// 
// Notice Regarding Standards.  AMD does not provide a license or sublicense to
// any Intellectual Property Rights relating to any standards, including but not
// limited to any audio and/or video codec technologies such as MPEG-2, MPEG-4;
// AVC/H.264; HEVC/H.265; AAC decode/FFMPEG; AAC encode/FFMPEG; VC-1; and MP3
// (collectively, the "Media Technologies"). For clarity, you will pay any
// royalties due for such third party technologies, which may include the Media
// Technologies that are owed as a result of AMD providing the Software to you.
// 
// MIT license 
// 
// Copyright (c) 2016 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//

#ifdef _WIN32
#include "DXApplication.h"
#endif
#include "OGLApplication.h"
#include "OCLApplication.h"
#include "Application.h"
#include "Settings.h"

#include <memory>

int main(int argc, char ** argv)
{
    Settings settings;
    if (!settings.Parse(argc, argv))
        return -1;

    // the application object needs to be declared before the 
    // graphics engine - on closing in some cases, the graphics
    // engine points to the Application object so the graphics
    // engine needs to be destroyed first
    Application  app(&settings);

    std::unique_ptr<IGraphicsEngine> graphicsEngine;
    switch (settings.ApiExt())
    {
#ifdef _WIN32
        case API_EXT_DX:
            graphicsEngine.reset(new DXApplication());
            break;
#endif
        case API_EXT_OPENCL:
            graphicsEngine.reset(new OCLApplication());
            break;
        case API_EXT_OPENGL:
        default:
            graphicsEngine.reset(new OGLApplication());
            break;
    }


    app.SetEngine(graphicsEngine.get());
    if (!app.Init(argc, argv))
    {
        app.Term();
        return -1;
    }

    app.Run();
    app.Term();

    return 0;
}
