// 
// Notice Regarding Standards.  AMD does not provide a license or sublicense to
// any Intellectual Property Rights relating to any standards, including but not
// limited to any audio and/or video codec technologies such as MPEG-2, MPEG-4;
// AVC/H.264; HEVC/H.265; AAC decode/FFMPEG; AAC encode/FFMPEG; VC-1; and MP3
// (collectively, the "Media Technologies"). For clarity, you will pay any
// royalties due for such third party technologies, which may include the Media
// Technologies that are owed as a result of AMD providing the Software to you.
// 
// MIT license 
// 
// Copyright (c) 2016 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//

#ifndef OGLAPPLICATION_H
#define OGLAPPLICATION_H
#pragma once

#include "Interfaces.h"

#include <GL/glew.h>
#include <GL/freeglut.h>

#include "../Include/OpenGL/glAmdGpuFileTransfer.h"

#include <vector>

class OGLApplication : 
    public IGraphicsEngine,
    public IGraphicsAPI,
    public IGraphicsAPIFrame,
    public IGraphicsAPI_P2P
{
public:
    OGLApplication();
    virtual ~OGLApplication();

protected:
    static OGLApplication * CurrentApp;

    IApplication* m_Application;
    ISettings*    m_Settings;
    bool          m_IsInteropUsed;

    int m_Width;
    int m_Height;
    
    bool m_Paused;
    bool m_IsFirstFrame;

    int m_NumBuffers;
    int m_readBuffer;
    int m_waitBuffer;
    
    GLint  m_TexBufferLocation;
    GLint  m_BufWidthLocation;
    GLint  m_BufHeightLocation;
    std::vector<GLuint> m_Buffers;
    std::vector<GLsync> m_SyncObject;
    static void Render();
    static void ProcessKeys(unsigned char key, int x, int y);
    static void Reshape(int w, int h);
    static void CloseWindow();
    GLuint CompileShader(GLenum type, const char * string);


    // general OpenGL extension support
    typedef void (GLAPIENTRY * PFNGLCREATEBUFFERSPROC) (GLsizei n, GLuint* buffers);
    typedef void (GLAPIENTRY * PFNGLNAMEDBUFFERSTORAGEPROC) (GLuint buffer, GLsizeiptr size, const void *data, GLbitfield flags);
#ifdef _WIN32
    typedef int  (WINAPI * PFNWGLGETSWAPINTERVALEXTPROC) (void);
    typedef bool (WINAPI * PFNWGLSWAPINTERVALEXTPROC) (int interval);

    PFNWGLGETSWAPINTERVALEXTPROC    wglGetSwapIntervalEXT;
#elif __linux__
    typedef void (GLAPIENTRY * PFNWGLSWAPINTERVALEXTPROC) (int interval);
#endif

    PFNGLCREATEBUFFERSPROC          glCreateBuffers;
    PFNGLNAMEDBUFFERSTORAGEPROC     glNamedBufferStorage;
    PFNWGLSWAPINTERVALEXTPROC       wglSwapIntervalEXT;

    bool  InitExtensions();

    PFNGLCREATEFILEAMDPROC          glCreateFileAMD;
    PFNGLRELEASEFILEAMDPROC         glReleaseFileAMD;
    PFNGLGETFILEPARAMETERI64VAMDPROC  glGetFileParameteri64vAMD;
    PFNGLREADFILEAMDPROC            glReadFileAMD;
    PFNGLWRITEFILEAMDPROC           glWriteFileAMD;
    bool  InitSsgExtensions();

    unsigned int    m_sectorSize;
    int64_t         m_SsgFileSize;
    GLFileHandleAMD m_OglSsgFileHandle;


    // display window
    int  m_Window;
    bool  InitWindow(int width, int height);

    // program
    GLuint m_Program;
    bool  InitProgram();

    // textures
    std::vector<GLuint> m_Textures;
    bool  InitTextures();

    // buffers
    int  m_DataSize;
    bool  InitBuffers(int dataBufferSize);


public:
    // IGraphicsAPI
    bool Init(IApplication *pAppliation, int argc, char ** argv);
    void Term();

    void Run();
    void Pause(bool pause);
    void Stop();
    void SetFullScreen(bool fullScreen);


    // IGraphicsAPIFrame
    void BeginFrame(bool clear);
    void DrawFrame();
    void DrawStatus(char * text);
    void DrawSeekbar(int frameNumber, int totalNumberOfFrames);
    void EndFrame();


    // IGraphicsAPI_P2P
    bool P2PIsExtensionActive();
    bool P2POpenFile(const char * filename);
    unsigned long long P2PGetFileSize();
    unsigned long long P2PGetSectorSize();
    bool P2PReadFile(unsigned long long fileOffset, unsigned long long size);
    void P2PCloseFile();
    bool IsFirstFrame() { return m_IsFirstFrame; }
};

#endif    /* OGLAPPLICATION_H */

