// 
// Notice Regarding Standards.  AMD does not provide a license or sublicense to
// any Intellectual Property Rights relating to any standards, including but not
// limited to any audio and/or video codec technologies such as MPEG-2, MPEG-4;
// AVC/H.264; HEVC/H.265; AAC decode/FFMPEG; AAC encode/FFMPEG; VC-1; and MP3
// (collectively, the "Media Technologies"). For clarity, you will pay any
// royalties due for such third party technologies, which may include the Media
// Technologies that are owed as a result of AMD providing the Software to you.
// 
// MIT license 
// 
// Copyright (c) 2016 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//

#ifndef _DXAPPLICATION_H
#define _DXAPPLICATION_H
#pragma once

#include <atlbase.h>
#include <atlcom.h>

#include <d3d11.h>
#include <d3dcompiler.h>

#include "Interfaces.h"

#include "FW1FontWrapper.h"
#include "../Include/DirectX11/AmdDxExtSSGApi.h"

#include <vector>


class DXApplication : 
    public IGraphicsEngine,
    public IGraphicsAPI,
    public IGraphicsAPIFrame,
    public IGraphicsAPI_P2P
{
public:
    DXApplication();
    virtual ~DXApplication();

protected:
    CComPtr<ID3D11Device>               m_Device;
    CComPtr<IDXGISwapChain>             m_SwapChain;
    CComPtr<ID3D11DeviceContext>        m_DeviceContext;
    CComPtr<ID3D11RenderTargetView>     m_RenderTargetView;
    CComPtr<ID3D11PixelShader>          m_PixelShader;
    CComPtr<ID3D11VertexShader>         m_VertexShader;
    CComPtr<ID3D11Buffer>               m_ConstantBuffer;
    CComPtr<ID3D11Query>                m_Query;

    std::vector<CComPtr<ID3D11ShaderResourceView> >   m_ShaderResourceView;
    std::vector<CComPtr<ID3D11Buffer> >               m_DataBuffer;

    // Windows specific
    LRESULT static WINAPI WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
    void TranslateCoordinates(int& x, int& y);
    void OnKey(int keyCode);
    void OnMouseDown(int x, int y);
    void OnMouseMove(int x, int y);
    void OnMouseUp(int x, int y);



    // display window
    HWND m_hWnd;
    bool InitWindow(int width, int height);
    
    // general DXX extension support
    IAmdDxExt* m_DxExt;
    HRESULT  InitExtensions();

    // Ssg extension
    IAmdDxExtSSG*                      m_DxSsgExt;
    UINT                               m_sectorSize;
    LARGE_INTEGER                      m_SsgFileSize;
    AmdDxSsgFileHandle                 m_hDxSsgFileHandle;
    std::vector<AmdDxSsgEventHandle>   m_hDxSsgEvent;
    HRESULT  InitDXXSsg();

    // Font wrapper
    CComPtr<IFW1FontWrapper> m_FontWrapper;
    bool  InitFontWrapper();

    // Init helper functions
    bool  GetMonitorRefreshRate(DXGI_RATIONAL& refreshRate);
    bool  LoadShader(UINT id, char** ppSource, LPDWORD pSize);
    bool  InitSwapChain(int width, int height);
    bool  InitRenderTargetView();
    bool  InitPixelShader();
    bool  InitVertexShader();
    bool  AllocateConstBuffer();
    bool  AllocateDataBuffer(int dataBufferSize);
    bool  InitShaderResourceView(int dataBufferSize);


    IApplication * m_Application;
    ISettings * m_Settings;

    bool m_Paused;
    bool m_displayText;
    bool m_IsFirstFrame;

    int m_NumBuffers;
    int m_readBuffer;
    int m_waitBuffer;

public:
    // IGraphicsAPI
    bool Init(IApplication* pApplication, int argc, char ** argv);
    void Term();

    void Run();
    void Pause(bool pause);
    void Stop();
    void SetFullScreen(bool fullScreen);


    // IGraphicsAPIFrame
    void BeginFrame(bool clear);
    void DrawFrame();
    void DrawStatus(char * text);
    void DrawSeekbar(int frameNumber, int totalNumberOfFrames);
    void EndFrame();


    // IGraphicsAPI_P2P
    bool P2PIsExtensionActive();
    bool P2POpenFile(const char * filename);
    unsigned long long P2PGetFileSize();
    unsigned long long P2PGetSectorSize();
    bool P2PReadFile(unsigned long long fileOffset, unsigned long long size);
    void P2PCloseFile();
    bool IsFirstFrame()           {  return m_IsFirstFrame;  }
};

#endif