
#include "stdafx.h"

#include <fstream>
#include <GL/glew.h>

#include "GLShader.h"
 
using namespace std;


GLShader::GLShader() : m_uiVertexShader(0), m_uiFragmentShader(0), m_uiProgram(0)
{
    m_strErrorMessage.clear();
}


GLShader::~GLShader()
{
    glUseProgram(0);

    glDeleteProgram(m_uiProgram);
}


bool GLShader::createVertexShaderFromFile(const char* pFileName)
{
    if (!createShaderFromFile(pFileName, GL_VERTEX_SHADER))
    {
        return false;
    }

    return true;
}


bool GLShader::createFragmentShaderFromFile(const char* pFileName)
{
    if (!createShaderFromFile(pFileName, GL_FRAGMENT_SHADER))
    {
        return false;
    }

    return true;
}



bool GLShader::buildProgram()
{
    if (!m_uiVertexShader || !m_uiFragmentShader)
    {
        return false;
    }

    if (m_uiProgram)
    {
        glDeleteProgram(m_uiProgram);
    }

    m_uiProgram = glCreateProgram();

    glAttachShader(m_uiProgram, m_uiVertexShader);
    glAttachShader(m_uiProgram, m_uiFragmentShader);

    glLinkProgram(m_uiProgram);

    int  nStatus;
    int  nLength;
    char cMessage[256];

    glGetProgramiv(m_uiProgram, GL_LINK_STATUS, &nStatus);

    if (nStatus != GL_TRUE)
    {
        glGetProgramInfoLog(m_uiProgram, 256, &nLength, cMessage);

        m_strErrorMessage = cMessage;

        return false;
    }

    return true;
}



bool GLShader::createShaderFromFile(const char* pFileName, unsigned int uiType)
{
    string strSource;
    unsigned int uiShader = 0;

    if (!readShaderSource(pFileName, strSource))
    {
        return false;
    }

    const char* pSource = strSource.c_str();

    if (uiType == GL_VERTEX_SHADER)
    {
        m_uiVertexShader = glCreateShader(GL_VERTEX_SHADER);

        uiShader = m_uiVertexShader;
    }
    else if (uiType == GL_FRAGMENT_SHADER)
    {
        m_uiFragmentShader = glCreateShader(GL_FRAGMENT_SHADER);

        uiShader = m_uiFragmentShader;
    }

    glShaderSource(uiShader, 1, &pSource, NULL);

    glCompileShader(uiShader);

    int  nStatus;
    int  nLength;
    char cMessage[256];

    glGetShaderiv(uiShader, GL_COMPILE_STATUS, &nStatus);

    if (nStatus != GL_TRUE)
    {
        glGetShaderInfoLog(uiShader, 256, &nLength, cMessage);

        m_strErrorMessage = cMessage;

        return false;
    }

    return true;
}


bool GLShader::readShaderSource(const char* pFileName, std::string &strSource)
{
    string		strLine;
	ifstream	ShaderFile(pFileName);

	if (!ShaderFile.is_open())
		return false;

	while(!ShaderFile.eof())
	{
		getline(ShaderFile, strLine);
		strSource += strLine;
        strSource += "\n";
	}
	
	return true;
}

