#pragma once

#include <GL/glew.h>


class GLShader;


class GLDOPPEngine
{
public:

    GLDOPPEngine();
    virtual ~GLDOPPEngine();

    bool                initDOPP(unsigned int uiDesktop = 1, bool bPresent = true);

    virtual bool        initEffect();
    virtual void        updateTexture();

    void                processDesktop();

    GLuint              getPresentTexture()     { return m_uiPresentTexture;    };
    GLuint              getPresentBuffer()      { return m_uiFBO;               };
    GLuint              getDesktopTexture()     { return m_uiDesktopTexture;    };    

    unsigned int        getDesktopWidth()       { return m_uiDesktopWidth;  };
    unsigned int        getDesktopHeight()      { return m_uiDesktopHeight; }; 

protected:

    void                createQuad();

    GLuint              m_uiDesktopTexture;
    GLuint              m_uiPresentTexture;

    GLuint              m_uiVertexBuffer;
    GLuint              m_uiVertexArray;

    GLShader*           m_pShader;
    GLuint              m_uiBaseMap;

    unsigned int        m_uiDesktopWidth;
    unsigned int        m_uiDesktopHeight; 

private:

    bool                setupDOPPExtension();

    GLuint              m_uiFBO;
    GLuint              m_uiDepthRB;

    bool                m_bStartPostProcessing;
    bool                m_bDoPresent;
};

