#include "StdAfx.h"
#include <GL/glew.h>
#include "GLShader.h"
#include "GLDOPPEdgeFilter.h"


GLDOPPEdgeFilter::GLDOPPEdgeFilter(void)
{
    m_pProgram = NULL;

    m_uiBasmapLoc = 0;
}


GLDOPPEdgeFilter::~GLDOPPEdgeFilter(void)
{
    if (m_pProgram)
    {
        delete m_pProgram;
    }
}



bool GLDOPPEdgeFilter::initEffect()
{
    if (m_pProgram)
    {
        delete m_pProgram;
    }

    m_pProgram = new GLShader;

    if ((!m_pProgram->createVertexShaderFromFile("base.vp")) || (!m_pProgram->createFragmentShaderFromFile("laplace.fp")))
    {
        return false;
    }

    if (!m_pProgram->buildProgram())
    {
        return false;
    }

    m_uiBasmapLoc = glGetUniformLocation(m_pProgram->getProgram(), "baseMap");

    createQuad();

    return true;
}


void GLDOPPEdgeFilter::updateTexture()
{
    glDisable(GL_DEPTH_TEST);

    m_pProgram->bind();

    glActiveTexture(GL_TEXTURE1);
    glBindTexture(GL_TEXTURE_2D, m_uiDesktopTexture);

    glUniform1i(m_uiBasmapLoc, 1);

    glBindVertexArray(m_uiVertexArray);
    glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
    glBindVertexArray(0);

    glEnable(GL_DEPTH_TEST);

    m_pProgram->unbind();
}