#include "StdAfx.h"
#include <GL/glew.h>

#include "GLShader.h"
#include "GLDOPPDistort.h"


GLDOPPDistort::GLDOPPDistort(void)
{
    m_pProgram = NULL;

    m_uiBasmapLoc = 0;
    m_uiTimerLoc  = 0;

    m_lStartCount = 0;

    QueryPerformanceFrequency((LARGE_INTEGER*)&m_lFreq);
}


GLDOPPDistort::~GLDOPPDistort(void)
{
    if (m_pProgram)
    {
        delete m_pProgram;
    }
}



bool GLDOPPDistort::initEffect()
{
    if (m_pProgram)
    {
        delete m_pProgram;
    }

    m_pProgram = new GLShader;

    if ((!m_pProgram->createVertexShaderFromFile("base.vp")) || (!m_pProgram->createFragmentShaderFromFile("distort.fp")))
    {
        return false;
    }

    if (!m_pProgram->buildProgram())
    {
        return false;
    }

    m_uiBasmapLoc = glGetUniformLocation(m_pProgram->getProgram(), "baseMap");
    m_uiTimerLoc  = glGetUniformLocation(m_pProgram->getProgram(), "fTime");

    createQuad();

    QueryPerformanceCounter((LARGE_INTEGER*) &m_lStartCount);

    return true;
}


void GLDOPPDistort::updateTexture()
{
    long long lCounter;
    float fElapsed;

    QueryPerformanceCounter((LARGE_INTEGER*) &lCounter);

    long long lDelta = lCounter - m_lStartCount;

    fElapsed = ((float)lDelta/(float)m_lFreq);

    glDisable(GL_DEPTH_TEST);

    m_pProgram->bind();

    glActiveTexture(GL_TEXTURE1);
    glBindTexture(GL_TEXTURE_2D, m_uiDesktopTexture);

    glUniform1i(m_uiBasmapLoc, 1);
    glUniform1f(m_uiTimerLoc, fElapsed);

    glBindVertexArray(m_uiVertexArray);
    glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
    glBindVertexArray(0);

    glEnable(GL_DEPTH_TEST);

    m_pProgram->unbind();
}
