// DOPPRotationDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DOPPEngine.h"
#include "DOPPRotationDlg.h"
#include "afxdialogex.h"




IMPLEMENT_DYNAMIC(DOPPRotationDlg, CDialogEx)

DOPPRotationDlg::DOPPRotationDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(DOPPRotationDlg::IDD, pParent)
{
    m_pSlider       = NULL;
    m_pSliderValue  = NULL;

    m_uiAngle       = 0;
}

DOPPRotationDlg::~DOPPRotationDlg()
{
}

void DOPPRotationDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(DOPPRotationDlg, CDialogEx)
    ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_ANGLE, &DOPPRotationDlg::OnNMCustomdrawSliderAngle)
    ON_BN_CLICKED(IDOK, &DOPPRotationDlg::OnBnClickedOk)
    ON_BN_CLICKED(IDCANCLE, &DOPPRotationDlg::OnBnClickedCancle)
END_MESSAGE_MAP()




void DOPPRotationDlg::OnNMCustomdrawSliderAngle(NMHDR *pNMHDR, LRESULT *pResult)
{
    m_uiAngle = m_pSlider->GetPos();

    char buf[8];

    sprintf_s(buf," %d", m_uiAngle);

    m_pSliderValue->SetWindowTextW(CA2CT(buf));
}



BOOL DOPPRotationDlg::OnInitDialog()
{
    m_pSlider = static_cast<CSliderCtrl*>(GetDlgItem(IDC_SLIDER_ANGLE));

    m_pSliderValue = static_cast<CEdit*>(GetDlgItem(IDC_EDIT_VALUE));

    if (!m_pSlider || !m_pSliderValue)
    {
        return false;
    }

    m_pSlider->SetRange(0, 360, false);

    return true;
}


void DOPPRotationDlg::OnBnClickedOk()
{
    CDialogEx::OnOK();
}


void DOPPRotationDlg::OnBnClickedCancle()
{
    CDialogEx::OnCancel();
}



