#pragma once
#include <string>

class GLShader
{
public:

    GLShader();
    virtual ~GLShader();

    bool    createVertexShaderFromFile(const char* pFileName);
    bool    createFragmentShaderFromFile(const char* pFileName);

    bool    buildProgram();

    void    bind()                      { glUseProgram(m_uiProgram); };
    void    unbind()                    { glUseProgram(0);           };

    unsigned int    getProgram()        { return m_uiProgram; };
    const char*     getErrorMessage()   { return m_strErrorMessage.c_str(); };  

private:

    bool            readShaderSource(const char* pFileName, std::string &strSource);
    bool            createShaderFromFile(const char* pFileName, unsigned int uiType);

    unsigned int    m_uiVertexShader;
    unsigned int    m_uiFragmentShader;
    unsigned int    m_uiProgram;

    std::string     m_strErrorMessage;

};