
#include "StdAfx.h"

#define _USE_MATH_DEFINES

#include <math.h>

#include <GL/glew.h>
#include "GLShader.h"
#include "GLDOPPRotate.h"



GLDOPPRotate::GLDOPPRotate(void)
{
    m_pProgram = NULL;

    m_uiBasmapLoc = 0;


    // Init model view
    memset(m_pModelViewMat, 0, 16 * sizeof(float));
    
    m_pModelViewMat[0]  = 1.0f;      // [0][0]
    m_pModelViewMat[5]  = 1.0f;      // [1][1]
    m_pModelViewMat[10] = 1.0f;      // [1][1]
    m_pModelViewMat[15] = 1.0f;      // [1][1]

    // Init ortho projection matrix as identity
    memset(m_pProjectionMat, 0, 16 * sizeof(float));

    m_pProjectionMat[0]  = 1.0f;
    m_pProjectionMat[5]  = 1.0f;
    m_pProjectionMat[10] = 1.0f;
    m_pProjectionMat[15] = 1.0f;
}


GLDOPPRotate::~GLDOPPRotate(void)
{
    if (m_pProgram)
    {
        delete m_pProgram;
    }

    if (m_uiTransform)
    {
        glDeleteBuffers(1, &m_uiTransform);
    }
}



bool GLDOPPRotate::initEffect()
{
    if (m_pProgram)
    {
        delete m_pProgram;
    }

    m_pProgram = new GLShader;

    if ((!m_pProgram->createVertexShaderFromFile("transform.vp")) || (!m_pProgram->createFragmentShaderFromFile("base.fp")))
    {
        return false;
    }

    if (!m_pProgram->buildProgram())
    {
        return false;
    }

    m_uiBasmapLoc = glGetUniformLocation(m_pProgram->getProgram(), "baseMap");

    // create UBO to pass tarnsformation matrix
    glGenBuffers(1, &m_uiTransform);

    glBindBuffer(GL_UNIFORM_BUFFER, m_uiTransform);

    glBufferData(GL_UNIFORM_BUFFER, 32 * sizeof(float), m_pModelViewMat, GL_STATIC_DRAW);

    glBufferSubData(GL_UNIFORM_BUFFER, 16 * sizeof(float), 16 * sizeof(float), m_pProjectionMat);

    glBindBuffer(GL_UNIFORM_BUFFER, 0);

    createQuad();

    return true;
}


void GLDOPPRotate::setRotation(float a)
{
    float r = ((float)M_PI * a) / 180.0f; 

    float ar = (float)m_uiDesktopWidth / (float)m_uiDesktopHeight;

    glBindBuffer(GL_UNIFORM_BUFFER, m_uiTransform);

    float* pMat = (float*)glMapBufferRange(GL_UNIFORM_BUFFER, 0, 32 * sizeof(float), GL_MAP_WRITE_BIT  | GL_MAP_UNSYNCHRONIZED_BIT);

    if (pMat)
    {
        // Build rotation matrix to rotate quad around z axis and scale y to
        // have a quad that matched the AR of the desktop texture
        pMat[0] =  cosf(r);
        pMat[1] = -sinf(r) ;

        pMat[4] =  sinf(r) / ar;
        pMat[5] =  cosf(r) / ar;  

        // Build otho projection matrix (glOrtho(-1.0f, 1.0f, -1.0f/ar, 1.0f/ar, -1.0f, 1.0f))
        // Only Orth[1][1] need to be updated. The ortho frustum needs to match the AR of the desktop
        pMat[21] = ar;
    }

    glUnmapBuffer(GL_UNIFORM_BUFFER);

    glBindBuffer(GL_UNIFORM_BUFFER, 0);
}


void GLDOPPRotate::updateTexture()
{
    glDisable(GL_DEPTH_TEST);

    glBindBufferBase(GL_UNIFORM_BUFFER, 0, m_uiTransform);

    m_pProgram->bind();

    glActiveTexture(GL_TEXTURE1);
    glBindTexture(GL_TEXTURE_2D, m_uiDesktopTexture);

    glUniform1i(m_uiBasmapLoc, 1);

    glBindVertexArray(m_uiVertexArray);
    glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
    glBindVertexArray(0);

    glEnable(GL_DEPTH_TEST);

    m_pProgram->unbind();
}
