
#pragma once

#include <vector>

struct DisplayData;

class DisplayManager
{
public:

    DisplayManager();
    ~DisplayManager();

    // Enumerates the active desktops.This functions needs to be called before any other method of this class
    // return: The number of active desktops
    unsigned int enumDisplays();
    
    // returns the number of GPUs in the system
    unsigned int    getNumGPUs();

    unsigned int    getNumDisplays();

    // returns the number of displays mapped on GPU uiGPU
    unsigned int    getNumDisplaysOnGPU(unsigned int uiGPU);
    
    // returns the DisplayID of n-th Display on GPU uiGPU
    // n=0 will return the first display on GPU uiGPU if available
    // n=1 will return the second display on GPU uiGPU if available ...
    unsigned int    getDisplayOnGPU(unsigned int uiGPU, unsigned int n=0);

    const char*     getDisplayName(unsigned int uiDisplay);

    unsigned int    getGpuId(unsigned int uiDisplay);    

    bool            getOrigin(unsigned int uiDisplay, int &uiOriginX, int &uiOriginY);

    bool            getSize(unsigned int uiDisplay, unsigned int &uiWidth, unsigned int &uiHeight);

private:

    bool            setupADL();
    void            deleteDisplays();

    unsigned int                m_uiNumGPU;
    
    std::vector<DisplayData* >  m_Displays;
};