
// DOPPEngineDlg.h : header file
//

#pragma once


class DisplayManager;
class DOPPRotationDlg;


// CDOPPEngineDlg dialog
class CDOPPEngineDlg : public CDialogEx
{
// Construction
public:
	CDOPPEngineDlg(CWnd* pParent = NULL);	// standard constructor
    ~CDOPPEngineDlg();

    // Dialog Data
	enum { IDD = IDD_DOPPENGINE_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support


// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL        OnInitDialog();
	afx_msg void        OnPaint();
    afx_msg void        OnSize(UINT nType, int cx, int cy);
	afx_msg HCURSOR     OnQueryDragIcon();
    afx_msg void        OnStart();
    afx_msg void        OnStop();
    afx_msg void        OnExit();

	DECLARE_MESSAGE_MAP()

private:

    enum EffectId { NO_EFFECT, COLOR_INVERT, EDGE_FILTER, DISTORT_EFFECT, ROTATE_DESKTOP };

    bool                createGLWindow();
    void                showWindow();
    void                deleteWindow();

    static DWORD        threadFunction(void* pData);
    DWORD               threadLoop();

    DWORD               m_dwThreadId;
    bool                m_bEngineRunning;
    HANDLE              m_hEngineThread;
    
    HWND                m_hWnd; 
    HDC                 m_hDC;
    HGLRC               m_hCtx;

    unsigned int        m_uiEffectSelection;
    unsigned int        m_uiDesktopSelection;
    unsigned int        m_uiRotationAngle;

    CComboBox*          m_pEffectComboBox;
    CComboBox*          m_pDesktopComboBox;
    CButton*            m_pShowWinCheckBox;

    DisplayManager*     m_pDisplayManager;

    DOPPRotationDlg*    m_pRotationDlg;

public:
    afx_msg void OnBnClickedCheckWindow();
};
