//=====================================================================
// Copyright (c) 2013-2018 Advanced Micro Devices, Inc. All rights reserved.
//
/// \author GPU Developer Tools
/// \file
/// \brief String Constants used by the GPU Profiler
//=============================================================

#ifndef __GPSTRINGCONSTANTS_H
#define __GPSTRINGCONSTANTS_H

#define GP_Str_ProfileSessionGPUPrefix "GPU: "
#define GP_Str_ProfileSessionHTMLHeading L"GPU Profile Session"
#define GP_Str_HSA "HSA"
#define GP_Str_CL "CL"
#define GP_Str_LocalHost "Local host"

// Session views names
#define GP_Str_PerfCountersViewName "Performance Counter View"
#define GP_Str_AppTraceViewName "Application Trace View"
#define GP_Str_OccupancyViewName "Kernel Occupancy Viewer"
#define GP_Str_OccupancyCodeViewerName "Code Viewer"
#define GP_Str_OccupancyWindowCaption "Kernel Occupancy (%1)"

/// Atp file properties
#define GP_Str_ATPPropertyDisplayName "DisplayName"

// Counter selection settings
#define GP_Str_CounterSelectionMainCaptionGeneral "General"
#define GP_Str_CounterSelectionPreformanceCountersSelection "Performance Counters Selection"
#define GP_Str_CounterSelectionProfileSpecificKernels "Profile Specific Kernels"
#define GP_Str_CounterSelectionAdvancedOptions   "Advanced Options"
#define GP_Str_CounterSelectionLoadSelection "Load Selection"
#define GP_Str_CounterSelectionSaveSelection "Save Selection"
#define GP_Str_CounterSelectionGenerateOccupancyDetails "Generate occupancy information for each OpenCL or HSA kernel profiled"
#define GP_str_GpuTimeCoolect "Measure kernel execution time (requires an additional pass)"
#define GP_str_GpuTimeToolTip "Perform 1 additional pass to measure the kernel execution time with high precision."
#define GP_str_CollectingMultiCountersLabel "Collecting Multiple performance counters may require executing the kernel more than once. If multiple passes are required, the profiler \nstores the OpenCL read/write buffers prior to kernel execution and restores them afterwards."
#define GP_str_MultiPassNote "      Note: Profiling OpenCL kernels that take Shared Virtual Memory pointers or pipes as arguments is disabled during multi-pass collection"
#define GP_str_PerfCounterNotAvailable "GPU Performance Counters are not available on the host platform. GPU Performance Counters are available only for AMD devices with a Catalyst driver installed"
#define GP_str_ProfileSpecificKernelsDesc  "Profile only these kernels (names are case-sensitive, separated by semi-colons). \nLeave empty to profile all kernels."
#define GP_Str_CounterSelectionAPITypeDesc "Collect counters for:"
#define GP_Str_CounterSelectionXInitThreadsDesc "Init the threading support before beginning a profile. Applicable only to multi-threaded applications."
#define GP_Str_CounterSelectionHSAPassesWarning "You selected a counter combination that requires %1 passes. Only a single pass can be used to collect HSA counters. Some counters will be removed from the selection."

// Performance counters data view
#define GP_Str_CountersDataSummaryAPICalls "# of API calls %1"
#define GP_Str_CountersDataSummaryDrawCalls "# of Draw calls %1"
#define GP_Str_CountersDataSummaryCpuTime "CPU Time: %1"
#define GP_Str_CountersDataSummaryGpuTime "GPU Time: %1"
#define GP_Str_CountersDataSummaryCpuTimePercentageDrawCalls "% CPU time in draw calls %1"
#define GP_Str_CountersDataSummaryGpuBusy "% GPU busy %1"

// Error and status messages
#define GP_Str_ErrorUnableToDelete "Unable to delete"
#define GP_Str_ErrorInsufficientMemory "Insufficient memory"
#define GP_Str_ErrorUnableToLoad "Unable to load %1."
#define GP_Str_ErrorWhileLoadingSession "Failed to load the session data"
#define GP_Str_MessageDeleted "Deleted"

// Application trace settings
#define GP_Str_ProjectSettingsMainCaption       "Application Timeline Trace"
#define GP_Str_ProjectSettingsOpenCLTraceOptions "OpenCL Trace Options"
#define GP_Str_ProjectSettingsAPITraceOptions   "API Trace Options"
#define GP_Str_AppTraceAPIToTrace               "API to trace"
#define GP_Str_AppTraceCollpase                 "Collapse consecutive identical clGetEventInfo calls"
#define GP_Str_AppTraceEnableNavigation         "Enable navigation to source code (high overhead)"
#define GP_Str_AppTraceAlwaysShowAPIErrorCodes  "Always show API error codes"
#define GP_Str_AppTraceGenerateSummary          "Generate summary pages"
#define GP_Str_AppTraceMaxAPI                   "Maximum number of APIs to trace:"
#define GP_Str_AppTraceWriteTraceData           "Write trace data in intervals during program execution (ms):"
#define GP_Str_AppTraceTraceDataInterval        "Interval at which to write trace data during program execution (ms):"
#define GP_Str_MarkersFileExtension             "clperfmarker"
#define GP_Str_NewerTraceSession                "This Application Trace session was generated by a newer version of CodeXL. Please update to a newer version of CodeXL to view this session."
#define GP_Str_InvalidDebugInfo                 "This may be caused by a lack of or invalid debugging information."
#define GP_Str_AppTerminatedUnexpectedly        "\n\nThis may also occur if the application terminated unexpectedly before the profiler wrote out any symbol information.\n%1"
#define GP_Str_NoSourceInfoForSelectedAPI       "No source information is available for the selected API.\n\n%1"
#define GP_Str_CantAccessSourceForSelectedAPI   "Unable to go to source for the selected API\n\nFile not found: %1"
#define GP_Str_AppMadeNoCallsToEnabledAPI       "\n\nIt is possible that the application did not call any of the APIs enabled in the \"%1\" option on the \"%2\" project setting page.\nTry enabling more (or all) APIs and profiling the application again."
#define GP_Str_UnableToLoadTimelineData         "Unable to load timeline data. %1"
#define GP_Str_ProjectSettingsOpenCLAPI         "OpenCL"
#define GP_Str_ProjectSettingsHSAAPI            "HSA"
#define GP_Str_ProjectSettingsAPITypeDesc       "Profile applications that use:"
#define GP_Str_ProjectSettingsOpenCLAPITooltip  "Profile applications that use OpenCL"
#define GP_Str_ProjectSettingsHSAAPITooltip     "Profile applications that use HSA-enabled languages (HCC, HIP, etc.). Currently available only on Linux"


#define GP_Str_ProjectSettingsAllCLRulesItemName "All OpenCL Rules"
#define GP_Str_ProjectSettingsAllHSARulesItemName "All HSA Rules"
#define GP_Str_ProjectSettingsAllCLAPIsItemName "All OpenCL APIs"
#define GP_Str_ProjectSettingsAllHSAAPIsItemName "All HSA APIs"

#define GP_profileTypePerformanceCountersWithPrefix         "GPU: Performance Counters"
#define GP_profileTypeApplicationTraceWithPrefix            "Application Timeline Trace"
#define GP_profileTypePerformanceCountersPrefix             L"GPU: "

#define GPU_str_profileTypePerformanceCounters               "Performance Counters"
#define GPU_str_profileTypeApplicationTrace                 "Application Timeline Trace"

#define GPU_STR_COUNTER_PROJECT_SETTINGS                    L"GPUPerformanceCounters"
#define GPU_STR_COUNTER_PROJECT_SETTINGS_DISPLAY            L"GPU Profile: Performance Counters"
#define GPU_STR_COUNTER_PROJECT_SETTINGS_TAB_NAME           L"GPU Pro&file: Performance Counters"
#define GPU_STR_APP_TRACE_PROJECT_TREE_PATH_STR             L"Profile, Application Timeline Trace"
#define GPU_STR_TRACE_PROJECT_SETTINGS                      L"OpenCLAppTrace"
#define GPU_STR_TRACE_PROJECT_SETTINGS_DISPLAY              L"GPU Profile: Application Trace"
#define GPU_STR_TRACE_PROJECT_TREE_PATH_STR                 L"Profile, GPU Profile: Perf. Counters"
#define GPU_NARROW_STR_TRACE_PROJECT_SETTINGS_DISPLAY       "Application Timeline Trace"
#define GPU_NARROW_STR_COUNTER_PROJECT_SETTINGS_DISPLAY     "GPU Profile: Perf. Counters"
#define GPU_STR_TRACE_PROJECT_SETTINGS_TAB_NAME             L"GPU Profile: Application &Trace"
#define GPU_STR_GENERAL_SETTINGS                            L"GPUProfiler"
#define GPU_STR_GENERAL_SETTINGS_DISPLAY                    L"GPU Profile"
#define GPU_STR_STARTING_REMOTE_SESSION                     L"GPU Profile: Attempting to connect to the remote agent..."
#define GPU_STR_REMOTE_HANDSHAKE_FALIURE                    L"Failed executing the handshake with the agent."
#define GPU_STR_REMOTE_HANDSHAKE_UNKNOWN_FAILURE            L"Unknown error on handshake with remote agent."
#define GPU_STR_REMOTE_TARGET_APP_NOT_FOUND                 "The target application does not exist on the remote machine. Session is aborted."
#define GPU_STR_PORT_NNN                                    L"PORT_NNNN"
#define GPU_STR_REMOTE_TARGET_APP_PORT_OCCUPIED             L"Session aborted - the CodeXL graphics server requires port " GPU_STR_PORT_NNN L" but it is already in use by another application.\nPlease close the application that acquired this port or use the CodeXL project settings to specify a different port number"

#define GPU_STR_REMOTE_TARGET_APP_ALREADY_RUNNING           "Session aborted. It is not possible to run 2 frame analysis sessions concurrently on the same host. Please stop the first session and run again."
#define GPU_STR_REMOTE_AGENT_VERSION_NOT_RETRIEVED          L"Unable to retrieve CodeXL version of CodeXL Remote Agent."
#define GPU_STR_REMOTE_AGENT_INIT_FAILURE                   L"Failed to initialize CodeXL Remote Agent."
#define GPU_STR_REMOTE_AGENT_INIT_FAILURE_WITH_CTX          L"Failed to initialize CodeXL Remote Agent from GPU profiling context."
#define GPU_STR_REMOTE_SESSION_TERMINATION_FAILURE_WITH_CTX L"Unable to terminate the whole remote session (from GPU profiling context)."
#define GPU_STR_REMOTE_SESSION_TERMINATION_FAILURE          L"Failed to terminate the current seession before another attempt."
#define GPU_STR_REMOTE_CONNECTION_FAILURE                   L"Unable to connect to CodeXL Remote Agent.\nPlease verify that:\n1. CodeXL and CodeXL Remote Agent are not blocked by a firewall.\n2. The given IP address and ports are valid, and the remote machine is accessible from the local machine.\n3. CodeXL Remote Agent is running on the remote machine."
#define GPU_STR_LOCAL_REMOTE_CONNECTION_FAILURE             L"Unable to establish a connection with the CodeXL Remote Agent.\nPlease verify that firewall settings allow CodeXL and CodeXLRemoteAgent to communicate over the network, even for local scenarios."

#define GPU_STR_REMOTE_COMMUNICATION_FAILURE                L"Communication failure: Please verify that both client and remote machines are connected to the network."
#define GPU_STR_REMOTE_PROFILE_IN_PROGRESS_PREFIX           L"Remote GPU profile in progress on "
#define GPU_STR_REMOTE_PROFILING_TASK_THREAD_NAME           L"AsyncProgressUpdater"

/// String constants for the project settings XML:
#define GPU_STR_ProjectSettingsGenerateOccupancy L"GenerateOccupancyInfo"
#define GPU_STR_ProjectSettingsShowErrorCode L"AlwaysShowAPIErrorCode"
#define GPU_STR_ProjectSettingsCollapseClGetEventInfo L"CollapseAllclGetEventInfoCalls"
#define GPU_STR_ProjectSettingsEnableNavigation L"EnableNavigationToSourceCode"
#define GPU_STR_ProjectSettingsGenerateSummaryPage L"GenerateSummaryPage"
#define GPU_STR_ProjectSettingsAPIsToFilter L"APIsToTrace"
#define GPU_STR_ProjectSettingsMaxAPIs L"MaximumNumberOfAPIs"
#define GPU_STR_ProjectSettingsRulesTree L"RuleTree"
#define GPU_STR_ProjectSettingsAPIsFilterTree L"APIsFilterTree"
#define GPU_STR_ProjectSettingsWriteDataTimeOut L"WriteDataTimeOut"
#define GPU_STR_ProjectSettingsTimeOutInterval L"TimeOutInterval"
#define GPU_STR_ProjectSettingsNumberOfCountersSelected L"NumberOfCountersSelected"
#define GPU_STR_ProjectSettingsLoadSelection L"LoadSelection"
#define GPU_STR_ProjectSettingsSaveSelection L"SaveSelection"
#define GPU_STR_ProjectSettingsCounterTree L"CounterTree"
#define GPU_STR_ProjectSettingsGpuTimeCollect L"GpuTimeCollect"
#define GPU_STR_ProjectSettingsCallXInitThreads L"CallXInitThreads"
#define GPU_STR_ProjectSettingsSpecificKernels L"ProfileSpecificKernels"
#define GPU_STR_ProjectSettingsIsRemoteSession L"IsRemoteSession"
#define GPU_STR_ProjectSettingsAPIType L"APIType"
#define GPU_STR_ProjectSettingsAPITypeOpenCL L"OpenCL"
#define GPU_STR_ProjectSettingsAPITypeHSA L"HSA"

#define GPU_STR_ProjectSettingsSpecificKernelErrMsg L"Profile Specific Kernels contains invalid characters.\nKernel name should consist of characters, digits and underscore and can not start with a digit.\nKernels should also be semi-colon delimited."

// Project settings rules strings:
#define GPU_STR_ProjectSettingsRulesWarnings "Warnings"
#define GPU_STR_ProjectSettingsRulesErrors "Errors"
#define GPU_STR_ProjectSettingsRulesBestPractices "Best Practices"


#define GPU_STR_ProjectSettingsRulesWarning1Name "RefTracker"
#define GPU_STR_ProjectSettingsRulesWarning1DisplayName "Detect resource leaks"
#define GPU_STR_ProjectSettingsRulesWarning1Description "Track the reference count for all OpenCL objects, and report any objects which are never released."

#define GPU_STR_ProjectSettingsRulesBestPractice1Name "BlockingWrite"
#define GPU_STR_ProjectSettingsRulesBestPractice1DisplayName "Detect unnecessary blocking writes"
#define GPU_STR_ProjectSettingsRulesBestPractice1Description "Detect unnecessary blocking write operations."

#define GPU_STR_ProjectSettingsRulesBestPractice2Name "BadWorkGroupSize"
#define GPU_STR_ProjectSettingsRulesBestPractice2DisplayName "Detect non-optimized work size"
#define GPU_STR_ProjectSettingsRulesBestPractice2Description "Detect clEnqueueNDRangeKernel calls which specify a global or local workgroup size which is non-optimal for AMD Hardware."

#define GPU_STR_ProjectSettingsRulesError1Name "RetCodeAnalyzer"
#define GPU_STR_ProjectSettingsRulesError1DisplayName "Detect failed API calls"
#define GPU_STR_ProjectSettingsRulesError1Description "Detect OpenCL API calls that do not return CL_SUCCESS.\n Some of the return codes may not be detected unless \"Always show API error codes\" option is checked."

#define GPU_STR_ProjectSettingsRulesBestPractice3Name "DataTransferAnalyzer"
#define GPU_STR_ProjectSettingsRulesBestPractice3DisplayName "Detect non-optimized data transfer"
#define GPU_STR_ProjectSettingsRulesBestPractice3Description "1. Detect Non-Fusion APU access to Device-Visible Host Memory directly.\n2. Detect Host-Visible Device Memory read back to CPU directly."

#define GPU_STR_ProjectSettingsRulesBestPractice4Name "SyncAnalyzer"
#define GPU_STR_ProjectSettingsRulesBestPractice4DisplayName "Detect redundant synchronization"
#define GPU_STR_ProjectSettingsRulesBestPractice4Description "Detect redundant synchronization which results in low host and device utilization."

#define GPU_STR_ProjectSettingsRulesWarning2Name "DeprecatedFunctionAnalyzer"
#define GPU_STR_ProjectSettingsRulesWarning2DisplayName "Detect deprecated API calls"
#define GPU_STR_ProjectSettingsRulesWarning2Description "Detect calls to OpenCL API functions that have been deprecated in recent versions of OpenCL"

// String constants for the GeneratedFileHeader namespace
#define GPU_STR_FileHeader_ProfileFileVersion   "ProfileFileVersion"
#define GPU_STR_FileHeader_TraceFileVersion     "TraceFileVersion"
#define GPU_STR_FileHeader_ProfilerVersion      "ProfilerVersion"
#define GPU_STR_FileHeader_GpSessionVersion     "GpSessionVersion"
#define GPU_STR_FileHeader_Application          "Application"
#define GPU_STR_FileHeader_ApplicationArgs      "ApplicationArgs"
#define GPU_STR_FileHeader_UserTimer            "UserTimer"
#define GPU_STR_FileHeader_PlatformVendor       "Platform Vendor"
#define GPU_STR_FileHeader_PlatformName         "Platform Name"
#define GPU_STR_FileHeader_PlatformVersion      "Platform Version"
#define GPU_STR_FileHeader_CLDriverVersion      "CLDriver Version"
#define GPU_STR_FileHeader_CLRuntimeVersion     "CLRuntime Version"
#define GPU_STR_FileHeader_NumberAppAddressBits "NumberAppAddressBits"
#define GPU_STR_FileHeader_OSVersion            "OS Version"
#define GPU_STR_FileHeader_BoardName            "Board Name"
#define GPU_STR_FileHeader_PCIEDeviceId         "PCIE device id"

// Trace View:
#define GPU_STR_TraceViewclGetEventInfo "clGetEventInfo"
#define GPU_STR_TraceViewHostThreadBranchName "Host Thread %1"
#define GPU_STR_TraceViewSummary "Summary"
#define GPU_STR_TraceViewGoToSource "Go to &source code"
#define GPU_STR_TraceViewZoomTimeline "&Show in timeline"
#define GPU_STR_TraceViewExpandAll "&Expand all"
#define GPU_STR_TraceViewCollapseAll "Co&llapse all"
#define GPU_STR_TraceViewCpuDevice "CPU_Device"
#define GPU_STR_TraceViewOpenCL "OpenCL"
#define GPU_STR_TraceViewHSA "HSA"
#define GPU_STR_TraceViewHSADataTransfers "Data Transfers"
#define GPU_STR_TraceViewHSAPerfMarker "HSAPerfMarker"
#define GPU_STR_TraceViewQueueRow "Queue %1 - %2 (%3)"
#define GPU_STR_HSATraceViewQueueRow "Queue %1 - Device %2 (%3)"

// Trace table captions
#define GP_STR_TraceTableColumnIndex "Index"
#define GP_STR_TraceTableColumnInterface "Interface"
#define GP_STR_TraceTableColumnCommandList "CmdList #"
#define GP_STR_TraceTableColumnCommandBuffer "CmdBuffer #"
#define GP_STR_TraceTableColumnCall "Call"
#define GP_STR_TraceTableColumnParameters "Parameters"
#define GP_STR_TraceTableColumnResult "Result"
#define GP_STR_TraceTableColumnDeviceBlock "Device Block"
#define GP_STR_TraceTableColumnKernelOccupancy "Kernel Occupancy"
#define GP_STR_TraceTableColumnCPUTime "CPU Time"
#define GP_STR_TraceTableColumnGPUTime "GPU Time"
#define GP_STR_TraceTableColumnDeviceTime "Device Time"
#define GP_STR_TraceTableColumnStartTime "Start Time"
#define GP_STR_TraceTableColumnEndTime "End Time"

/// Progress messages
#define GPU_STR_TraceViewLoadingTraceProgress L"Loading trace data..."
#define GPU_STR_TraceViewLoadingTraceTableItemsProgress L"Loading items..."
#define GPU_STR_TraceViewLoadingOccupancyProgress L"Loading occupancy data..."
#define GPU_STR_TraceViewLoadingAPITimelineItems L"Loading API items to timeline..."
#define GPU_STR_TraceViewLoadingGPUTimelineItems L"Loading GPU items to timeline..."
#define GPU_STR_TraceViewLoadingPerfMarkersTimelineItems L"Loading Performance Markers to timeline..."

// Profile Manager error messages
#define GPU_STR_ERR_NoCountersSelected "Unable to profile. At least one counter needs to be selected.\nCounter selection can be modified in the Project Settings dialog."
#define GPU_STR_ERR_FileNotSpecified   "Unable to profile.  No %1 file specified"
#define GPU_STR_ERR_InvalidExecutable  "Unable to profile. The specified executable is not a valid %1 file: \n%2"
#define GPU_STR_ERR_FileMissing        "Unable to profile. The specified %1 does not exist: \n%2"

// User messages:
#define GPU_STR_APICallsAmountExceedsTheLimitQuestion "The session contains more than %1 API calls.\n" \
    "Do you want to analyze only the first %1 API calls (recommended for performance reasons)?\n Selecting 'No' will analyze all API calls."

/// CSV export file names:
#define GPU_CSV_FileNameFormat "CodeXL%1_%2"
#define GPU_CSV_FileNameErrorsWarnings "ErrorsWarnings"
#define GPU_CSV_FileNameAPISummary "APISummary"
#define GPU_CSV_FileNameContextSummary "ContextSummary"
#define GPU_CSV_FileNameTop10KernelSummary "Top10KernelSummary"
#define GPU_CSV_FileNameKernelSummary "KernelSummary"
#define GPU_CSV_FileNameTop10DataSummary "Top10DataSummary"
#define GPU_CSV_FileNameTraceView "Trace"
#define GPU_RulesFullFileName "Rules.rls"
#define GPU_PerformanceCountersFullFileName ".CounterFile.csl"
#define GPU_RulesFileName L"Rules"
#define GPU_SummaryFileName L"*Summary.html"
#define GPU_APISummaryFileName L"*APISummary.html"
#define GPU_HSAAPISummaryFileName L"*HSAAPISummary.html"
#define GPU_CLAPISummaryFileName L"*CLAPISummary.html"
#define GPU_ContextSummaryFileName L"*ContextSummary.html"
#define GPU_KernelSummaryFileName L"*KernelSummary.html"
#define GPU_Top10DataTransferSummaryFileName L"*Top10DataTransferSummary.html"
#define GPU_Top10KernelSummaryFileName L"*Top10KernelSummary.html"
#define GPU_BestPracticesFileName L"*BestPractices.html"

/// GPU Profile file extensions
#define GP_CSV_FileExtension ".csv"
#define GP_ATP_FileExtension ".atp"
#define GP_HTML_FileExtension ".html"
#define GP_Occupancy_FileExtension ".occupancy"
#define GP_CSV_FileExtensionW L"csv"
#define GP_ATP_FileExtensionW L"atp"
#define GP_HTML_FileExtensionW L"html"
#define GP_Occupancy_FileExtensionW L"occupancy"

// Process Monitor Types
#define GPU_STR_ProcessMonitorRunType_Profile L"GPU profile in progress"
#define GPU_STR_ProcessMonitorRunType_GenSummary L"Generating Summary Pages"
#define GPU_STR_ProcessMonitorRunType_GenOccupancy L"Generating Occupancy Page"

// Timeline strings
#define GPU_STR_timeline_CPU_ThreadBranchName "Thread %1"
#define GPU_STR_timeline_OtherEnqueueBranchName "Other Enqueue Operations"
#define GPU_STR_timeline_UnknownQueueBranchName "<UnknownQueue>"
#define GPU_STR_timeline_QueueBranchNameWithParam "Queue (%1) - %2"
#define GPU_STR_timeline_QueueBranchNameWithParam "Queue (%1) - %2"
#define GPU_STR_timeline_ContextBranchName "Context %1 (%2)"
#define GPU_STR_timeline_QueueBranchName "Queue %1"
#define GPU_STR_timeline_CmdListBranchName "CmdList%1"
#define GPU_STR_timeline_CmdBufferBranchName "CmdBuffer%1"
#define GPU_STR_timeline_CmdListIsntanceBranchName "CmdList%1_%2"
#define GPU_STR_timeline_CmdBufferInstanceBranchName "CmdBuffer%1_%2"
#define GPU_STR_timeline_QueueGPUCommandsBranchName "GPU Commands"
#define GPU_STR_timeline_CmdListsBranchName "Command Lists"
#define GPU_STR_timeline_CmdBuffersBranchName "Command Buffers"
#define GPU_STR_timeline_ContextBranchNameWithParam "Queue %1 - %2 (%3)"

#define GPU_STR_APITimeline_TimeTooltipLine "Time: %3 - %4 (%5)"

#endif //__GPSTRINGCONSTANTS_H
