﻿//==================================================================================
// Copyright (c) 2016 , Advanced Micro Devices, Inc.  All rights reserved.
//
/// \author AMD Developer Tools Team
/// \file afAppStringConstants.h
///
//==================================================================================

// Infra:
#include <AMDTBaseTools/Include/AMDTDefinitions.h>

// Application title:
#define AF_STR_AMDAppDataDirectory L"AMD"
#define AF_STR_NoteTitle "Note"
#define AF_STR_WelcomePage "Welcome Page"
#define AF_STR_TitleRunningMode L" (%ls)"
#define AF_STR_TitleSeparator L" -"
#define AF_STR_TitleModeFormat L"| %ls"
#define AF_STR_TitleModeFormatA "| %1"
#define AF_STR_TitleModeSessionFormat L"| %ls (%ls)"
#define AF_STR_TitleModeSessionFormatA "| %1 (%2)"
#define AF_STR_TitleRunModeRunning L"Running"
#define AF_STR_TitleRunModeSuspended L"Suspended"
#define AF_STR_TitleRunModePaused L"Paused"
#define AF_STR_TitleRunModeDataTranslating L"Translating Data"
#define AF_STR_TitleNoProjectLoaded L"No Project Loaded"

// Tree root:
#define AF_STR_ApplicationTreeViewCaption L"%ls Explorer"
#define AF_STR_ApplicationTreeViewCommandName L"&%ls Explorer"
#define AF_STR_ApplicationTreeBackTooltip "Back"
#define AF_STR_ApplicationTreeBackToTooltip "Back to "
#define AF_STR_ApplicationTreeForwardTooltip "Forward"
#define AF_STR_ApplicationTreeForwardToTooltip "Forward to "
#define AF_STR_ApplicationTreeRootRunning "(Running)"
#define AF_STR_ApplicationTreeRootStopped "No project loaded"
#define AF_STR_ApplicationTreeNotRunning "Not running"
#define AF_STR_ApplicationTreeSeparator " - "
#define AF_STR_Underscore "_"


// General strings:
#define AF_STR_Empty L""
#define AF_STR_NotAvailable L"N/A"
#define AF_STR_NotAvailableA "N/A"
#define AF_STR_OutOfScope "Out Of Scope"
#define AF_STR_More L"More..."
#define AF_STR_MoreA "More..."
#define AF_STR_NoItems L"No Items"
#define AF_STR_Yes L"Yes"
#define AF_STR_No L"No"
#define AF_STR_OK_Button "OK"
#define AF_STR_Open_Button "&Open"
#define AF_STR_Cancel_Button "Cancel"
#define AF_STR_Close_Button L"&Close"
#define AF_STR_Attach_Button "&Attach"
#define AF_STR_Refresh_Button "&Refresh"
#define AF_STR_EmptyStr L"Empty"
#define AF_STR_Comma L","
#define AF_STR_CommaA ","
#define AF_STR_Semicolon L";"
#define AF_STR_Colon ":"
#define AF_STR_ColonW L":"
#define AF_STR_Shtrudel '@'
#define AF_STR_None L"None"
#define AF_STR_Unknown L"Unknown"
#define AF_STR_Total L"Total"
#define AF_STR_TotalA "Total"
#define AF_Str_MenuSeparator L"/"
#define AF_STR_pngFileExt L"png"
#define AF_STR_HyphenA "-"
#define AF_STR_Hyphen L'-'
#define AF_STR_StandaloneProduct L"Standalone"

#define AF_STR_ConfirmDeletion L"Are you sure you want to delete "
#define AF_STR_ConfirmRemove "Are you sure you want to remove %1 from project?"
#define AF_STR_ConfirmRemoveMultiple "Are you sure you want to remove the selected files from the project?"
#define AF_STR_NDAVersion L"NDA version"
#define AF_STR_InternalVersion L"AMD internal only"
#define AF_STR_Debug L"Debug binaries"
#define AF_STR_DoneLine L"----------------- Done -----------------"
#define AF_STR_Space L" "
#define AF_STR_SpaceA " "
#define AF_STR_Empty L""
#define AF_STR_EmptyA ""
#define AF_STR_Enabled L"Enabled"
#define AF_STR_Disabled L"Disabled"
#define AF_STR_Deleted L"Deleted"
#define AF_STR_PropertiesHandle L"Handle"
#define AF_STR_KilobytesShort L"KB"
#define AF_STR_nullptrContext L"No Context"
#define AF_STR_NewLine L"\n"
#define AF_STR_NewLineA "\n"
#define AF_STR_Tab L"\t"
#define AF_STR_Error L"Error"
#define AF_STR_ErrorA "Error"
#define AF_STR_Warning L"Warning"
#define AF_STR_WarningA "Warning"
#define AF_STR_Information L"Information"
#define AF_STR_InformationA "Information"
#define AF_STR_Question L"Question"
#define AF_STR_QuestionA "Question"
#define AF_STR_Message L"Message"
#define AF_STR_MessageA "Message"
#define AF_STR_Ready L"Ready"
#define AF_STR_AddButton "&Add >>"
#define AF_STR_RemoveButton "<< &Remove"
#define AF_STR_RemoveAllButton "Remove A&ll"
#define AF_STR_ApplyButton "Apply"
#define AF_STR_QStringAppend "%1 %2"

// Welcome page:
#define AF_STR_WelcomeDirectory L"HTML"
#define AF_STR_WelcomeFileName "Welcome.html"
#define AF_STR_WelcomeFileNameAnalyzeModeNA "WelcomeAnalyzeNA.html"
#define AF_STR_WelcomeFileExtension L"html"
#define AF_STR_WelcomeFileCSSExtension L"css"


#define AF_STR_Id L"ID"
#define AF_STR_Platform L"Platform"
#define AF_STR_Device L"Device"
#define AF_STR_Value L"Value"
#define AF_STR_ValueA "Value"
#define AF_STR_User L"User"
#define AF_STR_Item L"Item"
#define AF_STR_Size L"Size"
#define AF_STR_Type L"Type"
#define AF_STR_TypeA "Type"
#define AF_STR_FilePath L"File Path"
#define AF_STR_ProcessName L"Process Name"
#define AF_STR_FileName L"File Name"
#define AF_STR_Arguments L"Arguments"
#define AF_STR_Title L"Title"
#define AF_STR_Partial L"Partial"
#define AF_STR_Full L"Full"
#define AF_STR_RGBA L"RGBA"
#define AF_STR_Description L"Description"
#define AF_STR_FunctionName L"Function Name"
#define AF_STR_OpenGL L"OpenGL"
#if AMDT_BUILD_TARGET == AMDT_LINUX_OS
    #define AF_STR_DLLName L"Module Name"
#else
    #define AF_STR_DLLName L"DLL Name"
#endif
#define AF_STR_CLKernelDeclaration L"__kernel"
#define AF_STR_CLKernelDeclarationAlternative L"kernel"
#define AF_STR_CLKernelReturnType L"void"
#define AF_STR_IntFormat L"%d"
#define AF_STR_UIntFormat L"%u"
#define AF_STR_UInt64Format L"%llu"
#define AF_STR_LeftParenthesis L"("
#define AF_STR_RightParenthesis L")"


// General strings:
#define AF_STR_Name L"Name"
#define AF_STR_NameA "Name"
#define AF_STR_NumberShort L"no."
#define AF_STR_FileChangedMarker L" *"

// Layout strings
#define AF_STR_WindowRestoreGroup "WindowRestore"
#define AF_STR_WindowRestoreSectionPosition "WindowPosition"
#define AF_STR_WindowRestoreSectionSize "WindowSize"
#define AF_STR_WindowRestoreSectionMaximized "WindowMaximized"
#define AF_STR_WindowRestoreWindowState "windowState"
#define AF_STR_WindowRestoreWindowStateOriginal "windowStateOriginal"

#define AF_STR_LayoutNoProjectLoaded L"NoProject"
#define AF_STR_LayoutNoProjectOutputLoaded L"NoProjectOutput"
#define AF_STR_LayoutDebug L"Debug"
#define AF_STR_LayoutDebugKernel L"DebugKernel"
#define AF_STR_LayoutProfileGPU L"ProfileGPU"
#define AF_STR_LayoutKernelAnalyze L"KernelAnalyze"

#define AF_STR_SettingsOrganization "AMD"
#define AF_STR_SettingsApplication "AMDTApplication"
#define AF_STR_LayoutFileName L"Layout"

#define AF_STR_LayoutTempFile L"tempSetting"
#define AF_STR_LayoutGroupStrFormat L"[%ls]\n"
#define AF_STR_LayoutSettingStrFormatHead L"windowState=\""
#define AF_STR_LayoutSettingConvertedHead "@ByteArray"

// Extension names:
#define AF_STR_projectSettingsDebugExtensionName L"GPU Debug"

// Initialize application Command:
#define AF_STR_LogMsg_AppInitBegin L"Application initialization started"
#define AF_STR_LogMsg_AppInitEnded L"Application initialization ended"
#define AF_STR_LogMsg_InitImageHandlers L"Initializing image file handlers"
#define AF_STR_LogMsg_FinishedInitImageHandlers L"Finished initializing image file handlers"
#define AF_STR_LogMsg_AppInitCmdSucceeded L"Application Initialization command succeeded"
#define AF_STR_LogMsg_AppInitCmdFinalize L"Finalizing application initialization command"
#define AF_STR_LogMsg_VerifyWinVersion L"Verifying Windows version compatibility"
#define AF_STR_LogMsg_VerifyMacVersion L"Verifying Mac OS X version compatibility"
#define AF_STR_LogMsg_LoadingOptionsFile L"Loading options file"
#define AF_STR_LogMsg_FinishedLoadingOptionsFile L"Finished loading options file"
#define AF_STR_ErrorMessageFailedToLoadTheSettings "CodeXL failed to load the Settings file."
#define AF_STR_ErrorMessageFailedToLoadTheSettingsUnicode L"CodeXL failed to load the Settings file."
#define AF_STR_LogMsg_EULANotAcceptedExiting L"EULA was not accepted. Exiting."
#define AF_STR_OperatingSystemNotSupported L"CodeXL does not support this Operating System Version (%d.%d.%d).\nPlease go to https://github.com/GPUOpen-Tools/CodeXL/issues for more information."
#define AF_STR_LogMsg_EventHandlerOverflow L"Event handler overflow was prevented."
#define AF_STR_LogMsg_FailedToLoadAComponent L"Failed to load a basic component."
#define AF_STR_ErrorMessageLowResolution L"Insufficient display resolution. CodeXL requires a display resolution of %dx%d or higher. CodeXL will now exit."

// Remote session errors.
#define AF_STR_REMOTE_GENERAL_ERROR_MSG L"Unable to connect to CodeXL Remote Agent.\nPlease verify that:\n1. CodeXL and CodeXL Remote Agent are not blocked by a firewall.\n2. The given IP address and ports are valid, and the remote machine is accessible from the local machine.\n3. CodeXL Remote Agent is running on the remote machine."
#define AF_STR_REMOTE_PLATFORM_INFO_UNAVAILABLE_TITLE "OpenCL Platform information is unavailable."
#define AF_STR_REMOTE_PLATFORM_INFO_UNAVAILABLE_BODY "OpenCL platform information is currently unavailable for remote GPU debugging sessions."

// CodeXL application flow:
#define AF_STR_PropertiesViewStartRunningComment L"To run an application, select a run mode and run the application"
#define AF_STR_PropertiesViewLoadProjectComment L"To open a CodeXL project go to File -> Open Project menu"
#define AF_STR_PropertiesProcessNotRunning L"Process Not Running"
#define AF_STR_PropertiesProjectNotLoaded L"Project Not Loaded"
#define AF_STR_PropertiesProcessRunning L"Process Running"
#define AF_STR_PropertiesExecutionMode L"Current Execution Mode:"
#define AF_STR_NoExeIsSelected "No executable selected.\nPlease select an executable in the Project Settings dialog."
#define AF_STR_NoProjectIsLoaded "No project loaded.\nClick OK to create a new project."

/// Remote host:
#define AF_STR_modeToolbarHostLocal "Local"
#define AF_STR_modeToolbarHostConfigureSettings "Configure Remote Host Settings..."
#define AF_STR_modeToolbarHostSelectionProjectChangeQuestion "Do you want to switch to project %1?"
#define AF_STR_modeToolbarHostsButtonObjectName "HostsButton"

// Global settings XML file:
#define AF_STR_globalSettingsFileName L"CodeXLSettings"
#define AF_STR_globalSettingsFileExtension L"xml"
#define AF_globalSettingsGeneralHeader "General"
#define AF_globalSettingsGeneralHeaderUnicode L"General"
#define AF_globalSettingsGeneralLogFilesNode "LogFileDirectory"
#define AF_globalSettingsGeneralLogLevelNode "LogSeverity"
#define AF_globalSettingsProxyEnabledNode "IsUsingHttpProxy"
#define AF_globalSettingsProxyAddressNode "HttpProxyAddress"
#define AF_globalSettingsRdsApiPortNode "RdsApiPort"
#define AF_globalSettingsRdsEventsPortNode "RdsEventsPort"
#define AF_globalSettingsSpyApiPortNode "SpyApiPort"
#define AF_globalSettingsSpyEventsPortNode "SpyEventsPort"
#define AF_globalSettingsHistoryList "HistoryList"
#define AF_globalSettingsWidgetHistoryList "WidgetHistoryList"
#define AF_globalSettingsWidgetHistoryListItem "WidgetHistoryListItem"
#define AF_globalSettingsWidgetNameAttribute L"widgetName"
#define AF_globalSettingsEulaVersionAcceptedNode "EulaVersionAccepted"
#define AF_globalSettingsFloatingPointPrecisionNode "FloatingPointPrecision"
#define AF_globalSettingsAlertMissingSourceNode "AlertMissingSource"
#define AF_globalSettingsDialogsNotToShow "DialogsNotToShow"
#define AF_globalSettingsDialogsName "DialogName"
#define AF_STR_globalSettingsMinBoundErrorMsg "Invalid value.\nSet to minimum valid value %1"
#define AF_STR_globalSettingsMaxBoundErrorMsg "Invalid value.\nSet to maximum valid value %1"
#define AF_STR_globalSettingsInaccessiblePathErrorMsg "Log path %1 is inaccessible. Check access permissions. Reverting to original path."
#define AF_STR_globalSettingsEmptyPathErrorMsg "Log path cannot be empty. Reverting to original path."

// Commands
#define AF_STR_FileSaveAs "Save File As"

// CodeXL files:
#define AF_STR_projectFileExtension L"cxl"
#define AF_STR_exeFileExtension L"exe"
#define AF_STR_profileFileExtension1 L"cxlcpdb"
#define AF_STR_profileFileExtension2 L"prd"
#define AF_STR_profileFileExtension3 L"caperf"
#define AF_STR_profileFileExtension4 L"csv"
#define AF_STR_profileFileExtension5 L"atp"
#define AF_STR_pngFileExtension L"png"
#define AF_STR_htmlFileExtension L"html"

#define AF_STR_projectFileDetails "CodeXL Project files (*.cxl)"
#define AF_STR_visualStudioProjectFileExtension L"cxlvs"
#define AF_STR_noProjectLoaded L"No project loaded"
#define AF_STR_ImageBuffersViewsCreatorID L"ImagesAndBuffers"
#define AF_STR_GenericMDIViewsCreatorID L"GenericInfra"
#define AF_STR_KernelAnalyzerViewsCreatorID L"KernelAnalyzer"
#define AF_STR_GPUProfileViewsCreatorID L"GPUProfile"
#define AF_STR_CodeXMLImageBuffersFilesExtension L"gdcxl"
#define AF_STR_clSourceFileExtension L"cl"
#define AF_STR_hsailSourceFileExtension L"hsail"
#define AF_STR_glslSourceFileExtension L"glsl"
#define AF_STR_AnalyzedSourceFileExtension "cl,vs,hs,ds,gs,ps,cs,hlsl,frag,vert,comp,geom,tese,tesc,glsl"
#if AMDT_BUILD_TARGET == AMDT_WINDOWS_OS
    #define AF_STR_FILE_PATHEXTENSIONS_QREGEXP "[a-z]:([\\\\/][^\\\\/\"]+)+\\.(cl|hlsl|glsl|fs|frag|vs|vert|cs|comp|gs|geom|ps|hs|ds|tese|tesc)"
    #define AF_STR_FILE_EXTENSIONS_QREGEXP "\\.cl|hlsl|glsl|fs|frag|vs|vert|cs|comp|gs|geom|ps|hs|ds|tese|tesc"
#else
    #define AF_STR_FILE_PATHEXTENSIONS_QREGEXP "(/[^/\"]+)+\\.(cl|glsl|fs|frag|vs|vert|cs|comp|gs|geom|tese|tesc)"
    #define AF_STR_FILE_EXTENSIONS_QREGEXP "\\.cl|hlsl|glsl|fs|frag|vs|vert|cs|comp|gs|geom|tese|tesc"
#endif
#define AF_STR_BUILDING_STAGE_QREGEXP "vertex|tessellation evaluation|tessellation control|geometry|fragment|compute"
#define AF_STR_CL_LINENUM_QREGEXP "[lL]ine [0-9]+:"
#define AF_STR_HLSL_LINENUM_QREGEXP "(\\([\\d]+,)"
#define AF_STR_GLSL_LINENUM_QREGEXP ":[\\d]+:"
#define AF_STR_BUILD_STARTED "build started"

#define AF_STR_OpenGL_ERROR "ERROR:"
#define AF_STR_OpenGL_WARNING "WARNING:"
#define AF_STR_OpenGL_Shader_Failed "shader failed to compile"
#define AF_STR_BUILDING_STAGE "building stage: "
#define AF_STR_FILENAME_SEPARATOR ", filename: "
#define AF_STR_SHADER "shader"
#define AF_STR_STAGE "stage:"
#define AF_STR_COMPILING "Compiling"

#define AF_STR_GpuProfileSessionFileExtension L"gpsession"
#define AF_STR_GpuPerformanceCountersSessionFileExtension L"csv"
#define AF_STR_GpuProfileTraceFileExtension L"atp"
#define AF_STR_TeapotSampleProjectName L"CodeXL Teapot"
#define AF_STR_TeapotSampleVSProjectName L"CXLTeaPot"
#define AF_STR_ProfileDirExtension L"_ProfilerOutput"
#define AF_STR_KernelOutputExtension L"_KernelOutput"

// Toolbars:
#define AF_STR_ImagesAndBuffersToolbar L"Images and Buffers"
#define AF_STR_toolbarPostfix " Toolbar"
#define AF_STR_viewsToolbarPostfix " Views Toolbar"
#define AF_STR_modeToolbar "Active Mode"
#define AF_STR_actionsToolbar "Execution Toolbar"
#define AF_STR_actionsToolbarUnicode L"Execution Toolbar"
#define AF_STR_modeToobarButtonBaseName "ModeButton"
#define AF_STR_modeSwitchToTooltipPart1 "Switch to "
#define AF_STR_modeSwitchToTooltipPart2 " Mode"
#define AF_STR_playButtonContinue L"Continue"
#define AF_STR_playButtonExeNameOnly L" (%ls)"
#define AF_STR_playButtonStartPrefix L"Start CodeXL "
#define AF_STR_playButtonStartGeneric L"Start CodeXL"


// Menu items:
#define AF_STR_CloseAllDocuments "C&lose All Documents"

// Startup page:
#define AF_STR_StartupPageHTMLFileName L"CodeXL_startup.htm"

// Select Windows Store app dialog:
#define AF_STR_winStoreAppWindowTitle "Select Windows Store app"
#define AF_STR_winStoreAppUserModelIDLabel "User Model ID:"

// Attach to Process dialog:
#define AF_STR_winAttachToProcessTitle "Attach to Process"

// New project dialog:
#define AF_STR_newProjectWindowEditTitle "CodeXL Project Settings"
#define AF_STR_newProjectWindowNewTitle "Create a new CodeXL Project"
#define AF_STR_newProjectGeneralTabName "General"
#define AF_STR_newProjecProjectName "CodeXL Project Name:"
#define AF_STR_newProjectProjectExePath "Executable Path:"
#define AF_STR_newProjectProjectBrowseForExePathTooltipApp "Click to browse for an executable path"
#define AF_STR_newProjectProjectEXEEditLineTooltipApp "Type the full path of the selected Desktop Application, or click the browse button"
#define AF_STR_newProjectWindowsStoreApp "Windows Store App"
#define AF_STR_newProjectWindowsStoreAppTooltip "Click for a selection of a Windows Store App"
#define AF_STR_newProjectDesktopApplication "Desktop Application"
#define AF_STR_newProjectDesktopApplicationTooltip "Click for a selection of a Desktop Application"
#define AF_STR_newProjectWindowsStoreAppUserModelID "User Model ID:"
#define AF_STR_newProject_remoteHost "Remote Host"
#define AF_STR_newProject_remoteHostTooltip "Click to run the selected application on a Remote Host"
#define AF_STR_newProject_localHost "Local Host"
#define AF_STR_newProject_localHostTooltip "Click to run the selected application on the Local Host"
#define AF_STR_newProject_targetHost "Target Host:"
#define AF_STR_newProject_remoteHostAddress "Remote Host Address:"
#define AF_STR_newProject_remoteHostPort "Port:"
#define AF_STR_newProject_remoteHostDefaultPort "27015"
#define AF_STR_newProject_remoteHostTestConnection "Test Connection"
#define AF_STR_newProject_remoteHostTestConnectionTooltip "Click to test the connection to the remote host with the specified port and address"
#define AF_STR_newProject_remoteHostTestConnectionFailedMessage "Failed to connect to remote host %1 with port number %2.\n Please make sure that:\n1. CodeXL Remote Agent is running on the target machine.\n2. There is network access from the client machine to the remote machine.\n3. CodeXL is not blocked by a firewall on the client machine.\n4. CodeXL Remote Agent is not blocked by a firewall on the remote machine."
#define AF_STR_newProject_remoteHostTestConnectionSucceededMessage "Connection was established successfuly."
#define AF_STR_newProject_remoteHostInvalidAddress L"Invalid remote host address"
#define AF_STR_newProject_remoteHostInvalidPort L"Invalid port number for remote host"
#define AF_STR_newProjectWorkingFolder "Working Directory:"
#define AF_STR_newProjectWorkingFolderTooltip "Click to select the working folder for the executed application"
#define AF_STR_newProjectProgramArguments "Command Line Arguments:"
#define AF_STR_newProjectProgramArgumentsTooltip "Add the application command line arguments, separated by a ';'"
#define AF_STR_newProjectEnvironmentVariables "Environment Variables:"
#define AF_STR_newProjectBrowse "Browse"
#define AF_STR_newProjectEditEnvVars L"..."
#define AF_STR_newProjectWorkingFolderSelectionTitle "Select the project working folder"
#define AF_STR_newProjecExecutableFileSelectionTitle "Select an executable for the project"
#define AF_STR_newProjecWindowsStoreAppSelectionTitle L"Select Windows Store app"
#define AF_STR_newProjectRestoreDefaultSettings "&Restore Default Settings"
#define AF_STR_newProjectEnterName "Enter Project Name..."
#define AF_STR_newProjectDefaultProjectName "Project%1"
#define AF_STR_newProjectInvalidName L"CodeXL project name cannot be empty. Please enter a valid project name."
#define AF_STR_newProjectProjectNameChanged "The project contains saved data of type: %1.\nChanging the project name will create a new project that will not contain the data stored in this project.\nDo you want to change the project name?"
#define AF_STR_newProjectInvalidNameInvalidChars L"The project name contains invalid characters."
#define AF_STR_newProjectExeDoesNotExistOrInvalid L"Executable path does not exist or executable is invalid"
#define AF_STR_newProjectWindowsStoreAppInvalid L"Invalid Windows Store app User Model ID"
#define AF_STR_newProjectWorkingFolderDoesNotExist L"Working directory path does not exist"
#define AF_STR_loadProjectError "Could not load project file"
#define AF_STR_openFileDialogCaption "Open a file"
#define AF_STR_projectSettingsSourceFiles "Source Files"
#define AF_STR_projectSettingsTargetApplication "Target Application"
#define AF_STR_projectSettingsTargetApplicationVS "Target Application (Set by the Debugging section of the Visual Studio Project Properties)"
#define AF_STR_projectSettingsSourceFilesDirectory "Source Files Directories:"
#define AF_STR_projectSettingsSourceFilesResolutionDirectory "Source Files Resolution<br> Root Directory:"
#define AF_STR_projectSettingsSelectKernelSourceFilesFolderTitle "Select source code root resolution directory:"
#define AF_Str_ProjectSettingsSoureFilesDirectoriesLabel "CodeXL will use these paths to look for source code files of the debugged/profiled application (C, C++, OpenCL kernel files, etc.)"
#define AF_STR_newProjectEmptyProfileName L"The profile name cannot be empty."
#define AF_STR_newProjectInvalidProfileName L"The profile name must not contain any of the following characters: "
#define AF_STR_newProjectExistingQuestion "A project named '%1' already exists. \nDo you want to overwrite the existing project?"
#define AF_STR_newProjectEnvironmentVariablesDelimiter L"\n"
#define AF_STR_newProjectEnvironmentVariablesDelimitersVS L"\n;"
#define AF_STR_newProjectEditEnvVarsTooltip "Click to define the executed application environment variables"
#define AF_STR_projectSettingsSourceFilesDirectoryTooltip "Click to select a list of source files directories for the executed application.\nThe source files directories will be used to detect the sources and calls stacks when debugging / profiling the application."

// Global settings dialog:
#define AF_STR_globalSettingsWindowTitle "CodeXL Options"
#define AF_STR_globalSettingsGeneralTabName "&General"
#define AF_STR_globalSettingsRestoreDefaultSettings "&Restore Default Settings"
#define AF_STR_globalRemoteSettingsPortsHeadline "Remote Debugging Ports:"
// Global settings page:
#define AF_STR_globalSettingsLoggingGroupTitle "Logging"
#define AF_STR_globalSettingsDebugLogLevelLabel "Debug log level: "
#define AF_STR_globalSettingsLogFilesFolderLabel "Log Files and Images Directory"
#define AF_STR_globalSettingsSelectLogFilesFolderTitle "Select the log files and images directory"
#define AF_STR_globalSettingsConnectionGroupTitle "Connection"
#define AF_STR_globalSettingsUsingProxyCheckBox "I am using an HTTP proxy"
#define AF_STR_globalSettingsProxyAddressLabel "Server: "
#define AF_STR_globalSettingsProxyPortLabel "Port: "
#define AF_STR_globalSettingsFloatingPointPrecision "Floating-point precision (maximum number of significant digits):"
#define AF_STR_globalSettingsAdvancedGroupTitle "Advanced"
#define AF_STR_globalSettingsAlertMissingSourceFiles "Alert when a source file is missing"

#define AF_STR_sourceCodeQuestionInclude "Would you like to include\n%1\nin the list of source search directories?\n"

// "File" menu:
#define AF_STR_FileMenuString L"&File"
#define AF_STR_newProject L"&New Project...\t" AF_STR_keyboardShortcutNewMenu
#define AF_STR_openProject L"&Open Project...\t" AF_STR_keyboardShortcutOpenProjectMenu
#define AF_STR_closeProject L"Close &Project"
#define AF_STR_openFile L"Open &File...\t" AF_STR_keyboardShortcutOpenFileMenu
#define AF_STR_welcomePage L"&Welcome Page"
#define AF_STR_welcomePageStatusbarString  L"Open CodeXL welcome page"
#define AF_STR_RecentProject L"&Recent Projects"
#define AF_STR_saveProject L"&Save Project\t" AF_STR_keyboardShortcutSaveProjectMenu
#define AF_STR_saveProjectAs L"Save Project &As..."
#define AF_STR_saveFile L"Save Fi&le\t" AF_STR_keyboardShortcutSaveMenu
#define AF_STR_saveFileAs L"Save F&ile As..."
#define AF_STR_DebugSettings L"&Debug Settings...\t" AF_STR_keyboardShortcutDebugMenu
#define AF_STR_exit L"E&xit"
#define AF_STR_DebugMenuString L"&Debug"
#define AF_STR_ProjectSettings L"Project Se&ttings...\t" AF_STR_ProjectSettingsKeyBoardShortcut
#define AF_STR_ProjectSettingsKeyBoardShortcut L"Ctrl+P"

// Status strings:
#define AF_STR_RecentlyUsedProjectStatusbarString L"Recent projects list"
#define AF_STR_newProjectStatusbarString L"Create a new project"
#define AF_STR_openProjectStatusbarString L"Open an existing project file"
#define AF_STR_closeProjectStatusbarString L"Close the current project"
#define AF_STR_openFileStatusbarString L"Open a source code file"
#define AF_STR_saveFileStatusbarString L"Save the current file"
#define AF_STR_saveFileAsStatusbarString L"Save the current file to a new location"
#define AF_STR_saveProjectStatusbarString L"Save the current project"
#define AF_STR_saveProjectAsStatusbarString L"Save the current project to another file"
#define AF_STR_exitStatusbarString L"Exit the CodeXL application"
#define AF_STR_ProgressSettingsStatusbarString L"Specify the settings for the current project"

// "Edit" menu:
#define AF_STR_EditMenuString L"&Edit"
#define AF_STR_Copy L"&Copy\t" AF_STR_keyboardShortcutCopyMenu
#define AF_STR_CopyA "&Copy\t" AF_STR_keyboardShortcutCopyMenuA
#define AF_STR_Cut L"Cu&t\t" AF_STR_keyboardShortcutCutMenu
#define AF_STR_Paste L"&Paste\t" AF_STR_keyboardShortcutPasteMenu
#define AF_STR_Find L"&Find\t" AF_STR_keyboardShortcutFindMenu
#define AF_STR_FindA "&Find\t" AF_STR_keyboardShortcutFindMenuA
#define AF_STR_FindNext L"Find &Next\t" AF_STR_keyboardShortcutFindNextMenu
#define AF_STR_FindPrev L"Find Pre&vious\t" AF_STR_keyboardShortcutFindPrevMenu
#define AF_STR_FindNextA "Find &Next\t" AF_STR_keyboardShortcutFindNextMenuA
#define AF_STR_GoTo L"&Go to...\t" AF_STR_keyboardShortcutGoToMenu
#define AF_STR_GoToA "&Go to...\t" AF_STR_keyboardShortcutGoToMenuA
#define AF_STR_MarkerNext L"Go to Next Marker\t" AF_STR_keyboardShortcutNextMarkerMenu
#define AF_STR_MarkerPrevious L"Go to Previous Marker\t" AF_STR_keyboardShortcutPrevMarkerMenu
#define AF_STR_CopyStatusbarString L"Copies the selection to the Clipboard"
#define AF_STR_PasteStatusbarString L"Pastes from Clipboard"
#define AF_STR_CutStatusbarString L"Cuts the selection to the Clipboard"
#define AF_STR_FindStatusbarString L"Finds the specified text"
#define AF_STR_FindNextStatusbarString L"Finds next instance of specified text"
#define AF_STR_FindPrevStatusbarString L"Finds previous instance of specified text"
#define AF_STR_MarkerNextStatusbarString L"Next: Scroll the Calls History View to the next string marker function call"
#define AF_STR_MarkerPreviousStatusbarString L"Previous: Scroll the Calls History View to the previous string marker function call"
#define AF_STR_SelectAllStatusbarString L"Select all items in the view"
#define AF_STR_ShowLineNumbersStatusbarString L"Show line numbers in source code view"
#define AF_STR_GoToStatusbarString L"Go to line"

// Main menu:
#define AF_STR_ProfileMenuString L"&Profile"
#define AF_STR_AnalyzeMenuString L"&Analyze"
#define AF_STR_BreakPointsMenuString L"&Breakpoints"

// "View" menu:
#define AF_STR_ViewMenuString L"&View"
#define AF_STR_ViewMenuStringA "&View"
#define AF_STR_ResetGUILayouts L"Reset &GUI Layouts"
#define AF_STR_ResetGUILayoutsStatusbarString L"Reset the GUI Layouts back to factory settings"
#define AF_STR_ToolbarMenuStringA "&Toolbars"
#define AF_STR_ViewsToolbar "Views"
#define AF_STR_WindowsMenuString L"&Window"

// "Help" menu:
#define AF_STR_HelpMenuString L"&Help"
#define AF_STR_HelpUserGuide L"View &Help"
#define AF_STR_HelpQuickStart L"View &Quick Start Guide"
#define AF_STR_HelpDevToolsSupportForum L"&CodeXL Support and Issues Page"
#define AF_STR_HelpUpdates L"Check for &Updates"
#define AF_STR_LoadTeapotSample L"Load the Teapot &Sample"
#define AF_STR_HelpAbout L"&About CodeXL"
#define AF_STR_HelpUserGuideStatusbarString L"Display CodeXL User Guide"
#define AF_STR_HelpQuickStartStatusbarString L"Display the CodeXL Quick Start Guide"
#define AF_STR_HelpDevToolsSupportForumStatusbarString L"Go to the CodeXL Support and Issues Page"
#define AF_STR_HelpUpdatesStatusbarString L"Check for new CodeXL versions"
#define AF_STR_LoadTeapotSampleStatusbarString L"Load the Teapot sample"
#define AF_STR_HelpAboutStatusbarString L"Display the program information and copyright"
#define AF_STR_HelpDevToolsSupportForumURL L"https://github.com/GPUOpen-Tools/CodeXL/issues"
#define AF_STR_HelpCodeXLWebPage L"http://gpuopen.com/compute-product/codexl/"
#define AF_STR_HelpShortcut L"F1"


// "Tools" menu:
#define AF_STR_ToolsMenuString L"&Tools"
#define AF_STR_ToolsSystemInfo L"&System Information"
#define AF_STR_ToolsOptions L"&Options..."
#define AF_STR_ToolsSystemInfoStatusbarString L"Collects computer configuration data, OpenCL and OpenGL implementation details"
#define AF_STR_ToolsOptionsStatusbarString L"Enables you to change the settings"
#define AF_STR_DebugLogLevelWarning L"CodeXL debug log level is set to '%ls' level.\nPlease set it back to 'Info' level in the Tools Options dialog\nafter finishing your current task.\n\n Do you wish to continue?"
#define AF_STR_DebugLogLevelDebugWarningTitle "Warning - Log level"

// Keyboard shortcuts:
#define AF_STR_keyboardShortcutNewMenu L"Ctrl+N"
#define AF_STR_keyboardShortcutOpenFileMenu L"Ctrl+O"
#define AF_STR_keyboardShortcutOpenProjectMenu L"Ctrl+Shift+O"
#define AF_STR_keyboardShortcutStartupDialogMenu L"Ctrl+Alt+O"
#define AF_STR_keyboardShortcutStartupDialogString L"Ctrl+Alt+O"
#define AF_STR_keyboardShortcutSaveProjectMenu L"Ctrl+Shift+S"
#define AF_STR_keyboardShortcutSaveMenu L"Ctrl+S"
#define AF_STR_keyboardShortcutExitMenu L"Alt+F4"
#define AF_STR_keyboardShortcutDebugMenu L"Ctrl+D"
#define AF_STR_keyboardShortcutCopyMenu L"Ctrl+C"
#define AF_STR_keyboardShortcutCopyMenuA "Ctrl+C"
#define AF_STR_keyboardShortcutCutMenu L"Ctrl+X"
#define AF_STR_keyboardShortcutPasteMenu L"Ctrl+V"
#define AF_STR_keyboardShortcutCopyString L"Ctrl + C"
#define AF_STR_keyboardShortcutFindMenu L"Ctrl+F"
#define AF_STR_keyboardShortcutFindMenuA "Ctrl+F"
#define AF_STR_keyboardShortcutFindString L"Ctrl + F"
#define AF_STR_keyboardShortcutFindNextMenu L"F3"
#define AF_STR_keyboardShortcutFindNextMenuA "F3"
#define AF_STR_keyboardShortcutFindNextString L"F3"
#define AF_STR_keyboardShortcutFindPrevMenu L"Shift+F3"
#define AF_STR_keyboardShortcutNextMarkerMenu L"Ctrl+Shift+N"
#define AF_STR_keyboardShortcutNextMarkerString L"Command + Shift + N"
#define AF_STR_keyboardShortcutPrevMarkerMenu L"Ctrl+Shift+P"
#define AF_STR_keyboardShortcutPrevMarkerString L"Command + Shift + P"
#define AF_STR_keyboardShortcutSelectAllMenu L"Ctrl+A"
#define AF_STR_keyboardShortcutSelectAllMenuA "Ctrl+A"
#define AF_STR_keyboardShortcutSelectAllString L"Ctrl+A"
#define AF_STR_keyboardShortcutDeleteMenuA "Del"
#define AF_STR_keyboardShortcutDeleteMenu L"Del"
#define AF_STR_keyboardShortcutDeleteString L"Del"
#define AF_STR_keyboardShortcutGoToMenu L"Ctrl+G"
#define AF_STR_keyboardShortcutGoToMenuA "Ctrl+G"
#define AF_STR_keyboardShortcutGoToString L"Ctrl + G"

// Edit environment variables:
#define AF_STR_EditVariablesDialogTitle "Edit Environment Variables"
#define AF_STR_EditVariablesDialogDescription "Please add operating system environment variables for the debugged session"
#define AF_STR_EditVariablesDialogVariableNameColumnTitle "Environment Variable Name"
#define AF_STR_EditVariablesDialogAddEnvironmentVariable "Add Environment Variable..."
#define AF_STR_EditVariablesDialogErrorMsgTitle "Incorrect Variable Name"
#define AF_STR_EditVariablesDialogErrorMsg "Variable name in row number %d is not valid"

// Project xml file
#define AF_STR_loadProjectFileVersionNode "FileVersion"
#define AF_STR_loadProjectRootNodeBackwardsCompatibility "UnifiedTool"
#define AF_STR_loadProjectProjectNameNode "ProjectName"
#define AF_STR_loadProjectgApplicationPathNode "ApplicationPath"
#define AF_STR_loadProjectLogFilesFolderNode "LogFilesFolder"
#define AF_STR_loadProjectWorkDirNode "WorkingDirectory"
#define AF_STR_loadProjectAppArgsNode "ApplicationArguments"
#define AF_STR_loadProjectIsStoreApp "StoreApp"
#define AF_STR_loadProjectLastActiveModeNode "LastActiveMode"
#define AF_STR_loadProjectLastSessionTypeNode "LastSessionType"
#define AF_STR_loadProjectAppEnvVarsNode "ApplicationEnvironmentVariables"
#define AF_STR_loadProjectAppEnvVarsVarNode "EnvironmentVariable"
#define AF_STR_loadProjectAppEnvVarsNameNode "VariableName"
#define AF_STR_loadProjectAppEnvVarsValueNode "VariableValue"
#define AF_STR_loadProjectProductExtensionsNode "ProductExtensions"
#define AF_STR_loadProjectSourceFilesDirectoryNode "SourceFilesDirectory"
#define AF_STR_loadProjectSourceCodeRootDirectoryNode "SourceCodeRootDirectory"
#define AF_STR_loadProjectProfileNameNode "ProfileName"
#define AF_STR_loadProjectIsRemoteSession "IsRemoteSession"
#define AF_STR_loadProjectRecentlyUsedRemoteIPAddresses "RecentlyUsedRemoteIPAddresses"
#define AF_STR_loadProjectRemoteDaemonHostName "RemoteDaemonHostName"
#define AF_STR_loadProjectRemoteDaemonPortNumber "RemoteDaemonPortNumber"
#define AF_STR_loadProjectArchitecture32Bit L"32-bit GPU Build​"
#define AF_STR_loadProjectArchitecture64Bit L"64-bit GPU Build"

// "System Information" dialog:
#define AF_STR_SystemInformationTitle "System Information"
#define AF_STR_InformationSystem "S&ystem"
#define AF_STR_InformationDisplay "&Display"
#define AF_STR_SystemInformationTitleSaveButton "&Save"
#define AF_STR_InformationOpenGLRenderer "Open&GL Renderer"
#define AF_STR_InformationPixelFormats "OpenGL Pi&xel Formats"
#define AF_STR_InformationOpenGLExtensions "OpenGL &Extensions"
#define AF_STR_InformationOpenCLPlatforms "OpenCL &Platforms"
#define AF_STR_InformationOpenCLDevices "OpenCL De&vices"
#define AF_STR_ErrorMessageSaveSystemInformationFailed "Could not save the system information."
#define AF_STR_DescriptionSystem "<b>Description:</b><br>System view collects and displays information about the configuration of your system."
#define AF_STR_DescriptionDisplay "<b>Description:</b><br>Display view collects and displays information about the configuration of your display system."
#define AF_STR_DescriptionGraphicCard "<b>Description:</b><br>Graphic card view collects and displays information about the configuration of your graphic accelerator system."
#define AF_STR_DescriptionPixelFormats "<b>Description:</b><br>Pixel format view collects and displays information about the pixel formats supported by your system."
#define AF_STR_DescriptionOpenGLExtensions "<b>Description:</b><br>OpenGL extension view collects and displays information about the OpenGL extensions supported by your system."
#define AF_STR_DescriptionOpenCLPlatforms "<b>Description:</b><br>OpenCL platforms view collects and displays information about the OpenCL platforms available on your system."
#define AF_STR_DescriptionOpenCLDevices "<b>Description:</b><br>OpenCL devices view collects and displays information about the OpenCL devices available on all OpenCL platforms installed on your system.<br>This information is collected using the OpenCL modules in your system path. If the AMD APP SDK is installed it may provide more advanced device capabilities."
#define AF_STR_NoOpenCLPlatforms "No OpenCL platforms are installed on the local computer"
#define AF_STR_NoOpenCLDevices "No OpenCL devices are available on the local computer's OpenCL platforms"
#define AF_STR_FailToCollectOpenCLDevicesInfo "Failed to collect OpenCL devices information"
#define AF_STR_CollectingOpenCLDevicesInfo "Collecting data..."
#define AF_STR_OpenCLDevicesTableMinColumnWidth 125
#define AF_STR_32BitHeadingPrefix L"32-bit"
#define AF_STR_64BitHeadingPrefix L"64-bit"
#define AF_STR_32HeadingStr AF_STR_LeftParenthesis AF_STR_32BitHeadingPrefix AF_STR_Comma AF_STR_Space
#define AF_STR_64HeadingStr AF_STR_LeftParenthesis AF_STR_64BitHeadingPrefix AF_STR_Comma AF_STR_Space
#define AF_STR_System_Snapshot_Header L"This file contains a system information snapshot"
#define AF_STR_AMD_DEVELOPER_WEBSITE_URL L"http://gpuopen.com/"
#define AF_STR_FAILED_TO_COLLECT_GPU_DETAILS_AND_EXCEPTION_DESC L"Failed to collect GPU details. Exception raised: %s"
#define AF_STR_FAILED_TO_COLLECT_GPU_DETAILS L"Failed to collect GPU details. Exception raised"
#define AF_STR_FAILED_TO_COLLECT_SYSTEM_INFORMATION L"Failed to collect system information. Exception raised"

// System information command:
#define AF_STR_SystemInformationCommandComputerName L"Computer Name"
#define AF_STR_SystemInformationCommandDomainName L"Domain Name"
#define AF_STR_SystemInformationCommandOSVersionName L"Operating System Version (name)"
#define AF_STR_SystemInformationCommandOSVersionNumber L"Operating System Version (number)"
#define AF_STR_SystemInformationCommandNumberOfCPUCores L"Number of CPU Cores"
#define AF_STR_SystemInformationCommandSystemType L"System Type"
#define AF_STR_SystemInformationCommandCPUType L"CPU Type"
#define AF_STR_SystemInformationCommandTotalPhysicalMemory L"Total Physical Memory"
#define AF_STR_SystemInformationCommandAvailablePhysicalMemory L"Available Physical Memory"
#define AF_STR_SystemInformationCommandTotalVirtualMemory L"Total Virtual Memory"
#define AF_STR_SystemInformationCommandAvailableVirtualMemory L"Available Virtual Memory"
#define AF_STR_SystemInformationCommandTotalPageFiles L"Total Page Files"
#define AF_STR_SystemInformationCommandAvailablePageFiles L"Available Page Files"
#define AF_STR_SystemInformationCommandDriverVersion L"AMD Radeon Software version"
#define AF_STR_SystemInformationCommandComputerPath L"Computer Path"
#define AF_STR_SystemInformationCommandNumberOfMonitors L"Number of Monitors"
#define AF_STR_SystemInformationCommandPrimaryMonitorName L"Primary Monitor Name"
#define AF_STR_SystemInformationCommandScreenResolution L"Screen Resolution"
#define AF_STR_SystemInformationCommandRendererVendor L"Renderer Vendor"
#define AF_STR_SystemInformationCommandRendererName L"Renderer Name"
#define AF_STR_SystemInformationCommandRendererVersion L"Renderer Version"
#define AF_STR_SystemInformationCommandShadingLanguageVersion L"Shading Language Version"
#define AF_STR_SystemInformationCommandRendererType L"Renderer Type"
#define AF_STR_SystemInformationCommandShadingLanguageUpdateError L"rcSLan"
#define AF_STR_SystemInformationCommandInstallableClient L"Installable client"
#define AF_STR_SystemInformationCommandHardwareRenderer L"Hardware renderer"
#define AF_STR_SystemInformationCommandMiniClient L"Mini client"
#define AF_STR_SystemInformationCommandGenericOpenGLSoftwareRenderer L"Generic OpenGL software renderer"
#define AF_STR_SystemInformationCommandSoftwareRenderer L"Software renderer"
#define AF_STR_SystemInformationCommandDBuff L"D buff"
#define AF_STR_SystemInformationCommandZBuff L"Z buff"
#define AF_STR_SystemInformationCommandStBuff L"St buff"
#define AF_STR_SystemInformationCommandColorBits L"Color bits"
#define AF_STR_SystemInformationCommandRBits L"R bits"
#define AF_STR_SystemInformationCommandGBits L"G bits"
#define AF_STR_SystemInformationCommandBBits L"B bits"
#define AF_STR_SystemInformationCommandABits L"A bits"
#define AF_STR_SystemInformationCommandAccBuff L"Acc buff"
#define AF_STR_SystemInformationCommandGDI L"GDI"
#define AF_STR_SystemInformationCommandStereo L"Stereo"
#define AF_STR_SystemInformationCommandHardware L"Hardware"
#define AF_STR_SystemInformationCommandPixelType L"Pixel type"
#define AF_STR_SystemInformationCommandColorIndex L"Color Index"
#define AF_STR_SystemInformationCommandExtensionName L"Extension name"
#define AF_STR_SystemInformationCommandExtensions L"Extensions"
#define AF_STR_SystemInformationCommandParameter L"Parameter"
#define AF_STR_SystemInformationCommandVendor L"Vendor"
#define AF_STR_SystemInformationCommandVersion L"Version"
#define AF_STR_SystemInformationCommandProfile L"Profile"
#define AF_STR_SystemInformationCommandPlatformID L"Platform ID"
#define AF_STR_SystemInformationCommandDeviceType L"Device Type"
#define AF_STR_SystemInformationCommandDeviceName L"Device Name"
#define AF_STR_SystemInformationCommandCommandQueueProperties L"Command Queue Properties"
#define AF_STR_SystemInformationCommandMaxGlobalVariableSize L"Max Global Variable Size"
#define AF_STR_SystemInformationCommandGlobalVariablePreferredTotalSize L"Global Variable Preferred Total Size"
#define AF_STR_SystemInformationCommandQueueOnDeviceProperties L"Queue On Device Properties"
#define AF_STR_SystemInformationCommandQueueOnDevicePreferredSize L"Queue On-Device Preferred Size"
#define AF_STR_SystemInformationCommandQueueOnDeviceMaxSize L"Queue On-Device Max Size"
#define AF_STR_SystemInformationCommandMaxOnDeviceQueues L"Max On-Device Queues"
#define AF_STR_SystemInformationCommandMaxOnDeviceEvents L"Max On-Device Events"
#define AF_STR_SystemInformationCommandSVMCapabilities L"Shared Virtual Memory Capabilities"
#define AF_STR_SystemInformationCommandMaxPipeArgs L"Max Pipe Args"
#define AF_STR_SystemInformationCommandPipeMaxActiveReservations L"Pipe Max Active Reservations"
#define AF_STR_SystemInformationCommandPipeMaxPacketSize L"Pipe Max Packet Size"
#define AF_STR_SystemInformationCommandPreferredPlatformAtomicAlignment L"Preferred Platform Atomic Alignment"
#define AF_STR_SystemInformationCommandPreferredGlobalAtomicAlignment L"Preferred Global Atomic Alignment"
#define AF_STR_SystemInformationCommandPreferredLocalAtomicAlignment L"Preferred Local Atomic Alignment"
#define AF_STR_SystemInformationCommandAddressBits L"Address Bits"
#define AF_STR_SystemInformationCommandIsAvailable L"Is Available"
#define AF_STR_SystemInformationCommandIsCompilerAvailable L"Is Compiler Available"
#define AF_STR_SystemInformationCommandSingleFPConfig L"Single FP Config"
#define AF_STR_SystemInformationCommandDoubleFPConfig L"Double FP Config"
#define AF_STR_SystemInformationCommandHalfFPConfig L"Half FP Config"
#define AF_STR_SystemInformationCommandIsLittleEndian L"Is Little Endian"
#define AF_STR_SystemInformationCommandErrorCorrectionSupport L"Error Correction Support"
#define AF_STR_SystemInformationCommandExecutionCapabilities L"Execution Capabilities"
#define AF_STR_SystemInformationCommandGlobalMemoryCacheSize L"Global Memory Cache Size"
#define AF_STR_SystemInformationCommandMemoryCacheType L"Memory Cache Type"
#define AF_STR_SystemInformationCommandGlobalMemoryCacheLineSize L"Global Memory Cache Line Size"
#define AF_STR_SystemInformationCommandGlobalMemorySize L"Global Memory Size"
#define AF_STR_SystemInformationCommandAreImageSupported L"Are Images Supported"
#define AF_STR_SystemInformationCommandHostUnifiedMemory L"Host Unified Memory"
#define AF_STR_SystemInformationCommandMaxImage2DDimensions L"Max Image 2D Dimensions"
#define AF_STR_SystemInformationCommandMaxImage3DDimensions L"Max Image 3D Dimensions"
#define AF_STR_SystemInformationCommandLocalMemorySize L"Local Memory Size"
#define AF_STR_SystemInformationCommandLocalMemoryType L"Local Memory Type"
#define AF_STR_SystemInformationCommandMaxClockFrequency L"Max Clock Frequency"
#define AF_STR_SystemInformationCommandMaxComputeUnits L"Max Compute Units"
#define AF_STR_SystemInformationCommandMaxConstantArguments L"Max Constant Arguments"
#define AF_STR_SystemInformationCommandMaxConstantBufferSize L"Max Constant Buffer Size"
#define AF_STR_SystemInformationCommandMaxMemoryAllocationSize L"Max Memory Allocation Size"
#define AF_STR_SystemInformationCommandMaxParameterSize L"Max Parameter Size"
#define AF_STR_SystemInformationCommandReadImageArguments L"Read Image Arguments"
#define AF_STR_SystemInformationCommandMaxSamplers L"Max Samplers"
#define AF_STR_SystemInformationCommandMaxWorkgroupSize L"Max Workgroup Size"
#define AF_STR_SystemInformationCommandMaxWorkItemDimensions L"Max Work Item Dimensions"
#define AF_STR_SystemInformationCommandMaxWorkItemSizes L"Max Work Item Sizes"
#define AF_STR_SystemInformationCommandMaxWriteImageArguments L"Max Write Image Arguments"
#define AF_STR_SystemInformationCommandMaxReadWriteImageArguments L"Max Read-Write Image Arguments"
#define AF_STR_SystemInformationCommandMemoryBaseAddressAlignment L"Memory Base Address Alignment"
#define AF_STR_SystemInformationCommandMinimalDataTypeAlignmentSize L"Minimal Data Type Alignment Size"
#define AF_STR_SystemInformationCommandOpenCLCVersion L"OpenCL C Version"
#define AF_STR_SystemInformationCommandNativeCharVectorWidth L"Native Char Vector Width"
#define AF_STR_SystemInformationCommandNativeShortVectorWidth L"Native Short Vector Width"
#define AF_STR_SystemInformationCommandNativeIntVectorWidth L"Native Int Vector Width"
#define AF_STR_SystemInformationCommandNativeLongVectorWidth L"Native Long Vector Width"
#define AF_STR_SystemInformationCommandNativeFloatVectorWidth L"Native Float Vector Width"
#define AF_STR_SystemInformationCommandNativeDoubleVectorWidth L"Native Double Vector Width"
#define AF_STR_SystemInformationCommandNativeHalfVectorWidth L"Native Half Vector Width"
#define AF_STR_SystemInformationCommandPreferredCharVectorWidth L"Preferred Char Vector Width"
#define AF_STR_SystemInformationCommandPreferredShortVectorWidth L"Preferred Short Vector Width"
#define AF_STR_SystemInformationCommandPreferredIntVectorWidth L"Preferred Int Vector Width"
#define AF_STR_SystemInformationCommandPreferredLongVectorWidth L"Preferred Long Vector Width"
#define AF_STR_SystemInformationCommandPreferredFloatVectorWidth L"Preferred Float Vector Width"
#define AF_STR_SystemInformationCommandPreferredDoubleVectorWidth L"Preferred Double Vector Width"
#define AF_STR_SystemInformationCommandPreferredHalfVectorWidth L"Preferred Half Vector Width"
#define AF_STR_SystemInformationCommandProfilingTimerResolution L"Profiling Timer Resolution"
#define AF_STR_SystemInformationCommandVendorID L"Vendor ID"
#define AF_STR_SystemInformationCommandCpuFamily L"CPU Family"
#define AF_STR_SystemInformationCommandPipePrefix L"AMDT_SI_PIPE_NAME"
#define AF_STR_SystemInformationCommandHelper32Name L"CXLSystemInformationHelper"
#define AF_STR_SystemInformationCommandHelper64Name L"CXLSystemInformationHelper-x64"
#define AF_STR_SystemInformationCommandTimeOut L"System Information gathering timed out after 10s"

// Context Information dialog
#define AF_STR_ContextsInformationDialogTitle L"Context Information"
#define AF_STR_ContextsInformationDialogSaveButton L"&Save"
#define AF_STR_ContextsInformationDialogStatus L"Status: "
#define AF_STR_ContextsInformationDialogStatusActive L"Active"
#define AF_STR_ContextsInformationDialogStatusDeleted L"Deleted"
#define AF_STR_ContextsInformationDialogStatusShared L", Shared"
#define AF_STR_ContextsInformationDialogStatusUsingShare L", Using Share"
#define AF_STR_ContextsInformationDialogMarkedForDeletion L"Marked for Deletion"
#define AF_STR_ContextsInformationDialogOpenGLVersion L"OpenGL Version"
#define AF_STR_ContextsInformationDialogOpenGLESVersion L"OpenGL ES Version"
#define AF_STR_ContextsInformationDialogShadingLangVersion L"Shading Language Version"
#define AF_STR_ContextsInformationDialogGLSharedContext L"OpenGL Shared Context"
#define AF_STR_ContextsInformationDialogGLSharingContexts L"OpenGL Sharing Contexts"
#define AF_STR_ContextsInformationDialogCLSharedContexts L"OpenCL Shared Context"
#define AF_STR_ContextsInformationDialogGLRendererTitle L"OpenGL Renderer"
#define AF_STR_ContextsInformationDialogRendererVendor L"Renderer Vendor"
#define AF_STR_ContextsInformationDialogRendererName L"Renderer Name"
#define AF_STR_ContextsInformationDialogRendererVersion L"Renderer Version"
#define AF_STR_ContextsInformationDialogRendererType L"Renderer Type"
#define AF_STR_ContextsInformationDialogIsBackwardCompatible L"Is Backward-Compatible"
#define AF_STR_ContextsInformationDialogIsForewardCompatible L"Is Forward-Compatible"
#define AF_STR_ContextsInformationDialogIsDebugContext L"Is Debug Context"
#define AF_STR_ContextsInformationDialogCodeXLForced L" (CodeXL forced)"
#define AF_STR_ContextsInformationDialogPixelFormatInfoHeader L"Pixel Format Information"
#define AF_STR_ContextsInformationDialogPixelFormatId L"Pixel Format ID"
#define AF_STR_ContextsInformationDialogHardwareAcceleration L"Hardware Acceleration"
#define AF_STR_ContextsInformationDialogDoubleBuffered L"Double-Buffered"
#define AF_STR_ContextsInformationDialogStereographic L"Stereographic"
#define AF_STR_ContextsInformationDialogSupportsNative L"Supports Native Rendering (GDI)"
#define AF_STR_ContextsInformationDialogSupportsNativeShort L"Native Rendering"
#define AF_STR_ContextsInformationDialogChannelHeader L"Channel"
#define AF_STR_ContextsInformationDialogBitsHeader L"Bits"
#define AF_STR_ContextsInformationDialogIndexChannel L"Index"
#define AF_STR_ContextsInformationDialogRedChannel L"Red"
#define AF_STR_ContextsInformationDialogGreenChannel L"Green"
#define AF_STR_ContextsInformationDialogBlueChannel L"Blue"
#define AF_STR_ContextsInformationDialogAlphaChannel L"Alpha"
#define AF_STR_ContextsInformationDialogDepthChannel L"Depth"
#define AF_STR_ContextsInformationDialogStencilChannel L"Stencil"
#define AF_STR_ContextsInformationDialogAccumulationChannel L"Accumulation"
#define AF_STR_ContextsInformationDialogChooseAContext L"Choose a render / compute context to view its information"
#define AF_STR_ContextsInformationDialogCouldNotGetInfo L"Could not get context information"
#define AF_STR_ContextsInformationDialogGPUAffinity L"GPU Affinities"
#define AF_STR_ContextsInformationDialogGPUAffinityGPUName L"GPU %d (%ls)"
#define AF_STR_ContextsInformationDialogGPUAffinityNotSupported L"GPU Affinity information is not supported on this hardware"
#define AF_STR_ContextsInformationDialogSaveInfoFileHeaderAppNameDateAndTime L"////////////////////////////////////////////////////////////\n" \
    L"// This File contains %ls information\n" \
    L"// Project name: %ls\n" \
    L"// Generation date: %ls\n" \
    L"// Generation time: %ls\n"
#define AF_STR_ContextsInformationDialogSaveInfoFileHeader1 L"// %ls %d ("
#define AF_STR_ContextsInformationDialogSaveInfoFileHeader2 L")\n" \
    L"//\n" \
    L"// Generated by CodeXL - an OpenCL and OpenGL Debugger, Profile and Analyzer\n" \
    L"// http://gpuopen.com/\n" \
    L"////////////////////////////////////////////////////////////\n\n"
#define AF_STR_ContextsInformationDialogSaveInfoFileAlignString L"%-24s "
#define AF_STR_ContextsInformationDialogSaveInfoFileGeneralHeader L"\nGeneral\n-------\n"
#define AF_STR_ContextsInformationDialogSaveInfoFilePixelFormatInfoHeader L"\nPixel Format Information\n------------------------\n"
#define AF_STR_ContextsInformationDialogSaveInfoFileChannelHeader L"Channel"
#define AF_STR_ContextsInformationDialogSaveInfoFileBitsHeader L"Bits"
#define AF_STR_ContextsInformationDialogSaveInfoFileGPUAffinity L"\nGPU Affinities\n--------------\n"
#define AF_STR_ErrorMessageSaveContextInformationFailed L"Could not save context information"
#define AF_STR_ContextsInformationDialogAvailableOnProcessSuspensionMessage  L"Context information is available only when debugged process is suspended"
#define AF_STR_ContextsInformationDialogDriversTitle L"Drivers versions"
#define AF_STR_ContextsInformationDialogDriversCALVersion L"CAL version"
#define AF_STR_ContextsInformationDialogDriversCatalystVersion L"AMD Radeon Software version"
#define AF_STR_ContextsInformationsDialogDevices L"Context Devices"
#define AF_STR_ContextsInformationsDialogDevicesUnderline L"==============="
#define AF_STR_ContextsInformationsDialogDeviceHeader L"Device %d"
#define AF_STR_ContextsInformationsDialogDeviceHeaderUnderline L"---------"
#define AF_STR_ContextsInformationsDialogDeviceId L"Device Id"
#define AF_STR_ContextsInformationsDialogDeviceType L"Device Type"
#define AF_STR_ContextsInformationsDialogDeviceName L"Device Name"
#define AF_STR_ContextsInformationsDialogDeviceVersion L"Device Version"
#define AF_STR_ContextsInformationsDialogDeviceVendor L"Device Vendor"
#define AF_STR_SendErrorReportString7 L"System DLL Versions:"
#define AF_STR_SendErrorReportAdditionalStringHeader "Additional Information:"
#define AF_STR_SendErrorReportAdditionalStringOpenCL "- OpenCL Engine loaded:"
#define AF_STR_SendErrorReportAdditionalStringOpenGL "- OpenGL Engine loaded:"
#define AF_STR_SendErrorReportAdditionalStringKernel "- Kernel Debugging Entered:"

// afSourceCodeView:
#define AF_STR_SourceCodeDeleteBreakpoint "Delete Breakpoint"
#define AF_STR_SourceCodeEnableBreakpoint "Enable Breakpoint"
#define AF_STR_SourceCodeDisableBreakpoint "Disable Breakpoint"
#define AF_STR_SourceCodeTextWasNotFound L"The specified text was not found: "
#define AF_STR_SourceCodePassedEndOfDocument L"Passed the end of the document"
#define AF_STR_SourceCodeAddWatch "Add Watch"
#define AF_STR_sourceCodeShowLineNumbers "Show Line Numbers"
#define AF_STR_sourceCodeSaveAs "Save as"


// Teapot strings files:
// Application file paths
// NOTE: rgorton - 6-April-2012
//  Be careful about changing these directory names, even to changing
//  the case - they are tightly tied to the packaging/installation, and
//  also to the underlying filesystem.  These now match the physical
//  directory names on disk in the source tree.
#define AF_STR_CodeXLImagesDirName L"Images"
#define AF_STR_CodeXLTeapotExampleProjectName L"CodeXL Teapot"

#define AF_STR_CodeXLTeapotExampleSourceFileFolder1 L"AMDTTeapot"
#define AF_STR_CodeXLTeapotExampleSourceFileFolder2 L"AMDTTeapotLib"
#define AF_STR_CodeXLTeapotExampleSrcFolder L"src"
#if AMDT_BUILD_TARGET == AMDT_WINDOWS_OS
    #define AF_STR_CodeXLTeapotExampleBinaryName L"CXLTeaPot"
    #define AF_STR_CodeXLSampleBinaryExtension L"exe"
    #define AF_STR_CODEXLExampleReleaseDirName L"Release"
#elif AMDT_BUILD_TARGET == AMDT_LINUX_OS
    #define AF_STR_CodeXLTeapotExampleBinaryName L"CXLTeaPot-bin"
    #define AF_STR_CodeXLSampleBinaryExtension L""
    #define AF_STR_CODEXLExampleReleaseDirName L"release"
#endif
#define AF_STR_CodeXLTeapotLastMode L"Debug Mode"
#if AMDT_BUILD_TARGET == AMDT_LINUX_OS
    // The scons build layout puts content into debug rather than debug/bin
    #define AF_STR_CodeXLTeapotDebugBinDirName L"debug"
#else
    #define AF_STR_CodeXLTeapotDebugBinDirName L"Debug\\Bin"
#endif
#define AF_STR_CodeXLSampleResourcesDirName L"res"
#define AF_STR_CodeXLWindowsHelpFileName L"CodeXL_User_Guide.chm"
#define AF_STR_CodeXLDialogSmallLogoFileName L"CodeXLDialogSmallLogo.png"
#define AF_STR_CodeXLAboutLogoFileName L"CodeXLAboutLogo.png"
#define AF_STR_CheckForUpdatesIconFileName L"CheckForUpdates.png"
#define AF_STR_CodeXLVSPackageWindowsHelpFileName L"CodeXL_User_Guide.chm"
#define AF_STR_CodeXLWindowsTutorialFileName L"CodeXLTutorial"
#define AF_STR_CodeXLWindowTeapotSolutionName L"AMDTTeaPot%ls.sln"
#define AF_STR_VS2010 L"VS2010"
#define AF_STR_VS2012 L"VS2012"
#define AF_STR_VS2013 L"VS2013"
#define AF_STR_VS2015 L"VS2015"
#define AF_STR_OldSampleProjectQuestion "The project contains a CodeXL sample with a path that no longer exists. Do you want to relocate the sample path to the new CodeXL samples location?"

/// Samples source file names
#define AF_STR_TeapotSrc1 "amdtmainwin.cpp"
#define AF_STR_TeapotSrc2 "amdtteapot.cpp"
#define AF_STR_TeapotSrc3 "teapot.cpp"
#define AF_STR_TeapotSrc4 "glwindow.cpp"
#define AF_STR_TeapotSrc5 "amdtteapotoglcanvas.cpp"
#define AF_STR_TeapotSrc6 "amdtteapotrenderstate.cpp"
#define AF_STR_TeapotSrc7 "amdtteapotoclsmokesystem.cpp"
#define AF_STR_TeapotSrc8 "amdtopenglmath.cpp"
#define AF_STR_TeapotSrc9 "amdtfluidgrid.cpp"
#define AF_STR_TeapotSrc10 "amdtimage.cpp"
#define AF_STR_TeapotSrc11 "amdtopenclhelper.cpp"
#define AF_STR_TeapotSrc12 "amdtopenglhelper.cpp"
#define AF_STR_TeapotSrc13 "amdtgtkmain.cpp"
#define AF_STR_TeapotSrc14 "amdtmainwin.h"
#define AF_STR_TeapotSrc15 "amdtmisc.h"
#define AF_STR_TeapotSrc16 "amdtteapot.h"
#define AF_STR_TeapotSrc17 "amdtteapotsmokesimulationveclength.h"
#define AF_STR_TeapotSrc18 "amdtteapotsmokesimulationvecfield.h"
#define AF_STR_TeapotSrc19 "amdtteapotsmokesimulationvec.h"
#define AF_STR_TeapotSrc20 "amdtteapotsmokesimulationscalarfield.h"
#define AF_STR_TeapotSrc21 "amdtteapotsmokesimulationindex.h"
#define AF_STR_TeapotSrc22 "amdtteapotsmokesimulationgen.h"
#define AF_STR_TeapotSrc23 "amdtteapotsmokesimulationclamp.h"
#define AF_STR_TeapotSrc24 "amdtteapotsmokesimulation.h"
#define AF_STR_TeapotSrc25 "gremedyglextensions.h"
#define AF_STR_TeapotSrc26 "gremedyclextensions.h"
#define AF_STR_TeapotSrc27 "amdtteapotmenubar.h"
#define AF_STR_TeapotSrc28 "amdtteapotoclsmokesystem.h"
#define AF_STR_TeapotSrc29 "amdtteapotoglcanvas.h"
#define AF_STR_TeapotSrc30 "amdtteapotoglcanvasstresstest.h"
#define AF_STR_TeapotSrc31 "amdtteapotrenderstate.h"
#define AF_STR_TeapotSrc32 "amdttimer.h"
#define AF_STR_TeapotSrc33 "amdtopenglhelper.h"
#define AF_STR_TeapotSrc34 "amdtopenglmath.h"
#define AF_STR_TeapotSrc35 "amdtteapotapp.h"
#define AF_STR_TeapotSrc36 "amdtteapotconstants.h"
#define AF_STR_TeapotSrc37 "amdtteapotframe.h"
#define AF_STR_TeapotSrc38 "amdtfluidgrid.h"
#define AF_STR_TeapotSrc39 "amdtimage.h"
#define AF_STR_TeapotSrc40 "amdtopenclhelper.h"



// Generic Context menu items that doesn't appear in the menu bar
#define AF_STR_DeleteSelected L"&Delete Selected\t" AF_STR_keyboardShortcutDeleteMenu
#define AF_STR_DeleteSelectedA "&Delete Selected\t" AF_STR_keyboardShortcutDeleteMenuA
#define AF_STR_SelectAll L"Select &All\t" AF_STR_keyboardShortcutSelectAllMenu
#define AF_STR_SelectAllA "Select &All\t" AF_STR_keyboardShortcutSelectAllMenuA
#define AF_STR_ExportToCSV "&Export to CSV"
#define AF_STR_ShowLineNumbers L"Show &Line Numbers\t"
#define AF_STR_contextSaveStateVariables "Export State Variables Snapshot..."
#define AF_STR_contextSaveFunctionCallsStatistics L"&Export Function Calls Statistics..."
#define AF_STR_contextSaveProfilingData L"&Export Profiling Data..."
#define AF_STR_SelectAllDifferent L"Select All Items with Different Values"

// Main application flow:
#define AF_STR_beforeExitQuestion "Do you want to stop %1?"
#define AF_STR_HelpFileLoadErrorMessage "Could not load the help file"
#define AF_STR_TutorialFileLoadErrorMessage "Could not load the tutorial file"
#define AF_STR_QuickStartFileLoadErrorMessage "Could not load the Quick Start Guide file"
#define AF_STR_exitWithoutSaving L"The project could not be saved, quit anyway?"
#define AF_STR_TeapotSampleDoesNotExist "The Teapot Sample project does not exist."

// File dialog strings:
#if AMDT_BUILD_TARGET == AMDT_WINDOWS_OS
    #define AF_STR_executableFilesDetails "Program Files (*.exe);;All files (*.*)"
#else
    #define AF_STR_executableFilesDetails "All files (*)"
#endif
#define AF_STR_macProgramFilesDetails L"Applications (*.app);;All files (*.*)"
#define AF_STR_iPhoneOnDeviceProgramFilesDetails L"Xcode projects (*.xcodeproj);;All files (*.*)"
#define AF_STR_allFileDetails "All files (*)"
#define AF_STR_sourceFileDetails "Source Files (*.cl *.c *.cpp *.cxx *.cc *.h *.hpp *.hxx *.hh *.cs)"
#define AF_STR_textFileDetails "Text Files (*.txt)"
#define AF_STR_systemInformationFileTitle "Save System Information as"
#define AF_STR_systemInformationFileSample L"SystemInformation.txt"
#define AF_STR_systemInformationFileDetails "Text Documents (*.txt)"
#define AF_STR_saveDataDialogHeader L"Save Data as"
#define AF_STR_saveDataDialogHeaderA "Save Data as"
#define AF_STR_saveImageDialogHeader "Save Image as"
#define AF_STR_openFileDialogHeader L"Open File"
#define AF_STR_openFileDialogFailed L"Could not find the file specified."
#define AF_STR_saveFileDialogHeader L"Save File"
#define AF_STR_saveFileDialogNothingToSave L"There is nothing to save!"
#define AF_STR_openProjectDialogHeader "Open Project"
#define AF_STR_saveProjectDialogHeader "Save Project as"

// Splash screen:
#define AF_STR_SplashScreenFileName L"CodeXLSplashScreen" // Without extension
#define AF_STR_LogMsg_LoadingSplashScreen L"Loading splash screen"
#define AF_STR_LogMsg_FinishedLoadingSplashScreen L"Finished loading splash screen"

// Menu commands:

// HTML strings:
// General HTML:
#define AF_STR_HtmlTable2Padding L"<table width=100% cellspacing=3>"
#define AF_STR_HtmlTableTagEnd L"</table>"
#define AF_STR_HtmlTREnd L"</tr>"
#define AF_STR_HtmlTDEnd L"</td>"
#define AF_STR_HtmlFontTagStart L""
#define AF_STR_HtmlFontTagEnd L""
#define AF_STR_HtmlBoldTagStart L"<b>"
#define AF_STR_HtmlBoldTagEnd L"</b>"
#define AF_STR_HtmlBoldTagStartA "<b>"
#define AF_STR_HtmlBoldTagEndA "</b>"
#define AF_STR_HtmlNewLine L"<br />"
#define AF_STR_HtmlImage L"<IMG SRC=\"%ls\">"
#define AF_STR_HtmlImageWithSizeSpecifications L"<img SRC=\"%ls\" WIDTH=\"%d\" HEIGHT=\"%d\">"
#define AF_STR_HtmlImageWithSizeSpecsAndRightAlign L"<img SRC=\"%ls\" WIDTH=\"%d\" HEIGHT=\"%d\" STYLE=\"float:right;\">"
#define AF_STR_HtmlImage2 L"<IMG src=\"%ls\" alt=\"%ls\" align=middle border=0 valign=bottom />"
#define AF_STR_HtmlColorWhite L"FFFFFF"
#define AF_STR_HtmlEmptyLine L"<br>"
#define AF_STR_HtmlQuot L"&quot;"
#define AF_STR_HtmlNBSP "&nbsp;"

#define AF_STR_propertiesViewCaption L"Properties"
#define AF_STR_propertiesViewCommandName L"&Properties"
#define AF_STR_informationViewCaption L"Output"
#define AF_STR_informationViewCommandName L"&Output"

#define AF_STR_HtmlNoSourceFoundFileName "NoSource"
#define AF_STR_HtmlFindSourceWebpageTitle L"No Source Available"
#define AF_STR_HtmlFindSourceWebpage "<!doctype html><html lang=\"eng\"><head><meta charset=\"utf-8\">"\
"<title>No Source Available</title><style>"\
"body{font-family: %1, clean, sans-serif;}h1{font-weight: bold;font-size: 1.5em;}</style>"\
"</head><body><h1>%2 was not found</h1><p>CodeXL requires the location of this file to display the source for the current call stack frame.</p><p><a href = \"FindSource-%3\">Click to locate the file %2</a></p></body></html>"

#define AF_STR_HtmlNoDebugInformationWebpage "<!doctype html><html lang=\"eng\"><head><meta charset=\"utf-8\"><title>No Debug Information</title>"\
"<style>body{font-family: %1, clean, sans-serif;}h1{font-weight: bold;font-size: 1.5em;}</style></head>"\
"<body><h1>No debug information available for file %2</h1></body></html>"

#define AF_STR_HtmlNoDebugInformationNoFileWebpage "<!doctype html><html lang=\"eng\"><head><meta charset=\"utf-8\"><title>No Debug Information</title>"\
"<style>body{font-family: \"Helvetica Neue\", clean, sans-serif;}h1{font-weight: bold;font-size: 1.5em;}</style>"\
            "</head><body><h1>No debug information available</h1><p>The debugged module does not contain debug information. Try to build it with debug information (-g) and restart debug session.</p><p>Module details: %1</p></body></html>"

#define AF_STR_HtmlFindSourceLink "FindSource"

// Execution mode HTML properties:
#define AF_STR_HtmlPropertiesTableRowStart L"<tr bgcolor=#F5F5F5><td>"
#define AF_STR_HtmlPropertiesTableRowStartWithHighlightAndColspan L"<tr bgcolor=#CCCCCC><td colspan=%u>"
#define AF_STR_HtmlPropertiesTableRowStartWithWeakHighlight L"<tr bgcolor=#E0E0E0><td>"
#define AF_STR_HtmlPropertiesTableRowStartWithRowspan L"<tr bgcolor=#F5F5F5><td rowspan=%u valign=center>"
#define AF_STR_HtmlPropertiesTableRowStartWithRowspanAlignTop L"<tr bgcolor=#F5F5F5><td rowspan=%u valign=top>"
#define AF_STR_HtmlPropertiesTableRowStartWithColspan L"<tr bgcolor=#F5F5F5><td colspan=%u>"
#define AF_STR_HtmlPropertiesTableColEnd L"</td><td>"
#define AF_STR_HtmlPropertiesTableColEndHighlightedCell L"</td><td bgcolor=#cccccc>"
#define AF_STR_HtmlPropertiesTableRowEnd L"</td></tr>"
#define AF_STR_HtmlPropertiesLeftTagStart L"<left>"
#define AF_STR_HtmlPropertiesLeftTagEnd L"</left>"
#define AF_STR_HtmlPropertiesRightTagStart L"<tr><td align=right>"
#define AF_STR_HtmlPropertiesThumbnailFileNameSuffix L"-thumb"
#define AF_STR_HtmlPropertiesNonbreakingSpace L"&nbsp;"
#define AF_STR_HtmlPropertiesFunctionArgumentsListStart L"<b>(</b>"
#define AF_STR_HtmlPropertiesFunctionArgumentsListEnd L"<b>)</b>"
#define AF_STR_HtmlPropertiesTotal L"<b>Total: </b>"
#define AF_STR_HtmlPropertiesFontHeaderCommentTagStart L"<font SIZE=+1>"
#define AF_STR_HtmlPropertiesFontHeaderCommentTagEnd L"</font>"

#define AF_STR_HtmlPropertiesFontHeaderTagStart L"<b>"
#define AF_STR_HtmlPropertiesFontHeaderTagEnd L"</B><BR /><BR />"

#define AF_STR_HtmlPropertiesLink1ParamStart L"<a HREF='%ls-%d'>"
#define AF_STR_HtmlPropertiesLink2ParamStart L"<a HREF='%ls-%d-%d'>"
#define AF_STR_HtmlPropertiesLink3ParamStart L"<a HREF='%ls-%d-%d-%d'>"

#define AF_STR_HtmlPropertiesLinkHREF1ParamStart L"%ls-%d"
#define AF_STR_HtmlPropertiesLinkHREF2ParamStart L"%ls-%d-%d"
#define AF_STR_HtmlPropertiesLinkHREF3ParamStart L"%ls-%d-%d-%d"
#define AF_STR_HtmlMultipleItemsCaption L"Multiple Items Selection in Tree"
#define AF_STR_HtmlMultipleItems L"Multiple tree items selected. Select a single item to display it's properties."

// Image names:
#define AF_STR_WarningYellowIconFileName L"WarningIconYellow.png"
#define AF_STR_WarningYellowIconSmallFileName L"WarningIconYellowSmall.png"
#define AF_STR_WarningOrangeIconFileName L"WarningIconOrange.png"
#define AF_STR_WarningOrangeIconSmallFileName L"WarningIconOrangeSmall.png"
#define AF_STR_WarningRedIconFileName L"WarningIconRed.png"
#define AF_STR_WarningRedIconSmallFileName L"WarningIconRedSmall.png"
#define AF_STR_LightBulbSmallFileName L"LightBulbIconSmall.png"
#define AF_STR_InformationIconFileName L"InformationIcon.png"
#define AF_STR_InformationIconSmallFileName L"InformationIconSmall.png"
#define AF_STR_ShadingProgramFileName L"ShadingProgramIcon.png"
#define AF_STR_pngFileExt L"png"

// Execution mode manager strings
#define AF_STR_APIStepDebugging "API Step (" AF_STR_APIStepDebuggingShortcut ")"
#define AF_STR_DrawStepDebugging "Draw Step (" AF_STR_DrawStepDebuggingShortcut ")"
#define AF_STR_FrameStepDebugging "Frame Step (" AF_STR_FrameStepDebuggingShortcut ")"
#define AF_STR_StepOverDebugging "Step Over (" AF_STR_StepOverDebuggingShortcut ")"
#define AF_STR_StepInDebugging "Step In (" AF_STR_StepInDebuggingShortcut ")"
#define AF_STR_StepOutDebugging "Step Out (" AF_STR_StepOutDebuggingShortcut ")"
#define AF_STR_BreakDebugging "Break (" AF_STR_PauseDebuggingShortcut ")"
#define AF_STR_PauseProfiling "Pause (" AF_STR_PauseDebuggingShortcut ")"
#define AF_STR_StopDebugging "Stop (" AF_STR_StopDebuggingShortcut ")"
#define AF_STR_Start "Start (" AF_STR_StartDebuggingShortcut ")"
#define AF_STR_StartTooltip "Start %1 (" AF_STR_StartDebuggingShortcut ")"
#define AF_STR_Build "Build (" AF_STR_BuildShortcut ")"
#define AF_STR_CancelBuild "Cancel Build (" AF_STR_CancelBuildShortcut ")"
#define AF_STR_StartDebuggingShortcut "F5"
#define AF_STR_PauseDebuggingShortcut "F6"
#define AF_STR_StopDebuggingShortcut "Shift+F5"
#define AF_STR_APIStepDebuggingShortcut "Ctrl+F10"
#define AF_STR_DrawStepDebuggingShortcut "Ctrl+Shift+F10"
#define AF_STR_FrameStepDebuggingShortcut "Ctrl+F11"
#define AF_STR_StepOverDebuggingShortcut "F10"
#define AF_STR_StepInDebuggingShortcut "F11"
#define AF_STR_StepOutDebuggingShortcut "Shift+F11"
#define AF_STR_BuildShortcut "F7"
#define AF_STR_CancelBuildShortcut "Shift+F7"


// Item identification:
#define AF_STR_ItemIDUnknown L"Unknown item"
#define AF_STR_AppRoot L"Application Root"
#define AF_STR_GLContext L"GL Context"
#define AF_STR_GLTextures L"Textures"
#define AF_STR_GLTexture L"Texture"
#define AF_STR_GLRenderBuffers L"Render Buffers"
#define AF_STR_GLRenderBuffer L"Render Buffer"
#define AF_STR_GLStaticBuffers L"Static Buffers"
#define AF_STR_GLStaticBuffer L"Static Buffer"
#define AF_STR_GLAllPBuffers L"All PBuffers"
#define AF_STR_GLPBuffers L"PBuffers"
#define AF_STR_GLPBuffer L"PBuffer"
#define AF_STR_GLPBufferStaticBuffer L"PBuffer Static Buffer"
#define AF_STR_GLSyncs L"Sync Objects"
#define AF_STR_GLSync L"Sync"
#define AF_STR_GLVBOs L"VBOs"
#define AF_STR_GLVBO L"VBO"
#define AF_STR_Programs L"Programs"
#define AF_STR_Program L"Program"
#define AF_STR_GLShaders L"Shaders"
#define AF_STR_GLVertexShader L"Vertex Shader"
#define AF_STR_GLTessellationControlShader L"Tessellation Control Shader"
#define AF_STR_GLTessellationEvaluationShader L"Tessellation Evaluation Shader"
#define AF_STR_GLGeometryShader L"Geometry Shader"
#define AF_STR_GLFragmentShader L"Fragment Shader"
#define AF_STR_GLComputeShader L"Compute Shader"
#define AF_STR_GLUnknownShader L"Shader"
#define AF_STR_GLDisplayLists L"Display Lists"
#define AF_STR_GLDisplayList L"Display List"
#define AF_STR_GLFBOs L"FBOs"
#define AF_STR_GLFBO L"FBO"
#define AF_STR_GLFBOAttachment L"FBO Attachemnt"
#define AF_STR_CLContext L"CL Context"
#define AF_STR_CLImages L"CL Images"
#define AF_STR_CLImage L"CL Image"
#define AF_STR_CLBuffers L"CL Buffers"
#define AF_STR_CLBuffer L"CL Buffer"
#define AF_STR_CLSubBuffer L"CL Sub Buffer"
#define AF_STR_CLPipes L"CL Pipes"
#define AF_STR_CLPipe L"CL Pipe"
#define AF_STR_CLSamplers L"CL Samplers"
#define AF_STR_CLSampler L"CL Sampler"
#define AF_STR_CLEvents L"CL Events"
#define AF_STR_CLEvent L"CL Event"
#define AF_STR_CLCommandQueues L"CL Command Queues"
#define AF_STR_CLCommandQueue L"CL Command Queue"
#define AF_STR_CLDevice L"CL Device"
#define AF_STR_CLKernel L"Kernel"
#define AF_STR_CLKernelVariable L"Kernel variable"
#define AF_STR_ProfileSession L"Profile session"
#define AF_STR_ProfileSessionType L"Profile session type"
#define AF_STR_ProfileSessionGPUSummary L"GPU Profile session summary"
#define AF_STR_ProfileSessionGPUAPISummary L"GPU Profile session API summary"
#define AF_STR_ProfileSessionGPUContextSummary  L"GPU Profile session context summary"
#define AF_STR_ProfileSessionGPUKernelSummary  L"GPU Profile session kernel summary"
#define AF_STR_ProfileSessionGPUTop10TransferSummary L"GPU Profile session top10 transfer summary"
#define AF_STR_ProfileSessionGPUTop10KernelsSummary L"GPU Profile session top10 kernel summary"
#define AF_STR_ProfileSessionGPUBestPracticeSummary L"GPU Profile session best practice summary"
#define AF_STR_ProfileSessionGPUKernels L"GPU Profile session kernels"
#define AF_STR_ProfileSessionGPUKernel L"GPU Profile session kernel"
#define AF_STR_AnalyzerExeFile L"Analyzer executable file"
#define AF_STR_AnalyzerOpenCLSource L"Analyzer OpenCL source code"
#define AF_STR_AnalyzerKernel L"Analyzer kernel"
#define AF_STR_AnalyzerStatistics L"Analyzer kernel statistics"
#define AF_STR_AnalyzerAnalysis L"Analyzer kernel analysis"
#define AF_STR_AnalyzerDevice L"Analyzer kernel device"
#define AF_STR_AnalyzerHistory L"Analyzer kernel history"

#if (AMDT_BUILD_TARGET == AMDT_WINDOWS_OS)
    #define AF_STR_AnalyzerFile L"Analyzer Kernel/DirectX file"
    #define AF_STR_AnalyzerAddFile L"Analyzer add existing OpenCL/DirectX file"
    #define AF_STR_AnalyzerNewFile L"Analyzer create new OpenCL/DirectX file"
#else // Building for Linux
    #define AF_STR_AnalyzerFile L"Analyzer Kernel file"
    #define AF_STR_AnalyzerAddFile L"Analyzer add existing OpenCL file"
    #define AF_STR_AnalyzerNewFile L"Analyzer create new OpenCL file"
#endif // AMDT_BUILD_TARGET == AMDT_WINDOWS_OS

// Images and buffers load status messages:
#define AF_STR_ImagesAndBuffersViewLoadFailure L"Object is currently unavailable"
#define AF_STR_ImagesAndBuffersViewImagesBuffersProcessIsRunning L"Textures, Buffers and Images information are only displayed when the debugged process has been suspended"
#define AF_STR_ImagesAndBuffersViewImagesBuffersProcessIsRunningTitle L"Process is running"
#define AF_STR_ImagesAndBuffersViewImagesBuffersProcessIsNotRunningTitle L"Process is not running"
#define AF_STR_ImagesAndBuffersViewVariablesProcessIsRunning L"Kernel variables information is only displayed when the debugged process has been suspended"

#define AF_STR_ImagesAndBuffersViewKernelIsNotDebuggedTitle L"Process is not in kernel debugging"
#define AF_STR_ImagesAndBuffersViewKernelInteroperabilityTitle L"CL-GL interoperability object"
#define AF_STR_ImagesAndBuffersViewKernelIsNotDebugged L"Kernel variables are displayed only when a kernel is being debugged"
#define AF_STR_ImagesAndBuffersViewKernelDebugged L"Images and buffers are not available when a kernel is being debugged"
#define AF_STR_ImagesAndBuffersViewObjectNotAvailable L"%ls is currently unavailable"
#define AF_STR_ImagesAndBuffersViewObjectsNotAvailable L"%ls are not currently available"
#define AF_STR_ImagesAndBuffersViewImageTypeUnknown L"Image type is unknown"
#define AF_STR_ImagesAndBuffersViewTextureTypeUnknown L"Texture type is unknown"
#define AF_STR_ImagesAndBuffersViewGLCLInterop L"CL-GL interoperability objects are currently not supported"
#define AF_STR_ImagesAndBuffersViewGLBeginEndMessage L"Images and buffers are unavailable while the process is in glBegin-glEnd block"
#define AF_STR_ImagesAndBuffersViewGLBeginEndTitle L"Process is in glBegin-glEnd block"
#define AF_STR_ImagesAndBuffersViewObjectUnavailableMessageHeader L"%ls is unavailable"
#define AF_STR_ImagesAndBuffersViewObjectUnavailableMessageTitle L"Item is unavailable"
#define AF_STR_ImagesAndBuffersViewVariableDoNotExistMessageTitle L"The variable doesn't exist in this context"
#define AF_STR_ImagesAndBuffersViewBoundToFBO L"Object is unavailble when an FBO is bound"
#define AF_STR_ImagesAndBuffersViewerNoObjectsAvailableMessage L"%ls Are Unavailable"

// CodeXL version XML file:
#define AF_STR_CodeXLVersionXMLFileName L"VersionSettings"
#define AF_STR_CodeXLVersionXMLVersionSettingsNodeName "VersionSettings"
#define AF_STR_CodeXLVersionXMLTitleCaptionNodeName "TitleCaption"
#define AF_STR_CodeXLVersionXMLCheckForNewVersionURLNodeName "CheckForNewVersionURL"

// HTML properties strings:
#define AF_STR_ProcessEventsViewPropertiesTitleProcessStarted L"Process Started"
#define AF_STR_ProcessEventsViewPropertiesTitleProcessStopped L"Process Stopped"
#define AF_STR_ProcessEventsViewExePath L"Executable Path"
#define AF_STR_ProcessEventsViewWorkDir L"Work Directory"
#define AF_STR_ProcessEventsViewStartTime L"Start Time"
#define AF_STR_ProcessEventsViewProcessExit L"Process Exit"
#define AF_STR_ProcessEventsViewExitCode L"Exit Code"
#define AF_STR_ProcessEventsViewExitTime L"Exit Time"
#define AF_STR_ProcessEventsViewCreationTime L"Creation Time"
#define AF_STR_ProcessEventsViewPropertiesTitleProcessCreated L"Process Created"

// Mdi sub Window
#define AF_STR_CopyFullPath "Copy Full Path"
#define AF_STR_OpenContaningFolder "Open Contaning Folder"

// Multi directory dialog:
#define AF_STR_MultiDirDialogCaption "Source Files Directories:"
#define AF_STR_MultiDirDialogTableHeader "Directories"
#define AF_STR_MultiDirDeleteTooltip "Delete Directory"
#define AF_STR_MultiDirNewTooltip "New Directory"
#define AF_STR_MultiDirUpTooltip "Move Directory Up"
#define AF_STR_MultiDirDownTooltip "Move Directory Down"

// Document update String
#define AF_STR_UpdateOutOfDate "%1\nThis file has been modified outside of this source editor tab.\nDo you want to reload it ?"

// Startup dialog:
#define AF_STR_StartupDialogCaption "CodeXL - No project loaded"
#define AF_STR_StartupDialogDescription "To start working with CodeXL, please select one of the following:"
#define AF_STR_StartupDialogDebugCaption "<font size=+1>DEBUG<font>"
#define AF_STR_StartupDialogProfileCaption "<font size=+1>PROFILE<font>"
#define AF_STR_StartupDialogAnalyzeCaption "<font size=+1>ANALYZE<font>"
#define AF_STR_StartupButtonTableHTML "<table cellpadding=0 cellspacing=0><tr><td style='vertical-align: middle;'><img src ='mydata://image.jpg' style='float:left;'></img></td><td style='padding-left:10px;'>%1</td></tr><table>"
#define AF_STR_StartupDialogButtonTableHTML "<table cellpadding=0 cellspacing=0><tr><td style='vertical-align: middle;'><img src ='mydata://image.jpg' style='float:left;'></img></td><td style='padding-left:10px;'>%1</td></tr><table>"
#define AF_STR_StartupDialogNewProjectTitle "Create new project"
#define AF_STR_StartupDialogNewProjectDescription "<br>After creating a new project you can select the desired mode to debug or profile your application,<br>or to statically analyze your shaders and kernels."
#define AF_STR_StartupDialogNewProjectDebuggingTitle "Create new project for Debugging"
#define AF_STR_StartupDialogNewProjectDebuggingDescription "<br>Debugging allows you to set breakpoints, watch variables and much more.<br>Automatically selects Debug mode."
#define AF_STR_StartupDialogNewProjectProfilingTitle "Create new project for Profiling"
#define AF_STR_StartupDialogNewProjectProfilingDescription "<br>Profile code that runs on the GPU. Select a session type to define what data is collected.<br>Automatically selects Profile mode."
#if (AMDT_BUILD_TARGET == AMDT_WINDOWS_OS)
    #define AF_STR_StartupDialogNewProjectAnalyzeTitle "Create a new source file for analysis"
    #define AF_STR_StartupDialogNewProjectAnalyzeDescription "<br>Create and build an OpenCL/DirectX kernel for multiple hardware targets and analyze the ISA result to gain insight into<br>optimizing its performance."
    #define AF_STR_StartupDialogAddCLFileAnalyzeTitle "Add an existing source file for Analysis"
    #define AF_STR_StartupDialogAddCLFileAnalyzeDescription "<br>Compile an OpenCL/DirectX file for multiple hardware targets and analyze the ISA result to gain insight into<br>optimizing its performance."
#else // Building for Linux
    #define AF_STR_StartupDialogNewProjectAnalyzeTitle "Create a new OpenCL/OpenGL file for Analysis"
    #define AF_STR_StartupDialogNewProjectAnalyzeDescription "<br>Create and Compile an OpenCL kernel for multiple hardware targets and analyze the ISA result to gain insight into<br>optimizing its performance."
    #define AF_STR_StartupDialogAddCLFileAnalyzeTitle "Add an existing OpenCL/OpenGL file for Analysis"
    #define AF_STR_StartupDialogAddCLFileAnalyzeDescription "<br>Compile an OpenCL file for multiple hardware targets and analyze the ISA result to gain insight into<br>optimizing its performance."
#endif // (AMDT_BUILD_TARGET == AMDT_WINDOWS_OS)

// Aid functions
#define AF_STR_AMD_GPU_COMPONENT_NOT_INSTALLED L"CodeXL GPU Profiler: An AMD GPU was not detected. Local GPU Profiling will be disabled.\n"
#define AF_STR_AMD_CATALYST_COMPONENT_NOT_INSTALLED L"CodeXL Static Analyzer: AMD Radeon Software was not detected. Static Analysis will be disabled.\n"
// Memory Error messages
#define AF_STR_memAllocFailureHeadline "CodeXL - Memory Allocation Failure"
#define AF_STR_memAllocFailureClientMsg "Insufficient memory in executed application."

// CSV export strings:
#define AF_STR_saveCSVFilePostfix ".csv"
#define AF_STR_csvFileDetails L"CSV (Comma delimited) (*.csv)"

/// History management tags. These tags are used for widgets and actions that support history management. afBrowseAction + afLineEdit.
#define AF_Str_NewProjectRemoteHostIPLineEdit "NewProjectRemoteHostIP"
#define AF_Str_NewProjectBrowseForEXE "NewProjectBrowseForEXE"
#define AF_Str_NewProjectBrowseForWorkingFolder "NewProjectBrowseForWorkingFolder"
#define AF_Str_NewProjectBrowseForSourceCodeFolder "NewProjectBrowseForSourceCodeFolder"
#define AF_Str_NewProjectBrowseForSourceCodeRootFolder "NewProjectBrowseForSourceCodeRootFolder"
#define AF_Str_OpenFileBrowseFolder "OpenFileBrowseFolder"

/// Progress bar strings:
#define AF_STR_ProgressMessageFormat L"%ls %ls..."

#define AF_Str_optionsDialogD3DCompileType L"D3D"

/// About dialog
#define AF_STR_HelpAboutLGPLCopyRightCaption "LGPL Components:"
#define AF_STR_HelpAboutLGPLCopyRightHeader "The GNU Lesser General Public License, version 2.1 (LGPL-2.1)\nGNU Lesser General Public License"
#define AF_STR_HelpAboutLGPLCopyRightBody "Copyright (C) 1991, 1999 Free Software Foundation, Inc.\n51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\nEveryone is permitted to copy and distribute verbatim copies\nof this license document, but changing it is not allowed.\nUse of the Qt library is governed by the GNU\nLesser General Public License version 2.1 (LGPL v 2.1)."

/// CodeXl Special Folders
#define AF_STR_CSV_FILE_CACHE  L"CSV_FILE_CACHE"
