#!/usr/local/bin/perl
#
# This program inputs a stream of output generated by gcc builds and filters the build
# output to be less verbous.
# Usage Example:
#  scons | perl BuildFilter.pl
#
# Author: Yaki Tebeka
# Date: 26/11/2008


# Iterate the standard input lines until reaching an EOF:
my $currentLine = <STDIN>; 
while ($currentLine)
{
	my $wasCurrentLineHandled = 0;
	
	# Split the current line to its tokens:
    my @lineTokens = split(/ /, $currentLine);
	
	# If the curren line is a compile / link line:
	if (($lineTokens[0] =~ /gcc$/) || ($lineTokens[0] =~ /g\+\+$/) || ($lineTokens[0] =~ /\/ld$/))
	{
		# If this is a dynamic module or an application link line:
		if (($currentLine =~ /-shared/) || ($currentLine =~ /-L/) || ($lineTokens[0] =~ /\/ld$/))
		{
			# Iterate the tokens, looking for the linked module name:
			# (Which appears after a "-o" token)
			my $linkedModuleName = "Unknown";
			my $foundModuleNameFlag = 0;
			foreach $currentToken (@lineTokens)
			{
				if ($foundModuleNameFlag)
				{
					$linkedModuleName = $currentToken;
					last;
				}
			
				if ($currentToken eq "-o")
				{
					$foundModuleNameFlag = 1;
				}
			}
			
			# Print a "Linking XX" line:
			print "Linking: $linkedModuleName\n";
			
			# Mark that the current line was handled:
			$wasCurrentLineHandled = 1;
		}
		else
		{
			# This is a compile line:
		
			# Get the compiled file:
			my $compiledFileName = pop(@lineTokens);
	        
			# Print a "Compiling XX" line:
			print "Compiling: $compiledFileName";
			
			# Mark that the current line was handled:
			$wasCurrentLineHandled = 1;
		}
	}
	elsif ($lineTokens[0] eq "ar")
	{
		# This is a static library link line:
	
		# Iterate the tokens, looking for the linked archive name:
		# (Which appears after a "r" or "rc" token)
		my $linkedArchiveName = "Unknown";
		my $foundArchiveNameFlag = 0;
		foreach $currentToken (@lineTokens)
		{
			if ($foundArchiveNameFlag)
			{
				$linkedArchiveName = $currentToken;
				last;
			}
		
			if (($currentToken eq "r") || ($currentToken eq "rc"))
			{
				$foundArchiveNameFlag = 1;
			}
		}
		
		# If we found the archive name:
		if ($foundArchiveNameFlag)
		{
			# Print a "Creating static archive XX" line:
			print "Creating static archive: $linkedArchiveName\n";
		
			# Mark that the current line was handled:
			$wasCurrentLineHandled = 1;	
		}
	}
	elsif ($lineTokens[0] eq "install_name_tool")
	{
		# This is an install name tool line:
		
		# Iterate the tokens, looking for the changed install name:
		# (Which appears after a "-change" token)
		my $changedInstallName = "Unknown";
		my $foundChangedInstallName = 0;
		foreach $currentToken (@lineTokens)
		{
			if ($foundChangedInstallName)
			{
				$changedInstallName = $currentToken;
				last;
			}
		
			if ($currentToken eq "-change")
			{
				$foundChangedInstallName = 1;
			}
		}
		
		# If we found the archive name:
		if ($foundChangedInstallName)
		{
			# Print a "Changing install name: XX" line:
			print "Changing install name: $changedInstallName\n";
		
			# Mark that the current line was handled:
			$wasCurrentLineHandled = 1;	
		}
	}
	elsif ($lineTokens[0] =~ /bin\/moc/)
	{
		print "Mocking: $lineTokens[1] \n";
		
		# Mark that the current line was handled:
			$wasCurrentLineHandled = 1;	
	}
    
    # If the current line was not handled - print it:
    if (!($wasCurrentLineHandled))
    {
        print "$currentLine";
    }
    
	# Get the next input line:
	$currentLine = <STDIN>;
}

