//==================================================================================
// Copyright (c) 2016 , Advanced Micro Devices, Inc.  All rights reserved.
//
/// \author AMD Developer Tools Team
/// \file gdDeprecationStringConstants.h
///
//==================================================================================

//------------------------------ gdDeprecationStringConstants.h ------------------------------

#ifndef __GDDEPRECATIONSTRINGCONSTANTS
#define __GDDEPRECATIONSTRINGCONSTANTS

// Deprecation Status Description:

#define GD_STR_DeprecationShaderName L"glShaderSource - Shader %d"

#define GD_STR_DeprecationFunctionCallMoreMessage L"<b>More deprecated functions are detected when using Analyze Mode.</b>"
#define GD_STR_DeprecationOpenGLES L"OpenGL ES does not define a deprecation model"

#define GD_STR_DeprecationWarning L"It is recommended to avoid using deprecated functions, as their compatibility with future OpenGL versions is not assured."
#define GD_STR_DeprecationReasonTitle L"<b>Deprecated Feature:</b>"
#define GD_STR_DeprecationHeader1 L"The function <b>%ls</b> was marked as deprecated in OpenGL version %ls and was removed from OpenGL at version %ls."
#define GD_STR_DeprecationHeader2 L"The function <b>%ls</b> was marked as deprecated in OpenGL version %ls and will be removed from OpenGL at a future version."
#define GD_STR_DeprecationApplicationGenNamesHeader L"The function <b>%ls</b> uses an object that was not generated by OpenGL. This feature was marked as deprecated in OpenGL version %ls and "
#define GD_STR_DeprecationPixelFormatHeader L"The function <b>%ls</b> uses a deprecated pixel format as one of its arguments."
#define GD_STR_DeprecationEdgeFlagHeaderPrefix L"The function <b>%ls</b> with is using parameter values related to fixed-function vertex processing or edge flags, which are deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationColorIndexHeaderPrefix L"The function <b>%ls</b> uses color index mode rendering. Color index mode rendering is deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationImmediateModeHeaderPrefix L"The function <b>%ls</b> is an immediate mode draw function. Immediate mode drawing is deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationDisplayListHeaderPrefix L"The function <b>%ls</b> is using an OpenGL display list related command. Display lists are deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationRectHeaderPrefix L"The function <b>%ls</b> is an OpenGL function that draws a rectangle. Drawing rectangles is deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationAttributeStackHeaderPrefix L"The function <b>%ls</b> is using an OpenGL attribute stack related command. Attribute stacks are deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationRasterPositionHeaderPrefix L"The function <b>%ls</b> is using an OpenGL raster position command which is deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationSeperatePolygonDrawModeHeaderPrefix L"The function <b>%ls</b> is using a seperate polygon face draw mode which is deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationPixelDrawHeaderPrefix L"The function <b>%ls</b> is using a pixel drawing command. Pixel drawing is deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationTextureClampWrapModeHeaderPrefix L"The function <b>%ls</b> is using a texture wrap mode (GL_CLAMP) which is deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationTextureAutoMipmapHeaderPrefix L"The function <b>%ls</b> is using texture mipmap levels auto generation which is deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationAlphaTestHeaderPrefix L"The function <b>%ls</b> is using the alpha test feature which is deprecated since OpenGL version %ls and "
// TO_DO: OpenGL 3.2
#define GD_STR_DeprecationMaxVaryingHeaderPrefix L"The function <b>%ls</b> is using the max varying components query feature which is deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationCompressedTextureFormatsHeaderPrefix L"The function <b>%ls</b> is using the implementation-specific compressed texture format query feature which is deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationLSBFirstPixelPackingHeaderPrefix L"The function <b>%ls</b> is using the LSB-first pixel packing parameter feature which is deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationPolygonAndLineStippleHeaderPrefix L"The function <b>%ls</b> is using the polygon or line stipple features. Stippling is deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationBitmapHeaderPrefix L"The function <b>%ls</b> is a bitmap function which is deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationEvaluatorsHeaderPrefix L"The function <b>%ls</b> is an evaluator function which is deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationFeedbackHeaderPrefix L"The function <b>%ls</b> is using selection or feedback modes. Selection and feedback modes are deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationHintsHeaderPrefix L"Some of glHint's targets are deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationNonSpriteHeaderPrefix L"Non-sprite points rasterization is deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationLineWidthHeaderPrefix L"Line width greater than 1.0 is deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationTextureBorderHeaderPrefix L"Texture borders are deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationFixedFunctionFragmentProcessingHeaderPrefix L"The function <b>%ls</b> is using the fixed-function fragment processing which is deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationAccumulationBuffersHeaderPrefix L"The function <b>%ls</b> is using an accumulation buffer. Accumulation buffers are deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationFramebufferSizeQueriesHeaderPrefix L"The function <b>%ls</b> is performing framebuffers size queries which are deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationPixelCopyHeaderPrefix L"The function <b>%ls</b> is a pixel copying operation. Pixel copying is deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationPolygonQuadsPrimitivesHeaderPrefix L"The function <b>%ls</b> is using a quadrilateral or a polygon primitive, which are deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationUnifiedExtesionStringHeaderPrefix L"The function <b>%ls</b> is querying the unified extensions string. The unified extensions string (glGetString(GL_EXTENSIONS)) is deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationAuxiliryBuffersHeaderPrefix L"The function <b>%ls</b> is using auxiliary color buffers, which are deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationClientVertexAndIndexArrayHeaderPrefix L"The function <b>%ls</b> is using a client vertex or index array, which is a deprecated feature since OpenGL version %ls and "
#define GD_STR_DeprecationPixelTransferHeaderPrefix L"The function <b>%ls</b> is performing a pixel transfer operation or querying a pixel transfer mode. Pixel transfer is a deprecated feature since OpenGL version %ls and "
#define GD_STR_DeprecationGLSLVersionHeaderPrefix L"The function <b>%ls</b> is creating a shader (<b>%ls</b>) using a GLSL version which is deprecated since OpenGL version %ls and "
#define GD_STR_DeprecationPostfix1 L"was removed from OpenGL at version %ls."
#define GD_STR_DeprecationPostfix2 L"will be removed from OpenGL at a future version."
#define GD_STR_DeprecationDescriptionTitle1 L"<b>List of deprecated behaviors in this category:</b><br>"
#define GD_STR_DeprecationDescriptionTitle2 L"<b>Complete list of deprecated functions in this category:</b><br>"
#define GD_STR_DeprecationDescriptionPixelFormat L"Legacy OpenGL 1.0 pixel formats (1, 2, 3, and 4) and the following pixel formats: "\
    L"GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, and GL_INTENSITY external and internal formats, including compressed, floating point, and integer variants."

// Deprecation alternative:
#define GD_STR_DeprecationAlternativePixelFormat L"Instead, consider using non-deprecated pixel formats such as GL_RGB and GL_RGBA"
#define GD_STR_DeprecationAlternativeApplicationGenNames L"Instead, create OpenGL objects before using them using the appropriate glGen* function"
#define GD_STR_DeprecationAlternativeFixedVertexProcessing L"Instead, implement a vertex shader that performs the required vertex processing"
#define GD_STR_DeprecationAlternativeFixedFunctionFragmentProcessing L"Instead, implement a fragment shader that performs the required fragment processing"
#define GD_STR_DeprecationAlternativeColorIndexMode L"Instead, use RGBA color mode"
#define GD_STR_DeprecationAlternativeImmediateMode L"Instead, render using VBOs (vertex buffer objects)"
#define GD_STR_DeprecationAlternativeDisplayList L"Instead, render using VBOs (vertex buffer objects)"
#define GD_STR_DeprecationAlternativeAttributesStack L"Instead, use OpenGL state variables access functions directly"
#define GD_STR_DeprecationAlternativeRaster L"Instead, use OpenGL texture mapping (draw a textured polygon)"
#define GD_STR_DeprecationAlternativeSeperatePolygonDrawMode L"Instead, always use GL_FRONT_AND_BACK as polygon face for glPolygonMode"
#define GD_STR_DeprecationAlternativePolygonAndLineStipple L"Instead, implement a fragement shader that creates the stippling effect"
#define GD_STR_DeprecationAlternativePixelDraw L"Instead, use OpenGL texture mapping (draw a textured polygon)"
#define GD_STR_DeprecationAlternativeBitmap L"Instead, use OpenGL texture mapping (draw a textured polygon)"
#define GD_STR_DeprecationAlternativeClampMode L"Instead, use one of the non-deprecated texture wrap modes"
#define GD_STR_DeprecationAlternativeAutoMipmap L"Instead, call glGenerateMipmap"
#define GD_STR_DeprecationAlternativeGLSLVersion L"Instead, use the latest GLSL version"
#define GD_STR_DeprecationAlternativePolygonQuads L"Instead, use triangle and triangle strip rendering"
#define GD_STR_DeprecationAlternativeEvaluators L"Instead, use a geometry shader, performing the evaluation and using the transform feedback mode to get the generated vertices"
#define GD_STR_DeprecationAlternativeFeedback L"Instead, use transform feedback mode"
#define GD_STR_DeprecationAlternativeAccumulationBuffers L"Instead, use FBOs (framebuffer objects) render-to-texture operations and a fragment shader"
#define GD_STR_DeprecationAlternativeAuxiliryBuffers L"Instead, use FBOs (framebuffer objects) and render buffers"
#define GD_STR_DeprecationAlternativeCliendVertexAndIndexArrays L"Instead, use VBOs (vertex buffer objects)"
#define GD_STR_DeprecationAlternativePixelTransfer L"Instead, implement a fragment shader (for color pixels) or vertex shader (for depth / stencil pixels) that performs the required pixel channel value tranfers."
#define GD_STR_DeprecationAlternativeUnifiedExtensionString L"Instead, use glGetStringi to query the supported extensions one at a time"
#define GD_STR_DeprecationAlternativeAlphaTest L"Instead, implement a fragment shader that implements the transparency effect"
#define GD_STR_DeprecationAlternativeHints L""
#define GD_STR_DeprecationAlternativeNonSpritePoints L"Instead, draw a polygon represnting the point"
#define GD_STR_DeprecationAlternativeLineWidth L"Instead, draw a polygon represnting the line"
#define GD_STR_DeprecationAlternativeTextureBorder L""
#define GD_STR_DeprecationAlternativeFramebufferSizeQueries L"Instead query the pixel format used to create the frame buffer"
#define GD_STR_DeprecationAlternativePixelCopy L"Instead, use FBOs (framebuffer objects) render-to-texture operations and draw a textured polygon"

// Deprecations descriptions in details (quoted from OpenGLSpec 3.1):
#define GD_STR_DeprecationOpenGLSpec L"(OpenGL3.1 Spec)"
#define GD_STR_DeprecationPixelFormatDetails L"The function <b>%ls</b> uses a deprecated pixel format as one of its arguments.<br>"\
    L"<b>Deprecated pixel formats</b> - Legacy pixel formats (1, 2, 3, 4), all GL_ALPHA, GL_LUMINANCE, GL_LUMINANCE_ALPHA, and GL_INTENSITY external and internal formats, including compressed, floating point,"\
    L"and integer variants. All references to luminance and intensity formats elsewhere in the specification, including conversion to and from those formats."\
    L"and all associated states, including states describing the allocation or format of luminance and intensity texture or framebuffer components."

#define GD_STR_DeprecationPipelineVertextProcessingDetails L"The function <b>%ls</b> is using an argument value related to fixed function processing or edge flag, which are deprecated.<br>"\
    L"Deprecated arguments values for edge flags and fixed-function vertex processing:<br>"\
    L"glEnable/glDisable/glIsEnabled targets GL_RESCALE NORMAL and GL_NORMALIZE. <br>"\
    L"glTexGen* and glEnable/glDisable/glIsEnabled targets GL_TEXTURE_GEN*. <br>"\
    L"glMaterial*, glLight*, glLightModel*, glColorMaterial, glShadeModel, and glEnable/glDisable/glIsEnabled targets GL_LIGHTING. GL_VERTEX_PROGRAM_TWO_SIDE, GL_LIGHTi, and GL_COLOR_MATERIAL."

#define GD_STR_DeprecationApplicationGeneratedNamesDetails L"The function <b>%ls</b> uses an object with a name generated by the application.<br>" \
    L"<b>Application-generated object names</b> - the names of all object types, such as " \
    L"buffer, query, and texture objects, must be generated using the corresponding " \
    L"glGen* commands. Trying to bind an object name not returned by a glGen* " \
    L"command will result in a GL_INVALID_OPERATION error. This behavior is " \
    L"already the case for framebuffer, renderbuffer, and vertex array objects. Object " \
    L"types which have default objects (objects named zero), such as vertex " \
    L"array, framebuffer, and texture objects, may also bind the default object, even " \
    L"though it is not returned by Gen* command."

#define GD_STR_DeprecationImmediateModeDetails L"glBegin, glEnd, glEdgeFlag*, glColor*,glFogCoord*, glIndex*, glNormal3*, glSecondaryColor3*, glTexCoord*, glVertex* "\
    L"and all associated states. Vertex arrays and array drawing commands must be used to draw primitives.<br>"\
    L"However, glVertexAttrib* and the current vertex attribute state are retained in order to provide default attribute arrays."

#define GD_STR_DeprecationColorIndexModeDetails L"No color index visuals are supplied by the window system-binding APIs such as GLX and WGL, "\
    L"so the default framebuffer is always in RGBA mode.<br>"\
    L"All language and states related to color index "\
    L"mode vertex, rasterization, and fragment processing behavior is removed.<br>"\
    L"GL_COLOR_INDEX formats are also deprecated."

#define GD_STR_DeprecationDisplayListDetails L"All references to display lists and behavior when compiling commands into display lists in the specification are deprecated."
#define GD_STR_DeprecationAttributeStackDetails L"All references to attribute stacks in the specification are deprecated."
#define GD_STR_DeprecationRasterPosDetails L"glRasterPos*, glWindowPos*, and all associated state variables are deprecated."
#define GD_STR_DeprecationSeperatePolygonDrawModeDetails L"glPolygonMode face values of GL_FRONT and GL_BACK are deprecated.<br>"\
    L"Polygons are always drawn in the same mode, no matter which face is being rasterized."
#define GD_STR_DeprecationPolygonAndLineStippleDetails L"glPolygonStipple, glLineStipple and all associated states are deprecated.<br>glEnable/glDisable/glIsEnabled target GL_POLYGON_STIPPLE, GL_LINE_STIPPLE are also deprecated."
#define GD_STR_DeprecationPixelDrawingDetails L"glDrawPixels and glPixelZoom."
#define GD_STR_DeprecationTextureClampWrapModeDetails L"Texture wrap mode GL_CLAMP is no longer accepted as a value of texture parameters GL_TEXTURE_WRAP_S, GL_TEXTURE_WRAP_T, or GL_TEXTURE_WRAP_R."
#define GD_STR_DeprecationTextureAutoMipmapDetails L"Automatic mipmap generation - glTexParameter* target GL_GENERATE_MIPMAP, and all associated states are deprecated."
#define GD_STR_DeprecationBitmapDetails L"glBitmap and the GL_BITMAP external format are deprecated."
#define GD_STR_DeprecationAlphaTestDetails L"glAlphaFunc and glEnable/glDisable target GL_ALPHA_TEST and all associated states are deprecated."
#define GD_STR_DeprecationEvalutorsDetails L"glMap*, glEvalCoord*, glMapGrid*, glEvalMesh*, glEvalPoint* and all evaluator map enables, and all associated states are deprecated."
#define GD_STR_DeprecationFeedbackDetails L"Selection and feedback modes - glRenderMode, glInitNames, glPopName, glPushName, glLoadName, glSelectBuffer, glFeedbackBuffer, and glPassThrough and all associated states are deprecated."
#define GD_STR_DeprecationHintsDetails L"The following targets to glHint are deprecated: GL_PERSPECTIVE_CORRECTION_HINT, GL_POINT_SMOOTH_HINT, GL_FOG_HINT and GL_GENERATE_MIPMAP_HINT."
#define GD_STR_DeprecationRectangleDetails L"Rectangle feature is deprecated."
#define GD_STR_DeprecationNonSpritePointsDetails L"Non-sprite points - glEnable/glDisable targets GL_POINT_SMOOTH, and GL_POINT_SPRITE, and all associated states are deprecated.<BR>"\
    L"Point rasterization is always performed as though GL_POINT_SPRITE were enabled."
#define GD_STR_DeprecationLineWidthDetails L"glLineWidth is not deprecated, but values greater than 1.0 will generate an GL_INVALID_VALUE error"
#define GD_STR_DeprecationTextureBorderDetails L"The border value to glTexImage* must always be zero, or an GL_INVALID_VALUE error is generated"
#define GD_STR_DeprecationFixedFunctionFragmentProcessingDetails L"glAreTexturesResident, glPrioritizeTextures, and glTexParameter target GL_TEXTURE_PRIORITY are deprecated.<br>"\
    L"glTexEnv target GL_TEXTURE_ENV, and all associated parameters are deprecate.<br>"\
    L"glTexEnv target GL_TEXTURE_FILTER_CONTROL, and parameter name GL_TEXTURE_LOD_BIAS are deprecated.<br>"\
    L"glEnable targets of all dimensionalities (GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_3D, GL_TEXTURE_1D_ARRAY, GL_TEXTURE_2D_ARRAY, and GL_TEXTURE_CUBE_MAP) are deprecated.<br>"\
    L"glEnable target GL_COLOR_SUM, GL_FOG are deprecated.<br>"\
    L"glFog, and all associated parameters are deprecated.<br>"\
    L"The implementation-dependent values GL_MAX_TEXTURE_UNITS and GL_MAX_TEXTURE_COORDS and all associated state are also deprecated."

#define GD_STR_DeprecationAccumulationBuffersDetails L"GL_ACCUM_BUFFER_BIT is deprecated as a bit in the argument to glClear. glAccum are glClearAccum are deprecated <br>"\
    L"the GL_ACCUM_*_BITS framebuffer states describing the size of accumulation buffer components and all associated states are deprecated.<br>"\
    L"Window system-binding APIs such as GLX and WGL may choose to either not expose window configurations containing accumulation buffers, or to ignore "\
    L"accumulation buffers when the default framebuffer bound to a GL context contains them."

#define GD_STR_DeprecationFramebufferSizeQueriesDetails L"GL_RED_BITS, GL_GREEN_BITS, GL_BLUE_BITS, "\
    L"GL_ALPHA_BITS, GL_DEPTH_BITS, and GL_STENCIL_BITS are deprecated."

#define GD_STR_DeprecationPixelCopyDetails L"Pixel copying (glCopyPixels) is deprecated."
#define GD_STR_DeprecationPolygonQuadsDetails L"Quadrilateral and polygon primitives feature is deprecated. Vertex array drawing modes GL_POLYGON, GL_QUADS, and GL_QUAD_STRIP, related descriptions of rasterization of non-triangle polygons, and all associated state are deprecated."
#define GD_STR_DeprecationAuxiliryBuffersDetails L"Auxiliary color buffers, including GL_AUXi targets of the default framebuffer, are deprecated."
#define GD_STR_DeprecationGLSLVersionDetails L"OpenGL Shading Language versions 1.10 and 1.20 are deprecated.<br>"\
    L"These versions of the shading language depend on many API features that have also been deprecated."
#define GD_STR_DeprecationUnifiedExtensionStringDetails L"L_EXTENSIONS target to glGetString is deprecated."
#define GD_STR_DeprecationCliendVertexAndIndexArraysDetails L"All vertex array attribute and element array index pointers "\
    L"must refer to buffer objects. The default vertex array object (the name zero) is deprecated. "\
    L"Calling glVertexAttribPointer when no buffer object or no vertex array object is bound will generate an "\
    L"GL_INVALID_OPERATION error, as will calling any array drawing command when no vertex array object is bound."
#define GD_STR_DeprecationPixelTransferDetails L"All pixel transfer modes, including pixel maps, shift and bias, color table lookup, color matrix, and convolution commands and state, and all associated state and commands defining that state."

// Deprecation details2 (list of function calls deprecations):
#define GD_STR_DeprecationPipelineVertextProcessingDetails2 L" - glEnable/glDisable/glIsEnabled deprecated targets:"\
    L"&nbsp;&nbsp;GL_RESCALE_NORMAL, GL_NORMALIZE, GL_TEXTURE_GEN*, GL_LIGHTi, GL_VERTEX_PROGRAM_TWO_SIDE, GL_ LIGHTING and GL_COLOR_MATERIAL.<br>"\
    L" - glTexGen* targets:"\
    L"&nbsp;&nbsp;GL_TEXTURE_GEN*.<br>"\
    L" - glClampColor deprecated targets:"\
    L"&nbsp;&nbsp;GL_CLAMP_VERTEX_COLOR, and GL_CLAMP_FRAGMENT_COLOR."


#define GD_STR_DeprecationApplicationGeneratedNamesDetails2 L" - glBindBuffer, glBindTexture using an application-generated object name"
#define GD_STR_DeprecationRasterPosDetails2 L" - glGet* with one of the following arguments GL_CURRENT_RASTER_POSITION, GL_CURRENT_RASTER_POSITION_VALID, GL_CURRENT_RASTER_DISTANCE, "\
    L"GL_CURRENT_RASTER_COLOR, GL_CURRENT_RASTER_SECONDARY_COLOR, GL_CURRENT_RASTER_INDEX and GL_CURRENT_RASTER_TEXTURE_COORDS"
#define GD_STR_DeprecationSeperatePolygonDrawModeDetails2 L" - glPolygonMode deprecated face values: GL_FRONT & GL_BACK<br>"\
    L" - glGetIntegerv deprecated pname: GL_POLYGON_MODE"
#define GD_STR_DeprecationPolygonAndLineStippleDetails2 L" - glEnable/glDisable/glIsEnabled deprecated targets: GL_POLYGON_STIPPLE, GL_LINE_STIPPLE"
#define GD_STR_DeprecationBitmapDetails2 L" - All functions with GL_BITMAP used as external format"
#define GD_STR_DeprecationTextureClampWrapModeDetails2 L" - glTexParameterf/glTexParameteri with GL_CLAMP used as param value for GL_TEXTURE_WRAP* parameter"
#define GD_STR_DeprecationTextureAutoMipmapDetails2 L" - glTexParameterf/glTexParameteri with GL_GENERATE_MIPMAP used as pname value"
#define GD_STR_DeprecationAlphaTestDetails2 L" - glEnable/glDisable/glIsEnabled deprecated targets: GL_ALPHA_TEST<br>"\
    L" - glGetIntegerv deprecated pnames: GL_ALPHA_TEST_FUNC, GL_ALPHA_TEST_REF"
#define GD_STR_DeprecationEvaluatorsDetails2 L" - glEnable/glDisable/glIsEnabled deprecated targets: GL_MAP*_VERTEX_*, GL_MAP*_INDEX, GL_MAP*_COLOR_*. GL_MAP*_NORMAL, GL_MAP*_TEXTURE_COORD_*, GL_AUTO_NORMAL<br>"\
    L" - glGetIntegerv deprecated pnames: GL_MAX_EVAL_ORDER, GL_MAP*_GRID_DOMAIN, GL_MAP*_GRID_SEGMENTS"
#define GD_STR_DeprecationFeedbackDetails2 L" - glGetIntegerv deprecated pnames: GL_RENDER_MODE, GL_FEEDBACK_BUFFER_SIZE, GL_FEEDBACK_BUFFER_TYPE, GL_SELECTION_BUFFER_SIZE, GL_NAME_STACK_DEPTH, GL_MAX_NAME_STACK_DEPTH<br>"\
    L" - glGetPointerv deprecated pnames: GL_FEEDBACK_BUFFER_POINTER, GL_SELECTION_BUFFER_POINTER"
#define GD_STR_DeprecationHintsDetails2 L" - glHint deprecated targets: GL_PERSPECTIVE_CORRECTION_HINT, GL_POINT_SMOOTH_HINT, GL_FOG_HINT and GL_GENERATE_MIPMAP_HINT"
#define GD_STR_DeprecationNonSpritePointsDetails2 L" - glEnable/glDisable/glIsEnabled deprecated targets: GL_POINT_SMOOTH and GL_POINT_SPRITE"
#define GD_STR_DeprecationLineWidthDetails2 L" - glLineWidth width greater than 1.0"
#define GD_STR_DeprecationTextureBorderDetails2 L" - glTexImage* with border different than 0.0"
#define GD_STR_DeprecationFixedFunctionFragmentProcessingDetails2 L" - glTexParameter* with target GL_TEXTURE_PRIORITY<br>"\
    L" - glTexEnv* with target GL_TEXTURE_ENV and all associated parameters<br>"\
    L" - glTexEnv* with target GL_TEXTURE_FILTER_CONTROL and parameter name GL_TEXTURE_LOD_BIAS<br>"\
    L" - glEnable/glDisable/glIsEnabled deprecated targets: GL_TEXTURE_*D, GL_TEXTURE_*D_ARRAY, GL_TEXTURE_CUBE_MAP, GL_COLOR_SUM and GL_FOG<br>"\
    L" - glGetIntegerv deprecated pnames: GL_MAX_TEXTURE_UNITS, GL_FOG_MODE and GL_MAX_TEXTURE_COORDS<br>"\
    L" - glGetFloatv deprecated pnames: GL_FOG_COLOR, GL_FOG_INDEX, GL_FOG_DENSITY, GL_FOG_START and GL_FOG_END"
#define GD_STR_DeprecationAccumulationBuffersDetails2 L" - glClear with mask GL_ACCUM_BUFFER_BIT<br>"\
    L" - glGetIntegerv deprecated pnames: GL_ACCUM_*_BITS<br>"\
    L" - glGetFloatv deprecated pnames: GL_ACCUM_CLEAR_VALUE"
#define GD_STR_DeprecationFramebuffersSizeQueriesDetails2 L" - glGetIntegerv deprecated pnames: GL_RED_BITS, GL_GREEN_BITS, GL_BLUE_BITS, GL_ALPHA_BITS, GL_DEPTH_BITS and GL_STENCIL_BITS"
#define GD_STR_DeprecationPolygonQuadsDetails2 L" - glDrawElements, glDrawRangeElements, glMultiDrawElements and glMultiDrawArrays deprecated modes: GL_POLYGON, GL_QUAD_STRIP, and GL_QUADS"
#define GD_STR_DeprecationAttributeStackDetails2 L" - glEnable/glDisable/glIsEnabled deprecated targets: GL_ATTRIB_STACK_DEPTH and GL_MAX_CLIENT_ATTRIB_STACK_DEPTH"
#define GD_STR_DeprecationAuxiliryBuffersDetails2 L" - glDrawBuffer/glDrawBuffers/glReadBuffer deprecated modes: GL_AUXi"
#define GD_STR_DeprecationClindVertexAndIndexArrayDetails2 L" - glVertexPointer call while no array buffer is bound"
#define GD_STR_DeprecationUnifiedExtensionStringDetails2 L" - glGetString deprecated names: GL_EXTENSIONS"
#define GD_STR_DeprecationMaxVaryingDetails2 L" - glGetIntegerv deprecated pnames: GL_MAX_VARYING_COMPONENTS and GL_MAX_VARYING_FLOATS"
#define GD_STR_DeprecationCompressedTextureFormatsDetails2 L" - glGetIntegerv deprecated pnames: NUM_COMPRESSED_TEXTURE_FORMATS and COMPRESSED_TEXTURE_FORMATS"
#define GD_STR_DeprecationLSBFirstPixelPackingDetails2 L" - glPixelStore[i|f] and glGetBooleanv deprecated panmes: UNPACK_LSB_FIRST and PACK_LSB_FIRST"
#endif  // __GDDEPRECATIONSTRINGCONSTANTS

