
local demo_dir = gh_utils.get_demo_dir()
local lib_dir = gh_utils.get_lib_dir() 		
dofile(lib_dir .. "lua/gxl_stdlib.lua")  



    
-- Get the size of the current 3D window    
--
winW, winH = gh_window.getsize(0)




-- Perspective camera.
--
local aspect = winW / winH
camera_params = { fov=60, znear=0.1, zfar=1000.0 }
camera = gh_camera.create_persp(camera_params.fov, aspect, camera_params.znear, camera_params.zfar)
gh_camera.set_viewport(camera, 0, 0, winW, winH)
gh_camera.set_position(camera, 0, 0, 2)
gh_camera.set_lookat(camera, 0, 0, 0, 1)
gh_camera.set_upvec(camera, 0, 1, 0, 0)





GL_ARB_gl_spirv_OK = gh_renderer.check_opengl_extension("GL_ARB_gl_spirv")




texture_prog = 0
tex0 = 0



if (GL_ARB_gl_spirv_OK == 1) then

  -- The GPU program for this demo: a simple vertex color program.
  -- The GLSL source code is at the end of this XML file.
  --
  local vs = demo_dir .. "spirv/vs.spv"
  local ps = demo_dir .. "spirv/ps.spv"
  local gs = ""
  local tcs = ""
  local tes = ""
  local cs = ""
  texture_prog = gh_gpu_program.create_from_shader_files_gl_spirv("texture_prog", vs, ps, gs, tcs, tes, cs)


  local abs_path = 0
  local PF_U8_RGB = 1
  local PF_U8_RGBA = 3
  local pixel_format = PF_U8_RGBA
  local gen_mipmaps = 1
  local compressed_texture = 0
  local free_cpu_memory = 1
  tex0 = gh_texture.create_from_file_v6(demo_dir .. "textures/gxl-gl-spirv.jpg", pixel_format, gen_mipmaps, compressed_texture)

end





--[[    
Possible values for the last param of gh_gpu_buffer.set_matrix4x4() in GLSL Hacker 0.6.4.5
- "camera_view_projection"
- "camera_view"
- "camera_projection"
- "object_local_transform"
- "object_global_transform"
--]]    
    
function ShaderBufferUpdateCamera(ssbo, camera)    
  local buffer_offset_bytes = 0
  gh_gpu_buffer.set_matrix4x4(ssbo, buffer_offset_bytes, camera, "camera_view_projection")
end  

function ShaderBufferUpdateObject(ssbo, obj)    
  local buffer_offset_bytes = 0
  buffer_offset_bytes = buffer_offset_bytes + 64 -- A 4x4 matrix == 64 bytes
  gh_gpu_buffer.set_matrix4x4(ssbo, buffer_offset_bytes, obj, "object_global_transform")
end  




ub = 0
quad = 0


if (GL_ARB_gl_spirv_OK == 1) then

  local flags = ""
  local buffer_size = 512

  ub = gh_gpu_buffer.create("UNIFORM", "NONE", buffer_size, flags)

  local binding_point_index = 2 -- Binding point 2 specified in the vertex shader.
  gh_gpu_buffer.bind_base(ub, binding_point_index)



  gh_gpu_buffer.map(ub)
  ShaderBufferUpdateCamera(ub, camera)
  gh_gpu_buffer.unmap(ub)




  quad = gh_mesh.create_quad(2, 2)

end  








gh_renderer.set_vsync(0)


gl_renderer = gh_renderer.get_renderer_model()
gl_version = gh_renderer.get_api_version()

last_time = gh_utils.get_elapsed_time()
fps_time = 0
fps = 0
frames = 0
