@echo off

REM Copyright (c) 2017-2025 Advanced Micro Devices, Inc. All rights reserved.

REM The steps in this script are required in order to get a full set of data
REM to appear in the System Activity view in Radeon GPU Profiler for D3D12
REM applications. This script must be run with admin privileges.

REM It performs two actions:
REM
REM    1: It adds the current user to the "Performance Log Users" group.
REM    2: It attempts to add a required registry key.

echo Copyright (c) 2017-2025 Advanced Micro Devices, Inc. All rights reserved.
echo.
echo This script will add the current user to the "Performance Log Users" group.
echo This script will also add a required registry key.
echo Run this script with "--cleanup" to delete the registry key and remove the
echo current user from the group.
echo.
echo Domain:        %userdomain%
echo Username:      %USERNAME%
echo Computer Name: %COMPUTERNAME%
echo.

if "%1"=="--cleanup" (GOTO CLEANUP)

net session >nul 2>&1
if %errorLevel% == 0 (
    echo Running Script as Administrator.
    echo.

    echo **** Attempting to add user %USERNAME% to "Performance Log Users" group ****
    echo.

    net localgroup "Performance Log Users" "%USERNAME%" /add && (
        echo Please reboot your system for these changes to take effect.
        echo.
    )

    echo **** Attempting to add ETW enablement registry key ****
    echo.

    start "" "%~dp0\\EnableSyncPrimitives.exe" >nul 2>&1
    if errorlevel 1 (
        echo Error when trying to update the Windows registry.
        echo.
    ) else (
        echo Registry updated successfully.
        echo.
    )

    echo Exiting...
) else (
    echo Please run this script as Administrator.
)
GOTO DONE

:CLEANUP
net session >nul 2>&1
if %errorLevel% == 0 (
    echo Running Script as Administrator.
    echo.

    echo **** Attempting to remove user %USERNAME% from "Performance Log Users" group ****
    echo.

    net localgroup "Performance Log Users" "%USERNAME%" /delete && (
        echo Please reboot your system for these changes to take effect.
        echo.
    )

    echo **** Attempting to remove ETW enablement registry key ****
    echo.

    start "" "%~dp0\\EnableSyncPrimitives.exe" --cleanup >nul 2>&1
    if errorlevel 1 (
        echo Error when trying to update the Windows registry.
        echo.
    ) else (
        echo Registry updated successfully.
        echo.
    )

    echo Exiting...
) else (
    echo Please run this script as Administrator.
)

:DONE
