# Copyright (c) 2017-2018 Advanced Micro Devices, Inc. All rights reserved.
#
#
# -*- coding: utf-8 -*-
#
# Radeon Compute Profiler documentation build configuration file, created by
# sphinx-quickstart on Tue Sep 19 13:58:50 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))


# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = []

# Uncomment the following line if the spelling extension is available
#extensions = ['sphinxcontrib.spelling']


# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'Radeon Compute Profiler'
copyright = u'2017-2018 Advanced Micro Devices, Inc. All rights reserved'
author = u'AMD Developer Tools'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = u'5.6'
# The full version, including alpha/beta/rc tags.
release = u'5.6'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = []

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False


# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
# these seem to work
html_theme = 'sphinx_rtd_theme'
#html_theme = 'alabaster'
#html_theme = 'scrolls'
#html_theme = 'agogo'
#html_theme = 'haiku'
#html_theme = 'epub'

# these do not seem to work
#html_theme = 'classic'
#html_theme = 'basic'
#html_theme = 'sphinxdoc'
#html_theme = 'nature'
#html_theme = 'pyramid'
#html_theme = 'bizstyle'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# If a function setup(app) exists, Sphinx will call this function as a normal
# extension during application startup. This method of using the overrides css
# file works better with read the docs (more so than specifying it via the
# html_context tag)
def setup(app):
    app.add_stylesheet('theme_overrides.css')

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# This is required for the alabaster theme
# refs: http://alabaster.readthedocs.io/en/latest/installation.html#sidebars
html_sidebars = {
    '**': [
        'about.html',
        'navigation.html',
        'relations.html',  # needs 'show_related': True theme option to display
        'searchbox.html',
        'donate.html',
    ]
}

html_show_sourcelink = False
html_show_sphinx = False

# -- Options for HTMLHelp output ------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'RadeonComputeProfilerdoc'


# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'RadeonComputeProfiler.tex', u'Radeon Compute Profiler Documentation',
     u'AMD Developer Tools', 'manual'),
]


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'radeoncomputeprofiler', u'Radeon Compute Profiler Documentation',
     [author], 1)
]


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'RadeonComputeProfiler', u'Radeon Compute Profiler Documentation',
     author, 'RadeonComputeProfiler', 'One line description of project.',
     'Miscellaneous'),
]

# -- Options for spelling checker-----------------------------------------

# Specify known-words list for words that are not in the default dictionary
spelling_word_list_filename='rcp-wordlist.txt'
