//==============================================================================
// Copyright (c) 2015-2018 Advanced Micro Devices, Inc. All rights reserved.
/// \author AMD Developer Tools Team
/// \file
/// \brief THIS CODE WAS AUTOGENERATED BY HSA CODE GENERATOR
//==============================================================================

#ifndef _HSATRACESTRINGOUTPUT_H_
#define _HSATRACESTRINGOUTPUT_H_

#include <string>
#include <sstream>

#include <hsa.h>
#include <hsa_ext_finalize.h>
#include <hsa_ext_image.h>
#include <hsa_ext_amd.h>
#include <hsa_ven_amd_loader.h>
#include <hsa_ven_amd_aqlprofile.h>

namespace HSATraceStringUtils
{
/// Gets the string representation of the hsa_status_t type
/// \param input the input hsa_status_t
/// \return the string representation of the hsa_status_t
std::string Get_hsa_status_t_String(hsa_status_t input);

/// Gets the string representation of the hsa_status_t pointer type
/// \param pInputPtr the input hsa_status_t pointer
/// \param input the input hsa_status_t
/// \return the string representation of the hsa_status_t
std::string Get_hsa_status_t_Ptr_String(const hsa_status_t* pInputPtr, hsa_status_t input);

/// Gets the string representation of the hsa_dim3_t type
/// \param input the input hsa_dim3_t
/// \return the string representation of the hsa_dim3_t
std::string Get_hsa_dim3_t_String(hsa_dim3_t input);

/// Gets the string representation of the hsa_dim3_t pointer type
/// \param pInputPtr the input hsa_dim3_t pointer
/// \param input the input hsa_dim3_t
/// \return the string representation of the hsa_dim3_t
std::string Get_hsa_dim3_t_Ptr_String(const hsa_dim3_t* pInputPtr, hsa_dim3_t input);

/// Gets the string representation of the hsa_access_permission_t type
/// \param input the input hsa_access_permission_t
/// \return the string representation of the hsa_access_permission_t
std::string Get_hsa_access_permission_t_String(hsa_access_permission_t input);

/// Gets the string representation of the hsa_access_permission_t pointer type
/// \param pInputPtr the input hsa_access_permission_t pointer
/// \param input the input hsa_access_permission_t
/// \return the string representation of the hsa_access_permission_t
std::string Get_hsa_access_permission_t_Ptr_String(const hsa_access_permission_t* pInputPtr, hsa_access_permission_t input);

/// Gets the string representation of the hsa_endianness_t type
/// \param input the input hsa_endianness_t
/// \return the string representation of the hsa_endianness_t
std::string Get_hsa_endianness_t_String(hsa_endianness_t input);

/// Gets the string representation of the hsa_endianness_t pointer type
/// \param pInputPtr the input hsa_endianness_t pointer
/// \param input the input hsa_endianness_t
/// \return the string representation of the hsa_endianness_t
std::string Get_hsa_endianness_t_Ptr_String(const hsa_endianness_t* pInputPtr, hsa_endianness_t input);

/// Gets the string representation of the hsa_machine_model_t type
/// \param input the input hsa_machine_model_t
/// \return the string representation of the hsa_machine_model_t
std::string Get_hsa_machine_model_t_String(hsa_machine_model_t input);

/// Gets the string representation of the hsa_machine_model_t pointer type
/// \param pInputPtr the input hsa_machine_model_t pointer
/// \param input the input hsa_machine_model_t
/// \return the string representation of the hsa_machine_model_t
std::string Get_hsa_machine_model_t_Ptr_String(const hsa_machine_model_t* pInputPtr, hsa_machine_model_t input);

/// Gets the string representation of the hsa_profile_t type
/// \param input the input hsa_profile_t
/// \return the string representation of the hsa_profile_t
std::string Get_hsa_profile_t_String(hsa_profile_t input);

/// Gets the string representation of the hsa_profile_t pointer type
/// \param pInputPtr the input hsa_profile_t pointer
/// \param input the input hsa_profile_t
/// \return the string representation of the hsa_profile_t
std::string Get_hsa_profile_t_Ptr_String(const hsa_profile_t* pInputPtr, hsa_profile_t input);

/// Gets the string representation of the hsa_system_info_t type
/// \param input the input hsa_system_info_t
/// \return the string representation of the hsa_system_info_t
std::string Get_hsa_system_info_t_String(hsa_system_info_t input);

/// Gets the string representation of the hsa_system_info_t pointer type
/// \param pInputPtr the input hsa_system_info_t pointer
/// \param input the input hsa_system_info_t
/// \return the string representation of the hsa_system_info_t
std::string Get_hsa_system_info_t_Ptr_String(const hsa_system_info_t* pInputPtr, hsa_system_info_t input);

/// Gets the string representation of the hsa_extension_t type
/// \param input the input hsa_extension_t
/// \return the string representation of the hsa_extension_t
std::string Get_hsa_extension_t_String(hsa_extension_t input);

/// Gets the string representation of the hsa_extension_t pointer type
/// \param pInputPtr the input hsa_extension_t pointer
/// \param input the input hsa_extension_t
/// \return the string representation of the hsa_extension_t
std::string Get_hsa_extension_t_Ptr_String(const hsa_extension_t* pInputPtr, hsa_extension_t input);

/// Gets the string representation of the hsa_agent_t type
/// \param input the input hsa_agent_t
/// \return the string representation of the hsa_agent_t
std::string Get_hsa_agent_t_String(hsa_agent_t input);

/// Gets the string representation of the hsa_agent_t pointer type
/// \param pInputPtr the input hsa_agent_t pointer
/// \param input the input hsa_agent_t
/// \return the string representation of the hsa_agent_t
std::string Get_hsa_agent_t_Ptr_String(const hsa_agent_t* pInputPtr, hsa_agent_t input);

/// Gets the string representation of the hsa_agent_feature_t type
/// \param input the input hsa_agent_feature_t
/// \return the string representation of the hsa_agent_feature_t
std::string Get_hsa_agent_feature_t_String(hsa_agent_feature_t input);

/// Gets the string representation of the hsa_agent_feature_t pointer type
/// \param pInputPtr the input hsa_agent_feature_t pointer
/// \param input the input hsa_agent_feature_t
/// \return the string representation of the hsa_agent_feature_t
std::string Get_hsa_agent_feature_t_Ptr_String(const hsa_agent_feature_t* pInputPtr, hsa_agent_feature_t input);

/// Gets the string representation of the hsa_device_type_t type
/// \param input the input hsa_device_type_t
/// \return the string representation of the hsa_device_type_t
std::string Get_hsa_device_type_t_String(hsa_device_type_t input);

/// Gets the string representation of the hsa_device_type_t pointer type
/// \param pInputPtr the input hsa_device_type_t pointer
/// \param input the input hsa_device_type_t
/// \return the string representation of the hsa_device_type_t
std::string Get_hsa_device_type_t_Ptr_String(const hsa_device_type_t* pInputPtr, hsa_device_type_t input);

/// Gets the string representation of the hsa_default_float_rounding_mode_t type
/// \param input the input hsa_default_float_rounding_mode_t
/// \return the string representation of the hsa_default_float_rounding_mode_t
std::string Get_hsa_default_float_rounding_mode_t_String(hsa_default_float_rounding_mode_t input);

/// Gets the string representation of the hsa_default_float_rounding_mode_t pointer type
/// \param pInputPtr the input hsa_default_float_rounding_mode_t pointer
/// \param input the input hsa_default_float_rounding_mode_t
/// \return the string representation of the hsa_default_float_rounding_mode_t
std::string Get_hsa_default_float_rounding_mode_t_Ptr_String(const hsa_default_float_rounding_mode_t* pInputPtr, hsa_default_float_rounding_mode_t input);

/// Gets the string representation of the hsa_agent_info_t type
/// \param input the input hsa_agent_info_t
/// \return the string representation of the hsa_agent_info_t
std::string Get_hsa_agent_info_t_String(hsa_agent_info_t input);

/// Gets the string representation of the hsa_agent_info_t pointer type
/// \param pInputPtr the input hsa_agent_info_t pointer
/// \param input the input hsa_agent_info_t
/// \return the string representation of the hsa_agent_info_t
std::string Get_hsa_agent_info_t_Ptr_String(const hsa_agent_info_t* pInputPtr, hsa_agent_info_t input);

/// Gets the string representation of the hsa_exception_policy_t type
/// \param input the input hsa_exception_policy_t
/// \return the string representation of the hsa_exception_policy_t
std::string Get_hsa_exception_policy_t_String(hsa_exception_policy_t input);

/// Gets the string representation of the hsa_exception_policy_t pointer type
/// \param pInputPtr the input hsa_exception_policy_t pointer
/// \param input the input hsa_exception_policy_t
/// \return the string representation of the hsa_exception_policy_t
std::string Get_hsa_exception_policy_t_Ptr_String(const hsa_exception_policy_t* pInputPtr, hsa_exception_policy_t input);

/// Gets the string representation of the hsa_cache_t type
/// \param input the input hsa_cache_t
/// \return the string representation of the hsa_cache_t
std::string Get_hsa_cache_t_String(hsa_cache_t input);

/// Gets the string representation of the hsa_cache_t pointer type
/// \param pInputPtr the input hsa_cache_t pointer
/// \param input the input hsa_cache_t
/// \return the string representation of the hsa_cache_t
std::string Get_hsa_cache_t_Ptr_String(const hsa_cache_t* pInputPtr, hsa_cache_t input);

/// Gets the string representation of the hsa_cache_info_t type
/// \param input the input hsa_cache_info_t
/// \return the string representation of the hsa_cache_info_t
std::string Get_hsa_cache_info_t_String(hsa_cache_info_t input);

/// Gets the string representation of the hsa_cache_info_t pointer type
/// \param pInputPtr the input hsa_cache_info_t pointer
/// \param input the input hsa_cache_info_t
/// \return the string representation of the hsa_cache_info_t
std::string Get_hsa_cache_info_t_Ptr_String(const hsa_cache_info_t* pInputPtr, hsa_cache_info_t input);

/// Gets the string representation of the hsa_signal_t type
/// \param input the input hsa_signal_t
/// \return the string representation of the hsa_signal_t
std::string Get_hsa_signal_t_String(hsa_signal_t input);

/// Gets the string representation of the hsa_signal_t pointer type
/// \param pInputPtr the input hsa_signal_t pointer
/// \param input the input hsa_signal_t
/// \return the string representation of the hsa_signal_t
std::string Get_hsa_signal_t_Ptr_String(const hsa_signal_t* pInputPtr, hsa_signal_t input);

/// Gets the string representation of the hsa_signal_condition_t type
/// \param input the input hsa_signal_condition_t
/// \return the string representation of the hsa_signal_condition_t
std::string Get_hsa_signal_condition_t_String(hsa_signal_condition_t input);

/// Gets the string representation of the hsa_signal_condition_t pointer type
/// \param pInputPtr the input hsa_signal_condition_t pointer
/// \param input the input hsa_signal_condition_t
/// \return the string representation of the hsa_signal_condition_t
std::string Get_hsa_signal_condition_t_Ptr_String(const hsa_signal_condition_t* pInputPtr, hsa_signal_condition_t input);

/// Gets the string representation of the hsa_wait_state_t type
/// \param input the input hsa_wait_state_t
/// \return the string representation of the hsa_wait_state_t
std::string Get_hsa_wait_state_t_String(hsa_wait_state_t input);

/// Gets the string representation of the hsa_wait_state_t pointer type
/// \param pInputPtr the input hsa_wait_state_t pointer
/// \param input the input hsa_wait_state_t
/// \return the string representation of the hsa_wait_state_t
std::string Get_hsa_wait_state_t_Ptr_String(const hsa_wait_state_t* pInputPtr, hsa_wait_state_t input);

/// Gets the string representation of the hsa_signal_group_t type
/// \param input the input hsa_signal_group_t
/// \return the string representation of the hsa_signal_group_t
std::string Get_hsa_signal_group_t_String(hsa_signal_group_t input);

/// Gets the string representation of the hsa_signal_group_t pointer type
/// \param pInputPtr the input hsa_signal_group_t pointer
/// \param input the input hsa_signal_group_t
/// \return the string representation of the hsa_signal_group_t
std::string Get_hsa_signal_group_t_Ptr_String(const hsa_signal_group_t* pInputPtr, hsa_signal_group_t input);

/// Gets the string representation of the hsa_region_t type
/// \param input the input hsa_region_t
/// \return the string representation of the hsa_region_t
std::string Get_hsa_region_t_String(hsa_region_t input);

/// Gets the string representation of the hsa_region_t pointer type
/// \param pInputPtr the input hsa_region_t pointer
/// \param input the input hsa_region_t
/// \return the string representation of the hsa_region_t
std::string Get_hsa_region_t_Ptr_String(const hsa_region_t* pInputPtr, hsa_region_t input);

/// Gets the string representation of the hsa_queue_type_t type
/// \param input the input hsa_queue_type_t
/// \return the string representation of the hsa_queue_type_t
std::string Get_hsa_queue_type_t_String(hsa_queue_type_t input);

/// Gets the string representation of the hsa_queue_type_t pointer type
/// \param pInputPtr the input hsa_queue_type_t pointer
/// \param input the input hsa_queue_type_t
/// \return the string representation of the hsa_queue_type_t
std::string Get_hsa_queue_type_t_Ptr_String(const hsa_queue_type_t* pInputPtr, hsa_queue_type_t input);

/// Gets the string representation of the hsa_queue_feature_t type
/// \param input the input hsa_queue_feature_t
/// \return the string representation of the hsa_queue_feature_t
std::string Get_hsa_queue_feature_t_String(hsa_queue_feature_t input);

/// Gets the string representation of the hsa_queue_feature_t pointer type
/// \param pInputPtr the input hsa_queue_feature_t pointer
/// \param input the input hsa_queue_feature_t
/// \return the string representation of the hsa_queue_feature_t
std::string Get_hsa_queue_feature_t_Ptr_String(const hsa_queue_feature_t* pInputPtr, hsa_queue_feature_t input);

/// Gets the string representation of the hsa_queue_t type
/// \param input the input hsa_queue_t
/// \return the string representation of the hsa_queue_t
std::string Get_hsa_queue_t_String(hsa_queue_t input);

/// Gets the string representation of the hsa_queue_t pointer type
/// \param pInputPtr the input hsa_queue_t pointer
/// \param input the input hsa_queue_t
/// \return the string representation of the hsa_queue_t
std::string Get_hsa_queue_t_Ptr_String(const hsa_queue_t* pInputPtr, hsa_queue_t input);

/// Gets the string representation of the hsa_packet_type_t type
/// \param input the input hsa_packet_type_t
/// \return the string representation of the hsa_packet_type_t
std::string Get_hsa_packet_type_t_String(hsa_packet_type_t input);

/// Gets the string representation of the hsa_packet_type_t pointer type
/// \param pInputPtr the input hsa_packet_type_t pointer
/// \param input the input hsa_packet_type_t
/// \return the string representation of the hsa_packet_type_t
std::string Get_hsa_packet_type_t_Ptr_String(const hsa_packet_type_t* pInputPtr, hsa_packet_type_t input);

/// Gets the string representation of the hsa_fence_scope_t type
/// \param input the input hsa_fence_scope_t
/// \return the string representation of the hsa_fence_scope_t
std::string Get_hsa_fence_scope_t_String(hsa_fence_scope_t input);

/// Gets the string representation of the hsa_fence_scope_t pointer type
/// \param pInputPtr the input hsa_fence_scope_t pointer
/// \param input the input hsa_fence_scope_t
/// \return the string representation of the hsa_fence_scope_t
std::string Get_hsa_fence_scope_t_Ptr_String(const hsa_fence_scope_t* pInputPtr, hsa_fence_scope_t input);

/// Gets the string representation of the hsa_packet_header_t type
/// \param input the input hsa_packet_header_t
/// \return the string representation of the hsa_packet_header_t
std::string Get_hsa_packet_header_t_String(hsa_packet_header_t input);

/// Gets the string representation of the hsa_packet_header_t pointer type
/// \param pInputPtr the input hsa_packet_header_t pointer
/// \param input the input hsa_packet_header_t
/// \return the string representation of the hsa_packet_header_t
std::string Get_hsa_packet_header_t_Ptr_String(const hsa_packet_header_t* pInputPtr, hsa_packet_header_t input);

/// Gets the string representation of the hsa_packet_header_width_t type
/// \param input the input hsa_packet_header_width_t
/// \return the string representation of the hsa_packet_header_width_t
std::string Get_hsa_packet_header_width_t_String(hsa_packet_header_width_t input);

/// Gets the string representation of the hsa_packet_header_width_t pointer type
/// \param pInputPtr the input hsa_packet_header_width_t pointer
/// \param input the input hsa_packet_header_width_t
/// \return the string representation of the hsa_packet_header_width_t
std::string Get_hsa_packet_header_width_t_Ptr_String(const hsa_packet_header_width_t* pInputPtr, hsa_packet_header_width_t input);

/// Gets the string representation of the hsa_kernel_dispatch_packet_setup_t type
/// \param input the input hsa_kernel_dispatch_packet_setup_t
/// \return the string representation of the hsa_kernel_dispatch_packet_setup_t
std::string Get_hsa_kernel_dispatch_packet_setup_t_String(hsa_kernel_dispatch_packet_setup_t input);

/// Gets the string representation of the hsa_kernel_dispatch_packet_setup_t pointer type
/// \param pInputPtr the input hsa_kernel_dispatch_packet_setup_t pointer
/// \param input the input hsa_kernel_dispatch_packet_setup_t
/// \return the string representation of the hsa_kernel_dispatch_packet_setup_t
std::string Get_hsa_kernel_dispatch_packet_setup_t_Ptr_String(const hsa_kernel_dispatch_packet_setup_t* pInputPtr, hsa_kernel_dispatch_packet_setup_t input);

/// Gets the string representation of the hsa_kernel_dispatch_packet_setup_width_t type
/// \param input the input hsa_kernel_dispatch_packet_setup_width_t
/// \return the string representation of the hsa_kernel_dispatch_packet_setup_width_t
std::string Get_hsa_kernel_dispatch_packet_setup_width_t_String(hsa_kernel_dispatch_packet_setup_width_t input);

/// Gets the string representation of the hsa_kernel_dispatch_packet_setup_width_t pointer type
/// \param pInputPtr the input hsa_kernel_dispatch_packet_setup_width_t pointer
/// \param input the input hsa_kernel_dispatch_packet_setup_width_t
/// \return the string representation of the hsa_kernel_dispatch_packet_setup_width_t
std::string Get_hsa_kernel_dispatch_packet_setup_width_t_Ptr_String(const hsa_kernel_dispatch_packet_setup_width_t* pInputPtr, hsa_kernel_dispatch_packet_setup_width_t input);

/// Gets the string representation of the hsa_kernel_dispatch_packet_t type
/// \param input the input hsa_kernel_dispatch_packet_t
/// \return the string representation of the hsa_kernel_dispatch_packet_t
std::string Get_hsa_kernel_dispatch_packet_t_String(hsa_kernel_dispatch_packet_t input);

/// Gets the string representation of the hsa_kernel_dispatch_packet_t pointer type
/// \param pInputPtr the input hsa_kernel_dispatch_packet_t pointer
/// \param input the input hsa_kernel_dispatch_packet_t
/// \return the string representation of the hsa_kernel_dispatch_packet_t
std::string Get_hsa_kernel_dispatch_packet_t_Ptr_String(const hsa_kernel_dispatch_packet_t* pInputPtr, hsa_kernel_dispatch_packet_t input);

/// Gets the string representation of the hsa_agent_dispatch_packet_t type
/// \param input the input hsa_agent_dispatch_packet_t
/// \return the string representation of the hsa_agent_dispatch_packet_t
std::string Get_hsa_agent_dispatch_packet_t_String(hsa_agent_dispatch_packet_t input);

/// Gets the string representation of the hsa_agent_dispatch_packet_t pointer type
/// \param pInputPtr the input hsa_agent_dispatch_packet_t pointer
/// \param input the input hsa_agent_dispatch_packet_t
/// \return the string representation of the hsa_agent_dispatch_packet_t
std::string Get_hsa_agent_dispatch_packet_t_Ptr_String(const hsa_agent_dispatch_packet_t* pInputPtr, hsa_agent_dispatch_packet_t input);

/// Gets the string representation of the hsa_barrier_and_packet_t type
/// \param input the input hsa_barrier_and_packet_t
/// \return the string representation of the hsa_barrier_and_packet_t
std::string Get_hsa_barrier_and_packet_t_String(hsa_barrier_and_packet_t input);

/// Gets the string representation of the hsa_barrier_and_packet_t pointer type
/// \param pInputPtr the input hsa_barrier_and_packet_t pointer
/// \param input the input hsa_barrier_and_packet_t
/// \return the string representation of the hsa_barrier_and_packet_t
std::string Get_hsa_barrier_and_packet_t_Ptr_String(const hsa_barrier_and_packet_t* pInputPtr, hsa_barrier_and_packet_t input);

/// Gets the string representation of the hsa_barrier_or_packet_t type
/// \param input the input hsa_barrier_or_packet_t
/// \return the string representation of the hsa_barrier_or_packet_t
std::string Get_hsa_barrier_or_packet_t_String(hsa_barrier_or_packet_t input);

/// Gets the string representation of the hsa_barrier_or_packet_t pointer type
/// \param pInputPtr the input hsa_barrier_or_packet_t pointer
/// \param input the input hsa_barrier_or_packet_t
/// \return the string representation of the hsa_barrier_or_packet_t
std::string Get_hsa_barrier_or_packet_t_Ptr_String(const hsa_barrier_or_packet_t* pInputPtr, hsa_barrier_or_packet_t input);

/// Gets the string representation of the hsa_region_segment_t type
/// \param input the input hsa_region_segment_t
/// \return the string representation of the hsa_region_segment_t
std::string Get_hsa_region_segment_t_String(hsa_region_segment_t input);

/// Gets the string representation of the hsa_region_segment_t pointer type
/// \param pInputPtr the input hsa_region_segment_t pointer
/// \param input the input hsa_region_segment_t
/// \return the string representation of the hsa_region_segment_t
std::string Get_hsa_region_segment_t_Ptr_String(const hsa_region_segment_t* pInputPtr, hsa_region_segment_t input);

/// Gets the string representation of the hsa_region_global_flag_t type
/// \param input the input hsa_region_global_flag_t
/// \return the string representation of the hsa_region_global_flag_t
std::string Get_hsa_region_global_flag_t_String(hsa_region_global_flag_t input);

/// Gets the string representation of the hsa_region_global_flag_t pointer type
/// \param pInputPtr the input hsa_region_global_flag_t pointer
/// \param input the input hsa_region_global_flag_t
/// \return the string representation of the hsa_region_global_flag_t
std::string Get_hsa_region_global_flag_t_Ptr_String(const hsa_region_global_flag_t* pInputPtr, hsa_region_global_flag_t input);

/// Gets the string representation of the hsa_region_info_t type
/// \param input the input hsa_region_info_t
/// \return the string representation of the hsa_region_info_t
std::string Get_hsa_region_info_t_String(hsa_region_info_t input);

/// Gets the string representation of the hsa_region_info_t pointer type
/// \param pInputPtr the input hsa_region_info_t pointer
/// \param input the input hsa_region_info_t
/// \return the string representation of the hsa_region_info_t
std::string Get_hsa_region_info_t_Ptr_String(const hsa_region_info_t* pInputPtr, hsa_region_info_t input);

/// Gets the string representation of the hsa_isa_t type
/// \param input the input hsa_isa_t
/// \return the string representation of the hsa_isa_t
std::string Get_hsa_isa_t_String(hsa_isa_t input);

/// Gets the string representation of the hsa_isa_t pointer type
/// \param pInputPtr the input hsa_isa_t pointer
/// \param input the input hsa_isa_t
/// \return the string representation of the hsa_isa_t
std::string Get_hsa_isa_t_Ptr_String(const hsa_isa_t* pInputPtr, hsa_isa_t input);

/// Gets the string representation of the hsa_isa_info_t type
/// \param input the input hsa_isa_info_t
/// \return the string representation of the hsa_isa_info_t
std::string Get_hsa_isa_info_t_String(hsa_isa_info_t input);

/// Gets the string representation of the hsa_isa_info_t pointer type
/// \param pInputPtr the input hsa_isa_info_t pointer
/// \param input the input hsa_isa_info_t
/// \return the string representation of the hsa_isa_info_t
std::string Get_hsa_isa_info_t_Ptr_String(const hsa_isa_info_t* pInputPtr, hsa_isa_info_t input);

/// Gets the string representation of the hsa_fp_type_t type
/// \param input the input hsa_fp_type_t
/// \return the string representation of the hsa_fp_type_t
std::string Get_hsa_fp_type_t_String(hsa_fp_type_t input);

/// Gets the string representation of the hsa_fp_type_t pointer type
/// \param pInputPtr the input hsa_fp_type_t pointer
/// \param input the input hsa_fp_type_t
/// \return the string representation of the hsa_fp_type_t
std::string Get_hsa_fp_type_t_Ptr_String(const hsa_fp_type_t* pInputPtr, hsa_fp_type_t input);

/// Gets the string representation of the hsa_flush_mode_t type
/// \param input the input hsa_flush_mode_t
/// \return the string representation of the hsa_flush_mode_t
std::string Get_hsa_flush_mode_t_String(hsa_flush_mode_t input);

/// Gets the string representation of the hsa_flush_mode_t pointer type
/// \param pInputPtr the input hsa_flush_mode_t pointer
/// \param input the input hsa_flush_mode_t
/// \return the string representation of the hsa_flush_mode_t
std::string Get_hsa_flush_mode_t_Ptr_String(const hsa_flush_mode_t* pInputPtr, hsa_flush_mode_t input);

/// Gets the string representation of the hsa_round_method_t type
/// \param input the input hsa_round_method_t
/// \return the string representation of the hsa_round_method_t
std::string Get_hsa_round_method_t_String(hsa_round_method_t input);

/// Gets the string representation of the hsa_round_method_t pointer type
/// \param pInputPtr the input hsa_round_method_t pointer
/// \param input the input hsa_round_method_t
/// \return the string representation of the hsa_round_method_t
std::string Get_hsa_round_method_t_Ptr_String(const hsa_round_method_t* pInputPtr, hsa_round_method_t input);

/// Gets the string representation of the hsa_wavefront_t type
/// \param input the input hsa_wavefront_t
/// \return the string representation of the hsa_wavefront_t
std::string Get_hsa_wavefront_t_String(hsa_wavefront_t input);

/// Gets the string representation of the hsa_wavefront_t pointer type
/// \param pInputPtr the input hsa_wavefront_t pointer
/// \param input the input hsa_wavefront_t
/// \return the string representation of the hsa_wavefront_t
std::string Get_hsa_wavefront_t_Ptr_String(const hsa_wavefront_t* pInputPtr, hsa_wavefront_t input);

/// Gets the string representation of the hsa_wavefront_info_t type
/// \param input the input hsa_wavefront_info_t
/// \return the string representation of the hsa_wavefront_info_t
std::string Get_hsa_wavefront_info_t_String(hsa_wavefront_info_t input);

/// Gets the string representation of the hsa_wavefront_info_t pointer type
/// \param pInputPtr the input hsa_wavefront_info_t pointer
/// \param input the input hsa_wavefront_info_t
/// \return the string representation of the hsa_wavefront_info_t
std::string Get_hsa_wavefront_info_t_Ptr_String(const hsa_wavefront_info_t* pInputPtr, hsa_wavefront_info_t input);

/// Gets the string representation of the hsa_code_object_reader_t type
/// \param input the input hsa_code_object_reader_t
/// \return the string representation of the hsa_code_object_reader_t
std::string Get_hsa_code_object_reader_t_String(hsa_code_object_reader_t input);

/// Gets the string representation of the hsa_code_object_reader_t pointer type
/// \param pInputPtr the input hsa_code_object_reader_t pointer
/// \param input the input hsa_code_object_reader_t
/// \return the string representation of the hsa_code_object_reader_t
std::string Get_hsa_code_object_reader_t_Ptr_String(const hsa_code_object_reader_t* pInputPtr, hsa_code_object_reader_t input);

/// Gets the string representation of the hsa_executable_t type
/// \param input the input hsa_executable_t
/// \return the string representation of the hsa_executable_t
std::string Get_hsa_executable_t_String(hsa_executable_t input);

/// Gets the string representation of the hsa_executable_t pointer type
/// \param pInputPtr the input hsa_executable_t pointer
/// \param input the input hsa_executable_t
/// \return the string representation of the hsa_executable_t
std::string Get_hsa_executable_t_Ptr_String(const hsa_executable_t* pInputPtr, hsa_executable_t input);

/// Gets the string representation of the hsa_executable_state_t type
/// \param input the input hsa_executable_state_t
/// \return the string representation of the hsa_executable_state_t
std::string Get_hsa_executable_state_t_String(hsa_executable_state_t input);

/// Gets the string representation of the hsa_executable_state_t pointer type
/// \param pInputPtr the input hsa_executable_state_t pointer
/// \param input the input hsa_executable_state_t
/// \return the string representation of the hsa_executable_state_t
std::string Get_hsa_executable_state_t_Ptr_String(const hsa_executable_state_t* pInputPtr, hsa_executable_state_t input);

/// Gets the string representation of the hsa_loaded_code_object_t type
/// \param input the input hsa_loaded_code_object_t
/// \return the string representation of the hsa_loaded_code_object_t
std::string Get_hsa_loaded_code_object_t_String(hsa_loaded_code_object_t input);

/// Gets the string representation of the hsa_loaded_code_object_t pointer type
/// \param pInputPtr the input hsa_loaded_code_object_t pointer
/// \param input the input hsa_loaded_code_object_t
/// \return the string representation of the hsa_loaded_code_object_t
std::string Get_hsa_loaded_code_object_t_Ptr_String(const hsa_loaded_code_object_t* pInputPtr, hsa_loaded_code_object_t input);

/// Gets the string representation of the hsa_executable_info_t type
/// \param input the input hsa_executable_info_t
/// \return the string representation of the hsa_executable_info_t
std::string Get_hsa_executable_info_t_String(hsa_executable_info_t input);

/// Gets the string representation of the hsa_executable_info_t pointer type
/// \param pInputPtr the input hsa_executable_info_t pointer
/// \param input the input hsa_executable_info_t
/// \return the string representation of the hsa_executable_info_t
std::string Get_hsa_executable_info_t_Ptr_String(const hsa_executable_info_t* pInputPtr, hsa_executable_info_t input);

/// Gets the string representation of the hsa_executable_symbol_t type
/// \param input the input hsa_executable_symbol_t
/// \return the string representation of the hsa_executable_symbol_t
std::string Get_hsa_executable_symbol_t_String(hsa_executable_symbol_t input);

/// Gets the string representation of the hsa_executable_symbol_t pointer type
/// \param pInputPtr the input hsa_executable_symbol_t pointer
/// \param input the input hsa_executable_symbol_t
/// \return the string representation of the hsa_executable_symbol_t
std::string Get_hsa_executable_symbol_t_Ptr_String(const hsa_executable_symbol_t* pInputPtr, hsa_executable_symbol_t input);

/// Gets the string representation of the hsa_symbol_kind_t type
/// \param input the input hsa_symbol_kind_t
/// \return the string representation of the hsa_symbol_kind_t
std::string Get_hsa_symbol_kind_t_String(hsa_symbol_kind_t input);

/// Gets the string representation of the hsa_symbol_kind_t pointer type
/// \param pInputPtr the input hsa_symbol_kind_t pointer
/// \param input the input hsa_symbol_kind_t
/// \return the string representation of the hsa_symbol_kind_t
std::string Get_hsa_symbol_kind_t_Ptr_String(const hsa_symbol_kind_t* pInputPtr, hsa_symbol_kind_t input);

/// Gets the string representation of the hsa_symbol_linkage_t type
/// \param input the input hsa_symbol_linkage_t
/// \return the string representation of the hsa_symbol_linkage_t
std::string Get_hsa_symbol_linkage_t_String(hsa_symbol_linkage_t input);

/// Gets the string representation of the hsa_symbol_linkage_t pointer type
/// \param pInputPtr the input hsa_symbol_linkage_t pointer
/// \param input the input hsa_symbol_linkage_t
/// \return the string representation of the hsa_symbol_linkage_t
std::string Get_hsa_symbol_linkage_t_Ptr_String(const hsa_symbol_linkage_t* pInputPtr, hsa_symbol_linkage_t input);

/// Gets the string representation of the hsa_variable_allocation_t type
/// \param input the input hsa_variable_allocation_t
/// \return the string representation of the hsa_variable_allocation_t
std::string Get_hsa_variable_allocation_t_String(hsa_variable_allocation_t input);

/// Gets the string representation of the hsa_variable_allocation_t pointer type
/// \param pInputPtr the input hsa_variable_allocation_t pointer
/// \param input the input hsa_variable_allocation_t
/// \return the string representation of the hsa_variable_allocation_t
std::string Get_hsa_variable_allocation_t_Ptr_String(const hsa_variable_allocation_t* pInputPtr, hsa_variable_allocation_t input);

/// Gets the string representation of the hsa_variable_segment_t type
/// \param input the input hsa_variable_segment_t
/// \return the string representation of the hsa_variable_segment_t
std::string Get_hsa_variable_segment_t_String(hsa_variable_segment_t input);

/// Gets the string representation of the hsa_variable_segment_t pointer type
/// \param pInputPtr the input hsa_variable_segment_t pointer
/// \param input the input hsa_variable_segment_t
/// \return the string representation of the hsa_variable_segment_t
std::string Get_hsa_variable_segment_t_Ptr_String(const hsa_variable_segment_t* pInputPtr, hsa_variable_segment_t input);

/// Gets the string representation of the hsa_executable_symbol_info_t type
/// \param input the input hsa_executable_symbol_info_t
/// \return the string representation of the hsa_executable_symbol_info_t
std::string Get_hsa_executable_symbol_info_t_String(hsa_executable_symbol_info_t input);

/// Gets the string representation of the hsa_executable_symbol_info_t pointer type
/// \param pInputPtr the input hsa_executable_symbol_info_t pointer
/// \param input the input hsa_executable_symbol_info_t
/// \return the string representation of the hsa_executable_symbol_info_t
std::string Get_hsa_executable_symbol_info_t_Ptr_String(const hsa_executable_symbol_info_t* pInputPtr, hsa_executable_symbol_info_t input);

/// Gets the string representation of the hsa_code_object_t type
/// \param input the input hsa_code_object_t
/// \return the string representation of the hsa_code_object_t
std::string Get_hsa_code_object_t_String(hsa_code_object_t input);

/// Gets the string representation of the hsa_code_object_t pointer type
/// \param pInputPtr the input hsa_code_object_t pointer
/// \param input the input hsa_code_object_t
/// \return the string representation of the hsa_code_object_t
std::string Get_hsa_code_object_t_Ptr_String(const hsa_code_object_t* pInputPtr, hsa_code_object_t input);

/// Gets the string representation of the hsa_callback_data_t type
/// \param input the input hsa_callback_data_t
/// \return the string representation of the hsa_callback_data_t
std::string Get_hsa_callback_data_t_String(hsa_callback_data_t input);

/// Gets the string representation of the hsa_callback_data_t pointer type
/// \param pInputPtr the input hsa_callback_data_t pointer
/// \param input the input hsa_callback_data_t
/// \return the string representation of the hsa_callback_data_t
std::string Get_hsa_callback_data_t_Ptr_String(const hsa_callback_data_t* pInputPtr, hsa_callback_data_t input);

/// Gets the string representation of the hsa_code_object_type_t type
/// \param input the input hsa_code_object_type_t
/// \return the string representation of the hsa_code_object_type_t
std::string Get_hsa_code_object_type_t_String(hsa_code_object_type_t input);

/// Gets the string representation of the hsa_code_object_type_t pointer type
/// \param pInputPtr the input hsa_code_object_type_t pointer
/// \param input the input hsa_code_object_type_t
/// \return the string representation of the hsa_code_object_type_t
std::string Get_hsa_code_object_type_t_Ptr_String(const hsa_code_object_type_t* pInputPtr, hsa_code_object_type_t input);

/// Gets the string representation of the hsa_code_object_info_t type
/// \param input the input hsa_code_object_info_t
/// \return the string representation of the hsa_code_object_info_t
std::string Get_hsa_code_object_info_t_String(hsa_code_object_info_t input);

/// Gets the string representation of the hsa_code_object_info_t pointer type
/// \param pInputPtr the input hsa_code_object_info_t pointer
/// \param input the input hsa_code_object_info_t
/// \return the string representation of the hsa_code_object_info_t
std::string Get_hsa_code_object_info_t_Ptr_String(const hsa_code_object_info_t* pInputPtr, hsa_code_object_info_t input);

/// Gets the string representation of the hsa_code_symbol_t type
/// \param input the input hsa_code_symbol_t
/// \return the string representation of the hsa_code_symbol_t
std::string Get_hsa_code_symbol_t_String(hsa_code_symbol_t input);

/// Gets the string representation of the hsa_code_symbol_t pointer type
/// \param pInputPtr the input hsa_code_symbol_t pointer
/// \param input the input hsa_code_symbol_t
/// \return the string representation of the hsa_code_symbol_t
std::string Get_hsa_code_symbol_t_Ptr_String(const hsa_code_symbol_t* pInputPtr, hsa_code_symbol_t input);

/// Gets the string representation of the hsa_code_symbol_info_t type
/// \param input the input hsa_code_symbol_info_t
/// \return the string representation of the hsa_code_symbol_info_t
std::string Get_hsa_code_symbol_info_t_String(hsa_code_symbol_info_t input);

/// Gets the string representation of the hsa_code_symbol_info_t pointer type
/// \param pInputPtr the input hsa_code_symbol_info_t pointer
/// \param input the input hsa_code_symbol_info_t
/// \return the string representation of the hsa_code_symbol_info_t
std::string Get_hsa_code_symbol_info_t_Ptr_String(const hsa_code_symbol_info_t* pInputPtr, hsa_code_symbol_info_t input);

/// Gets the string representation of the BrigModule_t type
/// \param input the input BrigModule_t
/// \return the string representation of the BrigModule_t
std::string Get_BrigModule_t_String(BrigModule_t input);

/// Gets the string representation of the BrigModule_t pointer type
/// \param pInputPtr the input BrigModule_t pointer
/// \param input the input BrigModule_t
/// \return the string representation of the BrigModule_t
std::string Get_BrigModule_t_Ptr_String(const BrigModule_t* pInputPtr, BrigModule_t input);

/// Gets the string representation of the hsa_ext_program_t type
/// \param input the input hsa_ext_program_t
/// \return the string representation of the hsa_ext_program_t
std::string Get_hsa_ext_program_t_String(hsa_ext_program_t input);

/// Gets the string representation of the hsa_ext_program_t pointer type
/// \param pInputPtr the input hsa_ext_program_t pointer
/// \param input the input hsa_ext_program_t
/// \return the string representation of the hsa_ext_program_t
std::string Get_hsa_ext_program_t_Ptr_String(const hsa_ext_program_t* pInputPtr, hsa_ext_program_t input);

/// Gets the string representation of the hsa_ext_program_info_t type
/// \param input the input hsa_ext_program_info_t
/// \return the string representation of the hsa_ext_program_info_t
std::string Get_hsa_ext_program_info_t_String(hsa_ext_program_info_t input);

/// Gets the string representation of the hsa_ext_program_info_t pointer type
/// \param pInputPtr the input hsa_ext_program_info_t pointer
/// \param input the input hsa_ext_program_info_t
/// \return the string representation of the hsa_ext_program_info_t
std::string Get_hsa_ext_program_info_t_Ptr_String(const hsa_ext_program_info_t* pInputPtr, hsa_ext_program_info_t input);

/// Gets the string representation of the hsa_ext_finalizer_call_convention_t type
/// \param input the input hsa_ext_finalizer_call_convention_t
/// \return the string representation of the hsa_ext_finalizer_call_convention_t
std::string Get_hsa_ext_finalizer_call_convention_t_String(hsa_ext_finalizer_call_convention_t input);

/// Gets the string representation of the hsa_ext_finalizer_call_convention_t pointer type
/// \param pInputPtr the input hsa_ext_finalizer_call_convention_t pointer
/// \param input the input hsa_ext_finalizer_call_convention_t
/// \return the string representation of the hsa_ext_finalizer_call_convention_t
std::string Get_hsa_ext_finalizer_call_convention_t_Ptr_String(const hsa_ext_finalizer_call_convention_t* pInputPtr, hsa_ext_finalizer_call_convention_t input);

/// Gets the string representation of the hsa_ext_control_directives_t type
/// \param input the input hsa_ext_control_directives_t
/// \return the string representation of the hsa_ext_control_directives_t
std::string Get_hsa_ext_control_directives_t_String(hsa_ext_control_directives_t input);

/// Gets the string representation of the hsa_ext_control_directives_t pointer type
/// \param pInputPtr the input hsa_ext_control_directives_t pointer
/// \param input the input hsa_ext_control_directives_t
/// \return the string representation of the hsa_ext_control_directives_t
std::string Get_hsa_ext_control_directives_t_Ptr_String(const hsa_ext_control_directives_t* pInputPtr, hsa_ext_control_directives_t input);

/// Gets the string representation of the hsa_ext_image_t type
/// \param input the input hsa_ext_image_t
/// \return the string representation of the hsa_ext_image_t
std::string Get_hsa_ext_image_t_String(hsa_ext_image_t input);

/// Gets the string representation of the hsa_ext_image_t pointer type
/// \param pInputPtr the input hsa_ext_image_t pointer
/// \param input the input hsa_ext_image_t
/// \return the string representation of the hsa_ext_image_t
std::string Get_hsa_ext_image_t_Ptr_String(const hsa_ext_image_t* pInputPtr, hsa_ext_image_t input);

/// Gets the string representation of the hsa_ext_image_geometry_t type
/// \param input the input hsa_ext_image_geometry_t
/// \return the string representation of the hsa_ext_image_geometry_t
std::string Get_hsa_ext_image_geometry_t_String(hsa_ext_image_geometry_t input);

/// Gets the string representation of the hsa_ext_image_geometry_t pointer type
/// \param pInputPtr the input hsa_ext_image_geometry_t pointer
/// \param input the input hsa_ext_image_geometry_t
/// \return the string representation of the hsa_ext_image_geometry_t
std::string Get_hsa_ext_image_geometry_t_Ptr_String(const hsa_ext_image_geometry_t* pInputPtr, hsa_ext_image_geometry_t input);

/// Gets the string representation of the hsa_ext_image_channel_type_t type
/// \param input the input hsa_ext_image_channel_type_t
/// \return the string representation of the hsa_ext_image_channel_type_t
std::string Get_hsa_ext_image_channel_type_t_String(hsa_ext_image_channel_type_t input);

/// Gets the string representation of the hsa_ext_image_channel_type_t pointer type
/// \param pInputPtr the input hsa_ext_image_channel_type_t pointer
/// \param input the input hsa_ext_image_channel_type_t
/// \return the string representation of the hsa_ext_image_channel_type_t
std::string Get_hsa_ext_image_channel_type_t_Ptr_String(const hsa_ext_image_channel_type_t* pInputPtr, hsa_ext_image_channel_type_t input);

/// Gets the string representation of the hsa_ext_image_channel_order_t type
/// \param input the input hsa_ext_image_channel_order_t
/// \return the string representation of the hsa_ext_image_channel_order_t
std::string Get_hsa_ext_image_channel_order_t_String(hsa_ext_image_channel_order_t input);

/// Gets the string representation of the hsa_ext_image_channel_order_t pointer type
/// \param pInputPtr the input hsa_ext_image_channel_order_t pointer
/// \param input the input hsa_ext_image_channel_order_t
/// \return the string representation of the hsa_ext_image_channel_order_t
std::string Get_hsa_ext_image_channel_order_t_Ptr_String(const hsa_ext_image_channel_order_t* pInputPtr, hsa_ext_image_channel_order_t input);

/// Gets the string representation of the hsa_ext_image_format_t type
/// \param input the input hsa_ext_image_format_t
/// \return the string representation of the hsa_ext_image_format_t
std::string Get_hsa_ext_image_format_t_String(hsa_ext_image_format_t input);

/// Gets the string representation of the hsa_ext_image_format_t pointer type
/// \param pInputPtr the input hsa_ext_image_format_t pointer
/// \param input the input hsa_ext_image_format_t
/// \return the string representation of the hsa_ext_image_format_t
std::string Get_hsa_ext_image_format_t_Ptr_String(const hsa_ext_image_format_t* pInputPtr, hsa_ext_image_format_t input);

/// Gets the string representation of the hsa_ext_image_descriptor_t type
/// \param input the input hsa_ext_image_descriptor_t
/// \return the string representation of the hsa_ext_image_descriptor_t
std::string Get_hsa_ext_image_descriptor_t_String(hsa_ext_image_descriptor_t input);

/// Gets the string representation of the hsa_ext_image_descriptor_t pointer type
/// \param pInputPtr the input hsa_ext_image_descriptor_t pointer
/// \param input the input hsa_ext_image_descriptor_t
/// \return the string representation of the hsa_ext_image_descriptor_t
std::string Get_hsa_ext_image_descriptor_t_Ptr_String(const hsa_ext_image_descriptor_t* pInputPtr, hsa_ext_image_descriptor_t input);

/// Gets the string representation of the hsa_ext_image_capability_t type
/// \param input the input hsa_ext_image_capability_t
/// \return the string representation of the hsa_ext_image_capability_t
std::string Get_hsa_ext_image_capability_t_String(hsa_ext_image_capability_t input);

/// Gets the string representation of the hsa_ext_image_capability_t pointer type
/// \param pInputPtr the input hsa_ext_image_capability_t pointer
/// \param input the input hsa_ext_image_capability_t
/// \return the string representation of the hsa_ext_image_capability_t
std::string Get_hsa_ext_image_capability_t_Ptr_String(const hsa_ext_image_capability_t* pInputPtr, hsa_ext_image_capability_t input);

/// Gets the string representation of the hsa_ext_image_data_layout_t type
/// \param input the input hsa_ext_image_data_layout_t
/// \return the string representation of the hsa_ext_image_data_layout_t
std::string Get_hsa_ext_image_data_layout_t_String(hsa_ext_image_data_layout_t input);

/// Gets the string representation of the hsa_ext_image_data_layout_t pointer type
/// \param pInputPtr the input hsa_ext_image_data_layout_t pointer
/// \param input the input hsa_ext_image_data_layout_t
/// \return the string representation of the hsa_ext_image_data_layout_t
std::string Get_hsa_ext_image_data_layout_t_Ptr_String(const hsa_ext_image_data_layout_t* pInputPtr, hsa_ext_image_data_layout_t input);

/// Gets the string representation of the hsa_ext_image_data_info_t type
/// \param input the input hsa_ext_image_data_info_t
/// \return the string representation of the hsa_ext_image_data_info_t
std::string Get_hsa_ext_image_data_info_t_String(hsa_ext_image_data_info_t input);

/// Gets the string representation of the hsa_ext_image_data_info_t pointer type
/// \param pInputPtr the input hsa_ext_image_data_info_t pointer
/// \param input the input hsa_ext_image_data_info_t
/// \return the string representation of the hsa_ext_image_data_info_t
std::string Get_hsa_ext_image_data_info_t_Ptr_String(const hsa_ext_image_data_info_t* pInputPtr, hsa_ext_image_data_info_t input);

/// Gets the string representation of the hsa_ext_image_region_t type
/// \param input the input hsa_ext_image_region_t
/// \return the string representation of the hsa_ext_image_region_t
std::string Get_hsa_ext_image_region_t_String(hsa_ext_image_region_t input);

/// Gets the string representation of the hsa_ext_image_region_t pointer type
/// \param pInputPtr the input hsa_ext_image_region_t pointer
/// \param input the input hsa_ext_image_region_t
/// \return the string representation of the hsa_ext_image_region_t
std::string Get_hsa_ext_image_region_t_Ptr_String(const hsa_ext_image_region_t* pInputPtr, hsa_ext_image_region_t input);

/// Gets the string representation of the hsa_ext_sampler_t type
/// \param input the input hsa_ext_sampler_t
/// \return the string representation of the hsa_ext_sampler_t
std::string Get_hsa_ext_sampler_t_String(hsa_ext_sampler_t input);

/// Gets the string representation of the hsa_ext_sampler_t pointer type
/// \param pInputPtr the input hsa_ext_sampler_t pointer
/// \param input the input hsa_ext_sampler_t
/// \return the string representation of the hsa_ext_sampler_t
std::string Get_hsa_ext_sampler_t_Ptr_String(const hsa_ext_sampler_t* pInputPtr, hsa_ext_sampler_t input);

/// Gets the string representation of the hsa_ext_sampler_addressing_mode_t type
/// \param input the input hsa_ext_sampler_addressing_mode_t
/// \return the string representation of the hsa_ext_sampler_addressing_mode_t
std::string Get_hsa_ext_sampler_addressing_mode_t_String(hsa_ext_sampler_addressing_mode_t input);

/// Gets the string representation of the hsa_ext_sampler_addressing_mode_t pointer type
/// \param pInputPtr the input hsa_ext_sampler_addressing_mode_t pointer
/// \param input the input hsa_ext_sampler_addressing_mode_t
/// \return the string representation of the hsa_ext_sampler_addressing_mode_t
std::string Get_hsa_ext_sampler_addressing_mode_t_Ptr_String(const hsa_ext_sampler_addressing_mode_t* pInputPtr, hsa_ext_sampler_addressing_mode_t input);

/// Gets the string representation of the hsa_ext_sampler_coordinate_mode_t type
/// \param input the input hsa_ext_sampler_coordinate_mode_t
/// \return the string representation of the hsa_ext_sampler_coordinate_mode_t
std::string Get_hsa_ext_sampler_coordinate_mode_t_String(hsa_ext_sampler_coordinate_mode_t input);

/// Gets the string representation of the hsa_ext_sampler_coordinate_mode_t pointer type
/// \param pInputPtr the input hsa_ext_sampler_coordinate_mode_t pointer
/// \param input the input hsa_ext_sampler_coordinate_mode_t
/// \return the string representation of the hsa_ext_sampler_coordinate_mode_t
std::string Get_hsa_ext_sampler_coordinate_mode_t_Ptr_String(const hsa_ext_sampler_coordinate_mode_t* pInputPtr, hsa_ext_sampler_coordinate_mode_t input);

/// Gets the string representation of the hsa_ext_sampler_filter_mode_t type
/// \param input the input hsa_ext_sampler_filter_mode_t
/// \return the string representation of the hsa_ext_sampler_filter_mode_t
std::string Get_hsa_ext_sampler_filter_mode_t_String(hsa_ext_sampler_filter_mode_t input);

/// Gets the string representation of the hsa_ext_sampler_filter_mode_t pointer type
/// \param pInputPtr the input hsa_ext_sampler_filter_mode_t pointer
/// \param input the input hsa_ext_sampler_filter_mode_t
/// \return the string representation of the hsa_ext_sampler_filter_mode_t
std::string Get_hsa_ext_sampler_filter_mode_t_Ptr_String(const hsa_ext_sampler_filter_mode_t* pInputPtr, hsa_ext_sampler_filter_mode_t input);

/// Gets the string representation of the hsa_ext_sampler_descriptor_t type
/// \param input the input hsa_ext_sampler_descriptor_t
/// \return the string representation of the hsa_ext_sampler_descriptor_t
std::string Get_hsa_ext_sampler_descriptor_t_String(hsa_ext_sampler_descriptor_t input);

/// Gets the string representation of the hsa_ext_sampler_descriptor_t pointer type
/// \param pInputPtr the input hsa_ext_sampler_descriptor_t pointer
/// \param input the input hsa_ext_sampler_descriptor_t
/// \return the string representation of the hsa_ext_sampler_descriptor_t
std::string Get_hsa_ext_sampler_descriptor_t_Ptr_String(const hsa_ext_sampler_descriptor_t* pInputPtr, hsa_ext_sampler_descriptor_t input);

/// Gets the string representation of the hsa_amd_agent_info_t type
/// \param input the input hsa_amd_agent_info_t
/// \return the string representation of the hsa_amd_agent_info_t
std::string Get_hsa_amd_agent_info_t_String(hsa_amd_agent_info_t input);

/// Gets the string representation of the hsa_amd_agent_info_t pointer type
/// \param pInputPtr the input hsa_amd_agent_info_t pointer
/// \param input the input hsa_amd_agent_info_t
/// \return the string representation of the hsa_amd_agent_info_t
std::string Get_hsa_amd_agent_info_t_Ptr_String(const hsa_amd_agent_info_t* pInputPtr, hsa_amd_agent_info_t input);

/// Gets the string representation of the hsa_amd_region_info_t type
/// \param input the input hsa_amd_region_info_t
/// \return the string representation of the hsa_amd_region_info_t
std::string Get_hsa_amd_region_info_t_String(hsa_amd_region_info_t input);

/// Gets the string representation of the hsa_amd_region_info_t pointer type
/// \param pInputPtr the input hsa_amd_region_info_t pointer
/// \param input the input hsa_amd_region_info_t
/// \return the string representation of the hsa_amd_region_info_t
std::string Get_hsa_amd_region_info_t_Ptr_String(const hsa_amd_region_info_t* pInputPtr, hsa_amd_region_info_t input);

/// Gets the string representation of the hsa_amd_coherency_type_t type
/// \param input the input hsa_amd_coherency_type_t
/// \return the string representation of the hsa_amd_coherency_type_t
std::string Get_hsa_amd_coherency_type_t_String(hsa_amd_coherency_type_t input);

/// Gets the string representation of the hsa_amd_coherency_type_t pointer type
/// \param pInputPtr the input hsa_amd_coherency_type_t pointer
/// \param input the input hsa_amd_coherency_type_t
/// \return the string representation of the hsa_amd_coherency_type_t
std::string Get_hsa_amd_coherency_type_t_Ptr_String(const hsa_amd_coherency_type_t* pInputPtr, hsa_amd_coherency_type_t input);

/// Gets the string representation of the hsa_amd_profiling_dispatch_time_t type
/// \param input the input hsa_amd_profiling_dispatch_time_t
/// \return the string representation of the hsa_amd_profiling_dispatch_time_t
std::string Get_hsa_amd_profiling_dispatch_time_t_String(hsa_amd_profiling_dispatch_time_t input);

/// Gets the string representation of the hsa_amd_profiling_dispatch_time_t pointer type
/// \param pInputPtr the input hsa_amd_profiling_dispatch_time_t pointer
/// \param input the input hsa_amd_profiling_dispatch_time_t
/// \return the string representation of the hsa_amd_profiling_dispatch_time_t
std::string Get_hsa_amd_profiling_dispatch_time_t_Ptr_String(const hsa_amd_profiling_dispatch_time_t* pInputPtr, hsa_amd_profiling_dispatch_time_t input);

/// Gets the string representation of the hsa_amd_profiling_async_copy_time_t type
/// \param input the input hsa_amd_profiling_async_copy_time_t
/// \return the string representation of the hsa_amd_profiling_async_copy_time_t
std::string Get_hsa_amd_profiling_async_copy_time_t_String(hsa_amd_profiling_async_copy_time_t input);

/// Gets the string representation of the hsa_amd_profiling_async_copy_time_t pointer type
/// \param pInputPtr the input hsa_amd_profiling_async_copy_time_t pointer
/// \param input the input hsa_amd_profiling_async_copy_time_t
/// \return the string representation of the hsa_amd_profiling_async_copy_time_t
std::string Get_hsa_amd_profiling_async_copy_time_t_Ptr_String(const hsa_amd_profiling_async_copy_time_t* pInputPtr, hsa_amd_profiling_async_copy_time_t input);

/// Gets the string representation of the hsa_amd_signal_attribute_t type
/// \param input the input hsa_amd_signal_attribute_t
/// \return the string representation of the hsa_amd_signal_attribute_t
std::string Get_hsa_amd_signal_attribute_t_String(hsa_amd_signal_attribute_t input);

/// Gets the string representation of the hsa_amd_signal_attribute_t pointer type
/// \param pInputPtr the input hsa_amd_signal_attribute_t pointer
/// \param input the input hsa_amd_signal_attribute_t
/// \return the string representation of the hsa_amd_signal_attribute_t
std::string Get_hsa_amd_signal_attribute_t_Ptr_String(const hsa_amd_signal_attribute_t* pInputPtr, hsa_amd_signal_attribute_t input);

/// Gets the string representation of the hsa_amd_segment_t type
/// \param input the input hsa_amd_segment_t
/// \return the string representation of the hsa_amd_segment_t
std::string Get_hsa_amd_segment_t_String(hsa_amd_segment_t input);

/// Gets the string representation of the hsa_amd_segment_t pointer type
/// \param pInputPtr the input hsa_amd_segment_t pointer
/// \param input the input hsa_amd_segment_t
/// \return the string representation of the hsa_amd_segment_t
std::string Get_hsa_amd_segment_t_Ptr_String(const hsa_amd_segment_t* pInputPtr, hsa_amd_segment_t input);

/// Gets the string representation of the hsa_amd_memory_pool_t type
/// \param input the input hsa_amd_memory_pool_t
/// \return the string representation of the hsa_amd_memory_pool_t
std::string Get_hsa_amd_memory_pool_t_String(hsa_amd_memory_pool_t input);

/// Gets the string representation of the hsa_amd_memory_pool_t pointer type
/// \param pInputPtr the input hsa_amd_memory_pool_t pointer
/// \param input the input hsa_amd_memory_pool_t
/// \return the string representation of the hsa_amd_memory_pool_t
std::string Get_hsa_amd_memory_pool_t_Ptr_String(const hsa_amd_memory_pool_t* pInputPtr, hsa_amd_memory_pool_t input);

/// Gets the string representation of the hsa_amd_memory_pool_global_flag_t type
/// \param input the input hsa_amd_memory_pool_global_flag_t
/// \return the string representation of the hsa_amd_memory_pool_global_flag_t
std::string Get_hsa_amd_memory_pool_global_flag_t_String(hsa_amd_memory_pool_global_flag_t input);

/// Gets the string representation of the hsa_amd_memory_pool_global_flag_t pointer type
/// \param pInputPtr the input hsa_amd_memory_pool_global_flag_t pointer
/// \param input the input hsa_amd_memory_pool_global_flag_t
/// \return the string representation of the hsa_amd_memory_pool_global_flag_t
std::string Get_hsa_amd_memory_pool_global_flag_t_Ptr_String(const hsa_amd_memory_pool_global_flag_t* pInputPtr, hsa_amd_memory_pool_global_flag_t input);

/// Gets the string representation of the hsa_amd_memory_pool_info_t type
/// \param input the input hsa_amd_memory_pool_info_t
/// \return the string representation of the hsa_amd_memory_pool_info_t
std::string Get_hsa_amd_memory_pool_info_t_String(hsa_amd_memory_pool_info_t input);

/// Gets the string representation of the hsa_amd_memory_pool_info_t pointer type
/// \param pInputPtr the input hsa_amd_memory_pool_info_t pointer
/// \param input the input hsa_amd_memory_pool_info_t
/// \return the string representation of the hsa_amd_memory_pool_info_t
std::string Get_hsa_amd_memory_pool_info_t_Ptr_String(const hsa_amd_memory_pool_info_t* pInputPtr, hsa_amd_memory_pool_info_t input);

/// Gets the string representation of the hsa_pitched_ptr_t type
/// \param input the input hsa_pitched_ptr_t
/// \return the string representation of the hsa_pitched_ptr_t
std::string Get_hsa_pitched_ptr_t_String(hsa_pitched_ptr_t input);

/// Gets the string representation of the hsa_pitched_ptr_t pointer type
/// \param pInputPtr the input hsa_pitched_ptr_t pointer
/// \param input the input hsa_pitched_ptr_t
/// \return the string representation of the hsa_pitched_ptr_t
std::string Get_hsa_pitched_ptr_t_Ptr_String(const hsa_pitched_ptr_t* pInputPtr, hsa_pitched_ptr_t input);

/// Gets the string representation of the hsa_amd_copy_direction_t type
/// \param input the input hsa_amd_copy_direction_t
/// \return the string representation of the hsa_amd_copy_direction_t
std::string Get_hsa_amd_copy_direction_t_String(hsa_amd_copy_direction_t input);

/// Gets the string representation of the hsa_amd_copy_direction_t pointer type
/// \param pInputPtr the input hsa_amd_copy_direction_t pointer
/// \param input the input hsa_amd_copy_direction_t
/// \return the string representation of the hsa_amd_copy_direction_t
std::string Get_hsa_amd_copy_direction_t_Ptr_String(const hsa_amd_copy_direction_t* pInputPtr, hsa_amd_copy_direction_t input);

/// Gets the string representation of the hsa_amd_memory_pool_access_t type
/// \param input the input hsa_amd_memory_pool_access_t
/// \return the string representation of the hsa_amd_memory_pool_access_t
std::string Get_hsa_amd_memory_pool_access_t_String(hsa_amd_memory_pool_access_t input);

/// Gets the string representation of the hsa_amd_memory_pool_access_t pointer type
/// \param pInputPtr the input hsa_amd_memory_pool_access_t pointer
/// \param input the input hsa_amd_memory_pool_access_t
/// \return the string representation of the hsa_amd_memory_pool_access_t
std::string Get_hsa_amd_memory_pool_access_t_Ptr_String(const hsa_amd_memory_pool_access_t* pInputPtr, hsa_amd_memory_pool_access_t input);

/// Gets the string representation of the hsa_amd_link_info_type_t type
/// \param input the input hsa_amd_link_info_type_t
/// \return the string representation of the hsa_amd_link_info_type_t
std::string Get_hsa_amd_link_info_type_t_String(hsa_amd_link_info_type_t input);

/// Gets the string representation of the hsa_amd_link_info_type_t pointer type
/// \param pInputPtr the input hsa_amd_link_info_type_t pointer
/// \param input the input hsa_amd_link_info_type_t
/// \return the string representation of the hsa_amd_link_info_type_t
std::string Get_hsa_amd_link_info_type_t_Ptr_String(const hsa_amd_link_info_type_t* pInputPtr, hsa_amd_link_info_type_t input);

/// Gets the string representation of the hsa_amd_memory_pool_link_info_t type
/// \param input the input hsa_amd_memory_pool_link_info_t
/// \return the string representation of the hsa_amd_memory_pool_link_info_t
std::string Get_hsa_amd_memory_pool_link_info_t_String(hsa_amd_memory_pool_link_info_t input);

/// Gets the string representation of the hsa_amd_memory_pool_link_info_t pointer type
/// \param pInputPtr the input hsa_amd_memory_pool_link_info_t pointer
/// \param input the input hsa_amd_memory_pool_link_info_t
/// \return the string representation of the hsa_amd_memory_pool_link_info_t
std::string Get_hsa_amd_memory_pool_link_info_t_Ptr_String(const hsa_amd_memory_pool_link_info_t* pInputPtr, hsa_amd_memory_pool_link_info_t input);

/// Gets the string representation of the hsa_amd_agent_memory_pool_info_t type
/// \param input the input hsa_amd_agent_memory_pool_info_t
/// \return the string representation of the hsa_amd_agent_memory_pool_info_t
std::string Get_hsa_amd_agent_memory_pool_info_t_String(hsa_amd_agent_memory_pool_info_t input);

/// Gets the string representation of the hsa_amd_agent_memory_pool_info_t pointer type
/// \param pInputPtr the input hsa_amd_agent_memory_pool_info_t pointer
/// \param input the input hsa_amd_agent_memory_pool_info_t
/// \return the string representation of the hsa_amd_agent_memory_pool_info_t
std::string Get_hsa_amd_agent_memory_pool_info_t_Ptr_String(const hsa_amd_agent_memory_pool_info_t* pInputPtr, hsa_amd_agent_memory_pool_info_t input);

/// Gets the string representation of the hsa_amd_image_descriptor_t type
/// \param input the input hsa_amd_image_descriptor_t
/// \return the string representation of the hsa_amd_image_descriptor_t
std::string Get_hsa_amd_image_descriptor_t_String(hsa_amd_image_descriptor_t input);

/// Gets the string representation of the hsa_amd_image_descriptor_t pointer type
/// \param pInputPtr the input hsa_amd_image_descriptor_t pointer
/// \param input the input hsa_amd_image_descriptor_t
/// \return the string representation of the hsa_amd_image_descriptor_t
std::string Get_hsa_amd_image_descriptor_t_Ptr_String(const hsa_amd_image_descriptor_t* pInputPtr, hsa_amd_image_descriptor_t input);

/// Gets the string representation of the hsa_amd_pointer_type_t type
/// \param input the input hsa_amd_pointer_type_t
/// \return the string representation of the hsa_amd_pointer_type_t
std::string Get_hsa_amd_pointer_type_t_String(hsa_amd_pointer_type_t input);

/// Gets the string representation of the hsa_amd_pointer_type_t pointer type
/// \param pInputPtr the input hsa_amd_pointer_type_t pointer
/// \param input the input hsa_amd_pointer_type_t
/// \return the string representation of the hsa_amd_pointer_type_t
std::string Get_hsa_amd_pointer_type_t_Ptr_String(const hsa_amd_pointer_type_t* pInputPtr, hsa_amd_pointer_type_t input);

/// Gets the string representation of the hsa_amd_pointer_info_t type
/// \param input the input hsa_amd_pointer_info_t
/// \return the string representation of the hsa_amd_pointer_info_t
std::string Get_hsa_amd_pointer_info_t_String(hsa_amd_pointer_info_t input);

/// Gets the string representation of the hsa_amd_pointer_info_t pointer type
/// \param pInputPtr the input hsa_amd_pointer_info_t pointer
/// \param input the input hsa_amd_pointer_info_t
/// \return the string representation of the hsa_amd_pointer_info_t
std::string Get_hsa_amd_pointer_info_t_Ptr_String(const hsa_amd_pointer_info_t* pInputPtr, hsa_amd_pointer_info_t input);

/// Gets the string representation of the hsa_amd_ipc_memory_t type
/// \param input the input hsa_amd_ipc_memory_t
/// \return the string representation of the hsa_amd_ipc_memory_t
std::string Get_hsa_amd_ipc_memory_t_String(hsa_amd_ipc_memory_t input);

/// Gets the string representation of the hsa_amd_ipc_memory_t pointer type
/// \param pInputPtr the input hsa_amd_ipc_memory_t pointer
/// \param input the input hsa_amd_ipc_memory_t
/// \return the string representation of the hsa_amd_ipc_memory_t
std::string Get_hsa_amd_ipc_memory_t_Ptr_String(const hsa_amd_ipc_memory_t* pInputPtr, hsa_amd_ipc_memory_t input);

/// Gets the string representation of the hsa_amd_event_type_t type
/// \param input the input hsa_amd_event_type_t
/// \return the string representation of the hsa_amd_event_type_t
std::string Get_hsa_amd_event_type_t_String(hsa_amd_event_type_t input);

/// Gets the string representation of the hsa_amd_event_type_t pointer type
/// \param pInputPtr the input hsa_amd_event_type_t pointer
/// \param input the input hsa_amd_event_type_t
/// \return the string representation of the hsa_amd_event_type_t
std::string Get_hsa_amd_event_type_t_Ptr_String(const hsa_amd_event_type_t* pInputPtr, hsa_amd_event_type_t input);

/// Gets the string representation of the hsa_amd_gpu_memory_fault_info_t type
/// \param input the input hsa_amd_gpu_memory_fault_info_t
/// \return the string representation of the hsa_amd_gpu_memory_fault_info_t
std::string Get_hsa_amd_gpu_memory_fault_info_t_String(hsa_amd_gpu_memory_fault_info_t input);

/// Gets the string representation of the hsa_amd_gpu_memory_fault_info_t pointer type
/// \param pInputPtr the input hsa_amd_gpu_memory_fault_info_t pointer
/// \param input the input hsa_amd_gpu_memory_fault_info_t
/// \return the string representation of the hsa_amd_gpu_memory_fault_info_t
std::string Get_hsa_amd_gpu_memory_fault_info_t_Ptr_String(const hsa_amd_gpu_memory_fault_info_t* pInputPtr, hsa_amd_gpu_memory_fault_info_t input);

/// Gets the string representation of the hsa_amd_event_t type
/// \param input the input hsa_amd_event_t
/// \return the string representation of the hsa_amd_event_t
std::string Get_hsa_amd_event_t_String(hsa_amd_event_t input);

/// Gets the string representation of the hsa_amd_event_t pointer type
/// \param pInputPtr the input hsa_amd_event_t pointer
/// \param input the input hsa_amd_event_t
/// \return the string representation of the hsa_amd_event_t
std::string Get_hsa_amd_event_t_Ptr_String(const hsa_amd_event_t* pInputPtr, hsa_amd_event_t input);

/// Gets the string representation of the hsa_amd_queue_priority_t type
/// \param input the input hsa_amd_queue_priority_t
/// \return the string representation of the hsa_amd_queue_priority_t
std::string Get_hsa_amd_queue_priority_t_String(hsa_amd_queue_priority_t input);

/// Gets the string representation of the hsa_amd_queue_priority_t pointer type
/// \param pInputPtr the input hsa_amd_queue_priority_t pointer
/// \param input the input hsa_amd_queue_priority_t
/// \return the string representation of the hsa_amd_queue_priority_t
std::string Get_hsa_amd_queue_priority_t_Ptr_String(const hsa_amd_queue_priority_t* pInputPtr, hsa_amd_queue_priority_t input);

/// Gets the string representation of the hsa_ven_amd_loader_code_object_storage_type_t type
/// \param input the input hsa_ven_amd_loader_code_object_storage_type_t
/// \return the string representation of the hsa_ven_amd_loader_code_object_storage_type_t
std::string Get_hsa_ven_amd_loader_code_object_storage_type_t_String(hsa_ven_amd_loader_code_object_storage_type_t input);

/// Gets the string representation of the hsa_ven_amd_loader_code_object_storage_type_t pointer type
/// \param pInputPtr the input hsa_ven_amd_loader_code_object_storage_type_t pointer
/// \param input the input hsa_ven_amd_loader_code_object_storage_type_t
/// \return the string representation of the hsa_ven_amd_loader_code_object_storage_type_t
std::string Get_hsa_ven_amd_loader_code_object_storage_type_t_Ptr_String(const hsa_ven_amd_loader_code_object_storage_type_t* pInputPtr, hsa_ven_amd_loader_code_object_storage_type_t input);

/// Gets the string representation of the hsa_ven_amd_loader_segment_descriptor_t type
/// \param input the input hsa_ven_amd_loader_segment_descriptor_t
/// \return the string representation of the hsa_ven_amd_loader_segment_descriptor_t
std::string Get_hsa_ven_amd_loader_segment_descriptor_t_String(hsa_ven_amd_loader_segment_descriptor_t input);

/// Gets the string representation of the hsa_ven_amd_loader_segment_descriptor_t pointer type
/// \param pInputPtr the input hsa_ven_amd_loader_segment_descriptor_t pointer
/// \param input the input hsa_ven_amd_loader_segment_descriptor_t
/// \return the string representation of the hsa_ven_amd_loader_segment_descriptor_t
std::string Get_hsa_ven_amd_loader_segment_descriptor_t_Ptr_String(const hsa_ven_amd_loader_segment_descriptor_t* pInputPtr, hsa_ven_amd_loader_segment_descriptor_t input);

/// Gets the string representation of the hsa_ven_amd_loader_loaded_code_object_kind_t type
/// \param input the input hsa_ven_amd_loader_loaded_code_object_kind_t
/// \return the string representation of the hsa_ven_amd_loader_loaded_code_object_kind_t
std::string Get_hsa_ven_amd_loader_loaded_code_object_kind_t_String(hsa_ven_amd_loader_loaded_code_object_kind_t input);

/// Gets the string representation of the hsa_ven_amd_loader_loaded_code_object_kind_t pointer type
/// \param pInputPtr the input hsa_ven_amd_loader_loaded_code_object_kind_t pointer
/// \param input the input hsa_ven_amd_loader_loaded_code_object_kind_t
/// \return the string representation of the hsa_ven_amd_loader_loaded_code_object_kind_t
std::string Get_hsa_ven_amd_loader_loaded_code_object_kind_t_Ptr_String(const hsa_ven_amd_loader_loaded_code_object_kind_t* pInputPtr, hsa_ven_amd_loader_loaded_code_object_kind_t input);

/// Gets the string representation of the hsa_ven_amd_loader_loaded_code_object_info_t type
/// \param input the input hsa_ven_amd_loader_loaded_code_object_info_t
/// \return the string representation of the hsa_ven_amd_loader_loaded_code_object_info_t
std::string Get_hsa_ven_amd_loader_loaded_code_object_info_t_String(hsa_ven_amd_loader_loaded_code_object_info_t input);

/// Gets the string representation of the hsa_ven_amd_loader_loaded_code_object_info_t pointer type
/// \param pInputPtr the input hsa_ven_amd_loader_loaded_code_object_info_t pointer
/// \param input the input hsa_ven_amd_loader_loaded_code_object_info_t
/// \return the string representation of the hsa_ven_amd_loader_loaded_code_object_info_t
std::string Get_hsa_ven_amd_loader_loaded_code_object_info_t_Ptr_String(const hsa_ven_amd_loader_loaded_code_object_info_t* pInputPtr, hsa_ven_amd_loader_loaded_code_object_info_t input);

/// Gets the string representation of the hsa_ven_amd_aqlprofile_event_type_t type
/// \param input the input hsa_ven_amd_aqlprofile_event_type_t
/// \return the string representation of the hsa_ven_amd_aqlprofile_event_type_t
std::string Get_hsa_ven_amd_aqlprofile_event_type_t_String(hsa_ven_amd_aqlprofile_event_type_t input);

/// Gets the string representation of the hsa_ven_amd_aqlprofile_event_type_t pointer type
/// \param pInputPtr the input hsa_ven_amd_aqlprofile_event_type_t pointer
/// \param input the input hsa_ven_amd_aqlprofile_event_type_t
/// \return the string representation of the hsa_ven_amd_aqlprofile_event_type_t
std::string Get_hsa_ven_amd_aqlprofile_event_type_t_Ptr_String(const hsa_ven_amd_aqlprofile_event_type_t* pInputPtr, hsa_ven_amd_aqlprofile_event_type_t input);

/// Gets the string representation of the hsa_ven_amd_aqlprofile_block_name_t type
/// \param input the input hsa_ven_amd_aqlprofile_block_name_t
/// \return the string representation of the hsa_ven_amd_aqlprofile_block_name_t
std::string Get_hsa_ven_amd_aqlprofile_block_name_t_String(hsa_ven_amd_aqlprofile_block_name_t input);

/// Gets the string representation of the hsa_ven_amd_aqlprofile_block_name_t pointer type
/// \param pInputPtr the input hsa_ven_amd_aqlprofile_block_name_t pointer
/// \param input the input hsa_ven_amd_aqlprofile_block_name_t
/// \return the string representation of the hsa_ven_amd_aqlprofile_block_name_t
std::string Get_hsa_ven_amd_aqlprofile_block_name_t_Ptr_String(const hsa_ven_amd_aqlprofile_block_name_t* pInputPtr, hsa_ven_amd_aqlprofile_block_name_t input);

/// Gets the string representation of the hsa_ven_amd_aqlprofile_event_t type
/// \param input the input hsa_ven_amd_aqlprofile_event_t
/// \return the string representation of the hsa_ven_amd_aqlprofile_event_t
std::string Get_hsa_ven_amd_aqlprofile_event_t_String(hsa_ven_amd_aqlprofile_event_t input);

/// Gets the string representation of the hsa_ven_amd_aqlprofile_event_t pointer type
/// \param pInputPtr the input hsa_ven_amd_aqlprofile_event_t pointer
/// \param input the input hsa_ven_amd_aqlprofile_event_t
/// \return the string representation of the hsa_ven_amd_aqlprofile_event_t
std::string Get_hsa_ven_amd_aqlprofile_event_t_Ptr_String(const hsa_ven_amd_aqlprofile_event_t* pInputPtr, hsa_ven_amd_aqlprofile_event_t input);

/// Gets the string representation of the hsa_ven_amd_aqlprofile_parameter_name_t type
/// \param input the input hsa_ven_amd_aqlprofile_parameter_name_t
/// \return the string representation of the hsa_ven_amd_aqlprofile_parameter_name_t
std::string Get_hsa_ven_amd_aqlprofile_parameter_name_t_String(hsa_ven_amd_aqlprofile_parameter_name_t input);

/// Gets the string representation of the hsa_ven_amd_aqlprofile_parameter_name_t pointer type
/// \param pInputPtr the input hsa_ven_amd_aqlprofile_parameter_name_t pointer
/// \param input the input hsa_ven_amd_aqlprofile_parameter_name_t
/// \return the string representation of the hsa_ven_amd_aqlprofile_parameter_name_t
std::string Get_hsa_ven_amd_aqlprofile_parameter_name_t_Ptr_String(const hsa_ven_amd_aqlprofile_parameter_name_t* pInputPtr, hsa_ven_amd_aqlprofile_parameter_name_t input);

/// Gets the string representation of the hsa_ven_amd_aqlprofile_parameter_t type
/// \param input the input hsa_ven_amd_aqlprofile_parameter_t
/// \return the string representation of the hsa_ven_amd_aqlprofile_parameter_t
std::string Get_hsa_ven_amd_aqlprofile_parameter_t_String(hsa_ven_amd_aqlprofile_parameter_t input);

/// Gets the string representation of the hsa_ven_amd_aqlprofile_parameter_t pointer type
/// \param pInputPtr the input hsa_ven_amd_aqlprofile_parameter_t pointer
/// \param input the input hsa_ven_amd_aqlprofile_parameter_t
/// \return the string representation of the hsa_ven_amd_aqlprofile_parameter_t
std::string Get_hsa_ven_amd_aqlprofile_parameter_t_Ptr_String(const hsa_ven_amd_aqlprofile_parameter_t* pInputPtr, hsa_ven_amd_aqlprofile_parameter_t input);

/// Gets the string representation of the hsa_ven_amd_aqlprofile_descriptor_t type
/// \param input the input hsa_ven_amd_aqlprofile_descriptor_t
/// \return the string representation of the hsa_ven_amd_aqlprofile_descriptor_t
std::string Get_hsa_ven_amd_aqlprofile_descriptor_t_String(hsa_ven_amd_aqlprofile_descriptor_t input);

/// Gets the string representation of the hsa_ven_amd_aqlprofile_descriptor_t pointer type
/// \param pInputPtr the input hsa_ven_amd_aqlprofile_descriptor_t pointer
/// \param input the input hsa_ven_amd_aqlprofile_descriptor_t
/// \return the string representation of the hsa_ven_amd_aqlprofile_descriptor_t
std::string Get_hsa_ven_amd_aqlprofile_descriptor_t_Ptr_String(const hsa_ven_amd_aqlprofile_descriptor_t* pInputPtr, hsa_ven_amd_aqlprofile_descriptor_t input);

/// Gets the string representation of the hsa_ven_amd_aqlprofile_profile_t type
/// \param input the input hsa_ven_amd_aqlprofile_profile_t
/// \return the string representation of the hsa_ven_amd_aqlprofile_profile_t
std::string Get_hsa_ven_amd_aqlprofile_profile_t_String(hsa_ven_amd_aqlprofile_profile_t input);

/// Gets the string representation of the hsa_ven_amd_aqlprofile_profile_t pointer type
/// \param pInputPtr the input hsa_ven_amd_aqlprofile_profile_t pointer
/// \param input the input hsa_ven_amd_aqlprofile_profile_t
/// \return the string representation of the hsa_ven_amd_aqlprofile_profile_t
std::string Get_hsa_ven_amd_aqlprofile_profile_t_Ptr_String(const hsa_ven_amd_aqlprofile_profile_t* pInputPtr, hsa_ven_amd_aqlprofile_profile_t input);

/// Gets the string representation of the hsa_ext_amd_aql_pm4_packet_t type
/// \param input the input hsa_ext_amd_aql_pm4_packet_t
/// \return the string representation of the hsa_ext_amd_aql_pm4_packet_t
std::string Get_hsa_ext_amd_aql_pm4_packet_t_String(hsa_ext_amd_aql_pm4_packet_t input);

/// Gets the string representation of the hsa_ext_amd_aql_pm4_packet_t pointer type
/// \param pInputPtr the input hsa_ext_amd_aql_pm4_packet_t pointer
/// \param input the input hsa_ext_amd_aql_pm4_packet_t
/// \return the string representation of the hsa_ext_amd_aql_pm4_packet_t
std::string Get_hsa_ext_amd_aql_pm4_packet_t_Ptr_String(const hsa_ext_amd_aql_pm4_packet_t* pInputPtr, hsa_ext_amd_aql_pm4_packet_t input);

/// Gets the string representation of the hsa_ven_amd_aqlprofile_info_data_t type
/// \param input the input hsa_ven_amd_aqlprofile_info_data_t
/// \return the string representation of the hsa_ven_amd_aqlprofile_info_data_t
std::string Get_hsa_ven_amd_aqlprofile_info_data_t_String(hsa_ven_amd_aqlprofile_info_data_t input);

/// Gets the string representation of the hsa_ven_amd_aqlprofile_info_data_t pointer type
/// \param pInputPtr the input hsa_ven_amd_aqlprofile_info_data_t pointer
/// \param input the input hsa_ven_amd_aqlprofile_info_data_t
/// \return the string representation of the hsa_ven_amd_aqlprofile_info_data_t
std::string Get_hsa_ven_amd_aqlprofile_info_data_t_Ptr_String(const hsa_ven_amd_aqlprofile_info_data_t* pInputPtr, hsa_ven_amd_aqlprofile_info_data_t input);

/// Gets the string representation of the hsa_ven_amd_aqlprofile_id_query_t type
/// \param input the input hsa_ven_amd_aqlprofile_id_query_t
/// \return the string representation of the hsa_ven_amd_aqlprofile_id_query_t
std::string Get_hsa_ven_amd_aqlprofile_id_query_t_String(hsa_ven_amd_aqlprofile_id_query_t input);

/// Gets the string representation of the hsa_ven_amd_aqlprofile_id_query_t pointer type
/// \param pInputPtr the input hsa_ven_amd_aqlprofile_id_query_t pointer
/// \param input the input hsa_ven_amd_aqlprofile_id_query_t
/// \return the string representation of the hsa_ven_amd_aqlprofile_id_query_t
std::string Get_hsa_ven_amd_aqlprofile_id_query_t_Ptr_String(const hsa_ven_amd_aqlprofile_id_query_t* pInputPtr, hsa_ven_amd_aqlprofile_id_query_t input);

/// Gets the string representation of the hsa_ven_amd_aqlprofile_info_type_t type
/// \param input the input hsa_ven_amd_aqlprofile_info_type_t
/// \return the string representation of the hsa_ven_amd_aqlprofile_info_type_t
std::string Get_hsa_ven_amd_aqlprofile_info_type_t_String(hsa_ven_amd_aqlprofile_info_type_t input);

/// Gets the string representation of the hsa_ven_amd_aqlprofile_info_type_t pointer type
/// \param pInputPtr the input hsa_ven_amd_aqlprofile_info_type_t pointer
/// \param input the input hsa_ven_amd_aqlprofile_info_type_t
/// \return the string representation of the hsa_ven_amd_aqlprofile_info_type_t
std::string Get_hsa_ven_amd_aqlprofile_info_type_t_Ptr_String(const hsa_ven_amd_aqlprofile_info_type_t* pInputPtr, hsa_ven_amd_aqlprofile_info_type_t input);

}


#endif // _HSATRACESTRINGOUTPUT_H_

