//==============================================================================
// Copyright (c) 2015-2018 Advanced Micro Devices, Inc. All rights reserved.
/// \author AMD Developer Tools Team
/// \file
/// \brief THIS CODE WAS AUTOGENERATED BY HSA CODE GENERATOR
//==============================================================================


#include "../../Common/ProfilerOutputFileDefs.h"
#include "../HSATraceStringUtils.h"
#include "HSAAgentUtils.h"
#include "HSATraceStringOutput.h"

namespace HSATraceStringUtils
{
    static const char* s_pFieldSeparator = ATP_TRACE_STRUCT_ARG_SEPARATOR; ///< separator between fields in a structure
}

std::string HSATraceStringUtils::Get_hsa_status_t_String(hsa_status_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_STATUS_SUCCESS);
            CASE(HSA_STATUS_INFO_BREAK);
            CASE(HSA_STATUS_ERROR);
            CASE(HSA_STATUS_ERROR_INVALID_ARGUMENT);
            CASE(HSA_STATUS_ERROR_INVALID_QUEUE_CREATION);
            CASE(HSA_STATUS_ERROR_INVALID_ALLOCATION);
            CASE(HSA_STATUS_ERROR_INVALID_AGENT);
            CASE(HSA_STATUS_ERROR_INVALID_REGION);
            CASE(HSA_STATUS_ERROR_INVALID_SIGNAL);
            CASE(HSA_STATUS_ERROR_INVALID_QUEUE);
            CASE(HSA_STATUS_ERROR_OUT_OF_RESOURCES);
            CASE(HSA_STATUS_ERROR_INVALID_PACKET_FORMAT);
            CASE(HSA_STATUS_ERROR_RESOURCE_FREE);
            CASE(HSA_STATUS_ERROR_NOT_INITIALIZED);
            CASE(HSA_STATUS_ERROR_REFCOUNT_OVERFLOW);
            CASE(HSA_STATUS_ERROR_INCOMPATIBLE_ARGUMENTS);
            CASE(HSA_STATUS_ERROR_INVALID_INDEX);
            CASE(HSA_STATUS_ERROR_INVALID_ISA);
            CASE(HSA_STATUS_ERROR_INVALID_ISA_NAME);
            CASE(HSA_STATUS_ERROR_INVALID_CODE_OBJECT);
            CASE(HSA_STATUS_ERROR_INVALID_EXECUTABLE);
            CASE(HSA_STATUS_ERROR_FROZEN_EXECUTABLE);
            CASE(HSA_STATUS_ERROR_INVALID_SYMBOL_NAME);
            CASE(HSA_STATUS_ERROR_VARIABLE_ALREADY_DEFINED);
            CASE(HSA_STATUS_ERROR_VARIABLE_UNDEFINED);
            CASE(HSA_STATUS_ERROR_EXCEPTION);
            CASE(HSA_STATUS_ERROR_INVALID_CODE_SYMBOL);
            CASE(HSA_STATUS_ERROR_INVALID_EXECUTABLE_SYMBOL);
            CASE(HSA_STATUS_ERROR_INVALID_FILE);
            CASE(HSA_STATUS_ERROR_INVALID_CODE_OBJECT_READER);
            CASE(HSA_STATUS_ERROR_INVALID_CACHE);
            CASE(HSA_STATUS_ERROR_INVALID_WAVEFRONT);
            CASE(HSA_STATUS_ERROR_INVALID_SIGNAL_GROUP);
            CASE(HSA_STATUS_ERROR_INVALID_RUNTIME_STATE);
            CASE(HSA_STATUS_ERROR_FATAL);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_status_t_Ptr_String(const hsa_status_t* pInputPtr, hsa_status_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_status_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_dim3_t_String(hsa_dim3_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.x) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.y) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.z);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_dim3_t_Ptr_String(const hsa_dim3_t* pInputPtr, hsa_dim3_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_dim3_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_access_permission_t_String(hsa_access_permission_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_ACCESS_PERMISSION_RO);
            CASE(HSA_ACCESS_PERMISSION_WO);
            CASE(HSA_ACCESS_PERMISSION_RW);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_access_permission_t_Ptr_String(const hsa_access_permission_t* pInputPtr, hsa_access_permission_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_access_permission_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_endianness_t_String(hsa_endianness_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_ENDIANNESS_LITTLE);
            CASE(HSA_ENDIANNESS_BIG);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_endianness_t_Ptr_String(const hsa_endianness_t* pInputPtr, hsa_endianness_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_endianness_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_machine_model_t_String(hsa_machine_model_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_MACHINE_MODEL_SMALL);
            CASE(HSA_MACHINE_MODEL_LARGE);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_machine_model_t_Ptr_String(const hsa_machine_model_t* pInputPtr, hsa_machine_model_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_machine_model_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_profile_t_String(hsa_profile_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_PROFILE_BASE);
            CASE(HSA_PROFILE_FULL);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_profile_t_Ptr_String(const hsa_profile_t* pInputPtr, hsa_profile_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_profile_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_system_info_t_String(hsa_system_info_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_SYSTEM_INFO_VERSION_MAJOR);
            CASE(HSA_SYSTEM_INFO_VERSION_MINOR);
            CASE(HSA_SYSTEM_INFO_TIMESTAMP);
            CASE(HSA_SYSTEM_INFO_TIMESTAMP_FREQUENCY);
            CASE(HSA_SYSTEM_INFO_SIGNAL_MAX_WAIT);
            CASE(HSA_SYSTEM_INFO_ENDIANNESS);
            CASE(HSA_SYSTEM_INFO_MACHINE_MODEL);
            CASE(HSA_SYSTEM_INFO_EXTENSIONS);
            CASE(HSA_AMD_SYSTEM_INFO_BUILD_VERSION);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_system_info_t_Ptr_String(const hsa_system_info_t* pInputPtr, hsa_system_info_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_system_info_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_extension_t_String(hsa_extension_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_EXTENSION_FINALIZER);
            CASE(HSA_EXTENSION_IMAGES);
            CASE(HSA_EXTENSION_PERFORMANCE_COUNTERS);
            CASE(HSA_EXTENSION_PROFILING_EVENTS);
            CASE(HSA_AMD_FIRST_EXTENSION);
            CASE(HSA_EXTENSION_AMD_LOADER);
            CASE(HSA_EXTENSION_AMD_AQLPROFILE);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_extension_t_Ptr_String(const hsa_extension_t* pInputPtr, hsa_extension_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_extension_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_agent_t_String(hsa_agent_t input)
{
    std::ostringstream ss;

    ss << HSAAgentUtils::GetHSAAgentString(input, true);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_agent_t_Ptr_String(const hsa_agent_t* pInputPtr, hsa_agent_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_agent_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_agent_feature_t_String(hsa_agent_feature_t input)
{
    if (0 == input)
    {
        return "0";
    }

    std::ostringstream ss;
    unsigned int propVal = static_cast<unsigned int>(input);

    while (0 != propVal)
    {
        if (propVal & HSA_AGENT_FEATURE_KERNEL_DISPATCH)
        {
            ss << "HSA_AGENT_FEATURE_KERNEL_DISPATCH";
            propVal &= ~HSA_AGENT_FEATURE_KERNEL_DISPATCH;
        }
        else if (propVal & HSA_AGENT_FEATURE_AGENT_DISPATCH)
        {
            ss << "HSA_AGENT_FEATURE_AGENT_DISPATCH";
            propVal &= ~HSA_AGENT_FEATURE_AGENT_DISPATCH;
        }
        else
        {
            ss << StringUtils::ToString(propVal);
            propVal = 0;
        }

        if (propVal != 0)
        {
            ss << '|';
        }
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_agent_feature_t_Ptr_String(const hsa_agent_feature_t* pInputPtr, hsa_agent_feature_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_agent_feature_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_device_type_t_String(hsa_device_type_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_DEVICE_TYPE_CPU);
            CASE(HSA_DEVICE_TYPE_GPU);
            CASE(HSA_DEVICE_TYPE_DSP);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_device_type_t_Ptr_String(const hsa_device_type_t* pInputPtr, hsa_device_type_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_device_type_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_default_float_rounding_mode_t_String(hsa_default_float_rounding_mode_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_DEFAULT_FLOAT_ROUNDING_MODE_DEFAULT);
            CASE(HSA_DEFAULT_FLOAT_ROUNDING_MODE_ZERO);
            CASE(HSA_DEFAULT_FLOAT_ROUNDING_MODE_NEAR);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_default_float_rounding_mode_t_Ptr_String(const hsa_default_float_rounding_mode_t* pInputPtr, hsa_default_float_rounding_mode_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_default_float_rounding_mode_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_agent_info_t_String(hsa_agent_info_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_AGENT_INFO_NAME);
            CASE(HSA_AGENT_INFO_VENDOR_NAME);
            CASE(HSA_AGENT_INFO_FEATURE);
            CASE(HSA_AGENT_INFO_MACHINE_MODEL);
            CASE(HSA_AGENT_INFO_PROFILE);
            CASE(HSA_AGENT_INFO_DEFAULT_FLOAT_ROUNDING_MODE);
            CASE(HSA_AGENT_INFO_BASE_PROFILE_DEFAULT_FLOAT_ROUNDING_MODES);
            CASE(HSA_AGENT_INFO_FAST_F16_OPERATION);
            CASE(HSA_AGENT_INFO_WAVEFRONT_SIZE);
            CASE(HSA_AGENT_INFO_WORKGROUP_MAX_DIM);
            CASE(HSA_AGENT_INFO_WORKGROUP_MAX_SIZE);
            CASE(HSA_AGENT_INFO_GRID_MAX_DIM);
            CASE(HSA_AGENT_INFO_GRID_MAX_SIZE);
            CASE(HSA_AGENT_INFO_FBARRIER_MAX_SIZE);
            CASE(HSA_AGENT_INFO_QUEUES_MAX);
            CASE(HSA_AGENT_INFO_QUEUE_MIN_SIZE);
            CASE(HSA_AGENT_INFO_QUEUE_MAX_SIZE);
            CASE(HSA_AGENT_INFO_QUEUE_TYPE);
            CASE(HSA_AGENT_INFO_NODE);
            CASE(HSA_AGENT_INFO_DEVICE);
            CASE(HSA_AGENT_INFO_CACHE_SIZE);
            CASE(HSA_AGENT_INFO_ISA);
            CASE(HSA_AGENT_INFO_EXTENSIONS);
            CASE(HSA_AGENT_INFO_VERSION_MAJOR);
            CASE(HSA_AGENT_INFO_VERSION_MINOR);

        default:
            ss << Get_hsa_amd_agent_info_t_String(static_cast<hsa_amd_agent_info_t>(input));
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_agent_info_t_Ptr_String(const hsa_agent_info_t* pInputPtr, hsa_agent_info_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_agent_info_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_exception_policy_t_String(hsa_exception_policy_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_EXCEPTION_POLICY_BREAK);
            CASE(HSA_EXCEPTION_POLICY_DETECT);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_exception_policy_t_Ptr_String(const hsa_exception_policy_t* pInputPtr, hsa_exception_policy_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_exception_policy_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_cache_t_String(hsa_cache_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.handle);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_cache_t_Ptr_String(const hsa_cache_t* pInputPtr, hsa_cache_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_cache_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_cache_info_t_String(hsa_cache_info_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_CACHE_INFO_NAME_LENGTH);
            CASE(HSA_CACHE_INFO_NAME);
            CASE(HSA_CACHE_INFO_LEVEL);
            CASE(HSA_CACHE_INFO_SIZE);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_cache_info_t_Ptr_String(const hsa_cache_info_t* pInputPtr, hsa_cache_info_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_cache_info_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_signal_t_String(hsa_signal_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.handle);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_signal_t_Ptr_String(const hsa_signal_t* pInputPtr, hsa_signal_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_signal_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_signal_condition_t_String(hsa_signal_condition_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_SIGNAL_CONDITION_EQ);
            CASE(HSA_SIGNAL_CONDITION_NE);
            CASE(HSA_SIGNAL_CONDITION_LT);
            CASE(HSA_SIGNAL_CONDITION_GTE);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_signal_condition_t_Ptr_String(const hsa_signal_condition_t* pInputPtr, hsa_signal_condition_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_signal_condition_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_wait_state_t_String(hsa_wait_state_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_WAIT_STATE_BLOCKED);
            CASE(HSA_WAIT_STATE_ACTIVE);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_wait_state_t_Ptr_String(const hsa_wait_state_t* pInputPtr, hsa_wait_state_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_wait_state_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_signal_group_t_String(hsa_signal_group_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.handle);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_signal_group_t_Ptr_String(const hsa_signal_group_t* pInputPtr, hsa_signal_group_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_signal_group_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_region_t_String(hsa_region_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.handle);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_region_t_Ptr_String(const hsa_region_t* pInputPtr, hsa_region_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_region_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_queue_type_t_String(hsa_queue_type_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_QUEUE_TYPE_MULTI);
            CASE(HSA_QUEUE_TYPE_SINGLE);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_queue_type_t_Ptr_String(const hsa_queue_type_t* pInputPtr, hsa_queue_type_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_queue_type_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_queue_feature_t_String(hsa_queue_feature_t input)
{
    if (0 == input)
    {
        return "0";
    }

    std::ostringstream ss;
    unsigned int propVal = static_cast<unsigned int>(input);

    while (0 != propVal)
    {
        if (propVal & HSA_QUEUE_FEATURE_KERNEL_DISPATCH)
        {
            ss << "HSA_QUEUE_FEATURE_KERNEL_DISPATCH";
            propVal &= ~HSA_QUEUE_FEATURE_KERNEL_DISPATCH;
        }
        else if (propVal & HSA_QUEUE_FEATURE_AGENT_DISPATCH)
        {
            ss << "HSA_QUEUE_FEATURE_AGENT_DISPATCH";
            propVal &= ~HSA_QUEUE_FEATURE_AGENT_DISPATCH;
        }
        else
        {
            ss << StringUtils::ToString(propVal);
            propVal = 0;
        }

        if (propVal != 0)
        {
            ss << '|';
        }
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_queue_feature_t_Ptr_String(const hsa_queue_feature_t* pInputPtr, hsa_queue_feature_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_queue_feature_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_queue_t_String(hsa_queue_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.type) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.features) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.base_address) << s_pFieldSeparator;
    ss << HSATraceStringUtils::Get_hsa_signal_t_String(input.doorbell_signal) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.size) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.reserved1) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.id);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(const hsa_queue_t* pInputPtr, hsa_queue_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_queue_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_packet_type_t_String(hsa_packet_type_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_PACKET_TYPE_VENDOR_SPECIFIC);
            CASE(HSA_PACKET_TYPE_INVALID);
            CASE(HSA_PACKET_TYPE_KERNEL_DISPATCH);
            CASE(HSA_PACKET_TYPE_BARRIER_AND);
            CASE(HSA_PACKET_TYPE_AGENT_DISPATCH);
            CASE(HSA_PACKET_TYPE_BARRIER_OR);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_packet_type_t_Ptr_String(const hsa_packet_type_t* pInputPtr, hsa_packet_type_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_packet_type_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_fence_scope_t_String(hsa_fence_scope_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_FENCE_SCOPE_NONE);
            CASE(HSA_FENCE_SCOPE_AGENT);
            CASE(HSA_FENCE_SCOPE_SYSTEM);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_fence_scope_t_Ptr_String(const hsa_fence_scope_t* pInputPtr, hsa_fence_scope_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_fence_scope_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_packet_header_t_String(hsa_packet_header_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_PACKET_HEADER_TYPE);
            CASE(HSA_PACKET_HEADER_BARRIER);
            CASE(HSA_PACKET_HEADER_SCACQUIRE_FENCE_SCOPE);
            CASE(HSA_PACKET_HEADER_SCRELEASE_FENCE_SCOPE);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_packet_header_t_Ptr_String(const hsa_packet_header_t* pInputPtr, hsa_packet_header_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_packet_header_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_packet_header_width_t_String(hsa_packet_header_width_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_PACKET_HEADER_WIDTH_TYPE);
            CASE(HSA_PACKET_HEADER_WIDTH_BARRIER);
            CASE(HSA_PACKET_HEADER_WIDTH_SCACQUIRE_FENCE_SCOPE);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_packet_header_width_t_Ptr_String(const hsa_packet_header_width_t* pInputPtr, hsa_packet_header_width_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_packet_header_width_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_kernel_dispatch_packet_setup_t_String(hsa_kernel_dispatch_packet_setup_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_KERNEL_DISPATCH_PACKET_SETUP_DIMENSIONS);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_kernel_dispatch_packet_setup_t_Ptr_String(const hsa_kernel_dispatch_packet_setup_t* pInputPtr, hsa_kernel_dispatch_packet_setup_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_kernel_dispatch_packet_setup_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_kernel_dispatch_packet_setup_width_t_String(hsa_kernel_dispatch_packet_setup_width_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_KERNEL_DISPATCH_PACKET_SETUP_WIDTH_DIMENSIONS);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_kernel_dispatch_packet_setup_width_t_Ptr_String(const hsa_kernel_dispatch_packet_setup_width_t* pInputPtr, hsa_kernel_dispatch_packet_setup_width_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_kernel_dispatch_packet_setup_width_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_kernel_dispatch_packet_t_String(hsa_kernel_dispatch_packet_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.header) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.setup) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.workgroup_size_x) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.workgroup_size_y) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.workgroup_size_z) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.reserved0) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.grid_size_x) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.grid_size_y) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.grid_size_z) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.private_segment_size) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.group_segment_size) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.kernel_object) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.kernarg_address) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.reserved2) << s_pFieldSeparator;
    ss << HSATraceStringUtils::Get_hsa_signal_t_String(input.completion_signal);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_kernel_dispatch_packet_t_Ptr_String(const hsa_kernel_dispatch_packet_t* pInputPtr, hsa_kernel_dispatch_packet_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_kernel_dispatch_packet_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_agent_dispatch_packet_t_String(hsa_agent_dispatch_packet_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.header) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.type) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.reserved0) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.return_address) << s_pFieldSeparator;
    ss << HSATraceStringUtils::GetArrayString(input.arg, 4, StringUtils::ToString) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.reserved2) << s_pFieldSeparator;
    ss << HSATraceStringUtils::Get_hsa_signal_t_String(input.completion_signal);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_agent_dispatch_packet_t_Ptr_String(const hsa_agent_dispatch_packet_t* pInputPtr, hsa_agent_dispatch_packet_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_agent_dispatch_packet_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_barrier_and_packet_t_String(hsa_barrier_and_packet_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.header) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.reserved0) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.reserved1) << s_pFieldSeparator;
    ss << HSATraceStringUtils::GetArrayString(input.dep_signal, 5, HSATraceStringUtils::Get_hsa_signal_t_String) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.reserved2) << s_pFieldSeparator;
    ss << HSATraceStringUtils::Get_hsa_signal_t_String(input.completion_signal);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_barrier_and_packet_t_Ptr_String(const hsa_barrier_and_packet_t* pInputPtr, hsa_barrier_and_packet_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_barrier_and_packet_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_barrier_or_packet_t_String(hsa_barrier_or_packet_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.header) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.reserved0) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.reserved1) << s_pFieldSeparator;
    ss << HSATraceStringUtils::GetArrayString(input.dep_signal, 5, HSATraceStringUtils::Get_hsa_signal_t_String) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.reserved2) << s_pFieldSeparator;
    ss << HSATraceStringUtils::Get_hsa_signal_t_String(input.completion_signal);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_barrier_or_packet_t_Ptr_String(const hsa_barrier_or_packet_t* pInputPtr, hsa_barrier_or_packet_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_barrier_or_packet_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_region_segment_t_String(hsa_region_segment_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_REGION_SEGMENT_GLOBAL);
            CASE(HSA_REGION_SEGMENT_READONLY);
            CASE(HSA_REGION_SEGMENT_PRIVATE);
            CASE(HSA_REGION_SEGMENT_GROUP);
            CASE(HSA_REGION_SEGMENT_KERNARG);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_region_segment_t_Ptr_String(const hsa_region_segment_t* pInputPtr, hsa_region_segment_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_region_segment_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_region_global_flag_t_String(hsa_region_global_flag_t input)
{
    if (0 == input)
    {
        return "0";
    }

    std::ostringstream ss;
    unsigned int propVal = static_cast<unsigned int>(input);

    while (0 != propVal)
    {
        if (propVal & HSA_REGION_GLOBAL_FLAG_KERNARG)
        {
            ss << "HSA_REGION_GLOBAL_FLAG_KERNARG";
            propVal &= ~HSA_REGION_GLOBAL_FLAG_KERNARG;
        }
        else if (propVal & HSA_REGION_GLOBAL_FLAG_FINE_GRAINED)
        {
            ss << "HSA_REGION_GLOBAL_FLAG_FINE_GRAINED";
            propVal &= ~HSA_REGION_GLOBAL_FLAG_FINE_GRAINED;
        }
        else if (propVal & HSA_REGION_GLOBAL_FLAG_COARSE_GRAINED)
        {
            ss << "HSA_REGION_GLOBAL_FLAG_COARSE_GRAINED";
            propVal &= ~HSA_REGION_GLOBAL_FLAG_COARSE_GRAINED;
        }
        else
        {
            ss << StringUtils::ToString(propVal);
            propVal = 0;
        }

        if (propVal != 0)
        {
            ss << '|';
        }
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_region_global_flag_t_Ptr_String(const hsa_region_global_flag_t* pInputPtr, hsa_region_global_flag_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_region_global_flag_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_region_info_t_String(hsa_region_info_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_REGION_INFO_SEGMENT);
            CASE(HSA_REGION_INFO_GLOBAL_FLAGS);
            CASE(HSA_REGION_INFO_SIZE);
            CASE(HSA_REGION_INFO_ALLOC_MAX_SIZE);
            CASE(HSA_REGION_INFO_ALLOC_MAX_PRIVATE_WORKGROUP_SIZE);
            CASE(HSA_REGION_INFO_RUNTIME_ALLOC_ALLOWED);
            CASE(HSA_REGION_INFO_RUNTIME_ALLOC_GRANULE);
            CASE(HSA_REGION_INFO_RUNTIME_ALLOC_ALIGNMENT);

        default:
            ss << Get_hsa_amd_region_info_t_String(static_cast<hsa_amd_region_info_t>(input));
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_region_info_t_Ptr_String(const hsa_region_info_t* pInputPtr, hsa_region_info_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_region_info_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_isa_t_String(hsa_isa_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.handle);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_isa_t_Ptr_String(const hsa_isa_t* pInputPtr, hsa_isa_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_isa_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_isa_info_t_String(hsa_isa_info_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_ISA_INFO_NAME_LENGTH);
            CASE(HSA_ISA_INFO_NAME);
            CASE(HSA_ISA_INFO_CALL_CONVENTION_COUNT);
            CASE(HSA_ISA_INFO_CALL_CONVENTION_INFO_WAVEFRONT_SIZE);
            CASE(HSA_ISA_INFO_CALL_CONVENTION_INFO_WAVEFRONTS_PER_COMPUTE_UNIT);
            CASE(HSA_ISA_INFO_MACHINE_MODELS);
            CASE(HSA_ISA_INFO_PROFILES);
            CASE(HSA_ISA_INFO_DEFAULT_FLOAT_ROUNDING_MODES);
            CASE(HSA_ISA_INFO_BASE_PROFILE_DEFAULT_FLOAT_ROUNDING_MODES);
            CASE(HSA_ISA_INFO_FAST_F16_OPERATION);
            CASE(HSA_ISA_INFO_WORKGROUP_MAX_DIM);
            CASE(HSA_ISA_INFO_WORKGROUP_MAX_SIZE);
            CASE(HSA_ISA_INFO_GRID_MAX_DIM);
            CASE(HSA_ISA_INFO_GRID_MAX_SIZE);
            CASE(HSA_ISA_INFO_FBARRIER_MAX_SIZE);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_isa_info_t_Ptr_String(const hsa_isa_info_t* pInputPtr, hsa_isa_info_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_isa_info_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_fp_type_t_String(hsa_fp_type_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_FP_TYPE_16);
            CASE(HSA_FP_TYPE_32);
            CASE(HSA_FP_TYPE_64);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_fp_type_t_Ptr_String(const hsa_fp_type_t* pInputPtr, hsa_fp_type_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_fp_type_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_flush_mode_t_String(hsa_flush_mode_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_FLUSH_MODE_FTZ);
            CASE(HSA_FLUSH_MODE_NON_FTZ);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_flush_mode_t_Ptr_String(const hsa_flush_mode_t* pInputPtr, hsa_flush_mode_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_flush_mode_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_round_method_t_String(hsa_round_method_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_ROUND_METHOD_SINGLE);
            CASE(HSA_ROUND_METHOD_DOUBLE);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_round_method_t_Ptr_String(const hsa_round_method_t* pInputPtr, hsa_round_method_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_round_method_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_wavefront_t_String(hsa_wavefront_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.handle);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_wavefront_t_Ptr_String(const hsa_wavefront_t* pInputPtr, hsa_wavefront_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_wavefront_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_wavefront_info_t_String(hsa_wavefront_info_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_WAVEFRONT_INFO_SIZE);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_wavefront_info_t_Ptr_String(const hsa_wavefront_info_t* pInputPtr, hsa_wavefront_info_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_wavefront_info_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_code_object_reader_t_String(hsa_code_object_reader_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.handle);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_code_object_reader_t_Ptr_String(const hsa_code_object_reader_t* pInputPtr, hsa_code_object_reader_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_code_object_reader_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_executable_t_String(hsa_executable_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.handle);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_executable_t_Ptr_String(const hsa_executable_t* pInputPtr, hsa_executable_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_executable_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_executable_state_t_String(hsa_executable_state_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_EXECUTABLE_STATE_UNFROZEN);
            CASE(HSA_EXECUTABLE_STATE_FROZEN);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_executable_state_t_Ptr_String(const hsa_executable_state_t* pInputPtr, hsa_executable_state_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_executable_state_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_loaded_code_object_t_String(hsa_loaded_code_object_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.handle);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_loaded_code_object_t_Ptr_String(const hsa_loaded_code_object_t* pInputPtr, hsa_loaded_code_object_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_loaded_code_object_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_executable_info_t_String(hsa_executable_info_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_EXECUTABLE_INFO_PROFILE);
            CASE(HSA_EXECUTABLE_INFO_STATE);
            CASE(HSA_EXECUTABLE_INFO_DEFAULT_FLOAT_ROUNDING_MODE);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_executable_info_t_Ptr_String(const hsa_executable_info_t* pInputPtr, hsa_executable_info_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_executable_info_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_executable_symbol_t_String(hsa_executable_symbol_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.handle);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_executable_symbol_t_Ptr_String(const hsa_executable_symbol_t* pInputPtr, hsa_executable_symbol_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_executable_symbol_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_symbol_kind_t_String(hsa_symbol_kind_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_SYMBOL_KIND_VARIABLE);
            CASE(HSA_SYMBOL_KIND_KERNEL);
            CASE(HSA_SYMBOL_KIND_INDIRECT_FUNCTION);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_symbol_kind_t_Ptr_String(const hsa_symbol_kind_t* pInputPtr, hsa_symbol_kind_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_symbol_kind_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_symbol_linkage_t_String(hsa_symbol_linkage_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_SYMBOL_LINKAGE_MODULE);
            CASE(HSA_SYMBOL_LINKAGE_PROGRAM);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_symbol_linkage_t_Ptr_String(const hsa_symbol_linkage_t* pInputPtr, hsa_symbol_linkage_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_symbol_linkage_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_variable_allocation_t_String(hsa_variable_allocation_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_VARIABLE_ALLOCATION_AGENT);
            CASE(HSA_VARIABLE_ALLOCATION_PROGRAM);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_variable_allocation_t_Ptr_String(const hsa_variable_allocation_t* pInputPtr, hsa_variable_allocation_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_variable_allocation_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_variable_segment_t_String(hsa_variable_segment_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_VARIABLE_SEGMENT_GLOBAL);
            CASE(HSA_VARIABLE_SEGMENT_READONLY);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_variable_segment_t_Ptr_String(const hsa_variable_segment_t* pInputPtr, hsa_variable_segment_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_variable_segment_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_executable_symbol_info_t_String(hsa_executable_symbol_info_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_EXECUTABLE_SYMBOL_INFO_TYPE);
            CASE(HSA_EXECUTABLE_SYMBOL_INFO_NAME_LENGTH);
            CASE(HSA_EXECUTABLE_SYMBOL_INFO_NAME);
            CASE(HSA_EXECUTABLE_SYMBOL_INFO_MODULE_NAME_LENGTH);
            CASE(HSA_EXECUTABLE_SYMBOL_INFO_MODULE_NAME);
            CASE(HSA_EXECUTABLE_SYMBOL_INFO_AGENT);
            CASE(HSA_EXECUTABLE_SYMBOL_INFO_VARIABLE_ADDRESS);
            CASE(HSA_EXECUTABLE_SYMBOL_INFO_LINKAGE);
            CASE(HSA_EXECUTABLE_SYMBOL_INFO_IS_DEFINITION);
            CASE(HSA_EXECUTABLE_SYMBOL_INFO_VARIABLE_ALLOCATION);
            CASE(HSA_EXECUTABLE_SYMBOL_INFO_VARIABLE_SEGMENT);
            CASE(HSA_EXECUTABLE_SYMBOL_INFO_VARIABLE_ALIGNMENT);
            CASE(HSA_EXECUTABLE_SYMBOL_INFO_VARIABLE_SIZE);
            CASE(HSA_EXECUTABLE_SYMBOL_INFO_VARIABLE_IS_CONST);
            CASE(HSA_EXECUTABLE_SYMBOL_INFO_KERNEL_OBJECT);
            CASE(HSA_EXECUTABLE_SYMBOL_INFO_KERNEL_KERNARG_SEGMENT_SIZE);
            CASE(HSA_EXECUTABLE_SYMBOL_INFO_KERNEL_KERNARG_SEGMENT_ALIGNMENT);
            CASE(HSA_EXECUTABLE_SYMBOL_INFO_KERNEL_GROUP_SEGMENT_SIZE);
            CASE(HSA_EXECUTABLE_SYMBOL_INFO_KERNEL_PRIVATE_SEGMENT_SIZE);
            CASE(HSA_EXECUTABLE_SYMBOL_INFO_KERNEL_DYNAMIC_CALLSTACK);
            CASE(HSA_EXECUTABLE_SYMBOL_INFO_KERNEL_CALL_CONVENTION);
            CASE(HSA_EXECUTABLE_SYMBOL_INFO_INDIRECT_FUNCTION_OBJECT);
            CASE(HSA_EXECUTABLE_SYMBOL_INFO_INDIRECT_FUNCTION_CALL_CONVENTION);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_executable_symbol_info_t_Ptr_String(const hsa_executable_symbol_info_t* pInputPtr, hsa_executable_symbol_info_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_executable_symbol_info_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_code_object_t_String(hsa_code_object_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.handle);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_code_object_t_Ptr_String(const hsa_code_object_t* pInputPtr, hsa_code_object_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_code_object_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_callback_data_t_String(hsa_callback_data_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.handle);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_callback_data_t_Ptr_String(const hsa_callback_data_t* pInputPtr, hsa_callback_data_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_callback_data_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_code_object_type_t_String(hsa_code_object_type_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_CODE_OBJECT_TYPE_PROGRAM);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_code_object_type_t_Ptr_String(const hsa_code_object_type_t* pInputPtr, hsa_code_object_type_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_code_object_type_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_code_object_info_t_String(hsa_code_object_info_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_CODE_OBJECT_INFO_VERSION);
            CASE(HSA_CODE_OBJECT_INFO_TYPE);
            CASE(HSA_CODE_OBJECT_INFO_ISA);
            CASE(HSA_CODE_OBJECT_INFO_MACHINE_MODEL);
            CASE(HSA_CODE_OBJECT_INFO_PROFILE);
            CASE(HSA_CODE_OBJECT_INFO_DEFAULT_FLOAT_ROUNDING_MODE);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_code_object_info_t_Ptr_String(const hsa_code_object_info_t* pInputPtr, hsa_code_object_info_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_code_object_info_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_code_symbol_t_String(hsa_code_symbol_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.handle);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_code_symbol_t_Ptr_String(const hsa_code_symbol_t* pInputPtr, hsa_code_symbol_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_code_symbol_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_code_symbol_info_t_String(hsa_code_symbol_info_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_CODE_SYMBOL_INFO_TYPE);
            CASE(HSA_CODE_SYMBOL_INFO_NAME_LENGTH);
            CASE(HSA_CODE_SYMBOL_INFO_NAME);
            CASE(HSA_CODE_SYMBOL_INFO_MODULE_NAME_LENGTH);
            CASE(HSA_CODE_SYMBOL_INFO_MODULE_NAME);
            CASE(HSA_CODE_SYMBOL_INFO_LINKAGE);
            CASE(HSA_CODE_SYMBOL_INFO_IS_DEFINITION);
            CASE(HSA_CODE_SYMBOL_INFO_VARIABLE_ALLOCATION);
            CASE(HSA_CODE_SYMBOL_INFO_VARIABLE_SEGMENT);
            CASE(HSA_CODE_SYMBOL_INFO_VARIABLE_ALIGNMENT);
            CASE(HSA_CODE_SYMBOL_INFO_VARIABLE_SIZE);
            CASE(HSA_CODE_SYMBOL_INFO_VARIABLE_IS_CONST);
            CASE(HSA_CODE_SYMBOL_INFO_KERNEL_KERNARG_SEGMENT_SIZE);
            CASE(HSA_CODE_SYMBOL_INFO_KERNEL_KERNARG_SEGMENT_ALIGNMENT);
            CASE(HSA_CODE_SYMBOL_INFO_KERNEL_GROUP_SEGMENT_SIZE);
            CASE(HSA_CODE_SYMBOL_INFO_KERNEL_PRIVATE_SEGMENT_SIZE);
            CASE(HSA_CODE_SYMBOL_INFO_KERNEL_DYNAMIC_CALLSTACK);
            CASE(HSA_CODE_SYMBOL_INFO_KERNEL_CALL_CONVENTION);
            CASE(HSA_CODE_SYMBOL_INFO_INDIRECT_FUNCTION_CALL_CONVENTION);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_code_symbol_info_t_Ptr_String(const hsa_code_symbol_info_t* pInputPtr, hsa_code_symbol_info_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_code_symbol_info_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_BrigModule_t_String(BrigModule_t input)
{
    return StringUtils::ToHexString(input);
}

std::string HSATraceStringUtils::Get_BrigModule_t_Ptr_String(const BrigModule_t* pInputPtr, BrigModule_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_BrigModule_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ext_program_t_String(hsa_ext_program_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.handle);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_ext_program_t_Ptr_String(const hsa_ext_program_t* pInputPtr, hsa_ext_program_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ext_program_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ext_program_info_t_String(hsa_ext_program_info_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_EXT_PROGRAM_INFO_MACHINE_MODEL);
            CASE(HSA_EXT_PROGRAM_INFO_PROFILE);
            CASE(HSA_EXT_PROGRAM_INFO_DEFAULT_FLOAT_ROUNDING_MODE);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_ext_program_info_t_Ptr_String(const hsa_ext_program_info_t* pInputPtr, hsa_ext_program_info_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ext_program_info_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ext_finalizer_call_convention_t_String(hsa_ext_finalizer_call_convention_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_EXT_FINALIZER_CALL_CONVENTION_AUTO);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_ext_finalizer_call_convention_t_Ptr_String(const hsa_ext_finalizer_call_convention_t* pInputPtr, hsa_ext_finalizer_call_convention_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ext_finalizer_call_convention_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ext_control_directives_t_String(hsa_ext_control_directives_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.control_directives_mask) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.break_exceptions_mask) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.detect_exceptions_mask) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.max_dynamic_group_size) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.max_flat_grid_size) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.max_flat_workgroup_size) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.reserved1) << s_pFieldSeparator;
    ss << HSATraceStringUtils::GetArrayString(input.required_grid_size, 3, StringUtils::ToString) << s_pFieldSeparator;
    ss << HSATraceStringUtils::Get_hsa_dim3_t_String(input.required_workgroup_size) << s_pFieldSeparator;
    ss << HSATraceStringUtils::Get_uint8_t_String(input.required_dim) << s_pFieldSeparator;
    ss << HSATraceStringUtils::GetArrayString(input.reserved2, 75, HSATraceStringUtils::Get_uint8_t_String);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_ext_control_directives_t_Ptr_String(const hsa_ext_control_directives_t* pInputPtr, hsa_ext_control_directives_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ext_control_directives_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ext_image_t_String(hsa_ext_image_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.handle);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_ext_image_t_Ptr_String(const hsa_ext_image_t* pInputPtr, hsa_ext_image_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ext_image_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ext_image_geometry_t_String(hsa_ext_image_geometry_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_EXT_IMAGE_GEOMETRY_1D);
            CASE(HSA_EXT_IMAGE_GEOMETRY_2D);
            CASE(HSA_EXT_IMAGE_GEOMETRY_3D);
            CASE(HSA_EXT_IMAGE_GEOMETRY_1DA);
            CASE(HSA_EXT_IMAGE_GEOMETRY_2DA);
            CASE(HSA_EXT_IMAGE_GEOMETRY_1DB);
            CASE(HSA_EXT_IMAGE_GEOMETRY_2DDEPTH);
            CASE(HSA_EXT_IMAGE_GEOMETRY_2DADEPTH);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_ext_image_geometry_t_Ptr_String(const hsa_ext_image_geometry_t* pInputPtr, hsa_ext_image_geometry_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ext_image_geometry_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ext_image_channel_type_t_String(hsa_ext_image_channel_type_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_EXT_IMAGE_CHANNEL_TYPE_SNORM_INT8);
            CASE(HSA_EXT_IMAGE_CHANNEL_TYPE_SNORM_INT16);
            CASE(HSA_EXT_IMAGE_CHANNEL_TYPE_UNORM_INT8);
            CASE(HSA_EXT_IMAGE_CHANNEL_TYPE_UNORM_INT16);
            CASE(HSA_EXT_IMAGE_CHANNEL_TYPE_UNORM_INT24);
            CASE(HSA_EXT_IMAGE_CHANNEL_TYPE_UNORM_SHORT_555);
            CASE(HSA_EXT_IMAGE_CHANNEL_TYPE_UNORM_SHORT_565);
            CASE(HSA_EXT_IMAGE_CHANNEL_TYPE_UNORM_SHORT_101010);
            CASE(HSA_EXT_IMAGE_CHANNEL_TYPE_SIGNED_INT8);
            CASE(HSA_EXT_IMAGE_CHANNEL_TYPE_SIGNED_INT16);
            CASE(HSA_EXT_IMAGE_CHANNEL_TYPE_SIGNED_INT32);
            CASE(HSA_EXT_IMAGE_CHANNEL_TYPE_UNSIGNED_INT8);
            CASE(HSA_EXT_IMAGE_CHANNEL_TYPE_UNSIGNED_INT16);
            CASE(HSA_EXT_IMAGE_CHANNEL_TYPE_UNSIGNED_INT32);
            CASE(HSA_EXT_IMAGE_CHANNEL_TYPE_HALF_FLOAT);
            CASE(HSA_EXT_IMAGE_CHANNEL_TYPE_FLOAT);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_ext_image_channel_type_t_Ptr_String(const hsa_ext_image_channel_type_t* pInputPtr, hsa_ext_image_channel_type_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ext_image_channel_type_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ext_image_channel_order_t_String(hsa_ext_image_channel_order_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_EXT_IMAGE_CHANNEL_ORDER_A);
            CASE(HSA_EXT_IMAGE_CHANNEL_ORDER_R);
            CASE(HSA_EXT_IMAGE_CHANNEL_ORDER_RX);
            CASE(HSA_EXT_IMAGE_CHANNEL_ORDER_RG);
            CASE(HSA_EXT_IMAGE_CHANNEL_ORDER_RGX);
            CASE(HSA_EXT_IMAGE_CHANNEL_ORDER_RA);
            CASE(HSA_EXT_IMAGE_CHANNEL_ORDER_RGB);
            CASE(HSA_EXT_IMAGE_CHANNEL_ORDER_RGBX);
            CASE(HSA_EXT_IMAGE_CHANNEL_ORDER_RGBA);
            CASE(HSA_EXT_IMAGE_CHANNEL_ORDER_BGRA);
            CASE(HSA_EXT_IMAGE_CHANNEL_ORDER_ARGB);
            CASE(HSA_EXT_IMAGE_CHANNEL_ORDER_ABGR);
            CASE(HSA_EXT_IMAGE_CHANNEL_ORDER_SRGB);
            CASE(HSA_EXT_IMAGE_CHANNEL_ORDER_SRGBX);
            CASE(HSA_EXT_IMAGE_CHANNEL_ORDER_SRGBA);
            CASE(HSA_EXT_IMAGE_CHANNEL_ORDER_SBGRA);
            CASE(HSA_EXT_IMAGE_CHANNEL_ORDER_INTENSITY);
            CASE(HSA_EXT_IMAGE_CHANNEL_ORDER_LUMINANCE);
            CASE(HSA_EXT_IMAGE_CHANNEL_ORDER_DEPTH);
            CASE(HSA_EXT_IMAGE_CHANNEL_ORDER_DEPTH_STENCIL);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_ext_image_channel_order_t_Ptr_String(const hsa_ext_image_channel_order_t* pInputPtr, hsa_ext_image_channel_order_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ext_image_channel_order_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ext_image_format_t_String(hsa_ext_image_format_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.channel_type) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.channel_order);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_ext_image_format_t_Ptr_String(const hsa_ext_image_format_t* pInputPtr, hsa_ext_image_format_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ext_image_format_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ext_image_descriptor_t_String(hsa_ext_image_descriptor_t input)
{
    std::ostringstream ss;

    ss << HSATraceStringUtils::Get_hsa_ext_image_geometry_t_String(input.geometry) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.width) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.height) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.depth) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.array_size) << s_pFieldSeparator;
    ss << HSATraceStringUtils::Get_hsa_ext_image_format_t_String(input.format);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_ext_image_descriptor_t_Ptr_String(const hsa_ext_image_descriptor_t* pInputPtr, hsa_ext_image_descriptor_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ext_image_descriptor_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ext_image_capability_t_String(hsa_ext_image_capability_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_EXT_IMAGE_CAPABILITY_NOT_SUPPORTED);
            CASE(HSA_EXT_IMAGE_CAPABILITY_READ_ONLY);
            CASE(HSA_EXT_IMAGE_CAPABILITY_WRITE_ONLY);
            CASE(HSA_EXT_IMAGE_CAPABILITY_READ_WRITE);
            CASE(HSA_EXT_IMAGE_CAPABILITY_READ_MODIFY_WRITE);
            CASE(HSA_EXT_IMAGE_CAPABILITY_ACCESS_INVARIANT_DATA_LAYOUT);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_ext_image_capability_t_Ptr_String(const hsa_ext_image_capability_t* pInputPtr, hsa_ext_image_capability_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ext_image_capability_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ext_image_data_layout_t_String(hsa_ext_image_data_layout_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_EXT_IMAGE_DATA_LAYOUT_OPAQUE);
            CASE(HSA_EXT_IMAGE_DATA_LAYOUT_LINEAR);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_ext_image_data_layout_t_Ptr_String(const hsa_ext_image_data_layout_t* pInputPtr, hsa_ext_image_data_layout_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ext_image_data_layout_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ext_image_data_info_t_String(hsa_ext_image_data_info_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.size) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.alignment);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_ext_image_data_info_t_Ptr_String(const hsa_ext_image_data_info_t* pInputPtr, hsa_ext_image_data_info_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ext_image_data_info_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ext_image_region_t_String(hsa_ext_image_region_t input)
{
    std::ostringstream ss;

    ss << HSATraceStringUtils::Get_hsa_dim3_t_String(input.offset) << s_pFieldSeparator;
    ss << HSATraceStringUtils::Get_hsa_dim3_t_String(input.range);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_ext_image_region_t_Ptr_String(const hsa_ext_image_region_t* pInputPtr, hsa_ext_image_region_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ext_image_region_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ext_sampler_t_String(hsa_ext_sampler_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.handle);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_ext_sampler_t_Ptr_String(const hsa_ext_sampler_t* pInputPtr, hsa_ext_sampler_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ext_sampler_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ext_sampler_addressing_mode_t_String(hsa_ext_sampler_addressing_mode_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_EXT_SAMPLER_ADDRESSING_MODE_UNDEFINED);
            CASE(HSA_EXT_SAMPLER_ADDRESSING_MODE_CLAMP_TO_EDGE);
            CASE(HSA_EXT_SAMPLER_ADDRESSING_MODE_CLAMP_TO_BORDER);
            CASE(HSA_EXT_SAMPLER_ADDRESSING_MODE_REPEAT);
            CASE(HSA_EXT_SAMPLER_ADDRESSING_MODE_MIRRORED_REPEAT);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_ext_sampler_addressing_mode_t_Ptr_String(const hsa_ext_sampler_addressing_mode_t* pInputPtr, hsa_ext_sampler_addressing_mode_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ext_sampler_addressing_mode_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ext_sampler_coordinate_mode_t_String(hsa_ext_sampler_coordinate_mode_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_EXT_SAMPLER_COORDINATE_MODE_UNNORMALIZED);
            CASE(HSA_EXT_SAMPLER_COORDINATE_MODE_NORMALIZED);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_ext_sampler_coordinate_mode_t_Ptr_String(const hsa_ext_sampler_coordinate_mode_t* pInputPtr, hsa_ext_sampler_coordinate_mode_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ext_sampler_coordinate_mode_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ext_sampler_filter_mode_t_String(hsa_ext_sampler_filter_mode_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_EXT_SAMPLER_FILTER_MODE_NEAREST);
            CASE(HSA_EXT_SAMPLER_FILTER_MODE_LINEAR);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_ext_sampler_filter_mode_t_Ptr_String(const hsa_ext_sampler_filter_mode_t* pInputPtr, hsa_ext_sampler_filter_mode_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ext_sampler_filter_mode_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ext_sampler_descriptor_t_String(hsa_ext_sampler_descriptor_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.coordinate_mode) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.filter_mode) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.address_mode);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_ext_sampler_descriptor_t_Ptr_String(const hsa_ext_sampler_descriptor_t* pInputPtr, hsa_ext_sampler_descriptor_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ext_sampler_descriptor_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_amd_agent_info_t_String(hsa_amd_agent_info_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_AMD_AGENT_INFO_CHIP_ID);
            CASE(HSA_AMD_AGENT_INFO_CACHELINE_SIZE);
            CASE(HSA_AMD_AGENT_INFO_COMPUTE_UNIT_COUNT);
            CASE(HSA_AMD_AGENT_INFO_MAX_CLOCK_FREQUENCY);
            CASE(HSA_AMD_AGENT_INFO_DRIVER_NODE_ID);
            CASE(HSA_AMD_AGENT_INFO_MAX_ADDRESS_WATCH_POINTS);
            CASE(HSA_AMD_AGENT_INFO_BDFID);
            CASE(HSA_AMD_AGENT_INFO_MEMORY_WIDTH);
            CASE(HSA_AMD_AGENT_INFO_MEMORY_MAX_FREQUENCY);
            CASE(HSA_AMD_AGENT_INFO_PRODUCT_NAME);
            CASE(HSA_AMD_AGENT_INFO_MAX_WAVES_PER_CU);
            CASE(HSA_AMD_AGENT_INFO_NUM_SIMDS_PER_CU);
            CASE(HSA_AMD_AGENT_INFO_NUM_SHADER_ENGINES);
            CASE(HSA_AMD_AGENT_INFO_NUM_SHADER_ARRAYS_PER_SE);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_amd_agent_info_t_Ptr_String(const hsa_amd_agent_info_t* pInputPtr, hsa_amd_agent_info_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_amd_agent_info_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_amd_region_info_t_String(hsa_amd_region_info_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_AMD_REGION_INFO_HOST_ACCESSIBLE);
            CASE(HSA_AMD_REGION_INFO_BASE);
            CASE(HSA_AMD_REGION_INFO_BUS_WIDTH);
            CASE(HSA_AMD_REGION_INFO_MAX_CLOCK_FREQUENCY);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_amd_region_info_t_Ptr_String(const hsa_amd_region_info_t* pInputPtr, hsa_amd_region_info_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_amd_region_info_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_amd_coherency_type_t_String(hsa_amd_coherency_type_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_AMD_COHERENCY_TYPE_COHERENT);
            CASE(HSA_AMD_COHERENCY_TYPE_NONCOHERENT);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_amd_coherency_type_t_Ptr_String(const hsa_amd_coherency_type_t* pInputPtr, hsa_amd_coherency_type_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_amd_coherency_type_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_amd_profiling_dispatch_time_t_String(hsa_amd_profiling_dispatch_time_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.start) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.end);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_amd_profiling_dispatch_time_t_Ptr_String(const hsa_amd_profiling_dispatch_time_t* pInputPtr, hsa_amd_profiling_dispatch_time_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_amd_profiling_dispatch_time_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_amd_profiling_async_copy_time_t_String(hsa_amd_profiling_async_copy_time_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.start) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.end);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_amd_profiling_async_copy_time_t_Ptr_String(const hsa_amd_profiling_async_copy_time_t* pInputPtr, hsa_amd_profiling_async_copy_time_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_amd_profiling_async_copy_time_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_amd_signal_attribute_t_String(hsa_amd_signal_attribute_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_AMD_SIGNAL_AMD_GPU_ONLY);
            CASE(HSA_AMD_SIGNAL_IPC);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_amd_signal_attribute_t_Ptr_String(const hsa_amd_signal_attribute_t* pInputPtr, hsa_amd_signal_attribute_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_amd_signal_attribute_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_amd_segment_t_String(hsa_amd_segment_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_AMD_SEGMENT_GLOBAL);
            CASE(HSA_AMD_SEGMENT_READONLY);
            CASE(HSA_AMD_SEGMENT_PRIVATE);
            CASE(HSA_AMD_SEGMENT_GROUP);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_amd_segment_t_Ptr_String(const hsa_amd_segment_t* pInputPtr, hsa_amd_segment_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_amd_segment_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_amd_memory_pool_t_String(hsa_amd_memory_pool_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.handle);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_amd_memory_pool_t_Ptr_String(const hsa_amd_memory_pool_t* pInputPtr, hsa_amd_memory_pool_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_amd_memory_pool_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_amd_memory_pool_global_flag_t_String(hsa_amd_memory_pool_global_flag_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_AMD_MEMORY_POOL_GLOBAL_FLAG_KERNARG_INIT);
            CASE(HSA_AMD_MEMORY_POOL_GLOBAL_FLAG_FINE_GRAINED);
            CASE(HSA_AMD_MEMORY_POOL_GLOBAL_FLAG_COARSE_GRAINED);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_amd_memory_pool_global_flag_t_Ptr_String(const hsa_amd_memory_pool_global_flag_t* pInputPtr, hsa_amd_memory_pool_global_flag_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_amd_memory_pool_global_flag_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_amd_memory_pool_info_t_String(hsa_amd_memory_pool_info_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_AMD_MEMORY_POOL_INFO_SEGMENT);
            CASE(HSA_AMD_MEMORY_POOL_INFO_GLOBAL_FLAGS);
            CASE(HSA_AMD_MEMORY_POOL_INFO_SIZE);
            CASE(HSA_AMD_MEMORY_POOL_INFO_RUNTIME_ALLOC_ALLOWED);
            CASE(HSA_AMD_MEMORY_POOL_INFO_RUNTIME_ALLOC_GRANULE);
            CASE(HSA_AMD_MEMORY_POOL_INFO_RUNTIME_ALLOC_ALIGNMENT);
            CASE(HSA_AMD_MEMORY_POOL_INFO_ACCESSIBLE_BY_ALL);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_amd_memory_pool_info_t_Ptr_String(const hsa_amd_memory_pool_info_t* pInputPtr, hsa_amd_memory_pool_info_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_amd_memory_pool_info_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_pitched_ptr_t_String(hsa_pitched_ptr_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.base) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.pitch) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.slice);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_pitched_ptr_t_Ptr_String(const hsa_pitched_ptr_t* pInputPtr, hsa_pitched_ptr_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_pitched_ptr_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_amd_copy_direction_t_String(hsa_amd_copy_direction_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(hsaHostToHost);
            CASE(hsaHostToDevice);
            CASE(hsaDeviceToHost);
            CASE(hsaDeviceToDevice);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_amd_copy_direction_t_Ptr_String(const hsa_amd_copy_direction_t* pInputPtr, hsa_amd_copy_direction_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_amd_copy_direction_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_amd_memory_pool_access_t_String(hsa_amd_memory_pool_access_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_AMD_MEMORY_POOL_ACCESS_NEVER_ALLOWED);
            CASE(HSA_AMD_MEMORY_POOL_ACCESS_ALLOWED_BY_DEFAULT);
            CASE(HSA_AMD_MEMORY_POOL_ACCESS_DISALLOWED_BY_DEFAULT);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_amd_memory_pool_access_t_Ptr_String(const hsa_amd_memory_pool_access_t* pInputPtr, hsa_amd_memory_pool_access_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_amd_memory_pool_access_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_amd_link_info_type_t_String(hsa_amd_link_info_type_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_AMD_LINK_INFO_TYPE_HYPERTRANSPORT);
            CASE(HSA_AMD_LINK_INFO_TYPE_QPI);
            CASE(HSA_AMD_LINK_INFO_TYPE_PCIE);
            CASE(HSA_AMD_LINK_INFO_TYPE_INFINBAND);
            CASE(HSA_AMD_LINK_INFO_TYPE_XGMI);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_amd_link_info_type_t_Ptr_String(const hsa_amd_link_info_type_t* pInputPtr, hsa_amd_link_info_type_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_amd_link_info_type_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_amd_memory_pool_link_info_t_String(hsa_amd_memory_pool_link_info_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.min_latency) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.max_latency) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.min_bandwidth) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.max_bandwidth) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.atomic_support_32bit) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.atomic_support_64bit) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.coherent_support) << s_pFieldSeparator;
    ss << HSATraceStringUtils::Get_hsa_amd_link_info_type_t_String(input.link_type) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.numa_distance);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_amd_memory_pool_link_info_t_Ptr_String(const hsa_amd_memory_pool_link_info_t* pInputPtr, hsa_amd_memory_pool_link_info_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_amd_memory_pool_link_info_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_amd_agent_memory_pool_info_t_String(hsa_amd_agent_memory_pool_info_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_AMD_AGENT_MEMORY_POOL_INFO_ACCESS);
            CASE(HSA_AMD_AGENT_MEMORY_POOL_INFO_NUM_LINK_HOPS);
            CASE(HSA_AMD_AGENT_MEMORY_POOL_INFO_LINK_INFO);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_amd_agent_memory_pool_info_t_Ptr_String(const hsa_amd_agent_memory_pool_info_t* pInputPtr, hsa_amd_agent_memory_pool_info_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_amd_agent_memory_pool_info_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_amd_image_descriptor_t_String(hsa_amd_image_descriptor_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.version) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.deviceID) << s_pFieldSeparator;
    ss << HSATraceStringUtils::GetArrayString(input.data, 1, StringUtils::ToString);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_amd_image_descriptor_t_Ptr_String(const hsa_amd_image_descriptor_t* pInputPtr, hsa_amd_image_descriptor_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_amd_image_descriptor_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_amd_pointer_type_t_String(hsa_amd_pointer_type_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_EXT_POINTER_TYPE_UNKNOWN);
            CASE(HSA_EXT_POINTER_TYPE_HSA);
            CASE(HSA_EXT_POINTER_TYPE_LOCKED);
            CASE(HSA_EXT_POINTER_TYPE_GRAPHICS);
            CASE(HSA_EXT_POINTER_TYPE_IPC);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_amd_pointer_type_t_Ptr_String(const hsa_amd_pointer_type_t* pInputPtr, hsa_amd_pointer_type_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_amd_pointer_type_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_amd_pointer_info_t_String(hsa_amd_pointer_info_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.size) << s_pFieldSeparator;
    ss << HSATraceStringUtils::Get_hsa_amd_pointer_type_t_String(input.type) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.agentBaseAddress) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.hostBaseAddress) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.sizeInBytes) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.userData) << s_pFieldSeparator;
    ss << HSATraceStringUtils::Get_hsa_agent_t_String(input.agentOwner);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_amd_pointer_info_t_Ptr_String(const hsa_amd_pointer_info_t* pInputPtr, hsa_amd_pointer_info_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_amd_pointer_info_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_amd_ipc_memory_t_String(hsa_amd_ipc_memory_t input)
{
    std::ostringstream ss;

    ss << HSATraceStringUtils::GetArrayString(input.handle, 8, StringUtils::ToString);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_amd_ipc_memory_t_Ptr_String(const hsa_amd_ipc_memory_t* pInputPtr, hsa_amd_ipc_memory_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_amd_ipc_memory_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_amd_event_type_t_String(hsa_amd_event_type_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(GPU_MEMORY_FAULT_EVENT);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_amd_event_type_t_Ptr_String(const hsa_amd_event_type_t* pInputPtr, hsa_amd_event_type_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_amd_event_type_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_amd_gpu_memory_fault_info_t_String(hsa_amd_gpu_memory_fault_info_t input)
{
    std::ostringstream ss;

    ss << HSATraceStringUtils::Get_hsa_agent_t_String(input.agent) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.virtual_address) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.fault_reason_mask);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_amd_gpu_memory_fault_info_t_Ptr_String(const hsa_amd_gpu_memory_fault_info_t* pInputPtr, hsa_amd_gpu_memory_fault_info_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_amd_gpu_memory_fault_info_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_amd_event_t_String(hsa_amd_event_t input)
{
    std::ostringstream ss;

    ss << HSATraceStringUtils::Get_hsa_amd_event_type_t_String(input.event_type) << s_pFieldSeparator;
    ss << "{ " ;
    ss << HSATraceStringUtils::Get_hsa_amd_gpu_memory_fault_info_t_String(input.memory_fault);
    ss << " }";

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_amd_event_t_Ptr_String(const hsa_amd_event_t* pInputPtr, hsa_amd_event_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_amd_event_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_amd_queue_priority_t_String(hsa_amd_queue_priority_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_AMD_QUEUE_PRIORITY_LOW);
            CASE(HSA_AMD_QUEUE_PRIORITY_NORMAL);
            CASE(HSA_AMD_QUEUE_PRIORITY_HIGH);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_amd_queue_priority_t_Ptr_String(const hsa_amd_queue_priority_t* pInputPtr, hsa_amd_queue_priority_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_amd_queue_priority_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_loader_code_object_storage_type_t_String(hsa_ven_amd_loader_code_object_storage_type_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_VEN_AMD_LOADER_CODE_OBJECT_STORAGE_TYPE_NONE);
            CASE(HSA_VEN_AMD_LOADER_CODE_OBJECT_STORAGE_TYPE_FILE);
            CASE(HSA_VEN_AMD_LOADER_CODE_OBJECT_STORAGE_TYPE_MEMORY);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_loader_code_object_storage_type_t_Ptr_String(const hsa_ven_amd_loader_code_object_storage_type_t* pInputPtr, hsa_ven_amd_loader_code_object_storage_type_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ven_amd_loader_code_object_storage_type_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_loader_segment_descriptor_t_String(hsa_ven_amd_loader_segment_descriptor_t input)
{
    std::ostringstream ss;

    ss << HSATraceStringUtils::Get_hsa_agent_t_String(input.agent) << s_pFieldSeparator;
    ss << HSATraceStringUtils::Get_hsa_executable_t_String(input.executable) << s_pFieldSeparator;
    ss << HSATraceStringUtils::Get_hsa_ven_amd_loader_code_object_storage_type_t_String(input.code_object_storage_type) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.code_object_storage_base) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.code_object_storage_size) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.code_object_storage_offset) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.segment_base) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.segment_size);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_loader_segment_descriptor_t_Ptr_String(const hsa_ven_amd_loader_segment_descriptor_t* pInputPtr, hsa_ven_amd_loader_segment_descriptor_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ven_amd_loader_segment_descriptor_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_loader_loaded_code_object_kind_t_String(hsa_ven_amd_loader_loaded_code_object_kind_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_VEN_AMD_LOADER_LOADED_CODE_OBJECT_KIND_PROGRAM);
            CASE(HSA_VEN_AMD_LOADER_LOADED_CODE_OBJECT_KIND_AGENT);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_loader_loaded_code_object_kind_t_Ptr_String(const hsa_ven_amd_loader_loaded_code_object_kind_t* pInputPtr, hsa_ven_amd_loader_loaded_code_object_kind_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ven_amd_loader_loaded_code_object_kind_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_loader_loaded_code_object_info_t_String(hsa_ven_amd_loader_loaded_code_object_info_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_VEN_AMD_LOADER_LOADED_CODE_OBJECT_INFO_EXECUTABLE);
            CASE(HSA_VEN_AMD_LOADER_LOADED_CODE_OBJECT_INFO_KIND);
            CASE(HSA_VEN_AMD_LOADER_LOADED_CODE_OBJECT_INFO_AGENT);
            CASE(HSA_VEN_AMD_LOADER_LOADED_CODE_OBJECT_INFO_CODE_OBJECT_STORAGE_TYPE);
            CASE(HSA_VEN_AMD_LOADER_LOADED_CODE_OBJECT_INFO_CODE_OBJECT_STORAGE_MEMORY_BASE);
            CASE(HSA_VEN_AMD_LOADER_LOADED_CODE_OBJECT_INFO_CODE_OBJECT_STORAGE_MEMORY_SIZE);
            CASE(HSA_VEN_AMD_LOADER_LOADED_CODE_OBJECT_INFO_CODE_OBJECT_STORAGE_FILE);
            CASE(HSA_VEN_AMD_LOADER_LOADED_CODE_OBJECT_INFO_LOAD_DELTA);
            CASE(HSA_VEN_AMD_LOADER_LOADED_CODE_OBJECT_INFO_LOAD_BASE);
            CASE(HSA_VEN_AMD_LOADER_LOADED_CODE_OBJECT_INFO_LOAD_SIZE);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_loader_loaded_code_object_info_t_Ptr_String(const hsa_ven_amd_loader_loaded_code_object_info_t* pInputPtr, hsa_ven_amd_loader_loaded_code_object_info_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ven_amd_loader_loaded_code_object_info_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_event_type_t_String(hsa_ven_amd_aqlprofile_event_type_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_VEN_AMD_AQLPROFILE_EVENT_TYPE_PMC);
            CASE(HSA_VEN_AMD_AQLPROFILE_EVENT_TYPE_SQTT);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_event_type_t_Ptr_String(const hsa_ven_amd_aqlprofile_event_type_t* pInputPtr, hsa_ven_amd_aqlprofile_event_type_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ven_amd_aqlprofile_event_type_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_block_name_t_String(hsa_ven_amd_aqlprofile_block_name_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_CPC);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_CPF);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_GDS);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_GRBM);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_GRBMSE);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_SPI);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_SQ);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_SQCS);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_SRBM);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_SX);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_TA);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_TCA);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_TCC);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_TCP);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_TD);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_MCARB);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_MCHUB);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_MCMCBVM);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_MCSEQ);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_MCVML2);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_MCXBAR);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_ATC);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_ATCL2);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_GCEA);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCK_NAME_RPB);
            CASE(HSA_VEN_AMD_AQLPROFILE_BLOCKS_NUMBER);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_block_name_t_Ptr_String(const hsa_ven_amd_aqlprofile_block_name_t* pInputPtr, hsa_ven_amd_aqlprofile_block_name_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ven_amd_aqlprofile_block_name_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_event_t_String(hsa_ven_amd_aqlprofile_event_t input)
{
    std::ostringstream ss;

    ss << HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_block_name_t_String(input.block_name) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.block_index) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.counter_id);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_event_t_Ptr_String(const hsa_ven_amd_aqlprofile_event_t* pInputPtr, hsa_ven_amd_aqlprofile_event_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ven_amd_aqlprofile_event_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_parameter_name_t_String(hsa_ven_amd_aqlprofile_parameter_name_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_VEN_AMD_AQLPROFILE_PARAMETER_NAME_COMPUTE_UNIT_TARGET);
            CASE(HSA_VEN_AMD_AQLPROFILE_PARAMETER_NAME_VM_ID_MASK);
            CASE(HSA_VEN_AMD_AQLPROFILE_PARAMETER_NAME_MASK);
            CASE(HSA_VEN_AMD_AQLPROFILE_PARAMETER_NAME_TOKEN_MASK);
            CASE(HSA_VEN_AMD_AQLPROFILE_PARAMETER_NAME_TOKEN_MASK2);
            CASE(HSA_VEN_AMD_AQLPROFILE_PARAMETER_NAME_SE_MASK);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_parameter_name_t_Ptr_String(const hsa_ven_amd_aqlprofile_parameter_name_t* pInputPtr, hsa_ven_amd_aqlprofile_parameter_name_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ven_amd_aqlprofile_parameter_name_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_parameter_t_String(hsa_ven_amd_aqlprofile_parameter_t input)
{
    std::ostringstream ss;

    ss << HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_parameter_name_t_String(input.parameter_name) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.value);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_parameter_t_Ptr_String(const hsa_ven_amd_aqlprofile_parameter_t* pInputPtr, hsa_ven_amd_aqlprofile_parameter_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ven_amd_aqlprofile_parameter_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_descriptor_t_String(hsa_ven_amd_aqlprofile_descriptor_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.ptr) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.size);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_descriptor_t_Ptr_String(const hsa_ven_amd_aqlprofile_descriptor_t* pInputPtr, hsa_ven_amd_aqlprofile_descriptor_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ven_amd_aqlprofile_descriptor_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_profile_t_String(hsa_ven_amd_aqlprofile_profile_t input)
{
    std::ostringstream ss;

    ss << HSATraceStringUtils::Get_hsa_agent_t_String(input.agent) << s_pFieldSeparator;
    ss << HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_event_type_t_String(input.type) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.events) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.event_count) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.parameters) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.parameter_count) << s_pFieldSeparator;
    ss << HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_descriptor_t_String(input.output_buffer) << s_pFieldSeparator;
    ss << HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_descriptor_t_String(input.command_buffer);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_profile_t_Ptr_String(const hsa_ven_amd_aqlprofile_profile_t* pInputPtr, hsa_ven_amd_aqlprofile_profile_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ven_amd_aqlprofile_profile_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ext_amd_aql_pm4_packet_t_String(hsa_ext_amd_aql_pm4_packet_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.header) << s_pFieldSeparator;
    ss << HSATraceStringUtils::GetArrayString(input.pm4_command, 27, StringUtils::ToString) << s_pFieldSeparator;
    ss << HSATraceStringUtils::Get_hsa_signal_t_String(input.completion_signal);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_ext_amd_aql_pm4_packet_t_Ptr_String(const hsa_ext_amd_aql_pm4_packet_t* pInputPtr, hsa_ext_amd_aql_pm4_packet_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ext_amd_aql_pm4_packet_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_info_data_t_String(hsa_ven_amd_aqlprofile_info_data_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.sample_id) << s_pFieldSeparator;
    ss << "{ " ;
    ss << "{ " ;
    ss << HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_event_t_String(input.pmc_data.event) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.pmc_data.result);
    ss << " }";
    ss << HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_descriptor_t_String(input.sqtt_data);
    ss << " }";

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_info_data_t_Ptr_String(const hsa_ven_amd_aqlprofile_info_data_t* pInputPtr, hsa_ven_amd_aqlprofile_info_data_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ven_amd_aqlprofile_info_data_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_id_query_t_String(hsa_ven_amd_aqlprofile_id_query_t input)
{
    std::ostringstream ss;

    ss << StringUtils::ToString(input.name) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.id) << s_pFieldSeparator;
    ss << StringUtils::ToString(input.instance_count);

    return SurroundWithStruct(ss.str());
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_id_query_t_Ptr_String(const hsa_ven_amd_aqlprofile_id_query_t* pInputPtr, hsa_ven_amd_aqlprofile_id_query_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ven_amd_aqlprofile_id_query_t_String(input));
    }
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_info_type_t_String(hsa_ven_amd_aqlprofile_info_type_t input)
{
    std::ostringstream ss;

    switch (static_cast<int>(input))
    {
            CASE(HSA_VEN_AMD_AQLPROFILE_INFO_COMMAND_BUFFER_SIZE);
            CASE(HSA_VEN_AMD_AQLPROFILE_INFO_PMC_DATA_SIZE);
            CASE(HSA_VEN_AMD_AQLPROFILE_INFO_PMC_DATA);
            CASE(HSA_VEN_AMD_AQLPROFILE_INFO_SQTT_DATA);
            CASE(HSA_VEN_AMD_AQLPROFILE_INFO_BLOCK_COUNTERS);
            CASE(HSA_VEN_AMD_AQLPROFILE_INFO_BLOCK_ID);
            CASE(HSA_VEN_AMD_AQLPROFILE_INFO_ENABLE_CMD);

        default:
            ss << input;
            break;
    }

    return ss.str();
}

std::string HSATraceStringUtils::Get_hsa_ven_amd_aqlprofile_info_type_t_Ptr_String(const hsa_ven_amd_aqlprofile_info_type_t* pInputPtr, hsa_ven_amd_aqlprofile_info_type_t input)
{
    if (nullptr == pInputPtr)
    {
        return "NULL";
    }
    else
    {
        return SurroundWithDeRef(Get_hsa_ven_amd_aqlprofile_info_type_t_String(input));
    }
}


