//==============================================================================
// Copyright (c) 2015-2018 Advanced Micro Devices, Inc. All rights reserved.
/// \author AMD Developer Tools Team
/// \file
/// \brief THIS CODE WAS AUTOGENERATED BY HSA CODE GENERATOR
//==============================================================================

#include <algorithm>
#include <map>
#include <hsa_ext_profiler.h>
#include <hsa_ven_amd_loader.h>
#include <hsa_ven_amd_aqlprofile.h>

#include "Logger.h"
#include "GlobalSettings.h"
#include "OSUtils.h"
#include "HSARTModuleLoader.h"
#include "../HSAFdnAPIInfoManager.h"
#include "../HSATraceInterceptionHelpers.h"
#include "../HSATraceStringUtils.h"
#include "HSAAgentIterateReplacer.h"

#include "HSACoreAPITraceClasses.h"
#include "HSAImageExtensionAPITraceClasses.h"
#include "HSAFinalizerExtensionAPITraceClasses.h"
#include "HSAAMDExtensionAPITraceClasses.h"
#include "HSAAMDLoaderExtensionAPITraceClasses.h"
#include "HSAAMDAQLProfileExtensionAPITraceClasses.h"

#include "HSATraceInterception.h"

CoreApiTable*                  g_pRealCoreFunctions          = nullptr;
FinalizerExtTable*             g_pRealFinalizerExtFunctions  = nullptr;
ImageExtTable*                 g_pRealImageExtFunctions      = nullptr;
AmdExtTable*                   g_pRealAmdExtFunctions        = nullptr;
hsa_ven_amd_aqlprofile_pfn_t*  g_pRealAqlProfileExtFunctions = nullptr;
hsa_ven_amd_loader_1_01_pfn_t* g_pRealLoaderExtFunctions     = nullptr;

hsa_status_t HSA_API_Trace_hsa_status_string(hsa_status_t status, const char** status_string)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_status_string_fn(status, status_string);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_status_string* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_status_string();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        status,
        status_string,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_init()
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_init_fn();
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_init* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_init();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_shut_down()
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_shut_down_fn();
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_shut_down* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_shut_down();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_system_get_info(hsa_system_info_t attribute, void* value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_system_get_info_fn(attribute, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_system_get_info* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_system_get_info();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        attribute,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_extension_get_name(uint16_t extension, const char** name)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_extension_get_name_fn(extension, name);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_extension_get_name* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_extension_get_name();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        extension,
        name,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_system_extension_supported(uint16_t extension, uint16_t version_major, uint16_t version_minor, bool* result)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_system_extension_supported_fn(extension, version_major, version_minor, result);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_system_extension_supported* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_system_extension_supported();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        extension,
        version_major,
        version_minor,
        result,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_system_major_extension_supported(uint16_t extension, uint16_t version_major, uint16_t* version_minor, bool* result)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_system_major_extension_supported_fn(extension, version_major, version_minor, result);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_system_major_extension_supported* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_system_major_extension_supported();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        extension,
        version_major,
        version_minor,
        result,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_system_get_extension_table(uint16_t extension, uint16_t version_major, uint16_t version_minor, void* table)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_system_get_extension_table_fn(extension, version_major, version_minor, table);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_system_get_extension_table* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_system_get_extension_table();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        extension,
        version_major,
        version_minor,
        table,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
    HSA_APITrace_hsa_system_get_extension_table_PostCallHelper(retVal, extension, version_major, version_minor, table);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_system_get_major_extension_table(uint16_t extension, uint16_t version_major, size_t table_length, void* table)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_system_get_major_extension_table_fn(extension, version_major, table_length, table);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_system_get_major_extension_table* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_system_get_major_extension_table();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        extension,
        version_major,
        table_length,
        table,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
    HSA_APITrace_hsa_system_get_major_extension_table_PostCallHelper(retVal, extension, version_major, table_length, table);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_agent_get_info(hsa_agent_t agent, hsa_agent_info_t attribute, void* value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_agent_get_info_fn(agent, attribute, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_agent_get_info* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_agent_get_info();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        attribute,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_iterate_agents(hsa_status_t (*callback)(hsa_agent_t agent, void* data), void* data)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_iterate_agents_fn(HSAAgentIterateReplacer::Instance()->GetAgentIterator(callback, g_pRealCoreFunctions), data);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_iterate_agents* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_iterate_agents();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        callback,
        data,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_agent_get_exception_policies(hsa_agent_t agent, hsa_profile_t profile, uint16_t* mask)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_agent_get_exception_policies_fn(agent, profile, mask);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_agent_get_exception_policies* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_agent_get_exception_policies();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        profile,
        mask,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_cache_get_info(hsa_cache_t cache, hsa_cache_info_t attribute, void* value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_cache_get_info_fn(cache, attribute, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_cache_get_info* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_cache_get_info();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    void* pLocalValue = value;
    uint32_t valueLength = 0;
    std::string strValue;
    std::map<hsa_cache_info_t, hsa_cache_info_t> attrMap;

    attrMap.insert({HSA_CACHE_INFO_NAME, HSA_CACHE_INFO_NAME_LENGTH});

    if (attrMap.find(attribute) != attrMap.end())
    {
        if (HSA_STATUS_SUCCESS == g_pRealCoreFunctions->hsa_cache_get_info_fn(cache, attrMap.at(attribute), &valueLength))
        {
            strValue.assign(reinterpret_cast<char*>(value), valueLength);
            pLocalValue = reinterpret_cast<void*>(const_cast<char*>(strValue.c_str()));
            ++valueLength;
        }
    }
    else
    {
        valueLength = HSATraceStringUtils::Get_hsa_cache_get_info_AttributeSize(attribute);
    }


    pAPIInfo->Create(
        ullStart,
        ullEnd,
        cache,
        attribute,
        pLocalValue,
        valueLength,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_agent_iterate_caches(hsa_agent_t agent, hsa_status_t (*callback)(hsa_cache_t cache, void* data), void* data)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_agent_iterate_caches_fn(agent, callback, data);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_agent_iterate_caches* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_agent_iterate_caches();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        callback,
        data,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_agent_extension_supported(uint16_t extension, hsa_agent_t agent, uint16_t version_major, uint16_t version_minor, bool* result)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_agent_extension_supported_fn(extension, agent, version_major, version_minor, result);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_agent_extension_supported* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_agent_extension_supported();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        extension,
        agent,
        version_major,
        version_minor,
        result,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_agent_major_extension_supported(uint16_t extension, hsa_agent_t agent, uint16_t version_major, uint16_t* version_minor, bool* result)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_agent_major_extension_supported_fn(extension, agent, version_major, version_minor, result);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_agent_major_extension_supported* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_agent_major_extension_supported();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        extension,
        agent,
        version_major,
        version_minor,
        result,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_signal_create(hsa_signal_value_t initial_value, uint32_t num_consumers, const hsa_agent_t* consumers, hsa_signal_t* signal)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_signal_create_fn(initial_value, num_consumers, consumers, signal);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_create* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_create();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        initial_value,
        num_consumers,
        consumers,
        signal,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_signal_destroy(hsa_signal_t signal)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_signal_destroy_fn(signal);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_destroy* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_destroy();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_signal_value_t HSA_API_Trace_hsa_signal_load_scacquire(hsa_signal_t signal)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_signal_value_t retVal = g_pRealCoreFunctions->hsa_signal_load_scacquire_fn(signal);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_load_scacquire* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_load_scacquire();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_signal_value_t HSA_API_Trace_hsa_signal_load_relaxed(hsa_signal_t signal)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_signal_value_t retVal = g_pRealCoreFunctions->hsa_signal_load_relaxed_fn(signal);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_load_relaxed* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_load_relaxed();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

void HSA_API_Trace_hsa_signal_store_relaxed(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_store_relaxed_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_store_relaxed* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_store_relaxed();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_signal_store_screlease(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_store_screlease_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_store_screlease* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_store_screlease();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_signal_silent_store_relaxed(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_silent_store_relaxed_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_silent_store_relaxed* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_silent_store_relaxed();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_signal_silent_store_screlease(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_silent_store_screlease_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_silent_store_screlease* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_silent_store_screlease();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

hsa_signal_value_t HSA_API_Trace_hsa_signal_exchange_scacq_screl(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_signal_value_t retVal = g_pRealCoreFunctions->hsa_signal_exchange_scacq_screl_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_exchange_scacq_screl* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_exchange_scacq_screl();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_signal_value_t HSA_API_Trace_hsa_signal_exchange_scacquire(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_signal_value_t retVal = g_pRealCoreFunctions->hsa_signal_exchange_scacquire_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_exchange_scacquire* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_exchange_scacquire();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_signal_value_t HSA_API_Trace_hsa_signal_exchange_relaxed(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_signal_value_t retVal = g_pRealCoreFunctions->hsa_signal_exchange_relaxed_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_exchange_relaxed* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_exchange_relaxed();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_signal_value_t HSA_API_Trace_hsa_signal_exchange_screlease(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_signal_value_t retVal = g_pRealCoreFunctions->hsa_signal_exchange_screlease_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_exchange_screlease* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_exchange_screlease();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_signal_value_t HSA_API_Trace_hsa_signal_cas_scacq_screl(hsa_signal_t signal, hsa_signal_value_t expected, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_signal_value_t retVal = g_pRealCoreFunctions->hsa_signal_cas_scacq_screl_fn(signal, expected, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_cas_scacq_screl* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_cas_scacq_screl();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        expected,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_signal_value_t HSA_API_Trace_hsa_signal_cas_scacquire(hsa_signal_t signal, hsa_signal_value_t expected, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_signal_value_t retVal = g_pRealCoreFunctions->hsa_signal_cas_scacquire_fn(signal, expected, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_cas_scacquire* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_cas_scacquire();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        expected,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_signal_value_t HSA_API_Trace_hsa_signal_cas_relaxed(hsa_signal_t signal, hsa_signal_value_t expected, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_signal_value_t retVal = g_pRealCoreFunctions->hsa_signal_cas_relaxed_fn(signal, expected, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_cas_relaxed* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_cas_relaxed();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        expected,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_signal_value_t HSA_API_Trace_hsa_signal_cas_screlease(hsa_signal_t signal, hsa_signal_value_t expected, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_signal_value_t retVal = g_pRealCoreFunctions->hsa_signal_cas_screlease_fn(signal, expected, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_cas_screlease* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_cas_screlease();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        expected,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

void HSA_API_Trace_hsa_signal_add_scacq_screl(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_add_scacq_screl_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_add_scacq_screl* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_add_scacq_screl();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_signal_add_scacquire(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_add_scacquire_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_add_scacquire* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_add_scacquire();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_signal_add_relaxed(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_add_relaxed_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_add_relaxed* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_add_relaxed();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_signal_add_screlease(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_add_screlease_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_add_screlease* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_add_screlease();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_signal_subtract_scacq_screl(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_subtract_scacq_screl_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_subtract_scacq_screl* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_subtract_scacq_screl();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_signal_subtract_scacquire(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_subtract_scacquire_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_subtract_scacquire* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_subtract_scacquire();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_signal_subtract_relaxed(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_subtract_relaxed_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_subtract_relaxed* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_subtract_relaxed();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_signal_subtract_screlease(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_subtract_screlease_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_subtract_screlease* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_subtract_screlease();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_signal_and_scacq_screl(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_and_scacq_screl_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_and_scacq_screl* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_and_scacq_screl();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_signal_and_scacquire(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_and_scacquire_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_and_scacquire* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_and_scacquire();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_signal_and_relaxed(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_and_relaxed_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_and_relaxed* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_and_relaxed();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_signal_and_screlease(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_and_screlease_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_and_screlease* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_and_screlease();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_signal_or_scacq_screl(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_or_scacq_screl_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_or_scacq_screl* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_or_scacq_screl();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_signal_or_scacquire(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_or_scacquire_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_or_scacquire* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_or_scacquire();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_signal_or_relaxed(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_or_relaxed_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_or_relaxed* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_or_relaxed();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_signal_or_screlease(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_or_screlease_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_or_screlease* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_or_screlease();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_signal_xor_scacq_screl(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_xor_scacq_screl_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_xor_scacq_screl* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_xor_scacq_screl();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_signal_xor_scacquire(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_xor_scacquire_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_xor_scacquire* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_xor_scacquire();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_signal_xor_relaxed(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_xor_relaxed_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_xor_relaxed* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_xor_relaxed();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_signal_xor_screlease(hsa_signal_t signal, hsa_signal_value_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_signal_xor_screlease_fn(signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_xor_screlease* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_xor_screlease();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

hsa_signal_value_t HSA_API_Trace_hsa_signal_wait_scacquire(hsa_signal_t signal, hsa_signal_condition_t condition, hsa_signal_value_t compare_value, uint64_t timeout_hint, hsa_wait_state_t wait_state_hint)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_signal_value_t retVal = g_pRealCoreFunctions->hsa_signal_wait_scacquire_fn(signal, condition, compare_value, timeout_hint, wait_state_hint);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_wait_scacquire* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_wait_scacquire();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        condition,
        compare_value,
        timeout_hint,
        wait_state_hint,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_signal_value_t HSA_API_Trace_hsa_signal_wait_relaxed(hsa_signal_t signal, hsa_signal_condition_t condition, hsa_signal_value_t compare_value, uint64_t timeout_hint, hsa_wait_state_t wait_state_hint)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_signal_value_t retVal = g_pRealCoreFunctions->hsa_signal_wait_relaxed_fn(signal, condition, compare_value, timeout_hint, wait_state_hint);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_wait_relaxed* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_wait_relaxed();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        condition,
        compare_value,
        timeout_hint,
        wait_state_hint,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_signal_group_create(uint32_t num_signals, const hsa_signal_t* signals, uint32_t num_consumers, const hsa_agent_t* consumers, hsa_signal_group_t* signal_group)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_signal_group_create_fn(num_signals, signals, num_consumers, consumers, signal_group);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_group_create* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_group_create();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        num_signals,
        signals,
        num_consumers,
        consumers,
        signal_group,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_signal_group_destroy(hsa_signal_group_t signal_group)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_signal_group_destroy_fn(signal_group);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_group_destroy* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_group_destroy();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal_group,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_signal_group_wait_any_scacquire(hsa_signal_group_t signal_group, const hsa_signal_condition_t* conditions, const hsa_signal_value_t* compare_values, hsa_wait_state_t wait_state_hint, hsa_signal_t* signal, hsa_signal_value_t* value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_signal_group_wait_any_scacquire_fn(signal_group, conditions, compare_values, wait_state_hint, signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_group_wait_any_scacquire* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_group_wait_any_scacquire();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal_group,
        conditions,
        compare_values,
        wait_state_hint,
        signal,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_signal_group_wait_any_relaxed(hsa_signal_group_t signal_group, const hsa_signal_condition_t* conditions, const hsa_signal_value_t* compare_values, hsa_wait_state_t wait_state_hint, hsa_signal_t* signal, hsa_signal_value_t* value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_signal_group_wait_any_relaxed_fn(signal_group, conditions, compare_values, wait_state_hint, signal, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_signal_group_wait_any_relaxed* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_signal_group_wait_any_relaxed();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal_group,
        conditions,
        compare_values,
        wait_state_hint,
        signal,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_queue_create(hsa_agent_t agent, uint32_t size, hsa_queue_type32_t type, void (*callback)(hsa_status_t status, hsa_queue_t* source, void* data), void* data, uint32_t private_segment_size, uint32_t group_segment_size, hsa_queue_t** queue)
{
    ULONGLONG ullStart = 0ull;
    ULONGLONG ullEnd = 0ull;
    hsa_status_t retVal = HSA_STATUS_ERROR;

    if (HSA_STATUS_SUCCESS != retVal)
    {
        ullStart = OSUtils::Instance()->GetTimeNanos();
        retVal = g_pRealCoreFunctions->hsa_queue_create_fn(agent, size, type, callback, data, private_segment_size, group_segment_size, queue);
        ullEnd = OSUtils::Instance()->GetTimeNanos();
    }

    HSA_APITrace_hsa_queue_create* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_queue_create();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        size,
        type,
        callback,
        data,
        private_segment_size,
        group_segment_size,
        queue,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
    HSA_APITrace_hsa_queue_create_PostCallHelper(retVal, agent, size, type, callback, data, private_segment_size, group_segment_size, queue);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_soft_queue_create(hsa_region_t region, uint32_t size, hsa_queue_type32_t type, uint32_t features, hsa_signal_t doorbell_signal, hsa_queue_t** queue)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_soft_queue_create_fn(region, size, type, features, doorbell_signal, queue);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_soft_queue_create* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_soft_queue_create();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        region,
        size,
        type,
        features,
        doorbell_signal,
        queue,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_queue_destroy(hsa_queue_t* queue)
{
    hsa_queue_t temp_queue;

    if (nullptr != queue)
    {
        memcpy(&temp_queue, queue, sizeof(hsa_queue_t));
    }

    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_queue_destroy_fn(queue);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_queue_destroy* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_queue_destroy();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        nullptr != queue ? &temp_queue : queue,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_queue_inactivate(hsa_queue_t* queue)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_queue_inactivate_fn(queue);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_queue_inactivate* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_queue_inactivate();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        queue,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

uint64_t HSA_API_Trace_hsa_queue_load_read_index_scacquire(const hsa_queue_t* queue)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    uint64_t retVal = g_pRealCoreFunctions->hsa_queue_load_read_index_scacquire_fn(queue);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_queue_load_read_index_scacquire* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_queue_load_read_index_scacquire();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        queue,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

uint64_t HSA_API_Trace_hsa_queue_load_read_index_relaxed(const hsa_queue_t* queue)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    uint64_t retVal = g_pRealCoreFunctions->hsa_queue_load_read_index_relaxed_fn(queue);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_queue_load_read_index_relaxed* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_queue_load_read_index_relaxed();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        queue,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

uint64_t HSA_API_Trace_hsa_queue_load_write_index_scacquire(const hsa_queue_t* queue)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    uint64_t retVal = g_pRealCoreFunctions->hsa_queue_load_write_index_scacquire_fn(queue);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_queue_load_write_index_scacquire* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_queue_load_write_index_scacquire();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        queue,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

uint64_t HSA_API_Trace_hsa_queue_load_write_index_relaxed(const hsa_queue_t* queue)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    uint64_t retVal = g_pRealCoreFunctions->hsa_queue_load_write_index_relaxed_fn(queue);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_queue_load_write_index_relaxed* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_queue_load_write_index_relaxed();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        queue,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

void HSA_API_Trace_hsa_queue_store_write_index_relaxed(const hsa_queue_t* queue, uint64_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_queue_store_write_index_relaxed_fn(queue, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_queue_store_write_index_relaxed* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_queue_store_write_index_relaxed();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        queue,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_queue_store_write_index_screlease(const hsa_queue_t* queue, uint64_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_queue_store_write_index_screlease_fn(queue, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_queue_store_write_index_screlease* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_queue_store_write_index_screlease();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        queue,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

uint64_t HSA_API_Trace_hsa_queue_cas_write_index_scacq_screl(const hsa_queue_t* queue, uint64_t expected, uint64_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    uint64_t retVal = g_pRealCoreFunctions->hsa_queue_cas_write_index_scacq_screl_fn(queue, expected, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_queue_cas_write_index_scacq_screl* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_queue_cas_write_index_scacq_screl();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        queue,
        expected,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

uint64_t HSA_API_Trace_hsa_queue_cas_write_index_scacquire(const hsa_queue_t* queue, uint64_t expected, uint64_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    uint64_t retVal = g_pRealCoreFunctions->hsa_queue_cas_write_index_scacquire_fn(queue, expected, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_queue_cas_write_index_scacquire* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_queue_cas_write_index_scacquire();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        queue,
        expected,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

uint64_t HSA_API_Trace_hsa_queue_cas_write_index_relaxed(const hsa_queue_t* queue, uint64_t expected, uint64_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    uint64_t retVal = g_pRealCoreFunctions->hsa_queue_cas_write_index_relaxed_fn(queue, expected, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_queue_cas_write_index_relaxed* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_queue_cas_write_index_relaxed();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        queue,
        expected,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

uint64_t HSA_API_Trace_hsa_queue_cas_write_index_screlease(const hsa_queue_t* queue, uint64_t expected, uint64_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    uint64_t retVal = g_pRealCoreFunctions->hsa_queue_cas_write_index_screlease_fn(queue, expected, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_queue_cas_write_index_screlease* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_queue_cas_write_index_screlease();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        queue,
        expected,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

uint64_t HSA_API_Trace_hsa_queue_add_write_index_scacq_screl(const hsa_queue_t* queue, uint64_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    uint64_t retVal = g_pRealCoreFunctions->hsa_queue_add_write_index_scacq_screl_fn(queue, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_queue_add_write_index_scacq_screl* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_queue_add_write_index_scacq_screl();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        queue,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

uint64_t HSA_API_Trace_hsa_queue_add_write_index_scacquire(const hsa_queue_t* queue, uint64_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    uint64_t retVal = g_pRealCoreFunctions->hsa_queue_add_write_index_scacquire_fn(queue, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_queue_add_write_index_scacquire* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_queue_add_write_index_scacquire();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        queue,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

uint64_t HSA_API_Trace_hsa_queue_add_write_index_relaxed(const hsa_queue_t* queue, uint64_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    uint64_t retVal = g_pRealCoreFunctions->hsa_queue_add_write_index_relaxed_fn(queue, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_queue_add_write_index_relaxed* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_queue_add_write_index_relaxed();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        queue,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

uint64_t HSA_API_Trace_hsa_queue_add_write_index_screlease(const hsa_queue_t* queue, uint64_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    uint64_t retVal = g_pRealCoreFunctions->hsa_queue_add_write_index_screlease_fn(queue, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_queue_add_write_index_screlease* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_queue_add_write_index_screlease();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        queue,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

void HSA_API_Trace_hsa_queue_store_read_index_relaxed(const hsa_queue_t* queue, uint64_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_queue_store_read_index_relaxed_fn(queue, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_queue_store_read_index_relaxed* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_queue_store_read_index_relaxed();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        queue,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

void HSA_API_Trace_hsa_queue_store_read_index_screlease(const hsa_queue_t* queue, uint64_t value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    g_pRealCoreFunctions->hsa_queue_store_read_index_screlease_fn(queue, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_queue_store_read_index_screlease* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_queue_store_read_index_screlease();
    SpAssert(nullptr != pAPIInfo);

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        queue,
        value);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
}

hsa_status_t HSA_API_Trace_hsa_region_get_info(hsa_region_t region, hsa_region_info_t attribute, void* value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_region_get_info_fn(region, attribute, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_region_get_info* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_region_get_info();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        region,
        attribute,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_agent_iterate_regions(hsa_agent_t agent, hsa_status_t (*callback)(hsa_region_t region, void* data), void* data)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_agent_iterate_regions_fn(agent, callback, data);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_agent_iterate_regions* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_agent_iterate_regions();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        callback,
        data,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_memory_allocate(hsa_region_t region, size_t size, void** ptr)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_memory_allocate_fn(region, size, ptr);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_memory_allocate* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_memory_allocate();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        region,
        size,
        ptr,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_memory_free(void* ptr)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_memory_free_fn(ptr);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_memory_free* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_memory_free();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        ptr,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_memory_copy(void* dst, const void* src, size_t size)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_memory_copy_fn(dst, src, size);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_memory_copy* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_memory_copy();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        dst,
        src,
        size,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_memory_assign_agent(void* ptr, hsa_agent_t agent, hsa_access_permission_t access)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_memory_assign_agent_fn(ptr, agent, access);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_memory_assign_agent* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_memory_assign_agent();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        ptr,
        agent,
        access,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_memory_register(void* ptr, size_t size)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_memory_register_fn(ptr, size);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_memory_register* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_memory_register();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        ptr,
        size,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_memory_deregister(void* ptr, size_t size)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_memory_deregister_fn(ptr, size);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_memory_deregister* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_memory_deregister();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        ptr,
        size,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_isa_from_name(const char* name, hsa_isa_t* isa)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_isa_from_name_fn(name, isa);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_isa_from_name* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_isa_from_name();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        name,
        isa,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_agent_iterate_isas(hsa_agent_t agent, hsa_status_t (*callback)(hsa_isa_t isa, void* data), void* data)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_agent_iterate_isas_fn(agent, callback, data);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_agent_iterate_isas* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_agent_iterate_isas();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        callback,
        data,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_isa_get_info(hsa_isa_t isa, hsa_isa_info_t attribute, uint32_t index, void* value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_isa_get_info_fn(isa, attribute, index, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_isa_get_info* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_isa_get_info();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    void* pLocalValue = value;
    uint32_t valueLength = 0;
    std::string strValue;
    std::map<hsa_isa_info_t, hsa_isa_info_t> attrMap;

    attrMap.insert({HSA_ISA_INFO_NAME, HSA_ISA_INFO_NAME_LENGTH});

    if (attrMap.find(attribute) != attrMap.end())
    {
        if (HSA_STATUS_SUCCESS == g_pRealCoreFunctions->hsa_isa_get_info_fn(isa, attrMap.at(attribute), index, &valueLength))
        {
            strValue.assign(reinterpret_cast<char*>(value), valueLength);
            pLocalValue = reinterpret_cast<void*>(const_cast<char*>(strValue.c_str()));
            ++valueLength;
        }
    }
    else
    {
        valueLength = HSATraceStringUtils::Get_hsa_isa_get_info_AttributeSize(attribute);
    }


    pAPIInfo->Create(
        ullStart,
        ullEnd,
        isa,
        attribute,
        index,
        pLocalValue,
        valueLength,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_isa_get_info_alt(hsa_isa_t isa, hsa_isa_info_t attribute, void* value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_isa_get_info_alt_fn(isa, attribute, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_isa_get_info_alt* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_isa_get_info_alt();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        isa,
        attribute,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_isa_get_exception_policies(hsa_isa_t isa, hsa_profile_t profile, uint16_t* mask)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_isa_get_exception_policies_fn(isa, profile, mask);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_isa_get_exception_policies* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_isa_get_exception_policies();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        isa,
        profile,
        mask,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_isa_get_round_method(hsa_isa_t isa, hsa_fp_type_t fp_type, hsa_flush_mode_t flush_mode, hsa_round_method_t* round_method)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_isa_get_round_method_fn(isa, fp_type, flush_mode, round_method);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_isa_get_round_method* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_isa_get_round_method();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        isa,
        fp_type,
        flush_mode,
        round_method,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_wavefront_get_info(hsa_wavefront_t wavefront, hsa_wavefront_info_t attribute, void* value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_wavefront_get_info_fn(wavefront, attribute, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_wavefront_get_info* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_wavefront_get_info();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        wavefront,
        attribute,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_isa_iterate_wavefronts(hsa_isa_t isa, hsa_status_t (*callback)(hsa_wavefront_t wavefront, void* data), void* data)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_isa_iterate_wavefronts_fn(isa, callback, data);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_isa_iterate_wavefronts* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_isa_iterate_wavefronts();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        isa,
        callback,
        data,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_isa_compatible(hsa_isa_t code_object_isa, hsa_isa_t agent_isa, bool* result)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_isa_compatible_fn(code_object_isa, agent_isa, result);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_isa_compatible* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_isa_compatible();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        code_object_isa,
        agent_isa,
        result,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_code_object_reader_create_from_file(hsa_file_t file, hsa_code_object_reader_t* code_object_reader)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_code_object_reader_create_from_file_fn(file, code_object_reader);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_code_object_reader_create_from_file* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_code_object_reader_create_from_file();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        file,
        code_object_reader,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_code_object_reader_create_from_memory(const void* code_object, size_t size, hsa_code_object_reader_t* code_object_reader)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_code_object_reader_create_from_memory_fn(code_object, size, code_object_reader);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_code_object_reader_create_from_memory* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_code_object_reader_create_from_memory();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        code_object,
        size,
        code_object_reader,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_code_object_reader_destroy(hsa_code_object_reader_t code_object_reader)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_code_object_reader_destroy_fn(code_object_reader);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_code_object_reader_destroy* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_code_object_reader_destroy();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        code_object_reader,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_executable_create(hsa_profile_t profile, hsa_executable_state_t executable_state, const char* options, hsa_executable_t* executable)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_executable_create_fn(profile, executable_state, options, executable);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_executable_create* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_executable_create();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        profile,
        executable_state,
        options,
        executable,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_executable_create_alt(hsa_profile_t profile, hsa_default_float_rounding_mode_t default_float_rounding_mode, const char* options, hsa_executable_t* executable)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_executable_create_alt_fn(profile, default_float_rounding_mode, options, executable);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_executable_create_alt* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_executable_create_alt();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        profile,
        default_float_rounding_mode,
        options,
        executable,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_executable_destroy(hsa_executable_t executable)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_executable_destroy_fn(executable);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_executable_destroy* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_executable_destroy();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        executable,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_executable_load_program_code_object(hsa_executable_t executable, hsa_code_object_reader_t code_object_reader, const char* options, hsa_loaded_code_object_t* loaded_code_object)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_executable_load_program_code_object_fn(executable, code_object_reader, options, loaded_code_object);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_executable_load_program_code_object* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_executable_load_program_code_object();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        executable,
        code_object_reader,
        options,
        loaded_code_object,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_executable_load_agent_code_object(hsa_executable_t executable, hsa_agent_t agent, hsa_code_object_reader_t code_object_reader, const char* options, hsa_loaded_code_object_t* loaded_code_object)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_executable_load_agent_code_object_fn(executable, agent, code_object_reader, options, loaded_code_object);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_executable_load_agent_code_object* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_executable_load_agent_code_object();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        executable,
        agent,
        code_object_reader,
        options,
        loaded_code_object,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_executable_freeze(hsa_executable_t executable, const char* options)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_executable_freeze_fn(executable, options);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_executable_freeze* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_executable_freeze();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        executable,
        options,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_executable_get_info(hsa_executable_t executable, hsa_executable_info_t attribute, void* value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_executable_get_info_fn(executable, attribute, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_executable_get_info* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_executable_get_info();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        executable,
        attribute,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_executable_global_variable_define(hsa_executable_t executable, const char* variable_name, void* address)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_executable_global_variable_define_fn(executable, variable_name, address);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_executable_global_variable_define* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_executable_global_variable_define();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        executable,
        variable_name,
        address,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_executable_agent_global_variable_define(hsa_executable_t executable, hsa_agent_t agent, const char* variable_name, void* address)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_executable_agent_global_variable_define_fn(executable, agent, variable_name, address);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_executable_agent_global_variable_define* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_executable_agent_global_variable_define();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        executable,
        agent,
        variable_name,
        address,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_executable_readonly_variable_define(hsa_executable_t executable, hsa_agent_t agent, const char* variable_name, void* address)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_executable_readonly_variable_define_fn(executable, agent, variable_name, address);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_executable_readonly_variable_define* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_executable_readonly_variable_define();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        executable,
        agent,
        variable_name,
        address,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_executable_validate(hsa_executable_t executable, uint32_t* result)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_executable_validate_fn(executable, result);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_executable_validate* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_executable_validate();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        executable,
        result,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_executable_validate_alt(hsa_executable_t executable, const char* options, uint32_t* result)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_executable_validate_alt_fn(executable, options, result);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_executable_validate_alt* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_executable_validate_alt();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        executable,
        options,
        result,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_executable_get_symbol(hsa_executable_t executable, const char* module_name, const char* symbol_name, hsa_agent_t agent, int32_t call_convention, hsa_executable_symbol_t* symbol)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_executable_get_symbol_fn(executable, module_name, symbol_name, agent, call_convention, symbol);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_executable_get_symbol* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_executable_get_symbol();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        executable,
        module_name,
        symbol_name,
        agent,
        call_convention,
        symbol,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
    HSA_APITrace_hsa_executable_get_symbol_PostCallHelper(retVal, executable, module_name, symbol_name, agent, call_convention, symbol);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_executable_get_symbol_by_name(hsa_executable_t executable, const char* symbol_name, const hsa_agent_t* agent, hsa_executable_symbol_t* symbol)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_executable_get_symbol_by_name_fn(executable, symbol_name, agent, symbol);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_executable_get_symbol_by_name* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_executable_get_symbol_by_name();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        executable,
        symbol_name,
        agent,
        symbol,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);
    HSA_APITrace_hsa_executable_get_symbol_by_name_PostCallHelper(retVal, executable, symbol_name, agent, symbol);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_executable_symbol_get_info(hsa_executable_symbol_t executable_symbol, hsa_executable_symbol_info_t attribute, void* value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_executable_symbol_get_info_fn(executable_symbol, attribute, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_executable_symbol_get_info* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_executable_symbol_get_info();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    void* pLocalValue = value;
    uint32_t valueLength = 0;
    std::string strValue;
    std::map<hsa_executable_symbol_info_t, hsa_executable_symbol_info_t> attrMap;

    attrMap.insert({HSA_EXECUTABLE_SYMBOL_INFO_NAME, HSA_EXECUTABLE_SYMBOL_INFO_NAME_LENGTH});
    attrMap.insert({HSA_EXECUTABLE_SYMBOL_INFO_MODULE_NAME, HSA_EXECUTABLE_SYMBOL_INFO_MODULE_NAME_LENGTH});

    if (attrMap.find(attribute) != attrMap.end())
    {
        if (HSA_STATUS_SUCCESS == g_pRealCoreFunctions->hsa_executable_symbol_get_info_fn(executable_symbol, attrMap.at(attribute), &valueLength))
        {
            strValue.assign(reinterpret_cast<char*>(value), valueLength);
            pLocalValue = reinterpret_cast<void*>(const_cast<char*>(strValue.c_str()));
            ++valueLength;
        }
    }
    else
    {
        valueLength = HSATraceStringUtils::Get_hsa_executable_symbol_get_info_AttributeSize(attribute);
    }


    pAPIInfo->Create(
        ullStart,
        ullEnd,
        executable_symbol,
        attribute,
        pLocalValue,
        valueLength,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    if (HSA_EXECUTABLE_SYMBOL_INFO_NAME == attribute)
    {
        HSA_APITrace_hsa_executable_symbol_get_info_PostCallHelper(retVal, executable_symbol, attribute, value);
    }

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_executable_iterate_symbols(hsa_executable_t executable, hsa_status_t (*callback)(hsa_executable_t exec, hsa_executable_symbol_t symbol, void* data), void* data)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_executable_iterate_symbols_fn(executable, callback, data);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_executable_iterate_symbols* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_executable_iterate_symbols();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        executable,
        callback,
        data,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_executable_iterate_agent_symbols(hsa_executable_t executable, hsa_agent_t agent, hsa_status_t (*callback)(hsa_executable_t exec, hsa_agent_t agent, hsa_executable_symbol_t symbol, void* data), void* data)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_executable_iterate_agent_symbols_fn(executable, agent, callback, data);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_executable_iterate_agent_symbols* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_executable_iterate_agent_symbols();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        executable,
        agent,
        callback,
        data,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_executable_iterate_program_symbols(hsa_executable_t executable, hsa_status_t (*callback)(hsa_executable_t exec, hsa_executable_symbol_t symbol, void* data), void* data)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_executable_iterate_program_symbols_fn(executable, callback, data);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_executable_iterate_program_symbols* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_executable_iterate_program_symbols();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        executable,
        callback,
        data,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_code_object_serialize(hsa_code_object_t code_object, hsa_status_t (*alloc_callback)(size_t size, hsa_callback_data_t data, void** address), hsa_callback_data_t callback_data, const char* options, void** serialized_code_object, size_t* serialized_code_object_size)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_code_object_serialize_fn(code_object, alloc_callback, callback_data, options, serialized_code_object, serialized_code_object_size);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_code_object_serialize* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_code_object_serialize();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        code_object,
        alloc_callback,
        callback_data,
        options,
        serialized_code_object,
        serialized_code_object_size,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_code_object_deserialize(void* serialized_code_object, size_t serialized_code_object_size, const char* options, hsa_code_object_t* code_object)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_code_object_deserialize_fn(serialized_code_object, serialized_code_object_size, options, code_object);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_code_object_deserialize* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_code_object_deserialize();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        serialized_code_object,
        serialized_code_object_size,
        options,
        code_object,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_code_object_destroy(hsa_code_object_t code_object)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_code_object_destroy_fn(code_object);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_code_object_destroy* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_code_object_destroy();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        code_object,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_code_object_get_info(hsa_code_object_t code_object, hsa_code_object_info_t attribute, void* value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_code_object_get_info_fn(code_object, attribute, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_code_object_get_info* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_code_object_get_info();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        code_object,
        attribute,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_executable_load_code_object(hsa_executable_t executable, hsa_agent_t agent, hsa_code_object_t code_object, const char* options)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_executable_load_code_object_fn(executable, agent, code_object, options);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_executable_load_code_object* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_executable_load_code_object();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        executable,
        agent,
        code_object,
        options,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_code_object_get_symbol(hsa_code_object_t code_object, const char* symbol_name, hsa_code_symbol_t* symbol)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_code_object_get_symbol_fn(code_object, symbol_name, symbol);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_code_object_get_symbol* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_code_object_get_symbol();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        code_object,
        symbol_name,
        symbol,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_code_object_get_symbol_from_name(hsa_code_object_t code_object, const char* module_name, const char* symbol_name, hsa_code_symbol_t* symbol)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_code_object_get_symbol_from_name_fn(code_object, module_name, symbol_name, symbol);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_code_object_get_symbol_from_name* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_code_object_get_symbol_from_name();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        code_object,
        module_name,
        symbol_name,
        symbol,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_code_symbol_get_info(hsa_code_symbol_t code_symbol, hsa_code_symbol_info_t attribute, void* value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_code_symbol_get_info_fn(code_symbol, attribute, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_code_symbol_get_info* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_code_symbol_get_info();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    void* pLocalValue = value;
    uint32_t valueLength = 0;
    std::string strValue;
    std::map<hsa_code_symbol_info_t, hsa_code_symbol_info_t> attrMap;

    attrMap.insert({HSA_CODE_SYMBOL_INFO_NAME, HSA_CODE_SYMBOL_INFO_NAME_LENGTH});
    attrMap.insert({HSA_CODE_SYMBOL_INFO_MODULE_NAME, HSA_CODE_SYMBOL_INFO_MODULE_NAME_LENGTH});

    if (attrMap.find(attribute) != attrMap.end())
    {
        if (HSA_STATUS_SUCCESS == g_pRealCoreFunctions->hsa_code_symbol_get_info_fn(code_symbol, attrMap.at(attribute), &valueLength))
        {
            strValue.assign(reinterpret_cast<char*>(value), valueLength);
            pLocalValue = reinterpret_cast<void*>(const_cast<char*>(strValue.c_str()));
            ++valueLength;
        }
    }
    else
    {
        valueLength = HSATraceStringUtils::Get_hsa_code_symbol_get_info_AttributeSize(attribute);
    }


    pAPIInfo->Create(
        ullStart,
        ullEnd,
        code_symbol,
        attribute,
        pLocalValue,
        valueLength,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_code_object_iterate_symbols(hsa_code_object_t code_object, hsa_status_t (*callback)(hsa_code_object_t code_object, hsa_code_symbol_t symbol, void* data), void* data)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealCoreFunctions->hsa_code_object_iterate_symbols_fn(code_object, callback, data);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_code_object_iterate_symbols* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_code_object_iterate_symbols();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        code_object,
        callback,
        data,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ext_program_create(hsa_machine_model_t machine_model, hsa_profile_t profile, hsa_default_float_rounding_mode_t default_float_rounding_mode, const char* options, hsa_ext_program_t* program)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealFinalizerExtFunctions->hsa_ext_program_create_fn(machine_model, profile, default_float_rounding_mode, options, program);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ext_program_create* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ext_program_create();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        machine_model,
        profile,
        default_float_rounding_mode,
        options,
        program,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ext_program_destroy(hsa_ext_program_t program)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealFinalizerExtFunctions->hsa_ext_program_destroy_fn(program);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ext_program_destroy* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ext_program_destroy();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        program,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ext_program_add_module(hsa_ext_program_t program, hsa_ext_module_t module)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealFinalizerExtFunctions->hsa_ext_program_add_module_fn(program, module);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ext_program_add_module* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ext_program_add_module();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        program,
        module,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ext_program_iterate_modules(hsa_ext_program_t program, hsa_status_t (*callback)(hsa_ext_program_t program, hsa_ext_module_t module, void* data), void* data)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealFinalizerExtFunctions->hsa_ext_program_iterate_modules_fn(program, callback, data);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ext_program_iterate_modules* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ext_program_iterate_modules();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        program,
        callback,
        data,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ext_program_get_info(hsa_ext_program_t program, hsa_ext_program_info_t attribute, void* value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealFinalizerExtFunctions->hsa_ext_program_get_info_fn(program, attribute, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ext_program_get_info* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ext_program_get_info();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        program,
        attribute,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ext_program_finalize(hsa_ext_program_t program, hsa_isa_t isa, int32_t call_convention, hsa_ext_control_directives_t control_directives, const char* options, hsa_code_object_type_t code_object_type, hsa_code_object_t* code_object)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealFinalizerExtFunctions->hsa_ext_program_finalize_fn(program, isa, call_convention, control_directives, options, code_object_type, code_object);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ext_program_finalize* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ext_program_finalize();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        program,
        isa,
        call_convention,
        control_directives,
        options,
        code_object_type,
        code_object,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ext_image_get_capability(hsa_agent_t agent, hsa_ext_image_geometry_t geometry, const hsa_ext_image_format_t* image_format, uint32_t* capability_mask)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealImageExtFunctions->hsa_ext_image_get_capability_fn(agent, geometry, image_format, capability_mask);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ext_image_get_capability* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ext_image_get_capability();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        geometry,
        image_format,
        capability_mask,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ext_image_get_capability_with_layout(hsa_agent_t agent, hsa_ext_image_geometry_t geometry, const hsa_ext_image_format_t* image_format, hsa_ext_image_data_layout_t image_data_layout, uint32_t* capability_mask)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealImageExtFunctions->hsa_ext_image_get_capability_with_layout_fn(agent, geometry, image_format, image_data_layout, capability_mask);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ext_image_get_capability_with_layout* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ext_image_get_capability_with_layout();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        geometry,
        image_format,
        image_data_layout,
        capability_mask,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ext_image_data_get_info(hsa_agent_t agent, const hsa_ext_image_descriptor_t* image_descriptor, hsa_access_permission_t access_permission, hsa_ext_image_data_info_t* image_data_info)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealImageExtFunctions->hsa_ext_image_data_get_info_fn(agent, image_descriptor, access_permission, image_data_info);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ext_image_data_get_info* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ext_image_data_get_info();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        image_descriptor,
        access_permission,
        image_data_info,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ext_image_data_get_info_with_layout(hsa_agent_t agent, const hsa_ext_image_descriptor_t* image_descriptor, hsa_access_permission_t access_permission, hsa_ext_image_data_layout_t image_data_layout, size_t image_data_row_pitch, size_t image_data_slice_pitch, hsa_ext_image_data_info_t* image_data_info)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealImageExtFunctions->hsa_ext_image_data_get_info_with_layout_fn(agent, image_descriptor, access_permission, image_data_layout, image_data_row_pitch, image_data_slice_pitch, image_data_info);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ext_image_data_get_info_with_layout* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ext_image_data_get_info_with_layout();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        image_descriptor,
        access_permission,
        image_data_layout,
        image_data_row_pitch,
        image_data_slice_pitch,
        image_data_info,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ext_image_create(hsa_agent_t agent, const hsa_ext_image_descriptor_t* image_descriptor, const void* image_data, hsa_access_permission_t access_permission, hsa_ext_image_t* image)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealImageExtFunctions->hsa_ext_image_create_fn(agent, image_descriptor, image_data, access_permission, image);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ext_image_create* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ext_image_create();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        image_descriptor,
        image_data,
        access_permission,
        image,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ext_image_create_with_layout(hsa_agent_t agent, const hsa_ext_image_descriptor_t* image_descriptor, const void* image_data, hsa_access_permission_t access_permission, hsa_ext_image_data_layout_t image_data_layout, size_t image_data_row_pitch, size_t image_data_slice_pitch, hsa_ext_image_t* image)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealImageExtFunctions->hsa_ext_image_create_with_layout_fn(agent, image_descriptor, image_data, access_permission, image_data_layout, image_data_row_pitch, image_data_slice_pitch, image);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ext_image_create_with_layout* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ext_image_create_with_layout();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        image_descriptor,
        image_data,
        access_permission,
        image_data_layout,
        image_data_row_pitch,
        image_data_slice_pitch,
        image,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ext_image_destroy(hsa_agent_t agent, hsa_ext_image_t image)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealImageExtFunctions->hsa_ext_image_destroy_fn(agent, image);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ext_image_destroy* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ext_image_destroy();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        image,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ext_image_copy(hsa_agent_t agent, hsa_ext_image_t src_image, const hsa_dim3_t* src_offset, hsa_ext_image_t dst_image, const hsa_dim3_t* dst_offset, const hsa_dim3_t* range)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealImageExtFunctions->hsa_ext_image_copy_fn(agent, src_image, src_offset, dst_image, dst_offset, range);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ext_image_copy* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ext_image_copy();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        src_image,
        src_offset,
        dst_image,
        dst_offset,
        range,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ext_image_import(hsa_agent_t agent, const void* src_memory, size_t src_row_pitch, size_t src_slice_pitch, hsa_ext_image_t dst_image, const hsa_ext_image_region_t* image_region)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealImageExtFunctions->hsa_ext_image_import_fn(agent, src_memory, src_row_pitch, src_slice_pitch, dst_image, image_region);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ext_image_import* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ext_image_import();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        src_memory,
        src_row_pitch,
        src_slice_pitch,
        dst_image,
        image_region,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ext_image_export(hsa_agent_t agent, hsa_ext_image_t src_image, void* dst_memory, size_t dst_row_pitch, size_t dst_slice_pitch, const hsa_ext_image_region_t* image_region)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealImageExtFunctions->hsa_ext_image_export_fn(agent, src_image, dst_memory, dst_row_pitch, dst_slice_pitch, image_region);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ext_image_export* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ext_image_export();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        src_image,
        dst_memory,
        dst_row_pitch,
        dst_slice_pitch,
        image_region,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ext_image_clear(hsa_agent_t agent, hsa_ext_image_t image, const void* data, const hsa_ext_image_region_t* image_region)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealImageExtFunctions->hsa_ext_image_clear_fn(agent, image, data, image_region);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ext_image_clear* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ext_image_clear();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        image,
        data,
        image_region,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ext_sampler_create(hsa_agent_t agent, const hsa_ext_sampler_descriptor_t* sampler_descriptor, hsa_ext_sampler_t* sampler)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealImageExtFunctions->hsa_ext_sampler_create_fn(agent, sampler_descriptor, sampler);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ext_sampler_create* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ext_sampler_create();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        sampler_descriptor,
        sampler,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ext_sampler_destroy(hsa_agent_t agent, hsa_ext_sampler_t sampler)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealImageExtFunctions->hsa_ext_sampler_destroy_fn(agent, sampler);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ext_sampler_destroy* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ext_sampler_destroy();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        sampler,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_coherency_get_type(hsa_agent_t agent, hsa_amd_coherency_type_t* type)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_coherency_get_type_fn(agent, type);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_coherency_get_type* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_coherency_get_type();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        type,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_coherency_set_type(hsa_agent_t agent, hsa_amd_coherency_type_t type)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_coherency_set_type_fn(agent, type);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_coherency_set_type* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_coherency_set_type();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        type,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_profiling_set_profiler_enabled(hsa_queue_t* queue, int enable)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_profiling_set_profiler_enabled_fn(queue, enable);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_profiling_set_profiler_enabled* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_profiling_set_profiler_enabled();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        queue,
        enable,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_profiling_async_copy_enable(bool enable)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_profiling_async_copy_enable_fn(enable);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_profiling_async_copy_enable* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_profiling_async_copy_enable();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        enable,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_profiling_get_dispatch_time(hsa_agent_t agent, hsa_signal_t signal, hsa_amd_profiling_dispatch_time_t* time)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_profiling_get_dispatch_time_fn(agent, signal, time);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_profiling_get_dispatch_time* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_profiling_get_dispatch_time();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        signal,
        time,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_profiling_get_async_copy_time(hsa_signal_t signal, hsa_amd_profiling_async_copy_time_t* time)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_profiling_get_async_copy_time_fn(signal, time);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_profiling_get_async_copy_time* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_profiling_get_async_copy_time();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        time,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_profiling_convert_tick_to_system_domain(hsa_agent_t agent, uint64_t agent_tick, uint64_t* system_tick)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_profiling_convert_tick_to_system_domain_fn(agent, agent_tick, system_tick);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_profiling_convert_tick_to_system_domain* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_profiling_convert_tick_to_system_domain();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        agent_tick,
        system_tick,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_signal_create(hsa_signal_value_t initial_value, uint32_t num_consumers, const hsa_agent_t* consumers, uint64_t attributes, hsa_signal_t* signal)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_signal_create_fn(initial_value, num_consumers, consumers, attributes, signal);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_signal_create* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_signal_create();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        initial_value,
        num_consumers,
        consumers,
        attributes,
        signal,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_signal_async_handler(hsa_signal_t signal, hsa_signal_condition_t cond, hsa_signal_value_t value, hsa_amd_signal_handler handler, void* arg)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_signal_async_handler_fn(signal, cond, value, handler, arg);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_signal_async_handler* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_signal_async_handler();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        cond,
        value,
        handler,
        arg,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_async_function(void (*callback)(void* arg), void* arg)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_async_function_fn(callback, arg);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_async_function* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_async_function();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        callback,
        arg,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

uint32_t HSA_API_Trace_hsa_amd_signal_wait_any(uint32_t signal_count, hsa_signal_t* signals, hsa_signal_condition_t* conds, hsa_signal_value_t* values, uint64_t timeout_hint, hsa_wait_state_t wait_hint, hsa_signal_value_t* satisfying_value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    uint32_t retVal = g_pRealAmdExtFunctions->hsa_amd_signal_wait_any_fn(signal_count, signals, conds, values, timeout_hint, wait_hint, satisfying_value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_signal_wait_any* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_signal_wait_any();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal_count,
        signals,
        conds,
        values,
        timeout_hint,
        wait_hint,
        satisfying_value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_queue_cu_set_mask(const hsa_queue_t* queue, uint32_t num_cu_mask_count, const uint32_t* cu_mask)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_queue_cu_set_mask_fn(queue, num_cu_mask_count, cu_mask);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_queue_cu_set_mask* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_queue_cu_set_mask();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        queue,
        num_cu_mask_count,
        cu_mask,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_memory_pool_get_info(hsa_amd_memory_pool_t memory_pool, hsa_amd_memory_pool_info_t attribute, void* value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_memory_pool_get_info_fn(memory_pool, attribute, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_memory_pool_get_info* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_memory_pool_get_info();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        memory_pool,
        attribute,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_agent_iterate_memory_pools(hsa_agent_t agent, hsa_status_t (*callback)(hsa_amd_memory_pool_t memory_pool, void* data), void* data)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_agent_iterate_memory_pools_fn(agent, callback, data);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_agent_iterate_memory_pools* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_agent_iterate_memory_pools();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        callback,
        data,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_memory_pool_allocate(hsa_amd_memory_pool_t memory_pool, size_t size, uint32_t flags, void** ptr)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_memory_pool_allocate_fn(memory_pool, size, flags, ptr);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_memory_pool_allocate* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_memory_pool_allocate();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        memory_pool,
        size,
        flags,
        ptr,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_memory_pool_free(void* ptr)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_memory_pool_free_fn(ptr);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_memory_pool_free* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_memory_pool_free();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        ptr,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_memory_async_copy(void* dst, hsa_agent_t dst_agent, const void* src, hsa_agent_t src_agent, size_t size, uint32_t num_dep_signals, const hsa_signal_t* dep_signals, hsa_signal_t completion_signal)
{
    hsa_signal_t origSignal = completion_signal;
    ULONGLONG asyncCopyIdentifier = OSUtils::Instance()->GetTimeNanos();
    HSA_APITrace_hsa_amd_memory_async_copy_PreCallHelper(dst, dst_agent, src, src_agent, size, num_dep_signals, dep_signals, completion_signal, asyncCopyIdentifier);
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_memory_async_copy_fn(dst, dst_agent, src, src_agent, size, num_dep_signals, dep_signals, completion_signal);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_memory_async_copy* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_memory_async_copy();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        dst,
        dst_agent,
        src,
        src_agent,
        size,
        num_dep_signals,
        dep_signals,
        origSignal,
        asyncCopyIdentifier,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_memory_async_copy_rect(const hsa_pitched_ptr_t* dst, const hsa_dim3_t* dst_offset, const hsa_pitched_ptr_t* src, const hsa_dim3_t* src_offset, const hsa_dim3_t* range, hsa_agent_t copy_agent, hsa_amd_copy_direction_t dir, uint32_t num_dep_signals, const hsa_signal_t* dep_signals, hsa_signal_t completion_signal)
{
    hsa_signal_t origSignal = completion_signal;
    ULONGLONG asyncCopyIdentifier = OSUtils::Instance()->GetTimeNanos();
    HSA_APITrace_hsa_amd_memory_async_copy_rect_PreCallHelper(dst, dst_offset, src, src_offset, range, copy_agent, dir, num_dep_signals, dep_signals, completion_signal, asyncCopyIdentifier);
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_memory_async_copy_rect_fn(dst, dst_offset, src, src_offset, range, copy_agent, dir, num_dep_signals, dep_signals, completion_signal);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_memory_async_copy_rect* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_memory_async_copy_rect();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        dst,
        dst_offset,
        src,
        src_offset,
        range,
        copy_agent,
        dir,
        num_dep_signals,
        dep_signals,
        origSignal,
        asyncCopyIdentifier,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_agent_memory_pool_get_info(hsa_agent_t agent, hsa_amd_memory_pool_t memory_pool, hsa_amd_agent_memory_pool_info_t attribute, void* value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_agent_memory_pool_get_info_fn(agent, memory_pool, attribute, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_agent_memory_pool_get_info* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_agent_memory_pool_get_info();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        memory_pool,
        attribute,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_agents_allow_access(uint32_t num_agents, const hsa_agent_t* agents, const uint32_t* flags, const void* ptr)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_agents_allow_access_fn(num_agents, agents, flags, ptr);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_agents_allow_access* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_agents_allow_access();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        num_agents,
        agents,
        flags,
        ptr,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_memory_pool_can_migrate(hsa_amd_memory_pool_t src_memory_pool, hsa_amd_memory_pool_t dst_memory_pool, bool* result)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_memory_pool_can_migrate_fn(src_memory_pool, dst_memory_pool, result);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_memory_pool_can_migrate* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_memory_pool_can_migrate();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        src_memory_pool,
        dst_memory_pool,
        result,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_memory_migrate(const void* ptr, hsa_amd_memory_pool_t memory_pool, uint32_t flags)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_memory_migrate_fn(ptr, memory_pool, flags);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_memory_migrate* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_memory_migrate();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        ptr,
        memory_pool,
        flags,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_memory_lock(void* host_ptr, size_t size, hsa_agent_t* agents, int num_agent, void** agent_ptr)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_memory_lock_fn(host_ptr, size, agents, num_agent, agent_ptr);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_memory_lock* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_memory_lock();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        host_ptr,
        size,
        agents,
        num_agent,
        agent_ptr,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_memory_unlock(void* host_ptr)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_memory_unlock_fn(host_ptr);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_memory_unlock* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_memory_unlock();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        host_ptr,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_memory_fill(void* ptr, uint32_t value, size_t count)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_memory_fill_fn(ptr, value, count);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_memory_fill* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_memory_fill();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        ptr,
        value,
        count,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_interop_map_buffer(uint32_t num_agents, hsa_agent_t* agents, int interop_handle, uint32_t flags, size_t* size, void** ptr, size_t* metadata_size, const void** metadata)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_interop_map_buffer_fn(num_agents, agents, interop_handle, flags, size, ptr, metadata_size, metadata);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_interop_map_buffer* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_interop_map_buffer();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        num_agents,
        agents,
        interop_handle,
        flags,
        size,
        ptr,
        metadata_size,
        metadata,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_interop_unmap_buffer(void* ptr)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_interop_unmap_buffer_fn(ptr);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_interop_unmap_buffer* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_interop_unmap_buffer();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        ptr,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_image_create(hsa_agent_t agent, const hsa_ext_image_descriptor_t* image_descriptor, const hsa_amd_image_descriptor_t* image_layout, const void* image_data, hsa_access_permission_t access_permission, hsa_ext_image_t* image)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_image_create_fn(agent, image_descriptor, image_layout, image_data, access_permission, image);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_image_create* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_image_create();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        image_descriptor,
        image_layout,
        image_data,
        access_permission,
        image,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_pointer_info(void* ptr, hsa_amd_pointer_info_t* info, void* (*alloc)(size_t), uint32_t* num_agents_accessible, hsa_agent_t** accessible)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_pointer_info_fn(ptr, info, alloc, num_agents_accessible, accessible);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_pointer_info* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_pointer_info();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        ptr,
        info,
        alloc,
        num_agents_accessible,
        accessible,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_pointer_info_set_userdata(void* ptr, void* userdata)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_pointer_info_set_userdata_fn(ptr, userdata);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_pointer_info_set_userdata* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_pointer_info_set_userdata();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        ptr,
        userdata,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_ipc_memory_create(void* ptr, size_t len, hsa_amd_ipc_memory_t* handle)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_ipc_memory_create_fn(ptr, len, handle);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_ipc_memory_create* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_ipc_memory_create();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        ptr,
        len,
        handle,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_ipc_memory_attach(const hsa_amd_ipc_memory_t* handle, size_t len, uint32_t num_agents, const hsa_agent_t* mapping_agents, void** mapped_ptr)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_ipc_memory_attach_fn(handle, len, num_agents, mapping_agents, mapped_ptr);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_ipc_memory_attach* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_ipc_memory_attach();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        handle,
        len,
        num_agents,
        mapping_agents,
        mapped_ptr,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_ipc_memory_detach(void* mapped_ptr)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_ipc_memory_detach_fn(mapped_ptr);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_ipc_memory_detach* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_ipc_memory_detach();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        mapped_ptr,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_ipc_signal_create(hsa_signal_t signal, hsa_amd_ipc_signal_t* handle)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_ipc_signal_create_fn(signal, handle);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_ipc_signal_create* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_ipc_signal_create();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        signal,
        handle,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_ipc_signal_attach(const hsa_amd_ipc_signal_t* handle, hsa_signal_t* signal)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_ipc_signal_attach_fn(handle, signal);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_ipc_signal_attach* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_ipc_signal_attach();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        handle,
        signal,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_amd_queue_set_priority(hsa_queue_t* queue, hsa_amd_queue_priority_t priority)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAmdExtFunctions->hsa_amd_queue_set_priority_fn(queue, priority);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_amd_queue_set_priority* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_amd_queue_set_priority();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        queue,
        priority,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ven_amd_loader_query_host_address(const void* device_address, const void** host_address)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealLoaderExtFunctions->hsa_ven_amd_loader_query_host_address(device_address, host_address);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ven_amd_loader_query_host_address* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ven_amd_loader_query_host_address();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        device_address,
        host_address,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ven_amd_loader_query_segment_descriptors(hsa_ven_amd_loader_segment_descriptor_t* segment_descriptors, size_t* num_segment_descriptors)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealLoaderExtFunctions->hsa_ven_amd_loader_query_segment_descriptors(segment_descriptors, num_segment_descriptors);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ven_amd_loader_query_segment_descriptors* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ven_amd_loader_query_segment_descriptors();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        segment_descriptors,
        num_segment_descriptors,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ven_amd_loader_query_executable(const void* device_address, hsa_executable_t* executable)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealLoaderExtFunctions->hsa_ven_amd_loader_query_executable(device_address, executable);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ven_amd_loader_query_executable* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ven_amd_loader_query_executable();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        device_address,
        executable,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ven_amd_loader_executable_iterate_loaded_code_objects(hsa_executable_t executable, hsa_status_t (*callback)(
    hsa_executable_t executable, hsa_loaded_code_object_t loaded_code_object, void* data), void* data)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealLoaderExtFunctions->hsa_ven_amd_loader_executable_iterate_loaded_code_objects(executable, callback, data);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ven_amd_loader_executable_iterate_loaded_code_objects* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ven_amd_loader_executable_iterate_loaded_code_objects();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        executable,
        callback,
        data,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ven_amd_loader_loaded_code_object_get_info(hsa_loaded_code_object_t loaded_code_object, hsa_ven_amd_loader_loaded_code_object_info_t attribute, void* value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealLoaderExtFunctions->hsa_ven_amd_loader_loaded_code_object_get_info(loaded_code_object, attribute, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ven_amd_loader_loaded_code_object_get_info* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ven_amd_loader_loaded_code_object_get_info();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        loaded_code_object,
        attribute,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

uint32_t HSA_API_Trace_hsa_ven_amd_aqlprofile_version_major()
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    uint32_t retVal = g_pRealAqlProfileExtFunctions->hsa_ven_amd_aqlprofile_version_major();
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ven_amd_aqlprofile_version_major* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ven_amd_aqlprofile_version_major();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

uint32_t HSA_API_Trace_hsa_ven_amd_aqlprofile_version_minor()
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    uint32_t retVal = g_pRealAqlProfileExtFunctions->hsa_ven_amd_aqlprofile_version_minor();
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ven_amd_aqlprofile_version_minor* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ven_amd_aqlprofile_version_minor();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ven_amd_aqlprofile_validate_event(hsa_agent_t agent, const hsa_ven_amd_aqlprofile_event_t* event, bool* result)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAqlProfileExtFunctions->hsa_ven_amd_aqlprofile_validate_event(agent, event, result);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ven_amd_aqlprofile_validate_event* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ven_amd_aqlprofile_validate_event();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        agent,
        event,
        result,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ven_amd_aqlprofile_start(hsa_ven_amd_aqlprofile_profile_t* profile, hsa_ext_amd_aql_pm4_packet_t* aql_start_packet)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAqlProfileExtFunctions->hsa_ven_amd_aqlprofile_start(profile, aql_start_packet);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ven_amd_aqlprofile_start* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ven_amd_aqlprofile_start();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        profile,
        aql_start_packet,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ven_amd_aqlprofile_stop(const hsa_ven_amd_aqlprofile_profile_t* profile, hsa_ext_amd_aql_pm4_packet_t* aql_stop_packet)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAqlProfileExtFunctions->hsa_ven_amd_aqlprofile_stop(profile, aql_stop_packet);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ven_amd_aqlprofile_stop* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ven_amd_aqlprofile_stop();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        profile,
        aql_stop_packet,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ven_amd_aqlprofile_read(const hsa_ven_amd_aqlprofile_profile_t* profile, hsa_ext_amd_aql_pm4_packet_t* aql_read_packet)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAqlProfileExtFunctions->hsa_ven_amd_aqlprofile_read(profile, aql_read_packet);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ven_amd_aqlprofile_read* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ven_amd_aqlprofile_read();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        profile,
        aql_read_packet,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ven_amd_aqlprofile_legacy_get_pm4(const hsa_ext_amd_aql_pm4_packet_t* aql_packet, void* data)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAqlProfileExtFunctions->hsa_ven_amd_aqlprofile_legacy_get_pm4(aql_packet, data);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ven_amd_aqlprofile_legacy_get_pm4* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ven_amd_aqlprofile_legacy_get_pm4();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        aql_packet,
        data,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ven_amd_aqlprofile_get_info(const hsa_ven_amd_aqlprofile_profile_t* profile, hsa_ven_amd_aqlprofile_info_type_t attribute, void* value)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAqlProfileExtFunctions->hsa_ven_amd_aqlprofile_get_info(profile, attribute, value);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ven_amd_aqlprofile_get_info* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ven_amd_aqlprofile_get_info();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        profile,
        attribute,
        value,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ven_amd_aqlprofile_iterate_data(const hsa_ven_amd_aqlprofile_profile_t* profile, hsa_ven_amd_aqlprofile_data_callback_t callback, void* data)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAqlProfileExtFunctions->hsa_ven_amd_aqlprofile_iterate_data(profile, callback, data);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ven_amd_aqlprofile_iterate_data* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ven_amd_aqlprofile_iterate_data();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        profile,
        callback,
        data,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

hsa_status_t HSA_API_Trace_hsa_ven_amd_aqlprofile_error_string(const char** str)
{
    ULONGLONG ullStart = OSUtils::Instance()->GetTimeNanos();
    hsa_status_t retVal = g_pRealAqlProfileExtFunctions->hsa_ven_amd_aqlprofile_error_string(str);
    ULONGLONG ullEnd = OSUtils::Instance()->GetTimeNanos();

    HSA_APITrace_hsa_ven_amd_aqlprofile_error_string* pAPIInfo = new(std::nothrow) HSA_APITrace_hsa_ven_amd_aqlprofile_error_string();
    SpAssertRet(nullptr != pAPIInfo) retVal;

    pAPIInfo->Create(
        ullStart,
        ullEnd,
        str,
        retVal);

    RECORD_STACK_TRACE_FOR_API(pAPIInfo);
    HSAAPIInfoManager::Instance()->AddAPIInfoEntry(pAPIInfo);

    return retVal;
}

void InitHSAAPIInterceptTrace(HsaApiTable* pTable)
{
    // the minor_id of the version is the size of the structure
    // use the min of the compiled-in structure size and the size reported by the runtime
    uint32_t tableSize = std::min(pTable->core_->version.minor_id, static_cast<uint32_t>(sizeof(CoreApiTable)));

    if (0 < tableSize)
    {
        g_pRealCoreFunctions = reinterpret_cast<CoreApiTable*>(malloc(tableSize));
        memcpy(g_pRealCoreFunctions, pTable->core_, tableSize);

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_status_string))
        {
            pTable->core_->hsa_status_string_fn = HSA_API_Trace_hsa_status_string;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_init))
        {
            pTable->core_->hsa_init_fn = HSA_API_Trace_hsa_init;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_shut_down))
        {
            pTable->core_->hsa_shut_down_fn = HSA_API_Trace_hsa_shut_down;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_system_get_info))
        {
            pTable->core_->hsa_system_get_info_fn = HSA_API_Trace_hsa_system_get_info;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_extension_get_name))
        {
            pTable->core_->hsa_extension_get_name_fn = HSA_API_Trace_hsa_extension_get_name;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_system_extension_supported))
        {
            pTable->core_->hsa_system_extension_supported_fn = HSA_API_Trace_hsa_system_extension_supported;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_system_major_extension_supported))
        {
            pTable->core_->hsa_system_major_extension_supported_fn = HSA_API_Trace_hsa_system_major_extension_supported;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_system_get_extension_table))
        {
            pTable->core_->hsa_system_get_extension_table_fn = HSA_API_Trace_hsa_system_get_extension_table;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_system_get_major_extension_table))
        {
            pTable->core_->hsa_system_get_major_extension_table_fn = HSA_API_Trace_hsa_system_get_major_extension_table;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_agent_get_info))
        {
            pTable->core_->hsa_agent_get_info_fn = HSA_API_Trace_hsa_agent_get_info;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_iterate_agents))
        {
            pTable->core_->hsa_iterate_agents_fn = HSA_API_Trace_hsa_iterate_agents;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_agent_get_exception_policies))
        {
            pTable->core_->hsa_agent_get_exception_policies_fn = HSA_API_Trace_hsa_agent_get_exception_policies;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_cache_get_info))
        {
            pTable->core_->hsa_cache_get_info_fn = HSA_API_Trace_hsa_cache_get_info;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_agent_iterate_caches))
        {
            pTable->core_->hsa_agent_iterate_caches_fn = HSA_API_Trace_hsa_agent_iterate_caches;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_agent_extension_supported))
        {
            pTable->core_->hsa_agent_extension_supported_fn = HSA_API_Trace_hsa_agent_extension_supported;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_agent_major_extension_supported))
        {
            pTable->core_->hsa_agent_major_extension_supported_fn = HSA_API_Trace_hsa_agent_major_extension_supported;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_create))
        {
            pTable->core_->hsa_signal_create_fn = HSA_API_Trace_hsa_signal_create;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_destroy))
        {
            pTable->core_->hsa_signal_destroy_fn = HSA_API_Trace_hsa_signal_destroy;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_load_scacquire))
        {
            pTable->core_->hsa_signal_load_scacquire_fn = HSA_API_Trace_hsa_signal_load_scacquire;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_load_relaxed))
        {
            pTable->core_->hsa_signal_load_relaxed_fn = HSA_API_Trace_hsa_signal_load_relaxed;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_store_relaxed))
        {
            pTable->core_->hsa_signal_store_relaxed_fn = HSA_API_Trace_hsa_signal_store_relaxed;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_store_screlease))
        {
            pTable->core_->hsa_signal_store_screlease_fn = HSA_API_Trace_hsa_signal_store_screlease;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_silent_store_relaxed))
        {
            pTable->core_->hsa_signal_silent_store_relaxed_fn = HSA_API_Trace_hsa_signal_silent_store_relaxed;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_silent_store_screlease))
        {
            pTable->core_->hsa_signal_silent_store_screlease_fn = HSA_API_Trace_hsa_signal_silent_store_screlease;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_exchange_scacq_screl))
        {
            pTable->core_->hsa_signal_exchange_scacq_screl_fn = HSA_API_Trace_hsa_signal_exchange_scacq_screl;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_exchange_scacquire))
        {
            pTable->core_->hsa_signal_exchange_scacquire_fn = HSA_API_Trace_hsa_signal_exchange_scacquire;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_exchange_relaxed))
        {
            pTable->core_->hsa_signal_exchange_relaxed_fn = HSA_API_Trace_hsa_signal_exchange_relaxed;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_exchange_screlease))
        {
            pTable->core_->hsa_signal_exchange_screlease_fn = HSA_API_Trace_hsa_signal_exchange_screlease;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_cas_scacq_screl))
        {
            pTable->core_->hsa_signal_cas_scacq_screl_fn = HSA_API_Trace_hsa_signal_cas_scacq_screl;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_cas_scacquire))
        {
            pTable->core_->hsa_signal_cas_scacquire_fn = HSA_API_Trace_hsa_signal_cas_scacquire;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_cas_relaxed))
        {
            pTable->core_->hsa_signal_cas_relaxed_fn = HSA_API_Trace_hsa_signal_cas_relaxed;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_cas_screlease))
        {
            pTable->core_->hsa_signal_cas_screlease_fn = HSA_API_Trace_hsa_signal_cas_screlease;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_add_scacq_screl))
        {
            pTable->core_->hsa_signal_add_scacq_screl_fn = HSA_API_Trace_hsa_signal_add_scacq_screl;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_add_scacquire))
        {
            pTable->core_->hsa_signal_add_scacquire_fn = HSA_API_Trace_hsa_signal_add_scacquire;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_add_relaxed))
        {
            pTable->core_->hsa_signal_add_relaxed_fn = HSA_API_Trace_hsa_signal_add_relaxed;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_add_screlease))
        {
            pTable->core_->hsa_signal_add_screlease_fn = HSA_API_Trace_hsa_signal_add_screlease;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_subtract_scacq_screl))
        {
            pTable->core_->hsa_signal_subtract_scacq_screl_fn = HSA_API_Trace_hsa_signal_subtract_scacq_screl;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_subtract_scacquire))
        {
            pTable->core_->hsa_signal_subtract_scacquire_fn = HSA_API_Trace_hsa_signal_subtract_scacquire;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_subtract_relaxed))
        {
            pTable->core_->hsa_signal_subtract_relaxed_fn = HSA_API_Trace_hsa_signal_subtract_relaxed;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_subtract_screlease))
        {
            pTable->core_->hsa_signal_subtract_screlease_fn = HSA_API_Trace_hsa_signal_subtract_screlease;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_and_scacq_screl))
        {
            pTable->core_->hsa_signal_and_scacq_screl_fn = HSA_API_Trace_hsa_signal_and_scacq_screl;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_and_scacquire))
        {
            pTable->core_->hsa_signal_and_scacquire_fn = HSA_API_Trace_hsa_signal_and_scacquire;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_and_relaxed))
        {
            pTable->core_->hsa_signal_and_relaxed_fn = HSA_API_Trace_hsa_signal_and_relaxed;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_and_screlease))
        {
            pTable->core_->hsa_signal_and_screlease_fn = HSA_API_Trace_hsa_signal_and_screlease;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_or_scacq_screl))
        {
            pTable->core_->hsa_signal_or_scacq_screl_fn = HSA_API_Trace_hsa_signal_or_scacq_screl;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_or_scacquire))
        {
            pTable->core_->hsa_signal_or_scacquire_fn = HSA_API_Trace_hsa_signal_or_scacquire;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_or_relaxed))
        {
            pTable->core_->hsa_signal_or_relaxed_fn = HSA_API_Trace_hsa_signal_or_relaxed;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_or_screlease))
        {
            pTable->core_->hsa_signal_or_screlease_fn = HSA_API_Trace_hsa_signal_or_screlease;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_xor_scacq_screl))
        {
            pTable->core_->hsa_signal_xor_scacq_screl_fn = HSA_API_Trace_hsa_signal_xor_scacq_screl;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_xor_scacquire))
        {
            pTable->core_->hsa_signal_xor_scacquire_fn = HSA_API_Trace_hsa_signal_xor_scacquire;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_xor_relaxed))
        {
            pTable->core_->hsa_signal_xor_relaxed_fn = HSA_API_Trace_hsa_signal_xor_relaxed;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_xor_screlease))
        {
            pTable->core_->hsa_signal_xor_screlease_fn = HSA_API_Trace_hsa_signal_xor_screlease;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_wait_scacquire))
        {
            pTable->core_->hsa_signal_wait_scacquire_fn = HSA_API_Trace_hsa_signal_wait_scacquire;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_wait_relaxed))
        {
            pTable->core_->hsa_signal_wait_relaxed_fn = HSA_API_Trace_hsa_signal_wait_relaxed;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_group_create))
        {
            pTable->core_->hsa_signal_group_create_fn = HSA_API_Trace_hsa_signal_group_create;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_group_destroy))
        {
            pTable->core_->hsa_signal_group_destroy_fn = HSA_API_Trace_hsa_signal_group_destroy;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_group_wait_any_scacquire))
        {
            pTable->core_->hsa_signal_group_wait_any_scacquire_fn = HSA_API_Trace_hsa_signal_group_wait_any_scacquire;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_signal_group_wait_any_relaxed))
        {
            pTable->core_->hsa_signal_group_wait_any_relaxed_fn = HSA_API_Trace_hsa_signal_group_wait_any_relaxed;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_queue_create))
        {
            pTable->core_->hsa_queue_create_fn = HSA_API_Trace_hsa_queue_create;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_soft_queue_create))
        {
            pTable->core_->hsa_soft_queue_create_fn = HSA_API_Trace_hsa_soft_queue_create;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_queue_destroy))
        {
            pTable->core_->hsa_queue_destroy_fn = HSA_API_Trace_hsa_queue_destroy;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_queue_inactivate))
        {
            pTable->core_->hsa_queue_inactivate_fn = HSA_API_Trace_hsa_queue_inactivate;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_queue_load_read_index_scacquire))
        {
            pTable->core_->hsa_queue_load_read_index_scacquire_fn = HSA_API_Trace_hsa_queue_load_read_index_scacquire;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_queue_load_read_index_relaxed))
        {
            pTable->core_->hsa_queue_load_read_index_relaxed_fn = HSA_API_Trace_hsa_queue_load_read_index_relaxed;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_queue_load_write_index_scacquire))
        {
            pTable->core_->hsa_queue_load_write_index_scacquire_fn = HSA_API_Trace_hsa_queue_load_write_index_scacquire;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_queue_load_write_index_relaxed))
        {
            pTable->core_->hsa_queue_load_write_index_relaxed_fn = HSA_API_Trace_hsa_queue_load_write_index_relaxed;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_queue_store_write_index_relaxed))
        {
            pTable->core_->hsa_queue_store_write_index_relaxed_fn = HSA_API_Trace_hsa_queue_store_write_index_relaxed;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_queue_store_write_index_screlease))
        {
            pTable->core_->hsa_queue_store_write_index_screlease_fn = HSA_API_Trace_hsa_queue_store_write_index_screlease;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_queue_cas_write_index_scacq_screl))
        {
            pTable->core_->hsa_queue_cas_write_index_scacq_screl_fn = HSA_API_Trace_hsa_queue_cas_write_index_scacq_screl;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_queue_cas_write_index_scacquire))
        {
            pTable->core_->hsa_queue_cas_write_index_scacquire_fn = HSA_API_Trace_hsa_queue_cas_write_index_scacquire;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_queue_cas_write_index_relaxed))
        {
            pTable->core_->hsa_queue_cas_write_index_relaxed_fn = HSA_API_Trace_hsa_queue_cas_write_index_relaxed;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_queue_cas_write_index_screlease))
        {
            pTable->core_->hsa_queue_cas_write_index_screlease_fn = HSA_API_Trace_hsa_queue_cas_write_index_screlease;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_queue_add_write_index_scacq_screl))
        {
            pTable->core_->hsa_queue_add_write_index_scacq_screl_fn = HSA_API_Trace_hsa_queue_add_write_index_scacq_screl;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_queue_add_write_index_scacquire))
        {
            pTable->core_->hsa_queue_add_write_index_scacquire_fn = HSA_API_Trace_hsa_queue_add_write_index_scacquire;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_queue_add_write_index_relaxed))
        {
            pTable->core_->hsa_queue_add_write_index_relaxed_fn = HSA_API_Trace_hsa_queue_add_write_index_relaxed;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_queue_add_write_index_screlease))
        {
            pTable->core_->hsa_queue_add_write_index_screlease_fn = HSA_API_Trace_hsa_queue_add_write_index_screlease;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_queue_store_read_index_relaxed))
        {
            pTable->core_->hsa_queue_store_read_index_relaxed_fn = HSA_API_Trace_hsa_queue_store_read_index_relaxed;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_queue_store_read_index_screlease))
        {
            pTable->core_->hsa_queue_store_read_index_screlease_fn = HSA_API_Trace_hsa_queue_store_read_index_screlease;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_region_get_info))
        {
            pTable->core_->hsa_region_get_info_fn = HSA_API_Trace_hsa_region_get_info;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_agent_iterate_regions))
        {
            pTable->core_->hsa_agent_iterate_regions_fn = HSA_API_Trace_hsa_agent_iterate_regions;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_memory_allocate))
        {
            pTable->core_->hsa_memory_allocate_fn = HSA_API_Trace_hsa_memory_allocate;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_memory_free))
        {
            pTable->core_->hsa_memory_free_fn = HSA_API_Trace_hsa_memory_free;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_memory_copy))
        {
            pTable->core_->hsa_memory_copy_fn = HSA_API_Trace_hsa_memory_copy;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_memory_assign_agent))
        {
            pTable->core_->hsa_memory_assign_agent_fn = HSA_API_Trace_hsa_memory_assign_agent;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_memory_register))
        {
            pTable->core_->hsa_memory_register_fn = HSA_API_Trace_hsa_memory_register;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_memory_deregister))
        {
            pTable->core_->hsa_memory_deregister_fn = HSA_API_Trace_hsa_memory_deregister;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_isa_from_name))
        {
            pTable->core_->hsa_isa_from_name_fn = HSA_API_Trace_hsa_isa_from_name;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_agent_iterate_isas))
        {
            pTable->core_->hsa_agent_iterate_isas_fn = HSA_API_Trace_hsa_agent_iterate_isas;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_isa_get_info))
        {
            pTable->core_->hsa_isa_get_info_fn = HSA_API_Trace_hsa_isa_get_info;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_isa_get_info_alt))
        {
            pTable->core_->hsa_isa_get_info_alt_fn = HSA_API_Trace_hsa_isa_get_info_alt;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_isa_get_exception_policies))
        {
            pTable->core_->hsa_isa_get_exception_policies_fn = HSA_API_Trace_hsa_isa_get_exception_policies;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_isa_get_round_method))
        {
            pTable->core_->hsa_isa_get_round_method_fn = HSA_API_Trace_hsa_isa_get_round_method;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_wavefront_get_info))
        {
            pTable->core_->hsa_wavefront_get_info_fn = HSA_API_Trace_hsa_wavefront_get_info;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_isa_iterate_wavefronts))
        {
            pTable->core_->hsa_isa_iterate_wavefronts_fn = HSA_API_Trace_hsa_isa_iterate_wavefronts;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_isa_compatible))
        {
            pTable->core_->hsa_isa_compatible_fn = HSA_API_Trace_hsa_isa_compatible;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_code_object_reader_create_from_file))
        {
            pTable->core_->hsa_code_object_reader_create_from_file_fn = HSA_API_Trace_hsa_code_object_reader_create_from_file;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_code_object_reader_create_from_memory))
        {
            pTable->core_->hsa_code_object_reader_create_from_memory_fn = HSA_API_Trace_hsa_code_object_reader_create_from_memory;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_code_object_reader_destroy))
        {
            pTable->core_->hsa_code_object_reader_destroy_fn = HSA_API_Trace_hsa_code_object_reader_destroy;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_executable_create))
        {
            pTable->core_->hsa_executable_create_fn = HSA_API_Trace_hsa_executable_create;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_executable_create_alt))
        {
            pTable->core_->hsa_executable_create_alt_fn = HSA_API_Trace_hsa_executable_create_alt;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_executable_destroy))
        {
            pTable->core_->hsa_executable_destroy_fn = HSA_API_Trace_hsa_executable_destroy;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_executable_load_program_code_object))
        {
            pTable->core_->hsa_executable_load_program_code_object_fn = HSA_API_Trace_hsa_executable_load_program_code_object;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_executable_load_agent_code_object))
        {
            pTable->core_->hsa_executable_load_agent_code_object_fn = HSA_API_Trace_hsa_executable_load_agent_code_object;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_executable_freeze))
        {
            pTable->core_->hsa_executable_freeze_fn = HSA_API_Trace_hsa_executable_freeze;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_executable_get_info))
        {
            pTable->core_->hsa_executable_get_info_fn = HSA_API_Trace_hsa_executable_get_info;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_executable_global_variable_define))
        {
            pTable->core_->hsa_executable_global_variable_define_fn = HSA_API_Trace_hsa_executable_global_variable_define;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_executable_agent_global_variable_define))
        {
            pTable->core_->hsa_executable_agent_global_variable_define_fn = HSA_API_Trace_hsa_executable_agent_global_variable_define;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_executable_readonly_variable_define))
        {
            pTable->core_->hsa_executable_readonly_variable_define_fn = HSA_API_Trace_hsa_executable_readonly_variable_define;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_executable_validate))
        {
            pTable->core_->hsa_executable_validate_fn = HSA_API_Trace_hsa_executable_validate;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_executable_validate_alt))
        {
            pTable->core_->hsa_executable_validate_alt_fn = HSA_API_Trace_hsa_executable_validate_alt;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_executable_get_symbol))
        {
            pTable->core_->hsa_executable_get_symbol_fn = HSA_API_Trace_hsa_executable_get_symbol;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_executable_get_symbol_by_name))
        {
            pTable->core_->hsa_executable_get_symbol_by_name_fn = HSA_API_Trace_hsa_executable_get_symbol_by_name;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_executable_symbol_get_info))
        {
            pTable->core_->hsa_executable_symbol_get_info_fn = HSA_API_Trace_hsa_executable_symbol_get_info;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_executable_iterate_symbols))
        {
            pTable->core_->hsa_executable_iterate_symbols_fn = HSA_API_Trace_hsa_executable_iterate_symbols;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_executable_iterate_agent_symbols))
        {
            pTable->core_->hsa_executable_iterate_agent_symbols_fn = HSA_API_Trace_hsa_executable_iterate_agent_symbols;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_executable_iterate_program_symbols))
        {
            pTable->core_->hsa_executable_iterate_program_symbols_fn = HSA_API_Trace_hsa_executable_iterate_program_symbols;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_code_object_serialize))
        {
            pTable->core_->hsa_code_object_serialize_fn = HSA_API_Trace_hsa_code_object_serialize;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_code_object_deserialize))
        {
            pTable->core_->hsa_code_object_deserialize_fn = HSA_API_Trace_hsa_code_object_deserialize;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_code_object_destroy))
        {
            pTable->core_->hsa_code_object_destroy_fn = HSA_API_Trace_hsa_code_object_destroy;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_code_object_get_info))
        {
            pTable->core_->hsa_code_object_get_info_fn = HSA_API_Trace_hsa_code_object_get_info;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_executable_load_code_object))
        {
            pTable->core_->hsa_executable_load_code_object_fn = HSA_API_Trace_hsa_executable_load_code_object;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_code_object_get_symbol))
        {
            pTable->core_->hsa_code_object_get_symbol_fn = HSA_API_Trace_hsa_code_object_get_symbol;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_code_object_get_symbol_from_name))
        {
            pTable->core_->hsa_code_object_get_symbol_from_name_fn = HSA_API_Trace_hsa_code_object_get_symbol_from_name;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_code_symbol_get_info))
        {
            pTable->core_->hsa_code_symbol_get_info_fn = HSA_API_Trace_hsa_code_symbol_get_info;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_code_object_iterate_symbols))
        {
            pTable->core_->hsa_code_object_iterate_symbols_fn = HSA_API_Trace_hsa_code_object_iterate_symbols;
        }
    }

    tableSize = std::min(pTable->finalizer_ext_->version.minor_id, static_cast<uint32_t>(sizeof(FinalizerExtTable)));

    if (0 < tableSize)
    {
        g_pRealFinalizerExtFunctions = reinterpret_cast<FinalizerExtTable*>(malloc(tableSize));
        memcpy(g_pRealFinalizerExtFunctions, pTable->finalizer_ext_, tableSize);

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_ext_program_create))
        {
            pTable->finalizer_ext_->hsa_ext_program_create_fn = HSA_API_Trace_hsa_ext_program_create;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_ext_program_destroy))
        {
            pTable->finalizer_ext_->hsa_ext_program_destroy_fn = HSA_API_Trace_hsa_ext_program_destroy;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_ext_program_add_module))
        {
            pTable->finalizer_ext_->hsa_ext_program_add_module_fn = HSA_API_Trace_hsa_ext_program_add_module;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_ext_program_iterate_modules))
        {
            pTable->finalizer_ext_->hsa_ext_program_iterate_modules_fn = HSA_API_Trace_hsa_ext_program_iterate_modules;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_ext_program_get_info))
        {
            pTable->finalizer_ext_->hsa_ext_program_get_info_fn = HSA_API_Trace_hsa_ext_program_get_info;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_ext_program_finalize))
        {
            pTable->finalizer_ext_->hsa_ext_program_finalize_fn = HSA_API_Trace_hsa_ext_program_finalize;
        }
    }

    tableSize = std::min(pTable->image_ext_->version.minor_id, static_cast<uint32_t>(sizeof(ImageExtTable)));

    if (0 < tableSize)
    {
        g_pRealImageExtFunctions = reinterpret_cast<ImageExtTable*>(malloc(tableSize));
        memcpy(g_pRealImageExtFunctions, pTable->image_ext_, tableSize);

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_ext_image_get_capability))
        {
            pTable->image_ext_->hsa_ext_image_get_capability_fn = HSA_API_Trace_hsa_ext_image_get_capability;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_ext_image_get_capability_with_layout))
        {
            pTable->image_ext_->hsa_ext_image_get_capability_with_layout_fn = HSA_API_Trace_hsa_ext_image_get_capability_with_layout;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_ext_image_data_get_info))
        {
            pTable->image_ext_->hsa_ext_image_data_get_info_fn = HSA_API_Trace_hsa_ext_image_data_get_info;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_ext_image_data_get_info_with_layout))
        {
            pTable->image_ext_->hsa_ext_image_data_get_info_with_layout_fn = HSA_API_Trace_hsa_ext_image_data_get_info_with_layout;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_ext_image_create))
        {
            pTable->image_ext_->hsa_ext_image_create_fn = HSA_API_Trace_hsa_ext_image_create;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_ext_image_create_with_layout))
        {
            pTable->image_ext_->hsa_ext_image_create_with_layout_fn = HSA_API_Trace_hsa_ext_image_create_with_layout;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_ext_image_destroy))
        {
            pTable->image_ext_->hsa_ext_image_destroy_fn = HSA_API_Trace_hsa_ext_image_destroy;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_ext_image_copy))
        {
            pTable->image_ext_->hsa_ext_image_copy_fn = HSA_API_Trace_hsa_ext_image_copy;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_ext_image_import))
        {
            pTable->image_ext_->hsa_ext_image_import_fn = HSA_API_Trace_hsa_ext_image_import;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_ext_image_export))
        {
            pTable->image_ext_->hsa_ext_image_export_fn = HSA_API_Trace_hsa_ext_image_export;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_ext_image_clear))
        {
            pTable->image_ext_->hsa_ext_image_clear_fn = HSA_API_Trace_hsa_ext_image_clear;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_ext_sampler_create))
        {
            pTable->image_ext_->hsa_ext_sampler_create_fn = HSA_API_Trace_hsa_ext_sampler_create;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_ext_sampler_destroy))
        {
            pTable->image_ext_->hsa_ext_sampler_destroy_fn = HSA_API_Trace_hsa_ext_sampler_destroy;
        }
    }

    tableSize = std::min(pTable->amd_ext_->version.minor_id, static_cast<uint32_t>(sizeof(AmdExtTable)));

    if (0 < tableSize)
    {
        g_pRealAmdExtFunctions = reinterpret_cast<AmdExtTable*>(malloc(tableSize));
        memcpy(g_pRealAmdExtFunctions, pTable->amd_ext_, tableSize);

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_coherency_get_type))
        {
            pTable->amd_ext_->hsa_amd_coherency_get_type_fn = HSA_API_Trace_hsa_amd_coherency_get_type;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_coherency_set_type))
        {
            pTable->amd_ext_->hsa_amd_coherency_set_type_fn = HSA_API_Trace_hsa_amd_coherency_set_type;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_profiling_set_profiler_enabled))
        {
            pTable->amd_ext_->hsa_amd_profiling_set_profiler_enabled_fn = HSA_API_Trace_hsa_amd_profiling_set_profiler_enabled;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_profiling_async_copy_enable))
        {
            pTable->amd_ext_->hsa_amd_profiling_async_copy_enable_fn = HSA_API_Trace_hsa_amd_profiling_async_copy_enable;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_profiling_get_dispatch_time))
        {
            pTable->amd_ext_->hsa_amd_profiling_get_dispatch_time_fn = HSA_API_Trace_hsa_amd_profiling_get_dispatch_time;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_profiling_get_async_copy_time))
        {
            pTable->amd_ext_->hsa_amd_profiling_get_async_copy_time_fn = HSA_API_Trace_hsa_amd_profiling_get_async_copy_time;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_profiling_convert_tick_to_system_domain))
        {
            pTable->amd_ext_->hsa_amd_profiling_convert_tick_to_system_domain_fn = HSA_API_Trace_hsa_amd_profiling_convert_tick_to_system_domain;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_signal_create))
        {
            pTable->amd_ext_->hsa_amd_signal_create_fn = HSA_API_Trace_hsa_amd_signal_create;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_signal_async_handler))
        {
            pTable->amd_ext_->hsa_amd_signal_async_handler_fn = HSA_API_Trace_hsa_amd_signal_async_handler;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_async_function))
        {
            pTable->amd_ext_->hsa_amd_async_function_fn = HSA_API_Trace_hsa_amd_async_function;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_signal_wait_any))
        {
            pTable->amd_ext_->hsa_amd_signal_wait_any_fn = HSA_API_Trace_hsa_amd_signal_wait_any;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_queue_cu_set_mask))
        {
            pTable->amd_ext_->hsa_amd_queue_cu_set_mask_fn = HSA_API_Trace_hsa_amd_queue_cu_set_mask;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_memory_pool_get_info))
        {
            pTable->amd_ext_->hsa_amd_memory_pool_get_info_fn = HSA_API_Trace_hsa_amd_memory_pool_get_info;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_agent_iterate_memory_pools))
        {
            pTable->amd_ext_->hsa_amd_agent_iterate_memory_pools_fn = HSA_API_Trace_hsa_amd_agent_iterate_memory_pools;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_memory_pool_allocate))
        {
            pTable->amd_ext_->hsa_amd_memory_pool_allocate_fn = HSA_API_Trace_hsa_amd_memory_pool_allocate;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_memory_pool_free))
        {
            pTable->amd_ext_->hsa_amd_memory_pool_free_fn = HSA_API_Trace_hsa_amd_memory_pool_free;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_memory_async_copy))
        {
            pTable->amd_ext_->hsa_amd_memory_async_copy_fn = HSA_API_Trace_hsa_amd_memory_async_copy;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_memory_async_copy_rect))
        {
            pTable->amd_ext_->hsa_amd_memory_async_copy_rect_fn = HSA_API_Trace_hsa_amd_memory_async_copy_rect;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_agent_memory_pool_get_info))
        {
            pTable->amd_ext_->hsa_amd_agent_memory_pool_get_info_fn = HSA_API_Trace_hsa_amd_agent_memory_pool_get_info;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_agents_allow_access))
        {
            pTable->amd_ext_->hsa_amd_agents_allow_access_fn = HSA_API_Trace_hsa_amd_agents_allow_access;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_memory_pool_can_migrate))
        {
            pTable->amd_ext_->hsa_amd_memory_pool_can_migrate_fn = HSA_API_Trace_hsa_amd_memory_pool_can_migrate;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_memory_migrate))
        {
            pTable->amd_ext_->hsa_amd_memory_migrate_fn = HSA_API_Trace_hsa_amd_memory_migrate;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_memory_lock))
        {
            pTable->amd_ext_->hsa_amd_memory_lock_fn = HSA_API_Trace_hsa_amd_memory_lock;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_memory_unlock))
        {
            pTable->amd_ext_->hsa_amd_memory_unlock_fn = HSA_API_Trace_hsa_amd_memory_unlock;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_memory_fill))
        {
            pTable->amd_ext_->hsa_amd_memory_fill_fn = HSA_API_Trace_hsa_amd_memory_fill;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_interop_map_buffer))
        {
            pTable->amd_ext_->hsa_amd_interop_map_buffer_fn = HSA_API_Trace_hsa_amd_interop_map_buffer;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_interop_unmap_buffer))
        {
            pTable->amd_ext_->hsa_amd_interop_unmap_buffer_fn = HSA_API_Trace_hsa_amd_interop_unmap_buffer;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_image_create))
        {
            pTable->amd_ext_->hsa_amd_image_create_fn = HSA_API_Trace_hsa_amd_image_create;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_pointer_info))
        {
            pTable->amd_ext_->hsa_amd_pointer_info_fn = HSA_API_Trace_hsa_amd_pointer_info;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_pointer_info_set_userdata))
        {
            pTable->amd_ext_->hsa_amd_pointer_info_set_userdata_fn = HSA_API_Trace_hsa_amd_pointer_info_set_userdata;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_ipc_memory_create))
        {
            pTable->amd_ext_->hsa_amd_ipc_memory_create_fn = HSA_API_Trace_hsa_amd_ipc_memory_create;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_ipc_memory_attach))
        {
            pTable->amd_ext_->hsa_amd_ipc_memory_attach_fn = HSA_API_Trace_hsa_amd_ipc_memory_attach;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_ipc_memory_detach))
        {
            pTable->amd_ext_->hsa_amd_ipc_memory_detach_fn = HSA_API_Trace_hsa_amd_ipc_memory_detach;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_ipc_signal_create))
        {
            pTable->amd_ext_->hsa_amd_ipc_signal_create_fn = HSA_API_Trace_hsa_amd_ipc_signal_create;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_ipc_signal_attach))
        {
            pTable->amd_ext_->hsa_amd_ipc_signal_attach_fn = HSA_API_Trace_hsa_amd_ipc_signal_attach;
        }

        if (HSAAPIInfoManager::Instance()->ShouldIntercept(HSA_API_Type_hsa_amd_queue_set_priority))
        {
            pTable->amd_ext_->hsa_amd_queue_set_priority_fn = HSA_API_Trace_hsa_amd_queue_set_priority;
        }
    }
}

void DoneHSAAPIInterceptTrace()
{
    free(g_pRealCoreFunctions);
    free(g_pRealFinalizerExtFunctions);
    free(g_pRealImageExtFunctions);
    free(g_pRealAmdExtFunctions);
    free(g_pRealLoaderExtFunctions);
    free(g_pRealAqlProfileExtFunctions);
}


