//==============================================================================
// Copyright (c) 2015-2018 Advanced Micro Devices, Inc. All rights reserved.
/// \author AMD Developer Tools Team
/// \file
/// \brief THIS CODE WAS AUTOGENERATED BY HSA CODE GENERATOR
//==============================================================================

#include "../HSATraceStringUtils.h"
#include "HSATraceStringOutput.h"

#include "HSACoreAPITraceClasses.h"

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_status_string
///////////////////////////////////////////////////

HSA_APITrace_hsa_status_string::HSA_APITrace_hsa_status_string()
{
}

HSA_APITrace_hsa_status_string::~HSA_APITrace_hsa_status_string()
{
}

std::string HSA_APITrace_hsa_status_string::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_status_string::ToString()
{
    std::ostringstream ss;
    ss << "status=" << HSATraceStringUtils::Get_hsa_status_t_String(m_status) << s_strParamSeparator;

    const char* multiple_indirection_status_string_helper = nullptr;

    if (nullptr != m_status_string)
    {
        multiple_indirection_status_string_helper = m_status_stringVal.c_str();
    }
    ss << "status_string=" << HSATraceStringUtils::SurroundWithDeRef(HSATraceStringUtils::GetStringString(multiple_indirection_status_string_helper, m_status_stringVal));
    return ss.str();
}

void HSA_APITrace_hsa_status_string::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_status_t status,
    const char** status_string,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_status_string;
    m_status = status;
    m_status_string = status_string;

    if (nullptr != m_status_string && nullptr != *m_status_string)
    {
        m_status_stringVal = std::string(*m_status_string);
    }
    else
    {
        m_status_stringVal = "";
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_init
///////////////////////////////////////////////////

HSA_APITrace_hsa_init::HSA_APITrace_hsa_init()
{
}

HSA_APITrace_hsa_init::~HSA_APITrace_hsa_init()
{
}

std::string HSA_APITrace_hsa_init::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_init::ToString()
{
    return "";
}

void HSA_APITrace_hsa_init::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_init;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_shut_down
///////////////////////////////////////////////////

HSA_APITrace_hsa_shut_down::HSA_APITrace_hsa_shut_down()
{
}

HSA_APITrace_hsa_shut_down::~HSA_APITrace_hsa_shut_down()
{
}

std::string HSA_APITrace_hsa_shut_down::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_shut_down::ToString()
{
    return "";
}

void HSA_APITrace_hsa_shut_down::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_shut_down;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_system_get_info
///////////////////////////////////////////////////

HSA_APITrace_hsa_system_get_info::HSA_APITrace_hsa_system_get_info() : m_value(nullptr)
{
}

HSA_APITrace_hsa_system_get_info::~HSA_APITrace_hsa_system_get_info()
{
    if (nullptr != m_value)
    {
        FreeBuffer(m_value);
    }
}

std::string HSA_APITrace_hsa_system_get_info::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_system_get_info::ToString()
{
    std::ostringstream ss;
    ss << "attribute=" << HSATraceStringUtils::Get_hsa_system_info_t_String(m_attribute) << s_strParamSeparator;
    ss << "value=" << HSATraceStringUtils::Get_hsa_system_get_info_AttributeString(m_value, m_attribute, m_retVal);
    return ss.str();
}

void HSA_APITrace_hsa_system_get_info::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_system_info_t attribute,
    void* value,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_system_get_info;
    m_attribute = attribute;

    if (nullptr != value)
    {
        DeepCopyBuffer(&m_value, value, HSATraceStringUtils::Get_hsa_system_get_info_AttributeSize(m_attribute));
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_extension_get_name
///////////////////////////////////////////////////

HSA_APITrace_hsa_extension_get_name::HSA_APITrace_hsa_extension_get_name()
{
}

HSA_APITrace_hsa_extension_get_name::~HSA_APITrace_hsa_extension_get_name()
{
}

std::string HSA_APITrace_hsa_extension_get_name::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_extension_get_name::ToString()
{
    std::ostringstream ss;
    ss << "extension=" << StringUtils::ToString(m_extension) << s_strParamSeparator;

    const char* multiple_indirection_name_helper = nullptr;

    if (nullptr != m_name)
    {
        multiple_indirection_name_helper = m_nameVal.c_str();
    }
    ss << "name=" << HSATraceStringUtils::SurroundWithDeRef(HSATraceStringUtils::GetStringString(multiple_indirection_name_helper, m_nameVal));
    return ss.str();
}

void HSA_APITrace_hsa_extension_get_name::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    uint16_t extension,
    const char** name,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_extension_get_name;
    m_extension = extension;
    m_name = name;

    if (nullptr != m_name && nullptr != *m_name)
    {
        m_nameVal = std::string(*m_name);
    }
    else
    {
        m_nameVal = "";
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_system_extension_supported
///////////////////////////////////////////////////

HSA_APITrace_hsa_system_extension_supported::HSA_APITrace_hsa_system_extension_supported()
{
}

HSA_APITrace_hsa_system_extension_supported::~HSA_APITrace_hsa_system_extension_supported()
{
}

std::string HSA_APITrace_hsa_system_extension_supported::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_system_extension_supported::ToString()
{
    std::ostringstream ss;
    ss << "extension=" << StringUtils::ToString(m_extension) << s_strParamSeparator;
    ss << "version_major=" << StringUtils::ToString(m_version_major) << s_strParamSeparator;
    ss << "version_minor=" << StringUtils::ToString(m_version_minor) << s_strParamSeparator;
    ss << "result=" << StringUtils::ToStringPtr(m_result, m_resultVal);
    return ss.str();
}

void HSA_APITrace_hsa_system_extension_supported::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    uint16_t extension,
    uint16_t version_major,
    uint16_t version_minor,
    bool* result,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_system_extension_supported;
    m_extension = extension;
    m_version_major = version_major;
    m_version_minor = version_minor;
    m_result = result;

    if (nullptr != m_result)
    {
        m_resultVal = *m_result;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_system_major_extension_supported
///////////////////////////////////////////////////

HSA_APITrace_hsa_system_major_extension_supported::HSA_APITrace_hsa_system_major_extension_supported()
{
}

HSA_APITrace_hsa_system_major_extension_supported::~HSA_APITrace_hsa_system_major_extension_supported()
{
}

std::string HSA_APITrace_hsa_system_major_extension_supported::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_system_major_extension_supported::ToString()
{
    std::ostringstream ss;
    ss << "extension=" << StringUtils::ToString(m_extension) << s_strParamSeparator;
    ss << "version_major=" << StringUtils::ToString(m_version_major) << s_strParamSeparator;
    ss << "version_minor=" << StringUtils::ToStringPtr(m_version_minor, m_version_minorVal) << s_strParamSeparator;
    ss << "result=" << StringUtils::ToStringPtr(m_result, m_resultVal);
    return ss.str();
}

void HSA_APITrace_hsa_system_major_extension_supported::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    uint16_t extension,
    uint16_t version_major,
    uint16_t* version_minor,
    bool* result,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_system_major_extension_supported;
    m_extension = extension;
    m_version_major = version_major;
    m_version_minor = version_minor;

    if (nullptr != m_version_minor)
    {
        m_version_minorVal = *m_version_minor;
    }

    m_result = result;

    if (nullptr != m_result)
    {
        m_resultVal = *m_result;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_system_get_extension_table
///////////////////////////////////////////////////

HSA_APITrace_hsa_system_get_extension_table::HSA_APITrace_hsa_system_get_extension_table()
{
}

HSA_APITrace_hsa_system_get_extension_table::~HSA_APITrace_hsa_system_get_extension_table()
{
}

std::string HSA_APITrace_hsa_system_get_extension_table::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_system_get_extension_table::ToString()
{
    std::ostringstream ss;
    ss << "extension=" << StringUtils::ToString(m_extension) << s_strParamSeparator;
    ss << "version_major=" << StringUtils::ToString(m_version_major) << s_strParamSeparator;
    ss << "version_minor=" << StringUtils::ToString(m_version_minor) << s_strParamSeparator;
    ss << "table=" << StringUtils::ToHexString(m_table);
    return ss.str();
}

void HSA_APITrace_hsa_system_get_extension_table::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    uint16_t extension,
    uint16_t version_major,
    uint16_t version_minor,
    void* table,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_system_get_extension_table;
    m_extension = extension;
    m_version_major = version_major;
    m_version_minor = version_minor;
    m_table = table;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_system_get_major_extension_table
///////////////////////////////////////////////////

HSA_APITrace_hsa_system_get_major_extension_table::HSA_APITrace_hsa_system_get_major_extension_table()
{
}

HSA_APITrace_hsa_system_get_major_extension_table::~HSA_APITrace_hsa_system_get_major_extension_table()
{
}

std::string HSA_APITrace_hsa_system_get_major_extension_table::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_system_get_major_extension_table::ToString()
{
    std::ostringstream ss;
    ss << "extension=" << StringUtils::ToString(m_extension) << s_strParamSeparator;
    ss << "version_major=" << StringUtils::ToString(m_version_major) << s_strParamSeparator;
    ss << "table_length=" << StringUtils::ToString(m_table_length) << s_strParamSeparator;
    ss << "table=" << StringUtils::ToHexString(m_table);
    return ss.str();
}

void HSA_APITrace_hsa_system_get_major_extension_table::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    uint16_t extension,
    uint16_t version_major,
    size_t table_length,
    void* table,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_system_get_major_extension_table;
    m_extension = extension;
    m_version_major = version_major;
    m_table_length = table_length;
    m_table = table;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_agent_get_info
///////////////////////////////////////////////////

HSA_APITrace_hsa_agent_get_info::HSA_APITrace_hsa_agent_get_info() : m_value(nullptr)
{
}

HSA_APITrace_hsa_agent_get_info::~HSA_APITrace_hsa_agent_get_info()
{
    if (nullptr != m_value)
    {
        FreeBuffer(m_value);
    }
}

std::string HSA_APITrace_hsa_agent_get_info::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_agent_get_info::ToString()
{
    std::ostringstream ss;
    ss << "agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_agent) << s_strParamSeparator;
    ss << "attribute=" << HSATraceStringUtils::Get_hsa_agent_info_t_String(m_attribute) << s_strParamSeparator;
    ss << "value=" << HSATraceStringUtils::Get_hsa_agent_get_info_AttributeString(m_value, m_attribute, m_retVal);
    return ss.str();
}

void HSA_APITrace_hsa_agent_get_info::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_agent_t agent,
    hsa_agent_info_t attribute,
    void* value,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_agent_get_info;
    m_agent = agent;
    m_attribute = attribute;

    if (nullptr != value)
    {
        DeepCopyBuffer(&m_value, value, HSATraceStringUtils::Get_hsa_agent_get_info_AttributeSize(m_attribute));
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_iterate_agents
///////////////////////////////////////////////////

HSA_APITrace_hsa_iterate_agents::HSA_APITrace_hsa_iterate_agents()
{
}

HSA_APITrace_hsa_iterate_agents::~HSA_APITrace_hsa_iterate_agents()
{
}

std::string HSA_APITrace_hsa_iterate_agents::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_iterate_agents::ToString()
{
    std::ostringstream ss;
    ss << "callback=" << StringUtils::ToString(reinterpret_cast<void*>(m_callback)) << s_strParamSeparator;
    ss << "data=" << StringUtils::ToHexString(m_data);
    return ss.str();
}

void HSA_APITrace_hsa_iterate_agents::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_status_t (*callback)(hsa_agent_t agent, void* data),
    void* data,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_iterate_agents;
    m_callback = callback;
    m_data = data;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_agent_get_exception_policies
///////////////////////////////////////////////////

HSA_APITrace_hsa_agent_get_exception_policies::HSA_APITrace_hsa_agent_get_exception_policies()
{
}

HSA_APITrace_hsa_agent_get_exception_policies::~HSA_APITrace_hsa_agent_get_exception_policies()
{
}

std::string HSA_APITrace_hsa_agent_get_exception_policies::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_agent_get_exception_policies::ToString()
{
    std::ostringstream ss;
    ss << "agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_agent) << s_strParamSeparator;
    ss << "profile=" << HSATraceStringUtils::Get_hsa_profile_t_String(m_profile) << s_strParamSeparator;
    ss << "mask=" << StringUtils::ToStringPtr(m_mask, m_maskVal);
    return ss.str();
}

void HSA_APITrace_hsa_agent_get_exception_policies::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_agent_t agent,
    hsa_profile_t profile,
    uint16_t* mask,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_agent_get_exception_policies;
    m_agent = agent;
    m_profile = profile;
    m_mask = mask;

    if (nullptr != m_mask)
    {
        m_maskVal = *m_mask;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_cache_get_info
///////////////////////////////////////////////////

HSA_APITrace_hsa_cache_get_info::HSA_APITrace_hsa_cache_get_info() : m_value(nullptr)
{
}

HSA_APITrace_hsa_cache_get_info::~HSA_APITrace_hsa_cache_get_info()
{
    if (nullptr != m_value)
    {
        FreeBuffer(m_value);
    }
}

std::string HSA_APITrace_hsa_cache_get_info::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_cache_get_info::ToString()
{
    std::ostringstream ss;
    ss << "cache=" << HSATraceStringUtils::Get_hsa_cache_t_String(m_cache) << s_strParamSeparator;
    ss << "attribute=" << HSATraceStringUtils::Get_hsa_cache_info_t_String(m_attribute) << s_strParamSeparator;
    ss << "value=" << HSATraceStringUtils::Get_hsa_cache_get_info_AttributeString(m_value, m_attribute, m_retVal);
    return ss.str();
}

void HSA_APITrace_hsa_cache_get_info::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_cache_t cache,
    hsa_cache_info_t attribute,
    void* value,
    uint32_t valueLength,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_cache_get_info;
    m_cache = cache;
    m_attribute = attribute;

    if (nullptr != value)
    {
        DeepCopyBuffer(&m_value, value, valueLength);
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_agent_iterate_caches
///////////////////////////////////////////////////

HSA_APITrace_hsa_agent_iterate_caches::HSA_APITrace_hsa_agent_iterate_caches()
{
}

HSA_APITrace_hsa_agent_iterate_caches::~HSA_APITrace_hsa_agent_iterate_caches()
{
}

std::string HSA_APITrace_hsa_agent_iterate_caches::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_agent_iterate_caches::ToString()
{
    std::ostringstream ss;
    ss << "agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_agent) << s_strParamSeparator;
    ss << "callback=" << StringUtils::ToString(reinterpret_cast<void*>(m_callback)) << s_strParamSeparator;
    ss << "data=" << StringUtils::ToHexString(m_data);
    return ss.str();
}

void HSA_APITrace_hsa_agent_iterate_caches::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_agent_t agent,
    hsa_status_t (*callback)(hsa_cache_t cache, void* data),
    void* data,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_agent_iterate_caches;
    m_agent = agent;
    m_callback = callback;
    m_data = data;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_agent_extension_supported
///////////////////////////////////////////////////

HSA_APITrace_hsa_agent_extension_supported::HSA_APITrace_hsa_agent_extension_supported()
{
}

HSA_APITrace_hsa_agent_extension_supported::~HSA_APITrace_hsa_agent_extension_supported()
{
}

std::string HSA_APITrace_hsa_agent_extension_supported::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_agent_extension_supported::ToString()
{
    std::ostringstream ss;
    ss << "extension=" << StringUtils::ToString(m_extension) << s_strParamSeparator;
    ss << "agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_agent) << s_strParamSeparator;
    ss << "version_major=" << StringUtils::ToString(m_version_major) << s_strParamSeparator;
    ss << "version_minor=" << StringUtils::ToString(m_version_minor) << s_strParamSeparator;
    ss << "result=" << StringUtils::ToStringPtr(m_result, m_resultVal);
    return ss.str();
}

void HSA_APITrace_hsa_agent_extension_supported::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    uint16_t extension,
    hsa_agent_t agent,
    uint16_t version_major,
    uint16_t version_minor,
    bool* result,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_agent_extension_supported;
    m_extension = extension;
    m_agent = agent;
    m_version_major = version_major;
    m_version_minor = version_minor;
    m_result = result;

    if (nullptr != m_result)
    {
        m_resultVal = *m_result;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_agent_major_extension_supported
///////////////////////////////////////////////////

HSA_APITrace_hsa_agent_major_extension_supported::HSA_APITrace_hsa_agent_major_extension_supported()
{
}

HSA_APITrace_hsa_agent_major_extension_supported::~HSA_APITrace_hsa_agent_major_extension_supported()
{
}

std::string HSA_APITrace_hsa_agent_major_extension_supported::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_agent_major_extension_supported::ToString()
{
    std::ostringstream ss;
    ss << "extension=" << StringUtils::ToString(m_extension) << s_strParamSeparator;
    ss << "agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_agent) << s_strParamSeparator;
    ss << "version_major=" << StringUtils::ToString(m_version_major) << s_strParamSeparator;
    ss << "version_minor=" << StringUtils::ToStringPtr(m_version_minor, m_version_minorVal) << s_strParamSeparator;
    ss << "result=" << StringUtils::ToStringPtr(m_result, m_resultVal);
    return ss.str();
}

void HSA_APITrace_hsa_agent_major_extension_supported::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    uint16_t extension,
    hsa_agent_t agent,
    uint16_t version_major,
    uint16_t* version_minor,
    bool* result,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_agent_major_extension_supported;
    m_extension = extension;
    m_agent = agent;
    m_version_major = version_major;
    m_version_minor = version_minor;

    if (nullptr != m_version_minor)
    {
        m_version_minorVal = *m_version_minor;
    }

    m_result = result;

    if (nullptr != m_result)
    {
        m_resultVal = *m_result;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_create
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_create::HSA_APITrace_hsa_signal_create()
{
}

HSA_APITrace_hsa_signal_create::~HSA_APITrace_hsa_signal_create()
{
}

std::string HSA_APITrace_hsa_signal_create::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_signal_create::ToString()
{
    std::ostringstream ss;
    ss << "initial_value=" << StringUtils::ToString(m_initial_value) << s_strParamSeparator;
    ss << "num_consumers=" << StringUtils::ToString(m_num_consumers) << s_strParamSeparator;
    ss << "consumers=" << HSATraceStringUtils::Get_hsa_agent_t_Ptr_String(m_consumers, m_consumersVal) << s_strParamSeparator;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_Ptr_String(m_signal, m_signalVal);
    return ss.str();
}

void HSA_APITrace_hsa_signal_create::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_value_t initial_value,
    uint32_t num_consumers,
    const hsa_agent_t* consumers,
    hsa_signal_t* signal,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_create;
    m_initial_value = initial_value;
    m_num_consumers = num_consumers;
    m_consumers = consumers;

    if (nullptr != m_consumers)
    {
        m_consumersVal = *m_consumers;
    }

    m_signal = signal;

    if (nullptr != m_signal)
    {
        m_signalVal = *m_signal;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_destroy
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_destroy::HSA_APITrace_hsa_signal_destroy()
{
}

HSA_APITrace_hsa_signal_destroy::~HSA_APITrace_hsa_signal_destroy()
{
}

std::string HSA_APITrace_hsa_signal_destroy::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_signal_destroy::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal);
    return ss.str();
}

void HSA_APITrace_hsa_signal_destroy::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_destroy;
    m_signal = signal;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_load_scacquire
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_load_scacquire::HSA_APITrace_hsa_signal_load_scacquire()
{
}

HSA_APITrace_hsa_signal_load_scacquire::~HSA_APITrace_hsa_signal_load_scacquire()
{
}

std::string HSA_APITrace_hsa_signal_load_scacquire::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_signal_load_scacquire::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal);
    return ss.str();
}

void HSA_APITrace_hsa_signal_load_scacquire::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_load_scacquire;
    m_signal = signal;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_load_relaxed
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_load_relaxed::HSA_APITrace_hsa_signal_load_relaxed()
{
}

HSA_APITrace_hsa_signal_load_relaxed::~HSA_APITrace_hsa_signal_load_relaxed()
{
}

std::string HSA_APITrace_hsa_signal_load_relaxed::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_signal_load_relaxed::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal);
    return ss.str();
}

void HSA_APITrace_hsa_signal_load_relaxed::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_load_relaxed;
    m_signal = signal;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_store_relaxed
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_store_relaxed::HSA_APITrace_hsa_signal_store_relaxed()
{
}

HSA_APITrace_hsa_signal_store_relaxed::~HSA_APITrace_hsa_signal_store_relaxed()
{
}

std::string HSA_APITrace_hsa_signal_store_relaxed::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_store_relaxed::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_store_relaxed::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_store_relaxed;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_store_screlease
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_store_screlease::HSA_APITrace_hsa_signal_store_screlease()
{
}

HSA_APITrace_hsa_signal_store_screlease::~HSA_APITrace_hsa_signal_store_screlease()
{
}

std::string HSA_APITrace_hsa_signal_store_screlease::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_store_screlease::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_store_screlease::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_store_screlease;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_silent_store_relaxed
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_silent_store_relaxed::HSA_APITrace_hsa_signal_silent_store_relaxed()
{
}

HSA_APITrace_hsa_signal_silent_store_relaxed::~HSA_APITrace_hsa_signal_silent_store_relaxed()
{
}

std::string HSA_APITrace_hsa_signal_silent_store_relaxed::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_silent_store_relaxed::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_silent_store_relaxed::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_silent_store_relaxed;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_silent_store_screlease
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_silent_store_screlease::HSA_APITrace_hsa_signal_silent_store_screlease()
{
}

HSA_APITrace_hsa_signal_silent_store_screlease::~HSA_APITrace_hsa_signal_silent_store_screlease()
{
}

std::string HSA_APITrace_hsa_signal_silent_store_screlease::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_silent_store_screlease::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_silent_store_screlease::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_silent_store_screlease;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_exchange_scacq_screl
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_exchange_scacq_screl::HSA_APITrace_hsa_signal_exchange_scacq_screl()
{
}

HSA_APITrace_hsa_signal_exchange_scacq_screl::~HSA_APITrace_hsa_signal_exchange_scacq_screl()
{
}

std::string HSA_APITrace_hsa_signal_exchange_scacq_screl::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_signal_exchange_scacq_screl::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_exchange_scacq_screl::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value,
    hsa_signal_value_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_exchange_scacq_screl;
    m_signal = signal;
    m_value = value;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_exchange_scacquire
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_exchange_scacquire::HSA_APITrace_hsa_signal_exchange_scacquire()
{
}

HSA_APITrace_hsa_signal_exchange_scacquire::~HSA_APITrace_hsa_signal_exchange_scacquire()
{
}

std::string HSA_APITrace_hsa_signal_exchange_scacquire::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_signal_exchange_scacquire::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_exchange_scacquire::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value,
    hsa_signal_value_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_exchange_scacquire;
    m_signal = signal;
    m_value = value;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_exchange_relaxed
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_exchange_relaxed::HSA_APITrace_hsa_signal_exchange_relaxed()
{
}

HSA_APITrace_hsa_signal_exchange_relaxed::~HSA_APITrace_hsa_signal_exchange_relaxed()
{
}

std::string HSA_APITrace_hsa_signal_exchange_relaxed::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_signal_exchange_relaxed::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_exchange_relaxed::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value,
    hsa_signal_value_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_exchange_relaxed;
    m_signal = signal;
    m_value = value;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_exchange_screlease
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_exchange_screlease::HSA_APITrace_hsa_signal_exchange_screlease()
{
}

HSA_APITrace_hsa_signal_exchange_screlease::~HSA_APITrace_hsa_signal_exchange_screlease()
{
}

std::string HSA_APITrace_hsa_signal_exchange_screlease::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_signal_exchange_screlease::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_exchange_screlease::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value,
    hsa_signal_value_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_exchange_screlease;
    m_signal = signal;
    m_value = value;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_cas_scacq_screl
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_cas_scacq_screl::HSA_APITrace_hsa_signal_cas_scacq_screl()
{
}

HSA_APITrace_hsa_signal_cas_scacq_screl::~HSA_APITrace_hsa_signal_cas_scacq_screl()
{
}

std::string HSA_APITrace_hsa_signal_cas_scacq_screl::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_signal_cas_scacq_screl::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "expected=" << StringUtils::ToString(m_expected) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_cas_scacq_screl::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t expected,
    hsa_signal_value_t value,
    hsa_signal_value_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_cas_scacq_screl;
    m_signal = signal;
    m_expected = expected;
    m_value = value;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_cas_scacquire
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_cas_scacquire::HSA_APITrace_hsa_signal_cas_scacquire()
{
}

HSA_APITrace_hsa_signal_cas_scacquire::~HSA_APITrace_hsa_signal_cas_scacquire()
{
}

std::string HSA_APITrace_hsa_signal_cas_scacquire::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_signal_cas_scacquire::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "expected=" << StringUtils::ToString(m_expected) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_cas_scacquire::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t expected,
    hsa_signal_value_t value,
    hsa_signal_value_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_cas_scacquire;
    m_signal = signal;
    m_expected = expected;
    m_value = value;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_cas_relaxed
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_cas_relaxed::HSA_APITrace_hsa_signal_cas_relaxed()
{
}

HSA_APITrace_hsa_signal_cas_relaxed::~HSA_APITrace_hsa_signal_cas_relaxed()
{
}

std::string HSA_APITrace_hsa_signal_cas_relaxed::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_signal_cas_relaxed::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "expected=" << StringUtils::ToString(m_expected) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_cas_relaxed::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t expected,
    hsa_signal_value_t value,
    hsa_signal_value_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_cas_relaxed;
    m_signal = signal;
    m_expected = expected;
    m_value = value;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_cas_screlease
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_cas_screlease::HSA_APITrace_hsa_signal_cas_screlease()
{
}

HSA_APITrace_hsa_signal_cas_screlease::~HSA_APITrace_hsa_signal_cas_screlease()
{
}

std::string HSA_APITrace_hsa_signal_cas_screlease::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_signal_cas_screlease::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "expected=" << StringUtils::ToString(m_expected) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_cas_screlease::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t expected,
    hsa_signal_value_t value,
    hsa_signal_value_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_cas_screlease;
    m_signal = signal;
    m_expected = expected;
    m_value = value;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_add_scacq_screl
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_add_scacq_screl::HSA_APITrace_hsa_signal_add_scacq_screl()
{
}

HSA_APITrace_hsa_signal_add_scacq_screl::~HSA_APITrace_hsa_signal_add_scacq_screl()
{
}

std::string HSA_APITrace_hsa_signal_add_scacq_screl::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_add_scacq_screl::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_add_scacq_screl::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_add_scacq_screl;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_add_scacquire
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_add_scacquire::HSA_APITrace_hsa_signal_add_scacquire()
{
}

HSA_APITrace_hsa_signal_add_scacquire::~HSA_APITrace_hsa_signal_add_scacquire()
{
}

std::string HSA_APITrace_hsa_signal_add_scacquire::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_add_scacquire::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_add_scacquire::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_add_scacquire;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_add_relaxed
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_add_relaxed::HSA_APITrace_hsa_signal_add_relaxed()
{
}

HSA_APITrace_hsa_signal_add_relaxed::~HSA_APITrace_hsa_signal_add_relaxed()
{
}

std::string HSA_APITrace_hsa_signal_add_relaxed::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_add_relaxed::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_add_relaxed::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_add_relaxed;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_add_screlease
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_add_screlease::HSA_APITrace_hsa_signal_add_screlease()
{
}

HSA_APITrace_hsa_signal_add_screlease::~HSA_APITrace_hsa_signal_add_screlease()
{
}

std::string HSA_APITrace_hsa_signal_add_screlease::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_add_screlease::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_add_screlease::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_add_screlease;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_subtract_scacq_screl
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_subtract_scacq_screl::HSA_APITrace_hsa_signal_subtract_scacq_screl()
{
}

HSA_APITrace_hsa_signal_subtract_scacq_screl::~HSA_APITrace_hsa_signal_subtract_scacq_screl()
{
}

std::string HSA_APITrace_hsa_signal_subtract_scacq_screl::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_subtract_scacq_screl::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_subtract_scacq_screl::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_subtract_scacq_screl;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_subtract_scacquire
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_subtract_scacquire::HSA_APITrace_hsa_signal_subtract_scacquire()
{
}

HSA_APITrace_hsa_signal_subtract_scacquire::~HSA_APITrace_hsa_signal_subtract_scacquire()
{
}

std::string HSA_APITrace_hsa_signal_subtract_scacquire::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_subtract_scacquire::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_subtract_scacquire::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_subtract_scacquire;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_subtract_relaxed
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_subtract_relaxed::HSA_APITrace_hsa_signal_subtract_relaxed()
{
}

HSA_APITrace_hsa_signal_subtract_relaxed::~HSA_APITrace_hsa_signal_subtract_relaxed()
{
}

std::string HSA_APITrace_hsa_signal_subtract_relaxed::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_subtract_relaxed::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_subtract_relaxed::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_subtract_relaxed;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_subtract_screlease
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_subtract_screlease::HSA_APITrace_hsa_signal_subtract_screlease()
{
}

HSA_APITrace_hsa_signal_subtract_screlease::~HSA_APITrace_hsa_signal_subtract_screlease()
{
}

std::string HSA_APITrace_hsa_signal_subtract_screlease::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_subtract_screlease::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_subtract_screlease::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_subtract_screlease;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_and_scacq_screl
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_and_scacq_screl::HSA_APITrace_hsa_signal_and_scacq_screl()
{
}

HSA_APITrace_hsa_signal_and_scacq_screl::~HSA_APITrace_hsa_signal_and_scacq_screl()
{
}

std::string HSA_APITrace_hsa_signal_and_scacq_screl::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_and_scacq_screl::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_and_scacq_screl::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_and_scacq_screl;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_and_scacquire
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_and_scacquire::HSA_APITrace_hsa_signal_and_scacquire()
{
}

HSA_APITrace_hsa_signal_and_scacquire::~HSA_APITrace_hsa_signal_and_scacquire()
{
}

std::string HSA_APITrace_hsa_signal_and_scacquire::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_and_scacquire::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_and_scacquire::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_and_scacquire;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_and_relaxed
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_and_relaxed::HSA_APITrace_hsa_signal_and_relaxed()
{
}

HSA_APITrace_hsa_signal_and_relaxed::~HSA_APITrace_hsa_signal_and_relaxed()
{
}

std::string HSA_APITrace_hsa_signal_and_relaxed::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_and_relaxed::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_and_relaxed::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_and_relaxed;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_and_screlease
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_and_screlease::HSA_APITrace_hsa_signal_and_screlease()
{
}

HSA_APITrace_hsa_signal_and_screlease::~HSA_APITrace_hsa_signal_and_screlease()
{
}

std::string HSA_APITrace_hsa_signal_and_screlease::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_and_screlease::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_and_screlease::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_and_screlease;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_or_scacq_screl
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_or_scacq_screl::HSA_APITrace_hsa_signal_or_scacq_screl()
{
}

HSA_APITrace_hsa_signal_or_scacq_screl::~HSA_APITrace_hsa_signal_or_scacq_screl()
{
}

std::string HSA_APITrace_hsa_signal_or_scacq_screl::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_or_scacq_screl::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_or_scacq_screl::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_or_scacq_screl;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_or_scacquire
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_or_scacquire::HSA_APITrace_hsa_signal_or_scacquire()
{
}

HSA_APITrace_hsa_signal_or_scacquire::~HSA_APITrace_hsa_signal_or_scacquire()
{
}

std::string HSA_APITrace_hsa_signal_or_scacquire::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_or_scacquire::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_or_scacquire::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_or_scacquire;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_or_relaxed
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_or_relaxed::HSA_APITrace_hsa_signal_or_relaxed()
{
}

HSA_APITrace_hsa_signal_or_relaxed::~HSA_APITrace_hsa_signal_or_relaxed()
{
}

std::string HSA_APITrace_hsa_signal_or_relaxed::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_or_relaxed::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_or_relaxed::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_or_relaxed;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_or_screlease
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_or_screlease::HSA_APITrace_hsa_signal_or_screlease()
{
}

HSA_APITrace_hsa_signal_or_screlease::~HSA_APITrace_hsa_signal_or_screlease()
{
}

std::string HSA_APITrace_hsa_signal_or_screlease::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_or_screlease::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_or_screlease::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_or_screlease;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_xor_scacq_screl
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_xor_scacq_screl::HSA_APITrace_hsa_signal_xor_scacq_screl()
{
}

HSA_APITrace_hsa_signal_xor_scacq_screl::~HSA_APITrace_hsa_signal_xor_scacq_screl()
{
}

std::string HSA_APITrace_hsa_signal_xor_scacq_screl::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_xor_scacq_screl::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_xor_scacq_screl::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_xor_scacq_screl;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_xor_scacquire
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_xor_scacquire::HSA_APITrace_hsa_signal_xor_scacquire()
{
}

HSA_APITrace_hsa_signal_xor_scacquire::~HSA_APITrace_hsa_signal_xor_scacquire()
{
}

std::string HSA_APITrace_hsa_signal_xor_scacquire::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_xor_scacquire::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_xor_scacquire::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_xor_scacquire;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_xor_relaxed
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_xor_relaxed::HSA_APITrace_hsa_signal_xor_relaxed()
{
}

HSA_APITrace_hsa_signal_xor_relaxed::~HSA_APITrace_hsa_signal_xor_relaxed()
{
}

std::string HSA_APITrace_hsa_signal_xor_relaxed::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_xor_relaxed::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_xor_relaxed::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_xor_relaxed;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_xor_screlease
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_xor_screlease::HSA_APITrace_hsa_signal_xor_screlease()
{
}

HSA_APITrace_hsa_signal_xor_screlease::~HSA_APITrace_hsa_signal_xor_screlease()
{
}

std::string HSA_APITrace_hsa_signal_xor_screlease::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_signal_xor_screlease::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_signal_xor_screlease::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_value_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_xor_screlease;
    m_signal = signal;
    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_wait_scacquire
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_wait_scacquire::HSA_APITrace_hsa_signal_wait_scacquire()
{
}

HSA_APITrace_hsa_signal_wait_scacquire::~HSA_APITrace_hsa_signal_wait_scacquire()
{
}

std::string HSA_APITrace_hsa_signal_wait_scacquire::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_signal_wait_scacquire::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "condition=" << HSATraceStringUtils::Get_hsa_signal_condition_t_String(m_condition) << s_strParamSeparator;
    ss << "compare_value=" << StringUtils::ToString(m_compare_value) << s_strParamSeparator;
    ss << "timeout_hint=" << StringUtils::ToString(m_timeout_hint) << s_strParamSeparator;
    ss << "wait_state_hint=" << HSATraceStringUtils::Get_hsa_wait_state_t_String(m_wait_state_hint);
    return ss.str();
}

void HSA_APITrace_hsa_signal_wait_scacquire::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_condition_t condition,
    hsa_signal_value_t compare_value,
    uint64_t timeout_hint,
    hsa_wait_state_t wait_state_hint,
    hsa_signal_value_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_wait_scacquire;
    m_signal = signal;
    m_condition = condition;
    m_compare_value = compare_value;
    m_timeout_hint = timeout_hint;
    m_wait_state_hint = wait_state_hint;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_wait_relaxed
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_wait_relaxed::HSA_APITrace_hsa_signal_wait_relaxed()
{
}

HSA_APITrace_hsa_signal_wait_relaxed::~HSA_APITrace_hsa_signal_wait_relaxed()
{
}

std::string HSA_APITrace_hsa_signal_wait_relaxed::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_signal_wait_relaxed::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "condition=" << HSATraceStringUtils::Get_hsa_signal_condition_t_String(m_condition) << s_strParamSeparator;
    ss << "compare_value=" << StringUtils::ToString(m_compare_value) << s_strParamSeparator;
    ss << "timeout_hint=" << StringUtils::ToString(m_timeout_hint) << s_strParamSeparator;
    ss << "wait_state_hint=" << HSATraceStringUtils::Get_hsa_wait_state_t_String(m_wait_state_hint);
    return ss.str();
}

void HSA_APITrace_hsa_signal_wait_relaxed::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_condition_t condition,
    hsa_signal_value_t compare_value,
    uint64_t timeout_hint,
    hsa_wait_state_t wait_state_hint,
    hsa_signal_value_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_wait_relaxed;
    m_signal = signal;
    m_condition = condition;
    m_compare_value = compare_value;
    m_timeout_hint = timeout_hint;
    m_wait_state_hint = wait_state_hint;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_group_create
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_group_create::HSA_APITrace_hsa_signal_group_create()
{
}

HSA_APITrace_hsa_signal_group_create::~HSA_APITrace_hsa_signal_group_create()
{
}

std::string HSA_APITrace_hsa_signal_group_create::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_signal_group_create::ToString()
{
    std::ostringstream ss;
    ss << "num_signals=" << StringUtils::ToString(m_num_signals) << s_strParamSeparator;
    ss << "signals=" << HSATraceStringUtils::Get_hsa_signal_t_Ptr_String(m_signals, m_signalsVal) << s_strParamSeparator;
    ss << "num_consumers=" << StringUtils::ToString(m_num_consumers) << s_strParamSeparator;
    ss << "consumers=" << HSATraceStringUtils::Get_hsa_agent_t_Ptr_String(m_consumers, m_consumersVal) << s_strParamSeparator;
    ss << "signal_group=" << HSATraceStringUtils::Get_hsa_signal_group_t_Ptr_String(m_signal_group, m_signal_groupVal);
    return ss.str();
}

void HSA_APITrace_hsa_signal_group_create::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    uint32_t num_signals,
    const hsa_signal_t* signals,
    uint32_t num_consumers,
    const hsa_agent_t* consumers,
    hsa_signal_group_t* signal_group,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_group_create;
    m_num_signals = num_signals;
    m_signals = signals;

    if (nullptr != m_signals)
    {
        m_signalsVal = *m_signals;
    }

    m_num_consumers = num_consumers;
    m_consumers = consumers;

    if (nullptr != m_consumers)
    {
        m_consumersVal = *m_consumers;
    }

    m_signal_group = signal_group;

    if (nullptr != m_signal_group)
    {
        m_signal_groupVal = *m_signal_group;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_group_destroy
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_group_destroy::HSA_APITrace_hsa_signal_group_destroy()
{
}

HSA_APITrace_hsa_signal_group_destroy::~HSA_APITrace_hsa_signal_group_destroy()
{
}

std::string HSA_APITrace_hsa_signal_group_destroy::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_signal_group_destroy::ToString()
{
    std::ostringstream ss;
    ss << "signal_group=" << HSATraceStringUtils::Get_hsa_signal_group_t_String(m_signal_group);
    return ss.str();
}

void HSA_APITrace_hsa_signal_group_destroy::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_group_t signal_group,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_group_destroy;
    m_signal_group = signal_group;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_group_wait_any_scacquire
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_group_wait_any_scacquire::HSA_APITrace_hsa_signal_group_wait_any_scacquire()
{
}

HSA_APITrace_hsa_signal_group_wait_any_scacquire::~HSA_APITrace_hsa_signal_group_wait_any_scacquire()
{
}

std::string HSA_APITrace_hsa_signal_group_wait_any_scacquire::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_signal_group_wait_any_scacquire::ToString()
{
    std::ostringstream ss;
    ss << "signal_group=" << HSATraceStringUtils::Get_hsa_signal_group_t_String(m_signal_group) << s_strParamSeparator;
    ss << "conditions=" << HSATraceStringUtils::Get_hsa_signal_condition_t_Ptr_String(m_conditions, m_conditionsVal) << s_strParamSeparator;
    ss << "compare_values=" << StringUtils::ToStringPtr(m_compare_values, m_compare_valuesVal) << s_strParamSeparator;
    ss << "wait_state_hint=" << HSATraceStringUtils::Get_hsa_wait_state_t_String(m_wait_state_hint) << s_strParamSeparator;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_Ptr_String(m_signal, m_signalVal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToStringPtr(m_value, m_valueVal);
    return ss.str();
}

void HSA_APITrace_hsa_signal_group_wait_any_scacquire::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_group_t signal_group,
    const hsa_signal_condition_t* conditions,
    const hsa_signal_value_t* compare_values,
    hsa_wait_state_t wait_state_hint,
    hsa_signal_t* signal,
    hsa_signal_value_t* value,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_group_wait_any_scacquire;
    m_signal_group = signal_group;
    m_conditions = conditions;

    if (nullptr != m_conditions)
    {
        m_conditionsVal = *m_conditions;
    }

    m_compare_values = compare_values;

    if (nullptr != m_compare_values)
    {
        m_compare_valuesVal = *m_compare_values;
    }

    m_wait_state_hint = wait_state_hint;
    m_signal = signal;

    if (nullptr != m_signal)
    {
        m_signalVal = *m_signal;
    }

    m_value = value;

    if (nullptr != m_value)
    {
        m_valueVal = *m_value;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_signal_group_wait_any_relaxed
///////////////////////////////////////////////////

HSA_APITrace_hsa_signal_group_wait_any_relaxed::HSA_APITrace_hsa_signal_group_wait_any_relaxed()
{
}

HSA_APITrace_hsa_signal_group_wait_any_relaxed::~HSA_APITrace_hsa_signal_group_wait_any_relaxed()
{
}

std::string HSA_APITrace_hsa_signal_group_wait_any_relaxed::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_signal_group_wait_any_relaxed::ToString()
{
    std::ostringstream ss;
    ss << "signal_group=" << HSATraceStringUtils::Get_hsa_signal_group_t_String(m_signal_group) << s_strParamSeparator;
    ss << "conditions=" << HSATraceStringUtils::Get_hsa_signal_condition_t_Ptr_String(m_conditions, m_conditionsVal) << s_strParamSeparator;
    ss << "compare_values=" << StringUtils::ToStringPtr(m_compare_values, m_compare_valuesVal) << s_strParamSeparator;
    ss << "wait_state_hint=" << HSATraceStringUtils::Get_hsa_wait_state_t_String(m_wait_state_hint) << s_strParamSeparator;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_Ptr_String(m_signal, m_signalVal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToStringPtr(m_value, m_valueVal);
    return ss.str();
}

void HSA_APITrace_hsa_signal_group_wait_any_relaxed::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_group_t signal_group,
    const hsa_signal_condition_t* conditions,
    const hsa_signal_value_t* compare_values,
    hsa_wait_state_t wait_state_hint,
    hsa_signal_t* signal,
    hsa_signal_value_t* value,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_signal_group_wait_any_relaxed;
    m_signal_group = signal_group;
    m_conditions = conditions;

    if (nullptr != m_conditions)
    {
        m_conditionsVal = *m_conditions;
    }

    m_compare_values = compare_values;

    if (nullptr != m_compare_values)
    {
        m_compare_valuesVal = *m_compare_values;
    }

    m_wait_state_hint = wait_state_hint;
    m_signal = signal;

    if (nullptr != m_signal)
    {
        m_signalVal = *m_signal;
    }

    m_value = value;

    if (nullptr != m_value)
    {
        m_valueVal = *m_value;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_queue_create
///////////////////////////////////////////////////

HSA_APITrace_hsa_queue_create::HSA_APITrace_hsa_queue_create()
{
}

HSA_APITrace_hsa_queue_create::~HSA_APITrace_hsa_queue_create()
{
}

std::string HSA_APITrace_hsa_queue_create::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_queue_create::ToString()
{
    std::ostringstream ss;
    ss << "agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_agent) << s_strParamSeparator;
    ss << "size=" << StringUtils::ToString(m_size) << s_strParamSeparator;
    ss << "type=" << StringUtils::ToString(m_type_) << s_strParamSeparator;
    ss << "callback=" << StringUtils::ToString(reinterpret_cast<void*>(m_callback)) << s_strParamSeparator;
    ss << "data=" << StringUtils::ToHexString(m_data) << s_strParamSeparator;
    ss << "private_segment_size=" << StringUtils::ToString(m_private_segment_size) << s_strParamSeparator;
    ss << "group_segment_size=" << StringUtils::ToString(m_group_segment_size) << s_strParamSeparator;

    const hsa_queue_t* multiple_indirection_queue_helper = nullptr;

    if (nullptr != m_queue)
    {
        multiple_indirection_queue_helper = &m_queueVal;
    }
    ss << "queue=" << HSATraceStringUtils::SurroundWithDeRef(HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(multiple_indirection_queue_helper, m_queueVal));
    return ss.str();
}

void HSA_APITrace_hsa_queue_create::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_agent_t agent,
    uint32_t size,
    hsa_queue_type32_t type_,
    void (*callback)(hsa_status_t status, hsa_queue_t* source, void* data),
    void* data,
    uint32_t private_segment_size,
    uint32_t group_segment_size,
    hsa_queue_t** queue,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_queue_create;
    m_agent = agent;
    m_size = size;
    m_type_ = type_;
    m_callback = callback;
    m_data = data;
    m_private_segment_size = private_segment_size;
    m_group_segment_size = group_segment_size;
    m_queue = queue;

    if (nullptr != m_queue && nullptr != *m_queue)
    {
        m_queueVal = **m_queue;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_soft_queue_create
///////////////////////////////////////////////////

HSA_APITrace_hsa_soft_queue_create::HSA_APITrace_hsa_soft_queue_create()
{
}

HSA_APITrace_hsa_soft_queue_create::~HSA_APITrace_hsa_soft_queue_create()
{
}

std::string HSA_APITrace_hsa_soft_queue_create::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_soft_queue_create::ToString()
{
    std::ostringstream ss;
    ss << "region=" << HSATraceStringUtils::Get_hsa_region_t_String(m_region) << s_strParamSeparator;
    ss << "size=" << StringUtils::ToString(m_size) << s_strParamSeparator;
    ss << "type=" << StringUtils::ToString(m_type_) << s_strParamSeparator;
    ss << "features=" << StringUtils::ToString(m_features) << s_strParamSeparator;
    ss << "doorbell_signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_doorbell_signal) << s_strParamSeparator;

    const hsa_queue_t* multiple_indirection_queue_helper = nullptr;

    if (nullptr != m_queue)
    {
        multiple_indirection_queue_helper = &m_queueVal;
    }
    ss << "queue=" << HSATraceStringUtils::SurroundWithDeRef(HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(multiple_indirection_queue_helper, m_queueVal));
    return ss.str();
}

void HSA_APITrace_hsa_soft_queue_create::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_region_t region,
    uint32_t size,
    hsa_queue_type32_t type_,
    uint32_t features,
    hsa_signal_t doorbell_signal,
    hsa_queue_t** queue,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_soft_queue_create;
    m_region = region;
    m_size = size;
    m_type_ = type_;
    m_features = features;
    m_doorbell_signal = doorbell_signal;
    m_queue = queue;

    if (nullptr != m_queue && nullptr != *m_queue)
    {
        m_queueVal = **m_queue;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_queue_destroy
///////////////////////////////////////////////////

HSA_APITrace_hsa_queue_destroy::HSA_APITrace_hsa_queue_destroy()
{
}

HSA_APITrace_hsa_queue_destroy::~HSA_APITrace_hsa_queue_destroy()
{
}

std::string HSA_APITrace_hsa_queue_destroy::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_queue_destroy::ToString()
{
    std::ostringstream ss;
    ss << "queue=" << HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(m_queue, m_queueVal);
    return ss.str();
}

void HSA_APITrace_hsa_queue_destroy::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_queue_t* queue,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_queue_destroy;
    m_queue = queue;

    if (nullptr != m_queue)
    {
        m_queueVal = *m_queue;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_queue_inactivate
///////////////////////////////////////////////////

HSA_APITrace_hsa_queue_inactivate::HSA_APITrace_hsa_queue_inactivate()
{
}

HSA_APITrace_hsa_queue_inactivate::~HSA_APITrace_hsa_queue_inactivate()
{
}

std::string HSA_APITrace_hsa_queue_inactivate::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_queue_inactivate::ToString()
{
    std::ostringstream ss;
    ss << "queue=" << HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(m_queue, m_queueVal);
    return ss.str();
}

void HSA_APITrace_hsa_queue_inactivate::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_queue_t* queue,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_queue_inactivate;
    m_queue = queue;

    if (nullptr != m_queue)
    {
        m_queueVal = *m_queue;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_queue_load_read_index_scacquire
///////////////////////////////////////////////////

HSA_APITrace_hsa_queue_load_read_index_scacquire::HSA_APITrace_hsa_queue_load_read_index_scacquire()
{
}

HSA_APITrace_hsa_queue_load_read_index_scacquire::~HSA_APITrace_hsa_queue_load_read_index_scacquire()
{
}

std::string HSA_APITrace_hsa_queue_load_read_index_scacquire::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_queue_load_read_index_scacquire::ToString()
{
    std::ostringstream ss;
    ss << "queue=" << HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(m_queue, m_queueVal);
    return ss.str();
}

void HSA_APITrace_hsa_queue_load_read_index_scacquire::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    const hsa_queue_t* queue,
    uint64_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_queue_load_read_index_scacquire;
    m_queue = queue;

    if (nullptr != m_queue)
    {
        m_queueVal = *m_queue;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_queue_load_read_index_relaxed
///////////////////////////////////////////////////

HSA_APITrace_hsa_queue_load_read_index_relaxed::HSA_APITrace_hsa_queue_load_read_index_relaxed()
{
}

HSA_APITrace_hsa_queue_load_read_index_relaxed::~HSA_APITrace_hsa_queue_load_read_index_relaxed()
{
}

std::string HSA_APITrace_hsa_queue_load_read_index_relaxed::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_queue_load_read_index_relaxed::ToString()
{
    std::ostringstream ss;
    ss << "queue=" << HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(m_queue, m_queueVal);
    return ss.str();
}

void HSA_APITrace_hsa_queue_load_read_index_relaxed::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    const hsa_queue_t* queue,
    uint64_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_queue_load_read_index_relaxed;
    m_queue = queue;

    if (nullptr != m_queue)
    {
        m_queueVal = *m_queue;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_queue_load_write_index_scacquire
///////////////////////////////////////////////////

HSA_APITrace_hsa_queue_load_write_index_scacquire::HSA_APITrace_hsa_queue_load_write_index_scacquire()
{
}

HSA_APITrace_hsa_queue_load_write_index_scacquire::~HSA_APITrace_hsa_queue_load_write_index_scacquire()
{
}

std::string HSA_APITrace_hsa_queue_load_write_index_scacquire::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_queue_load_write_index_scacquire::ToString()
{
    std::ostringstream ss;
    ss << "queue=" << HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(m_queue, m_queueVal);
    return ss.str();
}

void HSA_APITrace_hsa_queue_load_write_index_scacquire::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    const hsa_queue_t* queue,
    uint64_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_queue_load_write_index_scacquire;
    m_queue = queue;

    if (nullptr != m_queue)
    {
        m_queueVal = *m_queue;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_queue_load_write_index_relaxed
///////////////////////////////////////////////////

HSA_APITrace_hsa_queue_load_write_index_relaxed::HSA_APITrace_hsa_queue_load_write_index_relaxed()
{
}

HSA_APITrace_hsa_queue_load_write_index_relaxed::~HSA_APITrace_hsa_queue_load_write_index_relaxed()
{
}

std::string HSA_APITrace_hsa_queue_load_write_index_relaxed::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_queue_load_write_index_relaxed::ToString()
{
    std::ostringstream ss;
    ss << "queue=" << HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(m_queue, m_queueVal);
    return ss.str();
}

void HSA_APITrace_hsa_queue_load_write_index_relaxed::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    const hsa_queue_t* queue,
    uint64_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_queue_load_write_index_relaxed;
    m_queue = queue;

    if (nullptr != m_queue)
    {
        m_queueVal = *m_queue;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_queue_store_write_index_relaxed
///////////////////////////////////////////////////

HSA_APITrace_hsa_queue_store_write_index_relaxed::HSA_APITrace_hsa_queue_store_write_index_relaxed()
{
}

HSA_APITrace_hsa_queue_store_write_index_relaxed::~HSA_APITrace_hsa_queue_store_write_index_relaxed()
{
}

std::string HSA_APITrace_hsa_queue_store_write_index_relaxed::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_queue_store_write_index_relaxed::ToString()
{
    std::ostringstream ss;
    ss << "queue=" << HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(m_queue, m_queueVal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_queue_store_write_index_relaxed::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    const hsa_queue_t* queue,
    uint64_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_queue_store_write_index_relaxed;
    m_queue = queue;

    if (nullptr != m_queue)
    {
        m_queueVal = *m_queue;
    }

    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_queue_store_write_index_screlease
///////////////////////////////////////////////////

HSA_APITrace_hsa_queue_store_write_index_screlease::HSA_APITrace_hsa_queue_store_write_index_screlease()
{
}

HSA_APITrace_hsa_queue_store_write_index_screlease::~HSA_APITrace_hsa_queue_store_write_index_screlease()
{
}

std::string HSA_APITrace_hsa_queue_store_write_index_screlease::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_queue_store_write_index_screlease::ToString()
{
    std::ostringstream ss;
    ss << "queue=" << HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(m_queue, m_queueVal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_queue_store_write_index_screlease::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    const hsa_queue_t* queue,
    uint64_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_queue_store_write_index_screlease;
    m_queue = queue;

    if (nullptr != m_queue)
    {
        m_queueVal = *m_queue;
    }

    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_queue_cas_write_index_scacq_screl
///////////////////////////////////////////////////

HSA_APITrace_hsa_queue_cas_write_index_scacq_screl::HSA_APITrace_hsa_queue_cas_write_index_scacq_screl()
{
}

HSA_APITrace_hsa_queue_cas_write_index_scacq_screl::~HSA_APITrace_hsa_queue_cas_write_index_scacq_screl()
{
}

std::string HSA_APITrace_hsa_queue_cas_write_index_scacq_screl::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_queue_cas_write_index_scacq_screl::ToString()
{
    std::ostringstream ss;
    ss << "queue=" << HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(m_queue, m_queueVal) << s_strParamSeparator;
    ss << "expected=" << StringUtils::ToString(m_expected) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_queue_cas_write_index_scacq_screl::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    const hsa_queue_t* queue,
    uint64_t expected,
    uint64_t value,
    uint64_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_queue_cas_write_index_scacq_screl;
    m_queue = queue;

    if (nullptr != m_queue)
    {
        m_queueVal = *m_queue;
    }

    m_expected = expected;
    m_value = value;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_queue_cas_write_index_scacquire
///////////////////////////////////////////////////

HSA_APITrace_hsa_queue_cas_write_index_scacquire::HSA_APITrace_hsa_queue_cas_write_index_scacquire()
{
}

HSA_APITrace_hsa_queue_cas_write_index_scacquire::~HSA_APITrace_hsa_queue_cas_write_index_scacquire()
{
}

std::string HSA_APITrace_hsa_queue_cas_write_index_scacquire::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_queue_cas_write_index_scacquire::ToString()
{
    std::ostringstream ss;
    ss << "queue=" << HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(m_queue, m_queueVal) << s_strParamSeparator;
    ss << "expected=" << StringUtils::ToString(m_expected) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_queue_cas_write_index_scacquire::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    const hsa_queue_t* queue,
    uint64_t expected,
    uint64_t value,
    uint64_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_queue_cas_write_index_scacquire;
    m_queue = queue;

    if (nullptr != m_queue)
    {
        m_queueVal = *m_queue;
    }

    m_expected = expected;
    m_value = value;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_queue_cas_write_index_relaxed
///////////////////////////////////////////////////

HSA_APITrace_hsa_queue_cas_write_index_relaxed::HSA_APITrace_hsa_queue_cas_write_index_relaxed()
{
}

HSA_APITrace_hsa_queue_cas_write_index_relaxed::~HSA_APITrace_hsa_queue_cas_write_index_relaxed()
{
}

std::string HSA_APITrace_hsa_queue_cas_write_index_relaxed::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_queue_cas_write_index_relaxed::ToString()
{
    std::ostringstream ss;
    ss << "queue=" << HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(m_queue, m_queueVal) << s_strParamSeparator;
    ss << "expected=" << StringUtils::ToString(m_expected) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_queue_cas_write_index_relaxed::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    const hsa_queue_t* queue,
    uint64_t expected,
    uint64_t value,
    uint64_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_queue_cas_write_index_relaxed;
    m_queue = queue;

    if (nullptr != m_queue)
    {
        m_queueVal = *m_queue;
    }

    m_expected = expected;
    m_value = value;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_queue_cas_write_index_screlease
///////////////////////////////////////////////////

HSA_APITrace_hsa_queue_cas_write_index_screlease::HSA_APITrace_hsa_queue_cas_write_index_screlease()
{
}

HSA_APITrace_hsa_queue_cas_write_index_screlease::~HSA_APITrace_hsa_queue_cas_write_index_screlease()
{
}

std::string HSA_APITrace_hsa_queue_cas_write_index_screlease::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_queue_cas_write_index_screlease::ToString()
{
    std::ostringstream ss;
    ss << "queue=" << HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(m_queue, m_queueVal) << s_strParamSeparator;
    ss << "expected=" << StringUtils::ToString(m_expected) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_queue_cas_write_index_screlease::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    const hsa_queue_t* queue,
    uint64_t expected,
    uint64_t value,
    uint64_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_queue_cas_write_index_screlease;
    m_queue = queue;

    if (nullptr != m_queue)
    {
        m_queueVal = *m_queue;
    }

    m_expected = expected;
    m_value = value;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_queue_add_write_index_scacq_screl
///////////////////////////////////////////////////

HSA_APITrace_hsa_queue_add_write_index_scacq_screl::HSA_APITrace_hsa_queue_add_write_index_scacq_screl()
{
}

HSA_APITrace_hsa_queue_add_write_index_scacq_screl::~HSA_APITrace_hsa_queue_add_write_index_scacq_screl()
{
}

std::string HSA_APITrace_hsa_queue_add_write_index_scacq_screl::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_queue_add_write_index_scacq_screl::ToString()
{
    std::ostringstream ss;
    ss << "queue=" << HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(m_queue, m_queueVal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_queue_add_write_index_scacq_screl::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    const hsa_queue_t* queue,
    uint64_t value,
    uint64_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_queue_add_write_index_scacq_screl;
    m_queue = queue;

    if (nullptr != m_queue)
    {
        m_queueVal = *m_queue;
    }

    m_value = value;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_queue_add_write_index_scacquire
///////////////////////////////////////////////////

HSA_APITrace_hsa_queue_add_write_index_scacquire::HSA_APITrace_hsa_queue_add_write_index_scacquire()
{
}

HSA_APITrace_hsa_queue_add_write_index_scacquire::~HSA_APITrace_hsa_queue_add_write_index_scacquire()
{
}

std::string HSA_APITrace_hsa_queue_add_write_index_scacquire::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_queue_add_write_index_scacquire::ToString()
{
    std::ostringstream ss;
    ss << "queue=" << HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(m_queue, m_queueVal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_queue_add_write_index_scacquire::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    const hsa_queue_t* queue,
    uint64_t value,
    uint64_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_queue_add_write_index_scacquire;
    m_queue = queue;

    if (nullptr != m_queue)
    {
        m_queueVal = *m_queue;
    }

    m_value = value;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_queue_add_write_index_relaxed
///////////////////////////////////////////////////

HSA_APITrace_hsa_queue_add_write_index_relaxed::HSA_APITrace_hsa_queue_add_write_index_relaxed()
{
}

HSA_APITrace_hsa_queue_add_write_index_relaxed::~HSA_APITrace_hsa_queue_add_write_index_relaxed()
{
}

std::string HSA_APITrace_hsa_queue_add_write_index_relaxed::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_queue_add_write_index_relaxed::ToString()
{
    std::ostringstream ss;
    ss << "queue=" << HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(m_queue, m_queueVal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_queue_add_write_index_relaxed::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    const hsa_queue_t* queue,
    uint64_t value,
    uint64_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_queue_add_write_index_relaxed;
    m_queue = queue;

    if (nullptr != m_queue)
    {
        m_queueVal = *m_queue;
    }

    m_value = value;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_queue_add_write_index_screlease
///////////////////////////////////////////////////

HSA_APITrace_hsa_queue_add_write_index_screlease::HSA_APITrace_hsa_queue_add_write_index_screlease()
{
}

HSA_APITrace_hsa_queue_add_write_index_screlease::~HSA_APITrace_hsa_queue_add_write_index_screlease()
{
}

std::string HSA_APITrace_hsa_queue_add_write_index_screlease::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_queue_add_write_index_screlease::ToString()
{
    std::ostringstream ss;
    ss << "queue=" << HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(m_queue, m_queueVal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_queue_add_write_index_screlease::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    const hsa_queue_t* queue,
    uint64_t value,
    uint64_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_queue_add_write_index_screlease;
    m_queue = queue;

    if (nullptr != m_queue)
    {
        m_queueVal = *m_queue;
    }

    m_value = value;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_queue_store_read_index_relaxed
///////////////////////////////////////////////////

HSA_APITrace_hsa_queue_store_read_index_relaxed::HSA_APITrace_hsa_queue_store_read_index_relaxed()
{
}

HSA_APITrace_hsa_queue_store_read_index_relaxed::~HSA_APITrace_hsa_queue_store_read_index_relaxed()
{
}

std::string HSA_APITrace_hsa_queue_store_read_index_relaxed::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_queue_store_read_index_relaxed::ToString()
{
    std::ostringstream ss;
    ss << "queue=" << HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(m_queue, m_queueVal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_queue_store_read_index_relaxed::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    const hsa_queue_t* queue,
    uint64_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_queue_store_read_index_relaxed;
    m_queue = queue;

    if (nullptr != m_queue)
    {
        m_queueVal = *m_queue;
    }

    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_queue_store_read_index_screlease
///////////////////////////////////////////////////

HSA_APITrace_hsa_queue_store_read_index_screlease::HSA_APITrace_hsa_queue_store_read_index_screlease()
{
}

HSA_APITrace_hsa_queue_store_read_index_screlease::~HSA_APITrace_hsa_queue_store_read_index_screlease()
{
}

std::string HSA_APITrace_hsa_queue_store_read_index_screlease::GetRetString()
{
    return "";
}

std::string HSA_APITrace_hsa_queue_store_read_index_screlease::ToString()
{
    std::ostringstream ss;
    ss << "queue=" << HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(m_queue, m_queueVal) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_queue_store_read_index_screlease::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    const hsa_queue_t* queue,
    uint64_t value)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_queue_store_read_index_screlease;
    m_queue = queue;

    if (nullptr != m_queue)
    {
        m_queueVal = *m_queue;
    }

    m_value = value;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_region_get_info
///////////////////////////////////////////////////

HSA_APITrace_hsa_region_get_info::HSA_APITrace_hsa_region_get_info() : m_value(nullptr)
{
}

HSA_APITrace_hsa_region_get_info::~HSA_APITrace_hsa_region_get_info()
{
    if (nullptr != m_value)
    {
        FreeBuffer(m_value);
    }
}

std::string HSA_APITrace_hsa_region_get_info::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_region_get_info::ToString()
{
    std::ostringstream ss;
    ss << "region=" << HSATraceStringUtils::Get_hsa_region_t_String(m_region) << s_strParamSeparator;
    ss << "attribute=" << HSATraceStringUtils::Get_hsa_region_info_t_String(m_attribute) << s_strParamSeparator;
    ss << "value=" << HSATraceStringUtils::Get_hsa_region_get_info_AttributeString(m_value, m_attribute, m_retVal);
    return ss.str();
}

void HSA_APITrace_hsa_region_get_info::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_region_t region,
    hsa_region_info_t attribute,
    void* value,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_region_get_info;
    m_region = region;
    m_attribute = attribute;

    if (nullptr != value)
    {
        DeepCopyBuffer(&m_value, value, HSATraceStringUtils::Get_hsa_region_get_info_AttributeSize(m_attribute));
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_agent_iterate_regions
///////////////////////////////////////////////////

HSA_APITrace_hsa_agent_iterate_regions::HSA_APITrace_hsa_agent_iterate_regions()
{
}

HSA_APITrace_hsa_agent_iterate_regions::~HSA_APITrace_hsa_agent_iterate_regions()
{
}

std::string HSA_APITrace_hsa_agent_iterate_regions::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_agent_iterate_regions::ToString()
{
    std::ostringstream ss;
    ss << "agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_agent) << s_strParamSeparator;
    ss << "callback=" << StringUtils::ToString(reinterpret_cast<void*>(m_callback)) << s_strParamSeparator;
    ss << "data=" << StringUtils::ToHexString(m_data);
    return ss.str();
}

void HSA_APITrace_hsa_agent_iterate_regions::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_agent_t agent,
    hsa_status_t (*callback)(hsa_region_t region, void* data),
    void* data,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_agent_iterate_regions;
    m_agent = agent;
    m_callback = callback;
    m_data = data;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_memory_allocate
///////////////////////////////////////////////////

HSA_APITrace_hsa_memory_allocate::HSA_APITrace_hsa_memory_allocate()
{
}

HSA_APITrace_hsa_memory_allocate::~HSA_APITrace_hsa_memory_allocate()
{
}

std::string HSA_APITrace_hsa_memory_allocate::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_memory_allocate::ToString()
{
    std::ostringstream ss;
    ss << "region=" << HSATraceStringUtils::Get_hsa_region_t_String(m_region) << s_strParamSeparator;
    ss << "size=" << StringUtils::ToString(m_size) << s_strParamSeparator;
    ss << "ptr=" << HSATraceStringUtils::SurroundWithDeRef(StringUtils::ToHexString(m_ptrVal));
    return ss.str();
}

void HSA_APITrace_hsa_memory_allocate::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_region_t region,
    size_t size,
    void** ptr,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_memory_allocate;
    m_region = region;
    m_size = size;
    m_ptr = ptr;

    if (nullptr != m_ptr)
    {
        m_ptrVal = reinterpret_cast<uintptr_t>(*m_ptr);
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_memory_free
///////////////////////////////////////////////////

HSA_APITrace_hsa_memory_free::HSA_APITrace_hsa_memory_free()
{
}

HSA_APITrace_hsa_memory_free::~HSA_APITrace_hsa_memory_free()
{
}

std::string HSA_APITrace_hsa_memory_free::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_memory_free::ToString()
{
    std::ostringstream ss;
    ss << "ptr=" << StringUtils::ToHexString(m_ptr);
    return ss.str();
}

void HSA_APITrace_hsa_memory_free::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    void* ptr,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_memory_free;
    m_ptr = ptr;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_memory_copy
///////////////////////////////////////////////////

HSA_APITrace_hsa_memory_copy::HSA_APITrace_hsa_memory_copy()
{
}

HSA_APITrace_hsa_memory_copy::~HSA_APITrace_hsa_memory_copy()
{
}

std::string HSA_APITrace_hsa_memory_copy::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_memory_copy::ToString()
{
    std::ostringstream ss;
    ss << "dst=" << StringUtils::ToHexString(m_dst) << s_strParamSeparator;
    ss << "src=" << StringUtils::ToHexString(m_src) << s_strParamSeparator;
    ss << "size=" << StringUtils::ToString(m_size);
    return ss.str();
}

void HSA_APITrace_hsa_memory_copy::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    void* dst,
    const void* src,
    size_t size,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_memory_copy;
    m_dst = dst;
    m_src = src;
    m_size = size;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_memory_assign_agent
///////////////////////////////////////////////////

HSA_APITrace_hsa_memory_assign_agent::HSA_APITrace_hsa_memory_assign_agent()
{
}

HSA_APITrace_hsa_memory_assign_agent::~HSA_APITrace_hsa_memory_assign_agent()
{
}

std::string HSA_APITrace_hsa_memory_assign_agent::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_memory_assign_agent::ToString()
{
    std::ostringstream ss;
    ss << "ptr=" << StringUtils::ToHexString(m_ptr) << s_strParamSeparator;
    ss << "agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_agent) << s_strParamSeparator;
    ss << "access=" << HSATraceStringUtils::Get_hsa_access_permission_t_String(m_access);
    return ss.str();
}

void HSA_APITrace_hsa_memory_assign_agent::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    void* ptr,
    hsa_agent_t agent,
    hsa_access_permission_t access,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_memory_assign_agent;
    m_ptr = ptr;
    m_agent = agent;
    m_access = access;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_memory_register
///////////////////////////////////////////////////

HSA_APITrace_hsa_memory_register::HSA_APITrace_hsa_memory_register()
{
}

HSA_APITrace_hsa_memory_register::~HSA_APITrace_hsa_memory_register()
{
}

std::string HSA_APITrace_hsa_memory_register::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_memory_register::ToString()
{
    std::ostringstream ss;
    ss << "ptr=" << StringUtils::ToHexString(m_ptr) << s_strParamSeparator;
    ss << "size=" << StringUtils::ToString(m_size);
    return ss.str();
}

void HSA_APITrace_hsa_memory_register::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    void* ptr,
    size_t size,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_memory_register;
    m_ptr = ptr;
    m_size = size;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_memory_deregister
///////////////////////////////////////////////////

HSA_APITrace_hsa_memory_deregister::HSA_APITrace_hsa_memory_deregister()
{
}

HSA_APITrace_hsa_memory_deregister::~HSA_APITrace_hsa_memory_deregister()
{
}

std::string HSA_APITrace_hsa_memory_deregister::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_memory_deregister::ToString()
{
    std::ostringstream ss;
    ss << "ptr=" << StringUtils::ToHexString(m_ptr) << s_strParamSeparator;
    ss << "size=" << StringUtils::ToString(m_size);
    return ss.str();
}

void HSA_APITrace_hsa_memory_deregister::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    void* ptr,
    size_t size,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_memory_deregister;
    m_ptr = ptr;
    m_size = size;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_isa_from_name
///////////////////////////////////////////////////

HSA_APITrace_hsa_isa_from_name::HSA_APITrace_hsa_isa_from_name()
{
}

HSA_APITrace_hsa_isa_from_name::~HSA_APITrace_hsa_isa_from_name()
{
}

std::string HSA_APITrace_hsa_isa_from_name::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_isa_from_name::ToString()
{
    std::ostringstream ss;
    ss << "name=" << HSATraceStringUtils::GetStringString(m_name, m_nameVal) << s_strParamSeparator;
    ss << "isa=" << HSATraceStringUtils::Get_hsa_isa_t_Ptr_String(m_isa, m_isaVal);
    return ss.str();
}

void HSA_APITrace_hsa_isa_from_name::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    const char* name,
    hsa_isa_t* isa,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_isa_from_name;
    m_name = name;

    if (nullptr != m_name)
    {
        m_nameVal = std::string(m_name);
    }
    else
    {
        m_nameVal = "";
    }

    m_isa = isa;

    if (nullptr != m_isa)
    {
        m_isaVal = *m_isa;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_agent_iterate_isas
///////////////////////////////////////////////////

HSA_APITrace_hsa_agent_iterate_isas::HSA_APITrace_hsa_agent_iterate_isas()
{
}

HSA_APITrace_hsa_agent_iterate_isas::~HSA_APITrace_hsa_agent_iterate_isas()
{
}

std::string HSA_APITrace_hsa_agent_iterate_isas::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_agent_iterate_isas::ToString()
{
    std::ostringstream ss;
    ss << "agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_agent) << s_strParamSeparator;
    ss << "callback=" << StringUtils::ToString(reinterpret_cast<void*>(m_callback)) << s_strParamSeparator;
    ss << "data=" << StringUtils::ToHexString(m_data);
    return ss.str();
}

void HSA_APITrace_hsa_agent_iterate_isas::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_agent_t agent,
    hsa_status_t (*callback)(hsa_isa_t isa, void* data),
    void* data,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_agent_iterate_isas;
    m_agent = agent;
    m_callback = callback;
    m_data = data;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_isa_get_info
///////////////////////////////////////////////////

HSA_APITrace_hsa_isa_get_info::HSA_APITrace_hsa_isa_get_info() : m_value(nullptr)
{
}

HSA_APITrace_hsa_isa_get_info::~HSA_APITrace_hsa_isa_get_info()
{
    if (nullptr != m_value)
    {
        FreeBuffer(m_value);
    }
}

std::string HSA_APITrace_hsa_isa_get_info::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_isa_get_info::ToString()
{
    std::ostringstream ss;
    ss << "isa=" << HSATraceStringUtils::Get_hsa_isa_t_String(m_isa) << s_strParamSeparator;
    ss << "attribute=" << HSATraceStringUtils::Get_hsa_isa_info_t_String(m_attribute) << s_strParamSeparator;
    ss << "index=" << StringUtils::ToString(m_index) << s_strParamSeparator;
    ss << "value=" << HSATraceStringUtils::Get_hsa_isa_get_info_AttributeString(m_value, m_attribute, m_retVal);
    return ss.str();
}

void HSA_APITrace_hsa_isa_get_info::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_isa_t isa,
    hsa_isa_info_t attribute,
    uint32_t index,
    void* value,
    uint32_t valueLength,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_isa_get_info;
    m_isa = isa;
    m_attribute = attribute;
    m_index = index;

    if (nullptr != value)
    {
        DeepCopyBuffer(&m_value, value, valueLength);
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_isa_get_info_alt
///////////////////////////////////////////////////

HSA_APITrace_hsa_isa_get_info_alt::HSA_APITrace_hsa_isa_get_info_alt()
{
}

HSA_APITrace_hsa_isa_get_info_alt::~HSA_APITrace_hsa_isa_get_info_alt()
{
}

std::string HSA_APITrace_hsa_isa_get_info_alt::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_isa_get_info_alt::ToString()
{
    std::ostringstream ss;
    ss << "isa=" << HSATraceStringUtils::Get_hsa_isa_t_String(m_isa) << s_strParamSeparator;
    ss << "attribute=" << HSATraceStringUtils::Get_hsa_isa_info_t_String(m_attribute) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToHexString(m_value);
    return ss.str();
}

void HSA_APITrace_hsa_isa_get_info_alt::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_isa_t isa,
    hsa_isa_info_t attribute,
    void* value,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_isa_get_info_alt;
    m_isa = isa;
    m_attribute = attribute;
    m_value = value;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_isa_get_exception_policies
///////////////////////////////////////////////////

HSA_APITrace_hsa_isa_get_exception_policies::HSA_APITrace_hsa_isa_get_exception_policies()
{
}

HSA_APITrace_hsa_isa_get_exception_policies::~HSA_APITrace_hsa_isa_get_exception_policies()
{
}

std::string HSA_APITrace_hsa_isa_get_exception_policies::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_isa_get_exception_policies::ToString()
{
    std::ostringstream ss;
    ss << "isa=" << HSATraceStringUtils::Get_hsa_isa_t_String(m_isa) << s_strParamSeparator;
    ss << "profile=" << HSATraceStringUtils::Get_hsa_profile_t_String(m_profile) << s_strParamSeparator;
    ss << "mask=" << StringUtils::ToStringPtr(m_mask, m_maskVal);
    return ss.str();
}

void HSA_APITrace_hsa_isa_get_exception_policies::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_isa_t isa,
    hsa_profile_t profile,
    uint16_t* mask,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_isa_get_exception_policies;
    m_isa = isa;
    m_profile = profile;
    m_mask = mask;

    if (nullptr != m_mask)
    {
        m_maskVal = *m_mask;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_isa_get_round_method
///////////////////////////////////////////////////

HSA_APITrace_hsa_isa_get_round_method::HSA_APITrace_hsa_isa_get_round_method()
{
}

HSA_APITrace_hsa_isa_get_round_method::~HSA_APITrace_hsa_isa_get_round_method()
{
}

std::string HSA_APITrace_hsa_isa_get_round_method::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_isa_get_round_method::ToString()
{
    std::ostringstream ss;
    ss << "isa=" << HSATraceStringUtils::Get_hsa_isa_t_String(m_isa) << s_strParamSeparator;
    ss << "fp_type=" << HSATraceStringUtils::Get_hsa_fp_type_t_String(m_fp_type) << s_strParamSeparator;
    ss << "flush_mode=" << HSATraceStringUtils::Get_hsa_flush_mode_t_String(m_flush_mode) << s_strParamSeparator;
    ss << "round_method=" << HSATraceStringUtils::Get_hsa_round_method_t_Ptr_String(m_round_method, m_round_methodVal);
    return ss.str();
}

void HSA_APITrace_hsa_isa_get_round_method::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_isa_t isa,
    hsa_fp_type_t fp_type,
    hsa_flush_mode_t flush_mode,
    hsa_round_method_t* round_method,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_isa_get_round_method;
    m_isa = isa;
    m_fp_type = fp_type;
    m_flush_mode = flush_mode;
    m_round_method = round_method;

    if (nullptr != m_round_method)
    {
        m_round_methodVal = *m_round_method;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_wavefront_get_info
///////////////////////////////////////////////////

HSA_APITrace_hsa_wavefront_get_info::HSA_APITrace_hsa_wavefront_get_info() : m_value(nullptr)
{
}

HSA_APITrace_hsa_wavefront_get_info::~HSA_APITrace_hsa_wavefront_get_info()
{
    if (nullptr != m_value)
    {
        FreeBuffer(m_value);
    }
}

std::string HSA_APITrace_hsa_wavefront_get_info::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_wavefront_get_info::ToString()
{
    std::ostringstream ss;
    ss << "wavefront=" << HSATraceStringUtils::Get_hsa_wavefront_t_String(m_wavefront) << s_strParamSeparator;
    ss << "attribute=" << HSATraceStringUtils::Get_hsa_wavefront_info_t_String(m_attribute) << s_strParamSeparator;
    ss << "value=" << HSATraceStringUtils::Get_hsa_wavefront_get_info_AttributeString(m_value, m_attribute, m_retVal);
    return ss.str();
}

void HSA_APITrace_hsa_wavefront_get_info::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_wavefront_t wavefront,
    hsa_wavefront_info_t attribute,
    void* value,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_wavefront_get_info;
    m_wavefront = wavefront;
    m_attribute = attribute;

    if (nullptr != value)
    {
        DeepCopyBuffer(&m_value, value, HSATraceStringUtils::Get_hsa_wavefront_get_info_AttributeSize(m_attribute));
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_isa_iterate_wavefronts
///////////////////////////////////////////////////

HSA_APITrace_hsa_isa_iterate_wavefronts::HSA_APITrace_hsa_isa_iterate_wavefronts()
{
}

HSA_APITrace_hsa_isa_iterate_wavefronts::~HSA_APITrace_hsa_isa_iterate_wavefronts()
{
}

std::string HSA_APITrace_hsa_isa_iterate_wavefronts::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_isa_iterate_wavefronts::ToString()
{
    std::ostringstream ss;
    ss << "isa=" << HSATraceStringUtils::Get_hsa_isa_t_String(m_isa) << s_strParamSeparator;
    ss << "callback=" << StringUtils::ToString(reinterpret_cast<void*>(m_callback)) << s_strParamSeparator;
    ss << "data=" << StringUtils::ToHexString(m_data);
    return ss.str();
}

void HSA_APITrace_hsa_isa_iterate_wavefronts::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_isa_t isa,
    hsa_status_t (*callback)(hsa_wavefront_t wavefront, void* data),
    void* data,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_isa_iterate_wavefronts;
    m_isa = isa;
    m_callback = callback;
    m_data = data;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_isa_compatible
///////////////////////////////////////////////////

HSA_APITrace_hsa_isa_compatible::HSA_APITrace_hsa_isa_compatible()
{
}

HSA_APITrace_hsa_isa_compatible::~HSA_APITrace_hsa_isa_compatible()
{
}

std::string HSA_APITrace_hsa_isa_compatible::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_isa_compatible::ToString()
{
    std::ostringstream ss;
    ss << "code_object_isa=" << HSATraceStringUtils::Get_hsa_isa_t_String(m_code_object_isa) << s_strParamSeparator;
    ss << "agent_isa=" << HSATraceStringUtils::Get_hsa_isa_t_String(m_agent_isa) << s_strParamSeparator;
    ss << "result=" << StringUtils::ToStringPtr(m_result, m_resultVal);
    return ss.str();
}

void HSA_APITrace_hsa_isa_compatible::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_isa_t code_object_isa,
    hsa_isa_t agent_isa,
    bool* result,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_isa_compatible;
    m_code_object_isa = code_object_isa;
    m_agent_isa = agent_isa;
    m_result = result;

    if (nullptr != m_result)
    {
        m_resultVal = *m_result;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_code_object_reader_create_from_file
///////////////////////////////////////////////////

HSA_APITrace_hsa_code_object_reader_create_from_file::HSA_APITrace_hsa_code_object_reader_create_from_file()
{
}

HSA_APITrace_hsa_code_object_reader_create_from_file::~HSA_APITrace_hsa_code_object_reader_create_from_file()
{
}

std::string HSA_APITrace_hsa_code_object_reader_create_from_file::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_code_object_reader_create_from_file::ToString()
{
    std::ostringstream ss;
    ss << "file=" << StringUtils::ToString(m_file) << s_strParamSeparator;
    ss << "code_object_reader=" << HSATraceStringUtils::Get_hsa_code_object_reader_t_Ptr_String(m_code_object_reader, m_code_object_readerVal);
    return ss.str();
}

void HSA_APITrace_hsa_code_object_reader_create_from_file::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_file_t file,
    hsa_code_object_reader_t* code_object_reader,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_code_object_reader_create_from_file;
    m_file = file;
    m_code_object_reader = code_object_reader;

    if (nullptr != m_code_object_reader)
    {
        m_code_object_readerVal = *m_code_object_reader;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_code_object_reader_create_from_memory
///////////////////////////////////////////////////

HSA_APITrace_hsa_code_object_reader_create_from_memory::HSA_APITrace_hsa_code_object_reader_create_from_memory()
{
}

HSA_APITrace_hsa_code_object_reader_create_from_memory::~HSA_APITrace_hsa_code_object_reader_create_from_memory()
{
}

std::string HSA_APITrace_hsa_code_object_reader_create_from_memory::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_code_object_reader_create_from_memory::ToString()
{
    std::ostringstream ss;
    ss << "code_object=" << StringUtils::ToHexString(m_code_object) << s_strParamSeparator;
    ss << "size=" << StringUtils::ToString(m_size) << s_strParamSeparator;
    ss << "code_object_reader=" << HSATraceStringUtils::Get_hsa_code_object_reader_t_Ptr_String(m_code_object_reader, m_code_object_readerVal);
    return ss.str();
}

void HSA_APITrace_hsa_code_object_reader_create_from_memory::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    const void* code_object,
    size_t size,
    hsa_code_object_reader_t* code_object_reader,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_code_object_reader_create_from_memory;
    m_code_object = code_object;
    m_size = size;
    m_code_object_reader = code_object_reader;

    if (nullptr != m_code_object_reader)
    {
        m_code_object_readerVal = *m_code_object_reader;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_code_object_reader_destroy
///////////////////////////////////////////////////

HSA_APITrace_hsa_code_object_reader_destroy::HSA_APITrace_hsa_code_object_reader_destroy()
{
}

HSA_APITrace_hsa_code_object_reader_destroy::~HSA_APITrace_hsa_code_object_reader_destroy()
{
}

std::string HSA_APITrace_hsa_code_object_reader_destroy::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_code_object_reader_destroy::ToString()
{
    std::ostringstream ss;
    ss << "code_object_reader=" << HSATraceStringUtils::Get_hsa_code_object_reader_t_String(m_code_object_reader);
    return ss.str();
}

void HSA_APITrace_hsa_code_object_reader_destroy::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_code_object_reader_t code_object_reader,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_code_object_reader_destroy;
    m_code_object_reader = code_object_reader;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_executable_create
///////////////////////////////////////////////////

HSA_APITrace_hsa_executable_create::HSA_APITrace_hsa_executable_create()
{
}

HSA_APITrace_hsa_executable_create::~HSA_APITrace_hsa_executable_create()
{
}

std::string HSA_APITrace_hsa_executable_create::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_executable_create::ToString()
{
    std::ostringstream ss;
    ss << "profile=" << HSATraceStringUtils::Get_hsa_profile_t_String(m_profile) << s_strParamSeparator;
    ss << "executable_state=" << HSATraceStringUtils::Get_hsa_executable_state_t_String(m_executable_state) << s_strParamSeparator;
    ss << "options=" << HSATraceStringUtils::GetStringString(m_options, m_optionsVal) << s_strParamSeparator;
    ss << "executable=" << HSATraceStringUtils::Get_hsa_executable_t_Ptr_String(m_executable, m_executableVal);
    return ss.str();
}

void HSA_APITrace_hsa_executable_create::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_profile_t profile,
    hsa_executable_state_t executable_state,
    const char* options,
    hsa_executable_t* executable,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_executable_create;
    m_profile = profile;
    m_executable_state = executable_state;
    m_options = options;

    if (nullptr != m_options)
    {
        m_optionsVal = std::string(m_options);
    }
    else
    {
        m_optionsVal = "";
    }

    m_executable = executable;

    if (nullptr != m_executable)
    {
        m_executableVal = *m_executable;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_executable_create_alt
///////////////////////////////////////////////////

HSA_APITrace_hsa_executable_create_alt::HSA_APITrace_hsa_executable_create_alt()
{
}

HSA_APITrace_hsa_executable_create_alt::~HSA_APITrace_hsa_executable_create_alt()
{
}

std::string HSA_APITrace_hsa_executable_create_alt::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_executable_create_alt::ToString()
{
    std::ostringstream ss;
    ss << "profile=" << HSATraceStringUtils::Get_hsa_profile_t_String(m_profile) << s_strParamSeparator;
    ss << "default_float_rounding_mode=" << HSATraceStringUtils::Get_hsa_default_float_rounding_mode_t_String(m_default_float_rounding_mode) << s_strParamSeparator;
    ss << "options=" << HSATraceStringUtils::GetStringString(m_options, m_optionsVal) << s_strParamSeparator;
    ss << "executable=" << HSATraceStringUtils::Get_hsa_executable_t_Ptr_String(m_executable, m_executableVal);
    return ss.str();
}

void HSA_APITrace_hsa_executable_create_alt::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_profile_t profile,
    hsa_default_float_rounding_mode_t default_float_rounding_mode,
    const char* options,
    hsa_executable_t* executable,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_executable_create_alt;
    m_profile = profile;
    m_default_float_rounding_mode = default_float_rounding_mode;
    m_options = options;

    if (nullptr != m_options)
    {
        m_optionsVal = std::string(m_options);
    }
    else
    {
        m_optionsVal = "";
    }

    m_executable = executable;

    if (nullptr != m_executable)
    {
        m_executableVal = *m_executable;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_executable_destroy
///////////////////////////////////////////////////

HSA_APITrace_hsa_executable_destroy::HSA_APITrace_hsa_executable_destroy()
{
}

HSA_APITrace_hsa_executable_destroy::~HSA_APITrace_hsa_executable_destroy()
{
}

std::string HSA_APITrace_hsa_executable_destroy::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_executable_destroy::ToString()
{
    std::ostringstream ss;
    ss << "executable=" << HSATraceStringUtils::Get_hsa_executable_t_String(m_executable);
    return ss.str();
}

void HSA_APITrace_hsa_executable_destroy::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_executable_t executable,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_executable_destroy;
    m_executable = executable;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_executable_load_program_code_object
///////////////////////////////////////////////////

HSA_APITrace_hsa_executable_load_program_code_object::HSA_APITrace_hsa_executable_load_program_code_object()
{
}

HSA_APITrace_hsa_executable_load_program_code_object::~HSA_APITrace_hsa_executable_load_program_code_object()
{
}

std::string HSA_APITrace_hsa_executable_load_program_code_object::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_executable_load_program_code_object::ToString()
{
    std::ostringstream ss;
    ss << "executable=" << HSATraceStringUtils::Get_hsa_executable_t_String(m_executable) << s_strParamSeparator;
    ss << "code_object_reader=" << HSATraceStringUtils::Get_hsa_code_object_reader_t_String(m_code_object_reader) << s_strParamSeparator;
    ss << "options=" << HSATraceStringUtils::GetStringString(m_options, m_optionsVal) << s_strParamSeparator;
    ss << "loaded_code_object=" << HSATraceStringUtils::Get_hsa_loaded_code_object_t_Ptr_String(m_loaded_code_object, m_loaded_code_objectVal);
    return ss.str();
}

void HSA_APITrace_hsa_executable_load_program_code_object::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_executable_t executable,
    hsa_code_object_reader_t code_object_reader,
    const char* options,
    hsa_loaded_code_object_t* loaded_code_object,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_executable_load_program_code_object;
    m_executable = executable;
    m_code_object_reader = code_object_reader;
    m_options = options;

    if (nullptr != m_options)
    {
        m_optionsVal = std::string(m_options);
    }
    else
    {
        m_optionsVal = "";
    }

    m_loaded_code_object = loaded_code_object;

    if (nullptr != m_loaded_code_object)
    {
        m_loaded_code_objectVal = *m_loaded_code_object;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_executable_load_agent_code_object
///////////////////////////////////////////////////

HSA_APITrace_hsa_executable_load_agent_code_object::HSA_APITrace_hsa_executable_load_agent_code_object()
{
}

HSA_APITrace_hsa_executable_load_agent_code_object::~HSA_APITrace_hsa_executable_load_agent_code_object()
{
}

std::string HSA_APITrace_hsa_executable_load_agent_code_object::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_executable_load_agent_code_object::ToString()
{
    std::ostringstream ss;
    ss << "executable=" << HSATraceStringUtils::Get_hsa_executable_t_String(m_executable) << s_strParamSeparator;
    ss << "agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_agent) << s_strParamSeparator;
    ss << "code_object_reader=" << HSATraceStringUtils::Get_hsa_code_object_reader_t_String(m_code_object_reader) << s_strParamSeparator;
    ss << "options=" << HSATraceStringUtils::GetStringString(m_options, m_optionsVal) << s_strParamSeparator;
    ss << "loaded_code_object=" << HSATraceStringUtils::Get_hsa_loaded_code_object_t_Ptr_String(m_loaded_code_object, m_loaded_code_objectVal);
    return ss.str();
}

void HSA_APITrace_hsa_executable_load_agent_code_object::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_executable_t executable,
    hsa_agent_t agent,
    hsa_code_object_reader_t code_object_reader,
    const char* options,
    hsa_loaded_code_object_t* loaded_code_object,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_executable_load_agent_code_object;
    m_executable = executable;
    m_agent = agent;
    m_code_object_reader = code_object_reader;
    m_options = options;

    if (nullptr != m_options)
    {
        m_optionsVal = std::string(m_options);
    }
    else
    {
        m_optionsVal = "";
    }

    m_loaded_code_object = loaded_code_object;

    if (nullptr != m_loaded_code_object)
    {
        m_loaded_code_objectVal = *m_loaded_code_object;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_executable_freeze
///////////////////////////////////////////////////

HSA_APITrace_hsa_executable_freeze::HSA_APITrace_hsa_executable_freeze()
{
}

HSA_APITrace_hsa_executable_freeze::~HSA_APITrace_hsa_executable_freeze()
{
}

std::string HSA_APITrace_hsa_executable_freeze::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_executable_freeze::ToString()
{
    std::ostringstream ss;
    ss << "executable=" << HSATraceStringUtils::Get_hsa_executable_t_String(m_executable) << s_strParamSeparator;
    ss << "options=" << HSATraceStringUtils::GetStringString(m_options, m_optionsVal);
    return ss.str();
}

void HSA_APITrace_hsa_executable_freeze::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_executable_t executable,
    const char* options,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_executable_freeze;
    m_executable = executable;
    m_options = options;

    if (nullptr != m_options)
    {
        m_optionsVal = std::string(m_options);
    }
    else
    {
        m_optionsVal = "";
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_executable_get_info
///////////////////////////////////////////////////

HSA_APITrace_hsa_executable_get_info::HSA_APITrace_hsa_executable_get_info() : m_value(nullptr)
{
}

HSA_APITrace_hsa_executable_get_info::~HSA_APITrace_hsa_executable_get_info()
{
    if (nullptr != m_value)
    {
        FreeBuffer(m_value);
    }
}

std::string HSA_APITrace_hsa_executable_get_info::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_executable_get_info::ToString()
{
    std::ostringstream ss;
    ss << "executable=" << HSATraceStringUtils::Get_hsa_executable_t_String(m_executable) << s_strParamSeparator;
    ss << "attribute=" << HSATraceStringUtils::Get_hsa_executable_info_t_String(m_attribute) << s_strParamSeparator;
    ss << "value=" << HSATraceStringUtils::Get_hsa_executable_get_info_AttributeString(m_value, m_attribute, m_retVal);
    return ss.str();
}

void HSA_APITrace_hsa_executable_get_info::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_executable_t executable,
    hsa_executable_info_t attribute,
    void* value,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_executable_get_info;
    m_executable = executable;
    m_attribute = attribute;

    if (nullptr != value)
    {
        DeepCopyBuffer(&m_value, value, HSATraceStringUtils::Get_hsa_executable_get_info_AttributeSize(m_attribute));
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_executable_global_variable_define
///////////////////////////////////////////////////

HSA_APITrace_hsa_executable_global_variable_define::HSA_APITrace_hsa_executable_global_variable_define()
{
}

HSA_APITrace_hsa_executable_global_variable_define::~HSA_APITrace_hsa_executable_global_variable_define()
{
}

std::string HSA_APITrace_hsa_executable_global_variable_define::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_executable_global_variable_define::ToString()
{
    std::ostringstream ss;
    ss << "executable=" << HSATraceStringUtils::Get_hsa_executable_t_String(m_executable) << s_strParamSeparator;
    ss << "variable_name=" << HSATraceStringUtils::GetStringString(m_variable_name, m_variable_nameVal) << s_strParamSeparator;
    ss << "address=" << StringUtils::ToHexString(m_address);
    return ss.str();
}

void HSA_APITrace_hsa_executable_global_variable_define::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_executable_t executable,
    const char* variable_name,
    void* address,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_executable_global_variable_define;
    m_executable = executable;
    m_variable_name = variable_name;

    if (nullptr != m_variable_name)
    {
        m_variable_nameVal = std::string(m_variable_name);
    }
    else
    {
        m_variable_nameVal = "";
    }

    m_address = address;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_executable_agent_global_variable_define
///////////////////////////////////////////////////

HSA_APITrace_hsa_executable_agent_global_variable_define::HSA_APITrace_hsa_executable_agent_global_variable_define()
{
}

HSA_APITrace_hsa_executable_agent_global_variable_define::~HSA_APITrace_hsa_executable_agent_global_variable_define()
{
}

std::string HSA_APITrace_hsa_executable_agent_global_variable_define::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_executable_agent_global_variable_define::ToString()
{
    std::ostringstream ss;
    ss << "executable=" << HSATraceStringUtils::Get_hsa_executable_t_String(m_executable) << s_strParamSeparator;
    ss << "agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_agent) << s_strParamSeparator;
    ss << "variable_name=" << HSATraceStringUtils::GetStringString(m_variable_name, m_variable_nameVal) << s_strParamSeparator;
    ss << "address=" << StringUtils::ToHexString(m_address);
    return ss.str();
}

void HSA_APITrace_hsa_executable_agent_global_variable_define::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_executable_t executable,
    hsa_agent_t agent,
    const char* variable_name,
    void* address,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_executable_agent_global_variable_define;
    m_executable = executable;
    m_agent = agent;
    m_variable_name = variable_name;

    if (nullptr != m_variable_name)
    {
        m_variable_nameVal = std::string(m_variable_name);
    }
    else
    {
        m_variable_nameVal = "";
    }

    m_address = address;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_executable_readonly_variable_define
///////////////////////////////////////////////////

HSA_APITrace_hsa_executable_readonly_variable_define::HSA_APITrace_hsa_executable_readonly_variable_define()
{
}

HSA_APITrace_hsa_executable_readonly_variable_define::~HSA_APITrace_hsa_executable_readonly_variable_define()
{
}

std::string HSA_APITrace_hsa_executable_readonly_variable_define::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_executable_readonly_variable_define::ToString()
{
    std::ostringstream ss;
    ss << "executable=" << HSATraceStringUtils::Get_hsa_executable_t_String(m_executable) << s_strParamSeparator;
    ss << "agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_agent) << s_strParamSeparator;
    ss << "variable_name=" << HSATraceStringUtils::GetStringString(m_variable_name, m_variable_nameVal) << s_strParamSeparator;
    ss << "address=" << StringUtils::ToHexString(m_address);
    return ss.str();
}

void HSA_APITrace_hsa_executable_readonly_variable_define::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_executable_t executable,
    hsa_agent_t agent,
    const char* variable_name,
    void* address,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_executable_readonly_variable_define;
    m_executable = executable;
    m_agent = agent;
    m_variable_name = variable_name;

    if (nullptr != m_variable_name)
    {
        m_variable_nameVal = std::string(m_variable_name);
    }
    else
    {
        m_variable_nameVal = "";
    }

    m_address = address;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_executable_validate
///////////////////////////////////////////////////

HSA_APITrace_hsa_executable_validate::HSA_APITrace_hsa_executable_validate()
{
}

HSA_APITrace_hsa_executable_validate::~HSA_APITrace_hsa_executable_validate()
{
}

std::string HSA_APITrace_hsa_executable_validate::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_executable_validate::ToString()
{
    std::ostringstream ss;
    ss << "executable=" << HSATraceStringUtils::Get_hsa_executable_t_String(m_executable) << s_strParamSeparator;
    ss << "result=" << StringUtils::ToStringPtr(m_result, m_resultVal);
    return ss.str();
}

void HSA_APITrace_hsa_executable_validate::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_executable_t executable,
    uint32_t* result,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_executable_validate;
    m_executable = executable;
    m_result = result;

    if (nullptr != m_result)
    {
        m_resultVal = *m_result;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_executable_validate_alt
///////////////////////////////////////////////////

HSA_APITrace_hsa_executable_validate_alt::HSA_APITrace_hsa_executable_validate_alt()
{
}

HSA_APITrace_hsa_executable_validate_alt::~HSA_APITrace_hsa_executable_validate_alt()
{
}

std::string HSA_APITrace_hsa_executable_validate_alt::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_executable_validate_alt::ToString()
{
    std::ostringstream ss;
    ss << "executable=" << HSATraceStringUtils::Get_hsa_executable_t_String(m_executable) << s_strParamSeparator;
    ss << "options=" << HSATraceStringUtils::GetStringString(m_options, m_optionsVal) << s_strParamSeparator;
    ss << "result=" << StringUtils::ToStringPtr(m_result, m_resultVal);
    return ss.str();
}

void HSA_APITrace_hsa_executable_validate_alt::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_executable_t executable,
    const char* options,
    uint32_t* result,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_executable_validate_alt;
    m_executable = executable;
    m_options = options;

    if (nullptr != m_options)
    {
        m_optionsVal = std::string(m_options);
    }
    else
    {
        m_optionsVal = "";
    }

    m_result = result;

    if (nullptr != m_result)
    {
        m_resultVal = *m_result;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_executable_get_symbol
///////////////////////////////////////////////////

HSA_APITrace_hsa_executable_get_symbol::HSA_APITrace_hsa_executable_get_symbol()
{
}

HSA_APITrace_hsa_executable_get_symbol::~HSA_APITrace_hsa_executable_get_symbol()
{
}

std::string HSA_APITrace_hsa_executable_get_symbol::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_executable_get_symbol::ToString()
{
    std::ostringstream ss;
    ss << "executable=" << HSATraceStringUtils::Get_hsa_executable_t_String(m_executable) << s_strParamSeparator;
    ss << "module_name=" << HSATraceStringUtils::GetStringString(m_module_name, m_module_nameVal) << s_strParamSeparator;
    ss << "symbol_name=" << HSATraceStringUtils::GetStringString(m_symbol_name, m_symbol_nameVal) << s_strParamSeparator;
    ss << "agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_agent) << s_strParamSeparator;
    ss << "call_convention=" << StringUtils::ToString(m_call_convention) << s_strParamSeparator;
    ss << "symbol=" << HSATraceStringUtils::Get_hsa_executable_symbol_t_Ptr_String(m_symbol, m_symbolVal);
    return ss.str();
}

void HSA_APITrace_hsa_executable_get_symbol::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_executable_t executable,
    const char* module_name,
    const char* symbol_name,
    hsa_agent_t agent,
    int32_t call_convention,
    hsa_executable_symbol_t* symbol,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_executable_get_symbol;
    m_executable = executable;
    m_module_name = module_name;

    if (nullptr != m_module_name)
    {
        m_module_nameVal = std::string(m_module_name);
    }
    else
    {
        m_module_nameVal = "";
    }

    m_symbol_name = symbol_name;

    if (nullptr != m_symbol_name)
    {
        m_symbol_nameVal = std::string(m_symbol_name);
    }
    else
    {
        m_symbol_nameVal = "";
    }

    m_agent = agent;
    m_call_convention = call_convention;
    m_symbol = symbol;

    if (nullptr != m_symbol)
    {
        m_symbolVal = *m_symbol;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_executable_get_symbol_by_name
///////////////////////////////////////////////////

HSA_APITrace_hsa_executable_get_symbol_by_name::HSA_APITrace_hsa_executable_get_symbol_by_name()
{
}

HSA_APITrace_hsa_executable_get_symbol_by_name::~HSA_APITrace_hsa_executable_get_symbol_by_name()
{
}

std::string HSA_APITrace_hsa_executable_get_symbol_by_name::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_executable_get_symbol_by_name::ToString()
{
    std::ostringstream ss;
    ss << "executable=" << HSATraceStringUtils::Get_hsa_executable_t_String(m_executable) << s_strParamSeparator;
    ss << "symbol_name=" << HSATraceStringUtils::GetStringString(m_symbol_name, m_symbol_nameVal) << s_strParamSeparator;
    ss << "agent=" << HSATraceStringUtils::Get_hsa_agent_t_Ptr_String(m_agent, m_agentVal) << s_strParamSeparator;
    ss << "symbol=" << HSATraceStringUtils::Get_hsa_executable_symbol_t_Ptr_String(m_symbol, m_symbolVal);
    return ss.str();
}

void HSA_APITrace_hsa_executable_get_symbol_by_name::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_executable_t executable,
    const char* symbol_name,
    const hsa_agent_t* agent,
    hsa_executable_symbol_t* symbol,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_executable_get_symbol_by_name;
    m_executable = executable;
    m_symbol_name = symbol_name;

    if (nullptr != m_symbol_name)
    {
        m_symbol_nameVal = std::string(m_symbol_name);
    }
    else
    {
        m_symbol_nameVal = "";
    }

    m_agent = agent;

    if (nullptr != m_agent)
    {
        m_agentVal = *m_agent;
    }

    m_symbol = symbol;

    if (nullptr != m_symbol)
    {
        m_symbolVal = *m_symbol;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_executable_symbol_get_info
///////////////////////////////////////////////////

HSA_APITrace_hsa_executable_symbol_get_info::HSA_APITrace_hsa_executable_symbol_get_info() : m_value(nullptr)
{
}

HSA_APITrace_hsa_executable_symbol_get_info::~HSA_APITrace_hsa_executable_symbol_get_info()
{
    if (nullptr != m_value)
    {
        FreeBuffer(m_value);
    }
}

std::string HSA_APITrace_hsa_executable_symbol_get_info::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_executable_symbol_get_info::ToString()
{
    std::ostringstream ss;
    ss << "executable_symbol=" << HSATraceStringUtils::Get_hsa_executable_symbol_t_String(m_executable_symbol) << s_strParamSeparator;
    ss << "attribute=" << HSATraceStringUtils::Get_hsa_executable_symbol_info_t_String(m_attribute) << s_strParamSeparator;
    ss << "value=" << HSATraceStringUtils::Get_hsa_executable_symbol_get_info_AttributeString(m_value, m_attribute, m_retVal);
    return ss.str();
}

void HSA_APITrace_hsa_executable_symbol_get_info::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_executable_symbol_t executable_symbol,
    hsa_executable_symbol_info_t attribute,
    void* value,
    uint32_t valueLength,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_executable_symbol_get_info;
    m_executable_symbol = executable_symbol;
    m_attribute = attribute;

    if (nullptr != value)
    {
        DeepCopyBuffer(&m_value, value, valueLength);
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_executable_iterate_symbols
///////////////////////////////////////////////////

HSA_APITrace_hsa_executable_iterate_symbols::HSA_APITrace_hsa_executable_iterate_symbols()
{
}

HSA_APITrace_hsa_executable_iterate_symbols::~HSA_APITrace_hsa_executable_iterate_symbols()
{
}

std::string HSA_APITrace_hsa_executable_iterate_symbols::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_executable_iterate_symbols::ToString()
{
    std::ostringstream ss;
    ss << "executable=" << HSATraceStringUtils::Get_hsa_executable_t_String(m_executable) << s_strParamSeparator;
    ss << "callback=" << StringUtils::ToString(reinterpret_cast<void*>(m_callback)) << s_strParamSeparator;
    ss << "data=" << StringUtils::ToHexString(m_data);
    return ss.str();
}

void HSA_APITrace_hsa_executable_iterate_symbols::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_executable_t executable,
    hsa_status_t (*callback)(hsa_executable_t exec, hsa_executable_symbol_t symbol, void* data),
    void* data,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_executable_iterate_symbols;
    m_executable = executable;
    m_callback = callback;
    m_data = data;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_executable_iterate_agent_symbols
///////////////////////////////////////////////////

HSA_APITrace_hsa_executable_iterate_agent_symbols::HSA_APITrace_hsa_executable_iterate_agent_symbols()
{
}

HSA_APITrace_hsa_executable_iterate_agent_symbols::~HSA_APITrace_hsa_executable_iterate_agent_symbols()
{
}

std::string HSA_APITrace_hsa_executable_iterate_agent_symbols::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_executable_iterate_agent_symbols::ToString()
{
    std::ostringstream ss;
    ss << "executable=" << HSATraceStringUtils::Get_hsa_executable_t_String(m_executable) << s_strParamSeparator;
    ss << "agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_agent) << s_strParamSeparator;
    ss << "callback=" << StringUtils::ToString(reinterpret_cast<void*>(m_callback)) << s_strParamSeparator;
    ss << "data=" << StringUtils::ToHexString(m_data);
    return ss.str();
}

void HSA_APITrace_hsa_executable_iterate_agent_symbols::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_executable_t executable,
    hsa_agent_t agent,
    hsa_status_t (*callback)(hsa_executable_t exec, hsa_agent_t agent, hsa_executable_symbol_t symbol, void* data),
    void* data,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_executable_iterate_agent_symbols;
    m_executable = executable;
    m_agent = agent;
    m_callback = callback;
    m_data = data;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_executable_iterate_program_symbols
///////////////////////////////////////////////////

HSA_APITrace_hsa_executable_iterate_program_symbols::HSA_APITrace_hsa_executable_iterate_program_symbols()
{
}

HSA_APITrace_hsa_executable_iterate_program_symbols::~HSA_APITrace_hsa_executable_iterate_program_symbols()
{
}

std::string HSA_APITrace_hsa_executable_iterate_program_symbols::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_executable_iterate_program_symbols::ToString()
{
    std::ostringstream ss;
    ss << "executable=" << HSATraceStringUtils::Get_hsa_executable_t_String(m_executable) << s_strParamSeparator;
    ss << "callback=" << StringUtils::ToString(reinterpret_cast<void*>(m_callback)) << s_strParamSeparator;
    ss << "data=" << StringUtils::ToHexString(m_data);
    return ss.str();
}

void HSA_APITrace_hsa_executable_iterate_program_symbols::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_executable_t executable,
    hsa_status_t (*callback)(hsa_executable_t exec, hsa_executable_symbol_t symbol, void* data),
    void* data,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_executable_iterate_program_symbols;
    m_executable = executable;
    m_callback = callback;
    m_data = data;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_code_object_serialize
///////////////////////////////////////////////////

HSA_APITrace_hsa_code_object_serialize::HSA_APITrace_hsa_code_object_serialize()
{
}

HSA_APITrace_hsa_code_object_serialize::~HSA_APITrace_hsa_code_object_serialize()
{
}

std::string HSA_APITrace_hsa_code_object_serialize::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_code_object_serialize::ToString()
{
    std::ostringstream ss;
    ss << "code_object=" << HSATraceStringUtils::Get_hsa_code_object_t_String(m_code_object) << s_strParamSeparator;
    ss << "alloc_callback=" << StringUtils::ToString(m_alloc_callback) << s_strParamSeparator;
    ss << "callback_data=" << HSATraceStringUtils::Get_hsa_callback_data_t_String(m_callback_data) << s_strParamSeparator;
    ss << "options=" << HSATraceStringUtils::GetStringString(m_options, m_optionsVal) << s_strParamSeparator;
    ss << "serialized_code_object=" << HSATraceStringUtils::SurroundWithDeRef(StringUtils::ToHexString(m_serialized_code_objectVal)) << s_strParamSeparator;
    ss << "serialized_code_object_size=" << StringUtils::ToStringPtr(m_serialized_code_object_size, m_serialized_code_object_sizeVal);
    return ss.str();
}

void HSA_APITrace_hsa_code_object_serialize::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_code_object_t code_object,
    hsa_status_t (*alloc_callback)(size_t size, hsa_callback_data_t data, void** address),
    hsa_callback_data_t callback_data,
    const char* options,
    void** serialized_code_object,
    size_t* serialized_code_object_size,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_code_object_serialize;
    m_code_object = code_object;
    m_alloc_callback = alloc_callback;
    m_callback_data = callback_data;
    m_options = options;

    if (nullptr != m_options)
    {
        m_optionsVal = std::string(m_options);
    }
    else
    {
        m_optionsVal = "";
    }

    m_serialized_code_object = serialized_code_object;

    if (nullptr != m_serialized_code_object)
    {
        m_serialized_code_objectVal = reinterpret_cast<uintptr_t>(*m_serialized_code_object);
    }

    m_serialized_code_object_size = serialized_code_object_size;

    if (nullptr != m_serialized_code_object_size)
    {
        m_serialized_code_object_sizeVal = *m_serialized_code_object_size;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_code_object_deserialize
///////////////////////////////////////////////////

HSA_APITrace_hsa_code_object_deserialize::HSA_APITrace_hsa_code_object_deserialize()
{
}

HSA_APITrace_hsa_code_object_deserialize::~HSA_APITrace_hsa_code_object_deserialize()
{
}

std::string HSA_APITrace_hsa_code_object_deserialize::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_code_object_deserialize::ToString()
{
    std::ostringstream ss;
    ss << "serialized_code_object=" << StringUtils::ToHexString(m_serialized_code_object) << s_strParamSeparator;
    ss << "serialized_code_object_size=" << StringUtils::ToString(m_serialized_code_object_size) << s_strParamSeparator;
    ss << "options=" << HSATraceStringUtils::GetStringString(m_options, m_optionsVal) << s_strParamSeparator;
    ss << "code_object=" << HSATraceStringUtils::Get_hsa_code_object_t_Ptr_String(m_code_object, m_code_objectVal);
    return ss.str();
}

void HSA_APITrace_hsa_code_object_deserialize::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    void* serialized_code_object,
    size_t serialized_code_object_size,
    const char* options,
    hsa_code_object_t* code_object,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_code_object_deserialize;
    m_serialized_code_object = serialized_code_object;
    m_serialized_code_object_size = serialized_code_object_size;
    m_options = options;

    if (nullptr != m_options)
    {
        m_optionsVal = std::string(m_options);
    }
    else
    {
        m_optionsVal = "";
    }

    m_code_object = code_object;

    if (nullptr != m_code_object)
    {
        m_code_objectVal = *m_code_object;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_code_object_destroy
///////////////////////////////////////////////////

HSA_APITrace_hsa_code_object_destroy::HSA_APITrace_hsa_code_object_destroy()
{
}

HSA_APITrace_hsa_code_object_destroy::~HSA_APITrace_hsa_code_object_destroy()
{
}

std::string HSA_APITrace_hsa_code_object_destroy::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_code_object_destroy::ToString()
{
    std::ostringstream ss;
    ss << "code_object=" << HSATraceStringUtils::Get_hsa_code_object_t_String(m_code_object);
    return ss.str();
}

void HSA_APITrace_hsa_code_object_destroy::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_code_object_t code_object,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_code_object_destroy;
    m_code_object = code_object;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_code_object_get_info
///////////////////////////////////////////////////

HSA_APITrace_hsa_code_object_get_info::HSA_APITrace_hsa_code_object_get_info() : m_value(nullptr)
{
}

HSA_APITrace_hsa_code_object_get_info::~HSA_APITrace_hsa_code_object_get_info()
{
    if (nullptr != m_value)
    {
        FreeBuffer(m_value);
    }
}

std::string HSA_APITrace_hsa_code_object_get_info::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_code_object_get_info::ToString()
{
    std::ostringstream ss;
    ss << "code_object=" << HSATraceStringUtils::Get_hsa_code_object_t_String(m_code_object) << s_strParamSeparator;
    ss << "attribute=" << HSATraceStringUtils::Get_hsa_code_object_info_t_String(m_attribute) << s_strParamSeparator;
    ss << "value=" << HSATraceStringUtils::Get_hsa_code_object_get_info_AttributeString(m_value, m_attribute, m_retVal);
    return ss.str();
}

void HSA_APITrace_hsa_code_object_get_info::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_code_object_t code_object,
    hsa_code_object_info_t attribute,
    void* value,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_code_object_get_info;
    m_code_object = code_object;
    m_attribute = attribute;

    if (nullptr != value)
    {
        DeepCopyBuffer(&m_value, value, HSATraceStringUtils::Get_hsa_code_object_get_info_AttributeSize(m_attribute));
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_executable_load_code_object
///////////////////////////////////////////////////

HSA_APITrace_hsa_executable_load_code_object::HSA_APITrace_hsa_executable_load_code_object()
{
}

HSA_APITrace_hsa_executable_load_code_object::~HSA_APITrace_hsa_executable_load_code_object()
{
}

std::string HSA_APITrace_hsa_executable_load_code_object::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_executable_load_code_object::ToString()
{
    std::ostringstream ss;
    ss << "executable=" << HSATraceStringUtils::Get_hsa_executable_t_String(m_executable) << s_strParamSeparator;
    ss << "agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_agent) << s_strParamSeparator;
    ss << "code_object=" << HSATraceStringUtils::Get_hsa_code_object_t_String(m_code_object) << s_strParamSeparator;
    ss << "options=" << HSATraceStringUtils::GetStringString(m_options, m_optionsVal);
    return ss.str();
}

void HSA_APITrace_hsa_executable_load_code_object::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_executable_t executable,
    hsa_agent_t agent,
    hsa_code_object_t code_object,
    const char* options,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_executable_load_code_object;
    m_executable = executable;
    m_agent = agent;
    m_code_object = code_object;
    m_options = options;

    if (nullptr != m_options)
    {
        m_optionsVal = std::string(m_options);
    }
    else
    {
        m_optionsVal = "";
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_code_object_get_symbol
///////////////////////////////////////////////////

HSA_APITrace_hsa_code_object_get_symbol::HSA_APITrace_hsa_code_object_get_symbol()
{
}

HSA_APITrace_hsa_code_object_get_symbol::~HSA_APITrace_hsa_code_object_get_symbol()
{
}

std::string HSA_APITrace_hsa_code_object_get_symbol::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_code_object_get_symbol::ToString()
{
    std::ostringstream ss;
    ss << "code_object=" << HSATraceStringUtils::Get_hsa_code_object_t_String(m_code_object) << s_strParamSeparator;
    ss << "symbol_name=" << HSATraceStringUtils::GetStringString(m_symbol_name, m_symbol_nameVal) << s_strParamSeparator;
    ss << "symbol=" << HSATraceStringUtils::Get_hsa_code_symbol_t_Ptr_String(m_symbol, m_symbolVal);
    return ss.str();
}

void HSA_APITrace_hsa_code_object_get_symbol::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_code_object_t code_object,
    const char* symbol_name,
    hsa_code_symbol_t* symbol,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_code_object_get_symbol;
    m_code_object = code_object;
    m_symbol_name = symbol_name;

    if (nullptr != m_symbol_name)
    {
        m_symbol_nameVal = std::string(m_symbol_name);
    }
    else
    {
        m_symbol_nameVal = "";
    }

    m_symbol = symbol;

    if (nullptr != m_symbol)
    {
        m_symbolVal = *m_symbol;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_code_object_get_symbol_from_name
///////////////////////////////////////////////////

HSA_APITrace_hsa_code_object_get_symbol_from_name::HSA_APITrace_hsa_code_object_get_symbol_from_name()
{
}

HSA_APITrace_hsa_code_object_get_symbol_from_name::~HSA_APITrace_hsa_code_object_get_symbol_from_name()
{
}

std::string HSA_APITrace_hsa_code_object_get_symbol_from_name::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_code_object_get_symbol_from_name::ToString()
{
    std::ostringstream ss;
    ss << "code_object=" << HSATraceStringUtils::Get_hsa_code_object_t_String(m_code_object) << s_strParamSeparator;
    ss << "module_name=" << HSATraceStringUtils::GetStringString(m_module_name, m_module_nameVal) << s_strParamSeparator;
    ss << "symbol_name=" << HSATraceStringUtils::GetStringString(m_symbol_name, m_symbol_nameVal) << s_strParamSeparator;
    ss << "symbol=" << HSATraceStringUtils::Get_hsa_code_symbol_t_Ptr_String(m_symbol, m_symbolVal);
    return ss.str();
}

void HSA_APITrace_hsa_code_object_get_symbol_from_name::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_code_object_t code_object,
    const char* module_name,
    const char* symbol_name,
    hsa_code_symbol_t* symbol,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_code_object_get_symbol_from_name;
    m_code_object = code_object;
    m_module_name = module_name;

    if (nullptr != m_module_name)
    {
        m_module_nameVal = std::string(m_module_name);
    }
    else
    {
        m_module_nameVal = "";
    }

    m_symbol_name = symbol_name;

    if (nullptr != m_symbol_name)
    {
        m_symbol_nameVal = std::string(m_symbol_name);
    }
    else
    {
        m_symbol_nameVal = "";
    }

    m_symbol = symbol;

    if (nullptr != m_symbol)
    {
        m_symbolVal = *m_symbol;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_code_symbol_get_info
///////////////////////////////////////////////////

HSA_APITrace_hsa_code_symbol_get_info::HSA_APITrace_hsa_code_symbol_get_info() : m_value(nullptr)
{
}

HSA_APITrace_hsa_code_symbol_get_info::~HSA_APITrace_hsa_code_symbol_get_info()
{
    if (nullptr != m_value)
    {
        FreeBuffer(m_value);
    }
}

std::string HSA_APITrace_hsa_code_symbol_get_info::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_code_symbol_get_info::ToString()
{
    std::ostringstream ss;
    ss << "code_symbol=" << HSATraceStringUtils::Get_hsa_code_symbol_t_String(m_code_symbol) << s_strParamSeparator;
    ss << "attribute=" << HSATraceStringUtils::Get_hsa_code_symbol_info_t_String(m_attribute) << s_strParamSeparator;
    ss << "value=" << HSATraceStringUtils::Get_hsa_code_symbol_get_info_AttributeString(m_value, m_attribute, m_retVal);
    return ss.str();
}

void HSA_APITrace_hsa_code_symbol_get_info::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_code_symbol_t code_symbol,
    hsa_code_symbol_info_t attribute,
    void* value,
    uint32_t valueLength,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_code_symbol_get_info;
    m_code_symbol = code_symbol;
    m_attribute = attribute;

    if (nullptr != value)
    {
        DeepCopyBuffer(&m_value, value, valueLength);
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_code_object_iterate_symbols
///////////////////////////////////////////////////

HSA_APITrace_hsa_code_object_iterate_symbols::HSA_APITrace_hsa_code_object_iterate_symbols()
{
}

HSA_APITrace_hsa_code_object_iterate_symbols::~HSA_APITrace_hsa_code_object_iterate_symbols()
{
}

std::string HSA_APITrace_hsa_code_object_iterate_symbols::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_code_object_iterate_symbols::ToString()
{
    std::ostringstream ss;
    ss << "code_object=" << HSATraceStringUtils::Get_hsa_code_object_t_String(m_code_object) << s_strParamSeparator;
    ss << "callback=" << StringUtils::ToString(reinterpret_cast<void*>(m_callback)) << s_strParamSeparator;
    ss << "data=" << StringUtils::ToHexString(m_data);
    return ss.str();
}

void HSA_APITrace_hsa_code_object_iterate_symbols::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_code_object_t code_object,
    hsa_status_t (*callback)(hsa_code_object_t code_object, hsa_code_symbol_t symbol, void* data),
    void* data,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_code_object_iterate_symbols;
    m_code_object = code_object;
    m_callback = callback;
    m_data = data;
    m_retVal = retVal;
}


