//==============================================================================
// Copyright (c) 2015-2018 Advanced Micro Devices, Inc. All rights reserved.
/// \author AMD Developer Tools Team
/// \file
/// \brief THIS CODE WAS AUTOGENERATED BY HSA CODE GENERATOR
//==============================================================================

#ifndef _HSAAMDLOADEREXTENSIONAPITRACECLASSES_H_
#define _HSAAMDLOADEREXTENSIONAPITRACECLASSES_H_

#include "../HSAAPIBase.h"

///////////////////////////////////////////////////
/// Class used to trace hsa_ven_amd_loader_query_host_address
///////////////////////////////////////////////////
class HSA_APITrace_hsa_ven_amd_loader_query_host_address : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_ven_amd_loader_query_host_address();

    /// Destructor
    ~HSA_APITrace_hsa_ven_amd_loader_query_host_address();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_ven_amd_loader_query_host_address
    /// \param ullEndTime the end timestamp for hsa_ven_amd_loader_query_host_address
    /// \param device_address Parameter passed to hsa_ven_amd_loader_query_host_address
    /// \param host_address Parameter passed to hsa_ven_amd_loader_query_host_address
    /// \param retVal the return value for hsa_ven_amd_loader_query_host_address
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const void* device_address,
                const void** host_address,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_ven_amd_loader_query_host_address(const HSA_APITrace_hsa_ven_amd_loader_query_host_address& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_ven_amd_loader_query_host_address& operator= (const HSA_APITrace_hsa_ven_amd_loader_query_host_address& rhs) = delete;

    const void* m_device_address; ///< Parameter passed to hsa_ven_amd_loader_query_host_address
    const void** m_host_address; ///< Parameter passed to hsa_ven_amd_loader_query_host_address
    uintptr_t m_host_addressVal; ///< Member to hold value passed to hsa_ven_amd_loader_query_host_address in host_address parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_ven_amd_loader_query_host_address
};

///////////////////////////////////////////////////
/// Class used to trace hsa_ven_amd_loader_query_segment_descriptors
///////////////////////////////////////////////////
class HSA_APITrace_hsa_ven_amd_loader_query_segment_descriptors : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_ven_amd_loader_query_segment_descriptors();

    /// Destructor
    ~HSA_APITrace_hsa_ven_amd_loader_query_segment_descriptors();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_ven_amd_loader_query_segment_descriptors
    /// \param ullEndTime the end timestamp for hsa_ven_amd_loader_query_segment_descriptors
    /// \param segment_descriptors Parameter passed to hsa_ven_amd_loader_query_segment_descriptors
    /// \param num_segment_descriptors Parameter passed to hsa_ven_amd_loader_query_segment_descriptors
    /// \param retVal the return value for hsa_ven_amd_loader_query_segment_descriptors
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_ven_amd_loader_segment_descriptor_t* segment_descriptors,
                size_t* num_segment_descriptors,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_ven_amd_loader_query_segment_descriptors(const HSA_APITrace_hsa_ven_amd_loader_query_segment_descriptors& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_ven_amd_loader_query_segment_descriptors& operator= (const HSA_APITrace_hsa_ven_amd_loader_query_segment_descriptors& rhs) = delete;

    hsa_ven_amd_loader_segment_descriptor_t* m_segment_descriptors; ///< Parameter passed to hsa_ven_amd_loader_query_segment_descriptors
    hsa_ven_amd_loader_segment_descriptor_t m_segment_descriptorsVal; ///< Member to hold value passed to hsa_ven_amd_loader_query_segment_descriptors in segment_descriptors parameter
    size_t* m_num_segment_descriptors; ///< Parameter passed to hsa_ven_amd_loader_query_segment_descriptors
    size_t m_num_segment_descriptorsVal; ///< Member to hold value passed to hsa_ven_amd_loader_query_segment_descriptors in num_segment_descriptors parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_ven_amd_loader_query_segment_descriptors
};

///////////////////////////////////////////////////
/// Class used to trace hsa_ven_amd_loader_query_executable
///////////////////////////////////////////////////
class HSA_APITrace_hsa_ven_amd_loader_query_executable : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_ven_amd_loader_query_executable();

    /// Destructor
    ~HSA_APITrace_hsa_ven_amd_loader_query_executable();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_ven_amd_loader_query_executable
    /// \param ullEndTime the end timestamp for hsa_ven_amd_loader_query_executable
    /// \param device_address Parameter passed to hsa_ven_amd_loader_query_executable
    /// \param executable Parameter passed to hsa_ven_amd_loader_query_executable
    /// \param retVal the return value for hsa_ven_amd_loader_query_executable
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const void* device_address,
                hsa_executable_t* executable,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_ven_amd_loader_query_executable(const HSA_APITrace_hsa_ven_amd_loader_query_executable& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_ven_amd_loader_query_executable& operator= (const HSA_APITrace_hsa_ven_amd_loader_query_executable& rhs) = delete;

    const void* m_device_address; ///< Parameter passed to hsa_ven_amd_loader_query_executable
    hsa_executable_t* m_executable; ///< Parameter passed to hsa_ven_amd_loader_query_executable
    hsa_executable_t m_executableVal; ///< Member to hold value passed to hsa_ven_amd_loader_query_executable in executable parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_ven_amd_loader_query_executable
};

///////////////////////////////////////////////////
/// Class used to trace hsa_ven_amd_loader_executable_iterate_loaded_code_objects
///////////////////////////////////////////////////
class HSA_APITrace_hsa_ven_amd_loader_executable_iterate_loaded_code_objects : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_ven_amd_loader_executable_iterate_loaded_code_objects();

    /// Destructor
    ~HSA_APITrace_hsa_ven_amd_loader_executable_iterate_loaded_code_objects();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_ven_amd_loader_executable_iterate_loaded_code_objects
    /// \param ullEndTime the end timestamp for hsa_ven_amd_loader_executable_iterate_loaded_code_objects
    /// \param executable Parameter passed to hsa_ven_amd_loader_executable_iterate_loaded_code_objects
    /// \param callback Parameter passed to hsa_ven_amd_loader_executable_iterate_loaded_code_objects
    /// \param data Parameter passed to hsa_ven_amd_loader_executable_iterate_loaded_code_objects
    /// \param retVal the return value for hsa_ven_amd_loader_executable_iterate_loaded_code_objects
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_executable_t executable,
                hsa_status_t (*callback)(
    hsa_executable_t executable, hsa_loaded_code_object_t loaded_code_object, void* data),
                void* data,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_ven_amd_loader_executable_iterate_loaded_code_objects(const HSA_APITrace_hsa_ven_amd_loader_executable_iterate_loaded_code_objects& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_ven_amd_loader_executable_iterate_loaded_code_objects& operator= (const HSA_APITrace_hsa_ven_amd_loader_executable_iterate_loaded_code_objects& rhs) = delete;

    hsa_executable_t m_executable; ///< Parameter passed to hsa_ven_amd_loader_executable_iterate_loaded_code_objects
    hsa_status_t (*m_callback)(
    hsa_executable_t executable, hsa_loaded_code_object_t loaded_code_object, void* data); ///< Parameter passed to hsa_ven_amd_loader_executable_iterate_loaded_code_objects
    void* m_data; ///< Parameter passed to hsa_ven_amd_loader_executable_iterate_loaded_code_objects
    hsa_status_t m_retVal; ///< Parameter passed to hsa_ven_amd_loader_executable_iterate_loaded_code_objects
};

///////////////////////////////////////////////////
/// Class used to trace hsa_ven_amd_loader_loaded_code_object_get_info
///////////////////////////////////////////////////
class HSA_APITrace_hsa_ven_amd_loader_loaded_code_object_get_info : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_ven_amd_loader_loaded_code_object_get_info();

    /// Destructor
    ~HSA_APITrace_hsa_ven_amd_loader_loaded_code_object_get_info();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_ven_amd_loader_loaded_code_object_get_info
    /// \param ullEndTime the end timestamp for hsa_ven_amd_loader_loaded_code_object_get_info
    /// \param loaded_code_object Parameter passed to hsa_ven_amd_loader_loaded_code_object_get_info
    /// \param attribute Parameter passed to hsa_ven_amd_loader_loaded_code_object_get_info
    /// \param value Parameter passed to hsa_ven_amd_loader_loaded_code_object_get_info
    /// \param retVal the return value for hsa_ven_amd_loader_loaded_code_object_get_info
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_loaded_code_object_t loaded_code_object,
                hsa_ven_amd_loader_loaded_code_object_info_t attribute,
                void* value,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_ven_amd_loader_loaded_code_object_get_info(const HSA_APITrace_hsa_ven_amd_loader_loaded_code_object_get_info& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_ven_amd_loader_loaded_code_object_get_info& operator= (const HSA_APITrace_hsa_ven_amd_loader_loaded_code_object_get_info& rhs) = delete;

    hsa_loaded_code_object_t m_loaded_code_object; ///< Parameter passed to hsa_ven_amd_loader_loaded_code_object_get_info
    hsa_ven_amd_loader_loaded_code_object_info_t m_attribute; ///< Parameter passed to hsa_ven_amd_loader_loaded_code_object_get_info
    void* m_value; ///< Parameter passed to hsa_ven_amd_loader_loaded_code_object_get_info
    hsa_status_t m_retVal; ///< Parameter passed to hsa_ven_amd_loader_loaded_code_object_get_info
};



#endif // _HSAAMDLOADEREXTENSIONAPITRACECLASSES_H_

