//==============================================================================
// Copyright (c) 2015-2018 Advanced Micro Devices, Inc. All rights reserved.
/// \author AMD Developer Tools Team
/// \file
/// \brief THIS CODE WAS AUTOGENERATED BY HSA CODE GENERATOR
//==============================================================================

#ifndef _HSAAMDEXTENSIONAPITRACECLASSES_H_
#define _HSAAMDEXTENSIONAPITRACECLASSES_H_

#include "../HSAAPIBase.h"

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_coherency_get_type
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_coherency_get_type : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_coherency_get_type();

    /// Destructor
    ~HSA_APITrace_hsa_amd_coherency_get_type();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_coherency_get_type
    /// \param ullEndTime the end timestamp for hsa_amd_coherency_get_type
    /// \param agent Parameter passed to hsa_amd_coherency_get_type
    /// \param type_ Parameter passed to hsa_amd_coherency_get_type
    /// \param retVal the return value for hsa_amd_coherency_get_type
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_agent_t agent,
                hsa_amd_coherency_type_t* type_,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_coherency_get_type(const HSA_APITrace_hsa_amd_coherency_get_type& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_coherency_get_type& operator= (const HSA_APITrace_hsa_amd_coherency_get_type& rhs) = delete;

    hsa_agent_t m_agent; ///< Parameter passed to hsa_amd_coherency_get_type
    hsa_amd_coherency_type_t* m_type_; ///< Parameter passed to hsa_amd_coherency_get_type
    hsa_amd_coherency_type_t m_type_Val; ///< Member to hold value passed to hsa_amd_coherency_get_type in type_ parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_coherency_get_type
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_coherency_set_type
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_coherency_set_type : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_coherency_set_type();

    /// Destructor
    ~HSA_APITrace_hsa_amd_coherency_set_type();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_coherency_set_type
    /// \param ullEndTime the end timestamp for hsa_amd_coherency_set_type
    /// \param agent Parameter passed to hsa_amd_coherency_set_type
    /// \param type_ Parameter passed to hsa_amd_coherency_set_type
    /// \param retVal the return value for hsa_amd_coherency_set_type
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_agent_t agent,
                hsa_amd_coherency_type_t type_,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_coherency_set_type(const HSA_APITrace_hsa_amd_coherency_set_type& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_coherency_set_type& operator= (const HSA_APITrace_hsa_amd_coherency_set_type& rhs) = delete;

    hsa_agent_t m_agent; ///< Parameter passed to hsa_amd_coherency_set_type
    hsa_amd_coherency_type_t m_type_; ///< Parameter passed to hsa_amd_coherency_set_type
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_coherency_set_type
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_profiling_set_profiler_enabled
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_profiling_set_profiler_enabled : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_profiling_set_profiler_enabled();

    /// Destructor
    ~HSA_APITrace_hsa_amd_profiling_set_profiler_enabled();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_profiling_set_profiler_enabled
    /// \param ullEndTime the end timestamp for hsa_amd_profiling_set_profiler_enabled
    /// \param queue Parameter passed to hsa_amd_profiling_set_profiler_enabled
    /// \param enable Parameter passed to hsa_amd_profiling_set_profiler_enabled
    /// \param retVal the return value for hsa_amd_profiling_set_profiler_enabled
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_queue_t* queue,
                int enable,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_profiling_set_profiler_enabled(const HSA_APITrace_hsa_amd_profiling_set_profiler_enabled& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_profiling_set_profiler_enabled& operator= (const HSA_APITrace_hsa_amd_profiling_set_profiler_enabled& rhs) = delete;

    hsa_queue_t* m_queue; ///< Parameter passed to hsa_amd_profiling_set_profiler_enabled
    hsa_queue_t m_queueVal; ///< Member to hold value passed to hsa_amd_profiling_set_profiler_enabled in queue parameter
    int m_enable; ///< Parameter passed to hsa_amd_profiling_set_profiler_enabled
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_profiling_set_profiler_enabled
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_profiling_async_copy_enable
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_profiling_async_copy_enable : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_profiling_async_copy_enable();

    /// Destructor
    ~HSA_APITrace_hsa_amd_profiling_async_copy_enable();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_profiling_async_copy_enable
    /// \param ullEndTime the end timestamp for hsa_amd_profiling_async_copy_enable
    /// \param enable Parameter passed to hsa_amd_profiling_async_copy_enable
    /// \param retVal the return value for hsa_amd_profiling_async_copy_enable
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                bool enable,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_profiling_async_copy_enable(const HSA_APITrace_hsa_amd_profiling_async_copy_enable& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_profiling_async_copy_enable& operator= (const HSA_APITrace_hsa_amd_profiling_async_copy_enable& rhs) = delete;

    bool m_enable; ///< Parameter passed to hsa_amd_profiling_async_copy_enable
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_profiling_async_copy_enable
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_profiling_get_dispatch_time
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_profiling_get_dispatch_time : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_profiling_get_dispatch_time();

    /// Destructor
    ~HSA_APITrace_hsa_amd_profiling_get_dispatch_time();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_profiling_get_dispatch_time
    /// \param ullEndTime the end timestamp for hsa_amd_profiling_get_dispatch_time
    /// \param agent Parameter passed to hsa_amd_profiling_get_dispatch_time
    /// \param signal Parameter passed to hsa_amd_profiling_get_dispatch_time
    /// \param time Parameter passed to hsa_amd_profiling_get_dispatch_time
    /// \param retVal the return value for hsa_amd_profiling_get_dispatch_time
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_agent_t agent,
                hsa_signal_t signal,
                hsa_amd_profiling_dispatch_time_t* time,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_profiling_get_dispatch_time(const HSA_APITrace_hsa_amd_profiling_get_dispatch_time& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_profiling_get_dispatch_time& operator= (const HSA_APITrace_hsa_amd_profiling_get_dispatch_time& rhs) = delete;

    hsa_agent_t m_agent; ///< Parameter passed to hsa_amd_profiling_get_dispatch_time
    hsa_signal_t m_signal; ///< Parameter passed to hsa_amd_profiling_get_dispatch_time
    hsa_amd_profiling_dispatch_time_t* m_time; ///< Parameter passed to hsa_amd_profiling_get_dispatch_time
    hsa_amd_profiling_dispatch_time_t m_timeVal; ///< Member to hold value passed to hsa_amd_profiling_get_dispatch_time in time parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_profiling_get_dispatch_time
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_profiling_get_async_copy_time
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_profiling_get_async_copy_time : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_profiling_get_async_copy_time();

    /// Destructor
    ~HSA_APITrace_hsa_amd_profiling_get_async_copy_time();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_profiling_get_async_copy_time
    /// \param ullEndTime the end timestamp for hsa_amd_profiling_get_async_copy_time
    /// \param signal Parameter passed to hsa_amd_profiling_get_async_copy_time
    /// \param time Parameter passed to hsa_amd_profiling_get_async_copy_time
    /// \param retVal the return value for hsa_amd_profiling_get_async_copy_time
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_amd_profiling_async_copy_time_t* time,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_profiling_get_async_copy_time(const HSA_APITrace_hsa_amd_profiling_get_async_copy_time& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_profiling_get_async_copy_time& operator= (const HSA_APITrace_hsa_amd_profiling_get_async_copy_time& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_amd_profiling_get_async_copy_time
    hsa_amd_profiling_async_copy_time_t* m_time; ///< Parameter passed to hsa_amd_profiling_get_async_copy_time
    hsa_amd_profiling_async_copy_time_t m_timeVal; ///< Member to hold value passed to hsa_amd_profiling_get_async_copy_time in time parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_profiling_get_async_copy_time
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_profiling_convert_tick_to_system_domain
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_profiling_convert_tick_to_system_domain : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_profiling_convert_tick_to_system_domain();

    /// Destructor
    ~HSA_APITrace_hsa_amd_profiling_convert_tick_to_system_domain();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_profiling_convert_tick_to_system_domain
    /// \param ullEndTime the end timestamp for hsa_amd_profiling_convert_tick_to_system_domain
    /// \param agent Parameter passed to hsa_amd_profiling_convert_tick_to_system_domain
    /// \param agent_tick Parameter passed to hsa_amd_profiling_convert_tick_to_system_domain
    /// \param system_tick Parameter passed to hsa_amd_profiling_convert_tick_to_system_domain
    /// \param retVal the return value for hsa_amd_profiling_convert_tick_to_system_domain
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_agent_t agent,
                uint64_t agent_tick,
                uint64_t* system_tick,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_profiling_convert_tick_to_system_domain(const HSA_APITrace_hsa_amd_profiling_convert_tick_to_system_domain& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_profiling_convert_tick_to_system_domain& operator= (const HSA_APITrace_hsa_amd_profiling_convert_tick_to_system_domain& rhs) = delete;

    hsa_agent_t m_agent; ///< Parameter passed to hsa_amd_profiling_convert_tick_to_system_domain
    uint64_t m_agent_tick; ///< Parameter passed to hsa_amd_profiling_convert_tick_to_system_domain
    uint64_t* m_system_tick; ///< Parameter passed to hsa_amd_profiling_convert_tick_to_system_domain
    uint64_t m_system_tickVal; ///< Member to hold value passed to hsa_amd_profiling_convert_tick_to_system_domain in system_tick parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_profiling_convert_tick_to_system_domain
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_signal_create
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_signal_create : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_signal_create();

    /// Destructor
    ~HSA_APITrace_hsa_amd_signal_create();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_signal_create
    /// \param ullEndTime the end timestamp for hsa_amd_signal_create
    /// \param initial_value Parameter passed to hsa_amd_signal_create
    /// \param num_consumers Parameter passed to hsa_amd_signal_create
    /// \param consumers Parameter passed to hsa_amd_signal_create
    /// \param attributes Parameter passed to hsa_amd_signal_create
    /// \param signal Parameter passed to hsa_amd_signal_create
    /// \param retVal the return value for hsa_amd_signal_create
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_value_t initial_value,
                uint32_t num_consumers,
                const hsa_agent_t* consumers,
                uint64_t attributes,
                hsa_signal_t* signal,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_signal_create(const HSA_APITrace_hsa_amd_signal_create& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_signal_create& operator= (const HSA_APITrace_hsa_amd_signal_create& rhs) = delete;

    hsa_signal_value_t m_initial_value; ///< Parameter passed to hsa_amd_signal_create
    uint32_t m_num_consumers; ///< Parameter passed to hsa_amd_signal_create
    const hsa_agent_t* m_consumers; ///< Parameter passed to hsa_amd_signal_create
    hsa_agent_t m_consumersVal; ///< Member to hold value passed to hsa_amd_signal_create in consumers parameter
    uint64_t m_attributes; ///< Parameter passed to hsa_amd_signal_create
    hsa_signal_t* m_signal; ///< Parameter passed to hsa_amd_signal_create
    hsa_signal_t m_signalVal; ///< Member to hold value passed to hsa_amd_signal_create in signal parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_signal_create
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_signal_async_handler
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_signal_async_handler : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_signal_async_handler();

    /// Destructor
    ~HSA_APITrace_hsa_amd_signal_async_handler();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_signal_async_handler
    /// \param ullEndTime the end timestamp for hsa_amd_signal_async_handler
    /// \param signal Parameter passed to hsa_amd_signal_async_handler
    /// \param cond Parameter passed to hsa_amd_signal_async_handler
    /// \param value Parameter passed to hsa_amd_signal_async_handler
    /// \param handler Parameter passed to hsa_amd_signal_async_handler
    /// \param arg Parameter passed to hsa_amd_signal_async_handler
    /// \param retVal the return value for hsa_amd_signal_async_handler
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_condition_t cond,
                hsa_signal_value_t value,
                hsa_amd_signal_handler handler,
                void* arg,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_signal_async_handler(const HSA_APITrace_hsa_amd_signal_async_handler& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_signal_async_handler& operator= (const HSA_APITrace_hsa_amd_signal_async_handler& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_amd_signal_async_handler
    hsa_signal_condition_t m_cond; ///< Parameter passed to hsa_amd_signal_async_handler
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_amd_signal_async_handler
    hsa_amd_signal_handler m_handler; ///< Parameter passed to hsa_amd_signal_async_handler
    void* m_arg; ///< Parameter passed to hsa_amd_signal_async_handler
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_signal_async_handler
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_async_function
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_async_function : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_async_function();

    /// Destructor
    ~HSA_APITrace_hsa_amd_async_function();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_async_function
    /// \param ullEndTime the end timestamp for hsa_amd_async_function
    /// \param callback Parameter passed to hsa_amd_async_function
    /// \param arg Parameter passed to hsa_amd_async_function
    /// \param retVal the return value for hsa_amd_async_function
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                void (*callback)(void* arg),
                void* arg,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_async_function(const HSA_APITrace_hsa_amd_async_function& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_async_function& operator= (const HSA_APITrace_hsa_amd_async_function& rhs) = delete;

    void (*m_callback)(void* arg); ///< Parameter passed to hsa_amd_async_function
    void* m_arg; ///< Parameter passed to hsa_amd_async_function
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_async_function
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_signal_wait_any
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_signal_wait_any : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_signal_wait_any();

    /// Destructor
    ~HSA_APITrace_hsa_amd_signal_wait_any();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_signal_wait_any
    /// \param ullEndTime the end timestamp for hsa_amd_signal_wait_any
    /// \param signal_count Parameter passed to hsa_amd_signal_wait_any
    /// \param signals Parameter passed to hsa_amd_signal_wait_any
    /// \param conds Parameter passed to hsa_amd_signal_wait_any
    /// \param values Parameter passed to hsa_amd_signal_wait_any
    /// \param timeout_hint Parameter passed to hsa_amd_signal_wait_any
    /// \param wait_hint Parameter passed to hsa_amd_signal_wait_any
    /// \param satisfying_value Parameter passed to hsa_amd_signal_wait_any
    /// \param retVal the return value for hsa_amd_signal_wait_any
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                uint32_t signal_count,
                hsa_signal_t* signals,
                hsa_signal_condition_t* conds,
                hsa_signal_value_t* values,
                uint64_t timeout_hint,
                hsa_wait_state_t wait_hint,
                hsa_signal_value_t* satisfying_value,
                uint32_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_signal_wait_any(const HSA_APITrace_hsa_amd_signal_wait_any& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_signal_wait_any& operator= (const HSA_APITrace_hsa_amd_signal_wait_any& rhs) = delete;

    uint32_t m_signal_count; ///< Parameter passed to hsa_amd_signal_wait_any
    hsa_signal_t* m_signals; ///< Parameter passed to hsa_amd_signal_wait_any
    hsa_signal_t m_signalsVal; ///< Member to hold value passed to hsa_amd_signal_wait_any in signals parameter
    hsa_signal_condition_t* m_conds; ///< Parameter passed to hsa_amd_signal_wait_any
    hsa_signal_condition_t m_condsVal; ///< Member to hold value passed to hsa_amd_signal_wait_any in conds parameter
    hsa_signal_value_t* m_values; ///< Parameter passed to hsa_amd_signal_wait_any
    hsa_signal_value_t m_valuesVal; ///< Member to hold value passed to hsa_amd_signal_wait_any in values parameter
    uint64_t m_timeout_hint; ///< Parameter passed to hsa_amd_signal_wait_any
    hsa_wait_state_t m_wait_hint; ///< Parameter passed to hsa_amd_signal_wait_any
    hsa_signal_value_t* m_satisfying_value; ///< Parameter passed to hsa_amd_signal_wait_any
    hsa_signal_value_t m_satisfying_valueVal; ///< Member to hold value passed to hsa_amd_signal_wait_any in satisfying_value parameter
    uint32_t m_retVal; ///< Parameter passed to hsa_amd_signal_wait_any
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_queue_cu_set_mask
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_queue_cu_set_mask : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_queue_cu_set_mask();

    /// Destructor
    ~HSA_APITrace_hsa_amd_queue_cu_set_mask();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_queue_cu_set_mask
    /// \param ullEndTime the end timestamp for hsa_amd_queue_cu_set_mask
    /// \param queue Parameter passed to hsa_amd_queue_cu_set_mask
    /// \param num_cu_mask_count Parameter passed to hsa_amd_queue_cu_set_mask
    /// \param cu_mask Parameter passed to hsa_amd_queue_cu_set_mask
    /// \param retVal the return value for hsa_amd_queue_cu_set_mask
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_queue_t* queue,
                uint32_t num_cu_mask_count,
                const uint32_t* cu_mask,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_queue_cu_set_mask(const HSA_APITrace_hsa_amd_queue_cu_set_mask& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_queue_cu_set_mask& operator= (const HSA_APITrace_hsa_amd_queue_cu_set_mask& rhs) = delete;

    const hsa_queue_t* m_queue; ///< Parameter passed to hsa_amd_queue_cu_set_mask
    hsa_queue_t m_queueVal; ///< Member to hold value passed to hsa_amd_queue_cu_set_mask in queue parameter
    uint32_t m_num_cu_mask_count; ///< Parameter passed to hsa_amd_queue_cu_set_mask
    const uint32_t* m_cu_mask; ///< Parameter passed to hsa_amd_queue_cu_set_mask
    uint32_t m_cu_maskVal; ///< Member to hold value passed to hsa_amd_queue_cu_set_mask in cu_mask parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_queue_cu_set_mask
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_memory_pool_get_info
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_memory_pool_get_info : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_memory_pool_get_info();

    /// Destructor
    ~HSA_APITrace_hsa_amd_memory_pool_get_info();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_memory_pool_get_info
    /// \param ullEndTime the end timestamp for hsa_amd_memory_pool_get_info
    /// \param memory_pool Parameter passed to hsa_amd_memory_pool_get_info
    /// \param attribute Parameter passed to hsa_amd_memory_pool_get_info
    /// \param value Parameter passed to hsa_amd_memory_pool_get_info
    /// \param retVal the return value for hsa_amd_memory_pool_get_info
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_amd_memory_pool_t memory_pool,
                hsa_amd_memory_pool_info_t attribute,
                void* value,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_memory_pool_get_info(const HSA_APITrace_hsa_amd_memory_pool_get_info& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_memory_pool_get_info& operator= (const HSA_APITrace_hsa_amd_memory_pool_get_info& rhs) = delete;

    hsa_amd_memory_pool_t m_memory_pool; ///< Parameter passed to hsa_amd_memory_pool_get_info
    hsa_amd_memory_pool_info_t m_attribute; ///< Parameter passed to hsa_amd_memory_pool_get_info
    void* m_value; ///< Parameter passed to hsa_amd_memory_pool_get_info
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_memory_pool_get_info
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_agent_iterate_memory_pools
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_agent_iterate_memory_pools : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_agent_iterate_memory_pools();

    /// Destructor
    ~HSA_APITrace_hsa_amd_agent_iterate_memory_pools();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_agent_iterate_memory_pools
    /// \param ullEndTime the end timestamp for hsa_amd_agent_iterate_memory_pools
    /// \param agent Parameter passed to hsa_amd_agent_iterate_memory_pools
    /// \param callback Parameter passed to hsa_amd_agent_iterate_memory_pools
    /// \param data Parameter passed to hsa_amd_agent_iterate_memory_pools
    /// \param retVal the return value for hsa_amd_agent_iterate_memory_pools
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_agent_t agent,
                hsa_status_t (*callback)(hsa_amd_memory_pool_t memory_pool, void* data),
                void* data,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_agent_iterate_memory_pools(const HSA_APITrace_hsa_amd_agent_iterate_memory_pools& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_agent_iterate_memory_pools& operator= (const HSA_APITrace_hsa_amd_agent_iterate_memory_pools& rhs) = delete;

    hsa_agent_t m_agent; ///< Parameter passed to hsa_amd_agent_iterate_memory_pools
    hsa_status_t (*m_callback)(hsa_amd_memory_pool_t memory_pool, void* data); ///< Parameter passed to hsa_amd_agent_iterate_memory_pools
    void* m_data; ///< Parameter passed to hsa_amd_agent_iterate_memory_pools
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_agent_iterate_memory_pools
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_memory_pool_allocate
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_memory_pool_allocate : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_memory_pool_allocate();

    /// Destructor
    ~HSA_APITrace_hsa_amd_memory_pool_allocate();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_memory_pool_allocate
    /// \param ullEndTime the end timestamp for hsa_amd_memory_pool_allocate
    /// \param memory_pool Parameter passed to hsa_amd_memory_pool_allocate
    /// \param size Parameter passed to hsa_amd_memory_pool_allocate
    /// \param flags Parameter passed to hsa_amd_memory_pool_allocate
    /// \param ptr Parameter passed to hsa_amd_memory_pool_allocate
    /// \param retVal the return value for hsa_amd_memory_pool_allocate
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_amd_memory_pool_t memory_pool,
                size_t size,
                uint32_t flags,
                void** ptr,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_memory_pool_allocate(const HSA_APITrace_hsa_amd_memory_pool_allocate& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_memory_pool_allocate& operator= (const HSA_APITrace_hsa_amd_memory_pool_allocate& rhs) = delete;

    hsa_amd_memory_pool_t m_memory_pool; ///< Parameter passed to hsa_amd_memory_pool_allocate
    size_t m_size; ///< Parameter passed to hsa_amd_memory_pool_allocate
    uint32_t m_flags; ///< Parameter passed to hsa_amd_memory_pool_allocate
    void** m_ptr; ///< Parameter passed to hsa_amd_memory_pool_allocate
    uintptr_t m_ptrVal; ///< Member to hold value passed to hsa_amd_memory_pool_allocate in ptr parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_memory_pool_allocate
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_memory_pool_free
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_memory_pool_free : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_memory_pool_free();

    /// Destructor
    ~HSA_APITrace_hsa_amd_memory_pool_free();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_memory_pool_free
    /// \param ullEndTime the end timestamp for hsa_amd_memory_pool_free
    /// \param ptr Parameter passed to hsa_amd_memory_pool_free
    /// \param retVal the return value for hsa_amd_memory_pool_free
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                void* ptr,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_memory_pool_free(const HSA_APITrace_hsa_amd_memory_pool_free& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_memory_pool_free& operator= (const HSA_APITrace_hsa_amd_memory_pool_free& rhs) = delete;

    void* m_ptr; ///< Parameter passed to hsa_amd_memory_pool_free
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_memory_pool_free
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_memory_async_copy
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_memory_async_copy : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_memory_async_copy();

    /// Destructor
    ~HSA_APITrace_hsa_amd_memory_async_copy();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_memory_async_copy
    /// \param ullEndTime the end timestamp for hsa_amd_memory_async_copy
    /// \param dst Parameter passed to hsa_amd_memory_async_copy
    /// \param dst_agent Parameter passed to hsa_amd_memory_async_copy
    /// \param src Parameter passed to hsa_amd_memory_async_copy
    /// \param src_agent Parameter passed to hsa_amd_memory_async_copy
    /// \param size Parameter passed to hsa_amd_memory_async_copy
    /// \param num_dep_signals Parameter passed to hsa_amd_memory_async_copy
    /// \param dep_signals Parameter passed to hsa_amd_memory_async_copy
    /// \param completion_signal Parameter passed to hsa_amd_memory_async_copy
    /// \param asyncCopyIdentifier async copy identifier
    /// \param retVal the return value for hsa_amd_memory_async_copy
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                void* dst,
                hsa_agent_t dst_agent,
                const void* src,
                hsa_agent_t src_agent,
                size_t size,
                uint32_t num_dep_signals,
                const hsa_signal_t* dep_signals,
                hsa_signal_t completion_signal,
                ULONGLONG asyncCopyIdentifier,
                hsa_status_t retVal);

    /// Write timestamp entry
    /// \param sout output stream
    /// \param bTimeout a flag indicating output mode
    /// \return True if timestamps are ready
    bool WriteTimestampEntry(std::ostream& sout, bool bTimeout);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_memory_async_copy(const HSA_APITrace_hsa_amd_memory_async_copy& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_memory_async_copy& operator= (const HSA_APITrace_hsa_amd_memory_async_copy& rhs) = delete;

    void* m_dst; ///< Parameter passed to hsa_amd_memory_async_copy
    hsa_agent_t m_dst_agent; ///< Parameter passed to hsa_amd_memory_async_copy
    const void* m_src; ///< Parameter passed to hsa_amd_memory_async_copy
    hsa_agent_t m_src_agent; ///< Parameter passed to hsa_amd_memory_async_copy
    size_t m_size; ///< Parameter passed to hsa_amd_memory_async_copy
    uint32_t m_num_dep_signals; ///< Parameter passed to hsa_amd_memory_async_copy
    const hsa_signal_t* m_dep_signals; ///< Parameter passed to hsa_amd_memory_async_copy
    hsa_signal_t m_dep_signalsVal; ///< Member to hold value passed to hsa_amd_memory_async_copy in dep_signals parameter
    hsa_signal_t m_completion_signal; ///< Parameter passed to hsa_amd_memory_async_copy
    ULONGLONG m_asyncCopyIdentifier; ///< async copy identifier
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_memory_async_copy
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_memory_async_copy_rect
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_memory_async_copy_rect : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_memory_async_copy_rect();

    /// Destructor
    ~HSA_APITrace_hsa_amd_memory_async_copy_rect();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_memory_async_copy_rect
    /// \param ullEndTime the end timestamp for hsa_amd_memory_async_copy_rect
    /// \param dst Parameter passed to hsa_amd_memory_async_copy_rect
    /// \param dst_offset Parameter passed to hsa_amd_memory_async_copy_rect
    /// \param src Parameter passed to hsa_amd_memory_async_copy_rect
    /// \param src_offset Parameter passed to hsa_amd_memory_async_copy_rect
    /// \param range Parameter passed to hsa_amd_memory_async_copy_rect
    /// \param copy_agent Parameter passed to hsa_amd_memory_async_copy_rect
    /// \param dir Parameter passed to hsa_amd_memory_async_copy_rect
    /// \param num_dep_signals Parameter passed to hsa_amd_memory_async_copy_rect
    /// \param dep_signals Parameter passed to hsa_amd_memory_async_copy_rect
    /// \param completion_signal Parameter passed to hsa_amd_memory_async_copy_rect
    /// \param asyncCopyIdentifier async copy identifier
    /// \param retVal the return value for hsa_amd_memory_async_copy_rect
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_pitched_ptr_t* dst,
                const hsa_dim3_t* dst_offset,
                const hsa_pitched_ptr_t* src,
                const hsa_dim3_t* src_offset,
                const hsa_dim3_t* range,
                hsa_agent_t copy_agent,
                hsa_amd_copy_direction_t dir,
                uint32_t num_dep_signals,
                const hsa_signal_t* dep_signals,
                hsa_signal_t completion_signal,
                ULONGLONG asyncCopyIdentifier,
                hsa_status_t retVal);

    /// Write timestamp entry
    /// \param sout output stream
    /// \param bTimeout a flag indicating output mode
    /// \return True if timestamps are ready
    bool WriteTimestampEntry(std::ostream& sout, bool bTimeout);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_memory_async_copy_rect(const HSA_APITrace_hsa_amd_memory_async_copy_rect& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_memory_async_copy_rect& operator= (const HSA_APITrace_hsa_amd_memory_async_copy_rect& rhs) = delete;

    const hsa_pitched_ptr_t* m_dst; ///< Parameter passed to hsa_amd_memory_async_copy_rect
    hsa_pitched_ptr_t m_dstVal; ///< Member to hold value passed to hsa_amd_memory_async_copy_rect in dst parameter
    const hsa_dim3_t* m_dst_offset; ///< Parameter passed to hsa_amd_memory_async_copy_rect
    hsa_dim3_t m_dst_offsetVal; ///< Member to hold value passed to hsa_amd_memory_async_copy_rect in dst_offset parameter
    const hsa_pitched_ptr_t* m_src; ///< Parameter passed to hsa_amd_memory_async_copy_rect
    hsa_pitched_ptr_t m_srcVal; ///< Member to hold value passed to hsa_amd_memory_async_copy_rect in src parameter
    const hsa_dim3_t* m_src_offset; ///< Parameter passed to hsa_amd_memory_async_copy_rect
    hsa_dim3_t m_src_offsetVal; ///< Member to hold value passed to hsa_amd_memory_async_copy_rect in src_offset parameter
    const hsa_dim3_t* m_range; ///< Parameter passed to hsa_amd_memory_async_copy_rect
    hsa_dim3_t m_rangeVal; ///< Member to hold value passed to hsa_amd_memory_async_copy_rect in range parameter
    hsa_agent_t m_copy_agent; ///< Parameter passed to hsa_amd_memory_async_copy_rect
    hsa_amd_copy_direction_t m_dir; ///< Parameter passed to hsa_amd_memory_async_copy_rect
    uint32_t m_num_dep_signals; ///< Parameter passed to hsa_amd_memory_async_copy_rect
    const hsa_signal_t* m_dep_signals; ///< Parameter passed to hsa_amd_memory_async_copy_rect
    hsa_signal_t m_dep_signalsVal; ///< Member to hold value passed to hsa_amd_memory_async_copy_rect in dep_signals parameter
    hsa_signal_t m_completion_signal; ///< Parameter passed to hsa_amd_memory_async_copy_rect
    ULONGLONG m_asyncCopyIdentifier; ///< async copy identifier
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_memory_async_copy_rect
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_agent_memory_pool_get_info
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_agent_memory_pool_get_info : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_agent_memory_pool_get_info();

    /// Destructor
    ~HSA_APITrace_hsa_amd_agent_memory_pool_get_info();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_agent_memory_pool_get_info
    /// \param ullEndTime the end timestamp for hsa_amd_agent_memory_pool_get_info
    /// \param agent Parameter passed to hsa_amd_agent_memory_pool_get_info
    /// \param memory_pool Parameter passed to hsa_amd_agent_memory_pool_get_info
    /// \param attribute Parameter passed to hsa_amd_agent_memory_pool_get_info
    /// \param value Parameter passed to hsa_amd_agent_memory_pool_get_info
    /// \param retVal the return value for hsa_amd_agent_memory_pool_get_info
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_agent_t agent,
                hsa_amd_memory_pool_t memory_pool,
                hsa_amd_agent_memory_pool_info_t attribute,
                void* value,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_agent_memory_pool_get_info(const HSA_APITrace_hsa_amd_agent_memory_pool_get_info& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_agent_memory_pool_get_info& operator= (const HSA_APITrace_hsa_amd_agent_memory_pool_get_info& rhs) = delete;

    hsa_agent_t m_agent; ///< Parameter passed to hsa_amd_agent_memory_pool_get_info
    hsa_amd_memory_pool_t m_memory_pool; ///< Parameter passed to hsa_amd_agent_memory_pool_get_info
    hsa_amd_agent_memory_pool_info_t m_attribute; ///< Parameter passed to hsa_amd_agent_memory_pool_get_info
    void* m_value; ///< Parameter passed to hsa_amd_agent_memory_pool_get_info
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_agent_memory_pool_get_info
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_agents_allow_access
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_agents_allow_access : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_agents_allow_access();

    /// Destructor
    ~HSA_APITrace_hsa_amd_agents_allow_access();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_agents_allow_access
    /// \param ullEndTime the end timestamp for hsa_amd_agents_allow_access
    /// \param num_agents Parameter passed to hsa_amd_agents_allow_access
    /// \param agents Parameter passed to hsa_amd_agents_allow_access
    /// \param flags Parameter passed to hsa_amd_agents_allow_access
    /// \param ptr Parameter passed to hsa_amd_agents_allow_access
    /// \param retVal the return value for hsa_amd_agents_allow_access
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                uint32_t num_agents,
                const hsa_agent_t* agents,
                const uint32_t* flags,
                const void* ptr,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_agents_allow_access(const HSA_APITrace_hsa_amd_agents_allow_access& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_agents_allow_access& operator= (const HSA_APITrace_hsa_amd_agents_allow_access& rhs) = delete;

    uint32_t m_num_agents; ///< Parameter passed to hsa_amd_agents_allow_access
    const hsa_agent_t* m_agents; ///< Parameter passed to hsa_amd_agents_allow_access
    hsa_agent_t m_agentsVal; ///< Member to hold value passed to hsa_amd_agents_allow_access in agents parameter
    const uint32_t* m_flags; ///< Parameter passed to hsa_amd_agents_allow_access
    uint32_t m_flagsVal; ///< Member to hold value passed to hsa_amd_agents_allow_access in flags parameter
    const void* m_ptr; ///< Parameter passed to hsa_amd_agents_allow_access
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_agents_allow_access
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_memory_pool_can_migrate
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_memory_pool_can_migrate : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_memory_pool_can_migrate();

    /// Destructor
    ~HSA_APITrace_hsa_amd_memory_pool_can_migrate();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_memory_pool_can_migrate
    /// \param ullEndTime the end timestamp for hsa_amd_memory_pool_can_migrate
    /// \param src_memory_pool Parameter passed to hsa_amd_memory_pool_can_migrate
    /// \param dst_memory_pool Parameter passed to hsa_amd_memory_pool_can_migrate
    /// \param result Parameter passed to hsa_amd_memory_pool_can_migrate
    /// \param retVal the return value for hsa_amd_memory_pool_can_migrate
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_amd_memory_pool_t src_memory_pool,
                hsa_amd_memory_pool_t dst_memory_pool,
                bool* result,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_memory_pool_can_migrate(const HSA_APITrace_hsa_amd_memory_pool_can_migrate& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_memory_pool_can_migrate& operator= (const HSA_APITrace_hsa_amd_memory_pool_can_migrate& rhs) = delete;

    hsa_amd_memory_pool_t m_src_memory_pool; ///< Parameter passed to hsa_amd_memory_pool_can_migrate
    hsa_amd_memory_pool_t m_dst_memory_pool; ///< Parameter passed to hsa_amd_memory_pool_can_migrate
    bool* m_result; ///< Parameter passed to hsa_amd_memory_pool_can_migrate
    bool m_resultVal; ///< Member to hold value passed to hsa_amd_memory_pool_can_migrate in result parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_memory_pool_can_migrate
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_memory_migrate
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_memory_migrate : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_memory_migrate();

    /// Destructor
    ~HSA_APITrace_hsa_amd_memory_migrate();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_memory_migrate
    /// \param ullEndTime the end timestamp for hsa_amd_memory_migrate
    /// \param ptr Parameter passed to hsa_amd_memory_migrate
    /// \param memory_pool Parameter passed to hsa_amd_memory_migrate
    /// \param flags Parameter passed to hsa_amd_memory_migrate
    /// \param retVal the return value for hsa_amd_memory_migrate
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const void* ptr,
                hsa_amd_memory_pool_t memory_pool,
                uint32_t flags,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_memory_migrate(const HSA_APITrace_hsa_amd_memory_migrate& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_memory_migrate& operator= (const HSA_APITrace_hsa_amd_memory_migrate& rhs) = delete;

    const void* m_ptr; ///< Parameter passed to hsa_amd_memory_migrate
    hsa_amd_memory_pool_t m_memory_pool; ///< Parameter passed to hsa_amd_memory_migrate
    uint32_t m_flags; ///< Parameter passed to hsa_amd_memory_migrate
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_memory_migrate
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_memory_lock
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_memory_lock : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_memory_lock();

    /// Destructor
    ~HSA_APITrace_hsa_amd_memory_lock();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_memory_lock
    /// \param ullEndTime the end timestamp for hsa_amd_memory_lock
    /// \param host_ptr Parameter passed to hsa_amd_memory_lock
    /// \param size Parameter passed to hsa_amd_memory_lock
    /// \param agents Parameter passed to hsa_amd_memory_lock
    /// \param num_agent Parameter passed to hsa_amd_memory_lock
    /// \param agent_ptr Parameter passed to hsa_amd_memory_lock
    /// \param retVal the return value for hsa_amd_memory_lock
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                void* host_ptr,
                size_t size,
                hsa_agent_t* agents,
                int num_agent,
                void** agent_ptr,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_memory_lock(const HSA_APITrace_hsa_amd_memory_lock& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_memory_lock& operator= (const HSA_APITrace_hsa_amd_memory_lock& rhs) = delete;

    void* m_host_ptr; ///< Parameter passed to hsa_amd_memory_lock
    size_t m_size; ///< Parameter passed to hsa_amd_memory_lock
    hsa_agent_t* m_agents; ///< Parameter passed to hsa_amd_memory_lock
    hsa_agent_t m_agentsVal; ///< Member to hold value passed to hsa_amd_memory_lock in agents parameter
    int m_num_agent; ///< Parameter passed to hsa_amd_memory_lock
    void** m_agent_ptr; ///< Parameter passed to hsa_amd_memory_lock
    uintptr_t m_agent_ptrVal; ///< Member to hold value passed to hsa_amd_memory_lock in agent_ptr parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_memory_lock
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_memory_unlock
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_memory_unlock : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_memory_unlock();

    /// Destructor
    ~HSA_APITrace_hsa_amd_memory_unlock();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_memory_unlock
    /// \param ullEndTime the end timestamp for hsa_amd_memory_unlock
    /// \param host_ptr Parameter passed to hsa_amd_memory_unlock
    /// \param retVal the return value for hsa_amd_memory_unlock
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                void* host_ptr,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_memory_unlock(const HSA_APITrace_hsa_amd_memory_unlock& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_memory_unlock& operator= (const HSA_APITrace_hsa_amd_memory_unlock& rhs) = delete;

    void* m_host_ptr; ///< Parameter passed to hsa_amd_memory_unlock
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_memory_unlock
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_memory_fill
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_memory_fill : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_memory_fill();

    /// Destructor
    ~HSA_APITrace_hsa_amd_memory_fill();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_memory_fill
    /// \param ullEndTime the end timestamp for hsa_amd_memory_fill
    /// \param ptr Parameter passed to hsa_amd_memory_fill
    /// \param value Parameter passed to hsa_amd_memory_fill
    /// \param count Parameter passed to hsa_amd_memory_fill
    /// \param retVal the return value for hsa_amd_memory_fill
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                void* ptr,
                uint32_t value,
                size_t count,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_memory_fill(const HSA_APITrace_hsa_amd_memory_fill& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_memory_fill& operator= (const HSA_APITrace_hsa_amd_memory_fill& rhs) = delete;

    void* m_ptr; ///< Parameter passed to hsa_amd_memory_fill
    uint32_t m_value; ///< Parameter passed to hsa_amd_memory_fill
    size_t m_count; ///< Parameter passed to hsa_amd_memory_fill
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_memory_fill
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_interop_map_buffer
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_interop_map_buffer : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_interop_map_buffer();

    /// Destructor
    ~HSA_APITrace_hsa_amd_interop_map_buffer();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_interop_map_buffer
    /// \param ullEndTime the end timestamp for hsa_amd_interop_map_buffer
    /// \param num_agents Parameter passed to hsa_amd_interop_map_buffer
    /// \param agents Parameter passed to hsa_amd_interop_map_buffer
    /// \param interop_handle Parameter passed to hsa_amd_interop_map_buffer
    /// \param flags Parameter passed to hsa_amd_interop_map_buffer
    /// \param size Parameter passed to hsa_amd_interop_map_buffer
    /// \param ptr Parameter passed to hsa_amd_interop_map_buffer
    /// \param metadata_size Parameter passed to hsa_amd_interop_map_buffer
    /// \param metadata Parameter passed to hsa_amd_interop_map_buffer
    /// \param retVal the return value for hsa_amd_interop_map_buffer
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                uint32_t num_agents,
                hsa_agent_t* agents,
                int interop_handle,
                uint32_t flags,
                size_t* size,
                void** ptr,
                size_t* metadata_size,
                const void** metadata,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_interop_map_buffer(const HSA_APITrace_hsa_amd_interop_map_buffer& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_interop_map_buffer& operator= (const HSA_APITrace_hsa_amd_interop_map_buffer& rhs) = delete;

    uint32_t m_num_agents; ///< Parameter passed to hsa_amd_interop_map_buffer
    hsa_agent_t* m_agents; ///< Parameter passed to hsa_amd_interop_map_buffer
    hsa_agent_t m_agentsVal; ///< Member to hold value passed to hsa_amd_interop_map_buffer in agents parameter
    int m_interop_handle; ///< Parameter passed to hsa_amd_interop_map_buffer
    uint32_t m_flags; ///< Parameter passed to hsa_amd_interop_map_buffer
    size_t* m_size; ///< Parameter passed to hsa_amd_interop_map_buffer
    size_t m_sizeVal; ///< Member to hold value passed to hsa_amd_interop_map_buffer in size parameter
    void** m_ptr; ///< Parameter passed to hsa_amd_interop_map_buffer
    uintptr_t m_ptrVal; ///< Member to hold value passed to hsa_amd_interop_map_buffer in ptr parameter
    size_t* m_metadata_size; ///< Parameter passed to hsa_amd_interop_map_buffer
    size_t m_metadata_sizeVal; ///< Member to hold value passed to hsa_amd_interop_map_buffer in metadata_size parameter
    const void** m_metadata; ///< Parameter passed to hsa_amd_interop_map_buffer
    uintptr_t m_metadataVal; ///< Member to hold value passed to hsa_amd_interop_map_buffer in metadata parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_interop_map_buffer
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_interop_unmap_buffer
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_interop_unmap_buffer : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_interop_unmap_buffer();

    /// Destructor
    ~HSA_APITrace_hsa_amd_interop_unmap_buffer();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_interop_unmap_buffer
    /// \param ullEndTime the end timestamp for hsa_amd_interop_unmap_buffer
    /// \param ptr Parameter passed to hsa_amd_interop_unmap_buffer
    /// \param retVal the return value for hsa_amd_interop_unmap_buffer
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                void* ptr,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_interop_unmap_buffer(const HSA_APITrace_hsa_amd_interop_unmap_buffer& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_interop_unmap_buffer& operator= (const HSA_APITrace_hsa_amd_interop_unmap_buffer& rhs) = delete;

    void* m_ptr; ///< Parameter passed to hsa_amd_interop_unmap_buffer
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_interop_unmap_buffer
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_image_create
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_image_create : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_image_create();

    /// Destructor
    ~HSA_APITrace_hsa_amd_image_create();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_image_create
    /// \param ullEndTime the end timestamp for hsa_amd_image_create
    /// \param agent Parameter passed to hsa_amd_image_create
    /// \param image_descriptor Parameter passed to hsa_amd_image_create
    /// \param image_layout Parameter passed to hsa_amd_image_create
    /// \param image_data Parameter passed to hsa_amd_image_create
    /// \param access_permission Parameter passed to hsa_amd_image_create
    /// \param image Parameter passed to hsa_amd_image_create
    /// \param retVal the return value for hsa_amd_image_create
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_agent_t agent,
                const hsa_ext_image_descriptor_t* image_descriptor,
                const hsa_amd_image_descriptor_t* image_layout,
                const void* image_data,
                hsa_access_permission_t access_permission,
                hsa_ext_image_t* image,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_image_create(const HSA_APITrace_hsa_amd_image_create& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_image_create& operator= (const HSA_APITrace_hsa_amd_image_create& rhs) = delete;

    hsa_agent_t m_agent; ///< Parameter passed to hsa_amd_image_create
    const hsa_ext_image_descriptor_t* m_image_descriptor; ///< Parameter passed to hsa_amd_image_create
    hsa_ext_image_descriptor_t m_image_descriptorVal; ///< Member to hold value passed to hsa_amd_image_create in image_descriptor parameter
    const hsa_amd_image_descriptor_t* m_image_layout; ///< Parameter passed to hsa_amd_image_create
    hsa_amd_image_descriptor_t m_image_layoutVal; ///< Member to hold value passed to hsa_amd_image_create in image_layout parameter
    const void* m_image_data; ///< Parameter passed to hsa_amd_image_create
    hsa_access_permission_t m_access_permission; ///< Parameter passed to hsa_amd_image_create
    hsa_ext_image_t* m_image; ///< Parameter passed to hsa_amd_image_create
    hsa_ext_image_t m_imageVal; ///< Member to hold value passed to hsa_amd_image_create in image parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_image_create
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_pointer_info
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_pointer_info : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_pointer_info();

    /// Destructor
    ~HSA_APITrace_hsa_amd_pointer_info();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_pointer_info
    /// \param ullEndTime the end timestamp for hsa_amd_pointer_info
    /// \param ptr Parameter passed to hsa_amd_pointer_info
    /// \param info Parameter passed to hsa_amd_pointer_info
    /// \param alloc Parameter passed to hsa_amd_pointer_info
    /// \param num_agents_accessible Parameter passed to hsa_amd_pointer_info
    /// \param accessible Parameter passed to hsa_amd_pointer_info
    /// \param retVal the return value for hsa_amd_pointer_info
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                void* ptr,
                hsa_amd_pointer_info_t* info,
                void* (*alloc)(size_t),
                uint32_t* num_agents_accessible,
                hsa_agent_t** accessible,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_pointer_info(const HSA_APITrace_hsa_amd_pointer_info& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_pointer_info& operator= (const HSA_APITrace_hsa_amd_pointer_info& rhs) = delete;

    void* m_ptr; ///< Parameter passed to hsa_amd_pointer_info
    hsa_amd_pointer_info_t* m_info; ///< Parameter passed to hsa_amd_pointer_info
    hsa_amd_pointer_info_t m_infoVal; ///< Member to hold value passed to hsa_amd_pointer_info in info parameter
    void* (*m_alloc)(size_t); ///< Parameter passed to hsa_amd_pointer_info
    uint32_t* m_num_agents_accessible; ///< Parameter passed to hsa_amd_pointer_info
    uint32_t m_num_agents_accessibleVal; ///< Member to hold value passed to hsa_amd_pointer_info in num_agents_accessible parameter
    hsa_agent_t** m_accessible; ///< Parameter passed to hsa_amd_pointer_info
    hsa_agent_t m_accessibleVal; ///< Member to hold value passed to hsa_amd_pointer_info in accessible parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_pointer_info
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_pointer_info_set_userdata
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_pointer_info_set_userdata : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_pointer_info_set_userdata();

    /// Destructor
    ~HSA_APITrace_hsa_amd_pointer_info_set_userdata();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_pointer_info_set_userdata
    /// \param ullEndTime the end timestamp for hsa_amd_pointer_info_set_userdata
    /// \param ptr Parameter passed to hsa_amd_pointer_info_set_userdata
    /// \param userdata Parameter passed to hsa_amd_pointer_info_set_userdata
    /// \param retVal the return value for hsa_amd_pointer_info_set_userdata
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                void* ptr,
                void* userdata,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_pointer_info_set_userdata(const HSA_APITrace_hsa_amd_pointer_info_set_userdata& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_pointer_info_set_userdata& operator= (const HSA_APITrace_hsa_amd_pointer_info_set_userdata& rhs) = delete;

    void* m_ptr; ///< Parameter passed to hsa_amd_pointer_info_set_userdata
    void* m_userdata; ///< Parameter passed to hsa_amd_pointer_info_set_userdata
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_pointer_info_set_userdata
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_ipc_memory_create
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_ipc_memory_create : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_ipc_memory_create();

    /// Destructor
    ~HSA_APITrace_hsa_amd_ipc_memory_create();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_ipc_memory_create
    /// \param ullEndTime the end timestamp for hsa_amd_ipc_memory_create
    /// \param ptr Parameter passed to hsa_amd_ipc_memory_create
    /// \param len Parameter passed to hsa_amd_ipc_memory_create
    /// \param handle Parameter passed to hsa_amd_ipc_memory_create
    /// \param retVal the return value for hsa_amd_ipc_memory_create
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                void* ptr,
                size_t len,
                hsa_amd_ipc_memory_t* handle,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_ipc_memory_create(const HSA_APITrace_hsa_amd_ipc_memory_create& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_ipc_memory_create& operator= (const HSA_APITrace_hsa_amd_ipc_memory_create& rhs) = delete;

    void* m_ptr; ///< Parameter passed to hsa_amd_ipc_memory_create
    size_t m_len; ///< Parameter passed to hsa_amd_ipc_memory_create
    hsa_amd_ipc_memory_t* m_handle; ///< Parameter passed to hsa_amd_ipc_memory_create
    hsa_amd_ipc_memory_t m_handleVal; ///< Member to hold value passed to hsa_amd_ipc_memory_create in handle parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_ipc_memory_create
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_ipc_memory_attach
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_ipc_memory_attach : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_ipc_memory_attach();

    /// Destructor
    ~HSA_APITrace_hsa_amd_ipc_memory_attach();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_ipc_memory_attach
    /// \param ullEndTime the end timestamp for hsa_amd_ipc_memory_attach
    /// \param handle Parameter passed to hsa_amd_ipc_memory_attach
    /// \param len Parameter passed to hsa_amd_ipc_memory_attach
    /// \param num_agents Parameter passed to hsa_amd_ipc_memory_attach
    /// \param mapping_agents Parameter passed to hsa_amd_ipc_memory_attach
    /// \param mapped_ptr Parameter passed to hsa_amd_ipc_memory_attach
    /// \param retVal the return value for hsa_amd_ipc_memory_attach
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_amd_ipc_memory_t* handle,
                size_t len,
                uint32_t num_agents,
                const hsa_agent_t* mapping_agents,
                void** mapped_ptr,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_ipc_memory_attach(const HSA_APITrace_hsa_amd_ipc_memory_attach& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_ipc_memory_attach& operator= (const HSA_APITrace_hsa_amd_ipc_memory_attach& rhs) = delete;

    const hsa_amd_ipc_memory_t* m_handle; ///< Parameter passed to hsa_amd_ipc_memory_attach
    hsa_amd_ipc_memory_t m_handleVal; ///< Member to hold value passed to hsa_amd_ipc_memory_attach in handle parameter
    size_t m_len; ///< Parameter passed to hsa_amd_ipc_memory_attach
    uint32_t m_num_agents; ///< Parameter passed to hsa_amd_ipc_memory_attach
    const hsa_agent_t* m_mapping_agents; ///< Parameter passed to hsa_amd_ipc_memory_attach
    hsa_agent_t m_mapping_agentsVal; ///< Member to hold value passed to hsa_amd_ipc_memory_attach in mapping_agents parameter
    void** m_mapped_ptr; ///< Parameter passed to hsa_amd_ipc_memory_attach
    uintptr_t m_mapped_ptrVal; ///< Member to hold value passed to hsa_amd_ipc_memory_attach in mapped_ptr parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_ipc_memory_attach
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_ipc_memory_detach
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_ipc_memory_detach : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_ipc_memory_detach();

    /// Destructor
    ~HSA_APITrace_hsa_amd_ipc_memory_detach();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_ipc_memory_detach
    /// \param ullEndTime the end timestamp for hsa_amd_ipc_memory_detach
    /// \param mapped_ptr Parameter passed to hsa_amd_ipc_memory_detach
    /// \param retVal the return value for hsa_amd_ipc_memory_detach
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                void* mapped_ptr,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_ipc_memory_detach(const HSA_APITrace_hsa_amd_ipc_memory_detach& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_ipc_memory_detach& operator= (const HSA_APITrace_hsa_amd_ipc_memory_detach& rhs) = delete;

    void* m_mapped_ptr; ///< Parameter passed to hsa_amd_ipc_memory_detach
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_ipc_memory_detach
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_ipc_signal_create
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_ipc_signal_create : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_ipc_signal_create();

    /// Destructor
    ~HSA_APITrace_hsa_amd_ipc_signal_create();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_ipc_signal_create
    /// \param ullEndTime the end timestamp for hsa_amd_ipc_signal_create
    /// \param signal Parameter passed to hsa_amd_ipc_signal_create
    /// \param handle Parameter passed to hsa_amd_ipc_signal_create
    /// \param retVal the return value for hsa_amd_ipc_signal_create
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_amd_ipc_signal_t* handle,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_ipc_signal_create(const HSA_APITrace_hsa_amd_ipc_signal_create& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_ipc_signal_create& operator= (const HSA_APITrace_hsa_amd_ipc_signal_create& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_amd_ipc_signal_create
    hsa_amd_ipc_signal_t* m_handle; ///< Parameter passed to hsa_amd_ipc_signal_create
    hsa_amd_ipc_signal_t m_handleVal; ///< Member to hold value passed to hsa_amd_ipc_signal_create in handle parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_ipc_signal_create
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_ipc_signal_attach
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_ipc_signal_attach : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_ipc_signal_attach();

    /// Destructor
    ~HSA_APITrace_hsa_amd_ipc_signal_attach();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_ipc_signal_attach
    /// \param ullEndTime the end timestamp for hsa_amd_ipc_signal_attach
    /// \param handle Parameter passed to hsa_amd_ipc_signal_attach
    /// \param signal Parameter passed to hsa_amd_ipc_signal_attach
    /// \param retVal the return value for hsa_amd_ipc_signal_attach
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_amd_ipc_signal_t* handle,
                hsa_signal_t* signal,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_ipc_signal_attach(const HSA_APITrace_hsa_amd_ipc_signal_attach& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_ipc_signal_attach& operator= (const HSA_APITrace_hsa_amd_ipc_signal_attach& rhs) = delete;

    const hsa_amd_ipc_signal_t* m_handle; ///< Parameter passed to hsa_amd_ipc_signal_attach
    hsa_amd_ipc_signal_t m_handleVal; ///< Member to hold value passed to hsa_amd_ipc_signal_attach in handle parameter
    hsa_signal_t* m_signal; ///< Parameter passed to hsa_amd_ipc_signal_attach
    hsa_signal_t m_signalVal; ///< Member to hold value passed to hsa_amd_ipc_signal_attach in signal parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_ipc_signal_attach
};

///////////////////////////////////////////////////
/// Class used to trace hsa_amd_queue_set_priority
///////////////////////////////////////////////////
class HSA_APITrace_hsa_amd_queue_set_priority : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_amd_queue_set_priority();

    /// Destructor
    ~HSA_APITrace_hsa_amd_queue_set_priority();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_amd_queue_set_priority
    /// \param ullEndTime the end timestamp for hsa_amd_queue_set_priority
    /// \param queue Parameter passed to hsa_amd_queue_set_priority
    /// \param priority Parameter passed to hsa_amd_queue_set_priority
    /// \param retVal the return value for hsa_amd_queue_set_priority
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_queue_t* queue,
                hsa_amd_queue_priority_t priority,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_amd_queue_set_priority(const HSA_APITrace_hsa_amd_queue_set_priority& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_amd_queue_set_priority& operator= (const HSA_APITrace_hsa_amd_queue_set_priority& rhs) = delete;

    hsa_queue_t* m_queue; ///< Parameter passed to hsa_amd_queue_set_priority
    hsa_queue_t m_queueVal; ///< Member to hold value passed to hsa_amd_queue_set_priority in queue parameter
    hsa_amd_queue_priority_t m_priority; ///< Parameter passed to hsa_amd_queue_set_priority
    hsa_status_t m_retVal; ///< Parameter passed to hsa_amd_queue_set_priority
};



#endif // _HSAAMDEXTENSIONAPITRACECLASSES_H_

