//==============================================================================
// Copyright (c) 2015-2018 Advanced Micro Devices, Inc. All rights reserved.
/// \author AMD Developer Tools Team
/// \file
/// \brief THIS CODE WAS AUTOGENERATED BY HSA CODE GENERATOR
//==============================================================================

#ifndef _HSAAMDAQLPROFILEEXTENSIONAPITRACECLASSES_H_
#define _HSAAMDAQLPROFILEEXTENSIONAPITRACECLASSES_H_

#include "../HSAAPIBase.h"

///////////////////////////////////////////////////
/// Class used to trace hsa_ven_amd_aqlprofile_version_major
///////////////////////////////////////////////////
class HSA_APITrace_hsa_ven_amd_aqlprofile_version_major : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_ven_amd_aqlprofile_version_major();

    /// Destructor
    ~HSA_APITrace_hsa_ven_amd_aqlprofile_version_major();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_ven_amd_aqlprofile_version_major
    /// \param ullEndTime the end timestamp for hsa_ven_amd_aqlprofile_version_major
    /// \param retVal the return value for hsa_ven_amd_aqlprofile_version_major
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                uint32_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_ven_amd_aqlprofile_version_major(const HSA_APITrace_hsa_ven_amd_aqlprofile_version_major& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_ven_amd_aqlprofile_version_major& operator= (const HSA_APITrace_hsa_ven_amd_aqlprofile_version_major& rhs) = delete;

    uint32_t m_retVal; ///< Parameter passed to hsa_ven_amd_aqlprofile_version_major
};

///////////////////////////////////////////////////
/// Class used to trace hsa_ven_amd_aqlprofile_version_minor
///////////////////////////////////////////////////
class HSA_APITrace_hsa_ven_amd_aqlprofile_version_minor : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_ven_amd_aqlprofile_version_minor();

    /// Destructor
    ~HSA_APITrace_hsa_ven_amd_aqlprofile_version_minor();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_ven_amd_aqlprofile_version_minor
    /// \param ullEndTime the end timestamp for hsa_ven_amd_aqlprofile_version_minor
    /// \param retVal the return value for hsa_ven_amd_aqlprofile_version_minor
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                uint32_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_ven_amd_aqlprofile_version_minor(const HSA_APITrace_hsa_ven_amd_aqlprofile_version_minor& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_ven_amd_aqlprofile_version_minor& operator= (const HSA_APITrace_hsa_ven_amd_aqlprofile_version_minor& rhs) = delete;

    uint32_t m_retVal; ///< Parameter passed to hsa_ven_amd_aqlprofile_version_minor
};

///////////////////////////////////////////////////
/// Class used to trace hsa_ven_amd_aqlprofile_validate_event
///////////////////////////////////////////////////
class HSA_APITrace_hsa_ven_amd_aqlprofile_validate_event : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_ven_amd_aqlprofile_validate_event();

    /// Destructor
    ~HSA_APITrace_hsa_ven_amd_aqlprofile_validate_event();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_ven_amd_aqlprofile_validate_event
    /// \param ullEndTime the end timestamp for hsa_ven_amd_aqlprofile_validate_event
    /// \param agent Parameter passed to hsa_ven_amd_aqlprofile_validate_event
    /// \param event Parameter passed to hsa_ven_amd_aqlprofile_validate_event
    /// \param result Parameter passed to hsa_ven_amd_aqlprofile_validate_event
    /// \param retVal the return value for hsa_ven_amd_aqlprofile_validate_event
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_agent_t agent,
                const hsa_ven_amd_aqlprofile_event_t* event,
                bool* result,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_ven_amd_aqlprofile_validate_event(const HSA_APITrace_hsa_ven_amd_aqlprofile_validate_event& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_ven_amd_aqlprofile_validate_event& operator= (const HSA_APITrace_hsa_ven_amd_aqlprofile_validate_event& rhs) = delete;

    hsa_agent_t m_agent; ///< Parameter passed to hsa_ven_amd_aqlprofile_validate_event
    const hsa_ven_amd_aqlprofile_event_t* m_event; ///< Parameter passed to hsa_ven_amd_aqlprofile_validate_event
    hsa_ven_amd_aqlprofile_event_t m_eventVal; ///< Member to hold value passed to hsa_ven_amd_aqlprofile_validate_event in event parameter
    bool* m_result; ///< Parameter passed to hsa_ven_amd_aqlprofile_validate_event
    bool m_resultVal; ///< Member to hold value passed to hsa_ven_amd_aqlprofile_validate_event in result parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_ven_amd_aqlprofile_validate_event
};

///////////////////////////////////////////////////
/// Class used to trace hsa_ven_amd_aqlprofile_start
///////////////////////////////////////////////////
class HSA_APITrace_hsa_ven_amd_aqlprofile_start : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_ven_amd_aqlprofile_start();

    /// Destructor
    ~HSA_APITrace_hsa_ven_amd_aqlprofile_start();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_ven_amd_aqlprofile_start
    /// \param ullEndTime the end timestamp for hsa_ven_amd_aqlprofile_start
    /// \param profile Parameter passed to hsa_ven_amd_aqlprofile_start
    /// \param aql_start_packet Parameter passed to hsa_ven_amd_aqlprofile_start
    /// \param retVal the return value for hsa_ven_amd_aqlprofile_start
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_ven_amd_aqlprofile_profile_t* profile,
                hsa_ext_amd_aql_pm4_packet_t* aql_start_packet,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_ven_amd_aqlprofile_start(const HSA_APITrace_hsa_ven_amd_aqlprofile_start& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_ven_amd_aqlprofile_start& operator= (const HSA_APITrace_hsa_ven_amd_aqlprofile_start& rhs) = delete;

    hsa_ven_amd_aqlprofile_profile_t* m_profile; ///< Parameter passed to hsa_ven_amd_aqlprofile_start
    hsa_ven_amd_aqlprofile_profile_t m_profileVal; ///< Member to hold value passed to hsa_ven_amd_aqlprofile_start in profile parameter
    hsa_ext_amd_aql_pm4_packet_t* m_aql_start_packet; ///< Parameter passed to hsa_ven_amd_aqlprofile_start
    hsa_ext_amd_aql_pm4_packet_t m_aql_start_packetVal; ///< Member to hold value passed to hsa_ven_amd_aqlprofile_start in aql_start_packet parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_ven_amd_aqlprofile_start
};

///////////////////////////////////////////////////
/// Class used to trace hsa_ven_amd_aqlprofile_stop
///////////////////////////////////////////////////
class HSA_APITrace_hsa_ven_amd_aqlprofile_stop : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_ven_amd_aqlprofile_stop();

    /// Destructor
    ~HSA_APITrace_hsa_ven_amd_aqlprofile_stop();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_ven_amd_aqlprofile_stop
    /// \param ullEndTime the end timestamp for hsa_ven_amd_aqlprofile_stop
    /// \param profile Parameter passed to hsa_ven_amd_aqlprofile_stop
    /// \param aql_stop_packet Parameter passed to hsa_ven_amd_aqlprofile_stop
    /// \param retVal the return value for hsa_ven_amd_aqlprofile_stop
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_ven_amd_aqlprofile_profile_t* profile,
                hsa_ext_amd_aql_pm4_packet_t* aql_stop_packet,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_ven_amd_aqlprofile_stop(const HSA_APITrace_hsa_ven_amd_aqlprofile_stop& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_ven_amd_aqlprofile_stop& operator= (const HSA_APITrace_hsa_ven_amd_aqlprofile_stop& rhs) = delete;

    const hsa_ven_amd_aqlprofile_profile_t* m_profile; ///< Parameter passed to hsa_ven_amd_aqlprofile_stop
    hsa_ven_amd_aqlprofile_profile_t m_profileVal; ///< Member to hold value passed to hsa_ven_amd_aqlprofile_stop in profile parameter
    hsa_ext_amd_aql_pm4_packet_t* m_aql_stop_packet; ///< Parameter passed to hsa_ven_amd_aqlprofile_stop
    hsa_ext_amd_aql_pm4_packet_t m_aql_stop_packetVal; ///< Member to hold value passed to hsa_ven_amd_aqlprofile_stop in aql_stop_packet parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_ven_amd_aqlprofile_stop
};

///////////////////////////////////////////////////
/// Class used to trace hsa_ven_amd_aqlprofile_read
///////////////////////////////////////////////////
class HSA_APITrace_hsa_ven_amd_aqlprofile_read : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_ven_amd_aqlprofile_read();

    /// Destructor
    ~HSA_APITrace_hsa_ven_amd_aqlprofile_read();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_ven_amd_aqlprofile_read
    /// \param ullEndTime the end timestamp for hsa_ven_amd_aqlprofile_read
    /// \param profile Parameter passed to hsa_ven_amd_aqlprofile_read
    /// \param aql_read_packet Parameter passed to hsa_ven_amd_aqlprofile_read
    /// \param retVal the return value for hsa_ven_amd_aqlprofile_read
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_ven_amd_aqlprofile_profile_t* profile,
                hsa_ext_amd_aql_pm4_packet_t* aql_read_packet,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_ven_amd_aqlprofile_read(const HSA_APITrace_hsa_ven_amd_aqlprofile_read& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_ven_amd_aqlprofile_read& operator= (const HSA_APITrace_hsa_ven_amd_aqlprofile_read& rhs) = delete;

    const hsa_ven_amd_aqlprofile_profile_t* m_profile; ///< Parameter passed to hsa_ven_amd_aqlprofile_read
    hsa_ven_amd_aqlprofile_profile_t m_profileVal; ///< Member to hold value passed to hsa_ven_amd_aqlprofile_read in profile parameter
    hsa_ext_amd_aql_pm4_packet_t* m_aql_read_packet; ///< Parameter passed to hsa_ven_amd_aqlprofile_read
    hsa_ext_amd_aql_pm4_packet_t m_aql_read_packetVal; ///< Member to hold value passed to hsa_ven_amd_aqlprofile_read in aql_read_packet parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_ven_amd_aqlprofile_read
};

///////////////////////////////////////////////////
/// Class used to trace hsa_ven_amd_aqlprofile_legacy_get_pm4
///////////////////////////////////////////////////
class HSA_APITrace_hsa_ven_amd_aqlprofile_legacy_get_pm4 : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_ven_amd_aqlprofile_legacy_get_pm4();

    /// Destructor
    ~HSA_APITrace_hsa_ven_amd_aqlprofile_legacy_get_pm4();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_ven_amd_aqlprofile_legacy_get_pm4
    /// \param ullEndTime the end timestamp for hsa_ven_amd_aqlprofile_legacy_get_pm4
    /// \param aql_packet Parameter passed to hsa_ven_amd_aqlprofile_legacy_get_pm4
    /// \param data Parameter passed to hsa_ven_amd_aqlprofile_legacy_get_pm4
    /// \param retVal the return value for hsa_ven_amd_aqlprofile_legacy_get_pm4
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_ext_amd_aql_pm4_packet_t* aql_packet,
                void* data,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_ven_amd_aqlprofile_legacy_get_pm4(const HSA_APITrace_hsa_ven_amd_aqlprofile_legacy_get_pm4& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_ven_amd_aqlprofile_legacy_get_pm4& operator= (const HSA_APITrace_hsa_ven_amd_aqlprofile_legacy_get_pm4& rhs) = delete;

    const hsa_ext_amd_aql_pm4_packet_t* m_aql_packet; ///< Parameter passed to hsa_ven_amd_aqlprofile_legacy_get_pm4
    hsa_ext_amd_aql_pm4_packet_t m_aql_packetVal; ///< Member to hold value passed to hsa_ven_amd_aqlprofile_legacy_get_pm4 in aql_packet parameter
    void* m_data; ///< Parameter passed to hsa_ven_amd_aqlprofile_legacy_get_pm4
    hsa_status_t m_retVal; ///< Parameter passed to hsa_ven_amd_aqlprofile_legacy_get_pm4
};

///////////////////////////////////////////////////
/// Class used to trace hsa_ven_amd_aqlprofile_get_info
///////////////////////////////////////////////////
class HSA_APITrace_hsa_ven_amd_aqlprofile_get_info : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_ven_amd_aqlprofile_get_info();

    /// Destructor
    ~HSA_APITrace_hsa_ven_amd_aqlprofile_get_info();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_ven_amd_aqlprofile_get_info
    /// \param ullEndTime the end timestamp for hsa_ven_amd_aqlprofile_get_info
    /// \param profile Parameter passed to hsa_ven_amd_aqlprofile_get_info
    /// \param attribute Parameter passed to hsa_ven_amd_aqlprofile_get_info
    /// \param value Parameter passed to hsa_ven_amd_aqlprofile_get_info
    /// \param retVal the return value for hsa_ven_amd_aqlprofile_get_info
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_ven_amd_aqlprofile_profile_t* profile,
                hsa_ven_amd_aqlprofile_info_type_t attribute,
                void* value,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_ven_amd_aqlprofile_get_info(const HSA_APITrace_hsa_ven_amd_aqlprofile_get_info& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_ven_amd_aqlprofile_get_info& operator= (const HSA_APITrace_hsa_ven_amd_aqlprofile_get_info& rhs) = delete;

    const hsa_ven_amd_aqlprofile_profile_t* m_profile; ///< Parameter passed to hsa_ven_amd_aqlprofile_get_info
    hsa_ven_amd_aqlprofile_profile_t m_profileVal; ///< Member to hold value passed to hsa_ven_amd_aqlprofile_get_info in profile parameter
    hsa_ven_amd_aqlprofile_info_type_t m_attribute; ///< Parameter passed to hsa_ven_amd_aqlprofile_get_info
    void* m_value; ///< Parameter passed to hsa_ven_amd_aqlprofile_get_info
    hsa_status_t m_retVal; ///< Parameter passed to hsa_ven_amd_aqlprofile_get_info
};

///////////////////////////////////////////////////
/// Class used to trace hsa_ven_amd_aqlprofile_iterate_data
///////////////////////////////////////////////////
class HSA_APITrace_hsa_ven_amd_aqlprofile_iterate_data : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_ven_amd_aqlprofile_iterate_data();

    /// Destructor
    ~HSA_APITrace_hsa_ven_amd_aqlprofile_iterate_data();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_ven_amd_aqlprofile_iterate_data
    /// \param ullEndTime the end timestamp for hsa_ven_amd_aqlprofile_iterate_data
    /// \param profile Parameter passed to hsa_ven_amd_aqlprofile_iterate_data
    /// \param callback Parameter passed to hsa_ven_amd_aqlprofile_iterate_data
    /// \param data Parameter passed to hsa_ven_amd_aqlprofile_iterate_data
    /// \param retVal the return value for hsa_ven_amd_aqlprofile_iterate_data
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_ven_amd_aqlprofile_profile_t* profile,
                hsa_ven_amd_aqlprofile_data_callback_t callback,
                void* data,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_ven_amd_aqlprofile_iterate_data(const HSA_APITrace_hsa_ven_amd_aqlprofile_iterate_data& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_ven_amd_aqlprofile_iterate_data& operator= (const HSA_APITrace_hsa_ven_amd_aqlprofile_iterate_data& rhs) = delete;

    const hsa_ven_amd_aqlprofile_profile_t* m_profile; ///< Parameter passed to hsa_ven_amd_aqlprofile_iterate_data
    hsa_ven_amd_aqlprofile_profile_t m_profileVal; ///< Member to hold value passed to hsa_ven_amd_aqlprofile_iterate_data in profile parameter
    hsa_ven_amd_aqlprofile_data_callback_t m_callback; ///< Parameter passed to hsa_ven_amd_aqlprofile_iterate_data
    void* m_data; ///< Parameter passed to hsa_ven_amd_aqlprofile_iterate_data
    hsa_status_t m_retVal; ///< Parameter passed to hsa_ven_amd_aqlprofile_iterate_data
};

///////////////////////////////////////////////////
/// Class used to trace hsa_ven_amd_aqlprofile_error_string
///////////////////////////////////////////////////
class HSA_APITrace_hsa_ven_amd_aqlprofile_error_string : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_ven_amd_aqlprofile_error_string();

    /// Destructor
    ~HSA_APITrace_hsa_ven_amd_aqlprofile_error_string();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_ven_amd_aqlprofile_error_string
    /// \param ullEndTime the end timestamp for hsa_ven_amd_aqlprofile_error_string
    /// \param str Parameter passed to hsa_ven_amd_aqlprofile_error_string
    /// \param retVal the return value for hsa_ven_amd_aqlprofile_error_string
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const char** str,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_ven_amd_aqlprofile_error_string(const HSA_APITrace_hsa_ven_amd_aqlprofile_error_string& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_ven_amd_aqlprofile_error_string& operator= (const HSA_APITrace_hsa_ven_amd_aqlprofile_error_string& rhs) = delete;

    const char** m_str; ///< Parameter passed to hsa_ven_amd_aqlprofile_error_string
    std::string m_strVal; ///< Member to hold value passed to hsa_ven_amd_aqlprofile_error_string in str parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_ven_amd_aqlprofile_error_string
};



#endif // _HSAAMDAQLPROFILEEXTENSIONAPITRACECLASSES_H_

