//==============================================================================
// Copyright (c) 2015 Advanced Micro Devices, Inc. All rights reserved.
/// \author AMD Developer Tools Team
/// \file
/// \brief  This analyzer class analyzes hsa return codes; reports errors for failures
//==============================================================================

#ifndef _HSA_RET_CODE_ANALYZER_H_
#define _HSA_RET_CODE_ANALYZER_H_

#include "AutoGenerated/HSARetCodeAnalyzerHelper.h"
#include "HSAAPIAnalyzer.h"

//------------------------------------------------------------------------------------
/// HSA Return code analyzer
//------------------------------------------------------------------------------------
class HSARetCodeAnalyzer : public HSAAPIAnalyzer
{
public:
    /// Constructor
    HSARetCodeAnalyzer();

    /// Destructor
    ~HSARetCodeAnalyzer(void);

    /// Callback function for flattened APIs
    /// \param pAPIInfo APIInfo object
    void FlattenedAPIAnalyze(APIInfo* pAPIInfo);

    /// Analyze API
    /// \param pAPIInfo APIInfo object
    void Analyze(APIInfo* pAPIInfo);

    /// Generate APIAnalyzerMessage
    void EndAnalyze();

    /// Override clear
    void Clear();

private:
    /// Copy constructor
    /// \param obj object
    HSARetCodeAnalyzer(const HSARetCodeAnalyzer& obj);

    /// Assignment operator
    /// \param obj object
    /// \return ref to itself
    const HSARetCodeAnalyzer& operator = (const HSARetCodeAnalyzer& obj);

    /// set of HSA APIs that don't report status
    /// abscence from this list indicates an API's return value
    /// is the status
    HSAAPITypeSet m_noStatusAPIs;
};

#endif //_HSA_RET_CODE_ANALYZER_H_
