//==============================================================================
// Copyright (c) 2015-2018 Advanced Micro Devices, Inc. All rights reserved.
/// \author AMD Developer Tools Team
/// \file
/// \brief THIS CODE WAS AUTOGENERATED BY HSA CODE GENERATOR
//==============================================================================

#include "../HSATraceStringUtils.h"
#include "HSATraceStringOutput.h"

#include "HSAFinalizerExtensionAPITraceClasses.h"

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_ext_program_create
///////////////////////////////////////////////////

HSA_APITrace_hsa_ext_program_create::HSA_APITrace_hsa_ext_program_create()
{
}

HSA_APITrace_hsa_ext_program_create::~HSA_APITrace_hsa_ext_program_create()
{
}

std::string HSA_APITrace_hsa_ext_program_create::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_ext_program_create::ToString()
{
    std::ostringstream ss;
    ss << "machine_model=" << HSATraceStringUtils::Get_hsa_machine_model_t_String(m_machine_model) << s_strParamSeparator;
    ss << "profile=" << HSATraceStringUtils::Get_hsa_profile_t_String(m_profile) << s_strParamSeparator;
    ss << "default_float_rounding_mode=" << HSATraceStringUtils::Get_hsa_default_float_rounding_mode_t_String(m_default_float_rounding_mode) << s_strParamSeparator;
    ss << "options=" << HSATraceStringUtils::GetStringString(m_options, m_optionsVal) << s_strParamSeparator;
    ss << "program=" << HSATraceStringUtils::Get_hsa_ext_program_t_Ptr_String(m_program, m_programVal);
    return ss.str();
}

void HSA_APITrace_hsa_ext_program_create::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_machine_model_t machine_model,
    hsa_profile_t profile,
    hsa_default_float_rounding_mode_t default_float_rounding_mode,
    const char* options,
    hsa_ext_program_t* program,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_ext_program_create;
    m_machine_model = machine_model;
    m_profile = profile;
    m_default_float_rounding_mode = default_float_rounding_mode;
    m_options = options;

    if (nullptr != m_options)
    {
        m_optionsVal = std::string(m_options);
    }
    else
    {
        m_optionsVal = "";
    }

    m_program = program;

    if (nullptr != m_program)
    {
        m_programVal = *m_program;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_ext_program_destroy
///////////////////////////////////////////////////

HSA_APITrace_hsa_ext_program_destroy::HSA_APITrace_hsa_ext_program_destroy()
{
}

HSA_APITrace_hsa_ext_program_destroy::~HSA_APITrace_hsa_ext_program_destroy()
{
}

std::string HSA_APITrace_hsa_ext_program_destroy::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_ext_program_destroy::ToString()
{
    std::ostringstream ss;
    ss << "program=" << HSATraceStringUtils::Get_hsa_ext_program_t_String(m_program);
    return ss.str();
}

void HSA_APITrace_hsa_ext_program_destroy::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_ext_program_t program,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_ext_program_destroy;
    m_program = program;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_ext_program_add_module
///////////////////////////////////////////////////

HSA_APITrace_hsa_ext_program_add_module::HSA_APITrace_hsa_ext_program_add_module()
{
}

HSA_APITrace_hsa_ext_program_add_module::~HSA_APITrace_hsa_ext_program_add_module()
{
}

std::string HSA_APITrace_hsa_ext_program_add_module::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_ext_program_add_module::ToString()
{
    std::ostringstream ss;
    ss << "program=" << HSATraceStringUtils::Get_hsa_ext_program_t_String(m_program) << s_strParamSeparator;
    ss << "module=" << StringUtils::ToString(m_module);
    return ss.str();
}

void HSA_APITrace_hsa_ext_program_add_module::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_ext_program_t program,
    hsa_ext_module_t module,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_ext_program_add_module;
    m_program = program;
    m_module = module;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_ext_program_iterate_modules
///////////////////////////////////////////////////

HSA_APITrace_hsa_ext_program_iterate_modules::HSA_APITrace_hsa_ext_program_iterate_modules()
{
}

HSA_APITrace_hsa_ext_program_iterate_modules::~HSA_APITrace_hsa_ext_program_iterate_modules()
{
}

std::string HSA_APITrace_hsa_ext_program_iterate_modules::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_ext_program_iterate_modules::ToString()
{
    std::ostringstream ss;
    ss << "program=" << HSATraceStringUtils::Get_hsa_ext_program_t_String(m_program) << s_strParamSeparator;
    ss << "callback=" << StringUtils::ToString(reinterpret_cast<void*>(m_callback)) << s_strParamSeparator;
    ss << "data=" << StringUtils::ToHexString(m_data);
    return ss.str();
}

void HSA_APITrace_hsa_ext_program_iterate_modules::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_ext_program_t program,
    hsa_status_t (*callback)(hsa_ext_program_t program, hsa_ext_module_t module, void* data),
    void* data,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_ext_program_iterate_modules;
    m_program = program;
    m_callback = callback;
    m_data = data;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_ext_program_get_info
///////////////////////////////////////////////////

HSA_APITrace_hsa_ext_program_get_info::HSA_APITrace_hsa_ext_program_get_info() : m_value(nullptr)
{
}

HSA_APITrace_hsa_ext_program_get_info::~HSA_APITrace_hsa_ext_program_get_info()
{
    if (nullptr != m_value)
    {
        FreeBuffer(m_value);
    }
}

std::string HSA_APITrace_hsa_ext_program_get_info::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_ext_program_get_info::ToString()
{
    std::ostringstream ss;
    ss << "program=" << HSATraceStringUtils::Get_hsa_ext_program_t_String(m_program) << s_strParamSeparator;
    ss << "attribute=" << HSATraceStringUtils::Get_hsa_ext_program_info_t_String(m_attribute) << s_strParamSeparator;
    ss << "value=" << HSATraceStringUtils::Get_hsa_ext_program_get_info_AttributeString(m_value, m_attribute, m_retVal);
    return ss.str();
}

void HSA_APITrace_hsa_ext_program_get_info::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_ext_program_t program,
    hsa_ext_program_info_t attribute,
    void* value,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_ext_program_get_info;
    m_program = program;
    m_attribute = attribute;

    if (nullptr != value)
    {
        DeepCopyBuffer(&m_value, value, HSATraceStringUtils::Get_hsa_ext_program_get_info_AttributeSize(m_attribute));
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_ext_program_finalize
///////////////////////////////////////////////////

HSA_APITrace_hsa_ext_program_finalize::HSA_APITrace_hsa_ext_program_finalize()
{
}

HSA_APITrace_hsa_ext_program_finalize::~HSA_APITrace_hsa_ext_program_finalize()
{
}

std::string HSA_APITrace_hsa_ext_program_finalize::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_ext_program_finalize::ToString()
{
    std::ostringstream ss;
    ss << "program=" << HSATraceStringUtils::Get_hsa_ext_program_t_String(m_program) << s_strParamSeparator;
    ss << "isa=" << HSATraceStringUtils::Get_hsa_isa_t_String(m_isa) << s_strParamSeparator;
    ss << "call_convention=" << StringUtils::ToString(m_call_convention) << s_strParamSeparator;
    ss << "control_directives=" << HSATraceStringUtils::Get_hsa_ext_control_directives_t_String(m_control_directives) << s_strParamSeparator;
    ss << "options=" << HSATraceStringUtils::GetStringString(m_options, m_optionsVal) << s_strParamSeparator;
    ss << "code_object_type=" << HSATraceStringUtils::Get_hsa_code_object_type_t_String(m_code_object_type) << s_strParamSeparator;
    ss << "code_object=" << HSATraceStringUtils::Get_hsa_code_object_t_Ptr_String(m_code_object, m_code_objectVal);
    return ss.str();
}

void HSA_APITrace_hsa_ext_program_finalize::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_ext_program_t program,
    hsa_isa_t isa,
    int32_t call_convention,
    hsa_ext_control_directives_t control_directives,
    const char* options,
    hsa_code_object_type_t code_object_type,
    hsa_code_object_t* code_object,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_ext_program_finalize;
    m_program = program;
    m_isa = isa;
    m_call_convention = call_convention;
    m_control_directives = control_directives;
    m_options = options;

    if (nullptr != m_options)
    {
        m_optionsVal = std::string(m_options);
    }
    else
    {
        m_optionsVal = "";
    }

    m_code_object_type = code_object_type;
    m_code_object = code_object;

    if (nullptr != m_code_object)
    {
        m_code_objectVal = *m_code_object;
    }

    m_retVal = retVal;
}


