//==============================================================================
// Copyright (c) 2015-2018 Advanced Micro Devices, Inc. All rights reserved.
/// \author AMD Developer Tools Team
/// \file
/// \brief THIS CODE WAS AUTOGENERATED BY HSA CODE GENERATOR
//==============================================================================

#ifndef _HSACOREAPITRACECLASSES_H_
#define _HSACOREAPITRACECLASSES_H_

#include "../HSAAPIBase.h"

///////////////////////////////////////////////////
/// Class used to trace hsa_status_string
///////////////////////////////////////////////////
class HSA_APITrace_hsa_status_string : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_status_string();

    /// Destructor
    ~HSA_APITrace_hsa_status_string();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_status_string
    /// \param ullEndTime the end timestamp for hsa_status_string
    /// \param status Parameter passed to hsa_status_string
    /// \param status_string Parameter passed to hsa_status_string
    /// \param retVal the return value for hsa_status_string
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_status_t status,
                const char** status_string,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_status_string(const HSA_APITrace_hsa_status_string& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_status_string& operator= (const HSA_APITrace_hsa_status_string& rhs) = delete;

    hsa_status_t m_status; ///< Parameter passed to hsa_status_string
    const char** m_status_string; ///< Parameter passed to hsa_status_string
    std::string m_status_stringVal; ///< Member to hold value passed to hsa_status_string in status_string parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_status_string
};

///////////////////////////////////////////////////
/// Class used to trace hsa_init
///////////////////////////////////////////////////
class HSA_APITrace_hsa_init : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_init();

    /// Destructor
    ~HSA_APITrace_hsa_init();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_init
    /// \param ullEndTime the end timestamp for hsa_init
    /// \param retVal the return value for hsa_init
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_init(const HSA_APITrace_hsa_init& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_init& operator= (const HSA_APITrace_hsa_init& rhs) = delete;

    hsa_status_t m_retVal; ///< Parameter passed to hsa_init
};

///////////////////////////////////////////////////
/// Class used to trace hsa_shut_down
///////////////////////////////////////////////////
class HSA_APITrace_hsa_shut_down : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_shut_down();

    /// Destructor
    ~HSA_APITrace_hsa_shut_down();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_shut_down
    /// \param ullEndTime the end timestamp for hsa_shut_down
    /// \param retVal the return value for hsa_shut_down
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_shut_down(const HSA_APITrace_hsa_shut_down& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_shut_down& operator= (const HSA_APITrace_hsa_shut_down& rhs) = delete;

    hsa_status_t m_retVal; ///< Parameter passed to hsa_shut_down
};

///////////////////////////////////////////////////
/// Class used to trace hsa_system_get_info
///////////////////////////////////////////////////
class HSA_APITrace_hsa_system_get_info : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_system_get_info();

    /// Destructor
    ~HSA_APITrace_hsa_system_get_info();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_system_get_info
    /// \param ullEndTime the end timestamp for hsa_system_get_info
    /// \param attribute Parameter passed to hsa_system_get_info
    /// \param value Parameter passed to hsa_system_get_info
    /// \param retVal the return value for hsa_system_get_info
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_system_info_t attribute,
                void* value,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_system_get_info(const HSA_APITrace_hsa_system_get_info& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_system_get_info& operator= (const HSA_APITrace_hsa_system_get_info& rhs) = delete;

    hsa_system_info_t m_attribute; ///< Parameter passed to hsa_system_get_info
    void* m_value; ///< Parameter passed to hsa_system_get_info
    hsa_status_t m_retVal; ///< Parameter passed to hsa_system_get_info
};

///////////////////////////////////////////////////
/// Class used to trace hsa_extension_get_name
///////////////////////////////////////////////////
class HSA_APITrace_hsa_extension_get_name : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_extension_get_name();

    /// Destructor
    ~HSA_APITrace_hsa_extension_get_name();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_extension_get_name
    /// \param ullEndTime the end timestamp for hsa_extension_get_name
    /// \param extension Parameter passed to hsa_extension_get_name
    /// \param name Parameter passed to hsa_extension_get_name
    /// \param retVal the return value for hsa_extension_get_name
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                uint16_t extension,
                const char** name,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_extension_get_name(const HSA_APITrace_hsa_extension_get_name& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_extension_get_name& operator= (const HSA_APITrace_hsa_extension_get_name& rhs) = delete;

    uint16_t m_extension; ///< Parameter passed to hsa_extension_get_name
    const char** m_name; ///< Parameter passed to hsa_extension_get_name
    std::string m_nameVal; ///< Member to hold value passed to hsa_extension_get_name in name parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_extension_get_name
};

///////////////////////////////////////////////////
/// Class used to trace hsa_system_extension_supported
///////////////////////////////////////////////////
class HSA_APITrace_hsa_system_extension_supported : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_system_extension_supported();

    /// Destructor
    ~HSA_APITrace_hsa_system_extension_supported();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_system_extension_supported
    /// \param ullEndTime the end timestamp for hsa_system_extension_supported
    /// \param extension Parameter passed to hsa_system_extension_supported
    /// \param version_major Parameter passed to hsa_system_extension_supported
    /// \param version_minor Parameter passed to hsa_system_extension_supported
    /// \param result Parameter passed to hsa_system_extension_supported
    /// \param retVal the return value for hsa_system_extension_supported
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                uint16_t extension,
                uint16_t version_major,
                uint16_t version_minor,
                bool* result,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_system_extension_supported(const HSA_APITrace_hsa_system_extension_supported& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_system_extension_supported& operator= (const HSA_APITrace_hsa_system_extension_supported& rhs) = delete;

    uint16_t m_extension; ///< Parameter passed to hsa_system_extension_supported
    uint16_t m_version_major; ///< Parameter passed to hsa_system_extension_supported
    uint16_t m_version_minor; ///< Parameter passed to hsa_system_extension_supported
    bool* m_result; ///< Parameter passed to hsa_system_extension_supported
    bool m_resultVal; ///< Member to hold value passed to hsa_system_extension_supported in result parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_system_extension_supported
};

///////////////////////////////////////////////////
/// Class used to trace hsa_system_major_extension_supported
///////////////////////////////////////////////////
class HSA_APITrace_hsa_system_major_extension_supported : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_system_major_extension_supported();

    /// Destructor
    ~HSA_APITrace_hsa_system_major_extension_supported();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_system_major_extension_supported
    /// \param ullEndTime the end timestamp for hsa_system_major_extension_supported
    /// \param extension Parameter passed to hsa_system_major_extension_supported
    /// \param version_major Parameter passed to hsa_system_major_extension_supported
    /// \param version_minor Parameter passed to hsa_system_major_extension_supported
    /// \param result Parameter passed to hsa_system_major_extension_supported
    /// \param retVal the return value for hsa_system_major_extension_supported
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                uint16_t extension,
                uint16_t version_major,
                uint16_t* version_minor,
                bool* result,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_system_major_extension_supported(const HSA_APITrace_hsa_system_major_extension_supported& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_system_major_extension_supported& operator= (const HSA_APITrace_hsa_system_major_extension_supported& rhs) = delete;

    uint16_t m_extension; ///< Parameter passed to hsa_system_major_extension_supported
    uint16_t m_version_major; ///< Parameter passed to hsa_system_major_extension_supported
    uint16_t* m_version_minor; ///< Parameter passed to hsa_system_major_extension_supported
    uint16_t m_version_minorVal; ///< Member to hold value passed to hsa_system_major_extension_supported in version_minor parameter
    bool* m_result; ///< Parameter passed to hsa_system_major_extension_supported
    bool m_resultVal; ///< Member to hold value passed to hsa_system_major_extension_supported in result parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_system_major_extension_supported
};

///////////////////////////////////////////////////
/// Class used to trace hsa_system_get_extension_table
///////////////////////////////////////////////////
class HSA_APITrace_hsa_system_get_extension_table : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_system_get_extension_table();

    /// Destructor
    ~HSA_APITrace_hsa_system_get_extension_table();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_system_get_extension_table
    /// \param ullEndTime the end timestamp for hsa_system_get_extension_table
    /// \param extension Parameter passed to hsa_system_get_extension_table
    /// \param version_major Parameter passed to hsa_system_get_extension_table
    /// \param version_minor Parameter passed to hsa_system_get_extension_table
    /// \param table Parameter passed to hsa_system_get_extension_table
    /// \param retVal the return value for hsa_system_get_extension_table
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                uint16_t extension,
                uint16_t version_major,
                uint16_t version_minor,
                void* table,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_system_get_extension_table(const HSA_APITrace_hsa_system_get_extension_table& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_system_get_extension_table& operator= (const HSA_APITrace_hsa_system_get_extension_table& rhs) = delete;

    uint16_t m_extension; ///< Parameter passed to hsa_system_get_extension_table
    uint16_t m_version_major; ///< Parameter passed to hsa_system_get_extension_table
    uint16_t m_version_minor; ///< Parameter passed to hsa_system_get_extension_table
    void* m_table; ///< Parameter passed to hsa_system_get_extension_table
    hsa_status_t m_retVal; ///< Parameter passed to hsa_system_get_extension_table
};

///////////////////////////////////////////////////
/// Class used to trace hsa_system_get_major_extension_table
///////////////////////////////////////////////////
class HSA_APITrace_hsa_system_get_major_extension_table : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_system_get_major_extension_table();

    /// Destructor
    ~HSA_APITrace_hsa_system_get_major_extension_table();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_system_get_major_extension_table
    /// \param ullEndTime the end timestamp for hsa_system_get_major_extension_table
    /// \param extension Parameter passed to hsa_system_get_major_extension_table
    /// \param version_major Parameter passed to hsa_system_get_major_extension_table
    /// \param table_length Parameter passed to hsa_system_get_major_extension_table
    /// \param table Parameter passed to hsa_system_get_major_extension_table
    /// \param retVal the return value for hsa_system_get_major_extension_table
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                uint16_t extension,
                uint16_t version_major,
                size_t table_length,
                void* table,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_system_get_major_extension_table(const HSA_APITrace_hsa_system_get_major_extension_table& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_system_get_major_extension_table& operator= (const HSA_APITrace_hsa_system_get_major_extension_table& rhs) = delete;

    uint16_t m_extension; ///< Parameter passed to hsa_system_get_major_extension_table
    uint16_t m_version_major; ///< Parameter passed to hsa_system_get_major_extension_table
    size_t m_table_length; ///< Parameter passed to hsa_system_get_major_extension_table
    void* m_table; ///< Parameter passed to hsa_system_get_major_extension_table
    hsa_status_t m_retVal; ///< Parameter passed to hsa_system_get_major_extension_table
};

///////////////////////////////////////////////////
/// Class used to trace hsa_agent_get_info
///////////////////////////////////////////////////
class HSA_APITrace_hsa_agent_get_info : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_agent_get_info();

    /// Destructor
    ~HSA_APITrace_hsa_agent_get_info();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_agent_get_info
    /// \param ullEndTime the end timestamp for hsa_agent_get_info
    /// \param agent Parameter passed to hsa_agent_get_info
    /// \param attribute Parameter passed to hsa_agent_get_info
    /// \param value Parameter passed to hsa_agent_get_info
    /// \param retVal the return value for hsa_agent_get_info
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_agent_t agent,
                hsa_agent_info_t attribute,
                void* value,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_agent_get_info(const HSA_APITrace_hsa_agent_get_info& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_agent_get_info& operator= (const HSA_APITrace_hsa_agent_get_info& rhs) = delete;

    hsa_agent_t m_agent; ///< Parameter passed to hsa_agent_get_info
    hsa_agent_info_t m_attribute; ///< Parameter passed to hsa_agent_get_info
    void* m_value; ///< Parameter passed to hsa_agent_get_info
    hsa_status_t m_retVal; ///< Parameter passed to hsa_agent_get_info
};

///////////////////////////////////////////////////
/// Class used to trace hsa_iterate_agents
///////////////////////////////////////////////////
class HSA_APITrace_hsa_iterate_agents : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_iterate_agents();

    /// Destructor
    ~HSA_APITrace_hsa_iterate_agents();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_iterate_agents
    /// \param ullEndTime the end timestamp for hsa_iterate_agents
    /// \param callback Parameter passed to hsa_iterate_agents
    /// \param data Parameter passed to hsa_iterate_agents
    /// \param retVal the return value for hsa_iterate_agents
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_status_t (*callback)(hsa_agent_t agent, void* data),
                void* data,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_iterate_agents(const HSA_APITrace_hsa_iterate_agents& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_iterate_agents& operator= (const HSA_APITrace_hsa_iterate_agents& rhs) = delete;

    hsa_status_t (*m_callback)(hsa_agent_t agent, void* data); ///< Parameter passed to hsa_iterate_agents
    void* m_data; ///< Parameter passed to hsa_iterate_agents
    hsa_status_t m_retVal; ///< Parameter passed to hsa_iterate_agents
};

///////////////////////////////////////////////////
/// Class used to trace hsa_agent_get_exception_policies
///////////////////////////////////////////////////
class HSA_APITrace_hsa_agent_get_exception_policies : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_agent_get_exception_policies();

    /// Destructor
    ~HSA_APITrace_hsa_agent_get_exception_policies();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_agent_get_exception_policies
    /// \param ullEndTime the end timestamp for hsa_agent_get_exception_policies
    /// \param agent Parameter passed to hsa_agent_get_exception_policies
    /// \param profile Parameter passed to hsa_agent_get_exception_policies
    /// \param mask Parameter passed to hsa_agent_get_exception_policies
    /// \param retVal the return value for hsa_agent_get_exception_policies
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_agent_t agent,
                hsa_profile_t profile,
                uint16_t* mask,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_agent_get_exception_policies(const HSA_APITrace_hsa_agent_get_exception_policies& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_agent_get_exception_policies& operator= (const HSA_APITrace_hsa_agent_get_exception_policies& rhs) = delete;

    hsa_agent_t m_agent; ///< Parameter passed to hsa_agent_get_exception_policies
    hsa_profile_t m_profile; ///< Parameter passed to hsa_agent_get_exception_policies
    uint16_t* m_mask; ///< Parameter passed to hsa_agent_get_exception_policies
    uint16_t m_maskVal; ///< Member to hold value passed to hsa_agent_get_exception_policies in mask parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_agent_get_exception_policies
};

///////////////////////////////////////////////////
/// Class used to trace hsa_cache_get_info
///////////////////////////////////////////////////
class HSA_APITrace_hsa_cache_get_info : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_cache_get_info();

    /// Destructor
    ~HSA_APITrace_hsa_cache_get_info();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_cache_get_info
    /// \param ullEndTime the end timestamp for hsa_cache_get_info
    /// \param cache Parameter passed to hsa_cache_get_info
    /// \param attribute Parameter passed to hsa_cache_get_info
    /// \param value Parameter passed to hsa_cache_get_info
    /// \param retVal the return value for hsa_cache_get_info
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_cache_t cache,
                hsa_cache_info_t attribute,
                void* value,
                uint32_t valueLength,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_cache_get_info(const HSA_APITrace_hsa_cache_get_info& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_cache_get_info& operator= (const HSA_APITrace_hsa_cache_get_info& rhs) = delete;

    hsa_cache_t m_cache; ///< Parameter passed to hsa_cache_get_info
    hsa_cache_info_t m_attribute; ///< Parameter passed to hsa_cache_get_info
    void* m_value; ///< Parameter passed to hsa_cache_get_info
    hsa_status_t m_retVal; ///< Parameter passed to hsa_cache_get_info
};

///////////////////////////////////////////////////
/// Class used to trace hsa_agent_iterate_caches
///////////////////////////////////////////////////
class HSA_APITrace_hsa_agent_iterate_caches : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_agent_iterate_caches();

    /// Destructor
    ~HSA_APITrace_hsa_agent_iterate_caches();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_agent_iterate_caches
    /// \param ullEndTime the end timestamp for hsa_agent_iterate_caches
    /// \param agent Parameter passed to hsa_agent_iterate_caches
    /// \param callback Parameter passed to hsa_agent_iterate_caches
    /// \param data Parameter passed to hsa_agent_iterate_caches
    /// \param retVal the return value for hsa_agent_iterate_caches
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_agent_t agent,
                hsa_status_t (*callback)(hsa_cache_t cache, void* data),
                void* data,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_agent_iterate_caches(const HSA_APITrace_hsa_agent_iterate_caches& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_agent_iterate_caches& operator= (const HSA_APITrace_hsa_agent_iterate_caches& rhs) = delete;

    hsa_agent_t m_agent; ///< Parameter passed to hsa_agent_iterate_caches
    hsa_status_t (*m_callback)(hsa_cache_t cache, void* data); ///< Parameter passed to hsa_agent_iterate_caches
    void* m_data; ///< Parameter passed to hsa_agent_iterate_caches
    hsa_status_t m_retVal; ///< Parameter passed to hsa_agent_iterate_caches
};

///////////////////////////////////////////////////
/// Class used to trace hsa_agent_extension_supported
///////////////////////////////////////////////////
class HSA_APITrace_hsa_agent_extension_supported : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_agent_extension_supported();

    /// Destructor
    ~HSA_APITrace_hsa_agent_extension_supported();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_agent_extension_supported
    /// \param ullEndTime the end timestamp for hsa_agent_extension_supported
    /// \param extension Parameter passed to hsa_agent_extension_supported
    /// \param agent Parameter passed to hsa_agent_extension_supported
    /// \param version_major Parameter passed to hsa_agent_extension_supported
    /// \param version_minor Parameter passed to hsa_agent_extension_supported
    /// \param result Parameter passed to hsa_agent_extension_supported
    /// \param retVal the return value for hsa_agent_extension_supported
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                uint16_t extension,
                hsa_agent_t agent,
                uint16_t version_major,
                uint16_t version_minor,
                bool* result,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_agent_extension_supported(const HSA_APITrace_hsa_agent_extension_supported& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_agent_extension_supported& operator= (const HSA_APITrace_hsa_agent_extension_supported& rhs) = delete;

    uint16_t m_extension; ///< Parameter passed to hsa_agent_extension_supported
    hsa_agent_t m_agent; ///< Parameter passed to hsa_agent_extension_supported
    uint16_t m_version_major; ///< Parameter passed to hsa_agent_extension_supported
    uint16_t m_version_minor; ///< Parameter passed to hsa_agent_extension_supported
    bool* m_result; ///< Parameter passed to hsa_agent_extension_supported
    bool m_resultVal; ///< Member to hold value passed to hsa_agent_extension_supported in result parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_agent_extension_supported
};

///////////////////////////////////////////////////
/// Class used to trace hsa_agent_major_extension_supported
///////////////////////////////////////////////////
class HSA_APITrace_hsa_agent_major_extension_supported : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_agent_major_extension_supported();

    /// Destructor
    ~HSA_APITrace_hsa_agent_major_extension_supported();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_agent_major_extension_supported
    /// \param ullEndTime the end timestamp for hsa_agent_major_extension_supported
    /// \param extension Parameter passed to hsa_agent_major_extension_supported
    /// \param agent Parameter passed to hsa_agent_major_extension_supported
    /// \param version_major Parameter passed to hsa_agent_major_extension_supported
    /// \param version_minor Parameter passed to hsa_agent_major_extension_supported
    /// \param result Parameter passed to hsa_agent_major_extension_supported
    /// \param retVal the return value for hsa_agent_major_extension_supported
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                uint16_t extension,
                hsa_agent_t agent,
                uint16_t version_major,
                uint16_t* version_minor,
                bool* result,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_agent_major_extension_supported(const HSA_APITrace_hsa_agent_major_extension_supported& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_agent_major_extension_supported& operator= (const HSA_APITrace_hsa_agent_major_extension_supported& rhs) = delete;

    uint16_t m_extension; ///< Parameter passed to hsa_agent_major_extension_supported
    hsa_agent_t m_agent; ///< Parameter passed to hsa_agent_major_extension_supported
    uint16_t m_version_major; ///< Parameter passed to hsa_agent_major_extension_supported
    uint16_t* m_version_minor; ///< Parameter passed to hsa_agent_major_extension_supported
    uint16_t m_version_minorVal; ///< Member to hold value passed to hsa_agent_major_extension_supported in version_minor parameter
    bool* m_result; ///< Parameter passed to hsa_agent_major_extension_supported
    bool m_resultVal; ///< Member to hold value passed to hsa_agent_major_extension_supported in result parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_agent_major_extension_supported
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_create
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_create : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_create();

    /// Destructor
    ~HSA_APITrace_hsa_signal_create();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_create
    /// \param ullEndTime the end timestamp for hsa_signal_create
    /// \param initial_value Parameter passed to hsa_signal_create
    /// \param num_consumers Parameter passed to hsa_signal_create
    /// \param consumers Parameter passed to hsa_signal_create
    /// \param signal Parameter passed to hsa_signal_create
    /// \param retVal the return value for hsa_signal_create
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_value_t initial_value,
                uint32_t num_consumers,
                const hsa_agent_t* consumers,
                hsa_signal_t* signal,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_create(const HSA_APITrace_hsa_signal_create& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_create& operator= (const HSA_APITrace_hsa_signal_create& rhs) = delete;

    hsa_signal_value_t m_initial_value; ///< Parameter passed to hsa_signal_create
    uint32_t m_num_consumers; ///< Parameter passed to hsa_signal_create
    const hsa_agent_t* m_consumers; ///< Parameter passed to hsa_signal_create
    hsa_agent_t m_consumersVal; ///< Member to hold value passed to hsa_signal_create in consumers parameter
    hsa_signal_t* m_signal; ///< Parameter passed to hsa_signal_create
    hsa_signal_t m_signalVal; ///< Member to hold value passed to hsa_signal_create in signal parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_signal_create
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_destroy
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_destroy : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_destroy();

    /// Destructor
    ~HSA_APITrace_hsa_signal_destroy();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_destroy
    /// \param ullEndTime the end timestamp for hsa_signal_destroy
    /// \param signal Parameter passed to hsa_signal_destroy
    /// \param retVal the return value for hsa_signal_destroy
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_destroy(const HSA_APITrace_hsa_signal_destroy& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_destroy& operator= (const HSA_APITrace_hsa_signal_destroy& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_destroy
    hsa_status_t m_retVal; ///< Parameter passed to hsa_signal_destroy
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_load_scacquire
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_load_scacquire : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_load_scacquire();

    /// Destructor
    ~HSA_APITrace_hsa_signal_load_scacquire();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_load_scacquire
    /// \param ullEndTime the end timestamp for hsa_signal_load_scacquire
    /// \param signal Parameter passed to hsa_signal_load_scacquire
    /// \param retVal the return value for hsa_signal_load_scacquire
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_load_scacquire(const HSA_APITrace_hsa_signal_load_scacquire& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_load_scacquire& operator= (const HSA_APITrace_hsa_signal_load_scacquire& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_load_scacquire
    hsa_signal_value_t m_retVal; ///< Parameter passed to hsa_signal_load_scacquire
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_load_relaxed
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_load_relaxed : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_load_relaxed();

    /// Destructor
    ~HSA_APITrace_hsa_signal_load_relaxed();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_load_relaxed
    /// \param ullEndTime the end timestamp for hsa_signal_load_relaxed
    /// \param signal Parameter passed to hsa_signal_load_relaxed
    /// \param retVal the return value for hsa_signal_load_relaxed
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_load_relaxed(const HSA_APITrace_hsa_signal_load_relaxed& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_load_relaxed& operator= (const HSA_APITrace_hsa_signal_load_relaxed& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_load_relaxed
    hsa_signal_value_t m_retVal; ///< Parameter passed to hsa_signal_load_relaxed
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_store_relaxed
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_store_relaxed : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_store_relaxed();

    /// Destructor
    ~HSA_APITrace_hsa_signal_store_relaxed();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_store_relaxed
    /// \param ullEndTime the end timestamp for hsa_signal_store_relaxed
    /// \param signal Parameter passed to hsa_signal_store_relaxed
    /// \param value Parameter passed to hsa_signal_store_relaxed
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_store_relaxed(const HSA_APITrace_hsa_signal_store_relaxed& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_store_relaxed& operator= (const HSA_APITrace_hsa_signal_store_relaxed& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_store_relaxed
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_store_relaxed
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_store_screlease
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_store_screlease : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_store_screlease();

    /// Destructor
    ~HSA_APITrace_hsa_signal_store_screlease();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_store_screlease
    /// \param ullEndTime the end timestamp for hsa_signal_store_screlease
    /// \param signal Parameter passed to hsa_signal_store_screlease
    /// \param value Parameter passed to hsa_signal_store_screlease
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_store_screlease(const HSA_APITrace_hsa_signal_store_screlease& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_store_screlease& operator= (const HSA_APITrace_hsa_signal_store_screlease& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_store_screlease
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_store_screlease
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_silent_store_relaxed
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_silent_store_relaxed : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_silent_store_relaxed();

    /// Destructor
    ~HSA_APITrace_hsa_signal_silent_store_relaxed();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_silent_store_relaxed
    /// \param ullEndTime the end timestamp for hsa_signal_silent_store_relaxed
    /// \param signal Parameter passed to hsa_signal_silent_store_relaxed
    /// \param value Parameter passed to hsa_signal_silent_store_relaxed
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_silent_store_relaxed(const HSA_APITrace_hsa_signal_silent_store_relaxed& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_silent_store_relaxed& operator= (const HSA_APITrace_hsa_signal_silent_store_relaxed& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_silent_store_relaxed
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_silent_store_relaxed
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_silent_store_screlease
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_silent_store_screlease : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_silent_store_screlease();

    /// Destructor
    ~HSA_APITrace_hsa_signal_silent_store_screlease();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_silent_store_screlease
    /// \param ullEndTime the end timestamp for hsa_signal_silent_store_screlease
    /// \param signal Parameter passed to hsa_signal_silent_store_screlease
    /// \param value Parameter passed to hsa_signal_silent_store_screlease
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_silent_store_screlease(const HSA_APITrace_hsa_signal_silent_store_screlease& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_silent_store_screlease& operator= (const HSA_APITrace_hsa_signal_silent_store_screlease& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_silent_store_screlease
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_silent_store_screlease
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_exchange_scacq_screl
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_exchange_scacq_screl : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_exchange_scacq_screl();

    /// Destructor
    ~HSA_APITrace_hsa_signal_exchange_scacq_screl();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_exchange_scacq_screl
    /// \param ullEndTime the end timestamp for hsa_signal_exchange_scacq_screl
    /// \param signal Parameter passed to hsa_signal_exchange_scacq_screl
    /// \param value Parameter passed to hsa_signal_exchange_scacq_screl
    /// \param retVal the return value for hsa_signal_exchange_scacq_screl
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value,
                hsa_signal_value_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_exchange_scacq_screl(const HSA_APITrace_hsa_signal_exchange_scacq_screl& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_exchange_scacq_screl& operator= (const HSA_APITrace_hsa_signal_exchange_scacq_screl& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_exchange_scacq_screl
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_exchange_scacq_screl
    hsa_signal_value_t m_retVal; ///< Parameter passed to hsa_signal_exchange_scacq_screl
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_exchange_scacquire
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_exchange_scacquire : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_exchange_scacquire();

    /// Destructor
    ~HSA_APITrace_hsa_signal_exchange_scacquire();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_exchange_scacquire
    /// \param ullEndTime the end timestamp for hsa_signal_exchange_scacquire
    /// \param signal Parameter passed to hsa_signal_exchange_scacquire
    /// \param value Parameter passed to hsa_signal_exchange_scacquire
    /// \param retVal the return value for hsa_signal_exchange_scacquire
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value,
                hsa_signal_value_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_exchange_scacquire(const HSA_APITrace_hsa_signal_exchange_scacquire& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_exchange_scacquire& operator= (const HSA_APITrace_hsa_signal_exchange_scacquire& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_exchange_scacquire
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_exchange_scacquire
    hsa_signal_value_t m_retVal; ///< Parameter passed to hsa_signal_exchange_scacquire
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_exchange_relaxed
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_exchange_relaxed : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_exchange_relaxed();

    /// Destructor
    ~HSA_APITrace_hsa_signal_exchange_relaxed();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_exchange_relaxed
    /// \param ullEndTime the end timestamp for hsa_signal_exchange_relaxed
    /// \param signal Parameter passed to hsa_signal_exchange_relaxed
    /// \param value Parameter passed to hsa_signal_exchange_relaxed
    /// \param retVal the return value for hsa_signal_exchange_relaxed
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value,
                hsa_signal_value_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_exchange_relaxed(const HSA_APITrace_hsa_signal_exchange_relaxed& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_exchange_relaxed& operator= (const HSA_APITrace_hsa_signal_exchange_relaxed& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_exchange_relaxed
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_exchange_relaxed
    hsa_signal_value_t m_retVal; ///< Parameter passed to hsa_signal_exchange_relaxed
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_exchange_screlease
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_exchange_screlease : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_exchange_screlease();

    /// Destructor
    ~HSA_APITrace_hsa_signal_exchange_screlease();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_exchange_screlease
    /// \param ullEndTime the end timestamp for hsa_signal_exchange_screlease
    /// \param signal Parameter passed to hsa_signal_exchange_screlease
    /// \param value Parameter passed to hsa_signal_exchange_screlease
    /// \param retVal the return value for hsa_signal_exchange_screlease
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value,
                hsa_signal_value_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_exchange_screlease(const HSA_APITrace_hsa_signal_exchange_screlease& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_exchange_screlease& operator= (const HSA_APITrace_hsa_signal_exchange_screlease& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_exchange_screlease
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_exchange_screlease
    hsa_signal_value_t m_retVal; ///< Parameter passed to hsa_signal_exchange_screlease
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_cas_scacq_screl
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_cas_scacq_screl : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_cas_scacq_screl();

    /// Destructor
    ~HSA_APITrace_hsa_signal_cas_scacq_screl();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_cas_scacq_screl
    /// \param ullEndTime the end timestamp for hsa_signal_cas_scacq_screl
    /// \param signal Parameter passed to hsa_signal_cas_scacq_screl
    /// \param expected Parameter passed to hsa_signal_cas_scacq_screl
    /// \param value Parameter passed to hsa_signal_cas_scacq_screl
    /// \param retVal the return value for hsa_signal_cas_scacq_screl
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t expected,
                hsa_signal_value_t value,
                hsa_signal_value_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_cas_scacq_screl(const HSA_APITrace_hsa_signal_cas_scacq_screl& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_cas_scacq_screl& operator= (const HSA_APITrace_hsa_signal_cas_scacq_screl& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_cas_scacq_screl
    hsa_signal_value_t m_expected; ///< Parameter passed to hsa_signal_cas_scacq_screl
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_cas_scacq_screl
    hsa_signal_value_t m_retVal; ///< Parameter passed to hsa_signal_cas_scacq_screl
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_cas_scacquire
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_cas_scacquire : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_cas_scacquire();

    /// Destructor
    ~HSA_APITrace_hsa_signal_cas_scacquire();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_cas_scacquire
    /// \param ullEndTime the end timestamp for hsa_signal_cas_scacquire
    /// \param signal Parameter passed to hsa_signal_cas_scacquire
    /// \param expected Parameter passed to hsa_signal_cas_scacquire
    /// \param value Parameter passed to hsa_signal_cas_scacquire
    /// \param retVal the return value for hsa_signal_cas_scacquire
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t expected,
                hsa_signal_value_t value,
                hsa_signal_value_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_cas_scacquire(const HSA_APITrace_hsa_signal_cas_scacquire& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_cas_scacquire& operator= (const HSA_APITrace_hsa_signal_cas_scacquire& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_cas_scacquire
    hsa_signal_value_t m_expected; ///< Parameter passed to hsa_signal_cas_scacquire
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_cas_scacquire
    hsa_signal_value_t m_retVal; ///< Parameter passed to hsa_signal_cas_scacquire
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_cas_relaxed
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_cas_relaxed : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_cas_relaxed();

    /// Destructor
    ~HSA_APITrace_hsa_signal_cas_relaxed();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_cas_relaxed
    /// \param ullEndTime the end timestamp for hsa_signal_cas_relaxed
    /// \param signal Parameter passed to hsa_signal_cas_relaxed
    /// \param expected Parameter passed to hsa_signal_cas_relaxed
    /// \param value Parameter passed to hsa_signal_cas_relaxed
    /// \param retVal the return value for hsa_signal_cas_relaxed
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t expected,
                hsa_signal_value_t value,
                hsa_signal_value_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_cas_relaxed(const HSA_APITrace_hsa_signal_cas_relaxed& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_cas_relaxed& operator= (const HSA_APITrace_hsa_signal_cas_relaxed& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_cas_relaxed
    hsa_signal_value_t m_expected; ///< Parameter passed to hsa_signal_cas_relaxed
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_cas_relaxed
    hsa_signal_value_t m_retVal; ///< Parameter passed to hsa_signal_cas_relaxed
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_cas_screlease
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_cas_screlease : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_cas_screlease();

    /// Destructor
    ~HSA_APITrace_hsa_signal_cas_screlease();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_cas_screlease
    /// \param ullEndTime the end timestamp for hsa_signal_cas_screlease
    /// \param signal Parameter passed to hsa_signal_cas_screlease
    /// \param expected Parameter passed to hsa_signal_cas_screlease
    /// \param value Parameter passed to hsa_signal_cas_screlease
    /// \param retVal the return value for hsa_signal_cas_screlease
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t expected,
                hsa_signal_value_t value,
                hsa_signal_value_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_cas_screlease(const HSA_APITrace_hsa_signal_cas_screlease& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_cas_screlease& operator= (const HSA_APITrace_hsa_signal_cas_screlease& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_cas_screlease
    hsa_signal_value_t m_expected; ///< Parameter passed to hsa_signal_cas_screlease
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_cas_screlease
    hsa_signal_value_t m_retVal; ///< Parameter passed to hsa_signal_cas_screlease
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_add_scacq_screl
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_add_scacq_screl : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_add_scacq_screl();

    /// Destructor
    ~HSA_APITrace_hsa_signal_add_scacq_screl();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_add_scacq_screl
    /// \param ullEndTime the end timestamp for hsa_signal_add_scacq_screl
    /// \param signal Parameter passed to hsa_signal_add_scacq_screl
    /// \param value Parameter passed to hsa_signal_add_scacq_screl
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_add_scacq_screl(const HSA_APITrace_hsa_signal_add_scacq_screl& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_add_scacq_screl& operator= (const HSA_APITrace_hsa_signal_add_scacq_screl& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_add_scacq_screl
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_add_scacq_screl
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_add_scacquire
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_add_scacquire : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_add_scacquire();

    /// Destructor
    ~HSA_APITrace_hsa_signal_add_scacquire();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_add_scacquire
    /// \param ullEndTime the end timestamp for hsa_signal_add_scacquire
    /// \param signal Parameter passed to hsa_signal_add_scacquire
    /// \param value Parameter passed to hsa_signal_add_scacquire
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_add_scacquire(const HSA_APITrace_hsa_signal_add_scacquire& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_add_scacquire& operator= (const HSA_APITrace_hsa_signal_add_scacquire& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_add_scacquire
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_add_scacquire
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_add_relaxed
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_add_relaxed : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_add_relaxed();

    /// Destructor
    ~HSA_APITrace_hsa_signal_add_relaxed();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_add_relaxed
    /// \param ullEndTime the end timestamp for hsa_signal_add_relaxed
    /// \param signal Parameter passed to hsa_signal_add_relaxed
    /// \param value Parameter passed to hsa_signal_add_relaxed
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_add_relaxed(const HSA_APITrace_hsa_signal_add_relaxed& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_add_relaxed& operator= (const HSA_APITrace_hsa_signal_add_relaxed& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_add_relaxed
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_add_relaxed
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_add_screlease
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_add_screlease : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_add_screlease();

    /// Destructor
    ~HSA_APITrace_hsa_signal_add_screlease();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_add_screlease
    /// \param ullEndTime the end timestamp for hsa_signal_add_screlease
    /// \param signal Parameter passed to hsa_signal_add_screlease
    /// \param value Parameter passed to hsa_signal_add_screlease
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_add_screlease(const HSA_APITrace_hsa_signal_add_screlease& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_add_screlease& operator= (const HSA_APITrace_hsa_signal_add_screlease& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_add_screlease
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_add_screlease
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_subtract_scacq_screl
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_subtract_scacq_screl : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_subtract_scacq_screl();

    /// Destructor
    ~HSA_APITrace_hsa_signal_subtract_scacq_screl();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_subtract_scacq_screl
    /// \param ullEndTime the end timestamp for hsa_signal_subtract_scacq_screl
    /// \param signal Parameter passed to hsa_signal_subtract_scacq_screl
    /// \param value Parameter passed to hsa_signal_subtract_scacq_screl
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_subtract_scacq_screl(const HSA_APITrace_hsa_signal_subtract_scacq_screl& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_subtract_scacq_screl& operator= (const HSA_APITrace_hsa_signal_subtract_scacq_screl& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_subtract_scacq_screl
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_subtract_scacq_screl
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_subtract_scacquire
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_subtract_scacquire : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_subtract_scacquire();

    /// Destructor
    ~HSA_APITrace_hsa_signal_subtract_scacquire();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_subtract_scacquire
    /// \param ullEndTime the end timestamp for hsa_signal_subtract_scacquire
    /// \param signal Parameter passed to hsa_signal_subtract_scacquire
    /// \param value Parameter passed to hsa_signal_subtract_scacquire
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_subtract_scacquire(const HSA_APITrace_hsa_signal_subtract_scacquire& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_subtract_scacquire& operator= (const HSA_APITrace_hsa_signal_subtract_scacquire& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_subtract_scacquire
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_subtract_scacquire
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_subtract_relaxed
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_subtract_relaxed : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_subtract_relaxed();

    /// Destructor
    ~HSA_APITrace_hsa_signal_subtract_relaxed();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_subtract_relaxed
    /// \param ullEndTime the end timestamp for hsa_signal_subtract_relaxed
    /// \param signal Parameter passed to hsa_signal_subtract_relaxed
    /// \param value Parameter passed to hsa_signal_subtract_relaxed
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_subtract_relaxed(const HSA_APITrace_hsa_signal_subtract_relaxed& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_subtract_relaxed& operator= (const HSA_APITrace_hsa_signal_subtract_relaxed& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_subtract_relaxed
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_subtract_relaxed
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_subtract_screlease
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_subtract_screlease : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_subtract_screlease();

    /// Destructor
    ~HSA_APITrace_hsa_signal_subtract_screlease();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_subtract_screlease
    /// \param ullEndTime the end timestamp for hsa_signal_subtract_screlease
    /// \param signal Parameter passed to hsa_signal_subtract_screlease
    /// \param value Parameter passed to hsa_signal_subtract_screlease
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_subtract_screlease(const HSA_APITrace_hsa_signal_subtract_screlease& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_subtract_screlease& operator= (const HSA_APITrace_hsa_signal_subtract_screlease& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_subtract_screlease
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_subtract_screlease
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_and_scacq_screl
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_and_scacq_screl : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_and_scacq_screl();

    /// Destructor
    ~HSA_APITrace_hsa_signal_and_scacq_screl();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_and_scacq_screl
    /// \param ullEndTime the end timestamp for hsa_signal_and_scacq_screl
    /// \param signal Parameter passed to hsa_signal_and_scacq_screl
    /// \param value Parameter passed to hsa_signal_and_scacq_screl
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_and_scacq_screl(const HSA_APITrace_hsa_signal_and_scacq_screl& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_and_scacq_screl& operator= (const HSA_APITrace_hsa_signal_and_scacq_screl& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_and_scacq_screl
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_and_scacq_screl
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_and_scacquire
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_and_scacquire : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_and_scacquire();

    /// Destructor
    ~HSA_APITrace_hsa_signal_and_scacquire();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_and_scacquire
    /// \param ullEndTime the end timestamp for hsa_signal_and_scacquire
    /// \param signal Parameter passed to hsa_signal_and_scacquire
    /// \param value Parameter passed to hsa_signal_and_scacquire
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_and_scacquire(const HSA_APITrace_hsa_signal_and_scacquire& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_and_scacquire& operator= (const HSA_APITrace_hsa_signal_and_scacquire& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_and_scacquire
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_and_scacquire
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_and_relaxed
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_and_relaxed : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_and_relaxed();

    /// Destructor
    ~HSA_APITrace_hsa_signal_and_relaxed();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_and_relaxed
    /// \param ullEndTime the end timestamp for hsa_signal_and_relaxed
    /// \param signal Parameter passed to hsa_signal_and_relaxed
    /// \param value Parameter passed to hsa_signal_and_relaxed
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_and_relaxed(const HSA_APITrace_hsa_signal_and_relaxed& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_and_relaxed& operator= (const HSA_APITrace_hsa_signal_and_relaxed& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_and_relaxed
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_and_relaxed
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_and_screlease
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_and_screlease : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_and_screlease();

    /// Destructor
    ~HSA_APITrace_hsa_signal_and_screlease();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_and_screlease
    /// \param ullEndTime the end timestamp for hsa_signal_and_screlease
    /// \param signal Parameter passed to hsa_signal_and_screlease
    /// \param value Parameter passed to hsa_signal_and_screlease
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_and_screlease(const HSA_APITrace_hsa_signal_and_screlease& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_and_screlease& operator= (const HSA_APITrace_hsa_signal_and_screlease& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_and_screlease
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_and_screlease
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_or_scacq_screl
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_or_scacq_screl : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_or_scacq_screl();

    /// Destructor
    ~HSA_APITrace_hsa_signal_or_scacq_screl();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_or_scacq_screl
    /// \param ullEndTime the end timestamp for hsa_signal_or_scacq_screl
    /// \param signal Parameter passed to hsa_signal_or_scacq_screl
    /// \param value Parameter passed to hsa_signal_or_scacq_screl
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_or_scacq_screl(const HSA_APITrace_hsa_signal_or_scacq_screl& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_or_scacq_screl& operator= (const HSA_APITrace_hsa_signal_or_scacq_screl& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_or_scacq_screl
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_or_scacq_screl
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_or_scacquire
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_or_scacquire : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_or_scacquire();

    /// Destructor
    ~HSA_APITrace_hsa_signal_or_scacquire();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_or_scacquire
    /// \param ullEndTime the end timestamp for hsa_signal_or_scacquire
    /// \param signal Parameter passed to hsa_signal_or_scacquire
    /// \param value Parameter passed to hsa_signal_or_scacquire
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_or_scacquire(const HSA_APITrace_hsa_signal_or_scacquire& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_or_scacquire& operator= (const HSA_APITrace_hsa_signal_or_scacquire& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_or_scacquire
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_or_scacquire
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_or_relaxed
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_or_relaxed : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_or_relaxed();

    /// Destructor
    ~HSA_APITrace_hsa_signal_or_relaxed();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_or_relaxed
    /// \param ullEndTime the end timestamp for hsa_signal_or_relaxed
    /// \param signal Parameter passed to hsa_signal_or_relaxed
    /// \param value Parameter passed to hsa_signal_or_relaxed
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_or_relaxed(const HSA_APITrace_hsa_signal_or_relaxed& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_or_relaxed& operator= (const HSA_APITrace_hsa_signal_or_relaxed& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_or_relaxed
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_or_relaxed
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_or_screlease
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_or_screlease : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_or_screlease();

    /// Destructor
    ~HSA_APITrace_hsa_signal_or_screlease();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_or_screlease
    /// \param ullEndTime the end timestamp for hsa_signal_or_screlease
    /// \param signal Parameter passed to hsa_signal_or_screlease
    /// \param value Parameter passed to hsa_signal_or_screlease
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_or_screlease(const HSA_APITrace_hsa_signal_or_screlease& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_or_screlease& operator= (const HSA_APITrace_hsa_signal_or_screlease& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_or_screlease
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_or_screlease
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_xor_scacq_screl
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_xor_scacq_screl : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_xor_scacq_screl();

    /// Destructor
    ~HSA_APITrace_hsa_signal_xor_scacq_screl();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_xor_scacq_screl
    /// \param ullEndTime the end timestamp for hsa_signal_xor_scacq_screl
    /// \param signal Parameter passed to hsa_signal_xor_scacq_screl
    /// \param value Parameter passed to hsa_signal_xor_scacq_screl
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_xor_scacq_screl(const HSA_APITrace_hsa_signal_xor_scacq_screl& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_xor_scacq_screl& operator= (const HSA_APITrace_hsa_signal_xor_scacq_screl& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_xor_scacq_screl
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_xor_scacq_screl
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_xor_scacquire
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_xor_scacquire : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_xor_scacquire();

    /// Destructor
    ~HSA_APITrace_hsa_signal_xor_scacquire();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_xor_scacquire
    /// \param ullEndTime the end timestamp for hsa_signal_xor_scacquire
    /// \param signal Parameter passed to hsa_signal_xor_scacquire
    /// \param value Parameter passed to hsa_signal_xor_scacquire
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_xor_scacquire(const HSA_APITrace_hsa_signal_xor_scacquire& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_xor_scacquire& operator= (const HSA_APITrace_hsa_signal_xor_scacquire& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_xor_scacquire
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_xor_scacquire
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_xor_relaxed
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_xor_relaxed : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_xor_relaxed();

    /// Destructor
    ~HSA_APITrace_hsa_signal_xor_relaxed();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_xor_relaxed
    /// \param ullEndTime the end timestamp for hsa_signal_xor_relaxed
    /// \param signal Parameter passed to hsa_signal_xor_relaxed
    /// \param value Parameter passed to hsa_signal_xor_relaxed
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_xor_relaxed(const HSA_APITrace_hsa_signal_xor_relaxed& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_xor_relaxed& operator= (const HSA_APITrace_hsa_signal_xor_relaxed& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_xor_relaxed
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_xor_relaxed
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_xor_screlease
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_xor_screlease : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_xor_screlease();

    /// Destructor
    ~HSA_APITrace_hsa_signal_xor_screlease();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_xor_screlease
    /// \param ullEndTime the end timestamp for hsa_signal_xor_screlease
    /// \param signal Parameter passed to hsa_signal_xor_screlease
    /// \param value Parameter passed to hsa_signal_xor_screlease
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_value_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_xor_screlease(const HSA_APITrace_hsa_signal_xor_screlease& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_xor_screlease& operator= (const HSA_APITrace_hsa_signal_xor_screlease& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_xor_screlease
    hsa_signal_value_t m_value; ///< Parameter passed to hsa_signal_xor_screlease
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_wait_scacquire
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_wait_scacquire : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_wait_scacquire();

    /// Destructor
    ~HSA_APITrace_hsa_signal_wait_scacquire();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_wait_scacquire
    /// \param ullEndTime the end timestamp for hsa_signal_wait_scacquire
    /// \param signal Parameter passed to hsa_signal_wait_scacquire
    /// \param condition Parameter passed to hsa_signal_wait_scacquire
    /// \param compare_value Parameter passed to hsa_signal_wait_scacquire
    /// \param timeout_hint Parameter passed to hsa_signal_wait_scacquire
    /// \param wait_state_hint Parameter passed to hsa_signal_wait_scacquire
    /// \param retVal the return value for hsa_signal_wait_scacquire
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_condition_t condition,
                hsa_signal_value_t compare_value,
                uint64_t timeout_hint,
                hsa_wait_state_t wait_state_hint,
                hsa_signal_value_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_wait_scacquire(const HSA_APITrace_hsa_signal_wait_scacquire& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_wait_scacquire& operator= (const HSA_APITrace_hsa_signal_wait_scacquire& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_wait_scacquire
    hsa_signal_condition_t m_condition; ///< Parameter passed to hsa_signal_wait_scacquire
    hsa_signal_value_t m_compare_value; ///< Parameter passed to hsa_signal_wait_scacquire
    uint64_t m_timeout_hint; ///< Parameter passed to hsa_signal_wait_scacquire
    hsa_wait_state_t m_wait_state_hint; ///< Parameter passed to hsa_signal_wait_scacquire
    hsa_signal_value_t m_retVal; ///< Parameter passed to hsa_signal_wait_scacquire
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_wait_relaxed
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_wait_relaxed : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_wait_relaxed();

    /// Destructor
    ~HSA_APITrace_hsa_signal_wait_relaxed();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_wait_relaxed
    /// \param ullEndTime the end timestamp for hsa_signal_wait_relaxed
    /// \param signal Parameter passed to hsa_signal_wait_relaxed
    /// \param condition Parameter passed to hsa_signal_wait_relaxed
    /// \param compare_value Parameter passed to hsa_signal_wait_relaxed
    /// \param timeout_hint Parameter passed to hsa_signal_wait_relaxed
    /// \param wait_state_hint Parameter passed to hsa_signal_wait_relaxed
    /// \param retVal the return value for hsa_signal_wait_relaxed
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_t signal,
                hsa_signal_condition_t condition,
                hsa_signal_value_t compare_value,
                uint64_t timeout_hint,
                hsa_wait_state_t wait_state_hint,
                hsa_signal_value_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_wait_relaxed(const HSA_APITrace_hsa_signal_wait_relaxed& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_wait_relaxed& operator= (const HSA_APITrace_hsa_signal_wait_relaxed& rhs) = delete;

    hsa_signal_t m_signal; ///< Parameter passed to hsa_signal_wait_relaxed
    hsa_signal_condition_t m_condition; ///< Parameter passed to hsa_signal_wait_relaxed
    hsa_signal_value_t m_compare_value; ///< Parameter passed to hsa_signal_wait_relaxed
    uint64_t m_timeout_hint; ///< Parameter passed to hsa_signal_wait_relaxed
    hsa_wait_state_t m_wait_state_hint; ///< Parameter passed to hsa_signal_wait_relaxed
    hsa_signal_value_t m_retVal; ///< Parameter passed to hsa_signal_wait_relaxed
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_group_create
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_group_create : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_group_create();

    /// Destructor
    ~HSA_APITrace_hsa_signal_group_create();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_group_create
    /// \param ullEndTime the end timestamp for hsa_signal_group_create
    /// \param num_signals Parameter passed to hsa_signal_group_create
    /// \param signals Parameter passed to hsa_signal_group_create
    /// \param num_consumers Parameter passed to hsa_signal_group_create
    /// \param consumers Parameter passed to hsa_signal_group_create
    /// \param signal_group Parameter passed to hsa_signal_group_create
    /// \param retVal the return value for hsa_signal_group_create
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                uint32_t num_signals,
                const hsa_signal_t* signals,
                uint32_t num_consumers,
                const hsa_agent_t* consumers,
                hsa_signal_group_t* signal_group,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_group_create(const HSA_APITrace_hsa_signal_group_create& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_group_create& operator= (const HSA_APITrace_hsa_signal_group_create& rhs) = delete;

    uint32_t m_num_signals; ///< Parameter passed to hsa_signal_group_create
    const hsa_signal_t* m_signals; ///< Parameter passed to hsa_signal_group_create
    hsa_signal_t m_signalsVal; ///< Member to hold value passed to hsa_signal_group_create in signals parameter
    uint32_t m_num_consumers; ///< Parameter passed to hsa_signal_group_create
    const hsa_agent_t* m_consumers; ///< Parameter passed to hsa_signal_group_create
    hsa_agent_t m_consumersVal; ///< Member to hold value passed to hsa_signal_group_create in consumers parameter
    hsa_signal_group_t* m_signal_group; ///< Parameter passed to hsa_signal_group_create
    hsa_signal_group_t m_signal_groupVal; ///< Member to hold value passed to hsa_signal_group_create in signal_group parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_signal_group_create
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_group_destroy
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_group_destroy : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_group_destroy();

    /// Destructor
    ~HSA_APITrace_hsa_signal_group_destroy();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_group_destroy
    /// \param ullEndTime the end timestamp for hsa_signal_group_destroy
    /// \param signal_group Parameter passed to hsa_signal_group_destroy
    /// \param retVal the return value for hsa_signal_group_destroy
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_group_t signal_group,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_group_destroy(const HSA_APITrace_hsa_signal_group_destroy& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_group_destroy& operator= (const HSA_APITrace_hsa_signal_group_destroy& rhs) = delete;

    hsa_signal_group_t m_signal_group; ///< Parameter passed to hsa_signal_group_destroy
    hsa_status_t m_retVal; ///< Parameter passed to hsa_signal_group_destroy
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_group_wait_any_scacquire
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_group_wait_any_scacquire : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_group_wait_any_scacquire();

    /// Destructor
    ~HSA_APITrace_hsa_signal_group_wait_any_scacquire();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_group_wait_any_scacquire
    /// \param ullEndTime the end timestamp for hsa_signal_group_wait_any_scacquire
    /// \param signal_group Parameter passed to hsa_signal_group_wait_any_scacquire
    /// \param conditions Parameter passed to hsa_signal_group_wait_any_scacquire
    /// \param compare_values Parameter passed to hsa_signal_group_wait_any_scacquire
    /// \param wait_state_hint Parameter passed to hsa_signal_group_wait_any_scacquire
    /// \param signal Parameter passed to hsa_signal_group_wait_any_scacquire
    /// \param value Parameter passed to hsa_signal_group_wait_any_scacquire
    /// \param retVal the return value for hsa_signal_group_wait_any_scacquire
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_group_t signal_group,
                const hsa_signal_condition_t* conditions,
                const hsa_signal_value_t* compare_values,
                hsa_wait_state_t wait_state_hint,
                hsa_signal_t* signal,
                hsa_signal_value_t* value,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_group_wait_any_scacquire(const HSA_APITrace_hsa_signal_group_wait_any_scacquire& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_group_wait_any_scacquire& operator= (const HSA_APITrace_hsa_signal_group_wait_any_scacquire& rhs) = delete;

    hsa_signal_group_t m_signal_group; ///< Parameter passed to hsa_signal_group_wait_any_scacquire
    const hsa_signal_condition_t* m_conditions; ///< Parameter passed to hsa_signal_group_wait_any_scacquire
    hsa_signal_condition_t m_conditionsVal; ///< Member to hold value passed to hsa_signal_group_wait_any_scacquire in conditions parameter
    const hsa_signal_value_t* m_compare_values; ///< Parameter passed to hsa_signal_group_wait_any_scacquire
    hsa_signal_value_t m_compare_valuesVal; ///< Member to hold value passed to hsa_signal_group_wait_any_scacquire in compare_values parameter
    hsa_wait_state_t m_wait_state_hint; ///< Parameter passed to hsa_signal_group_wait_any_scacquire
    hsa_signal_t* m_signal; ///< Parameter passed to hsa_signal_group_wait_any_scacquire
    hsa_signal_t m_signalVal; ///< Member to hold value passed to hsa_signal_group_wait_any_scacquire in signal parameter
    hsa_signal_value_t* m_value; ///< Parameter passed to hsa_signal_group_wait_any_scacquire
    hsa_signal_value_t m_valueVal; ///< Member to hold value passed to hsa_signal_group_wait_any_scacquire in value parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_signal_group_wait_any_scacquire
};

///////////////////////////////////////////////////
/// Class used to trace hsa_signal_group_wait_any_relaxed
///////////////////////////////////////////////////
class HSA_APITrace_hsa_signal_group_wait_any_relaxed : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_signal_group_wait_any_relaxed();

    /// Destructor
    ~HSA_APITrace_hsa_signal_group_wait_any_relaxed();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_signal_group_wait_any_relaxed
    /// \param ullEndTime the end timestamp for hsa_signal_group_wait_any_relaxed
    /// \param signal_group Parameter passed to hsa_signal_group_wait_any_relaxed
    /// \param conditions Parameter passed to hsa_signal_group_wait_any_relaxed
    /// \param compare_values Parameter passed to hsa_signal_group_wait_any_relaxed
    /// \param wait_state_hint Parameter passed to hsa_signal_group_wait_any_relaxed
    /// \param signal Parameter passed to hsa_signal_group_wait_any_relaxed
    /// \param value Parameter passed to hsa_signal_group_wait_any_relaxed
    /// \param retVal the return value for hsa_signal_group_wait_any_relaxed
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_signal_group_t signal_group,
                const hsa_signal_condition_t* conditions,
                const hsa_signal_value_t* compare_values,
                hsa_wait_state_t wait_state_hint,
                hsa_signal_t* signal,
                hsa_signal_value_t* value,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_signal_group_wait_any_relaxed(const HSA_APITrace_hsa_signal_group_wait_any_relaxed& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_signal_group_wait_any_relaxed& operator= (const HSA_APITrace_hsa_signal_group_wait_any_relaxed& rhs) = delete;

    hsa_signal_group_t m_signal_group; ///< Parameter passed to hsa_signal_group_wait_any_relaxed
    const hsa_signal_condition_t* m_conditions; ///< Parameter passed to hsa_signal_group_wait_any_relaxed
    hsa_signal_condition_t m_conditionsVal; ///< Member to hold value passed to hsa_signal_group_wait_any_relaxed in conditions parameter
    const hsa_signal_value_t* m_compare_values; ///< Parameter passed to hsa_signal_group_wait_any_relaxed
    hsa_signal_value_t m_compare_valuesVal; ///< Member to hold value passed to hsa_signal_group_wait_any_relaxed in compare_values parameter
    hsa_wait_state_t m_wait_state_hint; ///< Parameter passed to hsa_signal_group_wait_any_relaxed
    hsa_signal_t* m_signal; ///< Parameter passed to hsa_signal_group_wait_any_relaxed
    hsa_signal_t m_signalVal; ///< Member to hold value passed to hsa_signal_group_wait_any_relaxed in signal parameter
    hsa_signal_value_t* m_value; ///< Parameter passed to hsa_signal_group_wait_any_relaxed
    hsa_signal_value_t m_valueVal; ///< Member to hold value passed to hsa_signal_group_wait_any_relaxed in value parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_signal_group_wait_any_relaxed
};

///////////////////////////////////////////////////
/// Class used to trace hsa_queue_create
///////////////////////////////////////////////////
class HSA_APITrace_hsa_queue_create : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_queue_create();

    /// Destructor
    ~HSA_APITrace_hsa_queue_create();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_queue_create
    /// \param ullEndTime the end timestamp for hsa_queue_create
    /// \param agent Parameter passed to hsa_queue_create
    /// \param size Parameter passed to hsa_queue_create
    /// \param type_ Parameter passed to hsa_queue_create
    /// \param callback Parameter passed to hsa_queue_create
    /// \param data Parameter passed to hsa_queue_create
    /// \param private_segment_size Parameter passed to hsa_queue_create
    /// \param group_segment_size Parameter passed to hsa_queue_create
    /// \param queue Parameter passed to hsa_queue_create
    /// \param retVal the return value for hsa_queue_create
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_agent_t agent,
                uint32_t size,
                hsa_queue_type32_t type_,
                void (*callback)(hsa_status_t status, hsa_queue_t* source, void* data),
                void* data,
                uint32_t private_segment_size,
                uint32_t group_segment_size,
                hsa_queue_t** queue,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_queue_create(const HSA_APITrace_hsa_queue_create& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_queue_create& operator= (const HSA_APITrace_hsa_queue_create& rhs) = delete;

    hsa_agent_t m_agent; ///< Parameter passed to hsa_queue_create
    uint32_t m_size; ///< Parameter passed to hsa_queue_create
    hsa_queue_type32_t m_type_; ///< Parameter passed to hsa_queue_create
    void (*m_callback)(hsa_status_t status, hsa_queue_t* source, void* data); ///< Parameter passed to hsa_queue_create
    void* m_data; ///< Parameter passed to hsa_queue_create
    uint32_t m_private_segment_size; ///< Parameter passed to hsa_queue_create
    uint32_t m_group_segment_size; ///< Parameter passed to hsa_queue_create
    hsa_queue_t** m_queue; ///< Parameter passed to hsa_queue_create
    hsa_queue_t m_queueVal; ///< Member to hold value passed to hsa_queue_create in queue parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_queue_create
};

///////////////////////////////////////////////////
/// Class used to trace hsa_soft_queue_create
///////////////////////////////////////////////////
class HSA_APITrace_hsa_soft_queue_create : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_soft_queue_create();

    /// Destructor
    ~HSA_APITrace_hsa_soft_queue_create();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_soft_queue_create
    /// \param ullEndTime the end timestamp for hsa_soft_queue_create
    /// \param region Parameter passed to hsa_soft_queue_create
    /// \param size Parameter passed to hsa_soft_queue_create
    /// \param type_ Parameter passed to hsa_soft_queue_create
    /// \param features Parameter passed to hsa_soft_queue_create
    /// \param doorbell_signal Parameter passed to hsa_soft_queue_create
    /// \param queue Parameter passed to hsa_soft_queue_create
    /// \param retVal the return value for hsa_soft_queue_create
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_region_t region,
                uint32_t size,
                hsa_queue_type32_t type_,
                uint32_t features,
                hsa_signal_t doorbell_signal,
                hsa_queue_t** queue,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_soft_queue_create(const HSA_APITrace_hsa_soft_queue_create& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_soft_queue_create& operator= (const HSA_APITrace_hsa_soft_queue_create& rhs) = delete;

    hsa_region_t m_region; ///< Parameter passed to hsa_soft_queue_create
    uint32_t m_size; ///< Parameter passed to hsa_soft_queue_create
    hsa_queue_type32_t m_type_; ///< Parameter passed to hsa_soft_queue_create
    uint32_t m_features; ///< Parameter passed to hsa_soft_queue_create
    hsa_signal_t m_doorbell_signal; ///< Parameter passed to hsa_soft_queue_create
    hsa_queue_t** m_queue; ///< Parameter passed to hsa_soft_queue_create
    hsa_queue_t m_queueVal; ///< Member to hold value passed to hsa_soft_queue_create in queue parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_soft_queue_create
};

///////////////////////////////////////////////////
/// Class used to trace hsa_queue_destroy
///////////////////////////////////////////////////
class HSA_APITrace_hsa_queue_destroy : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_queue_destroy();

    /// Destructor
    ~HSA_APITrace_hsa_queue_destroy();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_queue_destroy
    /// \param ullEndTime the end timestamp for hsa_queue_destroy
    /// \param queue Parameter passed to hsa_queue_destroy
    /// \param retVal the return value for hsa_queue_destroy
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_queue_t* queue,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_queue_destroy(const HSA_APITrace_hsa_queue_destroy& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_queue_destroy& operator= (const HSA_APITrace_hsa_queue_destroy& rhs) = delete;

    hsa_queue_t* m_queue; ///< Parameter passed to hsa_queue_destroy
    hsa_queue_t m_queueVal; ///< Member to hold value passed to hsa_queue_destroy in queue parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_queue_destroy
};

///////////////////////////////////////////////////
/// Class used to trace hsa_queue_inactivate
///////////////////////////////////////////////////
class HSA_APITrace_hsa_queue_inactivate : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_queue_inactivate();

    /// Destructor
    ~HSA_APITrace_hsa_queue_inactivate();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_queue_inactivate
    /// \param ullEndTime the end timestamp for hsa_queue_inactivate
    /// \param queue Parameter passed to hsa_queue_inactivate
    /// \param retVal the return value for hsa_queue_inactivate
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_queue_t* queue,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_queue_inactivate(const HSA_APITrace_hsa_queue_inactivate& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_queue_inactivate& operator= (const HSA_APITrace_hsa_queue_inactivate& rhs) = delete;

    hsa_queue_t* m_queue; ///< Parameter passed to hsa_queue_inactivate
    hsa_queue_t m_queueVal; ///< Member to hold value passed to hsa_queue_inactivate in queue parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_queue_inactivate
};

///////////////////////////////////////////////////
/// Class used to trace hsa_queue_load_read_index_scacquire
///////////////////////////////////////////////////
class HSA_APITrace_hsa_queue_load_read_index_scacquire : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_queue_load_read_index_scacquire();

    /// Destructor
    ~HSA_APITrace_hsa_queue_load_read_index_scacquire();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_queue_load_read_index_scacquire
    /// \param ullEndTime the end timestamp for hsa_queue_load_read_index_scacquire
    /// \param queue Parameter passed to hsa_queue_load_read_index_scacquire
    /// \param retVal the return value for hsa_queue_load_read_index_scacquire
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_queue_t* queue,
                uint64_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_queue_load_read_index_scacquire(const HSA_APITrace_hsa_queue_load_read_index_scacquire& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_queue_load_read_index_scacquire& operator= (const HSA_APITrace_hsa_queue_load_read_index_scacquire& rhs) = delete;

    const hsa_queue_t* m_queue; ///< Parameter passed to hsa_queue_load_read_index_scacquire
    hsa_queue_t m_queueVal; ///< Member to hold value passed to hsa_queue_load_read_index_scacquire in queue parameter
    uint64_t m_retVal; ///< Parameter passed to hsa_queue_load_read_index_scacquire
};

///////////////////////////////////////////////////
/// Class used to trace hsa_queue_load_read_index_relaxed
///////////////////////////////////////////////////
class HSA_APITrace_hsa_queue_load_read_index_relaxed : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_queue_load_read_index_relaxed();

    /// Destructor
    ~HSA_APITrace_hsa_queue_load_read_index_relaxed();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_queue_load_read_index_relaxed
    /// \param ullEndTime the end timestamp for hsa_queue_load_read_index_relaxed
    /// \param queue Parameter passed to hsa_queue_load_read_index_relaxed
    /// \param retVal the return value for hsa_queue_load_read_index_relaxed
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_queue_t* queue,
                uint64_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_queue_load_read_index_relaxed(const HSA_APITrace_hsa_queue_load_read_index_relaxed& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_queue_load_read_index_relaxed& operator= (const HSA_APITrace_hsa_queue_load_read_index_relaxed& rhs) = delete;

    const hsa_queue_t* m_queue; ///< Parameter passed to hsa_queue_load_read_index_relaxed
    hsa_queue_t m_queueVal; ///< Member to hold value passed to hsa_queue_load_read_index_relaxed in queue parameter
    uint64_t m_retVal; ///< Parameter passed to hsa_queue_load_read_index_relaxed
};

///////////////////////////////////////////////////
/// Class used to trace hsa_queue_load_write_index_scacquire
///////////////////////////////////////////////////
class HSA_APITrace_hsa_queue_load_write_index_scacquire : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_queue_load_write_index_scacquire();

    /// Destructor
    ~HSA_APITrace_hsa_queue_load_write_index_scacquire();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_queue_load_write_index_scacquire
    /// \param ullEndTime the end timestamp for hsa_queue_load_write_index_scacquire
    /// \param queue Parameter passed to hsa_queue_load_write_index_scacquire
    /// \param retVal the return value for hsa_queue_load_write_index_scacquire
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_queue_t* queue,
                uint64_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_queue_load_write_index_scacquire(const HSA_APITrace_hsa_queue_load_write_index_scacquire& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_queue_load_write_index_scacquire& operator= (const HSA_APITrace_hsa_queue_load_write_index_scacquire& rhs) = delete;

    const hsa_queue_t* m_queue; ///< Parameter passed to hsa_queue_load_write_index_scacquire
    hsa_queue_t m_queueVal; ///< Member to hold value passed to hsa_queue_load_write_index_scacquire in queue parameter
    uint64_t m_retVal; ///< Parameter passed to hsa_queue_load_write_index_scacquire
};

///////////////////////////////////////////////////
/// Class used to trace hsa_queue_load_write_index_relaxed
///////////////////////////////////////////////////
class HSA_APITrace_hsa_queue_load_write_index_relaxed : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_queue_load_write_index_relaxed();

    /// Destructor
    ~HSA_APITrace_hsa_queue_load_write_index_relaxed();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_queue_load_write_index_relaxed
    /// \param ullEndTime the end timestamp for hsa_queue_load_write_index_relaxed
    /// \param queue Parameter passed to hsa_queue_load_write_index_relaxed
    /// \param retVal the return value for hsa_queue_load_write_index_relaxed
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_queue_t* queue,
                uint64_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_queue_load_write_index_relaxed(const HSA_APITrace_hsa_queue_load_write_index_relaxed& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_queue_load_write_index_relaxed& operator= (const HSA_APITrace_hsa_queue_load_write_index_relaxed& rhs) = delete;

    const hsa_queue_t* m_queue; ///< Parameter passed to hsa_queue_load_write_index_relaxed
    hsa_queue_t m_queueVal; ///< Member to hold value passed to hsa_queue_load_write_index_relaxed in queue parameter
    uint64_t m_retVal; ///< Parameter passed to hsa_queue_load_write_index_relaxed
};

///////////////////////////////////////////////////
/// Class used to trace hsa_queue_store_write_index_relaxed
///////////////////////////////////////////////////
class HSA_APITrace_hsa_queue_store_write_index_relaxed : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_queue_store_write_index_relaxed();

    /// Destructor
    ~HSA_APITrace_hsa_queue_store_write_index_relaxed();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_queue_store_write_index_relaxed
    /// \param ullEndTime the end timestamp for hsa_queue_store_write_index_relaxed
    /// \param queue Parameter passed to hsa_queue_store_write_index_relaxed
    /// \param value Parameter passed to hsa_queue_store_write_index_relaxed
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_queue_t* queue,
                uint64_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_queue_store_write_index_relaxed(const HSA_APITrace_hsa_queue_store_write_index_relaxed& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_queue_store_write_index_relaxed& operator= (const HSA_APITrace_hsa_queue_store_write_index_relaxed& rhs) = delete;

    const hsa_queue_t* m_queue; ///< Parameter passed to hsa_queue_store_write_index_relaxed
    hsa_queue_t m_queueVal; ///< Member to hold value passed to hsa_queue_store_write_index_relaxed in queue parameter
    uint64_t m_value; ///< Parameter passed to hsa_queue_store_write_index_relaxed
};

///////////////////////////////////////////////////
/// Class used to trace hsa_queue_store_write_index_screlease
///////////////////////////////////////////////////
class HSA_APITrace_hsa_queue_store_write_index_screlease : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_queue_store_write_index_screlease();

    /// Destructor
    ~HSA_APITrace_hsa_queue_store_write_index_screlease();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_queue_store_write_index_screlease
    /// \param ullEndTime the end timestamp for hsa_queue_store_write_index_screlease
    /// \param queue Parameter passed to hsa_queue_store_write_index_screlease
    /// \param value Parameter passed to hsa_queue_store_write_index_screlease
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_queue_t* queue,
                uint64_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_queue_store_write_index_screlease(const HSA_APITrace_hsa_queue_store_write_index_screlease& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_queue_store_write_index_screlease& operator= (const HSA_APITrace_hsa_queue_store_write_index_screlease& rhs) = delete;

    const hsa_queue_t* m_queue; ///< Parameter passed to hsa_queue_store_write_index_screlease
    hsa_queue_t m_queueVal; ///< Member to hold value passed to hsa_queue_store_write_index_screlease in queue parameter
    uint64_t m_value; ///< Parameter passed to hsa_queue_store_write_index_screlease
};

///////////////////////////////////////////////////
/// Class used to trace hsa_queue_cas_write_index_scacq_screl
///////////////////////////////////////////////////
class HSA_APITrace_hsa_queue_cas_write_index_scacq_screl : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_queue_cas_write_index_scacq_screl();

    /// Destructor
    ~HSA_APITrace_hsa_queue_cas_write_index_scacq_screl();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_queue_cas_write_index_scacq_screl
    /// \param ullEndTime the end timestamp for hsa_queue_cas_write_index_scacq_screl
    /// \param queue Parameter passed to hsa_queue_cas_write_index_scacq_screl
    /// \param expected Parameter passed to hsa_queue_cas_write_index_scacq_screl
    /// \param value Parameter passed to hsa_queue_cas_write_index_scacq_screl
    /// \param retVal the return value for hsa_queue_cas_write_index_scacq_screl
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_queue_t* queue,
                uint64_t expected,
                uint64_t value,
                uint64_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_queue_cas_write_index_scacq_screl(const HSA_APITrace_hsa_queue_cas_write_index_scacq_screl& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_queue_cas_write_index_scacq_screl& operator= (const HSA_APITrace_hsa_queue_cas_write_index_scacq_screl& rhs) = delete;

    const hsa_queue_t* m_queue; ///< Parameter passed to hsa_queue_cas_write_index_scacq_screl
    hsa_queue_t m_queueVal; ///< Member to hold value passed to hsa_queue_cas_write_index_scacq_screl in queue parameter
    uint64_t m_expected; ///< Parameter passed to hsa_queue_cas_write_index_scacq_screl
    uint64_t m_value; ///< Parameter passed to hsa_queue_cas_write_index_scacq_screl
    uint64_t m_retVal; ///< Parameter passed to hsa_queue_cas_write_index_scacq_screl
};

///////////////////////////////////////////////////
/// Class used to trace hsa_queue_cas_write_index_scacquire
///////////////////////////////////////////////////
class HSA_APITrace_hsa_queue_cas_write_index_scacquire : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_queue_cas_write_index_scacquire();

    /// Destructor
    ~HSA_APITrace_hsa_queue_cas_write_index_scacquire();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_queue_cas_write_index_scacquire
    /// \param ullEndTime the end timestamp for hsa_queue_cas_write_index_scacquire
    /// \param queue Parameter passed to hsa_queue_cas_write_index_scacquire
    /// \param expected Parameter passed to hsa_queue_cas_write_index_scacquire
    /// \param value Parameter passed to hsa_queue_cas_write_index_scacquire
    /// \param retVal the return value for hsa_queue_cas_write_index_scacquire
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_queue_t* queue,
                uint64_t expected,
                uint64_t value,
                uint64_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_queue_cas_write_index_scacquire(const HSA_APITrace_hsa_queue_cas_write_index_scacquire& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_queue_cas_write_index_scacquire& operator= (const HSA_APITrace_hsa_queue_cas_write_index_scacquire& rhs) = delete;

    const hsa_queue_t* m_queue; ///< Parameter passed to hsa_queue_cas_write_index_scacquire
    hsa_queue_t m_queueVal; ///< Member to hold value passed to hsa_queue_cas_write_index_scacquire in queue parameter
    uint64_t m_expected; ///< Parameter passed to hsa_queue_cas_write_index_scacquire
    uint64_t m_value; ///< Parameter passed to hsa_queue_cas_write_index_scacquire
    uint64_t m_retVal; ///< Parameter passed to hsa_queue_cas_write_index_scacquire
};

///////////////////////////////////////////////////
/// Class used to trace hsa_queue_cas_write_index_relaxed
///////////////////////////////////////////////////
class HSA_APITrace_hsa_queue_cas_write_index_relaxed : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_queue_cas_write_index_relaxed();

    /// Destructor
    ~HSA_APITrace_hsa_queue_cas_write_index_relaxed();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_queue_cas_write_index_relaxed
    /// \param ullEndTime the end timestamp for hsa_queue_cas_write_index_relaxed
    /// \param queue Parameter passed to hsa_queue_cas_write_index_relaxed
    /// \param expected Parameter passed to hsa_queue_cas_write_index_relaxed
    /// \param value Parameter passed to hsa_queue_cas_write_index_relaxed
    /// \param retVal the return value for hsa_queue_cas_write_index_relaxed
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_queue_t* queue,
                uint64_t expected,
                uint64_t value,
                uint64_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_queue_cas_write_index_relaxed(const HSA_APITrace_hsa_queue_cas_write_index_relaxed& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_queue_cas_write_index_relaxed& operator= (const HSA_APITrace_hsa_queue_cas_write_index_relaxed& rhs) = delete;

    const hsa_queue_t* m_queue; ///< Parameter passed to hsa_queue_cas_write_index_relaxed
    hsa_queue_t m_queueVal; ///< Member to hold value passed to hsa_queue_cas_write_index_relaxed in queue parameter
    uint64_t m_expected; ///< Parameter passed to hsa_queue_cas_write_index_relaxed
    uint64_t m_value; ///< Parameter passed to hsa_queue_cas_write_index_relaxed
    uint64_t m_retVal; ///< Parameter passed to hsa_queue_cas_write_index_relaxed
};

///////////////////////////////////////////////////
/// Class used to trace hsa_queue_cas_write_index_screlease
///////////////////////////////////////////////////
class HSA_APITrace_hsa_queue_cas_write_index_screlease : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_queue_cas_write_index_screlease();

    /// Destructor
    ~HSA_APITrace_hsa_queue_cas_write_index_screlease();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_queue_cas_write_index_screlease
    /// \param ullEndTime the end timestamp for hsa_queue_cas_write_index_screlease
    /// \param queue Parameter passed to hsa_queue_cas_write_index_screlease
    /// \param expected Parameter passed to hsa_queue_cas_write_index_screlease
    /// \param value Parameter passed to hsa_queue_cas_write_index_screlease
    /// \param retVal the return value for hsa_queue_cas_write_index_screlease
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_queue_t* queue,
                uint64_t expected,
                uint64_t value,
                uint64_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_queue_cas_write_index_screlease(const HSA_APITrace_hsa_queue_cas_write_index_screlease& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_queue_cas_write_index_screlease& operator= (const HSA_APITrace_hsa_queue_cas_write_index_screlease& rhs) = delete;

    const hsa_queue_t* m_queue; ///< Parameter passed to hsa_queue_cas_write_index_screlease
    hsa_queue_t m_queueVal; ///< Member to hold value passed to hsa_queue_cas_write_index_screlease in queue parameter
    uint64_t m_expected; ///< Parameter passed to hsa_queue_cas_write_index_screlease
    uint64_t m_value; ///< Parameter passed to hsa_queue_cas_write_index_screlease
    uint64_t m_retVal; ///< Parameter passed to hsa_queue_cas_write_index_screlease
};

///////////////////////////////////////////////////
/// Class used to trace hsa_queue_add_write_index_scacq_screl
///////////////////////////////////////////////////
class HSA_APITrace_hsa_queue_add_write_index_scacq_screl : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_queue_add_write_index_scacq_screl();

    /// Destructor
    ~HSA_APITrace_hsa_queue_add_write_index_scacq_screl();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_queue_add_write_index_scacq_screl
    /// \param ullEndTime the end timestamp for hsa_queue_add_write_index_scacq_screl
    /// \param queue Parameter passed to hsa_queue_add_write_index_scacq_screl
    /// \param value Parameter passed to hsa_queue_add_write_index_scacq_screl
    /// \param retVal the return value for hsa_queue_add_write_index_scacq_screl
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_queue_t* queue,
                uint64_t value,
                uint64_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_queue_add_write_index_scacq_screl(const HSA_APITrace_hsa_queue_add_write_index_scacq_screl& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_queue_add_write_index_scacq_screl& operator= (const HSA_APITrace_hsa_queue_add_write_index_scacq_screl& rhs) = delete;

    const hsa_queue_t* m_queue; ///< Parameter passed to hsa_queue_add_write_index_scacq_screl
    hsa_queue_t m_queueVal; ///< Member to hold value passed to hsa_queue_add_write_index_scacq_screl in queue parameter
    uint64_t m_value; ///< Parameter passed to hsa_queue_add_write_index_scacq_screl
    uint64_t m_retVal; ///< Parameter passed to hsa_queue_add_write_index_scacq_screl
};

///////////////////////////////////////////////////
/// Class used to trace hsa_queue_add_write_index_scacquire
///////////////////////////////////////////////////
class HSA_APITrace_hsa_queue_add_write_index_scacquire : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_queue_add_write_index_scacquire();

    /// Destructor
    ~HSA_APITrace_hsa_queue_add_write_index_scacquire();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_queue_add_write_index_scacquire
    /// \param ullEndTime the end timestamp for hsa_queue_add_write_index_scacquire
    /// \param queue Parameter passed to hsa_queue_add_write_index_scacquire
    /// \param value Parameter passed to hsa_queue_add_write_index_scacquire
    /// \param retVal the return value for hsa_queue_add_write_index_scacquire
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_queue_t* queue,
                uint64_t value,
                uint64_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_queue_add_write_index_scacquire(const HSA_APITrace_hsa_queue_add_write_index_scacquire& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_queue_add_write_index_scacquire& operator= (const HSA_APITrace_hsa_queue_add_write_index_scacquire& rhs) = delete;

    const hsa_queue_t* m_queue; ///< Parameter passed to hsa_queue_add_write_index_scacquire
    hsa_queue_t m_queueVal; ///< Member to hold value passed to hsa_queue_add_write_index_scacquire in queue parameter
    uint64_t m_value; ///< Parameter passed to hsa_queue_add_write_index_scacquire
    uint64_t m_retVal; ///< Parameter passed to hsa_queue_add_write_index_scacquire
};

///////////////////////////////////////////////////
/// Class used to trace hsa_queue_add_write_index_relaxed
///////////////////////////////////////////////////
class HSA_APITrace_hsa_queue_add_write_index_relaxed : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_queue_add_write_index_relaxed();

    /// Destructor
    ~HSA_APITrace_hsa_queue_add_write_index_relaxed();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_queue_add_write_index_relaxed
    /// \param ullEndTime the end timestamp for hsa_queue_add_write_index_relaxed
    /// \param queue Parameter passed to hsa_queue_add_write_index_relaxed
    /// \param value Parameter passed to hsa_queue_add_write_index_relaxed
    /// \param retVal the return value for hsa_queue_add_write_index_relaxed
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_queue_t* queue,
                uint64_t value,
                uint64_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_queue_add_write_index_relaxed(const HSA_APITrace_hsa_queue_add_write_index_relaxed& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_queue_add_write_index_relaxed& operator= (const HSA_APITrace_hsa_queue_add_write_index_relaxed& rhs) = delete;

    const hsa_queue_t* m_queue; ///< Parameter passed to hsa_queue_add_write_index_relaxed
    hsa_queue_t m_queueVal; ///< Member to hold value passed to hsa_queue_add_write_index_relaxed in queue parameter
    uint64_t m_value; ///< Parameter passed to hsa_queue_add_write_index_relaxed
    uint64_t m_retVal; ///< Parameter passed to hsa_queue_add_write_index_relaxed
};

///////////////////////////////////////////////////
/// Class used to trace hsa_queue_add_write_index_screlease
///////////////////////////////////////////////////
class HSA_APITrace_hsa_queue_add_write_index_screlease : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_queue_add_write_index_screlease();

    /// Destructor
    ~HSA_APITrace_hsa_queue_add_write_index_screlease();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_queue_add_write_index_screlease
    /// \param ullEndTime the end timestamp for hsa_queue_add_write_index_screlease
    /// \param queue Parameter passed to hsa_queue_add_write_index_screlease
    /// \param value Parameter passed to hsa_queue_add_write_index_screlease
    /// \param retVal the return value for hsa_queue_add_write_index_screlease
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_queue_t* queue,
                uint64_t value,
                uint64_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_queue_add_write_index_screlease(const HSA_APITrace_hsa_queue_add_write_index_screlease& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_queue_add_write_index_screlease& operator= (const HSA_APITrace_hsa_queue_add_write_index_screlease& rhs) = delete;

    const hsa_queue_t* m_queue; ///< Parameter passed to hsa_queue_add_write_index_screlease
    hsa_queue_t m_queueVal; ///< Member to hold value passed to hsa_queue_add_write_index_screlease in queue parameter
    uint64_t m_value; ///< Parameter passed to hsa_queue_add_write_index_screlease
    uint64_t m_retVal; ///< Parameter passed to hsa_queue_add_write_index_screlease
};

///////////////////////////////////////////////////
/// Class used to trace hsa_queue_store_read_index_relaxed
///////////////////////////////////////////////////
class HSA_APITrace_hsa_queue_store_read_index_relaxed : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_queue_store_read_index_relaxed();

    /// Destructor
    ~HSA_APITrace_hsa_queue_store_read_index_relaxed();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_queue_store_read_index_relaxed
    /// \param ullEndTime the end timestamp for hsa_queue_store_read_index_relaxed
    /// \param queue Parameter passed to hsa_queue_store_read_index_relaxed
    /// \param value Parameter passed to hsa_queue_store_read_index_relaxed
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_queue_t* queue,
                uint64_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_queue_store_read_index_relaxed(const HSA_APITrace_hsa_queue_store_read_index_relaxed& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_queue_store_read_index_relaxed& operator= (const HSA_APITrace_hsa_queue_store_read_index_relaxed& rhs) = delete;

    const hsa_queue_t* m_queue; ///< Parameter passed to hsa_queue_store_read_index_relaxed
    hsa_queue_t m_queueVal; ///< Member to hold value passed to hsa_queue_store_read_index_relaxed in queue parameter
    uint64_t m_value; ///< Parameter passed to hsa_queue_store_read_index_relaxed
};

///////////////////////////////////////////////////
/// Class used to trace hsa_queue_store_read_index_screlease
///////////////////////////////////////////////////
class HSA_APITrace_hsa_queue_store_read_index_screlease : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_queue_store_read_index_screlease();

    /// Destructor
    ~HSA_APITrace_hsa_queue_store_read_index_screlease();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_queue_store_read_index_screlease
    /// \param ullEndTime the end timestamp for hsa_queue_store_read_index_screlease
    /// \param queue Parameter passed to hsa_queue_store_read_index_screlease
    /// \param value Parameter passed to hsa_queue_store_read_index_screlease
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const hsa_queue_t* queue,
                uint64_t value);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_queue_store_read_index_screlease(const HSA_APITrace_hsa_queue_store_read_index_screlease& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_queue_store_read_index_screlease& operator= (const HSA_APITrace_hsa_queue_store_read_index_screlease& rhs) = delete;

    const hsa_queue_t* m_queue; ///< Parameter passed to hsa_queue_store_read_index_screlease
    hsa_queue_t m_queueVal; ///< Member to hold value passed to hsa_queue_store_read_index_screlease in queue parameter
    uint64_t m_value; ///< Parameter passed to hsa_queue_store_read_index_screlease
};

///////////////////////////////////////////////////
/// Class used to trace hsa_region_get_info
///////////////////////////////////////////////////
class HSA_APITrace_hsa_region_get_info : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_region_get_info();

    /// Destructor
    ~HSA_APITrace_hsa_region_get_info();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_region_get_info
    /// \param ullEndTime the end timestamp for hsa_region_get_info
    /// \param region Parameter passed to hsa_region_get_info
    /// \param attribute Parameter passed to hsa_region_get_info
    /// \param value Parameter passed to hsa_region_get_info
    /// \param retVal the return value for hsa_region_get_info
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_region_t region,
                hsa_region_info_t attribute,
                void* value,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_region_get_info(const HSA_APITrace_hsa_region_get_info& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_region_get_info& operator= (const HSA_APITrace_hsa_region_get_info& rhs) = delete;

    hsa_region_t m_region; ///< Parameter passed to hsa_region_get_info
    hsa_region_info_t m_attribute; ///< Parameter passed to hsa_region_get_info
    void* m_value; ///< Parameter passed to hsa_region_get_info
    hsa_status_t m_retVal; ///< Parameter passed to hsa_region_get_info
};

///////////////////////////////////////////////////
/// Class used to trace hsa_agent_iterate_regions
///////////////////////////////////////////////////
class HSA_APITrace_hsa_agent_iterate_regions : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_agent_iterate_regions();

    /// Destructor
    ~HSA_APITrace_hsa_agent_iterate_regions();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_agent_iterate_regions
    /// \param ullEndTime the end timestamp for hsa_agent_iterate_regions
    /// \param agent Parameter passed to hsa_agent_iterate_regions
    /// \param callback Parameter passed to hsa_agent_iterate_regions
    /// \param data Parameter passed to hsa_agent_iterate_regions
    /// \param retVal the return value for hsa_agent_iterate_regions
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_agent_t agent,
                hsa_status_t (*callback)(hsa_region_t region, void* data),
                void* data,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_agent_iterate_regions(const HSA_APITrace_hsa_agent_iterate_regions& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_agent_iterate_regions& operator= (const HSA_APITrace_hsa_agent_iterate_regions& rhs) = delete;

    hsa_agent_t m_agent; ///< Parameter passed to hsa_agent_iterate_regions
    hsa_status_t (*m_callback)(hsa_region_t region, void* data); ///< Parameter passed to hsa_agent_iterate_regions
    void* m_data; ///< Parameter passed to hsa_agent_iterate_regions
    hsa_status_t m_retVal; ///< Parameter passed to hsa_agent_iterate_regions
};

///////////////////////////////////////////////////
/// Class used to trace hsa_memory_allocate
///////////////////////////////////////////////////
class HSA_APITrace_hsa_memory_allocate : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_memory_allocate();

    /// Destructor
    ~HSA_APITrace_hsa_memory_allocate();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_memory_allocate
    /// \param ullEndTime the end timestamp for hsa_memory_allocate
    /// \param region Parameter passed to hsa_memory_allocate
    /// \param size Parameter passed to hsa_memory_allocate
    /// \param ptr Parameter passed to hsa_memory_allocate
    /// \param retVal the return value for hsa_memory_allocate
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_region_t region,
                size_t size,
                void** ptr,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_memory_allocate(const HSA_APITrace_hsa_memory_allocate& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_memory_allocate& operator= (const HSA_APITrace_hsa_memory_allocate& rhs) = delete;

    hsa_region_t m_region; ///< Parameter passed to hsa_memory_allocate
    size_t m_size; ///< Parameter passed to hsa_memory_allocate
    void** m_ptr; ///< Parameter passed to hsa_memory_allocate
    uintptr_t m_ptrVal; ///< Member to hold value passed to hsa_memory_allocate in ptr parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_memory_allocate
};

///////////////////////////////////////////////////
/// Class used to trace hsa_memory_free
///////////////////////////////////////////////////
class HSA_APITrace_hsa_memory_free : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_memory_free();

    /// Destructor
    ~HSA_APITrace_hsa_memory_free();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_memory_free
    /// \param ullEndTime the end timestamp for hsa_memory_free
    /// \param ptr Parameter passed to hsa_memory_free
    /// \param retVal the return value for hsa_memory_free
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                void* ptr,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_memory_free(const HSA_APITrace_hsa_memory_free& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_memory_free& operator= (const HSA_APITrace_hsa_memory_free& rhs) = delete;

    void* m_ptr; ///< Parameter passed to hsa_memory_free
    hsa_status_t m_retVal; ///< Parameter passed to hsa_memory_free
};

///////////////////////////////////////////////////
/// Class used to trace hsa_memory_copy
///////////////////////////////////////////////////
class HSA_APITrace_hsa_memory_copy : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_memory_copy();

    /// Destructor
    ~HSA_APITrace_hsa_memory_copy();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_memory_copy
    /// \param ullEndTime the end timestamp for hsa_memory_copy
    /// \param dst Parameter passed to hsa_memory_copy
    /// \param src Parameter passed to hsa_memory_copy
    /// \param size Parameter passed to hsa_memory_copy
    /// \param retVal the return value for hsa_memory_copy
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                void* dst,
                const void* src,
                size_t size,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_memory_copy(const HSA_APITrace_hsa_memory_copy& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_memory_copy& operator= (const HSA_APITrace_hsa_memory_copy& rhs) = delete;

    void* m_dst; ///< Parameter passed to hsa_memory_copy
    const void* m_src; ///< Parameter passed to hsa_memory_copy
    size_t m_size; ///< Parameter passed to hsa_memory_copy
    hsa_status_t m_retVal; ///< Parameter passed to hsa_memory_copy
};

///////////////////////////////////////////////////
/// Class used to trace hsa_memory_assign_agent
///////////////////////////////////////////////////
class HSA_APITrace_hsa_memory_assign_agent : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_memory_assign_agent();

    /// Destructor
    ~HSA_APITrace_hsa_memory_assign_agent();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_memory_assign_agent
    /// \param ullEndTime the end timestamp for hsa_memory_assign_agent
    /// \param ptr Parameter passed to hsa_memory_assign_agent
    /// \param agent Parameter passed to hsa_memory_assign_agent
    /// \param access Parameter passed to hsa_memory_assign_agent
    /// \param retVal the return value for hsa_memory_assign_agent
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                void* ptr,
                hsa_agent_t agent,
                hsa_access_permission_t access,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_memory_assign_agent(const HSA_APITrace_hsa_memory_assign_agent& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_memory_assign_agent& operator= (const HSA_APITrace_hsa_memory_assign_agent& rhs) = delete;

    void* m_ptr; ///< Parameter passed to hsa_memory_assign_agent
    hsa_agent_t m_agent; ///< Parameter passed to hsa_memory_assign_agent
    hsa_access_permission_t m_access; ///< Parameter passed to hsa_memory_assign_agent
    hsa_status_t m_retVal; ///< Parameter passed to hsa_memory_assign_agent
};

///////////////////////////////////////////////////
/// Class used to trace hsa_memory_register
///////////////////////////////////////////////////
class HSA_APITrace_hsa_memory_register : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_memory_register();

    /// Destructor
    ~HSA_APITrace_hsa_memory_register();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_memory_register
    /// \param ullEndTime the end timestamp for hsa_memory_register
    /// \param ptr Parameter passed to hsa_memory_register
    /// \param size Parameter passed to hsa_memory_register
    /// \param retVal the return value for hsa_memory_register
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                void* ptr,
                size_t size,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_memory_register(const HSA_APITrace_hsa_memory_register& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_memory_register& operator= (const HSA_APITrace_hsa_memory_register& rhs) = delete;

    void* m_ptr; ///< Parameter passed to hsa_memory_register
    size_t m_size; ///< Parameter passed to hsa_memory_register
    hsa_status_t m_retVal; ///< Parameter passed to hsa_memory_register
};

///////////////////////////////////////////////////
/// Class used to trace hsa_memory_deregister
///////////////////////////////////////////////////
class HSA_APITrace_hsa_memory_deregister : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_memory_deregister();

    /// Destructor
    ~HSA_APITrace_hsa_memory_deregister();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_memory_deregister
    /// \param ullEndTime the end timestamp for hsa_memory_deregister
    /// \param ptr Parameter passed to hsa_memory_deregister
    /// \param size Parameter passed to hsa_memory_deregister
    /// \param retVal the return value for hsa_memory_deregister
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                void* ptr,
                size_t size,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_memory_deregister(const HSA_APITrace_hsa_memory_deregister& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_memory_deregister& operator= (const HSA_APITrace_hsa_memory_deregister& rhs) = delete;

    void* m_ptr; ///< Parameter passed to hsa_memory_deregister
    size_t m_size; ///< Parameter passed to hsa_memory_deregister
    hsa_status_t m_retVal; ///< Parameter passed to hsa_memory_deregister
};

///////////////////////////////////////////////////
/// Class used to trace hsa_isa_from_name
///////////////////////////////////////////////////
class HSA_APITrace_hsa_isa_from_name : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_isa_from_name();

    /// Destructor
    ~HSA_APITrace_hsa_isa_from_name();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_isa_from_name
    /// \param ullEndTime the end timestamp for hsa_isa_from_name
    /// \param name Parameter passed to hsa_isa_from_name
    /// \param isa Parameter passed to hsa_isa_from_name
    /// \param retVal the return value for hsa_isa_from_name
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const char* name,
                hsa_isa_t* isa,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_isa_from_name(const HSA_APITrace_hsa_isa_from_name& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_isa_from_name& operator= (const HSA_APITrace_hsa_isa_from_name& rhs) = delete;

    const char* m_name; ///< Parameter passed to hsa_isa_from_name
    std::string m_nameVal; ///< Member to hold value passed to hsa_isa_from_name in name parameter
    hsa_isa_t* m_isa; ///< Parameter passed to hsa_isa_from_name
    hsa_isa_t m_isaVal; ///< Member to hold value passed to hsa_isa_from_name in isa parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_isa_from_name
};

///////////////////////////////////////////////////
/// Class used to trace hsa_agent_iterate_isas
///////////////////////////////////////////////////
class HSA_APITrace_hsa_agent_iterate_isas : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_agent_iterate_isas();

    /// Destructor
    ~HSA_APITrace_hsa_agent_iterate_isas();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_agent_iterate_isas
    /// \param ullEndTime the end timestamp for hsa_agent_iterate_isas
    /// \param agent Parameter passed to hsa_agent_iterate_isas
    /// \param callback Parameter passed to hsa_agent_iterate_isas
    /// \param data Parameter passed to hsa_agent_iterate_isas
    /// \param retVal the return value for hsa_agent_iterate_isas
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_agent_t agent,
                hsa_status_t (*callback)(hsa_isa_t isa, void* data),
                void* data,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_agent_iterate_isas(const HSA_APITrace_hsa_agent_iterate_isas& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_agent_iterate_isas& operator= (const HSA_APITrace_hsa_agent_iterate_isas& rhs) = delete;

    hsa_agent_t m_agent; ///< Parameter passed to hsa_agent_iterate_isas
    hsa_status_t (*m_callback)(hsa_isa_t isa, void* data); ///< Parameter passed to hsa_agent_iterate_isas
    void* m_data; ///< Parameter passed to hsa_agent_iterate_isas
    hsa_status_t m_retVal; ///< Parameter passed to hsa_agent_iterate_isas
};

///////////////////////////////////////////////////
/// Class used to trace hsa_isa_get_info
///////////////////////////////////////////////////
class HSA_APITrace_hsa_isa_get_info : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_isa_get_info();

    /// Destructor
    ~HSA_APITrace_hsa_isa_get_info();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_isa_get_info
    /// \param ullEndTime the end timestamp for hsa_isa_get_info
    /// \param isa Parameter passed to hsa_isa_get_info
    /// \param attribute Parameter passed to hsa_isa_get_info
    /// \param index Parameter passed to hsa_isa_get_info
    /// \param value Parameter passed to hsa_isa_get_info
    /// \param retVal the return value for hsa_isa_get_info
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_isa_t isa,
                hsa_isa_info_t attribute,
                uint32_t index,
                void* value,
                uint32_t valueLength,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_isa_get_info(const HSA_APITrace_hsa_isa_get_info& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_isa_get_info& operator= (const HSA_APITrace_hsa_isa_get_info& rhs) = delete;

    hsa_isa_t m_isa; ///< Parameter passed to hsa_isa_get_info
    hsa_isa_info_t m_attribute; ///< Parameter passed to hsa_isa_get_info
    uint32_t m_index; ///< Parameter passed to hsa_isa_get_info
    void* m_value; ///< Parameter passed to hsa_isa_get_info
    hsa_status_t m_retVal; ///< Parameter passed to hsa_isa_get_info
};

///////////////////////////////////////////////////
/// Class used to trace hsa_isa_get_info_alt
///////////////////////////////////////////////////
class HSA_APITrace_hsa_isa_get_info_alt : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_isa_get_info_alt();

    /// Destructor
    ~HSA_APITrace_hsa_isa_get_info_alt();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_isa_get_info_alt
    /// \param ullEndTime the end timestamp for hsa_isa_get_info_alt
    /// \param isa Parameter passed to hsa_isa_get_info_alt
    /// \param attribute Parameter passed to hsa_isa_get_info_alt
    /// \param value Parameter passed to hsa_isa_get_info_alt
    /// \param retVal the return value for hsa_isa_get_info_alt
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_isa_t isa,
                hsa_isa_info_t attribute,
                void* value,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_isa_get_info_alt(const HSA_APITrace_hsa_isa_get_info_alt& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_isa_get_info_alt& operator= (const HSA_APITrace_hsa_isa_get_info_alt& rhs) = delete;

    hsa_isa_t m_isa; ///< Parameter passed to hsa_isa_get_info_alt
    hsa_isa_info_t m_attribute; ///< Parameter passed to hsa_isa_get_info_alt
    void* m_value; ///< Parameter passed to hsa_isa_get_info_alt
    hsa_status_t m_retVal; ///< Parameter passed to hsa_isa_get_info_alt
};

///////////////////////////////////////////////////
/// Class used to trace hsa_isa_get_exception_policies
///////////////////////////////////////////////////
class HSA_APITrace_hsa_isa_get_exception_policies : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_isa_get_exception_policies();

    /// Destructor
    ~HSA_APITrace_hsa_isa_get_exception_policies();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_isa_get_exception_policies
    /// \param ullEndTime the end timestamp for hsa_isa_get_exception_policies
    /// \param isa Parameter passed to hsa_isa_get_exception_policies
    /// \param profile Parameter passed to hsa_isa_get_exception_policies
    /// \param mask Parameter passed to hsa_isa_get_exception_policies
    /// \param retVal the return value for hsa_isa_get_exception_policies
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_isa_t isa,
                hsa_profile_t profile,
                uint16_t* mask,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_isa_get_exception_policies(const HSA_APITrace_hsa_isa_get_exception_policies& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_isa_get_exception_policies& operator= (const HSA_APITrace_hsa_isa_get_exception_policies& rhs) = delete;

    hsa_isa_t m_isa; ///< Parameter passed to hsa_isa_get_exception_policies
    hsa_profile_t m_profile; ///< Parameter passed to hsa_isa_get_exception_policies
    uint16_t* m_mask; ///< Parameter passed to hsa_isa_get_exception_policies
    uint16_t m_maskVal; ///< Member to hold value passed to hsa_isa_get_exception_policies in mask parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_isa_get_exception_policies
};

///////////////////////////////////////////////////
/// Class used to trace hsa_isa_get_round_method
///////////////////////////////////////////////////
class HSA_APITrace_hsa_isa_get_round_method : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_isa_get_round_method();

    /// Destructor
    ~HSA_APITrace_hsa_isa_get_round_method();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_isa_get_round_method
    /// \param ullEndTime the end timestamp for hsa_isa_get_round_method
    /// \param isa Parameter passed to hsa_isa_get_round_method
    /// \param fp_type Parameter passed to hsa_isa_get_round_method
    /// \param flush_mode Parameter passed to hsa_isa_get_round_method
    /// \param round_method Parameter passed to hsa_isa_get_round_method
    /// \param retVal the return value for hsa_isa_get_round_method
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_isa_t isa,
                hsa_fp_type_t fp_type,
                hsa_flush_mode_t flush_mode,
                hsa_round_method_t* round_method,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_isa_get_round_method(const HSA_APITrace_hsa_isa_get_round_method& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_isa_get_round_method& operator= (const HSA_APITrace_hsa_isa_get_round_method& rhs) = delete;

    hsa_isa_t m_isa; ///< Parameter passed to hsa_isa_get_round_method
    hsa_fp_type_t m_fp_type; ///< Parameter passed to hsa_isa_get_round_method
    hsa_flush_mode_t m_flush_mode; ///< Parameter passed to hsa_isa_get_round_method
    hsa_round_method_t* m_round_method; ///< Parameter passed to hsa_isa_get_round_method
    hsa_round_method_t m_round_methodVal; ///< Member to hold value passed to hsa_isa_get_round_method in round_method parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_isa_get_round_method
};

///////////////////////////////////////////////////
/// Class used to trace hsa_wavefront_get_info
///////////////////////////////////////////////////
class HSA_APITrace_hsa_wavefront_get_info : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_wavefront_get_info();

    /// Destructor
    ~HSA_APITrace_hsa_wavefront_get_info();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_wavefront_get_info
    /// \param ullEndTime the end timestamp for hsa_wavefront_get_info
    /// \param wavefront Parameter passed to hsa_wavefront_get_info
    /// \param attribute Parameter passed to hsa_wavefront_get_info
    /// \param value Parameter passed to hsa_wavefront_get_info
    /// \param retVal the return value for hsa_wavefront_get_info
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_wavefront_t wavefront,
                hsa_wavefront_info_t attribute,
                void* value,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_wavefront_get_info(const HSA_APITrace_hsa_wavefront_get_info& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_wavefront_get_info& operator= (const HSA_APITrace_hsa_wavefront_get_info& rhs) = delete;

    hsa_wavefront_t m_wavefront; ///< Parameter passed to hsa_wavefront_get_info
    hsa_wavefront_info_t m_attribute; ///< Parameter passed to hsa_wavefront_get_info
    void* m_value; ///< Parameter passed to hsa_wavefront_get_info
    hsa_status_t m_retVal; ///< Parameter passed to hsa_wavefront_get_info
};

///////////////////////////////////////////////////
/// Class used to trace hsa_isa_iterate_wavefronts
///////////////////////////////////////////////////
class HSA_APITrace_hsa_isa_iterate_wavefronts : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_isa_iterate_wavefronts();

    /// Destructor
    ~HSA_APITrace_hsa_isa_iterate_wavefronts();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_isa_iterate_wavefronts
    /// \param ullEndTime the end timestamp for hsa_isa_iterate_wavefronts
    /// \param isa Parameter passed to hsa_isa_iterate_wavefronts
    /// \param callback Parameter passed to hsa_isa_iterate_wavefronts
    /// \param data Parameter passed to hsa_isa_iterate_wavefronts
    /// \param retVal the return value for hsa_isa_iterate_wavefronts
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_isa_t isa,
                hsa_status_t (*callback)(hsa_wavefront_t wavefront, void* data),
                void* data,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_isa_iterate_wavefronts(const HSA_APITrace_hsa_isa_iterate_wavefronts& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_isa_iterate_wavefronts& operator= (const HSA_APITrace_hsa_isa_iterate_wavefronts& rhs) = delete;

    hsa_isa_t m_isa; ///< Parameter passed to hsa_isa_iterate_wavefronts
    hsa_status_t (*m_callback)(hsa_wavefront_t wavefront, void* data); ///< Parameter passed to hsa_isa_iterate_wavefronts
    void* m_data; ///< Parameter passed to hsa_isa_iterate_wavefronts
    hsa_status_t m_retVal; ///< Parameter passed to hsa_isa_iterate_wavefronts
};

///////////////////////////////////////////////////
/// Class used to trace hsa_isa_compatible
///////////////////////////////////////////////////
class HSA_APITrace_hsa_isa_compatible : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_isa_compatible();

    /// Destructor
    ~HSA_APITrace_hsa_isa_compatible();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_isa_compatible
    /// \param ullEndTime the end timestamp for hsa_isa_compatible
    /// \param code_object_isa Parameter passed to hsa_isa_compatible
    /// \param agent_isa Parameter passed to hsa_isa_compatible
    /// \param result Parameter passed to hsa_isa_compatible
    /// \param retVal the return value for hsa_isa_compatible
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_isa_t code_object_isa,
                hsa_isa_t agent_isa,
                bool* result,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_isa_compatible(const HSA_APITrace_hsa_isa_compatible& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_isa_compatible& operator= (const HSA_APITrace_hsa_isa_compatible& rhs) = delete;

    hsa_isa_t m_code_object_isa; ///< Parameter passed to hsa_isa_compatible
    hsa_isa_t m_agent_isa; ///< Parameter passed to hsa_isa_compatible
    bool* m_result; ///< Parameter passed to hsa_isa_compatible
    bool m_resultVal; ///< Member to hold value passed to hsa_isa_compatible in result parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_isa_compatible
};

///////////////////////////////////////////////////
/// Class used to trace hsa_code_object_reader_create_from_file
///////////////////////////////////////////////////
class HSA_APITrace_hsa_code_object_reader_create_from_file : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_code_object_reader_create_from_file();

    /// Destructor
    ~HSA_APITrace_hsa_code_object_reader_create_from_file();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_code_object_reader_create_from_file
    /// \param ullEndTime the end timestamp for hsa_code_object_reader_create_from_file
    /// \param file Parameter passed to hsa_code_object_reader_create_from_file
    /// \param code_object_reader Parameter passed to hsa_code_object_reader_create_from_file
    /// \param retVal the return value for hsa_code_object_reader_create_from_file
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_file_t file,
                hsa_code_object_reader_t* code_object_reader,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_code_object_reader_create_from_file(const HSA_APITrace_hsa_code_object_reader_create_from_file& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_code_object_reader_create_from_file& operator= (const HSA_APITrace_hsa_code_object_reader_create_from_file& rhs) = delete;

    hsa_file_t m_file; ///< Parameter passed to hsa_code_object_reader_create_from_file
    hsa_code_object_reader_t* m_code_object_reader; ///< Parameter passed to hsa_code_object_reader_create_from_file
    hsa_code_object_reader_t m_code_object_readerVal; ///< Member to hold value passed to hsa_code_object_reader_create_from_file in code_object_reader parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_code_object_reader_create_from_file
};

///////////////////////////////////////////////////
/// Class used to trace hsa_code_object_reader_create_from_memory
///////////////////////////////////////////////////
class HSA_APITrace_hsa_code_object_reader_create_from_memory : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_code_object_reader_create_from_memory();

    /// Destructor
    ~HSA_APITrace_hsa_code_object_reader_create_from_memory();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_code_object_reader_create_from_memory
    /// \param ullEndTime the end timestamp for hsa_code_object_reader_create_from_memory
    /// \param code_object Parameter passed to hsa_code_object_reader_create_from_memory
    /// \param size Parameter passed to hsa_code_object_reader_create_from_memory
    /// \param code_object_reader Parameter passed to hsa_code_object_reader_create_from_memory
    /// \param retVal the return value for hsa_code_object_reader_create_from_memory
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                const void* code_object,
                size_t size,
                hsa_code_object_reader_t* code_object_reader,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_code_object_reader_create_from_memory(const HSA_APITrace_hsa_code_object_reader_create_from_memory& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_code_object_reader_create_from_memory& operator= (const HSA_APITrace_hsa_code_object_reader_create_from_memory& rhs) = delete;

    const void* m_code_object; ///< Parameter passed to hsa_code_object_reader_create_from_memory
    size_t m_size; ///< Parameter passed to hsa_code_object_reader_create_from_memory
    hsa_code_object_reader_t* m_code_object_reader; ///< Parameter passed to hsa_code_object_reader_create_from_memory
    hsa_code_object_reader_t m_code_object_readerVal; ///< Member to hold value passed to hsa_code_object_reader_create_from_memory in code_object_reader parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_code_object_reader_create_from_memory
};

///////////////////////////////////////////////////
/// Class used to trace hsa_code_object_reader_destroy
///////////////////////////////////////////////////
class HSA_APITrace_hsa_code_object_reader_destroy : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_code_object_reader_destroy();

    /// Destructor
    ~HSA_APITrace_hsa_code_object_reader_destroy();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_code_object_reader_destroy
    /// \param ullEndTime the end timestamp for hsa_code_object_reader_destroy
    /// \param code_object_reader Parameter passed to hsa_code_object_reader_destroy
    /// \param retVal the return value for hsa_code_object_reader_destroy
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_code_object_reader_t code_object_reader,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_code_object_reader_destroy(const HSA_APITrace_hsa_code_object_reader_destroy& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_code_object_reader_destroy& operator= (const HSA_APITrace_hsa_code_object_reader_destroy& rhs) = delete;

    hsa_code_object_reader_t m_code_object_reader; ///< Parameter passed to hsa_code_object_reader_destroy
    hsa_status_t m_retVal; ///< Parameter passed to hsa_code_object_reader_destroy
};

///////////////////////////////////////////////////
/// Class used to trace hsa_executable_create
///////////////////////////////////////////////////
class HSA_APITrace_hsa_executable_create : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_executable_create();

    /// Destructor
    ~HSA_APITrace_hsa_executable_create();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_executable_create
    /// \param ullEndTime the end timestamp for hsa_executable_create
    /// \param profile Parameter passed to hsa_executable_create
    /// \param executable_state Parameter passed to hsa_executable_create
    /// \param options Parameter passed to hsa_executable_create
    /// \param executable Parameter passed to hsa_executable_create
    /// \param retVal the return value for hsa_executable_create
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_profile_t profile,
                hsa_executable_state_t executable_state,
                const char* options,
                hsa_executable_t* executable,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_executable_create(const HSA_APITrace_hsa_executable_create& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_executable_create& operator= (const HSA_APITrace_hsa_executable_create& rhs) = delete;

    hsa_profile_t m_profile; ///< Parameter passed to hsa_executable_create
    hsa_executable_state_t m_executable_state; ///< Parameter passed to hsa_executable_create
    const char* m_options; ///< Parameter passed to hsa_executable_create
    std::string m_optionsVal; ///< Member to hold value passed to hsa_executable_create in options parameter
    hsa_executable_t* m_executable; ///< Parameter passed to hsa_executable_create
    hsa_executable_t m_executableVal; ///< Member to hold value passed to hsa_executable_create in executable parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_executable_create
};

///////////////////////////////////////////////////
/// Class used to trace hsa_executable_create_alt
///////////////////////////////////////////////////
class HSA_APITrace_hsa_executable_create_alt : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_executable_create_alt();

    /// Destructor
    ~HSA_APITrace_hsa_executable_create_alt();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_executable_create_alt
    /// \param ullEndTime the end timestamp for hsa_executable_create_alt
    /// \param profile Parameter passed to hsa_executable_create_alt
    /// \param default_float_rounding_mode Parameter passed to hsa_executable_create_alt
    /// \param options Parameter passed to hsa_executable_create_alt
    /// \param executable Parameter passed to hsa_executable_create_alt
    /// \param retVal the return value for hsa_executable_create_alt
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_profile_t profile,
                hsa_default_float_rounding_mode_t default_float_rounding_mode,
                const char* options,
                hsa_executable_t* executable,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_executable_create_alt(const HSA_APITrace_hsa_executable_create_alt& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_executable_create_alt& operator= (const HSA_APITrace_hsa_executable_create_alt& rhs) = delete;

    hsa_profile_t m_profile; ///< Parameter passed to hsa_executable_create_alt
    hsa_default_float_rounding_mode_t m_default_float_rounding_mode; ///< Parameter passed to hsa_executable_create_alt
    const char* m_options; ///< Parameter passed to hsa_executable_create_alt
    std::string m_optionsVal; ///< Member to hold value passed to hsa_executable_create_alt in options parameter
    hsa_executable_t* m_executable; ///< Parameter passed to hsa_executable_create_alt
    hsa_executable_t m_executableVal; ///< Member to hold value passed to hsa_executable_create_alt in executable parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_executable_create_alt
};

///////////////////////////////////////////////////
/// Class used to trace hsa_executable_destroy
///////////////////////////////////////////////////
class HSA_APITrace_hsa_executable_destroy : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_executable_destroy();

    /// Destructor
    ~HSA_APITrace_hsa_executable_destroy();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_executable_destroy
    /// \param ullEndTime the end timestamp for hsa_executable_destroy
    /// \param executable Parameter passed to hsa_executable_destroy
    /// \param retVal the return value for hsa_executable_destroy
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_executable_t executable,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_executable_destroy(const HSA_APITrace_hsa_executable_destroy& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_executable_destroy& operator= (const HSA_APITrace_hsa_executable_destroy& rhs) = delete;

    hsa_executable_t m_executable; ///< Parameter passed to hsa_executable_destroy
    hsa_status_t m_retVal; ///< Parameter passed to hsa_executable_destroy
};

///////////////////////////////////////////////////
/// Class used to trace hsa_executable_load_program_code_object
///////////////////////////////////////////////////
class HSA_APITrace_hsa_executable_load_program_code_object : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_executable_load_program_code_object();

    /// Destructor
    ~HSA_APITrace_hsa_executable_load_program_code_object();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_executable_load_program_code_object
    /// \param ullEndTime the end timestamp for hsa_executable_load_program_code_object
    /// \param executable Parameter passed to hsa_executable_load_program_code_object
    /// \param code_object_reader Parameter passed to hsa_executable_load_program_code_object
    /// \param options Parameter passed to hsa_executable_load_program_code_object
    /// \param loaded_code_object Parameter passed to hsa_executable_load_program_code_object
    /// \param retVal the return value for hsa_executable_load_program_code_object
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_executable_t executable,
                hsa_code_object_reader_t code_object_reader,
                const char* options,
                hsa_loaded_code_object_t* loaded_code_object,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_executable_load_program_code_object(const HSA_APITrace_hsa_executable_load_program_code_object& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_executable_load_program_code_object& operator= (const HSA_APITrace_hsa_executable_load_program_code_object& rhs) = delete;

    hsa_executable_t m_executable; ///< Parameter passed to hsa_executable_load_program_code_object
    hsa_code_object_reader_t m_code_object_reader; ///< Parameter passed to hsa_executable_load_program_code_object
    const char* m_options; ///< Parameter passed to hsa_executable_load_program_code_object
    std::string m_optionsVal; ///< Member to hold value passed to hsa_executable_load_program_code_object in options parameter
    hsa_loaded_code_object_t* m_loaded_code_object; ///< Parameter passed to hsa_executable_load_program_code_object
    hsa_loaded_code_object_t m_loaded_code_objectVal; ///< Member to hold value passed to hsa_executable_load_program_code_object in loaded_code_object parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_executable_load_program_code_object
};

///////////////////////////////////////////////////
/// Class used to trace hsa_executable_load_agent_code_object
///////////////////////////////////////////////////
class HSA_APITrace_hsa_executable_load_agent_code_object : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_executable_load_agent_code_object();

    /// Destructor
    ~HSA_APITrace_hsa_executable_load_agent_code_object();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_executable_load_agent_code_object
    /// \param ullEndTime the end timestamp for hsa_executable_load_agent_code_object
    /// \param executable Parameter passed to hsa_executable_load_agent_code_object
    /// \param agent Parameter passed to hsa_executable_load_agent_code_object
    /// \param code_object_reader Parameter passed to hsa_executable_load_agent_code_object
    /// \param options Parameter passed to hsa_executable_load_agent_code_object
    /// \param loaded_code_object Parameter passed to hsa_executable_load_agent_code_object
    /// \param retVal the return value for hsa_executable_load_agent_code_object
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_executable_t executable,
                hsa_agent_t agent,
                hsa_code_object_reader_t code_object_reader,
                const char* options,
                hsa_loaded_code_object_t* loaded_code_object,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_executable_load_agent_code_object(const HSA_APITrace_hsa_executable_load_agent_code_object& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_executable_load_agent_code_object& operator= (const HSA_APITrace_hsa_executable_load_agent_code_object& rhs) = delete;

    hsa_executable_t m_executable; ///< Parameter passed to hsa_executable_load_agent_code_object
    hsa_agent_t m_agent; ///< Parameter passed to hsa_executable_load_agent_code_object
    hsa_code_object_reader_t m_code_object_reader; ///< Parameter passed to hsa_executable_load_agent_code_object
    const char* m_options; ///< Parameter passed to hsa_executable_load_agent_code_object
    std::string m_optionsVal; ///< Member to hold value passed to hsa_executable_load_agent_code_object in options parameter
    hsa_loaded_code_object_t* m_loaded_code_object; ///< Parameter passed to hsa_executable_load_agent_code_object
    hsa_loaded_code_object_t m_loaded_code_objectVal; ///< Member to hold value passed to hsa_executable_load_agent_code_object in loaded_code_object parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_executable_load_agent_code_object
};

///////////////////////////////////////////////////
/// Class used to trace hsa_executable_freeze
///////////////////////////////////////////////////
class HSA_APITrace_hsa_executable_freeze : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_executable_freeze();

    /// Destructor
    ~HSA_APITrace_hsa_executable_freeze();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_executable_freeze
    /// \param ullEndTime the end timestamp for hsa_executable_freeze
    /// \param executable Parameter passed to hsa_executable_freeze
    /// \param options Parameter passed to hsa_executable_freeze
    /// \param retVal the return value for hsa_executable_freeze
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_executable_t executable,
                const char* options,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_executable_freeze(const HSA_APITrace_hsa_executable_freeze& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_executable_freeze& operator= (const HSA_APITrace_hsa_executable_freeze& rhs) = delete;

    hsa_executable_t m_executable; ///< Parameter passed to hsa_executable_freeze
    const char* m_options; ///< Parameter passed to hsa_executable_freeze
    std::string m_optionsVal; ///< Member to hold value passed to hsa_executable_freeze in options parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_executable_freeze
};

///////////////////////////////////////////////////
/// Class used to trace hsa_executable_get_info
///////////////////////////////////////////////////
class HSA_APITrace_hsa_executable_get_info : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_executable_get_info();

    /// Destructor
    ~HSA_APITrace_hsa_executable_get_info();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_executable_get_info
    /// \param ullEndTime the end timestamp for hsa_executable_get_info
    /// \param executable Parameter passed to hsa_executable_get_info
    /// \param attribute Parameter passed to hsa_executable_get_info
    /// \param value Parameter passed to hsa_executable_get_info
    /// \param retVal the return value for hsa_executable_get_info
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_executable_t executable,
                hsa_executable_info_t attribute,
                void* value,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_executable_get_info(const HSA_APITrace_hsa_executable_get_info& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_executable_get_info& operator= (const HSA_APITrace_hsa_executable_get_info& rhs) = delete;

    hsa_executable_t m_executable; ///< Parameter passed to hsa_executable_get_info
    hsa_executable_info_t m_attribute; ///< Parameter passed to hsa_executable_get_info
    void* m_value; ///< Parameter passed to hsa_executable_get_info
    hsa_status_t m_retVal; ///< Parameter passed to hsa_executable_get_info
};

///////////////////////////////////////////////////
/// Class used to trace hsa_executable_global_variable_define
///////////////////////////////////////////////////
class HSA_APITrace_hsa_executable_global_variable_define : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_executable_global_variable_define();

    /// Destructor
    ~HSA_APITrace_hsa_executable_global_variable_define();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_executable_global_variable_define
    /// \param ullEndTime the end timestamp for hsa_executable_global_variable_define
    /// \param executable Parameter passed to hsa_executable_global_variable_define
    /// \param variable_name Parameter passed to hsa_executable_global_variable_define
    /// \param address Parameter passed to hsa_executable_global_variable_define
    /// \param retVal the return value for hsa_executable_global_variable_define
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_executable_t executable,
                const char* variable_name,
                void* address,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_executable_global_variable_define(const HSA_APITrace_hsa_executable_global_variable_define& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_executable_global_variable_define& operator= (const HSA_APITrace_hsa_executable_global_variable_define& rhs) = delete;

    hsa_executable_t m_executable; ///< Parameter passed to hsa_executable_global_variable_define
    const char* m_variable_name; ///< Parameter passed to hsa_executable_global_variable_define
    std::string m_variable_nameVal; ///< Member to hold value passed to hsa_executable_global_variable_define in variable_name parameter
    void* m_address; ///< Parameter passed to hsa_executable_global_variable_define
    hsa_status_t m_retVal; ///< Parameter passed to hsa_executable_global_variable_define
};

///////////////////////////////////////////////////
/// Class used to trace hsa_executable_agent_global_variable_define
///////////////////////////////////////////////////
class HSA_APITrace_hsa_executable_agent_global_variable_define : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_executable_agent_global_variable_define();

    /// Destructor
    ~HSA_APITrace_hsa_executable_agent_global_variable_define();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_executable_agent_global_variable_define
    /// \param ullEndTime the end timestamp for hsa_executable_agent_global_variable_define
    /// \param executable Parameter passed to hsa_executable_agent_global_variable_define
    /// \param agent Parameter passed to hsa_executable_agent_global_variable_define
    /// \param variable_name Parameter passed to hsa_executable_agent_global_variable_define
    /// \param address Parameter passed to hsa_executable_agent_global_variable_define
    /// \param retVal the return value for hsa_executable_agent_global_variable_define
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_executable_t executable,
                hsa_agent_t agent,
                const char* variable_name,
                void* address,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_executable_agent_global_variable_define(const HSA_APITrace_hsa_executable_agent_global_variable_define& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_executable_agent_global_variable_define& operator= (const HSA_APITrace_hsa_executable_agent_global_variable_define& rhs) = delete;

    hsa_executable_t m_executable; ///< Parameter passed to hsa_executable_agent_global_variable_define
    hsa_agent_t m_agent; ///< Parameter passed to hsa_executable_agent_global_variable_define
    const char* m_variable_name; ///< Parameter passed to hsa_executable_agent_global_variable_define
    std::string m_variable_nameVal; ///< Member to hold value passed to hsa_executable_agent_global_variable_define in variable_name parameter
    void* m_address; ///< Parameter passed to hsa_executable_agent_global_variable_define
    hsa_status_t m_retVal; ///< Parameter passed to hsa_executable_agent_global_variable_define
};

///////////////////////////////////////////////////
/// Class used to trace hsa_executable_readonly_variable_define
///////////////////////////////////////////////////
class HSA_APITrace_hsa_executable_readonly_variable_define : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_executable_readonly_variable_define();

    /// Destructor
    ~HSA_APITrace_hsa_executable_readonly_variable_define();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_executable_readonly_variable_define
    /// \param ullEndTime the end timestamp for hsa_executable_readonly_variable_define
    /// \param executable Parameter passed to hsa_executable_readonly_variable_define
    /// \param agent Parameter passed to hsa_executable_readonly_variable_define
    /// \param variable_name Parameter passed to hsa_executable_readonly_variable_define
    /// \param address Parameter passed to hsa_executable_readonly_variable_define
    /// \param retVal the return value for hsa_executable_readonly_variable_define
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_executable_t executable,
                hsa_agent_t agent,
                const char* variable_name,
                void* address,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_executable_readonly_variable_define(const HSA_APITrace_hsa_executable_readonly_variable_define& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_executable_readonly_variable_define& operator= (const HSA_APITrace_hsa_executable_readonly_variable_define& rhs) = delete;

    hsa_executable_t m_executable; ///< Parameter passed to hsa_executable_readonly_variable_define
    hsa_agent_t m_agent; ///< Parameter passed to hsa_executable_readonly_variable_define
    const char* m_variable_name; ///< Parameter passed to hsa_executable_readonly_variable_define
    std::string m_variable_nameVal; ///< Member to hold value passed to hsa_executable_readonly_variable_define in variable_name parameter
    void* m_address; ///< Parameter passed to hsa_executable_readonly_variable_define
    hsa_status_t m_retVal; ///< Parameter passed to hsa_executable_readonly_variable_define
};

///////////////////////////////////////////////////
/// Class used to trace hsa_executable_validate
///////////////////////////////////////////////////
class HSA_APITrace_hsa_executable_validate : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_executable_validate();

    /// Destructor
    ~HSA_APITrace_hsa_executable_validate();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_executable_validate
    /// \param ullEndTime the end timestamp for hsa_executable_validate
    /// \param executable Parameter passed to hsa_executable_validate
    /// \param result Parameter passed to hsa_executable_validate
    /// \param retVal the return value for hsa_executable_validate
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_executable_t executable,
                uint32_t* result,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_executable_validate(const HSA_APITrace_hsa_executable_validate& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_executable_validate& operator= (const HSA_APITrace_hsa_executable_validate& rhs) = delete;

    hsa_executable_t m_executable; ///< Parameter passed to hsa_executable_validate
    uint32_t* m_result; ///< Parameter passed to hsa_executable_validate
    uint32_t m_resultVal; ///< Member to hold value passed to hsa_executable_validate in result parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_executable_validate
};

///////////////////////////////////////////////////
/// Class used to trace hsa_executable_validate_alt
///////////////////////////////////////////////////
class HSA_APITrace_hsa_executable_validate_alt : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_executable_validate_alt();

    /// Destructor
    ~HSA_APITrace_hsa_executable_validate_alt();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_executable_validate_alt
    /// \param ullEndTime the end timestamp for hsa_executable_validate_alt
    /// \param executable Parameter passed to hsa_executable_validate_alt
    /// \param options Parameter passed to hsa_executable_validate_alt
    /// \param result Parameter passed to hsa_executable_validate_alt
    /// \param retVal the return value for hsa_executable_validate_alt
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_executable_t executable,
                const char* options,
                uint32_t* result,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_executable_validate_alt(const HSA_APITrace_hsa_executable_validate_alt& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_executable_validate_alt& operator= (const HSA_APITrace_hsa_executable_validate_alt& rhs) = delete;

    hsa_executable_t m_executable; ///< Parameter passed to hsa_executable_validate_alt
    const char* m_options; ///< Parameter passed to hsa_executable_validate_alt
    std::string m_optionsVal; ///< Member to hold value passed to hsa_executable_validate_alt in options parameter
    uint32_t* m_result; ///< Parameter passed to hsa_executable_validate_alt
    uint32_t m_resultVal; ///< Member to hold value passed to hsa_executable_validate_alt in result parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_executable_validate_alt
};

///////////////////////////////////////////////////
/// Class used to trace hsa_executable_get_symbol
///////////////////////////////////////////////////
class HSA_APITrace_hsa_executable_get_symbol : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_executable_get_symbol();

    /// Destructor
    ~HSA_APITrace_hsa_executable_get_symbol();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_executable_get_symbol
    /// \param ullEndTime the end timestamp for hsa_executable_get_symbol
    /// \param executable Parameter passed to hsa_executable_get_symbol
    /// \param module_name Parameter passed to hsa_executable_get_symbol
    /// \param symbol_name Parameter passed to hsa_executable_get_symbol
    /// \param agent Parameter passed to hsa_executable_get_symbol
    /// \param call_convention Parameter passed to hsa_executable_get_symbol
    /// \param symbol Parameter passed to hsa_executable_get_symbol
    /// \param retVal the return value for hsa_executable_get_symbol
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_executable_t executable,
                const char* module_name,
                const char* symbol_name,
                hsa_agent_t agent,
                int32_t call_convention,
                hsa_executable_symbol_t* symbol,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_executable_get_symbol(const HSA_APITrace_hsa_executable_get_symbol& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_executable_get_symbol& operator= (const HSA_APITrace_hsa_executable_get_symbol& rhs) = delete;

    hsa_executable_t m_executable; ///< Parameter passed to hsa_executable_get_symbol
    const char* m_module_name; ///< Parameter passed to hsa_executable_get_symbol
    std::string m_module_nameVal; ///< Member to hold value passed to hsa_executable_get_symbol in module_name parameter
    const char* m_symbol_name; ///< Parameter passed to hsa_executable_get_symbol
    std::string m_symbol_nameVal; ///< Member to hold value passed to hsa_executable_get_symbol in symbol_name parameter
    hsa_agent_t m_agent; ///< Parameter passed to hsa_executable_get_symbol
    int32_t m_call_convention; ///< Parameter passed to hsa_executable_get_symbol
    hsa_executable_symbol_t* m_symbol; ///< Parameter passed to hsa_executable_get_symbol
    hsa_executable_symbol_t m_symbolVal; ///< Member to hold value passed to hsa_executable_get_symbol in symbol parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_executable_get_symbol
};

///////////////////////////////////////////////////
/// Class used to trace hsa_executable_get_symbol_by_name
///////////////////////////////////////////////////
class HSA_APITrace_hsa_executable_get_symbol_by_name : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_executable_get_symbol_by_name();

    /// Destructor
    ~HSA_APITrace_hsa_executable_get_symbol_by_name();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_executable_get_symbol_by_name
    /// \param ullEndTime the end timestamp for hsa_executable_get_symbol_by_name
    /// \param executable Parameter passed to hsa_executable_get_symbol_by_name
    /// \param symbol_name Parameter passed to hsa_executable_get_symbol_by_name
    /// \param agent Parameter passed to hsa_executable_get_symbol_by_name
    /// \param symbol Parameter passed to hsa_executable_get_symbol_by_name
    /// \param retVal the return value for hsa_executable_get_symbol_by_name
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_executable_t executable,
                const char* symbol_name,
                const hsa_agent_t* agent,
                hsa_executable_symbol_t* symbol,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_executable_get_symbol_by_name(const HSA_APITrace_hsa_executable_get_symbol_by_name& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_executable_get_symbol_by_name& operator= (const HSA_APITrace_hsa_executable_get_symbol_by_name& rhs) = delete;

    hsa_executable_t m_executable; ///< Parameter passed to hsa_executable_get_symbol_by_name
    const char* m_symbol_name; ///< Parameter passed to hsa_executable_get_symbol_by_name
    std::string m_symbol_nameVal; ///< Member to hold value passed to hsa_executable_get_symbol_by_name in symbol_name parameter
    const hsa_agent_t* m_agent; ///< Parameter passed to hsa_executable_get_symbol_by_name
    hsa_agent_t m_agentVal; ///< Member to hold value passed to hsa_executable_get_symbol_by_name in agent parameter
    hsa_executable_symbol_t* m_symbol; ///< Parameter passed to hsa_executable_get_symbol_by_name
    hsa_executable_symbol_t m_symbolVal; ///< Member to hold value passed to hsa_executable_get_symbol_by_name in symbol parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_executable_get_symbol_by_name
};

///////////////////////////////////////////////////
/// Class used to trace hsa_executable_symbol_get_info
///////////////////////////////////////////////////
class HSA_APITrace_hsa_executable_symbol_get_info : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_executable_symbol_get_info();

    /// Destructor
    ~HSA_APITrace_hsa_executable_symbol_get_info();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_executable_symbol_get_info
    /// \param ullEndTime the end timestamp for hsa_executable_symbol_get_info
    /// \param executable_symbol Parameter passed to hsa_executable_symbol_get_info
    /// \param attribute Parameter passed to hsa_executable_symbol_get_info
    /// \param value Parameter passed to hsa_executable_symbol_get_info
    /// \param retVal the return value for hsa_executable_symbol_get_info
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_executable_symbol_t executable_symbol,
                hsa_executable_symbol_info_t attribute,
                void* value,
                uint32_t valueLength,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_executable_symbol_get_info(const HSA_APITrace_hsa_executable_symbol_get_info& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_executable_symbol_get_info& operator= (const HSA_APITrace_hsa_executable_symbol_get_info& rhs) = delete;

    hsa_executable_symbol_t m_executable_symbol; ///< Parameter passed to hsa_executable_symbol_get_info
    hsa_executable_symbol_info_t m_attribute; ///< Parameter passed to hsa_executable_symbol_get_info
    void* m_value; ///< Parameter passed to hsa_executable_symbol_get_info
    hsa_status_t m_retVal; ///< Parameter passed to hsa_executable_symbol_get_info
};

///////////////////////////////////////////////////
/// Class used to trace hsa_executable_iterate_symbols
///////////////////////////////////////////////////
class HSA_APITrace_hsa_executable_iterate_symbols : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_executable_iterate_symbols();

    /// Destructor
    ~HSA_APITrace_hsa_executable_iterate_symbols();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_executable_iterate_symbols
    /// \param ullEndTime the end timestamp for hsa_executable_iterate_symbols
    /// \param executable Parameter passed to hsa_executable_iterate_symbols
    /// \param callback Parameter passed to hsa_executable_iterate_symbols
    /// \param data Parameter passed to hsa_executable_iterate_symbols
    /// \param retVal the return value for hsa_executable_iterate_symbols
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_executable_t executable,
                hsa_status_t (*callback)(hsa_executable_t exec, hsa_executable_symbol_t symbol, void* data),
                void* data,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_executable_iterate_symbols(const HSA_APITrace_hsa_executable_iterate_symbols& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_executable_iterate_symbols& operator= (const HSA_APITrace_hsa_executable_iterate_symbols& rhs) = delete;

    hsa_executable_t m_executable; ///< Parameter passed to hsa_executable_iterate_symbols
    hsa_status_t (*m_callback)(hsa_executable_t exec, hsa_executable_symbol_t symbol, void* data); ///< Parameter passed to hsa_executable_iterate_symbols
    void* m_data; ///< Parameter passed to hsa_executable_iterate_symbols
    hsa_status_t m_retVal; ///< Parameter passed to hsa_executable_iterate_symbols
};

///////////////////////////////////////////////////
/// Class used to trace hsa_executable_iterate_agent_symbols
///////////////////////////////////////////////////
class HSA_APITrace_hsa_executable_iterate_agent_symbols : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_executable_iterate_agent_symbols();

    /// Destructor
    ~HSA_APITrace_hsa_executable_iterate_agent_symbols();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_executable_iterate_agent_symbols
    /// \param ullEndTime the end timestamp for hsa_executable_iterate_agent_symbols
    /// \param executable Parameter passed to hsa_executable_iterate_agent_symbols
    /// \param agent Parameter passed to hsa_executable_iterate_agent_symbols
    /// \param callback Parameter passed to hsa_executable_iterate_agent_symbols
    /// \param data Parameter passed to hsa_executable_iterate_agent_symbols
    /// \param retVal the return value for hsa_executable_iterate_agent_symbols
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_executable_t executable,
                hsa_agent_t agent,
                hsa_status_t (*callback)(hsa_executable_t exec, hsa_agent_t agent, hsa_executable_symbol_t symbol, void* data),
                void* data,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_executable_iterate_agent_symbols(const HSA_APITrace_hsa_executable_iterate_agent_symbols& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_executable_iterate_agent_symbols& operator= (const HSA_APITrace_hsa_executable_iterate_agent_symbols& rhs) = delete;

    hsa_executable_t m_executable; ///< Parameter passed to hsa_executable_iterate_agent_symbols
    hsa_agent_t m_agent; ///< Parameter passed to hsa_executable_iterate_agent_symbols
    hsa_status_t (*m_callback)(hsa_executable_t exec, hsa_agent_t agent, hsa_executable_symbol_t symbol, void* data); ///< Parameter passed to hsa_executable_iterate_agent_symbols
    void* m_data; ///< Parameter passed to hsa_executable_iterate_agent_symbols
    hsa_status_t m_retVal; ///< Parameter passed to hsa_executable_iterate_agent_symbols
};

///////////////////////////////////////////////////
/// Class used to trace hsa_executable_iterate_program_symbols
///////////////////////////////////////////////////
class HSA_APITrace_hsa_executable_iterate_program_symbols : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_executable_iterate_program_symbols();

    /// Destructor
    ~HSA_APITrace_hsa_executable_iterate_program_symbols();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_executable_iterate_program_symbols
    /// \param ullEndTime the end timestamp for hsa_executable_iterate_program_symbols
    /// \param executable Parameter passed to hsa_executable_iterate_program_symbols
    /// \param callback Parameter passed to hsa_executable_iterate_program_symbols
    /// \param data Parameter passed to hsa_executable_iterate_program_symbols
    /// \param retVal the return value for hsa_executable_iterate_program_symbols
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_executable_t executable,
                hsa_status_t (*callback)(hsa_executable_t exec, hsa_executable_symbol_t symbol, void* data),
                void* data,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_executable_iterate_program_symbols(const HSA_APITrace_hsa_executable_iterate_program_symbols& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_executable_iterate_program_symbols& operator= (const HSA_APITrace_hsa_executable_iterate_program_symbols& rhs) = delete;

    hsa_executable_t m_executable; ///< Parameter passed to hsa_executable_iterate_program_symbols
    hsa_status_t (*m_callback)(hsa_executable_t exec, hsa_executable_symbol_t symbol, void* data); ///< Parameter passed to hsa_executable_iterate_program_symbols
    void* m_data; ///< Parameter passed to hsa_executable_iterate_program_symbols
    hsa_status_t m_retVal; ///< Parameter passed to hsa_executable_iterate_program_symbols
};

///////////////////////////////////////////////////
/// Class used to trace hsa_code_object_serialize
///////////////////////////////////////////////////
class HSA_APITrace_hsa_code_object_serialize : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_code_object_serialize();

    /// Destructor
    ~HSA_APITrace_hsa_code_object_serialize();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_code_object_serialize
    /// \param ullEndTime the end timestamp for hsa_code_object_serialize
    /// \param code_object Parameter passed to hsa_code_object_serialize
    /// \param alloc_callback Parameter passed to hsa_code_object_serialize
    /// \param callback_data Parameter passed to hsa_code_object_serialize
    /// \param options Parameter passed to hsa_code_object_serialize
    /// \param serialized_code_object Parameter passed to hsa_code_object_serialize
    /// \param serialized_code_object_size Parameter passed to hsa_code_object_serialize
    /// \param retVal the return value for hsa_code_object_serialize
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_code_object_t code_object,
                hsa_status_t (*alloc_callback)(size_t size, hsa_callback_data_t data, void** address),
                hsa_callback_data_t callback_data,
                const char* options,
                void** serialized_code_object,
                size_t* serialized_code_object_size,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_code_object_serialize(const HSA_APITrace_hsa_code_object_serialize& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_code_object_serialize& operator= (const HSA_APITrace_hsa_code_object_serialize& rhs) = delete;

    hsa_code_object_t m_code_object; ///< Parameter passed to hsa_code_object_serialize
    hsa_status_t (*m_alloc_callback)(size_t size, hsa_callback_data_t data, void** address); ///< Parameter passed to hsa_code_object_serialize
    hsa_callback_data_t m_callback_data; ///< Parameter passed to hsa_code_object_serialize
    const char* m_options; ///< Parameter passed to hsa_code_object_serialize
    std::string m_optionsVal; ///< Member to hold value passed to hsa_code_object_serialize in options parameter
    void** m_serialized_code_object; ///< Parameter passed to hsa_code_object_serialize
    uintptr_t m_serialized_code_objectVal; ///< Member to hold value passed to hsa_code_object_serialize in serialized_code_object parameter
    size_t* m_serialized_code_object_size; ///< Parameter passed to hsa_code_object_serialize
    size_t m_serialized_code_object_sizeVal; ///< Member to hold value passed to hsa_code_object_serialize in serialized_code_object_size parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_code_object_serialize
};

///////////////////////////////////////////////////
/// Class used to trace hsa_code_object_deserialize
///////////////////////////////////////////////////
class HSA_APITrace_hsa_code_object_deserialize : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_code_object_deserialize();

    /// Destructor
    ~HSA_APITrace_hsa_code_object_deserialize();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_code_object_deserialize
    /// \param ullEndTime the end timestamp for hsa_code_object_deserialize
    /// \param serialized_code_object Parameter passed to hsa_code_object_deserialize
    /// \param serialized_code_object_size Parameter passed to hsa_code_object_deserialize
    /// \param options Parameter passed to hsa_code_object_deserialize
    /// \param code_object Parameter passed to hsa_code_object_deserialize
    /// \param retVal the return value for hsa_code_object_deserialize
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                void* serialized_code_object,
                size_t serialized_code_object_size,
                const char* options,
                hsa_code_object_t* code_object,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_code_object_deserialize(const HSA_APITrace_hsa_code_object_deserialize& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_code_object_deserialize& operator= (const HSA_APITrace_hsa_code_object_deserialize& rhs) = delete;

    void* m_serialized_code_object; ///< Parameter passed to hsa_code_object_deserialize
    size_t m_serialized_code_object_size; ///< Parameter passed to hsa_code_object_deserialize
    const char* m_options; ///< Parameter passed to hsa_code_object_deserialize
    std::string m_optionsVal; ///< Member to hold value passed to hsa_code_object_deserialize in options parameter
    hsa_code_object_t* m_code_object; ///< Parameter passed to hsa_code_object_deserialize
    hsa_code_object_t m_code_objectVal; ///< Member to hold value passed to hsa_code_object_deserialize in code_object parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_code_object_deserialize
};

///////////////////////////////////////////////////
/// Class used to trace hsa_code_object_destroy
///////////////////////////////////////////////////
class HSA_APITrace_hsa_code_object_destroy : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_code_object_destroy();

    /// Destructor
    ~HSA_APITrace_hsa_code_object_destroy();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_code_object_destroy
    /// \param ullEndTime the end timestamp for hsa_code_object_destroy
    /// \param code_object Parameter passed to hsa_code_object_destroy
    /// \param retVal the return value for hsa_code_object_destroy
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_code_object_t code_object,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_code_object_destroy(const HSA_APITrace_hsa_code_object_destroy& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_code_object_destroy& operator= (const HSA_APITrace_hsa_code_object_destroy& rhs) = delete;

    hsa_code_object_t m_code_object; ///< Parameter passed to hsa_code_object_destroy
    hsa_status_t m_retVal; ///< Parameter passed to hsa_code_object_destroy
};

///////////////////////////////////////////////////
/// Class used to trace hsa_code_object_get_info
///////////////////////////////////////////////////
class HSA_APITrace_hsa_code_object_get_info : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_code_object_get_info();

    /// Destructor
    ~HSA_APITrace_hsa_code_object_get_info();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_code_object_get_info
    /// \param ullEndTime the end timestamp for hsa_code_object_get_info
    /// \param code_object Parameter passed to hsa_code_object_get_info
    /// \param attribute Parameter passed to hsa_code_object_get_info
    /// \param value Parameter passed to hsa_code_object_get_info
    /// \param retVal the return value for hsa_code_object_get_info
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_code_object_t code_object,
                hsa_code_object_info_t attribute,
                void* value,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_code_object_get_info(const HSA_APITrace_hsa_code_object_get_info& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_code_object_get_info& operator= (const HSA_APITrace_hsa_code_object_get_info& rhs) = delete;

    hsa_code_object_t m_code_object; ///< Parameter passed to hsa_code_object_get_info
    hsa_code_object_info_t m_attribute; ///< Parameter passed to hsa_code_object_get_info
    void* m_value; ///< Parameter passed to hsa_code_object_get_info
    hsa_status_t m_retVal; ///< Parameter passed to hsa_code_object_get_info
};

///////////////////////////////////////////////////
/// Class used to trace hsa_executable_load_code_object
///////////////////////////////////////////////////
class HSA_APITrace_hsa_executable_load_code_object : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_executable_load_code_object();

    /// Destructor
    ~HSA_APITrace_hsa_executable_load_code_object();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_executable_load_code_object
    /// \param ullEndTime the end timestamp for hsa_executable_load_code_object
    /// \param executable Parameter passed to hsa_executable_load_code_object
    /// \param agent Parameter passed to hsa_executable_load_code_object
    /// \param code_object Parameter passed to hsa_executable_load_code_object
    /// \param options Parameter passed to hsa_executable_load_code_object
    /// \param retVal the return value for hsa_executable_load_code_object
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_executable_t executable,
                hsa_agent_t agent,
                hsa_code_object_t code_object,
                const char* options,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_executable_load_code_object(const HSA_APITrace_hsa_executable_load_code_object& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_executable_load_code_object& operator= (const HSA_APITrace_hsa_executable_load_code_object& rhs) = delete;

    hsa_executable_t m_executable; ///< Parameter passed to hsa_executable_load_code_object
    hsa_agent_t m_agent; ///< Parameter passed to hsa_executable_load_code_object
    hsa_code_object_t m_code_object; ///< Parameter passed to hsa_executable_load_code_object
    const char* m_options; ///< Parameter passed to hsa_executable_load_code_object
    std::string m_optionsVal; ///< Member to hold value passed to hsa_executable_load_code_object in options parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_executable_load_code_object
};

///////////////////////////////////////////////////
/// Class used to trace hsa_code_object_get_symbol
///////////////////////////////////////////////////
class HSA_APITrace_hsa_code_object_get_symbol : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_code_object_get_symbol();

    /// Destructor
    ~HSA_APITrace_hsa_code_object_get_symbol();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_code_object_get_symbol
    /// \param ullEndTime the end timestamp for hsa_code_object_get_symbol
    /// \param code_object Parameter passed to hsa_code_object_get_symbol
    /// \param symbol_name Parameter passed to hsa_code_object_get_symbol
    /// \param symbol Parameter passed to hsa_code_object_get_symbol
    /// \param retVal the return value for hsa_code_object_get_symbol
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_code_object_t code_object,
                const char* symbol_name,
                hsa_code_symbol_t* symbol,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_code_object_get_symbol(const HSA_APITrace_hsa_code_object_get_symbol& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_code_object_get_symbol& operator= (const HSA_APITrace_hsa_code_object_get_symbol& rhs) = delete;

    hsa_code_object_t m_code_object; ///< Parameter passed to hsa_code_object_get_symbol
    const char* m_symbol_name; ///< Parameter passed to hsa_code_object_get_symbol
    std::string m_symbol_nameVal; ///< Member to hold value passed to hsa_code_object_get_symbol in symbol_name parameter
    hsa_code_symbol_t* m_symbol; ///< Parameter passed to hsa_code_object_get_symbol
    hsa_code_symbol_t m_symbolVal; ///< Member to hold value passed to hsa_code_object_get_symbol in symbol parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_code_object_get_symbol
};

///////////////////////////////////////////////////
/// Class used to trace hsa_code_object_get_symbol_from_name
///////////////////////////////////////////////////
class HSA_APITrace_hsa_code_object_get_symbol_from_name : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_code_object_get_symbol_from_name();

    /// Destructor
    ~HSA_APITrace_hsa_code_object_get_symbol_from_name();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_code_object_get_symbol_from_name
    /// \param ullEndTime the end timestamp for hsa_code_object_get_symbol_from_name
    /// \param code_object Parameter passed to hsa_code_object_get_symbol_from_name
    /// \param module_name Parameter passed to hsa_code_object_get_symbol_from_name
    /// \param symbol_name Parameter passed to hsa_code_object_get_symbol_from_name
    /// \param symbol Parameter passed to hsa_code_object_get_symbol_from_name
    /// \param retVal the return value for hsa_code_object_get_symbol_from_name
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_code_object_t code_object,
                const char* module_name,
                const char* symbol_name,
                hsa_code_symbol_t* symbol,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_code_object_get_symbol_from_name(const HSA_APITrace_hsa_code_object_get_symbol_from_name& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_code_object_get_symbol_from_name& operator= (const HSA_APITrace_hsa_code_object_get_symbol_from_name& rhs) = delete;

    hsa_code_object_t m_code_object; ///< Parameter passed to hsa_code_object_get_symbol_from_name
    const char* m_module_name; ///< Parameter passed to hsa_code_object_get_symbol_from_name
    std::string m_module_nameVal; ///< Member to hold value passed to hsa_code_object_get_symbol_from_name in module_name parameter
    const char* m_symbol_name; ///< Parameter passed to hsa_code_object_get_symbol_from_name
    std::string m_symbol_nameVal; ///< Member to hold value passed to hsa_code_object_get_symbol_from_name in symbol_name parameter
    hsa_code_symbol_t* m_symbol; ///< Parameter passed to hsa_code_object_get_symbol_from_name
    hsa_code_symbol_t m_symbolVal; ///< Member to hold value passed to hsa_code_object_get_symbol_from_name in symbol parameter
    hsa_status_t m_retVal; ///< Parameter passed to hsa_code_object_get_symbol_from_name
};

///////////////////////////////////////////////////
/// Class used to trace hsa_code_symbol_get_info
///////////////////////////////////////////////////
class HSA_APITrace_hsa_code_symbol_get_info : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_code_symbol_get_info();

    /// Destructor
    ~HSA_APITrace_hsa_code_symbol_get_info();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_code_symbol_get_info
    /// \param ullEndTime the end timestamp for hsa_code_symbol_get_info
    /// \param code_symbol Parameter passed to hsa_code_symbol_get_info
    /// \param attribute Parameter passed to hsa_code_symbol_get_info
    /// \param value Parameter passed to hsa_code_symbol_get_info
    /// \param retVal the return value for hsa_code_symbol_get_info
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_code_symbol_t code_symbol,
                hsa_code_symbol_info_t attribute,
                void* value,
                uint32_t valueLength,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_code_symbol_get_info(const HSA_APITrace_hsa_code_symbol_get_info& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_code_symbol_get_info& operator= (const HSA_APITrace_hsa_code_symbol_get_info& rhs) = delete;

    hsa_code_symbol_t m_code_symbol; ///< Parameter passed to hsa_code_symbol_get_info
    hsa_code_symbol_info_t m_attribute; ///< Parameter passed to hsa_code_symbol_get_info
    void* m_value; ///< Parameter passed to hsa_code_symbol_get_info
    hsa_status_t m_retVal; ///< Parameter passed to hsa_code_symbol_get_info
};

///////////////////////////////////////////////////
/// Class used to trace hsa_code_object_iterate_symbols
///////////////////////////////////////////////////
class HSA_APITrace_hsa_code_object_iterate_symbols : public HSAAPIBase
{
public:
    /// Constructor
    HSA_APITrace_hsa_code_object_iterate_symbols();

    /// Destructor
    ~HSA_APITrace_hsa_code_object_iterate_symbols();

    /// get return value string
    /// \return string representation of the return value;
    std::string GetRetString();

    /// Returns the API's arguments formatted as strings
    /// \return string representation of the API's arguments
    std::string ToString();

    /// Assigns the API's various parameter values
    /// \param ullStartTime the start timestamp for hsa_code_object_iterate_symbols
    /// \param ullEndTime the end timestamp for hsa_code_object_iterate_symbols
    /// \param code_object Parameter passed to hsa_code_object_iterate_symbols
    /// \param callback Parameter passed to hsa_code_object_iterate_symbols
    /// \param data Parameter passed to hsa_code_object_iterate_symbols
    /// \param retVal the return value for hsa_code_object_iterate_symbols
    void Create(ULONGLONG ullStartTime,
                ULONGLONG ullEndTime,
                hsa_code_object_t code_object,
                hsa_status_t (*callback)(hsa_code_object_t code_object, hsa_code_symbol_t symbol, void* data),
                void* data,
                hsa_status_t retVal);

private:
    /// Disabled copy constructor
    /// \rhs item being copied
    HSA_APITrace_hsa_code_object_iterate_symbols(const HSA_APITrace_hsa_code_object_iterate_symbols& rhs) = delete;

    /// Disabled assignment operator
    /// \rhs item being assigned
    HSA_APITrace_hsa_code_object_iterate_symbols& operator= (const HSA_APITrace_hsa_code_object_iterate_symbols& rhs) = delete;

    hsa_code_object_t m_code_object; ///< Parameter passed to hsa_code_object_iterate_symbols
    hsa_status_t (*m_callback)(hsa_code_object_t code_object, hsa_code_symbol_t symbol, void* data); ///< Parameter passed to hsa_code_object_iterate_symbols
    void* m_data; ///< Parameter passed to hsa_code_object_iterate_symbols
    hsa_status_t m_retVal; ///< Parameter passed to hsa_code_object_iterate_symbols
};



#endif // _HSACOREAPITRACECLASSES_H_

