//==============================================================================
// Copyright (c) 2015-2018 Advanced Micro Devices, Inc. All rights reserved.
/// \author AMD Developer Tools Team
/// \file
/// \brief THIS CODE WAS AUTOGENERATED BY HSA CODE GENERATOR
//==============================================================================

#include "../HSATraceStringUtils.h"
#include "HSATraceStringOutput.h"

#include "HSAAMDExtensionAPITraceClasses.h"

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_coherency_get_type
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_coherency_get_type::HSA_APITrace_hsa_amd_coherency_get_type()
{
}

HSA_APITrace_hsa_amd_coherency_get_type::~HSA_APITrace_hsa_amd_coherency_get_type()
{
}

std::string HSA_APITrace_hsa_amd_coherency_get_type::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_coherency_get_type::ToString()
{
    std::ostringstream ss;
    ss << "agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_agent) << s_strParamSeparator;
    ss << "type=" << HSATraceStringUtils::Get_hsa_amd_coherency_type_t_Ptr_String(m_type_, m_type_Val);
    return ss.str();
}

void HSA_APITrace_hsa_amd_coherency_get_type::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_agent_t agent,
    hsa_amd_coherency_type_t* type_,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_coherency_get_type;
    m_agent = agent;
    m_type_ = type_;

    if (nullptr != m_type_)
    {
        m_type_Val = *m_type_;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_coherency_set_type
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_coherency_set_type::HSA_APITrace_hsa_amd_coherency_set_type()
{
}

HSA_APITrace_hsa_amd_coherency_set_type::~HSA_APITrace_hsa_amd_coherency_set_type()
{
}

std::string HSA_APITrace_hsa_amd_coherency_set_type::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_coherency_set_type::ToString()
{
    std::ostringstream ss;
    ss << "agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_agent) << s_strParamSeparator;
    ss << "type=" << HSATraceStringUtils::Get_hsa_amd_coherency_type_t_String(m_type_);
    return ss.str();
}

void HSA_APITrace_hsa_amd_coherency_set_type::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_agent_t agent,
    hsa_amd_coherency_type_t type_,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_coherency_set_type;
    m_agent = agent;
    m_type_ = type_;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_profiling_set_profiler_enabled
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_profiling_set_profiler_enabled::HSA_APITrace_hsa_amd_profiling_set_profiler_enabled()
{
}

HSA_APITrace_hsa_amd_profiling_set_profiler_enabled::~HSA_APITrace_hsa_amd_profiling_set_profiler_enabled()
{
}

std::string HSA_APITrace_hsa_amd_profiling_set_profiler_enabled::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_profiling_set_profiler_enabled::ToString()
{
    std::ostringstream ss;
    ss << "queue=" << HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(m_queue, m_queueVal) << s_strParamSeparator;
    ss << "enable=" << StringUtils::ToString(m_enable);
    return ss.str();
}

void HSA_APITrace_hsa_amd_profiling_set_profiler_enabled::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_queue_t* queue,
    int enable,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_profiling_set_profiler_enabled;
    m_queue = queue;

    if (nullptr != m_queue)
    {
        m_queueVal = *m_queue;
    }

    m_enable = enable;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_profiling_async_copy_enable
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_profiling_async_copy_enable::HSA_APITrace_hsa_amd_profiling_async_copy_enable()
{
}

HSA_APITrace_hsa_amd_profiling_async_copy_enable::~HSA_APITrace_hsa_amd_profiling_async_copy_enable()
{
}

std::string HSA_APITrace_hsa_amd_profiling_async_copy_enable::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_profiling_async_copy_enable::ToString()
{
    std::ostringstream ss;
    ss << "enable=" << StringUtils::ToString(m_enable);
    return ss.str();
}

void HSA_APITrace_hsa_amd_profiling_async_copy_enable::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    bool enable,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_profiling_async_copy_enable;
    m_enable = enable;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_profiling_get_dispatch_time
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_profiling_get_dispatch_time::HSA_APITrace_hsa_amd_profiling_get_dispatch_time()
{
}

HSA_APITrace_hsa_amd_profiling_get_dispatch_time::~HSA_APITrace_hsa_amd_profiling_get_dispatch_time()
{
}

std::string HSA_APITrace_hsa_amd_profiling_get_dispatch_time::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_profiling_get_dispatch_time::ToString()
{
    std::ostringstream ss;
    ss << "agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_agent) << s_strParamSeparator;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "time=" << HSATraceStringUtils::Get_hsa_amd_profiling_dispatch_time_t_Ptr_String(m_time, m_timeVal);
    return ss.str();
}

void HSA_APITrace_hsa_amd_profiling_get_dispatch_time::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_agent_t agent,
    hsa_signal_t signal,
    hsa_amd_profiling_dispatch_time_t* time,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_profiling_get_dispatch_time;
    m_agent = agent;
    m_signal = signal;
    m_time = time;

    if (nullptr != m_time)
    {
        m_timeVal = *m_time;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_profiling_get_async_copy_time
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_profiling_get_async_copy_time::HSA_APITrace_hsa_amd_profiling_get_async_copy_time()
{
}

HSA_APITrace_hsa_amd_profiling_get_async_copy_time::~HSA_APITrace_hsa_amd_profiling_get_async_copy_time()
{
}

std::string HSA_APITrace_hsa_amd_profiling_get_async_copy_time::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_profiling_get_async_copy_time::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "time=" << HSATraceStringUtils::Get_hsa_amd_profiling_async_copy_time_t_Ptr_String(m_time, m_timeVal);
    return ss.str();
}

void HSA_APITrace_hsa_amd_profiling_get_async_copy_time::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_amd_profiling_async_copy_time_t* time,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_profiling_get_async_copy_time;
    m_signal = signal;
    m_time = time;

    if (nullptr != m_time)
    {
        m_timeVal = *m_time;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_profiling_convert_tick_to_system_domain
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_profiling_convert_tick_to_system_domain::HSA_APITrace_hsa_amd_profiling_convert_tick_to_system_domain()
{
}

HSA_APITrace_hsa_amd_profiling_convert_tick_to_system_domain::~HSA_APITrace_hsa_amd_profiling_convert_tick_to_system_domain()
{
}

std::string HSA_APITrace_hsa_amd_profiling_convert_tick_to_system_domain::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_profiling_convert_tick_to_system_domain::ToString()
{
    std::ostringstream ss;
    ss << "agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_agent) << s_strParamSeparator;
    ss << "agent_tick=" << StringUtils::ToString(m_agent_tick) << s_strParamSeparator;
    ss << "system_tick=" << StringUtils::ToStringPtr(m_system_tick, m_system_tickVal);
    return ss.str();
}

void HSA_APITrace_hsa_amd_profiling_convert_tick_to_system_domain::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_agent_t agent,
    uint64_t agent_tick,
    uint64_t* system_tick,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_profiling_convert_tick_to_system_domain;
    m_agent = agent;
    m_agent_tick = agent_tick;
    m_system_tick = system_tick;

    if (nullptr != m_system_tick)
    {
        m_system_tickVal = *m_system_tick;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_signal_create
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_signal_create::HSA_APITrace_hsa_amd_signal_create()
{
}

HSA_APITrace_hsa_amd_signal_create::~HSA_APITrace_hsa_amd_signal_create()
{
}

std::string HSA_APITrace_hsa_amd_signal_create::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_signal_create::ToString()
{
    std::ostringstream ss;
    ss << "initial_value=" << StringUtils::ToString(m_initial_value) << s_strParamSeparator;
    ss << "num_consumers=" << StringUtils::ToString(m_num_consumers) << s_strParamSeparator;
    ss << "consumers=" << HSATraceStringUtils::Get_hsa_agent_t_Ptr_String(m_consumers, m_consumersVal) << s_strParamSeparator;
    ss << "attributes=" << StringUtils::ToString(m_attributes) << s_strParamSeparator;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_Ptr_String(m_signal, m_signalVal);
    return ss.str();
}

void HSA_APITrace_hsa_amd_signal_create::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_value_t initial_value,
    uint32_t num_consumers,
    const hsa_agent_t* consumers,
    uint64_t attributes,
    hsa_signal_t* signal,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_signal_create;
    m_initial_value = initial_value;
    m_num_consumers = num_consumers;
    m_consumers = consumers;

    if (nullptr != m_consumers)
    {
        m_consumersVal = *m_consumers;
    }

    m_attributes = attributes;
    m_signal = signal;

    if (nullptr != m_signal)
    {
        m_signalVal = *m_signal;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_signal_async_handler
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_signal_async_handler::HSA_APITrace_hsa_amd_signal_async_handler()
{
}

HSA_APITrace_hsa_amd_signal_async_handler::~HSA_APITrace_hsa_amd_signal_async_handler()
{
}

std::string HSA_APITrace_hsa_amd_signal_async_handler::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_signal_async_handler::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "cond=" << HSATraceStringUtils::Get_hsa_signal_condition_t_String(m_cond) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value) << s_strParamSeparator;
    ss << "handler=" << StringUtils::ToString(m_handler) << s_strParamSeparator;
    ss << "arg=" << StringUtils::ToHexString(m_arg);
    return ss.str();
}

void HSA_APITrace_hsa_amd_signal_async_handler::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_signal_condition_t cond,
    hsa_signal_value_t value,
    hsa_amd_signal_handler handler,
    void* arg,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_signal_async_handler;
    m_signal = signal;
    m_cond = cond;
    m_value = value;
    m_handler = handler;
    m_arg = arg;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_async_function
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_async_function::HSA_APITrace_hsa_amd_async_function()
{
}

HSA_APITrace_hsa_amd_async_function::~HSA_APITrace_hsa_amd_async_function()
{
}

std::string HSA_APITrace_hsa_amd_async_function::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_async_function::ToString()
{
    std::ostringstream ss;
    ss << "callback=" << StringUtils::ToString(reinterpret_cast<void*>(m_callback)) << s_strParamSeparator;
    ss << "arg=" << StringUtils::ToHexString(m_arg);
    return ss.str();
}

void HSA_APITrace_hsa_amd_async_function::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    void (*callback)(void* arg),
    void* arg,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_async_function;
    m_callback = callback;
    m_arg = arg;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_signal_wait_any
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_signal_wait_any::HSA_APITrace_hsa_amd_signal_wait_any()
{
}

HSA_APITrace_hsa_amd_signal_wait_any::~HSA_APITrace_hsa_amd_signal_wait_any()
{
}

std::string HSA_APITrace_hsa_amd_signal_wait_any::GetRetString()
{
    return StringUtils::ToString(m_retVal);
}

std::string HSA_APITrace_hsa_amd_signal_wait_any::ToString()
{
    std::ostringstream ss;
    ss << "signal_count=" << StringUtils::ToString(m_signal_count) << s_strParamSeparator;
    ss << "signals=" << HSATraceStringUtils::Get_hsa_signal_t_Ptr_String(m_signals, m_signalsVal) << s_strParamSeparator;
    ss << "conds=" << HSATraceStringUtils::Get_hsa_signal_condition_t_Ptr_String(m_conds, m_condsVal) << s_strParamSeparator;
    ss << "values=" << StringUtils::ToStringPtr(m_values, m_valuesVal) << s_strParamSeparator;
    ss << "timeout_hint=" << StringUtils::ToString(m_timeout_hint) << s_strParamSeparator;
    ss << "wait_hint=" << HSATraceStringUtils::Get_hsa_wait_state_t_String(m_wait_hint) << s_strParamSeparator;
    ss << "satisfying_value=" << StringUtils::ToStringPtr(m_satisfying_value, m_satisfying_valueVal);
    return ss.str();
}

void HSA_APITrace_hsa_amd_signal_wait_any::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    uint32_t signal_count,
    hsa_signal_t* signals,
    hsa_signal_condition_t* conds,
    hsa_signal_value_t* values,
    uint64_t timeout_hint,
    hsa_wait_state_t wait_hint,
    hsa_signal_value_t* satisfying_value,
    uint32_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_signal_wait_any;
    m_signal_count = signal_count;
    m_signals = signals;

    if (nullptr != m_signals)
    {
        m_signalsVal = *m_signals;
    }

    m_conds = conds;

    if (nullptr != m_conds)
    {
        m_condsVal = *m_conds;
    }

    m_values = values;

    if (nullptr != m_values)
    {
        m_valuesVal = *m_values;
    }

    m_timeout_hint = timeout_hint;
    m_wait_hint = wait_hint;
    m_satisfying_value = satisfying_value;

    if (nullptr != m_satisfying_value)
    {
        m_satisfying_valueVal = *m_satisfying_value;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_queue_cu_set_mask
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_queue_cu_set_mask::HSA_APITrace_hsa_amd_queue_cu_set_mask()
{
}

HSA_APITrace_hsa_amd_queue_cu_set_mask::~HSA_APITrace_hsa_amd_queue_cu_set_mask()
{
}

std::string HSA_APITrace_hsa_amd_queue_cu_set_mask::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_queue_cu_set_mask::ToString()
{
    std::ostringstream ss;
    ss << "queue=" << HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(m_queue, m_queueVal) << s_strParamSeparator;
    ss << "num_cu_mask_count=" << StringUtils::ToString(m_num_cu_mask_count) << s_strParamSeparator;
    ss << "cu_mask=" << StringUtils::ToStringPtr(m_cu_mask, m_cu_maskVal);
    return ss.str();
}

void HSA_APITrace_hsa_amd_queue_cu_set_mask::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    const hsa_queue_t* queue,
    uint32_t num_cu_mask_count,
    const uint32_t* cu_mask,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_queue_cu_set_mask;
    m_queue = queue;

    if (nullptr != m_queue)
    {
        m_queueVal = *m_queue;
    }

    m_num_cu_mask_count = num_cu_mask_count;
    m_cu_mask = cu_mask;

    if (nullptr != m_cu_mask)
    {
        m_cu_maskVal = *m_cu_mask;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_memory_pool_get_info
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_memory_pool_get_info::HSA_APITrace_hsa_amd_memory_pool_get_info() : m_value(nullptr)
{
}

HSA_APITrace_hsa_amd_memory_pool_get_info::~HSA_APITrace_hsa_amd_memory_pool_get_info()
{
    if (nullptr != m_value)
    {
        FreeBuffer(m_value);
    }
}

std::string HSA_APITrace_hsa_amd_memory_pool_get_info::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_memory_pool_get_info::ToString()
{
    std::ostringstream ss;
    ss << "memory_pool=" << HSATraceStringUtils::Get_hsa_amd_memory_pool_t_String(m_memory_pool) << s_strParamSeparator;
    ss << "attribute=" << HSATraceStringUtils::Get_hsa_amd_memory_pool_info_t_String(m_attribute) << s_strParamSeparator;
    ss << "value=" << HSATraceStringUtils::Get_hsa_amd_memory_pool_get_info_AttributeString(m_value, m_attribute, m_retVal);
    return ss.str();
}

void HSA_APITrace_hsa_amd_memory_pool_get_info::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_amd_memory_pool_t memory_pool,
    hsa_amd_memory_pool_info_t attribute,
    void* value,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_memory_pool_get_info;
    m_memory_pool = memory_pool;
    m_attribute = attribute;

    if (nullptr != value)
    {
        DeepCopyBuffer(&m_value, value, HSATraceStringUtils::Get_hsa_amd_memory_pool_get_info_AttributeSize(m_attribute));
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_agent_iterate_memory_pools
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_agent_iterate_memory_pools::HSA_APITrace_hsa_amd_agent_iterate_memory_pools()
{
}

HSA_APITrace_hsa_amd_agent_iterate_memory_pools::~HSA_APITrace_hsa_amd_agent_iterate_memory_pools()
{
}

std::string HSA_APITrace_hsa_amd_agent_iterate_memory_pools::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_agent_iterate_memory_pools::ToString()
{
    std::ostringstream ss;
    ss << "agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_agent) << s_strParamSeparator;
    ss << "callback=" << StringUtils::ToString(reinterpret_cast<void*>(m_callback)) << s_strParamSeparator;
    ss << "data=" << StringUtils::ToHexString(m_data);
    return ss.str();
}

void HSA_APITrace_hsa_amd_agent_iterate_memory_pools::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_agent_t agent,
    hsa_status_t (*callback)(hsa_amd_memory_pool_t memory_pool, void* data),
    void* data,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_agent_iterate_memory_pools;
    m_agent = agent;
    m_callback = callback;
    m_data = data;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_memory_pool_allocate
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_memory_pool_allocate::HSA_APITrace_hsa_amd_memory_pool_allocate()
{
}

HSA_APITrace_hsa_amd_memory_pool_allocate::~HSA_APITrace_hsa_amd_memory_pool_allocate()
{
}

std::string HSA_APITrace_hsa_amd_memory_pool_allocate::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_memory_pool_allocate::ToString()
{
    std::ostringstream ss;
    ss << "memory_pool=" << HSATraceStringUtils::Get_hsa_amd_memory_pool_t_String(m_memory_pool) << s_strParamSeparator;
    ss << "size=" << StringUtils::ToString(m_size) << s_strParamSeparator;
    ss << "flags=" << StringUtils::ToString(m_flags) << s_strParamSeparator;
    ss << "ptr=" << HSATraceStringUtils::SurroundWithDeRef(StringUtils::ToHexString(m_ptrVal));
    return ss.str();
}

void HSA_APITrace_hsa_amd_memory_pool_allocate::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_amd_memory_pool_t memory_pool,
    size_t size,
    uint32_t flags,
    void** ptr,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_memory_pool_allocate;
    m_memory_pool = memory_pool;
    m_size = size;
    m_flags = flags;
    m_ptr = ptr;

    if (nullptr != m_ptr)
    {
        m_ptrVal = reinterpret_cast<uintptr_t>(*m_ptr);
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_memory_pool_free
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_memory_pool_free::HSA_APITrace_hsa_amd_memory_pool_free()
{
}

HSA_APITrace_hsa_amd_memory_pool_free::~HSA_APITrace_hsa_amd_memory_pool_free()
{
}

std::string HSA_APITrace_hsa_amd_memory_pool_free::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_memory_pool_free::ToString()
{
    std::ostringstream ss;
    ss << "ptr=" << StringUtils::ToHexString(m_ptr);
    return ss.str();
}

void HSA_APITrace_hsa_amd_memory_pool_free::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    void* ptr,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_memory_pool_free;
    m_ptr = ptr;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_memory_async_copy
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_memory_async_copy::HSA_APITrace_hsa_amd_memory_async_copy()
{
}

HSA_APITrace_hsa_amd_memory_async_copy::~HSA_APITrace_hsa_amd_memory_async_copy()
{
}

std::string HSA_APITrace_hsa_amd_memory_async_copy::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_memory_async_copy::ToString()
{
    std::ostringstream ss;
    ss << "dst=" << StringUtils::ToHexString(m_dst) << s_strParamSeparator;
    ss << "dst_agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_dst_agent) << s_strParamSeparator;
    ss << "src=" << StringUtils::ToHexString(m_src) << s_strParamSeparator;
    ss << "src_agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_src_agent) << s_strParamSeparator;
    ss << "size=" << StringUtils::ToString(m_size) << s_strParamSeparator;
    ss << "num_dep_signals=" << StringUtils::ToString(m_num_dep_signals) << s_strParamSeparator;
    ss << "dep_signals=" << HSATraceStringUtils::Get_hsa_signal_t_Ptr_String(m_dep_signals, m_dep_signalsVal) << s_strParamSeparator;
    ss << "completion_signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_completion_signal);
    return ss.str();
}

void HSA_APITrace_hsa_amd_memory_async_copy::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    void* dst,
    hsa_agent_t dst_agent,
    const void* src,
    hsa_agent_t src_agent,
    size_t size,
    uint32_t num_dep_signals,
    const hsa_signal_t* dep_signals,
    hsa_signal_t completion_signal,
    ULONGLONG asyncCopyIdentifier,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_memory_async_copy;
    m_dst = dst;
    m_dst_agent = dst_agent;
    m_src = src;
    m_src_agent = src_agent;
    m_size = size;
    m_num_dep_signals = num_dep_signals;
    m_dep_signals = dep_signals;

    if (nullptr != m_dep_signals)
    {
        m_dep_signalsVal = *m_dep_signals;
    }

    m_completion_signal = completion_signal;
    m_asyncCopyIdentifier = asyncCopyIdentifier;
    m_retVal = retVal;
}

bool HSA_APITrace_hsa_amd_memory_async_copy::WriteTimestampEntry(std::ostream& sout, bool bTimeout)
{
    if (HSAAPIBase::WriteTimestampEntry(sout, bTimeout))
    {
        // async copy identifier
        sout << std::left << std::setw(21) << m_asyncCopyIdentifier;
    }

    return true;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_memory_async_copy_rect
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_memory_async_copy_rect::HSA_APITrace_hsa_amd_memory_async_copy_rect()
{
}

HSA_APITrace_hsa_amd_memory_async_copy_rect::~HSA_APITrace_hsa_amd_memory_async_copy_rect()
{
}

std::string HSA_APITrace_hsa_amd_memory_async_copy_rect::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_memory_async_copy_rect::ToString()
{
    std::ostringstream ss;
    ss << "dst=" << HSATraceStringUtils::Get_hsa_pitched_ptr_t_Ptr_String(m_dst, m_dstVal) << s_strParamSeparator;
    ss << "dst_offset=" << HSATraceStringUtils::Get_hsa_dim3_t_Ptr_String(m_dst_offset, m_dst_offsetVal) << s_strParamSeparator;
    ss << "src=" << HSATraceStringUtils::Get_hsa_pitched_ptr_t_Ptr_String(m_src, m_srcVal) << s_strParamSeparator;
    ss << "src_offset=" << HSATraceStringUtils::Get_hsa_dim3_t_Ptr_String(m_src_offset, m_src_offsetVal) << s_strParamSeparator;
    ss << "range=" << HSATraceStringUtils::Get_hsa_dim3_t_Ptr_String(m_range, m_rangeVal) << s_strParamSeparator;
    ss << "copy_agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_copy_agent) << s_strParamSeparator;
    ss << "dir=" << HSATraceStringUtils::Get_hsa_amd_copy_direction_t_String(m_dir) << s_strParamSeparator;
    ss << "num_dep_signals=" << StringUtils::ToString(m_num_dep_signals) << s_strParamSeparator;
    ss << "dep_signals=" << HSATraceStringUtils::Get_hsa_signal_t_Ptr_String(m_dep_signals, m_dep_signalsVal) << s_strParamSeparator;
    ss << "completion_signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_completion_signal);
    return ss.str();
}

void HSA_APITrace_hsa_amd_memory_async_copy_rect::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    const hsa_pitched_ptr_t* dst,
    const hsa_dim3_t* dst_offset,
    const hsa_pitched_ptr_t* src,
    const hsa_dim3_t* src_offset,
    const hsa_dim3_t* range,
    hsa_agent_t copy_agent,
    hsa_amd_copy_direction_t dir,
    uint32_t num_dep_signals,
    const hsa_signal_t* dep_signals,
    hsa_signal_t completion_signal,
    ULONGLONG asyncCopyIdentifier,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_memory_async_copy_rect;
    m_dst = dst;

    if (nullptr != m_dst)
    {
        m_dstVal = *m_dst;
    }

    m_dst_offset = dst_offset;

    if (nullptr != m_dst_offset)
    {
        m_dst_offsetVal = *m_dst_offset;
    }

    m_src = src;

    if (nullptr != m_src)
    {
        m_srcVal = *m_src;
    }

    m_src_offset = src_offset;

    if (nullptr != m_src_offset)
    {
        m_src_offsetVal = *m_src_offset;
    }

    m_range = range;

    if (nullptr != m_range)
    {
        m_rangeVal = *m_range;
    }

    m_copy_agent = copy_agent;
    m_dir = dir;
    m_num_dep_signals = num_dep_signals;
    m_dep_signals = dep_signals;

    if (nullptr != m_dep_signals)
    {
        m_dep_signalsVal = *m_dep_signals;
    }

    m_completion_signal = completion_signal;
    m_asyncCopyIdentifier = asyncCopyIdentifier;
    m_retVal = retVal;
}

bool HSA_APITrace_hsa_amd_memory_async_copy_rect::WriteTimestampEntry(std::ostream& sout, bool bTimeout)
{
    if (HSAAPIBase::WriteTimestampEntry(sout, bTimeout))
    {
        // async copy identifier
        sout << std::left << std::setw(21) << m_asyncCopyIdentifier;
    }

    return true;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_agent_memory_pool_get_info
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_agent_memory_pool_get_info::HSA_APITrace_hsa_amd_agent_memory_pool_get_info() : m_value(nullptr)
{
}

HSA_APITrace_hsa_amd_agent_memory_pool_get_info::~HSA_APITrace_hsa_amd_agent_memory_pool_get_info()
{
    if (nullptr != m_value)
    {
        FreeBuffer(m_value);
    }
}

std::string HSA_APITrace_hsa_amd_agent_memory_pool_get_info::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_agent_memory_pool_get_info::ToString()
{
    std::ostringstream ss;
    ss << "agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_agent) << s_strParamSeparator;
    ss << "memory_pool=" << HSATraceStringUtils::Get_hsa_amd_memory_pool_t_String(m_memory_pool) << s_strParamSeparator;
    ss << "attribute=" << HSATraceStringUtils::Get_hsa_amd_agent_memory_pool_info_t_String(m_attribute) << s_strParamSeparator;
    ss << "value=" << HSATraceStringUtils::Get_hsa_amd_agent_memory_pool_get_info_AttributeString(m_value, m_attribute, m_retVal);
    return ss.str();
}

void HSA_APITrace_hsa_amd_agent_memory_pool_get_info::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_agent_t agent,
    hsa_amd_memory_pool_t memory_pool,
    hsa_amd_agent_memory_pool_info_t attribute,
    void* value,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_agent_memory_pool_get_info;
    m_agent = agent;
    m_memory_pool = memory_pool;
    m_attribute = attribute;

    if (nullptr != value)
    {
        DeepCopyBuffer(&m_value, value, HSATraceStringUtils::Get_hsa_amd_agent_memory_pool_get_info_AttributeSize(m_attribute));
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_agents_allow_access
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_agents_allow_access::HSA_APITrace_hsa_amd_agents_allow_access()
{
}

HSA_APITrace_hsa_amd_agents_allow_access::~HSA_APITrace_hsa_amd_agents_allow_access()
{
}

std::string HSA_APITrace_hsa_amd_agents_allow_access::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_agents_allow_access::ToString()
{
    std::ostringstream ss;
    ss << "num_agents=" << StringUtils::ToString(m_num_agents) << s_strParamSeparator;
    ss << "agents=" << HSATraceStringUtils::Get_hsa_agent_t_Ptr_String(m_agents, m_agentsVal) << s_strParamSeparator;
    ss << "flags=" << StringUtils::ToStringPtr(m_flags, m_flagsVal) << s_strParamSeparator;
    ss << "ptr=" << StringUtils::ToHexString(m_ptr);
    return ss.str();
}

void HSA_APITrace_hsa_amd_agents_allow_access::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    uint32_t num_agents,
    const hsa_agent_t* agents,
    const uint32_t* flags,
    const void* ptr,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_agents_allow_access;
    m_num_agents = num_agents;
    m_agents = agents;

    if (nullptr != m_agents)
    {
        m_agentsVal = *m_agents;
    }

    m_flags = flags;

    if (nullptr != m_flags)
    {
        m_flagsVal = *m_flags;
    }

    m_ptr = ptr;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_memory_pool_can_migrate
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_memory_pool_can_migrate::HSA_APITrace_hsa_amd_memory_pool_can_migrate()
{
}

HSA_APITrace_hsa_amd_memory_pool_can_migrate::~HSA_APITrace_hsa_amd_memory_pool_can_migrate()
{
}

std::string HSA_APITrace_hsa_amd_memory_pool_can_migrate::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_memory_pool_can_migrate::ToString()
{
    std::ostringstream ss;
    ss << "src_memory_pool=" << HSATraceStringUtils::Get_hsa_amd_memory_pool_t_String(m_src_memory_pool) << s_strParamSeparator;
    ss << "dst_memory_pool=" << HSATraceStringUtils::Get_hsa_amd_memory_pool_t_String(m_dst_memory_pool) << s_strParamSeparator;
    ss << "result=" << StringUtils::ToStringPtr(m_result, m_resultVal);
    return ss.str();
}

void HSA_APITrace_hsa_amd_memory_pool_can_migrate::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_amd_memory_pool_t src_memory_pool,
    hsa_amd_memory_pool_t dst_memory_pool,
    bool* result,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_memory_pool_can_migrate;
    m_src_memory_pool = src_memory_pool;
    m_dst_memory_pool = dst_memory_pool;
    m_result = result;

    if (nullptr != m_result)
    {
        m_resultVal = *m_result;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_memory_migrate
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_memory_migrate::HSA_APITrace_hsa_amd_memory_migrate()
{
}

HSA_APITrace_hsa_amd_memory_migrate::~HSA_APITrace_hsa_amd_memory_migrate()
{
}

std::string HSA_APITrace_hsa_amd_memory_migrate::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_memory_migrate::ToString()
{
    std::ostringstream ss;
    ss << "ptr=" << StringUtils::ToHexString(m_ptr) << s_strParamSeparator;
    ss << "memory_pool=" << HSATraceStringUtils::Get_hsa_amd_memory_pool_t_String(m_memory_pool) << s_strParamSeparator;
    ss << "flags=" << StringUtils::ToString(m_flags);
    return ss.str();
}

void HSA_APITrace_hsa_amd_memory_migrate::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    const void* ptr,
    hsa_amd_memory_pool_t memory_pool,
    uint32_t flags,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_memory_migrate;
    m_ptr = ptr;
    m_memory_pool = memory_pool;
    m_flags = flags;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_memory_lock
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_memory_lock::HSA_APITrace_hsa_amd_memory_lock()
{
}

HSA_APITrace_hsa_amd_memory_lock::~HSA_APITrace_hsa_amd_memory_lock()
{
}

std::string HSA_APITrace_hsa_amd_memory_lock::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_memory_lock::ToString()
{
    std::ostringstream ss;
    ss << "host_ptr=" << StringUtils::ToHexString(m_host_ptr) << s_strParamSeparator;
    ss << "size=" << StringUtils::ToString(m_size) << s_strParamSeparator;
    ss << "agents=" << HSATraceStringUtils::Get_hsa_agent_t_Ptr_String(m_agents, m_agentsVal) << s_strParamSeparator;
    ss << "num_agent=" << StringUtils::ToString(m_num_agent) << s_strParamSeparator;
    ss << "agent_ptr=" << HSATraceStringUtils::SurroundWithDeRef(StringUtils::ToHexString(m_agent_ptrVal));
    return ss.str();
}

void HSA_APITrace_hsa_amd_memory_lock::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    void* host_ptr,
    size_t size,
    hsa_agent_t* agents,
    int num_agent,
    void** agent_ptr,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_memory_lock;
    m_host_ptr = host_ptr;
    m_size = size;
    m_agents = agents;

    if (nullptr != m_agents)
    {
        m_agentsVal = *m_agents;
    }

    m_num_agent = num_agent;
    m_agent_ptr = agent_ptr;

    if (nullptr != m_agent_ptr)
    {
        m_agent_ptrVal = reinterpret_cast<uintptr_t>(*m_agent_ptr);
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_memory_unlock
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_memory_unlock::HSA_APITrace_hsa_amd_memory_unlock()
{
}

HSA_APITrace_hsa_amd_memory_unlock::~HSA_APITrace_hsa_amd_memory_unlock()
{
}

std::string HSA_APITrace_hsa_amd_memory_unlock::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_memory_unlock::ToString()
{
    std::ostringstream ss;
    ss << "host_ptr=" << StringUtils::ToHexString(m_host_ptr);
    return ss.str();
}

void HSA_APITrace_hsa_amd_memory_unlock::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    void* host_ptr,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_memory_unlock;
    m_host_ptr = host_ptr;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_memory_fill
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_memory_fill::HSA_APITrace_hsa_amd_memory_fill()
{
}

HSA_APITrace_hsa_amd_memory_fill::~HSA_APITrace_hsa_amd_memory_fill()
{
}

std::string HSA_APITrace_hsa_amd_memory_fill::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_memory_fill::ToString()
{
    std::ostringstream ss;
    ss << "ptr=" << StringUtils::ToHexString(m_ptr) << s_strParamSeparator;
    ss << "value=" << StringUtils::ToString(m_value) << s_strParamSeparator;
    ss << "count=" << StringUtils::ToString(m_count);
    return ss.str();
}

void HSA_APITrace_hsa_amd_memory_fill::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    void* ptr,
    uint32_t value,
    size_t count,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_memory_fill;
    m_ptr = ptr;
    m_value = value;
    m_count = count;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_interop_map_buffer
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_interop_map_buffer::HSA_APITrace_hsa_amd_interop_map_buffer()
{
}

HSA_APITrace_hsa_amd_interop_map_buffer::~HSA_APITrace_hsa_amd_interop_map_buffer()
{
}

std::string HSA_APITrace_hsa_amd_interop_map_buffer::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_interop_map_buffer::ToString()
{
    std::ostringstream ss;
    ss << "num_agents=" << StringUtils::ToString(m_num_agents) << s_strParamSeparator;
    ss << "agents=" << HSATraceStringUtils::Get_hsa_agent_t_Ptr_String(m_agents, m_agentsVal) << s_strParamSeparator;
    ss << "interop_handle=" << StringUtils::ToString(m_interop_handle) << s_strParamSeparator;
    ss << "flags=" << StringUtils::ToString(m_flags) << s_strParamSeparator;
    ss << "size=" << StringUtils::ToStringPtr(m_size, m_sizeVal) << s_strParamSeparator;
    ss << "ptr=" << HSATraceStringUtils::SurroundWithDeRef(StringUtils::ToHexString(m_ptrVal)) << s_strParamSeparator;
    ss << "metadata_size=" << StringUtils::ToStringPtr(m_metadata_size, m_metadata_sizeVal) << s_strParamSeparator;
    ss << "metadata=" << HSATraceStringUtils::SurroundWithDeRef(StringUtils::ToHexString(m_metadataVal));
    return ss.str();
}

void HSA_APITrace_hsa_amd_interop_map_buffer::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    uint32_t num_agents,
    hsa_agent_t* agents,
    int interop_handle,
    uint32_t flags,
    size_t* size,
    void** ptr,
    size_t* metadata_size,
    const void** metadata,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_interop_map_buffer;
    m_num_agents = num_agents;
    m_agents = agents;

    if (nullptr != m_agents)
    {
        m_agentsVal = *m_agents;
    }

    m_interop_handle = interop_handle;
    m_flags = flags;
    m_size = size;

    if (nullptr != m_size)
    {
        m_sizeVal = *m_size;
    }

    m_ptr = ptr;

    if (nullptr != m_ptr)
    {
        m_ptrVal = reinterpret_cast<uintptr_t>(*m_ptr);
    }

    m_metadata_size = metadata_size;

    if (nullptr != m_metadata_size)
    {
        m_metadata_sizeVal = *m_metadata_size;
    }

    m_metadata = metadata;

    if (nullptr != m_metadata)
    {
        m_metadataVal = reinterpret_cast<uintptr_t>(*m_metadata);
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_interop_unmap_buffer
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_interop_unmap_buffer::HSA_APITrace_hsa_amd_interop_unmap_buffer()
{
}

HSA_APITrace_hsa_amd_interop_unmap_buffer::~HSA_APITrace_hsa_amd_interop_unmap_buffer()
{
}

std::string HSA_APITrace_hsa_amd_interop_unmap_buffer::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_interop_unmap_buffer::ToString()
{
    std::ostringstream ss;
    ss << "ptr=" << StringUtils::ToHexString(m_ptr);
    return ss.str();
}

void HSA_APITrace_hsa_amd_interop_unmap_buffer::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    void* ptr,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_interop_unmap_buffer;
    m_ptr = ptr;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_image_create
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_image_create::HSA_APITrace_hsa_amd_image_create()
{
}

HSA_APITrace_hsa_amd_image_create::~HSA_APITrace_hsa_amd_image_create()
{
}

std::string HSA_APITrace_hsa_amd_image_create::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_image_create::ToString()
{
    std::ostringstream ss;
    ss << "agent=" << HSATraceStringUtils::Get_hsa_agent_t_String(m_agent) << s_strParamSeparator;
    ss << "image_descriptor=" << HSATraceStringUtils::Get_hsa_ext_image_descriptor_t_Ptr_String(m_image_descriptor, m_image_descriptorVal) << s_strParamSeparator;
    ss << "image_layout=" << HSATraceStringUtils::Get_hsa_amd_image_descriptor_t_Ptr_String(m_image_layout, m_image_layoutVal) << s_strParamSeparator;
    ss << "image_data=" << StringUtils::ToHexString(m_image_data) << s_strParamSeparator;
    ss << "access_permission=" << HSATraceStringUtils::Get_hsa_access_permission_t_String(m_access_permission) << s_strParamSeparator;
    ss << "image=" << HSATraceStringUtils::Get_hsa_ext_image_t_Ptr_String(m_image, m_imageVal);
    return ss.str();
}

void HSA_APITrace_hsa_amd_image_create::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_agent_t agent,
    const hsa_ext_image_descriptor_t* image_descriptor,
    const hsa_amd_image_descriptor_t* image_layout,
    const void* image_data,
    hsa_access_permission_t access_permission,
    hsa_ext_image_t* image,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_image_create;
    m_agent = agent;
    m_image_descriptor = image_descriptor;

    if (nullptr != m_image_descriptor)
    {
        m_image_descriptorVal = *m_image_descriptor;
    }

    m_image_layout = image_layout;

    if (nullptr != m_image_layout)
    {
        m_image_layoutVal = *m_image_layout;
    }

    m_image_data = image_data;
    m_access_permission = access_permission;
    m_image = image;

    if (nullptr != m_image)
    {
        m_imageVal = *m_image;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_pointer_info
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_pointer_info::HSA_APITrace_hsa_amd_pointer_info()
{
}

HSA_APITrace_hsa_amd_pointer_info::~HSA_APITrace_hsa_amd_pointer_info()
{
}

std::string HSA_APITrace_hsa_amd_pointer_info::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_pointer_info::ToString()
{
    std::ostringstream ss;
    ss << "ptr=" << StringUtils::ToHexString(m_ptr) << s_strParamSeparator;
    ss << "info=" << HSATraceStringUtils::Get_hsa_amd_pointer_info_t_Ptr_String(m_info, m_infoVal) << s_strParamSeparator;
    ss << "alloc=" << StringUtils::ToString(m_alloc) << s_strParamSeparator;
    ss << "num_agents_accessible=" << StringUtils::ToStringPtr(m_num_agents_accessible, m_num_agents_accessibleVal) << s_strParamSeparator;

    const hsa_agent_t* multiple_indirection_accessible_helper = nullptr;

    if (nullptr != m_accessible)
    {
        multiple_indirection_accessible_helper = &m_accessibleVal;
    }
    ss << "accessible=" << HSATraceStringUtils::SurroundWithDeRef(HSATraceStringUtils::Get_hsa_agent_t_Ptr_String(multiple_indirection_accessible_helper, m_accessibleVal));
    return ss.str();
}

void HSA_APITrace_hsa_amd_pointer_info::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    void* ptr,
    hsa_amd_pointer_info_t* info,
    void* (*alloc)(size_t),
    uint32_t* num_agents_accessible,
    hsa_agent_t** accessible,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_pointer_info;
    m_ptr = ptr;
    m_info = info;

    if (nullptr != m_info)
    {
        m_infoVal = *m_info;
    }

    m_alloc = alloc;
    m_num_agents_accessible = num_agents_accessible;

    if (nullptr != m_num_agents_accessible)
    {
        m_num_agents_accessibleVal = *m_num_agents_accessible;
    }

    m_accessible = accessible;

    if (nullptr != m_accessible && nullptr != *m_accessible)
    {
        m_accessibleVal = **m_accessible;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_pointer_info_set_userdata
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_pointer_info_set_userdata::HSA_APITrace_hsa_amd_pointer_info_set_userdata()
{
}

HSA_APITrace_hsa_amd_pointer_info_set_userdata::~HSA_APITrace_hsa_amd_pointer_info_set_userdata()
{
}

std::string HSA_APITrace_hsa_amd_pointer_info_set_userdata::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_pointer_info_set_userdata::ToString()
{
    std::ostringstream ss;
    ss << "ptr=" << StringUtils::ToHexString(m_ptr) << s_strParamSeparator;
    ss << "userdata=" << StringUtils::ToHexString(m_userdata);
    return ss.str();
}

void HSA_APITrace_hsa_amd_pointer_info_set_userdata::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    void* ptr,
    void* userdata,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_pointer_info_set_userdata;
    m_ptr = ptr;
    m_userdata = userdata;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_ipc_memory_create
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_ipc_memory_create::HSA_APITrace_hsa_amd_ipc_memory_create()
{
}

HSA_APITrace_hsa_amd_ipc_memory_create::~HSA_APITrace_hsa_amd_ipc_memory_create()
{
}

std::string HSA_APITrace_hsa_amd_ipc_memory_create::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_ipc_memory_create::ToString()
{
    std::ostringstream ss;
    ss << "ptr=" << StringUtils::ToHexString(m_ptr) << s_strParamSeparator;
    ss << "len=" << StringUtils::ToString(m_len) << s_strParamSeparator;
    ss << "handle=" << HSATraceStringUtils::Get_hsa_amd_ipc_memory_t_Ptr_String(m_handle, m_handleVal);
    return ss.str();
}

void HSA_APITrace_hsa_amd_ipc_memory_create::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    void* ptr,
    size_t len,
    hsa_amd_ipc_memory_t* handle,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_ipc_memory_create;
    m_ptr = ptr;
    m_len = len;
    m_handle = handle;

    if (nullptr != m_handle)
    {
        m_handleVal = *m_handle;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_ipc_memory_attach
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_ipc_memory_attach::HSA_APITrace_hsa_amd_ipc_memory_attach()
{
}

HSA_APITrace_hsa_amd_ipc_memory_attach::~HSA_APITrace_hsa_amd_ipc_memory_attach()
{
}

std::string HSA_APITrace_hsa_amd_ipc_memory_attach::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_ipc_memory_attach::ToString()
{
    std::ostringstream ss;
    ss << "handle=" << HSATraceStringUtils::Get_hsa_amd_ipc_memory_t_Ptr_String(m_handle, m_handleVal) << s_strParamSeparator;
    ss << "len=" << StringUtils::ToString(m_len) << s_strParamSeparator;
    ss << "num_agents=" << StringUtils::ToString(m_num_agents) << s_strParamSeparator;
    ss << "mapping_agents=" << HSATraceStringUtils::Get_hsa_agent_t_Ptr_String(m_mapping_agents, m_mapping_agentsVal) << s_strParamSeparator;
    ss << "mapped_ptr=" << HSATraceStringUtils::SurroundWithDeRef(StringUtils::ToHexString(m_mapped_ptrVal));
    return ss.str();
}

void HSA_APITrace_hsa_amd_ipc_memory_attach::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    const hsa_amd_ipc_memory_t* handle,
    size_t len,
    uint32_t num_agents,
    const hsa_agent_t* mapping_agents,
    void** mapped_ptr,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_ipc_memory_attach;
    m_handle = handle;

    if (nullptr != m_handle)
    {
        m_handleVal = *m_handle;
    }

    m_len = len;
    m_num_agents = num_agents;
    m_mapping_agents = mapping_agents;

    if (nullptr != m_mapping_agents)
    {
        m_mapping_agentsVal = *m_mapping_agents;
    }

    m_mapped_ptr = mapped_ptr;

    if (nullptr != m_mapped_ptr)
    {
        m_mapped_ptrVal = reinterpret_cast<uintptr_t>(*m_mapped_ptr);
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_ipc_memory_detach
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_ipc_memory_detach::HSA_APITrace_hsa_amd_ipc_memory_detach()
{
}

HSA_APITrace_hsa_amd_ipc_memory_detach::~HSA_APITrace_hsa_amd_ipc_memory_detach()
{
}

std::string HSA_APITrace_hsa_amd_ipc_memory_detach::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_ipc_memory_detach::ToString()
{
    std::ostringstream ss;
    ss << "mapped_ptr=" << StringUtils::ToHexString(m_mapped_ptr);
    return ss.str();
}

void HSA_APITrace_hsa_amd_ipc_memory_detach::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    void* mapped_ptr,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_ipc_memory_detach;
    m_mapped_ptr = mapped_ptr;
    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_ipc_signal_create
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_ipc_signal_create::HSA_APITrace_hsa_amd_ipc_signal_create()
{
}

HSA_APITrace_hsa_amd_ipc_signal_create::~HSA_APITrace_hsa_amd_ipc_signal_create()
{
}

std::string HSA_APITrace_hsa_amd_ipc_signal_create::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_ipc_signal_create::ToString()
{
    std::ostringstream ss;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_String(m_signal) << s_strParamSeparator;
    ss << "handle=" << HSATraceStringUtils::Get_hsa_amd_ipc_memory_t_Ptr_String(m_handle, m_handleVal);
    return ss.str();
}

void HSA_APITrace_hsa_amd_ipc_signal_create::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_signal_t signal,
    hsa_amd_ipc_signal_t* handle,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_ipc_signal_create;
    m_signal = signal;
    m_handle = handle;

    if (nullptr != m_handle)
    {
        m_handleVal = *m_handle;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_ipc_signal_attach
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_ipc_signal_attach::HSA_APITrace_hsa_amd_ipc_signal_attach()
{
}

HSA_APITrace_hsa_amd_ipc_signal_attach::~HSA_APITrace_hsa_amd_ipc_signal_attach()
{
}

std::string HSA_APITrace_hsa_amd_ipc_signal_attach::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_ipc_signal_attach::ToString()
{
    std::ostringstream ss;
    ss << "handle=" << HSATraceStringUtils::Get_hsa_amd_ipc_memory_t_Ptr_String(m_handle, m_handleVal) << s_strParamSeparator;
    ss << "signal=" << HSATraceStringUtils::Get_hsa_signal_t_Ptr_String(m_signal, m_signalVal);
    return ss.str();
}

void HSA_APITrace_hsa_amd_ipc_signal_attach::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    const hsa_amd_ipc_signal_t* handle,
    hsa_signal_t* signal,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_ipc_signal_attach;
    m_handle = handle;

    if (nullptr != m_handle)
    {
        m_handleVal = *m_handle;
    }

    m_signal = signal;

    if (nullptr != m_signal)
    {
        m_signalVal = *m_signal;
    }

    m_retVal = retVal;
}

///////////////////////////////////////////////////
/// Class HSA_APITrace_hsa_amd_queue_set_priority
///////////////////////////////////////////////////

HSA_APITrace_hsa_amd_queue_set_priority::HSA_APITrace_hsa_amd_queue_set_priority()
{
}

HSA_APITrace_hsa_amd_queue_set_priority::~HSA_APITrace_hsa_amd_queue_set_priority()
{
}

std::string HSA_APITrace_hsa_amd_queue_set_priority::GetRetString()
{
    return HSATraceStringUtils::Get_hsa_status_t_String(m_retVal);
}

std::string HSA_APITrace_hsa_amd_queue_set_priority::ToString()
{
    std::ostringstream ss;
    ss << "queue=" << HSATraceStringUtils::Get_hsa_queue_t_Ptr_String(m_queue, m_queueVal) << s_strParamSeparator;
    ss << "priority=" << HSATraceStringUtils::Get_hsa_amd_queue_priority_t_String(m_priority);
    return ss.str();
}

void HSA_APITrace_hsa_amd_queue_set_priority::Create(
    ULONGLONG ullStartTime,
    ULONGLONG ullEndTime,
    hsa_queue_t* queue,
    hsa_amd_queue_priority_t priority,
    hsa_status_t retVal)
{
    m_ullStart = ullStartTime;
    m_ullEnd = ullEndTime;
    m_type = HSA_API_Type_hsa_amd_queue_set_priority;
    m_queue = queue;

    if (nullptr != m_queue)
    {
        m_queueVal = *m_queue;
    }

    m_priority = priority;
    m_retVal = retVal;
}


