default: $(TARGET) $(TARGETSO) $(TARGETLIB)

# build targets
$(TARGET) : makedir $(OBJS)
	$(PRE_BUILD_ACTION)
	$(CC) $(LINKFLAGS_EXE) $(PLATFORM_LFLAG) $(OBJS) $(LIBPATH) $(LIBS) -o $(TARGET) $(STATIC_LIBS)
	$(POST_BUILD_ACTION)

$(TARGETLIB) : makedir $(LIB_OBJS)
	$(PRE_BUILD_ACTION)
	ar rcs $(TARGETLIB) $(LIB_OBJS)
	$(POST_BUILD_ACTION)

$(TARGETSO) : makedir $(SO_OBJS)
	$(PRE_BUILD_ACTION)
	$(CC) $(LINKFLAGS_SO) $(PLATFORM_LFLAG) $(SO_OBJS) $(LIBPATH) $(LIBS) -o $(TARGETSO) $(STATIC_LIBS)
	$(POST_BUILD_ACTION)

Internal:
	$(MAKE) -f $(MAKEFILENAME) $(BUILD_INTERNAL_OVERRIDES)

Dbg:
	$(MAKE) -f $(MAKEFILENAME) $(BUILD_DEBUG_OVERRIDES)

DbgInternal:
	$(MAKE) -f $(MAKEFILENAME) $(BUILD_DEBUG_INTERNAL_OVERRIDES)

makedir:
	mkdir -p $(OUTPUT_DIRS_TO_CREATE)

all: default Internal Dbg DbgInternal

# source file targets

BUILD_SRC=$(CC) $(CFLAGS) $(INCLUDES) $(DEFINES) -c $< -o $@

$(OBJ_DIR)/%.o: %.cpp
	$(BUILD_SRC)

$(OBJ_DIR)/%.o: $(SRC_COMMON_DIR)/%.cpp
	$(BUILD_SRC)

$(OBJ_DIR)/%.o: $(SRC_CLTRACEAGENT_DIR)/%.cpp
	$(BUILD_SRC)

$(OBJ_DIR)/%.o: $(SRC_CLTHREADTRACEAGENT_DIR)/%.cpp
	$(BUILD_SRC)

$(OBJ_DIR)/%.o: $(SRC_CLPROFILEAGENT_DIR)/%.cpp
	$(BUILD_SRC)

$(OBJ_DIR)/%.o: $(SRC_CLOCCUPANCYAGENT_DIR)/%.cpp
	$(BUILD_SRC)

$(OBJ_DIR)/%.o: $(SRC_HSAFDNCOMMON_DIR)/%.cpp
	$(BUILD_SRC)

$(OBJ_DIR)/%.o: $(SRC_HSAFDNTRACE_DIR)/%.cpp
	$(BUILD_SRC)

$(OBJ_DIR)/%.o: $(DYNAMICLIBRARYMODULE_DIR)/%.cpp
	$(BUILD_SRC)

$(OBJ_DIR)/%.o: $(DEVICEINFO_DIR)/%.cpp
	$(BUILD_SRC)

$(OBJ_DIR)/%.o: $(DEVICEINFO_INTERNAL_DIR)/%.cpp
	$(BUILD_SRC)

$(OBJ_DIR)/%.o: $(ACLMODULEMANAGER_DIR)/%.cpp
	$(BUILD_SRC)

$(OBJ_DIR)/%.o: $(GPUTHREADTRACEUTILS_DIR)/%.cpp
	$(BUILD_SRC)

$(OBJ_DIR)/%.o: $(ADLUTIL_DIR)/%.cpp
	$(BUILD_SRC)

$(OBJ_DIR)/%.o: $(SRC_SPROFILE_DIR)/%.cpp
	$(BUILD_SRC)

$(OBJ_DIR)/%.o: $(SRC_SANALYZE_DIR)/%.cpp
	$(BUILD_SRC)

$(OBJ_DIR)/%.o: $(HSATESTCOMMON_DIR)/%.cpp
	$(BUILD_SRC)

$(OBJ_DIR)/%.o: $(HSARESOURCEMANAGER_DIR)/%.cpp
	$(BUILD_SRC)

$(OBJ_DIR)/%.o: $(HSAUTILS_DIR)/%.cpp
	$(BUILD_SRC)

$(OBJ_DIR)/%.o: $(SRC_PROFILEDATAPARSER_DIR)/%.cpp
	$(BUILD_SRC)

$(OBJ_DIR)/%.o: $(COMGRUTILS_DIR)/%.cpp
	$(BUILD_SRC)

# clean targets
clean:
	rm -f $(OBJS) $(LIB_OBJS) $(SO_OBJS) $(TARGET) $(TARGETLIB) $(TARGETSO)

cleanInternal:
	$(MAKE) -f $(MAKEFILENAME) clean $(BUILD_INTERNAL_OVERRIDES)

cleanDbg:
	$(MAKE) -f $(MAKEFILENAME) clean $(BUILD_DEBUG_OVERRIDES)

cleanDbgInternal:
	$(MAKE) -f $(MAKEFILENAME) clean $(BUILD_DEBUG_INTERNAL_OVERRIDES)

spotless: clean cleanInternal cleanDbg cleanDbgInternal
	rm -rf $(BASE_OBJDIR)

