// AMDGenlockRestore.cpp : Defines the entry point for the console application.
//

#if defined (WIN32)
#include <Windows.h>

#endif

#include <iostream>
#include <string>

#include "AMDGenlockConfigManager.h"

using namespace std;

int main(int argc, char **argv)
{
    if (argc < 3)
    {
        cerr<<"\nUsage: "<<endl;
        cerr<<"   AMDGenlockRestore -s <config file name> to store a configuration"<<endl;
        cerr<<"   AMDGenlockRestore -r <config file name> to restore a configuration"<<endl<<endl;

        return 0;
    }
    else
    {
        string                  strCmdLine(argv[1]);
        string                  strCfgFile(argv[2]);
        AMDGenlockConfigManager GenlockManager;

        if (!GenlockManager.init(false))
        {
           cerr<<"\nError: Could not init Gnelock Configuration manager!"<<endl;

           return 0;
        }

        if (GenlockManager.enumDisplays() == 0)
        {
           cerr<<"\nError: No displays detected"<<endl;

           return 0;
        }

        size_t uiPos = strCmdLine.find("-s");

        if (uiPos != strCmdLine.npos)
        {
            if (GenlockManager.hasTimingServer() || GenlockManager.getNumTimingClients() > 0)
            {
                if (GenlockManager.saveConfiguration(strCfgFile.c_str()))
                {
                    cerr<<"\nConfiguration saved to "<<strCfgFile;
                    cerr<<endl;
                }
                else
                {
                    cerr<<"\nError: Saving configuration to "<<strCfgFile;
                    cerr<<endl;
                }
            }
            else
            {
                cerr<<"\nError: No Genlock configuration to be saved."<<endl;
            }
        }
        else
        {
            uiPos = strCmdLine.find("-r");

            if (uiPos != strCmdLine.npos)
            {
                if (!GenlockManager.loadConfiguration(strCfgFile.c_str()))
                {
                    cerr<<"\nError: Could not load configuration "<<strCfgFile;
                    cerr<<endl;
                }
                else
                {
                    if (!GenlockManager.restoreConfiguration())
                    {
                         cerr<<"\nError: Could not apply configuration "<<strCfgFile;
                        cerr<<endl;
                    }
                }
            }
            else
            {
                cerr<<"\nUsage: "<<endl;
                cerr<<"   AMDGenlockRestore -s <config file name> to store a configuration"<<endl;
                cerr<<"   AMDGenlockRestore -r <config file name> to restore a configuration"<<endl<<endl;
            }
        }
    }

    return 0;
}
