#pragma once

#include "adl_sdk.h"


#define  ADL_GLSYNC_CONFIGMASK_ALL (ADL_GLSYNC_CONFIGMASK_SIGNALSOURCE | ADL_GLSYNC_CONFIGMASK_SYNCFIELD | ADL_GLSYNC_CONFIGMASK_SAMPLERATE | ADL_GLSYNC_CONFIGMASK_SYNCDELAY | ADL_GLSYNC_CONFIGMASK_TRIGGEREDGE | ADL_GLSYNC_CONFIGMASK_SCANRATECOEFF | ADL_GLSYNC_CONFIGMASK_FRAMELOCKCNTL)

typedef int ( *ADL_MAIN_CONTROL_CREATE )                        (ADL_MAIN_MALLOC_CALLBACK, int );
typedef int ( *ADL_MAIN_CONTROL_DESTROY )                       ();
typedef int ( *ADL_ADAPTER_NUMBEROFADAPTERS_GET )               ( int* );
typedef int ( *ADL_ADAPTER_ACTIVE_GET )                         ( int, int* );
typedef int ( *ADL_ADAPTER_ADAPTERINFO_GET )                    ( LPAdapterInfo, int );
typedef int ( *ADL_ADAPTER_ACTIVE_GET )                         ( int, int* );
typedef int ( *ADL_DISPLAY_DISPLAYINFO_GET )                    ( int, int *, ADLDisplayInfo **, int );
typedef int ( *ADL_DISPLAY_POSITION_GET )                       ( int, int, int*, int*, int*,int*, int*, int*,int*, int*, int*,int*);
typedef int ( *ADL_DISPLAY_EDIDDATA_GET )                       ( int, int, ADLDisplayEDIDData* );
typedef int ( *ADL_WORKSTATION_DISPLAYGENLOCKCAPABLE_GET)       ( int, int, int* );
typedef int ( *ADL_WORKSTATION_DISPLAYGENLOCKCAPABLE_GET)       ( int, int, int* );
typedef int ( *ADL_WORKSTATION_GLSYNCMODULEDETECT_GET)          ( int, int, ADLGLSyncModuleID* );
typedef int ( *ADL_WORKSTATION_GLSYNCMODULEINFO_GET)            ( int, int, int*, int*, int*, int*, ADLGLSyncPortCaps**);
typedef int ( *ADL_WORKSTATION_GLSYNCGENLOCKCONFIGURATION_GET)  ( int, int, int, ADLGLSyncGenlockConfig*);
typedef int (* ADL_WORKSTATION_GLSYNCGENLOCKCONFIGURATION_SET)  ( int, int, ADLGLSyncGenlockConfig);
typedef int (* ADL_WORKSTATION_GLSYNCPORTSTATE_GET)             ( int, int, int,int, ADLGlSyncPortInfo*, int**);
typedef int (* ADL_WORKSTATION_GLSYNCPORTSTATE_SET)             ( int ,int, ADLGlSyncPortControl);
typedef int (* ADL_WORKSTATION_DISPLAYGLSYNCMODE_GET)           ( int, int, ADLGlSyncMode*);
typedef int (* ADL_WORKSTATION_DISPLAYGLSYNCMODE_SET)           ( int, int, ADLGlSyncMode);


typedef struct
{
    void*                                           hModule;
    ADL_MAIN_CONTROL_CREATE						    ADL_Main_Control_Create;
    ADL_MAIN_CONTROL_DESTROY						ADL_Main_Control_Destroy;
    ADL_ADAPTER_NUMBEROFADAPTERS_GET				ADL_Adapter_NumberOfAdapters_Get;
    ADL_ADAPTER_ACTIVE_GET							ADL_Adapter_Active_Get;
    ADL_ADAPTER_ADAPTERINFO_GET						ADL_Adapter_AdapterInfo_Get;
    ADL_DISPLAY_DISPLAYINFO_GET						ADL_Display_DisplayInfo_Get;
    ADL_DISPLAY_POSITION_GET						ADL_Display_Position_Get;
    ADL_DISPLAY_EDIDDATA_GET                        ADL_Display_EdidData_Get;
    ADL_WORKSTATION_DISPLAYGENLOCKCAPABLE_GET       ADL_Workstation_DisplayGenlockCapable_Get;
    ADL_WORKSTATION_GLSYNCMODULEDETECT_GET          ADL_Workstation_GLSyncModuleDetect_Get;
    ADL_WORKSTATION_GLSYNCMODULEINFO_GET            ADL_Workstation_GLSyncModuleInfo_Get;
    ADL_WORKSTATION_GLSYNCGENLOCKCONFIGURATION_GET  ADL_Workstation_GLSyncGenlockConfiguration_Get;
    ADL_WORKSTATION_GLSYNCGENLOCKCONFIGURATION_SET  ADL_Workstation_GLSyncGenlockConfiguration_Set;
    ADL_WORKSTATION_GLSYNCPORTSTATE_GET             ADL_Workstation_GLSyncPortState_Get;
    ADL_WORKSTATION_GLSYNCPORTSTATE_SET             ADL_Workstation_GLSyncPortState_Set;
    ADL_WORKSTATION_DISPLAYGLSYNCMODE_GET           ADL_Workstation_DisplayGLSyncMode_Get;
    ADL_WORKSTATION_DISPLAYGLSYNCMODE_SET           ADL_Workstation_DisplayGLSyncMode_Set;
} ADL_PROCS;
