
#if defined (WIN32)
#include <Windows.h>
#include <io.h>
#include <fcntl.h>

#elif defined (LINUX)

#include <time.h>
#include <sys/time.h>
#include <string.h>

#endif

#include <iostream>
#include <stdio.h>


#include "LogOutput.h"


using namespace std;


LogOutput::LogOutput(void)
{
}


LogOutput::~LogOutput(void)
{
}


void LogOutput::openLogFile(const char* pFileName)
{
    m_LogFile.open(pFileName, fstream::out);

    if (m_LogFile.is_open())
    {
        m_LogFile<<"\n/----------------------------------------------------------------------------------------------------------------------/"<<endl;
    }


#if defined (WIN32)
#ifdef _DEBUG

    AllocConsole();

    HANDLE handle_out = GetStdHandle(STD_OUTPUT_HANDLE);
    int hCrt = _open_osfhandle((long) handle_out, _O_TEXT);
    FILE* hf_out = _fdopen(hCrt, "w");
    setvbuf(hf_out, NULL, _IONBF, 1);
    *stdout = *hf_out;

    HANDLE handle_in = GetStdHandle(STD_INPUT_HANDLE);
    hCrt = _open_osfhandle((long) handle_in, _O_TEXT);
    FILE* hf_in = _fdopen(hCrt, "r");
    setvbuf(hf_in, NULL, _IONBF, 128);
    *stdin = *hf_in;

#endif
#endif
}


void LogOutput::closeLogFile()
{
    if (m_LogFile.is_open())
    {
        m_LogFile.close();
    }

#ifdef USE_CONSOLE

    FreeConsole();
#endif
}


#if defined (WIN32)

void LogOutput::print(MessageType mt, const char* pMessage)
{
    string      strMessage;
    SYSTEMTIME  sysTime;

    GetLocalTime(&sysTime);

    switch (mt)
    {
        case MSG_INFO:
            strMessage += "INFO: ";
            break;

        case MSG_WARNING:
            strMessage += "WARNING: ";
            break;

        case MSG_ERROR:
            strMessage += "ERROR: ";
            break;
    }

    strMessage += pMessage;

    if (m_LogFile.is_open())
    {
        m_LogFile<<sysTime.wYear<<" "<<sysTime.wMonth<<" "<<sysTime.wDay<<" "<<sysTime.wHour<<":"<<sysTime.wMinute<<":"<<sysTime.wSecond<<" "<<strMessage.c_str()<<endl;
    }

#ifdef _DEBUG
    cout<<sysTime.wYear<<" "<<sysTime.wMonth<<" "<<sysTime.wDay<<" "<<sysTime.wHour<<":"<<sysTime.wMinute<<":"<<sysTime.wSecond<<" "<<strMessage.c_str()<<endl;
#endif
}

#elif defined (LINUX)

void LogOutput::print(MessageType mt, const char* pMessage)
{
    string      	 strMessage;
    struct timeval   timeofday;
    struct tm*       pSysTime = NULL;

    memset(&timeofday, 0, sizeof(struct tm));

    if (gettimeofday(&timeofday, NULL) == 0)
    {
    	pSysTime = localtime(&timeofday.tv_sec);
    }

    switch (mt)
    {
        case MSG_INFO:
            strMessage += "INFO: ";
            break;

        case MSG_WARNING:
            strMessage += "WARNING: ";
            break;

        case MSG_ERROR:
            strMessage += "ERROR: ";
            break;
    }

    strMessage += pMessage;

    if (m_LogFile.is_open())
    {
        ;//m_LogFile<<sysTime.wYear<<" "<<sysTime.wMonth<<" "<<sysTime.wDay<<" "<<sysTime.wHour<<":"<<sysTime.wMinute<<":"<<sysTime.wSecond<<" "<<strMessage.c_str()<<endl;
    }

#ifdef _DEBUG
    cout<<sysTime.wYear<<" "<<sysTime.wMonth<<" "<<sysTime.wDay<<" "<<sysTime.wHour<<":"<<sysTime.wMinute<<":"<<sysTime.wSecond<<" "<<strMessage.c_str()<<endl;
#endif
}

#endif

