//--------------------------------------------------------------------------------------
// 
// Copyright 2014 ADVANCED MICRO DEVICES, INC.  All Rights Reserved.
//
// AMD is granting you permission to use this software and documentation (if
// any) (collectively, the "Materials") pursuant to the terms and conditions
// of the Software License Agreement included with the Materials.  If you do
// not have a copy of the Software License Agreement, contact your AMD
// representative for a copy.
// You agree that you will not reverse engineer or decompile the Materials,
// in whole or in part, except as allowed by applicable law.
//
// WARRANTY DISCLAIMER: THE SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF
// ANY KIND.  AMD DISCLAIMS ALL WARRANTIES, EXPRESS, IMPLIED, OR STATUTORY,
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE, NON-INFRINGEMENT, THAT THE SOFTWARE
// WILL RUN UNINTERRUPTED OR ERROR-FREE OR WARRANTIES ARISING FROM CUSTOM OF
// TRADE OR COURSE OF USAGE.  THE ENTIRE RISK ASSOCIATED WITH THE USE OF THE
// SOFTWARE IS ASSUMED BY YOU.
// Some jurisdictions do not allow the exclusion of implied warranties, so
// the above exclusion may not apply to You. 
// 
// LIMITATION OF LIABILITY AND INDEMNIFICATION:  AMD AND ITS LICENSORS WILL
// NOT, UNDER ANY CIRCUMSTANCES BE LIABLE TO YOU FOR ANY PUNITIVE, DIRECT,
// INCIDENTAL, INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING FROM USE OF
// THE SOFTWARE OR THIS AGREEMENT EVEN IF AMD AND ITS LICENSORS HAVE BEEN
// ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  
// In no event shall AMD's total liability to You for all damages, losses,
// and causes of action (whether in contract, tort (including negligence) or
// otherwise) exceed the amount of $100 USD.  You agree to defend, indemnify
// and hold harmless AMD and its licensors, and any of their directors,
// officers, employees, affiliates or agents from and against any and all
// loss, damage, liability and other expenses (including reasonable attorneys'
// fees), resulting from Your use of the Software or violation of the terms and
// conditions of this Agreement.  
//
// U.S. GOVERNMENT RESTRICTED RIGHTS: The Materials are provided with "RESTRICTED
// RIGHTS." Use, duplication, or disclosure by the Government is subject to the
// restrictions as set forth in FAR 52.227-14 and DFAR252.227-7013, et seq., or
// its successor.  Use of the Materials by the Government constitutes
// acknowledgement of AMD's proprietary rights in them.
// 
// EXPORT RESTRICTIONS: The Materials may be subject to export restrictions as
// stated in the Software License Agreement.
//
//--------------------------------------------------------------------------------------


// DOPPRotationDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DOPPEngine.h"
#include "DOPPRotationDlg.h"
#include "afxdialogex.h"




IMPLEMENT_DYNAMIC(DOPPRotationDlg, CDialogEx)

DOPPRotationDlg::DOPPRotationDlg(CWnd* pParent)
	: CDialogEx(DOPPRotationDlg::IDD, pParent)
{
    m_pSlider       = NULL;
    m_pSliderValue  = NULL;

    m_uiAngle       = 0;
}

DOPPRotationDlg::~DOPPRotationDlg()
{
}

void DOPPRotationDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(DOPPRotationDlg, CDialogEx)
    ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER_ANGLE, &DOPPRotationDlg::OnNMCustomdrawSliderAngle)
    ON_BN_CLICKED(IDOK, &DOPPRotationDlg::OnBnClickedOk)
    ON_BN_CLICKED(IDCANCLE, &DOPPRotationDlg::OnBnClickedCancle)
END_MESSAGE_MAP()




void DOPPRotationDlg::OnNMCustomdrawSliderAngle(NMHDR *pNMHDR, LRESULT *pResult)
{
    m_uiAngle = m_pSlider->GetPos();

    char buf[8];

    sprintf_s(buf," %d", m_uiAngle);

    m_pSliderValue->SetWindowTextW(CA2CT(buf));
}



BOOL DOPPRotationDlg::OnInitDialog()
{
    m_pSlider = static_cast<CSliderCtrl*>(GetDlgItem(IDC_SLIDER_ANGLE));

    m_pSliderValue = static_cast<CEdit*>(GetDlgItem(IDC_EDIT_VALUE));

    if (!m_pSlider || !m_pSliderValue)
    {
        return false;
    }

    m_pSlider->SetRange(0, 360, false);

    return true;
}


void DOPPRotationDlg::OnBnClickedOk()
{
    CDialogEx::OnOK();
}


void DOPPRotationDlg::OnBnClickedCancle()
{
    CDialogEx::OnCancel();
}



