//=====================================================================
// Copyright 2018-2024 (c), Advanced Micro Devices, Inc. All rights reserved.
//=====================================================================
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files(the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and / or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions :
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
#pragma once

#include "imgui.h"

#include <QtGui/qopenglextrafunctions.h>
#include <QtCore/qobject.h>

#include <memory>

class QMouseEvent;
class QWheelEvent;
class QKeyEvent;

class QImGUI_OpenGLWindowWrapper
{
public:
    virtual ~QImGUI_OpenGLWindowWrapper()
    {
    }
    virtual void   installEventFilter(QObject* object)  = 0;
    virtual QSize  size() const                         = 0;
    virtual qreal  devicePixelRatio() const             = 0;
    virtual bool   isActive() const                     = 0;
    virtual QPoint mapFromGlobal(const QPoint& p) const = 0;
};

class ImGuiRenderer : public QObject, QOpenGLExtraFunctions
{
    Q_OBJECT
public:
    ImGuiRenderer()
    {
    }

    void Draw();
    void initialize(QImGUI_OpenGLWindowWrapper* window);
    void newFrame();
    bool eventFilter(QObject* watched, QEvent* event);

private:
    void renderDrawList(ImDrawData* draw_data);

    void onMousePressedChange(QMouseEvent* event);
    void onWheel(QWheelEvent* event);
    void onKeyPressRelease(QKeyEvent* event);

    bool createFontsTexture();
    bool createDeviceObjects();

    std::unique_ptr<QImGUI_OpenGLWindowWrapper> m_window;
    double                                      g_Time            = 0.0f;
    bool                                        g_MousePressed[3] = {false, false, false};
    float                                       g_MouseWheel      = 0.0f;
    GLuint                                      g_FontTexture     = 0;
    int                                         g_ShaderHandle = 0, g_VertHandle = 0, g_FragHandle = 0;
    int                                         g_AttribLocationTex = 0, g_AttribLocationProjMtx = 0;
    int                                         g_AttribLocationPosition = 0, g_AttribLocationUV = 0, g_AttribLocationColor = 0;
    unsigned int                                g_VboHandle = 0, g_VaoHandle = 0, g_ElementsHandle = 0;
};
