//=====================================================================
// Copyright 2016-2024 (c), Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files(the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and / or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions :
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
/// \file cpTreeWidget.h
/// \version 2.21
//
//=====================================================================

#ifndef CPTREEWIDGET_H
#define CPTREEWIDGET_H

#include <QtWidgets>
#include <QScrollArea>
#include <QGridLayout>
#include <QLabel>
#include <QIcon>
#include <QMap>
#include <QFile>

class cpTreeWidget : public QTreeWidget
{
    Q_OBJECT

public:
    cpTreeWidget(QWidget* parent = 0);
    ~cpTreeWidget();

    virtual bool     dropMimeData(QTreeWidgetItem* parent, int index, const QMimeData* data, Qt::DropAction action);
    QStringList      mimeTypes() const;
    Qt::DropActions  supportedDropActions() const;
    QTreeWidgetItem* m_currentItem;

private:
    QString  m_currToolTip;
    void     keyPressEvent(QKeyEvent* event);
    void     mousePressEvent(QMouseEvent* event);
    void     mouseMoveEvent(QMouseEvent* event);
    QVariant data(const QModelIndex& index, int role);

private slots:
    void selChanged();
signals:
    void DroppedImageItem(QString& filePathName, int index);
    void event_mousePress(QMouseEvent* event, bool onIcon);
    void event_keyPress(QKeyEvent* event);
};

#endif
