#pragma once

// Structure to describe vertex layout
struct vertex
{
	rpr_float pos[3];
	rpr_float norm[3];
	rpr_float tex[2];
};

// Cube geometry
vertex cube_data[] = 
{
	{ -1.0f, 1.0f, -1.0f, 0.f, 1.f, 0.f, 0.f, 0.f },
	{  1.0f, 1.0f, -1.0f, 0.f, 1.f, 0.f, 0.f, 0.f },
	{  1.0f, 1.0f, 1.0f , 0.f, 1.f, 0.f, 0.f, 0.f },
	{  -1.0f, 1.0f, 1.0f , 0.f, 1.f, 0.f, 0.f, 0.f},

	{  -1.0f, -1.0f, -1.0f , 0.f, -1.f, 0.f, 0.f, 0.f },
	{  1.0f, -1.0f, -1.0f , 0.f, -1.f, 0.f, 0.f, 0.f },
	{  1.0f, -1.0f, 1.0f , 0.f, -1.f, 0.f, 0.f, 0.f },
	{  -1.0f, -1.0f, 1.0f , 0.f, -1.f, 0.f, 0.f, 0.f },

	{  -1.0f, -1.0f, 1.0f , -1.f, 0.f, 0.f, 0.f, 0.f },
	{  -1.0f, -1.0f, -1.0f , -1.f, 0.f, 0.f, 0.f, 0.f },
	{  -1.0f, 1.0f, -1.0f , -1.f, 0.f, 0.f, 0.f, 0.f },
	{  -1.0f, 1.0f, 1.0f , -1.f, 0.f, 0.f, 0.f, 0.f },

	{  1.0f, -1.0f, 1.0f ,  1.f, 0.f, 0.f, 0.f, 0.f },
	{  1.0f, -1.0f, -1.0f ,  1.f, 0.f, 0.f, 0.f, 0.f },
	{  1.0f, 1.0f, -1.0f ,  1.f, 0.f, 0.f, 0.f, 0.f },
	{  1.0f, 1.0f, 1.0f ,  1.f, 0.f, 0.f, 0.f, 0.f },

	{  -1.0f, -1.0f, -1.0f ,  0.f, 0.f, -1.f , 0.f, 0.f },
	{  1.0f, -1.0f, -1.0f ,  0.f, 0.f, -1.f , 0.f, 0.f },
	{  1.0f, 1.0f, -1.0f ,  0.f, 0.f, -1.f, 0.f, 0.f },
	{  -1.0f, 1.0f, -1.0f ,  0.f, 0.f, -1.f, 0.f, 0.f },

	{  -1.0f, -1.0f, 1.0f , 0.f, 0.f, 1.f, 0.f, 0.f },
	{  1.0f, -1.0f, 1.0f , 0.f, 0.f,  1.f, 0.f, 0.f },
	{  1.0f, 1.0f, 1.0f , 0.f, 0.f, 1.f, 0.f, 0.f },
	{  -1.0f, 1.0f, 1.0f , 0.f, 0.f, 1.f, 0.f, 0.f },
};

// Plane geometry
vertex plane_data[] = 
{
	{-15.f, 0.f, -15.f, 0.f, 1.f, 0.f, 0.f, 0.f},
	{-15.f, 0.f,  15.f, 0.f, 1.f, 0.f, 0.f, 1.f},
	{ 15.f, 0.f,  15.f, 0.f, 1.f, 0.f, 1.f, 1.f},
	{ 15.f, 0.f, -15.f, 0.f, 1.f, 0.f, 1.f, 0.f},
};

// Cube indices
rpr_int indices[] = 
{
	3,1,0,
	2,1,3,

	6,4,5,
	7,4,6,

	11,9,8,
	10,9,11,

	14,12,13,
	15,12,14,

	19,17,16,
	18,17,19,

	22,20,21,
	23,20,22
};

// Number of vertices per face
rpr_int num_face_vertices[] = 
{
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3
};


#define CHECK(x) status = x; assert(status == RPR_SUCCESS);

// Number of iterations for rendering
int const NUM_ITERATIONS = 64;

float PseudoRandom_GetFloat(float min, float max) {
	return (((float)rand() / (float)RAND_MAX) * (max - min)) + min;
}