#pragma once






//
//
//
// This file declares some API functions that are not supported by latest RPR API anymore but that can still be emulated by RPR for backward compatibility purpose. 
// Even if those funtions are emulated correctly, it's not recommended to use them in projects anymore.
//
//
//







#include <RadeonProRender.h>

#define RPRX_SUPPORT_API_VERSION 0x0000002 
#define RPRX_FLAGS_ENABLE_LOGGING 0x1 
#define RPRX_MATERIAL_UBER 0x1 

typedef rpr_uint rprx_material_type;
typedef rpr_uint rprx_parameter;
typedef rpr_uint rprx_parameter_type;

struct _rprxcontext
{
    rpr_uint padding;
};
struct _rprxmaterial
{
    rpr_uint padding;
};

typedef _rprxcontext *rprx_context;
typedef _rprxmaterial *rprx_material;

//rprx_parameter
#define RPRX_UBER_MATERIAL_DIFFUSE_COLOR			RPR_UBER_MATERIAL_INPUT_DIFFUSE_COLOR 
#define RPRX_UBER_MATERIAL_DIFFUSE_WEIGHT			RPR_UBER_MATERIAL_INPUT_DIFFUSE_WEIGHT 
#define RPRX_UBER_MATERIAL_DIFFUSE_ROUGHNESS			RPR_UBER_MATERIAL_INPUT_DIFFUSE_ROUGHNESS 
#define RPRX_UBER_MATERIAL_DIFFUSE_NORMAL			RPR_UBER_MATERIAL_INPUT_DIFFUSE_NORMAL 
#define RPRX_UBER_MATERIAL_REFLECTION_COLOR			RPR_UBER_MATERIAL_INPUT_REFLECTION_COLOR 
#define RPRX_UBER_MATERIAL_REFLECTION_WEIGHT			RPR_UBER_MATERIAL_INPUT_REFLECTION_WEIGHT 
#define RPRX_UBER_MATERIAL_REFLECTION_ROUGHNESS			RPR_UBER_MATERIAL_INPUT_REFLECTION_ROUGHNESS 
#define RPRX_UBER_MATERIAL_REFLECTION_ANISOTROPY		RPR_UBER_MATERIAL_INPUT_REFLECTION_ANISOTROPY 
#define RPRX_UBER_MATERIAL_REFLECTION_ANISOTROPY_ROTATION		RPR_UBER_MATERIAL_INPUT_REFLECTION_ANISOTROPY_ROTATION 
#define RPRX_UBER_MATERIAL_REFLECTION_MODE		RPR_UBER_MATERIAL_INPUT_REFLECTION_MODE 
#define RPRX_UBER_MATERIAL_REFLECTION_IOR		RPR_UBER_MATERIAL_INPUT_REFLECTION_IOR 
#define RPRX_UBER_MATERIAL_REFLECTION_METALNESS			RPR_UBER_MATERIAL_INPUT_REFLECTION_METALNESS 
#define RPRX_UBER_MATERIAL_REFLECTION_NORMAL		RPR_UBER_MATERIAL_INPUT_REFLECTION_NORMAL 
#define RPRX_UBER_MATERIAL_REFRACTION_COLOR			RPR_UBER_MATERIAL_INPUT_REFRACTION_COLOR 
#define RPRX_UBER_MATERIAL_REFRACTION_WEIGHT		RPR_UBER_MATERIAL_INPUT_REFRACTION_WEIGHT 
#define RPRX_UBER_MATERIAL_REFRACTION_ROUGHNESS			RPR_UBER_MATERIAL_INPUT_REFRACTION_ROUGHNESS 
#define RPRX_UBER_MATERIAL_REFRACTION_IOR		RPR_UBER_MATERIAL_INPUT_REFRACTION_IOR 
#define RPRX_UBER_MATERIAL_REFRACTION_NORMAL		RPR_UBER_MATERIAL_INPUT_REFRACTION_NORMAL 
#define RPRX_UBER_MATERIAL_REFRACTION_THIN_SURFACE		RPR_UBER_MATERIAL_INPUT_REFRACTION_THIN_SURFACE 
#define RPRX_UBER_MATERIAL_REFRACTION_ABSORPTION_COLOR		RPR_UBER_MATERIAL_INPUT_REFRACTION_ABSORPTION_COLOR 
#define RPRX_UBER_MATERIAL_REFRACTION_ABSORPTION_DISTANCE		RPR_UBER_MATERIAL_INPUT_REFRACTION_ABSORPTION_DISTANCE 
#define RPRX_UBER_MATERIAL_REFRACTION_CAUSTICS		RPR_UBER_MATERIAL_INPUT_REFRACTION_CAUSTICS 
#define RPRX_UBER_MATERIAL_COATING_COLOR		RPR_UBER_MATERIAL_INPUT_COATING_COLOR 
#define RPRX_UBER_MATERIAL_COATING_WEIGHT		RPR_UBER_MATERIAL_INPUT_COATING_WEIGHT 
#define RPRX_UBER_MATERIAL_COATING_ROUGHNESS		RPR_UBER_MATERIAL_INPUT_COATING_ROUGHNESS 
#define RPRX_UBER_MATERIAL_COATING_MODE			RPR_UBER_MATERIAL_INPUT_COATING_MODE 
#define RPRX_UBER_MATERIAL_COATING_IOR		RPR_UBER_MATERIAL_INPUT_COATING_IOR 
#define RPRX_UBER_MATERIAL_COATING_METALNESS		RPR_UBER_MATERIAL_INPUT_COATING_METALNESS 
#define RPRX_UBER_MATERIAL_COATING_NORMAL		RPR_UBER_MATERIAL_INPUT_COATING_NORMAL 
#define RPRX_UBER_MATERIAL_COATING_TRANSMISSION_COLOR		RPR_UBER_MATERIAL_INPUT_COATING_TRANSMISSION_COLOR 
#define RPRX_UBER_MATERIAL_COATING_THICKNESS		RPR_UBER_MATERIAL_INPUT_COATING_THICKNESS 
#define RPRX_UBER_MATERIAL_SHEEN		RPR_UBER_MATERIAL_INPUT_SHEEN 
#define RPRX_UBER_MATERIAL_SHEEN_TINT		RPR_UBER_MATERIAL_INPUT_SHEEN_TINT 
#define RPRX_UBER_MATERIAL_SHEEN_WEIGHT			RPR_UBER_MATERIAL_INPUT_SHEEN_WEIGHT 
#define RPRX_UBER_MATERIAL_EMISSION_COLOR		RPR_UBER_MATERIAL_INPUT_EMISSION_COLOR 
#define RPRX_UBER_MATERIAL_EMISSION_WEIGHT		RPR_UBER_MATERIAL_INPUT_EMISSION_WEIGHT 
#define RPRX_UBER_MATERIAL_EMISSION_MODE		RPR_UBER_MATERIAL_INPUT_EMISSION_MODE 
#define RPRX_UBER_MATERIAL_TRANSPARENCY			RPR_UBER_MATERIAL_INPUT_TRANSPARENCY 
//#define RPRX_UBER_MATERIAL_DISPLACEMENT			RPR_UBER_MATERIAL_INPUT_DISPLACEMENT   // removed.  replaced by rprShapeSetDisplacementMaterial
#define RPRX_UBER_MATERIAL_SSS_SCATTER_COLOR		RPR_UBER_MATERIAL_INPUT_SSS_SCATTER_COLOR 
#define RPRX_UBER_MATERIAL_SSS_SCATTER_DISTANCE			RPR_UBER_MATERIAL_INPUT_SSS_SCATTER_DISTANCE 
#define RPRX_UBER_MATERIAL_SSS_SCATTER_DIRECTION		RPR_UBER_MATERIAL_INPUT_SSS_SCATTER_DIRECTION 
#define RPRX_UBER_MATERIAL_SSS_WEIGHT		RPR_UBER_MATERIAL_INPUT_SSS_WEIGHT 
#define RPRX_UBER_MATERIAL_SSS_MULTISCATTER			RPR_UBER_MATERIAL_INPUT_SSS_MULTISCATTER 
#define RPRX_UBER_MATERIAL_BACKSCATTER_WEIGHT		RPR_UBER_MATERIAL_INPUT_BACKSCATTER_WEIGHT 
#define RPRX_UBER_MATERIAL_BACKSCATTER_COLOR		RPR_UBER_MATERIAL_INPUT_BACKSCATTER_COLOR 
#define RPRX_UBER_MATERIAL_FRESNEL_SCHLICK_APPROXIMATION		RPR_UBER_MATERIAL_INPUT_FRESNEL_SCHLICK_APPROXIMATION

#define RPRX_UBER_MATERIAL_BLEND_COLOR0 0x12EU 
#define RPRX_UBER_MATERIAL_BLEND_COLOR1 0x12FU 
#define RPRX_UBER_MATERIAL_BLEND_WEIGHT 0x130U 
#define RPRX_UBER_MATERIAL_TWOSIDED_FRONTFACE 0x131U 
#define RPRX_UBER_MATERIAL_TWOSIDED_BACKFACE 0x132U 

#define RPRX_UBER_MATERIAL_REFLECTION_MODE_PBR 0x1U 
#define RPRX_UBER_MATERIAL_REFLECTION_MODE_METALNESS 0x2U 
#define RPRX_UBER_MATERIAL_COATING_MODE_PBR 0x1U 
#define RPRX_UBER_MATERIAL_COATING_MODE_METALNESS 0x2U 
#define RPRX_UBER_MATERIAL_EMISSION_MODE_SINGLESIDED 0x1U 
#define RPRX_UBER_MATERIAL_EMISSION_MODE_DOUBLESIDED 0x2U 

#define RPRX_PARAMETER_TYPE_FLOAT4 0x1U 
#define RPRX_PARAMETER_TYPE_UINT 0x2U 
#define RPRX_PARAMETER_TYPE_NODE 0x3U 



//
// RPRX / rprSupport doesn't exist anymore
// Uber material is now a classic material inside Core RPR API : RPR_MATERIAL_NODE_UBERV2
// using those rprx* functions below is exactly the same thing that using RPR_MATERIAL_NODE_UBERV2
//
extern RPR_API_ENTRY rpr_int rprxCreateContext(rpr_material_system material_system, rpr_uint flags, rprx_context* out_context);
extern RPR_API_ENTRY rpr_int rprxCreateMaterial(rprx_context context, rprx_material_type type, rprx_material* out_material);
extern RPR_API_ENTRY rpr_int rprxMaterialDelete(rprx_context context, rprx_material material);
extern RPR_API_ENTRY rpr_int rprxMaterialSetParameterN(rprx_context context, rprx_material material, rprx_parameter parameter, rpr_material_node node);
extern RPR_API_ENTRY rpr_int rprxMaterialSetParameterUber(rprx_context context, rprx_material material, rprx_parameter parameter, rprx_material nodeX);
extern RPR_API_ENTRY rpr_int rprxMaterialSetParameterU(rprx_context context, rprx_material material, rprx_parameter parameter, rpr_uint value);
extern RPR_API_ENTRY rpr_int rprxMaterialSetParameterF(rprx_context context, rprx_material material, rprx_parameter parameter, rpr_float x, rpr_float y, rpr_float z, rpr_float w);
extern RPR_API_ENTRY rpr_int rprxMaterialGetParameterType(rprx_context context, rprx_material material, rprx_parameter parameter, rpr_parameter_type * out_type);
extern RPR_API_ENTRY rpr_int rprxMaterialGetParameterValue(rprx_context context, rprx_material material, rprx_parameter parameter, void * out_value);
extern RPR_API_ENTRY rpr_int rprxMaterialCommit(rprx_context context, rprx_material material);
extern RPR_API_ENTRY rpr_int rprxShapeAttachMaterial(rprx_context context, rpr_shape shape, rprx_material material);
extern RPR_API_ENTRY rpr_int rprxCurveAttachMaterial(rprx_context context, rpr_curve curve, rprx_material material);
extern RPR_API_ENTRY rpr_int rprxShapeDetachMaterial(rprx_context context, rpr_shape shape, rprx_material material);
extern RPR_API_ENTRY rpr_int rprxCurveDetachMaterial(rprx_context context, rpr_curve curve, rprx_material material);
extern RPR_API_ENTRY rpr_int rprxMaterialAttachMaterial(rprx_context context, rpr_material_node node, rpr_char const * parameter, rprx_material material);
extern RPR_API_ENTRY rpr_int rprxMaterialDetachMaterial(rprx_context context, rpr_material_node node, rpr_char const * parameter, rprx_material material);
extern RPR_API_ENTRY rpr_int rprxDeleteContext(rprx_context context);
extern RPR_API_ENTRY rpr_int rprxMaterialSetName(rprx_context context, rprx_material material, rpr_char const * name);
extern RPR_API_ENTRY rpr_int rprxMaterialGetName(rprx_context context, rprx_material material, size_t size, void * data, size_t * size_ret);


//
// Those functions have not been implemented in the backward compatibility :
//
//rpr_int rprxMaterialGetSurfaceNode(rprx_context context, rprx_material material, rpr_material_node* node);
//rpr_int rprxMaterialGetVolumeNode(rprx_context context, rprx_material material, rpr_material_node* node);
//rpr_int rprxMaterialGetDisplacementNode(rprx_context context, rprx_material material, rpr_material_node* node);
//rpr_int rprxIsMaterialRprx(rprx_context context, rpr_material_node node, rprx_material * out_material, rpr_bool* out_result);  
//rpr_int rprxGetLog(rprx_context context, rpr_char* log, size_t* size);
//rpr_int rprxShapeGetMaterial(rprx_context context, rpr_shape shape, rprx_material* material);
//rpr_int rprxCurveGetMaterial(rprx_context context, rpr_curve curve, rprx_material* material);


//
// materials should no longer use string parameters. only key parameters ( use rprMaterialNodeSetInput*ByKey )
//
extern RPR_API_ENTRY rpr_int rprMaterialNodeSetInputF(rpr_material_node in_node, const char* param, float x, float y, float z, float w); 
extern RPR_API_ENTRY rpr_int rprMaterialNodeSetInputN(rpr_material_node in_node, rpr_char const * in_input, rpr_material_node in_input_node);
extern RPR_API_ENTRY rpr_int rprMaterialNodeSetInputU(rpr_material_node in_node, rpr_char const * in_input, rpr_uint in_value);
extern RPR_API_ENTRY rpr_int rprMaterialNodeSetInputImageData(rpr_material_node in_node, rpr_char const * in_input, rpr_image image);
extern RPR_API_ENTRY rpr_int rprMaterialNodeSetInputBufferData(rpr_material_node in_node, rpr_char const * in_input, rpr_buffer buffer);



//
// context should no longer use string parameters. only key parameters ( use rprContextSetParameterByKey* )
//
extern RPR_API_ENTRY rpr_int rprContextSetParameter1u(rpr_context context, rpr_char const * name, rpr_uint x);
extern RPR_API_ENTRY rpr_int rprContextSetParameter1f(rpr_context context, rpr_char const * name, rpr_float x);
extern RPR_API_ENTRY rpr_int rprContextSetParameter3f(rpr_context context, rpr_char const * name, rpr_float x, rpr_float y, rpr_float z);
extern RPR_API_ENTRY rpr_int rprContextSetParameter4f(rpr_context context, rpr_char const * name, rpr_float x, rpr_float y, rpr_float z, rpr_float w);
extern RPR_API_ENTRY rpr_int rprContextSetParameterString(rpr_context context, rpr_char const * name, rpr_char const * value);


