function fileExists(name)
    local f=io.open(name,"r")
    if f~=nil then io.close(f) return true else return false end
end

newoption {
    trigger     = "metal",
    description = "Enable Metal backend (MacOs only)"
}

solution "Samples"

configurations { "Debug", "Release" }
language "C++"
flags { "NoMinimalRebuild", "EnableSSE", "EnableSSE2" }

if( _OPTIONS["metal"]) then
    defines{ "RIF_USE_METAL=1" }
    print ">> Building RadeonProImageProcessing to use metal backend";
end

-- define common includes
includedirs {".","ImageTools", "../RadeonImageFilters" }

platforms {"x64"}

--make configuration specific definitions
configuration "Debug"
    defines { "_DEBUG" }
    flags { "Symbols" }
    targetsuffix "D"
configuration "Release"
    defines { "NDEBUG" }
    flags { "Optimize" }

configuration {"x64", "Debug"}
    libdirs {"../Bin/Debug/x64"}
    links {"RadeonImageFilters64D"}
configuration {"x64", "Release"}
    libdirs {"../Bin/Release/x64"}
    links {"RadeonImageFilters64"}
configuration {}

-- perform OS specific initializations
local targetName;
if os.is("macosx") then
    targetName = "osx"
end

if os.is("windows") then
    targetName = "win"
    defines{ "WIN32" }
    buildoptions { "/MP"  } --multiprocessor build
    defines {"_CRT_SECURE_NO_WARNINGS"}
elseif os.is("linux") then
    buildoptions {"-fvisibility=hidden -std=c++14 -fPIC"}
elseif os.is("macosx") then
    buildoptions {"-fvisibility=hidden -std=c++11 -fPIC"}
end

if _OPTIONS["use_opencl"] then
    defines{"USE_OPENCL=1"}
end

if _OPTIONS["enable_fp16"] then
    defines{"FP16_ENABLED=1"}
end

if os.is("windows") then
    libdirs { "../3rdparty/lib/windows/oidn-0.9.0" }
    links { "opengl32", "OpenImageDenoise" }
end
if os.is("linux") then
    libdirs { "../3rdparty/lib/linux/oidn-0.9.0" }
    links { "RadeonImageFilters64", "GL", "pthread", "dl", "OpenImageDenoise" }
    -- linkoptions {"-Wl,-rpath=$(TARGETDIR)"}
end
if os.is("macosx") then
    libdirs { "../3rdparty/lib/macosx/oidn-0.9.0" }
    links { "OpenImageDenoise" }
    linkoptions{ "-framework OpenCL", "-framework Cocoa", "-framework OpenGL", "-framework IOKit" }
end


targetdir "./Bin"

configuration "Debug"


if os.is("windows") then
    if _OPTIONS["rif_dev"] then
        prebuildcommands { "{COPY} ../Bin/Debug/x64/RadeonImageFilters64D.dll %{cfg.targetdir}" }
    else
        prebuildcommands { "{COPY} ../Bin/Release/x64/RadeonImageFilters64.dll %{cfg.targetdir}" }
    end
else
    prebuildcommands { "{COPY} ../Bin/Debug/x64/libRadeonImageFilters64D.so %{cfg.targetdir}" }
end

configuration "Release"

if os.is("windows") then
    prebuildcommands { "{COPY} ../Bin/Release/x64/RadeonImageFilters64.dll %{cfg.targetdir}" }
else
    prebuildcommands { "{COPY} ../Bin/Release/x64/libRadeonImageFilters64.so %{cfg.targetdir}" }
end

configuration {}

if os.is("linux") then
    libdirs { "../3rdparty/lib/linux", "../3rdparty/lib/linux/RadeonProML" }

    dofile ("../OpenCLSearch.lua" )

    links { "RadeonProML-miopen",
            "RadeonProML-base",
            "RadeonProML-base-graph",
            "RadeonProML-base-graph-tensorflow",
            "RadeonProML-common",
            "tensorflow-graph-proto",
            "protobuf",
            "MIOpen"}
    links {"GL", "pthread", "dl", "OpenCL"}
end

if os.is("windows") then
    libdirs { "../3rdparty/lib/windows/MIOpen-1.7.1.2" }
    configuration "Debug"
    libdirs { "../3rdparty/lib/windows/RadeonProML/Debug" }
    configuration "Release"
    libdirs { "../3rdparty/lib/windows/RadeonProML/Release" }
    configuration {}
end

if fileExists("./BilateralDenoise/BilateralDenoise.lua") then
    dofile("./BilateralDenoise/BilateralDenoise.lua")
end

if fileExists("./MLAA/MLAA.lua") then
    dofile("./MLAA/MLAA.lua")
end

if fileExists("./GaussianBlur/GaussianBlur.lua") then
    dofile("./GaussianBlur/GaussianBlur.lua")
end

if fileExists("./ToneMapping/ToneMapping.lua") then
    dofile("./ToneMapping/ToneMapping.lua")
end

if fileExists("./EdgeDetection/EdgeDetection.lua") then
    dofile("./EdgeDetection/EdgeDetection.lua")
end

if fileExists("./MedianDenoise/MedianDenoise.lua") then
    dofile("./MedianDenoise/MedianDenoise.lua")
end

if fileExists("./UserDefined/UserDefined.lua") then
    dofile("./UserDefined/UserDefined.lua")
end

if fileExists("./Denoisers/Denoisers.lua") then
    dofile("./Denoisers/Denoisers.lua")
end

if fileExists("./PhotoToneMapping/PhotoToneMapping.lua") then
    dofile("./PhotoToneMapping/PhotoToneMapping.lua")
end

if fileExists("./Bloom/Bloom.lua") then
    dofile("./Bloom/Bloom.lua")
end

if os.is("windows") or os.is("linux") then
    if fileExists("./AIDenoiser/AIDenoiser.lua") then
        dofile("./AIDenoiser/AIDenoiser.lua")

        if os.is("windows") then
            postbuildcommands { "{COPY} ../3rdparty/lib/windows/MIOpen-1.7.1.2/MIOpen.dll %{cfg.targetdir}" }
            configuration "Debug"
            postbuildcommands { "{COPY} ../3rdparty/lib/windows/RadeonML/Release/RadeonML-MIOpen-d.dll %{cfg.targetdir}" }
            configuration "Release"
            postbuildcommands { "{COPY} ../3rdparty/lib/windows/RadeonML/Release/RadeonML-MIOpen.dll %{cfg.targetdir}" }
        end
        postbuildcommands { "{COPY} ../models ./models" }

    end
end

if fileExists("./OpenImageDenoiser/OpenImageDenoiser.lua") then
    if os.is("windows") then
        configuration "Debug"
        postbuildcommands { "{COPY} ../Bin/Debug/x64/RadeonImageFilters64D.dll %{cfg.targetdir}" }
        configuration "Release"
        postbuildcommands { "{COPY} ../Bin/Release/x64/RadeonImageFilters64.dll %{cfg.targetdir}" }
        configuration {}
        postbuildcommands { "{COPY} ../3rdparty/lib/windows/oidn-0.9.0/tbb-4233fe.dll %{cfg.targetdir}" }
        postbuildcommands { "{COPY} ../3rdparty/lib/windows/oidn-0.9.0/tbbmalloc-4233fe.dll %{cfg.targetdir}" }
        postbuildcommands { "{COPY} ../3rdparty/lib/windows/oidn-0.9.0/OpenImageDenoise.dll %{cfg.targetdir}" }
    end

    dofile("./OpenImageDenoiser/OpenImageDenoiser.lua")
end
