// This file is part of the FidelityFX SDK.
//
// Copyright (C) 2024 Advanced Micro Devices, Inc.
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files(the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and /or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions :
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// An Owen-scrambled Sobol sequence of 256 samples of 256 dimensions
static const int sobol_256spp_256d[256*256] = {32,226,72,70,57,171,246,75,112,81,109,239,120,101,230,103,103,41,249,86,253,99,132,184,214,147,128,248,17,149,163,17,60,40,169,196,77,79,102,23,250,77,75,151,95,123,234,198,25,26,184,114,230,188,105,18,231,233,175,151,19,174,202,71,84,229,247,148,182,127,92,14,41,112,162,253,35,101,137,30,111,134,95,122,28,2,41,254,181,91,101,188,145,31,166,38,53,193,1,122,99,86,178,36,198,169,113,255,97,221,227,231,29,100,30,141,250,254,16,157,2,220,187,95,181,125,207,187,105,119,156,41,16,194,93,216,227,124,138,90,227,1,88,153,233,69,120,36,19,189,120,4,185,220,185,109,184,96,247,173,210,227,54,3,18,9,139,213,156,57,61,101,37,247,21,201,10,143,11,38,146,18,118,129,95,191,75,207,12,252,238,104,47,39,190,229,31,56,20,127,42,178,100,141,93,222,192,247,186,7,224,161,72,100,87,69,218,44,25,195,185,118,179,123,231,170,96,225,204,52,117,60,3,86,25,143,230,18,11,165,72,188,158,3,66,105,50,200,226,145,227,45,183,62,82,176,191,36,248,191,189,122,96,185,146,166,203,78,144,189,67,174,154,182,86,169,90,236,101,40,71,107,81,93,159,82,75,230,157,191,34,35,235,139,150,193,10,142,217,77,154,249,74,13,196,248,56,154,27,6,242,226,105,94,66,67,145,112,31,145,133,68,21,0,44,212,254,153,183,238,98,102,145,199,100,213,196,52,131,141,216,209,236,122,58,249,188,108,8,206,62,199,207,103,160,247,207,255,101,185,1,113,223,126,182,0,50,93,250,174,194,18,65,111,206,104,156,3,48,195,122,212,10,101,235,200,13,183,173,7,192,3,101,228,84,168,121,241,205,122,115,132,155,242,215,22,236,242,69,35,48,245,3,175,68,57,4,15,226,155,222,140,54,48,80,200,194,149,213,68,225,14,182,122,147,195,69,166,191,17,176,58,222,58,190,70,66,153,196,215,121,123,176,190,161,145,203,121,255,27,207,28,113,22,44,232,46,84,181,131,245,220,27,202,161,38,94,208,39,143,52,5,154,85,121,139,226,223,159,246,170,56,94,209,188,71,205,76,16,233,168,172,200,37,19,123,120,202,28,175,232,88,120,107,157,198,111,253,18,24,36,35,43,169,199,197,137,194,12,238,138,232,17,17,58,115,39,234,4,164,225,215,14,185,232,76,215,171,142,206,206,132,90,31,130,24,0,165,34,91,126,113,64,202,144,114,132,125,58,184,234,211,246,238,168,7,1,172,169,218,67,29,185,66,73,49,222,167,243,189,36,116,23,223,219,200,84,67,94,53,79,26,202,204,91,180,221,166,106,18,207,17,128,137,246,235,162,13,129,130,49,76,104,189,138,55,174,71,152,49,116,204,207,103,198,147,225,142,79,8,172,59,234,225,192,168,181,144,185,6,233,243,61,123,46,55,44,16,228,79,156,235,190,115,61,162,115,182,122,230,138,204,140,86,173,80,99,207,211,181,23,141,152,17,180,35,121,168,67,205,107,74,55,229,234,210,6,94,48,186,210,189,2,200,190,181,227,128,211,225,215,228,74,7,188,195,36,82,10,131,96,99,138,63,1,210,39,134,153,112,72,163,196,55,126,37,125,107,234,166,129,80,61,97,121,20,123,222,3,155,219,62,49,207,87,182,26,214,167,142,89,38,36,112,87,100,56,245,240,152,23,7,237,11,185,206,233,203,131,42,53,35,60,40,211,114,9,13,189,130,196,210,173,39,208,56,110,34,240,65,75,234,76,73,34,39,2,118,174,237,52,194,197,28,155,161,135,180,200,3,89,210,26,154,145,45,57,54,85,26,118,207,212,58,101,69,202,184,36,234,219,155,41,29,80,22,193,175,145,100,50,29,149,166,168,162,213,130,36,25,234,78,84,97,191,139,95,156,9,12,41,97,110,222,8,16,250,161,130,45,111,195,83,213,16,141,154,48,124,175,89,25,27,9,172,242,51,167,76,109,69,107,23,80,23,166,12,16,180,156,182,238,148,249,59,130,75,122,59,134,240,69,220,21,230,47,1,124,66,180,77,247,147,103,66,98,211,96,105,213,127,178,144,102,213,33,247,141,232,67,62,86,230,222,146,68,122,27,147,7,85,69,31,22,67,67,78,13,149,221,57,121,176,133,161,84,201,146,119,196,217,19,132,52,76,135,247,107,29,131,248,220,156,248,29,41,36,202,174,136,253,191,226,91,179,96,69,213,172,0,206,75,192,54,69,120,138,218,171,185,232,211,139,8,31,11,50,119,28,197,83,158,170,229,244,195,190,23,213,87,70,17,102,197,39,59,88,152,234,95,106,29,195,236,114,136,6,159,105,101,2,119,184,47,212,218,188,165,163,138,174,114,71,54,127,64,183,39,51,42,209,202,106,96,215,154,56,33,102,25,62,111,9,49,4,98,142,198,128,138,13,74,95,229,42,164,19,175,179,111,138,19,157,125,94,34,221,103,246,144,141,176,129,201,55,100,23,12,139,33,227,91,223,224,69,120,83,245,50,57,190,21,54,86,245,95,250,34,71,249,100,201,144,16,221,0,40,74,133,38,145,48,217,119,132,34,138,67,161,62,221,126,108,207,140,42,156,13,224,198,142,19,55,85,254,155,140,168,250,58,118,137,42,78,8,48,89,195,167,91,243,246,88,23,22,206,17,190,56,125,171,116,245,129,121,57,144,228,159,197,243,217,239,86,188,152,88,239,112,120,245,119,147,189,25,128,240,72,208,29,162,23,152,24,143,226,136,174,171,58,178,10,5,250,209,239,88,62,34,251,156,163,231,247,102,112,46,48,61,233,24,71,54,73,12,81,195,243,115,138,145,194,164,135,148,51,201,104,74,24,78,107,65,246,118,159,165,130,206,34,157,177,180,10,126,163,167,129,75,0,149,115,172,21,242,139,162,170,92,238,35,46,24,108,101,62,26,147,180,210,227,166,103,149,188,192,92,115,141,161,120,90,231,250,181,130,208,232,151,157,141,208,27,81,82,42,162,244,186,62,163,6,254,94,107,138,123,144,14,216,138,235,104,135,98,77,82,57,47,77,171,213,192,134,69,226,93,197,9,63,181,197,169,22,248,190,55,178,250,167,76,157,101,170,138,94,156,44,12,155,102,133,133,149,43,224,51,130,44,138,3,195,25,161,29,216,1,188,160,73,4,196,125,240,92,88,50,192,176,234,39,109,96,39,60,165,226,80,248,179,232,244,141,102,81,131,110,19,206,225,222,115,198,63,195,251,19,155,77,51,194,251,124,13,77,69,106,112,114,187,126,67,222,81,227,163,80,172,25,70,205,111,48,160,111,165,112,243,47,236,107,81,15,83,95,132,80,133,178,116,87,10,195,139,151,122,44,82,111,24,234,156,187,202,250,20,233,186,204,184,154,149,117,78,205,119,71,166,192,239,88,148,154,229,200,139,163,129,12,155,167,252,50,198,46,106,221,91,235,75,2,14,240,122,62,178,218,42,223,213,6,17,212,242,32,190,96,163,121,63,228,65,111,229,63,70,140,232,221,248,216,80,5,145,12,27,33,195,86,111,42,125,70,44,232,82,209,40,234,168,224,215,215,133,247,128,76,248,178,34,253,61,204,193,105,44,227,66,45,238,159,16,241,67,99,178,235,181,68,204,234,144,58,40,132,125,203,25,204,148,151,253,195,198,81,8,54,248,148,248,58,54,235,82,71,67,181,212,241,43,111,111,202,69,166,200,66,87,245,207,70,112,64,26,240,149,82,86,28,104,17,59,72,154,106,1,173,59,21,204,184,231,15,224,161,253,174,78,249,25,217,35,144,180,57,102,174,57,138,227,125,141,246,16,35,201,173,170,31,107,205,169,59,19,52,209,226,49,136,168,13,238,63,53,78,203,68,18,146,228,165,245,244,84,215,78,230,167,83,239,15,210,34,99,90,184,143,187,50,98,95,182,121,47,53,112,15,53,239,130,105,66,142,11,185,224,203,20,44,156,28,197,195,65,118,36,206,88,55,37,18,112,9,20,231,73,6,11,225,79,180,145,124,204,29,245,148,198,53,210,171,103,53,215,106,111,154,237,107,2,249,79,145,126,255,255,53,222,196,57,237,131,6,63,45,70,68,190,191,12,210,247,162,41,135,184,234,206,153,176,115,255,114,178,110,24,25,66,114,55,29,79,253,67,124,245,37,236,13,88,232,186,18,143,178,59,5,237,10,249,253,37,88,46,134,71,53,74,172,186,69,137,11,154,60,68,120,125,100,91,182,239,177,38,28,125,208,165,38,150,207,244,41,88,127,241,251,168,84,195,111,37,211,165,113,3,212,184,180,207,48,52,204,171,213,128,154,138,218,69,214,154,99,201,203,109,93,71,190,5,99,1,72,173,15,149,49,253,51,82,171,179,114,131,68,114,133,15,104,227,141,109,39,68,225,130,50,51,133,154,148,48,28,230,9,43,157,50,133,203,239,37,160,233,120,54,20,116,57,174,116,158,45,8,196,14,200,80,203,212,233,1,0,88,172,214,196,22,192,224,142,138,146,230,105,100,153,155,112,241,124,26,71,253,143,4,191,50,49,88,226,25,142,141,13,12,50,159,122,211,42,168,23,217,253,218,151,135,3,152,114,102,191,76,186,42,124,70,19,56,25,85,234,58,57,225,230,253,56,194,107,134,142,201,213,43,14,33,242,16,141,205,196,99,143,100,115,5,99,128,100,221,174,110,191,83,165,164,78,60,124,209,199,63,185,120,175,43,3,24,40,153,1,83,147,223,112,72,242,148,166,115,36,138,42,13,63,1,45,173,225,83,121,19,23,208,171,146,240,108,150,3,213,83,210,238,72,120,80,197,2,4,159,197,138,216,19,178,24,173,212,237,169,129,129,102,51,63,203,142,11,134,180,207,105,98,133,253,20,224,6,126,194,167,33,132,90,101,179,113,216,222,132,30,88,23,229,210,85,6,154,226,252,17,39,174,208,255,8,11,252,159,110,195,86,250,59,161,218,31,140,167,41,33,201,143,250,68,82,205,44,4,77,43,214,212,60,82,214,41,44,125,236,152,34,64,133,184,58,145,227,65,70,73,166,49,21,158,242,114,42,75,209,36,72,188,192,146,223,138,76,27,235,115,153,105,169,96,209,231,4,33,105,226,175,187,91,218,12,73,168,214,254,98,208,113,214,116,177,49,34,94,22,127,175,12,155,193,56,187,115,187,240,136,234,206,189,250,115,219,154,17,52,62,198,63,225,81,77,90,127,246,219,192,106,223,78,102,88,142,46,208,156,230,196,67,182,18,112,210,126,198,59,15,234,166,243,77,61,149,24,223,70,245,142,178,199,101,195,190,109,78,244,224,12,84,52,158,184,88,212,155,159,128,187,54,48,209,190,202,157,70,122,109,33,221,124,227,1,196,124,121,163,138,238,25,129,134,83,111,124,60,142,46,143,48,85,63,5,77,46,251,193,209,81,108,149,108,1,47,137,175,85,106,148,27,204,145,104,3,152,84,228,215,113,141,6,117,115,151,206,248,61,43,182,198,76,88,12,222,132,75,73,8,205,190,32,12,159,70,205,4,158,0,107,220,104,90,223,181,80,7,111,166,130,16,168,145,218,242,101,35,165,172,12,217,239,157,76,37,238,176,63,124,243,45,101,181,191,200,64,186,170,42,104,154,191,224,67,145,240,72,82,103,93,108,220,251,36,178,110,145,98,136,83,2,171,177,220,23,98,221,2,160,216,219,237,90,105,255,48,157,136,55,102,122,181,7,225,55,229,254,215,169,94,22,44,65,136,50,190,151,198,54,132,81,245,106,71,91,141,176,162,15,210,33,14,140,108,81,17,135,249,17,44,15,121,28,16,114,178,210,7,129,250,11,239,18,86,203,161,124,2,185,178,83,110,168,3,81,125,80,149,8,67,30,212,0,129,8,77,255,114,243,68,8,119,210,232,104,244,127,165,159,26,176,206,160,228,34,116,10,3,91,65,149,163,43,43,44,171,113,113,223,206,17,63,64,215,216,94,118,5,139,66,201,213,30,120,149,18,236,99,41,81,175,245,1,7,171,209,151,134,28,32,122,201,13,18,46,236,215,113,188,192,221,39,69,117,121,255,119,26,59,142,121,126,238,179,163,183,245,98,199,32,46,39,137,236,232,52,138,4,60,86,83,12,100,44,195,49,107,228,105,56,183,18,177,222,50,189,188,97,197,148,94,99,1,198,221,121,206,54,31,212,145,62,73,77,213,189,38,66,13,139,69,173,57,26,11,176,245,141,166,141,203,10,48,45,201,17,131,241,115,13,165,235,28,129,88,72,36,124,169,128,6,145,10,109,219,198,187,90,149,67,215,68,116,33,56,204,217,236,231,0,205,84,97,113,175,30,185,95,187,166,164,123,103,0,218,18,150,180,103,151,153,146,97,15,161,171,246,252,131,198,186,58,55,210,93,58,157,3,142,220,98,50,202,151,2,115,205,200,3,236,146,210,233,71,222,129,198,18,131,29,157,152,63,201,45,197,253,170,121,124,232,64,197,112,22,208,106,99,54,41,247,146,135,234,142,177,3,38,157,234,222,46,189,233,76,41,150,255,135,82,99,244,246,187,81,215,16,76,188,188,104,156,21,239,255,206,97,35,217,194,13,70,106,106,238,171,232,93,223,145,190,50,39,144,48,13,113,146,151,178,156,18,131,231,168,108,178,224,7,44,122,98,87,166,65,220,174,138,98,95,93,188,127,246,195,136,215,160,201,137,35,217,167,126,219,175,109,180,111,127,222,93,69,133,2,58,198,186,238,108,57,157,101,174,249,26,46,210,254,251,76,43,197,209,161,52,197,28,246,173,229,35,43,13,81,122,34,245,212,223,50,135,69,70,192,171,78,9,135,189,54,168,232,131,250,208,59,227,252,247,231,40,235,203,254,51,25,198,223,165,81,140,141,67,194,180,31,194,172,47,195,56,153,118,221,30,217,17,85,154,184,122,15,130,179,86,8,37,33,200,95,144,73,175,68,185,197,128,182,154,171,147,182,86,172,23,236,20,92,194,110,253,124,133,82,127,206,92,34,108,69,170,47,61,41,87,108,218,3,244,7,124,51,153,83,186,164,116,154,85,123,43,135,177,107,28,189,81,241,214,189,235,233,142,6,109,183,130,75,79,107,99,67,31,164,248,227,114,159,230,115,116,115,252,33,75,4,171,191,217,88,245,156,203,48,239,140,253,211,46,184,136,34,21,248,161,128,156,16,88,64,71,34,174,125,70,164,125,92,205,214,79,157,199,223,143,214,138,213,150,169,17,16,181,95,200,208,91,91,55,125,7,1,39,91,6,103,252,246,22,71,110,149,236,73,1,247,51,2,168,88,124,234,86,100,6,94,1,17,215,157,34,238,126,194,222,109,67,175,96,45,252,99,58,3,34,192,251,95,240,36,188,243,191,229,74,164,55,171,108,239,73,208,140,114,46,244,36,30,33,56,14,209,94,86,28,9,153,30,23,102,165,252,98,77,72,233,22,126,152,98,40,246,35,93,137,114,191,114,200,54,214,8,238,145,43,119,180,186,55,74,170,232,166,247,56,233,9,162,16,241,95,47,5,109,72,125,67,35,130,55,138,75,157,246,85,244,3,230,60,226,159,12,234,155,160,180,119,243,253,179,202,194,53,218,65,208,230,212,71,228,29,49,220,31,146,244,249,84,46,237,203,93,171,73,33,115,46,109,10,163,137,73,18,133,213,236,174,230,216,119,127,80,199,18,100,180,236,191,127,152,158,226,45,72,70,181,106,90,21,229,46,41,109,55,237,81,0,158,169,63,40,22,85,246,181,235,161,180,28,175,136,87,132,184,54,121,185,69,89,58,20,54,81,101,87,37,251,152,4,162,108,113,248,178,219,151,240,144,158,242,185,138,4,34,148,255,250,66,75,144,141,25,248,244,89,180,203,97,141,149,179,129,213,186,64,101,242,119,130,121,108,230,198,74,228,155,96,237,140,201,158,44,127,161,120,219,94,11,95,27,145,80,184,107,215,88,252,32,89,59,97,159,249,183,75,131,180,65,184,179,85,80,88,74,128,53,126,191,54,169,0,133,100,248,196,158,91,121,110,12,248,130,87,248,186,85,136,101,181,0,90,45,34,227,84,17,40,96,221,187,167,131,112,48,70,62,240,138,78,245,248,226,203,255,32,242,246,141,200,17,167,32,151,12,72,159,221,190,56,115,237,233,226,113,71,228,167,60,113,127,28,174,27,176,227,160,77,221,157,64,14,166,82,60,78,7,91,16,214,169,78,222,97,33,229,210,4,255,104,234,42,181,7,177,190,23,40,135,53,67,63,28,151,60,167,81,21,190,110,214,160,222,51,228,87,83,113,220,46,182,163,193,79,214,249,120,197,244,197,169,252,20,33,253,246,46,198,16,208,35,110,5,37,236,172,149,234,155,32,36,8,249,70,224,226,40,16,146,131,224,173,250,111,102,227,160,196,255,167,81,196,62,24,6,39,4,245,139,98,158,201,247,5,6,2,61,92,5,65,70,24,206,135,30,246,146,155,22,29,247,25,112,186,5,208,134,240,95,137,29,48,148,222,92,36,165,248,10,244,222,158,131,46,156,217,243,219,101,123,98,209,124,89,178,16,48,173,142,241,134,127,160,217,64,134,35,244,28,253,59,26,10,212,162,143,252,94,0,198,0,16,156,116,145,64,255,206,234,251,104,250,213,247,171,89,86,125,48,237,216,196,160,45,90,227,12,33,58,31,88,200,117,101,36,105,135,49,134,64,181,233,40,63,100,189,192,13,48,58,159,183,105,34,162,170,166,132,83,141,116,29,39,216,84,29,224,211,54,145,251,248,148,150,203,26,51,179,47,134,175,80,66,223,24,221,52,170,59,241,37,95,232,183,15,162,203,144,221,60,248,8,211,255,78,249,55,59,23,131,11,165,152,182,82,168,71,89,48,249,78,107,182,117,73,21,79,42,128,232,89,103,207,13,224,32,236,175,138,201,54,26,98,122,91,253,144,222,108,171,101,120,208,168,40,29,46,64,23,171,248,115,40,80,28,107,143,65,188,142,205,155,234,86,121,157,124,23,44,177,188,201,222,229,244,169,241,155,62,102,187,15,28,49,168,157,29,135,202,9,160,102,125,112,184,31,209,162,114,13,130,215,93,15,255,110,50,54,19,144,98,47,46,170,252,210,5,161,176,69,185,97,187,253,94,124,215,85,69,73,136,150,68,137,217,52,113,151,241,70,44,102,126,10,143,167,133,81,239,233,109,73,171,141,93,133,112,185,133,103,206,49,208,130,79,127,234,48,173,231,82,200,74,68,194,188,185,26,56,199,134,122,3,153,227,174,245,23,34,49,20,68,184,202,1,232,252,31,171,45,85,7,114,187,66,203,169,98,117,144,15,165,104,143,111,174,100,197,60,7,53,248,238,100,12,162,96,40,189,247,101,64,57,57,14,195,114,229,155,228,32,111,37,141,8,8,163,2,223,6,96,54,144,175,85,141,51,77,41,60,192,113,15,103,101,44,30,102,189,100,251,227,71,37,62,123,4,63,119,25,116,47,205,191,156,1,106,136,248,37,151,162,72,226,41,208,133,69,146,114,137,43,245,90,115,117,90,122,134,180,218,136,10,36,210,53,138,90,139,213,130,56,173,119,174,71,72,213,138,87,171,101,156,110,0,164,38,191,156,215,148,220,106,138,50,237,54,37,49,215,127,45,81,226,61,181,195,147,154,208,170,94,34,8,228,121,71,182,239,63,56,65,244,0,70,162,73,198,63,16,134,216,58,187,203,234,115,44,209,105,127,183,130,74,82,203,219,128,128,162,13,47,106,252,31,56,155,184,119,56,139,70,241,3,104,153,43,183,28,68,241,224,25,154,52,51,131,108,142,150,13,106,43,251,166,76,47,218,150,11,125,109,109,179,145,213,217,241,16,32,208,48,33,217,59,171,245,248,174,34,191,77,111,183,221,49,141,59,221,76,224,103,190,107,171,215,232,44,84,133,236,88,227,175,24,57,144,252,229,182,140,36,219,42,92,101,187,212,188,34,205,167,99,168,91,224,154,187,112,52,190,62,212,191,250,250,68,229,248,142,143,161,185,243,117,222,69,61,162,247,179,140,133,135,164,217,144,222,8,114,20,240,161,44,27,187,82,122,237,53,167,43,2,215,122,219,61,163,54,181,154,176,222,239,12,13,63,88,213,167,98,162,94,254,89,113,112,242,88,158,65,229,215,16,126,234,96,129,34,233,231,85,152,90,16,97,32,90,134,18,131,114,130,148,249,76,135,186,171,103,192,83,45,100,96,36,88,217,197,165,86,194,168,112,149,125,108,133,112,117,199,26,221,35,245,88,233,9,113,47,138,31,61,114,47,51,32,197,55,17,175,164,93,204,223,215,203,221,224,147,103,78,214,230,214,71,214,220,169,117,39,0,147,198,108,242,153,155,144,235,250,162,35,53,61,45,156,227,244,108,123,32,227,129,77,252,146,213,168,197,237,147,123,38,228,75,144,165,144,102,113,198,22,145,14,101,195,177,43,62,151,113,96,81,189,204,180,207,197,24,72,76,135,127,181,246,81,18,167,113,85,184,62,190,140,86,209,148,134,111,32,60,108,33,233,115,99,216,239,112,146,92,217,236,252,213,215,98,122,215,64,175,155,179,121,195,7,207,252,163,51,58,143,187,255,188,122,6,199,73,36,149,218,141,142,43,108,99,2,232,187,65,216,24,169,125,102,148,113,59,233,176,194,207,77,204,245,20,43,145,104,88,88,212,187,237,152,64,18,141,254,53,255,111,53,61,62,49,143,145,197,10,207,36,198,166,88,7,199,42,201,145,219,135,53,239,108,162,82,202,181,4,255,82,23,38,141,213,120,0,218,105,2,141,120,255,138,20,27,255,97,202,151,0,166,227,16,196,48,139,91,164,4,170,177,243,27,154,220,212,167,205,179,84,245,205,50,51,155,45,39,99,124,70,27,48,182,173,3,26,38,214,1,26,23,216,248,214,89,78,142,7,44,2,118,103,73,72,202,187,222,242,74,37,84,166,251,191,67,11,231,116,61,33,17,96,93,116,165,173,88,153,105,123,125,159,243,89,143,66,211,213,23,47,204,192,2,231,229,224,32,30,45,9,31,149,216,137,119,152,34,22,131,206,47,216,201,89,197,58,66,204,67,92,0,150,199,161,213,185,96,252,164,78,46,247,41,134,48,118,14,77,30,250,176,12,138,96,58,51,142,9,249,103,99,29,247,189,31,126,29,86,211,201,108,216,195,90,32,119,124,219,207,128,192,119,91,217,60,215,24,182,244,100,241,153,24,3,99,115,167,33,25,239,186,42,198,202,179,57,117,112,11,208,212,50,26,170,22,148,206,252,232,159,56,64,37,184,40,232,109,62,164,199,64,198,112,56,71,12,215,108,220,20,211,118,70,182,19,212,219,182,104,5,188,255,61,162,241,25,176,78,25,176,239,21,205,246,214,246,86,45,101,158,9,252,149,38,59,72,225,119,121,209,20,85,6,84,253,24,182,126,20,150,105,176,238,54,59,96,46,28,214,21,80,112,19,118,125,115,134,244,30,35,230,238,255,199,220,32,200,9,142,2,182,14,101,191,176,143,96,217,200,124,194,43,105,61,93,143,135,53,12,228,233,30,150,173,228,73,179,184,84,21,117,63,245,231,49,129,29,249,46,23,172,195,94,36,76,227,246,71,159,188,8,88,119,49,177,156,203,88,101,195,170,151,183,106,100,9,246,64,254,1,90,4,9,163,154,231,88,68,182,99,67,75,171,107,142,196,79,237,114,70,178,128,33,83,168,67,129,82,214,135,38,206,41,152,140,168,52,239,28,171,28,29,180,246,185,183,243,85,129,112,168,63,139,133,0,162,86,166,48,132,244,159,151,235,175,64,110,168,85,97,233,11,62,25,177,16,57,124,63,250,59,218,136,209,136,192,23,168,160,206,65,84,30,73,213,235,181,104,66,27,98,126,183,219,93,200,115,84,141,57,55,20,131,91,14,228,85,181,19,4,110,176,90,101,40,91,107,155,7,70,21,114,154,141,146,125,246,64,1,216,213,232,23,143,224,115,244,247,144,186,71,134,69,183,141,25,186,91,29,145,163,250,202,181,57,216,172,131,228,242,181,187,52,94,218,252,4,118,44,52,124,160,37,176,17,218,121,140,191,107,102,91,222,49,91,229,106,179,221,170,200,88,38,138,167,10,48,157,47,99,57,137,88,76,206,141,214,208,48,80,226,18,227,6,175,180,63,107,247,251,197,59,51,247,13,109,209,162,206,192,125,112,94,235,247,26,88,14,126,241,225,249,81,162,7,157,238,150,138,24,69,121,155,219,17,169,180,218,93,230,99,92,139,53,179,145,30,14,205,171,75,247,49,194,3,14,177,24,222,122,30,75,174,121,243,104,233,244,81,4,47,70,43,206,113,229,119,231,49,72,144,78,214,29,193,41,75,14,97,19,84,148,246,3,250,243,7,246,233,153,48,135,226,204,199,93,210,3,97,11,106,117,170,122,92,97,150,179,177,220,46,59,17,151,242,160,233,237,81,78,255,87,243,237,113,135,216,131,97,197,224,41,142,85,234,243,135,58,152,220,191,227,149,78,77,30,82,167,63,217,43,227,106,173,223,128,161,49,70,29,184,169,178,179,124,224,2,243,210,229,112,103,15,29,78,229,91,9,68,198,94,135,241,207,69,183,229,46,78,63,189,93,163,10,91,172,13,205,180,217,216,102,237,239,3,217,247,218,0,147,130,158,175,242,39,94,23,238,221,229,211,72,140,103,207,7,73,10,200,247,155,254,35,165,152,2,137,237,154,128,235,215,210,1,132,104,143,128,91,191,225,241,171,220,16,165,209,59,10,1,128,151,229,116,17,20,188,108,57,196,105,197,5,64,216,75,255,49,10,35,243,39,238,142,201,1,32,8,28,116,21,216,226,89,90,231,210,128,81,149,93,249,111,150,128,11,228,231,236,178,74,34,174,187,230,84,78,197,136,17,197,25,242,154,123,24,78,245,178,254,76,70,182,72,15,115,54,62,10,89,172,129,113,97,148,204,240,100,172,169,122,13,95,182,26,184,25,191,255,250,250,137,18,19,72,145,135,112,125,227,63,65,26,54,228,181,30,158,27,191,9,236,168,115,248,144,187,132,253,45,84,154,196,103,30,149,123,53,42,206,172,146,175,44,203,69,239,45,147,0,121,103,125,132,136,192,38,62,79,29,241,17,151,110,28,38,221,234,230,228,182,64,241,144,165,124,145,120,49,50,129,18,33,242,212,143,68,167,109,134,179,113,176,85,93,87,105,133,15,66,249,8,43,9,147,72,30,6,2,85,185,204,160,20,76,70,119,163,67,200,121,228,185,204,22,48,31,122,177,123,93,159,108,114,65,90,91,67,95,139,6,187,3,78,142,38,96,61,68,23,146,93,32,245,153,131,61,126,1,194,201,158,51,161,172,0,176,76,143,229,81,201,36,157,210,139,109,215,12,9,41,152,243,188,240,144,194,27,114,193,162,39,43,9,203,46,137,76,217,93,125,215,74,43,75,0,153,246,95,88,44,134,248,43,87,166,46,133,1,77,197,205,206,31,50,102,178,248,22,226,192,156,203,195,155,193,32,35,158,173,76,75,79,240,112,7,161,130,162,85,225,67,223,15,127,53,24,49,231,201,248,16,114,146,228,17,178,247,166,162,2,32,180,41,188,9,197,103,77,246,35,30,71,112,6,222,168,64,60,248,242,61,201,130,219,58,182,38,143,103,45,104,219,7,121,119,138,183,148,149,107,216,169,2,89,111,185,120,49,74,173,174,35,38,194,214,86,32,216,229,123,41,64,108,178,152,13,174,71,86,192,147,84,112,246,98,151,238,63,210,134,112,5,28,254,154,125,236,82,78,22,114,230,212,88,97,54,211,70,203,48,159,59,21,36,55,56,141,194,247,133,160,138,224,66,180,74,137,37,94,5,120,135,170,119,209,147,221,28,19,215,139,29,199,87,234,102,225,111,74,180,27,169,131,129,29,44,138,81,235,206,181,229,133,192,201,163,110,48,203,245,95,200,183,29,29,31,255,74,216,148,92,109,191,130,29,236,248,204,126,228,208,76,200,13,128,197,198,255,211,23,197,132,124,133,71,155,21,132,233,191,189,212,255,108,47,94,109,53,232,234,95,174,83,223,18,188,255,239,215,139,141,51,127,243,199,103,111,117,45,101,67,184,104,196,20,34,25,184,251,144,47,226,217,214,217,125,47,52,41,242,113,104,13,56,74,44,166,36,63,154,133,145,18,80,160,124,59,47,48,219,63,43,134,67,115,238,189,252,67,6,164,83,181,123,230,213,252,7,222,130,221,30,79,68,34,162,2,61,134,162,207,49,146,161,216,82,98,181,190,57,57,164,128,97,121,148,131,128,152,66,106,247,15,154,148,82,42,174,142,17,249,123,23,138,78,106,245,159,202,19,26,160,50,138,153,136,182,101,89,247,195,169,69,220,50,155,45,140,251,248,183,139,84,17,44,98,83,13,102,234,106,135,22,255,212,246,163,28,11,251,123,18,5,150,221,6,2,137,17,176,56,215,12,166,187,52,149,11,97,119,140,245,13,201,20,98,80,27,26,125,126,58,232,231,83,52,195,75,116,248,147,230,123,171,77,81,168,163,120,39,158,18,54,60,212,117,67,148,122,151,78,51,30,88,27,152,83,92,191,105,162,106,233,12,27,116,4,53,100,189,242,253,169,182,10,105,196,84,229,122,141,80,15,0,38,26,50,176,229,18,32,169,241,202,190,190,225,100,193,44,196,209,193,83,89,43,228,8,127,48,9,221,186,199,251,97,138,218,190,131,202,206,62,148,128,44,48,107,164,177,57,149,171,214,244,57,198,194,87,179,232,10,17,65,243,255,109,19,208,42,55,68,178,164,84,21,57,206,5,27,252,203,144,108,90,231,137,198,221,204,164,204,56,73,223,129,127,246,244,144,140,13,229,195,199,39,42,93,103,202,8,45,68,203,17,186,154,9,154,228,59,255,134,120,125,170,90,18,141,31,17,116,10,189,48,63,147,112,188,11,184,92,95,253,180,92,80,106,57,112,187,229,228,69,3,1,47,47,72,146,48,135,37,111,82,27,20,77,157,222,115,123,120,119,159,196,99,7,116,57,222,119,79,79,212,213,215,145,225,154,187,25,22,126,89,170,169,123,159,94,29,177,63,137,207,167,192,97,134,193,17,236,199,8,35,214,220,156,72,183,180,8,63,200,171,93,216,103,110,145,159,209,158,236,233,50,228,220,144,113,159,214,222,157,156,27,133,183,240,127,191,28,41,222,148,155,247,32,97,96,128,237,98,236,159,107,157,192,176,19,81,248,145,219,183,179,73,178,81,38,137,81,108,189,148,180,164,63,244,107,140,13,253,2,84,88,16,121,200,120,77,203,104,24,207,202,194,62,253,155,102,96,168,116,28,237,163,138,91,149,34,82,230,211,109,230,176,130,28,82,186,233,159,99,238,249,81,38,106,243,246,4,63,80,43,104,47,1,253,236,84,79,158,5,81,26,18,242,70,42,11,229,216,154,236,16,203,159,227,7,207,120,26,197,81,87,177,4,32,197,147,111,255,229,91,211,194,195,230,35,169,151,31,196,33,181,120,192,254,71,84,152,228,208,209,129,98,55,39,210,144,146,192,231,249,121,170,81,218,202,197,150,149,234,93,90,178,167,209,244,86,25,140,141,156,206,14,247,240,217,14,39,99,82,121,16,119,157,210,169,220,50,58,255,48,130,189,120,154,59,60,85,94,135,23,15,171,6,31,212,224,89,73,100,179,91,61,170,128,28,33,227,9,149,128,12,110,120,44,9,52,192,4,24,65,221,114,24,77,109,0,237,94,4,42,232,84,150,134,32,50,33,84,234,130,136,89,117,253,79,60,135,69,29,50,128,196,38,41,43,37,78,168,73,163,249,45,207,177,76,38,115,76,143,118,145,106,166,6,142,230,193,147,145,87,195,222,73,219,219,89,33,68,237,118,120,146,164,74,130,237,16,47,79,228,9,153,184,5,127,80,182,81,105,196,51,244,192,237,160,118,200,191,94,235,152,191,202,161,231,171,19,116,102,94,206,253,175,4,193,18,70,53,214,98,123,181,137,167,190,84,96,169,2,204,232,54,221,169,175,186,172,137,170,75,32,249,57,119,86,19,52,123,234,142,11,108,19,58,84,98,250,242,114,170,31,205,195,117,12,243,41,93,222,0,101,219,102,129,196,192,91,8,186,233,243,37,194,183,162,121,59,93,71,52,178,114,96,72,252,185,254,109,31,107,112,168,64,226,160,216,43,49,74,50,139,112,148,135,148,88,184,35,26,29,171,245,47,96,61,39,146,159,194,252,57,202,244,245,218,216,18,29,71,237,39,25,197,164,184,67,97,53,45,16,218,207,244,97,249,96,167,93,62,103,162,164,67,186,159,2,26,136,32,184,9,167,169,183,210,72,43,253,167,72,211,171,205,117,92,82,32,5,197,107,8,68,106,237,8,142,148,101,227,90,210,67,13,252,233,3,242,79,95,172,175,195,246,251,254,247,71,7,224,252,37,255,4,158,178,131,23,77,77,22,178,114,155,151,162,207,53,98,63,132,143,232,73,194,185,91,243,57,47,83,36,154,42,31,150,56,15,33,40,14,111,70,137,225,158,138,108,119,114,255,48,176,231,182,51,219,163,86,122,80,104,197,169,107,181,97,55,228,63,47,73,106,27,23,65,207,177,34,218,221,147,192,237,165,74,89,152,255,181,169,250,226,99,10,232,6,181,45,3,222,174,26,248,155,12,199,237,65,205,85,22,125,164,146,124,17,73,140,71,36,57,173,173,157,157,161,35,164,157,190,71,67,29,142,133,206,231,64,185,95,111,65,166,220,233,245,73,242,25,16,29,223,124,142,199,177,13,24,198,245,218,190,115,38,32,45,236,12,96,101,63,17,230,151,217,117,234,153,112,111,91,162,196,247,185,166,60,2,8,145,56,160,48,175,226,250,67,51,132,106,42,213,138,119,167,9,240,25,8,56,22,165,218,9,62,218,121,29,43,177,130,210,166,150,15,220,225,225,152,34,255,104,115,223,108,131,55,250,255,49,92,130,20,179,218,73,38,116,122,102,17,118,237,183,109,65,232,122,235,4,68,3,245,160,150,224,73,183,115,6,100,124,166,210,201,82,249,142,15,23,20,60,118,137,170,181,229,205,108,201,240,169,87,195,99,76,138,15,228,158,47,216,146,8,248,175,110,207,39,94,180,173,250,47,24,2,201,150,241,233,238,16,120,75,140,84,49,212,106,98,213,162,86,181,76,170,35,124,116,48,164,197,74,131,117,229,28,19,139,154,0,123,202,110,178,10,79,113,166,22,172,117,191,54,48,27,183,59,223,105,57,148,54,241,188,72,118,58,255,33,235,238,206,33,254,197,162,45,154,226,221,57,145,225,19,36,11,164,245,79,188,132,50,190,248,255,75,183,214,242,69,109,232,147,130,166,70,86,58,124,161,96,88,92,166,32,184,117,117,232,148,14,163,81,163,242,0,239,41,82,240,105,189,74,68,200,164,195,85,62,74,56,226,196,41,2,105,154,95,205,207,232,106,98,226,99,112,210,188,162,203,188,28,65,78,18,252,134,93,120,74,188,64,154,12,133,146,228,14,25,9,13,157,22,83,145,169,201,189,221,137,49,232,138,179,182,165,146,2,109,172,21,172,40,157,230,199,70,170,17,231,133,250,192,45,75,214,33,111,3,120,209,54,12,206,159,226,150,136,96,94,25,66,56,178,106,7,73,214,104,156,236,28,249,93,15,229,9,0,132,16,69,155,125,179,207,94,14,13,244,207,241,54,32,52,63,98,162,154,191,75,209,229,33,193,255,57,31,229,86,153,43,207,166,165,245,54,40,212,29,222,70,136,130,40,74,185,218,104,130,108,129,245,188,86,215,76,131,33,190,168,234,99,175,11,251,216,73,187,108,44,255,201,238,119,247,44,86,81,235,45,3,57,216,75,34,73,180,36,35,240,164,214,36,117,135,41,119,211,38,76,81,196,8,21,97,136,235,119,71,123,36,176,199,227,228,108,128,149,137,5,164,77,148,159,81,47,176,108,234,54,46,235,56,167,178,84,254,105,129,190,49,65,57,236,213,149,152,10,85,206,195,221,92,221,54,74,114,134,198,83,208,132,62,75,99,76,23,147,221,170,238,47,2,231,238,159,31,157,21,230,120,116,37,205,171,183,193,105,172,143,117,1,93,76,23,54,218,89,41,8,34,70,14,172,247,13,165,93,149,104,106,13,209,88,202,31,127,1,56,213,196,57,128,219,160,128,36,102,11,50,241,144,120,109,249,181,6,101,158,193,159,198,121,72,53,117,201,226,238,36,19,89,190,170,97,242,166,133,255,187,116,117,149,110,240,34,46,115,10,173,23,253,193,26,88,218,204,250,37,212,109,250,201,191,194,118,95,136,247,161,207,241,204,135,2,78,149,74,112,131,147,47,174,61,6,17,165,170,245,205,230,27,4,219,42,253,132,224,5,105,216,149,164,189,139,111,218,70,124,62,36,131,167,58,160,166,166,15,182,6,55,43,51,18,46,56,174,90,10,0,14,29,74,85,33,208,147,69,176,90,198,106,36,37,30,25,35,124,178,130,4,84,25,198,20,229,53,83,27,191,7,155,221,115,87,5,220,83,80,84,102,251,48,221,102,199,149,98,72,199,4,97,43,61,78,97,140,141,115,8,36,76,209,170,73,151,35,27,50,135,70,240,173,0,121,54,23,163,78,109,212,129,93,171,216,134,28,83,113,141,233,192,101,187,144,201,55,84,241,226,162,50,111,152,243,114,9,111,93,4,89,234,55,65,28,241,78,143,188,189,252,70,80,238,69,204,212,181,122,171,109,189,186,144,136,240,116,95,234,155,53,70,170,203,113,36,46,45,134,195,163,140,104,104,25,181,136,167,116,55,237,25,77,120,91,44,239,159,52,190,41,227,220,175,171,101,213,127,105,222,163,58,68,40,210,118,247,1,76,42,20,189,248,76,43,113,25,81,37,26,154,234,25,226,251,39,69,143,3,138,235,220,47,9,31,25,63,195,193,72,173,92,80,43,152,143,80,74,126,49,33,238,113,228,171,168,241,82,49,174,116,73,94,130,72,230,253,161,187,183,237,195,41,153,143,130,252,152,169,147,185,106,2,207,13,134,90,175,141,157,242,255,161,154,42,107,178,145,195,16,211,119,181,175,211,84,142,39,77,187,239,159,12,177,186,243,150,95,140,58,167,52,103,146,158,98,247,173,141,219,214,180,87,55,184,155,216,203,67,81,243,45,171,219,220,110,144,106,5,138,225,212,232,110,202,220,68,84,250,115,120,118,200,167,154,108,73,90,190,72,34,47,249,229,114,4,80,142,144,22,68,254,128,128,196,171,194,100,131,176,168,30,203,107,42,65,59,156,176,21,156,53,86,125,203,58,216,87,127,233,238,153,162,195,175,35,133,212,69,25,61,96,246,99,19,132,120,219,58,140,93,223,248,9,43,246,147,166,10,33,40,237,26,6,87,228,81,182,159,34,234,48,74,27,30,186,36,136,63,92,110,3,131,130,27,239,155,0,156,219,146,232,148,189,133,204,227,35,102,6,13,242,251,69,127,251,171,127,248,242,116,126,174,84,115,6,193,135,29,128,225,230,162,23,222,79,106,4,26,156,61,251,88,57,81,76,237,7,19,107,37,95,147,230,99,193,76,98,87,252,124,217,105,200,201,204,245,189,226,154,95,54,19,34,64,85,66,163,243,6,203,46,201,0,174,183,154,181,226,46,152,199,255,75,54,243,29,83,133,231,240,6,21,38,68,184,253,109,54,23,224,31,102,11,112,103,43,17,38,125,238,71,104,161,159,219,136,215,196,141,170,10,56,156,93,207,152,188,114,22,157,0,165,25,138,205,58,248,67,193,58,28,147,32,38,229,221,175,114,14,42,161,2,223,231,204,164,6,92,49,52,64,37,164,223,252,197,118,55,243,108,10,158,239,219,175,244,102,22,194,134,212,9,249,244,43,86,97,41,53,9,224,110,61,250,140,202,187,95,171,204,21,221,58,141,24,176,120,96,194,232,84,28,125,246,218,142,73,131,254,249,22,179,71,110,208,97,247,139,162,171,64,251,79,190,180,190,186,29,110,165,88,119,225,30,58,64,49,68,45,83,93,122,136,199,146,158,106,5,211,222,64,64,160,74,72,185,138,112,186,135,133,95,31,236,77,86,54,59,235,32,245,245,133,152,27,233,115,154,253,233,222,36,218,216,218,211,137,127,103,199,95,165,151,234,33,228,72,167,103,13,43,119,38,71,23,218,227,177,230,222,214,149,81,102,246,94,251,84,233,90,116,77,26,118,194,122,55,75,208,137,52,159,238,73,8,33,157,218,178,213,108,45,131,207,210,31,144,133,204,239,144,183,230,251,195,57,195,154,39,61,36,39,117,126,121,69,224,198,15,198,98,59,82,181,202,28,149,49,219,53,48,163,19,164,57,251,219,61,159,235,12,121,100,151,160,191,93,194,90,22,119,28,191,219,210,170,234,145,2,111,53,86,140,171,46,232,231,111,18,43,83,2,142,131,38,36,99,174,3,26,169,105,31,214,250,212,191,8,1,141,69,73,158,180,248,93,117,146,242,10,188,63,7,61,149,69,118,161,141,117,25,193,18,187,220,194,82,13,30,5,225,194,158,252,56,159,129,5,240,0,213,85,67,54,209,242,151,41,141,172,187,12,215,255,6,5,126,185,11,225,35,202,5,182,98,154,26,217,237,193,140,136,38,71,118,166,44,17,223,179,101,97,16,153,33,21,204,15,219,189,120,219,24,117,23,4,153,22,143,40,174,238,185,27,159,69,251,1,227,108,218,69,111,198,184,236,14,216,136,208,115,154,211,47,149,116,98,114,40,90,83,116,92,109,38,134,140,104,157,197,116,57,122,111,5,224,4,175,201,244,62,210,203,188,216,230,131,214,184,164,54,48,242,179,251,201,77,16,77,13,77,23,34,66,146,24,12,187,238,151,92,139,64,114,217,125,244,175,10,155,138,118,58,245,52,121,17,241,62,231,105,214,169,120,184,4,155,16,20,12,215,206,40,237,161,186,68,63,141,166,178,6,127,126,151,70,195,245,163,96,91,23,138,173,211,99,103,164,14,51,246,20,75,76,135,150,74,215,220,71,15,76,77,215,250,38,227,176,76,17,15,179,232,18,19,165,54,194,146,187,110,158,216,55,66,145,232,119,152,61,63,121,155,194,202,244,22,81,66,36,140,38,108,209,21,139,25,159,255,185,60,117,9,245,95,46,99,220,27,61,151,235,253,38,161,64,188,88,189,117,249,42,176,56,54,107,62,80,240,135,153,86,180,137,121,111,177,208,196,3,194,236,106,173,82,40,195,1,146,180,204,141,11,192,120,252,52,4,116,199,14,254,104,216,4,219,7,221,233,33,47,34,247,94,0,104,240,54,18,128,85,240,255,179,195,197,161,240,178,242,197,103,68,166,60,95,131,245,148,198,163,124,209,39,120,42,206,15,106,91,118,113,89,19,66,66,241,200,64,65,37,82,169,139,136,203,234,192,172,175,27,160,244,10,91,4,183,109,177,183,93,233,92,26,227,67,87,232,184,97,234,202,240,80,213,42,133,15,68,206,0,206,110,170,227,223,113,90,208,60,11,93,245,151,50,51,86,152,199,229,35,248,13,119,64,238,165,152,108,70,48,149,157,110,249,189,25,187,246,251,124,64,0,176,165,128,174,39,200,94,100,193,34,233,19,192,83,39,177,228,74,234,195,128,251,203,238,192,16,66,200,223,179,30,106,195,189,26,217,157,142,161,132,38,20,179,217,79,34,97,189,231,106,19,144,223,172,39,206,91,192,115,254,111,141,170,103,121,61,72,101,60,110,173,73,193,25,89,206,122,137,151,213,60,169,7,42,226,224,249,190,43,17,190,187,240,163,77,26,192,162,70,170,154,216,20,183,212,229,81,56,157,247,123,219,168,91,21,53,107,174,135,98,32,176,146,78,98,190,30,232,190,171,107,188,254,223,5,25,58,134,150,36,28,218,134,107,40,253,245,199,11,1,191,26,173,238,5,142,204,170,161,157,127,172,254,27,185,235,87,15,3,74,170,36,195,132,163,3,126,33,178,173,141,106,23,111,96,111,124,164,68,230,2,210,18,190,148,45,70,148,194,38,160,67,130,166,172,81,5,91,142,239,190,58,3,102,81,212,68,68,73,134,6,117,116,100,47,57,100,207,232,224,125,32,30,193,162,117,36,57,8,27,203,56,199,110,251,56,35,162,240,157,224,0,42,206,199,201,33,95,5,127,132,29,178,152,101,166,1,242,99,155,248,47,71,180,75,84,99,65,91,32,31,136,206,52,48,74,184,208,83,85,179,51,105,125,87,66,145,207,127,71,239,255,157,126,120,139,232,35,64,70,128,118,191,41,217,7,185,86,117,216,187,163,194,206,174,218,56,214,58,160,248,111,154,70,17,108,212,91,199,245,32,108,125,43,198,192,38,68,101,100,147,129,87,52,240,50,91,92,218,108,127,101,155,228,123,77,147,41,86,207,159,139,140,93,22,169,163,63,89,236,154,98,131,93,39,55,237,122,107,6,174,184,202,126,27,199,141,16,52,167,250,44,52,64,134,244,66,235,39,127,190,88,127,61,105,107,157,35,59,146,10,14,155,241,227,170,104,180,47,95,20,235,236,196,100,29,66,255,252,236,249,128,214,5,234,40,241,34,234,45,47,166,217,121,36,243,35,251,23,126,3,133,136,164,113,22,69,236,180,239,139,48,255,146,161,48,135,129,150,245,193,181,210,85,120,4,249,147,174,66,17,136,154,208,148,214,82,198,29,171,4,223,212,84,104,93,95,153,151,59,52,212,150,113,85,179,189,60,151,118,28,93,220,49,114,124,228,164,99,165,40,1,5,200,121,138,132,77,15,5,21,162,216,252,37,141,224,202,125,209,225,242,62,177,195,93,254,238,77,226,148,168,119,167,195,151,180,25,60,215,48,166,94,44,45,114,159,78,24,155,132,119,38,31,231,227,51,37,35,33,239,40,171,12,250,68,190,248,231,228,59,213,61,15,65,53,179,92,176,23,172,176,32,72,135,37,241,24,107,242,184,186,57,99,239,241,14,0,114,211,202,79,176,88,52,130,56,18,75,55,22,208,79,100,1,57,105,53,174,100,13,234,232,158,118,211,9,144,128,160,76,177,166,10,90,95,110,144,254,243,190,208,135,184,198,226,200,27,9,38,241,0,208,210,237,180,2,22,149,157,19,155,249,21,3,55,195,149,105,206,24,110,148,19,249,58,78,186,176,25,100,216,4,198,194,104,71,150,103,193,54,223,28,146,80,51,157,194,14,178,180,189,161,192,44,225,168,111,47,225,151,43,100,26,191,125,146,222,221,199,216,186,126,173,89,90,229,77,60,34,228,75,219,182,85,232,170,22,24,130,197,101,20,253,116,141,176,241,34,223,208,190,53,49,201,93,144,151,241,108,236,120,86,232,128,234,238,83,111,80,172,96,67,34,128,6,29,10,136,122,7,204,83,50,186,1,23,79,169,21,92,114,15,132,236,51,188,123,139,240,236,199,67,208,132,52,13,194,187,174,29,120,140,151,198,252,88,147,102,219,35,162,73,126,98,77,213,8,169,217,193,210,100,239,19,153,49,43,252,194,75,228,65,143,184,39,77,42,202,171,40,113,137,164,157,33,120,131,63,197,218,5,250,238,192,175,128,92,206,161,173,254,238,133,100,158,136,16,101,127,238,52,208,92,82,3,217,66,93,246,228,193,254,74,72,78,122,33,105,54,8,66,93,246,194,222,27,194,33,125,31,125,186,243,13,92,218,44,36,132,226,180,89,124,205,104,135,159,122,252,15,162,223,62,10,250,171,0,131,127,85,178,231,79,207,40,253,46,196,118,242,128,72,35,191,117,82,21,59,50,253,123,77,220,143,104,20,203,224,176,13,252,32,28,67,43,91,75,244,94,186,135,19,180,199,223,127,142,98,37,239,28,103,87,65,235,18,238,103,120,238,30,86,59,98,172,2,220,161,99,43,3,209,122,161,55,146,255,1,36,249,99,184,3,3,168,72,232,46,73,223,106,79,159,210,38,156,147,51,126,50,165,108,52,49,96,42,238,80,99,70,146,206,224,54,97,97,16,213,14,248,251,126,49,66,87,134,179,227,232,143,91,185,125,0,158,183,5,242,48,7,152,160,171,198,163,34,181,199,170,68,125,93,97,109,136,230,150,33,113,56,104,7,226,175,49,100,51,84,213,22,135,7,237,200,148,72,116,142,163,153,122,86,4,164,15,210,118,24,67,210,223,220,137,144,48,144,180,185,234,2,241,154,213,43,109,156,143,172,26,128,135,231,119,24,217,131,61,148,77,141,150,92,115,120,2,154,217,75,86,241,208,171,108,103,82,89,209,129,238,172,132,255,207,27,146,164,74,184,68,92,141,13,124,214,138,185,244,149,236,189,182,103,67,87,10,32,216,220,143,80,210,206,245,104,149,139,20,55,5,113,172,207,125,29,89,249,19,112,108,14,88,182,201,165,18,10,245,121,6,178,148,34,12,59,196,61,173,239,178,241,33,155,25,242,134,32,227,233,188,135,113,163,52,64,251,178,224,118,246,79,167,5,63,212,177,112,180,80,242,169,49,210,21,134,141,17,157,190,91,64,227,91,38,133,159,225,105,247,226,195,200,172,31,220,215,170,68,107,20,234,183,178,143,56,158,107,86,223,172,215,193,84,10,65,89,99,158,61,203,224,96,108,213,54,164,149,13,125,118,120,95,189,114,57,41,211,241,237,209,190,6,62,79,184,242,245,149,195,91,85,198,131,178,227,71,202,112,154,51,82,29,130,223,121,113,6,199,251,129,30,201,68,187,181,197,35,52,79,104,12,235,40,127,72,62,197,101,25,50,235,135,22,61,18,204,9,17,58,139,193,112,118,161,34,157,65,113,190,135,176,140,117,20,216,176,111,50,116,217,162,214,180,80,45,31,21,53,93,2,228,123,100,207,17,230,207,97,240,183,85,31,41,46,45,3,43,72,155,187,165,203,128,67,28,120,236,54,20,65,238,109,110,179,222,136,198,17,77,149,130,251,103,177,204,150,184,189,37,5,55,241,217,14,130,255,116,126,175,235,144,116,140,66,14,51,205,67,99,220,51,208,79,206,154,127,22,85,71,77,215,145,255,44,243,64,209,227,67,73,110,151,218,87,197,55,237,118,245,39,169,244,170,245,203,108,245,142,50,189,176,80,21,202,93,146,1,53,148,177,158,56,213,31,235,149,163,76,7,160,96,185,175,209,247,27,135,158,217,147,16,10,240,197,137,20,206,239,82,56,27,22,220,198,2,89,79,127,31,142,1,6,55,182,200,142,137,107,201,174,111,181,210,207,62,30,104,243,208,79,121,233,86,23,51,192,246,38,237,63,185,68,166,75,123,229,116,251,234,207,59,122,231,68,113,211,62,70,25,143,151,209,232,208,160,147,131,216,54,242,90,239,63,40,144,174,63,16,36,202,26,114,183,89,217,89,136,230,91,48,252,125,202,164,150,89,145,56,123,247,12,54,155,187,186,61,40,196,208,28,136,119,101,36,210,226,52,175,235,200,109,39,72,109,208,243,138,191,212,112,241,255,140,84,135,41,149,18,74,71,117,169,225,47,36,251,47,104,143,61,234,88,50,148,255,119,218,157,33,205,193,198,233,229,11,62,162,92,119,220,137,255,123,184,226,35,157,8,174,39,63,216,248,137,225,131,8,2,82,204,80,214,39,91,209,189,161,6,81,144,36,198,76,197,109,194,10,4,72,54,53,184,115,91,225,10,11,168,200,46,218,124,246,135,15,89,53,166,8,241,71,83,123,154,209,50,174,37,55,123,83,140,20,54,44,56,182,163,26,6,6,190,38,53,147,232,222,149,68,107,255,157,252,151,137,92,252,145,148,33,103,9,72,231,13,116,195,38,2,23,236,159,143,19,6,218,213,124,179,244,182,30,110,173,19,168,90,131,57,252,205,106,250,34,115,21,156,227,2,178,233,51,164,166,165,72,112,14,41,93,38,111,111,37,191,106,207,33,185,185,90,72,233,134,236,98,171,160,112,169,40,190,94,93,171,234,98,137,93,127,65,248,80,186,131,116,191,197,63,31,50,255,195,58,34,142,54,220,246,198,63,55,183,44,126,0,217,209,232,158,8,7,110,86,107,240,61,28,52,138,97,149,20,247,180,192,143,33,83,155,177,22,187,216,48,139,83,169,139,99,123,154,74,125,236,38,59,46,27,30,157,211,15,232,203,47,94,136,56,194,51,139,205,174,21,161,217,7,160,227,59,236,156,91,143,154,27,42,117,22,168,18,246,201,35,37,107,157,58,5,158,76,100,112,62,84,117,50,22,6,96,111,120,207,116,151,161,13,67,239,116,206,98,64,136,103,8,201,197,9,81,239,18,226,93,190,46,81,229,232,167,200,193,215,90,182,212,93,78,67,26,105,97,197,49,164,150,52,143,248,121,13,95,217,227,206,14,80,200,179,171,10,146,200,142,90,137,125,253,146,71,131,33,45,48,69,241,119,153,254,188,241,25,222,97,30,63,46,136,159,57,134,89,0,129,234,189,184,64,200,208,245,48,167,116,134,99,230,3,164,217,19,159,106,99,97,202,22,164,70,66,13,97,32,58,239,114,37,9,60,59,67,157,37,172,251,50,177,13,116,63,7,119,74,90,248,108,175,187,95,134,112,101,157,132,160,143,70,245,232,144,69,184,106,150,9,184,122,224,32,162,162,167,166,203,10,237,99,78,75,217,159,250,237,184,75,97,163,68,55,215,93,14,236,225,12,141,49,8,40,126,117,77,135,80,77,205,97,75,21,26,145,221,123,172,2,182,77,86,93,204,86,114,144,92,13,141,25,97,222,15,100,182,160,159,142,35,220,49,107,187,208,137,105,153,135,0,174,222,172,239,170,133,207,178,208,164,230,211,2,139,92,32,192,133,89,232,32,239,245,110,166,136,37,21,196,131,79,242,98,209,25,180,252,102,119,100,85,102,115,189,106,122,226,157,178,221,143,154,92,187,57,68,241,18,33,225,250,134,114,116,72,134,250,27,40,97,219,30,86,74,184,102,193,26,66,181,24,165,153,255,190,75,185,18,121,114,85,220,59,224,145,174,176,36,67,144,74,196,161,88,9,48,79,220,4,67,25,232,105,176,32,242,28,201,66,116,178,36,164,218,208,31,240,68,239,166,138,242,198,226,27,136,232,255,174,210,152,60,200,61,15,238,2,218,231,198,130,236,180,235,65,221,66,82,162,92,235,251,20,38,65,92,156,106,85,0,144,25,182,28,226,88,153,34,253,19,27,116,90,101,248,35,202,216,184,19,35,2,94,8,209,254,66,212,135,68,219,185,32,107,225,25,227,136,211,138,181,174,112,128,190,66,165,251,135,185,108,40,159,222,177,26,58,26,148,218,89,13,15,27,236,24,118,78,33,185,174,168,219,230,119,230,179,169,161,57,118,97,227,203,9,125,55,136,197,112,94,138,136,230,112,204,245,136,116,59,13,75,68,121,43,122,9,22,252,149,172,182,118,113,61,53,171,44,42,118,178,166,69,222,44,157,34,128,126,179,24,154,159,106,149,17,227,58,143,176,241,222,56,42,62,181,26,208,33,24,30,33,112,83,127,84,65,41,251,206,115,178,2,222,106,153,209,238,98,208,200,210,177,133,86,65,23,104,110,177,161,96,79,57,142,162,15,207,173,153,56,254,250,73,76,74,43,36,200,57,145,60,95,227,21,147,221,41,171,192,107,234,251,74,126,3,247,128,122,243,153,128,202,238,189,17,198,179,70,97,245,190,200,231,176,186,98,217,254,45,230,228,185,78,204,155,64,247,183,255,152,161,26,12,21,183,209,199,194,177,1,221,95,77,76,253,203,104,7,192,167,209,180,50,138,227,189,182,231,239,238,168,59,221,119,154,107,247,102,200,51,40,120,192,133,47,249,238,189,123,233,117,188,210,82,68,72,178,111,103,77,144,205,181,97,1,172,166,152,242,0,187,181,174,188,39,82,5,75,21,213,113,66,102,62,173,169,132,21,120,138,226,211,39,44,143,160,126,74,108,191,13,117,58,148,234,239,194,161,161,156,231,240,170,77,120,106,63,168,175,231,243,60,192,181,236,20,52,239,78,141,78,130,59,219,80,208,24,37,165,109,209,49,251,9,62,80,50,249,181,232,42,228,47,166,191,144,176,206,148,242,148,153,182,121,24,128,65,137,42,161,119,66,94,240,11,55,102,122,7,205,142,144,144,180,47,60,218,192,149,85,15,213,83,8,79,215,104,8,209,172,222,200,242,28,255,51,185,167,33,226,26,65,147,100,114,222,54,27,170,212,207,83,56,170,37,126,121,14,18,40,231,4,14,164,248,6,110,118,48,51,83,228,76,3,131,87,77,86,163,48,72,194,109,53,105,118,111,198,140,133,34,20,119,56,35,236,7,170,176,164,95,86,183,232,105,108,7,25,169,127,50,26,86,83,94,101,58,219,72,205,46,231,78,158,94,221,190,147,92,96,224,0,30,65,191,21,237,118,106,224,247,161,116,33,41,10,92,81,248,232,191,41,72,116,171,89,110,208,62,230,196,11,67,172,81,188,8,212,62,255,199,22,201,68,20,120,21,90,72,70,211,251,61,232,5,238,147,16,91,225,65,103,178,238,63,246,157,100,192,170,206,249,101,28,25,120,125,225,94,105,146,218,75,10,178,103,244,73,77,174,18,113,205,198,233,5,88,129,66,64,72,137,118,81,217,130,206,156,174,224,223,115,249,164,10,160,47,237,255,135,146,236,13,99,71,63,62,20,134,132,135,155,27,21,239,159,60,195,224,248,123,205,45,147,225,233,72,95,151,236,249,144,43,148,51,197,175,100,140,185,170,200,234,37,87,113,85,41,197,41,164,33,181,64,228,58,125,41,220,43,111,47,37,139,69,75,126,166,210,12,7,175,6,63,122,236,237,156,149,142,254,174,11,37,215,82,200,54,62,74,43,2,249,172,218,115,203,91,14,165,110,103,178,200,5,226,141,45,42,68,130,198,173,253,230,217,122,113,39,163,182,160,231,100,179,40,207,8,27,212,22,174,85,58,27,55,118,83,118,244,201,68,167,205,50,31,36,17,250,228,187,200,203,159,109,44,83,197,240,214,82,128,207,62,237,127,108,238,226,36,190,44,152,27,248,90,79,254,43,191,182,206,138,179,239,133,27,56,192,25,166,40,83,172,241,62,178,172,53,58,205,73,6,139,66,50,24,22,193,232,205,173,161,67,139,236,13,114,239,156,46,253,12,218,238,6,255,169,98,117,8,215,156,102,178,212,208,18,175,147,108,96,73,71,115,87,75,254,77,61,212,49,252,42,72,23,95,49,206,208,189,203,240,139,4,56,101,109,139,204,117,23,213,104,47,1,254,115,179,25,96,58,221,157,53,112,19,110,172,118,168,11,21,171,109,123,100,79,124,202,172,155,236,144,86,224,44,183,119,167,51,180,139,191,76,201,173,212,215,120,148,255,149,110,69,229,152,112,197,133,178,122,15,23,55,103,67,13,152,239,59,168,53,175,130,232,143,236,0,96,95,206,91,141,167,127,199,149,82,51,222,51,43,148,225,183,56,32,68,76,97,35,154,233,207,47,2,29,114,143,36,159,81,168,169,22,163,74,208,233,149,204,129,138,138,13,48,180,42,41,155,141,156,228,19,71,135,137,63,119,146,67,61,236,133,52,209,164,39,67,110,28,5,36,100,159,52,79,220,118,89,126,230,63,180,117,243,165,179,147,209,255,162,97,177,43,45,86,56,48,223,195,122,39,130,118,8,183,36,55,42,221,83,72,74,95,130,91,23,121,226,221,206,241,204,44,105,177,188,105,190,84,106,225,244,183,44,76,188,169,150,98,155,208,244,161,94,75,232,173,64,126,153,184,124,75,229,87,31,209,154,93,125,64,53,167,155,250,167,122,169,184,231,14,34,61,208,47,179,182,194,37,87,240,10,125,2,26,125,232,189,207,199,3,153,204,157,148,33,93,160,134,67,238,203,126,198,203,210,112,25,199,23,136,192,135,207,227,224,213,125,17,93,230,177,178,164,152,162,80,107,50,52,221,42,20,128,143,202,168,22,91,223,159,118,214,249,29,184,124,24,124,1,183,54,43,61,91,155,116,241,94,157,187,60,100,244,97,97,177,9,57,90,72,245,38,31,86,172,41,102,15,35,39,4,233,141,9,165,41,137,229,44,122,16,181,99,178,84,124,207,34,140,41,145,250,172,186,100,100,156,162,5,126,187,160,57,183,240,17,46,181,44,120,144,141,151,142,129,195,192,11,203,241,78,134,142,214,106,198,94,141,84,62,51,127,110,9,65,150,68,221,157,131,236,130,114,10,128,197,13,157,252,8,165,223,138,108,179,156,231,156,82,132,196,202,13,64,69,92,110,180,238,15,125,240,30,231,134,56,66,31,193,191,100,72,106,233,11,113,8,121,238,178,117,107,157,215,58,43,212,236,53,215,214,1,16,192,173,175,231,62,113,26,94,248,47,30,36,232,160,227,75,161,127,33,5,192,210,69,155,249,190,217,224,42,17,77,54,231,20,45,5,116,154,154,80,74,148,126,85,137,13,59,123,226,167,20,148,24,19,123,17,78,46,126,232,255,147,20,83,85,103,16,86,141,246,211,162,58,245,162,77,31,51,40,174,164,117,38,201,18,8,240,124,226,180,213,190,92,223,249,184,227,8,168,86,142,19,66,247,142,54,135,218,13,197,216,225,152,61,155,156,171,88,150,158,129,132,144,138,13,21,166,17,156,62,40,147,131,134,66,228,77,177,184,53,207,92,208,3,16,2,45,215,154,73,196,92,47,104,0,94,23,103,132,206,81,105,63,84,231,7,205,95,148,128,250,142,158,42,49,223,26,22,72,27,211,39,245,201,245,4,127,48,221,21,121,201,223,108,209,6,93,31,85,112,207,74,123,201,78,249,139,38,60,134,47,225,21,74,31,177,146,41,144,16,100,28,219,207,21,104,154,200,135,169,238,147,227,243,217,211,187,109,182,74,223,148,201,132,46,26,159,121,196,145,148,161,153,126,127,103,44,44,215,135,248,8,157,23,184,220,82,173,81,229,136,173,243,230,69,68,158,137,156,73,166,209,116,155,166,231,141,186,187,84,175,227,63,227,13,18,245,222,185,2,9,97,179,58,174,246,67,94,255,153,44,100,138,172,19,5,67,221,82,20,224,61,104,222,44,53,106,82,147,130,225,31,218,140,64,109,45,5,216,165,119,100,159,228,18,213,150,192,59,85,135,249,36,228,230,57,28,67,206,105,230,148,212,28,106,92,97,2,31,152,107,208,11,10,205,238,102,126,66,83,190,233,77,232,77,96,85,249,251,119,192,179,5,0,198,67,127,22,157,78,146,64,204,6,39,200,12,229,227,234,242,193,195,141,125,107,248,143,210,251,18,220,67,240,110,48,114,110,15,160,241,14,133,152,132,225,44,134,92,88,11,167,164,225,12,234,164,92,9,175,74,190,164,193,157,232,4,137,216,80,165,124,20,254,221,2,198,63,217,156,135,119,4,178,58,153,215,139,67,52,172,206,47,40,75,33,86,67,63,41,10,20,37,237,37,156,4,13,25,23,201,228,9,237,67,16,22,116,17,184,162,203,188,227,13,110,65,231,79,200,61,118,207,68,161,90,71,47,113,31,224,165,90,23,21,239,63,80,176,54,103,99,60,125,72,207,90,110,231,121,225,205,35,28,16,137,252,136,94,179,14,97,157,227,66,82,219,137,26,78,157,181,147,28,161,251,43,196,201,53,245,149,152,194,86,91,70,203,91,114,199,241,212,180,125,44,131,135,116,26,132,69,27,84,222,132,88,96,163,119,62,129,249,230,33,147,28,124,23,172,231,132,144,182,235,125,193,70,233,206,77,27,210,203,223,213,95,105,230,117,205,214,164,126,23,240,10,34,237,211,43,162,138,230,118,192,86,247,125,167,215,62,26,113,209,175,19,231,246,167,150,22,44,69,31,236,205,198,210,214,123,93,60,9,175,131,96,145,71,92,190,209,201,225,103,43,204,242,98,253,129,95,56,223,107,29,87,165,180,44,49,28,37,42,83,215,122,91,126,77,38,243,71,213,191,223,14,76,247,97,110,190,120,147,167,234,237,10,98,148,45,218,3,23,117,15,148,142,173,118,236,90,31,27,85,54,188,202,253,43,102,109,130,17,8,239,241,89,212,14,29,172,179,90,8,104,5,203,117,188,43,184,167,54,8,100,136,17,55,201,102,193,221,245,173,86,65,162,176,40,92,214,101,18,82,59,131,63,156,187,219,65,190,115,172,242,52,181,80,109,165,136,98,148,149,152,234,86,143,132,100,239,159,119,163,250,30,130,119,190,45,58,208,104,161,144,10,202,200,31,177,215,242,236,78,3,151,34,8,16,172,231,112,71,159,168,32,208,230,50,84,234,214,40,92,65,60,148,117,76,216,111,91,121,177,66,86,123,55,54,126,46,118,241,103,105,245,89,242,0,0,166,87,7,145,164,227,90,30,10,4,88,64,114,70,127,14,161,218,198,16,35,230,115,54,65,108,190,175,186,252,79,33,24,82,118,130,249,181,253,61,28,154,77,227,209,111,63,61,68,223,162,41,90,176,37,114,169,199,77,160,219,199,22,79,240,212,158,243,217,226,74,158,215,193,166,204,82,135,0,106,12,155,150,113,241,197,33,205,6,16,19,118,164,194,115,243,112,162,251,134,203,122,124,61,242,68,140,200,131,168,172,123,48,70,132,227,199,3,196,130,48,55,231,64,216,195,86,36,160,233,137,145,108,224,93,218,61,107,191,138,171,13,215,212,65,223,117,85,120,109,207,141,12,23,221,175,68,130,129,185,138,67,225,85,127,85,215,75,146,79,69,133,10,129,210,51,71,147,116,11,104,76,194,87,78,137,12,108,185,53,10,210,35,135,33,203,224,96,175,47,98,138,83,60,163,16,100,51,21,186,245,7,153,128,164,73,27,189,195,13,61,255,96,12,174,169,37,39,235,177,224,137,71,128,240,63,137,238,255,68,185,212,135,190,156,240,184,158,113,210,241,119,224,63,177,236,63,172,135,117,74,27,187,227,253,246,222,134,197,251,197,243,107,188,160,85,252,111,4,141,195,243,91,73,226,144,131,109,136,10,172,209,186,95,172,96,107,43,22,44,176,226,122,100,50,28,65,163,62,235,88,16,254,97,48,250,64,155,101,21,83,64,255,189,98,142,60,20,184,3,54,87,20,50,178,254,138,105,53,169,141,5,88,57,244,207,138,191,208,185,54,87,134,70,182,197,77,248,201,118,133,148,231,106,241,215,91,61,184,61,250,9,140,91,66,203,141,93,171,166,65,183,29,234,196,85,230,194,177,148,240,126,71,14,92,212,2,120,179,141,11,42,166,15,45,196,187,30,249,247,104,244,5,25,126,208,252,253,157,224,36,138,145,222,221,213,15,204,112,217,50,193,215,194,2,248,214,48,43,229,7,204,79,218,223,82,137,114,228,41,220,68,157,35,245,242,213,255,141,189,192,243,63,72,119,222,107,252,230,192,211,47,186,209,144,213,221,185,22,152,208,54,130,76,100,242,54,210,211,40,29,189,40,7,183,252,209,130,240,76,107,14,110,35,151,57,0,187,180,78,210,153,198,18,212,33,205,72,211,89,150,175,136,7,138,13,18,93,226,93,52,171,126,188,165,113,29,15,231,234,11,67,54,164,115,158,58,48,20,202,65,198,247,224,202,190,45,10,153,146,148,150,218,67,157,27,190,197,15,182,135,56,130,43,203,209,174,134,100,81,179,58,182,229,1,155,224,135,148,214,99,38,92,212,220,49,17,170,248,161,123,88,92,5,119,19,210,149,12,254,121,21,140,38,10,247,25,4,22,186,68,1,211,221,109,182,103,137,4,242,129,66,67,138,61,50,131,83,208,81,53,132,36,86,63,33,62,142,250,210,195,68,246,210,84,77,150,182,48,140,129,1,24,195,122,107,160,22,129,227,250,27,102,21,127,52,229,47,19,58,21,47,132,85,233,11,183,119,3,54,223,94,30,168,153,3,202,62,170,29,46,235,105,186,122,192,71,128,73,149,47,98,46,122,34,64,101,76,177,160,154,47,174,96,118,108,73,203,121,15,19,101,72,99,177,70,118,219,124,182,128,41,154,76,22,204,166,120,224,174,35,27,29,63,8,248,217,183,247,192,11,141,178,28,4,184,73,111,64,221,65,220,21,145,34,163,79,94,28,225,40,146,182,182,2,244,18,250,136,64,65,3,121,52,149,19,150,105,221,244,244,247,77,249,155,100,216,128,178,170,122,153,140,221,2,88,211,227,255,108,191,91,6,185,100,148,31,75,245,179,229,46,107,30,214,20,93,198,142,86,108,83,131,235,38,107,38,203,229,248,160,22,216,41,215,22,55,59,211,156,38,76,79,202,176,49,88,161,162,206,46,81,83,200,99,138,117,40,110,2,84,142,165,212,63,185,183,35,165,96,218,110,177,40,36,21,19,181,76,171,145,175,144,249,115,42,97,99,152,49,128,122,54,8,136,236,196,46,137,181,211,218,83,112,177,64,193,136,89,220,176,221,204,172,174,154,77,96,166,191,132,59,141,90,169,6,46,45,84,193,160,209,49,6,199,255,3,129,73,146,92,31,226,30,164,12,7,148,241,217,3,113,226,199,81,146,95,141,45,176,205,253,233,128,78,74,123,244,138,154,234,99,11,241,18,251,174,123,196,122,254,82,210,2,90,216,87,97,38,253,160,197,255,134,152,168,162,17,72,133,41,122,235,85,154,133,172,162,240,103,107,149,216,192,182,55,27,163,94,52,129,61,154,61,11,135,223,222,154,217,53,135,124,181,120,2,41,107,239,28,32,232,45,27,51,86,176,14,7,40,249,170,100,67,101,131,23,151,200,74,151,82,184,146,40,7,64,240,146,253,80,218,150,108,16,186,224,225,98,8,166,177,252,0,35,95,107,137,80,130,116,129,161,149,37,52,149,240,167,11,50,129,134,80,126,16,233,201,206,97,186,68,205,245,254,241,139,20,5,89,162,39,98,188,107,186,119,233,101,250,245,150,241,120,191,39,29,12,121,31,198,242,252,230,85,160,112,172,171,128,29,103,65,246,39,126,74,92,140,142,56,181,82,101,195,59,71,4,8,9,42,98,180,136,41,26,56,252,4,230,102,239,251,161,183,106,22,54,238,250,59,61,243,9,189,77,195,254,119,234,124,186,211,5,26,88,176,159,87,101,242,100,179,102,218,39,85,82,118,109,146,144,225,73,28,78,77,189,135,29,192,12,95,153,113,248,50,171,113,241,189,121,194,155,247,109,70,124,72,61,27,79,56,185,218,51,155,130,98,183,1,100,60,85,55,160,158,110,41,58,63,216,176,49,228,195,87,118,254,105,223,41,138,84,41,78,214,111,49,206,175,91,190,57,25,68,120,22,127,85,81,202,226,197,123,156,169,249,12,182,148,31,115,211,146,41,208,248,249,197,188,103,47,138,8,117,43,130,28,28,102,44,149,38,221,176,211,11,76,148,186,176,252,87,62,69,3,88,80,123,168,196,245,128,224,186,224,99,220,46,237,181,88,159,161,175,204,237,160,154,13,131,12,99,88,171,231,111,242,238,194,193,15,3,254,152,148,114,131,215,216,106,245,73,197,176,147,149,25,185,200,252,52,225,236,86,240,34,22,76,102,243,132,148,11,204,125,58,185,37,184,188,4,169,89,249,104,232,254,3,96,102,68,177,242,8,251,188,177,100,48,1,248,177,185,181,108,161,130,117,35,229,28,94,131,105,31,242,158,200,167,63,124,21,55,142,139,10,202,5,82,209,8,37,48,22,47,237,174,182,254,11,32,46,255,142,78,113,207,192,187,172,174,16,156,90,26,138,142,57,129,2,59,148,175,197,194,242,205,81,57,214,199,206,60,204,225,254,113,28,148,222,242,209,101,104,98,108,237,223,49,114,212,129,78,146,78,208,40,162,230,188,127,198,195,47,15,146,82,173,159,186,217,133,148,237,194,5,33,102,245,90,65,8,165,35,12,231,205,62,97,232,36,7,127,30,119,233,149,99,221,178,173,102,226,168,250,196,60,181,5,125,126,243,158,64,110,37,30,195,162,229,136,241,198,229,105,88,85,49,14,96,84,216,55,253,53,92,172,24,38,54,35,37,50,118,149,84,244,199,203,56,87,218,44,100,7,25,135,147,55,101,115,200,99,37,8,239,72,221,30,76,8,86,146,55,44,91,241,31,111,230,90,185,168,144,245,50,43,46,238,33,229,223,34,244,14,118,219,103,141,110,249,21,49,255,202,251,214,126,66,144,34,95,94,195,240,131,109,100,123,73,158,69,82,217,206,59,169,190,31,185,211,83,88,73,74,185,229,228,147,57,21,198,39,234,143,84,167,170,144,247,206,56,43,55,104,193,157,220,89,125,173,151,17,4,10,18,124,244,41,133,194,59,11,202,98,174,212,26,19,95,71,26,82,242,133,85,125,4,131,36,108,37,250,255,99,63,15,53,173,129,255,175,83,105,132,142,35,4,243,133,67,237,220,88,25,169,219,83,229,33,83,46,251,0,111,226,87,41,226,98,245,208,93,251,94,207,210,41,146,56,119,137,32,0,61,212,6,161,219,144,112,202,88,124,132,83,197,240,185,196,152,34,202,136,59,198,165,5,136,11,246,158,60,3,176,105,203,207,70,162,187,45,160,39,60,82,115,113,239,37,166,188,235,215,222,227,65,73,188,70,178,98,215,247,7,12,10,4,216,139,202,178,125,231,103,79,61,127,58,10,202,75,42,107,139,214,172,4,14,3,23,73,247,52,158,78,61,218,235,79,191,182,70,127,157,34,208,242,177,248,153,110,42,50,168,186,212,159,202,174,245,161,60,197,47,221,200,111,195,231,35,136,145,196,62,119,52,247,41,50,41,64,94,231,136,149,213,174,127,157,61,143,47,166,152,59,245,186,16,70,32,201,49,239,157,90,225,122,138,88,158,93,59,121,246,69,151,25,182,189,199,100,74,131,123,99,103,185,138,240,169,255,83,8,240,13,159,156,5,223,181,247,243,244,179,90,207,159,36,69,34,174,29,39,12,198,108,220,130,2,10,203,188,206,67,116,209,27,67,170,198,93,113,250,14,198,254,196,37,146,198,0,245,162,19,196,105,30,136,94,211,48,61,213,53,160,236,102,140,240,236,1,246,124,73,73,184,88,243,157,125,154,77,39,104,111,1,205,78,22,233,44,37,253,92,198,51,8,211,150,43,192,106,122,208,21,123,140,14,148,222,144,217,194,15,242,120,80,45,66,71,74,147,132,37,185,45,165,41,76,166,143,130,134,3,4,15,104,214,102,179,162,238,195,200,235,20,223,172,249,110,37,43,216,136,128,232,235,48,215,2,250,173,82,109,146,30,125,217,231,73,206,65,2,40,45,35,163,248,230,102,19,67,102,0,76,64,7,130,23,167,105,28,152,26,73,234,15,36,35,231,146,205,50,217,164,199,154,192,15,19,80,26,30,181,14,197,12,131,88,61,140,86,85,233,182,210,78,143,77,63,177,30,176,10,224,14,137,130,162,84,191,108,227,75,85,115,237,159,119,222,168,131,18,13,22,92,110,176,134,71,180,31,116,154,111,4,116,74,59,2,191,75,114,181,184,238,106,236,202,251,63,247,48,35,155,172,61,122,174,26,38,3,176,42,15,71,195,153,55,66,191,33,169,177,220,36,95,177,66,86,173,31,180,219,166,178,139,120,139,67,88,25,238,233,169,169,111,163,217,54,29,44,34,138,236,199,35,50,82,214,30,125,91,25,222,65,137,125,96,232,78,167,209,68,71,70,1,22,163,34,202,200,71,113,235,157,41,14,32,110,171,235,197,174,10,51,158,251,44,98,199,201,196,168,50,201,99,205,245,153,75,169,17,143,154,52,222,138,28,173,86,92,134,115,136,220,131,85,171,122,218,117,190,117,143,79,26,121,10,50,45,80,241,33,4,253,140,1,159,201,105,123,35,133,81,59,236,16,238,109,215,10,124,211,64,112,180,147,203,106,142,69,97,205,162,177,217,151,174,189,239,69,50,30,166,238,219,120,79,225,197,121,127,91,215,89,102,17,39,158,213,94,164,254,49,125,216,191,222,90,38,224,214,242,60,2,38,241,139,218,34,185,186,30,206,33,43,38,242,81,191,12,1,200,96,167,125,197,194,127,129,244,184,30,74,74,196,174,229,224,226,124,52,137,122,146,108,187,169,127,72,111,131,243,79,149,236,134,103,137,212,161,44,61,183,188,103,150,96,95,88,187,167,31,213,185,63,128,70,10,58,47,69,155,112,231,242,129,19,78,116,74,152,85,44,128,199,241,148,56,48,27,194,180,191,35,170,227,179,166,110,172,88,208,185,53,153,120,109,155,216,205,172,159,59,191,94,49,209,213,90,125,246,132,153,163,89,50,28,91,141,185,11,4,229,210,18,79,36,117,191,90,231,97,92,89,193,98,201,7,9,252,3,100,157,87,134,164,29,218,54,7,117,232,97,226,74,185,43,135,78,199,151,206,137,157,244,201,49,137,164,23,115,134,121,92,128,224,192,100,154,252,124,146,17,129,44,130,237,65,159,194,35,88,56,132,29,163,200,91,112,118,35,100,76,112,87,180,233,171,69,124,62,161,232,54,66,129,248,193,47,232,197,143,236,112,36,132,61,97,179,231,60,124,4,220,161,114,16,84,196,143,200,58,98,2,255,8,3,222,42,146,204,234,68,199,78,202,173,32,215,30,242,64,32,250,49,111,31,174,191,209,40,51,55,101,12,137,212,116,140,72,132,52,104,204,245,218,122,29,236,175,188,112,137,112,129,225,22,84,118,55,75,104,13,207,51,243,102,148,120,49,86,192,53,173,30,143,161,0,187,160,141,185,32,104,37,221,242,44,29,27,162,135,12,4,205,239,98,8,217,237,81,207,29,240,169,209,6,80,56,120,99,193,90,244,235,14,45,162,130,224,62,152,96,147,9,238,188,49,82,151,207,8,240,126,39,228,192,121,199,227,52,238,238,69,130,134,174,90,34,126,176,133,63,234,79,219,126,186,224,106,183,242,244,90,180,161,17,110,155,66,109,222,205,83,121,103,49,85,234,220,198,98,67,0,50,194,21,182,193,118,19,220,4,173,96,221,203,40,186,232,98,162,37,12,169,225,26,229,12,71,121,194,162,100,159,139,30,0,151,86,14,131,219,129,154,212,170,79,126,26,171,90,92,239,0,106,79,97,213,183,128,12,238,216,30,67,114,73,64,191,22,179,225,12,252,220,234,87,55,51,145,66,34,63,168,252,148,87,47,176,54,228,85,152,226,61,198,41,76,94,182,131,134,142,127,97,14,232,78,147,107,91,23,55,184,220,0,132,128,230,214,41,253,146,45,59,69,244,78,228,127,47,234,235,212,197,152,203,251,16,167,93,153,46,245,207,238,82,246,96,131,4,123,250,67,9,15,63,198,214,205,18,51,223,238,190,104,69,185,188,1,61,168,132,22,21,224,86,237,119,49,15,228,241,216,161,180,19,252,22,109,144,133,49,21,97,145,73,250,32,160,0,103,179,235,69,26,206,44,140,184,97,110,167,21,84,228,112,18,154,24,41,60,232,190,168,43,72,248,82,221,13,138,79,89,140,122,61,117,232,17,75,243,217,88,218,235,50,96,182,174,230,168,249,99,90,3,240,143,171,128,49,247,62,32,242,216,73,239,88,172,30,77,172,78,40,138,46,152,178,103,92,139,57,224,167,208,14,63,245,78,69,235,225,103,133,134,96,22,32,104,77,117,153,192,206,38,183,221,117,253,207,240,211,16,89,105,251,119,74,144,222,156,150,154,58,135,38,58,165,24,125,4,181,205,243,117,226,156,243,80,70,66,176,146,37,197,55,215,99,87,148,92,191,170,198,29,60,48,57,132,232,226,100,191,28,143,184,235,205,69,47,243,18,71,89,96,148,5,68,98,120,4,46,222,166,248,156,123,31,13,147,244,29,153,133,248,130,207,112,2,139,131,49,115,58,120,121,244,170,19,97,201,192,75,161,137,127,83,157,78,253,58,222,224,220,83,182,11,236,101,153,140,34,113,36,254,143,112,151,78,23,46,155,32,170,178,239,64,77,243,128,127,240,27,82,213,68,205,87,27,42,124,75,156,9,234,4,161,210,181,7,140,130,78,31,105,100,208,169,223,62,105,229,132,50,56,128,226,5,184,254,213,116,54,2,93,233,67,132,34,39,179,133,27,209,227,163,127,21,38,10,175,140,28,114,70,190,173,123,166,31,176,23,83,27,2,64,147,250,217,95,1,100,211,238,42,151,65,188,182,234,61,134,64,31,245,14,173,167,214,244,223,242,182,230,208,180,241,228,142,135,251,1,188,189,100,175,18,181,117,35,14,102,136,20,208,168,235,41,228,102,112,204,114,197,137,63,144,1,174,122,8,52,194,119,247,169,229,16,103,124,105,126,128,30,165,102,132,107,24,55,253,220,212,101,202,129,150,144,2,88,195,9,152,160,243,97,168,80,228,18,168,79,186,193,151,206,197,164,32,6,58,126,128,178,154,122,20,188,81,123,96,6,46,214,149,107,24,177,129,255,208,247,29,66,228,212,126,81,168,1,76,131,174,108,141,122,248,24,107,113,170,68,235,117,129,83,56,163,148,130,79,104,185,22,138,198,242,77,180,102,47,117,225,233,90,16,225,8,163,241,112,173,15,227,176,197,136,139,114,202,96,151,63,60,96,154,107,17,147,224,206,248,93,53,106,235,229,60,87,165,173,67,60,192,40,25,38,154,183,128,195,41,187,21,254,166,61,76,158,20,29,63,194,131,191,180,111,32,193,245,193,122,94,224,84,142,94,172,150,192,219,151,49,107,61,164,252,204,72,119,227,21,253,120,84,60,176,113,224,172,24,196,92,64,19,6,114,3,127,121,48,40,3,60,52,74,110,225,56,14,140,23,179,58,129,206,230,166,25,190,123,31,5,201,50,253,204,94,174,116,91,166,97,216,90,145,201,152,88,164,18,19,17,202,204,251,146,159,61,233,43,209,63,240,241,168,94,78,86,211,0,62,97,12,204,199,62,218,65,64,9,170,91,210,0,191,56,249,81,51,140,84,246,229,192,59,27,87,104,195,108,174,216,168,188,98,234,57,57,162,193,13,190,155,45,124,40,58,32,99,14,179,68,39,112,92,159,159,36,201,2,226,129,171,120,102,185,148,114,152,162,196,181,56,69,182,37,197,98,228,38,41,142,10,57,84,197,160,183,210,236,9,42,214,224,63,62,31,118,26,251,177,236,185,210,104,244,19,251,195,113,141,34,50,255,204,42,56,117,66,203,139,249,119,14,28,203,175,32,42,245,180,104,11,154,25,127,248,60,200,28,180,91,39,244,161,108,240,140,189,72,32,119,76,235,30,100,46,74,250,110,234,232,192,243,51,124,39,251,186,123,64,23,149,105,161,56,180,49,163,245,34,42,187,145,64,13,82,135,95,186,146,44,214,135,104,194,94,110,93,178,242,130,21,226,63,156,184,127,204,241,167,193,180,9,237,106,90,105,165,19,198,246,140,189,35,66,77,27,170,145,237,170,99,161,189,234,238,51,219,82,212,214,32,43,128,193,45,163,2,216,44,192,84,104,92,99,93,116,94,163,255,90,174,176,184,147,127,46,68,22,63,23,62,151,173,125,237,52,101,54,144,205,184,145,103,197,86,53,11,127,158,118,175,217,13,86,251,47,11,230,181,185,174,212,134,254,17,229,174,154,246,87,107,230,55,252,104,84,104,251,201,66,110,183,24,71,54,10,178,175,12,182,18,163,73,203,244,85,216,175,129,81,60,17,112,71,155,136,34,122,134,137,245,172,152,64,127,55,97,0,148,116,138,88,45,172,16,250,169,10,55,168,155,249,246,117,74,112,183,220,144,84,127,245,255,79,75,162,219,9,150,235,53,199,122,194,58,198,192,83,66,183,114,7,36,198,143,179,218,40,178,248,218,185,108,140,103,50,91,31,235,191,230,109,62,140,189,224,31,241,31,255,48,167,106,18,242,164,95,24,208,232,159,107,188,95,66,187,61,92,245,43,201,191,135,1,41,19,255,103,156,115,9,219,112,48,74,62,113,152,120,196,200,133,105,206,67,75,26,102,159,159,237,244,74,119,46,70,217,24,102,5,82,212,11,224,67,44,241,148,125,122,140,30,141,56,185,122,202,228,228,152,203,143,221,92,116,168,69,113,89,106,187,215,201,255,151,132,143,105,97,52,138,102,179,146,194,72,5,11,142,16,31,119,218,54,11,45,117,143,78,191,169,116,115,101,231,67,196,81,203,175,126,36,74,3,153,52,15,176,118,87,2,10,235,166,166,25,217,24,97,56,174,121,208,62,83,81,159,25,1,81,67,213,89,71,34,140,83,221,7,159,118,96,172,176,235,249,185,28,97,166,17,64,245,165,23,63,251,128,105,12,76,148,92,91,188,236,238,25,184,58,203,60,22,171,192,183,224,144,158,173,39,61,188,92,76,155,181,102,5,187,207,150,94,58,3,250,36,236,210,151,254,24,164,165,111,28,108,229,47,22,146,124,12,137,148,24,184,174,127,13,247,114,83,177,100,178,209,116,247,77,184,99,249,116,52,90,208,48,242,239,23,251,172,248,54,133,62,24,240,90,110,209,64,19,65,231,127,36,40,74,61,89,232,108,40,133,183,241,255,164,20,180,249,37,233,11,144,123,198,10,134,56,30,115,232,181,188,113,167,11,26,133,132,207,13,144,114,236,85,141,70,151,42,10,176,211,160,243,33,210,57,247,197,33,32,215,207,152,153,82,222,95,87,217,232,251,9,157,52,92,92,186,221,244,36,132,244,171,126,222,212,178,213,118,239,52,68,215,228,157,37,229,77,151,40,95,205,177,209,250,59,223,193,65,135,147,161,220,60,30,20,221,12,251,251,237,115,218,76,211,222,227,113,244,133,150,144,25,141,230,202,17,219,118,142,8,254,249,111,8,74,66,92,214,206,5,252,176,47,65,208,174,127,25,182,208,254,125,215,136,104,95,122,148,47,160,24,171,217,115,108,36,46,111,121,54,209,200,78,201,242,47,82,146,153,116,84,30,151,175,199,2,189,89,106,30,113,219,11,101,233,191,165,1,168,238,15,156,187,76,114,205,125,10,232,251,59,152,234,16,241,125,111,195,40,170,83,198,62,219,137,128,20,195,25,33,235,77,95,39,151,116,175,239,44,250,171,84,173,154,211,23,212,157,160,162,208,164,16,244,147,14,14,17,6,104,150,53,108,250,78,227,27,137,22,252,98,238,175,243,37,70,13,183,79,164,152,113,101,78,244,30,197,103,210,103,214,38,156,171,0,17,21,28,178,30,168,20,31,200,208,51,52,113,15,151,103,235,237,40,10,81,34,216,193,173,182,231,138,223,70,74,110,140,135,128,67,193,157,182,109,142,223,157,163,206,148,192,228,100,183,148,130,219,246,217,18,184,83,27,227,178,40,188,85,136,45,33,244,69,87,159,128,40,97,108,157,0,46,148,60,23,222,235,38,205,188,53,18,244,187,182,168,183,237,144,27,24,195,130,65,220,216,15,20,137,249,27,41,218,232,246,197,92,106,119,80,113,188,192,30,233,34,219,39,146,187,114,27,18,165,104,236,249,38,44,105,166,205,230,49,128,243,36,251,113,40,38,25,215,224,120,27,235,159,12,92,34,87,109,158,74,60,6,136,178,187,38,91,137,86,88,121,201,214,195,151,83,64,228,135,143,158,147,97,176,188,111,251,247,113,197,192,23,113,9,177,188,15,65,193,111,153,189,107,45,251,63,75,15,75,144,12,21,147,41,0,174,131,76,50,32,230,156,172,12,21,217,99,174,122,176,90,142,255,218,205,218,102,252,254,211,225,2,68,190,66,50,226,64,173,14,103,174,112,42,47,226,144,59,125,110,69,123,255,9,156,24,136,238,168,115,76,198,25,170,142,181,178,27,82,125,25,38,98,50,248,232,139,82,51,79,162,74,26,73,204,26,40,13,40,2,73,96,105,177,92,99,35,99,110,56,185,105,177,205,31,100,153,114,150,60,150,252,43,129,210,116,71,159,252,129,54,152,242,65,180,226,15,50,224,127,124,175,143,91,38,46,62,8,22,59,186,178,38,77,246,103,48,216,212,109,56,156,174,127,24,51,123,161,249,178,142,219,27,68,158,78,254,94,242,73,34,240,204,200,93,216,7,25,228,165,205,3,19,2,181,77,104,175,11,217,230,194,135,111,69,253,161,56,50,214,192,155,137,146,17,189,167,202,57,121,74,241,142,45,201,161,154,57,125,92,44,130,241,88,74,115,124,14,144,36,13,187,40,11,139,4,59,158,157,206,13,92,151,135,1,219,94,61,152,173,99,202,240,172,225,103,253,248,69,184,171,34,33,169,218,245,125,15,58,199,178,40,202,80,134,75,170,110,92,65,6,58,200,15,51,116,102,229,188,24,164,185,80,221,62,235,227,1,238,159,158,44,47,211,248,136,211,153,57,241,104,231,90,19,39,187,253,118,187,69,91,208,213,90,157,249,110,157,246,186,4,46,212,11,235,27,55,22,236,16,139,224,123,76,76,174,18,156,21,2,25,59,83,147,157,186,202,18,243,139,77,192,205,43,11,67,231,130,169,53,171,6,241,244,138,2,96,125,93,209,194,120,187,162,104,129,237,118,242,149,94,212,207,222,141,202,202,204,103,231,34,132,92,157,95,239,176,202,195,185,87,154,63,219,10,215,8,146,73,190,222,17,110,27,90,35,66,27,93,191,17,12,120,158,138,224,58,68,152,169,243,48,157,252,163,132,148,157,222,184,145,161,202,141,123,93,61,82,14,213,82,53,66,165,100,215,10,77,207,216,139,35,208,176,63,63,80,219,7,147,222,36,12,252,16,92,225,56,96,70,218,129,99,205,25,99,208,253,109,43,104,153,0,224,39,192,163,67,138,85,157,8,128,148,197,89,194,87,99,206,81,141,47,214,217,156,211,187,184,220,33,32,20,31,143,48,136,147,54,141,147,129,53,91,215,115,208,74,187,36,225,92,30,238,23,79,195,80,124,161,28,40,129,212,156,128,13,94,16,64,122,47,166,181,116,236,218,16,106,162,20,12,250,106,59,75,168,173,41,229,75,239,230,135,79,240,61,106,144,243,222,80,207,8,155,238,226,204,246,25,2,83,116,227,42,121,189,61,88,237,200,221,66,111,84,209,44,204,5,74,21,249,236,194,187,52,103,164,109,114,191,27,0,240,99,60,253,103,92,69,90,87,109,109,138,61,171,55,129,98,152,62,65,82,93,47,130,95,171,12,145,48,243,4,220,47,118,144,188,144,153,224,242,141,144,94,218,128,144,77,106,98,182,215,118,91,73,238,22,122,110,3,109,89,91,34,0,57,72,86,228,158,153,209,235,58,200,213,223,68,254,49,210,128,11,87,0,207,25,93,183,141,193,9,142,11,15,213,209,90,220,249,117,222,163,188,42,116,162,111,235,175,70,29,243,205,184,46,214,112,219,68,27,190,37,228,13,196,98,127,58,220,90,248,241,41,128,82,170,102,78,72,99,103,47,49,238,210,203,217,40,130,83,98,143,81,119,52,173,166,24,234,61,253,11,147,118,189,128,69,161,207,122,161,251,67,139,246,0,44,109,95,241,166,224,177,225,201,10,38,201,24,44,192,55,22,191,109,159,167,39,67,213,33,100,6,197,183,223,105,223,51,37,21,232,53,7,12,64,243,13,77,22,76,175,156,127,201,50,147,144,135,179,71,59,88,161,195,29,23,213,184,66,77,202,54,134,198,21,205,74,59,68,197,2,150,28,192,219,164,192,158,231,193,240,26,176,33,136,97,129,95,91,76,114,79,86,97,220,135,80,233,39,150,150,27,223,206,160,84,151,120,226,45,231,200,167,121,200,46,1,132,39,112,88,96,85,173,249,29,67,46,208,224,131,84,81,64,218,16,15,12,243,215,86,157,212,204,147,221,26,11,10,114,75,9,240,8,16,58,152,196,219,149,51,8,94,225,203,7,157,156,249,220,220,207,80,128,47,103,189,58,38,83,183,122,51,230,254,146,160,37,235,226,233,55,164,177,33,246,224,67,54,25,126,27,216,100,83,102,46,231,99,215,206,57,243,30,174,54,153,209,116,17,156,121,215,104,69,33,59,37,187,95,75,158,233,68,148,64,236,174,32,201,143,189,99,126,50,216,65,155,184,98,84,102,243,47,178,99,59,227,198,213,53,206,39,35,180,9,162,212,58,190,48,80,234,176,124,165,130,234,100,117,5,245,122,210,159,134,31,165,144,196,154,81,131,130,236,180,4,23,225,45,144,92,99,117,71,130,142,141,103,81,168,211,2,123,203,171,59,133,24,46,169,116,160,216,233,44,215,66,201,119,51,58,75,50,68,116,127,170,113,129,55,193,109,155,237,246,191,189,150,135,24,5,204,65,201,86,15,202,87,40,122,227,52,245,82,182,54,65,104,165,101,190,208,117,246,203,163,168,171,35,67,186,170,221,100,63,0,206,157,229,28,237,147,132,88,91,215,64,64,22,48,88,246,232,140,146,211,199,110,230,207,238,78,66,78,104,253,244,227,114,94,210,30,6,33,43,1,110,176,2,156,178,126,202,213,183,124,213,218,56,96,100,54,192,53,69,60,180,73,48,142,15,85,251,191,216,147,246,47,251,203,203,138,14,174,9,73,186,102,220,0,200,22,56,137,234,117,155,105,229,151,192,129,193,93,234,222,103,57,195,107,240,92,18,180,41,23,23,255,255,135,26,222,109,47,129,205,129,52,192,82,153,195,24,72,58,156,127,159,210,114,67,196,173,239,17,84,216,115,57,151,70,218,133,179,61,149,175,160,128,222,103,91,202,239,92,198,173,251,58,186,236,105,215,23,167,254,58,4,21,22,17,213,211,230,47,195,183,154,245,187,224,165,236,107,184,195,149,49,79,138,158,97,201,64,138,145,249,37,253,56,175,148,83,197,74,69,186,47,38,63,14,241,224,30,52,152,74,163,144,190,253,92,176,164,109,217,165,118,19,56,214,162,10,193,213,18,95,72,55,150,22,199,50,196,111,155,204,32,122,25,68,234,156,43,178,92,160,204,83,138,2,184,248,7,132,201,144,69,176,216,12,49,175,55,89,163,91,23,159,27,226,183,111,153,13,35,140,237,237,170,126,119,171,55,105,81,53,55,142,131,46,39,136,83,145,158,216,192,73,71,22,117,124,243,85,81,130,52,28,216,143,226,153,141,3,162,141,249,125,8,119,27,65,133,135,123,117,71,161,45,130,255,194,160,178,21,123,106,105,199,3,146,205,115,157,18,61,181,226,101,151,234,244,10,17,216,104,186,3,215,32,157,200,151,190,41,62,181,74,5,160,213,185,70,97,253,164,115,81,108,228,207,4,144,210,54,224,36,93,21,210,109,58,54,121,127,235,182,110,122,161,24,48,114,193,83,31,221,109,136,70,83,212,203,195,232,231,69,5,55,157,106,77,101,19,58,55,127,91,240,85,64,11,229,155,10,93,177,2,144,20,75,121,186,81,171,50,1,196,62,217,231,16,206,250,186,173,24,60,218,230,99,216,36,3,103,61,237,73,61,170,38,35,224,158,166,103,119,128,4,5,152,194,141,234,113,149,54,196,25,235,18,81,227,137,137,138,115,20,204,38,189,115,69,224,31,135,6,32,171,72,87,42,144,71,72,255,171,79,132,159,83,151,209,62,152,25,79,133,19,172,154,90,84,80,101,131,150,37,245,195,199,210,235,98,122,229,215,7,164,79,63,62,80,142,144,161,189,235,24,212,200,109,145,185,104,122,29,112,81,147,15,4,108,147,244,184,155,249,18,80,201,174,227,93,226,109,63,7,17,14,209,141,194,160,30,170,18,60,144,32,224,177,0,106,248,126,107,84,185,179,106,146,13,238,80,251,18,50,96,122,216,217,112,187,148,102,111,47,244,158,22,39,76,59,150,43,22,117,202,253,88,26,166,126,243,142,239,81,69,185,255,93,56,20,32,232,185,22,217,19,198,221,159,42,176,105,127,180,90,189,136,213,241,120,92,0,77,136,165,142,142,126,142,164,219,231,41,237,134,253,191,235,254,252,57,52,25,89,120,215,145,142,87,152,149,107,177,79,86,176,4,105,59,150,254,14,74,110,116,206,16,0,218,98,156,66,18,10,16,202,136,15,80,236,236,233,75,132,186,168,174,233,16,240,124,0,189,243,98,252,33,121,215,44,173,199,127,71,233,97,165,227,102,12,62,59,225,180,119,55,117,95,159,229,177,99,143,111,247,182,37,180,23,219,51,67,250,113,124,122,213,160,93,82,156,170,252,0,1,76,22,11,250,91,147,112,1,233,251,21,112,60,137,25,215,114,231,83,28,55,129,94,198,200,247,80,156,163,198,211,214,235,239,111,210,160,137,128,181,114,163,61,8,94,83,46,49,30,181,239,140,222,109,66,167,226,89,159,32,73,145,21,222,213,65,62,66,94,137,206,128,169,236,73,167,141,150,232,238,36,44,136,68,28,4,21,153,225,253,254,31,210,190,138,17,5,228,142,90,163,91,64,60,208,230,70,88,201,198,140,171,37,112,143,83,251,39,36,63,189,48,135,196,100,189,76,124,37,117,179,153,183,236,97,94,72,5,144,76,23,71,22,137,91,101,17,51,31,37,37,248,167,248,202,225,125,28,24,192,51,67,242,20,243,183,110,138,211,210,110,39,221,189,226,241,100,225,217,111,128,6,152,234,156,179,79,2,139,150,103,51,47,252,21,104,71,84,83,243,17,144,151,52,96,128,26,163,179,77,162,97,109,136,128,106,219,50,111,229,203,148,252,102,19,181,220,239,169,7,60,6,173,111,160,55,24,162,69,223,39,186,222,104,184,206,203,0,68,178,244,108,51,107,230,205,176,248,207,12,225,122,184,184,1,99,226,173,135,71,136,45,243,127,168,160,134,31,180,45,53,1,213,36,43,83,51,59,61,115,223,67,123,54,86,38,128,71,198,210,179,241,150,253,253,1,26,104,127,234,182,86,121,188,19,134,211,19,249,75,96,210,137,255,175,48,38,23,82,107,180,73,87,97,17,31,217,160,77,243,143,164,224,77,154,152,148,205,66,240,48,168,156,21,103,19,214,154,17,173,156,16,31,18,63,134,224,211,145,46,114,33,113,105,125,72,78,202,25,183,28,255,45,63,169,16,225,2,237,156,45,254,223,125,195,250,99,49,156,250,188,216,169,104,171,157,188,114,72,110,29,153,187,99,254,51,237,255,23,98,131,248,193,121,59,142,7,176,78,52,182,134,170,136,125,40,234,245,225,74,212,208,176,105,253,8,32,143,69,180,249,246,10,31,176,129,144,255,199,193,59,12,181,231,207,169,241,243,19,253,220,49,45,195,42,147,102,239,117,186,240,63,156,184,43,225,119,87,44,38,11,106,231,241,208,145,167,222,147,22,240,37,62,139,30,249,0,209,78,164,84,131,254,178,126,91,170,226,29,73,170,154,101,221,202,18,92,146,134,178,38,195,106,88,228,86,86,172,34,113,89,4,85,139,78,39,3,161,49,94,245,107,21,206,162,64,240,35,201,126,89,226,156,229,141,165,29,4,22,197,202,125,44,200,64,176,137,55,95,167,234,104,86,244,217,45,234,206,4,6,171,85,146,235,237,168,81,103,77,204,104,16,110,90,132,100,240,72,96,188,201,254,56,43,229,76,8,144,250,190,182,102,89,64,104,238,222,184,173,138,130,235,233,91,226,30,237,38,236,194,116,180,36,198,97,37,242,32,60,224,15,13,203,190,121,127,41,1,108,205,117,79,104,173,232,164,128,0,31,193,82,164,115,1,175,199,50,22,0,215,136,87,212,105,174,240,47,27,51,93,165,183,61,96,31,150,125,70,38,192,85,215,191,65,159,42,123,59,211,210,39,96,64,53,80,103,134,214,75,89,23,40,114,4,148,61,56,175,176,119,180,61,162,119,184,21,110,204,103,52,202,109,151,202,204,240,215,165,116,96,52,113,64,112,42,171,54,172,169,69,253,44,153,24,232,19,141,73,3,80,141,143,57,23,209,218,79,5,176,20,117,197,223,97,0,0,216,103,205,251,42,189,173,104,182,224,240,187,184,90,150,165,151,54,237,248,21,195,252,26,86,186,43,130,85,173,165,88,77,47,61,60,251,197,177,40,114,201,153,72,161,39,61,136,217,22,39,227,180,112,20,184,0,22,255,248,87,132,120,113,8,6,226,212,166,57,112,185,75,15,83,79,196,106,136,205,5,59,250,63,35,80,140,176,236,196,248,3,221,98,250,104,32,99,152,165,109,139,192,40,49,68,14,50,89,102,202,12,64,120,114,49,227,205,144,18,43,180,65,47,167,89,67,145,180,44,241,173,23,232,86,141,103,210,72,240,225,180,133,221,238,4,125,161,121,44,204,5,162,64,34,84,167,152,247,154,190,162,116,71,83,180,181,174,3,151,227,180,162,28,198,133,1,195,199,54,251,220,4,182,126,209,15,24,207,187,240,50,11,120,250,158,87,125,246,74,64,175,190,21,150,255,202,170,125,38,228,16,24,166,186,7,113,0,133,182,112,138,188,2,24,120,236,10,76,154,89,48,23,228,159,219,144,219,209,76,59,25,100,202,46,203,178,117,252,97,240,97,42,143,205,52,199,220,7,0,109,217,139,126,170,178,227,213,192,16,171,133,173,237,240,186,6,14,155,94,157,194,99,123,174,181,74,164,126,56,178,0,172,77,163,74,172,53,5,161,130,161,162,149,232,150,69,170,172,59,70,142,112,87,58,16,192,67,8,250,29,140,221,17,117,167,133,43,180,141,157,214,18,131,114,105,147,206,25,138,207,188,30,41,9,97,113,247,123,251,56,165,182,239,95,79,152,45,113,160,213,230,249,227,167,149,52,172,156,182,242,134,61,19,90,144,248,100,252,168,76,213,246,126,123,175,8,114,218,41,247,90,229,94,238,86,73,43,35,42,116,168,217,75,167,166,122,230,82,130,255,164,51,9,86,79,111,49,152,198,132,96,62,12,131,23,66,96,51,213,29,13,144,20,26,228,66,41,228,68,254,126,173,192,51,62,41,184,136,182,93,102,144,250,65,236,200,19,121,182,87,125,72,97,132,164,29,130,211,26,115,217,177,199,35,54,132,98,87,138,188,229,34,130,240,81,186,231,130,41,17,74,64,27,41,169,251,229,192,38,247,81,85,224,10,181,80,164,164,112,73,150,53,119,166,144,157,52,98,187,48,28,64,77,33,237,100,1,46,123,40,27,232,128,105,190,126,27,132,205,16,107,184,30,187,240,29,128,81,177,9,175,37,159,188,53,109,59,15,33,102,39,182,31,73,163,176,14,150,178,216,231,41,152,253,100,240,46,106,181,137,111,240,101,204,74,57,134,179,49,230,134,124,152,70,64,166,43,65,203,80,53,157,166,39,138,142,243,74,145,217,9,194,93,128,67,93,129,161,161,254,211,189,239,205,32,171,253,118,141,204,240,183,222,146,198,220,187,58,201,238,218,179,206,89,183,40,198,33,53,38,40,144,216,247,161,189,216,173,9,22,72,148,174,45,3,127,35,125,111,140,15,207,119,246,38,244,195,69,85,106,121,28,241,125,124,103,116,108,152,84,133,165,68,92,5,189,160,223,125,159,69,84,91,214,24,52,36,207,180,152,8,156,70,209,194,220,165,138,212,192,246,132,124,186,64,218,179,23,131,210,117,7,15,197,250,249,187,104,74,19,195,232,168,66,171,125,133,252,89,123,236,67,152,150,187,82,161,241,29,160,206,15,254,101,201,34,79,182,6,88,237,204,67,3,24,199,64,58,22,71,118,31,80,235,148,111,111,74,248,229,15,0,160,215,0,121,227,15,243,58,122,251,203,236,223,102,217,235,105,113,239,209,206,227,198,166,116,250,85,48,71,14,78,216,2,167,129,129,240,167,56,89,118,161,125,49,228,56,221,13,219,207,36,68,253,27,45,219,117,151,229,111,247,206,97,173,132,8,74,182,16,125,54,238,31,46,244,50,250,3,216,182,42,120,67,61,39,106,101,23,248,21,80,151,115,41,105,95,47,32,90,53,3,164,31,12,113,105,26,135,101,186,43,191,173,143,177,4,75,109,96,7,121,5,231,218,250,45,96,254,193,146,225,251,238,21,240,27,207,43,187,7,61,254,195,234,210,152,46,241,186,188,216,234,82,179,109,61,190,139,211,58,36,74,149,107,249,150,196,71,226,167,232,40,42,19,152,17,194,16,94,5,11,57,37,43,99,98,248,81,211,60,69,192,80,94,225,241,197,53,76,100,1,166,253,132,17,3,72,232,72,214,60,18,151,159,15,167,78,27,76,142,22,21,129,121,10,185,35,246,49,165,218,73,182,236,65,1,175,236,230,71,209,189,163,164,179,194,209,86,6,180,219,147,94,15,212,246,83,21,183,250,40,230,78,222,159,74,94,13,20,247,51,90,218,253,125,50,81,72,93,1,200,50,199,223,192,197,223,38,208,98,122,118,7,82,178,154,193,50,199,199,7,184,231,120,39,2,232,41,182,32,75,56,236,176,5,0,113,190,13,109,1,175,212,249,89,21,130,204,162,228,119,244,190,87,252,151,13,40,209,103,93,95,199,103,141,133,122,94,189,161,222,26,229,214,114,137,110,97,84,81,251,213,80,122,215,144,113,154,105,12,130,191,24,0,226,159,46,86,119,142,104,231,72,118,224,91,195,94,179,212,168,32,243,2,25,219,4,197,34,167,252,198,18,155,87,88,62,165,118,253,176,96,152,186,128,214,140,226,59,11,113,104,102,96,136,126,9,13,140,165,46,116,134,52,249,105,131,168,226,83,93,216,194,247,236,251,159,42,118,243,93,85,175,120,106,134,75,146,217,187,183,49,138,190,5,189,3,203,106,166,110,104,108,70,111,165,41,203,34,212,254,32,10,2,238,30,243,126,47,119,175,63,107,73,75,131,105,17,54,253,158,128,179,196,198,64,151,178,55,47,159,191,106,78,234,208,198,108,42,131,2,33,44,121,43,48,137,107,252,205,15,84,242,200,169,148,239,199,117,248,6,151,51,83,45,149,57,75,160,202,27,122,235,14,50,90,135,90,94,140,171,241,123,236,90,200,243,190,6,111,165,246,139,34,141,151,172,38,34,66,201,218,83,110,52,12,146,6,26,248,102,120,174,193,25,147,171,152,87,174,79,55,208,166,73,111,90,214,25,117,239,102,226,213,182,128,93,49,129,174,3,2,180,9,250,166,8,32,141,187,26,55,157,229,144,64,195,91,154,133,56,176,6,198,60,119,115,232,70,213,143,59,250,97,136,50,75,125,198,19,151,141,168,48,163,47,67,211,114,119,103,69,9,119,244,236,196,164,248,228,69,215,205,245,16,57,177,244,43,224,109,172,45,14,5,161,195,63,81,38,117,19,125,248,179,103,199,168,84,151,192,55,216,72,96,43,117,199,103,51,202,42,177,40,169,84,157,153,173,244,141,108,142,38,188,53,35,151,221,147,12,148,111,151,129,212,37,253,142,191,152,21,241,153,150,30,71,95,49,124,83,150,47,109,169,199,96,70,141,167,74,79,11,152,159,93,215,159,185,141,249,140,114,217,75,87,133,177,114,114,27,32,86,10,246,20,157,127,160,164,227,79,194,177,107,49,142,179,84,144,135,178,81,30,7,228,120,116,11,103,210,83,15,94,77,40,116,144,27,125,81,192,231,217,112,4,184,78,6,144,65,184,221,84,114,52,150,241,217,130,114,219,252,15,34,244,209,76,178,193,231,229,38,137,147,0,147,242,150,26,33,32,28,132,60,63,134,221,9,214,135,97,120,217,109,78,130,199,253,153,215,234,19,186,201,199,169,20,132,151,74,179,54,65,25,171,126,126,88,23,247,222,39,52,65,85,45,245,229,214,38,98,14,0,10,216,42,17,230,34,91,84,144,209,31,186,211,140,175,188,80,202,99,174,124,88,40,32,214,235,133,253,145,179,186,102,42,135,61,67,235,163,133,41,35,25,168,87,141,24,186,210,233,150,19,220,120,81,123,169,245,18,197,27,207,176,15,197,115,139,69,152,82,211,148,77,184,232,173,29,253,46,123,173,245,217,54,231,135,218,236,101,196,45,109,136,189,206,68,215,214,77,251,43,39,224,144,62,135,50,114,247,67,110,247,38,143,220,5,1,173,142,88,7,149,152,225,194,10,114,152,121,105,239,242,249,117,29,172,2,39,98,218,33,31,69,93,11,210,222,132,40,251,162,173,144,13,165,165,242,181,202,215,89,196,228,253,39,70,73,153,144,63,184,211,2,204,107,51,166,197,173,14,15,96,66,141,11,12,244,148,50,16,214,9,8,52,6,165,105,91,184,10,10,62,135,250,200,159,69,227,229,86,98,229,73,27,200,217,108,233,211,81,90,93,45,50,50,149,19,35,23,116,202,113,21,211,33,217,140,128,86,228,185,130,140,104,87,180,174,131,213,254,48,90,67,239,159,204,139,229,42,236,142,82,151,187,165,11,12,150,53,56,10,76,97,213,117,217,51,242,133,135,229,78,117,95,26,31,69,32,138,147,70,226,136,42,0,8,199,224,233,35,206,48,207,61,99,52,101,204,118,143,245,236,120,33,226,57,223,53,32,255,6,236,127,223,89,137,99,84,204,80,106,20,237,64,149,193,65,7,41,202,120,56,115,112,137,35,254,243,28,47,4,229,33,115,177,48,219,231,48,63,139,95,214,209,6,170,197,116,222,104,88,254,141,16,48,222,226,9,47,121,65,188,142,38,129,229,60,122,25,131,229,78,249,211,139,93,199,181,248,231,247,38,161,131,223,146,216,88,123,189,77,186,220,2,185,53,173,226,101,153,213,103,171,140,207,44,51,120,168,36,182,213,176,87,166,170,61,250,49,139,249,215,135,168,170,59,95,118,142,249,166,177,121,94,175,159,219,228,219,117,28,222,43,180,225,108,140,7,25,5,94,45,171,5,65,137,255,40,123,190,89,181,94,76,172,91,161,197,240,85,79,172,28,47,57,205,233,102,137,143,28,155,20,20,157,41,148,175,43,167,5,82,171,148,109,247,237,236,176,176,124,1,158,189,93,168,51,115,231,208,228,55,164,123,212,27,25,190,38,1,120,25,153,91,236,95,116,67,210,173,224,156,220,91,207,120,91,114,212,191,71,198,205,146,136,65,91,33,204,192,154,155,243,71,11,55,239,100,89,204,247,199,59,120,22,68,109,137,194,203,81,61,247,11,226,242,210,155,195,209,1,193,108,163,178,20,22,170,30,148,214,80,229,153,91,103,246,237,10,245,110,211,150,205,98,239,92,94,71,206,91,253,204,90,157,216,152,35,148,167,8,201,167,24,239,191,158,102,23,131,159,64,99,81,159,58,193,185,68,1,28,24,38,198,132,80,191,19,122,235,99,129,100,49,253,29,52,194,32,108,106,166,243,179,53,189,96,59,73,241,61,32,223,84,218,118,59,32,64,9,98,239,207,219,101,38,106,54,148,148,25,5,50,107,106,152,242,117,192,102,56,184,19,232,133,157,243,182,52,144,217,94,101,153,221,88,157,52,224,159,93,159,71,2,115,200,230,116,202,177,236,75,20,176,16,39,147,24,150,195,21,251,77,57,185,113,216,168,48,127,164,56,104,92,23,85,141,159,93,53,192,103,163,130,24,85,85,160,61,246,23,185,196,18,158,228,129,148,126,206,52,198,191,182,12,98,112,31,56,160,62,208,196,234,1,56,249,23,61,115,25,164,254,151,45,11,124,107,53,151,131,221,52,249,185,90,5,4,129,177,134,168,239,37,50,111,225,178,53,251,9,5,87,32,111,75,239,38,160,33,50,128,211,5,250,31,61,177,31,115,182,221,118,33,225,75,165,5,43,89,152,62,217,185,246,122,194,98,47,193,42,74,46,144,111,16,231,76,88,151,7,93,68,144,237,82,117,206,167,239,6,137,55,125,14,88,92,201,143,148,62,216,55,224,150,178,38,77,42,167,163,233,124,131,220,55,50,219,117,225,244,220,233,124,27,133,246,213,86,54,152,29,92,98,226,98,54,110,144,186,41,161,225,72,199,30,105,121,160,56,141,23,100,40,88,208,169,32,196,122,95,231,57,244,199,120,13,232,165,250,170,24,34,231,23,205,33,18,214,128,56,165,14,48,104,223,133,183,73,58,100,111,112,115,239,70,81,81,38,94,88,232,164,212,242,0,59,114,36,133,89,252,41,204,37,193,144,244,255,242,124,20,131,112,126,131,187,205,71,229,86,90,197,199,245,45,120,190,56,223,164,63,177,75,188,238,180,176,137,182,95,221,29,158,104,4,224,38,183,94,172,67,44,62,168,237,218,85,159,58,25,168,173,108,204,228,81,18,145,207,176,19,10,212,78,133,108,169,178,117,11,19,155,152,200,117,243,99,143,126,93,75,167,4,103,249,245,27,30,184,78,162,35,174,200,4,59,119,138,195,58,130,59,179,147,48,207,134,201,207,31,90,145,168,212,195,79,220,16,253,80,24,42,159,61,178,241,81,140,246,198,225,166,94,74,63,254,3,218,93,2,74,194,239,192,68,55,75,132,51,79,200,162,72,133,34,87,86,7,157,235,37,94,78,191,150,81,213,162,147,20,232,243,173,36,1,244,91,3,192,10,224,194,229,74,147,19,192,165,168,153,5,127,230,113,185,206,127,146,80,114,246,179,16,31,90,0,242,254,82,189,36,246,211,7,118,168,33,154,220,184,107,101,40,150,196,194,242,253,216,72,132,210,147,230,224,198,34,75,25,74,233,205,159,168,6,197,50,217,127,251,94,27,0,89,55,171,138,10,197,251,46,127,84,139,97,212,131,44,89,5,181,154,11,223,2,106,249,29,222,72,44,89,57,56,8,138,102,140,86,159,219,77,239,32,203,126,142,214,192,72,16,119,161,71,155,250,58,115,189,112,51,213,249,25,85,78,170,171,102,164,103,133,109,37,229,130,167,116,64,21,234,76,246,89,206,141,235,89,223,141,56,47,168,166,97,190,26,197,70,97,133,200,148,53,45,183,39,129,38,122,174,116,58,75,115,221,204,101,52,24,94,177,14,237,2,172,234,210,8,208,25,77,235,113,24,108,216,242,184,180,255,173,101,240,51,246,200,240,13,156,209,93,60,66,170,252,82,230,13,215,146,117,255,210,7,34,122,10,106,156,176,21,68,222,248,33,83,152,206,191,60,18,158,149,114,74,41,60,203,244,210,249,189,212,25,25,75,131,95,76,207,254,188,23,124,249,162,255,170,137,0,81,97,181,221,127,2,120,240,234,80,28,115,105,158,136,89,77,135,103,255,251,8,186,242,63,176,164,122,8,11,128,19,58,243,8,212,252,204,84,170,108,158,179,247,0,254,32,87,139,213,136,45,180,92,145,67,92,246,247,205,97,103,87,101,163,137,0,61,23,230,147,218,153,102,235,104,17,24,246,70,190,79,179,238,178,41,56,128,115,241,148,114,229,173,144,63,54,151,123,191,45,145,222,89,230,29,59,34,163,123,120,56,34,137,149,161,32,221,255,87,39,50,57,112,84,159,209,51,170,143,167,190,117,145,202,12,127,248,132,142,52,118,154,247,22,242,179,161,240,146,155,7,176,79,18,1,228,242,227,81,34,121,92,236,105,176,207,233,51,86,159,119,70,173,14,42,103,31,241,149,157,98,49,61,96,106,94,142,12,146,88,63,16,173,84,14,216,170,188,7,119,188,94,156,24,78,218,117,39,252,216,201,136,241,118,24,231,164,15,9,211,193,68,14,9,140,214,99,95,235,172,219,136,83,12,95,75,88,48,152,236,153,95,137,236,38,125,35,176,220,87,52,101,106,40,172,224,140,105,118,201,227,143,43,59,162,152,247,197,72,70,232,183,21,160,2,64,169,41,69,166,102,52,189,217,130,19,196,230,34,133,35,31,17,193,45,252,112,79,79,223,99,168,154,14,19,74,179,41,246,27,199,128,101,54,80,252,173,165,241,80,26,204,142,255,57,94,25,56,246,22,133,229,144,110,212,118,251,36,49,81,254,183,116,222,99,70,181,22,74,96,199,161,124,176,7,199,9,56,128,64,200,185,222,37,225,144,156,152,22,99,76,208,43,99,207,169,146,220,182,136,30,96,166,118,49,125,40,132,106,49,212,158,91,55,84,208,213,75,63,190,113,71,83,98,109,21,176,11,204,253,157,79,106,111,232,239,253,187,98,141,32,52,39,209,183,100,176,183,32,232,137,209,189,13,67,230,44,99,233,235,31,211,62,149,120,185,114,79,123,8,153,151,112,255,65,154,228,16,226,177,21,18,10,146,172,134,181,123,4,253,122,188,229,98,89,112,147,19,145,108,246,176,210,201,128,231,96,230,39,140,7,175,246,144,253,114,34,223,14,48,134,160,78,112,135,138,197,142,208,213,221,156,197,198,131,42,169,203,191,140,36,205,131,59,11,239,147,205,235,193,132,59,199,198,42,204,244,120,24,172,221,253,85,141,118,110,76,153,91,146,222,142,200,251,52,172,145,250,47,123,86,49,253,220,27,77,170,51,36,179,148,26,32,251,162,197,246,163,248,65,123,233,68,194,166,153,206,118,238,22,134,49,13,218,176,11,183,124,197,148,169,251,224,80,11,209,166,233,229,19,220,114,244,144,246,17,131,119,108,78,6,26,238,121,82,13,57,179,139,149,164,255,235,181,20,240,76,155,71,61,89,192,100,16,244,93,71,199,139,70,203,107,44,233,154,66,40,255,1,15,20,206,89,244,23,68,123,164,177,175,187,170,150,195,150,44,96,99,142,169,220,220,197,235,124,72,198,60,112,180,196,35,190,154,107,29,177,10,243,111,210,61,157,156,223,255,101,5,210,27,224,15,23,138,119,65,201,139,134,84,70,122,22,204,153,5,193,108,54,149,173,173,37,200,81,229,93,72,7,45,14,51,177,85,166,96,189,55,43,70,88,172,251,17,221,163,81,62,196,216,14,31,82,46,38,65,125,42,32,4,9,145,100,31,102,106,231,86,31,167,246,39,11,28,118,34,92,179,80,65,191,115,43,247,211,118,115,124,156,122,145,222,177,73,161,7,117,51,20,29,178,100,26,127,202,208,177,209,121,101,140,194,20,229,139,123,55,186,209,31,33,39,115,64,97,128,152,60,147,70,35,97,4,156,87,181,58,244,132,109,115,229,91,215,10,28,25,21,57,163,234,21,101,81,18,220,78,130,105,85,41,164,78,228,156,201,182,234,93,221,241,194,212,66,84,4,11,81,116,94,234,37,200,8,214,228,253,58,205,250,62,168,189,1,46,223,0,158,154,29,127,247,188,25,193,165,228,117,234,121,149,167,254,11,3,15,12,91,42,46,11,240,230,134,120,108,46,58,63,23,230,140,113,173,206,94,55,63,20,187,32,255,142,32,192,135,161,231,95,115,204,50,125,129,245,15,153,89,124,35,87,200,91,78,68,126,100,158,103,224,232,192,132,174,34,19,19,48,139,182,247,255,70,88,227,139,253,31,10,222,62,188,140,85,169,143,143,14,29,108,159,46,98,211,30,129,63,149,77,230,246,61,181,103,153,124,242,214,63,70,78,193,78,208,159,94,20,59,30,81,88,112,124,123,183,101,239,217,86,232,137,59,250,5,110,107,71,27,31,15,33,62,200,161,218,153,82,134,5,7,141,180,7,152,169,23,182,33,150,252,223,90,209,54,177,15,50,19,8,253,37,226,84,143,33,164,230,38,215,102,42,156,198,36,35,149,175,75,79,102,252,69,215,7,165,103,252,189,221,18,204,32,86,110,22,47,74,38,247,11,126,5,145,242,247,20,9,190,177,121,79,16,110,73,41,45,141,3,247,35,3,252,191,45,7,156,127,115,198,74,194,5,25,124,110,61,109,115,151,84,72,182,140,170,23,217,123,133,98,143,18,53,128,55,78,61,89,152,214,253,63,133,196,183,215,107,107,158,245,129,15,153,169,246,158,65,172,8,47,226,30,126,10,64,163,175,108,218,130,19,89,235,34,206,150,176,199,6,140,234,201,165,130,107,208,64,112,36,44,115,250,199,236,204,60,127,43,124,225,163,49,76,103,210,254,126,180,82,44,230,68,93,12,246,201,186,72,190,172,76,128,42,173,0,221,120,14,150,19,197,121,163,71,111,214,183,143,24,187,70,13,255,228,250,134,173,209,183,166,208,21,225,94,109,145,98,70,255,76,151,190,150,183,152,248,238,224,187,111,4,2,111,236,73,135,133,67,34,193,94,52,159,42,187,59,38,75,152,72,134,112,236,191,233,150,43,156,14,167,70,226,7,114,200,31,140,164,33,84,232,169,15,96,172,175,192,57,229,71,227,101,139,17,90,45,154,32,255,204,159,141,200,159,147,45,152,135,128,51,11,78,181,154,83,92,144,157,134,244,234,140,201,95,218,104,165,146,35,28,223,139,111,128,149,30,162,119,191,217,136,196,219,138,212,22,168,182,19,118,34,168,68,234,104,231,59,166,128,52,254,212,215,218,117,66,31,249,88,61,78,33,130,242,94,66,17,169,102,100,130,251,1,125,169,71,110,165,239,246,162,251,220,185,184,20,76,133,171,122,57,219,218,181,169,220,38,166,27,206,53,166,180,135,172,64,7,187,131,182,110,67,34,191,25,145,197,184,217,30,140,72,15,212,194,123,34,239,194,64,110,117,35,199,82,17,157,252,230,226,228,44,151,158,81,101,191,59,18,175,143,139,235,12,185,50,15,106,29,143,82,247,211,52,208,35,153,64,11,50,37,13,38,232,128,45,104,62,240,201,122,137,83,140,250,178,64,142,202,168,54,119,221,215,71,166,35,108,71,223,239,99,153,12,8,134,64,200,182,235,107,96,111,231,153,200,254,189,247,49,93,127,4,200,77,43,160,120,224,252,243,224,46,190,166,143,82,46,207,86,235,116,203,190,88,18,55,121,70,227,215,107,69,58,245,221,133,33,73,230,34,36,254,49,127,129,180,253,175,209,180,54,94,124,96,104,97,243,225,38,248,166,230,189,233,78,38,61,122,43,51,76,9,219,127,1,239,79,151,48,213,26,208,118,80,108,178,180,167,38,224,5,87,106,12,73,252,109,195,190,244,1,237,106,212,236,116,74,192,255,121,219,152,67,18,77,38,21,51,27,121,200,196,0,84,219,179,46,124,54,85,12,179,49,241,46,197,14,33,28,79,227,246,94,112,66,187,209,230,116,161,40,15,78,57,156,110,138,178,73,41,255,178,62,43,236,180,171,248,21,243,240,13,110,71,67,79,176,57,76,207,194,20,219,223,36,60,83,50,200,87,245,137,235,132,89,144,67,4,174,55,221,14,212,138,175,187,209,186,54,80,178,238,243,36,9,199,108,128,111,120,61,208,105,53,44,233,236,78,63,226,71,197,238,242,101,100,227,70,160,209,41,198,56,65,115,138,237,132,126,95,23,46,122,98,177,164,159,251,98,212,145,111,203,95,36,21,53,163,88,57,51,139,255,60,181,38,187,107,75,128,165,215,232,130,56,103,173,192,192,119,72,104,142,246,79,232,200,17,207,225,61,55,106,74,61,126,180,229,233,187,223,190,82,11,232,15,84,52,13,98,154,199,134,191,227,132,219,235,17,230,249,92,249,34,165,54,132,101,234,209,220,66,6,69,181,50,132,160,155,246,171,5,167,56,49,27,175,90,222,36,13,217,116,128,9,151,3,203,43,43,40,205,132,14,248,28,88,180,107,146,95,19,175,0,109,41,170,148,148,54,179,0,71,101,59,99,221,143,205,42,59,156,112,136,31,59,18,231,136,191,41,46,122,77,101,152,172,123,108,116,111,53,229,4,163,218,156,39,171,198,100,223,236,90,205,126,143,72,67,138,159,241,118,154,239,154,219,34,182,123,33,163,113,46,15,249,238,36,50,215,132,241,226,207,196,181,96,162,212,88,224,190,81,179,12,136,146,122,238,83,129,26,72,105,125,20,146,253,67,112,232,12,188,96,52,161,160,121,241,50,77,49,218,20,78,169,246,196,95,213,12,11,243,170,71,1,244,78,233,115,143,34,201,250,23,100,9,97,17,4,211,193,128,42,106,170,138,9,75,28,208,247,157,32,4,210,106,87,15,97,167,209,22,160,123,52,183,148,194,21,14,53,212,119,43,76,147,154,56,43,175,79,109,103,68,93,115,95,230,242,89,230,162,136,47,37,79,109,220,24,217,83,40,241,45,113,250,138,133,115,120,72,115,222,65,36,226,44,1,172,128,192,152,113,44,162,139,24,194,114,139,90,162,31,228,198,129,96,97,224,87,232,183,43,193,104,251,129,67,148,240,227,100,4,27,202,89,241,226,221,189,142,102,74,1,234,197,88,247,95,217,142,161,58,118,124,174,252,162,242,248,126,19,199,138,191,202,209,59,204,127,100,65,187,50,108,197,107,107,205,55,228,48,246,168,68,28,74,186,102,54,116,29,188,57,221,206,122,202,240,151,15,23,162,146,91,12,88,51,69,3,110,205,52,5,186,49,46,171,126,221,23,30,236,45,162,17,198,211,238,177,147,106,5,203,206,78,143,1,167,153,96,15,225,28,219,223,209,68,221,218,102,32,19,138,90,130,254,63,73,240,165,99,150,83,198,65,210,22,92,216,204,186,182,213,249,35,2,80,190,138,101,47,225,210,232,29,85,90,174,228,82,244,173,189,193,47,20,238,93,189,172,27,25,87,244,243,224,87,201,186,153,42,69,160,195,77,180,136,128,231,197,161,163,94,0,191,87,57,125,254,155,170,223,110,165,95,181,188,82,153,240,68,118,58,137,253,184,248,35,170,207,20,197,246,93,21,36,48,195,147,75,92,94,166,34,77,198,225,189,122,91,111,136,32,138,146,132,33,113,35,32,184,97,10,255,132,98,61,203,100,65,30,160,150,30,85,22,8,32,101,187,142,240,176,3,67,219,207,113,202,242,213,177,61,155,141,225,69,7,10,3,184,65,132,69,241,149,214,97,91,168,150,187,136,18,190,15,66,134,232,239,202,169,247,10,160,246,157,238,77,41,185,221,165,157,108,94,145,231,229,169,101,1,167,15,161,20,158,211,139,204,107,228,206,211,185,65,246,158,167,12,107,190,45,182,28,192,44,106,148,62,159,222,82,10,227,237,251,3,151,152,139,76,162,183,169,202,107,181,200,129,195,124,71,208,135,234,26,203,154,53,208,137,99,150,100,142,114,50,153,183,126,133,1,253,9,202,235,65,46,106,126,8,5,105,93,53,17,35,209,62,117,114,152,57,29,66,71,127,2,130,103,158,7,17,86,195,64,229,219,75,195,212,33,209,50,154,59,27,177,135,24,163,107,219,137,197,220,7,153,96,131,0,65,187,83,25,18,15,100,245,27,6,174,119,25,182,124,115,158,7,84,182,105,34,75,231,222,190,48,233,221,49,119,79,153,174,200,28,223,87,37,72,254,237,189,199,23,239,255,69,27,152,251,104,233,142,231,80,48,149,197,234,170,200,149,73,120,9,20,212,128,69,99,144,23,22,83,89,207,47,19,17,198,156,214,226,55,130,85,146,54,5,58,224,214,6,27,36,31,164,126,182,225,53,4,52,100,11,28,220,125,41,101,102,215,188,97,6,55,113,252,140,78,81,115,58,203,129,115,132,109,206,21,68,78,20,128,95,62,34,72,211,75,41,78,234,223,115,175,57,229,107,227,179,9,162,15,86,211,207,126,44,120,162,65,99,15,187,57,91,18,41,138,119,15,37,90,138,187,40,13,121,164,30,26,160,7,116,143,9,149,10,228,215,85,75,134,113,241,72,248,12,116,160,177,187,166,188,208,252,178,182,169,220,121,139,203,135,116,198,224,193,215,214,189,110,168,68,129,130,192,8,226,15,122,181,16,37,227,17,156,38,246,249,4,89,193,12,237,32,109,66,52,139,50,235,10,231,210,19,204,191,161,192,238,27,142,203,62,146,194,119,135,132,70,245,214,127,209,179,254,19,43,72,110,124,118,71,34,142,134,163,182,130,140,131,160,56,194,13,10,6,8,136,131,171,206,237,108,163,127,8,17,208,116,17,165,125,236,166,45,180,115,123,110,117,255,84,33,201,176,66,60,220,2,92,128,59,50,147,27,232,7,251,48,118,128,215,225,182,113,163,1,165,184,212,132,246,28,57,13,84,140,97,222,230,172,120,254,160,216,70,239,215,0,111,160,68,51,0,31,109,79,49,38,221,94,95,37,226,200,239,75,160,227,1,122,27,49,244,122,133,67,125,60,12,216,60,89,219,92,146,252,169,205,31,71,112,119,174,142,76,205,10,173,28,31,26,119,222,159,151,151,214,150,124,197,51,174,17,3,58,240,120,130,175,51,87,155,106,76,197,143,86,226,95,45,72,196,34,230,99,248,121,236,163,207,67,132,152,165,42,252,107,111,171,10,114,221,71,94,190,87,197,251,236,116,86,60,82,253,64,166,236,178,150,126,252,230,179,186,45,52,123,29,16,175,237,157,13,213,215,69,153,217,233,51,38,227,186,80,200,188,65,110,196,78,3,202,66,175,161,253,111,249,120,23,44,176,170,211,138,243,128,128,115,108,85,27,23,107,91,1,212,31,154,136,228,166,30,96,59,92,34,162,61,242,225,232,47,195,154,45,144,74,125,246,69,128,166,229,187,39,196,152,5,66,133,189,18,245,235,31,214,153,14,205,11,130,1,238,167,83,107,14,41,235,8,139,62,37,74,87,110,189,142,226,150,1,219,52,58,115,150,62,55,66,239,30,11,157,138,57,159,200,148,184,237,250,169,248,88,159,137,188,98,30,50,189,59,15,225,149,129,184,102,146,114,254,181,178,143,54,171,186,63,219,29,83,52,76,222,208,189,242,11,81,188,87,249,54,213,162,246,147,7,72,54,22,48,119,146,108,131,16,194,137,175,45,132,109,33,243,243,40,190,135,54,116,177,29,228,193,151,91,207,114,183,37,198,58,44,53,196,42,118,27,144,95,155,137,80,255,233,76,228,204,81,135,24,99,82,230,130,134,134,90,185,64,21,78,113,200,124,44,66,8,202,250,219,158,245,90,117,100,130,99,79,193,113,76,66,140,147,91,76,194,35,42,183,235,58,162,251,48,190,103,86,96,173,72,202,179,222,118,203,182,225,42,46,211,245,250,204,238,192,46,2,210,178,141,212,84,160,233,228,60,100,58,151,244,252,138,108,189,119,187,104,222,9,36,11,182,33,204,41,164,233,176,152,233,86,233,50,206,99,64,128,110,66,233,201,123,179,225,189,88,55,210,152,178,238,149,204,213,200,212,190,228,170,205,255,165,46,209,51,91,74,229,36,181,120,52,6,82,169,229,225,218,231,110,222,218,6,179,193,106,30,34,243,244,157,149,112,198,254,119,89,250,217,97,62,28,209,188,203,80,211,129,242,222,66,129,254,133,112,29,113,174,62,6,239,237,224,23,116,214,189,215,75,239,171,17,204,68,178,19,31,37,201,108,153,71,126,166,217,28,201,87,186,193,62,200,110,44,41,74,172,66,60,174,120,134,18,85,137,113,240,138,170,198,225,97,115,26,202,243,51,96,31,18,185,179,52,52,98,63,170,11,216,247,18,9,35,203,107,220,12,6,21,178,236,232,102,112,57,211,73,9,28,24,100,146,157,25,199,182,169,71,71,6,60,175,82,210,8,190,110,18,136,70,15,43,13,60,52,12,43,123,111,248,2,36,45,160,215,73,52,54,36,80,105,210,238,113,115,116,84,251,91,72,109,192,195,188,108,51,89,2,189,86,142,28,210,69,246,138,253,85,224,49,223,6,47,125,40,72,173,56,214,70,132,134,51,244,168,101,112,151,126,77,102,143,239,4,13,116,106,10,103,119,126,65,6,31,18,107,68,76,241,127,130,133,186,61,250,68,253,189,150,134,117,83,51,83,25,187,118,78,134,35,123,184,148,245,53,68,14,88,131,0,68,159,141,48,76,196,130,198,34,56,19,203,64,75,87,26,133,28,73,19,242,167,183,2,251,172,114,9,7,155,151,79,86,68,141,54,101,212,74,210,65,219,237,175,83,252,71,245,207,108,46,196,105,180,46,85,217,5,128,221,226,157,62,176,224,25,140,26,228,142,51,187,96,116,42,92,18,197,211,133,4,0,207,161,141,187,60,8,215,220,174,187,41,153,27,83,242,133,205,30,135,7,207,178,168,111,3,85,173,149,137,68,187,204,184,237,209,59,41,154,36,35,7,212,199,183,241,25,178,86,195,41,137,201,81,164,246,218,251,180,218,161,189,193,147,17,147,15,78,69,23,170,86,93,28,58,170,81,208,143,20,240,63,182,158,203,197,94,135,254,11,135,124,183,89,193,71,88,184,98,208,164,134,197,140,75,234,159,83,20,177,109,123,195,118,229,245,116,207,220,6,11,187,253,37,198,220,195,29,176,38,46,67,200,232,90,245,23,105,165,133,57,29,208,185,232,69,180,3,5,19,111,91,226,98,197,90,102,20,243,203,137,88,156,217,18,24,141,253,17,194,150,75,120,212,232,5,187,191,80,176,71,27,94,71,149,230,108,103,17,129,248,166,186,196,171,152,249,136,146,130,38,204,223,106,175,46,105,241,113,125,212,159,243,233,110,229,177,187,141,186,157,99,212,232,218,25,58,4,212,122,110,11,236,187,184,12,168,127,135,212,37,81,184,79,102,171,143,151,189,158,113,56,80,94,110,58,223,118,37,73,53,158,134,151,251,250,216,143,88,233,8,206,211,238,115,195,53,186,238,140,128,150,50,225,14,236,49,195,224,75,85,229,24,20,244,72,136,144,15,96,152,6,156,158,133,144,200,229,50,186,234,205,77,101,31,5,147,136,55,31,158,100,141,179,213,225,15,161,176,225,156,40,169,60,57,227,45,170,44,97,107,83,178,31,102,192,84,212,43,159,32,188,252,47,248,53,6,68,8,126,187,27,46,133,214,4,199,153,29,177,123,35,170,100,66,253,178,46,37,206,97,62,17,208,98,178,195,223,64,76,251,94,132,241,102,36,130,182,53,98,94,253,122,211,197,204,144,195,101,203,40,158,215,192,102,44,87,233,61,81,147,158,79,117,222,27,26,219,168,15,59,142,65,113,172,49,253,190,191,188,12,59,244,226,238,7,59,116,34,120,56,20,118,83,59,78,142,79,43,150,41,207,228,35,234,182,14,86,50,120,254,31,74,82,5,29,39,173,104,87,10,249,237,158,29,211,250,239,50,64,90,200,107,209,100,26,135,182,38,139,177,27,64,6,87,21,235,204,230,235,222,248,48,156,212,204,138,22,36,123,3,40,93,25,200,55,162,51,116,3,140,58,246,81,78,59,89,103,138,23,220,89,171,48,48,203,181,80,163,171,109,173,17,34,188,238,42,205,32,106,18,122,80,8,247,127,26,32,148,141,138,226,57,27,129,234,74,40,235,202,6,106,127,1,11,117,117,236,240,123,227,139,185,241,205,42,57,186,237,83,21,90,3,25,88,42,109,224,140,238,11,177,108,46,111,28,229,139,95,217,72,101,173,235,131,28,2,85,51,19,52,105,218,235,176,84,57,140,165,80,238,93,92,6,47,138,188,132,100,36,219,223,236,201,112,201,190,0,20,146,68,95,16,147,1,52,108,54,185,188,154,104,247,173,127,160,214,230,207,56,112,98,105,62,42,66,97,101,47,220,193,114,23,202,61,21,118,64,16,191,112,119,123,20,117,173,202,70,39,239,112,202,66,142,163,211,106,89,2,97,150,55,78,226,111,190,170,144,53,195,72,96,89,229,178,153,130,164,161,86,154,154,21,95,120,12,31,122,50,142,245,189,124,17,218,35,201,75,20,203,234,97,11,70,151,3,185,169,71,243,91,56,248,117,103,8,162,90,14,193,33,124,194,169,48,150,40,80,127,37,151,74,195,221,99,145,74,172,228,150,120,147,204,160,67,110,187,30,236,197,101,7,127,128,115,7,243,235,20,66,101,40,114,136,254,206,220,67,96,231,89,65,202,234,82,8,131,187,238,220,213,142,223,77,25,167,69,68,87,110,101,200,142,51,26,234,143,164,214,134,215,222,141,23,42,75,147,88,211,199,154,201,24,72,202,13,136,234,25,52,120,254,136,185,193,163,187,133,84,93,81,133,177,73,126,136,46,251,136,144,180,33,34,18,230,128,47,79,79,106,150,8,58,160,248,106,132,183,215,17,146,173,177,243,32,65,1,175,14,45,235,55,127,69,29,175,177,184,199,168,231,173,143,212,218,44,28,243,157,87,243,247,193,142,155,49,191,221,140,235,246,53,125,204,139,60,232,18,220,63,106,61,252,172,154,140,47,208,189,55,163,20,44,108,250,50,252,255,204,45,52,2,76,66,64,241,107,21,163,134,187,242,247,136,203,1,7,118,226,244,67,198,15,238,194,74,9,230,186,185,49,162,49,71,168,31,130,160,103,223,244,225,108,133,142,123,181,164,114,112,172,100,229,165,150,250,57,212,15,63,204,70,163,4,98,111,152,45,37,45,245,228,45,244,111,124,250,163,197,120,243,232,117,56,154,191,145,196,141,125,8,55,90,132,216,85,224,174,60,253,201,63,198,114,202,235,236,103,174,176,192,65,93,161,74,226,65,222,241,126,119,113,174,16,71,68,19,253,160,250,79,117,231,129,159,61,132,104,164,251,78,110,48,246,12,36,172,100,111,152,87,36,40,95,115,60,227,74,123,204,149,244,119,65,162,114,102,121,19,155,249,117,248,51,151,33,42,115,199,237,144,43,180,51,121,129,23,83,127,226,56,9,32,222,44,201,44,21,7,249,122,183,224,239,85,204,10,181,91,19,103,103,133,205,12,229,38,97,31,108,141,82,255,186,32,185,59,95,66,45,15,41,179,36,56,178,53,39,230,128,252,12,104,165,98,132,4,223,238,44,36,222,188,218,52,250,146,212,148,237,85,68,175,72,79,155,38,36,230,62,122,67,208,138,241,5,49,158,119,106,100,178,247,61,154,161,134,111,198,28,192,44,150,189,7,205,154,142,45,190,172,69,107,176,36,105,64,30,153,120,233,138,210,10,19,201,37,119,182,152,85,43,37,56,68,199,14,82,214,220,245,249,231,141,77,20,190,252,61,102,166,209,230,24,109,225,229,78,195,145,93,109,32,127,163,49,126,248,87,165,80,47,35,155,3,51,50,146,244,105,171,122,226,62,82,242,157,209,37,222,157,224,156,21,73,10,238,198,123,110,60,209,122,158,82,5,221,166,227,119,183,251,80,175,245,112,156,150,175,183,247,162,53,159,213,33,71,40,168,227,104,244,244,210,154,12,114,234,6,153,36,147,203,170,108,85,64,250,110,225,137,2,143,243,163,40,173,220,191,63,210,108,131,154,142,83,175,46,56,41,236,83,221,81,161,144,135,172,99,88,139,115,229,148,143,162,9,203,12,44,238,102,165,234,230,179,179,242,16,227,158,20,196,203,126,102,121,194,246,105,131,73,192,81,122,192,229,32,52,68,139,60,16,102,94,4,190,236,77,238,222,73,240,221,6,252,179,240,56,85,108,237,167,95,168,223,161,49,28,186,57,93,43,203,125,223,42,221,67,47,174,96,56,99,204,115,41,252,252,106,153,180,228,242,100,155,42,105,108,181,215,47,150,176,81,36,192,211,244,135,162,127,189,201,80,62,117,91,125,58,245,215,9,16,165,134,52,42,43,225,155,28,21,189,76,85,226,216,155,133,105,120,60,145,152,6,52,150,149,2,255,255,126,255,45,36,58,37,21,112,25,5,210,187,69,74,195,46,226,170,12,90,154,7,142,228,89,148,22,211,1,150,132,252,99,19,215,135,242,15,150,0,17,251,192,38,133,71,164,62,161,144,240,178,62,63,254,50,137,26,207,233,156,52,145,94,86,239,132,26,146,181,46,165,248,100,14,76,252,16,214,130,195,166,67,120,113,30,255,126,197,11,57,108,130,66,163,177,70,30,223,117,244,53,44,13,86,39,70,58,213,212,230,152,164,76,152,10,227,3,6,230,216,73,88,108,91,245,126,137,58,224,132,168,129,199,254,247,134,142,56,81,168,160,119,44,222,123,230,189,204,92,245,18,227,172,58,240,174,149,68,71,210,183,169,241,146,73,86,210,216,156,250,239,161,219,212,210,69,48,33,137,81,185,192,218,197,2,122,26,76,13,121,61,31,44,239,37,158,126,254,241,131,26,167,224,67,133,125,52,204,195,141,119,131,208,214,151,86,54,137,139,144,178,173,220,170,156,70,125,66,38,125,127,135,146,246,160,95,230,1,248,184,55,65,56,225,139,169,106,17,246,153,98,119,248,67,85,148,28,157,200,233,186,149,138,180,147,37,42,212,190,28,189,109,117,242,168,56,133,17,29,241,89,218,5,242,81,50,61,166,175,124,106,47,237,20,201,235,69,95,202,35,243,79,223,34,85,47,100,252,168,29,171,20,189,109,65,14,156,71,195,246,94,104,211,21,29,195,84,33,131,207,221,120,139,57,78,126,88,195,191,172,133,96,242,110,140,236,227,76,154,55,32,134,193,20,204,21,192,232,157,224,147,175,193,96,9,127,18,107,239,96,240,98,139,149,104,92,151,196,170,198,104,185,117,179,26,20,72,48,36,47,32,86,42,189,173,80,71,219,151,79,181,88,45,26,191,38,133,45,54,131,31,109,115,161,163,34,38,89,40,49,173,198,48,17,40,39,121,77,90,70,42,251,130,168,125,184,76,60,95,94,136,227,248,145,210,226,191,137,247,72,210,17,141,52,5,102,220,23,111,146,114,218,208,22,105,9,130,97,83,57,25,228,137,6,99,12,24,29,89,25,101,217,133,196,253,246,158,114,75,8,90,142,28,147,19,22,164,240,205,1,21,145,19,225,61,98,21,22,215,32,158,9,44,97,148,104,201,219,76,43,45,162,73,151,252,188,155,192,134,113,103,109,255,54,42,206,24,76,87,154,98,187,78,193,50,86,191,222,86,162,165,38,191,118,117,72,31,6,174,147,231,105,158,70,133,79,138,223,55,73,210,90,194,194,112,167,14,253,133,160,197,234,193,24,75,239,106,47,115,70,102,75,122,123,87,158,185,162,180,84,210,222,141,172,125,211,117,181,155,250,182,51,247,178,100,123,8,8,173,224,246,222,40,35,31,171,203,195,36,34,6,53,171,105,219,106,216,77,18,130,182,37,225,3,235,196,203,114,168,7,2,10,14,230,118,6,134,118,20,184,145,213,218,127,110,182,193,145,91,202,110,11,96,118,1,8,96,103,167,236,180,15,141,151,253,100,7,112,25,70,89,121,233,178,158,234,47,68,162,185,146,146,7,74,2,17,238,108,171,91,64,92,173,85,82,121,240,175,136,132,26,123,225,64,169,132,53,192,187,113,8,165,133,192,249,61,166,108,170,2,175,11,243,183,162,93,109,51,151,40,206,39,150,0,84,130,215,29,211,96,200,244,193,206,63,137,9,225,205,195,93,147,70,125,177,146,164,76,247,0,61,118,12,73,75,151,145,218,82,180,207,112,233,175,169,104,180,29,149,4,129,248,70,10,159,34,67,208,4,235,146,205,128,223,104,17,16,189,72,150,29,148,21,85,152,237,97,200,84,57,234,9,165,16,73,40,118,10,18,222,171,43,231,169,211,149,179,250,145,227,129,66,53,2,35,228,99,7,1,101,161,122,247,98,103,47,32,194,21,66,228,215,171,211,95,93,47,71,164,197,154,72,46,73,190,186,131,152,104,252,1,237,94,154,240,6,67,188,57,183,3,28,30,181,14,142,247,193,242,88,231,188,86,198,130,125,97,9,115,137,196,6,38,94,170,51,157,253,197,152,195,181,150,253,125,49,6,217,29,102,120,252,248,217,191,232,176,151,7,118,12,126,164,219,67,123,72,16,146,223,203,183,0,196,87,186,185,173,67,246,204,171,20,21,86,98,182,253,7,186,6,120,189,118,3,229,237,60,53,90,120,139,87,229,79,153,85,139,16,81,100,189,150,202,125,164,42,132,10,163,190,85,177,69,169,181,85,186,64,77,182,99,209,185,183,19,5,1,24,167,247,211,71,7,154,124,136,40,199,61,196,217,202,170,170,93,64,20,178,234,247,41,59,124,192,158,211,128,28,144,37,95,61,108,113,150,27,161,102,97,250,86,162,10,193,27,201,55,193,56,84,164,176,59,172,180,2,117,209,83,226,255,156,104,115,80,9,171,177,196,38,252,19,138,252,29,242,231,74,93,205,161,41,158,79,204,211,0,30,248,42,125,237,167,151,3,163,35,219,102,225,38,80,160,246,91,202,15,81,5,104,108,210,239,193,131,146,27,150,17,171,71,221,84,112,204,146,94,186,237,255,206,118,141,107,20,169,226,15,43,75,224,52,120,186,0,134,235,166,30,237,98,31,139,146,29,104,64,56,3,249,66,92,147,217,211,9,31,96,178,69,148,227,230,101,236,243,45,246,172,39,229,59,69,106,63,147,212,148,179,217,10,220,19,61,36,147,54,173,248,250,238,79,181,163,211,105,11,79,136,249,56,91,202,219,147,180,212,42,140,52,110,222,216,92,215,61,213,55,188,33,239,190,201,255,96,1,215,85,244,86,49,152,17,180,172,68,196,115,71,107,182,243,219,136,48,23,116,210,242,8,233,123,235,101,169,61,55,63,1,51,205,161,189,96,59,52,218,197,250,26,88,73,52,217,104,199,216,234,189,209,12,232,29,210,128,20,244,127,219,15,204,123,222,84,167,249,54,43,174,28,118,186,210,116,176,58,78,38,166,130,144,219,92,43,91,180,1,195,20,39,139,0,25,240,204,75,61,178,95,199,10,3,136,139,50,249,155,86,95,70,214,41,166,76,132,6,166,146,35,118,145,100,203,149,154,211,215,94,104,5,44,83,183,45,251,89,212,57,197,144,82,87,170,120,45,105,80,129,100,131,159,10,127,221,163,246,63,192,154,53,205,6,127,117,223,24,147,216,93,28,239,163,214,221,158,12,149,255,83,88,41,136,165,138,1,254,6,44,25,143,22,104,150,94,24,196,25,238,193,216,170,71,103,76,33,52,211,45,205,235,134,41,248,86,65,9,32,255,32,95,30,250,243,251,43,119,170,184,85,107,38,21,98,231,54,218,226,16,72,174,6,221,38,211,120,221,119,117,120,67,209,251,33,84,155,163,163,47,53,96,15,51,76,204,87,153,85,170,54,66,113,12,174,34,104,136,90,62,76,103,210,150,82,37,200,148,44,89,113,229,33,173,240,114,61,21,131,193,157,216,181,193,207,219,29,42,99,21,186,158,11,145,155,4,216,22,244,162,245,120,63,128,57,117,241,213,60,251,251,149,87,153,99,63,22,75,81,103,103,239,199,225,110,110,88,38,125,240,116,161,226,53,38,183,2,223,68,221,87,205,73,201,187,129,82,39,35,166,109,116,96,250,15,15,242,104,227,86,21,140,48,172,188,54,214,185,33,4,199,217,220,218,185,44,244,170,133,64,135,231,135,80,159,130,65,112,36,250,209,241,226,74,174,130,199,202,217,218,87,161,162,130,254,242,150,34,63,117,178,224,76,211,80,201,111,72,69,137,93,62,24,23,249,115,80,83,95,17,166,84,223,132,120,6,53,34,199,208,205,80,109,133,213,92,49,18,214,230,123,245,73,80,228,94,106,241,165,216,84,255,96,177,178,90,92,5,219,185,153,238,208,136,79,150,15,232,139,179,52,146,235,158,62,239,136,154,45,92,190,176,19,91,40,214,152,149,209,222,247,97,175,74,250,98,231,204,211,233,2,168,136,18,202,254,144,196,95,80,187,220,123,31,164,176,207,23,248,81,3,174,138,206,65,83,36,29,70,32,71,21,227,157,254,228,2,4,215,71,27,252,9,219,49,49,23,248,163,43,170,192,126,75,198,97,91,38,182,93,204,141,250,187,145,128,158,103,88,73,178,191,233,253,231,3,169,38,117,163,181,44,217,91,138,15,239,82,140,19,78,13,168,212,227,46,202,225,130,28,150,211,105,239,25,243,208,76,174,52,37,170,87,125,141,221,90,95,41,51,53,205,112,75,54,129,102,51,87,222,28,117,188,154,174,103,66,55,95,247,97,127,31,107,22,117,195,115,97,108,19,52,70,179,212,190,15,8,213,49,139,119,170,201,169,8,199,203,166,183,90,134,185,169,133,135,9,251,66,104,187,220,182,164,82,21,125,132,197,116,14,169,241,211,104,107,169,17,246,140,46,235,236,23,84,93,180,72,214,10,39,185,197,170,73,30,43,35,75,114,202,126,143,2,127,114,206,107,25,116,183,11,43,3,146,183,121,214,79,26,240,70,203,45,88,74,11,137,245,21,38,44,66,143,61,168,69,76,204,92,186,121,203,15,46,213,237,131,23,220,68,52,188,111,185,48,81,35,208,159,218,44,76,71,236,152,61,103,92,247,136,123,88,196,109,213,91,97,190,88,164,237,171,59,217,231,230,51,149,191,114,162,41,91,249,249,25,109,183,231,25,48,30,35,44,156,199,26,146,144,26,85,40,82,54,83,253,102,88,29,52,114,160,176,0,95,4,217,205,123,143,97,62,149,15,178,195,166,156,183,183,170,183,54,232,197,211,241,7,215,241,86,159,151,161,98,116,91,139,14,111,22,41,155,5,43,72,245,246,20,196,27,62,112,149,21,253,42,111,173,148,25,42,199,41,53,84,169,17,246,92,25,211,161,41,159,252,62,243,4,19,121,43,66,199,74,28,208,193,205,33,126,84,173,30,16,26,179,244,95,188,90,6,16,178,251,191,203,121,130,161,12,52,170,24,14,141,2,163,190,6,52,205,187,57,245,252,9,53,65,132,246,126,90,3,26,54,238,222,74,237,35,163,214,83,43,254,139,112,244,74,15,241,20,255,217,117,129,81,233,181,187,160,29,30,245,145,199,163,29,171,87,228,222,50,229,60,139,23,152,179,33,23,124,180,100,223,209,21,191,93,240,166,209,66,67,28,158,237,190,62,80,188,131,151,72,22,159,212,121,139,49,254,184,106,134,122,77,103,165,81,70,69,174,0,7,179,26,152,234,23,37,155,212,120,59,223,226,216,189,170,9,42,206,10,123,140,130,214,229,149,218,74,215,152,151,235,170,53,33,209,190,193,105,61,182,108,226,176,32,213,78,117,106,23,56,121,61,82,213,107,121,107,114,185,20,99,151,57,44,105,153,238,174,24,192,241,254,251,80,193,143,221,0,58,227,109,190,129,185,22,131,37,221,129,34,101,144,152,33,250,198,183,73,236,69,174,215,68,64,181,94,33,132,40,149,248,252,133,191,99,245,130,21,43,49,211,224,204,33,169,240,230,120,107,228,46,140,168,241,32,17,95,48,147,101,16,176,251,83,160,253,105,171,56,79,198,139,36,48,144,120,99,236,171,235,56,117,196,171,178,244,170,61,79,183,32,202,66,50,130,211,99,78,199,73,255,242,30,138,199,156,129,107,187,182,255,144,201,230,138,199,111,154,10,126,232,144,99,117,187,160,97,221,177,191,5,239,139,181,240,32,249,247,61,216,207,154,217,224,246,49,118,3,194,107,197,233,3,242,99,182,58,45,151,176,238,101,118,57,44,123,195,112,61,129,140,199,98,25,86,104,2,141,220,161,128,109,32,8,89,147,249,11,246,14,255,195,81,233,46,89,37,122,225,211,69,132,120,138,169,254,0,72,208,116,247,244,60,55,28,135,15,11,28,174,65,40,253,148,181,6,57,220,134,224,205,255,225,22,228,49,200,228,182,179,141,237,217,9,47,114,203,57,24,173,236,15,100,174,120,178,73,84,236,141,45,188,142,252,66,85,56,248,161,247,21,240,209,145,198,24,158,227,106,158,18,248,204,21,1,99,35,91,187,157,228,98,106,35,231,158,103,53,119,135,62,168,207,48,5,118,236,117,255,204,65,60,49,102,180,55,82,149,17,205,214,182,198,223,77,55,234,99,156,29,161,90,22,138,7,126,240,213,226,110,63,214,97,71,161,203,216,10,31,25,62,71,223,163,238,97,14,115,144,121,112,103,4,186,16,66,51,105,110,65,111,32,206,82,213,231,74,107,199,255,85,48,249,19,123,45,142,3,104,77,86,181,99,8,158,50,3,108,43,23,113,246,189,180,107,134,24,9,137,36,178,9,176,197,63,33,63,164,220,217,243,175,16,197,210,28,16,109,192,143,193,240,252,44,124,8,108,179,168,171,135,107,32,216,49,136,123,109,133,33,176,167,185,189,30,120,210,5,211,14,127,118,199,147,121,246,58,33,239,172,251,87,223,152,144,13,169,216,65,87,59,132,210,118,116,30,68,72,68,155,103,230,81,33,26,21,82,14,73,251,183,147,86,222,194,97,44,169,244,82,155,95,253,205,116,91,165,44,64,31,163,242,253,93,23,26,209,14,33,97,62,148,115,63,247,111,137,13,9,163,215,243,223,218,10,114,82,195,219,233,24,117,167,173,231,13,156,77,46,231,130,200,122,169,91,49,229,215,250,140,73,229,240,44,212,41,117,112,31,126,218,196,58,241,101,147,26,195,148,98,153,198,104,87,90,149,128,60,239,177,50,49,11,242,239,230,196,182,89,101,80,215,168,143,70,48,53,53,215,22,99,194,129,245,128,163,40,102,25,14,99,189,152,35,135,13,16,105,137,188,32,226,246,176,38,30,36,65,146,145,240,83,103,2,107,133,21,172,41,239,28,250,134,170,228,80,43,122,211,87,111,228,168,29,171,79,69,62,152,18,69,203,96,169,144,83,50,37,65,208,1,113,46,2,67,73,221,2,181,73,185,209,20,163,237,141,222,221,69,220,155,12,177,239,150,84,234,58,111,225,3,31,187,110,139,78,139,234,186,202,73,72,34,125,59,43,206,220,68,6,49,123,14,147,144,206,60,95,31,173,236,244,239,64,11,119,89,226,7,117,175,218,115,104,165,195,209,202,140,132,15,6,115,213,209,69,238,7,89,37,249,156,158,67,124,208,100,194,232,148,52,214,125,166,99,224,152,46,109,187,234,230,51,60,189,191,120,28,13,67,152,105,230,40,147,153,215,16,149,231,51,170,159,88,97,228,216,161,34,87,65,129,153,213,186,140,150,104,113,164,25,120,246,58,78,221,124,33,179,135,7,220,233,68,9,15,123,101,187,131,139,95,177,234,29,215,24,57,107,53,194,252,161,247,70,224,245,22,104,10,41,39,213,190,186,249,159,32,28,196,55,153,225,205,18,72,227,70,120,101,199,237,132,225,10,124,88,154,151,215,153,67,177,100,244,99,169,37,127,97,122,188,216,217,79,187,227,87,69,243,42,139,151,228,79,141,154,88,240,7,29,255,165,129,150,70,173,212,207,194,245,243,54,210,111,168,77,71,140,61,28,64,106,8,196,60,68,154,18,110,22,252,63,172,163,34,138,138,105,145,101,244,110,11,75,95,244,220,224,140,191,243,85,79,137,128,246,173,146,28,1,68,146,131,190,104,107,105,10,183,141,149,204,59,176,190,91,3,180,254,33,47,24,58,4,53,177,211,193,103,6,161,57,156,191,177,108,76,83,185,133,20,167,103,26,75,148,54,239,124,182,71,95,160,157,60,112,22,149,136,53,82,150,241,250,192,35,199,124,207,79,66,84,131,7,63,140,114,16,166,158,30,0,73,131,202,144,116,46,50,92,60,23,147,147,14,236,195,64,128,205,63,248,146,1,49,182,30,96,166,149,196,243,131,88,93,119,167,118,22,137,56,179,169,223,194,48,235,4,196,19,7,210,55,75,235,92,247,15,83,174,53,132,172,34,214,91,205,147,70,34,195,103,132,175,68,245,7,227,205,122,160,7,72,137,123,51,243,8,7,82,113,179,53,171,249,151,156,75,82,204,101,194,53,247,2,201,39,125,151,8,4,189,190,40,95,41,72,181,116,99,58,100,136,118,164,13,191,107,164,69,39,229,204,2,248,254,87,112,64,247,106,105,66,193,73,104,67,75,181,248,105,39,227,153,139,164,41,215,76,244,118,95,99,56,13,94,20,67,33,205,238,108,249,81,105,60,177,18,155,229,73,173,205,78,164,144,180,161,191,210,203,150,190,16,55,228,110,203,212,118,15,103,25,67,152,199,2,36,17,117,201,129,88,197,112,153,188,44,58,196,160,131,198,150,19,223,209,224,90,127,231,71,1,40,82,195,12,242,223,233,211,68,210,32,176,1,106,119,179,211,33,221,107,210,194,227,213,88,3,122,19,130,145,199,16,66,179,41,215,40,18,133,40,191,25,49,31,101,27,16,11,60,119,20,186,217,168,204,250,28,173,159,38,166,106,2,35,49,133,30,16,174,41,134,5,154,247,72,247,171,23,225,89,228,141,14,221,122,56,188,54,252,90,121,252,169,8,168,27,59,138,8,245,70,122,230,65,165,140,117,136,206,11,169,209,146,240,8,234,87,27,21,119,136,227,84,138,65,172,42,227,109,202,167,67,219,148,125,32,179,242,176,224,42,235,163,145,195,63,145,122,135,21,164,85,133,249,38,87,145,90,3,151,203,189,99,172,189,248,86,207,193,226,138,44,42,179,190,99,83,127,92,185,32,159,58,246,239,241,246,235,227,205,219,169,42,77,149,0,212,210,172,47,174,68,122,133,7,78,152,86,30,65,58,84,65,40,113,125,213,150,112,146,1,46,218,175,242,206,243,3,22,233,246,135,129,96,57,130,15,151,104,91,220,169,42,107,34,44,14,229,23,97,55,219,134,96,213,252,133,227,120,195,1,46,17,86,212,120,130,91,248,166,233,51,66,254,106,183,117,42,44,36,169,196,204,173,91,96,109,228,171,28,189,45,250,183,121,167,12,164,164,245,225,177,164,170,138,139,161,93,90,83,85,26,198,104,106,203,108,131,144,196,153,22,188,229,99,101,228,68,84,115,35,112,19,129,18,184,189,228,220,191,206,106,106,126,188,176,42,150,208,166,249,215,76,49,78,167,49,137,16,206,210,203,31,206,130,158,233,143,12,168,123,152,246,181,110,5,9,143,33,8,20,72,188,117,52,80,18,200,90,101,236,228,207,56,241,5,217,53,40,86,180,67,214,216,113,227,232,42,4,123,161,29,225,131,69,60,164,193,158,200,54,177,14,32,137,153,25,110,144,200,246,156,194,61,16,88,79,24,113,181,5,133,88,82,165,176,38,251,156,45,231,111,141,37,120,107,195,254,51,23,243,143,18,30,92,222,216,31,27,168,49,204,158,75,50,29,108,173,189,227,162,147,5,233,159,187,189,71,11,14,221,15,68,223,60,234,186,227,182,193,229,131,242,98,115,34,126,30,59,20,56,101,249,9,38,148,110,79,181,179,181,29,240,61,110,204,161,242,160,184,30,38,49,180,136,78,22,156,1,249,192,217,132,67,3,250,243,132,141,231,10,84,231,97,122,73,28,88,116,105,213,193,202,47,183,216,19,80,71,55,14,123,32,194,193,121,208,234,113,73,234,146,93,189,196,164,129,140,201,122,187,60,67,10,121,125,17,246,192,134,16,58,220,3,66,88,63,127,197,206,164,85,151,11,143,43,109,35,215,25,113,90,99,90,205,22,209,122,41,112,244,206,253,59,161,241,168,251,89,190,186,151,193,3,142,219,1,102,68,147,87,145,74,157,223,203,18,248,51,21,219,92,9,251,196,149,82,153,103,27,151,252,54,21,4,47,205,56,172,183,3,29,202,225,83,16,70,15,21,227,219,225,178,248,157,53,135,57,185,163,37,123,167,126,80,187,41,181,17,191,207,228,71,37,158,205,118,62,248,250,194,59,71,214,167,103,233,25,73,205,178,231,128,78,53,113,28,73,140,86,87,88,87,238,196,137,77,234,138,39,195,39,117,89,71,3,123,115,108,182,175,148,180,142,193,159,155,141,71,168,172,98,136,187,112,36,25,146,98,217,160,17,34,77,55,98,189,208,173,74,117,181,200,124,182,123,12,56,62,149,214,75,112,112,107,126,242,224,85,234,235,172,131,250,233,229,99,14,92,194,36,21,156,167,172,215,243,141,214,57,79,177,104,94,207,160,8,3,102,237,50,84,126,223,147,92,211,221,196,52,130,24,176,159,132,65,156,131,71,126,4,33,143,91,104,28,50,153,209,95,181,28,75,113,70,67,27,109,192,39,174,135,252,172,218,211,94,160,62,199,154,79,251,16,22,195,15,22,140,253,36,242,85,72,147,22,121,33,25,195,83,123,67,179,160,66,85,146,45,114,228,93,116,57,55,217,212,216,31,50,167,229,242,19,107,240,57,124,255,142,191,249,148,74,39,163,43,156,151,201,207,220,46,185,27,203,141,137,15,92,5,101,198,159,181,2,84,128,42,9,10,185,221,175,55,128,247,131,98,98,146,152,8,240,110,121,15,67,233,2,21,145,83,105,182,127,239,100,153,185,165,225,124,59,119,26,175,192,81,4,98,42,93,184,200,34,68,13,134,123,5,43,164,167,218,32,67,79,70,4,196,254,131,50,201,157,133,80,79,208,242,155,224,237,252,110,27,249,238,45,235,77,229,182,93,205,123,32,5,3,78,154,69,213,117,216,130,198,46,105,47,78,76,255,250,230,254,99,106,218,110,21,186,185,71,173,236,91,67,119,59,38,141,202,223,39,183,153,239,2,113,168,121,123,54,217,55,237,94,11,1,190,38,16,170,216,147,239,88,254,229,245,220,108,102,247,55,229,237,173,167,179,231,185,82,226,109,53,81,87,15,55,217,69,204,109,3,164,126,143,193,42,141,227,90,36,226,83,128,215,12,177,216,190,140,85,129,225,224,25,74,141,225,41,192,131,60,180,130,169,191,124,58,1,135,224,63,27,9,138,244,124,167,199,35,2,120,62,25,218,238,78,254,29,125,60,19,72,168,31,194,52,28,70,137,193,242,203,2,91,43,138,248,5,135,204,165,116,67,10,198,121,98,100,238,143,43,94,209,39,162,232,129,176,41,254,158,40,195,167,51,206,48,151,123,55,64,65,233,220,176,238,73,3,129,139,129,242,194,88,95,199,147,187,75,237,229,171,30,89,115,154,239,165,169,235,59,98,63,177,91,115,84,142,203,97,103,79,66,2,91,157,207,14,45,246,75,211,46,69,228,42,158,158,132,228,178,36,163,98,194,69,11,37,186,217,155,206,244,54,125,9,122,128,237,37,159,232,91,68,159,92,116,153,244,199,136,214,88,171,186,117,98,60,171,163,232,45,147,151,123,170,237,130,250,83,244,253,125,237,248,178,237,111,15,63,154,122,147,51,15,60,204,111,139,245,231,228,185,51,36,176,237,79,48,4,150,130,163,59,120,29,126,54,40,104,116,142,238,121,237,189,107,191,35,8,119,113,131,109,108,173,24,9,142,108,8,49,51,202,146,192,173,17,1,241,218,187,124,164,246,139,220,70,143,192,138,152,227,175,189,77,209,86,106,63,119,2,159,194,2,163,89,30,119,83,127,152,98,60,123,145,96,155,67,36,124,94,20,93,243,98,219,253,143,238,124,45,39,226,10,242,116,227,184,129,242,21,192,51,94,97,231,64,148,237,211,59,177,198,10,216,238,62,4,109,230,168,9,132,240,215,0,86,29,251,174,78,233,243,27,50,92,197,253,214,2,123,146,246,222,140,146,148,108,237,15,4,222,247,156,154,132,10,40,151,8,10,70,114,132,181,145,136,176,233,7,169,57,111,204,90,220,67,215,132,40,150,216,152,69,54,80,43,171,67,46,100,140,33,185,115,58,154,35,242,247,6,43,31,174,39,80,101,216,73,40,132,227,201,14,85,37,194,50,3,146,118,78,76,36,211,88,24,220,98,14,33,120,148,222,160,20,160,118,195,167,167,92,128,37,5,53,38,72,206,146,123,57,213,135,200,109,71,35,239,160,169,225,222,136,217,153,92,67,165,51,105,189,47,203,155,237,217,9,216,232,29,225,177,49,205,230,232,177,124,66,19,114,207,198,114,64,45,161,124,66,110,85,157,81,102,32,22,83,53,111,196,27,133,196,169,162,223,120,126,235,105,163,132,221,206,150,110,214,226,227,26,172,30,160,193,251,235,130,209,125,165,77,58,39,115,187,196,165,24,148,33,237,15,73,76,51,191,88,212,165,137,89,220,47,35,108,174,114,48,214,113,39,163,180,185,63,88,233,112,0,120,241,137,168,24,63,138,54,82,207,177,179,66,101,46,177,222,3,52,49,103,68,5,246,78,182,234,55,35,29,9,19,192,144,78,132,224,162,148,96,89,62,61,109,6,178,98,241,196,88,167,22,196,56,11,139,35,94,112,213,134,206,158,24,179,145,144,24,250,44,149,253,67,210,8,0,244,166,243,0,180,234,155,46,191,122,41,93,142,70,154,56,201,66,159,207,162,193,63,26,46,204,221,206,29,100,232,161,225,87,106,130,47,154,66,253,50,33,4,103,71,134,239,65,137,220,222,90,200,221,145,253,16,73,125,66,213,113,239,82,209,96,85,98,196,87,143,30,250,24,217,92,120,23,123,71,64,51,243,204,192,239,147,75,30,170,32,161,187,95,176,78,235,9,173,103,112,9,93,39,55,89,66,223,135,55,158,58,28,249,4,53,46,175,138,48,65,135,70,136,1,162,20,77,236,103,41,150,88,60,162,162,221,75,62,108,114,118,100,40,120,101,241,122,160,0,109,225,54,161,239,188,6,149,136,139,198,177,179,32,43,126,52,149,57,217,226,136,215,201,55,32,213,229,87,28,109,36,223,42,151,98,71,107,140,255,230,206,183,84,127,109,108,57,226,37,11,140,188,250,216,82,32,241,186,122,68,173,128,81,29,57,2,23,81,10,233,198,238,113,91,11,7,17,184,180,159,230,116,147,143,120,21,24,1,220,118,49,16,80,204,12,78,41,111,117,193,98,56,148,193,219,160,156,230,56,126,1,172,183,95,204,229,202,75,218,108,245,33,254,8,58,127,98,209,197,176,100,60,110,139,133,80,43,42,133,200,12,216,121,186,89,171,171,252,220,132,121,46,180,75,79,8,157,91,112,112,34,247,193,147,132,119,236,30,223,101,129,132,197,45,134,84,202,92,249,70,208,211,158,206,209,216,202,106,106,96,1,80,249,182,103,247,124,85,169,42,212,67,245,112,214,156,147,143,216,186,202,197,119,5,230,23,226,199,79,150,253,252,85,1,193,145,96,212,15,165,73,246,244,50,249,165,95,254,252,112,62,100,237,167,234,181,238,164,135,224,175,19,225,82,153,135,122,209,81,59,123,165,21,127,99,54,56,18,153,226,205,161,95,202,7,79,126,124,92,208,244,46,5,176,227,206,200,16,140,97,250,131,187,54,34,117,52,52,206,150,201,200,182,45,201,225,80,46,100,113,199,193,12,116,224,253,59,85,244,248,161,239,199,164,208,63,114,103,163,167,185,246,203,19,33,102,53,236,108,3,205,170,155,230,73,204,142,178,233,7,187,171,191,137,254,60,149,218,98,40,42,87,10,3,146,207,162,67,113,25,173,141,27,217,143,225,97,164,2,208,116,57,181,180,112,233,183,114,62,110,197,29,79,155,213,7,115,94,60,229,43,83,79,119,171,196,20,78,239,233,51,87,6,32,5,59,166,121,176,193,0,2,145,150,183,130,7,36,179,159,57,212,66,179,111,151,174,27,202,58,35,12,121,174,29,17,69,244,46,87,1,173,238,194,40,107,180,147,157,209,184,241,104,251,123,242,164,42,31,93,118,82,79,189,47,105,102,158,30,210,164,16,47,140,226,212,235,70,176,78,30,247,193,162,137,19,102,181,9,248,156,29,149,41,73,2,34,88,183,198,106,254,34,124,19,150,32,99,71,253,14,190,121,107,200,168,38,114,205,153,112,139,204,16,149,101,168,127,70,40,156,157,78,179,113,220,4,46,194,124,96,187,139,83,36,28,169,50,209,88,176,134,217,219,55,18,186,165,170,11,175,60,216,24,132,95,218,101,75,194,66,64,184,1,56,29,86,92,86,243,122,204,124,185,21,219,37,111,68,82,178,41,69,127,186,121,223,219,84,41,169,105,54,165,5,128,102,12,67,130,217,46,97,233,254,216,57,121,145,39,46,34,136,82,175,114,153,215,16,119,138,116,45,137,136,230,59,132,221,97,0,150,250,153,211,18,141,254,212,157,9,45,217,191,16,24,133,130,194,151,189,230,92,187,55,12,247,187,8,115,13,29,222,207,59,92,230,24,146,39,165,2,54,188,107,162,190,178,185,22,188,187,172,42,164,239,225,92,55,26,237,230,59,0,75,13,33,47,250,12,161,72,4,185,159,244,163,208,129,102,176,239,178,99,211,97,92,241,234,19,85,70,42,189,55,130,151,119,38,50,126,239,231,40,153,124,51,220,63,234,208,163,211,170,63,37,231,40,152,183,204,90,227,246,208,8,196,85,209,243,92,102,174,199,27,110,145,27,1,158,35,176,107,152,163,227,75,21,184,120,238,57,155,201,3,194,165,57,117,211,136,236,17,128,98,177,93,111,46,94,137,155,5,70,101,212,42,190,79,218,62,143,123,151,171,59,185,175,9,185,245,254,235,130,177,69,252,61,157,29,229,105,128,229,192,180,37,158,214,254,13,129,64,53,209,247,56,140,241,97,250,119,174,250,204,68,97,184,208,29,20,117,25,12,105,234,224,76,223,115,197,177,7,235,247,19,42,20,85,78,15,81,181,192,153,4,160,176,82,106,67,212,194,132,240,190,45,126,79,192,122,42,28,239,165,14,139,14,152,62,129,78,48,66,45,207,97,240,165,178,129,234,169,234,59,12,218,46,249,54,76,20,225,254,11,128,237,242,61,101,16,36,207,202,13,244,205,77,104,204,51,50,1,5,95,211,151,110,251,255,185,191,151,167,102,140,98,163,129,27,38,60,101,197,176,252,212,232,136,208,157,118,51,83,111,209,188,223,78,130,47,24,91,236,170,159,121,55,3,202,0,155,212,180,173,74,37,161,201,91,108,166,174,27,239,60,20,65,158,225,185,85,89,127,76,244,27,86,150,160,201,13,106,79,143,68,200,236,55,107,243,76,149,215,188,118,183,198,159,26,140,136,153,211,173,159,16,57,139,31,93,149,70,6,141,53,112,164,6,184,239,106,159,222,67,158,26,121,136,223,39,46,140,67,170,202,95,88,179,214,186,212,140,8,12,94,34,77,226,17,17,162,210,225,20,151,177,74,9,100,126,170,73,142,33,144,154,131,151,205,235,28,118,190,6,137,98,50,237,7,94,230,246,133,250,179,160,199,89,103,9,203,111,37,216,185,171,40,117,6,107,87,133,165,172,22,140,220,186,41,97,187,57,196,102,220,15,169,194,254,170,33,237,69,78,127,4,30,119,51,251,153,50,179,106,153,232,131,96,100,243,32,78,78,223,191,150,158,39,30,201,43,12,220,233,103,223,247,156,210,213,52,75,203,102,114,46,35,81,55,175,89,207,53,66,198,247,164,132,51,64,124,120,125,108,35,3,184,185,202,162,122,93,58,198,11,176,146,221,62,6,92,250,135,230,38,135,125,76,89,22,140,243,110,14,212,252,94,85,234,86,142,168,158,28,94,124,183,180,213,174,80,170,142,88,83,48,201,169,249,109,156,83,4,161,186,46,235,85,83,86,244,7,52,58,188,19,124,117,35,105,13,185,191,47,252,142,77,194,147,27,235,193,126,138,65,32,134,118,24,227,33,219,142,48,59,235,147,8,183,94,74,184,233,4,78,44,55,20,167,190,216,145,187,105,253,135,93,68,15,204,76,81,176,255,140,229,106,248,29,154,109,79,247,240,181,62,181,2,28,187,26,136,254,180,92,158,140,81,194,11,245,237,48,28,57,112,87,48,233,185,13,251,113,29,199,152,222,226,254,232,119,199,120,251,113,224,226,89,162,215,74,115,227,118,145,197,176,156,161,226,233,79,170,203,163,113,106,144,108,25,85,163,91,129,143,75,216,56,51,156,13,106,116,79,121,79,152,139,128,156,169,174,94,228,172,49,115,235,134,42,145,67,107,214,122,8,49,156,210,218,178,151,67,247,169,0,56,164,44,222,132,125,193,90,153,10,15,29,69,159,229,98,193,181,138,65,215,14,65,89,116,209,247,174,22,72,27,141,214,94,36,169,203,34,123,25,192,248,196,238,148,225,225,253,59,44,43,96,2,26,21,96,123,202,184,253,55,162,172,81,29,95,172,11,133,235,129,224,183,94,71,85,29,23,65,246,242,222,224,109,136,62,63,145,107,248,167,160,195,242,204,135,237,253,107,53,91,77,34,207,186,102,102,84,28,14,44,194,39,232,156,245,132,232,76,102,63,206,240,49,132,118,211,1,70,75,30,42,3,149,207,174,223,160,227,64,221,207,62,64,74,186,97,163,201,85,231,33,84,76,132,47,66,189,73,137,21,77,184,234,168,231,171,247,76,32,229,1,138,186,116,5,60,65,8,57,133,57,165,125,190,51,105,242,89,1,141,234,53,168,34,89,88,55,63,52,10,226,116,30,115,175,214,74,234,133,248,48,242,17,47,155,75,131,130,124,207,192,199,156,142,142,119,122,3,15,49,119,155,82,80,171,180,19,29,133,31,247,222,9,245,206,244,22,69,12,85,112,250,23,97,212,191,32,152,5,115,206,31,197,19,250,138,219,130,3,84,216,78,11,80,213,13,161,199,128,136,64,7,53,223,221,247,108,10,139,128,47,36,225,149,145,94,106,22,86,14,62,13,43,181,226,188,243,228,218,231,144,137,51,46,13,237,21,72,193,233,132,28,220,20,8,4,122,72,237,253,246,222,239,176,0,105,79,66,248,100,211,232,18,217,109,127,11,57,83,34,123,20,60,137,153,193,152,195,96,127,130,205,193,250,201,146,44,174,91,40,108,105,104,231,248,136,114,61,136,124,241,31,128,186,165,230,218,248,76,54,35,51,13,80,241,46,59,34,214,111,253,168,149,252,124,4,81,171,131,110,58,165,172,223,166,5,45,240,154,11,195,26,117,137,238,192,41,98,219,74,113,235,25,234,46,9,144,57,228,196,138,122,230,73,229,42,31,24,18,166,217,131,24,95,177,251,18,240,249,10,235,122,112,16,73,162,6,70,8,231,108,54,87,216,194,174,60,128,244,234,190,212,213,146,128,244,187,133,74,29,128,195,60,234,120,57,168,116,97,234,156,164,173,42,225,70,177,38,184,43,121,148,186,19,207,224,19,253,214,102,184,227,77,205,223,63,242,184,142,75,134,48,96,96,243,151,83,50,87,123,186,147,177,176,62,113,237,99,50,108,201,126,185,218,219,219,241,171,55,44,28,194,49,254,72,63,140,63,178,112,216,15,3,183,189,172,230,154,116,254,246,200,73,82,76,41,15,168,132,147,25,115,46,90,151,15,180,193,60,237,178,105,74,47,191,86,59,221,105,248,98,26,140,49,149,76,146,83,229,173,71,134,78,113,171,186,136,69,240,102,228,167,251,86,198,107,167,79,180,215,210,44,58,98,143,79,188,44,133,107,54,248,165,231,104,149,127,120,62,61,159,252,239,41,101,177,140,108,77,90,49,230,151,125,115,153,80,213,191,17,98,59,202,149,108,239,233,23,177,26,245,216,97,198,111,31,75,248,67,177,55,207,157,212,233,20,69,111,167,232,80,21,144,9,32,199,43,200,181,141,195,9,143,237,154,121,175,158,247,124,39,117,184,48,30,51,103,4,19,16,28,84,98,72,251,204,19,32,194,90,236,170,52,202,181,96,92,120,59,184,47,169,66,177,66,217,150,2,50,182,17,7,131,32,76,227,116,70,174,42,90,163,89,35,33,148,41,240,228,253,31,107,201,210,198,152,13,86,70,112,248,225,121,155,252,134,99,239,2,8,98,108,44,76,227,160,213,104,141,16,130,205,118,253,123,220,48,200,187,80,35,114,62,45,188,107,29,79,220,169,244,147,158,70,102,122,231,232,149,243,55,230,115,28,185,83,39,179,237,221,41,170,240,44,143,39,216,163,87,213,39,157,118,225,99,80,190,57,171,200,20,2,7,166,112,211,127,0,69,167,84,159,62,190,37,46,1,194,192,152,94,188,50,203,38,220,128,2,108,156,32,255,174,254,89,135,44,97,26,237,37,203,70,32,238,3,218,163,213,145,32,244,50,67,233,217,30,131,135,205,0,46,29,143,192,99,180,144,34,96,7,74,212,164,44,215,190,88,252,138,84,97,50,251,203,44,252,175,247,178,155,79,180,28,8,80,184,205,211,9,119,150,32,91,150,4,102,212,89,217,117,71,241,163,146,90,113,142,34,228,139,182,236,101,97,47,152,88,91,161,47,37,246,4,92,89,174,210,15,82,44,118,249,82,198,192,155,172,220,91,168,190,233,35,204,84,24,113,139,102,112,42,108,124,19,27,148,60,159,78,38,239,90,234,5,193,172,28,58,20,182,11,43,162,123,82,184,178,167,19,172,101,106,3,69,146,204,136,46,70,35,133,166,103,74,245,222,246,76,109,232,173,160,36,50,39,140,112,227,59,10,18,127,30,232,161,113,146,233,102,248,171,205,245,154,98,101,53,109,65,36,82,31,241,200,111,216,27,255,10,48,237,213,82,221,17,250,248,215,19,150,56,175,233,19,230,30,233,199,3,100,121,176,189,175,63,20,231,105,113,121,51,88,188,231,109,177,58,34,9,199,121,226,157,183,76,219,41,224,204,61,144,124,88,115,7,214,74,179,178,42,119,144,76,98,58,171,185,134,98,123,177,87,100,213,183,165,147,22,29,151,19,74,146,102,107,158,201,189,0,79,185,36,105,84,104,73,152,103,132,228,196,39,102,113,158,255,56,212,198,37,172,139,31,238,98,184,182,42,69,108,194,245,23,205,45,21,76,115,162,181,174,59,213,233,59,240,184,32,212,226,199,126,11,205,232,217,187,51,197,98,94,117,94,105,152,41,48,22,181,8,146,134,207,30,237,255,240,248,183,191,187,67,210,16,185,191,54,193,2,218,22,99,176,191,233,78,247,165,4,231,131,62,37,109,244,76,194,155,129,212,66,0,101,223,162,211,13,80,169,217,16,68,4,155,216,61,35,76,162,144,217,34,209,73,249,250,253,186,140,124,41,237,124,22,168,97,40,95,47,38,188,204,216,150,184,229,185,174,113,3,154,126,238,50,165,170,12,27,209,53,157,76,118,81,252,10,140,31,103,160,43,171,6,65,205,225,154,85,121,76,216,228,29,241,184,200,160,225,86,4,199,137,80,222,199,30,9,163,177,222,131,91,24,3,147,148,250,20,157,246,166,73,41,246,240,159,85,53,172,227,255,239,211,188,78,85,210,198,63,175,149,47,251,126,139,167,245,143,5,212,41,111,52,133,173,37,114,122,63,214,212,6,98,213,169,140,241,226,233,95,47,169,91,89,117,116,228,30,78,123,163,137,11,19,142,70,121,166,215,141,20,57,100,202,75,131,150,222,136,204,79,199,205,220,46,9,129,92,116,55,148,224,138,82,32,255,250,251,59,239,99,130,13,77,106,233,191,37,70,164,141,160,195,95,192,54,39,178,189,46,17,135,160,255,198,62,249,69,57,5,74,22,165,134,209,143,179,8,28,219,212,141,148,242,233,231,171,234,72,186,111,252,84,120,130,253,206,225,145,123,88,19,194,150,24,168,247,191,92,162,203,56,94,55,72,199,142,76,50,37,253,13,142,159,201,100,153,149,243,217,240,192,204,254,66,239,13,23,161,166,210,210,120,35,7,141,179,109,83,57,146,163,16,195,195,129,214,39,34,155,158,29,244,128,143,18,233,121,150,87,80,227,145,22,207,133,15,10,172,79,48,176,209,68,66,116,22,167,251,162,90,108,98,148,98,84,46,164,185,106,48,68,247,163,112,24,15,78,105,58,173,251,63,10,252,91,83,158,57,178,63,21,40,113,231,82,251,191,134,27,71,131,203,150,222,121,48,211,181,0,62,91,119,123,77,252,183,63,204,142,239,211,87,244,129,213,2,81,221,210,104,182,252,35,116,91,198,172,132,76,148,89,3,74,8,96,232,19,70,18,232,128,18,145,133,229,23,13,93,175,174,68,105,55,192,81,168,1,142,132,193,37,99,188,243,51,14,26,6,195,29,149,159,115,77,169,235,22,66,101,37,224,43,146,152,141,191,222,67,12,74,51,124,129,141,11,37,97,10,50,79,112,123,54,180,89,156,10,237,145,90,99,35,116,84,163,249,196,70,103,144,16,14,13,233,42,5,213,163,203,205,92,6,212,210,195,46,141,24,15,1,215,71,30,31,0,4,24,15,93,217,35,228,173,104,78,117,69,140,243,168,119,62,223,200,171,123,57,184,88,64,53,21,153,201,0,115,146,22,119,84,228,16,189,124,213,148,92,15,178,58,83,69,87,213,137,150,254,92,197,211,157,193,255,150,115,3,222,48,64,41,28,208,245,211,29,135,30,54,205,250,93,94,57,155,196,37,151,90,109,165,11,249,203,106,37,64,103,100,206,108,40,181,36,238,104,208,241,13,26,75,32,133,101,47,132,226,199,174,3,139,186,102,206,19,21,6,166,44,184,63,7,255,61,155,90,233,60,161,86,176,23,97,194,237,176,234,251,116,25,226,11,145,130,13,179,158,222,252,26,235,132,202,117,229,195,232,158,52,183,96,47,219,235,210,51,146,103,15,241,22,194,84,73,169,183,142,81,87,203,6,251,105,254,2,56,164,156,137,219,71,205,59,144,217,70,38,73,57,73,70,131,114,20,249,181,50,184,200,127,251,28,30,92,166,20,252,156,141,128,223,214,176,136,154,210,238,245,131,123,1,114,106,160,197,74,57,4,101,162,185,66,93,219,192,225,68,181,231,74,140,180,121,162,114,142,129,187,73,66,192,218,128,28,39,134,251,0,243,48,55,112,205,204,80,144,149,109,100,247,179,224,228,198,89,225,7,131,170,203,32,130,21,23,249,122,134,208,160,239,23,10,91,107,175,27,56,59,104,18,71,209,245,4,165,227,203,178,69,1,114,130,119,193,171,64,18,182,174,155,16,84,193,55,150,153,90,251,6,94,161,253,223,200,143,16,162,175,93,211,88,243,61,118,144,204,158,163,68,183,243,85,64,42,52,155,32,39,213,93,165,239,188,8,152,93,228,136,71,213,103,158,57,252,54,203,34,230,180,127,56,46,22,5,220,190,103,131,16,64,135,114,68,112,125,205,54,108,113,157,5,31,108,20,138,80,149,170,6,114,65,223,21,159,246,115,158,118,220,203,106,20,66,204,213,59,225,109,136,122,206,137,104,126,66,24,195,83,223,112,36,241,154,219,254,255,248,77,142,202,95,86,171,11,42,188,7,245,217,138,49,224,34,61,121,28,57,25,3,70,9,40,108,107,108,211,160,206,154,77,59,153,161,172,200,23,84,154,131,94,122,115,145,19,13,234,127,86,154,80,149,41,50,98,186,251,36,10,53,159,223,103,104,248,67,154,136,228,46,83,243,36,33,221,157,116,83,109,54,89,171,46,252,120,86,50,220,23,252,185,68,192,125,37,223,233,232,110,16,135,71,175,199,37,75,162,17,48,41,32,39,131,59,145,161,20,26,149,216,99,1,188,240,87,189,8,24,224,227,175,207,156,151,37,76,105,62,202,86,172,9,208,0,186,72,213,78,103,254,132,192,92,113,242,42,224,245,111,181,206,107,130,182,212,63,185,27,28,41,112,220,209,148,172,7,140,225,168,124,67,203,73,76,139,41,226,87,30,125,197,216,76,36,160,168,194,202,181,254,134,0,148,187,242,94,239,72,9,21,148,168,92,66,161,144,73,37,106,39,176,127,116,44,183,89,77,47,138,171,10,169,117,147,107,92,29,184,69,82,220,13,130,34,214,197,214,6,152,46,180,228,77,211,162,47,149,169,145,56,196,174,84,97,93,246,216,30,34,211,137,93,8,161,64,73,106,220,60,107,201,86,86,124,51,9,66,244,168,8,22,125,147,200,68,23,23,247,75,139,87,52,54,5,53,175,14,218,127,126,196,104,220,88,75,122,52,99,226,111,88,137,95,199,196,6,2,87,182,200,67,133,205,210,73,174,53,64,12,134,84,182,73,199,7,65,88,7,24,83,187,31,81,35,236,229,37,177,78,42,143,233,94,241,133,195,255,185,7,218,41,43,231,129,3,23,175,147,37,26,188,70,161,146,126,24,12,38,104,96,209,143,227,254,9,198,24,192,4,227,59,174,32,240,251,5,34,127,186,184,83,193,62,41,187,33,39,239,28,16,118,164,36,171,230,136,212,122,52,86,39,165,85,61,117,145,179,83,209,229,95,227,85,170,136,187,59,115,217,179,60,48,21,67,116,58,14,145,89,89,35,229,5,152,217,138,26,10,189,186,35,83,210,174,165,179,87,168,247,177,43,213,204,247,37,109,164,15,182,108,253,170,140,83,214,151,0,211,81,132,64,43,30,248,18,149,11,44,248,98,107,216,117,38,96,167,82,124,152,140,191,51,40,145,207,31,45,189,144,120,151,236,172,94,196,233,80,172,227,217,187,197,174,24,108,153,189,212,51,44,156,203,149,74,222,95,240,202,168,235,255,91,215,29,201,254,8,156,120,134,162,218,172,153,51,254,189,4,238,93,65,227,158,247,6,74,254,126,91,58,204,84,167,188,223,91,180,79,147,62,150,135,231,158,186,185,126,91,13,115,56,108,78,17,205,175,102,47,20,157,73,175,89,225,242,141,119,215,191,236,127,186,252,109,87,164,233,22,213,98,137,134,97,78,12,13,150,30,160,164,149,154,108,167,156,104,67,228,187,152,143,135,114,154,47,7,21,89,131,179,34,253,135,40,109,220,0,127,213,82,85,64,161,1,113,242,240,66,56,78,225,32,59,26,177,12,19,79,6,212,120,217,177,7,187,76,85,122,133,9,219,81,118,109,201,21,119,47,122,30,190,208,241,78,63,16,91,45,44,253,13,228,18,228,187,96,222,132,166,77,100,226,124,234,61,59,174,40,117,26,163,5,65,107,1,95,18,170,126,100,95,216,113,98,15,186,246,133,3,205,221,228,159,206,212,201,240,175,113,198,72,187,233,28,104,253,239,168,246,139,120,149,143,34,146,39,220,145,216,114,243,109,219,151,117,75,33,162,197,181,62,19,128,118,215,96,101,54,68,109,7,171,133,54,145,1,15,56,224,58,123,172,196,221,3,133,158,85,120,21,246,153,166,1,17,66,48,223,247,230,95,15,223,253,250,109,197,6,190,76,117,7,245,185,143,129,188,191,215,198,20,90,194,172,250,78,233,102,182,120,92,116,208,65,80,84,235,77,57,207,221,127,16,225,96,218,22,104,216,138,195,220,101,236,3,109,87,42,198,95,96,164,202,48,107,45,17,107,246,2,243,229,149,152,83,101,228,91,80,183,254,119,138,201,64,197,135,212,15,171,151,44,69,249,208,188,57,253,250,157,63,153,226,131,155,3,224,56,103,144,28,200,229,192,71,131,21,129,219,235,31,205,144,191,146,253,77,67,78,216,241,242,228,244,174,123,254,65,212,26,35,218,100,1,28,145,247,37,254,116,206,212,40,200,241,209,30,238,181,165,198,211,144,87,158,142,226,70,232,172,134,42,41,121,222,108,17,68,45,47,16,56,26,77,188,99,188,115,118,252,245,11,51,25,44,27,128,31,32,221,54,158,109,102,53,155,4,245,73,26,234,174,198,111,64,52,171,213,56,173,114,145,152,204,191,140,179,22,93,211,35,243,221,136,103,201,155,0,41,110,183,62,30,176,252,190,108,47,23,203,166,160,173,17,124,11,189,244,44,4,13,133,74,224,19,240,200,254,27,57,180,193,89,67,10,147,117,127,169,109,96,98,8,10,21,26,37,181,81,247,202,60,172,58,139,237,116,143,140,46,52,176,49,71,231,243,80,161,14,219,152,25,62,178,232,150,162,47,124,122,155,221,61,212,160,224,158,136,39,24,24,159,93,108,6,145,49,245,189,95,22,153,45,100,83,225,12,97,201,53,242,6,2,23,210,62,108,106,189,178,189,42,64,247,93,171,233,157,196,159,103,239,240,111,60,164,43,151,83,198,183,204,37,185,207,113,120,130,103,10,4,90,144,149,54,51,128,82,233,108,119,172,85,82,79,203,25,184,22,113,202,100,46,34,121,95,234,102,43,243,242,211,223,171,133,152,188,18,134,67,47,2,94,11,17,249,254,0,115,150,132,37,136,76,84,42,91,153,219,138,4,233,91,164,1,243,162,12,134,75,244,55,138,40,252,182,74,245,239,39,45,157,106,56,118,130,15,190,210,138,155,237,239,57,182,77,69,190,113,237,27,178,173,214,149,95,133,12,106,208,89,63,129,174,51,58,43,142,103,103,138,109,123,39,101,45,171,1,233,54,34,208,63,121,151,241,39,0,207,133,172,100,150,134,5,196,133,184,171,253,201,139,186,75,242,123,53,174,38,249,95,72,254,64,108,209,147,37,177,166,69,3,178,95,255,47,41,195,232,6,73,119,89,203,225,150,80,125,183,56,28,82,112,89,167,237,204,73,139,208,233,7,168,90,35,244,133,50,216,254,240,80,227,187,102,135,27,213,192,201,21,175,236,199,100,103,36,247,192,4,133,40,125,16,111,25,177,101,37,180,170,49,230,106,169,123,73,58,231,60,106,230,145,116,211,215,134,199,90,18,243,210,29,225,79,224,248,108,204,147,215,73,244,75,154,145,95,137,151,193,154,146,43,242,175,5,62,42,113,9,57,70,59,133,75,165,250,154,186,143,167,22,47,252,137,102,87,181,104,147,207,195,205,88,18,48,209,126,182,35,179,10,30,175,25,163,6,202,85,185,99,52,208,20,19,242,169,14,253,227,198,85,129,68,11,99,112,59,79,142,105,188,254,123,148,88,153,70,89,84,106,236,34,181,241,51,194,138,62,14,134,245,151,117,235,135,10,139,140,204,146,196,96,242,114,217,131,102,142,129,65,132,108,64,29,42,233,238,33,19,249,17,222,195,125,158,124,202,110,18,183,150,111,199,70,127,8,180,135,203,33,143,230,228,90,44,43,118,241,57,168,162,89,150,106,102,32,60,250,93,143,196,239,12,214,171,73,180,196,199,210,115,112,192,13,9,123,222,213,148,91,19,101,236,101,30,146,43,164,10,156,101,112,151,65,89,151,245,154,56,37,194,99,153,35,80,3,93,62,246,6,68,42,34,155,207,230,215,121,37,213,153,36,165,136,123,181,144,31,215,138,161,118,151,196,108,131,138,93,13,158,182,138,197,184,0,44,139,70,0,204,15,179,245,235,111,229,61,119,1,248,135,70,169,50,116,69,16,223,77,223,248,176,81,63,205,104,150,100,178,216,215,7,243,251,58,16,117,59,213,117,122,156,183,0,72,126,132,100,86,92,240,106,174,220,88,51,75,166,111,176,139,229,215,30,173,166,246,249,201,187,24,250,69,150,214,224,9,17,218,53,173,213,254,11,60,19,32,202,124,40,131,51,99,223,226,217,190,252,29,14,39,73,199,37,180,254,114,46,169,46,109,205,172,86,62,198,113,209,186,149,211,122,42,239,238,71,133,33,39,217,86,131,68,199,243,26,0,143,97,215,140,217,34,11,55,192,118,66,69,203,200,128,171,40,250,94,127,204,76,168,232,153,226,37,150,4,8,22,177,75,64,204,39,19,45,127,173,174,14,222,159,184,66,88,61,250,133,231,114,166,164,33,157,77,203,31,222,189,111,131,178,107,117,10,165,203,18,211,117,188,134,254,238,158,123,143,231,245,189,89,21,88,66,169,241,24,26,210,108,105,249,56,37,196,36,26,110,237,31,34,198,114,72,218,133,14,40,38,0,26,218,130,56,146,228,86,253,43,36,112,162,58,232,178,162,105,114,186,74,187,229,215,195,101,241,14,24,95,246,248,101,255,68,164,79,41,18,245,65,11,228,167,132,169,52,170,196,91,52,224,204,230,105,193,231,254,49,143,85,42,221,140,233,18,131,116,86,127,103,136,113,15,23,95,39,90,226,59,168,56,73,43,227,171,60,251,5,66,24,207,129,225,168,127,243,190,108,173,215,76,110,107,75,120,242,147,252,217,57,234,116,1,133,221,90,162,174,126,61,236,200,53,105,71,155,217,56,85,6,214,13,60,119,234,225,200,186,152,215,237,225,105,85,252,240,252,38,75,220,200,6,243,144,34,127,161,14,197,107,63,75,235,195,72,44,27,244,129,243,201,59,241,45,173,62,200,145,232,76,142,208,183,15,77,119,157,26,157,170,159,104,206,13,248,132,68,229,234,196,252,168,229,154,203,44,177,54,200,235,132,93,52,10,196,60,152,226,220,27,98,85,215,82,144,161,12,76,202,47,71,231,225,223,105,35,201,195,174,188,10,168,199,141,255,108,74,166,226,33,4,203,54,202,178,27,127,250,86,181,225,246,70,219,65,173,49,214,202,71,22,67,184,54,90,182,251,202,40,14,235,63,201,190,75,65,15,33,62,81,56,157,55,187,67,3,223,5,188,105,211,72,202,95,229,207,20,1,219,121,116,56,5,116,227,97,48,200,192,252,86,238,56,125,89,89,89,100,76,5,180,81,31,33,111,202,211,182,51,25,81,28,239,153,125,85,67,149,136,118,157,65,84,65,43,74,86,81,238,45,7,227,222,145,234,95,152,157,225,22,53,47,59,189,252,16,40,26,171,155,247,98,73,206,206,218,9,241,152,213,3,15,107,123,100,86,78,2,200,194,8,78,101,235,150,113,69,232,13,102,131,200,41,240,126,186,238,184,20,62,218,235,221,116,53,44,20,219,104,254,112,139,81,119,100,253,105,53,62,247,159,166,75,128,64,51,7,193,108,154,115,34,146,127,75,102,17,112,81,35,33,255,104,228,11,97,24,252,219,214,122,235,2,28,34,128,252,220,126,248,87,48,200,149,102,191,135,59,48,111,142,210,22,87,41,25,209,90,114,67,98,234,128,53,45,198,155,116,161,66,14,216,226,63,200,18,7,20,213,60,221,77,128,48,20,142,208,197,61,210,161,90,77,80,146,220,80,168,29,93,171,234,195,182,134,136,225,120,206,94,147,141,52,199,5,155,74,143,12,252,50,79,254,135,78,145,222,143,150,128,28,137,206,79,88,83,195,0,213,182,223,225,201,191,235,235,39,175,202,211,139,11,109,8,255,251,237,232,33,37,250,169,184,42,115,205,55,220,211,160,190,225,201,208,87,227,181,15,92,123,111,172,104,71,23,236,206,214,177,119,77,128,149,238,102,224,147,48,143,82,158,83,179,110,112,12,75,86,190,48,208,14,156,92,140,55,64,14,23,106,204,140,48,97,72,62,247,14,217,121,31,224,171,233,69,177,129,185,71,17,87,96,138,78,19,178,198,229,37,235,51,51,208,149,100,111,39,54,197,126,215,245,125,0,18,64,157,246,4,183,62,21,82,209,182,193,74,163,255,99,143,38,119,30,171,116,62,129,241,64,167,205,128,48,19,141,208,126,96,231,17,94,11,123,106,132,252,127,95,4,217,84,100,231,9,56,144,178,55,92,107,154,194,164,113,19,93,117,152,188,49,241,135,95,131,177,63,10,247,179,86,47,153,63,125,70,239,205,3,48,196,135,152,123,146,5,229,21,112,255,72,4,180,42,148,238,234,211,163,111,223,49,176,36,101,182,121,145,65,242,151,27,181,100,235,212,127,238,78,165,2,36,188,117,89,217,137,39,32,249,156,72,106,48,65,177,35,119,166,109,125,93,15,74,133,194,177,8,208,79,4,23,216,37,3,20,67,12,40,52,11,160,213,96,177,234,40,240,251,19,126,81,186,153,249,204,11,91,78,70,238,38,31,243,13,156,49,165,95,148,218,155,179,139,30,216,15,153,27,164,59,189,173,159,141,146,16,21,167,183,161,203,82,140,66,150,182,16,73,40,176,102,55,118,132,173,249,137,117,137,145,90,53,86,164,24,152,171,14,64,192,181,253,238,22,204,59,115,228,173,155,232,15,108,250,14,135,190,177,25,54,114,152,83,38,132,125,185,243,134,112,168,170,99,100,155,125,107,46,165,146,10,12,243,170,39,155,195,220,140,129,9,27,178,166,144,112,200,134,3,146,228,27,60,217,251,147,93,72,56,196,158,217,177,53,113,146,111,93,172,7,71,165,196,105,120,164,255,79,158,235,183,45,61,139,128,87,87,24,202,89,236,50,129,135,90,217,225,115,211,102,32,22,124,87,167,76,209,47,193,179,5,176,1,172,115,53,235,4,198,69,17,146,1,156,60,169,171,3,154,137,1,8,160,180,39,33,145,194,221,167,74,225,147,22,226,175,161,190,155,99,104,36,234,28,206,255,153,106,146,140,248,208,160,159,129,189,81,79,151,34,57,191,19,60,238,132,173,126,112,102,40,167,236,248,169,15,165,62,167,248,117,241,242,52,190,179,82,62,174,253,135,166,242,116,101,164,25,44,212,205,199,182,51,26,85,54,11,16,243,103,183,145,84,222,115,193,84,191,14,243,49,214,76,187,20,39,29,243,173,156,181,219,109,64,24,75,52,179,28,160,231,99,85,33,44,165,96,91,1,116,151,203,247,43,74,128,179,172,198,31,77,89,11,160,120,13,159,140,72,217,110,79,78,206,233,178,98,50,152,74,216,73,133,249,217,70,75,56,129,241,107,234,100,37,103,60,16,188,2,190,11,70,104,226,153,93,247,153,143,161,19,20,220,168,207,59,231,145,117,83,136,104,18,107,25,84,26,105,116,169,98,24,122,32,236,228,193,206,223,235,29,238,49,143,225,2,196,58,61,127,140,102,14,140,100,86,158,130,245,106,213,21,195,130,77,170,38,87,189,28,239,43,9,141,221,172,71,101,23,117,196,97,176,152,245,228,11,197,252,84,206,70,36,202,196,205,27,80,137,39,25,75,180,73,162,224,150,97,44,115,24,151,153,239,190,250,64,81,124,193,49,199,158,225,239,216,251,150,194,11,43,136,66,171,93,122,163,101,50,248,76,30,251,201,114,80,75,69,109,212,155,11,141,217,118,95,15,127,174,149,147,216,251,178,89,253,92,51,157,16,128,60,144,26,219,47,131,125,182,76,241,164,209,6,26,7,92,85,220,173,245,230,208,98,209,124,70,173,192,190,132,55,211,201,186,183,60,108,73,202,134,11,25,98,22,219,173,173,140,39,222,243,91,17,177,81,168,144,244,94,105,34,211,227,16,134,9,254,20,51,4,182,243,203,82,63,238,89,246,230,147,185,200,52,129,113,141,167,177,99,18,247,119,52,84,13,203,187,89,98,35,178,30,13,149,205,77,136,197,164,183,202,225,132,158,34,253,166,180,170,81,56,53,16,116,34,149,120,212,66,17,226,5,193,175,148,81,251,230,23,177,141,43,79,103,153,84,172,51,44,242,34,237,188,74,225,118,144,129,40,56,96,157,254,134,231,14,209,110,23,26,41,253,29,33,247,80,149,196,100,34,23,183,198,124,246,191,174,56,254,31,119,127,229,154,236,190,38,98,101,91,126,182,201,156,27,210,62,101,17,18,95,17,62,112,173,218,95,8,203,29,169,3,23,137,111,219,234,54,156,50,148,31,227,60,56,205,74,105,149,45,57,162,39,83,232,38,150,169,204,161,15,212,82,220,124,196,127,1,123,135,186,208,13,210,224,127,223,143,131,107,123,201,10,21,58,99,135,64,212,81,242,174,16,20,198,65,72,42,58,79,59,206,26,52,133,57,223,232,6,119,87,13,47,214,82,42,153,242,77,203,163,205,22,188,0,129,78,179,114,86,63,119,183,248,180,74,200,49,174,239,118,170,130,129,69,61,251,182,192,219,239,214,192,255,58,247,26,49,105,232,74,79,103,145,214,114,231,134,233,230,182,242,244,118,246,117,136,107,207,19,107,184,247,251,123,157,189,96,101,189,162,223,179,99,10,86,165,128,163,231,16,244,57,68,233,20,250,104,28,166,38,49,110,177,66,17,127,187,199,42,122,137,238,193,107,95,247,227,189,113,10,75,176,213,70,136,141,144,164,87,37,42,23,127,141,164,183,78,139,218,128,235,216,244,18,237,172,200,24,113,21,112,117,16,59,41,136,9,155,210,169,170,75,221,91,65,24,147,102,178,110,106,220,193,124,222,37,240,191,119,132,54,85,182,115,221,35,234,48,168,174,45,235,227,126,189,190,94,228,240,101,211,112,91,127,57,151,48,255,55,129,17,139,254,252,80,114,75,182,22,51,188,91,109,69,192,230,36,179,138,232,162,3,131,1,137,52,56,241,139,77,224,236,177,175,210,192,80,187,135,105,224,116,81,229,132,151,223,232,67,207,191,76,55,255,26,58,42,239,48,161,0,251,40,166,214,231,173,40,122,99,165,8,170,84,14,152,38,0,60,172,198,70,127,95,75,16,127,6,6,164,64,141,172,238,59,222,131,224,43,38,141,127,96,100,62,2,30,34,180,54,230,3,150,5,231,193,31,96,61,201,7,121,144,136,49,68,114,1,180,193,165,67,117,98,92,230,45,153,167,120,227,39,220,201,40,218,176,242,79,255,176,197,84,44,219,188,24,123,109,252,180,10,54,56,205,152,158,23,34,226,122,114,118,86,190,135,145,210,139,53,111,80,254,12,33,99,114,50,69,174,102,63,40,134,203,163,241,201,210,132,197,30,194,21,41,67,111,169,59,137,176,140,87,223,35,219,148,41,17,47,87,132,177,195,184,155,62,44,57,51,61,166,176,0,78,17,239,248,132,24,90,111,0,114,11,243,116,156,217,62,172,237,169,184,102,49,203,132,170,173,228,19,92,247,110,129,213,51,246,166,189,117,14,122,133,32,168,49,250,110,109,130,233,47,207,247,73,245,53,4,163,18,37,68,143,96,159,144,46,41,170,94,167,114,150,192,69,209,251,219,13,111,213,186,98,240,94,100,151,249,137,215,40,31,202,233,102,233,87,154,45,180,231,125,239,156,180,218,112,223,97,62,42,141,65,252,126,67,80,247,250,233,208,232,35,192,160,163,194,226,126,10,45,236,6,185,108,216,204,37,163,11,79,111,48,215,146,155,158,134,141,203,55,89,61,222,33,78,82,125,74,58,124,11,39,39,25,125,19,251,109,165,69,192,6,62,4,243,172,60,180,97,171,114,245,37,98,216,173,83,172,42,223,203,123,98,129,233,163,55,50,102,117,207,223,131,8,155,151,246,17,163,194,153,249,69,72,100,93,139,51,97,70,143,174,24,21,44,73,67,97,203,26,232,224,113,226,185,74,242,203,51,164,179,209,188,168,1,102,93,74,120,214,135,191,193,209,7,112,218,199,145,10,92,23,239,226,242,205,187,159,126,171,125,35,158,53,118,74,19,183,224,31,116,118,13,32,211,205,92,131,123,48,181,32,124,7,233,247,254,24,251,109,189,0,184,187,80,73,194,94,100,239,81,170,145,20,235,132,230,56,141,90,22,151,198,88,153,66,134,20,94,237,62,58,110,218,255,50,111,198,109,211,202,21,39,7,30,238,147,85,35,154,58,236,112,221,70,102,211,120,115,74,109,188,70,229,214,191,122,134,120,195,231,217,122,35,113,9,110,154,50,82,32,35,111,159,191,205,52,223,124,250,77,32,228,68,131,215,255,245,107,10,80,105,104,31,4,173,207,219,31,219,171,182,182,254,211,181,183,202,185,238,165,167,38,248,72,193,90,249,154,165,80,64,209,68,160,49,226,93,135,143,48,97,211,47,187,29,120,160,203,115,39,87,245,227,220,244,5,60,57,251,126,42,117,244,81,69,98,77,242,210,249,188,19,130,253,198,56,95,174,249,187,185,215,132,16,226,25,29,180,25,54,143,69,121,134,79,117,180,218,210,211,236,58,207,231,69,104,95,149,166,212,59,105,131,68,83,21,233,177,143,135,83,237,99,3,20,58,123,234,249,128,199,117,238,163,124,52,215,100,124,76,146,61,253,192,135,196,87,201,115,149,98,141,214,85,252,207,188,13,34,208,166,93,132,22,39,44,115,121,203,93,78,137,69,196,253,197,120,148,36,21,208,5,95,43,5,122,145,41,160,12,117,201,143,36,62,133,73,185,73,185,155,194,182,166,248,96,33,9,112,7,42,39,42,203,253,23,196,161,187,66,234,58,217,44,48,7,139,47,158,58,153,179,83,189,27,100,164,156,234,199,98,117,100,38,11,24,163,169,221,244,159,173,191,177,229,194,60,25,229,142,239,38,104,95,145,238,47,214,188,90,21,66,126,66,111,210,228,101,36,242,172,130,97,234,90,20,62,166,38,11,198,159,44,245,249,131,27,135,234,87,83,2,62,185,253,129,60,125,165,26,164,138,148,193,87,246,201,45,72,3,33,31,191,29,45,33,15,238,109,8,39,100,38,195,128,83,7,133,205,161,144,113,161,194,75,111,13,7,188,92,227,251,80,96,18,64,26,145,25,40,183,204,243,127,122,119,214,146,16,231,175,187,101,92,23,25,172,45,195,139,252,212,135,73,86,24,33,203,30,64,143,202,39,238,180,143,39,141,32,30,65,76,186,57,211,14,143,45,98,183,16,106,103,221,249,6,53,137,24,139,142,183,198,247,95,139,222,54,254,33,32,110,206,70,243,213,3,192,199,172,149,164,83,182,93,148,177,50,21,141,173,13,238,107,195,127,67,110,37,112,43,142,183,230,190,209,160,162,156,23,27,134,24,34,52,140,72,249,61,178,169,148,8,130,66,147,91,31,208,121,252,240,86,4,49,94,172,145,170,231,175,155,91,81,34,65,35,19,119,54,89,16,204,192,75,121,73,147,188,144,117,13,228,38,41,170,216,212,138,219,190,30,66,160,168,25,44,46,139,91,239,138,252,75,214,254,70,38,167,102,27,83,199,3,87,193,132,173,198,46,20,126,199,149,77,169,28,80,101,104,137,62,96,184,186,195,156,232,54,165,152,181,234,109,221,187,146,210,235,81,120,213,202,4,54,76,73,143,91,58,186,245,234,169,42,230,22,18,250,90,107,166,223,111,105,64,154,164,4,224,90,136,137,59,115,161,111,33,203,195,109,85,228,153,230,42,60,71,72,5,2,62,18,247,95,210,226,191,18,86,215,250,188,187,220,235,252,237,222,248,38,43,49,68,167,200,78,234,221,147,5,179,21,224,63,87,13,134,86,163,63,36,111,99,183,191,107,252,17,109,125,244,237,227,124,248,96,249,123,151,124,55,89,15,60,83,228,51,167,78,178,149,160,185,115,84,80,74,205,223,140,130,90,11,7,178,123,40,235,140,10,228,159,27,22,21,27,35,97,198,101,3,45,152,101,159,133,198,240,50,167,96,88,76,87,206,44,39,249,11,105,101,233,91,94,0,117,182,228,62,63,40,7,175,93,108,94,109,10,13,105,155,235,242,84,115,42,225,207,146,64,214,155,15,160,204,116,101,205,129,106,90,130,161,1,205,66,106,134,110,197,2,121,251,255,76,57,17,131,177,22,249,53,191,239,3,209,175,23,202,194,236,120,82,27,150,175,201,140,218,92,66,6,242,27,242,72,21,153,249,76,147,161,201,108,133,37,82,63,157,26,16,157,157,53,227,144,45,33,251,159,166,102,14,146,8,130,61,71,232,239,55,149,154,94,62,201,196,46,66,64,182,197,173,177,174,129,184,239,93,144,26,35,78,229,198,0,35,11,0,24,58,31,116,17,14,148,173,217,199,57,30,154,70,63,65,205,96,139,15,161,221,167,15,248,53,144,210,247,198,28,89,183,77,185,161,137,46,60,33,250,124,201,6,162,14,149,173,139,246,183,196,97,174,62,140,41,85,124,32,241,157,180,188,116,43,88,101,206,143,162,87,136,175,53,8,137,29,26,223,233,139,150,187,232,66,160,175,236,60,249,74,124,88,0,169,71,249,158,190,158,10,136,161,14,192,129,205,123,206,139,139,194,116,10,232,178,229,135,29,133,175,175,159,206,251,200,116,49,111,179,231,204,59,114,82,198,44,18,188,92,104,214,214,0,99,131,131,20,13,139,95,163,166,89,240,125,147,162,92,27,236,208,194,108,76,213,90,135,100,0,183,53,71,191,95,49,61,227,177,149,62,19,73,102,79,254,208,162,75,217,114,173,130,116,114,179,103,102,51,151,84,216,208,210,52,137,180,99,72,124,128,249,247,136,183,36,28,249,242,125,70,239,231,22,75,183,222,194,216,180,98,166,182,159,27,186,214,74,253,234,220,112,80,103,58,215,113,70,28,68,149,92,181,110,119,67,179,179,9,96,140,249,194,72,173,244,144,58,9,141,246,68,237,118,179,124,164,96,125,30,196,126,104,19,176,107,25,7,162,89,236,206,184,139,167,166,16,55,67,7,93,251,90,252,86,252,171,140,238,114,28,106,253,2,64,26,18,192,199,145,70,224,41,158,81,211,254,47,235,74,231,215,176,97,187,165,209,79,109,189,21,14,209,97,193,29,254,42,24,157,72,5,143,9,214,54,90,86,243,143,140,12,163,2,158,213,69,48,232,80,165,123,73,197,247,8,241,232,198,127,142,153,236,153,145,20,27,64,72,56,14,13,147,102,116,211,20,44,176,108,13,229,36,230,81,206,9,197,5,42,177,137,125,239,52,138,145,92,76,16,223,134,138,221,234,177,91,177,210,67,1,151,117,176,201,125,211,227,144,217,180,31,53,97,31,147,33,222,114,225,63,236,245,62,68,54,30,147,134,96,110,84,124,209,201,141,3,62,115,79,24,228,194,3,74,218,184,3,66,224,170,40,123,37,121,61,129,54,53,103,197,43,89,135,6,26,104,193,193,136,152,56,142,183,224,128,35,138,123,231,218,184,64,116,133,134,79,71,93,163,18,65,127,217,137,72,42,147,44,193,117,255,58,201,221,139,83,224,169,171,21,200,243,196,43,229,12,27,96,110,87,50,136,174,144,220,236,35,210,9,136,71,10,14,95,205,206,230,46,210,240,140,197,31,1,18,188,0,238,15,228,67,49,220,86,132,126,70,124,204,88,118,84,251,214,36,171,200,70,160,93,190,20,193,149,122,208,201,60,231,13,227,143,217,98,120,101,241,47,166,37,0,246,166,53,179,69,210,170,111,102,237,39,29,58,140,90,17,30,66,50,240,135,134,156,130,216,158,96,227,238,43,173,150,62,156,252,12,213,121,200,99,178,38,253,248,51,29,232,51,139,88,26,160,174,235,4,96,47,68,39,65,224,118,4,246,129,110,151,23,33,196,101,107,18,57,33,181,138,239,175,105,157,49,247,51,175,4,49,223,166,210,239,121,16,164,212,230,198,33,63,150,165,9,54,147,43,215,241,224,55,27,106,204,89,39,184,161,80,49,4,115,240,147,14,244,80,211,157,188,47,240,27,232,175,82,215,194,147,55,86,12,143,240,196,252,206,171,147,238,96,167,220,204,222,124,57,43,217,33,94,205,196,224,116,99,78,12,233,159,227,1,76,43,79,235,217,146,66,161,211,175,94,65,74,199,243,183,6,81,84,203,242,106,233,76,173,158,214,45,43,108,174,250,106,136,126,230,63,14,251,213,18,71,87,50,64,255,236,85,183,102,109,45,1,174,202,9,149,185,253,197,58,210,45,138,136,51,85,221,138,73,184,106,127,134,253,72,58,18,180,62,151,29,82,139,220,202,116,64,248,20,81,96,109,47,138,242,186,193,36,58,228,83,194,172,38,0,252,218,244,10,112,115,142,57,210,57,11,64,200,229,159,61,193,101,132,118,218,80,148,208,24,56,50,42,216,65,221,198,222,42,94,40,195,189,60,175,28,71,25,114,164,42,45,8,67,46,142,204,238,25,167,37,150,221,46,11,216,39,161,104,150,116,113,1,94,67,6,9,155,180,85,217,5,244,160,99,51,203,177,93,136,13,60,29,150,143,141,45,240,202,86,52,252,208,169,251,4,6,159,54,129,123,18,109,207,1,191,79,38,187,105,43,96,244,160,246,58,53,1,126,98,82,106,12,250,65,44,103,65,155,146,190,0,201,249,32,20,57,171,220,149,156,114,51,66,148,220,137,156,113,120,32,169,126,124,13,130,177,138,31,55,46,148,240,128,29,71,141,116,145,112,8,66,189,190,216,123,114,164,94,213,103,242,213,46,100,240,150,169,179,251,110,47,164,50,174,245,163,245,59,14,243,8,35,82,74,151,19,130,70,32,129,139,54,14,190,35,131,230,71,44,133,253,187,52,219,118,239,235,58,76,31,196,252,32,242,187,197,157,187,55,29,121,51,214,250,24,234,46,96,133,232,102,63,43,191,186,226,113,189,64,205,186,249,119,43,113,194,61,250,58,221,69,191,75,14,152,187,167,243,108,156,124,46,5,218,175,243,118,7,240,85,167,144,192,213,61,210,252,162,165,162,46,86,124,240,63,149,35,88,159,198,71,207,56,140,25,144,133,248,190,191,241,252,13,124,234,108,165,9,106,44,119,178,102,193,221,168,140,143,125,102,211,106,41,163,241,103,12,131,227,10,78,64,224,131,209,128,108,224,131,81,196,188,208,57,0,65,7,171,245,92,68,97,155,26,19,0,220,173,153,62,182,16,55,19,229,89,135,80,157,145,162,168,60,3,54,77,8,252,62,78,45,97,13,187,5,95,233,221,143,244,218,237,9,191,191,111,230,19,235,185,24,229,133,236,211,127,22,70,243,186,237,63,6,52,140,155,111,172,124,143,130,20,198,240,17,48,164,10,74,221,17,240,102,82,73,186,66,214,132,28,226,189,253,197,216,71,13,102,76,54,192,250,157,250,97,33,169,125,119,76,18,127,148,89,55,79,41,27,171,173,241,40,25,242,210,152,51,104,129,66,79,162,178,205,127,78,159,148,90,244,237,62,200,220,157,71,215,30,45,95,17,166,151,2,107,156,25,214,202,113,205,64,70,182,24,9,62,176,176,190,16,176,188,96,117,242,77,22,88,50,108,118,138,246,209,82,199,143,160,77,201,121,197,140,194,143,8,181,195,45,95,221,40,139,214,14,153,166,70,195,180,165,102,177,227,237,193,79,231,55,66,91,102,116,212,200,47,182,152,106,44,255,140,122,66,158,160,250,117,112,5,28,227,9,101,161,115,43,75,216,160,129,201,85,4,155,212,168,94,163,160,204,9,102,25,233,102,160,184,227,106,238,100,129,31,84,122,126,254,145,223,210,150,80,172,229,177,248,245,3,169,238,5,16,2,78,51,54,207,82,72,227,99,136,26,105,129,53,22,17,45,214,181,195,68,36,56,169,195,242,5,8,191,67,154,4,98,246,26,112,153,140,77,237,240,2,154,115,169,245,170,100,202,110,18,149,98,123,104,24,71,192,232,157,222,215,83,47,36,18,129,246,103,237,227,185,218,144,30,199,136,151,160,138,100,74,32,166,208,86,67,75,237,132,120,166,153,52,64,10,225,171,2,81,131,86,59,191,48,93,62,184,125,186,164,181,232,91,66,146,242,21,173,53,43,188,74,248,215,108,185,224,167,76,81,71,206,93,12,235,166,22,241,224,190,133,235,131,111,103,60,230,112,49,52,171,86,194,94,59,123,115,191,87,69,241,194,32,229,82,37,247,66,83,202,39,30,54,213,89,3,78,249,44,22,248,167,57,0,84,189,32,168,147,103,6,140,148,202,187,193,37,38,180,46,29,166,57,72,223,230,106,44,108,111,251,141,251,89,7,111,191,116,203,52,57,144,49,241,196,170,155,145,94,130,81,6,8,48,239,173,230,55,130,69,187,163,225,66,214,151,106,237,182,124,152,252,164,152,71,188,138,18,156,234,158,96,75,48,112,107,71,163,19,180,198,24,225,112,151,114,89,6,217,49,26,232,78,138,51,90,69,91,193,126,130,54,20,217,158,121,249,61,85,203,2,97,83,109,237,170,254,0,91,197,122,244,126,45,233,234,109,127,179,19,219,93,31,65,76,94,19,176,192,62,20,225,161,144,181,212,117,211,254,177,20,119,165,4,191,21,105,172,116,103,36,198,101,166,240,111,212,21,87,239,249,26,153,242,52,76,142,34,251,237,81,66,187,57,122,29,236,37,110,21,148,230,218,247,104,63,1,234,5,69,199,73,134,157,172,42,231,147,224,75,141,129,211,82,4,89,195,246,70,171,181,93,183,55,108,159,166,33,84,4,185,111,204,210,203,121,247,47,11,38,196,128,175,73,224,158,13,7,251,219,162,20,164,80,64,199,241,117,6,96,69,101,173,208,37,165,211,107,165,193,43,31,159,138,214,247,2,33,12,191,208,158,105,240,17,229,141,41,237,45,38,45,115,88,232,28,191,188,150,228,13,47,17,235,94,149,41,105,96,203,124,26,222,106,9,189,50,92,15,120,136,57,57,255,99,51,112,155,217,186,209,181,137,48,198,43,39,230,86,230,26,217,240,223,93,238,195,80,220,79,238,160,255,161,52,146,25,191,179,0,106,203,39,179,207,46,133,153,151,239,88,57,122,189,135,89,178,115,230,216,10,114,143,251,93,168,61,169,202,150,202,196,237,75,49,182,183,125,110,19,34,1,136,14,89,81,155,227,118,201,69,250,152,109,216,132,250,88,147,48,2,191,100,195,211,13,126,162,119,72,133,229,123,207,22,23,212,210,63,155,150,227,57,166,222,129,67,70,42,85,154,245,247,41,193,230,95,156,113,40,103,226,86,19,6,181,49,124,103,224,189,223,33,119,236,24,20,229,68,141,154,5,89,177,163,212,125,152,33,38,48,226,24,141,151,158,51,86,207,22,139,80,172,113,125,82,37,229,71,24,29,22,151,195,95,177,29,49,74,158,121,217,68,52,92,168,158,88,196,251,22,3,155,79,122,252,156,221,200,181,70,100,216,71,156,175,156,86,2,231,130,108,43,211,119,75,181,114,163,95,222,24,246,255,186,183,186,101,37,137,223,53,194,47,117,58,55,235,209,179,14,167,242,26,134,221,36,193,38,118,184,207,96,67,32,145,250,154,128,94,25,66,185,48,57,213,130,222,58,197,173,252,78,101,199,141,206,155,94,81,157,155,216,239,200,168,141,203,59,210,55,17,55,170,5,110,70,51,20,19,17,219,187,198,121,220,48,135,101,52,185,215,244,4,37,229,220,138,211,126,144,244,210,14,194,134,9,176,26,52,128,5,94,173,63,199,171,196,37,142,16,185,13,98,224,38,105,153,24,182,124,179,35,177,69,226,224,127,75,236,2,98,7,44,185,3,14,107,156,129,152,51,36,29,203,211,203,108,162,74,162,216,89,12,128,9,112,14,157,147,3,227,248,177,51,228,239,231,213,231,254,82,42,244,137,106,99,170,156,192,66,71,139,213,5,156,125,195,124,229,130,190,205,89,225,241,254,176,95,30,219,40,248,129,218,116,222,75,183,241,249,60,88,178,52,92,157,156,113,232,162,36,107,47,55,17,155,162,70,224,125,82,84,211,203,26,49,246,193,94,207,161,122,216,126,138,16,206,87,28,38,45,30,196,186,30,68,206,95,156,208,218,236,93,107,125,217,121,46,223,4,69,183,46,238,206,71,72,167,159,167,48,118,25,0,159,147,140,99,166,172,4,113,21,161,52,102,54,219,194,90,106,50,6,156,202,21,86,112,33,45,53,6,124,162,83,226,178,246,1,165,167,177,190,237,128,219,79,114,30,187,31,146,10,157,251,80,124,108,191,233,91,104,68,35,156,13,54,123,191,37,77,245,82,222,206,8,246,133,27,217,87,116,7,145,65,128,81,142,250,19,137,207,10,217,88,150,119,183,30,231,123,9,189,145,113,150,247,204,148,101,142,228,144,127,101,122,157,153,221,45,112,44,139,13,223,94,18,221,245,14,185,252,132,117,15,173,122,121,1,251,109,2,107,25,97,29,180,199,11,124,161,138,37,92,119,254,245,118,34,128,28,100,200,80,5,114,99,208,232,126,215,247,226,193,129,111,229,166,12,107,30,67,118,84,156,100,158,204,44,28,118,134,227,10,22,153,126,77,13,134,137,18,167,115,62,98,60,182,179,66,109,93,146,39,135,247,137,193,45,175,156,83,87,217,63,250,57,154,128,151,152,45,35,43,126,198,229,219,126,200,145,4,236,251,153,196,162,89,73,134,96,119,107,128,190,147,228,64,73,220,100,124,73,203,91,213,77,92,68,50,107,69,237,110,138,228,193,175,162,213,78,39,118,105,39,11,196,157,25,195,35,53,250,121,123,219,197,179,143,206,30,210,251,106,231,243,37,84,55,23,7,30,84,11,121,92,53,9,191,28,49,57,237,112,78,183,12,215,243,99,159,238,14,246,197,136,207,69,0,120,99,89,37,184,54,94,128,204,224,174,118,50,226,59,151,162,115,167,144,223,213,199,4,87,55,193,10,212,169,238,242,254,70,213,252,87,32,245,18,157,79,122,232,143,103,31,93,140,93,243,91,156,91,223,136,12,68,98,200,179,170,185,195,112,27,104,3,205,165,28,186,174,118,57,189,119,144,158,95,158,164,143,139,58,87,217,43,22,68,43,126,240,70,94,163,225,233,248,227,168,70,198,16,51,205,239,192,4,124,244,190,80,130,188,253,65,63,201,98,243,142,139,238,115,52,164,188,234,11,203,33,66,111,40,174,113,78,139,135,102,209,122,166,53,10,2,10,140,215,139,223,100,11,23,208,126,65,214,52,37,98,93,37,250,159,75,209,155,248,86,107,5,114,199,254,105,179,240,132,18,228,65,136,188,180,168,141,149,43,234,13,114,25,92,32,8,212,172,186,194,234,241,77,20,142,76,140,225,110,176,248,93,52,69,8,47,143,25,99,166,56,37,228,218,183,234,205,236,237,168,228,136,179,145,123,254,230,182,37,220,223,96,199,45,24,147,73,86,254,47,90,124,89,129,192,199,167,216,217,62,148,163,46,107,74,67,155,206,30,163,44,42,238,69,77,5,86,126,151,131,136,59,134,63,72,23,50,35,228,75,48,172,147,4,200,35,217,142,56,51,159,145,237,51,218,27,192,43,193,90,63,194,218,149,77,69,58,68,24,177,235,144,245,52,41,241,21,63,202,204,123,60,245,245,147,59,230,53,58,179,177,6,108,72,142,101,202,171,147,1,238,27,183,145,157,7,29,13,111,137,129,183,185,196,139,126,204,48,220,237,170,227,65,153,226,170,245,241,69,250,74,235,39,129,115,94,113,165,212,140,219,239,255,30,2,150,71,167,222,250,123,230,253,102,110,67,175,23,73,166,0,144,47,148,163,151,221,23,81,24,247,230,191,244,11,1,206,112,51,40,182,33,40,163,61,107,169,167,6,202,202,72,255,23,102,172,225,38,148,226,88,109,43,255,21,145,157,184,0,241,95,26,253,89,42,53,13,149,184,8,74,173,119,80,63,39,122,131,186,46,224,96,135,125,146,230,186,215,105,91,230,163,169,125,167,150,59,214,137,125,94,22,30,51,110,143,175,201,170,44,185,136,253,28,105,89,77,41,65,135,12,60,237,170,191,75,127,88,149,34,205,123,6,139,121,217,249,166,254,165,197,104,144,84,48,58,172,21,122,128,85,199,148,36,114,91,239,123,1,206,8,169,49,206,39,142,97,137,189,224,169,198,119,13,171,201,140,49,157,103,118,88,94,210,27,126,242,245,68,55,25,204,114,244,247,64,29,145,137,154,56,172,22,62,19,227,79,143,90,5,12,201,194,154,224,71,103,79,31,119,20,146,114,219,19,44,92,21,211,69,49,20,95,47,183,25,195,60,209,50,238,182,244,59,9,94,112,27,36,210,214,7,152,57,84,87,219,76,117,252,173,214,2,188,162,120,141,43,194,108,127,121,25,148,205,129,10,46,39,41,144,243,52,218,147,187,37,188,247,50,228,177,63,51,214,17,10,240,24,244,129,34,87,146,124,5,230,163,171,120,234,22,101,103,156,68,245,144,114,132,132,244,163,47,127,235,219,88,243,187,140,196,153,78,126,139,116,152,107,147,27,119,0,2,213,231,59,70,73,214,67,31,130,51,71,155,189,211,225,165,140,83,24,36,56,202,105,50,33,140,155,216,216,209,252,54,156,254,20,81,120,206,235,241,53,194,44,177,128,30,239,26,95,124,88,90,21,132,123,188,158,141,127,241,223,95,178,108,21,221,145,222,26,192,180,84,129,78,175,117,146,57,215,116,10,13,53,12,252,227,64,32,115,213,68,143,238,155,225,101,184,132,28,92,127,89,232,1,139,160,185,99,115,92,29,188,211,254,180,85,121,47,205,53,199,122,73,153,119,188,74,163,229,129,90,48,50,178,91,189,168,116,38,32,114,55,89,132,116,208,124,128,113,113,16,206,199,26,163,212,71,1,250,155,96,53,100,44,246,31,136,208,243,220,60,176,23,103,88,245,48,51,59,225,235,226,76,182,53,49,135,126,117,23,4,0,51,62,11,237,65,252,21,246,193,84,14,85,217,111,240,108,226,134,59,194,210,198,214,9,245,99,101,81,3,89,134,225,173,80,61,204,115,250,25,191,22,137,42,177,155,159,237,248,200,39,189,1,66,189,88,8,198,57,47,194,59,150,74,50,244,192,145,124,139,137,9,88,183,226,179,162,219,55,201,222,186,109,36,242,146,104,134,170,9,120,67,123,240,251,118,184,113,206,203,242,204,29,95,103,160,139,24,229,246,174,44,232,1,92,51,119,121,192,74,200,193,169,150,115,168,56,37,31,105,175,166,10,183,252,135,115,233,34,0,229,124,183,246,177,143,42,237,125,2,142,154,240,49,228,213,15,77,123,202,79,84,0,147,189,200,161,106,243,41,87,86,158,216,240,246,100,112,9,91,213,220,206,108,190,57,220,218,99,189,47,194,120,28,127,254,169,178,91,243,109,75,134,210,210,244,242,159,54,217,20,133,68,233,153,234,101,91,233,30,96,171,224,92,91,176,236,182,188,20,131,21,122,84,104,171,14,236,252,249,75,212,235,191,95,11,62,141,94,241,165,26,219,173,197,153,214,168,223,240,94,213,113,148,95,22,212,203,134,117,232,60,147,51,11,201,54,4,81,122,170,58,150,209,147,128,196,78,68,78,148,160,114,198,127,162,120,180,68,133,22,76,101,119,11,93,246,9,232,183,127,140,173,92,221,236,51,178,45,217,246,70,118,91,129,102,24,199,252,7,6,116,81,43,240,49,115,77,164,134,23,10,184,92,26,223,238,174,254,108,5,221,29,205,3,38,30,51,143,196,202,21,102,228,51,105,45,191,54,175,140,175,135,132,56,183,9,116,20,68,132,18,220,233,176,239,82,87,160,87,75,33,255,121,193,156,78,230,23,79,64,52,198,99,148,130,106,107,8,203,26,34,248,194,178,123,242,238,250,69,219,168,219,185,118,64,221,220,7,62,58,172,34,161,85,252,155,52,152,60,87,103,183,167,226,234,225,170,247,90,38,143,81,89,210,156,20,60,194,148,113,179,171,5,77,184,78,26,208,131,200,86,18,46,116,74,134,61,119,29,194,3,117,40,80,168,90,103,191,42,184,95,218,91,28,155,54,146,65,95,188,105,77,14,205,75,249,117,46,221,98,224,169,93,190,83,43,182,146,208,7,135,154,99,250,12,2,189,246,105,220,172,175,69,1,167,218,186,57,136,247,112,149,221,32,11,202,229,160,52,60,200,208,193,198,75,246,250,53,55,150,176,139,93,85,222,206,205,111,9,73,162,186,211,69,140,188,136,164,203,223,18,225,119,181,234,138,60,23,112,75,105,15,203,7,125,177,246,31,45,74,151,48,22,139,175,136,183,250,161,111,94,119,158,113,175,140,79,29,122,65,55,233,80,125,200,31,209,18,35,82,3,116,190,125,208,46,253,125,100,73,160,238,5,244,38,184,200,7,167,119,122,165,28,250,26,52,110,188,151,63,208,63,248,94,165,164,111,163,146,32,37,5,60,85,192,27,61,24,60,161,222,0,4,254,155,189,84,196,0,157,35,12,162,103,138,192,135,38,45,40,41,69,63,30,177,222,41,253,200,54,63,230,237,20,103,172,23,99,192,215,2,181,198,52,12,1,157,162,169,147,206,27,237,188,158,40,214,164,233,240,100,201,245,24,178,38,205,66,140,166,43,132,117,143,233,22,167,190,202,18,188,127,240,184,49,182,87,84,214,121,140,169,20,29,122,133,69,18,168,61,132,146,108,35,131,109,86,101,183,150,34,77,90,194,24,46,232,28,48,183,206,47,100,61,163,165,74,17,92,27,210,106,16,222,186,117,41,103,197,144,3,27,9,248,132,189,88,83,122,219,49,116,2,50,30,40,205,76,130,35,126,83,228,228,138,171,171,135,39,196,227,87,106,235,241,239,86,179,253,11,23,99,7,66,41,158,178,157,76,234,6,5,214,254,184,155,181,84,197,165,122,251,119,249,236,166,219,144,14,253,20,200,71,185,128,249,58,15,196,101,206,51,124,190,50,159,255,10,172,123,168,253,230,89,10,236,71,194,62,129,71,92,165,85,0,198,135,157,141,191,50,13,140,37,124,110,249,46,46,25,251,68,145,8,18,120,51,137,142,119,244,148,246,141,26,132,163,135,241,35,159,49,77,209,163,230,111,6,242,146,195,49,170,2,124,194,17,165,42,155,254,34,50,37,48,67,234,117,90,102,69,129,61,195,172,78,87,34,46,79,146,168,210,166,122,231,226,222,204,251,20,75,223,196,242,130,34,225,110,75,207,175,78,24,239,45,171,104,198,59,0,19,49,11,243,112,43,250,158,62,80,155,237,46,52,188,185,245,171,68,197,202,251,110,93,211,94,67,191,87,157,87,233,13,61,47,52,206,80,194,167,66,67,198,170,244,247,174,171,50,79,255,184,161,14,254,202,162,162,254,221,148,221,251,90,102,154,71,98,61,150,1,32,250,227,57,240,168,21,174,152,107,235,75,2,198,35,117,161,148,210,231,214,184,87,241,102,16,184,144,221,165,158,108,17,177,46,228,156,159,149,123,171,239,250,40,10,62,189,159,144,124,7,64,76,122,161,214,158,46,206,191,99,142,189,68,40,168,172,65,88,130,102,169,121,107,188,201,117,35,139,212,14,176,77,110,172,197,14,238,254,189,108,234,224,228,68,226,121,230,183,185,224,25,14,142,86,3,2,21,133,116,109,24,125,214,126,192,236,107,42,30,208,247,43,102,62,205,11,213,177,80,163,92,245,82,101,244,192,151,191,169,102,204,190,167,232,66,226,12,115,238,131,188,181,235,30,55,68,17,186,125,64,121,44,39,147,240,53,20,40,101,224,109,239,226,32,115,253,200,113,202,118,207,81,168,138,146,224,129,38,168,181,120,87,225,170,24,6,223,254,59,48,103,66,191,112,18,100,232,149,121,191,132,39,231,12,223,111,202,150,238,150,76,143,41,37,183,222,8,16,24,33,99,101,144,218,10,68,70,133,97,95,109,42,67,13,102,0,93,189,206,41,149,160,206,101,195,209,76,22,231,109,76,142,113,78,222,63,202,227,65,140,154,29,47,96,41,58,77,137,107,249,152,7,126,53,105,31,221,134,107,150,14,18,108,110,152,91,57,88,146,199,220,12,79,116,220,134,180,176,224,71,97,52,154,76,94,230,58,14,196,154,89,27,162,219,96,227,91,143,175,92,36,179,222,30,59,163,32,250,146,96,163,83,134,33,18,27,99,127,113,171,35,52,143,96,219,71,71,254,216,30,244,75,88,241,242,50,213,1,83,56,154,152,153,219,130,166,175,82,10,125,111,96,137,38,46,205,11,85,195,29,184,117,250,218,58,49,10,40,30,139,211,81,157,249,51,33,100,201,34,96,197,189,206,48,180,50,2,111,154,109,10,90,116,189,224,85,45,153,10,96,210,142,179,131,174,213,131,9,90,194,235,113,201,152,223,253,134,198,136,215,196,121,114,145,127,197,63,226,22,10,124,149,177,37,12,217,218,113,9,235,142,49,103,237,98,82,140,8,127,97,56,61,78,76,142,106,216,56,78,153,139,60,223,243,28,34,38,199,137,132,50,118,151,58,141,192,20,249,138,53,114,177,45,146,78,147,234,123,244,61,157,119,7,88,41,82,17,102,213,59,93,79,45,40,157,139,219,81,12,134,18,77,1,101,45,228,155,66,227,243,242,202,71,136,205,94,102,239,237,253,62,207,30,222,178,58,135,219,74,150,232,27,209,251,37,198,33,83,209,39,249,183,21,38,213,39,143,198,149,91,161,250,193,43,45,233,70,234,118,173,231,180,151,157,138,7,167,198,81,194,51,164,200,83,56,176,121,167,225,108,50,245,125,137,148,215,111,59,19,64,109,5,114,176,218,137,186,235,94,254,156,96,194,168,34,159,84,171,68,70,215,155,148,244,240,11,54,128,75,56,161,201,231,65,137,194,113,32,89,201,13,141,169,131,94,198,168,132,135,101,50,165,181,8,159,184,15,19,74,16,105,43,25,168,214,106,76,164,64,91,12,74,22,16,124,27,121,145,188,125,255,96,131,33,245,145,180,29,62,194,137,30,62,243,129,77,13,158,163,117,162,206,61,236,135,244,220,166,174,217,73,139,0,254,201,26,125,241,33,68,187,155,235,119,25,72,196,151,8,255,8,84,250,43,102,204,134,121,186,123,144,48,2,235,7,229,41,190,150,181,169,203,226,194,118,180,182,162,220,222,14,52,114,197,229,86,207,201,148,241,246,69,68,231,8,57,6,21,171,44,83,134,151,83,25,48,142,91,248,21,21,213,9,104,208,21,12,133,100,100,144,124,237,193,56,180,34,39,246,232,53,212,121,61,127,221,103,74,114,150,223,11,229,210,6,76,40,95,192,199,167,100,100,64,117,44,73,13,187,42,241,47,212,35,164,55,64,85,88,41,102,68,165,110,72,100,66,38,33,14,166,233,157,80,35,137,1,69,63,111,169,42,19,65,190,106,104,216,90,154,147,190,183,207,177,145,142,190,213,148,10,228,251,99,58,72,148,192,227,20,1,79,110,181,47,89,218,133,7,75,111,229,49,60,97,179,158,28,51,110,139,80,56,147,33,182,227,153,92,32,1,241,44,181,143,24,16,252,26,129,134,63,65,186,1,160,90,254,21,88,43,220,101,222,156,214,211,98,172,42,254,193,103,147,61,229,181,85,228,223,127,163,201,157,106,97,82,251,201,89,32,245,234,92,103,151,70,111,44,210,74,166,88,95,204,82,185,9,218,72,146,27,181,139,97,122,22,228,206,84,237,87,140,101,100,110,216,186,226,110,186,109,140,162,59,52,3,26,96,176,41,84,66,47,216,100,110,106,2,55,106,165,232,43,156,42,193,122,42,74,224,96,101,41,240,141,4,88,29,113,31,121,80,196,152,15,234,154,70,129,228,97,137,99,89,108,64,143,32,111,199,220,209,192,20,24,80,192,202,191,169,156,133,210,36,179,17,149,67,213,52,180,176,134,253,181,179,174,87,217,236,254,162,137,201,192,88,23,89,195,231,73,182,226,224,149,99,172,221,135,5,241,132,86,236,118,69,50,108,27,103,65,17,127,75,11,160,71,85,227,148,153,62,103,83,250,192,254,215,123,252,157,8,112,132,210,193,21,244,168,131,44,69,226,190,243,10,225,163,84,190,118,32,19,193,234,220,32,188,74,90,197,143,70,191,99,113,186,143,49,131,109,253,62,234,221,183,103,238,89,65,67,11,230,9,222,24,95,129,14,228,125,126,166,49,29,239,36,39,124,130,203,200,105,29,231,182,43,1,179,193,103,230,251,205,22,182,65,191,137,110,165,113,180,60,209,87,212,7,69,241,130,157,125,59,225,89,244,120,134,142,170,92,19,65,251,87,163,83,32,185,163,202,187,191,34,192,183,186,236,30,222,225,180,237,142,162,77,93,190,100,248,70,134,164,253,105,255,142,189,83,50,161,225,223,241,240,252,170,90,122,221,22,108,187,81,31,252,76,218,238,217,175,90,110,37,190,8,65,147,181,160,202,39,24,230,218,92,233,102,123,98,72,215,163,152,111,198,25,215,60,213,1,254,4,168,45,13,40,238,142,158,60,70,241,144,183,215,236,146,149,13,234,215,133,3,112,135,7,8,40,195,214,105,244,172,246,200,198,238,153,112,100,59,137,18,122,9,204,17,41,181,111,41,61,21,160,16,170,194,218,178,62,88,92,199,233,200,24,70,246,142,224,164,200,210,237,216,75,100,45,115,160,117,92,38,226,170,215,156,203,215,210,248,231,199,216,248,161,125,167,132,103,180,186,9,249,4,154,16,237,107,80,28,27,235,150,39,210,201,153,66,17,97,165,29,15,167,130,23,77,17,106,160,90,248,47,219,164,20,127,81,248,1,36,254,22,50,208,65,145,45,220,160,93,16,45,62,229,177,187,144,167,142,26,248,232,6,191,77,59,136,49,2,33,116,66,65,146,218,44,111,73,2,222,99,111,24,180,41,67,103,39,216,168,240,207,142,34,241,86,17,173,37,58,64,186,213,98,181,151,159,141,26,22,31,45,92,64,9,10,26,76,181,236,145,18,8,30,219,158,183,71,138,134,56,65,70,34,140,141,13,54,245,29,155,227,200,183,113,40,113,203,86,214,2,162,90,237,5,247,2,186,149,205,73,75,106,255,178,8,39,126,21,96,43,117,216,10,81,98,244,208,25,252,177,189,21,50,204,13,115,42,29,115,2,10,234,207,168,29,131,228,241,82,183,158,85,177,161,142,249,81,208,74,7,73,61,160,142,153,121,63,78,230,152,77,38,100,58,119,15,102,23,145,201,189,165,77,147,230,208,2,84,68,22,86,13,32,68,58,88,73,8,48,139,117,27,222,40,32,182,33,168,89,188,113,162,162,146,225,102,118,158,53,22,82,149,184,240,92,212,243,40,50,170,149,147,223,104,185,45,162,20,59,162,173,157,5,224,233,8,159,219,28,215,102,178,59,121,254,199,162,199,99,2,69,53,6,16,218,9,6,241,44,220,188,45,208,250,244,235,250,209,70,110,222,198,183,219,47,135,143,170,11,226,178,201,194,8,0,115,63,105,158,9,227,172,16,176,218,211,18,70,236,5,109,35,119,143,218,145,213,190,153,247,240,232,191,61,9,58,130,175,235,45,122,195,207,43,194,102,133,91,46,230,18,78,212,122,114,168,4,94,120,96,72,18,12,142,191,141,105,202,78,241,114,85,34,238,84,11,10,254,50,188,122,76,216,117,121,110,3,95,91,62,253,60,174,139,195,120,183,220,61,229,75,22,220,190,134,216,68,90,111,184,152,40,130,43,39,76,144,94,215,83,252,62,127,27,6,175,158,50,87,41,85,95,32,24,14,193,22,92,54,156,254,77,61,50,7,243,25,48,156,89,56,17,33,107,135,110,160,52,80,216,55,217,98,40,102,1,34,70,233,200,205,172,234,156,17,180,123,113,143,67,81,224,51,149,12,213,251,3,2,63,30,249,181,254,120,160,155,133,96,137,181,35,5,182,121,214,39,128,129,237,203,19,137,24,93,101,255,228,209,34,58,241,253,187,131,60,8,241,178,36,11,26,109,21,150,214,31,242,19,60,118,147,158,111,23,164,168,73,67,92,231,211,6,86,222,242,248,107,142,231,119,143,1,168,27,187,91,70,38,230,162,216,232,152,83,71,41,183,182,189,94,221,128,7,217,182,42,49,232,20,23,3,87,95,213,181,137,117,14,161,52,243,122,183,193,90,134,182,58,222,179,72,150,241,129,197,216,227,156,20,75,90,202,71,128,15,137,242,183,117,188,168,252,39,243,76,167,222,12,190,250,197,206,164,145,191,47,206,24,20,40,253,36,4,220,72,143,199,19,105,30,48,219,215,196,37,15,182,38,220,134,239,35,187,29,230,68,215,139,220,215,90,25,184,246,196,149,239,249,142,248,63,141,205,161,28,87,142,170,237,214,67,142,251,97,163,163,242,208,139,28,201,5,249,160,111,232,64,231,207,201,197,196,206,92,127,71,17,57,48,200,25,226,176,113,210,162,108,233,45,224,15,40,196,161,187,228,55,88,74,235,30,68,12,209,70,87,243,159,85,208,70,192,75,111,14,15,239,6,234,134,248,30,113,51,255,128,43,104,82,6,158,241,74,19,174,199,229,132,238,6,70,145,96,242,208,185,17,12,251,210,13,113,233,186,188,29,9,195,244,71,62,26,195,82,44,209,10,230,93,188,92,234,241,145,115,67,77,67,44,210,249,228,5,84,43,160,77,103,214,59,87,195,200,20,129,254,173,229,229,37,115,254,49,72,119,145,188,255,12,95,191,110,239,124,12,213,234,217,4,211,133,39,184,242,103,223,13,5,50,56,74,214,135,66,130,62,223,167,91,175,30,40,134,82,42,167,175,169,33,40,205,88,123,104,96,189,142,226,130,73,0,60,121,128,225,203,146,1,170,4,93,235,72,243,97,77,129,92,246,173,53,161,138,204,83,70,234,80,223,20,176,62,149,150,127,141,182,196,163,80,117,13,31,248,64,166,35,112,96,44,221,70,128,124,229,74,60,65,83,15,20,135,165,184,82,153,163,153,145,137,168,21,68,140,120,76,239,1,57,32,133,38,158,157,114,92,79,139,129,100,233,109,73,206,6,164,101,18,250,41,214,14,185,87,241,153,142,116,3,55,77,138,149,123,112,38,59,191,132,156,136,205,108,175,236,117,66,107,36,241,192,147,149,227,116,253,26,209,34,134,94,214,68,212,25,142,117,207,151,32,13,101,187,154,38,54,165,162,58,254,142,54,86,89,13,232,46,36,31,67,169,250,183,168,205,55,163,165,77,37,211,28,12,51,80,99,47,117,190,69,215,83,246,24,48,152,252,50,167,183,242,94,21,63,211,171,23,199,4,160,172,57,57,92,128,50,52,174,87,77,255,17,221,149,165,195,162,43,38,226,27,221,101,124,188,82,226,222,49,132,246,31,27,81,255,205,69,176,163,195,253,83,47,80,99,157,132,223,160,92,39,120,73,149,51,171,255,67,218,107,160,220,58,236,28,119,180,1,82,24,146,160,44,200,70,141,109,254,12,126,229,95,99,96,3,216,221,136,205,113,142,122,186,243,183,255,22,253,97,176,39,222,179,209,180,233,133,72,37,54,158,28,65,95,13,1,59,153,193,87,230,128,104,160,201,205,2,196,6,125,232,155,188,65,83,240,126,145,178,63,143,0,240,193,78,184,2,226,82,240,49,22,50,167,206,196,168,121,68,212,156,249,154,95,24,93,83,113,168,33,14,246,208,135,139,78,122,101,123,8,177,97,182,122,128,106,140,8,192,100,143,88,196,50,29,207,215,143,65,120,133,133,118,94,128,12,106,130,195,165,203,112,192,173,166,222,59,23,34,6,82,131,16,84,214,205,87,208,140,201,182,166,221,131,122,181,85,150,65,139,133,103,23,179,159,231,7,175,204,95,130,131,126,45,155,135,76,69,145,54,197,251,173,9,206,46,189,122,101,178,24,17,52,231,121,151,60,255,66,47,5,0,134,235,185,232,129,137,35,158,3,110,230,211,73,61,209,224,71,153,55,248,61,100,233,170,140,66,27,177,253,40,208,209,143,4,27,108,105,166,136,60,8,218,119,168,182,107,8,119,5,118,31,219,43,94,70,182,91,68,254,135,245,212,250,26,105,156,109,180,133,177,249,140,89,130,79,55,31,123,18,154,42,191,139,9,240,237,151,107,173,188,134,243,132,118,79,249,197,52,29,174,60,127,48,203,213,101,118,178,117,92,200,49,217,119,172,213,150,231,103,134,168,200,159,174,105,85,8,72,53,243,196,179,102,171,173,207,190,134,186,250,180,231,155,193,203,81,248,175,8,196,145,73,186,178,63,177,60,238,12,42,169,79,173,245,76,171,131,19,102,237,156,201,116,42,209,167,158,198,227,114,197,227,182,212,229,151,110,140,149,239,82,124,137,145,167,26,54,159,102,237,132,139,121,181,115,78,145,179,231,40,243,114,107,190,126,230,152,86,21,43,130,126,87,172,107,120,215,174,119,95,238,138,107,162,109,30,0,156,48,191,59,137,171,39,151,249,219,16,202,29,186,7,225,198,202,213,119,26,30,46,66,61,154,127,212,160,121,30,139,137,77,16,197,1,225,23,181,190,52,124,88,224,250,45,111,131,115,99,26,188,227,244,207,13,101,230,130,96,187,90,109,141,203,246,150,213,238,2,180,162,199,113,129,255,97,7,65,101,37,145,166,70,193,39,68,86,45,6,162,80,189,182,147,237,204,108,173,114,12,139,6,79,110,178,50,39,17,113,41,178,217,61,88,132,240,93,181,152,170,7,71,170,146,115,177,209,87,215,16,157,38,76,45,46,220,16,103,58,125,32,153,241,187,154,232,13,56,84,165,56,94,8,6,118,36,14,96,65,93,68,50,208,97,85,185,103,1,161,83,67,194,38,128,76,181,204,102,151,40,72,219,119,58,243,206,0,99,50,157,241,110,31,75,39,89,181,28,80,34,47,54,40,145,0,60,100,212,148,16,35,19,189,130,103,237,1,19,109,241,72,134,148,103,72,23,209,106,186,211,41,196,18,76,23,75,122,68,251,50,11,252,232,52,72,57,5,52,226,217,252,184,71,71,112,106,214,93,60,250,235,235,115,148,64,183,222,82,158,135,135,145,153,54,138,126,116,216,66,235,51,100,7,1,111,11,231,57,153,174,195,76,173,195,2,137,227,217,61,109,233,31,68,5,179,235,72,80,16,191,118,37,76,119,131,246,39,251,58,127,172,229,32,135,167,216,216,39,54,7,180,45,236,44,47,186,218,5,45,145,201,222,24,126,214,198,237,218,245,74,159,119,201,233,27,224,213,175,46,43,252,104,209,254,53,126,25,166,190,157,66,64,23,226,4,74,69,28,42,238,195,233,33,1,64,116,16,110,32,81,97,57,242,250,108,13,200,31,184,115,30,190,65,111,225,197,90,215,174,221,193,216,165,11,16,3,153,141,181,161,223,213,141,64,243,41,33,65,208,245,48,203,171,242,234,120,183,57,60,85,83,188,148,249,94,62,178,164,119,223,137,180,49,184,166,120,134,127,76,230,216,208,161,5,42,237,196,235,114,222,23,134,110,242,244,163,1,42,228,3,251,93,156,48,46,154,200,19,163,205,213,250,142,212,14,156,210,48,20,148,235,204,232,128,21,3,100,38,184,230,249,138,117,207,253,60,79,102,174,115,184,21,102,194,116,47,69,98,110,200,73,248,186,30,220,75,239,155,228,138,141,255,84,179,127,17,124,167,107,102,248,93,59,11,170,167,110,129,228,140,41,111,215,131,169,31,210,192,131,220,50,29,241,34,235,141,60,96,178,83,126,109,14,186,209,248,63,130,108,186,180,105,95,192,234,29,87,8,197,153,103,55,13,10,116,247,40,153,54,84,199,120,69,98,185,228,4,234,107,80,168,240,218,9,114,58,196,150,245,120,244,210,164,160,201,55,20,40,135,138,179,149,228,199,157,192,174,190,79,35,154,208,104,215,44,229,241,125,186,156,42,60,224,60,98,79,40,64,126,207,165,212,10,115,54,25,33,126,58,236,50,194,209,149,85,111,178,89,79,15,60,227,54,174,229,243,135,42,102,50,171,254,95,21,247,31,125,0,215,95,9,254,115,158,204,23,106,103,28,139,202,110,125,119,242,110,213,56,152,116,42,49,235,231,28,252,0,141,119,191,200,51,122,183,74,56,200,99,174,153,239,174,227,16,247,241,53,17,43,147,201,28,236,24,172,158,183,250,239,232,109,178,138,191,154,85,92,101,93,173,175,120,149,115,204,109,250,109,193,172,203,85,254,72,122,109,173,97,223,35,161,59,23,39,177,164,124,186,70,76,36,143,143,79,179,160,167,125,30,112,233,209,141,126,247,37,119,77,159,6,86,22,186,250,64,148,109,116,69,157,161,219,213,126,74,234,55,4,74,150,191,164,59,229,208,73,147,153,74,155,93,93,177,111,177,180,36,107,46,26,222,118,125,41,31,110,95,84,199,96,81,223,99,229,230,111,208,187,44,207,189,197,162,155,118,66,246,102,5,157,180,61,121,27,171,235,38,194,219,47,109,32,238,247,114,130,158,184,151,243,155,87,210,50,16,172,39,124,229,145,237,44,49,206,229,30,118,171,255,129,65,10,175,28,62,65,30,217,20,113,253,179,149,240,28,118,112,140,20,237,39,7,159,242,230,64,144,209,53,33,213,116,176,141,135,111,225,244,248,107,202,235,131,88,130,60,113,17,151,144,193,21,155,78,5,33,221,177,64,101,141,166,1,217,83,16,24,8,33,203,8,73,180,252,201,36,37,193,112,158,81,36,62,12,87,125,150,121,19,39,92,191,173,210,244,36,77,195,88,140,26,156,4,231,27,111,89,251,35,188,185,246,75,176,127,162,75,144,137,255,124,36,161,108,144,154,177,88,19,197,21,51,61,242,175,177,115,118,58,158,40,174,196,158,97,198,184,209,36,126,232,71,189,204,186,7,102,36,124,234,204,89,172,220,192,86,101,51,175,40,9,191,17,115,155,117,200,237,22,138,77,48,250,240,160,224,117,133,170,182,144,213,211,213,2,243,145,65,254,0,2,248,48,33,249,80,119,29,108,76,228,213,3,143,250,23,23,131,183,155,60,55,214,27,114,225,198,150,10,35,148,123,109,118,26,2,65,205,51,165,231,113,146,183,118,99,110,128,192,107,84,128,130,68,16,88,195,165,35,170,219,153,195,92,132,226,34,20,77,81,240,139,150,107,214,77,155,204,106,79,19,168,44,71,198,240,87,142,60,44,60,246,5,116,90,243,72,82,123,206,123,164,157,159,113,100,46,227,97,151,247,172,49,26,253,214,112,110,75,191,20,199,178,121,153,73,146,167,80,165,179,249,104,118,42,76,8,126,200,69,25,1,35,35,219,85,218,235,253,164,63,211,195,178,60,208,120,222,151,167,79,238,35,131,109,53,18,149,50,40,14,206,218,230,111,82,234,124,19,223,6,18,94,196,199,189,219,79,203,3,86,63,184,11,70,220,145,70,39,204,13,70,25,105,99,18,2,0,24,161,197,244,35,162,11,157,34,54,196,92,138,255,30,83,77,170,69,196,207,11,28,60,155,7,88,6,248,72,159,21,242,123,4,244,230,249,74,32,130,186,174,143,2,140,24,130,73,170,186,195,129,0,221,95,213,21,27,147,128,194,103,91,111,210,249,82,200,180,140,107,187,79,132,95,135,105,220,39,219,47,101,130,232,19,153,84,96,21,214,227,184,212,26,88,77,22,173,250,215,51,120,214,55,206,86,220,178,39,170,15,114,12,97,98,239,4,124,47,250,230,133,149,196,82,209,165,151,0,207,30,106,133,62,251,241,196,196,47,179,145,179,2,155,15,5,165,22,67,52,207,39,246,123,134,219,252,174,231,168,82,8,7,192,229,168,45,215,86,100,235,111,169,107,12,249,89,109,86,160,142,181,238,237,223,92,168,130,150,236,224,116,222,45,18,13,13,164,73,38,27,208,24,138,45,80,4,148,58,149,54,128,230,244,22,230,218,179,87,51,104,223,178,9,209,228,14,206,192,249,41,82,34,115,235,125,150,192,196,1,165,252,62,83,243,157,37,218,134,192,149,232,139,145,253,205,51,17,97,192,121,157,60,181,170,126,156,5,44,196,235,223,123,170,2,118,228,255,243,8,132,196,221,30,242,92,159,112,180,131,51,25,126,253,184,7,4,110,34,217,37,185,91,186,44,77,80,104,181,58,171,9,210,180,17,119,8,141,229,247,64,62,232,121,118,112,133,52,173,5,202,94,170,37,212,28,222,193,97,51,164,107,197,181,220,102,52,58,47,147,194,179,174,14,89,19,221,145,39,174,86,249,64,89,192,101,143,207,156,186,210,1,137,143,225,13,38,98,59,92,137,53,31,64,212,100,157,144,100,131,3,65,115,94,185,87,13,25,176,45,184,207,19,250,197,231,86,217,51,191,125,60,11,95,125,105,236,148,166,54,6,42,0,150,180,138,38,30,235,72,106,14,217,69,184,242,46,197,173,38,89,234,41,197,213,165,79,86,118,231,142,207,69,207,108,20,53,179,160,231,84,99,156,253,80,13,15,65,18,73,160,149,31,76,124,141,4,48,207,86,81,87,66,32,121,213,115,116,230,240,201,247,195,159,66,154,244,180,174,14,101,84,3,66,175,40,177,65,194,101,162,234,26,55,222,21,72,164,219,243,129,30,172,104,212,50,6,152,90,233,235,35,221,207,165,225,44,109,74,127,123,173,56,87,209,84,211,48,214,123,5,105,101,78,188,169,175,36,172,214,19,232,125,217,130,252,99,237,244,61,173,193,82,209,216,57,13,12,202,82,193,78,70,69,206,74,240,191,91,25,179,254,242,177,68,23,139,165,101,32,52,246,25,212,240,38,237,147,60,156,190,36,3,56,163,125,228,107,228,6,235,44,250,90,92,77,158,36,217,168,161,77,26,49,125,99,103,191,115,41,120,16,231,243,69,108,169,115,81,127,195,48,164,132,75,173,147,62,148,220,3,189,186,165,200,86,60,18,172,193,207,129,196,167,69,181,134,232,130,109,48,76,133,202,38,184,207,153,39,149,26,4,242,77,59,193,254,102,222,99,68,91,147,245,252,14,111,57,224,121,244,233,148,97,66,37,162,181,44,60,144,184,181,187,204,143,33,120,225,243,226,97,190,168,25,134,240,146,145,251,166,104,183,243,126,93,104,93,84,55,148,49,84,30,71,204,203,236,226,179,113,247,64,213,92,207,126,35,130,231,86,232,149,34,79,127,8,155,120,228,29,247,142,10,151,52,57,180,40,56,93,99,171,253,160,143,201,101,183,204,59,240,23,208,83,198,151,231,231,147,28,110,4,156,102,57,157,18,249,18,50,20,130,56,53,156,41,45,170,41,117,136,179,222,121,239,18,168,166,237,2,237,98,107,148,236,81,60,2,33,181,218,46,71,254,197,234,84,204,80,27,160,118,123,153,37,55,238,240,199,98,227,116,197,126,232,21,255,98,226,206,152,34,211,121,85,69,183,195,225,202,232,188,79,208,206,156,187,96,21,189,252,76,203,227,241,70,211,61,52,217,12,33,243,41,50,152,77,47,82,19,140,197,235,100,59,65,70,115,52,246,95,80,145,224,57,224,221,213,78,145,49,47,117,102,248,205,92,84,18,215,150,191,135,145,62,36,193,200,52,133,187,34,96,149,139,1,97,248,25,51,64,247,58,93,111,15,225,212,223,114,61,92,11,95,154,153,245,208,78,148,39,150,34,40,110,50,154,11,54,4,145,21,134,166,233,0,193,39,105,2,102,29,28,168,238,231,117,248,142,40,50,56,142,240,142,165,151,16,85,30,155,98,225,239,177,187,143,215,228,29,118,98,85,69,167,21,45,116,143,40,42,152,1,87,158,139,169,81,137,18,54,65,178,145,44,82,225,241,84,208,111,202,139,17,95,107,130,255,148,105,65,106,172,230,171,55,197,239,133,168,4,152,247,235,19,138,175,168,216,216,171,23,160,83,71,40,126,234,228,1,76,145,9,132,135,166,202,190,232,233,218,105,184,138,161,252,19,33,132,61,159,183,129,62,37,37,194,79,104,59,218,204,215,82,166,4,190,36,224,43,97,59,71,51,188,214,175,54,18,10,15,153,110,203,218,59,225,113,185,123,75,111,206,104,24,163,254,170,85,40,105,9,229,41,218,37,240,211,103,89,253,97,34,77,188,114,220,132,215,129,26,109,149,186,128,119,108,19,20,122,172,175,10,20,169,9,104,195,150,51,8,159,140,86,232,226,177,7,196,200,167,207,106,126,27,140,222,219,198,149,46,0,13,93,255,121,205,23,206,245,185,247,15,231,173,156,59,156,16,48,118,254,93,148,203,237,189,158,180,101,52,62,155,57,8,175,171,215,67,69,104,60,72,232,226,185,20,206,65,59,42,125,90,124,100,202,134,141,239,191,110,203,164,223,50,232,219,4,222,205,22,70,62,180,75,143,174,228,44,62,245,202,39,117,215,33,145,80,106,131,177,244,66,46,89,167,198,251,80,38,72,190,90,118,85,34,158,83,17,61,132,124,53,24,63,24,90,249,68,131,245,198,183,117,13,157,137,70,189,73,23,75,77,13,25,88,126,217,87,108,92,8,133,154,15,158,112,113,94,186,162,177,9,232,181,162,55,24,38,161,79,176,4,233,11,158,170,242,240,168,77,25,3,223,158,186,182,26,129,84,106,135,108,205,79,254,175,227,1,238,248,79,5,72,169,217,128,158,1,139,110,157,12,39,55,95,3,2,113,179,81,229,38,144,253,35,77,155,97,157,9,47,133,35,238,97,246,176,156,164,3,236,181,42,140,173,1,46,164,218,168,228,127,219,160,224,59,249,247,7,155,98,77,199,215,146,55,151,221,185,163,241,26,122,137,164,190,205,207,4,237,134,165,74,238,223,226,15,248,242,139,107,210,187,234,4,145,23,231,180,229,53,254,166,201,220,10,14,58,33,230,72,92,230,207,170,109,188,229,137,28,147,22,41,192,213,40,215,216,127,14,228,9,13,85,247,106,247,1,155,206,136,4,23,190,148,170,106,194,155,170,96,227,85,168,247,195,20,113,172,17,34,38,123,79,167,110,206,207,53,66,173,162,178,166,84,120,160,160,218,186,227,34,87,100,212,219,28,84,255,59,138,26,28,227,102,205,94,75,152,55,216,163,46,225,96,152,57,32,57,159,27,251,178,201,231,5,139,31,163,136,69,71,125,19,213,46,252,84,88,215,163,249,153,181,25,227,174,4,105,93,98,251,60,164,4,222,26,165,85,83,87,45,206,132,134,6,108,89,96,76,139,144,143,144,116,59,72,48,184,248,230,195,135,167,29,166,42,207,49,87,221,159,42,168,96,157,181,125,152,96,130,72,48,100,105,145,96,98,200,116,7,131,166,69,99,117,55,141,40,125,106,249,33,118,191,121,159,138,79,27,90,132,13,52,0,61,44,246,212,77,127,107,26,124,234,104,26,14,238,68,79,124,247,99,81,60,135,27,62,83,231,104,214,53,69,104,188,95,120,30,105,222,150,218,223,80,221,209,86,113,125,226,123,36,1,136,94,206,253,124,34,218,2,77,208,172,39,238,148,151,111,237,3,135,99,41,22,142,129,39,56,105,255,31,62,12,171,5,206,94,114,13,174,185,89,199,225,131,239,187,92,132,102,86,138,156,36,55,112,65,191,209,70,60,75,110,59,216,180,148,36,118,238,139,97,222,17,236,209,68,163,76,177,206,58,196,113,2,166,47,131,113,199,180,134,23,174,24,119,20,124,144,29,221,9,90,224,188,131,232,13,244,94,200,129,51,27,11,124,24,154,5,91,171,150,238,212,117,175,71,155,110,168,3,236,162,196,193,74,101,6,238,157,132,151,181,88,122,26,84,194,170,253,198,124,142,133,185,66,4,105,5,152,87,209,178,134,243,242,197,214,209,103,53,218,128,193,9,83,231,55,111,29,235,133,45,107,115,71,203,15,1,69,200,105,216,1,163,183,18,222,54,6,56,48,104,228,237,119,166,90,242,184,97,160,218,194,255,151,131,120,180,104,202,167,157,179,147,77,161,34,65,201,171,236,177,175,0,92,134,255,40,217,133,61,187,44,165,109,184,127,37,189,61,62,60,232,182,210,78,123,118,207,185,156,158,77,117,67,26,37,222,174,87,192,241,152,180,170,218,35,86,86,91,87,98,97,192,129,140,194,233,36,79,152,203,136,73,223,63,26,117,190,88,188,60,42,9,45,54,223,198,207,196,237,26,244,60,233,67,132,223,113,147,253,16,126,10,119,41,159,99,237,109,167,23,248,146,7,166,214,75,0,234,202,90,254,26,71,82,240,116,216,96,236,109,46,104,255,134,115,253,155,36,36,129,188,183,140,151,14,153,244,139,244,252,214,160,8,249,226,35,58,185,116,255,126,128,120,235,190,225,169,185,175,255,64,176,56,247,249,7,18,39,92,249,142,98,47,116,247,126,6,66,208,245,253,217,123,160,123,49,99,18,90,47,9,80,207,212,123,18,61,155,193,44,242,205,146,4,96,210,222,194,220,47,172,241,165,29,155,45,163,105,121,174,115,233,211,216,182,136,24,90,234,77,214,70,94,160,35,59,16,39,71,24,186,43,251,99,53,11,47,60,159,24,144,250,41,114,90,26,97,209,154,96,63,178,67,28,211,107,179,90,253,127,165,163,26,175,163,165,60,47,25,151,210,245,25,91,122,31,176,184,179,128,161,75,71,166,119,40,19,58,101,115,237,145,211,239,250,235,224,4,46,64,94,118,213,191,21,42,27,169,75,217,193,182,121,215,57,216,234,245,160,135,78,21,125,113,51,250,39,177,32,227,61,57,182,118,16,212,181,130,153,240,62,148,127,188,127,160,37,3,231,33,68,181,179,95,116,179,14,247,145,214,104,222,71,140,17,161,171,218,105,81,195,25,20,202,235,110,70,90,42,47,194,109,74,85,60,77,65,92,205,106,16,171,147,0,227,16,251,48,224,101,8,46,29,94,50,36,213,78,254,13,7,254,227,219,219,18,45,213,145,136,25,210,42,32,47,62,61,139,31,140,17,210,249,37,178,80,160,59,139,26,250,178,179,208,129,81,82,239,54,209,224,20,156,174,251,26,130,136,28,68,243,28,42,28,17,51,90,6,39,125,11,249,223,165,193,243,148,129,17,210,146,186,89,202,253,59,205,5,52,237,17,181,104,92,54,142,214,177,178,59,214,195,73,72,186,175,17,1,0,220,146,69,144,120,89,133,146,152,239,230,141,237,0,78,250,117,54,179,45,38,167,90,149,136,233,115,8,227,210,205,255,208,177,5,45,173,12,189,122,109,122,136,191,40,176,51,234,201,4,208,42,147,44,56,120,17,43,69,93,97,143,103,130,166,129,101,7,40,85,92,157,218,212,230,114,139,2,233,64,93,127,49,140,232,168,194,0,74,215,40,158,61,12,247,57,151,103,148,42,210,155,139,211,87,19,0,208,70,224,199,34,241,199,70,169,161,135,61,105,233,172,62,114,0,96,15,45,231,45,55,172,39,55,41,225,133,190,138,162,53,142,120,95,183,32,192,36,208,155,102,233,86,61,53,30,206,83,199,125,72,101,207,29,247,104,10,148,18,184,234,165,202,151,116,193,119,185,112,23,192,20,152,65,174,8,254,94,56,95,112,30,175,131,75,160,36,26,226,61,55,97,225,40,77,212,181,0,239,155,198,208,128,240,202,248,190,135,42,46,22,94,11,61,30,199,55,16,98,142,1,63,173,36,147,172,74,152,45,239,201,204,46,115,27,81,227,120,112,155,184,99,79,214,130,147,122,64,139,9,147,208,82,76,15,123,98,5,74,218,198,40,175,162,34,226,243,95,227,126,94,45,242,141,118,9,49,66,13,62,135,201,56,200,96,255,212,204,11,3,243,18,242,108,74,227,62,173,115,180,224,226,248,249,141,136,245,6,158,110,65,8,248,189,225,236,226,84,45,8,72,133,12,176,12,140,172,135,245,88,80,88,0,185,175,79,207,75,134,219,100,194,29,255,125,135,114,8,126,63,172,235,145,65,229,120,37,197,36,66,254,60,122,61,197,192,6,79,197,152,198,219,179,231,14,155,211,69,154,175,209,49,59,91,6,25,138,1,144,199,28,148,67,149,19,37,147,101,173,173,206,196,37,179,47,184,185,251,43,182,74,221,246,66,82,220,131,113,87,197,241,66,226,95,156,93,186,196,250,229,244,248,189,22,207,27,43,104,3,210,183,207,145,95,190,74,251,145,107,71,36,138,225,83,79,207,145,78,210,137,175,90,23,239,94,181,98,41,136,109,211,114,150,87,255,49,149,169,69,132,65,211,140,205,214,29,22,127,210,12,110,19,72,139,152,200,229,246,220,110,222,227,189,5,36,90,254,53,6,237,122,57,142,108,23,90,140,146,218,237,207,124,148,18,43,1,231,98,177,83,35,133,156,57,105,201,222,84,80,168,12,176,33,62,83,81,72,91,127,176,136,94,105,255,254,90,145,155,68,132,45,203,4,81,16,2,218,66,189,227,170,31,12,196,122,121,143,12,99,122,129,195,234,210,79,14,55,209,162,72,6,182,66,57,203,144,165,124,104,28,239,250,145,78,30,73,201,115,103,29,184,58,64,70,85,21,63,220,48,82,120,182,147,193,160,57,159,29,228,110,185,119,116,208,106,226,116,121,81,43,222,244,81,208,45,54,252,92,150,203,97,118,228,145,19,251,135,68,118,217,134,205,225,179,191,233,152,12,91,197,183,100,112,245,155,90,49,164,31,226,11,161,97,101,12,52,104,87,67,185,88,236,186,244,207,7,33,67,86,181,69,233,84,8,132,228,204,119,32,165,140,91,72,140,72,59,85,160,243,119,182,101,202,174,103,225,103,157,66,245,6,239,65,118,228,82,220,95,37,111,101,138,161,191,68,163,207,254,132,5,33,34,56,45,15,145,79,100,40,250,236,235,36,175,245,20,209,154,13,198,149,155,0,80,11,84,80,172,105,217,187,232,7,132,48,231,150,103,105,189,165,83,77,153,247,75,244,46,186,175,219,208,150,199,180,28,58,132,148,105,13,207,113,32,133,101,252,13,167,207,239,200,38,246,25,126,101,156,150,20,134,155,28,193,203,237,91,8,31,34,172,248,160,57,105,219,239,42,133,226,116,81,43,132,235,167,30,68,43,231,221,164,52,182,249,179,61,153,161,159,137,151,189,73,236,246,163,36,98,19,85,248,126,173,105,179,75,212,179,6,192,100,128,153,211,199,108,66,203,86,207,169,95,199,34,119,154,244,10,13,220,112,98,175,183,40,113,55,27,57,116,86,1,170,179,54,173,252,94,178,69,116,19,143,251,130,194,112,136,117,223,38,229,127,85,195,14,156,30,223,71,155,223,129,124,152,171,136,110,120,95,180,53,100,168,25,3,216,42,54,85,46,69,119,107,155,145,251,64,53,185,193,15,13,139,6,167,11,60,47,89,97,48,152,126,89,204,146,71,95,57,111,150,78,240,251,102,115,113,11,147,15,192,253,231,25,248,245,109,134,153,56,58,101,46,144,2,253,31,2,83,198,61,64,121,63,76,80,67,29,12,66,28,147,254,92,69,68,35,212,156,221,161,237,249,146,56,121,137,145,156,246,183,247,139,124,62,163,212,103,229,186,93,174,69,23,160,26,196,181,43,175,176,60,110,211,55,131,146,61,179,46,79,154,194,63,7,77,202,244,150,202,18,92,217,129,241,239,222,111,51,135,13,231,255,23,171,205,2,165,228,225,46,247,213,245,181,190,140,154,241,182,186,251,24,83,159,137,53,64,138,170,164,60,147,27,90,82,193,36,201,173,182,188,108,188,229,45,193,211,18,253,200,185,25,95,180,93,30,219,69,195,239,222,97,161,110,214,36,114,96,168,76,77,164,53,131,226,197,100,0,42,106,159,84,214,55,249,124,216,170,102,155,118,134,77,181,65,115,14,167,123,89,46,212,228,181,29,222,148,86,228,253,74,236,231,197,148,188,137,167,27,127,12,253,186,84,67,146,211,91,131,122,218,230,239,254,175,168,1,213,249,121,7,221,136,146,201,36,166,47,73,221,190,128,205,126,206,89,121,78,233,57,64,136,20,67,198,178,249,191,17,131,33,149,197,130,104,170,130,142,237,246,170,147,192,156,248,187,123,25,225,139,220,171,61,24,24,114,110,77,3,160,244,82,56,94,113,16,27,118,228,217,56,29,253,10,75,145,97,193,150,89,210,52,60,146,17,127,187,216,5,195,108,15,251,39,157,158,86,49,193,199,155,106,6,73,80,247,203,61,88,81,56,93,158,179,40,245,81,68,136,69,32,237,101,122,112,165,100,55,9,127,59,26,9,41,16,102,92,246,179,125,108,231,225,63,120,88,135,69,195,239,197,51,245,72,72,59,15,231,42,3,184,123,64,176,64,2,15,246,220,67,193,252,8,159,56,20,44,137,45,172,109,183,204,159,101,6,17,221,228,44,160,69,242,153,202,128,203,12,4,126,92,35,50,234,50,118,36,235,41,31,25,142,113,24,62,9,95,20,19,50,125,158,204,53,186,86,53,189,102,153,228,219,22,2,99,14,143,147,221,199,23,113,107,196,224,225,104,121,99,34,19,112,121,28,191,160,245,10,17,84,184,88,225,151,167,54,240,195,72,254,120,18,22,155,131,146,29,227,234,30,101,250,135,69,125,243,191,220,108,252,27,73,15,229,136,53,207,18,173,204,19,205,199,182,167,225,33,249,143,99,91,17,55,149,227,252,128,238,114,212,169,242,145,36,176,68,219,87,139,157,11,63,61,59,211,206,153,189,127,223,109,58,97,39,141,146,29,253,92,94,80,25,18,106,154,118,230,19,134,225,160,83,60,150,40,14,114,137,33,215,197,110,48,190,240,56,91,138,248,129,37,247,39,83,175,2,103,194,229,110,102,216,12,120,6,3,226,163,55,78,249,252,111,226,91,6,137,148,130,47,48,247,229,23,243,182,71,150,137,124,20,124,66,139,32,193,148,161,185,236,79,174,99,200,112,53,55,117,29,34,237,204,153,30,100,212,1,178,63,101,108,21,60,226,164,189,178,191,164,14,130,253,211,82,162,209,199,23,248,243,208,248,249,158,141,215,199,86,0,246,74,146,131,115,160,41,65,31,203,224,248,194,77,33,67,47,171,200,140,46,76,21,188,172,177,183,243,246,224,185,32,56,122,180,233,201,25,233,15,85,45,133,25,16,136,35,136,145,142,15,86,80,133,48,119,224,178,65,40,193,213,90,108,89,160,56,151,217,217,57,103,175,63,242,81,89,154,80,29,72,39,62,162,124,64,207,184,236,170,24,70,121,44,61,235,14,3,108,68,201,57,178,69,188,58,91,211,235,251,154,69,34,123,86,213,66,253,253,216,176,67,99,197,91,185,250,198,244,215,134,106,130,27,155,101,61,23,181,173,83,247,184,185,24,221,87,94,129,150,24,83,250,180,99,14,23,157,95,133,189,98,219,252,120,118,181,213,41,131,138,220,245,32,75,155,209,55,31,197,21,188,175,14,108,96,144,219,70,87,169,105,80,215,39,54,253,164,135,220,113,179,11,26,86,90,17,173,82,168,51,234,219,159,197,190,211,12,96,163,96,156,21,216,237,81,71,8,238,177,222,65,238,18,207,224,198,6,78,77,58,229,128,113,49,80,53,64,60,188,235,183,243,253,19,186,159,48,179,25,11,199,176,100,249,48,94,85,170,164,215,111,157,248,47,235,115,199,148,241,90,5,156,158,194,36,48,2,128,54,251,107,121,73,162,149,9,148,65,58,167,164,203,170,52,197,196,44,120,167,22,204,41,135,101,200,149,248,38,73,57,71,205,69,158,255,72,185,219,30,199,49,162,53,242,190,45,142,206,11,94,30,40,120,221,10,171,209,31,64,30,69,102,138,222,180,169,4,28,97,34,15,174,50,15,217,31,255,141,56,24,233,173,156,216,252,142,255,94,59,43,223,147,253,34,44,189,10,93,55,252,67,27,40,123,12,243,5,33,140,234,16,240,115,171,26,131,179,201,114,216,135,196,14,204,11,226,91,159,139,238,182,65,152,10,212,173,146,189,31,16,197,251,214,140,176,101,41,217,127,19,65,118,112,116,119,159,28,52,102,175,254,92,132,73,106,70,124,121,229,34,136,208,230,102,14,165,73,4,170,233,83,76,138,148,54,152,21,227,68,40,188,180,162,79,72,48,228,26,205,64,66,33,171,221,163,170,114,114,184,172,219,201,168,200,24,77,52,12,80,226,95,105,205,101,189,221,3,5,202,38,226,148,208,76,126,116,245,120,125,186,56,187,96,82,46,133,211,10,66,86,187,156,137,23,160,98,171,226,232,11,114,200,18,250,211,87,122,21,93,163,90,104,194,160,53,194,74,207,94,195,91,24,76,184,136,174,136,22,245,12,54,167,76,106,249,48,251,40,188,97,95,223,30,22,142,194,231,189,143,57,151,51,105,150,197,223,211,167,34,90,118,91,128,229,236,240,185,96,234,208,26,179,111,122,244,232,80,12,38,10,75,30,38,189,236,165,19,26,106,197,252,71,235,185,204,73,177,213,143,142,148,0,198,150,67,125,250,112,233,80,164,49,60,6,157,40,93,68,163,97,177,11,138,69,11,80,35,151,37,226,112,83,104,68,199,208,112,120,18,122,5,174,225,120,249,246,187,239,139,207,193,43,156,214,226,0,98,218,49,189,224,164,249,146,98,223,125,50,17,156,249,81,199,227,5,93,233,167,93,238,114,241,192,104,44,145,2,60,79,168,0,112,62,78,120,31,150,105,225,33,243,194,10,247,239,80,186,67,248,147,112,190,206,149,49,185,35,4,129,193,254,128,152,100,164,105,79,44,168,54,203,1,129,230,43,92,174,4,56,200,148,20,82,211,212,136,193,83,214,240,81,138,39,11,132,114,55,99,194,4,143,40,233,177,238,255,46,166,183,5,115,190,182,171,253,136,6,248,32,219,26,252,55,109,189,224,176,219,6,131,136,170,148,101,102,58,242,121,97,120,125,146,126,232,251,70,200,193,191,199,169,112,172,43,218,147,205,17,215,99,9,141,194,206,149,104,71,115,45,250,190,121,28,115,88,81,131,250,172,238,160,98,146,119,165,113,166,10,172,34,174,43,44,119,114,32,110,169,188,210,22,181,71,3,8,218,196,202,103,105,234,72,209,168,202,3,206,120,58,52,91,169,202,207,73,67,52,223,246,40,85,129,186,17,147,193,231,46,110,139,178,74,210,186,252,20,42,212,66,107,31,239,184,60,105,247,138,212,29,59,35,147,239,109,123,57,144,11,149,66,71,134,57,20,223,47,197,51,83,184,140,102,217,213,245,43,232,173,139,129,135,141,23,147,64,170,6,101,154,52,47,242,34,140,3,101,199,41,95,122,146,104,251,210,114,60,120,85,93,235,23,132,185,200,46,225,58,185,30,23,139,234,67,231,176,36,70,216,129,111,57,23,74,254,117,89,199,41,209,178,61,214,211,184,105,167,86,249,49,90,42,123,168,58,104,222,200,67,41,108,0,17,167,116,177,110,201,116,233,182,36,97,100,6,194,14,109,98,123,229,192,135,60,139,212,178,229,24,178,75,57,129,64,124,38,73,23,182,0,233,69,40,62,242,69,133,151,96,88,46,115,166,144,227,171,12,67,150,150,224,205,128,11,68,98,7,65,199,98,217,18,163,103,246,75,237,111,191,192,188,237,204,240,118,109,98,193,54,170,132,185,37,96,110,213,152,18,190,35,50,82,137,93,149,215,225,221,42,90,5,238,158,171,51,61,216,167,102,11,175,66,32,95,200,136,58,38,185,31,31,7,154,137,77,199,135,129,68,11,138,218,56,51,63,138,232,178,118,35,168,128,222,75,254,4,133,240,20,138,225,42,242,179,147,238,252,236,171,207,216,158,161,187,121,28,211,191,97,168,90,83,211,109,149,65,124,180,9,172,11,247,233,144,178,35,236,201,59,110,14,121,70,14,224,61,254,78,212,28,174,65,117,240,197,140,63,81,231,180,236,142,119,35,45,55,146,227,92,243,89,103,227,113,113,7,241,196,218,216,222,133,210,176,201,227,29,129,190,164,242,224,9,230,82,122,179,114,75,246,39,15,229,149,39,223,54,20,209,236,251,52,201,186,78,73,37,151,126,3,228,78,186,96,42,131,8,164,251,31,66,192,181,12,97,55,186,77,32,219,199,151,33,3,42,85,29,142,29,6,107,115,68,114,214,114,140,199,143,20,245,129,9,78,83,246,169,65,41,122,99,69,204,115,173,8,254,95,66,163,162,48,175,244,113,209,100,147,112,188,220,233,113,5,212,201,138,91,38,191,72,7,99,178,116,234,92,48,244,0,211,154,27,247,206,232,89,85,99,233,132,72,85,200,139,238,153,179,24,123,99,134,246,142,188,239,9,157,112,162,234,185,118,245,59,130,224,204,31,163,171,38,159,221,225,99,216,177,58,35,104,109,10,125,89,23,53,56,37,68,165,189,60,83,249,63,161,240,70,141,1,210,143,125,157,56,227,11,24,55,38,168,16,119,213,155,223,143,131,175,37,234,125,238,16,194,101,201,158,4,110,18,210,221,84,87,14,13,169,250,241,240,1,12,205,98,246,198,75,250,239,249,104,97,127,57,19,15,104,126,28,59,196,119,32,32,82,17,212,81,175,226,118,175,241,105,177,135,71,82,187,16,240,159,71,37,41,230,115,64,156,184,169,24,234,219,0,246,117,253,167,73,143,69,3,130,245,116,43,177,166,154,119,212,153,47,46,26,192,155,252,200,241,110,201,195,252,231,181,147,45,221,62,85,89,150,72,79,230,174,245,52,49,209,202,184,143,160,9,190,63,249,33,193,163,53,123,237,31,46,225,42,225,49,158,14,120,71,133,247,37,52,27,195,168,0,173,254,175,48,203,127,136,142,20,140,58,102,224,52,13,72,195,143,146,84,91,160,228,92,126,63,39,81,150,207,232,13,28,22,22,113,169,45,140,23,5,46,155,127,197,116,25,54,226,104,89,169,95,100,83,211,41,119,115,107,60,190,170,12,213,173,189,220,228,10,211,105,116,245,166,208,229,181,165,201,68,170,57,36,97,78,110,76,75,65,230,77,138,17,146,196,148,196,16,237,121,105,24,158,75,121,236,185,205,129,31,100,68,181,179,248,183,65,29,74,96,126,223,176,27,19,62,148,147,12,48,70,173,22,7,123,162,216,137,16,123,171,81,196,100,84,138,92,119,3,209,28,49,46,184,35,78,201,26,213,233,176,139,204,161,161,100,134,151,46,27,220,236,243,154,104,171,179,29,24,244,219,213,4,109,217,17,167,110,219,11,225,255,47,80,164,122,91,85,104,133,179,78,39,122,132,12,176,53,220,175,184,93,42,5,93,129,217,176,225,1,179,77,53,121,239,203,231,143,218,94,107,129,31,11,195,254,148,78,105,60,149,153,223,20,120,153,7,211,141,71,154,236,170,254,85,202,104,196,108,18,145,215,252,129,244,163,252,137,151,112,146,157,1,59,187,240,13,15,2,216,118,65,35,126,38,27,221,174,235,245,160,106,120,196,95,105,214,48,54,136,226,74,65,88,37,3,224,245,60,140,2,150,249,134,212,251,59,123,169,14,76,79,118,67,227,62,202,182,40,50,114,7,24,44,54,254,33,251,230,193,198,191,167,178,228,71,214,100,187,93,9,99,58,230,102,178,170,160,39,178,130,14,57,7,70,171,249,174,14,35,35,120,237,233,152,182,162,97,118,134,142,150,24,7,159,154,144,20,178,175,155,125,114,58,253,140,118,189,3,236,201,17,137,170,158,6,138,214,209,52,137,203,102,157,11,99,113,92,97,55,117,153,111,20,219,251,13,105,77,46,143,89,53,195,147,116,53,124,195,182,95,154,49,226,94,206,124,56,128,210,109,131,196,167,229,110,5,138,241,184,84,170,48,209,20,77,49,194,144,208,224,23,8,82,52,152,83,235,136,168,48,59,7,125,42,229,139,89,170,227,83,9,67,233,174,188,101,17,74,229,208,35,149,23,105,183,73,116,1,80,193,46,164,25,242,129,1,17,88,87,87,94,55,96,126,151,60,35,202,219,9,3,222,161,131,34,149,198,202,198,131,167,91,75,106,85,22,230,193,8,201,156,81,226,164,111,44,147,161,162,209,240,123,26,148,30,161,104,16,29,236,170,204,149,74,126,34,109,24,139,125,1,32,228,137,89,30,201,147,146,189,177,123,185,72,228,107,91,49,121,163,27,243,72,155,29,183,58,67,212,196,210,201,58,31,102,67,158,141,70,175,80,213,3,99,198,124,34,110,94,209,77,20,85,45,162,82,18,61,189,203,199,56,131,228,230,7,53,226,247,217,35,66,115,37,68,130,210,200,156,186,44,33,11,229,31,84,159,92,194,52,14,158,187,179,106,80,194,179,80,226,202,110,147,204,167,44,63,158,49,55,80,115,164,46,156,244,58,137,134,55,253,220,75,9,103,136,249,242,3,215,220,53,123,17,75,112,40,131,105,76,0,16,17,245,242,195,47,165,106,200,206,26,130,189,65,203,2,99,181,5,143,191,100,128,52,249,154,169,127,159,85,163,175,105,201,79,170,124,33,172,15,229,166,146,194,104,108,129,91,132,33,195,224,4,116,61,113,89,52,79,251,121,2,32,71,98,121,115,214,245,87,160,16,97,250,177,149,55,39,223,212,203,76,231,248,127,176,129,187,75,9,209,101,237,148,65,111,200,193,164,44,66,237,159,220,85,84,91,89,208,128,237,151,180,31,151,237,151,16,114,221,155,43,42,4,83,34,238,79,149,66,231,157,222,132,11,145,104,170,56,236,84,248,183,36,85,4,10,143,170,141,177,87,7,163,114,225,72,248,238,122,146,203,203,157,4,155,198,245,193,60,218,180,175,34,89,80,195,35,71,85,234,238,86,77,49,244,128,157,230,211,30,114,38,88,35,242,190,254,27,132,194,18,236,121,228,133,95,97,44,236,154,28,64,235,14,62,141,6,104,2,239,196,0,239,190,200,189,55,225,88,118,166,28,3,155,39,73,135,166,250,86,28,103,243,78,21,135,177,206,135,183,141,13,148,181,253,155,176,98,53,113,191,110,156,23,111,210,0,12,145,6,255,146,80,247,0,74,171,33,213,96,90,118,193,89,208,79,47,247,61,246,11,199,235,65,231,27,63,41,110,254,129,80,132,0,167,84,59,171,175,164,131,185,207,179,36,207,187,236,180,205,188,150,112,119,170,82,180,155,78,6,33,163,196,74,97,85,204,95,48,248,81,22,74,219,228,3,163,28,111,155,134,69,37,9,187,242,25,75,186,8,17,151,196,130,59,118,14,82,207,194,129,82,65,199,147,72,96,117,243,22,125,145,219,206,184,153,41,144,219,98,96,155,34,94,181,44,163,237,168,33,89,151,218,192,247,57,198,126,236,197,141,63,109,159,157,29,83,185,46,181,8,73,42,95,252,161,116,224,219,172,169,119,219,52,46,170,69,178,172,93,174,0,45,81,139,114,181,102,240,100,159,66,137,156,200,175,244,173,51,117,206,244,24,77,6,23,82,12,37,118,160,225,85,183,69,79,100,126,129,93,155,18,95,145,39,32,118,241,90,236,152,14,20,126,31,234,84,34,120,172,90,243,50,162,34,238,83,91,24,255,99,225,240,27,114,166,100,243,207,98,170,111,107,224,19,79,177,203,231,135,126,205,13,231,108,153,215,16,143,6,18,244,71,18,188,143,224,169,189,54,129,185,202,121,10,142,246,219,251,81,92,184,115,207,55,223,23,9,172,6,80,2,236,96,4,51,62,54,135,46,10,0,229,235,188,235,218,127,115,177,136,157,40,2,71,146,32,245,200,137,190,179,220,117,208,242,197,14,183,79,124,35,171,203,89,139,208,30,50,32,249,148,242,236,98,48,88,255,143,25,1,235,159,210,127,229,219,6,20,19,41,23,220,116,32,214,217,7,197,244,101,247,93,18,117,151,140,84,68,104,42,232,36,226,57,55,57,181,128,52,6,203,130,54,199,103,197,158,184,138,127,61,223,65,111,57,25,181,72,139,155,65,139,48,15,128,95,194,241,163,12,246,39,191,53,212,114,194,90,65,109,13,121,48,171,160,68,35,192,251,149,193,182,207,178,158,107,32,192,59,214,166,145,205,76,194,17,236,248,105,195,184,201,91,214,106,71,163,206,253,189,15,166,160,158,55,182,108,213,82,244,47,221,194,227,48,139,93,104,165,186,46,214,47,63,142,36,158,192,116,253,133,77,50,45,85,208,33,203,120,156,6,55,217,53,210,131,30,194,170,65,32,80,32,81,218,104,125,77,236,131,42,23,51,41,208,230,40,175,127,201,126,254,209,89,221,187,181,101,185,235,139,217,248,49,187,232,192,124,28,52,88,70,236,155,38,60,43,157,178,180,45,203,113,4,9,67,86,60,136,52,5,61,152,126,254,205,152,68,61,64,58,226,75,218,19,204,177,16,138,148,243,180,234,110,6,134,194,139,167,50,151,95,62,160,137,209,208,255,81,199,177,240,114,1,163,160,235,235,172,203,57,245,240,94,121,56,11,132,16,23,152,180,38,90,26,107,103,77,223,70,133,160,220,55,161,159,238,135,127,195,39,208,86,53,94,195,241,255,207,90,238,9,252,64,51,154,107,238,114,42,193,58,242,19,108,172,209,86,71,42,197,80,100,152,114,254,57,174,37,64,50,36,160,251,173,106,84,18,16,170,209,101,166,151,240,142,96,134,97,50,207,93,244,231,22,49,72,181,188,188,85,53,41,160,158,84,157,23,30,169,226,115,33,73,115,107,143,0,226,138,147,191,74,190,144,231,29,158,45,154,232,182,228,53,105,112,118,75,176,179,123,111,233,14,139,90,157,138,223,14,191,88,106,91,191,149,119,119,125,12,238,211,244,188,43,214,146,153,165,147,172,221,81,131,160,19,124,234,236,188,144,176,73,96,127,208,169,247,17,186,160,163,61,186,59,233,72,217,58,90,43,43,23,250,105,188,236,66,19,98,125,250,90,130,162,167,174,46,218,37,184,26,92,237,34,0,26,104,74,167,221,23,105,113,9,187,125,231,185,93,92,121,93,23,185,54,19,90,235,249,3,121,58,43,88,53,140,51,45,206,210,228,223,67,147,216,82,11,167,178,164,218,132,152,116,134,84,112,15,165,106,15,116,46,222,118,186,76,133,157,255,99,27,35,96,230,14,223,36,164,244,30,234,71,169,225,124,239,103,239,185,44,71,223,241,177,16,211,173,64,220,127,244,65,244,249,195,214,90,121,43,248,177,241,128,96,74,224,104,16,53,79,225,14,219,175,78,129,103,35,184,131,156,66,49,75,196,237,145,109,124,157,74,188,157,84,32,153,170,210,235,165,6,155,60,118,114,50,169,40,37,1,220,122,220,107,20,39,19,238,244,128,227,140,103,0,179,250,11,140,38,165,57,63,111,193,84,165,175,223,21,24,232,153,190,211,114,99,96,103,146,32,24,107,66,117,93,27,243,49,114,246,219,30,34,20,17,69,183,243,131,101,22,123,146,89,58,14,130,29,141,36,211,54,162,164,189,208,207,2,157,64,29,178,133,166,206,71,226,123,104,195,207,127,14,140,247,187,212,124,199,222,83,46,134,206,111,75,190,63,73,82,47,139,200,197,11,130,44,168,239,104,124,162,31,115,106,15,77,72,8,188,215,102,185,145,177,146,105,215,243,128,236,120,202,35,200,18,3,56,41,51,228,233,136,75,253,209,15,226,133,173,67,184,30,89,158,18,91,156,153,18,111,152,178,1,79,85,158,151,216,76,58,134,155,146,49,89,17,51,188,208,128,156,11,43,131,131,106,12,149,63,166,121,16,63,219,137,51,65,222,5,172,189,253,110,113,53,167,226,44,245,31,50,38,174,100,68,22,13,112,212,36,155,239,195,60,53,18,123,223,198,86,22,195,153,183,238,240,84,186,32,5,221,42,82,204,140,146,40,142,221,64,66,150,70,55,47,30,39,14,91,230,39,190,250,204,44,92,192,48,150,46,192,2,42,75,126,145,237,31,191,38,153,131,36,227,179,79,231,201,9,204,104,33,64,247,81,36,153,134,244,72,253,218,167,247,131,248,178,75,238,207,226,79,244,209,92,176,76,70,26,233,159,72,80,240,245,86,236,211,60,129,147,52,202,224,10,121,136,140,72,97,73,10,133,96,120,170,207,50,34,150,192,32,223,232,196,218,17,88,13,218,31,177,119,20,156,206,58,133,152,213,248,174,186,249,107,70,175,113,37,10,115,145,51,107,100,20,219,82,204,77,140,219,219,169,215,58,48,94,235,31,79,145,66,12,48,214,3,229,197,44,184,188,88,27,187,162,100,106,211,186,207,12,7,55,129,174,102,0,79,203,232,178,166,41,96,67,20,205,236,10,17,185,214,114,166,94,180,205,186,114,55,253,184,106,217,46,50,15,196,129,214,56,81,178,117,165,228,136,107,226,194,252,239,232,52,189,121,119,33,227,225,214,234,74,40,173,225,105,36,9,32,65,235,127,209,218,119,230,246,90,85,92,208,117,25,145,241,125,158,150,196,130,194,200,251,49,170,85,124,87,213,239,96,184,96,197,63,244,187,217,215,49,3,224,114,164,10,22,251,65,108,238,13,29,254,18,139,129,219,58,169,151,73,96,64,221,26,16,12,14,12,78,9,203,11,80,73,221,118,103,173,1,169,193,215,109,126,166,137,12,12,135,17,81,209,32,12,131,60,0,153,66,201,121,182,155,39,109,173,1,186,45,253,219,88,63,179,91,22,106,108,66,107,17,105,97,59,6,133,136,82,129,125,190,184,234,131,23,198,146,94,243,204,25,190,50,160,81,176,220,38,215,41,120,112,38,74,163,171,24,106,116,214,231,194,77,99,71,195,47,141,134,111,103,119,122,241,34,5,170,123,150,232,85,63,156,112,76,202,78,176,136,79,161,164,245,223,119,235,27,8,99,121,57,0,225,90,143,129,173,209,102,133,158,64,233,181,113,212,237,35,132,15,88,36,85,226,152,217,11,16,251,213,25,7,85,125,48,155,221,141,133,205,66,237,6,5,241,72,247,133,199,177,78,236,71,27,110,205,207,241,40,22,141,156,101,179,172,227,30,248,161,147,84,177,176,26,32,103,36,110,30,67,137,223,121,255,110,247,94,76,30,149,83,111,96,72,165,93,200,58,207,176,213,13,29,75,187,45,112,179,43,234,213,242,216,43,249,33,207,40,167,96,46,219,167,44,111,57,183,96,243,201,5,215,73,106,130,134,7,142,153,17,97,126,88,35,57,154,246,15,16,48,120,187,131,106,242,11,250,99,54,230,135,88,172,62,208,30,127,145,236,44,247,246,202,229,174,206,139,144,172,167,141,73,106,163,33,202,57,80,76,67,219,18,99,153,119,22,223,8,132,90,173,119,88,241,34,158,228,149,129,248,73,110,153,176,170,26,33,117,151,227,204,107,181,26,21,245,164,236,219,77,199,199,35,205,68,49,148,238,100,242,214,99,155,100,23,181,56,99,13,119,225,107,153,143,182,246,225,208,95,196,75,114,87,98,134,84,115,210,91,16,159,38,83,255,6,141,147,176,178,28,7,98,154,157,117,22,186,222,203,229,195,97,78,111,21,1,209,7,216,220,49,206,103,113,12,92,248,125,213,205,208,125,25,23,255,131,122,18,244,102,110,19,246,57,97,29,160,122,12,249,191,178,249,218,202,196,118,95,227,2,202,72,253,166,224,126,142,247,255,235,17,182,40,239,72,49,69,198,190,146,45,197,143,72,232,60,106,114,24,207,64,199,21,148,63,154,255,94,65,161,221,130,35,137,115,115,180,84,241,144,61,126,156,106,22,242,150,187,185,206,193,114,109,233,188,162,195,80,84,37,148,76,38,233,82,107,55,196,65,244,142,66,169,247,79,119,3,176,143,31,254,163,250,36,254,95,244,199,37,243,80,12,199,218,35,41,133,113,33,14,19,65,68,109,255,12,46,255,36,190,184,245,158,28,243,54,230,255,252,10,28,140,185,137,52,36,177,174,246,253,228,33,46,4,171,48,142,104,247,44,43,68,29,108,218,170,183,172,241,193,73,207,219,37,138,1,150,130,219,251,45,165,77,163,56,41,211,48,28,136,245,232,57,137,129,92,21,128,45,154,238,208,32,231,214,120,74,179,72,201,37,186,206,84,50,7,123,49,12,239,253,65,164,149,178,102,109,53,34,240,96,200,137,6,135,145,49,172,151,73,182,67,200,127,30,211,36,85,185,165,56,97,54,221,209,90,70,22,143,152,129,15,204,59,5,143,171,180,132,244,145,20,44,11,142,181,72,223,151,147,26,241,164,157,222,7,97,79,43,35,103,66,163,25,155,118,174,109,181,98,111,56,136,55,63,81,51,89,250,61,148,153,110,132,172,218,99,18,104,242,83,175,53,197,209,126,182,44,53,73,229,104,21,252,214,227,27,176,170,31,200,156,251,40,253,90,104,145,10,1,175,235,135,77,56,137,11,51,99,233,59,250,122,62,196,2,245,142,86,59,143,192,123,130,214,245,182,157,134,228,82,199,243,29,167,83,105,75,4,236,116,174,50,18,89,242,200,87,109,23,221,184,42,3,82,80,103,135,218,190,7,129,98,180,64,149,196,181,217,136,28,58,56,53,14,16,248,30,82,197,85,149,53,2,112,81,243,53,131,126,174,187,3,237,209,3,20,9,246,22,3,194,201,118,169,89,116,66,199,66,16,175,193,47,238,65,137,126,87,148,144,167,191,216,137,23,120,162,24,80,68,168,161,148,167,6,137,56,1,160,59,75,181,56,92,175,90,233,7,212,173,52,242,167,91,64,194,196,220,18,71,186,221,224,84,47,76,156,55,190,180,102,18,21,27,55,125,249,219,154,48,54,210,58,72,73,154,78,48,73,105,233,200,178,230,208,130,172,18,160,79,130,20,166,83,203,232,203,108,136,211,228,152,192,103,222,8,46,245,50,29,25,234,254,228,47,202,93,242,41,33,139,115,212,186,141,90,222,177,4};

// The scrambling tile of 128x128 pixels.
// Each pixel contains an optimized 8d key used to scramble the sequence.
// The keys are optimized for 4spp in 8d.
static const int scramblingTile[128*128*8] = {199,3,43,44,83,88,9,109,120,198,120,4,89,192,55,29,14,89,219,60,139,81,163,91,18,101,104,90,148,170,75,237,15,205,23,144,65,165,55,53,107,249,165,128,166,130,143,185,185,23,153,182,247,151,69,59,207,119,135,204,51,247,222,188,146,138,44,67,61,92,43,252,212,172,192,63,69,234,167,148,152,223,24,90,19,6,27,29,64,142,86,217,35,44,236,51,177,205,229,216,1,147,44,215,24,225,122,84,185,114,157,73,138,180,141,175,68,234,145,140,4,197,99,51,64,37,111,209,43,19,242,88,47,193,142,102,115,62,226,152,82,254,86,227,57,69,186,151,188,212,221,111,55,12,29,240,201,69,219,63,75,156,139,67,8,128,158,200,196,42,39,74,254,189,243,39,90,23,27,222,130,151,43,32,118,58,82,38,36,123,121,32,176,150,135,119,154,23,36,43,171,177,57,163,161,78,5,243,145,199,167,242,139,37,157,144,80,67,150,206,154,254,130,31,81,146,200,246,142,177,133,224,252,53,224,221,187,238,61,154,2,164,196,194,215,152,175,46,227,2,22,29,88,238,132,202,204,162,187,17,122,20,207,4,184,66,104,12,205,163,18,191,251,52,180,44,171,52,141,199,188,44,171,103,208,122,138,89,58,91,46,93,177,200,44,104,200,220,31,1,230,220,6,142,230,228,167,50,228,88,34,175,98,95,134,26,85,126,228,37,56,33,17,36,168,68,136,204,128,85,48,64,174,236,230,161,125,187,254,233,197,206,131,188,77,173,92,167,101,229,224,241,225,143,33,123,219,247,38,60,86,111,227,87,148,198,205,171,70,251,16,195,252,11,243,213,104,213,66,209,113,154,216,51,10,178,109,62,190,229,166,237,164,17,155,159,215,60,247,4,185,165,75,73,237,30,28,228,44,168,116,117,94,109,78,24,95,60,21,67,196,240,35,14,120,122,174,37,170,78,72,219,42,139,164,201,240,147,165,182,38,110,216,246,185,8,138,11,237,94,176,38,69,72,76,220,238,238,201,170,88,210,87,233,130,30,50,46,165,247,59,144,191,171,157,253,177,193,11,171,69,125,2,214,221,255,103,180,89,205,95,67,68,139,246,231,125,38,113,130,90,78,35,141,99,16,234,226,156,45,237,179,67,109,130,92,239,130,151,147,94,134,157,16,142,178,227,110,54,82,134,251,80,210,218,55,69,232,105,118,229,98,155,139,232,243,249,219,104,49,177,112,118,101,83,233,216,13,52,192,25,45,108,197,96,102,29,136,156,87,91,121,241,143,220,22,207,41,96,176,122,52,0,38,40,31,82,199,37,141,47,179,94,189,100,65,176,188,175,126,86,55,77,112,148,208,113,157,22,115,184,148,1,159,109,54,43,204,94,225,120,49,178,192,135,123,14,35,144,96,137,8,147,4,231,239,135,3,56,185,248,201,116,97,100,210,189,216,227,167,112,173,226,157,222,145,215,157,133,205,134,41,244,73,218,177,188,47,9,116,177,128,83,149,150,15,122,214,236,154,34,190,246,155,213,182,236,81,56,84,121,189,5,203,105,22,81,117,85,129,30,110,211,131,8,129,59,40,31,226,66,60,214,83,74,59,102,0,132,159,206,191,136,27,121,170,102,7,173,210,166,239,216,141,46,167,2,212,92,3,245,8,76,245,35,51,224,231,136,42,36,138,34,255,201,121,63,12,155,180,237,229,143,71,28,241,210,175,158,255,174,154,121,212,173,137,49,21,92,161,137,120,30,221,148,66,96,60,98,60,230,213,233,168,134,211,127,233,213,175,45,75,118,246,102,202,81,52,235,64,77,148,209,86,80,107,175,9,87,82,198,255,172,237,179,43,52,221,12,21,14,220,114,179,177,215,48,221,63,252,220,79,200,91,205,237,52,103,22,29,130,89,14,83,204,78,146,156,217,222,34,217,154,19,64,195,65,202,12,142,112,127,170,73,120,167,101,86,206,86,133,195,242,172,130,202,123,253,20,146,87,118,59,232,30,170,99,247,248,118,72,126,12,102,154,90,57,171,184,245,216,119,255,104,175,240,95,238,250,14,58,92,156,206,11,45,249,232,121,185,79,8,41,139,160,174,147,179,242,112,66,219,133,71,204,159,123,61,68,171,171,13,244,244,127,83,187,34,159,243,113,167,59,163,118,66,167,226,5,138,230,244,141,174,34,158,190,52,52,11,150,3,253,53,70,158,177,26,148,97,197,12,129,88,199,60,28,28,25,44,162,172,55,184,164,85,254,180,42,62,149,95,122,106,202,148,13,0,181,45,188,120,244,240,235,232,84,210,159,145,33,184,197,124,237,253,191,250,219,165,80,92,75,141,56,88,84,126,102,168,37,182,91,133,30,6,125,146,68,97,26,146,230,159,244,235,35,196,234,188,55,172,75,87,124,235,100,218,105,132,163,33,222,73,2,182,104,0,228,21,79,107,95,120,73,33,254,118,181,6,233,144,103,195,171,71,58,28,76,161,250,188,16,112,238,117,237,58,194,250,104,243,0,6,196,122,18,76,24,218,218,86,251,22,90,234,49,135,165,112,161,177,48,17,229,114,205,249,142,221,150,59,117,102,73,230,106,237,175,80,13,138,201,83,20,80,187,14,7,98,106,198,205,114,229,14,87,108,172,176,241,223,206,232,224,241,146,110,211,177,177,25,104,178,186,211,42,243,52,149,104,99,63,236,30,166,18,83,169,204,149,243,141,33,105,6,223,170,178,165,86,90,3,5,192,106,30,149,191,230,161,17,254,186,114,165,193,196,179,182,38,180,208,194,60,108,149,193,75,194,2,248,63,165,247,212,59,56,133,252,77,14,169,62,223,226,197,77,119,157,167,176,204,148,114,234,48,225,156,109,250,135,187,180,156,112,216,82,93,56,197,133,40,56,243,35,139,7,133,247,202,248,58,249,148,212,158,182,36,17,249,123,54,106,220,111,186,21,250,53,213,248,94,27,85,34,98,177,93,109,244,40,120,31,139,22,143,200,5,94,218,57,56,142,32,124,215,29,87,85,4,181,133,176,243,112,25,221,44,131,109,144,179,76,9,146,28,12,210,250,155,219,229,96,167,131,171,142,146,182,122,9,141,83,23,55,186,135,167,111,195,8,99,180,160,234,206,72,251,84,63,150,61,244,153,141,59,196,199,47,50,7,179,163,142,212,152,253,180,9,12,139,53,75,147,136,43,153,170,196,57,60,141,214,172,153,239,253,247,185,112,243,11,168,128,80,168,109,87,241,128,6,98,104,63,40,242,103,255,59,208,103,69,190,80,9,247,221,203,56,170,32,225,176,133,14,39,67,52,155,207,109,181,139,188,109,58,40,155,150,116,42,227,217,76,76,53,181,230,0,92,178,149,251,204,78,138,52,111,156,44,123,97,101,71,108,228,204,62,225,47,31,23,191,117,236,14,73,149,141,193,184,126,196,204,125,119,64,87,176,68,228,188,233,230,198,162,202,22,43,31,247,128,250,161,75,124,115,177,65,1,173,218,232,82,255,21,27,180,135,97,134,1,22,157,94,83,86,87,184,76,159,132,32,121,223,37,45,108,31,95,160,129,101,149,28,81,220,3,203,15,227,206,9,244,68,50,14,178,135,77,83,192,239,243,179,57,137,73,153,234,0,9,80,10,76,126,45,70,176,206,186,242,70,78,188,174,252,52,139,180,79,100,148,164,74,130,239,90,136,136,173,239,222,75,244,228,49,114,208,150,173,91,211,6,156,75,154,49,74,107,45,123,173,72,195,9,181,83,109,197,54,146,98,201,128,203,103,239,3,166,186,152,11,63,170,62,235,178,151,94,241,206,113,6,104,52,178,111,71,173,52,50,15,125,112,56,243,59,141,115,89,159,84,163,113,158,175,91,202,234,80,186,195,184,59,185,104,118,6,150,255,65,154,213,239,114,235,250,193,38,101,184,5,218,173,160,73,170,63,220,56,224,31,67,24,242,8,115,19,140,57,127,51,5,149,206,188,172,237,14,174,151,29,50,204,195,38,51,91,152,109,141,34,10,179,29,17,90,57,181,165,250,137,71,147,191,253,251,156,149,6,194,25,144,160,210,125,185,245,221,166,110,155,16,205,205,224,98,25,39,85,83,42,243,212,228,120,149,239,74,140,112,229,245,34,125,35,126,212,158,248,63,110,231,9,4,245,56,180,2,209,10,153,179,16,246,203,249,58,180,25,138,43,113,109,26,161,205,116,179,206,192,56,243,166,170,250,245,180,7,215,17,45,159,92,84,106,142,67,35,188,65,198,92,236,167,95,30,113,44,236,42,52,14,95,29,141,229,69,168,24,135,42,210,78,172,24,12,226,4,133,161,195,208,81,91,221,202,75,12,95,132,130,141,71,190,96,219,88,206,157,74,115,133,28,117,69,94,223,190,7,135,65,229,60,73,146,172,97,87,105,80,46,241,39,109,152,242,213,248,3,241,129,219,129,10,133,178,239,198,160,159,160,161,106,0,159,79,21,146,250,157,27,181,58,144,18,22,173,156,185,103,30,220,237,230,43,175,162,112,45,49,130,108,119,171,100,1,86,30,183,192,237,3,135,238,114,148,219,111,82,228,179,72,142,149,242,115,156,5,243,175,70,97,77,101,103,151,221,208,122,18,45,48,169,168,160,70,107,172,138,177,53,145,182,125,117,116,51,73,148,0,176,177,162,0,242,152,134,104,162,178,62,46,207,197,194,232,253,159,251,70,238,137,167,143,101,78,28,57,63,25,152,120,155,36,129,233,11,167,137,253,50,245,207,69,191,226,133,189,129,140,95,46,170,137,86,129,177,29,95,148,117,182,231,123,217,125,71,94,152,27,129,70,97,9,61,100,80,83,119,218,196,161,46,176,119,106,82,115,140,73,151,13,15,131,242,74,3,136,254,25,34,21,81,101,241,35,120,125,71,173,50,13,31,43,48,120,112,35,94,198,81,182,82,84,114,83,78,153,147,199,103,204,81,97,70,34,201,235,54,12,163,218,94,135,189,53,70,213,153,1,226,186,81,36,221,146,221,153,129,160,228,49,148,112,59,186,94,53,200,177,171,95,116,115,150,83,98,25,165,128,93,111,204,235,13,117,150,214,237,76,83,112,81,94,181,16,82,109,60,67,209,71,93,21,21,121,20,54,207,245,192,145,15,73,186,174,241,65,200,131,148,170,217,152,122,204,142,238,125,159,229,229,65,134,28,19,209,66,17,44,46,61,138,213,193,243,174,0,24,67,181,222,86,132,224,104,231,112,244,44,146,237,116,182,48,94,207,69,93,61,77,175,236,201,173,105,216,120,112,123,138,207,119,148,253,86,90,80,112,191,195,179,55,98,26,99,78,138,170,165,169,136,15,60,195,101,66,21,48,191,56,47,174,216,222,241,150,41,117,237,178,144,238,219,179,216,172,181,108,100,42,249,49,12,189,15,218,218,215,70,5,184,140,149,118,144,248,99,55,169,4,30,62,175,208,24,233,131,61,11,124,135,24,173,118,38,225,23,211,151,62,111,210,250,246,62,236,115,165,193,245,11,213,3,24,145,212,102,218,158,203,121,40,32,65,12,252,235,76,131,225,42,243,184,26,69,86,199,31,5,80,132,96,4,39,225,34,104,126,246,115,40,77,18,254,10,189,65,122,238,174,47,193,67,92,105,56,223,217,248,222,244,249,166,192,237,74,97,224,155,99,247,17,34,236,222,42,23,31,76,98,94,0,8,215,145,132,227,194,30,34,228,129,238,240,49,17,34,92,20,5,180,214,121,0,47,99,219,60,91,168,216,11,255,182,123,91,117,6,57,216,123,150,195,215,115,192,37,111,199,63,255,38,41,74,67,224,14,6,31,32,119,231,127,251,188,199,97,68,58,232,181,222,100,49,47,99,21,102,240,225,116,82,49,157,157,230,133,51,234,72,1,95,201,97,133,147,200,164,236,29,182,149,161,91,211,154,170,244,55,248,35,80,167,99,196,34,211,164,65,112,79,230,21,205,147,141,153,201,22,163,242,156,113,154,189,88,99,211,80,240,188,241,147,36,44,235,87,10,8,154,213,31,30,167,144,142,125,12,3,168,182,75,188,254,220,191,237,62,150,253,36,195,170,42,201,204,208,198,13,143,23,50,119,233,227,4,129,156,167,45,139,6,152,46,180,194,24,83,250,81,78,178,82,43,148,220,69,177,46,148,113,186,87,183,166,129,29,235,154,115,232,81,254,205,163,212,99,52,20,121,133,241,78,170,85,144,220,108,249,170,189,36,114,171,153,219,132,222,169,232,14,195,33,83,98,183,195,20,254,52,73,160,186,164,248,117,196,222,11,103,5,26,82,144,106,176,52,35,54,82,144,126,231,252,45,203,219,240,24,199,43,210,14,90,145,41,5,116,139,88,42,210,88,190,180,107,129,197,144,226,80,123,184,150,177,0,18,177,213,214,64,200,94,56,187,207,107,93,214,205,255,4,222,131,147,251,238,229,117,144,58,252,142,197,214,59,210,145,212,160,250,57,127,26,64,182,190,134,46,161,209,121,50,11,36,103,183,56,239,244,174,154,212,66,28,122,114,223,223,250,108,1,164,230,230,206,47,31,118,74,47,153,168,55,145,113,196,121,156,118,11,12,189,73,58,157,243,80,40,141,211,191,238,198,200,180,117,46,131,138,100,171,145,97,84,224,235,171,28,118,175,75,222,66,187,147,203,75,176,198,194,197,203,35,28,10,29,231,118,171,193,104,187,22,4,187,141,211,235,81,143,195,201,82,7,163,22,187,208,127,16,77,55,67,229,171,48,141,45,122,237,144,170,139,139,234,51,62,255,69,8,146,49,213,228,98,34,180,111,103,30,178,3,77,162,154,70,84,62,154,45,243,143,190,136,144,133,97,99,225,87,126,193,210,108,72,214,218,247,213,255,38,201,13,80,100,70,48,61,64,57,71,137,170,192,19,174,28,32,176,157,72,220,200,204,143,92,83,220,178,203,133,91,148,151,110,144,161,126,175,216,190,252,80,54,17,44,193,168,146,139,195,57,132,154,234,102,210,149,60,7,152,33,55,64,82,60,221,214,174,135,179,181,189,139,24,214,220,170,96,137,103,125,116,185,40,159,251,165,38,197,165,114,169,21,89,151,62,88,216,11,35,190,164,128,68,239,167,67,205,211,60,252,116,77,11,138,174,73,44,132,223,195,29,174,68,237,43,102,120,228,225,89,104,181,25,201,217,7,149,12,48,159,207,253,107,127,175,43,29,189,167,140,233,13,129,19,64,150,107,94,178,198,224,47,72,164,150,180,240,142,244,254,109,20,185,156,148,184,203,87,236,224,13,174,198,19,115,84,98,250,216,28,235,30,55,3,66,128,106,69,221,95,175,137,219,132,61,155,159,248,140,240,101,93,186,175,46,213,171,218,135,250,166,34,108,30,102,144,33,128,218,213,235,250,127,155,140,24,106,27,233,237,61,49,61,62,86,152,193,246,247,197,160,92,241,242,225,230,188,180,67,126,56,76,213,229,80,169,186,32,103,60,134,67,50,33,242,232,129,155,30,57,49,138,191,13,68,70,6,221,144,61,221,6,159,50,174,74,23,212,37,46,47,122,200,33,244,34,229,79,166,51,82,116,221,218,73,69,4,223,207,65,248,158,112,62,108,12,158,238,45,171,78,210,75,170,254,122,156,151,232,110,42,22,119,155,119,213,208,11,18,72,139,15,199,38,157,110,138,136,83,107,74,59,2,35,213,94,96,60,163,2,45,140,170,34,82,196,63,196,15,97,12,176,76,234,91,42,237,44,49,50,35,130,247,55,9,221,17,150,81,60,26,5,34,150,233,25,69,26,37,83,236,50,223,225,49,109,153,132,4,53,254,199,10,58,117,35,150,192,179,75,158,180,108,138,151,179,124,217,226,131,12,172,89,74,17,229,206,169,48,165,163,253,129,52,55,108,22,27,197,229,226,203,29,113,131,147,125,148,178,152,187,196,93,85,235,191,159,180,223,108,192,219,212,168,220,40,7,217,122,34,155,12,192,25,91,190,251,25,202,230,66,161,5,248,64,250,41,65,45,138,103,28,184,78,45,221,151,226,226,112,57,158,53,196,89,70,211,202,147,181,226,226,48,182,35,83,235,173,100,111,59,99,42,96,126,154,199,160,50,131,123,20,83,113,86,94,234,89,173,18,39,14,141,20,105,175,242,188,243,42,81,150,176,194,50,245,51,218,204,139,114,0,192,220,182,230,242,10,34,95,106,211,60,16,121,41,67,37,130,252,150,94,164,155,13,89,2,120,218,25,173,102,190,115,2,58,164,160,150,53,223,119,59,82,45,140,191,72,173,204,145,138,203,178,52,101,152,119,254,48,228,132,211,244,216,237,106,44,165,177,249,134,172,197,79,25,100,40,252,176,218,63,121,117,193,14,222,40,199,65,243,62,85,190,104,166,238,150,232,13,121,133,158,0,147,95,181,150,79,177,191,25,65,135,131,127,116,111,111,117,251,176,78,236,248,149,24,172,49,74,100,90,206,96,144,246,95,92,23,185,232,193,245,1,254,227,179,189,118,135,60,19,128,157,68,136,81,35,140,252,11,98,123,99,152,199,231,148,68,33,0,13,44,167,135,117,51,78,138,225,6,185,45,183,146,149,213,138,72,59,49,76,249,93,53,108,16,234,222,169,240,195,168,30,252,14,4,143,93,151,21,112,39,177,31,18,184,189,62,191,92,31,147,191,216,48,110,90,14,102,151,198,18,114,103,250,73,184,162,58,181,11,75,205,196,90,49,22,59,41,116,0,183,210,165,149,15,181,40,81,47,230,82,245,44,16,71,40,193,36,138,79,9,222,33,230,145,5,164,85,72,252,12,153,58,150,234,81,250,121,171,183,102,14,242,21,7,6,58,174,0,23,189,71,47,224,206,194,203,113,221,221,6,170,25,246,236,222,34,49,11,250,249,144,221,34,158,60,210,200,155,47,177,237,186,110,163,73,155,130,240,102,240,239,212,143,173,185,195,48,240,52,116,174,208,222,107,108,217,221,231,24,10,169,174,145,160,32,126,48,58,168,33,115,107,219,242,26,99,28,64,191,215,113,159,9,207,121,24,13,253,96,37,43,234,215,69,26,220,79,65,137,159,203,132,34,126,110,77,96,155,137,135,204,65,129,235,155,4,37,236,83,217,147,117,206,172,139,211,168,212,166,182,242,113,150,187,235,231,145,7,206,69,91,152,218,69,212,54,49,120,32,254,227,137,177,165,238,154,198,216,253,121,177,137,99,222,173,86,215,110,12,39,132,59,194,116,85,149,233,198,242,150,44,31,30,208,115,94,27,77,15,175,19,124,185,129,199,8,101,84,24,53,145,68,77,55,241,248,234,182,172,21,55,213,73,53,53,87,142,38,121,17,145,105,11,119,229,12,141,243,91,137,7,132,212,138,180,119,162,85,43,88,255,78,172,165,196,109,122,2,9,20,149,191,106,241,104,118,231,17,165,79,252,206,162,142,174,66,83,166,123,200,53,249,158,103,246,218,130,44,61,127,162,152,102,203,47,10,0,169,130,245,78,78,21,52,117,32,135,93,100,131,127,222,96,137,189,97,60,156,91,173,30,246,156,168,177,25,72,136,43,151,70,139,74,251,164,80,100,249,68,169,198,248,172,37,108,26,106,197,107,95,128,215,17,201,85,226,229,59,201,8,151,249,239,134,121,117,241,36,33,252,57,155,128,14,124,65,166,171,192,189,102,245,159,85,14,170,65,107,228,206,218,253,113,21,118,80,121,201,86,181,95,219,209,177,118,87,130,215,5,248,22,151,5,183,142,137,225,153,98,174,247,189,245,122,130,216,115,131,204,119,53,115,173,244,31,186,192,61,93,228,28,236,54,128,23,224,187,59,251,107,119,87,183,143,15,47,64,20,116,231,242,25,233,129,32,122,82,213,115,168,73,176,17,71,127,51,18,91,38,89,156,136,159,61,35,234,145,14,78,127,28,70,63,94,216,173,246,117,88,20,146,220,60,235,223,174,251,33,13,85,18,145,200,75,87,63,61,253,255,100,184,51,0,242,125,151,215,118,74,192,106,220,40,10,8,97,189,233,226,200,68,177,245,23,210,217,78,1,164,104,105,4,7,187,101,242,43,127,91,40,16,222,55,46,244,199,82,12,177,219,85,30,253,185,25,184,236,112,1,112,119,80,75,95,195,64,125,196,229,234,41,109,122,74,60,238,89,160,19,27,230,93,191,215,9,43,146,135,45,14,83,123,86,11,68,111,167,64,134,206,47,243,83,36,119,255,200,250,97,50,237,183,13,208,246,231,64,172,113,20,187,236,11,113,60,41,5,54,200,132,179,99,135,49,79,141,192,100,236,162,162,182,83,28,210,21,83,30,15,207,97,154,227,232,118,167,148,126,247,26,22,27,138,11,167,248,48,108,102,194,76,21,77,7,225,93,129,7,160,201,217,134,74,162,162,226,37,204,3,138,185,146,17,124,105,17,80,8,219,3,86,171,242,157,45,245,95,134,248,176,171,192,134,48,51,193,122,158,182,87,15,88,184,168,73,49,46,26,48,183,22,23,117,110,135,46,206,120,27,221,115,204,239,247,181,68,97,49,104,171,249,11,244,96,110,160,233,12,142,52,81,173,70,229,77,146,16,178,251,200,218,101,158,99,138,128,89,111,122,89,55,137,159,26,108,77,65,229,63,24,129,40,230,11,73,116,142,162,227,227,29,84,2,237,250,79,27,84,42,46,99,86,118,88,218,127,35,151,241,25,46,149,6,171,26,211,84,100,167,242,120,178,170,145,207,220,219,212,217,36,117,145,165,89,177,54,93,20,79,205,142,203,183,173,126,52,53,214,131,146,162,9,81,249,200,233,168,241,153,153,220,112,213,145,49,115,78,176,28,242,240,17,161,107,50,144,204,69,91,35,37,224,136,8,130,165,84,171,206,222,30,97,253,157,22,151,210,152,103,69,179,116,174,73,86,244,83,199,172,188,247,243,231,188,112,252,13,233,223,104,73,210,233,75,62,212,101,202,113,43,136,138,184,231,141,245,192,111,225,186,134,32,8,207,32,32,217,130,192,240,141,84,171,82,247,221,244,154,172,107,44,2,217,39,238,162,76,102,95,249,138,195,81,219,103,24,143,6,131,29,72,136,149,223,150,157,112,203,185,157,151,128,210,142,116,147,87,164,214,116,186,38,70,211,35,201,158,102,82,137,192,101,58,116,206,133,241,26,237,152,72,224,246,202,45,35,89,170,147,48,48,243,88,231,219,15,17,72,112,238,34,14,148,204,36,133,104,146,227,209,197,192,8,230,89,171,163,109,148,120,202,75,236,131,212,241,90,90,99,87,238,26,210,52,149,207,124,103,38,89,182,12,51,137,90,254,220,150,122,95,211,3,141,253,53,191,169,108,93,51,41,97,81,107,232,205,20,146,149,223,4,161,109,121,233,183,126,219,56,149,149,27,181,2,131,91,225,242,60,89,1,234,111,171,177,233,117,106,52,4,21,56,84,170,134,243,76,244,162,79,140,105,159,186,105,212,15,24,11,80,188,141,115,1,196,242,208,153,81,115,85,75,239,169,141,69,225,118,106,15,25,75,173,97,157,128,88,57,132,168,6,225,17,48,174,158,235,103,222,183,227,29,52,170,72,78,203,81,93,118,71,223,48,179,107,96,171,65,180,235,177,224,187,198,102,30,199,131,175,197,74,226,249,131,216,184,115,69,199,136,223,182,114,53,154,109,195,84,186,6,159,204,174,35,166,128,210,180,95,104,240,135,30,252,170,224,8,179,220,107,20,51,50,230,1,24,246,84,139,68,86,21,240,223,170,46,4,165,213,136,131,58,28,67,167,163,190,183,35,42,251,108,195,177,26,183,8,105,202,4,75,193,124,54,161,30,226,81,80,111,146,160,222,233,251,158,134,134,101,238,14,16,90,86,183,179,139,137,38,82,99,166,137,16,41,56,150,103,123,148,221,7,180,131,195,57,83,223,71,75,31,233,169,73,20,176,28,176,13,36,198,81,105,195,11,83,109,164,184,18,48,9,147,234,148,199,8,61,32,132,208,109,171,103,115,251,91,190,41,91,125,103,184,97,29,69,127,169,99,233,139,181,64,119,82,110,159,67,227,192,65,159,235,215,211,163,171,146,103,198,192,249,16,56,42,184,14,206,242,217,158,27,234,27,19,111,82,89,102,54,103,41,77,145,88,191,121,13,202,96,104,117,45,147,153,202,104,122,245,101,0,29,215,46,250,167,192,242,57,169,238,163,202,64,225,147,13,226,189,143,39,72,161,232,119,195,196,141,101,62,68,248,61,122,36,78,12,116,236,231,187,210,35,9,156,125,121,162,5,209,70,77,48,16,103,157,139,112,105,99,103,115,87,194,202,231,93,149,72,108,82,47,3,31,200,42,145,129,138,222,92,133,200,120,54,247,11,205,63,81,174,78,172,187,104,35,106,144,222,9,53,173,166,208,91,186,114,157,5,64,23,234,242,18,52,67,90,100,140,246,119,149,7,233,34,131,202,0,43,34,228,99,25,35,8,187,182,73,176,73,33,231,44,57,61,196,244,31,10,124,36,223,157,227,128,105,117,82,57,251,93,136,232,83,199,5,194,149,171,100,246,33,254,64,10,91,20,127,6,163,56,175,181,179,86,71,63,129,78,200,143,146,130,246,8,35,159,141,115,48,56,218,39,12,171,53,89,45,0,94,68,194,166,2,119,154,82,219,201,152,237,217,189,134,192,188,143,107,86,194,140,51,163,77,253,154,222,240,82,188,63,215,208,179,29,75,169,97,242,145,156,138,232,33,207,128,13,7,38,241,220,14,67,227,20,180,206,226,94,79,168,186,109,132,35,225,68,150,25,149,249,158,83,250,164,116,233,110,139,160,191,210,29,229,203,83,229,161,69,121,180,80,104,68,198,222,168,81,85,67,121,246,165,101,5,81,105,227,42,15,93,63,13,121,44,203,61,230,110,30,56,204,171,47,208,112,87,162,40,28,25,153,136,69,113,138,34,108,208,102,228,43,18,0,189,30,13,247,183,28,99,179,151,35,7,112,176,66,105,93,255,102,148,219,61,153,131,185,76,76,51,69,159,29,68,253,202,98,142,254,28,201,111,16,151,113,95,51,247,114,182,54,53,225,10,174,201,65,98,221,198,64,172,221,56,205,196,76,140,161,146,30,120,231,84,201,94,67,203,62,230,72,226,170,129,8,65,145,146,100,99,137,175,206,49,70,13,205,46,111,161,249,165,124,156,234,219,237,51,193,77,179,112,121,98,74,138,26,239,244,175,218,8,26,130,194,203,213,11,63,73,231,234,209,191,191,108,66,7,236,63,241,228,236,111,181,132,213,178,96,127,226,240,24,23,252,165,128,70,141,9,74,164,254,144,207,211,235,168,197,109,196,56,224,251,23,212,242,97,250,242,187,255,175,166,118,40,193,106,27,200,104,103,64,160,75,237,171,81,226,246,75,159,185,223,21,162,88,222,200,57,24,156,139,141,23,95,155,236,65,108,186,107,51,169,70,217,169,1,96,245,22,46,239,93,214,0,151,239,58,74,146,246,241,184,34,193,246,184,31,127,194,75,176,197,84,86,223,1,2,197,142,174,63,251,114,209,33,183,78,161,229,17,195,125,188,207,208,253,243,28,14,13,138,220,190,87,193,196,197,47,156,19,134,105,162,55,90,200,200,64,251,246,32,19,172,160,223,8,217,154,206,89,7,79,172,148,176,50,180,239,191,255,222,54,148,8,102,100,146,134,218,219,46,204,96,38,166,120,206,238,30,132,72,23,200,69,39,68,201,184,36,118,249,109,14,62,198,49,53,164,3,173,112,163,220,205,175,159,140,67,151,70,225,45,127,111,146,111,170,96,198,26,98,252,205,121,122,188,173,49,11,8,154,238,222,253,94,204,177,150,242,34,33,134,40,226,245,150,101,78,237,12,97,246,157,200,1,0,242,22,186,143,215,12,62,141,144,158,216,98,58,199,215,221,23,54,182,236,70,165,130,240,182,225,254,220,126,233,249,106,208,139,61,186,27,137,218,95,4,153,126,186,250,217,73,133,125,158,64,239,58,203,183,42,97,107,45,102,95,156,174,57,193,236,125,131,160,217,203,232,242,13,180,68,245,219,159,200,135,128,154,59,194,254,255,81,250,52,3,75,23,68,122,153,181,173,50,41,55,232,180,49,196,135,214,113,145,102,12,170,43,106,82,165,40,112,240,197,165,22,222,90,161,77,5,97,223,34,176,233,131,91,96,81,115,182,166,219,8,181,126,167,158,148,222,238,176,24,86,154,36,35,204,224,114,164,231,231,145,39,127,196,247,7,129,164,78,16,129,112,200,222,43,74,227,250,232,199,222,39,39,251,160,153,15,35,29,105,18,85,141,127,178,152,251,195,249,154,99,55,18,60,193,108,226,108,87,113,134,188,1,184,34,50,209,118,17,228,86,86,178,200,35,234,15,203,130,70,26,33,223,83,182,174,6,56,170,48,121,209,214,118,153,135,90,252,141,235,14,89,250,98,226,27,175,25,208,154,81,25,12,244,214,247,51,178,221,187,160,246,177,144,195,157,178,85,139,241,134,216,72,48,204,215,220,176,4,25,98,252,132,27,217,247,52,188,107,31,176,192,68,132,224,205,78,215,25,12,225,237,208,210,1,73,89,180,13,67,212,255,224,112,62,97,25,24,77,158,222,101,172,228,63,96,170,239,78,66,47,152,225,154,226,120,42,74,99,70,51,28,138,182,213,137,155,104,101,110,115,76,37,226,152,49,133,219,45,170,255,22,115,67,63,66,5,30,151,98,55,33,223,25,106,170,213,221,146,247,2,133,24,119,35,165,209,25,154,23,145,178,189,245,214,90,225,163,243,176,244,34,178,131,247,62,84,154,212,24,107,49,39,71,4,223,250,250,133,26,130,115,196,157,24,167,36,135,236,111,240,62,74,242,162,170,208,94,252,207,220,107,231,184,142,244,158,14,234,33,153,147,160,101,214,175,186,109,179,97,77,188,36,90,27,174,245,129,236,32,47,174,84,50,206,148,72,149,104,158,79,8,156,167,189,70,59,35,215,60,238,75,50,150,182,54,162,160,212,59,252,162,17,185,255,16,246,247,226,47,103,132,206,117,31,91,102,192,166,59,134,133,252,113,83,191,128,166,234,71,9,23,118,166,18,65,24,192,210,12,132,139,100,73,195,53,35,90,175,22,62,125,12,145,74,160,107,143,5,226,175,110,115,6,150,187,73,176,35,139,254,178,70,54,48,213,158,36,171,63,94,117,80,82,228,242,25,144,101,73,205,183,107,135,57,9,198,84,59,81,70,40,120,101,196,203,56,73,33,53,207,86,100,15,77,236,170,25,163,29,227,180,103,245,9,177,81,90,192,207,138,249,128,21,232,98,57,149,238,237,188,116,171,133,157,216,209,33,119,69,209,61,251,255,122,203,145,125,229,6,204,245,223,129,70,99,194,174,93,116,37,112,255,252,245,188,21,21,251,102,199,240,12,60,134,215,142,203,252,200,111,180,186,72,173,78,100,131,11,154,84,95,198,167,116,231,40,140,149,109,230,161,43,212,165,255,251,88,167,171,233,209,85,120,228,152,147,26,85,170,40,28,134,197,239,207,142,222,96,6,124,32,193,130,70,140,30,29,193,191,185,86,125,99,160,130,251,14,95,180,184,146,47,127,241,142,36,151,106,222,63,18,251,42,119,233,5,61,172,33,220,85,60,144,61,171,151,163,181,104,69,226,49,157,117,197,250,191,131,13,22,184,19,92,120,53,119,31,53,3,63,112,233,9,202,122,67,106,112,72,161,174,102,0,10,55,51,104,215,149,215,116,219,79,24,192,212,122,18,23,51,245,157,169,184,234,56,227,247,168,170,138,34,65,130,143,5,68,142,234,247,74,85,175,201,110,194,9,114,199,207,253,254,138,121,244,7,226,104,42,175,192,184,225,198,252,243,146,45,13,136,178,233,201,75,109,221,188,18,73,118,107,66,240,240,239,9,163,139,215,241,59,4,203,212,106,178,196,58,17,161,183,150,4,225,1,146,159,163,135,3,150,141,117,80,252,129,68,206,153,245,111,144,7,138,236,152,176,208,249,77,56,112,216,254,32,187,149,229,55,231,253,205,87,107,72,39,88,43,87,159,108,170,100,86,8,190,15,166,13,250,126,33,143,230,176,32,121,211,252,40,97,19,23,33,231,139,214,4,63,6,198,219,160,138,218,134,116,132,100,210,164,85,164,169,39,79,90,250,41,242,77,108,38,140,45,171,35,96,166,108,22,157,116,250,209,183,4,90,143,148,213,155,167,233,74,136,246,81,86,47,177,177,187,37,122,42,138,190,95,7,46,55,134,212,163,224,151,150,29,26,17,87,129,110,52,186,166,24,224,8,172,1,32,7,154,46,29,57,184,134,140,163,34,166,112,165,178,75,240,22,227,183,87,136,25,235,199,125,233,132,28,161,225,29,117,172,117,228,112,42,111,14,156,45,17,14,96,165,68,49,110,142,9,243,15,26,50,82,218,27,3,82,1,133,24,126,189,89,68,211,125,117,96,37,9,192,234,113,14,190,222,106,99,228,142,161,153,134,82,203,203,77,172,18,185,242,191,199,117,65,202,203,209,76,82,237,130,95,30,114,215,8,127,115,105,111,53,84,233,192,8,230,120,92,111,190,30,117,113,43,109,223,157,128,214,102,72,230,84,78,190,180,81,38,214,229,194,166,252,57,245,39,201,123,35,38,198,231,174,243,226,191,237,136,223,7,201,45,89,166,232,119,90,66,28,42,96,57,250,60,107,16,39,245,32,195,90,80,202,174,14,104,230,112,95,208,129,32,113,77,199,160,240,189,31,151,203,23,1,129,11,249,196,86,32,249,75,177,119,53,166,241,108,214,101,236,180,219,212,227,142,183,82,154,109,79,25,78,118,254,165,213,233,224,163,51,159,201,115,233,198,190,160,208,190,251,103,6,65,188,106,240,129,102,66,220,235,145,92,170,89,4,124,86,127,224,47,117,144,229,131,197,165,14,34,156,142,106,254,241,222,69,222,236,102,182,57,32,95,199,239,7,208,142,76,174,112,238,84,83,107,216,107,93,228,66,175,62,145,111,60,95,70,161,59,171,10,12,251,90,169,6,188,179,11,230,196,146,115,239,145,193,206,96,75,69,95,182,86,250,160,158,78,45,234,172,122,245,9,184,122,25,92,118,19,217,167,218,155,210,105,20,1,102,43,163,141,12,40,250,34,196,51,56,42,30,81,57,136,179,32,193,159,96,20,118,206,238,225,4,134,147,144,103,117,161,9,249,249,137,47,87,151,163,203,187,171,162,27,98,12,24,167,131,140,244,61,223,86,137,185,179,186,220,46,13,54,6,29,30,235,224,232,43,31,157,4,109,202,85,157,214,94,246,31,195,217,54,108,184,128,185,7,130,147,151,84,80,146,55,37,186,183,171,222,110,220,179,74,154,36,220,184,148,29,148,127,63,10,11,170,35,208,196,4,226,151,61,147,29,224,251,114,208,18,103,130,138,42,8,112,253,180,217,91,232,205,103,150,4,119,125,88,218,81,116,95,56,71,188,250,131,236,92,45,149,69,242,168,252,97,17,154,3,59,138,237,192,90,159,98,226,23,79,195,118,76,101,151,64,185,215,104,129,49,215,91,44,12,109,24,80,38,90,212,92,150,16,33,200,8,183,209,143,68,130,176,188,138,206,39,189,86,72,203,102,175,240,102,159,133,0,46,81,15,152,45,121,215,111,254,96,159,221,216,175,188,21,195,37,55,172,235,100,196,150,20,255,3,88,149,44,247,197,252,33,74,107,200,58,91,229,196,14,115,160,7,79,66,10,240,163,97,44,180,87,181,206,192,153,36,62,199,10,226,0,131,186,36,243,182,209,248,156,31,220,228,223,213,41,93,51,240,54,178,91,241,173,235,44,99,66,131,224,201,97,64,23,173,103,149,11,184,66,192,203,206,224,166,59,117,135,186,229,127,159,10,16,128,154,157,217,77,168,159,4,6,33,35,143,140,37,69,183,171,31,191,233,216,83,98,237,15,245,129,187,60,221,24,171,223,62,42,219,81,201,43,229,245,114,62,18,80,62,42,8,236,246,93,235,176,244,181,233,69,159,175,100,232,228,194,3,255,188,242,15,222,125,64,35,209,208,131,210,16,183,90,161,42,235,233,180,161,217,62,105,76,200,248,86,209,94,13,25,156,238,44,251,147,102,252,10,210,151,221,90,110,64,61,53,184,28,125,221,136,215,125,225,162,195,53,173,164,73,92,213,144,225,160,55,6,49,234,209,133,59,26,242,189,13,137,9,108,161,58,58,241,234,28,218,114,63,250,230,229,212,253,186,112,27,98,137,142,73,132,106,157,209,90,162,67,225,93,122,86,181,96,119,133,134,120,48,91,83,109,178,233,223,94,241,42,157,65,209,17,48,93,41,243,197,61,93,245,191,44,201,118,151,149,197,6,90,92,75,202,56,179,73,52,172,99,212,132,122,149,224,140,65,6,109,152,25,161,137,11,107,232,88,108,66,236,184,175,119,119,76,115,172,187,209,25,93,151,84,207,115,135,19,135,83,114,176,252,185,189,178,39,74,44,102,132,22,134,222,124,125,52,33,226,168,118,84,166,251,186,67,120,137,13,208,84,37,137,148,68,186,82,154,248,6,79,234,126,107,105,219,230,128,64,9,56,80,239,244,62,154,82,58,19,148,218,101,6,178,124,82,164,203,193,45,83,72,5,227,227,245,25,4,110,207,199,201,191,219,239,59,205,39,137,188,65,240,41,215,128,103,34,214,105,203,63,225,18,241,39,46,241,125,70,28,14,63,158,231,77,71,94,150,161,237,196,75,84,60,34,239,234,222,213,149,116,221,4,151,57,102,175,114,54,231,4,250,148,108,141,254,209,202,91,207,32,65,182,206,175,250,142,247,238,121,88,163,1,34,106,92,67,194,160,113,25,19,23,61,198,121,1,30,248,233,54,26,236,245,227,4,233,78,154,88,251,133,16,215,130,98,46,111,214,5,124,86,154,212,20,133,167,89,71,96,179,160,55,86,204,64,98,148,143,67,73,221,10,141,216,56,237,148,6,225,56,196,188,10,214,89,38,158,68,136,32,45,108,172,87,236,187,158,189,169,77,4,166,10,18,134,51,178,62,49,98,132,183,249,139,34,76,88,205,167,29,111,253,26,66,167,237,243,9,86,19,238,233,100,85,119,13,102,223,8,183,155,70,168,179,201,195,241,94,65,87,137,93,62,147,90,253,45,195,40,243,80,83,102,139,3,167,226,198,8,149,8,127,155,195,201,118,27,120,72,233,178,16,8,142,42,254,231,149,201,61,174,23,89,51,213,199,115,13,155,45,195,96,245,33,246,143,172,111,37,183,129,229,216,169,224,93,200,20,192,139,185,7,183,66,73,142,151,250,66,50,100,65,218,167,17,140,144,245,126,246,218,5,119,226,10,137,235,148,133,50,51,102,115,160,166,115,181,78,205,146,84,72,77,75,75,181,231,65,80,38,32,8,121,32,115,136,159,173,247,33,48,190,9,82,249,168,95,212,152,53,47,161,151,120,85,172,86,65,133,236,132,9,23,35,15,224,229,147,175,255,212,191,115,197,115,7,139,132,34,6,194,233,65,144,38,224,10,19,255,13,59,105,191,25,198,83,19,53,53,95,219,242,1,214,153,180,142,122,29,130,86,47,140,161,97,73,138,166,123,180,166,64,129,114,86,25,18,208,84,46,189,101,27,111,225,100,151,183,219,20,142,122,90,162,160,224,68,84,71,124,210,94,137,246,112,112,100,94,48,62,254,152,102,29,80,94,95,146,77,178,70,192,45,222,48,54,160,123,250,115,70,26,191,27,248,88,75,103,110,113,150,73,234,54,247,162,133,249,241,151,81,195,188,188,191,198,90,106,209,234,23,124,156,95,84,120,226,31,133,74,12,41,185,60,243,248,176,105,21,121,119,209,233,102,172,25,158,113,193,208,86,81,142,219,235,225,214,100,137,133,65,203,206,179,37,207,231,10,66,236,146,207,237,212,9,161,40,7,88,110,153,87,60,7,219,242,17,146,242,114,191,190,76,241,191,231,162,75,133,233,158,161,7,31,64,216,200,64,242,55,113,58,46,211,114,195,136,18,104,159,46,245,69,89,12,121,35,44,168,249,183,16,191,128,24,171,189,74,129,203,154,119,218,229,78,190,86,91,190,109,167,213,133,72,59,66,107,89,50,121,198,236,72,157,66,72,98,36,9,249,155,33,204,118,43,142,39,150,175,88,48,214,73,246,168,190,133,107,142,226,214,192,79,254,200,121,114,226,191,206,150,78,235,121,37,32,129,8,178,119,175,245,161,146,159,212,2,89,147,80,40,205,66,12,140,243,186,96,130,246,161,30,6,9,195,221,60,194,0,136,69,76,241,4,39,53,207,146,36,13,144,39,225,231,149,215,135,107,166,86,13,97,255,48,180,120,117,84,217,109,157,220,207,48,123,126,141,208,96,208,48,143,78,12,89,95,32,251,115,167,34,255,208,235,188,150,236,16,117,239,106,140,109,75,33,245,55,43,218,245,76,13,10,92,92,199,150,251,157,166,240,143,112,69,126,202,139,41,222,130,132,230,107,199,87,4,119,121,216,253,231,45,169,96,198,238,107,193,65,166,137,54,146,36,170,68,215,123,110,116,139,49,78,102,83,207,22,80,93,215,80,116,14,203,230,115,67,29,208,33,137,197,127,203,241,105,54,22,229,89,85,187,117,9,106,31,184,207,162,209,177,47,9,35,28,58,145,221,140,68,71,205,93,6,46,142,167,49,50,33,197,29,113,241,246,17,18,91,232,5,11,212,48,96,200,35,106,178,198,234,250,237,108,149,194,206,231,193,201,203,71,208,11,254,33,255,86,16,145,90,190,133,149,60,125,24,167,204,217,140,72,105,16,134,187,3,134,171,98,117,167,233,216,96,112,80,66,39,133,76,255,117,27,184,53,207,176,93,168,206,126,178,115,236,91,116,152,239,2,158,12,57,215,54,185,13,127,175,89,202,241,53,21,74,225,15,193,242,221,32,208,178,147,213,209,211,75,60,145,246,6,241,238,142,188,85,193,198,217,143,20,34,3,102,116,93,174,200,246,137,19,154,65,15,106,248,95,116,194,174,213,74,245,206,166,52,170,142,229,21,64,35,100,24,26,70,217,56,229,182,212,51,44,213,189,127,145,234,61,210,200,178,76,132,80,217,114,96,223,163,25,69,32,33,188,7,162,81,224,117,197,201,86,137,174,189,208,173,253,64,112,203,187,24,19,219,46,60,66,190,197,133,120,77,43,49,43,17,71,249,41,254,119,231,91,86,139,173,19,52,171,242,219,39,179,209,99,73,44,187,103,120,113,24,104,127,6,77,95,155,249,46,170,159,112,88,120,103,59,165,172,53,143,247,98,83,189,95,241,242,138,217,49,59,211,214,75,155,144,213,246,208,205,241,181,109,119,249,215,98,75,245,199,176,214,10,156,117,205,59,89,67,127,74,130,108,185,126,119,41,136,171,29,253,245,31,72,254,196,195,127,118,87,131,49,163,49,155,144,8,220,153,233,3,83,75,46,92,118,107,43,223,51,138,68,54,65,59,119,119,149,120,230,19,108,18,132,26,11,84,3,50,204,233,107,154,186,39,51,139,52,138,18,113,218,183,69,180,91,59,233,45,17,0,253,132,154,96,10,126,235,130,100,236,181,40,57,161,87,36,54,46,152,15,135,232,143,138,18,61,223,89,131,41,109,235,41,170,245,117,39,145,42,57,119,99,114,151,68,143,106,249,67,128,200,53,26,2,75,201,118,81,195,63,80,174,63,37,171,60,193,193,108,75,210,85,109,137,240,239,133,27,19,176,65,43,189,239,166,56,9,187,182,217,180,10,88,190,82,165,29,53,133,182,244,134,120,120,89,175,69,252,196,41,4,194,132,203,35,131,172,252,95,124,49,158,4,53,161,120,30,42,186,21,48,140,152,105,176,152,236,242,134,89,119,86,78,220,12,43,146,85,2,6,81,50,47,0,197,207,139,53,105,104,190,212,225,244,202,22,124,186,121,188,255,27,204,155,222,238,224,84,9,26,15,183,166,123,134,159,146,176,246,49,34,52,168,128,217,146,219,254,214,106,163,32,135,91,32,10,105,20,179,95,195,91,138,252,141,131,161,10,228,50,98,202,30,203,100,225,105,213,132,47,201,87,110,209,202,144,78,239,223,114,200,74,205,11,51,194,243,53,250,188,121,222,188,246,27,115,102,196,87,192,217,211,150,251,83,141,167,225,204,166,120,8,191,77,173,131,34,60,100,29,134,190,159,240,26,45,19,38,105,231,224,14,20,223,136,232,60,0,108,112,32,193,189,142,135,192,207,233,132,123,30,80,97,213,148,31,94,221,19,231,145,167,107,34,123,236,213,165,21,152,172,136,7,38,157,162,59,5,137,222,235,237,165,181,240,216,102,101,247,97,142,240,199,111,9,239,103,97,58,199,254,110,252,85,212,183,41,174,80,57,236,82,246,100,202,23,179,74,37,138,61,35,93,45,153,0,90,41,11,214,33,228,167,117,33,229,251,233,251,69,173,56,42,79,199,255,209,121,3,1,113,219,211,43,145,55,223,243,13,208,225,215,151,2,57,150,60,99,193,111,165,189,168,34,164,204,214,59,181,168,108,153,147,23,22,177,162,23,93,190,15,120,170,27,197,93,219,115,163,15,236,125,230,68,166,246,21,249,193,166,255,158,177,0,131,132,159,120,161,213,160,146,129,212,191,233,58,95,226,98,93,147,254,158,213,43,14,188,70,112,151,220,87,116,196,165,35,143,111,211,240,203,123,101,28,100,115,189,228,137,169,59,64,65,183,104,250,249,209,13,155,99,128,196,220,186,114,24,19,228,187,215,11,83,29,130,80,70,18,176,245,157,77,206,177,84,218,104,228,241,118,209,136,154,28,83,28,84,9,14,189,44,137,182,30,236,63,136,167,219,190,59,187,119,129,139,120,170,167,67,119,12,188,97,144,12,20,32,70,61,24,250,35,53,51,96,232,160,37,69,25,12,150,241,242,31,94,198,27,236,181,255,14,49,221,97,56,133,139,29,50,114,239,219,181,109,102,133,189,196,86,194,89,81,89,181,137,180,102,137,128,32,177,224,33,80,229,100,103,65,101,2,123,98,169,17,71,61,83,97,70,149,224,219,190,228,147,66,113,178,128,64,7,172,222,53,193,91,108,67,231,144,250,114,83,140,2,44,203,42,33,184,97,205,232,20,128,22,207,218,71,45,13,187,151,182,187,51,62,151,176,85,66,74,252,254,246,156,232,126,240,0,234,199,77,150,42,4,193,12,160,11,157,76,90,255,114,182,247,151,251,225,35,2,3,38,80,55,41,255,217,99,48,74,46,165,64,217,186,160,63,55,76,104,149,228,55,2,63,34,240,44,126,219,118,3,127,128,113,71,94,89,240,153,13,161,125,98,231,159,72,241,239,6,72,191,173,150,19,80,112,123,137,204,128,37,137,148,233,78,100,246,187,177,202,40,133,21,38,86,232,212,228,179,159,242,188,186,207,101,249,237,130,228,105,132,42,66,172,60,21,134,16,124,27,166,135,225,165,91,213,103,13,145,119,218,208,99,49,204,39,65,128,195,86,20,244,176,224,221,226,93,71,190,77,254,131,204,59,60,28,173,196,115,167,229,201,172,61,94,66,206,191,164,130,204,132,86,59,211,19,66,72,23,113,96,210,160,187,39,235,51,58,148,35,247,114,31,43,84,231,205,129,146,69,134,160,223,242,12,164,80,183,117,228,214,190,41,145,96,93,113,59,209,194,76,181,26,107,224,25,242,36,123,243,233,97,7,30,35,15,252,67,114,204,113,189,246,232,7,211,44,28,37,118,14,13,215,54,241,62,194,163,144,45,251,89,156,56,184,35,160,102,11,1,48,94,60,65,242,81,110,30,95,218,67,201,85,107,174,169,236,105,53,9,123,124,68,144,19,64,40,33,202,117,231,179,153,171,27,90,6,128,36,125,216,25,122,140,106,234,28,252,216,155,136,187,67,61,85,235,231,69,20,219,43,76,104,210,117,239,66,50,2,114,66,105,194,159,233,137,185,10,49,131,156,179,231,167,92,62,40,161,151,58,90,180,41,127,22,37,108,246,10,126,22,155,136,38,201,255,79,141,254,44,101,205,245,193,197,36,168,138,131,136,26,53,60,163,43,58,204,106,153,66,74,44,90,2,36,72,219,164,138,71,170,168,230,75,205,112,64,3,254,49,99,203,157,92,187,219,213,4,112,182,51,129,118,156,213,148,108,39,246,153,196,218,254,214,163,239,8,181,21,193,41,83,216,55,196,111,76,91,172,192,210,227,164,86,8,199,19,172,122,202,239,75,1,127,58,230,3,243,205,125,89,95,162,252,250,54,48,147,47,105,240,173,122,29,112,200,216,69,9,122,250,142,104,164,60,144,55,191,203,239,188,217,244,157,60,55,121,190,95,33,82,218,27,244,20,16,102,240,103,68,33,104,171,106,169,196,150,189,231,100,125,221,89,176,201,124,136,82,167,247,207,207,232,18,36,85,93,172,239,184,176,236,244,144,186,21,76,236,151,10,172,180,208,53,69,169,182,20,192,95,200,131,233,21,23,22,174,17,192,20,40,229,196,101,120,130,105,139,72,48,42,249,86,160,212,166,144,1,208,50,191,19,51,142,161,231,26,74,111,139,230,144,157,52,202,2,44,198,90,179,212,20,65,99,58,76,136,91,116,0,31,117,164,117,242,120,223,238,48,171,46,189,150,1,73,234,93,94,2,195,119,38,212,183,167,167,58,119,99,28,196,136,218,215,156,218,69,45,190,22,189,24,9,169,161,6,227,18,23,139,70,212,118,149,118,191,93,38,49,249,248,233,148,64,44,8,126,178,192,151,184,57,14,187,16,139,169,60,151,103,134,69,189,46,170,198,72,1,16,28,90,205,127,250,62,240,61,34,194,67,242,170,125,150,32,97,78,151,230,154,77,91,91,140,103,115,107,199,104,194,37,68,109,175,171,162,41,197,51,19,87,209,1,165,208,171,241,121,132,21,115,194,69,237,103,16,86,141,232,231,226,140,20,140,131,168,0,89,116,192,147,227,128,53,119,63,93,235,213,26,53,241,30,182,245,216,220,83,191,133,231,79,123,205,8,183,62,57,253,41,245,55,53,110,255,141,2,246,152,193,48,11,80,229,112,98,54,233,165,89,227,3,23,11,250,194,26,205,200,215,131,155,192,155,111,34,249,45,230,106,16,128,215,196,178,92,23,134,13,73,96,40,202,21,152,141,127,230,41,161,1,4,226,144,52,114,38,100,37,34,41,72,217,148,69,241,224,144,32,185,201,204,115,97,74,119,115,169,55,16,71,64,37,155,17,51,56,214,98,21,252,116,8,150,200,85,189,60,223,159,172,139,82,73,250,144,175,219,81,168,52,235,159,177,230,226,14,98,112,196,127,127,216,100,85,86,221,39,57,120,96,156,251,227,64,252,207,68,131,93,33,255,195,100,122,86,235,97,208,218,88,35,6,178,207,80,29,87,246,185,159,34,126,59,8,185,59,165,223,159,184,124,122,108,41,29,93,216,136,237,39,152,102,193,115,26,71,61,24,116,115,104,174,8,123,77,125,80,183,1,208,242,144,104,214,106,61,114,203,80,253,255,228,196,246,127,243,1,61,39,39,27,29,32,195,51,203,222,3,110,99,74,103,117,109,254,236,153,65,174,14,93,58,72,106,238,223,53,102,110,193,185,254,189,6,197,158,173,166,135,137,216,61,95,39,1,139,61,80,47,171,111,230,51,229,184,72,16,232,211,156,154,10,22,191,134,116,158,232,104,129,129,164,113,128,224,114,223,131,74,161,37,240,31,93,71,101,115,87,229,8,244,118,113,244,126,126,253,143,199,233,62,185,178,64,25,215,64,167,27,153,122,58,75,239,115,216,6,40,246,205,238,107,232,209,186,228,197,216,109,233,230,188,82,189,14,249,157,85,42,155,98,131,147,99,30,108,99,169,183,42,170,30,48,193,72,61,150,66,139,39,18,162,145,27,185,0,83,160,173,113,226,41,88,127,159,84,201,61,76,147,218,204,158,52,246,239,227,20,115,6,39,193,222,92,229,220,88,205,22,238,230,15,21,242,142,241,181,147,204,82,181,62,111,235,78,172,111,217,246,239,27,253,132,86,78,229,0,82,159,15,33,147,42,166,207,209,251,200,10,195,45,28,106,65,101,174,141,84,88,36,248,55,114,237,76,164,146,172,131,237,6,97,64,38,135,85,166,128,49,52,81,29,166,213,186,70,120,72,100,254,155,234,114,108,87,0,28,240,252,37,79,9,175,121,3,141,102,81,208,128,247,92,19,2,89,71,116,104,181,26,55,65,43,195,111,234,206,225,82,233,26,71,154,145,150,15,250,47,18,232,211,254,101,125,124,13,135,118,140,45,128,83,184,178,95,210,216,216,177,139,168,154,27,44,218,110,0,25,171,138,74,176,108,134,241,111,66,234,186,2,90,8,249,113,154,38,213,39,37,52,70,139,217,43,131,22,106,40,160,236,180,7,7,180,28,212,124,135,250,154,32,232,115,216,249,167,245,221,67,140,72,125,227,219,22,236,212,77,103,111,142,131,38,94,112,204,192,19,240,237,34,101,139,221,255,166,182,13,217,217,235,18,23,254,35,102,188,27,223,156,30,196,6,208,138,206,10,84,187,225,255,207,228,62,33,53,71,194,206,91,74,38,66,78,240,13,255,30,121,71,77,64,157,97,27,189,139,48,207,26,13,96,139,213,75,148,150,98,40,224,53,74,88,80,72,106,239,135,150,114,55,100,241,148,164,177,134,12,6,56,152,241,132,69,111,137,116,170,40,176,31,32,71,39,128,27,55,201,220,172,57,232,136,168,164,230,242,30,164,40,119,102,15,111,245,252,230,96,59,189,41,170,203,108,218,70,152,215,57,211,40,155,249,141,122,155,119,252,57,188,199,150,252,58,81,246,252,76,168,53,182,40,107,213,171,233,18,14,240,50,217,245,50,9,232,143,134,214,27,237,5,38,215,254,88,93,19,43,210,35,250,216,120,52,29,7,77,78,128,101,24,181,129,50,104,130,104,19,234,21,35,232,175,131,246,167,80,91,196,142,34,103,228,57,83,218,175,208,153,67,159,2,210,240,47,85,11,176,125,207,204,142,185,236,117,199,132,26,2,66,190,119,37,104,116,37,37,107,63,70,145,90,138,63,248,4,123,208,144,167,75,73,230,217,238,237,54,14,121,102,69,238,73,225,189,188,10,148,90,143,249,8,97,115,219,166,191,74,152,141,82,130,49,24,188,108,80,76,35,253,81,17,39,19,143,228,119,210,237,209,123,130,220,176,224,250,216,157,85,65,66,96,44,254,57,190,214,188,182,133,63,53,4,50,186,102,238,26,12,96,35,75,109,32,213,249,102,53,42,129,163,130,226,101,75,20,150,243,194,171,77,124,59,10,57,11,23,235,3,161,12,242,183,193,185,108,136,139,249,20,82,252,131,171,63,216,45,12,252,9,54,163,177,230,98,31,8,36,29,46,181,136,227,178,19,14,234,167,59,8,193,136,135,228,231,137,162,74,182,71,210,215,67,221,213,50,229,26,227,162,167,138,243,3,236,32,205,149,217,192,154,236,39,188,41,14,79,151,59,245,146,211,227,248,167,234,178,157,90,133,226,48,186,113,48,167,119,9,209,114,226,0,185,75,4,25,171,253,133,112,65,237,229,168,95,237,11,192,73,127,121,214,30,171,99,126,142,96,72,34,71,53,107,60,98,160,166,105,217,199,131,196,53,239,135,29,128,191,190,49,136,25,142,238,44,15,214,29,27,227,94,55,87,233,112,59,58,1,205,172,192,127,11,15,59,143,50,200,58,255,12,187,204,78,86,233,92,197,40,69,111,67,152,93,203,94,111,216,84,4,67,178,201,64,195,109,110,220,36,237,246,199,26,76,69,57,75,26,67,41,1,176,243,69,219,172,176,180,57,83,174,115,44,54,138,65,36,196,183,128,216,13,201,86,178,234,240,150,242,121,53,60,153,223,131,2,252,12,140,108,230,226,56,145,77,86,160,213,246,59,83,222,138,60,65,55,110,18,226,148,105,101,131,189,108,83,186,65,13,206,174,181,235,171,87,5,214,196,17,5,89,179,199,170,248,90,170,203,158,77,134,93,108,193,219,5,61,190,219,17,157,106,87,177,144,183,62,76,199,37,102,74,214,25,124,80,100,139,30,167,222,137,25,169,13,152,44,131,231,103,42,133,57,183,5,48,104,11,124,31,133,208,153,159,28,227,15,77,165,218,127,18,154,112,116,78,89,97,110,39,181,10,145,192,208,132,70,254,252,90,113,245,43,233,145,225,36,105,140,201,120,158,30,149,73,67,171,196,170,234,170,152,47,41,230,230,139,205,7,198,119,197,31,97,213,31,155,186,155,247,191,153,20,23,87,141,80,111,182,234,171,168,154,35,108,54,115,122,42,174,5,5,145,53,189,191,14,193,94,110,56,160,57,2,51,206,46,155,175,0,94,61,89,243,207,81,177,145,227,51,132,232,82,100,205,182,209,241,151,152,123,202,230,18,3,164,111,120,17,36,202,198,11,28,1,162,36,230,127,236,82,108,50,171,126,85,234,184,94,130,7,30,113,196,150,15,105,232,159,216,27,160,190,155,48,119,13,172,94,63,83,195,0,2,187,210,255,5,144,160,110,61,146,76,76,214,90,88,227,35,41,144,50,227,124,225,118,152,2,41,210,63,183,97,219,143,249,161,201,72,140,91,140,231,84,249,107,208,244,159,51,246,0,92,73,186,4,71,244,198,192,236,60,71,221,121,221,194,177,194,167,117,34,118,127,62,71,168,209,77,16,244,16,203,148,234,223,241,73,137,188,71,148,92,219,113,89,122,83,237,221,27,69,168,73,23,152,52,168,230,105,200,6,113,170,121,158,4,209,253,213,181,3,6,60,140,213,49,103,32,129,39,10,110,107,75,145,73,179,122,56,116,186,195,70,165,68,78,28,81,83,225,203,92,157,200,126,252,13,198,254,101,168,226,68,206,172,233,230,158,169,211,35,166,120,203,16,147,79,8,30,182,183,122,132,154,102,81,240,216,78,146,20,205,182,13,44,17,106,164,56,74,191,142,93,200,111,19,112,166,26,87,51,142,128,113,146,0,181,17,15,229,167,137,25,250,96,24,195,138,171,12,68,219,84,23,81,211,72,62,101,134,38,129,215,244,108,110,115,68,175,226,14,80,4,186,190,118,136,201,206,38,110,217,216,27,167,192,32,52,68,245,160,85,156,72,151,157,227,167,155,135,37,239,137,161,217,159,54,49,40,123,115,5,90,53,145,148,198,84,236,106,195,94,76,5,227,159,34,179,189,242,122,254,163,118,213,249,143,200,43,231,146,93,37,240,184,238,107,92,177,118,55,247,68,123,59,113,20,227,203,107,23,221,128,1,223,184,106,114,50,237,25,237,35,62,66,205,74,252,197,168,27,250,159,247,107,115,210,210,139,202,0,3,87,220,233,118,12,204,208,20,46,25,90,203,221,212,99,106,65,63,125,233,160,229,132,22,163,222,94,22,195,112,213,141,128,162,121,42,106,90,172,8,44,152,41,161,39,114,63,70,209,250,66,183,239,90,7,230,96,160,135,226,219,178,11,42,63,11,213,198,33,253,39,75,117,129,139,15,158,198,190,34,176,86,62,13,82,48,99,74,3,124,74,229,102,85,178,189,144,246,125,14,186,96,13,23,255,234,250,150,53,220,209,37,210,174,41,55,179,88,148,211,16,219,112,95,40,250,174,105,113,174,94,8,89,120,36,205,51,193,176,190,145,240,10,8,208,241,100,156,253,207,55,50,59,58,219,116,40,89,36,238,231,79,216,243,18,231,175,76,82,108,86,103,164,203,242,91,126,209,253,181,123,241,210,120,0,155,253,218,30,178,40,103,212,196,216,180,250,201,232,14,248,2,109,20,69,103,98,234,218,68,95,118,145,94,131,10,131,142,98,128,111,202,111,222,174,207,159,104,206,241,47,198,134,220,23,157,171,155,178,34,122,234,205,15,190,211,31,15,232,234,88,0,3,31,42,202,188,220,245,236,190,138,116,166,19,185,204,63,105,191,168,209,119,200,58,138,149,152,253,245,6,108,64,124,69,246,29,111,120,160,250,216,246,122,0,8,18,27,215,192,134,45,105,10,127,208,67,248,226,61,239,221,117,146,236,3,75,176,238,97,230,99,100,129,116,133,164,198,65,114,29,90,55,231,136,244,121,143,114,243,213,183,8,70,102,78,148,107,155,78,31,9,237,105,211,162,191,32,218,148,149,173,10,19,10,208,206,33,228,182,215,94,26,33,109,144,177,229,166,113,55,34,238,95,113,6,94,7,97,183,162,139,127,174,8,144,217,52,167,113,7,157,55,187,4,206,62,109,52,139,188,74,102,53,217,161,66,94,59,122,121,103,66,226,248,120,27,81,32,39,240,208,87,144,243,161,242,113,52,32,32,137,76,111,22,39,76,126,234,241,98,145,205,128,113,196,249,9,253,176,236,113,8,242,178,97,23,139,89,248,185,172,37,214,180,0,231,187,97,74,15,148,208,231,101,0,119,241,88,148,33,167,69,212,8,52,116,211,214,61,44,41,13,132,153,194,18,13,65,239,90,175,57,187,136,240,214,218,86,111,2,219,246,118,214,51,96,10,57,228,201,175,139,5,75,32,224,216,168,148,122,40,170,77,117,218,113,82,151,170,149,101,189,56,78,138,134,66,235,114,94,45,18,242,84,214,25,187,114,160,21,147,111,196,174,127,154,12,245,11,99,103,107,141,225,63,140,40,194,30,180,216,114,88,141,51,69,145,35,3,89,246,244,91,46,201,220,101,53,107,158,126,234,25,177,188,85,21,248,249,216,230,78,9,66,113,37,130,20,55,49,205,92,76,21,45,61,76,44,54,15,53,220,58,210,44,167,191,189,3,18,168,135,215,233,185,150,128,51,149,209,88,71,245,65,250,177,240,140,230,114,80,32,228,131,131,43,32,127,52,127,7,154,173,126,10,10,53,223,130,190,24,28,16,218,22,141,245,119,57,46,196,156,7,211,79,60,172,180,13,153,53,126,106,144,86,22,46,240,21,188,173,189,67,52,21,158,132,81,146,41,152,217,61,120,2,62,24,100,57,99,233,67,181,241,90,41,90,130,166,109,236,46,237,100,3,225,255,244,67,243,162,0,4,109,188,79,123,89,6,68,76,132,139,206,247,40,115,163,194,185,109,228,205,227,58,137,51,113,155,109,2,149,253,9,3,160,101,23,191,131,93,102,230,176,155,222,52,202,124,243,40,135,76,46,74,34,110,72,38,236,80,57,83,194,78,243,172,208,132,16,32,244,249,197,83,205,166,38,229,137,196,48,107,11,45,1,41,133,82,75,182,154,142,62,213,27,54,170,185,216,167,11,42,169,79,187,38,79,211,56,229,92,171,2,15,157,105,212,198,158,233,202,148,147,14,232,253,150,91,38,173,22,171,245,99,230,106,75,188,179,163,39,157,234,4,57,98,7,217,3,83,137,123,217,214,137,12,22,251,60,95,167,136,177,44,126,199,3,109,254,247,248,89,190,7,207,160,31,234,134,217,215,21,121,164,232,221,20,226,58,101,255,228,51,251,244,68,87,44,196,37,176,193,200,114,180,137,39,110,7,45,55,76,134,156,170,17,25,221,245,187,17,236,149,77,71,50,196,125,103,137,45,36,43,228,119,196,34,152,125,39,167,219,248,192,188,44,25,28,234,179,210,19,120,74,228,238,107,138,228,86,228,127,28,68,126,249,44,39,52,1,147,241,200,68,238,65,254,251,108,198,97,114,183,77,189,103,19,29,234,98,14,174,151,190,83,248,29,152,198,252,166,254,172,61,68,70,207,198,87,85,129,6,179,125,238,232,63,98,224,178,180,24,174,61,136,16,80,6,129,119,216,126,25,73,162,154,229,59,164,176,135,89,241,168,167,82,113,7,58,164,202,16,241,248,24,7,144,96,171,195,74,32,152,219,146,57,158,57,111,235,113,232,17,10,60,21,75,88,202,163,253,255,217,69,226,76,114,166,193,99,53,146,114,58,4,209,20,114,244,171,157,199,204,104,190,199,254,31,155,21,123,34,86,45,136,178,99,127,149,116,126,192,213,47,96,5,93,212,10,60,175,6,5,27,209,201,65,86,147,152,88,43,54,153,125,58,63,178,156,21,28,205,167,144,127,113,54,98,239,245,17,127,94,145,209,204,120,201,204,39,202,90,61,3,223,37,191,38,28,107,246,97,126,212,239,110,53,38,32,221,174,235,67,94,182,228,66,219,154,255,159,227,77,175,46,112,15,62,222,99,125,246,191,159,62,100,15,208,202,214,120,137,112,113,243,123,92,239,215,49,75,59,39,193,233,57,29,207,64,133,146,25,230,40,240,215,164,214,2,0,153,66,49,224,211,49,56,204,202,149,160,168,217,2,175,54,189,113,7,81,232,149,231,244,135,84,55,80,209,66,197,73,73,82,79,235,139,5,240,30,113,10,100,115,250,219,194,13,134,126,234,15,71,61,161,187,223,102,92,132,42,158,114,157,75,89,117,156,118,106,11,160,254,249,74,119,153,252,171,33,181,151,141,191,4,203,17,231,157,128,19,14,32,138,179,185,86,84,189,123,206,10,208,26,207,131,218,28,187,144,194,82,34,250,203,151,224,252,150,179,206,48,119,223,6,82,197,119,167,39,233,63,46,65,19,1,14,189,120,208,253,26,212,97,204,73,106,29,199,82,125,25,61,217,85,245,41,121,74,113,20,116,108,211,185,216,218,106,199,134,148,42,69,80,238,87,88,177,202,52,201,114,68,67,143,189,229,183,127,226,255,155,94,7,69,86,215,250,111,148,205,49,109,201,93,132,213,177,250,30,250,31,233,137,110,71,130,35,52,212,237,220,233,122,205,175,16,143,15,164,94,72,95,134,214,103,45,151,109,86,149,24,75,204,50,8,37,40,50,180,238,154,61,137,57,135,82,192,129,181,73,29,18,181,164,28,181,134,97,239,144,69,42,191,192,34,242,73,147,134,46,183,114,26,221,135,138,77,94,145,140,118,135,181,21,226,238,20,59,74,4,236,63,92,252,184,139,222,57,72,12,125,198,14,186,197,143,109,91,24,234,139,160,14,53,246,62,210,19,39,76,123,181,24,223,127,104,190,192,213,6,206,154,28,100,62,114,226,204,183,78,143,59,188,78,204,228,24,243,219,132,201,5,42,171,5,194,76,106,81,63,71,88,34,96,202,113,241,9,149,229,28,164,137,96,214,38,226,50,57,230,50,4,196,171,255,178,214,51,28,177,168,155,214,37,3,42,174,237,34,187,152,114,168,169,129,162,127,92,134,19,158,149,101,149,143,191,249,191,87,74,104,87,50,11,159,226,106,27,163,166,97,83,142,155,86,153,33,236,81,112,61,188,193,186,130,29,206,69,74,58,221,145,177,196,65,202,44,210,254,118,122,10,41,184,49,16,181,151,36,213,129,55,172,41,66,88,143,190,77,129,240,85,114,149,239,4,251,182,12,129,82,167,221,112,28,174,172,157,176,223,182,232,35,49,84,176,162,77,70,184,0,9,26,69,233,20,14,17,52,218,113,139,99,117,122,62,187,237,54,149,79,18,90,2,107,110,134,228,206,37,18,52,210,92,63,250,98,53,236,178,7,105,12,34,90,29,31,72,134,87,167,77,179,235,242,166,59,121,217,187,125,152,70,189,171,188,52,178,45,26,248,209,200,127,160,168,68,249,158,113,177,243,98,24,153,168,207,238,83,252,77,196,132,128,251,84,154,221,32,240,127,184,49,115,47,236,210,200,69,51,64,83,213,251,173,252,229,76,251,120,253,203,249,23,201,244,121,58,8,29,223,209,227,152,105,17,204,129,92,160,210,3,20,40,234,166,208,48,107,221,213,217,133,137,54,150,102,124,212,3,166,164,200,134,144,253,24,188,51,202,119,242,104,32,124,214,149,99,219,23,84,84,130,253,208,52,153,38,6,136,83,201,8,117,157,166,248,99,100,2,37,253,174,157,50,83,73,108,140,67,230,175,220,160,47,149,91,252,194,66,96,53,66,171,52,200,40,192,24,1,55,24,182,229,93,253,23,212,20,51,205,43,199,138,61,96,74,41,141,120,128,246,98,218,122,187,90,157,164,31,145,122,203,195,193,132,104,208,91,64,36,19,131,156,158,0,54,13,160,112,42,187,88,136,14,229,161,153,113,2,153,185,27,182,163,255,2,123,47,21,135,16,130,22,41,69,150,108,34,8,19,74,191,198,202,63,125,164,200,28,133,10,86,81,83,160,207,36,95,146,183,24,202,63,67,14,122,13,194,91,79,201,98,237,60,11,174,79,249,233,217,180,45,248,221,101,218,174,97,193,141,164,229,190,246,151,118,106,66,67,253,166,22,158,82,205,199,75,10,234,227,55,59,240,83,39,205,253,61,0,155,178,47,60,109,74,75,157,138,93,43,126,225,59,52,74,205,171,222,183,151,78,56,120,231,0,105,28,8,94,110,180,131,186,132,29,224,42,248,159,17,217,111,102,124,27,73,128,41,246,49,91,99,141,10,119,81,37,22,188,23,86,192,36,100,84,132,131,232,36,29,231,52,125,148,86,255,70,171,180,78,240,78,211,205,2,74,220,40,206,60,233,36,128,163,26,183,102,249,32,215,146,19,204,58,70,111,17,160,229,78,48,17,38,3,56,42,115,117,27,248,232,89,8,202,225,174,25,133,29,107,136,43,231,84,137,249,76,168,159,113,27,162,200,177,157,197,245,33,50,167,82,240,115,165,31,15,16,158,245,239,61,117,138,99,184,32,55,15,91,220,197,48,201,120,155,116,55,82,229,29,58,83,64,166,25,194,227,252,8,64,235,130,130,211,121,93,33,201,131,232,220,230,252,162,58,105,130,20,248,89,193,8,236,228,152,95,108,165,240,125,70,89,241,105,235,153,38,192,220,37,95,193,118,225,88,43,23,120,235,201,37,222,229,193,27,21,182,78,40,19,13,88,141,103,155,190,136,181,49,73,204,132,119,44,221,214,29,103,57,5,130,64,252,40,160,19,5,226,45,82,145,217,173,199,159,4,222,58,119,5,139,166,204,89,109,174,208,232,246,22,215,183,93,59,179,198,206,95,230,152,143,93,47,83,157,255,114,161,67,36,201,168,238,240,128,194,248,235,197,9,88,191,129,238,198,30,166,245,223,138,193,126,64,18,120,137,242,113,228,64,116,236,216,38,126,246,118,106,157,190,97,3,254,222,203,191,1,209,233,185,75,241,173,52,83,27,144,86,249,212,68,196,52,116,150,135,163,124,236,145,185,191,193,141,10,144,247,51,15,137,164,5,186,196,137,161,245,75,193,146,188,47,165,192,80,179,54,45,232,225,181,223,10,161,216,171,61,103,23,78,81,156,243,76,175,103,41,59,130,208,145,125,109,97,108,118,125,56,32,199,83,69,65,217,190,116,211,233,97,241,184,188,110,153,3,213,212,11,49,240,221,132,126,10,232,33,22,104,113,103,229,33,49,45,97,40,254,38,152,108,8,238,221,0,87,82,22,30,17,239,70,143,191,25,229,44,227,204,28,238,230,113,60,91,140,218,182,75,212,131,196,68,118,177,92,100,234,168,90,3,102,122,129,118,128,118,55,244,138,131,209,75,185,75,181,131,109,115,54,237,150,55,157,157,235,185,190,39,106,83,103,209,11,64,114,145,173,253,191,176,108,229,86,121,142,202,30,117,251,208,54,140,65,16,34,146,10,243,24,3,251,51,240,179,47,29,41,128,189,146,47,94,23,169,30,41,172,228,66,202,58,197,40,162,167,109,48,98,214,255,117,217,58,208,195,42,79,143,22,140,250,107,130,208,161,64,5,30,234,54,154,147,212,109,107,42,19,41,236,73,23,16,170,22,192,255,10,234,28,74,67,254,28,193,59,232,168,155,148,11,39,39,209,177,125,211,166,132,5,1,250,103,146,94,247,253,27,49,101,190,99,35,1,158,197,228,134,24,229,66,204,105,9,91,229,41,95,202,198,205,193,235,190,20,144,222,135,33,211,92,205,148,80,106,132,88,89,9,20,115,107,6,59,227,34,50,174,64,205,203,29,37,19,5,80,37,36,118,35,212,27,51,150,153,54,106,128,238,219,162,5,173,5,65,241,252,108,146,111,206,21,216,139,194,74,41,218,162,75,101,148,93,15,246,240,40,61,20,162,191,3,153,220,253,235,33,30,79,223,48,249,223,11,154,127,164,163,51,58,100,253,24,0,126,174,75,20,177,93,96,172,34,166,165,20,20,200,35,159,10,1,229,131,249,76,167,43,63,215,11,186,57,77,10,176,53,132,98,54,219,96,18,153,167,21,102,167,3,237,232,31,192,168,164,135,238,229,115,42,10,140,246,46,88,141,212,212,8,55,78,158,176,70,50,240,70,22,215,139,230,102,228,71,83,163,100,161,233,235,203,108,100,18,8,200,69,252,156,70,25,37,176,185,59,237,250,243,44,197,105,153,85,129,211,210,174,107,128,212,156,40,133,55,73,36,119,232,95,1,177,64,133,75,104,116,172,123,209,64,162,160,254,250,57,165,36,181,158,209,230,69,213,49,7,33,182,6,240,118,232,150,187,148,176,235,132,153,97,185,181,174,56,182,107,136,253,144,255,148,80,140,157,20,51,173,204,241,122,143,193,44,56,47,115,0,1,97,252,237,59,193,85,221,221,98,2,28,161,184,255,39,173,158,113,192,100,65,166,104,234,164,126,76,90,61,36,198,4,250,100,151,22,1,106,103,190,131,143,41,237,144,145,118,115,240,157,85,122,237,44,243,86,226,216,159,247,89,219,105,196,165,187,104,9,157,10,172,166,121,1,180,136,117,50,202,48,69,159,21,180,170,125,42,128,86,103,22,77,179,11,7,215,139,121,147,249,132,122,79,254,180,210,100,196,22,39,118,210,210,247,200,182,221,37,46,51,252,87,123,202,153,177,82,14,7,185,71,130,178,201,209,254,28,55,241,245,51,83,134,132,248,128,211,86,126,236,133,131,219,39,123,142,240,29,35,144,174,51,49,238,211,138,41,146,107,144,247,69,177,193,227,109,28,203,29,36,32,163,14,176,230,182,50,148,114,107,224,186,67,78,116,18,67,213,178,2,211,99,40,253,146,5,19,62,125,219,17,48,187,52,57,56,186,58,55,27,102,67,21,26,95,68,8,169,157,153,207,181,37,160,71,135,66,46,39,220,181,46,79,161,2,50,165,132,156,187,3,216,96,40,113,237,180,80,111,43,216,43,148,211,133,42,29,16,80,216,167,237,243,20,179,232,213,224,242,70,108,131,224,114,165,231,27,74,174,183,36,106,140,116,104,73,87,19,37,13,87,75,244,117,116,43,170,66,185,116,3,38,82,57,229,104,101,183,236,63,234,133,239,62,93,84,120,200,119,144,124,70,126,119,19,206,180,182,3,112,21,236,93,232,101,223,234,38,223,153,119,169,21,50,33,252,244,147,84,91,248,242,65,158,51,226,188,90,42,131,236,39,213,218,88,144,4,104,179,211,113,126,223,60,117,193,125,236,136,197,110,66,221,47,64,188,210,223,152,151,130,247,106,160,49,63,183,38,216,106,209,244,200,86,203,189,93,153,3,60,239,133,213,90,32,115,255,189,193,180,42,145,99,173,135,209,6,251,127,34,103,16,97,132,122,20,86,10,168,186,21,242,132,240,14,236,118,146,61,108,210,203,246,0,65,101,238,237,228,157,219,248,131,40,95,9,70,139,157,142,26,134,164,107,100,254,51,196,236,191,198,241,40,203,214,237,30,163,226,151,210,175,5,24,58,186,159,46,111,15,37,76,69,58,205,125,46,143,26,36,197,124,35,229,96,190,67,24,247,178,93,20,147,21,33,127,78,2,141,50,72,178,139,44,113,182,27,123,174,9,160,128,33,91,102,65,128,17,104,64,192,190,126,6,182,105,86,123,221,193,251,240,47,171,212,83,249,30,213,212,133,29,171,225,172,43,246,235,158,248,140,132,109,218,57,199,162,176,104,170,214,226,215,114,142,136,73,19,123,117,79,24,2,143,4,58,44,141,123,113,42,186,106,152,139,142,211,29,60,162,91,90,190,23,141,234,134,45,246,107,132,251,252,70,174,115,248,99,31,156,37,19,174,49,182,84,202,12,70,58,131,36,44,42,241,8,98,162,172,137,221,222,244,73,179,195,144,248,8,143,61,120,45,73,185,248,198,242,251,227,25,154,250,168,222,216,43,199,141,93,68,245,162,167,151,102,205,217,131,201,144,80,165,12,75,5,63,179,118,74,56,212,136,57,18,195,33,182,87,162,44,35,205,213,164,100,98,186,13,110,247,230,243,25,227,123,61,62,82,188,157,157,69,214,125,65,24,160,49,7,63,99,111,101,46,204,33,59,134,16,235,147,172,7,133,218,142,44,71,49,12,229,88,251,26,153,184,158,107,173,120,212,183,159,84,189,135,181,140,75,50,160,205,222,122,208,172,229,175,123,230,20,239,100,207,129,51,194,217,156,198,17,46,123,110,217,39,196,223,240,216,130,64,46,21,87,224,23,255,73,126,145,57,62,4,220,5,92,47,123,38,31,36,28,61,112,247,245,24,124,14,245,8,3,188,8,119,16,110,207,106,182,195,24,25,198,195,37,1,253,234,3,64,100,188,253,55,44,164,63,227,237,28,139,163,62,242,203,19,212,178,171,144,210,142,47,96,222,60,218,236,144,91,102,86,179,218,240,49,165,33,74,32,21,195,189,61,106,56,81,254,49,105,128,141,153,178,74,207,120,157,43,42,47,41,237,235,30,183,161,245,9,172,66,150,121,211,112,202,128,192,216,205,100,137,107,105,229,249,81,190,68,214,217,63,155,158,210,131,44,209,30,137,63,30,234,171,169,226,233,104,123,22,95,174,103,201,219,167,246,42,151,197,74,234,129,240,89,20,105,63,202,235,42,77,111,185,95,7,4,2,77,229,211,176,192,5,98,214,172,202,105,130,63,44,29,132,49,158,40,209,1,229,229,100,201,62,122,203,196,241,167,118,66,181,83,37,160,122,220,140,212,79,252,88,157,180,183,189,162,147,140,176,250,206,92,49,188,81,2,87,201,254,207,112,207,9,125,53,178,230,219,175,55,64,6,22,47,131,82,220,79,109,157,56,141,195,82,69,3,137,150,122,153,63,101,147,23,111,229,225,212,236,216,166,73,6,15,134,145,229,19,168,220,169,100,219,38,250,14,40,152,255,225,239,31,202,180,9,171,0,32,194,139,117,132,123,154,177,66,90,173,233,79,153,44,173,183,22,198,21,117,90,109,205,202,131,130,131,189,223,152,116,236,201,11,235,123,74,57,20,44,230,162,21,255,42,252,25,21,243,2,110,189,203,80,212,60,195,148,41,5,237,23,178,141,242,80,8,148,209,50,152,174,116,5,229,199,203,157,135,17,69,61,134,67,253,235,45,190,219,192,170,238,137,102,80,244,127,226,89,28,18,245,22,164,128,128,109,234,198,201,100,59,157,134,173,80,215,229,254,64,170,91,195,199,68,71,65,198,82,191,95,27,135,165,12,184,100,127,136,164,182,152,139,118,73,96,5,70,156,153,45,194,15,60,178,24,179,243,72,167,168,116,28,233,132,5,56,81,249,243,174,160,64,70,17,118,230,1,80,48,125,76,44,93,197,55,119,133,134,167,133,184,163,71,195,180,252,128,223,75,65,255,197,122,177,97,40,66,207,133,46,152,60,199,141,226,162,57,4,240,36,142,163,238,234,1,209,47,30,251,102,72,106,220,56,31,81,131,149,194,37,246,196,205,207,200,194,234,144,20,142,159,236,170,235,161,146,96,130,124,194,253,16,216,187,193,177,71,237,74,229,165,232,89,234,121,35,39,65,2,214,20,8,132,250,57,139,155,202,73,58,204,154,154,23,97,55,177,238,170,245,117,228,105,188,1,77,231,220,95,4,18,46,92,231,25,76,222,99,13,86,181,160,242,65,233,46,54,104,36,31,88,245,98,68,38,177,5,200,127,75,33,0,24,145,179,26,37,212,168,106,51,62,89,216,93,146,149,79,181,27,34,254,161,12,126,176,61,27,81,132,168,244,56,64,220,16,155,171,69,24,46,135,166,102,68,80,60,219,197,227,96,108,245,115,13,64,224,128,74,115,154,200,10,212,56,124,86,145,119,186,34,166,7,20,9,11,180,230,201,65,27,140,144,170,25,103,230,151,101,98,248,175,219,74,209,19,199,73,193,197,107,74,37,145,72,1,222,142,244,42,31,180,2,102,15,210,30,21,153,227,212,65,40,210,19,89,137,169,174,223,5,85,105,125,72,51,155,36,36,161,225,52,183,57,110,186,13,201,134,240,222,178,154,134,51,130,46,217,237,12,10,14,251,138,34,24,216,208,155,107,216,177,237,13,104,134,209,41,44,53,132,98,80,102,166,85,108,45,231,165,15,88,155,19,255,131,75,139,229,138,240,136,100,220,176,219,195,45,128,73,119,163,3,81,246,232,3,116,220,191,27,123,43,124,1,1,52,194,165,144,23,152,251,150,103,236,32,253,123,12,20,50,211,177,212,66,122,207,124,241,18,65,28,123,22,126,3,81,165,103,190,81,11,245,56,225,146,236,214,214,253,107,171,219,209,216,67,217,18,237,35,171,51,208,245,68,8,45,133,16,181,123,53,13,54,233,52,71,73,24,213,28,20,62,196,172,22,189,209,142,27,189,179,37,34,36,247,45,46,47,233,25,87,149,186,43,62,103,197,115,236,136,129,29,132,13,255,73,187,65,59,74,248,37,250,137,31,216,138,245,153,153,75,125,72,94,107,152,162,119,138,184,179,113,78,163,5,211,254,243,106,165,104,240,32,248,231,92,1,28,222,207,76,46,3,218,255,205,92,84,237,160,56,254,139,53,155,39,48,11,13,93,245,148,142,21,37,253,231,191,23,161,183,88,25,137,205,207,60,95,122,35,106,110,66,75,231,179,133,179,163,119,176,124,175,7,41,192,5,121,148,10,62,96,88,221,130,88,133,36,185,217,117,118,209,45,102,183,250,7,77,82,27,32,181,20,210,94,45,160,19,138,206,246,96,85,144,161,89,249,3,31,181,153,49,157,189,21,201,9,147,14,113,143,233,64,73,90,179,60,176,229,20,174,48,252,249,44,70,54,157,201,93,117,94,135,187,137,180,89,160,77,110,163,251,46,201,194,146,150,47,46,141,80,2,243,21,207,201,122,84,45,250,127,111,45,172,70,191,57,190,104,66,28,110,8,229,40,147,23,148,31,27,144,231,194,94,215,11,168,184,177,164,88,138,232,246,17,144,232,122,99,128,22,157,54,135,27,7,23,252,89,127,207,202,164,166,9,226,127,253,123,145,117,231,52,107,112,91,34,232,138,124,144,158,77,147,237,43,205,80,172,122,174,239,222,99,253,51,97,38,53,125,229,65,18,145,238,65,0,61,13,108,197,48,170,127,97,105,165,171,228,116,87,41,12,28,95,85,177,112,198,118,226,161,148,155,238,49,87,149,119,179,106,19,183,110,85,119,160,129,208,23,253,192,222,38,19,131,3,57,166,135,200,54,106,118,146,197,204,225,50,191,102,248,36,67,252,187,172,142,161,12,185,76,50,103,206,52,170,146,63,18,55,123,18,27,252,85,189,169,182,112,69,131,178,246,217,200,91,250,29,105,12,197,34,242,167,97,99,231,10,124,185,26,118,41,201,214,189,31,216,211,91,62,22,184,236,95,96,246,80,214,110,55,100,177,120,139,254,47,23,16,136,128,190,27,180,115,32,123,166,171,44,177,161,74,127,225,150,158,91,7,130,179,142,222,186,169,210,250,240,86,91,238,104,182,35,206,199,216,120,194,239,201,123,65,232,90,48,209,137,54,15,128,50,67,202,147,145,208,142,3,100,161,10,75,131,102,34,136,202,159,33,208,185,243,28,125,19,199,68,229,166,243,111,124,154,166,82,72,197,54,205,236,27,136,171,124,10,46,236,97,115,177,231,143,30,135,149,192,38,37,230,73,146,56,66,18,238,67,65,192,18,255,204,193,145,49,171,172,138,126,101,57,67,124,96,255,187,80,189,103,206,224,253,49,166,240,255,94,171,27,22,5,141,136,41,169,60,101,251,250,231,106,76,111,144,171,137,132,27,207,253,95,207,56,32,156,205,96,113,110,234,223,223,242,61,202,219,91,8,66,178,78,155,240,110,122,254,245,117,132,184,94,212,82,149,191,66,174,97,116,81,167,22,147,194,36,15,206,88,143,222,38,135,94,119,133,100,205,67,121,170,244,222,119,94,104,150,148,142,14,122,2,114,12,10,54,109,253,240,52,238,175,178,165,253,132,198,205,151,210,64,86,87,143,181,225,232,254,114,235,98,180,109,197,45,125,21,12,155,29,235,26,231,88,42,77,182,99,160,72,194,137,70,135,169,247,216,40,50,156,122,140,128,167,254,143,68,122,181,89,148,135,173,129,129,218,39,199,30,58,141,245,106,231,64,255,254,254,40,175,184,211,96,94,23,172,53,127,124,229,250,70,129,155,200,162,143,38,246,139,160,38,250,17,253,222,171,100,195,183,211,126,63,159,128,58,107,228,186,189,131,42,233,240,18,92,2,214,6,62,69,8,227,70,215,29,151,218,177,184,144,222,86,63,163,96,153,214,233,96,28,204,22,243,49,140,11,177,55,225,90,123,6,139,67,172,30,9,197,207,26,150,178,7,57,17,53,222,98,202,155,61,115,102,250,222,174,127,245,195,64,69,162,254,84,205,34,182,161,184,228,33,14,59,221,174,221,31,241,254,115,209,90,248,180,171,127,15,104,61,27,21,95,225,26,119,146,207,55,71,160,71,0,76,81,251,172,41,233,253,104,184,15,79,108,68,158,114,21,61,237,167,143,186,100,135,127,74,179,67,95,133,71,27,36,102,61,33,41,68,220,72,249,113,7,158,165,118,171,90,186,212,165,181,128,89,103,42,158,236,71,22,111,86,9,255,103,196,121,52,197,128,128,203,52,117,30,255,167,100,86,171,6,166,96,0,81,191,66,69,23,204,249,155,132,8,59,206,58,55,203,178,97,116,96,194,172,185,180,23,192,189,196,185,72,139,91,170,160,77,11,166,29,114,13,159,200,99,224,93,228,72,151,212,255,130,77,22,181,27,141,118,211,152,145,159,196,221,186,184,13,84,184,226,238,232,234,239,61,3,221,87,104,198,9,17,120,21,45,102,137,205,164,97,127,46,112,192,238,227,103,151,198,235,83,160,227,31,198,85,168,148,72,82,201,23,21,89,240,43,73,153,71,157,60,217,201,74,160,130,215,232,62,232,59,188,71,123,50,253,230,36,67,235,173,2,71,202,139,196,87,132,188,235,39,220,35,87,96,222,110,162,60,95,109,122,91,161,87,37,145,56,150,147,100,57,244,172,249,46,205,237,213,77,254,80,184,50,63,165,30,250,189,251,58,155,255,79,15,218,152,133,171,13,182,11,57,140,245,8,147,65,159,55,19,112,217,120,177,251,196,126,163,115,31,173,70,122,61,212,163,204,52,224,46,89,93,155,2,204,71,177,56,233,99,244,224,178,3,143,203,40,162,130,104,175,93,183,224,245,205,99,214,144,150,2,144,185,85,144,44,229,202,31,164,164,180,236,234,164,60,90,75,215,82,133,136,195,82,132,221,0,187,20,187,236,139,36,209,83,100,133,201,246,20,177,201,145,22,106,124,16,227,133,230,180,32,241,16,110,59,215,145,94,226,224,76,51,63,175,65,99,69,200,105,3,137,59,200,212,92,87,246,199,29,84,60,160,214,112,122,235,153,3,119,173,152,133,22,2,64,51,238,135,187,116,233,213,193,166,74,69,27,245,251,162,38,79,162,97,118,114,164,137,25,18,145,222,90,179,220,16,38,8,65,197,19,144,93,61,86,121,109,56,3,50,216,45,217,125,35,142,109,136,238,212,46,9,83,177,136,225,56,47,174,6,238,145,109,244,216,43,32,162,2,178,206,5,79,0,143,101,159,38,98,84,249,45,165,223,83,158,199,31,37,136,200,76,58,214,22,47,198,217,188,171,21,197,194,78,246,84,105,3,125,36,246,57,197,92,147,188,230,82,103,54,238,107,236,128,27,57,187,254,195,185,120,97,242,226,211,202,89,34,88,114,8,220,254,117,128,110,177,221,25,88,208,73,89,188,39,231,35,3,230,180,152,46,20,192,12,188,224,155,120,237,236,133,50,17,208,251,141,104,187,153,68,164,248,190,178,189,73,193,80,189,51,114,152,140,240,181,253,74,14,179,99,191,107,10,59,129,31,19,220,229,42,102,24,37,98,5,57,44,186,90,198,30,185,39,131,55,249,66,92,180,49,27,255,17,147,76,125,21,109,101,204,194,85,248,89,108,255,27,218,225,126,10,70,94,9,46,193,207,48,227,223,105,111,219,226,179,208,82,132,158,154,83,140,115,11,225,87,191,224,62,196,78,112,232,239,137,40,192,165,129,95,0,15,37,36,161,136,176,41,66,117,178,133,183,105,218,22,83,34,154,180,128,47,148,41,115,142,75,229,157,1,30,33,221,59,93,53,132,237,222,232,72,107,113,96,200,50,119,206,49,128,191,105,142,195,3,23,75,183,108,193,97,249,142,71,144,182,209,244,26,101,38,92,222,210,248,142,30,195,58,235,63,28,102,57,226,168,31,114,122,208,8,225,39,73,45,75,115,125,171,204,253,34,95,214,104,8,49,73,109,60,15,178,173,219,174,136,113,99,180,49,148,45,238,163,219,131,140,24,190,21,56,96,115,168,232,126,131,78,217,155,98,228,156,64,161,211,21,197,126,144,244,5,178,226,52,171,45,63,199,208,182,91,179,73,205,25,225,58,142,16,215,225,220,121,170,13,21,52,10,250,136,144,100,132,160,224,79,198,25,13,127,45,75,69,69,103,241,7,84,64,53,111,60,151,74,42,131,225,91,146,27,249,238,40,202,26,187,52,24,76,101,63,32,171,206,193,248,24,173,49,182,166,49,163,225,126,160,150,15,137,81,110,225,252,91,191,188,102,115,144,31,101,138,249,134,14,159,96,117,206,126,157,159,98,60,89,140,69,146,206,217,144,217,38,59,86,137,124,62,113,148,40,218,40,59,217,92,46,125,66,228,146,17,142,36,107,97,215,16,127,149,17,26,253,109,254,100,38,176,158,52,29,2,200,80,114,112,171,43,76,125,7,74,239,192,98,2,210,57,215,10,136,191,31,96,233,138,80,106,74,159,86,34,158,235,251,71,156,7,63,10,203,203,27,84,113,162,94,6,102,188,210,233,205,161,171,183,175,82,51,99,173,223,86,219,97,50,111,219,159,142,250,205,57,227,77,73,225,46,236,59,9,92,36,124,143,154,221,121,90,158,200,2,63,108,250,105,52,162,141,68,48,213,25,125,150,143,59,117,77,112,131,165,53,38,103,60,174,66,188,191,190,246,139,99,199,213,191,216,123,187,223,114,174,158,92,126,0,24,114,185,166,119,93,83,48,242,220,50,152,184,158,101,72,246,28,90,61,222,7,158,176,177,63,198,124,45,43,105,174,94,147,70,9,58,1,70,106,238,30,52,231,144,3,62,237,161,239,194,250,110,162,161,119,132,112,3,149,209,42,159,251,24,202,227,190,106,182,144,87,50,184,228,89,238,244,229,60,165,180,240,51,242,119,10,200,195,206,31,235,213,233,143,110,231,224,174,183,170,87,54,100,172,151,177,18,74,110,158,98,192,214,106,19,133,94,4,87,184,119,212,166,196,113,118,146,57,244,177,187,108,231,142,120,199,38,27,22,241,199,81,77,49,70,105,237,146,67,168,233,26,227,57,244,139,101,124,120,22,48,21,61,133,226,153,185,36,221,132,140,115,135,145,33,163,56,118,64,226,243,212,109,19,66,152,126,38,181,212,237,121,15,231,158,222,195,194,185,239,78,62,49,45,132,68,249,79,251,123,29,175,219,136,147,60,112,36,145,204,40,224,164,139,76,85,46,6,204,89,141,28,112,55,40,159,168,230,0,156,197,76,126,159,133,21,202,229,128,113,16,59,54,191,166,39,40,153,114,206,190,33,178,26,13,237,92,222,144,89,99,0,5,136,132,26,108,19,148,109,71,209,29,182,82,148,211,238,43,24,34,125,119,141,244,156,25,192,85,67,132,191,74,125,1,226,46,218,157,68,79,148,226,7,39,66,42,160,213,229,30,170,84,45,158,170,95,179,243,251,73,133,123,17,51,69,31,75,28,128,81,175,119,127,194,166,83,144,222,84,234,244,253,89,192,10,234,173,61,198,0,108,249,62,211,35,215,190,33,241,45,182,114,118,32,172,165,107,25,65,34,70,255,47,132,98,96,53,62,111,57,179,154,153,245,131,14,38,10,137,200,108,160,136,176,126,31,92,45,33,52,149,143,4,124,30,125,85,136,52,163,237,179,107,80,201,154,161,232,226,195,136,124,35,248,157,187,107,233,247,180,34,3,240,38,36,252,24,50,107,199,131,205,157,144,121,23,65,247,56,173,44,127,173,176,129,199,66,58,86,42,156,59,134,76,2,7,127,93,91,52,161,127,79,24,206,38,69,107,86,81,188,54,158,9,107,74,17,55,108,75,173,51,126,130,32,129,202,238,77,172,85,35,86,11,20,150,158,168,43,110,50,205,37,77,171,190,95,30,196,160,133,225,230,172,162,97,90,214,56,51,212,91,93,235,37,88,77,203,38,241,26,125,170,100,43,248,4,77,180,130,194,66,48,137,155,246,74,85,146,111,52,91,32,178,237,187,224,10,217,77,228,12,46,103,4,43,248,179,42,48,209,73,207,22,1,84,190,77,236,139,45,95,60,37,104,110,109,23,101,179,183,132,190,151,74,48,105,29,161,35,54,46,248,82,155,64,184,20,238,160,39,217,156,26,161,102,219,138,231,39,142,56,52,21,6,119,209,185,236,39,161,47,51,25,207,75,74,205,203,130,76,122,209,241,124,118,176,67,35,138,84,232,81,251,71,217,193,69,156,14,10,105,152,10,115,247,120,36,229,39,78,21,75,158,105,168,255,81,176,59,186,67,127,29,146,253,239,211,216,34,29,55,164,119,213,243,192,109,208,30,173,145,131,204,10,231,145,35,21,146,10,228,181,237,216,56,224,218,200,251,194,134,148,105,131,36,236,86,1,177,47,221,111,119,201,62,227,122,41,232,101,33,182,178,194,60,95,8,13,173,73,168,176,212,56,180,45,63,57,220,79,5,79,73,236,208,13,30,244,48,216,46,47,24,65,142,158,44,123,175,135,64,91,91,22,21,49,153,187,137,97,141,126,82,30,126,168,8,83,4,189,50,179,74,23,26,170,177,159,252,8,208,33,52,54,89,190,26,244,174,187,118,187,119,207,107,25,4,253,237,195,119,239,78,1,109,231,88,246,229,35,172,23,21,76,202,142,193,26,204,94,47,192,195,178,110,213,61,206,1,112,64,110,237,188,227,12,11,176,91,222,177,197,97,114,129,55,109,254,43,60,251,27,104,203,142,84,134,12,170,158,59,157,165,98,67,113,54,251,44,210,31,247,102,159,238,160,255,246,24,19,249,61,132,31,194,123,58,108,211,124,139,1,49,223,9,148,127,236,155,251,189,79,125,167,204,248,240,243,116,36,16,50,202,132,139,230,153,188,97,181,182,177,162,71,25,53,94,158,142,76,174,188,244,109,149,137,233,13,217,237,201,80,120,183,201,26,32,63,16,189,2,181,134,184,92,1,82,48,39,119,175,43,210,87,38,217,116,250,221,122,251,128,255,230,69,210,21,13,57,85,175,252,165,134,3,188,138,31,130,113,9,46,200,65,23,156,56,169,72,27,79,107,119,77,187,232,24,152,49,165,141,103,111,34,18,243,231,22,21,187,54,10,206,64,195,192,222,167,221,195,94,20,22,183,149,0,241,58,126,237,187,189,54,103,20,201,6,222,154,212,9,194,49,171,244,18,193,134,229,152,20,101,16,51,255,167,143,134,54,124,90,110,55,162,233,30,22,156,146,150,28,132,217,176,36,38,169,250,196,248,173,208,28,43,245,244,31,218,170,213,253,157,141,179,34,182,165,158,25,212,106,222,252,195,196,251,239,248,84,188,215,128,141,214,215,15,100,46,63,251,105,216,28,36,92,184,74,208,141,234,37,92,225,218,222,95,21,110,33,221,157,154,207,255,2,17,23,182,15,62,11,188,20,45,114,146,151,10,160,33,43,205,249,70,210,211,88,80,57,119,75,11,3,130,232,109,24,47,32,64,168,32,16,207,155,182,120,112,80,168,30,114,166,204,191,127,2,220,135,203,201,254,218,186,104,113,106,221,234,210,18,129,74,242,21,237,242,101,166,241,189,2,233,105,157,51,75,242,36,97,144,157,133,158,56,244,123,174,111,191,16,114,185,111,93,2,19,115,13,238,218,254,85,239,223,47,101,200,22,229,115,49,169,151,97,247,36,40,22,68,180,53,93,91,77,21,105,125,75,21,119,144,212,137,167,155,11,43,159,131,190,204,120,102,25,70,93,237,183,162,240,121,117,62,104,61,97,104,157,184,69,107,154,213,71,219,239,52,111,138,95,139,113,24,233,38,69,110,240,221,115,160,217,8,6,79,10,194,141,211,244,30,238,102,161,131,234,84,149,230,244,160,28,234,84,254,203,26,144,231,48,98,64,174,99,251,43,76,178,238,117,218,12,221,147,128,40,65,18,174,194,15,205,6,90,42,96,233,168,52,133,36,116,19,30,125,63,0,184,137,13,112,157,216,4,48,245,16,145,200,248,48,96,252,240,73,189,239,148,112,100,134,16,18,227,133,227,31,96,51,130,222,51,189,14,199,86,249,175,1,196,166,186,88,32,200,37,253,112,91,215,4,180,215,107,120,167,243,242,47,20,15,27,39,139,155,175,214,10,118,142,101,140,52,1,227,45,57,96,246,145,244,187,118,42,255,3,152,119,19,49,74,60,4,160,74,199,173,145,253,110,159,165,14,214,73,70,59,65,12,2,124,21,124,50,254,124,66,161,98,139,196,219,199,168,201,205,69,63,156,160,54,73,123,102,28,206,131,159,190,172,212,144,15,237,182,113,132,193,31,247,214,47,79,10,243,112,250,99,220,120,53,68,229,178,50,161,148,8,23,99,81,147,166,183,10,19,130,195,78,105,73,88,73,64,87,64,194,130,66,188,137,131,249,99,190,221,91,48,44,178,26,82,166,38,46,94,117,43,180,138,222,177,6,138,94,70,120,38,233,224,120,29,190,224,116,178,124,66,5,94,106,53,200,83,100,143,255,124,157,53,197,199,114,191,143,93,180,5,164,245,193,10,63,59,127,168,74,198,149,21,67,67,65,196,156,11,223,197,93,201,230,244,153,40,94,229,180,25,167,26,48,141,162,32,114,112,254,202,15,1,193,172,53,164,202,12,242,176,187,189,210,166,59,57,189,215,73,81,247,193,95,252,196,11,255,1,99,114,0,207,46,78,127,67,114,87,189,86,139,207,137,21,46,144,166,165,62,42,37,122,31,62,129,8,173,25,13,47,213,26,236,226,39,143,162,28,77,1,165,214,198,12,153,52,230,12,148,133,138,5,134,116,65,152,94,35,150,67,59,88,35,172,37,4,201,70,190,75,231,156,58,109,55,56,141,35,68,206,109,59,10,84,182,201,162,239,32,217,160,3,148,237,2,206,24,122,186,183,222,212,42,22,107,53,52,4,127,252,244,88,5,88,31,38,47,222,154,246,58,134,170,90,240,250,51,206,227,42,249,46,3,239,3,149,84,20,105,81,159,223,63,14,247,177,131,103,59,189,79,9,18,56,213,81,227,160,10,105,63,6,90,84,44,111,252,154,223,196,156,67,157,195,86,233,24,208,243,249,42,70,50,60,217,181,211,29,232,56,125,116,39,162,8,203,217,69,68,21,12,71,199,95,65,46,141,82,227,179,183,114,7,22,254,40,65,63,168,163,126,195,135,13,83,103,13,46,147,231,55,209,51,142,209,155,89,233,247,55,226,171,97,248,250,211,209,217,192,105,136,127,170,252,18,43,69,195,114,23,69,27,99,69,173,28,223,17,133,126,253,45,41,245,242,145,95,95,78,111,31,96,205,160,210,101,109,252,49,209,56,28,29,243,231,124,95,39,35,115,90,42,143,195,231,151,158,70,105,198,169,89,162,183,225,89,178,227,139,174,154,144,12,115,49,175,175,114,230,250,147,104,4,79,12,141,33,29,218,69,68,40,69,34,61,246,250,42,149,198,32,154,190,194,226,106,212,83,53,179,184,178,52,169,2,149,215,213,247,134,2,108,129,242,231,250,232,83,69,37,228,199,228,132,170,116,2,8,11,133,89,115,70,200,103,186,58,80,198,222,74,187,132,52,39,181,94,185,246,141,16,33,43,11,194,129,188,188,158,188,100,213,110,163,131,87,12,26,218,119,25,129,255,58,113,132,102,117,166,163,131,244,74,108,243,76,200,109,67,44,7,89,174,187,180,25,149,203,100,104,60,240,202,157,30,247,53,142,188,34,170,143,176,208,3,229,145,241,191,17,117,236,5,0,61,194,189,164,126,60,45,125,30,144,95,253,85,251,60,204,143,159,153,32,250,182,127,150,170,75,181,97,177,138,133,241,25,232,70,67,10,22,39,240,215,141,247,124,212,157,128,81,196,221,37,72,37,58,60,103,201,91,82,252,151,181,9,142,214,254,137,248,199,128,130,13,118,33,181,59,27,79,212,60,144,101,129,119,172,106,163,62,82,53,23,1,117,90,217,121,57,204,186,120,83,184,98,45,135,236,78,51,28,224,201,184,250,119,248,4,139,177,247,202,14,20,197,173,242,218,70,52,233,44,206,250,70,173,111,81,41,208,76,151,121,205,191,226,145,134,16,160,170,118,243,22,38,192,33,40,146,176,63,194,110,238,184,81,36,218,13,163,24,175,148,205,29,249,12,101,74,74,60,17,34,150,37,80,109,200,147,21,184,0,186,37,217,222,253,119,62,40,101,28,147,189,230,169,221,249,19,37,9,239,22,90,187,223,161,44,255,220,174,192,59,55,141,25,253,43,220,39,162,29,145,169,229,74,236,145,241,125,119,162,222,178,210,222,113,16,83,84,233,143,174,23,161,218,106,134,69,168,151,37,224,25,86,11,104,54,121,59,220,84,250,154,181,198,222,3,106,51,67,46,50,235,193,198,81,90,71,113,236,200,40,177,30,173,3,25,234,155,6,98,165,86,237,150,115,140,204,110,161,214,106,172,30,23,63,222,188,89,138,78,74,189,237,43,224,119,118,113,123,135,120,55,38,51,210,118,4,98,77,192,90,212,189,229,249,151,232,112,45,248,244,210,181,21,218,50,73,142,116,189,146,57,201,5,60,208,179,4,175,90,110,79,114,40,198,174,200,67,26,132,202,56,124,44,60,112,7,96,241,5,186,156,22,132,117,254,225,237,158,177,36,188,179,100,16,245,231,95,169,185,68,17,40,49,212,251,43,154,8,251,96,26,107,7,93,46,27,196,168,48,143,168,131,12,190,115,141,220,154,159,63,55,9,250,106,10,220,180,92,229,222,171,210,104,47,210,78,114,105,48,228,8,63,116,220,192,70,12,169,46,5,28,72,45,123,210,130,106,101,233,96,118,76,124,111,141,26,157,19,51,154,115,95,107,105,162,163,178,114,57,147,250,164,25,23,6,103,5,156,63,34,90,132,26,209,124,54,126,209,38,101,130,40,194,227,204,101,22,84,209,67,247,194,238,137,0,28,100,22,223,80,47,227,229,1,50,211,35,116,68,229,148,136,159,151,168,31,60,15,146,203,34,55,176,61,116,26,175,249,1,173,207,85,156,156,248,154,182,164,68,216,182,43,241,137,241,241,187,10,79,59,44,170,213,58,119,188,40,6,78,237,176,151,234,127,12,63,119,30,136,167,48,11,59,7,255,213,232,23,3,35,90,45,134,146,4,6,129,29,227,11,30,174,44,57,44,184,233,160,78,231,204,45,174,78,8,14,176,207,189,212,249,125,160,227,135,144,124,63,78,229,178,185,101,212,153,24,106,165,91,152,27,129,89,6,21,195,131,71,3,221,207,122,50,241,16,234,136,7,216,11,187,81,123,51,100,203,66,166,27,13,87,224,97,245,108,51,150,37,79,121,99,1,110,6,15,179,247,8,122,84,163,176,131,159,158,100,83,228,153,209,92,10,159,202,100,48,147,230,235,242,105,225,62,120,162,67,123,223,133,102,124,181,43,110,92,51,169,146,0,72,227,89,52,203,74,88,197,197,225,69,233,86,243,167,65,98,156,44,23,167,238,180,47,116,228,163,169,39,252,207,176,151,197,206,95,152,105,163,237,169,73,221,31,56,24,247,44,30,130,248,250,168,51,107,49,32,125,92,36,163,77,136,61,226,30,20,103,55,92,109,138,36,16,88,88,81,152,102,93,85,90,177,20,77,176,9,51,42,253,87,253,112,22,141,108,144,39,102,106,132,233,117,85,77,109,248,216,3,60,50,121,115,254,216,77,90,220,142,74,76,131,179,2,11,174,117,113,83,100,123,84,155,136,93,76,31,170,220,182,147,77,68,29,235,104,138,84,197,163,250,79,184,202,249,62,177,138,62,90,144,96,68,229,131,70,225,150,194,156,99,63,127,139,163,189,238,185,228,66,144,83,123,116,154,102,78,71,120,160,50,48,15,46,161,129,78,9,161,47,203,129,171,43,196,107,175,28,132,186,95,111,238,189,236,198,244,27,214,80,171,141,209,236,204,97,217,43,119,196,65,71,17,13,168,87,196,230,113,190,143,161,8,110,65,217,225,54,207,214,77,250,158,233,61,216,105,219,140,49,5,172,81,21,175,190,60,147,79,144,98,189,55,251,148,96,218,135,153,122,14,35,245,174,159,193,152,190,48,215,13,95,192,161,182,131,24,29,63,120,115,226,194,203,106,61,207,7,16,181,87,198,185,53,229,44,159,39,185,102,100,200,180,195,222,83,156,193,243,199,148,27,220,24,241,232,94,232,75,54,158,55,32,12,117,67,62,66,173,247,52,155,68,178,172,60,68,126,170,171,189,74,101,96,149,129,65,15,186,161,133,56,170,186,190,152,247,67,226,70,58,45,118,168,212,197,136,111,219,132,88,255,149,180,231,99,230,239,211,147,65,102,176,210,43,46,172,221,225,20,248,59,214,78,59,133,188,181,180,171,60,244,231,46,87,104,14,209,76,153,191,16,132,40,34,252,62,30,77,61,237,243,72,234,29,36,55,134,89,175,116,59,67,20,71,78,230,147,86,16,42,88,209,45,167,40,249,36,104,56,94,70,244,1,96,0,28,238,242,53,212,132,149,252,203,84,119,42,169,44,205,77,43,85,33,137,144,238,87,113,68,62,141,133,208,113,152,62,79,233,99,241,64,221,187,175,69,81,243,199,43,89,29,28,116,113,13,99,4,148,191,57,69,28,199,116,125,105,96,97,188,18,233,167,31,64,185,1,237,63,182,191,89,121,252,253,207,107,42,144,70,232,75,77,235,30,133,153,61,163,51,25,199,39,143,47,132,181,195,68,133,83,58,125,229,150,203,234,179,189,97,136,124,209,241,14,23,221,25,95,84,93,223,136,82,191,209,129,35,161,223,243,106,18,82,53,244,96,231,189,180,166,151,16,89,214,190,110,159,91,14,50,90,97,251,254,100,186,96,149,74,43,14,204,80,248,67,182,200,145,226,169,121,104,209,130,5,92,158,67,198,76,249,132,211,42,254,114,191,211,93,42,97,145,120,111,188,184,142,242,28,192,185,213,132,140,158,10,227,242,160,72,104,246,114,102,161,12,114,88,35,204,35,3,23,2,60,204,145,116,10,153,116,195,69,200,181,183,122,241,147,180,28,35,71,45,245,111,71,130,123,254,137,18,168,77,164,248,175,212,87,181,207,242,218,72,6,233,101,18,184,56,248,11,225,176,183,196,8,73,128,57,188,70,198,251,68,49,49,76,70,235,187,111,160,105,220,44,41,43,79,228,68,94,87,125,179,215,240,125,43,10,234,86,242,251,24,237,76,41,117,243,108,216,200,110,59,0,102,11,49,250,254,9,120,59,208,126,102,75,236,171,151,138,243,189,131,129,197,43,247,57,230,86,164,47,214,223,60,159,170,138,83,100,243,10,206,90,43,183,2,188,226,232,224,24,221,73,131,180,107,194,34,186,126,13,71,213,75,188,233,188,251,219,120,32,9,103,98,107,102,231,236,88,99,22,41,44,132,54,72,24,246,120,150,179,169,251,221,54,220,166,172,152,50,146,242,211,236,155,26,236,6,23,151,24,199,118,0,41,234,68,44,215,214,34,197,174,227,231,79,255,11,201,196,47,41,210,219,103,203,102,188,202,3,5,254,68,248,88,100,249,196,58,199,161,222,227,110,55,251,242,149,45,123,95,198,90,96,202,225,177,112,112,75,77,6,133,24,49,186,67,227,79,129,249,171,72,216,97,164,81,111,33,196,31,141,176,111,245,203,12,116,152,114,27,162,108,183,188,104,187,85,65,132,84,170,128,95,4,238,98,255,100,61,185,124,136,225,20,201,95,71,11,145,44,197,41,184,25,115,93,106,214,25,209,125,168,229,251,74,228,98,193,87,129,24,218,251,97,148,88,0,211,167,187,191,206,96,163,77,56,99,145,18,1,185,102,142,129,12,2,89,181,0,14,15,2,25,63,154,78,143,127,114,123,22,69,175,130,250,28,154,182,1,207,167,52,214,43,125,29,135,100,157,139,11,226,69,100,5,8,78,71,39,211,61,58,145,156,156,45,198,207,27,17,177,37,214,251,96,255,79,196,113,15,221,161,46,194,254,252,238,35,171,118,133,238,18,35,34,233,16,109,161,32,124,204,44,86,237,115,7,171,154,123,19,125,199,161,200,101,71,255,218,90,164,6,245,51,204,97,37,232,138,166,89,85,161,90,72,7,5,152,167,61,71,132,88,156,104,123,65,249,221,31,108,51,137,53,122,119,81,49,90,241,20,177,230,157,188,165,164,8,133,188,35,173,217,7,243,152,232,150,78,133,156,211,9,85,116,74,27,211,180,5,117,217,127,3,104,228,227,235,48,45,149,209,91,105,86,149,29,205,102,120,147,41,135,180,69,86,165,203,208,0,82,76,21,130,20,65,100,102,132,145,32,49,88,59,230,235,136,33,56,9,186,0,130,191,157,27,180,106,141,56,215,136,171,75,97,12,215,70,32,157,38,48,127,73,120,117,209,27,57,183,77,237,94,37,28,126,78,92,76,115,19,15,180,11,57,23,193,20,108,218,152,103,195,51,179,195,170,255,84,150,135,68,104,34,143,10,110,177,89,66,74,119,13,81,113,17,219,53,118,148,209,11,76,193,191,25,202,249,125,29,218,89,4,20,137,111,125,80,107,53,96,123,166,59,158,190,31,202,70,151,159,76,59,139,66,236,82,15,100,98,13,30,216,162,146,171,201,74,149,68,248,146,156,154,78,210,197,213,177,139,205,115,40,192,168,133,12,165,146,83,124,7,135,174,25,104,178,170,42,143,41,200,61,228,153,243,27,38,6,21,221,48,84,103,104,58,217,6,246,111,177,31,155,26,197,51,117,197,70,182,92,121,23,221,68,156,63,15,241,170,241,203,48,125,91,27,195,213,45,220,28,245,214,138,255,95,78,42,56,1,84,187,107,23,180,73,196,213,224,132,226,169,140,11,144,238,142,238,92,141,15,158,137,154,40,82,170,249,85,23,179,165,184,208,49,178,117,253,132,55,0,90,178,71,194,103,192,19,174,235,17,219,12,144,233,232,164,183,125,74,165,42,249,191,135,171,161,158,143,131,147,146,60,179,215,111,184,160,43,253,17,25,182,158,115,100,100,139,21,126,86,232,80,229,4,225,186,175,197,182,200,206,123,63,205,67,53,119,160,50,120,129,245,47,201,243,128,22,159,244,17,167,124,85,190,166,76,99,236,12,103,31,197,215,76,205,181,34,227,109,193,134,36,136,194,255,168,11,102,41,159,118,154,232,152,53,133,144,79,209,124,255,231,150,9,221,48,110,97,131,8,18,187,133,144,42,51,200,219,57,64,112,85,62,222,2,43,26,24,114,242,163,167,211,17,51,82,106,160,235,39,229,21,153,67,241,13,89,24,172,169,141,239,208,200,90,12,6,46,169,208,76,163,144,15,79,110,82,195,198,83,155,140,18,102,148,203,110,45,94,102,112,60,182,178,156,164,52,21,5,2,111,161,31,99,233,247,58,188,225,210,243,76,95,167,37,175,2,219,70,199,70,205,16,20,57,128,204,180,17,49,103,119,78,131,88,156,250,191,3,51,34,153,169,209,142,79,96,73,62,207,0,114,212,30,78,247,68,219,193,75,225,143,234,206,148,46,159,39,161,105,134,97,204,1,214,57,141,94,122,143,157,228,235,30,231,131,167,217,180,160,0,146,198,246,127,13,138,244,145,138,244,135,102,228,104,171,39,171,41,31,7,72,231,230,177,45,255,151,93,169,126,213,125,124,217,212,12,252,144,182,98,55,58,84,50,136,209,57,101,219,225,104,66,6,167,166,14,37,152,30,12,94,33,9,36,130,191,105,193,202,1,69,61,181,136,47,143,211,109,56,142,225,225,237,24,254,160,183,45,225,80,17,21,149,186,41,11,185,48,213,129,164,96,120,36,149,78,71,169,35,21,134,142,206,7,76,22,151,93,246,4,225,53,252,120,174,50,195,254,138,214,52,234,137,220,171,14,68,84,124,209,205,166,1,123,243,94,142,116,232,78,240,192,186,47,66,186,65,122,213,168,118,220,36,21,76,81,99,70,196,125,104,231,31,225,0,122,18,150,0,157,39,133,42,187,78,97,36,167,155,14,9,25,36,155,223,48,55,202,229,253,114,64,48,148,93,208,80,29,154,166,28,126,25,26,80,156,15,32,56,238,59,52,107,7,36,211,109,12,142,26,175,37,70,73,165,208,220,20,185,96,127,115,238,29,54,253,217,140,202,69,190,107,120,213,184,175,253,176,150,42,121,157,212,99,124,159,164,136,38,109,42,38,253,194,107,130,85,179,248,21,83,252,168,78,47,53,111,19,112,116,228,169,54,164,123,151,246,216,183,136,84,19,181,110,65,83,108,183,241,173,219,96,178,119,135,12,209,156,63,83,180,168,251,212,109,44,157,35,232,67,18,28,75,181,136,135,253,190,221,129,129,132,122,40,127,123,237,164,179,223,155,51,21,35,140,138,179,92,94,84,111,29,2,241,39,58,183,97,86,63,167,159,236,94,100,14,1,107,154,246,29,94,122,80,135,188,255,139,54,2,46,150,166,85,155,98,86,99,147,126,98,191,186,198,179,62,216,54,99,10,192,131,131,68,63,224,167,194,223,70,254,122,65,175,238,236,208,203,44,186,91,226,131,207,166,226,208,88,154,23,170,177,63,124,107,123,106,169,243,87,181,112,185,71,3,159,137,152,240,80,12,215,124,209,81,173,173,56,168,233,215,168,244,175,215,98,235,15,104,85,217,119,231,157,82,33,102,20,74,19,152,169,194,110,145,78,236,80,67,102,9,8,96,172,160,33,127,68,241,221,7,187,100,253,181,143,10,254,176,209,79,12,109,96,240,5,38,126,46,87,61,27,49,38,72,180,207,145,200,75,235,192,226,42,191,247,92,41,1,204,201,130,176,34,161,189,142,253,4,105,94,16,71,222,19,102,147,66,29,7,127,38,166,113,130,12,191,241,178,176,95,158,249,238,129,210,216,160,198,237,138,32,143,67,106,39,255,171,123,161,151,252,29,249,236,104,27,41,122,199,55,180,78,50,151,90,244,142,156,151,1,153,250,142,247,169,81,202,193,184,109,59,133,135,21,179,83,87,48,230,123,29,103,145,181,86,123,110,14,230,74,40,44,69,235,42,186,125,174,135,94,210,56,240,44,195,217,93,117,93,151,86,167,100,189,103,2,167,14,69,108,158,114,146,138,241,185,117,164,161,233,165,17,92,58,10,240,241,71,10,189,81,145,148,190,207,218,130,128,195,229,233,113,81,49,250,109,191,70,149,36,42,2,214,118,130,114,25,7,18,47,173,49,208,68,56,106,30,246,131,14,121,108,197,168,211,64,56,245,5,155,72,133,241,197,157,75,98,3,11,58,216,186,225,101,174,174,92,69,170,5,149,23,148,207,96,12,66,42,252,100,156,240,163,95,15,60,24,232,194,166,148,21,110,59,152,217,4,115,255,102,87,142,133,225,176,201,136,162,99,210,212,155,31,225,65,115,94,127,71,18,167,75,201,108,225,242,47,209,189,109,160,180,86,108,25,146,133,26,241,79,77,205,202,225,1,92,90,73,18,207,62,214,240,148,78,194,17,189,159,130,15,165,48,7,17,133,78,241,91,100,250,201,140,165,88,202,192,146,4,230,58,179,101,99,178,35,70,223,118,192,14,36,98,45,230,188,28,102,249,145,45,178,217,236,100,183,84,81,24,44,127,123,5,27,109,153,225,87,210,229,205,189,194,197,117,80,92,220,40,0,213,61,9,59,160,234,211,169,126,79,135,161,208,229,123,5,5,192,171,231,234,125,212,233,112,55,95,40,130,238,182,91,0,239,2,225,107,218,79,67,159,223,108,253,219,80,45,187,64,255,9,114,152,224,66,253,179,65,122,174,226,31,147,154,167,81,246,203,162,110,173,212,219,150,45,156,100,4,90,125,235,93,220,85,62,40,117,99,80,119,97,104,224,35,148,112,123,159,59,148,143,77,12,212,184,2,12,236,12,116,60,237,38,216,230,233,103,43,192,55,2,100,60,223,245,75,246,196,107,211,64,87,79,54,221,126,19,157,168,163,201,155,215,115,137,171,30,196,2,249,51,137,104,103,37,124,93,92,93,241,178,245,151,140,46,113,101,60,10,234,51,100,26,223,202,154,184,159,30,200,25,206,5,112,37,192,143,81,48,205,186,121,238,92,254,151,12,164,118,235,89,61,214,205,52,138,30,196,155,93,44,175,183,163,237,248,26,121,8,233,36,84,43,192,49,90,173,146,7,30,105,143,193,59,176,249,151,135,97,182,109,13,141,178,41,46,5,58,229,36,159,141,97,8,245,78,203,192,80,45,132,31,74,116,212,136,88,196,69,113,123,218,125,235,168,243,203,3,189,110,120,76,109,87,151,85,162,69,54,190,50,236,147,215,126,67,65,213,253,240,74,40,184,207,84,246,7,150,249,9,131,176,160,235,210,154,141,93,140,148,231,4,56,82,56,209,36,213,45,68,58,253,160,129,66,220,177,236,229,233,112,25,112,35,13,167,119,75,194,166,110,100,90,216,150,226,189,194,133,144,75,38,19,218,47,219,231,68,243,22,156,130,203,115,208,136,8,5,101,2,160,141,228,4,157,203,82,29,18,92,199,70,130,204,0,84,49,92,190,91,246,223,97,155,85,213,45,81,51,143,113,243,69,29,141,122,233,178,69,133,215,133,146,73,184,136,209,106,109,202,236,240,57,118,235,121,181,15,88,178,126,146,184,226,1,57,28,104,172,26,116,231,187,10,194,248,206,155,230,173,15,46,8,147,98,58,97,148,43,244,64,132,187,38,148,144,183,197,145,92,124,199,142,47,112,106,223,177,228,10,183,230,87,5,247,202,92,63,214,59,84,35,78,35,121,227,38,86,45,237,114,183,49,188,150,238,151,245,40,188,174,150,165,118,59,201,235,18,214,179,228,184,116,58,193,53,217,73,18,116,24,223,115,194,235,47,151,233,170,166,95,209,71,61,177,25,95,2,75,221,11,150,153,118,246,151,35,66,55,138,57,130,105,181,237,94,193,246,118,67,138,154,29,183,218,193,78,163,23,42,64,29,143,234,83,251,224,107,40,151,227,198,224,213,194,86,104,35,40,54,57,22,128,131,221,75,83,139,98,101,152,99,47,191,112,212,238,148,227,187,28,196,56,207,172,56,85,27,13,171,33,61,234,129,6,154,113,109,180,42,219,96,235,59,57,5,241,182,203,189,212,59,138,58,17,136,129,237,54,9,236,144,154,251,208,79,112,117,198,25,10,115,67,79,55,132,46,2,83,206,32,228,161,118,31,232,69,134,85,102,205,73,230,42,202,82,7,96,8,12,41,91,157,60,196,20,7,207,57,45,128,5,243,139,106,85,20,235,188,234,197,5,219,171,245,173,173,159,116,73,68,221,140,54,138,169,51,71,20,154,133,181,45,110,232,6,37,158,73,149,181,143,19,47,162,17,68,135,79,64,115,39,49,176,47,34,124,44,130,129,35,148,28,157,82,68,169,239,191,77,103,18,45,196,153,37,199,31,11,119,250,211,110,48,234,204,231,184,122,217,218,134,219,94,121,65,213,71,28,48,9,71,203,6,137,224,153,79,229,53,235,27,28,178,99,46,36,223,155,22,60,137,232,102,167,254,233,228,178,157,47,27,107,128,177,169,209,105,205,225,124,50,132,230,240,84,80,211,43,205,211,9,172,253,242,252,4,53,214,89,96,195,43,101,115,77,149,77,176,216,138,151,184,233,195,106,228,166,57,93,187,62,112,157,227,36,135,93,52,148,201,123,131,81,47,127,118,2,10,74,221,110,228,245,203,108,103,81,231,73,98,69,240,236,15,112,93,176,17,232,49,176,125,219,173,147,92,253,160,19,63,235,114,69,16,8,54,119,255,197,118,208,36,179,162,75,100,99,205,81,84,51,211,159,78,128,0,74,128,250,47,116,13,251,121,213,6,64,46,201,225,204,194,243,189,90,7,212,148,170,52,9,154,52,152,155,145,189,106,247,30,171,253,19,36,28,84,43,65,61,63,209,229,167,225,189,59,131,123,161,217,239,14,68,203,204,202,31,233,229,184,111,40,216,87,114,32,254,86,187,97,141,236,219,213,167,55,4,19,40,166,184,181,244,118,165,180,210,226,131,30,237,4,211,217,149,218,0,181,129,210,115,77,106,244,183,54,227,152,235,224,86,180,119,222,227,65,161,191,118,137,205,233,166,73,67,78,176,247,180,27,18,176,34,129,117,30,187,166,117,158,37,95,83,142,17,28,79,221,25,212,133,161,213,45,80,102,231,166,151,18,188,249,108,94,29,178,224,39,67,29,45,69,85,66,46,229,29,235,220,130,234,88,206,38,170,166,23,121,114,103,235,108,200,208,195,133,136,1,77,27,210,77,68,161,208,177,222,65,17,23,219,209,85,234,233,159,144,97,148,156,186,162,151,224,154,249,250,191,46,121,171,23,178,55,64,198,3,34,109,227,24,70,135,112,131,250,216,231,229,118,180,98,249,20,239,97,245,154,231,205,183,198,149,200,194,191,211,172,102,50,76,235,80,127,36,206,67,82,250,49,114,72,230,54,79,30,184,248,22,168,222,180,129,202,23,83,190,195,147,67,13,116,245,235,109,85,22,238,72,44,92,241,157,166,13,169,120,64,58,0,220,90,53,23,128,158,198,153,240,36,39,96,229,28,67,187,43,254,35,44,187,169,252,205,22,201,246,140,118,229,31,33,51,170,155,254,72,236,228,62,184,136,222,214,202,149,158,1,122,160,124,72,222,72,81,228,252,137,205,216,201,201,92,91,57,80,210,27,104,65,124,214,227,164,201,40,137,82,94,11,202,28,114,214,91,148,98,159,186,198,204,124,4,176,105,112,189,25,45,64,50,61,180,166,117,137,54,175,181,203,227,124,18,133,93,70,175,136,203,58,125,6,189,47,240,42,243,246,106,139,239,66,13,206,175,239,154,241,169,2,253,245,88,205,118,94,26,171,221,34,48,80,183,173,114,152,232,219,198,108,233,223,193,138,163,199,129,145,46,245,221,12,175,8,215,75,100,61,143,70,222,70,167,193,62,81,59,100,209,115,150,238,175,125,187,85,189,106,24,142,229,168,129,200,232,179,94,206,76,20,1,138,16,224,81,110,33,113,29,221,218,204,135,30,92,135,162,104,43,48,205,171,112,106,161,240,56,5,117,199,200,86,0,13,207,50,95,23,200,19,19,243,230,19,216,69,253,217,5,47,146,46,207,108,65,86,185,53,41,32,220,134,154,97,244,126,233,140,198,190,43,117,118,235,199,111,229,122,192,206,60,215,220,170,173,167,206,14,42,239,242,157,109,209,229,38,231,239,17,89,79,57,26,217,51,92,54,173,244,55,123,21,197,68,14,142,46,30,166,203,50,117,118,190,49,166,211,22,212,247,148,134,62,58,239,100,168,194,170,74,146,100,174,179,248,31,190,119,229,174,199,230,92,27,144,150,96,195,43,81,41,95,71,87,249,126,182,151,60,140,167,183,88,44,196,29,207,194,10,236,72,237,65,16,146,9,246,16,6,118,176,115,243,178,36,231,126,165,185,202,127,15,94,115,36,131,216,94,176,130,207,94,83,186,208,113,66,234,227,170,107,155,228,224,64,175,48,163,159,177,59,192,207,165,221,233,174,64,98,3,249,153,120,158,253,240,179,207,6,15,171,178,51,14,168,168,142,141,147,138,4,177,121,111,39,251,131,170,226,237,79,179,35,63,9,1,51,197,213,160,85,111,204,98,194,237,43,43,98,168,42,79,133,7,101,220,151,3,19,146,144,89,238,209,236,218,44,54,7,52,203,49,28,25,249,240,101,226,121,207,67,38,250,23,137,114,224,209,70,229,210,42,122,149,81,240,254,52,205,149,1,239,117,232,54,97,75,54,95,104,67,163,238,87,114,37,190,128,74,29,91,244,146,89,5,71,163,56,253,160,2,79,147,221,17,55,135,5,101,108,52,149,191,162,72,219,141,4,6,77,243,233,114,85,148,40,128,42,89,78,20,114,103,71,179,142,180,225,110,119,26,83,77,217,198,154,118,83,87,180,179,244,187,188,145,207,228,155,83,251,5,230,5,254,121,14,115,0,35,33,113,53,198,102,58,200,130,190,159,174,96,50,94,44,204,134,110,211,119,78,143,8,158,72,244,249,165,118,216,19,53,234,123,75,96,118,42,7,164,112,6,103,128,188,69,154,180,150,107,157,123,94,63,16,159,202,173,67,189,153,209,158,99,164,138,255,138,110,59,243,254,166,8,213,234,140,1,179,35,12,127,171,112,56,240,53,6,238,2,58,104,4,146,182,25,160,202,210,130,153,124,130,81,212,220,228,146,218,179,74,39,245,76,86,118,9,175,252,69,222,35,109,150,35,145,127,33,14,196,123,136,80,158,84,57,34,152,137,100,158,230,179,129,143,85,77,222,56,5,201,165,23,252,224,107,4,71,45,129,200,157,110,117,228,175,153,148,38,97,197,92,197,66,13,73,147,130,224,239,97,170,119,120,169,142,219,12,191,188,48,71,115,183,184,132,244,146,101,158,61,213,14,36,240,109,48,22,162,117,4,88,199,222,143,139,217,137,109,230,27,252,180,100,35,251,162,210,121,21,51,119,159,87,142,87,123,211,125,30,177,191,95,254,224,50,16,249,27,214,193,207,27,163,103,224,237,62,64,157,49,128,240,161,34,185,246,103,205,4,117,187,172,196,70,127,180,243,218,98,15,81,108,247,70,85,166,81,32,136,210,64,210,160,202,222,90,160,87,106,182,72,219,10,144,19,124,14,134,209,91,18,115,89,189,246,185,182,220,221,86,17,137,46,230,61,90,120,236,250,40,26,166,6,166,75,158,164,95,178,50,134,196,41,97,157,208,115,43,176,9,93,10,180,208,191,0,141,39,91,51,230,132,195,44,25,44,232,121,241,204,234,107,96,190,189,24,21,145,86,201,238,112,21,129,89,123,125,180,210,223,136,187,100,25,166,145,88,210,35,43,128,75,55,214,100,157,73,251,62,97,209,206,244,25,151,8,178,64,230,160,33,85,221,166,173,140,166,38,201,198,5,41,190,233,133,113,26,251,235,199,249,249,79,97,75,35,161,142,138,55,154,161,49,134,228,50,153,98,237,76,148,231,143,57,123,67,123,2,46,185,29,255,252,112,50,158,145,39,38,40,98,109,196,25,245,6,76,227,98,151,81,23,247,149,234,181,207,97,226,176,201,128,2,211,248,53,194,223,197,201,39,167,141,141,167,38,35,167,170,203,238,204,202,253,175,246,4,252,64,167,99,151,137,215,193,102,30,156,71,226,155,242,35,107,108,115,58,40,53,119,15,14,48,90,96,78,221,138,195,225,9,55,207,223,59,184,180,196,38,244,96,2,205,84,57,114,149,23,147,86,228,251,14,54,113,246,237,232,113,65,178,77,108,164,66,249,110,119,110,64,156,90,8,26,148,53,30,141,167,11,154,30,102,251,171,119,13,74,176,47,153,161,254,2,174,88,245,232,250,144,156,230,114,227,152,198,70,237,161,202,31,30,23,185,175,67,54,110,145,121,5,73,13,132,27,250,4,211,189,27,204,93,209,64,209,33,159,89,200,152,242,208,125,15,177,138,85,21,38,99,93,89,165,111,184,252,69,163,210,21,95,9,0,142,35,52,113,104,192,149,8,34,251,34,138,86,163,184,150,30,12,244,66,240,217,101,6,81,225,79,129,63,101,109,44,112,213,213,191,34,55,90,65,84,35,156,11,43,18,154,20,102,202,127,167,21,50,143,2,226,4,206,5,121,16,181,42,86,46,227,230,50,118,120,114,134,173,229,15,49,212,208,123,85,215,33,84,52,161,237,29,87,84,215,74,96,10,140,217,172,107,109,60,148,182,129,239,203,72,65,151,72,145,160,13,240,184,139,182,221,68,251,245,175,22,118,106,253,121,195,27,184,130,234,184,252,237,136,208,210,83,64,200,143,70,188,241,87,33,183,97,166,24,23,34,60,95,137,20,132,155,59,54,151,42,121,68,91,99,142,131,57,252,235,51,181,6,179,38,4,6,1,136,152,231,154,109,200,41,234,61,22,222,84,183,160,208,67,158,166,80,0,120,129,181,1,179,143,24,205,217,236,238,82,139,147,232,162,104,14,217,207,43,4,131,30,41,58,28,48,152,113,182,187,76,7,27,134,130,1,179,24,5,193,36,74,171,69,128,2,191,89,236,111,4,248,164,48,167,53,79,255,225,5,51,100,55,121,124,223,69,148,173,32,121,46,206,137,60,47,96,243,254,96,97,165,190,199,0,174,234,66,136,136,22,95,67,114,203,128,152,104,14,153,37,137,240,26,189,223,170,123,154,223,57,77,44,250,128,131,72,59,52,144,119,57,69,97,71,233,208,76,26,163,236,135,178,204,73,113,38,9,24,144,215,46,35,155,58,42,215,124,245,226,58,77,23,161,213,192,22,36,155,134,98,206,6,234,202,101,198,175,235,91,33,84,45,98,24,159,95,115,165,60,32,218,158,173,93,149,224,69,235,59,95,184,73,220,211,2,121,3,62,194,15,150,28,224,219,80,67,80,94,251,176,10,36,221,9,64,55,156,144,80,197,186,231,91,174,169,112,235,3,154,37,117,42,25,87,120,174,21,211,165,124,236,174,105,192,55,76,165,78,148,226,88,75,31,168,195,28,147,33,169,165,226,162,49,81,98,219,204,199,12,122,13,186,83,144,167,67,83,188,6,249,86,143,245,50,209,175,84,188,253,244,95,88,106,230,186,108,232,77,64,240,43,223,40,227,204,193,29,160,228,168,213,62,249,179,60,155,152,67,171,137,129,138,30,179,7,200,183,171,8,10,188,160,206,254,0,53,70,47,62,115,121,223,48,42,211,240,51,122,75,109,4,255,98,148,3,100,13,1,202,134,211,235,101,59,128,220,249,66,71,152,162,225,41,43,213,221,122,189,145,237,134,33,77,131,148,215,123,190,233,60,222,81,83,173,81,42,76,160,76,200,87,161,161,147,153,33,255,244,122,158,21,218,202,153,199,161,30,181,227,213,227,50,90,220,19,249,15,50,75,213,137,235,237,95,64,209,30,172,233,98,78,223,92,206,156,116,156,176,99,111,126,225,201,143,141,224,121,223,31,139,20,43,116,39,236,130,232,80,30,76,102,28,53,68,231,73,107,174,67,111,201,246,228,254,98,2,118,85,243,6,112,127,67,120,70,126,44,160,136,3,1,118,221,76,222,72,168,81,113,135,87,204,65,43,87,120,134,252,254,32,166,71,225,0,45,230,173,175,128,80,133,19,229,1,73,206,248,1,77,18,120,49,121,145,179,18,253,170,114,225,138,167,123,1,54,30,86,129,79,179,44,14,184,49,187,173,109,204,247,161,207,253,131,117,130,42,26,60,126,172,110,58,72,188,127,220,93,36,98,3,163,73,135,87,20,69,40,26,84,52,166,137,48,121,162,88,47,59,99,157,157,67,95,183,22,13,12,219,86,122,254,230,178,163,67,236,237,128,21,137,110,131,129,5,213,78,107,77,157,34,253,189,0,245,54,99,175,156,184,241,34,208,17,27,143,231,154,92,205,80,89,142,58,126,158,19,174,16,82,237,76,82,108,105,142,50,127,8,163,17,75,23,30,246,111,234,101,72,7,151,137,95,54,247,211,62,239,172,83,171,53,160,216,19,95,225,122,24,32,214,20,107,90,130,130,58,193,112,238,155,222,56,234,46,39,73,17,47,107,150,133,32,166,113,130,153,237,138,211,144,171,208,90,50,186,53,72,2,25,104,104,140,63,156,98,48,161,69,119,152,95,21,103,15,138,71,58,83,227,158,81,225,211,231,120,169,25,98,212,36,153,115,19,224,114,27,252,78,95,52,35,28,68,160,199,130,179,14,173,208,191,85,184,176,69,248,35,85,13,64,111,28,209,209,98,130,159,214,60,107,149,89,25,70,80,162,116,131,240,45,220,134,108,99,191,241,20,186,171,98,107,174,114,14,83,90,134,53,221,39,28,240,96,165,67,118,218,133,250,149,186,251,111,0,252,45,184,203,117,218,197,242,65,232,117,177,247,63,9,100,56,73,60,90,191,103,196,240,217,99,72,97,142,24,167,155,135,240,21,26,49,81,169,105,91,51,63,133,141,169,52,233,243,204,83,51,178,223,24,239,113,206,23,115,179,205,132,236,196,87,116,158,54,198,39,208,86,99,35,238,167,138,152,13,238,124,114,161,175,61,136,253,5,31,151,155,248,239,121,83,43,176,101,235,24,63,103,23,253,234,16,35,174,145,122,99,149,186,231,89,49,183,14,149,31,142,216,32,148,128,252,26,79,113,253,145,252,178,141,200,209,58,131,200,219,32,46,34,111,200,192,107,120,135,123,16,189,88,108,60,141,58,17,206,115,120,66,167,33,143,60,9,242,84,1,111,234,199,137,177,143,231,170,89,61,167,89,57,237,254,130,247,77,73,40,45,29,43,175,158,133,221,153,80,99,219,123,254,45,193,11,195,89,21,154,88,64,241,169,118,43,119,172,202,123,133,75,80,24,194,85,86,6,30,23,159,58,127,7,151,177,211,254,89,115,143,45,49,34,204,99,225,73,63,171,156,33,252,187,165,6,135,249,53,90,13,49,148,172,190,177,179,10,200,126,89,44,97,190,113,14,47,204,8,21,32,179,153,58,0,79,124,64,191,204,236,95,57,96,4,123,201,14,211,238,153,231,171,12,235,57,254,9,30,233,252,36,66,236,139,61,40,178,207,102,168,85,148,66,228,35,8,129,194,114,150,111,105,134,219,188,222,47,8,231,224,9,115,237,128,20,21,83,223,176,116,3,246,196,209,124,122,110,211,110,169,182,72,118,187,152,57,197,94,156,80,85,241,25,244,66,214,63,150,68,149,41,100,110,42,221,237,115,148,131,13,52,138,155,84,7,41,179,144,126,160,192,218,82,182,154,126,65,151,171,252,177,94,3,94,238,167,0,244,126,74,125,5,51,108,133,210,132,84,233,165,127,55,108,23,180,66,36,134,47,224,155,177,52,206,102,134,13,39,177,146,12,143,211,164,97,58,60,115,82,11,228,13,207,67,100,208,10,195,138,163,245,185,74,152,196,98,205,254,198,29,152,107,33,41,59,36,62,38,170,149,228,33,244,4,5,216,141,88,50,20,119,63,148,76,208,16,222,179,252,213,59,193,93,243,225,236,66,250,4,217,243,4,179,244,205,145,127,43,237,207,76,77,242,242,77,93,214,137,37,27,246,199,251,19,161,30,112,7,78,229,103,208,145,111,227,68,228,239,210,205,35,185,31,108,103,207,49,23,130,227,169,25,129,157,255,183,46,121,234,70,168,159,36,11,180,131,58,40,153,62,114,160,219,16,123,25,166,143,189,123,42,230,137,130,235,206,169,97,133,71,160,102,186,4,138,11,143,224,187,148,82,137,82,185,127,125,243,75,146,146,117,175,6,60,79,189,184,189,85,117,211,229,44,135,72,137,28,151,127,122,50,231,251,104,15,195,181,216,88,132,217,113,243,116,87,20,166,242,224,81,82,106,176,33,168,245,106,168,58,108,34,100,5,223,69,240,180,119,109,133,240,75,253,137,201,248,195,91,220,27,17,108,56,148,86,195,234,113,178,175,129,227,23,173,71,102,53,155,229,73,65,30,208,204,147,159,63,173,14,113,41,245,178,214,216,205,48,104,81,73,184,217,16,239,113,156,112,165,90,148,204,228,192,88,142,73,114,106,56,30,45,34,48,112,89,72,69,214,161,111,194,184,60,82,16,126,11,188,45,2,251,244,126,17,71,141,44,117,12,43,134,184,205,192,139,188,122,0,171,195,230,238,214,85,75,184,226,72,133,235,249,164,16,193,198,248,150,20,215,235,190,104,34,249,18,115,84,68,31,99,90,1,219,85,168,33,53,41,100,102,236,19,143,209,241,179,112,124,58,62,182,64,74,158,232,130,101,0,219,160,2,226,201,152,56,42,8,108,56,36,96,214,206,226,10,199,148,79,33,17,44,89,41,151,102,208,6,174,127,98,199,251,37,144,39,78,114,9,248,59,97,12,87,121,46,160,140,131,130,115,192,243,66,137,23,247,81,212,134,17,74,214,252,185,182,114,170,233,140,33,8,229,49,228,223,76,139,24,248,80,33,205,108,32,236,194,211,74,197,253,136,101,56,173,114,72,49,6,112,195,18,122,108,53,28,103,42,106,34,254,245,250,232,182,230,190,222,222,33,102,171,99,255,87,74,172,58,31,148,189,72,135,145,123,23,78,55,194,115,41,206,184,125,181,109,173,77,185,163,73,97,80,99,2,38,61,202,122,65,201,25,194,181,199,147,246,73,239,248,3,126,124,153,213,49,220,58,221,245,138,161,35,69,130,225,147,176,252,201,252,216,52,104,39,51,197,234,151,116,5,58,110,10,212,51,234,94,46,8,245,83,111,71,142,108,225,225,134,188,243,43,176,181,228,58,109,10,171,237,219,143,249,252,170,119,91,188,79,158,197,84,55,207,207,31,174,117,137,223,250,219,0,66,212,157,229,68,131,39,182,32,88,150,217,251,105,210,222,54,26,103,25,29,2,184,209,208,101,67,43,85,52,86,205,230,111,19,253,66,181,54,180,61,139,208,195,203,193,109,219,11,205,65,101,227,9,203,78,79,184,3,11,212,113,248,225,117,20,184,129,202,63,155,252,84,141,159,245,174,43,206,69,139,29,1,95,196,30,104,94,211,44,111,179,23,44,169,98,224,54,49,41,234,228,63,85,195,193,22,37,78,98,123,235,207,180,210,51,195,191,136,243,149,39,121,24,234,192,178,47,96,252,77,214,198,59,42,198,186,171,95,108,143,255,21,169,14,197,132,48,136,211,198,80,206,167,145,42,83,161,240,249,109,88,193,116,213,127,71,1,216,232,184,20,118,78,13,42,244,148,101,106,241,187,170,236,114,116,35,195,15,231,157,148,94,47,160,122,32,26,82,11,55,22,16,4,104,42,191,185,46,91,64,55,196,151,33,134,28,64,126,139,240,252,79,98,59,166,5,222,221,141,3,233,139,176,172,208,98,238,8,117,205,54,20,114,45,192,194,15,179,169,130,115,136,242,238,167,103,122,255,128,11,242,126,7,107,133,95,220,34,13,200,99,78,165,158,207,244,109,223,64,3,255,13,93,121,203,243,100,174,135,46,248,108,73,28,227,9,242,172,182,197,120,254,8,15,166,128,145,228,45,39,15,168,61,177,225,119,107,5,13,152,52,90,129,21,53,30,49,77,10,246,53,166,102,202,136,145,204,216,104,89,99,77,246,221,68,10,13,55,31,83,153,177,58,68,116,2,60,103,216,190,126,120,240,25,177,85,211,54,96,48,179,246,75,235,57,210,73,164,226,195,100,132,225,33,67,237,217,247,21,227,20,8,40,93,54,209,150,188,58,41,206,30,209,151,22,126,64,253,78,186,149,183,239,132,58,29,50,219,1,236,67,25,173,112,203,208,161,200,201,165,65,137,198,131,65,183,108,59,200,189,249,179,180,94,166,178,251,183,34,91,217,234,151,129,158,125,130,197,254,221,111,91,233,54,86,244,14,198,166,204,58,137,157,17,35,110,86,214,36,9,1,54,167,28,188,90,98,230,37,229,184,236,30,42,144,134,68,31,166,203,48,218,85,167,181,15,57,244,15,15,164,157,7,181,234,216,40,36,140,96,157,155,197,197,51,79,170,204,198,142,127,124,104,177,194,191,170,76,182,107,250,45,18,78,12,109,152,145,72,215,224,221,217,97,116,247,57,33,16,0,229,7,24,220,248,75,174,191,37,35,76,118,135,116,12,211,242,214,180,81,42,159,73,146,140,128,243,195,59,6,53,107,11,177,11,120,118,2,69,82,83,144,43,147,81,222,96,199,160,196,246,114,254,86,224,99,135,201,12,38,37,86,119,97,165,243,82,183,195,205,200,110,187,96,186,102,166,207,252,162,127,5,140,138,182,244,99,5,75,177,91,123,113,209,157,33,190,176,235,150,139,45,239,92,159,232,188,140,100,232,244,11,206,10,141,100,172,125,88,25,86,11,155,71,4,93,164,6,240,192,219,230,40,206,220,110,15,190,108,214,111,237,1,229,89,1,78,133,197,185,123,125,175,28,114,44,82,219,225,31,59,252,106,7,172,59,129,43,196,195,219,134,66,230,87,182,163,94,82,166,150,213,227,46,221,248,46,250,145,78,74,164,224,177,106,208,20,40,176,13,147,212,198,44,192,132,146,206,58,110,189,105,207,224,102,216,103,181,65,167,73,77,252,140,30,143,5,114,182,116,26,19,153,60,63,42,245,172,111,224,64,6,13,20,38,8,148,91,77,210,108,172,129,77,62,201,129,250,201,156,181,107,202,175,127,198,14,202,138,250,146,200,181,57,24,166,185,225,173,123,185,17,84,96,202,204,115,175,148,194,254,8,32,99,95,251,105,81,45,9,225,236,241,212,83,38,91,131,47,199,51,107,103,3,39,183,38,4,72,21,93,195,204,87,205,206,248,170,246,172,128,218,180,46,194,72,115,76,111,75,130,54,58,110,87,102,8,229,237,11,147,196,132,76,166,254,203,44,4,90,108,224,45,49,233,250,203,227,178,162,6,208,140,155,46,83,26,115,159,216,176,204,110,253,152,211,41,246,82,1,83,99,48,8,193,216,197,156,126,78,35,155,121,211,106,222,139,253,214,66,1,133,75,161,211,222,86,82,173,21,209,124,233,253,21,107,194,192,222,155,215,102,163,77,86,162,18,109,191,93,34,28,185,218,41,46,198,212,131,64,246,27,138,190,50,190,219,47,25,55,171,225,219,148,143,166,83,177,208,17,215,68,167,16,224,211,225,77,130,9,243,173,78,228,86,130,170,65,214,51,241,99,60,162,41,39,29,226,146,70,16,136,20,250,78,222,64,101,188,235,80,161,225,104,227,250,79,230,243,224,172,229,254,71,236,194,29,146,166,160,29,173,151,227,14,67,111,74,111,28,145,100,246,109,71,173,14,123,190,21,226,194,249,146,100,75,214,65,128,50,112,166,134,134,213,7,186,212,1,92,175,100,40,62,153,238,217,115,159,184,15,175,193,7,129,108,240,15,175,109,69,51,218,232,184,149,188,238,99,10,248,160,26,59,13,210,41,14,222,60,21,234,148,87,141,74,232,19,3,169,184,122,58,104,14,217,75,101,13,13,202,67,164,63,218,64,40,48,39,95,86,8,33,78,187,39,114,114,225,147,226,168,109,159,194,135,169,29,65,162,151,186,255,56,220,206,247,1,89,125,119,76,181,89,213,36,61,8,177,233,100,90,60,229,106,144,201,174,56,83,106,66,214,61,162,249,26,203,144,198,234,104,12,157,213,49,247,169,120,88,227,67,57,236,0,85,77,136,250,81,6,41,108,184,5,230,144,45,251,81,123,70,194,38,9,53,84,25,51,194,243,234,121,104,110,56,5,1,37,253,76,72,193,41,40,48,75,140,120,61,120,14,242,11,51,218,77,106,5,137,83,236,242,62,50,252,253,47,237,47,69,59,107,18,21,29,165,159,39,253,249,127,247,95,208,190,42,117,64,170,131,236,255,89,72,160,196,247,63,180,141,78,14,130,210,95,26,132,188,119,157,216,89,32,43,153,78,62,59,237,42,0,76,8,117,139,93,201,236,251,52,48,69,189,44,130,72,82,118,170,147,118,22,165,48,116,220,178,249,255,136,27,201,88,97,139,103,255,64,59,89,38,36,135,79,192,45,84,42,194,7,162,241,15,226,116,125,224,1,18,178,137,88,139,179,131,46,165,84,112,168,116,177,254,20,139,150,195,87,155,119,20,64,173,237,123,2,178,143,181,214,172,188,114,53,117,23,52,225,249,141,240,189,65,238,18,204,145,72,20,120,96,174,58,182,72,129,58,135,123,67,152,138,193,176,133,114,18,37,187,215,253,144,211,95,82,8,149,70,133,83,206,21,168,62,232,116,89,36,225,60,139,79,174,81,112,71,92,181,217,48,110,9,149,140,35,122,1,62,242,231,243,189,247,77,171,106,188,159,2,141,197,43,246,68,43,48,25,124,167,27,203,217,33,28,38,250,200,235,50,99,99,235,187,193,247,3,61,191,69,21,209,16,164,22,162,37,88,172,11,234,91,158,182,36,30,205,252,122,83,8,46,11,116,229,212,54,179,135,54,138,124,233,23,155,137,123,33,228,77,29,149,240,185,71,0,195,83,208,95,27,128,17,117,41,69,75,118,112,25,85,94,146,133,82,34,141,91,156,100,132,252,60,129,155,28,169,20,184,147,115,208,43,231,169,231,139,14,110,159,5,231,133,94,213,39,38,99,149,214,97,182,247,125,78,251,39,75,232,209,86,34,179,230,231,145,17,252,245,13,121,52,11,185,58,167,255,160,34,167,122,88,56,33,28,131,144,209,70,210,8,14,78,214,188,242,139,60,97,191,252,191,154,111,204,188,229,226,144,76,230,112,189,154,78,8,236,203,238,198,240,155,173,172,148,136,202,214,118,242,162,31,132,75,249,67,212,97,145,134,125,230,255,59,16,20,180,197,198,67,16,69,58,83,150,183,242,76,13,17,228,89,199,75,228,1,42,153,121,59,20,78,36,203,167,229,9,222,97,176,228,113,10,205,155,88,77,115,164,234,155,204,150,136,179,57,7,242,110,241,237,138,166,15,172,146,69,12,39,254,155,43,183,80,132,168,172,130,36,116,68,99,242,5,199,95,13,89,30,89,211,43,182,177,199,233,33,5,90,147,67,111,154,214,129,7,120,249,235,246,1,247,228,85,144,61,209,50,226,60,229,106,225,6,120,120,69,144,250,129,158,27,130,116,166,124,82,40,196,61,125,213,189,175,128,22,97,178,19,83,148,64,181,104,47,196,134,84,176,235,145,60,89,145,181,161,78,76,157,64,251,11,173,93,36,118,147,248,99,157,40,65,98,98,44,146,91,194,130,61,170,232,232,66,228,251,186,247,62,238,42,94,4,117,45,66,231,209,49,98,35,216,75,187,249,155,44,230,207,181,201,140,148,64,25,209,151,134,190,58,164,251,88,225,189,122,208,199,92,86,220,191,98,191,71,230,87,154,162,158,161,129,242,220,221,128,123,169,27,189,247,137,130,96,102,115,198,161,120,164,240,176,125,252,226,253,87,132,201,158,16,3,147,118,83,59,157,163,196,5,231,198,44,125,25,198,253,221,54,33,126,75,83,50,1,135,62,111,188,49,169,0,23,90,13,149,200,129,198,224,75,100,143,117,26,84,4,89,171,42,102,136,36,248,214,80,241,1,17,113,19,210,29,5,167,22,80,220,228,48,215,150,206,54,42,188,194,25,163,101,223,240,60,137,136,38,206,186,96,96,90,75,98,90,227,4,145,174,225,192,158,135,60,90,170,140,234,82,244,46,253,213,183,17,127,87,139,5,192,46,222,121,169,38,46,19,27,17,3,85,132,183,168,22,16,65,68,77,197,140,54,47,58,108,232,205,79,197,139,158,110,40,159,230,111,150,40,217,140,22,209,206,64,52,178,60,223,0,127,237,130,177,31,24,171,98,82,163,158,114,248,95,71,148,9,144,112,154,25,123,25,230,151,215,234,248,170,218,181,15,33,144,65,155,148,57,115,55,29,125,167,100,127,157,65,119,87,141,175,141,179,91,93,198,37,162,142,189,214,162,211,101,77,70,166,207,102,56,38,76,124,167,212,99,47,174,43,206,239,214,26,7,4,138,105,164,238,21,176,1,192,70,229,58,57,41,73,28,153,186,22,170,30,145,251,100,235,73,151,196,229,120,209,234,59,69,142,189,165,177,207,106,223,128,16,31,151,115,162,154,149,103,13,222,85,83,116,211,67,40,25,74,70,96,160,40,70,161,35,44,55,176,112,49,177,157,115,96,252,61,249,155,66,180,47,170,185,218,13,220,230,83,22,108,64,109,201,149,3,121,74,107,219,17,250,195,125,225,250,65,148,234,63,160,50,23,55,93,250,210,79,70,6,221,209,115,205,25,149,51,198,166,233,88,248,112,220,232,175,38,86,96,111,25,132,254,187,207,199,66,200,219,217,196,9,189,35,218,80,186,173,41,47,42,53,66,79,195,224,238,55,228,138,42,209,150,149,74,228,217,229,79,120,152,188,57,192,60,148,102,65,104,179,4,205,95,88,65,107,86,142,167,185,193,9,14,88,162,35,119,57,254,122,235,152,189,222,90,94,115,14,33,211,141,183,89,30,181,231,20,181,248,234,230,249,253,185,239,45,92,57,233,213,220,201,57,44,154,240,75,112,219,8,244,83,80,45,161,176,227,234,19,82,157,202,181,216,17,161,63,79,209,61,199,211,88,81,43,223,27,179,49,4,58,214,91,116,6,148,167,177,56,183,171,141,228,85,218,34,152,193,135,235,118,210,63,126,96,162,12,219,198,204,175,2,52,191,154,73,126,48,113,223,113,5,134,232,236,13,22,194,83,212,112,149,158,79,169,230,141,179,28,181,11,4,83,2,218,231,14,204,138,163,169,229,90,111,148,128,104,77,196,168,227,169,16,80,95,123,248,145,194,45,51,184,84,66,162,157,238,154,77,152,104,72,71,55,85,86,253,145,181,185,239,7,107,168,58,168,72,186,98,37,124,32,208,132,243,155,200,46,244,131,158,232,145,195,97,72,218,176,214,193,58,109,230,151,189,72,211,22,81,8,106,106,144,183,64,189,255,31,219,217,169,253,131,177,175,10,151,254,22,123,196,22,107,62,98,151,102,92,144,116,129,0,77,186,37,127,175,142,8,58,162,146,162,147,60,227,123,250,132,51,84,189,247,78,113,223,108,160,227,172,59,87,207,208,225,125,125,250,194,243,166,138,126,131,119,120,3,10,226,20,221,213,68,233,116,86,45,59,58,181,93,95,140,147,210,187,169,152,207,100,112,11,66,78,246,234,248,232,113,32,131,107,39,44,205,142,157,115,218,88,36,184,186,3,54,86,15,190,220,215,198,214,56,14,120,92,230,76,75,240,216,197,236,104,127,205,62,127,168,254,222,33,87,229,39,99,104,8,33,3,62,214,1,37,80,150,185,46,161,188,219,211,58,197,138,82,2,83,70,85,12,50,173,168,144,25,96,234,30,159,151,163,87,102,230,129,92,29,2,0,98,240,157,216,149,113,109,153,146,185,143,250,163,252,64,152,245,120,174,203,121,37,116,45,67,30,4,120,235,237,102,87,124,212,38,117,5,192,17,164,238,152,2,14,91,162,41,104,241,0,36,235,172,139,3,30,201,58,239,108,234,6,126,141,222,16,41,217,107,17,140,3,157,14,167,201,60,193,52,34,65,108,127,238,182,244,165,3,242,120,0,105,189,233,79,48,84,206,163,228,209,164,217,131,226,101,42,98,105,158,100,28,95,6,185,226,7,223,239,171,199,218,161,184,72,90,92,134,16,178,195,214,99,109,149,6,131,229,36,172,10,43,167,86,181,194,29,143,124,122,221,206,129,96,119,174,203,232,177,30,94,8,245,144,249,106,245,150,241,153,102,48,126,52,52,164,29,6,113,29,244,123,69,89,66,43,111,35,206,145,235,75,223,35,152,232,167,210,237,204,160,65,90,66,193,140,203,15,75,99,102,158,67,250,90,36,120,169,168,232,158,227,29,252,70,200,150,215,43,89,149,47,88,185,11,18,159,109,54,163,89,219,162,142,211,80,183,29,37,155,61,54,230,164,39,98,60,61,74,75,255,232,59,241,223,222,37,131,12,230,166,116,237,71,52,173,37,183,106,255,144,232,19,250,129,58,31,218,188,82,7,149,203,142,142,179,93,0,235,164,227,20,97,195,153,48,159,225,203,58,143,182,57,255,192,197,44,5,88,50,198,9,80,251,235,66,96,189,64,21,57,122,71,120,64,26,110,61,131,42,112,160,141,193,187,155,18,203,223,88,164,152,212,220,247,245,237,103,123,14,253,163,125,23,42,63,146,30,87,149,4,37,18,108,240,51,169,30,136,225,243,200,247,104,63,73,24,173,78,148,128,0,61,170,217,153,108,85,133,233,20,61,122,81,123,57,187,209,159,91,163,26,45,3,87,165,220,151,146,110,95,137,18,131,112,70,179,175,243,215,45,18,192,127,107,227,219,242,91,82,67,190,30,192,240,88,134,148,178,44,130,161,35,99,41,93,3,172,215,115,16,234,141,228,204,160,242,88,90,74,2,63,227,93,29,172,239,21,84,26,185,217,154,69,37,160,31,117,32,101,95,116,13,192,42,14,254,34,96,233,98,90,117,124,196,19,51,164,39,33,78,3,120,163,36,152,123,253,185,230,128,237,174,18,200,21,42,239,12,13,91,38,144,66,67,181,24,148,2,20,97,213,34,35,74,71,33,1,162,17,190,30,9,27,9,162,242,122,33,169,105,26,182,102,212,21,168,210,215,237,146,169,45,107,55,141,17,12,11,170,160,84,168,113,127,92,231,41,40,250,4,87,227,136,164,156,25,149,65,99,88,99,193,198,60,185,214,72,174,162,179,153,93,51,138,144,169,106,245,78,117,85,217,123,100,15,195,104,107,213,161,141,211,12,48,84,170,78,244,253,195,59,245,102,99,181,101,249,128,74,19,129,200,87,8,203,252,188,175,194,22,241,62,1,189,8,103,4,85,46,192,195,130,52,4,151,10,56,7,230,248,87,241,170,99,214,128,131,6,117,10,135,255,130,188,231,160,227,68,228,108,113,192,232,88,138,110,240,206,193,194,68,211,51,72,140,21,97,73,57,52,215,175,46,9,229,167,192,59,138,117,6,177,220,102,148,237,109,26,145,46,55,190,111,188,212,181,192,227,182,166,82,134,202,52,76,191,119,132,135,207,231,125,200,45,78,103,127,104,170,63,240,3,0,34,153,176,35,19,157,206,60,29,194,9,78,194,99,37,211,191,158,52,100,191,200,85,180,163,61,83,208,77,170,181,84,15,255,236,120,80,91,24,247,200,9,196,218,112,15,228,148,245,247,70,229,39,207,205,216,144,58,16,33,41,49,230,155,198,173,242,226,247,95,14,132,126,36,204,0,2,182,160,3,17,73,251,45,153,207,61,115,39,93,91,4,180,6,138,181,160,126,168,136,5,150,17,252,154,203,33,166,50,141,181,174,227,235,156,178,179,197,221,252,210,161,74,136,220,45,255,66,25,35,127,181,125,4,211,237,243,215,18,67,35,125,90,146,50,253,129,249,116,233,232,80,211,9,175,219,167,216,218,208,132,62,221,68,148,248,28,87,186,162,100,59,131,105,43,250,175,156,57,3,176,44,5,181,216,66,69,101,168,2,231,252,145,182,115,129,246,203,196,54,119,161,228,100,162,5,119,223,195,154,5,45,79,178,209,123,123,100,51,14,224,118,5,83,5,253,155,40,134,200,118,97,154,150,112,67,178,61,205,13,200,203,119,60,233,108,245,218,7,57,4,209,173,181,115,149,127,185,46,141,37,27,50,136,89,38,145,109,120,92,12,180,116,4,106,114,44,97,36,219,92,208,31,16,190,44,194,147,11,194,89,174,218,28,50,245,117,241,32,91,8,89,132,186,119,184,42,157,105,70,30,53,119,9,84,132,215,62,115,212,82,101,110,105,50,189,170,112,180,56,172,4,128,215,129,118,5,156,195,157,56,72,139,66,254,27,105,141,19,63,70,140,237,83,170,45,134,115,173,35,209,41,142,126,159,141,101,236,68,93,55,23,230,67,78,50,115,163,40,10,112,128,225,202,36,69,30,46,91,248,26,83,90,7,9,107,187,51,98,157,115,103,228,53,128,205,198,238,243,98,180,205,211,234,152,192,67,70,128,96,81,207,191,25,101,212,197,223,74,90,153,204,222,240,177,42,73,117,147,172,199,42,101,53,188,170,113,4,199,223,81,141,152,56,77,234,199,100,137,242,5,179,109,153,236,72,72,58,250,238,104,117,71,24,105,130,50,120,121,94,125,216,16,127,197,177,226,22,247,74,123,75,252,237,176,89,9,234,7,209,233,173,99,89,152,212,230,230,23,120,217,28,177,74,147,91,101,234,97,0,145,161,177,19,242,163,64,231,23,74,218,40,106,210,21,139,47,120,28,9,207,168,103,43,81,226,159,227,129,255,2,38,200,154,26,231,243,237,150,206,249,0,92,151,120,219,176,167,181,139,248,75,137,236,39,182,66,27,12,90,189,205,12,198,130,162,205,59,68,90,176,24,164,128,99,134,89,219,57,198,199,140,29,50,39,14,4,166,163,188,254,208,109,149,19,4,73,248,31,251,196,0,119,101,42,211,147,102,130,248,149,150,23,43,237,140,245,129,133,6,38,57,85,206,61,221,188,251,139,148,46,194,147,39,12,64,121,169,58,175,224,44,73,116,101,158,64,101,244,79,32,226,242,112,218,89,107,55,212,196,191,68,108,163,114,171,150,37,106,104,145,197,244,163,209,226,156,188,105,218,52,248,177,53,93,132,75,145,217,111,184,11,118,33,48,22,168,206,21,32,96,4,145,236,109,236,34,132,235,220,171,36,161,16,204,124,5,237,151,8,159,207,84,38,247,81,136,137,21,16,91,179,193,90,22,156,66,97,29,20,128,41,210,227,252,92,231,146,38,145,157,97,219,31,10,199,126,248,60,145,106,115,85,185,18,223,171,79,67,69,114,46,158,39,230,36,159,150,232,239,81,27,163,15,150,51,141,217,182,148,152,222,198,131,29,115,244,170,141,162,29,6,160,148,220,224,179,14,233,253,201,228,155,8,75,202,158,160,236,134,110,244,58,126,43,46,100,183,58,254,5,65,246,241,141,204,41,211,249,51,220,221,103,22,229,235,10,193,230,247,57,242,57,168,55,77,88,170,143,4,11,9,134,168,150,117,26,169,39,202,218,17,237,68,57,46,0,106,168,125,207,188,245,55,186,77,137,21,162,50,217,28,233,178,103,178,32,96,53,158,244,228,199,99,215,23,195,87,94,119,202,121,67,184,233,176,99,250,57,65,184,158,75,143,126,198,231,81,82,172,48,177,84,126,147,113,74,35,244,217,101,93,27,248,12,104,226,209,92,230,5,228,55,228,171,96,230,35,9,250,174,67,144,64,28,121,131,163,48,60,109,210,62,83,223,38,134,219,183,97,78,181,233,213,226,240,137,218,9,220,201,239,25,122,220,146,94,99,138,87,149,131,20,224,156,231,212,67,30,113,1,249,163,32,247,122,245,67,112,44,182,178,176,70,81,238,9,202,154,149,110,82,110,224,158,110,152,59,229,98,16,115,55,126,164,42,176,24,165,96,249,87,73,211,215,35,98,150,255,162,98,243,122,21,84,216,157,125,91,207,91,163,24,25,53,51,125,28,100,125,98,40,145,238,140,225,139,21,44,169,10,6,71,126,30,233,129,209,100,45,148,19,136,1,121,240,247,159,204,171,172,57,163,133,218,31,207,235,206,36,134,243,7,220,51,158,250,68,132,206,44,177,170,156,10,126,86,178,178,132,154,36,48,244,187,172,228,182,13,238,76,115,224,124,193,201,232,159,161,194,49,204,86,96,235,204,186,132,163,79,240,187,185,195,150,246,237,131,94,71,147,178,9,81,133,162,26,23,190,42,104,253,145,144,148,67,177,219,89,88,42,235,236,205,168,140,74,116,136,217,137,167,143,29,107,103,218,169,77,144,253,130,192,0,183,228,81,186,189,176,47,27,122,185,36,76,171,139,85,106,91,1,128,227,165,189,229,171,144,54,79,235,70,7,180,217,20,151,206,255,4,57,70,26,56,2,221,218,32,194,116,144,94,57,100,25,215,226,65,185,114,255,88,94,55,248,181,137,204,189,107,120,233,241,227,161,69,58,8,207,94,145,206,250,102,93,111,70,58,129,175,63,13,21,165,255,191,194,213,133,50,157,207,93,154,90,173,108,176,52,143,11,201,249,48,219,140,246,212,140,110,85,132,253,168,221,224,188,86,51,90,144,144,129,207,103,242,99,221,152,176,208,234,73,67,241,164,213,133,243,37,95,63,80,186,55,175,35,142,145,202,127,25,52,219,123,20,252,228,198,28,27,32,207,37,150,145,59,51,240,94,246,235,71,122,73,139,10,69,76,254,162,214,136,165,67,237,96,189,210,156,205,115,236,124,227,255,59,168,242,22,133,196,22,124,5,61,99,40,193,111,98,235,60,232,31,254,242,85,35,186,234,41,226,50,225,152,136,242,74,202,121,5,142,43,135,12,145,116,154,121,66,29,134,177,223,39,77,161,4,116,17,25,249,100,231,147,222,181,205,151,167,190,40,204,168,136,116,202,50,209,13,248,173,7,205,58,207,20,133,79,219,220,7,136,41,42,163,126,173,36,60,208,134,184,30,3,59,15,19,30,163,45,245,93,54,73,84,42,14,54,85,252,26,144,131,57,33,25,14,208,44,83,213,142,63,227,52,125,146,177,102,172,221,220,43,178,46,36,209,220,229,139,35,134,224,12,98,84,183,240,63,86,63,219,98,132,32,37,130,56,38,6,255,249,35,21,184,85,19,60,239,25,41,146,62,26,242,217,108,91,243,155,160,7,125,173,83,42,67,113,41,121,196,179,114,233,84,182,11,223,12,76,197,185,112,9,74,29,12,170,45,153,187,164,254,178,45,159,231,100,146,71,89,202,50,225,0,110,92,202,68,7,10,130,83,157,121,160,100,139,55,23,198,167,22,159,17,108,138,76,130,232,218,65,51,240,205,77,9,57,161,69,1,64,35,48,45,121,143,122,45,125,59,225,247,200,1,51,250,74,128,34,73,212,135,89,217,111,232,4,27,140,63,24,127,23,92,37,81,16,158,44,33,219,207,185,52,150,102,205,64,52,62,78,49,117,159,221,118,188,171,116,69,87,239,237,246,174,19,105,82,49,53,105,105,245,122,20,121,201,152,30,215,72,132,121,88,164,124,142,242,156,188,0,164,151,60,190,198,237,60,61,242,110,3,235,91,159,191,160,141,68,230,97,176,205,182,44,200,14,69,240,102,251,255,251,10,51,216,25,140,102,24,55,51,122,1,21,25,220,63,3,135,145,162,229,196,21,86,29,120,12,163,175,158,245,121,217,197,165,64,145,224,201,70,159,67,33,117,28,202,214,94,88,25,8,206,235,107,72,187,97,40,194,107,68,130,137,33,252,41,130,230,253,177,249,102,124,198,122,230,31,55,190,18,176,75,78,239,44,138,86,34,106,240,49,10,215,66,98,201,158,76,136,202,13,160,152,67,131,79,99,255,203,138,241,168,108,123,182,239,56,216,201,52,45,198,12,75,19,202,149,132,4,221,244,61,35,91,171,171,59,122,39,182,54,133,81,204,125,150,217,199,26,186,57,228,86,219,41,210,243,186,159,147,152,144,211,123,216,8,230,203,133,208,132,149,43,142,184,151,28,25,79,212,116,202,130,146,126,67,0,65,46,39,161,122,21,243,82,174,113,249,243,69,121,73,44,179,251,154,28,186,168,66,255,151,194,58,24,37,63,193,50,52,32,26,176,243,122,176,192,215,86,173,133,108,89,29,236,136,129,227,50,59,185,212,199,237,10,176,224,111,133,231,113,165,54,103,87,180,219,34,218,186,144,152,218,17,225,194,211,42,56,130,71,1,159,229,22,140,82,143,225,232,106,157,26,12,45,114,202,134,75,98,175,17,165,14,234,247,213,190,53,36,86,44,179,22,224,36,75,71,103,245,87,47,4,152,174,51,169,209,171,10,51,107,109,197,20,246,115,24,106,151,91,228,122,128,194,14,184,255,229,190,41,143,87,94,175,129,193,215,202,88,24,3,66,133,21,227,84,213,125,187,119,92,30,250,117,46,133,237,106,171,139,181,87,235,147,205,148,251,179,155,113,172,189,45,234,208,240,54,41,155,83,54,27,101,176,89,215,105,207,46,165,87,135,177,3,3,11,195,205,18,65,95,238,132,230,95,1,113,101,61,142,160,78,179,227,145,157,175,209,176,117,133,206,199,169,10,165,130,234,120,144,87,46,53,156,251,70,79,123,185,230,2,239,56,113,132,14,67,215,41,212,251,121,165,176,46,167,200,78,30,80,62,217,210,192,34,225,206,166,91,13,125,83,245,120,88,199,214,77,87,225,158,134,68,250,187,243,142,84,255,156,197,147,12,233,22,74,161,67,180,129,76,57,112,2,213,127,37,251,36,68,229,48,80,39,132,89,102,243,190,40,188,235,238,142,182,163,205,169,190,167,165,42,155,26,229,113,162,43,155,245,27,159,2,84,160,194,118,89,61,169,2,209,131,217,155,24,43,32,34,229,181,234,147,94,50,233,25,6,228,249,14,67,189,181,156,7,19,72,237,36,158,84,186,52,149,71,1,199,147,136,102,129,121,101,170,188,41,123,90,80,236,79,19,186,4,218,89,22,246,173,4,9,249,76,123,223,157,130,115,77,79,27,221,239,69,72,221,40,35,135,228,178,186,19,212,149,183,245,66,169,217,236,39,208,147,100,30,153,215,223,254,145,23,89,164,62,251,8,159,77,227,167,66,22,36,195,111,202,252,97,165,130,210,31,182,216,169,134,81,91,136,92,44,72,108,45,86,26,246,65,219,205,8,189,221,114,134,232,254,234,93,137,24,182,88,60,13,22,66,179,82,166,176,51,47,57,76,78,64,244,138,28,221,88,85,226,136,189,177,206,111,82,168,117,152,127,46,182,131,157,199,171,3,124,0,153,153,223,253,57,57,65,222,58,80,77,2,197,42,169,147,252,225,78,246,79,208,70,174,136,204,106,3,88,35,94,138,166,152,248,217,176,72,164,75,142,174,11,144,33,199,211,98,76,234,237,119,225,117,63,87,250,1,38,53,4,75,116,18,170,153,166,148,86,139,144,108,155,148,25,108,235,126,50,204,19,111,82,240,125,182,223,136,36,20,160,119,145,7,247,125,151,41,228,162,190,166,66,214,228,200,147,96,74,25,162,159,17,111,234,212,219,37,115,26,44,190,208,245,120,251,221,184,61,56,42,40,89,113,198,17,76,177,27,85,28,18,167,247,110,29,38,59,118,29,194,220,0,246,23,89,65,130,240,109,116,154,210,189,229,58,250,170,104,7,116,164,177,28,43,7,77,54,88,16,131,105,248,238,126,120,232,35,211,56,62,106,114,200,68,207,106,133,31,131,97,106,215,215,152,120,113,91,88,221,149,110,124,169,131,68,133,254,99,142,49,189,87,153,187,122,212,65,81,30,239,92,213,183,182,124,216,192,67,69,254,64,225,210,246,229,194,107,211,193,104,129,16,161,18,40,196,183,129,207,29,251,51,24,142,133,186,64,118,90,101,61,209,39,203,244,220,114,74,123,48,177,230,171,61,19,33,200,17,116,54,7,251,170,245,88,116,112,138,163,204,240,179,72,85,42,34,233,113,195,16,181,157,173,29,27,78,31,94,114,135,85,127,226,204,43,165,9,218,83,174,128,118,160,165,40,47,159,115,190,76,79,121,79,28,48,13,30,87,115,133,83,49,180,101,111,80,110,176,8,38,201,97,171,89,198,209,116,136,137,174,135,161,36,10,248,138,77,156,76,74,42,251,204,27,178,11,20,140,254,195,37,10,73,241,128,172,45,200,201,156,72,118,61,131,13,89,208,81,86,67,134,194,236,207,162,110,150,4,165,108,160,0,2,196,57,167,248,233,18,169,124,190,49,56,210,17,186,238,236,246,116,38,103,106,50,142,172,30,34,236,115,49,197,101,247,54,252,195,97,190,102,213,205,84,215,28,196,67,109,104,72,115,39,248,15,135,235,156,241,41,4,53,222,166,29,34,203,189,220,231,192,23,93,1,87,238,240,151,179,152,62,86,115,100,127,230,3,118,175,216,17,15,218,82,243,123,14,241,215,245,20,126,80,70,202,65,134,164,178,112,97,198,253,245,0,127,234,96,223,187,120,110,60,176,99,236,201,133,165,93,98,101,174,216,246,246,136,114,238,82,23,119,196,60,228,44,80,75,251,16,195,194,69,31,24,133,130,152,191,23,74,186,37,102,214,91,155,55,160,144,89,93,15,129,245,153,171,228,2,146,169,243,53,130,230,173,241,231,12,176,232,229,74,139,18,53,180,213,50,192,220,250,158,133,244,25,69,138,147,164,230,250,18,216,88,90,224,144,83,217,92,87,132,29,255,34,201,128,236,210,180,132,220,77,33,230,130,37,76,179,103,205,162,73,169,123,5,157,85,117,143,11,151,128,106,49,57,229,188,249,253,99,13,203,79,171,77,103,84,45,116,228,90,61,46,213,117,46,207,238,30,99,44,229,74,13,42,77,239,152,132,140,79,210,201,37,212,13,112,210,173,150,3,90,132,19,227,96,197,84,246,46,15,1,217,241,238,165,24,130,103,234,112,7,126,246,251,116,71,26,139,165,83,115,49,109,108,185,143,100,58,92,67,101,127,136,224,52,191,19,243,215,227,146,14,106,124,215,128,1,200,114,244,21,221,186,7,138,69,156,18,84,216,4,67,96,110,237,140,217,69,56,36,23,128,76,207,141,115,26,15,60,209,237,136,150,137,177,51,214,44,81,226,169,110,38,6,25,239,245,13,208,66,73,8,216,89,129,114,158,166,16,156,126,59,204,86,123,80,125,39,15,24,64,226,36,52,230,210,200,14,31,154,21,12,5,218,54,248,202,172,174,128,52,228,145,227,144,141,197,242,136,226,191,131,157,134,109,115,130,16,36,169,53,120,28,168,173,120,109,32,154,34,42,25,111,5,173,78,202,223,53,238,182,112,54,94,80,125,210,217,111,107,13,114,114,239,111,245,243,31,243,156,237,196,95,182,205,240,12,103,57,165,247,133,48,229,39,128,146,114,60,239,230,151,68,170,112,5,12,83,248,152,217,225,239,186,0,112,230,226,142,193,38,188,109,30,221,40,69,226,144,248,59,55,240,248,48,54,10,33,225,246,156,15,108,58,140,84,134,219,209,237,109,169,60,8,124,46,191,0,81,115,133,60,120,101,220,18,225,86,158,85,91,203,229,236,92,189,21,34,34,245,31,94,112,7,110,179,56,179,189,61,109,145,117,104,15,22,129,85,228,32,204,213,203,120,117,239,114,83,146,236,148,16,211,177,125,13,195,87,42,40,25,212,201,246,76,41,125,211,35,135,3,206,111,174,201,106,129,80,43,121,166,121,48,36,169,160,140,253,156,107,161,80,52,3,199,75,244,58,223,45,134,67,31,55,22,6,4,98,104,192,15,111,220,190,189,6,104,28,192,51,255,234,205,133,162,44,125,10,45,216,132,95,186,153,75,49,223,25,187,105,204,167,108,64,133,114,229,42,90,200,175,173,159,150,63,241,196,11,184,44,154,23,0,125,41,251,11,188,176,179,93,32,247,192,95,63,172,32,121,111,67,165,39,190,33,150,30,6,188,101,6,77,71,164,67,143,196,171,240,74,195,122,91,187,242,214,95,219,236,223,61,54,160,106,225,8,1,185,243,153,140,28,81,131,179,183,83,71,33,249,78,89,143,55,246,208,106,43,44,57,196,169,100,181,132,137,44,34,134,8,175,130,90,156,242,145,167,81,4,245,192,228,211,109,125,44,52,187,168,248,69,23,19,28,0,150,224,211,239,186,124,129,35,18,252,95,235,140,85,41,41,76,20,1,135,93,94,21,187,185,72,62,18,239,214,255,147,74,191,39,145,220,130,228,99,7,175,23,161,211,77,94,169,151,220,237,253,102,47,207,16,7,82,32,195,228,154,221,53,57,255,119,93,199,69,127,126,18,203,82,136,189,186,86,167,159,190,117,113,45,146,242,3,170,144,134,121,227,186,235,201,129,202,187,128,242,252,193,65,253,45,87,172,10,81,123,231,150,255,241,217,235,38,223,106,46,36,237,103,196,209,226,63,236,228,249,237,117,228,54,183,100,199,198,50,122,101,171,181,103,109,62,23,186,236,98,139,61,119,9,168,201,226,114,108,20,29,80,115,251,190,144,159,255,45,231,198,147,148,77,159,186,9,168,89,198,168,226,186,209,209,134,138,66,247,23,100,236,152,79,70,142,75,245,157,120,45,188,52,32,165,202,254,204,129,203,243,117,141,120,26,79,223,171,102,190,69,120,82,180,6,243,91,219,184,198,74,136,55,152,17,157,147,103,63,79,23,89,101,241,130,2,221,248,18,25,151,116,46,151,238,62,117,126,239,173,174,238,152,46,79,112,40,226,71,2,206,10,72,232,212,21,116,231,102,66,177,61,250,203,119,28,120,234,237,214,179,232,82,161,103,208,197,252,5,160,29,193,121,16,29,236,252,92,54,52,46,47,55,182,126,126,22,99,199,112,9,132,24,204,139,63,249,253,227,128,95,95,154,65,180,135,32,170,213,209,35,118,105,195,19,5,137,122,174,201,148,107,8,202,164,171,60,222,191,174,168,137,169,160,132,137,228,148,130,121,255,182,108,63,219,81,189,226,178,192,5,81,227,204,178,189,44,124,13,11,61,231,128,217,218,68,54,243,11,196,235,211,160,29,221,178,39,220,191,61,252,94,17,146,221,136,107,118,117,120,233,2,158,204,64,156,17,111,9,113,255,239,115,62,129,99,152,136,172,202,117,31,245,58,225,130,120,84,75,221,4,216,198,165,93,125,246,56,188,18,130,93,247,250,107,233,188,177,52,199,148,239,221,155,54,47,33,227,71,90,215,70,73,99,113,114,83,226,119,33,30,169,110,179,68,99,84,228,85,86,115,221,90,158,181,154,108,158,177,180,19,133,46,176,239,137,17,142,41,243,231,106,219,163,126,164,56,160,98,186,54,44,75,177,26,98,158,22,187,216,102,110,63,155,199,47,133,246,170,250,123,71,153,70,41,225,196,153,66,97,223,42,242,104,190,94,170,195,54,118,56,125,215,254,18,66,34,11,151,221,248,253,222,194,161,212,170,55,49,202,10,73,51,113,136,34,47,57,188,166,106,100,162,215,187,136,35,150,67,47,133,209,233,248,119,9,105,27,121,105,182,91,82,172,96,220,20,246,112,252,187,129,5,225,245,130,122,16,5,180,61,192,83,102,251,95,82,34,164,47,158,211,30,221,234,51,79,87,22,33,161,188,77,192,51,81,198,12,149,10,240,24,116,123,53,189,249,119,110,197,77,80,74,243,191,194,253,65,76,106,155,198,11,242,41,22,133,74,171,10,33,17,223,246,186,212,222,255,89,66,36,180,129,232,72,187,180,17,26,60,145,195,245,204,169,20,202,22,152,231,156,88,38,173,95,245,214,155,7,13,88,172,104,72,154,40,111,187,88,163,245,73,113,51,55,13,182,18,26,230,193,89,90,58,245,221,248,176,41,195,24,196,67,233,23,24,190,198,233,16,120,70,70,54,72,162,214,29,251,194,41,172,209,219,87,126,247,216,27,186,68,182,139,184,172,116,26,135,106,99,120,204,141,146,15,116,8,163,69,176,182,3,23,189,41,237,98,82,216,154,59,63,15,194,182,123,31,10,134,27,66,49,4,223,148,28,75,86,233,167,239,56,141,164,48,0,230,230,225,91,102,13,110,45,84,246,40,14,64,162,202,173,81,53,208,221,235,174,158,155,142,213,252,101,188,198,100,217,24,202,135,13,242,123,212,75,144,56,242,202,34,153,126,118,251,44,196,234,251,165,26,147,205,64,33,140,207,154,223,221,16,94,98,141,141,162,254,28,84,12,157,226,179,151,38,44,24,146,229,59,154,37,38,86,154,157,156,240,105,19,118,98,40,224,147,187,1,16,31,178,29,232,186,253,202,57,111,126,19,19,167,50,232,199,182,125,241,139,1,225,96,252,126,178,198,154,129,28,174,0,148,123,177,144,179,36,89,61,119,241,187,61,177,79,147,143,246,109,143,39,51,170,140,10,195,10,162,55,121,159,63,188,168,40,146,76,80,43,23,12,67,210,138,97,219,128,179,142,30,205,127,154,19,126,208,237,49,211,252,25,62,82,243,151,172,245,210,88,11,253,108,185,79,62,134,112,158,69,203,163,112,210,181,25,94,113,236,208,168,241,47,215,169,83,114,166,92,44,61,195,18,236,92,117,141,104,93,226,237,143,98,157,41,172,74,40,202,251,158,107,66,44,206,135,228,210,6,151,12,21,252,106,207,90,193,26,132,60,142,119,92,5,217,118,93,186,205,205,80,217,231,84,117,194,27,246,44,71,79,83,55,152,45,214,150,164,207,34,167,187,56,164,0,5,235,218,138,198,230,30,121,108,209,202,204,4,235,175,228,143,63,108,169,244,4,164,28,180,204,71,165,31,87,207,244,47,122,78,48,44,33,239,68,88,3,232,203,22,168,212,104,232,154,51,7,105,67,254,116,170,236,81,166,211,111,162,234,166,49,102,46,199,184,152,219,135,162,209,5,53,16,134,111,153,6,223,96,99,51,227,149,207,96,186,56,125,184,93,12,195,223,184,196,197,235,110,41,254,14,34,72,33,201,129,5,157,225,63,37,149,216,165,228,93,23,121,81,199,71,68,252,53,194,166,170,70,212,25,198,42,92,107,5,175,132,237,56,171,130,86,89,57,220,20,151,155,70,151,94,124,250,224,166,11,241,159,185,237,68,76,141,99,249,224,130,61,150,150,245,167,168,128,83,70,237,241,206,109,184,18,20,142,227,238,172,250,189,19,74,114,148,24,93,248,27,245,19,19,47,237,125,143,5,253,115,78,63,18,191,243,198,129,172,178,87,114,144,75,147,183,139,167,54,182,96,233,184,175,117,135,108,72,70,201,156,24,30,168,67,20,244,115,243,15,171,151,116,164,196,78,155,224,194,83,158,101,231,96,165,176,193,123,183,17,78,89,136,28,64,240,229,214,41,150,155,142,230,253,148,26,21,12,198,244,196,135,78,33,61,118,176,111,160,245,178,132,48,66,195,210,150,109,210,33,98,52,160,38,57,217,209,252,132,227,41,223,174,214,76,66,115,213,80,226,0,168,238,125,18,183,188,24,111,109,218,136,12,42,203,198,196,159,151,72,187,144,229,214,97,163,22,55,157,215,75,196,169,191,82,91,36,189,138,127,37,238,176,118,139,176,84,117,191,193,132,93,21,51,25,143,226,185,225,185,246,0,241,163,137,209,192,211,2,114,208,199,173,114,244,157,37,220,36,47,152,77,200,108,11,44,14,9,84,14,4,249,31,10,220,54,72,215,94,90,31,74,210,133,111,71,187,165,95,254,215,81,191,134,129,50,118,198,166,202,248,97,84,27,212,74,251,247,157,200,99,38,64,134,75,66,146,196,222,208,165,60,112,231,180,240,97,240,68,191,23,81,196,53,32,136,59,214,197,29,104,95,55,252,128,237,136,160,113,100,21,208,178,240,79,119,106,30,151,110,185,167,46,3,67,19,25,106,72,68,205,186,248,247,80,145,244,49,85,25,9,239,19,109,190,131,213,135,136,76,14,90,11,122,116,225,11,57,190,241,47,151,186,11,230,103,214,54,79,91,7,252,70,87,105,40,129,121,92,95,242,86,204,13,171,199,204,16,89,116,184,78,140,97,141,19,105,198,231,245,220,178,49,34,67,176,12,235,6,141,12,95,18,200,139,113,254,104,191,71,121,169,71,86,195,46,101,117,43,192,112,53,117,69,143,147,146,102,82,40,159,102,16,19,60,214,128,241,197,53,104,180,205,138,96,97,164,78,49,113,47,187,232,194,55,217,72,212,121,69,31,197,141,187,115,23,168,142,26,55,68,54,236,27,52,248,60,31,232,129,72,252,89,69,74,168,160,71,184,35,107,11,114,105,244,70,116,25,17,192,115,159,45,100,239,62,120,158,238,119,204,2,32,75,37,162,192,87,81,231,205,231,91,156,16,211,31,29,193,7,141,235,171,24,25,42,125,249,160,226,114,38,226,57,76,213,85,127,75,243,212,179,15,65,76,133,152,90,61,108,59,42,44,189,188,51,123,227,7,228,229,179,237,159,67,176,230,82,121,232,118,161,141,197,208,168,133,54,124,119,114,35,67,6,181,3,62,27,207,141,250,125,49,73,204,45,237,105,226,149,232,74,22,51,162,208,134,215,210,139,125,215,179,239,46,139,118,240,64,172,162,76,47,73,211,73,93,50,133,31,76,21,15,255,23,107,53,123,36,221,3,222,239,120,145,64,125,229,93,77,128,135,220,29,119,108,73,146,236,214,21,144,82,168,22,153,184,199,93,34,215,42,164,164,195,224,121,176,110,151,124,236,215,57,61,185,221,56,145,241,95,250,192,228,251,175,253,164,220,36,182,198,205,150,76,129,104,128,242,62,160,161,151,28,220,251,177,236,182,198,142,192,236,13,186,197,109,98,132,186,1,47,143,222,27,103,241,131,131,242,162,250,10,130,115,9,166,197,58,223,47,225,254,90,20,148,196,154,237,132,193,160,233,202,91,234,199,243,78,24,194,165,43,108,167,11,101,144,248,143,172,217,110,100,193,164,160,20,30,152,250,150,241,149,192,82,193,248,223,153,180,184,1,245,191,252,113,118,157,141,187,197,92,248,251,155,242,128,239,54,179,187,133,203,2,37,208,91,61,76,151,225,196,180,135,135,38,235,243,121,251,38,119,72,68,172,190,98,70,86,201,203,44,53,56,183,183,125,183,238,227,138,173,131,47,24,108,138,197,246,196,194,22,237,92,53,127,224,139,63,82,78,192,186,18,10,125,71,100,43,102,32,74,161,91,77,92,245,18,174,50,243,94,45,106,93,148,32,40,254,51,65,23,1,118,182,88,205,145,128,164,12,137,78,34,36,233,109,18,97,127,56,203,13,110,3,62,220,176,26,29,127,54,77,1,147,114,133,154,143,15,106,126,89,35,142,166,253,146,110,208,9,25,223,110,131,180,127,182,128,99,47,235,172,205,172,118,254,253,223,202,34,88,42,50,201,106,238,60,98,125,108,17,218,192,74,212,5,134,10,47,166,236,80,124,44,191,247,47,248,45,253,45,90,140,226,175,152,21,193,132,241,145,222,192,220,222,242,181,143,181,100,30,255,178,109,23,63,93,71,35,57,39,134,143,4,176,98,118,151,21,178,49,165,235,116,138,71,123,190,104,109,104,18,70,69,75,83,197,224,29,65,102,140,74,251,242,202,59,153,91,98,114,72,156,226,177,140,3,119,141,244,49,213,227,57,13,12,110,177,166,175,94,164,59,163,108,230,30,228,243,141,155,219,74,5,84,133,147,224,216,227,108,50,24,140,230,61,21,73,109,164,24,249,159,120,56,66,49,156,152,151,202,3,37,111,89,224,27,197,211,247,135,211,82,192,40,7,88,25,91,152,254,255,131,63,136,49,100,141,59,224,227,236,165,54,93,188,150,128,223,105,207,13,127,194,8,86,161,193,171,16,148,136,25,123,227,20,47,226,250,19,186,70,49,150,79,159,208,127,93,183,185,131,57,189,236,147,129,225,144,158,242,10,253,40,55,129,67,213,199,25,15,106,250,131,212,62,254,243,184,48,109,62,54,135,230,12,104,23,199,207,111,190,234,246,83,182,103,104,80,180,152,195,183,35,141,147,117,144,2,255,234,69,119,251,44,240,100,227,34,11,135,18,175,33,87,143,67,36,55,54,104,220,68,233,16,215,69,209,146,151,149,166,95,199,123,239,118,221,165,150,208,217,185,164,114,31,191,66,90,219,54,73,53,195,122,225,1,43,29,92,145,66,150,76,97,161,140,114,117,155,18,230,221,153,126,96,44,185,69,252,81,176,223,159,29,203,139,244,137,147,55,144,223,105,53,202,112,11,76,39,33,228,90,128,109,97,152,210,19,67,113,249,180,225,234,9,105,216,20,122,44,25,207,8,52,228,224,231,71,58,42,154,48,11,38,217,175,87,3,139,123,63,2,255,159,119,57,192,181,114,56,44,80,106,226,89,20,39,218,220,166,147,172,97,132,139,40,153,179,69,4,163,239,24,76,234,211,196,59,139,63,240,144,81,118,200,100,238,0,7,30,144,17,225,4,36,109,121,196,226,94,148,59,218,187,132,106,146,44,112,60,105,204,237,7,120,206,218,5,2,137,101,136,94,37,124,107,29,37,190,105,164,45,76,147,91,213,205,34,178,22,233,42,215,223,25,237,37,60,224,229,47,252,32,0,91,21,125,193,229,200,142,249,57,162,126,250,163,60,166,240,81,80,84,33,204,250,131,80,201,58,75,124,246,202,80,100,58,235,174,67,150,98,208,221,105,25,82,102,34,175,156,213,29,137,81,206,204,134,219,180,157,143,200,78,111,95,1,253,30,168,241,36,107,162,240,117,221,81,90,243,157,96,214,242,179,216,97,12,184,161,252,212,214,16,113,154,93,66,57,21,237,6,125,221,91,134,133,80,104,73,48,7,155,24,154,19,231,236,123,112,161,40,162,243,40,249,198,198,6,94,21,202,162,64,173,123,131,106,80,153,80,125,131,67,242,42,111,70,241,115,254,238,252,242,122,189,82,3,211,137,1,99,200,28,131,222,232,86,124,239,2,238,55,123,134,81,218,153,9,46,151,149,30,12,47,223,132,5,228,173,21,183,218,254,4,84,140,198,185,52,203,214,2,233,250,185,52,20,35,250,58,45,85,244,250,241,50,152,23,249,139,97,234,161,24,214,7,26,184,173,186,41,188,192,122,39,45,209,227,210,49,247,188,117,75,192,193,218,187,80,101,76,171,225,167,35,163,135,23,148,138,49,235,217,235,169,33,99,244,151,135,104,145,145,132,72,119,9,229,76,247,8,190,5,78,35,185,102,229,105,127,80,186,150,142,166,48,78,38,111,161,14,121,99,72,231,143,156,200,27,43,225,252,153,107,28,254,33,27,68,31,0,128,185,106,22,24,161,182,45,145,8,236,161,225,56,237,30,62,14,82,146,194,173,116,98,98,94,25,210,154,26,224,137,29,180,86,224,164,66,35,233,79,7,157,199,132,236,19,192,81,129,46,214,53,142,97,247,219,160,63,238,232,253,145,66,103,71,106,9,204,35,212,113,84,34,255,81,149,201,85,14,141,25,200,47,21,75,147,219,61,36,125,52,53,27,194,77,228,252,26,233,35,250,42,223,180,200,125,123,35,76,60,124,65,4,89,217,2,206,250,16,155,203,248,5,115,156,18,224,175,244,22,41,76,198,160,3,182,110,114,17,172,176,222,144,208,100,64,254,189,33,21,85,72,10,201,151,146,203,36,200,152,49,161,179,159,174,172,231,66,213,131,16,37,174,217,90,59,5,110,86,132,0,53,89,1,57,101,106,212,46,72,162,18,110,201,239,37,126,49,181,211,218,149,149,236,136,94,103,158,123,23,56,128,64,105,136,18,42,230,231,249,40,151,25,53,238,195,156,195,236,197,171,129,141,105,56,227,219,179,179,251,192,108,203,91,168,176,249,42,37,112,68,213,192,67,90,245,223,147,246,96,69,165,14,54,254,246,99,11,164,236,128,182,196,36,83,135,0,13,116,194,170,70,104,50,58,206,170,108,145,207,239,35,93,125,178,162,219,62,75,13,13,210,49,185,21,199,60,41,161,14,32,203,246,204,213,150,37,179,58,177,147,69,40,28,191,143,188,227,236,109,9,168,119,113,132,36,164,35,7,177,204,159,219,14,125,78,191,144,185,130,70,46,85,47,130,232,33,104,168,34,60,153,10,89,115,162,240,15,11,9,165,49,73,169,159,182,46,111,93,5,130,8,206,71,172,141,169,238,225,237,32,160,11,39,84,170,81,42,40,238,215,181,39,252,103,22,126,206,245,39,106,9,103,122,181,177,203,102,59,201,250,27,56,48,75,226,148,133,216,222,68,65,80,30,234,50,183,150,165,131,76,55,223,30,86,36,39,142,209,174,202,57,93,179,16,74,20,65,243,53,186,148,137,228,128,40,22,7,164,252,160,195,173,18,41,24,8,40,201,255,199,139,101,237,133,72,225,121,149,172,241,226,5,13,25,239,19,116,226,181,20,16,249,57,134,96,65,236,238,131,111,249,247,36,189,204,121,50,164,212,185,18,97,134,186,3,131,201,35,16,91,179,38,163,77,178,244,119,54,42,126,188,255,70,64,155,86,77,242,135,12,198,127,119,31,95,179,245,226,241,59,68,127,119,100,43,204,55,29,103,254,192,21,53,28,92,183,158,222,245,43,109,227,26,213,56,38,133,229,32,56,182,132,196,116,254,67,54,230,72,227,40,191,228,121,42,114,238,179,134,209,16,14,26,189,28,44,54,231,42,167,66,127,164,98,149,82,233,80,112,167,236,160,88,250,188,144,86,12,36,41,69,167,60,160,225,148,94,253,44,131,14,57,55,230,211,57,155,138,90,0,208,103,152,27,183,6,161,24,17,13,80,149,64,61,229,36,108,91,140,13,201,98,20,195,163,188,114,251,69,195,208,252,204,57,244,231,16,206,24,137,153,5,48,201,219,73,174,129,177,241,8,107,36,97,92,210,223,210,190,105,199,104,147,41,247,28,137,208,241,146,110,12,164,251,29,64,195,126,214,90,232,74,162,252,107,243,164,123,19,220,215,141,111,100,135,40,21,103,82,63,128,253,141,218,245,60,96,10,180,8,171,249,65,72,90,154,178,120,0,87,73,139,210,1,11,151,157,60,62,145,43,207,173,33,37,24,203,39,10,210,168,248,11,51,80,47,220,110,135,193,184,116,191,132,47,99,184,177,155,65,98,227,40,231,72,229,7,41,119,74,6,97,238,65,162,236,78,176,88,17,202,110,150,32,227,118,218,1,76,36,115,217,99,67,238,243,8,68,50,240,55,150,246,62,58,179,188,188,160,222,50,25,44,38,207,123,135,67,209,238,27,192,36,152,75,9,51,76,183,202,85,25,152,36,24,127,0,236,197,70,246,12,38,174,21,221,233,58,178,241,201,88,122,35,209,7,144,206,255,50,156,216,134,199,237,252,247,136,133,255,201,160,134,139,135,179,242,88,203,107,155,177,151,88,14,197,77,221,12,221,217,92,145,123,141,245,167,179,84,226,232,15,160,66,0,189,69,144,87,252,91,87,91,119,0,199,141,234,204,244,252,76,8,110,166,207,78,194,137,138,41,164,141,66,120,253,186,208,88,132,23,8,168,180,219,46,84,183,104,33,181,134,98,216,51,44,3,179,190,78,31,67,134,32,5,247,215,127,132,119,5,182,146,144,237,234,45,95,249,46,21,137,164,110,129,15,20,53,90,163,78,75,187,130,0,14,253,207,216,234,16,55,162,44,53,54,172,204,5,126,112,203,80,44,8,173,14,81,123,189,67,202,182,150,181,45,204,116,122,146,45,49,48,29,185,137,138,111,218,72,247,39,166,170,84,127,110,97,181,187,140,156,56,208,91,213,101,252,102,100,66,129,30,217,213,196,179,227,18,209,75,115,221,139,98,209,120,89,62,158,98,63,134,93,75,233,59,24,39,64,210,174,82,65,115,245,106,251,186,31,14,131,130,38,117,99,231,33,146,231,112,86,237,235,74,217,167,33,176,135,209,11,178,70,3,135,32,216,10,7,167,117,245,241,170,157,233,125,145,30,85,237,190,204,22,38,97,109,222,222,200,243,15,140,92,83,146,208,175,100,141,158,125,167,240,77,11,238,195,50,93,26,253,138,50,197,237,46,166,177,149,201,25,247,222,239,248,89,224,191,183,203,92,128,155,120,89,159,28,165,195,46,66,236,130,201,34,231,113,213,192,252,86,237,118,113,217,198,16,204,162,35,28,107,92,184,78,174,163,183,140,231,100,60,154,134,35,151,186,194,29,176,120,252,219,78,143,83,82,135,80,96,176,15,18,104,38,244,1,156,201,121,7,171,16,115,245,12,182,175,1,140,108,231,135,36,224,137,177,173,148,4,204,37,254,74,136,141,55,128,157,247,149,1,119,130,164,173,172,217,233,51,54,76,131,232,255,151,239,178,50,223,245,193,18,29,219,146,162,145,158,114,137,7,251,71,144,15,183,198,240,225,28,117,41,37,134,184,123,109,186,137,173,61,153,102,204,210,55,142,179,209,157,0,246,20,20,213,139,184,131,245,148,136,150,111,134,218,54,178,7,87,89,154,226,67,34,31,66,119,203,196,46,153,167,137,110,127,5,68,77,150,0,146,20,124,57,45,1,105,239,207,148,164,31,155,27,254,213,120,176,110,197,59,238,152,230,224,60,125,221,192,20,102,127,200,5,94,208,140,99,0,68,88,190,211,241,202,141,42,215,110,12,116,97,194,147,123,223,246,64,77,140,68,43,73,234,183,214,135,8,43,153,157,169,83,66,187,54,27,246,67,49,79,19,69,138,247,1,55,116,73,131,222,14,128,64,210,250,247,82,144,208,170,99,116,156,202,222,0,38,126,24,142,223,195,51,163,165,219,66,76,20,131,66,156,178,239,198,220,19,227,96,19,9,109,87,135,224,39,158,43,94,34,237,189,98,14,40,73,96,4,7,234,192,7,64,27,226,142,226,208,48,81,62,103,20,106,24,156,33,218,99,17,22,193,69,98,205,22,161,9,106,138,141,30,155,193,61,114,104,41,210,155,177,137,80,12,173,131,160,186,32,153,23,98,239,36,27,136,72,43,219,130,189,250,45,23,152,94,74,170,45,89,108,42,106,30,182,41,25,96,251,195,207,25,173,229,107,16,110,74,172,133,18,68,210,64,125,60,112,176,164,17,106,234,76,11,178,120,81,191,61,2,33,211,88,149,171,217,142,85,141,217,7,50,133,52,119,198,108,188,236,53,130,78,220,250,111,236,16,255,64,78,82,126,164,221,13,219,114,41,165,135,156,91,70,86,86,119,48,32,150,204,101,217,155,223,83,69,178,253,125,53,230,178,168,192,146,15,93,28,230,16,67,215,249,134,63,9,143,63,93,84,114,199,11,136,162,231,55,101,107,231,50,75,145,83,207,42,142,8,240,174,190,149,147,23,177,109,92,181,136,162,37,176,159,165,152,246,186,113,76,100,209,74,116,202,180,77,235,209,224,89,143,189,16,11,205,210,51,116,37,130,113,90,58,67,172,9,25,24,94,117,185,71,101,3,136,153,110,151,145,2,84,241,75,129,3,18,174,146,180,220,29,184,217,215,56,226,39,204,229,220,249,169,1,28,152,133,156,248,140,231,177,61,57,66,183,194,103,114,81,22,102,115,96,234,183,192,231,13,204,125,131,16,84,74,66,179,151,151,247,194,122,221,187,241,246,24,72,210,158,96,179,54,93,44,138,58,223,120,222,0,140,30,34,197,155,22,115,12,4,170,80,112,98,160,53,226,39,47,156,112,104,112,186,193,126,23,160,215,112,160,197,220,220,123,152,93,32,255,101,50,3,151,109,36,210,251,125,84,100,102,17,53,100,151,97,103,185,41,23,235,189,155,173,168,165,150,180,1,26,146,27,240,153,107,147,253,31,223,61,212,105,180,33,100,52,141,24,22,103,125,188,190,0,84,237,99,47,13,145,52,31,45,234,28,30,196,251,82,41,152,58,248,133,95,64,57,205,4,31,63,103,120,98,224,70,110,243,5,190,18,60,20,228,242,93,28,104,130,186,6,27,45,76,227,134,185,121,201,5,71,111,203,91,182,194,177,238,241,134,250,239,38,244,246,88,5,33,228,33,89,36,205,62,190,60,66,185,17,209,5,69,168,125,179,61,108,123,46,165,8,213,17,127,75,181,56,140,65,61,50,237,53,16,115,92,248,1,23,15,94,100,206,99,164,109,43,240,104,86,210,34,81,111,103,137,202,49,193,172,74,234,124,26,125,64,253,151,37,182,143,190,65,177,51,129,81,105,160,57,120,196,176,118,244,102,150,23,181,198,41,192,110,95,216,23,141,122,30,27,64,120,120,144,61,232,171,115,143,153,235,98,34,230,0,166,181,185,185,91,68,161,186,221,141,201,176,76,114,58,28,145,153,190,18,113,200,152,13,89,166,144,164,54,84,246,11,139,161,168,131,65,68,63,67,197,146,188,35,19,94,41,4,243,184,0,128,99,234,205,115,202,87,133,27,60,89,190,60,61,116,111,3,65,244,46,30,22,69,92,222,100,201,198,142,46,238,125,119,10,242,166,181,136,104,141,20,196,139,53,139,6,106,40,166,60,208,59,75,91,73,32,71,247,66,245,143,56,186,14,209,222,180,101,25,28,2,163,231,73,86,250,187,226,215,141,206,111,177,146,117,183,11,166,86,14,104,144,37,151,178,201,30,23,156,185,69,132,24,183,105,157,227,173,107,10,183,143,215,185,36,206,121,215,36,184,226,210,40,244,76,244,2,140,240,253,13,69,253,91,76,100,76,159,252,121,135,198,53,45,13,48,205,39,66,167,201,8,101,3,157,150,42,99,180,36,245,221,104,182,150,184,2,40,19,21,108,130,125,41,29,161,176,169,171,224,91,56,61,214,227,251,151,238,12,17,157,39,252,113,182,215,173,38,54,3,10,156,132,116,188,214,145,253,2,218,119,199,136,84,68,115,81,168,74,133,95,124,56,61,100,174,224,96,54,200,252,3,4,183,104,186,126,104,110,230,143,250,136,104,146,33,150,248,173,186,75,204,158,105,222,204,152,36,52,219,220,112,79,60,151,42,161,231,112,42,127,185,135,48,9,208,129,225,166,172,250,58,237,59,201,30,135,24,200,25,95,31,236,65,204,134,241,228,23,161,102,100,98,186,6,105,1,109,75,193,53,192,182,129,57,31,18,173,45,28,89,236,44,37,40,168,198,164,62,197,211,92,162,30,118,210,77,207,254,8,9,49,234,1,163,207,167,47,44,45,153,160,146,42,231,29,119,251,99,148,206,14,82,4,41,72,57,228,24,1,190,228,92,12,24,25,217,9,138,96,78,194,146,72,138,43,196,221,189,119,149,51,207,236,189,111,148,240,29,27,184,216,92,218,117,154,70,93,123,78,251,203,184,120,124,102,38,179,110,45,246,86,7,79,84,202,231,208,236,225,192,48,62,59,244,65,128,135,40,222,88,8,182,14,65,192,7,82,59,202,161,254,191,29,151,32,180,187,29,198,13,182,159,40,247,87,50,102,33,162,215,75,150,17,79,122,84,125,247,32,68,91,128,80,104,240,137,141,91,37,100,188,0,3,113,40,168,121,247,71,33,46,87,79,31,167,182,81,129,77,33,38,122,203,22,99,189,108,253,49,247,251,50,90,124,45,17,111,46,88,2,4,195,169,198,223,5,209,55,207,7,238,55,198,64,187,226,50,226,117,83,114,79,229,228,163,137,148,104,186,244,226,156,162,212,2,10,20,120,169,160,60,252,52,77,6,82,133,201,79,154,208,54,226,75,27,153,210,47,155,200,235,157,90,38,107,104,238,231,8,96,150,192,254,90,226,23,245,166,109,51,41,162,48,195,4,53,23,137,3,48,203,150,64,89,68,16,236,120,97,47,129,98,82,158,26,230,94,195,254,77,96,236,126,198,166,142,113,45,95,83,9,60,12,186,201,60,38,231,232,235,122,116,82,7,1,14,245,118,39,48,175,143,165,171,88,25,64,200,175,31,166,60,141,230,105,245,203,179,176,232,41,240,90,135,0,100,79,5,251,162,40,75,75,137,34,131,238,32,214,193,83,167,92,85,22,251,234,47,96,228,102,122,160,17,74,28,230,109,22,75,34,158,125,219,67,207,117,167,187,245,127,179,0,214,72,122,133,222,83,69,237,252,73,73,51,76,216,171,36,7,91,159,246,51,110,162,116,198,137,162,134,16,50,122,15,124,103,233,117,243,246,168,72,49,95,82,65,8,205,249,232,89,176,41,156,254,48,67,213,59,125,26,140,209,34,15,212,163,152,142,13,206,171,71,127,12,71,214,72,252,113,130,222,177,192,183,193,102,132,106,125,132,150,218,246,234,159,60,43,192,169,34,216,33,213,8,152,220,24,2,31,229,180,62,254,233,158,111,57,59,96,159,209,215,234,127,32,15,7,242,194,35,218,253,200,50,61,107,163,75,125,128,161,22,238,202,192,98,172,6,27,26,183,50,247,14,64,88,170,235,139,117,230,87,62,91,66,172,140,220,147,148,69,191,81,118,88,117,131,211,103,146,39,75,96,143,178,45,62,68,204,146,180,99,135,23,170,106,104,216,66,76,215,224,66,95,7,200,91,111,84,74,58,184,40,233,47,144,250,98,132,219,194,194,231,160,232,5,85,245,209,86,78,179,140,73,78,149,126,154,241,74,72,189,7,114,105,168,110,46,48,145,135,229,142,140,172,139,8,233,9,112,154,218,180,6,38,0,195,127,80,217,4,26,160,85,93,216,61,152,186,179,45,50,92,82,83,254,85,60,227,40,177,32,82,98,171,200,243,180,187,132,222,80,69,2,14,232,212,6,1,137,125,17,80,247,244,177,236,55,124,136,111,168,234,235,94,166,247,225,156,39,126,227,29,165,121,125,61,133,40,96,67,63,151,230,7,85,241,106,115,152,201,219,174,123,176,130,211,128,182,190,228,161,57,159,114,191,210,144,76,105,188,229,61,23,111,41,63,38,197,106,219,229,89,172,141,127,180,174,137,95,50,145,171,37,183,229,76,72,0,213,198,168,140,133,124,30,159,151,41,156,236,172,129,153,53,22,26,181,210,212,220,108,126,36,205,179,206,84,187,208,64,94,61,125,11,2,216,10,130,102,30,93,75,134,63,147,183,171,40,217,36,44,208,189,123,71,238,39,207,2,123,97,67,170,108,31,28,187,194,123,55,66,82,107,227,16,17,129,10,30,185,251,47,51,249,141,3,240,233,254,198,177,115,21,174,216,37,32,106,221,190,39,86,167,27,179,208,67,15,23,25,73,193,57,147,149,25,152,35,110,52,88,183,181,166,185,88,181,71,181,210,102,12,252,223,228,155,181,215,169,60,194,8,5,213,169,27,127,199,2,82,51,24,85,184,7,218,34,31,220,12,123,24,25,126,103,61,19,227,196,47,72,27,184,161,212,113,28,29,218,93,9,244,224,217,230,138,216,118,40,141,11,189,222,103,177,119,158,61,75,163,145,184,173,212,2,245,5,228,252,253,3,88,34,12,134,175,175,242,142,218,63,132,247,107,30,210,25,198,158,26,76,129,230,229,52,194,83,192,178,85,49,48,77,183,93,156,43,176,186,39,117,121,97,247,2,5,228,23,13,82,164,56,129,124,171,59,102,230,10,191,16,153,7,52,158,67,202,87,183,72,19,9,98,32,70,173,50,52,108,16,34,206,153,28,8,12,12,142,85,252,60,35,45,49,245,158,194,56,101,128,135,44,112,168,169,18,154,36,207,95,118,67,202,175,11,190,96,180,14,224,134,188,131,145,191,150,201,120,30,217,143,2,235,62,45,70,235,189,39,90,7,54,163,211,150,81,24,104,211,189,233,105,179,179,75,89,175,129,212,66,204,247,249,211,236,72,108,82,28,19,146,186,203,16,38,81,163,183,127,29,215,161,118,75,103,240,157,48,155,192,70,35,89,239,238,182,43,233,109,135,50,117,160,73,125,81,26,36,193,248,40,210,2,183,192,210,189,148,199,135,216,143,56,76,220,186,250,165,232,61,16,29,246,8,160,140,224,14,19,210,40,136,209,158,38,114,33,190,253,24,72,105,21,105,104,63,205,50,135,82,132,15,5,106,251,223,119,133,103,29,83,82,88,82,40,80,90,203,252,213,37,94,0,179,66,251,202,108,0,103,227,191,210,124,250,194,160,242,222,119,237,48,230,92,240,9,24,3,253,94,215,144,169,156,137,22,54,6,246,67,181,55,190,232,90,223,162,201,42,146,135,27,252,162,204,199,167,248,49,9,32,178,47,75,57,239,82,180,71,215,236,166,116,79,237,127,90,137,193,24,167,225,227,95,127,96,88,102,151,4,165,228,107,71,55,186,168,69,50,86,30,18,203,17,213,40,93,123,96,175,131,26,254,179,195,68,87,38,248,247,47,212,214,101,50,212,88,56,76,241,250,192,132,121,157,131,103,133,98,74,241,94,237,65,207,55,222,167,80,146,115,125,83,213,255,225,206,146,33,127,142,143,192,148,227,247,24,104,199,181,61,199,214,104,180,105,24,60,17,238,68,39,129,78,247,240,125,168,118,159,39,175,228,241,61,152,39,122,77,118,186,36,81,174,187,209,102,209,208,236,89,32,148,24,76,74,132,191,203,94,170,93,95,162,131,215,164,207,24,162,123,108,31,217,132,188,79,241,89,137,251,207,211,140,228,21,165,112,61,207,21,30,77,205,146,246,202,210,157,57,199,232,10,175,64,10,126,12,13,216,188,67,127,24,70,99,253,236,142,61,226,163,127,162,6,82,232,28,161,116,129,54,48,34,178,167,135,88,77,16,94,244,179,252,234,67,160,184,13,198,233,165,93,39,181,154,242,201,172,95,12,76,138,222,132,126,23,158,59,239,253,146,70,170,190,21,215,8,2,197,2,158,69,116,1,252,140,222,231,30,68,102,231,99,46,181,138,121,13,243,240,205,111,195,120,251,39,167,14,92,89,106,4,20,160,127,65,211,28,170,48,59,221,8,163,153,182,131,17,220,42,74,251,243,58,118,50,204,205,239,76,33,46,124,147,167,100,35,125,163,170,207,132,218,25,133,27,20,94,68,74,30,90,32,18,182,250,31,101,55,154,22,59,57,74,156,47,153,205,231,221,71,211,183,196,68,57,209,175,45,40,204,36,52,158,69,128,64,107,93,178,225,120,78,204,216,145,188,144,28,103,4,45,112,183,71,2,197,248,197,4,154,85,22,53,44,91,90,24,102,105,53,250,247,158,15,182,208,84,1,20,156,101,60,4,166,164,102,142,217,71,73,241,85,139,183,164,239,91,49,194,101,117,139,136,202,54,224,49,57,216,61,252,161,16,31,103,219,133,20,20,98,245,250,82,189,174,11,138,15,102,229,125,177,64,188,79,228,91,38,99,75,99,156,240,181,109,141,235,202,237,64,192,75,25,34,144,107,154,127,153,78,47,55,77,152,90,0,146,215,67,23,49,17,68,204,6,122,39,34,114,42,109,43,191,68,66,222,75,57,196,68,195,69,204,212,202,62,77,119,246,196,158,99,21,30,169,96,25,219,48,254,127,88,35,45,114,73,154,83,60,100,187,254,203,96,32,63,35,21,3,12,254,5,135,242,111,196,92,115,150,33,106,28,23,11,88,60,94,45,16,90,253,206,56,45,230,35,176,230,129,140,233,98,151,23,133,106,42,164,166,115,231,45,33,236,13,217,83,89,254,183,27,18,56,149,211,152,95,132,49,44,155,152,243,254,107,201,34,126,59,59,207,25,124,148,203,30,137,167,116,154,229,182,31,180,23,162,221,43,156,215,176,244,177,108,30,49,214,194,153,55,236,106,149,5,55,255,112,10,198,110,191,248,139,126,111,22,125,177,221,48,104,209,46,124,145,153,149,171,237,70,29,192,35,48,126,253,193,145,255,139,12,123,179,193,34,38,144,255,90,14,72,202,236,79,240,191,246,93,137,199,125,49,181,122,172,184,250,63,72,38,44,99,214,112,214,67,19,134,84,35,11,24,126,173,164,251,206,125,153,208,164,125,64,24,48,179,1,255,22,0,45,153,101,128,223,77,108,52,162,179,224,70,139,83,183,135,132,131,53,57,188,52,166,177,199,73,202,248,93,176,15,111,206,4,217,215,184,244,40,157,38,203,244,119,242,4,204,234,167,160,21,105,61,253,182,119,148,186,162,66,87,27,241,132,5,142,151,114,130,63,203,5,97,43,242,51,164,145,82,28,183,134,6,12,111,7,19,234,16,96,204,184,24,203,202,217,226,37,131,143,3,168,172,235,156,155,130,17,118,129,133,182,67,75,33,194,146,239,201,134,42,234,55,108,134,7,225,107,222,207,205,120,188,106,33,172,28,40,105,212,215,79,166,175,230,241,118,41,151,39,13,250,47,192,191,145,134,250,227,104,79,102,215,206,94,22,180,218,95,43,35,39,169,27,9,69,233,233,130,232,92,105,36,139,166,211,96,123,198,242,81,66,40,195,251,229,158,19,178,33,28,45,72,169,237,113,146,190,185,229,69,239,133,28,13,130,139,244,238,27,200,179,237,168,153,194,154,233,8,92,54,39,15,170,160,80,0,194,121,170,5,104,205,217,74,199,161,201,60,33,56,152,222,232,146,122,6,232,150,111,31,40,203,74,64,122,252,82,226,31,147,106,55,53,147,56,191,253,8,169,142,38,188,97,204,138,56,96,240,72,29,66,106,149,18,252,78,84,46,202,114,58,252,199,211,84,215,243,73,54,181,84,54,66,167,167,162,39,21,192,35,86,68,219,249,144,94,86,100,66,154,245,112,109,33,212,156,189,33,129,249,25,55,12,112,128,56,76,172,221,215,81,74,199,81,131,225,73,222,247,3,166,248,90,199,230,255,108,191,116,206,28,229,76,115,141,170,75,0,130,221,240,222,214,142,125,105,9,160,7,184,245,37,9,56,149,180,46,176,100,69,1,104,7,190,228,116,89,114,141,48,184,206,229,244,145,99,60,15,45,244,163,227,36,45,69,251,11,166,233,101,21,128,189,84,130,223,13,241,154,62,121,132,252,96,244,205,81,33,146,106,218,211,97,171,70,214,21,61,3,47,14,145,10,156,64,84,134,64,105,55,58,160,56,58,144,127,89,228,139,52,144,215,179,218,190,210,182,207,102,49,159,224,152,135,172,48,136,149,230,218,129,178,182,231,113,134,204,224,45,229,14,9,148,248,84,218,24,179,177,188,191,37,184,194,142,201,255,145,199,25,255,160,40,147,227,194,100,55,208,222,93,2,72,212,65,79,200,244,45,116,149,197,196,0,9,201,254,136,33,94,50,9,55,2,209,83,0,119,32,245,58,63,187,25,5,180,2,121,190,202,27,149,122,235,83,124,158,68,4,210,97,97,43,17,134,118,172,221,50,51,214,183,184,93,189,126,63,90,242,51,144,176,92,179,238,44,34,198,234,90,12,92,168,18,144,14,104,111,114,132,134,1,41,92,221,80,236,168,118,194,221,137,103,59,129,115,143,146,232,175,75,1,119,64,255,190,134,242,231,42,61,126,120,228,156,183,194,94,22,71,41,60,188,90,250,72,254,107,206,129,86,67,120,19,141,115,246,164,254,55,248,180,21,83,8,65,230,28,196,10,150,64,133,93,203,115,126,182,164,109,161,62,244,168,62,146,195,83,84,179,213,150,178,253,175,228,211,174,19,57,20,178,198,79,119,98,103,67,199,19,38,170,95,2,216,81,179,170,13,20,107,28,237,60,73,169,111,34,67,127,240,100,221,132,114,171,21,55,222,21,231,189,2,129,21,235,228,220,18,148,83,178,52,221,180,247,169,13,30,114,180,204,242,165,155,223,248,68,147,114,90,28,67,163,22,45,216,26,109,124,111,77,55,114,62,199,37,29,168,4,161,101,22,0,162,197,108,13,116,50,117,126,92,101,37,160,230,15,67,41,110,85,27,74,119,20,0,199,23,44,102,170,169,103,112,0,42,119,197,45,166,215,67,223,169,62,82,39,24,216,12,135,1,31,55,205,233,239,147,247,62,76,12,2,1,149,173,51,95,51,61,237,208,233,213,78,72,196,64,9,219,105,96,53,116,34,211,142,203,46,136,17,233,56,148,65,208,186,212,210,230,65,142,225,148,75,84,229,83,61,135,127,242,249,82,1,42,83,14,77,78,243,161,114,103,89,177,231,241,70,202,60,106,120,226,29,223,137,191,24,117,37,28,49,223,168,138,52,243,30,3,92,233,40,246,95,237,46,126,226,230,217,3,177,119,84,63,202,151,174,45,245,5,51,253,249,1,180,119,45,118,102,95,149,55,32,47,105,8,71,80,60,188,25,114,190,226,44,236,223,134,60,3,253,138,93,30,49,248,217,111,8,61,92,60,113,86,37,75,147,47,155,30,22,66,95,36,251,86,181,202,210,179,217,144,87,178,189,212,110,46,104,218,105,158,144,24,15,145,128,18,78,18,47,246,81,65,119,34,123,188,72,100,122,8,55,188,74,10,28,114,186,46,2,124,176,112,200,158,116,178,173,65,69,158,92,85,64,208,93,124,129,137,168,225,164,223,21,204,195,154,9,40,122,73,122,184,183,163,243,160,10,52,255,114,151,117,25,7,51,81,222,108,107,41,237,82,25,157,245,36,115,52,136,72,164,168,70,240,235,24,83,100,99,158,104,131,197,223,243,110,239,55,210,167,4,46,247,248,243,114,242,94,117,144,248,244,124,163,17,108,254,152,83,169,208,188,58,25,207,110,241,94,83,207,200,119,12,222,77,111,25,223,251,132,116,8,215,185,124,210,182,34,201,165,65,93,211,63,123,21,169,134,220,27,99,86,149,63,150,186,12,49,133,213,33,233,162,184,234,129,42,254,21,60,178,7,23,121,230,92,165,25,36,25,157,101,73,135,129,81,9,44,179,32,247,124,13,79,225,79,99,79,112,128,45,123,33,143,182,236,153,135,183,249,18,215,64,116,87,55,118,74,129,149,57,203,252,54,42,58,173,41,12,249,193,27,7,36,107,251,56,89,241,207,209,59,23,114,91,178,225,6,107,8,211,170,98,228,199,41,150,245,29,108,217,112,232,93,166,106,153,56,8,219,85,52,5,115,122,75,250,77,27,122,179,254,234,239,88,173,201,213,126,202,222,161,97,116,47,238,92,20,236,211,158,109,253,91,68,151,97,196,61,63,144,29,222,131,66,109,40,184,243,152,116,1,201,253,21,237,247,38,9,210,125,232,94,40,211,90,150,121,56,24,197,42,149,145,77,232,77,164,189,178,18,158,190,46,109,228,203,209,128,243,52,46,10,36,37,135,162,109,10,250,198,151,246,176,175,152,84,211,243,87,4,162,255,12,189,177,4,130,176,61,173,226,138,129,194,178,89,104,143,70,24,142,8,100,235,113,179,37,46,52,125,219,202,208,149,19,18,64,63,43,248,184,27,244,93,220,27,231,57,54,201,188,97,139,145,100,100,195,27,202,54,231,208,207,38,63,253,32,115,43,244,167,111,7,63,131,16,154,203,3,193,124,143,73,40,194,240,80,130,89,160,96,235,44,42,123,98,255,26,208,66,99,33,57,48,161,56,58,50,103,250,123,204,60,152,57,165,58,148,220,197,74,197,70,36,90,14,10,32,3,84,125,81,242,65,241,206,100,244,133,223,13,11,72,52,5,34,122,187,55,136,172,44,74,27,199,154,92,166,83,178,217,153,158,64,77,114,80,6,42,192,48,23,122,10,13,107,202,14,36,127,191,106,116,164,164,144,181,92,36,58,18,64,221,211,17,110,28,16,21,159,100,241,243,221,79,47,114,15,231,93,78,142,105,9,76,119,18,113,183,76,145,157,54,59,83,93,201,163,153,116,117,74,224,121,249,32,149,245,194,110,219,219,50,48,171,204,214,241,243,143,46,64,165,230,249,218,207,51,118,108,191,123,64,35,188,177,81,52,47,127,241,123,139,129,60,163,0,91,108,6,61,219,3,136,22,57,4,183,165,204,117,27,250,139,231,14,0,223,200,203,130,191,107,51,69,43,8,204,55,55,169,9,26,171,175,250,145,160,78,14,112,130,229,2,48,159,141,239,167,169,233,43,25,103,228,57,104,171,253,158,32,133,138,205,79,58,22,7,130,233,151,49,131,141,15,204,10,219,117,130,28,98,243,205,72,164,56,94,203,43,61,8,42,43,137,165,21,125,212,77,82,86,70,73,209,56,250,103,140,184,240,242,34,91,17,48,250,118,171,137,17,147,11,225,220,83,72,22,156,196,87,255,22,187,248,175,170,148,66,46,133,203,12,240,193,101,120,253,53,197,234,243,75,106,156,148,184,110,65,132,14,153,253,118,208,20,242,26,46,103,110,86,38,131,127,168,55,62,119,20,1,209,91,7,49,153,218,69,235,12,84,148,195,101,123,92,118,174,67,19,102,55,189,111,73,195,13,42,42,49,158,212,218,89,74,117,43,251,214,110,155,22,126,141,88,168,174,191,205,10,199,70,45,88,84,219,230,124,70,195,54,23,75,154,159,78,23,167,61,240,123,95,222,134,102,135,84,88,21,128,55,69,77,201,74,215,40,215,255,5,129,12,58,85,124,5,156,216,65,38,145,102,31,136,13,218,254,29,215,184,138,174,211,201,192,100,230,70,238,129,80,226,35,246,228,10,85,250,37,183,128,139,33,77,238,163,38,195,197,180,196,79,114,180,104,229,33,175,53,55,216,55,20,222,113,142,225,217,28,54,250,69,167,121,241,16,164,27,193,180,130,24,79,36,184,64,212,142,237,172,195,146,203,27,237,47,93,11,221,78,157,145,240,130,240,105,226,235,137,13,130,107,38,178,106,212,228,47,46,25,48,52,81,241,104,111,253,244,202,150,21,80,199,67,73,211,191,47,135,135,179,79,224,66,29,62,163,88,168,106,141,252,205,11,35,20,250,204,201,205,14,198,83,222,150,164,252,108,89,98,91,101,53,40,76,203,215,32,212,85,131,132,115,44,176,94,210,218,129,194,74,16,155,105,225,77,45,31,248,106,82,207,156,87,147,13,48,54,36,231,219,126,23,146,218,183,132,109,149,249,186,18,225,10,184,170,252,88,61,142,193,105,96,121,138,129,116,191,235,64,93,242,34,170,68,30,70,245,80,69,238,186,116,63,103,146,64,53,169,182,114,3,79,206,26,32,238,105,55,32,132,42,224,185,232,218,187,99,113,215,12,73,91,197,133,77,181,196,150,120,199,238,55,18,173,139,178,79,206,114,189,2,236,170,30,224,255,75,27,49,213,176,38,92,104,150,84,217,136,152,127,107,183,177,34,236,46,225,15,57,156,216,233,146,141,225,111,123,80,15,25,180,117,95,88,230,156,120,161,139,40,247,230,196,41,38,39,58,84,186,203,65,14,66,67,255,174,253,7,145,103,129,179,87,210,186,107,251,56,171,98,55,239,58,36,249,8,157,205,137,95,169,40,54,11,96,88,237,116,129,89,15,247,207,232,176,254,1,23,233,166,29,228,38,181,90,140,195,24,128,91,40,4,255,34,128,202,175,24,98,105,177,199,207,37,87,253,146,170,9,62,167,18,53,44,130,131,34,218,144,102,110,201,102,2,80,82,215,221,55,202,202,62,103,151,56,103,150,21,43,2,51,234,128,25,195,58,8,254,60,151,27,162,109,155,65,187,234,109,195,89,17,43,102,109,178,29,16,110,61,142,127,105,31,1,107,179,78,225,108,226,104,94,190,15,89,160,251,117,6,62,89,242,19,81,82,119,240,95,86,234,207,206,112,198,212,181,6,171,227,44,19,133,181,132,70,64,21,8,48,171,129,53,65,56,188,236,64,172,11,109,172,173,139,127,125,231,184,167,91,216,199,194,139,12,91,65,236,139,236,77,58,90,169,90,125,102,12,8,130,1,218,19,24,24,240,170,43,126,228,247,35,127,40,142,164,177,34,238,26,124,182,223,32,142,119,41,90,87,212,241,185,247,9,145,146,237,83,193,104,66,84,56,61,47,17,62,212,18,144,72,158,255,43,208,248,28,63,59,218,219,242,156,148,13,90,83,140,224,179,117,181,37,112,8,180,156,17,157,23,81,84,150,245,212,30,3,47,221,83,62,34,34,36,240,83,241,105,87,29,52,70,154,97,72,59,155,192,116,128,12,106,197,220,172,129,240,37,150,112,169,189,198,167,222,28,7,197,50,150,51,248,182,29,233,56,0,211,222,44,104,136,143,10,34,30,195,87,24,38,61,125,128,58,112,205,105,4,101,177,224,238,74,196,1,157,7,33,105,222,180,33,25,98,170,36,37,27,244,109,68,88,48,1,173,139,143,48,58,243,216,58,70,82,91,152,51,163,81,52,142,50,57,101,21,8,136,216,54,25,190,55,122,73,195,191,251,142,252,39,215,94,49,103,199,177,67,50,109,111,188,250,209,229,242,203,102,246,195,226,28,122,73,214,182,52,81,229,244,213,195,101,46,79,205,120,207,227,172,76,94,14,78,242,111,103,176,43,167,39,49,19,119,28,217,122,98,102,250,252,166,154,101,224,87,192,254,143,27,231,193,116,165,255,42,192,55,107,67,221,178,89,100,190,241,83,4,137,142,168,50,7,14,36,113,189,255,76,1,190,35,11,7,111,149,75,46,148,157,40,28,210,183,211,65,190,205,50,45,250,2,186,149,235,187,193,4,84,22,203,101,210,198,83,110,97,45,21,122,161,243,239,89,75,245,21,1,102,73,25,56,122,67,4,168,148,127,47,228,235,121,218,63,232,250,59,247,222,237,133,222,152,27,62,146,163,150,167,183,8,220,239,187,146,180,38,159,161,118,116,209,180,150,122,235,0,98,174,3,129,184,5,150,43,86,152,241,6,35,123,81,106,198,148,110,8,232,174,113,72,47,185,195,89,137,60,242,111,243,243,245,177,123,183,36,65,21,3,48,2,14,108,135,29,112,214,159,126,189,231,206,215,12,158,251,119,212,113,38,132,135,152,88,200,6,169,195,116,81,243,73,145,28,140,72,12,46,162,103,76,97,99,190,244,234,123,157,47,183,25,80,32,157,90,23,77,220,212,165,104,125,243,102,171,102,225,32,105,205,116,25,146,92,105,167,233,109,24,216,50,43,181,188,40,226,57,224,135,205,204,140,196,143,244,22,69,23,213,189,137,212,149,179,104,32,189,74,89,108,58,142,77,144,100,12,72,135,122,219,46,89,56,52,117,181,14,180,222,194,65,68,89,14,80,110,20,134,115,94,162,17,243,50,40,166,174,237,231,86,81,170,17,67,196,155,72,129,142,166,174,148,254,117,41,221,15,153,63,103,115,255,57,241,141,61,7,175,166,10,169,142,70,174,68,105,196,177,237,218,36,203,73,114,6,172,215,21,136,146,158,170,171,197,111,249,241,54,7,201,69,238,145,201,163,83,36,147,181,167,89,124,107,88,167,214,131,69,122,7,170,251,62,13,150,53,254,39,151,190,155,212,164,69,86,139,254,19,222,120,119,108,37,234,187,165,240,5,172,123,179,109,20,170,164,136,10,147,153,129,216,32,210,175,90,71,140,248,242,201,4,81,26,171,72,98,161,62,132,177,57,248,241,255,220,139,64,207,29,221,191,210,195,241,98,49,224,53,123,67,108,206,213,117,130,87,93,184,87,245,247,118,177,56,217,121,219,78,105,62,159,71,120,7,101,116,68,255,42,186,129,216,202,48,57,10,43,88,97,144,213,11,166,195,132,203,236,108,232,78,222,102,188,40,196,50,223,254,199,234,175,243,205,218,57,215,12,56,89,211,92,158,35,178,58,21,173,249,115,143,96,250,92,248,156,253,70,230,30,236,96,135,25,26,46,160,135,67,244,221,55,2,225,201,197,39,239,51,20,220,161,249,152,187,235,24,225,72,245,223,107,101,8,150,186,247,74,230,168,145,172,34,154,141,220,205,11,41,153,137,229,227,222,202,139,120,168,246,223,7,245,117,122,73,32,13,14,110,202,62,66,236,147,45,49,15,88,90,243,49,14,146,23,176,194,54,216,206,135,35,102,71,29,85,146,218,225,123,255,242,49,167,68,216,104,212,147,212,16,181,36,230,254,16,250,169,86,70,89,61,111,148,101,0,171,183,215,158,247,169,86,61,95,72,62,76,199,155,176,197,101,35,109,175,20,114,138,118,83,47,241,65,185,100,189,75,195,211,211,18,151,86,132,124,30,193,165,117,57,76,105,131,13,103,157,44,202,226,19,48,208,27,177,165,233,34,21,47,136,161,78,67,132,190,145,226,230,126,67,192,162,58,156,220,1,81,135,236,58,20,242,254,163,118,189,187,29,99,40,226,56,238,22,31,230,76,142,58,63,130,67,47,187,69,187,86,114,74,125,171,139,255,60,208,45,112,103,121,73,141,160,160,210,174,184,183,162,28,17,160,132,145,32,99,85,144,112,185,236,200,9,221,157,68,176,193,131,162,252,178,247,249,161,170,173,153,12,149,96,208,142,119,136,130,215,45,22,192,188,66,87,35,77,122,250,195,246,21,113,104,251,14,167,75,154,108,95,159,119,22,129,173,43,194,4,74,133,25,7,42,90,39,72,35,241,195,31,205,13,129,12,153,102,119,240,62,54,52,44,70,249,216,76,167,199,33,243,104,61,195,243,26,92,250,244,34,207,174,71,233,110,196,22,68,31,39,5,83,97,202,67,15,124,136,10,27,177,239,76,48,94,174,27,213,238,8,248,174,201,202,231,243,194,189,118,239,166,105,226,78,145,49,69,55,88,101,126,54,183,127,198,91,208,218,219,74,94,129,187,10,6,198,21,73,218,191,133,38,35,133,118,5,211,84,223,223,70,158,55,140,164,2,4,148,104,241,90,52,251,42,108,205,112,238,96,178,177,2,144,169,12,228,189,107,100,172,251,137,35,221,62,245,124,6,57,185,16,117,88,162,115,141,197,235,28,111,145,228,239,176,105,96,57,86,189,125,0,70,43,165,176,114,40,181,59,190,174,118,101,191,203,219,232,17,149,71,86,249,16,179,26,14,220,41,32,201,37,90,193,137,89,162,38,148,114,159,35,104,124,46,212,30,223,205,189,212,69,248,93,101,173,229,20,228,46,219,40,112,154,182,137,147,117,206,15,233,193,72,75,57,78,183,79,70,170,227,132,226,83,237,176,234,80,24,98,20,171,187,126,247,102,180,26,186,87,10,108,29,230,37,141,203,78,230,154,170,185,193,243,186,112,202,181,210,133,91,164,173,42,236,118,210,68,33,137,65,101,33,41,248,167,240,233,99,191,52,249,228,141,228,82,59,65,23,33,14,189,90,125,204,155,27,159,254,88,30,196,181,56,57,110,127,115,222,61,222,82,199,175,8,7,101,67,227,222,241,87,242,59,81,235,212,140,91,48,24,192,249,83,118,199,89,218,1,251,126,78,152,88,139,3,102,146,68,53,124,160,231,181,73,174,86,109,5,76,190,196,27,234,104,72,222,120,91,231,190,196,101,132,121,153,144,139,150,8,239,238,241,100,62,231,33,195,71,173,176,215,58,1,76,185,91,67,1,133,220,225,137,74,10,235,62,176,178,190,38,13,148,122,117,160,27,35,14,210,103,82,95,96,161,55,169,153,211,37,76,13,47,16,132,204,148,38,201,143,238,16,99,105,124,254,22,53,77,144,186,133,93,235,251,213,94,184,85,161,250,127,3,171,37,64,73,100,104,227,86,73,240,94,35,132,47,200,182,140,65,78,222,91,154,149,19,179,55,126,77,19,79,226,114,194,84,177,170,110,53,66,7,91,21,140,143,189,169,37,142,82,53,241,40,224,36,80,90,111,92,195,79,143,64,72,161,187,239,68,196,205,52,24,61,171,149,168,98,162,129,126,140,147,221,141,210,137,232,220,23,163,147,59,113,245,138,218,86,156,184,149,217,91,187,250,175,23,153,168,218,13,236,9,147,52,7,43,20,199,92,104,105,246,204,222,253,83,239,204,144,180,46,78,213,99,160,252,84,198,100,1,187,141,207,9,47,175,72,109,27,134,133,23,180,56,185,126,32,104,247,244,138,137,150,83,54,28,95,137,182,201,23,4,195,124,127,173,238,6,221,76,21,218,155,218,192,253,41,36,218,227,45,114,103,66,32,215,195,187,190,4,247,223,214,160,44,159,5,100,237,5,149,249,92,216,254,17,182,55,245,55,76,91,129,78,71,42,13,138,12,178,229,103,232,180,182,83,161,158,190,135,96,222,89,200,194,116,120,54,252,109,109,241,235,53,76,189,173,242,127,29,240,221,255,28,192,65,72,109,12,54,56,190,254,30,30,247,52,85,103,104,208,78,88,89,166,60,81,235,112,174,252,8,189,125,145,200,120,124,8,226,87,220,121,60,111,50,219,96,196,186,5,200,16,68,157,158,55,20,55,89,219,216,135,253,123,19,132,196,251,83,102,16,132,38,180,251,42,130,31,49,231,248,94,154,6,184,62,10,178,145,210,191,150,160,177,38,247,10,99,52,45,153,229,25,134,176,203,130,194,58,65,150,0,178,202,25,201,156,92,81,17,196,88,156,30,125,143,224,171,121,235,178,36,183,45,97,180,93,215,193,194,82,67,4,195,145,201,154,83,72,101,107,12,40,109,2,18,139,162,53,111,26,235,164,143,25,24,146,179,162,124,210,240,3,135,214,14,219,118,24,61,62,45,90,152,200,229,141,48,148,236,225,93,103,212,100,22,224,121,9,132,173,123,68,232,126,254,61,226,6,19,81,217,212,186,58,111,4,206,45,161,77,106,164,27,196,55,111,63,41,77,116,195,151,230,206,208,15,4,184,181,245,21,166,241,55,51,242,59,177,190,101,9,55,6,110,221,146,41,31,64,158,161,72,252,168,17,191,225,42,101,76,224,251,244,124,168,174,56,214,133,8,96,12,154,67,162,239,109,26,93,215,194,208,249,255,96,169,111,231,39,157,110,240,26,65,219,91,47,59,114,54,216,218,228,208,149,113,24,236,215,8,44,135,1,39,179,185,238,104,193,108,35,223,95,39,105,218,82,73,182,84,6,69,89,91,112,60,162,221,59,26,59,14,110,101,128,63,116,47,244,228,19,254,16,14,71,0,40,79,205,220,229,66,49,198,35,9,146,201,29,250,81,255,250,198,147,247,106,61,85,79,118,236,38,215,150,153,16,69,22,216,13,140,130,212,77,115,75,6,147,129,219,81,216,198,182,144,215,213,177,49,106,246,96,57,85,101,187,131,94,136,195,174,95,160,163,19,223,112,65,10,133,94,126,154,87,30,229,60,31,133,154,132,220,131,107,1,166,144,184,235,231,16,15,60,135,161,178,180,105,139,85,69,123,96,243,140,13,126,249,69,64,83,90,63,224,201,91,200,163,162,78,23,26,183,14,228,153,82,37,97,128,8,49,240,174,24,56,42,163,114,87,151,61,126,4,9,232,35,19,168,205,180,169,219,139,90,208,134,156,16,17,54,222,115,127,59,6,77,236,221,193,54,11,157,154,231,198,113,91,157,77,218,246,207,86,110,90,18,189,120,225,145,190,243,109,69,133,41,219,27,139,155,68,109,214,28,144,184,179,215,53,13,221,45,164,133,85,227,66,30,226,192,199,230,255,19,121,64,197,104,33,167,247,219,87,185,108,231,247,247,145,242,132,139,145,65,44,33,98,164,3,249,230,76,123,204,198,213,115,31,243,255,107,122,3,230,110,177,202,206,61,83,206,171,99,142,50,146,176,108,3,107,215,143,14,86,234,64,143,93,220,27,112,60,21,97,58,137,163,81,213,20,168,231,227,238,3,207,34,161,62,216,87,22,93,52,60,246,127,109,207,56,82,98,235,62,10,42,36,123,133,207,31,74,38,6,222,134,156,64,37,201,139,154,178,151,220,171,130,236,182,21,19,105,245,208,82,57,189,147,167,87,131,28,172,235,120,178,97,182,2,191,224,160,93,95,226,251,186,139,1,132,80,10,89,232,196,170,127,82,173,232,121,192,21,125,160,82,80,46,177,33,196,88,0,203,6,233,138,241,146,102,60,61,224,179,173,196,54,249,116,124,166,67,4,233,47,77,198,89,149,234,63,118,70,133,224,100,221,110,232,100,120,130,102,2,5,113,28,73,6,186,125,77,11,243,147,66,245,145,253,48,130,69,64,85,194,173,118,139,159,192,110,154,68,52,95,219,71,0,95,125,211,83,94,22,197,6,197,211,94,141,179,49,246,207,165,72,118,175,193,235,207,253,11,77,64,13,250,37,232,77,53,17,63,255,75,44,153,213,55,248,9,61,33,253,231,115,187,163,56,127,199,92,185,179,116,95,237,84,90,73,203,192,157,199,108,56,166,242,23,177,83,232,79,66,7,233,67,84,68,172,55,114,52,218,231,52,199,173,135,13,45,236,213,7,222,98,145,233,175,161,37,70,14,154,8,189,38,2,195,56,135,191,218,75,220,194,112,82,197,126,35,141,171,133,248,184,168,21,54,162,240,224,170,136,127,24,198,109,101,180,77,110,31,215,245,65,199,129,10,187,8,253,55,228,187,2,107,89,11,66,189,106,219,252,207,94,72,81,158,232,10,122,115,130,3,103,210,68,192,248,89,24,42,100,130,111,35,101,234,197,13,130,109,171,203,8,65,66,81,76,146,148,75,227,60,217,53,116,89,184,166,40,69,3,65,104,154,68,236,223,166,98,9,236,124,118,86,234,20,112,99,127,165,187,194,220,171,221,76,91,106,95,176,162,14,242,194,234,92,129,106,159,73,214,106,52,141,29,74,160,236,147,179,18,70,37,81,82,16,103,37,36,85,161,44,7,68,176,15,74,108,39,153,147,235,49,227,101,80,213,98,232,199,71,117,82,115,154,125,140,249,254,145,218,30,134,132,98,37,209,47,121,221,30,162,16,29,151,53,69,232,100,186,200,190,107,180,60,166,5,158,33,146,153,113,11,249,80,216,78,89,86,235,238,89,49,200,245,169,55,32,22,113,175,172,230,10,178,152,122,163,134,154,152,174,255,93,73,11,61,141,85,240,86,34,162,12,23,180,124,53,114,149,202,32,122,87,160,179,43,69,170,63,75,229,162,34,43,57,2,48,159,78,157,195,1,28,67,29,92,43,179,15,23,239,94,251,70,171,183,51,109,14,122,43,194,3,92,29,74,10,3,123,208,32,40,31,18,125,139,11,33,110,38,111,63,7,89,101,235,209,63,13,240,118,184,221,172,57,253,252,183,24,106,77,219,111,56,37,127,52,12,44,86,166,151,205,253,222,102,191,204,195,68,235,174,234,250,128,236,176,44,153,94,251,210,78,15,118,23,36,105,1,124,25,7,207,250,14,187,16,79,98,12,128,195,43,144,47,100,212,176,196,39,1,100,80,246,22,36,131,22,166,29,117,104,16,220,3,181,38,105,70,36,145,246,178,41,14,189,169,118,27,248,146,21,57,69,111,181,114,54,87,204,170,200,153,95,171,249,83,190,54,177,105,104,149,204,50,179,202,93,254,240,178,101,7,51,141,68,25,14,156,80,157,172,175,251,65,249,124,86,223,139,182,112,172,189,66,88,112,212,228,150,17,14,114,176,192,47,231,185,127,220,84,156,94,92,34,188,130,45,136,4,113,103,12,156,137,204,19,182,9,76,245,98,232,19,90,74,184,91,39,245,64,202,147,236,202,242,183,96,253,91,15,228,45,181,223,148,212,114,57,55,14,223,137,57,222,2,49,89,9,111,24,84,8,159,30,58,48,29,32,159,33,184,148,37,251,6,162,53,167,29,53,26,203,58,76,209,221,233,244,174,177,203,99,247,31,131,58,65,194,160,215,186,32,66,3,92,59,27,168,32,215,19,117,52,178,141,59,94,111,238,175,119,255,215,28,58,132,9,26,70,197,90,233,7,36,106,78,134,176,132,170,114,66,33,175,170,233,102,20,17,134,99,124,1,19,216,138,55,236,156,173,198,84,66,157,13,163,118,219,62,219,61,253,218,186,185,255,28,53,240,210,106,252,143,65,42,160,166,27,13,232,209,160,163,159,252,26,172,97,83,36,41,122,245,208,111,246,119,83,56,16,208,91,116,146,24,129,125,158,122,225,19,184,227,107,165,80,148,23,243,194,17,252,27,251,83,204,36,47,57,51,222,184,117,150,183,130,8,147,150,148,119,36,223,97,103,163,115,154,209,242,53,79,181,66,149,124,232,123,48,114,130,237,32,222,22,18,23,102,74,198,50,252,95,246,66,81,161,55,242,1,196,100,200,248,138,123,171,131,143,94,141,179,215,246,150,51,38,236,151,218,221,51,166,198,108,42,169,7,229,86,125,211,16,149,209,145,163,219,196,225,36,134,8,123,166,168,255,21,243,33,103,220,150,217,61,62,67,14,139,221,178,241,170,75,89,142,192,98,249,102,191,40,108,224,144,45,144,223,183,20,153,155,154,170,42,167,88,78,169,203,174,9,116,58,34,163,125,177,94,38,165,16,126,3,248,115,60,188,140,181,30,235,107,66,187,229,132,128,46,110,41,242,50,160,252,28,162,137,28,201,102,211,119,39,127,236,121,160,87,201,56,105,205,6,68,156,147,163,193,124,111,125,10,23,238,66,235,46,31,100,202,166,93,20,221,6,247,119,32,157,231,237,84,205,107,88,28,113,148,45,140,81,235,119,194,61,132,186,215,187,108,73,37,31,111,77,255,163,43,189,69,186,170,238,224,172,165,129,144,149,40,105,113,240,153,48,196,225,26,117,150,85,209,28,53,76,20,64,253,135,111,201,181,209,23,128,142,13,202,57,248,151,19,243,58,100,223,92,233,193,55,211,229,69,98,148,211,88,175,51,153,93,41,190,230,136,188,150,97,33,208,28,196,174,140,60,171,236,10,166,192,248,251,55,243,247,43,212,171,12,63,26,43,171,164,109,93,197,18,32,86,239,92,111,156,200,50,33,232,182,102,139,70,11,112,158,20,39,225,243,122,59,181,188,83,102,130,118,201,80,133,86,226,221,236,198,77,118,155,186,144,90,209,254,241,111,192,112,192,70,37,153,5,188,153,17,255,98,239,211,52,130,89,234,30,82,251,203,233,123,149,54,10,161,76,171,38,161,100,25,238,175,23,175,109,217,167,12,132,126,87,99,172,59,86,251,228,217,209,134,94,232,124,107,250,11,177,74,210,202,226,217,48,163,165,177,168,48,181,4,108,143,148,202,48,161,57,255,83,60,157,253,202,228,247,193,132,195,74,199,29,95,180,202,166,236,0,120,8,54,128,133,52,22,253,165,191,23,218,244,76,6,220,184,63,73,0,83,10,98,226,65,134,116,198,149,32,182,38,162,164,168,154,238,85,201,195,251,152,140,119,35,88,208,246,75,242,21,19,80,131,87,28,41,118,185,115,178,108,252,178,171,206,55,211,247,201,196,101,53,251,148,173,215,122,203,245,13,214,175,52,55,166,207,12,25,126,97,249,19,33,86,17,112,30,162,202,235,102,43,7,199,203,85,167,81,157,3,139,73,72,216,149,234,5,150,202,218,115,135,6,37,35,135,108,198,222,254,102,135,209,180,246,37,238,248,60,63,183,198,217,97,139,128,58,129,146,50,207,79,74,5,68,39,14,49,134,206,2,42,237,89,173,197,52,186,131,132,150,54,42,239,159,249,185,31,9,153,22,81,50,168,141,125,189,116,186,44,224,42,150,85,134,99,33,51,105,201,68,63,40,172,87,27,88,227,121,2,135,107,79,206,212,79,232,216,33,22,212,53,217,38,158,0,119,215,108,235,29,201,179,72,169,246,72,30,232,162,23,23,24,69,221,43,203,98,145,102,225,114,51,163,239,127,90,130,3,120,197,250,23,81,29,218,86,80,22,202,36,235,238,156,230,132,59,118,60,105,106,223,208,15,98,164,59,4,188,214,92,253,88,74,239,166,96,91,79,75,254,161,230,71,69,6,102,225,115,47,159,30,4,218,194,118,42,216,250,44,123,250,251,78,95,241,14,243,99,4,195,113,112,165,220,15,90,122,136,191,192,24,132,190,122,164,244,31,249,64,210,73,95,181,6,138,144,172,89,254,207,7,116,178,139,183,154,13,37,57,37,26,24,48,186,117,121,146,38,181,61,159,6,211,252,113,129,249,129,206,122,26,71,29,110,136,24,235,95,218,38,225,75,39,99,44,251,33,58,85,77,194,228,209,187,24,253,100,106,120,145,230,146,116,90,130,74,111,176,63,127,103,6,8,88,95,133,45,42,231,80,102,233,87,25,195,169,196,25,223,149,188,77,255,147,254,108,207,17,17,141,151,251,14,220,162,209,8,195,132,26,22,26,132,86,164,119,107,125,76,230,243,244,75,191,103,100,226,131,32,226,42,54,248,53,58,42,80,74,146,197,228,12,82,182,112,22,188,50,3,28,137,51,94,204,11,86,211,230,6,115,75,39,172,50,29,140,138,16,187,233,193,144,181,164,98,32,142,127,115,236,109,87,241,64,200,71,38,78,52,10,21,252,7,61,145,106,86,11,55,211,92,224,56,140,35,203,198,122,56,105,174,146,69,136,43,142,254,216,82,219,127,198,100,165,113,168,236,79,15,137,235,20,200,215,156,254,71,167,78,136,143,68,100,60,35,79,115,112,45,64,112,194,98,255,129,93,90,123,104,242,143,28,214,119,17,224,224,169,24,8,150,97,24,91,1,202,77,43,232,64,99,175,199,243,134,125,216,253,45,159,246,192,254,28,133,30,121,147,140,15,80,159,92,255,252,100,50,48,137,112,106,64,38,175,198,201,28,58,32,154,149,18,79,191,118,21,128,187,13,119,114,159,51,87,243,7,110,135,231,205,251,78,52,190,52,82,51,117,151,34,80,19,220,152,237,88,7,37,133,44,210,35,248,11,172,64,164,239,238,162,11,8,64,234,199,193,85,54,220,47,48,200,68,183,128,39,208,235,127,195,210,89,190,254,250,247,138,90,144,190,58,6,245,192,145,205,164,203,2,186,29,224,54,81,171,231,106,85,122,204,158,98,6,250,77,117,21,66,170,90,92,163,213,84,57,153,104,175,112,144,168,247,218,97,84,228,92,13,127,168,240,170,247,114,18,247,51,132,157,216,250,132,69,209,100,103,230,102,73,245,36,139,71,21,117,60,120,67,125,98,238,37,208,76,146,231,17,101,117,156,121,112,31,242,84,92,14,186,231,219,74,50,102,28,229,89,182,76,224,142,10,39,124,89,21,179,215,163,62,189,62,102,125,108,195,153,6,60,253,10,149,156,74,15,241,151,103,99,91,73,52,57,19,249,240,240,171,36,214,14,81,54,95,67,190,176,23,154,175,228,145,234,28,168,155,196,169,202,118,180,206,200,99,117,209,210,74,17,132,50,134,95,117,0,196,233,99,16,225,100,32,75,250,198,118,223,23,15,222,132,88,253,3,97,112,235,164,211,36,1,130,28,234,92,56,168,3,59,250,83,250,137,17,246,216,95,79,136,230,121,7,19,17,21,57,20,222,135,105,46,213,164,50,155,225,188,47,73,239,206,215,112,250,58,47,252,125,230,73,43,203,165,245,78,170,213,124,153,69,56,193,141,225,186,204,171,56,207,169,98,17,136,250,199,45,132,24,171,46,208,123,34,18,216,125,159,236,35,159,109,13,67,29,207,82,94,106,68,107,148,13,180,150,21,251,67,53,215,190,252,138,66,153,228,170,145,129,151,182,164,203,39,233,249,212,254,38,147,190,31,58,70,156,202,193,145,191,223,152,28,181,231,153,19,100,42,107,110,22,251,77,40,149,83,97,183,80,214,142,87,67,17,176,5,54,31,164,125,245,202,157,180,225,236,27,79,64,237,236,191,34,105,62,22,164,35,25,208,207,228,199,92,152,18,213,11,102,193,6,196,19,157,224,42,187,108,82,117,113,240,0,33,26,219,117,92,116,132,218,167,241,67,233,43,70,64,240,31,91,50,3,212,162,113,83,248,35,226,212,232,234,146,222,104,103,167,31,166,85,0,199,74,219,186,47,93,12,45,113,40,234,30,105,180,19,160,38,6,254,221,231,254,130,188,184,194,234,34,38,151,246,192,154,233,70,62,60,37,45,8,89,228,229,51,231,237,87,103,108,204,201,90,178,155,85,247,220,125,42,108,33,55,192,104,27,42,218,113,16,92,61,242,74,15,97,162,242,96,178,218,117,212,75,144,188,64,131,21,196,114,31,86,110,114,45,1,152,29,177,139,32,107,12,54,150,203,103,179,45,171,230,85,176,178,177,5,221,79,91,23,105,111,43,135,135,90,119,235,206,36,51,86,167,118,206,69,124,20,106,109,185,182,234,253,202,67,110,189,73,229,175,66,237,178,80,98,129,229,26,58,38,235,5,8,136,150,183,46,192,103,230,19,68,89,170,102,9,101,203,158,50,246,135,14,103,74,185,239,14,21,201,38,93,115,27,146,159,116,184,232,177,141,81,113,36,121,227,202,193,22,146,75,231,116,204,9,175,94,215,112,26,130,162,230,28,53,0,99,61,221,6,18,103,24,131,28,75,4,106,48,70,54,217,45,65,150,172,176,255,15,174,101,236,250,128,40,194,66,156,76,99,185,91,106,146,96,179,137,237,51,193,238,184,201,241,240,82,143,32,81,145,238,66,123,234,174,227,87,201,0,28,140,197,192,2,119,156,75,116,31,228,62,13,162,37,252,229,9,91,248,245,227,18,198,223,252,125,100,217,163,87,58,127,246,97,29,87,158,131,169,174,36,79,138,237,116,7,26,147,135,40,7,216,245,92,39,142,86,219,123,111,199,20,81,176,107,68,14,23,32,211,225,159,152,198,136,171,184,176,114,50,61,202,4,83,10,44,224,115,243,231,190,200,89,10,79,216,248,237,34,67,63,61,160,21,193,76,158,106,28,189,204,243,211,161,120,212,27,168,34,100,255,229,209,128,140,159,225,46,57,21,153,249,233,163,55,182,65,58,162,68,218,117,21,127,204,162,244,180,20,208,67,246,165,48,184,52,99,177,40,147,154,153,128,77,108,53,183,116,108,187,184,69,193,69,241,61,91,164,156,96,224,115,77,202,119,215,147,174,211,130,184,21,173,243,168,143,255,4,104,238,95,8,174,199,227,84,2,155,50,98,95,244,16,221,1,72,130,21,120,208,168,136,202,47,77,39,233,1,205,41,88,165,222,174,197,31,87,144,122,96,67,126,14,184,49,181,105,171,156,140,90,40,77,203,12,172,160,99,178,109,209,37,54,186,127,25,145,6,187,173,242,94,126,71,167,240,144,100,124,151,90,185,237,9,123,164,214,138,99,107,140,94,99,22,71,33,60,170,109,215,30,228,118,132,95,16,38,170,159,11,226,249,49,145,110,152,182,215,94,165,96,67,54,233,133,48,142,244,67,48,200,125,230,213,239,100,2,9,55,223,208,56,30,57,76,53,105,175,27,196,18,15,94,205,12,149,251,3,154,237,248,141,198,144,210,53,104,157,233,57,135,2,95,216,171,178,128,240,203,179,13,128,73,202,217,196,245,84,105,190,112,114,246,242,68,228,221,76,217,208,162,187,43,245,21,179,195,84,204,85,113,202,250,225,34,13,28,169,19,74,120,13,227,102,227,19,161,142,30,83,178,44,215,54,246,221,212,41,73,71,203,46,196,238,129,45,5,54,253,67,132,154,217,174,156,160,163,102,200,74,243,50,144,211,66,177,253,123,54,143,51,23,108,29,47,159,250,65,123,6,190,177,10,152,198,221,117,190,156,140,50,50,74,205,169,36,142,244,11,89,15,128,70,148,175,38,14,26,164,191,101,237,158,5,163,46,60,47,52,129,124,200,217,22,184,169,139,209,101,87,243,181,211,249,99,206,210,129,247,95,21,133,150,216,48,83,62,13,164,115,49,154,67,135,13,150,16,199,119,77,210,31,37,84,34,59,29,226,244,239,212,78,127,40,164,90,111,214,97,90,184,78,73,58,85,162,189,2,122,148,226,41,158,222,147,127,19,31,15,220,172,75,125,174,44,6,104,23,252,128,50,134,146,121,62,91,252,106,67,219,77,64,249,99,43,80,114,125,1,83,145,218,194,170,9,52,63,182,39,91,240,236,234,61,7,210,218,179,10,167,233,172,48,193,159,19,137,189,89,219,224,177,236,57,165,29,25,57,112,163,102,140,218,104,49,137,241,133,235,163,87,118,238,174,206,130,53,16,236,110,146,12,185,186,85,88,161,144,176,229,222,35,13,139,9,79,213,192,249,143,106,69,184,167,166,104,149,247,75,98,159,243,76,128,47,246,252,79,210,225,184,31,110,56,196,133,185,149,24,46,188,9,232,124,92,30,34,97,135,15,100,213,104,56,77,143,246,7,245,255,0,2,201,56,180,63,175,229,134,202,87,83,41,27,141,47,6,31,189,107,150,162,118,68,35,57,136,147,205,241,148,254,129,0,171,108,65,137,29,198,178,60,123,115,13,241,174,229,198,116,142,157,251,40,183,51,244,44,45,253,59,3,159,162,199,157,6,238,227,49,240,170,79,21,146,68,202,21,42,4,118,98,159,193,140,6,155,139,45,218,248,57,121,224,10,195,24,228,175,139,52,86,32,206,79,130,159,6,92,83,64,89,40,31,31,196,103,240,20,151,182,78,158,246,220,0,13,235,95,118,62,4,5,153,113,47,199,6,207,164,242,112,150,109,46,121,189,153,160,166,205,225,92,148,88,81,98,18,185,165,200,135,161,32,64,225,37,246,9,39,70,66,111,237,232,189,70,90,221,110,192,212,104,146,188,200,151,220,103,111,112,57,195,229,237,142,34,234,35,54,75,14,170,225,46,54,16,187,46,10,57,217,22,69,92,131,66,162,215,76,207,99,40,16,92,122,208,255,4,222,117,252,182,26,87,183,228,30,168,23,43,39,213,119,137,87,210,140,177,60,101,230,36,84,70,53,212,200,159,0,250,188,108,108,175,86,182,124,215,250,111,44,238,50,16,72,248,222,130,0,39,178,18,244,193,178,230,110,133,70,65,232,80,172,52,46,222,133,110,155,127,147,25,203,85,3,241,248,182,121,63,182,235,149,218,192,198,33,229,239,200,96,34,218,52,0,197,130,174,237,46,205,126,77,214,158,191,142,29,211,67,154,236,46,226,244,171,74,107,7,173,197,208,217,142,162,74,240,13,28,19,158,61,251,14,110,6,177,251,59,1,76,101,153,143,133,174,14,32,110,190,103,56,143,125,50,61,32,14,161,6,175,53,253,5,74,147,76,50,206,15,191,196,137,194,83,217,14,250,192,90,42,229,18,99,158,88,8,136,106,90,133,253,31,41,147,206,53,165,13,244,91,177,78,253,237,250,115,220,10,203,203,78,0,3,93,18,34,223,157,180,235,102,187,42,184,203,226,129,139,84,214,239,87,226,215,69,233,44,238,113,209,216,193,215,141,207,99,45,40,103,249,245,67,208,182,50,36,192,138,79,41,45,166,238,207,240,28,228,46,15,142,163,59,175,189,121,195,157,159,43,79,77,175,174,75,136,137,1,224,109,169,223,192,189,227,204,150,19,138,210,178,26,251,87,215,46,67,34,118,230,5,215,114,77,61,138,144,59,134,253,251,27,144,81,180,28,37,132,178,85,191,173,100,89,58,210,130,180,129,144,174,47,146,71,170,29,161,5,3,96,185,152,147,36,199,228,197,66,24,195,193,24,200,191,210,47,203,41,107,118,20,146,231,244,86,62,229,125,9,72,192,30,121,26,141,52,53,234,62,55,24,60,40,222,176,239,209,98,62,207,191,207,6,57,185,47,96,136,143,178,79,29,247,37,153,228,130,151,104,111,128,123,141,189,247,254,197,123,121,94,176,68,210,145,88,70,31,203,158,101,179,230,234,202,225,42,217,26,97,47,151,51,176,204,189,116,16,86,168,170,224,14,120,6,185,160,145,159,244,241,25,101,137,53,80,88,247,58,190,22,101,61,176,186,187,10,11,183,94,148,88,228,220,252,207,70,197,206,227,84,102,180,235,7,177,81,40,9,249,116,214,216,32,235,134,173,48,160,90,185,22,38,183,159,59,121,115,229,131,199,130,101,141,48,171,219,254,165,153,155,30,3,97,197,119,131,45,218,77,58,221,236,33,116,231,241,183,17,2,28,206,93,148,195,104,230,229,254,57,190,191,42,198,114,2,196,145,32,101,30,107,62,31,70,187,17,62,46,41,216,66,20,45,111,203,22,169,94,74,255,99,93,199,245,129,214,51,99,219,109,235,76,59,244,107,124,138,178,246,153,25,49,173,71,44,160,4,164,30,219,144,54,84,131,166,6,135,242,33,168,62,54,139,173,155,173,79,105,165,23,21,171,43,145,168,105,126,220,115,45,7,53,87,23,88,86,255,32,207,74,243,62,227,117,193,198,140,105,153,249,24,230,164,43,135,13,88,60,24,222,183,154,154,196,98,210,1,79,163,66,7,206,89,252,160,22,72,28,104,177,253,199,33,33,191,247,52,90,90,115,8,159,155,126,0,46,108,73,122,40,218,77,107,204,214,41,116,254,162,216,26,229,11,58,62,220,138,245,221,140,193,188,211,249,211,127,232,177,227,9,123,187,2,151,50,145,198,47,88,111,196,158,156,13,240,207,5,144,169,85,190,156,40,92,61,184,152,109,13,149,218,168,91,182,13,106,164,31,85,194,15,183,60,2,179,135,228,102,7,119,69,52,24,238,236,192,245,213,181,31,149,237,243,93,228,7,109,67,180,104,53,97,198,234,25,12,215,70,72,229,170,148,5,73,66,61,202,146,70,126,33,176,222,0,252,89,91,238,4,33,192,197,164,148,14,28,245,203,116,187,157,165,69,32,193,169,177,234,22,226,241,70,155,49,213,28,63,202,173,98,230,7,169,209,205,228,31,197,199,56,235,82,28,39,188,224,242,210,94,82,177,50,231,213,114,160,220,32,194,36,104,238,125,123,186,120,168,108,10,72,86,212,203,9,58,74,26,107,106,238,234,156,78,68,158,99,184,143,136,66,238,124,16,203,188,19,22,243,49,170,23,34,44,42,246,114,165,51,8,243,22,185,125,93,85,91,252,219,250,212,20,131,252,71,212,228,197,191,222,233,198,13,131,192,129,21,233,129,110,105,174,14,112,63,223,255,172,149,211,98,84,188,149,222,225,85,254,22,133,224,35,67,40,99,224,71,94,128,57,124,109,86,11,255,8,118,73,180,124,244,19,155,137,251,158,213,27,248,43,92,66,231,241,156,219,239,201,125,202,226,231,185,38,110,72,113,68,205,212,133,205,89,54,197,232,232,88,187,8,85,32,93,81,117,196,141,119,37,157,121,118,161,242,246,6,14,58,96,34,80,227,20,191,148,175,195,176,86,23,201,34,28,202,142,219,173,182,233,154,143,162,52,191,16,37,6,113,60,38,222,171,65,106,160,33,137,163,127,114,16,190,130,102,159,19,87,228,49,120,65,220,191,7,45,222,0,20,124,197,39,176,48,103,49,65,159,235,134,16,155,203,65,35,75,253,105,205,95,196,166,242,3,193,10,242,97,132,149,133,40,31,159,58,187,131,230,144,190,117,186,22,148,64,212,137,138,250,131,254,44,235,236,89,219,142,66,96,27,252,152,223,154,8,83,113,136,199,214,214,65,235,155,103,53,196,124,85,32,111,170,74,241,123,214,53,42,131,19,55,79,55,227,79,163,94,62,255,137,225,48,133,112,60,61,146,233,220,108,104,33,142,26,167,66,245,19,119,164,216,210,206,12,232,163,231,224,186,10,106,165,86,34,10,142,146,147,67,150,115,63,80,168,191,176,103,176,153,68,169,105,74,167,133,83,210,118,129,140,164,46,113,111,102,226,101,104,9,75,246,243,201,65,78,68,127,86,175,217,79,105,250,90,65,0,197,48,116,160,212,201,35,76,198,111,226,192,98,255,31,103,100,39,86,243,136,12,174,8,25,182,101,89,103,223,55,55,214,38,131,121,191,41,74,229,93,131,248,213,213,168,57,233,77,42,44,233,38,131,239,23,165,5,252,90,238,106,188,49,9,104,29,45,76,22,78,242,167,222,93,215,104,46,181,102,43,225,108,248,158,89,158,123,114,67,69,167,28,22,44,21,176,190,53,159,220,86,114,87,20,181,91,114,49,227,9,197,16,114,249,35,87,112,127,246,173,201,118,26,213,79,157,56,235,176,93,133,172,168,173,233,140,209,38,190,199,92,88,223,168,224,239,147,194,52,166,88,10,22,29,141,242,177,63,236,99,197,98,165,242,27,131,114,19,199,156,207,140,39,145,190,116,240,205,118,140,205,179,38,222,113,165,85,4,131,190,138,16,211,9,149,5,77,230,248,48,27,17,50,40,46,53,236,226,38,58,39,191,16,88,1,223,140,184,90,52,153,21,234,92,110,11,212,199,90,60,80,149,93,114,92,141,190,41,220,55,245,5,185,35,139,192,223,163,250,74,199,155,149,113,248,182,165,68,238,187,254,221,116,69,130,236,105,18,143,83,104,95,152,74,121,178,112,125,88,253,69,162,49,53,88,24,77,206,202,27,134,240,177,246,127,225,173,135,108,236,36,199,89,232,148,122,168,226,5,63,151,71,178,177,159,22,243,202,42,244,188,215,128,125,89,246,24,211,229,176,46,9,171,144,224,192,77,141,18,118,116,195,31,189,139,158,208,251,3,11,223,245,236,86,16,86,35,65,177,64,147,220,101,101,28,105,130,164,169,158,116,38,56,238,162,176,152,190,11,151,85,161,80,219,161,34,22,49,0,192,220,5,26,52,180,165,125,227,90,108,234,241,130,1,149,215,126,73,212,140,211,122,71,237,133,72,141,56,163,9,111,32,120,91,250,185,71,122,216,213,213,67,82,119,126,84,253,73,61,251,194,209,205,92,45,10,223,176,135,104,19,24,27,224,85,155,186,246,138,90,73,192,114,128,78,193,54,200,101,217,69,51,127,120,161,161,216,250,140,98,126,249,112,145,172,211,35,16,231,99,216,251,134,218,160,255,247,93,15,144,68,205,237,129,182,42,50,237,110,79,163,33,53,68,228,174,221,225,223,100,160,184,50,240,244,132,230,54,209,58,108,201,129,120,124,10,184,157,113,236,189,70,77,238,61,51,222,87,163,26,176,59,250,213,233,230,138,35,53,96,85,251,206,240,211,13,10,90,236,232,156,134,255,119,147,81,221,87,203,152,120,179,8,152,2,172,224,39,50,95,13,6,12,116,254,226,127,102,208,129,121,95,0,61,204,152,30,104,7,237,216,206,72,184,74,21,63,199,56,103,34,34,102,144,83,53,1,161,182,217,142,123,87,31,48,153,109,219,12,1,24,126,139,62,150,8,68,161,181,13,17,150,161,134,120,238,85,57,245,111,27,167,69,175,232,91,200,125,191,90,163,159,117,224,150,249,192,26,68,30,71,214,141,213,60,63,152,250,73,246,27,52,248,206,231,146,121,165,164,18,208,164,17,147,131,253,71,152,118,200,64,114,96,113,186,135,180,228,193,97,187,195,119,12,174,43,125,9,169,65,91,109,146,173,213,1,110,98,131,78,34,117,20,120,54,120,85,120,189,148,60,126,255,62,246,10,69,126,211,20,125,22,158,59,237,70,4,27,161,61,192,189,204,163,176,34,248,1,123,211,139,140,90,11,45,139,105,35,255,27,55,12,143,48,75,235,230,209,253,59,77,226,140,208,219,133,28,140,254,93,59,28,141,175,59,36,2,160,29,49,44,218,39,16,120,159,118,6,19,180,89,248,168,133,173,122,172,150,97,183,158,71,244,190,120,200,157,154,15,68,19,130,89,252,72,121,97,106,160,184,53,197,189,42,127,83,233,228,175,70,242,15,83,191,184,104,230,57,222,88,114,125,118,51,80,17,44,111,167,13,245,30,226,217,182,201,242,229,24,166,179,243,216,89,210,71,32,171,7,164,109,35,232,208,39,36,155,23,119,145,86,21,4,68,3,228,83,30,190,177,242,239,196,242,128,134,216,83,51,77,108,246,23,227,179,134,211,38,4,130,159,232,124,6,254,9,254,210,32,90,229,198,207,187,86,101,191,205,157,161,40,131,192,196,129,240,194,246,23,120,57,106,158,91,206,114,69,45,236,139,81,100,252,77,127,48,66,49,126,211,197,110,36,25,148,192,120,87,175,122,85,43,112,56,190,72,77,252,19,18,193,39,122,59,12,89,3,38,8,61,27,16,226,41,61,169,136,154,35,173,159,204,146,95,55,65,172,191,15,155,69,19,2,237,205,166,164,144,53,254,139,138,84,249,214,190,95,29,75,228,121,69,218,57,24,70,149,216,229,231,201,60,120,120,103,101,13,250,231,180,132,5,14,162,232,231,2,41,95,44,229,136,26,159,82,210,212,118,1,184,163,134,254,203,76,35,40,140,91,152,230,65,74,169,116,112,148,154,221,151,34,230,248,7,0,59,144,192,12,155,180,32,136,207,187,48,33,154,133,93,105,34,136,28,17,230,2,8,137,28,173,0,134,243,158,127,161,14,154,123,120,235,75,6,33,105,84,168,96,159,221,96,159,125,173,239,214,64,11,162,240,249,242,51,60,243,205,94,130,7,176,152,169,189,253,78,76,249,74,37,102,67,164,60,177,6,227,139,52,45,137,118,155,59,156,164,8,67,205,75,207,22,182,169,248,150,173,239,122,199,17,159,195,32,162,10,126,148,240,226,227,233,206,42,59,189,162,48,137,147,143,38,183,111,60,56,87,176,48,21,117,75,112,116,54,140,211,77,79,85,21,43,14,218,94,43,148,172,58,197,93,153,168,25,30,229,3,180,167,251,145,53,177,206,171,87,73,192,101,75,90,127,4,121,4,130,99,80,42,213,53,120,42,67,234,251,184,93,53,33,14,189,202,65,225,225,6,155,72,118,189,252,159,196,36,54,250,154,192,88,8,59,114,35,33,198,111,133,37,30,15,187,120,165,182,48,155,121,107,167,68,210,19,209,241,150,142,227,145,180,40,62,236,73,4,134,188,109,95,45,72,168,49,202,144,56,173,192,130,190,111,139,56,247,122,71,229,170,196,155,43,4,123,64,93,28,205,18,111,112,83,130,130,60,187,165,86,147,61,167,185,183,2,86,45,108,177,177,204,31,172,104,167,196,4,189,86,53,248,124,32,220,165,228,40,247,70,252,135,123,130,117,97,85,105,23,177,3,198,187,243,211,73,56,164,104,167,107,2,244,98,10,246,126,235,233,165,144,25,255,177,118,45,36,188,27,92,255,198,19,171,22,144,106,147,132,86,62,155,25,27,114,173,168,225,251,6,112,87,196,126,131,43,247,205,154,152,217,215,167,125,143,9,254,248,222,147,192,235,28,139,105,223,111,15,55,26,63,170,160,200,207,19,183,22,179,33,235,37,126,155,143,75,38,136,176,109,41,176,239,255,130,129,110,140,149,215,202,48,163,48,193,249,142,241,49,166,192,50,240,32,93,112,145,23,184,27,24,241,63,158,87,12,37,117,16,186,110,229,177,41,199,100,141,167,126,178,151,107,51,71,61,252,13,219,137,25,212,163,238,95,179,62,65,76,113,95,194,114,116,150,183,15,204,104,131,102,122,235,64,57,42,128,246,148,101,191,141,8,230,123,142,232,153,103,212,204,115,61,250,207,23,112,38,167,24,167,117,147,175,50,31,211,219,93,174,17,200,217,198,129,139,240,36,103,59,108,97,241,27,215,60,211,189,83,144,162,60,184,96,174,171,56,3,219,138,227,6,11,3,216,213,58,42,136,233,203,90,231,155,170,171,209,252,100,161,72,39,13,32,109,204,220,217,149,236,75,251,93,158,62,32,8,238,2,133,128,4,73,60,75,1,121,80,163,129,247,219,196,135,182,126,121,251,216,200,105,202,184,183,112,76,73,223,65,229,208,145,53,122,171,247,92,71,164,145,166,92,140,143,3,155,245,12,159,150,116,184,82,115,131,38,220,125,170,65,238,144,147,167,161,248,164,174,180,202,11,213,47,116,140,190,119,181,160,96,211,27,66,197,151,152,210,249,111,72,165,168,105,162,141,211,95,87,242,211,241,224,171,205,134,112,147,139,195,203,134,241,174,175,184,119,184,223,27,232,228,246,224,66,84,114,194,29,22,162,142,66,142,187,9,130,148,248,166,38,191,122,51,122,150,41,3,237,15,247,86,41,124,16,163,124,47,215,139,151,228,47,114,77,78,111,77,107,204,211,43,56,203,177,39,71,233,75,88,183,161,241,52,113,107,59,168,95,141,132,142,70,62,173,187,41,98,79,145,173,81,28,146,216,165,163,22,147,74,18,9,32,76,105,21,252,242,238,160,14,145,75,40,13,97,246,232,98,214,128,0,27,189,64,129,63,172,217,143,172,70,65,79,70,14,71,126,153,131,248,231,103,109,107,158,4,9,104,181,28,162,144,84,62,210,177,23,127,138,15,18,209,118,238,91,185,155,108,190,69,58,7,144,197,241,87,197,37,167,26,52,178,183,158,46,83,39,195,200,44,221,100,222,102,234,228,27,132,56,242,247,193,3,163,11,141,248,178,31,59,51,202,39,30,134,53,84,38,186,42,2,52,80,39,61,41,108,22,197,16,239,215,5,27,136,187,200,201,237,76,63,234,32,104,211,138,199,231,14,131,31,128,144,23,211,112,173,29,46,43,56,170,117,156,110,70,203,189,134,179,212,39,28,193,206,213,97,208,193,180,178,164,233,190,113,122,73,59,222,79,215,153,88,99,243,79,38,98,80,11,105,215,76,224,80,120,186,53,172,95,108,168,42,64,110,18,75,255,17,60,80,210,127,53,253,41,37,69,180,94,240,1,209,72,192,200,244,125,114,80,203,65,96,43,15,1,214,99,0,87,130,93,149,238,224,255,222,26,77,12,11,5,147,102,185,85,209,243,14,105,188,30,226,191,182,181,227,188,154,24,121,33,205,215,199,243,175,66,34,60,43,114,253,2,157,216,88,100,62,154,32,229,139,100,57,109,29,155,106,130,253,217,171,81,199,74,115,244,96,46,81,206,146,180,1,211,26,8,149,37,43,100,104,174,185,56,52,233,48,91,85,104,223,195,137,44,24,190,117,200,67,252,173,155,144,128,65,226,180,182,254,163,118,252,31,234,87,106,33,82,219,143,113,165,165,129,63,147,61,85,171,241,129,239,11,248,91,24,53,34,107,153,119,186,206,248,121,83,116,97,172,87,85,239,197,162,134,132,90,118,15,4,37,107,147,30,33,8,91,159,175,45,139,239,4,78,44,145,39,102,12,245,95,58,160,65,174,147,217,73,31,197,185,116,71,137,159,34,51,87,185,230,244,166,117,60,8,156,137,74,230,23,209,20,45,229,204,2,17,11,49,144,103,204,227,200,88,178,9,184,172,218,63,139,7,246,230,251,255,194,147,193,182,69,114,76,123,121,158,78,202,56,68,194,188,7,86,239,180,223,60,142,239,240,247,188,19,150,184,192,29,145,177,148,40,237,232,131,31,91,90,34,69,152,149,39,49,52,220,87,32,95,7,76,141,232,233,241,13,176,213,131,169,142,60,122,34,142,69,250,7,238,199,216,128,192,248,131,53,147,152,192,42,93,110,68,54,155,63,13,199,211,61,162,138,167,237,172,69,242,238,41,255,50,65,26,99,140,199,82,111,95,177,20,200,69,183,170,230,46,235,172,132,82,38,219,0,49,97,137,218,191,13,205,128,74,65,123,171,78,87,233,69,50,3,4,135,244,253,237,205,177,148,162,237,199,201,89,83,246,174,124,227,220,17,46,121,129,71,18,54,17,13,174,215,167,244,129,123,246,78,35,173,114,127,175,148,115,232,180,32,210,50,18,29,208,19,12,43,22,241,40,212,31,124,121,93,104,203,200,218,154,206,72,1,8,12,160,89,127,237,174,182,15,194,35,20,86,21,182,192,114,27,185,44,28,2,194,245,105,48,226,234,30,202,108,210,145,149,204,55,188,220,111,5,57,15,72,15,129,129,169,192,202,94,227,186,38,147,67,79,132,15,78,131,156,165,241,212,79,229,167,225,42,91,208,130,176,97,147,200,81,233,56,84,18,1,1,156,96,148,35,252,114,166,218,140,65,181,107,199,199,15,205,48,203,159,164,253,236,195,62,176,177,160,161,20,15,80,95,74,181,231,100,55,184,28,123,130,72,151,46,125,77,47,87,159,134,228,180,203,244,146,227,143,121,29,110,102,200,229,197,238,248,10,106,239,46,126,164,198,160,236,12,195,44,216,253,50,211,225,65,234,87,138,79,186,236,28,71,156,114,121,224,161,195,88,162,99,59,8,54,153,14,63,78,17,133,91,224,93,60,115,46,135,238,51,30,243,157,64,226,148,1,102,157,245,65,16,213,194,100,95,214,188,32,232,109,113,149,176,226,234,23,214,212,73,136,64,254,145,13,55,228,21,228,35,201,129,35,167,76,35,62,23,92,34,228,187,75,158,72,103,230,194,3,185,123,220,220,126,126,251,209,212,30,233,91,144,198,208,189,42,39,54,140,79,139,190,94,116,71,40,175,97,75,170,223,71,147,130,142,21,160,211,101,15,41,179,116,133,138,238,186,47,40,33,162,54,21,172,48,170,193,151,101,19,67,115,212,210,7,52,84,190,199,21,99,159,197,56,60,252,250,41,227,149,134,15,20,41,147,163,35,38,49,119,40,80,224,180,148,177,203,223,39,99,207,123,134,56,85,249,108,76,213,60,111,87,153,36,148,170,65,148,231,32,37,168,82,115,112,54,10,13,161,41,77,137,51,41,185,173,171,185,115,4,104,244,61,220,128,45,30,178,147,175,144,50,241,162,237,66,168,46,114,197,190,64,157,163,81,100,134,15,12,231,187,152,149,118,77,16,161,99,7,67,23,28,143,73,7,77,251,106,200,211,93,65,45,226,148,12,228,71,157,44,91,5,49,49,151,249,129,135,236,187,206,49,51,60,175,191,54,132,41,234,16,116,177,48,77,69,215,2,168,80,221,15,119,209,24,220,191,233,159,38,76,230,184,206,108,232,184,91,151,57,5,107,151,84,43,111,189,229,117,163,11,54,16,134,42,92,175,19,20,116,61,74,254,176,200,52,133,203,169,22,198,87,53,9,166,173,55,96,213,20,94,78,1,190,28,46,60,36,186,31,5,128,122,250,121,65,48,173,194,62,76,198,195,30,11,149,122,181,65,55,169,253,63,228,123,251,71,116,51,134,131,228,90,40,93,80,89,188,73,14,67,179,204,96,36,75,71,166,67,21,219,89,101,81,100,199,120,198,224,197,159,114,39,230,32,86,246,76,188,155,48,37,195,148,47,48,12,4,12,31,34,177,29,113,110,101,160,24,88,143,207,131,235,14,224,247,22,59,151,98,27,51,73,34,149,179,214,137,158,148,134,197,115,232,125,124,74,49,105,114,140,130,153,127,150,219,45,227,243,153,90,214,30,92,123,162,13,215,18,77,121,30,83,28,72,18,215,93,53,63,93,137,113,192,126,180,6,118,107,99,213,5,87,255,160,56,151,228,52,105,198,174,178,101,250,173,146,240,197,239,167,184,242,14,57,146,112,206,21,218,35,157,176,150,179,252,118,101,133,181,178,107,94,182,2,115,169,59,78,100,174,175,28,184,250,25,103,193,229,67,188,53,192,192,81,42,3,20,128,25,40,21,96,232,123,245,125,56,170,173,249,146,86,205,199,82,65,187,53,243,207,241,62,206,232,211,176,144,105,204,188,224,215,180,148,93,7,232,166,198,18,14,86,114,242,128,250,137,149,107,227,14,122,208,16,145,62,123,149,248,58,46,148,176,85,9,47,229,84,138,168,140,224,107,157,213,44,234,138,19,139,170,191,124,248,239,188,44,240,161,233,252,57,221,168,232,187,216,133,20,230,198,50,173,222,25,108,81,207,143,73,154,181,59,136,219,169,18,91,175,44,188,50,253,236,164,134,175,81,229,21,181,130,36,117,91,218,221,173,118,40,76,10,170,137,226,26,95,141,160,27,104,17,188,7,185,46,182,49,195,4,112,55,14,110,104,17,224,68,141,51,214,116,175,211,97,171,187,38,102,126,38,229,74,141,99,25,71,94,39,75,85,134,219,101,159,58,46,125,207,250,31,195,208,24,110,3,79,157,75,180,66,127,197,56,116,138,230,227,232,132,255,192,197,217,205,89,232,53,214,233,7,54,237,26,40,167,184,114,145,129,149,249,14,213,77,189,115,34,36,38,61,230,254,58,199,209,188,62,28,169,154,82,86,6,182,216,13,35,183,71,18,29,48,172,32,62,237,229,60,191,103,94,110,242,162,197,112,230,32,88,191,204,99,131,68,38,25,224,223,24,162,19,98,50,73,41,227,131,199,39,193,66,196,140,239,51,14,4,225,251,171,19,203,246,233,56,178,89,157,65,26,236,31,25,29,50,105,238,132,251,63,42,150,222,178,121,31,204,23,107,94,150,207,66,191,168,134,12,42,101,201,89,62,87,215,210,225,252,75,21,162,187,47,76,251,5,177,216,164,145,35,254,201,51,132,15,190,159,200,53,219,118,183,161,146,144,82,107,9,77,112,208,95,254,199,53,99,76,55,202,248,54,209,203,130,129,2,26,196,206,254,50,80,38,32,78,2,28,16,26,203,76,160,161,96,59,40,233,3,234,149,36,197,112,38,129,20,110,151,58,234,40,139,244,102,250,235,191,121,28,168,206,13,153,96,214,64,49,219,167,55,103,19,224,186,67,43,129,28,3,198,250,26,151,19,100,230,152,164,62,158,219,133,231,228,51,198,13,28,127,233,60,23,179,66,229,104,114,53,254,2,218,59,217,213,77,26,245,79,166,229,111,106,232,155,104,6,76,213,108,242,134,29,222,158,111,0,83,212,219,212,99,147,126,42,204,153,205,159,211,21,76,235,232,108,243,94,35,13,152,218,115,70,200,188,119,30,15,249,52,109,152,113,241,43,34,142,17,193,63,121,162,69,205,140,191,86,179,109,139,169,19,22,165,131,41,247,175,137,115,148,28,85,47,88,29,136,82,13,179,25,21,185,46,64,96,86,50,18,119,159,237,119,217,61,78,211,30,142,168,89,184,26,22,24,46,17,90,39,205,7,164,131,10,48,216,127,251,100,43,182,240,167,153,149,47,218,143,17,187,150,55,198,165,0,122,69,74,122,83,47,18,51,86,115,9,121,62,105,235,245,254,125,168,2,188,65,255,217,116,144,99,48,154,250,180,177,176,158,35,145,163,113,26,88,69,151,162,16,109,142,251,233,81,195,177,161,42,179,29,101,99,146,219,151,101,93,78,183,26,231,171,114,166,249,151,4,147,206,132,189,210,136,47,177,0,74,177,26,128,207,23,144,168,109,4,203,154,164,163,37,61,6,88,43,168,218,0,33,111,240,201,24,98,34,226,254,84,147,158,158,80,24,78,5,5,60,12,29,76,113,211,35,134,220,181,34,238,6,79,87,166,239,245,107,158,97,239,177,74,182,184,224,64,104,188,123,73,116,175,169,36,197,153,213,81,141,166,91,104,253,48,234,105,30,110,221,209,181,86,156,225,24,81,61,228,126,86,56,183,232,245,241,81,140,44,207,191,58,89,245,60,54,141,164,0,145,214,229,172,64,106,53,144,158,172,78,252,172,155,188,72,160,170,158,44,13,91,121,90,12,99,176,97,18,181,151,165,142,234,219,213,167,40,171,41,203,212,72,219,8,13,191,223,162,138,224,249,178,127,146,182,164,188,72,47,117,64,83,126,248,224,123,91,10,12,109,160,130,169,184,153,16,162,114,237,191,129,155,40,74,76,77,230,82,188,92,75,130,153,215,81,93,58,66,145,207,145,151,238,72,3,162,93,11,51,0,65,30,166,218,98,240,211,152,151,124,67,145,195,107,173,224,129,176,237,60,35,78,237,71,80,144,195,30,61,153,65,246,236,73,66,34,139,174,73,120,131,235,125,108,159,240,177,33,40,196,200,79,164,223,84,23,4,76,28,48,88,215,73,116,49,113,120,158,228,232,230,232,1,168,249,217,132,167,175,150,192,100,70,87,183,149,255,125,160,133,107,123,149,109,186,89,159,163,5,142,1,3,142,138,183,210,92,169,46,166,210,189,9,217,75,198,161,124,247,91,41,127,211,145,238,205,220,152,227,164,196,195,239,40,172,143,240,69,202,86,173,12,85,58,81,51,121,243,35,99,77,151,68,5,90,205,26,70,193,144,118,50,153,142,23,199,184,198,21,218,122,209,248,196,118,68,85,4,77,252,101,134,76,221,164,235,44,222,56,247,176,185,47,138,236,53,46,190,225,64,44,68,196,109,84,148,244,132,9,57,86,130,218,30,194,129,196,103,88,67,164,117,226,206,185,233,47,156,248,28,154,17,87,176,147,96,137,85,191,81,193,176,112,1,200,125,129,38,110,230,156,40,226,233,53,17,244,124,104,87,161,11,188,104,88,42,183,130,130,194,125,215,96,96,4,242,28,234,152,172,43,86,77,221,50,169,1,142,146,24,31,38,79,79,25,70,31,125,41,225,73,130,78,161,19,67,81,4,143,165,228,94,225,50,50,37,230,115,59,112,122,30,65,245,238,65,7,219,111,50,206,200,19,224,165,79,177,107,221,143,234,248,133,125,154,66,41,218,230,90,75,127,175,247,233,47,173,121,123,0,121,46,133,12,193,120,13,149,49,184,141,158,180,155,79,32,17,160,86,227,95,242,45,78,59,255,139,179,129,173,226,233,64,104,88,252,88,11,153,124,246,33,95,127,114,224,128,48,162,179,146,184,234,182,36,16,160,47,103,90,62,147,4,231,128,21,220,45,103,193,0,36,252,173,179,23,171,228,30,67,51,139,229,251,139,228,125,21,141,185,226,134,52,184,220,47,35,23,90,120,6,153,245,27,1,179,76,239,21,33,104,63,57,138,57,201,168,182,167,13,87,50,15,152,113,152,197,166,5,98,153,12,198,63,219,192,151,93,157,207,252,218,62,68,37,92,62,7,213,250,208,139,67,204,226,241,147,255,163,200,157,62,251,35,225,192,191,246,112,163,62,147,172,211,80,42,59,25,41,73,84,10,19,93,89,197,204,84,155,56,54,227,20,138,99,115,105,57,245,61,65,235,13,202,207,180,206,201,203,73,73,244,233,169,189,5,113,36,104,33,216,84,3,254,76,22,124,187,180,177,133,236,38,200,240,232,94,57,119,219,223,61,226,150,214,241,52,206,177,148,154,73,86,103,127,137,43,231,32,202,10,84,40,164,52,63,214,80,199,111,166,252,245,27,9,92,225,248,85,41,135,177,95,193,86,108,235,226,135,117,212,199,98,172,86,190,68,78,43,11,142,235,244,2,30,105,17,41,72,111,136,43,167,15,23,193,117,129,209,96,13,173,51,234,230,71,92,78,217,178,136,93,9,252,118,245,216,207,111,168,32,25,106,14,241,164,182,118,22,50,9,226,177,15,247,72,13,13,88,48,223,33,235,140,179,1,223,51,59,67,91,186,148,36,196,19,224,0,155,217,114,159,80,97,25,33,52,10,203,196,7,185,62,122,128,45,64,196,86,145,121,81,159,97,236,70,126,77,255,246,45,61,253,227,118,223,57,196,72,11,25,18,108,225,176,251,70,195,49,107,66,130,54,125,168,159,84,46,239,181,211,75,148,245,240,132,238,7,123,120,113,7,211,228,12,17,84,211,239,59,72,255,13,222,107,34,69,133,183,60,120,196,120,14,185,89,106,177,61,128,86,228,33,76,58,247,94,203,135,155,136,13,173,67,44,77,244,196,84,6,25,12,217,66,119,229,12,208,8,129,119,210,208,154,147,135,148,152,120,236,214,42,32,253,188,109,15,215,51,18,180,249,77,13,253,87,25,228,16,215,214,149,227,108,50,178,100,229,18,127,68,52,86,37,77,104,87,102,150,7,244,183,91,156,119,33,19,55,163,100,208,178,209,131,232,208,106,62,116,246,176,204,208,109,18,242,196,252,111,196,237,80,15,194,254,148,231,136,105,254,47,250,196,217,180,237,75,131,87,197,114,137,20,150,208,226,106,191,189,146,28,62,180,70,42,227,152,216,112,247,107,216,217,248,94,204,170,72,177,0,23,144,141,37,134,45,122,229,83,164,44,5,182,240,141,192,193,123,70,185,74,54,214,250,183,135,29,137,244,154,197,171,150,74,231,200,227,107,232,155,165,49,83,73,65,97,183,71,123,0,3,113,160,78,150,119,19,89,32,228,191,133,81,145,146,125,235,244,230,143,90,36,165,69,215,96,75,64,100,132,19,123,54,13,178,97,44,196,131,217,89,42,0,124,182,179,95,151,85,231,9,241,7,130,250,165,119,165,198,217,193,171,103,191,18,102,122,248,56,236,85,214,106,0,10,197,142,211,222,62,153,226,240,73,160,249,243,17,60,78,24,35,40,143,24,76,191,255,198,143,56,178,132,65,133,98,50,50,79,17,204,125,73,119,21,22,56,36,195,56,240,164,129,85,85,164,227,29,54,110,147,17,121,243,166,16,90,66,62,62,0,43,94,41,233,114,194,248,74,23,132,100,90,41,95,194,110,155,113,148,65,72,244,157,55,235,19,52,201,5,123,244,11,222,16,9,15,37,71,221,211,48,58,117,68,4,19,158,101,36,255,1,10,156,25,224,246,87,128,101,233,120,148,194,239,122,5,142,104,240,181,225,192,40,239,143,198,191,192,181,97,250,189,155,171,4,78,112,76,128,196,76,142,58,183,203,149,51,217,123,22,66,185,234,136,147,105,210,126,202,235,232,249,104,101,155,230,196,201,33,108,62,83,204,90,46,163,154,148,26,52,109,191,95,119,51,190,141,160,20,151,19,205,135,172,69,173,219,81,60,54,156,58,196,95,144,94,158,55,221,133,188,26,31,234,26,223,173,17,43,121,76,240,233,177,158,184,0,96,142,228,204,235,44,235,120,92,120,199,235,10,55,36,111,133,12,126,82,147,88,137,26,36,147,255,24,106,56,172,193,156,130,204,104,24,247,41,204,0,19,233,132,7,223,20,30,54,207,160,22,182,104,18,39,219,22,32,55,142,138,39,121,126,88,252,23,168,15,60,218,191,138,111,25,90,191,185,130,89,5,41,11,161,120,238,108,182,48,215,191,73,96,141,94,232,86,175,119,179,136,49,249,201,131,20,227,66,75,2,56,169,127,240,48,129,167,24,190,182,147,9,83,86,55,123,156,124,158,227,112,122,8,10,95,243,157,14,31,77,173,226,69,132,10,8,226,179,41,164,225,10,9,74,235,246,64,202,50,88,38,243,154,201,185,208,18,225,144,137,67,167,99,154,227,220,180,92,72,254,144,109,68,7,96,128,113,234,50,163,156,236,74,191,32,198,29,204,103,71,107,90,28,83,35,74,29,37,57,219,40,221,139,147,46,166,140,84,87,98,135,115,212,223,171,186,20,190,105,222,232,78,170,203,161,155,65,244,70,129,142,90,102,234,121,86,246,33,131,1,153,183,2,199,219,154,187,207,122,142,157,199,237,10,246,250,181,230,211,166,148,51,19,202,224,114,157,0,64,84,151,81,112,165,18,102,127,160,175,55,173,194,78,109,214,198,170,145,241,182,114,2,202,242,78,56,111,73,41,216,103,15,39,3,213,212,174,125,112,171,63,167,176,129,74,184,224,46,95,98,17,118,12,214,85,232,243,202,137,76,203,118,1,109,159,3,112,121,19,9,141,14,142,99,67,119,229,131,249,171,56,194,122,0,219,108,220,22,84,132,180,214,37,110,98,59,123,166,159,193,232,192,126,254,44,141,89,27,87,48,93,24,102,150,167,74,19,122,52,43,24,59,62,20,254,45,27,222,14,76,7,62,114,230,53,52,90,199,144,215,176,218,250,32,251,92,160,209,217,230,244,116,61,176,225,234,181,32,17,236,26,69,67,204,37,11,130,23,225,107,128,171,89,219,55,233,156,129,110,142,29,123,56,16,249,42,221,120,218,61,55,169,157,54,48,132,239,246,128,184,23,91,165,206,204,89,233,49,4,136,167,113,202,30,246,31,57,196,39,78,149,191,194,247,3,153,223,181,139,80,105,195,219,253,57,30,225,224,219,3,253,198,29,162,197,199,238,97,71,57,125,59,233,151,116,147,168,243,179,135,227,151,128,186,166,144,196,129,187,182,45,68,209,46,193,178,74,54,49,141,134,184,215,43,222,241,60,127,11,72,31,204,70,90,25,181,193,251,102,0,75,28,92,102,175,174,142,228,127,177,234,219,159,86,180,94,244,74,73,243,31,184,203,80,61,217,213,230,166,226,62,216,80,128,169,212,231,242,31,135,60,182,157,139,88,211,187,32,161,40,201,22,65,225,158,70,221,10,238,91,119,205,90,168,63,134,210,65,134,132,168,192,99,231,247,15,86,127,63,82,47,68,119,38,77,222,133,113,207,234,174,229,27,236,103,123,82,37,150,177,188,248,240,86,238,165,166,88,94,168,2,143,94,210,39,244,136,174,136,173,117,145,238,193,19,57,199,217,180,115,206,88,64,65,102,124,151,121,71,164,220,191,85,10,186,127,160,4,237,243,196,118,227,119,232,198,85,18,132,198,189,23,78,0,249,107,184,195,66,170,254,204,222,167,204,119,141,64,140,238,225,14,83,32,196,17,127,195,46,128,59,73,190,176,127,5,10,245,28,124,76,223,151,120,142,33,219,219,23,184,178,120,98,202,201,224,165,203,171,129,169,62,252,53,27,194,99,164,43,207,79,80,76,26,80,64,228,170,128,152,160,218,180,30,1,84,234,70,34,249,244,34,21,177,94,163,134,185,13,205,52,22,228,33,110,200,169,55,7,183,61,6,155,109,251,85,182,163,216,107,237,199,107,36,95,209,93,206,168,29,185,203,24,45,25,11,59,54,206,234,70,248,108,42,167,217,233,10,162,123,49,19,13,15,27,39,55,225,168,32,183,175,39,196,167,135,177,216,63,199,115,157,159,1,194,17,153,53,82,40,254,55,228,224,133,140,124,30,126,212,142,194,42,115,187,227,95,50,98,225,26,186,27,211,174,120,118,71,227,135,58,66,4,67,245,140,120,222,80,42,153,245,237,50,197,117,23,188,247,239,105,243,104,166,39,121,252,216,35,93,235,187,202,31,193,184,33,247,161,69,142,137,218,173,131,91,19,4,185,1,188,226,171,244,55,19,224,75,8,230,57,216,126,21,19,131,29,199,6,44,27,103,253,218,236,132,0,200,17,155,94,68,189,115,158,243,179,83,161,174,157,135,113,216,151,51,232,1,128,33,97,66,213,64,30,128,178,181,197,184,206,66,192,171,127,219,78,125,53,60,38,223,231,49,122,5,71,159,87,163,241,145,134,21,16,166,218,185,76,2,228,148,36,208,190,206,118,228,61,225,26,207,28,245,42,84,34,104,89,55,167,221,26,11,203,37,150,189,75,153,254,215,21,6,106,151,24,105,55,27,99,242,249,189,190,89,107,111,86,184,206,137,56,141,78,42,142,13,228,245,134,205,36,99,59,234,9,28,109,206,183,78,29,201,213,103,11,91,171,243,102,96,58,140,45,162,57,213,233,156,146,41,211,109,128,225,215,98,126,188,67,238,1,142,0,220,29,244,56,40,146,97,98,177,242,149,85,38,92,203,121,202,219,15,101,22,171,65,107,215,176,177,6,57,252,225,242,1,7,166,196,223,15,173,68,57,37,161,123,75,13,105,50,162,169,31,255,233,126,144,59,149,132,209,122,146,80,178,85,141,164,229,209,176,114,30,88,193,139,164,132,161,236,243,8,180,206,16,234,30,53,142,37,171,181,250,196,3,10,179,84,200,65,131,205,118,218,183,23,152,60,140,121,77,41,52,37,180,160,122,8,29,232,123,50,184,206,150,186,229,131,244,82,229,56,127,85,223,45,167,51,52,193,165,138,53,100,212,1,228,119,157,78,150,77,179,104,242,213,16,201,83,181,237,90,18,122,185,223,53,148,165,135,250,100,71,99,35,24,80,154,193,186,19,80,60,170,160,211,44,243,242,190,221,147,140,89,3,145,147,190,247,8,68,87,44,74,112,129,136,29,127,150,98,145,140,93,228,169,154,45,81,127,254,144,217,83,52,131,39,234,5,102,162,60,124,162,7,58,169,11,26,234,14,135,242,152,167,255,247,19,123,122,237,210,78,122,154,205,249,90,210,5,112,70,73,9,134,52,198,131,204,36,194,157,32,239,246,167,152,25,87,199,104,211,194,126,224,127,60,74,218,180,115,179,95,116,255,22,127,46,65,115,76,174,217,183,196,25,226,208,136,183,132,36,169,207,103,254,25,177,207,63,131,247,254,134,49,217,113,170,56,218,121,105,223,229,67,52,238,248,130,180,28,47,58,165,41,57,42,49,183,128,113,113,141,220,241,17,64,91,87,192,31,92,162,95,49,189,235,82,168,48,20,215,128,170,42,156,78,234,239,96,158,3,127,123,84,142,74,255,6,16,158,11,225,251,89,39,171,19,217,51,30,171,117,19,11,111,148,76,154,67,139,253,118,61,115,44,204,158,67,91,109,191,87,245,131,133,138,123,105,109,108,38,180,10,111,78,128,245,154,246,128,254,107,238,193,253,188,99,87,144,145,168,252,106,173,232,71,185,66,104,155,169,116,227,157,138,243,216,224,77,23,221,109,253,231,90,147,140,53,113,116,219,108,5,62,11,37,176,144,91,85,81,16,61,106,96,29,23,16,1,65,193,30,126,129,189,73,127,174,49,195,66,141,101,97,179,37,18,210,120,198,165,157,158,235,7,244,70,231,43,138,232,205,185,238,50,4,239,41,248,247,210,33,124,113,66,2,126,142,177,95,219,73,251,233,99,11,211,64,39,9,106,38,158,205,70,84,125,54,42,73,22,171,119,98,67,28,193,119,109,222,157,39,149,131,11,206,118,215,186,56,49,116,156,88,227,55,80,95,178,179,249,241,254,130,107,247,110,159,210,25,120,146,65,133,189,216,232,45,151,179,18,245,135,224,34,251,51,220,61,0,255,241,3,43,105,170,60,215,173,211,196,68,49,186,142,181,172,109,99,100,123,63,2,124,30,151,168,134,192,215,154,140,76,46,198,171,21,25,180,154,13,199,166,96,162,104,150,13,52,99,2,235,157,112,94,103,163,42,143,48,187,101,208,1,124,64,203,95,151,232,120,154,39,183,177,215,142,3,237,216,214,230,35,60,98,113,248,158,191,196,92,253,131,45,36,36,241,242,26,83,164,213,31,230,222,187,139,116,143,66,246,0,202,27,15,83,250,26,206,173,180,120,50,91,41,252,159,49,55,36,181,19,180,57,185,85,214,13,127,204,150,86,193,111,84,29,196,114,217,247,169,222,74,62,194,174,7,243,61,77,32,194,181,129,242,95,95,140,205,12,21,172,65,142,186,15,67,32,50,6,31,219,28,100,220,197,134,14,221,229,58,1,114,208,166,105,175,255,126,165,15,91,184,214,29,29,222,36,62,199,228,226,234,38,100,53,142,28,6,143,52,104,43,119,216,44,53,26,154,81,136,87,125,50,189,114,191,173,5,224,64,139,232,36,10,245,255,193,170,148,75,135,224,193,22,75,153,22,47,234,183,101,33,236,218,122,118,169,142,60,235,210,72,129,85,166,4,141,11,242,125,23,17,90,119,226,237,129,163,255,124,159,68,26,138,133,219,224,1,221,104,149,243,104,63,180,201,208,58,245,129,42,85,33,231,145,197,204,47,114,217,205,138,203,87,69,60,77,136,38,68,50,94,244,90,96,183,223,174,214,132,211,4,153,32,153,27,167,109,196,98,42,93,131,120,31,223,173,89,232,128,157,67,181,162,40,87,82,62,36,50,235,183,154,96,31,155,59,147,116,130,131,197,166,181,247,68,67,175,38,232,28,38,203,230,151,76,134,63,165,251,230,47,138,210,165,214,219,106,32,65,8,254,23,189,115,14,168,77,112,245,30,238,191,193,151,114,229,138,190,208,77,60,214,113,133,110,89,240,119,218,68,24,191,73,3,169,135,171,124,116,153,63,107,101,178,210,163,30,161,19,26,94,8,70,54,121,216,107,120,35,57,102,60,39,151,54,7,30,255,9,199,165,209,204,179,172,143,37,215,202,48,121,111,124,210,197,237,243,248,246,29,44,38,186,204,12,143,138,243,93,151,218,128,41,140,92,13,247,226,12,73,2,223,23,68,6,197,105,181,232,72,11,212,74,153,126,135,216,121,191,230,218,9,7,190,74,91,235,222,10,51,47,151,111,122,195,247,235,80,126,90,61,10,249,93,81,88,148,46,189,38,152,56,5,236,221,183,16,141,132,157,103,205,242,238,242,57,169,173,64,38,107,176,50,107,91,133,106,204,166,137,110,89,162,125,182,237,129,156,232,234,216,65,127,100,248,169,199,49,105,110,230,142,205,128,50,221,125,193,90,26,116,200,179,141,161,198,221,187,227,162,158,43,94,216,111,207,36,57,72,191,237,193,230,229,126,87,3,144,201,116,220,186,158,161,154,161,11,151,50,38,255,151,31,169,79,50,154,93,116,220,251,15,78,96,179,109,61,157,213,61,229,179,156,36,30,94,11,0,32,37,155,7,46,97,205,93,204,62,231,81,201,207,102,47,175,1,59,59,136,117,255,81,233,120,31,182,167,130,143,10,153,146,19,240,155,54,180,29,168,83,169,202,108,213,85,129,129,168,50,12,75,206,8,216,62,126,152,48,34,19,0,113,91,209,66,30,25,250,234,41,161,76,63,172,45,135,54,97,216,96,2,226,154,168,215,133,59,27,40,213,116,2,8,65,117,130,76,33,94,106,161,117,60,181,171,73,90,35,101,68,231,143,0,191,23,42,185,120,211,152,142,65,55,65,228,58,210,180,110,194,18,121,8,8,34,173,92,241,100,161,197,173,120,200,159,153,144,55,138,125,79,238,185,222,199,187,17,89,53,122,14,48,255,214,170,10,39,91,44,28,22,155,156,87,220,254,140,102,144,110,138,160,112,218,238,89,82,237,41,221,50,192,209,71,161,83,249,49,189,178,245,63,148,237,70,53,141,65,129,38,104,200,107,28,153,178,8,6,118,203,241,251,0,157,117,159,7,117,100,22,206,221,227,37,32,223,13,157,84,47,118,154,27,56,204,124,68,111,137,27,63,24,253,198,47,171,83,143,192,166,130,251,81,4,104,30,172,69,94,242,18,61,255,74,54,97,246,0,70,122,164,122,12,160,155,132,5,175,84,254,137,188,210,214,235,200,108,112,55,149,73,244,103,157,191,206,173,125,20,223,218,90,129,251,20,83,178,254,128,117,11,183,138,164,184,15,1,25,37,104,132,94,143,122,10,230,222,20,36,93,93,120,134,202,167,170,115,46,166,85,89,4,101,152,49,171,146,230,32,30,3,161,225,85,243,202,252,122,239,16,75,53,38,133,160,150,123,56,157,152,154,247,223,154,173,251,165,139,236,111,151,40,219,174,175,62,209,20,72,140,223,42,161,211,12,153,80,189,92,229,144,81,19,204,205,198,200,217,116,224,150,54,238,255,181,25,0,68,59,10,146,120,33,167,120,180,75,150,188,108,11,143,107,133,128,171,142,159,162,180,73,192,17,235,97,207,161,79,104,112,87,178,4,85,147,121,33,31,238,207,78,18,141,154,121,91,237,188,101,67,9,232,14,171,118,152,44,44,43,162,40,212,88,41,146,188,114,28,154,203,53,151,170,23,196,57,224,191,163,162,101,137,107,58,67,225,12,37,255,218,80,207,171,94,132,239,72,111,12,180,88,105,50,76,117,59,239,23,22,233,47,55,180,38,88,236,205,90,125,67,147,136,71,124,253,51,93,213,163,55,42,87,68,77,2,102,217,7,197,220,34,163,88,68,22,240,52,19,20,52,238,112,37,194,210,233,152,138,153,149,214,88,132,41,75,104,188,108,79,111,201,82,209,126,57,104,166,39,51,21,53,151,59,93,218,255,212,126,6,69,26,83,159,87,97,174,31,137,253,253,163,234,5,203,190,58,97,86,228,37,4,67,202,38,174,229,215,182,97,136,164,38,116,252,113,129,15,37,51,93,190,141,224,208,254,12,12,184,98,85,120,116,147,183,112,125,35,127,155,99,178,32,240,45,1,74,244,90,67,124,42,70,127,200,105,162,135,80,1,194,44,221,137,62,53,56,182,169,186,98,0,168,80,151,22,1,36,176,145,171,100,218,50,18,187,61,196,222,32,76,204,51,220,34,189,185,244,108,236,237,160,89,208,105,26,159,32,74,69,247,78,17,215,16,25,61,244,141,183,116,192,34,222,114,85,42,249,144,245,151,253,218,185,46,12,156,95,23,227,204,36,250,229,120,173,87,186,85,208,251,87,2,250,185,40,50,65,19,90,198,30,21,106,249,111,154,106,247,247,112,91,204,234,101,99,238,118,163,38,123,190,73,169,7,208,17,102,139,70,0,237,41,174,162,231,39,8,200,229,252,103,48,64,95,52,26,53,18,103,28,113,93,153,160,42,127,181,38,93,38,73,145,9,25,240,173,47,157,244,77,132,243,74,108,51,41,3,3,190,253,137,126,180,9,193,119,68,6,100,21,7,159,234,175,255,122,214,4,165,152,141,230,68,72,135,248,61,3,12,227,22,115,231,201,77,124,110,74,128,110,94,85,212,8,66,22,101,13,116,35,164,163,115,218,187,249,241,27,91,58,88,29,75,30,181,231,207,158,12,157,30,120,208,29,187,109,212,90,17,111,48,39,100,19,163,144,33,96,255,11,237,59,138,187,86,81,140,146,74,18,35,218,16,57,160,194,232,189,217,251,47,129,65,31,197,204,15,147,110,211,41,119,153,253,48,231,123,207,27,115,7,3,242,107,92,156,42,185,105,170,30,33,2,8,5,219,205,19,138,145,36,235,14,241,241,63,53,11,180,31,55,226,84,147,17,213,126,85,44,60,13,238,210,247,107,248,122,12,188,205,149,172,4,95,21,140,12,166,40,154,199,161,156,44,97,56,127,144,125,100,27,75,249,50,208,6,122,241,59,114,207,190,125,52,33,238,143,68,50,141,168,104,11,25,98,93,18,245,90,241,172,54,85,254,91,38,51,6,73,100,123,119,122,89,242,163,216,44,21,254,31,63,87,247,128,141,105,123,116,76,127,46,176,71,213,169,195,61,29,1,9,176,183,138,191,227,73,90,100,240,72,120,139,26,60,253,205,26,127,39,188,160,37,139,241,131,240,96,93,207,219,203,136,103,197,0,201,43,40,19,103,73,69,80,32,41,147,50,72,1,52,156,84,154,184,196,136,174,179,130,158,23,223,69,171,188,146,237,75,246,207,194,21,195,93,217,235,242,225,148,52,84,43,98,72,242,5,217,156,16,84,168,46,106,83,113,161,254,122,216,220,26,204,189,116,21,232,108,236,178,163,39,189,48,202,103,197,80,94,18,43,204,201,101,21,153,100,92,90,108,197,38,254,132,29,182,124,182,201,215,109,154,167,148,1,214,171,134,77,56,17,88,32,79,151,253,99,83,187,166,204,230,10,229,36,106,196,127,253,185,193,214,5,12,62,25,193,185,152,254,209,90,245,217,175,96,35,208,27,16,34,115,167,198,134,155,192,109,150,81,35,241,87,65,184,249,121,220,184,6,56,85,147,100,196,94,246,106,20,140,252,84,43,255,82,121,124,109,22,67,167,149,75,15,93,171,22,139,190,165,59,233,215,235,55,113,154,170,215,77,98,220,50,93,177,85,235,68,80,232,6,54,102,183,51,231,195,194,129,3,243,75,181,202,237,221,26,57,95,47,119,165,236,232,75,190,63,239,59,103,219,60,50,36,113,212,23,16,228,117,25,206,120,108,168,81,143,155,70,241,65,136,22,37,24,143,237,136,188,247,69,70,5,104,150,185,105,218,168,255,34,204,89,131,216,156,82,106,78,237,71,109,70,237,54,160,247,50,126,96,125,206,8,224,23,201,140,169,133,216,64,4,59,143,171,94,35,179,182,164,20,168,141,232,93,166,136,175,83,91,108,45,173,188,50,16,233,12,247,81,34,100,206,109,158,101,41,247,115,195,222,190,63,72,138,94,19,46,46,2,44,85,106,69,191,169,159,159,130,159,162,70,148,223,18,121,25,244,99,61,244,227,232,130,168,184,238,34,206,37,254,58,185,231,29,148,214,102,93,64,178,43,89,186,136,93,247,2,77,118,174,209,169,112,126,255,238,114,203,37,146,11,73,207,150,86,20,18,6,56,184,150,130,109,133,61,28,111,254,138,172,83,174,186,37,215,134,169,212,64,234,137,6,40,162,91,227,166,144,33,36,189,148,71,87,9,43,14,151,138,78,56,117,123,130,65,51,76,106,114,71,187,84,104,136,127,90,196,65,237,203,90,18,186,170,59,102,139,85,21,17,145,73,45,176,9,209,2,228,173,38,67,213,27,0,191,129,245,222,208,111,79,204,106,168,157,178,148,6,164,57,25,135,24,54,116,175,187,146,240,101,52,34,145,29,40,33,47,0,143,168,89,245,49,8,39,139,190,14,40,221,182,253,133,51,140,249,14,41,67,32,12,115,24,196,61,241,49,159,177,99,169,121,246,251,207,204,22,223,152,138,218,150,1,2,160,89,186,195,211,46,32,128,70,50,218,40,236,189,40,24,211,123,30,194,23,142,133,212,112,100,133,240,42,46,127,255,107,236,38,152,29,72,84,16,91,150,230,94,74,79,223,43,73,115,212,34,226,86,168,2,12,76,51,216,229,246,136,43,170,96,114,142,160,143,191,64,10,135,83,244,212,198,186,199,57,205,119,43,254,208,109,80,158,109,157,179,194,52,253,31,18,236,47,132,130,18,91,23,189,143,61,71,20,2,131,77,155,176,237,106,147,54,183,6,124,242,175,4,163,70,53,45,221,107,107,50,98,124,130,17,111,163,165,16,25,38,25,23,65,148,83,49,90,181,234,117,8,137,57,194,36,69,208,193,35,3,242,244,235,215,205,252,208,51,222,233,209,119,241,93,173,167,19,60,43,246,125,82,3,93,161,113,84,252,48,216,155,34,244,21,247,214,144,196,36,186,136,239,70,95,181,115,28,237,214,237,106,195,238,173,111,3,41,135,156,104,55,175,210,57,77,244,111,68,245,253,242,152,82,12,126,145,150,93,188,157,193,36,126,108,76,181,164,227,111,27,3,166,116,212,216,53,212,93,241,92,195,153,201,187,96,200,27,246,27,223,127,231,252,78,42,212,255,176,132,169,60,201,66,248,57,154,123,15,94,241,224,193,4,138,23,42,160,88,148,161,7,48,18,90,116,164,12,197,39,14,115,74,10,227,200,49,218,127,4,159,65,152,105,190,107,66,134,195,39,111,35,153,11,179,155,76,194,84,134,175,227,216,108,223,225,250,244,207,126,74,3,42,97,167,155,157,179,99,137,35,16,199,83,128,156,53,71,13,92,249,164,76,138,83,221,37,168,156,36,237,190,138,209,110,56,190,92,180,2,17,143,167,228,147,216,198,87,153,213,51,48,6,197,202,73,124,0,1,246,168,246,206,239,39,200,25,97,181,30,103,162,159,217,91,54,169,55,23,199,99,243,147,1,156,251,221,228,191,130,66,246,172,223,161,188,103,236,139,191,109,181,53,29,53,192,54,115,241,204,111,30,170,142,206,65,157,85,119,211,112,137,46,156,181,169,90,228,167,204,191,39,11,221,109,223,73,250,52,27,234,1,84,188,9,45,37,233,34,168,227,112,48,62,161,208,6,195,137,77,31,102,61,218,66,239,233,15,15,164,38,5,194,235,51,46,49,21,57,34,99,35,207,208,202,124,28,148,87,130,157,107,25,22,171,249,61,2,171,241,183,84,132,236,143,166,7,0,239,40,202,6,17,219,90,53,40,48,119,56,93,134,98,37,113,93,66,24,80,202,60,54,79,95,226,198,225,250,181,24,159,151,56,228,194,10,228,182,195,203,167,23,246,49,69,17,173,244,132,76,223,102,128,81,53,33,168,119,52,104,124,49,18,51,129,134,9,172,185,40,193,211,176,224,3,39,21,189,189,179,104,139,80,53,45,4,55,43,1,160,14,42,65,214,201,22,40,20,60,71,247,242,237,206,193,99,88,1,188,235,39,220,86,167,35,121,213,34,208,182,110,80,34,142,107,171,210,141,224,235,138,53,114,14,119,229,127,99,20,141,158,60,73,119,155,200,104,236,204,102,99,235,240,54,113,112,43,163,109,100,187,171,212,1,26,1,67,2,130,142,9,80,100,205,183,140,186,240,104,66,80,234,76,24,16,31,169,49,164,39,160,199,112,156,27,248,34,252,116,237,165,42,169,107,180,124,108,202,220,7,51,213,3,78,195,165,89,83,240,199,181,135,106,104,97,105,1,216,192,119,69,75,68,152,210,160,80,96,171,125,95,46,9,15,224,25,135,134,118,183,50,44,15,131,58,34,79,20,46,237,155,116,156,115,110,140,187,105,251,3,119,191,14,174,232,119,150,159,60,150,61,93,32,237,169,133,80,62,82,161,172,69,58,240,115,86,229,156,7,185,69,137,245,116,200,82,70,250,148,103,100,209,207,96,197,204,242,25,74,108,234,153,202,96,93,129,26,69,217,162,13,124,16,248,127,169,225,165,249,13,96,61,9,157,16,152,165,216,106,222,234,217,136,39,131,16,94,193,176,16,167,198,43,155,44,153,220,174,55,4,21,23,155,104,45,9,51,45,199,227,185,34,233,126,201,206,227,92,22,61,54,2,94,163,11,99,60,221,66,122,8,183,216,80,244,105,218,208,80,57,234,13,155,26,87,223,219,25,227,189,64,63,224,254,236,85,25,6,249,116,195,160,29,186,149,108,245,174,59,133,200,211,98,197,73,104,150,107,70,145,65,131,111,73,186,249,113,206,165,224,163,13,154,200,78,85,120,56,3,61,59,62,110,61,148,135,245,234,211,185,86,12,249,38,210,74,222,183,7,65,255,51,136,2,194,1,125,38,199,145,114,250,255,156,69,134,168,115,104,52,60,115,85,20,161,4,127,16,2,63,101,253,218,44,29,16,50,205,104,140,178,83,67,180,110,4,25,172,202,22,85,130,121,240,252,251,152,222,225,208,100,255,112,171,141,57,109,233,72,177,70,209,85,44,187,193,32,138,208,133,46,144,108,105,119,77,192,10,125,47,84,44,59,63,41,108,79,70,239,160,190,80,83,94,31,90,211,135,131,226,219,138,33,20,134,162,168,240,62,77,26,75,106,25,247,207,216,93,246,182,10,227,161,96,184,127,136,25,233,46,147,234,131,134,9,210,45,210,80,144,206,149,132,26,144,184,255,253,87,181,55,193,169,64,199,244,182,148,92,87,163,57,104,231,142,168,159,231,214,208,68,170,154,136,198,168,245,71,30,139,180,48,117,100,227,102,136,41,150,17,218,137,248,211,45,189,8,183,172,166,82,68,42,10,21,71,55,223,14,107,142,65,161,86,250,178,203,51,245,26,7,185,57,166,126,154,176,14,84,41,241,76,111,196,36,113,150,25,174,225,82,245,221,239,121,63,107,178,52,215,129,99,209,26,235,141,242,235,212,70,157,250,9,179,205,198,141,252,61,205,218,5,166,216,45,133,13,221,185,228,133,34,91,172,242,251,198,158,113,150,27,235,106,218,229,18,195,95,100,77,139,230,113,139,245,124,214,201,227,151,53,118,67,148,132,60,0,242,13,94,115,140,173,47,198,194,43,180,191,14,68,45,20,12,128,128,227,171,125,55,61,96,2,212,135,238,0,148,240,153,225,71,210,222,49,174,13,199,47,99,234,151,16,38,30,172,165,175,16,56,64,110,60,207,73,46,35,197,115,112,183,40,130,209,238,179,185,193,247,69,210,10,247,70,135,172,161,104,241,5,54,22,14,16,63,209,186,18,126,163,163,126,211,67,141,60,1,208,198,181,167,158,121,182,169,132,11,233,100,198,201,113,25,225,236,1,131,174,20,83,248,118,124,70,10,148,218,60,71,76,48,235,122,19,79,128,76,55,1,83,226,192,252,34,130,8,61,0,2,88,210,217,116,218,27,241,138,0,184,107,107,163,88,202,29,56,228,15,68,22,219,154,12,29,93,28,145,80,246,43,141,79,139,250,35,115,84,27,98,187,82,113,0,217,142,46,53,140,135,128,161,142,112,55,12,205,194,153,33,197,80,246,45,61,175,232,8,179,209,48,107,85,103,237,206,144,120,65,1,235,153,163,131,172,226,231,169,213,125,78,58,240,239,232,217,149,215,234,234,60,244,161,12,176,188,64,206,109,123,11,153,180,114,77,29,10,221,169,159,250,74,243,234,52,237,189,227,135,201,197,245,30,175,64,148,178,99,135,213,164,129,87,213,76,207,154,11,46,254,166,73,185,75,250,223,222,2,155,247,104,132,208,114,237,250,89,17,236,199,187,48,152,23,101,50,144,163,253,241,162,97,202,14,163,197,153,43,151,218,97,5,98,221,161,11,76,245,196,49,75,226,133,2,29,113,1,113,230,154,202,19,135,230,242,156,103,232,252,47,92,230,124,229,171,62,95,52,240,51,16,204,185,3,38,114,219,115,233,117,58,118,138,141,53,13,192,42,168,218,25,159,24,81,83,86,132,175,195,193,221,73,101,140,19,219,165,51,237,152,148,61,242,42,177,145,79,15,137,121,86,81,78,180,190,127,233,75,118,51,48,34,242,181,117,237,29,68,137,111,126,206,91,123,71,46,167,56,245,231,118,205,56,22,146,119,73,12,65,238,236,61,134,76,213,4,50,23,99,8,224,183,199,40,38,206,209,136,206,102,191,237,15,61,5,0,251,19,111,34,198,232,168,37,33,233,91,184,9,214,47,151,1,56,176,206,79,242,208,103,164,101,80,231,123,58,141,88,70,106,35,97,74,10,42,39,12,90,113,229,145,32,133,41,99,55,66,215,48,20,199,93,86,77,217,50,102,43,180,209,255,25,143,56,99,20,57,83,26,0,181,7,90,152,245,195,92,174,96,99,161,163,135,242,245,5,174,183,181,235,53,71,190,74,140,189,78,230,27,213,28,50,236,150,179,206,41,120,192,187,189,125,26,47,2,1,173,42,76,247,54,174,222,49,222,114,12,213,17,145,115,60,61,30,250,154,0,228,251,127,227,177,141,158,69,118,120,87,44,109,183,179,191,57,74,108,81,85,36,34,137,165,96,222,92,250,238,6,16,25,87,190,227,21,21,94,241,140,114,227,189,28,24,24,61,88,30,187,219,42,125,148,18,40,50,31,247,22,5,147,141,151,231,220,26,250,46,174,126,181,41,241,13,60,199,198,26,109,15,199,249,211,21,221,5,160,62,7,71,44,32,6,53,229,60,250,10,97,208,224,106,78,207,188,54,250,225,228,197,57,45,173,210,127,197,159,38,31,18,98,59,6,66,118,80,59,5,165,35,65,169,151,42,121,36,128,136,94,11,242,103,136,245,81,45,8,4,102,215,49,178,128,127,46,156,91,27,70,140,161,144,22,173,38,242,17,254,66,118,179,27,177,244,245,111,217,235,197,138,166,231,165,236,100,90,154,67,222,25,47,79,204,223,230,222,166,88,159,251,215,246,18,183,112,27,179,198,42,185,21,75,9,243,255,175,178,35,53,135,93,14,218,2,42,231,135,175,236,8,154,98,100,14,97,130,251,36,181,134,101,88,30,70,210,75,138,112,77,37,15,118,97,27,108,169,212,99,116,142,198,5,59,216,76,204,134,190,249,194,40,120,197,5,33,182,223,185,35,9,53,109,242,166,174,101,48,172,121,130,65,240,137,86,250,91,174,218,19,100,128,11,36,87,137,63,41,54,188,84,234,12,49,182,132,185,220,125,84,20,148,154,77,101,155,8,14,109,134,31,64,19,190,215,42,179,102,250,229,80,173,52,82,247,146,31,52,37,139,231,2,196,246,191,138,219,236,17,142,87,136,30,189,47,206,120,50,22,79,104,147,76,242,139,210,173,16,152,170,99,168,75,232,75,30,71,32,222,153,215,107,122,50,59,62,167,43,6,129,33,195,32,151,250,157,54,183,217,102,115,193,111,29,167,157,219,172,253,194,243,131,106,180,140,88,96,68,195,175,65,192,179,202,196,112,190,221,117,10,86,100,175,40,158,80,51,50,13,186,236,31,238,84,68,124,62,76,32,10,180,121,231,9,240,146,123,60,131,237,160,33,141,225,241,145,135,71,87,8,39,23,194,178,167,114,15,167,38,95,210,231,229,146,152,248,189,81,235,153,236,84,122,217,19,55,4,48,51,172,63,24,154,110,145,9,29,195,69,68,37,253,49,161,58,37,57,91,178,211,4,115,244,101,87,199,236,243,55,86,118,35,125,35,129,149,208,200,73,96,82,24,16,13,100,81,96,3,43,50,84,166,185,249,105,197,35,173,103,125,69,181,174,124,0,37,120,160,86,12,152,66,95,174,175,171,151,234,172,189,14,90,51,193,185,195,11,85,2,197,23,241,102,94,6,254,121,138,216,68,70,136,131,69,7,55,24,116,115,160,51,214,121,228,199,56,93,75,202,101,83,199,227,137,117,149,1,199,215,174,18,6,89,179,41,4,153,160,16,233,149,4,14,52,51,251,217,52,38,36,205,149,68,198,43,109,135,49,244,229,168,170,83,75,60,193,106,216,41,40,113,100,225,234,4,208,54,89,94,228,240,79,151,198,106,164,235,96,66,78,176,219,134,47,142,10,208,23,136,246,169,218,108,106,194,64,200,221,237,149,165,242,89,235,43,74,94,126,212,145,34,55,32,193,157,227,2,152,16,28,177,65,0,210,32,191,11,36,191,54,39,233,34,57,96,30,47,89,198,198,142,125,233,72,151,201,43,125,191,135,173,36,18,102,61,171,224,234,219,98,161,65,234,225,86,184,183,5,1,183,118,194,36,158,81,222,33,56,145,224,214,63,188,126,198,244,127,8,136,119,137,160,67,162,214,196,40,29,180,22,184,72,108,63,72,114,233,84,215,220,198,240,76,75,0,117,216,146,103,33,50,212,37,66,67,241,145,2,192,216,46,44,166,208,83,7,234,148,159,243,31,9,118,50,29,42,98,201,141,21,119,216,37,113,131,153,188,197,96,252,145,204,73,31,175,106,249,151,241,34,83,130,159,142,49,238,4,164,29,115,164,76,210,160,0,116,48,80,93,35,114,148,113,155,16,10,225,191,103,207,7,207,112,119,17,48,217,205,254,194,203,173,37,72,122,236,37,212,121,137,190,38,165,6,0,237,55,168,76,10,109,203,23,173,13,130,196,233,149,233,216,186,102,158,76,200,79,241,42,15,3,162,113,134,87,214,4,58,16,119,76,229,72,131,57,52,245,148,148,136,173,49,12,141,55,24,201,174,31,10,32,161,35,113,142,180,108,37,208,10,211,91,211,138,186,231,0,194,67,44,160,117,64,48,140,157,168,255,156,95,40,37,73,229,151,71,220,174,162,130,187,86,209,127,211,95,28,187,176,220,61,198,33,59,224,66,92,255,79,154,61,161,65,59,214,220,236,37,188,35,151,102,79,218,141,43,118,43,134,79,216,236,6,25,42,45,185,106,18,41,48,4,11,30,107,127,177,139,32,73,36,235,167,76,84,147,234,230,128,76,0,92,3,189,152,22,78,225,250,213,3,43,227,59,167,47,54,143,62,106,120,6,157,163,154,0,235,92,195,218,151,86,106,214,243,169,157,8,146,11,83,160,204,156,210,100,120,198,202,178,236,187,43,187,79,61,54,198,161,102,57,193,236,16,232,12,72,1,14,254,113,172,127,115,54,90,107,24,170,135,8,233,206,112,46,69,235,110,236,100,115,42,148,49,157,211,8,161,108,90,52,204,45,0,126,26,37,246,219,102,96,46,30,136,11,34,206,35,20,193,11,66,157,27,28,8,51,235,236,191,40,12,57,73,195,62,198,0,213,119,254,244,19,230,204,171,74,71,29,255,226,116,242,89,184,76,84,38,196,242,246,151,69,238,87,208,64,163,15,178,152,252,35,82,8,170,63,86,136,0,146,127,134,10,125,195,49,228,224,188,91,196,41,23,40,28,184,89,157,51,106,210,199,203,212,107,240,57,126,115,120,81,35,203,13,90,248,32,126,246,142,207,202,93,56,204,107,127,88,81,151,93,152,159,47,199,227,102,55,118,51,164,95,190,24,250,151,192,153,187,227,41,244,221,172,200,213,155,132,179,250,87,234,253,244,162,114,159,75,177,31,154,33,206,152,20,243,168,163,57,143,179,106,36,98,209,20,83,218,94,192,83,235,147,59,13,190,55,32,130,94,25,246,55,228,174,74,224,47,17,25,157,43,88,146,205,5,65,48,199,19,245,111,142,29,160,211,251,18,22,241,61,137,140,100,234,129,93,159,125,217,119,137,31,78,46,228,12,233,82,185,58,37,175,247,226,188,95,130,157,230,93,219,148,192,39,56,182,195,38,213,244,148,20,202,132,52,195,102,213,214,15,148,167,0,248,216,226,132,207,9,220,39,17,214,59,53,35,218,32,62,49,41,215,1,221,192,238,209,18,149,160,89,208,28,47,254,224,125,73,241,125,176,77,77,159,88,135,194,205,24,18,3,174,215,97,29,241,178,107,170,110,1,207,179,218,153,67,16,109,23,158,34,192,128,3,175,2,120,184,206,71,82,82,212,34,115,44,26,100,209,115,48,144,99,75,4,253,230,233,180,38,174,129,32,66,89,42,26,84,61,186,166,138,241,138,61,29,10,155,33,198,246,107,86,255,232,112,86,112,104,209,57,146,28,57,255,59,35,88,10,30,41,123,86,25,26,121,65,138,190,91,189,78,237,176,224,91,216,186,71,110,241,31,1,108,56,167,53,203,123,224,255,136,143,66,46,113,222,227,210,109,211,89,88,53,75,250,68,64,237,114,52,183,198,102,9,89,102,41,103,210,153,174,250,1,209,105,85,240,68,207,11,13,167,92,235,218,103,109,137,123,93,44,2,46,202,210,25,200,174,48,130,68,55,247,31,130,154,234,101,112,4,175,35,244,69,249,117,155,233,114,13,189,102,79,38,148,11,132,114,204,131,175,126,67,80,16,175,165,37,136,50,102,159,120,111,254,204,178,52,229,121,20,182,198,92,240,9,200,224,132,151,248,180,91,55,201,219,72,58,13,131,189,137,114,172,250,156,67,137,155,51,80,113,103,211,212,206,182,85,230,53,116,110,171,241,150,161,95,235,200,225,63,17,8,5,233,213,13,42,17,163,124,73,97,63,195,208,124,177,85,17,130,157,255,174,32,27,38,130,57,99,150,1,30,165,175,126,89,98,60,120,219,41,6,138,197,129,27,239,146,101,243,165,82,205,51,138,43,191,91,225,148,232,58,189,33,93,49,205,171,43,93,134,166,58,68,62,246,137,189,196,114,166,65,233,44,122,78,199,181,238,155,176,74,91,214,230,204,128,188,193,176,134,123,243,250,236,219,164,90,112,149,205,132,58,233,57,53,209,133,84,232,186,165,16,124,252,5,107,154,209,247,188,112,125,136,88,109,153,252,1,81,194,172,222,231,52,131,199,137,235,31,70,130,95,185,105,188,249,94,35,16,157,115,49,105,211,61,110,223,49,240,121,79,85,92,232,110,73,202,43,48,72,190,94,74,107,20,72,110,163,133,31,117,17,94,26,186,231,117,160,114,146,56,210,6,134,140,3,194,23,41,58,204,242,92,114,232,254,227,109,232,147,250,107,165,9,25,22,92,115,128,4,133,63,148,51,144,247,196,254,25,123,165,211,58,105,166,241,191,226,144,34,174,14,59,8,153,105,105,202,131,37,15,118,116,155,225,107,174,95,31,99,161,182,121,97,55,141,23,43,29,237,151,211,10,48,249,24,231,169,170,82,44,28,76,85,80,133,177,167,44,131,234,213,98,204,230,71,243,70,60,28,54,49,153,3,29,103,33,219,54,164,45,42,58,31,39,110,102,5,148,126,75,165,117,146,147,141,34,149,246,188,51,61,73,104,158,30,201,229,188,110,248,198,3,236,86,50,247,23,134,104,57,191,147,221,204,16,93,146,189,6,116,132,233,62,104,158,218,158,248,190,209,87,52,105,103,74,52,152,162,231,190,144,27,225,224,102,224,199,149,226,35,205,72,208,62,86,23,75,13,196,28,173,5,37,248,102,40,187,208,132,42,145,29,243,64,188,140,95,94,252,39,117,111,5,186,148,242,181,37,174,68,199,103,241,203,222,158,34,141,14,75,10,72,224,215,33,104,39,77,18,134,211,252,147,54,249,130,29,0,199,213,171,14,176,249,224,221,234,163,186,102,64,117,123,34,0,230,34,109,137,246,232,43,81,254,191,125,171,250,22,9,160,184,19,64,207,217,203,1,152,23,227,47,227,61,175,81,3,189,204,28,61,244,209,164,193,227,54,180,25,184,160,16,181,187,171,215,17,158,175,130,128,6,151,131,184,120,185,80,171,197,175,10,31,108,195,228,125,136,61,226,155,142,95,232,77,145,1,168,164,99,239,193,86,181,62,125,69,93,216,175,238,36,70,243,84,243,138,47,145,142,190,212,54,131,182,249,179,106,47,198,36,55,163,6,154,226,101,234,74,104,167,166,227,208,20,174,97,42,132,109,206,147,65,106,70,92,216,176,35,184,57,150,123,110,125,157,61,63,250,158,195,237,67,194,48,99,200,69,124,227,3,91,9,214,95,89,151,102,232,177,143,231,71,238,55,124,219,148,219,198,127,147,69,12,232,13,245,175,7,8,252,250,179,175,95,116,86,121,130,38,241,163,164,64,230,202,54,19,40,245,70,61,99,5,56,172,52,25,74,178,29,60,129,5,2,114,218,221,0,31,239,234,91,153,127,233,193,135,212,23,87,24,202,187,242,22,121,41,51,246,91,85,202,57,60,18,97,112,124,116,112,81,199,41,77,14,62,206,236,39,52,127,162,44,231,188,74,108,189,247,97,230,18,244,86,122,20,174,122,103,67,49,81,48,58,154,65,175,246,163,197,12,25,205,169,73,127,214,81,103,56,10,203,229,18,248,43,76,224,223,62,173,45,195,224,240,215,242,63,217,78,37,14,10,64,228,205,74,173,226,176,154,132,131,140,135,79,223,157,31,181,206,212,149,56,118,11,44,236,226,213,51,101,65,116,247,140,156,253,230,172,26,67,210,34,17,116,58,99,239,231,135,216,223,100,133,97,201,75,41,68,229,48,23,251,121,208,185,42,13,27,54,21,253,142,4,38,226,81,240,128,55,103,144,19,207,86,69,143,182,238,128,116,234,235,49,187,216,123,18,46,70,199,10,107,6,176,83,39,162,0,118,218,172,93,50,19,228,41,199,198,83,109,219,144,222,229,169,131,142,48,181,78,200,37,169,132,179,71,167,216,195,249,157,182,45,121,220,68,187,91,78,215,4,78,113,149,155,40,202,76,55,123,88,145,171,154,122,220,73,2,50,45,2,182,104,163,137,126,161,157,61,66,151,218,131,248,16,31,8,56,223,187,185,206,84,250,125,0,47,78,158,68,97,155,213,200,167,11,164,79,239,58,148,236,33,237,21,121,72,121,167,94,11,27,135,227,7,80,158,166,42,30,193,145,79,103,97,137,173,241,166,156,119,156,123,199,11,9,185,195,170,17,102,39,28,66,75,106,177,122,189,21,224,182,124,50,220,2,156,84,220,122,92,6,228,245,97,113,125,77,150,198,175,229,170,3,237,222,4,238,4,72,57,244,160,185,53,38,151,139,145,170,161,5,162,6,21,220,98,66,187,107,118,5,86,211,148,116,235,32,91,8,130,81,60,225,207,75,69,51,198,180,180,143,160,95,179,87,209,134,198,9,59,77,244,215,59,106,97,160,129,220,42,104,138,25,73,141,178,204,235,84,156,129,123,116,110,61,84,187,35,136,213,100,228,67,188,18,123,51,88,181,25,117,104,48,134,196,225,216,40,166,20,221,168,234,216,188,188,198,240,54,120,15,46,207,75,170,202,4,170,21,210,16,188,77,16,46,224,245,194,45,73,147,245,140,30,150,29,191,219,7,104,178,186,88,106,160,76,20,224,130,3,49,242,137,105,146,215,83,153,115,198,113,32,176,134,189,145,144,197,157,79,9,220,87,1,110,16,184,126,50,153,21,48,114,117,99,18,56,82,50,111,8,207,38,121,81,127,27,129,94,226,31,158,176,136,118,76,98,220,60,207,247,204,145,198,39,199,176,18,172,12,93,235,122,196,124,192,232,0,246,6,9,137,32,17,243,245,210,24,200,45,89,232,210,56,37,188,161,184,210,144,203,92,231,241,117,9,66,51,116,98,81,182,152,109,187,0,168,175,46,250,34,230,58,88,216,103,33,159,18,32,66,178,14,171,29,173,176,221,76,134,196,69,45,50,23,199,196,164,227,25,62,154,255,47,238,195,193,52,71,178,100,188,251,250,118,57,175,155,44,224,179,203,54,192,205,117,41,184,158,176,216,177,42,111,212,177,192,54,238,204,29,93,171,81,230,10,22,115,66,243,168,21,70,91,129,15,207,186,29,180,43,203,253,42,162,236,75,187,195,57,176,64,107,140,121,16,33,181,165,144,48,16,7,229,95,159,34,163,142,66,246,209,172,213,28,53,140,210,111,223,60,32,238,136,150,246,80,237,106,139,134,209,142,87,52,232,187,190,114,228,170,212,100,58,101,26,204,192,159,35,232,86,133,132,57,131,5,138,69,237,240,153,67,112,71,197,75,162,146,184,148,59,182,93,57,71,208,95,162,232,141,241,192,95,107,96,205,8,29,202,12,248,32,230,234,238,32,154,88,2,207,241,17,6,203,75,169,12,179,3,112,37,241,134,33,109,138,158,190,185,196,17,223,184,42,147,175,20,77,122,13,88,90,63,216,252,59,156,56,177,152,44,20,156,63,8,105,246,105,31,88,165,253,26,21,98,33,31,99,222,155,254,230,84,255,112,84,117,20,176,98,176,40,89,247,79,24,98,209,152,206,36,45,45,211,105,78,70,23,237,18,135,195,50,98,164,35,109,74,141,103,28,90,248,24,139,239,221,145,60,232,157,22,43,222,251,204,105,48,65,99,148,70,80,225,5,2,133,49,82,180,97,161,43,38,35,68,203,184,133,130,178,89,129,164,189,238,133,246,196,21,131,99,128,110,187,35,135,210,183,248,44,156,136,229,177,242,39,17,221,63,152,232,200,142,233,246,193,195,37,251,112,3,143,127,57,223,114,197,91,216,2,218,241,91,79,220,9,35,138,241,74,189,126,33,30,94,103,248,236,124,17,227,48,159,139,208,203,204,109,18,19,145,237,129,221,132,118,105,24,155,161,3,245,109,49,142,222,79,131,18,5,31,6,210,178,59,33,1,50,93,234,215,32,61,156,245,163,189,206,63,163,126,112,234,8,245,82,206,219,18,245,230,228,5,47,99,195,208,3,176,13,82,183,249,147,16,56,107,76,24,131,84,4,246,162,155,200,118,23,108,235,241,42,68,192,104,50,162,90,33,197,98,190,12,23,226,34,19,43,198,196,109,132,84,181,9,139,199,254,28,88,149,171,110,219,166,34,253,4,171,183,9,30,50,105,241,58,132,155,247,132,146,0,25,37,42,207,207,116,114,63,160,128,77,114,100,221,95,2,59,238,61,242,62,186,220,40,105,48,77,25,3,173,122,157,30,148,107,85,51,77,89,41,45,214,240,123,92,64,8,249,245,224,14,16,248,54,170,169,188,101,177,120,190,85,134,69,8,28,142,95,129,147,55,35,41,253,67,111,123,12,1,85,64,206,116,7,209,205,155,188,242,161,154,104,169,181,174,117,200,242,225,124,247,147,122,56,68,100,198,236,134,132,50,234,52,74,189,217,159,9,182,137,51,41,139,198,116,184,77,80,5,253,160,224,98,207,249,38,13,100,211,59,4,17,188,254,48,231,73,158,222,166,189,182,105,7,98,204,134,142,85,157,0,161,92,5,183,118,110,197,189,183,19,3,7,223,159,101,70,216,38,53,201,87,76,70,141,244,110,13,123,200,205,33,34,49,221,148,187,10,55,140,175,125,125,207,51,19,4,91,18,217,87,127,144,161,43,8,196,45,98,162,196,81,19,29,230,245,205,93,126,86,125,214,242,211,245,213,189,241,51,245,63,60,236,163,211,199,216,100,186,213,184,173,98,195,97,69,95,167,61,204,191,51,83,198,79,210,86,84,136,234,225,246,211,131,92,189,36,100,205,227,225,195,73,1,172,27,79,104,225,142,24,21,182,188,137,199,178,90,243,179,202,81,194,148,160,37,33,137,42,227,3,151,63,11,41,112,193,1,176,181,242,54,57,35,226,42,243,122,49,198,170,50,110,141,84,31,237,248,74,11,199,225,151,44,244,84,151,163,221,202,22,28,111,120,121,36,92,227,45,216,132,226,0,236,90,42,137,68,87,63,195,20,59,19,82,73,45,198,222,91,140,245,184,45,148,83,33,38,120,150,158,187,32,36,35,174,68,10,173,203,166,47,17,113,16,59,4,249,198,253,233,128,102,50,91,3,18,41,2,243,57,246,37,52,100,164,133,224,213,25,209,72,143,210,118,107,231,117,117,7,207,16,189,136,47,207,105,88,214,220,66,234,137,139,154,215,164,18,66,122,133,77,190,133,232,151,157,166,16,198,122,249,201,138,169,143,97,17,121,39,34,124,248,53,228,164,213,101,47,21,194,29,70,236,10,28,232,90,179,53,28,154,37,236,113,234,98,241,230,6,28,155,202,145,144,77,2,40,176,140,46,117,81,12,72,201,252,82,95,194,120,39,165,242,202,213,152,227,246,156,238,62,123,187,244,72,254,215,98,53,232,42,162,184,13,66,107,151,183,166,74,104,63,210,18,201,242,140,212,116,22,114,139,188,158,106,120,154,250,166,16,63,117,163,48,142,48,72,104,122,245,240,154,56,222,139,170,67,72,223,178,16,237,163,71,66,188,53,222,233,178,13,64,205,95,69,100,110,96,179,127,16,239,126,47,255,45,173,79,110,31,191,47,82,244,144,109,209,251,107,4,147,202,50,243,136,40,5,122,223,234,225,251,208,82,96,86,101,185,214,46,58,252,220,183,62,9,83,58,98,22,157,145,74,83,123,3,19,160,198,227,142,123,97,17,54,126,123,1,251,172,71,26,136,7,186,4,208,141,235,189,173,71,82,138,210,182,53,139,215,33,230,175,170,200,188,250,141,3,61,98,152,30,58,64,149,13,157,175,230,166,209,38,132,107,5,10,69,193,146,66,211,227,47,10,121,235,128,100,44,175,237,121,245,238,177,119,16,129,126,204,225,176,90,64,139,205,79,243,96,37,214,107,116,228,151,59,189,44,32,44,94,38,182,15,243,163,178,205,101,216,72,173,24,2,179,226,181,18,101,254,171,241,94,198,133,155,121,13,221,236,128,58,231,127,71,27,159,168,132,37,122,17,30,88,118,95,175,28,28,230,246,85,221,29,68,63,241,203,152,161,169,165,216,28,219,193,11,178,224,213,251,59,183,10,49,207,2,156,228,102,90,240,206,198,236,102,59,73,123,93,155,32,204,253,240,62,20,229,51,138,92,207,154,246,21,44,253,213,168,113,98,65,51,150,142,106,182,234,132,173,61,47,59,44,92,178,224,177,147,80,208,17,40,247,143,1,16,247,213,72,175,32,34,4,169,192,1,234,6,138,80,75,219,207,61,95,9,86,246,1,137,64,163,149,153,45,50,228,206,156,185,246,160,217,169,215,158,96,0,84,156,175,192,146,59,64,149,27,40,202,113,204,92,83,235,162,119,148,23,168,75,110,117,132,162,216,18,166,129,185,10,204,57,94,49,118,46,255,146,78,92,19,150,127,172,218,92,43,79,150,9,70,192,237,218,13,161,176,246,167,125,121,116,200,97,206,113,73,125,69,70,9,110,251,80,249,71,227,99,63,165,214,26,2,152,130,238,197,156,83,150,19,122,99,9,219,121,110,227,51,25,66,131,216,190,226,210,68,147,63,163,202,47,35,205,239,100,112,3,103,190,211,40,208,248,252,126,201,239,235,48,151,15,214,93,0,219,143,252,156,239,102,83,9,104,173,71,234,161,219,130,181,21,161,197,195,224,73,239,41,135,183,40,28,250,54,13,91,183,108,196,40,173,31,51,34,46,149,99,231,49,180,22,76,0,67,105,130,74,134,105,40,205,119,78,106,32,202,92,199,134,206,238,225,153,54,196,31,153,183,150,163,168,150,192,92,123,209,168,171,94,144,254,240,92,251,145,220,116,175,215,80,96,111,46,70,226,49,87,47,156,252,44,253,72,104,178,237,44,76,139,238,251,238,226,18,127,56,178,144,47,217,155,35,229,174,253,94,59,145,32,115,68,48,229,248,147,54,221,187,14,198,65,104,177,90,245,101,213,40,134,217,179,173,154,64,121,219,33,92,106,0,153,242,52,225,232,18,8,159,208,217,15,159,231,95,38,200,214,11,96,205,225,75,27,236,115,175,231,109,136,248,252,243,137,232,91,219,33,14,245,16,202,221,249,236,26,79,51,242,36,92,175,126,44,219,117,94,254,135,221,192,71,58,37,108,17,81,239,28,82,228,231,100,249,118,42,106,201,162,222,208,151,81,97,4,9,211,204,40,172,218,8,18,184,122,191,132,233,162,219,22,50,74,214,85,231,65,25,25,146,166,30,172,187,26,249,102,135,101,219,231,141,251,41,222,197,67,121,177,115,226,0,232,10,64,223,126,114,194,117,13,178,50,71,92,234,9,88,185,21,46,178,146,128,20,171,79,222,188,30,173,73,107,144,57,84,101,236,142,221,10,0,107,52,192,103,111,63,114,238,218,208,210,162,244,46,171,204,159,201,80,155,147,156,189,143,106,30,205,154,178,65,50,252,173,192,83,173,223,98,239,32,108,219,73,237,43,236,144,65,208,235,117,200,150,104,197,231,137,217,34,19,184,205,51,185,209,163,83,242,119,186,247,90,175,250,221,217,107,232,215,121,237,133,14,31,53,110,15,22,141,111,51,186,48,58,189,139,200,8,16,177,167,71,85,217,171,62,243,130,214,126,185,244,35,238,90,148,240,167,65,233,73,138,204,199,209,144,206,212,201,236,103,120,94,159,57,12,61,118,30,100,162,245,197,99,77,168,227,146,152,172,95,242,191,102,105,167,139,208,105,67,205,128,64,33,4,207,130,190,176,69,117,242,94,198,133,145,217,102,199,248,28,39,173,175,200,77,5,22,45,24,71,121,69,144,54,37,165,19,93,236,178,178,193,111,146,162,113,87,200,41,107,36,247,39,2,182,130,219,163,206,161,146,205,216,189,169,218,231,60,131,27,42,193,181,218,171,101,213,99,162,214,138,195,233,24,243,95,21,181,169,163,227,60,206,166,202,42,193,173,84,169,47,54,173,116,160,69,198,105,73,136,130,137,85,49,126,83,217,115,114,42,169,55,212,218,89,253,77,166,154,174,249,59,1,28,169,4,96,23,174,144,75,196,235,235,238,227,171,113,108,44,134,245,129,62,8,30,68,214,42,49,117,93,126,82,188,166,192,45,154,127,228,121,128,192,91,108,235,136,175,208,181,103,200,72,48,24,255,66,0,109,72,144,137,76,50,86,167,15,19,180,248,170,202,199,170,78,211,10,241,28,168,141,118,37,58,131,156,186,75,168,233,204,215,146,45,80,204,95,117,81,92,4,25,182,123,113,138,16,251,136,84,66,23,84,230,63,65,125,159,190,42,106,187,71,48,57,247,150,211,215,13,79,140,209,157,224,16,219,208,152,27,28,169,2,64,35,242,166,77,215,21,43,98,132,47,173,133,164,158,206,227,113,211,199,172,56,222,40,59,34,10,193,94,28,111,71,187,197,247,233,147,93,61,119,119,220,14,206,219,76,186,187,71,250,88,46,128,198,63,132,182,160,170,82,219,235,2,108,87,127,236,141,180,16,153,47,40,130,183,102,150,209,180,118,193,227,104,64,96,169,147,245,171,170,130,141,40,153,211,63,5,76,88,230,144,215,244,45,44,145,141,254,78,138,93,27,173,201,114,155,189,226,52,180,96,208,231,234,143,142,108,99,134,90,96,146,18,181,44,135,105,230,201,98,213,145,227,26,27,201,234,253,124,30,194,1,244,140,211,81,41,188,137,85,27,53,154,242,22,166,197,104,155,183,1,29,255,154,51,59,225,69,124,7,69,227,220,143,148,91,224,253,81,106,92,231,169,166,92,235,173,89,211,30,212,11,195,156,144,27,160,36,226,86,185,214,72,135,53,35,57,52,35,185,137,90,46,168,87,154,167,246,161,236,27,154,46,22,171,196,3,172,227,249,79,163,146,118,151,159,53,133,160,77,113,109,242,216,9,160,221,151,12,122,83,103,213,230,62,55,121,251,103,216,133,141,147,126,44,196,8,70,233,50,140,184,15,75,48,87,89,209,74,248,202,58,99,221,37,207,219,209,217,34,11,176,91,99,130,103,75,32,175,3,0,72,199,150,86,107,58,240,163,206,168,240,217,126,69,129,200,124,128,197,237,66,47,234,238,198,152,183,102,234,3,99,174,56,86,68,240,121,45,131,180,240,130,104,62,79,0,149,10,84,64,216,168,219,67,126,168,205,104,79,136,63,82,17,112,162,148,236,46,201,3,86,78,26,7,197,2,166,211,188,123,84,238,210,244,140,183,8,207,172,132,19,57,2,254,161,162,8,119,180,0,166,33,10,0,240,244,137,163,113,88,213,159,20,92,47,78,233,86,99,146,105,216,17,177,200,134,225,220,47,229,40,226,131,45,164,177,36,63,208,20,58,165,242,131,166,130,215,189,21,198,68,130,48,194,168,25,124,32,209,60,12,87,114,96,157,85,188,115,27,242,33,206,147,147,236,170,65,16,158,145,175,66,201,246,243,161,7,214,31,205,165,54,157,5,16,140,127,71,51,129,26,38,147,135,25,226,80,94,99,22,102,7,22,138,84,194,137,46,107,209,253,192,174,34,51,188,14,103,13,177,146,195,8,61,144,23,203,212,45,244,126,230,241,229,183,41,113,100,39,196,164,13,40,113,192,159,197,101,124,94,237,25,147,214,205,44,87,43,93,60,18,229,220,155,248,103,77,189,188,253,120,5,123,172,226,209,36,195,118,213,25,23,122,202,245,51,228,183,190,125,153,248,61,108,246,73,38,59,91,59,29,226,48,143,7,114,210,117,237,229,219,254,253,1,103,35,225,97,53,209,44,126,241,109,224,200,230,110,158,174,55,64,37,200,214,72,172,134,192,168,43,251,243,128,78,133,28,134,28,21,173,182,149,189,53,54,254,169,113,164,92,151,130,173,38,20,198,156,206,222,25,211,79,38,119,231,108,176,140,194,235,45,97,212,148,160,96,148,109,180,126,167,98,233,162,43,2,89,33,167,151,86,13,70,148,114,78,83,193,110,160,102,54,73,37,141,71,255,171,140,245,75,157,180,99,211,78,194,125,233,233,221,173,247,114,170,235,148,183,150,50,246,61,111,71,199,25,40,229,227,234,11,98,245,36,161,145,121,22,200,69,34,170,8,186,74,219,198,208,146,145,91,195,192,191,60,110,9,135,1,128,220,157,19,184,227,47,65,203,87,190,96,154,86,190,11,212,248,39,11,160,250,132,249,20,53,95,232,149,206,186,218,236,219,107,50,157,229,25,66,215,225,66,172,108,61,211,202,248,23,239,83,7,239,243,113,197,248,220,193,31,29,141,88,243,225,29,24,243,8,240,250,232,102,230,232,150,38,221,132,185,136,190,84,103,158,156,146,33,130,180,255,204,206,72,50,135,28,232,194,90,226,109,219,47,119,146,45,10,170,5,180,215,151,170,3,183,248,175,231,142,77,158,97,196,191,43,210,248,98,220,161,122,172,39,83,203,31,221,112,109,1,32,101,108,107,48,125,42,231,61,147,141,163,56,159,169,222,2,233,0,139,222,236,226,207,83,136,118,64,8,209,251,116,146,56,232,228,196,57,109,64,212,32,166,85,191,112,49,87,253,180,204,203,253,112,140,182,165,199,71,126,45,11,82,190,211,235,232,206,238,19,228,51,75,139,155,113,95,97,112,140,121,43,167,129,111,45,158,47,159,7,4,26,209,206,90,149,168,247,143,69,252,127,1,244,104,10,113,161,50,190,130,223,135,135,185,216,214,243,176,252,192,245,26,53,81,161,29,137,246,50,5,0,97,105,33,238,223,117,107,218,28,113,147,100,196,177,152,20,162,91,221,96,31,133,1,77,160,128,138,157,226,136,204,177,165,162,234,175,198,99,9,244,16,166,251,208,214,93,46,158,47,59,173,135,110,250,23,163,183,91,130,198,116,12,32,190,104,6,246,8,2,94,231,53,158,56,243,93,224,14,117,56,244,207,60,168,220,183,152,70,12,242,7,142,32,35,59,249,176,237,199,125,189,19,31,208,226,213,33,163,54,63,19,178,236,56,93,230,77,190,192,217,255,183,120,239,76,35,114,76,217,129,210,85,241,13,140,53,221,17,157,178,4,31,29,105,37,109,244,228,50,59,145,143,30,191,180,200,216,251,207,181,239,141,145,29,193,55,61,139,160,85,216,52,46,125,237,158,210,136,179,3,132,24,147,44,60,49,130,194,144,105,179,84,13,67,117,28,177,54,50,163,51,124,191,120,223,196,10,225,22,43,228,79,163,0,242,70,210,193,206,235,194,214,26,36,230,41,230,193,64,64,161,66,158,32,175,230,174,171,142,63,172,29,101,218,40,255,220,158,152,82,154,34,29,21,240,114,134,37,87,36,225,8,46,174,208,221,157,178,99,122,2,242,170,101,18,104,64,26,208,192,133,67,168,250,53,167,131,45,32,24,255,137,198,255,29,117,90,178,218,195,34,111,42,213,59,38,49,92,67,200,62,203,6,109,65,57,1,18,254,161,240,111,24,137,177,173,117,4,84,107,94,192,36,217,227,216,29,200,138,132,220,211,189,195,196,41,148,75,17,193,37,222,52,149,42,38,30,56,32,23,4,31,91,202,13,141,152,247,157,159,109,12,248,110,42,142,76,234,33,163,71,233,94,126,99,177,10,112,218,213,13,1,94,62,77,80,199,59,35,46,200,166,117,191,225,239,109,45,18,138,142,79,171,112,25,113,99,168,205,146,20,222,47,73,231,186,238,107,243,124,72,220,34,34,94,237,84,113,232,184,104,7,232,202,86,171,169,223,228,124,93,236,255,248,124,16,139,188,254,115,219,152,71,183,169,109,126,241,106,184,109,251,4,35,95,14,203,21,203,90,137,24,232,229,47,240,219,152,235,135,19,121,245,115,249,27,216,162,160,80,78,27,199,49,61,56,255,39,25,237,130,164,221,80,89,145,97,50,183,228,213,197,18,188,57,74,167,119,188,228,167,224,238,173,192,211,209,119,142,218,147,186,77,134,223,157,193,28,215,235,53,115,5,184,71,54,161,41,107,84,66,4,88,159,88,248,210,19,250,102,180,14,146,108,160,196,232,15,202,93,137,20,39,73,35,28,222,174,191,48,156,226,129,227,207,48,151,34,219,13,17,134,180,70,254,7,74,184,57,105,11,121,194,241,46,19,90,165,45,58,96,144,16,29,112,203,103,25,22,203,197,21,53,255,112,137,193,35,230,226,114,225,174,163,222,244,71,226,133,170,114,17,66,136,89,84,188,130,7,221,15,246,250,81,19,34,142,74,102,16,175,210,232,18,7,122,137,225,148,132,0,107,19,226,82,101,175,54,16,220,81,215,180,228,82,19,190,72,45,174,131,253,154,33,32,2,198,113,188,7,40,188,209,71,100,1,20,241,114,17,111,128,45,248,42,6,122,70,192,33,146,138,12,76,85,106,107,78,229,177,247,32,103,233,126,234,35,150,121,102,249,251,23,23,150,148,13,186,71,173,118,59,5,238,222,36,51,200,30,254,177,105,197,129,43,16,181,198,132,154,49,220,212,24,203,3,239,248,12,234,158,27,172,142,223,218,200,115,232,179,125,151,54,46,37,243,198,205,21,186,146,145,21,109,26,47,9,233,50,250,3,231,110,211,125,76,93,177,144,184,93,121,129,127,189,0,245,75,94,189,130,205,150,253,51,148,238,188,135,23,104,191,20,77,158,99,169,121,121,84,157,194,239,114,79,72,79,149,31,152,71,252,250,240,40,139,102,160,57,99,166,35,10,194,70,152,14,84,24,149,35,177,128,136,231,78,240,191,198,12,176,8,240,115,81,150,15,69,12,118,113,21,46,236,218,253,115,87,176,45,60,26,61,115,170,252,73,177,246,143,189,107,43,67,55,50,227,203,67,142,194,122,207,248,85,75,169,122,146,25,74,155,214,102,87,84,39,109,206,29,208,46,209,8,160,54,115,64,68,18,99,13,52,18,74,113,106,131,93,183,197,213,143,176,183,85,156,176,216,217,191,113,129,250,25,53,165,186,149,127,185,200,121,21,142,51,212,82,171,145,173,21,110,220,251,223,233,76,234,29,247,148,140,60,22,191,84,131,193,232,46,21,252,131,98,79,59,52,178,34,36,238,188,250,64,203,63,62,100,80,138,24,45,190,249,23,108,184,64,139,112,236,59,87,235,37,148,164,212,200,105,102,27,102,30,196,230,131,119,39,210,3,148,64,31,252,253,139,139,158,165,126,127,190,138,14,40,189,31,51,159,40,182,42,6,153,70,84,228,215,71,84,64,82,239,63,68,192,187,127,19,99,102,29,233,226,102,80,218,89,146,129,108,206,39,75,216,157,70,90,128,45,73,106,231,121,198,202,190,64,34,139,179,152,253,105,244,81,114,189,200,47,47,193,27,34,95,108,235,60,213,116,17,251,37,227,28,4,150,42,191,90,235,30,88,43,216,89,12,206,190,132,42,238,102,205,136,205,183,17,150,179,207,116,186,33,188,161,7,203,196,231,37,92,24,12,192,66,248,5,10,126,37,52,119,172,129,47,39,9,110,42,63,96,55,193,241,237,221,135,135,77,239,112,236,100,231,179,242,245,59,151,187,154,57,107,173,229,94,245,61,170,98,177,132,11,110,7,158,156,114,217,153,215,57,69,123,4,15,101,53,117,187,223,20,36,51,79,235,89,91,90,254,196,95,123,228,143,208,153,17,110,108,67,23,232,128,123,213,122,166,0,182,9,9,87,156,165,79,88,85,48,66,103,115,37,92,6,27,7,60,253,56,92,147,72,218,22,169,58,90,5,164,127,180,237,39,39,60,224,221,32,38,89,154,96,47,43,124,73,169,86,121,247,11,24,105,51,237,120,220,177,186,239,22,183,154,188,101,51,232,213,102,223,60,108,108,139,46,203,90,154,109,223,113,229,238,52,103,182,214,186,117,108,242,253,42,73,121,7,140,67,174,1,234,43,46,35,97,153,169,214,214,76,164,64,50,134,30,11,186,120,255,219,254,23,7,189,235,154,211,229,180,7,225,39,222,71,178,101,31,144,198,22,63,123,39,172,55,127,48,138,181,116,24,2,167,98,254,8,199,90,82,154,133,27,214,53,141,111,156,144,88,147,193,229,80,49,180,237,25,191,120,119,254,167,179,87,215,31,75,38,125,215,234,237,241,151,121,241,139,63,140,137,7,74,220,84,177,251,166,87,139,75,167,112,36,0,22,170,94,108,134,141,87,210,144,252,242,13,187,254,148,45,182,170,78,37,205,221,136,81,122,226,139,16,41,6,87,177,126,145,113,6,142,119,67,65,54,66,244,93,26,63,15,182,123,131,227,169,185,221,220,157,136,243,165,241,78,126,151,186,223,79,145,50,165,250,141,29,51,52,255,25,224,49,13,93,26,158,83,121,237,88,122,148,210,108,114,174,220,22,183,59,44,196,101,87,205,98,228,35,247,194,131,102,184,92,97,203,199,229,176,187,6,168,228,100,91,124,171,146,164,129,137,255,39,79,28,51,191,251,230,189,75,85,149,1,185,10,198,134,69,180,128,252,240,196,218,49,187,41,180,46,204,56,58,105,163,191,103,194,248,61,167,115,208,51,118,146,145,210,223,168,179,221,152,4,229,26,253,9,190,173,15,182,64,36,122,40,147,134,221,44,70,230,109,84,129,206,22,207,157,213,221,43,40,42,85,237,223,206,16,213,74,25,166,72,117,223,107,207,86,98,171,163,132,103,6,102,54,231,197,106,185,81,210,84,39,120,175,246,241,120,118,101,74,219,101,198,194,14,16,138,5,91,24,22,41,155,244,228,36,211,222,35,122,185,177,101,185,101,93,111,235,1,142,211,77,188,243,4,234,255,231,215,7,123,9,70,254,177,179,32,72,112,209,188,45,83,19,148,201,244,71,0,167,212,35,202,230,135,26,104,103,54,93,247,180,101,214,222,139,203,47,77,16,210,117,32,46,169,26,140,123,157,216,128,18,232,166,30,206,255,235,185,25,207,58,82,162,240,108,218,115,237,15,98,200,216,233,219,166,70,158,230,224,23,0,97,51,225,40,61,94,60,106,154,215,190,215,100,68,30,48,103,89,185,94,95,248,122,228,131,195,201,76,55,210,207,56,202,59,162,121,239,71,89,153,194,249,38,219,229,11,141,101,50,94,12,220,17,68,167,76,80,150,55,230,199,179,88,139,250,171,88,39,215,169,140,43,183,49,47,239,159,250,67,174,46,65,13,72,39,243,189,147,222,21,229,160,76,164,119,110,34,195,62,188,22,206,163,20,95,134,162,121,14,23,241,54,200,251,225,142,128,31,191,94,2,217,157,121,68,12,137,177,60,228,108,124,33,179,161,65,62,246,161,41,182,37,145,155,196,92,152,20,130,91,68,107,239,226,231,77,218,28,97,0,167,209,178,193,225,212,170,162,175,186,25,179,119,16,218,96,47,207,98,241,142,8,134,61,58,156,81,31,125,14,79,83,171,211,23,185,113,71,137,52,252,79,187,178,182,124,220,2,230,93,47,158,39,52,47,58,114,101,145,116,113,43,14,98,115,176,158,69,17,89,46,223,25,213,231,135,91,171,25,162,212,97,184,109,7,125,112,188,48,203,165,85,151,9,136,48,166,141,220,27,112,28,190,168,151,166,4,242,91,148,18,31,128,83,105,213,95,5,17,41,167,154,121,181,152,206,170,171,12,219,3,101,95,72,132,16,88,39,209,59,74,31,66,72,2,60,108,185,180,95,161,52,50,103,142,33,178,233,216,247,6,250,248,196,58,244,125,239,214,174,24,139,33,76,247,67,79,10,9,145,76,250,228,199,16,32,215,170,124,214,220,242,37,14,241,6,120,224,145,172,251,99,253,212,32,235,17,3,221,192,247,121,183,144,194,193,66,12,3,8,142,39,187,39,203,146,177,78,196,143,168,73,120,136,117,245,252,155,251,128,212,77,75,203,80,44,81,209,233,164,197,75,128,83,182,250,163,34,228,118,97,133,208,159,235,188,185,128,106,120,48,95,160,217,210,16,165,61,138,230,206,20,91,189,36,68,226,50,3,214,150,98,37,41,104,26,123,237,105,240,120,231,55,220,88,207,72,93,19,60,139,242,30,64,54,179,239,66,28,201,66,137,132,122,217,81,235,247,142,227,240,249,109,188,198,185,194,166,173,137,172,141,254,3,240,11,242,189,140,134,86,88,22,125,165,180,217,232,105,13,38,220,88,19,120,68,145,85,93,7,198,75,134,6,146,13,87,139,176,151,59,159,124,152,134,185,158,74,30,153,165,237,177,203,90,251,10,231,130,220,53,252,173,88,75,117,150,88,191,124,111,154,33,242,255,104,174,135,146,229,118,147,33,75,68,138,122,82,81,217,205,225,92,149,218,31,78,252,91,194,72,120,142,165,75,128,127,118,210,111,67,188,198,162,73,132,36,118,205,242,236,155,198,250,86,78,144,140,22,77,150,200,90,188,216,241,206,85,31,130,115,1,115,187,9,91,186,182,214,254,185,133,202,124,147,144,207,230,209,78,246,145,148,219,166,113,250,43,75,174,245,252,77,67,163,78,118,85,221,119,222,124,78,117,97,1,97,221,35,161,153,238,231,17,191,174,118,191,82,53,229,55,112,136,61,148,24,172,79,161,219,173,146,5,82,246,163,28,111,101,178,176,76,185,33,11,91,211,240,159,108,114,251,228,81,81,154,223,87,52,145,247,235,214,214,41,179,0,0,15,162,238,187,108,108,58,72,34,225,195,91,70,196,1,95,236,152,254,140,183,140,172,58,219,26,231,81,93,6,3,128,56,158,153,44,217,147,58,86,250,108,65,55,154,252,71,158,14,66,218,89,240,29,236,97,167,101,249,104,137,83,0,85,25,4,40,230,152,106,213,12,37,237,139,226,113,86,242,222,90,140,166,93,164,253,0,218,161,94,47,149,39,117,234,35,107,164,228,93,234,180,120,13,212,17,72,120,254,211,242,163,60,117,243,122,247,225,76,29,243,123,172,58,28,106,37,165,159,88,118,14,5,194,158,50,248,141,38,198,209,68,234,188,7,201,87,11,126,55,184,14,182,216,242,154,213,183,57,72,1,167,135,30,139,226,144,124,152,231,48,129,175,42,3,35,134,173,111,6,158,211,158,67,92,158,221,78,152,132,135,120,124,93,94,7,214,209,214,253,116,50,80,150,216,226,67,33,175,73,107,38,17,216,33,3,200,126,226,76,176,241,31,194,134,207,14,236,50,215,227,186,120,247,220,31,205,30,204,166,233,172,177,244,42,146,249,128,163,193,205,122,217,35,8,180,241,33,23,198,140,251,230,198,139,79,149,173,102,206,204,2,185,194,165,118,64,63,65,13,1,228,97,76,102,224,191,56,228,142,109,238,184,87,104,216,28,176,84,32,127,216,167,1,55,147,247,84,84,154,172,206,55,201,213,177,130,7,73,248,163,166,186,132,189,219,63,39,133,210,162,214,173,109,31,120,105,174,62,76,231,183,206,167,69,45,8,156,66,134,8,245,212,1,191,197,189,176,141,124,89,70,123,75,58,191,62,59,246,109,94,252,183,149,30,36,51,104,75,115,184,112,63,227,205,209,50,158,163,224,170,55,166,51,94,143,88,195,180,191,227,140,155,173,172,72,181,239,136,35,143,42,202,25,241,22,27,57,122,95,219,217,174,178,135,5,90,130,166,185,26,41,224,45,95,105,68,220,79,80,184,16,136,199,125,131,96,10,137,46,176,43,163,50,157,73,29,29,61,106,216,53,222,79,34,185,141,73,235,82,54,15,238,120,21,78,239,99,135,94,0,16,33,14,43,223,160,18,13,240,207,198,68,178,95,79,22,196,178,64,31,19,44,156,108,26,223,53,248,178,148,41,142,43,141,255,152,192,91,47,250,4,151,5,237,141,136,193,51,43,142,184,47,184,127,240,116,64,46,26,88,246,109,98,239,76,157,225,48,55,32,73,243,243,250,48,160,27,0,138,230,111,126,98,142,255,144,104,191,181,196,94,32,43,29,248,112,221,239,38,203,202,80,140,239,84,128,87,24,78,31,125,118,93,187,34,125,160,56,90,220,175,125,107,12,136,102,70,230,21,167,199,20,100,153,210,159,219,149,88,51,44,153,16,168,61,245,232,86,3,66,23,12,172,209,64,75,206,236,85,226,184,223,20,6,34,172,254,146,6,190,104,122,85,62,18,242,148,19,64,114,141,89,150,176,62,208,125,97,111,238,174,15,133,93,233,177,110,135,98,103,100,246,236,93,25,82,78,23,165,1,127,15,23,97,173,139,144,120,136,13,194,148,153,242,114,99,110,162,235,4,2,79,29,216,23,52,176,37,41,148,28,78,60,51,119,79,54,229,92,133,30,4,67,112,221,10,76,151,247,244,214,210,76,132,26,207,192,236,9,105,150,164,45,154,22,26,25,85,188,174,159,252,60,167,156,220,159,25,219,220,2,46,200,138,50,87,21,61,205,192,78,217,49,206,78,228,91,153,131,192,100,119,94,65,32,69,9,229,17,121,248,110,199,236,125,178,191,99,75,101,120,234,236,195,26,29,205,208,235,152,111,96,107,14,236,35,163,254,10,216,164,93,102,197,137,193,143,103,54,150,127,106,131,211,123,206,40,69,229,189,115,186,187,38,79,60,197,113,28,168,17,11,98,167,241,74,96,165,46,105,240,228,166,70,54,67,13,132,32,100,240,180,20,180,121,65,173,248,243,220,255,95,160,194,161,228,99,195,121,130,113,208,26,191,34,221,161,62,179,218,248,181,119,227,117,214,149,236,124,45,99,209,131,17,162,123,45,138,198,96,52,151,193,94,105,106,194,134,141,231,158,108,246,180,43,189,114,165,74,178,21,218,135,134,195,194,103,26,99,203,171,176,171,82,253,22,251,49,225,66,160,74,110,193,190,54,199,133,74,242,209,158,133,237,36,90,130,41,34,146,116,152,95,242,215,87,26,171,162,203,122,148,136,181,169,139,130,180,118,130,54,205,137,78,191,155,199,119,229,244,112,77,100,157,254,243,116,208,246,90,172,110,7,135,144,85,128,206,213,90,59,74,47,185,213,149,109,213,79,200,183,228,175,215,109,119,126,121,9,9,78,171,191,57,112,244,14,133,72,250,143,31,208,79,239,220,33,194,1,193,35,145,101,247,101,199,189,122,64,123,67,16,254,202,128,90,3,79,140,196,93,108,106,98,108,20,118,160,116,77,62,44,81,152,35,4,132,93,124,86,62,114,239,129,37,191,8,157,238,108,13,95,255,204,44,225,151,82,55,220,75,183,128,38,154,148,152,181,48,227,108,211,161,69,188,196,253,223,155,237,215,216,33,246,6,75,221,218,245,83,34,196,211,23,122,40,145,169,200,58,25,36,1,106,16,228,60,210,25,52,145,142,41,234,87,66,61,177,57,241,200,205,115,181,17,172,182,176,3,252,181,136,243,123,22,17,16,125,223,59,50,40,134,98,206,21,101,27,67,21,187,84,253,85,93,34,11,31,228,177,223,51,222,5,242,56,253,56,88,80,21,93,249,220,238,152,141,240,90,74,60,54,221,8,181,230,59,113,106,65,37,204,82,90,63,44,1,125,121,205,212,39,229,38,192,47,150,142,238,206,230,207,61,3,19,115,188,53,23,83,155,134,119,182,138,36,234,163,27,151,75,224,207,11,20,193,62,107,28,36,24,69,1,203,235,88,122,13,244,5,110,184,33,105,103,180,207,122,1,64,8,150,146,32,187,70,84,135,190,255,75,3,145,122,127,180,149,57,80,56,70,101,209,80,178,64,224,78,111,30,230,164,141,209,45,41,14,61,104,156,84,165,161,50,211,81,132,131,99,61,2,69,255,99,174,82,94,22,220,118,206,15,191,111,104,68,45,63,50,167,247,142,64,149,104,85,20,193,179,178,214,211,38,46,25,172,131,84,122,60,202,199,10,37,182,79,188,232,131,115,18,104,175,246,121,109,147,171,33,144,188,250,204,213,30,112,92,127,37,219,142,228,205,91,218,69,13,141,172,132,122,28,92,0,12,217,208,172,42,225,129,90,235,47,251,30,101,55,127,162,97,167,122,42,53,163,237,24,40,121,218,191,58,178,147,155,116,111,227,63,92,201,174,88,81,45,241,3,185,29,137,233,105,177,167,205,212,189,76,39,88,15,127,5,157,18,61,146,45,213,211,170,16,97,20,178,90,108,156,200,162,29,89,26,59,225,61,251,119,0,145,190,45,120,63,157,147,115,102,150,18,78,213,50,179,32,153,62,151,203,177,186,194,82,216,92,173,169,40,20,88,98,240,253,146,177,117,58,185,3,12,238,197,4,76,164,204,31,117,221,171,227,161,237,157,130,76,217,86,203,146,223,20,172,107,21,64,99,255,242,235,202,253,56,103,173,205,163,91,103,149,127,147,250,237,194,215,137,253,9,118,166,14,51,46,160,5,119,90,63,59,76,250,87,45,116,254,238,195,117,212,191,43,28,233,6,203,90,24,153,83,230,243,72,47,25,54,201,205,117,204,110,177,194,227,26,243,254,104,37,196,176,116,43,199,150,54,169,176,10,121,236,232,210,200,23,33,255,203,249,49,26,69,122,71,180,79,188,247,71,123,74,223,130,121,245,24,121,13,205,196,193,102,32,33,36,46,163,12,243,78,222,44,247,50,210,170,220,175,184,192,182,16,42,2,227,137,64,115,251,247,216,134,194,170,240,21,213,16,187,35,22,96,144,224,44,20,87,41,233,159,190,14,124,35,45,4,162,197,241,56,111,224,201,240,149,3,99,35,182,14,251,214,168,157,128,211,62,106,250,10,135,248,28,103,14,31,21,204,151,196,123,101,48,61,252,148,61,82,190,86,164,20,141,80,223,72,97,1,246,58,217,96,227,104,112,45,78,156,234,86,44,11,222,101,152,6,170,108,204,4,123,83,58,103,195,76,66,97,237,37,25,64,155,80,62,242,6,167,211,120,254,40,70,203,87,53,98,4,15,115,172,238,205,106,232,27,234,166,128,106,143,208,60,61,209,159,106,11,153,226,152,73,83,255,189,201,217,188,38,217,171,150,201,49,23,245,242,52,190,242,32,0,162,241,35,141,143,37,79,191,65,40,187,245,124,218,30,148,86,237,14,89,87,230,99,19,123,221,231,146,213,175,129,197,50,109,195,226,58,87,162,77,210,92,114,91,139,120,41,197,121,77,82,113,117,186,133,26,148,120,107,238,167,177,71,53,43,87,1,198,206,232,181,201,214,81,83,213,215,135,209,95,126,178,113,80,128,142,177,239,56,71,1,150,194,222,189,180,205,74,36,170,57,243,143,102,165,221,166,11,236,51,188,106,78,230,10,31,91,71,51,91,58,150,58,167,71,188,105,94,196,194,70,209,183,228,17,111,132,112,36,171,161,98,153,79,75,77,130,232,90,19,125,127,206,224,79,102,174,188,70,254,174,116,1,146,51,194,231,202,91,173,127,254,190,121,14,158,88,44,33,166,232,35,38,242,157,25,180,62,24,136,199,75,173,118,227,15,91,165,126,79,176,52,219,215,63,85,136,50,27,174,140,194,186,243,80,88,198,92,45,227,150,220,254,122,83,40,192,121,187,23,144,79,157,20,30,173,118,161,204,64,188,58,192,22,68,158,56,95,154,202,249,35,62,245,47,54,17,244,77,7,236,240,0,248,172,233,194,80,22,116,221,142,27,129,255,17,253,44,39,222,189,114,126,104,139,53,18,238,163,54,69,72,224,165,72,86,16,160,118,33,109,14,163,47,49,108,96,180,90,105,174,216,170,55,138,121,33,147,0,150,149,20,1,45,160,1,106,96,113,224,203,123,13,33,83,203,183,255,114,117,60,85,101,213,55,125,196,156,239,114,14,239,3,60,108,3,239,22,142,255,60,150,227,89,19,149,150,17,254,122,225,217,5,163,173,55,6,131,0,235,126,208,80,59,69,82,166,101,177,109,98,169,156,74,49,215,230,118,10,67,24,213,62,72,137,16,77,147,84,121,196,96,241,9,213,117,195,226,40,146,155,231,189,178,186,139,9,37,176,79,125,168,95,93,18,185,210,0,188,20,157,13,85,174,199,251,106,126,115,216,77,33,64,86,250,145,151,56,11,67,192,37,174,1,104,243,193,163,41,4,9,118,45,46,230,137,1,87,235,15,2,1,220,27,0,8,234,171,94,218,155,219,67,77,49,83,52,248,249,58,189,117,244,147,16,207,127,28,202,56,19,106,124,227,191,28,234,18,216,177,204,192,26,141,63,224,59,52,228,228,70,159,231,36,71,239,223,106,105,81,153,121,62,8,106,35,40,68,63,93,18,197,115,125,237,101,191,104,179,255,139,91,154,87,197,76,112,201,212,215,43,202,13,242,143,32,11,224,163,169,14,72,249,163,77,206,192,47,28,191,16,201,231,65,166,87,193,88,197,152,211,253,16,36,53,128,110,3,240,119,24,170,201,154,52,124,181,230,167,120,109,163,181,42,135,63,10,86,221,26,203,205,155,6,55,109,95,99,170,243,242,106,221,126,27,3,182,72,80,92,203,220,107,230,74,83,197,218,103,254,216,245,125,109,191,229,30,129,103,153,57,231,247,98,59,34,140,23,75,78,96,55,19,126,131,86,188,150,153,109,178,193,96,7,121,201,15,77,143,26,156,230,37,238,222,115,180,119,229,223,13,215,232,194,40,5,5,214,28,123,132,136,0,238,17,224,110,54,238,209,83,222,159,218,14,56,72,74,206,172,206,136,208,6,249,34,35,185,225,229,96,50,160,113,235,121,19,18,103,174,71,15,219,90,126,245,248,192,191,234,40,215,90,204,60,142,199,164,165,64,74,185,124,181,215,0,108,105,79,54,229,68,208,220,207,167,177,86,139,255,183,40,189,202,232,63,71,163,67,102,146,255,106,226,214,184,21,108,124,52,134,194,229,149,160,157,223,133,116,53,248,238,211,9,144,205,143,145,186,104,76,175,132,180,187,166,31,127,184,141,140,47,131,122,63,87,163,188,30,13,235,126,242,19,1,113,107,43,151,180,208,35,178,111,91,10,238,151,39,122,39,18,149,33,197,188,165,99,192,103,43,169,242,45,102,141,127,173,100,92,216,225,83,103,254,241,80,244,14,111,81,154,131,78,152,115,235,182,77,34,18,50,107,219,208,76,161,13,29,26,79,180,79,252,247,43,58,193,122,246,161,65,11,102,183,92,109,69,104,64,232,17,210,146,87,150,2,100,194,62,145,166,200,246,133,22,18,200,168,144,42,217,225,115,1,120,175,79,221,51,67,71,201,197,244,240,78,178,169,154,112,248,215,28,157,34,155,207,93,80,246,78,104,230,53,170,252,8,238,195,12,122,223,187,239,217,87,220,64,14,144,189,40,64,36,186,12,42,249,246,193,111,48,210,229,185,80,13,105,192,48,89,216,169,108,161,161,210,46,11,55,1,197,62,81,248,12,30,212,54,227,140,82,48,199,204,232,218,44,145,186,238,253,21,24,7,11,11,200,32,203,142,204,69,224,158,102,3,7,108,56,130,26,113,34,218,161,195,124,168,224,74,73,216,95,116,169,163,100,35,114,205,38,108,0,56,55,189,122,134,23,103,86,206,213,73,6,121,223,16,156,35,223,251,206,75,84,139,11,140,74,208,151,244,163,63,38,49,240,158,36,48,186,254,120,248,134,41,32,167,45,95,5,132,102,202,22,231,120,194,114,70,175,220,48,58,179,91,186,232,100,53,64,94,40,44,125,24,22,226,156,40,236,82,25,218,4,220,169,170,159,222,125,191,5,70,92,11,139,93,6,141,96,237,96,62,17,133,92,183,246,151,252,19,119,90,174,1,204,177,187,160,118,15,54,119,46,104,111,151,245,109,97,75,134,42,155,182,46,30,180,251,53,133,32,114,172,74,62,150,15,149,186,119,157,130,255,163,110,242,13,87,0,43,190,203,198,177,135,89,41,190,205,141,0,6,33,206,81,207,118,32,39,195,150,147,149,254,224,101,206,115,129,186,172,175,200,205,57,43,135,247,130,153,40,1,197,26,79,200,36,26,68,41,73,88,186,117,4,39,164,138,110,129,141,241,125,2,196,46,29,97,146,157,135,182,144,159,151,82,73,73,90,132,187,163,98,8,186,182,150,213,27,70,222,154,56,200,114,185,11,52,137,187,121,85,50,17,250,191,134,50,218,37,222,232,199,96,158,213,188,219,197,118,14,67,100,185,12,83,116,25,113,137,21,224,56,22,191,50,11,110,154,82,48,199,10,43,23,247,214,50,32,121,169,106,202,68,164,53,125,78,64,245,18,109,229,74,120,194,165,179,242,148,155,42,43,33,248,36,90,204,247,188,128,117,100,175,232,81,170,223,87,73,41,16,90,76,185,41,210,225,80,237,126,105,165,28,148,63,166,190,51,159,37,113,32,69,27,70,40,13,62,175,130,39,135,31,82,54,52,102,219,42,237,204,141,180,53,153,27,130,145,245,58,166,144,162,112,1,230,238,1,140,189,148,178,104,56,214,237,79,113,114,253,7,0,38,53,35,8,63,169,157,90,206,172,188,147,86,144,33,237,135,159,146,230,188,133,185,27,164,250,245,74,135,26,25,209,154,209,214,191,148,117,247,228,22,213,54,141,161,34,73,125,173,97,96,106,95,65,226,103,65,185,83,251,2,220,213,236,22,119,187,99,103,164,7,27,106,232,173,150,254,112,227,37,64,1,13,158,147,71,55,73,111,108,92,107,113,45,246,240,217,61,116,33,162,27,53,30,132,206,90,84,136,56,87,162,120,241,191,101,47,39,174,42,20,92,53,99,91,28,155,100,225,190,247,201,207,61,218,98,122,62,254,41,202,14,244,142,29,75,237,110,172,58,113,193,194,38,190,30,115,29,201,27,242,40,223,123,160,106,225,15,46,215,90,32,99,200,100,171,7,158,120,61,78,252,41,16,240,232,45,204,117,132,255,190,70,24,138,186,237,129,202,225,156,6,29,130,145,160,230,36,232,112,40,177,59,35,220,81,190,21,52,32,18,146,12,73,200,82,128,136,155,44,1,97,4,57,196,59,71,83,98,144,248,29,66,116,96,242,46,90,48,11,162,12,81,226,0,34,155,13,91,53,245,242,158,62,205,133,209,128,18,221,192,241,253,182,255,178,158,143,105,171,92,255,253,73,232,205,166,133,211,117,77,149,102,142,52,158,66,219,45,47,243,200,221,181,119,26,45,126,133,237,2,233,81,237,180,95,173,1,129,254,162,173,10,102,246,125,20,13,87,170,77,152,76,37,171,66,239,150,109,146,227,47,207,176,218,56,63,33,91,28,234,121,145,2,36,117,18,203,164,132,194,50,219,213,217,91,51,84,241,11,6,236,232,24,71,187,196,125,244,218,82,21,121,26,146,196,194,154,215,232,13,52,190,1,203,2,227,216,45,129,130,39,249,40,136,96,72,125,202,201,94,107,168,119,55,39,248,226,175,106,232,144,245,14,125,82,219,239,156,7,195,211,178,69,28,203,96,43,235,165,33,17,58,180,214,121,71,246,185,160,188,48,224,208,153,145,32,176,206,37,190,53,86,50,210,245,254,94,245,177,8,91,37,81,128,43,129,247,128,179,236,123,137,190,255,215,94,207,206,25,198,242,151,173,52,204,232,36,149,87,52,107,216,38,147,112,184,146,238,91,243,209,208,107,66,150,223,16,29,49,26,62,153,137,23,91,152,0,248,14,120,175,76,73,42,30,193,6,186,99,149,114,154,51,188,19,47,23,18,44,5,131,115,87,237,62,111,73,194,227,187,126,209,185,51,153,231,110,153,35,195,0,206,109,242,3,238,68,21,99,137,113,62,190,242,109,97,123,31,158,240,8,172,132,148,153,202,226,112,109,206,246,172,166,63,33,69,136,250,28,10,157,158,230,103,254,107,124,245,179,160,226,190,48,87,0,169,226,125,201,3,43,110,112,222,109,4,91,29,154,197,97,68,139,168,232,76,133,93,109,62,231,149,85,100,152,41,182,132,144,240,236,199,138,211,206,15,201,12,198,253,192,243,141,189,2,21,38,140,89,188,235,46,122,179,18,185,243,212,41,237,109,113,197,9,225,239,206,26,130,88,216,141,48,223,241,39,232,99,43,20,192,82,59,216,169,95,64,194,0,71,64,150,147,31,120,229,26,155,3,188,194,4,37,15,48,56,187,157,50,167,94,152,142,91,198,182,209,43,137,215,199,203,63,52,234,116,98,160,43,251,226,24,32,218,145,123,250,209,31,170,45,41,86,34,190,199,4,104,67,3,114,80,26,90,25,235,186,81,168,95,24,197,34,93,144,98,101,105,213,88,9,47,248,231,194,198,236,8,134,187,161,42,98,17,238,87,115,10,3,69,209,56,71,237,237,178,174,23,115,6,100,203,173,68,135,246,40,165,254,156,206,136,44,119,152,38,52,248,234,174,183,50,249,150,211,204,37,11,35,188,35,96,30,197,124,48,161,4,254,57,96,248,187,156,254,230,99,140,86,136,33,111,226,183,197,97,201,31,158,81,47,129,186,100,187,213,248,111,61,105,19,33,251,209,141,74,220,222,19,146,83,191,52,39,96,39,65,252,230,134,75,123,206,24,254,231,239,66,201,176,137,195,161,92,87,48,101,241,128,114,28,24,85,205,153,126,195,39,14,150,221,155,61,94,169,146,37,225,165,152,17,99,184,110,146,79,19,142,173,247,139,82,216,186,179,211,237,184,24,58,100,210,122,173,199,149,77,84,69,37,247,136,185,104,227,129,203,171,155,110,253,178,183,227,71,169,172,81,181,142,149,74,116,146,222,186,200,117,82,138,133,62,185,13,203,145,136,3,198,50,73,47,158,49,159,104,185,0,153,26,170,232,249,102,188,166,239,184,134,222,70,204,46,130,156,149,133,24,11,218,157,139,12,224,208,2,144,225,237,118,21,51,253,65,51,57,247,201,85,106,143,136,204,233,134,246,175,138,136,39,225,209,10,13,3,252,248,0,232,13,10,102,42,219,136,108,89,35,142,91,36,254,40,70,63,63,110,147,13,206,114,40,214,31,104,197,147,173,250,87,124,8,133,228,110,73,133,47,81,254,250,240,157,156,71,14,108,101,148,9,245,74,114,26,238,8,71,16,111,59,13,200,10,53,58,137,147,82,122,213,195,143,164,147,96,32,16,56,242,201,68,208,126,118,170,14,5,152,190,233,139,66,8,64,72,191,241,230,187,97,54,32,122,94,125,197,126,61,193,29,201,212,158,164,81,126,89,64,163,170,88,166,150,165,44,102,114,2,252,8,244,7,71,22,73,3,217,162,9,56,22,140,250,29,22,131,37,13,191,182,89,43,41,184,189,39,87,3,157,68,10,22,106,82,154,51,221,96,123,140,29,221,50,128,145,85,90,170,11,244,43,126,160,108,208,249,161,222,29,189,158,170,101,34,76,47,41,110,248,208,183,3,18,186,199,27,157,247,232,130,249,153,230,67,200,214,236,230,175,190,136,125,245,89,74,210,140,8,233,29,12,220,38,26,130,49,66,6,219,140,24,48,130,215,101,242,251,219,221,43,174,56,160,214,88,142,40,9,106,213,250,155,178,29,205,61,215,110,17,226,25,121,66,47,203,79,188,173,203,127,237,3,248,252,75,237,58,123,43,222,103,175,105,110,1,74,108,175,68,74,91,217,252,109,113,83,40,63,66,175,33,192,32,168,69,162,113,144,234,193,123,32,59,67,228,54,125,193,74,117,95,107,3,190,69,156,180,81,27,167,35,46,208,195,129,38,50,95,174,188,59,64,146,193,190,15,48,14,69,102,89,49,198,63,113,38,208,231,98,123,155,4,13,251,83,192,10,145,177,113,103,248,60,154,38,232,138,216,38,66,222,144,209,186,135,13,130,10,130,163,27,82,172,37,83,195,200,161,43,44,235,41,39,224,132,210,172,141,204,118,6,167,56,121,149,174,147,229,176,163,171,50,48,45,237,235,130,129,237,77,97,9,35,225,98,39,186,139,83,197,141,206,83,207,10,109,234,179,55,135,225,95,216,162,113,227,39,53,62,212,27,90,80,129,32,240,28,215,121,186,97,171,178,172,63,241,198,208,1,100,32,146,20,173,84,229,253,82,82,23,37,61,10,26,214,150,253,222,190,251,43,235,208,6,31,131,9,214,0,119,82,33,78,181,38,128,75,81,1,41,106,73,41,191,241,37,143,100,151,196,104,78,35,196,136,14,96,229,52,55,219,234,172,154,97,117,93,98,157,22,19,146,137,27,7,25,243,163,177,48,80,16,246,118,51,50,131,125,61,252,92,85,11,207,162,7,74,148,49,223,169,179,216,89,63,101,2,53,254,143,228,247,176,245,40,188,85,7,178,200,51,182,175,52,101,187,250,111,6,42,41,145,69,212,234,176,220,120,233,169,198,112,146,171,163,101,190,76,41,186,199,88,247,189,130,186,134,120,185,49,186,110,210,39,189,204,189,153,137,17,95,2,46,195,224,52,209,136,232,143,96,182,9,44,63,108,14,10,132,81,160,74,134,142,125,34,36,254,53,1,159,20,44,26,108,20,191,51,89,240,61,69,115,225,129,102,44,136,216,121,167,215,2,95,14,176,185,95,217,154,22,230,250,184,96,101,234,24,82,255,94,126,126,240,19,16,90,84,135,117,7,29,56,56,237,79,157,62,127,102,235,59,106,201,149,227,246,234,86,71,225,97,63,179,28,33,224,105,218,179,33,104,91,40,75,62,196,8,68,238,208,43,208,83,216,234,124,219,237,88,159,148,242,100,103,113,199,255,218,100,56,41,44,84,163,125,40,85,67,4,144,185,217,165,233,158,131,76,8,154,131,220,7,11,70,176,157,16,178,125,23,74,211,216,82,63,80,92,45,30,237,94,165,152,112,136,117,233,0,14,11,174,117,31,15,193,28,197,152,248,182,66,244,173,255,242,152,21,200,103,70,83,143,60,49,104,201,213,242,247,230,199,231,3,27,204,8,10,190,14,40,201,176,204,217,177,244,167,87,121,139,232,245,33,226,105,7,240,51,125,84,4,60,85,136,168,199,26,64,197,111,59,52,91,21,42,95,104,3,22,80,146,62,251,88,170,95,56,147,144,180,80,168,189,161,220,91,234,244,169,191,70,235,143,244,132,47,161,234,91,128,102,241,58,214,47,116,248,172,252,246,2,246,164,98,20,48,221,124,127,112,149,48,229,15,187,90,5,66,220,192,210,90,109,101,153,196,92,217,131,45,219,191,94,118,67,175,206,121,58,23,185,85,48,203,46,34,250,181,210,71,131,162,8,136,225,132,142,166,71,40,26,24,219,51,172,75,10,129,9,174,145,124,102,10,117,200,77,187,127,159,77,174,48,215,168,215,65,139,13,195,27,206,154,189,28,90,105,122,130,225,94,130,204,27,49,185,206,44,63,24,36,94,7,132,227,213,234,98,117,54,152,76,193,122,135,178,23,36,187,16,224,239,159,157,182,64,81,38,20,31,163,208,51,100,18,126,102,27,42,197,87,71,56,189,74,227,190,45,23,79,214,10,56,30,104,184,247,115,28,114,14,10,78,118,233,249,118,111,162,80,123,167,141,144,129,38,232,194,108,218,53,232,37,121,188,234,49,110,115,64,248,133,158,28,56,30,82,131,24,172,234,50,254,0,195,31,52,116,208,8,205,192,39,53,167,212,31,48,60,64,15,192,59,10,252,74,204,239,176,56,95,124,69,29,244,64,150,1,10,172,228,53,12,44,53,163,17,239,218,33,251,181,64,184,100,77,250,252,19,78,125,135,127,96,11,66,198,7,206,21,83,166,103,239,248,125,224,224,183,130,65,237,57,53,238,189,129,149,43,83,230,249,228,245,152,89,195,105,223,149,9,92,254,147,244,174,46,226,172,20,63,97,20,15,216,91,7,235,143,46,15,31,99,12,51,224,209,123,192,173,75,172,146,163,97,150,126,232,173,216,42,216,78,186,69,71,13,189,140,220,141,115,100,28,78,249,97,63,243,205,211,167,200,131,131,8,103,213,11,7,201,187,6,161,87,191,154,16,173,202,140,247,132,56,158,197,6,174,186,18,219,195,160,176,71,207,18,33,98,216,150,92,191,130,152,240,1,216,203,60,196,68,15,130,153,80,141,166,216,22,214,183,95,97,116,197,165,136,114,160,183,76,174,172,227,243,202,196,45,22,185,196,200,126,225,46,21,124,149,181,95,136,33,222,230,26,80,153,152,242,0,23,193,43,203,168,108,20,33,251,192,15,5,70,6,178,3,107,195,81,7,255,3,212,204,199,15,69,189,200,103,38,252,161,233,94,86,36,240,34,87,252,51,113,6,127,60,25,48,16,74,75,167,42,219,33,35,246,243,125,148,1,168,255,240,17,209,70,132,240,227,141,124,153,111,236,25,176,216,191,76,99,168,203,24,186,177,228,202,179,157,159,70,66,40,194,182,69,97,80,254,225,29,33,228,15,248,134,209,231,127,182,95,242,254,173,187,28,22,146,54,245,81,204,44,109,99,72,126,129,141,232,239,141,225,244,57,220,13,221,2,174,210,119,0,122,48,163,71,148,38,223,179,205,47,214,95,5,14,173,142,163,184,155,177,52,148,241,170,96,221,86,10,24,169,156,89,214,208,22,254,209,36,220,163,217,80,178,156,163,106,32,221,231,195,214,249,189,180,150,232,162,215,29,16,172,16,60,231,61,23,109,125,89,238,124,249,201,240,93,164,176,157,254,65,124,144,147,52,16,69,253,169,66,84,174,9,71,144,30,177,179,169,104,155,41,120,40,83,170,216,146,164,89,12,222,3,117,181,64,60,15,238,193,246,102,116,80,252,82,194,243,53,60,163,139,46,85,179,252,221,65,56,182,17,7,207,52,202,244,135,99,182,196,239,124,247,65,111,69,39,86,255,171,211,165,53,33,25,4,34,41,215,69,0,30,216,10,132,24,105,106,44,91,235,52,162,105,84,174,197,219,28,202,17,221,125,131,171,46,47,102,60,172,235,160,19,232,3,182,232,36,145,194,234,159,104,222,13,233,194,172,132,22,1,163,220,7,160,177,168,158,39,236,170,202,4,134,80,187,30,204,255,13,24,198,195,192,75,9,251,147,120,164,255,251,183,142,174,18,99,253,62,149,224,190,241,40,70,178,226,109,54,19,211,140,215,102,2,158,190,109,57,104,46,112,124,7,236,254,133,176,125,253,92,1,4,49,12,60,146,59,117,123,92,227,52,97,164,174,95,83,219,76,16,215,236,146,147,167,161,112,207,99,103,123,139,149,82,193,50,221,165,83,169,89,86,223,28,159,43,175,181,69,115,177,119,124,229,159,102,215,204,94,181,117,3,189,72,241,251,121,130,178,94,26,208,90,23,115,92,146,8,253,184,11,66,222,213,62,167,104,225,195,123,123,100,233,230,110,113,250,45,15,123,221,176,108,37,213,8,66,34,28,199,19,24,240,77,49,214,147,153,21,250,142,123,89,174,165,223,3,197,176,166,172,137,146,78,109,24,181,118,39,187,46,137,206,43,249,170,7,108,3,79,127,76,211,241,177,142,28,194,202,22,120,208,115,6,181,92,53,113,27,250,147,142,95,192,240,68,44,97,221,206,252,134,196,244,119,64,209,35,203,187,6,60,112,168,126,41,139,158,97,22,143,99,105,23,181,242,123,154,177,27,113,162,127,25,226,16,147,171,22,141,90,53,13,248,4,251,185,38,40,223,113,23,243,194,211,164,6,181,230,127,203,227,163,120,119,80,49,31,248,163,157,185,157,51,38,222,129,137,96,209,48,3,10,250,116,13,186,227,112,228,59,35,65,205,2,194,229,105,75,187,67,102,104,30,157,61,218,86,129,101,67,69,19,33,102,230,173,21,178,197,39,221,98,50,69,204,188,38,161,189,8,220,163,127,144,12,5,253,134,198,156,65,124,30,48,107,246,228,199,173,4,95,34,33,238,91,175,102,249,51,234,53,8,123,251,65,191,26,60,135,35,30,94,253,90,13,120,170,108,219,2,63,229,40,141,90,131,92,59,131,207,120,28,72,31,234,180,57,235,253,88,169,49,66,11,206,194,47,35,236,247,131,107,156,212,96,112,140,242,87,58,111,122,64,185,188,202,121,192,113,172,244,204,129,206,19,224,57,25,131,46,182,87,41,205,105,75,189,7,129,230,67,107,155,233,251,113,58,36,102,237,237,111,89,175,96,68,15,83,103,9,25,99,158,6,163,194,204,43,37,196,15,227,175,169,242,141,15,184,184,222,229,134,236,236,209,185,94,60,147,88,91,212,226,145,223,15,178,133,170,251,12,196,189,56,30,149,119,229,72,139,160,2,237,229,67,112,124,111,175,29,70,197,114,216,142,166,157,179,74,26,35,150,163,253,39,129,217,232,72,166,152,175,27,189,40,110,214,14,242,224,164,52,12,86,82,0,175,147,86,231,232,155,100,187,117,205,241,119,133,59,105,167,147,109,137,27,205,9,238,109,121,6,37,130,240,87,132,24,60,58,118,8,165,95,6,40,24,18,128,47,228,117,41,216,30,58,16,71,253,220,58,196,33,173,52,212,238,55,234,5,219,72,60,0,222,39,52,184,64,155,36,40,101,107,135,199,241,12,105,1,167,194,31,207,53,193,4,221,71,67,104,56,114,135,25,8,17,251,196,30,25,202,31,108,140,75,37,15,138,255,175,90,67,28,238,157,138,208,105,234,33,212,50,156,244,3,54,33,34,241,164,232,152,130,141,235,6,223,132,100,41,67,184,62,198,241,26,31,177,17,3,101,13,168,80,208,25,119,92,15,62,246,140,94,48,63,74,222,114,237,43,97,253,204,17,247,41,125,108,61,139,85,197,73,87,132,125,173,148,107,144,32,202,170,61,173,10,62,163,228,172,102,153,34,117,60,107,168,118,188,101,204,219,191,90,24,249,147,237,51,227,114,31,201,239,205,12,199,7,90,55,243,99,98,158,76,153,179,95,71,225,172,186,14,175,65,94,60,198,222,94,188,213,219,213,73,250,121,200,240,186,64,15,114,52,187,151,61,49,128,117,6,187,101,40,80,70,235,133,60,153,209,97,54,241,48,220,144,66,174,50,116,143,223,204,223,111,254,187,49,191,70,117,195,85,123,196,16,36,199,70,113,24,68,156,245,143,176,242,82,223,23,93,53,139,195,107,191,74,47,116,102,212,222,226,190,170,151,5,121,76,92,99,143,146,50,70,102,184,181,124,230,128,89,168,4,192,47,75,154,19,156,122,122,152,13,111,171,90,82,50,173,53,192,87,50,153,106,233,200,222,77,9,131,49,219,148,155,92,18,46,102,131,218,186,126,8,129,47,88,127,188,95,155,7,57,116,228,74,151,189,18,159,64,68,135,243,226,112,253,58,227,214,245,110,5,157,98,18,45,167,223,82,53,93,126,45,160,228,90,98,3,124,238,208,26,137,76,130,209,139,246,62,174,46,45,151,44,53,82,226,151,253,7,177,91,23,73,62,45,17,129,136,229,51,151,205,10,33,128,201,94,117,36,41,152,80,111,76,72,189,62,168,54,180,138,182,113,154,198,155,244,193,48,155,22,116,116,122,134,126,238,162,49,64,249,72,177,255,17,84,119,121,21,247,79,204,250,138,156,251,27,154,209,88,215,155,159,50,96,202,53,38,103,160,212,144,122,227,250,60,69,102,46,122,30,46,114,123,68,207,151,77,166,52,86,173,142,17,76,103,96,9,231,47,159,182,162,97,194,16,47,234,89,241,154,72,140,4,177,120,185,61,22,200,73,39,69,174,87,76,92,132,87,152,229,188,102,222,174,76,124,162,2,222,14,36,132,40,149,29,211,218,117,143,143,201,133,69,121,105,135,178,179,255,232,122,230,109,31,47,148,206,4,239,162,248,248,201,73,237,160,88,36,140,247,49,188,98,235,26,96,103,153,6,37,140,225,125,245,26,17,160,139,228,101,78,165,45,112,57,179,77,151,190,67,204,228,155,195,215,66,140,221,188,80,84,249,39,177,178,64,130,50,184,132,26,139,153,240,234,7,157,55,16,245,185,147,7,69,51,188,148,207,83,66,96,12,57,6,50,195,212,48,181,40,161,117,229,242,207,24,80,159,134,35,44,52,10,175,156,14,144,142,129,95,138,242,11,56,13,178,94,86,233,130,141,168,166,120,129,122,46,106,201,193,164,95,166,94,15,10,206,246,77,75,132,220,8,91,76,160,253,242,147,40,52,255,19,225,51,35,99,17,139,33,207,202,132,16,58,85,181,211,255,45,112,25,148,164,34,248,158,194,13,32,15,135,227,234,20,38,203,129,148,119,72,166,121,240,157,169,180,246,27,16,112,74,62,40,183,129,58,229,161,49,106,43,114,75,94,209,164,169,82,221,106,48,146,151,244,197,174,174,18,94,100,248,199,65,55,66,15,131,178,141,155,104,243,179,78,57,213,246,173,116,160,83,114,74,123,10,194,99,89,64,247,164,175,208,155,211,99,169,27,124,139,64,13,120,144,6,57,45,162,137,103,74,82,94,233,102,194,37,38,118,181,185,41,231,136,141,165,186,142,111,31,215,34,146,125,195,6,67,238,180,233,37,69,120,57,183,252,201,153,241,29,145,198,55,157,66,184,87,138,172,15,177,61,53,79,223,58,41,111,29,166,33,20,157,229,223,33,71,121,68,38,106,142,219,232,61,247,59,214,202,241,42,180,251,230,188,196,88,191,26,55,10,92,140,232,51,128,131,138,38,13,248,94,252,179,36,184,197,195,175,62,204,77,252,198,174,45,209,16,8,65,179,116,176,195,113,56,172,88,101,101,98,85,143,33,30,10,167,134,21,47,161,12,105,254,53,215,74,19,50,78,216,195,190,201,235,25,220,124,107,96,165,49,109,10,244,182,114,247,89,30,236,50,101,222,97,6,55,128,252,233,159,199,13,165,76,48,129,40,46,91,8,73,180,124,88,234,249,107,231,65,92,228,63,115,117,116,72,16,50,103,126,3,205,21,196,140,30,244,45,22,249,213,193,29,134,184,29,15,69,114,232,15,138,92,84,35,247,80,92,30,67,61,168,207,211,43,227,55,24,201,229,102,105,76,215,95,57,12,199,194,215,120,178,175,94,193,214,78,205,58,225,137,120,125,239,171,228,210,151,52,214,75,19,85,1,246,188,235,74,25,249,251,6,81,66,25,63,238,142,145,180,241,125,162,1,70,207,253,10,3,232,145,90,207,113,48,98,1,246,73,45,29,227,185,185,132,59,109,135,117,10,187,160,32,19,192,8,62,86,141,21,140,172,26,147,40,85,111,149,144,127,126,15,31,167,105,135,168,109,236,210,112,157,209,203,123,205,141,181,19,72,236,147,73,117,160,222,188,248,82,31,116,188,66,186,137,141,6,157,96,139,232,130,228,47,153,236,23,11,232,207,207,17,60,102,106,128,121,243,43,22,174,67,57,21,155,99,74,36,182,247,1,68,103,199,114,173,45,77,162,240,76,220,85,132,91,85,100,138,64,28,136,65,197,37,74,234,100,253,172,121,252,116,115,205,44,19,163,28,47,198,118,128,252,6,36,152,29,133,128,230,12,122,9,10,175,246,53,115,55,165,228,155,232,222,79,110,254,74,77,104,4,66,111,189,131,75,209,51,53,250,187,175,42,132,150,73,93,6,46,16,170,115,104,124,31,175,254,141,170,201,19,195,32,149,18,125,129,110,16,186,114,228,136,82,179,31,152,167,198,221,76,35,111,8,178,129,28,203,241,230,0,35,67,196,18,92,219,91,147,206,185,106,150,27,229,178,84,233,124,239,249,62,153,75,34,200,91,110,232,152,28,26,237,166,119,113,120,41,183,118,129,134,75,23,232,132,179,87,26,245,104,66,144,183,206,176,55,93,84,45,4,186,100,160,20,82,131,252,206,214,249,214,214,24,185,21,57,94,69,18,49,54,133,56,108,71,177,243,226,173,182,211,17,85,16,210,4,112,242,80,176,34,24,41,66,67,33,121,173,2,91,112,139,251,201,106,94,49,125,91,15,228,12,225,42,116,110,223,68,198,95,217,165,72,163,247,161,162,146,231,127,113,81,220,135,44,30,96,234,80,242,63,110,11,233,79,103,101,64,65,46,197,243,237,235,58,141,60,226,126,173,189,146,12,59,4,27,176,78,235,174,239,10,31,68,223,84,106,39,215,179,82,185,195,117,98,72,194,104,223,231,185,43,98,150,187,214,213,17,16,27,75,102,207,153,194,198,186,89,242,13,4,174,158,58,71,161,95,232,111,159,238,2,179,62,21,215,24,162,123,84,252,183,13,37,209,147,106,127,147,8,131,167,141,189,91,170,161,82,244,136,62,31,111,215,208,245,209,215,219,96,42,88,225,81,148,233,114,233,242,26,16,8,193,129,230,150,22,218,238,207,68,6,21,117,223,40,115,105,84,70,145,30,217,189,17,188,100,246,56,198,124,176,209,135,159,66,53,125,190,213,107,144,10,197,0,72,137,153,84,229,209,32,120,149,44,246,24,114,39,30,55,220,206,207,36,174,147,1,24,248,222,34,85,181,69,219,136,99,7,229,206,187,134,56,177,195,27,88,110,68,162,170,231,61,39,111,128,178,7,166,215,198,87,102,176,1,254,130,143,204,112,156,143,62,12,16,189,243,71,141,4,22,2,142,180,28,100,19,22,196,44,245,43,73,58,231,58,127,150,48,64,58,99,219,36,91,230,5,3,12,147,95,58,199,49,195,125,95,110,165,88,127,173,11,116,157,222,221,154,167,223,65,89,17,42,255,170,205,114,223,206,57,77,161,194,61,212,53,79,6,180,153,225,23,193,242,161,204,144,63,42,56,233,97,34,140,5,25,129,221,113,178,48,24,103,248,11,223,103,44,26,75,86,9,249,137,6,211,197,222,146,59,195,61,9,181,181,118,110,113,151,140,205,29,86,249,66,204,97,207,160,158,76,8,68,86,226,167,251,16,126,198,128,89,30,221,142,91,79,243,86,113,39,70,102,182,39,139,248,200,139,38,19,204,76,250,180,88,24,147,32,236,228,10,146,132,218,175,152,236,69,46,226,114,101,142,177,187,6,3,90,180,142,173,90,10,147,173,190,137,134,48,129,242,56,54,36,208,148,181,121,198,0,69,9,173,178,162,173,40,27,11,34,88,95,235,163,222,226,225,241,23,87,83,46,188,75,237,93,161,103,124,146,28,8,235,73,100,69,178,23,21,207,209,251,58,123,96,58,55,213,225,43,125,231,123,212,222,24,57,25,24,133,247,31,42,78,125,196,82,62,55,74,74,186,169,224,55,87,194,57,53,13,14,233,77,176,31,117,206,77,252,70,112,252,216,16,211,127,3,193,81,16,236,215,230,192,128,144,94,167,117,47,224,126,134,244,216,158,250,254,8,161,92,145,126,210,193,138,238,188,16,232,21,62,126,1,123,8,36,76,27,237,130,42,24,21,182,167,8,64,98,167,190,161,183,73,134,129,12,86,93,239,192,116,203,101,95,189,218,205,53,202,185,98,224,14,110,88,78,221,108,156,244,44,217,54,38,81,65,244,200,23,246,206,124,38,180,40,150,54,33,119,50,61,76,163,204,131,92,54,249,185,34,249,92,174,43,200,187,151,174,181,100,46,124,50,161,89,158,52,26,103,28,240,222,153,169,70,45,82,69,36,35,169,203,175,3,215,242,211,85,107,226,161,33,146,253,77,66,197,103,252,152,43,77,199,51,161,147,209,2,164,135,88,139,107,71,174,153,249,142,230,172,102,43,208,227,158,245,143,90,252,132,180,29,21,24,99,155,204,186,0,16,122,102,16,180,54,157,170,58,187,89,43,137,242,165,182,186,249,167,236,17,20,195,81,134,58,26,97,161,68,170,192,209,6,104,34,173,14,26,117,171,52,141,240,108,149,171,116,241,205,113,4,87,145,13,66,189,179,135,154,202,206,176,123,136,131,98,238,217,37,139,51,171,219,74,168,136,143,224,66,33,251,6,13,172,179,199,53,123,72,85,146,183,74,230,121,80,143,89,253,111,17,72,150,207,242,61,166,8,229,153,121,124,238,161,232,3,209,128,68,231,72,208,44,165,160,191,63,131,210,205,149,135,157,192,228,195,70,80,209,187,181,157,175,250,140,195,192,124,142,3,30,10,131,67,32,157,11,161,27,110,162,122,150,41,234,151,59,193,229,191,68,172,158,152,101,51,219,240,234,93,113,110,243,122,9,64,201,32,231,119,81,48,174,220,112,185,210,226,130,80,157,85,124,33,66,173,36,7,103,126,212,180,17,24,75,163,90,43,19,130,59,18,103,195,191,243,239,125,149,120,255,144,195,25,32,159,97,80,138,172,103,45,132,215,207,223,182,14,90,15,248,62,62,164,83,121,118,84,36,178,9,149,114,223,220,198,193,207,161,57,226,141,156,239,17,107,37,176,193,214,200,16,251,144,29,138,167,201,174,209,47,188,50,110,191,123,112,223,240,75,45,155,150,182,207,116,184,6,157,16,7,84,40,78,210,56,248,217,189,218,121,121,119,116,9,127,185,130,142,68,244,242,142,236,94,27,125,186,45,100,18,74,21,132,39,158,189,22,165,29,171,127,56,7,97,14,199,237,206,212,145,74,105,45,84,3,118,46,99,147,239,25,24,129,247,113,216,176,84,32,166,62,190,162,54,152,204,14,209,141,128,60,29,179,47,88,101,45,235,20,61,106,152,228,75,93,218,225,184,119,90,61,106,128,103,200,132,27,65,165,155,95,202,203,125,182,200,163,45,32,94,171,151,117,112,2,76,166,108,114,32,237,1,198,145,241,83,101,25,109,103,232,98,122,253,150,46,147,104,89,76,68,84,42,109,160,0,97,53,87,38,136,117,32,6,93,195,54,194,94,88,31,63,149,221,17,171,43,125,196,111,112,109,70,28,163,61,207,31,77,77,177,52,21,244,100,187,40,205,200,136,9,52,87,92,208,77,40,174,57,17,158,108,59,208,120,193,16,207,53,33,2,223,151,115,247,183,112,207,131,84,241,128,143,20,63,167,166,180,142,79,177,133,151,6,37,192,185,77,134,146,38,93,98,120,231,123,240,139,245,51,231,142,174,217,241,237,223,150,154,121,146,233,210,78,143,64,168,131,82,22,253,112,15,14,253,174,79,201,34,131,136,67,138,52,218,182,176,166,187,57,127,12,198,35,156,105,151,52,252,202,224,217,169,117,178,155,204,196,10,226,77,94,155,255,225,239,219,235,249,226,222,9,245,187,117,130,212,205,32,19,62,245,70,125,252,168,15,84,99,23,223,16,127,60,117,101,215,134,212,191,1,137,112,53,31,55,126,167,184,185,219,2,191,86,64,99,198,113,20,177,35,37,174,198,227,90,41,168,159,56,121,206,96,157,147,81,79,125,102,127,197,13,177,81,1,137,186,64,245,63,248,34,217,182,210,33,155,239,112,161,100,134,154,243,159,87,225,111,215,199,47,111,169,3,219,174,91,85,26,89,156,97,241,54,50,42,75,123,65,83,222,118,49,59,140,81,134,78,9,49,211,248,110,85,22,182,163,119,254,210,8,115,205,103,32,96,95,234,250,197,240,39,130,170,115,69,39,164,213,187,32,173,242,210,115,171,118,14,191,98,39,11,28,43,68,54,248,100,244,100,58,228,165,141,140,217,99,36,208,135,109,74,0,133,114,84,108,44,81,114,192,183,180,198,99,117,183,79,49,228,38,117,81,143,84,116,85,21,21,211,86,77,247,67,126,128,47,241,169,250,206,111,38,252,233,185,190,131,116,170,222,104,119,195,134,114,18,119,251,83,11,252,148,228,83,251,250,124,199,89,247,50,122,204,84,226,163,98,121,75,207,49,101,212,18,29,100,20,90,29,90,181,202,79,61,216,64,169,163,246,61,174,202,122,10,237,192,0,158,234,145,21,41,169,230,105,132,46,168,231,201,36,182,244,25,114,57,87,216,53,236,135,35,166,229,234,48,102,208,146,113,77,192,132,160,166,218,179,81,4,92,42,167,159,41,172,100,240,126,30,216,20,98,222,158,129,188,149,185,60,155,121,129,117,210,40,132,205,180,190,96,137,127,172,152,162,111,69,170,222,91,0,165,129,159,26,244,213,138,251,146,79,52,91,194,180,177,157,22,136,47,146,213,178,117,252,54,39,75,72,75,55,11,139,83,113,21,134,75,246,32,107,102,81,68,50,221,84,195,48,76,80,100,27,152,55,25,4,24,147,73,114,235,183,137,33,114,3,125,29,76,70,179,109,91,109,70,239,188,67,53,94,151,231,105,3,148,121,12,61,222,53,180,92,138,104,121,129,238,104,159,184,36,177,114,114,195,236,114,16,150,152,8,120,167,38,146,247,79,204,170,93,158,222,246,214,115,97,162,69,27,233,108,48,232,68,243,85,187,254,34,111,212,246,147,219,128,56,106,83,228,116,104,229,57,171,225,162,10,55,60,165,204,69,193,43,79,43,76,80,245,107,239,143,12,78,242,253,26,38,143,239,13,89,214,63,11,111,79,123,119,232,64,99,178,82,109,97,20,159,89,143,39,129,232,206,145,160,214,189,152,17,120,89,187,211,63,21,40,191,27,61,72,107,253,218,59,129,219,2,106,69,49,89,126,68,120,87,82,168,69,29,141,36,37,42,162,212,112,111,156,26,106,60,4,237,87,85,200,100,153,157,236,141,254,172,184,11,79,18,95,148,15,88,242,52,118,202,162,146,209,232,243,119,68,213,108,163,179,208,77,27,243,56,231,180,23,25,129,84,110,142,194,102,90,254,173,4,182,81,31,159,198,242,21,239,94,80,34,108,254,220,59,65,42,78,135,175,231,78,100,69,232,171,244,41,179,122,136,251,104,27,86,243,202,89,65,89,97,10,20,95,236,135,102,115,92,122,171,227,44,53,58,76,117,205,132,76,88,6,23,30,70,197,82,86,170,113,225,84,0,153,37,109,4,75,195,66,253,57,216,26,188,166,134,121,78,45,139,167,17,240,93,106,163,71,125,111,245,209,113,78,149,249,221,234,142,77,255,195,255,109,135,213,117,58,22,185,216,153,149,168,153,235,226,215,15,77,131,229,12,18,166,3,187,62,1,248,207,254,195,17,252,130,170,24,254,231,16,52,20,232,92,83,195,167,0,4,219,7,253,228,113,56,199,178,48,175,120,7,10,129,141,2,5,97,245,66,111,169,158,139,251,202,169,92,62,90,8,111,87,242,107,97,223,180,139,206,34,26,50,236,148,17,49,115,21,84,85,207,39,47,69,1,56,103,119,251,77,166,222,213,8,55,112,161,180,113,166,36,28,136,121,251,149,176,203,126,40,166,230,232,41,243,231,12,169,181,76,69,162,88,214,252,9,68,85,224,137,44,248,18,185,51,182,65,58,85,67,61,215,121,215,0,4,242,120,181,62,35,250,157,115,59,193,27,90,182,88,32,17,36,19,74,99,174,110,205,136,166,12,53,150,8,182,239,249,207,110,234,159,190,245,251,54,129,191,198,165,141,62,6,55,245,7,217,248,47,109,119,93,213,55,152,255,53,195,209,203,185,178,177,114,105,0,217,246,80,148,4,52,88,88,164,245,253,111,115,75,60,52,70,240,126,83,95,221,52,164,216,7,130,103,10,245,219,134,197,232,65,151,145,252,130,213,16,145,106,255,199,241,189,98,245,212,114,89,3,199,248,115,118,151,3,21,45,28,223,74,94,135,107,60,186,201,125,249,70,180,187,23,191,86,94,89,146,229,145,130,131,6,76,2,110,130,54,164,218,198,210,112,102,178,82,104,25,241,107,111,1,100,154,107,95,59,148,217,142,53,51,158,28,42,79,106,220,154,175,43,209,186,138,191,177,89,176,178,231,111,214,253,169,208,0,243,46,11,204,208,149,18,100,231,20,92,108,122,68,255,198,37,86,166,72,217,73,193,159,167,119,209,75,21,117,13,204,152,189,199,124,75,84,245,121,142,167,32,107,45,234,175,239,43,8,1,133,148,247,79,27,99,117,47,16,175,107,42,231,182,23,200,241,3,222,130,204,102,125,135,113,113,130,121,142,238,135,229,101,140,148,66,63,206,60,190,70,74,179,115,144,45,252,28,201,118,137,20,171,100,195,179,104,144,36,101,0,71,157,203,245,131,176,106,237,124,232,158,13,5,57,143,98,250,0,168,171,13,147,108,18,217,136,51,147,217,46,223,58,221,205,8,221,255,16,248,213,235,245,133,152,0,77,10,232,32,141,3,137,137,225,87,148,29,99,144,118,124,205,111,173,158,222,21,54,16,19,166,149,79,0,191,181,192,92,73,12,2,255,190,107,255,81,118,58,46,23,17,138,66,238,68,229,86,147,128,72,252,212,126,163,47,5,132,103,220,17,11,84,29,40,205,177,28,235,213,162,111,157,226,190,130,4,148,142,254,112,239,171,227,255,159,73,47,82,165,179,31,55,238,126,84,168,200,168,113,222,198,64,120,185,250,25,235,207,251,139,125,139,234,209,13,178,50,98,155,49,79,17,249,123,128,159,18,160,99,63,185,151,186,29,138,155,230,17,16,110,144,76,76,165,147,53,49,208,20,114,211,245,254,47,110,79,161,23,233,92,108,118,2,90,67,101,236,81,245,145,58,38,126,207,254,175,19,156,28,143,65,218,218,217,35,220,36,196,34,231,143,107,221,125,56,217,204,252,217,100,65,205,193,112,42,245,19,64,55,27,202,193,11,41,78,103,30,127,185,15,212,140,112,44,250,225,206,17,106,74,181,255,170,205,123,187,15,208,164,156,104,208,228,83,117,158,155,24,120,109,85,107,103,18,116,117,172,175,243,216,186,20,28,52,237,203,208,39,84,178,235,181,95,132,165,116,157,255,6,217,20,176,72,31,110,192,218,151,48,248,148,145,132,100,180,165,229,22,160,20,195,183,179,2,0,126,189,228,39,84,161,108,76,79,118,240,235,113,90,146,101,220,14,231,188,199,141,47,235,95,107,177,212,71,23,46,48,49,156,154,171,24,205,248,252,253,90,168,128,34,245,213,248,128,28,73,234,255,222,153,212,228,238,93,50,64,118,179,238,157,177,122,37,201,107,211,209,97,217,67,155,96,62,25,64,11,224,146,107,182,8,55,196,123,210,56,236,162,169,185,0,144,70,15,199,211,110,139,40,144,52,63,117,251,74,29,74,86,33,124,133,166,247,0,101,193,32,185,212,239,92,164,217,117,127,232,107,93,223,150,249,254,66,117,211,146,234,52,127,231,235,121,94,65,38,21,57,218,71,75,51,189,225,92,133,124,176,86,3,208,179,83,117,118,227,117,115,252,142,67,217,197,8,129,184,46,211,186,29,42,89,8,95,21,242,228,32,170,58,197,87,243,37,212,235,237,63,7,160,97,155,32,75,248,176,56,19,154,233,14,43,142,99,39,137,24,235,247,22,54,153,167,167,211,34,205,202,151,249,29,168,167,186,110,224,113,76,126,166,207,146,43,253,4,6,52,162,67,185,250,201,59,106,107,148,57,52,124,113,78,22,81,83,104,163,67,46,178,114,79,233,2,148,194,9,214,163,106,175,237,57,249,48,203,35,24,43,153,234,191,18,115,25,104,26,192,254,199,153,70,80,213,23,4,214,148,187,187,102,124,157,229,33,45,226,238,129,154,211,144,203,242,92,209,7,118,22,108,126,0,217,231,105,212,81,23,210,46,165,18,147,166,114,193,236,125,160,78,248,21,231,48,163,74,47,160,145,13,61,26,46,85,11,156,48,233,209,66,42,187,245,129,174,197,72,142,81,202,34,157,149,237,109,182,147,157,222,147,90,54,24,255,148,183,31,241,117,82,219,240,167,153,92,210,83,114,177,122,142,78,200,122,194,51,239,196,39,113,235,235,97,199,100,9,72,137,193,6,146,177,200,65,115,160,232,155,238,151,149,172,90,227,193,191,190,118,104,57,92,21,77,21,238,178,24,74,110,35,236,251,94,74,163,161,97,243,213,193,30,220,245,38,251,56,90,80,37,0,94,0,122,26,213,200,50,234,18,143,60,139,246,243,105,162,129,98,45,125,223,178,185,216,185,63,60,9,63,126,64,151,3,22,3,52,30,128,159,7,154,110,9,245,159,50,11,35,121,201,233,148,244,82,88,110,66,52,210,96,5,96,146,196,255,5,7,94,81,168,229,110,30,251,105,105,54,77,165,163,80,158,237,71,129,123,225,194,157,58,211,200,172,145,27,153,135,211,105,204,204,181,185,98,236,248,16,83,235,206,36,83,38,149,140,248,234,248,84,200,132,18,217,76,83,98,120,170,187,88,133,140,167,134,31,45,169,14,95,82,30,57,130,22,141,243,56,97,231,192,11,161,228,188,99,162,19,142,152,36,208,73,81,1,209,122,246,250,213,116,49,0,137,106,170,208,186,83,127,168,117,23,186,6,84,134,78,177,160,154,132,216,159,245,215,45,149,135,45,103,188,233,226,187,225,191,225,216,255,213,178,173,95,201,7,136,64,247,174,179,198,185,48,178,175,64,212,157,165,30,0,221,42,8,249,95,141,8,35,236,177,56,6,170,152,170,129,218,144,77,125,42,178,156,34,33,95,75,49,12,159,132,232,167,33,239,241,113,117,72,222,149,63,81,245,21,76,43,254,238,45,141,150,46,190,135,205,85,32,67,202,42,242,169,67,232,90,155,224,212,16,154,34,194,226,231,119,33,170,3,54,41,253,163,50,10,211,90,11,29,218,104,5,122,93,151,46,161,68,128,94,87,47,7,63,249,220,49,107,242,23,42,38,29,60,90,76,168,32,62,12,235,14,174,237,71,179,142,220,79,10,61,184,23,159,191,229,113,102,123,51,40,12,8,210,71,236,131,96,117,97,146,175,238,151,142,177,193,5,120,91,55,52,244,137,14,129,21,1,212,64,255,194,161,199,163,218,167,32,89,198,142,91,20,171,78,33,215,41,153,225,154,140,226,73,108,15,97,9,110,29,227,120,19,42,41,22,249,43,189,235,71,195,223,160,2,2,241,51,210,237,137,137,63,237,56,233,79,151,224,83,77,109,245,73,251,238,211,221,185,211,137,139,236,84,142,250,232,41,119,254,253,49,191,58,253,213,60,227,127,53,46,182,86,200,253,144,135,58,71,132,64,231,87,137,2,68,143,112,119,197,234,17,191,34,234,202,195,168,85,90,216,1,169,42,74,154,32,173,237,141,40,107,249,81,47,84,172,151,179,81,32,207,52,224,54,163,106,231,233,196,205,130,92,137,210,95,17,157,79,135,62,70,8,189,109,130,90,178,44,239,187,135,114,64,115,223,97,110,13,193,80,240,152,39,4,109,89,213,29,179,178,28,252,22,246,203,245,208,135,213,9,67,202,28,91,65,203,69,236,125,135,39,90,142,239,253,152,68,162,249,166,51,76,29,143,221,250,233,48,199,188,202,133,93,24,16,14,109,182,106,197,249,40,119,171,25,130,231,144,212,63,184,246,48,190,243,53,109,188,121,56,150,145,39,197,108,235,230,130,70,118,234,137,69,92,74,113,199,248,229,46,11,106,31,78,247,61,93,119,164,239,135,131,41,81,149,250,3,212,236,196,214,101,194,89,226,109,199,160,60,210,36,12,123,112,22,143,212,75,78,145,199,139,227,164,127,245,102,226,204,84,20,84,108,15,57,139,230,56,126,10,147,231,95,211,208,47,57,196,67,223,251,166,93,163,121,213,147,156,137,73,41,137,40,191,193,97,225,15,21,72,55,15,112,252,156,100,120,32,9,18,76,208,206,83,132,238,184,31,208,101,16,94,214,7,34,228,80,188,48,104,238,54,121,69,246,123,6,74,127,89,174,63,71,113,61,94,24,183,32,46,147,82,6,85,128,9,163,220,70,9,178,13,182,129,211,151,156,146,198,32,128,61,245,53,231,160,255,33,20,190,73,93,210,142,107,25,244,4,121,208,160,86,47,52,74,194,125,92,188,3,188,15,187,60,241,221,165,129,66,40,143,124,205,252,50,228,145,42,64,0,42,26,165,192,228,140,26,135,49,43,31,189,95,108,61,204,123,51,36,157,181,4,12,51,75,123,10,143,119,171,131,30,169,147,198,14,10,241,66,249,3,118,115,214,83,149,125,105,198,185,97,140,135,64,164,208,108,132,21,190,212,29,81,97,127,205,224,114,210,38,99,90,168,46,204,253,213,242,85,141,64,149,183,221,8,109,77,7,107,206,67,229,61,28,108,58,103,114,73,225,222,133,89,187,193,29,188,149,207,184,27,75,184,229,218,14,171,19,115,219,135,104,127,250,156,34,78,30,111,211,129,120,160,37,205,66,34,115,56,239,54,144,241,221,52,72,27,78,183,109,7,123,8,27,5,137,164,207,16,190,142,210,181,62,223,41,231,253,179,104,61,69,74,71,155,146,96,173,187,126,195,237,22,3,106,169,123,78,162,131,121,90,208,90,223,182,33,250,156,66,33,68,150,135,124,203,192,174,63,225,3,186,179,40,89,233,16,164,42,1,40,5,136,159,81,136,206,43,203,90,102,107,108,15,137,169,185,139,173,101,227,114,10,6,238,34,239,115,121,228,116,22,147,47,26,88,202,89,207,52,82,173,67,114,129,45,47,248,123,205,162,15,48,68,15,132,231,39,67,56,199,72,164,201,66,69,135,14,146,124,41,85,118,205,16,103,166,146,27,19,231,78,27,43,228,126,30,59,158,54,237,202,69,157,89,202,115,46,11,114,143,219,36,243,87,19,51,104,70,61,167,34,4,25,136,146,135,233,195,13,206,63,160,142,121,72,80,44,51,2,243,168,60,57,96,20,11,173,150,26,175,39,174,155,47,72,237,115,49,188,207,213,198,34,78,138,44,147,17,247,14,95,219,94,228,238,207,9,251,47,230,224,121,226,25,54,159,9,199,98,255,3,131,21,89,156,206,206,219,182,243,75,83,189,77,87,174,119,206,169,30,45,94,181,49,129,126,183,210,52,120,103,137,117,135,128,93,197,81,105,3,58,246,74,11,77,82,11,121,68,164,35,56,87,24,214,91,169,151,218,230,253,109,25,101,235,12,196,10,171,71,132,72,97,19,141,43,199,102,254,140,2,252,35,87,37,134,140,126,126,34,164,102,3,88,153,169,207,206,221,182,88,129,18,192,246,5,97,39,121,5,93,57,22,147,215,218,111,190,233,82,5,37,30,120,219,85,68,221,208,175,190,126,27,50,110,82,181,155,100,89,21,6,227,28,74,173,65,124,168,24,14,241,44,249,194,22,171,237,34,187,62,145,213,218,217,108,0,49,10,232,243,202,108,160,44,102,103,154,203,25,237,218,180,41,47,208,215,169,95,94,104,176,31,85,173,238,30,137,234,23,220,225,147,108,152,199,240,226,132,28,182,169,147,11,10,201,149,195,46,72,21,175,60,255,224,244,155,120,238,147,30,108,58,198,1,4,35,162,113,250,237,211,106,63,243,185,237,85,153,154,98,190,207,97,167,115,141,122,26,245,23,156,148,65,188,188,249,176,112,99,199,141,139,251,147,238,210,239,235,125,222,35,118,210,50,196,89,201,244,0,143,190,86,120,227,132,84,162,131,235,33,176,49,23,154,117,165,151,78,74,206,114,77,123,241,34,234,53,121,43,87,219,198,216,144,111,144,224,113,141,250,191,136,228,251,163,107,193,181,89,160,120,204,73,101,5,198,109,25,71,224,152,164,160,112,107,40,161,68,194,139,238,143,84,105,167,85,12,40,133,236,85,233,153,223,14,43,60,199,241,168,147,53,18,130,14,186,83,90,165,201,139,22,70,12,83,38,20,109,128,234,105,77,86,4,101,71,186,159,18,85,224,52,51,78,197,37,134,8,46,227,216,114,229,42,27,238,170,128,43,16,13,178,228,228,64,64,63,215,64,242,251,251,42,153,240,151,63,67,88,202,99,34,177,168,3,183,250,63,114,251,243,29,228,129,177,43,74,74,182,77,147,121,53,146,220,37,207,16,68,181,239,197,91,116,86,226,175,105,228,4,193,55,87,156,252,126,197,76,176,54,199,62,65,91,127,215,243,27,170,112,117,24,134,40,230,46,246,89,141,32,38,23,166,122,26,163,70,116,48,29,57,115,92,77,12,240,138,72,32,98,49,61,69,198,144,111,130,30,155,0,12,155,236,33,157,124,171,144,59,127,193,51,87,226,241,251,90,88,58,170,60,186,237,96,228,162,166,18,149,9,206,139,108,73,128,181,3,57,99,16,194,112,152,229,136,14,7,233,185,59,245,213,191,129,124,211,80,188,118,98,144,162,227,106,14,203,144,140,99,28,155,188,165,211,79,69,116,0,101,186,19,112,40,49,39,108,230,36,127,9,132,175,7,227,89,121,187,135,11,171,137,81,170,7,142,59,121,161,178,49,46,144,34,88,85,246,53,176,189,53,254,141,130,181,251,209,134,5,32,152,167,144,178,105,219,70,6,167,47,52,194,5,189,56,239,191,173,18,36,152,126,160,128,173,154,40,120,133,14,190,1,212,205,119,168,112,118,239,158,55,98,87,147,2,36,153,84,3,104,56,109,193,72,195,45,18,82,247,189,127,93,228,6,169,242,215,68,251,27,114,19,255,48,61,45,6,224,225,162,33,28,210,204,131,177,43,78,233,18,201,35,121,209,73,179,206,32,232,241,92,250,193,174,255,14,108,127,222,227,213,58,83,22,124,239,39,56,199,97,146,52,222,159,38,30,43,77,4,160,253,202,77,231,186,203,180,56,39,152,215,251,146,237,255,26,147,143,42,161,107,21,195,131,21,244,80,148,34,35,106,41,134,30,61,237,187,197,120,140,236,148,116,67,45,3,100,72,95,236,61,193,4,59,15,34,49,205,51,120,76,3,189,8,118,120,4,54,105,181,138,36,85,235,151,121,104,14,241,239,145,132,85,168,92,53,96,90,56,179,126,156,85,235,180,172,1,99,137,168,125,2,229,153,42,244,108,114,246,24,161,214,45,41,35,192,74,219,236,184,212,231,137,121,167,199,192,96,238,55,106,231,153,84,251,0,237,160,85,129,24,65,12,146,137,137,41,199,48,212,168,169,183,122,105,86,63,80,174,149,76,54,149,175,90,137,7,8,166,90,43,150,77,161,214,219,165,15,53,218,222,29,113,18,242,232,0,107,91,11,145,63,113,115,179,80,178,12,228,243,12,194,255,204,194,213,7,42,56,27,238,136,79,73,60,229,230,3,94,136,186,38,235,220,192,47,75,172,195,14,222,136,117,5,229,162,240,239,192,75,28,189,199,8,75,193,191,137,151,233,61,145,50,33,159,30,60,202,254,204,73,55,28,148,5,172,51,184,34,79,251,77,113,88,85,143,25,238,189,50,243,117,155,223,214,215,193,225,5,31,250,176,107,147,70,174,138,138,142,119,33,229,226,150,219,42,178,53,182,151,148,184,244,106,29,177,205,114,103,8,61,213,152,249,146,19,125,174,119,250,67,213,228,60,234,155,177,67,225,240,109,177,2,96,157,129,26,235,62,47,68,3,129,89,180,175,177,115,126,33,67,64,251,46,35,110,122,177,195,81,30,147,36,235,13,113,217,137,154,177,172,136,29,90,16,229,140,91,230,248,82,63,96,76,176,210,125,29,121,165,127,60,58,175,204,217,10,115,96,149,99,185,9,232,233,218,169,54,57,27,243,192,42,206,106,106,218,233,200,53,93,225,145,70,63,134,33,158,69,121,183,20,125,13,14,220,56,30,169,62,202,84,222,233,147,240,138,151,0,40,46,195,51,163,45,36,148,165,108,200,221,118,39,157,62,136,19,21,117,219,190,71,219,93,220,58,10,190,211,204,29,168,43,247,161,19,228,225,51,131,233,194,221,253,189,126,105,32,159,166,118,158,174,18,152,136,205,237,182,57,15,52,147,8,253,206,120,175,148,140,107,67,91,67,32,246,221,12,112,6,191,157,79,184,18,33,101,151,155,160,73,11,43,67,2,231,181,125,67,107,249,0,249,162,220,180,204,236,197,59,73,112,126,242,181,213,65,82,89,61,93,51,11,80,173,162,205,49,235,158,89,124,153,120,234,8,26,60,58,166,240,195,16,44,254,182,145,95,51,187,127,181,145,175,5,42,59,135,67,254,193,248,118,123,63,124,101,216,66,34,208,56,180,83,147,0,115,87,71,43,217,120,172,73,88,106,34,69,235,239,185,207,42,148,155,25,127,18,96,196,25,96,236,40,142,233,102,134,161,144,180,84,217,16,202,8,177,218,158,13,234,208,156,222,196,28,22,15,170,104,236,233,206,134,17,82,142,106,32,231,52,161,76,49,12,102,215,125,66,138,239,170,172,75,185,86,201,213,51,219,106,133,26,87,104,172,22,17,61,32,90,42,31,218,242,9,168,246,67,196,243,59,200,113,140,1,5,210,119,185,193,166,235,35,192,109,26,128,153,182,202,109,57,64,109,238,68,63,13,33,239,16,43,173,172,194,22,122,141,216,187,122,101,117,221,202,66,49,36,202,50,171,229,176,202,153,73,175,197,146,16,104,144,82,50,39,19,186,32,110,126,204,183,129,91,209,192,101,113,43,7,66,70,248,6,91,176,63,94,48,115,31,147,5,94,84,4,8,109,88,160,99,168,7,125,56,208,58,114,77,247,220,156,9,34,74,150,49,199,15,3,62,196,109,73,162,114,80,83,215,124,86,140,141,96,222,141,242,25,35,204,35,3,96,65,27,107,12,64,131,182,45,146,154,182,197,207,107,232,161,33,118,192,159,55,148,226,219,104,202,248,254,218,230,225,140,71,247,106,182,243,16,236,24,194,87,234,191,176,140,167,53,36,188,92,149,12,68,97,0,236,34,182,76,96,249,101,52,165,125,90,169,70,202,221,0,18,204,207,172,205,231,76,122,36,255,89,63,225,251,156,208,215,108,217,124,13,225,122,45,234,117,97,80,24,14,104,154,90,135,175,75,77,139,33,21,24,162,196,102,184,65,29,203,233,15,232,71,172,171,129,19,134,88,214,49,3,245,96,25,167,69,50,55,202,65,42,199,27,215,150,198,84,97,215,139,34,253,214,238,90,204,186,172,135,140,240,102,118,68,45,36,210,174,81,24,87,49,97,224,223,40,75,212,102,210,16,233,110,204,186,181,34,101,223,144,233,134,84,246,135,249,151,71,125,218,217,207,184,207,69,159,35,236,135,27,239,81,252,177,90,151,208,20,201,246,199,151,14,192,210,37,27,223,52,115,106,249,70,117,246,149,66,246,94,33,93,0,9,167,7,226,136,201,216,74,252,193,41,86,166,231,168,103,200,251,142,211,255,134,142,63,219,5,227,189,89,1,46,61,230,208,95,40,12,119,34,234,75,244,39,237,17,16,143,237,55,231,228,222,135,20,207,198,203,202,14,188,53,133,47,51,224,130,1,50,225,50,32,243,129,7,237,241,51,248,134,128,67,61,78,115,97,229,104,149,117,238,138,14,131,199,13,166,7,83,69,233,249,225,168,138,80,118,218,243,190,247,138,22,228,190,185,103,216,126,140,167,218,96,207,211,229,34,247,236,66,53,175,35,10,216,159,182,231,210,158,185,61,254,81,87,116,136,212,76,94,213,215,42,65,40,13,33,215,75,179,166,180,196,206,252,43,228,158,66,51,65,111,114,119,210,81,135,169,102,128,242,65,183,30,203,19,112,23,157,147,170,33,142,197,116,174,215,160,203,253,62,235,69,237,250,155,67,93,179,66,106,148,220,161,255,84,159,113,67,108,98,128,98,221,188,75,120,244,209,191,13,177,89,34,69,41,184,67,10,182,223,87,194,56,35,131,76,66,242,23,244,129,131,251,75,42,71,96,24,7,219,205,106,7,155,140,127,41,22,172,12,216,169,179,80,215,157,226,82,35,215,133,109,124,169,196,115,40,1,90,4,130,34,30,53,20,142,250,27,37,81,188,170,238,40,81,101,77,156,146,238,237,122,159,19,12,131,35,215,73,12,76,20,89,138,183,236,113,220,184,100,127,44,106,242,39,73,131,154,21,180,86,68,95,74,31,16,227,125,211,123,8,127,186,115,119,225,78,227,87,7,146,180,57,85,182,90,20,230,149,137,167,192,238,100,100,118,197,128,153,5,237,209,113,50,111,172,184,213,218,1,5,236,80,148,214,190,171,20,155,163,88,230,74,183,18,48,31,211,165,205,96,84,45,92,90,134,149,186,143,35,41,127,54,137,47,20,187,111,109,2,131,147,233,50,147,238,105,143,120,254,55,225,100,44,10,250,185,99,97,26,223,197,119,58,141,186,221,192,72,191,15,4,101,92,240,144,178,138,110,64,163,133,142,12,15,181,140,102,28,159,209,97,95,4,190,183,229,111,99,68,31,243,211,252,40,110,79,120,237,139,162,209,247,76,162,31,229,204,121,67,11,199,207,152,10,231,247,214,18,59,245,75,242,233,138,148,56,149,120,7,3,31,148,242,63,160,213,162,23,71,236,206,193,4,76,155,120,114,64,70,85,125,71,224,94,234,172,242,46,14,171,194,37,67,138,90,206,236,204,144,221,111,82,182,61,41,12,252,209,252,96,7,130,26,203,215,10,149,148,188,37,99,76,107,253,197,0,144,45,199,122,74,151,121,36,100,3,60,96,116,208,186,179,80,52,43,151,168,43,111,1,66,75,225,8,231,119,182,146,1,143,82,83,207,215,179,11,117,125,117,176,190,108,251,52,238,53,6,61,10,184,8,232,246,178,72,50,237,202,245,197,125,37,218,52,54,15,59,121,68,80,234,153,3,213,37,18,92,200,80,42,211,160,2,199,14,8,157,52,70,232,41,229,132,177,140,184,42,49,250,165,84,214,109,14,170,93,24,229,199,182,176,139,84,67,199,253,150,7,142,96,122,191,22,102,167,247,66,67,75,183,183,55,205,227,104,3,122,66,145,13,244,110,111,131,155,218,254,196,124,129,68,221,75,162,99,241,234,58,46,238,42,27,57,115,185,22,126,217,170,123,28,163,159,38,14,227,107,10,195,111,21,131,55,45,13,79,226,71,176,255,92,15,187,123,18,173,58,206,110,33,88,23,245,247,232,71,21,107,76,129,183,6,19,201,42,204,80,136,94,115,101,52,66,19,240,151,153,220,152,212,144,47,34,187,251,70,147,31,175,49,138,249,55,129,21,166,17,17,220,3,152,202,86,55,157,56,210,52,102,240,89,141,150,248,5,145,135,196,63,73,98,235,58,232,34,27,136,232,33,174,223,86,189,112,83,207,254,105,185,73,51,188,195,245,145,63,55,82,106,80,227,145,10,63,222,44,138,152,39,167,134,72,99,92,243,89,190,37,136,201,246,156,63,125,131,140,12,113,81,190,192,174,151,246,153,50,225,89,199,131,118,22,4,51,122,153,165,234,77,88,55,155,221,78,112,1,186,251,64,196,14,132,134,110,5,203,140,6,107,104,107,65,247,62,176,151,214,42,168,192,194,107,143,139,163,177,0,146,197,235,159,172,91,228,46,191,130,231,161,250,179,112,219,53,244,120,180,69,198,174,215,9,136,62,157,112,247,14,61,127,212,162,185,182,170,105,207,121,110,152,50,234,85,145,240,167,179,13,124,125,141,223,96,102,45,181,81,161,43,158,92,227,13,45,204,219,190,204,244,47,227,79,206,202,131,210,152,9,146,229,156,1,1,58,147,41,181,96,58,134,83,200,90,30,21,184,175,199,189,44,18,2,208,195,239,232,165,201,34,82,217,58,73,214,36,91,23,146,18,81,164,175,27,41,61,3,5,76,202,245,38,127,166,126,215,248,120,129,45,119,35,108,93,226,248,26,196,71,87,130,109,124,156,31,146,26,182,26,58,39,206,63,255,135,225,60,25,62,56,150,210,248,157,39,167,239,255,154,23,143,114,26,139,125,137,180,241,174,9,242,105,25,212,56,233,65,156,134,252,43,229,151,146,21,176,193,221,187,96,214,79,61,117,54,253,133,132,70,24,96,172,153,105,250,67,232,182,31,64,43,4,199,163,138,191,163,75,73,77,97,52,196,22,14,104,206,33,162,29,12,114,152,134,63,254,34,99,84,155,197,88,175,130,76,193,31,160,176,94,156,212,29,174,100,175,146,218,219,177,160,115,34,24,34,211,159,110,161,62,247,60,143,188,253,12,205,87,18,45,107,47,117,47,57,18,100,7,158,90,92,17,183,172,63,223,240,151,65,82,169,156,28,112,11,108,82,216,66,125,185,41,120,214,208,214,92,83,61,66,29,74,31,142,232,234,202,25,136,168,197,19,17,244,76,168,44,177,104,124,137,254,167,157,28,51,117,208,248,229,231,55,208,221,152,125,74,15,231,173,11,0,94,175,56,112,158,93,107,37,175,3,59,158,83,146,214,31,149,107,19,68,205,197,197,104,215,158,174,244,76,242,235,79,240,180,139,209,232,190,246,247,203,82,190,142,192,237,70,154,54,28,44,151,240,147,242,211,29,140,135,158,222,231,35,251,175,114,150,167,98,131,92,212,148,22,64,92,153,112,6,96,10,60,91,3,208,85,114,163,90,34,131,11,67,32,133,86,47,20,118,79,21,165,244,15,34,194,174,205,120,162,57,22,126,135,61,181,161,53,4,49,92,221,219,136,2,98,43,140,108,132,9,112,108,218,78,145,33,155,39,161,6,142,112,55,72,238,94,90,223,140,89,225,128,128,101,14,151,152,139,220,145,69,95,196,230,167,166,242,255,114,117,253,249,48,99,194,213,68,193,172,204,97,154,48,188,160,254,152,255,138,103,47,105,123,142,94,114,43,142,14,32,163,188,100,29,65,142,198,140,185,68,215,58,176,204,217,186,156,36,156,66,198,124,172,148,210,145,57,110,76,43,38,53,41,51,242,73,37,191,77,115,74,239,203,32,135,142,245,30,51,175,140,59,181,143,29,166,29,157,93,150,53,236,145,155,52,121,183,67,4,232,14,43,116,187,104,34,156,131,42,36,138,144,19,132,239,127,136,218,95,221,39,244,100,174,226,70,204,128,53,159,166,151,195,14,49,211,110,177,71,119,232,34,198,42,121,6,85,48,2,2,114,173,0,61,126,219,104,82,114,233,101,164,100,126,32,97,108,223,165,147,80,87,14,24,31,30,26,157,221,43,54,193,222,190,0,41,73,153,26,202,175,117,60,65,139,185,140,201,6,24,88,198,168,66,126,34,131,19,236,215,80,77,239,233,17,148,80,109,131,168,59,209,77,217,12,61,185,253,147,226,51,242,140,20,112,128,229,202,138,209,91,41,73,188,64,94,136,223,248,13,174,147,40,128,21,112,96,77,64,173,3,176,190,40,130,104,36,3,33,108,140,207,162,248,171,113,119,198,218,62,79,219,110,64,193,62,63,61,161,108,197,173,96,143,23,65,68,69,124,109,59,239,195,50,134,75,200,139,199,116,254,194,10,155,178,6,189,187,168,174,192,122,223,19,11,232,232,184,139,7,20,249,249,39,101,213,11,0,116,55,200,242,139,35,253,54,25,51,58,9,224,240,193,47,92,212,12,63,174,104,183,219,15,155,241,178,187,150,189,158,143,119,3,126,149,215,167,3,113,188,24,5,151,59,189,99,210,233,128,53,94,135,201,144,65,222,160,27,115,250,75,168,124,201,223,145,8,229,181,234,8,94,163,73,191,138,174,1,116,116,238,183,179,55,68,244,178,188,134,191,46,158,155,248,2,207,65,91,128,218,163,108,169,55,229,231,10,189,111,255,55,167,143,62,234,95,17,252,82,76,72,190,233,248,33,128,105,19,122,29,164,86,177,8,128,225,130,45,69,91,159,46,6,85,253,141,240,6,138,58,56,42,86,33,194,66,161,237,124,99,165,78,22,94,159,147,241,91,197,157,234,113,161,223,166,59,100,106,249,157,124,79,235,253,167,60,208,114,196,253,164,44,203,14,197,91,9,117,39,85,153,183,97,59,21,69,182,161,239,104,230,36,119,34,34,174,120,77,223,73,240,169,123,88,49,214,33,201,146,16,221,33,223,107,1,63,215,14,72,220,112,81,40,73,42,63,118,188,67,104,191,112,5,172,236,87,221,172,60,209,213,157,202,128,222,75,3,233,142,119,14,101,133,48,56,66,5,59,160,193,107,163,95,97,192,171,153,125,197,79,99,131,203,219,254,169,132,247,137,202,212,228,37,237,48,79,229,50,246,194,39,1,102,237,9,6,26,82,22,35,21,23,204,9,58,22,177,180,66,4,183,234,130,236,36,240,220,34,84,118,246,169,229,87,60,16,32,7,220,43,179,167,16,9,220,188,221,74,143,71,136,160,33,227,158,202,139,83,201,180,69,221,34,7,172,104,93,53,44,130,80,43,78,253,9,28,199,0,61,133,201,243,123,162,87,65,74,183,217,143,162,176,145,190,30,99,31,233,176,246,128,157,222,223,53,208,89,206,36,152,227,197,253,42,246,78,100,11,193,205,22,230,53,104,78,147,129,170,166,133,6,226,33,108,53,255,178,49,40,35,224,67,165,52,182,58,2,123,254,95,142,106,39,214,60,171,255,57,223,176,203,204,121,225,90,90,242,104,121,31,27,78,52,168,219,65,77,119,136,76,164,247,166,208,182,20,208,113,91,15,212,158,3,102,224,73,145,30,37,215,133,119,169,250,56,94,167,101,190,25,46,119,130,178,208,44,19,169,73,142,23,72,227,41,179,15,16,142,177,54,171,168,147,71,60,85,167,134,116,12,255,105,234,181,135,49,22,234,203,7,167,60,145,63,50,40,177,123,215,184,184,174,54,122,173,227,183,111,249,82,103,215,31,66,39,183,223,96,141,135,189,126,19,77,196,182,101,163,135,109,83,122,127,221,40,21,242,82,106,2,237,149,88,77,117,229,35,99,53,151,104,181,230,174,32,74,18,42,100,206,15,199,220,35,255,93,145,215,128,189,254,225,68,177,253,196,172,63,172,23,167,170,4,204,202,82,55,84,104,0,44,79,176,51,117,96,184,131,116,108,255,248,70,161,145,116,54,10,193,194,101,15,253,184,8,59,15,118,254,44,195,134,153,203,10,120,87,229,175,90,161,103,180,77,217,131,221,31,60,233,47,161,46,255,108,50,123,44,26,179,87,167,35,179,12,75,134,139,249,227,131,25,189,115,152,239,209,223,162,216,0,104,125,67,101,18,185,193,115,190,36,17,179,0,122,230,121,206,254,61,120,199,250,151,168,6,207,201,212,126,190,29,138,15,155,189,50,19,158,192,133,95,87,205,169,31,88,63,202,97,174,133,11,70,160,252,252,118,26,51,81,101,21,175,176,28,58,153,68,175,36,106,91,167,134,92,195,204,13,192,181,173,107,169,166,118,105,237,91,255,184,61,206,196,76,78,36,8,211,19,165,54,94,10,82,4,17,170,205,10,182,100,21,108,136,216,77,36,68,119,187,56,113,20,0,58,108,165,37,127,171,234,56,187,198,76,195,186,222,65,56,214,226,113,218,50,106,251,155,148,43,137,196,70,212,139,148,1,8,243,230,149,216,130,4,18,168,205,188,82,22,187,161,241,116,184,114,72,66,115,153,176,22,4,171,47,145,30,97,169,93,124,213,97,123,155,120,146,179,72,255,212,10,123,79,251,141,44,252,241,80,81,212,77,153,6,94,216,136,120,61,229,245,44,105,16,99,93,246,167,148,2,141,113,255,54,209,12,127,12,231,79,80,25,9,164,237,175,240,131,35,18,224,153,10,139,103,59,11,239,154,28,46,161,75,171,54,241,20,57,53,159,43,37,77,3,66,199,220,178,97,0,243,89,140,119,186,79,177,207,55,127,96,9,124,136,66,212,22,224,72,68,152,253,7,250,42,173,213,45,169,34,155,47,50,130,48,6,91,92,230,147,4,30,124,89,121,113,75,174,24,90,197,118,23,154,52,140,134,121,243,175,62,94,56,38,98,27,55,203,61,245,58,21,229,234,137,59,139,242,245,215,31,135,234,105,153,149,37,195,78,147,116,246,253,135,161,85,34,248,180,136,29,244,140,88,129,62,133,121,184,226,113,203,209,133,107,225,200,11,251,211,158,36,184,78,100,178,91,228,247,11,68,55,139,202,160,198,45,201,97,252,120,249,135,14,218,74,123,118,110,170,179,144,161,214,79,219,91,130,82,169,17,18,9,253,227,27,211,226,193,109,73,94,85,37,246,214,235,107,238,202,206,237,85,99,209,11,71,90,129,17,99,245,202,211,170,161,87,198,86,198,98,187,6,155,214,51,42,157,76,19,142,197,153,134,72,187,43,211,67,244,251,29,7,205,225,59,160,56,53,82,221,96,212,51,127,229,124,45,19,82,189,23,19,23,230,77,224,21,135,48,104,51,145,90,119,205,221,146,41,85,216,119,142,51,183,103,238,40,244,64,172,239,254,114,16,2,110,149,186,238,73,212,38,192,69,103,75,101,101,232,179,21,121,220,236,165,36,200,3,211,184,155,57,204,215,226,251,121,162,22,103,251,151,158,18,58,147,167,178,171,43,206,47,42,236,35,146,5,110,29,46,87,215,31,185,36,193,100,129,166,222,147,185,212,139,92,81,165,92,210,225,9,138,108,232,158,154,128,248,197,168,95,114,178,171,183,68,240,85,161,188,6,7,154,179,228,247,60,234,141,111,252,5,160,43,6,148,78,255,226,100,143,18,214,167,146,188,152,78,212,26,57,227,140,246,113,187,70,21,25,152,103,43,243,55,209,127,34,67,167,77,93,34,241,69,186,126,237,125,36,105,141,205,27,18,166,103,39,62,181,36,205,227,217,86,136,119,28,139,248,45,132,218,212,0,157,45,134,126,102,118,56,228,143,104,79,79,134,27,125,201,191,76,249,10,165,117,79,40,113,241,254,234,232,24,65,20,206,214,229,52,98,100,124,244,163,57,17,108,44,202,200,57,96,151,63,17,136,176,36,251,75,32,32,94,255,235,180,152,13,131,22,115,162,142,131,93,22,58,120,52,185,204,241,156,243,138,120,247,161,67,42,102,146,190,15,220,20,130,207,183,88,154,111,107,111,110,236,128,6,32,70,0,85,69,69,190,76,133,246,145,94,38,26,119,244,228,145,240,158,52,191,238,191,243,242,9,179,75,44,70,154,221,249,45,49,74,28,182,39,175,203,97,128,236,224,79,210,210,182,197,246,32,104,96,224,70,206,250,201,30,24,53,56,140,150,6,235,108,37,85,252,187,136,58,103,104,136,63,45,213,18,18,242,63,11,186,2,176,49,253,157,75,26,21,224,241,15,206,226,124,54,116,206,94,41,7,224,248,68,234,87,26,28,166,151,188,0,239,255,13,91,39,109,58,34,61,54,49,221,168,130,159,240,166,181,182,176,10,89,150,16,142,92,41,219,220,223,8,177,223,82,135,25,114,106,54,217,185,71,8,37,213,223,83,158,234,107,184,16,253,139,74,243,36,88,96,226,23,29,14,103,131,61,172,180,36,36,144,219,179,190,64,146,190,88,99,60,80,224,186,38,157,196,27,212,158,117,38,136,249,239,53,116,118,56,106,157,94,57,151,169,172,246,60,108,49,191,34,86,146,66,141,7,116,40,30,137,84,230,170,115,218,225,128,135,101,136,102,219,168,49,68,233,246,223,84,21,101,29,176,31,16,126,92,70,139,180,72,245,124,135,49,178,125,247,106,246,205,149,110,89,81,57,134,27,111,11,81,222,242,169,241,226,198,38,48,164,118,101,95,142,172,75,206,0,154,146,225,94,44,7,87,212,172,187,111,154,229,95,191,245,1,2,80,88,0,233,18,145,59,49,84,235,213,120,21,57,12,111,80,23,96,11,244,193,43,45,52,162,247,83,223,176,99,33,74,155,211,63,28,133,192,64,96,110,255,9,238,162,245,137,97,209,157,31,41,214,93,26,32,11,16,194,221,120,217,201,233,123,37,254,38,153,167,67,237,52,60,176,40,110,182,53,184,39,218,113,103,5,83,41,125,33,27,201,71,47,126,17,146,183,124,91,214,236,51,253,186,61,195,166,147,222,242,143,156,209,15,1,141,240,223,223,225,100,86,28,185,247,126,89,218,85,170,195,178,67,163,11,239,104,157,234,226,113,229,60,77,228,29,157,204,196,199,0,175,223,40,10,47,209,126,52,100,200,171,175,31,183,112,203,87,23,12,48,123,250,94,31,194,100,216,58,86,16,53,127,164,227,115,201,164,239,172,35,237,144,133,226,5,70,174,2,1,4,25,67,83,101,37,54,75,77,24,31,84,226,80,2,237,80,151,55,41,37,97,94,173,240,113,236,45,173,74,150,180,225,201,25,23,134,202,133,148,65,210,49,51,199,110,188,172,124,246,172,23,37,65,218,225,79,53,248,132,233,85,139,150,144,156,93,188,104,98,117,182,240,164,203,201,200,65,66,30,11,74,187,227,111,77,30,79,187,98,142,197,115,245,233,45,111,249,19,72,79,42,49,5,253,118,215,85,216,218,144,124,244,230,38,196,74,191,181,244,194,158,20,232,201,39,3,235,72,143,139,143,193,111,40,96,100,67,1,24,110,36,63,72,221,185,132,120,37,23,241,177,111,234,248,215,197,245,140,233,171,125,141,71,21,59,15,155,51,32,247,249,115,97,172,18,122,27,139,211,51,227,200,90,133,199,51,229,55,79,232,83,182,135,182,54,133,252,110,226,207,6,29,203,184,220,31,195,121,44,210,60,176,27,79,133,192,219,30,129,136,152,249,249,108,141,92,121,158,204,124,24,33,119,50,180,169,15,86,192,130,230,159,36,139,57,134,85,38,91,38,87,111,112,222,48,59,206,197,18,43,95,28,25,23,242,239,154,107,246,23,96,20,44,222,179,131,162,41,159,190,200,48,240,142,102,31,180,170,10,1,68,153,69,6,247,215,142,16,108,28,114,61,56,177,226,195,104,204,152,43,144,134,119,222,195,160,126,245,128,91,94,17,35,196,215,157,92,126,97,64,248,254,141,168,197,252,238,131,144,218,117,174,120,128,55,96,74,65,88,133,58,92,30,134,188,46,219,35,12,60,182,27,32,131,162,109,152,63,193,237,206,148,54,132,5,89,151,138,248,9,52,23,72,109,65,39,146,168,66,17,170,159,95,83,90,207,100,20,100,118,190,43,3,6,95,38,56,130,51,70,190,105,149,75,83,93,221,251,223,133,100,176,69,144,243,220,95,14,80,131,157,211,143,236,3,16,253,21,6,215,79,86,123,165,118,89,0,232,201,192,24,149,74,194,100,226,98,234,194,130,5,229,133,9,253,82,229,50,207,30,182,251,252,197,236,147,135,234,26,24,27,111,208,140,243,77,137,95,186,51,26,254,92,155,167,41,88,245,56,180,145,28,17,178,108,208,237,177,46,77,11,154,78,193,1,208,53,65,219,78,69,38,128,177,31,195,103,241,148,192,199,176,220,243,162,94,33,231,106,80,232,79,23,24,20,102,105,239,91,171,143,198,189,211,127,248,157,53,143,211,8,79,39,205,51,9,70,116,73,17,234,252,211,209,242,49,186,158,177,119,97,199,105,219,40,229,142,200,17,166,6,60,94,42,159,6,54,205,186,43,154,236,168,154,255,180,39,49,212,214,52,116,187,134,201,67,169,199,205,232,195,176,221,34,148,138,43,17,151,254,241,203,139,13,12,59,175,98,247,218,57,167,35,104,77,211,139,248,0,156,46,147,238,27,197,92,8,198,31,236,54,226,45,147,34,179,155,9,104,242,117,87,216,148,164,42,21,200,19,167,81,25,139,141,116,151,52,143,104,186,148,32,91,103,76,234,249,153,63,105,141,240,112,139,151,160,1,140,213,147,8,96,177,158,234,196,108,204,178,175,154,86,214,99,21,208,9,72,171,210,118,40,206,222,55,244,62,255,251,69,85,10,13,17,81,30,179,56,248,80,117,10,103,34,108,109,249,133,253,238,130,94,10,185,206,215,145,2,189,21,222,134,153,43,124,117,214,58,173,175,78,10,252,135,57,165,67,193,108,158,219,52,74,123,13,237,74,73,212,188,24,79,244,249,155,97,2,217,152,165,36,183,175,73,107,254,21,158,237,221,32,132,219,254,107,116,60,188,0,60,183,89,70,227,168,161,28,13,124,232,147,81,46,118,72,100,62,132,66,176,197,34,117,21,24,170,102,101,44,32,250,57,159,235,170,125,184,53,201,55,63,47,52,86,197,105,36,37,1,82,26,54,12,92,68,216,175,62,101,86,52,82,253,124,89,199,69,54,28,34,46,98,164,70,252,230,32,203,23,106,84,88,76,78,28,84,162,197,89,252,42,245,125,153,233,100,167,25,103,235,180,254,119,62,244,93,151,0,192,153,106,21,127,132,10,141,141,100,94,237,209,47,66,170,99,208,226,101,175,246,184,239,100,182,157,37,184,217,150,140,3,66,90,23,139,19,162,41,33,189,255,36,193,63,137,28,119,235,239,107,5,213,141,41,147,213,24,47,47,233,170,14,164,53,80,35,100,10,159,239,181,196,136,128,71,116,59,143,51,202,9,25,39,253,35,11,124,247,49,190,111,109,32,121,253,91,25,120,116,234,22,167,212,216,8,10,3,172,55,109,28,7,205,64,23,193,199,253,108,233,174,36,151,246,240,119,10,212,242,150,57,142,29,98,250,205,90,22,208,151,216,153,115,222,144,188,246,52,113,111,85,31,143,99,63,144,194,254,4,165,168,77,110,181,90,108,232,110,174,57,141,68,108,39,112,91,212,30,32,233,76,94,254,125,119,200,0,71,199,105,219,82,140,130,21,246,195,114,107,125,130,104,195,133,167,249,187,187,14,190,65,147,40,36,253,160,218,141,224,240,249,3,150,252,51,129,126,169,207,58,40,128,255,185,135,15,15,78,102,244,220,83,200,233,137,153,41,175,19,191,211,0,186,202,21,154,85,197,183,69,68,170,220,84,20,63,106,180,36,137,98,114,219,74,54,253,76,80,40,8,195,186,15,17,241,74,81,203,75,123,148,96,1,121,0,34,52,158,114,43,85,190,24,24,253,65,202,81,107,85,71,111,227,36,11,238,252,96,143,9,3,22,62,64,150,213,55,133,150,156,30,89,5,27,124,15,159,112,253,117,177,185,81,147,211,159,116,144,20,142,2,59,192,86,73,141,136,52,125,3,236,127,101,253,199,29,192,121,48,148,249,203,88,103,235,205,87,36,220,53,96,229,182,54,70,26,102,73,156,193,55,61,201,234,31,185,186,78,206,65,180,155,210,78,139,183,238,124,40,160,52,208,26,204,194,141,88,16,115,47,196,173,98,108,77,149,19,158,159,97,46,64,183,219,30,130,182,255,90,141,138,249,224,78,91,81,132,189,82,44,111,58,10,163,120,237,123,166,167,219,229,115,53,115,31,249,140,127,202,223,139,79,133,128,127,119,98,103,189,252,170,33,81,68,155,125,129,14,140,232,75,158,114,243,154,168,183,142,99,233,28,125,122,67,105,255,109,53,184,215,253,238,31,13,243,183,39,73,205,54,44,243,137,58,23,96,74,133,157,62,190,183,170,203,152,191,12,226,33,219,5,231,241,235,42,211,171,201,202,61,240,176,205,128,147,24,55,6,195,235,219,47,248,104,236,32,208,211,75,135,94,5,208,25,233,16,8,50,57,102,37,28,4,28,63,186,145,158,181,39,194,68,171,53,215,130,32,8,225,216,201,237,232,250,85,86,21,238,228,129,132,196,121,0,179,129,155,105,36,3,123,21,129,74,177,62,21,251,69,222,176,13,14,255,246,243,236,2,74,215,86,236,177,67,15,115,202,130,174,246,220,47,29,111,31,45,198,91,197,7,152,47,35,252,241,155,24,244,123,83,198,75,167,140,150,88,104,151,10,236,209,180,124,136,180,18,104,198,223,15,26,122,144,233,89,164,244,190,145,6,172,71,93,114,151,5,238,229,16,196,14,250,234,130,112,162,252,251,63,7,30,234,29,249,251,48,15,115,202,90,39,39,243,19,163,90,153,237,75,220,65,250,171,48,55,11,245,146,169,66,251,18,175,181,11,117,93,177,208,9,69,33,183,77,117,47,155,201,102,53,17,117,169,25,20,62,29,15,88,247,170,174,176,13,169,161,192,138,216,150,102,61,182,250,242,27,159,48,64,44,53,200,90,1,160,108,122,208,30,35,32,250,241,163,165,138,233,96,75,90,79,204,87,230,62,118,22,177,198,226,159,157,15,51,51,37,164,25,255,174,156,215,209,167,203,96,196,167,17,177,184,20,139,253,168,71,239,78,185,198,43,73,28,108,120,109,148,127,81,192,122,201,185,160,188,36,49,52,31,171,145,37,188,157,250,223,197,230,97,19,3,234,184,0,223,3,195,49,82,25,63,45,46,163,254,178,18,136,185,216,21,23,119,92,32,236,3,33,137,128,203,255,130,157,241,57,217,139,50,92,96,163,162,74,187,241,17,19,111,159,129,125,135,132,226,158,54,65,124,243,30,77,244,0,72,252,247,176,248,199,228,1,223,81,171,217,48,233,37,160,235,84,94,106,30,103,120,29,118,165,107,74,162,73,159,245,217,52,94,220,11,137,143,84,194,147,242,122,60,239,205,233,243,25,151,92,13,90,66,3,203,150,86,62,231,86,134,43,170,33,170,213,252,175,76,189,41,122,139,107,34,110,21,167,216,18,189,94,94,10,138,123,95,12,53,32,3,186,52,37,101,26,150,4,125,37,243,3,32,55,120,22,78,113,219,33,75,145,209,226,70,206,212,147,248,76,236,150,217,201,154,241,203,183,195,5,73,243,184,156,0,87,197,166,26,53,220,183,131,155,0,72,201,118,62,215,219,129,207,218,70,207,214,37,29,169,237,102,215,42,222,34,202,6,193,89,173,153,45,101,57,67,252,219,26,117,76,171,144,155,225,247,147,254,118,38,250,99,216,164,86,180,81,237,121,37,229,83,83,39,170,205,26,184,233,234,222,31,107,123,4,81,193,85,121,15,205,203,15,80,11,121,163,50,155,250,172,6,237,213,236,150,214,36,0,100,13,36,206,167,243,185,48,83,92,27,28,224,198,18,184,122,102,187,192,228,52,172,223,13,183,79,53,139,229,252,149,95,229,184,5,74,33,134,99,114,221,214,133,20,19,180,204,154,111,181,177,20,186,5,249,146,88,22,207,110,152,49,179,162,208,115,20,2,221,239,246,188,132,230,57,225,249,207,27,158,225,40,232,225,151,190,66,170,135,96,7,86,170,234,128,9,170,115,251,44,250,67,246,21,151,107,106,248,179,132,91,56,35,136,45,68,10,136,218,141,175,243,20,15,139,179,161,129,154,42,96,116,223,99,185,110,164,177,141,64,234,41,229,65,94,156,189,171,206,153,131,179,187,234,148,97,160,185,125,254,121,169,230,168,233,71,174,33,164,235,231,66,188,195,199,220,214,43,63,44,245,178,70,175,183,186,12,106,47,110,151,103,98,101,46,48,6,165,168,214,216,70,218,171,111,57,189,92,194,75,165,7,126,12,253,30,81,223,243,204,168,99,75,173,47,102,137,44,253,33,229,109,186,73,30,14,116,47,165,112,10,3,211,135,204,219,138,166,195,89,108,126,203,34,42,81,59,36,252,233,238,237,34,56,200,121,99,77,98,73,63,2,39,223,234,73,147,242,177,247,13,99,167,141,251,215,76,7,230,143,66,0,159,156,111,149,204,17,224,99,11,101,133,102,72,76,27,85,78,175,24,139,232,244,34,236,37,165,241,110,7,9,76,196,72,135,153,213,57,87,228,207,241,61,49,154,3,118,255,56,219,172,173,140,101,246,231,31,153,44,110,138,130,171,41,173,182,239,176,49,154,212,193,138,55,31,92,159,52,185,3,95,82,3,154,224,166,20,45,210,250,166,230,48,151,32,39,39,233,24,199,169,239,190,71,50,169,89,240,31,119,74,1,168,181,5,216,46,25,57,234,9,153,49,176,45,255,111,53,250,23,201,122,53,86,62,55,127,84,168,162,86,103,240,167,163,39,248,72,236,26,140,100,154,255,9,210,235,168,172,142,111,198,87,201,248,145,70,159,35,103,26,20,101,210,236,146,182,112,207,138,140,32,85,243,57,34,111,253,120,203,233,34,80,254,160,229,204,61,162,41,77,214,226,245,104,94,158,246,92,56,50,107,23,164,59,215,115,204,190,237,132,196,168,148,121,229,156,95,112,66,115,226,20,54,115,127,232,38,130,102,134,94,145,238,77,204,184,241,103,176,221,196,142,197,82,145,131,117,251,191,138,72,228,222,200,241,170,246,145,144,197,248,28,18,124,15,157,107,114,197,42,88,246,115,58,129,149,45,40,132,120,110,117,239,193,84,230,114,140,240,2,50,53,41,245,46,24,128,217,159,182,18,77,74,82,143,39,17,51,207,90,50,111,116,105,253,84,250,206,91,115,228,43,191,214,157,243,244,69,202,26,238,110,170,37,152,245,211,141,183,189,64,38,18,14,38,77,154,127,7,15,106,194,248,166,48,49,167,67,206,2,89,91,38,129,27,19,81,84,67,232,6,179,52,141,55,236,212,13,51,166,143,52,102,6,107,61,249,5,160,203,133,38,156,76,30,10,33,64,28,99,114,154,217,35,245,21,246,69,73,31,107,129,181,197,11,46,49,166,117,16,125,80,84,65,48,14,132,33,170,172,106,142,32,129,32,179,159,151,216,99,172,113,22,73,12,189,64,6,77,77,38,199,253,221,245,127,159,88,18,2,170,163,211,93,9,182,210,65,90,28,205,247,239,207,87,74,31,251,178,227,22,48,82,151,214,43,193,142,111,154,115,232,103,216,13,181,123,76,207,116,235,175,162,45,76,107,124,108,6,218,139,12,54,1,130,113,100,44,190,41,230,224,102,235,61,101,174,71,136,248,3,192,118,2,133,105,182,82,244,18,160,116,13,115,200,93,165,168,70,38,46,79,149,167,3,16,48,155,199,155,184,110,108,190,117,23,218,221,6,184,201,151,83,165,202,86,156,0,71,42,166,31,94,233,254,29,236,170,120,142,107,108,162,180,65,181,53,142,228,14,241,188,129,59,11,157,51,194,4,251,177,221,118,246,42,191,192,236,111,195,219,208,19,175,56,83,17,186,252,236,35,230,243,85,55,56,15,46,4,145,245,51,250,107,55,129,248,206,183,241,209,211,166,201,144,15,242,242,34,227,197,45,101,159,184,102,27,208,188,17,136,212,217,28,42,88,199,23,73,226,90,132,117,113,32,229,197,27,244,190,78,164,25,102,95,33,50,29,213,154,62,152,47,248,49,114,46,56,156,54,94,31,174,242,126,157,69,150,238,174,193,202,31,172,112,28,124,148,38,224,44,120,18,11,229,56,77,132,247,2,238,214,190,12,122,105,197,142,129,241,15,135,254,60,165,168,175,207,45,172,53,212,157,143,42,179,131,118,206,25,118,202,14,180,184,229,126,170,229,45,255,178,94,90,86,47,255,86,121,21,62,30,125,71,200,11,207,170,32,132,16,230,210,155,143,195,68,164,240,172,213,219,169,4,59,178,203,241,183,23,197,236,216,139,126,194,79,68,40,2,25,118,166,9,223,175,29,183,88,48,222,243,143,221,194,229,239,20,225,115,254,159,244,179,197,217,90,153,73,47,238,223,225,157,100,239,211,202,32,224,253,221,158,160,59,141,96,110,211,97,194,193,136,164,9,155,102,34,227,90,217,140,46,34,68,41,107,96,227,251,43,94,122,15,94,198,78,205,253,84,22,225,142,242,101,151,225,139,80,200,57,240,168,134,149,207,141,135,196,22,138,174,175,91,188,161,209,141,29,114,72,124,244,13,188,183,14,121,231,73,72,188,244,8,177,58,250,97,150,59,92,207,5,51,40,110,122,197,197,196,228,216,18,82,132,152,193,245,50,72,67,215,28,122,81,28,5,113,193,249,43,17,65,137,45,249,140,157,177,233,127,242,182,65,38,121,78,193,140,235,195,112,114,116,219,150,172,159,73,231,172,63,229,52,52,227,54,219,19,150,96,156,70,240,16,202,141,220,116,188,181,172,62,212,59,243,164,30,128,54,60,55,110,46,174,125,106,22,25,102,81,243,179,65,24,252,78,140,39,206,134,118,40,25,238,221,218,220,43,217,28,193,204,56,230,74,118,109,18,211,254,253,44,186,131,89,145,246,105,27,12,204,29,44,121,13,85,57,104,40,32,240,194,78,57,58,59,240,71,116,230,185,125,224,205,66,7,95,3,93,5,202,20,216,163,206,230,204,42,246,32,179,104,128,30,215,101,156,167,157,161,178,41,122,58,160,23,140,89,17,145,218,50,219,154,110,101,78,186,3,187,101,166,201,42,37,246,200,141,139,191,36,70,120,202,208,79,116,245,206,124,94,48,186,112,69,52,213,200,9,192,65,190,10,7,255,60,39,108,200,166,198,199,204,131,131,195,57,132,165,95,240,174,160,221,43,40,1,57,88,233,141,41,223,183,191,188,41,82,129,190,16,147,18,4,231,133,167,252,41,181,121,167,22,106,10,142,210,177,163,202,187,134,113,254,32,46,156,221,160,232,131,221,238,165,24,93,74,145,155,66,190,186,102,167,61,178,135,145,27,46,244,193,100,161,88,23,107,213,229,243,1,132,89,56,67,59,223,6,244,232,197,153,88,228,60,107,67,140,174,165,181,67,249,44,233,9,234,178,149,190,31,103,7,140,79,34,174,57,243,181,115,123,234,148,170,158,117,140,157,114,14,7,49,42,149,110,133,220,118,92,37,210,181,205,228,91,79,96,187,179,206,122,221,7,102,206,187,229,70,32,107,74,33,125,223,218,5,55,155,224,140,232,200,138,191,179,160,167,120,117,40,189,32,175,116,216,83,80,39,105,151,156,52,252,118,162,11,236,91,167,93,193,94,201,63,138,125,142,111,234,127,0,106,84,178,139,185,203,24,69,178,147,150,200,113,30,36,127,98,182,222,67,61,231,29,158,88,220,235,112,255,182,116,0,51,236,119,233,129,90,248,38,80,176,30,211,101,46,53,136,59,212,106,114,62,168,108,189,30,226,63,139,202,207,36,118,247,177,183,45,13,228,126,82,235,109,32,190,212,143,131,222,47,106,124,36,199,78,249,182,65,73,72,206,201,197,220,95,231,69,44,90,10,176,249,14,218,44,186,19,189,192,210,62,249,165,139,145,192,155,92,2,193,146,13,23,176,157,183,143,63,206,247,204,76,175,109,34,66,42,35,223,207,51,40,251,215,23,15,6,217,29,2,185,60,137,60,235,134,238,103,112,157,13,23,203,50,249,63,27,190,174,223,155,70,219,163,30,35,165,235,207,163,64,143,68,195,199,217,238,166,202,234,24,128,225,161,76,239,81,161,111,208,89,31,23,218,116,215,33,222,221,236,55,145,229,229,3,123,218,42,162,134,176,198,228,96,238,22,217,148,43,107,220,83,211,65,123,124,189,56,152,144,192,38,250,20,159,46,42,79,88,54,229,217,223,167,136,95,195,115,235,254,72,229,187,116,76,250,159,193,123,18,53,79,117,87,244,145,230,75,27,92,143,17,151,167,105,52,124,73,230,205,166,176,5,14,63,68,217,0,108,13,152,56,27,213,67,252,162,171,33,107,240,249,129,38,1,51,185,0,105,22,204,89,62,136,23,235,152,153,208,30,186,167,131,161,225,32,238,56,162,190,55,118,23,45,142,24,206,47,5,198,122,226,119,181,235,140,49,161,94,229,240,17,172,161,8,136,0,197,178,122,87,1,25,160,201,190,89,37,144,100,195,241,50,219,67,60,234,64,36,38,150,78,225,228,162,100,5,159,234,26,182,80,209,120,235,174,49,44,126,114,231,116,142,201,8,31,20,118,17,154,108,64,70,174,166,72,215,116,93,179,118,227,127,98,255,54,215,218,35,147,96,36,52,194,72,235,24,24,2,27,217,240,95,102,25,88,192,69,14,81,155,39,40,194,29,97,46,18,60,43,26,246,239,208,173,239,209,2,61,107,61,159,71,243,117,103,95,83,117,219,194,232,19,95,135,227,90,142,216,197,52,93,120,104,92,174,31,163,174,74,150,103,235,83,240,221,191,252,40,95,185,76,207,107,144,231,253,104,5,143,202,41,96,35,110,240,107,26,230,22,81,206,104,169,144,12,88,234,25,239,84,165,171,246,55,70,235,30,143,194,216,116,6,91,86,99,252,48,6,255,235,41,24,16,212,156,31,151,44,202,223,40,132,242,238,210,33,192,11,197,88,175,198,210,109,161,54,106,51,150,153,254,26,214,146,2,249,31,29,133,158,36,16,190,218,149,162,32,235,54,58,157,45,52,24,249,183,248,1,204,105,2,33,183,1,194,145,249,90,12,212,66,151,181,62,43,205,218,21,197,241,215,2,158,252,178,2,11,154,77,150,196,73,248,224,12,56,165,147,216,147,61,69,102,17,59,237,229,100,21,10,54,40,228,28,43,243,191,151,117,209,46,124,238,66,191,59,18,90,194,205,138,60,156,3,199,124,221,103,191,123,112,208,65,148,189,156,3,32,139,12,93,115,60,39,183,193,101,176,204,142,66,139,197,16,84,29,255,178,55,228,229,61,111,90,89,190,95,22,255,123,232,91,181,66,210,100,219,132,119,28,40,24,149,214,31,97,66,175,101,39,185,12,118,13,234,43,11,28,128,53,182,228,79,18,16,193,120,43,78,225,229,142,51,237,59,23,250,202,99,236,197,114,150,22,5,241,4,151,155,155,85,103,166,93,124,89,57,24,102,175,31,181,165,144,92,134,20,144,154,211,90,167,244,41,158,31,37,196,125,243,139,58,62,167,87,253,235,151,89,214,5,54,170,200,29,30,123,252,45,162,55,232,222,143,180,88,253,147,65,104,187,73,142,79,83,100,27,11,71,31,161,121,140,109,221,168,55,254,80,103,166,228,245,17,13,9,37,136,147,204,155,237,24,195,138,232,171,71,191,120,227,210,175,140,150,171,93,220,28,33,177,194,111,100,30,29,10,197,133,70,54,84,246,193,141,200,253,252,91,167,129,187,110,52,43,153,119,65,199,225,68,197,79,59,193,109,49,2,4,3,104,115,32,176,2,153,168,29,137,141,165,138,70,189,21,66,22,158,125,201,83,34,18,114,59,199,200,89,189,152,239,69,216,146,138,219,216,246,43,216,121,80,98,227,64,10,32,94,175,190,95,50,143,192,19,166,227,46,10,220,1,111,213,118,5,241,160,224,115,138,199,48,244,213,138,118,9,213,39,184,59,16,137,63,166,238,61,64,124,59,136,141,204,107,158,14,67,196,218,128,147,175,56,147,124,64,73,114,77,77,35,59,65,25,35,238,11,184,93,196,29,152,4,148,179,1,216,228,221,233,235,246,75,148,148,77,156,44,47,31,214,51,182,20,32,26,217,239,126,29,35,76,181,76,104,133,129,242,51,130,26,38,76,90,156,124,83,24,56,59,67,43,116,55,158,22,77,138,43,237,109,75,154,196,128,241,178,98,66,12,43,173,183,52,213,161,158,165,108,147,59,34,120,108,22,207,190,178,77,57,63,222,59,3,85,142,124,39,122,227,238,40,74,171,185,94,231,196,29,51,242,159,59,8,184,243,5,225,14,45,23,55,99,14,239,60,253,27,59,204,197,234,244,138,148,100,149,185,166,98,138,83,189,42,64,130,96,24,79,155,106,247,17,67,255,135,246,132,206,245,47,35,10,202,79,177,173,39,153,79,51,99,191,157,134,231,135,208,232,10,9,175,180,26,9,192,99,107,32,13,255,237,16,76,221,99,96,33,80,127,11,122,52,173,93,166,172,166,6,206,62,36,206,9,178,241,46,7,201,218,50,161,117,194,235,176,116,5,204,155,251,200,51,86,218,169,213,223,237,130,55,251,210,229,59,251,212,240,6,215,166,154,220,58,231,1,106,219,207,150,144,122,112,63,60,231,100,113,201,83,75,13,184,201,191,178,65,60,96,171,126,0,193,99,142,8,217,129,34,241,146,93,40,76,78,192,53,109,83,73,30,176,252,0,141,207,39,108,73,217,143,115,17,80,26,157,132,234,204,131,24,178,191,246,40,214,190,99,47,77,243,218,104,117,127,104,252,94,195,137,150,72,212,143,223,216,172,242,236,42,112,174,117,162,26,99,212,231,109,37,232,169,13,210,207,89,78,25,211,151,49,243,76,61,169,128,55,111,1,32,252,81,220,138,68,203,65,33,228,122,243,172,127,48,229,4,4,211,213,76,175,82,185,252,49,244,179,1,150,206,36,173,169,140,206,101,3,251,197,224,167,181,55,54,38,57,217,35,149,100,8,178,86,136,88,84,105,178,29,118,123,183,234,119,18,175,215,111,113,30,237,62,122,242,21,215,4,41,177,150,242,145,191,237,3,219,70,201,223,168,9,254,46,126,1,221,147,140,135,223,185,245,89,13,104,61,163,95,18,176,119,59,170,30,152,55,37,112,136,53,34,74,191,125,88,132,122,170,67,36,176,46,190,121,90,45,237,85,13,70,226,182,161,78,218,115,17,135,139,69,56,245,75,6,110,197,170,171,185,139,33,150,131,109,90,93,66,29,242,23,180,54,80,141,144,33,201,61,187,121,113,79,50,165,170,8,200,136,63,126,209,240,116,242,213,197,28,66,37,98,16,246,239,33,143,208,18,76,67,52,58,135,246,192,237,154,89,252,80,128,125,107,184,176,112,117,150,33,239,7,136,30,191,46,219,34,170,33,133,186,24,86,178,27,121,69,225,156,221,213,205,90,81,131,240,84,50,217,248,56,225,76,20,11,16,109,76,13,64,226,115,233,216,14,102,228,64,66,84,45,218,138,161,34,1,190,144,72,243,40,123,154,99,30,250,4,9,239,96,207,112,237,188,192,62,11,142,120,79,149,135,242,144,45,211,104,249,232,175,56,63,53,226,13,146,104,238,238,142,86,108,45,60,239,25,134,83,70,252,28,107,194,47,176,174,34,89,68,209,37,6,0,45,141,115,154,247,240,119,190,117,255,115,162,252,79,79,229,44,223,214,105,16,179,191,154,99,214,205,81,225,141,42,4,146,254,99,97,113,181,143,172,170,30,86,93,121,206,193,59,112,61,68,189,246,236,60,30,139,82,252,56,191,171,143,33,187,101,198,245,239,157,18,151,88,178,221,48,254,106,101,27,251,59,161,212,45,108,79,180,14,51,193,164,207,135,178,147,177,80,141,144,12,178,11,250,102,102,117,99,28,85,231,170,195,42,106,141,126,182,26,222,146,79,118,239,93,220,248,180,56,1,69,26,144,32,143,62,131,63,113,169,121,224,237,66,218,13,111,149,86,108,197,235,60,61,210,239,46,86,11,190,247,43,83,111,31,221,68,113,39,49,59,2,236,64,56,69,50,252,30,160,75,228,2,101,192,144,247,192,101,29,207,123,230,188,78,147,196,108,14,65,149,70,98,170,245,69,83,220,192,20,31,141,240,115,172,178,49,67,154,129,143,143,55,40,169,229,238,74,126,127,77,9,108,41,48,118,229,6,32,250,59,239,216,170,23,42,30,70,236,84,211,135,71,229,55,10,246,208,145,200,67,126,160,31,217,1,128,189,137,107,33,176,33,211,202,250,182,226,45,59,97,96,120,224,51,229,110,13,148,229,193,149,162,14,205,66,111,201,61,174,171,140,23,55,114,162,130,218,12,162,157,121,93,124,201,182,70,3,51,214,3,123,142,251,232,127,232,39,2,194,252,117,129,37,172,99,35,238,170,54,3,97,98,5,132,234,140,184,18,5,80,176,224,117,117,208,227,21,108,92,83,34,134,86,95,183,217,84,193,3,169,230,75,9,78,71,16,40,91,109,101,219,97,44,46,135,200,225,69,170,147,135,4,156,212,223,47,49,138,171,113,107,119,141,99,25,219,17,209,112,203,185,27,237,211,138,38,6,97,75,42,136,28,219,172,198,19,12,182,241,238,160,210,177,88,223,110,153,194,56,243,115,221,123,48,120,59,131,58,73,146,6,248,74,117,154,1,11,187,114,185,104,197,231,25,247,156,207,200,235,118,70,56,54,220,205,35,49,226,118,94,236,50,96,238,8,90,73,165,26,193,202,192,102,139,133,13,145,209,235,53,103,76,142,115,195,13,23,149,111,185,46,228,174,93,61,128,40,50,142,121,239,44,10,223,207,203,72,84,135,97,225,193,10,171,219,2,48,195,162,66,24,42,167,100,43,107,149,134,44,159,92,32,88,246,39,178,236,89,9,104,226,197,12,186,107,242,75,189,49,171,92,137,239,29,61,110,142,236,54,65,196,125,197,91,114,4,62,75,153,247,141,226,71,244,201,178,249,229,197,122,112,60,57,241,135,7,227,249,100,27,9,119,96,205,6,97,77,237,1,124,27,183,27,188,132,180,89,19,53,81,226,138,229,4,155,221,2,111,194,244,209,144,187,246,144,3,77,99,103,168,57,89,62,50,58,37,217,195,139,207,78,92,12,190,164,213,90,3,178,250,44,127,99,229,237,6,36,113,119,8,134,67,219,102,149,224,195,205,177,113,227,143,1,215,218,215,111,202,192,77,116,216,133,188,67,103,245,110,10,102,159,143,47,209,149,239,26,238,166,127,16,73,151,37,10,64,171,213,61,113,85,79,40,205,183,243,26,188,143,229,0,64,140,92,3,133,190,48,39,241,27,47,186,5,130,213,195,192,152,222,33,185,43,248,46,47,240,156,203,47,121,44,222,240,47,1,253,157,19,113,83,234,131,222,37,51,27,28,65,94,131,131,195,136,238,97,205,124,8,203,228,208,251,193,146,159,83,163,33,121,244,206,87,73,107,123,201,4,206,64,206,39,64,82,232,72,166,104,166,183,103,16,193,105,225,35,25,252,167,200,22,214,175,99,195,130,113,82,6,42,214,94,60,224,200,59,181,34,28,105,177,247,67,213,113,68,201,29,154,63,112,29,200,120,84,165,32,34,235,53,110,103,101,40,174,2,199,186,79,34,80,255,148,122,237,251,107,149,113,93,44,129,248,141,11,150,11,147,9,159,149,133,208,175,87,217,242,129,60,117,241,211,102,73,114,138,137,239,228,205,235,110,78,179,183,198,108,97,134,201,247,247,118,238,178,210,81,235,204,166,149,155,75,79,255,121,91,166,26,146,241,243,205,222,95,214,233,170,107,29,123,107,123,135,60,87,27,157,50,214,200,175,3,11,187,48,222,33,15,227,188,57,78,130,63,22,63,151,131,71,174,78,239,216,111,89,101,232,31,2,0,43,54,161,230,22,16,48,59,111,13,55,72,11,196,22,125,174,201,17,103,97,36,145,67,217,160,98,123,205,95,236,176,177,153,81,211,232,167,40,138,24,225,138,53,86,21,186,250,244,204,10,33,180,216,7,120,210,253,251,208,10,247,172,125,99,156,254,85,187,135,121,155,30,36,70,74,133,156,195,12,214,199,205,252,109,11,36,184,205,76,42,161,118,134,104,187,236,173,248,141,135,7,45,153,132,173,145,178,82,45,112,91,64,157,111,213,33,17,121,193,99,67,1,154,106,88,18,191,112,217,134,134,74,253,65,215,66,99,38,236,115,43,215,246,35,81,76,215,82,178,101,250,99,175,215,167,64,108,88,83,196,124,232,145,106,8,241,153,53,137,50,141,133,16,175,165,31,189,248,217,23,28,221,199,198,156,246,88,163,182,197,132,184,48,63,25,126,150,165,226,255,176,222,32,26,96,226,138,115,74,190,3,7,14,2,208,81,125,229,240,3,252,114,241,182,86,70,115,32,47,15,38,11,254,149,16,17,219,243,193,76,54,187,69,87,243,26,30,214,24,194,101,94,161,194,247,130,146,35,155,198,153,100,157,150,20,24,115,13,187,242,64,34,70,185,179,191,184,212,214,14,224,149,61,140,126,165,33,166,152,195,4,151,142,191,29,215,56,141,143,185,193,103,163,81,10,55,36,125,4,73,153,6,44,175,93,86,45,115,200,138,25,206,108,96,85,121,18,129,72,133,241,246,42,199,247,122,217,151,88,51,146,229,32,81,122,144,39,28,174,254,30,80,220,255,164,163,207,157,255,120,132,81,98,240,18,165,110,228,58,36,206,226,205,181,188,201,23,76,12,4,224,201,116,7,118,53,251,50,210,244,193,92,150,211,55,186,190,168,1,233,143,174,6,205,139,119,253,223,193,12,58,109,246,11,105,38,188,54,216,36,206,169,88,159,108,233,59,238,233,164,192,84,21,116,71,156,226,81,3,107,238,20,138,22,243,72,247,85,46,28,38,174,77,245,227,21,22,237,107,102,46,173,28,205,105,208,180,134,214,229,54,59,21,137,11,213,55,223,18,234,214,247,59,176,15,117,144,169,9,22,199,155,141,208,61,219,157,190,157,166,195,97,83,216,48,167,73,137,54,55,33,244,182,204,165,180,248,48,227,74,212,32,169,11,22,93,193,181,216,35,68,242,43,223,173,181,8,148,89,146,24,74,216,152,212,242,110,7,109,155,136,212,50,197,203,250,169,253,132,240,249,15,238,144,213,27,190,153,4,122,58,79,24,65,157,111,33,151,152,232,97,187,110,167,210,7,12,123,4,156,20,15,94,235,250,13,109,54,228,102,235,23,175,208,229,203,223,213,51,125,190,9,136,178,235,180,10,15,37,220,93,158,136,59,253,161,184,194,17,192,184,250,27,194,224,63,22,173,215,54,46,13,39,140,95,14,163,239,225,119,174,223,40,164,248,110,213,48,135,242,122,91,150,136,26,159,39,238,69,43,181,184,9,206,26,90,46,49,44,114,10,57,95,32,7,103,132,45,5,82,181,142,79,223,204,64,51,123,165,177,227,200,133,160,24,157,79,234,26,250,254,88,62,98,40,196,61,89,182,151,8,176,66,17,8,233,162,221,215,144,194,82,155,50,84,62,207,182,143,83,234,4,98,123,232,219,28,153,202,205,244,18,56,43,11,235,191,187,67,255,67,166,161,215,226,112,177,105,40,129,138,187,221,178,14,142,13,237,189,253,13,220,233,200,120,102,2,120,25,55,34,48,93,90,165,253,253,0,122,169,95,177,201,33,123,227,11,65,186,65,29,144,17,23,208,234,242,100,102,173,174,99,147,202,193,83,175,100,47,218,77,94,105,220,150,80,182,52,243,110,13,23,176,118,29,55,132,120,233,51,249,224,104,4,45,91,233,60,196,15,147,178,133,124,31,94,91,233,145,69,176,70,151,135,35,254,66,118,224,213,160,99,103,34,144,196,233,110,45,197,18,10,69,12,203,109,252,160,137,225,93,87,172,31,95,220,222,138,131,42,112,176,54,168,58,115,35,53,63,37,111,171,17,64,212,217,8,229,27,228,188,29,147,186,50,233,221,252,86,172,29,231,192,223,55,210,112,252,45,22,237,32,175,98,195,197,74,17,218,57,121,211,36,115,122,35,144,208,0,79,118,199,119,83,184,251,51,179,141,215,72,129,66,70,75,139,216,36,243,165,205,252,125,178,111,16,114,35,238,217,78,150,31,110,235,145,113,161,10,189,79,221,131,243,86,206,221,7,160,99,23,172,35,19,22,252,90,55,34,241,176,81,253,80,152,210,214,68,24,18,157,56,157,94,232,78,66,199,119,163,0,253,106,38,69,36,150,95,66,169,137,206,157,243,172,176,178,168,116,29,165,195,37,38,235,207,23,172,216,223,203,200,6,145,49,255,151,195,74,36,56,10,23,11,161,51,155,242,106,152,172,235,164,196,239,239,214,222,134,245,152,169,118,3,139,35,48,139,57,89,126,97,159,140,187,142,164,119,82,128,240,164,3,147,235,195,36,235,121,201,35,112,230,85,107,160,191,18,56,2,14,132,35,76,120,247,22,96,115,79,139,104,246,212,143,189,56,9,110,36,67,165,108,122,183,20,35,22,221,154,147,223,62,225,64,247,121,160,237,95,151,15,95,132,177,234,228,247,179,137,221,149,66,221,131,226,32,230,246,195,124,6,34,65,216,98,196,184,119,110,6,111,237,147,21,93,63,94,69,187,221,114,242,219,55,121,46,126,98,217,222,122,101,113,101,64,0,236,212,216,16,95,0,242,134,246,188,169,109,24,187,14,231,126,65,237,206,103,214,44,66,32,223,194,179,190,34,48,174,93,107,60,44,55,67,37,108,167,113,215,149,116,140,225,178,138,94,251,93,2,59,129,233,129,209,206,181,37,17,108,192,151,182,44,166,118,58,158,214,198,83,136,246,221,50,212,194,142,97,30,105,215,69,92,69,238,217,185,21,70,78,73,242,103,110,252,176,252,97,234,78,157,163,116,2,193,78,98,112,39,197,152,200,84,149,100,10,43,86,91,46,154,179,139,59,36,25,160,92,161,4,1,140,123,187,237,100,133,47,162,46,147,153,79,64,201,55,8,93,45,67,162,105,85,12,16,122,122,116,80,101,160,230,77,81,227,83,106,215,21,184,103,223,207,169,126,92,233,90,76,142,77,255,177,89,234,167,103,175,231,144,158,125,219,92,196,144,26,12,129,20,111,203,57,167,33,194,247,242,211,139,241,39,84,216,248,94,150,163,207,220,49,37,213,92,168,155,246,117,196,65,169,160,197,15,138,91,72,221,15,169,242,190,105,221,6,42,188,135,130,87,129,243,223,50,93,98,92,105,187,60,122,216,148,91,111,253,9,248,248,236,43,241,106,60,75,181,104,67,199,223,150,226,70,148,170,12,61,124,205,24,33,202,204,236,216,152,77,59,254,229,66,152,193,101,202,221,202,156,135,181,61,12,127,39,52,144,160,138,38,122,198,83,172,207,224,184,183,79,172,155,88,172,234,5,222,159,121,114,202,187,221,140,191,17,194,207,123,193,177,60,152,61,247,36,153,175,143,97,185,90,82,89,28,11,218,85,6,222,202,73,245,233,158,186,116,73,32,83,216,58,89,99,191,34,215,119,203,194,54,3,10,151,255,59,112,38,29,210,3,216,150,105,180,242,158,130,38,157,14,42,68,206,221,71,44,53,127,117,123,62,169,107,195,1,78,94,108,198,199,136,41,91,95,142,170,15,74,9,135,9,29,181,168,166,55,57,35,21,161,171,204,13,182,208,26,50,110,64,212,149,139,89,143,113,203,42,229,44,156,223,44,51,186,12,180,50,102,240,11,31,137,96,115,204,191,215,112,136,230,174,150,85,152,95,151,127,172,127,132,137,161,96,47,35,89,160,45,58,236,145,45,217,191,20,116,17,25,223,14,73,72,63,137,54,170,131,50,138,121,114,160,171,0,136,34,231,132,254,82,153,38,20,80,204,193,169,29,13,222,250,230,147,44,82,77,120,98,139,17,44,50,58,206,68,17,93,22,184,7,125,245,222,32,226,59,147,131,220,31,229,137,236,143,79,2,88,193,118,170,226,168,28,232,66,176,18,255,18,107,48,36,203,236,45,118,234,38,134,137,250,148,59,156,62,209,189,194,46,128,25,6,97,94,151,208,150,198,55,176,31,98,57,64,253,50,5,235,153,130,157,223,181,22,137,78,7,247,2,21,110,144,48,214,97,21,121,46,227,100,171,6,21,2,70,159,121,120,145,47,69,103,157,210,163,224,252,201,173,176,246,77,22,79,152,58,217,147,192,47,199,115,98,149,66,85,161,249,69,195,112,139,204,133,158,79,99,0,204,91,175,98,245,63,177,43,125,186,232,145,169,56,6,55,45,143,231,126,83,89,46,74,167,11,0,140,227,39,206,48,255,64,141,186,178,250,2,244,28,32,116,188,15,16,221,202,42,26,82,172,72,150,190,124,222,54,165,112,37,183,200,238,226,192,243,155,190,252,142,70,129,226,165,240,154,7,151,41,126,225,227,72,134,248,165,129,30,79,227,104,33,97,232,28,36,43,73,196,175,45,205,176,69,237,85,93,24,234,229,235,32,51,83,148,34,26,250,176,122,25,121,56,206,62,65,90,184,106,70,19,125,47,61,56,206,243,106,45,149,29,211,221,178,240,40,202,219,54,91,43,75,171,244,0,168,208,204,228,224,29,190,218,132,69,96,167,199,110,172,230,174,53,136,13,56,241,223,205,64,204,178,37,94,189,69,126,2,160,153,155,125,221,113,4,203,181,66,111,115,233,204,96,68,139,8,128,220,20,241,93,230,231,124,15,201,81,120,66,29,94,52,123,54,103,68,41,193,138,26,86,155,53,163,48,105,243,64,194,208,57,80,67,254,253,173,103,189,159,27,106,217,193,112,84,57,116,248,116,97,215,192,253,244,25,206,20,80,151,144,71,143,168,249,44,175,38,89,60,201,75,205,82,89,95,44,88,47,206,223,12,231,86,9,14,8,137,86,98,73,232,121,11,68,166,36,234,79,211,69,101,0,137,117,158,141,17,122,195,56,1,219,12,56,149,0,160,222,213,143,34,13,76,146,197,231,149,173,208,24,217,199,228,145,100,71,127,191,142,114,9,190,1,96,87,162,97,246,19,157,179,69,252,137,135,9,77,243,179,194,87,150,161,126,234,224,37,58,10,121,79,77,119,188,236,13,173,1,236,5,139,132,205,196,151,46,113,124,165,40,246,51,8,27,95,6,232,241,0,255,196,44,131,135,202,148,83,94,9,211,34,225,213,115,196,50,61,255,173,152,124,83,69,214,243,151,230,190,172,179,188,176,75,13,73,18,30,112,6,219,197,56,68,140,179,24,67,244,112,44,32,239,64,112,12,54,17,252,253,114,186,92,52,105,41,28,207,89,116,166,82,224,62,77,45,108,185,109,249,220,197,125,215,116,22,73,205,221,132,157,47,139,163,68,208,1,115,29,25,100,141,113,99,48,43,26,75,179,37,65,148,176,75,101,102,110,67,157,19,246,149,175,42,153,218,132,119,37,223,194,67,168,240,191,248,100,127,72,146,33,3,42,228,176,72,116,164,12,204,187,242,228,164,64,153,236,2,183,60,212,198,253,190,207,170,85,117,5,186,215,89,4,149,110,82,122,133,244,115,86,188,193,55,192,98,147,11,220,49,95,140,44,219,226,162,33,137,170,140,147,224,76,248,229,206,214,192,190,42,129,118,133,99,186,186,99,138,115,217,137,222,236,132,95,14,84,147,176,91,57,27,229,158,225,188,124,0,208,194,95,157,113,18,60,242,232,40,188,117,119,80,23,250,146,68,6,4,155,168,21,224,72,101,58,146,221,108,53,4,178,191,143,179,15,185,212,112,215,164,3,23,123,41,153,28,247,203,36,203,133,127,106,230,184,176,166,97,17,253,242,252,22,4,176,179,241,85,202,193,87,52,167,4,95,103,237,210,220,207,241,53,120,254,103,36,235,224,156,196,85,50,193,167,234,11,228,58,2,45,163,3,185,92,245,198,185,14,139,90,123,233,51,169,60,149,43,179,87,28,250,176,94,156,131,155,100,126,197,109,125,210,98,152,160,95,171,29,230,16,126,76,156,81,4,79,0,233,74,168,250,120,63,123,207,116,142,142,108,111,177,213,181,143,37,173,106,172,149,87,187,255,26,69,88,215,176,234,208,123,224,110,107,49,229,75,250,201,134,118,180,146,191,198,124,239,109,44,201,43,178,82,50,152,146,158,47,148,117,172,120,174,72,174,132,176,86,99,130,23,240,85,63,75,102,171,95,135,100,58,193,141,90,249,217,235,158,200,21,11,127,128,242,88,97,50,52,31,206,172,178,254,240,242,226,96,151,64,46,154,98,67,209,50,183,84,190,160,212,34,169,82,38,122,160,228,133,31,138,253,146,171,146,217,79,98,3,78,214,18,116,243,180,185,183,60,55,102,19,145,168,11,174,200,180,165,31,188,90,249,223,252,42,224,57,148,214,160,133,123,208,34,221,105,156,3,154,242,119,168,169,188,81,68,211,29,145,255,46,123,109,105,74,109,194,6,171,22,75,136,58,169,121,99,35,250,240,213,245,187,223,168,231,130,223,59,94,196,37,39,100,108,252,97,159,236,127,31,35,213,203,124,2,14,87,159,22,70,127,214,131,127,167,170,45,22,82,50,17,152,57,251,25,27,229,65,155,162,5,193,57,227,197,17,168,213,242,193,253,80,55,9,225,31,233,87,153,222,148,248,203,55,201,213,12,134,238,101,125,22,136,61,2,216,180,18,89,132,193,204,44,37,180,242,197,3,218,140,150,19,6,19,116,207,56,110,168,214,139,158,110,56,19,74,201,94,163,237,21,98,194,35,32,117,130,223,84,148,233,205,42,11,100,203,15,111,143,245,231,86,31,190,8,212,148,249,22,131,94,219,240,210,15,221,189,184,246,85,249,227,249,237,245,235,210,93,182,24,224,229,87,99,229,199,194,61,133,135,163,202,253,245,219,251,143,163,94,254,105,117,237,144,122,74,105,1,181,168,52,174,251,65,45,65,136,18,120,226,64,120,233,62,101,98,89,30,82,37,230,151,63,182,198,47,54,133,218,189,7,111,193,60,142,186,153,92,23,123,166,26,168,143,57,193,43,223,148,71,16,138,246,173,166,168,191,116,209,36,4,152,216,175,239,30,122,135,53,249,25,212,130,187,199,109,138,157,57,194,2,51,160,107,39,6,141,1,224,5,246,255,126,99,165,50,23,129,195,169,141,243,190,216,254,227,120,26,195,223,62,199,151,49,76,88,0,131,255,59,39,202,166,58,161,83,192,219,184,251,172,150,58,66,64,233,74,224,31,42,124,51,53,33,111,158,55,172,72,55,119,253,216,125,223,21,139,170,15,154,240,155,126,131,175,97,178,192,161,64,101,119,53,90,138,170,221,139,24,103,252,219,62,243,217,184,11,1,57,151,65,98,251,153,247,108,31,189,47,156,17,246,219,132,72,125,186,205,126,103,163,182,97,94,129,188,160,199,242,120,146,7,96,181,211,88,136,86,50,31,186,230,9,225,233,57,142,56,134,77,33,112,168,52,73,96,173,134,138,148,96,251,43,135,118,159,195,129,15,150,9,50,14,190,211,189,138,190,205,97,62,140,231,41,11,142,86,199,62,165,194,170,17,54,204,10,133,20,111,97,99,223,149,119,59,155,88,158,21,5,229,66,74,92,115,166,81,126,181,215,152,24,227,117,163,80,115,226,70,38,54,107,204,183,40,167,151,70,118,172,61,66,194,205,198,118,90,70,7,104,236,36,81,150,164,145,226,80,197,207,238,32,160,239,12,92,133,225,34,55,11,219,59,41,231,78,35,85,251,207,4,196,222,182,139,126,20,196,142,226,53,87,207,53,37,15,254,126,50,27,253,129,179,73,251,85,187,237,42,253,193,102,205,99,21,12,99,132,151,144,81,114,205,54,168,97,105,179,245,76,252,25,23,92,50,246,123,42,53,145,46,185,137,196,44,78,31,76,248,200,55,16,90,8,176,254,177,175,172,186,226,181,155,128,203,120,147,245,141,235,77,129,94,105,244,208,59,83,168,88,241,86,134,207,224,121,21,174,147,75,239,235,21,224,191,229,88,124,64,205,106,100,40,14,246,9,28,60,59,244,18,232,18,82,32,111,107,103,6,1,201,190,22,225,109,4,60,41,23,133,202,76,76,43,181,9,245,222,255,115,116,159,209,72,137,236,107,246,205,227,76,32,232,126,201,44,239,23,183,168,95,23,221,203,216,172,123,79,47,128,197,238,213,128,154,127,164,149,130,211,176,172,22,90,237,51,94,133,215,210,46,190,197,66,173,121,20,8,101,61,178,171,131,185,161,79,86,6,197,162,66,168,61,108,44,253,244,45,232,236,19,136,89,124,74,10,209,162,133,240,187,78,232,9,23,91,158,67,144,83,62,251,46,29,170,238,253,145,14,119,41,191,165,148,253,142,50,67,7,168,71,107,217,183,76,154,146,240,161,107,146,186,139,195,81,178,133,173,128,146,110,97,189,223,187,199,176,242,158,204,0,167,153,86,12,217,109,237,238,12,214,142,156,21,78,255,36,41,240,77,165,2,57,4,129,91,68,210,220,163,179,155,194,43,113,116,135,203,88,39,255,24,253,179,101,142,12,198,211,4,87,88,18,20,113,84,140,116,164,206,151,190,182,88,253,177,61,194,88,237,230,38,47,135,9,54,161,199,216,236,156,225,4,172,58,220,103,201,2,127,48,32,10,233,139,70,114,252,220,64,75,200,221,5,40,109,165,78,113,46,120,117,14,82,35,11,150,166,178,225,171,160,219,33,67,79,169,113,131,253,243,21,3,156,130,221,54,156,59,237,78,151,3,177,25,141,254,144,103,109,55,26,57,180,142,34,146,185,63,6,160,28,136,50,172,89,234,128,134,162,210,230,153,158,224,91,15,238,32,145,50,165,80,187,191,156,244,88,37,200,113,24,113,108,203,184,22,50,81,46,144,32,83,238,152,73,153,82,203,238,127,113,17,198,240,227,154,182,85,147,225,149,8,92,171,88,105,190,188,234,114,212,186,242,215,163,57,194,218,77,10,209,18,243,12,115,220,245,83,86,7,113,4,8,57,95,121,19,125,52,22,182,84,52,192,28,221,56,191,44,211,155,75,77,240,216,5,222,223,208,165,253,238,49,8,178,162,74,148,212,81,215,35,216,124,180,194,10,104,70,134,124,67,101,84,161,116,153,224,4,122,92,96,12,103,90,191,242,141,99,222,56,183,101,211,195,64,203,190,46,77,126,70,146,146,197,255,20,37,15,220,154,17,42,21,201,92,229,134,171,224,185,107,60,106,59,100,247,232,200,199,0,15,159,133,102,186,86,99,107,229,123,106,171,189,54,141,180,150,144,25,81,142,68,224,102,186,188,10,112,64,207,197,116,132,95,37,239,247,45,167,245,146,109,30,142,84,24,141,160,28,24,62,254,74,241,11,89,73,20,175,196,230,63,216,113,61,10,7,208,10,231,5,75,106,28,151,223,68,235,163,95,245,130,183,113,120,31,33,166,173,249,105,108,61,245,72,178,110,16,16,31,233,235,9,148,137,100,139,243,110,35,163,223,83,229,165,103,0,145,124,162,152,131,158,22,19,212,93,33,234,157,0,250,217,135,2,251,149,35,81,137,60,121,195,191,28,111,65,227,239,212,37,57,66,116,200,247,132,47,233,97,117,81,218,239,45,223,73,161,161,225,119,217,99,151,37,218,60,40,25,78,2,41,128,210,21,2,90,73,216,253,143,210,130,36,101,163,91,9,188,179,120,105,67,113,236,199,82,240,131,16,248,208,86,146,225,203,202,72,16,13,193,120,10,156,205,32,212,39,156,227,173,187,246,194,175,2,85,72,24,139,52,220,25,50,64,127,49,29,29,238,214,193,103,218,200,113,58,226,136,173,20,75,71,194,13,29,103,236,20,106,28,151,163,111,255,96,111,46,3,226,241,3,144,224,100,202,200,223,139,118,62,129,96,244,224,251,173,239,26,178,109,190,220,92,47,179,3,146,60,112,101,228,94,84,61,224,26,93,140,220,119,188,226,172,116,52,38,96,72,249,121,107,245,57,107,220,225,201,172,112,9,238,196,37,107,218,249,228,162,140,9,184,217,238,20,215,65,242,153,20,106,64,233,223,117,239,0,197,194,182,203,97,41,136,203,241,157,85,145,52,12,82,82,130,171,200,186,11,185,250,48,146,45,230,116,35,92,147,192,170,178,208,204,119,221,200,24,81,199,128,31,173,65,123,6,160,213,57,34,162,213,89,103,104,181,42,245,28,95,123,92,216,121,9,56,245,142,87,119,241,69,39,22,62,113,177,91,196,187,87,240,168,189,218,15,185,128,119,201,232,185,206,167,142,20,2,84,53,128,46,156,171,64,11,175,18,191,253,125,67,25,38,37,34,62,197,3,198,64,87,204,208,15,191,248,75,220,191,234,109,249,1,46,132,147,6,170,169,66,239,155,212,19,229,39,132,103,204,8,212,170,170,204,119,170,98,62,234,121,157,189,77,227,212,40,150,79,133,48,72,121,57,16,39,60,219,171,105,214,243,228,85,200,59,62,17,197,136,101,217,91,220,139,178,74,103,141,253,22,43,81,228,15,105,58,255,135,43,168,14,146,71,91,101,137,68,113,123,17,134,150,156,184,20,89,91,115,190,163,171,11,107,138,176,195,210,12,52,124,183,113,124,11,96,124,23,40,42,4,171,229,199,85,104,147,213,69,143,171,187,173,90,176,116,66,116,1,66,148,19,149,25,178,141,242,61,114,26,208,53,99,78,175,124,61,59,234,208,71,133,160,109,82,242,254,75,188,240,54,229,100,157,122,44,255,39,44,143,25,49,77,231,162,62,14,178,35,101,101,41,144,54,142,77,246,220,55,17,250,15,76,99,161,101,197,109,52,43,92,241,4,145,217,142,249,60,51,59,202,199,250,107,141,184,158,38,10,49,207,237,191,33,222,253,171,70,9,217,154,103,152,67,144,81,50,214,126,163,145,187,79,199,71,50,69,109,180,183,217,211,113,65,200,225,255,113,73,1,13,58,121,199,57,82,238,140,237,75,158,199,144,74,8,49,155,207,30,185,106,92,135,216,72,59,110,50,34,245,250,160,19,36,149,74,218,140,115,182,207,193,115,47,253,77,215,151,179,142,181,59,162,176,129,131,33,217,88,179,211,158,233,185,20,104,17,100,23,42,233,242,216,112,114,118,100,153,210,42,151,150,198,98,143,108,189,208,107,12,131,238,145,153,15,83,4,199,123,126,185,187,246,235,186,219,49,166,181,15,161,212,67,120,216,178,153,97,156,162,235,134,152,2,149,97,220,125,159,148,34,136,176,104,235,185,66,77,66,0,244,224,110,5,47,72,123,242,128,147,92,199,35,4,229,196,179,198,96,33,194,112,57,147,174,170,248,187,227,130,154,98,49,180,158,117,195,102,171,74,85,169,32,219,169,93,75,145,239,65,162,56,66,180,102,128,146,188,154,238,146,42,197,191,199,44,140,4,205,67,34,203,185,208,104,193,179,232,228,208,61,223,95,6,150,85,237,114,27,188,151,129,238,4,105,35,84,75,175,43,151,164,66,137,122,160,135,24,153,20,169,52,195,146,194,132,33,134,238,141,159,7,64,42,179,228,26,208,80,60,173,19,204,3,142,25,197,89,212,132,166,206,176,26,107,179,51,214,158,57,146,28,53,22,51,144,169,150,121,160,168,157,129,95,250,170,64,164,41,142,208,12,103,229,96,177,98,3,175,97,5,88,13,224,36,58,48,17,156,89,158,148,112,202,137,80,34,153,230,235,9,114,29,25,212,237,231,76,27,208,197,187,237,179,99,217,107,135,157,234,91,223,120,33,80,155,219,71,197,253,64,126,50,176,21,53,62,66,79,222,23,152,53,220,221,146,104,52,193,246,106,142,79,107,144,203,16,87,30,162,168,155,42,30,38,57,159,170,85,70,107,63,204,137,142,158,58,126,19,200,18,204,250,146,88,59,136,100,147,112,179,146,0,194,36,47,232,16,64,162,193,240,108,154,32,62,112,238,189,145,226,187,100,134,154,151,83,245,18,49,193,102,105,156,4,139,117,145,120,27,198,45,185,118,102,83,228,63,7,168,167,221,61,108,196,246,40,96,233,15,89,194,235,150,20,138,172,236,105,75,15,35,47,175,34,135,253,97,110,55,224,235,47,74,188,225,79,149,139,218,149,46,168,45,158,251,164,95,241,192,214,20,115,14,42,161,199,119,114,101,189,182,1,77,186,79,83,160,90,109,200,105,138,17,93,14,228,3,73,70,228,200,45,81,14,211,247,206,248,108,19,182,233,66,86,115,197,19,53,137,8,9,0,252,200,51,143,86,201,139,62,111,162,165,164,132,219,3,79,61,137,68,195,95,81,70,36,54,191,125,131,194,47,159,240,42,229,211,161,167,178,154,165,46,63,39,9,32,216,63,197,140,3,55,129,202,126,179,255,177,152,20,136,38,253,94,111,172,16,111,236,35,56,120,94,151,148,42,15,148,8,130,238,88,252,237,240,206,167,249,125,140,223,13,157,46,113,163,31,176,141,147,201,125,55,95,174,33,142,206,82,90,7,69,128,23,162,39,221,73,133,139,107,20,3,99,35,195,147,54,215,184,48,150,228,22,44,106,59,154,181,228,86,39,31,237,32,243,175,16,230,168,147,91,107,14,237,82,115,130,121,237,18,203,206,60,227,24,182,176,38,87,100,170,164,134,36,3,204,4,245,151,39,58,106,124,13,138,133,162,159,101,93,101,229,66,77,197,255,192,219,188,49,180,0,56,151,56,90,78,80,157,47,116,143,145,51,125,109,83,22,108,4,116,29,216,197,107,189,78,212,157,150,151,60,160,244,226,121,37,242,81,252,85,111,4,226,217,148,85,97,57,182,165,5,75,236,96,174,205,222,72,198,224,108,123,25,51,37,104,11,131,220,231,123,27,41,188,79,242,50,26,177,214,218,153,156,0,194,188,227,35,77,135,218,221,37,170,23,49,151,178,43,146,131,142,130,114,100,75,31,0,231,60,168,238,244,83,41,160,191,130,124,138,193,253,83,63,203,158,35,3,134,52,38,198,172,149,251,195,136,35,20,113,9,46,100,179,96,105,55,80,24,31,129,145,155,132,99,133,7,242,1,175,31,72,17,174,38,62,134,233,125,139,120,246,97,200,227,71,4,186,53,229,147,19,230,230,204,156,212,135,78,10,41,74,225,3,177,22,225,220,149,0,50,251,46,219,113,195,189,14,155,69,50,237,245,234,66,109,111,231,10,171,80,217,10,123,140,185,4,87,194,140,59,177,81,15,97,18,118,174,236,140,117,255,82,239,168,23,222,4,224,10,78,143,241,46,117,126,47,235,121,150,27,8,241,49,184,4,41,108,109,125,216,69,16,86,30,2,203,181,62,193,152,43,85,180,164,24,228,243,13,176,47,194,43,51,150,219,191,202,162,77,88,165,163,168,137,241,228,138,140,34,211,13,185,139,78,4,79,141,38,114,32,181,98,93,119,251,250,6,39,236,186,222,29,64,234,125,166,178,132,14,173,57,134,84,204,222,174,245,132,9,2,134,195,126,140,84,178,123,248,251,250,179,19,156,136,147,123,142,112,25,166,165,195,224,186,32,58,125,127,44,191,27,123,129,167,254,79,226,5,215,90,162,137,223,208,217,207,249,13,151,11,59,221,2,227,88,50,52,106,24,159,206,92,172,13,106,246,250,209,182,206,137,190,99,148,10,231,116,47,186,125,251,26,114,14,91,195,73,239,45,250,2,126,70,82,164,11,217,206,252,132,55,46,74,35,137,35,173,115,227,246,58,237,236,246,51,31,236,121,229,195,244,119,238,45,21,27,6,216,157,177,207,93,194,45,148,54,185,148,48,66,244,101,221,241,250,146,171,36,91,0,126,242,204,200,221,149,226,250,218,188,6,248,225,101,44,224,149,116,135,244,45,75,211,140,52,135,84,158,215,109,42,184,33,81,230,36,159,252,47,4,254,174,69,184,124,39,228,133,253,101,97,144,92,77,75,231,13,158,39,172,168,55,142,207,125,126,72,170,233,185,181,13,71,191,99,65,180,75,180,51,183,205,124,223,245,11,16,58,54,238,53,245,196,93,92,247,80,216,197,173,138,203,34,156,218,169,125,231,107,4,8,221,128,228,76,22,190,47,238,46,88,56,102,252,250,235,71,39,122,2,182,111,48,166,242,88,66,223,194,175,9,98,67,221,222,169,17,3,218,10,219,251,60,122,152,160,107,74,237,168,108,3,47,209,16,252,185,92,43,196,238,249,8,3,183,232,86,159,28,29,239,65,125,220,67,188,11,109,119,18,128,225,225,168,246,239,20,121,74,74,211,193,181,103,56,207,175,249,41,65,102,109,254,226,25,24,135,215,152,47,145,82,235,175,137,102,91,202,93,139,16,57,180,82,28,134,49,131,164,121,131,184,32,12,174,215,53,104,107,57,171,101,93,154,84,65,52,121,233,100,215,185,35,7,93,159,242,187,178,157,235,173,26,215,113,206,121,191,7,157,22,225,221,221,53,96,47,220,62,190,20,124,37,255,246,33,19,7,52,31,93,114,132,173,27,73,118,80,215,93,193,103,41,100,95,149,173,130,7,57,116,20,223,155,103,173,181,36,170,2,116,234,135,51,158,225,108,253,69,101,221,189,246,202,249,186,20,206,61,119,153,175,79,21,107,117,217,104,159,41,115,139,0,151,120,181,28,175,65,41,16,161,17,215,231,76,253,227,237,140,141,171,26,206,192,9,202,170,248,104,26,123,229,37,233,111,199,71,217,32,231,217,118,200,12,14,186,106,13,79,140,176,29,182,3,203,141,76,204,7,159,155,211,221,60,117,189,167,169,87,3,65,39,43,149,168,82,122,245,174,133,146,109,137,49,172,145,212,28,228,61,40,228,204,236,229,104,71,190,96,248,122,40,64,171,189,227,242,77,69,8,4,70,184,194,133,61,178,232,170,172,90,100,244,76,16,24,88,67,27,38,155,67,85,181,77,165,185,134,182,245,22,87,149,53,40,36,240,69,96,0,178,83,180,19,148,94,194,251,34,130,126,176,141,129,12,87,173,22,47,72,105,38,27,254,254,168,199,110,144,77,250,189,252,145,143,16,157,154,164,203,123,2,27,59,164,63,129,76,59,115,75,25,91,226,177,244,90,104,152,245,199,19,100,101,49,140,212,127,241,37,61,249,185,162,48,65,214,218,150,141,243,4,143,67,137,208,13,184,122,22,63,121,186,209,63,212,14,69,79,72,198,175,170,145,86,50,129,70,122,120,223,253,223,230,40,186,9,224,116,243,99,5,205,26,171,42,141,242,138,180,255,36,91,88,93,157,104,167,169,199,178,194,127,102,130,87,19,65,182,36,171,3,60,202,87,68,93,146,204,233,32,42,200,141,73,35,219,25,72,221,68,223,229,155,243,210,70,25,123,20,206,240,185,4,118,41,214,118,240,30,130,49,189,237,215,87,128,92,30,74,134,95,252,116,34,190,147,82,174,247,232,48,4,182,25,136,168,210,218,191,21,45,3,71,98,203,229,41,30,90,198,75,70,255,134,24,60,36,33,153,215,152,197,47,68,89,188,183,10,110,19,71,16,107,81,56,58,171,194,48,54,8,25,83,26,99,47,0,21,205,53,39,141,221,95,251,46,126,15,28,34,91,59,144,53,236,97,39,8,102,180,235,68,42,173,94,42,34,78,255,167,9,130,145,240,71,9,30,155,180,195,157,89,27,79,58,133,195,112,181,224,154,71,88,3,151,123,246,235,85,223,36,38,143,231,50,185,57,79,74,139,159,17,103,151,220,158,126,235,125,247,19,8,95,43,59,93,71,55,59,150,201,11,95,153,88,14,105,247,40,244,26,114,205,165,206,144,17,221,180,13,191,139,250,172,152,251,202,197,87,94,74,233,169,118,10,251,1,240,123,175,221,143,233,41,30,107,238,248,103,31,249,169,47,162,87,205,201,39,87,201,193,135,162,136,252,14,4,102,55,46,125,107,77,15,171,223,27,181,66,0,203,135,154,253,9,54,38,175,225,84,136,170,40,230,16,121,85,207,122,221,85,176,76,26,195,95,163,160,75,89,60,216,34,205,182,120,25,123,13,105,168,171,4,5,200,108,189,19,143,134,59,196,139,197,134,73,240,82,167,46,120,92,240,19,243,118,107,212,131,7,30,236,35,194,208,243,253,56,2,127,106,145,244,201,91,31,166,206,196,149,142,210,11,164,57,111,107,163,102,47,165,222,70,150,85,153,177,244,12,131,20,78,71,109,200,194,191,1,187,208,226,92,59,21,182,107,84,126,26,121,80,88,20,78,29,185,115,189,206,57,191,138,60,4,145,179,123,16,69,205,70,237,29,202,237,218,139,160,205,213,106,240,84,58,49,46,145,176,20,58,157,20,28,159,106,80,63,141,237,158,221,247,120,131,173,134,2,1,0,194,93,166,14,85,146,53,134,129,50,168,176,211,145,21,41,140,7,238,41,239,251,129,166,237,30,153,173,117,92,225,52,202,147,158,139,220,110,145,3,78,107,169,133,13,168,157,33,166,135,115,225,34,26,139,103,36,13,99,181,31,211,75,153,55,123,124,32,189,50,220,112,236,165,253,127,215,11,234,87,63,142,102,151,237,35,70,201,119,55,24,178,195,141,250,10,16,181,52,12,254,51,242,160,110,210,36,97,106,184,200,191,161,135,137,53,77,170,251,144,187,158,86,195,195,147,222,54,39,208,104,40,16,58,87,4,131,24,111,134,9,135,252,188,75,171,211,186,39,29,214,181,230,211,246,88,169,165,140,83,141,144,154,251,15,101,250,232,0,211,101,208,221,62,148,50,199,126,1,212,110,202,78,91,75,72,43,126,120,251,235,246,116,78,119,72,54,153,199,17,165,53,75,106,190,110,255,237,151,96,26,43,160,68,9,159,223,183,251,112,149,147,17,223,87,222,245,138,240,78,62,197,156,40,196,119,220,56,3,207,230,161,138,181,115,179,35,30,153,179,215,132,1,56,188,224,184,237,239,132,201,79,92,253,208,205,132,98,82,97,37,195,139,48,177,71,57,19,161,74,54,100,152,105,102,79,7,237,35,230,90,237,234,203,136,228,112,115,65,101,70,224,48,161,223,99,191,5,250,73,102,236,250,50,108,240,199,162,58,155,150,57,175,61,86,76,20,21,234,18,106,159,165,124,129,242,158,31,157,125,145,121,80,38,128,174,39,76,27,66,162,207,241,29,212,41,32,88,192,116,63,99,150,94,222,239,186,251,63,216,33,254,99,213,130,227,118,235,249,83,74,5,211,75,234,45,120,214,94,21,44,53,123,22,53,165,9,116,59,228,134,31,140,144,129,227,9,80,54,153,168,69,17,208,34,56,232,183,222,48,115,64,87,122,36,198,173,110,116,137,137,82,198,50,206,86,46,169,7,29,62,51,107,63,106,163,61,131,82,27,250,229,232,157,35,46,166,39,15,1,252,238,254,28,254,163,148,144,131,11,95,101,177,71,81,230,165,143,37,181,227,159,73,39,87,121,238,114,144,46,115,93,104,13,183,29,1,54,226,155,200,100,73,74,227,199,197,80,16,56,97,84,60,213,75,186,62,169,51,52,168,67,213,9,18,30,92,197,222,34,5,241,155,54,154,103,146,140,176,85,114,101,159,52,87,181,37,50,34,121,7,146,79,94,62,157,186,199,59,34,118,148,21,195,106,224,204,183,183,253,249,215,201,133,243,105,222,195,12,58,254,90,86,70,177,184,57,175,162,104,176,168,248,107,198,26,188,148,85,139,60,161,130,210,87,106,126,77,103,57,136,110,216,39,80,142,190,178,200,244,104,42,240,203,46,174,135,109,246,17,172,204,240,125,42,118,36,18,113,72,102,198,225,89,121,111,178,190,122,6,105,8,66,201,3,13,219,181,136,120,234,198,205,97,130,56,67,200,106,65,145,64,252,27,103,145,93,179,251,227,145,108,54,78,236,109,199,18,62,96,74,112,58,214,126,191,228,118,107,95,130,190,149,240,106,193,110,255,169,133,44,60,168,16,237,166,241,54,178,236,95,37,108,143,103,156,103,165,152,7,251,37,52,216,221,168,211,37,32,92,166,233,253,6,183,194,134,188,10,183,201,34,139,251,182,124,19,126,72,134,50,143,151,40,49,46,156,162,11,253,241,128,215,59,47,28,77,215,210,105,248,246,138,183,60,159,49,139,39,155,36,205,0,87,152,119,176,204,156,191,227,191,213,105,83,148,149,4,40,45,228,150,98,44,246,216,68,154,228,230,88,132,203,57,120,88,46,201,96,205,25,243,84,142,241,221,160,31,131,50,10,169,45,189,55,246,98,48,134,101,52,254,111,133,199,85,48,2,44,16,152,211,90,162,66,32,77,223,118,159,69,31,179,46,52,249,97,124,238,147,254,150,48,134,53,75,98,233,80,210,254,59,208,142,153,4,124,129,136,199,226,64,244,201,59,173,198,82,165,222,91,72,50,172,186,65,48,182,203,163,245,40,6,160,191,77,238,58,107,102,19,210,70,198,117,201,70,131,30,55,198,97,205,31,99,241,163,64,81,69,230,62,30,62,103,35,182,64,47,198,104,203,94,90,48,127,143,22,138,50,128,159,4,228,125,133,254,104,236,52,150,64,213,164,206,40,168,82,159,217,146,169,0,187,47,26,169,162,55,78,60,231,215,191,12,242,250,32,7,84,189,141,116,71,196,3,241,133,157,242,115,129,119,253,100,108,14,125,24,112,19,56,78,49,235,75,119,176,183,70,96,58,6,170,241,182,59,244,114,110,187,74,248,116,209,19,157,220,176,44,244,50,172,44,121,242,232,247,122,214,188,116,109,34,204,76,216,101,221,129,9,151,203,139,51,78,124,190,232,79,80,201,235,161,218,149,194,183,65,213,48,100,204,127,133,0,67,131,36,30,96,179,88,51,155,120,86,219,36,100,195,28,162,152,75,119,11,134,236,75,89,146,244,19,206,249,110,245,9,164,123,46,176,240,6,232,168,80,181,244,90,152,41,87,185,71,209,31,100,127,24,46,240,163,193,219,51,88,174,154,71,46,136,70,193,153,223,166,58,139,126,66,91,200,251,111,195,83,236,26,229,26,142,250,72,255,95,189,237,215,55,163,30,46,161,45,153,208,241,96,170,181,132,45,184,105,195,253,139,81,77,110,54,51,102,2,126,153,151,189,100,23,72,131,210,128,167,198,150,33,138,214,211,156,126,118,204,122,184,218,189,21,196,168,104,186,245,227,210,12,239,188,244,217,220,132,237,230,162,203,220,95,66,94,232,175,128,36,148,187,39,105,199,87,16,158,164,9,175,235,123,124,148,81,240,113,20,204,232,56,119,199,102,84,173,95,206,21,95,38,95,112,128,84,84,211,116,235,177,83,5,223,119,41,70,245,74,199,8,205,248,21,24,136,20,42,204,83,144,110,130,124,223,210,23,140,61,12,171,178,244,236,184,76,86,24,139,77,205,82,6,32,53,82,176,171,189,158,44,174,237,153,60,58,134,69,204,117,27,127,93,82,26,128,3,37,179,69,153,130,26,87,40,76,95,55,164,27,165,142,200,144,210,4,146,240,213,245,92,209,176,135,80,35,170,108,73,168,10,242,32,93,3,215,73,139,135,59,150,174,155,98,227,242,148,45,170,161,53,174,10,201,186,75,92,129,176,131,211,9,153,184,236,206,169,73,163,199,10,37,182,163,147,120,126,116,40,202,125,222,251,124,48,28,50,53,91,110,216,132,213,11,109,42,208,182,203,48,93,220,66,64,225,182,19,132,134,105,123,51,157,35,11,166,105,127,163,27,96,158,214,101,122,66,170,254,85,122,29,51,81,29,206,115,44,78,78,64,110,120,243,25,245,94,154,128,21,158,243,169,201,72,200,55,25,69,86,238,4,186,229,33,121,208,103,97,48,239,2,82,178,186,73,129,180,17,43,20,9,171,12,55,145,205,27,63,248,58,4,122,89,44,111,7,87,22,194,241,69,8,252,118,157,216,39,55,89,99,116,89,250,127,6,67,127,145,28,183,198,128,210,39,61,71,43,220,5,150,8,20,227,32,157,85,70,135,50,242,138,20,252,156,43,22,160,236,167,221,197,175,1,229,51,195,6,9,135,89,154,90,5,155,69,244,183,45,122,130,190,139,201,195,207,179,65,112,79,226,83,52,130,185,157,194,69,139,109,17,32,146,164,152,5,250,179,110,230,245,189,213,105,239,147,76,63,90,203,146,38,53,100,80,21,111,7,71,9,15,235,45,147,1,224,178,194,174,13,154,183,202,21,125,243,72,221,115,190,217,201,67,212,182,153,2,39,211,134,98,201,30,245,162,179,47,32,67,147,178,122,2,228,194,91,128,41,230,140,166,73,73,13,147,168,69,18,122,187,100,167,99,28,24,32,67,200,20,19,175,153,167,144,250,232,108,111,244,64,215,189,9,255,213,45,94,18,141,119,175,68,253,7,118,212,165,228,190,163,182,205,208,43,49,209,63,137,148,53,100,37,146,69,70,220,119,10,71,6,8,116,162,189,61,224,104,212,126,233,188,40,124,87,108,90,206,158,201,233,128,190,144,186,121,74,230,195,153,159,247,25,113,223,73,186,22,178,78,83,89,10,114,46,254,217,56,19,137,244,250,130,66,154,47,124,48,113,184,229,188,223,104,224,203,23,33,57,165,134,9,252,56,175,219,204,191,99,179,222,76,146,42,251,52,89,189,114,117,247,11,22,87,169,4,91,225,203,45,195,185,196,135,68,83,234,143,233,35,246,224,128,122,23,167,52,109,223,231,183,46,248,198,220,23,17,198,46,5,172,0,210,218,103,17,37,19,107,213,243,119,232,14,8,53,3,172,62,10,65,220,236,128,192,151,246,177,37,70,79,181,137,153,2,252,218,222,102,44,174,137,249,106,229,121,75,79,165,169,221,15,195,84,195,174,145,138,23,71,232,101,174,92,55,3,188,170,38,89,138,96,151,204,196,32,180,15,171,208,51,21,233,83,103,181,165,145,38,91,228,116,75,3,40,58,243,52,57,101,239,196,36,67,0,117,247,199,23,249,146,244,53,84,85,151,177,205,197,204,75,249,228,41,87,253,2,86,0,13,121,77,183,143,245,229,245,42,69,80,37,29,242,187,8,31,246,231,5,41,66,78,158,213,148,157,218,184,209,176,215,216,61,209,44,41,127,156,6,236,107,141,18,71,126,169,116,156,73,194,226,131,224,244,14,165,227,224,201,61,199,150,219,157,210,146,130,3,32,242,132,110,57,131,69,103,113,136,5,92,244,200,165,216,39,111,246,60,113,151,148,20,221,211,160,116,134,181,241,226,13,39,173,3,16,81,50,27,150,110,194,61,242,120,216,65,244,108,150,240,26,103,161,89,10,19,218,99,53,225,164,185,116,37,224,62,11,241,202,143,39,79,132,80,176,255,243,135,178,236,65,30,125,116,242,178,78,30,123,255,85,43,66,126,85,178,83,50,17,197,97,46,115,82,109,147,183,3,121,37,70,223,126,166,47,159,77,2,93,104,241,142,78,48,121,35,191,32,149,83,39,120,153,72,151,204,55,152,59,187,110,43,254,164,87,111,144,90,134,127,79,246,43,230,199,146,230,245,161,9,46,36,62,250,25,138,246,204,180,11,41,99,59,190,169,251,169,211,19,101,188,231,239,183,72,170,80,36,61,107,235,67,238,219,166,240,59,34,212,226,213,205,115,234,188,254,208,52,99,50,73,68,69,50,12,163,6,14,114,116,207,21,1,157,152,232,84,184,121,235,29,106,203,133,217,176,0,122,66,106,3,31,190,176,205,13,98,169,174,100,222,164,74,166,201,202,44,254,136,250,138,186,168,105,112,65,189,31,165,76,117,238,48,204,231,88,3,63,152,222,100,230,184,106,178,122,162,19,178,143,31,175,151,235,176,208,0,80,192,8,101,232,212,88,113,190,247,230,176,201,59,148,252,153,43,216,51,181,241,72,250,0,140,102,20,97,191,253,152,125,182,225,90,74,124,229,65,94,144,142,143,77,19,9,216,141,230,102,230,37,129,27,142,68,230,24,210,240,182,114,177,120,50,10,160,42,76,196,79,85,49,43,105,43,150,80,90,43,180,74,67,31,106,237,119,67,36,77,183,165,62,82,1,60,140,125,132,84,123,92,244,102,114,35,69,58,157,236,175,235,74,247,62,27,162,7,41,205,113,84,35,57,142,70,61,77,57,127,162,7,226,30,249,236,238,36,38,145,195,36,12,139,55,232,62,23,43,141,6,65,66,18,218,167,175,9,103,250,32,69,222,238,90,206,123,211,13,32,40,37,238,174,80,184,176,88,139,172,247,179,110,203,55,44,102,249,87,0,150,2,15,190,51,15,125,164,143,169,224,26,134,237,212,201,126,50,191,199,185,126,128,72,105,157,153,176,253,29,234,49,239,60,189,209,212,74,130,163,150,239,146,19,234,188,175,148,164,217,100,71,209,185,48,74,90,243,239,132,248,242,2,112,12,42,208,251,110,218,224,214,127,112,187,171,84,140,78,233,81,98,151,193,176,217,113,47,166,151,227,254,249,250,31,41,151,254,87,51,159,26,227,210,120,80,65,155,128,237,76,87,48,126,131,143,67,219,210,198,56,209,229,156,191,30,177,178,164,247,205,190,101,107,146,165,212,123,116,192,152,163,179,63,180,69,141,62,38,95,60,28,238,200,195,98,44,83,167,159,118,107,228,102,216,124,101,98,157,47,78,45,80,32,215,252,242,152,217,80,20,111,171,93,207,204,104,39,110,78,141,85,150,1,18,135,21,190,170,146,2,52,169,226,25,153,41,112,172,59,31,147,199,80,136,100,7,7,84,154,59,70,190,73,183,105,248,50,147,146,127,108,143,19,31,246,113,172,203,32,182,88,252,13,88,104,50,5,124,204,176,63,200,145,17,106,70,205,13,22,41,188,121,159,48,141,116,53,238,113,13,33,139,3,237,73,29,140,65,7,186,134,101,226,149,93,172,83,198,23,211,90,226,122,214,246,187,167,154,250,153,153,43,67,94,4,158,83,112,34,3,98,218,251,242,207,13,8,37,138,234,111,194,61,57,180,155,224,51,254,140,200,37,180,82,77,148,17,184,189,25,211,172,250,23,243,218,162,135,251,138,99,37,237,102,144,236,48,56,20,64,202,201,243,3,108,105,81,115,198,150,49,51,185,175,54,5,215,16,204,116,1,62,184,167,230,222,88,58,34,226,215,132,250,170,102,7,25,150,124,181,115,254,175,140,232,16,169,34,47,93,198,211,130,20,76,188,134,228,104,46,49,39,152,18,172,231,138,14,232,220,66,217,7,229,172,49,205,247,89,37,150,149,112,115,139,216,57,129,78,214,6,238,250,181,229,4,126,147,116,204,57,146,246,96,71,140,224,128,212,133,101,194,150,141,70,245,245,192,74,179,101,190,121,203,220,85,96,232,133,73,174,153,140,245,133,97,101,24,119,0,239,254,122,141,67,79,119,104,17,214,140,181,51,195,186,237,184,166,180,236,164,98,13,254,196,31,18,91,218,81,32,114,170,91,27,117,217,172,56,49,234,64,37,57,104,146,183,27,194,124,50,159,10,5,37,154,164,76,197,152,238,24,134,106,43,102,106,122,47,31,170,20,102,155,197,17,12,174,172,133,94,187,73,181,90,123,89,41,123,104,182,110,125,8,151,31,151,211,78,217,22,203,48,221,237,10,145,152,9,73,211,208,164,85,218,207,53,137,202,82,106,111,254,166,198,213,75,103,189,228,202,104,5,41,169,98,71,50,48,88,83,144,96,155,218,92,214,231,250,236,133,176,185,6,127,116,138,220,167,145,9,242,34,30,108,180,80,165,124,209,31,51,68,210,206,16,155,100,142,96,215,173,72,14,161,200,55,242,28,12,63,59,73,211,94,81,177,91,120,119,240,218,124,22,17,104,196,19,204,106,194,97,62,210,208,141,76,13,78,61,78,13,180,149,125,157,228,159,150,105,76,27,239,52,157,228,125,31,193,136,213,26,23,66,109,78,250,126,228,182,9,27,73,235,27,224,165,121,124,55,199,104,113,33,122,47,97,98,216,235,154,249,85,122,225,112,255,218,108,34,117,219,29,157,111,148,74,3,131,243,9,228,88,99,161,154,44,139,39,31,202,87,181,9,188,227,243,16,59,148,195,109,154,154,62,253,254,129,193,166,212,243,183,36,24,138,32,150,37,31,156,225,115,216,213,92,190,71,164,220,44,90,255,135,220,100,39,140,53,159,17,55,3,201,107,222,143,196,232,28,96,20,220,163,249,25,140,187,59,81,94,248,81,196,71,200,188,131,40,115,36,84,252,102,215,246,65,160,28,119,246,168,101,210,56,83,34,221,5,31,156,239,5,110,122,86,251,89,168,140,113,78,72,137,12,126,1,166,66,98,103,169,100,237,59,227,86,168,15,163,71,220,203,67,248,28,211,188,187,251,251,43,149,153,128,148,154,211,117,160,35,221,125,20,138,83,122,212,61,227,97,94,206,219,85,196,127,249,187,189,244,13,197,2,156,140,240,92,80,73,232,242,164,115,117,192,254,173,201,217,41,209,87,24,108,1,123,44,185,188,163,135,65,28,0,188,215,89,154,217,35,177,92,214,53,237,107,151,186,244,123,207,65,221,221,41,219,212,29,241,109,177,137,29,245,240,92,237,147,81,173,46,43,176,252,74,43,90,30,5,237,206,54,181,235,203,162,82,126,148,190,106,212,124,146,33,140,187,224,104,255,226,231,27,168,96,226,215,126,211,25,191,248,218,143,251,69,226,212,139,71,77,186,185,82,9,13,74,158,133,172,13,196,84,208,34,120,126,29,86,162,179,46,108,35,203,144,53,71,22,65,233,182,206,249,221,53,59,104,214,187,233,205,248,139,1,140,112,248,123,62,38,253,151,127,179,69,198,65,94,150,75,82,217,84,130,232,251,141,57,142,250,37,187,51,9,7,123,132,206,132,72,8,211,120,205,206,237,62,248,1,7,174,32,212,91,94,65,130,148,147,167,98,123,215,123,179,75,128,17,76,159,116,153,145,113,239,137,145,176,196,56,65,77,187,196,135,61,163,250,55,178,169,121,200,230,184,196,166,121,206,76,18,204,88,233,56,48,28,214,92,185,9,15,31,178,3,98,39,132,41,50,214,35,212,208,147,131,210,80,95,15,104,233,162,195,101,253,90,150,114,171,55,75,33,116,210,177,31,142,49,54,202,15,72,194,119,228,244,209,213,85,21,39,172,2,4,1,18,61,119,159,38,70,134,248,141,113,24,214,102,102,200,206,119,171,87,227,95,129,40,164,69,64,213,101,93,14,113,88,183,32,171,176,54,53,27,239,113,16,157,109,35,219,83,235,68,164,101,154,49,19,120,0,217,241,94,91,75,42,194,172,247,148,233,52,106,26,22,129,167,186,194,212,94,178,141,209,82,219,244,13,117,107,8,190,244,94,91,197,38,147,233,236,134,160,248,232,159,143,225,53,142,78,206,223,133,92,155,97,191,24,146,230,137,198,219,90,16,11,37,11,138,105,140,194,212,74,18,51,169,65,22,127,161,100,36,158,255,91,11,195,190,254,166,46,93,48,184,76,159,194,22,203,179,222,53,176,9,93,20,88,172,255,162,193,55,122,35,37,143,167,98,126,65,72,231,56,208,223,153,236,244,167,72,28,80,64,69,184,235,217,231,115,204,247,237,163,80,231,37,220,225,175,185,108,194,232,175,165,169,68,16,12,186,12,124,89,6,212,185,29,71,64,193,204,76,244,125,114,8,185,52,62,176,41,93,23,26,129,131,96,9,220,126,145,236,55,253,225,139,68,173,162,199,20,83,207,43,185,64,194,143,167,163,123,39,165,140,158,214,141,72,104,5,74,175,44,44,29,129,7,201,204,78,38,182,174,185,100,248,234,73,180,187,57,212,42,229,83,178,134,17,3,67,95,38,204,240,102,221,54,124,49,54,71,118,237,61,20,176,151,210,187,77,91,126,224,91,123,32,45,171,24,157,247,56,51,55,202,55,63,80,214,67,252,196,141,147,11,90,253,128,153,32,15,46,169,170,243,139,24,211,214,112,90,185,80,248,103,71,221,197,196,90,228,192,146,57,51,79,253,224,148,16,99,89,65,124,224,66,121,245,79,145,141,181,176,255,187,74,196,118,202,156,3,137,43,71,6,31,219,239,101,123,180,113,227,101,131,188,243,153,153,157,58,21,70,58,15,140,50,219,31,184,59,48,141,33,28,53,205,45,86,182,36,229,45,135,240,69,116,107,49,4,254,184,113,114,58,226,145,74,194,129,85,137,76,85,160,98,40,248,112,184,168,83,114,81,4,168,57,12,95,114,198,37,173,5,81,84,71,244,81,146,199,158,206,5,79,104,67,135,76,20,173,113,17,205,25,88,124,94,89,17,160,177,239,53,190,29,178,30,215,97,51,77,84,121,87,47,55,7,224,11,156,89,126,142,199,83,14,192,241,1,122,72,87,201,176,190,167,132,17,189,27,64,81,143,125,51,93,206,45,227,126,104,185,31,126,224,21,13,238,94,139,58,245,17,129,168,182,152,131,66,147,13,228,233,252,234,152,30,209,249,188,167,243,30,250,33,236,88,144,147,195,78,17,196,110,52,141,99,248,110,36,9,206,155,5,16,217,17,131,253,169,90,17,224,238,96,204,192,214,58,146,209,252,148,8,235,21,34,86,26,197,157,217,189,87,211,208,63,29,113,32,198,11,17,186,241,194,135,23,66,116,178,253,170,95,181,171,219,234,129,202,192,63,194,73,68,156,237,225,211,21,59,1,156,90,143,223,218,110,185,177,162,247,214,194,231,46,25,178,108,65,217,17,143,238,107,129,252,58,181,197,1,219,218,135,89,126,2,177,255,125,154,228,149,213,23,122,214,226,128,54,148,40,141,1,230,11,51,66,19,157,225,56,231,229,131,25,190,196,120,111,12,50,157,209,63,215,109,51,35,73,216,11,175,9,222,103,17,147,26,236,204,12,62,211,177,161,26,49,159,48,142,55,42,41,211,20,134,10,188,2,25,78,105,87,89,226,14,142,34,118,74,129,37,156,180,40,52,100,43,243,176,38,231,114,16,255,27,176,107,186,89,94,45,197,85,106,145,87,164,104,80,107,129,94,33,112,202,6,163,254,80,138,60,73,245,36,93,15,144,171,168,22,33,172,230,208,162,113,231,23,220,28,179,249,62,79,6,117,173,229,96,134,35,26,58,52,6,0,169,218,113,2,105,110,30,146,177,66,122,40,29,87,151,159,225,233,208,212,113,13,55,8,239,40,136,31,0,247,206,127,93,80,33,173,86,133,123,81,167,67,16,90,163,139,32,122,163,209,177,215,100,178,134,106,185,79,243,202,94,214,255,173,115,229,91,169,30,132,140,142,247,157,165,141,132,136,59,69,177,83,236,82,49,81,50,229,116,120,128,124,38,249,217,88,69,222,117,200,148,156,220,135,135,161,35,8,117,173,163,81,156,112,21,63,11,123,94,133,189,74,44,82,237,229,75,169,147,62,123,115,218,134,71,156,8,205,237,27,189,184,101,162,33,246,248,177,48,185,66,48,76,60,195,124,10,140,246,252,157,193,123,210,218,157,21,249,106,63,162,106,33,156,97,247,209,213,52,93,85,102,199,4,42,215,89,149,115,83,210,195,239,233,103,177,139,187,106,72,161,39,205,177,72,128,132,5,81,147,28,178,19,246,185,241,131,178,69,140,136,193,128,162,45,134,185,108,19,145,79,95,72,191,78,32,135,242,147,229,161,203,105,73,122,209,165,116,201,253,171,113,72,120,33,114,224,2,28,104,51,189,53,198,13,49,252,159,110,83,146,165,27,254,131,229,26,1,152,144,43,164,87,199,187,191,243,49,110,31,77,249,76,189,132,229,192,146,244,103,43,238,247,144,26,96,201,70,120,9,156,62,93,255,227,12,223,159,160,230,237,39,109,151,210,98,140,205,50,64,8,36,212,27,253,146,46,119,252,43,137,44,34,119,125,210,242,183,151,133,136,157,138,170,154,48,255,220,61,8,193,206,45,152,155,161,233,244,172,127,83,105,177,133,14,11,157,88,41,20,197,132,56,91,237,122,60,220,138,210,205,109,179,241,202,100,144,19,46,114,121,84,183,115,176,236,100,69,170,83,165,58,146,145,35,32,9,42,218,29,184,79,63,102,202,34,71,72,238,84,217,65,143,179,209,94,116,107,130,59,110,63,24,113,154,181,67,232,80,68,37,52,222,95,136,178,159,163,94,245,199,30,96,63,225,41,0,106,119,79,24,25,189,194,190,57,8,16,221,239,35,104,124,69,202,209,188,171,23,153,98,5,241,237,200,255,82,81,2,45,160,121,63,115,187,11,50,103,98,232,40,229,99,195,78,108,148,64,239,225,180,242,234,111,128,209,219,223,241,138,235,68,166,20,8,17,194,194,90,18,179,119,237,197,173,58,218,151,9,33,253,236,137,136,58,155,51,12,0,120,52,177,209,160,219,211,219,246,203,83,247,232,189,233,214,71,23,163,226,12,17,227,50,109,32,35,243,103,2,59,109,166,157,255,111,132,162,4,101,154,116,183,251,147,196,81,136,96,132,91,201,187,103,230,127,129,188,168,90,141,233,197,24,108,64,82,233,156,135,14,51,177,172,148,205,247,38,72,8,40,142,2,124,118,73,100,187,129,50,127,220,90,254,127,19,112,237,24,47,222,147,190,234,228,156,144,118,50,237,68,159,121,47,238,114,112,190,106,31,97,187,120,240,70,195,2,167,115,183,71,59,60,253,78,126,186,59,227,198,112,169,54,56,140,21,100,55,3,250,227,27,254,141,237,138,190,41,75,88,190,200,16,223,56,215,37,84,196,221,214,118,221,47,27,183,92,119,187,114,240,224,224,25,179,81,149,197,141,101,225,130,207,193,222,166,17,93,40,244,160,232,46,125,70,56,234,204,173,191,223,238,120,20,19,217,43,202,33,93,74,42,37,143,171,109,51,138,51,137,16,107,136,37,232,62,238,230,88,210,14,87,200,17,71,135,41,199,185,189,248,48,128,180,4,58,216,156,205,126,159,59,45,47,230,252,229,16,36,22,192,32,63,239,65,221,111,103,185,103,79,174,231,9,147,68,249,195,74,221,42,151,4,55,12,115,119,125,20,165,42,21,55,222,122,157,71,117,45,196,31,244,48,34,230,102,208,172,5,227,252,237,39,183,46,36,177,74,54,29,3,71,223,134,227,16,8,154,164,137,248,61,115,209,8,143,55,250,168,232,97,233,53,187,211,154,134,219,228,7,175,236,103,49,160,175,154,213,87,220,61,184,141,152,182,108,178,110,7,225,62,168,202,63,27,64,157,129,160,68,73,131,134,21,41,214,112,210,122,202,181,237,21,103,75,27,197,45,103,9,107,104,209,71,134,98,74,108,140,112,10,23,177,213,113,18,143,41,176,21,29,123,106,186,24,25,31,36,50,129,86,137,214,110,140,131,32,81,138,193,0,69,175,184,88,55,146,72,155,17,139,130,76,186,42,149,165,149,203,66,172,168,161,132,113,41,210,115,195,42,183,32,217,77,121,33,44,140,31,146,5,110,76,132,51,209,244,156,134,116,122,212,21,174,246,220,122,51,135,189,108,73,209,68,25,227,121,140,82,103,231,225,56,76,248,236,72,133,222,213,253,107,218,61,234,206,149,231,205,8,73,191,232,123,143,151,191,79,162,5,222,151,112,51,117,169,169,78,55,159,186,5,230,85,20,111,5,52,15,6,37,192,102,255,185,157,144,162,12,57,230,109,138,197,216,26,95,86,193,83,95,116,62,39,155,176,161,130,95,188,137,222,242,195,42,209,124,82,38,209,20,100,135,237,67,196,51,47,8,62,92,33,226,242,20,24,255,23,98,229,3,218,107,251,4,177,224,120,154,128,217,51,59,222,174,8,100,51,175,179,7,92,225,76,5,164,164,28,113,222,147,182,104,218,121,56,43,121,249,114,171,7,74,107,74,163,79,234,228,233,0,99,30,223,216,208,40,96,60,173,248,195,149,115,104,180,144,4,165,189,250,2,41,38,203,217,174,83,191,97,69,151,160,45,197,75,193,94,251,164,155,154,149,222,211,93,205,7,245,99,90,45,237,157,139,55,1,43,69,189,109,144,120,29,194,26,42,72,147,80,33,178,103,48,6,248,238,112,116,135,67,103,158,128,214,123,229,18,164,92,91,126,41,12,60,241,31,71,191,23,139,35,3,21,47,112,132,70,169,32,230,50,90,29,87,27,72,224,71,191,116,74,241,9,213,25,160,148,239,204,147,186,84,61,143,20,216,7,245,239,255,186,237,0,233,225,145,84,213,203,105,120,114,131,69,195,62,209,176,229,23,250,240,246,243,246,73,46,139,195,70,150,244,251,162,21,235,66,154,37,67,3,109,183,214,135,165,230,167,86,67,223,129,149,122,133,36,195,112,13,19,47,14,232,128,155,101,28,81,51,198,98,30,85,156,237,220,53,252,55,199,185,146,149,99,28,44,168,114,129,47,225,226,33,245,130,252,188,7,245,159,218,14,155,28,91,42,121,188,121,107,160,221,253,33,194,164,129,35,108,228,140,12,106,153,215,3,84,45,122,201,169,148,14,106,206,117,45,113,143,159,133,55,113,163,14,42,211,108,229,241,166,145,238,160,23,212,211,80,215,78,51,68,138,186,31,241,67,255,74,213,184,180,225,27,252,251,80,15,231,124,215,12,84,216,98,69,78,226,169,238,199,103,139,72,205,143,145,98,66,251,117,103,48,85,33,214,59,195,189,11,108,105,252,216,206,119,141,190,0,176,4,24,150,148,52,78,95,77,96,198,179,180,44,172,123,17,83,131,64,231,66,206,85,198,208,142,2,101,230,148,26,225,77,199,175,66,143,25,36,212,101,152,155,121,140,148,104,175,116,250,61,204,166,227,14,150,212,49,156,66,19,124,118,89,73,193,45,67,180,84,193,197,183,248,147,120,120,126,173,247,83,152,2,67,213,127,244,39,130,206,99,248,77,69,101,89,130,176,194,103,151,87,58,79,102,91,28,84,53,65,159,217,157,118,180,87,175,119,137,134,223,131,214,171,15,29,11,163,62,185,128,64,130,88,153,94,183,223,183,147,210,155,174,102,69,128,244,114,16,7,250,104,145,57,202,170,226,181,198,242,105,224,123,75,83,223,26,115,243,215,102,12,78,11,113,217,204,42,142,63,1,97,80,41,35,5,128,191,122,25,249,158,92,182,89,113,200,47,225,67,224,19,184,157,246,61,45,213,154,232,205,253,33,148,38,235,214,133,184,217,169,181,187,123,97,239,24,168,160,111,129,91,120,146,240,169,16,95,37,127,174,183,212,121,132,109,139,26,246,104,160,144,93,234,254,62,202,14,124,78,123,57,129,94,187,248,129,167,174,8,245,103,96,43,124,242,128,88,209,243,229,177,85,63,251,228,21,201,221,119,84,18,140,22,253,208,215,167,170,11,224,57,100,129,114,52,68,75,105,255,174,10,116,190,186,138,46,146,143,156,166,109,235,198,108,67,135,15,135,210,162,26,227,192,168,110,85,230,164,56,212,202,242,95,138,243,194,135,252,246,90,234,74,206,41,125,214,129,144,111,119,249,218,165,160,243,204,145,138,219,240,71,224,232,121,139,83,216,37,163,255,63,246,199,118,70,232,231,133,64,133,216,247,155,69,46,151,115,44,84,198,84,99,143,173,154,207,184,47,190,202,32,42,255,98,51,36,125,38,57,9,164,33,113,209,86,133,145,100,136,90,98,220,233,114,41,217,171,148,189,232,58,178,242,248,131,117,180,28,7,26,227,2,150,15,180,188,231,111,228,95,228,160,52,190,58,205,14,21,168,239,59,214,196,4,185,39,209,94,233,227,252,39,101,204,73,57,218,236,67,151,224,246,123,131,84,116,170,239,69,84,111,237,113,157,200,131,189,211,118,40,163,71,143,71,137,185,175,37,148,211,110,52,27,40,166,252,131,129,207,153,69,10,116,89,177,122,68,200,143,59,24,124,36,39,224,244,200,49,238,180,102,60,26,104,236,79,36,24,247,182,166,87,53,118,24,149,167,44,124,90,244,65,166,186,194,224,172,48,22,62,112,210,131,57,226,194,106,14,206,176,16,167,156,38,153,45,10,20,27,251,37,18,71,135,87,233,190,8,53,172,44,31,177,188,252,44,18,194,8,81,182,132,89,29,58,26,106,48,76,185,76,106,110,42,219,4,26,203,152,244,31,169,209,195,155,162,102,3,153,149,131,129,165,124,120,75,111,239,251,86,133,140,87,24,131,97,116,69,92,174,214,35,200,4,165,172,162,9,162,80,36,108,28,36,14,119,128,133,42,153,213,157,94,187,91,224,246,175,3,227,101,212,233,182,123,82,155,247,237,156,220,212,68,190,224,223,32,224,249,52,126,90,20,172,242,199,170,254,109,74,81,47,197,221,87,152,124,60,190,66,26,234,61,15,152,53,215,138,150,36,153,226,208,32,57,184,136,205,62,56,0,96,198,228,187,220,242,205,39,42,19,104,35,194,8,218,163,92,250,160,95,133,58,105,20,103,118,40,73,129,185,86,211,155,157,11,10,171,175,50,218,75,109,213,63,248,204,196,174,254,208,1,222,11,57,191,119,181,17,233,216,192,45,195,200,218,209,22,141,37,120,123,114,38,176,32,178,216,86,240,223,56,251,192,11,232,206,55,54,150,182,225,41,161,234,15,233,140,149,180,89,143,89,184,167,225,174,28,227,122,96,178,226,34,252,88,179,107,205,107,214,89,51,202,20,158,78,191,17,60,234,238,126,161,128,64,41,230,192,186,66,150,197,65,2,138,79,126,177,218,157,149,65,172,142,209,254,89,243,134,199,147,115,149,62,46,217,184,249,199,84,108,188,148,192,166,83,126,196,222,149,174,2,76,3,78,229,182,2,118,24,154,119,62,6,59,5,118,57,36,50,144,184,15,166,144,139,233,209,162,214,189,212,182,254,128,214,63,137,110,50,169,42,7,54,94,60,130,247,82,209,19,119,44,14,88,242,224,214,53,41,97,73,23,92,100,179,6,214,41,138,90,162,78,148,200,229,14,94,45,154,117,79,52,51,58,38,19,116,60,32,28,250,86,181,28,138,196,75,101,37,25,11,21,47,14,141,244,190,170,105,48,7,110,74,25,164,113,66,174,195,59,139,40,80,20,214,115,124,216,23,137,192,81,40,190,62,101,120,7,74,35,225,234,83,221,104,160,35,51,104,134,27,119,10,114,76,155,29,218,195,22,248,188,146,250,210,219,91,214,116,69,100,102,128,80,214,127,72,246,74,105,222,188,120,77,126,44,103,119,62,45,12,145,232,166,186,4,124,23,63,37,252,101,148,52,223,35,215,113,225,247,210,168,105,31,98,86,133,46,232,91,72,83,51,110,198,16,87,239,97,41,18,232,185,9,27,6,65,105,47,179,151,163,13,64,200,211,126,12,253,68,93,55,236,22,63,191,234,136,119,196,193,178,60,22,82,26,37,53,151,155,201,20,13,59,130,73,239,196,247,99,249,98,23,117,156,144,6,149,125,45,201,117,220,213,110,48,87,11,230,85,108,101,82,139,218,35,8,162,93,155,129,241,97,17,178,209,226,189,123,3,48,222,220,122,193,32,115,60,131,50,152,82,232,181,95,195,43,156,252,102,148,65,103,163,100,157,29,94,113,143,204,195,27,213,207,51,180,171,113,81,194,160,18,231,176,71,222,18,234,226,132,19,153,177,212,35,88,150,154,168,97,74,60,135,183,249,145,212,252,232,114,57,104,155,84,127,110,30,128,47,174,89,141,158,92,236,41,111,78,164,242,6,77,93,219,76,167,181,0,35,106,217,183,19,193,182,160,102,93,156,237,161,130,43,53,182,39,122,195,119,6,17,95,199,2,137,124,153,8,10,205,138,154,128,223,47,162,111,31,108,108,0,104,3,112,156,189,132,79,176,56,224,138,175,99,150,220,154,236,248,236,64,24,119,168,44,105,200,197,195,129,25,72,162,93,80,156,219,179,124,247,81,13,95,163,15,80,204,80,98,206,60,207,243,32,11,160,217,96,152,86,33,199,119,200,45,107,133,142,133,35,241,239,133,239,105,159,199,10,138,150,219,186,165,158,83,49,246,200,226,14,211,179,16,17,200,84,69,59,157,200,46,248,67,22,147,184,182,98,17,159,220,24,117,116,136,13,219,213,219,101,132,139,93,39,147,248,25,102,9,149,38,22,111,215,39,201,98,78,223,9,101,181,160,124,16,152,204,166,172,248,213,61,173,41,85,13,81,233,117,115,56,64,68,252,29,77,159,63,26,57,114,216,53,183,163,22,158,176,197,87,215,117,191,231,120,142,249,239,157,85,109,210,0,79,232,61,147,14,82,104,221,164,26,163,145,244,50,204,235,208,71,155,174,205,126,94,220,99,241,32,52,197,8,29,239,57,167,78,132,160,222,119,218,168,155,55,13,219,189,80,172,145,217,15,58,128,162,128,242,130,251,112,72,14,147,19,29,39,148,63,123,152,75,111,119,97,16,6,193,222,214,28,186,64,178,178,215,48,250,222,245,40,48,171,90,173,50,234,96,116,143,225,183,239,28,40,138,79,235,132,115,209,93,195,114,184,27,61,134,82,125,36,78,227,156,53,65,255,5,61,166,139,177,23,192,136,230,252,205,73,160,252,28,101,16,145,247,167,186,83,187,93,174,47,25,22,249,137,107,22,56,105,213,138,92,132,55,61,5,253,234,93,166,160,204,71,73,2,93,168,145,0,254,171,75,38,59,145,187,210,244,45,91,101,201,112,47,244,224,109,86,238,238,41,101,111,235,122,110,211,200,131,186,77,242,64,165,189,206,101,9,134,216,185,138,11,188,50,41,62,17,124,145,116,153,77,178,20,63,85,96,85,244,116,133,64,174,50,20,243,39,94,180,200,74,77,27,109,139,170,29,216,89,222,202,144,167,228,1,191,175,109,217,3,155,115,190,100,125,48,199,61,196,208,213,28,56,237,142,23,55,228,73,41,133,94,229,21,16,13,40,29,28,213,219,61,56,92,133,244,129,148,27,223,235,249,228,130,205,178,178,88,210,223,223,109,166,128,234,158,72,100,22,185,203,42,196,179,253,151,41,240,160,217,221,104,4,127,135,167,5,250,8,56,37,43,242,240,132,164,169,160,250,11,143,34,204,165,179,237,249,210,234,68,170,37,217,192,132,92,149,169,215,152,132,59,97,201,145,37,2,4,247,21,81,84,94,3,118,51,182,254,175,182,92,146,248,81,19,159,155,216,171,31,200,95,200,83,209,154,220,247,247,1,173,16,224,239,193,174,61,89,118,36,200,208,181,225,9,143,129,123,60,114,79,218,58,239,232,56,10,206,45,120,36,190,74,211,161,100,111,11,10,22,169,157,157,235,213,101,87,181,243,124,186,18,255,13,128,115,94,43,149,172,233,114,253,128,123,151,171,88,194,54,214,80,184,165,216,1,207,175,13,114,16,3,237,211,213,94,58,114,237,38,205,229,55,111,82,142,95,84,110,187,155,154,151,189,50,162,236,43,141,178,112,214,214,233,151,1,26,213,17,138,50,28,120,248,100,16,136,85,18,174,106,47,215,11,14,189,113,174,70,105,58,54,5,135,16,242,44,72,242,195,155,231,122,81,60,167,62,209,21,209,61,96,149,128,117,183,60,124,27,146,233,175,10,245,161,101,81,136,28,194,80,14,83,48,106,241,220,50,137,251,99,5,188,151,228,237,8,152,10,240,156,241,172,9,49,184,177,179,111,47,145,244,19,213,143,149,162,47,1,64,19,99,180,28,91,14,241,204,20,55,213,174,112,83,36,106,80,120,252,51,153,25,223,42,68,245,76,24,87,251,228,69,162,93,118,121,32,23,53,205,218,165,17,223,32,217,79,177,228,150,238,236,163,182,75,70,139,182,182,61,92,95,128,34,127,94,43,37,125,185,119,237,69,74,133,193,181,175,191,225,46,191,90,250,205,142,254,148,56,63,114,202,75,174,124,224,137,253,76,239,45,92,14,199,52,211,206,177,208,83,116,9,70,39,178,123,213,147,171,56,138,236,44,212,112,147,111,186,37,71,66,15,224,126,4,250,63,60,81,114,13,193,23,7,39,151,112,129,202,16,125,12,65,130,245,37,217,215,84,185,33,88,91,173,38,184,80,150,96,116,114,86,157,179,185,97,38,58,43,120,217,109,85,65,138,84,42,254,21,25,164,233,113,197,150,50,158,133,52,143,68,21,86,102,171,254,200,175,36,58,59,177,12,37,178,215,74,235,73,131,1,216,10,193,103,85,233,90,101,213,101,176,57,81,32,102,125,3,117,87,132,7,176,52,52,26,2,33,191,126,154,234,196,151,81,19,124,100,189,172,9,184,121,20,82,71,102,0,128,221,235,130,81,173,242,44,234,127,198,47,45,156,47,207,39,47,120,3,30,171,31,108,127,224,13,251,248,87,46,54,180,189,188,235,54,127,51,159,168,144,80,79,198,52,162,142,245,142,167,104,108,211,184,178,238,250,130,182,25,47,120,133,18,0,76,163,216,137,67,98,185,3,46,24,100,230,99,213,3,100,127,3,16,13,43,111,242,238,23,116,37,215,239,70,192,9,254,130,15,172,155,197,44,88,202,220,11,136,247,250,80,235,112,32,234,143,231,100,45,28,202,207,198,34,180,101,233,225,246,158,230,20,88,59,131,1,243,18,157,205,126,194,64,195,23,255,148,17,70,244,61,42,61,147,12,48,190,153,101,37,112,134,175,106,20,140,215,148,81,157,115,106,95,186,178,56,59,181,156,132,52,10,189,238,160,138,46,92,254,108,207,70,159,31,30,149,13,43,75,68,170,210,8,99,38,3,39,176,205,30,6,215,111,153,136,133,100,144,176,180,156,203,246,86,115,34,14,64,113,10,64,236,155,7,175,98,95,44,191,95,23,166,208,167,225,180,72,162,226,21,205,118,240,65,34,74,151,90,170,154,213,97,91,220,96,194,31,120,206,173,13,28,163,99,1,166,68,24,236,141,230,27,161,120,215,11,196,47,28,247,203,38,198,233,161,71,190,179,5,191,84,65,247,103,51,219,83,142,236,227,76,128,248,64,43,29,223,45,11,74,136,174,49,72,34,77,24,204,184,112,230,187,244,133,254,42,57,13,161,154,232,16,141,188,194,197,79,173,81,139,166,72,54,250,80,153,6,86,52,40,69,244,188,53,21,253,168,95,108,106,18,238,89,116,249,171,171,140,252,92,126,82,245,37,41,49,193,60,188,9,165,132,175,64,113,195,7,15,127,125,232,119,96,118,65,108,189,184,4,193,61,63,103,249,3,8,73,63,132,33,217,23,152,189,126,68,215,24,249,163,46,29,3,53,242,82,139,91,135,112,142,178,127,238,231,112,101,13,132,217,240,219,152,22,109,200,213,141,106,215,185,194,107,158,228,200,149,9,111,62,3,84,223,61,70,162,19,158,211,25,162,108,37,79,52,214,43,209,77,245,135,71,233,113,223,248,7,49,182,19,154,69,53,232,123,125,81,163,174,118,114,29,137,154,111,34,189,152,216,122,126,35,31,198,58,172,218,183,233,176,55,102,20,20,82,27,214,112,2,6,131,47,150,51,241,58,88,27,173,189,142,7,236,94,30,237,43,21,27,2,153,0,191,73,189,144,125,58,206,9,12,217,12,130,80,26,139,84,145,55,172,176,57,156,51,204,250,160,149,38,73,3,139,33,0,92,98,98,11,187,69,60,120,3,242,8,209,103,157,236,47,10,173,111,44,46,240,42,50,211,108,86,30,44,175,5,129,119,117,181,212,91,193,23,163,21,85,116,255,110,186,53,189,187,50,218,244,32,230,225,245,87,118,182,232,245,255,91,133,105,84,49,216,151,208,189,241,229,28,18,107,227,175,64,93,90,43,153,152,219,179,135,95,221,99,22,160,20,175,213,67,250,27,173,9,186,22,75,68,105,85,77,193,224,13,134,144,73,159,55,243,179,222,115,164,178,131,80,188,53,237,31,248,64,144,150,148,15,93,27,188,58,122,215,114,225,240,60,4,81,141,35,134,217,46,155,176,102,96,79,179,10,143,16,62,198,76,91,53,171,249,106,153,88,152,124,80,49,88,94,253,97,10,66,110,144,21,163,125,202,34,168,114,12,161,251,84,10,60,133,72,142,70,9,202,106,53,36,227,229,115,38,249,21,18,139,0,145,172,219,64,7,90,183,103,121,81,146,34,49,113,9,148,131,125,21,35,103,172,4,39,138,72,208,82,20,10,62,5,157,130,0,252,36,255,216,66,52,90,63,55,232,23,7,169,246,239,73,183,94,5,238,123,191,44,240,17,132,129,165,240,180,35,25,174,224,92,77,80,250,36,170,146,215,28,180,109,222,119,54,87,51,227,20,56,74,252,186,35,26,27,114,193,245,162,144,85,203,54,85,245,83,44,251,86,37,73,111,124,40,136,131,66,231,65,139,227,161,28,237,242,215,221,135,121,129,60,111,197,96,52,182,0,242,135,103,8,238,183,23,56,201,96,244,177,196,176,129,45,182,6,40,196,130,17,248,236,200,27,163,127,103,103,210,19,167,200,19,84,210,184,251,8,119,222,56,80,239,194,24,14,47,59,130,42,8,254,7,207,207,193,41,28,39,52,45,62,242,249,135,214,197,122,148,127,149,16,110,209,10,222,36,110,0,132,0,70,140,79,27,202,38,244,110,226,31,24,173,225,96,73,152,203,40,55,6,85,95,121,184,10,182,88,184,145,100,166,86,110,72,5,28,253,78,111,102,156,73,217,102,208,84,144,174,49,237,119,189,158,207,163,141,44,133,240,87,158,67,156,112,182,253,153,154,13,42,166,21,243,222,222,93,166,110,71,50,138,224,253,122,77,68,144,49,49,107,15,23,49,234,129,16,156,0,170,95,13,192,80,209,160,250,192,153,203,141,93,172,95,207,178,173,243,34,211,29,185,16,14,135,78,52,65,242,114,164,97,2,225,9,242,69,165,121,127,171,50,99,136,211,157,36,97,98,120,237,229,187,56,26,33,215,80,11,13,191,187,135,36,88,228,184,207,21,154,73,113,228,148,98,64,68,135,239,222,248,178,123,189,124,9,167,104,31,149,144,197,50,108,129,97,245,119,123,85,175,20,236,89,24,93,153,246,151,250,193,65,219,125,14,68,3,171,233,103,51,132,172,172,54,76,7,111,240,167,227,91,254,215,20,27,207,178,205,141,211,206,46,190,63,14,10,167,126,107,218,154,229,121,239,65,98,18,220,155,115,18,58,43,239,241,126,229,150,28,199,0,63,20,157,69,223,61,140,138,46,182,9,106,224,133,12,20,168,176,155,252,115,58,83,125,140,114,252,122,193,211,188,155,50,241,201,192,95,33,113,79,27,69,223,141,226,231,240,144,12,136,122,178,201,127,152,163,189,77,232,197,46,208,19,5,57,47,151,229,252,168,128,64,20,127,163,228,78,147,151,96,195,158,77,121,119,225,126,46,49,48,120,33,166,18,81,217,83,168,115,75,145,5,183,155,24,230,98,48,75,176,189,86,199,89,73,217,222,225,66,190,1,217,68,107,194,134,117,194,89,198,230,157,56,152,56,125,124,239,55,162,156,14,85,255,32,57,221,141,170,99,130,111,252,231,227,162,106,161,103,90,13,91,100,18,241,159,43,54,79,203,121,97,26,133,240,231,164,138,143,14,166,75,249,247,243,6,134,141,237,253,178,31,7,172,115,46,144,231,8,139,32,126,156,96,181,248,43,225,24,48,108,145,246,124,63,94,166,166,108,175,173,144,246,109,77,140,128,19,193,159,217,87,60,51,82,158,250,41,168,190,252,203,79,52,26,226,84,95,29,66,229,199,59,108,57,27,83,105,130,64,31,184,89,140,232,25,68,12,172,117,153,109,80,116,67,233,131,41,40,50,149,100,109,129,120,30,94,28,55,47,95,157,102,71,255,178,149,46,22,232,101,155,29,213,117,193,250,55,47,252,56,93,237,116,245,190,92,76,82,185,255,165,102,83,124,254,205,180,121,213,136,17,82,228,67,138,160,159,74,60,75,66,214,56,202,31,42,31,189,175,131,169,244,4,234,97,133,83,10,240,200,163,83,16,13,249,190,79,196,155,250,68,52,16,192,139,13,150,45,237,240,96,128,218,96,227,215,163,203,211,220,221,112,15,12,255,223,58,33,138,160,89,101,140,253,197,219,142,87,25,161,226,99,12,148,238,176,97,128,26,76,216,168,249,227,36,147,160,116,232,1,132,204,121,69,39,34,15,162,124,104,8,8,36,251,12,39,180,253,129,152,80,93,12,113,192,124,18,182,119,188,109,76,63,236,217,127,69,150,81,204,53,123,175,187,116,127,112,72,130,232,6,224,134,72,67,138,170,115,244,76,121,174,189,128,151,178,238,160,179,56,150,102,72,145,193,83,58,196,152,234,52,226,247,136,148,252,106,195,97,197,234,74,180,211,118,238,133,252,153,35,37,80,204,114,20,81,155,248,236,58,33,160,44,177,187,15,202,32,92,78,4,135,148,225,6,104,136,47,120,170,26,200,55,233,151,22,111,194,95,85,36,60,237,197,103,71,133,208,211,16,180,113,210,242,68,113,130,129,87,117,199,14,156,188,118,87,76,136,239,61,225,145,161,43,204,219,80,104,79,121,132,38,79,103,132,154,252,177,4,75,121,254,149,214,93,239,161,40,162,226,3,180,53,175,123,85,219,113,206,243,64,122,22,180,135,192,187,218,41,9,118,165,176,80,230,79,131,128,245,191,98,64,203,19,102,68,100,215,140,113,106,19,236,254,17,83,89,40,250,158,103,209,40,17,148,10,207,133,131,255,19,211,24,17,62,10,37,159,214,211,236,253,59,164,70,40,151,231,243,71,249,42,33,141,105,21,52,219,12,8,3,210,129,52,31,190,255,187,56,233,153,176,133,248,60,17,120,253,178,231,159,182,68,128,242,109,230,63,145,44,160,51,152,58,184,205,3,48,180,71,116,94,130,124,236,10,123,220,100,97,122,45,11,92,18,194,128,198,96,251,207,121,69,234,163,195,103,196,250,187,153,78,159,239,150,163,128,118,44,40,5,222,62,27,10,96,99,75,69,135,15,121,180,33,181,241,108,248,80,232,237,209,155,190,30,204,50,42,208,22,178,217,34,84,110,231,255,48,222,9,111,134,157,158,177,179,224,37,168,83,129,173,203,194,187,80,205,174,78,139,82,10,152,61,216,112,121,177,173,34,116,138,137,79,244,191,149,26,207,241,168,45,147,222,242,159,184,125,102,149,94,168,222,185,202,20,137,130,144,75,214,4,216,251,106,47,77,107,24,226,251,53,217,180,150,197,88,153,147,150,136,208,179,220,164,23,202,221,58,35,82,236,38,88,98,171,48,204,37,207,165,76,178,168,39,131,92,157,84,81,146,103,20,78,63,26,56,108,14,91,144,220,198,68,155,80,51,100,168,143,25,85,186,77,198,202,227,246,48,24,143,121,48,53,170,48,64,198,73,133,25,79,56,89,168,14,88,212,40,220,146,125,58,122,227,243,196,75,126,123,69,71,167,210,89,143,108,239,101,33,43,228,118,236,20,83,154,34,84,51,33,45,210,106,1,118,32,14,92,53,193,255,51,13,181,34,44,122,146,13,255,57,96,240,175,176,87,242,202,229,50,37,200,109,149,32,237,22,21,162,103,42,170,246,17,100,208,174,157,153,170,210,190,127,253,129,90,102,7,241,124,187,181,170,241,5,253,165,2,107,29,176,57,221,70,214,159,254,52,157,20,132,92,199,46,81,135,218,170,191,78,13,232,165,247,80,151,98,217,94,58,150,252,138,100,253,118,71,71,243,152,145,214,57,48,176,116,184,82,99,81,38,199,160,148,143,120,64,116,67,42,156,71,238,197,35,124,232,145,4,209,128,188,71,197,209,137,223,200,174,213,176,33,203,165,124,65,78,252,211,222,117,87,86,30,75,90,199,252,86,247,88,219,108,246,135,121,188,231,113,14,0,198,83,20,155,57,241,56,59,136,210,40,182,193,85,73,13,204,108,243,170,10,170,86,206,79,28,10,128,77,140,207,251,123,158,63,123,247,113,111,216,81,4,42,25,140,54,131,54,141,158,230,164,245,205,168,3,75,202,92,80,243,13,29,229,213,149,34,117,90,219,96,71,137,101,185,121,67,32,87,61,186,179,78,67,105,51,171,18,91,93,74,113,218,119,193,66,251,36,0,103,197,160,5,30,233,96,114,72,94,204,120,126,133,71,130,93,39,53,142,68,178,223,13,48,107,93,123,184,210,250,126,195,192,105,123,85,254,14,177,24,108,212,208,38,8,126,145,58,184,254,38,238,138,233,24,250,191,181,22,112,255,27,83,32,99,153,46,83,213,46,210,143,204,5,139,94,159,208,156,253,90,63,10,178,239,2,198,64,234,111,117,148,88,191,226,56,173,191,56,152,100,34,254,143,255,82,127,200,4,164,29,246,17,79,183,56,126,13,145,193,2,139,80,207,54,233,218,128,101,75,166,216,242,248,82,238,131,161,152,245,122,141,163,237,173,233,200,99,104,81,47,159,229,46,14,198,154,189,76,78,240,19,99,114,120,219,226,72,255,170,112,41,145,30,4,187,20,208,65,236,225,139,78,117,238,139,241,238,133,165,185,73,43,140,186,119,42,140,108,137,73,207,146,180,106,188,237,220,29,129,178,136,164,182,196,159,67,119,31,171,15,144,238,7,154,171,183,19,136,140,68,62,42,189,4,92,25,98,254,132,124,195,152,44,230,178,32,200,89,237,113,205,201,91,150,149,161,126,245,135,160,156,238,177,162,210,48,100,169,1,246,131,133,162,219,197,56,30,92,21,180,75,117,164,178,36,65,151,166,107,119,119,8,65,252,29,165,149,249,39,159,94,166,35,181,220,160,190,237,107,147,95,91,171,5,119,59,11,29,35,161,70,228,43,82,73,70,229,107,207,210,251,50,152,34,143,23,245,2,234,81,212,108,149,38,157,53,158,35,89,62,105,49,192,118,27,65,239,245,63,33,83,6,156,174,49,10,165,210,206,15,50,193,127,233,219,171,169,195,67,122,103,212,102,133,86,245,208,36,85,87,205,75,231,217,54,19,156,162,180,58,173,224,164,100,248,235,175,109,228,60,148,39,42,60,62,48,31,172,24,137,198,191,95,74,254,65,41,17,235,97,129,59,171,116,111,93,40,139,45,192,123,184,23,231,211,148,109,211,93,194,31,245,39,243,16,62,223,138,26,211,16,208,234,130,118,20,212,228,161,140,16,47,74,174,241,249,196,220,5,122,158,191,41,246,66,159,124,94,11,88,12,207,153,185,199,63,127,36,35,190,114,206,62,120,0,74,235,185,68,119,116,161,9,182,101,38,81,15,23,134,131,174,205,222,120,128,95,231,83,88,87,43,9,94,233,20,190,101,7,138,156,133,63,21,112,115,54,157,10,176,235,174,124,82,183,54,32,161,1,71,235,193,171,90,212,138,182,255,60,206,120,119,43,109,166,38,154,190,141,238,177,56,226,36,26,60,171,208,150,6,196,46,122,72,149,54,191,229,201,139,20,254,229,152,142,176,230,191,168,212,247,46,206,84,80,92,2,249,119,247,148,26,242,214,19,57,174,50,73,235,100,168,47,234,219,193,155,103,104,51,30,30,13,53,119,36,249,23,230,172,163,123,135,149,66,179,181,74,196,206,111,72,90,162,241,114,168,2,103,208,104,12,175,8,122,182,226,250,175,187,58,242,85,136,217,28,61,11,5,183,88,235,98,122,11,36,114,180,239,99,60,46,101,139,95,124,12,206,35,251,240,135,202,92,231,92,175,12,112,253,174,192,174,236,211,102,22,156,242,224,3,75,244,161,16,239,144,24,85,228,181,237,214,210,168,115,232,218,55,9,14,101,182,3,24,145,186,142,25,57,157,220,12,101,215,180,70,110,175,35,120,6,210,151,135,228,201,82,71,118,102,114,177,134,20,248,77,160,95,174,72,43,123,93,221,25,224,141,213,63,205,95,87,152,207,210,177,65,152,98,158,136,16,73,144,221,171,19,166,46,74,63,102,180,68,88,206,130,118,137,153,160,174,216,119,226,167,240,254,192,156,15,97,6,216,3,0,22,104,171,249,99,227,193,128,218,215,136,213,79,187,41,11,85,254,27,131,120,150,6,37,111,190,160,176,68,138,235,215,179,237,96,175,174,119,240,243,155,38,47,207,226,252,2,102,78,204,53,112,247,102,130,138,50,67,135,111,195,220,14,233,123,112,166,70,122,254,66,198,140,60,66,39,227,251,212,3,212,5,172,53,117,181,36,114,62,98,207,2,132,171,102,154,145,88,78,150,48,149,197,198,33,248,228,165,23,186,7,91,115,210,168,92,101,59,13,214,51,192,221,135,173,92,107,177,156,112,152,184,254,127,122,217,171,239,67,101,180,236,170,193,92,73,59,243,16,99,158,163,88,22,112,47,228,74,42,184,161,186,28,15,73,193,122,153,41,3,51,19,100,9,217,66,245,138,86,166,84,98,234,30,55,158,38,98,46,69,96,125,206,180,209,224,220,127,77,10,64,233,65,148,73,129,227,116,34,134,90,47,244,95,93,22,207,50,38,117,196,160,175,236,137,81,26,21,111,159,196,108,122,127,238,90,134,194,118,204,194,120,18,63,180,0,104,255,227,17,208,76,232,239,184,59,183,117,119,100,198,39,48,141,58,241,81,88,158,202,70,18,207,142,146,20,40,145,62,212,122,114,173,218,73,179,56,41,169,125,25,7,1,110,22,115,187,252,233,41,103,69,112,49,234,10,109,26,154,19,191,8,153,159,230,5,200,195,132,185,252,214,209,46,132,62,189,165,79,62,69,11,230,112,194,43,89,126,230,24,56,93,116,57,74,158,131,171,11,140,220,10,127,227,192,155,41,97,228,128,82,250,67,69,13,162,135,164,36,23,211,213,227,174,30,199,148,254,40,144,69,210,34,39,117,32,49,7,67,92,96,223,129,157,217,138,254,105,42,173,178,220,131,180,110,122,86,149,182,23,198,38,197,159,214,187,129,205,185,244,255,73,206,255,178,33,51,182,7,5,23,15,136,30,0,1,20,127,98,40,130,45,186,97,137,107,172,164,248,142,141,75,244,10,107,189,156,179,249,0,215,252,120,99,163,233,19,81,40,105,230,209,7,167,24,246,8,238,118,191,190,44,242,159,161,193,174,126,195,245,214,21,9,199,176,8,46,48,27,199,243,252,213,156,190,108,150,207,17,238,41,162,181,199,234,193,183,51,152,12,73,176,86,101,59,1,171,25,65,99,218,87,180,106,5,53,100,143,240,133,96,27,37,203,152,248,89,24,213,177,209,245,178,153,141,24,241,35,63,20,124,97,237,183,100,183,71,135,152,195,245,43,144,146,9,148,220,186,202,9,61,249,5,0,38,214,142,170,26,203,32,120,209,124,185,196,48,132,206,178,100,213,4,188,111,90,16,177,210,233,109,192,244,16,208,4,206,223,63,100,71,113,45,159,31,242,252,238,254,145,0,60,94,225,245,150,56,98,94,231,121,51,218,171,107,184,71,51,95,164,161,10,196,100,144,225,73,92,50,82,150,138,245,46,102,172,55,138,49,104,37,5,82,96,30,42,14,79,22,149,199,37,183,23,154,60,33,91,250,17,132,147,151,164,238,220,191,38,134,74,114,222,55,5,219,111,182,41,189,75,162,119,173,8,39,184,200,184,248,202,8,45,17,140,198,55,217,230,246,143,75,234,126,0,130,159,228,217,173,144,112,253,158,88,134,253,96,200,79,108,248,209,153,17,154,79,201,67,172,144,238,240,172,184,0,152,92,170,140,46,178,221,118,117,111,216,30,59,107,221,80,141,194,52,66,30,111,157,166,168,54,210,136,231,174,163,149,97,212,31,117,197,25,227,97,188,189,77,214,141,20,157,252,186,87,155,217,40,107,149,1,174,204,73,84,24,56,61,20,90,114,246,104,36,237,56,11,208,176,33,76,222,174,227,251,67,45,3,220,141,223,8,135,44,188,74,186,233,61,9,219,11,148,131,199,216,109,34,39,28,143,7,254,65,230,52,114,18,76,66,39,183,154,40,252,14,234,122,234,99,94,37,52,36,116,190,93,67,175,118,199,246,206,144,45,117,43,232,78,197,34,20,82,196,21,206,133,25,18,244,213,206,222,146,193,142,105,242,10,120,225,82,175,222,53,203,27,48,79,27,91,232,65,124,42,250,33,224,57,67,206,9,11,86,88,144,226,90,34,229,253,235,110,121,34,122,24,223,200,252,118,98,53,51,176,233,125,188,62,143,6,10,2,255,159,173,16,225,57,141,252,203,184,145,163,173,240,122,5,171,92,129,35,46,247,240,117,179,98,114,229,37,74,205,42,198,253,230,123,164,111,26,174,20,116,170,199,197,158,249,45,34,155,244,9,228,160,138,175,170,52,215,36,173,48,24,251,163,132,63,131,234,21,105,23,195,33,86,74,157,223,214,240,65,112,35,149,74,74,94,79,56,250,110,251,231,177,73,46,212,221,82,160,122,250,150,179,80,110,51,145,22,97,127,210,68,206,113,30,29,23,63,233,142,34,22,248,46,113,80,201,175,22,219,195,179,17,214,40,62,179,112,88,37,160,132,236,48,83,240,7,252,115,96,249,243,201,201,229,201,176,6,127,7,142,252,128,138,200,110,91,146,206,132,162,217,89,21,5,164,225,231,211,20,157,79,227,151,188,63,105,205,168,151,181,92,158,192,170,98,202,143,192,155,139,159,20,208,133,127,41,39,17,185,233,59,236,172,16,251,224,18,18,67,71,44,213,192,14,164,240,115,125,236,93,151,99,110,176,224,19,167,249,51,63,128,202,20,186,148,161,47,164,206,226,82,154,160,127,43,184,3,50,52,113,59,79,233,4,203,217,127,75,168,7,149,235,47,84,6,65,203,115,189,218,75,96,40,172,231,147,21,150,89,170,125,92,247,7,52,212,46,79,8,99,116,170,128,198,164,231,122,112,18,35,109,2,52,87,207,153,232,14,67,187,171,106,22,59,193,40,142,138,136,71,232,36,73,44,76,135,61,219,92,21,146,206,234,77,182,135,222,169,98,150,201,220,208,167,160,126,121,191,254,231,24,89,48,85,20,193,128,145,230,238,68,39,233,180,107,18,139,212,128,145,246,227,174,56,0,221,108,28,79,22,42,81,174,179,77,187,74,180,149,213,220,140,109,95,141,54,153,123,198,159,244,154,146,160,22,107,236,179,85,188,184,12,165,20,195,149,32,215,86,35,242,107,201,102,243,156,210,202,78,91,40,64,101,66,239,175,174,140,226,226,74,132,13,114,141,196,135,50,120,176,158,224,218,10,138,143,20,237,159,219,99,181,183,161,63,238,34,237,6,228,127,154,228,115,98,36,139,103,1,106,82,196,206,144,130,178,191,51,56,94,198,78,66,17,213,84,90,245,84,198,44,131,140,40,203,22,45,26,13,126,0,192,227,83,18,229,176,162,129,52,249,246,43,111,209,220,144,49,99,107,143,185,234,74,246,164,249,197,199,82,199,196,163,252,12,176,156,125,242,105,200,134,253,26,32,216,199,128,132,181,125,141,31,128,255,38,169,60,33,138,140,99,121,86,125,136,6,116,135,148,49,13,121,44,127,2,168,20,64,255,192,219,23,22,14,176,19,74,10,33,62,175,191,133,44,121,249,170,157,135,209,32,57,88,199,134,37,131,30,214,191,23,177,157,254,241,206,237,136,166,18,100,134,192,236,108,181,149,60,198,76,238,121,214,138,173,162,161,254,114,147,230,53,181,146,175,43,204,244,165,134,102,5,62,209,221,89,153,9,220,121,146,81,222,177,125,156,124,106,178,93,44,145,197,158,86,245,142,204,97,247,59,190,163,89,114,39,224,164,68,89,12,245,220,14,13,221,77,134,50,21,52,42,121,133,105,241,156,109,186,158,106,91,199,182,153,93,255,114,184,132,185,56,72,245,134,26,94,47,13,126,249,77,218,203,57,216,175,62,4,164,77,103,69,132,134,25,229,79,108,91,92,32,19,42,26,194,233,94,178,70,87,97,43,117,142,155,224,96,169,205,20,188,174,43,41,118,95,133,198,44,104,140,186,151,53,240,114,208,131,253,204,187,231,89,171,27,146,4,189,64,246,239,185,44,221,61,229,177,72,169,252,98,84,104,214,148,161,219,197,192,194,149,85,120,144,113,104,3,45,178,220,71,150,177,161,209,184,191,178,223,167,43,78,39,218,73,63,133,207,212,22,3,129,109,142,237,0,33,244,42,75,70,190,195,4,208,96,29,20,215,73,20,60,242,95,73,73,38,175,45,18,107,16,35,24,46,159,25,169,249,240,171,180,15,135,70,44,188,17,109,56,14,198,186,107,9,54,94,224,164,218,136,82,44,103,33,218,76,229,88,13,110,202,69,246,170,238,234,74,146,62,142,143,79,173,62,40,65,169,235,33,123,237,218,226,47,32,217,209,35,205,23,68,49,226,19,24,48,240,252,102,164,77,52,106,223,26,33,52,144,105,198,33,72,156,121,43,204,148,52,18,167,148,131,243,42,216,220,49,97,241,27,54,129,0,62,17,68,136,54,206,246,173,78,38,179,128,153,230,5,35,244,93,119,232,176,82,137,172,236,153,0,160,90,215,162,10,220,225,85,222,217,108,145,139,213,64,119,42,184,14,129,8,131,154,97,156,194,58,180,52,225,65,77,213,13,113,144,160,202,21,92,35,198,13,9,2,127,184,230,234,248,202,246,27,23,130,3,196,65,200,14,226,27,220,236,38,242,112,130,13,177,178,62,153,184,113,97,144,136,239,155,194,85,229,21,84,18,219,245,85,194,207,127,54,105,97,54,103,235,160,106,210,245,45,193,130,113,165,16,135,224,108,24,126,139,202,81,160,196,120,150,58,187,3,249,9,246,150,218,71,70,152,195,186,87,245,9,139,112,184,156,188,238,237,53,222,180,42,129,170,214,105,186,119,40,89,229,65,251,65,138,131,10,99,204,249,66,69,24,247,105,140,229,46,225,132,240,14,78,169,248,45,223,132,62,122,61,183,170,228,52,102,2,146,17,215,173,151,202,194,16,105,216,102,163,241,95,31,162,106,138,57,68,215,1,249,193,88,65,198,122,201,67,59,122,181,106,249,94,41,123,236,16,57,25,235,181,138,116,197,69,128,94,238,8,105,170,73,38,47,146,183,15,227,221,202,43,9,98,81,200,135,124,151,74,196,187,79,247,123,104,35,19,26,206,194,248,179,249,210,143,104,208,157,16,51,213,230,79,31,241,124,37,222,199,89,56,212,251,5,12,227,111,9,233,161,213,106,179,162,85,111,41,12,246,202,158,100,238,159,250,222,172,218,96,43,198,174,15,185,55,234,208,60,162,212,107,66,88,122,198,0,125,102,85,111,64,4,161,244,35,164,50,13,144,237,126,200,191,72,28,251,194,74,201,112,88,249,168,156,36,132,55,68,203,6,91,124,172,89,181,62,131,37,220,135,132,60,21,68,1,182,0,157,251,144,151,232,178,33,40,175,60,239,69,227,73,25,97,188,156,23,13,73,9,73,207,90,14,242,185,101,134,166,52,47,63,29,161,54,216,28,156,41,167,45,85,172,171,187,147,32,243,236,147,177,231,202,104,193,228,203,68,206,80,194,225,24,178,187,56,45,218,191,12,94,146,127,73,200,19,200,208,17,241,15,183,21,49,32,235,180,227,57,131,27,148,133,5,239,238,166,86,104,185,235,51,42,12,84,87,5,200,12,231,102,208,203,250,64,177,176,194,167,160,45,2,50,28,16,160,200,52,159,69,184,54,35,205,248,0,190,113,109,0,203,59,16,12,8,24,165,254,118,94,105,122,196,149,108,90,236,226,211,57,253,105,5,158,191,85,115,66,35,89,116,161,240,61,124,193,6,154,200,85,24,26,179,248,124,140,77,89,11,73,75,148,86,145,44,35,19,238,61,188,135,116,152,246,76,220,35,139,230,16,152,48,10,25,164,243,169,75,5,96,240,207,174,118,90,41,56,142,130,104,82,251,45,244,82,171,86,98,180,90,126,222,33,190,91,205,198,196,8,187,46,5,237,26,5,61,154,198,142,19,216,240,197,21,119,55,150,64,209,212,226,131,15,115,123,223,240,255,0,181,179,184,145,96,152,120,175,157,80,26,182,53,111,66,196,225,116,123,125,207,245,38,226,32,106,184,86,137,140,171,86,172,86,206,243,63,124,102,52,236,252,253,132,123,201,46,67,118,189,197,119,209,249,238,142,91,127,198,175,72,33,148,29,20,186,82,244,30,159,235,98,255,153,114,205,112,89,214,229,181,129,134,215,232,181,193,7,140,177,191,248,92,128,180,208,239,14,215,241,143,25,159,42,164,29,167,175,250,153,213,194,150,144,145,97,22,49,101,29,247,1,228,204,89,161,91,223,15,136,123,38,113,37,210,246,61,85,89,7,55,238,214,74,139,202,63,121,127,235,130,57,164,184,190,238,17,83,233,149,148,223,120,136,236,247,163,54,97,226,255,1,195,97,22,116,249,153,155,59,194,156,152,53,254,98,167,34,184,162,97,158,96,42,95,132,238,105,59,174,169,77,37,11,155,60,240,152,255,83,153,225,140,36,165,3,93,209,43,43,25,123,52,46,108,77,84,134,188,83,223,107,219,124,109,213,155,239,117,25,195,22,68,90,30,28,123,240,190,59,222,50,234,158,145,70,84,247,243,30,193,13,33,91,2,195,105,36,91,152,52,143,226,206,137,13,236,168,8,38,201,114,111,147,202,23,127,128,47,197,175,104,13,101,86,47,7,175,237,14,119,88,208,63,197,1,246,114,133,231,61,13,253,110,174,52,122,200,117,248,170,219,56,103,86,225,152,34,228,4,59,18,109,190,145,152,186,91,83,135,115,10,166,144,5,126,104,99,143,228,244,143,106,126,26,218,0,84,72,144,234,5,72,229,176,94,27,56,247,186,37,179,149,38,197,238,130,193,30,7,52,56,254,111,36,151,12,144,42,102,214,58,177,255,58,232,183,138,61,203,165,188,117,108,48,225,58,13,151,80,184,151,146,242,169,100,72,143,47,214,184,146,98,137,114,69,49,54,172,218,204,239,42,79,67,234,122,229,9,41,81,109,105,135,24,16,227,150,167,226,91,182,43,130,237,189,205,250,38,168,19,97,236,208,237,106,26,190,185,186,209,15,234,53,33,218,232,169,153,106,26,32,123,167,25,156,33,119,202,124,69,239,47,89,109,188,230,140,160,92,59,220,6,67,198,171,224,84,145,231,168,235,42,151,31,15,202,200,240,230,160,170,55,154,190,178,194,41,157,149,105,164,109,157,4,139,86,205,193,138,249,67,80,151,58,251,131,106,89,86,126,14,114,84,157,149,46,198,97,71,73,134,2,227,217,98,148,171,57,104,50,145,228,68,71,70,160,203,137,195,176,196,232,58,131,138,210,115,50,4,46,68,130,122,39,112,147,180,108,253,126,161,52,21,75,13,11,236,153,201,216,253,13,135,28,49,129,208,84,89,180,202,127,139,41,105,212,2,245,7,186,164,188,84,147,216,20,128,93,147,93,222,191,165,152,58,2,122,223,24,165,151,250,98,88,137,122,241,160,77,95,126,199,97,252,239,40,149,121,76,92,179,134,180,179,124,134,100,124,8,231,243,156,79,128,26,76,5,167,132,35,61,237,184,110,36,122,220,79,140,107,133,87,202,99,48,226,191,212,173,114,54,161,93,143,2,35,21,239,134,246,101,206,110,233,35,106,47,113,53,49,163,39,139,198,180,199,139,86,208,106,2,40,222,22,253,214,92,87,52,78,23,58,207,144,16,97,221,101,32,187,131,85,9,81,6,79,50,137,169,130,33,226,60,10,84,216,1,18,213,62,197,233,9,68,159,183,66,11,246,8,62,115,214,214,114,35,107,76,89,196,19,102,193,113,237,194,44,109,119,253,254,43,157,109,189,31,45,168,17,243,235,238,92,37,239,17,1,170,85,123,5,21,205,50,119,120,252,215,223,45,119,135,147,223,86,238,199,87,255,34,123,237,60,41,75,230,103,106,158,178,31,17,246,122,11,37,131,72,255,198,83,72,170,19,120,200,202,243,6,243,146,207,195,226,91,13,180,172,248,33,153,12,217,85,184,101,56,94,151,212,32,200,27,238,170,113,116,45,127,49,205,1,84,43,123,254,178,22,21,52,11,103,238,182,111,3,111,43,49,190,183,102,57,254,65,216,10,165,175,94,45,203,12,83,54,95,179,6,176,204,200,239,169,35,62,19,115,226,243,65,146,208,220,219,88,154,48,102,181,132,20,72,26,97,161,221,66,134,125,154,184,57,85,188,109,71,7,164,48,8,188,250,47,132,94,144,249,226,187,85,181,7,52,197,91,191,44,125,90,201,38,125,97,135,240,62,65,15,144,40,217,165,10,96,43,59,20,22,12,215,181,13,215,120,61,36,62,216,205,13,137,153,10,128,64,124,121,67,245,185,48,166,66,148,30,39,199,250,233,186,183,188,210,210,94,224,150,231,161,7,172,163,139,13,158,36,225,145,193,72,219,117,54,219,112,37,219,236,145,238,1,249,8,225,241,105,190,188,237,52,46,240,168,99,83,45,227,208,191,130,193,199,127,164,140,135,216,177,144,42,144,89,139,32,173,143,220,179,234,96,2,150,53,163,118,183,163,72,191,160,21,97,65,46,35,88,142,7,14,12,166,166,21,35,215,254,174,184,177,215,120,107,144,50,122,109,225,230,187,82,245,64,214,13,172,36,40,232,64,226,115,16,178,240,141,71,246,183,18,145,135,181,45,11,119,165,164,21,67,203,80,125,239,77,210,157,244,110,160,28,216,18,73,205,133,192,185,73,194,58,5,40,22,195,140,55,116,217,10,4,36,153,51,167,149,197,23,183,177,198,255,73,129,60,71,83,232,111,159,208,114,52,185,162,64,247,124,199,96,181,242,73,138,50,29,61,94,200,62,64,224,39,47,14,9,48,103,237,126,143,4,144,43,104,165,24,187,103,48,190,236,217,49,24,18,173,252,184,54,194,8,77,180,190,8,31,28,98,62,106,114,113,154,149,104,91,201,70,154,69,177,94,91,115,244,181,84,63,158,218,129,238,120,20,26,20,147,20,37,173,223,92,174,133,185,121,200,29,248,65,99,216,43,180,189,201,50,132,53,66,192,47,86,115,117,172,111,140,2,145,40,75,118,131,12,14,244,100,136,233,123,106,9,104,81,251,152,84,223,102,143,39,201,214,179,174,236,61,23,157,184,129,163,77,184,220,150,169,140,230,138,24,255,254,208,223,57,86,4,141,176,17,112,233,237,221,63,72,207,5,89,126,123,247,202,98,161,148,62,82,172,14,182,213,14,217,105,117,126,26,23,156,40,218,89,168,167,243,251,50,22,111,72,107,241,198,193,2,94,72,241,13,205,224,16,41,68,218,197,116,155,7,97,222,126,193,62,158,235,28,194,70,140,96,135,234,218,194,111,178,92,15,109,153,207,179,137,159,192,26,145,208,207,83,206,179,166,54,79,230,239,139,169,37,60,110,118,11,199,162,186,69,234,50,158,2,176,74,102,71,83,144,81,87,32,46,78,2,193,222,180,43,24,89,239,35,230,19,77,21,45,12,253,30,215,44,29,45,67,238,15,116,96,32,224,86,171,65,129,96,81,78,253,155,164,143,172,7,151,156,105,39,233,229,237,29,71,181,65,1,184,17,159,65,195,21,86,102,160,167,65,208,245,207,124,70,79,26,22,7,47,8,102,30,20,6,199,229,190,49,38,185,234,117,241,211,51,138,6,65,183,41,19,205,20,65,227,71,25,186,182,79,10,63,21,36,41,92,237,178,110,16,33,217,244,119,0,183,244,118,231,226,67,10,114,202,26,75,75,152,117,138,247,69,241,57,0,94,194,209,37,232,60,236,76,112,85,152,75,200,6,167,175,151,161,238,224,41,125,82,191,223,236,13,132,19,9,119,3,79,23,118,164,70,51,34,125,185,100,74,170,146,137,10,230,144,67,1,67,115,24,19,18,109,111,50,224,213,135,75,8,224,182,20,46,36,11,177,180,97,5,226,196,22,127,223,84,162,243,12,49,67,117,12,252,199,206,45,77,179,229,120,213,137,164,96,42,152,60,157,17,231,62,74,39,221,188,231,105,107,239,129,205,165,179,105,84,85,36,58,233,135,206,71,145,94,109,91,175,153,91,122,74,117,84,46,140,26,11,144,6,81,168,22,81,52,199,139,180,232,69,148,121,135,226,90,54,154,16,28,98,12,156,74,36,203,247,163,35,126,120,79,227,118,6,171,149,237,125,48,132,191,134,207,104,38,50,105,173,130,54,136,162,4,229,86,152,237,236,18,41,60,63,138,47,90,205,49,211,216,181,43,103,202,20,140,136,241,106,244,210,16,143,97,240,44,28,125,169,215,243,78,19,180,66,68,216,229,201,160,18,197,48,38,254,115,51,195,11,93,157,42,103,4,17,23,92,16,75,24,208,219,143,5,171,242,199,161,249,173,29,120,147,181,27,171,118,153,255,64,74,98,9,97,96,216,165,98,125,63,137,248,200,115,143,78,12,25,55,69,215,181,61,225,37,51,162,4,176,36,55,96,104,121,84,85,208,150,76,188,103,201,106,137,162,205,94,228,27,102,117,203,70,219,104,163,79,43,8,1,63,83,148,47,149,172,37,234,147,233,109,31,165,19,243,220,46,18,45,88,247,244,111,206,231,62,121,247,203,129,178,241,194,125,211,183,77,238,213,20,113,210,64,212,70,218,161,136,53,84,132,235,208,137,140,53,13,169,228,106,57,25,90,84,117,92,158,64,117,225,141,17,228,84,43,85,91,132,55,179,182,97,1,218,50,46,211,223,35,94,138,200,75,31,38,85,8,0,43,222,221,73,126,230,191,207,20,241,62,164,149,55,248,101,229,13,116,203,229,126,165,141,222,47,205,76,198,87,55,12,42,58,229,97,8,188,105,240,110,8,112,126,136,62,1,196,136,187,139,138,23,128,202,44,49,21,97,45,21,184,202,172,14,47,122,21,62,219,210,6,138,149,131,5,88,79,201,98,182,171,86,211,37,119,248,240,69,185,42,133,31,58,209,86,63,48,155,30,140,28,44,30,76,17,132,35,10,243,226,230,209,107,63,49,38,99,232,83,110,231,164,118,131,28,154,237,156,12,109,237,172,48,174,41,71,210,25,129,241,195,214,211,33,246,194,170,151,227,182,230,115,17,170,152,201,116,125,27,222,117,42,177,91,117,8,108,233,181,214,172,55,219,151,21,96,208,152,81,182,162,214,170,73,253,110,185,31,168,113,147,14,152,75,56,105,158,22,85,35,45,158,237,230,16,17,139,202,14,59,127,198,127,160,102,119,11,176,213,155,132,179,40,75,196,6,149,224,113,26,168,46,85,144,218,133,221,144,255,82,129,183,61,161,177,134,121,28,235,105,53,157,255,244,145,116,223,70,84,21,183,28,188,3,229,231,202,243,217,44,145,130,179,49,219,49,56,32,73,230,200,153,240,147,69,56,183,217,242,132,218,113,13,145,6,151,37,166,140,159,38,171,226,185,207,176,239,222,194,170,129,192,247,171,200,193,157,129,25,78,158,186,44,140,149,177,59,127,77,160,29,136,185,65,85,159,213,198,252,241,132,74,204,80,236,177,112,106,220,128,88,164,53,154,40,173,169,52,103,122,212,248,196,190,40,252,73,78,242,31,250,133,159,35,83,122,142,41,148,164,244,21,204,98,163,65,244,91,184,90,253,189,47,175,61,135,22,253,193,128,86,20,148,178,251,81,42,183,126,228,15,253,213,153,255,235,113,243,68,102,65,168,62,65,60,214,41,203,34,87,49,151,144,246,31,72,191,25,163,223,162,34,5,199,132,110,54,146,239,227,202,235,170,37,124,106,55,132,47,11,252,140,128,127,119,245,92,3,219,31,162,147,195,200,72,224,26,19,12,33,103,231,58,193,176,14,207,2,76,232,97,238,153,46,231,208,109,105,137,250,51,63,61,243,135,253,188,56,233,88,180,26,91,129,10,149,121,211,242,42,195,61,106,137,157,206,107,229,226,22,170,216,9,212,13,207,88,212,102,43,53,245,247,151,62,97,240,53,30,227,210,23,102,224,80,215,73,19,10,41,159,203,33,166,100,253,170,221,52,12,199,231,0,119,214,31,69,253,249,157,48,167,189,91,82,114,110,93,20,244,108,148,115,134,64,9,207,109,225,211,185,255,195,42,109,75,96,109,11,92,185,45,252,73,232,87,5,194,60,10,229,141,20,224,115,51,13,4,40,8,123,36,107,253,255,106,40,163,69,42,24,201,230,255,120,24,48,2,41,108,127,42,5,62,222,115,6,218,244,72,167,224,231,205,125,240,133,232,57,26,89,189,92,42,169,85,112,102,130,251,109,167,155,250,66,38,26,196,161,25,42,216,114,106,168,181,104,111,238,144,230,89,158,90,118,90,173,148,169,164,187,239,91,159,84,132,46,57,186,50,90,65,248,45,168,164,110,222,238,54,193,67,98,235,236,137,39,251,21,125,121,195,22,11,136,27,59,176,108,78,99,211,12,90,69,233,172,188,88,44,73,10,64,169,18,77,37,77,105,153,65,30,192,178,193,118,180,20,167,247,229,141,116,250,229,189,153,22,176,252,96,163,211,142,160,66,206,27,134,181,18,169,93,58,39,155,25,236,2,185,15,32,226,237,218,4,186,96,143,249,20,147,251,186,243,216,114,94,55,246,48,226,142,31,111,26,186,65,147,59,71,48,1,47,131,234,1,191,35,1,193,245,148,91,245,57,49,202,117,236,48,11,35,207,24,244,84,61,195,77,234,29,192,70,240,251,1,237,141,166,239,233,21,43,116,83,223,28,90,159,107,26,173,49,94,42,220,75,121,115,114,166,121,188,95,105,28,121,166,32,255,187,156,102,83,131,91,8,220,108,106,52,130,70,82,79,107,36,28,122,133,212,63,54,242,18,98,143,81,122,233,210,71,0,33,208,117,92,19,87,61,231,137,36,77,154,212,221,161,91,31,177,114,100,191,169,5,14,188,30,159,144,84,73,46,113,45,232,127,184,111,174,32,220,46,14,76,52,112,5,192,51,245,11,217,203,159,215,180,106,151,70,173,5,135,51,120,24,162,30,82,242,191,68,243,113,39,40,252,154,118,178,50,107,255,140,40,187,72,146,11,70,185,96,152,139,166,65,252,105,113,194,228,166,8,48,180,55,197,105,79,185,168,215,202,109,136,29,132,115,12,36,213,13,210,107,186,32,146,40,250,69,231,140,17,70,91,91,14,219,140,163,187,178,214,250,204,226,223,97,164,82,62,161,71,219,253,0,155,170,54,226,43,97,97,174,45,156,7,112,76,71,76,237,127,97,202,68,115,125,40,16,66,42,10,238,33,22,104,7,29,64,68,195,61,245,85,180,0,22,146,6,253,59,230,241,174,85,16,93,17,126,158,153,157,127,43,2,174,25,143,252,134,182,103,24,213,42,119,179,168,132,13,170,125,68,93,71,135,123,218,230,92,172,151,59,227,127,71,3,73,201,226,162,216,79,49,110,250,251,145,210,33,44,142,46,16,48,6,217,5,84,193,154,60,120,226,102,138,174,249,173,174,135,3,220,19,253,219,60,197,251,231,38,136,90,99,125,38,223,178,84,173,162,79,83,24,214,106,238,186,83,53,123,147,103,33,148,142,7,151,189,167,3,84,223,105,125,148,189,65,118,168,35,71,2,21,140,237,116,17,173,238,171,46,15,159,86,177,44,98,223,208,198,231,3,90,40,227,190,14,230,124,107,152,222,247,168,55,202,161,178,26,144,106,155,119,143,194,57,27,23,64,233,161,46,206,29,180,215,212,165,89,24,152,255,149,1,201,183,201,45,59,18,114,213,42,35,247,85,28,86,182,229,18,13,183,179,27,46,129,140,191,93,88,121,44,16,74,247,154,80,129,212,220,28,19,135,235,101,187,246,132,230,157,212,26,110,116,32,56,218,198,83,225,20,137,155,93,95,234,201,210,187,163,179,125,246,212,36,175,99,131,164,219,64,190,160,164,71,107,253,31,180,131,118,45,102,237,25,235,129,152,0,11,74,80,101,20,188,180,163,18,133,119,10,204,39,203,25,243,217,205,175,239,211,249,37,168,114,139,38,146,180,220,86,212,241,218,155,30,230,218,207,105,203,190,195,195,36,201,191,60,137,147,170,74,3,247,95,29,121,195,224,101,216,212,33,134,161,139,102,24,20,19,183,40,211,39,225,173,154,63,79,140,201,95,221,221,94,12,210,175,214,239,54,174,39,108,143,137,12,192,193,146,107,37,127,25,28,35,38,145,157,223,231,45,236,192,253,209,6,78,39,6,217,139,50,43,114,124,151,134,35,218,169,36,69,1,242,147,25,1,7,250,54,121,131,105,138,160,23,76,164,214,243,218,168,146,136,73,155,25};

// The ranking tile of 128x128 pixels.
// Each pixel contains an optimized 8d key used to scramble the sequence.
// The keys are optimized for all the powers of two spp below 4in 8d.
static const int rankingTile[128*128*8] = {1,1,1,1,1,1,0,0,3,3,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,1,1,2,2,2,2,3,3,3,3,1,1,0,0,1,1,3,3,1,1,0,0,0,0,1,1,3,3,1,1,1,1,0,0,0,0,1,1,1,1,3,3,0,0,2,2,1,1,3,3,1,1,3,3,3,3,0,0,0,0,1,1,2,2,2,2,0,0,1,1,1,1,1,1,2,2,2,2,1,1,1,1,0,0,2,2,0,0,2,2,3,3,3,3,3,3,3,3,2,2,2,2,1,1,1,1,0,0,1,1,0,0,0,0,0,0,2,2,2,2,1,1,0,0,2,2,1,1,1,1,1,1,1,1,0,0,2,2,0,0,0,0,0,0,1,1,2,2,2,2,0,0,3,3,0,0,2,2,1,1,2,2,1,1,0,0,3,3,1,1,2,2,1,1,3,3,0,0,2,2,0,0,1,1,1,1,2,2,1,1,1,1,2,2,2,2,2,2,2,2,3,3,2,2,0,0,1,1,2,2,0,0,0,0,0,0,0,0,2,2,1,1,2,2,2,2,1,1,1,1,1,1,3,3,1,1,0,0,1,1,1,1,2,2,2,2,3,3,0,0,0,0,3,3,3,3,0,0,1,1,3,3,1,1,0,0,0,0,2,2,2,2,0,0,1,1,1,1,0,0,0,0,2,2,3,3,3,3,1,1,2,2,1,1,2,2,0,0,3,3,1,1,3,3,3,3,2,2,3,3,1,1,2,2,0,0,2,2,2,2,0,0,0,0,0,0,2,2,0,0,1,1,2,2,2,2,3,3,2,2,0,0,2,2,1,1,2,2,3,3,1,1,3,3,0,0,3,3,0,0,0,0,0,0,2,2,0,0,3,3,0,0,0,0,2,2,3,3,0,0,3,3,2,2,3,3,3,3,2,2,1,1,1,1,2,2,3,3,0,0,3,3,2,2,1,1,2,2,2,2,2,2,1,1,2,2,2,2,1,1,2,2,3,3,0,0,3,3,2,2,2,2,0,0,2,2,0,0,1,1,3,3,0,0,0,0,1,1,2,2,2,2,0,0,1,1,2,2,0,0,2,2,0,0,0,0,0,0,1,1,2,2,0,0,1,1,2,2,3,3,2,2,0,0,0,0,1,1,0,0,1,1,0,0,3,3,1,1,2,2,1,1,3,3,1,1,3,3,3,3,0,0,3,3,2,2,1,1,2,2,1,1,0,0,0,0,0,0,2,2,3,3,1,1,2,2,0,0,3,3,0,0,1,1,0,0,3,3,1,1,1,1,1,1,2,2,0,0,3,3,0,0,1,1,1,1,0,0,3,3,0,0,2,2,3,3,2,2,1,1,2,2,1,1,2,2,1,1,3,3,1,1,0,0,3,3,1,1,3,3,3,3,2,2,0,0,0,0,3,3,2,2,2,2,0,0,2,2,2,2,3,3,0,0,2,2,0,0,0,0,3,3,1,1,0,0,3,3,1,1,3,3,2,2,2,2,1,1,3,3,1,1,2,2,0,0,0,0,0,0,1,1,1,1,2,2,0,0,0,0,2,2,0,0,1,1,2,2,0,0,1,1,2,2,1,1,0,0,3,3,0,0,1,1,1,1,0,0,0,0,3,3,2,2,2,2,3,3,2,2,1,1,1,1,2,2,1,1,0,0,3,3,2,2,0,0,0,0,1,1,1,1,2,2,2,2,0,0,2,2,0,0,0,0,0,0,2,2,3,3,1,1,3,3,1,1,2,2,2,2,2,2,2,2,0,0,0,0,1,1,2,2,2,2,2,2,1,1,0,0,0,0,1,1,0,0,2,2,2,2,1,1,3,3,1,1,0,0,1,1,1,1,0,0,2,2,0,0,0,0,2,2,3,3,1,1,0,0,3,3,3,3,2,2,2,2,3,3,3,3,0,0,3,3,3,3,1,1,2,2,0,0,0,0,3,3,1,1,2,2,3,3,1,1,0,0,0,0,3,3,2,2,2,2,2,2,1,1,3,3,3,3,3,3,1,1,0,0,0,0,1,1,2,2,1,1,2,2,0,0,3,3,2,2,2,2,1,1,2,2,3,3,2,2,2,2,1,1,1,1,2,2,1,1,3,3,0,0,0,0,0,0,3,3,0,0,1,1,3,3,0,0,0,0,3,3,2,2,3,3,0,0,3,3,3,3,2,2,0,0,2,2,3,3,3,3,3,3,0,0,2,2,3,3,0,0,3,3,2,2,1,1,2,2,0,0,2,2,2,2,0,0,1,1,0,0,1,1,3,3,2,2,2,2,0,0,2,2,2,2,0,0,3,3,0,0,0,0,2,2,1,1,1,1,1,1,3,3,0,0,3,3,1,1,0,0,0,0,0,0,2,2,3,3,0,0,0,0,0,0,1,1,2,2,2,2,3,3,2,2,0,0,1,1,0,0,1,1,2,2,3,3,1,1,2,2,0,0,0,0,1,1,0,0,1,1,2,2,0,0,0,0,0,0,3,3,2,2,2,2,0,0,0,0,2,2,2,2,1,1,0,0,3,3,2,2,1,1,2,2,3,3,1,1,3,3,0,0,2,2,2,2,0,0,3,3,1,1,1,1,3,3,2,2,2,2,0,0,3,3,3,3,2,2,1,1,2,2,2,2,2,2,0,0,2,2,1,1,0,0,0,0,0,0,1,1,2,2,0,0,1,1,0,0,3,3,1,1,0,0,3,3,1,1,2,2,2,2,0,0,1,1,2,2,1,1,2,2,0,0,1,1,1,1,3,3,2,2,0,0,0,0,0,0,1,1,3,3,3,3,0,0,0,0,3,3,3,3,0,0,1,1,3,3,1,1,0,0,2,2,2,2,2,2,2,2,1,1,0,0,3,3,1,1,0,0,3,3,2,2,3,3,1,1,1,1,2,2,0,0,0,0,3,3,2,2,0,0,0,0,1,1,1,1,1,1,0,0,2,2,0,0,2,2,0,0,3,3,0,0,1,1,0,0,0,0,2,2,1,1,2,2,0,0,2,2,3,3,0,0,1,1,0,0,2,2,1,1,2,2,2,2,3,3,1,1,0,0,1,1,3,3,1,1,0,0,1,1,3,3,0,0,2,2,0,0,2,2,1,1,3,3,3,3,1,1,3,3,3,3,0,0,1,1,1,1,0,0,2,2,1,1,3,3,1,1,0,0,0,0,0,0,1,1,1,1,3,3,2,2,0,0,0,0,1,1,1,1,3,3,0,0,2,2,2,2,1,1,2,2,0,0,2,2,1,1,2,2,0,0,0,0,2,2,1,1,1,1,0,0,1,1,0,0,2,2,2,2,1,1,0,0,2,2,3,3,0,0,2,2,0,0,1,1,2,2,2,2,2,2,1,1,1,1,0,0,3,3,0,0,2,2,3,3,3,3,2,2,3,3,1,1,1,1,3,3,0,0,2,2,3,3,0,0,0,0,3,3,1,1,3,3,2,2,0,0,0,0,0,0,2,2,3,3,2,2,2,2,3,3,1,1,0,0,0,0,3,3,1,1,0,0,3,3,3,3,3,3,1,1,3,3,0,0,1,1,0,0,1,1,2,2,1,1,2,2,2,2,2,2,0,0,3,3,1,1,0,0,1,1,1,1,2,2,0,0,2,2,0,0,2,2,2,2,3,3,0,0,0,0,0,0,0,0,1,1,3,3,3,3,0,0,3,3,2,2,0,0,1,1,3,3,3,3,2,2,3,3,1,1,2,2,0,0,2,2,0,0,0,0,2,2,3,3,3,3,0,0,1,1,3,3,0,0,3,3,0,0,0,0,2,2,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,3,3,3,3,1,1,3,3,2,2,0,0,1,1,1,1,2,2,0,0,1,1,3,3,2,2,3,3,1,1,2,2,1,1,1,1,1,1,1,1,0,0,3,3,0,0,0,0,3,3,0,0,0,0,2,2,2,2,2,2,1,1,0,0,0,0,3,3,1,1,2,2,2,2,0,0,3,3,0,0,2,2,3,3,2,2,3,3,0,0,2,2,0,0,3,3,0,0,0,0,1,1,0,0,1,1,3,3,0,0,3,3,3,3,2,2,2,2,3,3,1,1,2,2,0,0,0,0,3,3,1,1,1,1,2,2,0,0,0,0,2,2,1,1,1,1,2,2,1,1,1,1,1,1,3,3,2,2,3,3,2,2,1,1,2,2,2,2,0,0,0,0,3,3,2,2,2,2,0,0,2,2,0,0,1,1,0,0,0,0,1,1,3,3,2,2,2,2,1,1,1,1,1,1,3,3,0,0,3,3,1,1,1,1,0,0,3,3,0,0,2,2,1,1,2,2,3,3,2,2,1,1,0,0,2,2,0,0,1,1,2,2,1,1,1,1,0,0,3,3,1,1,3,3,0,0,3,3,1,1,0,0,2,2,0,0,3,3,1,1,0,0,0,0,3,3,2,2,2,2,3,3,1,1,2,2,0,0,0,0,1,1,3,3,3,3,3,3,1,1,0,0,0,0,1,1,2,2,1,1,1,1,0,0,1,1,0,0,1,1,3,3,1,1,0,0,1,1,0,0,2,2,2,2,1,1,0,0,0,0,0,0,2,2,3,3,1,1,1,1,2,2,0,0,1,1,2,2,0,0,2,2,0,0,0,0,0,0,3,3,2,2,1,1,2,2,3,3,0,0,3,3,3,3,1,1,2,2,1,1,1,1,1,1,2,2,3,3,1,1,1,1,3,3,3,3,2,2,0,0,1,1,3,3,0,0,1,1,0,0,0,0,1,1,2,2,0,0,0,0,2,2,2,2,1,1,0,0,2,2,2,2,2,2,0,0,1,1,2,2,3,3,1,1,3,3,3,3,3,3,0,0,1,1,1,1,3,3,3,3,1,1,1,1,3,3,3,3,3,3,0,0,0,0,0,0,2,2,3,3,0,0,2,2,1,1,0,0,3,3,2,2,2,2,0,0,0,0,2,2,3,3,0,0,3,3,3,3,2,2,3,3,3,3,1,1,1,1,1,1,1,1,3,3,2,2,1,1,0,0,2,2,0,0,2,2,3,3,2,2,2,2,0,0,0,0,2,2,3,3,1,1,2,2,3,3,3,3,0,0,3,3,0,0,0,0,2,2,1,1,1,1,0,0,3,3,1,1,0,0,0,0,1,1,3,3,0,0,1,1,0,0,0,0,1,1,3,3,1,1,1,1,0,0,2,2,3,3,0,0,0,0,1,1,3,3,1,1,3,3,1,1,1,1,2,2,1,1,3,3,3,3,2,2,3,3,0,0,3,3,3,3,2,2,2,2,2,2,2,2,1,1,1,1,0,0,3,3,1,1,0,0,0,0,3,3,3,3,3,3,2,2,2,2,3,3,1,1,0,0,3,3,0,0,3,3,2,2,2,2,1,1,3,3,1,1,0,0,2,2,2,2,2,2,1,1,1,1,2,2,0,0,2,2,2,2,0,0,3,3,1,1,0,0,2,2,1,1,3,3,0,0,3,3,0,0,3,3,1,1,3,3,2,2,3,3,1,1,0,0,3,3,0,0,0,0,1,1,2,2,1,1,3,3,3,3,0,0,3,3,2,2,0,0,2,2,0,0,0,0,2,2,2,2,3,3,1,1,2,2,3,3,2,2,2,2,1,1,0,0,3,3,2,2,1,1,2,2,3,3,0,0,3,3,3,3,3,3,3,3,0,0,3,3,2,2,3,3,1,1,2,2,3,3,1,1,3,3,3,3,2,2,0,0,0,0,1,1,3,3,0,0,0,0,2,2,3,3,3,3,0,0,1,1,0,0,3,3,0,0,0,0,0,0,3,3,1,1,2,2,2,2,1,1,3,3,2,2,3,3,0,0,1,1,2,2,1,1,1,1,2,2,2,2,3,3,1,1,3,3,0,0,3,3,0,0,0,0,1,1,0,0,3,3,2,2,1,1,3,3,0,0,2,2,0,0,0,0,0,0,1,1,1,1,1,1,3,3,1,1,1,1,3,3,1,1,0,0,1,1,3,3,1,1,3,3,2,2,0,0,3,3,2,2,3,3,1,1,2,2,2,2,1,1,3,3,1,1,3,3,3,3,3,3,1,1,2,2,3,3,3,3,3,3,1,1,3,3,1,1,3,3,3,3,0,0,1,1,3,3,3,3,3,3,1,1,0,0,0,0,1,1,0,0,0,0,3,3,0,0,3,3,1,1,3,3,0,0,1,1,1,1,0,0,3,3,0,0,0,0,2,2,1,1,0,0,2,2,1,1,0,0,3,3,3,3,2,2,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,1,1,3,3,0,0,2,2,2,2,2,2,3,3,1,1,0,0,2,2,0,0,1,1,2,2,2,2,3,3,0,0,2,2,1,1,3,3,3,3,0,0,2,2,3,3,3,3,3,3,0,0,1,1,0,0,2,2,2,2,2,2,0,0,3,3,0,0,0,0,0,0,3,3,1,1,1,1,2,2,2,2,0,0,3,3,3,3,2,2,0,0,3,3,0,0,2,2,0,0,0,0,0,0,2,2,0,0,0,0,0,0,1,1,0,0,3,3,1,1,2,2,0,0,2,2,0,0,3,3,0,0,3,3,3,3,1,1,0,0,3,3,1,1,2,2,0,0,0,0,0,0,0,0,3,3,3,3,2,2,0,0,2,2,0,0,3,3,0,0,1,1,0,0,1,1,0,0,0,0,0,0,3,3,1,1,2,2,1,1,3,3,1,1,1,1,0,0,0,0,2,2,3,3,3,3,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,3,3,1,1,2,2,3,3,3,3,3,3,1,1,0,0,1,1,3,3,0,0,0,0,0,0,1,1,1,1,1,1,2,2,1,1,0,0,0,0,2,2,3,3,0,0,1,1,0,0,2,2,3,3,3,3,0,0,0,0,3,3,3,3,2,2,2,2,1,1,1,1,0,0,1,1,0,0,3,3,2,2,0,0,0,0,1,1,1,1,2,2,2,2,2,2,2,2,1,1,0,0,0,0,0,0,2,2,0,0,2,2,0,0,1,1,1,1,0,0,0,0,3,3,2,2,0,0,0,0,3,3,3,3,2,2,1,1,3,3,1,1,2,2,0,0,3,3,0,0,0,0,2,2,1,1,0,0,2,2,2,2,0,0,3,3,2,2,1,1,2,2,1,1,0,0,2,2,1,1,3,3,3,3,3,3,3,3,1,1,2,2,1,1,0,0,2,2,3,3,0,0,3,3,2,2,0,0,0,0,0,0,3,3,2,2,0,0,2,2,2,2,0,0,1,1,2,2,3,3,2,2,2,2,0,0,2,2,2,2,0,0,2,2,1,1,1,1,0,0,3,3,0,0,0,0,2,2,3,3,0,0,0,0,3,3,1,1,0,0,3,3,1,1,0,0,0,0,2,2,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,2,2,2,2,3,3,3,3,0,0,0,0,0,0,0,0,0,0,2,2,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,3,3,3,3,1,1,3,3,0,0,3,3,0,0,0,0,2,2,0,0,0,0,0,0,0,0,2,2,0,0,0,0,1,1,0,0,1,1,3,3,1,1,3,3,2,2,1,1,2,2,2,2,2,2,1,1,1,1,0,0,3,3,0,0,1,1,3,3,1,1,2,2,1,1,2,2,2,2,0,0,0,0,0,0,1,1,2,2,3,3,3,3,0,0,2,2,1,1,0,0,0,0,0,0,0,0,2,2,2,2,0,0,1,1,0,0,1,1,1,1,1,1,3,3,1,1,1,1,3,3,1,1,1,1,3,3,0,0,0,0,1,1,2,2,3,3,2,2,0,0,1,1,3,3,0,0,2,2,0,0,0,0,3,3,1,1,0,0,2,2,3,3,3,3,1,1,2,2,0,0,0,0,1,1,2,2,3,3,1,1,2,2,1,1,2,2,1,1,0,0,1,1,1,1,1,1,1,1,1,1,3,3,3,3,2,2,1,1,1,1,1,1,2,2,3,3,0,0,3,3,1,1,1,1,1,1,3,3,3,3,1,1,3,3,1,1,1,1,2,2,1,1,2,2,1,1,1,1,0,0,3,3,2,2,1,1,3,3,0,0,2,2,0,0,3,3,3,3,0,0,1,1,3,3,2,2,1,1,1,1,3,3,0,0,1,1,3,3,0,0,1,1,3,3,3,3,1,1,0,0,1,1,2,2,0,0,2,2,2,2,0,0,3,3,3,3,2,2,2,2,2,2,2,2,2,2,0,0,3,3,3,3,1,1,3,3,1,1,0,0,3,3,1,1,1,1,1,1,0,0,3,3,2,2,0,0,3,3,0,0,0,0,2,2,2,2,2,2,3,3,1,1,2,2,0,0,2,2,2,2,0,0,0,0,0,0,3,3,1,1,0,0,0,0,0,0,1,1,3,3,1,1,2,2,1,1,1,1,2,2,1,1,2,2,2,2,0,0,0,0,0,0,1,1,3,3,1,1,1,1,2,2,0,0,3,3,1,1,0,0,2,2,2,2,2,2,2,2,2,2,2,2,1,1,2,2,1,1,2,2,0,0,1,1,3,3,1,1,0,0,1,1,0,0,0,0,3,3,1,1,1,1,0,0,2,2,0,0,3,3,2,2,2,2,0,0,3,3,1,1,1,1,0,0,3,3,0,0,3,3,2,2,3,3,1,1,0,0,2,2,0,0,3,3,1,1,3,3,0,0,2,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,1,1,1,1,3,3,2,2,3,3,2,2,2,2,1,1,0,0,3,3,3,3,2,2,3,3,0,0,3,3,3,3,2,2,1,1,2,2,1,1,1,1,0,0,3,3,2,2,2,2,1,1,2,2,2,2,1,1,2,2,2,2,3,3,3,3,0,0,0,0,3,3,0,0,0,0,1,1,2,2,2,2,3,3,1,1,3,3,2,2,0,0,2,2,0,0,1,1,0,0,1,1,3,3,0,0,2,2,1,1,3,3,0,0,0,0,0,0,0,0,3,3,2,2,0,0,0,0,0,0,3,3,3,3,1,1,0,0,2,2,0,0,2,2,0,0,2,2,1,1,1,1,1,1,3,3,0,0,2,2,1,1,3,3,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,2,2,3,3,3,3,1,1,0,0,2,2,3,3,2,2,2,2,0,0,3,3,0,0,0,0,0,0,2,2,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,3,3,3,3,2,2,0,0,0,0,1,1,0,0,3,3,0,0,1,1,2,2,0,0,0,0,2,2,1,1,2,2,1,1,3,3,0,0,2,2,3,3,3,3,3,3,3,3,0,0,1,1,3,3,2,2,3,3,2,2,2,2,1,1,1,1,0,0,0,0,0,0,2,2,1,1,0,0,0,0,3,3,2,2,1,1,0,0,0,0,1,1,3,3,1,1,0,0,0,0,1,1,3,3,0,0,2,2,0,0,1,1,3,3,2,2,1,1,2,2,2,2,3,3,1,1,3,3,1,1,2,2,1,1,0,0,3,3,0,0,1,1,0,0,1,1,2,2,0,0,3,3,2,2,1,1,0,0,0,0,2,2,3,3,1,1,3,3,1,1,0,0,0,0,2,2,1,1,3,3,1,1,1,1,0,0,0,0,1,1,1,1,0,0,3,3,0,0,2,2,2,2,3,3,3,3,1,1,0,0,3,3,1,1,2,2,1,1,2,2,3,3,0,0,3,3,0,0,3,3,1,1,0,0,0,0,3,3,2,2,3,3,0,0,2,2,0,0,1,1,3,3,1,1,3,3,1,1,0,0,3,3,3,3,1,1,1,1,1,1,2,2,0,0,3,3,2,2,2,2,1,1,1,1,2,2,0,0,2,2,3,3,0,0,3,3,1,1,1,1,0,0,2,2,0,0,2,2,2,2,0,0,0,0,0,0,3,3,1,1,0,0,3,3,0,0,3,3,0,0,1,1,1,1,2,2,2,2,3,3,2,2,2,2,3,3,0,0,1,1,3,3,2,2,0,0,1,1,2,2,2,2,1,1,3,3,3,3,1,1,0,0,1,1,2,2,3,3,0,0,1,1,1,1,2,2,2,2,1,1,2,2,0,0,0,0,0,0,2,2,1,1,1,1,0,0,2,2,0,0,1,1,1,1,1,1,0,0,3,3,2,2,0,0,3,3,2,2,2,2,1,1,0,0,3,3,0,0,2,2,3,3,2,2,3,3,0,0,3,3,0,0,1,1,1,1,3,3,3,3,2,2,1,1,3,3,2,2,2,2,0,0,2,2,0,0,0,0,2,2,1,1,2,2,1,1,2,2,3,3,0,0,0,0,1,1,2,2,0,0,0,0,1,1,1,1,0,0,0,0,2,2,3,3,0,0,3,3,0,0,2,2,2,2,1,1,1,1,1,1,0,0,3,3,2,2,1,1,3,3,0,0,2,2,1,1,3,3,3,3,0,0,0,0,2,2,1,1,3,3,3,3,3,3,2,2,1,1,2,2,0,0,1,1,3,3,2,2,2,2,2,2,0,0,1,1,0,0,3,3,3,3,0,0,1,1,1,1,0,0,0,0,0,0,2,2,1,1,1,1,3,3,1,1,3,3,3,3,1,1,1,1,2,2,2,2,1,1,1,1,0,0,2,2,0,0,0,0,3,3,2,2,3,3,3,3,1,1,0,0,3,3,1,1,0,0,3,3,0,0,1,1,3,3,3,3,3,3,1,1,0,0,1,1,3,3,1,1,2,2,1,1,0,0,2,2,2,2,0,0,2,2,1,1,2,2,1,1,2,2,0,0,3,3,0,0,1,1,1,1,2,2,3,3,2,2,1,1,3,3,2,2,3,3,2,2,2,2,2,2,1,1,0,0,3,3,2,2,3,3,2,2,1,1,0,0,1,1,3,3,2,2,0,0,0,0,3,3,2,2,0,0,2,2,1,1,1,1,3,3,2,2,2,2,3,3,2,2,2,2,0,0,1,1,3,3,2,2,2,2,3,3,2,2,2,2,3,3,2,2,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,2,2,1,1,1,1,0,0,2,2,1,1,1,1,1,1,2,2,1,1,2,2,1,1,3,3,3,3,0,0,1,1,0,0,0,0,2,2,3,3,3,3,1,1,3,3,1,1,1,1,2,2,3,3,0,0,0,0,0,0,3,3,0,0,2,2,1,1,0,0,3,3,2,2,0,0,0,0,3,3,2,2,0,0,3,3,2,2,0,0,0,0,2,2,2,2,2,2,2,2,2,2,1,1,3,3,0,0,3,3,1,1,1,1,2,2,0,0,2,2,0,0,3,3,3,3,3,3,2,2,3,3,1,1,3,3,1,1,3,3,0,0,1,1,2,2,0,0,3,3,0,0,2,2,3,3,3,3,1,1,2,2,0,0,1,1,2,2,1,1,0,0,0,0,0,0,3,3,0,0,3,3,2,2,0,0,3,3,3,3,1,1,2,2,0,0,3,3,1,1,3,3,0,0,2,2,1,1,1,1,0,0,2,2,2,2,1,1,1,1,1,1,3,3,1,1,1,1,2,2,2,2,0,0,3,3,2,2,3,3,2,2,3,3,3,3,0,0,2,2,0,0,3,3,0,0,3,3,0,0,2,2,3,3,1,1,3,3,3,3,0,0,1,1,2,2,1,1,3,3,2,2,0,0,2,2,3,3,0,0,1,1,1,1,1,1,2,2,0,0,3,3,2,2,1,1,0,0,3,3,3,3,2,2,0,0,1,1,0,0,2,2,3,3,1,1,2,2,0,0,3,3,0,0,0,0,0,0,1,1,2,2,1,1,1,1,1,1,3,3,2,2,3,3,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,3,3,1,1,2,2,0,0,3,3,3,3,3,3,1,1,3,3,2,2,1,1,1,1,1,1,2,2,2,2,2,2,3,3,1,1,1,1,1,1,2,2,0,0,3,3,3,3,1,1,0,0,2,2,2,2,1,1,0,0,0,0,0,0,2,2,0,0,3,3,3,3,0,0,0,0,3,3,3,3,3,3,2,2,3,3,3,3,1,1,1,1,1,1,3,3,1,1,2,2,0,0,2,2,0,0,1,1,2,2,3,3,2,2,0,0,0,0,3,3,1,1,1,1,2,2,0,0,1,1,1,1,0,0,0,0,0,0,2,2,2,2,0,0,1,1,0,0,1,1,0,0,3,3,3,3,3,3,3,3,2,2,0,0,1,1,0,0,0,0,2,2,3,3,0,0,0,0,0,0,1,1,3,3,0,0,3,3,1,1,2,2,1,1,0,0,1,1,0,0,1,1,2,2,1,1,3,3,1,1,0,0,2,2,0,0,3,3,3,3,1,1,1,1,2,2,0,0,2,2,0,0,1,1,0,0,2,2,3,3,0,0,1,1,3,3,1,1,3,3,0,0,1,1,2,2,0,0,2,2,0,0,2,2,3,3,3,3,2,2,1,1,3,3,2,2,0,0,0,0,2,2,3,3,1,1,1,1,1,1,2,2,1,1,0,0,2,2,0,0,3,3,3,3,3,3,2,2,3,3,1,1,3,3,0,0,0,0,3,3,0,0,0,0,1,1,0,0,1,1,0,0,2,2,0,0,0,0,2,2,0,0,1,1,1,1,2,2,3,3,1,1,3,3,0,0,2,2,3,3,2,2,0,0,2,2,3,3,1,1,2,2,0,0,3,3,2,2,0,0,3,3,2,2,3,3,2,2,2,2,1,1,3,3,0,0,2,2,0,0,3,3,0,0,2,2,2,2,1,1,0,0,3,3,3,3,2,2,1,1,0,0,0,0,1,1,2,2,0,0,0,0,2,2,0,0,1,1,2,2,3,3,3,3,0,0,2,2,3,3,0,0,3,3,0,0,2,2,1,1,1,1,3,3,2,2,2,2,3,3,3,3,2,2,3,3,0,0,3,3,1,1,1,1,2,2,3,3,0,0,2,2,1,1,3,3,0,0,2,2,2,2,1,1,1,1,3,3,1,1,3,3,1,1,1,1,2,2,3,3,1,1,3,3,1,1,0,0,1,1,1,1,0,0,2,2,0,0,3,3,2,2,1,1,1,1,2,2,2,2,1,1,3,3,0,0,3,3,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,1,1,0,0,0,0,3,3,0,0,0,0,0,0,2,2,3,3,0,0,3,3,1,1,3,3,3,3,2,2,3,3,2,2,2,2,2,2,0,0,3,3,1,1,0,0,1,1,1,1,3,3,2,2,0,0,1,1,3,3,1,1,0,0,1,1,1,1,2,2,2,2,2,2,3,3,3,3,1,1,2,2,2,2,0,0,1,1,3,3,2,2,3,3,0,0,0,0,0,0,2,2,2,2,2,2,3,3,1,1,2,2,1,1,3,3,2,2,3,3,2,2,3,3,3,3,0,0,0,0,1,1,2,2,3,3,1,1,1,1,3,3,3,3,0,0,3,3,0,0,1,1,1,1,0,0,1,1,3,3,2,2,0,0,3,3,1,1,0,0,0,0,1,1,3,3,2,2,0,0,2,2,3,3,1,1,0,0,3,3,3,3,3,3,1,1,1,1,0,0,1,1,1,1,1,1,2,2,3,3,3,3,2,2,2,2,0,0,1,1,3,3,0,0,2,2,2,2,1,1,2,2,3,3,0,0,2,2,0,0,2,2,1,1,2,2,3,3,0,0,0,0,0,0,3,3,0,0,1,1,2,2,3,3,2,2,3,3,0,0,1,1,2,2,3,3,3,3,0,0,0,0,0,0,2,2,1,1,2,2,2,2,0,0,0,0,1,1,1,1,1,1,0,0,2,2,0,0,1,1,2,2,2,2,2,2,3,3,3,3,2,2,2,2,2,2,0,0,2,2,3,3,0,0,1,1,3,3,1,1,2,2,2,2,0,0,1,1,2,2,3,3,1,1,3,3,0,0,0,0,1,1,2,2,1,1,3,3,0,0,2,2,0,0,1,1,0,0,1,1,2,2,1,1,1,1,2,2,3,3,2,2,2,2,2,2,1,1,0,0,1,1,0,0,1,1,3,3,2,2,3,3,1,1,1,1,1,1,0,0,2,2,3,3,0,0,3,3,0,0,1,1,0,0,0,0,0,0,1,1,0,0,3,3,2,2,1,1,0,0,1,1,0,0,1,1,2,2,0,0,1,1,3,3,2,2,3,3,3,3,1,1,2,2,0,0,0,0,0,0,1,1,0,0,2,2,3,3,2,2,0,0,1,1,1,1,3,3,0,0,0,0,0,0,2,2,0,0,2,2,0,0,2,2,3,3,0,0,3,3,1,1,3,3,0,0,2,2,1,1,0,0,0,0,0,0,0,0,1,1,3,3,2,2,0,0,3,3,0,0,0,0,1,1,3,3,0,0,0,0,3,3,0,0,2,2,1,1,0,0,1,1,1,1,1,1,3,3,0,0,1,1,0,0,1,1,0,0,0,0,2,2,3,3,1,1,0,0,1,1,0,0,2,2,1,1,1,1,0,0,0,0,0,0,0,0,2,2,3,3,3,3,3,3,1,1,3,3,2,2,2,2,3,3,3,3,0,0,0,0,0,0,3,3,1,1,1,1,0,0,1,1,3,3,3,3,0,0,1,1,3,3,2,2,3,3,2,2,2,2,1,1,3,3,2,2,0,0,2,2,1,1,0,0,3,3,3,3,2,2,1,1,0,0,2,2,3,3,2,2,0,0,1,1,0,0,0,0,2,2,2,2,1,1,1,1,2,2,3,3,3,3,2,2,2,2,1,1,1,1,1,1,3,3,2,2,3,3,0,0,2,2,3,3,3,3,1,1,0,0,1,1,2,2,0,0,3,3,0,0,2,2,1,1,2,2,2,2,3,3,1,1,3,3,3,3,2,2,3,3,1,1,2,2,1,1,1,1,0,0,1,1,0,0,2,2,0,0,1,1,2,2,1,1,2,2,0,0,3,3,2,2,3,3,0,0,1,1,2,2,2,2,1,1,3,3,3,3,0,0,2,2,0,0,1,1,2,2,2,2,1,1,1,1,0,0,1,1,1,1,2,2,3,3,2,2,2,2,0,0,3,3,0,0,0,0,2,2,3,3,3,3,1,1,2,2,2,2,1,1,3,3,2,2,0,0,3,3,0,0,2,2,2,2,0,0,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,0,0,1,1,1,1,3,3,3,3,3,3,3,3,0,0,1,1,2,2,0,0,2,2,0,0,0,0,0,0,2,2,0,0,2,2,0,0,2,2,2,2,2,2,2,2,0,0,1,1,0,0,0,0,2,2,3,3,0,0,1,1,0,0,2,2,1,1,2,2,2,2,1,1,3,3,3,3,0,0,0,0,1,1,0,0,1,1,1,1,0,0,2,2,1,1,2,2,0,0,2,2,1,1,0,0,2,2,3,3,0,0,2,2,0,0,2,2,0,0,2,2,1,1,1,1,1,1,2,2,1,1,1,1,0,0,2,2,3,3,1,1,2,2,1,1,1,1,3,3,2,2,1,1,3,3,3,3,0,0,3,3,0,0,3,3,3,3,2,2,1,1,3,3,3,3,3,3,0,0,0,0,2,2,3,3,0,0,2,2,1,1,0,0,1,1,0,0,0,0,3,3,0,0,2,2,3,3,3,3,3,3,2,2,1,1,0,0,3,3,1,1,3,3,1,1,1,1,3,3,2,2,0,0,2,2,2,2,2,2,0,0,1,1,3,3,2,2,2,2,2,2,2,2,0,0,2,2,1,1,2,2,0,0,2,2,1,1,1,1,1,1,2,2,1,1,0,0,3,3,1,1,1,1,3,3,3,3,2,2,0,0,2,2,1,1,1,1,0,0,2,2,0,0,2,2,0,0,3,3,1,1,2,2,3,3,0,0,0,0,1,1,2,2,3,3,0,0,1,1,0,0,3,3,1,1,2,2,0,0,3,3,0,0,2,2,0,0,1,1,3,3,3,3,3,3,3,3,0,0,2,2,0,0,2,2,2,2,1,1,0,0,1,1,1,1,3,3,0,0,1,1,3,3,1,1,1,1,1,1,0,0,2,2,3,3,1,1,3,3,3,3,1,1,0,0,0,0,1,1,3,3,1,1,1,1,3,3,1,1,3,3,1,1,3,3,3,3,3,3,0,0,0,0,2,2,3,3,1,1,0,0,1,1,3,3,1,1,0,0,3,3,2,2,1,1,2,2,1,1,2,2,1,1,3,3,0,0,1,1,0,0,1,1,2,2,3,3,0,0,1,1,1,1,1,1,0,0,3,3,2,2,3,3,1,1,1,1,2,2,3,3,3,3,3,3,0,0,3,3,1,1,2,2,2,2,1,1,0,0,3,3,1,1,1,1,0,0,2,2,1,1,3,3,3,3,3,3,1,1,2,2,0,0,2,2,2,2,3,3,1,1,2,2,2,2,3,3,0,0,2,2,3,3,2,2,2,2,2,2,0,0,3,3,3,3,2,2,1,1,1,1,1,1,2,2,1,1,1,1,3,3,0,0,1,1,3,3,0,0,1,1,0,0,2,2,0,0,3,3,3,3,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,2,2,2,2,0,0,2,2,3,3,1,1,3,3,1,1,0,0,1,1,3,3,1,1,0,0,0,0,3,3,0,0,0,0,1,1,1,1,2,2,0,0,0,0,2,2,0,0,1,1,0,0,3,3,1,1,0,0,2,2,1,1,3,3,2,2,0,0,0,0,1,1,2,2,3,3,0,0,1,1,3,3,1,1,2,2,2,2,3,3,1,1,2,2,1,1,1,1,3,3,3,3,0,0,1,1,3,3,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,3,3,3,3,2,2,1,1,0,0,2,2,1,1,1,1,0,0,3,3,2,2,0,0,0,0,3,3,2,2,0,0,0,0,2,2,0,0,1,1,3,3,1,1,0,0,0,0,3,3,3,3,0,0,0,0,2,2,1,1,0,0,2,2,0,0,2,2,3,3,2,2,1,1,2,2,2,2,3,3,0,0,0,0,3,3,3,3,2,2,2,2,2,2,3,3,0,0,3,3,3,3,2,2,1,1,1,1,2,2,3,3,3,3,3,3,2,2,3,3,3,3,0,0,1,1,0,0,2,2,3,3,0,0,2,2,0,0,2,2,2,2,3,3,2,2,1,1,3,3,1,1,2,2,0,0,3,3,1,1,3,3,1,1,2,2,0,0,0,0,1,1,3,3,2,2,1,1,0,0,1,1,2,2,2,2,1,1,0,0,2,2,3,3,3,3,1,1,2,2,1,1,0,0,0,0,0,0,2,2,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,3,3,1,1,0,0,0,0,2,2,0,0,1,1,2,2,2,2,0,0,1,1,0,0,0,0,3,3,0,0,3,3,1,1,2,2,0,0,0,0,2,2,3,3,0,0,0,0,0,0,2,2,0,0,2,2,1,1,0,0,0,0,2,2,0,0,2,2,3,3,0,0,0,0,3,3,2,2,0,0,1,1,1,1,1,1,2,2,3,3,0,0,3,3,0,0,1,1,3,3,0,0,0,0,3,3,2,2,1,1,2,2,1,1,3,3,1,1,1,1,0,0,2,2,1,1,1,1,0,0,3,3,3,3,2,2,2,2,2,2,3,3,0,0,0,0,1,1,0,0,2,2,2,2,3,3,0,0,0,0,0,0,3,3,0,0,3,3,0,0,0,0,0,0,0,0,2,2,3,3,1,1,3,3,2,2,3,3,1,1,1,1,1,1,2,2,0,0,0,0,2,2,2,2,2,2,3,3,0,0,2,2,1,1,2,2,1,1,0,0,3,3,3,3,1,1,1,1,1,1,2,2,2,2,0,0,0,0,3,3,0,0,3,3,0,0,0,0,0,0,1,1,2,2,2,2,2,2,2,2,1,1,3,3,2,2,2,2,1,1,3,3,2,2,2,2,3,3,3,3,3,3,3,3,1,1,1,1,3,3,2,2,0,0,0,0,2,2,0,0,0,0,3,3,2,2,2,2,2,2,1,1,2,2,3,3,0,0,1,1,3,3,0,0,3,3,0,0,1,1,0,0,2,2,3,3,2,2,3,3,1,1,0,0,1,1,0,0,2,2,0,0,3,3,3,3,1,1,0,0,0,0,0,0,2,2,3,3,1,1,1,1,3,3,0,0,1,1,1,1,0,0,0,0,0,0,3,3,3,3,1,1,3,3,0,0,1,1,1,1,2,2,0,0,1,1,3,3,0,0,1,1,2,2,1,1,3,3,1,1,1,1,3,3,1,1,1,1,2,2,0,0,3,3,2,2,0,0,1,1,0,0,0,0,2,2,1,1,0,0,1,1,0,0,3,3,1,1,1,1,0,0,2,2,3,3,1,1,3,3,1,1,0,0,3,3,3,3,2,2,2,2,2,2,1,1,2,2,0,0,1,1,2,2,2,2,1,1,0,0,0,0,3,3,0,0,1,1,1,1,1,1,1,1,3,3,0,0,3,3,0,0,1,1,2,2,0,0,0,0,1,1,3,3,0,0,2,2,1,1,0,0,1,1,0,0,1,1,1,1,3,3,0,0,1,1,0,0,1,1,2,2,3,3,1,1,1,1,1,1,0,0,2,2,0,0,3,3,0,0,2,2,0,0,0,0,3,3,2,2,2,2,1,1,0,0,1,1,1,1,3,3,2,2,2,2,0,0,2,2,0,0,0,0,0,0,0,0,3,3,3,3,0,0,2,2,0,0,0,0,0,0,2,2,3,3,1,1,2,2,2,2,2,2,3,3,2,2,3,3,1,1,0,0,1,1,2,2,1,1,2,2,0,0,1,1,2,2,0,0,0,0,0,0,0,0,1,1,1,1,2,2,0,0,3,3,2,2,1,1,1,1,1,1,3,3,1,1,2,2,3,3,3,3,1,1,1,1,0,0,0,0,1,1,2,2,1,1,3,3,0,0,0,0,1,1,0,0,1,1,2,2,0,0,3,3,3,3,2,2,3,3,0,0,2,2,2,2,0,0,2,2,0,0,3,3,0,0,1,1,3,3,3,3,0,0,3,3,1,1,2,2,1,1,3,3,0,0,2,2,1,1,1,1,0,0,2,2,1,1,1,1,0,0,2,2,1,1,1,1,1,1,0,0,0,0,3,3,2,2,2,2,0,0,3,3,2,2,1,1,2,2,3,3,0,0,2,2,2,2,2,2,0,0,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,0,0,1,1,0,0,1,1,2,2,3,3,0,0,2,2,1,1,0,0,0,0,3,3,1,1,3,3,0,0,1,1,2,2,1,1,0,0,1,1,2,2,1,1,2,2,0,0,1,1,0,0,1,1,0,0,1,1,0,0,3,3,3,3,1,1,0,0,1,1,0,0,3,3,3,3,2,2,2,2,2,2,1,1,2,2,2,2,0,0,3,3,0,0,3,3,3,3,0,0,0,0,3,3,2,2,2,2,3,3,3,3,0,0,0,0,3,3,2,2,0,0,0,0,1,1,3,3,0,0,2,2,3,3,2,2,0,0,0,0,2,2,0,0,1,1,0,0,0,0,3,3,3,3,2,2,1,1,0,0,0,0,2,2,3,3,0,0,0,0,0,0,2,2,1,1,3,3,2,2,3,3,3,3,3,3,0,0,1,1,1,1,0,0,1,1,0,0,2,2,0,0,1,1,0,0,3,3,1,1,3,3,0,0,3,3,0,0,0,0,1,1,0,0,2,2,0,0,2,2,0,0,1,1,3,3,3,3,3,3,2,2,0,0,3,3,1,1,3,3,1,1,0,0,0,0,0,0,2,2,2,2,2,2,1,1,2,2,1,1,3,3,1,1,2,2,1,1,0,0,1,1,3,3,0,0,0,0,1,1,2,2,0,0,0,0,0,0,1,1,3,3,3,3,3,3,2,2,0,0,0,0,1,1,3,3,0,0,2,2,0,0,1,1,1,1,0,0,0,0,2,2,3,3,2,2,3,3,2,2,0,0,0,0,1,1,3,3,1,1,3,3,3,3,2,2,1,1,0,0,0,0,3,3,0,0,3,3,0,0,1,1,3,3,0,0,0,0,0,0,0,0,2,2,2,2,3,3,3,3,0,0,3,3,2,2,0,0,2,2,2,2,0,0,1,1,3,3,2,2,3,3,0,0,3,3,0,0,3,3,3,3,1,1,0,0,2,2,3,3,3,3,3,3,0,0,3,3,2,2,1,1,1,1,3,3,2,2,2,2,2,2,2,2,2,2,3,3,1,1,3,3,1,1,0,0,0,0,3,3,0,0,2,2,3,3,2,2,3,3,2,2,1,1,3,3,3,3,0,0,1,1,2,2,3,3,1,1,1,1,3,3,0,0,2,2,0,0,3,3,2,2,2,2,3,3,1,1,3,3,0,0,1,1,2,2,1,1,1,1,1,1,1,1,3,3,0,0,3,3,0,0,2,2,2,2,2,2,3,3,1,1,2,2,3,3,2,2,2,2,0,0,0,0,1,1,3,3,2,2,1,1,2,2,0,0,2,2,0,0,0,0,0,0,2,2,3,3,0,0,2,2,0,0,0,0,0,0,1,1,1,1,3,3,1,1,2,2,2,2,1,1,0,0,3,3,0,0,0,0,2,2,0,0,3,3,0,0,1,1,3,3,0,0,3,3,2,2,1,1,1,1,3,3,2,2,0,0,1,1,0,0,0,0,3,3,0,0,0,0,1,1,0,0,1,1,3,3,3,3,1,1,0,0,1,1,2,2,3,3,0,0,2,2,0,0,2,2,2,2,3,3,1,1,0,0,2,2,3,3,0,0,1,1,3,3,3,3,1,1,3,3,0,0,0,0,0,0,3,3,1,1,3,3,1,1,0,0,1,1,2,2,0,0,0,0,0,0,3,3,1,1,0,0,2,2,0,0,0,0,2,2,2,2,1,1,0,0,0,0,1,1,3,3,1,1,2,2,0,0,3,3,0,0,1,1,3,3,2,2,1,1,1,1,3,3,1,1,1,1,0,0,1,1,3,3,3,3,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,3,3,3,3,2,2,3,3,2,2,3,3,2,2,3,3,0,0,3,3,0,0,2,2,0,0,2,2,3,3,1,1,0,0,3,3,2,2,1,1,2,2,2,2,0,0,0,0,1,1,1,1,3,3,1,1,2,2,1,1,0,0,3,3,1,1,0,0,1,1,1,1,0,0,3,3,1,1,0,0,3,3,2,2,3,3,0,0,1,1,3,3,1,1,1,1,1,1,1,1,1,1,2,2,0,0,0,0,3,3,3,3,0,0,1,1,0,0,2,2,0,0,3,3,2,2,2,2,0,0,3,3,0,0,3,3,1,1,3,3,2,2,0,0,3,3,2,2,1,1,1,1,2,2,0,0,3,3,2,2,1,1,2,2,1,1,2,2,2,2,1,1,0,0,0,0,2,2,1,1,3,3,1,1,3,3,1,1,2,2,2,2,3,3,3,3,1,1,3,3,1,1,1,1,2,2,1,1,0,0,3,3,1,1,1,1,1,1,1,1,1,1,2,2,0,0,0,0,1,1,0,0,0,0,1,1,3,3,2,2,1,1,3,3,0,0,1,1,1,1,1,1,0,0,0,0,2,2,3,3,3,3,0,0,3,3,0,0,0,0,3,3,1,1,2,2,0,0,0,0,0,0,1,1,3,3,3,3,1,1,3,3,1,1,3,3,3,3,1,1,3,3,1,1,1,1,0,0,0,0,0,0,2,2,3,3,0,0,3,3,3,3,0,0,2,2,0,0,0,0,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,2,0,0,3,3,1,1,1,1,1,1,1,1,0,0,1,1,0,0,3,3,0,0,0,0,2,2,3,3,1,1,2,2,3,3,3,3,0,0,1,1,3,3,2,2,0,0,2,2,2,2,2,2,2,2,1,1,1,1,2,2,0,0,2,2,1,1,1,1,2,2,1,1,3,3,2,2,1,1,1,1,3,3,0,0,0,0,1,1,1,1,0,0,3,3,2,2,2,2,0,0,0,0,2,2,0,0,2,2,2,2,1,1,1,1,2,2,3,3,1,1,0,0,2,2,0,0,2,2,3,3,2,2,2,2,3,3,0,0,1,1,2,2,0,0,3,3,3,3,2,2,3,3,0,0,3,3,1,1,1,1,3,3,0,0,0,0,3,3,2,2,2,2,3,3,3,3,1,1,3,3,0,0,3,3,2,2,3,3,3,3,3,3,2,2,1,1,2,2,0,0,1,1,2,2,2,2,2,2,3,3,0,0,2,2,0,0,3,3,0,0,1,1,0,0,1,1,3,3,3,3,3,3,3,3,3,3,1,1,0,0,1,1,0,0,0,0,1,1,3,3,3,3,1,1,0,0,0,0,2,2,2,2,0,0,3,3,2,2,0,0,0,0,2,2,0,0,2,2,3,3,0,0,3,3,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,0,0,0,0,2,2,0,0,2,2,0,0,3,3,1,1,1,1,0,0,3,3,1,1,2,2,0,0,3,3,0,0,2,2,1,1,2,2,1,1,1,1,0,0,2,2,1,1,3,3,2,2,1,1,0,0,0,0,3,3,1,1,1,1,2,2,3,3,2,2,3,3,3,3,0,0,3,3,0,0,0,0,3,3,3,3,0,0,2,2,2,2,2,2,1,1,0,0,3,3,3,3,2,2,1,1,3,3,2,2,1,1,1,1,2,2,0,0,3,3,1,1,1,1,3,3,2,2,3,3,3,3,1,1,0,0,1,1,2,2,0,0,2,2,2,2,1,1,0,0,3,3,3,3,2,2,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,3,3,1,1,0,0,1,1,2,2,0,0,1,1,0,0,2,2,0,0,2,2,3,3,3,3,0,0,1,1,3,3,3,3,3,3,2,2,1,1,2,2,3,3,2,2,3,3,2,2,3,3,0,0,0,0,0,0,1,1,2,2,3,3,3,3,1,1,3,3,2,2,0,0,2,2,2,2,0,0,3,3,2,2,2,2,0,0,2,2,2,2,1,1,1,1,1,1,0,0,2,2,1,1,0,0,1,1,2,2,1,1,3,3,1,1,2,2,0,0,3,3,1,1,1,1,1,1,1,1,1,1,0,0,2,2,1,1,1,1,0,0,2,2,0,0,3,3,1,1,0,0,2,2,3,3,2,2,0,0,2,2,1,1,3,3,3,3,0,0,3,3,3,3,2,2,0,0,0,0,1,1,3,3,3,3,3,3,2,2,0,0,2,2,2,2,3,3,2,2,3,3,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,3,3,2,2,2,2,3,3,2,2,2,2,1,1,2,2,0,0,1,1,0,0,3,3,1,1,3,3,2,2,2,2,3,3,3,3,1,1,2,2,0,0,2,2,3,3,1,1,2,2,1,1,2,2,1,1,2,2,1,1,3,3,0,0,1,1,3,3,0,0,1,1,3,3,2,2,2,2,2,2,0,0,0,0,2,2,1,1,3,3,3,3,0,0,0,0,3,3,0,0,2,2,3,3,1,1,1,1,3,3,0,0,1,1,3,3,2,2,3,3,3,3,2,2,2,2,1,1,3,3,1,1,2,2,1,1,3,3,0,0,1,1,0,0,2,2,0,0,1,1,1,1,3,3,1,1,2,2,2,2,0,0,1,1,2,2,0,0,1,1,1,1,2,2,3,3,1,1,3,3,0,0,0,0,3,3,1,1,2,2,0,0,1,1,0,0,1,1,2,2,3,3,1,1,3,3,0,0,1,1,2,2,3,3,0,0,2,2,2,2,1,1,2,2,1,1,1,1,0,0,0,0,1,1,2,2,2,2,3,3,0,0,2,2,2,2,0,0,3,3,0,0,0,0,3,3,0,0,3,3,1,1,0,0,1,1,2,2,1,1,2,2,3,3,2,2,1,1,1,1,1,1,1,1,3,3,0,0,1,1,1,1,0,0,3,3,0,0,1,1,1,1,1,1,3,3,2,2,2,2,0,0,1,1,0,0,2,2,2,2,0,0,2,2,3,3,0,0,1,1,1,1,3,3,2,2,3,3,3,3,1,1,1,1,1,1,0,0,0,0,2,2,0,0,1,1,2,2,2,2,1,1,3,3,3,3,3,3,1,1,1,1,2,2,2,2,3,3,2,2,0,0,2,2,1,1,0,0,2,2,1,1,3,3,1,1,1,1,2,2,3,3,1,1,1,1,2,2,1,1,1,1,1,1,2,2,0,0,0,0,0,0,0,0,2,2,1,1,2,2,3,3,1,1,0,0,3,3,0,0,3,3,0,0,2,2,0,0,2,2,2,2,3,3,3,3,3,3,1,1,0,0,2,2,3,3,1,1,1,1,3,3,1,1,1,1,2,2,2,2,3,3,1,1,2,2,0,0,2,2,0,0,1,1,1,1,2,2,3,3,2,2,2,2,0,0,0,0,3,3,0,0,0,0,0,0,0,0,3,3,3,3,1,1,3,3,0,0,1,1,0,0,2,2,0,0,1,1,2,2,3,3,2,2,1,1,1,1,0,0,2,2,3,3,0,0,2,2,3,3,2,2,0,0,0,0,1,1,0,0,0,0,0,0,3,3,3,3,1,1,0,0,2,2,0,0,2,2,0,0,2,2,1,1,3,3,2,2,0,0,2,2,2,2,3,3,2,2,2,2,0,0,2,2,0,0,0,0,2,2,3,3,2,2,3,3,3,3,0,0,2,2,1,1,3,3,3,3,1,1,1,1,1,1,0,0,2,2,0,0,3,3,1,1,2,2,0,0,0,0,2,2,0,0,0,0,0,0,2,2,3,3,1,1,1,1,0,0,2,2,3,3,3,3,1,1,2,2,0,0,3,3,1,1,1,1,3,3,0,0,2,2,0,0,1,1,2,2,0,0,0,0,2,2,3,3,1,1,2,2,1,1,2,2,0,0,1,1,1,1,2,2,0,0,3,3,3,3,1,1,0,0,0,0,1,1,2,2,3,3,0,0,1,1,1,1,0,0,2,2,2,2,2,2,0,0,0,0,3,3,1,1,1,1,2,2,0,0,2,2,0,0,1,1,0,0,1,1,0,0,1,1,2,2,2,2,0,0,0,0,3,3,3,3,2,2,3,3,0,0,3,3,3,3,2,2,2,2,1,1,1,1,1,1,1,1,1,1,3,3,2,2,0,0,1,1,2,2,3,3,0,0,0,0,1,1,0,0,2,2,1,1,2,2,1,1,3,3,0,0,2,2,1,1,1,1,1,1,0,0,1,1,2,2,1,1,0,0,3,3,3,3,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,2,2,0,0,3,3,1,1,1,1,0,0,0,0,0,0,2,2,2,2,0,0,0,0,3,3,2,2,1,1,2,2,2,2,0,0,2,2,2,2,3,3,2,2,3,3,0,0,3,3,3,3,3,3,1,1,1,1,2,2,0,0,0,0,3,3,3,3,1,1,3,3,1,1,3,3,1,1,0,0,1,1,1,1,1,1,2,2,3,3,0,0,0,0,2,2,0,0,0,0,2,2,2,2,0,0,3,3,1,1,1,1,3,3,1,1,1,1,3,3,2,2,0,0,0,0,1,1,0,0,0,0,1,1,2,2,3,3,2,2,2,2,2,2,1,1,0,0,3,3,1,1,2,2,1,1,1,1,3,3,2,2,2,2,0,0,3,3,3,3,0,0,3,3,2,2,1,1,3,3,0,0,0,0,3,3,3,3,3,3,3,3,1,1,1,1,0,0,0,0,3,3,0,0,2,2,2,2,3,3,3,3,0,0,3,3,2,2,2,2,0,0,0,0,3,3,2,2,2,2,0,0,3,3,0,0,0,0,0,0,0,0,0,0,3,3,0,0,2,2,0,0,3,3,2,2,1,1,1,1,0,0,3,3,3,3,0,0,2,2,2,2,3,3,2,2,3,3,3,3,1,1,2,2,1,1,3,3,3,3,3,3,2,2,2,2,3,3,2,2,1,1,2,2,2,2,1,1,0,0,1,1,1,1,2,2,0,0,3,3,1,1,0,0,3,3,2,2,2,2,3,3,1,1,1,1,3,3,1,1,2,2,2,2,2,2,3,3,2,2,1,1,1,1,0,0,1,1,1,1,3,3,2,2,2,2,2,2,1,1,0,0,1,1,2,2,3,3,3,3,0,0,3,3,3,3,3,3,0,0,0,0,1,1,2,2,2,2,1,1,2,2,2,2,3,3,3,3,2,2,0,0,2,2,0,0,2,2,2,2,2,2,0,0,3,3,3,3,1,1,2,2,3,3,0,0,2,2,2,2,1,1,1,1,1,1,1,1,2,2,0,0,1,1,1,1,2,2,0,0,1,1,2,2,1,1,3,3,2,2,1,1,3,3,1,1,0,0,1,1,2,2,1,1,2,2,0,0,3,3,3,3,1,1,3,3,3,3,3,3,3,3,0,0,1,1,1,1,2,2,3,3,3,3,1,1,1,1,1,1,2,2,3,3,1,1,3,3,2,2,3,3,0,0,3,3,0,0,2,2,2,2,3,3,3,3,2,2,1,1,2,2,3,3,2,2,3,3,1,1,0,0,2,2,1,1,2,2,3,3,2,2,0,0,1,1,1,1,2,2,3,3,0,0,1,1,0,0,3,3,0,0,1,1,3,3,2,2,2,2,0,0,1,1,1,1,0,0,2,2,0,0,1,1,3,3,3,3,3,3,2,2,3,3,1,1,2,2,2,2,0,0,3,3,0,0,1,1,1,1,3,3,1,1,1,1,2,2,3,3,0,0,3,3,2,2,0,0,0,0,2,2,1,1,2,2,0,0,2,2,0,0,1,1,3,3,2,2,0,0,2,2,3,3,3,3,0,0,3,3,1,1,0,0,1,1,0,0,1,1,3,3,0,0,2,2,2,2,2,2,0,0,3,3,0,0,3,3,0,0,3,3,1,1,1,1,0,0,2,2,3,3,0,0,2,2,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,1,1,3,3,2,2,0,0,1,1,2,2,2,2,0,0,1,1,3,3,0,0,3,3,3,3,2,2,1,1,0,0,0,0,1,1,2,2,3,3,1,1,2,2,3,3,2,2,0,0,2,2,1,1,0,0,3,3,1,1,1,1,3,3,2,2,1,1,0,0,0,0,2,2,1,1,1,1,0,0,0,0,0,0,3,3,0,0,3,3,0,0,3,3,0,0,0,0,3,3,3,3,2,2,3,3,1,1,1,1,0,0,2,2,2,2,0,0,1,1,3,3,3,3,1,1,0,0,2,2,0,0,2,2,1,1,1,1,0,0,0,0,0,0,0,0,1,1,3,3,0,0,1,1,1,1,2,2,1,1,0,0,0,0,2,2,2,2,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,2,2,1,1,1,1,3,3,1,1,2,2,0,0,2,2,2,2,3,3,3,3,2,2,2,2,0,0,1,1,1,1,0,0,2,2,0,0,2,2,3,3,0,0,2,2,0,0,1,1,3,3,3,3,0,0,0,0,3,3,2,2,3,3,0,0,1,1,3,3,3,3,0,0,1,1,3,3,3,3,2,2,1,1,3,3,3,3,3,3,1,1,1,1,2,2,0,0,1,1,0,0,1,1,0,0,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,3,3,2,2,3,3,0,0,0,0,0,0,3,3,2,2,0,0,1,1,2,2,2,2,3,3,3,3,1,1,1,1,1,1,2,2,2,2,0,0,0,0,0,0,1,1,0,0,1,1,1,1,2,2,2,2,2,2,0,0,0,0,0,0,1,1,0,0,0,0,3,3,0,0,3,3,1,1,3,3,2,2,0,0,2,2,3,3,0,0,1,1,3,3,1,1,3,3,1,1,3,3,0,0,2,2,3,3,0,0,2,2,0,0,0,0,1,1,3,3,0,0,0,0,1,1,2,2,0,0,2,2,1,1,0,0,2,2,3,3,0,0,3,3,2,2,2,2,2,2,2,2,1,1,3,3,2,2,0,0,1,1,1,1,0,0,0,0,0,0,2,2,1,1,1,1,1,1,3,3,3,3,0,0,3,3,0,0,1,1,0,0,0,0,2,2,3,3,0,0,1,1,1,1,0,0,1,1,1,1,2,2,1,1,0,0,1,1,1,1,0,0,0,0,3,3,3,3,2,2,2,2,3,3,1,1,2,2,3,3,0,0,0,0,1,1,0,0,0,0,3,3,1,1,2,2,0,0,1,1,0,0,2,2,1,1,3,3,3,3,3,3,1,1,3,3,3,3,2,2,1,1,1,1,1,1,2,2,2,2,3,3,2,2,3,3,2,2,0,0,2,2,2,2,0,0,2,2,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,3,3,0,0,2,2,0,0,0,0,1,1,0,0,1,1,2,2,2,2,0,0,3,3,0,0,2,2,1,1,1,1,0,0,1,1,3,3,2,2,3,3,0,0,1,1,1,1,2,2,3,3,3,3,1,1,3,3,3,3,2,2,3,3,3,3,1,1,1,1,3,3,2,2,0,0,0,0,0,0,2,2,3,3,2,2,0,0,3,3,2,2,3,3,1,1,3,3,0,0,1,1,0,0,0,0,0,0,3,3,2,2,3,3,3,3,2,2,0,0,2,2,3,3,0,0,1,1,2,2,2,2,1,1,2,2,0,0,2,2,3,3,0,0,0,0,0,0,0,0,1,1,2,2,0,0,1,1,2,2,3,3,2,2,2,2,0,0,1,1,2,2,1,1,2,2,1,1,3,3,2,2,2,2,1,1,0,0,0,0,3,3,1,1,0,0,3,3,0,0,2,2,1,1,1,1,0,0,3,3,2,2,0,0,0,0,0,0,3,3,0,0,0,0,1,1,2,2,0,0,0,0,2,2,1,1,3,3,3,3,3,3,3,3,1,1,1,1,3,3,0,0,2,2,1,1,2,2,0,0,0,0,3,3,1,1,0,0,0,0,0,0,2,2,3,3,1,1,2,2,2,2,1,1,0,0,2,2,1,1,2,2,3,3,1,1,2,2,2,2,1,1,2,2,1,1,3,3,0,0,1,1,2,2,0,0,3,3,0,0,2,2,3,3,1,1,3,3,1,1,0,0,0,0,2,2,3,3,3,3,2,2,2,2,1,1,3,3,3,3,2,2,1,1,0,0,1,1,0,0,1,1,2,2,3,3,0,0,1,1,3,3,1,1,0,0,3,3,3,3,2,2,1,1,3,3,1,1,0,0,2,2,0,0,0,0,3,3,0,0,1,1,3,3,2,2,2,2,2,2,3,3,0,0,2,2,3,3,0,0,3,3,0,0,0,0,1,1,0,0,2,2,1,1,2,2,3,3,0,0,3,3,0,0,0,0,0,0,2,2,1,1,0,0,1,1,1,1,3,3,2,2,2,2,2,2,2,2,3,3,0,0,3,3,3,3,1,1,0,0,2,2,1,1,3,3,2,2,0,0,3,3,2,2,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,3,3,1,1,2,2,0,0,1,1,0,0,0,0,0,0,0,0,2,2,2,2,0,0,3,3,1,1,0,0,2,2,3,3,1,1,2,2,2,2,1,1,3,3,0,0,0,0,3,3,2,2,0,0,1,1,3,3,0,0,2,2,2,2,3,3,1,1,3,3,2,2,1,1,2,2,2,2,0,0,0,0,1,1,0,0,0,0,1,1,2,2,1,1,0,0,0,0,1,1,3,3,0,0,1,1,0,0,1,1,2,2,1,1,2,2,0,0,2,2,3,3,3,3,2,2,3,3,1,1,3,3,2,2,2,2,1,1,2,2,3,3,0,0,3,3,1,1,0,0,1,1,1,1,0,0,2,2,3,3,3,3,3,3,3,3,1,1,2,2,3,3,0,0,2,2,0,0,3,3,3,3,3,3,1,1,3,3,0,0,0,0,3,3,1,1,0,0,3,3,2,2,1,1,1,1,3,3,0,0,3,3,0,0,3,3,2,2,1,1,0,0,0,0,3,3,0,0,0,0,3,3,0,0,1,1,3,3,0,0,3,3,0,0,3,3,1,1,1,1,0,0,1,1,3,3,0,0,1,1,0,0,2,2,2,2,0,0,1,1,0,0,3,3,1,1,0,0,2,2,2,2,0,0,3,3,3,3,1,1,2,2,2,2,1,1,0,0,2,2,2,2,1,1,1,1,0,0,2,2,3,3,1,1,0,0,2,2,2,2,3,3,2,2,1,1,1,1,0,0,1,1,3,3,0,0,3,3,1,1,1,1,0,0,1,1,1,1,3,3,0,0,0,0,1,1,2,2,2,2,1,1,0,0,3,3,0,0,1,1,2,2,1,1,1,1,3,3,2,2,1,1,3,3,0,0,0,0,3,3,0,0,0,0,3,3,0,0,1,1,1,1,0,0,3,3,3,3,2,2,0,0,1,1,3,3,2,2,3,3,3,3,0,0,2,2,0,0,2,2,2,2,0,0,3,3,2,2,1,1,2,2,1,1,2,2,3,3,1,1,1,1,3,3,0,0,1,1,3,3,1,1,3,3,0,0,0,0,1,1,3,3,1,1,2,2,0,0,0,0,1,1,3,3,3,3,1,1,3,3,0,0,1,1,1,1,0,0,1,1,0,0,3,3,2,2,0,0,0,0,1,1,3,3,3,3,0,0,1,1,3,3,3,3,2,2,2,2,1,1,0,0,3,3,0,0,0,0,1,1,3,3,3,3,0,0,1,1,2,2,3,3,2,2,3,3,2,2,0,0,2,2,2,2,3,3,3,3,0,0,3,3,1,1,3,3,2,2,3,3,0,0,3,3,0,0,2,2,3,3,0,0,2,2,0,0,1,1,3,3,0,0,0,0,2,2,0,0,2,2,1,1,0,0,3,3,1,1,0,0,0,0,2,2,1,1,2,2,2,2,0,0,1,1,1,1,0,0,3,3,1,1,2,2,1,1,1,1,2,2,1,1,0,0,0,0,1,1,0,0,0,0,0,0,2,2,1,1,2,2,2,2,0,0,1,1,0,0,3,3,1,1,3,3,0,0,1,1,0,0,1,1,3,3,1,1,1,1,1,1,0,0,0,0,0,0,2,2,1,1,2,2,2,2,3,3,2,2,2,2,2,2,1,1,1,1,2,2,1,1,0,0,1,1,1,1,2,2,2,2,3,3,1,1,1,1,1,1,0,0,0,0,3,3,0,0,1,1,3,3,3,3,0,0,2,2,0,0,2,2,3,3,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,3,3,3,3,0,0,3,3,1,1,2,2,0,0,1,1,1,1,3,3,1,1,0,0,1,1,2,2,2,2,0,0,0,0,1,1,1,1,2,2,0,0,3,3,3,3,0,0,1,1,3,3,3,3,3,3,0,0,0,0,3,3,1,1,1,1,1,1,2,2,2,2,3,3,0,0,0,0,0,0,3,3,3,3,2,2,3,3,2,2,1,1,1,1,1,1,3,3,3,3,1,1,2,2,0,0,2,2,0,0,2,2,0,0,1,1,3,3,1,1,1,1,0,0,0,0,3,3,1,1,3,3,1,1,0,0,2,2,0,0,3,3,0,0,3,3,2,2,0,0,1,1,0,0,0,0,2,2,2,2,0,0,0,0,2,2,2,2,3,3,2,2,0,0,2,2,2,2,3,3,1,1,3,3,3,3,3,3,1,1,2,2,3,3,3,3,3,3,0,0,0,0,2,2,1,1,0,0,1,1,1,1,2,2,0,0,2,2,2,2,0,0,2,2,2,2,2,2,1,1,1,1,2,2,2,2,3,3,2,2,2,2,2,2,0,0,0,0,0,0,3,3,0,0,2,2,2,2,0,0,3,3,2,2,2,2,2,2,1,1,1,1,3,3,0,0,0,0,3,3,2,2,3,3,1,1,1,1,3,3,1,1,1,1,2,2,2,2,1,1,1,1,0,0,2,2,3,3,0,0,1,1,1,1,1,1,1,1,1,1,2,2,1,1,3,3,1,1,0,0,2,2,0,0,3,3,0,0,1,1,2,2,0,0,0,0,1,1,1,1,2,2,1,1,1,1,3,3,0,0,3,3,2,2,0,0,0,0,3,3,3,3,2,2,2,2,0,0,3,3,0,0,3,3,0,0,2,2,2,2,0,0,0,0,1,1,2,2,1,1,0,0,3,3,1,1,3,3,3,3,2,2,0,0,2,2,1,1,0,0,1,1,0,0,3,3,0,0,1,1,1,1,2,2,1,1,0,0,1,1,2,2,0,0,0,0,0,0,2,2,0,0,2,2,2,2,0,0,2,2,3,3,2,2,1,1,0,0,0,0,3,3,1,1,0,0,3,3,3,3,1,1,2,2,3,3,1,1,2,2,1,1,3,3,2,2,3,3,3,3,0,0,3,3,0,0,3,3,1,1,1,1,0,0,2,2,2,2,3,3,2,2,3,3,3,3,2,2,2,2,3,3,3,3,0,0,2,2,3,3,1,1,0,0,1,1,1,1,3,3,1,1,0,0,2,2,3,3,3,3,0,0,0,0,2,2,1,1,3,3,0,0,2,2,1,1,1,1,2,2,1,1,3,3,3,3,0,0,0,0,3,3,2,2,3,3,1,1,1,1,0,0,2,2,2,2,0,0,2,2,2,2,2,2,1,1,2,2,3,3,3,3,0,0,1,1,2,2,1,1,2,2,1,1,0,0,1,1,1,1,3,3,1,1,3,3,3,3,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,2,2,3,3,3,3,2,2,3,3,3,3,3,3,2,2,1,1,0,0,1,1,2,2,3,3,0,0,2,2,0,0,1,1,3,3,2,2,3,3,0,0,1,1,0,0,2,2,2,2,3,3,0,0,2,2,1,1,0,0,0,0,2,2,1,1,3,3,1,1,1,1,1,1,3,3,2,2,3,3,1,1,1,1,1,1,1,1,2,2,3,3,0,0,0,0,2,2,0,0,2,2,1,1,1,1,0,0,0,0,1,1,0,0,0,0,2,2,2,2,0,0,1,1,2,2,2,2,0,0,3,3,2,2,0,0,0,0,3,3,0,0,1,1,2,2,2,2,2,2,3,3,0,0,3,3,2,2,2,2,1,1,2,2,2,2,2,2,1,1,0,0,0,0,0,0,3,3,2,2,0,0,1,1,0,0,2,2,1,1,0,0,0,0,0,0,0,0,0,0,2,2,1,1,3,3,3,3,2,2,0,0,2,2,1,1,3,3,2,2,1,1,3,3,0,0,2,2,2,2,1,1,2,2,1,1,0,0,3,3,2,2,1,1,3,3,3,3,3,3,3,3,3,3,0,0,1,1,2,2,0,0,1,1,0,0,1,1,3,3,1,1,3,3,3,3,3,3,3,3,2,2,2,2,3,3,1,1,1,1,0,0,1,1,1,1,2,2,0,0,1,1,0,0,0,0,1,1,1,1,2,2,0,0,0,0,2,2,1,1,2,2,0,0,0,0,1,1,1,1,0,0,1,1,3,3,2,2,3,3,2,2,0,0,3,3,3,3,0,0,2,2,1,1,0,0,3,3,3,3,0,0,2,2,2,2,3,3,3,3,2,2,1,1,1,1,2,2,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,3,3,0,0,1,1,0,0,2,2,1,1,1,1,0,0,3,3,0,0,2,2,0,0,2,2,2,2,1,1,1,1,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,3,3,0,0,3,3,0,0,0,0,1,1,1,1,3,3,2,2,1,1,2,2,3,3,2,2,2,2,1,1,3,3,3,3,0,0,2,2,2,2,2,2,1,1,2,2,1,1,3,3,0,0,2,2,1,1,0,0,1,1,2,2,2,2,0,0,1,1,0,0,2,2,1,1,0,0,1,1,0,0,3,3,3,3,1,1,3,3,2,2,2,2,0,0,0,0,1,1,2,2,0,0,1,1,3,3,1,1,2,2,1,1,2,2,1,1,0,0,3,3,0,0,1,1,1,1,0,0,3,3,3,3,3,3,1,1,2,2,2,2,3,3,0,0,1,1,0,0,3,3,0,0,3,3,1,1,0,0,3,3,1,1,0,0,2,2,3,3,0,0,1,1,3,3,2,2,0,0,2,2,1,1,1,1,3,3,2,2,0,0,2,2,0,0,1,1,1,1,0,0,2,2,0,0,1,1,0,0,3,3,1,1,2,2,0,0,1,1,3,3,0,0,3,3,2,2,2,2,0,0,0,0,1,1,0,0,1,1,0,0,0,0,3,3,0,0,3,3,3,3,3,3,0,0,0,0,2,2,2,2,1,1,2,2,0,0,1,1,1,1,2,2,0,0,2,2,2,2,1,1,3,3,0,0,1,1,2,2,1,1,1,1,2,2,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,3,3,2,2,2,2,3,3,0,0,2,2,3,3,2,2,1,1,0,0,3,3,0,0,0,0,3,3,2,2,3,3,0,0,2,2,2,2,0,0,3,3,2,2,1,1,0,0,3,3,3,3,3,3,0,0,0,0,3,3,2,2,1,1,1,1,1,1,1,1,2,2,2,2,1,1,0,0,2,2,3,3,1,1,0,0,1,1,3,3,2,2,0,0,3,3,0,0,3,3,3,3,3,3,1,1,2,2,1,1,3,3,3,3,3,3,0,0,0,0,2,2,0,0,1,1,2,2,3,3,1,1,1,1,2,2,0,0,1,1,2,2,3,3,0,0,0,0,0,0,0,0,3,3,1,1,0,0,0,0,2,2,2,2,1,1,3,3,2,2,0,0,3,3,0,0,0,0,1,1,2,2,1,1,2,2,0,0,0,0,1,1,3,3,1,1,1,1,2,2,1,1,2,2,3,3,3,3,3,3,0,0,3,3,3,3,0,0,0,0,2,2,0,0,1,1,1,1,1,1,3,3,0,0,3,3,1,1,0,0,1,1,2,2,1,1,1,1,3,3,0,0,2,2,3,3,2,2,0,0,1,1,1,1,3,3,1,1,2,2,0,0,3,3,0,0,2,2,3,3,0,0,2,2,1,1,1,1,0,0,2,2,3,3,1,1,3,3,3,3,2,2,3,3,1,1,1,1,1,1,1,1,0,0,2,2,3,3,0,0,3,3,3,3,1,1,3,3,1,1,3,3,2,2,2,2,3,3,3,3,2,2,2,2,1,1,0,0,2,2,3,3,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,0,0,0,0,3,3,1,1,1,1,3,3,0,0,3,3,3,3,2,2,1,1,1,1,1,1,1,1,1,1,3,3,0,0,3,3,0,0,1,1,0,0,3,3,1,1,1,1,0,0,3,3,1,1,1,1,0,0,1,1,3,3,2,2,0,0,3,3,2,2,2,2,2,2,2,2,3,3,2,2,1,1,1,1,0,0,0,0,1,1,0,0,2,2,0,0,0,0,3,3,1,1,1,1,1,1,3,3,0,0,2,2,0,0,3,3,2,2,1,1,1,1,0,0,0,0,3,3,0,0,3,3,2,2,1,1,1,1,3,3,1,1,3,3,3,3,1,1,2,2,0,0,3,3,1,1,3,3,1,1,1,1,0,0,3,3,0,0,1,1,2,2,0,0,1,1,1,1,3,3,3,3,2,2,2,2,2,2,3,3,2,2,3,3,2,2,0,0,2,2,2,2,1,1,3,3,3,3,2,2,3,3,0,0,0,0,0,0,1,1,2,2,1,1,0,0,2,2,1,1,2,2,0,0,3,3,1,1,1,1,1,1,1,1,2,2,2,2,1,1,0,0,2,2,3,3,1,1,1,1,1,1,1,1,1,1,3,3,1,1,1,1,2,2,2,2,0,0,2,2,3,3,3,3,0,0,1,1,0,0,3,3,2,2,0,0,0,0,1,1,0,0,2,2,2,2,2,2,1,1,1,1,2,2,0,0,1,1,3,3,2,2,3,3,1,1,3,3,1,1,1,1,1,1,3,3,2,2,0,0,1,1,3,3,0,0,3,3,0,0,2,2,0,0,1,1,1,1,1,1,1,1,3,3,1,1,1,1,1,1,3,3,1,1,1,1,0,0,2,2,3,3,2,2,0,0,2,2,3,3,3,3,3,3,0,0,2,2,1,1,1,1,2,2,0,0,0,0,0,0,0,0,1,1,2,2,1,1,2,2,1,1,3,3,1,1,2,2,3,3,3,3,0,0,2,2,1,1,3,3,3,3,1,1,0,0,3,3,2,2,1,1,3,3,1,1,1,1,0,0,1,1,0,0,3,3,2,2,0,0,1,1,0,0,0,0,2,2,2,2,3,3,2,2,2,2,2,2,2,2,0,0,3,3,2,2,0,0,3,3,3,3,0,0,3,3,2,2,1,1,3,3,3,3,0,0,1,1,1,1,0,0,1,1,2,2,0,0,3,3,0,0,1,1,0,0,2,2,1,1,1,1,0,0,2,2,2,2,0,0,2,2,2,2,0,0,0,0,1,1,0,0,3,3,0,0,1,1,0,0,0,0,2,2,2,2,0,0,3,3,0,0,1,1,0,0,1,1,3,3,2,2,2,2,2,2,1,1,1,1,3,3,1,1,1,1,0,0,2,2,0,0,0,0,2,2,0,0,1,1,2,2,2,2,0,0,0,0,0,0,2,2,0,0,3,3,2,2,3,3,2,2,1,1,3,3,0,0,1,1,3,3,0,0,2,2,3,3,2,2,1,1,3,3,1,1,0,0,3,3,3,3,1,1,1,1,0,0,1,1,2,2,1,1,3,3,3,3,3,3,1,1,3,3,0,0,1,1,2,2,1,1,3,3,1,1,3,3,2,2,0,0,0,0,3,3,2,2,2,2,3,3,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,2,2,2,2,2,2,3,3,0,0,0,0,0,0,3,3,1,1,3,3,2,2,0,0,3,3,2,2,0,0,0,0,1,1,2,2,0,0,1,1,2,2,1,1,0,0,1,1,0,0,2,2,2,2,1,1,0,0,3,3,0,0,1,1,2,2,2,2,0,0,3,3,0,0,2,2,2,2,1,1,2,2,1,1,2,2,3,3,2,2,2,2,1,1,1,1,1,1,0,0,2,2,2,2,3,3,3,3,0,0,1,1,3,3,0,0,0,0,2,2,3,3,1,1,0,0,2,2,1,1,2,2,3,3,2,2,0,0,2,2,2,2,2,2,0,0,1,1,3,3,2,2,1,1,2,2,3,3,2,2,3,3,3,3,1,1,2,2,2,2,1,1,1,1,1,1,2,2,1,1,0,0,0,0,2,2,3,3,2,2,0,0,2,2,0,0,0,0,1,1,0,0,3,3,2,2,1,1,2,2,1,1,0,0,3,3,3,3,2,2,1,1,0,0,0,0,0,0,1,1,3,3,0,0,2,2,0,0,2,2,2,2,0,0,3,3,3,3,1,1,3,3,1,1,1,1,1,1,1,1,1,1,1,1,2,2,0,0,2,2,0,0,2,2,1,1,3,3,2,2,2,2,0,0,1,1,1,1,3,3,2,2,2,2,1,1,3,3,0,0,0,0,3,3,2,2,2,2,0,0,1,1,2,2,0,0,1,1,0,0,1,1,3,3,2,2,2,2,3,3,3,3,1,1,1,1,1,1,1,1,0,0,1,1,0,0,2,2,3,3,1,1,2,2,1,1,2,2,3,3,1,1,1,1,0,0,1,1,2,2,3,3,0,0,2,2,3,3,1,1,3,3,1,1,0,0,1,1,2,2,0,0,1,1,3,3,2,2,2,2,3,3,3,3,1,1,1,1,0,0,0,0,1,1,0,0,1,1,3,3,2,2,0,0,0,0,0,0,0,0,3,3,0,0,0,0,1,1,1,1,3,3,0,0,0,0,2,2,3,3,0,0,1,1,0,0,0,0,0,0,2,2,2,2,3,3,3,3,2,2,3,3,3,3,0,0,1,1,3,3,1,1,0,0,3,3,1,1,3,3,0,0,0,0,1,1,2,2,2,2,3,3,0,0,1,1,3,3,2,2,0,0,3,3,3,3,0,0,2,2,0,0,2,2,2,2,3,3,1,1,2,2,2,2,0,0,1,1,3,3,0,0,2,2,2,2,1,1,0,0,1,1,1,1,3,3,3,3,0,0,0,0,3,3,3,3,2,2,2,2,0,0,0,0,0,0,2,2,0,0,2,2,1,1,1,1,2,2,3,3,2,2,3,3,2,2,1,1,0,0,0,0,0,0,1,1,2,2,2,2,3,3,2,2,3,3,0,0,1,1,0,0,2,2,1,1,0,0,0,0,0,0,1,1,0,0,2,2,1,1,3,3,3,3,3,3,1,1,0,0,1,1,1,1,0,0,2,2,3,3,1,1,1,1,2,2,3,3,0,0,0,0,3,3,0,0,2,2,0,0,2,2,0,0,2,2,3,3,3,3,1,1,3,3,0,0,3,3,2,2,3,3,3,3,3,3,0,0,1,1,1,1,1,1,0,0,3,3,0,0,1,1,1,1,0,0,1,1,0,0,1,1,3,3,0,0,2,2,1,1,1,1,0,0,2,2,3,3,1,1,3,3,3,3,1,1,2,2,2,2,1,1,2,2,0,0,3,3,1,1,0,0,3,3,3,3,2,2,1,1,3,3,2,2,1,1,2,2,2,2,2,2,3,3,3,3,3,3,3,3,2,2,0,0,3,3,1,1,0,0,1,1,0,0,2,2,0,0,0,0,2,2,1,1,0,0,0,0,3,3,1,1,0,0,0,0,2,2,0,0,2,2,1,1,2,2,1,1,3,3,1,1,0,0,1,1,2,2,3,3,1,1,1,1,0,0,3,3,3,3,0,0,3,3,1,1,1,1,1,1,3,3,0,0,2,2,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,3,3,3,3,3,3,3,3,0,0,3,3,0,0,3,3,1,1,1,1,3,3,0,0,3,3,0,0,2,2,0,0,2,2,0,0,1,1,2,2,3,3,1,1,1,1,2,2,0,0,3,3,1,1,0,0,2,2,1,1,3,3,2,2,3,3,0,0,0,0,3,3,1,1,2,2,0,0,0,0,3,3,2,2,1,1,2,2,1,1,0,0,2,2,1,1,1,1,2,2,2,2,1,1,0,0,0,0,2,2,0,0,3,3,1,1,1,1,1,1,1,1,2,2,1,1,3,3,3,3,0,0,2,2,1,1,0,0,1,1,0,0,0,0,1,1,1,1,2,2,0,0,1,1,1,1,2,2,0,0,0,0,0,0,1,1,1,1,3,3,2,2,2,2,1,1,1,1,2,2,2,2,0,0,3,3,0,0,2,2,1,1,1,1,3,3,0,0,0,0,2,2,3,3,1,1,3,3,2,2,1,1,0,0,2,2,0,0,3,3,2,2,1,1,0,0,3,3,0,0,2,2,3,3,1,1,0,0,3,3,3,3,0,0,1,1,3,3,1,1,1,1,0,0,3,3,0,0,1,1,2,2,2,2,0,0,3,3,0,0,0,0,1,1,0,0,2,2,2,2,0,0,2,2,3,3,2,2,0,0,1,1,3,3,0,0,2,2,0,0,1,1,3,3,1,1,2,2,0,0,3,3,2,2,0,0,2,2,0,0,0,0,2,2,1,1,2,2,2,2,0,0,2,2,0,0,1,1,2,2,2,2,2,2,3,3,0,0,2,2,0,0,1,1,2,2,2,2,0,0,1,1,2,2,2,2,2,2,0,0,1,1,2,2,0,0,3,3,1,1,3,3,3,3,3,3,2,2,1,1,1,1,2,2,2,2,3,3,0,0,2,2,1,1,0,0,2,2,0,0,2,2,1,1,0,0,2,2,3,3,0,0,2,2,2,2,1,1,2,2,3,3,1,1,1,1,1,1,0,0,2,2,2,2,2,2,0,0,1,1,1,1,2,2,1,1,1,1,1,1,0,0,2,2,1,1,1,1,3,3,2,2,2,2,0,0,1,1,2,2,1,1,2,2,0,0,0,0,1,1,0,0,3,3,2,2,3,3,3,3,3,3,2,2,2,2,1,1,2,2,2,2,1,1,1,1,0,0,2,2,3,3,3,3,0,0,2,2,2,2,2,2,0,0,0,0,3,3,1,1,3,3,2,2,3,3,2,2,3,3,2,2,2,2,0,0,1,1,2,2,0,0,1,1,0,0,0,0,2,2,0,0,1,1,3,3,1,1,3,3,0,0,1,1,3,3,2,2,0,0,3,3,2,2,2,2,3,3,3,3,0,0,2,2,2,2,0,0,1,1,1,1,2,2,0,0,2,2,0,0,1,1,2,2,2,2,2,2,1,1,0,0,3,3,0,0,3,3,0,0,3,3,2,2,0,0,2,2,2,2,0,0,2,2,1,1,2,2,2,2,2,2,0,0,1,1,2,2,3,3,1,1,2,2,3,3,0,0,0,0,0,0,0,0,3,3,1,1,0,0,0,0,0,0,0,0,1,1,2,2,1,1,0,0,3,3,3,3,2,2,2,2,3,3,0,0,0,0,0,0,3,3,0,0,2,2,1,1,0,0,0,0,3,3,1,1,0,0,3,3,2,2,0,0,2,2,3,3,2,2,0,0,1,1,0,0,1,1,2,2,2,2,1,1,2,2,2,2,2,2,1,1,3,3,0,0,2,2,1,1,3,3,0,0,0,0,3,3,1,1,1,1,1,1,2,2,2,2,3,3,0,0,2,2,3,3,3,3,3,3,1,1,2,2,0,0,1,1,3,3,3,3,3,3,2,2,1,1,1,1,3,3,3,3,3,3,1,1,2,2,0,0,2,2,3,3,0,0,2,2,0,0,1,1,0,0,0,0,3,3,2,2,0,0,0,0,3,3,3,3,2,2,2,2,0,0,3,3,1,1,0,0,1,1,3,3,3,3,0,0,2,2,3,3,1,1,1,1,0,0,2,2,3,3,3,3,1,1,0,0,1,1,2,2,3,3,3,3,2,2,0,0,0,0,2,2,2,2,0,0,1,1,2,2,0,0,0,0,0,0,2,2,1,1,0,0,1,1,1,1,2,2,2,2,2,2,3,3,0,0,2,2,0,0,2,2,0,0,2,2,1,1,2,2,1,1,0,0,1,1,2,2,1,1,0,0,2,2,3,3,0,0,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,1,1,2,2,1,1,0,0,1,1,1,1,2,2,2,2,3,3,3,3,0,0,3,3,2,2,2,2,1,1,0,0,3,3,1,1,2,2,3,3,3,3,3,3,1,1,1,1,2,2,3,3,3,3,3,3,0,0,1,1,3,3,0,0,2,2,0,0,2,2,3,3,1,1,0,0,0,0,1,1,1,1,0,0,3,3,1,1,3,3,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,3,3,1,1,2,2,3,3,1,1,1,1,0,0,2,2,2,2,1,1,3,3,2,2,3,3,3,3,3,3,0,0,0,0,0,0,3,3,0,0,0,0,3,3,1,1,3,3,1,1,1,1,1,1,3,3,2,2,0,0,1,1,2,2,3,3,0,0,0,0,0,0,1,1,2,2,1,1,3,3,0,0,3,3,0,0,2,2,1,1,0,0,0,0,1,1,0,0,0,0,3,3,0,0,3,3,3,3,2,2,0,0,0,0,2,2,0,0,0,0,3,3,0,0,0,0,0,0,3,3,2,2,1,1,0,0,3,3,1,1,2,2,3,3,1,1,0,0,2,2,1,1,0,0,0,0,1,1,1,1,1,1,3,3,1,1,1,1,0,0,2,2,0,0,1,1,2,2,1,1,2,2,3,3,0,0,1,1,0,0,3,3,0,0,2,2,2,2,1,1,3,3,3,3,3,3,3,3,3,3,0,0,1,1,2,2,3,3,2,2,2,2,3,3,2,2,3,3,2,2,2,2,0,0,0,0,2,2,3,3,3,3,0,0,1,1,0,0,3,3,1,1,2,2,3,3,2,2,3,3,1,1,1,1,3,3,3,3,1,1,0,0,0,0,1,1,2,2,1,1,1,1,2,2,0,0,2,2,1,1,2,2,1,1,1,1,3,3,0,0,1,1,0,0,1,1,3,3,0,0,1,1,0,0,3,3,0,0,2,2,3,3,0,0,1,1,0,0,2,2,3,3,0,0,1,1,3,3,3,3,3,3,1,1,1,1,3,3,3,3,0,0,0,0,0,0,3,3,1,1,3,3,1,1,2,2,1,1,1,1,2,2,3,3,3,3,0,0,3,3,0,0,2,2,2,2,2,2,3,3,2,2,1,1,3,3,2,2,0,0,1,1,2,2,2,2,0,0,0,0,2,2,2,2,2,2,1,1,3,3,3,3,3,3,3,3,1,1,1,1,3,3,0,0,2,2,1,1,2,2,1,1,0,0,2,2,2,2,0,0,2,2,2,2,0,0,1,1,3,3,3,3,2,2,1,1,1,1,0,0,2,2,3,3,2,2,0,0,1,1,3,3,3,3,1,1,0,0,1,1,1,1,1,1,0,0,2,2,3,3,3,3,2,2,3,3,1,1,3,3,1,1,0,0,0,0,3,3,3,3,3,3,0,0,2,2,2,2,3,3,1,1,0,0,2,2,2,2,0,0,3,3,0,0,1,1,3,3,3,3,0,0,0,0,3,3,2,2,0,0,0,0,2,2,3,3,0,0,3,3,2,2,2,2,0,0,2,2,0,0,3,3,2,2,1,1,3,3,3,3,1,1,3,3,2,2,2,2,2,2,0,0,1,1,0,0,3,3,1,1,2,2,2,2,0,0,0,0,2,2,0,0,3,3,0,0,2,2,1,1,3,3,2,2,3,3,0,0,1,1,2,2,0,0,2,2,0,0,2,2,0,0,2,2,3,3,3,3,0,0,3,3,0,0,0,0,1,1,3,3,0,0,0,0,0,0,3,3,0,0,0,0,1,1,3,3,1,1,3,3,0,0,1,1,2,2,3,3,0,0,1,1,2,2,0,0,2,2,2,2,0,0,2,2,3,3,2,2,1,1,0,0,2,2,0,0,2,2,3,3,1,1,0,0,1,1,1,1,2,2,0,0,0,0,2,2,0,0,2,2,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,3,3,1,1,2,2,0,0,2,2,0,0,0,0,1,1,1,1,1,1,2,2,3,3,2,2,3,3,0,0,0,0,0,0,0,0,1,1,2,2,3,3,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,1,1,2,2,2,2,3,3,1,1,3,3,3,3,0,0,1,1,0,0,3,3,1,1,3,3,1,1,0,0,3,3,0,0,3,3,2,2,0,0,0,0,2,2,3,3,2,2,1,1,2,2,1,1,3,3,3,3,2,2,0,0,3,3,0,0,0,0,1,1,0,0,1,1,2,2,3,3,0,0,3,3,2,2,1,1,0,0,0,0,0,0,2,2,1,1,3,3,1,1,1,1,0,0,2,2,3,3,1,1,3,3,2,2,0,0,2,2,3,3,0,0,1,1,3,3,2,2,3,3,0,0,1,1,3,3,1,1,2,2,0,0,2,2,0,0,3,3,2,2,0,0,1,1,2,2,1,1,2,2,3,3,2,2,2,2,0,0,2,2,1,1,3,3,3,3,1,1,1,1,0,0,1,1,3,3,1,1,1,1,3,3,3,3,2,2,1,1,1,1,1,1,1,1,0,0,0,0,2,2,0,0,0,0,2,2,2,2,3,3,0,0,2,2,3,3,1,1,0,0,0,0,2,2,0,0,3,3,0,0,2,2,1,1,0,0,2,2,0,0,1,1,0,0,2,2,2,2,0,0,2,2,0,0,3,3,3,3,1,1,1,1,3,3,2,2,2,2,0,0,1,1,3,3,2,2,3,3,1,1,3,3,0,0,1,1,2,2,1,1,2,2,1,1,1,1,3,3,3,3,1,1,3,3,3,3,1,1,0,0,0,0,1,1,1,1,0,0,0,0,2,2,0,0,1,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,0,0,1,1,3,3,0,0,2,2,2,2,2,2,1,1,1,1,1,1,3,3,3,3,3,3,2,2,2,2,2,2,1,1,0,0,0,0,2,2,0,0,3,3,0,0,3,3,1,1,1,1,2,2,1,1,2,2,3,3,0,0,0,0,1,1,0,0,2,2,2,2,3,3,0,0,1,1,2,2,0,0,2,2,2,2,3,3,0,0,2,2,1,1,1,1,0,0,0,0,0,0,1,1,3,3,2,2,0,0,1,1,0,0,3,3,3,3,1,1,0,0,3,3,3,3,3,3,3,3,2,2,3,3,3,3,1,1,2,2,2,2,2,2,1,1,2,2,2,2,0,0,0,0,0,0,1,1,3,3,2,2,0,0,3,3,1,1,0,0,2,2,1,1,0,0,0,0,1,1,2,2,3,3,1,1,2,2,2,2,2,2,1,1,3,3,1,1,1,1,3,3,3,3,2,2,3,3,0,0,2,2,2,2,3,3,1,1,0,0,3,3,2,2,2,2,3,3,2,2,2,2,1,1,2,2,1,1,1,1,0,0,1,1,3,3,2,2,0,0,0,0,2,2,3,3,0,0,1,1,2,2,1,1,1,1,0,0,3,3,3,3,2,2,2,2,0,0,0,0,2,2,1,1,0,0,1,1,1,1,3,3,1,1,3,3,0,0,0,0,1,1,2,2,3,3,1,1,1,1,3,3,0,0,1,1,2,2,3,3,0,0,0,0,1,1,0,0,3,3,0,0,3,3,1,1,3,3,0,0,0,0,3,3,1,1,3,3,1,1,2,2,0,0,2,2,2,2,0,0,1,1,2,2,1,1,3,3,3,3,3,3,0,0,0,0,1,1,3,3,0,0,3,3,0,0,2,2,0,0,3,3,1,1,0,0,0,0,2,2,0,0,3,3,0,0,3,3,2,2,3,3,1,1,1,1,0,0,2,2,2,2,0,0,3,3,2,2,1,1,3,3,2,2,1,1,3,3,1,1,0,0,1,1,2,2,3,3,3,3,3,3,0,0,0,0,3,3,0,0,0,0,0,0,0,0,1,1,2,2,0,0,1,1,0,0,0,0,1,1,1,1,1,1,2,2,1,1,2,2,3,3,2,2,2,2,0,0,0,0,3,3,0,0,2,2,3,3,3,3,1,1,0,0,2,2,1,1,0,0,0,0,0,0,1,1,2,2,0,0,3,3,2,2,0,0,0,0,3,3,0,0,0,0,3,3,3,3,1,1,1,1,3,3,3,3,0,0,3,3,2,2,2,2,1,1,3,3,3,3,3,3,0,0,1,1,3,3,2,2,0,0,0,0,3,3,3,3,1,1,1,1,0,0,2,2,0,0,0,0,0,0,3,3,1,1,2,2,3,3,2,2,1,1,3,3,1,1,1,1,3,3,1,1,2,2,1,1,3,3,1,1,3,3,0,0,2,2,2,2,1,1,2,2,0,0,0,0,1,1,0,0,2,2,0,0,1,1,3,3,1,1,3,3,0,0,1,1,0,0,3,3,1,1,0,0,3,3,3,3,0,0,3,3,3,3,1,1,3,3,3,3,2,2,3,3,3,3,3,3,1,1,0,0,3,3,3,3,2,2,3,3,1,1,1,1,2,2,2,2,0,0,0,0,0,0,3,3,2,2,0,0,2,2,0,0,2,2,1,1,3,3,0,0,3,3,3,3,3,3,0,0,1,1,1,1,2,2,2,2,0,0,2,2,1,1,3,3,2,2,1,1,3,3,3,3,0,0,3,3,0,0,1,1,2,2,2,2,1,1,2,2,0,0,2,2,3,3,1,1,3,3,3,3,0,0,3,3,3,3,3,3,3,3,0,0,3,3,2,2,0,0,3,3,0,0,3,3,0,0,0,0,0,0,2,2,0,0,0,0,3,3,0,0,3,3,2,2,0,0,2,2,1,1,0,0,2,2,1,1,2,2,0,0,0,0,2,2,2,2,1,1,1,1,2,2,3,3,3,3,3,3,0,0,3,3,1,1,0,0,1,1,2,2,1,1,2,2,1,1,2,2,2,2,0,0,0,0,0,0,0,0,3,3,3,3,2,2,1,1,3,3,2,2,0,0,0,0,2,2,1,1,1,1,0,0,1,1,0,0,2,2,2,2,2,2,1,1,0,0,1,1,0,0,0,0,3,3,3,3,1,1,2,2,0,0,2,2,0,0,3,3,2,2,1,1,2,2,0,0,3,3,0,0,0,0,2,2,2,2,0,0,3,3,1,1,1,1,2,2,3,3,2,2,0,0,0,0,3,3,1,1,3,3,0,0,0,0,0,0,3,3,2,2,2,2,1,1,1,1,2,2,1,1,0,0,3,3,3,3,1,1,0,0,1,1,0,0,2,2,3,3,0,0,1,1,2,2,0,0,1,1,1,1,3,3,2,2,0,0,0,0,3,3,2,2,2,2,1,1,3,3,3,3,1,1,1,1,3,3,0,0,0,0,0,0,2,2,3,3,0,0,3,3,1,1,1,1,0,0,0,0,2,2,1,1,0,0,2,2,0,0,1,1,3,3,1,1,2,2,3,3,1,1,2,2,2,2,1,1,0,0,1,1,2,2,2,2,2,2,0,0,1,1,1,1,2,2,1,1,3,3,1,1,1,1,0,0,0,0,3,3,3,3,1,1,2,2,1,1,2,2,3,3,0,0,0,0,0,0,2,2,3,3,0,0,2,2,2,2,1,1,1,1,2,2,0,0,2,2,1,1,3,3,1,1,2,2,1,1,0,0,3,3,0,0,2,2,0,0,1,1,3,3,2,2,0,0,1,1,3,3,1,1,2,2,2,2,1,1,3,3,3,3,0,0,2,2,0,0,2,2,3,3,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,3,3,0,0,3,3,3,3,0,0,3,3,1,1,0,0,0,0,0,0,1,1,2,2,0,0,3,3,1,1,0,0,0,0,1,1,3,3,0,0,2,2,2,2,1,1,3,3,2,2,3,3,1,1,1,1,0,0,0,0,1,1,0,0,3,3,0,0,0,0,2,2,3,3,3,3,3,3,3,3,2,2,3,3,1,1,2,2,0,0,1,1,0,0,3,3,2,2,3,3,0,0,1,1,0,0,3,3,3,3,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,2,2,0,0,3,3,1,1,0,0,3,3,0,0,3,3,0,0,2,2,2,2,2,2,3,3,2,2,0,0,2,2,3,3,1,1,2,2,3,3,1,1,2,2,1,1,2,2,1,1,2,2,2,2,0,0,2,2,0,0,3,3,0,0,3,3,1,1,3,3,3,3,2,2,1,1,0,0,2,2,1,1,3,3,0,0,2,2,2,2,3,3,2,2,1,1,3,3,3,3,3,3,1,1,2,2,1,1,0,0,0,0,2,2,0,0,0,0,0,0,1,1,0,0,0,0,3,3,3,3,0,0,0,0,3,3,3,3,3,3,2,2,2,2,1,1,3,3,1,1,0,0,3,3,1,1,0,0,3,3,1,1,2,2,2,2,3,3,1,1,1,1,0,0,3,3,0,0,1,1,3,3,3,3,3,3,0,0,3,3,0,0,3,3,1,1,2,2,0,0,1,1,2,2,3,3,2,2,2,2,0,0,1,1,1,1,1,1,1,1,3,3,3,3,2,2,0,0,3,3,0,0,2,2,3,3,2,2,0,0,3,3,0,0,3,3,2,2,3,3,3,3,0,0,1,1,0,0,0,0,2,2,0,0,2,2,1,1,1,1,3,3,3,3,3,3,2,2,3,3,1,1,0,0,0,0,3,3,2,2,0,0,3,3,1,1,1,1,2,2,2,2,2,2,0,0,3,3,1,1,2,2,3,3,0,0,0,0,0,0,1,1,3,3,1,1,2,2,2,2,0,0,3,3,0,0,0,0,3,3,0,0,1,1,3,3,0,0,2,2,0,0,1,1,3,3,1,1,2,2,1,1,2,2,0,0,0,0,0,0,2,2,0,0,3,3,1,1,3,3,0,0,1,1,0,0,1,1,0,0,1,1,0,0,2,2,2,2,3,3,3,3,0,0,1,1,1,1,1,1,3,3,2,2,1,1,0,0,1,1,3,3,3,3,0,0,3,3,0,0,0,0,0,0,0,0,2,2,1,1,3,3,0,0,1,1,3,3,2,2,1,1,2,2,3,3,2,2,0,0,3,3,3,3,2,2,3,3,3,3,1,1,1,1,1,1,1,1,2,2,0,0,3,3,3,3,1,1,2,2,2,2,2,2,1,1,3,3,0,0,2,2,1,1,0,0,0,0,0,0,1,1,0,0,2,2,0,0,3,3,1,1,3,3,3,3,0,0,1,1,3,3,2,2,1,1,3,3,3,3,3,3,1,1,2,2,3,3,3,3,0,0,0,0,3,3,3,3,3,3,3,3,3,3,0,0,2,2,3,3,2,2,3,3,0,0,2,2,0,0,1,1,3,3,2,2,0,0,2,2,1,1,3,3,1,1,3,3,0,0,1,1,3,3,1,1,1,1,0,0,2,2,0,0,0,0,3,3,0,0,0,0,1,1,3,3,3,3,1,1,2,2,1,1,2,2,2,2,3,3,3,3,1,1,2,2,0,0,0,0,3,3,1,1,1,1,1,1,1,1,0,0,1,1,0,0,3,3,2,2,3,3,1,1,2,2,1,1,3,3,0,0,0,0,0,0,0,0,0,0,3,3,1,1,2,2,1,1,0,0,0,0,3,3,1,1,3,3,2,2,2,2,2,2,2,2,0,0,2,2,0,0,3,3,1,1,1,1,0,0,2,2,1,1,2,2,0,0,0,0,2,2,0,0,3,3,3,3,1,1,2,2,3,3,3,3,3,3,1,1,1,1,2,2,3,3,1,1,2,2,1,1,0,0,1,1,2,2,3,3,2,2,3,3,0,0,1,1,2,2,2,2,2,2,0,0,1,1,1,1,3,3,3,3,0,0,1,1,0,0,3,3,0,0,0,0,2,2,3,3,3,3,3,3,0,0,2,2,1,1,0,0,1,1,0,0,0,0,2,2,1,1,1,1,1,1,0,0,2,2,2,2,3,3,0,0,3,3,2,2,1,1,1,1,0,0,0,0,0,0,1,1,2,2,0,0,2,2,1,1,0,0,2,2,1,1,2,2,3,3,2,2,3,3,3,3,1,1,0,0,2,2,2,2,3,3,2,2,2,2,0,0,2,2,2,2,3,3,3,3,1,1,1,1,0,0,1,1,2,2,0,0,2,2,2,2,3,3,2,2,2,2,3,3,3,3,3,3,3,3,2,2,0,0,0,0,2,2,0,0,0,0,2,2,3,3,3,3,0,0,3,3,1,1,2,2,1,1,0,0,0,0,0,0,0,0,3,3,1,1,3,3,0,0,3,3,0,0,3,3,2,2,0,0,2,2,1,1,3,3,0,0,3,3,1,1,2,2,0,0,0,0,2,2,2,2,1,1,1,1,2,2,0,0,2,2,1,1,1,1,2,2,3,3,0,0,2,2,1,1,3,3,2,2,1,1,1,1,2,2,3,3,0,0,1,1,0,0,1,1,0,0,1,1,3,3,3,3,1,1,1,1,0,0,1,1,1,1,2,2,0,0,1,1,3,3,0,0,1,1,1,1,2,2,2,2,0,0,3,3,2,2,3,3,2,2,3,3,3,3,0,0,2,2,2,2,3,3,1,1,0,0,2,2,0,0,1,1,0,0,2,2,2,2,0,0,2,2,0,0,2,2,2,2,3,3,0,0,2,2,0,0,2,2,2,2,2,2,0,0,0,0,2,2,0,0,1,1,1,1,3,3,0,0,3,3,2,2,2,2,0,0,3,3,0,0,1,1,2,2,1,1,3,3,3,3,3,3,1,1,1,1,0,0,1,1,0,0,2,2,2,2,1,1,2,2,1,1,1,1,3,3,0,0,0,0,0,0,3,3,1,1,0,0,1,1,3,3,1,1,1,1,2,2,2,2,3,3,3,3,2,2,3,3,0,0,0,0,2,2,1,1,0,0,1,1,3,3,1,1,0,0,3,3,0,0,1,1,2,2,2,2,0,0,3,3,1,1,3,3,0,0,0,0,0,0,0,0,3,3,0,0,3,3,3,3,0,0,0,0,2,2,1,1,1,1,0,0,1,1,1,1,0,0,2,2,0,0,0,0,0,0,0,0,2,2,1,1,3,3,3,3,2,2,2,2,1,1,3,3,1,1,0,0,0,0,1,1,3,3,2,2,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,3,3,1,1,2,2,0,0,0,0,0,0,2,2,3,3,1,1,1,1,2,2,1,1,2,2,1,1,2,2,0,0,1,1,3,3,3,3,3,3,0,0,3,3,2,2,1,1,2,2,2,2,1,1,0,0,1,1,0,0,0,0,2,2,0,0,2,2,0,0,1,1,3,3,3,3,1,1,3,3,2,2,0,0,0,0,1,1,1,1,1,1,3,3,2,2,3,3,2,2,0,0,3,3,2,2,3,3,1,1,2,2,2,2,1,1,3,3,1,1,3,3,1,1,2,2,2,2,0,0,0,0,3,3,3,3,0,0,2,2,1,1,0,0,2,2,1,1,3,3,1,1,0,0,2,2,1,1,2,2,1,1,3,3,3,3,1,1,0,0,0,0,1,1,0,0,3,3,3,3,3,3,2,2,0,0,3,3,2,2,1,1,2,2,1,1,0,0,0,0,2,2,1,1,0,0,2,2,3,3,0,0,0,0,2,2,2,2,3,3,1,1,3,3,2,2,2,2,2,2,0,0,1,1,2,2,0,0,1,1,3,3,0,0,1,1,3,3,2,2,2,2,0,0,1,1,3,3,0,0,0,0,2,2,3,3,3,3,2,2,3,3,3,3,3,3,3,3,1,1,0,0,3,3,3,3,3,3,2,2,2,2,0,0,2,2,2,2,2,2,1,1,0,0,2,2,2,2,2,2,2,2,0,0,0,0,3,3,1,1,2,2,3,3,1,1,2,2,2,2,1,1,2,2,3,3,2,2,3,3,1,1,2,2,1,1,2,2,3,3,0,0,0,0,3,3,1,1,2,2,2,2,0,0,0,0,3,3,0,0,2,2,1,1,0,0,3,3,2,2,0,0,2,2,0,0,2,2,2,2,3,3,2,2,1,1,2,2,1,1,1,1,0,0,2,2,1,1,0,0,2,2,2,2,0,0,0,0,1,1,3,3,1,1,0,0,2,2,2,2,2,2,3,3,3,3,2,2,3,3,3,3,1,1,2,2,0,0,3,3,1,1,2,2,1,1,0,0,1,1,2,2,2,2,2,2,3,3,0,0,0,0,0,0,3,3,1,1,0,0,0,0,3,3,0,0,2,2,3,3,2,2,1,1,1,1,0,0,2,2,1,1,1,1,0,0,1,1,1,1,1,1,3,3,2,2,2,2,0,0,1,1,3,3,1,1,2,2,3,3,1,1,1,1,1,1,3,3,3,3,2,2,2,2,0,0,1,1,2,2,0,0,0,0,1,1,3,3,3,3,2,2,0,0,2,2,3,3,0,0,1,1,0,0,2,2,1,1,0,0,2,2,1,1,3,3,0,0,2,2,1,1,2,2,2,2,3,3,1,1,0,0,0,0,1,1,1,1,2,2,2,2,0,0,0,0,0,0,3,3,2,2,3,3,2,2,0,0,1,1,0,0,3,3,3,3,0,0,2,2,3,3,3,3,1,1,0,0,2,2,1,1,1,1,0,0,0,0,1,1,1,1,0,0,2,2,0,0,3,3,2,2,0,0,0,0,2,2,0,0,3,3,0,0,3,3,2,2,2,2,0,0,2,2,0,0,2,2,1,1,3,3,0,0,0,0,3,3,0,0,0,0,1,1,2,2,3,3,0,0,1,1,0,0,2,2,2,2,1,1,1,1,0,0,0,0,0,0,3,3,3,3,0,0,1,1,1,1,2,2,0,0,0,0,0,0,1,1,0,0,3,3,1,1,0,0,3,3,1,1,3,3,3,3,2,2,0,0,2,2,1,1,0,0,1,1,2,2,1,1,1,1,1,1,3,3,2,2,3,3,2,2,2,2,0,0,3,3,3,3,2,2,1,1,3,3,0,0,1,1,1,1,3,3,1,1,0,0,3,3,1,1,1,1,1,1,1,1,3,3,2,2,0,0,0,0,2,2,0,0,1,1,0,0,0,0,2,2,1,1,0,0,3,3,0,0,0,0,0,0,3,3,0,0,1,1,0,0,2,2,1,1,0,0,2,2,3,3,2,2,2,2,2,2,2,2,3,3,0,0,2,2,2,2,2,2,3,3,2,2,3,3,0,0,0,0,2,2,3,3,1,1,0,0,2,2,2,2,2,2,0,0,2,2,1,1,2,2,1,1,1,1,3,3,0,0,3,3,0,0,0,0,2,2,2,2,1,1,0,0,3,3,1,1,0,0,3,3,0,0,1,1,1,1,2,2,3,3,2,2,1,1,3,3,0,0,2,2,0,0,2,2,0,0,0,0,0,0,0,0,3,3,1,1,3,3,3,3,3,3,2,2,3,3,1,1,0,0,1,1,0,0,1,1,1,1,3,3,3,3,3,3,0,0,1,1,0,0,0,0,1,1,2,2,1,1,2,2,0,0,0,0,0,0,0,0,0,0,3,3,1,1,0,0,0,0,3,3,0,0,1,1,1,1,1,1,3,3,1,1,1,1,1,1,1,1,3,3,1,1,3,3,1,1,1,1,0,0,0,0,0,0,3,3,0,0,3,3,1,1,2,2,2,2,3,3,2,2,3,3,3,3,3,3,1,1,3,3,1,1,2,2,1,1,3,3,3,3,1,1,1,1,1,1,3,3,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,3,3,2,2,0,0,0,0,1,1,0,0,1,1,2,2,2,2,1,1,3,3,2,2,2,2,2,2,2,2,0,0,1,1,0,0,2,2,2,2,3,3,2,2,2,2,1,1,1,1,1,1,3,3,0,0,2,2,3,3,0,0,0,0,0,0,1,1,0,0,3,3,1,1,0,0,0,0,3,3,3,3,3,3,3,3,2,2,2,2,0,0,2,2,3,3,3,3,3,3,0,0,3,3,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,2,2,3,3,0,0,2,2,3,3,2,2,2,2,3,3,1,1,3,3,3,3,3,3,3,3,1,1,2,2,1,1,0,0,2,2,2,2,0,0,0,0,3,3,1,1,1,1,3,3,3,3,2,2,1,1,2,2,1,1,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,2,2,0,0,1,1,0,0,1,1,1,1,3,3,0,0,1,1,2,2,1,1,0,0,3,3,3,3,1,1,2,2,2,2,3,3,3,3,3,3,3,3,2,2,0,0,1,1,0,0,0,0,1,1,3,3,2,2,3,3,1,1,1,1,1,1,1,1,2,2,3,3,2,2,1,1,1,1,2,2,2,2,1,1,2,2,0,0,0,0,0,0,3,3,0,0,0,0,0,0,3,3,0,0,1,1,2,2,0,0,1,1,1,1,0,0,0,0,0,0,1,1,2,2,3,3,1,1,1,1,2,2,2,2,1,1,1,1,2,2,2,2,2,2,3,3,0,0,1,1,1,1,2,2,0,0,0,0,3,3,2,2,0,0,3,3,3,3,3,3,1,1,0,0,1,1,3,3,3,3,1,1,3,3,1,1,3,3,0,0,2,2,3,3,1,1,1,1,0,0,1,1,3,3,2,2,1,1,2,2,3,3,0,0,1,1,1,1,1,1,3,3,0,0,2,2,3,3,1,1,2,2,2,2,1,1,2,2,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,2,2,0,0,1,1,2,2,3,3,3,3,3,3,0,0,3,3,1,1,2,2,2,2,3,3,3,3,1,1,2,2,2,2,1,1,2,2,3,3,0,0,1,1,3,3,3,3,3,3,0,0,1,1,0,0,0,0,3,3,3,3,0,0,1,1,3,3,1,1,1,1,0,0,2,2,3,3,2,2,1,1,0,0,0,0,0,0,0,0,1,1,2,2,3,3,0,0,0,0,0,0,2,2,0,0,0,0,0,0,1,1,0,0,3,3,3,3,3,3,3,3,1,1,3,3,0,0,1,1,0,0,0,0,3,3,3,3,0,0,3,3,1,1,2,2,1,1,3,3,1,1,0,0,2,2,1,1,3,3,2,2,0,0,2,2,1,1,2,2,1,1,3,3,0,0,3,3,1,1,3,3,0,0,3,3,2,2,3,3,1,1,1,1,2,2,3,3,0,0,2,2,3,3,1,1,0,0,0,0,3,3,3,3,0,0,3,3,1,1,1,1,2,2,3,3,1,1,0,0,0,0,0,0,0,0,2,2,2,2,0,0,1,1,1,1,1,1,1,1,2,2,0,0,3,3,3,3,3,3,3,3,1,1,0,0,1,1,2,2,1,1,3,3,3,3,0,0,1,1,2,2,0,0,3,3,0,0,1,1,0,0,2,2,0,0,1,1,2,2,2,2,0,0,3,3,0,0,3,3,0,0,0,0,0,0,1,1,2,2,3,3,1,1,1,1,0,0,3,3,2,2,3,3,3,3,3,3,0,0,0,0,3,3,2,2,1,1,1,1,2,2,0,0,3,3,3,3,3,3,0,0,0,0,2,2,2,2,0,0,0,0,2,2,2,2,2,2,1,1,3,3,1,1,1,1,1,1,2,2,3,3,2,2,2,2,3,3,0,0,0,0,3,3,2,2,2,2,3,3,3,3,3,3,0,0,3,3,1,1,2,2,1,1,0,0,0,0,0,0,0,0,1,1,3,3,2,2,3,3,1,1,3,3,3,3,3,3,2,2,2,2,3,3,2,2,1,1,0,0,1,1,0,0,2,2,0,0,0,0,1,1,1,1,2,2,1,1,0,0,0,0,2,2,3,3,1,1,2,2,0,0,0,0,0,0,2,2,2,2,2,2,0,0,2,2,3,3,2,2,1,1,0,0,3,3,2,2,1,1,0,0,3,3,2,2,2,2,0,0,3,3,2,2,3,3,1,1,0,0,1,1,2,2,0,0,1,1,3,3,1,1,2,2,0,0,2,2,3,3,2,2,2,2,1,1,2,2,1,1,2,2,1,1,1,1,3,3,0,0,0,0,0,0,2,2,0,0,3,3,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,3,3,0,0,2,2,2,2,2,2,1,1,1,1,1,1,1,1,3,3,2,2,0,0,1,1,1,1,3,3,0,0,1,1,2,2,2,2,0,0,3,3,1,1,2,2,2,2,0,0,3,3,0,0,1,1,3,3,0,0,2,2,0,0,0,0,0,0,2,2,0,0,0,0,3,3,2,2,0,0,1,1,3,3,2,2,2,2,3,3,0,0,3,3,3,3,0,0,1,1,2,2,0,0,2,2,1,1,2,2,0,0,0,0,3,3,2,2,1,1,0,0,2,2,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,2,2,0,0,2,2,0,0,3,3,3,3,2,2,2,2,0,0,0,0,2,2,0,0,3,3,1,1,3,3,1,1,3,3,2,2,1,1,3,3,3,3,2,2,3,3,3,3,3,3,0,0,2,2,2,2,0,0,3,3,0,0,3,3,3,3,2,2,3,3,0,0,0,0,2,2,3,3,2,2,1,1,0,0,0,0,2,2,0,0,2,2,1,1,2,2,0,0,3,3,2,2,2,2,2,2,2,2,3,3,3,3,0,0,1,1,1,1,2,2,1,1,1,1,1,1,0,0,0,0,1,1,0,0,3,3,2,2,1,1,1,1,0,0,2,2,0,0,2,2,1,1,2,2,2,2,0,0,3,3,0,0,0,0,0,0,2,2,0,0,2,2,3,3,3,3,3,3,1,1,2,2,1,1,0,0,2,2,1,1,3,3,2,2,3,3,2,2,0,0,2,2,2,2,2,2,1,1,1,1,0,0,2,2,1,1,1,1,3,3,3,3,1,1,2,2,0,0,3,3,3,3,3,3,2,2,1,1,3,3,0,0,1,1,2,2,1,1,0,0,1,1,0,0,1,1,3,3,3,3,0,0,0,0,0,0,3,3,2,2,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,2,2,3,3,2,2,2,2,2,2,0,0,3,3,2,2,0,0,0,0,3,3,2,2,0,0,0,0,2,2,1,1,2,2,2,2,2,2,0,0,1,1,3,3,2,2,3,3,1,1,2,2,3,3,3,3,1,1,3,3,1,1,0,0,0,0,0,0,0,0,1,1,3,3,2,2,0,0,3,3,1,1,1,1,1,1,2,2,2,2,0,0,0,0,1,1,2,2,3,3,1,1,1,1,0,0,1,1,0,0,3,3,2,2,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,1,1,1,1,3,3,3,3,3,3,2,2,0,0,0,0,1,1,0,0,0,0,2,2,3,3,3,3,2,2,1,1,2,2,2,2,3,3,3,3,3,3,3,3,2,2,0,0,2,2,0,0,2,2,1,1,3,3,1,1,2,2,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,2,2,0,0,1,1,3,3,0,0,0,0,3,3,1,1,3,3,3,3,3,3,1,1,1,1,2,2,3,3,0,0,1,1,3,3,1,1,2,2,3,3,0,0,2,2,3,3,2,2,0,0,3,3,1,1,0,0,2,2,2,2,0,0,0,0,1,1,2,2,3,3,3,3,1,1,2,2,3,3,2,2,3,3,2,2,2,2,0,0,2,2,3,3,3,3,1,1,0,0,3,3,2,2,2,2,2,2,3,3,1,1,3,3,2,2,1,1,2,2,3,3,1,1,2,2,3,3,3,3,2,2,3,3,3,3,3,3,1,1,3,3,2,2,1,1,0,0,0,0,3,3,1,1,2,2,2,2,3,3,0,0,2,2,2,2,3,3,0,0,1,1,0,0,2,2,2,2,2,2,3,3,3,3,2,2,3,3,0,0,1,1,1,1,0,0,2,2,1,1,3,3,0,0,0,0,0,0,2,2,2,2,3,3,3,3,3,3,2,2,0,0,3,3,2,2,0,0,3,3,0,0,1,1,0,0,1,1,3,3,1,1,2,2,2,2,1,1,0,0,3,3,1,1,3,3,3,3,0,0,0,0,3,3,0,0,1,1,3,3,1,1,3,3,1,1,0,0,1,1,0,0,0,0,3,3,1,1,2,2,0,0,1,1,2,2,1,1,2,2,2,2,1,1,3,3,0,0,0,0,3,3,1,1,3,3,3,3,3,3,1,1,0,0,2,2,0,0,0,0,0,0,3,3,0,0,2,2,0,0,2,2,0,0,1,1,0,0,2,2,2,2,2,2,0,0,1,1,1,1,3,3,1,1,3,3,1,1,3,3,1,1,0,0,2,2,0,0,2,2,3,3,2,2,2,2,2,2,2,2,2,2,2,2,3,3,0,0,3,3,0,0,3,3,2,2,1,1,1,1,3,3,1,1,1,1,2,2,3,3,2,2,1,1,3,3,2,2,0,0,0,0,1,1,3,3,1,1,2,2,3,3,2,2,0,0,2,2,0,0,1,1,0,0,1,1,2,2,0,0,3,3,2,2,3,3,0,0,0,0,0,0,0,0,2,2,0,0,2,2,3,3,0,0,2,2,2,2,2,2,3,3,2,2,0,0,0,0,1,1,0,0,2,2,3,3,0,0,0,0,0,0,1,1,3,3,3,3,2,2,0,0,1,1,2,2,3,3,0,0,3,3,1,1,2,2,1,1,3,3,3,3,1,1,3,3,1,1,2,2,0,0,3,3,1,1,2,2,1,1,2,2,2,2,2,2,1,1,3,3,0,0,2,2,2,2,1,1,0,0,2,2,3,3,0,0,2,2,3,3,1,1,0,0,0,0,2,2,1,1,2,2,3,3,3,3,1,1,1,1,3,3,1,1,3,3,3,3,3,3,3,3,1,1,2,2,1,1,2,2,0,0,3,3,1,1,2,2,3,3,1,1,2,2,1,1,2,2,2,2,3,3,0,0,2,2,2,2,0,0,1,1,1,1,0,0,0,0,1,1,1,1,2,2,1,1,1,1,0,0,1,1,1,1,0,0,1,1,2,2,1,1,2,2,3,3,2,2,0,0,3,3,2,2,3,3,1,1,0,0,1,1,3,3,3,3,0,0,1,1,1,1,0,0,3,3,1,1,3,3,3,3,3,3,3,3,2,2,1,1,2,2,1,1,2,2,3,3,1,1,2,2,2,2,0,0,2,2,3,3,0,0,2,2,2,2,0,0,2,2,2,2,1,1,1,1,0,0,3,3,1,1,3,3,1,1,1,1,1,1,3,3,1,1,1,1,3,3,1,1,3,3,1,1,0,0,3,3,0,0,2,2,3,3,2,2,1,1,3,3,1,1,3,3,2,2,3,3,1,1,1,1,0,0,2,2,3,3,0,0,2,2,1,1,2,2,0,0,3,3,3,3,2,2,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,2,2,0,0,1,1,1,1,1,1,2,2,1,1,3,3,1,1,1,1,1,1,2,2,1,1,0,0,2,2,0,0,0,0,3,3,0,0,3,3,2,2,1,1,1,1,2,2,2,2,0,0,2,2,0,0,0,0,2,2,0,0,3,3,1,1,0,0,3,3,3,3,0,0,3,3,1,1,3,3,2,2,2,2,1,1,3,3,2,2,1,1,2,2,0,0,1,1,2,2,1,1,1,1,0,0,2,2,2,2,2,2,0,0,2,2,1,1,1,1,3,3,2,2,0,0,2,2,2,2,1,1,1,1,0,0,1,1,2,2,2,2,0,0,1,1,1,1,1,1,1,1,1,1,3,3,1,1,2,2,1,1,2,2,2,2,0,0,2,2,0,0,1,1,2,2,1,1,2,2,3,3,1,1,1,1,2,2,3,3,3,3,2,2,3,3,0,0,3,3,1,1,3,3,3,3,0,0,1,1,2,2,2,2,2,2,1,1,0,0,1,1,0,0,2,2,1,1,3,3,2,2,1,1,0,0,1,1,1,1,1,1,3,3,1,1,2,2,2,2,0,0,3,3,1,1,3,3,1,1,0,0,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,1,1,0,0,3,3,2,2,2,2,0,0,3,3,2,2,2,2,0,0,1,1,1,1,0,0,2,2,2,2,1,1,2,2,2,2,1,1,2,2,1,1,3,3,0,0,0,0,3,3,3,3,2,2,3,3,0,0,3,3,1,1,1,1,1,1,1,1,1,1,2,2,0,0,1,1,3,3,3,3,1,1,3,3,3,3,3,3,0,0,2,2,3,3,2,2,1,1,1,1,2,2,2,2,0,0,2,2,3,3,0,0,3,3,3,3,0,0,3,3,2,2,0,0,0,0,3,3,2,2,1,1,1,1,3,3,0,0,3,3,2,2,0,0,1,1,1,1,1,1,0,0,2,2,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,3,3,1,1,0,0,3,3,3,3,0,0,0,0,0,0,2,2,3,3,0,0,3,3,0,0,2,2,0,0,2,2,1,1,2,2,3,3,1,1,0,0,2,2,2,2,3,3,2,2,3,3,3,3,1,1,2,2,2,2,2,2,1,1,2,2,1,1,1,1,1,1,1,1,2,2,2,2,1,1,2,2,0,0,1,1,1,1,0,0,3,3,0,0,3,3,1,1,0,0,1,1,1,1,2,2,3,3,3,3,3,3,0,0,0,0,0,0,2,2,0,0,1,1,0,0,1,1,0,0,0,0,0,0,2,2,3,3,1,1,2,2,2,2,2,2,2,2,1,1,1,1,0,0,2,2,0,0,0,0,0,0,2,2,1,1,0,0,1,1,2,2,3,3,0,0,0,0,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,0,0,3,3,2,2,3,3,1,1,1,1,2,2,0,0,1,1,0,0,2,2,0,0,0,0,3,3,2,2,2,2,1,1,1,1,3,3,3,3,2,2,2,2,2,2,3,3,0,0,2,2,2,2,0,0,3,3,1,1,2,2,3,3,3,3,2,2,2,2,3,3,2,2,2,2,3,3,3,3,2,2,1,1,2,2,1,1,2,2,1,1,1,1,1,1,2,2,3,3,2,2,3,3,2,2,1,1,2,2,3,3,2,2,2,2,0,0,3,3,2,2,1,1,3,3,0,0,0,0,0,0,2,2,3,3,1,1,3,3,0,0,2,2,3,3,3,3,0,0,0,0,1,1,2,2,3,3,3,3,0,0,1,1,0,0,1,1,2,2,1,1,3,3,0,0,1,1,1,1,1,1,0,0,0,0,2,2,2,2,1,1,2,2,0,0,0,0,3,3,3,3,3,3,3,3,2,2,3,3,1,1,3,3,0,0,0,0,1,1,3,3,3,3,1,1,2,2,3,3,0,0,2,2,0,0,2,2,3,3,3,3,3,3,1,1,3,3,3,3,0,0,2,2,3,3,1,1,1,1,3,3,2,2,0,0,2,2,2,2,1,1,3,3,3,3,3,3,0,0,3,3,0,0,1,1,1,1,0,0,1,1,3,3,3,3,3,3,3,3,2,2,3,3,3,3,3,3,1,1,0,0,3,3,0,0,2,2,2,2,1,1,0,0,3,3,3,3,0,0,0,0,2,2,1,1,2,2,1,1,1,1,0,0,0,0,2,2,2,2,2,2,3,3,2,2,3,3,2,2,0,0,2,2,0,0,3,3,0,0,1,1,1,1,2,2,2,2,0,0,1,1,2,2,0,0,1,1,3,3,0,0,2,2,3,3,2,2,0,0,3,3,2,2,3,3,0,0,2,2,2,2,0,0,3,3,2,2,3,3,2,2,2,2,3,3,3,3,3,3,0,0,3,3,0,0,2,2,2,2,3,3,0,0,2,2,2,2,2,2,3,3,0,0,2,2,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,0,0,2,2,0,0,1,1,3,3,0,0,1,1,0,0,0,0,3,3,2,2,1,1,0,0,2,2,2,2,3,3,0,0,1,1,2,2,1,1,3,3,3,3,1,1,3,3,3,3,0,0,2,2,1,1,2,2,3,3,3,3,1,1,0,0,1,1,3,3,2,2,1,1,3,3,1,1,3,3,2,2,0,0,3,3,1,1,2,2,1,1,3,3,3,3,0,0,1,1,0,0,0,0,0,0,2,2,1,1,1,1,2,2,2,2,2,2,1,1,2,2,0,0,0,0,3,3,0,0,0,0,1,1,2,2,1,1,0,0,0,0,3,3,0,0,0,0,1,1,2,2,0,0,2,2,0,0,1,1,3,3,0,0,2,2,0,0,3,3,1,1,2,2,0,0,3,3,0,0,3,3,1,1,2,2,2,2,2,2,3,3,3,3,1,1,2,2,2,2,3,3,1,1,3,3,3,3,0,0,3,3,0,0,0,0,2,2,0,0,1,1,3,3,0,0,2,2,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,2,2,0,0,3,3,0,0,3,3,0,0,2,2,0,0,1,1,1,1,1,1,3,3,0,0,2,2,3,3,2,2,3,3,0,0,1,1,1,1,3,3,1,1,2,2,2,2,0,0,2,2,2,2,3,3,1,1,3,3,3,3,0,0,1,1,0,0,0,0,3,3,3,3,0,0,2,2,1,1,0,0,1,1,1,1,1,1,3,3,0,0,1,1,1,1,1,1,2,2,0,0,3,3,2,2,3,3,0,0,3,3,0,0,1,1,3,3,0,0,3,3,0,0,3,3,0,0,0,0,1,1,1,1,1,1,1,1,3,3,0,0,0,0,2,2,1,1,0,0,3,3,3,3,0,0,2,2,0,0,0,0,0,0,1,1,2,2,1,1,0,0,0,0,1,1,1,1,0,0,2,2,3,3,1,1,3,3,0,0,0,0,0,0,0,0,1,1,3,3,0,0,3,3,2,2,0,0,2,2,2,2,1,1,2,2,3,3,1,1,2,2,0,0,3,3,0,0,3,3,2,2,2,2,3,3,0,0,1,1,0,0,0,0,2,2,3,3,3,3,3,3,3,3,2,2,3,3,1,1,0,0,0,0,1,1,0,0,3,3,2,2,1,1,3,3,2,2,3,3,0,0,2,2,3,3,2,2,2,2,3,3,3,3,2,2,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,1,1,0,0,0,0,3,3,2,2,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,2,2,3,3,0,0,2,2,0,0,0,0,2,2,1,1,0,0,1,1,0,0,2,2,2,2,2,2,1,1,2,2,1,1,2,2,2,2,2,2,0,0,1,1,0,0,0,0,1,1,3,3,0,0,3,3,3,3,0,0,3,3,0,0,1,1,3,3,1,1,2,2,0,0,2,2,2,2,3,3,3,3,0,0,2,2,1,1,0,0,3,3,2,2,1,1,1,1,2,2,2,2,2,2,1,1,1,1,3,3,3,3,1,1,2,2,2,2,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,1,1,2,2,3,3,0,0,2,2,1,1,3,3,3,3,3,3,3,3,0,0,2,2,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,3,3,1,1,1,1,2,2,2,2,0,0,1,1,1,1,0,0,1,1,2,2,1,1,3,3,2,2,2,2,1,1,3,3,0,0,2,2,1,1,0,0,3,3,0,0,0,0,3,3,1,1,2,2,3,3,3,3,1,1,0,0,1,1,3,3,1,1,3,3,0,0,0,0,0,0,1,1,3,3,3,3,1,1,0,0,3,3,2,2,1,1,2,2,3,3,3,3,1,1,1,1,1,1,3,3,1,1,0,0,2,2,1,1,1,1,1,1,2,2,0,0,1,1,2,2,3,3,0,0,0,0,0,0,3,3,2,2,1,1,2,2,2,2,0,0,3,3,1,1,2,2,1,1,0,0,0,0,1,1,1,1,3,3,1,1,1,1,1,1,2,2,0,0,0,0,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,3,3,3,3,1,1,3,3,0,0,3,3,0,0,1,1,2,2,2,2,2,2,3,3,3,3,0,0,2,2,2,2,1,1,3,3,3,3,3,3,2,2,1,1,0,0,0,0,3,3,1,1,2,2,2,2,3,3,1,1,1,1,3,3,1,1,1,1,3,3,1,1,3,3,3,3,2,2,1,1,2,2,3,3,2,2,3,3,3,3,3,3,1,1,3,3,3,3,2,2,2,2,0,0,0,0,0,0,3,3,0,0,3,3,1,1,0,0,1,1,0,0,1,1,2,2,1,1,2,2,0,0,0,0,1,1,0,0,0,0,1,1,3,3,0,0,0,0,3,3,3,3,3,3,0,0,2,2,3,3,0,0,2,2,2,2,2,2,3,3,1,1,3,3,2,2,3,3,0,0,3,3,3,3,2,2,1,1,1,1,1,1,1,1,3,3,2,2,2,2,3,3,2,2,1,1,2,2,3,3,0,0,2,2,1,1,3,3,2,2,2,2,0,0,3,3,0,0,1,1,3,3,0,0,0,0,1,1,1,1,1,1,0,0,2,2,3,3,0,0,2,2,2,2,1,1,2,2,0,0,1,1,2,2,1,1,1,1,1,1,0,0,1,1,0,0,3,3,1,1,3,3,0,0,1,1,3,3,2,2,0,0,0,0,3,3,3,3,3,3,2,2,1,1,2,2,3,3,2,2,3,3,1,1,0,0,2,2,0,0,1,1,0,0,0,0,0,0,3,3,2,2,1,1,1,1,1,1,1,1,1,1,0,0,2,2,3,3,1,1,0,0,2,2,3,3,1,1,0,0,2,2,2,2,2,2,0,0,0,0,3,3,1,1,1,1,0,0,3,3,2,2,3,3,0,0,0,0,3,3,1,1,3,3,2,2,0,0,3,3,2,2,2,2,0,0,3,3,3,3,1,1,0,0,3,3,1,1,3,3,3,3,3,3,0,0,1,1,2,2,3,3,1,1,0,0,2,2,3,3,0,0,2,2,0,0,3,3,0,0,2,2,2,2,2,2,2,2,3,3,0,0,1,1,1,1,2,2,3,3,2,2,1,1,1,1,0,0,0,0,0,0,1,1,2,2,0,0,3,3,0,0,1,1,2,2,0,0,0,0,1,1,0,0,3,3,2,2,0,0,3,3,1,1,3,3,2,2,0,0,0,0,1,1,2,2,1,1,1,1,1,1,2,2,3,3,0,0,3,3,3,3,1,1,1,1,3,3,1,1,2,2,0,0,0,0,1,1,1,1,2,2,0,0,3,3,0,0,1,1,3,3,2,2,0,0,1,1,2,2,2,2,0,0,2,2,3,3,2,2,0,0,0,0,0,0,3,3,2,2,2,2,1,1,0,0,2,2,3,3,2,2,2,2,1,1,0,0,2,2,0,0,3,3,0,0,3,3,3,3,0,0,3,3,0,0,3,3,2,2,3,3,1,1,2,2,3,3,2,2,2,2,0,0,2,2,0,0,2,2,2,2,1,1,1,1,0,0,1,1,3,3,1,1,0,0,0,0,3,3,0,0,0,0,1,1,1,1,2,2,3,3,3,3,1,1,2,2,2,2,1,1,3,3,2,2,0,0,1,1,0,0,2,2,0,0,3,3,1,1,0,0,1,1,1,1,2,2,1,1,3,3,1,1,3,3,1,1,0,0,0,0,0,0,2,2,3,3,2,2,1,1,2,2,0,0,1,1,0,0,3,3,0,0,2,2,2,2,2,2,3,3,3,3,1,1,2,2,1,1,0,0,3,3,3,3,2,2,0,0,2,2,0,0,2,2,0,0,1,1,1,1,0,0,1,1,3,3,1,1,0,0,3,3,3,3,2,2,0,0,3,3,2,2,3,3,0,0,0,0,3,3,2,2,1,1,1,1,1,1,0,0,2,2,1,1,0,0,0,0,2,2,1,1,2,2,1,1,1,1,3,3,0,0,0,0,1,1,3,3,2,2,1,1,1,1,3,3,0,0,0,0,3,3,0,0,3,3,3,3,2,2,0,0,0,0,2,2,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,2,2,2,2,1,1,3,3,3,3,1,1,2,2,2,2,3,3,2,2,3,3,2,2,3,3,2,2,2,2,0,0,3,3,0,0,3,3,0,0,0,0,3,3,0,0,2,2,1,1,0,0,1,1,0,0,3,3,0,0,2,2,2,2,0,0,1,1,2,2,2,2,1,1,1,1,2,2,3,3,0,0,2,2,1,1,2,2,1,1,2,2,1,1,0,0,3,3,1,1,2,2,3,3,3,3,1,1,2,2,2,2,0,0,3,3,1,1,0,0,1,1,0,0,2,2,2,2,0,0,3,3,0,0,1,1,2,2,1,1,0,0,2,2,0,0,0,0,1,1,2,2,0,0,3,3,0,0,2,2,3,3,3,3,0,0,1,1,3,3,2,2,2,2,1,1,2,2,3,3,2,2,2,2,0,0,2,2,2,2,1,1,0,0,0,0,1,1,0,0,2,2,1,1,0,0,1,1,0,0,1,1,3,3,2,2,0,0,1,1,2,2,1,1,2,2,0,0,0,0,3,3,2,2,1,1,0,0,2,2,0,0,0,0,2,2,2,2,3,3,1,1,1,1,3,3,2,2,0,0,0,0,3,3,1,1,3,3,0,0,1,1,3,3,2,2,3,3,1,1,0,0,1,1,1,1,3,3,1,1,0,0,1,1,3,3,1,1,3,3,2,2,3,3,0,0,0,0,2,2,2,2,0,0,3,3,1,1,2,2,1,1,2,2,0,0,0,0,2,2,2,2,0,0,1,1,3,3,2,2,0,0,3,3,3,3,1,1,1,1,3,3,3,3,2,2,2,2,3,3,0,0,2,2,3,3,1,1,0,0,3,3,3,3,1,1,2,2,1,1,2,2,2,2,3,3,2,2,1,1,0,0,2,2,1,1,0,0,2,2,0,0,3,3,1,1,1,1,0,0,1,1,1,1,2,2,0,0,2,2,1,1,0,0,2,2,3,3,2,2,2,2,1,1,0,0,2,2,2,2,3,3,1,1,0,0,2,2,0,0,2,2,0,0,3,3,3,3,2,2,2,2,3,3,3,3,1,1,2,2,1,1,2,2,2,2,1,1,3,3,1,1,2,2,2,2,3,3,0,0,3,3,2,2,0,0,0,0,1,1,0,0,1,1,2,2,2,2,3,3,2,2,3,3,2,2,0,0,0,0,1,1,2,2,3,3,0,0,3,3,3,3,3,3,0,0,2,2,1,1,2,2,3,3,1,1,1,1,1,1,1,1,0,0,1,1,2,2,0,0,0,0,2,2,0,0,1,1,2,2,1,1,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,1,1,3,3,0,0,3,3,3,3,1,1,0,0,3,3,2,2,1,1,2,2,1,1,2,2,0,0,3,3,0,0,1,1,2,2,0,0,1,1,0,0,1,1,1,1,2,2,1,1,3,3,1,1,3,3,3,3,0,0,2,2,3,3,0,0,1,1,0,0,2,2,0,0,2,2,2,2,1,1,0,0,3,3,1,1,1,1,2,2,3,3,1,1,0,0,0,0,1,1,0,0,0,0,3,3,2,2,2,2,1,1,2,2,1,1,2,2,1,1,3,3,1,1,3,3,2,2,2,2,3,3,1,1,0,0,2,2,0,0,1,1,2,2,3,3,2,2,0,0,1,1,0,0,3,3,1,1,2,2,3,3,0,0,3,3,0,0,0,0,2,2,3,3,0,0,0,0,2,2,3,3,1,1,0,0,2,2,1,1,0,0,3,3,3,3,3,3,0,0,3,3,0,0,0,0,1,1,0,0,2,2,3,3,1,1,1,1,2,2,1,1,2,2,0,0,3,3,2,2,0,0,1,1,2,2,1,1,1,1,3,3,0,0,3,3,2,2,0,0,1,1,3,3,0,0,0,0,1,1,0,0,0,0,1,1,3,3,2,2,1,1,1,1,1,1,1,1,0,0,3,3,1,1,0,0,0,0,1,1,0,0,3,3,2,2,0,0,1,1,2,2,2,2,3,3,0,0,1,1,2,2,1,1,3,3,2,2,0,0,3,3,2,2,2,2,1,1,1,1,1,1,2,2,0,0,0,0,3,3,3,3,1,1,0,0,3,3,0,0,2,2,3,3,0,0,3,3,3,3,2,2,1,1,1,1,3,3,1,1,1,1,1,1,0,0,0,0,0,0,0,0,3,3,2,2,3,3,1,1,0,0,1,1,3,3,1,1,1,1,1,1,0,0,3,3,1,1,0,0,1,1,2,2,3,3,1,1,1,1,0,0,1,1,2,2,1,1,2,2,3,3,3,3,2,2,0,0,3,3,0,0,1,1,0,0,0,0,0,0,3,3,2,2,0,0,2,2,1,1,2,2,1,1,0,0,0,0,0,0,2,2,3,3,0,0,2,2,0,0,0,0,1,1,1,1,3,3,2,2,0,0,1,1,0,0,1,1,3,3,1,1,1,1,3,3,0,0,3,3,0,0,3,3,3,3,3,3,1,1,1,1,1,1,3,3,3,3,2,2,3,3,3,3,1,1,2,2,2,2,0,0,3,3,3,3,2,2,1,1,0,0,0,0,2,2,3,3,1,1,2,2,3,3,0,0,0,0,3,3,0,0,2,2,3,3,0,0,1,1,2,2,3,3,2,2,2,2,3,3,2,2,2,2,3,3,2,2,1,1,2,2,3,3,3,3,0,0,3,3,1,1,0,0,0,0,1,1,2,2,0,0,1,1,3,3,0,0,3,3,1,1,2,2,2,2,1,1,1,1,0,0,1,1,3,3,1,1,1,1,1,1,1,1,3,3,1,1,1,1,3,3,3,3,1,1,2,2,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,3,3,3,3,2,2,3,3,1,1,1,1,1,1,0,0,1,1,3,3,2,2,2,2,3,3,0,0,0,0,3,3,1,1,3,3,2,2,1,1,1,1,3,3,1,1,0,0,0,0,3,3,2,2,2,2,3,3,2,2,3,3,2,2,2,2,0,0,3,3,3,3,0,0,3,3,0,0,3,3,2,2,0,0,0,0,1,1,0,0,3,3,0,0,2,2,1,1,3,3,1,1,0,0,2,2,3,3,0,0,1,1,3,3,3,3,1,1,1,1,2,2,1,1,1,1,1,1,3,3,2,2,1,1,3,3,2,2,1,1,0,0,1,1,1,1,1,1,3,3,1,1,1,1,0,0,0,0,1,1,3,3,3,3,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,2,2,3,3,1,1,0,0,3,3,0,0,0,0,1,1,2,2,3,3,0,0,1,1,3,3,1,1,2,2,0,0,3,3,3,3,3,3,0,0,0,0,1,1,0,0,1,1,0,0,1,1,2,2,2,2,1,1,3,3,0,0,0,0,1,1,3,3,1,1,3,3,0,0,1,1,0,0,0,0,2,2,1,1,0,0,3,3,0,0,0,0,0,0,1,1,0,0,1,1,2,2,0,0,2,2,3,3,3,3,3,3,2,2,0,0,1,1,2,2,0,0,1,1,1,1,3,3,0,0,1,1,1,1,0,0,0,0,3,3,3,3,3,3,2,2,1,1,0,0,3,3,1,1,1,1,0,0,0,0,0,0,2,2,0,0,0,0,3,3,1,1,2,2,2,2,3,3,2,2,3,3,2,2,2,2,2,2,1,1,2,2,3,3,3,3,2,2,0,0,3,3,2,2,3,3,0,0,0,0,1,1,2,2,0,0,3,3,1,1,1,1,0,0,3,3,0,0,3,3,1,1,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,1,1,1,1,3,3,3,3,2,2,1,1,0,0,0,0,1,1,2,2,3,3,3,3,0,0,2,2,0,0,1,1,3,3,0,0,0,0,1,1,1,1,2,2,3,3,1,1,0,0,1,1,3,3,3,3,3,3,0,0,2,2,3,3,1,1,0,0,3,3,3,3,1,1,0,0,3,3,0,0,2,2,2,2,0,0,0,0,3,3,2,2,2,2,1,1,2,2,0,0,0,0,2,2,3,3,0,0,0,0,3,3,3,3,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,3,3,2,2,2,2,3,3,0,0,2,2,3,3,2,2,1,1,2,2,3,3,3,3,2,2,1,1,1,1,2,2,0,0,3,3,0,0,3,3,2,2,0,0,3,3,0,0,0,0,3,3,1,1,1,1,2,2,2,2,0,0,0,0,1,1,1,1,0,0,2,2,2,2,1,1,0,0,1,1,0,0,0,0,1,1,0,0,2,2,2,2,0,0,0,0,3,3,0,0,1,1,2,2,0,0,2,2,1,1,2,2,3,3,1,1,3,3,2,2,0,0,3,3,2,2,3,3,3,3,1,1,2,2,3,3,3,3,2,2,3,3,3,3,3,3,0,0,3,3,2,2,0,0,0,0,1,1,1,1,0,0,1,1,1,1,2,2,1,1,2,2,3,3,2,2,1,1,1,1,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,3,3,0,0,3,3,1,1,1,1,2,2,1,1,2,2,2,2,1,1,1,1,0,0,0,0,2,2,3,3,0,0,1,1,3,3,1,1,0,0,2,2,0,0,3,3,0,0,3,3,0,0,1,1,0,0,3,3,3,3,3,3,3,3,2,2,2,2,1,1,0,0,0,0,3,3,1,1,2,2,0,0,3,3,2,2,3,3,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,2,2,2,2,0,0,1,1,1,1,0,0,0,0,3,3,2,2,0,0,0,0,1,1,1,1,1,1,1,1,0,0,2,2,3,3,0,0,3,3,0,0,1,1,1,1,0,0,0,0,1,1,3,3,0,0,3,3,0,0,3,3,0,0,2,2,2,2,2,2,2,2,2,2,3,3,1,1,2,2,1,1,1,1,3,3,3,3,3,3,2,2,1,1,2,2,0,0,1,1,2,2,0,0,1,1,3,3,3,3,2,2,3,3,2,2,1,1,2,2,3,3,0,0,2,2,1,1,0,0,2,2,2,2,2,2,1,1,2,2,0,0,0,0,3,3,2,2,3,3,3,3,1,1,0,0,3,3,2,2,0,0,0,0,2,2,3,3,0,0,1,1,3,3,0,0,0,0,3,3,3,3,0,0,3,3,0,0,1,1,0,0,0,0,2,2,1,1,3,3,3,3,1,1,3,3,1,1,1,1,3,3,2,2,1,1,1,1,2,2,2,2,2,2,1,1,2,2,0,0,2,2,2,2,2,2,3,3,3,3,3,3,3,3,1,1,1,1,0,0,2,2,3,3,1,1,1,1,0,0,3,3,1,1,1,1,0,0,0,0,2,2,0,0,2,2,3,3,2,2,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,2,2,3,3,0,0,2,2,2,2,0,0,0,0,3,3,0,0,1,1,2,2,2,2,0,0,1,1,1,1,1,1,1,1,0,0,1,1,3,3,1,1,2,2,2,2,0,0,1,1,2,2,2,2,3,3,2,2,1,1,2,2,3,3,3,3,2,2,3,3,1,1,0,0,1,1,3,3,1,1,3,3,0,0,2,2,3,3,1,1,0,0,1,1,2,2,3,3,3,3,2,2,3,3,3,3,0,0,2,2,2,2,3,3,1,1,0,0,0,0,3,3,2,2,0,0,3,3,1,1,1,1,3,3,1,1,3,3,1,1,2,2,0,0,2,2,3,3,2,2,3,3,0,0,2,2,1,1,1,1,0,0,3,3,1,1,2,2,0,0,1,1,0,0,3,3,1,1,1,1,2,2,1,1,0,0,0,0,1,1,0,0,2,2,2,2,2,2,0,0,0,0,0,0,3,3,1,1,3,3,1,1,0,0,2,2,2,2,1,1,1,1,1,1,2,2,3,3,0,0,3,3,0,0,1,1,2,2,2,2,2,2,2,2,1,1,1,1,2,2,3,3,0,0,2,2,2,2,2,2,0,0,3,3,1,1,3,3,1,1,1,1,2,2,0,0,0,0,2,2,3,3,1,1,1,1,2,2,0,0,3,3,3,3,1,1,3,3,1,1,1,1,2,2,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,2,2,3,3,0,0,3,3,1,1,1,1,2,2,2,2,2,2,2,2,3,3,2,2,2,2,3,3,0,0,1,1,0,0,2,2,3,3,1,1,0,0,1,1,1,1,2,2,2,2,1,1,0,0,0,0,2,2,2,2,0,0,0,0,1,1,3,3,0,0,0,0,2,2,1,1,0,0,3,3,2,2,3,3,3,3,3,3,2,2,2,2,3,3,3,3,1,1,1,1,2,2,3,3,2,2,2,2,2,2,2,2,3,3,2,2,0,0,1,1,1,1,0,0,3,3,2,2,2,2,1,1,0,0,0,0,3,3,1,1,0,0,3,3,1,1,0,0,1,1,3,3,2,2,3,3,0,0,3,3,1,1,1,1,1,1,0,0,3,3,0,0,1,1,3,3,0,0,0,0,2,2,0,0,1,1,1,1,0,0,1,1,1,1,2,2,0,0,3,3,0,0,2,2,2,2,1,1,3,3,0,0,3,3,0,0,3,3,2,2,0,0,1,1,2,2,0,0,3,3,3,3,3,3,2,2,1,1,0,0,0,0,0,0,3,3,1,1,3,3,1,1,2,2,1,1,1,1,0,0,2,2,3,3,0,0,2,2,3,3,3,3,1,1,0,0,3,3,2,2,0,0,2,2,0,0,3,3,0,0,2,2,0,0,2,2,2,2,0,0,0,0,1,1,2,2,0,0,2,2,1,1,1,1,2,2,2,2,3,3,1,1,0,0,2,2,1,1,1,1,3,3,1,1,2,2,1,1,2,2,1,1,1,1,0,0,0,0,1,1,1,1,1,1,3,3,0,0,0,0,2,2,2,2,0,0,1,1,0,0,2,2,2,2,0,0,3,3,2,2,2,2,0,0,1,1,3,3,3,3,3,3,1,1,0,0,2,2,1,1,2,2,1,1,1,1,3,3,2,2,0,0,0,0,2,2,1,1,1,1,3,3,3,3,0,0,1,1,0,0,0,0,1,1,2,2,3,3,1,1,1,1,3,3,0,0,0,0,3,3,2,2,2,2,1,1,0,0,0,0,0,0,3,3,1,1,0,0,1,1,3,3,3,3,1,1,1,1,0,0,3,3,1,1,2,2,2,2,1,1,1,1,3,3,0,0,2,2,2,2,1,1,1,1,0,0,2,2,3,3,0,0,2,2,0,0,1,1,3,3,0,0,2,2,1,1,2,2,0,0,0,0,3,3,3,3,0,0,2,2,0,0,2,2,3,3,3,3,3,3,2,2,0,0,2,2,3,3,3,3,0,0,2,2,2,2,0,0,3,3,3,3,2,2,3,3,2,2,2,2,0,0,0,0,2,2,1,1,3,3,2,2,0,0,3,3,0,0,2,2,0,0,3,3,2,2,1,1,1,1,0,0,3,3,1,1,1,1,1,1,3,3,2,2,0,0,3,3,3,3,2,2,2,2,1,1,3,3,2,2,2,2,3,3,2,2,1,1,3,3,1,1,1,1,3,3,1,1,3,3,3,3,2,2,3,3,0,0,0,0,1,1,2,2,0,0,3,3,2,2,2,2,1,1,3,3,2,2,3,3,3,3,2,2,2,2,0,0,3,3,0,0,0,0,1,1,1,1,1,1,3,3,1,1,1,1,3,3,0,0,3,3,2,2,1,1,1,1,1,1,0,0,3,3,2,2,0,0,2,2,2,2,0,0,0,0,1,1,2,2,2,2,0,0,1,1,3,3,1,1,1,1,1,1,0,0,2,2,0,0,0,0,2,2,0,0,3,3,1,1,0,0,1,1,2,2,0,0,0,0,2,2,3,3,0,0,0,0,1,1,1,1,1,1,3,3,2,2,2,2,3,3,0,0,2,2,3,3,0,0,1,1,1,1,0,0,0,0,1,1,1,1,2,2,2,2,1,1,3,3,0,0,1,1,3,3,1,1,2,2,2,2,3,3,2,2,1,1,0,0,3,3,0,0,0,0,1,1,3,3,0,0,2,2,2,2,3,3,3,3,0,0,1,1,0,0,2,2,3,3,1,1,0,0,1,1,2,2,0,0,0,0,1,1,2,2,2,2,1,1,1,1,2,2,3,3,3,3,2,2,0,0,1,1,3,3,3,3,0,0,2,2,0,0,0,0,2,2,1,1,1,1,2,2,3,3,3,3,0,0,2,2,3,3,1,1,0,0,0,0,2,2,2,2,0,0,1,1,3,3,2,2,1,1,3,3,0,0,1,1,2,2,2,2,2,2,2,2,2,2,0,0,3,3,3,3,1,1,3,3,0,0,1,1,0,0,3,3,3,3,3,3,0,0,3,3,0,0,3,3,2,2,2,2,1,1,2,2,1,1,2,2,0,0,2,2,3,3,3,3,3,3,0,0,0,0,0,0,1,1,3,3,1,1,2,2,3,3,2,2,2,2,1,1,1,1,3,3,0,0,0,0,0,0,2,2,1,1,1,1,2,2,3,3,2,2,2,2,1,1,3,3,0,0,0,0,2,2,1,1,2,2,2,2,2,2,0,0,2,2,3,3,0,0,2,2,2,2,0,0,0,0,3,3,1,1,0,0,2,2,3,3,3,3,0,0,2,2,0,0,0,0,1,1,1,1,2,2,3,3,0,0,3,3,3,3,3,3,0,0,0,0,2,2,3,3,0,0,2,2,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,2,2,3,3,1,1,3,3,0,0,2,2,0,0,0,0,0,0,0,0,1,1,1,1,3,3,1,1,3,3,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,2,2,3,3,1,1,1,1,1,1,2,2,0,0,1,1,0,0,1,1,3,3,3,3,3,3,3,3,1,1,1,1,2,2,0,0,0,0,0,0,0,0,2,2,3,3,3,3,0,0,0,0,3,3,2,2,2,2,0,0,0,0,2,2,3,3,0,0,0,0,1,1,2,2,3,3,1,1,0,0,1,1,2,2,2,2,3,3,2,2,1,1,0,0,2,2,0,0,0,0,2,2,0,0,3,3,1,1,3,3,0,0,3,3,0,0,0,0,1,1,1,1,1,1,1,1,3,3,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,3,3,3,3,2,2,0,0,3,3,3,3,2,2,1,1,0,0,1,1,3,3,0,0,2,2,0,0,1,1,0,0,0,0,3,3,0,0,2,2,2,2,3,3,2,2,1,1,1,1,3,3,2,2,0,0,3,3,1,1,0,0,3,3,2,2,3,3,0,0,3,3,0,0,0,0,3,3,0,0,2,2,1,1,0,0,0,0,1,1,3,3,0,0,3,3,0,0,0,0,3,3,3,3,0,0,0,0,0,0,1,1,0,0,0,0,3,3,2,2,3,3,1,1,0,0,2,2,0,0,1,1,2,2,3,3,2,2,2,2,2,2,1,1,3,3,0,0,3,3,1,1,0,0,1,1,3,3,0,0,0,0,3,3,3,3,0,0,1,1,1,1,0,0,1,1,2,2,3,3,0,0,2,2,3,3,3,3,2,2,1,1,3,3,2,2,1,1,2,2,0,0,0,0,0,0,1,1,1,1,1,1,3,3,2,2,1,1,0,0,2,2,1,1,1,1,1,1,0,0,0,0,2,2,3,3,3,3,2,2,2,2,1,1,3,3,3,3,0,0,3,3,3,3,0,0,3,3,1,1,2,2,1,1,0,0,1,1,0,0,0,0,1,1,2,2,3,3,0,0,3,3,3,3,0,0,3,3,0,0,1,1,0,0,3,3,0,0,2,2,1,1,3,3,1,1,2,2,2,2,1,1,2,2,0,0,0,0,1,1,2,2,1,1,0,0,1,1,2,2,0,0,2,2,1,1,1,1,1,1,0,0,1,1,1,1,3,3,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,3,3,0,0,1,1,0,0,0,0,1,1,0,0,1,1,3,3,3,3,2,2,3,3,0,0,2,2,0,0,0,0,3,3,2,2,3,3,0,0,3,3,3,3,0,0,3,3,2,2,0,0,2,2,1,1,3,3,2,2,1,1,0,0,3,3,0,0,2,2,3,3,2,2,3,3,0,0,1,1,2,2,1,1,1,1,1,1,1,1,2,2,3,3,1,1,1,1,3,3,0,0,0,0,2,2,3,3,0,0,1,1,1,1,3,3,3,3,0,0,3,3,2,2,3,3,2,2,3,3,0,0,1,1,3,3,0,0,0,0,3,3,2,2,3,3,0,0,0,0,0,0,1,1,3,3,1,1,1,1,0,0,1,1,1,1,3,3,2,2,2,2,0,0,3,3,0,0,1,1,0,0,0,0,3,3,0,0,0,0,3,3,3,3,3,3,1,1,2,2,3,3,3,3,3,3,2,2,1,1,0,0,3,3,1,1,2,2,2,2,0,0,2,2,2,2,0,0,2,2,1,1,2,2,3,3,2,2,2,2,0,0,1,1,1,1,1,1,2,2,3,3,0,0,1,1,3,3,3,3,3,3,1,1,0,0,0,0,3,3,2,2,2,2,0,0,3,3,2,2,0,0,2,2,2,2,1,1,0,0,2,2,0,0,2,2,1,1,2,2,0,0,0,0,3,3,1,1,1,1,3,3,0,0,3,3,2,2,0,0,3,3,0,0,1,1,2,2,2,2,0,0,1,1,0,0,3,3,2,2,1,1,1,1,0,0,2,2,3,3,0,0,0,0,3,3,1,1,3,3,0,0,0,0,2,2,1,1,0,0,0,0,0,0,2,2,2,2,1,1,3,3,1,1,3,3,2,2,2,2,0,0,0,0,1,1,0,0,2,2,1,1,2,2,2,2,1,1,3,3,2,2,3,3,1,1,3,3,2,2,0,0,1,1,3,3,1,1,0,0,0,0,3,3,3,3,0,0,1,1,1,1,1,1,0,0,1,1,0,0,3,3,1,1,3,3,2,2,1,1,0,0,2,2,0,0,1,1,0,0,1,1,2,2,0,0,1,1,1,1,2,2,1,1,1,1,0,0,0,0,2,2,1,1,3,3,3,3,3,3,0,0,2,2,0,0,0,0,3,3,3,3,2,2,0,0,0,0,3,3,1,1,0,0,0,0,1,1,3,3,3,3,0,0,0,0,1,1,3,3,1,1,1,1,3,3,1,1,2,2,0,0,1,1,3,3,3,3,1,1,2,2,1,1,0,0,1,1,0,0,3,3,3,3,1,1,2,2,1,1,0,0,2,2,2,2,1,1,3,3,2,2,0,0,2,2,0,0,3,3,0,0,2,2,0,0,1,1,0,0,3,3,0,0,0,0,1,1,2,2,0,0,3,3,2,2,1,1,3,3,3,3,3,3,1,1,3,3,2,2,2,2,1,1,1,1,0,0,2,2,1,1,2,2,1,1,1,1,2,2,1,1,3,3,3,3,3,3,2,2,0,0,3,3,1,1,2,2,0,0,3,3,0,0,3,3,0,0,2,2,3,3,3,3,1,1,1,1,0,0,0,0,3,3,1,1,1,1,0,0,1,1,0,0,1,1,2,2,3,3,0,0,2,2,1,1,2,2,0,0,3,3,3,3,2,2,0,0,3,3,2,2,1,1,1,1,2,2,2,2,2,2,2,2,3,3,0,0,3,3,0,0,1,1,0,0,2,2,1,1,3,3,2,2,0,0,3,3,1,1,3,3,3,3,1,1,3,3,1,1,2,2,1,1,1,1,3,3,1,1,1,1,1,1,0,0,1,1,3,3,0,0,2,2,0,0,0,0,0,0,3,3,2,2,2,2,1,1,0,0,3,3,2,2,0,0,3,3,0,0,3,3,0,0,3,3,3,3,2,2,0,0,3,3,3,3,1,1,1,1,0,0,1,1,1,1,3,3,3,3,1,1,0,0,1,1,0,0,1,1,2,2,3,3,1,1,2,2,0,0,1,1,3,3,3,3,2,2,2,2,0,0,0,0,2,2,0,0,3,3,0,0,2,2,0,0,2,2,0,0,3,3,0,0,3,3,0,0,0,0,0,0,1,1,0,0,2,2,2,2,0,0,0,0,1,1,2,2,3,3,3,3,2,2,0,0,2,2,1,1,0,0,3,3,1,1,1,1,3,3,1,1,1,1,0,0,1,1,0,0,2,2,0,0,1,1,2,2,2,2,0,0,1,1,1,1,0,0,2,2,3,3,3,3,2,2,2,2,2,2,3,3,1,1,1,1,1,1,2,2,2,2,1,1,2,2,1,1,3,3,0,0,3,3,1,1,0,0,1,1,3,3,0,0,2,2,0,0,1,1,2,2,0,0,2,2,3,3,1,1,0,0,2,2,2,2,3,3,3,3,0,0,3,3,3,3,2,2,0,0,2,2,2,2,3,3,1,1,0,0,1,1,1,1,0,0,3,3,2,2,3,3,1,1,0,0,0,0,1,1,3,3,1,1,1,1,1,1,0,0,0,0,3,3,2,2,2,2,3,3,0,0,1,1,3,3,3,3,1,1,2,2,2,2,3,3,3,3,1,1,2,2,3,3,3,3,1,1,2,2,2,2,1,1,3,3,1,1,3,3,2,2,0,0,2,2,1,1,0,0,1,1,0,0,2,2,0,0,0,0,2,2,3,3,1,1,2,2,0,0,2,2,3,3,1,1,2,2,1,1,3,3,1,1,1,1,3,3,3,3,1,1,0,0,0,0,1,1,3,3,2,2,1,1,0,0,1,1,2,2,1,1,1,1,1,1,0,0,1,1,0,0,2,2,1,1,3,3,2,2,3,3,2,2,3,3,3,3,1,1,3,3,1,1,0,0,3,3,0,0,0,0,2,2,1,1,2,2,0,0,2,2,0,0,0,0,0,0,1,1,2,2,3,3,3,3,0,0,2,2,0,0,1,1,0,0,0,0,1,1,1,1,2,2,0,0,3,3,2,2,3,3,2,2,0,0,3,3,3,3,2,2,3,3,1,1,3,3,1,1,0,0,0,0,1,1,3,3,3,3,2,2,3,3,1,1,2,2,0,0,1,1,2,2,2,2,3,3,1,1,3,3,2,2,1,1,2,2,2,2,0,0,0,0,0,0,0,0,1,1,3,3,3,3,0,0,2,2,1,1,2,2,0,0,0,0,2,2,2,2,0,0,3,3,2,2,2,2,1,1,2,2,2,2,1,1,1,1,2,2,1,1,2,2,2,2,3,3,2,2,0,0,1,1,1,1,0,0,0,0,0,0,2,2,2,2,0,0,0,0,3,3,0,0,3,3,1,1,2,2,0,0,3,3,0,0,3,3,3,3,0,0,3,3,1,1,2,2,3,3,0,0,1,1,3,3,1,1,1,1,1,1,1,1,0,0,1,1,0,0,3,3,1,1,1,1,3,3,3,3,1,1,2,2,0,0,2,2,0,0,0,0,1,1,2,2,0,0,2,2,1,1,2,2,2,2,0,0,2,2,2,2,1,1,3,3,0,0,1,1,0,0,1,1,3,3,2,2,0,0,1,1,0,0,2,2,0,0,3,3,0,0,1,1,0,0,3,3,2,2,0,0,1,1,1,1,3,3,2,2,0,0,3,3,1,1,2,2,1,1,1,1,3,3,0,0,3,3,1,1,1,1,0,0,0,0,2,2,0,0,1,1,1,1,2,2,3,3,2,2,3,3,0,0,1,1,1,1,3,3,1,1,3,3,1,1,3,3,3,3,2,2,2,2,2,2,3,3,2,2,1,1,2,2,2,2,3,3,1,1,2,2,1,1,0,0,0,0,0,0,1,1,0,0,2,2,3,3,3,3,1,1,1,1,3,3,2,2,1,1,1,1,0,0,2,2,0,0,3,3,2,2,0,0,1,1,0,0,2,2,2,2,2,2,1,1,1,1,1,1,1,1,3,3,2,2,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,2,2,3,3,2,2,1,1,1,1,1,1,0,0,1,1,3,3,1,1,3,3,3,3,2,2,2,2,1,1,1,1,0,0,3,3,0,0,0,0,0,0,2,2,3,3,3,3,1,1,3,3,0,0,2,2,3,3,1,1,2,2,1,1,1,1,1,1,2,2,3,3,1,1,3,3,3,3,2,2,1,1,0,0,0,0,2,2,2,2,0,0,0,0,1,1,1,1,0,0,1,1,2,2,0,0,2,2,3,3,2,2,1,1,1,1,1,1,2,2,0,0,2,2,0,0,2,2,2,2,1,1,0,0,2,2,1,1,0,0,1,1,2,2,1,1,1,1,3,3,3,3,0,0,0,0,0,0,0,0,3,3,3,3,2,2,0,0,0,0,3,3,3,3,2,2,2,2,1,1,2,2,2,2,3,3,1,1,0,0,3,3,1,1,3,3,2,2,1,1,0,0,2,2,1,1,2,2,3,3,2,2,0,0,1,1,0,0,0,0,2,2,0,0,3,3,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,2,2,0,0,3,3,3,3,3,3,0,0,1,1,3,3,1,1,1,1,3,3,3,3,0,0,0,0,2,2,0,0,0,0,1,1,0,0,1,1,1,1,1,1,2,2,0,0,3,3,0,0,0,0,3,3,3,3,0,0,0,0,0,0,3,3,1,1,2,2,0,0,0,0,1,1,0,0,1,1,2,2,2,2,0,0,2,2,2,2,2,2,3,3,2,2,0,0,2,2,0,0,0,0,3,3,0,0,3,3,2,2,1,1,2,2,1,1,1,1,2,2,0,0,2,2,1,1,1,1,0,0,0,0,3,3,3,3,2,2,3,3,3,3,3,3,3,3,1,1,3,3,2,2,0,0,2,2,3,3,2,2,0,0,0,0,2,2,2,2,0,0,3,3,3,3,1,1,0,0,3,3,0,0,2,2,1,1,0,0,1,1,2,2,0,0,0,0,2,2,0,0,3,3,2,2,3,3,2,2,0,0,3,3,1,1,1,1,1,1,3,3,1,1,2,2,2,2,3,3,3,3,3,3,1,1,3,3,2,2,0,0,3,3,0,0,0,0,3,3,3,3,1,1,2,2,0,0,2,2,2,2,3,3,3,3,0,0,3,3,1,1,2,2,3,3,2,2,0,0,1,1,2,2,2,2,0,0,3,3,0,0,0,0,2,2,3,3,3,3,1,1,2,2,1,1,3,3,3,3,3,3,0,0,2,2,2,2,0,0,1,1,2,2,1,1,2,2,0,0,0,0,1,1,2,2,1,1,0,0,2,2,3,3,0,0,2,2,1,1,1,1,3,3,0,0,1,1,3,3,0,0,0,0,2,2,1,1,0,0,1,1,0,0,0,0,2,2,3,3,2,2,0,0,0,0,0,0,0,0,1,1,2,2,1,1,1,1,2,2,3,3,0,0,0,0,2,2,0,0,2,2,1,1,1,1,2,2,3,3,2,2,1,1,3,3,1,1,0,0,2,2,0,0,3,3,0,0,1,1,0,0,3,3,2,2,0,0,0,0,3,3,1,1,3,3,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,2,2,0,0,2,2,3,3,2,2,2,2,0,0,3,3,2,2,0,0,1,1,3,3,2,2,3,3,1,1,0,0,1,1,2,2,1,1,2,2,2,2,1,1,1,1,1,1,3,3,2,2,0,0,2,2,2,2,3,3,2,2,1,1,1,1,1,1,3,3,3,3,3,3,2,2,3,3,3,3,1,1,0,0,0,0,2,2,0,0,3,3,1,1,1,1,3,3,2,2,1,1,0,0,0,0,0,0,0,0,0,0,3,3,1,1,1,1,1,1,3,3,2,2,2,2,2,2,0,0,1,1,0,0,0,0,2,2,2,2,2,2,0,0,2,2,3,3,1,1,0,0,0,0,3,3,1,1,3,3,2,2,1,1,1,1,2,2,0,0,1,1,0,0,1,1,2,2,3,3,2,2,1,1,2,2,0,0,0,0,2,2,2,2,2,2,3,3,2,2,0,0,3,3,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,3,3,2,2,3,3,0,0,0,0,2,2,1,1,0,0,1,1,0,0,0,0,3,3,3,3,0,0,0,0,1,1,2,2,2,2,1,1,0,0,2,2,0,0,0,0,0,0,1,1,2,2,2,2,3,3,1,1,3,3,3,3,3,3,2,2,1,1,0,0,3,3,0,0,2,2,0,0,0,0,0,0,3,3,2,2,1,1,0,0,3,3,0,0,3,3,0,0,2,2,3,3,0,0,2,2,0,0,1,1,0,0,2,2,0,0,0,0,2,2,2,2,3,3,2,2,0,0,0,0,3,3,2,2,1,1,3,3,0,0,2,2,3,3,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,2,2,0,0,0,0,0,0,2,2,2,2,0,0,1,1,0,0,0,0,3,3,1,1,2,2,3,3,3,3,3,3,2,2,2,2,1,1,0,0,2,2,2,2,0,0,3,3,1,1,2,2,1,1,3,3,0,0,1,1,1,1,1,1,2,2,2,2,1,1,3,3,3,3,3,3,0,0,2,2,0,0,1,1,3,3,0,0,3,3,1,1,3,3,1,1,1,1,0,0,2,2,1,1,0,0,0,0,3,3,3,3,1,1,1,1,1,1,3,3,2,2,1,1,1,1,0,0,1,1,0,0,2,2,3,3,0,0,0,0,3,3,1,1,0,0,3,3,2,2,3,3,2,2,3,3,2,2,1,1,0,0,0,0,1,1,0,0,3,3,1,1,0,0,3,3,1,1,1,1,2,2,0,0,1,1,0,0,0,0,3,3,3,3,0,0,1,1,1,1,3,3,0,0,0,0,3,3,0,0,0,0,1,1,2,2,2,2,2,2,2,2,1,1,0,0,2,2,1,1,1,1,2,2,2,2,2,2,2,2,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,3,3,2,2,2,2,1,1,1,1,3,3,0,0,2,2,2,2,1,1,0,0,1,1,2,2,2,2,0,0,3,3,2,2,2,2,2,2,3,3,0,0,1,1,3,3,3,3,1,1,2,2,3,3,2,2,2,2,2,2,1,1,0,0,0,0,1,1,1,1,1,1,2,2,0,0,1,1,3,3,1,1,2,2,0,0,2,2,0,0,3,3,2,2,1,1,1,1,3,3,0,0,2,2,0,0,0,0,0,0,1,1,3,3,3,3,2,2,1,1,0,0,2,2,0,0,2,2,2,2,3,3,3,3,1,1,2,2,1,1,1,1,3,3,0,0,2,2,1,1,0,0,3,3,0,0,1,1,2,2,0,0,2,2,2,2,2,2,3,3,3,3,1,1,2,2,3,3,1,1,0,0,2,2,1,1,0,0,1,1,2,2,1,1,2,2,2,2,2,2,2,2,0,0,2,2,3,3,2,2,2,2,3,3,3,3,2,2,1,1,1,1,0,0,2,2,3,3,0,0,2,2,0,0,3,3,1,1,2,2,3,3,0,0,1,1,2,2,2,2,1,1,1,1,3,3,1,1,1,1,2,2,2,2,2,2,1,1,2,2,0,0,3,3,0,0,1,1,2,2,1,1,2,2,0,0,3,3,0,0,3,3,1,1,3,3,2,2,3,3,2,2,1,1,2,2,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,2,2,0,0,3,3,3,3,0,0,3,3,2,2,1,1,3,3,3,3,0,0,1,1,1,1,0,0,3,3,0,0,2,2,0,0,0,0,1,1,2,2,0,0,3,3,1,1,2,2,0,0,1,1,3,3,1,1,1,1,2,2,1,1,0,0,0,0,0,0,2,2,3,3,3,3,3,3,2,2,0,0,2,2,0,0,2,2,3,3,3,3,2,2,2,2,0,0,3,3,3,3,2,2,3,3,1,1,2,2,2,2,0,0,2,2,2,2,3,3,1,1,2,2,2,2,1,1,2,2,3,3,1,1,2,2,0,0,0,0,1,1,2,2,1,1,1,1,3,3,0,0,1,1,0,0,1,1,0,0,3,3,3,3,1,1,3,3,3,3,3,3,3,3,1,1,0,0,3,3,2,2,1,1,1,1,1,1,3,3,1,1,3,3,2,2,3,3,2,2,1,1,2,2,1,1,3,3,2,2,3,3,3,3,3,3,2,2,3,3,3,3,1,1,3,3,0,0,0,0,2,2,3,3,1,1,1,1,0,0,2,2,0,0,0,0,3,3,3,3,2,2,1,1,2,2,2,2,3,3,2,2,2,2,3,3,3,3,2,2,0,0,3,3,3,3,1,1,1,1,0,0,1,1,0,0,2,2,1,1,2,2,2,2,0,0,1,1,3,3,2,2,1,1,2,2,3,3,0,0,0,0,1,1,1,1,2,2,1,1,2,2,2,2,2,2,0,0,2,2,1,1,3,3,2,2,0,0,0,0,1,1,0,0,3,3,1,1,2,2,1,1,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,1,1,3,3,0,0,1,1,1,1,1,1,3,3,0,0,2,2,2,2,1,1,3,3,0,0,2,2,0,0,2,2,2,2,1,1,1,1,2,2,2,2,3,3,3,3,2,2,0,0,0,0,2,2,0,0,2,2,3,3,2,2,1,1,3,3,0,0,0,0,0,0,2,2,0,0,0,0,3,3,1,1,2,2,2,2,2,2,2,2,3,3,0,0,3,3,0,0,0,0,0,0,1,1,3,3,3,3,2,2,0,0,3,3,1,1,2,2,2,2,3,3,2,2,0,0,3,3,3,3,1,1,0,0,1,1,3,3,1,1,2,2,3,3,1,1,2,2,1,1,1,1,3,3,3,3,3,3,2,2,0,0,2,2,2,2,3,3,0,0,3,3,1,1,1,1,0,0,1,1,1,1,3,3,3,3,2,2,2,2,2,2,0,0,1,1,0,0,0,0,3,3,0,0,1,1,1,1,2,2,1,1,2,2,0,0,0,0,0,0,2,2,0,0,1,1,0,0,1,1,0,0,1,1,2,2,1,1,0,0,0,0,1,1,3,3,0,0,1,1,3,3,2,2,1,1,0,0,1,1,3,3,1,1,0,0,1,1,1,1,3,3,3,3,0,0,1,1,2,2,2,2,1,1,1,1,3,3,1,1,0,0,1,1,0,0,3,3,2,2,3,3,2,2,1,1,3,3,1,1,2,2,3,3,3,3,0,0,1,1,1,1,3,3,3,3,2,2,2,2,0,0,3,3,0,0,0,0,0,0,2,2,3,3,2,2,3,3,0,0,2,2,3,3,2,2,0,0,0,0,1,1,0,0,1,1,2,2,3,3,2,2,1,1,0,0,2,2,3,3,2,2,1,1,3,3,3,3,0,0,3,3,0,0,0,0,2,2,3,3,0,0,3,3,1,1,1,1,0,0,0,0,2,2,2,2,0,0,0,0,2,2,3,3,3,3,1,1,3,3,1,1,3,3,3,3,2,2,2,2,3,3,0,0,0,0,3,3,1,1,0,0,2,2,2,2,0,0,2,2,0,0,3,3,2,2,2,2,1,1,1,1,0,0,0,0,2,2,0,0,2,2,2,2,1,1,3,3,2,2,1,1,3,3,2,2,1,1,3,3,2,2,0,0,3,3,3,3,3,3,1,1,3,3,3,3,0,0,3,3,0,0,0,0,1,1,1,1,0,0,3,3,3,3,2,2,2,2,2,2,2,2,3,3,1,1,0,0,2,2,1,1,2,2,2,2,1,1,0,0,3,3,1,1,1,1,3,3,0,0,1,1,2,2,0,0,1,1,3,3,0,0,2,2,2,2,2,2,2,2,1,1,3,3,2,2,3,3,2,2,0,0,3,3,3,3,2,2,1,1,3,3,3,3,2,2,3,3,1,1,1,1,2,2,2,2,1,1,0,0,1,1,2,2,3,3,2,2,3,3,2,2,3,3,1,1,2,2,1,1,3,3,0,0,0,0,2,2,0,0,3,3,2,2,1,1,0,0,3,3,0,0,2,2,1,1,2,2,2,2,3,3,0,0,0,0,1,1,1,1,2,2,0,0,1,1,1,1,3,3,3,3,3,3,1,1,0,0,0,0,0,0,0,0,0,0,0,0,2,2,3,3,0,0,1,1,0,0,1,1,0,0,0,0,3,3,1,1,3,3,2,2,0,0,3,3,3,3,3,3,3,3,1,1,2,2,1,1,2,2,1,1,0,0,3,3,2,2,3,3,2,2,1,1,0,0,2,2,0,0,2,2,2,2,2,2,1,1,3,3,0,0,0,0,1,1,0,0,2,2,1,1,0,0,0,0,3,3,1,1,0,0,3,3,3,3,2,2,0,0,3,3,2,2,0,0,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,3,3,2,2,0,0,2,2,3,3,2,2,0,0,3,3,1,1,2,2,2,2,2,2,2,2,0,0,1,1,0,0,1,1,1,1,2,2,3,3,2,2,0,0,3,3,1,1,1,1,0,0,3,3,0,0,2,2,2,2,0,0,1,1,2,2,1,1,3,3,0,0,3,3,2,2,1,1,2,2,2,2,0,0,1,1,3,3,1,1,2,2,1,1,2,2,3,3,3,3,2,2,1,1,0,0,1,1,0,0,3,3,1,1,0,0,0,0,0,0,1,1,3,3,3,3,0,0,0,0,0,0,1,1,1,1,2,2,0,0,1,1,2,2,3,3,0,0,1,1,1,1,2,2,3,3,3,3,3,3,1,1,1,1,2,2,1,1,2,2,2,2,2,2,1,1,2,2,2,2,1,1,2,2,3,3,3,3,0,0,1,1,0,0,0,0,0,0,2,2,2,2,3,3,0,0,3,3,0,0,1,1,0,0,1,1,2,2,3,3,3,3,3,3,3,3,0,0,0,0,2,2,1,1,1,1,1,1,0,0,1,1,3,3,1,1,0,0,1,1,0,0,1,1,1,1,3,3,1,1,0,0,2,2,1,1,2,2,0,0,0,0,1,1,1,1,2,2,3,3,3,3,2,2,1,1,0,0,2,2,0,0,3,3,3,3,3,3,1,1,3,3,0,0,3,3,1,1,3,3,0,0,1,1,3,3,1,1,1,1,1,1,3,3,0,0,2,2,2,2,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,3,3,2,2,1,1,0,0,2,2,0,0,2,2,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,3,3,3,3,1,1,2,2,2,2,2,2,0,0,1,1,1,1,2,2,3,3,0,0,2,2,2,2,3,3,1,1,3,3,3,3,1,1,1,1,3,3,2,2,1,1,3,3,2,2,3,3,1,1,0,0,1,1,0,0,0,0,2,2,0,0,3,3,0,0,3,3,1,1,0,0,3,3,0,0,0,0,3,3,0,0,1,1,0,0,3,3,2,2,1,1,0,0,2,2,0,0,2,2,1,1,2,2,3,3,0,0,2,2,0,0,0,0,3,3,1,1,2,2,2,2,3,3,3,3,1,1,0,0,0,0,3,3,0,0,2,2,3,3,2,2,0,0,3,3,1,1,0,0,2,2,0,0,3,3,2,2,3,3,2,2,3,3,3,3,2,2,1,1,1,1,3,3,2,2,3,3,1,1,3,3,1,1,2,2,1,1,2,2,0,0,1,1,1,1,2,2,1,1,3,3,0,0,3,3,2,2,0,0,3,3,3,3,3,3,1,1,0,0,0,0,2,2,0,0,1,1,3,3,3,3,3,3,3,3,3,3,0,0,3,3,0,0,1,1,0,0,1,1,0,0,0,0,3,3,1,1,0,0,2,2,0,0,2,2,3,3,2,2,3,3,0,0,0,0,3,3,0,0,3,3,3,3,3,3,2,2,2,2,1,1,1,1,3,3,0,0,0,0,0,0,0,0,2,2,2,2,1,1,3,3,1,1,0,0,0,0,3,3,2,2,1,1,1,1,3,3,2,2,1,1,0,0,3,3,2,2,0,0,1,1,1,1,1,1,1,1,3,3,0,0,0,0,2,2,2,2,2,2,0,0,2,2,1,1,0,0,0,0,0,0,2,2,3,3,0,0,1,1,2,2,3,3,0,0,0,0,0,0,1,1,3,3,2,2,2,2,0,0,1,1,0,0,1,1,2,2,2,2,1,1,0,0,0,0,0,0,0,0,2,2,3,3,2,2,3,3,1,1,0,0,0,0,0,0,0,0,3,3,0,0,0,0,3,3,3,3,2,2,0,0,0,0,3,3,0,0,1,1,2,2,0,0,0,0,2,2,0,0,1,1,2,2,3,3,2,2,0,0,2,2,0,0,0,0,0,0,1,1,3,3,2,2,1,1,0,0,0,0,3,3,1,1,2,2,1,1,3,3,3,3,1,1,2,2,2,2,2,2,1,1,3,3,0,0,2,2,3,3,1,1,3,3,3,3,2,2,2,2,1,1,2,2,3,3,1,1,1,1,2,2,0,0,2,2,2,2,3,3,2,2,0,0,3,3,1,1,1,1,0,0,2,2,2,2,1,1,2,2,1,1,2,2,0,0,1,1,3,3,3,3,3,3,2,2,0,0,3,3,1,1,0,0,0,0,2,2,1,1,3,3,2,2,1,1,3,3,0,0,1,1,3,3,1,1,0,0,2,2,3,3,2,2,1,1,0,0,2,2,3,3,2,2,2,2,2,2,3,3,1,1,0,0,0,0,0,0,0,0,0,0,0,0,3,3,1,1,1,1,2,2,0,0,2,2,3,3,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,0,0,1,1,2,2,1,1,1,1,1,1,2,2,3,3,0,0,1,1,1,1,2,2,3,3,0,0,3,3,1,1,1,1,3,3,2,2,1,1,3,3,3,3,0,0,0,0,1,1,2,2,2,2,0,0,2,2,2,2,3,3,2,2,3,3,3,3,3,3,2,2,1,1,3,3,0,0,3,3,1,1,2,2,3,3,0,0,2,2,2,2,1,1,3,3,0,0,3,3,0,0,0,0,1,1,2,2,2,2,1,1,1,1,1,1,3,3,1,1,0,0,2,2,1,1,3,3,3,3,3,3,0,0,1,1,1,1,2,2,2,2,3,3,1,1,2,2,2,2,2,2,0,0,0,0,2,2,2,2,3,3,2,2,3,3,0,0,2,2,0,0,3,3,3,3,0,0,0,0,3,3,0,0,1,1,0,0,3,3,2,2,2,2,3,3,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,2,2,0,0,0,0,2,2,1,1,0,0,0,0,0,0,1,1,0,0,2,2,2,2,0,0,0,0,3,3,1,1,2,2,1,1,2,2,1,1,2,2,0,0,3,3,1,1,0,0,2,2,2,2,1,1,0,0,0,0,3,3,3,3,3,3,0,0,0,0,1,1,1,1,2,2,1,1,1,1,0,0,3,3,1,1,0,0,1,1,3,3,1,1,2,2,2,2,0,0,1,1,0,0,1,1,1,1,3,3,0,0,0,0,2,2,0,0,2,2,0,0,3,3,3,3,1,1,3,3,3,3,0,0,0,0,2,2,1,1,1,1,0,0,3,3,3,3,1,1,2,2,2,2,3,3,3,3,0,0,1,1,1,1,2,2,2,2,1,1,2,2,3,3,0,0,1,1,1,1,1,1,0,0,2,2,2,2,2,2,1,1,3,3,2,2,0,0,2,2,1,1,3,3,2,2,0,0,3,3,1,1,1,1,3,3,0,0,1,1,3,3,0,0,3,3,0,0,0,0,0,0,1,1,1,1,1,1,2,2,0,0,0,0,1,1,1,1,3,3,3,3,1,1,0,0,1,1,0,0,2,2,2,2,1,1,1,1,0,0,3,3,0,0,2,2,3,3,3,3,1,1,3,3,0,0,0,0,2,2,3,3,0,0,2,2,0,0,3,3,3,3,3,3,2,2,0,0,1,1,1,1,1,1,3,3,0,0,0,0,0,0,0,0,2,2,0,0,3,3,0,0,0,0,1,1,0,0,3,3,0,0,2,2,2,2,0,0,0,0,2,2,0,0,0,0,0,0,3,3,2,2,3,3,0,0,1,1,2,2,2,2,2,2,1,1,0,0,2,2,3,3,2,2,1,1,2,2,1,1,0,0,1,1,2,2,0,0,3,3,1,1,3,3,3,3,1,1,2,2,1,1,1,1,3,3,0,0,1,1,3,3,0,0,2,2,3,3,3,3,0,0,2,2,3,3,0,0,2,2,2,2,2,2,3,3,0,0,1,1,0,0,3,3,1,1,0,0,0,0,2,2,0,0,3,3,2,2,2,2,2,2,1,1,3,3,1,1,0,0,2,2,1,1,0,0,2,2,3,3,1,1,2,2,2,2,3,3,0,0,0,0,3,3,3,3,3,3,0,0,3,3,1,1,3,3,2,2,0,0,0,0,3,3,2,2,1,1,1,1,1,1,1,1,0,0,2,2,1,1,2,2,2,2,3,3,1,1,1,1,3,3,3,3,0,0,3,3,1,1,3,3,0,0,1,1,1,1,3,3,2,2,2,2,2,2,1,1,0,0,3,3,2,2,0,0,2,2,2,2,1,1,2,2,2,2,3,3,3,3,1,1,0,0,2,2,0,0,3,3,3,3,3,3,1,1,3,3,3,3,3,3,2,2,1,1,3,3,3,3,2,2,0,0,3,3,2,2,2,2,2,2,3,3,0,0,3,3,0,0,1,1,0,0,1,1,3,3,3,3,0,0,1,1,1,1,0,0,0,0,3,3,0,0,0,0,2,2,3,3,3,3,0,0,1,1,0,0,3,3,1,1,1,1,1,1,3,3,0,0,3,3,1,1,3,3,2,2,2,2,1,1,0,0,0,0,1,1,3,3,3,3,3,3,1,1,3,3,3,3,2,2,0,0,2,2,1,1,1,1,3,3,1,1,1,1,0,0,0,0,2,2,1,1,0,0,1,1,1,1,2,2,1,1,0,0,2,2,3,3,3,3,3,3,3,3,3,3,0,0,3,3,1,1,1,1,2,2,3,3,3,3,2,2,2,2,1,1,1,1,2,2,3,3,2,2,0,0,3,3,2,2,2,2,3,3,0,0,1,1,2,2,1,1,0,0,1,1,1,1,2,2,3,3,0,0,0,0,3,3,2,2,2,2,0,0,0,0,1,1,0,0,3,3,2,2,3,3,1,1,2,2,0,0,2,2,3,3,3,3,2,2,2,2,1,1,0,0,0,0,2,2,0,0,0,0,2,2,3,3,1,1,2,2,2,2,1,1,3,3,3,3,0,0,3,3,2,2,2,2,1,1,3,3,3,3,1,1,3,3,2,2,0,0,2,2,0,0,2,2,2,2,2,2,3,3,3,3,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,3,3,0,0,3,3,1,1,0,0,0,0,2,2,1,1,0,0,1,1,1,1,1,1,3,3,0,0,3,3,2,2,0,0,3,3,1,1,0,0,2,2,3,3,3,3,1,1,1,1,0,0,0,0,1,1,1,1,3,3,2,2,2,2,0,0,2,2,2,2,2,2,0,0,2,2,2,2,0,0,0,0,2,2,3,3,2,2,3,3,3,3,0,0,2,2,2,2,2,2,1,1,1,1,1,1,3,3,0,0,1,1,2,2,0,0,1,1,3,3,1,1,3,3,2,2,3,3,1,1,2,2,1,1,2,2,0,0,0,0,3,3,0,0,1,1,0,0,0,0,3,3,2,2,0,0,3,3,0,0,0,0,3,3,1,1,3,3,0,0,1,1,2,2,3,3,1,1,2,2,1,1,1,1,0,0,0,0,2,2,1,1,3,3,3,3,1,1,0,0,1,1,0,0,0,0,2,2,2,2,1,1,1,1,2,2,1,1,1,1,3,3,1,1,3,3,1,1,2,2,2,2,1,1,3,3,3,3,3,3,1,1,2,2,1,1,1,1,1,1,1,1,0,0,1,1,2,2,0,0,0,0,2,2,2,2,1,1,3,3,0,0,2,2,1,1,3,3,3,3,3,3,0,0,1,1,0,0,0,0,1,1,0,0,2,2,1,1,1,1,0,0,3,3,0,0,1,1,1,1,3,3,3,3,2,2,3,3,2,2,3,3,3,3,3,3,1,1,2,2,2,2,2,2,1,1,0,0,1,1,0,0,1,1,2,2,1,1,2,2,3,3,1,1,0,0,2,2,0,0,0,0,0,0,2,2,3,3,0,0,3,3,1,1,2,2,0,0,1,1,1,1,2,2,2,2,0,0,3,3,2,2,3,3,2,2,2,2,1,1,1,1,3,3,0,0,2,2,3,3,0,0,0,0,0,0,1,1,2,2,2,2,3,3,2,2,0,0,2,2,2,2,3,3,3,3,3,3,1,1,1,1,1,1,2,2,2,2,0,0,3,3,2,2,0,0,2,2,2,2,1,1,1,1,3,3,1,1,3,3,2,2,0,0,2,2,1,1,3,3,1,1,0,0,3,3,2,2,3,3,2,2,2,2,2,2,0,0,1,1,2,2,2,2,3,3,0,0,0,0,0,0,3,3,1,1,3,3,2,2,1,1,1,1,0,0,2,2,2,2,1,1,1,1,1,1,3,3,0,0,2,2,2,2,2,2,0,0,1,1,3,3,3,3,2,2,1,1,0,0,2,2,0,0,2,2,1,1,1,1,3,3,0,0,0,0,3,3,2,2,3,3,3,3,1,1,3,3,1,1,2,2,1,1,1,1,2,2,2,2,2,2,1,1,0,0,3,3,0,0,1,1,2,2,1,1,1,1,1,1,2,2,3,3,1,1,3,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,3,3,1,1,0,0,0,0,1,1,2,2,3,3,2,2,1,1,3,3,2,2,3,3,0,0,1,1,2,2,2,2,2,2,1,1,3,3,0,0,1,1,2,2,1,1,1,1,3,3,3,3,2,2,3,3,0,0,3,3,2,2,2,2,2,2,3,3,3,3,0,0,2,2,0,0,3,3,3,3,3,3,2,2,3,3,1,1,1,1,3,3,2,2,2,2,0,0,3,3,2,2,1,1,0,0,2,2,1,1,2,2,1,1,2,2,2,2,0,0,0,0,2,2,0,0,0,0,3,3,1,1,0,0,0,0,0,0,2,2,2,2,0,0,3,3,2,2,1,1,0,0,0,0,0,0,0,0,3,3,2,2,2,2,2,2,3,3,0,0,0,0,3,3,3,3,2,2,1,1,2,2,3,3,0,0,3,3,3,3,0,0,2,2,0,0,2,2,2,2,0,0,3,3,2,2,1,1,0,0,0,0,2,2,3,3,3,3,2,2,1,1,3,3,0,0,2,2,1,1,2,2,0,0,0,0,1,1,1,1,2,2,2,2,1,1,3,3,0,0,0,0,1,1,2,2,1,1,0,0,3,3,1,1,3,3,2,2,1,1,3,3,0,0,1,1,2,2,2,2,0,0,0,0,0,0,3,3,0,0,3,3,3,3,1,1,1,1,0,0,1,1,2,2,1,1,1,1,1,1,3,3,1,1,2,2,3,3,0,0,2,2,0,0,2,2,3,3,2,2,2,2,3,3,0,0,3,3,2,2,0,0,0,0,0,0,1,1,0,0,1,1,0,0,2,2,3,3,0,0,3,3,2,2,1,1,3,3,0,0,0,0,1,1,3,3,0,0,2,2,2,2,0,0,0,0,3,3,1,1,3,3,2,2,2,2,1,1,2,2,3,3,2,2,2,2,1,1,0,0,1,1,2,2,2,2,3,3,2,2,0,0,3,3,1,1,1,1,3,3,2,2,0,0,3,3,2,2,0,0,0,0,2,2,0,0,2,2,3,3,0,0,1,1,1,1,1,1,0,0,2,2,0,0,0,0,1,1,2,2,1,1,2,2,0,0,2,2,0,0,2,2,3,3,0,0,0,0,1,1,1,1,0,0,2,2,0,0,1,1,0,0,1,1,2,2,0,0,1,1,1,1,1,1,2,2,0,0,0,0,0,0,0,0,2,2,3,3,1,1,1,1,2,2,0,0,1,1,1,1,1,1,3,3,2,2,0,0,1,1,2,2,1,1,0,0,2,2,1,1,1,1,0,0,3,3,2,2,3,3,3,3,1,1,0,0,2,2,1,1,0,0,1,1,1,1,3,3,2,2,3,3,0,0,3,3,1,1,2,2,3,3,2,2,1,1,0,0,0,0,0,0,2,2,0,0,0,0,0,0,2,2,1,1,0,0,0,0,0,0,2,2,3,3,2,2,0,0,0,0,0,0,0,0,0,0,3,3,2,2,2,2,1,1,0,0,2,2,3,3,0,0,0,0,1,1,3,3,2,2,0,0,0,0,2,2,2,2,3,3,0,0,1,1,0,0,2,2,3,3,3,3,2,2,3,3,0,0,1,1,3,3,3,3,2,2,0,0,2,2,2,2,1,1,1,1,3,3,0,0,2,2,2,2,2,2,3,3,1,1,3,3,3,3,0,0,1,1,2,2,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,2,2,3,3,0,0,3,3,2,2,2,2,0,0,2,2,1,1,1,1,3,3,2,2,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,1,1,3,3,1,1,0,0,0,0,3,3,0,0,0,0,3,3,1,1,2,2,3,3,0,0,2,2,3,3,3,3,3,3,3,3,0,0,3,3,0,0,3,3,1,1,2,2,3,3,1,1,0,0,2,2,0,0,1,1,3,3,0,0,1,1,1,1,2,2,2,2,3,3,0,0,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,3,3,0,0,2,2,0,0,3,3,1,1,3,3,2,2,2,2,0,0,1,1,3,3,1,1,2,2,0,0,0,0,0,0,2,2,2,2,0,0,3,3,0,0,2,2,3,3,0,0,1,1,3,3,1,1,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,3,3,1,1,2,2,2,2,0,0,1,1,2,2,1,1,2,2,1,1,3,3,0,0,3,3,3,3,3,3,0,0,1,1,2,2,3,3,0,0,0,0,0,0,2,2,0,0,2,2,3,3,3,3,3,3,0,0,1,1,1,1,3,3,0,0,0,0,3,3,3,3,2,2,0,0,1,1,3,3,1,1,2,2,2,2,2,2,0,0,0,0,2,2,0,0,0,0,2,2,3,3,3,3,1,1,1,1,3,3,2,2,1,1,0,0,1,1,0,0,3,3,3,3,1,1,0,0,2,2,3,3,2,2,0,0,1,1,3,3,0,0,2,2,1,1,2,2,3,3,0,0,2,2,3,3,2,2,2,2,0,0,1,1,1,1,1,1,2,2,2,2,1,1,2,2,1,1,0,0,0,0,0,0,3,3,3,3,2,2,3,3,1,1,2,2,2,2,3,3,3,3,1,1,1,1,1,1,3,3,0,0,1,1,2,2,2,2,0,0,2,2,3,3,3,3,2,2,1,1,0,0,2,2,2,2,2,2,2,2,2,2,1,1,3,3,1,1,3,3,1,1,3,3,2,2,2,2,1,1,3,3,1,1,0,0,3,3,0,0,1,1,1,1,3,3,0,0,1,1,2,2,2,2,1,1,0,0,3,3,0,0,0,0,2,2,1,1,0,0,3,3,1,1,2,2,0,0,3,3,2,2,0,0,3,3,0,0,2,2,1,1,3,3,0,0,1,1,3,3,3,3,0,0,1,1,1,1,1,1,2,2,2,2,0,0,2,2,1,1,0,0,1,1,1,1,2,2,1,1,1,1,0,0,2,2,2,2,0,0,1,1,2,2,3,3,2,2,1,1,0,0,2,2,3,3,1,1,2,2,3,3,1,1,3,3,0,0,3,3,0,0,2,2,1,1,3,3,3,3,0,0,0,0,0,0,0,0,1,1,0,0,3,3,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,2,2,3,3,1,1,1,1,2,2,1,1,0,0,2,2,2,2,0,0,3,3,3,3,1,1,0,0,1,1,1,1,2,2,1,1,1,1,2,2,3,3,1,1,2,2,2,2,0,0,1,1,1,1,0,0,3,3,1,1,0,0,1,1,3,3,1,1,0,0,3,3,2,2,2,2,0,0,0,0,3,3,3,3,0,0,2,2,3,3,1,1,1,1,3,3,2,2,0,0,2,2,2,2,0,0,1,1,3,3,2,2,1,1,2,2,1,1,0,0,3,3,3,3,0,0,3,3,1,1,0,0,3,3,1,1,2,2,0,0,2,2,2,2,1,1,2,2,3,3,0,0,1,1,2,2,2,2,0,0,2,2,3,3,1,1,3,3,3,3,3,3,1,1,0,0,3,3,3,3,2,2,2,2,1,1,0,0,0,0,0,0,2,2,2,2,0,0,1,1,3,3,0,0,0,0,1,1,0,0,0,0,0,0,2,2,3,3,1,1,1,1,2,2,3,3,2,2,3,3,0,0,2,2,1,1,3,3,1,1,1,1,2,2,2,2,0,0,0,0,2,2,2,2,1,1,3,3,1,1,2,2,1,1,2,2,0,0,0,0,2,2,0,0,3,3,3,3,3,3,2,2,2,2,3,3,0,0,1,1,1,1,1,1,0,0,2,2,1,1,2,2,1,1,0,0,3,3,2,2,0,0,1,1,1,1,2,2,1,1,1,1,3,3,0,0,0,0,2,2,2,2,2,2,1,1,2,2,3,3,3,3,2,2,1,1,1,1,1,1,0,0,0,0,3,3,3,3,2,2,3,3,2,2,1,1,2,2,3,3,1,1,1,1,1,1,0,0,2,2,1,1,1,1,3,3,2,2,3,3,3,3,2,2,2,2,1,1,0,0,1,1,0,0,1,1,0,0,3,3,3,3,3,3,1,1,3,3,2,2,1,1,3,3,0,0,3,3,2,2,0,0,3,3,2,2,3,3,2,2,3,3,0,0,0,0,2,2,1,1,0,0,3,3,1,1,3,3,3,3,3,3,3,3,0,0,1,1,1,1,0,0,0,0,3,3,3,3,2,2,0,0,3,3,3,3,3,3,1,1,3,3,1,1,3,3,0,0,3,3,1,1,2,2,1,1,1,1,0,0,2,2,1,1,3,3,1,1,2,2,1,1,1,1,1,1,3,3,1,1,2,2,3,3,3,3,0,0,3,3,3,3,0,0,3,3,1,1,2,2,2,2,2,2,3,3,3,3,0,0,2,2,1,1,3,3,2,2,0,0,3,3,1,1,0,0,3,3,1,1,1,1,3,3,0,0,0,0,0,0,2,2,1,1,0,0,2,2,0,0,2,2,1,1,1,1,2,2,1,1,2,2,2,2,2,2,2,2,0,0,3,3,0,0,1,1,2,2,1,1,2,2,1,1,3,3,2,2,3,3,1,1,3,3,3,3,3,3,2,2,3,3,1,1,2,2,3,3,0,0,1,1,2,2,2,2,0,0,0,0,3,3,0,0,3,3,3,3,0,0,3,3,1,1,1,1,0,0,1,1,2,2,0,0,2,2,2,2,2,2,0,0,0,0,1,1,2,2,2,2,2,2,3,3,1,1,0,0,3,3,2,2,0,0,3,3,2,2,3,3,2,2,2,2,0,0,2,2,3,3,3,3,0,0,3,3,2,2,1,1,3,3,3,3,2,2,2,2,3,3,2,2,3,3,0,0,2,2,0,0,3,3,3,3,3,3,0,0,3,3,2,2,3,3,3,3,2,2,0,0,0,0,1,1,0,0,3,3,0,0,3,3,0,0,2,2,2,2,1,1,0,0,1,1,0,0,3,3,3,3,1,1,2,2,2,2,3,3,2,2,2,2,1,1,3,3,2,2,3,3,1,1,0,0,2,2,0,0,1,1,1,1,0,0,3,3,0,0,0,0,1,1,3,3,1,1,2,2,0,0,3,3,2,2,1,1,1,1,3,3,2,2,1,1,1,1,2,2,3,3,1,1,3,3,2,2,0,0,3,3,0,0,2,2,1,1,1,1,0,0,1,1,2,2,1,1,1,1,0,0,1,1,1,1,2,2,3,3,3,3,0,0,3,3,2,2,3,3,2,2,2,2,2,2,0,0,0,0,1,1,1,1,0,0,1,1,1,1,3,3,3,3,3,3,0,0,1,1,0,0,2,2,0,0,3,3,1,1,0,0,1,1,3,3,2,2,3,3,3,3,0,0,0,0,0,0,2,2,2,2,2,2,1,1,1,1,3,3,0,0,3,3,2,2,0,0,3,3,0,0,0,0,0,0,3,3,0,0,3,3,3,3,0,0,1,1,3,3,0,0,1,1,2,2,0,0,1,1,3,3,3,3,1,1,3,3,2,2,1,1,2,2,2,2,1,1,1,1,3,3,3,3,1,1,2,2,3,3,1,1,3,3,2,2,1,1,1,1,3,3,1,1,0,0,1,1,0,0,1,1,0,0,2,2,0,0,0,0,0,0,3,3,2,2,2,2,3,3,0,0,0,0,2,2,1,1,1,1,2,2,3,3,2,2,0,0,3,3,1,1,2,2,2,2,0,0,1,1,0,0,1,1,0,0,3,3,1,1,0,0,0,0,1,1,0,0,2,2,0,0,3,3,3,3,0,0,0,0,1,1,0,0,0,0,1,1,3,3,2,2,0,0,0,0,0,0,0,0,2,2,2,2,3,3,0,0,0,0,2,2,2,2,2,2,1,1,0,0,1,1,1,1,1,1,1,1,2,2,0,0,2,2,3,3,2,2,1,1,2,2,1,1,1,1,1,1,2,2,0,0,3,3,2,2,0,0,2,2,0,0,1,1,1,1,2,2,3,3,0,0,0,0,0,0,2,2,3,3,2,2,2,2,2,2,2,2,1,1,0,0,0,0,3,3,0,0,0,0,2,2,1,1,2,2,0,0,0,0,2,2,0,0,3,3,2,2,1,1,3,3,3,3,2,2,0,0,2,2,1,1,2,2,0,0,1,1,1,1,3,3,1,1,1,1,0,0,2,2,1,1,2,2,1,1,3,3,2,2,1,1,0,0,1,1,0,0,1,1,2,2,2,2,0,0,2,2,2,2,3,3,2,2,2,2,2,2,2,2,3,3,1,1,2,2,1,1,3,3,2,2,3,3,2,2,0,0,3,3,1,1,1,1,3,3,0,0,0,0,2,2,1,1,2,2,3,3,1,1,2,2,3,3,3,3,2,2,1,1,3,3,2,2,0,0,3,3,0,0,2,2,1,1,2,2,2,2,3,3,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,2,2,3,3,0,0,1,1,3,3,1,1,2,2,2,2,0,0,0,0,1,1,3,3,2,2,0,0,3,3,3,3,1,1,3,3,2,2,2,2,2,2,3,3,1,1,3,3,2,2,0,0,1,1,1,1,0,0,3,3,0,0,1,1,1,1,2,2,0,0,2,2,1,1,3,3,1,1,2,2,2,2,2,2,3,3,0,0,3,3,0,0,3,3,2,2,2,2,2,2,3,3,0,0,2,2,3,3,2,2,3,3,1,1,0,0,1,1,2,2,1,1,1,1,3,3,3,3,3,3,2,2,3,3,3,3,0,0,3,3,0,0,3,3,2,2,3,3,3,3,3,3,0,0,3,3,1,1,0,0,3,3,1,1,2,2,1,1,0,0,1,1,0,0,2,2,2,2,0,0,2,2,1,1,3,3,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,2,2,2,2,0,0,2,2,1,1,1,1,1,1,2,2,2,2,3,3,1,1,0,0,1,1,0,0,0,0,3,3,2,2,3,3,1,1,3,3,0,0,2,2,1,1,3,3,1,1,0,0,0,0,1,1,2,2,1,1,2,2,1,1,1,1,0,0,0,0,3,3,1,1,1,1,1,1,1,1,2,2,1,1,0,0,1,1,2,2,3,3,0,0,0,0,1,1,0,0,2,2,2,2,0,0,3,3,1,1,1,1,1,1,3,3,0,0,0,0,2,2,0,0,2,2,0,0,3,3,1,1,3,3,2,2,1,1,3,3,1,1,3,3,2,2,1,1,3,3,0,0,1,1,1,1,3,3,2,2,3,3,2,2,0,0,0,0,3,3,3,3,1,1,2,2,0,0,3,3,1,1,3,3,0,0,1,1,0,0,1,1,0,0,0,0,1,1,3,3,1,1,1,1,3,3,0,0,1,1,3,3,3,3,1,1,2,2,2,2,3,3,2,2,1,1,0,0,2,2,2,2,3,3,2,2,2,2,0,0,1,1,3,3,0,0,0,0,3,3,2,2,1,1,2,2,1,1,3,3,3,3,0,0,2,2,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,0,0,0,0,0,0,3,3,3,3,1,1,2,2,1,1,0,0,0,0,3,3,1,1,0,0,0,0,0,0,0,0,0,0,1,1,3,3,1,1,3,3,1,1,0,0,0,0,3,3,0,0,3,3,2,2,1,1,2,2,2,2,2,2,3,3,0,0,3,3,1,1,0,0,3,3,0,0,3,3,0,0,3,3,3,3,3,3,0,0,1,1,2,2,1,1,0,0,1,1,2,2,1,1,3,3,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,0,0,1,1,3,3,2,2,1,1,2,2,2,2,3,3,0,0,1,1,2,2,2,2,1,1,0,0,2,2,0,0,3,3,2,2,1,1,2,2,2,2,0,0,3,3,1,1,3,3,0,0,0,0,1,1,3,3,3,3,2,2,0,0,2,2,0,0,0,0,2,2,3,3,1,1,2,2,2,2,2,2,1,1,1,1,0,0,1,1,1,1,2,2,2,2,3,3,1,1,0,0,1,1,2,2,2,2,1,1,2,2,2,2,0,0,0,0,2,2,1,1,2,2,1,1,0,0,2,2,1,1,1,1,0,0,3,3,2,2,3,3,1,1,1,1,1,1,1,1,2,2,2,2,1,1,2,2,3,3,0,0,3,3,3,3,2,2,1,1,3,3,1,1,2,2,1,1,0,0,2,2,2,2,3,3,0,0,3,3,0,0,0,0,2,2,2,2,0,0,2,2,0,0,1,1,2,2,2,2,0,0,3,3,1,1,0,0,3,3,3,3,1,1,0,0,1,1,2,2,2,2,2,2,1,1,0,0,3,3,2,2,1,1,3,3,1,1,3,3,3,3,3,3,1,1,1,1,2,2,3,3,0,0,1,1,0,0,3,3,2,2,3,3,1,1,2,2,0,0,1,1,0,0,3,3,2,2,0,0,1,1,2,2,0,0,0,0,3,3,1,1,1,1,0,0,2,2,3,3,0,0,3,3,1,1,2,2,0,0,2,2,0,0,0,0,0,0,3,3,3,3,2,2,3,3,0,0,1,1,0,0,1,1,1,1,1,1,0,0,2,2,1,1,0,0,1,1,2,2,0,0,0,0,0,0,3,3,3,3,3,3,0,0,3,3,3,3,0,0,2,2,1,1,2,2,2,2,1,1,2,2,0,0,1,1,2,2,1,1,3,3,1,1,1,1,2,2,0,0,1,1,2,2,0,0,1,1,2,2,0,0,1,1,1,1,0,0,3,3,0,0,3,3,1,1,0,0,2,2,3,3,2,2,1,1,3,3,1,1,3,3,0,0,3,3,1,1,1,1,0,0,2,2,2,2,3,3,0,0,1,1,0,0,0,0,1,1,0,0,1,1,2,2,3,3,0,0,0,0,3,3,2,2,2,2,3,3,3,3,1,1,1,1,0,0,3,3,1,1,3,3,2,2,3,3,3,3,2,2,1,1,2,2,2,2,1,1,1,1,1,1,3,3,0,0,1,1,1,1,1,1,1,1,2,2,3,3,0,0,1,1,2,2,0,0,3,3,2,2,0,0,1,1,0,0,3,3,1,1,0,0,2,2,1,1,0,0,1,1,2,2,0,0,3,3,3,3,0,0,2,2,3,3,3,3,1,1,0,0,2,2,2,2,1,1,2,2,0,0,3,3,3,3,2,2,0,0,1,1,0,0,1,1,0,0,2,2,1,1,0,0,0,0,3,3,1,1,1,1,2,2,0,0,0,0,2,2,3,3,0,0,1,1,2,2,2,2,1,1,1,1,2,2,1,1,0,0,2,2,0,0,2,2,0,0,1,1,2,2,1,1,0,0,3,3,1,1,2,2,1,1,0,0,3,3,3,3,2,2,2,2,1,1,0,0,0,0,0,0,2,2,1,1,3,3,0,0,1,1,3,3,3,3,0,0,3,3,1,1,1,1,3,3,2,2,3,3,2,2,1,1,0,0,2,2,1,1,3,3,3,3,2,2,1,1,3,3,0,0,1,1,2,2,3,3,3,3,2,2,2,2,1,1,0,0,0,0,0,0,0,0,2,2,2,2,2,2,3,3,0,0,3,3,1,1,2,2,2,2,0,0,1,1,0,0,0,0,2,2,0,0,3,3,0,0,1,1,1,1,3,3,2,2,2,2,0,0,0,0,2,2,0,0,0,0,1,1,1,1,1,1,0,0,0,0,2,2,0,0,3,3,2,2,1,1,2,2,2,2,3,3,1,1,1,1,3,3,0,0,3,3,0,0,2,2,2,2,2,2,3,3,1,1,0,0,0,0,0,0,1,1,3,3,0,0,1,1,3,3,3,3,0,0,3,3,1,1,0,0,3,3,2,2,2,2,1,1,3,3,0,0,0,0,0,0,2,2,0,0,3,3,3,3,3,3,1,1,1,1,2,2,1,1,2,2,2,2,1,1,2,2,0,0,0,0,2,2,2,2,0,0,3,3,0,0,3,3,3,3,0,0,1,1,1,1,3,3,2,2,0,0,3,3,3,3,2,2,1,1,1,1,3,3,3,3,0,0,0,0,0,0,2,2,1,1,3,3,1,1,1,1,1,1,0,0,0,0,0,0,2,2,0,0,2,2,1,1,0,0,3,3,0,0,1,1,2,2,1,1,1,1,2,2,1,1,2,2,1,1,1,1,0,0,2,2,1,1,0,0,1,1,0,0,1,1,2,2,3,3,2,2,1,1,1,1,2,2,2,2,1,1,0,0,1,1,2,2,3,3,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,3,3,2,2,1,1,1,1,3,3,2,2,0,0,0,0,3,3,3,3,3,3,1,1,1,1,0,0,0,0,1,1,0,0,2,2,0,0,3,3,0,0,2,2,1,1,0,0,0,0,3,3,3,3,0,0,1,1,0,0,0,0,3,3,2,2,3,3,3,3,3,3,2,2,1,1,2,2,2,2,2,2,2,2,0,0,2,2,1,1,2,2,3,3,2,2,3,3,1,1,0,0,2,2,3,3,1,1,3,3,1,1,0,0,2,2,2,2,1,1,1,1,3,3,2,2,3,3,0,0,1,1,3,3,2,2,2,2,0,0,0,0,3,3,3,3,0,0,2,2,3,3,0,0,1,1,2,2,1,1,1,1,1,1,0,0,2,2,0,0,1,1,0,0,3,3,0,0,2,2,0,0,2,2,2,2,1,1,1,1,3,3,2,2,2,2,3,3,3,3,1,1,2,2,3,3,1,1,0,0,3,3,2,2,0,0,2,2,0,0,0,0,3,3,1,1,0,0,2,2,2,2,1,1,2,2,2,2,0,0,1,1,1,1,3,3,3,3,2,2,3,3,0,0,3,3,0,0,3,3,1,1,2,2,1,1,0,0,1,1,3,3,0,0,2,2,1,1,2,2,0,0,3,3,2,2,0,0,0,0,1,1,0,0,1,1,0,0,0,0,3,3,1,1,3,3,0,0,0,0,3,3,1,1,1,1,1,1,3,3,0,0,1,1,2,2,0,0,0,0,0,0,0,0,2,2,1,1,1,1,2,2,0,0,0,0,1,1,1,1,2,2,3,3,1,1,3,3,3,3,2,2,1,1,0,0,2,2,2,2,1,1,3,3,0,0,3,3,2,2,0,0,1,1,2,2,0,0,3,3,2,2,2,2,0,0,1,1,1,1,1,1,2,2,2,2,1,1,3,3,0,0,0,0,2,2,2,2,2,2,2,2,2,2,1,1,1,1,2,2,1,1,0,0,3,3,2,2,0,0,0,0,0,0,0,0,1,1,0,0,3,3,0,0,3,3,1,1,3,3,2,2,2,2,0,0,0,0,2,2,3,3,3,3,1,1,0,0,0,0,0,0,1,1,3,3,3,3,2,2,3,3,1,1,3,3,0,0,0,0,1,1,3,3,1,1,0,0,2,2,1,1,1,1,0,0,0,0,0,0,3,3,2,2,3,3,0,0,0,0,0,0,2,2,2,2,1,1,1,1,1,1,2,2,2,2,3,3,1,1,1,1,3,3,3,3,0,0,1,1,2,2,1,1,1,1,3,3,2,2,1,1,0,0,2,2,3,3,0,0,0,0,3,3,0,0,3,3,3,3,2,2,0,0,1,1,0,0,0,0,0,0,0,0,2,2,3,3,2,2,0,0,0,0,2,2,0,0,1,1,0,0,1,1,0,0,0,0,1,1,3,3,3,3,1,1,0,0,1,1,1,1,3,3,2,2,1,1,3,3,0,0,0,0,3,3,0,0,2,2,2,2,1,1,2,2,1,1,0,0,2,2,3,3,1,1,0,0,2,2,0,0,1,1,2,2,2,2,0,0,3,3,2,2,2,2,0,0,2,2,3,3,1,1,1,1,2,2,1,1,0,0,1,1,2,2,0,0,1,1,0,0,1,1,2,2,0,0,1,1,2,2,1,1,3,3,2,2,1,1,3,3,1,1,2,2,3,3,1,1,2,2,3,3,0,0,0,0,2,2,1,1,2,2,1,1,1,1,3,3,0,0,3,3,1,1,0,0,0,0,0,0,0,0,3,3,3,3,2,2,2,2,2,2,3,3,3,3,3,3,0,0,2,2,2,2,2,2,1,1,1,1,0,0,1,1,2,2,2,2,1,1,0,0,1,1,1,1,3,3,1,1,2,2,0,0,0,0,2,2,3,3,1,1,3,3,3,3,3,3,1,1,1,1,0,0,1,1,1,1,1,1,2,2,0,0,0,0,3,3,2,2,3,3,3,3,3,3,2,2,0,0,0,0,3,3,3,3,0,0,0,0,1,1,0,0,2,2,1,1,2,2,1,1,3,3,1,1,3,3,0,0,1,1,2,2,3,3,0,0,0,0,2,2,2,2,2,2,1,1,3,3,3,3,1,1,2,2,2,2,2,2,1,1,0,0,3,3,3,3,2,2,1,1,3,3,3,3,2,2,0,0,2,2,3,3,2,2,2,2,2,2,3,3,3,3,1,1,1,1,3,3,2,2,2,2,0,0,1,1,0,0,3,3,1,1,3,3,2,2,0,0,1,1,1,1,2,2,2,2,0,0,0,0,0,0,2,2,3,3,3,3,2,2,1,1,0,0,0,0,2,2,2,2,1,1,1,1,0,0,3,3,1,1,0,0,0,0,2,2,0,0,2,2,2,2,3,3,1,1,3,3,3,3,1,1,1,1,0,0,3,3,1,1,3,3,0,0,3,3,1,1,0,0,2,2,3,3,3,3,1,1,1,1,2,2,2,2,1,1,1,1,3,3,3,3,1,1,1,1,3,3,1,1,3,3,1,1,3,3,3,3,0,0,1,1,2,2,2,2,2,2,0,0,2,2,2,2,3,3,1,1,1,1,2,2,0,0,2,2,3,3,0,0,3,3,2,2,0,0,3,3,3,3,2,2,0,0,2,2,2,2,3,3,1,1,0,0,3,3,2,2,0,0,1,1,2,2,2,2,0,0,2,2,2,2,1,1,0,0,0,0,1,1,3,3,1,1,3,3,0,0,2,2,0,0,1,1,0,0,1,1,2,2,2,2,3,3,0,0,3,3,3,3,0,0,3,3,1,1,2,2,0,0,0,0,2,2,3,3,3,3,2,2,2,2,2,2,3,3,2,2,0,0,1,1,2,2,0,0,2,2,3,3,3,3,1,1,0,0,3,3,2,2,1,1,1,1,1,1,1,1,3,3,0,0,1,1,0,0,0,0,2,2,1,1,0,0,2,2,2,2,0,0,1,1,0,0,2,2,3,3,3,3,2,2,1,1,1,1,0,0,2,2,0,0,0,0,2,2,3,3,2,2,1,1,0,0,0,0,2,2,0,0,2,2,1,1,1,1,3,3,1,1,0,0,0,0,0,0,1,1,3,3,1,1,0,0,2,2,1,1,1,1,0,0,1,1,1,1,0,0,2,2,1,1,0,0,1,1,2,2,3,3,2,2,0,0,1,1,1,1,3,3,2,2,0,0,2,2,2,2,1,1,2,2,1,1,3,3,2,2,2,2,2,2,3,3,1,1,3,3,1,1,2,2,1,1,1,1,2,2,0,0,0,0,3,3,1,1,1,1,3,3,3,3,1,1,2,2,0,0,3,3,3,3,0,0,2,2,0,0,0,0,2,2,2,2,3,3,1,1,3,3,1,1,2,2,0,0,3,3,0,0,0,0,0,0,2,2,1,1,0,0,2,2,2,2,3,3,3,3,1,1,3,3,2,2,2,2,1,1,0,0,3,3,1,1,0,0,2,2,3,3,1,1,2,2,2,2,3,3,3,3,1,1,1,1,1,1,0,0,2,2,2,2,0,0,3,3,0,0,1,1,3,3,1,1,2,2,0,0,0,0,3,3,1,1,3,3,3,3,2,2,1,1,1,1,1,1,0,0,0,0,0,0,1,1,2,2,3,3,3,3,3,3,3,3,1,1,2,2,1,1,2,2,1,1,0,0,2,2,0,0,0,0,3,3,1,1,3,3,2,2,2,2,2,2,1,1,3,3,2,2,1,1,2,2,2,2,0,0,2,2,0,0,0,0,3,3,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,2,2,2,2,3,3,3,3,2,2,0,0,3,3,0,0,3,3,0,0,0,0,3,3,3,3,3,3,0,0,3,3,3,3,3,3,0,0,3,3,2,2,0,0,0,0,2,2,1,1,3,3,2,2,1,1,0,0,1,1,2,2,1,1,1,1,3,3,0,0,0,0,3,3,1,1,1,1,0,0,0,0,1,1,3,3,2,2,0,0,3,3,2,2,2,2,3,3,3,3,1,1,0,0,1,1,2,2,2,2,3,3,2,2,0,0,1,1,0,0,1,1,3,3,1,1,1,1,2,2,0,0,2,2,0,0,3,3,1,1,0,0,3,3,2,2,2,2,0,0,2,2,1,1,3,3,1,1,3,3,3,3,3,3,2,2,3,3,2,2,2,2,2,2,3,3,1,1,3,3,2,2,3,3,1,1,2,2,1,1,2,2,1,1,1,1,3,3,1,1,0,0,3,3,0,0,0,0,3,3,1,1,3,3,3,3,1,1,2,2,1,1,0,0,0,0,1,1,3,3,3,3,0,0,2,2,2,2,1,1,0,0,3,3,0,0,0,0,2,2,1,1,0,0,1,1,3,3,1,1,1,1,3,3,0,0,3,3,0,0,2,2,0,0,2,2,1,1,0,0,2,2,1,1,2,2,3,3,1,1,3,3,3,3,2,2,3,3,1,1,0,0,0,0,3,3,1,1,0,0,3,3,1,1,3,3,3,3,3,3,3,3,1,1,2,2,0,0,1,1,2,2,2,2,1,1,2,2,1,1,2,2,1,1,0,0,0,0,2,2,0,0,1,1,0,0,0,0,1,1,0,0,2,2,0,0,2,2,1,1,3,3,2,2,2,2,0,0,1,1,3,3,3,3,2,2,0,0,0,0,0,0,0,0,2,2,1,1,0,0,2,2,3,3,1,1,0,0,3,3,2,2,0,0,0,0,2,2,0,0,1,1,0,0,2,2,3,3,1,1,3,3,3,3,2,2,0,0,1,1,1,1,0,0,0,0,3,3,3,3,2,2,1,1,2,2,2,2,3,3,3,3,2,2,2,2,3,3,0,0,3,3,1,1,0,0,1,1,3,3,1,1,0,0,0,0,0,0,0,0,3,3,2,2,2,2,0,0,2,2,3,3,3,3,2,2,3,3,0,0,2,2,3,3,3,3,2,2,2,2,0,0,3,3,1,1,2,2,0,0,2,2,0,0,0,0,3,3,3,3,2,2,0,0,1,1,2,2,0,0,2,2,3,3,3,3,2,2,0,0,2,2,1,1,0,0,0,0,3,3,0,0,2,2,1,1,2,2,3,3,0,0,1,1,0,0,2,2,1,1,2,2,2,2,0,0,2,2,0,0,1,1,2,2,2,2,1,1,3,3,1,1,1,1,2,2,1,1,0,0,0,0,1,1,2,2,2,2,2,2,3,3,0,0,0,0,2,2,3,3,2,2,1,1,0,0,0,0,1,1,1,1,0,0,3,3,3,3,1,1,1,1,2,2,2,2,1,1,0,0,0,0,0,0,3,3,2,2,0,0,1,1,3,3,1,1,2,2,1,1,1,1,1,1,2,2,1,1,2,2,0,0,1,1,0,0,1,1,3,3,2,2,1,1,0,0,1,1,2,2,3,3,3,3,2,2,0,0,3,3,0,0,2,2,1,1,0,0,1,1,2,2,1,1,0,0,3,3,0,0,2,2,2,2,2,2,2,2,3,3,1,1,0,0,1,1,1,1,1,1,2,2,3,3,0,0,3,3,0,0,1,1,0,0,1,1,3,3,1,1,2,2,1,1,2,2,2,2,1,1,0,0,1,1,3,3,2,2,0,0,3,3,1,1,1,1,2,2,0,0,1,1,3,3,3,3,2,2,3,3,2,2,2,2,1,1,2,2,1,1,0,0,2,2,3,3,3,3,0,0,0,0,1,1,2,2,3,3,3,3,3,3,2,2,2,2,3,3,0,0,0,0,0,0,1,1,0,0,0,0,2,2,2,2,0,0,1,1,2,2,1,1,1,1,3,3,0,0,2,2,3,3,3,3,2,2,0,0,3,3,2,2,1,1,1,1,3,3,0,0,0,0,3,3,2,2,1,1,2,2,0,0,1,1,1,1,2,2,0,0,0,0,0,0,0,0,3,3,0,0,0,0,2,2,0,0,2,2,2,2,0,0,2,2,1,1,1,1,1,1,1,1,1,1,1,1,3,3,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,3,3,1,1,1,1,3,3,3,3,0,0,1,1,2,2,3,3,0,0,1,1,3,3,3,3,3,3,1,1,2,2,1,1,2,2,0,0,1,1,2,2,1,1,1,1,1,1,0,0,0,0,1,1,3,3,2,2,1,1,0,0,2,2,0,0,0,0,0,0,2,2,0,0,2,2,3,3,3,3,2,2,0,0,1,1,3,3,2,2,3,3,0,0,1,1,1,1,0,0,1,1,2,2,2,2,3,3,2,2,3,3,3,3,2,2,1,1,0,0,2,2,1,1,0,0,3,3,1,1,3,3,3,3,0,0,2,2,1,1,2,2,2,2,1,1,3,3,0,0,2,2,3,3,2,2,3,3,0,0,3,3,1,1,0,0,3,3,1,1,2,2,2,2,2,2,0,0,1,1,0,0,0,0,0,0,3,3,1,1,0,0,3,3,3,3,0,0,0,0,1,1,3,3,3,3,1,1,3,3,0,0,3,3,0,0,0,0,3,3,3,3,3,3,1,1,2,2,1,1,3,3,2,2,1,1,2,2,1,1,0,0,2,2,0,0,3,3,0,0,1,1,2,2,2,2,3,3,1,1,2,2,0,0,3,3,0,0,0,0,0,0,0,0,3,3,0,0,2,2,1,1,3,3,0,0,2,2,1,1,3,3,2,2,3,3,3,3,2,2,3,3,2,2,1,1,2,2,3,3,0,0,3,3,3,3,2,2,0,0,3,3,0,0,2,2,1,1,0,0,0,0,3,3,1,1,3,3,2,2,1,1,1,1,2,2,3,3,2,2,2,2,0,0,0,0,0,0,0,0,3,3,3,3,3,3,2,2,2,2,3,3,3,3,0,0,2,2,2,2,1,1,3,3,2,2,3,3,0,0,2,2,3,3,3,3,1,1,1,1,0,0,0,0,1,1,1,1,2,2,0,0,0,0,2,2,1,1,1,1,2,2,2,2,1,1,1,1,3,3,3,3,2,2,0,0,2,2,3,3,0,0,1,1,2,2,3,3,2,2,3,3,2,2,3,3,1,1,1,1,0,0,3,3,1,1,2,2,1,1,2,2,3,3,3,3,3,3,1,1,0,0,0,0,3,3,2,2,1,1,2,2,3,3,3,3,1,1,3,3,2,2,3,3,0,0,2,2,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,2,2,2,2,1,1,1,1,0,0,3,3,0,0,1,1,1,1,2,2,2,2,2,2,1,1,0,0,0,0,2,2,2,2,1,1,2,2,0,0,0,0,3,3,2,2,2,2,0,0,0,0,2,2,3,3,1,1,2,2,1,1,2,2,1,1,3,3,2,2,3,3,1,1,2,2,1,1,0,0,0,0,1,1,1,1,1,1,3,3,3,3,3,3,0,0,1,1,0,0,3,3,0,0,2,2,3,3,3,3,1,1,2,2,0,0,3,3,2,2,2,2,2,2,2,2,2,2,3,3,2,2,0,0,3,3,2,2,1,1,2,2,0,0,1,1,1,1,1,1,1,1,0,0,3,3,2,2,0,0,0,0,0,0,0,0,2,2,0,0,2,2,3,3,0,0,3,3,3,3,1,1,3,3,3,3,1,1,2,2,3,3,1,1,0,0,2,2,3,3,1,1,1,1,1,1,3,3,1,1,0,0,1,1,2,2,0,0,3,3,0,0,0,0,0,0,2,2,0,0,0,0,3,3,3,3,1,1,2,2,2,2,0,0,1,1,0,0,3,3,1,1,3,3,2,2,2,2,0,0,2,2,0,0,0,0,0,0,2,2,2,2,0,0,1,1,1,1,0,0,1,1,3,3,3,3,0,0,3,3,2,2,2,2,1,1,2,2,0,0,1,1,3,3,0,0,1,1,3,3,3,3,0,0,1,1,1,1,1,1,0,0,1,1,3,3,0,0,1,1,3,3,1,1,2,2,0,0,0,0,2,2,1,1,0,0,1,1,1,1,1,1,3,3,0,0,0,0,0,0,0,0,3,3,0,0,0,0,1,1,1,1,2,2,1,1,1,1,3,3,2,2,2,2,3,3,3,3,0,0,1,1,3,3,0,0,0,0,2,2,0,0,0,0,2,2,0,0,0,0,2,2,1,1,3,3,3,3,0,0,3,3,0,0,1,1,1,1,3,3,0,0,3,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,2,2,1,1,0,0,3,3,2,2,3,3,3,3,2,2,3,3,1,1,0,0,3,3,2,2,1,1,1,1,2,2,3,3,2,2,2,2,3,3,2,2,3,3,1,1,1,1,1,1,0,0,2,2,1,1,1,1,2,2,3,3,3,3,0,0,3,3,0,0,2,2,1,1,1,1,1,1,2,2,2,2,1,1,1,1,3,3,2,2,3,3,2,2,2,2,2,2,3,3,3,3,2,2,1,1,2,2,2,2,2,2,1,1,1,1,3,3,0,0,3,3,2,2,3,3,0,0,2,2,1,1,1,1,0,0,3,3,3,3,2,2,0,0,0,0,0,0,3,3,2,2,2,2,0,0,0,0,3,3,1,1,1,1,1,1,3,3,2,2,0,0,1,1,1,1,0,0,2,2,1,1,0,0,2,2,1,1,2,2,1,1,2,2,2,2,3,3,2,2,0,0,1,1,1,1,2,2,3,3,2,2,2,2,1,1,0,0,2,2,0,0,1,1,2,2,1,1,2,2,1,1,3,3,2,2,3,3,2,2,3,3,1,1,0,0,2,2,0,0,3,3,3,3,3,3,0,0,1,1,3,3,1,1,0,0,1,1,2,2,3,3,2,2,0,0,3,3,1,1,3,3,0,0,3,3,1,1,2,2,0,0,0,0,0,0,2,2,2,2,1,1,0,0,1,1,0,0,2,2,1,1,2,2,3,3,1,1,2,2,3,3,0,0,2,2,0,0,3,3,2,2,3,3,0,0,3,3,1,1,2,2,2,2,2,2,3,3,0,0,2,2,3,3,0,0,1,1,2,2,0,0,2,2,1,1,1,1,2,2,0,0,3,3,2,2,1,1,3,3,2,2,1,1,1,1,3,3,3,3,2,2,0,0,3,3,0,0,3,3,0,0,3,3,0,0,0,0,3,3,1,1,0,0,0,0,1,1,3,3,3,3,1,1,2,2,3,3,2,2,2,2,3,3,2,2,2,2,1,1,0,0,2,2,2,2,3,3,1,1,2,2,1,1,0,0,1,1,2,2,3,3,3,3,3,3,0,0,0,0,3,3,1,1,1,1,2,2,1,1,1,1,2,2,3,3,1,1,2,2,3,3,2,2,0,0,1,1,2,2,0,0,0,0,1,1,2,2,2,2,1,1,3,3,2,2,2,2,0,0,2,2,2,2,2,2,3,3,0,0,3,3,0,0,1,1,2,2,0,0,0,0,3,3,2,2,0,0,2,2,2,2,0,0,3,3,1,1,3,3,2,2,1,1,1,1,1,1,2,2,3,3,1,1,2,2,2,2,2,2,3,3,3,3,3,3,2,2,3,3,1,1,2,2,1,1,3,3,0,0,2,2,1,1,1,1,1,1,3,3,2,2,2,2,0,0,3,3,0,0,3,3,0,0,2,2,0,0,1,1,1,1,2,2,0,0,0,0,0,0,2,2,2,2,0,0,1,1,2,2,1,1,3,3,3,3,3,3,3,3,0,0,1,1,0,0,0,0,0,0,2,2,1,1,0,0,0,0,2,2,1,1,2,2,0,0,0,0,2,2,1,1,2,2,1,1,0,0,3,3,0,0,2,2,1,1,1,1,0,0,1,1,2,2,2,2,3,3,3,3,3,3,0,0,1,1,0,0,3,3,3,3,0,0,1,1,1,1,2,2,1,1,2,2,3,3,2,2,1,1,3,3,2,2,1,1,1,1,0,0,0,0,3,3,0,0,1,1,1,1,2,2,2,2,0,0,2,2,3,3,2,2,1,1,1,1,2,2,3,3,0,0,0,0,1,1,0,0,3,3,1,1,0,0,2,2,1,1,2,2,2,2,0,0,3,3,3,3,0,0,1,1,1,1,1,1,2,2,3,3,2,2,1,1,3,3,2,2,2,2,3,3,1,1,1,1,1,1,0,0,3,3,0,0,0,0,1,1,2,2,3,3,2,2,3,3,1,1,1,1,3,3,0,0,3,3,1,1,3,3,0,0,2,2,1,1,1,1,2,2,1,1,3,3,0,0,1,1,1,1,0,0,3,3,0,0,0,0,2,2,1,1,3,3,1,1,2,2,3,3,2,2,3,3,0,0,1,1,2,2,0,0,0,0,2,2,0,0,1,1,1,1,3,3,2,2,2,2,2,2,2,2,0,0,2,2,3,3,1,1,1,1,1,1,2,2,2,2,3,3,2,2,3,3,1,1,0,0,0,0,0,0,2,2,1,1,0,0,3,3,1,1,3,3,2,2,2,2,0,0,0,0,2,2,0,0,3,3,3,3,3,3,3,3,2,2,0,0,0,0,3,3,1,1,1,1,3,3,0,0,1,1,1,1,2,2,1,1,3,3,0,0,1,1,3,3,0,0,0,0,1,1,1,1,2,2,3,3,3,3,2,2,1,1,3,3,2,2,3,3,0,0,1,1,1,1,3,3,1,1,2,2,1,1,0,0,2,2,1,1,3,3,3,3,1,1,3,3,1,1,0,0,0,0,1,1,1,1,1,1,2,2,2,2,3,3,2,2,1,1,1,1,0,0,3,3,1,1,0,0,3,3,0,0,1,1,1,1,1,1,3,3,1,1,2,2,2,2,0,0,0,0,1,1,0,0,3,3,2,2,0,0,3,3,1,1,2,2,3,3,3,3,1,1,0,0,1,1,3,3,0,0,0,0,2,2,3,3,2,2,2,2,3,3,3,3,1,1,0,0,1,1,1,1,1,1,0,0,0,0,3,3,2,2,2,2,0,0,3,3,3,3,1,1,0,0,3,3,1,1,0,0,3,3,2,2,2,2,1,1,2,2,2,2,2,2,0,0,2,2,0,0,0,0,0,0,0,0,2,2,2,2,0,0,2,2,0,0,0,0,2,2,3,3,1,1,0,0,3,3,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,3,3,2,2,3,3,2,2,0,0,1,1,1,1,0,0,2,2,0,0,2,2,1,1,1,1,0,0,1,1,0,0,1,1,2,2,1,1,3,3,1,1,0,0,1,1,1,1,2,2,3,3,0,0,0,0,2,2,2,2,3,3,2,2,2,2,3,3,2,2,2,2,2,2,1,1,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,3,3,0,0,0,0,2,2,1,1,3,3,3,3,2,2,0,0,0,0,1,1,2,2,0,0,0,0,0,0,0,0,2,2,0,0,0,0,1,1,0,0,0,0,3,3,2,2,2,2,3,3,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,3,3,2,2,0,0,0,0,3,3,2,2,0,0,0,0,1,1,3,3,1,1,1,1,3,3,2,2,0,0,2,2,0,0,0,0,1,1,0,0,1,1,3,3,1,1,1,1,0,0,3,3,0,0,1,1,1,1,3,3,3,3,2,2,0,0,1,1,0,0,1,1,1,1,2,2,1,1,3,3,3,3,0,0,2,2,2,2,3,3,2,2,0,0,3,3,3,3,1,1,2,2,0,0,3,3,1,1,3,3,2,2,0,0,3,3,2,2,3,3,3,3,2,2,0,0,1,1,0,0,0,0,3,3,0,0,1,1,0,0,1,1,2,2,2,2,2,2,0,0,2,2,2,2,1,1,1,1,1,1,1,1,1,1,3,3,0,0,2,2,2,2,0,0,2,2,1,1,0,0,1,1,2,2,1,1,0,0,2,2,1,1,2,2,1,1,1,1,3,3,0,0,3,3,2,2,2,2,3,3,0,0,0,0,1,1,3,3,3,3,2,2,1,1,1,1,2,2,3,3,1,1,2,2,1,1,1,1,3,3,2,2,2,2,2,2,0,0,0,0,3,3,2,2,0,0,0,0,0,0,1,1,0,0,0,0,0,0,3,3,3,3,3,3,0,0,2,2,0,0,0,0,3,3,1,1,2,2,3,3,3,3,0,0,3,3,2,2,1,1,0,0,2,2,0,0,0,0,0,0,3,3,0,0,2,2,0,0,2,2,1,1,2,2,3,3,3,3,1,1,1,1,2,2,0,0,2,2,2,2,0,0,1,1,3,3,0,0,1,1,0,0,2,2,1,1,1,1,1,1,2,2,1,1,0,0,3,3,1,1,1,1,0,0,2,2,2,2,3,3,0,0,0,0,2,2,1,1,1,1,1,1,3,3,2,2,1,1,2,2,3,3,0,0,1,1,3,3,3,3,0,0,2,2,1,1,0,0,0,0,3,3,1,1,1,1,0,0,2,2,3,3,1,1,1,1,0,0,0,0,2,2,0,0,1,1,0,0,3,3,0,0,3,3,0,0,2,2,3,3,3,3,1,1,0,0,1,1,0,0,2,2,0,0,1,1,0,0,3,3,2,2,0,0,3,3,1,1,3,3,3,3,2,2,1,1,1,1,3,3,0,0,0,0,3,3,2,2,0,0,2,2,1,1,1,1,3,3,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,0,0,0,0,1,1,0,0,0,0,2,2,3,3,0,0,1,1,1,1,1,1,3,3,0,0,2,2,1,1,2,2,0,0,2,2,1,1,3,3,2,2,1,1,0,0,2,2,3,3,3,3,0,0,1,1,3,3,1,1,2,2,0,0,0,0,3,3,1,1,2,2,1,1,3,3,0,0,0,0,0,0,0,0,1,1,2,2,1,1,0,0,2,2,0,0,2,2,2,2,0,0,2,2,1,1,3,3,1,1,1,1,1,1,3,3,2,2,1,1,0,0,1,1,0,0,2,2,2,2,2,2,2,2,2,2,3,3,0,0,0,0,2,2,1,1,2,2,2,2,1,1,3,3,2,2,0,0,1,1,1,1,3,3,1,1,1,1,3,3,1,1,2,2,1,1,0,0,3,3,3,3,0,0,0,0,3,3,2,2,0,0,2,2,3,3,2,2,2,2,0,0,0,0,0,0,3,3,0,0,3,3,0,0,2,2,1,1,1,1,0,0,0,0,0,0,3,3,2,2,2,2,3,3,1,1,2,2,0,0,0,0,3,3,2,2,0,0,3,3,2,2,1,1,1,1,3,3,0,0,3,3,0,0,2,2,3,3,0,0,3,3,1,1,0,0,2,2,1,1,1,1,3,3,3,3,1,1,3,3,0,0,0,0,2,2,0,0,3,3,0,0,1,1,0,0,1,1,1,1,1,1,2,2,2,2,2,2,1,1,0,0,2,2,3,3,3,3,1,1,3,3,3,3,2,2,0,0,0,0,3,3,0,0,2,2,2,2,2,2,0,0,2,2,2,2,0,0,2,2,1,1,1,1,3,3,0,0,0,0,3,3,3,3,2,2,0,0,1,1,0,0,2,2,2,2,1,1,2,2,3,3,1,1,1,1,3,3,3,3,1,1,2,2,0,0,3,3,2,2,2,2,2,2,1,1,1,1,0,0,1,1,2,2,3,3,3,3,2,2,2,2,2,2,3,3,2,2,0,0,1,1,2,2,3,3,0,0,2,2,0,0,3,3,1,1,0,0,0,0,2,2,0,0,2,2,3,3,3,3,2,2,2,2,0,0,2,2,3,3,2,2,3,3,1,1,3,3,1,1,2,2,2,2,3,3,3,3,3,3,1,1,0,0,3,3,0,0,3,3,0,0,2,2,2,2,2,2,1,1,3,3,0,0,2,2,0,0,1,1,2,2,3,3,3,3,0,0,1,1,1,1,0,0,1,1,0,0,0,0,2,2,1,1,0,0,1,1,3,3,2,2,2,2,3,3,0,0,2,2,3,3,3,3,3,3,3,3,3,3,0,0,1,1,2,2,0,0,1,1,1,1,0,0,3,3,2,2,3,3,0,0,3,3,3,3,2,2,0,0,1,1,3,3,1,1,0,0,1,1,3,3,1,1,0,0,2,2,3,3,0,0,1,1,1,1,3,3,1,1,0,0,1,1,1,1,3,3,3,3,1,1,2,2,1,1,2,2,2,2,1,1,0,0,1,1,3,3,2,2,2,2,1,1,0,0,2,2,3,3,2,2,3,3,2,2,1,1,3,3,3,3,2,2,1,1,0,0,3,3,3,3,2,2,1,1,1,1,3,3,0,0,1,1,3,3,1,1,2,2,1,1,3,3,1,1,1,1,1,1,2,2,2,2,0,0,1,1,2,2,2,2,0,0,0,0,2,2,0,0,2,2,2,2,1,1,3,3,0,0,0,0,2,2,0,0,0,0,3,3,3,3,1,1,2,2,3,3,0,0,2,2,3,3,0,0,2,2,1,1,2,2,2,2,1,1,3,3,3,3,0,0,1,1,0,0,1,1,3,3,0,0,1,1,3,3,1,1,1,1,3,3,1,1,3,3,1,1,3,3,2,2,3,3,2,2,0,0,1,1,3,3,2,2,3,3,0,0,3,3,2,2,1,1,0,0,3,3,2,2,0,0,3,3,2,2,0,0,1,1,2,2,3,3,0,0,3,3,3,3,3,3,0,0,2,2,3,3,2,2,2,2,0,0,3,3,3,3,2,2,0,0,0,0,0,0,0,0,0,0,3,3,0,0,3,3,2,2,1,1,1,1,0,0,3,3,1,1,2,2,2,2,2,2,0,0,2,2,0,0,0,0,2,2,2,2,3,3,0,0,2,2,2,2,3,3,3,3,0,0,0,0,1,1,2,2,0,0,3,3,1,1,0,0,2,2,0,0,2,2,2,2,2,2,0,0,3,3,2,2,1,1,1,1,2,2,0,0,0,0,3,3,3,3,0,0,3,3,1,1,3,3,1,1,3,3,3,3,1,1,0,0,0,0,3,3,0,0,1,1,3,3,2,2,1,1,0,0,3,3,0,0,1,1,0,0,2,2,0,0,2,2,2,2,3,3,2,2,3,3,0,0,1,1,0,0,0,0,2,2,3,3,1,1,0,0,2,2,2,2,1,1,3,3,2,2,0,0,2,2,3,3,2,2,3,3,2,2,0,0,0,0,1,1,2,2,3,3,0,0,2,2,1,1,1,1,2,2,0,0,1,1,1,1,2,2,3,3,1,1,1,1,0,0,2,2,1,1,3,3,1,1,1,1,1,1,3,3,3,3,1,1,2,2,2,2,0,0,3,3,1,1,1,1,2,2,0,0,3,3,3,3,1,1,1,1,3,3,0,0,2,2,3,3,1,1,0,0,2,2,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,0,0,1,1,1,1,0,0,1,1,0,0,3,3,2,2,1,1,2,2,2,2,2,2,2,2,1,1,0,0,2,2,3,3,3,3,0,0,0,0,0,0,1,1,3,3,1,1,0,0,0,0,1,1,3,3,1,1,2,2,1,1,2,2,2,2,3,3,1,1,1,1,0,0,0,0,2,2,2,2,1,1,1,1,1,1,3,3,1,1,0,0,3,3,1,1,3,3,1,1,1,1,3,3,2,2,0,0,3,3,0,0,3,3,1,1,1,1,0,0,1,1,1,1,0,0,3,3,3,3,2,2,3,3,0,0,0,0,3,3,3,3,1,1,1,1,2,2,0,0,2,2,1,1,0,0,2,2,3,3,3,3,3,3,2,2,0,0,3,3,3,3,2,2,0,0,3,3,1,1,0,0,2,2,3,3,3,3,2,2,3,3,2,2,0,0,3,3,0,0,2,2,1,1,1,1,1,1,0,0,3,3,2,2,1,1,1,1,2,2,0,0,1,1,1,1,2,2,1,1,3,3,0,0,0,0,3,3,1,1,3,3,3,3,3,3,1,1,0,0,1,1,0,0,2,2,1,1,0,0,2,2,1,1,0,0,3,3,2,2,2,2,1,1,2,2,0,0,1,1,3,3,2,2,1,1,0,0,0,0,0,0,3,3,2,2,3,3,3,3,0,0,1,1,1,1,3,3,0,0,0,0,3,3,2,2,1,1,3,3,2,2,3,3,2,2,0,0,2,2,0,0,0,0,3,3,3,3,0,0,0,0,1,1,2,2,3,3,3,3,2,2,1,1,0,0,0,0,1,1,3,3,3,3,0,0,0,0,1,1,1,1,2,2,2,2,3,3,2,2,2,2,2,2,0,0,1,1,0,0,2,2,1,1,1,1,1,1,2,2,2,2,2,2,1,1,2,2,0,0,1,1,3,3,1,1,3,3,3,3,0,0,2,2,2,2,1,1,0,0,2,2,3,3,0,0,2,2,2,2,3,3,2,2,3,3,0,0,1,1,1,1,2,2,2,2,3,3,1,1,2,2,3,3,0,0,3,3,1,1,2,2,0,0,1,1,2,2,3,3,0,0,2,2,2,2,3,3,3,3,0,0,1,1,0,0,1,1,0,0,3,3,2,2,0,0,2,2,3,3,2,2,0,0,0,0,1,1,2,2,1,1,2,2,2,2,0,0,0,0,0,0,0,0,2,2,1,1,3,3,0,0,0,0,1,1,1,1,2,2,3,3,0,0,1,1,2,2,2,2,1,1,0,0,3,3,1,1,2,2,2,2,2,2,2,2,1,1,2,2,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,3,3,3,3,0,0,1,1,2,2,1,1,0,0,1,1,0,0,3,3,2,2,1,1,1,1,1,1,0,0,2,2,2,2,0,0,1,1,3,3,1,1,0,0,1,1,0,0,3,3,0,0,1,1,0,0,1,1,1,1,3,3,3,3,1,1,3,3,3,3,0,0,1,1,3,3,0,0,0,0,1,1,3,3,2,2,0,0,2,2,2,2,3,3,2,2,1,1,2,2,3,3,0,0,2,2,3,3,3,3,1,1,1,1,0,0,2,2,3,3,2,2,1,1,0,0,1,1,0,0,0,0,3,3,2,2,1,1,1,1,2,2,3,3,1,1,0,0,1,1,1,1,0,0,2,2,2,2,0,0,0,0,3,3,0,0,0,0,0,0,2,2,2,2,1,1,1,1,0,0,1,1,3,3,3,3,0,0,2,2,0,0,2,2,2,2,2,2,1,1,2,2,0,0,0,0,3,3,0,0,0,0,0,0,1,1,1,1,1,1,2,2,3,3,0,0,3,3,3,3,3,3,1,1,3,3,2,2,2,2,1,1,1,1,1,1,0,0,0,0,2,2,0,0,3,3,2,2,1,1,3,3,1,1,2,2,3,3,2,2,2,2,3,3,1,1,2,2,0,0,0,0,1,1,0,0,3,3,0,0,2,2,1,1,3,3,2,2,1,1,3,3,1,1,1,1,1,1,2,2,3,3,1,1,2,2,3,3,2,2,2,2,0,0,1,1,1,1,2,2,1,1,0,0,2,2,2,2,3,3,3,3,2,2,1,1,1,1,2,2,2,2,0,0,2,2,1,1,3,3,3,3,3,3,1,1,0,0,0,0,1,1,2,2,1,1,0,0,1,1,1,1,2,2,2,2,0,0,2,2,1,1,2,2,1,1,3,3,1,1,1,1,1,1,3,3,2,2,0,0,1,1,1,1,2,2,3,3,3,3,2,2,0,0,1,1,3,3,2,2,2,2,1,1,1,1,0,0,2,2,1,1,0,0,1,1,2,2,0,0,2,2,0,0,0,0,2,2,1,1,0,0,2,2,3,3,3,3,1,1,2,2,3,3,1,1,1,1,0,0,0,0,1,1,0,0,2,2,0,0,1,1,2,2,2,2,3,3,3,3,2,2,0,0,3,3,1,1,1,1,0,0,0,0,0,0,2,2,2,2,0,0,0,0,1,1,1,1,0,0,3,3,1,1,3,3,0,0,0,0,0,0,0,0,1,1,2,2,0,0,0,0,1,1,1,1,2,2,2,2,0,0,1,1,1,1,0,0,2,2,1,1,2,2,1,1,1,1,0,0,0,0,0,0,2,2,3,3,0,0,2,2,0,0,1,1,3,3,2,2,2,2,2,2,2,2,1,1,0,0,0,0,1,1,3,3,2,2,2,2,1,1,2,2,1,1,1,1,3,3,1,1,1,1,0,0,0,0,2,2,0,0,1,1,0,0,3,3,3,3,1,1,0,0,3,3,0,0,3,3,0,0,2,2,1,1,3,3,0,0,0,0,2,2,1,1,0,0,2,2,2,2,0,0,2,2,2,2,0,0,3,3,2,2,2,2,1,1,1,1,3,3,0,0,2,2,2,2,0,0,2,2,2,2,2,2,2,2,0,0,3,3,0,0,0,0,1,1,2,2,0,0,1,1,2,2,0,0,3,3,0,0,3,3,0,0,0,0,2,2,1,1,3,3,0,0,3,3,1,1,0,0,2,2,3,3,0,0,3,3,0,0,0,0,2,2,2,2,1,1,3,3,3,3,2,2,1,1,1,1,2,2,0,0,0,0,3,3,2,2,1,1,3,3,2,2,3,3,0,0,2,2,1,1,1,1,3,3,2,2,0,0,2,2,0,0,2,2,3,3,2,2,2,2,2,2,1,1,1,1,3,3,1,1,1,1,1,1,0,0,2,2,3,3,2,2,3,3,3,3,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,1,1,3,3,1,1,2,2,2,2,2,2,1,1,2,2,3,3,1,1,1,1,3,3,2,2,0,0,3,3,3,3,1,1,1,1,2,2,3,3,1,1,2,2,0,0,0,0,2,2,1,1,3,3,2,2,1,1,2,2,3,3,2,2,0,0,1,1,2,2,3,3,2,2,2,2,0,0,2,2,3,3,1,1,3,3,0,0,1,1,2,2,1,1,1,1,0,0,3,3,0,0,3,3,0,0,0,0,3,3,2,2,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,2,2,0,0,1,1,2,2,0,0,0,0,1,1,0,0,3,3,3,3,1,1,2,2,3,3,2,2,1,1,1,1,2,2,0,0,0,0,1,1,0,0,0,0,2,2,1,1,3,3,0,0,1,1,2,2,2,2,0,0,1,1,1,1,3,3,1,1,1,1,2,2,0,0,3,3,1,1,1,1,1,1,2,2,1,1,2,2,0,0,1,1,2,2,3,3,2,2,1,1,3,3,2,2,1,1,2,2,3,3,2,2,0,0,3,3,0,0,0,0,3,3,2,2,3,3,3,3,1,1,3,3,2,2,0,0,0,0,2,2,0,0,2,2,2,2,3,3,3,3,1,1,2,2,1,1,1,1,2,2,3,3,2,2,3,3,0,0,2,2,0,0,1,1,0,0,3,3,1,1,0,0,2,2,0,0,0,0,3,3,1,1,0,0,2,2,3,3,1,1,0,0,1,1,0,0,3,3,1,1,1,1,1,1,2,2,1,1,0,0,1,1,3,3,0,0,3,3,1,1,3,3,1,1,3,3,1,1,3,3,3,3,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,2,2,2,2,2,2,1,1,0,0,2,2,0,0,0,0,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,2,2,0,0,1,1,1,1,0,0,0,0,1,1,2,2,2,2,0,0,0,0,2,2,3,3,2,2,0,0,3,3,3,3,3,3,3,3,2,2,1,1,1,1,2,2,0,0,2,2,2,2,0,0,3,3,1,1,1,1,2,2,0,0,3,3,2,2,2,2,3,3,0,0,3,3,1,1,1,1,1,1,2,2,3,3,2,2,2,2,1,1,2,2,3,3,3,3,3,3,1,1,0,0,0,0,1,1,2,2,2,2,2,2,1,1,0,0,2,2,2,2,2,2,0,0,1,1,2,2,2,2,3,3,1,1,2,2,1,1,1,1,0,0,2,2,2,2,2,2,0,0,0,0,3,3,0,0,0,0,1,1,3,3,0,0,0,0,3,3,3,3,1,1,2,2,2,2,2,2,1,1,2,2,0,0,1,1,1,1,3,3,2,2,3,3,1,1,1,1,0,0,1,1,0,0,1,1,3,3,0,0,1,1,0,0,1,1,1,1,1,1,0,0,3,3,0,0,1,1,0,0,2,2,1,1,3,3,3,3,2,2,2,2,2,2,3,3,2,2,2,2,0,0,0,0,1,1,0,0,3,3,2,2,0,0,1,1,1,1,1,1,3,3,0,0,3,3,0,0,1,1,0,0,2,2,2,2,1,1,0,0,3,3,0,0,3,3,1,1,0,0,1,1,2,2,3,3,2,2,3,3,3,3,1,1,1,1,1,1,3,3,0,0,0,0,0,0,3,3,0,0,1,1,2,2,2,2,3,3,1,1,2,2,0,0,0,0,1,1,1,1,0,0,1,1,3,3,0,0,0,0,0,0,3,3,0,0,1,1,0,0,3,3,3,3,3,3,0,0,0,0,0,0,1,1,2,2,3,3,0,0,0,0,0,0,1,1,2,2,2,2,2,2,3,3,0,0,2,2,1,1,2,2,3,3,2,2,3,3,2,2,2,2,2,2,2,2,1,1,0,0,3,3,3,3,3,3,1,1,2,2,2,2,3,3,1,1,0,0,0,0,0,0,2,2,0,0,2,2,0,0,3,3,2,2,1,1,1,1,1,1,0,0,0,0,2,2,2,2,0,0,0,0,1,1,1,1,2,2,3,3,2,2,1,1,1,1,3,3,0,0,1,1,2,2,3,3,1,1,2,2,0,0,0,0,0,0,1,1,2,2,3,3,1,1,2,2,3,3,0,0,0,0,0,0,1,1,0,0,3,3,2,2,3,3,2,2,3,3,1,1,3,3,1,1,0,0,3,3,3,3,0,0,3,3,1,1,3,3,2,2,0,0,3,3,0,0,2,2,1,1,2,2,0,0,0,0,1,1,1,1,2,2,0,0,3,3,3,3,2,2,1,1,1,1,3,3,3,3,3,3,0,0,2,2,0,0,2,2,2,2,3,3,1,1,3,3,1,1,2,2,1,1,1,1,2,2,3,3,0,0,3,3,3,3,0,0,0,0,1,1,2,2,1,1,3,3,1,1,1,1,3,3,1,1,3,3,0,0,1,1,0,0,0,0,1,1,3,3,1,1,2,2,2,2,2,2,2,2,1,1,3,3,0,0,3,3,0,0,3,3,0,0,1,1,2,2,0,0,3,3,3,3,0,0,3,3,1,1,1,1,0,0,1,1,2,2,0,0,3,3,1,1,3,3,2,2,1,1,2,2,1,1,2,2,1,1,0,0,3,3,1,1,1,1,3,3,2,2,3,3,1,1,1,1,3,3,0,0,1,1,3,3,1,1,2,2,2,2,0,0,3,3,0,0,2,2,1,1,1,1,0,0,3,3,3,3,1,1,0,0,2,2,0,0,0,0,3,3,0,0,0,0,1,1,2,2,1,1,1,1,2,2,0,0,3,3,1,1,1,1,3,3,0,0,0,0,3,3,1,1,0,0,3,3,2,2,3,3,1,1,2,2,0,0,2,2,3,3,0,0,0,0,1,1,2,2,2,2,3,3,0,0,2,2,0,0,1,1,2,2,2,2,2,2,3,3,3,3,3,3,1,1,2,2,1,1,0,0,3,3,0,0,3,3,0,0,3,3,2,2,0,0,2,2,0,0,1,1,2,2,0,0,2,2,1,1,0,0,1,1,3,3,1,1,1,1,0,0,3,3,2,2,1,1,3,3,2,2,3,3,3,3,0,0,2,2,0,0,0,0,1,1,1,1,0,0,3,3,3,3,2,2,1,1,3,3,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,3,3,2,2,3,3,1,1,0,0,1,1,0,0,3,3,0,0,2,2,2,2,0,0,2,2,0,0,2,2,1,1,1,1,3,3,1,1,3,3,1,1,1,1,2,2,0,0,0,0,0,0,2,2,1,1,2,2,1,1,1,1,0,0,2,2,1,1,1,1,0,0,0,0,3,3,2,2,0,0,1,1,1,1,3,3,3,3,1,1,2,2,1,1,2,2,2,2,0,0,0,0,1,1,2,2,0,0,0,0,1,1,1,1,3,3,3,3,1,1,3,3,0,0,0,0,3,3,2,2,2,2,2,2,3,3,0,0,2,2,0,0,3,3,0,0,1,1,2,2,1,1,1,1,0,0,3,3,3,3,1,1,3,3,0,0,1,1,3,3,2,2,1,1,3,3,3,3,2,2,0,0,0,0,3,3,1,1,3,3,2,2,0,0,3,3,1,1,0,0,0,0,1,1,3,3,1,1,0,0,0,0,2,2,1,1,0,0,0,0,3,3,1,1,0,0,2,2,2,2,0,0,3,3,3,3,0,0,3,3,3,3,1,1,2,2,1,1,2,2,0,0,1,1,0,0,1,1,3,3,0,0,1,1,0,0,1,1,3,3,2,2,2,2,1,1,3,3,2,2,0,0,0,0,3,3,2,2,2,2,3,3,1,1,0,0,0,0,2,2,0,0,3,3,0,0,3,3,2,2,0,0,1,1,0,0,3,3,1,1,2,2,1,1,1,1,3,3,1,1,2,2,2,2,0,0,0,0,2,2,2,2,0,0,0,0,2,2,0,0,2,2,3,3,2,2,0,0,1,1,3,3,3,3,3,3,3,3,2,2,0,0,0,0,3,3,2,2,3,3,3,3,3,3,0,0,2,2,1,1,1,1,3,3,3,3,0,0,2,2,3,3,0,0,2,2,1,1,3,3,3,3,3,3,0,0,1,1,0,0,1,1,1,1,3,3,3,3,1,1,2,2,3,3,0,0,2,2,0,0,2,2,0,0,2,2,2,2,3,3,1,1,2,2,1,1,0,0,1,1,3,3,1,1,1,1,3,3,2,2,2,2,0,0,1,1,3,3,2,2,1,1,3,3,2,2,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,0,0,1,1,3,3,1,1,1,1,2,2,3,3,1,1,1,1,1,1,1,1,2,2,0,0,2,2,1,1,3,3,3,3,1,1,3,3,0,0,3,3,2,2,2,2,2,2,0,0,0,0,0,0,3,3,1,1,0,0,3,3,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,1,1,0,0,1,1,3,3,3,3,0,0,0,0,0,0,2,2,3,3,0,0,3,3,3,3,2,2,0,0,1,1,0,0,0,0,3,3,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,1,1,2,2,1,1,2,2,3,3,1,1,3,3,0,0,2,2,2,2,2,2,2,2,2,2,2,2,1,1,0,0,0,0,0,0,1,1,2,2,2,2,2,2,0,0,3,3,0,0,0,0,2,2,2,2,2,2,1,1,3,3,2,2,3,3,3,3,3,3,2,2,0,0,0,0,0,0,0,0,1,1,1,1,1,1,3,3,0,0,3,3,2,2,2,2,2,2,1,1,2,2,2,2,3,3,2,2,0,0,0,0,2,2,2,2,1,1,0,0,1,1,2,2,0,0,1,1,0,0,3,3,0,0,0,0,3,3,3,3,3,3,2,2,1,1,3,3,3,3,1,1,0,0,1,1,3,3,2,2,0,0,0,0,2,2,2,2,1,1,2,2,1,1,0,0,0,0,1,1,1,1,1,1,3,3,3,3,0,0,1,1,1,1,2,2,1,1,1,1,3,3,1,1,3,3,3,3,1,1,0,0,1,1,2,2,2,2,1,1,0,0,3,3,2,2,2,2,2,2,3,3,1,1,0,0,3,3,1,1,0,0,1,1,0,0,1,1,0,0,1,1,3,3,0,0,1,1,0,0,3,3,3,3,0,0,1,1,3,3,1,1,0,0,0,0,0,0,2,2,0,0,1,1,2,2,2,2,2,2,0,0,1,1,3,3,3,3,3,3,1,1,0,0,3,3,0,0,0,0,1,1,2,2,2,2,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,3,3,0,0,3,3,3,3,0,0,0,0,1,1,3,3,3,3,0,0,3,3,1,1,2,2,0,0,3,3,1,1,1,1,0,0,1,1,1,1,3,3,2,2,0,0,0,0,3,3,1,1,0,0,0,0,3,3,1,1,1,1,1,1,1,1,3,3,1,1,3,3,1,1,0,0,3,3,1,1,3,3,0,0,3,3,2,2,0,0,3,3,3,3,0,0,1,1,0,0,3,3,1,1,0,0,2,2,0,0,3,3,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,1,1,0,0,1,1,2,2,1,1,3,3,1,1,3,3,3,3,2,2,1,1,2,2,0,0,1,1,3,3,3,3,2,2,0,0,1,1,0,0,2,2,3,3,2,2,2,2,2,2,1,1,2,2,2,2,2,2,2,2,1,1,0,0,2,2,0,0,0,0,0,0,0,0,2,2,2,2,3,3,2,2,1,1,0,0,0,0,0,0,2,2,3,3,0,0,3,3,1,1,0,0,0,0,0,0,2,2,1,1,1,1,3,3,2,2,2,2,3,3,3,3,0,0,1,1,0,0,1,1,2,2,1,1,1,1,1,1,0,0,0,0,3,3,2,2,0,0,0,0,2,2,2,2,3,3,3,3,0,0,1,1,1,1,3,3,2,2,1,1,1,1,2,2,3,3,0,0,0,0,1,1,1,1,1,1,1,1,3,3,2,2,2,2,0,0,2,2,1,1,2,2,1,1,0,0,2,2,2,2,3,3,3,3,3,3,0,0,0,0,0,0,2,2,1,1,1,1,3,3,1,1,0,0,2,2,3,3,2,2,0,0,0,0,3,3,0,0,2,2,1,1,0,0,0,0,0,0,3,3,3,3,0,0,2,2,2,2,1,1,0,0,3,3,1,1,3,3,0,0,1,1,1,1,3,3,1,1,1,1,0,0,3,3,2,2,0,0,0,0,2,2,0,0,3,3,3,3,0,0,2,2,1,1,3,3,1,1,2,2,0,0,1,1,1,1,0,0,2,2,1,1,3,3,0,0,2,2,3,3,2,2,2,2,3,3,0,0,0,0,2,2,1,1,0,0,2,2,3,3,2,2,0,0,3,3,3,3,1,1,2,2,0,0,3,3,1,1,0,0,0,0,2,2,3,3,1,1,0,0,1,1,2,2,1,1,3,3,2,2,1,1,0,0,2,2,2,2,2,2,1,1,3,3,2,2,2,2,2,2,1,1,3,3,3,3,2,2,0,0,3,3,0,0,3,3,0,0,2,2,2,2,1,1,1,1,2,2,0,0,2,2,0,0,1,1,3,3,1,1,3,3,2,2,2,2,0,0,0,0,3,3,3,3,0,0,2,2,2,2,3,3,1,1,1,1,1,1,0,0,1,1,2,2,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,2,2,2,2,1,1,2,2,0,0,3,3,0,0,3,3,0,0,2,2,2,2,0,0,2,2,0,0,2,2,2,2,1,1,3,3,1,1,0,0,2,2,3,3,1,1,1,1,3,3,2,2,2,2,2,2,0,0,1,1,2,2,1,1,0,0,1,1,1,1,0,0,2,2,3,3,3,3,3,3,1,1,1,1,0,0,3,3,0,0,0,0,3,3,1,1,0,0,3,3,2,2,3,3,2,2,2,2,2,2,2,2,2,2,2,2,3,3,1,1,3,3,2,2,1,1,0,0,0,0,3,3,3,3,3,3,0,0,1,1,1,1,2,2,1,1,3,3,2,2,2,2,0,0,3,3,0,0,1,1,3,3,0,0,0,0,1,1,2,2,2,2,0,0,0,0,0,0,3,3,3,3,3,3,2,2,0,0,3,3,0,0,0,0,0,0,3,3,3,3,1,1,2,2,1,1,2,2,0,0,0,0,2,2,2,2,3,3,2,2,0,0,1,1,2,2,0,0,3,3,3,3,2,2,3,3,0,0,2,2,2,2,2,2,2,2,2,2,3,3,1,1,1,1,2,2,2,2,0,0,0,0,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,3,3,2,2,3,3,2,2,1,1,1,1,2,2,0,0,0,0,3,3,3,3,0,0,2,2,0,0,2,2,1,1,0,0,3,3,2,2,2,2,3,3,2,2,2,2,2,2,0,0,0,0,3,3,0,0,2,2,1,1,3,3,2,2,2,2,1,1,0,0,2,2,0,0,3,3,3,3,3,3,1,1,1,1,3,3,2,2,0,0,0,0,1,1,0,0,3,3,3,3,0,0,3,3,3,3,3,3,3,3,0,0,3,3,1,1,2,2,1,1,2,2,1,1,0,0,1,1,0,0,1,1,3,3,1,1,2,2,3,3,0,0,3,3,1,1,3,3,3,3,2,2,2,2,3,3,2,2,3,3,3,3,0,0,2,2,0,0,0,0,2,2,2,2,0,0,2,2,3,3,3,3,1,1,0,0,2,2,1,1,0,0,3,3,3,3,1,1,3,3,2,2,1,1,3,3,2,2,0,0,3,3,0,0,1,1,2,2,0,0,0,0,1,1,0,0,2,2,3,3,0,0,0,0,2,2,3,3,3,3,3,3,3,3,0,0,2,2,1,1,2,2,0,0,1,1,3,3,1,1,0,0,2,2,3,3,2,2,1,1,3,3,3,3,2,2,2,2,0,0,1,1,1,1,1,1,3,3,0,0,1,1,0,0,0,0,1,1,1,1,2,2,1,1,3,3,1,1,2,2,0,0,0,0,0,0,0,0,1,1,1,1,3,3,1,1,3,3,0,0,3,3,2,2,1,1,0,0,3,3,2,2,3,3,3,3,2,2,2,2,0,0,0,0,2,2,3,3,2,2,3,3,2,2,1,1,3,3,3,3,2,2,3,3,0,0,1,1,0,0,1,1,2,2,3,3,3,3,1,1,0,0,1,1,1,1,0,0,0,0,2,2,2,2,2,2,1,1,0,0,3,3,2,2,0,0,2,2,0,0,3,3,2,2,0,0,0,0,3,3,2,2,3,3,3,3,2,2,1,1,2,2,0,0,1,1,3,3,2,2,1,1,2,2,1,1,0,0,0,0,1,1,3,3,1,1,2,2,2,2,1,1,2,2,1,1,0,0,3,3,3,3,1,1,1,1,0,0,1,1,0,0,0,0,3,3,0,0,1,1,3,3,1,1,1,1,1,1,1,1,3,3,2,2,3,3,1,1,0,0,0,0,1,1,1,1,3,3,1,1,3,3,1,1,2,2,0,0,3,3,0,0,1,1,1,1,2,2,3,3,3,3,3,3,3,3,3,3,0,0,3,3,1,1,0,0,0,0,3,3,1,1,2,2,0,0,0,0,0,0,3,3,2,2,1,1,0,0,3,3,3,3,0,0,0,0,3,3,3,3,2,2,0,0,2,2,3,3,0,0,3,3,2,2,1,1,2,2,3,3,0,0,3,3,0,0,1,1,1,1,0,0,0,0,1,1,3,3,1,1,2,2,2,2,2,2,3,3,0,0,2,2,1,1,1,1,3,3,1,1,0,0,0,0,3,3,0,0,1,1,0,0,1,1,2,2,1,1,2,2,0,0,0,0,3,3,3,3,3,3,0,0,2,2,0,0,1,1,0,0,0,0,0,0,0,0,2,2,1,1,0,0,0,0,3,3,3,3,1,1,3,3,2,2,2,2,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,3,3,1,1,2,2,2,2,1,1,0,0,3,3,0,0,0,0,3,3,2,2,0,0,0,0,1,1,3,3,0,0,1,1,3,3,2,2,0,0,2,2,1,1,2,2,1,1,0,0,2,2,2,2,0,0,1,1,2,2,1,1,0,0,2,2,2,2,3,3,2,2,1,1,0,0,3,3,3,3,1,1,2,2,1,1,3,3,0,0,1,1,1,1,3,3,1,1,2,2,2,2,0,0,1,1,2,2,3,3,0,0,3,3,1,1,0,0,2,2,0,0,1,1,0,0,1,1,1,1,2,2,1,1,3,3,1,1,0,0,2,2,0,0,2,2,0,0,3,3,3,3,3,3,0,0,2,2,2,2,3,3,1,1,0,0,0,0,1,1,2,2,2,2,0,0,3,3,2,2,0,0,1,1,2,2,3,3,1,1,0,0,1,1,1,1,3,3,3,3,3,3,0,0,0,0,1,1,1,1,0,0,1,1,0,0,3,3,1,1,1,1,2,2,3,3,1,1,2,2,2,2,0,0,1,1,3,3,1,1,0,0,2,2,3,3,1,1,1,1,0,0,1,1,0,0,2,2,1,1,1,1,0,0,1,1,2,2,3,3,1,1,3,3,2,2,1,1,0,0,1,1,0,0,2,2,0,0,2,2,1,1,0,0,2,2,3,3,2,2,3,3,1,1,0,0,2,2,2,2,2,2,1,1,1,1,3,3,0,0,0,0,0,0,0,0,2,2,1,1,3,3,3,3,2,2,0,0,2,2,3,3,2,2,1,1,1,1,2,2,0,0,3,3,0,0,0,0,1,1,2,2,1,1,0,0,0,0,3,3,1,1,0,0,3,3,3,3,1,1,2,2,1,1,3,3,3,3,0,0,2,2,3,3,2,2,0,0,2,2,1,1,0,0,3,3,2,2,1,1,0,0,1,1,2,2,1,1,1,1,1,1,2,2,3,3,0,0,3,3,2,2,2,2,1,1,3,3,2,2,1,1,1,1,0,0,0,0,0,0,1,1,2,2,1,1,0,0,2,2,0,0,0,0,1,1,2,2,0,0,2,2,1,1,1,1,0,0,3,3,1,1,2,2,0,0,3,3,1,1,1,1,1,1,0,0,2,2,3,3,3,3,0,0,0,0,1,1,0,0,2,2,1,1,1,1,2,2,3,3,0,0,0,0,0,0,2,2,3,3,1,1,1,1,0,0,1,1,3,3,1,1,2,2,1,1,3,3,0,0,1,1,2,2,0,0,2,2,1,1,0,0,2,2,0,0,3,3,0,0,3,3,3,3,1,1,1,1,0,0,1,1,2,2,0,0,3,3,2,2,0,0,0,0,0,0,1,1,2,2,0,0,3,3,3,3,2,2,3,3,0,0,2,2,3,3,0,0,1,1,3,3,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,3,3,2,2,1,1,1,1,2,2,1,1,0,0,1,1,0,0,3,3,1,1,0,0,0,0,1,1,2,2,3,3,2,2,2,2,1,1,2,2,2,2,3,3,2,2,2,2,3,3,0,0,3,3,3,3,0,0,2,2,1,1,2,2,1,1,0,0,1,1,3,3,2,2,2,2,2,2,2,2,2,2,0,0,0,0,2,2,0,0,3,3,2,2,2,2,0,0,2,2,1,1,3,3,0,0,2,2,0,0,1,1,0,0,0,0,3,3,0,0,0,0,0,0,2,2,3,3,0,0,3,3,1,1,0,0,3,3,0,0,2,2,0,0,0,0,2,2,3,3,2,2,0,0,1,1,0,0,2,2,0,0,3,3,1,1,3,3,2,2,0,0,3,3,3,3,0,0,0,0,1,1,0,0,3,3,0,0,3,3,3,3,1,1,3,3,2,2,3,3,2,2,2,2,3,3,3,3,1,1,2,2,1,1,3,3,0,0,2,2,0,0,3,3,1,1,3,3,2,2,3,3,2,2,2,2,0,0,1,1,2,2,0,0,1,1,0,0,0,0,1,1,3,3,0,0,0,0,3,3,2,2,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,2,2,3,3,1,1,2,2,1,1,0,0,3,3,1,1,2,2,2,2,0,0,1,1,0,0,2,2,3,3,0,0,1,1,1,1,3,3,1,1,2,2,2,2,3,3,1,1,3,3,3,3,1,1,2,2,2,2,1,1,0,0,3,3,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,3,3,1,1,3,3,2,2,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,3,3,2,2,3,3,1,1,1,1,0,0,1,1,1,1,0,0,0,0,3,3,0,0,1,1,0,0,3,3,0,0,1,1,0,0,0,0,1,1,2,2,2,2,0,0,0,0,3,3,0,0,0,0,1,1,2,2,2,2,0,0,3,3,3,3,0,0,2,2,0,0,3,3,0,0,0,0,2,2,0,0,3,3,2,2,3,3,1,1,1,1,1,1,0,0,1,1,3,3,1,1,3,3,2,2,0,0,2,2,1,1,3,3,2,2,1,1,0,0,1,1,0,0,3,3,3,3,2,2,3,3,3,3,0,0,2,2,0,0,1,1,2,2,2,2,2,2,1,1,3,3,3,3,0,0,1,1,1,1,3,3,0,0,2,2,2,2,1,1,1,1,0,0,3,3,0,0,3,3,2,2,0,0,3,3,3,3,1,1,3,3,2,2,2,2,2,2,3,3,3,3,3,3,3,3,1,1,0,0,1,1,3,3,3,3,2,2,2,2,3,3,3,3,3,3,2,2,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,0,0,2,2,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,3,3,0,0,2,2,3,3,3,3,1,1,0,0,2,2,2,2,1,1,0,0,2,2,1,1,0,0,2,2,0,0,0,0,2,2,2,2,3,3,1,1,3,3,2,2,1,1,3,3,3,3,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,2,2,1,1,2,2,0,0,0,0,2,2,2,2,0,0,0,0,3,3,1,1,3,3,3,3,0,0,1,1,0,0,0,0,0,0,0,0,3,3,2,2,3,3,1,1,0,0,1,1,1,1,3,3,1,1,0,0,2,2,2,2,3,3,3,3,2,2,2,2,2,2,0,0,1,1,0,0,2,2,1,1,0,0,0,0,1,1,2,2,1,1,2,2,2,2,2,2,3,3,0,0,0,0,2,2,0,0,3,3,1,1,2,2,2,2,1,1,2,2,0,0,1,1,2,2,2,2,3,3,1,1,3,3,0,0,2,2,1,1,1,1,3,3,3,3,3,3,1,1,1,1,3,3,0,0,0,0,2,2,1,1,0,0,2,2,2,2,1,1,2,2,1,1,1,1,1,1,1,1,3,3,2,2,0,0,3,3,0,0,3,3,3,3,0,0,1,1,2,2,0,0,2,2,2,2,0,0,3,3,2,2,2,2,1,1,1,1,2,2,3,3,0,0,1,1,3,3,3,3,0,0,0,0,1,1,3,3,1,1,1,1,2,2,0,0,0,0,3,3,3,3,1,1,2,2,0,0,1,1,0,0,0,0,3,3,2,2,0,0,0,0,3,3,0,0,1,1,0,0,0,0,3,3,3,3,1,1,2,2,3,3,1,1,1,1,0,0,0,0,2,2,2,2,2,2,2,2,2,2,3,3,3,3,2,2,1,1,1,1,2,2,3,3,2,2,2,2,2,2,2,2,1,1,3,3,3,3,2,2,1,1,0,0,2,2,1,1,3,3,0,0,0,0,1,1,1,1,3,3,1,1,3,3,0,0,3,3,2,2,0,0,1,1,0,0,3,3,1,1,3,3,2,2,1,1,3,3,0,0,3,3,0,0,1,1,2,2,3,3,3,3,1,1,2,2,0,0,3,3,2,2,3,3,0,0,0,0,3,3,1,1,0,0,3,3,0,0,3,3,1,1,2,2,1,1,1,1,3,3,2,2,3,3,1,1,2,2,3,3,3,3,1,1,0,0,0,0,1,1,0,0,0,0,2,2,1,1,3,3,1,1,1,1,1,1,3,3,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,3,3,2,2,0,0,1,1,0,0,3,3,2,2,3,3,3,3,3,3,1,1,2,2,3,3,1,1,0,0,1,1,0,0,3,3,2,2,1,1,0,0,2,2,1,1,2,2,3,3,0,0,0,0,0,0,1,1,0,0,2,2,0,0,1,1,0,0,1,1,2,2,2,2,3,3,1,1,2,2,1,1,0,0,2,2,3,3,3,3,2,2,1,1,0,0,1,1,2,2,3,3,3,3,2,2,1,1,1,1,3,3,0,0,3,3,2,2,0,0,1,1,1,1,0,0,2,2,1,1,3,3,2,2,0,0,3,3,0,0,1,1,3,3,2,2,0,0,0,0,0,0,3,3,1,1,2,2,1,1,3,3,0,0,2,2,2,2,1,1,2,2,0,0,3,3,3,3,2,2,0,0,0,0,2,2,3,3,3,3,3,3,0,0,0,0,3,3,0,0,2,2,1,1,0,0,1,1,0,0,2,2,1,1,1,1,1,1,3,3,0,0,1,1,2,2,2,2,2,2,1,1,2,2,2,2,0,0,0,0,3,3,1,1,2,2,1,1,0,0,3,3,3,3,0,0,2,2,3,3,0,0,0,0,3,3,3,3,3,3,3,3,0,0,2,2,3,3,3,3,2,2,2,2,1,1,3,3,0,0,1,1,2,2,2,2,0,0,0,0,3,3,0,0,1,1,1,1,0,0,2,2,1,1,3,3,2,2,0,0,2,2,2,2,0,0,3,3,2,2,0,0,3,3,3,3,3,3,1,1,0,0,3,3,2,2,3,3,2,2,3,3,1,1,2,2,1,1,1,1,3,3,3,3,0,0,1,1,3,3,2,2,1,1,2,2,2,2,0,0,2,2,2,2,2,2,3,3,0,0,0,0,0,0,2,2,1,1,0,0,0,0,0,0,1,1,2,2,2,2,1,1,2,2,2,2,1,1,1,1,0,0,1,1,0,0,2,2,3,3,3,3,3,3,3,3,3,3,2,2,0,0,2,2,1,1,0,0,1,1,3,3,1,1,3,3,1,1,1,1,0,0,2,2,3,3,0,0,2,2,3,3,1,1,2,2,0,0,3,3,0,0,1,1,0,0,1,1,0,0,3,3,3,3,0,0,0,0,1,1,3,3,3,3,0,0,2,2,1,1,0,0,2,2,0,0,2,2,2,2,1,1,1,1,1,1,3,3,0,0,3,3,2,2,1,1,2,2,1,1,2,2,0,0,1,1,0,0,0,0,1,1,1,1,2,2,0,0,2,2,1,1,1,1,1,1,2,2,3,3,2,2,3,3,3,3,1,1,0,0,3,3,2,2,0,0,0,0,1,1,0,0,0,0,0,0,2,2,3,3,0,0,3,3,1,1,0,0,1,1,1,1,2,2,3,3,0,0,0,0,3,3,0,0,3,3,1,1,0,0,2,2,3,3,2,2,0,0,0,0,0,0,2,2,1,1,3,3,3,3,1,1,3,3,0,0,3,3,3,3,1,1,2,2,0,0,0,0,2,2,0,0,1,1,2,2,3,3,0,0,0,0,0,0,2,2,3,3,2,2,1,1,0,0,3,3,3,3,3,3,3,3,2,2,1,1,3,3,0,0,1,1,0,0,0,0,0,0,2,2,1,1,2,2,2,2,3,3,0,0,1,1,2,2,1,1,0,0,3,3,3,3,3,3,1,1,1,1,3,3,1,1,1,1,2,2,0,0,2,2,2,2,2,2,0,0,0,0,1,1,2,2,1,1,0,0,2,2,2,2,2,2,3,3,3,3,3,3,3,3,0,0,1,1,0,0,3,3,2,2,1,1,3,3,1,1,2,2,3,3,3,3,0,0,1,1,1,1,3,3,0,0,0,0,1,1,0,0,3,3,1,1,3,3,3,3,3,3,3,3,0,0,3,3,1,1,1,1,0,0,3,3,0,0,3,3,3,3,2,2,0,0,3,3,1,1,2,2,0,0,1,1,3,3,3,3,3,3,2,2,1,1,0,0,2,2,3,3,3,3,2,2,3,3,0,0,1,1,3,3,0,0,2,2,3,3,3,3,1,1,3,3,0,0,1,1,3,3,0,0,1,1,2,2,3,3,3,3,3,3,1,1,2,2,2,2,1,1,0,0,2,2,2,2,3,3,1,1,3,3,0,0,3,3,1,1,1,1,1,1,0,0,3,3,2,2,1,1,0,0,3,3,0,0,0,0,3,3,2,2,0,0,2,2,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,1,1,2,2,1,1,3,3,2,2,0,0,3,3,2,2,0,0,3,3,1,1,3,3,3,3,1,1,2,2,2,2,2,2,2,2,2,2,3,3,0,0,3,3,0,0,1,1,1,1,1,1,3,3,1,1,2,2,3,3,0,0,2,2,2,2,0,0,1,1,1,1,0,0,2,2,2,2,2,2,3,3,1,1,3,3,0,0,0,0,2,2,0,0,2,2,3,3,2,2,1,1,0,0,3,3,0,0,3,3,2,2,1,1,3,3,0,0,2,2,3,3,3,3,0,0,0,0,2,2,3,3,3,3,0,0,0,0,0,0,2,2,2,2,2,2,2,2,3,3,2,2,2,2,2,2,3,3,0,0,0,0,0,0,1,1,0,0,1,1,2,2,2,2,0,0,0,0,0,0,3,3,1,1,3,3,2,2,2,2,3,3,1,1,3,3,0,0,3,3,0,0,2,2,1,1,1,1,1,1,3,3,0,0,2,2,1,1,3,3,3,3,0,0,0,0,2,2,1,1,3,3,0,0,0,0,1,1,1,1,2,2,0,0,2,2,1,1,3,3,1,1,3,3,2,2,2,2,2,2,2,2,0,0,2,2,2,2,0,0,1,1,1,1,3,3,0,0,3,3,2,2,0,0,2,2,0,0,3,3,2,2,1,1,1,1,3,3,2,2,2,2,0,0,2,2,1,1,3,3,3,3,0,0,1,1,0,0,3,3,1,1,2,2,3,3,3,3,2,2,3,3,3,3,3,3,0,0,3,3,1,1,2,2,3,3,1,1,3,3,2,2,3,3,0,0,1,1,0,0,0,0,0,0,2,2,3,3,1,1,2,2,2,2,2,2,2,2,0,0,0,0,2,2,0,0,2,2,1,1,2,2,3,3,0,0,3,3,1,1,2,2,2,2,1,1,2,2,0,0,1,1,2,2,1,1,2,2,1,1,2,2,1,1,2,2,2,2,0,0,3,3,0,0,3,3,1,1,1,1,2,2,3,3,1,1,0,0,0,0,1,1,2,2,0,0,3,3,0,0,3,3,2,2,0,0,3,3,2,2,2,2,0,0,1,1,1,1,3,3,3,3,2,2,3,3,3,3,1,1,2,2,1,1,2,2,3,3,2,2,3,3,3,3,1,1,0,0,3,3,0,0,2,2,0,0,2,2,1,1,2,2,2,2,0,0,1,1,2,2,0,0,1,1,0,0,1,1,0,0,0,0,2,2,3,3,2,2,1,1,0,0,3,3,2,2,0,0,2,2,2,2,2,2,1,1,2,2,3,3,3,3,3,3,0,0,0,0,3,3,1,1,3,3,1,1,3,3,3,3,3,3,1,1,0,0,0,0,0,0,3,3,3,3,0,0,3,3,2,2,0,0,0,0,2,2,1,1,0,0,2,2,3,3,2,2,3,3,3,3,3,3,3,3,0,0,2,2,0,0,1,1,2,2,0,0,2,2,0,0,2,2,3,3,2,2,2,2,3,3,1,1,2,2,3,3,2,2,1,1,2,2,0,0,3,3,1,1,0,0,2,2,0,0,0,0,2,2,0,0,1,1,2,2,2,2,0,0,1,1,0,0,0,0,0,0,3,3,0,0,2,2,1,1,0,0,2,2,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,3,3,2,2,1,1,2,2,3,3,1,1,0,0,2,2,3,3,1,1,2,2,0,0,1,1,1,1,3,3,2,2,0,0,1,1,1,1,0,0,3,3,3,3,2,2,0,0,3,3,2,2,2,2,0,0,0,0,1,1,2,2,2,2,0,0,0,0,1,1,0,0,3,3,1,1,0,0,1,1,3,3,2,2,1,1,2,2,1,1,3,3,1,1,0,0,2,2,1,1,0,0,2,2,3,3,1,1,2,2,3,3,3,3,0,0,0,0,3,3,0,0,0,0,0,0,3,3,2,2,0,0,1,1,1,1,3,3,1,1,3,3,1,1,0,0,0,0,0,0,1,1,2,2,3,3,1,1,2,2,0,0,2,2,2,2,1,1,1,1,0,0,2,2,2,2,3,3,0,0,0,0,0,0,2,2,1,1,2,2,1,1,3,3,2,2,3,3,3,3,2,2,0,0,0,0,3,3,0,0,1,1,3,3,1,1,2,2,0,0,3,3,0,0,1,1,2,2,2,2,0,0,2,2,3,3,0,0,0,0,2,2,0,0,2,2,3,3,2,2,1,1,0,0,3,3,2,2,3,3,2,2,2,2,2,2,2,2,2,2,0,0,2,2,0,0,2,2,1,1,1,1,0,0,3,3,1,1,2,2,0,0,2,2,2,2,1,1,2,2,2,2,2,2,0,0,3,3,1,1,1,1,0,0,3,3,3,3,3,3,3,3,2,2,0,0,0,0,0,0,0,0,3,3,2,2,3,3,0,0,2,2,1,1,1,1,2,2,1,1,0,0,0,0,1,1,3,3,1,1,1,1,1,1,0,0,3,3,0,0,1,1,2,2,2,2,3,3,1,1,1,1,2,2,0,0,2,2,3,3,1,1,2,2,1,1,1,1,2,2,3,3,2,2,3,3,2,2,1,1,2,2,2,2,2,2,0,0,3,3,3,3,3,3,1,1,0,0,0,0,2,2,3,3,2,2,3,3,3,3,0,0,2,2,3,3,1,1,1,1,2,2,1,1,1,1,2,2,2,2,1,1,2,2,0,0,0,0,3,3,2,2,1,1,3,3,2,2,3,3,3,3,3,3,1,1,2,2,0,0,0,0,3,3,1,1,3,3,0,0,2,2,2,2,2,2,3,3,1,1,3,3,1,1,1,1,0,0,0,0,3,3,1,1,0,0,1,1,2,2,2,2,2,2,0,0,3,3,0,0,1,1,2,2,2,2,1,1,0,0,2,2,2,2,1,1,2,2,3,3,0,0,0,0,2,2,0,0,1,1,1,1,1,1,1,1,1,1,2,2,3,3,2,2,3,3,3,3,0,0,2,2,1,1,0,0,0,0,0,0,3,3,1,1,2,2,1,1,2,2,1,1,3,3,1,1,1,1,0,0,0,0,0,0,0,0,2,2,3,3,2,2,1,1,3,3,2,2,1,1,2,2,2,2,3,3,2,2,1,1,0,0,0,0,0,0,3,3,0,0,1,1,2,2,3,3,1,1,1,1,3,3,2,2,1,1,1,1,1,1,2,2,0,0,0,0,1,1,2,2,3,3,0,0,3,3,0,0,3,3,0,0,3,3,3,3,2,2,2,2,3,3,0,0,2,2,0,0,2,2,3,3,2,2,0,0,0,0,0,0,0,0,2,2,3,3,3,3,3,3,2,2,1,1,0,0,2,2,2,2,2,2,0,0,1,1,2,2,0,0,3,3,0,0,3,3,1,1,2,2,1,1,0,0,2,2,2,2,0,0,0,0,2,2,1,1,2,2,0,0,1,1,0,0,0,0,3,3,0,0,3,3,0,0,3,3,0,0,1,1,1,1,2,2,2,2,3,3,2,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,0,0,1,1,1,1,0,0,0,0,0,0,2,2,0,0,1,1,2,2,3,3,3,3,1,1,0,0,0,0,1,1,2,2,3,3,1,1,3,3,2,2,0,0,0,0,1,1,2,2,2,2,1,1,0,0,3,3,0,0,2,2,2,2,2,2,1,1,1,1,1,1,0,0,1,1,2,2,1,1,3,3,1,1,3,3,1,1,3,3,0,0,0,0,2,2,0,0,3,3,1,1,1,1,0,0,1,1,1,1,3,3,1,1,1,1,0,0,3,3,2,2,1,1,1,1,2,2,1,1,2,2,2,2,2,2,2,2,1,1,0,0,1,1,0,0,1,1,3,3,2,2,2,2,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,3,3,1,1,0,0,1,1,0,0,3,3,0,0,2,2,0,0,0,0,2,2,3,3,0,0,0,0,0,0,0,0,0,0,2,2,1,1,2,2,0,0,1,1,0,0,1,1,3,3,1,1,1,1,0,0,1,1,2,2,1,1,3,3,1,1,3,3,3,3,1,1,1,1,2,2,3,3,2,2,2,2,0,0,0,0,0,0,1,1,2,2,2,2,3,3,1,1,0,0,2,2,1,1,2,2,0,0,1,1,1,1,2,2,1,1,0,0,0,0,3,3,2,2,3,3,0,0,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,3,3,1,1,2,2,0,0,3,3,1,1,0,0,3,3,3,3,3,3,3,3,0,0,0,0,3,3,1,1,2,2,1,1,3,3,3,3,3,3,1,1,2,2,1,1,2,2,1,1,0,0,3,3,3,3,2,2,1,1,1,1,1,1,0,0,3,3,3,3,2,2,2,2,3,3,3,3,1,1,0,0,2,2,2,2,0,0,0,0,3,3,0,0,1,1,1,1,0,0,3,3,1,1,2,2,3,3,1,1,1,1,2,2,2,2,1,1,1,1,2,2,0,0,3,3,2,2,2,2,3,3,2,2,2,2,2,2,1,1,0,0,2,2,0,0,3,3,0,0,2,2,2,2,0,0,3,3,0,0,3,3,1,1,0,0,1,1,2,2,1,1,0,0,2,2,1,1,2,2,0,0,1,1,3,3,2,2,3,3,0,0,2,2,3,3,1,1,0,0,1,1,3,3,1,1,3,3,2,2,1,1,3,3,0,0,0,0,1,1,0,0,0,0,1,1,1,1,3,3,1,1,1,1,1,1,2,2,2,2,1,1,2,2,2,2,1,1,1,1,1,1,0,0,1,1,3,3,3,3,0,0,3,3,1,1,3,3,0,0,3,3,1,1,3,3,1,1,1,1,1,1,0,0,2,2,1,1,0,0,1,1,2,2,2,2,3,3,1,1,1,1,2,2,0,0,1,1,2,2,1,1,1,1,3,3,3,3,1,1,3,3,0,0,0,0,2,2,2,2,1,1,1,1,2,2,2,2,0,0,0,0,3,3,3,3,3,3,1,1,0,0,1,1,3,3,3,3,3,3,2,2,3,3,3,3,3,3,0,0,3,3,2,2,3,3,1,1,1,1,2,2,3,3,1,1,0,0,1,1,1,1,1,1,0,0,2,2,0,0,3,3,0,0,3,3,2,2,3,3,2,2,2,2,0,0,0,0,0,0,1,1,2,2,2,2,1,1,3,3,1,1,1,1,0,0,0,0,2,2,1,1,3,3,0,0,0,0,1,1,1,1,3,3,1,1,1,1,0,0,1,1,3,3,1,1,1,1,2,2,0,0,0,0,2,2,1,1,3,3,0,0,1,1,1,1,3,3,2,2,3,3,1,1,1,1,0,0,1,1,3,3,1,1,3,3,3,3,0,0,1,1,1,1,1,1,1,1,0,0,1,1,3,3,1,1,0,0,2,2,0,0,3,3,3,3,1,1,2,2,2,2,0,0,3,3,0,0,1,1,2,2,1,1,3,3,1,1,1,1,2,2,1,1,3,3,0,0,3,3,2,2,2,2,3,3,0,0,2,2,1,1,0,0,1,1,1,1,3,3,2,2,1,1,1,1,3,3,1,1,2,2,2,2,3,3,0,0,0,0,2,2,1,1,2,2,1,1,1,1,0,0,1,1,3,3,3,3,0,0,1,1,3,3,1,1,0,0,0,0,1,1,2,2,0,0,2,2,1,1,1,1,0,0,1,1,1,1,3,3,3,3,1,1,1,1,3,3,1,1,1,1,2,2,2,2,1,1,2,2,0,0,1,1,2,2,2,2,3,3,2,2,1,1,2,2,3,3,2,2,3,3,3,3,2,2,3,3,3,3,2,2,1,1,0,0,3,3,3,3,1,1,2,2,3,3,2,2,1,1,2,2,2,2,2,2,2,2,1,1,3,3,0,0,0,0,1,1,2,2,2,2,2,2,0,0,3,3,0,0,3,3,3,3,1,1,0,0,3,3,1,1,1,1,0,0,1,1,1,1,0,0,1,1,2,2,1,1,1,1,1,1,2,2,1,1,2,2,0,0,3,3,0,0,1,1,2,2,0,0,0,0,2,2,1,1,2,2,1,1,2,2,3,3,0,0,2,2,0,0,3,3,1,1,3,3,1,1,1,1,1,1,2,2,1,1,0,0,1,1,0,0,1,1,1,1,3,3,0,0,3,3,0,0,1,1,3,3,2,2,3,3,0,0,0,0,0,0,1,1,0,0,3,3,1,1,0,0,2,2,3,3,2,2,2,2,2,2,1,1,1,1,1,1,0,0,3,3,3,3,0,0,1,1,1,1,2,2,1,1,0,0,2,2,2,2,1,1,0,0,2,2,2,2,0,0,1,1,1,1,2,2,2,2,2,2,2,2,3,3,1,1,3,3,1,1,0,0,0,0,2,2,0,0,2,2,1,1,1,1,0,0,2,2,2,2,2,2,1,1,3,3,2,2,3,3,3,3,3,3,3,3,1,1,1,1,2,2,0,0,3,3,2,2,3,3,1,1,3,3,3,3,3,3,1,1,3,3,0,0,0,0,1,1,0,0,0,0,3,3,0,0,2,2,1,1,1,1,0,0,0,0,3,3,2,2,2,2,1,1,2,2,0,0,2,2,0,0,2,2,3,3,1,1,1,1,1,1,3,3,0,0,0,0,3,3,2,2,0,0,3,3,1,1,1,1,2,2,0,0,1,1,1,1,1,1,1,1,2,2,2,2,0,0,3,3,0,0,2,2,1,1,2,2,1,1,0,0,3,3,3,3,2,2,1,1,1,1,3,3,2,2,3,3,1,1,0,0,2,2,2,2,3,3,0,0,2,2,2,2,0,0,2,2,0,0,3,3,0,0,2,2,1,1,1,1,2,2,1,1,0,0,0,0,3,3,2,2,1,1,2,2,2,2,0,0,1,1,1,1,3,3,3,3,3,3,0,0,0,0,1,1,1,1,1,1,2,2,2,2,0,0,1,1,1,1,3,3,0,0,1,1,1,1,3,3,2,2,1,1,3,3,1,1,3,3,3,3,2,2,0,0,0,0,2,2,1,1,0,0,3,3,3,3,3,3,0,0,0,0,0,0,2,2,3,3,2,2,2,2,1,1,3,3,0,0,0,0,2,2,1,1,2,2,1,1,0,0,1,1,0,0,3,3,2,2,2,2,0,0,2,2,0,0,3,3,2,2,3,3,1,1,1,1,3,3,1,1,0,0,0,0,2,2,2,2,0,0,3,3,3,3,2,2,2,2,3,3,1,1,0,0,3,3,0,0,3,3,2,2,3,3,0,0,1,1,3,3,2,2,3,3,2,2,3,3,2,2,3,3,0,0,0,0,2,2,2,2,3,3,0,0,3,3,1,1,3,3,1,1,0,0,1,1,1,1,2,2,3,3,2,2,1,1,0,0,3,3,0,0,3,3,0,0,0,0,3,3,2,2,2,2,1,1,3,3,3,3,2,2,3,3,1,1,0,0,1,1,1,1,3,3,3,3,0,0,0,0,3,3,3,3,0,0,1,1,0,0,0,0,0,0,0,0,3,3,1,1,3,3,0,0,0,0,1,1,0,0,1,1,0,0,3,3,2,2,1,1,0,0,0,0,0,0,0,0,1,1,0,0,2,2,2,2,3,3,1,1,0,0,1,1,1,1,3,3,0,0,2,2,3,3,1,1,1,1,3,3,1,1,1,1,0,0,2,2,1,1,2,2,2,2,0,0,2,2,3,3,1,1,0,0,2,2,0,0,2,2,2,2,0,0,1,1,1,1,0,0,0,0,3,3,2,2,1,1,2,2,0,0,3,3,2,2,1,1,3,3,0,0,3,3,1,1,1,1,2,2,1,1,3,3,0,0,3,3,1,1,1,1,0,0,1,1,2,2,3,3,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,2,2,0,0,1,1,1,1,3,3,1,1,3,3,0,0,2,2,0,0,3,3,2,2,2,2,2,2,2,2,3,3,3,3,1,1,0,0,3,3,2,2,2,2,0,0,3,3,3,3,0,0,2,2,0,0,3,3,2,2,2,2,2,2,0,0,2,2,0,0,1,1,2,2,3,3,3,3,1,1,0,0,1,1,1,1,1,1,3,3,0,0,1,1,1,1,3,3,0,0,1,1,3,3,3,3,0,0,3,3,2,2,2,2,1,1,0,0,1,1,0,0,2,2,2,2,3,3,2,2,1,1,1,1,3,3,1,1,1,1,1,1,3,3,1,1,2,2,1,1,2,2,1,1,2,2,1,1,3,3,1,1,1,1,3,3,0,0,0,0,2,2,2,2,0,0,2,2,2,2,0,0,0,0,3,3,0,0,2,2,2,2,3,3,2,2,3,3,3,3,0,0,3,3,2,2,3,3,1,1,2,2,3,3,3,3,1,1,2,2,2,2,2,2,2,2,3,3,0,0,0,0,3,3,3,3,0,0,1,1,3,3,2,2,1,1,0,0,0,0,1,1,2,2,2,2,1,1,2,2,1,1,2,2,2,2,0,0,0,0,3,3,2,2,1,1,3,3,2,2,0,0,2,2,2,2,1,1,2,2,2,2,2,2,1,1,2,2,0,0,3,3,1,1,1,1,0,0,1,1,3,3,3,3,3,3,0,0,0,0,2,2,1,1,2,2,3,3,1,1,2,2,1,1,2,2,1,1,0,0,0,0,0,0,3,3,2,2,0,0,2,2,3,3,2,2,1,1,2,2,0,0,0,0,2,2,2,2,3,3,0,0,1,1,0,0,0,0,0,0,1,1,2,2,1,1,1,1,1,1,0,0,2,2,1,1,1,1,3,3,0,0,0,0,2,2,2,2,0,0,1,1,3,3,3,3,3,3,2,2,2,2,3,3,0,0,2,2,1,1,1,1,2,2,0,0,1,1,2,2,2,2,1,1,3,3,0,0,0,0,0,0,3,3,2,2,3,3,2,2,2,2,1,1,3,3,0,0,0,0,0,0,2,2,0,0,0,0,2,2,3,3,1,1,1,1,2,2,0,0,0,0,0,0,0,0,3,3,0,0,1,1,3,3,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,3,3,2,2,2,2,2,2,1,1,2,2,0,0,3,3,1,1,1,1,1,1,2,2,1,1,0,0,2,2,1,1,0,0,3,3,1,1,3,3,3,3,3,3,0,0,3,3,2,2,0,0,0,0,2,2,0,0,2,2,2,2,1,1,3,3,2,2,0,0,0,0,0,0,3,3,1,1,1,1,0,0,0,0,1,1,1,1,2,2,1,1,0,0,2,2,1,1,3,3,2,2,3,3,2,2,2,2,2,2,1,1,0,0,3,3,0,0,3,3,0,0,3,3,2,2,2,2,2,2,0,0,0,0,1,1,3,3,2,2,3,3,0,0,2,2,2,2,0,0,0,0,1,1,2,2,2,2,1,1,2,2,0,0,2,2,3,3,1,1,2,2,0,0,2,2,3,3,1,1,0,0,0,0,2,2,3,3,1,1,2,2,0,0,2,2,2,2,2,2,3,3,2,2,3,3,0,0,3,3,0,0,0,0,3,3,3,3,2,2,2,2,2,2,2,2,1,1,2,2,1,1,1,1,3,3,2,2,1,1,2,2,3,3,1,1,2,2,0,0,0,0,1,1,0,0,3,3,2,2,0,0,3,3,2,2,3,3,2,2,1,1,2,2,0,0,2,2,3,3,1,1,0,0,0,0,1,1,3,3,2,2,2,2,1,1,0,0,2,2,0,0,1,1,2,2,2,2,3,3,0,0,2,2,3,3,3,3,3,3,1,1,3,3,0,0,3,3,3,3,2,2,1,1,0,0,3,3,2,2,3,3,1,1,1,1,3,3,1,1,1,1,2,2,1,1,1,1,2,2,0,0,0,0,2,2,3,3,0,0,2,2,0,0,0,0,1,1,0,0,0,0,2,2,1,1,3,3,2,2,0,0,1,1,3,3,0,0,3,3,1,1,0,0,3,3,2,2,3,3,0,0,2,2,2,2,2,2,0,0,3,3,3,3,3,3,2,2,3,3,2,2,3,3,0,0,1,1,0,0,2,2,2,2,0,0,2,2,3,3,2,2,2,2,3,3,3,3,1,1,3,3,1,1,2,2,0,0,1,1,3,3,1,1,0,0,2,2,3,3,2,2,1,1,1,1,1,1,2,2,3,3,1,1,1,1,0,0,1,1,1,1,3,3,0,0,0,0,3,3,0,0,0,0,1,1,1,1,1,1,3,3,2,2,1,1,1,1,3,3,0,0,3,3,0,0,0,0,1,1,2,2,0,0,2,2,0,0,0,0,0,0,2,2,3,3,3,3,1,1,3,3,3,3,2,2,1,1,2,2,0,0,0,0,0,0,2,2,2,2,0,0,1,1,1,1,2,2,1,1,3,3,2,2,3,3,1,1,0,0,0,0,2,2,3,3,0,0,1,1,1,1,2,2,3,3,3,3,3,3,3,3,3,3,1,1,0,0,0,0,0,0,0,0,1,1,1,1,3,3,1,1,3,3,2,2,3,3,1,1,0,0,0,0,2,2,2,2,1,1,2,2,0,0,0,0,0,0,2,2,0,0,1,1,0,0,2,2,3,3,1,1,0,0,2,2,1,1,3,3,2,2,0,0,3,3,0,0,2,2,2,2,2,2,3,3,0,0,1,1,2,2,3,3,1,1,0,0,2,2,0,0,3,3,1,1,0,0,3,3,2,2,1,1,2,2,0,0,3,3,3,3,1,1,2,2,0,0,0,0,0,0,1,1,1,1,3,3,2,2,1,1,2,2,2,2,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,3,3,0,0,0,0,3,3,0,0,1,1,0,0,0,0,0,0,0,0,3,3,0,0,0,0,2,2,1,1,3,3,1,1,1,1,2,2,2,2,0,0,2,2,2,2,1,1,0,0,0,0,1,1,2,2,0,0,2,2,3,3,2,2,2,2,0,0,0,0,2,2,1,1,3,3,3,3,0,0,2,2,1,1,0,0,0,0,0,0,3,3,2,2,0,0,3,3,0,0,3,3,3,3,0,0,0,0,3,3,3,3,2,2,2,2,1,1,0,0,3,3,0,0,0,0,0,0,3,3,1,1,2,2,1,1,2,2,1,1,2,2,3,3,0,0,0,0,2,2,3,3,3,3,1,1,1,1,0,0,3,3,2,2,0,0,2,2,0,0,2,2,0,0,2,2,2,2,3,3,3,3,3,3,2,2,1,1,2,2,3,3,1,1,3,3,1,1,3,3,0,0,1,1,0,0,2,2,3,3,0,0,2,2,1,1,0,0,1,1,0,0,3,3,3,3,2,2,0,0,0,0,2,2,3,3,3,3,0,0,3,3,1,1,0,0,2,2,3,3,2,2,1,1,1,1,3,3,0,0,1,1,1,1,1,1,2,2,0,0,1,1,1,1,3,3,1,1,0,0,0,0,0,0,0,0,3,3,0,0,2,2,3,3,0,0,3,3,2,2,0,0,2,2,0,0,2,2,3,3,2,2,1,1,1,1,1,1,3,3,2,2,0,0,2,2,2,2,1,1,2,2,3,3,3,3,0,0,0,0,2,2,1,1,1,1,2,2,1,1,2,2,1,1,1,1,1,1,3,3,0,0,3,3,3,3,1,1,0,0,2,2,0,0,3,3,1,1,0,0,0,0,1,1,3,3,1,1,2,2,1,1,1,1,3,3,3,3,3,3,2,2,0,0,2,2,3,3,0,0,3,3,3,3,0,0,2,2,3,3,3,3,3,3,1,1,1,1,1,1,2,2,0,0,1,1,0,0,3,3,0,0,0,0,2,2,0,0,2,2,2,2,3,3,3,3,3,3,0,0,0,0,3,3,1,1,1,1,0,0,0,0,1,1,0,0,3,3,0,0,3,3,1,1,2,2,3,3,2,2,3,3,1,1,3,3,2,2,3,3,0,0,3,3,3,3,3,3,0,0,0,0,2,2,3,3,1,1,0,0,1,1,1,1,1,1,0,0,3,3,3,3,2,2,0,0,3,3,1,1,2,2,0,0,1,1,0,0,1,1,1,1,2,2,0,0,2,2,2,2,1,1,2,2,1,1,1,1,2,2,0,0,0,0,3,3,2,2,3,3,1,1,2,2,0,0,1,1,1,1,1,1,2,2,0,0,1,1,2,2,2,2,0,0,3,3,2,2,1,1,1,1,3,3,3,3,3,3,2,2,0,0,1,1,3,3,0,0,1,1,1,1,2,2,2,2,2,2,1,1,3,3,3,3,2,2,3,3,2,2,2,2,3,3,3,3,3,3,1,1,1,1,0,0,1,1,3,3,3,3,3,3,1,1,3,3,1,1,2,2,3,3,0,0,1,1,2,2,0,0,2,2,2,2,0,0,3,3,2,2,1,1,3,3,2,2,2,2,0,0,1,1,1,1,2,2,2,2,1,1,2,2,0,0,0,0,0,0,2,2,2,2,0,0,2,2,0,0,2,2,3,3,1,1,3,3,0,0,2,2,0,0,2,2,0,0,1,1,2,2,1,1,2,2,0,0,0,0,1,1,2,2,0,0,3,3,1,1,0,0,3,3,3,3,1,1,0,0,2,2,2,2,0,0,0,0,3,3,1,1,2,2,3,3,3,3,3,3,0,0,0,0,1,1,0,0,1,1,0,0,2,2,2,2,3,3,0,0,2,2,3,3,1,1,0,0,0,0,3,3,0,0,2,2,2,2,1,1,0,0,3,3,2,2,3,3,2,2,2,2,0,0,3,3,1,1,3,3,1,1,2,2,3,3,0,0,2,2,2,2,1,1,2,2,1,1,2,2,3,3,0,0,0,0,0,0,3,3,2,2,0,0,0,0,1,1,0,0,0,0,3,3,3,3,2,2,2,2,2,2,3,3,2,2,2,2,1,1,2,2,3,3,2,2,0,0,1,1,3,3,2,2,2,2,1,1,2,2,0,0,2,2,1,1,1,1,3,3,1,1,0,0,2,2,3,3,2,2,1,1,2,2,1,1,1,1,3,3,0,0,0,0,0,0,0,0,1,1,2,2,3,3,3,3,3,3,0,0,1,1,0,0,2,2,1,1,3,3,0,0,3,3,0,0,1,1,1,1,0,0,1,1,2,2,3,3,3,3,1,1,2,2,3,3,0,0,1,1,1,1,1,1,0,0,3,3,1,1,3,3,1,1,3,3,0,0,1,1,2,2,3,3,2,2,3,3,1,1,0,0,2,2,2,2,3,3,2,2,2,2,2,2,3,3,1,1,2,2,0,0,3,3,2,2,0,0,2,2,2,2,2,2,0,0,2,2,2,2,1,1,3,3,2,2,1,1,1,1,2,2,0,0,1,1,1,1,2,2,0,0,3,3,3,3,1,1,0,0,2,2,2,2,0,0,1,1,1,1,2,2,2,2,0,0,0,0,0,0,2,2,0,0,0,0,3,3,1,1,2,2,2,2,0,0,0,0,0,0,3,3,1,1,2,2,0,0,0,0,2,2,1,1,0,0,2,2,2,2,2,2,1,1,0,0,3,3,2,2,1,1,1,1,1,1,2,2,0,0,3,3,3,3,0,0,1,1,2,2,1,1,3,3,3,3,1,1,1,1,1,1,2,2,3,3,2,2,3,3,2,2,2,2,3,3,2,2,0,0,2,2,3,3,0,0,1,1,0,0,2,2,1,1,1,1,3,3,3,3,1,1,2,2,2,2,1,1,2,2,3,3,1,1,1,1,1,1,1,1,1,1,1,1,0,0,3,3,2,2,2,2,1,1,2,2,0,0,3,3,1,1,0,0,2,2,2,2,2,2,2,2,2,2,0,0,2,2,1,1,3,3,0,0,1,1,1,1,1,1,0,0,1,1,0,0,2,2,1,1,2,2,1,1,2,2,0,0,1,1,1,1,0,0,3,3,1,1,3,3,0,0,0,0,0,0,1,1,1,1,3,3,1,1,0,0,2,2,3,3,2,2,2,2,1,1,3,3,0,0,1,1,3,3,1,1,1,1,0,0,1,1,3,3,1,1,2,2,0,0,2,2,3,3,2,2,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,2,2,3,3,0,0,0,0,0,0,1,1,1,1,2,2,2,2,0,0,2,2,3,3,0,0,1,1,0,0,3,3,3,3,3,3,1,1,0,0,2,2,3,3,3,3,0,0,3,3,1,1,3,3,2,2,3,3,3,3,1,1,3,3,1,1,1,1,2,2,2,2,1,1,2,2,2,2,1,1,1,1,2,2,1,1,1,1,0,0,2,2,2,2,2,2,0,0,3,3,3,3,1,1,3,3,3,3,2,2,1,1,0,0,2,2,0,0,3,3,1,1,1,1,1,1,2,2,2,2,3,3,3,3,0,0,0,0,0,0,3,3,0,0,3,3,1,1,1,1,2,2,0,0,1,1,2,2,1,1,1,1,3,3,2,2,0,0,2,2,0,0,2,2,1,1,2,2,2,2,2,2,2,2,2,2,1,1,2,2,3,3,2,2,0,0,0,0,3,3,2,2,2,2,3,3,0,0,2,2,3,3,2,2,1,1,0,0,2,2,0,0,1,1,3,3,3,3,1,1,2,2,0,0,0,0,0,0,2,2,2,2,3,3,3,3,3,3,2,2,0,0,2,2,2,2,2,2,1,1,3,3,2,2,0,0,1,1,3,3,3,3,3,3,0,0,0,0,1,1,3,3,3,3,0,0,2,2,0,0,1,1,0,0,1,1,1,1,3,3,3,3,0,0,1,1,3,3,0,0,1,1,1,1,2,2,3,3,0,0,3,3,0,0,1,1,0,0,2,2,2,2,0,0,3,3,1,1,3,3,2,2,2,2,3,3,0,0,1,1,3,3,2,2,2,2,0,0,0,0,2,2,0,0,1,1,0,0,2,2,1,1,3,3,0,0,2,2,1,1,0,0,1,1,0,0,1,1,0,0,1,1,2,2,1,1,1,1,3,3,0,0,2,2,3,3,2,2,3,3,2,2,2,2,3,3,1,1,2,2,2,2,2,2,0,0,1,1,1,1,1,1,1,1,2,2,0,0,3,3,2,2,3,3,3,3,1,1,2,2,3,3,1,1,1,1,3,3,0,0,3,3,2,2,1,1,2,2,2,2,3,3,2,2,1,1,1,1,1,1,0,0,0,0,0,0,3,3,3,3,3,3,1,1,1,1,2,2,1,1,3,3,3,3,2,2,1,1,0,0,3,3,0,0,1,1,2,2,3,3,0,0,0,0,3,3,1,1,3,3,1,1,2,2,0,0,2,2,3,3,1,1,3,3,1,1,0,0,3,3,3,3,1,1,1,1,0,0,2,2,1,1,0,0,1,1,3,3,2,2,1,1,3,3,0,0,3,3,0,0,1,1,0,0,2,2,1,1,3,3,3,3,2,2,1,1,3,3,0,0,0,0,3,3,1,1,1,1,2,2,0,0,0,0,3,3,1,1,2,2,2,2,1,1,1,1,0,0,2,2,0,0,0,0,0,0,1,1,1,1,0,0,1,1,3,3,1,1,1,1,2,2,0,0,3,3,2,2,1,1,3,3,3,3,1,1,1,1,3,3,2,2,0,0,0,0,2,2,1,1,2,2,0,0,3,3,1,1,2,2,1,1,3,3,3,3,1,1,2,2,0,0,1,1,1,1,2,2,0,0,3,3,3,3,0,0,1,1,0,0,3,3,2,2,2,2,3,3,0,0,2,2,1,1,3,3,0,0,1,1,2,2,0,0,1,1,3,3,1,1,3,3,0,0,0,0,3,3,1,1,2,2,1,1,3,3,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,1,1,1,1,0,0,2,2,0,0,0,0,2,2,1,1,1,1,0,0,3,3,2,2,0,0,2,2,1,1,3,3,0,0,1,1,3,3,1,1,0,0,3,3,2,2,3,3,2,2,2,2,2,2,2,2,1,1,3,3,3,3,3,3,0,0,1,1,1,1,1,1,1,1,2,2,0,0,1,1,3,3,1,1,1,1,0,0,1,1,0,0,1,1,3,3,2,2,2,2,3,3,0,0,2,2,0,0,0,0,1,1,1,1,0,0,0,0,0,0,3,3,2,2,3,3,0,0,0,0,1,1,3,3,2,2,1,1,0,0,0,0,3,3,2,2,3,3,0,0,1,1,2,2,1,1,2,2,3,3,1,1,0,0,2,2,1,1,0,0,0,0,3,3,0,0,3,3,0,0,0,0,0,0,3,3,3,3,1,1,0,0,1,1,2,2,0,0,1,1,1,1,1,1,0,0,0,0,2,2,1,1,0,0,3,3,0,0,2,2,2,2,3,3,1,1,1,1,0,0,0,0,3,3,3,3,2,2,1,1,1,1,2,2,0,0,0,0,3,3,1,1,3,3,1,1,3,3,0,0,1,1,1,1,0,0,1,1,2,2,1,1,2,2,1,1,2,2,0,0,1,1,1,1,2,2,2,2,1,1,3,3,2,2,3,3,0,0,1,1,0,0,1,1,0,0,1,1,0,0,2,2,1,1,0,0,3,3,1,1,2,2,1,1,2,2,0,0,2,2,2,2,3,3,2,2,3,3,0,0,2,2,3,3,1,1,0,0,1,1,3,3,1,1,2,2,3,3,2,2,0,0,0,0,1,1,3,3,2,2,3,3,0,0,1,1,3,3,0,0,3,3,0,0,0,0,1,1,2,2,3,3,0,0,2,2,1,1,3,3,1,1,3,3,3,3,0,0,3,3,1,1,0,0,1,1,0,0,0,0,1,1,1,1,2,2,3,3,3,3,1,1,2,2,0,0,0,0,2,2,3,3,3,3,1,1,0,0,3,3,1,1,0,0,3,3,2,2,2,2,1,1,2,2,0,0,1,1,0,0,0,0,0,0,2,2,2,2,1,1,3,3,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,0,0,0,0,3,3,3,3,1,1,3,3,1,1,2,2,3,3,3,3,1,1,1,1,2,2,0,0,1,1,0,0,2,2,2,2,2,2,2,2,0,0,2,2,2,2,0,0,2,2,3,3,2,2,2,2,2,2,3,3,2,2,0,0,0,0,1,1,3,3,1,1,3,3,0,0,2,2,1,1,1,1,3,3,2,2,1,1,2,2,2,2,0,0,0,0,2,2,2,2,0,0,0,0,0,0,3,3,2,2,2,2,1,1,3,3,1,1,0,0,0,0,2,2,1,1,3,3,3,3,2,2,2,2,0,0,0,0,3,3,2,2,2,2,2,2,0,0,3,3,1,1,0,0,2,2,1,1,2,2,2,2,1,1,0,0,0,0,0,0,2,2,3,3,2,2,2,2,0,0,3,3,3,3,0,0,1,1,2,2,0,0,3,3,0,0,1,1,1,1,3,3,1,1,1,1,1,1,3,3,1,1,0,0,3,3,2,2,2,2,3,3,0,0,2,2,2,2,2,2,2,2,1,1,0,0,0,0,2,2,0,0,0,0,0,0,2,2,1,1,3,3,2,2,0,0,2,2,0,0,1,1,1,1,1,1,3,3,0,0,2,2,2,2,1,1,2,2,1,1,1,1,3,3,3,3,1,1,0,0,3,3,3,3,0,0,3,3,2,2,3,3,2,2,1,1,1,1,2,2,0,0,3,3,0,0,0,0,0,0,1,1,2,2,1,1,3,3,3,3,2,2,3,3,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,2,2,0,0,3,3,2,2,1,1,0,0,1,1,2,2,0,0,0,0,1,1,3,3,3,3,3,3,1,1,2,2,0,0,0,0,2,2,0,0,1,1,1,1,2,2,1,1,3,3,1,1,0,0,3,3,0,0,0,0,3,3,3,3,2,2,0,0,2,2,0,0,3,3,1,1,0,0,1,1,2,2,3,3,1,1,0,0,0,0,0,0,3,3,0,0,2,2,1,1,0,0,2,2,2,2,3,3,3,3,0,0,1,1,1,1,0,0,0,0,3,3,3,3,1,1,2,2,2,2,2,2,1,1,1,1,2,2,1,1,2,2,1,1,1,1,1,1,1,1,3,3,3,3,2,2,0,0,0,0,1,1,1,1,3,3,3,3,0,0,3,3,1,1,2,2,2,2,0,0,1,1,3,3,2,2,1,1,2,2,0,0,1,1,0,0,3,3,3,3,3,3,1,1,0,0,2,2,3,3,0,0,3,3,1,1,0,0,0,0,0,0,0,0,3,3,1,1,3,3,0,0,1,1,2,2,0,0,0,0,3,3,3,3,2,2,2,2,0,0,1,1,2,2,2,2,2,2,3,3,2,2,1,1,2,2,2,2,3,3,0,0,1,1,2,2,3,3,1,1,2,2,1,1,0,0,0,0,0,0,1,1,0,0,3,3,2,2,1,1,3,3,0,0,0,0,1,1,3,3,1,1,1,1,3,3,0,0,2,2,3,3,3,3,2,2,1,1,3,3,0,0,1,1,1,1,2,2,2,2,1,1,2,2,2,2,1,1,0,0,2,2,0,0,0,0,2,2,0,0,2,2,3,3,3,3,0,0,3,3,3,3,2,2,3,3,0,0,3,3,0,0,3,3,2,2,1,1,1,1,1,1,3,3,2,2,3,3,3,3,2,2,0,0,2,2,2,2,0,0,0,0,0,0,2,2,0,0,2,2,0,0,1,1,1,1,1,1,1,1,2,2,2,2,3,3,2,2,2,2,0,0,2,2,3,3,2,2,2,2,0,0,1,1,0,0,3,3,0,0,3,3,2,2,0,0,0,0,3,3,1,1,2,2,2,2,2,2,3,3,2,2,3,3,0,0,0,0,2,2,3,3,2,2,0,0,3,3,1,1,1,1,1,1,2,2,2,2,3,3,0,0,0,0,1,1,2,2,0,0,1,1,3,3,0,0,0,0,3,3,0,0,2,2,1,1,0,0,1,1,2,2,2,2,1,1,0,0,2,2,2,2,3,3,3,3,2,2,3,3,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,3,3,2,2,2,2,1,1,0,0,2,2,0,0,1,1,1,1,1,1,0,0,1,1,1,1,2,2,3,3,2,2,1,1,1,1,2,2,1,1,1,1,0,0,2,2,1,1,3,3,0,0,3,3,3,3,3,3,3,3,2,2,2,2,3,3,2,2,0,0,3,3,2,2,0,0,3,3,3,3,1,1,3,3,1,1,0,0,3,3,1,1,2,2,0,0,1,1,2,2,2,2,3,3,1,1,1,1,1,1,3,3,0,0,2,2,1,1,0,0,1,1,0,0,3,3,2,2,1,1,1,1,0,0,0,0,3,3,0,0,2,2,2,2,2,2,0,0,0,0,0,0,3,3,0,0,3,3,3,3,1,1,0,0,0,0,0,0,1,1,2,2,3,3,1,1,0,0,3,3,2,2,2,2,2,2,0,0,0,0,2,2,3,3,2,2,2,2,2,2,1,1,0,0,3,3,3,3,0,0,1,1,1,1,1,1,1,1,1,1,3,3,1,1,0,0,1,1,2,2,2,2,3,3,0,0,1,1,0,0,2,2,3,3,0,0,3,3,3,3,2,2,2,2,1,1,3,3,2,2,3,3,0,0,3,3,1,1,0,0,1,1,1,1,1,1,1,1,0,0,2,2,0,0,0,0,2,2,0,0,0,0,1,1,2,2,0,0,0,0,2,2,3,3,2,2,0,0,1,1,1,1,1,1,2,2,0,0,0,0,2,2,2,2,3,3,0,0,2,2,1,1,0,0,3,3,1,1,0,0,0,0,0,0,3,3,3,3,0,0,2,2,0,0,0,0,0,0,0,0,1,1,0,0,3,3,0,0,0,0,3,3,3,3,2,2,1,1,3,3,3,3,2,2,2,2,2,2,0,0,2,2,0,0,2,2,0,0,3,3,1,1,3,3,0,0,1,1,1,1,2,2,0,0,0,0,0,0,3,3,1,1,2,2,1,1,1,1,2,2,0,0,0,0,1,1,1,1,0,0,0,0,3,3,1,1,3,3,3,3,2,2,2,2,1,1,2,2,3,3,1,1,1,1,3,3,2,2,3,3,2,2,1,1,1,1,0,0,2,2,0,0,0,0,2,2,2,2,0,0,1,1,0,0,2,2,2,2,0,0,0,0,3,3,2,2,3,3,2,2,0,0,0,0,1,1,2,2,3,3,2,2,0,0,2,2,0,0,1,1,0,0,2,2,2,2,1,1,0,0,1,1,2,2,1,1,0,0,0,0,1,1,3,3,0,0,0,0,1,1,2,2,0,0,2,2,3,3,2,2,1,1,2,2,3,3,0,0,3,3,0,0,0,0,2,2,1,1,3,3,1,1,0,0,1,1,0,0,0,0,0,0,3,3,1,1,1,1,1,1,1,1,3,3,1,1,2,2,1,1,1,1,0,0,3,3,1,1,2,2,3,3,1,1,1,1,0,0,3,3,3,3,3,3,3,3,0,0,1,1,1,1,0,0,3,3,3,3,0,0,2,2,2,2,1,1,1,1,2,2,1,1,2,2,3,3,3,3,1,1,2,2,2,2,3,3,1,1,0,0,3,3,0,0,1,1,0,0,3,3,1,1,3,3,2,2,3,3,3,3,2,2,3,3,2,2,3,3,3,3,3,3,3,3,0,0,3,3,0,0,2,2,1,1,3,3,3,3,1,1,1,1,3,3,0,0,0,0,2,2,0,0,1,1,2,2,0,0,0,0,2,2,3,3,2,2,3,3,2,2,0,0,3,3,2,2,3,3,3,3,2,2,2,2,3,3,0,0,1,1,0,0,2,2,3,3,1,1,1,1,1,1,1,1,2,2,1,1,0,0,2,2,0,0,1,1,0,0,3,3,3,3,1,1,2,2,3,3,2,2,1,1,2,2,3,3,3,3,1,1,0,0,0,0,3,3,0,0,2,2,2,2,0,0,0,0,0,0,3,3,0,0,3,3,0,0,0,0,3,3,1,1,2,2,1,1,2,2,3,3,2,2,2,2,2,2,3,3,1,1,3,3,3,3,3,3,3,3,2,2,1,1,3,3,2,2,2,2,0,0,0,0,2,2,2,2,0,0,2,2,0,0,1,1,1,1,1,1,0,0,2,2,3,3,1,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,0,0,0,0,0,0,3,3,1,1,2,2,0,0,3,3,1,1,0,0,1,1,0,0,3,3,3,3,0,0,2,2,2,2,0,0,1,1,2,2,2,2,0,0,0,0,0,0,3,3,0,0,3,3,3,3,0,0,1,1,1,1,2,2,3,3,0,0,2,2,1,1,1,1,0,0,3,3,0,0,0,0,2,2,2,2,0,0,3,3,3,3,0,0,3,3,1,1,0,0,2,2,3,3,1,1,0,0,0,0,2,2,2,2,3,3,0,0,3,3,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,3,3,1,1,3,3,0,0,0,0,3,3,0,0,2,2,3,3,2,2,1,1,1,1,2,2,2,2,0,0,1,1,2,2,3,3,3,3,3,3,1,1,1,1,3,3,1,1,2,2,1,1,1,1,0,0,3,3,2,2,0,0,3,3,3,3,0,0,3,3,1,1,0,0,1,1,1,1,1,1,2,2,2,2,1,1,2,2,3,3,3,3,1,1,1,1,2,2,0,0,3,3,3,3,0,0,3,3,3,3,2,2,3,3,0,0,3,3,2,2,1,1,0,0,3,3,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,3,3,1,1,0,0,1,1,2,2,1,1,1,1,0,0,2,2,0,0,2,2,3,3,0,0,2,2,0,0,2,2,0,0,1,1,1,1,2,2,2,2,1,1,3,3,3,3,0,0,0,0,2,2,0,0,3,3,1,1,0,0,0,0,2,2,0,0,1,1,1,1,1,1,3,3,0,0,1,1,3,3,3,3,0,0,2,2,2,2,0,0,1,1,2,2,1,1,3,3,1,1,0,0,0,0,3,3,3,3,1,1,2,2,0,0,1,1,1,1,0,0,2,2,3,3,1,1,1,1,2,2,0,0,2,2,2,2,1,1,1,1,0,0,0,0,1,1,0,0,3,3,2,2,1,1,1,1,0,0,2,2,2,2,1,1,0,0,2,2,1,1,0,0,1,1,1,1,2,2,0,0,1,1,2,2,0,0,1,1,0,0,1,1,1,1,0,0,3,3,0,0,3,3,2,2,2,2,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,2,2,0,0,0,0,2,2,0,0,0,0,2,2,2,2,1,1,1,1,2,2,0,0,1,1,3,3,3,3,0,0,2,2,2,2,2,2,1,1,2,2,2,2,2,2,2,2,3,3,1,1,2,2,2,2,3,3,1,1,1,1,3,3,1,1,0,0,3,3,1,1,0,0,3,3,0,0,1,1,3,3,0,0,1,1,2,2,0,0,0,0,1,1,0,0,3,3,1,1,0,0,0,0,3,3,2,2,2,2,2,2,2,2,1,1,2,2,2,2,0,0,2,2,2,2,3,3,0,0,1,1,3,3,3,3,3,3,3,3,2,2,1,1,0,0,2,2,0,0,0,0,3,3,2,2,0,0,2,2,0,0,0,0,3,3,3,3,2,2,2,2,0,0,0,0,0,0,1,1,3,3,1,1,0,0,3,3,0,0,0,0,1,1,0,0,1,1,1,1,3,3,2,2,2,2,1,1,1,1,3,3,3,3,1,1,3,3,1,1,2,2,2,2,3,3,0,0,1,1,2,2,1,1,1,1,1,1,2,2,0,0,1,1,1,1,1,1,3,3,2,2,2,2,0,0,1,1,0,0,2,2,0,0,3,3,2,2,1,1,3,3,1,1,0,0,2,2,1,1,3,3,3,3,1,1,2,2,3,3,2,2,0,0,1,1,2,2,1,1,3,3,1,1,3,3,2,2,0,0,0,0,2,2,3,3,3,3,0,0,2,2,0,0,1,1,3,3,2,2,3,3,2,2,3,3,1,1,2,2,1,1,2,2,2,2,1,1,1,1,1,1,2,2,1,1,3,3,2,2,1,1,0,0,2,2,1,1,0,0,2,2,0,0,3,3,0,0,3,3,2,2,1,1,3,3,0,0,2,2,0,0,0,0,1,1,0,0,3,3,0,0,3,3,0,0,1,1,0,0,2,2,0,0,2,2,0,0,1,1,3,3,0,0,2,2,2,2,2,2,0,0,2,2,1,1,2,2,3,3,0,0,1,1,2,2,2,2,2,2,0,0,0,0,3,3,3,3,3,3,3,3,1,1,2,2,3,3,0,0,2,2,0,0,0,0,0,0,1,1,2,2,2,2,3,3,3,3,1,1,3,3,0,0,0,0,3,3,0,0,2,2,1,1,0,0,1,1,0,0,0,0,0,0,1,1,2,2,0,0,2,2,0,0,3,3,1,1,0,0,1,1,3,3,2,2,3,3,3,3,2,2,2,2,1,1,3,3,1,1,0,0,3,3,0,0,3,3,2,2,0,0,1,1,0,0,0,0,1,1,1,1,2,2,3,3,0,0,3,3,3,3,0,0,3,3,0,0,2,2,3,3,3,3,2,2,3,3,2,2,0,0,1,1,3,3,0,0,2,2,3,3,3,3,2,2,2,2,2,2,0,0,3,3,1,1,2,2,2,2,1,1,0,0,2,2,0,0,3,3,2,2,0,0,1,1,3,3,0,0,0,0,0,0,0,0,3,3,1,1,2,2,2,2,1,1,2,2,2,2,1,1,3,3,2,2,1,1,2,2,3,3,0,0,1,1,3,3,1,1,0,0,0,0,2,2,3,3,0,0,2,2,3,3,1,1,1,1,2,2,0,0,0,0,0,0,0,0,1,1,2,2,2,2,1,1,3,3,0,0,1,1,1,1,2,2,3,3,1,1,0,0,1,1,2,2,1,1,0,0,2,2,2,2,2,2,0,0,1,1,1,1,0,0,2,2,0,0,1,1,3,3,0,0,0,0,0,0,1,1,1,1,1,1,3,3,1,1,0,0,0,0,3,3,2,2,1,1,2,2,3,3,2,2,0,0,3,3,0,0,1,1,2,2,1,1,1,1,2,2,1,1,1,1,2,2,3,3,1,1,1,1,2,2,0,0,3,3,3,3,2,2,2,2,2,2,0,0,0,0,1,1,3,3,2,2,3,3,2,2,1,1,1,1,2,2,1,1,2,2,1,1,0,0,3,3,1,1,2,2,1,1,2,2,3,3,2,2,0,0,0,0,3,3,2,2,0,0,0,0,1,1,3,3,1,1,3,3,0,0,3,3,0,0,2,2,2,2,2,2,3,3,0,0,1,1,0,0,3,3,2,2,1,1,3,3,3,3,1,1,1,1,0,0,2,2,0,0,3,3,3,3,3,3,1,1,2,2,0,0,2,2,1,1,3,3,0,0,0,0,1,1,1,1,0,0,2,2,1,1,0,0,1,1,2,2,2,2,1,1,2,2,1,1,3,3,0,0,1,1,2,2,1,1,2,2,0,0,3,3,2,2,0,0,1,1,1,1,3,3,2,2,1,1,2,2,0,0,1,1,2,2,3,3,1,1,3,3,0,0,3,3,1,1,0,0,0,0,0,0,1,1,3,3,2,2,3,3,1,1,2,2,2,2,2,2,0,0,2,2,3,3,1,1,3,3,1,1,3,3,3,3,2,2,3,3,0,0,2,2,3,3,0,0,3,3,0,0,3,3,3,3,2,2,3,3,2,2,2,2,2,2,2,2,3,3,1,1,2,2,0,0,0,0,2,2,3,3,2,2,1,1,1,1,3,3,3,3,1,1,2,2,1,1,0,0,2,2,0,0,1,1,3,3,0,0,0,0,0,0,2,2,1,1,2,2,1,1,2,2,3,3,0,0,0,0,0,0,0,0,1,1,2,2,3,3,3,3,2,2,3,3,1,1,1,1,0,0,1,1,3,3,2,2,2,2,0,0,1,1,0,0,2,2,1,1,0,0,1,1,2,2,3,3,3,3,3,3,3,3,2,2,2,2,3,3,1,1,1,1,3,3,0,0,2,2,0,0,2,2,0,0,1,1,0,0,1,1,2,2,2,2,1,1,1,1,1,1,2,2,1,1,0,0,2,2,0,0,2,2,2,2,2,2,1,1,2,2,3,3,3,3,3,3,1,1,2,2,2,2,3,3,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,2,2,1,1,2,2,2,2,1,1,0,0,0,0,1,1,2,2,1,1,1,1,1,1,2,2,0,0,0,0,0,0,0,0,3,3,0,0,1,1,2,2,2,2,3,3,3,3,1,1,2,2,0,0,0,0,2,2,3,3,2,2,2,2,1,1,2,2,3,3,1,1,1,1,0,0,3,3,3,3,2,2,3,3,0,0,0,0,2,2,0,0,0,0,3,3,3,3,0,0,3,3,0,0,2,2,2,2,1,1,0,0,3,3,0,0,2,2,0,0,2,2,2,2,1,1,0,0,0,0,2,2,3,3,2,2,0,0,1,1,2,2,2,2,0,0,0,0,0,0,2,2,0,0,3,3,0,0,2,2,1,1,0,0,2,2,2,2,2,2,3,3,3,3,1,1,2,2,2,2,0,0,0,0,2,2,3,3,0,0,1,1,3,3,2,2,1,1,3,3,3,3,0,0,3,3,1,1,0,0,3,3,0,0,2,2,3,3,1,1,0,0,3,3,1,1,0,0,0,0,1,1,1,1,2,2,3,3,2,2,0,0,3,3,2,2,2,2,1,1,1,1,0,0,0,0,1,1,1,1,3,3,1,1,2,2,0,0,0,0,0,0,3,3,3,3,1,1,3,3,3,3,0,0,2,2,1,1,0,0,1,1,2,2,3,3,1,1,3,3,0,0,0,0,2,2,3,3,0,0,1,1,1,1,3,3,0,0,2,2,2,2,0,0,1,1,2,2,2,2,2,2,2,2,2,2,3,3,0,0,2,2,2,2,2,2,0,0,1,1,3,3,1,1,1,1,1,1,0,0,3,3,0,0,3,3,1,1,3,3,3,3,0,0,1,1,0,0,1,1,1,1,0,0,0,0,2,2,2,2,0,0,2,2,1,1,2,2,1,1,3,3,1,1,1,1,1,1,1,1,2,2,2,2,0,0,0,0,2,2,0,0,1,1,1,1,0,0,2,2,0,0,2,2,3,3,0,0,1,1,2,2,2,2,1,1,2,2,0,0,2,2,3,3,3,3,1,1,1,1,1,1,2,2,2,2,1,1,3,3,1,1,2,2,2,2,0,0,1,1,1,1,0,0,3,3,2,2,2,2,0,0,2,2,1,1,3,3,2,2,2,2,2,2,1,1,0,0,0,0,0,0,2,2,1,1,0,0,3,3,3,3,0,0,1,1,1,1,0,0,3,3,0,0,2,2,2,2,2,2,2,2,1,1,1,1,3,3,2,2,2,2,3,3,2,2,2,2,3,3,2,2,0,0,1,1,1,1,0,0,0,0,0,0,1,1,3,3,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,1,1,0,0,1,1,0,0,2,2,3,3,0,0,0,0,1,1,0,0,3,3,1,1,1,1,0,0,3,3,0,0,2,2,3,3,2,2,2,2,1,1,0,0,3,3,2,2,2,2,2,2,2,2,3,3,0,0,3,3,1,1,2,2,2,2,2,2,1,1,2,2,3,3,1,1,1,1,3,3,1,1,3,3,1,1,3,3,2,2,0,0,3,3,0,0,3,3,0,0,1,1,1,1,3,3,1,1,0,0,3,3,3,3,3,3,0,0,0,0,0,0,3,3,3,3,0,0,0,0,2,2,0,0,1,1,2,2,0,0,2,2,0,0,3,3,1,1,0,0,2,2,2,2,0,0,2,2,3,3,3,3,0,0,0,0,0,0,2,2,2,2,0,0,3,3,1,1,0,0,3,3,3,3,3,3,0,0,2,2,1,1,3,3,1,1,2,2,0,0,0,0,3,3,0,0,2,2,0,0,1,1,2,2,3,3,0,0,2,2,2,2,3,3,0,0,1,1,2,2,2,2,3,3,3,3,0,0,0,0,3,3,0,0,1,1,0,0,3,3,2,2,2,2,1,1,1,1,1,1,3,3,2,2,3,3,0,0,1,1,2,2,1,1,1,1,0,0,1,1,1,1,0,0,3,3,0,0,2,2,0,0,1,1,0,0,3,3,0,0,0,0,2,2,0,0,0,0,0,0,1,1,3,3,2,2,1,1,1,1,3,3,0,0,1,1,0,0,2,2,0,0,3,3,2,2,2,2,1,1,3,3,3,3,1,1,0,0,1,1,1,1,1,1,0,0,3,3,0,0,2,2,2,2,3,3,3,3,2,2,3,3,1,1,2,2,3,3,1,1,3,3,1,1,3,3,0,0,0,0,3,3,0,0,1,1,0,0,1,1,0,0,3,3,1,1,0,0,0,0,3,3,0,0,2,2,0,0,2,2,1,1,2,2,1,1,0,0,1,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,1,1,1,1,3,3,3,3,1,1,1,1,0,0,1,1,0,0,3,3,0,0,0,0,3,3,3,3,1,1,1,1,3,3,1,1,1,1,2,2,2,2,3,3,2,2,2,2,3,3,2,2,3,3,0,0,2,2,3,3,2,2,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,2,2,2,2,3,3,2,2,0,0,0,0,2,2,3,3,2,2,3,3,0,0,3,3,0,0,3,3,3,3,0,0,1,1,2,2,3,3,1,1,0,0,1,1,3,3,0,0,0,0,2,2,0,0,0,0,1,1,3,3,1,1,3,3,0,0,1,1,0,0,3,3,1,1,3,3,1,1,0,0,3,3,3,3,0,0,2,2,0,0,3,3,2,2,3,3,1,1,2,2,1,1,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,1,1,0,0,2,2,2,2,3,3,0,0,1,1,3,3,1,1,0,0,3,3,0,0,2,2,1,1,3,3,2,2,1,1,2,2,3,3,3,3,2,2,0,0,2,2,1,1,3,3,1,1,3,3,2,2,1,1,2,2,3,3,1,1,1,1,3,3,3,3,3,3,3,3,0,0,2,2,3,3,0,0,2,2,1,1,0,0,1,1,2,2,2,2,0,0,0,0,2,2,1,1,3,3,3,3,1,1,1,1,0,0,0,0,0,0,0,0,1,1,3,3,2,2,3,3,2,2,0,0,2,2,3,3,3,3,2,2,3,3,1,1,0,0,1,1,3,3,1,1,1,1,3,3,0,0,1,1,2,2,2,2,1,1,0,0,2,2,2,2,3,3,1,1,0,0,3,3,2,2,1,1,1,1,3,3,2,2,2,2,0,0,1,1,0,0,2,2,1,1,0,0,1,1,1,1,1,1,0,0,2,2,0,0,0,0,1,1,3,3,3,3,2,2,2,2,1,1,2,2,1,1,1,1,3,3,2,2,0,0,1,1,1,1,3,3,3,3,3,3,0,0,2,2,0,0,3,3,0,0,0,0,0,0,1,1,0,0,2,2,2,2,3,3,1,1,0,0,0,0,2,2,3,3,3,3,2,2,1,1,1,1,1,1,1,1,2,2,0,0,0,0,0,0,3,3,0,0,2,2,1,1,2,2,2,2,2,2,2,2,0,0,1,1,0,0,3,3,3,3,2,2,2,2,1,1,3,3,3,3,3,3,2,2,1,1,3,3,0,0,1,1,1,1,0,0,0,0,1,1,2,2,1,1,3,3,0,0,1,1,0,0,0,0,3,3,2,2,0,0,2,2,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,1,1,2,2,3,3,0,0,1,1,0,0,1,1,3,3,2,2,2,2,3,3,0,0,0,0,0,0,0,0,2,2,3,3,0,0,2,2,1,1,3,3,3,3,2,2,3,3,3,3,3,3,1,1,1,1,3,3,0,0,0,0,3,3,2,2,0,0,2,2,2,2,2,2,1,1,0,0,0,0,0,0,1,1,2,2,2,2,0,0,3,3,3,3,0,0,3,3,1,1,3,3,1,1,1,1,0,0,2,2,0,0,2,2,2,2,0,0,3,3,2,2,1,1,2,2,2,2,3,3,2,2,0,0,1,1,0,0,2,2,0,0,1,1,0,0,0,0,0,0,1,1,2,2,0,0,0,0,2,2,0,0,1,1,1,1,2,2,3,3,0,0,1,1,1,1,1,1,1,1,3,3,3,3,2,2,3,3,0,0,0,0,3,3,1,1,0,0,3,3,2,2,0,0,0,0,1,1,0,0,0,0,0,0,3,3,2,2,0,0,2,2,1,1,1,1,3,3,0,0,2,2,3,3,3,3,1,1,0,0,2,2,3,3,1,1,1,1,2,2,1,1,3,3,2,2,2,2,1,1,0,0,1,1,2,2,3,3,0,0,2,2,3,3,2,2,0,0,0,0,1,1,1,1,0,0,3,3,0,0,0,0,2,2,1,1,3,3,2,2,2,2,2,2,0,0,1,1,2,2,3,3,0,0,0,0,3,3,2,2,3,3,2,2,1,1,1,1,0,0,3,3,0,0,0,0,1,1,2,2,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,3,3,1,1,2,2,0,0,3,3,3,3,0,0,3,3,0,0,2,2,1,1,2,2,1,1,3,3,0,0,1,1,1,1,2,2,3,3,3,3,1,1,0,0,0,0,0,0,1,1,0,0,3,3,0,0,0,0,2,2,1,1,0,0,1,1,1,1,0,0,0,0,0,0,3,3,0,0,1,1,0,0,0,0,0,0,3,3,3,3,1,1,3,3,2,2,0,0,0,0,2,2,1,1,2,2,2,2,2,2,1,1,3,3,1,1,3,3,1,1,2,2,0,0,3,3,1,1,2,2,0,0,3,3,1,1,1,1,3,3,1,1,0,0,0,0,1,1,0,0,2,2,3,3,0,0,1,1,1,1,2,2,1,1,0,0,0,0,1,1,1,1,2,2,0,0,0,0,2,2,0,0,2,2,1,1,2,2,1,1,1,1,1,1,2,2,1,1,3,3,3,3,2,2,0,0,2,2,2,2,3,3,2,2,0,0,0,0,1,1,3,3,3,3,2,2,2,2,3,3,1,1,3,3,2,2,3,3,3,3,3,3,2,2,3,3,2,2,0,0,0,0,2,2,3,3,0,0,1,1,2,2,0,0,3,3,1,1,0,0,0,0,1,1,1,1,0,0,3,3,0,0,0,0,2,2,1,1,1,1,1,1,2,2,1,1,2,2,0,0,0,0,3,3,2,2,1,1,3,3,3,3,3,3,3,3,3,3,2,2,3,3,2,2,2,2,0,0,3,3,0,0,3,3,0,0,0,0,3,3,3,3,0,0,0,0,1,1,2,2,1,1,1,1,2,2,1,1,1,1,2,2,0,0,0,0,0,0,3,3,3,3,0,0,3,3,3,3,1,1,2,2,3,3,0,0,1,1,1,1,1,1,2,2,3,3,2,2,0,0,3,3,2,2,2,2,3,3,2,2,1,1,1,1,0,0,3,3,3,3,3,3,0,0,2,2,0,0,0,0,0,0,1,1,3,3,2,2,2,2,3,3,1,1,2,2,0,0,2,2,2,2,0,0,3,3,1,1,3,3,3,3,3,3,2,2,2,2,1,1,1,1,0,0,2,2,0,0,1,1,0,0,1,1,1,1,0,0,2,2,1,1,1,1,2,2,3,3,3,3,1,1,2,2,0,0,3,3,2,2,2,2,0,0,1,1,0,0,0,0,1,1,2,2,0,0,1,1,0,0,1,1,3,3,1,1,2,2,1,1,2,2,3,3,2,2,1,1,1,1,1,1,2,2,0,0,1,1,0,0,0,0,1,1,2,2,1,1,3,3,0,0,2,2,1,1,3,3,3,3,2,2,2,2,0,0,1,1,2,2,2,2,1,1,2,2,0,0,1,1,0,0,1,1,1,1,2,2,0,0,0,0,2,2,0,0,0,0,0,0,0,0,3,3,1,1,0,0,0,0,2,2,3,3,0,0,0,0,3,3,1,1,0,0,0,0,3,3,1,1,0,0,1,1,1,1,0,0,2,2,2,2,2,2,3,3,1,1,1,1,1,1,3,3,0,0,3,3,2,2,1,1,2,2,0,0,3,3,1,1,2,2,3,3,3,3,1,1,2,2,0,0,3,3,3,3,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,1,1,2,2,2,2,0,0,1,1,0,0,2,2,3,3,0,0,1,1,3,3,0,0,2,2,2,2,2,2,0,0,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,3,3,3,3,2,2,1,1,2,2,2,2,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,2,2,2,2,1,1,1,1,2,2,3,3,2,2,2,2,3,3,0,0,2,2,2,2,0,0,2,2,0,0,3,3,0,0,3,3,3,3,1,1,1,1,2,2,3,3,3,3,0,0,0,0,1,1,0,0,3,3,0,0,2,2,1,1,1,1,3,3,3,3,1,1,1,1,3,3,2,2,2,2,2,2,0,0,2,2,3,3,1,1,1,1,0,0,3,3,0,0,0,0,3,3,2,2,0,0,0,0,1,1,1,1,0,0,0,0,2,2,2,2,0,0,3,3,2,2,2,2,3,3,1,1,0,0,0,0,0,0,2,2,3,3,1,1,2,2,3,3,2,2,2,2,2,2,3,3,3,3,2,2,2,2,1,1,0,0,3,3,2,2,3,3,1,1,0,0,3,3,1,1,1,1,2,2,3,3,0,0,3,3,3,3,1,1,1,1,3,3,2,2,2,2,2,2,1,1,2,2,1,1,2,2,2,2,3,3,3,3,3,3,2,2,0,0,2,2,2,2,2,2,3,3,0,0,2,2,2,2,0,0,3,3,3,3,0,0,3,3,3,3,0,0,2,2,0,0,0,0,3,3,2,2,1,1,2,2,0,0,3,3,0,0,2,2,3,3,2,2,0,0,1,1,3,3,1,1,0,0,2,2,0,0,0,0,1,1,0,0,2,2,0,0,3,3,3,3,3,3,2,2,0,0,3,3,0,0,2,2,0,0,2,2,0,0,2,2,2,2,0,0,2,2,0,0,3,3,0,0,3,3,1,1,3,3,2,2,2,2,2,2,1,1,2,2,2,2,2,2,0,0,3,3,2,2,2,2,3,3,3,3,3,3,2,2,0,0,0,0,1,1,2,2,1,1,2,2,2,2,1,1,2,2,1,1,0,0,0,0,0,0,3,3,1,1,2,2,0,0,2,2,0,0,1,1,0,0,3,3,1,1,1,1,0,0,0,0,2,2,0,0,1,1,0,0,3,3,2,2,0,0,0,0,1,1,3,3,1,1,2,2,2,2,0,0,3,3,1,1,3,3,0,0,1,1,1,1,3,3,3,3,2,2,0,0,0,0,2,2,2,2,1,1,3,3,2,2,0,0,2,2,3,3,3,3,1,1,2,2,1,1,2,2,3,3,1,1,0,0,2,2,2,2,2,2,1,1,0,0,0,0,0,0,2,2,2,2,1,1,2,2,1,1,3,3,1,1,1,1,3,3,3,3,2,2,3,3,1,1,3,3,0,0,2,2,3,3,0,0,1,1,2,2,0,0,1,1,0,0,1,1,3,3,0,0,1,1,1,1,2,2,3,3,1,1,3,3,1,1,3,3,0,0,1,1,1,1,3,3,2,2,1,1,1,1,3,3,0,0,1,1,0,0,3,3,1,1,1,1,2,2,1,1,0,0,0,0,2,2,0,0,1,1,3,3,0,0,3,3,0,0,3,3,0,0,2,2,2,2,1,1,0,0,1,1,0,0,1,1,2,2,3,3,2,2,2,2,0,0,3,3,0,0,3,3,2,2,1,1,0,0,1,1,1,1,0,0,1,1,3,3,3,3,0,0,3,3,0,0,3,3,0,0,3,3,3,3,2,2,0,0,1,1,0,0,0,0,2,2,1,1,2,2,3,3,0,0,2,2,1,1,1,1,2,2,2,2,3,3,2,2,1,1,1,1,0,0,1,1,3,3,3,3,0,0,3,3,1,1,2,2,0,0,1,1,3,3,3,3,1,1,0,0,1,1,2,2,3,3,2,2,3,3,3,3,3,3,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,2,2,2,2,2,2,2,2,0,0,3,3,3,3,2,2,1,1,0,0,1,1,3,3,1,1,2,2,2,2,3,3,2,2,1,1,2,2,0,0,3,3,1,1,3,3,1,1,3,3,1,1,0,0,3,3,0,0,3,3,2,2,3,3,3,3,1,1,1,1,0,0,1,1,1,1,2,2,1,1,0,0,2,2,3,3,1,1,0,0,0,0,1,1,2,2,1,1,0,0,2,2,0,0,1,1,2,2,3,3,1,1,3,3,0,0,3,3,2,2,3,3,0,0,2,2,0,0,2,2,3,3,3,3,1,1,1,1,3,3,3,3,1,1,2,2,1,1,3,3,2,2,2,2,2,2,0,0,2,2,2,2,0,0,0,0,0,0,3,3,0,0,0,0,0,0,2,2,0,0,0,0,1,1,1,1,3,3,1,1,3,3,2,2,1,1,0,0,1,1,0,0,3,3,1,1,3,3,0,0,2,2,3,3,1,1,3,3,0,0,1,1,1,1,2,2,2,2,3,3,2,2,1,1,2,2,0,0,2,2,0,0,3,3,2,2,2,2,2,2,2,2,2,2,0,0,1,1,1,1,3,3,3,3,0,0,1,1,2,2,2,2,3,3,2,2,0,0,1,1,1,1,3,3,3,3,3,3,3,3,1,1,0,0,2,2,1,1,1,1,1,1,0,0,3,3,0,0,0,0,2,2,0,0,1,1,2,2,0,0,0,0,3,3,2,2,3,3,2,2,3,3,3,3,3,3,3,3,2,2,0,0,1,1,2,2,2,2,1,1,2,2,2,2,2,2,2,2,3,3,0,0,2,2,0,0,1,1,1,1,1,1,1,1,1,1,2,2,0,0,2,2,0,0,1,1,2,2,1,1,2,2,0,0,3,3,1,1,3,3,2,2,0,0,1,1,2,2,0,0,0,0,2,2,2,2,2,2,3,3,1,1,3,3,2,2,2,2,1,1,1,1,3,3,2,2,2,2,2,2,1,1,0,0,3,3,1,1,2,2,2,2,2,2,1,1,1,1,0,0,1,1,3,3,0,0,2,2,0,0,0,0,2,2,1,1,3,3,0,0,3,3,2,2,1,1,0,0,0,0,0,0,0,0,1,1,3,3,0,0,3,3,0,0,2,2,2,2,0,0,1,1,1,1,3,3,1,1,0,0,2,2,0,0,2,2,2,2,2,2,0,0,1,1,1,1,2,2,1,1,2,2,1,1,1,1,2,2,2,2,3,3,2,2,0,0,1,1,2,2,3,3,1,1,1,1,2,2,3,3,3,3,2,2,1,1,1,1,0,0,3,3,3,3,3,3,1,1,3,3,1,1,2,2,2,2,1,1,1,1,3,3,1,1,3,3,1,1,3,3,1,1,1,1,3,3,3,3,0,0,3,3,1,1,0,0,0,0,2,2,2,2,2,2,1,1,0,0,0,0,3,3,2,2,0,0,1,1,1,1,1,1,0,0,3,3,1,1,3,3,2,2,1,1,2,2,2,2,0,0,0,0,1,1,1,1,0,0,3,3,2,2,1,1,3,3,1,1,2,2,2,2,3,3,0,0,2,2,0,0,3,3,1,1,3,3,3,3,2,2,3,3,1,1,0,0,1,1,1,1,3,3,3,3,2,2,2,2,3,3,2,2,3,3,1,1,2,2,2,2,1,1,1,1,3,3,3,3,1,1,2,2,1,1,2,2,3,3,3,3,2,2,1,1,1,1,0,0,2,2,0,0,0,0,0,0,3,3,0,0,3,3,1,1,1,1,3,3,3,3,1,1,1,1,1,1,2,2,0,0,1,1,0,0,0,0,3,3,2,2,2,2,1,1,2,2,3,3,0,0,1,1,3,3,0,0,1,1,0,0,3,3,1,1,2,2,3,3,0,0,1,1,1,1,0,0,2,2,3,3,2,2,2,2,0,0,0,0,1,1,0,0,2,2,0,0,1,1,0,0,0,0,2,2,2,2,2,2,2,2,3,3,2,2,0,0,2,2,3,3,0,0,1,1,2,2,2,2,2,2,0,0,1,1,2,2,2,2,3,3,0,0,0,0,0,0,2,2,0,0,1,1,2,2,1,1,0,0,0,0,2,2,1,1,3,3,3,3,1,1,2,2,0,0,2,2,0,0,0,0,3,3,0,0,1,1,0,0,1,1,0,0,2,2,1,1,2,2,0,0,0,0,0,0,3,3,0,0,1,1,1,1,3,3,2,2,2,2,3,3,1,1,2,2,3,3,3,3,0,0,2,2,0,0,0,0,2,2,1,1,2,2,3,3,0,0,0,0,0,0,0,0,2,2,2,2,0,0,2,2,0,0,0,0,0,0,2,2,1,1,3,3,0,0,2,2,1,1,2,2,1,1,0,0,3,3,2,2,1,1,3,3,0,0,3,3,1,1,1,1,0,0,3,3,1,1,2,2,3,3,2,2,3,3,1,1,1,1,2,2,0,0,3,3,3,3,2,2,0,0,3,3,1,1,0,0,1,1,1,1,1,1,0,0,0,0,2,2,3,3,1,1,0,0,3,3,0,0,3,3,0,0,1,1,3,3,2,2,2,2,3,3,2,2,1,1,1,1,1,1,2,2,2,2,0,0,2,2,1,1,3,3,2,2,2,2,3,3,0,0,1,1,0,0,2,2,2,2,0,0,2,2,3,3,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,3,3,0,0,0,0,2,2,3,3,3,3,0,0,0,0,0,0,1,1,3,3,2,2,0,0,2,2,0,0,3,3,0,0,3,3,3,3,2,2,3,3,0,0,1,1,3,3,0,0,0,0,2,2,1,1,3,3,2,2,0,0,3,3,1,1,1,1,0,0,1,1,3,3,2,2,2,2,2,2,0,0,2,2,1,1,3,3,1,1,1,1,2,2,3,3,3,3,1,1,0,0,0,0,2,2,3,3,0,0,3,3,2,2,3,3,3,3,3,3,3,3,2,2,3,3,0,0,2,2,1,1,3,3,1,1,1,1,2,2,1,1,0,0,2,2,2,2,0,0,3,3,0,0,1,1,0,0,0,0,3,3,1,1,0,0,3,3,1,1,1,1,0,0,0,0,0,0,2,2,0,0,3,3,0,0,2,2,2,2,2,2,2,2,3,3,1,1,3,3,0,0,2,2,0,0,2,2,2,2,1,1,0,0,3,3,2,2,0,0,3,3,3,3,0,0,0,0,1,1,3,3,0,0,0,0,0,0,2,2,0,0,3,3,3,3,1,1,1,1,0,0,2,2,3,3,1,1,2,2,0,0,0,0,1,1,1,1,0,0,2,2,0,0,1,1,2,2,3,3,3,3,3,3,3,3,2,2,1,1,1,1,2,2,1,1,0,0,3,3,1,1,0,0,1,1,0,0,2,2,2,2,3,3,1,1,2,2,1,1,3,3,2,2,2,2,2,2,0,0,2,2,3,3,1,1,3,3,3,3,0,0,0,0,0,0,3,3,1,1,2,2,1,1,1,1,3,3,2,2,1,1,1,1,1,1,3,3,0,0,1,1,2,2,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,3,3,0,0,0,0,3,3,2,2,3,3,1,1,3,3,1,1,1,1,0,0,0,0,0,0,3,3,1,1,1,1,0,0,3,3,0,0,2,2,2,2,3,3,1,1,1,1,3,3,0,0,2,2,1,1,0,0,2,2,2,2,2,2,0,0,2,2,0,0,2,2,1,1,2,2,1,1,0,0,0,0,2,2,3,3,1,1,3,3,2,2,3,3,3,3,0,0,1,1,1,1,0,0,2,2,2,2,1,1,2,2,3,3,1,1,0,0,0,0,0,0,2,2,3,3,3,3,2,2,1,1,3,3,3,3,1,1,3,3,1,1,0,0,2,2,2,2,2,2,0,0,3,3,1,1,2,2,1,1,0,0,1,1,3,3,3,3,0,0,3,3,3,3,0,0,3,3,3,3,2,2,0,0,1,1,3,3,2,2,3,3,1,1,2,2,2,2,2,2,3,3,2,2,3,3,3,3,3,3,1,1,1,1,2,2,0,0,2,2,2,2,3,3,1,1,2,2,1,1,3,3,1,1,2,2,0,0,2,2,1,1,2,2,1,1,0,0,3,3,1,1,1,1,2,2,1,1,3,3,2,2,3,3,2,2,3,3,2,2,1,1,3,3,0,0,3,3,0,0,2,2,3,3,1,1,2,2,2,2,2,2,2,2,0,0,3,3,2,2,1,1,0,0,1,1,1,1,2,2,3,3,1,1,2,2,3,3,1,1,0,0,2,2,1,1,3,3,3,3,2,2,3,3,3,3,3,3,1,1,3,3,2,2,1,1,2,2,1,1,0,0,3,3,3,3,1,1,1,1,3,3,1,1,3,3,1,1,0,0,3,3,0,0,1,1,0,0,2,2,0,0,2,2,0,0,0,0,2,2,3,3,0,0,0,0,1,1,2,2,3,3,1,1,2,2,3,3,0,0,1,1,1,1,2,2,0,0,1,1,0,0,1,1,2,2,0,0,1,1,2,2,1,1,3,3,2,2,0,0,2,2,0,0,3,3,1,1,2,2,3,3,3,3,1,1,0,0,1,1,0,0,2,2,2,2,3,3,0,0,3,3,0,0,1,1,3,3,1,1,1,1,0,0,2,2,2,2,1,1,0,0,1,1,0,0,3,3,1,1,2,2,3,3,2,2,1,1,2,2,0,0,2,2,2,2,3,3,1,1,0,0,0,0,3,3,1,1,3,3,1,1,3,3,3,3,1,1,3,3,2,2,1,1,2,2,1,1,2,2,3,3,1,1,0,0,3,3,3,3,2,2,1,1,0,0,1,1,2,2,0,0,3,3,3,3,0,0,0,0,0,0,3,3,0,0,1,1,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,2,2,0,0,3,3,0,0,3,3,2,2,1,1,1,1,2,2,1,1,3,3,3,3,1,1,1,1,1,1,3,3,1,1,0,0,3,3,1,1,0,0,3,3,0,0,3,3,2,2,2,2,3,3,0,0,2,2,0,0,2,2,0,0,0,0,2,2,3,3,0,0,1,1,1,1,2,2,2,2,3,3,0,0,2,2,1,1,2,2,2,2,2,2,1,1,0,0,0,0,2,2,3,3,1,1,1,1,1,1,0,0,3,3,2,2,0,0,3,3,1,1,2,2,1,1,0,0,3,3,3,3,3,3,1,1,3,3,0,0,2,2,0,0,2,2,2,2,3,3,1,1,0,0,3,3,1,1,0,0,2,2,3,3,0,0,2,2,2,2,3,3,3,3,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,2,2,0,0,0,0,2,2,3,3,1,1,0,0,1,1,1,1,3,3,3,3,1,1,2,2,2,2,0,0,1,1,3,3,3,3,1,1,1,1,3,3,0,0,1,1,2,2,1,1,1,1,1,1,0,0,2,2,2,2,3,3,3,3,0,0,2,2,2,2,2,2,0,0,3,3,0,0,1,1,2,2,0,0,2,2,0,0,3,3,2,2,2,2,2,2,2,2,0,0,2,2,0,0,0,0,1,1,0,0,3,3,0,0,1,1,3,3,1,1,1,1,2,2,1,1,2,2,2,2,1,1,0,0,0,0,1,1,2,2,1,1,1,1,3,3,1,1,2,2,3,3,1,1,0,0,0,0,0,0,1,1,1,1,3,3,1,1,3,3,1,1,0,0,1,1,1,1,3,3,3,3,2,2,3,3,3,3,2,2,2,2,0,0,2,2,0,0,0,0,0,0,3,3,0,0,2,2,1,1,0,0,2,2,1,1,2,2,1,1,3,3,1,1,3,3,2,2,1,1,0,0,1,1,0,0,3,3,0,0,0,0,1,1,2,2,1,1,3,3,3,3,0,0,2,2,0,0,2,2,1,1,2,2,0,0,1,1,2,2,3,3,3,3,0,0,3,3,1,1,0,0,3,3,1,1,2,2,1,1,1,1,1,1,3,3,0,0,1,1,1,1,3,3,3,3,2,2,3,3,3,3,2,2,0,0,3,3,1,1,2,2,0,0,2,2,0,0,1,1,2,2,0,0,0,0,0,0,1,1,0,0,2,2,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,3,3,2,2,0,0,1,1,0,0,2,2,2,2,2,2,2,2,3,3,2,2,2,2,1,1,2,2,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,3,3,1,1,2,2,0,0,3,3,3,3,3,3,3,3,1,1,3,3,0,0,3,3,3,3,1,1,0,0,1,1,2,2,3,3,2,2,0,0,1,1,2,2,0,0,1,1,1,1,0,0,0,0,2,2,2,2,0,0,0,0,2,2,3,3,2,2,1,1,2,2,2,2,2,2,1,1,3,3,1,1,3,3,3,3,3,3,0,0,2,2,2,2,1,1,0,0,3,3,2,2,0,0,3,3,2,2,1,1,1,1,2,2,0,0,3,3,1,1,3,3,2,2,2,2,0,0,0,0,0,0,0,0,3,3,1,1,2,2,3,3,1,1,0,0,1,1,0,0,0,0,3,3,3,3,1,1,0,0,3,3,0,0,0,0,3,3,3,3,0,0,3,3,1,1,1,1,2,2,2,2,3,3,3,3,0,0,0,0,1,1,3,3,0,0,1,1,0,0,2,2,1,1,0,0,3,3,1,1,3,3,1,1,0,0,3,3,0,0,3,3,0,0,2,2,3,3,0,0,3,3,0,0,0,0,1,1,0,0,2,2,0,0,1,1,1,1,3,3,1,1,2,2,1,1,3,3,2,2,0,0,1,1,1,1,0,0,3,3,1,1,3,3,3,3,0,0,1,1,1,1,1,1,3,3,1,1,0,0,0,0,1,1,3,3,0,0,0,0,2,2,2,2,1,1,0,0,3,3,0,0,0,0,0,0,1,1,2,2,2,2,0,0,3,3,3,3,2,2,1,1,0,0,2,2,2,2,1,1,0,0,1,1,3,3,3,3,3,3,2,2,0,0,0,0,0,0,2,2,2,2,3,3,1,1,0,0,2,2,0,0,1,1,3,3,2,2,0,0,3,3,2,2,1,1,2,2,2,2,2,2,3,3,3,3,2,2,0,0,0,0,2,2,0,0,2,2,3,3,1,1,2,2,3,3,2,2,2,2,0,0,2,2,3,3,2,2,0,0,0,0,3,3,0,0,1,1,0,0,1,1,2,2,2,2,0,0,0,0,0,0,2,2,3,3,1,1,3,3,1,1,2,2,0,0,3,3,1,1,0,0,0,0,0,0,3,3,2,2,1,1,2,2,0,0,3,3,3,3,0,0,0,0,2,2,2,2,0,0,2,2,3,3,1,1,3,3,2,2,0,0,1,1,0,0,1,1,0,0,2,2,3,3,3,3,3,3,0,0,1,1,2,2,1,1,1,1,1,1,0,0,0,0,1,1,1,1,3,3,2,2,1,1,2,2,1,1,0,0,0,0,2,2,1,1,2,2,3,3,3,3,0,0,3,3,1,1,0,0,1,1,3,3,3,3,2,2,0,0,1,1,3,3,3,3,0,0,0,0,2,2,2,2,1,1,1,1,1,1,2,2,3,3,0,0,2,2,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,2,2,0,0,1,1,1,1,3,3,3,3,3,3,2,2,2,2,0,0,3,3,0,0,2,2,1,1,3,3,1,1,1,1,0,0,2,2,0,0,1,1,0,0,0,0,1,1,3,3,2,2,1,1,3,3,3,3,2,2,1,1,2,2,2,2,1,1,0,0,1,1,2,2,3,3,3,3,0,0,0,0,0,0,1,1,3,3,3,3,3,3,2,2,1,1,1,1,1,1,1,1,2,2,1,1,0,0,0,0,2,2,2,2,1,1,1,1,0,0,0,0,0,0,3,3,3,3,1,1,0,0,2,2,3,3,0,0,3,3,2,2,1,1,1,1,0,0,2,2,3,3,1,1,1,1,1,1,1,1,0,0,2,2,0,0,0,0,2,2,2,2,1,1,0,0,2,2,2,2,2,2,1,1,1,1,2,2,1,1,3,3,3,3,3,3,2,2,2,2,3,3,3,3,0,0,1,1,3,3,2,2,2,2,3,3,0,0,1,1,1,1,0,0,1,1,2,2,3,3,2,2,2,2,3,3,0,0,2,2,0,0,2,2,3,3,1,1,3,3,2,2,1,1,3,3,1,1,0,0,2,2,1,1,1,1,0,0,3,3,3,3,3,3,2,2,0,0,0,0,1,1,2,2,3,3,1,1,1,1,1,1,2,2,2,2,1,1,3,3,2,2,0,0,3,3,3,3,3,3,2,2,0,0,1,1,3,3,2,2,0,0,1,1,3,3,1,1,3,3,2,2,2,2,0,0,2,2,3,3,3,3,0,0,0,0,0,0,2,2,1,1,1,1,1,1,2,2,2,2,1,1,1,1,2,2,2,2,0,0,0,0,3,3,1,1,1,1,1,1,2,2,0,0,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,3,3,0,0,2,2,0,0,2,2,3,3,2,2,2,2,0,0,2,2,0,0,3,3,2,2,1,1,3,3,0,0,2,2,2,2,2,2,2,2,1,1,3,3,2,2,1,1,0,0,1,1,2,2,0,0,2,2,0,0,2,2,2,2,1,1,3,3,2,2,3,3,3,3,3,3,2,2,2,2,3,3,1,1,1,1,0,0,0,0,1,1,3,3,0,0,2,2,3,3,2,2,2,2,0,0,1,1,3,3,3,3,3,3,2,2,2,2,0,0,3,3,2,2,3,3,1,1,0,0,1,1,1,1,1,1,3,3,2,2,1,1,3,3,2,2,0,0,0,0,1,1,2,2,2,2,3,3,2,2,2,2,2,2,3,3,1,1,1,1,0,0,2,2,0,0,1,1,2,2,3,3,2,2,3,3,3,3,2,2,0,0,1,1,1,1,1,1,0,0,1,1,0,0,3,3,3,3,0,0,1,1,0,0,0,0,2,2,2,2,1,1,0,0,3,3,0,0,0,0,1,1,1,1,0,0,1,1,3,3,1,1,1,1,1,1,0,0,2,2,0,0,2,2,1,1,0,0,1,1,3,3,1,1,1,1,3,3,2,2,0,0,2,2,2,2,2,2,1,1,3,3,2,2,2,2,2,2,0,0,2,2,3,3,0,0,2,2,0,0,1,1,2,2,1,1,0,0,0,0,3,3,3,3,1,1,3,3,1,1,1,1,2,2,3,3,0,0,1,1,1,1,3,3,1,1,0,0,3,3,2,2,2,2,0,0,2,2,0,0,1,1,3,3,1,1,2,2,0,0,1,1,3,3,3,3,0,0,0,0,3,3,0,0,2,2,0,0,3,3,3,3,2,2,1,1,2,2,1,1,2,2,1,1,2,2,0,0,3,3,1,1,2,2,0,0,0,0,1,1,3,3,0,0,2,2,0,0,0,0,0,0,0,0,2,2,1,1,2,2,3,3,2,2,2,2,2,2,3,3,3,3,3,3,0,0,0,0,2,2,0,0,2,2,2,2,0,0,2,2,0,0,1,1,0,0,3,3,1,1,0,0,0,0,2,2,0,0,3,3,1,1,0,0,0,0,3,3,3,3,0,0,0,0,1,1,3,3,3,3,1,1,0,0,0,0,2,2,3,3,0,0,0,0,1,1,2,2,1,1,1,1,0,0,0,0,2,2,2,2,1,1,2,2,2,2,1,1,2,2,0,0,1,1,2,2,0,0,0,0,0,0,2,2,1,1,1,1,1,1,2,2,0,0,3,3,3,3,0,0,0,0,3,3,0,0,3,3,2,2,3,3,1,1,3,3,3,3,1,1,3,3,1,1,0,0,3,3,3,3,3,3,0,0,3,3,1,1,1,1,0,0,0,0,2,2,3,3,0,0,3,3,0,0,1,1,1,1,1,1,2,2,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,2,2,3,3,0,0,0,0,2,2,2,2,2,2,2,2,0,0,2,2,0,0,2,2,3,3,2,2,2,2,2,2,3,3,2,2,0,0,0,0,1,1,0,0,3,3,2,2,0,0,3,3,1,1,3,3,2,2,2,2,2,2,2,2,1,1,2,2,0,0,0,0,2,2,0,0,3,3,3,3,1,1,1,1,1,1,1,1,2,2,3,3,3,3,2,2,0,0,1,1,1,1,1,1,1,1,1,1,2,2,0,0,3,3,0,0,3,3,1,1,0,0,2,2,1,1,3,3,0,0,2,2,1,1,1,1,2,2,2,2,2,2,3,3,1,1,3,3,0,0,3,3,3,3,0,0,1,1,1,1,2,2,2,2,0,0,3,3,0,0,2,2,0,0,1,1,3,3,3,3,3,3,2,2,1,1,3,3,0,0,3,3,2,2,1,1,1,1,0,0,0,0,1,1,3,3,0,0,0,0,2,2,0,0,2,2,2,2,1,1,1,1,2,2,1,1,3,3,1,1,3,3,2,2,0,0,1,1,0,0,3,3,0,0,1,1,0,0,2,2,2,2,0,0,2,2,0,0,3,3,0,0,3,3,0,0,2,2,2,2,0,0,1,1,0,0,1,1,1,1,2,2,0,0,0,0,1,1,0,0,3,3,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,3,3,0,0,3,3,1,1,3,3,3,3,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,3,3,0,0,0,0,3,3,1,1,1,1,2,2,0,0,1,1,0,0,1,1,1,1,3,3,0,0,0,0,2,2,2,2,1,1,1,1,3,3,0,0,1,1,3,3,1,1,3,3,2,2,1,1,1,1,0,0,0,0,2,2,0,0,1,1,1,1,3,3,2,2,2,2,1,1,3,3,3,3,0,0,3,3,2,2,3,3,3,3,0,0,0,0,3,3,0,0,0,0,0,0,3,3,2,2,2,2,0,0,1,1,2,2,0,0,2,2,2,2,1,1,1,1,3,3,0,0,1,1,2,2,3,3,0,0,0,0,2,2,1,1,2,2,3,3,1,1,1,1,0,0,2,2,1,1,2,2,2,2,3,3,3,3,1,1,2,2,1,1,2,2,0,0,0,0,2,2,2,2,2,2,3,3,0,0,0,0,0,0,3,3,0,0,3,3,2,2,2,2,1,1,3,3,0,0,2,2,3,3,2,2,0,0,3,3,2,2,1,1,0,0,1,1,3,3,1,1,0,0,2,2,0,0,2,2,1,1,3,3,2,2,3,3,1,1,1,1,2,2,1,1,1,1,1,1,1,1,3,3,3,3,2,2,0,0,0,0,2,2,3,3,2,2,0,0,1,1,2,2,2,2,2,2,2,2,0,0,3,3,1,1,3,3,1,1,0,0,0,0,2,2,0,0,1,1,2,2,2,2,1,1,1,1,1,1,2,2,1,1,0,0,1,1,1,1,0,0,1,1,2,2,3,3,1,1,0,0,1,1,3,3,2,2,0,0,1,1,1,1,2,2,0,0,0,0,3,3,2,2,2,2,1,1,2,2,1,1,2,2,3,3,2,2,0,0,3,3,2,2,2,2,3,3,1,1,0,0,0,0,0,0,0,0,2,2,0,0,1,1,0,0,2,2,3,3,3,3,0,0,3,3,0,0,2,2,0,0,0,0,1,1,0,0,1,1,0,0,2,2,2,2,2,2,2,2,1,1,3,3,2,2,2,2,1,1,1,1,1,1,3,3,3,3,0,0,2,2,3,3,0,0,0,0,1,1,2,2,1,1,3,3,2,2,2,2,3,3,1,1,0,0,3,3,3,3,3,3,2,2,3,3,0,0,0,0,2,2,2,2,1,1,0,0,1,1,0,0,2,2,1,1,3,3,3,3,2,2,1,1,0,0,2,2,0,0,2,2,3,3,2,2,2,2,1,1,3,3,2,2,0,0,1,1,1,1,3,3,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,2,2,1,1,2,2,0,0,1,1,0,0,2,2,0,0,2,2,0,0,2,2,2,2,2,2,2,2,0,0,3,3,2,2,3,3,1,1,3,3,0,0,0,0,0,0,1,1,2,2,1,1,3,3,0,0,1,1,0,0,1,1,0,0,2,2,3,3,0,0,3,3,0,0,3,3,1,1,2,2,3,3,0,0,1,1,1,1,2,2,0,0,0,0,2,2,0,0,1,1,0,0,2,2,0,0,0,0,2,2,2,2,3,3,2,2,0,0,3,3,1,1,0,0,2,2,2,2,2,2,2,2,3,3,2,2,1,1,0,0,3,3,3,3,1,1,2,2,0,0,1,1,1,1,2,2,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,2,2,2,2,0,0,2,2,3,3,2,2,1,1,3,3,0,0,0,0,2,2,0,0,3,3,0,0,2,2,1,1,1,1,2,2,0,0,0,0,1,1,3,3,0,0,2,2,2,2,2,2,1,1,1,1,0,0,3,3,3,3,1,1,1,1,2,2,0,0,0,0,3,3,1,1,1,1,0,0,1,1,1,1,3,3,3,3,3,3,3,3,0,0,0,0,2,2,2,2,3,3,2,2,1,1,2,2,0,0,0,0,0,0,2,2,0,0,0,0,2,2,2,2,1,1,3,3,3,3,0,0,3,3,1,1,3,3,0,0,1,1,0,0,1,1,2,2,0,0,2,2,2,2,0,0,1,1,2,2,3,3,0,0,0,0,3,3,0,0,2,2,3,3,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,3,3,1,1,3,3,1,1,1,1,0,0,3,3,1,1,0,0,0,0,0,0,1,1,3,3,3,3,3,3,0,0,0,0,3,3,0,0,3,3,0,0,2,2,0,0,2,2,2,2,2,2,0,0,0,0,2,2,2,2,1,1,1,1,3,3,2,2,2,2,3,3,3,3,1,1,2,2,3,3,3,3,0,0,3,3,0,0,2,2,1,1,3,3,0,0,1,1,1,1,2,2,1,1,3,3,3,3,0,0,1,1,3,3,2,2,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,2,2,2,2,0,0,2,2,0,0,3,3,0,0,0,0,0,0,0,0,1,1,3,3,1,1,0,0,3,3,2,2,2,2,3,3,3,3,3,3,0,0,3,3,2,2,0,0,0,0,2,2,0,0,0,0,1,1,0,0,2,2,1,1,2,2,1,1,1,1,1,1,3,3,1,1,1,1,3,3,0,0,0,0,1,1,1,1,2,2,3,3,0,0,2,2,1,1,1,1,0,0,1,1,0,0,3,3,0,0,0,0,3,3,0,0,1,1,2,2,0,0,0,0,0,0,3,3,3,3,1,1,0,0,2,2,2,2,2,2,1,1,3,3,3,3,1,1,1,1,3,3,2,2,3,3,2,2,2,2,3,3,2,2,3,3,2,2,2,2,1,1,2,2,2,2,1,1,3,3,2,2,2,2,2,2,1,1,3,3,2,2,1,1,3,3,2,2,3,3,1,1,0,0,3,3,2,2,2,2,1,1,1,1,2,2,2,2,1,1,2,2,1,1,3,3,3,3,0,0,3,3,1,1,2,2,0,0,3,3,0,0,2,2,3,3,0,0,2,2,3,3,2,2,0,0,0,0,0,0,3,3,0,0,0,0,1,1,3,3,3,3,0,0,1,1,0,0,2,2,1,1,2,2,2,2,3,3,1,1,1,1,1,1,3,3,3,3,0,0,2,2,2,2,3,3,0,0,0,0,2,2,1,1,3,3,1,1,1,1,1,1,2,2,0,0,2,2,2,2,3,3,3,3,1,1,0,0,3,3,3,3,0,0,0,0,3,3,0,0,3,3,3,3,2,2,2,2,3,3,3,3,1,1,1,1,3,3,2,2,0,0,0,0,3,3,1,1,0,0,0,0,3,3,3,3,1,1,1,1,3,3,0,0,1,1,3,3,3,3,3,3,0,0,1,1,1,1,1,1,2,2,1,1,1,1,0,0,1,1,1,1,0,0,0,0,2,2,3,3,1,1,2,2,2,2,0,0,2,2,2,2,2,2,3,3,0,0,1,1,1,1,1,1,3,3,2,2,2,2,1,1,2,2,1,1,1,1,1,1,0,0,2,2,3,3,1,1,0,0,3,3,3,3,3,3,3,3,2,2,0,0,0,0,2,2,0,0,2,2,2,2,1,1,0,0,1,1,1,1,2,2,3,3,1,1,2,2,3,3,2,2,2,2,0,0,0,0,1,1,3,3,2,2,1,1,0,0,0,0,3,3,3,3,1,1,0,0,1,1,2,2,0,0,2,2,3,3,2,2,3,3,1,1,1,1,2,2,1,1,3,3,0,0,2,2,0,0,0,0,2,2,3,3,0,0,2,2,3,3,1,1,0,0,3,3,0,0,3,3,0,0,1,1,2,2,2,2,3,3,1,1,0,0,2,2,2,2,2,2,1,1,0,0,0,0,1,1,3,3,3,3,0,0,2,2,0,0,3,3,3,3,3,3,1,1,3,3,2,2,0,0,1,1,0,0,1,1,3,3,2,2,1,1,1,1,2,2,1,1,0,0,3,3,3,3,0,0,3,3,2,2,1,1,1,1,1,1,0,0,0,0,1,1,0,0,3,3,3,3,0,0,2,2,3,3,0,0,0,0,3,3,2,2,0,0,2,2,0,0,3,3,2,2,0,0,3,3,3,3,3,3,1,1,1,1,0,0,3,3,0,0,1,1,0,0,2,2,0,0,2,2,3,3,3,3,0,0,0,0,3,3,2,2,0,0,2,2,2,2,3,3,3,3,0,0,3,3,0,0,1,1,0,0,0,0,1,1,3,3,3,3,3,3,2,2,3,3,2,2,3,3,1,1,0,0,3,3,3,3,3,3,2,2,1,1,3,3,1,1,2,2,0,0,2,2,3,3,1,1,2,2,3,3,3,3,2,2,1,1,0,0,2,2,1,1,0,0,1,1,2,2,1,1,1,1,3,3,2,2,3,3,3,3,0,0,3,3,1,1,3,3,0,0,1,1,0,0,1,1,2,2,3,3,3,3,0,0,3,3,0,0,0,0,0,0,1,1,0,0,2,2,1,1,3,3,0,0,1,1,0,0,1,1,1,1,0,0,1,1,2,2,0,0,0,0,0,0,1,1,0,0,2,2,0,0,2,2,0,0,0,0,2,2,1,1,3,3,2,2,1,1,1,1,2,2,2,2,0,0,0,0,1,1,2,2,1,1,2,2,0,0,1,1,3,3,1,1,0,0,3,3,2,2,2,2,2,2,1,1,2,2,2,2,3,3,0,0,0,0,0,0,2,2,2,2,3,3,2,2,1,1,2,2,1,1,1,1,0,0,0,0,2,2,2,2,1,1,3,3,3,3,0,0,2,2,0,0,3,3,2,2,1,1,1,1,1,1,3,3,1,1,0,0,2,2,1,1,0,0,3,3,1,1,1,1,3,3,3,3,1,1,0,0,2,2,1,1,1,1,0,0,1,1,0,0,3,3,2,2,2,2,2,2,3,3,1,1,2,2,0,0,0,0,1,1,0,0,2,2,3,3,0,0,1,1,1,1,2,2,1,1,3,3,3,3,2,2,2,2,2,2,3,3,0,0,0,0,3,3,3,3,0,0,0,0,1,1,1,1,1,1,3,3,0,0,0,0,2,2,0,0,1,1,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,2,2,2,2,3,3,2,2,3,3,0,0,3,3,1,1,0,0,0,0,0,0,1,1,0,0,3,3,1,1,3,3,1,1,3,3,3,3,1,1,2,2,0,0,3,3,3,3,2,2,3,3,1,1,3,3,0,0,1,1,0,0,2,2,2,2,2,2,2,2,1,1,2,2,3,3,3,3,3,3,2,2,3,3,0,0,0,0,3,3,1,1,1,1,0,0,0,0,2,2,1,1,2,2,3,3,0,0,1,1,3,3,0,0,1,1,3,3,1,1,1,1,3,3,0,0,1,1,2,2,1,1,3,3,3,3,0,0,1,1,1,1,2,2,2,2,3,3,1,1,0,0,3,3,1,1,2,2,1,1,3,3,3,3,2,2,0,0,2,2,3,3,3,3,1,1,1,1,2,2,2,2,3,3,2,2,2,2,3,3,1,1,0,0,3,3,2,2,1,1,1,1,0,0,1,1,1,1,3,3,3,3,0,0,1,1,0,0,3,3,0,0,3,3,2,2,0,0,2,2,2,2,3,3,2,2,2,2,2,2,0,0,1,1,1,1,0,0,2,2,2,2,1,1,2,2,0,0,2,2,0,0,1,1,1,1,1,1,2,2,1,1,2,2,2,2,3,3,1,1,0,0,0,0,1,1,0,0,3,3,0,0,1,1,0,0,2,2,2,2,0,0,3,3,1,1,2,2,2,2,3,3,3,3,3,3,2,2,3,3,2,2,1,1,0,0,1,1,1,1,2,2,0,0,2,2,2,2,2,2,0,0,2,2,2,2,2,2,0,0,3,3,1,1,3,3,0,0,3,3,1,1,1,1,1,1,0,0,0,0,2,2,0,0,3,3,0,0,3,3,2,2,2,2,0,0,2,2,2,2,0,0,2,2,2,2,1,1,0,0,2,2,3,3,2,2,2,2,3,3,1,1,0,0,0,0,1,1,1,1,1,1,2,2,1,1,3,3,1,1,1,1,0,0,2,2,3,3,0,0,1,1,2,2,2,2,0,0,0,0,3,3,1,1,2,2,3,3,1,1,0,0,1,1,2,2,0,0,1,1,0,0,0,0,0,0,2,2,3,3,3,3,0,0,1,1,0,0,0,0,0,0,2,2,1,1,3,3,0,0,0,0,3,3,3,3,0,0,0,0,3,3,2,2,2,2,0,0,3,3,0,0,0,0,2,2,3,3,1,1,3,3,2,2,2,2,1,1,1,1,2,2,2,2,1,1,1,1,1,1,3,3,3,3,2,2,3,3,1,1,2,2,1,1,3,3,0,0,1,1,3,3,3,3,2,2,0,0,0,0,2,2,0,0,1,1,1,1,2,2,3,3,1,1,3,3,2,2,0,0,0,0,1,1,0,0,0,0,3,3,2,2,3,3,3,3,3,3,2,2,2,2,2,2,2,2,0,0,3,3,2,2,3,3,1,1,1,1,2,2,0,0,2,2,0,0,1,1,3,3,0,0,2,2,1,1,0,0,3,3,2,2,0,0,0,0,1,1,1,1,2,2,0,0,0,0,1,1,0,0,0,0,2,2,3,3,2,2,3,3,1,1,3,3,3,3,2,2,3,3,3,3,2,2,2,2,0,0,2,2,1,1,3,3,3,3,3,3,0,0,3,3,1,1,2,2,1,1,0,0,1,1,2,2,0,0,0,0,1,1,0,0,0,0,3,3,1,1,3,3,1,1,1,1,3,3,2,2,2,2,2,2,0,0,2,2,3,3,3,3,3,3,3,3,1,1,2,2,1,1,2,2,3,3,3,3,0,0,3,3,0,0,0,0,0,0,0,0,2,2,1,1,0,0,1,1,2,2,2,2,0,0,1,1,2,2,2,2,3,3,1,1,2,2,2,2,1,1,1,1,2,2,2,2,3,3,0,0,3,3,2,2,0,0,0,0,0,0,3,3,0,0,1,1,3,3,0,0,2,2,2,2,1,1,2,2,2,2,0,0,3,3,0,0,2,2,3,3,1,1,1,1,1,1,2,2,1,1,1,1,3,3,3,3,1,1,1,1,0,0,1,1,0,0,3,3,0,0,1,1,1,1,3,3,1,1,1,1,3,3,2,2,0,0,2,2,2,2,0,0,2,2,2,2,1,1,3,3,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,0,0,2,2,3,3,2,2,1,1,1,1,1,1,0,0,0,0,3,3,3,3,1,1,0,0,2,2,1,1,3,3,0,0,1,1,1,1,1,1,3,3,1,1,3,3,2,2,2,2,1,1,1,1,1,1,1,1,3,3,0,0,1,1,3,3,2,2,3,3,2,2,2,2,3,3,3,3,2,2,1,1,3,3,2,2,2,2,1,1,0,0,1,1,1,1,2,2,2,2,0,0,0,0,2,2,1,1,3,3,2,2,1,1,0,0,3,3,0,0,1,1,1,1,2,2,2,2,2,2,1,1,0,0,1,1,2,2,1,1,2,2,1,1,0,0,2,2,0,0,3,3,3,3,3,3,1,1,1,1,0,0,1,1,2,2,0,0,2,2,1,1,2,2,0,0,0,0,0,0,0,0,0,0,3,3,1,1,0,0,1,1,3,3,0,0,0,0,1,1,1,1,3,3,0,0,2,2,2,2,0,0,0,0,0,0,1,1,1,1,3,3,0,0,0,0,2,2,2,2,2,2,3,3,0,0,1,1,3,3,0,0,1,1,0,0,0,0,2,2,1,1,3,3,0,0,1,1,1,1,0,0,0,0,0,0,2,2,0,0,1,1,2,2,3,3,0,0,0,0,2,2,3,3,2,2,3,3,0,0,3,3,0,0,3,3,0,0,2,2,3,3,2,2,3,3,1,1,3,3,1,1,0,0,1,1,3,3,0,0,0,0,1,1,2,2,3,3,1,1,1,1,0,0,0,0,1,1,2,2,3,3,3,3,0,0,3,3,1,1,0,0,1,1,2,2,3,3,2,2,2,2,3,3,0,0,0,0,0,0,1,1,2,2,2,2,2,2,0,0,3,3,3,3,3,3,2,2,1,1,0,0,0,0,1,1,1,1,3,3,0,0,0,0,1,1,2,2,2,2,3,3,1,1,3,3,0,0,1,1,0,0,1,1,1,1,0,0,0,0,2,2,1,1,0,0,3,3,3,3,0,0,3,3,1,1,0,0,3,3,2,2,3,3,1,1,2,2,0,0,1,1,3,3,2,2,3,3,0,0,2,2,1,1,1,1,0,0,2,2,0,0,1,1,0,0,1,1,1,1,2,2,3,3,2,2,1,1,0,0,1,1,2,2,1,1,2,2,0,0,3,3,3,3,0,0,3,3,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,2,2,3,3,1,1,0,0,3,3,1,1,0,0,0,0,3,3,0,0,1,1,0,0,3,3,2,2,1,1,0,0,2,2,2,2,0,0,0,0,3,3,3,3,3,3,2,2,3,3,0,0,0,0,1,1,1,1,3,3,0,0,2,2,1,1,2,2,2,2,1,1,3,3,0,0,0,0,0,0,2,2,1,1,0,0,1,1,2,2,0,0,2,2,1,1,0,0,2,2,0,0,1,1,0,0,3,3,1,1,3,3,3,3,2,2,1,1,2,2,3,3,3,3,1,1,1,1,0,0,3,3,0,0,3,3,2,2,3,3,2,2,3,3,3,3,1,1,0,0,1,1,0,0,3,3,3,3,1,1,3,3,2,2,1,1,0,0,2,2,3,3,3,3,0,0,1,1,3,3,0,0,2,2,0,0,0,0,2,2,1,1,2,2,0,0,1,1,2,2,1,1,3,3,0,0,2,2,3,3,2,2,1,1,1,1,2,2,0,0,0,0,1,1,3,3,0,0,0,0,3,3,2,2,3,3,2,2,0,0,0,0,1,1,0,0,1,1,2,2,3,3,3,3,2,2,1,1,0,0,1,1,3,3,3,3,0,0,3,3,3,3,1,1,3,3,0,0,3,3,2,2,0,0,0,0,0,0,2,2,0,0,0,0,1,1,0,0,2,2,2,2,1,1,2,2,2,2,1,1,0,0,1,1,2,2,3,3,0,0,0,0,2,2,0,0,2,2,1,1,3,3,0,0,2,2,1,1,0,0,2,2,3,3,0,0,3,3,1,1,1,1,1,1,3,3,3,3,3,3,0,0,1,1,2,2,0,0,0,0,2,2,0,0,3,3,0,0,2,2,0,0,3,3,1,1,1,1,2,2,3,3,0,0,2,2,0,0,0,0,1,1,3,3,0,0,2,2,3,3,0,0,3,3,1,1,0,0,3,3,2,2,1,1,3,3,3,3,0,0,1,1,2,2,1,1,2,2,3,3,3,3,2,2,1,1,2,2,0,0,3,3,3,3,3,3,1,1,2,2,3,3,0,0,3,3,3,3,1,1,1,1,0,0,0,0,0,0,2,2,2,2,0,0,3,3,2,2,2,2,0,0,0,0,1,1,3,3,2,2,3,3,0,0,2,2,1,1,3,3,2,2,2,2,1,1,3,3,3,3,3,3,1,1,3,3,1,1,2,2,3,3,0,0,1,1,3,3,3,3,0,0,0,0,0,0,1,1,2,2,1,1,3,3,3,3,3,3,2,2,2,2,1,1,3,3,0,0,3,3,2,2,0,0,0,0,2,2,3,3,3,3,2,2,3,3,3,3,2,2,2,2,0,0,2,2,1,1,2,2,3,3,0,0,3,3,2,2,3,3,1,1,3,3,1,1,1,1,0,0,1,1,3,3,1,1,2,2,2,2,1,1,0,0,1,1,3,3,3,3,3,3,2,2,1,1,1,1,1,1,1,1,2,2,3,3,3,3,2,2,0,0,0,0,2,2,1,1,2,2,2,2,0,0,0,0,3,3,1,1,0,0,2,2,1,1,0,0,1,1,2,2,0,0,2,2,0,0,3,3,0,0,2,2,0,0,0,0,0,0,2,2,1,1,2,2,3,3,0,0,2,2,0,0,1,1,2,2,0,0,1,1,1,1,0,0,2,2,2,2,0,0,0,0,2,2,1,1,0,0,0,0,2,2,2,2,2,2,3,3,2,2,1,1,2,2,0,0,0,0,1,1,2,2,2,2,1,1,1,1,0,0,2,2,2,2,1,1,0,0,1,1,1,1,2,2,2,2,0,0,3,3,1,1,1,1,1,1,2,2,0,0,0,0,1,1,1,1,0,0,0,0,2,2,2,2,3,3,1,1,2,2,2,2,2,2,3,3,1,1,2,2,1,1,2,2,3,3,0,0,0,0,0,0,0,0,1,1,3,3,3,3,2,2,2,2,0,0,3,3,1,1,3,3,3,3,0,0,1,1,2,2,1,1,1,1,3,3,1,1,1,1,0,0,1,1,1,1,2,2,0,0,0,0,2,2,1,1,1,1,1,1,0,0,0,0,2,2,0,0,2,2,0,0,2,2,3,3,0,0,3,3,2,2,0,0,2,2,0,0,1,1,0,0,1,1,2,2,2,2,3,3,3,3,3,3,1,1,2,2,3,3,3,3,2,2,2,2,0,0,3,3,2,2,2,2,1,1,3,3,0,0,1,1,1,1,2,2,2,2,1,1,3,3,0,0,0,0,0,0,3,3,2,2,1,1,3,3,1,1,0,0,2,2,1,1,3,3,0,0,1,1,1,1,3,3,3,3,1,1,0,0,3,3,2,2,1,1,0,0,2,2,2,2,1,1,0,0,3,3,1,1,1,1,3,3,3,3,3,3,1,1,2,2,1,1,0,0,3,3,3,3,0,0,0,0,2,2,2,2,1,1,1,1,2,2,3,3,2,2,2,2,0,0,0,0,0,0,2,2,2,2,1,1,1,1,2,2,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,3,3,2,2,3,3,3,3,1,1,1,1,3,3,0,0,1,1,3,3,1,1,2,2,1,1,0,0,3,3,2,2,3,3,0,0,2,2,0,0,3,3,0,0,3,3,0,0,2,2,0,0,0,0,0,0,3,3,2,2,3,3,1,1,1,1,2,2,2,2,2,2,1,1,0,0,2,2,1,1,0,0,1,1,2,2,2,2,1,1,0,0,2,2,2,2,1,1,2,2,1,1,0,0,3,3,1,1,2,2,0,0,0,0,2,2,2,2,1,1,1,1,1,1,3,3,0,0,3,3,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,3,3,1,1,3,3,2,2,1,1,1,1,2,2,3,3,3,3,2,2,3,3,1,1,1,1,0,0,1,1,0,0,0,0,0,0,2,2,2,2,0,0,1,1,1,1,1,1,3,3,1,1,2,2,1,1,0,0,1,1,1,1,0,0,0,0,3,3,3,3,2,2,2,2,1,1,2,2,3,3,2,2,3,3,3,3,2,2,1,1,2,2,3,3,0,0,0,0,1,1,3,3,2,2,1,1,2,2,1,1,0,0,1,1,3,3,2,2,3,3,1,1,1,1,0,0,3,3,0,0,2,2,3,3,3,3,0,0,3,3,1,1,2,2,2,2,2,2,1,1,3,3,1,1,3,3,0,0,0,0,2,2,1,1,1,1,2,2,1,1,1,1,3,3,2,2,2,2,1,1,2,2,3,3,0,0,2,2,2,2,0,0,2,2,3,3,3,3,3,3,3,3,0,0,3,3,0,0,2,2,2,2,1,1,3,3,2,2,0,0,0,0,0,0,0,0,2,2,1,1,1,1,2,2,0,0,2,2,0,0,1,1,1,1,0,0,0,0,0,0,2,2,0,0,2,2,0,0,3,3,1,1,2,2,2,2,0,0,1,1,2,2,2,2,2,2,2,2,3,3,2,2,0,0,0,0,3,3,1,1,3,3,3,3,3,3,1,1,0,0,0,0,0,0,2,2,1,1,3,3,3,3,1,1,3,3,3,3,3,3,1,1,1,1,0,0,2,2,0,0,2,2,2,2,1,1,1,1,3,3,3,3,0,0,1,1,1,1,1,1,2,2,0,0,3,3,1,1,0,0,0,0,3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,1,2,2,1,1,1,1,0,0,0,0,3,3,3,3,2,2,2,2,3,3,3,3,1,1,2,2,2,2,0,0,0,0,1,1,2,2,2,2,3,3,2,2,0,0,3,3,3,3,3,3,1,1,3,3,2,2,1,1,2,2,2,2,1,1,3,3,1,1,3,3,0,0,1,1,0,0,3,3,2,2,1,1,0,0,2,2,2,2,2,2,1,1,3,3,0,0,3,3,2,2,3,3,3,3,0,0,3,3,1,1,3,3,1,1,2,2,1,1,2,2,1,1,1,1,3,3,0,0,0,0,2,2,3,3,2,2,0,0,0,0,1,1,0,0,3,3,0,0,1,1,0,0,2,2,0,0,1,1,2,2,1,1,1,1,2,2,0,0,2,2,2,2,1,1,3,3,2,2,0,0,3,3,2,2,0,0,0,0,3,3,2,2,0,0,0,0,0,0,3,3,2,2,0,0,0,0,2,2,1,1,1,1,0,0,0,0,2,2,3,3,0,0,2,2,1,1,2,2,1,1,1,1,1,1,0,0,1,1,0,0,1,1,3,3,0,0,0,0,0,0,3,3,2,2,1,1,3,3,3,3,2,2,2,2,3,3,0,0,2,2,3,3,2,2,1,1,2,2,1,1,2,2,0,0,1,1,2,2,0,0,1,1,0,0,2,2,1,1,1,1,2,2,3,3,0,0,1,1,0,0,2,2,0,0,3,3,0,0,3,3,3,3,3,3,0,0,1,1,1,1,2,2,0,0,0,0,3,3,2,2,2,2,2,2,2,2,0,0,1,1,3,3,0,0,1,1,2,2,0,0,2,2,3,3,0,0,0,0,2,2,2,2,0,0,0,0,3,3,3,3,2,2,0,0,2,2,0,0,1,1,1,1,0,0,3,3,0,0,0,0,3,3,0,0,2,2,0,0,0,0,3,3,0,0,0,0,3,3,1,1,1,1,3,3,2,2,1,1,0,0,1,1,2,2,0,0,3,3,2,2,2,2,2,2,2,2,1,1,3,3,1,1,0,0,0,0,0,0,0,0,2,2,0,0,1,1,0,0,1,1,2,2,0,0,0,0,3,3,1,1,1,1,3,3,2,2,1,1,1,1,2,2,1,1,2,2,0,0,1,1,2,2,1,1,3,3,0,0,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,2,1,1,3,3,3,3,2,2,2,2,0,0,0,0,0,0,2,2,0,0,0,0,2,2,3,3,3,3,0,0,0,0,3,3,2,2,3,3,1,1,2,2,1,1,2,2,1,1,3,3,2,2,0,0,1,1,3,3,3,3,2,2,2,2,0,0,0,0,3,3,1,1,2,2,1,1,3,3,3,3,1,1,3,3,3,3,0,0,0,0,3,3,1,1,1,1,3,3,2,2,0,0,3,3,3,3,3,3,3,3,1,1,3,3,0,0,2,2,0,0,2,2,0,0,2,2,0,0,0,0,2,2,1,1,2,2,0,0,1,1,3,3,0,0,1,1,0,0,1,1,3,3,1,1,0,0,3,3,3,3,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,3,3,1,1,0,0,3,3,0,0,1,1,3,3,1,1,3,3,0,0,1,1,2,2,1,1,3,3,1,1,3,3,1,1,3,3,0,0,3,3,3,3,0,0,2,2,0,0,0,0,2,2,0,0,2,2,1,1,0,0,0,0,3,3,3,3,0,0,2,2,1,1,0,0,2,2,0,0,2,2,2,2,0,0,1,1,0,0,1,1,2,2,0,0,3,3,0,0,0,0,0,0,1,1,2,2,3,3,3,3,1,1,2,2,3,3,2,2,0,0,2,2,1,1,0,0,2,2,1,1,3,3,1,1,1,1,2,2,1,1,3,3,2,2,1,1,2,2,1,1,3,3,3,3,0,0,1,1,1,1,2,2,0,0,3,3,3,3,0,0,0,0,0,0,3,3,1,1,1,1,1,1,2,2,0,0,1,1,3,3,2,2,3,3,1,1,2,2,3,3,3,3,2,2,3,3,1,1,3,3,0,0,0,0,1,1,0,0,3,3,1,1,0,0,1,1,0,0,3,3,1,1,3,3,0,0,0,0,3,3,2,2,0,0,1,1,3,3,0,0,3,3,1,1,1,1,0,0,1,1,0,0,0,0,2,2,0,0,1,1,3,3,2,2,0,0,1,1,1,1,3,3,2,2,3,3,3,3,2,2,3,3,3,3,0,0,0,0,0,0,3,3,0,0,1,1,0,0,0,0,0,0,3,3,3,3,2,2,3,3,1,1,1,1,3,3,2,2,2,2,3,3,1,1,2,2,0,0,2,2,2,2,3,3,2,2,2,2,3,3,2,2,0,0,0,0,1,1,3,3,1,1,1,1,3,3,2,2,3,3,2,2,2,2,0,0,0,0,2,2,2,2,0,0,3,3,1,1,2,2,2,2,1,1,3,3,2,2,3,3,1,1,1,1,2,2,1,1,0,0,0,0,3,3,3,3,1,1,2,2,1,1,2,2,3,3,0,0,1,1,1,1,1,1,1,1,1,1,3,3,0,0,2,2,2,2,1,1,3,3,3,3,1,1,0,0,3,3,2,2,0,0,0,0,2,2,2,2,3,3,3,3,0,0,0,0,2,2,2,2,1,1,1,1,0,0,3,3,0,0,2,2,3,3,2,2,2,2,0,0,3,3,0,0,0,0,0,0,3,3,0,0,2,2,3,3,0,0,0,0,3,3,3,3,0,0,1,1,3,3,3,3,2,2,0,0,1,1,0,0,3,3,0,0,1,1,0,0,3,3,2,2,0,0,0,0,1,1,1,1,1,1,2,2,2,2,0,0,0,0,2,2,1,1,1,1,1,1,2,2,2,2,1,1,0,0,3,3,3,3,1,1,0,0,2,2,0,0,0,0,0,0,1,1,2,2,0,0,2,2,2,2,3,3,2,2,3,3,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,0,0,1,1,1,1,2,2,3,3,2,2,0,0,2,2,3,3,3,3,0,0,3,3,2,2,1,1,3,3,1,1,0,0,2,2,2,2,2,2,3,3,2,2,2,2,1,1,1,1,0,0,3,3,3,3,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,3,3,1,1,2,2,2,2,1,1,1,1,0,0,3,3,1,1,1,1,1,1,0,0,3,3,1,1,1,1,0,0,2,2,2,2,0,0,3,3,1,1,2,2,2,2,2,2,1,1,0,0,1,1,3,3,3,3,1,1,1,1,3,3,1,1,1,1,2,2,3,3,3,3,0,0,1,1,1,1,3,3,2,2,1,1,0,0,3,3,1,1,0,0,3,3,0,0,2,2,0,0,2,2,0,0,0,0,3,3,1,1,1,1,3,3,3,3,2,2,0,0,2,2,2,2,0,0,2,2,2,2,0,0,3,3,0,0,3,3,2,2,0,0,1,1,3,3,3,3,1,1,0,0,0,0,0,0,2,2,1,1,0,0,2,2,3,3,0,0,1,1,3,3,0,0,2,2,1,1,0,0,3,3,0,0,2,2,1,1,2,2,3,3,0,0,2,2,0,0,1,1,1,1,2,2,0,0,0,0,2,2,0,0,3,3,1,1,2,2,1,1,2,2,2,2,0,0,3,3,1,1,2,2,0,0,3,3,0,0,2,2,3,3,0,0,0,0,0,0,3,3,1,1,2,2,2,2,3,3,0,0,1,1,0,0,2,2,0,0,0,0,1,1,0,0,3,3,3,3,3,3,0,0,2,2,2,2,2,2,0,0,3,3,0,0,0,0,3,3,0,0,1,1,1,1,0,0,2,2,2,2,2,2,2,2,0,0,3,3,1,1,3,3,3,3,2,2,0,0,0,0,2,2,3,3,0,0,1,1,1,1,3,3,0,0,3,3,3,3,2,2,0,0,3,3,0,0,2,2,3,3,1,1,3,3,0,0,3,3,0,0,1,1,0,0,2,2,1,1,0,0,0,0,2,2,3,3,3,3,2,2,0,0,3,3,2,2,0,0,0,0,1,1,3,3,3,3,1,1,2,2,0,0,2,2,1,1,3,3,2,2,0,0,3,3,1,1,2,2,0,0,3,3,0,0,0,0,2,2,2,2,0,0,1,1,2,2,3,3,0,0,3,3,3,3,0,0,3,3,2,2,1,1,0,0,0,0,3,3,0,0,3,3,0,0,0,0,2,2,0,0,3,3,0,0,1,1,2,2,0,0,1,1,0,0,2,2,1,1,1,1,1,1,0,0,0,0,2,2,3,3,0,0,2,2,0,0,1,1,3,3,2,2,3,3,0,0,2,2,2,2,3,3,0,0,0,0,0,0,0,0,3,3,1,1,3,3,2,2,3,3,3,3,2,2,3,3,0,0,3,3,0,0,0,0,0,0,0,0,0,0,2,2,0,0,2,2,0,0,0,0,3,3,2,2,1,1,0,0,1,1,3,3,3,3,2,2,2,2,1,1,1,1,3,3,2,2,2,2,1,1,3,3,3,3,2,2,3,3,2,2,1,1,1,1,3,3,0,0,0,0,2,2,0,0,1,1,3,3,3,3,2,2,0,0,3,3,0,0,3,3,0,0,3,3,0,0,0,0,3,3,1,1,1,1,0,0,2,2,3,3,3,3,0,0,1,1,3,3,0,0,2,2,1,1,1,1,0,0,3,3,0,0,0,0,1,1,2,2,1,1,1,1,0,0,0,0,1,1,3,3,3,3,2,2,3,3,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,3,3,0,0,2,2,2,2,1,1,0,0,0,0,1,1,3,3,0,0,3,3,1,1,0,0,3,3,0,0,2,2,0,0,2,2,0,0,2,2,1,1,3,3,2,2,3,3,2,2,3,3,2,2,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,2,2,1,1,0,0,0,0,1,1,0,0,2,2,0,0,2,2,2,2,1,1,3,3,2,2,2,2,0,0,3,3,3,3,3,3,2,2,1,1,3,3,1,1,3,3,2,2,0,0,2,2,3,3,1,1,2,2,0,0,3,3,0,0,2,2,1,1,1,1,2,2,0,0,0,0,2,2,2,2,0,0,1,1,2,2,2,2,0,0,1,1,3,3,0,0,3,3,0,0,0,0,3,3,3,3,1,1,3,3,0,0,1,1,1,1,3,3,3,3,3,3,2,2,0,0,1,1,0,0,0,0,2,2,0,0,3,3,0,0,0,0,0,0,2,2,1,1,1,1,0,0,2,2,2,2,2,2,2,2,1,1,1,1,2,2,2,2,1,1,3,3,0,0,2,2,2,2,2,2,1,1,0,0,2,2,0,0,2,2,2,2,1,1,0,0,2,2,1,1,1,1,3,3,3,3,0,0,1,1,3,3,3,3,3,3,1,1,3,3,2,2,0,0,0,0,3,3,3,3,3,3,0,0,1,1,3,3,0,0,2,2,0,0,2,2,1,1,2,2,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,2,2,3,3,3,3,0,0,1,1,0,0,0,0,0,0,3,3,2,2,0,0,0,0,0,0,2,2,2,2,3,3,3,3,2,2,0,0,0,0,3,3,2,2,1,1,0,0,0,0,3,3,2,2,0,0,3,3,0,0,2,2,2,2,1,1,0,0,0,0,1,1,0,0,0,0,1,1,3,3,3,3,0,0,1,1,1,1,3,3,0,0,2,2,3,3,1,1,3,3,2,2,0,0,2,2,2,2,2,2,0,0,1,1,0,0,3,3,0,0,1,1,3,3,0,0,0,0,0,0,0,0,1,1,1,1,3,3,2,2,0,0,1,1,1,1,2,2,3,3,2,2,2,2,1,1,1,1,2,2,1,1,3,3,1,1,2,2,0,0,3,3,1,1,3,3,2,2,1,1,0,0,2,2,0,0,1,1,3,3,1,1,2,2,0,0,1,1,3,3,1,1,2,2,3,3,2,2,3,3,0,0,3,3,2,2,1,1,0,0,2,2,1,1,3,3,0,0,2,2,0,0,0,0,3,3,0,0,1,1,3,3,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,0,0,1,1,2,2,0,0,0,0,3,3,3,3,3,3,3,3,0,0,2,2,0,0,3,3,2,2,0,0,2,2,0,0,0,0,3,3,1,1,2,2,2,2,1,1,1,1,1,1,1,1,2,2,0,0,1,1,3,3,2,2,3,3,0,0,3,3,1,1,2,2,3,3,1,1,0,0,3,3,0,0,3,3,2,2,2,2,0,0,1,1,3,3,0,0,1,1,2,2,1,1,1,1,0,0,0,0,3,3,2,2,2,2,0,0,0,0,0,0,3,3,1,1,0,0,1,1,3,3,0,0,0,0,3,3,3,3,0,0,3,3,2,2,3,3,3,3,0,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,1,1,0,0,2,2,1,1,2,2,1,1,3,3,3,3,0,0,1,1,0,0,2,2,0,0,0,0,3,3,2,2,2,2,2,2,3,3,0,0,0,0,1,1,2,2,0,0,1,1,0,0,3,3,3,3,3,3,0,0,1,1,3,3,3,3,2,2,1,1,3,3,1,1,2,2,3,3,2,2,2,2,2,2,0,0,3,3,2,2,0,0,1,1,3,3,1,1,2,2,2,2,2,2,3,3,1,1,2,2,3,3,2,2,3,3,2,2,3,3,1,1,0,0,3,3,0,0,3,3,1,1,0,0,3,3,2,2,0,0,3,3,1,1,1,1,0,0,0,0,0,0,0,0,0,0,2,2,0,0,1,1,3,3,3,3,1,1,3,3,0,0,1,1,2,2,1,1,1,1,1,1,2,2,3,3,0,0,1,1,0,0,1,1,1,1,3,3,1,1,0,0,1,1,2,2,0,0,3,3,2,2,2,2,1,1,0,0,1,1,2,2,0,0,3,3,1,1,1,1,0,0,0,0,3,3,1,1,0,0,2,2,0,0,1,1,1,1,1,1,2,2,1,1,3,3,3,3,0,0,0,0,1,1,2,2,0,0,1,1,0,0,2,2,0,0,1,1,3,3,1,1,2,2,0,0,2,2,3,3,1,1,0,0,1,1,3,3,0,0,2,2,3,3,3,3,3,3,1,1,3,3,3,3,2,2,2,2,3,3,1,1,0,0,3,3,3,3,3,3,0,0,2,2,1,1,2,2,3,3,0,0,0,0,2,2,0,0,2,2,2,2,3,3,1,1,2,2,2,2,1,1,0,0,0,0,2,2,1,1,2,2,2,2,1,1,1,1,2,2,0,0,2,2,3,3,1,1,0,0,2,2,0,0,3,3,2,2,3,3,3,3,1,1,2,2,2,2,3,3,3,3,1,1,0,0,1,1,2,2,3,3,0,0,0,0,1,1,2,2,3,3,3,3,1,1,1,1,0,0,2,2,0,0,3,3,0,0,2,2,3,3,2,2,1,1,0,0,1,1,2,2,1,1,3,3,3,3,3,3,3,3,3,3,1,1,0,0,1,1,1,1,2,2,0,0,3,3,0,0,3,3,2,2,3,3,3,3,1,1,0,0,2,2,0,0,2,2,1,1,1,1,3,3,3,3,1,1,3,3,3,3,2,2,1,1,0,0,1,1,0,0,2,2,2,2,3,3,0,0,2,2,0,0,1,1,3,3,1,1,0,0,0,0,2,2,3,3,2,2,2,2,1,1,1,1,2,2,0,0,3,3,2,2,3,3,1,1,1,1,1,1,3,3,0,0,0,0,2,2,1,1,2,2,2,2,1,1,3,3,0,0,2,2,0,0,1,1,1,1,2,2,2,2,1,1,1,1,3,3,3,3,3,3,2,2,1,1,3,3,0,0,2,2,0,0,2,2,2,2,0,0,3,3,1,1,0,0,3,3,2,2,1,1,2,2,2,2,0,0,2,2,2,2,1,1,0,0,2,2,2,2,2,2,1,1,2,2,3,3,3,3,0,0,3,3,1,1,1,1,3,3,1,1,2,2,2,2,3,3,2,2,1,1,1,1,3,3,3,3,2,2,2,2,3,3,0,0,1,1,3,3,3,3,2,2,2,2,1,1,3,3,0,0,1,1,1,1,3,3,2,2,1,1,1,1,0,0,2,2,2,2,2,2,1,1,1,1,1,1,3,3,2,2,3,3,2,2,0,0,1,1,2,2,1,1,3,3,0,0,1,1,1,1,1,1,2,2,0,0,0,0,0,0,1,1,1,1,0,0,1,1,2,2,0,0,0,0,0,0,2,2,2,2,1,1,3,3,1,1,0,0,3,3,3,3,3,3,0,0,3,3,2,2,1,1,2,2,2,2,2,2,1,1,1,1,0,0,3,3,1,1,0,0,1,1,0,0,0,0,3,3,2,2,0,0,1,1,0,0,2,2,1,1,3,3,1,1,1,1,2,2,2,2,0,0,1,1,3,3,1,1,2,2,3,3,0,0,3,3,0,0,2,2,0,0,1,1,1,1,2,2,2,2,3,3,2,2,0,0,2,2,1,1,2,2,0,0,3,3,3,3,2,2,0,0,1,1,3,3,0,0,1,1,3,3,2,2,1,1,3,3,3,3,3,3,2,2,3,3,2,2,0,0,1,1,2,2,0,0,0,0,3,3,0,0,0,0,2,2,1,1,3,3,2,2,1,1,3,3,1,1,1,1,0,0,0,0,3,3,3,3,0,0,1,1,1,1,0,0,1,1,1,1,2,2,2,2,2,2,3,3,1,1,0,0,1,1,3,3,3,3,0,0,2,2,1,1,2,2,2,2,0,0,1,1,3,3,0,0,1,1,0,0,3,3,3,3,2,2,0,0,1,1,1,1,1,1,3,3,2,2,0,0,0,0,3,3,1,1,0,0,2,2,3,3,2,2,3,3,1,1,3,3,0,0,3,3,2,2,2,2,3,3,3,3,2,2,1,1,0,0,2,2,2,2,2,2,2,2,3,3,0,0,2,2,2,2,3,3,0,0,3,3,0,0,3,3,3,3,2,2,1,1,1,1,3,3,1,1,0,0,3,3,0,0,3,3,1,1,1,1,2,2,2,2,2,2,1,1,1,1,2,2,3,3,3,3,0,0,0,0,2,2,3,3,2,2,2,2,0,0,2,2,2,2,2,2,0,0,2,2,1,1,2,2,2,2,0,0,2,2,0,0,0,0,2,2,0,0,3,3,1,1,1,1,2,2,0,0,1,1,2,2,0,0,2,2,0,0,0,0,1,1,2,2,0,0,2,2,1,1,3,3,0,0,2,2,3,3,1,1,2,2,2,2,1,1,1,1,3,3,0,0,0,0,0,0,3,3,2,2,2,2,1,1,3,3,2,2,3,3,1,1,2,2,0,0,2,2,2,2,0,0,0,0,3,3,1,1,1,1,1,1,1,1,3,3,0,0,2,2,0,0,0,0,2,2,2,2,1,1,1,1,1,1,1,1,3,3,0,0,3,3,0,0,3,3,3,3,0,0,2,2,3,3,2,2,0,0,2,2,2,2,1,1,1,1,0,0,3,3,1,1,1,1,0,0,3,3,1,1,3,3,0,0,1,1,1,1,3,3,3,3,2,2,0,0,3,3,0,0,2,2,1,1,0,0,1,1,0,0,2,2,1,1,2,2,3,3,3,3,2,2,1,1,1,1,0,0,2,2,3,3,0,0,3,3,3,3,3,3,3,3,1,1,3,3,3,3,1,1,2,2,2,2,2,2,2,2,2,2,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,0,0,1,1,2,2,0,0,2,2,2,2,0,0,0,0,2,2,3,3,0,0,0,0,1,1,3,3,0,0,2,2,2,2,0,0,2,2,3,3,3,3,0,0,2,2,0,0,1,1,2,2,1,1,2,2,1,1,2,2,2,2,3,3,2,2,3,3,1,1,1,1,2,2,1,1,1,1,0,0,2,2,0,0,2,2,3,3,0,0,0,0,0,0,0,0,0,0,2,2,3,3,0,0,0,0,0,0,0,0,2,2,3,3,0,0,2,2,3,3,2,2,0,0,0,0,2,2,0,0,0,0,2,2,3,3,0,0,3,3,1,1,1,1,3,3,0,0,1,1,0,0,2,2,0,0,3,3,2,2,1,1,3,3,0,0,3,3,2,2,1,1,2,2,3,3,1,1,1,1,0,0,3,3,2,2,1,1,0,0,2,2,0,0,3,3,3,3,0,0,2,2,0,0,0,0,1,1,3,3,0,0,0,0,1,1,2,2,1,1,2,2,3,3,1,1,2,2,3,3,0,0,0,0,1,1,2,2,1,1,1,1,0,0,2,2,1,1,1,1,3,3,0,0,1,1,0,0,0,0,3,3,1,1,3,3,3,3,1,1,1,1,3,3,2,2,3,3,1,1,1,1,1,1,3,3,1,1,3,3,0,0,1,1,3,3,0,0,1,1,0,0,0,0,0,0,3,3,2,2,3,3,3,3,2,2,0,0,3,3,0,0,3,3,2,2,3,3,2,2,3,3,1,1,2,2,3,3,2,2,3,3,0,0,2,2,2,2,0,0,1,1,0,0,2,2,0,0,0,0,3,3,0,0,0,0,3,3,0,0,2,2,1,1,2,2,2,2,0,0,1,1,1,1,3,3,1,1,0,0,3,3,2,2,3,3,0,0,1,1,2,2,3,3,0,0,2,2,3,3,3,3,0,0,2,2,1,1,2,2,0,0,1,1,3,3,0,0,1,1,1,1,2,2,2,2,3,3,3,3,0,0,1,1,1,1,0,0,0,0,2,2,3,3,0,0,3,3,2,2,3,3,0,0,1,1,3,3,0,0,1,1,1,1,0,0,3,3,1,1,3,3,3,3,3,3,2,2,2,2,1,1,2,2,1,1,3,3,1,1,0,0,2,2,3,3,2,2,1,1,1,1,3,3,2,2,1,1,2,2,3,3,1,1,2,2,2,2,0,0,2,2,2,2,1,1,1,1,0,0,1,1,2,2,3,3,2,2,3,3,2,2,0,0,0,0,2,2,1,1,1,1,0,0,0,0,3,3,3,3,0,0,1,1,2,2,3,3,0,0,1,1,1,1,1,1,2,2,0,0,3,3,2,2,3,3,2,2,2,2,3,3,3,3,1,1,0,0,1,1,3,3,2,2,3,3,3,3,2,2,2,2,1,1,2,2,0,0,3,3,0,0,0,0,1,1,1,1,0,0,1,1,1,1,3,3,3,3,2,2,3,3,0,0,2,2,2,2,0,0,1,1,3,3,2,2,0,0,2,2,2,2,0,0,1,1,0,0,2,2,0,0,2,2,0,0,2,2,0,0,1,1,3,3,3,3,3,3,1,1,3,3,0,0,2,2,0,0,3,3,3,3,0,0,3,3,1,1,3,3,1,1,2,2,0,0,1,1,2,2,1,1,2,2,1,1,1,1,2,2,0,0,3,3,3,3,2,2,3,3,0,0,2,2,2,2,0,0,0,0,3,3,1,1,1,1,3,3,3,3,1,1,2,2,2,2,0,0,2,2,2,2,3,3,2,2,3,3,1,1,0,0,2,2,1,1,1,1,0,0,3,3,0,0,0,0,0,0,0,0,0,0,2,2,3,3,0,0,0,0,3,3,1,1,3,3,0,0,1,1,3,3,2,2,0,0,2,2,2,2,3,3,2,2,0,0,3,3,3,3,2,2,2,2,2,2,3,3,0,0,3,3,1,1,1,1,1,1,0,0,0,0,3,3,1,1,3,3,1,1,3,3,3,3,3,3,3,3,2,2,0,0,0,0,0,0,0,0,0,0,2,2,1,1,0,0,1,1,0,0,0,0,2,2,1,1,2,2,2,2,0,0,1,1,2,2,0,0,0,0,3,3,3,3,2,2,1,1,0,0,2,2,2,2,1,1,2,2,3,3,3,3,1,1,0,0,2,2,2,2,0,0,0,0,2,2,0,0,0,0,1,1,3,3,0,0,2,2,1,1,1,1,1,1,0,0,0,0,2,2,3,3,2,2,2,2,2,2,0,0,1,1,2,2,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,1,1,2,2,2,2,1,1,2,2,2,2,0,0,2,2,1,1,0,0,0,0,1,1,0,0,2,2,0,0,1,1,3,3,0,0,0,0,2,2,0,0,0,0,0,0,0,0,3,3,0,0,3,3,1,1,3,3,3,3,0,0,2,2,0,0,3,3,2,2,0,0,2,2,1,1,2,2,2,2,3,3,2,2,2,2,2,2,2,2,2,2,3,3,1,1,1,1,1,1,0,0,2,2,1,1,2,2,3,3,0,0,0,0,1,1,3,3,3,3,1,1,1,1,0,0,0,0,3,3,2,2,3,3,0,0,2,2,2,2,2,2,1,1,0,0,3,3,2,2,0,0,2,2,0,0,1,1,1,1,0,0,3,3,1,1,3,3,0,0,3,3,0,0,1,1,0,0,1,1,3,3,2,2,1,1,2,2,1,1,3,3,3,3,1,1,1,1,1,1,1,1,0,0,3,3,3,3,2,2,3,3,0,0,0,0,0,0,1,1,2,2,2,2,0,0,2,2,2,2,0,0,2,2,1,1,2,2,2,2,0,0,0,0,0,0,0,0,2,2,1,1,2,2,3,3,1,1,2,2,0,0,3,3,2,2,2,2,2,2,0,0,0,0,3,3,2,2,3,3,3,3,0,0,1,1,2,2,0,0,3,3,1,1,2,2,3,3,0,0,0,0,0,0,0,0,3,3,3,3,1,1,1,1,0,0,3,3,1,1,0,0,3,3,3,3,1,1,1,1,0,0,3,3,0,0,1,1,2,2,1,1,2,2,0,0,3,3,0,0,0,0,2,2,2,2,3,3,0,0,1,1,3,3,0,0,3,3,0,0,0,0,1,1,3,3,0,0,0,0,1,1,0,0,1,1,2,2,3,3,2,2,3,3,2,2,2,2,1,1,3,3,2,2,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,2,2,1,1,1,1,2,2,2,2,2,2,2,2,3,3,1,1,0,0,0,0,0,0,0,0,2,2,1,1,2,2,1,1,0,0,1,1,1,1,2,2,2,2,3,3,0,0,3,3,2,2,0,0,2,2,2,2,2,2,0,0,2,2,2,2,2,2,0,0,0,0,1,1,1,1,1,1,2,2,3,3,0,0,0,0,1,1,1,1,2,2,1,1,0,0,3,3,2,2,2,2,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,3,3,1,1,0,0,1,1,1,1,1,1,0,0,3,3,0,0,1,1,1,1,3,3,2,2,0,0,1,1,1,1,3,3,3,3,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,2,2,1,1,3,3,2,2,1,1,2,2,2,2,0,0,1,1,1,1,2,2,1,1,0,0,2,2,3,3,0,0,1,1,0,0,1,1,1,1,2,2,1,1,0,0,3,3,2,2,3,3,0,0,1,1,0,0,0,0,1,1,2,2,1,1,1,1,0,0,3,3,2,2,3,3,2,2,2,2,0,0,0,0,2,2,3,3,1,1,1,1,0,0,3,3,0,0,2,2,2,2,0,0,1,1,0,0,0,0,2,2,2,2,0,0,3,3,0,0,2,2,3,3,3,3,0,0,0,0,2,2,1,1,2,2,0,0,2,2,0,0,0,0,1,1,2,2,0,0,1,1,1,1,1,1,1,1,3,3,3,3,2,2,1,1,3,3,0,0,3,3,0,0,3,3,0,0,0,0,0,0,2,2,1,1,0,0,2,2,2,2,2,2,0,0,1,1,3,3,2,2,2,2,2,2,0,0,3,3,3,3,2,2,2,2,0,0,2,2,3,3,0,0,0,0,0,0,0,0,1,1,1,1,0,0,2,2,0,0,2,2,2,2,0,0,3,3,2,2,2,2,3,3,3,3,1,1,1,1,1,1,0,0,0,0,3,3,2,2,1,1,2,2,0,0,3,3,1,1,2,2,1,1,3,3,1,1,0,0,1,1,1,1,3,3,2,2,0,0,1,1,3,3,3,3,0,0,1,1,2,2,2,2,2,2,1,1,3,3,2,2,0,0,3,3,2,2,1,1,2,2,1,1,0,0,0,0,3,3,0,0,1,1,2,2,3,3,2,2,3,3,0,0,2,2,2,2,1,1,3,3,1,1,2,2,2,2,1,1,2,2,0,0,0,0,0,0,1,1,2,2,2,2,0,0,0,0,2,2,0,0,1,1,2,2,0,0,2,2,2,2,3,3,1,1,2,2,3,3,0,0,2,2,3,3,3,3,0,0,2,2,1,1,1,1,0,0,1,1,3,3,3,3,1,1,3,3,0,0,1,1,0,0,0,0,2,2,0,0,3,3,0,0,1,1,1,1,0,0,0,0,3,3,2,2,1,1,1,1,0,0,2,2,1,1,2,2,2,2,2,2,2,2,0,0,2,2,0,0,2,2,1,1,0,0,0,0,1,1,3,3,2,2,3,3,0,0,0,0,0,0,3,3,1,1,0,0,2,2,3,3,3,3,1,1,0,0,0,0,0,0,1,1,1,1,1,1,2,2,1,1,3,3,0,0,1,1,2,2,0,0,0,0,2,2,1,1,3,3,1,1,3,3,1,1,0,0,0,0,1,1,0,0,0,0,0,0,3,3,2,2,0,0,3,3,0,0,3,3,1,1,3,3,3,3,0,0,0,0,0,0,3,3,1,1,3,3,1,1,2,2,0,0,1,1,3,3,3,3,1,1,0,0,2,2,0,0,2,2,2,2,0,0,3,3,2,2,0,0,1,1,1,1,3,3,3,3,2,2,0,0,1,1,2,2,3,3,2,2,2,2,0,0,3,3,1,1,0,0,2,2,0,0,0,0,0,0,0,0,2,2,1,1,0,0,2,2,3,3,3,3,3,3,3,3,1,1,2,2,3,3,1,1,3,3,0,0,0,0,1,1,3,3,2,2,3,3,1,1,0,0,0,0,2,2,3,3,2,2,0,0,3,3,0,0,0,0,1,1,0,0,3,3,3,3,3,3,3,3,3,3,1,1,1,1,0,0,2,2,0,0,2,2,3,3,1,1,2,2,0,0,3,3,3,3,2,2,1,1,0,0,2,2,3,3,0,0,1,1,0,0,2,2,0,0,3,3,2,2,3,3,2,2,3,3,2,2,2,2,0,0,3,3,0,0,3,3,1,1,0,0,2,2,1,1,3,3,0,0,3,3,2,2,1,1,3,3,2,2,0,0,2,2,0,0,3,3,3,3,3,3,2,2,3,3,0,0,3,3,2,2,0,0,0,0,2,2,0,0,0,0,0,0,2,2,1,1,1,1,0,0,2,2,2,2,3,3,3,3,2,2,1,1,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,2,2,3,3,1,1,0,0,2,2,2,2,0,0,2,2,3,3,3,3,3,3,0,0,3,3,1,1,3,3,3,3,0,0,0,0,2,2,0,0,2,2,2,2,3,3,1,1,1,1,1,1,2,2,3,3,3,3,2,2,1,1,3,3,0,0,2,2,0,0,3,3,0,0,2,2,0,0,0,0,3,3,0,0,0,0,2,2,2,2,2,2,3,3,2,2,0,0,0,0,0,0,3,3,2,2,0,0,1,1,3,3,0,0,1,1,2,2,2,2,2,2,0,0,3,3,1,1,1,1,0,0,3,3,2,2,1,1,1,1,1,1,1,1,1,1,2,2,3,3,2,2,0,0,2,2,1,1,2,2,1,1,0,0,1,1,0,0,3,3,2,2,2,2,2,2,1,1,1,1,2,2,2,2,2,2,3,3,2,2,3,3,1,1,1,1,3,3,3,3,3,3,1,1,3,3,1,1,3,3,2,2,1,1,2,2,0,0,3,3,0,0,1,1,2,2,0,0,2,2,3,3,2,2,2,2,1,1,2,2,3,3,1,1,3,3,1,1,2,2,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,3,3,0,0,3,3,0,0,1,1,2,2,3,3,0,0,3,3,2,2,3,3,1,1,3,3,3,3,0,0,3,3,3,3,1,1,1,1,2,2,0,0,2,2,1,1,0,0,0,0,3,3,1,1,3,3,3,3,2,2,0,0,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,0,0,0,0,3,3,3,3,1,1,1,1,0,0,0,0,3,3,3,3,3,3,1,1,3,3,0,0,1,1,2,2,1,1,3,3,1,1,3,3,0,0,3,3,2,2,1,1,2,2,3,3,2,2,2,2,2,2,2,2,3,3,3,3,1,1,1,1,2,2,1,1,3,3,3,3,2,2,0,0,0,0,1,1,1,1,2,2,2,2,0,0,3,3,0,0,1,1,3,3,0,0,1,1,0,0,0,0,1,1,0,0,3,3,3,3,3,3,1,1,2,2,3,3,3,3,0,0,1,1,3,3,1,1,0,0,2,2,2,2,0,0,1,1,1,1,1,1,3,3,1,1,2,2,2,2,2,2,1,1,0,0,2,2,1,1,1,1,3,3,3,3,0,0,0,0,2,2,2,2,0,0,1,1,2,2,0,0,2,2,3,3,0,0,1,1,2,2,3,3,2,2,2,2,0,0,2,2,3,3,1,1,1,1,2,2,2,2,3,3,2,2,0,0,3,3,0,0,0,0,0,0,2,2,2,2,1,1,3,3,3,3,0,0,0,0,2,2,2,2,3,3,1,1,0,0,2,2,3,3,3,3,3,3,1,1,0,0,1,1,0,0,2,2,3,3,3,3,0,0,2,2,1,1,0,0,0,0,3,3,2,2,3,3,0,0,2,2,0,0,0,0,1,1,1,1,2,2,1,1,0,0,0,0,3,3,2,2,2,2,2,2,1,1,3,3,0,0,2,2,3,3,2,2,0,0,2,2,0,0,2,2,0,0,2,2,0,0,3,3,0,0,0,0,1,1,0,0,0,0,1,1,2,2,2,2,1,1,1,1,0,0,3,3,0,0,0,0,1,1,1,1,3,3,1,1,2,2,1,1,3,3,2,2,1,1,1,1,0,0,0,0,0,0,2,2,2,2,0,0,0,0,2,2,1,1,2,2,2,2,0,0,3,3,2,2,0,0,3,3,0,0,1,1,2,2,1,1,1,1,3,3,3,3,3,3,1,1,2,2,2,2,0,0,0,0,0,0,0,0,2,2,0,0,2,2,0,0,0,0,1,1,2,2,1,1,1,1,0,0,2,2,0,0,3,3,0,0,1,1,2,2,0,0,0,0,0,0,2,2,1,1,1,1,0,0,3,3,2,2,1,1,2,2,3,3,3,3,3,3,0,0,0,0,3,3,1,1,2,2,2,2,1,1,3,3,2,2,2,2,1,1,3,3,0,0,1,1,3,3,0,0,0,0,3,3,3,3,1,1,1,1,0,0,3,3,1,1,1,1,2,2,2,2,3,3,3,3,3,3,3,3,0,0,0,0,3,3,0,0,0,0,0,0,2,2,1,1,2,2,2,2,0,0,3,3,0,0,0,0,2,2,3,3,1,1,1,1,1,1,2,2,0,0,3,3,0,0,2,2,0,0,3,3,3,3,1,1,1,1,3,3,1,1,1,1,0,0,0,0,2,2,1,1,1,1,2,2,3,3,1,1,3,3,0,0,2,2,0,0,3,3,0,0,2,2,0,0,1,1,0,0,0,0,0,0,3,3,0,0,0,0,1,1,2,2,1,1,3,3,0,0,1,1,3,3,2,2,3,3,2,2,1,1,1,1,3,3,2,2,3,3,3,3,1,1,1,1,2,2,2,2,0,0,3,3,1,1,2,2,3,3,2,2,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,3,3,2,2,0,0,3,3,3,3,1,1,3,3,2,2,1,1,3,3,2,2,1,1,3,3,3,3,1,1,3,3,2,2,2,2,0,0,3,3,1,1,1,1,3,3,1,1,0,0,3,3,2,2,0,0,2,2,3,3,2,2,2,2,1,1,3,3,0,0,0,0,1,1,0,0,0,0,3,3,2,2,3,3,2,2,1,1,3,3,1,1,1,1,2,2,2,2,3,3,0,0,0,0,3,3,3,3,1,1,3,3,0,0,0,0,3,3,1,1,3,3,0,0,3,3,0,0,3,3,1,1,0,0,2,2,1,1,0,0,3,3,0,0,3,3,1,1,3,3,1,1,0,0,2,2,0,0,2,2,1,1,0,0,0,0,1,1,1,1,0,0,2,2,2,2,2,2,1,1,1,1,3,3,2,2,3,3,1,1,3,3,1,1,3,3,3,3,2,2,3,3,1,1,0,0,2,2,3,3,1,1,0,0,3,3,2,2,2,2,2,2,1,1,0,0,0,0,0,0,2,2,0,0,1,1,0,0,0,0,3,3,1,1,0,0,2,2,1,1,1,1,0,0,1,1,2,2,0,0,3,3,1,1,0,0,3,3,2,2,0,0,0,0,3,3,1,1,3,3,1,1,0,0,3,3,2,2,3,3,0,0,2,2,2,2,1,1,0,0,1,1,1,1,0,0,0,0,3,3,2,2,3,3,0,0,2,2,2,2,3,3,0,0,2,2,0,0,2,2,3,3,0,0,2,2,0,0,1,1,1,1,2,2,0,0,2,2,3,3,2,2,0,0,1,1,3,3,1,1,2,2,2,2,1,1,3,3,0,0,3,3,1,1,2,2,1,1,2,2,1,1,2,2,2,2,3,3,2,2,3,3,3,3,2,2,2,2,3,3,0,0,2,2,3,3,3,3,0,0,3,3,0,0,0,0,1,1,2,2,0,0,2,2,0,0,3,3,2,2,1,1,3,3,1,1,1,1,3,3,0,0,3,3,1,1,0,0,3,3,1,1,2,2,2,2,3,3,0,0,2,2,2,2,3,3,0,0,3,3,3,3,1,1,1,1,0,0,3,3,3,3,0,0,3,3,0,0,1,1,2,2,0,0,1,1,1,1,3,3,1,1,1,1,3,3,1,1,0,0,3,3,0,0,3,3,2,2,3,3,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,2,2,3,3,3,3,3,3,2,2,2,2,2,2,2,2,3,3,3,3,3,3,0,0,0,0,0,0,1,1,0,0,2,2,0,0,1,1,3,3,0,0,1,1,1,1,3,3,2,2,3,3,3,3,3,3,3,3,3,3,0,0,3,3,0,0,1,1,2,2,2,2,3,3,1,1,0,0,1,1,2,2,2,2,3,3,1,1,0,0,0,0,1,1,2,2,0,0,2,2,3,3,3,3,3,3,2,2,2,2,2,2,0,0,2,2,3,3,3,3,1,1,1,1,1,1,2,2,3,3,0,0,0,0,3,3,1,1,1,1,1,1,0,0,2,2,0,0,0,0,1,1,0,0,0,0,1,1,0,0,2,2,3,3,1,1,1,1,0,0,0,0,0,0,2,2,0,0,2,2,3,3,1,1,0,0,3,3,2,2,2,2,3,3,1,1,3,3,1,1,2,2,0,0,3,3,3,3,3,3,2,2,3,3,1,1,0,0,0,0,0,0,0,0,1,1,1,1,2,2,3,3,2,2,0,0,0,0,1,1,0,0,2,2,1,1,3,3,0,0,1,1,1,1,2,2,1,1,0,0,0,0,1,1,1,1,3,3,1,1,3,3,0,0,2,2,0,0,1,1,0,0,3,3,1,1,2,2,2,2,0,0,0,0,0,0,1,1,2,2,1,1,1,1,2,2,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,2,2,3,3,2,2,0,0,3,3,3,3,3,3,0,0,1,1,2,2,2,2,1,1,0,0,3,3,2,2,2,2,1,1,0,0,3,3,1,1,3,3,0,0,1,1,0,0,0,0,0,0,2,2,1,1,0,0,3,3,3,3,3,3,1,1,1,1,1,1,3,3,2,2,1,1,0,0,1,1,3,3,0,0,2,2,0,0,2,2,3,3,3,3,0,0,2,2,1,1,0,0,1,1,2,2,0,0,2,2,2,2,1,1,2,2,2,2,3,3,2,2,2,2,2,2,0,0,0,0,0,0,1,1,3,3,0,0,0,0,1,1,0,0,0,0,3,3,3,3,2,2,0,0,0,0,1,1,3,3,1,1,3,3,2,2,1,1,3,3,2,2,0,0,0,0,1,1,2,2,0,0,2,2,1,1,1,1,1,1,1,1,0,0,1,1,2,2,2,2,0,0,1,1,3,3,2,2,3,3,2,2,2,2,0,0,3,3,1,1,3,3,2,2,2,2,3,3,0,0,2,2,1,1,1,1,2,2,2,2,0,0,2,2,0,0,2,2,0,0,1,1,2,2,0,0,0,0,1,1,3,3,0,0,0,0,2,2,3,3,1,1,1,1,3,3,3,3,0,0,2,2,1,1,2,2,1,1,3,3,1,1,1,1,2,2,2,2,3,3,2,2,0,0,1,1,3,3,1,1,0,0,0,0,3,3,1,1,3,3,1,1,2,2,3,3,2,2,1,1,0,0,1,1,0,0,0,0,3,3,3,3,0,0,0,0,3,3,1,1,2,2,1,1,1,1,0,0,2,2,3,3,0,0,3,3,1,1,3,3,0,0,0,0,3,3,3,3,0,0,0,0,3,3,2,2,3,3,1,1,0,0,1,1,1,1,3,3,0,0,1,1,1,1,1,1,1,1,1,1,2,2,1,1,0,0,0,0,0,0,3,3,1,1,0,0,1,1,3,3,0,0,1,1,2,2,1,1,1,1,1,1,1,1,3,3,1,1,2,2,1,1,2,2,0,0,0,0,1,1,0,0,1,1,0,0,1,1,3,3,1,1,1,1,3,3,3,3,0,0,0,0,2,2,1,1,1,1,0,0,1,1,3,3,0,0,3,3,0,0,2,2,3,3,3,3,0,0,1,1,2,2,1,1,2,2,0,0,0,0,2,2,3,3,2,2,3,3,2,2,2,2,2,2,0,0,1,1,1,1,3,3,2,2,2,2,1,1,0,0,3,3,1,1,0,0,1,1,2,2,1,1,3,3,0,0,1,1,1,1,1,1,2,2,1,1,3,3,1,1,1,1,2,2,1,1,3,3,2,2,3,3,1,1,1,1,0,0,3,3,0,0,1,1,0,0,0,0,3,3,3,3,2,2,2,2,2,2,0,0,3,3,1,1,2,2,1,1,3,3,3,3,1,1,3,3,0,0,0,0,3,3,2,2,2,2,2,2,2,2,0,0,2,2,0,0,0,0,2,2,2,2,0,0,1,1,2,2,1,1,0,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,2,2,3,3,0,0,3,3,3,3,0,0,2,2,3,3,1,1,1,1,2,2,1,1,3,3,3,3,3,3,2,2,2,2,2,2,0,0,1,1,1,1,3,3,1,1,3,3,2,2,2,2,2,2,1,1,1,1,3,3,0,0,0,0,0,0,3,3,2,2,0,0,2,2,0,0,0,0,3,3,2,2,1,1,2,2,1,1,2,2,3,3,2,2,3,3,2,2,0,0,0,0,2,2,3,3,1,1,0,0,1,1,0,0,1,1,3,3,2,2,0,0,0,0,3,3,3,3,0,0,1,1,0,0,2,2,2,2,3,3,0,0,0,0,2,2,0,0,3,3,3,3,2,2,3,3,3,3,1,1,1,1,1,1,0,0,3,3,1,1,3,3,3,3,0,0,0,0,3,3,0,0,1,1,0,0,3,3,2,2,1,1,1,1,2,2,0,0,2,2,2,2,3,3,0,0,0,0,3,3,1,1,0,0,2,2,0,0,1,1,2,2,0,0,0,0,0,0,0,0,0,0,3,3,2,2,3,3,0,0,3,3,2,2,2,2,0,0,2,2,3,3,2,2,2,2,0,0,0,0,1,1,2,2,2,2,2,2,2,2,1,1,0,0,1,1,1,1,2,2,2,2,1,1,0,0,0,0,2,2,1,1,2,2,2,2,3,3,1,1,0,0,0,0,1,1,0,0,3,3,0,0,0,0,2,2,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,2,2,0,0,1,1,0,0,1,1,2,2,1,1,3,3,1,1,1,1,0,0,3,3,2,2,3,3,3,3,0,0,2,2,3,3,1,1,0,0,2,2,0,0,2,2,1,1,2,2,2,2,1,1,0,0,2,2,0,0,3,3,1,1,1,1,1,1,1,1,0,0,0,0,3,3,2,2,3,3,2,2,0,0,1,1,0,0,0,0,0,0,2,2,0,0,1,1,3,3,0,0,0,0,2,2,3,3,1,1,3,3,3,3,1,1,0,0,3,3,3,3,2,2,1,1,2,2,0,0,1,1,0,0,2,2,3,3,2,2,0,0,3,3,0,0,3,3,1,1,0,0,0,0,1,1,0,0,2,2,0,0,2,2,2,2,0,0,1,1,2,2,3,3,3,3,1,1,2,2,1,1,2,2,2,2,0,0,1,1,3,3,0,0,1,1,1,1,3,3,2,2,1,1,3,3,2,2,3,3,1,1,0,0,2,2,0,0,3,3,3,3,0,0,3,3,3,3,2,2,0,0,3,3,2,2,1,1,0,0,0,0,0,0,2,2,2,2,1,1,0,0,0,0,1,1,2,2,0,0,0,0,3,3,3,3,1,1,1,1,3,3,0,0,1,1,2,2,0,0,1,1,2,2,0,0,2,2,1,1,3,3,1,1,2,2,2,2,2,2,0,0,1,1,0,0,1,1,0,0,2,2,2,2,1,1,0,0,2,2,2,2,2,2,0,0,1,1,0,0,3,3,0,0,1,1,3,3,2,2,2,2,1,1,0,0,2,2,0,0,3,3,1,1,0,0,3,3,1,1,1,1,3,3,1,1,0,0,2,2,1,1,3,3,0,0,0,0,2,2,0,0,3,3,0,0,1,1,2,2,1,1,0,0,3,3,0,0,0,0,2,2,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,3,3,1,1,3,3,0,0,1,1,0,0,2,2,3,3,2,2,3,3,3,3,0,0,1,1,1,1,0,0,3,3,2,2,1,1,2,2,1,1,1,1,3,3,1,1,0,0,1,1,2,2,3,3,1,1,3,3,2,2,2,2,0,0,3,3,3,3,3,3,1,1,0,0,0,0,3,3,3,3,2,2,1,1,2,2,1,1,1,1,0,0,3,3,0,0,0,0,2,2,0,0,3,3,1,1,0,0,0,0,1,1,3,3,3,3,0,0,1,1,3,3,2,2,0,0,3,3,1,1,1,1,1,1,0,0,1,1,3,3,3,3,1,1,1,1,2,2,2,2,2,2,3,3,0,0,2,2,0,0,0,0,1,1,2,2,3,3,3,3,2,2,2,2,1,1,1,1,1,1,3,3,3,3,2,2,2,2,1,1,3,3,3,3,0,0,1,1,1,1,0,0,2,2,0,0,2,2,0,0,1,1,2,2,3,3,1,1,2,2,2,2,1,1,2,2,0,0,0,0,3,3,3,3,0,0,3,3,0,0,1,1,0,0,1,1,0,0,2,2,1,1,3,3,0,0,1,1,0,0,1,1,1,1,3,3,0,0,0,0,3,3,0,0,1,1,3,3,0,0,3,3,1,1,3,3,2,2,2,2,2,2,0,0,3,3,1,1,3,3,2,2,2,2,0,0,2,2,1,1,2,2,0,0,3,3,3,3,0,0,0,0,2,2,2,2,2,2,1,1,3,3,3,3,1,1,3,3,0,0,3,3,3,3,0,0,3,3,3,3,3,3,2,2,1,1,0,0,0,0,0,0,0,0,0,0,2,2,0,0,1,1,1,1,0,0,1,1,3,3,0,0,1,1,1,1,2,2,2,2,1,1,3,3,0,0,0,0,2,2,2,2,0,0,0,0,2,2,1,1,0,0,2,2,3,3,3,3,0,0,2,2,3,3,3,3,1,1,2,2,3,3,0,0,0,0,2,2,1,1,3,3,3,3,0,0,2,2,2,2,3,3,1,1,3,3,1,1,0,0,3,3,0,0,1,1,1,1,2,2,2,2,3,3,3,3,1,1,2,2,2,2,0,0,3,3,2,2,3,3,0,0,0,0,0,0,0,0,3,3,2,2,0,0,0,0,3,3,3,3,2,2,0,0,2,2,1,1,2,2,1,1,2,2,0,0,1,1,0,0,1,1,0,0,0,0,3,3,2,2,0,0,1,1,2,2,1,1,2,2,1,1,0,0,2,2,2,2,0,0,0,0,1,1,2,2,1,1,2,2,2,2,3,3,0,0,3,3,0,0,3,3,0,0,1,1,1,1,0,0,3,3,0,0,0,0,1,1,2,2,1,1,0,0,2,2,2,2,0,0,3,3,0,0,2,2,3,3,0,0,0,0,1,1,0,0,3,3,2,2,2,2,1,1,1,1,0,0,2,2,0,0,3,3,0,0,0,0,2,2,1,1,1,1,0,0,1,1,3,3,2,2,3,3,1,1,2,2,0,0,3,3,0,0,2,2,2,2,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,2,2,1,1,3,3,0,0,1,1,0,0,0,0,2,2,3,3,0,0,2,2,3,3,1,1,1,1,1,1,1,1,2,2,2,2,1,1,3,3,0,0,3,3,2,2,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,2,2,2,2,1,1,3,3,2,2,1,1,2,2,0,0,0,0,0,0,0,0,1,1,3,3,3,3,2,2,0,0,0,0,3,3,3,3,1,1,1,1,0,0,0,0,2,2,0,0,2,2,0,0,3,3,0,0,1,1,0,0,1,1,0,0,3,3,0,0,2,2,1,1,1,1,3,3,2,2,3,3,0,0,0,0,1,1,1,1,0,0,2,2,0,0,0,0,2,2,3,3,2,2,1,1,3,3,1,1,0,0,1,1,3,3,3,3,2,2,1,1,2,2,2,2,1,1,1,1,0,0,2,2,0,0,2,2,0,0,3,3,0,0,3,3,1,1,0,0,2,2,3,3,1,1,1,1,2,2,0,0,2,2,2,2,3,3,3,3,3,3,3,3,2,2,0,0,0,0,0,0,3,3,3,3,0,0,0,0,3,3,3,3,3,3,2,2,0,0,1,1,1,1,1,1,2,2,2,2,3,3,3,3,2,2,0,0,0,0,3,3,3,3,3,3,2,2,2,2,1,1,2,2,0,0,1,1,1,1,1,1,0,0,2,2,0,0,2,2,1,1,0,0,1,1,2,2,3,3,1,1,0,0,2,2,2,2,0,0,0,0,1,1,0,0,2,2,0,0,2,2,1,1,3,3,0,0,2,2,3,3,2,2,1,1,2,2,3,3,0,0,3,3,1,1,0,0,1,1,1,1,1,1,3,3,0,0,2,2,1,1,3,3,0,0,1,1,1,1,1,1,0,0,1,1,3,3,2,2,0,0,0,0,1,1,2,2,3,3,3,3,3,3,2,2,0,0,1,1,2,2,3,3,1,1,1,1,0,0,1,1,0,0,2,2,2,2,0,0,3,3,1,1,2,2,1,1,1,1,0,0,2,2,1,1,2,2,2,2,2,2,2,2,2,2,3,3,0,0,0,0,3,3,3,3,2,2,1,1,0,0,1,1,0,0,2,2,2,2,2,2,0,0,2,2,0,0,2,2,3,3,0,0,1,1,1,1,2,2,0,0,0,0,2,2,3,3,0,0,2,2,2,2,2,2,0,0,0,0,1,1,0,0,3,3,1,1,2,2,0,0,1,1,0,0,1,1,0,0,2,2,2,2,0,0,1,1,1,1,2,2,3,3,1,1,0,0,0,0,3,3,0,0,0,0,3,3,2,2,2,2,2,2,0,0,0,0,3,3,0,0,0,0,2,2,0,0,3,3,1,1,1,1,3,3,2,2,0,0,1,1,1,1,3,3,1,1,1,1,0,0,0,0,3,3,3,3,1,1,1,1,0,0,1,1,2,2,3,3,2,2,1,1,1,1,1,1,0,0,0,0,3,3,2,2,1,1,1,1,0,0,1,1,0,0,3,3,1,1,0,0,0,0,0,0,1,1,3,3,2,2,1,1,1,1,0,0,0,0,2,2,0,0,0,0,3,3,1,1,1,1,0,0,1,1,3,3,1,1,3,3,2,2,3,3,1,1,2,2,0,0,3,3,3,3,0,0,1,1,0,0,3,3,2,2,2,2,2,2,1,1,0,0,0,0,3,3,2,2,1,1,0,0,0,0,3,3,2,2,1,1,1,1,3,3,3,3,0,0,0,0,3,3,2,2,1,1,0,0,1,1,1,1,1,1,1,1,3,3,2,2,1,1,0,0,0,0,3,3,3,3,3,3,0,0,3,3,0,0,0,0,2,2,3,3,0,0,3,3,1,1,3,3,0,0,1,1,3,3,3,3,0,0,0,0,0,0,3,3,1,1,3,3,2,2,3,3,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,3,3,2,2,3,3,0,0,0,0,0,0,0,0,1,1,2,2,2,2,1,1,1,1,2,2,3,3,3,3,2,2,2,2,1,1,1,1,3,3,0,0,2,2,2,2,2,2,1,1,0,0,2,2,3,3,3,3,2,2,2,2,3,3,2,2,3,3,1,1,2,2,1,1,0,0,2,2,1,1,3,3,1,1,0,0,0,0,0,0,1,1,3,3,0,0,2,2,3,3,2,2,1,1,3,3,0,0,3,3,2,2,1,1,2,2,1,1,2,2,1,1,2,2,3,3,1,1,3,3,3,3,2,2,0,0,1,1,0,0,3,3,2,2,1,1,1,1,3,3,0,0,3,3,1,1,0,0,0,0,0,0,1,1,3,3,1,1,2,2,0,0,3,3,1,1,1,1,1,1,0,0,3,3,3,3,0,0,3,3,0,0,1,1,0,0,2,2,2,2,1,1,2,2,0,0,0,0,1,1,0,0,0,0,3,3,1,1,0,0,0,0,1,1,1,1,0,0,3,3,0,0,1,1,0,0,1,1,1,1,0,0,3,3,2,2,2,2,0,0,2,2,2,2,3,3,0,0,0,0,2,2,2,2,1,1,3,3,0,0,1,1,3,3,1,1,2,2,1,1,0,0,1,1,2,2,1,1,3,3,0,0,3,3,0,0,0,0,1,1,1,1,2,2,3,3,2,2,3,3,0,0,3,3,1,1,2,2,0,0,2,2,1,1,1,1,1,1,2,2,2,2,2,2,2,2,0,0,3,3,1,1,2,2,2,2,1,1,0,0,2,2,0,0,1,1,1,1,3,3,2,2,0,0,3,3,0,0,2,2,1,1,2,2,0,0,1,1,3,3,1,1,1,1,2,2,0,0,3,3,2,2,1,1,2,2,2,2,1,1,2,2,2,2,0,0,0,0,2,2,1,1,1,1,0,0,1,1,2,2,2,2,1,1,1,1,2,2,3,3,2,2,2,2,3,3,1,1,0,0,2,2,2,2,0,0,0,0,3,3,2,2,3,3,0,0,3,3,2,2,3,3,2,2,0,0,2,2,2,2,0,0,1,1,3,3,3,3,0,0,0,0,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,3,3,1,1,0,0,1,1,3,3,0,0,0,0,2,2,2,2,0,0,0,0,1,1,0,0,1,1,3,3,3,3,0,0,0,0,0,0,0,0,0,0,2,2,0,0,3,3,3,3,1,1,1,1,0,0,0,0,1,1,1,1,3,3,2,2,3,3,2,2,1,1,3,3,1,1,2,2,3,3,0,0,0,0,1,1,3,3,1,1,0,0,2,2,2,2,2,2,1,1,3,3,2,2,2,2,3,3,2,2,2,2,3,3,0,0,3,3,0,0,1,1,2,2,1,1,2,2,1,1,3,3,3,3,1,1,3,3,1,1,1,1,2,2,1,1,0,0,0,0,3,3,2,2,2,2,0,0,0,0,3,3,2,2,3,3,2,2,1,1,0,0,0,0,0,0,0,0,1,1,0,0,2,2,0,0,0,0,2,2,3,3,0,0,2,2,1,1,2,2,2,2,3,3,0,0,0,0,2,2,1,1,3,3,2,2,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,1,1,3,3,0,0,2,2,2,2,3,3,0,0,0,0,1,1,2,2,3,3,0,0,2,2,1,1,3,3,1,1,2,2,0,0,0,0,3,3,2,2,1,1,1,1,0,0,1,1,0,0,3,3,1,1,1,1,0,0,3,3,2,2,0,0,0,0,3,3,0,0,3,3,2,2,1,1,0,0,1,1,1,1,3,3,3,3,2,2,0,0,0,0,2,2,1,1,2,2,1,1,1,1,3,3,0,0,3,3,1,1,0,0,2,2,2,2,1,1,2,2,1,1,2,2,2,2,1,1,0,0,1,1,2,2,0,0,1,1,0,0,0,0,0,0,3,3,2,2,2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0,3,3,3,3,2,2,2,2,3,3,3,3,3,3,1,1,3,3,3,3,0,0,1,1,3,3,0,0,2,2,2,2,3,3,1,1,0,0,2,2,1,1,0,0,0,0,1,1,1,1,3,3,3,3,0,0,0,0,3,3,1,1,0,0,1,1,3,3,1,1,3,3,1,1,2,2,1,1,0,0,2,2,1,1,1,1,0,0,1,1,2,2,2,2,2,2,1,1,2,2,1,1,2,2,1,1,1,1,2,2,3,3,0,0,2,2,2,2,2,2,2,2,0,0,2,2,1,1,0,0,1,1,0,0,1,1,3,3,3,3,1,1,2,2,2,2,0,0,0,0,3,3,2,2,3,3,1,1,0,0,3,3,1,1,0,0,0,0,0,0,0,0,0,0,2,2,0,0,3,3,1,1,1,1,1,1,0,0,0,0,3,3,1,1,0,0,0,0,0,0,0,0,1,1,0,0,2,2,0,0,3,3,0,0,2,2,3,3,0,0,0,0,0,0,2,2,0,0,3,3,3,3,1,1,3,3,2,2,1,1,1,1,2,2,2,2,0,0,0,0,2,2,1,1,1,1,2,2,1,1,0,0,1,1,1,1,2,2,0,0,2,2,3,3,1,1,2,2,3,3,3,3,1,1,0,0,1,1,0,0,2,2,3,3,1,1,3,3,0,0,0,0,1,1,0,0,2,2,0,0,1,1,1,1,2,2,2,2,1,1,0,0,1,1,0,0,1,1,3,3,0,0,0,0,1,1,1,1,0,0,2,2,0,0,3,3,0,0,3,3,1,1,1,1,3,3,3,3,0,0,0,0,1,1,2,2,0,0,2,2,1,1,3,3,3,3,0,0,3,3,0,0,2,2,3,3,2,2,1,1,3,3,0,0,3,3,3,3,1,1,1,1,0,0,3,3,3,3,2,2,2,2,0,0,3,3,1,1,3,3,2,2,1,1,2,2,0,0,0,0,0,0,3,3,0,0,2,2,0,0,3,3,3,3,0,0,2,2,2,2,3,3,0,0,1,1,2,2,1,1,0,0,3,3,0,0,1,1,2,2,2,2,0,0,1,1,2,2,1,1,1,1,3,3,2,2,1,1,3,3,1,1,0,0,0,0,1,1,0,0,3,3,1,1,2,2,3,3,2,2,1,1,0,0,3,3,1,1,2,2,0,0,2,2,3,3,0,0,1,1,2,2,2,2,3,3,2,2,1,1,2,2,0,0,0,0,2,2,3,3,1,1,0,0,1,1,2,2,1,1,2,2,2,2,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,3,3,0,0,0,0,0,0,2,2,2,2,1,1,2,2,1,1,3,3,3,3,0,0,1,1,2,2,2,2,0,0,3,3,1,1,3,3,2,2,0,0,3,3,1,1,2,2,2,2,1,1,0,0,2,2,3,3,3,3,1,1,3,3,0,0,3,3,0,0,1,1,3,3,3,3,2,2,3,3,2,2,3,3,1,1,1,1,0,0,3,3,2,2,2,2,2,2,3,3,1,1,2,2,1,1,3,3,3,3,1,1,0,0,3,3,1,1,3,3,1,1,0,0,3,3,0,0,0,0,3,3,3,3,1,1,1,1,3,3,0,0,1,1,2,2,0,0,1,1,3,3,0,0,3,3,1,1,0,0,3,3,0,0,2,2,2,2,3,3,0,0,2,2,2,2,3,3,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,1,1,2,2,2,2,0,0,0,0,1,1,0,0,0,0,3,3,0,0,0,0,2,2,3,3,0,0,0,0,1,1,1,1,1,1,3,3,2,2,2,2,0,0,0,0,3,3,2,2,3,3,3,3,0,0,2,2,2,2,0,0,2,2,2,2,1,1,3,3,2,2,0,0,3,3,2,2,0,0,2,2,0,0,2,2,2,2,3,3,1,1,0,0,0,0,0,0,2,2,0,0,1,1,2,2,3,3,3,3,2,2,2,2,0,0,1,1,3,3,0,0,1,1,3,3,2,2,1,1,0,0,2,2,0,0,3,3,3,3,1,1,1,1,0,0,0,0,1,1,2,2,0,0,1,1,1,1,1,1,2,2,2,2,0,0,0,0,2,2,1,1,2,2,0,0,0,0,3,3,3,3,2,2,0,0,0,0,2,2,0,0,2,2,3,3,1,1,0,0,1,1,0,0,2,2,1,1,0,0,2,2,0,0,1,1,0,0,2,2,0,0,3,3,0,0,3,3,0,0,2,2,1,1,1,1,3,3,3,3,1,1,2,2,3,3,2,2,3,3,1,1,1,1,0,0,0,0,0,0,2,2,0,0,1,1,0,0,1,1,1,1,2,2,1,1,2,2,1,1,1,1,2,2,3,3,0,0,1,1,2,2,3,3,0,0,2,2,3,3,2,2,1,1,0,0,0,0,3,3,0,0,2,2,3,3,2,2,1,1,2,2,0,0,3,3,1,1,0,0,1,1,2,2,1,1,1,1,1,1,0,0,1,1,2,2,0,0,2,2,0,0,2,2,3,3,3,3,1,1,3,3,0,0,0,0,1,1,3,3,0,0,0,0,0,0,3,3,1,1,3,3,1,1,2,2,0,0,0,0,3,3,3,3,0,0,0,0,3,3,1,1,3,3,0,0,2,2,1,1,3,3,2,2,1,1,3,3,2,2,2,2,0,0,1,1,1,1,0,0,0,0,2,2,0,0,2,2,1,1,2,2,2,2,2,2,2,2,2,2,0,0,0,0,2,2,2,2,2,2,0,0,1,1,3,3,1,1,2,2,3,3,1,1,2,2,1,1,1,1,3,3,2,2,0,0,1,1,0,0,0,0,1,1,1,1,0,0,2,2,3,3,2,2,1,1,3,3,3,3,3,3,2,2,1,1,1,1,1,1,0,0,0,0,3,3,2,2,2,2,3,3,1,1,1,1,0,0,2,2,1,1,0,0,0,0,0,0,1,1,2,2,0,0,2,2,3,3,0,0,0,0,0,0,0,0,3,3,2,2,0,0,1,1,2,2,2,2,3,3,0,0,1,1,0,0,3,3,3,3,3,3,2,2,1,1,3,3,0,0,2,2,2,2,3,3,2,2,1,1,3,3,1,1,2,2,1,1,1,1,3,3,1,1,1,1,3,3,0,0,0,0,3,3,3,3,1,1,0,0,2,2,1,1,1,1,1,1,2,2,0,0,1,1,1,1,0,0,2,2,3,3,0,0,3,3,3,3,2,2,2,2,3,3,0,0,0,0,2,2,3,3,0,0,0,0,2,2,2,2,0,0,3,3,3,3,2,2,2,2,1,1,0,0,0,0,1,1,3,3,1,1,3,3,0,0,2,2,3,3,3,3,2,2,0,0,3,3,1,1,1,1,0,0,1,1,0,0,2,2,0,0,2,2,1,1,3,3,0,0,1,1,1,1,0,0,3,3,2,2,0,0,0,0,2,2,2,2,1,1,2,2,3,3,1,1,0,0,2,2,3,3,2,2,1,1,0,0,1,1,2,2,2,2,1,1,2,2,3,3,3,3,3,3,2,2,0,0,3,3,0,0,0,0,2,2,3,3,0,0,3,3,0,0,2,2,2,2,2,2,3,3,1,1,2,2,3,3,1,1,0,0,2,2,0,0,2,2,3,3,3,3,3,3,1,1,3,3,2,2,1,1,0,0,2,2,2,2,3,3,1,1,0,0,3,3,1,1,1,1,3,3,2,2,2,2,3,3,1,1,2,2,2,2,1,1,0,0,0,0,3,3,0,0,2,2,2,2,3,3,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,3,3,2,2,1,1,3,3,2,2,0,0,2,2,2,2,1,1,2,2,0,0,1,1,1,1,1,1,0,0,0,0,2,2,1,1,1,1,1,1,0,0,1,1,1,1,2,2,0,0,2,2,1,1,1,1,3,3,1,1,2,2,2,2,0,0,3,3,3,3,1,1,0,0,3,3,2,2,2,2,2,2,1,1,3,3,3,3,0,0,2,2,2,2,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,3,3,1,1,0,0,2,2,1,1,3,3,0,0,1,1,3,3,3,3,1,1,3,3,1,1,3,3,3,3,2,2,1,1,2,2,0,0,2,2,0,0,2,2,3,3,3,3,1,1,3,3,3,3,1,1,0,0,1,1,3,3,3,3,2,2,0,0,0,0,0,0,3,3,3,3,0,0,1,1,1,1,0,0,0,0,1,1,2,2,0,0,0,0,3,3,3,3,2,2,0,0,3,3,0,0,2,2,2,2,1,1,2,2,2,2,0,0,3,3,2,2,3,3,3,3,2,2,1,1,1,1,3,3,3,3,2,2,3,3,3,3,3,3,2,2,1,1,2,2,0,0,0,0,1,1,2,2,1,1,3,3,0,0,1,1,0,0,1,1,2,2,2,2,1,1,3,3,0,0,3,3,1,1,2,2,2,2,2,2,3,3,0,0,0,0,2,2,0,0,1,1,0,0,0,0,1,1,2,2,3,3,2,2,2,2,3,3,2,2,0,0,1,1,3,3,0,0,3,3,1,1,1,1,3,3,1,1,1,1,3,3,2,2,3,3,3,3,2,2,0,0,2,2,3,3,0,0,1,1,1,1,3,3,2,2,0,0,3,3,0,0,2,2,0,0,3,3,1,1,1,1,2,2,2,2,1,1,1,1,0,0,2,2,3,3,0,0,2,2,2,2,0,0,2,2,0,0,2,2,0,0,1,1,0,0,2,2,2,2,3,3,2,2,0,0,0,0,1,1,0,0,2,2,2,2,0,0,3,3,2,2,0,0,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,0,0,3,3,0,0,2,2,2,2,0,0,0,0,3,3,2,2,2,2,1,1,2,2,2,2,2,2,3,3,1,1,0,0,1,1,1,1,2,2,0,0,0,0,0,0,3,3,2,2,0,0,0,0,3,3,0,0,1,1,2,2,0,0,1,1,3,3,2,2,2,2,0,0,2,2,2,2,0,0,3,3,0,0,0,0,2,2,1,1,1,1,2,2,1,1,0,0,2,2,3,3,0,0,0,0,1,1,2,2,1,1,0,0,3,3,1,1,2,2,2,2,3,3,1,1,1,1,2,2,0,0,0,0,0,0,1,1,1,1,1,1,3,3,0,0,2,2,3,3,3,3,1,1,0,0,3,3,3,3,3,3,2,2,0,0,2,2,3,3,1,1,0,0,1,1,2,2,0,0,3,3,0,0,3,3,0,0,2,2,1,1,0,0,0,0,0,0,0,0,0,0,1,1,3,3,3,3,2,2,0,0,1,1,0,0,3,3,2,2,1,1,3,3,1,1,3,3,0,0,2,2,2,2,3,3,1,1,1,1,1,1,1,1,1,1,2,2,3,3,2,2,0,0,2,2,2,2,2,2,2,2,0,0,1,1,3,3,2,2,0,0,1,1,1,1,3,3,1,1,0,0,1,1,0,0,0,0,3,3,3,3,3,3,0,0,1,1,0,0,3,3,1,1,0,0,1,1,2,2,1,1,0,0,1,1,0,0,1,1,3,3,0,0,0,0,3,3,0,0,1,1,1,1,3,3,2,2,0,0,2,2,3,3,2,2,0,0,1,1,0,0,3,3,2,2,0,0,0,0,0,0,1,1,2,2,1,1,0,0,2,2,0,0,0,0,3,3,0,0,1,1,1,1,1,1,3,3,0,0,1,1,0,0,1,1,3,3,1,1,2,2,2,2,3,3,0,0,0,0,0,0,1,1,0,0,0,0,3,3,2,2,2,2,1,1,3,3,3,3,1,1,2,2,1,1,1,1,0,0,1,1,0,0,2,2,1,1,0,0,2,2,3,3,2,2,0,0,0,0,1,1,2,2,3,3,3,3,2,2,3,3,3,3,1,1,0,0,1,1,1,1,2,2,1,1,3,3,2,2,1,1,3,3,3,3,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,3,2,2,2,2,1,1,2,2,2,2,1,1,2,2,0,0,1,1,1,1,2,2,0,0,0,0,0,0,1,1,1,1,3,3,0,0,3,3,0,0,3,3,0,0,0,0,1,1,3,3,1,1,2,2,0,0,2,2,0,0,3,3,0,0,3,3,2,2,0,0,0,0,0,0,3,3,1,1,1,1,0,0,2,2,3,3,1,1,0,0,1,1,2,2,2,2,0,0,2,2,1,1,2,2,0,0,1,1,2,2,1,1,3,3,3,3,0,0,2,2,3,3,1,1,1,1,0,0,3,3,2,2,2,2,3,3,1,1,0,0,2,2,3,3,3,3,0,0,0,0,0,0,0,0,2,2,3,3,0,0,0,0,3,3,0,0,1,1,0,0,3,3,0,0,0,0,2,2,1,1,3,3,2,2,0,0,0,0,3,3,0,0,3,3,1,1,0,0,2,2,2,2,3,3,0,0,2,2,1,1,3,3,1,1,3,3,1,1,0,0,2,2,2,2,1,1,1,1,2,2,0,0,3,3,0,0,2,2,2,2,3,3,1,1,3,3,3,3,3,3,3,3,3,3,3,3,0,0,2,2,2,2,0,0,1,1,3,3,1,1,1,1,3,3,0,0,2,2,3,3,1,1,2,2,1,1,0,0,3,3,3,3,1,1,0,0,3,3,1,1,0,0,0,0,0,0,3,3,1,1,2,2,2,2,0,0,1,1,2,2,3,3,2,2,3,3,0,0,1,1,2,2,0,0,2,2,1,1,2,2,2,2,2,2,0,0,1,1,0,0,0,0,3,3,2,2,1,1,0,0,0,0,2,2,0,0,3,3,1,1,0,0,0,0,0,0,2,2,3,3,1,1,0,0,3,3,1,1,3,3,2,2,1,1,3,3,0,0,3,3,2,2,2,2,0,0,1,1,1,1,2,2,2,2,1,1,3,3,2,2,1,1,3,3,1,1,0,0,3,3,2,2,1,1,2,2,2,2,1,1,0,0,3,3,1,1,0,0,3,3,1,1,3,3,2,2,2,2,2,2,0,0,1,1,3,3,1,1,3,3,3,3,3,3,2,2,0,0,3,3,0,0,3,3,0,0,2,2,1,1,2,2,2,2,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,3,3,0,0,1,1,1,1,2,2,0,0,0,0,0,0,3,3,2,2,1,1,2,2,1,1,0,0,1,1,2,2,0,0,1,1,3,3,1,1,3,3,1,1,1,1,2,2,3,3,2,2,0,0,0,0,2,2,3,3,1,1,0,0,2,2,0,0,3,3,1,1,3,3,2,2,2,2,3,3,3,3,2,2,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,2,2,0,0,1,1,1,1,3,3,2,2,2,2,1,1,0,0,0,0,3,3,1,1,0,0,0,0,1,1,3,3,0,0,0,0,0,0,2,2,3,3,0,0,1,1,2,2,3,3,3,3,3,3,1,1,1,1,2,2,1,1,0,0,1,1,0,0,0,0,2,2,1,1,3,3,3,3,1,1,2,2,0,0,2,2,3,3,0,0,0,0,2,2,0,0,2,2,2,2,0,0,0,0,3,3,0,0,3,3,2,2,2,2,0,0,3,3,1,1,0,0,1,1,1,1,0,0,3,3,0,0,0,0,1,1,3,3,0,0,0,0,3,3,3,3,2,2,2,2,2,2,0,0,3,3,0,0,0,0,2,2,3,3,2,2,0,0,2,2,0,0,1,1,2,2,1,1,3,3,2,2,1,1,3,3,3,3,3,3,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,1,1,1,1,0,0,3,3,0,0,3,3,3,3,3,3,0,0,2,2,3,3,3,3,3,3,1,1,2,2,1,1,3,3,2,2,0,0,0,0,3,3,0,0,0,0,3,3,0,0,1,1,1,1,0,0,0,0,0,0,3,3,1,1,3,3,2,2,1,1,2,2,3,3,2,2,3,3,2,2,1,1,2,2,3,3,0,0,2,2,0,0,3,3,2,2,0,0,0,0,1,1,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,3,3,3,3,0,0,2,2,3,3,3,3,1,1,1,1,0,0,0,0,2,2,2,2,3,3,0,0,3,3,1,1,3,3,2,2,2,2,3,3,1,1,3,3,1,1,3,3,0,0,2,2,0,0,1,1,3,3,1,1,2,2,0,0,0,0,1,1,2,2,2,2,0,0,1,1,1,1,2,2,1,1,3,3,2,2,3,3,0,0,3,3,0,0,2,2,0,0,1,1,2,2,0,0,0,0,2,2,3,3,2,2,0,0,3,3,2,2,0,0,2,2,2,2,0,0,3,3,2,2,3,3,0,0,0,0,3,3,1,1,2,2,2,2,3,3,0,0,3,3,2,2,1,1,0,0,0,0,3,3,1,1,3,3,2,2,3,3,2,2,1,1,3,3,0,0,0,0,0,0,1,1,3,3,2,2,3,3,1,1,1,1,0,0,2,2,1,1,1,1,2,2,1,1,3,3,1,1,3,3,2,2,2,2,0,0,0,0,3,3,2,2,1,1,0,0,3,3,2,2,0,0,1,1,0,0,2,2,2,2,0,0,2,2,1,1,1,1,1,1,1,1,1,1,1,1,0,0,2,2,3,3,2,2,2,2,2,2,2,2,1,1,3,3,3,3,2,2,3,3,2,2,0,0,3,3,0,0,0,0,1,1,3,3,2,2,0,0,3,3,0,0,3,3,3,3,2,2,1,1,1,1,1,1,3,3,1,1,0,0,3,3,2,2,3,3,3,3,1,1,0,0,0,0,2,2,2,2,0,0,2,2,2,2,0,0,3,3,2,2,0,0,3,3,3,3,1,1,0,0,1,1,1,1,1,1,3,3,3,3,1,1,3,3,0,0,2,2,3,3,1,1,3,3,1,1,1,1,2,2,1,1,0,0,0,0,1,1,2,2,2,2,0,0,1,1,1,1,2,2,1,1,0,0,2,2,0,0,0,0,1,1,0,0,1,1,2,2,1,1,0,0,1,1,1,1,2,2,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,3,3,1,1,0,0,1,1,1,1,3,3,0,0,0,0,1,1,1,1,2,2,0,0,2,2,2,2,3,3,3,3,0,0,1,1,0,0,3,3,2,2,2,2,3,3,0,0,0,0,0,0,1,1,0,0,3,3,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,2,2,0,0,0,0,2,2,3,3,3,3,0,0,3,3,1,1,2,2,2,2,1,1,0,0,3,3,1,1,2,2,2,2,2,2,0,0,1,1,1,1,0,0,2,2,1,1,3,3,1,1,0,0,0,0,0,0,1,1,3,3,3,3,1,1,2,2,3,3,3,3,0,0,0,0,3,3,3,3,1,1,1,1,2,2,3,3,0,0,2,2,0,0,0,0,2,2,0,0,2,2,2,2,1,1,1,1,1,1,0,0,2,2,1,1,2,2,0,0,0,0,1,1,2,2,0,0,2,2,0,0,0,0,2,2,0,0,3,3,2,2,0,0,2,2,0,0,2,2,1,1,1,1,2,2,1,1,3,3,0,0,1,1,0,0,0,0,2,2,2,2,1,1,0,0,0,0,0,0,1,1,0,0,3,3,0,0,3,3,0,0,2,2,1,1,1,1,3,3,2,2,0,0,0,0,3,3,3,3,0,0,1,1,3,3,2,2,2,2,3,3,2,2,2,2,2,2,0,0,0,0,3,3,0,0,0,0,3,3,1,1,3,3,0,0,0,0,1,1,3,3,1,1,0,0,0,0,1,1,2,2,0,0,2,2,3,3,0,0,2,2,2,2,2,2,2,2,2,2,1,1,3,3,1,1,1,1,0,0,2,2,1,1,0,0,3,3,2,2,1,1,3,3,2,2,1,1,2,2,3,3,2,2,1,1,0,0,3,3,3,3,2,2,0,0,0,0,1,1,1,1,3,3,2,2,0,0,0,0,3,3,0,0,0,0,0,0,1,1,1,1,3,3,1,1,3,3,1,1,2,2,2,2,1,1,0,0,2,2,2,2,0,0,2,2,3,3,0,0,2,2,0,0,0,0,3,3,2,2,0,0,2,2,3,3,3,3,3,3,1,1,2,2,0,0,1,1,2,2,1,1,1,1,2,2,2,2,1,1,3,3,0,0,1,1,2,2,1,1,0,0,1,1,3,3,0,0,0,0,2,2,3,3,0,0,0,0,1,1,2,2,1,1,2,2,2,2,1,1,2,2,2,2,3,3,1,1,3,3,1,1,2,2,1,1,2,2,1,1,1,1,0,0,2,2,0,0,3,3,3,3,2,2,2,2,2,2,2,2,2,2,3,3,0,0,3,3,0,0,1,1,0,0,1,1,3,3,0,0,3,3,0,0,0,0,3,3,2,2,3,3,2,2,1,1,1,1,0,0,3,3,2,2,1,1,1,1,0,0,3,3,1,1,3,3,3,3,2,2,2,2,0,0,2,2,0,0,3,3,1,1,2,2,2,2,2,2,3,3,3,3,2,2,2,2,0,0,1,1,0,0,2,2,3,3,2,2,3,3,1,1,0,0,1,1,2,2,2,2,2,2,3,3,2,2,1,1,2,2,0,0,0,0,3,3,3,3,0,0,2,2,1,1,0,0,1,1,3,3,3,3,1,1,1,1,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,0,0,3,3,0,0,2,2,3,3,0,0,0,0,3,3,2,2,1,1,1,1,0,0,2,2,2,2,1,1,2,2,1,1,0,0,3,3,3,3,1,1,3,3,1,1,3,3,3,3,1,1,2,2,2,2,0,0,0,0,3,3,1,1,2,2,3,3,1,1,0,0,2,2,0,0,0,0,3,3,2,2,0,0,3,3,0,0,2,2,0,0,0,0,2,2,2,2,2,2,0,0,2,2,1,1,3,3,3,3,2,2,3,3,1,1,3,3,3,3,3,3,3,3,1,1,3,3,2,2,3,3,0,0,3,3,1,1,0,0,2,2,2,2,3,3,2,2,1,1,1,1,3,3,3,3,1,1,2,2,3,3,1,1,3,3,0,0,0,0,0,0,2,2,3,3,2,2,1,1,3,3,2,2,2,2,0,0,2,2,0,0,1,1,0,0,3,3,0,0,3,3,2,2,0,0,2,2,2,2,3,3,1,1,0,0,2,2,1,1,3,3,0,0,0,0,0,0,2,2,0,0,1,1,2,2,2,2,1,1,2,2,2,2,0,0,2,2,1,1,0,0,0,0,2,2,0,0,0,0,1,1,2,2,1,1,3,3,1,1,0,0,0,0,0,0,1,1,1,1,2,2,2,2,2,2,0,0,0,0,3,3,0,0,3,3,3,3,3,3,0,0,2,2,2,2,2,2,1,1,0,0,1,1,1,1,0,0,3,3,3,3,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,0,0,2,2,3,3,3,3,1,1,2,2,1,1,2,2,2,2,3,3,0,0,0,0,3,3,2,2,0,0,1,1,3,3,1,1,1,1,2,2,2,2,3,3,3,3,3,3,1,1,0,0,1,1,3,3,1,1,2,2,2,2,1,1,1,1,3,3,0,0,1,1,1,1,3,3,2,2,1,1,2,2,2,2,2,2,2,2,3,3,2,2,2,2,1,1,1,1,2,2,0,0,3,3,2,2,0,0,1,1,2,2,3,3,2,2,0,0,1,1,3,3,0,0,1,1,1,1,3,3,3,3,1,1,3,3,0,0,2,2,2,2,3,3,2,2,3,3,2,2,2,2,0,0,0,0,2,2,2,2,1,1,0,0,3,3,3,3,0,0,2,2,1,1,1,1,3,3,1,1,3,3,1,1,2,2,0,0,0,0,3,3,3,3,1,1,0,0,0,0,3,3,1,1,2,2,1,1,3,3,1,1,1,1,2,2,1,1,2,2,2,2,0,0,2,2,3,3,3,3,2,2,3,3,2,2,0,0,2,2,1,1,1,1,3,3,0,0,3,3,2,2,0,0,0,0,2,2,0,0,3,3,3,3,0,0,3,3,3,3,3,3,0,0,2,2,0,0,1,1,2,2,0,0,3,3,2,2,1,1,1,1,1,1,1,1,0,0,3,3,2,2,3,3,2,2,3,3,1,1,2,2,0,0,1,1,1,1,0,0,3,3,1,1,3,3,0,0,2,2,0,0,2,2,2,2,1,1,2,2,1,1,1,1,1,1,2,2,2,2,0,0,2,2,2,2,0,0,2,2,1,1,3,3,1,1,2,2,2,2,1,1,1,1,3,3,1,1,1,1,3,3,0,0,0,0,0,0,1,1,0,0,0,0,0,0,3,3,1,1,2,2,0,0,3,3,3,3,2,2,0,0,3,3,2,2,1,1,3,3,0,0,0,0,3,3,2,2,1,1,3,3,3,3,1,1,3,3,0,0,2,2,0,0,1,1,3,3,0,0,0,0,3,3,1,1,2,2,1,1,3,3,3,3,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,1,1,3,3,2,2,3,3,3,3,3,3,3,3,2,2,0,0,0,0,1,1,0,0,3,3,3,3,0,0,3,3,0,0,3,3,2,2,3,3,1,1,1,1,2,2,2,2,3,3,1,1,0,0,3,3,0,0,2,2,3,3,3,3,1,1,1,1,1,1,1,1,3,3,0,0,2,2,2,2,2,2,1,1,2,2,3,3,3,3,1,1,2,2,2,2,0,0,1,1,0,0,0,0,1,1,1,1,2,2,1,1,2,2,1,1,3,3,3,3,2,2,2,2,1,1,0,0,1,1,3,3,2,2,0,0,3,3,0,0,0,0,3,3,2,2,0,0,3,3,3,3,0,0,3,3,2,2,1,1,0,0,2,2,0,0,3,3,1,1,3,3,3,3,0,0,2,2,1,1,3,3,2,2,2,2,3,3,2,2,0,0,0,0,0,0,1,1,0,0,3,3,3,3,2,2,2,2,1,1,3,3,1,1,3,3,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,0,0,0,0,1,1,1,1,2,2,0,0,2,2,1,1,0,0,3,3,2,2,1,1,0,0,0,0,3,3,3,3,2,2,3,3,3,3,3,3,1,1,0,0,1,1,3,3,2,2,3,3,1,1,0,0,0,0,2,2,1,1,0,0,1,1,3,3,0,0,3,3,0,0,2,2,1,1,3,3,3,3,3,3,0,0,2,2,0,0,0,0,2,2,3,3,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,3,3,0,0,2,2,1,1,3,3,2,2,0,0,2,2,1,1,0,0,1,1,1,1,2,2,3,3,0,0,3,3,2,2,2,2,2,2,1,1,1,1,1,1,3,3,0,0,0,0,3,3,0,0,3,3,1,1,2,2,0,0,2,2,3,3,3,3,2,2,1,1,3,3,3,3,0,0,2,2,3,3,1,1,2,2,1,1,3,3,0,0,0,0,3,3,3,3,2,2,2,2,0,0,0,0,2,2,3,3,2,2,1,1,1,1,2,2,2,2,1,1,0,0,0,0,2,2,0,0,0,0,0,0,2,2,0,0,3,3,1,1,2,2,1,1,2,2,3,3,0,0,0,0,1,1,3,3,2,2,0,0,3,3,0,0,0,0,0,0,0,0,0,0,2,2,1,1,3,3,3,3,1,1,3,3,0,0,2,2,1,1,0,0,0,0,1,1,2,2,2,2,0,0,0,0,3,3,3,3,2,2,0,0,1,1,0,0,2,2,0,0,3,3,2,2,2,2,2,2,2,2,0,0,1,1,0,0,3,3,0,0,1,1,0,0,0,0,3,3,0,0,1,1,0,0,0,0,1,1,0,0,3,3,2,2,0,0,0,0,1,1,3,3,2,2,2,2,1,1,0,0,2,2,0,0,2,2,0,0,0,0,0,0,1,1,1,1,2,2,0,0,3,3,1,1,1,1,2,2,2,2,3,3,3,3,2,2,1,1,2,2,0,0,1,1,0,0,1,1,2,2,0,0,3,3,1,1,2,2,2,2,1,1,2,2,2,2,2,2,3,3,1,1,3,3,2,2,1,1,1,1,3,3,3,3,2,2,0,0,2,2,2,2,2,2,2,2,1,1,0,0,3,3,0,0,0,0,1,1,1,1,3,3,1,1,2,2,1,1,3,3,1,1,2,2,3,3,1,1,0,0,1,1,0,0,0,0,2,2,3,3,2,2,1,1,2,2,2,2,0,0,1,1,1,1,3,3,1,1,3,3,2,2,3,3,1,1,2,2,0,0,0,0,2,2,0,0,1,1,2,2,1,1,2,2,1,1,0,0,1,1,1,1,0,0,2,2,1,1,2,2,2,2,2,2,0,0,0,0,2,2,1,1,0,0,3,3,3,3,1,1,1,1,0,0,1,1,0,0,1,1,3,3,1,1,3,3,2,2,1,1,0,0,3,3,2,2,2,2,2,2,3,3,3,3,1,1,1,1,0,0,0,0,3,3,1,1,0,0,0,0,2,2,0,0,1,1,1,1,0,0,3,3,1,1,0,0,0,0,1,1,3,3,2,2,1,1,2,2,3,3,2,2,1,1,2,2,2,2,2,2,3,3,0,0,0,0,1,1,0,0,1,1,0,0,2,2,1,1,0,0,0,0,0,0,2,2,0,0,0,0,2,2,0,0,0,0,3,3,0,0,2,2,3,3,3,3,2,2,1,1,0,0,1,1,3,3,3,3,0,0,3,3,2,2,2,2,2,2,3,3,2,2,2,2,0,0,0,0,3,3,1,1,2,2,2,2,3,3,1,1,3,3,1,1,2,2,3,3,0,0,1,1,0,0,0,0,1,1,0,0,2,2,0,0,0,0,1,1,1,1,3,3,2,2,3,3,0,0,2,2,3,3,3,3,0,0,0,0,1,1,2,2,0,0,3,3,0,0,3,3,3,3,0,0,1,1,3,3,1,1,1,1,1,1,3,3,3,3,0,0,0,0,2,2,1,1,2,2,0,0,1,1,3,3,0,0,1,1,0,0,3,3,0,0,3,3,0,0,1,1,2,2,2,2,1,1,2,2,2,2,1,1,0,0,0,0,0,0,2,2,2,2,1,1,3,3,3,3,1,1,0,0,0,0,2,2,2,2,1,1,2,2,2,2,1,1,2,2,0,0,1,1,1,1,0,0,2,2,3,3,1,1,2,2,3,3,1,1,2,2,3,3,3,3,2,2,2,2,3,3,0,0,3,3,1,1,0,0,3,3,0,0,2,2,1,1,1,1,2,2,3,3,2,2,1,1,3,3,0,0,3,3,2,2,1,1,1,1,0,0,3,3,2,2,0,0,0,0,2,2,0,0,1,1,1,1,3,3,3,3,3,3,1,1,0,0,2,2,0,0,0,0,2,2,0,0,1,1,2,2,0,0,0,0,3,3,0,0,1,1,2,2,0,0,0,0,2,2,1,1,3,3,0,0,1,1,3,3,0,0,3,3,2,2,0,0,0,0,1,1,2,2,0,0,2,2,2,2,0,0,3,3,0,0,0,0,3,3,1,1,2,2,2,2,3,3,3,3,2,2,2,2,2,2,3,3,1,1,1,1,3,3,0,0,2,2,0,0,0,0,3,3,2,2,0,0,3,3,0,0,3,3,3,3,1,1,2,2,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,3,3,3,3,0,0,0,0,2,2,2,2,1,1,3,3,3,3,1,1,0,0,3,3,1,1,2,2,0,0,0,0,3,3,2,2,3,3,3,3,2,2,1,1,2,2,2,2,3,3,1,1,3,3,1,1,2,2,1,1,2,2,3,3,1,1,2,2,0,0,2,2,2,2,1,1,3,3,2,2,1,1,3,3,2,2,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,3,3,1,1,1,1,0,0,2,2,0,0,3,3,3,3,1,1,2,2,0,0,1,1,1,1,2,2,3,3,0,0,0,0,1,1,1,1,2,2,1,1,2,2,2,2,1,1,1,1,0,0,2,2,3,3,1,1,2,2,3,3,2,2,1,1,0,0,0,0,0,0,1,1,1,1,3,3,3,3,0,0,1,1,2,2,2,2,0,0,3,3,2,2,3,3,0,0,3,3,3,3,3,3,0,0,1,1,2,2,0,0,1,1,1,1,0,0,2,2,1,1,1,1,1,1,3,3,1,1,0,0,0,0,1,1,0,0,1,1,3,3,1,1,0,0,2,2,3,3,0,0,0,0,0,0,2,2,1,1,1,1,0,0,2,2,1,1,2,2,3,3,3,3,1,1,0,0,2,2,3,3,1,1,2,2,2,2,2,2,0,0,3,3,1,1,2,2,0,0,1,1,1,1,3,3,1,1,1,1,2,2,3,3,2,2,1,1,1,1,2,2,0,0,1,1,2,2,1,1,2,2,0,0,3,3,0,0,0,0,0,0,1,1,0,0,2,2,1,1,1,1,3,3,3,3,3,3,2,2,0,0,0,0,1,1,0,0,0,0,2,2,1,1,1,1,1,1,0,0,2,2,3,3,1,1,2,2,3,3,1,1,3,3,1,1,3,3,3,3,3,3,0,0,0,0,1,1,2,2,2,2,2,2,1,1,0,0,1,1,1,1,0,0,3,3,2,2,2,2,0,0,0,0,1,1,3,3,1,1,0,0,3,3,2,2,3,3,0,0,0,0,2,2,2,2,2,2,3,3,2,2,1,1,2,2,2,2,0,0,3,3,2,2,3,3,2,2,3,3,1,1,1,1,0,0,1,1,2,2,0,0,1,1,2,2,1,1,0,0,3,3,3,3,2,2,3,3,1,1,1,1,1,1,1,1,1,1,3,3,3,3,0,0,3,3,0,0,0,0,2,2,3,3,0,0,1,1,3,3,1,1,2,2,2,2,2,2,2,2,2,2,1,1,3,3,2,2,1,1,2,2,3,3,3,3,1,1,3,3,2,2,2,2,0,0,1,1,2,2,2,2,0,0,2,2,3,3,2,2,0,0,0,0,2,2,2,2,2,2,2,2,3,3,2,2,0,0,1,1,2,2,2,2,1,1,1,1,2,2,3,3,3,3,3,3,3,3,0,0,3,3,2,2,1,1,3,3,3,3,1,1,0,0,3,3,2,2,0,0,2,2,2,2,0,0,3,3,1,1,1,1,3,3,2,2,3,3,3,3,1,1,0,0,3,3,0,0,0,0,2,2,1,1,1,1,2,2,0,0,0,0,2,2,2,2,0,0,1,1,1,1,0,0,2,2,1,1,3,3,3,3,1,1,1,1,0,0,0,0,1,1,1,1,2,2,1,1,2,2,0,0,3,3,3,3,1,1,0,0,3,3,1,1,0,0,2,2,3,3,1,1,3,3,0,0,3,3,1,1,0,0,1,1,1,1,0,0,1,1,1,1,2,2,2,2,1,1,2,2,2,2,2,2,1,1,1,1,1,1,0,0,1,1,1,1,2,2,1,1,2,2,1,1,3,3,3,3,3,3,2,2,3,3,3,3,0,0,0,0,0,0,1,1,0,0,2,2,1,1,3,3,2,2,2,2,3,3,3,3,1,1,0,0,3,3,2,2,2,2,3,3,3,3,0,0,3,3,3,3,3,3,2,2,1,1,1,1,0,0,0,0,0,0,2,2,1,1,2,2,0,0,1,1,3,3,2,2,3,3,0,0,2,2,3,3,2,2,2,2,1,1,0,0,0,0,2,2,1,1,2,2,1,1,1,1,2,2,2,2,1,1,1,1,1,1,0,0,3,3,0,0,1,1,1,1,0,0,2,2,3,3,1,1,2,2,0,0,1,1,3,3,1,1,0,0,0,0,1,1,2,2,3,3,0,0,3,3,3,3,3,3,3,3,0,0,3,3,3,3,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,0,0,0,0,3,3,2,2,0,0,2,2,1,1,3,3,0,0,0,0,3,3,3,3,1,1,1,1,2,2,1,1,3,3,2,2,1,1,2,2,3,3,3,3,0,0,1,1,0,0,2,2,1,1,2,2,2,2,3,3,0,0,2,2,0,0,3,3,2,2,3,3,3,3,2,2,1,1,1,1,3,3,1,1,1,1,1,1,3,3,3,3,0,0,2,2,1,1,2,2,0,0,1,1,3,3,2,2,2,2,3,3,3,3,3,3,1,1,0,0,1,1,0,0,1,1,2,2,3,3,1,1,1,1,3,3,3,3,2,2,3,3,0,0,2,2,2,2,0,0,1,1,1,1,3,3,0,0,2,2,0,0,2,2,0,0,3,3,2,2,1,1,1,1,3,3,0,0,3,3,3,3,0,0,3,3,0,0,0,0,3,3,0,0,3,3,0,0,2,2,1,1,2,2,0,0,0,0,2,2,3,3,2,2,1,1,1,1,3,3,2,2,3,3,2,2,1,1,2,2,1,1,0,0,3,3,0,0,2,2,1,1,1,1,2,2,1,1,0,0,1,1,2,2,1,1,1,1,0,0,2,2,1,1,3,3,2,2,3,3,2,2,3,3,3,3,3,3,0,0,2,2,3,3,3,3,1,1,3,3,1,1,0,0,3,3,2,2,2,2,2,2,0,0,3,3,3,3,0,0,1,1,3,3,2,2,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,2,2,0,0,1,1,2,2,0,0,2,2,0,0,1,1,1,1,2,2,2,2,3,3,1,1,1,1,2,2,0,0,2,2,2,2,2,2,1,1,0,0,3,3,3,3,1,1,1,1,2,2,3,3,1,1,1,1,1,1,0,0,3,3,3,3,2,2,3,3,2,2,2,2,1,1,0,0,0,0,2,2,1,1,1,1,0,0,1,1,3,3,0,0,0,0,0,0,1,1,1,1,1,1,3,3,0,0,2,2,1,1,2,2,3,3,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,3,3,2,2,0,0,2,2,3,3,3,3,3,3,2,2,0,0,3,3,2,2,0,0,2,2,1,1,1,1,1,1,2,2,0,0,0,0,0,0,1,1,0,0,2,2,3,3,2,2,0,0,2,2,1,1,2,2,2,2,2,2,2,2,3,3,1,1,2,2,0,0,2,2,0,0,3,3,2,2,0,0,0,0,0,0,3,3,2,2,0,0,0,0,2,2,3,3,2,2,1,1,0,0,0,0,2,2,0,0,3,3,3,3,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,3,3,1,1,0,0,3,3,1,1,0,0,1,1,2,2,0,0,3,3,3,3,0,0,0,0,0,0,0,0,3,3,0,0,3,3,1,1,0,0,3,3,3,3,0,0,3,3,2,2,2,2,1,1,1,1,3,3,1,1,2,2,0,0,1,1,2,2,1,1,2,2,0,0,0,0,3,3,1,1,1,1,2,2,0,0,0,0,3,3,2,2,3,3,1,1,3,3,0,0,1,1,2,2,0,0,1,1,2,2,1,1,1,1,1,1,2,2,3,3,1,1,3,3,1,1,0,0,2,2,3,3,0,0,0,0,3,3,0,0,0,0,3,3,3,3,2,2,0,0,3,3,1,1,3,3,1,1,1,1,3,3,2,2,3,3,2,2,3,3,1,1,3,3,2,2,1,1,2,2,2,2,1,1,2,2,1,1,2,2,2,2,1,1,2,2,2,2,1,1,3,3,1,1,0,0,0,0,2,2,1,1,0,0,0,0,0,0,0,0,3,3,0,0,0,0,1,1,0,0,0,0,0,0,2,2,3,3,3,3,2,2,0,0,2,2,0,0,3,3,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,2,2,3,3,2,2,2,2,0,0,0,0,3,3,1,1,1,1,1,1,2,2,1,1,1,1,2,2,3,3,2,2,2,2,0,0,2,2,3,3,3,3,3,3,0,0,3,3,2,2,3,3,3,3,0,0,0,0,3,3,2,2,2,2,0,0,0,0,1,1,3,3,2,2,1,1,0,0,0,0,1,1,3,3,3,3,3,3,2,2,1,1,1,1,3,3,0,0,2,2,0,0,2,2,0,0,3,3,3,3,1,1,1,1,2,2,0,0,1,1,1,1,3,3,2,2,1,1,2,2,2,2,0,0,1,1,2,2,0,0,3,3,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,2,2,1,1,1,1,1,1,0,0,1,1,0,0,3,3,2,2,0,0,2,2,0,0,2,2,1,1,1,1,1,1,2,2,1,1,0,0,2,2,1,1,2,2,1,1,3,3,2,2,2,2,3,3,3,3,3,3,1,1,3,3,0,0,0,0,2,2,1,1,2,2,2,2,0,0,0,0,0,0,2,2,0,0,2,2,3,3,3,3,3,3,1,1,0,0,3,3,1,1,0,0,0,0,1,1,3,3,2,2,3,3,1,1,1,1,0,0,1,1,2,2,2,2,1,1,0,0,0,0,2,2,2,2,0,0,1,1,1,1,2,2,0,0,1,1,2,2,1,1,3,3,2,2,3,3,3,3,1,1,1,1,3,3,0,0,2,2,3,3,3,3,3,3,3,3,3,3,1,1,1,1,2,2,3,3,0,0,0,0,1,1,1,1,1,1,2,2,1,1,3,3,1,1,3,3,3,3,0,0,3,3,2,2,1,1,3,3,1,1,2,2,0,0,0,0,0,0,1,1,2,2,0,0,2,2,2,2,1,1,1,1,2,2,1,1,0,0,1,1,1,1,3,3,3,3,0,0,2,2,1,1,1,1,3,3,0,0,2,2,2,2,0,0,2,2,3,3,3,3,1,1,0,0,1,1,1,1,1,1,2,2,2,2,1,1,0,0,3,3,0,0,2,2,0,0,0,0,1,1,0,0,0,0,1,1,0,0,2,2,2,2,0,0,1,1,1,1,2,2,1,1,2,2,1,1,1,1,1,1,1,1,3,3,2,2,1,1,2,2,0,0,3,3,1,1,3,3,2,2,0,0,0,0,0,0,0,0,0,0,3,3,2,2,3,3,3,3,0,0,0,0,2,2,1,1,2,2,3,3,2,2,0,0,1,1,0,0,0,0,2,2,1,1,2,2,1,1,3,3,0,0,2,2,3,3,1,1,1,1,1,1,1,1,2,2,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,2,2,3,3,1,1,0,0,2,2,0,0,0,0,2,2,1,1,3,3,0,0,0,0,0,0,0,0,3,3,0,0,2,2,1,1,2,2,0,0,3,3,0,0,1,1,1,1,0,0,0,0,3,3,1,1,1,1,2,2,2,2,0,0,2,2,0,0,2,2,1,1,3,3,2,2,0,0,3,3,3,3,2,2,1,1,1,1,1,1,0,0,2,2,3,3,0,0,1,1,2,2,2,2,1,1,3,3,0,0,0,0,3,3,3,3,0,0,2,2,3,3,3,3,2,2,0,0,2,2,3,3,3,3,1,1,3,3,2,2,1,1,1,1,1,1,1,1,3,3,3,3,1,1,0,0,2,2,0,0,3,3,1,1,1,1,0,0,1,1,3,3,3,3,2,2,0,0,0,0,1,1,2,2,1,1,0,0,1,1,3,3,3,3,1,1,0,0,3,3,3,3,2,2,2,2,1,1,0,0,3,3,3,3,2,2,3,3,3,3,0,0,2,2,1,1,1,1,0,0,3,3,1,1,2,2,0,0,1,1,1,1,0,0,1,1,0,0,1,1,3,3,0,0,0,0,2,2,3,3,3,3,1,1,2,2,2,2,3,3,2,2,3,3,3,3,1,1,2,2,2,2,2,2,2,2,3,3,1,1,2,2,1,1,0,0,2,2,2,2,2,2,2,2,3,3,2,2,2,2,1,1,1,1,1,1,3,3,2,2,2,2,2,2,2,2,3,3,3,3,0,0,1,1,1,1,0,0,3,3,1,1,3,3,2,2,3,3,0,0,3,3,2,2,2,2,1,1,3,3,2,2,3,3,1,1,2,2,0,0,0,0,0,0,1,1,0,0,1,1,2,2,2,2,1,1,2,2,1,1,3,3,2,2,3,3,0,0,0,0,1,1,1,1,2,2,2,2,3,3,0,0,2,2,3,3,0,0,0,0,2,2,3,3,3,3,1,1,2,2,2,2,0,0,2,2,2,2,0,0,0,0,2,2,1,1,3,3,1,1,3,3,1,1,1,1,2,2,1,1,3,3,2,2,3,3,2,2,2,2,1,1,3,3,2,2,0,0,0,0,0,0,2,2,1,1,1,1,1,1,1,1,0,0,3,3,0,0,1,1,2,2,1,1,0,0,1,1,2,2,2,2,3,3,0,0,1,1,2,2,1,1,2,2,2,2,2,2,0,0,1,1,0,0,0,0,3,3,3,3,3,3,0,0,0,0,3,3,0,0,0,0,1,1,2,2,0,0,2,2,3,3,3,3,2,2,1,1,2,2,0,0,0,0,3,3,0,0,3,3,1,1,2,2,2,2,0,0,0,0,0,0,2,2,2,2,3,3,3,3,0,0,0,0,2,2,3,3,0,0,0,0,0,0,0,0,1,1,2,2,2,2,1,1,0,0,3,3,1,1,1,1,0,0,0,0,0,0,3,3,3,3,0,0,1,1,3,3,1,1,3,3,0,0,0,0,2,2,2,2,1,1,2,2,0,0,0,0,0,0,1,1,2,2,0,0,0,0,0,0,2,2,2,2,0,0,1,1,1,1,0,0,0,0,0,0,1,1,2,2,2,2,2,2,0,0,0,0,2,2,0,0,1,1,1,1,2,2,0,0,0,0,3,3,3,3,0,0,3,3,1,1,2,2,1,1,2,2,3,3,1,1,3,3,3,3,1,1,3,3,3,3,3,3,2,2,3,3,3,3,2,2,2,2,2,2,3,3,0,0,1,1,1,1,0,0,1,1,3,3,3,3,0,0,3,3,0,0,1,1,1,1,2,2,1,1,2,2,2,2,1,1,2,2,0,0,2,2,1,1,2,2,0,0,3,3,0,0,1,1,2,2,0,0,3,3,0,0,0,0,0,0,1,1,0,0,2,2,1,1,3,3,3,3,2,2,3,3,1,1,0,0,1,1,1,1,1,1,0,0,3,3,0,0,2,2,0,0,0,0,3,3,0,0,3,3,3,3,3,3,3,3,1,1,1,1,3,3,1,1,2,2,1,1,3,3,1,1,2,2,2,2,3,3,2,2,1,1,2,2,0,0,2,2,3,3,3,3,1,1,3,3,3,3,0,0,3,3,0,0,0,0,1,1,0,0,0,0,2,2,0,0,1,1,1,1,3,3,2,2,1,1,0,0,1,1,0,0,0,0,2,2,2,2,3,3,0,0,2,2,0,0,1,1,3,3,0,0,2,2,0,0,1,1,0,0,1,1,1,1,2,2,0,0,2,2,0,0,1,1,2,2,3,3,2,2,3,3,1,1,0,0,1,1,2,2,1,1,3,3,2,2,1,1,0,0,2,2,2,2,1,1,3,3,0,0,3,3,3,3,2,2,3,3,1,1,2,2,0,0,3,3,2,2,3,3,3,3,0,0,0,0,0,0,2,2,2,2,3,3,2,2,3,3,3,3,3,3,3,3,0,0,3,3,2,2,0,0,0,0,2,2,2,2,1,1,3,3,1,1,2,2,3,3,3,3,1,1,1,1,2,2,2,2,1,1,0,0,1,1,3,3,3,3,2,2,1,1,2,2,0,0,1,1,1,1,2,2,0,0,1,1,2,2,2,2,0,0,1,1,1,1,2,2,3,3,1,1,1,1,1,1,0,0,2,2,0,0,2,2,0,0,1,1,2,2,2,2,0,0,0,0,0,0,1,1,2,2,3,3,1,1,1,1,0,0,2,2,2,2,0,0,1,1,0,0,2,2,2,2,0,0,3,3,3,3,0,0,3,3,2,2,2,2,2,2,3,3,1,1,3,3,2,2,2,2,2,2,2,2,0,0,1,1,2,2,0,0,3,3,1,1,1,1,0,0,1,1,3,3,1,1,2,2,0,0,0,0,2,2,1,1,2,2,3,3,2,2,2,2,3,3,3,3,2,2,1,1,0,0,1,1,2,2,2,2,0,0,1,1,2,2,1,1,0,0,1,1,2,2,1,1,1,1,3,3,1,1,0,0,0,0,3,3,0,0,0,0,0,0,1,1,1,1,1,1,1,1,3,3,1,1,2,2,0,0,0,0,0,0,0,0,1,1,1,1,1,1,2,2,2,2,2,2,1,1,2,2,0,0,1,1,0,0,0,0,1,1,1,1,3,3,1,1,2,2,2,2,1,1,0,0,2,2,0,0,0,0,3,3,0,0,1,1,3,3,0,0,2,2,2,2,1,1,0,0,0,0,0,0,3,3,1,1,1,1,1,1,2,2,2,2,1,1,3,3,3,3,3,3,2,2,0,0,3,3,1,1,0,0,1,1,1,1,1,1,2,2,0,0,2,2,0,0,3,3,1,1,1,1,0,0,3,3,1,1,3,3,0,0,0,0,3,3,0,0,0,0,1,1,1,1,3,3,2,2,3,3,1,1,3,3,2,2,0,0,0,0,2,2,2,2,3,3,2,2,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,2,2,3,3,0,0,1,1,0,0,0,0,0,0,2,2,1,1,3,3,3,3,1,1,3,3,0,0,0,0,1,1,2,2,0,0,1,1,0,0,2,2,0,0,2,2,2,2,2,2,0,0,2,2,2,2,2,2,1,1,0,0,0,0,2,2,3,3,0,0,1,1,2,2,1,1,0,0,2,2,2,2,0,0,0,0,1,1,0,0,2,2,0,0,0,0,0,0,2,2,2,2,3,3,3,3,2,2,2,2,1,1,2,2,1,1,3,3,1,1,3,3,3,3,0,0,0,0,1,1,3,3,3,3,3,3,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,2,2,0,0,1,1,2,2,0,0,0,0,2,2,2,2,1,1,0,0,0,0,2,2,0,0,3,3,2,2,1,1,1,1,2,2,3,3,3,3,0,0,2,2,3,3,3,3,0,0,1,1,1,1,3,3,1,1,3,3,0,0,0,0,2,2,1,1,1,1,3,3,1,1,2,2,0,0,1,1,0,0,1,1,3,3,3,3,2,2,3,3,2,2,1,1,2,2,2,2,2,2,2,2,0,0,0,0,1,1,1,1,2,2,0,0,1,1,3,3,2,2,2,2,0,0,0,0,0,0,1,1,2,2,3,3,0,0,1,1,1,1,3,3,2,2,0,0,2,2,2,2,2,2,0,0,0,0,0,0,3,3,2,2,0,0,2,2,3,3,2,2,0,0,2,2,1,1,2,2,2,2,0,0,1,1,1,1,0,0,0,0,2,2,1,1,0,0,2,2,1,1,2,2,1,1,1,1,0,0,0,0,1,1,2,2,0,0,1,1,2,2,0,0,0,0,3,3,3,3,3,3,3,3,0,0,2,2,3,3,0,0,0,0,0,0,3,3,2,2,1,1,1,1,2,2,2,2,2,2,0,0,2,2,0,0,2,2,0,0,0,0,3,3,2,2,0,0,2,2,3,3,2,2,1,1,1,1,2,2,3,3,0,0,1,1,3,3,2,2,3,3,2,2,0,0,0,0,0,0,0,0,0,0,3,3,3,3,1,1,1,1,0,0,0,0,3,3,1,1,1,1,1,1,3,3,0,0,2,2,0,0,3,3,1,1,1,1,2,2,0,0,0,0,1,1,2,2,3,3,1,1,1,1,1,1,3,3,0,0,0,0,0,0,2,2,0,0,2,2,2,2,3,3,2,2,0,0,0,0,0,0,1,1,3,3,0,0,0,0,2,2,3,3,3,3,1,1,0,0,0,0,3,3,2,2,2,2,2,2,3,3,1,1,0,0,3,3,1,1,2,2,0,0,3,3,1,1,2,2,0,0,1,1,1,1,3,3,2,2,0,0,3,3,0,0,1,1,0,0,2,2,3,3,0,0,1,1,3,3,3,3,1,1,0,0,2,2,1,1,0,0,2,2,3,3,2,2,1,1,0,0,3,3,2,2,0,0,1,1,1,1,2,2,2,2,2,2,2,2,1,1,0,0,3,3,3,3,3,3,0,0,0,0,2,2,1,1,3,3,2,2,2,2,0,0,2,2,2,2,2,2,1,1,0,0,3,3,1,1,0,0,1,1,2,2,1,1,3,3,3,3,3,3,3,3,1,1,0,0,0,0,0,0,1,1,3,3,1,1,3,3,3,3,2,2,0,0,0,0,0,0,2,2,3,3,2,2,3,3,1,1,3,3,0,0,1,1,2,2,3,3,2,2,1,1,2,2,1,1,1,1,2,2,2,2,1,1,0,0,0,0,2,2,2,2,3,3,2,2,3,3,3,3,0,0,2,2,0,0,3,3,1,1,2,2,0,0,0,0,1,1,1,1,0,0,3,3,1,1,0,0,0,0,2,2,0,0,3,3,1,1,1,1,3,3,2,2,1,1,0,0,3,3,0,0,0,0,2,2,2,2,2,2,1,1,1,1,0,0,1,1,0,0,0,0,0,0,2,2,1,1,0,0,0,0,1,1,1,1,3,3,1,1,2,2,1,1,2,2,1,1,0,0,0,0,1,1,2,2,3,3,2,2,2,2,0,0,3,3,1,1,2,2,0,0,3,3,0,0,3,3,2,2,2,2,0,0,0,0,1,1,3,3,0,0,2,2,1,1,2,2,1,1,3,3,0,0,1,1,0,0,0,0,0,0,2,2,2,2,0,0,3,3,3,3,0,0,0,0,0,0,2,2,2,2,0,0,1,1,0,0,2,2,2,2,2,2,2,2,0,0,1,1,3,3,1,1,0,0,3,3,3,3,1,1,3,3,3,3,3,3,0,0,0,0,2,2,3,3,2,2,3,3,1,1,3,3,1,1,0,0,3,3,0,0,3,3,3,3,2,2,1,1,0,0,3,3,0,0,3,3,0,0,3,3,3,3,0,0,0,0,1,1,0,0,3,3,2,2,1,1,0,0,2,2,1,1,2,2,2,2,2,2,2,2,1,1,2,2,2,2,0,0,0,0,2,2,0,0,0,0,2,2,3,3,1,1,0,0,0,0,0,0,1,1,1,1,2,2,3,3,1,1,3,3,2,2,2,2,1,1,2,2,2,2,1,1,3,3,2,2,1,1,2,2,3,3,2,2,1,1,1,1,0,0,2,2,3,3,0,0,0,0,1,1,1,1,0,0,0,0,2,2,2,2,2,2,1,1,1,1,2,2,1,1,3,3,3,3,0,0,0,0,1,1,0,0,2,2,1,1,0,0,2,2,0,0,0,0,2,2,0,0,1,1,0,0,1,1,1,1,1,1,1,1,2,2,3,3,2,2,1,1,3,3,0,0,0,0,1,1,3,3,0,0,2,2,2,2,2,2,1,1,3,3,2,2,3,3,1,1,0,0,2,2,3,3,1,1,1,1,2,2,2,2,1,1,1,1,0,0,2,2,0,0,1,1,3,3,2,2,2,2,2,2,3,3,3,3,2,2,0,0,0,0,3,3,3,3,3,3,3,3,1,1,0,0,3,3,0,0,1,1,1,1,3,3,0,0,2,2,3,3,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,2,2,1,1,3,3,0,0,1,1,3,3,1,1,3,3,2,2,1,1,1,1,1,1,1,1,0,0,2,2,3,3,2,2,1,1,1,1,2,2,3,3,2,2,0,0,0,0,2,2,0,0,0,0,3,3,2,2,0,0,1,1,3,3,1,1,2,2,3,3,2,2,1,1,3,3,2,2,1,1,3,3,1,1,3,3,3,3,1,1,0,0,2,2,3,3,0,0,1,1,0,0,0,0,3,3,1,1,3,3,3,3,0,0,2,2,0,0,1,1,2,2,0,0,1,1,2,2,0,0,0,0,3,3,1,1,3,3,0,0,3,3,0,0,0,0,2,2,3,3,0,0,0,0,2,2,2,2,0,0,0,0,3,3,1,1,3,3,1,1,1,1,0,0,1,1,0,0,3,3,0,0,3,3,1,1,2,2,1,1,3,3,2,2,0,0,3,3,2,2,1,1,0,0,3,3,0,0,1,1,2,2,2,2,0,0,3,3,2,2,2,2,3,3,3,3,3,3,0,0,3,3,1,1,1,1,0,0,1,1,0,0,1,1,2,2,2,2,1,1,2,2,0,0,1,1,0,0,1,1,1,1,0,0,3,3,1,1,1,1,3,3,2,2,3,3,0,0,2,2,1,1,0,0,2,2,3,3,0,0,2,2,0,0,2,2,2,2,2,2,3,3,2,2,0,0,1,1,3,3,3,3,3,3,3,3,2,2,0,0,1,1,3,3,3,3,2,2,3,3,1,1,2,2,0,0,3,3,1,1,1,1,1,1,3,3,0,0,1,1,2,2,1,1,2,2,0,0,2,2,2,2,3,3,2,2,1,1,0,0,3,3,2,2,2,2,1,1,3,3,1,1,0,0,3,3,1,1,2,2,0,0,3,3,0,0,0,0,0,0,3,3,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,2,2,1,1,0,0,3,3,1,1,3,3,3,3,1,1,3,3,0,0,0,0,0,0,2,2,3,3,3,3,2,2,1,1,0,0,0,0,2,2,2,2,1,1,3,3,0,0,2,2,1,1,0,0,1,1,3,3,1,1,2,2,1,1,2,2,0,0,2,2,1,1,2,2,2,2,1,1,3,3,2,2,1,1,2,2,2,2,0,0,1,1,3,3,0,0,1,1,3,3,2,2,3,3,0,0,2,2,0,0,3,3,1,1,1,1,3,3,0,0,3,3,3,3,0,0,2,2,3,3,3,3,2,2,2,2,1,1,0,0,1,1,2,2,0,0,2,2,3,3,3,3,2,2,3,3,0,0,1,1,1,1,3,3,1,1,2,2,2,2,1,1,1,1,1,1,3,3,1,1,0,0,2,2,3,3,0,0,3,3,3,3,1,1,1,1,1,1,0,0,2,2,0,0,3,3,1,1,0,0,0,0,2,2,3,3,1,1,3,3,0,0,1,1,1,1,2,2,3,3,0,0,3,3,0,0,0,0,3,3,1,1,0,0,3,3,2,2,0,0,2,2,3,3,3,3,1,1,0,0,0,0,0,0,1,1,0,0,0,0,2,2,2,2,2,2,0,0,0,0,3,3,0,0,3,3,3,3,1,1,2,2,0,0,0,0,2,2,3,3,3,3,0,0,3,3,1,1,0,0,1,1,1,1,1,1,2,2,0,0,1,1,1,1,3,3,2,2,1,1,2,2,2,2,1,1,1,1,0,0,1,1,0,0,1,1,2,2,2,2,0,0,0,0,3,3,1,1,1,1,0,0,3,3,3,3,1,1,2,2,1,1,2,2,3,3,1,1,3,3,0,0,2,2,2,2,0,0,1,1,1,1,3,3,0,0,3,3,1,1,0,0,3,3,3,3,1,1,0,0,0,0,0,0,0,0,3,3,0,0,1,1,2,2,1,1,0,0,2,2,3,3,3,3,0,0,2,2,1,1,1,1,1,1,2,2,1,1,0,0,2,2,0,0,2,2,3,3,0,0,1,1,0,0,3,3,0,0,0,0,0,0,0,0,0,0,1,1,1,1,3,3,0,0,2,2,2,2,2,2,2,2,2,2,3,3,3,3,1,1,1,1,2,2,1,1,0,0,2,2,1,1,2,2,2,2,3,3,1,1,2,2,3,3,1,1,2,2,3,3,0,0,1,1,0,0,0,0,2,2,0,0,0,0,3,3,2,2,2,2,2,2,0,0,3,3,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,3,3,1,1,3,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,2,2,0,0,0,0,0,0,0,0,3,3,2,2,0,0,3,3,2,2,1,1,1,1,3,3,3,3,2,2,1,1,1,1,1,1,0,0,2,2,2,2,0,0,2,2,1,1,0,0,0,0,2,2,2,2,1,1,0,0,2,2,0,0,1,1,2,2,0,0,2,2,0,0,1,1,0,0,2,2,1,1,0,0,3,3,2,2,2,2,0,0,0,0,1,1,2,2,1,1,2,2,2,2,0,0,0,0,0,0,0,0,3,3,1,1,0,0,1,1,2,2,3,3,0,0,1,1,1,1,3,3,2,2,1,1,1,1,1,1,3,3,2,2,1,1,2,2,1,1,1,1,1,1,2,2,3,3,1,1,2,2,3,3,0,0,2,2,1,1,2,2,0,0,3,3,0,0,2,2,2,2,1,1,3,3,0,0,1,1,0,0,3,3,0,0,0,0,0,0,2,2,2,2,2,2,1,1,3,3,3,3,2,2,2,2,0,0,3,3,0,0,0,0,1,1,0,0,1,1,0,0,2,2,0,0,0,0,1,1,1,1,3,3,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,1,1,1,1,0,0,1,1,1,1,2,2,2,2,3,3,2,2,2,2,2,2,1,1,3,3,3,3,2,2,1,1,0,0,3,3,1,1,2,2,3,3,3,3,3,3,3,3,1,1,1,1,0,0,3,3,1,1,3,3,3,3,3,3,2,2,2,2,0,0,1,1,2,2,1,1,1,1,1,1,0,0,2,2,2,2,1,1,3,3,3,3,3,3,1,1,1,1,3,3,0,0,3,3,1,1,0,0,1,1,3,3,2,2,3,3,3,3,0,0,1,1,2,2,1,1,1,1,0,0,1,1,0,0,3,3,3,3,2,2,2,2,2,2,2,2,1,1,2,2,1,1,1,1,0,0,2,2,0,0,0,0,0,0,2,2,3,3,0,0,0,0,0,0,0,0,1,1,3,3,1,1,2,2,2,2,2,2,2,2,1,1,2,2,0,0,1,1,1,1,3,3,1,1,0,0,1,1,1,1,1,1,3,3,1,1,0,0,0,0,2,2,2,2,0,0,1,1,1,1,1,1,3,3,1,1,1,1,3,3,3,3,3,3,3,3,0,0,0,0,2,2,0,0,1,1,2,2,1,1,0,0,2,2,0,0,0,0,1,1,3,3,2,2,3,3,3,3,3,3,1,1,0,0,0,0,3,3,0,0,3,3,3,3,3,3,0,0,1,1,1,1,2,2,3,3,0,0,0,0,0,0,3,3,0,0,0,0,2,2,1,1,1,1,1,1,0,0,2,2,0,0,2,2,0,0,3,3,2,2,2,2,3,3,0,0,0,0,0,0,0,0,3,3,3,3,3,3,2,2,0,0,2,2,0,0,1,1,0,0,0,0,2,2,2,2,1,1,3,3,0,0,1,1,1,1,3,3,3,3,2,2,2,2,2,2,0,0,1,1,3,3,0,0,3,3,3,3,1,1,0,0,0,0,1,1,3,3,0,0,2,2,1,1,3,3,2,2,3,3,0,0,0,0,2,2,0,0,2,2,1,1,3,3,2,2,0,0,0,0,3,3,2,2,1,1,1,1,1,1,3,3,0,0,0,0,0,0,3,3,0,0,0,0,3,3,0,0,1,1,3,3,1,1,0,0,3,3,3,3,0,0,0,0,0,0,0,0,1,1,2,2,0,0,2,2,0,0,0,0,0,0,0,0,1,1,0,0,1,1,3,3,1,1,1,1,1,1,0,0,1,1,1,1,2,2,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,2,2,2,2,3,3,0,0,0,0,1,1,0,0,2,2,2,2,0,0,1,1,2,2,1,1,0,0,0,0,0,0,1,1,2,2,2,2,2,2,3,3,1,1,0,0,3,3,0,0,3,3,0,0,2,2,1,1,3,3,1,1,0,0,2,2,2,2,1,1,2,2,0,0,2,2,1,1,0,0,0,0,0,0,0,0,3,3,1,1,2,2,0,0,3,3,1,1,0,0,0,0,2,2,3,3,1,1,1,1,2,2,1,1,0,0,1,1,1,1,3,3,0,0,3,3,1,1,1,1,3,3,3,3,0,0,2,2,2,2,0,0,3,3,1,1,3,3,2,2,1,1,2,2,0,0,2,2,2,2,2,2,3,3,2,2,2,2,1,1,1,1,0,0,0,0,2,2,2,2,3,3,0,0,2,2,0,0,2,2,1,1,0,0,1,1,0,0,3,3,3,3,3,3,1,1,1,1,1,1,1,1,2,2,3,3,1,1,1,1,1,1,3,3,1,1,3,3,1,1,2,2,3,3,1,1,1,1,1,1,1,1,2,2,0,0,1,1,1,1,2,2,0,0,0,0,3,3,3,3,0,0,3,3,2,2,1,1,3,3,0,0,3,3,1,1,1,1,2,2,2,2,1,1,3,3,1,1,2,2,2,2,0,0,3,3,2,2,0,0,0,0,0,0,1,1,2,2,1,1,1,1,2,2,0,0,1,1,1,1,2,2,1,1,0,0,3,3,3,3,2,2,1,1,3,3,2,2,0,0,0,0,2,2,0,0,0,0,0,0,3,3,0,0,3,3,0,0,0,0,3,3,3,3,2,2,3,3,0,0,0,0,0,0,0,0,3,3,0,0,0,0,1,1,2,2,0,0,2,2,2,2,1,1,3,3,1,1,0,0,1,1,0,0,1,1,0,0,2,2,1,1,1,1,0,0,3,3,3,3,3,3,1,1,2,2,1,1,1,1,2,2,3,3,0,0,2,2,0,0,3,3,1,1,0,0,1,1,0,0,1,1,0,0,2,2,1,1,2,2,1,1,3,3,2,2,3,3,1,1,1,1,2,2,1,1,1,1,2,2,3,3,2,2,3,3,3,3,0,0,3,3,3,3,3,3,0,0,1,1,3,3,1,1,3,3,0,0,1,1,3,3,3,3,2,2,1,1,2,2,2,2,1,1,1,1,0,0,2,2,0,0,3,3,2,2,1,1,3,3,0,0,3,3,0,0,1,1,2,2,1,1,3,3,3,3,1,1,0,0,2,2,3,3,0,0,1,1,1,1,3,3,0,0,2,2,2,2,0,0,2,2,1,1,1,1,2,2,2,2,1,1,2,2,2,2,2,2,2,2,0,0,1,1,3,3,2,2,2,2,0,0,3,3,3,3,2,2,1,1,0,0,1,1,1,1,1,1,3,3,3,3,0,0,0,0,2,2,0,0,3,3,2,2,1,1,2,2,0,0,0,0,1,1,1,1,3,3,3,3,3,3,1,1,3,3,3,3,0,0,0,0,1,1,2,2,1,1,0,0,2,2,0,0,2,2,0,0,3,3,1,1,0,0,1,1,1,1,2,2,0,0,0,0,0,0,0,0,1,1,1,1,3,3,3,3,0,0,2,2,0,0,1,1,0,0,3,3,1,1,0,0,0,0,0,0,3,3,1,1,1,1,2,2,3,3,1,1,1,1,1,1,2,2,3,3,1,1,2,2,3,3,3,3,0,0,2,2,2,2,2,2,3,3,2,2,0,0,3,3,3,3,1,1,2,2,1,1,3,3,2,2,0,0,0,0,2,2,0,0,3,3,1,1,3,3,2,2,0,0,3,3,0,0,2,2,2,2,1,1,1,1,3,3,0,0,2,2,0,0,0,0,0,0,0,0,1,1,0,0,1,1,2,2,1,1,1,1,3,3,0,0,2,2,0,0,0,0,3,3,3,3,1,1,0,0,0,0,0,0,1,1,3,3,2,2,1,1,0,0,1,1,2,2,2,2,2,2,0,0,0,0,2,2,1,1,0,0,3,3,2,2,0,0,0,0,0,0,0,0,3,3,0,0,2,2,1,1,3,3,0,0,1,1,1,1,2,2,2,2,2,2,2,2,0,0,2,2,1,1,2,2,0,0,2,2,2,2,3,3,0,0,1,1,1,1,2,2,0,0,1,1,2,2,2,2,1,1,2,2,1,1,3,3,3,3,2,2,0,0,3,3,3,3,2,2,0,0,3,3,0,0,1,1,3,3,2,2,2,2,0,0,0,0,3,3,2,2,1,1,3,3,1,1,0,0,0,0,1,1,2,2,1,1,1,1,3,3,3,3,2,2,3,3,0,0,3,3,1,1,0,0,1,1,3,3,1,1,3,3,3,3,2,2,2,2,3,3,2,2,3,3,1,1,3,3,2,2,1,1,0,0,0,0,3,3,2,2,1,1,3,3,2,2,0,0,0,0,3,3,3,3,0,0,0,0,2,2,0,0,2,2,2,2,3,3,2,2,0,0,1,1,2,2,3,3,2,2,0,0,1,1,2,2,2,2,0,0,0,0,1,1,3,3,0,0,2,2,3,3,3,3,1,1,2,2,1,1,3,3,3,3,0,0,0,0,1,1,2,2,2,2,0,0,0,0,0,0,3,3,3,3,3,3,2,2,0,0,1,1,3,3,3,3,0,0,3,3,2,2,2,2,1,1,1,1,0,0,1,1,1,1,2,2,3,3,1,1,2,2,1,1,0,0,1,1,0,0,1,1,3,3,1,1,3,3,0,0,2,2,2,2,1,1,1,1,1,1,2,2,2,2,1,1,1,1,0,0,3,3,2,2,3,3,1,1,1,1,2,2,2,2,0,0,1,1,2,2,3,3,0,0,1,1,2,2,0,0,0,0,0,0,0,0,2,2,1,1,1,1,0,0,3,3,0,0,0,0,0,0,1,1,1,1,3,3,2,2,2,2,0,0,1,1,2,2,3,3,2,2,3,3,1,1,0,0,0,0,1,1,0,0,0,0,0,0,3,3,1,1,2,2,0,0,2,2,0,0,1,1,1,1,2,2,3,3,3,3,2,2,2,2,2,2,1,1,0,0,2,2,2,2,3,3,2,2,1,1,0,0,2,2,1,1,2,2,3,3,0,0,0,0,3,3,2,2,1,1,0,0,0,0,1,1,0,0,2,2,0,0,2,2,1,1,2,2,0,0,1,1,0,0,1,1,2,2,3,3,0,0,0,0,1,1,0,0,3,3,2,2,3,3,2,2,2,2,2,2,1,1,2,2,3,3,2,2,3,3,2,2,1,1,1,1,1,1,2,2,2,2,3,3,1,1,2,2,0,0,3,3,0,0,1,1,0,0,2,2,2,2,1,1,0,0,2,2,2,2,1,1,3,3,2,2,2,2,2,2,1,1,0,0,3,3,3,3,1,1,0,0,0,0,0,0,2,2,2,2,3,3,0,0,3,3,2,2,1,1,3,3,3,3,2,2,1,1,0,0,3,3,3,3,0,0,3,3,1,1,0,0,0,0,2,2,1,1,1,1,1,1,3,3,1,1,0,0,0,0,3,3,2,2,1,1,3,3,1,1,3,3,0,0,1,1,1,1,3,3,0,0,0,0,3,3,0,0,3,3,0,0,1,1,0,0,0,0,1,1,3,3,2,2,3,3,1,1,2,2,2,2,3,3,0,0,1,1,1,1,3,3,3,3,3,3,1,1,1,1,2,2,1,1,3,3,1,1,0,0,2,2,1,1,1,1,2,2,2,2,1,1,3,3,3,3,1,1,0,0,1,1,0,0,0,0,3,3,3,3,1,1,3,3,3,3,3,3,2,2,2,2,1,1,0,0,0,0,3,3,2,2,0,0,0,0,2,2,2,2,2,2,1,1,2,2,1,1,3,3,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,2,2,1,1,2,2,3,3,3,3,0,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,3,3,1,1,3,3,2,2,3,3,0,0,1,1,1,1,3,3,3,3,0,0,0,0,3,3,1,1,1,1,0,0,1,1,1,1,1,1,0,0,3,3,3,3,0,0,2,2,2,2,2,2,3,3,0,0,3,3,2,2,0,0,1,1,2,2,3,3,3,3,2,2,0,0,1,1,0,0,3,3,3,3,2,2,3,3,3,3,0,0,2,2,2,2,2,2,1,1,2,2,1,1,3,3,3,3,3,3,0,0,2,2,0,0,1,1,0,0,3,3,1,1,0,0,1,1,3,3,0,0,0,0,2,2,0,0,1,1,1,1,2,2,3,3,1,1,0,0,2,2,3,3,2,2,2,2,1,1,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,1,1,2,2,2,2,0,0,1,1,0,0,0,0,0,0,2,2,0,0,0,0,1,1,0,0,0,0,1,1,3,3,3,3,3,3,1,1,2,2,0,0,0,0,2,2,2,2,2,2,2,2,0,0,2,2,2,2,0,0,0,0,3,3,3,3,0,0,1,1,1,1,1,1,2,2,2,2,0,0,3,3,2,2,0,0,0,0,2,2,2,2,2,2,2,2,3,3,0,0,0,0,2,2,1,1,0,0,0,0,0,0,2,2,3,3,2,2,2,2,1,1,2,2,2,2,1,1,0,0,0,0,0,0,0,0,2,2,3,3,2,2,3,3,1,1,1,1,1,1,3,3,0,0,1,1,1,1,3,3,2,2,2,2,2,2,0,0,2,2,2,2,2,2,3,3,2,2,3,3,3,3,2,2,3,3,2,2,1,1,0,0,0,0,3,3,0,0,1,1,2,2,0,0,1,1,1,1,2,2,1,1,2,2,0,0,0,0,2,2,0,0,2,2,0,0,2,2,1,1,1,1,3,3,3,3,2,2,1,1,1,1,2,2,1,1,1,1,3,3,2,2,0,0,2,2,2,2,0,0,2,2,1,1,0,0,2,2,0,0,1,1,0,0,0,0,1,1,2,2,3,3,1,1,0,0,2,2,3,3,2,2,1,1,3,3,3,3,0,0,1,1,2,2,2,2,1,1,2,2,0,0,1,1,2,2,2,2,0,0,3,3,2,2,1,1,1,1,1,1,2,2,3,3,2,2,0,0,0,0,1,1,3,3,1,1,3,3,3,3,3,3,0,0,3,3,1,1,1,1,1,1,0,0,0,0,1,1,0,0,2,2,1,1,3,3,0,0,1,1,2,2,0,0,3,3,0,0,3,3,2,2,0,0,0,0,1,1,1,1,2,2,2,2,2,2,1,1,3,3,3,3,1,1,1,1,3,3,3,3,2,2,2,2,2,2,0,0,0,0,1,1,2,2,1,1,2,2,3,3,0,0,1,1,2,2,0,0,0,0,1,1,0,0,0,0,3,3,0,0,0,0,0,0,1,1,3,3,0,0,1,1,0,0,1,1,2,2,0,0,3,3,1,1,3,3,1,1,3,3,2,2,0,0,2,2,2,2,1,1,0,0,3,3,3,3,1,1,0,0,3,3,3,3,3,3,1,1,2,2,3,3,0,0,0,0,1,1,1,1,0,0,3,3,2,2,1,1,0,0,2,2,1,1,3,3,1,1,2,2,0,0,2,2,2,2,0,0,1,1,2,2,3,3,2,2,2,2,1,1,2,2,3,3,0,0,2,2,2,2,3,3,2,2,0,0,0,0,1,1,2,2,1,1,0,0,1,1,1,1,3,3,0,0,3,3,3,3,3,3,2,2,2,2,1,1,0,0,2,2,2,2,1,1,0,0,2,2,0,0,0,0,2,2,3,3,2,2,3,3,1,1,2,2,1,1,2,2,3,3,0,0,2,2,1,1,0,0,2,2,0,0,0,0,2,2,1,1,0,0,3,3,1,1,3,3,1,1,1,1,0,0,0,0,1,1,3,3,0,0,0,0,3,3,3,3,0,0,1,1,2,2,0,0,1,1,0,0,2,2,3,3,2,2,1,1,0,0,0,0,1,1,3,3,2,2,2,2,3,3,1,1,0,0,1,1,3,3,2,2,1,1,1,1,2,2,1,1,0,0,0,0,2,2,3,3,0,0,2,2,3,3,2,2,1,1,1,1,3,3,1,1,3,3,0,0,3,3,1,1,3,3,0,0,3,3,2,2,0,0,2,2,1,1,2,2,0,0,0,0,1,1,2,2,0,0,3,3,3,3,1,1,1,1,1,1,0,0,1,1,1,1,2,2,2,2,2,2,2,2,1,1,3,3,0,0,1,1,3,3,1,1,1,1,0,0,2,2,0,0,1,1,1,1,3,3,1,1,2,2,0,0,1,1,3,3,2,2,1,1,0,0,0,0,0,0,1,1,0,0,2,2,0,0,1,1,1,1,1,1,1,1,1,1,3,3,2,2,1,1,2,2,2,2,3,3,3,3,2,2,1,1,0,0,2,2,0,0,0,0,2,2,1,1,0,0,0,0,0,0,2,2,0,0,1,1,1,1,0,0,3,3,1,1,2,2,1,1,1,1,2,2,1,1,2,2,1,1,1,1,3,3,0,0,0,0,1,1,1,1,3,3,0,0,0,0,0,0,2,2,0,0,3,3,0,0,2,2,2,2,3,3,3,3,1,1,2,2,3,3,3,3,3,3,0,0,3,3,0,0,0,0,2,2,0,0,3,3,2,2,0,0,2,2,2,2,0,0,0,0,0,0,1,1,0,0,2,2,2,2,0,0,1,1,1,1,2,2,1,1,2,2,1,1,2,2,2,2,3,3,0,0,1,1,1,1,3,3,3,3,3,3,0,0,1,1,0,0,2,2,0,0,2,2,0,0,1,1,3,3,0,0,2,2,2,2,3,3,2,2,3,3,3,3,1,1,2,2,0,0,1,1,2,2,0,0,2,2,3,3,2,2,0,0,3,3,3,3,1,1,0,0,3,3,1,1,1,1,0,0,1,1,2,2,0,0,3,3,1,1,1,1,0,0,1,1,0,0,2,2,1,1,0,0,0,0,3,3,0,0,1,1,2,2,3,3,3,3,2,2,0,0,2,2,3,3,1,1,1,1,1,1,1,1,0,0,1,1,3,3,1,1,1,1,1,1,3,3,2,2,0,0,3,3,0,0,1,1,2,2,3,3,2,2,2,2,3,3,0,0,2,2,2,2,0,0,2,2,3,3,0,0,1,1,0,0,0,0,0,0,1,1,3,3,3,3,2,2,1,1,0,0,3,3,1,1,2,2,1,1,3,3,0,0,2,2,2,2,2,2,3,3,2,2,2,2,3,3,0,0,2,2,2,2,3,3,0,0,2,2,0,0,2,2,1,1,1,1,2,2,0,0,0,0,0,0,0,0,1,1,3,3,0,0,0,0,2,2,2,2,3,3,3,3,1,1,3,3,3,3,1,1,1,1,2,2,3,3,1,1,0,0,0,0,2,2,0,0,0,0,0,0,2,2,2,2,3,3,0,0,1,1,0,0,2,2,1,1,0,0,2,2,1,1,2,2,1,1,2,2,0,0,1,1,0,0,0,0,3,3,3,3,3,3,2,2,1,1,0,0,0,0,2,2,1,1,0,0,0,0,0,0,0,0,1,1,3,3,3,3,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,2,2,3,3,3,3,3,3,1,1,3,3,0,0,2,2,2,2,2,2,3,3,3,3,0,0,2,2,0,0,0,0,0,0,2,2,3,3,1,1,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,2,2,1,1,1,1,3,3,0,0,0,0,2,2,0,0,3,3,2,2,1,1,3,3,0,0,2,2,3,3,2,2,1,1,1,1,2,2,0,0,1,1,0,0,1,1,3,3,0,0,2,2,1,1,2,2,1,1,3,3,1,1,3,3,3,3,2,2,0,0,2,2,1,1,3,3,3,3,0,0,3,3,3,3,0,0,1,1,1,1,0,0,2,2,3,3,3,3,3,3,0,0,2,2,3,3,1,1,1,1,2,2,0,0,1,1,1,1,2,2,3,3,3,3,1,1,1,1,2,2,1,1,3,3,3,3,0,0,0,0,3,3,1,1,0,0,1,1,1,1,0,0,0,0,1,1,2,2,3,3,1,1,1,1,0,0,2,2,2,2,3,3,1,1,0,0,2,2,1,1,3,3,1,1,1,1,1,1,2,2,2,2,0,0,1,1,2,2,3,3,1,1,1,1,2,2,0,0,3,3,1,1,1,1,0,0,0,0,2,2,0,0,3,3,2,2,2,2,2,2,2,2,2,2,1,1,2,2,3,3,1,1,1,1,3,3,3,3,2,2,2,2,2,2,3,3,2,2,2,2,3,3,2,2,0,0,0,0,2,2,3,3,1,1,0,0,3,3,2,2,0,0,2,2,0,0,0,0,0,0,0,0,2,2,2,2,1,1,0,0,3,3,1,1,0,0,0,0,0,0,3,3,0,0,0,0,3,3,3,3,3,3,1,1,1,1,1,1,2,2,0,0,3,3,1,1,0,0,0,0,0,0,3,3,0,0,3,3,1,1,0,0,3,3,1,1,3,3,3,3,2,2,2,2,1,1,0,0,2,2,2,2,0,0,2,2,1,1,1,1,1,1,3,3,0,0,3,3,1,1,2,2,0,0,2,2,3,3,2,2,3,3,2,2,1,1,3,3,2,2,1,1,1,1,1,1,3,3,3,3,0,0,1,1,3,3,3,3,0,0,3,3,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,0,0,3,3,1,1,0,0,0,0,2,2,1,1,1,1,0,0,1,1,1,1,3,3,1,1,3,3,0,0,3,3,0,0,3,3,1,1,1,1,1,1,2,2,1,1,3,3,1,1,2,2,2,2,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,3,3,0,0,0,0,1,1,1,1,3,3,2,2,1,1,3,3,1,1,3,3,1,1,2,2,2,2,2,2,1,1,3,3,0,0,2,2,2,2,2,2,2,2,3,3,1,1,3,3,3,3,3,3,2,2,0,0,0,0,3,3,0,0,1,1,1,1,2,2,3,3,1,1,2,2,2,2,1,1,2,2,3,3,0,0,0,0,2,2,1,1,0,0,1,1,2,2,0,0,2,2,2,2,1,1,2,2,2,2,2,2,0,0,2,2,3,3,2,2,1,1,3,3,2,2,1,1,0,0,1,1,0,0,0,0,2,2,0,0,0,0,2,2,0,0,1,1,1,1,1,1,2,2,2,2,1,1,1,1,3,3,0,0,3,3,2,2,1,1,1,1,0,0,2,2,2,2,1,1,3,3,0,0,1,1,3,3,1,1,1,1,3,3,0,0,0,0,0,0,2,2,2,2,2,2,1,1,0,0,1,1,0,0,3,3,2,2,2,2,2,2,1,1,0,0,2,2,3,3,2,2,3,3,3,3,2,2,2,2,0,0,0,0,2,2,3,3,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,3,3,1,1,2,2,1,1,3,3,3,3,3,3,3,3,0,0,0,0,0,0,2,2,3,3,0,0,3,3,3,3,2,2,1,1,3,3,1,1,0,0,3,3,0,0,2,2,3,3,1,1,0,0,1,1,3,3,0,0,3,3,0,0,0,0,1,1,0,0,0,0,3,3,1,1,2,2,1,1,1,1,0,0,2,2,0,0,3,3,0,0,3,3,1,1,2,2,1,1,1,1,1,1,0,0,0,0,2,2,0,0,1,1,1,1,0,0,0,0,2,2,1,1,0,0,2,2,1,1,2,2,2,2,0,0,3,3,0,0,3,3,1,1,0,0,2,2,1,1,2,2,2,2,2,2,2,2,1,1,2,2,1,1,0,0,2,2,0,0,1,1,3,3,0,0,0,0,2,2,3,3,3,3,1,1,0,0,3,3,2,2,0,0,3,3,2,2,1,1,3,3,3,3,2,2,1,1,0,0,3,3,1,1,0,0,0,0,2,2,0,0,2,2,0,0,3,3,2,2,0,0,1,1,2,2,1,1,2,2,3,3,2,2,2,2,3,3,1,1,0,0,0,0,2,2,2,2,0,0,1,1,1,1,1,1,3,3,3,3,3,3,0,0,0,0,1,1,0,0,0,0,3,3,2,2,2,2,2,2,3,3,0,0,0,0,3,3,3,3,1,1,0,0,0,0,1,1,1,1,1,1,0,0,3,3,1,1,2,2,1,1,2,2,1,1,0,0,3,3,0,0,1,1,0,0,1,1,1,1,0,0,3,3,2,2,0,0,0,0,3,3,2,2,0,0,1,1,2,2,2,2,1,1,2,2,3,3,1,1,0,0,3,3,2,2,0,0,2,2,1,1,0,0,0,0,3,3,1,1,2,2,1,1,1,1,2,2,0,0,1,1,0,0,1,1,3,3,0,0,3,3,1,1,3,3,1,1,0,0,3,3,2,2,0,0,2,2,0,0,3,3,1,1,0,0,0,0,3,3,1,1,3,3,3,3,2,2,2,2,1,1,3,3,1,1,2,2,3,3,3,3,2,2,1,1,0,0,1,1,3,3,2,2,2,2,1,1,0,0,1,1,2,2,3,3,3,3,0,0,0,0,2,2,1,1,1,1,3,3,3,3,0,0,0,0,3,3,3,3,0,0,2,2,2,2,0,0,2,2,3,3,0,0,3,3,0,0,0,0,0,0,3,3,1,1,3,3,3,3,1,1,1,1,3,3,1,1,3,3,1,1,3,3,1,1,0,0,3,3,3,3,2,2,2,2,0,0,0,0,1,1,2,2,3,3,1,1,0,0,2,2,1,1,3,3,2,2,2,2,3,3,1,1,0,0,0,0,2,2,0,0,3,3,0,0,3,3,2,2,2,2,1,1,0,0,2,2,1,1,1,1,0,0,1,1,3,3,3,3,2,2,0,0,3,3,1,1,2,2,2,2,3,3,3,3,0,0,0,0,0,0,3,3,1,1,0,0,0,0,1,1,2,2,1,1,0,0,3,3,2,2,2,2,2,2,0,0,0,0,1,1,2,2,0,0,0,0,3,3,0,0,1,1,3,3,0,0,0,0,3,3,3,3,2,2,0,0,1,1,1,1,2,2,2,2,1,1,0,0,3,3,3,3,1,1,1,1,2,2,2,2,3,3,1,1,2,2,1,1,0,0,0,0,3,3,0,0,1,1,2,2,1,1,0,0,0,0,0,0,2,2,2,2,3,3,0,0,0,0,3,3,2,2,0,0,3,3,2,2,0,0,1,1,1,1,2,2,0,0,1,1,0,0,0,0,1,1,3,3,1,1,2,2,3,3,0,0,0,0,0,0,1,1,0,0,1,1,0,0,2,2,3,3,1,1,2,2,3,3,0,0,3,3,1,1,1,1,1,1,3,3,0,0,3,3,2,2,3,3,3,3,1,1,1,1,1,1,0,0,0,0,2,2,2,2,2,2,3,3,1,1,1,1,0,0,0,0,2,2,3,3,0,0,2,2,1,1,3,3,0,0,3,3,2,2,2,2,3,3,0,0,1,1,1,1,2,2,2,2,1,1,2,2,2,2,0,0,1,1,1,1,1,1,3,3,1,1,0,0,0,0,0,0,0,0,3,3,1,1,3,3,1,1,3,3,1,1,1,1,3,3,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,3,3,3,3,0,0,2,2,1,1,3,3,1,1,0,0,2,2,1,1,1,1,3,3,1,1,0,0,2,2,1,1,1,1,2,2,1,1,0,0,0,0,3,3,1,1,1,1,2,2,1,1,3,3,2,2,1,1,1,1,1,1,1,1,2,2,0,0,3,3,1,1,2,2,1,1,2,2,1,1,0,0,3,3,0,0,1,1,0,0,2,2,3,3,1,1,0,0,3,3,1,1,3,3,3,3,3,3,0,0,3,3,3,3,3,3,2,2,0,0,0,0,2,2,0,0,2,2,2,2,0,0,3,3,1,1,1,1,2,2,0,0,3,3,0,0,3,3,2,2,3,3,0,0,0,0,1,1,2,2,2,2,2,2,1,1,1,1,2,2,1,1,2,2,0,0,2,2,2,2,1,1,2,2,1,1,0,0,3,3,3,3,2,2,2,2,3,3,0,0,2,2,3,3,2,2,3,3,2,2,3,3,0,0,0,0,0,0,0,0,0,0,2,2,1,1,2,2,0,0,0,0,0,0,0,0,1,1,2,2,3,3,3,3,2,2,0,0,2,2,0,0,1,1,1,1,0,0,1,1,1,1,3,3,2,2,3,3,3,3,1,1,1,1,0,0,3,3,3,3,0,0,2,2,0,0,1,1,3,3,3,3,1,1,1,1,3,3,1,1,0,0,0,0,3,3,2,2,1,1,3,3,3,3,2,2,1,1,2,2,1,1,2,2,2,2,0,0,3,3,2,2,3,3,1,1,2,2,0,0,3,3,1,1,3,3,0,0,0,0,2,2,3,3,2,2,2,2,3,3,2,2,1,1,3,3,3,3,3,3,2,2,2,2,1,1,0,0,3,3,2,2,2,2,2,2,1,1,2,2,3,3,0,0,2,2,2,2,3,3,1,1,3,3,1,1,0,0,1,1,1,1,3,3,0,0,2,2,1,1,1,1,1,1,2,2,3,3,0,0,3,3,2,2,3,3,1,1,1,1,2,2,0,0,1,1,2,2,0,0,1,1,3,3,0,0,1,1,0,0,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,1,1,3,3,2,2,2,2,2,2,1,1,1,1,2,2,2,2,3,3,2,2,3,3,0,0,0,0,0,0,3,3,2,2,0,0,2,2,0,0,1,1,3,3,0,0,1,1,1,1,1,1,2,2,3,3,3,3,3,3,2,2,2,2,3,3,1,1,3,3,3,3,2,2,0,0,3,3,0,0,2,2,2,2,0,0,3,3,1,1,2,2,3,3,3,3,0,0,0,0,0,0,1,1,0,0,2,2,2,2,3,3,2,2,3,3,1,1,1,1,0,0,0,0,2,2,3,3,2,2,0,0,2,2,3,3,3,3,0,0,3,3,0,0,2,2,3,3,0,0,0,0,1,1,1,1,2,2,0,0,2,2,2,2,3,3,1,1,1,1,0,0,3,3,3,3,2,2,1,1,1,1,2,2,0,0,2,2,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,2,2,2,2,1,1,3,3,0,0,2,2,2,2,3,3,2,2,2,2,1,1,1,1,2,2,3,3,0,0,1,1,3,3,3,3,1,1,0,0,2,2,3,3,1,1,1,1,1,1,1,1,1,1,0,0,3,3,1,1,1,1,3,3,2,2,3,3,1,1,3,3,3,3,2,2,2,2,3,3,1,1,1,1,1,1,3,3,3,3,2,2,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,2,2,3,3,3,3,0,0,1,1,2,2,0,0,2,2,1,1,2,2,1,1,3,3,0,0,3,3,1,1,1,1,1,1,1,1,3,3,0,0,3,3,1,1,2,2,1,1,0,0,3,3,3,3,3,3,1,1,1,1,2,2,3,3,1,1,0,0,2,2,2,2,3,3,0,0,1,1,1,1,2,2,2,2,1,1,1,1,3,3,2,2,2,2,3,3,0,0,1,1,1,1,3,3,0,0,1,1,2,2,0,0,1,1,2,2,1,1,3,3,2,2,3,3,0,0,3,3,1,1,0,0,1,1,0,0,3,3,1,1,1,1,2,2,0,0,1,1,1,1,2,2,1,1,1,1,0,0,0,0,3,3,2,2,3,3,2,2,1,1,1,1,3,3,3,3,2,2,2,2,2,2,2,2,2,2,1,1,3,3,3,3,1,1,1,1,0,0,1,1,0,0,0,0,2,2,3,3,0,0,1,1,2,2,3,3,3,3,0,0,3,3,3,3,2,2,0,0,0,0,3,3,2,2,3,3,1,1,0,0,2,2,3,3,3,3,0,0,3,3,2,2,2,2,3,3,2,2,1,1,2,2,0,0,1,1,2,2,1,1,0,0,3,3,0,0,3,3,1,1,1,1,2,2,2,2,0,0,1,1,2,2,0,0,0,0,3,3,0,0,1,1,1,1,0,0,2,2,3,3,0,0,0,0,3,3,1,1,3,3,2,2,1,1,0,0,2,2,1,1,0,0,0,0,1,1,0,0,3,3,1,1,2,2,1,1,0,0,3,3,1,1,2,2,2,2,0,0,1,1,0,0,1,1,1,1,2,2,1,1,2,2,0,0,1,1,0,0,3,3,0,0,2,2,1,1,3,3,3,3,0,0,3,3,3,3,2,2,0,0,0,0,2,2,3,3,0,0,3,3,2,2,1,1,2,2,1,1,1,1,1,1,0,0,0,0,2,2,3,3,3,3,1,1,0,0,0,0,2,2,3,3,0,0,0,0,2,2,1,1,1,1,0,0,3,3,0,0,1,1,1,1,0,0,3,3,3,3,3,3,3,3,2,2,1,1,0,0,2,2,0,0,3,3,1,1,1,1,3,3,2,2,0,0,1,1,2,2,1,1,3,3,1,1,2,2,3,3,3,3,3,3,3,3,0,0,3,3,3,3,2,2,1,1,3,3,3,3,3,3,0,0,1,1,2,2,3,3,2,2,3,3,0,0,2,2,1,1,0,0,3,3,0,0,3,3,1,1,3,3,0,0,2,2,3,3,3,3,2,2,0,0,3,3,0,0,3,3,2,2,0,0,3,3,3,3,2,2,1,1,2,2,2,2,1,1,0,0,0,0,3,3,0,0,0,0,2,2,2,2,1,1,2,2,2,2,1,1,2,2,3,3,3,3,0,0,0,0,2,2,1,1,2,2,0,0,1,1,3,3,0,0,0,0,1,1,2,2,0,0,0,0,3,3,2,2,3,3,1,1,1,1,0,0,2,2,3,3,0,0,1,1,0,0,0,0,0,0,1,1,2,2,0,0,3,3,1,1,2,2,3,3,2,2,0,0,0,0,3,3,0,0,1,1,0,0,3,3,1,1,0,0,1,1,3,3,2,2,0,0,3,3,1,1,2,2,2,2,0,0,1,1,2,2,1,1,1,1,1,1,1,1,3,3,1,1,1,1,3,3,2,2,2,2,1,1,2,2,2,2,3,3,0,0,2,2,1,1,0,0,0,0,0,0,0,0,3,3,2,2,3,3,3,3,3,3,3,3,2,2,1,1,3,3,1,1,0,0,2,2,1,1,1,1,0,0,1,1,1,1,3,3,2,2,0,0,1,1,0,0,3,3,2,2,1,1,3,3,1,1,3,3,0,0,0,0,0,0,3,3,1,1,3,3,1,1,1,1,2,2,2,2,1,1,3,3,0,0,2,2,2,2,0,0,2,2,3,3,3,3,0,0,2,2,3,3,3,3,2,2,3,3,1,1,0,0,3,3,0,0,1,1,3,3,0,0,3,3,0,0,3,3,0,0,2,2,1,1,3,3,1,1,2,2,3,3,0,0,3,3,2,2,3,3,3,3,0,0,3,3,3,3,1,1,0,0,1,1,0,0,1,1,3,3,0,0,1,1,1,1,3,3,3,3,3,3,2,2,1,1,0,0,2,2,3,3,0,0,1,1,2,2,2,2,1,1,0,0,3,3,3,3,0,0,0,0,1,1,1,1,2,2,3,3,1,1,3,3,0,0,0,0,3,3,3,3,2,2,3,3,3,3,3,3,1,1,2,2,3,3,2,2,0,0,0,0,1,1,0,0,0,0,2,2,0,0,1,1,1,1,2,2,1,1,2,2,3,3,0,0,0,0,3,3,3,3,0,0,2,2,2,2,3,3,3,3,1,1,0,0,3,3,2,2,0,0,2,2,2,2,3,3,2,2,3,3,3,3,0,0,2,2,1,1,3,3,1,1,0,0,0,0,0,0,0,0,2,2,0,0,1,1,2,2,3,3,0,0,3,3,0,0,2,2,0,0,2,2,2,2,3,3,1,1,3,3,0,0,0,0,0,0,2,2,0,0,1,1,3,3,2,2,2,2,0,0,3,3,0,0,2,2,0,0,3,3,3,3,1,1,3,3,2,2,0,0,2,2,0,0,1,1,3,3,0,0,2,2,0,0,2,2,2,2,3,3,1,1,1,1,0,0,3,3,3,3,3,3,0,0,1,1,0,0,2,2,3,3,2,2,2,2,0,0,3,3,0,0,0,0,3,3,2,2,2,2,1,1,0,0,3,3,0,0,0,0,0,0,3,3,3,3,1,1,0,0,3,3,1,1,3,3,0,0,3,3,2,2,0,0,0,0,2,2,0,0,3,3,0,0,1,1,2,2,3,3,3,3,3,3,2,2,3,3,3,3,1,1,2,2,0,0,3,3,3,3,1,1,1,1,2,2,2,2,2,2,0,0,2,2,0,0,0,0,3,3,2,2,2,2,3,3,1,1,3,3,0,0,1,1,1,1,1,1,0,0,3,3,1,1,0,0,0,0,3,3,2,2,0,0,3,3,1,1,2,2,2,2,1,1,0,0,2,2,1,1,2,2,3,3,0,0,2,2,1,1,0,0,1,1,2,2,1,1,3,3,0,0,0,0,0,0,3,3,0,0,0,0,2,2,2,2,0,0,1,1,0,0,0,0,3,3,1,1,1,1,3,3,1,1,0,0,3,3,1,1,2,2,0,0,2,2,1,1,2,2,3,3,2,2,0,0,0,0,0,0,3,3,3,3,3,3,3,3,0,0,3,3,1,1,0,0,3,3,3,3,0,0,2,2,2,2,3,3,0,0,3,3,1,1,2,2,2,2,0,0,3,3,2,2,0,0,3,3,0,0,3,3,1,1,2,2,2,2,3,3,0,0,1,1,0,0,0,0,1,1,1,1,2,2,0,0,3,3,1,1,3,3,0,0,0,0,1,1,1,1,2,2,3,3,0,0,2,2,0,0,2,2,3,3,2,2,0,0,2,2,3,3,0,0,1,1,1,1,2,2,2,2,0,0,0,0,2,2,2,2,2,2,0,0,0,0,3,3,3,3,0,0,0,0,1,1,2,2,0,0,2,2,2,2,0,0,0,0,0,0,1,1,0,0,1,1,3,3,0,0,1,1,0,0,1,1,3,3,3,3,2,2,0,0,0,0,0,0,2,2,0,0,0,0,2,2,2,2,1,1,2,2,2,2,1,1,2,2,1,1,2,2,3,3,0,0,2,2,0,0,2,2,2,2,1,1,0,0,3,3,0,0,3,3,2,2,3,3,1,1,1,1,1,1,2,2,3,3,2,2,3,3,0,0,1,1,1,1,1,1,0,0,3,3,3,3,0,0,2,2,1,1,3,3,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,3,3,3,3,2,2,1,1,0,0,0,0,3,3,3,3,2,2,2,2,1,1,3,3,1,1,2,2,3,3,3,3,1,1,1,1,0,0,0,0,2,2,1,1,1,1,3,3,3,3,2,2,2,2,3,3,0,0,2,2,1,1,0,0,1,1,3,3,1,1,0,0,2,2,3,3,1,1,3,3,1,1,0,0,3,3,0,0,1,1,3,3,3,3,2,2,1,1,0,0,0,0,3,3,0,0,1,1,1,1,1,1,2,2,3,3,1,1,1,1,0,0,2,2,3,3,0,0,2,2,1,1,0,0,0,0,0,0,0,0,3,3,1,1,2,2,1,1,0,0,0,0,2,2,0,0,2,2,0,0,1,1,1,1,2,2,3,3,2,2,2,2,0,0,0,0,3,3,2,2,0,0,1,1,0,0,2,2,0,0,1,1,1,1,2,2,0,0,3,3,3,3,3,3,2,2,2,2,1,1,0,0,1,1,1,1,1,1,1,1,2,2,0,0,0,0,1,1,1,1,1,1,1,1,0,0,2,2,1,1,2,2,0,0,3,3,0,0,2,2,1,1,1,1,1,1,2,2,0,0,1,1,1,1,2,2,2,2,1,1,2,2,3,3,3,3,1,1,0,0,0,0,2,2,1,1,1,1,2,2,2,2,3,3,3,3,1,1,3,3,0,0,1,1,2,2,2,2,3,3,2,2,0,0,2,2,2,2,3,3,0,0,1,1,1,1,1,1,2,2,0,0,1,1,0,0,2,2,3,3,2,2,0,0,2,2,3,3,2,2,3,3,0,0,3,3,0,0,3,3,3,3,2,2,3,3,2,2,0,0,1,1,0,0,1,1,3,3,3,3,1,1,0,0,2,2,0,0,2,2,1,1,3,3,0,0,1,1,0,0,2,2,0,0,3,3,1,1,1,1,1,1,0,0,0,0,0,0,2,2,0,0,2,2,1,1,2,2,1,1,3,3,2,2,0,0,3,3,2,2,0,0,1,1,3,3,0,0,1,1,1,1,2,2,3,3,3,3,3,3,3,3,2,2,2,2,1,1,0,0,3,3,2,2,2,2,2,2,1,1,0,0,1,1,2,2,0,0,3,3,0,0,3,3,0,0,0,0,0,0,3,3,3,3,2,2,2,2,1,1,2,2,1,1,2,2,3,3,3,3,3,3,0,0,1,1,0,0,0,0,2,2,3,3,1,1,2,2,3,3,0,0,1,1,2,2,2,2,0,0,2,2,3,3,1,1,0,0,3,3,1,1,2,2,0,0,2,2,0,0,0,0,2,2,0,0,2,2,3,3,1,1,1,1,3,3,2,2,3,3,2,2,0,0,1,1,0,0,0,0,2,2,1,1,1,1,0,0,2,2,1,1,1,1,0,0,1,1,0,0,2,2,0,0,3,3,3,3,3,3,1,1,1,1,3,3,1,1,0,0,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,3,3,3,3,2,2,0,0,1,1,1,1,1,1,1,1,0,0,0,0,3,3,2,2,3,3,3,3,0,0,1,1,0,0,3,3,0,0,1,1,1,1,0,0,2,2,2,2,0,0,1,1,0,0,2,2,3,3,3,3,1,1,3,3,0,0,3,3,0,0,1,1,3,3,0,0,1,1,2,2,2,2,3,3,3,3,2,2,0,0,0,0,0,0,0,0,2,2,3,3,3,3,1,1,1,1,0,0,3,3,2,2,3,3,3,3,0,0,0,0,2,2,2,2,2,2,2,2,0,0,3,3,1,1,1,1,2,2,3,3,1,1,0,0,0,0,0,0,2,2,0,0,0,0,0,0,3,3,3,3,0,0,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,0,0,1,1,1,1,3,3,2,2,0,0,1,1,0,0,0,0,1,1,0,0,2,2,3,3,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,2,2,0,0,2,2,3,3,0,0,2,2,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,3,3,1,1,2,2,1,1,3,3,3,3,3,3,1,1,0,0,0,0,2,2,3,3,3,3,0,0,1,1,2,2,2,2,3,3,2,2,0,0,2,2,0,0,0,0,3,3,2,2,3,3,0,0,0,0,2,2,2,2,2,2,3,3,2,2,2,2,2,2,0,0,1,1,0,0,0,0,0,0,3,3,0,0,3,3,1,1,2,2,0,0,2,2,2,2,2,2,2,2,3,3,1,1,3,3,1,1,1,1,1,1,2,2,1,1,0,0,0,0,2,2,2,2,2,2,3,3,2,2,0,0,1,1,2,2,2,2,3,3,1,1,1,1,2,2,3,3,2,2,1,1,3,3,2,2,1,1,1,1,2,2,2,2,1,1,1,1,1,1,2,2,2,2,0,0,1,1,2,2,2,2,1,1,0,0,3,3,0,0,1,1,1,1,1,1,1,1,1,1,3,3,0,0,2,2,2,2,2,2,3,3,2,2,1,1,1,1,2,2,0,0,0,0,0,0,3,3,1,1,3,3,1,1,1,1,3,3,2,2,0,0,0,0,0,0,0,0,0,0,0,0,1,1,3,3,2,2,1,1,1,1,0,0,3,3,2,2,1,1,0,0,0,0,0,0,2,2,2,2,0,0,2,2,3,3,2,2,2,2,0,0,0,0,1,1,3,3,2,2,2,2,0,0,3,3,1,1,2,2,2,2,3,3,1,1,3,3,1,1,0,0,3,3,1,1,3,3,0,0,0,0,0,0,2,2,3,3,2,2,0,0,0,0,2,2,3,3,2,2,3,3,0,0,1,1,0,0,1,1,3,3,3,3,1,1,2,2,2,2,1,1,1,1,2,2,2,2,0,0,2,2,2,2,1,1,0,0,3,3,2,2,2,2,2,2,3,3,0,0,1,1,1,1,2,2,2,2,2,2,3,3,2,2,1,1,1,1,0,0,0,0,2,2,0,0,3,3,2,2,3,3,2,2,1,1,2,2,3,3,0,0,3,3,3,3,1,1,3,3,1,1,1,1,1,1,2,2,1,1,2,2,2,2,3,3,2,2,3,3,2,2,2,2,1,1,1,1,2,2,2,2,1,1,1,1,1,1,0,0,3,3,1,1,0,0,1,1,1,1,1,1,0,0,2,2,1,1,2,2,0,0,0,0,2,2,1,1,1,1,2,2,2,2,1,1,0,0,0,0,0,0,2,2,2,2,0,0,2,2,0,0,1,1,1,1,1,1,2,2,1,1,3,3,3,3,2,2,2,2,0,0,1,1,2,2,1,1,2,2,2,2,1,1,0,0,3,3,3,3,1,1,2,2,3,3,1,1,2,2,3,3,1,1,2,2,0,0,3,3,1,1,1,1,0,0,1,1,0,0,0,0,3,3,2,2,3,3,0,0,3,3,2,2,0,0,0,0,2,2,3,3,0,0,0,0,3,3,2,2,1,1,3,3,3,3,1,1,2,2,0,0,1,1,3,3,0,0,0,0,2,2,0,0,1,1,0,0,2,2,2,2,3,3,3,3,1,1,2,2,2,2,0,0,2,2,2,2,0,0,3,3,0,0,3,3,1,1,3,3,3,3,1,1,2,2,2,2,0,0,2,2,2,2,0,0,0,0,3,3,0,0,3,3,2,2,1,1,0,0,1,1,1,1,2,2,3,3,3,3,3,3,1,1,0,0,1,1,0,0,1,1,0,0,3,3,1,1,2,2,3,3,2,2,2,2,1,1,2,2,3,3,0,0,2,2,2,2,0,0,3,3,0,0,0,0,1,1,3,3,1,1,0,0,1,1,1,1,3,3,3,3,2,2,0,0,1,1,0,0,3,3,1,1,0,0,0,0,0,0,0,0,2,2,2,2,1,1,3,3,0,0,1,1,3,3,2,2,1,1,0,0,2,2,3,3,0,0,1,1,1,1,3,3,2,2,0,0,2,2,2,2,1,1,1,1,0,0,0,0,3,3,1,1,3,3,2,2,2,2,1,1,1,1,0,0,1,1,2,2,3,3,3,3,1,1,1,1,3,3,1,1,1,1,1,1,2,2,0,0,0,0,2,2,2,2,2,2,1,1,0,0,1,1,0,0,2,2,3,3,2,2,1,1,3,3,0,0,0,0,1,1,0,0,2,2,1,1,3,3,0,0,2,2,0,0,1,1,1,1,1,1,2,2,1,1,2,2,0,0,0,0,2,2,1,1,3,3,0,0,0,0,0,0,1,1,1,1,3,3,1,1,0,0,1,1,0,0,1,1,2,2,0,0,2,2,1,1,1,1,3,3,2,2,3,3,2,2,1,1,2,2,0,0,2,2,1,1,0,0,1,1,1,1,3,3,2,2,1,1,1,1,1,1,1,1,3,3,3,3,2,2,1,1,2,2,3,3,2,2,2,2,3,3,3,3,2,2,0,0,3,3,0,0,1,1,2,2,0,0,3,3,0,0,0,0,0,0,1,1,1,1,0,0,3,3,2,2,2,2,1,1,0,0,1,1,1,1,3,3,3,3,0,0,3,3,1,1,0,0,0,0,2,2,3,3,0,0,3,3,0,0,3,3,3,3,2,2,1,1,2,2,2,2,3,3,3,3,3,3,3,3,3,3,0,0,2,2,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,2,2,3,3,3,3,2,2,3,3,2,2,1,1,3,3,1,1,1,1,1,1,0,0,1,1,1,1,2,2,1,1,2,2,0,0,0,0,1,1,2,2,3,3,3,3,1,1,1,1,3,3,1,1,1,1,0,0,3,3,1,1,2,2,0,0,1,1,0,0,1,1,2,2,3,3,2,2,2,2,3,3,1,1,0,0,0,0,2,2,3,3,2,2,3,3,1,1,2,2,3,3,2,2,2,2,0,0,3,3,0,0,2,2,2,2,1,1,0,0,1,1,3,3,0,0,0,0,3,3,3,3,0,0,0,0,2,2,0,0,1,1,2,2,1,1,2,2,0,0,1,1,0,0,0,0,1,1,3,3,1,1,2,2,2,2,3,3,3,3,0,0,3,3,3,3,1,1,1,1,3,3,2,2,2,2,3,3,1,1,3,3,3,3,3,3,3,3,1,1,1,1,2,2,2,2,1,1,1,1,3,3,1,1,0,0,2,2,1,1,0,0,2,2,1,1,1,1,1,1,3,3,1,1,3,3,2,2,0,0,0,0,2,2,1,1,2,2,3,3,2,2,1,1,2,2,2,2,0,0,2,2,2,2,0,0,3,3,2,2,0,0,0,0,2,2,0,0,2,2,3,3,1,1,2,2,2,2,2,2,2,2,3,3,3,3,0,0,1,1,0,0,0,0,3,3,3,3,2,2,2,2,0,0,0,0,3,3,0,0,2,2,1,1,3,3,3,3,2,2,3,3,2,2,0,0,0,0,2,2,2,2,3,3,2,2,2,2,1,1,2,2,3,3,1,1,3,3,1,1,0,0,0,0,1,1,1,1,2,2,1,1,1,1,0,0,3,3,2,2,1,1,1,1,3,3,3,3,1,1,3,3,3,3,3,3,2,2,0,0,0,0,1,1,0,0,2,2,3,3,0,0,1,1,1,1,3,3,0,0,2,2,1,1,0,0,1,1,2,2,0,0,0,0,0,0,1,1,1,1,0,0,3,3,0,0,3,3,1,1,3,3,0,0,2,2,0,0,3,3,0,0,0,0,2,2,3,3,2,2,1,1,1,1,0,0,2,2,0,0,0,0,1,1,3,3,2,2,0,0,3,3,3,3,0,0,2,2,2,2,3,3,0,0,2,2,1,1,2,2,1,1,0,0,3,3,2,2,2,2,2,2,2,2,3,3,1,1,0,0,1,1,2,2,2,2,0,0,1,1,1,1,2,2,0,0,2,2,0,0,3,3,3,3,1,1,1,1,2,2,2,2,0,0,3,3,1,1,0,0,2,2,0,0,2,2,1,1,1,1,3,3,2,2,0,0,3,3,1,1,0,0,1,1,0,0,3,3,1,1,3,3,0,0,3,3,0,0,2,2,3,3,1,1,0,0,3,3,1,1,2,2,2,2,0,0,1,1,0,0,2,2,0,0,1,1,2,2,0,0,2,2,2,2,2,2,1,1,0,0,3,3,2,2,0,0,0,0,1,1,3,3,1,1,3,3,3,3,3,3,0,0,2,2,3,3,0,0,3,3,2,2,1,1,1,1,1,1,1,1,1,1,0,0,1,1,2,2,0,0,3,3,1,1,0,0,0,0,2,2,0,0,0,0,0,0,2,2,0,0,2,2,3,3,0,0,1,1,0,0,2,2,2,2,2,2,3,3,0,0,2,2,1,1,1,1,0,0,3,3,1,1,2,2,2,2,0,0,2,2,3,3,0,0,3,3,1,1,3,3,1,1,2,2,2,2,0,0,3,3,1,1,0,0,2,2,0,0,3,3,1,1,1,1,2,2,0,0,0,0,1,1,1,1,3,3,1,1,0,0,1,1,1,1,0,0,0,0,1,1,3,3,0,0,0,0,3,3,2,2,3,3,2,2,2,2,3,3,0,0,2,2,0,0,0,0,0,0,3,3,3,3,0,0,2,2,1,1,0,0,0,0,0,0,2,2,2,2,1,1,1,1,1,1,3,3,3,3,3,3,1,1,3,3,0,0,2,2,0,0,3,3,2,2,2,2,2,2,1,1,3,3,3,3,2,2,1,1,2,2,0,0,2,2,3,3,1,1,1,1,0,0,2,2,2,2,1,1,2,2,2,2,2,2,1,1,1,1,1,1,0,0,2,2,1,1,2,2,2,2,2,2,1,1,3,3,1,1,2,2,2,2,3,3,1,1,3,3,3,3,2,2,3,3,3,3,0,0,0,0,3,3,3,3,0,0,3,3,0,0,0,0,3,3,3,3,0,0,0,0,1,1,2,2,1,1,3,3,2,2,0,0,0,0,2,2,2,2,2,2,2,2,1,1,2,2,2,2,3,3,0,0,2,2,3,3,2,2,2,2,3,3,2,2,1,1,0,0,0,0,0,0,3,3,1,1,1,1,3,3,3,3,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,2,2,1,1,2,2,2,2,2,2,0,0,0,0,3,3,3,3,1,1,0,0,3,3,1,1,2,2,3,3,0,0,2,2,3,3,0,0,0,0,3,3,3,3,0,0,0,0,2,2,1,1,3,3,2,2,0,0,3,3,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,3,3,2,2,3,3,3,3,2,2,3,3,2,2,3,3,0,0,0,0,1,1,1,1,3,3,1,1,3,3,2,2,0,0,0,0,0,0,3,3,0,0,1,1,2,2,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,2,2,3,3,3,3,3,3,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,3,3,3,3,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,2,2,2,2,3,3,2,2,0,0,2,2,1,1,3,3,3,3,2,2,3,3,2,2,2,2,2,2,0,0,3,3,2,2,3,3,1,1,1,1,1,1,3,3,2,2,2,2,1,1,2,2,3,3,0,0,2,2,0,0,3,3,3,3,1,1,3,3,2,2,0,0,1,1,1,1,3,3,2,2,1,1,2,2,2,2,1,1,3,3,2,2,2,2,2,2,3,3,3,3,3,3,1,1,0,0,0,0,1,1,1,1,1,1,2,2,0,0,1,1,1,1,1,1,0,0,2,2,0,0,1,1,2,2,3,3,1,1,2,2,2,2,0,0,1,1,1,1,2,2,3,3,0,0,2,2,0,0,0,0,1,1,1,1,3,3,2,2,0,0,2,2,0,0,2,2,1,1,3,3,0,0,2,2,3,3,2,2,2,2,1,1,3,3,2,2,3,3,0,0,0,0,1,1,0,0,2,2,1,1,1,1,0,0,2,2,1,1,2,2,3,3,2,2,0,0,2,2,0,0,0,0,1,1,1,1,3,3,2,2,0,0,0,0,2,2,0,0,0,0,1,1,1,1,0,0,1,1,3,3,1,1,3,3,2,2,2,2,1,1,2,2,2,2,1,1,2,2,2,2,3,3,0,0,2,2,1,1,3,3,1,1,0,0,2,2,3,3,2,2,1,1,1,1,0,0,3,3,0,0,3,3,3,3,3,3,2,2,1,1,0,0,0,0,3,3,3,3,1,1,2,2,2,2,2,2,0,0,1,1,1,1,3,3,0,0,1,1,2,2,1,1,0,0,3,3,0,0,3,3,0,0,3,3,3,3,3,3,2,2,1,1,0,0,1,1,0,0,1,1,1,1,0,0,3,3,1,1,1,1,2,2,2,2,3,3,0,0,1,1,0,0,1,1,0,0,3,3,2,2,0,0,3,3,0,0,1,1,2,2,2,2,3,3,3,3,3,3,2,2,2,2,0,0,1,1,3,3,1,1,0,0,0,0,3,3,2,2,2,2,3,3,3,3,0,0,2,2,2,2,2,2,1,1,0,0,1,1,2,2,3,3,2,2,0,0,0,0,2,2,0,0,2,2,2,2,3,3,0,0,3,3,3,3,0,0,0,0,0,0,1,1,3,3,1,1,3,3,1,1,3,3,2,2,0,0,0,0,0,0,0,0,3,3,3,3,1,1,0,0,0,0,1,1,3,3,0,0,1,1,2,2,1,1,1,1,2,2,1,1,0,0,2,2,3,3,0,0,0,0,2,2,2,2,2,2,1,1,0,0,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0,0,2,2,0,0,3,3,0,0,2,2,2,2,0,0,0,0,3,3,2,2,0,0,1,1,2,2,3,3,0,0,1,1,0,0,0,0,0,0,2,2,2,2,2,2,2,2,3,3,0,0,2,2,1,1,2,2,0,0,3,3,3,3,1,1,3,3,3,3,3,3,0,0,2,2,0,0,3,3,0,0,3,3,3,3,0,0,2,2,1,1,1,1,0,0,2,2,0,0,2,2,2,2,3,3,1,1,2,2,3,3,3,3,0,0,3,3,2,2,1,1,1,1,3,3,1,1,3,3,2,2,2,2,1,1,1,1,3,3,2,2,0,0,1,1,1,1,0,0,2,2,0,0,3,3,2,2,1,1,3,3,1,1,1,1,0,0,3,3,3,3,3,3,1,1,1,1,3,3,3,3,0,0,3,3,3,3,0,0,1,1,1,1,0,0,2,2,2,2,0,0,0,0,1,1,1,1,2,2,0,0,3,3,1,1,0,0,2,2,2,2,0,0,3,3,0,0,2,2,1,1,0,0,2,2,0,0,3,3,3,3,2,2,0,0,0,0,1,1,2,2,1,1,2,2,1,1,3,3,2,2,1,1,0,0,2,2,3,3,2,2,3,3,0,0,0,0,2,2,0,0,0,0,0,0,2,2,3,3,2,2,0,0,3,3,3,3,2,2,3,3,0,0,1,1,1,1,2,2,2,2,1,1,0,0,2,2,0,0,2,2,2,2,3,3,2,2,0,0,0,0,1,1,0,0,0,0,0,0,1,1,2,2,2,2,3,3,3,3,2,2,0,0,2,2,2,2,3,3,2,2,2,2,3,3,0,0,3,3,1,1,0,0,2,2,3,3,0,0,1,1,2,2,0,0,2,2,2,2,1,1,2,2,0,0,1,1,0,0,2,2,0,0,3,3,0,0,1,1,0,0,1,1,3,3,0,0,0,0,0,0,3,3,3,3,2,2,1,1,0,0,2,2,3,3,3,3,1,1,1,1,2,2,2,2,1,1,2,2,1,1,3,3,3,3,2,2,0,0,2,2,3,3,1,1,1,1,0,0,0,0,3,3,1,1,2,2,1,1,3,3,0,0,1,1,3,3,1,1,2,2,1,1,2,2,1,1,2,2,2,2,0,0,0,0,3,3,0,0,3,3,3,3,0,0,2,2,1,1,0,0,1,1,2,2,1,1,3,3,3,3,3,3,0,0,2,2,1,1,3,3,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,2,2,3,3,3,3,2,2,3,3,0,0,0,0,3,3,0,0,3,3,0,0,2,2,3,3,2,2,2,2,1,1,3,3,3,3,2,2,2,2,2,2,2,2,3,3,0,0,3,3,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,0,0,3,3,2,2,0,0,1,1,2,2,2,2,2,2,2,2,3,3,1,1,2,2,1,1,1,1,3,3,0,0,0,0,2,2,0,0,2,2,2,2,0,0,3,3,1,1,2,2,0,0,0,0,3,3,1,1,2,2,0,0,2,2,0,0,0,0,2,2,2,2,2,2,3,3,1,1,2,2,1,1,2,2,3,3,1,1,0,0,0,0,3,3,0,0,2,2,2,2,3,3,1,1,3,3,3,3,2,2,0,0,2,2,1,1,1,1,0,0,2,2,3,3,0,0,1,1,3,3,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,2,2,0,0,1,1,1,1,0,0,3,3,1,1,2,2,3,3,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,2,2,0,0,1,1,1,1,2,2,0,0,2,2,0,0,3,3,1,1,0,0,1,1,2,2,3,3,1,1,3,3,1,1,0,0,0,0,3,3,3,3,0,0,0,0,1,1,1,1,2,2,3,3,0,0,2,2,1,1,1,1,0,0,3,3,0,0,2,2,3,3,0,0,2,2,0,0,1,1,2,2,3,3,1,1,3,3,1,1,1,1,2,2,3,3,0,0,3,3,1,1,1,1,1,1,3,3,1,1,2,2,1,1,0,0,3,3,2,2,1,1,1,1,2,2,3,3,0,0,1,1,0,0,0,0,1,1,1,1,2,2,1,1,2,2,1,1,3,3,0,0,0,0,0,0,3,3,3,3,3,3,2,2,3,3,1,1,1,1,2,2,3,3,0,0,2,2,0,0,3,3,2,2,3,3,1,1,3,3,2,2,0,0,2,2,2,2,1,1,2,2,0,0,2,2,0,0,0,0,0,0,3,3,1,1,0,0,1,1,0,0,2,2,1,1,1,1,0,0,0,0,3,3,0,0,2,2,0,0,1,1,2,2,1,1,2,2,2,2,1,1,2,2,3,3,3,3,2,2,0,0,0,0,3,3,2,2,2,2,0,0,2,2,0,0,0,0,2,2,0,0,3,3,3,3,2,2,0,0,1,1,3,3,1,1,2,2,3,3,2,2,1,1,2,2,2,2,2,2,3,3,3,3,0,0,3,3,3,3,0,0,1,1,2,2,3,3,1,1,0,0,0,0,0,0,1,1,0,0,2,2,2,2,0,0,2,2,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,3,3,3,3,0,0,0,0,2,2,0,0,1,1,0,0,3,3,0,0,1,1,2,2,1,1,0,0,1,1,0,0,2,2,3,3,2,2,0,0,3,3,0,0,2,2,3,3,1,1,3,3,2,2,2,2,1,1,0,0,0,0,1,1,0,0,2,2,0,0,2,2,0,0,0,0,1,1,0,0,3,3,1,1,1,1,1,1,2,2,0,0,0,0,1,1,3,3,3,3,3,3,3,3,0,0,2,2,0,0,0,0,1,1,0,0,0,0,3,3,0,0,2,2,2,2,2,2,0,0,1,1,2,2,0,0,2,2,2,2,1,1,0,0,2,2,0,0,0,0,0,0,3,3,1,1,1,1,3,3,1,1,2,2,0,0,2,2,2,2,2,2,2,2,2,2,0,0,2,2,0,0,0,0,1,1,3,3,0,0,0,0,3,3,1,1,0,0,1,1,0,0,2,2,2,2,1,1,2,2,2,2,3,3,1,1,1,1,0,0,0,0,2,2,1,1,3,3,2,2,0,0,3,3,0,0,3,3,0,0,0,0,2,2,3,3,3,3,1,1,3,3,0,0,1,1,2,2,3,3,2,2,0,0,0,0,1,1,0,0,0,0,1,1,1,1,3,3,1,1,1,1,1,1,1,1,3,3,3,3,2,2,0,0,1,1,3,3,0,0,2,2,2,2,0,0,2,2,1,1,2,2,1,1,3,3,2,2,0,0,1,1,2,2,3,3,2,2,1,1,3,3,0,0,0,0,0,0,3,3,0,0,1,1,2,2,3,3,0,0,3,3,2,2,1,1,2,2,2,2,0,0,1,1,1,1,2,2,1,1,1,1,3,3,0,0,1,1,0,0,0,0,2,2,1,1,3,3,0,0,0,0,3,3,2,2,0,0,1,1,3,3,1,1,3,3,2,2,2,2,2,2,3,3,3,3,1,1,1,1,0,0,2,2,1,1,2,2,0,0,2,2,2,2,0,0,0,0,3,3,2,2,0,0,0,0,3,3,0,0,2,2,1,1,3,3,2,2,2,2,2,2,0,0,2,2,2,2,1,1,2,2,1,1,1,1,2,2,3,3,2,2,0,0,3,3,3,3,0,0,3,3,3,3,2,2,3,3,2,2,3,3,2,2,2,2,1,1,0,0,2,2,3,3,3,3,1,1,1,1,1,1,3,3,2,2,2,2,1,1,0,0,2,2,3,3,0,0,2,2,2,2,1,1,1,1,3,3,2,2,2,2,1,1,2,2,0,0,1,1,2,2,0,0,2,2,2,2,2,2,3,3,3,3,1,1,0,0,2,2,1,1,0,0,2,2,2,2,0,0,2,2,0,0,2,2,2,2,1,1,1,1,2,2,3,3,1,1,1,1,0,0,0,0,0,0,3,3,0,0,0,0,1,1,3,3,0,0,1,1,2,2,2,2,3,3,2,2,2,2,2,2,0,0,1,1,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,3,3,2,2,3,3,0,0,3,3,3,3,0,0,2,2,1,1,2,2,0,0,3,3,3,3,0,0,2,2,1,1,0,0,1,1,3,3,2,2,2,2,1,1,0,0,1,1,3,3,2,2,2,2,0,0,3,3,1,1,3,3,0,0,3,3,3,3,0,0,3,3,2,2,1,1,0,0,1,1,2,2,0,0,0,0,1,1,1,1,3,3,1,1,0,0,2,2,2,2,0,0,1,1,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,3,3,0,0,2,2,2,2,2,2,2,2,0,0,0,0,1,1,3,3,1,1,0,0,1,1,1,1,3,3,3,3,0,0,1,1,3,3,2,2,1,1,2,2,0,0,2,2,2,2,3,3,3,3,2,2,1,1,2,2,3,3,2,2,3,3,1,1,1,1,3,3,0,0,1,1,1,1,3,3,2,2,2,2,0,0,1,1,2,2,2,2,0,0,3,3,1,1,0,0,1,1,1,1,1,1,3,3,3,3,2,2,0,0,1,1,0,0,3,3,2,2,2,2,0,0,2,2,1,1,2,2,2,2,3,3,3,3,3,3,0,0,0,0,2,2,2,2,3,3,0,0,0,0,2,2,0,0,1,1,2,2,0,0,1,1,3,3,1,1,2,2,2,2,3,3,2,2,2,2,0,0,0,0,2,2,1,1,0,0,3,3,1,1,1,1,0,0,0,0,3,3,1,1,2,2,2,2,2,2,1,1,1,1,0,0,1,1,0,0,1,1,2,2,0,0,2,2,2,2,1,1,2,2,2,2,1,1,2,2,2,2,2,2,2,2,0,0,0,0,2,2,1,1,3,3,2,2,2,2,1,1,1,1,1,1,2,2,1,1,3,3,3,3,1,1,3,3,0,0,1,1,1,1,1,1,2,2,1,1,3,3,3,3,2,2,0,0,0,0,0,0,1,1,2,2,2,2,3,3,3,3,0,0,2,2,1,1,0,0,3,3,1,1,0,0,0,0,3,3,1,1,2,2,1,1,3,3,3,3,3,3,0,0,1,1,0,0,0,0,0,0,3,3,1,1,0,0,2,2,1,1,1,1,2,2,0,0,0,0,2,2,2,2,3,3,2,2,1,1,3,3,2,2,2,2,1,1,2,2,3,3,2,2,0,0,1,1,1,1,2,2,0,0,1,1,3,3,0,0,1,1,3,3,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,3,2,2,0,0,1,1,1,1,1,1,0,0,2,2,2,2,3,3,2,2,1,1,3,3,0,0,1,1,0,0,0,0,1,1,0,0,3,3,0,0,2,2,1,1,2,2,2,2,0,0,2,2,2,2,3,3,1,1,3,3,3,3,1,1,3,3,0,0,0,0,1,1,1,1,2,2,1,1,2,2,3,3,3,3,1,1,1,1,1,1,2,2,3,3,1,1,1,1,2,2,3,3,0,0,0,0,0,0,1,1,3,3,1,1,1,1,1,1,0,0,1,1,2,2,1,1,0,0,3,3,3,3,1,1,1,1,2,2,0,0,1,1,1,1,0,0,3,3,2,2,2,2,1,1,1,1,0,0,1,1,3,3,3,3,3,3,2,2,3,3,3,3,3,3,0,0,3,3,2,2,3,3,2,2,1,1,2,2,3,3,3,3,1,1,1,1,2,2,0,0,1,1,2,2,3,3,1,1,3,3,2,2,3,3,3,3,1,1,3,3,2,2,1,1,0,0,0,0,3,3,1,1,1,1,2,2,3,3,3,3,2,2,2,2,0,0,2,2,0,0,0,0,3,3,3,3,0,0,3,3,0,0,2,2,3,3,2,2,1,1,0,0,0,0,1,1,0,0,2,2,1,1,1,1,1,1,1,1,3,3,2,2,1,1,0,0,3,3,1,1,2,2,1,1,1,1,1,1,1,1,3,3,0,0,2,2,2,2,1,1,2,2,0,0,1,1,1,1,2,2,1,1,0,0,3,3,1,1,1,1,3,3,1,1,2,2,0,0,0,0,1,1,2,2,2,2,0,0,1,1,2,2,0,0,2,2,1,1,2,2,1,1,2,2,2,2,1,1,3,3,1,1,2,2,0,0,0,0,0,0,0,0,1,1,2,2,2,2,1,1,0,0,3,3,0,0,3,3,0,0,3,3,2,2,2,2,1,1,0,0,2,2,2,2,0,0,0,0,2,2,1,1,1,1,2,2,3,3,3,3,1,1,1,1,2,2,0,0,1,1,2,2,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,2,2,2,2,1,1,1,1,2,2,3,3,1,1,0,0,2,2,0,0,2,2,2,2,1,1,1,1,0,0,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,0,0,0,0,1,1,1,1,0,0,2,2,1,1,1,1,2,2,3,3,0,0,1,1,1,1,0,0,0,0,0,0,1,1,2,2,1,1,0,0,2,2,0,0,0,0,1,1,2,2,2,2,0,0,1,1,3,3,1,1,0,0,0,0,1,1,1,1,0,0,2,2,2,2,3,3,0,0,0,0,0,0,1,1,2,2,2,2,0,0,2,2,3,3,3,3,0,0,2,2,0,0,3,3,3,3,3,3,0,0,0,0,1,1,0,0,0,0,0,0,3,3,0,0,3,3,0,0,0,0,3,3,0,0,2,2,3,3,1,1,2,2,2,2,3,3,0,0,1,1,3,3,1,1,0,0,1,1,3,3,0,0,2,2,2,2,1,1,0,0,2,2,0,0,0,0,2,2,1,1,1,1,2,2,2,2,0,0,0,0,2,2,3,3,1,1,0,0,2,2,2,2,0,0,2,2,0,0,2,2,0,0,1,1,1,1,1,1,0,0,3,3,1,1,3,3,2,2,1,1,2,2,2,2,0,0,1,1,0,0,3,3,0,0,2,2,0,0,0,0,2,2,0,0,3,3,1,1,1,1,0,0,1,1,0,0,0,0,2,2,1,1,2,2,3,3,3,3,1,1,3,3,3,3,1,1,1,1,3,3,2,2,0,0,2,2,0,0,0,0,3,3,3,3,0,0,2,2,0,0,2,2,0,0,2,2,2,2,1,1,0,0,3,3,1,1,2,2,2,2,3,3,3,3,3,3,0,0,3,3,0,0,2,2,0,0,0,0,2,2,1,1,2,2,2,2,0,0,1,1,2,2,3,3,0,0,1,1,1,1,3,3,0,0,1,1,3,3,2,2,1,1,3,3,2,2,0,0,2,2,3,3,1,1,0,0,0,0,3,3,3,3,1,1,0,0,0,0,0,0,2,2,1,1,2,2,1,1,1,1,1,1,3,3,2,2,3,3,1,1,1,1,2,2,2,2,0,0,2,2,2,2,0,0,2,2,3,3,3,3,1,1,0,0,1,1,3,3,0,0,2,2,0,0,1,1,3,3,3,3,1,1,0,0,3,3,2,2,2,2,3,3,2,2,3,3,0,0,0,0,0,0,3,3,1,1,1,1,3,3,0,0,0,0,0,0,0,0,1,1,1,1,3,3,0,0,1,1,3,3,1,1,1,1,1,1,2,2,0,0,0,0,3,3,0,0,1,1,0,0,1,1,3,3,1,1,1,1,3,3,2,2,0,0,3,3,3,3,0,0,1,1,0,0,1,1,2,2,3,3,0,0,0,0,2,2,3,3,1,1,0,0,1,1,1,1,2,2,2,2,3,3,1,1,3,3,0,0,2,2,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,3,3,2,2,2,2,0,0,0,0,3,3,2,2,3,3,3,3,2,2,0,0,3,3,1,1,1,1,1,1,0,0,0,0,3,3,3,3,0,0,2,2,3,3,1,1,3,3,3,3,0,0,3,3,1,1,2,2,3,3,1,1,1,1,1,1,3,3,1,1,0,0,0,0,0,0,1,1,1,1,2,2,0,0,1,1,2,2,1,1,0,0,3,3,3,3,3,3,3,3,0,0,2,2,0,0,3,3,0,0,3,3,0,0,2,2,2,2,1,1,0,0,3,3,3,3,0,0,0,0,2,2,3,3,1,1,2,2,3,3,0,0,3,3,0,0,2,2,3,3,0,0,0,0,0,0,0,0,1,1,1,1,3,3,2,2,2,2,3,3,0,0,2,2,3,3,1,1,3,3,2,2,0,0,0,0,2,2,1,1,0,0,1,1,3,3,1,1,1,1,1,1,2,2,1,1,3,3,0,0,1,1,0,0,0,0,3,3,1,1,2,2,1,1,0,0,1,1,2,2,0,0,1,1,3,3,2,2,1,1,0,0,0,0,0,0,2,2,0,0,0,0,1,1,3,3,0,0,1,1,3,3,2,2,2,2,1,1,2,2,1,1,2,2,0,0,1,1,1,1,2,2,3,3,3,3,1,1,3,3,3,3,2,2,1,1,3,3,1,1,0,0,1,1,1,1,3,3,0,0,0,0,0,0,3,3,3,3,0,0,0,0,0,0,3,3,0,0,0,0,1,1,3,3,1,1,1,1,2,2,0,0,1,1,3,3,2,2,1,1,2,2,1,1,0,0,0,0,2,2,2,2,3,3,2,2,3,3,3,3,3,3,1,1,3,3,3,3,2,2,1,1,2,2,3,3,3,3,0,0,1,1,1,1,1,1,2,2,1,1,2,2,1,1,0,0,3,3,2,2,3,3,2,2,0,0,1,1,1,1,1,1,1,1,2,2,2,2,1,1,3,3,0,0,0,0,0,0,1,1,1,1,3,3,3,3,1,1,1,1,0,0,3,3,3,3,3,3,3,3,0,0,1,1,0,0,3,3,3,3,3,3,1,1,2,2,3,3,2,2,1,1,2,2,1,1,1,1,1,1,3,3,0,0,2,2,1,1,2,2,2,2,3,3,1,1,0,0,3,3,0,0,2,2,3,3,1,1,0,0,1,1,0,0,1,1,3,3,3,3,2,2,2,2,2,2,3,3,3,3,2,2,2,2,1,1,0,0,3,3,2,2,0,0,0,0,0,0,2,2,2,2,3,3,0,0,1,1,1,1,3,3,2,2,2,2,0,0,0,0,0,0,1,1,3,3,1,1,2,2,3,3,3,3,1,1,2,2,1,1,1,1,3,3,0,0,3,3,1,1,3,3,3,3,3,3,2,2,0,0,3,3,3,3,2,2,3,3,2,2,1,1,0,0,3,3,0,0,1,1,3,3,3,3,3,3,2,2,1,1,0,0,1,1,2,2,1,1,3,3,3,3,2,2,0,0,3,3,2,2,1,1,2,2,0,0,1,1,0,0,0,0,2,2,3,3,0,0,1,1,0,0,2,2,0,0,1,1,1,1,0,0,2,2,0,0,1,1,0,0,3,3,1,1,2,2,0,0,3,3,0,0,0,0,0,0,1,1,3,3,1,1,1,1,3,3,3,3,0,0,1,1,0,0,0,0,0,0,1,1,2,2,2,2,3,3,2,2,0,0,3,3,0,0,3,3,0,0,1,1,1,1,1,1,1,1,3,3,3,3,0,0,1,1,2,2,1,1,1,1,2,2,1,1,0,0,3,3,2,2,3,3,2,2,3,3,2,2,3,3,1,1,3,3,3,3,2,2,0,0,2,2,0,0,0,0,1,1,0,0,1,1,0,0,3,3,3,3,3,3,1,1,3,3,1,1,3,3,2,2,1,1,2,2,1,1,3,3,0,0,2,2,3,3,1,1,2,2,3,3,0,0,3,3,3,3,2,2,0,0,0,0,0,0,3,3,2,2,0,0,2,2,2,2,3,3,2,2,0,0,2,2,2,2,3,3,1,1,0,0,1,1,1,1,3,3,2,2,3,3,3,3,1,1,3,3,2,2,2,2,1,1,0,0,3,3,0,0,0,0,0,0,1,1,2,2,2,2,0,0,0,0,3,3,2,2,2,2,0,0,1,1,0,0,0,0,1,1,2,2,2,2,2,2,0,0,1,1,0,0,3,3,2,2,0,0,1,1,3,3,3,3,0,0,2,2,0,0,2,2,2,2,3,3,1,1,0,0,1,1,2,2,3,3,0,0,1,1,0,0,0,0,3,3,0,0,2,2,1,1,1,1,3,3,2,2,2,2,0,0,0,0,3,3,2,2,0,0,2,2,0,0,2,2,3,3,3,3,2,2,2,2,0,0,2,2,1,1,1,1,3,3,3,3,2,2,1,1,3,3,3,3,3,3,1,1,0,0,0,0,0,0,3,3,0,0,2,2,0,0,2,2,3,3,3,3,3,3,2,2,1,1,1,1,2,2,3,3,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,1,1,0,0,3,3,2,2,3,3,1,1,3,3,1,1,2,2,3,3,0,0,1,1,0,0,3,3,1,1,1,1,2,2,3,3,0,0,3,3,0,0,3,3,0,0,0,0,0,0,2,2,2,2,3,3,3,3,0,0,0,0,3,3,2,2,0,0,1,1,1,1,1,1,0,0,0,0,3,3,2,2,0,0,1,1,1,1,2,2,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,2,2,3,3,2,2,3,3,3,3,3,3,3,3,1,1,0,0,0,0,3,3,3,3,2,2,1,1,0,0,1,1,1,1,3,3,3,3,0,0,0,0,1,1,1,1,3,3,0,0,1,1,0,0,3,3,3,3,1,1,3,3,3,3,3,3,3,3,2,2,1,1,1,1,3,3,0,0,1,1,2,2,3,3,3,3,2,2,1,1,0,0,1,1,3,3,1,1,1,1,0,0,2,2,1,1,2,2,2,2,1,1,3,3,2,2,2,2,0,0,2,2,1,1,1,1,0,0,2,2,3,3,1,1,1,1,0,0,2,2,0,0,1,1,0,0,2,2,0,0,1,1,2,2,1,1,1,1,2,2,2,2,0,0,2,2,2,2,0,0,3,3,1,1,2,2,3,3,0,0,3,3,2,2,2,2,3,3,2,2,3,3,3,3,3,3,0,0,3,3,3,3,3,3,0,0,2,2,3,3,1,1,1,1,2,2,1,1,2,2,0,0,0,0,0,0,2,2,3,3,1,1,3,3,1,1,0,0,3,3,3,3,2,2,0,0,0,0,2,2,0,0,0,0,1,1,2,2,2,2,0,0,2,2,1,1,3,3,3,3,3,3,0,0,3,3,3,3,2,2,3,3,0,0,2,2,1,1,3,3,3,3,2,2,1,1,3,3,3,3,2,2,2,2,3,3,2,2,3,3,2,2,0,0,2,2,0,0,3,3,0,0,2,2,3,3,2,2,3,3,2,2,2,2,1,1,3,3,0,0,3,3,3,3,2,2,0,0,3,3,2,2,3,3,1,1,1,1,2,2,1,1,1,1,2,2,1,1,2,2,0,0,3,3,3,3,1,1,3,3,0,0,3,3,3,3,0,0,1,1,3,3,1,1,1,1,1,1,0,0,0,0,2,2,1,1,3,3,0,0,1,1,2,2,3,3,2,2,2,2,2,2,3,3,2,2,2,2,3,3,2,2,0,0,3,3,1,1,0,0,1,1,0,0,0,0,3,3,2,2,1,1,1,1,0,0,2,2,1,1,2,2,0,0,0,0,0,0,0,0,2,2,1,1,2,2,2,2,3,3,0,0,0,0,3,3,0,0,1,1,3,3,0,0,3,3,0,0,2,2,0,0,3,3,0,0,2,2,3,3,1,1,2,2,2,2,0,0,1,1,3,3,2,2,0,0,3,3,0,0,0,0,0,0,0,0,0,0,1,1,0,0,2,2,1,1,3,3,2,2,1,1,2,2,2,2,0,0,0,0,0,0,2,2,1,1,2,2,2,2,0,0,0,0,1,1,0,0,2,2,2,2,2,2,0,0,3,3,2,2,0,0,3,3,1,1,1,1,2,2,1,1,0,0,1,1,0,0,2,2,0,0,1,1,1,1,3,3,0,0,1,1,2,2,2,2,0,0,1,1,2,2,1,1,3,3,0,0,0,0,3,3,1,1,2,2,0,0,0,0,3,3,2,2,1,1,2,2,1,1,3,3,3,3,0,0,1,1,3,3,0,0,2,2,0,0,3,3,1,1,2,2,0,0,3,3,3,3,2,2,1,1,1,1,3,3,0,0,2,2,3,3,3,3,3,3,0,0,2,2,3,3,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,3,3,0,0,2,2,3,3,0,0,2,2,1,1,3,3,1,1,0,0,0,0,0,0,2,2,2,2,2,2,3,3,3,3,0,0,0,0,3,3,1,1,2,2,0,0,2,2,1,1,3,3,1,1,1,1,2,2,1,1,1,1,1,1,1,1,0,0,2,2,0,0,1,1,2,2,3,3,0,0,2,2,1,1,2,2,3,3,2,2,3,3,0,0,2,2,3,3,0,0,3,3,0,0,3,3,0,0,0,0,3,3,3,3,2,2,1,1,3,3,2,2,0,0,3,3,1,1,3,3,0,0,0,0,2,2,2,2,3,3,2,2,0,0,2,2,2,2,0,0,1,1,0,0,2,2,1,1,1,1,0,0};

float samplerBlueNoiseErrorDistribution_128x128_OptimizedFor_2d2d2d2d_4spp(int pixel_i, int pixel_j, int sampleIndex, int sampleDimension)
{
	// wrap arguments
	pixel_i = pixel_i & 127;
	pixel_j = pixel_j & 127;
	sampleIndex = sampleIndex & 255;
	sampleDimension = sampleDimension & 255;

	// xor index based on optimized ranking
	int rankedSampleIndex = sampleIndex ^ rankingTile[sampleDimension + (pixel_i + pixel_j*128)*8];

	// fetch value in sequence
	int value = sobol_256spp_256d[sampleDimension + rankedSampleIndex*256];

	// If the dimension is optimized, xor sequence value based on optimized scrambling
	value = value ^ scramblingTile[(sampleDimension%8) + (pixel_i + pixel_j*128)*8];

	// convert to float and return
	float v = (0.5f+value)/256.0f;
	return v;
}
