// This file is part of the FidelityFX SDK.
//
// Copyright (C) 2024 Advanced Micro Devices, Inc.
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files(the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and /or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions :
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// An Owen-scrambled Sobol sequence of 256 samples of 256 dimensions
static const int sobol_256spp_256d[256*256] = {32,226,72,70,57,171,246,75,112,81,109,239,120,101,230,103,103,41,249,86,253,99,132,184,214,147,128,248,17,149,163,17,60,40,169,196,77,79,102,23,250,77,75,151,95,123,234,198,25,26,184,114,230,188,105,18,231,233,175,151,19,174,202,71,84,229,247,148,182,127,92,14,41,112,162,253,35,101,137,30,111,134,95,122,28,2,41,254,181,91,101,188,145,31,166,38,53,193,1,122,99,86,178,36,198,169,113,255,97,221,227,231,29,100,30,141,250,254,16,157,2,220,187,95,181,125,207,187,105,119,156,41,16,194,93,216,227,124,138,90,227,1,88,153,233,69,120,36,19,189,120,4,185,220,185,109,184,96,247,173,210,227,54,3,18,9,139,213,156,57,61,101,37,247,21,201,10,143,11,38,146,18,118,129,95,191,75,207,12,252,238,104,47,39,190,229,31,56,20,127,42,178,100,141,93,222,192,247,186,7,224,161,72,100,87,69,218,44,25,195,185,118,179,123,231,170,96,225,204,52,117,60,3,86,25,143,230,18,11,165,72,188,158,3,66,105,50,200,226,145,227,45,183,62,82,176,191,36,248,191,189,122,96,185,146,166,203,78,144,189,67,174,154,182,86,169,90,236,101,40,71,107,81,93,159,82,75,230,157,191,34,35,235,139,150,193,10,142,217,77,154,249,74,13,196,248,56,154,27,6,242,226,105,94,66,67,145,112,31,145,133,68,21,0,44,212,254,153,183,238,98,102,145,199,100,213,196,52,131,141,216,209,236,122,58,249,188,108,8,206,62,199,207,103,160,247,207,255,101,185,1,113,223,126,182,0,50,93,250,174,194,18,65,111,206,104,156,3,48,195,122,212,10,101,235,200,13,183,173,7,192,3,101,228,84,168,121,241,205,122,115,132,155,242,215,22,236,242,69,35,48,245,3,175,68,57,4,15,226,155,222,140,54,48,80,200,194,149,213,68,225,14,182,122,147,195,69,166,191,17,176,58,222,58,190,70,66,153,196,215,121,123,176,190,161,145,203,121,255,27,207,28,113,22,44,232,46,84,181,131,245,220,27,202,161,38,94,208,39,143,52,5,154,85,121,139,226,223,159,246,170,56,94,209,188,71,205,76,16,233,168,172,200,37,19,123,120,202,28,175,232,88,120,107,157,198,111,253,18,24,36,35,43,169,199,197,137,194,12,238,138,232,17,17,58,115,39,234,4,164,225,215,14,185,232,76,215,171,142,206,206,132,90,31,130,24,0,165,34,91,126,113,64,202,144,114,132,125,58,184,234,211,246,238,168,7,1,172,169,218,67,29,185,66,73,49,222,167,243,189,36,116,23,223,219,200,84,67,94,53,79,26,202,204,91,180,221,166,106,18,207,17,128,137,246,235,162,13,129,130,49,76,104,189,138,55,174,71,152,49,116,204,207,103,198,147,225,142,79,8,172,59,234,225,192,168,181,144,185,6,233,243,61,123,46,55,44,16,228,79,156,235,190,115,61,162,115,182,122,230,138,204,140,86,173,80,99,207,211,181,23,141,152,17,180,35,121,168,67,205,107,74,55,229,234,210,6,94,48,186,210,189,2,200,190,181,227,128,211,225,215,228,74,7,188,195,36,82,10,131,96,99,138,63,1,210,39,134,153,112,72,163,196,55,126,37,125,107,234,166,129,80,61,97,121,20,123,222,3,155,219,62,49,207,87,182,26,214,167,142,89,38,36,112,87,100,56,245,240,152,23,7,237,11,185,206,233,203,131,42,53,35,60,40,211,114,9,13,189,130,196,210,173,39,208,56,110,34,240,65,75,234,76,73,34,39,2,118,174,237,52,194,197,28,155,161,135,180,200,3,89,210,26,154,145,45,57,54,85,26,118,207,212,58,101,69,202,184,36,234,219,155,41,29,80,22,193,175,145,100,50,29,149,166,168,162,213,130,36,25,234,78,84,97,191,139,95,156,9,12,41,97,110,222,8,16,250,161,130,45,111,195,83,213,16,141,154,48,124,175,89,25,27,9,172,242,51,167,76,109,69,107,23,80,23,166,12,16,180,156,182,238,148,249,59,130,75,122,59,134,240,69,220,21,230,47,1,124,66,180,77,247,147,103,66,98,211,96,105,213,127,178,144,102,213,33,247,141,232,67,62,86,230,222,146,68,122,27,147,7,85,69,31,22,67,67,78,13,149,221,57,121,176,133,161,84,201,146,119,196,217,19,132,52,76,135,247,107,29,131,248,220,156,248,29,41,36,202,174,136,253,191,226,91,179,96,69,213,172,0,206,75,192,54,69,120,138,218,171,185,232,211,139,8,31,11,50,119,28,197,83,158,170,229,244,195,190,23,213,87,70,17,102,197,39,59,88,152,234,95,106,29,195,236,114,136,6,159,105,101,2,119,184,47,212,218,188,165,163,138,174,114,71,54,127,64,183,39,51,42,209,202,106,96,215,154,56,33,102,25,62,111,9,49,4,98,142,198,128,138,13,74,95,229,42,164,19,175,179,111,138,19,157,125,94,34,221,103,246,144,141,176,129,201,55,100,23,12,139,33,227,91,223,224,69,120,83,245,50,57,190,21,54,86,245,95,250,34,71,249,100,201,144,16,221,0,40,74,133,38,145,48,217,119,132,34,138,67,161,62,221,126,108,207,140,42,156,13,224,198,142,19,55,85,254,155,140,168,250,58,118,137,42,78,8,48,89,195,167,91,243,246,88,23,22,206,17,190,56,125,171,116,245,129,121,57,144,228,159,197,243,217,239,86,188,152,88,239,112,120,245,119,147,189,25,128,240,72,208,29,162,23,152,24,143,226,136,174,171,58,178,10,5,250,209,239,88,62,34,251,156,163,231,247,102,112,46,48,61,233,24,71,54,73,12,81,195,243,115,138,145,194,164,135,148,51,201,104,74,24,78,107,65,246,118,159,165,130,206,34,157,177,180,10,126,163,167,129,75,0,149,115,172,21,242,139,162,170,92,238,35,46,24,108,101,62,26,147,180,210,227,166,103,149,188,192,92,115,141,161,120,90,231,250,181,130,208,232,151,157,141,208,27,81,82,42,162,244,186,62,163,6,254,94,107,138,123,144,14,216,138,235,104,135,98,77,82,57,47,77,171,213,192,134,69,226,93,197,9,63,181,197,169,22,248,190,55,178,250,167,76,157,101,170,138,94,156,44,12,155,102,133,133,149,43,224,51,130,44,138,3,195,25,161,29,216,1,188,160,73,4,196,125,240,92,88,50,192,176,234,39,109,96,39,60,165,226,80,248,179,232,244,141,102,81,131,110,19,206,225,222,115,198,63,195,251,19,155,77,51,194,251,124,13,77,69,106,112,114,187,126,67,222,81,227,163,80,172,25,70,205,111,48,160,111,165,112,243,47,236,107,81,15,83,95,132,80,133,178,116,87,10,195,139,151,122,44,82,111,24,234,156,187,202,250,20,233,186,204,184,154,149,117,78,205,119,71,166,192,239,88,148,154,229,200,139,163,129,12,155,167,252,50,198,46,106,221,91,235,75,2,14,240,122,62,178,218,42,223,213,6,17,212,242,32,190,96,163,121,63,228,65,111,229,63,70,140,232,221,248,216,80,5,145,12,27,33,195,86,111,42,125,70,44,232,82,209,40,234,168,224,215,215,133,247,128,76,248,178,34,253,61,204,193,105,44,227,66,45,238,159,16,241,67,99,178,235,181,68,204,234,144,58,40,132,125,203,25,204,148,151,253,195,198,81,8,54,248,148,248,58,54,235,82,71,67,181,212,241,43,111,111,202,69,166,200,66,87,245,207,70,112,64,26,240,149,82,86,28,104,17,59,72,154,106,1,173,59,21,204,184,231,15,224,161,253,174,78,249,25,217,35,144,180,57,102,174,57,138,227,125,141,246,16,35,201,173,170,31,107,205,169,59,19,52,209,226,49,136,168,13,238,63,53,78,203,68,18,146,228,165,245,244,84,215,78,230,167,83,239,15,210,34,99,90,184,143,187,50,98,95,182,121,47,53,112,15,53,239,130,105,66,142,11,185,224,203,20,44,156,28,197,195,65,118,36,206,88,55,37,18,112,9,20,231,73,6,11,225,79,180,145,124,204,29,245,148,198,53,210,171,103,53,215,106,111,154,237,107,2,249,79,145,126,255,255,53,222,196,57,237,131,6,63,45,70,68,190,191,12,210,247,162,41,135,184,234,206,153,176,115,255,114,178,110,24,25,66,114,55,29,79,253,67,124,245,37,236,13,88,232,186,18,143,178,59,5,237,10,249,253,37,88,46,134,71,53,74,172,186,69,137,11,154,60,68,120,125,100,91,182,239,177,38,28,125,208,165,38,150,207,244,41,88,127,241,251,168,84,195,111,37,211,165,113,3,212,184,180,207,48,52,204,171,213,128,154,138,218,69,214,154,99,201,203,109,93,71,190,5,99,1,72,173,15,149,49,253,51,82,171,179,114,131,68,114,133,15,104,227,141,109,39,68,225,130,50,51,133,154,148,48,28,230,9,43,157,50,133,203,239,37,160,233,120,54,20,116,57,174,116,158,45,8,196,14,200,80,203,212,233,1,0,88,172,214,196,22,192,224,142,138,146,230,105,100,153,155,112,241,124,26,71,253,143,4,191,50,49,88,226,25,142,141,13,12,50,159,122,211,42,168,23,217,253,218,151,135,3,152,114,102,191,76,186,42,124,70,19,56,25,85,234,58,57,225,230,253,56,194,107,134,142,201,213,43,14,33,242,16,141,205,196,99,143,100,115,5,99,128,100,221,174,110,191,83,165,164,78,60,124,209,199,63,185,120,175,43,3,24,40,153,1,83,147,223,112,72,242,148,166,115,36,138,42,13,63,1,45,173,225,83,121,19,23,208,171,146,240,108,150,3,213,83,210,238,72,120,80,197,2,4,159,197,138,216,19,178,24,173,212,237,169,129,129,102,51,63,203,142,11,134,180,207,105,98,133,253,20,224,6,126,194,167,33,132,90,101,179,113,216,222,132,30,88,23,229,210,85,6,154,226,252,17,39,174,208,255,8,11,252,159,110,195,86,250,59,161,218,31,140,167,41,33,201,143,250,68,82,205,44,4,77,43,214,212,60,82,214,41,44,125,236,152,34,64,133,184,58,145,227,65,70,73,166,49,21,158,242,114,42,75,209,36,72,188,192,146,223,138,76,27,235,115,153,105,169,96,209,231,4,33,105,226,175,187,91,218,12,73,168,214,254,98,208,113,214,116,177,49,34,94,22,127,175,12,155,193,56,187,115,187,240,136,234,206,189,250,115,219,154,17,52,62,198,63,225,81,77,90,127,246,219,192,106,223,78,102,88,142,46,208,156,230,196,67,182,18,112,210,126,198,59,15,234,166,243,77,61,149,24,223,70,245,142,178,199,101,195,190,109,78,244,224,12,84,52,158,184,88,212,155,159,128,187,54,48,209,190,202,157,70,122,109,33,221,124,227,1,196,124,121,163,138,238,25,129,134,83,111,124,60,142,46,143,48,85,63,5,77,46,251,193,209,81,108,149,108,1,47,137,175,85,106,148,27,204,145,104,3,152,84,228,215,113,141,6,117,115,151,206,248,61,43,182,198,76,88,12,222,132,75,73,8,205,190,32,12,159,70,205,4,158,0,107,220,104,90,223,181,80,7,111,166,130,16,168,145,218,242,101,35,165,172,12,217,239,157,76,37,238,176,63,124,243,45,101,181,191,200,64,186,170,42,104,154,191,224,67,145,240,72,82,103,93,108,220,251,36,178,110,145,98,136,83,2,171,177,220,23,98,221,2,160,216,219,237,90,105,255,48,157,136,55,102,122,181,7,225,55,229,254,215,169,94,22,44,65,136,50,190,151,198,54,132,81,245,106,71,91,141,176,162,15,210,33,14,140,108,81,17,135,249,17,44,15,121,28,16,114,178,210,7,129,250,11,239,18,86,203,161,124,2,185,178,83,110,168,3,81,125,80,149,8,67,30,212,0,129,8,77,255,114,243,68,8,119,210,232,104,244,127,165,159,26,176,206,160,228,34,116,10,3,91,65,149,163,43,43,44,171,113,113,223,206,17,63,64,215,216,94,118,5,139,66,201,213,30,120,149,18,236,99,41,81,175,245,1,7,171,209,151,134,28,32,122,201,13,18,46,236,215,113,188,192,221,39,69,117,121,255,119,26,59,142,121,126,238,179,163,183,245,98,199,32,46,39,137,236,232,52,138,4,60,86,83,12,100,44,195,49,107,228,105,56,183,18,177,222,50,189,188,97,197,148,94,99,1,198,221,121,206,54,31,212,145,62,73,77,213,189,38,66,13,139,69,173,57,26,11,176,245,141,166,141,203,10,48,45,201,17,131,241,115,13,165,235,28,129,88,72,36,124,169,128,6,145,10,109,219,198,187,90,149,67,215,68,116,33,56,204,217,236,231,0,205,84,97,113,175,30,185,95,187,166,164,123,103,0,218,18,150,180,103,151,153,146,97,15,161,171,246,252,131,198,186,58,55,210,93,58,157,3,142,220,98,50,202,151,2,115,205,200,3,236,146,210,233,71,222,129,198,18,131,29,157,152,63,201,45,197,253,170,121,124,232,64,197,112,22,208,106,99,54,41,247,146,135,234,142,177,3,38,157,234,222,46,189,233,76,41,150,255,135,82,99,244,246,187,81,215,16,76,188,188,104,156,21,239,255,206,97,35,217,194,13,70,106,106,238,171,232,93,223,145,190,50,39,144,48,13,113,146,151,178,156,18,131,231,168,108,178,224,7,44,122,98,87,166,65,220,174,138,98,95,93,188,127,246,195,136,215,160,201,137,35,217,167,126,219,175,109,180,111,127,222,93,69,133,2,58,198,186,238,108,57,157,101,174,249,26,46,210,254,251,76,43,197,209,161,52,197,28,246,173,229,35,43,13,81,122,34,245,212,223,50,135,69,70,192,171,78,9,135,189,54,168,232,131,250,208,59,227,252,247,231,40,235,203,254,51,25,198,223,165,81,140,141,67,194,180,31,194,172,47,195,56,153,118,221,30,217,17,85,154,184,122,15,130,179,86,8,37,33,200,95,144,73,175,68,185,197,128,182,154,171,147,182,86,172,23,236,20,92,194,110,253,124,133,82,127,206,92,34,108,69,170,47,61,41,87,108,218,3,244,7,124,51,153,83,186,164,116,154,85,123,43,135,177,107,28,189,81,241,214,189,235,233,142,6,109,183,130,75,79,107,99,67,31,164,248,227,114,159,230,115,116,115,252,33,75,4,171,191,217,88,245,156,203,48,239,140,253,211,46,184,136,34,21,248,161,128,156,16,88,64,71,34,174,125,70,164,125,92,205,214,79,157,199,223,143,214,138,213,150,169,17,16,181,95,200,208,91,91,55,125,7,1,39,91,6,103,252,246,22,71,110,149,236,73,1,247,51,2,168,88,124,234,86,100,6,94,1,17,215,157,34,238,126,194,222,109,67,175,96,45,252,99,58,3,34,192,251,95,240,36,188,243,191,229,74,164,55,171,108,239,73,208,140,114,46,244,36,30,33,56,14,209,94,86,28,9,153,30,23,102,165,252,98,77,72,233,22,126,152,98,40,246,35,93,137,114,191,114,200,54,214,8,238,145,43,119,180,186,55,74,170,232,166,247,56,233,9,162,16,241,95,47,5,109,72,125,67,35,130,55,138,75,157,246,85,244,3,230,60,226,159,12,234,155,160,180,119,243,253,179,202,194,53,218,65,208,230,212,71,228,29,49,220,31,146,244,249,84,46,237,203,93,171,73,33,115,46,109,10,163,137,73,18,133,213,236,174,230,216,119,127,80,199,18,100,180,236,191,127,152,158,226,45,72,70,181,106,90,21,229,46,41,109,55,237,81,0,158,169,63,40,22,85,246,181,235,161,180,28,175,136,87,132,184,54,121,185,69,89,58,20,54,81,101,87,37,251,152,4,162,108,113,248,178,219,151,240,144,158,242,185,138,4,34,148,255,250,66,75,144,141,25,248,244,89,180,203,97,141,149,179,129,213,186,64,101,242,119,130,121,108,230,198,74,228,155,96,237,140,201,158,44,127,161,120,219,94,11,95,27,145,80,184,107,215,88,252,32,89,59,97,159,249,183,75,131,180,65,184,179,85,80,88,74,128,53,126,191,54,169,0,133,100,248,196,158,91,121,110,12,248,130,87,248,186,85,136,101,181,0,90,45,34,227,84,17,40,96,221,187,167,131,112,48,70,62,240,138,78,245,248,226,203,255,32,242,246,141,200,17,167,32,151,12,72,159,221,190,56,115,237,233,226,113,71,228,167,60,113,127,28,174,27,176,227,160,77,221,157,64,14,166,82,60,78,7,91,16,214,169,78,222,97,33,229,210,4,255,104,234,42,181,7,177,190,23,40,135,53,67,63,28,151,60,167,81,21,190,110,214,160,222,51,228,87,83,113,220,46,182,163,193,79,214,249,120,197,244,197,169,252,20,33,253,246,46,198,16,208,35,110,5,37,236,172,149,234,155,32,36,8,249,70,224,226,40,16,146,131,224,173,250,111,102,227,160,196,255,167,81,196,62,24,6,39,4,245,139,98,158,201,247,5,6,2,61,92,5,65,70,24,206,135,30,246,146,155,22,29,247,25,112,186,5,208,134,240,95,137,29,48,148,222,92,36,165,248,10,244,222,158,131,46,156,217,243,219,101,123,98,209,124,89,178,16,48,173,142,241,134,127,160,217,64,134,35,244,28,253,59,26,10,212,162,143,252,94,0,198,0,16,156,116,145,64,255,206,234,251,104,250,213,247,171,89,86,125,48,237,216,196,160,45,90,227,12,33,58,31,88,200,117,101,36,105,135,49,134,64,181,233,40,63,100,189,192,13,48,58,159,183,105,34,162,170,166,132,83,141,116,29,39,216,84,29,224,211,54,145,251,248,148,150,203,26,51,179,47,134,175,80,66,223,24,221,52,170,59,241,37,95,232,183,15,162,203,144,221,60,248,8,211,255,78,249,55,59,23,131,11,165,152,182,82,168,71,89,48,249,78,107,182,117,73,21,79,42,128,232,89,103,207,13,224,32,236,175,138,201,54,26,98,122,91,253,144,222,108,171,101,120,208,168,40,29,46,64,23,171,248,115,40,80,28,107,143,65,188,142,205,155,234,86,121,157,124,23,44,177,188,201,222,229,244,169,241,155,62,102,187,15,28,49,168,157,29,135,202,9,160,102,125,112,184,31,209,162,114,13,130,215,93,15,255,110,50,54,19,144,98,47,46,170,252,210,5,161,176,69,185,97,187,253,94,124,215,85,69,73,136,150,68,137,217,52,113,151,241,70,44,102,126,10,143,167,133,81,239,233,109,73,171,141,93,133,112,185,133,103,206,49,208,130,79,127,234,48,173,231,82,200,74,68,194,188,185,26,56,199,134,122,3,153,227,174,245,23,34,49,20,68,184,202,1,232,252,31,171,45,85,7,114,187,66,203,169,98,117,144,15,165,104,143,111,174,100,197,60,7,53,248,238,100,12,162,96,40,189,247,101,64,57,57,14,195,114,229,155,228,32,111,37,141,8,8,163,2,223,6,96,54,144,175,85,141,51,77,41,60,192,113,15,103,101,44,30,102,189,100,251,227,71,37,62,123,4,63,119,25,116,47,205,191,156,1,106,136,248,37,151,162,72,226,41,208,133,69,146,114,137,43,245,90,115,117,90,122,134,180,218,136,10,36,210,53,138,90,139,213,130,56,173,119,174,71,72,213,138,87,171,101,156,110,0,164,38,191,156,215,148,220,106,138,50,237,54,37,49,215,127,45,81,226,61,181,195,147,154,208,170,94,34,8,228,121,71,182,239,63,56,65,244,0,70,162,73,198,63,16,134,216,58,187,203,234,115,44,209,105,127,183,130,74,82,203,219,128,128,162,13,47,106,252,31,56,155,184,119,56,139,70,241,3,104,153,43,183,28,68,241,224,25,154,52,51,131,108,142,150,13,106,43,251,166,76,47,218,150,11,125,109,109,179,145,213,217,241,16,32,208,48,33,217,59,171,245,248,174,34,191,77,111,183,221,49,141,59,221,76,224,103,190,107,171,215,232,44,84,133,236,88,227,175,24,57,144,252,229,182,140,36,219,42,92,101,187,212,188,34,205,167,99,168,91,224,154,187,112,52,190,62,212,191,250,250,68,229,248,142,143,161,185,243,117,222,69,61,162,247,179,140,133,135,164,217,144,222,8,114,20,240,161,44,27,187,82,122,237,53,167,43,2,215,122,219,61,163,54,181,154,176,222,239,12,13,63,88,213,167,98,162,94,254,89,113,112,242,88,158,65,229,215,16,126,234,96,129,34,233,231,85,152,90,16,97,32,90,134,18,131,114,130,148,249,76,135,186,171,103,192,83,45,100,96,36,88,217,197,165,86,194,168,112,149,125,108,133,112,117,199,26,221,35,245,88,233,9,113,47,138,31,61,114,47,51,32,197,55,17,175,164,93,204,223,215,203,221,224,147,103,78,214,230,214,71,214,220,169,117,39,0,147,198,108,242,153,155,144,235,250,162,35,53,61,45,156,227,244,108,123,32,227,129,77,252,146,213,168,197,237,147,123,38,228,75,144,165,144,102,113,198,22,145,14,101,195,177,43,62,151,113,96,81,189,204,180,207,197,24,72,76,135,127,181,246,81,18,167,113,85,184,62,190,140,86,209,148,134,111,32,60,108,33,233,115,99,216,239,112,146,92,217,236,252,213,215,98,122,215,64,175,155,179,121,195,7,207,252,163,51,58,143,187,255,188,122,6,199,73,36,149,218,141,142,43,108,99,2,232,187,65,216,24,169,125,102,148,113,59,233,176,194,207,77,204,245,20,43,145,104,88,88,212,187,237,152,64,18,141,254,53,255,111,53,61,62,49,143,145,197,10,207,36,198,166,88,7,199,42,201,145,219,135,53,239,108,162,82,202,181,4,255,82,23,38,141,213,120,0,218,105,2,141,120,255,138,20,27,255,97,202,151,0,166,227,16,196,48,139,91,164,4,170,177,243,27,154,220,212,167,205,179,84,245,205,50,51,155,45,39,99,124,70,27,48,182,173,3,26,38,214,1,26,23,216,248,214,89,78,142,7,44,2,118,103,73,72,202,187,222,242,74,37,84,166,251,191,67,11,231,116,61,33,17,96,93,116,165,173,88,153,105,123,125,159,243,89,143,66,211,213,23,47,204,192,2,231,229,224,32,30,45,9,31,149,216,137,119,152,34,22,131,206,47,216,201,89,197,58,66,204,67,92,0,150,199,161,213,185,96,252,164,78,46,247,41,134,48,118,14,77,30,250,176,12,138,96,58,51,142,9,249,103,99,29,247,189,31,126,29,86,211,201,108,216,195,90,32,119,124,219,207,128,192,119,91,217,60,215,24,182,244,100,241,153,24,3,99,115,167,33,25,239,186,42,198,202,179,57,117,112,11,208,212,50,26,170,22,148,206,252,232,159,56,64,37,184,40,232,109,62,164,199,64,198,112,56,71,12,215,108,220,20,211,118,70,182,19,212,219,182,104,5,188,255,61,162,241,25,176,78,25,176,239,21,205,246,214,246,86,45,101,158,9,252,149,38,59,72,225,119,121,209,20,85,6,84,253,24,182,126,20,150,105,176,238,54,59,96,46,28,214,21,80,112,19,118,125,115,134,244,30,35,230,238,255,199,220,32,200,9,142,2,182,14,101,191,176,143,96,217,200,124,194,43,105,61,93,143,135,53,12,228,233,30,150,173,228,73,179,184,84,21,117,63,245,231,49,129,29,249,46,23,172,195,94,36,76,227,246,71,159,188,8,88,119,49,177,156,203,88,101,195,170,151,183,106,100,9,246,64,254,1,90,4,9,163,154,231,88,68,182,99,67,75,171,107,142,196,79,237,114,70,178,128,33,83,168,67,129,82,214,135,38,206,41,152,140,168,52,239,28,171,28,29,180,246,185,183,243,85,129,112,168,63,139,133,0,162,86,166,48,132,244,159,151,235,175,64,110,168,85,97,233,11,62,25,177,16,57,124,63,250,59,218,136,209,136,192,23,168,160,206,65,84,30,73,213,235,181,104,66,27,98,126,183,219,93,200,115,84,141,57,55,20,131,91,14,228,85,181,19,4,110,176,90,101,40,91,107,155,7,70,21,114,154,141,146,125,246,64,1,216,213,232,23,143,224,115,244,247,144,186,71,134,69,183,141,25,186,91,29,145,163,250,202,181,57,216,172,131,228,242,181,187,52,94,218,252,4,118,44,52,124,160,37,176,17,218,121,140,191,107,102,91,222,49,91,229,106,179,221,170,200,88,38,138,167,10,48,157,47,99,57,137,88,76,206,141,214,208,48,80,226,18,227,6,175,180,63,107,247,251,197,59,51,247,13,109,209,162,206,192,125,112,94,235,247,26,88,14,126,241,225,249,81,162,7,157,238,150,138,24,69,121,155,219,17,169,180,218,93,230,99,92,139,53,179,145,30,14,205,171,75,247,49,194,3,14,177,24,222,122,30,75,174,121,243,104,233,244,81,4,47,70,43,206,113,229,119,231,49,72,144,78,214,29,193,41,75,14,97,19,84,148,246,3,250,243,7,246,233,153,48,135,226,204,199,93,210,3,97,11,106,117,170,122,92,97,150,179,177,220,46,59,17,151,242,160,233,237,81,78,255,87,243,237,113,135,216,131,97,197,224,41,142,85,234,243,135,58,152,220,191,227,149,78,77,30,82,167,63,217,43,227,106,173,223,128,161,49,70,29,184,169,178,179,124,224,2,243,210,229,112,103,15,29,78,229,91,9,68,198,94,135,241,207,69,183,229,46,78,63,189,93,163,10,91,172,13,205,180,217,216,102,237,239,3,217,247,218,0,147,130,158,175,242,39,94,23,238,221,229,211,72,140,103,207,7,73,10,200,247,155,254,35,165,152,2,137,237,154,128,235,215,210,1,132,104,143,128,91,191,225,241,171,220,16,165,209,59,10,1,128,151,229,116,17,20,188,108,57,196,105,197,5,64,216,75,255,49,10,35,243,39,238,142,201,1,32,8,28,116,21,216,226,89,90,231,210,128,81,149,93,249,111,150,128,11,228,231,236,178,74,34,174,187,230,84,78,197,136,17,197,25,242,154,123,24,78,245,178,254,76,70,182,72,15,115,54,62,10,89,172,129,113,97,148,204,240,100,172,169,122,13,95,182,26,184,25,191,255,250,250,137,18,19,72,145,135,112,125,227,63,65,26,54,228,181,30,158,27,191,9,236,168,115,248,144,187,132,253,45,84,154,196,103,30,149,123,53,42,206,172,146,175,44,203,69,239,45,147,0,121,103,125,132,136,192,38,62,79,29,241,17,151,110,28,38,221,234,230,228,182,64,241,144,165,124,145,120,49,50,129,18,33,242,212,143,68,167,109,134,179,113,176,85,93,87,105,133,15,66,249,8,43,9,147,72,30,6,2,85,185,204,160,20,76,70,119,163,67,200,121,228,185,204,22,48,31,122,177,123,93,159,108,114,65,90,91,67,95,139,6,187,3,78,142,38,96,61,68,23,146,93,32,245,153,131,61,126,1,194,201,158,51,161,172,0,176,76,143,229,81,201,36,157,210,139,109,215,12,9,41,152,243,188,240,144,194,27,114,193,162,39,43,9,203,46,137,76,217,93,125,215,74,43,75,0,153,246,95,88,44,134,248,43,87,166,46,133,1,77,197,205,206,31,50,102,178,248,22,226,192,156,203,195,155,193,32,35,158,173,76,75,79,240,112,7,161,130,162,85,225,67,223,15,127,53,24,49,231,201,248,16,114,146,228,17,178,247,166,162,2,32,180,41,188,9,197,103,77,246,35,30,71,112,6,222,168,64,60,248,242,61,201,130,219,58,182,38,143,103,45,104,219,7,121,119,138,183,148,149,107,216,169,2,89,111,185,120,49,74,173,174,35,38,194,214,86,32,216,229,123,41,64,108,178,152,13,174,71,86,192,147,84,112,246,98,151,238,63,210,134,112,5,28,254,154,125,236,82,78,22,114,230,212,88,97,54,211,70,203,48,159,59,21,36,55,56,141,194,247,133,160,138,224,66,180,74,137,37,94,5,120,135,170,119,209,147,221,28,19,215,139,29,199,87,234,102,225,111,74,180,27,169,131,129,29,44,138,81,235,206,181,229,133,192,201,163,110,48,203,245,95,200,183,29,29,31,255,74,216,148,92,109,191,130,29,236,248,204,126,228,208,76,200,13,128,197,198,255,211,23,197,132,124,133,71,155,21,132,233,191,189,212,255,108,47,94,109,53,232,234,95,174,83,223,18,188,255,239,215,139,141,51,127,243,199,103,111,117,45,101,67,184,104,196,20,34,25,184,251,144,47,226,217,214,217,125,47,52,41,242,113,104,13,56,74,44,166,36,63,154,133,145,18,80,160,124,59,47,48,219,63,43,134,67,115,238,189,252,67,6,164,83,181,123,230,213,252,7,222,130,221,30,79,68,34,162,2,61,134,162,207,49,146,161,216,82,98,181,190,57,57,164,128,97,121,148,131,128,152,66,106,247,15,154,148,82,42,174,142,17,249,123,23,138,78,106,245,159,202,19,26,160,50,138,153,136,182,101,89,247,195,169,69,220,50,155,45,140,251,248,183,139,84,17,44,98,83,13,102,234,106,135,22,255,212,246,163,28,11,251,123,18,5,150,221,6,2,137,17,176,56,215,12,166,187,52,149,11,97,119,140,245,13,201,20,98,80,27,26,125,126,58,232,231,83,52,195,75,116,248,147,230,123,171,77,81,168,163,120,39,158,18,54,60,212,117,67,148,122,151,78,51,30,88,27,152,83,92,191,105,162,106,233,12,27,116,4,53,100,189,242,253,169,182,10,105,196,84,229,122,141,80,15,0,38,26,50,176,229,18,32,169,241,202,190,190,225,100,193,44,196,209,193,83,89,43,228,8,127,48,9,221,186,199,251,97,138,218,190,131,202,206,62,148,128,44,48,107,164,177,57,149,171,214,244,57,198,194,87,179,232,10,17,65,243,255,109,19,208,42,55,68,178,164,84,21,57,206,5,27,252,203,144,108,90,231,137,198,221,204,164,204,56,73,223,129,127,246,244,144,140,13,229,195,199,39,42,93,103,202,8,45,68,203,17,186,154,9,154,228,59,255,134,120,125,170,90,18,141,31,17,116,10,189,48,63,147,112,188,11,184,92,95,253,180,92,80,106,57,112,187,229,228,69,3,1,47,47,72,146,48,135,37,111,82,27,20,77,157,222,115,123,120,119,159,196,99,7,116,57,222,119,79,79,212,213,215,145,225,154,187,25,22,126,89,170,169,123,159,94,29,177,63,137,207,167,192,97,134,193,17,236,199,8,35,214,220,156,72,183,180,8,63,200,171,93,216,103,110,145,159,209,158,236,233,50,228,220,144,113,159,214,222,157,156,27,133,183,240,127,191,28,41,222,148,155,247,32,97,96,128,237,98,236,159,107,157,192,176,19,81,248,145,219,183,179,73,178,81,38,137,81,108,189,148,180,164,63,244,107,140,13,253,2,84,88,16,121,200,120,77,203,104,24,207,202,194,62,253,155,102,96,168,116,28,237,163,138,91,149,34,82,230,211,109,230,176,130,28,82,186,233,159,99,238,249,81,38,106,243,246,4,63,80,43,104,47,1,253,236,84,79,158,5,81,26,18,242,70,42,11,229,216,154,236,16,203,159,227,7,207,120,26,197,81,87,177,4,32,197,147,111,255,229,91,211,194,195,230,35,169,151,31,196,33,181,120,192,254,71,84,152,228,208,209,129,98,55,39,210,144,146,192,231,249,121,170,81,218,202,197,150,149,234,93,90,178,167,209,244,86,25,140,141,156,206,14,247,240,217,14,39,99,82,121,16,119,157,210,169,220,50,58,255,48,130,189,120,154,59,60,85,94,135,23,15,171,6,31,212,224,89,73,100,179,91,61,170,128,28,33,227,9,149,128,12,110,120,44,9,52,192,4,24,65,221,114,24,77,109,0,237,94,4,42,232,84,150,134,32,50,33,84,234,130,136,89,117,253,79,60,135,69,29,50,128,196,38,41,43,37,78,168,73,163,249,45,207,177,76,38,115,76,143,118,145,106,166,6,142,230,193,147,145,87,195,222,73,219,219,89,33,68,237,118,120,146,164,74,130,237,16,47,79,228,9,153,184,5,127,80,182,81,105,196,51,244,192,237,160,118,200,191,94,235,152,191,202,161,231,171,19,116,102,94,206,253,175,4,193,18,70,53,214,98,123,181,137,167,190,84,96,169,2,204,232,54,221,169,175,186,172,137,170,75,32,249,57,119,86,19,52,123,234,142,11,108,19,58,84,98,250,242,114,170,31,205,195,117,12,243,41,93,222,0,101,219,102,129,196,192,91,8,186,233,243,37,194,183,162,121,59,93,71,52,178,114,96,72,252,185,254,109,31,107,112,168,64,226,160,216,43,49,74,50,139,112,148,135,148,88,184,35,26,29,171,245,47,96,61,39,146,159,194,252,57,202,244,245,218,216,18,29,71,237,39,25,197,164,184,67,97,53,45,16,218,207,244,97,249,96,167,93,62,103,162,164,67,186,159,2,26,136,32,184,9,167,169,183,210,72,43,253,167,72,211,171,205,117,92,82,32,5,197,107,8,68,106,237,8,142,148,101,227,90,210,67,13,252,233,3,242,79,95,172,175,195,246,251,254,247,71,7,224,252,37,255,4,158,178,131,23,77,77,22,178,114,155,151,162,207,53,98,63,132,143,232,73,194,185,91,243,57,47,83,36,154,42,31,150,56,15,33,40,14,111,70,137,225,158,138,108,119,114,255,48,176,231,182,51,219,163,86,122,80,104,197,169,107,181,97,55,228,63,47,73,106,27,23,65,207,177,34,218,221,147,192,237,165,74,89,152,255,181,169,250,226,99,10,232,6,181,45,3,222,174,26,248,155,12,199,237,65,205,85,22,125,164,146,124,17,73,140,71,36,57,173,173,157,157,161,35,164,157,190,71,67,29,142,133,206,231,64,185,95,111,65,166,220,233,245,73,242,25,16,29,223,124,142,199,177,13,24,198,245,218,190,115,38,32,45,236,12,96,101,63,17,230,151,217,117,234,153,112,111,91,162,196,247,185,166,60,2,8,145,56,160,48,175,226,250,67,51,132,106,42,213,138,119,167,9,240,25,8,56,22,165,218,9,62,218,121,29,43,177,130,210,166,150,15,220,225,225,152,34,255,104,115,223,108,131,55,250,255,49,92,130,20,179,218,73,38,116,122,102,17,118,237,183,109,65,232,122,235,4,68,3,245,160,150,224,73,183,115,6,100,124,166,210,201,82,249,142,15,23,20,60,118,137,170,181,229,205,108,201,240,169,87,195,99,76,138,15,228,158,47,216,146,8,248,175,110,207,39,94,180,173,250,47,24,2,201,150,241,233,238,16,120,75,140,84,49,212,106,98,213,162,86,181,76,170,35,124,116,48,164,197,74,131,117,229,28,19,139,154,0,123,202,110,178,10,79,113,166,22,172,117,191,54,48,27,183,59,223,105,57,148,54,241,188,72,118,58,255,33,235,238,206,33,254,197,162,45,154,226,221,57,145,225,19,36,11,164,245,79,188,132,50,190,248,255,75,183,214,242,69,109,232,147,130,166,70,86,58,124,161,96,88,92,166,32,184,117,117,232,148,14,163,81,163,242,0,239,41,82,240,105,189,74,68,200,164,195,85,62,74,56,226,196,41,2,105,154,95,205,207,232,106,98,226,99,112,210,188,162,203,188,28,65,78,18,252,134,93,120,74,188,64,154,12,133,146,228,14,25,9,13,157,22,83,145,169,201,189,221,137,49,232,138,179,182,165,146,2,109,172,21,172,40,157,230,199,70,170,17,231,133,250,192,45,75,214,33,111,3,120,209,54,12,206,159,226,150,136,96,94,25,66,56,178,106,7,73,214,104,156,236,28,249,93,15,229,9,0,132,16,69,155,125,179,207,94,14,13,244,207,241,54,32,52,63,98,162,154,191,75,209,229,33,193,255,57,31,229,86,153,43,207,166,165,245,54,40,212,29,222,70,136,130,40,74,185,218,104,130,108,129,245,188,86,215,76,131,33,190,168,234,99,175,11,251,216,73,187,108,44,255,201,238,119,247,44,86,81,235,45,3,57,216,75,34,73,180,36,35,240,164,214,36,117,135,41,119,211,38,76,81,196,8,21,97,136,235,119,71,123,36,176,199,227,228,108,128,149,137,5,164,77,148,159,81,47,176,108,234,54,46,235,56,167,178,84,254,105,129,190,49,65,57,236,213,149,152,10,85,206,195,221,92,221,54,74,114,134,198,83,208,132,62,75,99,76,23,147,221,170,238,47,2,231,238,159,31,157,21,230,120,116,37,205,171,183,193,105,172,143,117,1,93,76,23,54,218,89,41,8,34,70,14,172,247,13,165,93,149,104,106,13,209,88,202,31,127,1,56,213,196,57,128,219,160,128,36,102,11,50,241,144,120,109,249,181,6,101,158,193,159,198,121,72,53,117,201,226,238,36,19,89,190,170,97,242,166,133,255,187,116,117,149,110,240,34,46,115,10,173,23,253,193,26,88,218,204,250,37,212,109,250,201,191,194,118,95,136,247,161,207,241,204,135,2,78,149,74,112,131,147,47,174,61,6,17,165,170,245,205,230,27,4,219,42,253,132,224,5,105,216,149,164,189,139,111,218,70,124,62,36,131,167,58,160,166,166,15,182,6,55,43,51,18,46,56,174,90,10,0,14,29,74,85,33,208,147,69,176,90,198,106,36,37,30,25,35,124,178,130,4,84,25,198,20,229,53,83,27,191,7,155,221,115,87,5,220,83,80,84,102,251,48,221,102,199,149,98,72,199,4,97,43,61,78,97,140,141,115,8,36,76,209,170,73,151,35,27,50,135,70,240,173,0,121,54,23,163,78,109,212,129,93,171,216,134,28,83,113,141,233,192,101,187,144,201,55,84,241,226,162,50,111,152,243,114,9,111,93,4,89,234,55,65,28,241,78,143,188,189,252,70,80,238,69,204,212,181,122,171,109,189,186,144,136,240,116,95,234,155,53,70,170,203,113,36,46,45,134,195,163,140,104,104,25,181,136,167,116,55,237,25,77,120,91,44,239,159,52,190,41,227,220,175,171,101,213,127,105,222,163,58,68,40,210,118,247,1,76,42,20,189,248,76,43,113,25,81,37,26,154,234,25,226,251,39,69,143,3,138,235,220,47,9,31,25,63,195,193,72,173,92,80,43,152,143,80,74,126,49,33,238,113,228,171,168,241,82,49,174,116,73,94,130,72,230,253,161,187,183,237,195,41,153,143,130,252,152,169,147,185,106,2,207,13,134,90,175,141,157,242,255,161,154,42,107,178,145,195,16,211,119,181,175,211,84,142,39,77,187,239,159,12,177,186,243,150,95,140,58,167,52,103,146,158,98,247,173,141,219,214,180,87,55,184,155,216,203,67,81,243,45,171,219,220,110,144,106,5,138,225,212,232,110,202,220,68,84,250,115,120,118,200,167,154,108,73,90,190,72,34,47,249,229,114,4,80,142,144,22,68,254,128,128,196,171,194,100,131,176,168,30,203,107,42,65,59,156,176,21,156,53,86,125,203,58,216,87,127,233,238,153,162,195,175,35,133,212,69,25,61,96,246,99,19,132,120,219,58,140,93,223,248,9,43,246,147,166,10,33,40,237,26,6,87,228,81,182,159,34,234,48,74,27,30,186,36,136,63,92,110,3,131,130,27,239,155,0,156,219,146,232,148,189,133,204,227,35,102,6,13,242,251,69,127,251,171,127,248,242,116,126,174,84,115,6,193,135,29,128,225,230,162,23,222,79,106,4,26,156,61,251,88,57,81,76,237,7,19,107,37,95,147,230,99,193,76,98,87,252,124,217,105,200,201,204,245,189,226,154,95,54,19,34,64,85,66,163,243,6,203,46,201,0,174,183,154,181,226,46,152,199,255,75,54,243,29,83,133,231,240,6,21,38,68,184,253,109,54,23,224,31,102,11,112,103,43,17,38,125,238,71,104,161,159,219,136,215,196,141,170,10,56,156,93,207,152,188,114,22,157,0,165,25,138,205,58,248,67,193,58,28,147,32,38,229,221,175,114,14,42,161,2,223,231,204,164,6,92,49,52,64,37,164,223,252,197,118,55,243,108,10,158,239,219,175,244,102,22,194,134,212,9,249,244,43,86,97,41,53,9,224,110,61,250,140,202,187,95,171,204,21,221,58,141,24,176,120,96,194,232,84,28,125,246,218,142,73,131,254,249,22,179,71,110,208,97,247,139,162,171,64,251,79,190,180,190,186,29,110,165,88,119,225,30,58,64,49,68,45,83,93,122,136,199,146,158,106,5,211,222,64,64,160,74,72,185,138,112,186,135,133,95,31,236,77,86,54,59,235,32,245,245,133,152,27,233,115,154,253,233,222,36,218,216,218,211,137,127,103,199,95,165,151,234,33,228,72,167,103,13,43,119,38,71,23,218,227,177,230,222,214,149,81,102,246,94,251,84,233,90,116,77,26,118,194,122,55,75,208,137,52,159,238,73,8,33,157,218,178,213,108,45,131,207,210,31,144,133,204,239,144,183,230,251,195,57,195,154,39,61,36,39,117,126,121,69,224,198,15,198,98,59,82,181,202,28,149,49,219,53,48,163,19,164,57,251,219,61,159,235,12,121,100,151,160,191,93,194,90,22,119,28,191,219,210,170,234,145,2,111,53,86,140,171,46,232,231,111,18,43,83,2,142,131,38,36,99,174,3,26,169,105,31,214,250,212,191,8,1,141,69,73,158,180,248,93,117,146,242,10,188,63,7,61,149,69,118,161,141,117,25,193,18,187,220,194,82,13,30,5,225,194,158,252,56,159,129,5,240,0,213,85,67,54,209,242,151,41,141,172,187,12,215,255,6,5,126,185,11,225,35,202,5,182,98,154,26,217,237,193,140,136,38,71,118,166,44,17,223,179,101,97,16,153,33,21,204,15,219,189,120,219,24,117,23,4,153,22,143,40,174,238,185,27,159,69,251,1,227,108,218,69,111,198,184,236,14,216,136,208,115,154,211,47,149,116,98,114,40,90,83,116,92,109,38,134,140,104,157,197,116,57,122,111,5,224,4,175,201,244,62,210,203,188,216,230,131,214,184,164,54,48,242,179,251,201,77,16,77,13,77,23,34,66,146,24,12,187,238,151,92,139,64,114,217,125,244,175,10,155,138,118,58,245,52,121,17,241,62,231,105,214,169,120,184,4,155,16,20,12,215,206,40,237,161,186,68,63,141,166,178,6,127,126,151,70,195,245,163,96,91,23,138,173,211,99,103,164,14,51,246,20,75,76,135,150,74,215,220,71,15,76,77,215,250,38,227,176,76,17,15,179,232,18,19,165,54,194,146,187,110,158,216,55,66,145,232,119,152,61,63,121,155,194,202,244,22,81,66,36,140,38,108,209,21,139,25,159,255,185,60,117,9,245,95,46,99,220,27,61,151,235,253,38,161,64,188,88,189,117,249,42,176,56,54,107,62,80,240,135,153,86,180,137,121,111,177,208,196,3,194,236,106,173,82,40,195,1,146,180,204,141,11,192,120,252,52,4,116,199,14,254,104,216,4,219,7,221,233,33,47,34,247,94,0,104,240,54,18,128,85,240,255,179,195,197,161,240,178,242,197,103,68,166,60,95,131,245,148,198,163,124,209,39,120,42,206,15,106,91,118,113,89,19,66,66,241,200,64,65,37,82,169,139,136,203,234,192,172,175,27,160,244,10,91,4,183,109,177,183,93,233,92,26,227,67,87,232,184,97,234,202,240,80,213,42,133,15,68,206,0,206,110,170,227,223,113,90,208,60,11,93,245,151,50,51,86,152,199,229,35,248,13,119,64,238,165,152,108,70,48,149,157,110,249,189,25,187,246,251,124,64,0,176,165,128,174,39,200,94,100,193,34,233,19,192,83,39,177,228,74,234,195,128,251,203,238,192,16,66,200,223,179,30,106,195,189,26,217,157,142,161,132,38,20,179,217,79,34,97,189,231,106,19,144,223,172,39,206,91,192,115,254,111,141,170,103,121,61,72,101,60,110,173,73,193,25,89,206,122,137,151,213,60,169,7,42,226,224,249,190,43,17,190,187,240,163,77,26,192,162,70,170,154,216,20,183,212,229,81,56,157,247,123,219,168,91,21,53,107,174,135,98,32,176,146,78,98,190,30,232,190,171,107,188,254,223,5,25,58,134,150,36,28,218,134,107,40,253,245,199,11,1,191,26,173,238,5,142,204,170,161,157,127,172,254,27,185,235,87,15,3,74,170,36,195,132,163,3,126,33,178,173,141,106,23,111,96,111,124,164,68,230,2,210,18,190,148,45,70,148,194,38,160,67,130,166,172,81,5,91,142,239,190,58,3,102,81,212,68,68,73,134,6,117,116,100,47,57,100,207,232,224,125,32,30,193,162,117,36,57,8,27,203,56,199,110,251,56,35,162,240,157,224,0,42,206,199,201,33,95,5,127,132,29,178,152,101,166,1,242,99,155,248,47,71,180,75,84,99,65,91,32,31,136,206,52,48,74,184,208,83,85,179,51,105,125,87,66,145,207,127,71,239,255,157,126,120,139,232,35,64,70,128,118,191,41,217,7,185,86,117,216,187,163,194,206,174,218,56,214,58,160,248,111,154,70,17,108,212,91,199,245,32,108,125,43,198,192,38,68,101,100,147,129,87,52,240,50,91,92,218,108,127,101,155,228,123,77,147,41,86,207,159,139,140,93,22,169,163,63,89,236,154,98,131,93,39,55,237,122,107,6,174,184,202,126,27,199,141,16,52,167,250,44,52,64,134,244,66,235,39,127,190,88,127,61,105,107,157,35,59,146,10,14,155,241,227,170,104,180,47,95,20,235,236,196,100,29,66,255,252,236,249,128,214,5,234,40,241,34,234,45,47,166,217,121,36,243,35,251,23,126,3,133,136,164,113,22,69,236,180,239,139,48,255,146,161,48,135,129,150,245,193,181,210,85,120,4,249,147,174,66,17,136,154,208,148,214,82,198,29,171,4,223,212,84,104,93,95,153,151,59,52,212,150,113,85,179,189,60,151,118,28,93,220,49,114,124,228,164,99,165,40,1,5,200,121,138,132,77,15,5,21,162,216,252,37,141,224,202,125,209,225,242,62,177,195,93,254,238,77,226,148,168,119,167,195,151,180,25,60,215,48,166,94,44,45,114,159,78,24,155,132,119,38,31,231,227,51,37,35,33,239,40,171,12,250,68,190,248,231,228,59,213,61,15,65,53,179,92,176,23,172,176,32,72,135,37,241,24,107,242,184,186,57,99,239,241,14,0,114,211,202,79,176,88,52,130,56,18,75,55,22,208,79,100,1,57,105,53,174,100,13,234,232,158,118,211,9,144,128,160,76,177,166,10,90,95,110,144,254,243,190,208,135,184,198,226,200,27,9,38,241,0,208,210,237,180,2,22,149,157,19,155,249,21,3,55,195,149,105,206,24,110,148,19,249,58,78,186,176,25,100,216,4,198,194,104,71,150,103,193,54,223,28,146,80,51,157,194,14,178,180,189,161,192,44,225,168,111,47,225,151,43,100,26,191,125,146,222,221,199,216,186,126,173,89,90,229,77,60,34,228,75,219,182,85,232,170,22,24,130,197,101,20,253,116,141,176,241,34,223,208,190,53,49,201,93,144,151,241,108,236,120,86,232,128,234,238,83,111,80,172,96,67,34,128,6,29,10,136,122,7,204,83,50,186,1,23,79,169,21,92,114,15,132,236,51,188,123,139,240,236,199,67,208,132,52,13,194,187,174,29,120,140,151,198,252,88,147,102,219,35,162,73,126,98,77,213,8,169,217,193,210,100,239,19,153,49,43,252,194,75,228,65,143,184,39,77,42,202,171,40,113,137,164,157,33,120,131,63,197,218,5,250,238,192,175,128,92,206,161,173,254,238,133,100,158,136,16,101,127,238,52,208,92,82,3,217,66,93,246,228,193,254,74,72,78,122,33,105,54,8,66,93,246,194,222,27,194,33,125,31,125,186,243,13,92,218,44,36,132,226,180,89,124,205,104,135,159,122,252,15,162,223,62,10,250,171,0,131,127,85,178,231,79,207,40,253,46,196,118,242,128,72,35,191,117,82,21,59,50,253,123,77,220,143,104,20,203,224,176,13,252,32,28,67,43,91,75,244,94,186,135,19,180,199,223,127,142,98,37,239,28,103,87,65,235,18,238,103,120,238,30,86,59,98,172,2,220,161,99,43,3,209,122,161,55,146,255,1,36,249,99,184,3,3,168,72,232,46,73,223,106,79,159,210,38,156,147,51,126,50,165,108,52,49,96,42,238,80,99,70,146,206,224,54,97,97,16,213,14,248,251,126,49,66,87,134,179,227,232,143,91,185,125,0,158,183,5,242,48,7,152,160,171,198,163,34,181,199,170,68,125,93,97,109,136,230,150,33,113,56,104,7,226,175,49,100,51,84,213,22,135,7,237,200,148,72,116,142,163,153,122,86,4,164,15,210,118,24,67,210,223,220,137,144,48,144,180,185,234,2,241,154,213,43,109,156,143,172,26,128,135,231,119,24,217,131,61,148,77,141,150,92,115,120,2,154,217,75,86,241,208,171,108,103,82,89,209,129,238,172,132,255,207,27,146,164,74,184,68,92,141,13,124,214,138,185,244,149,236,189,182,103,67,87,10,32,216,220,143,80,210,206,245,104,149,139,20,55,5,113,172,207,125,29,89,249,19,112,108,14,88,182,201,165,18,10,245,121,6,178,148,34,12,59,196,61,173,239,178,241,33,155,25,242,134,32,227,233,188,135,113,163,52,64,251,178,224,118,246,79,167,5,63,212,177,112,180,80,242,169,49,210,21,134,141,17,157,190,91,64,227,91,38,133,159,225,105,247,226,195,200,172,31,220,215,170,68,107,20,234,183,178,143,56,158,107,86,223,172,215,193,84,10,65,89,99,158,61,203,224,96,108,213,54,164,149,13,125,118,120,95,189,114,57,41,211,241,237,209,190,6,62,79,184,242,245,149,195,91,85,198,131,178,227,71,202,112,154,51,82,29,130,223,121,113,6,199,251,129,30,201,68,187,181,197,35,52,79,104,12,235,40,127,72,62,197,101,25,50,235,135,22,61,18,204,9,17,58,139,193,112,118,161,34,157,65,113,190,135,176,140,117,20,216,176,111,50,116,217,162,214,180,80,45,31,21,53,93,2,228,123,100,207,17,230,207,97,240,183,85,31,41,46,45,3,43,72,155,187,165,203,128,67,28,120,236,54,20,65,238,109,110,179,222,136,198,17,77,149,130,251,103,177,204,150,184,189,37,5,55,241,217,14,130,255,116,126,175,235,144,116,140,66,14,51,205,67,99,220,51,208,79,206,154,127,22,85,71,77,215,145,255,44,243,64,209,227,67,73,110,151,218,87,197,55,237,118,245,39,169,244,170,245,203,108,245,142,50,189,176,80,21,202,93,146,1,53,148,177,158,56,213,31,235,149,163,76,7,160,96,185,175,209,247,27,135,158,217,147,16,10,240,197,137,20,206,239,82,56,27,22,220,198,2,89,79,127,31,142,1,6,55,182,200,142,137,107,201,174,111,181,210,207,62,30,104,243,208,79,121,233,86,23,51,192,246,38,237,63,185,68,166,75,123,229,116,251,234,207,59,122,231,68,113,211,62,70,25,143,151,209,232,208,160,147,131,216,54,242,90,239,63,40,144,174,63,16,36,202,26,114,183,89,217,89,136,230,91,48,252,125,202,164,150,89,145,56,123,247,12,54,155,187,186,61,40,196,208,28,136,119,101,36,210,226,52,175,235,200,109,39,72,109,208,243,138,191,212,112,241,255,140,84,135,41,149,18,74,71,117,169,225,47,36,251,47,104,143,61,234,88,50,148,255,119,218,157,33,205,193,198,233,229,11,62,162,92,119,220,137,255,123,184,226,35,157,8,174,39,63,216,248,137,225,131,8,2,82,204,80,214,39,91,209,189,161,6,81,144,36,198,76,197,109,194,10,4,72,54,53,184,115,91,225,10,11,168,200,46,218,124,246,135,15,89,53,166,8,241,71,83,123,154,209,50,174,37,55,123,83,140,20,54,44,56,182,163,26,6,6,190,38,53,147,232,222,149,68,107,255,157,252,151,137,92,252,145,148,33,103,9,72,231,13,116,195,38,2,23,236,159,143,19,6,218,213,124,179,244,182,30,110,173,19,168,90,131,57,252,205,106,250,34,115,21,156,227,2,178,233,51,164,166,165,72,112,14,41,93,38,111,111,37,191,106,207,33,185,185,90,72,233,134,236,98,171,160,112,169,40,190,94,93,171,234,98,137,93,127,65,248,80,186,131,116,191,197,63,31,50,255,195,58,34,142,54,220,246,198,63,55,183,44,126,0,217,209,232,158,8,7,110,86,107,240,61,28,52,138,97,149,20,247,180,192,143,33,83,155,177,22,187,216,48,139,83,169,139,99,123,154,74,125,236,38,59,46,27,30,157,211,15,232,203,47,94,136,56,194,51,139,205,174,21,161,217,7,160,227,59,236,156,91,143,154,27,42,117,22,168,18,246,201,35,37,107,157,58,5,158,76,100,112,62,84,117,50,22,6,96,111,120,207,116,151,161,13,67,239,116,206,98,64,136,103,8,201,197,9,81,239,18,226,93,190,46,81,229,232,167,200,193,215,90,182,212,93,78,67,26,105,97,197,49,164,150,52,143,248,121,13,95,217,227,206,14,80,200,179,171,10,146,200,142,90,137,125,253,146,71,131,33,45,48,69,241,119,153,254,188,241,25,222,97,30,63,46,136,159,57,134,89,0,129,234,189,184,64,200,208,245,48,167,116,134,99,230,3,164,217,19,159,106,99,97,202,22,164,70,66,13,97,32,58,239,114,37,9,60,59,67,157,37,172,251,50,177,13,116,63,7,119,74,90,248,108,175,187,95,134,112,101,157,132,160,143,70,245,232,144,69,184,106,150,9,184,122,224,32,162,162,167,166,203,10,237,99,78,75,217,159,250,237,184,75,97,163,68,55,215,93,14,236,225,12,141,49,8,40,126,117,77,135,80,77,205,97,75,21,26,145,221,123,172,2,182,77,86,93,204,86,114,144,92,13,141,25,97,222,15,100,182,160,159,142,35,220,49,107,187,208,137,105,153,135,0,174,222,172,239,170,133,207,178,208,164,230,211,2,139,92,32,192,133,89,232,32,239,245,110,166,136,37,21,196,131,79,242,98,209,25,180,252,102,119,100,85,102,115,189,106,122,226,157,178,221,143,154,92,187,57,68,241,18,33,225,250,134,114,116,72,134,250,27,40,97,219,30,86,74,184,102,193,26,66,181,24,165,153,255,190,75,185,18,121,114,85,220,59,224,145,174,176,36,67,144,74,196,161,88,9,48,79,220,4,67,25,232,105,176,32,242,28,201,66,116,178,36,164,218,208,31,240,68,239,166,138,242,198,226,27,136,232,255,174,210,152,60,200,61,15,238,2,218,231,198,130,236,180,235,65,221,66,82,162,92,235,251,20,38,65,92,156,106,85,0,144,25,182,28,226,88,153,34,253,19,27,116,90,101,248,35,202,216,184,19,35,2,94,8,209,254,66,212,135,68,219,185,32,107,225,25,227,136,211,138,181,174,112,128,190,66,165,251,135,185,108,40,159,222,177,26,58,26,148,218,89,13,15,27,236,24,118,78,33,185,174,168,219,230,119,230,179,169,161,57,118,97,227,203,9,125,55,136,197,112,94,138,136,230,112,204,245,136,116,59,13,75,68,121,43,122,9,22,252,149,172,182,118,113,61,53,171,44,42,118,178,166,69,222,44,157,34,128,126,179,24,154,159,106,149,17,227,58,143,176,241,222,56,42,62,181,26,208,33,24,30,33,112,83,127,84,65,41,251,206,115,178,2,222,106,153,209,238,98,208,200,210,177,133,86,65,23,104,110,177,161,96,79,57,142,162,15,207,173,153,56,254,250,73,76,74,43,36,200,57,145,60,95,227,21,147,221,41,171,192,107,234,251,74,126,3,247,128,122,243,153,128,202,238,189,17,198,179,70,97,245,190,200,231,176,186,98,217,254,45,230,228,185,78,204,155,64,247,183,255,152,161,26,12,21,183,209,199,194,177,1,221,95,77,76,253,203,104,7,192,167,209,180,50,138,227,189,182,231,239,238,168,59,221,119,154,107,247,102,200,51,40,120,192,133,47,249,238,189,123,233,117,188,210,82,68,72,178,111,103,77,144,205,181,97,1,172,166,152,242,0,187,181,174,188,39,82,5,75,21,213,113,66,102,62,173,169,132,21,120,138,226,211,39,44,143,160,126,74,108,191,13,117,58,148,234,239,194,161,161,156,231,240,170,77,120,106,63,168,175,231,243,60,192,181,236,20,52,239,78,141,78,130,59,219,80,208,24,37,165,109,209,49,251,9,62,80,50,249,181,232,42,228,47,166,191,144,176,206,148,242,148,153,182,121,24,128,65,137,42,161,119,66,94,240,11,55,102,122,7,205,142,144,144,180,47,60,218,192,149,85,15,213,83,8,79,215,104,8,209,172,222,200,242,28,255,51,185,167,33,226,26,65,147,100,114,222,54,27,170,212,207,83,56,170,37,126,121,14,18,40,231,4,14,164,248,6,110,118,48,51,83,228,76,3,131,87,77,86,163,48,72,194,109,53,105,118,111,198,140,133,34,20,119,56,35,236,7,170,176,164,95,86,183,232,105,108,7,25,169,127,50,26,86,83,94,101,58,219,72,205,46,231,78,158,94,221,190,147,92,96,224,0,30,65,191,21,237,118,106,224,247,161,116,33,41,10,92,81,248,232,191,41,72,116,171,89,110,208,62,230,196,11,67,172,81,188,8,212,62,255,199,22,201,68,20,120,21,90,72,70,211,251,61,232,5,238,147,16,91,225,65,103,178,238,63,246,157,100,192,170,206,249,101,28,25,120,125,225,94,105,146,218,75,10,178,103,244,73,77,174,18,113,205,198,233,5,88,129,66,64,72,137,118,81,217,130,206,156,174,224,223,115,249,164,10,160,47,237,255,135,146,236,13,99,71,63,62,20,134,132,135,155,27,21,239,159,60,195,224,248,123,205,45,147,225,233,72,95,151,236,249,144,43,148,51,197,175,100,140,185,170,200,234,37,87,113,85,41,197,41,164,33,181,64,228,58,125,41,220,43,111,47,37,139,69,75,126,166,210,12,7,175,6,63,122,236,237,156,149,142,254,174,11,37,215,82,200,54,62,74,43,2,249,172,218,115,203,91,14,165,110,103,178,200,5,226,141,45,42,68,130,198,173,253,230,217,122,113,39,163,182,160,231,100,179,40,207,8,27,212,22,174,85,58,27,55,118,83,118,244,201,68,167,205,50,31,36,17,250,228,187,200,203,159,109,44,83,197,240,214,82,128,207,62,237,127,108,238,226,36,190,44,152,27,248,90,79,254,43,191,182,206,138,179,239,133,27,56,192,25,166,40,83,172,241,62,178,172,53,58,205,73,6,139,66,50,24,22,193,232,205,173,161,67,139,236,13,114,239,156,46,253,12,218,238,6,255,169,98,117,8,215,156,102,178,212,208,18,175,147,108,96,73,71,115,87,75,254,77,61,212,49,252,42,72,23,95,49,206,208,189,203,240,139,4,56,101,109,139,204,117,23,213,104,47,1,254,115,179,25,96,58,221,157,53,112,19,110,172,118,168,11,21,171,109,123,100,79,124,202,172,155,236,144,86,224,44,183,119,167,51,180,139,191,76,201,173,212,215,120,148,255,149,110,69,229,152,112,197,133,178,122,15,23,55,103,67,13,152,239,59,168,53,175,130,232,143,236,0,96,95,206,91,141,167,127,199,149,82,51,222,51,43,148,225,183,56,32,68,76,97,35,154,233,207,47,2,29,114,143,36,159,81,168,169,22,163,74,208,233,149,204,129,138,138,13,48,180,42,41,155,141,156,228,19,71,135,137,63,119,146,67,61,236,133,52,209,164,39,67,110,28,5,36,100,159,52,79,220,118,89,126,230,63,180,117,243,165,179,147,209,255,162,97,177,43,45,86,56,48,223,195,122,39,130,118,8,183,36,55,42,221,83,72,74,95,130,91,23,121,226,221,206,241,204,44,105,177,188,105,190,84,106,225,244,183,44,76,188,169,150,98,155,208,244,161,94,75,232,173,64,126,153,184,124,75,229,87,31,209,154,93,125,64,53,167,155,250,167,122,169,184,231,14,34,61,208,47,179,182,194,37,87,240,10,125,2,26,125,232,189,207,199,3,153,204,157,148,33,93,160,134,67,238,203,126,198,203,210,112,25,199,23,136,192,135,207,227,224,213,125,17,93,230,177,178,164,152,162,80,107,50,52,221,42,20,128,143,202,168,22,91,223,159,118,214,249,29,184,124,24,124,1,183,54,43,61,91,155,116,241,94,157,187,60,100,244,97,97,177,9,57,90,72,245,38,31,86,172,41,102,15,35,39,4,233,141,9,165,41,137,229,44,122,16,181,99,178,84,124,207,34,140,41,145,250,172,186,100,100,156,162,5,126,187,160,57,183,240,17,46,181,44,120,144,141,151,142,129,195,192,11,203,241,78,134,142,214,106,198,94,141,84,62,51,127,110,9,65,150,68,221,157,131,236,130,114,10,128,197,13,157,252,8,165,223,138,108,179,156,231,156,82,132,196,202,13,64,69,92,110,180,238,15,125,240,30,231,134,56,66,31,193,191,100,72,106,233,11,113,8,121,238,178,117,107,157,215,58,43,212,236,53,215,214,1,16,192,173,175,231,62,113,26,94,248,47,30,36,232,160,227,75,161,127,33,5,192,210,69,155,249,190,217,224,42,17,77,54,231,20,45,5,116,154,154,80,74,148,126,85,137,13,59,123,226,167,20,148,24,19,123,17,78,46,126,232,255,147,20,83,85,103,16,86,141,246,211,162,58,245,162,77,31,51,40,174,164,117,38,201,18,8,240,124,226,180,213,190,92,223,249,184,227,8,168,86,142,19,66,247,142,54,135,218,13,197,216,225,152,61,155,156,171,88,150,158,129,132,144,138,13,21,166,17,156,62,40,147,131,134,66,228,77,177,184,53,207,92,208,3,16,2,45,215,154,73,196,92,47,104,0,94,23,103,132,206,81,105,63,84,231,7,205,95,148,128,250,142,158,42,49,223,26,22,72,27,211,39,245,201,245,4,127,48,221,21,121,201,223,108,209,6,93,31,85,112,207,74,123,201,78,249,139,38,60,134,47,225,21,74,31,177,146,41,144,16,100,28,219,207,21,104,154,200,135,169,238,147,227,243,217,211,187,109,182,74,223,148,201,132,46,26,159,121,196,145,148,161,153,126,127,103,44,44,215,135,248,8,157,23,184,220,82,173,81,229,136,173,243,230,69,68,158,137,156,73,166,209,116,155,166,231,141,186,187,84,175,227,63,227,13,18,245,222,185,2,9,97,179,58,174,246,67,94,255,153,44,100,138,172,19,5,67,221,82,20,224,61,104,222,44,53,106,82,147,130,225,31,218,140,64,109,45,5,216,165,119,100,159,228,18,213,150,192,59,85,135,249,36,228,230,57,28,67,206,105,230,148,212,28,106,92,97,2,31,152,107,208,11,10,205,238,102,126,66,83,190,233,77,232,77,96,85,249,251,119,192,179,5,0,198,67,127,22,157,78,146,64,204,6,39,200,12,229,227,234,242,193,195,141,125,107,248,143,210,251,18,220,67,240,110,48,114,110,15,160,241,14,133,152,132,225,44,134,92,88,11,167,164,225,12,234,164,92,9,175,74,190,164,193,157,232,4,137,216,80,165,124,20,254,221,2,198,63,217,156,135,119,4,178,58,153,215,139,67,52,172,206,47,40,75,33,86,67,63,41,10,20,37,237,37,156,4,13,25,23,201,228,9,237,67,16,22,116,17,184,162,203,188,227,13,110,65,231,79,200,61,118,207,68,161,90,71,47,113,31,224,165,90,23,21,239,63,80,176,54,103,99,60,125,72,207,90,110,231,121,225,205,35,28,16,137,252,136,94,179,14,97,157,227,66,82,219,137,26,78,157,181,147,28,161,251,43,196,201,53,245,149,152,194,86,91,70,203,91,114,199,241,212,180,125,44,131,135,116,26,132,69,27,84,222,132,88,96,163,119,62,129,249,230,33,147,28,124,23,172,231,132,144,182,235,125,193,70,233,206,77,27,210,203,223,213,95,105,230,117,205,214,164,126,23,240,10,34,237,211,43,162,138,230,118,192,86,247,125,167,215,62,26,113,209,175,19,231,246,167,150,22,44,69,31,236,205,198,210,214,123,93,60,9,175,131,96,145,71,92,190,209,201,225,103,43,204,242,98,253,129,95,56,223,107,29,87,165,180,44,49,28,37,42,83,215,122,91,126,77,38,243,71,213,191,223,14,76,247,97,110,190,120,147,167,234,237,10,98,148,45,218,3,23,117,15,148,142,173,118,236,90,31,27,85,54,188,202,253,43,102,109,130,17,8,239,241,89,212,14,29,172,179,90,8,104,5,203,117,188,43,184,167,54,8,100,136,17,55,201,102,193,221,245,173,86,65,162,176,40,92,214,101,18,82,59,131,63,156,187,219,65,190,115,172,242,52,181,80,109,165,136,98,148,149,152,234,86,143,132,100,239,159,119,163,250,30,130,119,190,45,58,208,104,161,144,10,202,200,31,177,215,242,236,78,3,151,34,8,16,172,231,112,71,159,168,32,208,230,50,84,234,214,40,92,65,60,148,117,76,216,111,91,121,177,66,86,123,55,54,126,46,118,241,103,105,245,89,242,0,0,166,87,7,145,164,227,90,30,10,4,88,64,114,70,127,14,161,218,198,16,35,230,115,54,65,108,190,175,186,252,79,33,24,82,118,130,249,181,253,61,28,154,77,227,209,111,63,61,68,223,162,41,90,176,37,114,169,199,77,160,219,199,22,79,240,212,158,243,217,226,74,158,215,193,166,204,82,135,0,106,12,155,150,113,241,197,33,205,6,16,19,118,164,194,115,243,112,162,251,134,203,122,124,61,242,68,140,200,131,168,172,123,48,70,132,227,199,3,196,130,48,55,231,64,216,195,86,36,160,233,137,145,108,224,93,218,61,107,191,138,171,13,215,212,65,223,117,85,120,109,207,141,12,23,221,175,68,130,129,185,138,67,225,85,127,85,215,75,146,79,69,133,10,129,210,51,71,147,116,11,104,76,194,87,78,137,12,108,185,53,10,210,35,135,33,203,224,96,175,47,98,138,83,60,163,16,100,51,21,186,245,7,153,128,164,73,27,189,195,13,61,255,96,12,174,169,37,39,235,177,224,137,71,128,240,63,137,238,255,68,185,212,135,190,156,240,184,158,113,210,241,119,224,63,177,236,63,172,135,117,74,27,187,227,253,246,222,134,197,251,197,243,107,188,160,85,252,111,4,141,195,243,91,73,226,144,131,109,136,10,172,209,186,95,172,96,107,43,22,44,176,226,122,100,50,28,65,163,62,235,88,16,254,97,48,250,64,155,101,21,83,64,255,189,98,142,60,20,184,3,54,87,20,50,178,254,138,105,53,169,141,5,88,57,244,207,138,191,208,185,54,87,134,70,182,197,77,248,201,118,133,148,231,106,241,215,91,61,184,61,250,9,140,91,66,203,141,93,171,166,65,183,29,234,196,85,230,194,177,148,240,126,71,14,92,212,2,120,179,141,11,42,166,15,45,196,187,30,249,247,104,244,5,25,126,208,252,253,157,224,36,138,145,222,221,213,15,204,112,217,50,193,215,194,2,248,214,48,43,229,7,204,79,218,223,82,137,114,228,41,220,68,157,35,245,242,213,255,141,189,192,243,63,72,119,222,107,252,230,192,211,47,186,209,144,213,221,185,22,152,208,54,130,76,100,242,54,210,211,40,29,189,40,7,183,252,209,130,240,76,107,14,110,35,151,57,0,187,180,78,210,153,198,18,212,33,205,72,211,89,150,175,136,7,138,13,18,93,226,93,52,171,126,188,165,113,29,15,231,234,11,67,54,164,115,158,58,48,20,202,65,198,247,224,202,190,45,10,153,146,148,150,218,67,157,27,190,197,15,182,135,56,130,43,203,209,174,134,100,81,179,58,182,229,1,155,224,135,148,214,99,38,92,212,220,49,17,170,248,161,123,88,92,5,119,19,210,149,12,254,121,21,140,38,10,247,25,4,22,186,68,1,211,221,109,182,103,137,4,242,129,66,67,138,61,50,131,83,208,81,53,132,36,86,63,33,62,142,250,210,195,68,246,210,84,77,150,182,48,140,129,1,24,195,122,107,160,22,129,227,250,27,102,21,127,52,229,47,19,58,21,47,132,85,233,11,183,119,3,54,223,94,30,168,153,3,202,62,170,29,46,235,105,186,122,192,71,128,73,149,47,98,46,122,34,64,101,76,177,160,154,47,174,96,118,108,73,203,121,15,19,101,72,99,177,70,118,219,124,182,128,41,154,76,22,204,166,120,224,174,35,27,29,63,8,248,217,183,247,192,11,141,178,28,4,184,73,111,64,221,65,220,21,145,34,163,79,94,28,225,40,146,182,182,2,244,18,250,136,64,65,3,121,52,149,19,150,105,221,244,244,247,77,249,155,100,216,128,178,170,122,153,140,221,2,88,211,227,255,108,191,91,6,185,100,148,31,75,245,179,229,46,107,30,214,20,93,198,142,86,108,83,131,235,38,107,38,203,229,248,160,22,216,41,215,22,55,59,211,156,38,76,79,202,176,49,88,161,162,206,46,81,83,200,99,138,117,40,110,2,84,142,165,212,63,185,183,35,165,96,218,110,177,40,36,21,19,181,76,171,145,175,144,249,115,42,97,99,152,49,128,122,54,8,136,236,196,46,137,181,211,218,83,112,177,64,193,136,89,220,176,221,204,172,174,154,77,96,166,191,132,59,141,90,169,6,46,45,84,193,160,209,49,6,199,255,3,129,73,146,92,31,226,30,164,12,7,148,241,217,3,113,226,199,81,146,95,141,45,176,205,253,233,128,78,74,123,244,138,154,234,99,11,241,18,251,174,123,196,122,254,82,210,2,90,216,87,97,38,253,160,197,255,134,152,168,162,17,72,133,41,122,235,85,154,133,172,162,240,103,107,149,216,192,182,55,27,163,94,52,129,61,154,61,11,135,223,222,154,217,53,135,124,181,120,2,41,107,239,28,32,232,45,27,51,86,176,14,7,40,249,170,100,67,101,131,23,151,200,74,151,82,184,146,40,7,64,240,146,253,80,218,150,108,16,186,224,225,98,8,166,177,252,0,35,95,107,137,80,130,116,129,161,149,37,52,149,240,167,11,50,129,134,80,126,16,233,201,206,97,186,68,205,245,254,241,139,20,5,89,162,39,98,188,107,186,119,233,101,250,245,150,241,120,191,39,29,12,121,31,198,242,252,230,85,160,112,172,171,128,29,103,65,246,39,126,74,92,140,142,56,181,82,101,195,59,71,4,8,9,42,98,180,136,41,26,56,252,4,230,102,239,251,161,183,106,22,54,238,250,59,61,243,9,189,77,195,254,119,234,124,186,211,5,26,88,176,159,87,101,242,100,179,102,218,39,85,82,118,109,146,144,225,73,28,78,77,189,135,29,192,12,95,153,113,248,50,171,113,241,189,121,194,155,247,109,70,124,72,61,27,79,56,185,218,51,155,130,98,183,1,100,60,85,55,160,158,110,41,58,63,216,176,49,228,195,87,118,254,105,223,41,138,84,41,78,214,111,49,206,175,91,190,57,25,68,120,22,127,85,81,202,226,197,123,156,169,249,12,182,148,31,115,211,146,41,208,248,249,197,188,103,47,138,8,117,43,130,28,28,102,44,149,38,221,176,211,11,76,148,186,176,252,87,62,69,3,88,80,123,168,196,245,128,224,186,224,99,220,46,237,181,88,159,161,175,204,237,160,154,13,131,12,99,88,171,231,111,242,238,194,193,15,3,254,152,148,114,131,215,216,106,245,73,197,176,147,149,25,185,200,252,52,225,236,86,240,34,22,76,102,243,132,148,11,204,125,58,185,37,184,188,4,169,89,249,104,232,254,3,96,102,68,177,242,8,251,188,177,100,48,1,248,177,185,181,108,161,130,117,35,229,28,94,131,105,31,242,158,200,167,63,124,21,55,142,139,10,202,5,82,209,8,37,48,22,47,237,174,182,254,11,32,46,255,142,78,113,207,192,187,172,174,16,156,90,26,138,142,57,129,2,59,148,175,197,194,242,205,81,57,214,199,206,60,204,225,254,113,28,148,222,242,209,101,104,98,108,237,223,49,114,212,129,78,146,78,208,40,162,230,188,127,198,195,47,15,146,82,173,159,186,217,133,148,237,194,5,33,102,245,90,65,8,165,35,12,231,205,62,97,232,36,7,127,30,119,233,149,99,221,178,173,102,226,168,250,196,60,181,5,125,126,243,158,64,110,37,30,195,162,229,136,241,198,229,105,88,85,49,14,96,84,216,55,253,53,92,172,24,38,54,35,37,50,118,149,84,244,199,203,56,87,218,44,100,7,25,135,147,55,101,115,200,99,37,8,239,72,221,30,76,8,86,146,55,44,91,241,31,111,230,90,185,168,144,245,50,43,46,238,33,229,223,34,244,14,118,219,103,141,110,249,21,49,255,202,251,214,126,66,144,34,95,94,195,240,131,109,100,123,73,158,69,82,217,206,59,169,190,31,185,211,83,88,73,74,185,229,228,147,57,21,198,39,234,143,84,167,170,144,247,206,56,43,55,104,193,157,220,89,125,173,151,17,4,10,18,124,244,41,133,194,59,11,202,98,174,212,26,19,95,71,26,82,242,133,85,125,4,131,36,108,37,250,255,99,63,15,53,173,129,255,175,83,105,132,142,35,4,243,133,67,237,220,88,25,169,219,83,229,33,83,46,251,0,111,226,87,41,226,98,245,208,93,251,94,207,210,41,146,56,119,137,32,0,61,212,6,161,219,144,112,202,88,124,132,83,197,240,185,196,152,34,202,136,59,198,165,5,136,11,246,158,60,3,176,105,203,207,70,162,187,45,160,39,60,82,115,113,239,37,166,188,235,215,222,227,65,73,188,70,178,98,215,247,7,12,10,4,216,139,202,178,125,231,103,79,61,127,58,10,202,75,42,107,139,214,172,4,14,3,23,73,247,52,158,78,61,218,235,79,191,182,70,127,157,34,208,242,177,248,153,110,42,50,168,186,212,159,202,174,245,161,60,197,47,221,200,111,195,231,35,136,145,196,62,119,52,247,41,50,41,64,94,231,136,149,213,174,127,157,61,143,47,166,152,59,245,186,16,70,32,201,49,239,157,90,225,122,138,88,158,93,59,121,246,69,151,25,182,189,199,100,74,131,123,99,103,185,138,240,169,255,83,8,240,13,159,156,5,223,181,247,243,244,179,90,207,159,36,69,34,174,29,39,12,198,108,220,130,2,10,203,188,206,67,116,209,27,67,170,198,93,113,250,14,198,254,196,37,146,198,0,245,162,19,196,105,30,136,94,211,48,61,213,53,160,236,102,140,240,236,1,246,124,73,73,184,88,243,157,125,154,77,39,104,111,1,205,78,22,233,44,37,253,92,198,51,8,211,150,43,192,106,122,208,21,123,140,14,148,222,144,217,194,15,242,120,80,45,66,71,74,147,132,37,185,45,165,41,76,166,143,130,134,3,4,15,104,214,102,179,162,238,195,200,235,20,223,172,249,110,37,43,216,136,128,232,235,48,215,2,250,173,82,109,146,30,125,217,231,73,206,65,2,40,45,35,163,248,230,102,19,67,102,0,76,64,7,130,23,167,105,28,152,26,73,234,15,36,35,231,146,205,50,217,164,199,154,192,15,19,80,26,30,181,14,197,12,131,88,61,140,86,85,233,182,210,78,143,77,63,177,30,176,10,224,14,137,130,162,84,191,108,227,75,85,115,237,159,119,222,168,131,18,13,22,92,110,176,134,71,180,31,116,154,111,4,116,74,59,2,191,75,114,181,184,238,106,236,202,251,63,247,48,35,155,172,61,122,174,26,38,3,176,42,15,71,195,153,55,66,191,33,169,177,220,36,95,177,66,86,173,31,180,219,166,178,139,120,139,67,88,25,238,233,169,169,111,163,217,54,29,44,34,138,236,199,35,50,82,214,30,125,91,25,222,65,137,125,96,232,78,167,209,68,71,70,1,22,163,34,202,200,71,113,235,157,41,14,32,110,171,235,197,174,10,51,158,251,44,98,199,201,196,168,50,201,99,205,245,153,75,169,17,143,154,52,222,138,28,173,86,92,134,115,136,220,131,85,171,122,218,117,190,117,143,79,26,121,10,50,45,80,241,33,4,253,140,1,159,201,105,123,35,133,81,59,236,16,238,109,215,10,124,211,64,112,180,147,203,106,142,69,97,205,162,177,217,151,174,189,239,69,50,30,166,238,219,120,79,225,197,121,127,91,215,89,102,17,39,158,213,94,164,254,49,125,216,191,222,90,38,224,214,242,60,2,38,241,139,218,34,185,186,30,206,33,43,38,242,81,191,12,1,200,96,167,125,197,194,127,129,244,184,30,74,74,196,174,229,224,226,124,52,137,122,146,108,187,169,127,72,111,131,243,79,149,236,134,103,137,212,161,44,61,183,188,103,150,96,95,88,187,167,31,213,185,63,128,70,10,58,47,69,155,112,231,242,129,19,78,116,74,152,85,44,128,199,241,148,56,48,27,194,180,191,35,170,227,179,166,110,172,88,208,185,53,153,120,109,155,216,205,172,159,59,191,94,49,209,213,90,125,246,132,153,163,89,50,28,91,141,185,11,4,229,210,18,79,36,117,191,90,231,97,92,89,193,98,201,7,9,252,3,100,157,87,134,164,29,218,54,7,117,232,97,226,74,185,43,135,78,199,151,206,137,157,244,201,49,137,164,23,115,134,121,92,128,224,192,100,154,252,124,146,17,129,44,130,237,65,159,194,35,88,56,132,29,163,200,91,112,118,35,100,76,112,87,180,233,171,69,124,62,161,232,54,66,129,248,193,47,232,197,143,236,112,36,132,61,97,179,231,60,124,4,220,161,114,16,84,196,143,200,58,98,2,255,8,3,222,42,146,204,234,68,199,78,202,173,32,215,30,242,64,32,250,49,111,31,174,191,209,40,51,55,101,12,137,212,116,140,72,132,52,104,204,245,218,122,29,236,175,188,112,137,112,129,225,22,84,118,55,75,104,13,207,51,243,102,148,120,49,86,192,53,173,30,143,161,0,187,160,141,185,32,104,37,221,242,44,29,27,162,135,12,4,205,239,98,8,217,237,81,207,29,240,169,209,6,80,56,120,99,193,90,244,235,14,45,162,130,224,62,152,96,147,9,238,188,49,82,151,207,8,240,126,39,228,192,121,199,227,52,238,238,69,130,134,174,90,34,126,176,133,63,234,79,219,126,186,224,106,183,242,244,90,180,161,17,110,155,66,109,222,205,83,121,103,49,85,234,220,198,98,67,0,50,194,21,182,193,118,19,220,4,173,96,221,203,40,186,232,98,162,37,12,169,225,26,229,12,71,121,194,162,100,159,139,30,0,151,86,14,131,219,129,154,212,170,79,126,26,171,90,92,239,0,106,79,97,213,183,128,12,238,216,30,67,114,73,64,191,22,179,225,12,252,220,234,87,55,51,145,66,34,63,168,252,148,87,47,176,54,228,85,152,226,61,198,41,76,94,182,131,134,142,127,97,14,232,78,147,107,91,23,55,184,220,0,132,128,230,214,41,253,146,45,59,69,244,78,228,127,47,234,235,212,197,152,203,251,16,167,93,153,46,245,207,238,82,246,96,131,4,123,250,67,9,15,63,198,214,205,18,51,223,238,190,104,69,185,188,1,61,168,132,22,21,224,86,237,119,49,15,228,241,216,161,180,19,252,22,109,144,133,49,21,97,145,73,250,32,160,0,103,179,235,69,26,206,44,140,184,97,110,167,21,84,228,112,18,154,24,41,60,232,190,168,43,72,248,82,221,13,138,79,89,140,122,61,117,232,17,75,243,217,88,218,235,50,96,182,174,230,168,249,99,90,3,240,143,171,128,49,247,62,32,242,216,73,239,88,172,30,77,172,78,40,138,46,152,178,103,92,139,57,224,167,208,14,63,245,78,69,235,225,103,133,134,96,22,32,104,77,117,153,192,206,38,183,221,117,253,207,240,211,16,89,105,251,119,74,144,222,156,150,154,58,135,38,58,165,24,125,4,181,205,243,117,226,156,243,80,70,66,176,146,37,197,55,215,99,87,148,92,191,170,198,29,60,48,57,132,232,226,100,191,28,143,184,235,205,69,47,243,18,71,89,96,148,5,68,98,120,4,46,222,166,248,156,123,31,13,147,244,29,153,133,248,130,207,112,2,139,131,49,115,58,120,121,244,170,19,97,201,192,75,161,137,127,83,157,78,253,58,222,224,220,83,182,11,236,101,153,140,34,113,36,254,143,112,151,78,23,46,155,32,170,178,239,64,77,243,128,127,240,27,82,213,68,205,87,27,42,124,75,156,9,234,4,161,210,181,7,140,130,78,31,105,100,208,169,223,62,105,229,132,50,56,128,226,5,184,254,213,116,54,2,93,233,67,132,34,39,179,133,27,209,227,163,127,21,38,10,175,140,28,114,70,190,173,123,166,31,176,23,83,27,2,64,147,250,217,95,1,100,211,238,42,151,65,188,182,234,61,134,64,31,245,14,173,167,214,244,223,242,182,230,208,180,241,228,142,135,251,1,188,189,100,175,18,181,117,35,14,102,136,20,208,168,235,41,228,102,112,204,114,197,137,63,144,1,174,122,8,52,194,119,247,169,229,16,103,124,105,126,128,30,165,102,132,107,24,55,253,220,212,101,202,129,150,144,2,88,195,9,152,160,243,97,168,80,228,18,168,79,186,193,151,206,197,164,32,6,58,126,128,178,154,122,20,188,81,123,96,6,46,214,149,107,24,177,129,255,208,247,29,66,228,212,126,81,168,1,76,131,174,108,141,122,248,24,107,113,170,68,235,117,129,83,56,163,148,130,79,104,185,22,138,198,242,77,180,102,47,117,225,233,90,16,225,8,163,241,112,173,15,227,176,197,136,139,114,202,96,151,63,60,96,154,107,17,147,224,206,248,93,53,106,235,229,60,87,165,173,67,60,192,40,25,38,154,183,128,195,41,187,21,254,166,61,76,158,20,29,63,194,131,191,180,111,32,193,245,193,122,94,224,84,142,94,172,150,192,219,151,49,107,61,164,252,204,72,119,227,21,253,120,84,60,176,113,224,172,24,196,92,64,19,6,114,3,127,121,48,40,3,60,52,74,110,225,56,14,140,23,179,58,129,206,230,166,25,190,123,31,5,201,50,253,204,94,174,116,91,166,97,216,90,145,201,152,88,164,18,19,17,202,204,251,146,159,61,233,43,209,63,240,241,168,94,78,86,211,0,62,97,12,204,199,62,218,65,64,9,170,91,210,0,191,56,249,81,51,140,84,246,229,192,59,27,87,104,195,108,174,216,168,188,98,234,57,57,162,193,13,190,155,45,124,40,58,32,99,14,179,68,39,112,92,159,159,36,201,2,226,129,171,120,102,185,148,114,152,162,196,181,56,69,182,37,197,98,228,38,41,142,10,57,84,197,160,183,210,236,9,42,214,224,63,62,31,118,26,251,177,236,185,210,104,244,19,251,195,113,141,34,50,255,204,42,56,117,66,203,139,249,119,14,28,203,175,32,42,245,180,104,11,154,25,127,248,60,200,28,180,91,39,244,161,108,240,140,189,72,32,119,76,235,30,100,46,74,250,110,234,232,192,243,51,124,39,251,186,123,64,23,149,105,161,56,180,49,163,245,34,42,187,145,64,13,82,135,95,186,146,44,214,135,104,194,94,110,93,178,242,130,21,226,63,156,184,127,204,241,167,193,180,9,237,106,90,105,165,19,198,246,140,189,35,66,77,27,170,145,237,170,99,161,189,234,238,51,219,82,212,214,32,43,128,193,45,163,2,216,44,192,84,104,92,99,93,116,94,163,255,90,174,176,184,147,127,46,68,22,63,23,62,151,173,125,237,52,101,54,144,205,184,145,103,197,86,53,11,127,158,118,175,217,13,86,251,47,11,230,181,185,174,212,134,254,17,229,174,154,246,87,107,230,55,252,104,84,104,251,201,66,110,183,24,71,54,10,178,175,12,182,18,163,73,203,244,85,216,175,129,81,60,17,112,71,155,136,34,122,134,137,245,172,152,64,127,55,97,0,148,116,138,88,45,172,16,250,169,10,55,168,155,249,246,117,74,112,183,220,144,84,127,245,255,79,75,162,219,9,150,235,53,199,122,194,58,198,192,83,66,183,114,7,36,198,143,179,218,40,178,248,218,185,108,140,103,50,91,31,235,191,230,109,62,140,189,224,31,241,31,255,48,167,106,18,242,164,95,24,208,232,159,107,188,95,66,187,61,92,245,43,201,191,135,1,41,19,255,103,156,115,9,219,112,48,74,62,113,152,120,196,200,133,105,206,67,75,26,102,159,159,237,244,74,119,46,70,217,24,102,5,82,212,11,224,67,44,241,148,125,122,140,30,141,56,185,122,202,228,228,152,203,143,221,92,116,168,69,113,89,106,187,215,201,255,151,132,143,105,97,52,138,102,179,146,194,72,5,11,142,16,31,119,218,54,11,45,117,143,78,191,169,116,115,101,231,67,196,81,203,175,126,36,74,3,153,52,15,176,118,87,2,10,235,166,166,25,217,24,97,56,174,121,208,62,83,81,159,25,1,81,67,213,89,71,34,140,83,221,7,159,118,96,172,176,235,249,185,28,97,166,17,64,245,165,23,63,251,128,105,12,76,148,92,91,188,236,238,25,184,58,203,60,22,171,192,183,224,144,158,173,39,61,188,92,76,155,181,102,5,187,207,150,94,58,3,250,36,236,210,151,254,24,164,165,111,28,108,229,47,22,146,124,12,137,148,24,184,174,127,13,247,114,83,177,100,178,209,116,247,77,184,99,249,116,52,90,208,48,242,239,23,251,172,248,54,133,62,24,240,90,110,209,64,19,65,231,127,36,40,74,61,89,232,108,40,133,183,241,255,164,20,180,249,37,233,11,144,123,198,10,134,56,30,115,232,181,188,113,167,11,26,133,132,207,13,144,114,236,85,141,70,151,42,10,176,211,160,243,33,210,57,247,197,33,32,215,207,152,153,82,222,95,87,217,232,251,9,157,52,92,92,186,221,244,36,132,244,171,126,222,212,178,213,118,239,52,68,215,228,157,37,229,77,151,40,95,205,177,209,250,59,223,193,65,135,147,161,220,60,30,20,221,12,251,251,237,115,218,76,211,222,227,113,244,133,150,144,25,141,230,202,17,219,118,142,8,254,249,111,8,74,66,92,214,206,5,252,176,47,65,208,174,127,25,182,208,254,125,215,136,104,95,122,148,47,160,24,171,217,115,108,36,46,111,121,54,209,200,78,201,242,47,82,146,153,116,84,30,151,175,199,2,189,89,106,30,113,219,11,101,233,191,165,1,168,238,15,156,187,76,114,205,125,10,232,251,59,152,234,16,241,125,111,195,40,170,83,198,62,219,137,128,20,195,25,33,235,77,95,39,151,116,175,239,44,250,171,84,173,154,211,23,212,157,160,162,208,164,16,244,147,14,14,17,6,104,150,53,108,250,78,227,27,137,22,252,98,238,175,243,37,70,13,183,79,164,152,113,101,78,244,30,197,103,210,103,214,38,156,171,0,17,21,28,178,30,168,20,31,200,208,51,52,113,15,151,103,235,237,40,10,81,34,216,193,173,182,231,138,223,70,74,110,140,135,128,67,193,157,182,109,142,223,157,163,206,148,192,228,100,183,148,130,219,246,217,18,184,83,27,227,178,40,188,85,136,45,33,244,69,87,159,128,40,97,108,157,0,46,148,60,23,222,235,38,205,188,53,18,244,187,182,168,183,237,144,27,24,195,130,65,220,216,15,20,137,249,27,41,218,232,246,197,92,106,119,80,113,188,192,30,233,34,219,39,146,187,114,27,18,165,104,236,249,38,44,105,166,205,230,49,128,243,36,251,113,40,38,25,215,224,120,27,235,159,12,92,34,87,109,158,74,60,6,136,178,187,38,91,137,86,88,121,201,214,195,151,83,64,228,135,143,158,147,97,176,188,111,251,247,113,197,192,23,113,9,177,188,15,65,193,111,153,189,107,45,251,63,75,15,75,144,12,21,147,41,0,174,131,76,50,32,230,156,172,12,21,217,99,174,122,176,90,142,255,218,205,218,102,252,254,211,225,2,68,190,66,50,226,64,173,14,103,174,112,42,47,226,144,59,125,110,69,123,255,9,156,24,136,238,168,115,76,198,25,170,142,181,178,27,82,125,25,38,98,50,248,232,139,82,51,79,162,74,26,73,204,26,40,13,40,2,73,96,105,177,92,99,35,99,110,56,185,105,177,205,31,100,153,114,150,60,150,252,43,129,210,116,71,159,252,129,54,152,242,65,180,226,15,50,224,127,124,175,143,91,38,46,62,8,22,59,186,178,38,77,246,103,48,216,212,109,56,156,174,127,24,51,123,161,249,178,142,219,27,68,158,78,254,94,242,73,34,240,204,200,93,216,7,25,228,165,205,3,19,2,181,77,104,175,11,217,230,194,135,111,69,253,161,56,50,214,192,155,137,146,17,189,167,202,57,121,74,241,142,45,201,161,154,57,125,92,44,130,241,88,74,115,124,14,144,36,13,187,40,11,139,4,59,158,157,206,13,92,151,135,1,219,94,61,152,173,99,202,240,172,225,103,253,248,69,184,171,34,33,169,218,245,125,15,58,199,178,40,202,80,134,75,170,110,92,65,6,58,200,15,51,116,102,229,188,24,164,185,80,221,62,235,227,1,238,159,158,44,47,211,248,136,211,153,57,241,104,231,90,19,39,187,253,118,187,69,91,208,213,90,157,249,110,157,246,186,4,46,212,11,235,27,55,22,236,16,139,224,123,76,76,174,18,156,21,2,25,59,83,147,157,186,202,18,243,139,77,192,205,43,11,67,231,130,169,53,171,6,241,244,138,2,96,125,93,209,194,120,187,162,104,129,237,118,242,149,94,212,207,222,141,202,202,204,103,231,34,132,92,157,95,239,176,202,195,185,87,154,63,219,10,215,8,146,73,190,222,17,110,27,90,35,66,27,93,191,17,12,120,158,138,224,58,68,152,169,243,48,157,252,163,132,148,157,222,184,145,161,202,141,123,93,61,82,14,213,82,53,66,165,100,215,10,77,207,216,139,35,208,176,63,63,80,219,7,147,222,36,12,252,16,92,225,56,96,70,218,129,99,205,25,99,208,253,109,43,104,153,0,224,39,192,163,67,138,85,157,8,128,148,197,89,194,87,99,206,81,141,47,214,217,156,211,187,184,220,33,32,20,31,143,48,136,147,54,141,147,129,53,91,215,115,208,74,187,36,225,92,30,238,23,79,195,80,124,161,28,40,129,212,156,128,13,94,16,64,122,47,166,181,116,236,218,16,106,162,20,12,250,106,59,75,168,173,41,229,75,239,230,135,79,240,61,106,144,243,222,80,207,8,155,238,226,204,246,25,2,83,116,227,42,121,189,61,88,237,200,221,66,111,84,209,44,204,5,74,21,249,236,194,187,52,103,164,109,114,191,27,0,240,99,60,253,103,92,69,90,87,109,109,138,61,171,55,129,98,152,62,65,82,93,47,130,95,171,12,145,48,243,4,220,47,118,144,188,144,153,224,242,141,144,94,218,128,144,77,106,98,182,215,118,91,73,238,22,122,110,3,109,89,91,34,0,57,72,86,228,158,153,209,235,58,200,213,223,68,254,49,210,128,11,87,0,207,25,93,183,141,193,9,142,11,15,213,209,90,220,249,117,222,163,188,42,116,162,111,235,175,70,29,243,205,184,46,214,112,219,68,27,190,37,228,13,196,98,127,58,220,90,248,241,41,128,82,170,102,78,72,99,103,47,49,238,210,203,217,40,130,83,98,143,81,119,52,173,166,24,234,61,253,11,147,118,189,128,69,161,207,122,161,251,67,139,246,0,44,109,95,241,166,224,177,225,201,10,38,201,24,44,192,55,22,191,109,159,167,39,67,213,33,100,6,197,183,223,105,223,51,37,21,232,53,7,12,64,243,13,77,22,76,175,156,127,201,50,147,144,135,179,71,59,88,161,195,29,23,213,184,66,77,202,54,134,198,21,205,74,59,68,197,2,150,28,192,219,164,192,158,231,193,240,26,176,33,136,97,129,95,91,76,114,79,86,97,220,135,80,233,39,150,150,27,223,206,160,84,151,120,226,45,231,200,167,121,200,46,1,132,39,112,88,96,85,173,249,29,67,46,208,224,131,84,81,64,218,16,15,12,243,215,86,157,212,204,147,221,26,11,10,114,75,9,240,8,16,58,152,196,219,149,51,8,94,225,203,7,157,156,249,220,220,207,80,128,47,103,189,58,38,83,183,122,51,230,254,146,160,37,235,226,233,55,164,177,33,246,224,67,54,25,126,27,216,100,83,102,46,231,99,215,206,57,243,30,174,54,153,209,116,17,156,121,215,104,69,33,59,37,187,95,75,158,233,68,148,64,236,174,32,201,143,189,99,126,50,216,65,155,184,98,84,102,243,47,178,99,59,227,198,213,53,206,39,35,180,9,162,212,58,190,48,80,234,176,124,165,130,234,100,117,5,245,122,210,159,134,31,165,144,196,154,81,131,130,236,180,4,23,225,45,144,92,99,117,71,130,142,141,103,81,168,211,2,123,203,171,59,133,24,46,169,116,160,216,233,44,215,66,201,119,51,58,75,50,68,116,127,170,113,129,55,193,109,155,237,246,191,189,150,135,24,5,204,65,201,86,15,202,87,40,122,227,52,245,82,182,54,65,104,165,101,190,208,117,246,203,163,168,171,35,67,186,170,221,100,63,0,206,157,229,28,237,147,132,88,91,215,64,64,22,48,88,246,232,140,146,211,199,110,230,207,238,78,66,78,104,253,244,227,114,94,210,30,6,33,43,1,110,176,2,156,178,126,202,213,183,124,213,218,56,96,100,54,192,53,69,60,180,73,48,142,15,85,251,191,216,147,246,47,251,203,203,138,14,174,9,73,186,102,220,0,200,22,56,137,234,117,155,105,229,151,192,129,193,93,234,222,103,57,195,107,240,92,18,180,41,23,23,255,255,135,26,222,109,47,129,205,129,52,192,82,153,195,24,72,58,156,127,159,210,114,67,196,173,239,17,84,216,115,57,151,70,218,133,179,61,149,175,160,128,222,103,91,202,239,92,198,173,251,58,186,236,105,215,23,167,254,58,4,21,22,17,213,211,230,47,195,183,154,245,187,224,165,236,107,184,195,149,49,79,138,158,97,201,64,138,145,249,37,253,56,175,148,83,197,74,69,186,47,38,63,14,241,224,30,52,152,74,163,144,190,253,92,176,164,109,217,165,118,19,56,214,162,10,193,213,18,95,72,55,150,22,199,50,196,111,155,204,32,122,25,68,234,156,43,178,92,160,204,83,138,2,184,248,7,132,201,144,69,176,216,12,49,175,55,89,163,91,23,159,27,226,183,111,153,13,35,140,237,237,170,126,119,171,55,105,81,53,55,142,131,46,39,136,83,145,158,216,192,73,71,22,117,124,243,85,81,130,52,28,216,143,226,153,141,3,162,141,249,125,8,119,27,65,133,135,123,117,71,161,45,130,255,194,160,178,21,123,106,105,199,3,146,205,115,157,18,61,181,226,101,151,234,244,10,17,216,104,186,3,215,32,157,200,151,190,41,62,181,74,5,160,213,185,70,97,253,164,115,81,108,228,207,4,144,210,54,224,36,93,21,210,109,58,54,121,127,235,182,110,122,161,24,48,114,193,83,31,221,109,136,70,83,212,203,195,232,231,69,5,55,157,106,77,101,19,58,55,127,91,240,85,64,11,229,155,10,93,177,2,144,20,75,121,186,81,171,50,1,196,62,217,231,16,206,250,186,173,24,60,218,230,99,216,36,3,103,61,237,73,61,170,38,35,224,158,166,103,119,128,4,5,152,194,141,234,113,149,54,196,25,235,18,81,227,137,137,138,115,20,204,38,189,115,69,224,31,135,6,32,171,72,87,42,144,71,72,255,171,79,132,159,83,151,209,62,152,25,79,133,19,172,154,90,84,80,101,131,150,37,245,195,199,210,235,98,122,229,215,7,164,79,63,62,80,142,144,161,189,235,24,212,200,109,145,185,104,122,29,112,81,147,15,4,108,147,244,184,155,249,18,80,201,174,227,93,226,109,63,7,17,14,209,141,194,160,30,170,18,60,144,32,224,177,0,106,248,126,107,84,185,179,106,146,13,238,80,251,18,50,96,122,216,217,112,187,148,102,111,47,244,158,22,39,76,59,150,43,22,117,202,253,88,26,166,126,243,142,239,81,69,185,255,93,56,20,32,232,185,22,217,19,198,221,159,42,176,105,127,180,90,189,136,213,241,120,92,0,77,136,165,142,142,126,142,164,219,231,41,237,134,253,191,235,254,252,57,52,25,89,120,215,145,142,87,152,149,107,177,79,86,176,4,105,59,150,254,14,74,110,116,206,16,0,218,98,156,66,18,10,16,202,136,15,80,236,236,233,75,132,186,168,174,233,16,240,124,0,189,243,98,252,33,121,215,44,173,199,127,71,233,97,165,227,102,12,62,59,225,180,119,55,117,95,159,229,177,99,143,111,247,182,37,180,23,219,51,67,250,113,124,122,213,160,93,82,156,170,252,0,1,76,22,11,250,91,147,112,1,233,251,21,112,60,137,25,215,114,231,83,28,55,129,94,198,200,247,80,156,163,198,211,214,235,239,111,210,160,137,128,181,114,163,61,8,94,83,46,49,30,181,239,140,222,109,66,167,226,89,159,32,73,145,21,222,213,65,62,66,94,137,206,128,169,236,73,167,141,150,232,238,36,44,136,68,28,4,21,153,225,253,254,31,210,190,138,17,5,228,142,90,163,91,64,60,208,230,70,88,201,198,140,171,37,112,143,83,251,39,36,63,189,48,135,196,100,189,76,124,37,117,179,153,183,236,97,94,72,5,144,76,23,71,22,137,91,101,17,51,31,37,37,248,167,248,202,225,125,28,24,192,51,67,242,20,243,183,110,138,211,210,110,39,221,189,226,241,100,225,217,111,128,6,152,234,156,179,79,2,139,150,103,51,47,252,21,104,71,84,83,243,17,144,151,52,96,128,26,163,179,77,162,97,109,136,128,106,219,50,111,229,203,148,252,102,19,181,220,239,169,7,60,6,173,111,160,55,24,162,69,223,39,186,222,104,184,206,203,0,68,178,244,108,51,107,230,205,176,248,207,12,225,122,184,184,1,99,226,173,135,71,136,45,243,127,168,160,134,31,180,45,53,1,213,36,43,83,51,59,61,115,223,67,123,54,86,38,128,71,198,210,179,241,150,253,253,1,26,104,127,234,182,86,121,188,19,134,211,19,249,75,96,210,137,255,175,48,38,23,82,107,180,73,87,97,17,31,217,160,77,243,143,164,224,77,154,152,148,205,66,240,48,168,156,21,103,19,214,154,17,173,156,16,31,18,63,134,224,211,145,46,114,33,113,105,125,72,78,202,25,183,28,255,45,63,169,16,225,2,237,156,45,254,223,125,195,250,99,49,156,250,188,216,169,104,171,157,188,114,72,110,29,153,187,99,254,51,237,255,23,98,131,248,193,121,59,142,7,176,78,52,182,134,170,136,125,40,234,245,225,74,212,208,176,105,253,8,32,143,69,180,249,246,10,31,176,129,144,255,199,193,59,12,181,231,207,169,241,243,19,253,220,49,45,195,42,147,102,239,117,186,240,63,156,184,43,225,119,87,44,38,11,106,231,241,208,145,167,222,147,22,240,37,62,139,30,249,0,209,78,164,84,131,254,178,126,91,170,226,29,73,170,154,101,221,202,18,92,146,134,178,38,195,106,88,228,86,86,172,34,113,89,4,85,139,78,39,3,161,49,94,245,107,21,206,162,64,240,35,201,126,89,226,156,229,141,165,29,4,22,197,202,125,44,200,64,176,137,55,95,167,234,104,86,244,217,45,234,206,4,6,171,85,146,235,237,168,81,103,77,204,104,16,110,90,132,100,240,72,96,188,201,254,56,43,229,76,8,144,250,190,182,102,89,64,104,238,222,184,173,138,130,235,233,91,226,30,237,38,236,194,116,180,36,198,97,37,242,32,60,224,15,13,203,190,121,127,41,1,108,205,117,79,104,173,232,164,128,0,31,193,82,164,115,1,175,199,50,22,0,215,136,87,212,105,174,240,47,27,51,93,165,183,61,96,31,150,125,70,38,192,85,215,191,65,159,42,123,59,211,210,39,96,64,53,80,103,134,214,75,89,23,40,114,4,148,61,56,175,176,119,180,61,162,119,184,21,110,204,103,52,202,109,151,202,204,240,215,165,116,96,52,113,64,112,42,171,54,172,169,69,253,44,153,24,232,19,141,73,3,80,141,143,57,23,209,218,79,5,176,20,117,197,223,97,0,0,216,103,205,251,42,189,173,104,182,224,240,187,184,90,150,165,151,54,237,248,21,195,252,26,86,186,43,130,85,173,165,88,77,47,61,60,251,197,177,40,114,201,153,72,161,39,61,136,217,22,39,227,180,112,20,184,0,22,255,248,87,132,120,113,8,6,226,212,166,57,112,185,75,15,83,79,196,106,136,205,5,59,250,63,35,80,140,176,236,196,248,3,221,98,250,104,32,99,152,165,109,139,192,40,49,68,14,50,89,102,202,12,64,120,114,49,227,205,144,18,43,180,65,47,167,89,67,145,180,44,241,173,23,232,86,141,103,210,72,240,225,180,133,221,238,4,125,161,121,44,204,5,162,64,34,84,167,152,247,154,190,162,116,71,83,180,181,174,3,151,227,180,162,28,198,133,1,195,199,54,251,220,4,182,126,209,15,24,207,187,240,50,11,120,250,158,87,125,246,74,64,175,190,21,150,255,202,170,125,38,228,16,24,166,186,7,113,0,133,182,112,138,188,2,24,120,236,10,76,154,89,48,23,228,159,219,144,219,209,76,59,25,100,202,46,203,178,117,252,97,240,97,42,143,205,52,199,220,7,0,109,217,139,126,170,178,227,213,192,16,171,133,173,237,240,186,6,14,155,94,157,194,99,123,174,181,74,164,126,56,178,0,172,77,163,74,172,53,5,161,130,161,162,149,232,150,69,170,172,59,70,142,112,87,58,16,192,67,8,250,29,140,221,17,117,167,133,43,180,141,157,214,18,131,114,105,147,206,25,138,207,188,30,41,9,97,113,247,123,251,56,165,182,239,95,79,152,45,113,160,213,230,249,227,167,149,52,172,156,182,242,134,61,19,90,144,248,100,252,168,76,213,246,126,123,175,8,114,218,41,247,90,229,94,238,86,73,43,35,42,116,168,217,75,167,166,122,230,82,130,255,164,51,9,86,79,111,49,152,198,132,96,62,12,131,23,66,96,51,213,29,13,144,20,26,228,66,41,228,68,254,126,173,192,51,62,41,184,136,182,93,102,144,250,65,236,200,19,121,182,87,125,72,97,132,164,29,130,211,26,115,217,177,199,35,54,132,98,87,138,188,229,34,130,240,81,186,231,130,41,17,74,64,27,41,169,251,229,192,38,247,81,85,224,10,181,80,164,164,112,73,150,53,119,166,144,157,52,98,187,48,28,64,77,33,237,100,1,46,123,40,27,232,128,105,190,126,27,132,205,16,107,184,30,187,240,29,128,81,177,9,175,37,159,188,53,109,59,15,33,102,39,182,31,73,163,176,14,150,178,216,231,41,152,253,100,240,46,106,181,137,111,240,101,204,74,57,134,179,49,230,134,124,152,70,64,166,43,65,203,80,53,157,166,39,138,142,243,74,145,217,9,194,93,128,67,93,129,161,161,254,211,189,239,205,32,171,253,118,141,204,240,183,222,146,198,220,187,58,201,238,218,179,206,89,183,40,198,33,53,38,40,144,216,247,161,189,216,173,9,22,72,148,174,45,3,127,35,125,111,140,15,207,119,246,38,244,195,69,85,106,121,28,241,125,124,103,116,108,152,84,133,165,68,92,5,189,160,223,125,159,69,84,91,214,24,52,36,207,180,152,8,156,70,209,194,220,165,138,212,192,246,132,124,186,64,218,179,23,131,210,117,7,15,197,250,249,187,104,74,19,195,232,168,66,171,125,133,252,89,123,236,67,152,150,187,82,161,241,29,160,206,15,254,101,201,34,79,182,6,88,237,204,67,3,24,199,64,58,22,71,118,31,80,235,148,111,111,74,248,229,15,0,160,215,0,121,227,15,243,58,122,251,203,236,223,102,217,235,105,113,239,209,206,227,198,166,116,250,85,48,71,14,78,216,2,167,129,129,240,167,56,89,118,161,125,49,228,56,221,13,219,207,36,68,253,27,45,219,117,151,229,111,247,206,97,173,132,8,74,182,16,125,54,238,31,46,244,50,250,3,216,182,42,120,67,61,39,106,101,23,248,21,80,151,115,41,105,95,47,32,90,53,3,164,31,12,113,105,26,135,101,186,43,191,173,143,177,4,75,109,96,7,121,5,231,218,250,45,96,254,193,146,225,251,238,21,240,27,207,43,187,7,61,254,195,234,210,152,46,241,186,188,216,234,82,179,109,61,190,139,211,58,36,74,149,107,249,150,196,71,226,167,232,40,42,19,152,17,194,16,94,5,11,57,37,43,99,98,248,81,211,60,69,192,80,94,225,241,197,53,76,100,1,166,253,132,17,3,72,232,72,214,60,18,151,159,15,167,78,27,76,142,22,21,129,121,10,185,35,246,49,165,218,73,182,236,65,1,175,236,230,71,209,189,163,164,179,194,209,86,6,180,219,147,94,15,212,246,83,21,183,250,40,230,78,222,159,74,94,13,20,247,51,90,218,253,125,50,81,72,93,1,200,50,199,223,192,197,223,38,208,98,122,118,7,82,178,154,193,50,199,199,7,184,231,120,39,2,232,41,182,32,75,56,236,176,5,0,113,190,13,109,1,175,212,249,89,21,130,204,162,228,119,244,190,87,252,151,13,40,209,103,93,95,199,103,141,133,122,94,189,161,222,26,229,214,114,137,110,97,84,81,251,213,80,122,215,144,113,154,105,12,130,191,24,0,226,159,46,86,119,142,104,231,72,118,224,91,195,94,179,212,168,32,243,2,25,219,4,197,34,167,252,198,18,155,87,88,62,165,118,253,176,96,152,186,128,214,140,226,59,11,113,104,102,96,136,126,9,13,140,165,46,116,134,52,249,105,131,168,226,83,93,216,194,247,236,251,159,42,118,243,93,85,175,120,106,134,75,146,217,187,183,49,138,190,5,189,3,203,106,166,110,104,108,70,111,165,41,203,34,212,254,32,10,2,238,30,243,126,47,119,175,63,107,73,75,131,105,17,54,253,158,128,179,196,198,64,151,178,55,47,159,191,106,78,234,208,198,108,42,131,2,33,44,121,43,48,137,107,252,205,15,84,242,200,169,148,239,199,117,248,6,151,51,83,45,149,57,75,160,202,27,122,235,14,50,90,135,90,94,140,171,241,123,236,90,200,243,190,6,111,165,246,139,34,141,151,172,38,34,66,201,218,83,110,52,12,146,6,26,248,102,120,174,193,25,147,171,152,87,174,79,55,208,166,73,111,90,214,25,117,239,102,226,213,182,128,93,49,129,174,3,2,180,9,250,166,8,32,141,187,26,55,157,229,144,64,195,91,154,133,56,176,6,198,60,119,115,232,70,213,143,59,250,97,136,50,75,125,198,19,151,141,168,48,163,47,67,211,114,119,103,69,9,119,244,236,196,164,248,228,69,215,205,245,16,57,177,244,43,224,109,172,45,14,5,161,195,63,81,38,117,19,125,248,179,103,199,168,84,151,192,55,216,72,96,43,117,199,103,51,202,42,177,40,169,84,157,153,173,244,141,108,142,38,188,53,35,151,221,147,12,148,111,151,129,212,37,253,142,191,152,21,241,153,150,30,71,95,49,124,83,150,47,109,169,199,96,70,141,167,74,79,11,152,159,93,215,159,185,141,249,140,114,217,75,87,133,177,114,114,27,32,86,10,246,20,157,127,160,164,227,79,194,177,107,49,142,179,84,144,135,178,81,30,7,228,120,116,11,103,210,83,15,94,77,40,116,144,27,125,81,192,231,217,112,4,184,78,6,144,65,184,221,84,114,52,150,241,217,130,114,219,252,15,34,244,209,76,178,193,231,229,38,137,147,0,147,242,150,26,33,32,28,132,60,63,134,221,9,214,135,97,120,217,109,78,130,199,253,153,215,234,19,186,201,199,169,20,132,151,74,179,54,65,25,171,126,126,88,23,247,222,39,52,65,85,45,245,229,214,38,98,14,0,10,216,42,17,230,34,91,84,144,209,31,186,211,140,175,188,80,202,99,174,124,88,40,32,214,235,133,253,145,179,186,102,42,135,61,67,235,163,133,41,35,25,168,87,141,24,186,210,233,150,19,220,120,81,123,169,245,18,197,27,207,176,15,197,115,139,69,152,82,211,148,77,184,232,173,29,253,46,123,173,245,217,54,231,135,218,236,101,196,45,109,136,189,206,68,215,214,77,251,43,39,224,144,62,135,50,114,247,67,110,247,38,143,220,5,1,173,142,88,7,149,152,225,194,10,114,152,121,105,239,242,249,117,29,172,2,39,98,218,33,31,69,93,11,210,222,132,40,251,162,173,144,13,165,165,242,181,202,215,89,196,228,253,39,70,73,153,144,63,184,211,2,204,107,51,166,197,173,14,15,96,66,141,11,12,244,148,50,16,214,9,8,52,6,165,105,91,184,10,10,62,135,250,200,159,69,227,229,86,98,229,73,27,200,217,108,233,211,81,90,93,45,50,50,149,19,35,23,116,202,113,21,211,33,217,140,128,86,228,185,130,140,104,87,180,174,131,213,254,48,90,67,239,159,204,139,229,42,236,142,82,151,187,165,11,12,150,53,56,10,76,97,213,117,217,51,242,133,135,229,78,117,95,26,31,69,32,138,147,70,226,136,42,0,8,199,224,233,35,206,48,207,61,99,52,101,204,118,143,245,236,120,33,226,57,223,53,32,255,6,236,127,223,89,137,99,84,204,80,106,20,237,64,149,193,65,7,41,202,120,56,115,112,137,35,254,243,28,47,4,229,33,115,177,48,219,231,48,63,139,95,214,209,6,170,197,116,222,104,88,254,141,16,48,222,226,9,47,121,65,188,142,38,129,229,60,122,25,131,229,78,249,211,139,93,199,181,248,231,247,38,161,131,223,146,216,88,123,189,77,186,220,2,185,53,173,226,101,153,213,103,171,140,207,44,51,120,168,36,182,213,176,87,166,170,61,250,49,139,249,215,135,168,170,59,95,118,142,249,166,177,121,94,175,159,219,228,219,117,28,222,43,180,225,108,140,7,25,5,94,45,171,5,65,137,255,40,123,190,89,181,94,76,172,91,161,197,240,85,79,172,28,47,57,205,233,102,137,143,28,155,20,20,157,41,148,175,43,167,5,82,171,148,109,247,237,236,176,176,124,1,158,189,93,168,51,115,231,208,228,55,164,123,212,27,25,190,38,1,120,25,153,91,236,95,116,67,210,173,224,156,220,91,207,120,91,114,212,191,71,198,205,146,136,65,91,33,204,192,154,155,243,71,11,55,239,100,89,204,247,199,59,120,22,68,109,137,194,203,81,61,247,11,226,242,210,155,195,209,1,193,108,163,178,20,22,170,30,148,214,80,229,153,91,103,246,237,10,245,110,211,150,205,98,239,92,94,71,206,91,253,204,90,157,216,152,35,148,167,8,201,167,24,239,191,158,102,23,131,159,64,99,81,159,58,193,185,68,1,28,24,38,198,132,80,191,19,122,235,99,129,100,49,253,29,52,194,32,108,106,166,243,179,53,189,96,59,73,241,61,32,223,84,218,118,59,32,64,9,98,239,207,219,101,38,106,54,148,148,25,5,50,107,106,152,242,117,192,102,56,184,19,232,133,157,243,182,52,144,217,94,101,153,221,88,157,52,224,159,93,159,71,2,115,200,230,116,202,177,236,75,20,176,16,39,147,24,150,195,21,251,77,57,185,113,216,168,48,127,164,56,104,92,23,85,141,159,93,53,192,103,163,130,24,85,85,160,61,246,23,185,196,18,158,228,129,148,126,206,52,198,191,182,12,98,112,31,56,160,62,208,196,234,1,56,249,23,61,115,25,164,254,151,45,11,124,107,53,151,131,221,52,249,185,90,5,4,129,177,134,168,239,37,50,111,225,178,53,251,9,5,87,32,111,75,239,38,160,33,50,128,211,5,250,31,61,177,31,115,182,221,118,33,225,75,165,5,43,89,152,62,217,185,246,122,194,98,47,193,42,74,46,144,111,16,231,76,88,151,7,93,68,144,237,82,117,206,167,239,6,137,55,125,14,88,92,201,143,148,62,216,55,224,150,178,38,77,42,167,163,233,124,131,220,55,50,219,117,225,244,220,233,124,27,133,246,213,86,54,152,29,92,98,226,98,54,110,144,186,41,161,225,72,199,30,105,121,160,56,141,23,100,40,88,208,169,32,196,122,95,231,57,244,199,120,13,232,165,250,170,24,34,231,23,205,33,18,214,128,56,165,14,48,104,223,133,183,73,58,100,111,112,115,239,70,81,81,38,94,88,232,164,212,242,0,59,114,36,133,89,252,41,204,37,193,144,244,255,242,124,20,131,112,126,131,187,205,71,229,86,90,197,199,245,45,120,190,56,223,164,63,177,75,188,238,180,176,137,182,95,221,29,158,104,4,224,38,183,94,172,67,44,62,168,237,218,85,159,58,25,168,173,108,204,228,81,18,145,207,176,19,10,212,78,133,108,169,178,117,11,19,155,152,200,117,243,99,143,126,93,75,167,4,103,249,245,27,30,184,78,162,35,174,200,4,59,119,138,195,58,130,59,179,147,48,207,134,201,207,31,90,145,168,212,195,79,220,16,253,80,24,42,159,61,178,241,81,140,246,198,225,166,94,74,63,254,3,218,93,2,74,194,239,192,68,55,75,132,51,79,200,162,72,133,34,87,86,7,157,235,37,94,78,191,150,81,213,162,147,20,232,243,173,36,1,244,91,3,192,10,224,194,229,74,147,19,192,165,168,153,5,127,230,113,185,206,127,146,80,114,246,179,16,31,90,0,242,254,82,189,36,246,211,7,118,168,33,154,220,184,107,101,40,150,196,194,242,253,216,72,132,210,147,230,224,198,34,75,25,74,233,205,159,168,6,197,50,217,127,251,94,27,0,89,55,171,138,10,197,251,46,127,84,139,97,212,131,44,89,5,181,154,11,223,2,106,249,29,222,72,44,89,57,56,8,138,102,140,86,159,219,77,239,32,203,126,142,214,192,72,16,119,161,71,155,250,58,115,189,112,51,213,249,25,85,78,170,171,102,164,103,133,109,37,229,130,167,116,64,21,234,76,246,89,206,141,235,89,223,141,56,47,168,166,97,190,26,197,70,97,133,200,148,53,45,183,39,129,38,122,174,116,58,75,115,221,204,101,52,24,94,177,14,237,2,172,234,210,8,208,25,77,235,113,24,108,216,242,184,180,255,173,101,240,51,246,200,240,13,156,209,93,60,66,170,252,82,230,13,215,146,117,255,210,7,34,122,10,106,156,176,21,68,222,248,33,83,152,206,191,60,18,158,149,114,74,41,60,203,244,210,249,189,212,25,25,75,131,95,76,207,254,188,23,124,249,162,255,170,137,0,81,97,181,221,127,2,120,240,234,80,28,115,105,158,136,89,77,135,103,255,251,8,186,242,63,176,164,122,8,11,128,19,58,243,8,212,252,204,84,170,108,158,179,247,0,254,32,87,139,213,136,45,180,92,145,67,92,246,247,205,97,103,87,101,163,137,0,61,23,230,147,218,153,102,235,104,17,24,246,70,190,79,179,238,178,41,56,128,115,241,148,114,229,173,144,63,54,151,123,191,45,145,222,89,230,29,59,34,163,123,120,56,34,137,149,161,32,221,255,87,39,50,57,112,84,159,209,51,170,143,167,190,117,145,202,12,127,248,132,142,52,118,154,247,22,242,179,161,240,146,155,7,176,79,18,1,228,242,227,81,34,121,92,236,105,176,207,233,51,86,159,119,70,173,14,42,103,31,241,149,157,98,49,61,96,106,94,142,12,146,88,63,16,173,84,14,216,170,188,7,119,188,94,156,24,78,218,117,39,252,216,201,136,241,118,24,231,164,15,9,211,193,68,14,9,140,214,99,95,235,172,219,136,83,12,95,75,88,48,152,236,153,95,137,236,38,125,35,176,220,87,52,101,106,40,172,224,140,105,118,201,227,143,43,59,162,152,247,197,72,70,232,183,21,160,2,64,169,41,69,166,102,52,189,217,130,19,196,230,34,133,35,31,17,193,45,252,112,79,79,223,99,168,154,14,19,74,179,41,246,27,199,128,101,54,80,252,173,165,241,80,26,204,142,255,57,94,25,56,246,22,133,229,144,110,212,118,251,36,49,81,254,183,116,222,99,70,181,22,74,96,199,161,124,176,7,199,9,56,128,64,200,185,222,37,225,144,156,152,22,99,76,208,43,99,207,169,146,220,182,136,30,96,166,118,49,125,40,132,106,49,212,158,91,55,84,208,213,75,63,190,113,71,83,98,109,21,176,11,204,253,157,79,106,111,232,239,253,187,98,141,32,52,39,209,183,100,176,183,32,232,137,209,189,13,67,230,44,99,233,235,31,211,62,149,120,185,114,79,123,8,153,151,112,255,65,154,228,16,226,177,21,18,10,146,172,134,181,123,4,253,122,188,229,98,89,112,147,19,145,108,246,176,210,201,128,231,96,230,39,140,7,175,246,144,253,114,34,223,14,48,134,160,78,112,135,138,197,142,208,213,221,156,197,198,131,42,169,203,191,140,36,205,131,59,11,239,147,205,235,193,132,59,199,198,42,204,244,120,24,172,221,253,85,141,118,110,76,153,91,146,222,142,200,251,52,172,145,250,47,123,86,49,253,220,27,77,170,51,36,179,148,26,32,251,162,197,246,163,248,65,123,233,68,194,166,153,206,118,238,22,134,49,13,218,176,11,183,124,197,148,169,251,224,80,11,209,166,233,229,19,220,114,244,144,246,17,131,119,108,78,6,26,238,121,82,13,57,179,139,149,164,255,235,181,20,240,76,155,71,61,89,192,100,16,244,93,71,199,139,70,203,107,44,233,154,66,40,255,1,15,20,206,89,244,23,68,123,164,177,175,187,170,150,195,150,44,96,99,142,169,220,220,197,235,124,72,198,60,112,180,196,35,190,154,107,29,177,10,243,111,210,61,157,156,223,255,101,5,210,27,224,15,23,138,119,65,201,139,134,84,70,122,22,204,153,5,193,108,54,149,173,173,37,200,81,229,93,72,7,45,14,51,177,85,166,96,189,55,43,70,88,172,251,17,221,163,81,62,196,216,14,31,82,46,38,65,125,42,32,4,9,145,100,31,102,106,231,86,31,167,246,39,11,28,118,34,92,179,80,65,191,115,43,247,211,118,115,124,156,122,145,222,177,73,161,7,117,51,20,29,178,100,26,127,202,208,177,209,121,101,140,194,20,229,139,123,55,186,209,31,33,39,115,64,97,128,152,60,147,70,35,97,4,156,87,181,58,244,132,109,115,229,91,215,10,28,25,21,57,163,234,21,101,81,18,220,78,130,105,85,41,164,78,228,156,201,182,234,93,221,241,194,212,66,84,4,11,81,116,94,234,37,200,8,214,228,253,58,205,250,62,168,189,1,46,223,0,158,154,29,127,247,188,25,193,165,228,117,234,121,149,167,254,11,3,15,12,91,42,46,11,240,230,134,120,108,46,58,63,23,230,140,113,173,206,94,55,63,20,187,32,255,142,32,192,135,161,231,95,115,204,50,125,129,245,15,153,89,124,35,87,200,91,78,68,126,100,158,103,224,232,192,132,174,34,19,19,48,139,182,247,255,70,88,227,139,253,31,10,222,62,188,140,85,169,143,143,14,29,108,159,46,98,211,30,129,63,149,77,230,246,61,181,103,153,124,242,214,63,70,78,193,78,208,159,94,20,59,30,81,88,112,124,123,183,101,239,217,86,232,137,59,250,5,110,107,71,27,31,15,33,62,200,161,218,153,82,134,5,7,141,180,7,152,169,23,182,33,150,252,223,90,209,54,177,15,50,19,8,253,37,226,84,143,33,164,230,38,215,102,42,156,198,36,35,149,175,75,79,102,252,69,215,7,165,103,252,189,221,18,204,32,86,110,22,47,74,38,247,11,126,5,145,242,247,20,9,190,177,121,79,16,110,73,41,45,141,3,247,35,3,252,191,45,7,156,127,115,198,74,194,5,25,124,110,61,109,115,151,84,72,182,140,170,23,217,123,133,98,143,18,53,128,55,78,61,89,152,214,253,63,133,196,183,215,107,107,158,245,129,15,153,169,246,158,65,172,8,47,226,30,126,10,64,163,175,108,218,130,19,89,235,34,206,150,176,199,6,140,234,201,165,130,107,208,64,112,36,44,115,250,199,236,204,60,127,43,124,225,163,49,76,103,210,254,126,180,82,44,230,68,93,12,246,201,186,72,190,172,76,128,42,173,0,221,120,14,150,19,197,121,163,71,111,214,183,143,24,187,70,13,255,228,250,134,173,209,183,166,208,21,225,94,109,145,98,70,255,76,151,190,150,183,152,248,238,224,187,111,4,2,111,236,73,135,133,67,34,193,94,52,159,42,187,59,38,75,152,72,134,112,236,191,233,150,43,156,14,167,70,226,7,114,200,31,140,164,33,84,232,169,15,96,172,175,192,57,229,71,227,101,139,17,90,45,154,32,255,204,159,141,200,159,147,45,152,135,128,51,11,78,181,154,83,92,144,157,134,244,234,140,201,95,218,104,165,146,35,28,223,139,111,128,149,30,162,119,191,217,136,196,219,138,212,22,168,182,19,118,34,168,68,234,104,231,59,166,128,52,254,212,215,218,117,66,31,249,88,61,78,33,130,242,94,66,17,169,102,100,130,251,1,125,169,71,110,165,239,246,162,251,220,185,184,20,76,133,171,122,57,219,218,181,169,220,38,166,27,206,53,166,180,135,172,64,7,187,131,182,110,67,34,191,25,145,197,184,217,30,140,72,15,212,194,123,34,239,194,64,110,117,35,199,82,17,157,252,230,226,228,44,151,158,81,101,191,59,18,175,143,139,235,12,185,50,15,106,29,143,82,247,211,52,208,35,153,64,11,50,37,13,38,232,128,45,104,62,240,201,122,137,83,140,250,178,64,142,202,168,54,119,221,215,71,166,35,108,71,223,239,99,153,12,8,134,64,200,182,235,107,96,111,231,153,200,254,189,247,49,93,127,4,200,77,43,160,120,224,252,243,224,46,190,166,143,82,46,207,86,235,116,203,190,88,18,55,121,70,227,215,107,69,58,245,221,133,33,73,230,34,36,254,49,127,129,180,253,175,209,180,54,94,124,96,104,97,243,225,38,248,166,230,189,233,78,38,61,122,43,51,76,9,219,127,1,239,79,151,48,213,26,208,118,80,108,178,180,167,38,224,5,87,106,12,73,252,109,195,190,244,1,237,106,212,236,116,74,192,255,121,219,152,67,18,77,38,21,51,27,121,200,196,0,84,219,179,46,124,54,85,12,179,49,241,46,197,14,33,28,79,227,246,94,112,66,187,209,230,116,161,40,15,78,57,156,110,138,178,73,41,255,178,62,43,236,180,171,248,21,243,240,13,110,71,67,79,176,57,76,207,194,20,219,223,36,60,83,50,200,87,245,137,235,132,89,144,67,4,174,55,221,14,212,138,175,187,209,186,54,80,178,238,243,36,9,199,108,128,111,120,61,208,105,53,44,233,236,78,63,226,71,197,238,242,101,100,227,70,160,209,41,198,56,65,115,138,237,132,126,95,23,46,122,98,177,164,159,251,98,212,145,111,203,95,36,21,53,163,88,57,51,139,255,60,181,38,187,107,75,128,165,215,232,130,56,103,173,192,192,119,72,104,142,246,79,232,200,17,207,225,61,55,106,74,61,126,180,229,233,187,223,190,82,11,232,15,84,52,13,98,154,199,134,191,227,132,219,235,17,230,249,92,249,34,165,54,132,101,234,209,220,66,6,69,181,50,132,160,155,246,171,5,167,56,49,27,175,90,222,36,13,217,116,128,9,151,3,203,43,43,40,205,132,14,248,28,88,180,107,146,95,19,175,0,109,41,170,148,148,54,179,0,71,101,59,99,221,143,205,42,59,156,112,136,31,59,18,231,136,191,41,46,122,77,101,152,172,123,108,116,111,53,229,4,163,218,156,39,171,198,100,223,236,90,205,126,143,72,67,138,159,241,118,154,239,154,219,34,182,123,33,163,113,46,15,249,238,36,50,215,132,241,226,207,196,181,96,162,212,88,224,190,81,179,12,136,146,122,238,83,129,26,72,105,125,20,146,253,67,112,232,12,188,96,52,161,160,121,241,50,77,49,218,20,78,169,246,196,95,213,12,11,243,170,71,1,244,78,233,115,143,34,201,250,23,100,9,97,17,4,211,193,128,42,106,170,138,9,75,28,208,247,157,32,4,210,106,87,15,97,167,209,22,160,123,52,183,148,194,21,14,53,212,119,43,76,147,154,56,43,175,79,109,103,68,93,115,95,230,242,89,230,162,136,47,37,79,109,220,24,217,83,40,241,45,113,250,138,133,115,120,72,115,222,65,36,226,44,1,172,128,192,152,113,44,162,139,24,194,114,139,90,162,31,228,198,129,96,97,224,87,232,183,43,193,104,251,129,67,148,240,227,100,4,27,202,89,241,226,221,189,142,102,74,1,234,197,88,247,95,217,142,161,58,118,124,174,252,162,242,248,126,19,199,138,191,202,209,59,204,127,100,65,187,50,108,197,107,107,205,55,228,48,246,168,68,28,74,186,102,54,116,29,188,57,221,206,122,202,240,151,15,23,162,146,91,12,88,51,69,3,110,205,52,5,186,49,46,171,126,221,23,30,236,45,162,17,198,211,238,177,147,106,5,203,206,78,143,1,167,153,96,15,225,28,219,223,209,68,221,218,102,32,19,138,90,130,254,63,73,240,165,99,150,83,198,65,210,22,92,216,204,186,182,213,249,35,2,80,190,138,101,47,225,210,232,29,85,90,174,228,82,244,173,189,193,47,20,238,93,189,172,27,25,87,244,243,224,87,201,186,153,42,69,160,195,77,180,136,128,231,197,161,163,94,0,191,87,57,125,254,155,170,223,110,165,95,181,188,82,153,240,68,118,58,137,253,184,248,35,170,207,20,197,246,93,21,36,48,195,147,75,92,94,166,34,77,198,225,189,122,91,111,136,32,138,146,132,33,113,35,32,184,97,10,255,132,98,61,203,100,65,30,160,150,30,85,22,8,32,101,187,142,240,176,3,67,219,207,113,202,242,213,177,61,155,141,225,69,7,10,3,184,65,132,69,241,149,214,97,91,168,150,187,136,18,190,15,66,134,232,239,202,169,247,10,160,246,157,238,77,41,185,221,165,157,108,94,145,231,229,169,101,1,167,15,161,20,158,211,139,204,107,228,206,211,185,65,246,158,167,12,107,190,45,182,28,192,44,106,148,62,159,222,82,10,227,237,251,3,151,152,139,76,162,183,169,202,107,181,200,129,195,124,71,208,135,234,26,203,154,53,208,137,99,150,100,142,114,50,153,183,126,133,1,253,9,202,235,65,46,106,126,8,5,105,93,53,17,35,209,62,117,114,152,57,29,66,71,127,2,130,103,158,7,17,86,195,64,229,219,75,195,212,33,209,50,154,59,27,177,135,24,163,107,219,137,197,220,7,153,96,131,0,65,187,83,25,18,15,100,245,27,6,174,119,25,182,124,115,158,7,84,182,105,34,75,231,222,190,48,233,221,49,119,79,153,174,200,28,223,87,37,72,254,237,189,199,23,239,255,69,27,152,251,104,233,142,231,80,48,149,197,234,170,200,149,73,120,9,20,212,128,69,99,144,23,22,83,89,207,47,19,17,198,156,214,226,55,130,85,146,54,5,58,224,214,6,27,36,31,164,126,182,225,53,4,52,100,11,28,220,125,41,101,102,215,188,97,6,55,113,252,140,78,81,115,58,203,129,115,132,109,206,21,68,78,20,128,95,62,34,72,211,75,41,78,234,223,115,175,57,229,107,227,179,9,162,15,86,211,207,126,44,120,162,65,99,15,187,57,91,18,41,138,119,15,37,90,138,187,40,13,121,164,30,26,160,7,116,143,9,149,10,228,215,85,75,134,113,241,72,248,12,116,160,177,187,166,188,208,252,178,182,169,220,121,139,203,135,116,198,224,193,215,214,189,110,168,68,129,130,192,8,226,15,122,181,16,37,227,17,156,38,246,249,4,89,193,12,237,32,109,66,52,139,50,235,10,231,210,19,204,191,161,192,238,27,142,203,62,146,194,119,135,132,70,245,214,127,209,179,254,19,43,72,110,124,118,71,34,142,134,163,182,130,140,131,160,56,194,13,10,6,8,136,131,171,206,237,108,163,127,8,17,208,116,17,165,125,236,166,45,180,115,123,110,117,255,84,33,201,176,66,60,220,2,92,128,59,50,147,27,232,7,251,48,118,128,215,225,182,113,163,1,165,184,212,132,246,28,57,13,84,140,97,222,230,172,120,254,160,216,70,239,215,0,111,160,68,51,0,31,109,79,49,38,221,94,95,37,226,200,239,75,160,227,1,122,27,49,244,122,133,67,125,60,12,216,60,89,219,92,146,252,169,205,31,71,112,119,174,142,76,205,10,173,28,31,26,119,222,159,151,151,214,150,124,197,51,174,17,3,58,240,120,130,175,51,87,155,106,76,197,143,86,226,95,45,72,196,34,230,99,248,121,236,163,207,67,132,152,165,42,252,107,111,171,10,114,221,71,94,190,87,197,251,236,116,86,60,82,253,64,166,236,178,150,126,252,230,179,186,45,52,123,29,16,175,237,157,13,213,215,69,153,217,233,51,38,227,186,80,200,188,65,110,196,78,3,202,66,175,161,253,111,249,120,23,44,176,170,211,138,243,128,128,115,108,85,27,23,107,91,1,212,31,154,136,228,166,30,96,59,92,34,162,61,242,225,232,47,195,154,45,144,74,125,246,69,128,166,229,187,39,196,152,5,66,133,189,18,245,235,31,214,153,14,205,11,130,1,238,167,83,107,14,41,235,8,139,62,37,74,87,110,189,142,226,150,1,219,52,58,115,150,62,55,66,239,30,11,157,138,57,159,200,148,184,237,250,169,248,88,159,137,188,98,30,50,189,59,15,225,149,129,184,102,146,114,254,181,178,143,54,171,186,63,219,29,83,52,76,222,208,189,242,11,81,188,87,249,54,213,162,246,147,7,72,54,22,48,119,146,108,131,16,194,137,175,45,132,109,33,243,243,40,190,135,54,116,177,29,228,193,151,91,207,114,183,37,198,58,44,53,196,42,118,27,144,95,155,137,80,255,233,76,228,204,81,135,24,99,82,230,130,134,134,90,185,64,21,78,113,200,124,44,66,8,202,250,219,158,245,90,117,100,130,99,79,193,113,76,66,140,147,91,76,194,35,42,183,235,58,162,251,48,190,103,86,96,173,72,202,179,222,118,203,182,225,42,46,211,245,250,204,238,192,46,2,210,178,141,212,84,160,233,228,60,100,58,151,244,252,138,108,189,119,187,104,222,9,36,11,182,33,204,41,164,233,176,152,233,86,233,50,206,99,64,128,110,66,233,201,123,179,225,189,88,55,210,152,178,238,149,204,213,200,212,190,228,170,205,255,165,46,209,51,91,74,229,36,181,120,52,6,82,169,229,225,218,231,110,222,218,6,179,193,106,30,34,243,244,157,149,112,198,254,119,89,250,217,97,62,28,209,188,203,80,211,129,242,222,66,129,254,133,112,29,113,174,62,6,239,237,224,23,116,214,189,215,75,239,171,17,204,68,178,19,31,37,201,108,153,71,126,166,217,28,201,87,186,193,62,200,110,44,41,74,172,66,60,174,120,134,18,85,137,113,240,138,170,198,225,97,115,26,202,243,51,96,31,18,185,179,52,52,98,63,170,11,216,247,18,9,35,203,107,220,12,6,21,178,236,232,102,112,57,211,73,9,28,24,100,146,157,25,199,182,169,71,71,6,60,175,82,210,8,190,110,18,136,70,15,43,13,60,52,12,43,123,111,248,2,36,45,160,215,73,52,54,36,80,105,210,238,113,115,116,84,251,91,72,109,192,195,188,108,51,89,2,189,86,142,28,210,69,246,138,253,85,224,49,223,6,47,125,40,72,173,56,214,70,132,134,51,244,168,101,112,151,126,77,102,143,239,4,13,116,106,10,103,119,126,65,6,31,18,107,68,76,241,127,130,133,186,61,250,68,253,189,150,134,117,83,51,83,25,187,118,78,134,35,123,184,148,245,53,68,14,88,131,0,68,159,141,48,76,196,130,198,34,56,19,203,64,75,87,26,133,28,73,19,242,167,183,2,251,172,114,9,7,155,151,79,86,68,141,54,101,212,74,210,65,219,237,175,83,252,71,245,207,108,46,196,105,180,46,85,217,5,128,221,226,157,62,176,224,25,140,26,228,142,51,187,96,116,42,92,18,197,211,133,4,0,207,161,141,187,60,8,215,220,174,187,41,153,27,83,242,133,205,30,135,7,207,178,168,111,3,85,173,149,137,68,187,204,184,237,209,59,41,154,36,35,7,212,199,183,241,25,178,86,195,41,137,201,81,164,246,218,251,180,218,161,189,193,147,17,147,15,78,69,23,170,86,93,28,58,170,81,208,143,20,240,63,182,158,203,197,94,135,254,11,135,124,183,89,193,71,88,184,98,208,164,134,197,140,75,234,159,83,20,177,109,123,195,118,229,245,116,207,220,6,11,187,253,37,198,220,195,29,176,38,46,67,200,232,90,245,23,105,165,133,57,29,208,185,232,69,180,3,5,19,111,91,226,98,197,90,102,20,243,203,137,88,156,217,18,24,141,253,17,194,150,75,120,212,232,5,187,191,80,176,71,27,94,71,149,230,108,103,17,129,248,166,186,196,171,152,249,136,146,130,38,204,223,106,175,46,105,241,113,125,212,159,243,233,110,229,177,187,141,186,157,99,212,232,218,25,58,4,212,122,110,11,236,187,184,12,168,127,135,212,37,81,184,79,102,171,143,151,189,158,113,56,80,94,110,58,223,118,37,73,53,158,134,151,251,250,216,143,88,233,8,206,211,238,115,195,53,186,238,140,128,150,50,225,14,236,49,195,224,75,85,229,24,20,244,72,136,144,15,96,152,6,156,158,133,144,200,229,50,186,234,205,77,101,31,5,147,136,55,31,158,100,141,179,213,225,15,161,176,225,156,40,169,60,57,227,45,170,44,97,107,83,178,31,102,192,84,212,43,159,32,188,252,47,248,53,6,68,8,126,187,27,46,133,214,4,199,153,29,177,123,35,170,100,66,253,178,46,37,206,97,62,17,208,98,178,195,223,64,76,251,94,132,241,102,36,130,182,53,98,94,253,122,211,197,204,144,195,101,203,40,158,215,192,102,44,87,233,61,81,147,158,79,117,222,27,26,219,168,15,59,142,65,113,172,49,253,190,191,188,12,59,244,226,238,7,59,116,34,120,56,20,118,83,59,78,142,79,43,150,41,207,228,35,234,182,14,86,50,120,254,31,74,82,5,29,39,173,104,87,10,249,237,158,29,211,250,239,50,64,90,200,107,209,100,26,135,182,38,139,177,27,64,6,87,21,235,204,230,235,222,248,48,156,212,204,138,22,36,123,3,40,93,25,200,55,162,51,116,3,140,58,246,81,78,59,89,103,138,23,220,89,171,48,48,203,181,80,163,171,109,173,17,34,188,238,42,205,32,106,18,122,80,8,247,127,26,32,148,141,138,226,57,27,129,234,74,40,235,202,6,106,127,1,11,117,117,236,240,123,227,139,185,241,205,42,57,186,237,83,21,90,3,25,88,42,109,224,140,238,11,177,108,46,111,28,229,139,95,217,72,101,173,235,131,28,2,85,51,19,52,105,218,235,176,84,57,140,165,80,238,93,92,6,47,138,188,132,100,36,219,223,236,201,112,201,190,0,20,146,68,95,16,147,1,52,108,54,185,188,154,104,247,173,127,160,214,230,207,56,112,98,105,62,42,66,97,101,47,220,193,114,23,202,61,21,118,64,16,191,112,119,123,20,117,173,202,70,39,239,112,202,66,142,163,211,106,89,2,97,150,55,78,226,111,190,170,144,53,195,72,96,89,229,178,153,130,164,161,86,154,154,21,95,120,12,31,122,50,142,245,189,124,17,218,35,201,75,20,203,234,97,11,70,151,3,185,169,71,243,91,56,248,117,103,8,162,90,14,193,33,124,194,169,48,150,40,80,127,37,151,74,195,221,99,145,74,172,228,150,120,147,204,160,67,110,187,30,236,197,101,7,127,128,115,7,243,235,20,66,101,40,114,136,254,206,220,67,96,231,89,65,202,234,82,8,131,187,238,220,213,142,223,77,25,167,69,68,87,110,101,200,142,51,26,234,143,164,214,134,215,222,141,23,42,75,147,88,211,199,154,201,24,72,202,13,136,234,25,52,120,254,136,185,193,163,187,133,84,93,81,133,177,73,126,136,46,251,136,144,180,33,34,18,230,128,47,79,79,106,150,8,58,160,248,106,132,183,215,17,146,173,177,243,32,65,1,175,14,45,235,55,127,69,29,175,177,184,199,168,231,173,143,212,218,44,28,243,157,87,243,247,193,142,155,49,191,221,140,235,246,53,125,204,139,60,232,18,220,63,106,61,252,172,154,140,47,208,189,55,163,20,44,108,250,50,252,255,204,45,52,2,76,66,64,241,107,21,163,134,187,242,247,136,203,1,7,118,226,244,67,198,15,238,194,74,9,230,186,185,49,162,49,71,168,31,130,160,103,223,244,225,108,133,142,123,181,164,114,112,172,100,229,165,150,250,57,212,15,63,204,70,163,4,98,111,152,45,37,45,245,228,45,244,111,124,250,163,197,120,243,232,117,56,154,191,145,196,141,125,8,55,90,132,216,85,224,174,60,253,201,63,198,114,202,235,236,103,174,176,192,65,93,161,74,226,65,222,241,126,119,113,174,16,71,68,19,253,160,250,79,117,231,129,159,61,132,104,164,251,78,110,48,246,12,36,172,100,111,152,87,36,40,95,115,60,227,74,123,204,149,244,119,65,162,114,102,121,19,155,249,117,248,51,151,33,42,115,199,237,144,43,180,51,121,129,23,83,127,226,56,9,32,222,44,201,44,21,7,249,122,183,224,239,85,204,10,181,91,19,103,103,133,205,12,229,38,97,31,108,141,82,255,186,32,185,59,95,66,45,15,41,179,36,56,178,53,39,230,128,252,12,104,165,98,132,4,223,238,44,36,222,188,218,52,250,146,212,148,237,85,68,175,72,79,155,38,36,230,62,122,67,208,138,241,5,49,158,119,106,100,178,247,61,154,161,134,111,198,28,192,44,150,189,7,205,154,142,45,190,172,69,107,176,36,105,64,30,153,120,233,138,210,10,19,201,37,119,182,152,85,43,37,56,68,199,14,82,214,220,245,249,231,141,77,20,190,252,61,102,166,209,230,24,109,225,229,78,195,145,93,109,32,127,163,49,126,248,87,165,80,47,35,155,3,51,50,146,244,105,171,122,226,62,82,242,157,209,37,222,157,224,156,21,73,10,238,198,123,110,60,209,122,158,82,5,221,166,227,119,183,251,80,175,245,112,156,150,175,183,247,162,53,159,213,33,71,40,168,227,104,244,244,210,154,12,114,234,6,153,36,147,203,170,108,85,64,250,110,225,137,2,143,243,163,40,173,220,191,63,210,108,131,154,142,83,175,46,56,41,236,83,221,81,161,144,135,172,99,88,139,115,229,148,143,162,9,203,12,44,238,102,165,234,230,179,179,242,16,227,158,20,196,203,126,102,121,194,246,105,131,73,192,81,122,192,229,32,52,68,139,60,16,102,94,4,190,236,77,238,222,73,240,221,6,252,179,240,56,85,108,237,167,95,168,223,161,49,28,186,57,93,43,203,125,223,42,221,67,47,174,96,56,99,204,115,41,252,252,106,153,180,228,242,100,155,42,105,108,181,215,47,150,176,81,36,192,211,244,135,162,127,189,201,80,62,117,91,125,58,245,215,9,16,165,134,52,42,43,225,155,28,21,189,76,85,226,216,155,133,105,120,60,145,152,6,52,150,149,2,255,255,126,255,45,36,58,37,21,112,25,5,210,187,69,74,195,46,226,170,12,90,154,7,142,228,89,148,22,211,1,150,132,252,99,19,215,135,242,15,150,0,17,251,192,38,133,71,164,62,161,144,240,178,62,63,254,50,137,26,207,233,156,52,145,94,86,239,132,26,146,181,46,165,248,100,14,76,252,16,214,130,195,166,67,120,113,30,255,126,197,11,57,108,130,66,163,177,70,30,223,117,244,53,44,13,86,39,70,58,213,212,230,152,164,76,152,10,227,3,6,230,216,73,88,108,91,245,126,137,58,224,132,168,129,199,254,247,134,142,56,81,168,160,119,44,222,123,230,189,204,92,245,18,227,172,58,240,174,149,68,71,210,183,169,241,146,73,86,210,216,156,250,239,161,219,212,210,69,48,33,137,81,185,192,218,197,2,122,26,76,13,121,61,31,44,239,37,158,126,254,241,131,26,167,224,67,133,125,52,204,195,141,119,131,208,214,151,86,54,137,139,144,178,173,220,170,156,70,125,66,38,125,127,135,146,246,160,95,230,1,248,184,55,65,56,225,139,169,106,17,246,153,98,119,248,67,85,148,28,157,200,233,186,149,138,180,147,37,42,212,190,28,189,109,117,242,168,56,133,17,29,241,89,218,5,242,81,50,61,166,175,124,106,47,237,20,201,235,69,95,202,35,243,79,223,34,85,47,100,252,168,29,171,20,189,109,65,14,156,71,195,246,94,104,211,21,29,195,84,33,131,207,221,120,139,57,78,126,88,195,191,172,133,96,242,110,140,236,227,76,154,55,32,134,193,20,204,21,192,232,157,224,147,175,193,96,9,127,18,107,239,96,240,98,139,149,104,92,151,196,170,198,104,185,117,179,26,20,72,48,36,47,32,86,42,189,173,80,71,219,151,79,181,88,45,26,191,38,133,45,54,131,31,109,115,161,163,34,38,89,40,49,173,198,48,17,40,39,121,77,90,70,42,251,130,168,125,184,76,60,95,94,136,227,248,145,210,226,191,137,247,72,210,17,141,52,5,102,220,23,111,146,114,218,208,22,105,9,130,97,83,57,25,228,137,6,99,12,24,29,89,25,101,217,133,196,253,246,158,114,75,8,90,142,28,147,19,22,164,240,205,1,21,145,19,225,61,98,21,22,215,32,158,9,44,97,148,104,201,219,76,43,45,162,73,151,252,188,155,192,134,113,103,109,255,54,42,206,24,76,87,154,98,187,78,193,50,86,191,222,86,162,165,38,191,118,117,72,31,6,174,147,231,105,158,70,133,79,138,223,55,73,210,90,194,194,112,167,14,253,133,160,197,234,193,24,75,239,106,47,115,70,102,75,122,123,87,158,185,162,180,84,210,222,141,172,125,211,117,181,155,250,182,51,247,178,100,123,8,8,173,224,246,222,40,35,31,171,203,195,36,34,6,53,171,105,219,106,216,77,18,130,182,37,225,3,235,196,203,114,168,7,2,10,14,230,118,6,134,118,20,184,145,213,218,127,110,182,193,145,91,202,110,11,96,118,1,8,96,103,167,236,180,15,141,151,253,100,7,112,25,70,89,121,233,178,158,234,47,68,162,185,146,146,7,74,2,17,238,108,171,91,64,92,173,85,82,121,240,175,136,132,26,123,225,64,169,132,53,192,187,113,8,165,133,192,249,61,166,108,170,2,175,11,243,183,162,93,109,51,151,40,206,39,150,0,84,130,215,29,211,96,200,244,193,206,63,137,9,225,205,195,93,147,70,125,177,146,164,76,247,0,61,118,12,73,75,151,145,218,82,180,207,112,233,175,169,104,180,29,149,4,129,248,70,10,159,34,67,208,4,235,146,205,128,223,104,17,16,189,72,150,29,148,21,85,152,237,97,200,84,57,234,9,165,16,73,40,118,10,18,222,171,43,231,169,211,149,179,250,145,227,129,66,53,2,35,228,99,7,1,101,161,122,247,98,103,47,32,194,21,66,228,215,171,211,95,93,47,71,164,197,154,72,46,73,190,186,131,152,104,252,1,237,94,154,240,6,67,188,57,183,3,28,30,181,14,142,247,193,242,88,231,188,86,198,130,125,97,9,115,137,196,6,38,94,170,51,157,253,197,152,195,181,150,253,125,49,6,217,29,102,120,252,248,217,191,232,176,151,7,118,12,126,164,219,67,123,72,16,146,223,203,183,0,196,87,186,185,173,67,246,204,171,20,21,86,98,182,253,7,186,6,120,189,118,3,229,237,60,53,90,120,139,87,229,79,153,85,139,16,81,100,189,150,202,125,164,42,132,10,163,190,85,177,69,169,181,85,186,64,77,182,99,209,185,183,19,5,1,24,167,247,211,71,7,154,124,136,40,199,61,196,217,202,170,170,93,64,20,178,234,247,41,59,124,192,158,211,128,28,144,37,95,61,108,113,150,27,161,102,97,250,86,162,10,193,27,201,55,193,56,84,164,176,59,172,180,2,117,209,83,226,255,156,104,115,80,9,171,177,196,38,252,19,138,252,29,242,231,74,93,205,161,41,158,79,204,211,0,30,248,42,125,237,167,151,3,163,35,219,102,225,38,80,160,246,91,202,15,81,5,104,108,210,239,193,131,146,27,150,17,171,71,221,84,112,204,146,94,186,237,255,206,118,141,107,20,169,226,15,43,75,224,52,120,186,0,134,235,166,30,237,98,31,139,146,29,104,64,56,3,249,66,92,147,217,211,9,31,96,178,69,148,227,230,101,236,243,45,246,172,39,229,59,69,106,63,147,212,148,179,217,10,220,19,61,36,147,54,173,248,250,238,79,181,163,211,105,11,79,136,249,56,91,202,219,147,180,212,42,140,52,110,222,216,92,215,61,213,55,188,33,239,190,201,255,96,1,215,85,244,86,49,152,17,180,172,68,196,115,71,107,182,243,219,136,48,23,116,210,242,8,233,123,235,101,169,61,55,63,1,51,205,161,189,96,59,52,218,197,250,26,88,73,52,217,104,199,216,234,189,209,12,232,29,210,128,20,244,127,219,15,204,123,222,84,167,249,54,43,174,28,118,186,210,116,176,58,78,38,166,130,144,219,92,43,91,180,1,195,20,39,139,0,25,240,204,75,61,178,95,199,10,3,136,139,50,249,155,86,95,70,214,41,166,76,132,6,166,146,35,118,145,100,203,149,154,211,215,94,104,5,44,83,183,45,251,89,212,57,197,144,82,87,170,120,45,105,80,129,100,131,159,10,127,221,163,246,63,192,154,53,205,6,127,117,223,24,147,216,93,28,239,163,214,221,158,12,149,255,83,88,41,136,165,138,1,254,6,44,25,143,22,104,150,94,24,196,25,238,193,216,170,71,103,76,33,52,211,45,205,235,134,41,248,86,65,9,32,255,32,95,30,250,243,251,43,119,170,184,85,107,38,21,98,231,54,218,226,16,72,174,6,221,38,211,120,221,119,117,120,67,209,251,33,84,155,163,163,47,53,96,15,51,76,204,87,153,85,170,54,66,113,12,174,34,104,136,90,62,76,103,210,150,82,37,200,148,44,89,113,229,33,173,240,114,61,21,131,193,157,216,181,193,207,219,29,42,99,21,186,158,11,145,155,4,216,22,244,162,245,120,63,128,57,117,241,213,60,251,251,149,87,153,99,63,22,75,81,103,103,239,199,225,110,110,88,38,125,240,116,161,226,53,38,183,2,223,68,221,87,205,73,201,187,129,82,39,35,166,109,116,96,250,15,15,242,104,227,86,21,140,48,172,188,54,214,185,33,4,199,217,220,218,185,44,244,170,133,64,135,231,135,80,159,130,65,112,36,250,209,241,226,74,174,130,199,202,217,218,87,161,162,130,254,242,150,34,63,117,178,224,76,211,80,201,111,72,69,137,93,62,24,23,249,115,80,83,95,17,166,84,223,132,120,6,53,34,199,208,205,80,109,133,213,92,49,18,214,230,123,245,73,80,228,94,106,241,165,216,84,255,96,177,178,90,92,5,219,185,153,238,208,136,79,150,15,232,139,179,52,146,235,158,62,239,136,154,45,92,190,176,19,91,40,214,152,149,209,222,247,97,175,74,250,98,231,204,211,233,2,168,136,18,202,254,144,196,95,80,187,220,123,31,164,176,207,23,248,81,3,174,138,206,65,83,36,29,70,32,71,21,227,157,254,228,2,4,215,71,27,252,9,219,49,49,23,248,163,43,170,192,126,75,198,97,91,38,182,93,204,141,250,187,145,128,158,103,88,73,178,191,233,253,231,3,169,38,117,163,181,44,217,91,138,15,239,82,140,19,78,13,168,212,227,46,202,225,130,28,150,211,105,239,25,243,208,76,174,52,37,170,87,125,141,221,90,95,41,51,53,205,112,75,54,129,102,51,87,222,28,117,188,154,174,103,66,55,95,247,97,127,31,107,22,117,195,115,97,108,19,52,70,179,212,190,15,8,213,49,139,119,170,201,169,8,199,203,166,183,90,134,185,169,133,135,9,251,66,104,187,220,182,164,82,21,125,132,197,116,14,169,241,211,104,107,169,17,246,140,46,235,236,23,84,93,180,72,214,10,39,185,197,170,73,30,43,35,75,114,202,126,143,2,127,114,206,107,25,116,183,11,43,3,146,183,121,214,79,26,240,70,203,45,88,74,11,137,245,21,38,44,66,143,61,168,69,76,204,92,186,121,203,15,46,213,237,131,23,220,68,52,188,111,185,48,81,35,208,159,218,44,76,71,236,152,61,103,92,247,136,123,88,196,109,213,91,97,190,88,164,237,171,59,217,231,230,51,149,191,114,162,41,91,249,249,25,109,183,231,25,48,30,35,44,156,199,26,146,144,26,85,40,82,54,83,253,102,88,29,52,114,160,176,0,95,4,217,205,123,143,97,62,149,15,178,195,166,156,183,183,170,183,54,232,197,211,241,7,215,241,86,159,151,161,98,116,91,139,14,111,22,41,155,5,43,72,245,246,20,196,27,62,112,149,21,253,42,111,173,148,25,42,199,41,53,84,169,17,246,92,25,211,161,41,159,252,62,243,4,19,121,43,66,199,74,28,208,193,205,33,126,84,173,30,16,26,179,244,95,188,90,6,16,178,251,191,203,121,130,161,12,52,170,24,14,141,2,163,190,6,52,205,187,57,245,252,9,53,65,132,246,126,90,3,26,54,238,222,74,237,35,163,214,83,43,254,139,112,244,74,15,241,20,255,217,117,129,81,233,181,187,160,29,30,245,145,199,163,29,171,87,228,222,50,229,60,139,23,152,179,33,23,124,180,100,223,209,21,191,93,240,166,209,66,67,28,158,237,190,62,80,188,131,151,72,22,159,212,121,139,49,254,184,106,134,122,77,103,165,81,70,69,174,0,7,179,26,152,234,23,37,155,212,120,59,223,226,216,189,170,9,42,206,10,123,140,130,214,229,149,218,74,215,152,151,235,170,53,33,209,190,193,105,61,182,108,226,176,32,213,78,117,106,23,56,121,61,82,213,107,121,107,114,185,20,99,151,57,44,105,153,238,174,24,192,241,254,251,80,193,143,221,0,58,227,109,190,129,185,22,131,37,221,129,34,101,144,152,33,250,198,183,73,236,69,174,215,68,64,181,94,33,132,40,149,248,252,133,191,99,245,130,21,43,49,211,224,204,33,169,240,230,120,107,228,46,140,168,241,32,17,95,48,147,101,16,176,251,83,160,253,105,171,56,79,198,139,36,48,144,120,99,236,171,235,56,117,196,171,178,244,170,61,79,183,32,202,66,50,130,211,99,78,199,73,255,242,30,138,199,156,129,107,187,182,255,144,201,230,138,199,111,154,10,126,232,144,99,117,187,160,97,221,177,191,5,239,139,181,240,32,249,247,61,216,207,154,217,224,246,49,118,3,194,107,197,233,3,242,99,182,58,45,151,176,238,101,118,57,44,123,195,112,61,129,140,199,98,25,86,104,2,141,220,161,128,109,32,8,89,147,249,11,246,14,255,195,81,233,46,89,37,122,225,211,69,132,120,138,169,254,0,72,208,116,247,244,60,55,28,135,15,11,28,174,65,40,253,148,181,6,57,220,134,224,205,255,225,22,228,49,200,228,182,179,141,237,217,9,47,114,203,57,24,173,236,15,100,174,120,178,73,84,236,141,45,188,142,252,66,85,56,248,161,247,21,240,209,145,198,24,158,227,106,158,18,248,204,21,1,99,35,91,187,157,228,98,106,35,231,158,103,53,119,135,62,168,207,48,5,118,236,117,255,204,65,60,49,102,180,55,82,149,17,205,214,182,198,223,77,55,234,99,156,29,161,90,22,138,7,126,240,213,226,110,63,214,97,71,161,203,216,10,31,25,62,71,223,163,238,97,14,115,144,121,112,103,4,186,16,66,51,105,110,65,111,32,206,82,213,231,74,107,199,255,85,48,249,19,123,45,142,3,104,77,86,181,99,8,158,50,3,108,43,23,113,246,189,180,107,134,24,9,137,36,178,9,176,197,63,33,63,164,220,217,243,175,16,197,210,28,16,109,192,143,193,240,252,44,124,8,108,179,168,171,135,107,32,216,49,136,123,109,133,33,176,167,185,189,30,120,210,5,211,14,127,118,199,147,121,246,58,33,239,172,251,87,223,152,144,13,169,216,65,87,59,132,210,118,116,30,68,72,68,155,103,230,81,33,26,21,82,14,73,251,183,147,86,222,194,97,44,169,244,82,155,95,253,205,116,91,165,44,64,31,163,242,253,93,23,26,209,14,33,97,62,148,115,63,247,111,137,13,9,163,215,243,223,218,10,114,82,195,219,233,24,117,167,173,231,13,156,77,46,231,130,200,122,169,91,49,229,215,250,140,73,229,240,44,212,41,117,112,31,126,218,196,58,241,101,147,26,195,148,98,153,198,104,87,90,149,128,60,239,177,50,49,11,242,239,230,196,182,89,101,80,215,168,143,70,48,53,53,215,22,99,194,129,245,128,163,40,102,25,14,99,189,152,35,135,13,16,105,137,188,32,226,246,176,38,30,36,65,146,145,240,83,103,2,107,133,21,172,41,239,28,250,134,170,228,80,43,122,211,87,111,228,168,29,171,79,69,62,152,18,69,203,96,169,144,83,50,37,65,208,1,113,46,2,67,73,221,2,181,73,185,209,20,163,237,141,222,221,69,220,155,12,177,239,150,84,234,58,111,225,3,31,187,110,139,78,139,234,186,202,73,72,34,125,59,43,206,220,68,6,49,123,14,147,144,206,60,95,31,173,236,244,239,64,11,119,89,226,7,117,175,218,115,104,165,195,209,202,140,132,15,6,115,213,209,69,238,7,89,37,249,156,158,67,124,208,100,194,232,148,52,214,125,166,99,224,152,46,109,187,234,230,51,60,189,191,120,28,13,67,152,105,230,40,147,153,215,16,149,231,51,170,159,88,97,228,216,161,34,87,65,129,153,213,186,140,150,104,113,164,25,120,246,58,78,221,124,33,179,135,7,220,233,68,9,15,123,101,187,131,139,95,177,234,29,215,24,57,107,53,194,252,161,247,70,224,245,22,104,10,41,39,213,190,186,249,159,32,28,196,55,153,225,205,18,72,227,70,120,101,199,237,132,225,10,124,88,154,151,215,153,67,177,100,244,99,169,37,127,97,122,188,216,217,79,187,227,87,69,243,42,139,151,228,79,141,154,88,240,7,29,255,165,129,150,70,173,212,207,194,245,243,54,210,111,168,77,71,140,61,28,64,106,8,196,60,68,154,18,110,22,252,63,172,163,34,138,138,105,145,101,244,110,11,75,95,244,220,224,140,191,243,85,79,137,128,246,173,146,28,1,68,146,131,190,104,107,105,10,183,141,149,204,59,176,190,91,3,180,254,33,47,24,58,4,53,177,211,193,103,6,161,57,156,191,177,108,76,83,185,133,20,167,103,26,75,148,54,239,124,182,71,95,160,157,60,112,22,149,136,53,82,150,241,250,192,35,199,124,207,79,66,84,131,7,63,140,114,16,166,158,30,0,73,131,202,144,116,46,50,92,60,23,147,147,14,236,195,64,128,205,63,248,146,1,49,182,30,96,166,149,196,243,131,88,93,119,167,118,22,137,56,179,169,223,194,48,235,4,196,19,7,210,55,75,235,92,247,15,83,174,53,132,172,34,214,91,205,147,70,34,195,103,132,175,68,245,7,227,205,122,160,7,72,137,123,51,243,8,7,82,113,179,53,171,249,151,156,75,82,204,101,194,53,247,2,201,39,125,151,8,4,189,190,40,95,41,72,181,116,99,58,100,136,118,164,13,191,107,164,69,39,229,204,2,248,254,87,112,64,247,106,105,66,193,73,104,67,75,181,248,105,39,227,153,139,164,41,215,76,244,118,95,99,56,13,94,20,67,33,205,238,108,249,81,105,60,177,18,155,229,73,173,205,78,164,144,180,161,191,210,203,150,190,16,55,228,110,203,212,118,15,103,25,67,152,199,2,36,17,117,201,129,88,197,112,153,188,44,58,196,160,131,198,150,19,223,209,224,90,127,231,71,1,40,82,195,12,242,223,233,211,68,210,32,176,1,106,119,179,211,33,221,107,210,194,227,213,88,3,122,19,130,145,199,16,66,179,41,215,40,18,133,40,191,25,49,31,101,27,16,11,60,119,20,186,217,168,204,250,28,173,159,38,166,106,2,35,49,133,30,16,174,41,134,5,154,247,72,247,171,23,225,89,228,141,14,221,122,56,188,54,252,90,121,252,169,8,168,27,59,138,8,245,70,122,230,65,165,140,117,136,206,11,169,209,146,240,8,234,87,27,21,119,136,227,84,138,65,172,42,227,109,202,167,67,219,148,125,32,179,242,176,224,42,235,163,145,195,63,145,122,135,21,164,85,133,249,38,87,145,90,3,151,203,189,99,172,189,248,86,207,193,226,138,44,42,179,190,99,83,127,92,185,32,159,58,246,239,241,246,235,227,205,219,169,42,77,149,0,212,210,172,47,174,68,122,133,7,78,152,86,30,65,58,84,65,40,113,125,213,150,112,146,1,46,218,175,242,206,243,3,22,233,246,135,129,96,57,130,15,151,104,91,220,169,42,107,34,44,14,229,23,97,55,219,134,96,213,252,133,227,120,195,1,46,17,86,212,120,130,91,248,166,233,51,66,254,106,183,117,42,44,36,169,196,204,173,91,96,109,228,171,28,189,45,250,183,121,167,12,164,164,245,225,177,164,170,138,139,161,93,90,83,85,26,198,104,106,203,108,131,144,196,153,22,188,229,99,101,228,68,84,115,35,112,19,129,18,184,189,228,220,191,206,106,106,126,188,176,42,150,208,166,249,215,76,49,78,167,49,137,16,206,210,203,31,206,130,158,233,143,12,168,123,152,246,181,110,5,9,143,33,8,20,72,188,117,52,80,18,200,90,101,236,228,207,56,241,5,217,53,40,86,180,67,214,216,113,227,232,42,4,123,161,29,225,131,69,60,164,193,158,200,54,177,14,32,137,153,25,110,144,200,246,156,194,61,16,88,79,24,113,181,5,133,88,82,165,176,38,251,156,45,231,111,141,37,120,107,195,254,51,23,243,143,18,30,92,222,216,31,27,168,49,204,158,75,50,29,108,173,189,227,162,147,5,233,159,187,189,71,11,14,221,15,68,223,60,234,186,227,182,193,229,131,242,98,115,34,126,30,59,20,56,101,249,9,38,148,110,79,181,179,181,29,240,61,110,204,161,242,160,184,30,38,49,180,136,78,22,156,1,249,192,217,132,67,3,250,243,132,141,231,10,84,231,97,122,73,28,88,116,105,213,193,202,47,183,216,19,80,71,55,14,123,32,194,193,121,208,234,113,73,234,146,93,189,196,164,129,140,201,122,187,60,67,10,121,125,17,246,192,134,16,58,220,3,66,88,63,127,197,206,164,85,151,11,143,43,109,35,215,25,113,90,99,90,205,22,209,122,41,112,244,206,253,59,161,241,168,251,89,190,186,151,193,3,142,219,1,102,68,147,87,145,74,157,223,203,18,248,51,21,219,92,9,251,196,149,82,153,103,27,151,252,54,21,4,47,205,56,172,183,3,29,202,225,83,16,70,15,21,227,219,225,178,248,157,53,135,57,185,163,37,123,167,126,80,187,41,181,17,191,207,228,71,37,158,205,118,62,248,250,194,59,71,214,167,103,233,25,73,205,178,231,128,78,53,113,28,73,140,86,87,88,87,238,196,137,77,234,138,39,195,39,117,89,71,3,123,115,108,182,175,148,180,142,193,159,155,141,71,168,172,98,136,187,112,36,25,146,98,217,160,17,34,77,55,98,189,208,173,74,117,181,200,124,182,123,12,56,62,149,214,75,112,112,107,126,242,224,85,234,235,172,131,250,233,229,99,14,92,194,36,21,156,167,172,215,243,141,214,57,79,177,104,94,207,160,8,3,102,237,50,84,126,223,147,92,211,221,196,52,130,24,176,159,132,65,156,131,71,126,4,33,143,91,104,28,50,153,209,95,181,28,75,113,70,67,27,109,192,39,174,135,252,172,218,211,94,160,62,199,154,79,251,16,22,195,15,22,140,253,36,242,85,72,147,22,121,33,25,195,83,123,67,179,160,66,85,146,45,114,228,93,116,57,55,217,212,216,31,50,167,229,242,19,107,240,57,124,255,142,191,249,148,74,39,163,43,156,151,201,207,220,46,185,27,203,141,137,15,92,5,101,198,159,181,2,84,128,42,9,10,185,221,175,55,128,247,131,98,98,146,152,8,240,110,121,15,67,233,2,21,145,83,105,182,127,239,100,153,185,165,225,124,59,119,26,175,192,81,4,98,42,93,184,200,34,68,13,134,123,5,43,164,167,218,32,67,79,70,4,196,254,131,50,201,157,133,80,79,208,242,155,224,237,252,110,27,249,238,45,235,77,229,182,93,205,123,32,5,3,78,154,69,213,117,216,130,198,46,105,47,78,76,255,250,230,254,99,106,218,110,21,186,185,71,173,236,91,67,119,59,38,141,202,223,39,183,153,239,2,113,168,121,123,54,217,55,237,94,11,1,190,38,16,170,216,147,239,88,254,229,245,220,108,102,247,55,229,237,173,167,179,231,185,82,226,109,53,81,87,15,55,217,69,204,109,3,164,126,143,193,42,141,227,90,36,226,83,128,215,12,177,216,190,140,85,129,225,224,25,74,141,225,41,192,131,60,180,130,169,191,124,58,1,135,224,63,27,9,138,244,124,167,199,35,2,120,62,25,218,238,78,254,29,125,60,19,72,168,31,194,52,28,70,137,193,242,203,2,91,43,138,248,5,135,204,165,116,67,10,198,121,98,100,238,143,43,94,209,39,162,232,129,176,41,254,158,40,195,167,51,206,48,151,123,55,64,65,233,220,176,238,73,3,129,139,129,242,194,88,95,199,147,187,75,237,229,171,30,89,115,154,239,165,169,235,59,98,63,177,91,115,84,142,203,97,103,79,66,2,91,157,207,14,45,246,75,211,46,69,228,42,158,158,132,228,178,36,163,98,194,69,11,37,186,217,155,206,244,54,125,9,122,128,237,37,159,232,91,68,159,92,116,153,244,199,136,214,88,171,186,117,98,60,171,163,232,45,147,151,123,170,237,130,250,83,244,253,125,237,248,178,237,111,15,63,154,122,147,51,15,60,204,111,139,245,231,228,185,51,36,176,237,79,48,4,150,130,163,59,120,29,126,54,40,104,116,142,238,121,237,189,107,191,35,8,119,113,131,109,108,173,24,9,142,108,8,49,51,202,146,192,173,17,1,241,218,187,124,164,246,139,220,70,143,192,138,152,227,175,189,77,209,86,106,63,119,2,159,194,2,163,89,30,119,83,127,152,98,60,123,145,96,155,67,36,124,94,20,93,243,98,219,253,143,238,124,45,39,226,10,242,116,227,184,129,242,21,192,51,94,97,231,64,148,237,211,59,177,198,10,216,238,62,4,109,230,168,9,132,240,215,0,86,29,251,174,78,233,243,27,50,92,197,253,214,2,123,146,246,222,140,146,148,108,237,15,4,222,247,156,154,132,10,40,151,8,10,70,114,132,181,145,136,176,233,7,169,57,111,204,90,220,67,215,132,40,150,216,152,69,54,80,43,171,67,46,100,140,33,185,115,58,154,35,242,247,6,43,31,174,39,80,101,216,73,40,132,227,201,14,85,37,194,50,3,146,118,78,76,36,211,88,24,220,98,14,33,120,148,222,160,20,160,118,195,167,167,92,128,37,5,53,38,72,206,146,123,57,213,135,200,109,71,35,239,160,169,225,222,136,217,153,92,67,165,51,105,189,47,203,155,237,217,9,216,232,29,225,177,49,205,230,232,177,124,66,19,114,207,198,114,64,45,161,124,66,110,85,157,81,102,32,22,83,53,111,196,27,133,196,169,162,223,120,126,235,105,163,132,221,206,150,110,214,226,227,26,172,30,160,193,251,235,130,209,125,165,77,58,39,115,187,196,165,24,148,33,237,15,73,76,51,191,88,212,165,137,89,220,47,35,108,174,114,48,214,113,39,163,180,185,63,88,233,112,0,120,241,137,168,24,63,138,54,82,207,177,179,66,101,46,177,222,3,52,49,103,68,5,246,78,182,234,55,35,29,9,19,192,144,78,132,224,162,148,96,89,62,61,109,6,178,98,241,196,88,167,22,196,56,11,139,35,94,112,213,134,206,158,24,179,145,144,24,250,44,149,253,67,210,8,0,244,166,243,0,180,234,155,46,191,122,41,93,142,70,154,56,201,66,159,207,162,193,63,26,46,204,221,206,29,100,232,161,225,87,106,130,47,154,66,253,50,33,4,103,71,134,239,65,137,220,222,90,200,221,145,253,16,73,125,66,213,113,239,82,209,96,85,98,196,87,143,30,250,24,217,92,120,23,123,71,64,51,243,204,192,239,147,75,30,170,32,161,187,95,176,78,235,9,173,103,112,9,93,39,55,89,66,223,135,55,158,58,28,249,4,53,46,175,138,48,65,135,70,136,1,162,20,77,236,103,41,150,88,60,162,162,221,75,62,108,114,118,100,40,120,101,241,122,160,0,109,225,54,161,239,188,6,149,136,139,198,177,179,32,43,126,52,149,57,217,226,136,215,201,55,32,213,229,87,28,109,36,223,42,151,98,71,107,140,255,230,206,183,84,127,109,108,57,226,37,11,140,188,250,216,82,32,241,186,122,68,173,128,81,29,57,2,23,81,10,233,198,238,113,91,11,7,17,184,180,159,230,116,147,143,120,21,24,1,220,118,49,16,80,204,12,78,41,111,117,193,98,56,148,193,219,160,156,230,56,126,1,172,183,95,204,229,202,75,218,108,245,33,254,8,58,127,98,209,197,176,100,60,110,139,133,80,43,42,133,200,12,216,121,186,89,171,171,252,220,132,121,46,180,75,79,8,157,91,112,112,34,247,193,147,132,119,236,30,223,101,129,132,197,45,134,84,202,92,249,70,208,211,158,206,209,216,202,106,106,96,1,80,249,182,103,247,124,85,169,42,212,67,245,112,214,156,147,143,216,186,202,197,119,5,230,23,226,199,79,150,253,252,85,1,193,145,96,212,15,165,73,246,244,50,249,165,95,254,252,112,62,100,237,167,234,181,238,164,135,224,175,19,225,82,153,135,122,209,81,59,123,165,21,127,99,54,56,18,153,226,205,161,95,202,7,79,126,124,92,208,244,46,5,176,227,206,200,16,140,97,250,131,187,54,34,117,52,52,206,150,201,200,182,45,201,225,80,46,100,113,199,193,12,116,224,253,59,85,244,248,161,239,199,164,208,63,114,103,163,167,185,246,203,19,33,102,53,236,108,3,205,170,155,230,73,204,142,178,233,7,187,171,191,137,254,60,149,218,98,40,42,87,10,3,146,207,162,67,113,25,173,141,27,217,143,225,97,164,2,208,116,57,181,180,112,233,183,114,62,110,197,29,79,155,213,7,115,94,60,229,43,83,79,119,171,196,20,78,239,233,51,87,6,32,5,59,166,121,176,193,0,2,145,150,183,130,7,36,179,159,57,212,66,179,111,151,174,27,202,58,35,12,121,174,29,17,69,244,46,87,1,173,238,194,40,107,180,147,157,209,184,241,104,251,123,242,164,42,31,93,118,82,79,189,47,105,102,158,30,210,164,16,47,140,226,212,235,70,176,78,30,247,193,162,137,19,102,181,9,248,156,29,149,41,73,2,34,88,183,198,106,254,34,124,19,150,32,99,71,253,14,190,121,107,200,168,38,114,205,153,112,139,204,16,149,101,168,127,70,40,156,157,78,179,113,220,4,46,194,124,96,187,139,83,36,28,169,50,209,88,176,134,217,219,55,18,186,165,170,11,175,60,216,24,132,95,218,101,75,194,66,64,184,1,56,29,86,92,86,243,122,204,124,185,21,219,37,111,68,82,178,41,69,127,186,121,223,219,84,41,169,105,54,165,5,128,102,12,67,130,217,46,97,233,254,216,57,121,145,39,46,34,136,82,175,114,153,215,16,119,138,116,45,137,136,230,59,132,221,97,0,150,250,153,211,18,141,254,212,157,9,45,217,191,16,24,133,130,194,151,189,230,92,187,55,12,247,187,8,115,13,29,222,207,59,92,230,24,146,39,165,2,54,188,107,162,190,178,185,22,188,187,172,42,164,239,225,92,55,26,237,230,59,0,75,13,33,47,250,12,161,72,4,185,159,244,163,208,129,102,176,239,178,99,211,97,92,241,234,19,85,70,42,189,55,130,151,119,38,50,126,239,231,40,153,124,51,220,63,234,208,163,211,170,63,37,231,40,152,183,204,90,227,246,208,8,196,85,209,243,92,102,174,199,27,110,145,27,1,158,35,176,107,152,163,227,75,21,184,120,238,57,155,201,3,194,165,57,117,211,136,236,17,128,98,177,93,111,46,94,137,155,5,70,101,212,42,190,79,218,62,143,123,151,171,59,185,175,9,185,245,254,235,130,177,69,252,61,157,29,229,105,128,229,192,180,37,158,214,254,13,129,64,53,209,247,56,140,241,97,250,119,174,250,204,68,97,184,208,29,20,117,25,12,105,234,224,76,223,115,197,177,7,235,247,19,42,20,85,78,15,81,181,192,153,4,160,176,82,106,67,212,194,132,240,190,45,126,79,192,122,42,28,239,165,14,139,14,152,62,129,78,48,66,45,207,97,240,165,178,129,234,169,234,59,12,218,46,249,54,76,20,225,254,11,128,237,242,61,101,16,36,207,202,13,244,205,77,104,204,51,50,1,5,95,211,151,110,251,255,185,191,151,167,102,140,98,163,129,27,38,60,101,197,176,252,212,232,136,208,157,118,51,83,111,209,188,223,78,130,47,24,91,236,170,159,121,55,3,202,0,155,212,180,173,74,37,161,201,91,108,166,174,27,239,60,20,65,158,225,185,85,89,127,76,244,27,86,150,160,201,13,106,79,143,68,200,236,55,107,243,76,149,215,188,118,183,198,159,26,140,136,153,211,173,159,16,57,139,31,93,149,70,6,141,53,112,164,6,184,239,106,159,222,67,158,26,121,136,223,39,46,140,67,170,202,95,88,179,214,186,212,140,8,12,94,34,77,226,17,17,162,210,225,20,151,177,74,9,100,126,170,73,142,33,144,154,131,151,205,235,28,118,190,6,137,98,50,237,7,94,230,246,133,250,179,160,199,89,103,9,203,111,37,216,185,171,40,117,6,107,87,133,165,172,22,140,220,186,41,97,187,57,196,102,220,15,169,194,254,170,33,237,69,78,127,4,30,119,51,251,153,50,179,106,153,232,131,96,100,243,32,78,78,223,191,150,158,39,30,201,43,12,220,233,103,223,247,156,210,213,52,75,203,102,114,46,35,81,55,175,89,207,53,66,198,247,164,132,51,64,124,120,125,108,35,3,184,185,202,162,122,93,58,198,11,176,146,221,62,6,92,250,135,230,38,135,125,76,89,22,140,243,110,14,212,252,94,85,234,86,142,168,158,28,94,124,183,180,213,174,80,170,142,88,83,48,201,169,249,109,156,83,4,161,186,46,235,85,83,86,244,7,52,58,188,19,124,117,35,105,13,185,191,47,252,142,77,194,147,27,235,193,126,138,65,32,134,118,24,227,33,219,142,48,59,235,147,8,183,94,74,184,233,4,78,44,55,20,167,190,216,145,187,105,253,135,93,68,15,204,76,81,176,255,140,229,106,248,29,154,109,79,247,240,181,62,181,2,28,187,26,136,254,180,92,158,140,81,194,11,245,237,48,28,57,112,87,48,233,185,13,251,113,29,199,152,222,226,254,232,119,199,120,251,113,224,226,89,162,215,74,115,227,118,145,197,176,156,161,226,233,79,170,203,163,113,106,144,108,25,85,163,91,129,143,75,216,56,51,156,13,106,116,79,121,79,152,139,128,156,169,174,94,228,172,49,115,235,134,42,145,67,107,214,122,8,49,156,210,218,178,151,67,247,169,0,56,164,44,222,132,125,193,90,153,10,15,29,69,159,229,98,193,181,138,65,215,14,65,89,116,209,247,174,22,72,27,141,214,94,36,169,203,34,123,25,192,248,196,238,148,225,225,253,59,44,43,96,2,26,21,96,123,202,184,253,55,162,172,81,29,95,172,11,133,235,129,224,183,94,71,85,29,23,65,246,242,222,224,109,136,62,63,145,107,248,167,160,195,242,204,135,237,253,107,53,91,77,34,207,186,102,102,84,28,14,44,194,39,232,156,245,132,232,76,102,63,206,240,49,132,118,211,1,70,75,30,42,3,149,207,174,223,160,227,64,221,207,62,64,74,186,97,163,201,85,231,33,84,76,132,47,66,189,73,137,21,77,184,234,168,231,171,247,76,32,229,1,138,186,116,5,60,65,8,57,133,57,165,125,190,51,105,242,89,1,141,234,53,168,34,89,88,55,63,52,10,226,116,30,115,175,214,74,234,133,248,48,242,17,47,155,75,131,130,124,207,192,199,156,142,142,119,122,3,15,49,119,155,82,80,171,180,19,29,133,31,247,222,9,245,206,244,22,69,12,85,112,250,23,97,212,191,32,152,5,115,206,31,197,19,250,138,219,130,3,84,216,78,11,80,213,13,161,199,128,136,64,7,53,223,221,247,108,10,139,128,47,36,225,149,145,94,106,22,86,14,62,13,43,181,226,188,243,228,218,231,144,137,51,46,13,237,21,72,193,233,132,28,220,20,8,4,122,72,237,253,246,222,239,176,0,105,79,66,248,100,211,232,18,217,109,127,11,57,83,34,123,20,60,137,153,193,152,195,96,127,130,205,193,250,201,146,44,174,91,40,108,105,104,231,248,136,114,61,136,124,241,31,128,186,165,230,218,248,76,54,35,51,13,80,241,46,59,34,214,111,253,168,149,252,124,4,81,171,131,110,58,165,172,223,166,5,45,240,154,11,195,26,117,137,238,192,41,98,219,74,113,235,25,234,46,9,144,57,228,196,138,122,230,73,229,42,31,24,18,166,217,131,24,95,177,251,18,240,249,10,235,122,112,16,73,162,6,70,8,231,108,54,87,216,194,174,60,128,244,234,190,212,213,146,128,244,187,133,74,29,128,195,60,234,120,57,168,116,97,234,156,164,173,42,225,70,177,38,184,43,121,148,186,19,207,224,19,253,214,102,184,227,77,205,223,63,242,184,142,75,134,48,96,96,243,151,83,50,87,123,186,147,177,176,62,113,237,99,50,108,201,126,185,218,219,219,241,171,55,44,28,194,49,254,72,63,140,63,178,112,216,15,3,183,189,172,230,154,116,254,246,200,73,82,76,41,15,168,132,147,25,115,46,90,151,15,180,193,60,237,178,105,74,47,191,86,59,221,105,248,98,26,140,49,149,76,146,83,229,173,71,134,78,113,171,186,136,69,240,102,228,167,251,86,198,107,167,79,180,215,210,44,58,98,143,79,188,44,133,107,54,248,165,231,104,149,127,120,62,61,159,252,239,41,101,177,140,108,77,90,49,230,151,125,115,153,80,213,191,17,98,59,202,149,108,239,233,23,177,26,245,216,97,198,111,31,75,248,67,177,55,207,157,212,233,20,69,111,167,232,80,21,144,9,32,199,43,200,181,141,195,9,143,237,154,121,175,158,247,124,39,117,184,48,30,51,103,4,19,16,28,84,98,72,251,204,19,32,194,90,236,170,52,202,181,96,92,120,59,184,47,169,66,177,66,217,150,2,50,182,17,7,131,32,76,227,116,70,174,42,90,163,89,35,33,148,41,240,228,253,31,107,201,210,198,152,13,86,70,112,248,225,121,155,252,134,99,239,2,8,98,108,44,76,227,160,213,104,141,16,130,205,118,253,123,220,48,200,187,80,35,114,62,45,188,107,29,79,220,169,244,147,158,70,102,122,231,232,149,243,55,230,115,28,185,83,39,179,237,221,41,170,240,44,143,39,216,163,87,213,39,157,118,225,99,80,190,57,171,200,20,2,7,166,112,211,127,0,69,167,84,159,62,190,37,46,1,194,192,152,94,188,50,203,38,220,128,2,108,156,32,255,174,254,89,135,44,97,26,237,37,203,70,32,238,3,218,163,213,145,32,244,50,67,233,217,30,131,135,205,0,46,29,143,192,99,180,144,34,96,7,74,212,164,44,215,190,88,252,138,84,97,50,251,203,44,252,175,247,178,155,79,180,28,8,80,184,205,211,9,119,150,32,91,150,4,102,212,89,217,117,71,241,163,146,90,113,142,34,228,139,182,236,101,97,47,152,88,91,161,47,37,246,4,92,89,174,210,15,82,44,118,249,82,198,192,155,172,220,91,168,190,233,35,204,84,24,113,139,102,112,42,108,124,19,27,148,60,159,78,38,239,90,234,5,193,172,28,58,20,182,11,43,162,123,82,184,178,167,19,172,101,106,3,69,146,204,136,46,70,35,133,166,103,74,245,222,246,76,109,232,173,160,36,50,39,140,112,227,59,10,18,127,30,232,161,113,146,233,102,248,171,205,245,154,98,101,53,109,65,36,82,31,241,200,111,216,27,255,10,48,237,213,82,221,17,250,248,215,19,150,56,175,233,19,230,30,233,199,3,100,121,176,189,175,63,20,231,105,113,121,51,88,188,231,109,177,58,34,9,199,121,226,157,183,76,219,41,224,204,61,144,124,88,115,7,214,74,179,178,42,119,144,76,98,58,171,185,134,98,123,177,87,100,213,183,165,147,22,29,151,19,74,146,102,107,158,201,189,0,79,185,36,105,84,104,73,152,103,132,228,196,39,102,113,158,255,56,212,198,37,172,139,31,238,98,184,182,42,69,108,194,245,23,205,45,21,76,115,162,181,174,59,213,233,59,240,184,32,212,226,199,126,11,205,232,217,187,51,197,98,94,117,94,105,152,41,48,22,181,8,146,134,207,30,237,255,240,248,183,191,187,67,210,16,185,191,54,193,2,218,22,99,176,191,233,78,247,165,4,231,131,62,37,109,244,76,194,155,129,212,66,0,101,223,162,211,13,80,169,217,16,68,4,155,216,61,35,76,162,144,217,34,209,73,249,250,253,186,140,124,41,237,124,22,168,97,40,95,47,38,188,204,216,150,184,229,185,174,113,3,154,126,238,50,165,170,12,27,209,53,157,76,118,81,252,10,140,31,103,160,43,171,6,65,205,225,154,85,121,76,216,228,29,241,184,200,160,225,86,4,199,137,80,222,199,30,9,163,177,222,131,91,24,3,147,148,250,20,157,246,166,73,41,246,240,159,85,53,172,227,255,239,211,188,78,85,210,198,63,175,149,47,251,126,139,167,245,143,5,212,41,111,52,133,173,37,114,122,63,214,212,6,98,213,169,140,241,226,233,95,47,169,91,89,117,116,228,30,78,123,163,137,11,19,142,70,121,166,215,141,20,57,100,202,75,131,150,222,136,204,79,199,205,220,46,9,129,92,116,55,148,224,138,82,32,255,250,251,59,239,99,130,13,77,106,233,191,37,70,164,141,160,195,95,192,54,39,178,189,46,17,135,160,255,198,62,249,69,57,5,74,22,165,134,209,143,179,8,28,219,212,141,148,242,233,231,171,234,72,186,111,252,84,120,130,253,206,225,145,123,88,19,194,150,24,168,247,191,92,162,203,56,94,55,72,199,142,76,50,37,253,13,142,159,201,100,153,149,243,217,240,192,204,254,66,239,13,23,161,166,210,210,120,35,7,141,179,109,83,57,146,163,16,195,195,129,214,39,34,155,158,29,244,128,143,18,233,121,150,87,80,227,145,22,207,133,15,10,172,79,48,176,209,68,66,116,22,167,251,162,90,108,98,148,98,84,46,164,185,106,48,68,247,163,112,24,15,78,105,58,173,251,63,10,252,91,83,158,57,178,63,21,40,113,231,82,251,191,134,27,71,131,203,150,222,121,48,211,181,0,62,91,119,123,77,252,183,63,204,142,239,211,87,244,129,213,2,81,221,210,104,182,252,35,116,91,198,172,132,76,148,89,3,74,8,96,232,19,70,18,232,128,18,145,133,229,23,13,93,175,174,68,105,55,192,81,168,1,142,132,193,37,99,188,243,51,14,26,6,195,29,149,159,115,77,169,235,22,66,101,37,224,43,146,152,141,191,222,67,12,74,51,124,129,141,11,37,97,10,50,79,112,123,54,180,89,156,10,237,145,90,99,35,116,84,163,249,196,70,103,144,16,14,13,233,42,5,213,163,203,205,92,6,212,210,195,46,141,24,15,1,215,71,30,31,0,4,24,15,93,217,35,228,173,104,78,117,69,140,243,168,119,62,223,200,171,123,57,184,88,64,53,21,153,201,0,115,146,22,119,84,228,16,189,124,213,148,92,15,178,58,83,69,87,213,137,150,254,92,197,211,157,193,255,150,115,3,222,48,64,41,28,208,245,211,29,135,30,54,205,250,93,94,57,155,196,37,151,90,109,165,11,249,203,106,37,64,103,100,206,108,40,181,36,238,104,208,241,13,26,75,32,133,101,47,132,226,199,174,3,139,186,102,206,19,21,6,166,44,184,63,7,255,61,155,90,233,60,161,86,176,23,97,194,237,176,234,251,116,25,226,11,145,130,13,179,158,222,252,26,235,132,202,117,229,195,232,158,52,183,96,47,219,235,210,51,146,103,15,241,22,194,84,73,169,183,142,81,87,203,6,251,105,254,2,56,164,156,137,219,71,205,59,144,217,70,38,73,57,73,70,131,114,20,249,181,50,184,200,127,251,28,30,92,166,20,252,156,141,128,223,214,176,136,154,210,238,245,131,123,1,114,106,160,197,74,57,4,101,162,185,66,93,219,192,225,68,181,231,74,140,180,121,162,114,142,129,187,73,66,192,218,128,28,39,134,251,0,243,48,55,112,205,204,80,144,149,109,100,247,179,224,228,198,89,225,7,131,170,203,32,130,21,23,249,122,134,208,160,239,23,10,91,107,175,27,56,59,104,18,71,209,245,4,165,227,203,178,69,1,114,130,119,193,171,64,18,182,174,155,16,84,193,55,150,153,90,251,6,94,161,253,223,200,143,16,162,175,93,211,88,243,61,118,144,204,158,163,68,183,243,85,64,42,52,155,32,39,213,93,165,239,188,8,152,93,228,136,71,213,103,158,57,252,54,203,34,230,180,127,56,46,22,5,220,190,103,131,16,64,135,114,68,112,125,205,54,108,113,157,5,31,108,20,138,80,149,170,6,114,65,223,21,159,246,115,158,118,220,203,106,20,66,204,213,59,225,109,136,122,206,137,104,126,66,24,195,83,223,112,36,241,154,219,254,255,248,77,142,202,95,86,171,11,42,188,7,245,217,138,49,224,34,61,121,28,57,25,3,70,9,40,108,107,108,211,160,206,154,77,59,153,161,172,200,23,84,154,131,94,122,115,145,19,13,234,127,86,154,80,149,41,50,98,186,251,36,10,53,159,223,103,104,248,67,154,136,228,46,83,243,36,33,221,157,116,83,109,54,89,171,46,252,120,86,50,220,23,252,185,68,192,125,37,223,233,232,110,16,135,71,175,199,37,75,162,17,48,41,32,39,131,59,145,161,20,26,149,216,99,1,188,240,87,189,8,24,224,227,175,207,156,151,37,76,105,62,202,86,172,9,208,0,186,72,213,78,103,254,132,192,92,113,242,42,224,245,111,181,206,107,130,182,212,63,185,27,28,41,112,220,209,148,172,7,140,225,168,124,67,203,73,76,139,41,226,87,30,125,197,216,76,36,160,168,194,202,181,254,134,0,148,187,242,94,239,72,9,21,148,168,92,66,161,144,73,37,106,39,176,127,116,44,183,89,77,47,138,171,10,169,117,147,107,92,29,184,69,82,220,13,130,34,214,197,214,6,152,46,180,228,77,211,162,47,149,169,145,56,196,174,84,97,93,246,216,30,34,211,137,93,8,161,64,73,106,220,60,107,201,86,86,124,51,9,66,244,168,8,22,125,147,200,68,23,23,247,75,139,87,52,54,5,53,175,14,218,127,126,196,104,220,88,75,122,52,99,226,111,88,137,95,199,196,6,2,87,182,200,67,133,205,210,73,174,53,64,12,134,84,182,73,199,7,65,88,7,24,83,187,31,81,35,236,229,37,177,78,42,143,233,94,241,133,195,255,185,7,218,41,43,231,129,3,23,175,147,37,26,188,70,161,146,126,24,12,38,104,96,209,143,227,254,9,198,24,192,4,227,59,174,32,240,251,5,34,127,186,184,83,193,62,41,187,33,39,239,28,16,118,164,36,171,230,136,212,122,52,86,39,165,85,61,117,145,179,83,209,229,95,227,85,170,136,187,59,115,217,179,60,48,21,67,116,58,14,145,89,89,35,229,5,152,217,138,26,10,189,186,35,83,210,174,165,179,87,168,247,177,43,213,204,247,37,109,164,15,182,108,253,170,140,83,214,151,0,211,81,132,64,43,30,248,18,149,11,44,248,98,107,216,117,38,96,167,82,124,152,140,191,51,40,145,207,31,45,189,144,120,151,236,172,94,196,233,80,172,227,217,187,197,174,24,108,153,189,212,51,44,156,203,149,74,222,95,240,202,168,235,255,91,215,29,201,254,8,156,120,134,162,218,172,153,51,254,189,4,238,93,65,227,158,247,6,74,254,126,91,58,204,84,167,188,223,91,180,79,147,62,150,135,231,158,186,185,126,91,13,115,56,108,78,17,205,175,102,47,20,157,73,175,89,225,242,141,119,215,191,236,127,186,252,109,87,164,233,22,213,98,137,134,97,78,12,13,150,30,160,164,149,154,108,167,156,104,67,228,187,152,143,135,114,154,47,7,21,89,131,179,34,253,135,40,109,220,0,127,213,82,85,64,161,1,113,242,240,66,56,78,225,32,59,26,177,12,19,79,6,212,120,217,177,7,187,76,85,122,133,9,219,81,118,109,201,21,119,47,122,30,190,208,241,78,63,16,91,45,44,253,13,228,18,228,187,96,222,132,166,77,100,226,124,234,61,59,174,40,117,26,163,5,65,107,1,95,18,170,126,100,95,216,113,98,15,186,246,133,3,205,221,228,159,206,212,201,240,175,113,198,72,187,233,28,104,253,239,168,246,139,120,149,143,34,146,39,220,145,216,114,243,109,219,151,117,75,33,162,197,181,62,19,128,118,215,96,101,54,68,109,7,171,133,54,145,1,15,56,224,58,123,172,196,221,3,133,158,85,120,21,246,153,166,1,17,66,48,223,247,230,95,15,223,253,250,109,197,6,190,76,117,7,245,185,143,129,188,191,215,198,20,90,194,172,250,78,233,102,182,120,92,116,208,65,80,84,235,77,57,207,221,127,16,225,96,218,22,104,216,138,195,220,101,236,3,109,87,42,198,95,96,164,202,48,107,45,17,107,246,2,243,229,149,152,83,101,228,91,80,183,254,119,138,201,64,197,135,212,15,171,151,44,69,249,208,188,57,253,250,157,63,153,226,131,155,3,224,56,103,144,28,200,229,192,71,131,21,129,219,235,31,205,144,191,146,253,77,67,78,216,241,242,228,244,174,123,254,65,212,26,35,218,100,1,28,145,247,37,254,116,206,212,40,200,241,209,30,238,181,165,198,211,144,87,158,142,226,70,232,172,134,42,41,121,222,108,17,68,45,47,16,56,26,77,188,99,188,115,118,252,245,11,51,25,44,27,128,31,32,221,54,158,109,102,53,155,4,245,73,26,234,174,198,111,64,52,171,213,56,173,114,145,152,204,191,140,179,22,93,211,35,243,221,136,103,201,155,0,41,110,183,62,30,176,252,190,108,47,23,203,166,160,173,17,124,11,189,244,44,4,13,133,74,224,19,240,200,254,27,57,180,193,89,67,10,147,117,127,169,109,96,98,8,10,21,26,37,181,81,247,202,60,172,58,139,237,116,143,140,46,52,176,49,71,231,243,80,161,14,219,152,25,62,178,232,150,162,47,124,122,155,221,61,212,160,224,158,136,39,24,24,159,93,108,6,145,49,245,189,95,22,153,45,100,83,225,12,97,201,53,242,6,2,23,210,62,108,106,189,178,189,42,64,247,93,171,233,157,196,159,103,239,240,111,60,164,43,151,83,198,183,204,37,185,207,113,120,130,103,10,4,90,144,149,54,51,128,82,233,108,119,172,85,82,79,203,25,184,22,113,202,100,46,34,121,95,234,102,43,243,242,211,223,171,133,152,188,18,134,67,47,2,94,11,17,249,254,0,115,150,132,37,136,76,84,42,91,153,219,138,4,233,91,164,1,243,162,12,134,75,244,55,138,40,252,182,74,245,239,39,45,157,106,56,118,130,15,190,210,138,155,237,239,57,182,77,69,190,113,237,27,178,173,214,149,95,133,12,106,208,89,63,129,174,51,58,43,142,103,103,138,109,123,39,101,45,171,1,233,54,34,208,63,121,151,241,39,0,207,133,172,100,150,134,5,196,133,184,171,253,201,139,186,75,242,123,53,174,38,249,95,72,254,64,108,209,147,37,177,166,69,3,178,95,255,47,41,195,232,6,73,119,89,203,225,150,80,125,183,56,28,82,112,89,167,237,204,73,139,208,233,7,168,90,35,244,133,50,216,254,240,80,227,187,102,135,27,213,192,201,21,175,236,199,100,103,36,247,192,4,133,40,125,16,111,25,177,101,37,180,170,49,230,106,169,123,73,58,231,60,106,230,145,116,211,215,134,199,90,18,243,210,29,225,79,224,248,108,204,147,215,73,244,75,154,145,95,137,151,193,154,146,43,242,175,5,62,42,113,9,57,70,59,133,75,165,250,154,186,143,167,22,47,252,137,102,87,181,104,147,207,195,205,88,18,48,209,126,182,35,179,10,30,175,25,163,6,202,85,185,99,52,208,20,19,242,169,14,253,227,198,85,129,68,11,99,112,59,79,142,105,188,254,123,148,88,153,70,89,84,106,236,34,181,241,51,194,138,62,14,134,245,151,117,235,135,10,139,140,204,146,196,96,242,114,217,131,102,142,129,65,132,108,64,29,42,233,238,33,19,249,17,222,195,125,158,124,202,110,18,183,150,111,199,70,127,8,180,135,203,33,143,230,228,90,44,43,118,241,57,168,162,89,150,106,102,32,60,250,93,143,196,239,12,214,171,73,180,196,199,210,115,112,192,13,9,123,222,213,148,91,19,101,236,101,30,146,43,164,10,156,101,112,151,65,89,151,245,154,56,37,194,99,153,35,80,3,93,62,246,6,68,42,34,155,207,230,215,121,37,213,153,36,165,136,123,181,144,31,215,138,161,118,151,196,108,131,138,93,13,158,182,138,197,184,0,44,139,70,0,204,15,179,245,235,111,229,61,119,1,248,135,70,169,50,116,69,16,223,77,223,248,176,81,63,205,104,150,100,178,216,215,7,243,251,58,16,117,59,213,117,122,156,183,0,72,126,132,100,86,92,240,106,174,220,88,51,75,166,111,176,139,229,215,30,173,166,246,249,201,187,24,250,69,150,214,224,9,17,218,53,173,213,254,11,60,19,32,202,124,40,131,51,99,223,226,217,190,252,29,14,39,73,199,37,180,254,114,46,169,46,109,205,172,86,62,198,113,209,186,149,211,122,42,239,238,71,133,33,39,217,86,131,68,199,243,26,0,143,97,215,140,217,34,11,55,192,118,66,69,203,200,128,171,40,250,94,127,204,76,168,232,153,226,37,150,4,8,22,177,75,64,204,39,19,45,127,173,174,14,222,159,184,66,88,61,250,133,231,114,166,164,33,157,77,203,31,222,189,111,131,178,107,117,10,165,203,18,211,117,188,134,254,238,158,123,143,231,245,189,89,21,88,66,169,241,24,26,210,108,105,249,56,37,196,36,26,110,237,31,34,198,114,72,218,133,14,40,38,0,26,218,130,56,146,228,86,253,43,36,112,162,58,232,178,162,105,114,186,74,187,229,215,195,101,241,14,24,95,246,248,101,255,68,164,79,41,18,245,65,11,228,167,132,169,52,170,196,91,52,224,204,230,105,193,231,254,49,143,85,42,221,140,233,18,131,116,86,127,103,136,113,15,23,95,39,90,226,59,168,56,73,43,227,171,60,251,5,66,24,207,129,225,168,127,243,190,108,173,215,76,110,107,75,120,242,147,252,217,57,234,116,1,133,221,90,162,174,126,61,236,200,53,105,71,155,217,56,85,6,214,13,60,119,234,225,200,186,152,215,237,225,105,85,252,240,252,38,75,220,200,6,243,144,34,127,161,14,197,107,63,75,235,195,72,44,27,244,129,243,201,59,241,45,173,62,200,145,232,76,142,208,183,15,77,119,157,26,157,170,159,104,206,13,248,132,68,229,234,196,252,168,229,154,203,44,177,54,200,235,132,93,52,10,196,60,152,226,220,27,98,85,215,82,144,161,12,76,202,47,71,231,225,223,105,35,201,195,174,188,10,168,199,141,255,108,74,166,226,33,4,203,54,202,178,27,127,250,86,181,225,246,70,219,65,173,49,214,202,71,22,67,184,54,90,182,251,202,40,14,235,63,201,190,75,65,15,33,62,81,56,157,55,187,67,3,223,5,188,105,211,72,202,95,229,207,20,1,219,121,116,56,5,116,227,97,48,200,192,252,86,238,56,125,89,89,89,100,76,5,180,81,31,33,111,202,211,182,51,25,81,28,239,153,125,85,67,149,136,118,157,65,84,65,43,74,86,81,238,45,7,227,222,145,234,95,152,157,225,22,53,47,59,189,252,16,40,26,171,155,247,98,73,206,206,218,9,241,152,213,3,15,107,123,100,86,78,2,200,194,8,78,101,235,150,113,69,232,13,102,131,200,41,240,126,186,238,184,20,62,218,235,221,116,53,44,20,219,104,254,112,139,81,119,100,253,105,53,62,247,159,166,75,128,64,51,7,193,108,154,115,34,146,127,75,102,17,112,81,35,33,255,104,228,11,97,24,252,219,214,122,235,2,28,34,128,252,220,126,248,87,48,200,149,102,191,135,59,48,111,142,210,22,87,41,25,209,90,114,67,98,234,128,53,45,198,155,116,161,66,14,216,226,63,200,18,7,20,213,60,221,77,128,48,20,142,208,197,61,210,161,90,77,80,146,220,80,168,29,93,171,234,195,182,134,136,225,120,206,94,147,141,52,199,5,155,74,143,12,252,50,79,254,135,78,145,222,143,150,128,28,137,206,79,88,83,195,0,213,182,223,225,201,191,235,235,39,175,202,211,139,11,109,8,255,251,237,232,33,37,250,169,184,42,115,205,55,220,211,160,190,225,201,208,87,227,181,15,92,123,111,172,104,71,23,236,206,214,177,119,77,128,149,238,102,224,147,48,143,82,158,83,179,110,112,12,75,86,190,48,208,14,156,92,140,55,64,14,23,106,204,140,48,97,72,62,247,14,217,121,31,224,171,233,69,177,129,185,71,17,87,96,138,78,19,178,198,229,37,235,51,51,208,149,100,111,39,54,197,126,215,245,125,0,18,64,157,246,4,183,62,21,82,209,182,193,74,163,255,99,143,38,119,30,171,116,62,129,241,64,167,205,128,48,19,141,208,126,96,231,17,94,11,123,106,132,252,127,95,4,217,84,100,231,9,56,144,178,55,92,107,154,194,164,113,19,93,117,152,188,49,241,135,95,131,177,63,10,247,179,86,47,153,63,125,70,239,205,3,48,196,135,152,123,146,5,229,21,112,255,72,4,180,42,148,238,234,211,163,111,223,49,176,36,101,182,121,145,65,242,151,27,181,100,235,212,127,238,78,165,2,36,188,117,89,217,137,39,32,249,156,72,106,48,65,177,35,119,166,109,125,93,15,74,133,194,177,8,208,79,4,23,216,37,3,20,67,12,40,52,11,160,213,96,177,234,40,240,251,19,126,81,186,153,249,204,11,91,78,70,238,38,31,243,13,156,49,165,95,148,218,155,179,139,30,216,15,153,27,164,59,189,173,159,141,146,16,21,167,183,161,203,82,140,66,150,182,16,73,40,176,102,55,118,132,173,249,137,117,137,145,90,53,86,164,24,152,171,14,64,192,181,253,238,22,204,59,115,228,173,155,232,15,108,250,14,135,190,177,25,54,114,152,83,38,132,125,185,243,134,112,168,170,99,100,155,125,107,46,165,146,10,12,243,170,39,155,195,220,140,129,9,27,178,166,144,112,200,134,3,146,228,27,60,217,251,147,93,72,56,196,158,217,177,53,113,146,111,93,172,7,71,165,196,105,120,164,255,79,158,235,183,45,61,139,128,87,87,24,202,89,236,50,129,135,90,217,225,115,211,102,32,22,124,87,167,76,209,47,193,179,5,176,1,172,115,53,235,4,198,69,17,146,1,156,60,169,171,3,154,137,1,8,160,180,39,33,145,194,221,167,74,225,147,22,226,175,161,190,155,99,104,36,234,28,206,255,153,106,146,140,248,208,160,159,129,189,81,79,151,34,57,191,19,60,238,132,173,126,112,102,40,167,236,248,169,15,165,62,167,248,117,241,242,52,190,179,82,62,174,253,135,166,242,116,101,164,25,44,212,205,199,182,51,26,85,54,11,16,243,103,183,145,84,222,115,193,84,191,14,243,49,214,76,187,20,39,29,243,173,156,181,219,109,64,24,75,52,179,28,160,231,99,85,33,44,165,96,91,1,116,151,203,247,43,74,128,179,172,198,31,77,89,11,160,120,13,159,140,72,217,110,79,78,206,233,178,98,50,152,74,216,73,133,249,217,70,75,56,129,241,107,234,100,37,103,60,16,188,2,190,11,70,104,226,153,93,247,153,143,161,19,20,220,168,207,59,231,145,117,83,136,104,18,107,25,84,26,105,116,169,98,24,122,32,236,228,193,206,223,235,29,238,49,143,225,2,196,58,61,127,140,102,14,140,100,86,158,130,245,106,213,21,195,130,77,170,38,87,189,28,239,43,9,141,221,172,71,101,23,117,196,97,176,152,245,228,11,197,252,84,206,70,36,202,196,205,27,80,137,39,25,75,180,73,162,224,150,97,44,115,24,151,153,239,190,250,64,81,124,193,49,199,158,225,239,216,251,150,194,11,43,136,66,171,93,122,163,101,50,248,76,30,251,201,114,80,75,69,109,212,155,11,141,217,118,95,15,127,174,149,147,216,251,178,89,253,92,51,157,16,128,60,144,26,219,47,131,125,182,76,241,164,209,6,26,7,92,85,220,173,245,230,208,98,209,124,70,173,192,190,132,55,211,201,186,183,60,108,73,202,134,11,25,98,22,219,173,173,140,39,222,243,91,17,177,81,168,144,244,94,105,34,211,227,16,134,9,254,20,51,4,182,243,203,82,63,238,89,246,230,147,185,200,52,129,113,141,167,177,99,18,247,119,52,84,13,203,187,89,98,35,178,30,13,149,205,77,136,197,164,183,202,225,132,158,34,253,166,180,170,81,56,53,16,116,34,149,120,212,66,17,226,5,193,175,148,81,251,230,23,177,141,43,79,103,153,84,172,51,44,242,34,237,188,74,225,118,144,129,40,56,96,157,254,134,231,14,209,110,23,26,41,253,29,33,247,80,149,196,100,34,23,183,198,124,246,191,174,56,254,31,119,127,229,154,236,190,38,98,101,91,126,182,201,156,27,210,62,101,17,18,95,17,62,112,173,218,95,8,203,29,169,3,23,137,111,219,234,54,156,50,148,31,227,60,56,205,74,105,149,45,57,162,39,83,232,38,150,169,204,161,15,212,82,220,124,196,127,1,123,135,186,208,13,210,224,127,223,143,131,107,123,201,10,21,58,99,135,64,212,81,242,174,16,20,198,65,72,42,58,79,59,206,26,52,133,57,223,232,6,119,87,13,47,214,82,42,153,242,77,203,163,205,22,188,0,129,78,179,114,86,63,119,183,248,180,74,200,49,174,239,118,170,130,129,69,61,251,182,192,219,239,214,192,255,58,247,26,49,105,232,74,79,103,145,214,114,231,134,233,230,182,242,244,118,246,117,136,107,207,19,107,184,247,251,123,157,189,96,101,189,162,223,179,99,10,86,165,128,163,231,16,244,57,68,233,20,250,104,28,166,38,49,110,177,66,17,127,187,199,42,122,137,238,193,107,95,247,227,189,113,10,75,176,213,70,136,141,144,164,87,37,42,23,127,141,164,183,78,139,218,128,235,216,244,18,237,172,200,24,113,21,112,117,16,59,41,136,9,155,210,169,170,75,221,91,65,24,147,102,178,110,106,220,193,124,222,37,240,191,119,132,54,85,182,115,221,35,234,48,168,174,45,235,227,126,189,190,94,228,240,101,211,112,91,127,57,151,48,255,55,129,17,139,254,252,80,114,75,182,22,51,188,91,109,69,192,230,36,179,138,232,162,3,131,1,137,52,56,241,139,77,224,236,177,175,210,192,80,187,135,105,224,116,81,229,132,151,223,232,67,207,191,76,55,255,26,58,42,239,48,161,0,251,40,166,214,231,173,40,122,99,165,8,170,84,14,152,38,0,60,172,198,70,127,95,75,16,127,6,6,164,64,141,172,238,59,222,131,224,43,38,141,127,96,100,62,2,30,34,180,54,230,3,150,5,231,193,31,96,61,201,7,121,144,136,49,68,114,1,180,193,165,67,117,98,92,230,45,153,167,120,227,39,220,201,40,218,176,242,79,255,176,197,84,44,219,188,24,123,109,252,180,10,54,56,205,152,158,23,34,226,122,114,118,86,190,135,145,210,139,53,111,80,254,12,33,99,114,50,69,174,102,63,40,134,203,163,241,201,210,132,197,30,194,21,41,67,111,169,59,137,176,140,87,223,35,219,148,41,17,47,87,132,177,195,184,155,62,44,57,51,61,166,176,0,78,17,239,248,132,24,90,111,0,114,11,243,116,156,217,62,172,237,169,184,102,49,203,132,170,173,228,19,92,247,110,129,213,51,246,166,189,117,14,122,133,32,168,49,250,110,109,130,233,47,207,247,73,245,53,4,163,18,37,68,143,96,159,144,46,41,170,94,167,114,150,192,69,209,251,219,13,111,213,186,98,240,94,100,151,249,137,215,40,31,202,233,102,233,87,154,45,180,231,125,239,156,180,218,112,223,97,62,42,141,65,252,126,67,80,247,250,233,208,232,35,192,160,163,194,226,126,10,45,236,6,185,108,216,204,37,163,11,79,111,48,215,146,155,158,134,141,203,55,89,61,222,33,78,82,125,74,58,124,11,39,39,25,125,19,251,109,165,69,192,6,62,4,243,172,60,180,97,171,114,245,37,98,216,173,83,172,42,223,203,123,98,129,233,163,55,50,102,117,207,223,131,8,155,151,246,17,163,194,153,249,69,72,100,93,139,51,97,70,143,174,24,21,44,73,67,97,203,26,232,224,113,226,185,74,242,203,51,164,179,209,188,168,1,102,93,74,120,214,135,191,193,209,7,112,218,199,145,10,92,23,239,226,242,205,187,159,126,171,125,35,158,53,118,74,19,183,224,31,116,118,13,32,211,205,92,131,123,48,181,32,124,7,233,247,254,24,251,109,189,0,184,187,80,73,194,94,100,239,81,170,145,20,235,132,230,56,141,90,22,151,198,88,153,66,134,20,94,237,62,58,110,218,255,50,111,198,109,211,202,21,39,7,30,238,147,85,35,154,58,236,112,221,70,102,211,120,115,74,109,188,70,229,214,191,122,134,120,195,231,217,122,35,113,9,110,154,50,82,32,35,111,159,191,205,52,223,124,250,77,32,228,68,131,215,255,245,107,10,80,105,104,31,4,173,207,219,31,219,171,182,182,254,211,181,183,202,185,238,165,167,38,248,72,193,90,249,154,165,80,64,209,68,160,49,226,93,135,143,48,97,211,47,187,29,120,160,203,115,39,87,245,227,220,244,5,60,57,251,126,42,117,244,81,69,98,77,242,210,249,188,19,130,253,198,56,95,174,249,187,185,215,132,16,226,25,29,180,25,54,143,69,121,134,79,117,180,218,210,211,236,58,207,231,69,104,95,149,166,212,59,105,131,68,83,21,233,177,143,135,83,237,99,3,20,58,123,234,249,128,199,117,238,163,124,52,215,100,124,76,146,61,253,192,135,196,87,201,115,149,98,141,214,85,252,207,188,13,34,208,166,93,132,22,39,44,115,121,203,93,78,137,69,196,253,197,120,148,36,21,208,5,95,43,5,122,145,41,160,12,117,201,143,36,62,133,73,185,73,185,155,194,182,166,248,96,33,9,112,7,42,39,42,203,253,23,196,161,187,66,234,58,217,44,48,7,139,47,158,58,153,179,83,189,27,100,164,156,234,199,98,117,100,38,11,24,163,169,221,244,159,173,191,177,229,194,60,25,229,142,239,38,104,95,145,238,47,214,188,90,21,66,126,66,111,210,228,101,36,242,172,130,97,234,90,20,62,166,38,11,198,159,44,245,249,131,27,135,234,87,83,2,62,185,253,129,60,125,165,26,164,138,148,193,87,246,201,45,72,3,33,31,191,29,45,33,15,238,109,8,39,100,38,195,128,83,7,133,205,161,144,113,161,194,75,111,13,7,188,92,227,251,80,96,18,64,26,145,25,40,183,204,243,127,122,119,214,146,16,231,175,187,101,92,23,25,172,45,195,139,252,212,135,73,86,24,33,203,30,64,143,202,39,238,180,143,39,141,32,30,65,76,186,57,211,14,143,45,98,183,16,106,103,221,249,6,53,137,24,139,142,183,198,247,95,139,222,54,254,33,32,110,206,70,243,213,3,192,199,172,149,164,83,182,93,148,177,50,21,141,173,13,238,107,195,127,67,110,37,112,43,142,183,230,190,209,160,162,156,23,27,134,24,34,52,140,72,249,61,178,169,148,8,130,66,147,91,31,208,121,252,240,86,4,49,94,172,145,170,231,175,155,91,81,34,65,35,19,119,54,89,16,204,192,75,121,73,147,188,144,117,13,228,38,41,170,216,212,138,219,190,30,66,160,168,25,44,46,139,91,239,138,252,75,214,254,70,38,167,102,27,83,199,3,87,193,132,173,198,46,20,126,199,149,77,169,28,80,101,104,137,62,96,184,186,195,156,232,54,165,152,181,234,109,221,187,146,210,235,81,120,213,202,4,54,76,73,143,91,58,186,245,234,169,42,230,22,18,250,90,107,166,223,111,105,64,154,164,4,224,90,136,137,59,115,161,111,33,203,195,109,85,228,153,230,42,60,71,72,5,2,62,18,247,95,210,226,191,18,86,215,250,188,187,220,235,252,237,222,248,38,43,49,68,167,200,78,234,221,147,5,179,21,224,63,87,13,134,86,163,63,36,111,99,183,191,107,252,17,109,125,244,237,227,124,248,96,249,123,151,124,55,89,15,60,83,228,51,167,78,178,149,160,185,115,84,80,74,205,223,140,130,90,11,7,178,123,40,235,140,10,228,159,27,22,21,27,35,97,198,101,3,45,152,101,159,133,198,240,50,167,96,88,76,87,206,44,39,249,11,105,101,233,91,94,0,117,182,228,62,63,40,7,175,93,108,94,109,10,13,105,155,235,242,84,115,42,225,207,146,64,214,155,15,160,204,116,101,205,129,106,90,130,161,1,205,66,106,134,110,197,2,121,251,255,76,57,17,131,177,22,249,53,191,239,3,209,175,23,202,194,236,120,82,27,150,175,201,140,218,92,66,6,242,27,242,72,21,153,249,76,147,161,201,108,133,37,82,63,157,26,16,157,157,53,227,144,45,33,251,159,166,102,14,146,8,130,61,71,232,239,55,149,154,94,62,201,196,46,66,64,182,197,173,177,174,129,184,239,93,144,26,35,78,229,198,0,35,11,0,24,58,31,116,17,14,148,173,217,199,57,30,154,70,63,65,205,96,139,15,161,221,167,15,248,53,144,210,247,198,28,89,183,77,185,161,137,46,60,33,250,124,201,6,162,14,149,173,139,246,183,196,97,174,62,140,41,85,124,32,241,157,180,188,116,43,88,101,206,143,162,87,136,175,53,8,137,29,26,223,233,139,150,187,232,66,160,175,236,60,249,74,124,88,0,169,71,249,158,190,158,10,136,161,14,192,129,205,123,206,139,139,194,116,10,232,178,229,135,29,133,175,175,159,206,251,200,116,49,111,179,231,204,59,114,82,198,44,18,188,92,104,214,214,0,99,131,131,20,13,139,95,163,166,89,240,125,147,162,92,27,236,208,194,108,76,213,90,135,100,0,183,53,71,191,95,49,61,227,177,149,62,19,73,102,79,254,208,162,75,217,114,173,130,116,114,179,103,102,51,151,84,216,208,210,52,137,180,99,72,124,128,249,247,136,183,36,28,249,242,125,70,239,231,22,75,183,222,194,216,180,98,166,182,159,27,186,214,74,253,234,220,112,80,103,58,215,113,70,28,68,149,92,181,110,119,67,179,179,9,96,140,249,194,72,173,244,144,58,9,141,246,68,237,118,179,124,164,96,125,30,196,126,104,19,176,107,25,7,162,89,236,206,184,139,167,166,16,55,67,7,93,251,90,252,86,252,171,140,238,114,28,106,253,2,64,26,18,192,199,145,70,224,41,158,81,211,254,47,235,74,231,215,176,97,187,165,209,79,109,189,21,14,209,97,193,29,254,42,24,157,72,5,143,9,214,54,90,86,243,143,140,12,163,2,158,213,69,48,232,80,165,123,73,197,247,8,241,232,198,127,142,153,236,153,145,20,27,64,72,56,14,13,147,102,116,211,20,44,176,108,13,229,36,230,81,206,9,197,5,42,177,137,125,239,52,138,145,92,76,16,223,134,138,221,234,177,91,177,210,67,1,151,117,176,201,125,211,227,144,217,180,31,53,97,31,147,33,222,114,225,63,236,245,62,68,54,30,147,134,96,110,84,124,209,201,141,3,62,115,79,24,228,194,3,74,218,184,3,66,224,170,40,123,37,121,61,129,54,53,103,197,43,89,135,6,26,104,193,193,136,152,56,142,183,224,128,35,138,123,231,218,184,64,116,133,134,79,71,93,163,18,65,127,217,137,72,42,147,44,193,117,255,58,201,221,139,83,224,169,171,21,200,243,196,43,229,12,27,96,110,87,50,136,174,144,220,236,35,210,9,136,71,10,14,95,205,206,230,46,210,240,140,197,31,1,18,188,0,238,15,228,67,49,220,86,132,126,70,124,204,88,118,84,251,214,36,171,200,70,160,93,190,20,193,149,122,208,201,60,231,13,227,143,217,98,120,101,241,47,166,37,0,246,166,53,179,69,210,170,111,102,237,39,29,58,140,90,17,30,66,50,240,135,134,156,130,216,158,96,227,238,43,173,150,62,156,252,12,213,121,200,99,178,38,253,248,51,29,232,51,139,88,26,160,174,235,4,96,47,68,39,65,224,118,4,246,129,110,151,23,33,196,101,107,18,57,33,181,138,239,175,105,157,49,247,51,175,4,49,223,166,210,239,121,16,164,212,230,198,33,63,150,165,9,54,147,43,215,241,224,55,27,106,204,89,39,184,161,80,49,4,115,240,147,14,244,80,211,157,188,47,240,27,232,175,82,215,194,147,55,86,12,143,240,196,252,206,171,147,238,96,167,220,204,222,124,57,43,217,33,94,205,196,224,116,99,78,12,233,159,227,1,76,43,79,235,217,146,66,161,211,175,94,65,74,199,243,183,6,81,84,203,242,106,233,76,173,158,214,45,43,108,174,250,106,136,126,230,63,14,251,213,18,71,87,50,64,255,236,85,183,102,109,45,1,174,202,9,149,185,253,197,58,210,45,138,136,51,85,221,138,73,184,106,127,134,253,72,58,18,180,62,151,29,82,139,220,202,116,64,248,20,81,96,109,47,138,242,186,193,36,58,228,83,194,172,38,0,252,218,244,10,112,115,142,57,210,57,11,64,200,229,159,61,193,101,132,118,218,80,148,208,24,56,50,42,216,65,221,198,222,42,94,40,195,189,60,175,28,71,25,114,164,42,45,8,67,46,142,204,238,25,167,37,150,221,46,11,216,39,161,104,150,116,113,1,94,67,6,9,155,180,85,217,5,244,160,99,51,203,177,93,136,13,60,29,150,143,141,45,240,202,86,52,252,208,169,251,4,6,159,54,129,123,18,109,207,1,191,79,38,187,105,43,96,244,160,246,58,53,1,126,98,82,106,12,250,65,44,103,65,155,146,190,0,201,249,32,20,57,171,220,149,156,114,51,66,148,220,137,156,113,120,32,169,126,124,13,130,177,138,31,55,46,148,240,128,29,71,141,116,145,112,8,66,189,190,216,123,114,164,94,213,103,242,213,46,100,240,150,169,179,251,110,47,164,50,174,245,163,245,59,14,243,8,35,82,74,151,19,130,70,32,129,139,54,14,190,35,131,230,71,44,133,253,187,52,219,118,239,235,58,76,31,196,252,32,242,187,197,157,187,55,29,121,51,214,250,24,234,46,96,133,232,102,63,43,191,186,226,113,189,64,205,186,249,119,43,113,194,61,250,58,221,69,191,75,14,152,187,167,243,108,156,124,46,5,218,175,243,118,7,240,85,167,144,192,213,61,210,252,162,165,162,46,86,124,240,63,149,35,88,159,198,71,207,56,140,25,144,133,248,190,191,241,252,13,124,234,108,165,9,106,44,119,178,102,193,221,168,140,143,125,102,211,106,41,163,241,103,12,131,227,10,78,64,224,131,209,128,108,224,131,81,196,188,208,57,0,65,7,171,245,92,68,97,155,26,19,0,220,173,153,62,182,16,55,19,229,89,135,80,157,145,162,168,60,3,54,77,8,252,62,78,45,97,13,187,5,95,233,221,143,244,218,237,9,191,191,111,230,19,235,185,24,229,133,236,211,127,22,70,243,186,237,63,6,52,140,155,111,172,124,143,130,20,198,240,17,48,164,10,74,221,17,240,102,82,73,186,66,214,132,28,226,189,253,197,216,71,13,102,76,54,192,250,157,250,97,33,169,125,119,76,18,127,148,89,55,79,41,27,171,173,241,40,25,242,210,152,51,104,129,66,79,162,178,205,127,78,159,148,90,244,237,62,200,220,157,71,215,30,45,95,17,166,151,2,107,156,25,214,202,113,205,64,70,182,24,9,62,176,176,190,16,176,188,96,117,242,77,22,88,50,108,118,138,246,209,82,199,143,160,77,201,121,197,140,194,143,8,181,195,45,95,221,40,139,214,14,153,166,70,195,180,165,102,177,227,237,193,79,231,55,66,91,102,116,212,200,47,182,152,106,44,255,140,122,66,158,160,250,117,112,5,28,227,9,101,161,115,43,75,216,160,129,201,85,4,155,212,168,94,163,160,204,9,102,25,233,102,160,184,227,106,238,100,129,31,84,122,126,254,145,223,210,150,80,172,229,177,248,245,3,169,238,5,16,2,78,51,54,207,82,72,227,99,136,26,105,129,53,22,17,45,214,181,195,68,36,56,169,195,242,5,8,191,67,154,4,98,246,26,112,153,140,77,237,240,2,154,115,169,245,170,100,202,110,18,149,98,123,104,24,71,192,232,157,222,215,83,47,36,18,129,246,103,237,227,185,218,144,30,199,136,151,160,138,100,74,32,166,208,86,67,75,237,132,120,166,153,52,64,10,225,171,2,81,131,86,59,191,48,93,62,184,125,186,164,181,232,91,66,146,242,21,173,53,43,188,74,248,215,108,185,224,167,76,81,71,206,93,12,235,166,22,241,224,190,133,235,131,111,103,60,230,112,49,52,171,86,194,94,59,123,115,191,87,69,241,194,32,229,82,37,247,66,83,202,39,30,54,213,89,3,78,249,44,22,248,167,57,0,84,189,32,168,147,103,6,140,148,202,187,193,37,38,180,46,29,166,57,72,223,230,106,44,108,111,251,141,251,89,7,111,191,116,203,52,57,144,49,241,196,170,155,145,94,130,81,6,8,48,239,173,230,55,130,69,187,163,225,66,214,151,106,237,182,124,152,252,164,152,71,188,138,18,156,234,158,96,75,48,112,107,71,163,19,180,198,24,225,112,151,114,89,6,217,49,26,232,78,138,51,90,69,91,193,126,130,54,20,217,158,121,249,61,85,203,2,97,83,109,237,170,254,0,91,197,122,244,126,45,233,234,109,127,179,19,219,93,31,65,76,94,19,176,192,62,20,225,161,144,181,212,117,211,254,177,20,119,165,4,191,21,105,172,116,103,36,198,101,166,240,111,212,21,87,239,249,26,153,242,52,76,142,34,251,237,81,66,187,57,122,29,236,37,110,21,148,230,218,247,104,63,1,234,5,69,199,73,134,157,172,42,231,147,224,75,141,129,211,82,4,89,195,246,70,171,181,93,183,55,108,159,166,33,84,4,185,111,204,210,203,121,247,47,11,38,196,128,175,73,224,158,13,7,251,219,162,20,164,80,64,199,241,117,6,96,69,101,173,208,37,165,211,107,165,193,43,31,159,138,214,247,2,33,12,191,208,158,105,240,17,229,141,41,237,45,38,45,115,88,232,28,191,188,150,228,13,47,17,235,94,149,41,105,96,203,124,26,222,106,9,189,50,92,15,120,136,57,57,255,99,51,112,155,217,186,209,181,137,48,198,43,39,230,86,230,26,217,240,223,93,238,195,80,220,79,238,160,255,161,52,146,25,191,179,0,106,203,39,179,207,46,133,153,151,239,88,57,122,189,135,89,178,115,230,216,10,114,143,251,93,168,61,169,202,150,202,196,237,75,49,182,183,125,110,19,34,1,136,14,89,81,155,227,118,201,69,250,152,109,216,132,250,88,147,48,2,191,100,195,211,13,126,162,119,72,133,229,123,207,22,23,212,210,63,155,150,227,57,166,222,129,67,70,42,85,154,245,247,41,193,230,95,156,113,40,103,226,86,19,6,181,49,124,103,224,189,223,33,119,236,24,20,229,68,141,154,5,89,177,163,212,125,152,33,38,48,226,24,141,151,158,51,86,207,22,139,80,172,113,125,82,37,229,71,24,29,22,151,195,95,177,29,49,74,158,121,217,68,52,92,168,158,88,196,251,22,3,155,79,122,252,156,221,200,181,70,100,216,71,156,175,156,86,2,231,130,108,43,211,119,75,181,114,163,95,222,24,246,255,186,183,186,101,37,137,223,53,194,47,117,58,55,235,209,179,14,167,242,26,134,221,36,193,38,118,184,207,96,67,32,145,250,154,128,94,25,66,185,48,57,213,130,222,58,197,173,252,78,101,199,141,206,155,94,81,157,155,216,239,200,168,141,203,59,210,55,17,55,170,5,110,70,51,20,19,17,219,187,198,121,220,48,135,101,52,185,215,244,4,37,229,220,138,211,126,144,244,210,14,194,134,9,176,26,52,128,5,94,173,63,199,171,196,37,142,16,185,13,98,224,38,105,153,24,182,124,179,35,177,69,226,224,127,75,236,2,98,7,44,185,3,14,107,156,129,152,51,36,29,203,211,203,108,162,74,162,216,89,12,128,9,112,14,157,147,3,227,248,177,51,228,239,231,213,231,254,82,42,244,137,106,99,170,156,192,66,71,139,213,5,156,125,195,124,229,130,190,205,89,225,241,254,176,95,30,219,40,248,129,218,116,222,75,183,241,249,60,88,178,52,92,157,156,113,232,162,36,107,47,55,17,155,162,70,224,125,82,84,211,203,26,49,246,193,94,207,161,122,216,126,138,16,206,87,28,38,45,30,196,186,30,68,206,95,156,208,218,236,93,107,125,217,121,46,223,4,69,183,46,238,206,71,72,167,159,167,48,118,25,0,159,147,140,99,166,172,4,113,21,161,52,102,54,219,194,90,106,50,6,156,202,21,86,112,33,45,53,6,124,162,83,226,178,246,1,165,167,177,190,237,128,219,79,114,30,187,31,146,10,157,251,80,124,108,191,233,91,104,68,35,156,13,54,123,191,37,77,245,82,222,206,8,246,133,27,217,87,116,7,145,65,128,81,142,250,19,137,207,10,217,88,150,119,183,30,231,123,9,189,145,113,150,247,204,148,101,142,228,144,127,101,122,157,153,221,45,112,44,139,13,223,94,18,221,245,14,185,252,132,117,15,173,122,121,1,251,109,2,107,25,97,29,180,199,11,124,161,138,37,92,119,254,245,118,34,128,28,100,200,80,5,114,99,208,232,126,215,247,226,193,129,111,229,166,12,107,30,67,118,84,156,100,158,204,44,28,118,134,227,10,22,153,126,77,13,134,137,18,167,115,62,98,60,182,179,66,109,93,146,39,135,247,137,193,45,175,156,83,87,217,63,250,57,154,128,151,152,45,35,43,126,198,229,219,126,200,145,4,236,251,153,196,162,89,73,134,96,119,107,128,190,147,228,64,73,220,100,124,73,203,91,213,77,92,68,50,107,69,237,110,138,228,193,175,162,213,78,39,118,105,39,11,196,157,25,195,35,53,250,121,123,219,197,179,143,206,30,210,251,106,231,243,37,84,55,23,7,30,84,11,121,92,53,9,191,28,49,57,237,112,78,183,12,215,243,99,159,238,14,246,197,136,207,69,0,120,99,89,37,184,54,94,128,204,224,174,118,50,226,59,151,162,115,167,144,223,213,199,4,87,55,193,10,212,169,238,242,254,70,213,252,87,32,245,18,157,79,122,232,143,103,31,93,140,93,243,91,156,91,223,136,12,68,98,200,179,170,185,195,112,27,104,3,205,165,28,186,174,118,57,189,119,144,158,95,158,164,143,139,58,87,217,43,22,68,43,126,240,70,94,163,225,233,248,227,168,70,198,16,51,205,239,192,4,124,244,190,80,130,188,253,65,63,201,98,243,142,139,238,115,52,164,188,234,11,203,33,66,111,40,174,113,78,139,135,102,209,122,166,53,10,2,10,140,215,139,223,100,11,23,208,126,65,214,52,37,98,93,37,250,159,75,209,155,248,86,107,5,114,199,254,105,179,240,132,18,228,65,136,188,180,168,141,149,43,234,13,114,25,92,32,8,212,172,186,194,234,241,77,20,142,76,140,225,110,176,248,93,52,69,8,47,143,25,99,166,56,37,228,218,183,234,205,236,237,168,228,136,179,145,123,254,230,182,37,220,223,96,199,45,24,147,73,86,254,47,90,124,89,129,192,199,167,216,217,62,148,163,46,107,74,67,155,206,30,163,44,42,238,69,77,5,86,126,151,131,136,59,134,63,72,23,50,35,228,75,48,172,147,4,200,35,217,142,56,51,159,145,237,51,218,27,192,43,193,90,63,194,218,149,77,69,58,68,24,177,235,144,245,52,41,241,21,63,202,204,123,60,245,245,147,59,230,53,58,179,177,6,108,72,142,101,202,171,147,1,238,27,183,145,157,7,29,13,111,137,129,183,185,196,139,126,204,48,220,237,170,227,65,153,226,170,245,241,69,250,74,235,39,129,115,94,113,165,212,140,219,239,255,30,2,150,71,167,222,250,123,230,253,102,110,67,175,23,73,166,0,144,47,148,163,151,221,23,81,24,247,230,191,244,11,1,206,112,51,40,182,33,40,163,61,107,169,167,6,202,202,72,255,23,102,172,225,38,148,226,88,109,43,255,21,145,157,184,0,241,95,26,253,89,42,53,13,149,184,8,74,173,119,80,63,39,122,131,186,46,224,96,135,125,146,230,186,215,105,91,230,163,169,125,167,150,59,214,137,125,94,22,30,51,110,143,175,201,170,44,185,136,253,28,105,89,77,41,65,135,12,60,237,170,191,75,127,88,149,34,205,123,6,139,121,217,249,166,254,165,197,104,144,84,48,58,172,21,122,128,85,199,148,36,114,91,239,123,1,206,8,169,49,206,39,142,97,137,189,224,169,198,119,13,171,201,140,49,157,103,118,88,94,210,27,126,242,245,68,55,25,204,114,244,247,64,29,145,137,154,56,172,22,62,19,227,79,143,90,5,12,201,194,154,224,71,103,79,31,119,20,146,114,219,19,44,92,21,211,69,49,20,95,47,183,25,195,60,209,50,238,182,244,59,9,94,112,27,36,210,214,7,152,57,84,87,219,76,117,252,173,214,2,188,162,120,141,43,194,108,127,121,25,148,205,129,10,46,39,41,144,243,52,218,147,187,37,188,247,50,228,177,63,51,214,17,10,240,24,244,129,34,87,146,124,5,230,163,171,120,234,22,101,103,156,68,245,144,114,132,132,244,163,47,127,235,219,88,243,187,140,196,153,78,126,139,116,152,107,147,27,119,0,2,213,231,59,70,73,214,67,31,130,51,71,155,189,211,225,165,140,83,24,36,56,202,105,50,33,140,155,216,216,209,252,54,156,254,20,81,120,206,235,241,53,194,44,177,128,30,239,26,95,124,88,90,21,132,123,188,158,141,127,241,223,95,178,108,21,221,145,222,26,192,180,84,129,78,175,117,146,57,215,116,10,13,53,12,252,227,64,32,115,213,68,143,238,155,225,101,184,132,28,92,127,89,232,1,139,160,185,99,115,92,29,188,211,254,180,85,121,47,205,53,199,122,73,153,119,188,74,163,229,129,90,48,50,178,91,189,168,116,38,32,114,55,89,132,116,208,124,128,113,113,16,206,199,26,163,212,71,1,250,155,96,53,100,44,246,31,136,208,243,220,60,176,23,103,88,245,48,51,59,225,235,226,76,182,53,49,135,126,117,23,4,0,51,62,11,237,65,252,21,246,193,84,14,85,217,111,240,108,226,134,59,194,210,198,214,9,245,99,101,81,3,89,134,225,173,80,61,204,115,250,25,191,22,137,42,177,155,159,237,248,200,39,189,1,66,189,88,8,198,57,47,194,59,150,74,50,244,192,145,124,139,137,9,88,183,226,179,162,219,55,201,222,186,109,36,242,146,104,134,170,9,120,67,123,240,251,118,184,113,206,203,242,204,29,95,103,160,139,24,229,246,174,44,232,1,92,51,119,121,192,74,200,193,169,150,115,168,56,37,31,105,175,166,10,183,252,135,115,233,34,0,229,124,183,246,177,143,42,237,125,2,142,154,240,49,228,213,15,77,123,202,79,84,0,147,189,200,161,106,243,41,87,86,158,216,240,246,100,112,9,91,213,220,206,108,190,57,220,218,99,189,47,194,120,28,127,254,169,178,91,243,109,75,134,210,210,244,242,159,54,217,20,133,68,233,153,234,101,91,233,30,96,171,224,92,91,176,236,182,188,20,131,21,122,84,104,171,14,236,252,249,75,212,235,191,95,11,62,141,94,241,165,26,219,173,197,153,214,168,223,240,94,213,113,148,95,22,212,203,134,117,232,60,147,51,11,201,54,4,81,122,170,58,150,209,147,128,196,78,68,78,148,160,114,198,127,162,120,180,68,133,22,76,101,119,11,93,246,9,232,183,127,140,173,92,221,236,51,178,45,217,246,70,118,91,129,102,24,199,252,7,6,116,81,43,240,49,115,77,164,134,23,10,184,92,26,223,238,174,254,108,5,221,29,205,3,38,30,51,143,196,202,21,102,228,51,105,45,191,54,175,140,175,135,132,56,183,9,116,20,68,132,18,220,233,176,239,82,87,160,87,75,33,255,121,193,156,78,230,23,79,64,52,198,99,148,130,106,107,8,203,26,34,248,194,178,123,242,238,250,69,219,168,219,185,118,64,221,220,7,62,58,172,34,161,85,252,155,52,152,60,87,103,183,167,226,234,225,170,247,90,38,143,81,89,210,156,20,60,194,148,113,179,171,5,77,184,78,26,208,131,200,86,18,46,116,74,134,61,119,29,194,3,117,40,80,168,90,103,191,42,184,95,218,91,28,155,54,146,65,95,188,105,77,14,205,75,249,117,46,221,98,224,169,93,190,83,43,182,146,208,7,135,154,99,250,12,2,189,246,105,220,172,175,69,1,167,218,186,57,136,247,112,149,221,32,11,202,229,160,52,60,200,208,193,198,75,246,250,53,55,150,176,139,93,85,222,206,205,111,9,73,162,186,211,69,140,188,136,164,203,223,18,225,119,181,234,138,60,23,112,75,105,15,203,7,125,177,246,31,45,74,151,48,22,139,175,136,183,250,161,111,94,119,158,113,175,140,79,29,122,65,55,233,80,125,200,31,209,18,35,82,3,116,190,125,208,46,253,125,100,73,160,238,5,244,38,184,200,7,167,119,122,165,28,250,26,52,110,188,151,63,208,63,248,94,165,164,111,163,146,32,37,5,60,85,192,27,61,24,60,161,222,0,4,254,155,189,84,196,0,157,35,12,162,103,138,192,135,38,45,40,41,69,63,30,177,222,41,253,200,54,63,230,237,20,103,172,23,99,192,215,2,181,198,52,12,1,157,162,169,147,206,27,237,188,158,40,214,164,233,240,100,201,245,24,178,38,205,66,140,166,43,132,117,143,233,22,167,190,202,18,188,127,240,184,49,182,87,84,214,121,140,169,20,29,122,133,69,18,168,61,132,146,108,35,131,109,86,101,183,150,34,77,90,194,24,46,232,28,48,183,206,47,100,61,163,165,74,17,92,27,210,106,16,222,186,117,41,103,197,144,3,27,9,248,132,189,88,83,122,219,49,116,2,50,30,40,205,76,130,35,126,83,228,228,138,171,171,135,39,196,227,87,106,235,241,239,86,179,253,11,23,99,7,66,41,158,178,157,76,234,6,5,214,254,184,155,181,84,197,165,122,251,119,249,236,166,219,144,14,253,20,200,71,185,128,249,58,15,196,101,206,51,124,190,50,159,255,10,172,123,168,253,230,89,10,236,71,194,62,129,71,92,165,85,0,198,135,157,141,191,50,13,140,37,124,110,249,46,46,25,251,68,145,8,18,120,51,137,142,119,244,148,246,141,26,132,163,135,241,35,159,49,77,209,163,230,111,6,242,146,195,49,170,2,124,194,17,165,42,155,254,34,50,37,48,67,234,117,90,102,69,129,61,195,172,78,87,34,46,79,146,168,210,166,122,231,226,222,204,251,20,75,223,196,242,130,34,225,110,75,207,175,78,24,239,45,171,104,198,59,0,19,49,11,243,112,43,250,158,62,80,155,237,46,52,188,185,245,171,68,197,202,251,110,93,211,94,67,191,87,157,87,233,13,61,47,52,206,80,194,167,66,67,198,170,244,247,174,171,50,79,255,184,161,14,254,202,162,162,254,221,148,221,251,90,102,154,71,98,61,150,1,32,250,227,57,240,168,21,174,152,107,235,75,2,198,35,117,161,148,210,231,214,184,87,241,102,16,184,144,221,165,158,108,17,177,46,228,156,159,149,123,171,239,250,40,10,62,189,159,144,124,7,64,76,122,161,214,158,46,206,191,99,142,189,68,40,168,172,65,88,130,102,169,121,107,188,201,117,35,139,212,14,176,77,110,172,197,14,238,254,189,108,234,224,228,68,226,121,230,183,185,224,25,14,142,86,3,2,21,133,116,109,24,125,214,126,192,236,107,42,30,208,247,43,102,62,205,11,213,177,80,163,92,245,82,101,244,192,151,191,169,102,204,190,167,232,66,226,12,115,238,131,188,181,235,30,55,68,17,186,125,64,121,44,39,147,240,53,20,40,101,224,109,239,226,32,115,253,200,113,202,118,207,81,168,138,146,224,129,38,168,181,120,87,225,170,24,6,223,254,59,48,103,66,191,112,18,100,232,149,121,191,132,39,231,12,223,111,202,150,238,150,76,143,41,37,183,222,8,16,24,33,99,101,144,218,10,68,70,133,97,95,109,42,67,13,102,0,93,189,206,41,149,160,206,101,195,209,76,22,231,109,76,142,113,78,222,63,202,227,65,140,154,29,47,96,41,58,77,137,107,249,152,7,126,53,105,31,221,134,107,150,14,18,108,110,152,91,57,88,146,199,220,12,79,116,220,134,180,176,224,71,97,52,154,76,94,230,58,14,196,154,89,27,162,219,96,227,91,143,175,92,36,179,222,30,59,163,32,250,146,96,163,83,134,33,18,27,99,127,113,171,35,52,143,96,219,71,71,254,216,30,244,75,88,241,242,50,213,1,83,56,154,152,153,219,130,166,175,82,10,125,111,96,137,38,46,205,11,85,195,29,184,117,250,218,58,49,10,40,30,139,211,81,157,249,51,33,100,201,34,96,197,189,206,48,180,50,2,111,154,109,10,90,116,189,224,85,45,153,10,96,210,142,179,131,174,213,131,9,90,194,235,113,201,152,223,253,134,198,136,215,196,121,114,145,127,197,63,226,22,10,124,149,177,37,12,217,218,113,9,235,142,49,103,237,98,82,140,8,127,97,56,61,78,76,142,106,216,56,78,153,139,60,223,243,28,34,38,199,137,132,50,118,151,58,141,192,20,249,138,53,114,177,45,146,78,147,234,123,244,61,157,119,7,88,41,82,17,102,213,59,93,79,45,40,157,139,219,81,12,134,18,77,1,101,45,228,155,66,227,243,242,202,71,136,205,94,102,239,237,253,62,207,30,222,178,58,135,219,74,150,232,27,209,251,37,198,33,83,209,39,249,183,21,38,213,39,143,198,149,91,161,250,193,43,45,233,70,234,118,173,231,180,151,157,138,7,167,198,81,194,51,164,200,83,56,176,121,167,225,108,50,245,125,137,148,215,111,59,19,64,109,5,114,176,218,137,186,235,94,254,156,96,194,168,34,159,84,171,68,70,215,155,148,244,240,11,54,128,75,56,161,201,231,65,137,194,113,32,89,201,13,141,169,131,94,198,168,132,135,101,50,165,181,8,159,184,15,19,74,16,105,43,25,168,214,106,76,164,64,91,12,74,22,16,124,27,121,145,188,125,255,96,131,33,245,145,180,29,62,194,137,30,62,243,129,77,13,158,163,117,162,206,61,236,135,244,220,166,174,217,73,139,0,254,201,26,125,241,33,68,187,155,235,119,25,72,196,151,8,255,8,84,250,43,102,204,134,121,186,123,144,48,2,235,7,229,41,190,150,181,169,203,226,194,118,180,182,162,220,222,14,52,114,197,229,86,207,201,148,241,246,69,68,231,8,57,6,21,171,44,83,134,151,83,25,48,142,91,248,21,21,213,9,104,208,21,12,133,100,100,144,124,237,193,56,180,34,39,246,232,53,212,121,61,127,221,103,74,114,150,223,11,229,210,6,76,40,95,192,199,167,100,100,64,117,44,73,13,187,42,241,47,212,35,164,55,64,85,88,41,102,68,165,110,72,100,66,38,33,14,166,233,157,80,35,137,1,69,63,111,169,42,19,65,190,106,104,216,90,154,147,190,183,207,177,145,142,190,213,148,10,228,251,99,58,72,148,192,227,20,1,79,110,181,47,89,218,133,7,75,111,229,49,60,97,179,158,28,51,110,139,80,56,147,33,182,227,153,92,32,1,241,44,181,143,24,16,252,26,129,134,63,65,186,1,160,90,254,21,88,43,220,101,222,156,214,211,98,172,42,254,193,103,147,61,229,181,85,228,223,127,163,201,157,106,97,82,251,201,89,32,245,234,92,103,151,70,111,44,210,74,166,88,95,204,82,185,9,218,72,146,27,181,139,97,122,22,228,206,84,237,87,140,101,100,110,216,186,226,110,186,109,140,162,59,52,3,26,96,176,41,84,66,47,216,100,110,106,2,55,106,165,232,43,156,42,193,122,42,74,224,96,101,41,240,141,4,88,29,113,31,121,80,196,152,15,234,154,70,129,228,97,137,99,89,108,64,143,32,111,199,220,209,192,20,24,80,192,202,191,169,156,133,210,36,179,17,149,67,213,52,180,176,134,253,181,179,174,87,217,236,254,162,137,201,192,88,23,89,195,231,73,182,226,224,149,99,172,221,135,5,241,132,86,236,118,69,50,108,27,103,65,17,127,75,11,160,71,85,227,148,153,62,103,83,250,192,254,215,123,252,157,8,112,132,210,193,21,244,168,131,44,69,226,190,243,10,225,163,84,190,118,32,19,193,234,220,32,188,74,90,197,143,70,191,99,113,186,143,49,131,109,253,62,234,221,183,103,238,89,65,67,11,230,9,222,24,95,129,14,228,125,126,166,49,29,239,36,39,124,130,203,200,105,29,231,182,43,1,179,193,103,230,251,205,22,182,65,191,137,110,165,113,180,60,209,87,212,7,69,241,130,157,125,59,225,89,244,120,134,142,170,92,19,65,251,87,163,83,32,185,163,202,187,191,34,192,183,186,236,30,222,225,180,237,142,162,77,93,190,100,248,70,134,164,253,105,255,142,189,83,50,161,225,223,241,240,252,170,90,122,221,22,108,187,81,31,252,76,218,238,217,175,90,110,37,190,8,65,147,181,160,202,39,24,230,218,92,233,102,123,98,72,215,163,152,111,198,25,215,60,213,1,254,4,168,45,13,40,238,142,158,60,70,241,144,183,215,236,146,149,13,234,215,133,3,112,135,7,8,40,195,214,105,244,172,246,200,198,238,153,112,100,59,137,18,122,9,204,17,41,181,111,41,61,21,160,16,170,194,218,178,62,88,92,199,233,200,24,70,246,142,224,164,200,210,237,216,75,100,45,115,160,117,92,38,226,170,215,156,203,215,210,248,231,199,216,248,161,125,167,132,103,180,186,9,249,4,154,16,237,107,80,28,27,235,150,39,210,201,153,66,17,97,165,29,15,167,130,23,77,17,106,160,90,248,47,219,164,20,127,81,248,1,36,254,22,50,208,65,145,45,220,160,93,16,45,62,229,177,187,144,167,142,26,248,232,6,191,77,59,136,49,2,33,116,66,65,146,218,44,111,73,2,222,99,111,24,180,41,67,103,39,216,168,240,207,142,34,241,86,17,173,37,58,64,186,213,98,181,151,159,141,26,22,31,45,92,64,9,10,26,76,181,236,145,18,8,30,219,158,183,71,138,134,56,65,70,34,140,141,13,54,245,29,155,227,200,183,113,40,113,203,86,214,2,162,90,237,5,247,2,186,149,205,73,75,106,255,178,8,39,126,21,96,43,117,216,10,81,98,244,208,25,252,177,189,21,50,204,13,115,42,29,115,2,10,234,207,168,29,131,228,241,82,183,158,85,177,161,142,249,81,208,74,7,73,61,160,142,153,121,63,78,230,152,77,38,100,58,119,15,102,23,145,201,189,165,77,147,230,208,2,84,68,22,86,13,32,68,58,88,73,8,48,139,117,27,222,40,32,182,33,168,89,188,113,162,162,146,225,102,118,158,53,22,82,149,184,240,92,212,243,40,50,170,149,147,223,104,185,45,162,20,59,162,173,157,5,224,233,8,159,219,28,215,102,178,59,121,254,199,162,199,99,2,69,53,6,16,218,9,6,241,44,220,188,45,208,250,244,235,250,209,70,110,222,198,183,219,47,135,143,170,11,226,178,201,194,8,0,115,63,105,158,9,227,172,16,176,218,211,18,70,236,5,109,35,119,143,218,145,213,190,153,247,240,232,191,61,9,58,130,175,235,45,122,195,207,43,194,102,133,91,46,230,18,78,212,122,114,168,4,94,120,96,72,18,12,142,191,141,105,202,78,241,114,85,34,238,84,11,10,254,50,188,122,76,216,117,121,110,3,95,91,62,253,60,174,139,195,120,183,220,61,229,75,22,220,190,134,216,68,90,111,184,152,40,130,43,39,76,144,94,215,83,252,62,127,27,6,175,158,50,87,41,85,95,32,24,14,193,22,92,54,156,254,77,61,50,7,243,25,48,156,89,56,17,33,107,135,110,160,52,80,216,55,217,98,40,102,1,34,70,233,200,205,172,234,156,17,180,123,113,143,67,81,224,51,149,12,213,251,3,2,63,30,249,181,254,120,160,155,133,96,137,181,35,5,182,121,214,39,128,129,237,203,19,137,24,93,101,255,228,209,34,58,241,253,187,131,60,8,241,178,36,11,26,109,21,150,214,31,242,19,60,118,147,158,111,23,164,168,73,67,92,231,211,6,86,222,242,248,107,142,231,119,143,1,168,27,187,91,70,38,230,162,216,232,152,83,71,41,183,182,189,94,221,128,7,217,182,42,49,232,20,23,3,87,95,213,181,137,117,14,161,52,243,122,183,193,90,134,182,58,222,179,72,150,241,129,197,216,227,156,20,75,90,202,71,128,15,137,242,183,117,188,168,252,39,243,76,167,222,12,190,250,197,206,164,145,191,47,206,24,20,40,253,36,4,220,72,143,199,19,105,30,48,219,215,196,37,15,182,38,220,134,239,35,187,29,230,68,215,139,220,215,90,25,184,246,196,149,239,249,142,248,63,141,205,161,28,87,142,170,237,214,67,142,251,97,163,163,242,208,139,28,201,5,249,160,111,232,64,231,207,201,197,196,206,92,127,71,17,57,48,200,25,226,176,113,210,162,108,233,45,224,15,40,196,161,187,228,55,88,74,235,30,68,12,209,70,87,243,159,85,208,70,192,75,111,14,15,239,6,234,134,248,30,113,51,255,128,43,104,82,6,158,241,74,19,174,199,229,132,238,6,70,145,96,242,208,185,17,12,251,210,13,113,233,186,188,29,9,195,244,71,62,26,195,82,44,209,10,230,93,188,92,234,241,145,115,67,77,67,44,210,249,228,5,84,43,160,77,103,214,59,87,195,200,20,129,254,173,229,229,37,115,254,49,72,119,145,188,255,12,95,191,110,239,124,12,213,234,217,4,211,133,39,184,242,103,223,13,5,50,56,74,214,135,66,130,62,223,167,91,175,30,40,134,82,42,167,175,169,33,40,205,88,123,104,96,189,142,226,130,73,0,60,121,128,225,203,146,1,170,4,93,235,72,243,97,77,129,92,246,173,53,161,138,204,83,70,234,80,223,20,176,62,149,150,127,141,182,196,163,80,117,13,31,248,64,166,35,112,96,44,221,70,128,124,229,74,60,65,83,15,20,135,165,184,82,153,163,153,145,137,168,21,68,140,120,76,239,1,57,32,133,38,158,157,114,92,79,139,129,100,233,109,73,206,6,164,101,18,250,41,214,14,185,87,241,153,142,116,3,55,77,138,149,123,112,38,59,191,132,156,136,205,108,175,236,117,66,107,36,241,192,147,149,227,116,253,26,209,34,134,94,214,68,212,25,142,117,207,151,32,13,101,187,154,38,54,165,162,58,254,142,54,86,89,13,232,46,36,31,67,169,250,183,168,205,55,163,165,77,37,211,28,12,51,80,99,47,117,190,69,215,83,246,24,48,152,252,50,167,183,242,94,21,63,211,171,23,199,4,160,172,57,57,92,128,50,52,174,87,77,255,17,221,149,165,195,162,43,38,226,27,221,101,124,188,82,226,222,49,132,246,31,27,81,255,205,69,176,163,195,253,83,47,80,99,157,132,223,160,92,39,120,73,149,51,171,255,67,218,107,160,220,58,236,28,119,180,1,82,24,146,160,44,200,70,141,109,254,12,126,229,95,99,96,3,216,221,136,205,113,142,122,186,243,183,255,22,253,97,176,39,222,179,209,180,233,133,72,37,54,158,28,65,95,13,1,59,153,193,87,230,128,104,160,201,205,2,196,6,125,232,155,188,65,83,240,126,145,178,63,143,0,240,193,78,184,2,226,82,240,49,22,50,167,206,196,168,121,68,212,156,249,154,95,24,93,83,113,168,33,14,246,208,135,139,78,122,101,123,8,177,97,182,122,128,106,140,8,192,100,143,88,196,50,29,207,215,143,65,120,133,133,118,94,128,12,106,130,195,165,203,112,192,173,166,222,59,23,34,6,82,131,16,84,214,205,87,208,140,201,182,166,221,131,122,181,85,150,65,139,133,103,23,179,159,231,7,175,204,95,130,131,126,45,155,135,76,69,145,54,197,251,173,9,206,46,189,122,101,178,24,17,52,231,121,151,60,255,66,47,5,0,134,235,185,232,129,137,35,158,3,110,230,211,73,61,209,224,71,153,55,248,61,100,233,170,140,66,27,177,253,40,208,209,143,4,27,108,105,166,136,60,8,218,119,168,182,107,8,119,5,118,31,219,43,94,70,182,91,68,254,135,245,212,250,26,105,156,109,180,133,177,249,140,89,130,79,55,31,123,18,154,42,191,139,9,240,237,151,107,173,188,134,243,132,118,79,249,197,52,29,174,60,127,48,203,213,101,118,178,117,92,200,49,217,119,172,213,150,231,103,134,168,200,159,174,105,85,8,72,53,243,196,179,102,171,173,207,190,134,186,250,180,231,155,193,203,81,248,175,8,196,145,73,186,178,63,177,60,238,12,42,169,79,173,245,76,171,131,19,102,237,156,201,116,42,209,167,158,198,227,114,197,227,182,212,229,151,110,140,149,239,82,124,137,145,167,26,54,159,102,237,132,139,121,181,115,78,145,179,231,40,243,114,107,190,126,230,152,86,21,43,130,126,87,172,107,120,215,174,119,95,238,138,107,162,109,30,0,156,48,191,59,137,171,39,151,249,219,16,202,29,186,7,225,198,202,213,119,26,30,46,66,61,154,127,212,160,121,30,139,137,77,16,197,1,225,23,181,190,52,124,88,224,250,45,111,131,115,99,26,188,227,244,207,13,101,230,130,96,187,90,109,141,203,246,150,213,238,2,180,162,199,113,129,255,97,7,65,101,37,145,166,70,193,39,68,86,45,6,162,80,189,182,147,237,204,108,173,114,12,139,6,79,110,178,50,39,17,113,41,178,217,61,88,132,240,93,181,152,170,7,71,170,146,115,177,209,87,215,16,157,38,76,45,46,220,16,103,58,125,32,153,241,187,154,232,13,56,84,165,56,94,8,6,118,36,14,96,65,93,68,50,208,97,85,185,103,1,161,83,67,194,38,128,76,181,204,102,151,40,72,219,119,58,243,206,0,99,50,157,241,110,31,75,39,89,181,28,80,34,47,54,40,145,0,60,100,212,148,16,35,19,189,130,103,237,1,19,109,241,72,134,148,103,72,23,209,106,186,211,41,196,18,76,23,75,122,68,251,50,11,252,232,52,72,57,5,52,226,217,252,184,71,71,112,106,214,93,60,250,235,235,115,148,64,183,222,82,158,135,135,145,153,54,138,126,116,216,66,235,51,100,7,1,111,11,231,57,153,174,195,76,173,195,2,137,227,217,61,109,233,31,68,5,179,235,72,80,16,191,118,37,76,119,131,246,39,251,58,127,172,229,32,135,167,216,216,39,54,7,180,45,236,44,47,186,218,5,45,145,201,222,24,126,214,198,237,218,245,74,159,119,201,233,27,224,213,175,46,43,252,104,209,254,53,126,25,166,190,157,66,64,23,226,4,74,69,28,42,238,195,233,33,1,64,116,16,110,32,81,97,57,242,250,108,13,200,31,184,115,30,190,65,111,225,197,90,215,174,221,193,216,165,11,16,3,153,141,181,161,223,213,141,64,243,41,33,65,208,245,48,203,171,242,234,120,183,57,60,85,83,188,148,249,94,62,178,164,119,223,137,180,49,184,166,120,134,127,76,230,216,208,161,5,42,237,196,235,114,222,23,134,110,242,244,163,1,42,228,3,251,93,156,48,46,154,200,19,163,205,213,250,142,212,14,156,210,48,20,148,235,204,232,128,21,3,100,38,184,230,249,138,117,207,253,60,79,102,174,115,184,21,102,194,116,47,69,98,110,200,73,248,186,30,220,75,239,155,228,138,141,255,84,179,127,17,124,167,107,102,248,93,59,11,170,167,110,129,228,140,41,111,215,131,169,31,210,192,131,220,50,29,241,34,235,141,60,96,178,83,126,109,14,186,209,248,63,130,108,186,180,105,95,192,234,29,87,8,197,153,103,55,13,10,116,247,40,153,54,84,199,120,69,98,185,228,4,234,107,80,168,240,218,9,114,58,196,150,245,120,244,210,164,160,201,55,20,40,135,138,179,149,228,199,157,192,174,190,79,35,154,208,104,215,44,229,241,125,186,156,42,60,224,60,98,79,40,64,126,207,165,212,10,115,54,25,33,126,58,236,50,194,209,149,85,111,178,89,79,15,60,227,54,174,229,243,135,42,102,50,171,254,95,21,247,31,125,0,215,95,9,254,115,158,204,23,106,103,28,139,202,110,125,119,242,110,213,56,152,116,42,49,235,231,28,252,0,141,119,191,200,51,122,183,74,56,200,99,174,153,239,174,227,16,247,241,53,17,43,147,201,28,236,24,172,158,183,250,239,232,109,178,138,191,154,85,92,101,93,173,175,120,149,115,204,109,250,109,193,172,203,85,254,72,122,109,173,97,223,35,161,59,23,39,177,164,124,186,70,76,36,143,143,79,179,160,167,125,30,112,233,209,141,126,247,37,119,77,159,6,86,22,186,250,64,148,109,116,69,157,161,219,213,126,74,234,55,4,74,150,191,164,59,229,208,73,147,153,74,155,93,93,177,111,177,180,36,107,46,26,222,118,125,41,31,110,95,84,199,96,81,223,99,229,230,111,208,187,44,207,189,197,162,155,118,66,246,102,5,157,180,61,121,27,171,235,38,194,219,47,109,32,238,247,114,130,158,184,151,243,155,87,210,50,16,172,39,124,229,145,237,44,49,206,229,30,118,171,255,129,65,10,175,28,62,65,30,217,20,113,253,179,149,240,28,118,112,140,20,237,39,7,159,242,230,64,144,209,53,33,213,116,176,141,135,111,225,244,248,107,202,235,131,88,130,60,113,17,151,144,193,21,155,78,5,33,221,177,64,101,141,166,1,217,83,16,24,8,33,203,8,73,180,252,201,36,37,193,112,158,81,36,62,12,87,125,150,121,19,39,92,191,173,210,244,36,77,195,88,140,26,156,4,231,27,111,89,251,35,188,185,246,75,176,127,162,75,144,137,255,124,36,161,108,144,154,177,88,19,197,21,51,61,242,175,177,115,118,58,158,40,174,196,158,97,198,184,209,36,126,232,71,189,204,186,7,102,36,124,234,204,89,172,220,192,86,101,51,175,40,9,191,17,115,155,117,200,237,22,138,77,48,250,240,160,224,117,133,170,182,144,213,211,213,2,243,145,65,254,0,2,248,48,33,249,80,119,29,108,76,228,213,3,143,250,23,23,131,183,155,60,55,214,27,114,225,198,150,10,35,148,123,109,118,26,2,65,205,51,165,231,113,146,183,118,99,110,128,192,107,84,128,130,68,16,88,195,165,35,170,219,153,195,92,132,226,34,20,77,81,240,139,150,107,214,77,155,204,106,79,19,168,44,71,198,240,87,142,60,44,60,246,5,116,90,243,72,82,123,206,123,164,157,159,113,100,46,227,97,151,247,172,49,26,253,214,112,110,75,191,20,199,178,121,153,73,146,167,80,165,179,249,104,118,42,76,8,126,200,69,25,1,35,35,219,85,218,235,253,164,63,211,195,178,60,208,120,222,151,167,79,238,35,131,109,53,18,149,50,40,14,206,218,230,111,82,234,124,19,223,6,18,94,196,199,189,219,79,203,3,86,63,184,11,70,220,145,70,39,204,13,70,25,105,99,18,2,0,24,161,197,244,35,162,11,157,34,54,196,92,138,255,30,83,77,170,69,196,207,11,28,60,155,7,88,6,248,72,159,21,242,123,4,244,230,249,74,32,130,186,174,143,2,140,24,130,73,170,186,195,129,0,221,95,213,21,27,147,128,194,103,91,111,210,249,82,200,180,140,107,187,79,132,95,135,105,220,39,219,47,101,130,232,19,153,84,96,21,214,227,184,212,26,88,77,22,173,250,215,51,120,214,55,206,86,220,178,39,170,15,114,12,97,98,239,4,124,47,250,230,133,149,196,82,209,165,151,0,207,30,106,133,62,251,241,196,196,47,179,145,179,2,155,15,5,165,22,67,52,207,39,246,123,134,219,252,174,231,168,82,8,7,192,229,168,45,215,86,100,235,111,169,107,12,249,89,109,86,160,142,181,238,237,223,92,168,130,150,236,224,116,222,45,18,13,13,164,73,38,27,208,24,138,45,80,4,148,58,149,54,128,230,244,22,230,218,179,87,51,104,223,178,9,209,228,14,206,192,249,41,82,34,115,235,125,150,192,196,1,165,252,62,83,243,157,37,218,134,192,149,232,139,145,253,205,51,17,97,192,121,157,60,181,170,126,156,5,44,196,235,223,123,170,2,118,228,255,243,8,132,196,221,30,242,92,159,112,180,131,51,25,126,253,184,7,4,110,34,217,37,185,91,186,44,77,80,104,181,58,171,9,210,180,17,119,8,141,229,247,64,62,232,121,118,112,133,52,173,5,202,94,170,37,212,28,222,193,97,51,164,107,197,181,220,102,52,58,47,147,194,179,174,14,89,19,221,145,39,174,86,249,64,89,192,101,143,207,156,186,210,1,137,143,225,13,38,98,59,92,137,53,31,64,212,100,157,144,100,131,3,65,115,94,185,87,13,25,176,45,184,207,19,250,197,231,86,217,51,191,125,60,11,95,125,105,236,148,166,54,6,42,0,150,180,138,38,30,235,72,106,14,217,69,184,242,46,197,173,38,89,234,41,197,213,165,79,86,118,231,142,207,69,207,108,20,53,179,160,231,84,99,156,253,80,13,15,65,18,73,160,149,31,76,124,141,4,48,207,86,81,87,66,32,121,213,115,116,230,240,201,247,195,159,66,154,244,180,174,14,101,84,3,66,175,40,177,65,194,101,162,234,26,55,222,21,72,164,219,243,129,30,172,104,212,50,6,152,90,233,235,35,221,207,165,225,44,109,74,127,123,173,56,87,209,84,211,48,214,123,5,105,101,78,188,169,175,36,172,214,19,232,125,217,130,252,99,237,244,61,173,193,82,209,216,57,13,12,202,82,193,78,70,69,206,74,240,191,91,25,179,254,242,177,68,23,139,165,101,32,52,246,25,212,240,38,237,147,60,156,190,36,3,56,163,125,228,107,228,6,235,44,250,90,92,77,158,36,217,168,161,77,26,49,125,99,103,191,115,41,120,16,231,243,69,108,169,115,81,127,195,48,164,132,75,173,147,62,148,220,3,189,186,165,200,86,60,18,172,193,207,129,196,167,69,181,134,232,130,109,48,76,133,202,38,184,207,153,39,149,26,4,242,77,59,193,254,102,222,99,68,91,147,245,252,14,111,57,224,121,244,233,148,97,66,37,162,181,44,60,144,184,181,187,204,143,33,120,225,243,226,97,190,168,25,134,240,146,145,251,166,104,183,243,126,93,104,93,84,55,148,49,84,30,71,204,203,236,226,179,113,247,64,213,92,207,126,35,130,231,86,232,149,34,79,127,8,155,120,228,29,247,142,10,151,52,57,180,40,56,93,99,171,253,160,143,201,101,183,204,59,240,23,208,83,198,151,231,231,147,28,110,4,156,102,57,157,18,249,18,50,20,130,56,53,156,41,45,170,41,117,136,179,222,121,239,18,168,166,237,2,237,98,107,148,236,81,60,2,33,181,218,46,71,254,197,234,84,204,80,27,160,118,123,153,37,55,238,240,199,98,227,116,197,126,232,21,255,98,226,206,152,34,211,121,85,69,183,195,225,202,232,188,79,208,206,156,187,96,21,189,252,76,203,227,241,70,211,61,52,217,12,33,243,41,50,152,77,47,82,19,140,197,235,100,59,65,70,115,52,246,95,80,145,224,57,224,221,213,78,145,49,47,117,102,248,205,92,84,18,215,150,191,135,145,62,36,193,200,52,133,187,34,96,149,139,1,97,248,25,51,64,247,58,93,111,15,225,212,223,114,61,92,11,95,154,153,245,208,78,148,39,150,34,40,110,50,154,11,54,4,145,21,134,166,233,0,193,39,105,2,102,29,28,168,238,231,117,248,142,40,50,56,142,240,142,165,151,16,85,30,155,98,225,239,177,187,143,215,228,29,118,98,85,69,167,21,45,116,143,40,42,152,1,87,158,139,169,81,137,18,54,65,178,145,44,82,225,241,84,208,111,202,139,17,95,107,130,255,148,105,65,106,172,230,171,55,197,239,133,168,4,152,247,235,19,138,175,168,216,216,171,23,160,83,71,40,126,234,228,1,76,145,9,132,135,166,202,190,232,233,218,105,184,138,161,252,19,33,132,61,159,183,129,62,37,37,194,79,104,59,218,204,215,82,166,4,190,36,224,43,97,59,71,51,188,214,175,54,18,10,15,153,110,203,218,59,225,113,185,123,75,111,206,104,24,163,254,170,85,40,105,9,229,41,218,37,240,211,103,89,253,97,34,77,188,114,220,132,215,129,26,109,149,186,128,119,108,19,20,122,172,175,10,20,169,9,104,195,150,51,8,159,140,86,232,226,177,7,196,200,167,207,106,126,27,140,222,219,198,149,46,0,13,93,255,121,205,23,206,245,185,247,15,231,173,156,59,156,16,48,118,254,93,148,203,237,189,158,180,101,52,62,155,57,8,175,171,215,67,69,104,60,72,232,226,185,20,206,65,59,42,125,90,124,100,202,134,141,239,191,110,203,164,223,50,232,219,4,222,205,22,70,62,180,75,143,174,228,44,62,245,202,39,117,215,33,145,80,106,131,177,244,66,46,89,167,198,251,80,38,72,190,90,118,85,34,158,83,17,61,132,124,53,24,63,24,90,249,68,131,245,198,183,117,13,157,137,70,189,73,23,75,77,13,25,88,126,217,87,108,92,8,133,154,15,158,112,113,94,186,162,177,9,232,181,162,55,24,38,161,79,176,4,233,11,158,170,242,240,168,77,25,3,223,158,186,182,26,129,84,106,135,108,205,79,254,175,227,1,238,248,79,5,72,169,217,128,158,1,139,110,157,12,39,55,95,3,2,113,179,81,229,38,144,253,35,77,155,97,157,9,47,133,35,238,97,246,176,156,164,3,236,181,42,140,173,1,46,164,218,168,228,127,219,160,224,59,249,247,7,155,98,77,199,215,146,55,151,221,185,163,241,26,122,137,164,190,205,207,4,237,134,165,74,238,223,226,15,248,242,139,107,210,187,234,4,145,23,231,180,229,53,254,166,201,220,10,14,58,33,230,72,92,230,207,170,109,188,229,137,28,147,22,41,192,213,40,215,216,127,14,228,9,13,85,247,106,247,1,155,206,136,4,23,190,148,170,106,194,155,170,96,227,85,168,247,195,20,113,172,17,34,38,123,79,167,110,206,207,53,66,173,162,178,166,84,120,160,160,218,186,227,34,87,100,212,219,28,84,255,59,138,26,28,227,102,205,94,75,152,55,216,163,46,225,96,152,57,32,57,159,27,251,178,201,231,5,139,31,163,136,69,71,125,19,213,46,252,84,88,215,163,249,153,181,25,227,174,4,105,93,98,251,60,164,4,222,26,165,85,83,87,45,206,132,134,6,108,89,96,76,139,144,143,144,116,59,72,48,184,248,230,195,135,167,29,166,42,207,49,87,221,159,42,168,96,157,181,125,152,96,130,72,48,100,105,145,96,98,200,116,7,131,166,69,99,117,55,141,40,125,106,249,33,118,191,121,159,138,79,27,90,132,13,52,0,61,44,246,212,77,127,107,26,124,234,104,26,14,238,68,79,124,247,99,81,60,135,27,62,83,231,104,214,53,69,104,188,95,120,30,105,222,150,218,223,80,221,209,86,113,125,226,123,36,1,136,94,206,253,124,34,218,2,77,208,172,39,238,148,151,111,237,3,135,99,41,22,142,129,39,56,105,255,31,62,12,171,5,206,94,114,13,174,185,89,199,225,131,239,187,92,132,102,86,138,156,36,55,112,65,191,209,70,60,75,110,59,216,180,148,36,118,238,139,97,222,17,236,209,68,163,76,177,206,58,196,113,2,166,47,131,113,199,180,134,23,174,24,119,20,124,144,29,221,9,90,224,188,131,232,13,244,94,200,129,51,27,11,124,24,154,5,91,171,150,238,212,117,175,71,155,110,168,3,236,162,196,193,74,101,6,238,157,132,151,181,88,122,26,84,194,170,253,198,124,142,133,185,66,4,105,5,152,87,209,178,134,243,242,197,214,209,103,53,218,128,193,9,83,231,55,111,29,235,133,45,107,115,71,203,15,1,69,200,105,216,1,163,183,18,222,54,6,56,48,104,228,237,119,166,90,242,184,97,160,218,194,255,151,131,120,180,104,202,167,157,179,147,77,161,34,65,201,171,236,177,175,0,92,134,255,40,217,133,61,187,44,165,109,184,127,37,189,61,62,60,232,182,210,78,123,118,207,185,156,158,77,117,67,26,37,222,174,87,192,241,152,180,170,218,35,86,86,91,87,98,97,192,129,140,194,233,36,79,152,203,136,73,223,63,26,117,190,88,188,60,42,9,45,54,223,198,207,196,237,26,244,60,233,67,132,223,113,147,253,16,126,10,119,41,159,99,237,109,167,23,248,146,7,166,214,75,0,234,202,90,254,26,71,82,240,116,216,96,236,109,46,104,255,134,115,253,155,36,36,129,188,183,140,151,14,153,244,139,244,252,214,160,8,249,226,35,58,185,116,255,126,128,120,235,190,225,169,185,175,255,64,176,56,247,249,7,18,39,92,249,142,98,47,116,247,126,6,66,208,245,253,217,123,160,123,49,99,18,90,47,9,80,207,212,123,18,61,155,193,44,242,205,146,4,96,210,222,194,220,47,172,241,165,29,155,45,163,105,121,174,115,233,211,216,182,136,24,90,234,77,214,70,94,160,35,59,16,39,71,24,186,43,251,99,53,11,47,60,159,24,144,250,41,114,90,26,97,209,154,96,63,178,67,28,211,107,179,90,253,127,165,163,26,175,163,165,60,47,25,151,210,245,25,91,122,31,176,184,179,128,161,75,71,166,119,40,19,58,101,115,237,145,211,239,250,235,224,4,46,64,94,118,213,191,21,42,27,169,75,217,193,182,121,215,57,216,234,245,160,135,78,21,125,113,51,250,39,177,32,227,61,57,182,118,16,212,181,130,153,240,62,148,127,188,127,160,37,3,231,33,68,181,179,95,116,179,14,247,145,214,104,222,71,140,17,161,171,218,105,81,195,25,20,202,235,110,70,90,42,47,194,109,74,85,60,77,65,92,205,106,16,171,147,0,227,16,251,48,224,101,8,46,29,94,50,36,213,78,254,13,7,254,227,219,219,18,45,213,145,136,25,210,42,32,47,62,61,139,31,140,17,210,249,37,178,80,160,59,139,26,250,178,179,208,129,81,82,239,54,209,224,20,156,174,251,26,130,136,28,68,243,28,42,28,17,51,90,6,39,125,11,249,223,165,193,243,148,129,17,210,146,186,89,202,253,59,205,5,52,237,17,181,104,92,54,142,214,177,178,59,214,195,73,72,186,175,17,1,0,220,146,69,144,120,89,133,146,152,239,230,141,237,0,78,250,117,54,179,45,38,167,90,149,136,233,115,8,227,210,205,255,208,177,5,45,173,12,189,122,109,122,136,191,40,176,51,234,201,4,208,42,147,44,56,120,17,43,69,93,97,143,103,130,166,129,101,7,40,85,92,157,218,212,230,114,139,2,233,64,93,127,49,140,232,168,194,0,74,215,40,158,61,12,247,57,151,103,148,42,210,155,139,211,87,19,0,208,70,224,199,34,241,199,70,169,161,135,61,105,233,172,62,114,0,96,15,45,231,45,55,172,39,55,41,225,133,190,138,162,53,142,120,95,183,32,192,36,208,155,102,233,86,61,53,30,206,83,199,125,72,101,207,29,247,104,10,148,18,184,234,165,202,151,116,193,119,185,112,23,192,20,152,65,174,8,254,94,56,95,112,30,175,131,75,160,36,26,226,61,55,97,225,40,77,212,181,0,239,155,198,208,128,240,202,248,190,135,42,46,22,94,11,61,30,199,55,16,98,142,1,63,173,36,147,172,74,152,45,239,201,204,46,115,27,81,227,120,112,155,184,99,79,214,130,147,122,64,139,9,147,208,82,76,15,123,98,5,74,218,198,40,175,162,34,226,243,95,227,126,94,45,242,141,118,9,49,66,13,62,135,201,56,200,96,255,212,204,11,3,243,18,242,108,74,227,62,173,115,180,224,226,248,249,141,136,245,6,158,110,65,8,248,189,225,236,226,84,45,8,72,133,12,176,12,140,172,135,245,88,80,88,0,185,175,79,207,75,134,219,100,194,29,255,125,135,114,8,126,63,172,235,145,65,229,120,37,197,36,66,254,60,122,61,197,192,6,79,197,152,198,219,179,231,14,155,211,69,154,175,209,49,59,91,6,25,138,1,144,199,28,148,67,149,19,37,147,101,173,173,206,196,37,179,47,184,185,251,43,182,74,221,246,66,82,220,131,113,87,197,241,66,226,95,156,93,186,196,250,229,244,248,189,22,207,27,43,104,3,210,183,207,145,95,190,74,251,145,107,71,36,138,225,83,79,207,145,78,210,137,175,90,23,239,94,181,98,41,136,109,211,114,150,87,255,49,149,169,69,132,65,211,140,205,214,29,22,127,210,12,110,19,72,139,152,200,229,246,220,110,222,227,189,5,36,90,254,53,6,237,122,57,142,108,23,90,140,146,218,237,207,124,148,18,43,1,231,98,177,83,35,133,156,57,105,201,222,84,80,168,12,176,33,62,83,81,72,91,127,176,136,94,105,255,254,90,145,155,68,132,45,203,4,81,16,2,218,66,189,227,170,31,12,196,122,121,143,12,99,122,129,195,234,210,79,14,55,209,162,72,6,182,66,57,203,144,165,124,104,28,239,250,145,78,30,73,201,115,103,29,184,58,64,70,85,21,63,220,48,82,120,182,147,193,160,57,159,29,228,110,185,119,116,208,106,226,116,121,81,43,222,244,81,208,45,54,252,92,150,203,97,118,228,145,19,251,135,68,118,217,134,205,225,179,191,233,152,12,91,197,183,100,112,245,155,90,49,164,31,226,11,161,97,101,12,52,104,87,67,185,88,236,186,244,207,7,33,67,86,181,69,233,84,8,132,228,204,119,32,165,140,91,72,140,72,59,85,160,243,119,182,101,202,174,103,225,103,157,66,245,6,239,65,118,228,82,220,95,37,111,101,138,161,191,68,163,207,254,132,5,33,34,56,45,15,145,79,100,40,250,236,235,36,175,245,20,209,154,13,198,149,155,0,80,11,84,80,172,105,217,187,232,7,132,48,231,150,103,105,189,165,83,77,153,247,75,244,46,186,175,219,208,150,199,180,28,58,132,148,105,13,207,113,32,133,101,252,13,167,207,239,200,38,246,25,126,101,156,150,20,134,155,28,193,203,237,91,8,31,34,172,248,160,57,105,219,239,42,133,226,116,81,43,132,235,167,30,68,43,231,221,164,52,182,249,179,61,153,161,159,137,151,189,73,236,246,163,36,98,19,85,248,126,173,105,179,75,212,179,6,192,100,128,153,211,199,108,66,203,86,207,169,95,199,34,119,154,244,10,13,220,112,98,175,183,40,113,55,27,57,116,86,1,170,179,54,173,252,94,178,69,116,19,143,251,130,194,112,136,117,223,38,229,127,85,195,14,156,30,223,71,155,223,129,124,152,171,136,110,120,95,180,53,100,168,25,3,216,42,54,85,46,69,119,107,155,145,251,64,53,185,193,15,13,139,6,167,11,60,47,89,97,48,152,126,89,204,146,71,95,57,111,150,78,240,251,102,115,113,11,147,15,192,253,231,25,248,245,109,134,153,56,58,101,46,144,2,253,31,2,83,198,61,64,121,63,76,80,67,29,12,66,28,147,254,92,69,68,35,212,156,221,161,237,249,146,56,121,137,145,156,246,183,247,139,124,62,163,212,103,229,186,93,174,69,23,160,26,196,181,43,175,176,60,110,211,55,131,146,61,179,46,79,154,194,63,7,77,202,244,150,202,18,92,217,129,241,239,222,111,51,135,13,231,255,23,171,205,2,165,228,225,46,247,213,245,181,190,140,154,241,182,186,251,24,83,159,137,53,64,138,170,164,60,147,27,90,82,193,36,201,173,182,188,108,188,229,45,193,211,18,253,200,185,25,95,180,93,30,219,69,195,239,222,97,161,110,214,36,114,96,168,76,77,164,53,131,226,197,100,0,42,106,159,84,214,55,249,124,216,170,102,155,118,134,77,181,65,115,14,167,123,89,46,212,228,181,29,222,148,86,228,253,74,236,231,197,148,188,137,167,27,127,12,253,186,84,67,146,211,91,131,122,218,230,239,254,175,168,1,213,249,121,7,221,136,146,201,36,166,47,73,221,190,128,205,126,206,89,121,78,233,57,64,136,20,67,198,178,249,191,17,131,33,149,197,130,104,170,130,142,237,246,170,147,192,156,248,187,123,25,225,139,220,171,61,24,24,114,110,77,3,160,244,82,56,94,113,16,27,118,228,217,56,29,253,10,75,145,97,193,150,89,210,52,60,146,17,127,187,216,5,195,108,15,251,39,157,158,86,49,193,199,155,106,6,73,80,247,203,61,88,81,56,93,158,179,40,245,81,68,136,69,32,237,101,122,112,165,100,55,9,127,59,26,9,41,16,102,92,246,179,125,108,231,225,63,120,88,135,69,195,239,197,51,245,72,72,59,15,231,42,3,184,123,64,176,64,2,15,246,220,67,193,252,8,159,56,20,44,137,45,172,109,183,204,159,101,6,17,221,228,44,160,69,242,153,202,128,203,12,4,126,92,35,50,234,50,118,36,235,41,31,25,142,113,24,62,9,95,20,19,50,125,158,204,53,186,86,53,189,102,153,228,219,22,2,99,14,143,147,221,199,23,113,107,196,224,225,104,121,99,34,19,112,121,28,191,160,245,10,17,84,184,88,225,151,167,54,240,195,72,254,120,18,22,155,131,146,29,227,234,30,101,250,135,69,125,243,191,220,108,252,27,73,15,229,136,53,207,18,173,204,19,205,199,182,167,225,33,249,143,99,91,17,55,149,227,252,128,238,114,212,169,242,145,36,176,68,219,87,139,157,11,63,61,59,211,206,153,189,127,223,109,58,97,39,141,146,29,253,92,94,80,25,18,106,154,118,230,19,134,225,160,83,60,150,40,14,114,137,33,215,197,110,48,190,240,56,91,138,248,129,37,247,39,83,175,2,103,194,229,110,102,216,12,120,6,3,226,163,55,78,249,252,111,226,91,6,137,148,130,47,48,247,229,23,243,182,71,150,137,124,20,124,66,139,32,193,148,161,185,236,79,174,99,200,112,53,55,117,29,34,237,204,153,30,100,212,1,178,63,101,108,21,60,226,164,189,178,191,164,14,130,253,211,82,162,209,199,23,248,243,208,248,249,158,141,215,199,86,0,246,74,146,131,115,160,41,65,31,203,224,248,194,77,33,67,47,171,200,140,46,76,21,188,172,177,183,243,246,224,185,32,56,122,180,233,201,25,233,15,85,45,133,25,16,136,35,136,145,142,15,86,80,133,48,119,224,178,65,40,193,213,90,108,89,160,56,151,217,217,57,103,175,63,242,81,89,154,80,29,72,39,62,162,124,64,207,184,236,170,24,70,121,44,61,235,14,3,108,68,201,57,178,69,188,58,91,211,235,251,154,69,34,123,86,213,66,253,253,216,176,67,99,197,91,185,250,198,244,215,134,106,130,27,155,101,61,23,181,173,83,247,184,185,24,221,87,94,129,150,24,83,250,180,99,14,23,157,95,133,189,98,219,252,120,118,181,213,41,131,138,220,245,32,75,155,209,55,31,197,21,188,175,14,108,96,144,219,70,87,169,105,80,215,39,54,253,164,135,220,113,179,11,26,86,90,17,173,82,168,51,234,219,159,197,190,211,12,96,163,96,156,21,216,237,81,71,8,238,177,222,65,238,18,207,224,198,6,78,77,58,229,128,113,49,80,53,64,60,188,235,183,243,253,19,186,159,48,179,25,11,199,176,100,249,48,94,85,170,164,215,111,157,248,47,235,115,199,148,241,90,5,156,158,194,36,48,2,128,54,251,107,121,73,162,149,9,148,65,58,167,164,203,170,52,197,196,44,120,167,22,204,41,135,101,200,149,248,38,73,57,71,205,69,158,255,72,185,219,30,199,49,162,53,242,190,45,142,206,11,94,30,40,120,221,10,171,209,31,64,30,69,102,138,222,180,169,4,28,97,34,15,174,50,15,217,31,255,141,56,24,233,173,156,216,252,142,255,94,59,43,223,147,253,34,44,189,10,93,55,252,67,27,40,123,12,243,5,33,140,234,16,240,115,171,26,131,179,201,114,216,135,196,14,204,11,226,91,159,139,238,182,65,152,10,212,173,146,189,31,16,197,251,214,140,176,101,41,217,127,19,65,118,112,116,119,159,28,52,102,175,254,92,132,73,106,70,124,121,229,34,136,208,230,102,14,165,73,4,170,233,83,76,138,148,54,152,21,227,68,40,188,180,162,79,72,48,228,26,205,64,66,33,171,221,163,170,114,114,184,172,219,201,168,200,24,77,52,12,80,226,95,105,205,101,189,221,3,5,202,38,226,148,208,76,126,116,245,120,125,186,56,187,96,82,46,133,211,10,66,86,187,156,137,23,160,98,171,226,232,11,114,200,18,250,211,87,122,21,93,163,90,104,194,160,53,194,74,207,94,195,91,24,76,184,136,174,136,22,245,12,54,167,76,106,249,48,251,40,188,97,95,223,30,22,142,194,231,189,143,57,151,51,105,150,197,223,211,167,34,90,118,91,128,229,236,240,185,96,234,208,26,179,111,122,244,232,80,12,38,10,75,30,38,189,236,165,19,26,106,197,252,71,235,185,204,73,177,213,143,142,148,0,198,150,67,125,250,112,233,80,164,49,60,6,157,40,93,68,163,97,177,11,138,69,11,80,35,151,37,226,112,83,104,68,199,208,112,120,18,122,5,174,225,120,249,246,187,239,139,207,193,43,156,214,226,0,98,218,49,189,224,164,249,146,98,223,125,50,17,156,249,81,199,227,5,93,233,167,93,238,114,241,192,104,44,145,2,60,79,168,0,112,62,78,120,31,150,105,225,33,243,194,10,247,239,80,186,67,248,147,112,190,206,149,49,185,35,4,129,193,254,128,152,100,164,105,79,44,168,54,203,1,129,230,43,92,174,4,56,200,148,20,82,211,212,136,193,83,214,240,81,138,39,11,132,114,55,99,194,4,143,40,233,177,238,255,46,166,183,5,115,190,182,171,253,136,6,248,32,219,26,252,55,109,189,224,176,219,6,131,136,170,148,101,102,58,242,121,97,120,125,146,126,232,251,70,200,193,191,199,169,112,172,43,218,147,205,17,215,99,9,141,194,206,149,104,71,115,45,250,190,121,28,115,88,81,131,250,172,238,160,98,146,119,165,113,166,10,172,34,174,43,44,119,114,32,110,169,188,210,22,181,71,3,8,218,196,202,103,105,234,72,209,168,202,3,206,120,58,52,91,169,202,207,73,67,52,223,246,40,85,129,186,17,147,193,231,46,110,139,178,74,210,186,252,20,42,212,66,107,31,239,184,60,105,247,138,212,29,59,35,147,239,109,123,57,144,11,149,66,71,134,57,20,223,47,197,51,83,184,140,102,217,213,245,43,232,173,139,129,135,141,23,147,64,170,6,101,154,52,47,242,34,140,3,101,199,41,95,122,146,104,251,210,114,60,120,85,93,235,23,132,185,200,46,225,58,185,30,23,139,234,67,231,176,36,70,216,129,111,57,23,74,254,117,89,199,41,209,178,61,214,211,184,105,167,86,249,49,90,42,123,168,58,104,222,200,67,41,108,0,17,167,116,177,110,201,116,233,182,36,97,100,6,194,14,109,98,123,229,192,135,60,139,212,178,229,24,178,75,57,129,64,124,38,73,23,182,0,233,69,40,62,242,69,133,151,96,88,46,115,166,144,227,171,12,67,150,150,224,205,128,11,68,98,7,65,199,98,217,18,163,103,246,75,237,111,191,192,188,237,204,240,118,109,98,193,54,170,132,185,37,96,110,213,152,18,190,35,50,82,137,93,149,215,225,221,42,90,5,238,158,171,51,61,216,167,102,11,175,66,32,95,200,136,58,38,185,31,31,7,154,137,77,199,135,129,68,11,138,218,56,51,63,138,232,178,118,35,168,128,222,75,254,4,133,240,20,138,225,42,242,179,147,238,252,236,171,207,216,158,161,187,121,28,211,191,97,168,90,83,211,109,149,65,124,180,9,172,11,247,233,144,178,35,236,201,59,110,14,121,70,14,224,61,254,78,212,28,174,65,117,240,197,140,63,81,231,180,236,142,119,35,45,55,146,227,92,243,89,103,227,113,113,7,241,196,218,216,222,133,210,176,201,227,29,129,190,164,242,224,9,230,82,122,179,114,75,246,39,15,229,149,39,223,54,20,209,236,251,52,201,186,78,73,37,151,126,3,228,78,186,96,42,131,8,164,251,31,66,192,181,12,97,55,186,77,32,219,199,151,33,3,42,85,29,142,29,6,107,115,68,114,214,114,140,199,143,20,245,129,9,78,83,246,169,65,41,122,99,69,204,115,173,8,254,95,66,163,162,48,175,244,113,209,100,147,112,188,220,233,113,5,212,201,138,91,38,191,72,7,99,178,116,234,92,48,244,0,211,154,27,247,206,232,89,85,99,233,132,72,85,200,139,238,153,179,24,123,99,134,246,142,188,239,9,157,112,162,234,185,118,245,59,130,224,204,31,163,171,38,159,221,225,99,216,177,58,35,104,109,10,125,89,23,53,56,37,68,165,189,60,83,249,63,161,240,70,141,1,210,143,125,157,56,227,11,24,55,38,168,16,119,213,155,223,143,131,175,37,234,125,238,16,194,101,201,158,4,110,18,210,221,84,87,14,13,169,250,241,240,1,12,205,98,246,198,75,250,239,249,104,97,127,57,19,15,104,126,28,59,196,119,32,32,82,17,212,81,175,226,118,175,241,105,177,135,71,82,187,16,240,159,71,37,41,230,115,64,156,184,169,24,234,219,0,246,117,253,167,73,143,69,3,130,245,116,43,177,166,154,119,212,153,47,46,26,192,155,252,200,241,110,201,195,252,231,181,147,45,221,62,85,89,150,72,79,230,174,245,52,49,209,202,184,143,160,9,190,63,249,33,193,163,53,123,237,31,46,225,42,225,49,158,14,120,71,133,247,37,52,27,195,168,0,173,254,175,48,203,127,136,142,20,140,58,102,224,52,13,72,195,143,146,84,91,160,228,92,126,63,39,81,150,207,232,13,28,22,22,113,169,45,140,23,5,46,155,127,197,116,25,54,226,104,89,169,95,100,83,211,41,119,115,107,60,190,170,12,213,173,189,220,228,10,211,105,116,245,166,208,229,181,165,201,68,170,57,36,97,78,110,76,75,65,230,77,138,17,146,196,148,196,16,237,121,105,24,158,75,121,236,185,205,129,31,100,68,181,179,248,183,65,29,74,96,126,223,176,27,19,62,148,147,12,48,70,173,22,7,123,162,216,137,16,123,171,81,196,100,84,138,92,119,3,209,28,49,46,184,35,78,201,26,213,233,176,139,204,161,161,100,134,151,46,27,220,236,243,154,104,171,179,29,24,244,219,213,4,109,217,17,167,110,219,11,225,255,47,80,164,122,91,85,104,133,179,78,39,122,132,12,176,53,220,175,184,93,42,5,93,129,217,176,225,1,179,77,53,121,239,203,231,143,218,94,107,129,31,11,195,254,148,78,105,60,149,153,223,20,120,153,7,211,141,71,154,236,170,254,85,202,104,196,108,18,145,215,252,129,244,163,252,137,151,112,146,157,1,59,187,240,13,15,2,216,118,65,35,126,38,27,221,174,235,245,160,106,120,196,95,105,214,48,54,136,226,74,65,88,37,3,224,245,60,140,2,150,249,134,212,251,59,123,169,14,76,79,118,67,227,62,202,182,40,50,114,7,24,44,54,254,33,251,230,193,198,191,167,178,228,71,214,100,187,93,9,99,58,230,102,178,170,160,39,178,130,14,57,7,70,171,249,174,14,35,35,120,237,233,152,182,162,97,118,134,142,150,24,7,159,154,144,20,178,175,155,125,114,58,253,140,118,189,3,236,201,17,137,170,158,6,138,214,209,52,137,203,102,157,11,99,113,92,97,55,117,153,111,20,219,251,13,105,77,46,143,89,53,195,147,116,53,124,195,182,95,154,49,226,94,206,124,56,128,210,109,131,196,167,229,110,5,138,241,184,84,170,48,209,20,77,49,194,144,208,224,23,8,82,52,152,83,235,136,168,48,59,7,125,42,229,139,89,170,227,83,9,67,233,174,188,101,17,74,229,208,35,149,23,105,183,73,116,1,80,193,46,164,25,242,129,1,17,88,87,87,94,55,96,126,151,60,35,202,219,9,3,222,161,131,34,149,198,202,198,131,167,91,75,106,85,22,230,193,8,201,156,81,226,164,111,44,147,161,162,209,240,123,26,148,30,161,104,16,29,236,170,204,149,74,126,34,109,24,139,125,1,32,228,137,89,30,201,147,146,189,177,123,185,72,228,107,91,49,121,163,27,243,72,155,29,183,58,67,212,196,210,201,58,31,102,67,158,141,70,175,80,213,3,99,198,124,34,110,94,209,77,20,85,45,162,82,18,61,189,203,199,56,131,228,230,7,53,226,247,217,35,66,115,37,68,130,210,200,156,186,44,33,11,229,31,84,159,92,194,52,14,158,187,179,106,80,194,179,80,226,202,110,147,204,167,44,63,158,49,55,80,115,164,46,156,244,58,137,134,55,253,220,75,9,103,136,249,242,3,215,220,53,123,17,75,112,40,131,105,76,0,16,17,245,242,195,47,165,106,200,206,26,130,189,65,203,2,99,181,5,143,191,100,128,52,249,154,169,127,159,85,163,175,105,201,79,170,124,33,172,15,229,166,146,194,104,108,129,91,132,33,195,224,4,116,61,113,89,52,79,251,121,2,32,71,98,121,115,214,245,87,160,16,97,250,177,149,55,39,223,212,203,76,231,248,127,176,129,187,75,9,209,101,237,148,65,111,200,193,164,44,66,237,159,220,85,84,91,89,208,128,237,151,180,31,151,237,151,16,114,221,155,43,42,4,83,34,238,79,149,66,231,157,222,132,11,145,104,170,56,236,84,248,183,36,85,4,10,143,170,141,177,87,7,163,114,225,72,248,238,122,146,203,203,157,4,155,198,245,193,60,218,180,175,34,89,80,195,35,71,85,234,238,86,77,49,244,128,157,230,211,30,114,38,88,35,242,190,254,27,132,194,18,236,121,228,133,95,97,44,236,154,28,64,235,14,62,141,6,104,2,239,196,0,239,190,200,189,55,225,88,118,166,28,3,155,39,73,135,166,250,86,28,103,243,78,21,135,177,206,135,183,141,13,148,181,253,155,176,98,53,113,191,110,156,23,111,210,0,12,145,6,255,146,80,247,0,74,171,33,213,96,90,118,193,89,208,79,47,247,61,246,11,199,235,65,231,27,63,41,110,254,129,80,132,0,167,84,59,171,175,164,131,185,207,179,36,207,187,236,180,205,188,150,112,119,170,82,180,155,78,6,33,163,196,74,97,85,204,95,48,248,81,22,74,219,228,3,163,28,111,155,134,69,37,9,187,242,25,75,186,8,17,151,196,130,59,118,14,82,207,194,129,82,65,199,147,72,96,117,243,22,125,145,219,206,184,153,41,144,219,98,96,155,34,94,181,44,163,237,168,33,89,151,218,192,247,57,198,126,236,197,141,63,109,159,157,29,83,185,46,181,8,73,42,95,252,161,116,224,219,172,169,119,219,52,46,170,69,178,172,93,174,0,45,81,139,114,181,102,240,100,159,66,137,156,200,175,244,173,51,117,206,244,24,77,6,23,82,12,37,118,160,225,85,183,69,79,100,126,129,93,155,18,95,145,39,32,118,241,90,236,152,14,20,126,31,234,84,34,120,172,90,243,50,162,34,238,83,91,24,255,99,225,240,27,114,166,100,243,207,98,170,111,107,224,19,79,177,203,231,135,126,205,13,231,108,153,215,16,143,6,18,244,71,18,188,143,224,169,189,54,129,185,202,121,10,142,246,219,251,81,92,184,115,207,55,223,23,9,172,6,80,2,236,96,4,51,62,54,135,46,10,0,229,235,188,235,218,127,115,177,136,157,40,2,71,146,32,245,200,137,190,179,220,117,208,242,197,14,183,79,124,35,171,203,89,139,208,30,50,32,249,148,242,236,98,48,88,255,143,25,1,235,159,210,127,229,219,6,20,19,41,23,220,116,32,214,217,7,197,244,101,247,93,18,117,151,140,84,68,104,42,232,36,226,57,55,57,181,128,52,6,203,130,54,199,103,197,158,184,138,127,61,223,65,111,57,25,181,72,139,155,65,139,48,15,128,95,194,241,163,12,246,39,191,53,212,114,194,90,65,109,13,121,48,171,160,68,35,192,251,149,193,182,207,178,158,107,32,192,59,214,166,145,205,76,194,17,236,248,105,195,184,201,91,214,106,71,163,206,253,189,15,166,160,158,55,182,108,213,82,244,47,221,194,227,48,139,93,104,165,186,46,214,47,63,142,36,158,192,116,253,133,77,50,45,85,208,33,203,120,156,6,55,217,53,210,131,30,194,170,65,32,80,32,81,218,104,125,77,236,131,42,23,51,41,208,230,40,175,127,201,126,254,209,89,221,187,181,101,185,235,139,217,248,49,187,232,192,124,28,52,88,70,236,155,38,60,43,157,178,180,45,203,113,4,9,67,86,60,136,52,5,61,152,126,254,205,152,68,61,64,58,226,75,218,19,204,177,16,138,148,243,180,234,110,6,134,194,139,167,50,151,95,62,160,137,209,208,255,81,199,177,240,114,1,163,160,235,235,172,203,57,245,240,94,121,56,11,132,16,23,152,180,38,90,26,107,103,77,223,70,133,160,220,55,161,159,238,135,127,195,39,208,86,53,94,195,241,255,207,90,238,9,252,64,51,154,107,238,114,42,193,58,242,19,108,172,209,86,71,42,197,80,100,152,114,254,57,174,37,64,50,36,160,251,173,106,84,18,16,170,209,101,166,151,240,142,96,134,97,50,207,93,244,231,22,49,72,181,188,188,85,53,41,160,158,84,157,23,30,169,226,115,33,73,115,107,143,0,226,138,147,191,74,190,144,231,29,158,45,154,232,182,228,53,105,112,118,75,176,179,123,111,233,14,139,90,157,138,223,14,191,88,106,91,191,149,119,119,125,12,238,211,244,188,43,214,146,153,165,147,172,221,81,131,160,19,124,234,236,188,144,176,73,96,127,208,169,247,17,186,160,163,61,186,59,233,72,217,58,90,43,43,23,250,105,188,236,66,19,98,125,250,90,130,162,167,174,46,218,37,184,26,92,237,34,0,26,104,74,167,221,23,105,113,9,187,125,231,185,93,92,121,93,23,185,54,19,90,235,249,3,121,58,43,88,53,140,51,45,206,210,228,223,67,147,216,82,11,167,178,164,218,132,152,116,134,84,112,15,165,106,15,116,46,222,118,186,76,133,157,255,99,27,35,96,230,14,223,36,164,244,30,234,71,169,225,124,239,103,239,185,44,71,223,241,177,16,211,173,64,220,127,244,65,244,249,195,214,90,121,43,248,177,241,128,96,74,224,104,16,53,79,225,14,219,175,78,129,103,35,184,131,156,66,49,75,196,237,145,109,124,157,74,188,157,84,32,153,170,210,235,165,6,155,60,118,114,50,169,40,37,1,220,122,220,107,20,39,19,238,244,128,227,140,103,0,179,250,11,140,38,165,57,63,111,193,84,165,175,223,21,24,232,153,190,211,114,99,96,103,146,32,24,107,66,117,93,27,243,49,114,246,219,30,34,20,17,69,183,243,131,101,22,123,146,89,58,14,130,29,141,36,211,54,162,164,189,208,207,2,157,64,29,178,133,166,206,71,226,123,104,195,207,127,14,140,247,187,212,124,199,222,83,46,134,206,111,75,190,63,73,82,47,139,200,197,11,130,44,168,239,104,124,162,31,115,106,15,77,72,8,188,215,102,185,145,177,146,105,215,243,128,236,120,202,35,200,18,3,56,41,51,228,233,136,75,253,209,15,226,133,173,67,184,30,89,158,18,91,156,153,18,111,152,178,1,79,85,158,151,216,76,58,134,155,146,49,89,17,51,188,208,128,156,11,43,131,131,106,12,149,63,166,121,16,63,219,137,51,65,222,5,172,189,253,110,113,53,167,226,44,245,31,50,38,174,100,68,22,13,112,212,36,155,239,195,60,53,18,123,223,198,86,22,195,153,183,238,240,84,186,32,5,221,42,82,204,140,146,40,142,221,64,66,150,70,55,47,30,39,14,91,230,39,190,250,204,44,92,192,48,150,46,192,2,42,75,126,145,237,31,191,38,153,131,36,227,179,79,231,201,9,204,104,33,64,247,81,36,153,134,244,72,253,218,167,247,131,248,178,75,238,207,226,79,244,209,92,176,76,70,26,233,159,72,80,240,245,86,236,211,60,129,147,52,202,224,10,121,136,140,72,97,73,10,133,96,120,170,207,50,34,150,192,32,223,232,196,218,17,88,13,218,31,177,119,20,156,206,58,133,152,213,248,174,186,249,107,70,175,113,37,10,115,145,51,107,100,20,219,82,204,77,140,219,219,169,215,58,48,94,235,31,79,145,66,12,48,214,3,229,197,44,184,188,88,27,187,162,100,106,211,186,207,12,7,55,129,174,102,0,79,203,232,178,166,41,96,67,20,205,236,10,17,185,214,114,166,94,180,205,186,114,55,253,184,106,217,46,50,15,196,129,214,56,81,178,117,165,228,136,107,226,194,252,239,232,52,189,121,119,33,227,225,214,234,74,40,173,225,105,36,9,32,65,235,127,209,218,119,230,246,90,85,92,208,117,25,145,241,125,158,150,196,130,194,200,251,49,170,85,124,87,213,239,96,184,96,197,63,244,187,217,215,49,3,224,114,164,10,22,251,65,108,238,13,29,254,18,139,129,219,58,169,151,73,96,64,221,26,16,12,14,12,78,9,203,11,80,73,221,118,103,173,1,169,193,215,109,126,166,137,12,12,135,17,81,209,32,12,131,60,0,153,66,201,121,182,155,39,109,173,1,186,45,253,219,88,63,179,91,22,106,108,66,107,17,105,97,59,6,133,136,82,129,125,190,184,234,131,23,198,146,94,243,204,25,190,50,160,81,176,220,38,215,41,120,112,38,74,163,171,24,106,116,214,231,194,77,99,71,195,47,141,134,111,103,119,122,241,34,5,170,123,150,232,85,63,156,112,76,202,78,176,136,79,161,164,245,223,119,235,27,8,99,121,57,0,225,90,143,129,173,209,102,133,158,64,233,181,113,212,237,35,132,15,88,36,85,226,152,217,11,16,251,213,25,7,85,125,48,155,221,141,133,205,66,237,6,5,241,72,247,133,199,177,78,236,71,27,110,205,207,241,40,22,141,156,101,179,172,227,30,248,161,147,84,177,176,26,32,103,36,110,30,67,137,223,121,255,110,247,94,76,30,149,83,111,96,72,165,93,200,58,207,176,213,13,29,75,187,45,112,179,43,234,213,242,216,43,249,33,207,40,167,96,46,219,167,44,111,57,183,96,243,201,5,215,73,106,130,134,7,142,153,17,97,126,88,35,57,154,246,15,16,48,120,187,131,106,242,11,250,99,54,230,135,88,172,62,208,30,127,145,236,44,247,246,202,229,174,206,139,144,172,167,141,73,106,163,33,202,57,80,76,67,219,18,99,153,119,22,223,8,132,90,173,119,88,241,34,158,228,149,129,248,73,110,153,176,170,26,33,117,151,227,204,107,181,26,21,245,164,236,219,77,199,199,35,205,68,49,148,238,100,242,214,99,155,100,23,181,56,99,13,119,225,107,153,143,182,246,225,208,95,196,75,114,87,98,134,84,115,210,91,16,159,38,83,255,6,141,147,176,178,28,7,98,154,157,117,22,186,222,203,229,195,97,78,111,21,1,209,7,216,220,49,206,103,113,12,92,248,125,213,205,208,125,25,23,255,131,122,18,244,102,110,19,246,57,97,29,160,122,12,249,191,178,249,218,202,196,118,95,227,2,202,72,253,166,224,126,142,247,255,235,17,182,40,239,72,49,69,198,190,146,45,197,143,72,232,60,106,114,24,207,64,199,21,148,63,154,255,94,65,161,221,130,35,137,115,115,180,84,241,144,61,126,156,106,22,242,150,187,185,206,193,114,109,233,188,162,195,80,84,37,148,76,38,233,82,107,55,196,65,244,142,66,169,247,79,119,3,176,143,31,254,163,250,36,254,95,244,199,37,243,80,12,199,218,35,41,133,113,33,14,19,65,68,109,255,12,46,255,36,190,184,245,158,28,243,54,230,255,252,10,28,140,185,137,52,36,177,174,246,253,228,33,46,4,171,48,142,104,247,44,43,68,29,108,218,170,183,172,241,193,73,207,219,37,138,1,150,130,219,251,45,165,77,163,56,41,211,48,28,136,245,232,57,137,129,92,21,128,45,154,238,208,32,231,214,120,74,179,72,201,37,186,206,84,50,7,123,49,12,239,253,65,164,149,178,102,109,53,34,240,96,200,137,6,135,145,49,172,151,73,182,67,200,127,30,211,36,85,185,165,56,97,54,221,209,90,70,22,143,152,129,15,204,59,5,143,171,180,132,244,145,20,44,11,142,181,72,223,151,147,26,241,164,157,222,7,97,79,43,35,103,66,163,25,155,118,174,109,181,98,111,56,136,55,63,81,51,89,250,61,148,153,110,132,172,218,99,18,104,242,83,175,53,197,209,126,182,44,53,73,229,104,21,252,214,227,27,176,170,31,200,156,251,40,253,90,104,145,10,1,175,235,135,77,56,137,11,51,99,233,59,250,122,62,196,2,245,142,86,59,143,192,123,130,214,245,182,157,134,228,82,199,243,29,167,83,105,75,4,236,116,174,50,18,89,242,200,87,109,23,221,184,42,3,82,80,103,135,218,190,7,129,98,180,64,149,196,181,217,136,28,58,56,53,14,16,248,30,82,197,85,149,53,2,112,81,243,53,131,126,174,187,3,237,209,3,20,9,246,22,3,194,201,118,169,89,116,66,199,66,16,175,193,47,238,65,137,126,87,148,144,167,191,216,137,23,120,162,24,80,68,168,161,148,167,6,137,56,1,160,59,75,181,56,92,175,90,233,7,212,173,52,242,167,91,64,194,196,220,18,71,186,221,224,84,47,76,156,55,190,180,102,18,21,27,55,125,249,219,154,48,54,210,58,72,73,154,78,48,73,105,233,200,178,230,208,130,172,18,160,79,130,20,166,83,203,232,203,108,136,211,228,152,192,103,222,8,46,245,50,29,25,234,254,228,47,202,93,242,41,33,139,115,212,186,141,90,222,177,4};

// The scrambling tile of 128x128 pixels.
// Each pixel contains an optimized 8d key used to scramble the sequence.
// The keys are optimized for 2spp in 8d.
static const int scramblingTile[128*128*8] = {34,84,55,60,39,66,75,70,156,6,79,158,252,177,119,233,237,130,224,206,7,240,57,132,94,234,21,172,214,81,213,214,71,65,12,198,14,174,177,147,75,156,252,141,201,34,111,201,161,67,56,14,183,5,106,95,170,223,254,122,148,83,189,54,126,56,91,76,211,225,38,250,10,203,203,117,114,157,132,227,243,224,111,62,204,171,34,178,5,68,179,69,50,59,64,234,53,21,126,13,123,70,44,215,72,59,5,135,11,186,181,115,134,184,253,186,153,215,234,132,147,34,215,236,239,253,248,33,65,155,135,247,183,92,47,175,162,23,112,80,97,249,253,253,60,80,72,201,53,113,168,51,19,180,44,26,23,42,98,167,14,31,100,215,115,110,57,131,212,88,121,177,45,153,21,21,20,160,160,130,139,173,127,164,101,56,27,207,202,245,213,239,186,75,86,185,1,39,26,35,52,43,175,156,131,96,111,253,142,252,135,93,94,162,0,67,12,211,198,231,184,203,231,215,117,186,123,130,246,168,3,145,81,3,69,214,123,230,106,4,134,228,120,18,150,220,132,233,92,138,251,206,211,72,119,149,71,110,12,54,75,13,63,248,11,124,54,221,2,218,43,210,126,23,1,146,153,234,234,238,8,207,164,156,97,207,26,183,240,189,76,200,231,200,232,35,44,221,142,78,51,99,215,219,131,43,104,136,182,9,231,154,0,186,170,9,32,65,20,113,234,255,3,122,199,151,222,197,236,148,153,125,242,217,198,160,82,107,211,13,110,153,33,229,54,227,185,76,223,13,108,218,254,88,92,210,156,136,219,113,147,111,54,84,163,54,86,182,74,208,165,131,236,164,31,36,140,12,91,153,211,105,228,60,49,14,210,25,168,2,99,164,140,170,142,68,194,103,80,23,245,27,167,153,188,64,137,152,184,3,221,7,125,116,120,81,201,156,147,41,150,245,236,192,26,57,35,141,80,254,4,93,204,255,121,74,106,188,248,28,151,27,104,214,132,11,161,87,142,164,91,159,80,66,38,8,194,235,44,124,174,206,168,116,158,125,236,148,128,124,232,185,194,178,55,75,205,74,107,43,32,46,108,197,252,160,61,36,54,150,205,149,221,107,107,66,246,151,141,73,171,126,5,243,239,55,162,44,97,155,187,82,167,81,111,3,228,188,110,142,67,207,105,130,191,129,57,13,34,42,187,210,199,161,235,28,240,135,233,156,1,239,133,150,145,65,84,149,160,144,12,165,71,43,3,251,90,150,42,249,127,160,127,87,219,212,104,57,82,153,178,221,24,114,220,29,15,1,222,56,49,51,252,78,214,172,121,80,131,106,167,43,146,38,50,253,200,188,253,206,146,119,67,202,22,45,29,5,234,18,86,114,73,184,45,158,186,81,123,208,52,3,116,164,23,255,187,223,69,154,14,47,202,81,78,95,221,247,94,163,2,71,47,53,150,6,16,91,234,236,124,64,83,116,221,122,164,211,50,209,224,45,67,10,113,134,170,80,204,87,198,182,45,27,1,85,241,169,36,138,145,85,238,249,67,101,169,222,55,64,222,67,250,244,221,137,4,53,178,99,175,183,16,152,119,232,17,3,88,118,251,116,51,138,151,168,43,150,218,168,212,233,206,180,155,157,233,235,173,39,188,219,87,163,22,116,251,19,207,36,58,33,215,111,124,128,237,140,245,215,45,255,99,255,122,168,230,255,1,122,205,129,21,209,14,145,55,29,28,106,120,133,7,63,202,93,79,240,5,172,183,8,140,65,108,164,195,153,2,254,148,242,223,162,167,210,17,129,239,122,226,36,212,202,107,102,83,75,44,77,217,100,51,214,32,200,27,42,41,4,195,116,100,86,200,27,143,50,126,234,131,169,169,204,202,248,172,192,18,60,227,167,166,128,121,45,216,186,185,72,104,145,103,68,176,114,151,12,133,70,28,219,228,178,90,173,57,193,79,0,16,221,99,22,77,161,138,26,207,155,220,0,151,189,77,247,6,102,4,87,201,131,116,142,118,110,129,43,115,197,103,5,30,246,3,185,179,175,68,130,209,8,96,7,61,53,55,243,41,130,17,71,102,81,236,84,207,212,194,164,113,228,133,128,17,170,53,45,50,240,155,127,228,27,69,93,44,42,223,182,179,185,45,184,178,11,188,119,161,1,193,52,201,253,79,230,255,253,56,83,47,207,53,84,220,58,254,221,104,231,226,167,58,140,135,61,21,242,210,19,240,200,120,59,227,108,131,12,37,156,96,209,169,73,24,178,145,197,55,2,64,226,222,233,120,116,242,226,250,240,178,98,6,160,14,98,3,24,233,44,162,252,88,53,8,231,208,145,136,26,178,203,215,176,143,20,129,134,129,12,159,244,202,201,3,77,191,82,102,225,137,135,86,250,125,173,12,68,234,253,133,58,159,4,16,250,252,152,70,147,83,234,202,87,64,171,187,180,186,183,190,137,1,22,163,211,143,159,38,57,52,99,112,200,107,199,70,210,108,231,213,175,210,177,247,155,70,219,198,113,201,39,154,217,1,214,199,250,28,201,149,165,158,67,163,176,44,145,11,195,129,131,4,59,238,196,46,158,14,236,46,124,19,55,218,204,78,197,71,221,90,163,28,44,35,81,233,169,136,15,163,80,74,3,219,96,113,248,236,148,227,25,8,4,250,160,4,133,117,130,166,154,122,39,10,47,129,221,112,203,169,212,254,98,122,226,44,53,243,7,147,120,154,115,166,88,197,110,114,6,108,108,204,139,138,80,100,128,44,30,18,244,118,127,177,32,102,0,179,207,90,67,194,65,9,56,204,13,170,210,37,41,209,86,187,245,189,176,128,68,89,15,110,187,18,245,42,8,116,66,81,98,106,9,162,97,57,44,3,180,47,208,174,183,240,240,109,219,188,90,118,113,61,140,167,245,69,162,100,220,74,105,212,145,50,61,218,163,17,16,22,200,80,148,125,63,165,118,87,159,177,148,17,15,250,153,220,184,107,24,168,92,69,255,62,150,219,11,138,191,106,168,29,231,134,241,239,214,187,223,114,223,29,185,219,72,135,161,38,144,130,1,59,123,156,232,136,61,87,185,147,44,147,126,49,12,112,58,121,122,51,31,33,104,240,219,30,149,251,83,245,160,141,225,230,167,108,223,83,35,106,141,161,24,182,82,24,107,41,186,191,243,101,51,148,41,100,30,65,13,46,21,38,195,122,227,24,254,239,205,208,2,151,237,212,132,81,155,0,42,182,166,3,188,178,156,48,129,121,107,101,110,59,237,82,128,181,157,79,8,236,178,78,97,207,116,140,44,42,186,21,202,63,37,62,163,87,144,32,215,250,4,187,17,55,228,83,104,176,135,113,32,67,123,154,214,133,30,149,231,47,0,169,189,212,116,189,64,232,231,162,44,85,254,11,28,37,72,68,150,119,28,79,204,150,198,217,20,159,226,47,117,193,247,94,35,121,127,232,165,113,43,106,110,187,8,53,94,211,20,28,235,105,58,132,47,155,25,54,181,208,83,191,184,157,244,213,54,143,204,224,246,84,51,164,223,190,22,26,7,26,161,98,174,178,189,40,218,247,132,193,146,245,129,76,159,32,202,23,119,51,32,155,159,223,149,0,197,126,220,176,41,79,210,125,108,0,64,223,102,188,85,60,21,46,26,30,3,243,189,94,85,104,149,146,15,157,64,75,207,242,253,109,147,119,35,44,127,163,100,161,146,133,170,68,89,216,198,59,136,151,98,135,111,23,100,203,22,178,201,219,231,154,15,146,180,230,124,235,14,57,137,254,118,162,227,18,204,73,234,213,233,20,22,145,252,82,38,29,231,187,254,101,188,116,110,153,220,247,2,95,228,21,21,250,51,11,77,150,148,72,77,185,49,141,123,57,216,31,120,199,8,226,219,255,151,105,25,83,37,81,222,132,230,91,238,71,173,16,253,109,177,60,75,149,127,202,143,170,48,95,30,137,249,133,98,109,69,240,136,179,1,70,36,202,222,174,236,113,62,169,73,148,86,130,213,4,102,172,132,218,35,51,157,244,182,213,13,234,228,252,252,138,55,141,97,254,144,42,200,52,109,75,101,63,155,203,85,90,123,210,19,249,35,61,202,59,243,52,117,141,181,97,128,64,82,235,102,103,33,17,167,179,24,218,254,53,241,89,15,102,231,59,131,188,224,139,51,25,71,177,49,99,225,215,157,160,206,65,239,0,252,148,211,45,250,15,162,162,197,135,224,234,8,39,28,62,101,193,58,178,24,91,134,76,244,52,176,21,22,245,235,92,173,251,233,246,0,166,161,111,139,115,148,79,38,151,21,178,52,142,197,17,55,189,227,227,204,236,133,72,118,101,63,29,7,231,27,108,188,44,177,225,73,139,68,167,15,218,34,211,172,44,216,231,243,41,57,2,208,17,109,232,58,122,217,213,194,18,197,235,143,215,70,21,119,105,142,26,118,129,227,4,170,105,160,72,174,1,194,215,187,163,81,172,237,198,255,0,119,76,230,34,166,56,204,92,189,213,99,66,39,120,167,220,237,158,78,158,145,140,183,65,80,192,96,211,223,229,197,251,78,28,238,42,142,90,134,26,104,210,156,187,184,169,199,172,58,47,174,123,172,1,137,238,82,210,83,58,231,80,172,125,55,129,94,224,241,62,252,118,84,189,98,225,104,178,163,181,52,240,244,54,173,144,223,96,125,186,193,121,14,117,181,0,181,67,7,108,197,134,3,11,119,126,123,55,16,185,236,118,29,104,175,214,214,20,175,30,170,30,137,45,255,173,68,9,103,87,163,234,68,112,72,237,221,49,217,135,104,143,60,158,98,139,176,194,9,115,105,52,29,1,173,72,227,223,234,205,95,65,74,212,149,71,155,109,54,117,200,112,173,27,9,25,227,42,171,37,222,120,109,205,186,195,143,44,68,165,67,132,234,96,37,204,17,142,237,95,44,84,131,250,119,40,215,188,40,47,187,128,138,74,162,135,100,125,21,139,56,238,250,124,74,155,55,98,88,194,145,13,91,215,186,97,230,55,64,159,35,52,218,76,29,244,25,246,191,90,136,48,75,201,143,246,95,163,6,83,62,18,154,53,99,78,203,188,161,85,231,242,154,78,39,255,246,40,132,210,104,37,136,21,215,59,244,134,15,77,190,105,150,19,167,36,195,166,238,226,162,214,110,80,45,192,14,215,16,23,119,151,178,110,133,69,184,135,72,105,156,213,245,156,205,175,138,3,154,23,122,39,70,228,89,118,174,151,46,61,240,200,241,3,109,120,36,185,40,248,21,38,40,55,102,109,4,175,93,67,237,64,114,248,11,3,236,119,185,238,48,41,33,247,242,34,123,146,158,4,235,47,156,43,78,0,100,168,175,104,246,230,127,51,36,225,147,109,72,125,191,202,142,36,38,68,180,25,230,23,242,69,16,114,57,206,62,164,67,202,78,194,192,73,146,198,99,97,55,186,237,191,91,117,60,27,180,73,122,193,135,119,119,143,161,1,159,227,185,100,174,228,202,237,106,162,172,30,159,248,74,109,221,32,165,74,23,186,194,223,159,96,26,222,10,232,21,249,67,143,215,140,59,133,185,150,173,99,110,111,137,176,13,121,29,20,132,205,140,97,46,89,240,110,153,252,210,187,189,26,87,73,44,126,77,196,86,121,48,192,121,232,239,253,9,12,140,171,80,141,141,31,233,254,42,182,132,175,40,231,141,185,86,247,137,14,186,103,235,128,6,11,100,146,183,79,161,53,51,145,195,219,73,30,143,158,66,33,91,45,22,86,47,14,121,198,97,234,99,121,230,208,50,56,141,61,227,166,121,40,132,70,126,237,1,207,55,103,177,118,58,197,115,69,56,163,182,139,226,25,131,130,171,138,43,128,88,123,48,217,235,204,40,76,139,39,255,58,16,240,185,57,111,198,74,172,69,177,157,40,139,87,42,90,55,2,243,127,47,46,170,250,159,137,13,109,134,64,121,133,73,225,90,153,113,92,241,167,54,192,198,101,234,43,19,83,49,145,59,192,197,1,191,79,176,94,158,3,221,71,199,163,26,170,64,223,23,118,83,233,224,80,8,86,93,82,20,164,249,104,85,97,197,6,168,83,100,144,111,151,90,185,23,110,144,210,200,194,238,235,57,153,178,215,110,108,79,159,96,138,79,59,232,35,33,244,76,141,209,235,68,165,84,35,253,248,123,183,228,121,220,113,162,102,115,201,97,200,205,140,17,54,40,153,223,15,150,93,165,244,160,179,157,36,96,11,43,75,134,151,19,50,161,43,140,21,97,48,108,239,246,69,111,133,24,101,115,23,72,154,40,52,168,243,102,237,121,193,4,237,39,81,24,6,94,59,175,223,229,184,161,20,62,146,138,28,136,21,25,174,129,37,57,11,73,142,250,209,220,107,68,108,246,217,223,62,234,98,57,179,239,63,197,178,101,240,54,125,74,252,137,36,115,163,131,90,29,6,178,19,168,4,143,175,96,80,84,198,83,7,164,224,164,232,4,120,124,81,22,214,199,12,123,139,241,234,124,17,80,29,61,224,57,172,143,86,11,58,187,5,149,217,152,118,101,224,198,64,7,179,160,205,196,229,139,160,201,52,204,130,152,38,236,137,112,248,33,177,115,78,116,40,92,48,24,132,80,208,96,108,64,115,39,145,241,41,23,87,1,220,42,241,20,83,101,164,3,68,63,114,154,160,31,58,111,231,49,11,83,241,185,80,150,190,133,104,244,56,88,228,131,23,0,173,97,247,219,173,198,208,246,48,199,157,161,216,96,229,58,252,177,34,236,123,208,159,199,58,234,112,37,59,233,160,141,127,179,95,84,8,5,205,235,208,10,8,253,94,246,179,156,90,93,182,233,84,20,253,179,134,220,105,219,9,253,126,219,201,129,253,160,111,209,103,11,130,237,241,206,132,106,21,35,23,185,165,202,9,37,99,166,102,55,105,234,190,77,89,205,177,141,72,102,99,233,254,144,246,32,150,64,61,242,28,242,58,114,60,235,49,2,136,119,166,96,94,84,64,200,188,10,233,94,83,18,227,3,6,49,252,179,200,6,89,117,64,28,40,120,137,253,169,25,51,88,15,212,78,52,243,94,107,7,102,2,169,132,16,126,125,137,120,167,34,162,174,17,1,49,55,211,48,223,178,171,120,112,70,122,134,126,120,248,242,126,145,252,50,122,104,191,157,222,236,115,89,20,171,150,55,79,125,118,133,107,186,114,130,174,8,55,74,201,99,252,38,154,157,16,226,168,37,101,97,70,10,66,24,83,107,9,70,251,119,10,178,195,207,116,4,141,168,70,50,225,216,51,146,177,148,140,145,242,50,11,224,241,20,252,197,88,82,232,159,162,71,116,180,36,209,214,116,245,121,234,106,33,162,4,160,138,60,137,54,121,143,63,4,164,235,104,194,228,41,69,107,155,19,123,214,170,197,40,230,218,68,228,10,250,154,242,27,179,21,244,222,158,235,152,12,87,93,44,88,13,53,128,104,33,35,25,16,215,132,217,130,113,204,125,92,228,71,55,117,194,176,91,1,50,176,22,234,222,76,29,151,35,146,28,92,92,123,250,33,98,203,130,108,184,13,87,65,51,119,12,44,187,50,220,36,16,25,198,45,72,108,99,208,178,49,223,207,198,254,114,194,73,79,32,207,19,101,33,241,203,23,158,25,75,230,19,63,134,249,251,238,95,207,106,138,32,14,10,190,167,166,60,131,175,119,98,105,83,232,13,26,203,61,71,102,212,134,120,89,225,175,250,41,156,44,61,18,81,197,16,162,48,206,29,45,46,132,5,213,31,223,179,3,60,210,200,54,94,142,34,182,126,58,1,6,172,141,217,22,243,34,229,176,38,190,247,197,21,115,189,238,204,204,0,45,40,81,48,148,239,250,236,164,80,44,121,62,120,21,125,92,179,22,69,183,61,227,104,245,175,111,220,214,49,149,63,51,220,191,225,179,206,95,44,15,220,131,38,240,75,56,113,198,39,227,117,242,215,192,188,65,175,132,4,243,16,147,200,90,78,69,49,40,168,113,16,202,89,51,145,127,237,113,81,104,111,222,27,220,138,183,56,49,166,193,204,131,93,69,187,24,70,1,20,200,220,138,158,72,43,174,188,56,35,247,1,103,118,146,19,113,104,144,96,186,18,252,181,67,21,111,82,81,212,93,218,220,14,110,213,42,12,248,229,0,122,27,254,172,74,122,212,21,165,233,152,220,112,58,167,69,18,182,137,69,51,146,188,26,0,118,229,134,146,132,40,32,240,230,24,61,63,195,64,91,165,146,171,170,255,137,242,160,60,79,125,142,143,102,99,148,240,108,106,250,200,76,175,209,183,155,222,175,190,2,1,144,52,22,171,219,17,130,184,172,193,235,59,124,247,138,30,243,166,9,201,27,78,92,132,197,132,185,104,123,158,18,41,53,77,202,224,55,19,173,117,108,48,167,154,223,157,233,11,85,203,235,171,18,218,142,188,168,80,171,54,135,181,132,5,74,191,43,179,164,88,46,115,153,205,121,171,94,98,255,2,21,159,7,58,2,144,142,222,61,244,103,197,64,245,40,252,255,69,217,189,132,237,100,206,124,181,123,255,119,20,189,202,111,22,245,216,225,9,17,252,145,114,117,161,50,37,228,223,124,218,22,24,249,129,100,151,207,153,236,13,233,100,189,24,143,167,231,65,25,166,113,100,232,5,49,194,216,69,11,37,231,79,41,172,254,226,195,74,187,214,240,115,75,195,198,217,126,45,130,234,172,221,94,215,77,148,204,119,29,74,43,81,169,174,65,175,27,255,106,53,131,53,232,253,217,154,185,73,131,66,150,192,117,228,251,163,38,203,210,118,75,176,150,213,224,44,23,183,161,69,169,180,243,116,124,181,248,43,96,198,81,59,149,28,212,1,48,187,206,188,98,237,177,179,209,115,112,200,245,199,54,148,205,24,31,151,127,40,15,21,155,216,176,155,17,118,99,161,66,206,249,99,43,203,2,67,178,90,101,125,40,177,203,3,20,40,211,85,7,214,37,154,123,229,213,141,53,84,246,122,66,30,34,161,253,213,82,6,10,212,30,223,202,0,216,77,220,131,120,66,86,11,180,189,195,160,188,35,0,74,112,183,30,173,20,105,159,195,54,204,226,195,222,79,184,45,231,121,223,25,60,201,238,68,92,91,89,126,155,42,242,5,46,211,68,79,11,66,97,205,251,116,188,50,70,196,65,76,54,89,101,24,152,223,214,13,242,21,89,104,53,133,165,36,71,225,137,129,65,137,98,190,135,180,40,231,152,164,44,46,75,152,83,155,195,81,235,130,24,113,71,76,114,208,11,39,145,44,1,209,56,117,158,111,33,76,89,162,249,49,208,34,4,105,190,211,146,113,239,223,98,164,104,236,167,33,164,169,32,14,100,110,79,209,10,42,228,92,218,195,26,236,56,163,216,8,156,124,39,5,183,23,74,25,140,244,159,51,230,206,136,35,148,204,56,147,37,165,251,254,124,10,66,236,249,128,216,157,145,79,209,243,133,219,63,78,217,54,92,202,212,64,8,248,84,186,155,192,192,56,35,183,137,219,161,97,70,254,84,9,175,10,131,159,69,17,142,91,243,213,52,10,99,199,106,78,211,80,155,38,35,196,143,57,7,142,10,91,45,184,5,21,19,64,221,171,1,54,138,154,53,13,24,25,27,237,171,103,188,79,234,240,49,77,99,194,126,215,143,33,214,201,176,205,254,227,254,129,127,126,25,94,168,138,64,253,8,170,118,211,98,150,92,110,144,254,160,224,144,49,62,220,127,73,49,243,241,191,150,208,165,38,85,168,161,240,35,165,253,3,122,80,123,109,253,87,58,113,53,179,248,27,170,171,203,136,133,13,23,116,252,19,34,177,238,130,142,66,242,203,222,84,94,132,106,139,183,46,127,194,27,189,198,168,253,115,157,254,172,15,160,102,5,56,10,178,242,111,157,207,45,250,49,159,196,179,83,164,217,122,91,51,40,28,186,47,127,227,85,77,122,136,255,114,14,6,191,12,166,135,67,213,174,146,4,75,167,101,138,195,206,32,95,108,251,196,71,9,99,43,209,86,101,142,110,151,126,64,35,120,223,214,157,158,108,226,181,21,23,89,119,116,132,179,117,172,58,63,26,191,181,202,205,164,79,118,62,40,69,97,130,7,206,219,77,254,85,249,158,67,237,204,46,162,143,68,102,200,147,251,174,203,104,121,210,130,132,79,99,113,142,107,88,75,208,241,162,93,120,200,189,147,103,160,33,94,71,113,143,119,16,80,111,31,145,238,71,181,243,231,49,11,164,129,83,223,61,206,242,77,207,197,149,173,251,37,206,144,27,40,132,233,140,245,23,102,148,114,70,145,84,20,227,164,148,63,11,124,124,239,74,19,184,173,213,242,163,23,203,15,125,91,97,162,147,221,69,171,159,95,37,15,100,229,50,14,182,110,182,210,131,119,157,144,162,197,69,183,202,139,151,8,29,152,129,32,237,246,253,146,189,250,204,98,34,96,26,1,139,7,43,48,154,73,166,201,9,76,37,130,80,214,239,171,100,151,224,64,9,175,94,228,166,73,96,48,80,4,179,184,225,26,162,106,116,153,188,1,135,80,219,92,195,137,168,250,4,123,156,148,21,43,102,16,173,154,80,133,187,104,90,61,108,178,118,70,241,191,123,109,38,144,56,230,175,66,210,32,88,246,143,225,224,227,176,166,162,222,75,8,68,139,96,10,43,235,236,19,187,119,185,48,80,69,134,126,108,37,69,25,186,225,123,130,246,44,193,185,116,20,187,237,230,123,95,154,41,179,8,225,164,227,102,92,219,46,120,14,104,17,87,27,199,163,91,175,48,234,172,173,20,8,20,138,228,88,206,5,73,202,170,220,155,99,221,158,175,140,245,150,184,49,220,79,144,225,36,240,193,72,81,12,252,126,220,154,161,66,31,11,74,4,177,57,231,190,186,64,139,45,46,119,31,241,205,177,83,190,76,27,145,128,121,252,48,222,101,219,2,233,145,175,213,178,110,121,9,98,244,138,166,51,26,53,108,172,26,203,245,222,159,35,111,254,226,124,229,46,3,91,238,85,46,9,155,254,166,106,164,31,133,21,101,70,241,23,130,205,176,56,88,169,155,188,207,142,76,188,103,6,43,33,179,237,162,9,58,92,255,198,139,101,42,112,148,192,189,144,141,151,14,220,155,181,221,135,71,52,71,0,190,189,83,170,246,234,61,19,210,206,221,186,251,103,104,181,150,101,17,147,90,226,86,119,30,12,153,184,168,227,218,186,179,87,110,16,27,224,11,226,134,231,71,243,93,75,41,95,14,242,198,220,24,55,238,66,171,133,197,159,152,84,60,139,201,118,19,163,95,40,37,43,102,16,185,52,125,95,230,93,237,43,204,215,198,37,142,23,193,27,170,76,156,66,34,60,148,254,137,157,232,245,189,65,80,127,104,49,185,146,141,252,235,114,164,7,195,37,200,10,137,196,186,211,165,49,45,85,39,143,9,154,222,174,53,150,144,14,102,109,118,62,55,22,95,38,253,237,184,89,104,176,61,63,155,176,2,7,125,124,247,214,106,39,55,36,44,110,4,81,27,239,124,171,17,28,128,246,202,184,1,154,249,197,95,74,133,46,92,90,17,153,94,59,85,90,182,25,208,150,42,108,247,79,101,251,22,54,219,142,59,234,143,5,6,171,175,97,106,82,230,178,201,6,87,20,170,139,153,142,90,14,28,92,236,75,51,55,122,95,201,96,204,42,213,68,68,214,223,204,5,75,154,85,168,57,135,115,210,118,170,3,213,133,174,23,22,132,84,34,78,143,229,125,84,84,239,91,85,20,228,133,32,49,231,182,163,182,253,118,149,95,237,44,125,148,81,4,180,142,39,108,135,253,218,125,97,249,209,2,195,169,90,86,80,65,76,127,19,55,56,178,212,100,128,127,230,112,84,4,113,102,228,86,96,26,40,136,236,61,0,219,188,124,73,183,248,251,2,101,207,145,134,20,127,67,65,142,79,163,180,255,38,48,28,237,130,31,63,158,61,66,130,89,132,92,204,111,238,244,113,119,124,48,187,58,43,251,196,86,183,2,78,235,75,93,20,30,143,244,225,82,198,213,160,71,48,185,0,33,189,153,225,119,184,190,22,193,144,61,217,198,119,58,133,244,240,203,171,237,16,38,247,135,170,33,248,45,92,147,121,216,1,118,48,125,223,225,88,228,250,154,9,64,63,70,50,179,143,19,113,43,229,60,140,212,10,49,191,250,51,53,64,26,113,182,216,5,40,73,63,160,130,141,76,27,174,245,203,202,24,19,88,187,45,245,227,96,210,215,183,194,109,104,242,91,74,239,69,118,179,75,41,125,1,28,163,57,53,194,120,196,217,134,4,204,158,120,98,26,79,135,201,233,245,29,74,129,81,195,137,204,172,162,20,157,242,145,228,83,112,22,96,85,26,231,25,200,24,126,7,208,44,18,36,123,64,78,27,11,74,128,53,4,232,119,239,44,39,224,237,54,14,129,117,25,5,183,80,112,221,128,36,128,203,34,51,50,216,1,14,241,174,63,54,183,179,77,99,186,252,216,3,21,141,213,194,158,144,32,172,178,220,31,247,35,19,149,196,19,150,103,163,212,82,96,250,127,226,52,68,155,236,55,184,149,189,73,32,15,157,192,166,228,249,27,249,97,122,78,211,125,146,205,22,59,23,213,150,138,23,167,65,246,89,62,81,97,117,219,216,188,239,135,182,232,123,148,114,185,138,160,252,39,166,49,213,234,26,110,148,149,48,75,203,88,184,205,55,223,72,255,68,161,75,153,107,238,228,194,95,108,69,71,222,174,34,166,232,233,198,134,34,74,190,196,38,10,146,203,244,31,247,212,80,102,1,2,185,137,158,206,93,235,197,18,102,33,243,64,102,172,173,52,40,196,83,228,138,216,128,121,72,237,147,174,216,197,247,249,87,162,78,186,227,229,125,151,41,3,45,151,168,19,2,107,88,233,116,171,210,64,102,188,142,17,2,126,154,177,2,252,9,105,30,208,148,119,96,60,208,19,107,146,11,251,189,167,54,89,202,63,134,138,251,242,46,193,157,30,65,71,50,152,200,246,221,35,227,15,50,126,107,204,41,185,171,142,139,55,161,195,243,87,250,187,33,87,148,143,219,215,62,223,75,244,78,92,158,96,75,77,175,64,254,40,21,48,238,52,116,209,6,77,237,163,56,26,34,86,114,223,39,229,125,112,197,236,209,252,220,46,188,126,186,119,63,108,184,227,240,242,85,100,206,215,234,222,175,139,20,206,200,134,62,206,245,111,36,88,144,3,147,110,239,177,5,157,54,154,73,142,178,79,224,26,82,24,171,65,211,98,134,248,133,186,77,19,175,150,115,55,183,155,193,110,250,17,99,103,237,107,81,7,180,79,9,228,118,42,252,113,110,111,86,21,29,23,100,103,108,240,207,123,195,88,225,20,151,78,137,110,8,123,174,17,58,229,34,88,53,167,194,89,240,24,58,39,151,39,130,159,201,42,255,251,17,133,5,141,28,98,178,226,234,209,34,218,222,147,196,25,181,13,103,213,227,29,52,51,215,118,85,129,103,179,242,156,213,47,131,92,152,217,22,14,176,213,95,0,198,12,97,164,240,174,216,175,112,37,142,109,157,20,208,43,161,118,236,26,155,198,131,199,218,165,63,126,242,31,110,9,41,146,8,118,36,113,216,180,58,216,26,140,197,224,63,127,70,248,105,88,58,137,105,164,30,78,148,149,22,41,194,211,111,227,207,189,200,195,231,10,219,252,143,42,3,242,8,187,202,125,115,251,41,11,74,210,151,134,164,254,22,184,145,60,135,127,158,106,220,25,70,243,71,209,93,136,196,194,173,51,57,241,151,146,142,254,176,68,246,174,206,36,78,62,226,245,189,69,180,239,100,203,35,237,69,254,101,155,165,108,132,175,21,7,32,0,233,153,228,232,107,86,5,130,237,248,218,69,240,77,233,23,47,162,57,77,101,42,89,62,252,216,245,192,23,189,229,146,203,159,66,160,128,169,173,5,39,237,44,130,27,202,63,117,252,176,193,181,156,179,197,233,83,169,6,104,10,3,77,57,14,73,44,224,137,45,21,7,184,28,11,58,177,234,229,37,130,5,247,169,121,211,203,80,218,117,14,240,176,8,123,120,133,149,69,37,5,47,129,169,31,195,5,164,39,121,107,34,191,234,242,145,30,204,51,239,223,219,34,35,195,39,170,145,175,250,15,250,246,173,43,44,95,66,147,146,190,145,5,135,83,41,83,244,149,181,240,10,247,121,190,237,197,73,147,118,134,243,77,69,237,238,221,34,66,95,209,253,244,0,81,147,60,184,8,64,146,156,1,18,242,27,86,158,150,175,231,207,115,26,85,11,214,128,119,168,98,57,173,52,135,223,42,156,76,239,182,110,201,151,235,156,14,114,94,195,204,42,230,114,215,28,158,107,17,162,48,121,145,82,114,29,216,218,1,190,197,206,222,23,61,78,126,235,208,13,141,255,204,227,41,61,250,66,230,164,153,65,235,133,118,102,188,115,234,191,13,116,36,122,238,248,220,22,76,166,228,145,18,169,62,153,56,233,38,242,237,84,116,240,203,90,2,197,233,219,191,4,149,75,77,37,29,34,133,106,51,37,179,183,233,183,71,9,163,109,52,133,37,1,32,45,29,205,205,126,34,202,31,242,187,169,23,192,207,89,85,49,197,105,19,163,152,5,182,113,208,237,137,44,254,8,122,177,28,66,233,159,222,48,186,133,184,201,150,97,84,0,219,240,137,159,192,152,31,45,59,71,125,148,28,22,235,21,208,225,27,19,122,142,152,41,129,185,70,91,108,120,35,215,128,250,197,84,126,202,76,73,112,98,183,135,141,89,232,251,2,200,82,6,32,228,16,121,21,126,204,104,127,104,33,50,117,4,11,234,221,144,30,239,94,112,35,89,28,139,44,105,138,91,72,18,67,33,240,235,191,29,153,120,132,70,219,160,236,245,188,79,250,247,129,21,24,253,221,16,54,154,69,39,150,223,152,122,215,93,130,93,159,62,106,27,17,188,220,245,184,177,74,230,65,203,237,76,11,149,137,232,89,52,146,237,51,200,3,230,56,142,145,168,212,23,53,105,12,39,202,139,147,36,200,229,78,99,130,102,22,81,244,27,31,234,93,146,169,30,24,71,15,178,199,153,145,7,80,107,98,108,144,97,85,142,198,205,113,150,30,51,165,228,176,238,255,148,220,236,105,130,19,190,34,217,150,48,244,146,44,212,168,144,107,194,230,162,241,169,207,141,80,123,103,197,56,61,146,41,42,191,208,248,120,117,208,195,229,166,141,197,134,188,250,156,152,145,111,182,124,210,232,90,72,109,255,92,87,159,132,189,131,197,186,233,245,203,30,137,170,143,183,62,73,73,217,169,25,24,95,238,203,134,106,169,85,91,225,115,152,47,101,13,71,197,147,131,108,24,57,74,173,139,164,45,5,92,87,121,246,8,246,161,245,108,33,217,56,84,184,92,226,58,208,66,196,213,255,25,159,108,147,218,51,159,255,147,114,68,254,114,44,250,227,54,80,144,32,254,65,82,193,2,124,12,53,66,226,47,2,0,82,181,193,111,10,116,143,126,95,79,145,246,249,167,104,150,244,193,237,146,9,53,81,26,121,142,24,159,53,66,122,40,160,228,228,217,85,235,60,57,138,96,179,10,132,154,193,90,132,16,171,72,159,98,18,209,65,77,94,19,35,45,89,174,173,61,134,28,171,188,25,95,218,27,58,17,241,164,223,73,9,243,192,243,227,194,10,9,59,135,39,64,182,221,50,84,247,39,213,191,30,187,140,54,230,107,157,179,123,29,71,99,203,83,122,223,18,99,176,10,151,84,11,66,108,61,138,184,226,45,11,164,174,46,250,35,169,30,195,50,208,103,59,152,175,141,251,43,0,83,31,219,76,81,37,167,185,83,2,94,112,248,229,167,232,113,24,116,240,195,141,236,182,230,109,57,227,20,123,135,50,145,119,97,37,51,69,180,9,210,33,253,231,252,112,100,97,96,72,168,50,146,148,82,134,207,49,72,234,91,167,179,218,134,167,11,51,183,76,76,127,29,79,106,64,192,239,66,170,186,1,249,101,58,108,75,142,71,225,229,166,59,153,141,242,37,14,131,90,97,190,101,79,24,208,106,9,173,45,31,162,175,13,214,74,31,236,211,217,92,28,64,80,231,181,182,100,132,35,232,125,121,105,136,16,28,2,106,43,53,195,29,220,36,29,213,52,90,55,114,58,58,72,255,23,203,27,223,130,122,52,158,45,167,93,177,48,16,0,36,64,47,168,147,13,126,237,91,5,34,206,212,194,18,125,249,25,177,188,220,108,53,216,104,118,234,129,102,47,161,198,90,77,107,78,243,62,11,176,190,42,70,148,176,102,213,202,156,181,0,191,92,42,203,155,36,139,208,235,240,69,168,119,116,9,207,251,93,193,53,206,1,244,96,136,167,63,6,122,135,184,243,172,73,107,156,140,205,219,42,234,33,194,47,54,193,41,179,9,184,70,37,211,229,216,111,184,27,241,177,98,220,24,8,148,199,171,60,26,231,196,220,57,4,225,37,221,174,150,141,69,234,172,29,15,27,116,97,23,3,68,205,11,186,181,103,172,163,56,116,31,51,250,27,7,138,97,69,42,233,21,229,177,201,219,28,105,170,140,164,59,225,171,157,50,173,169,221,13,28,208,246,160,222,221,42,24,204,121,68,164,81,110,38,242,238,18,109,145,172,16,87,116,95,1,209,225,148,72,137,61,169,84,114,25,207,220,181,248,216,66,236,55,108,215,48,45,136,153,149,22,238,165,103,103,255,92,62,186,243,111,216,138,72,4,211,31,86,21,61,248,240,24,121,218,182,229,141,240,164,175,184,145,235,100,201,236,89,221,6,205,151,73,93,235,230,171,143,229,120,202,214,95,253,107,198,62,132,225,82,58,46,179,15,153,103,152,245,241,166,86,31,54,27,149,209,166,130,107,91,208,58,239,12,228,61,148,194,8,35,211,91,82,106,34,84,94,90,94,94,231,5,25,137,21,193,214,52,63,83,203,68,211,123,242,11,137,43,43,73,82,207,52,178,18,217,213,250,178,20,164,119,107,39,235,83,217,124,210,212,91,86,141,132,39,151,85,245,201,223,247,223,221,248,204,55,12,45,181,7,180,96,131,76,118,151,162,180,199,48,50,209,103,190,115,241,161,42,109,191,57,216,206,86,197,12,236,44,92,231,175,52,67,182,32,39,26,7,19,8,172,179,210,142,172,142,124,176,233,82,168,170,203,230,40,28,140,231,24,194,232,186,195,14,227,102,120,188,27,7,231,228,85,77,86,101,135,178,12,140,56,58,31,155,168,128,82,219,143,178,200,167,27,215,141,3,112,182,88,206,196,108,68,49,145,210,85,136,48,20,237,179,215,142,142,79,250,174,28,19,13,99,47,35,88,210,44,209,105,56,24,175,189,129,250,217,56,226,251,42,166,202,107,135,50,140,211,174,216,218,233,176,92,219,211,21,244,121,162,249,17,253,228,205,111,112,18,130,182,209,91,147,63,3,32,232,147,92,61,2,175,114,80,47,94,115,12,188,117,199,160,221,224,23,66,231,183,255,121,162,32,99,37,232,35,188,174,7,127,149,184,148,135,243,126,85,206,193,167,82,59,74,102,47,236,100,208,31,16,240,71,156,22,151,176,17,11,212,148,49,149,218,160,138,171,240,189,107,174,124,46,169,215,96,117,182,91,209,102,240,39,13,0,236,248,140,147,205,142,119,20,173,196,33,114,168,148,177,249,132,31,29,249,240,153,75,18,98,93,104,131,30,83,199,213,68,162,41,187,227,250,187,129,247,1,74,137,141,208,210,181,136,187,17,192,199,185,203,86,228,238,199,167,135,125,151,210,200,7,233,143,5,210,250,57,237,129,151,21,187,9,175,246,232,106,253,246,156,196,22,0,122,34,99,105,188,142,166,210,195,214,228,216,45,224,126,140,63,59,212,177,65,219,55,217,110,255,178,64,52,152,237,249,32,191,225,56,188,102,116,30,226,78,2,89,86,216,69,69,242,40,244,192,195,200,105,205,175,5,191,158,164,178,85,113,161,107,49,210,155,81,38,133,207,198,43,159,128,253,83,38,157,55,76,28,58,63,200,3,32,227,71,110,3,112,55,235,157,217,205,45,67,100,89,140,240,78,161,255,203,190,55,230,213,244,174,50,197,209,119,31,147,197,40,182,72,219,198,113,91,8,241,194,225,228,46,54,210,216,112,47,69,62,209,102,208,156,70,195,81,158,204,25,76,174,157,214,51,127,220,209,105,99,193,175,240,247,223,3,18,100,62,7,206,72,245,205,4,184,91,123,232,219,104,226,175,20,36,80,126,57,229,141,241,243,222,82,185,51,104,85,62,123,156,136,173,13,221,200,110,21,70,249,38,117,135,155,18,43,23,48,255,70,179,5,0,213,211,139,160,20,159,90,205,200,85,175,27,16,93,138,44,222,225,119,76,129,15,227,179,93,221,69,126,186,37,85,120,176,249,91,191,64,252,151,142,147,40,213,243,38,132,83,250,216,141,92,150,74,42,118,21,108,25,85,71,4,54,7,171,201,116,60,231,51,172,114,170,152,142,202,161,251,242,207,238,166,8,66,148,198,95,189,175,110,63,38,246,185,108,250,118,9,106,215,253,107,13,30,143,219,202,83,152,70,54,35,12,128,78,244,31,166,234,37,79,181,248,58,122,77,231,210,5,168,103,201,70,159,194,17,252,211,154,142,216,221,140,174,68,61,86,232,163,96,211,182,163,121,244,47,238,16,127,17,37,84,122,16,75,234,152,129,85,180,194,252,144,237,70,188,121,239,156,190,71,17,161,136,131,159,29,64,194,241,138,126,190,56,64,168,32,88,44,167,126,199,237,148,167,150,30,16,199,194,129,36,30,134,139,72,63,254,22,97,139,200,111,254,66,66,28,201,174,200,152,156,239,27,123,25,135,116,132,77,136,194,253,82,189,168,136,245,9,154,34,129,15,99,162,171,200,4,11,106,126,181,230,190,66,120,226,21,251,0,228,194,207,213,76,174,216,86,180,238,91,223,243,148,167,20,208,58,167,108,133,100,148,211,188,251,0,89,75,71,55,28,77,240,180,90,225,115,64,67,178,226,210,147,167,24,12,185,106,162,226,244,30,0,255,156,210,189,86,236,203,15,75,167,137,97,97,181,171,157,16,206,171,131,168,193,7,60,75,113,20,113,145,254,86,235,35,124,214,138,238,227,190,159,71,198,240,176,84,122,21,254,229,182,205,236,5,169,118,43,154,95,175,161,18,102,138,44,206,186,254,119,159,56,5,105,21,219,220,126,60,184,119,178,155,30,171,165,213,0,92,78,192,206,78,111,252,84,127,124,7,147,144,142,86,8,63,151,156,83,191,207,204,140,79,223,187,187,207,200,104,124,162,179,223,38,73,117,90,254,155,160,170,77,108,172,219,162,185,203,242,229,39,14,241,151,68,231,166,15,27,99,88,45,86,44,222,99,125,77,22,75,56,31,120,163,69,238,22,123,75,255,75,92,175,34,131,248,203,112,200,101,204,242,152,0,214,33,168,145,240,4,123,59,102,10,1,51,153,156,198,89,7,149,45,222,32,50,186,77,154,210,21,254,122,240,123,102,60,26,40,130,70,74,96,20,185,181,157,231,43,197,84,181,59,185,80,165,125,78,242,42,44,57,116,178,235,228,51,230,109,91,35,197,218,22,75,112,152,114,148,216,151,94,108,99,85,11,244,165,43,33,168,24,162,155,119,136,93,210,62,97,22,144,248,1,57,139,177,113,225,123,13,128,34,237,10,164,104,24,145,83,183,206,84,59,44,1,50,240,233,11,22,21,75,235,239,205,90,2,153,64,225,101,75,230,144,239,40,55,201,99,128,228,48,220,233,138,243,209,216,81,82,32,178,175,98,47,68,231,194,76,223,64,91,100,5,66,246,23,96,155,244,195,94,233,76,116,60,107,207,130,204,95,56,235,130,255,225,75,24,25,129,28,2,196,65,79,88,199,204,167,228,51,207,150,21,235,250,205,50,26,175,149,249,106,231,106,154,74,52,13,59,118,70,156,250,54,115,172,176,48,87,227,255,111,149,201,35,178,60,33,203,223,6,36,140,202,158,180,89,136,236,177,27,131,24,110,7,198,133,249,238,29,113,31,181,60,108,115,160,41,231,118,162,243,118,198,217,244,193,56,158,114,114,62,210,161,230,190,22,1,31,29,53,111,236,96,189,147,152,1,100,99,116,234,187,201,60,114,37,19,134,78,9,127,190,51,117,81,61,6,119,22,147,102,251,26,168,221,131,47,110,182,253,59,195,173,71,91,121,35,46,154,249,158,225,73,209,168,71,119,201,50,223,22,126,245,202,255,167,228,128,36,133,147,14,99,239,35,88,88,22,235,67,70,149,67,175,136,71,127,230,60,124,71,210,105,46,22,136,70,67,52,86,190,7,205,249,158,165,205,218,139,215,245,87,41,24,98,139,44,137,96,103,158,32,18,53,0,15,16,14,147,135,36,243,195,151,173,47,3,189,44,27,28,33,254,109,68,226,117,95,87,8,210,253,58,119,61,225,22,107,245,38,54,179,47,124,12,164,216,235,13,87,243,94,230,65,54,85,133,244,157,27,197,31,170,213,134,29,220,93,251,108,188,153,218,249,71,9,190,252,167,17,73,239,188,180,218,32,206,62,104,7,120,99,51,192,188,254,182,39,42,150,168,75,41,32,227,183,76,13,191,226,3,153,205,252,38,143,108,161,117,195,6,21,110,235,162,93,19,106,206,174,157,34,104,119,227,44,125,76,39,85,95,138,152,124,112,198,245,79,187,210,35,11,153,168,139,8,165,107,120,63,113,136,181,169,138,36,184,100,236,51,128,236,207,239,49,113,122,118,63,252,170,202,236,213,111,198,40,196,111,81,163,202,99,74,253,131,247,13,26,97,38,37,206,69,179,104,112,61,59,100,229,201,140,195,3,19,7,177,132,154,243,66,88,2,87,22,251,230,71,31,20,166,153,55,79,105,189,36,10,193,222,101,181,54,179,168,118,255,12,58,107,127,65,221,94,41,58,28,250,47,113,25,155,192,66,188,224,85,63,102,48,23,89,240,183,149,196,253,81,233,244,207,100,123,118,171,215,151,183,46,151,210,84,243,138,86,102,130,233,243,176,15,192,63,89,25,11,187,55,101,84,80,184,220,74,107,229,93,234,230,136,59,63,151,167,234,155,59,36,186,196,209,2,191,169,251,230,10,29,249,241,1,254,224,209,186,187,135,96,86,7,195,133,210,83,150,76,199,143,171,45,132,36,68,162,110,83,203,199,227,134,9,40,79,8,174,130,173,73,120,15,2,113,96,157,199,10,31,158,0,229,234,226,83,139,3,102,5,145,23,63,243,57,114,184,31,133,141,52,21,216,89,53,9,128,99,66,84,66,193,184,34,105,180,118,242,153,236,139,120,234,18,155,76,38,235,70,158,5,31,46,217,94,49,45,246,219,245,122,170,134,101,153,233,185,20,113,134,65,94,218,157,197,147,208,178,39,15,142,41,166,36,179,88,28,234,0,117,153,135,133,14,220,225,219,198,45,67,128,154,131,76,122,196,10,168,69,94,7,122,236,167,32,23,254,236,12,134,247,235,199,11,62,206,74,85,28,224,14,218,9,104,77,129,175,183,55,40,157,56,202,153,193,60,159,116,19,157,59,204,5,22,225,201,91,186,132,167,133,8,48,54,189,64,75,147,79,9,240,5,41,40,121,62,111,115,10,133,8,181,18,118,16,61,46,169,32,115,129,8,64,198,109,34,65,29,145,74,59,177,139,163,50,161,219,148,118,227,79,61,120,253,14,242,205,154,60,235,7,84,96,170,26,138,60,2,66,58,73,63,34,78,85,182,122,223,193,140,48,174,100,15,223,176,33,43,13,250,60,80,8,55,145,157,220,152,88,94,242,220,172,53,215,86,19,203,215,148,9,163,94,125,121,12,22,243,4,127,224,13,252,173,100,162,233,232,3,19,49,54,148,18,175,230,204,0,24,108,0,122,165,6,72,105,252,148,200,97,31,42,139,165,10,205,64,11,231,157,211,158,36,84,50,192,181,62,203,127,104,115,76,90,216,171,86,0,151,148,48,22,144,174,74,85,252,126,154,167,113,6,58,98,36,193,167,53,179,182,118,146,36,125,45,13,129,200,94,69,246,33,205,120,11,6,243,213,60,37,185,55,147,25,52,113,191,58,27,179,167,168,91,107,240,97,248,157,38,128,17,243,137,148,190,157,135,188,152,141,229,27,11,229,204,12,179,216,205,252,139,160,117,43,250,166,255,76,184,53,144,122,253,157,95,94,43,11,76,75,48,62,104,216,74,104,192,207,3,193,239,81,3,238,2,53,203,246,68,50,252,242,114,191,132,187,155,70,0,168,160,42,101,191,246,170,0,85,166,167,251,62,232,17,203,72,6,33,211,241,173,52,208,174,243,40,41,214,188,150,104,190,54,26,201,12,245,98,178,179,247,128,18,241,252,132,45,144,140,194,71,166,113,138,15,62,173,28,61,184,37,236,131,199,237,114,12,3,124,86,188,130,4,151,115,89,219,249,240,48,91,207,96,237,67,152,129,145,242,8,1,1,39,240,210,157,211,235,172,27,213,130,9,3,205,116,230,176,212,20,59,160,18,115,58,10,189,235,108,56,250,45,97,161,80,40,152,217,37,32,165,233,30,101,135,58,142,120,105,244,226,116,156,17,41,179,126,108,56,113,75,244,47,235,24,85,17,213,244,7,147,151,239,113,97,135,6,153,195,64,251,21,154,118,222,159,61,106,50,123,253,148,186,126,105,31,2,196,23,156,226,248,166,85,129,202,27,91,107,144,71,61,210,189,161,75,235,14,108,106,71,91,139,198,177,221,49,193,230,54,104,69,85,126,32,88,14,97,17,147,18,132,49,228,216,192,84,241,18,71,127,246,169,116,99,9,168,96,30,58,109,79,16,188,209,136,125,150,120,180,107,89,161,188,252,44,229,170,75,170,24,214,194,191,108,248,92,23,229,96,129,152,238,208,97,142,188,226,68,22,141,119,36,190,25,166,49,176,245,227,67,32,233,117,36,252,185,79,157,56,48,231,105,205,90,204,137,189,93,12,35,44,211,172,9,107,53,42,116,55,54,216,85,218,77,84,38,152,21,103,24,24,39,1,125,218,0,128,53,191,36,206,217,180,230,84,120,155,241,58,160,31,81,173,245,56,18,135,1,24,236,170,16,170,85,205,40,145,237,46,194,175,226,150,62,199,173,131,136,6,57,244,248,82,207,16,169,151,117,118,52,226,239,148,65,219,116,129,9,87,203,252,129,165,226,209,124,159,18,164,229,65,54,182,1,203,244,81,3,151,140,8,29,246,140,32,204,128,46,128,56,33,4,76,163,13,125,58,100,62,173,64,19,52,252,102,180,107,254,165,242,251,151,168,157,165,230,154,77,137,36,131,113,130,79,229,182,18,91,234,77,12,35,76,37,113,210,131,20,200,206,115,76,250,154,200,117,228,26,13,225,184,59,100,121,72,121,97,45,155,155,28,158,47,224,155,122,254,211,253,106,60,190,64,219,219,72,231,194,250,218,221,29,113,41,73,241,14,245,50,220,14,168,28,48,218,111,67,51,62,239,248,78,76,137,112,155,64,92,225,230,58,126,97,64,87,99,103,190,194,133,128,220,17,110,187,199,144,212,74,105,24,255,217,156,109,221,255,160,19,85,145,113,6,224,156,56,5,131,236,86,177,41,62,219,194,74,182,214,237,245,185,26,166,176,194,158,49,199,203,75,83,137,46,195,32,46,117,37,52,53,117,196,76,234,116,90,172,5,11,101,50,35,203,200,244,97,132,191,184,138,191,241,62,181,61,82,251,166,48,236,105,51,102,255,134,53,72,81,112,71,217,0,199,223,18,155,152,126,140,253,218,57,210,118,177,75,252,209,36,214,94,252,19,31,208,42,26,87,85,235,154,225,176,146,114,44,173,87,177,118,11,108,235,35,32,14,224,67,35,144,225,113,228,255,242,121,94,81,123,206,154,124,94,93,24,249,69,153,12,196,10,80,197,202,20,234,68,189,231,171,233,240,216,180,241,88,142,247,235,44,13,26,82,177,162,191,206,83,222,120,168,110,113,119,145,160,14,153,40,77,255,163,166,16,77,66,30,80,32,170,110,128,19,222,0,166,109,36,17,98,55,167,233,87,197,40,147,197,125,183,172,66,251,227,118,103,126,235,195,33,8,146,182,67,36,170,140,19,254,4,133,175,24,160,1,80,232,141,195,250,79,13,37,137,68,159,234,7,136,54,137,204,217,116,246,249,255,16,64,229,89,55,157,241,5,46,192,221,12,44,83,175,128,38,58,140,205,123,50,175,119,14,223,216,177,241,105,247,197,34,180,168,25,107,246,58,210,247,2,104,197,1,135,252,120,16,59,180,101,64,110,72,212,151,159,205,141,106,195,88,135,75,194,90,178,42,40,236,70,34,228,159,118,134,86,246,168,92,255,104,111,30,110,81,32,163,18,187,127,119,225,131,197,17,190,120,85,72,112,115,74,85,41,151,192,27,2,180,238,110,197,174,99,80,204,33,183,232,43,35,106,226,89,61,115,42,156,173,32,71,70,217,16,78,103,34,167,178,173,39,167,246,99,197,248,87,199,177,162,18,14,215,12,86,130,27,250,40,141,37,92,142,211,126,228,52,88,25,23,173,67,34,15,165,200,62,158,189,206,35,140,214,115,238,165,128,223,21,76,168,78,97,58,148,2,156,119,146,206,174,187,125,84,177,244,126,156,99,211,71,209,193,103,182,144,39,175,150,102,160,153,231,192,190,221,41,201,249,227,64,233,244,4,199,10,19,63,19,218,161,191,89,13,127,101,205,244,86,34,135,117,18,75,128,114,100,213,177,237,3,221,150,53,207,94,75,209,200,131,81,191,254,178,228,116,37,188,73,44,141,141,130,131,142,29,151,94,13,149,42,199,85,65,94,78,234,188,119,186,237,11,36,209,55,214,2,19,125,2,74,148,0,6,208,80,228,50,2,133,89,214,187,103,50,12,55,33,196,189,8,108,101,95,207,253,153,236,69,45,239,59,248,34,106,198,25,9,143,114,25,149,199,10,28,199,13,87,186,19,69,27,240,177,90,135,46,78,81,173,39,233,235,29,165,194,220,11,205,64,180,70,34,186,142,20,229,98,179,215,25,93,175,242,36,211,246,231,130,30,115,167,104,225,52,155,47,66,246,60,53,70,181,55,74,210,213,7,101,52,164,232,205,253,37,88,212,38,146,24,3,131,209,45,39,157,140,224,170,185,162,133,5,71,84,166,149,155,50,223,234,3,38,60,71,178,3,253,180,190,228,133,119,210,96,85,108,250,174,253,151,190,127,143,158,133,92,80,244,196,251,119,73,114,30,183,58,246,146,98,155,26,85,146,253,152,229,237,232,111,188,155,210,18,213,174,8,97,99,103,200,191,186,12,70,184,140,246,41,44,129,26,55,68,110,174,139,14,106,239,217,186,121,219,174,93,151,186,107,164,33,38,220,214,67,21,18,120,155,70,253,188,118,230,30,155,122,8,31,197,22,43,157,251,158,224,10,97,218,174,142,195,61,148,190,242,100,228,6,185,90,39,169,11,218,248,71,60,205,139,78,69,181,152,219,167,208,20,137,228,74,147,21,6,63,183,11,211,203,187,43,85,217,165,202,94,197,19,73,3,200,16,185,246,182,160,236,31,143,30,114,221,114,31,27,221,122,199,97,12,60,160,105,107,53,205,145,55,116,190,251,25,146,188,140,121,178,225,196,244,195,121,221,185,129,51,93,190,45,173,136,13,88,156,132,134,90,102,177,224,134,211,190,125,129,167,92,171,90,86,237,76,68,152,31,107,244,124,142,58,6,34,192,242,157,13,201,118,210,218,182,244,251,250,122,30,43,150,123,216,190,63,60,175,208,86,189,75,126,147,158,84,140,245,110,41,19,81,180,249,196,29,107,193,172,213,141,19,124,151,18,103,236,58,234,163,140,61,111,237,78,89,169,118,4,124,87,182,59,130,200,206,216,123,108,217,96,155,233,129,174,182,191,104,36,120,81,198,226,0,75,192,85,60,82,73,141,11,136,206,213,30,224,253,90,115,229,83,133,109,213,120,41,46,85,164,18,46,103,16,166,35,88,192,24,243,241,25,199,75,222,213,123,48,183,113,102,130,108,189,31,157,116,73,62,72,228,145,92,47,156,206,166,103,55,98,40,17,238,121,5,121,18,78,170,187,51,71,249,182,123,212,196,232,90,132,239,214,71,135,107,144,163,216,16,177,120,84,151,233,153,102,44,243,61,167,159,175,125,227,48,61,151,172,25,54,48,1,82,69,53,125,137,16,254,105,156,213,69,26,161,67,70,129,78,149,106,103,198,28,222,174,63,106,177,28,3,154,238,204,66,47,11,61,190,220,160,37,193,186,116,101,115,70,72,132,119,246,129,152,39,34,76,248,22,185,115,139,26,237,167,131,17,39,93,200,116,170,104,46,57,68,16,234,113,52,73,210,73,130,4,132,87,153,179,27,89,86,193,118,2,75,199,110,194,52,223,65,24,58,95,4,57,76,110,253,93,59,143,113,156,205,121,25,129,188,116,25,75,177,228,43,35,220,77,217,129,16,119,75,254,124,167,227,77,43,111,46,179,78,178,96,31,186,152,137,61,32,238,198,193,78,10,245,85,166,31,35,25,34,75,142,50,82,120,80,6,138,95,60,77,31,151,120,83,123,182,135,168,160,243,212,164,233,133,13,174,227,89,85,187,86,1,54,81,23,127,24,242,18,229,156,20,65,179,16,72,236,77,187,236,200,106,44,137,116,182,187,165,243,114,171,104,14,60,179,223,84,15,97,3,54,138,205,195,200,147,100,93,143,199,17,255,60,6,33,246,232,27,86,35,8,37,230,23,43,42,221,70,97,180,94,118,23,116,234,4,145,163,237,60,155,80,161,202,231,128,172,110,64,84,10,131,58,106,225,214,90,155,48,122,255,65,56,225,196,122,114,183,89,80,232,201,55,6,78,141,245,10,156,113,90,209,38,4,250,198,231,106,231,179,166,112,3,244,253,4,26,66,117,155,238,216,120,159,91,190,41,206,71,142,177,255,5,14,67,41,197,235,79,46,81,246,65,135,249,164,173,218,66,54,49,11,133,21,253,162,122,159,74,16,104,65,107,217,215,239,244,182,206,52,91,64,77,139,151,32,168,23,245,94,223,220,56,199,21,65,33,99,172,118,102,170,55,36,73,213,223,27,28,93,18,95,116,1,13,56,121,203,36,250,232,131,179,14,53,105,185,23,93,211,89,79,77,27,249,104,243,154,34,230,19,234,211,176,3,178,119,224,166,144,169,214,126,56,19,134,132,228,78,175,151,225,126,73,186,164,43,100,191,73,33,142,238,53,115,201,133,23,195,127,163,30,10,26,106,15,242,87,4,225,145,90,20,58,118,109,102,255,208,77,58,21,110,149,32,195,44,17,53,82,86,80,125,169,153,237,188,153,88,100,255,64,126,224,116,138,190,26,44,130,26,153,27,254,148,37,24,166,193,251,89,214,91,201,182,69,52,13,36,235,238,18,251,224,184,214,112,33,229,5,61,215,139,83,7,160,168,179,16,161,220,114,89,210,6,241,42,114,194,192,23,158,52,132,193,241,132,3,12,165,124,21,187,178,249,177,234,38,49,241,67,31,208,87,220,210,242,225,33,211,110,234,238,5,222,174,132,113,61,164,64,196,114,173,56,145,134,4,9,147,8,239,203,107,122,188,75,66,22,226,138,90,75,72,50,21,75,134,97,9,202,151,28,242,148,81,231,52,63,110,0,79,240,46,25,73,169,164,135,52,125,134,116,1,153,215,49,69,92,196,81,248,207,209,160,240,19,1,244,32,230,61,12,190,105,71,144,55,126,47,69,98,94,163,200,174,194,255,48,58,114,192,123,230,233,79,163,99,147,216,200,130,37,47,44,25,35,136,58,129,167,234,146,212,225,138,166,177,94,162,190,172,138,227,252,70,220,196,87,193,171,103,75,140,253,133,252,220,66,53,153,97,204,56,70,189,14,15,5,237,250,134,160,253,244,72,194,0,151,151,71,154,236,38,157,216,168,118,15,117,204,112,7,183,143,37,35,50,212,168,136,176,31,246,4,6,182,34,225,103,169,92,83,177,4,65,94,117,80,48,9,20,115,110,175,143,237,6,94,96,85,74,8,116,6,83,177,55,196,204,33,65,173,134,212,77,10,59,27,48,221,66,52,146,71,203,189,166,100,150,167,212,237,165,26,26,116,236,36,38,249,154,129,125,184,40,77,197,165,163,75,184,57,167,48,111,50,115,0,40,25,144,184,41,127,168,52,202,144,45,36,168,105,223,139,181,176,113,178,59,34,171,137,177,83,45,195,254,109,4,48,67,4,20,80,1,247,171,81,227,183,152,231,86,68,99,37,27,189,64,195,57,28,61,170,48,45,61,117,173,120,177,251,92,77,239,241,76,117,118,236,71,153,3,230,133,28,249,193,139,33,64,118,75,179,0,41,1,129,52,190,187,200,48,199,83,198,114,63,199,105,26,30,135,64,131,30,210,144,253,227,156,16,164,177,167,226,109,223,13,173,240,125,174,169,95,229,238,236,247,136,241,40,95,52,234,171,99,46,47,144,169,121,227,214,166,25,41,49,92,129,146,54,63,137,70,84,210,56,64,101,138,110,9,214,56,150,130,141,94,204,45,154,2,171,212,26,237,154,237,245,92,55,79,169,60,171,44,97,96,115,92,6,249,31,183,15,175,76,6,104,24,226,117,205,11,16,152,187,108,87,175,237,215,176,255,236,180,237,6,186,36,26,37,144,136,12,87,3,22,203,115,156,145,135,222,104,219,246,180,129,206,170,124,193,189,97,0,134,188,247,35,84,6,60,219,157,112,183,236,139,242,70,215,225,103,90,239,94,254,18,161,158,4,148,163,197,49,107,93,122,70,174,82,114,122,127,200,218,188,6,67,91,154,202,20,29,246,240,244,209,244,104,194,31,9,237,133,147,49,163,157,71,190,185,150,16,253,138,182,30,117,150,165,53,65,165,220,36,65,249,80,112,59,133,57,233,91,183,131,157,100,100,160,196,139,144,108,188,210,195,244,124,37,210,63,204,12,81,250,145,114,240,119,255,66,181,132,213,93,93,11,110,62,198,121,68,58,38,229,185,154,217,158,39,98,30,27,70,66,140,196,15,80,210,104,158,232,241,28,23,83,103,200,47,158,88,77,242,249,111,9,14,24,104,79,107,240,252,24,237,126,223,111,177,47,143,120,107,99,35,160,208,150,189,20,6,243,86,250,7,190,110,21,248,27,211,135,161,58,70,34,189,127,51,65,196,170,202,214,193,116,212,154,122,46,219,125,107,205,207,80,114,82,99,26,227,122,146,104,194,21,36,35,45,53,96,207,135,58,150,227,193,247,222,236,74,194,40,148,131,87,74,92,87,130,4,242,23,194,10,52,235,27,129,182,116,169,4,252,200,224,183,153,211,157,180,202,140,143,106,206,248,166,26,31,78,123,151,187,111,133,120,174,79,49,247,6,196,254,8,60,133,108,228,53,141,214,250,186,222,23,139,107,37,24,247,93,107,20,19,131,148,47,18,157,60,240,180,213,45,232,150,151,128,241,87,163,70,187,64,5,246,88,49,3,229,72,27,213,253,235,37,209,188,225,1,204,177,164,244,97,2,219,90,39,203,0,159,140,90,152,20,182,21,179,134,228,201,252,70,173,189,24,168,76,217,47,10,157,109,191,85,245,126,125,10,174,201,7,250,207,227,104,157,61,177,194,167,83,215,156,104,99,88,34,24,116,223,41,145,103,182,56,217,154,96,92,227,142,128,213,168,44,81,131,143,9,149,155,180,96,47,82,144,95,149,40,233,41,184,212,186,235,39,14,248,16,126,26,75,149,174,50,137,68,57,194,220,224,70,76,78,239,78,62,101,133,27,114,159,223,168,217,238,209,55,38,176,238,8,110,208,248,184,31,117,31,174,0,62,165,180,244,114,183,251,65,99,241,57,86,250,196,63,76,244,81,149,249,137,173,95,3,148,154,228,121,228,47,122,6,4,170,100,43,44,132,55,177,82,195,130,122,62,105,210,81,51,138,166,81,129,42,59,72,80,106,30,129,5,199,89,56,54,168,180,113,254,143,37,111,11,100,156,68,171,166,218,98,118,29,170,183,16,10,79,172,86,239,157,107,50,4,225,33,116,225,87,26,164,125,42,106,159,93,195,103,196,191,34,62,54,16,12,192,249,71,188,192,153,209,203,168,99,46,129,176,97,248,176,128,109,224,144,70,214,27,254,210,193,22,126,105,104,172,58,52,149,220,50,198,118,25,69,234,127,53,93,172,125,202,20,124,229,176,192,224,99,135,28,90,67,73,135,152,18,201,243,169,160,112,116,205,62,53,100,100,110,188,233,99,141,93,41,174,57,124,69,54,163,8,26,136,30,213,26,52,29,175,100,65,8,150,126,60,137,148,176,155,249,103,44,15,227,116,209,249,76,70,73,108,66,238,213,248,243,129,28,154,127,213,164,191,112,185,175,183,249,247,110,64,212,113,209,193,230,143,51,15,159,131,102,207,42,238,182,126,26,40,61,40,75,82,35,90,253,159,78,241,184,64,149,147,117,107,38,232,99,131,33,166,145,216,18,53,203,127,167,144,50,240,179,120,224,204,192,96,97,28,126,233,218,38,126,113,234,235,230,245,117,72,220,167,89,128,95,158,166,33,89,241,191,112,217,202,154,14,57,173,3,134,214,119,220,194,248,206,72,120,9,151,124,167,166,20,78,246,120,221,165,126,235,85,217,95,15,198,142,9,119,190,15,28,55,97,240,79,104,193,59,71,227,245,166,115,54,81,70,145,117,185,74,229,39,4,31,76,186,52,15,71,161,52,197,26,96,249,157,21,121,231,62,230,174,36,237,199,111,148,142,198,225,237,192,224,10,198,223,204,69,41,6,125,122,133,248,100,205,233,25,172,53,31,107,158,163,147,190,163,162,15,195,52,195,170,252,220,159,255,217,216,121,253,30,47,49,69,173,97,23,226,106,173,114,72,16,151,12,46,195,234,53,28,124,103,144,64,35,37,207,236,86,178,60,135,112,198,248,98,255,165,16,134,254,255,18,38,153,73,18,95,73,204,170,218,254,31,96,184,178,59,196,33,78,184,17,85,147,137,241,182,55,249,46,49,239,231,84,238,244,44,73,134,216,239,40,154,212,139,253,216,248,60,146,158,142,119,57,130,76,10,250,81,254,182,124,111,238,212,183,72,70,23,177,57,155,78,210,136,176,178,217,119,16,143,202,202,22,104,159,112,144,251,107,61,171,119,64,110,52,82,82,248,11,14,43,150,41,103,129,179,162,167,99,130,220,45,178,41,135,114,40,146,9,150,163,76,57,72,85,127,224,112,19,162,91,130,88,77,106,181,27,161,186,83,32,238,230,66,131,215,75,184,125,88,225,55,111,141,128,17,197,54,116,107,189,20,171,161,144,194,191,186,194,112,253,68,62,49,47,51,169,186,148,33,14,220,88,165,171,166,14,93,183,142,199,115,26,232,151,79,233,169,42,18,254,233,18,168,151,99,10,196,172,66,180,241,116,175,109,209,208,97,103,57,222,103,67,74,77,118,246,36,85,185,218,98,233,207,150,236,100,162,43,37,95,144,89,49,134,118,79,27,134,90,228,161,255,81,194,242,36,147,147,73,251,28,162,45,36,120,181,21,184,138,228,120,45,17,103,128,58,183,84,69,150,250,204,225,153,220,102,131,235,62,55,138,182,182,153,96,171,231,3,222,37,117,233,16,29,152,227,108,67,201,232,95,219,93,17,127,212,251,171,64,24,75,172,72,120,124,190,157,168,185,193,94,89,108,122,24,167,203,165,40,205,4,183,234,113,211,60,50,107,159,39,235,177,147,40,87,11,145,199,42,153,61,193,208,4,96,255,255,19,252,140,4,26,147,160,228,199,32,180,115,167,43,148,193,123,109,4,186,236,31,52,231,241,130,253,71,54,131,136,124,176,74,243,63,148,199,229,252,115,136,159,184,26,207,106,115,2,106,213,3,5,3,112,10,140,189,143,33,155,165,219,217,23,194,44,76,122,65,76,208,231,240,115,145,134,57,213,255,14,245,192,166,197,144,161,166,42,29,128,198,11,29,244,118,27,80,148,154,203,180,250,148,65,93,60,253,108,242,107,21,129,156,13,204,158,0,231,34,28,190,167,144,2,67,152,214,158,102,56,198,47,15,16,174,73,47,23,128,217,11,113,44,24,66,88,110,177,92,83,61,242,185,12,241,237,130,24,178,69,166,218,27,38,42,121,172,24,100,129,228,106,141,57,22,106,90,18,230,157,131,172,210,204,57,124,61,132,224,102,183,1,207,16,166,238,1,219,82,236,172,60,116,140,149,51,50,174,50,162,180,150,112,38,157,193,236,152,168,73,46,169,13,7,29,141,106,54,75,219,210,216,122,95,220,9,235,32,115,208,87,150,160,80,247,254,7,245,28,53,133,224,121,167,144,100,54,151,107,90,206,236,114,80,239,191,165,242,191,159,149,194,174,218,252,9,21,238,220,108,161,151,189,196,6,71,160,140,128,45,157,203,234,55,136,81,105,48,115,31,70,40,95,149,199,10,86,178,224,219,150,218,17,48,154,110,38,44,68,25,56,203,150,155,217,147,72,231,211,34,97,185,103,64,34,164,123,136,22,201,26,15,35,200,199,172,88,5,192,245,245,163,187,128,126,208,8,89,88,208,133,127,133,160,117,102,185,33,49,103,11,33,33,111,216,159,83,105,236,80,5,194,166,241,175,84,202,60,111,3,86,211,103,157,104,134,72,135,127,142,51,52,158,43,139,157,45,5,208,124,81,251,118,214,45,134,120,89,124,118,153,215,138,64,129,21,252,89,18,232,1,219,122,10,150,201,245,87,91,224,78,112,164,151,206,24,58,42,76,130,146,102,97,111,6,36,169,209,255,59,122,79,113,103,232,91,193,10,187,60,98,165,212,220,67,113,198,86,219,60,140,50,9,70,39,28,152,20,193,135,207,53,101,117,221,110,135,218,79,80,188,38,85,26,53,250,150,9,63,216,60,171,7,160,78,133,194,85,41,199,8,18,184,166,50,105,122,173,120,118,242,221,14,254,42,211,180,73,250,158,113,73,196,160,206,96,168,34,26,219,178,31,240,71,119,237,84,134,59,40,239,207,128,25,121,99,190,172,164,184,209,123,143,59,131,67,210,100,217,39,75,87,78,202,169,219,6,129,102,71,43,153,198,165,62,30,17,224,179,80,189,128,208,67,86,67,253,27,124,153,191,211,237,234,124,30,177,241,136,176,6,81,49,184,171,33,169,248,65,248,107,142,134,111,107,108,36,153,208,181,142,221,0,103,233,44,190,212,135,191,13,214,238,162,132,236,89,181,102,69,162,29,253,129,36,200,87,185,21,137,172,91,199,134,17,157,103,76,117,247,100,157,162,242,175,228,254,160,202,56,190,53,68,127,44,230,51,171,169,77,118,161,180,135,101,213,213,7,49,220,62,125,191,43,146,129,45,41,213,4,197,81,60,208,87,164,39,149,168,2,120,218,82,203,179,249,88,34,236,136,36,189,26,99,132,142,185,10,149,186,206,94,153,219,130,191,93,140,77,14,226,247,32,195,176,236,83,198,107,127,170,246,202,17,113,83,203,53,41,229,47,143,14,166,159,217,108,158,170,15,215,46,88,205,56,42,18,153,127,123,226,219,254,23,7,85,249,169,128,50,113,28,173,109,170,115,166,222,176,110,136,7,80,0,85,75,110,102,240,105,108,197,8,98,167,4,177,23,62,54,212,124,61,56,154,115,110,114,193,194,41,73,80,181,73,234,161,187,194,212,95,199,8,122,165,6,155,223,180,135,55,47,105,134,120,121,231,39,37,160,9,185,37,27,210,112,233,100,145,218,30,194,96,141,2,63,182,177,209,180,147,242,12,89,253,7,248,251,188,7,153,68,200,251,190,183,217,180,147,138,52,219,196,230,144,218,177,109,236,128,230,90,107,186,39,73,243,58,59,29,225,150,166,34,76,141,204,206,250,231,86,233,212,181,172,5,86,145,98,126,29,165,82,182,159,43,176,4,227,140,139,45,33,2,106,70,61,63,33,148,181,132,58,63,212,219,250,11,236,26,171,245,122,205,181,11,28,42,92,13,189,111,118,100,202,200,211,35,53,116,242,52,58,75,121,20,195,18,142,157,146,108,132,230,120,55,41,222,216,228,212,67,199,87,166,103,188,16,23,2,226,10,197,12,245,101,48,163,185,13,2,89,103,245,228,37,87,153,249,155,187,158,129,250,240,185,152,60,52,220,252,221,118,183,38,72,30,193,178,182,36,213,250,87,91,100,153,16,110,76,171,113,149,43,160,234,12,252,162,31,236,254,158,187,207,0,123,95,205,25,196,167,139,234,129,159,190,74,254,245,169,207,124,113,68,24,20,112,233,96,215,32,191,115,120,50,122,99,194,235,25,45,229,17,228,28,186,164,163,156,234,235,135,200,231,224,207,41,88,253,238,32,6,106,184,114,170,148,73,179,79,229,250,123,106,238,24,238,90,80,52,232,202,181,134,173,189,106,92,106,207,224,46,168,55,221,111,89,230,10,137,11,150,219,74,15,222,177,112,147,172,186,253,44,69,12,207,146,89,188,102,127,22,96,157,177,13,242,187,129,217,116,100,14,66,220,235,76,10,242,180,199,193,139,209,216,107,71,241,253,212,178,19,72,249,1,230,57,148,206,150,108,50,75,118,17,123,124,143,4,33,35,159,163,121,239,216,170,219,80,85,227,62,231,171,219,221,135,129,8,166,177,253,27,7,87,102,134,85,216,132,235,135,117,202,172,155,100,69,190,114,16,87,172,222,110,180,22,240,206,62,212,62,112,58,81,69,100,145,163,219,30,240,79,199,136,13,130,66,76,0,234,166,70,203,75,165,209,207,72,125,182,109,52,194,43,42,183,114,204,60,0,132,184,113,199,216,4,117,236,40,134,160,229,128,6,107,53,50,168,204,69,42,188,227,12,253,242,251,52,136,246,225,158,167,120,81,89,178,110,32,232,78,24,62,123,41,66,77,244,43,169,194,52,23,221,123,53,40,1,26,115,66,106,80,16,172,149,170,10,3,47,32,253,167,77,248,119,88,208,221,233,60,17,82,113,231,145,183,183,2,80,172,235,20,126,101,189,111,254,235,201,154,181,56,207,193,232,46,178,72,122,235,41,157,225,150,75,149,110,77,66,37,112,16,5,244,1,53,255,176,69,236,17,176,40,16,109,143,28,128,73,230,139,23,32,113,150,69,40,185,188,11,164,151,91,126,245,171,95,40,89,237,31,0,94,66,107,10,204,157,178,20,114,248,44,104,87,125,29,139,207,36,145,217,122,19,182,57,46,7,20,137,53,134,229,213,155,247,189,99,33,238,100,8,96,135,252,39,50,154,199,118,224,219,229,61,184,150,180,254,243,232,76,203,9,110,34,33,58,121,60,161,8,46,125,164,109,29,232,36,153,12,116,224,71,153,146,249,36,96,75,187,160,199,238,218,69,204,134,59,200,65,30,94,0,200,14,84,136,117,238,8,123,77,84,21,145,44,111,71,92,225,236,173,201,82,25,116,49,94,213,142,160,157,128,43,145,24,165,192,73,15,254,106,66,167,109,98,95,64,83,214,214,253,227,179,106,205,106,60,26,71,131,91,221,171,41,16,44,85,196,210,50,74,184,109,120,41,39,210,233,160,213,139,5,253,107,1,138,47,89,181,187,115,10,113,195,216,195,235,135,37,253,198,78,121,189,248,232,203,245,134,206,74,59,121,181,67,41,100,109,87,73,167,89,234,88,68,77,117,27,32,109,154,181,41,65,75,115,113,154,25,22,132,21,32,218,157,22,232,213,218,177,196,195,76,82,100,153,169,9,128,117,82,154,96,223,245,199,10,246,135,76,236,155,251,177,46,55,63,222,149,107,229,100,55,110,14,190,136,239,8,17,76,189,254,189,82,109,198,8,165,251,182,84,93,177,242,64,42,192,169,174,1,107,248,208,239,39,209,90,51,9,5,54,13,85,62,217,9,157,212,152,148,96,35,135,116,143,36,86,96,151,109,223,242,36,118,49,177,41,55,61,71,2,219,134,40,174,142,34,144,104,139,82,157,42,219,236,69,163,143,12,201,65,157,156,160,11,101,50,124,31,178,32,96,180,35,182,61,10,119,93,89,211,108,119,222,250,97,164,189,199,240,26,157,35,79,108,195,82,169,128,75,28,16,16,149,31,107,136,221,2,76,128,125,243,37,238,87,100,32,162,29,136,76,2,239,204,199,2,32,161,9,254,121,99,39,221,213,251,19,107,167,243,159,165,125,83,60,29,58,92,9,236,47,127,75,92,65,184,249,215,20,118,132,84,99,195,231,224,253,136,214,37,232,14,249,121,55,16,17,21,174,1,133,144,143,181,234,78,50,178,200,65,7,58,249,51,169,47,201,128,178,75,93,89,169,185,174,5,207,49,63,27,161,97,121,142,95,1,194,122,243,157,51,120,237,179,137,221,83,60,3,174,222,149,251,183,47,57,116,71,32,183,198,245,84,75,26,236,201,219,221,45,3,245,175,219,228,15,31,155,120,198,118,36,74,54,152,253,156,203,21,105,244,240,246,127,224,171,100,225,59,42,85,235,36,152,39,131,186,67,170,148,87,192,44,109,190,45,114,164,52,60,80,99,251,70,251,227,115,245,9,153,154,29,127,124,246,186,65,16,60,167,129,182,183,23,171,145,171,212,238,17,134,154,254,118,28,181,212,214,84,187,56,224,185,215,121,71,35,134,1,149,163,95,165,0,10,206,3,93,10,223,195,6,96,0,224,197,70,9,61,27,38,59,93,63,26,69,8,38,43,15,68,207,82,47,248,84,135,161,48,76,65,244,179,255,245,69,123,110,198,131,27,134,207,39,12,38,176,32,19,7,139,34,131,111,250,166,202,104,216,146,196,93,183,196,28,233,152,218,132,191,16,11,159,160,228,199,244,114,37,129,60,61,48,147,128,22,109,159,84,88,0,119,63,227,167,151,145,202,207,241,86,87,41,153,168,45,78,214,32,187,140,191,4,188,5,209,254,204,123,5,199,82,106,219,50,98,169,142,17,99,75,249,156,63,119,33,196,130,197,70,132,157,6,69,54,31,214,51,224,39,104,229,98,164,31,225,152,61,135,57,121,109,21,97,18,22,209,136,144,134,43,232,237,141,103,152,165,212,187,233,153,126,11,245,202,242,188,177,127,197,242,128,229,184,154,226,129,138,72,51,33,195,235,81,40,161,57,27,53,147,212,204,107,147,186,37,102,59,104,121,150,195,87,89,188,154,237,122,232,18,107,239,30,212,47,46,146,160,21,39,148,203,214,91,127,166,97,77,73,116,51,132,152,141,50,207,133,55,205,44,58,165,239,60,132,201,232,78,83,197,41,241,153,71,191,121,142,86,199,141,58,67,114,43,147,192,135,68,218,82,229,104,76,215,34,143,109,32,24,219,132,160,116,0,35,115,215,189,50,48,236,91,213,132,231,241,232,126,56,199,58,48,130,69,109,70,79,47,99,249,59,215,214,89,133,253,178,170,59,15,57,216,246,216,46,213,187,56,75,232,39,39,79,177,194,213,89,51,170,40,195,239,167,156,82,23,66,119,153,63,208,6,178,224,255,34,227,127,220,233,126,148,146,101,251,252,2,248,162,133,205,237,112,210,73,153,197,235,92,140,144,106,208,144,17,160,85,89,99,72,159,116,165,152,27,129,226,13,135,236,213,158,60,162,71,22,72,94,107,162,50,57,216,46,107,142,134,195,250,48,156,253,1,41,168,108,129,94,113,27,171,191,28,42,103,250,220,8,51,237,174,50,147,21,47,162,80,173,87,21,168,89,202,206,161,10,247,49,28,48,124,134,137,220,186,231,228,90,154,232,237,5,195,127,124,232,28,205,56,180,245,9,47,77,42,46,132,13,253,112,171,217,241,126,103,37,111,28,9,101,8,10,166,143,127,233,190,104,33,202,65,236,32,146,80,102,57,167,103,115,219,216,25,44,110,107,38,145,97,188,184,178,181,90,158,214,165,5,57,196,149,4,159,89,192,170,247,177,226,75,179,60,251,201,175,119,41,232,65,148,112,255,87,127,139,209,164,125,234,188,160,200,226,119,194,66,211,12,152,12,119,38,128,239,179,169,131,87,249,46,71,82,125,247,183,150,174,66,22,9,46,30,155,201,240,85,192,249,199,161,250,69,52,74,149,21,163,135,51,125,217,236,247,207,226,251,101,62,135,105,7,160,150,9,175,16,35,47,129,173,215,179,46,52,216,28,113,30,81,254,212,13,231,191,29,226,125,53,74,37,196,53,201,74,229,244,135,178,255,170,56,9,125,185,136,47,48,224,244,191,248,180,180,71,191,182,17,106,173,92,77,196,127,29,102,252,214,75,173,174,53,54,86,98,14,151,96,59,206,158,178,11,194,194,28,122,60,120,225,34,96,224,3,188,92,22,169,71,3,47,225,26,169,239,206,172,63,133,28,162,83,86,103,206,176,237,46,15,226,32,151,12,116,122,1,56,134,142,193,184,145,32,251,198,52,108,5,47,165,179,146,147,90,248,246,81,201,244,124,140,189,28,245,193,28,54,10,232,6,34,154,119,202,21,250,45,227,111,52,202,52,102,51,198,175,106,0,50,114,151,204,73,215,201,253,131,35,225,151,1,58,129,218,86,125,13,237,209,16,84,30,105,37,58,100,137,254,96,65,41,125,108,26,128,96,96,4,17,98,255,93,94,136,3,119,216,53,232,221,126,4,39,69,151,76,76,29,42,215,79,18,252,8,245,107,50,191,51,244,229,163,170,134,1,171,139,120,119,102,159,47,4,226,183,28,155,199,141,25,163,109,209,37,102,22,178,94,175,88,167,78,186,156,69,155,222,165,79,100,244,199,229,249,51,116,26,209,133,172,22,217,175,178,83,232,103,201,102,235,12,29,7,39,106,189,76,88,46,4,185,28,154,96,252,97,127,228,63,103,158,249,128,157,133,209,121,66,34,35,223,222,122,174,35,115,82,192,33,227,192,153,66,159,192,86,120,41,237,35,13,198,230,32,32,75,102,212,226,247,161,30,191,231,100,9,109,25,157,242,65,252,45,210,81,255,75,13,33,178,244,22,195,216,207,55,147,221,90,34,169,167,17,241,56,134,10,123,204,52,145,66,46,98,193,241,156,77,41,187,22,164,253,181,25,191,131,95,226,254,86,217,230,25,220,44,145,87,253,99,147,137,188,74,44,132,90,169,2,186,97,168,30,80,21,78,144,112,230,166,137,161,41,179,162,237,229,227,25,189,228,43,90,168,96,17,41,109,58,121,221,159,174,113,131,188,21,206,135,53,30,82,216,36,41,148,128,240,131,81,48,72,164,160,3,132,75,15,158,168,198,184,82,37,10,45,1,120,88,86,233,46,95,206,134,79,21,226,244,42,147,126,165,24,146,220,208,122,208,206,26,93,149,189,14,72,138,54,216,126,40,133,72,137,147,2,251,133,208,184,233,212,208,193,104,204,155,242,109,88,89,156,254,107,189,214,216,170,131,201,205,25,237,143,100,179,38,172,44,117,241,130,163,165,161,160,236,142,167,82,232,211,45,196,151,208,141,117,141,124,73,171,29,20,241,5,166,81,51,20,63,113,144,187,79,145,155,111,26,153,84,2,52,217,174,139,3,121,13,203,146,150,242,84,234,142,212,75,212,243,225,96,78,205,108,6,160,8,181,41,236,238,197,88,25,124,118,152,141,161,62,226,38,54,124,133,48,155,184,127,215,100,60,175,73,80,213,103,176,199,10,83,194,198,166,95,8,123,164,248,209,192,5,153,159,178,241,15,205,226,171,82,101,234,23,88,127,11,213,230,144,204,165,99,216,83,178,153,179,151,22,169,116,130,139,164,25,211,75,132,255,199,111,84,106,209,171,44,127,2,61,184,87,128,192,67,217,238,187,222,177,94,229,151,24,173,154,42,77,17,50,243,212,104,56,125,15,24,76,230,92,42,49,165,40,242,53,112,44,117,172,138,86,186,232,8,224,225,24,34,69,10,178,22,115,65,106,219,148,88,38,111,227,37,254,26,113,52,145,226,136,181,237,31,133,105,219,217,84,7,87,42,33,93,91,133,97,198,63,250,154,188,244,35,21,231,181,147,185,127,71,219,88,32,13,181,48,9,57,248,140,184,0,70,83,70,108,51,255,222,132,97,106,201,42,5,54,33,194,218,94,246,207,180,97,131,12,119,76,135,187,12,95,247,132,22,229,124,82,196,39,125,56,75,131,197,59,45,79,168,153,143,145,178,3,165,247,69,143,42,0,101,159,142,137,105,56,200,164,222,244,142,43,201,94,248,226,152,254,158,202,46,11,54,16,113,148,184,133,138,33,25,180,69,37,76,12,215,116,216,254,58,85,152,116,214,187,152,86,114,208,44,46,198,83,51,0,79,58,106,180,196,28,198,122,135,75,255,131,16,227,15,24,202,93,179,106,250,139,211,129,243,137,244,246,222,51,78,239,66,154,106,163,174,118,146,25,103,24,161,78,33,74,169,40,207,4,201,19,20,144,68,105,98,102,144,211,96,111,165,93,246,23,22,180,239,73,151,50,53,112,30,88,138,210,132,126,20,45,0,146,127,90,63,16,238,32,68,229,69,136,249,11,74,29,141,220,95,104,193,93,122,61,79,0,170,210,111,168,151,116,252,253,112,127,241,176,65,40,138,166,10,210,43,225,25,23,176,229,192,155,119,132,159,165,229,174,160,135,140,51,17,193,149,214,248,231,233,223,231,112,37,173,203,19,152,106,36,1,220,73,253,240,105,54,252,95,95,9,171,189,67,209,60,206,7,69,250,163,159,196,219,19,176,66,200,22,115,69,19,146,97,159,23,200,202,67,230,248,144,82,37,64,104,73,79,70,225,164,218,96,103,57,125,152,191,41,232,200,140,9,26,114,69,97,90,90,234,166,107,96,165,141,74,133,81,254,50,247,12,141,175,170,38,210,208,194,101,27,159,251,74,54,206,120,226,118,253,205,33,5,46,133,162,205,174,232,172,72,217,180,250,23,241,74,205,7,47,99,118,102,164,60,173,120,229,12,75,193,203,87,228,192,48,77,190,58,114,226,237,71,238,68,93,28,209,187,165,254,33,223,130,235,71,222,156,126,236,33,55,79,43,239,18,20,23,24,67,196,19,85,13,70,210,226,135,221,115,107,242,3,182,72,149,153,45,4,218,180,143,37,230,254,31,242,80,184,67,95,162,212,43,85,54,194,85,212,124,35,92,195,148,91,5,41,170,173,218,168,159,217,141,21,50,174,255,26,201,239,162,245,226,230,174,135,162,191,210,35,45,149,77,171,76,167,182,115,28,88,207,57,136,61,104,150,71,33,19,158,0,89,62,28,63,96,177,52,248,234,21,75,221,0,203,121,196,191,220,163,134,184,234,211,101,28,66,209,196,67,79,66,51,113,118,130,44,130,133,158,71,235,194,173,14,66,186,82,83,105,175,90,27,15,139,217,49,19,93,20,120,218,125,64,227,4,65,174,238,152,230,193,252,233,155,142,18,61,10,69,197,129,42,227,67,143,59,156,242,103,1,64,245,178,106,80,205,48,236,104,73,17,2,123,113,0,208,149,61,84,87,243,4,34,114,32,185,244,199,173,65,215,13,150,124,127,12,128,134,194,17,221,212,66,129,136,199,160,104,58,181,110,36,235,159,9,208,153,21,63,40,184,177,120,170,214,118,113,235,48,209,68,255,176,234,218,13,13,117,197,230,218,155,190,57,84,153,43,36,195,74,77,180,91,70,95,87,176,47,4,192,20,141,178,142,29,60,65,128,146,204,5,160,113,80,168,41,135,123,131,122,86,129,155,119,78,176,21,72,28,17,139,26,53,69,51,146,23,78,181,66,144,1,109,254,102,121,239,226,201,240,158,14,10,170,196,150,234,210,127,187,15,228,74,219,148,185,129,22,177,194,181,219,22,113,246,111,19,33,121,16,88,110,38,152,38,27,57,255,187,49,16,131,185,214,229,45,12,5,116,153,199,255,112,4,251,58,196,70,244,134,246,72,100,177,147,41,91,243,158,222,115,139,195,22,203,119,235,10,146,178,114,155,106,184,175,22,62,246,84,73,116,164,251,174,163,147,48,122,254,232,100,74,128,35,57,5,185,144,180,242,139,83,255,255,235,46,25,33,246,199,85,21,29,150,79,201,160,49,44,47,150,239,97,79,33,19,24,240,133,69,86,75,236,206,58,201,106,28,97,142,254,49,214,161,91,47,235,217,79,224,77,137,248,201,173,55,197,255,181,113,211,184,203,181,138,89,240,207,181,113,87,7,221,144,108,192,122,214,21,20,128,62,154,185,53,28,38,82,155,5,233,40,226,177,46,251,240,115,218,88,184,203,195,236,92,198,108,52,194,161,232,14,16,115,54,190,101,249,162,209,136,136,124,108,51,238,227,198,122,243,55,42,166,39,189,158,168,161,214,135,25,68,30,238,205,149,99,108,169,127,149,94,166,122,2,4,249,34,106,155,65,49,98,239,254,226,23,243,4,76,22,229,125,190,14,41,11,164,225,135,0,222,119,42,237,200,250,5,8,221,166,208,67,217,17,69,116,129,29,156,203,91,88,236,16,152,95,131,98,48,204,158,186,64,247,114,145,78,204,153,41,103,161,82,203,84,229,222,166,55,248,145,238,237,187,165,204,226,134,253,217,187,40,176,141,164,187,174,39,202,167,226,99,85,14,13,124,128,25,164,21,11,203,206,234,2,252,102,215,197,56,204,73,12,34,38,192,14,7,127,253,225,117,230,19,78,37,144,224,153,213,196,187,53,40,211,221,250,141,188,231,108,72,196,18,93,179,139,89,180,132,198,224,188,137,69,16,218,116,132,148,236,217,229,76,172,37,200,58,216,162,237,163,84,87,117,28,44,202,14,253,63,241,139,135,109,65,50,234,45,121,234,199,29,58,236,71,102,95,14,4,49,131,181,172,27,174,218,1,71,3,99,210,217,39,178,74,216,25,235,186,171,57,186,15,9,56,32,146,142,30,74,195,205,58,122,60,214,125,26,70,62,175,92,91,192,209,36,155,73,156,176,86,116,59,38,4,188,53,218,236,9,207,113,154,60,94,145,182,114,185,175,9,252,117,234,161,120,32,142,70,170,52,156,132,1,110,187,225,29,137,194,198,148,61,254,140,153,37,149,11,87,22,149,99,215,11,97,224,114,195,12,23,182,198,59,163,137,114,142,157,221,157,176,17,9,61,90,201,190,186,26,76,192,9,126,98,128,109,47,196,125,230,45,226,82,146,228,145,180,28,166,93,127,68,232,84,220,141,233,243,130,130,39,46,181,231,33,229,150,33,218,241,7,23,190,170,186,200,116,146,152,88,25,207,109,113,179,228,45,80,60,251,213,217,129,229,106,245,143,156,106,238,110,54,237,110,58,46,99,47,246,155,54,180,122,10,206,76,114,103,49,46,67,147,191,15,174,18,100,162,172,14,218,227,168,246,236,184,172,53,235,39,124,129,127,155,216,126,32,122,11,207,94,139,144,77,108,87,125,127,200,17,127,168,146,233,100,65,15,220,63,27,217,182,245,125,225,65,145,116,111,203,115,190,221,104,236,152,54,219,95,117,147,201,159,184,124,120,21,109,116,219,233,254,98,151,130,101,222,177,128,225,23,177,64,210,158,12,251,163,47,96,208,224,114,80,158,154,122,139,161,5,42,175,154,68,164,56,177,249,187,3,95,219,142,255,20,51,91,44,69,144,109,124,129,177,104,167,3,235,129,63,225,19,42,114,217,52,48,87,149,228,92,133,167,247,231,105,206,213,50,169,2,210,129,180,236,152,101,215,254,28,191,25,137,239,61,142,236,81,29,41,89,232,174,215,25,238,10,147,161,57,13,169,122,220,138,141,43,182,148,53,200,86,187,46,81,240,70,115,19,219,238,185,175,130,3,8,99,114,251,44,71,75,225,156,83,207,113,189,213,23,252,61,225,100,10,78,137,10,195,51,61,69,158,213,2,149,49,4,37,18,21,42,225,78,223,84,111,8,108,105,118,246,59,179,49,195,19,18,34,156,118,42,233,169,142,119,126,65,119,133,157,206,57,76,221,41,151,25,249,247,232,206,73,251,68,111,69,203,179,131,143,160,113,4,39,44,73,123,28,17,185,194,193,249,150,55,42,149,112,54,51,222,170,204,161,56,118,117,172,64,230,206,104,127,65,184,30,121,233,26,58,16,24,142,53,234,50,246,195,111,44,253,121,188,247,180,115,202,118,221,255,199,133,77,242,119,133,95,129,101,249,21,25,1,97,201,192,71,70,126,116,254,45,20,228,122,201,40,234,175,101,122,82,12,229,88,178,65,20,142,149,217,81,174,90,53,81,52,252,197,182,53,184,163,154,141,246,73,86,46,154,215,202,155,194,218,141,220,32,217,244,220,148,133,112,205,33,103,166,33,206,255,59,150,245,5,222,144,174,76,238,240,210,63,109,227,196,61,143,103,31,211,247,169,189,152,22,141,172,184,51,197,86,166,6,246,215,233,249,255,47,236,206,110,4,56,83,160,7,151,148,252,230,78,31,8,245,145,63,183,55,251,246,48,255,123,10,26,224,231,18,139,25,112,92,135,132,173,180,0,84,65,34,5,45,24,195,157,173,139,154,246,219,179,184,165,183,51,233,74,101,16,253,150,53,145,214,253,162,152,124,215,143,16,190,21,112,228,207,108,250,35,231,170,249,254,127,150,188,65,213,71,183,129,143,211,168,58,212,223,255,28,188,255,10,55,184,84,26,95,199,90,106,15,106,195,117,97,99,89,194,21,176,152,161,228,246,46,61,75,251,100,80,59,226,237,55,51,0,155,152,172,128,118,20,150,31,186,245,74,217,15,117,34,255,59,193,32,92,56,46,85,31,108,3,59,175,170,162,214,150,123,19,136,9,209,89,99,154,165,224,221,125,98,105,241,187,148,7,186,94,194,46,64,248,31,89,233,158,27,147,88,140,240,135,13,134,75,235,158,188,132,85,25,134,217,243,7,73,95,224,153,53,164,223,181,34,173,166,236,176,131,7,57,242,151,168,167,137,67,2,89,39,105,180,88,151,168,6,153,108,198,149,248,220,86,81,191,58,187,173,43,157,62,38,126,111,60,14,153,197,171,7,223,215,57,117,211,135,3,177,94,114,85,223,216,238,195,65,247,37,43,140,96,148,227,45,90,218,100,12,102,167,105,47,248,157,89,215,139,244,10,0,168,221,53,181,193,106,155,252,86,5,33,63,160,160,242,46,111,25,205,123,140,121,133,244,55,15,115,145,35,106,16,130,232,35,171,61,126,225,140,228,162,104,89,79,36,187,133,56,202,79,40,3,84,15,152,117,236,16,97,137,29,49,44,27,211,51,107,161,228,165,165,164,98,83,24,11,254,205,159,195,50,196,39,53,41,41,4,107,28,39,73,210,109,200,89,125,243,255,203,248,31,213,235,238,69,129,172,183,162,191,227,219,253,193,207,172,226,131,133,198,29,165,130,251,231,77,239,106,26,136,38,125,31,191,1,30,173,95,7,89,247,8,126,179,211,99,78,123,187,38,136,239,69,131,242,1,121,84,42,128,210,96,210,157,90,163,114,128,147,199,193,251,219,75,174,8,134,205,109,137,37,228,58,243,179,144,12,176,31,81,41,172,242,29,165,206,154,225,173,101,175,45,176,87,138,8,206,112,37,203,27,22,58,129,189,190,106,160,49,150,79,68,30,84,67,192,187,243,112,115,66,157,147,24,171,70,193,237,46,81,200,53,17,174,176,187,74,200,90,144,159,78,125,156,248,79,99,107,101,248,84,38,185,98,209,226,31,54,33,111,100,3,62,56,168,16,108,210,151,20,225,249,104,110,56,26,251,209,85,38,91,142,129,46,79,39,193,89,237,240,26,227,251,162,212,237,197,198,196,240,108,205,122,63,59,208,188,135,87,248,64,215,220,179,230,162,59,8,254,187,54,102,246,217,201,100,210,83,192,59,1,86,227,59,49,201,146,82,158,130,36,250,131,252,78,218,142,240,157,35,7,154,123,235,206,235,17,250,229,241,239,132,106,117,12,63,72,254,77,12,83,207,238,162,88,233,215,210,120,135,163,242,148,221,3,5,211,76,247,139,251,54,228,104,81,15,238,43,58,207,220,144,127,218,54,111,21,120,111,234,197,114,51,18,185,139,20,139,158,9,80,75,68,203,108,181,216,101,131,7,26,184,145,251,195,62,210,238,65,228,201,116,160,121,170,61,153,52,150,228,244,16,74,132,237,31,211,189,182,166,19,220,23,110,230,152,142,88,59,0,241,55,123,74,210,173,150,247,6,90,92,2,111,132,98,78,185,83,225,69,3,222,188,34,131,46,214,1,207,95,238,248,53,85,35,158,246,21,85,61,178,159,65,206,84,133,254,3,123,31,41,162,60,127,191,39,139,176,94,229,52,112,219,105,174,215,34,80,77,57,165,191,191,129,121,221,73,159,22,67,4,78,66,84,230,216,222,78,49,33,164,174,186,38,57,194,188,172,244,65,55,99,75,89,8,72,143,101,109,165,138,152,39,200,194,14,84,217,205,33,45,158,99,5,163,173,233,50,217,23,89,236,223,69,140,205,202,36,100,226,30,164,6,174,68,219,211,35,28,70,229,60,73,4,115,202,249,185,53,49,223,102,246,62,148,132,118,183,129,63,93,234,76,102,224,21,168,209,102,65,74,26,144,92,240,23,66,116,35,61,171,138,210,99,161,199,102,195,83,114,159,209,215,188,168,164,219,143,63,64,197,73,177,237,241,129,126,29,87,108,232,159,63,225,50,34,22,132,36,112,6,253,245,238,140,223,171,58,147,54,121,237,6,215,29,23,72,10,79,222,244,46,111,208,226,91,41,27,204,242,26,69,170,124,21,217,63,27,173,9,249,220,24,237,155,90,253,9,110,101,191,214,175,173,142,246,79,19,33,149,113,97,225,92,247,208,185,183,149,66,162,35,139,237,205,100,235,146,116,44,248,168,167,59,6,59,86,88,84,66,30,55,67,124,143,157,159,52,143,194,228,141,75,13,206,70,77,31,172,219,60,98,25,5,110,138,236,60,13,153,63,65,157,195,226,182,73,171,118,189,46,46,200,197,123,253,184,195,144,208,165,156,46,154,212,141,242,164,203,225,164,57,158,242,190,191,151,159,244,2,28,74,214,29,62,236,131,101,151,72,137,67,19,229,76,70,49,236,147,63,72,128,117,177,94,156,30,94,122,205,27,247,240,41,60,44,196,225,249,84,98,92,2,217,65,33,72,144,144,206,101,238,195,212,126,78,42,17,23,89,233,204,176,120,194,186,125,58,110,159,7,254,234,87,236,122,44,203,119,69,111,202,252,209,91,248,171,237,27,100,23,86,11,223,61,103,6,170,15,38,247,121,117,14,32,231,14,232,127,73,239,63,17,236,181,57,102,147,222,70,177,57,33,4,203,31,125,185,105,211,139,131,86,40,203,202,16,49,190,225,120,208,38,82,135,101,210,174,210,112,139,105,73,111,111,226,150,78,204,39,248,60,233,39,109,34,36,75,69,93,44,201,125,212,248,203,27,131,102,73,125,18,185,158,173,43,77,180,219,232,17,56,218,228,98,8,236,237,102,118,45,75,13,243,24,114,210,74,122,162,75,189,201,96,96,4,5,3,127,197,146,233,21,23,165,65,16,233,51,121,162,233,59,219,186,172,69,65,108,93,216,5,81,217,101,179,62,189,118,136,4,252,28,59,189,240,199,59,237,79,84,85,107,165,20,178,156,172,118,191,76,107,165,151,37,113,76,213,51,105,125,210,85,231,24,50,163,74,19,55,234,1,163,144,245,229,86,230,5,9,137,130,39,7,33,213,246,185,38,115,232,141,138,101,82,164,245,11,195,229,216,108,200,237,127,42,69,152,2,236,10,49,156,1,97,31,67,201,233,72,250,253,146,55,241,2,84,198,155,18,167,218,132,21,165,2,44,230,189,182,197,39,49,14,154,64,35,8,128,221,140,225,173,199,92,170,32,244,2,40,59,50,104,208,87,13,228,101,159,215,199,43,29,52,4,207,98,32,129,86,30,255,175,4,217,31,189,16,109,83,34,233,244,136,55,229,4,58,26,213,45,214,116,161,163,237,180,82,9,150,104,53,62,115,121,78,139,90,173,201,212,155,177,229,226,8,18,94,116,122,235,39,239,46,189,43,193,19,111,150,67,8,245,175,206,191,16,251,12,113,15,66,167,222,134,228,161,33,246,39,67,205,211,111,90,100,189,15,59,163,72,185,186,67,80,238,91,179,161,2,39,162,79,165,182,228,119,95,107,107,218,20,179,139,90,63,202,22,203,8,119,95,141,205,30,118,26,35,238,236,27,166,39,111,190,136,94,132,13,205,182,152,212,27,205,123,33,153,93,163,108,63,59,54,94,179,193,74,182,92,30,84,148,37,65,173,152,134,79,176,154,248,120,99,18,27,123,56,247,76,49,83,144,215,28,133,147,10,134,221,188,220,247,209,215,161,240,141,30,254,57,96,249,205,81,52,167,40,105,3,203,239,166,7,63,72,11,90,7,195,101,97,152,186,89,225,200,248,145,47,193,231,124,107,100,212,26,120,198,229,33,144,137,167,103,189,89,117,30,142,26,149,144,142,13,159,221,66,15,230,31,103,13,190,51,50,94,223,165,68,103,87,204,22,194,146,44,130,89,42,143,255,2,207,31,217,226,151,174,93,102,194,170,101,241,203,79,113,21,6,93,155,154,202,253,152,125,135,12,76,3,173,130,215,111,248,233,49,207,6,253,4,59,71,221,46,153,155,193,203,119,101,19,30,25,90,165,148,65,13,124,84,171,15,243,114,208,47,29,146,12,187,85,191,130,165,236,202,197,249,126,184,184,197,152,139,130,97,44,98,241,19,193,90,170,219,140,139,16,59,183,153,176,168,172,210,21,230,232,190,11,112,192,75,145,173,210,221,194,237,151,95,82,158,66,93,220,157,254,116,142,119,6,1,1,209,202,153,9,4,151,54,25,220,20,243,192,187,48,149,18,120,111,242,177,7,86,239,144,244,94,0,9,227,161,140,231,38,68,95,169,252,50,181,37,230,62,79,77,200,229,170,136,101,66,183,200,50,217,88,144,200,45,249,14,124,106,67,52,179,104,30,196,36,41,223,139,240,68,33,163,184,89,177,242,180,207,180,39,162,166,124,32,251,157,173,65,13,68,163,6,198,55,86,10,170,60,243,152,57,227,211,22,26,25,18,55,192,181,155,141,77,204,51,245,37,97,237,9,30,123,216,176,155,4,130,95,199,138,244,193,101,253,32,120,2,212,179,7,209,110,114,157,128,223,151,221,243,185,105,211,102,238,208,142,188,212,21,140,220,141,182,48,82,219,82,55,113,136,75,250,41,82,211,243,88,195,229,249,88,149,40,164,150,186,7,116,244,42,241,26,75,94,192,85,192,103,40,251,95,63,57,224,163,109,54,10,145,38,16,82,174,226,157,92,65,190,112,130,245,37,19,13,149,15,13,47,23,87,193,41,108,45,15,98,165,204,55,139,114,246,60,202,178,120,245,65,143,134,66,178,82,155,19,209,48,146,7,22,185,182,244,222,158,35,55,192,209,134,184,79,70,29,223,208,50,10,217,199,130,68,74,157,232,83,69,72,41,11,52,45,183,32,7,52,106,215,95,4,54,162,28,111,23,34,51,87,111,90,182,206,147,140,142,67,6,148,149,100,94,159,96,142,204,232,96,144,197,231,235,168,9,116,175,36,44,252,161,100,246,45,140,21,67,57,148,178,61,125,181,224,247,166,227,232,243,1,129,187,137,53,24,131,244,200,42,207,84,159,73,109,174,185,81,112,52,192,161,161,169,98,85,243,122,8,223,203,225,115,132,42,168,229,11,0,66,42,60,62,89,9,36,241,30,193,4,135,24,136,179,93,225,101,214,37,78,226,153,157,200,47,122,71,167,159,63,148,134,142,7,245,253,194,242,216,165,21,192,7,147,148,29,168,140,233,111,203,120,120,113,9,139,93,149,239,12,53,48,215,67,247,55,191,116,170,197,18,44,92,246,24,178,235,236,94,14,224,140,245,106,245,46,108,159,200,122,1,142,177,70,65,44,250,182,166,76,153,187,117,151,19,153,10,118,27,69,124,37,102,0,116,164,175,116,71,104,177,166,121,72,141,90,204,65,81,150,60,140,209,48,147,185,246,53,173,75,44,207,9,1,147,180,17,250,131,51,18,218,197,69,202,174,169,194,223,237,115,198,11,137,223,151,130,13,42,94,76,69,237,147,14,213,61,40,246,233,158,211,19,101,213,138,232,10,32,211,255,38,122,96,11,117,223,166,145,166,50,90,129,19,10,226,5,90,180,44,211,153,33,204,224,219,132,13,66,20,134,145,159,135,60,188,127,44,57,98,122,26,132,138,246,170,85,22,217,127,53,216,34,34,17,88,37,132,24,247,216,231,117,104,111,122,141,194,146,24,76,41,197,3,121,3,190,77,78,131,224,251,46,103,56,169,182,67,115,45,137,91,82,138,249,38,89,94,65,125,247,223,62,223,193,244,18,160,121,115,156,57,204,49,253,159,39,24,172,168,247,75,77,93,9,21,19,169,157,85,0,182,39,187,91,156,122,175,231,39,101,194,97,129,142,205,25,212,236,13,127,64,88,122,48,10,3,15,34,253,50,38,28,73,179,214,127,60,120,69,82,220,27,110,85,217,242,181,164,157,84,136,33,174,231,198,166,48,17,69,218,167,115,53,218,245,51,130,195,135,204,147,194,74,233,158,191,202,20,33,168,84,126,59,250,21,108,23,76,34,215,67,32,103,3,208,84,65,77,153,17,71,141,240,26,157,85,133,199,85,42,138,203,132,130,160,80,66,73,76,106,213,126,5,227,156,87,38,88,85,75,46,5,247,229,165,72,202,36,197,194,149,186,206,82,0,31,180,82,234,121,240,190,234,117,140,110,105,197,154,23,0,131,98,124,169,123,232,34,102,100,43,31,29,3,230,176,91,235,178,22,30,179,149,194,154,133,122,96,13,28,46,206,40,206,157,135,162,4,235,75,99,53,58,146,200,16,72,98,15,94,251,33,12,56,166,91,231,9,20,176,73,225,197,199,138,11,93,159,40,96,146,197,102,118,9,251,32,35,231,52,68,156,126,52,88,99,242,162,131,109,215,89,9,217,46,11,64,23,97,105,152,126,118,153,44,122,76,213,31,48,254,217,120,117,122,229,229,150,55,12,155,203,209,187,151,151,151,56,249,232,103,210,19,161,77,157,165,216,123,104,86,154,154,177,79,196,219,229,96,93,54,27,130,182,204,27,254,28,17,191,94,228,52,46,61,161,71,33,76,3,39,152,123,61,171,17,76,254,239,92,21,184,8,172,173,38,137,102,73,28,253,191,17,99,8,159,50,64,234,91,54,152,20,86,24,178,114,211,246,236,87,242,25,142,116,28,118,107,222,66,143,196,182,45,54,110,240,221,159,190,201,205,2,203,253,35,194,157,154,78,66,40,68,122,246,207,4,214,7,152,249,246,200,95,213,126,225,128,249,102,80,30,114,16,40,220,169,95,176,197,90,61,166,192,10,238,157,129,17,49,7,247,217,127,193,222,189,114,140,231,2,114,241,170,123,130,87,23,39,129,146,125,102,74,84,189,8,7,93,155,105,168,155,43,142,64,35,69,9,193,140,135,178,220,132,206,14,69,225,188,5,236,99,48,64,107,175,62,50,98,3,237,186,195,29,75,20,216,72,151,229,200,110,151,231,139,36,50,237,160,113,20,174,166,255,45,213,85,208,86,117,149,197,248,125,173,90,18,212,254,232,190,142,63,255,187,167,222,18,139,212,27,165,130,101,98,195,62,147,211,67,231,64,205,119,149,252,51,58,70,180,158,70,232,252,127,163,209,145,171,162,179,228,204,208,100,217,116,28,15,34,122,29,136,37,182,170,83,252,242,243,93,246,221,161,12,70,245,121,205,196,116,0,61,167,145,242,132,64,111,105,20,110,185,45,10,168,245,29,107,18,193,40,74,158,222,46,232,22,157,84,43,210,45,198,231,137,194,112,252,168,191,71,173,214,171,188,101,85,217,151,244,183,23,2,32,73,72,112,64,140,91,115,67,183,195,136,1,138,152,67,147,26,165,190,18,222,3,33,14,191,73,104,176,4,24,194,72,68,144,142,198,187,238,253,227,107,66,82,78,37,130,219,175,185,102,83,22,232,145,238,124,67,71,187,199,174,47,26,57,29,241,63,223,126,196,167,136,232,119,12,75,53,123,38,158,131,161,235,10,219,230,198,240,1,193,162,142,86,156,125,156,168,85,255,254,18,104,206,223,12,17,179,113,113,213,229,147,147,81,33,48,118,57,167,181,192,219,123,22,179,116,32,171,53,245,226,193,86,161,244,100,179,199,169,203,222,229,55,29,116,192,82,135,202,52,178,94,124,36,21,239,169,209,232,218,91,9,27,22,112,253,140,187,170,102,223,92,205,169,34,117,5,121,247,196,234,101,237,243,177,117,70,176,181,170,221,148,232,94,3,242,131,211,14,36,218,232,82,219,54,181,102,40,166,30,195,136,123,65,162,69,157,186,190,49,213,171,51,53,178,35,120,72,140,89,237,85,213,203,174,21,116,50,11,35,37,148,238,153,9,199,29,185,127,107,172,238,160,137,234,26,23,64,73,214,198,227,236,229,89,73,65,68,95,235,73,158,0,236,97,236,113,166,175,174,160,143,28,123,62,82,130,194,246,5,185,113,77,252,4,225,249,165,155,178,105,63,188,227,36,206,218,14,87,214,209,97,83,186,78,170,154,255,4,52,105,23,191,56,218,221,152,160,57,185,117,148,142,177,255,235,149,9,66,23,63,118,66,74,200,248,190,38,90,206,75,140,255,0,217,101,10,234,15,29,50,52,100,71,61,136,100,188,218,225,111,192,208,127,5,144,225,94,17,157,85,120,180,57,40,217,116,237,121,211,92,86,160,52,15,104,151,102,228,60,85,100,41,208,7,225,185,40,151,228,84,137,144,234,123,95,104,152,198,83,3,139,1,198,48,166,73,124,95,174,84,147,68,158,32,175,93,71,3,177,127,194,17,224,51,193,20,20,33,141,249,176,237,231,226,232,94,189,112,221,144,45,85,175,37,120,51,222,113,95,163,207,212,180,17,111,52,5,162,90,230,210,17,219,149,233,145,58,126,101,209,20,212,13,66,220,106,72,194,156,254,107,69,96,212,0,179,10,204,158,79,187,45,125,152,59,168,183,75,27,144,250,191,188,133,71,135,230,236,121,77,240,68,243,133,71,105,226,36,62,59,138,164,217,31,7,202,93,205,104,94,143,74,196,228,239,252,153,109,91,121,190,132,86,57,105,58,250,39,199,202,243,230,244,177,160,65,41,38,186,54,42,181,225,42,106,90,0,5,189,174,49,230,110,113,129,82,63,77,71,233,0,46,161,123,46,232,31,39,173,6,79,167,27,151,206,110,20,233,230,218,183,194,80,42,250,196,164,183,112,164,117,166,129,252,12,220,249,142,162,31,94,116,132,117,139,32,239,115,189,214,226,64,115,215,65,33,251,44,53,26,243,145,129,46,69,2,211,127,152,120,12,22,182,198,87,226,168,38,151,119,9,169,157,52,103,152,88,108,170,239,255,218,29,103,45,176,211,204,121,218,135,87,97,246,199,131,123,44,53,104,177,208,112,200,50,175,45,44,251,29,199,52,31,41,125,149,214,149,121,75,98,205,137,80,229,82,126,104,132,13,186,31,7,172,137,2,214,144,238,74,146,134,19,85,168,36,123,40,70,181,109,141,4,233,128,60,103,11,157,145,143,179,195,240,89,98,109,26,176,138,84,80,15,231,201,114,242,148,137,196,87,47,43,90,172,89,158,77,71,94,12,83,217,161,7,246,141,133,190,38,190,193,43,173,61,221,192,226,211,156,241,113,254,92,177,60,112,7,5,251,145,58,248,205,227,91,59,77,147,113,109,237,176,38,9,250,57,244,224,94,246,6,183,187,136,87,151,135,94,27,149,112,116,5,186,245,240,86,233,29,60,80,100,229,161,157,13,3,79,211,29,156,91,101,59,145,127,46,44,54,23,167,184,108,230,35,194,10,208,79,27,20,98,200,159,151,163,230,169,149,207,62,167,76,24,253,88,232,239,195,233,34,168,50,202,0,235,235,145,77,91,136,228,113,101,168,24,205,242,65,200,177,144,124,232,138,43,178,101,95,232,96,39,126,92,121,203,222,240,128,76,224,0,72,156,142,79,17,246,252,41,45,229,50,219,57,218,59,13,225,215,200,101,40,191,98,159,184,224,31,49,235,126,66,198,247,131,200,65,104,91,228,146,71,232,99,90,62,190,191,42,158,225,62,103,140,198,81,235,67,43,114,55,157,117,88,62,253,57,209,35,13,93,4,176,200,101,136,0,106,53,120,213,9,199,155,145,231,1,42,101,138,140,229,34,96,182,70,9,215,185,60,153,42,227,61,163,91,232,187,151,131,249,207,27,13,20,34,39,200,22,13,119,20,119,196,88,181,129,200,78,203,202,248,240,19,222,112,213,160,112,135,179,221,239,149,8,101,95,171,53,196,47,119,78,31,243,10,170,207,84,208,196,49,171,157,147,63,227,228,153,73,88,36,193,212,102,160,191,94,240,58,141,192,75,249,0,243,196,154,206,152,225,32,159,39,79,220,207,22,129,216,72,157,85,94,224,65,127,244,167,108,127,220,191,13,163,97,37,168,24,166,195,32,152,14,171,12,188,107,155,117,247,239,146,148,131,86,194,85,223,60,231,133,192,142,74,178,195,18,23,40,130,95,146,110,189,64,82,78,60,6,155,131,49,116,183,67,131,64,23,123,173,156,167,26,206,35,110,96,204,45,32,52,35,163,11,202,69,186,100,202,220,58,72,101,106,42,49,251,155,227,146,204,13,121,128,95,174,251,34,252,112,61,150,44,14,171,12,64,61,14,164,14,36,45,121,135,23,63,39,191,23,153,122,70,192,148,64,108,16,244,110,76,55,104,166,179,221,80,227,89,65,113,200,192,168,195,66,34,128,145,98,44,136,126,1,136,241,212,232,168,159,56,94,18,238,160,133,222,114,169,122,225,140,151,83,20,227,197,43,64,168,212,148,76,102,128,40,181,253,238,1,24,201,194,87,131,128,51,163,235,246,70,54,205,115,99,21,209,86,60,61,114,67,241,29,253,155,246,164,222,57,5,200,174,41,62,238,15,161,50,18,185,140,227,194,19,16,99,157,73,33,129,173,87,208,54,188,11,92,219,132,9,132,223,207,241,206,136,237,168,222,239,176,209,11,230,71,43,241,86,206,209,217,215,142,95,64,18,65,189,225,129,137,118,46,122,45,221,189,85,66,15,124,74,251,41,234,179,3,20,188,134,253,207,16,31,98,253,236,178,112,92,165,108,235,101,205,107,74,40,145,94,80,35,196,112,168,5,160,229,199,136,122,197,241,87,25,143,181,65,236,147,222,138,14,119,159,155,0,26,188,63,112,149,19,23,96,131,138,55,46,95,51,92,149,211,80,101,6,40,78,237,144,255,218,14,90,249,45,210,245,100,106,185,1,123,4,181,73,192,36,115,49,249,94,23,74,66,77,152,49,34,111,223,170,40,229,210,52,25,150,178,183,19,67,250,16,52,34,20,2,216,114,26,146,126,44,85,72,25,111,137,138,102,188,170,246,228,39,74,145,15,1,25,152,39,221,191,192,172,13,222,158,90,199,50,142,106,30,184,224,222,90,73,162,173,166,26,127,140,50,15,88,223,53,254,65,14,35,209,214,250,189,83,55,155,65,81,190,228,54,188,249,146,45,13,116,48,121,70,230,89,66,160,156,20,155,150,89,37,77,229,39,53,203,24,0,237,51,62,222,208,185,206,191,230,226,84,85,172,247,66,254,176,12,5,210,187,197,27,117,62,203,245,227,15,88,69,79,91,152,54,152,188,50,112,240,186,199,208,223,56,24,181,225,3,92,208,53,104,61,228,147,118,6,147,8,33,110,148,198,179,4,143,188,29,132,176,51,126,74,219,87,250,189,246,231,152,222,218,22,234,208,85,175,76,11,144,103,96,234,157,200,213,37,98,237,23,199,80,216,28,199,19,245,160,0,178,52,80,112,5,184,10,56,91,157,51,207,198,211,169,244,117,163,26,95,149,44,254,34,158,25,174,24,207,238,35,141,228,38,13,11,51,81,157,163,58,87,69,237,20,150,149,70,201,11,214,76,89,232,160,28,187,114,21,222,13,121,39,88,228,24,47,138,40,203,9,47,206,201,214,252,194,13,32,154,128,56,182,167,41,124,52,237,184,234,116,60,10,65,123,247,104,94,125,164,57,186,64,125,124,19,20,242,224,27,165,232,31,163,66,118,42,129,61,221,151,71,211,64,35,204,38,190,220,5,205,222,58,66,32,255,189,190,42,251,114,44,109,160,255,251,181,134,29,81,7,0,253,41,97,223,255,183,24,187,230,172,167,40,157,20,123,220,89,94,87,181,220,150,144,210,51,125,136,150,170,154,48,94,82,246,107,25,22,187,170,116,11,63,153,79,67,95,215,210,243,186,0,77,30,117,193,159,197,6,22,129,87,41,96,240,64,0,195,56,179,75,177,236,23,99,193,66,124,219,37,246,84,52,36,62,247,113,134,27,14,245,159,166,53,130,73,145,118,101,208,153,185,150,161,138,211,60,162,255,91,101,70,185,162,179,134,48,50,4,107,110,216,220,234,100,249,43,41,23,126,112,166,207,4,138,10,227,161,130,116,8,116,211,89,254,72,19,86,136,94,166,175,75,4,101,167,125,42,63,225,34,241,148,89,24,109,146,148,28,251,208,155,219,200,3,202,39,51,169,79,172,166,183,253,163,189,204,151,198,153,22,220,120,144,129,85,157,199,2,114,40,197,208,55,140,24,48,176,252,50,184,206,30,9,147,74,234,219,179,2,21,145,106,117,31,28,117,140,60,214,251,70,80,212,12,172,146,1,214,26,163,10,14,132,119,8,65,81,14,93,154,136,202,196,93,15,124,101,111,27,66,189,39,228,154,117,85,218,192,224,23,152,35,119,10,26,99,77,234,226,7,65,243,221,119,236,12,83,217,198,211,112,60,130,50,0,75,7,108,76,55,170,128,168,22,72,85,143,106,98,40,103,151,22,4,217,213,128,123,179,57,190,130,73,162,186,159,111,5,162,116,52,82,108,232,211,123,119,94,64,15,170,78,53,97,34,55,182,169,202,54,182,223,44,119,169,54,140,95,125,71,127,181,120,54,218,165,107,40,146,213,69,4,206,112,171,219,17,107,59,130,151,62,56,77,162,229,183,238,150,16,212,222,83,205,76,199,143,231,149,109,64,30,214,188,99,152,242,42,43,87,139,24,191,13,83,114,115,200,218,60,106,214,77,16,69,37,158,61,172,152,115,133,5,152,175,148,115,136,14,189,45,236,67,79,48,24,187,243,114,17,150,200,95,108,121,119,136,92,82,183,14,198,145,153,169,148,30,126,227,210,249,3,131,55,196,166,228,26,42,184,102,37,244,196,168,118,194,227,195,137,245,161,93,153,198,108,159,165,86,243,47,198,19,158,96,179,131,141,186,171,88,57,199,219,43,24,243,147,34,158,123,150,185,41,39,145,239,58,160,199,60,89,87,240,218,198,222,221,178,253,26,84,246,252,103,242,73,37,146,4,153,54,18,97,143,101,55,121,182,207,91,90,178,194,202,47,70,5,162,235,76,60,6,25,43,252,216,246,245,93,204,57,50,31,136,145,87,118,23,146,224,142,36,217,253,26,246,145,22,1,78,44,211,61,196,241,135,118,29,230,206,254,144,33,87,137,154,17,163,146,234,119,26,175,156,48,58,185,89,46,34,226,75,187,36,148,121,135,54,95,121,20,240,57,162,215,82,44,61,49,246,112,230,134,103,214,87,94,172,254,155,171,64,133,156,45,140,194,197,231,42,170,135,179,238,217,253,8,89,115,194,222,15,134,102,115,105,216,62,164,110,78,139,61,165,64,77,5,174,241,66,7,192,19,240,110,219,130,186,144,154,97,155,211,152,139,255,22,168,233,105,86,186,104,52,248,25,241,29,160,254,209,38,27,83,248,155,19,40,122,146,7,44,172,131,190,225,109,160,89,67,1,90,42,112,214,233,238,101,241,87,129,167,71,214,110,25,247,178,29,36,16,147,205,239,45,16,236,222,174,199,68,87,136,203,227,178,136,128,41,112,103,16,211,141,178,20,121,157,117,63,163,233,143,207,100,97,129,209,213,158,68,22,85,166,178,3,98,73,204,33,160,60,168,237,24,109,28,204,202,225,10,201,32,80,240,110,248,40,194,125,29,61,83,191,14,95,242,148,49,144,84,231,156,40,13,23,130,5,101,187,233,180,77,151,182,117,3,64,74,65,62,173,247,65,150,7,19,248,166,116,68,216,186,187,163,3,187,31,142,216,234,32,153,195,12,189,219,142,255,254,172,85,48,64,142,91,67,115,31,214,249,163,33,194,24,143,121,45,5,245,241,162,235,6,95,169,200,74,65,154,149,45,128,98,245,14,176,80,57,209,118,55,180,155,148,111,130,242,178,214,220,135,171,188,66,117,254,229,187,137,79,158,240,74,81,55,198,254,40,236,117,42,54,39,161,183,80,236,210,70,160,83,80,23,112,61,196,110,73,101,49,201,240,230,5,200,37,49,21,220,166,229,177,248,218,125,88,54,19,68,209,203,161,63,83,129,65,59,122,245,19,102,205,12,220,211,111,225,118,218,225,34,49,65,37,54,238,81,129,179,116,181,137,230,51,97,47,101,219,91,87,87,103,9,136,79,117,10,236,184,8,230,82,184,150,0,19,243,252,197,39,194,116,110,57,23,22,9,197,12,217,76,102,230,96,145,87,22,225,25,12,55,18,44,86,174,135,53,163,82,183,207,61,217,12,217,116,174,8,130,233,171,13,107,4,83,29,235,183,83,92,62,158,16,97,158,35,178,126,102,43,226,241,108,217,111,224,76,242,229,127,185,48,177,3,171,125,58,157,192,11,8,61,192,168,81,48,37,70,89,154,167,167,162,221,102,59,111,201,79,61,186,112,15,115,186,42,145,132,78,55,31,147,121,238,37,176,180,66,92,23,105,137,28,84,133,226,99,147,200,103,92,3,236,55,2,85,45,156,21,4,108,172,133,218,115,131,236,192,252,159,200,127,130,224,198,99,41,247,161,76,1,201,43,235,54,70,163,148,61,21,232,253,70,161,147,247,153,91,121,80,153,226,198,50,34,192,111,208,8,238,227,90,243,68,9,59,27,164,89,228,48,116,119,250,91,106,21,234,62,211,99,185,134,228,32,191,178,233,182,208,69,67,49,92,253,69,43,153,178,239,43,43,134,153,199,170,42,15,136,114,60,190,13,240,214,179,176,208,138,124,32,116,48,128,109,86,54,53,44,233,214,31,82,51,2,150,8,88,130,212,131,76,212,191,95,236,206,181,19,3,244,62,150,81,169,215,145,46,225,196,114,52,255,187,143,189,122,241,81,246,217,241,167,36,65,152,85,106,188,134,254,107,238,238,179,120,238,19,1,113,187,10,42,85,143,190,76,248,194,72,224,204,238,145,240,163,63,194,117,92,130,125,50,193,45,103,54,12,113,20,152,255,247,114,183,22,4,124,45,226,23,111,120,162,201,254,40,183,186,127,65,2,41,167,18,48,12,62,133,110,69,233,145,168,70,152,110,228,51,251,174,9,29,166,115,168,205,148,241,16,158,234,39,248,247,107,191,46,152,113,193,222,166,154,217,99,85,167,64,115,29,46,141,235,177,84,186,74,211,139,238,161,253,174,174,43,13,25,3,53,164,11,204,222,61,34,215,25,46,91,28,234,66,189,241,50,131,247,12,176,218,185,6,106,101,196,125,109,115,205,59,211,36,37,208,111,17,214,4,8,173,106,237,253,144,171,170,90,198,100,147,7,108,177,237,126,131,147,212,91,193,230,216,184,6,212,200,206,25,195,56,129,21,5,28,65,226,191,37,182,228,80,43,3,35,94,13,98,168,166,171,24,33,255,49,209,89,70,47,131,11,108,129,77,184,198,43,102,251,111,64,60,254,107,6,42,89,196,241,73,185,137,85,147,54,143,96,20,163,206,45,213,47,193,12,13,201,172,222,220,66,172,3,203,146,225,2,214,172,151,210,98,35,209,131,250,233,47,134,238,121,162,195,134,246,116,144,27,177,112,74,85,17,40,141,167,108,6,180,38,168,114,248,165,83,198,122,181,154,192,177,60,70,136,49,55,0,171,143,5,6,0,27,88,107,62,70,89,148,40,247,77,32,56,176,246,20,146,232,19,3,163,237,85,194,58,34,129,222,160,105,52,37,232,216,7,111,255,105,151,88,218,120,19,109,95,144,148,69,74,3,82,247,122,46,194,109,29,132,42,195,203,230,202,34,178,67,127,126,145,151,189,63,50,134,115,47,32,92,183,5,110,120,150,21,84,69,34,145,152,249,0,56,191,18,185,43,98,101,213,237,125,61,104,251,152,236,218,53,215,94,42,140,87,172,112,17,45,75,237,121,185,45,17,118,206,211,139,170,129,244,99,20,0,80,136,213,136,147,195,38,135,161,229,162,123,34,3,4,58,3,84,183,183,188,22,159,161,201,82,14,89,107,33,71,220,137,8,82,44,225,77,250,176,64,70,204,134,6,142,216,68,124,129,6,204,131,234,138,233,75,123,223,61,185,58,226,138,56,53,163,187,169,127,215,55,141,176,122,35,72,160,105,149,140,24,158,100,137,35,169,36,218,73,247,179,77,32,105,222,127,99,24,220,42,161,235,236,197,195,32,121,121,119,78,31,13,244,200,55,9,43,145,244,177,139,6,238,44,218,135,23,126,241,14,63,111,74,44,29,8,230,82,65,148,45,119,159,186,165,146,208,14,35,140,11,23,247,146,15,174,154,230,217,230,94,168,192,123,84,42,249,180,27,100,137,7,129,30,113,137,137,115,81,146,229,160,113,210,1,156,59,167,183,196,72,148,1,147,142,219,254,42,235,171,62,84,176,17,184,64,251,222,91,117,46,146,0,8,3,158,176,79,6,121,58,132,171,184,206,176,213,246,32,36,26,235,175,31,250,142,106,204,109,13,15,6,149,60,33,111,132,68,31,56,206,198,124,149,74,100,74,236,162,74,136,231,32,54,238,126,89,158,55,79,103,85,25,59,8,186,170,14,81,250,81,81,108,232,220,143,114,112,126,243,155,176,224,8,34,75,33,32,37,180,119,238,12,29,92,137,160,203,82,34,177,192,227,141,147,67,83,6,65,128,98,199,137,55,121,69,233,254,74,162,164,207,55,124,110,169,224,104,41,189,64,181,167,117,116,152,104,89,241,97,252,37,214,131,209,205,231,122,89,68,84,204,166,179,26,36,23,79,169,135,149,91,220,144,50,20,221,179,60,202,149,125,125,74,125,98,7,172,11,62,49,228,21,78,200,146,190,223,194,139,86,243,178,236,172,122,236,223,174,238,108,179,52,216,162,235,125,196,242,144,162,250,196,26,217,192,103,181,92,94,151,131,70,88,111,249,102,158,207,44,104,161,47,153,169,212,34,2,255,237,252,253,227,1,196,252,60,65,180,78,242,139,41,73,28,91,77,234,148,121,138,105,130,56,114,159,30,147,151,208,134,3,237,65,123,127,124,232,67,199,25,27,54,111,181,115,220,79,53,69,184,16,34,31,218,223,51,203,31,153,160,196,115,31,119,234,176,157,75,207,154,95,51,53,53,202,84,118,50,162,16,203,252,123,191,167,92,153,129,181,21,51,211,100,37,172,115,88,175,229,131,82,113,170,198,137,218,12,189,35,156,147,79,1,100,245,224,185,193,252,148,217,91,45,230,173,67,89,119,28,228,179,152,139,46,104,205,65,186,110,211,33,111,234,80,84,113,214,60,70,132,193,229,81,240,15,150,245,132,82,138,40,172,159,133,192,178,98,8,185,136,108,73,120,129,60,215,190,125,128,218,254,254,6,124,171,244,86,110,194,38,199,15,243,202,20,103,202,158,105,246,177,153,234,61,171,176,215,212,208,126,155,80,155,100,145,255,128,50,196,114,236,225,92,194,110,230,32,224,222,63,205,90,132,164,239,82,155,160,122,250,2,87,237,149,159,116,218,115,115,6,143,62,89,125,21,66,164,201,18,138,232,170,197,236,90,214,207,241,101,147,110,74,48,58,109,60,51,68,130,18,186,68,113,130,132,5,181,81,64,228,138,210,68,21,76,235,223,155,212,172,185,146,158,147,39,52,190,242,93,201,175,172,224,19,104,133,255,137,95,17,163,94,111,213,242,122,219,5,208,171,191,95,208,161,24,230,203,201,87,132,124,223,120,3,197,77,136,250,150,163,222,77,83,98,97,117,206,136,157,78,164,3,10,16,76,245,92,13,157,181,217,48,198,251,130,176,74,245,161,216,234,182,101,131,231,128,82,106,64,55,83,72,85,177,154,19,11,184,19,255,171,204,87,53,110,101,75,144,223,53,55,85,86,139,12,95,151,93,212,16,166,209,128,55,92,244,157,35,46,109,35,163,125,19,236,64,103,158,54,72,172,96,252,129,206,219,214,60,113,41,0,16,5,235,234,186,165,223,146,47,176,188,60,176,10,67,189,2,162,142,13,88,68,108,70,176,134,56,255,160,135,91,190,201,123,8,10,228,125,231,241,200,207,191,163,183,30,137,36,254,81,146,142,16,205,67,182,140,155,214,207,184,160,228,198,213,172,203,222,25,87,32,215,164,70,106,121,155,38,175,88,252,74,255,111,15,193,10,145,66,143,245,72,192,15,46,102,54,119,68,33,53,141,42,203,133,10,211,116,198,99,150,241,118,189,116,98,12,211,133,120,119,57,53,195,62,255,171,216,232,98,15,190,63,113,181,1,202,2,243,103,164,57,226,2,157,127,106,67,150,85,101,155,121,98,214,62,11,157,202,16,255,60,211,241,201,232,42,58,131,146,253,238,117,153,166,239,97,17,145,132,252,72,39,129,15,244,119,194,255,121,174,243,197,232,202,213,220,197,152,160,227,123,92,51,92,181,198,200,107,179,112,198,34,32,73,146,84,92,231,13,5,94,154,168,169,17,71,82,188,182,0,84,253,111,170,115,19,16,69,166,134,71,86,58,154,229,7,60,168,38,53,230,28,140,141,218,253,166,95,162,98,89,24,231,176,166,240,213,239,24,137,54,189,245,37,76,185,108,127,32,86,156,218,75,121,134,173,113,143,16,145,30,238,235,61,123,245,103,100,174,191,127,43,149,202,237,211,224,193,253,99,5,142,24,16,73,239,24,46,186,21,206,169,180,93,126,141,244,135,249,135,89,123,29,77,7,130,187,111,99,253,45,26,51,206,167,143,131,91,234,88,205,34,69,222,89,177,63,74,121,192,89,129,10,34,237,232,2,103,128,207,77,98,185,81,53,215,210,95,18,3,197,182,6,107,19,103,66,242,59,249,16,249,183,112,255,78,192,32,170,213,8,1,49,161,17,178,207,241,141,29,113,139,56,22,52,87,42,184,109,14,227,47,245,76,207,4,209,122,37,238,90,125,224,165,250,31,171,199,43,228,45,97,213,197,99,116,135,220,214,61,240,113,252,229,30,221,162,108,37,131,32,135,107,154,140,232,72,158,157,49,233,206,235,91,173,233,242,163,66,145,206,235,190,86,192,101,255,110,206,45,224,244,139,91,198,158,234,183,0,120,174,205,251,213,178,109,118,193,81,251,26,134,234,229,60,224,101,24,73,138,2,63,41,14,151,227,217,236,219,56,188,77,253,39,174,84,253,131,131,155,101,137,52,36,75,158,254,52,83,38,12,185,86,47,163,150,116,34,252,132,98,172,17,54,181,36,57,153,57,63,93,207,128,99,132,177,123,67,183,124,170,141,178,151,16,94,21,247,129,221,197,211,157,209,223,240,109,194,151,111,63,170,244,173,107,132,243,34,188,18,150,211,28,98,78,21,56,90,164,99,151,103,239,238,191,243,249,155,199,237,48,225,156,82,9,198,177,120,116,93,185,204,40,52,137,136,104,242,213,8,70,139,79,204,18,52,190,142,194,120,67,64,69,198,87,225,220,200,34,196,7,232,146,96,19,243,55,175,56,158,57,69,208,142,233,236,201,3,118,220,141,175,134,26,94,175,71,0,59,2,111,240,175,252,108,225,226,231,24,48,79,83,233,82,104,30,148,143,191,50,199,216,37,252,121,33,29,46,63,123,160,250,224,186,14,176,69,193,112,243,223,53,28,254,146,1,118,71,233,90,99,177,178,224,201,121,140,173,179,87,28,174,176,48,206,199,122,209,152,193,102,72,18,200,243,205,112,32,27,148,57,154,62,196,73,245,173,14,219,191,210,239,51,122,128,104,14,142,128,214,214,78,32,68,223,208,241,174,94,136,223,252,37,182,151,31,100,124,181,197,234,90,235,217,24,7,225,39,75,103,52,10,4,224,155,25,49,175,16,79,56,41,179,181,3,79,41,176,254,234,64,56,199,201,107,227,113,155,212,82,170,244,48,105,45,199,241,178,48,75,26,146,142,87,68,6,81,147,196,252,201,8,130,126,227,249,250,44,188,245,12,253,25,207,113,66,153,63,158,159,222,226,20,171,57,55,145,67,49,38,70,36,214,91,42,69,6,104,171,7,185,120,249,13,241,100,101,53,26,58,119,72,233,230,166,120,50,197,169,34,159,208,35,101,183,171,243,13,118,131,198,253,205,89,37,145,86,67,63,129,72,11,151,193,145,39,8,101,231,113,48,34,149,171,205,14,87,60,249,188,100,102,173,93,214,34,191,171,89,171,126,107,28,162,13,149,23,42,77,14,211,230,227,17,134,129,50,75,163,115,209,150,64,66,47,177,25,27,185,221,161,40,81,218,245,222,84,60,241,223,82,164,69,231,38,32,129,66,31,147,181,90,122,202,132,38,90,45,76,203,117,14,87,201,63,183,143,68,250,67,226,140,213,79,162,13,140,245,6,58,126,115,214,129,82,59,66,204,148,91,62,153,124,139,67,82,127,51,114,166,32,43,190,153,133,25,212,235,98,174,167,33,49,250,141,6,12,109,86,69,4,116,229,51,229,148,153,147,83,220,36,144,219,167,124,85,50,103,16,74,163,37,74,54,167,51,101,198,14,128,22,157,61,24,131,158,47,88,58,108,67,237,222,86,235,226,209,56,243,195,199,62,235,220,190,131,53,88,29,75,226,50,206,15,119,0,238,211,35,176,170,98,126,43,49,103,23,118,204,147,200,216,177,105,173,92,177,233,155,176,198,63,88,113,221,8,189,204,151,63,159,61,131,6,65,59,165,253,121,186,36,25,11,185,148,156,184,94,243,143,126,82,176,221,195,24,199,40,175,201,106,14,50,146,224,229,114,200,159,236,167,100,72,105,30,195,208,234,96,2,48,199,193,102,185,116,128,170,193,110,20,144,139,234,203,38,254,167,213,60,112,2,115,150,231,55,31,99,208,10,110,64,205,22,205,92,180,200,34,119,186,67,3,11,97,77,198,55,83,235,232,0,160,144,184,25,136,141,205,227,43,206,202,169,38,155,125,80,84,177,146,27,187,37,220,43,188,117,226,131,96,72,47,21,88,60,55,12,142,26,227,250,140,249,4,171,232,131,237,123,225,192,22,51,167,46,181,128,57,236,4,109,125,21,242,249,69,189,134,98,12,103,26,67,187,156,70,80,47,13,13,169,245,142,111,223,108,246,68,202,137,18,178,72,182,33,213,149,126,105,142,60,244,133,173,74,96,57,135,168,68,203,214,93,76,66,240,222,61,93,115,97,236,39,246,61,227,120,46,189,227,101,169,65,250,174,153,199,155,200,227,2,116,111,80,250,210,205,170,214,78,191,186,208,14,13,63,237,230,11,83,178,72,229,153,235,20,35,151,85,111,103,126,198,157,163,237,250,144,33,113,18,68,176,27,176,183,114,5,250,0,14,31,33,188,173,216,106,57,24,165,14,154,229,171,31,0,150,61,126,214,216,198,89,94,37,138,249,135,145,68,99,155,143,210,19,49,234,20,72,22,168,46,174,164,237,210,70,197,117,158,1,33,170,222,210,200,235,196,103,247,22,149,162,39,133,239,211,4,96,6,171,22,29,78,100,44,203,222,222,224,177,248,252,255,149,228,57,49,18,89,173,156,253,104,183,120,4,234,219,126,35,243,218,12,130,90,178,135,115,166,226,111,85,154,184,198,47,128,17,31,189,170,45,250,227,155,157,208,85,57,25,73,55,78,247,128,224,137,95,175,109,23,156,65,214,211,88,112,15,112,119,68,7,192,60,241,9,245,208,178,201,186,114,55,92,132,123,148,76,105,55,82,190,29,227,200,99,40,101,153,212,6,103,165,255,128,94,252,172,250,90,94,115,121,112,209,238,133,100,194,1,111,27,171,228,13,42,253,5,41,56,145,30,223,9,3,24,15,140,251,183,43,198,97,71,94,11,6,1,158,70,7,164,246,160,145,8,45,78,79,54,157,209,148,72,145,169,134,123,208,122,26,32,75,125,47,17,100,5,222,94,248,64,31,198,112,76,133,181,189,70,150,17,43,213,97,201,203,235,109,111,205,47,212,144,56,56,9,167,47,31,122,162,33,106,193,184,139,127,204,205,80,133,92,30,246,46,0,110,112,5,129,247,42,88,165,54,153,38,178,227,27,167,138,93,112,123,73,241,199,30,219,228,24,202,146,218,25,61,239,58,54,128,118,251,216,78,177,34,105,134,230,199,74,94,180,84,197,118,109,251,186,13,183,164,9,0,14,242,70,130,90,234,127,182,105,1,160,150,200,75,190,233,182,106,91,23,5,119,7,242,140,237,88,216,224,25,60,187,157,4,159,155,113,48,83,178,31,103,0,181,90,176,106,39,230,82,150,238,23,154,180,5,142,184,6,19,228,243,207,242,183,102,99,230,133,134,73,98,70,210,189,181,241,170,128,195,117,228,11,141,80,33,168,227,165,69,86,172,98,160,116,184,26,107,128,54,174,8,67,100,210,197,250,144,30,247,77,243,181,239,130,66,2,5,238,217,11,157,9,184,41,215,236,65,112,232,144,44,17,8,220,242,241,196,217,154,195,74,60,207,32,128,117,143,76,83,76,111,178,175,3,33,3,199,152,195,217,139,204,104,232,83,98,182,69,222,176,220,251,179,133,58,50,143,198,174,42,129,241,92,110,145,126,2,133,137,77,168,117,206,117,76,109,80,8,157,120,142,151,12,9,33,61,161,190,253,154,189,100,253,199,159,242,96,202,132,187,236,99,199,157,253,247,39,106,55,35,113,219,115,57,52,131,30,233,130,60,151,67,205,192,18,121,243,119,57,187,172,1,11,28,89,68,211,85,28,198,76,61,255,95,159,227,77,201,156,186,31,132,5,26,37,176,195,72,189,10,140,235,98,240,130,146,144,10,5,213,194,35,13,141,211,223,9,110,144,190,91,70,170,182,195,173,96,204,169,61,69,71,140,233,120,51,62,1,216,135,71,201,158,35,241,224,135,85,54,58,8,179,73,145,232,157,177,215,109,20,45,252,8,45,218,237,138,115,6,110,229,130,64,28,190,216,186,33,83,238,162,81,133,59,144,58,54,209,212,53,207,122,160,132,173,1,190,190,130,247,50,101,168,98,139,90,14,132,34,215,242,18,242,192,189,203,88,70,118,49,167,253,219,146,103,203,2,110,239,0,71,230,173,136,157,25,121,40,250,78,211,97,166,31,168,224,200,117,179,156,151,23,49,35,16,220,171,45,255,222,79,160,2,138,83,33,56,167,22,77,88,203,241,28,154,62,146,45,246,179,8,62,246,183,210,116,175,253,121,126,130,233,253,165,189,25,96,185,244,214,93,153,6,121,207,204,106,87,105,200,108,179,136,167,134,56,49,227,202,53,172,240,49,239,70,133,179,119,160,236,86,251,20,1,229,22,140,26,213,51,172,65,72,34,74,96,30,125,246,34,146,139,198,49,95,169,105,89,113,81,33,163,56,251,58,151,58,191,101,92,244,85,92,105,36,115,228,224,214,35,56,62,78,171,225,252,145,66,187,238,34,37,180,33,169,167,145,8,190,165,51,91,32,17,140,73,193,219,240,11,68,97,22,10,57,161,124,50,202,182,54,201,156,175,170,248,236,35,125,194,91,219,91,95,142,55,41,28,166,5,132,158,181,177,15,9,68,205,237,108,150,118,170,220,190,103,137,236,142,196,158,51,220,170,145,169,176,106,225,223,128,251,59,88,47,92,121,24,72,211,101,193,171,168,157,206,222,140,120,59,39,232,43,120,150,232,24,231,71,228,190,68,100,13,187,63,249,186,41,8,29,245,85,44,105,72,191,156,138,193,163,19,213,54,196,232,150,22,0,92,233,241,164,43,251,56,67,27,196,54,76,54,104,0,137,98,64,210,19,13,149,125,212,178,158,85,171,171,39,63,174,138,161,144,39,122,204,55,232,181,95,98,177,80,73,109,241,131,140,109,196,168,108,182,66,210,181,38,85,3,213,205,249,196,79,156,33,201,140,29,119,3,198,224,156,126,38,210,98,71,47,169,34,28,205,154,51,44,98,198,177,158,158,90,212,29,207,215,213,39,8,66,116,201,4,236,67,241,15,57,221,210,133,141,211,148,78,246,244,39,251,227,29,64,110,13,243,45,8,140,102,92,195,54,247,238,21,121,52,58,107,239,91,44,66,23,161,116,196,193,43,244,221,188,188,79,112,139,145,31,130,206,57,133,208,165,108,118,23,50,106,29,203,84,195,218,113,231,254,97,150,178,128,140,45,203,33,160,183,117,32,216,56,179,185,88,43,70,238,25,91,211,95,254,71,161,251,176,193,236,221,61,73,127,117,12,118,47,88,68,167,88,141,66,217,125,215,243,244,58,147,231,213,65,244,111,77,172,251,113,132,60,107,76,136,173,77,240,29,11,242,176,247,148,40,174,235,81,196,71,20,240,146,86,90,36,253,131,246,233,12,100,146,204,146,57,96,215,176,100,35,167,182,12,159,20,81,102,24,241,238,150,179,83,184,175,154,129,31,117,253,100,239,65,43,144,169,122,184,201,195,163,0,63,30,146,11,142,111,202,0,124,89,235,140,152,49,145,86,91,171,51,14,213,142,19,68,232,218,229,105,136,8,147,210,126,194,188,88,138,191,105,195,97,112,238,207,195,226,126,98,175,27,179,179,166,164,158,133,216,45,148,34,192,47,49,181,73,13,250,94,7,236,23,211,139,125,125,124,101,243,82,171,209,159,87,221,205,151,35,151,178,198,31,52,175,94,225,203,33,245,183,22,4,104,18,95,200,100,113,33,239,57,61,105,56,156,207,119,75,132,40,173,254,234,232,220,77,110,119,216,50,235,18,50,59,150,5,172,160,252,44,102,30,199,120,228,229,243,235,6,230,218,94,200,113,58,141,152,199,26,230,131,3,239,139,52,158,243,186,237,47,20,124,130,54,221,181,126,119,186,45,43,89,190,241,212,174,154,62,126,91,7,33,167,104,12,107,150,211,105,201,128,28,161,206,38,127,16,58,31,217,172,132,126,183,149,244,228,143,176,155,199,117,191,182,9,55,203,170,38,95,14,213,127,209,175,201,187,129,74,143,78,27,222,119,3,73,64,160,22,113,179,35,162,57,199,213,101,131,131,147,238,254,240,193,50,239,147,220,139,38,253,181,183,202,193,152,90,149,215,109,242,144,185,45,66,224,121,90,5,137,215,226,169,172,28,179,124,219,190,35,211,209,233,80,247,238,234,249,141,110,231,207,131,132,196,156,43,11,23,104,231,251,151,21,62,110,10,28,145,209,97,107,152,198,167,74,164,155,222,43,147,211,17,209,208,111,16,152,36,111,162,29,101,80,129,34,71,45,14,125,216,0,201,94,44,53,236,223,84,17,102,193,164,76,46,251,214,64,235,124,216,129,72,191,215,133,186,129,85,119,255,114,233,251,200,176,239,177,191,170,146,185,168,16,166,196,48,56,196,13,44,95,114,24,100,19,236,152,39,36,101,30,194,198,178,217,178,247,79,114,27,34,223,220,61,215,123,16,1,122,164,37,119,10,78,130,54,101,61,114,10,96,248,87,181,198,96,161,180,28,177,6,17,112,208,203,215,115,74,18,133,239,159,151,246,35,145,82,30,250,254,75,234,65,248,218,96,151,60,52,126,184,121,171,25,238,218,208,197,13,132,107,109,67,44,190,233,45,198,151,53,38,114,146,157,194,83,32,47,243,168,86,34,36,4,196,27,218,38,72,75,147,254,250,127,89,217,9,55,98,228,115,85,255,238,62,143,52,12,14,89,145,113,99,168,25,165,34,212,221,160,115,44,74,107,37,80,59,14,124,90,25,98,21,195,201,126,154,26,115,28,147,114,228,91,100,51,38,222,135,132,169,230,198,82,63,121,110,95,94,167,44,246,142,58,105,222,14,142,107,66,57,205,36,118,167,237,57,136,243,245,228,209,205,165,100,18,68,198,128,177,181,17,247,205,56,111,27,160,28,228,181,25,213,36,233,229,223,87,132,46,235,100,59,6,181,211,101,155,165,42,250,169,146,71,42,241,244,162,170,63,101,208,157,69,35,172,221,166,159,173,141,241,85,228,81,235,103,20,117,5,54,231,68,118,194,141,194,170,124,189,3,240,42,58,44,19,231,10,240,60,164,70,254,119,209,189,234,250,148,248,8,205,244,13,128,45,226,69,192,149,13,81,76,80,86,211,162,145,65,229,127,164,220,233,245,210,168,174,183,222,67,138,148,130,26,46,25,90,2,233,70,237,50,24,127,102,6,3,182,203,210,78,150,59,50,129,232,228,243,184,193,185,250,216,28,18,42,86,55,127,238,43,106,246,134,118,113,80,9,46,17,136,243,175,25,79,207,83,151,177,84,71,59,141,33,86,214,2,211,119,150,252,55,112,84,108,1,73,189,165,246,183,4,245,150,255,120,217,111,4,19,72,39,202,44,21,214,149,248,236,64,3,178,149,126,230,168,231,132,59,145,74,218,236,148,9,17,71,253,112,173,173,204,142,99,191,246,235,247,132,254,38,184,160,36,182,203,140,111,144,202,15,62,106,128,253,148,66,168,70,255,98,6,190,160,16,145,111,199,177,243,28,84,216,84,96,6,228,171,33,250,159,45,9,78,55,210,220,21,166,49,160,138,131,162,102,191,128,243,103,213,45,142,42,33,59,173,34,40,232,66,34,106,106,139,180,237,130,8,149,224,2,89,90,128,146,95,96,52,78,245,104,94,164,59,108,86,109,187,34,40,30,23,186,119,153,85,70,13,202,204,61,13,215,239,2,54,250,197,96,146,107,94,109,181,226,241,3,102,83,48,166,62,114,37,141,10,33,227,229,253,178,142,133,71,158,71,185,183,248,196,163,212,27,134,241,251,105,180,28,162,197,162,119,111,201,113,47,190,138,205,227,126,82,84,154,12,162,17,238,184,51,184,228,251,10,203,80,35,236,204,152,16,29,72,116,66,169,79,252,136,85,66,34,49,126,143,193,2,12,35,192,72,55,94,147,100,137,243,231,18,67,7,145,53,66,218,131,35,238,203,133,79,23,147,61,189,217,181,6,254,26,207,216,228,12,255,103,84,97,146,135,248,139,199,95,159,252,59,1,54,28,53,49,221,55,221,168,194,89,91,82,109,80,111,176,252,173,164,189,104,146,23,157,224,100,152,218,137,70,46,246,177,138,150,64,175,106,201,187,18,184,174,49,215,109,142,211,105,6,70,140,101,86,236,156,37,61,132,35,80,49,67,213,49,91,245,131,161,5,231,243,14,197,23,55,187,226,176,105,202,34,165,5,59,39,53,89,29,173,0,97,10,235,245,241,54,146,115,137,229,225,195,68,180,41,227,46,192,59,170,119,12,48,8,40,167,119,253,158,194,115,1,18,6,118,224,101,227,220,23,121,80,21,37,68,147,150,71,57,14,237,128,47,122,235,158,247,161,236,199,8,138,160,205,179,47,190,187,25,201,88,143,93,72,223,252,54,25,146,162,202,165,45,16,53,35,78,138,186,121,131,206,255,143,52,146,13,40,254,41,162,123,189,191,112,33,69,86,205,49,244,134,250,200,251,213,197,30,105,90,13,11,243,132,169,43,151,180,89,1,92,64,231,36,41,12,59,248,192,250,204,132,32,38,170,111,178,245,6,157,153,231,146,38,242,6,98,240,225,93,33,109,62,143,59,196,129,55,245,196,255,150,228,143,172,138,122,83,103,222,120,7,251,228,189,43,63,50,230,67,20,144,243,123,177,213,45,194,248,253,90,222,138,254,21,208,6,235,215,235,110,193,206,1,146,40,113,69,32,56,51,41,88,29,44,63,138,180,102,208,108,196,89,159,59,255,3,83,45,125,238,79,7,182,226,105,247,176,157,101,67,75,20,125,79,157,163,67,204,153,202,64,59,117,121,44,130,227,187,94,70,68,224,14,187,227,20,159,213,61,156,228,169,189,152,247,43,20,181,5,130,244,224,145,160,78,135,193,19,130,105,121,247,33,248,23,163,209,42,141,88,124,92,107,148,59,189,209,241,53,231,138,193,108,1,54,82,119,154,163,135,7,116,213,61,157,129,225,26,77,139,144,201,175,84,4,76,100,196,58,173,27,52,130,146,130,232,234,97,153,182,75,39,164,64,116,7,171,6,153,247,89,158,69,232,66,204,244,90,67,105,249,76,143,11,180,241,123,83,190,197,236,189,55,90,94,214,157,16,253,222,91,214,152,248,125,159,178,41,106,142,141,188,130,219,218,30,70,75,178,70,183,41,121,23,47,8,97,20,208,9,38,169,242,111,137,96,191,210,236,3,102,80,131,186,204,73,13,74,101,37,237,6,27,197,115,56,15,50,192,82,90,163,172,194,237,2,177,200,241,239,122,158,216,220,228,195,147,150,155,107,10,254,51,123,195,201,248,8,80,207,145,240,158,245,69,32,17,159,161,94,205,12,196,107,236,238,134,202,75,161,232,201,60,217,88,165,37,36,145,143,28,191,171,209,242,232,172,35,227,55,158,125,4,122,9,165,215,241,97,73,158,112,185,223,31,166,72,14,105,21,224,14,231,190,139,78,76,251,128,225,201,3,99,70,120,197,64,177,45,147,237,36,185,214,59,106,11,109,24,234,109,249,116,67,133,87,214,220,41,255,143,223,121,195,241,61,80,57,3,135,13,12,53,17,252,81,113,45,12,215,188,10,120,39,18,201,93,44,2,174,94,155,236,72,126,72,69,229,171,78,202,48,52,55,47,131,221,37,51,177,209,115,97,98,228,251,40,85,86,217,162,240,55,66,135,27,242,70,175,70,0,219,39,230,49,73,212,238,162,213,82,253,133,203,94,112,33,252,183,28,178,40,237,206,21,48,165,144,172,142,5,58,46,47,224,249,125,114,146,130,51,137,234,178,23,6,135,38,14,122,75,169,103,150,215,223,87,190,116,152,128,21,241,187,197,145,153,208,252,70,161,153,14,214,245,134,221,221,241,27,50,72,182,131,50,179,155,72,237,11,110,255,28,38,224,195,254,202,139,153,203,192,22,228,77,214,131,203,75,154,129,146,142,114,165,9,178,253,78,145,119,209,53,65,216,56,172,58,71,135,189,8,102,233,204,12,25,148,117,32,82,179,55,87,111,46,107,180,87,124,168,21,238,4,15,235,47,229,55,23,50,169,61,7,241,151,89,126,185,57,214,138,139,191,220,71,155,161,102,160,59,255,16,25,198,122,26,132,122,65,234,15,233,52,254,199,135,162,31,117,19,21,53,139,93,37,186,0,243,169,226,125,81,83,234,66,109,254,102,68,135,49,135,129,166,110,173,36,212,63,255,60,161,238,183,239,172,148,190,134,126,68,31,19,202,14,110,202,24,241,218,57,57,166,48,107,169,53,191,181,30,49,98,152,13,177,202,192,189,93,159,97,6,78,156,62,174,46,97,219,170,30,28,5,147,189,41,78,37,29,250,92,10,246,215,152,132,21,104,38,40,9,75,249,174,193,190,141,251,54,184,91,191,190,78,222,108,6,127,162,166,123,214,219,157,195,32,97,86,130,166,164,75,177,41,225,103,146,91,146,230,147,3,198,111,9,223,14,91,213,229,134,34,20,157,152,154,182,128,211,232,121,205,44,78,251,103,113,187,166,24,88,160,217,175,3,249,25,137,218,208,68,147,225,70,84,252,191,227,4,236,10,179,222,203,15,72,195,142,78,15,155,25,245,102,70,145,178,76,20,166,148,57,143,37,207,26,242,238,74,88,129,255,126,229,187,143,104,84,45,74,181,254,205,27,36,66,106,132,150,219,246,80,156,217,85,81,229,125,233,250,96,53,142,179,163,243,233,233,193,172,224,254,22,154,87,220,169,233,18,33,97,197,221,142,99,144,53,2,237,124,89,50,71,46,176,44,222,126,50,151,34,223,10,5,137,160,166,66,142,56,3,98,249,57,141,59,83,251,173,61,177,113,248,206,35,180,240,247,90,15,191,189,241,51,13,42,19,167,55,248,148,249,94,131,161,226,205,84,204,176,117,223,15,186,149,182,31,100,210,219,151,248,88,209,96,141,254,11,96,173,58,229,74,21,182,19,242,39,189,64,226,162,17,155,94,99,114,28,134,128,178,103,238,166,6,179,81,203,17,234,131,123,192,247,210,156,74,89,40,13,136,55,224,241,95,237,84,214,138,69,156,210,4,74,178,173,51,159,208,166,62,52,125,61,116,134,31,58,80,29,247,193,30,164,132,99,31,237,47,78,112,252,42,125,221,73,73,139,120,130,201,161,175,90,212,179,255,105,223,71,28,7,123,199,56,195,245,199,214,60,17,105,177,41,41,195,179,133,145,156,212,147,123,16,227,199,103,53,133,116,6,71,191,30,136,121,184,87,175,222,248,50,249,134,252,16,203,192,24,89,70,80,117,89,152,150,20,93,236,254,44,117,180,84,217,154,221,44,40,105,53,38,188,179,142,72,77,190,199,102,240,234,25,95,2,84,15,163,61,251,67,23,148,239,70,236,150,17,179,72,1,245,58,111,33,206,212,52,162,133,134,177,101,248,108,101,93,73,32,169,62,230,235,35,100,157,143,141,90,248,35,121,196,138,247,217,58,177,223,14,129,81,113,146,128,75,89,217,131,47,243,72,191,180,113,226,112,210,75,108,107,13,55,185,219,78,70,59,87,11,225,35,252,132,33,190,145,65,85,59,190,132,232,36,193,237,74,132,109,143,148,86,145,222,166,59,196,20,190,183,129,196,47,97,83,177,31,90,66,174,32,149,173,251,83,25,48,145,78,194,36,64,195,140,133,84,61,36,255,136,5,237,106,23,55,138,95,99,116,51,246,92,145,226,60,111,59,236,147,36,238,169,157,241,115,168,238,171,127,210,68,197,143,217,102,146,190,142,4,178,153,60,208,250,99,50,158,157,22,81,50,69,72,131,160,127,249,210,64,21,44,224,239,129,126,238,254,206,102,161,225,44,249,56,43,149,18,37,203,212,110,159,151,149,143,27,162,81,49,142,3,247,45,56,51,144,154,74,174,148,208,71,81,47,229,71,4,224,91,152,60,254,163,166,30,32,74,142,250,133,216,208,173,214,73,212,2,83,180,182,205,143,39,121,32,155,161,126,225,150,98,196,136,117,144,24,98,184,227,16,65,152,192,208,225,109,151,117,108,253,160,254,99,224,1,202,21,196,42,60,59,133,123,245,133,185,16,216,201,145,229,122,251,187,191,96,74,94,136,230,206,27,46,184,206,159,43,31,191,25,151,118,234,193,131,118,2,65,241,43,73,205,211,217,231,48,202,74,199,159,252,45,51,118,2,46,248,104,154,134,85,254,121,29,94,49,122,42,81,212,32,26,171,249,217,201,140,195,139,135,213,150,112,116,190,149,204,192,183,130,174,213,153,117,130,70,3,24,27,186,190,169,209,33,14,83,250,63,140,202,217,192,118,132,59,153,201,207,87,166,73,217,80,43,253,43,104,100,58,133,11,238,241,235,95,107,149,156,152,219,212,225,56,188,217,188,79,135,108,57,251,79,197,162,21,51,69,29,111,117,212,196,49,148,80,154,11,17,138,20,46,89,22,171,242,114,251,62,145,38,250,142,30,247,68,230,112,25,12,83,61,205,252,171,219,230,226,109,99,0,174,176,27,66,139,39,165,137,202,242,119,220,130,233,81,242,191,68,115,244,66,228,238,238,214,106,28,196,223,157,130,199,168,13,151,34,201,244,182,81,249,209,226,245,40,240,47,132,231,188,41,206,111,88,55,89,109,72,142,99,117,83,173,149,32,51,25,250,2,183,50,182,162,11,208,152,95,10,82,132,147,99,53,112,40,232,236,103,233,75,148,216,246,145,121,179,32,8,52,142,232,187,15,145,99,202,164,159,96,132,137,49,208,138,56,77,103,220,110,204,97,91,226,191,19,42,133,106,110,21,188,146,221,28,214,36,147,245,84,198,228,203,123,243,173,194,237,56,184,54,237,148,254,189,164,228,6,110,141,199,241,219,46,160,88,118,167,55,109,203,167,239,53,182,75,100,219,247,201,239,109,216,48,178,93,189,205,163,159,137,216,155,245,219,128,133,47,53,212,55,201,176,52,2,33,106,109,117,80,1,167,95,142,107,213,250,240,224,209,143,165,36,23,187,72,116,135,58,40,132,81,180,142,229,239,223,20,218,144,89,109,66,90,157,247,81,201,109,45,48,55,86,249,99,180,49,229,234,131,63,184,241,206,182,85,43,125,165,220,199,29,202,192,226,241,79,49,47,199,118,151,76,165,222,174,170,123,128,64,59,193,87,155,31,255,50,218,193,132,64,139,208,84,206,173,163,101,129,210,187,185,3,31,56,108,184,110,250,198,231,0,213,79,175,236,169,62,78,28,106,65,217,144,188,193,200,195,156,202,221,50,95,207,14,119,74,127,14,10,221,104,252,195,52,21,119,90,149,167,14,254,250,228,140,167,141,144,164,248,186,84,223,107,154,102,102,57,154,23,1,4,60,252,202,185,108,4,188,70,84,252,245,212,217,77,65,255,201,148,166,0,158,79,69,170,155,231,95,179,160,132,117,52,195,181,69,219,149,251,187,80,183,114,60,142,26,182,84,70,253,132,60,113,213,137,171,13,134,175,11,144,13,240,120,124,196,93,208,193,87,63,186,139,160,192,38,98,20,214,176,43,66,123,231,173,126,15,115,34,26,100,20,195,39,120,44,139,100,27,13,182,182,14,157,72,226,56,55,77,121,191,61,108,187,71,197,253,89,101,162,99,83,142,245,226,163,254,119,52,62,179,101,73,139,210,106,131,119,54,86,250,162,179,164,41,54,15,153,213,83,88,151,251,41,151,28,125,184,132,125,131,227,77,25,78,70,149,128,34,254,62,57,220,14,122,212,73,10,182,71,126,5,152,165,169,161,209,29,154,122,32,50,142,36,114,0,218,170,129,239,159,247,69,133,221,199,246,136,176,156,31,32,247,172,176,88,17,45,120,221,104,40,194,99,142,91,3,143,66,118,55,122,195,69,176,48,4,43,68,75,89,166,195,204,44,13,221,252,74,148,45,214,66,3,121,30,42,233,186,97,50,124,78,93,119,151,246,178,123,128,24,204,71,43,181,8,77,75,191,57,18,88,230,100,200,33,77,81,135,19,155,172,48,235,246,236,155,45,64,50,191,16,14,23,21,57,243,187,17,207,2,32,15,215,198,242,158,186,153,238,179,78,170,147,153,4,104,145,205,2,56,7,224,62,194,182,90,205,168,87,243,27,136,10,100,57,53,146,111,102,41,52,252,96,151,69,74,196,160,32,120,185,190,196,44,212,215,127,168,203,96,185,85,53,254,105,12,3,218,114,39,98,50,40,240,226,237,52,100,56,173,115,163,126,201,125,136,81,220,162,142,208,89,255,135,109,83,17,146,168,224,30,170,163,193,86,152,207,139,251,37,198,195,97,197,21,229,161,7,17,235,47,185,29,83,255,160,178,141,169,163,88,76,138,151,55,228,10,252,160,113,161,106,214,148,43,4,246,62,252,5,224,25,180,121,83,42,57,39,177,0,172,52,185,99,232,130,184,176,108,139,245,152,6,248,65,192,140,156,212,163,170,135,150,187,239,72,183,218,221,233,102,208,177,125,119,219,108,249,192,152,252,244,52,135,254,231,200,37,26,206,88,199,40,230,187,243,58,8,72,108,146,162,3,216,183,211,107,224,4,179,158,84,132,29,134,188,206,223,81,110,119,229,52,141,253,50,105,50,104,175,180,233,150,218,2,84,30,70,72,49,205,166,42,169,174,151,159,139,33,14,210,46,119,237,153,243,140,39,221,226,11,201,205,174,17,172,120,120,250,111,213,42,109,2,217,109,231,220,96,27,163,169,210,237,55,96,94,169,29,57,250,209,151,63,82,159,69,119,73,232,86,82,172,171,34,80,112,122,1,186,78,83,191,58,207,153,137,153,221,20,74,251,120,217,225,42,3,31,148,15,149,144,4,119,143,22,175,236,171,61,205,112,227,123,233,80,157,251,233,175,57,23,228,223,108,95,15,1,51,132,201,164,124,5,4,161,35,65,203,43,18,191,158,190,103,223,240,126,108,98,201,59,114,123,110,45,112,37,168,140,221,6,101,187,215,107,42,193,95,118,140,250,178,110,198,165,161,239,67,69,149,140,166,66,204,247,191,233,178,193,74,217,1,110,84,151,71,130,153,168,63,2,170,128,56,243,97,194,226,250,22,218,38,100,202,69,213,175,248,200,121,21,141,120,49,11,127,223,75,207,82,217,59,189,50,219,189,77,17,75,90,30,176,78,234,183,36,116,174,246,162,41,253,21,202,42,196,247,234,151,32,176,156,237,98,70,121,20,235,41,173,121,1,254,143,191,137,241,87,210,212,228,199,124,136,188,85,65,11,93,184,205,78,71,43,159,143,37,156,16,17,255,104,110,172,139,114,217,162,135,207,241,199,41,200,174,154,218,76,163,248,252,128,220,248,122,177,158,11,213,78,158,143,35,2,237,41,32,10,22,219,17,247,143,124,83,144,161,161,219,127,159,185,183,100,131,87,112,178,162,79,96,70,22,143,60,152,216,111,25,177,194,130,228,2,142,241,118,83,233,237,57,232,143,20,55,71,108,80,32,84,46,84,64,111,41,132,4,253,190,142,85,151,3,165,33,102,167,213,231,172,154,7,50,193,38,63,94,236,64,124,160,53,65,123,69,62,216,170,11,25,202,61,216,105,102,198,104,244,102,99,122,44,97,23,163,20,236,194,16,237,243,41,88,245,174,67,3,128,21,195,226,115,210,142,233,174,157,140,161,137,28,230,121,109,128,110,60,230,159,138,180,63,124,162,111,28,68,34,205,207,251,146,177,159,28,234,91,165,205,107,144,215,246,170,248,1,118,96,0,187,198,229,223,80,129,221,117,14,125,153,10,86,102,32,73,72,59,197,248,188,242,252,109,249,123,180,102,225,1,52,74,30,182,21,243,32,157,87,255,223,162,188,86,229,227,221,191,196,208,51,38,121,252,22,141,63,40,68,80,254,57,77,58,90,243,39,117,160,166,240,211,1,7,138,49,205,193,73,168,140,30,7,119,147,11,60,163,35,90,219,146,104,190,223,255,198,201,1,166,128,101,253,49,212,133,65,238,233,34,45,217,9,169,20,100,120,161,122,9,235,38,105,48,213,145,41,240,167,226,125,215,97,245,207,206,157,222,209,152,178,162,215,110,245,217,248,168,108,51,166,26,27,50,132,224,236,189,114,134,215,21,112,233,101,16,210,180,45,127,49,22,80,220,135,109,240,182,99,211,74,22,109,242,143,25,243,78,217,155,180,108,217,119,211,249,36,208,95,184,167,216,86,112,147,153,242,85,6,141,252,109,252,10,230,220,64,129,129,207,252,166,62,176,110,115,79,87,28,38,58,1,45,122,113,220,207,75,252,97,129,47,155,213,108,232,64,82,36,75,243,136,183,154,138,50,47,241,210,39,119,55,246,143,108,41,169,125,71,154,29,200,215,33,13,158,204,35,239,253,89,252,65,134,48,6,218,55,84,98,17,251,225,152,133,150,107,51,150,141,218,77,61,109,112,79,233,216,245,50,239,65,14,31,123,243,118,124,20,187,241,5,61,142,172,45,175,165,18,43,159,218,169,185,142,23,41,92,121,165,42,153,110,122,71,199,252,140,244,214,239,43,104,78,177,54,61,240,160,17,132,202,137,200,19,81,198,112,6,104,251,27,199,228,136,153,148,38,231,101,205,93,105,50,220,40,148,20,63,137,239,167,69,1,188,199,15,15,19,6,90,49,68,189,221,80,194,127,216,88,232,205,184,42,50,165,22,75,190,220,172,176,7,30,195,225,22,216,166,216,13,180,162,144,194,54,204,64,240,155,149,8,31,138,75,144,51,234,119,45,8,230,158,52,57,95,151,227,111,37,140,69,160,102,234,23,140,191,103,109,42,222,75,158,46,203,105,210,236,132,205,49,38,92,88,252,79,55,46,167,146,2,145,113,68,145,101,99,233,198,169,196,188,72,62,207,98,170,31,68,117,160,124,64,244,28,65,148,159,45,52,12,178,47,11,228,149,201,76,207,238,104,74,11,119,214,176,108,94,212,114,191,106,90,205,128,176,79,211,127,139,60,185,221,140,135,13,114,61,29,26,98,189,61,59,244,20,131,34,187,34,111,64,157,31,94,90,208,245,233,227,34,251,27,247,69,1,135,169,118,154,202,185,194,140,254,229,241,225,240,162,0,149,37,202,65,185,177,214,223,98,74,205,212,218,52,132,116,163,125,156,152,131,92,107,124,85,251,36,197,11,120,135,36,102,12,190,9,215,78,38,110,199,126,38,104,48,171,64,192,135,15,190,82,11,86,208,240,124,8,43,67,118,238,193,103,43,35,92,121,34,78,186,237,173,89,3,251,14,144,73,147,161,217,247,43,160,0,130,159,248,54,119,195,210,246,79,36,215,135,119,100,107,184,116,202,154,9,211,63,154,246,60,242,195,95,16,179,247,148,242,134,141,48,209,23,84,107,61,106,105,114,32,86,108,160,77,33,79,230,190,133,161,200,215,150,150,7,202,109,249,238,163,11,216,142,239,212,152,44,11,196,47,121,74,155,26,85,116,9,161,120,6,97,82,50,33,184,113,218,31,51,192,91,211,241,126,178,246,104,44,165,105,162,12,101,107,194,98,195,147,158,199,103,89,115,60,17,119,209,64,122,18,99,206,185,37,217,173,25,94,252,166,98,1,177,27,190,51,96,81,132,225,124,151,160,161,10,119,53,172,48,20,77,74,81,50,155,141,189,130,59,164,63,206,200,254,203,207,194,84,201,248,68,182,231,29,188,193,182,61,224,22,226,5,241,53,132,66,4,80,176,22,159,86,82,58,2,108,210,222,235,112,173,253,126,27,66,165,177,136,219,36,70,189,21,100,244,178,191,237,171,60,112,156,109,213,101,234,87,157,57,250,29,98,123,188,109,15,166,95,173,146,88,218,222,255,220,12,231,13,43,219,70,71,136,147,254,84,147,37,255,178,200,226,0,106,42,130,28,92,21,173,112,196,76,201,38,205,12,86,177,19,166,13,44,95,60,38,158,222,146,245,109,73,77,32,17,0,192,43,48,40,62,136,117,141,96,199,6,171,229,72,57,252,187,220,161,87,205,232,59,46,223,34,225,224,119,171,175,234,140,57,27,200,19,230,66,47,174,212,241,212,157,71,213,226,50,171,23,78,178,177,226,130,38,248,250,131,6,126,86,155,230,254,199,3,23,64,145,96,181,183,112,220,19,238,18,161,139,155,28,55,178,9,162,129,123,64,202,116,140,196,200,81,117,131,142,40,223,24,169,170,109,57,22,251,142,250,210,75,145,172,70,234,9,193,24,48,113,207,55,140,78,27,234,3,219,174,215,228,91,162,158,9,11,106,160,128,53,193,200,89,3,216,175,177,191,179,218,29,240,42,161,39,133,177,63,167,68,240,71,106,84,86,156,59,51,16,90,184,18,153,185,110,163,115,219,230,90,53,226,157,17,50,33,34,88,88,30,236,127,117,10,202,126,48,176,176,77,1,124,1,228,229,142,38,109,207,25,207,48,201,230,184,27,172,215,60,80,54,93,29,151,126,83,152,138,188,160,244,46,90,27,196,231,187,2,119,0,60,20,204,178,118,139,143,84,0,40,83,49,33,84,41,227,193,111,147,41,161,14,216,246,252,170,230,16,165,172,37,174,89,65,157,89,208,226,41,11,161,249,91,202,22,185,248,131,178,111,107,148,194,22,153,2,194,125,152,251,129,129,124,102,126,159,29,168,115,25,176,150,33,173,60,125,185,104,160,75,32,10,241,100,31,8,43,210,206,226,8,221,65,213,168,233,240,25,195,20,213,189,3,138,245,192,151,98,163,50,177,173,175,250,126,3,206,80,130,221,222,131,139,72,40,54,93,208,202,67,167,46,99,243,89,99,186,215,76,146,124,148,21,206,19,53,16,224,177,114,203,42,202,238,225,255,87,19,212,164,52,144,210,125,140,181,151,249,254,119,122,66,236,226,30,192,242,5,163,141,222,200,221,197,33,166,24,170,148,66,220,191,106,255,114,129,15,246,152,193,178,226,36,118,142,152,221,135,131,130,96,195,206,180,43,178,231,250,144,205,119,175,68,230,115,232,111,91,138,193,103,54,193,140,130,80,181,185,36,135,245,11,202,59,212,205,231,179,93,158,128,135,139,114,145,141,225,177,66,84,234,122,169,13,251,44,24,182,141,253,7,54,26,108,122,50,215,232,101,174,108,176,24,89,37,113,247,147,170,216,214,29,103,123,113,125,32,71,137,131,107,151,154,26,97,205,105,47,192,161,60,95,83,39,77,134,29,72,80,88,178,172,154,32,4,6,238,35,141,88,246,164,58,223,180,196,176,50,207,78,237,178,74,74,104,136,120,233,223,251,154,223,137,198,8,245,26,177,216,61,87,117,105,105,74,90,135,161,92,175,230,59,236,54,123,115,51,247,219,130,23,221,36,48,42,140,191,135,34,80,151,149,15,162,85,156,26,144,229,27,24,235,219,179,231,248,167,119,198,232,146,208,185,130,248,185,22,14,225,80,25,235,157,68,211,212,214,239,221,146,107,214,191,229,90,151,137,76,74,17,90,46,55,228,71,69,41,215,102,205,14,215,176,102,26,47,28,136,211,184,238,85,57,231,64,28,43,191,84,99,59,181,106,91,94,236,244,109,14,4,237,38,96,119,21,151,55,238,127,125,95,167,120,0,227,87,164,66,148,209,42,50,64,9,86,12,90,76,116,175,47,31,171,111,78,134,250,248,216,190,133,22,147,60,189,84,212,239,104,240,185,100,141,150,159,89,36,134,254,2,228,196,2,201,198,185,42,37,153,240,218,173,68,186,242,110,78,213,59,21,44,31,202,148,79,88,145,109,4,131,134,177,77,224,79,198,37,213,173,37,43,81,144,170,124,116,189,218,237,88,21,171,80,235,245,237,160,249,136,225,43,243,135,3,97,192,48,181,6,57,206,212,115,4,67,202,101,210,27,204,206,79,205,221,179,189,192,178,233,56,230,70,70,209,210,251,73,120,195,1,161,136,196,17,176,71,215,129,240,169,52,131,190,211,35,250,18,186,156,65,253,151,28,113,142,156,224,26,209,13,34,33,88,180,193,132,178,245,89,56,165,135,42,38,175,16,180,0,103,124,215,242,122,121,107,221,151,37,187,82,112,9,30,186,142,203,249,48,173,196,155,199,70,219,81,13,135,190,219,54,42,100,180,7,44,151,77,91,102,202,171,146,67,63,60,244,36,127,118,14,82,157,138,219,130,157,42,169,51,248,0,92,218,187,152,174,159,130,185,41,43,1,78,100,243,236,139,58,144,66,80,182,251,8,236,39,92,78,8,137,65,96,93,174,167,29,209,19,103,235,164,242,92,250,32,154,128,215,107,209,158,222,251,138,236,107,10,162,78,71,157,179,75,69,208,206,104,230,167,88,61,209,197,9,149,175,138,46,174,36,127,71,194,94,119,222,82,103,75,4,19,146,49,85,252,120,187,120,91,93,225,166,160,201,81,53,94,181,166,207,82,40,83,235,5,253,147,148,53,79,200,191,40,113,216,168,233,72,178,21,135,242,137,97,234,134,7,9,232,60,100,55,10,47,129,42,223,202,168,200,106,138,217,185,8,110,93,164,101,173,219,209,18,151,159,238,239,191,57,80,9,93,118,12,146,127,131,225,192,45,79,225,79,221,82,143,159,219,56,58,67,77,202,210,222,251,86,167,182,98,182,226,155,98,74,15,24,57,89,116,80,22,141,111,81,221,147,172,174,191,92,53,157,255,149,223,211,67,43,170,77,182,124,108,183,93,120,25,113,141,153,60,147,253,23,42,16,142,67,84,176,133,221,78,21,56,201,204,109,190,230,209,103,231,14,77,11,151,183,10,231,217,208,113,234,32,228,12,108,39,190,219,213,147,58,166,96,113,203,10,31,215,40,68,200,50,163,173,184,248,99,191,82,115,73,234,97,1,117,21,106,240,83,48,103,200,154,147,53,209,19,206,148,181,194,134,155,130,53,71,41,11,65,183,186,239,70,212,105,4,237,210,231,57,153,231,110,113,169,192,239,88,203,208,204,116,154,77,80,34,72,236,58,145,47,116,138,234,93,15,126,94,221,249,13,183,59,160,165,58,215,97,185,163,196,14,230,87,174,20,16,92,196,236,135,214,118,168,78,27,69,128,104,238,104,118,22,104,43,8,81,98,94,33,114,52,73,186,130,104,146,255,174,205,10,151,47,126,102,185,156,56,245,207,6,10,177,202,211,108,56,179,79,229,137,250,38,88,78,149,24,106,77,244,102,184,52,125,39,201,200,209,58,116,229,20,198,92,148,60,235,168,0,138,86,23,90,250,192,20,107,207,8,200,17,243,41,37,129,144,216,87,240,94,159,82,236,246,184,60,78,227,51,198,39,13,164,206,176,212,192,128,199,31,122,160,84,156,73,214,65,13,119,59,121,121,34,34,202,87,68,15,156,7,230,222,209,217,27,144,74,253,251,0,170,248,219,49,108,14,198,111,195,175,173,107,169,170,125,235,238,198,246,230,217,109,145,29,135,131,2,126,207,138,51,25,122,215,132,62,179,41,30,59,97,144,39,209,127,179,225,62,146,0,71,93,190,234,97,154,55,25,223,223,56,90,82,182,201,244,157,238,50,252,20,241,61,138,71,161,34,198,47,87,10,221,239,255,199,230,87,207,195,177,18,193,129,242,159,207,242,237,48,23,149,99,162,114,34,208,75,195,122,158,216,165,197,72,83,103,30,209,90,161,87,43,211,67,112,9,110,194,215,167,140,144,131,80,116,118,156,216,54,199,177,23,222,69,215,133,241,129,51,195,151,102,220,123,163,103,142,95,52,57,58,250,198,111,114,233,153,177,183,248,63,219,186,243,143,237,227,95,150,207,118,92,248,5,66,96,161,171,119,222,93,20,114,149,30,250,182,214,28,39,71,32,55,25,136,22,1,246,207,22,81,161,102,240,137,139,80,88,45,49,15,171,68,133,164,102,248,48,94,16,165,65,61,89,88,88,180,32,36,119,12,247,240,68,16,13,50,223,20,33,58,97,102,164,91,177,212,83,203,243,174,158,238,62,53,238,173,128,121,110,60,165,221,23,142,7,48,186,244,84,191,237,247,124,210,217,36,161,34,70,59,147,152,109,188,171,223,108,98,224,81,52,98,59,199,49,148,231,94,241,23,12,212,139,84,35,209,157,177,33,71,229,17,134,160,95,93,25,179,49,255,197,35,76,170,104,106,11,228,91,255,91,3,75,25,139,252,128,218,152,186,39,27,12,153,248,98,226,39,6,149,192,135,67,16,245,73,60,27,77,217,239,180,237,210,14,65,25,40,46,242,162,195,68,221,101,234,1,43,109,1,102,98,34,76,101,39,209,9,172,77,189,47,42,89,136,195,131,60,152,6,146,136,108,114,229,177,231,73,29,248,106,195,27,158,149,161,102,184,136,99,134,201,233,102,230,78,255,38,178,155,24,59,134,242,92,84,18,115,84,197,174,3,32,208,56,94,254,18,39,33,75,133,162,13,238,7,140,187,28,55,54,59,67,220,1,17,23,136,66,116,128,193,136,242,138,90,154,70,151,198,114,130,194,60,232,23,127,63,83,200,125,125,24,95,82,89,216,1,97,238,143,32,226,120,126,113,39,58,137,207,2,164,74,38,82,145,237,252,220,60,117,174,120,32,66,0,87,151,110,4,219,96,146,29,0,108,92,90,46,156,244,172,58,166,242,238,155,234,128,39,75,185,117,176,15,0,153,167,35,198,44,128,236,182,188,200,155,28,2,237,232,114,27,58,105,26,99,42,159,91,246,6,39,82,10,117,206,182,23,143,192,40,202,11,223,244,53,202,139,227,87,192,105,118,58,131,154,19,167,36,103,174,1,217,24,153,12,130,190,188,185,101,159,222,102,79,24,72,22,171,63,101,37,44,224,54,63,78,183,171,31,24,98,227,240,125,105,131,10,86,11,37,38,245,214,38,116,160,165,55,146,131,155,160,251,100,223,212,177,217,190,220,103,154,143,100,252,11,132,126,75,70,215,11,130,117,197,22,224,168,238,31,74,243,73,192,236,97,108,33,255,89,192,13,182,11,67,182,247,56,149,76,7,115,150,102,202,216,95,235,169,210,36,194,103,49,24,118,46,130,88,152,25,151,93,24,213,210,143,55,80,37,36,28,108,23,195,84,201,92,34,171,84,42,117,181,39,191,64,230,105,130,112,145,144,38,196,104,146,189,204,25,15,199,167,5,80,63,8,248,167,158,116,178,115,163,124,116,94,91,168,213,92,189,41,80,130,110,7,90,63,249,170,207,254,17,248,33,67,32,248,242,101,68,177,179,2,113,120,1,104,205,180,209,11,195,89,189,145,173,114,129,124,81,50,104,210,31,110,4,41,22,74,240,82,28,58,195,195,22,207,118,235,246,173,51,127,211,201,217,235,165,75,112,39,181,235,225,125,201,83,180,118,183,172,37,215,188,229,129,70,4,182,246,96,187,169,74,197,200,18,0,145,142,26,247,141,183,154,71,121,67,127,41,218,177,80,131,41,10,225,187,134,250,194,50,215,124,27,70,74,230,146,137,198,166,157,176,244,218,95,230,40,217,246,107,74,150,190,33,220,130,238,133,100,109,10,247,70,232,182,42,73,142,66,162,46,160,122,123,96,35,80,95,151,83,163,75,201,148,253,114,108,123,85,147,136,99,63,9,58,6,37,55,166,179,182,18,159,191,17,18,9,28,194,22,204,140,105,28,67,237,75,216,190,237,26,52,120,21,35,167,91,149,74,91,83,58,4,3,179,133,35,216,1,33,231,138,136,13,138,38,146,232,167,204,228,237,180,210,193,157,225,32,129,0,176,91,163,31,178,219,173,199,205,145,148,123,20,61,251,13,111,191,181,27,243,12,160,77,165,101,226,240,18,0,8,43,78,135,24,14,42,217,33,10,183,250,199,117,83,24,32,125,129,137,143,213,119,132,89,43,164,188,97,172,164,103,163,88,230,91,237,54,248,85,21,187,0,124,40,67,79,46,247,29,74,136,168,95,59,131,205,64,163,102,12,150,246,148,231,103,248,181,187,248,38,32,218,161,39,213,25,125,170,26,27,219,213,119,165,80,99,207,250,162,167,19,240,0,91,42,202,45,197,90,73,78,176,229,54,208,151,7,139,130,20,79,184,197,186,226,142,17,68,53,128,208,34,95,219,63,248,15,112,38,26,75,129,157,229,82,94,179,77,17,209,204,156,172,213,31,101,72,74,88,202,88,48,252,96,116,50,173,164,6,203,196,222,181,37,249,104,77,24,19,204,16,20,172,121,228,35,93,53,198,39,113,1,215,132,226,0,251,172,214,56,22,15,212,165,157,15,7,25,1,107,68,58,233,178,128,22,109,74,66,88,25,31,236,34,65,13,196,58,100,40,45,75,128,45,151,34,71,13,172,211,166,14,234,164,35,89,122,153,90,111,158,11,80,124,157,115,148,26,83,181,88,174,97,231,134,75,148,237,172,12,28,53,199,116,195,104,206,163,172,227,232,177,44,111,55,122,199,30,27,5,251,77,139,57,25,103,213,150,196,170,202,147,71,203,160,133,224,31,43,176,180,80,140,107,9,255,151,198,131,39,171,44,59,157,82,137,225,88,107,36,124,223,9,15,13,52,137,23,167,8,177,168,169,241,62,89,43,89,242,17,229,184,241,202,198,38,163,63,26,213,116,166,236,136,247,232,228,224,47,155,77,138,102,128,131,218,18,51,154,186,33,34,162,167,119,197,18,5,140,128,48,201,119,106,31,160,230,238,63,172,168,47,162,216,33,184,237,32,253,146,235,207,123,254,74,20,147,31,213,148,176,203,250,4,208,114,240,40,40,230,128,70,75,127,123,30,124,17,122,25,45,4,236,250,50,164,108,210,7,163,164,163,21,59,200,221,228,77,156,112,76,55,142,75,109,219,132,183,114,137,238,107,67,225,120,30,128,255,38,6,135,2,139,88,200,78,252,36,100,81,227,9,111,199,219,166,93,196,217,238,122,26,96,159,212,247,85,178,122,216,131,178,241,4,67,244,243,117,217,207,22,170,115,196,188,48,254,105,147,237,20,160,236,66,141,242,232,148,144,184,39,49,80,184,72,164,235,47,201,130,255,249,160,82,252,79,113,20,189,135,15,83,96,62,66,121,71,221,73,174,164,76,180,40,43,246,142,63,71,30,109,75,113,100,57,188,160,152,57,120,204,106,201,70,142,8,71,116,241,43,15,201,13,141,89,156,46,176,195,74,105,192,233,132,8,220,14,228,154,99,77,4,236,187,244,202,169,38,182,82,134,42,149,172,188,146,56,85,123,174,84,85,142,2,153,223,77,69,166,229,218,232,107,216,104,241,197,180,169,141,47,59,162,252,109,18,181,230,16,134,190,104,173,81,191,21,16,242,51,63,220,247,76,8,64,140,193,174,239,188,254,7,189,126,155,246,148,100,116,157,206,250,220,5,56,140,238,173,234,188,98,79,194,99,155,121,32,243,241,61,142,29,106,212,81,4,198,122,110,129,64,6,120,57,69,73,187,67,194,116,34,206,41,162,177,196,30,9,225,42,246,33,148,6,98,236,3,145,60,4,62,176,248,156,3,243,15,69,50,15,177,25,105,48,199,29,195,87,133,205,128,153,14,241,8,243,130,177,25,14,215,15,194,241,209,18,98,224,112,112,242,153,84,170,63,82,87,84,104,117,64,21,67,202,95,166,131,5,53,245,55,229,156,130,154,171,228,62,249,155,255,12,28,95,126,248,157,238,65,202,209,7,139,91,149,61,28,215,210,227,126,59,224,86,209,177,142,155,58,86,105,244,1,129,63,106,81,240,230,196,17,51,93,151,150,105,254,72,136,187,79,43,100,86,248,239,62,10,67,65,226,74,241,13,83,223,155,154,177,91,183,45,128,212,232,243,28,107,142,201,120,130,71,100,51,213,22,171,239,247,10,220,87,49,54,215,148,33,63,49,37,69,80,46,221,2,83,174,254,9,229,52,186,102,63,224,141,165,27,207,198,209,70,129,74,43,193,94,100,253,189,222,160,198,22,43,83,64,212,54,201,3,58,0,61,246,132,112,144,174,143,41,229,202,24,55,252,8,139,179,3,159,81,24,27,63,176,236,96,194,85,139,241,206,87,215,94,245,214,15,54,164,136,42,206,157,1,81,72,1,91,126,94,170,15,157,172,32,42,4,38,10,252,187,109,192,137,121,166,86,167,77,147,206,54,44,19,79,105,26,248,199,197,244,222,233,25,161,51,116,25,96,2,210,33,119,99,5,211,145,92,12,160,255,34,21,240,94,64,196,2,144,217,142,42,77,40,146,242,132,62,231,250,29,169,181,93,145,7,114,129,90,90,41,132,109,180,79,144,206,146,41,97,247,133,132,106,47,22,27,201,179,242,64,151,177,119,30,114,141,71,53,57,12,182,50,109,9,7,171,251,252,107,2,188,140,190,202,114,225,195,25,28,0,240,31,173,109,208,81,142,52,199,250,76,122,241,251,179,99,64,68,119,35,24,75,201,7,49,215,26,129,43,134,16,183,232,41,107,158,103,43,11,107,31,125,155,137,5,53,147,240,230,160,237,103,62,113,136,147,198,84,177,73,181,92,248,59,132,40,219,3,237,184,195,224,4,5,248,123,65,23,149,1,130,137,86,147,173,68,15,135,87,149,178,97,32,122,18,59,182,87,244,93,57,233,196,70,234,8,52,44,231,48,118,80,31,17,150,58,148,152,64,167,241,221,123,18,32,115,162,143,188,166,29,176,56,186,77,238,221,192,155,144,233,219,254,229,74,83,226,53,97,96,35,159,51,198,131,16,190,113,140,18,182,29,101,20,21,27,105,228,81,24,59,245,124,68,210,31,46,7,86,180,171,141,146,219,152,52,99,227,81,132,145,91,3,113,61,131,253,199,65,183,227,190,67,50,67,111,229,44,151,52,160,114,123,201,118,115,185,233,226,131,21,64,32,189,127,75,97,4,67,221,170,23,54,201,101,168,216,80,212,166,190,127,57,67,250,182,203,144,226,208,226,204,145,113,62,33,235,15,253,78,45,3,250,196,85,4,179,215,112,81,156,81,81,154,92,158,192,109,226,100,61,9,222,152,26,235,232,211,123,68,150,165,189,120,157,228,41,142,141,224,233,112,35,250,12,191,249,90,146,176,218,15,158,213,118,205,13,145,160,135,70,128,112,236,32,0,216,226,218,211,176,205,79,239,34,11,171,210,122,91,140,229,215,179,178,107,210,220,251,216,245,205,168,153,170,102,84,189,45,167,133,126,54,237,172,30,61,119,143,56,37,97,147,222,189,41,78,100,229,177,114,19,141,192,134,134,209,240,16,186,222,80,116,126,224,164,191,199,150,189,212,99,254,156,235,153,135,49,233,131,21,175,161,119,33,22,187,29,121,245,77,250,101,103,129,104,58,99,200,215,118,239,17,51,30,55,128,71,11,24,111,89,88,214,226,91,71,244,21,253,128,42,16,36,234,234,217,4,248,3,209,137,139,95,253,164,154,207,171,2,96,4,153,210,179,58,177,141,10,64,12,2,15,175,222,55,114,216,89,190,123,38,207,127,48,55,106,223,77,206,78,117,92,191,130,231,91,36,165,80,14,210,104,149,204,171,153,225,244,244,76,88,97,130,175,46,250,10,98,190,141,150,29,141,179,10,137,9,91,72,117,20,119,165,98,67,179,217,139,232,22,37,199,198,212,201,47,227,112,147,214,133,174,146,223,65,230,198,154,27,102,148,91,51,65,187,130,152,9,24,95,151,99,28,176,140,30,166,172,202,130,226,153,223,167,157,11,20,58,231,246,172,215,122,212,16,240,196,16,193,122,21,87,28,221,62,162,82,49,94,50,70,16,148,42,75,80,115,10,194,241,231,213,207,18,173,214,51,140,93,52,124,55,113,58,108,29,55,221,140,82,145,2,10,132,117,78,38,25,224,34,42,57,101,164,25,237,191,230,121,149,201,203,56,149,16,5,32,155,98,193,152,227,118,5,248,189,64,161,237,210,160,112,21,64,150,21,205,93,193,17,158,4,59,224,172,40,89,225,79,191,47,76,20,198,198,160,128,49,100,29,50,176,188,74,244,232,208,125,166,232,239,102,29,219,23,184,255,51,185,224,114,183,240,223,207,173,42,223,202,109,200,45,49,213,88,80,100,178,97,68,207,180,166,189,116,11,101,126,195,78,28,109,69,225,118,183,228,245,81,63,152,51,30,246,118,231,234,220,58,216,139,195,97,206,72,62,101,52,178,236,151,240,154,117,91,95,29,40,211,188,173,45,3,243,63,26,172,127,3,6,155,48,80,202,132,204,187,213,138,103,111,183,166,125,178,44,195,120,61,255,144,103,19,188,67,172,13,202,229,228,86,205,224,105,198,55,26,142,107,136,168,45,111,192,146,79,67,46,25,163,227,149,189,1,36,146,45,171,100,109,242,52,157,190,182,124,44,41,29,206,252,79,38,128,218,127,173,252,86,206,21,226,6,237,157,236,145,126,59,239,66,188,150,207,74,53,235,200,24,198,224,108,214,238,90,218,150,2,74,10,156,113,221,234,93,16,225,31,190,180,67,199,225,227,104,130,215,43,32,215,111,166,93,31,236,111,141,14,250,205,36,188,70,54,136,107,12,88,32,65,228,65,119,174,227,226,172,32,253,29,178,131,84,82,219,67,101,96,156,168,186,99,0,168,134,93,1,16,33,40,254,96,139,90,74,156,118,213,125,198,196,132,131,65,210,150,147,164,243,10,153,215,245,61,199,11,74,93,51,98,132,7,130,191,198,44,14,65,159,101,132,132,50,237,43,9,74,210,218,20,94,36,177,29,249,142,155,226,204,131,220,209,94,153,19,106,244,234,181,108,183,151,75,202,187,249,18,39,252,109,230,191,133,8,65,220,65,83,124,250,235,62,225,50,73,75,181,188,54,200,41,175,253,40,204,80,94,151,52,215,24,123,2,253,240,89,141,78,126,150,167,10,121,97,176,177,231,212,231,102,7,28,245,152,81,142,93,238,30,243,135,6,15,120,146,111,140,174,63,190,55,53,142,36,109,231,81,109,205,166,59,65,38,62,254,126,20,226,5,59,38,147,184,60,47,192,188,12,139,230,115,223,161,202,30,76,175,144,18,245,138,76,101,2,52,253,223,0,175,23,177,5,84,210,155,141,183,116,37,21,121,148,201,92,120,212,81,102,105,144,122,178,228,245,9,247,67,56,190,131,149,95,12,200,25,200,8,216,23,94,159,39,110,146,236,76,50,238,45,52,255,183,193,46,61,25,159,251,147,123,12,7,111,255,159,8,204,142,241,92,222,113,186,221,111,79,239,189,47,142,52,136,168,197,245,165,68,178,18,79,242,198,53,182,197,78,75,153,15,128,144,204,89,191,223,218,97,81,68,181,101,154,39,129,20,93,32,112,157,9,127,200,52,223,132,227,140,59,94,81,126,187,56,99,97,196,50,223,225,160,29,194,214,57,190,56,173,100,147,143,67,241,45,194,101,199,175,152,56,113,67,112,18,29,193,225,112,84,7,41,61,225,142,164,87,207,29,21,3,10,165,120,147,95,180,67,92,170,245,226,206,9,8,93,234,34,204,87,120,163,126,159,72,181,125,224,18,177,48,63,11,51,99,36,184,79,39,206,119,232,27,215,202,150,206,138,208,146,30,143,122,21,100,174,55,15,78,228,252,217,218,231,91,146,56,201,93,81,131,72,210,119,196,129,230,61,76,240,157,65,83,150,19,200,240,183,91,156,43,154,159,61,9,77,150,91,197,20,174,238,50,143,131,175,80,40,21,167,39,64,183,8,107,85,198,197,91,233,210,250,100,179,110,154,171,172,231,83,34,254,186,54,221,10,228,172,239,214,193,254,136,57,125,158,77,161,70,125,83,146,101,105,16,187,179,33,137,143,33,81,215,177,198,176,47,1,102,117,63,127,150,154,212,42,221,188,148,200,110,249,233,103,229,104,187,135,83,108,134,239,118,75,115,65,251,17,93,0,107,108,3,191,147,140,76,243,12,98,221,12,240,67,200,242,106,76,95,47,62,200,194,253,57,18,104,144,83,186,119,63,14,143,5,91,144,90,183,74,33,229,138,204,180,54,157,50,138,133,160,55,212,255,55,140,237,178,48,229,181,200,159,192,5,127,139,90,186,166,239,58,55,174,97,108,31,255,122,252,14,115,77,76,119,192,87,76,74,200,117,207,97,2,1,38,134,97,20,2,77,122,223,227,245,219,181,208,197,144,75,140,149,172,64,235,26,191,173,184,98,185,3,62,68,55,118,223,243,193,34,197,62,152,95,45,45,218,187,250,193,236,3,12,233,89,39,116,189,154,180,155,120,2,41,107,255,165,118,16,11,230,137,26,77,234,50,205,165,50,206,254,122,132,95,247,98,25,8,178,58,10,66,254,136,155,66,209,147,180,10,222,4,55,212,128,190,153,128,138,172,75,181,83,28,85,134,74,89,241,200,62,145,58,88,46,19,2,230,125,224,202,164,236,35,206,231,36,83,231,237,145,212,131,220,96,207,150,197,154,129,74,160,199,125,222,42,17,225,196,124,48,151,22,111,8,154,160,33,250,235,192,228,90,244,135,173,229,134,91,164,47,10,101,209,154,111,53,62,168,87,195,86,233,84,86,214,98,206,31,10,79,65,124,187,213,181,215,126,92,146,180,23,180,139,104,112,115,125,242,100,183,36,207,83,133,92,223,234,4,180,75,231,76,91,5,241,71,137,227,110,130,20,176,251,33,98,26,253,233,110,135,106,22,221,15,4,253,244,239,126,174,111,97,97,40,166,155,4,1,127,29,36,36,49,37,191,45,236,80,125,162,54,251,26,242,148,30,134,51,69,202,201,43,40,153,153,253,208,76,70,74,171,246,170,52,186,87,61,123,34,185,137,31,129,33,88,207,211,8,207,203,29,176,230,103,100,255,50,202,160,55,227,176,161,202,20,201,154,215,94,226,5,188,108,5,242,35,76,1,190,18,45,215,146,112,60,4,254,107,199,20,208,203,190,228,165,79,153,126,119,252,216,157,24,117,232,189,33,52,74,139,84,22,82,50,17,206,167,91,2,42,169,243,128,181,235,132,121,177,54,36,44,246,73,38,46,72,111,68,35,188,51,83,187,216,126,49,133,200,68,44,205,150,17,118,12,83,28,142,206,237,205,174,244,18,54,133,67,39,23,130,70,172,127,22,212,139,108,106,78,193,172,201,197,112,245,195,195,10,166,126,239,188,131,24,164,34,36,39,67,231,160,188,2,227,160,144,25,43,59,30,71,251,50,85,106,53,30,245,19,188,20,188,92,90,149,91,34,45,64,155,217,142,87,136,150,111,231,88,77,156,230,144,164,66,0,130,22,202,204,88,88,174,67,101,27,210,254,139,103,163,133,110,92,168,108,22,29,132,26,53,58,191,154,21,140,171,111,55,150,180,197,162,52,216,92,197,201,201,65,156,248,38,117,49,19,227,124,25,210,243,181,243,3,205,247,107,11,101,197,3,64,190,164,103,131,174,155,181,227,231,90,25,12,147,92,142,43,48,240,69,181,136,209,199,176,162,170,137,51,152,143,138,76,61,154,118,145,0,192,46,11,243,110,16,89,45,23,198,240,123,44,240,102,123,112,6,60,188,74,192,214,38,79,42,130,208,125,222,125,207,50,62,77,149,62,238,130,105,180,76,91,76,189,60,32,60,156,34,34,17,44,139,218,218,32,169,48,105,153,43,131,255,205,152,131,125,35,199,69,23,253,142,198,5,0,61,237,216,149,133,7,59,181,76,255,63,121,1,132,248,252,43,75,94,152,163,36,44,240,13,46,22,230,231,167,24,69,204,219,240,61,237,120,84,54,64,200,124,107,144,5,213,11,163,224,246,185,49,66,91,76,33,81,112,154,118,142,240,132,102,183,118,64,122,45,27,90,165,37,239,97,157,16,160,214,88,139,187,9,223,60,253,214,162,247,28,164,230,147,66,6,4,253,123,91,178,217,84,80,252,106,129,249,30,125,31,103,176,122,189,129,148,53,138,121,93,56,68,208,206,224,115,243,24,106,199,70,0,165,166,181,252,53,15,80,61,27,103,59,216,172,213,232,25,180,140,220,245,120,36,165,214,150,240,176,51,232,223,7,122,149,4,138,103,157,103,51,78,100,159,146,109,251,153,66,131,158,229,3,22,160,250,42,85,153,188,176,196,155,170,254,39,18,45,141,104,238,121,247,85,187,86,115,67,52,145,176,61,188,141,64,18,28,45,203,84,34,215,33,142,130,171,103,59,75,91,140,162,108,62,26,26,227,167,184,86,25,183,15,98,21,2,145,177,167,186,252,48,137,180,62,227,129,99,69,253,147,64,20,119,250,225,234,211,57,238,98,6,100,36,208,85,103,53,173,153,152,204,2,22,223,214,145,204,14,182,112,244,84,153,114,43,185,131,157,42,243,108,39,178,239,202,48,123,115,32,122,161,44,39,132,214,211,30,135,228,49,165,33,183,179,233,75,153,88,91,68,248,40,36,202,61,174,63,217,131,123,28,138,222,58,232,108,205,74,52,55,34,230,97,123,35,9,211,252,80,75,225,49,112,131,19,124,79,18,111,165,116,86,66,175,60,238,250,136,102,24,143,15,191,173,56,236,236,28,114,246,83,19,176,242,208,84,187,86,164,234,120,249,165,48,39,75,94,66,50,61,185,218,122,172,112,154,73,229,227,209,72,104,189,229,126,168,144,82,84,35,152,0,239,154,25,244,141,225,160,196,161,87,79,226,62,103,68,215,63,227,27,181,85,174,223,74,232,33,46,63,12,122,243,255,44,164,231,99,224,234,29,35,231,189,189,126,175,178,142,55,172,6,118,43,152,61,142,129,64,157,208,166,245,211,209,43,59,16,235,108,123,96,235,20,88,64,88,47,149,206,33,0,161,127,155,30,166,136,143,3,142,107,20,102,198,205,172,230,10,33,245,240,229,176,143,203,233,168,217,49,144,54,147,46,62,122,113,65,155,135,109,4,162,156,223,197,97,9,199,7,241,51,144,39,27,45,45,44,118,210,213,155,229,191,204,173,155,178,230,47,75,131,41,153,110,30,243,218,38,111,112,235,41,121,157,227,191,74,75,189,181,40,89,30,46,47,213,206,215,151,243,91,86,145,121,124,213,97,194,182,194,240,202,60,26,38,55,12,219,112,39,18,136,26,91,150,131,31,156,188,93,161,143,188,114,70,179,56,195,188,32,176,23,13,255,95,116,211,106,144,4,90,129,243,183,1,142,249,98,126,188,165,141,250,51,150,5,238,165,208,13,13,45,1,170,77,114,158,29,195,203,56,221,168,158,225,38,232,163,188,144,42,151,104,246,73,230,178,225,232,125,202,109,123,86,136,192,146,94,111,83,204,106,35,252,100,56,198,29,149,29,1,143,224,17,16,98,98,40,129,124,13,225,59,35,20,111,120,63,107,197,104,81,241,84,234,37,179,220,135,95,67,96,172,219,236,26,21,54,13,254,191,127,161,201,37,88,193,55,112,252,142,191,90,145,13,149,203,165,62,217,179,99,42,76,179,139,169,247,113,210,84,124,167,73,153,83,240,183,128,69,217,53,87,138,211,138,23,45,63,99,204,4,174,220,254,194,88,94,121,205,126,158,238,27,242,217,32,174,202,164,9,161,103,182,151,42,146,118,22,207,111,30,177,70,130,85,151,174,197,239,52,5,200,249,228,131,13,50,217,178,139,178,236,80,245,195,122,193,1,67,237,91,165,137,112,65,38,101,29,147,40,141,250,79,188,34,221,149,125,37,220,182,87,164,127,162,36,77,37,16,233,97,133,212,199,143,124,44,80,5,28,134,89,226,56,105,112,107,117,93,195,35,14,162,79,244,123,39,123,5,238,77,229,111,194,225,138,148,210,105,51,86,170,182,118,19,69,172,180,217,222,148,205,145,15,61,92,191,113,88,212,180,200,78,248,55,6,17,241,178,156,42,244,68,42,8,101,253,205,197,220,35,236,26,182,120,3,78,169,95,106,208,212,4,184,2,221,122,143,229,88,156,25,190,230,26,76,54,42,180,177,149,158,30,22,233,145,98,210,30,15,24,225,86,170,175,219,253,185,112,54,178,147,123,137,196,126,48,84,88,35,210,174,175,53,138,241,242,49,88,147,22,115,7,63,253,147,13,10,219,123,51,60,138,170,103,195,206,245,83,222,65,216,15,214,118,124,35,19,91,75,180,86,149,195,196,233,46,91,231,105,38,103,75,205,182,114,139,74,216,223,25,97,216,245,60,157,28,70,220,50,248,95,97,216,50,121,70,188,204,188,37,238,192,212,56,59,91,191,118,23,161,207,31,151,160,222,43,124,223,148,253,110,252,167,89,141,180,84,32,45,229,251,93,111,7,77,212,112,217,163,30,231,94,15,253,252,191,34,236,94,178,133,160,244,38,105,165,23,200,227,238,154,195,30,119,125,44,24,174,59,61,220,129,47,217,187,163,179,255,243,166,204,44,215,99,40,157,67,88,141,246,162,160,76,199,173,159,53,184,64,248,24,103,207,127,136,169,32,220,160,10,33,6,91,3,60,85,167,81,82,91,38,76,41,106,19,254,85,21,215,102,193,238,55,12,62,149,224,194,91,126,182,83,59,192,120,167,59,110,238,181,134,138,89,210,100,131,125,15,205,118,218,29,208,18,111,143,189,45,17,97,47,238,152,108,186,174,45,136,172,115,45,115,85,114,171,73,14,73,12,114,238,132,218,107,124,41,184,20,138,107,239,14,220,245,231,235,20,146,38,108,34,109,210,10,57,135,240,10,28,58,118,80,217,225,206,164,6,164,98,176,36,218,101,116,90,185,217,71,64,42,111,188,213,19,231,127,107,96,173,28,103,242,228,123,200,116,46,42,83,178,204,58,119,41,75,245,191,124,223,51,193,52,249,176,127,187,163,231,169,76,117,83,149,15,190,156,149,133,209,137,26,109,26,10,195,36,233,236,240,108,87,76,48,246,42,93,98,20,127,39,101,5,194,146,69,37,210,155,224,36,138,78,48,206,45,106,241,231,135,194,114,242,222,176,1,250,9,158,188,16,71,31,124,214,174,186,62,3,211,102,86,46,238,20,128,109,149,78,27,56,178,197,222,179,237,223,71,239,38,38,125,83,39,121,3,177,227,198,189,151,174,187,14,106,158,165,14,234,51,153,149,4,183,177,89,180,61,255,144,191,16,92,180,197,4,194,117,212,102,114,21,43,86,53,28,79,96,224,191,88,42,103,176,148,102,2,139,61,214,159,85,236,42,17,165,169,86,45,59,50,82,158,144,87,244,58,22,201,204,236,68,200,246,245,115,32,135,40,107,54,178,56,201,52,10,108,80,241,195,183,147,218,57,27,192,26,203,238,114,238,68,114,110,92,151,16,192,108,61,143,215,91,194,95,226,44,236,26,150,37,87,174,136,77,77,170,98,169,107,24,234,48,200,106,132,156,146,110,85,14,4,113,253,6,167,176,178,199,220,229,198,229,142,117,200,118,166,66,161,239,7,109,10,179,102,172,132,56,171,14,65,237,209,90,23,81,47,76,37,48,117,19,161,232,156,214,170,235,100,74,48,235,21,95,196,221,48,72,247,198,98,146,135,206,227,196,141,254,140,140,105,25,7,168,138,110,130,78,212,78,227,27,223,32,193,58,193,156,90,85,226,131,225,123,101,20,60,103,86,57,69,230,23,105,57,149,79,107,23,169,140,194,185,99,103,16,218,81,50,32,130,104,215,128,86,179,220,18,51,166,186,204,202,60,139,40,65,144,19,164,131,202,44,172,10,158,113,146,191,207,65,9,46,59,69,89,241,60,198,59,164,125,1,188,45,76,80,194,245,31,241,196,165,57,254,231,209,187,173,246,123,141,158,58,233,118,157,169,60,37,186,147,244,221,199,206,176,106,7,211,185,186,12,231,64,93,187,243,122,239,234,208,59,182,149,152,27,209,63,172,165,127,96,225,82,250,181,175,34,254,68,108,106,13,56,139,173,208,186,154,149,214,137,152,193,167,117,93,22,241,34,115,93,130,203,204,178,164,73,113,255,70,86,116,51,118,201,62,185,167,184,228,171,15,116,246,252,102,180,221,83,194,110,96,72,92,95,169,226,111,45,40,209,144,206,254,182,11,193,213,84,185,4,90,162,35,21,17,83,193,59,240,243,90,17,110,82,122,208,206,9,148,10,21,135,109,249,202,230,232,35,15,100,76,142,206,144,3,23,64,225,235,190,224,36,26,188,116,113,122,161,28,175,49,67,236,105,238,33,225,97,120,35,20,88,114,112,161,11,113,169,29,38,224,8,55,109,62,245,40,170,43,102,212,231,199,3,61,195,32,175,217,26,81,115,74,132,75,35,168,118,143,47,181,76,184,245,58,103,60,131,226,170,192,213,47,199,112,207,0,0,62,154,9,242,253,255,27,163,2,137,168,140,33,137,73,180,180,43,186,67,138,55,6,254,239,26,92,17,212,9,250,132,139,230,71,238,173,22,171,65,63,232,168,147,193,83,158,27,247,118,198,218,133,91,131,170,85,194,44,203,76,174,16,50,136,238,126,128,102,250,82,7,130,143,180,252,18,139,42,233,189,247,88,164,211,46,235,164,93,21,25,171,98,39,178,62,148,75,160,229,133,97,65,18,136,243,44,191,196,25,135,6,26,195,183,60,117,37,216,186,93,230,91,23,175,195,87,212,229,197,249,152,239,100,46,196,3,241,183,216,154,23,180,83,230,97,255,17,119,142,108,140,129,135,216,147,44,38,48,240,242,52,105,181,83,130,102,172,109,52,97,110,138,143,149,216,63,13,145,140,81,232,89,1,145,134,36,46,123,223,148,242,152,17,252,235,76,128,21,233,69,175,11,140,14,132,75,65,163,204,126,185,0,69,132,147,55,201,222,233,31,33,151,51,193,123,122,116,8,8,25,0,109,210,175,182,9,144,111,162,175,43,205,135,43,73,87,197,200,91,206,9,212,138,33,62,49,31,8,105,191,59,183,188,244,240,110,6,246,117,171,221,205,22,138,78,174,214,224,3,163,239,50,14,209,73,102,82,169,106,226,152,187,96,20,57,224,76,59,64,219,28,250,107,249,196,59,23,111,100,250,213,145,224,154,106,94,245,205,74,50,190,251,158,103,53,133,228,229,2,202,12,138,18,33,166,7,233,135,227,209,46,213,171,146,218,188,53,113,53,37,251,197,51,254,51,153,7,141,222,250,227,211,75,233,112,233,111,249,116,124,20,52,102,170,203,128,43,19,98,136,41,107,123,216,133,90,46,56,63,184,85,207,96,207,73,239,144,225,211,123,134,186,179,246,6,136,64,210,146,35,218,56,142,78,138,101,104,141,83,240,227,163,253,223,21,51,51,235,53,234,242,174,118,200,246,134,162,61,27,15,46,36,128,4,160,46,182,174,49,108,91,249,71,57,217,114,113,10,128,31,16,119,126,215,42,145,157,220,228,181,116,25,148,81,222,252,47,109,119,247,59,128,255,255,137,240,115,48,170,227,232,183,68,63,26,133,223,14,79,206,10,91,182,33,228,170,215,130,14,24,91,204,219,172,11,66,36,200,139,66,111,80,149,67,115,150,204,248,32,155,67,166,63,7,151,123,92,77,122,229,16,1,95,87,210,102,153,157,107,223,81,228,187,158,54,222,199,80,89,91,40,163,125,139,132,178,244,112,83,30,125,6,216,130,121,185,114,231,239,212,40,228,247,20,9,108,254,159,243,221,26,65,25,172,65,162,4,25,212,113,219,237,47,66,105,234,226,255,73,151,97,151,156,38,1,198,175,65,104,158,3,18,204,44,245,21,55,62,20,240,144,189,143,210,2,152,76,28,47,114,170,0,63,200,78,161,76,189,253,191,190,151,16,62,134,237,206,129,125,148,189,9,97,148,89,240,79,150,42,101,202,30,252,48,159,235,245,183,6,13,39,220,166,157,199,3,83,190,156,239,228,231,92,220,213,239,59,147,172,43,175,212,99,133,75,103,180,233,251,78,225,74,117,9,236,156,39,57,107,15,232,200,53,35,88,232,86,242,22,111,148,91,115,12,255,111,19,233,223,43,248,232,242,236,232,74,219,208,231,192,100,250,83,167,148,66,175,70,117,8,220,104,253,167,212,131,68,215,46,7,30,106,145,147,131,10,13,11,185,113,85,232,232,147,66,192,114,182,235,53,87,217,176,43,205,122,246,228,199,121,35,179,66,138,172,243,154,41,133,160,213,114,177,39,152,106,49,50,134,58,91,100,234,35,203,131,207,188,44,105,84,156,244,120,228,57,96,233,51,125,70,158,123,95,40,10,187,102,230,50,204,15,93,234,142,189,40,105,132,13,28,156,134,31,72,43,173,15,172,249,40,126,157,10,200,52,252,166,208,112,38,16,80,205,216,153,155,56,232,199,16,119,141,219,194,219,118,177,133,168,115,147,114,6,81,182,17,114,79,102,224,18,166,139,136,217,96,40,33,7,55,106,177,53,175,252,57,57,196,49,214,99,66,142,153,16,99,247,185,204,8,196,58,163,48,52,144,221,213,53,186,86,73,181,241,149,46,17,224,176,246,87,215,37,15,97,44,118,137,146,164,137,83,239,186,150,214,23,230,102,2,176,18,231,145,210,92,30,93,202,131,121,255,1,62,49,97,77,27,227,189,239,166,204,201,195,27,249,22,35,172,74,146,33,206,30,107,109,31,127,15,84,209,192,65,248,29,11,166,197,168,236,250,89,195,236,184,212,59,226,213,122,127,187,223,210,144,74,127,43,228,18,189,214,22,147,117,101,72,55,34,18,104,244,205,167,118,74,102,96,24,25,4,23,19,53,195,251,4,226,189,115,127,135,227,221,88,244,32,57,229,236,209,39,160,47,136,136,193,42,89,124,229,138,53,217,156,237,74,45,108,101,216,216,199,37,218,119,100,42,86,123,253,88,190,125,141,224,66,10,203,62,235,169,37,196,215,244,103,15,137,158,176,191,161,169,12,229,60,123,106,152,94,45,84,217,88,150,122,108,57,79,149,249,214,6,91,189,174,154,250,63,228,117,210,125,2,54,90,127,7,242,159,24,205,0,244,62,8,118,26,66,235,196,46,158,69,25,228,134,99,52,161,203,129,21,94,211,95,160,21,32,126,103,191,109,59,124,243,48,252,196,194,60,163,222,183,28,11,17,36,101,238,200,57,137,18,252,108,118,23,98,240,159,118,164,86,103,117,166,72,215,67,227,143,21,128,151,29,77,1,174,28,95,21,245,195,224,97,248,181,171,113,185,202,171,42,68,251,228,161,84,181,209,92,118,165,182,20,246,23,7,52,43,153,143,167,183,170,20,244,43,229,219,193,216,33,155,150,34,4,122,84,210,122,82,32,202,130,17,106,131,19,23,144,35,74,77,95,247,221,155,113,122,56,239,81,115,133,202,148,0,94,41,108,136,198,166,96,82,103,13,70,161,137,156,146,84,241,209,143,1,181,22,137,114,186,228,66,198,225,203,71,238,132,153,102,181,104,33,55,241,32,158,213,92,85,242,220,156,189,85,250,216,20,81,79,11,237,165,152,154,104,221,26,34,103,59,184,241,151,250,73,248,5,154,0,28,44,184,208,182,207,111,34,89,114,41,174,132,149,168,58,119,55,118,24,197,237,149,218,151,247,117,177,185,3,108,143,125,140,132,159,196,136,133,52,25,64,89,93,93,220,251,134,247,9,45,61,68,87,49,0,171,141,197,87,120,235,204,102,59,193,98,107,83,164,21,162,213,244,63,24,136,185,9,51,238,176,135,123,164,235,123,210,63,241,160,247,231,52,205,134,220,68,123,169,235,174,252,183,186,29,67,15,177,60,254,79,253,13,57,81,175,2,27,90,180,253,144,182,109,131,29,26,254,132,145,93,80,208,208,98,243,18,249,211,77,110,131,229,17,227,186,231,110,63,176,80,2,80,119,153,146,8,139,37,109,125,212,107,48,34,107,143,172,228,184,36,166,81,58,205,115,86,131,197,201,91,194,116,25,197,210,175,47,41,230,232,2,88,235,153,224,180,52,74,209,131,141,169,245,70,224,184,35,29,38,136,199,139,162,221,45,76,132,238,209,33,36,184,175,5,200,252,32,247,213,55,247,142,91,127,173,144,8,6,6,177,137,170,224,33,93,98,53,217,43,37,194,94,25,152,113,107,221,188,170,243,116,63,246,32,61,30,157,62,126,201,173,152,201,204,141,187,67,65,175,216,12,132,232,211,104,116,122,237,68,183,64,173,152,123,191,120,149,176,81,115,91,25,76,205,31,198,5,60,138,182,86,246,80,244,173,118,56,32,27,11,248,142,177,136,210,23,234,175,135,124,50,52,190,166,167,224,21,61,83,97,128,143,7,142,201,62,228,43,191,32,111,80,135,135,147,55,153,106,191,215,157,50,63,255,26,56,88,178,9,114,97,203,45,75,252,212,204,242,46,49,237,174,234,35,169,100,218,5,232,93,5,71,192,209,13,174,100,195,115,21,144,156,26,229,28,100,89,126,223,129,47,14,70,45,208,10,104,208,89,160,118,199,109,12,242,190,146,59,19,163,151,141,207,94,189,248,80,49,173,71,79,28,153,4,102,171,126,26,129,119,149,243,190,136,33,118,170,179,183,41,155,24,130,190,68,192,207,94,114,12,209,131,219,184,50,158,126,103,164,214,168,194,101,46,216,10,172,125,141,76,81,248,122,202,109,24,68,234,41,182,27,55,21,57,11,49,93,116,5,231,143,89,129,10,13,206,70,61,249,51,247,88,101,190,62,82,221,146,158,134,128,115,194,8,24,199,124,41,232,138,15,135,198,119,53,156,8,252,102,43,141,122,137,246,251,129,63,87,176,47,234,184,31,18,64,36,20,59,106,197,252,12,136,249,241,145,89,103,100,222,48,144,245,22,11,218,55,35,204,114,217,137,88,81,200,67,163,30,2,127,224,100,17,108,99,165,224,121,41,202,225,141,20,8,52,218,165,242,128,65,134,50,157,166,41,72,98,148,131,146,79,79,66,130,76,14,157,16,214,80,119,240,34,233,33,53,133,63,254,152,60,4,61,74,16,69,117,51,215,65,133,51,0,14,244,16,23,211,122,92,102,206,107,80,217,183,197,101,69,190,243,105,4,135,19,148,73,77,179,112,213,60,184,144,154,164,83,161,149,191,74,15,114,56,171,200,184,238,46,108,107,169,86,125,73,216,131,115,148,114,42,102,4,188,244,182,48,67,147,198,155,231,51,182,67,126,182,91,246,7,111,87,195,8,198,167,178,200,35,44,6,112,4,84,139,211,66,150,47,159,61,97,117,247,167,28,237,232,64,83,75,185,146,70,56,54,38,100,243,225,206,187,134,73,193,141,61,126,40,93,201,213,97,220,157,66,238,166,213,251,129,236,245,124,56,204,188,175,235,213,212,24,146,199,244,169,120,198,209,128,145,172,23,253,104,35,161,96,78,32,147,130,197,174,208,26,116,152,22,165,175,131,115,121,24,93,60,61,109,232,247,201,251,108,189,229,244,187,148,160,57,49,68,156,150,63,206,207,28,4,18,127,147,246,19,178,211,252,138,80,202,13,197,235,67,234,180,11,182,176,29,105,17,237,90,41,146,125,94,204,148,120,8,130,204,138,236,153,69,132,52,50,236,23,96,151,186,47,176,70,233,221,253,230,36,173,108,65,56,0,42,179,136,53,46,112,85,16,147,17,199,61,203,75,52,116,82,145,53,223,219,23,214,194,197,225,64,248,202,181,76,160,165,42,11,160,224,248,49,211,153,140,7,126,171,204,123,116,105,212,189,8,18,109,23,190,23,26,89,107,151,35,27,84,108,42,172,72,201,176,171,239,59,181,245,6,36,9,193,250,140,53,134,176,121,166,236,190,199,47,13,162,220,58,152,55,194,146,168,148,198,109,77,140,244,190,119,167,155,75,155,236,128,58,130,154,58,134,82,194,151,83,84,45,209,60,41,98,232,101,157,189,97,116,253,202,150,207,122,10,146,45,115,210,9,160,10,130,178,209,15,37,27,199,99,214,87,174,144,22,76,114,152,182,178,4,155,50,45,219,80,20,94,57,119,120,227,219,43,111,3,92,89,35,159,69,50,252,53,18,41,120,101,152,87,149,238,202,115,112,122,18,135,35,167,178,45,227,240,233,84,223,185,95,69,232,164,128,52,168,140,228,55,56,129,184,126,143,196,216,193,169,87,147,177,37,92,166,203,58,45,21,68,171,58,55,129,147,223,15,155,132,237,220,159,251,200,214,191,223,8,179,1,188,240,147,129,202,211,120,53,82,91,248,201,59,84,46,102,190,154,32,38,203,60,145,196,22,137,164,12,131,180,20,121,249,180,210,90,189,207,107,113,20,75,51,52,149,205,197,120,173,32,166,127,72,80,209,57,107,104,178,212,249,189,155,182,13,103,68,96,130,219,117,205,95,188,9,121,209,74,19,123,193,105,40,20,65,31,126,120,6,236,146,73,179,179,119,33,162,103,233,189,238,42,195,176,185,34,144,42,109,240,173,234,61,14,121,210,6,132,55,129,240,43,218,107,138,140,65,207,150,32,115,253,31,48,104,39,84,220,16,45,237,65,24,87,7,234,174,70,77,191,109,163,218,220,209,130,113,199,128,155,163,120,64,159,25,41,161,121,74,244,118,79,107,139,174,98,139,191,224,98,227,96,223,30,22,145,77,204,152,169,20,32,187,0,119,106,208,136,84,96,88,244,181,220,120,74,99,197,8,29,248,66,49,137,13,133,41,204,145,47,26,172,228,64,139,190,221,88,238,46,155,181,169,59,140,52,202,0,237,187,104,200,230,116,143,62,65,205,196,24,76,39,22,47,197,50,55,72,32,1,121,121,65,32,104,124,158,223,48,81,154,237,52,73,164,174,215,92,199,114,77,117,25,119,204,178,13,144,78,85,252,94,74,132,211,233,196,239,233,67,185,74,199,193,225,191,179,186,120,127,147,245,8,3,241,59,69,109,77,100,76,103,107,68,89,175,64,181,188,33,206,147,173,118,146,223,195,177,188,228,221,237,133,86,203,152,133,57,163,42,25,34,190,202,210,109,59,34,164,177,205,175,237,193,109,155,175,158,44,4,87,138,11,122,10,94,178,201,116,12,14,104,202,50,167,128,52,159,77,123,171,203,77,98,169,112,206,40,73,32,157,95,9,112,118,190,96,28,120,131,77,218,63,44,42,106,232,60,113,1,97,94,187,9,2,28,221,185,242,98,34,131,167,227,108,8,66,29,176,98,251,160,1,27,134,6,50,226,81,31,42,208,237,233,232,243,242,174,178,187,114,44,251,253,166,198,9,72,162,28,39,39,240,183,217,92,84,127,79,210,250,243,168,104,223,166,2,14,106,77,55,229,67,237,101,192,77,102,136,160,253,140,126,191,248,157,158,48,170,85,12,7,23,60,26,73,41,4,193,30,156,77,109,135,29,164,109,8,213,200,244,84,100,169,142,213,225,30,155,204,93,120,126,161,12,129,38,16,63,155,225,121,251,95,33,69,210,243,194,231,91,245,148,99,63,53,35,77,162,113,88,29,255,61,186,157,8,40,165,100,195,124,56,224,223,111,177,253,168,252,186,80,39,237,133,197,234,14,192,173,148,150,50,121,24,119,186,13,205,115,77,127,178,98,49,89,129,43,237,229,36,49,153,191,38,6,109,134,238,138,24,255,173,240,213,159,84,228,81,134,64,97,70,199,235,37,37,121,139,50,127,123,221,89,150,49,50,64,199,188,71,102,213,75,89,7,84,16,55,69,13,209,10,34,231,177,33,51,245,13,19,111,66,204,158,107,85,179,66,229,118,243,37,233,34,167,215,54,253,10,96,203,213,164,101,16,48,2,148,72,69,234,136,195,127,32,81,239,129,67,27,73,38,139,195,144,249,126,111,128,241,14,204,238,95,33,50,1,189,238,231,77,11,63,119,9,244,237,21,113,229,96,227,50,61,16,34,44,217,163,137,165,142,41,7,205,198,67,232,93,215,231,189,10,142,15,193,23,28,161,71,42,24,21,47,148,101,109,209,249,42,116,147,254,214,31,247,159,252,156,202,240,85,167,204,105,182,97,194,11,85,74,219,80,252,219,248,33,137,210,127,96,37,12,239,111,157,93,66,234,16,116,220,95,87,153,240,29,229,161,103,242,247,220,58,204,28,176,130,1,128,206,8,54,17,78,57,237,85,212,143,151,144,152,83,94,10,184,217,98,0,175,5,235,14,199,102,148,52,79,95,92,47,60,194,220,95,176,104,34,91,249,110,88,99,247,91,208,186,206,172,0,171,45,232,111,33,82,253,224,104,75,100,181,139,47,223,102,202,186,144,140,90,128,40,133,74,199,194,219,126,14,72,105,123,112,149,32,6,222,2,98,255,108,192,192,237,249,105,157,109,184,26,167,169,227,222,203,102,81,138,129,199,63,120,36,202,29,2,0,179,111,64,235,174,149,23,147,21,59,62,76,220,86,181,204,166,196,217,20,130,63,206,13,52,140,211,238,184,46,136,1,190,141,78,93,237,135,58,132,150,220,42,69,156,214,184,112,91,71,72,152,182,100,238,15,233,152,113,222,56,195,199,62,159,0,101,200,172,32,101,176,181,157,216,99,185,161,95,106,220,201,8,31,195,7,230,28,250,122,40,243,137,74,158,96,99,12,11,151,252,181,234,48,96,193,127,86,184,77,89,24,43,182,201,128,41,243,49,234,202,184,101,160,190,150,254,132,255,101,244,230,67,252,103,14,189,34,235,124,49,16,147,132,223,203,162,205,132,73,88,252,94,217,212,186,79,116,96,108,86,35,225,233,216,111,181,125,48,10,43,82,144,97,222,22,176,186,136,3,0,33,233,199,86,104,80,214,65,140,167,55,236,130,253,101,81,223,31,243,78,168,166,133,203,180,42,171,194,145,208,67,52,221,234,138,248,85,243,199,14,239,14,136,29,38,134,244,231,52,206,121,183,254,205,3,43,89,98,80,10,189,143,120,136,152,197,207,26,252,76,39,72,123,206,197,87,124,48,207,24,125,109,252,40,186,87,96,159,38,57,38,98,136,23,69,92,96,63,90,24,245,142,220,88,82,201,85,64,178,112,237,34,56,236,231,119,201,107,151,149,149,209,137,245,246,151,241,203,242,82,20,139,168,241,55,9,140,4,101,105,49,131,41,245,19,49,133,48,78,29,36,28,49,240,237,189,139,236,225,165,72,163,165,151,159,94,42,178,10,197,42,240,75,154,112,203,10,122,47,51,47,252,12,252,40,80,205,13,86,21,133,235,120,178,102,178,128,254,64,212,123,200,244,228,167,75,65,15,53,237,234,17,207,93,95,135,242,165,38,252,167,193,175,46,77,176,229,105,130,70,248,26,197,192,233,41,184,27,62,21,130,95,47,155,230,153,75,85,255,215,12,63,158,177,183,215,16,173,220,179,194,121,171,130,59,50,44,127,253,192,127,198,193,194,10,102,169,98,80,93,27,59,208,202,170,218,10,197,206,113,75,157,194,206,153,119,49,219,93,80,116,213,83,200,37,159,203,229,80,97,170,8,209,149,81,201,92,243,221,244,156,132,78,253,173,7,96,244,78,236,123,110,204,57,48,126,55,190,135,61,157,156,34,155,13,85,247,86,31,203,69,2,68,211,27,223,46,166,100,57,25,129,172,75,221,221,216,208,129,2,188,254,118,117,21,42,46,147,203,206,251,209,219,33,67,227,155,97,168,181,246,172,225,143,190,40,25,44,210,24,98,239,226,10,16,160,178,194,2,127,49,101,131,192,216,124,198,121,75,165,168,7,23,161,98,101,196,10,28,151,191,35,143,146,150,183,182,166,45,88,90,63,235,49,131,88,209,27,62,189,4,9,214,208,30,38,100,230,239,221,163,118,52,100,138,66,28,123,190,176,35,150,93,247,231,53,205,0,73,212,100,115,18,157,158,216,90,100,103,45,110,144,186,102,108,232,14,11,36,55,79,140,132,239,44,91,112,48,77,192,68,245,213,39,181,124,52,111,16,204,59,252,23,55,146,104,202,57,100,221,234,107,197,57,189,146,32,180,41,151,98,73,14,38,133,50,175,247,199,95,117,160,245,124,90,24,235,244,0,175,200,225,99,221,153,109,149,160,194,208,3,119,78,163,54,249,245,89,239,90,233,225,100,144,136,35,17,67,189,24,142,211,97,45,103,214,239,121,167,32,234,41,35,216,232,56,115,92,173,0,11,124,53,119,137,60,246,75,122,40,193,198,16,109,230,240,248,121,94,206,65,166,212,171,216,136,147,141,94,18,32,154,2,151,238,228,106,88,25,68,88,70,239,121,62,212,15,190,202,31,18,102,147,190,167,55,152,169,123,54,161,6,11,118,3,218,209,135,10,153,88,86,51,229,140,49,75,83,166,174,94,9,48,80,155,196,159,143,124,214,120,145,20,168,194,108,2,15,225,230,39,111,223,152,41,161,191,95,166,87,14,8,28,100,138,171,218,170,132,52,154,121,125,1,236,18,242,97,51,34,16,235,54,233,136,129,181,43,96,222,91,73,183,205,192,95,174,92,24,122,233,101,63,224,91,14,94,62,133,2,216,128,16,68,131,210,226,136,169,19,39,183,139,181,253,125,73,248,44,53,234,148,30,4,116,58,91,124,144,213,200,108,189,189,75,137,135,19,167,169,190,96,46,166,182,132,108,11,76,245,179,227,165,195,25,37,24,224,244,145,109,125,91,71,85,116,163,48,149,128,5,149,84,158,64,83,152,39,158,192,107,232,229,39,235,97,99,153,93,55,156,148,36,127,35,109,61,253,145,30,31,74,78,47,81,122,222,177,157,56,248,112,249,25,240,244,111,195,166,152,21,92,170,160,54,106,166,208,75,31,120,223,43,254,241,151,45,125,225,66,166,249,222,13,205,204,225,168,157,217,169,146,96,2,189,137,112,130,104,43,146,79,155,72,216,157,17,74,33,57,222,154,175,102,19,199,102,148,14,233,242,218,241,70,245,18,161,129,71,6,14,109,112,114,196,136,3,40,175,120,159,55,38,126,175,23,135,145,193,225,145,29,141,10,167,44,21,80,152,200,215,126,42,15,197,2,9,130,131,210,69,198,76,22,119,174,24,80,160,88,149,213,232,205,75,109,202,219,56,105,54,198,251,34,168,255,73,207,202,32,195,223,227,65,112,56,43,170,170,9,254,133,22,112,218,218,244,116,145,10,26,254,220,83,146,131,184,140,168,95,127,116,51,76,242,120,251,172,32,56,144,17,195,145,40,7,96,196,163,71,184,226,183,52,21,246,191,241,116,129,54,160,167,176,238,215,53,240,198,216,223,154,50,25,255,117,55,62,27,246,157,58,154,84,93,188,203,252,196,36,117,65,36,231,128,222,121,0,63,150,193,10,33,46,36,28,125,243,66,197,87,96,53,249,125,179,163,49,236,246,19,174,66,84,185,161,40,201,253,105,198,67,88,252,203,100,130,178,186,112,182,48,0,243,26,45,212,198,239,197,120,117,246,253,61,83,164,100,188,230,5,88,148,217,105,177,23,221,71,174,83,236,67,196,216,231,90,86,170,17,242,165,228,84,195,120,213,169,34,170,14,187,45,50,156,140,113,58,49,219,38,89,119,63,159,221,212,38,14,241,172,152,121,167,100,84,31,76,128,134,224,179,232,104,238,177,251,2,109,14,175,228,188,20,170,229,141,170,89,148,86,141,111,71,105,205,37,187,129,81,65,193,141,17,98,205,193,66,110,219,185,17,56,42,133,27,70,70,106,250,206,147,212,3,165,121,162,193,114,144,55,12,53,35,182,101,161,139,97,141,74,2,139,206,8,178,174,165,224,165,23,13,193,118,124,168,175,254,24,81,176,158,74,71,250,25,32,148,111,114,18,175,12,11,70,24,18,176,87,47,26,206,49,97,43,9,244,64,73,65,123,16,92,32,7,14,41,100,212,170,18,109,5,145,118,45,205,25,80,163,198,64,103,109,54,250,180,38,43,76,95,219,225,217,107,130,81,157,57,190,232,92,92,205,153,252,80,9,104,67,79,70,35,141,175,239,50,51,164,47,205,225,23,152,121,94,98,224,207,176,144,192,185,220,208,164,225,26,45,128,47,207,78,230,252,246,254,30,222,251,4,101,81,182,182,223,179,99,134,15,155,101,239,99,141,35,179,241,225,225,35,63,169,121,3,84,250,14,128,18,142,189,137,45,169,230,153,202,240,115,88,159,26,107,160,59,116,47,22,43,156,0,79,196,242,167,222,134,115,94,41,209,97,118,45,28,159,183,247,102,147,69,14,234,235,237,24,30,204,80,251,141,212,165,134,128,86,13,94,3,157,94,222,180,242,181,173,24,108,109,195,243,222,130,32,114,153,12,8,94,42,53,3,144,83,227,48,110,203,66,175,3,251,235,117,158,51,20,17,87,154,63,177,233,166,121,62,129,215,59,79,174,86,121,1,216,70,127,22,125,233,161,77,98,74,129,57,157,40,146,10,76,144,163,118,190,88,156,197,156,38,174,248,204,194,172,191,230,244,48,230,143,63,94,108,114,19,148,232,31,215,73,154,97,253,139,146,106,37,45,118,254,157,150,22,7,253,243,111,133,172,127,90,134,53,105,61,152,232,220,222,135,138,47,65,45,249,106,127,250,196,79,238,60,105,113,72,136,77,113,175,78,125,223,24,58,202,123,22,40,38,35,40,219,46,191,213,209,234,248,206,49,248,61,182,203,218,135,27,146,142,12,104,179,229,126,44,140,124,249,171,7,131,57,192,37,240,37,198,79,104,50,8,122,122,34,23,176,25,153,170,217,174,184,11,66,187,218,215,168,19,166,217,83,115,179,126,233,24,116,112,124,207,253,100,53,231,42,251,43,213,116,223,92,0,47,48,102,103,28,5,8,153,79,81,190,42,242,7,97,136,144,199,149,216,52,186,89,78,81,254,240,63,75,11,242,82,38,150,19,209,107,64,86,156,196,12,23,87,233,50,240,249,157,202,188,28,184,117,183,51,19,107,218,80,24,236,218,197,191,23,183,247,84,67,165,116,54,5,61,196,194,28,81,149,168,130,118,161,11,203,173,32,17,150,173,247,214,232,120,178,18,83,137,34,57,14,32,207,78,179,109,176,83,195,31,116,42,47,57,234,159,0,206,21,224,90,207,133,135,239,178,98,158,170,55,126,29,125,7,164,204,205,253,208,15,20,162,224,68,180,124,234,167,76,27,46,72,81,4,172,1,90,175,91,232,240,47,10,92,160,110,67,4,115,168,36,197,68,10,221,204,188,0,130,121,46,14,176,190,67,202,227,9,193,199,165,89,16,210,200,104,232,13,240,167,103,47,105,110,200,77,213,49,225,126,191,254,70,61,64,221,146,147,127,73,116,138,183,104,107,219,183,56,14,50,58,97,105,67,118,5,11,224,65,226,81,228,69,249,53,167,222,98,236,172,153,116,70,73,177,230,116,150,41,123,125,63,81,118,37,63,203,165,183,170,118,73,19,178,2,231,214,83,247,210,234,158,165,91,111,34,104,157,55,196,120,113,52,18,118,42,64,46,36,203,68,248,42,136,145,105,221,114,28,126,243,194,109,125,107,119,64,112,173,169,228,47,16,153,117,93,214,97,50,211,226,71,48,123,227,169,81,134,182,161,14,198,169,224,235,122,15,178,225,209,188,150,45,67,18,106,91,171,38,180,194,0,121,188,191,16,45,19,149,66,19,60,154,234,105,186,172,168,254,208,149,183,234,214,223,32,190,33,47,31,140,130,221,178,115,100,116,115,207,76,46,64,64,63,76,250,143,113,13,177,162,111,143,90,74,115,78,211,161,19,18,170,196,61,73,112,165,235,72,47,18,23,57,96,96,25,110,138,10,119,3,88,10,81,165,46,158,3,106,210,132,96,151,212,63,114,153,187,192,194,196,51,219,148,216,201,246,127,32,245,160,78,185,61,73,63,96,29,23,211,132,0,196,247,235,109,181,251,150,161,159,110,53,142,71,43,231,251,103,57,233,249,61,0,233,192,221,52,185,53,250,66,134,134,157,235,19,118,223,136,23,175,99,17,110,152,156,95,138,227,51,169,243,211,96,13,205,106,103,125,244,98,59,86,176,47,189,138,193,87,98,231,12,2,179,1,219,61,75,125,50,141,180,217,133,174,36,204,34,228,26,52,24,225,204,77,6,36,214,43,122,141,176,245,115,152,143,146,120,33,224,31,215,155,211,121,194,66,186,107,109,138,63,210,12,206,166,147,228,55,165,249,1,87,245,54,159,209,120,243,115,187,79,80,91,40,133,51,251,250,190,117,20,179,76,106,52,71,35,97,14,84,103,24,249,100,88,199,130,48,130,65,199,73,33,3,245,174,175,244,114,96,28,220,189,139,156,40,45,195,238,151,166,110,20,92,81,166,42,169,53,254,165,31,121,48,235,15,127,24,39,30,144,76,46,6,237,123,162,169,97,48,248,81,73,113,2,10,208,81,126,230,95,179,173,5,228,155,145,200,179,23,244,144,42,112,113,108,114,112,203,220,196,112,148,132,58,161,81,240,47,177,25,233,91,31,55,126,230,87,214,25,242,106,187,122,76,36,190,141,160,29,84,170,216,111,255,23,223,251,40,117,158,92,159,32,240,83,98,183,44,160,207,51,140,205,230,30,161,128,14,189,231,55,56,239,140,223,16,222,224,191,216,128,207,38,79,244,135,44,18,6,162,58,97,99,207,29,110,64,119,87,125,41,141,207,19,150,188,114,242,36,64,233,89,184,244,21,52,48,178,218,210,223,88,197,14,239,103,202,182,16,1,59,24,25,21,139,207,237,141,11,236,212,18,217,221,171,183,118,20,232,72,136,199,5,52,122,183,188,9,25,15,32,83,74,231,27,45,220,113,137,190,18,100,38,199,8,42,184,221,11,99,151,169,186,182,151,112,63,188,19,23,193,22,57,187,208,4,19,52,82,42,231,40,171,94,55,81,127,32,166,102,124,36,52,222,107,140,178,208,254,212,166,31,205,53,197,21,173,16,103,129,187,77,176,144,253,31,206,200,165,32,208,114,102,72,67,128,53,151,186,170,29,58,117,106,61,123,125,89,179,19,29,188,175,193,102,220,225,64,157,201,198,13,227,175,94,195,207,36,33,247,36,149,18,239,180,209,233,137,16,106,126,71,163,164,18,236,170,47,84,91,3,20,7,173,78,225,34,138,218,121,145,5,26,67,221,201,77,181,34,69,233,82,51,13,215,134,160,86,7,170,96,198,129,220,45,98,58,86,146,157,102,8,154,184,149,15,179,100,204,160,167,118,146,61,35,214,83,222,82,27,203,152,190,182,249,141,197,172,139,108,239,72,45,45,234,176,90,162,2,161,74,88,231,206,183,36,181,67,126,167,210,0,12,31,216,65,148,97,198,115,229,215,154,178,133,109,76,161,172,4,118,134,74,251,121,156,12,188,109,82,88,140,209,224,42,122,239,118,200,99,67,64,190,216,76,147,108,217,108,28,53,178,64,64,41,62,23,47,174,169,39,60,226,27,50,110,59,15,59,180,220,23,223,85,235,84,210,219,85,151,176,170,245,2,64,150,15,95,32,217,171,187,35,151,244,108,103,44,178,30,115,193,0,9,181,20,95,212,144,82,255,154,217,105,223,181,231,48,181,226,80,170,55,80,97,99,116,196,218,240,90,180,13,11,41,34,107,51,105,113,78,33,201,163,97,130,109,76,221,217,169,170,224,162,236,85,2,154,111,9,233,174,72,245,103,140,189,23,23,105,198,106,226,40,202,69,85,17,219,49,135,182,103,218,10,125,167,204,222,61,146,161,182,53,26,114,196,19,51,108,234,107,219,190,42,179,155,224,91,207,159,12,143,96,118,162,219,137,170,239,214,104,130,78,68,42,37,138,24,178,9,74,183,94,251,241,39,196,140,133,200,17,218,7,11,68,240,43,181,74,229,222,99,196,36,116,97,220,198,171,231,24,139,168,66,167,252,203,171,77,103,141,180,221,117,221,90,193,206,250,47,198,153,130,101,59,164,77,150,202,64,216,251,185,124,249,192,170,140,7,201,220,152,42,136,80,215,39,229,33,204,251,3,139,75,240,249,17,11,197,231,117,130,77,179,171,189,28,118,45,12,169,202,109,137,18,145,67,212,4,112,135,89,147,33,13,238,195,89,220,201,15,37,106,234,43,110,211,82,88,65,227,131,139,26,245,43,96,148,35,177,228,122,184,229,172,233,200,252,60,126,24,90,246,161,156,35,217,131,220,12,84,229,111,151,135,235,135,22,66,28,33,44,206,127,118,188,174,95,26,91,91,96,181,7,33,252,90,15,56,28,212,231,63,59,92,133,224,109,36,44,74,3,144,186,32,38,44,90,13,203,190,196,91,215,232,63,115,21,199,47,154,184,230,112,14,83,27,213,33,144,119,78,205,51,98,84,161,16,69,167,80,43,57,165,247,144,85,49,165,228,119,28,44,188,197,115,232,212,226,144,76,30,144,23,221,17,186,19,153,175,121,76,174,252,100,1,38,147,254,233,179,135,36,89,218,194,56,157,43,231,40,36,177,195,57,24,121,67,103,115,83,80,111,188,164,68,40,160,136,43,8,230,153,169,83,39,171,21,138,61,197,197,59,237,77,117,113,127,42,38,243,80,22,63,243,76,113,11,103,194,215,12,153,114,230,21,204,6,48,90,249,220,6,77,124,104,232,38,140,176,231,91,173,99,230,184,12,5,79,86,72,62,144,50,127,60,191,203,246,61,180,50,81,88,33,231,238,104,68,169,4,176,117,45,156,64,159,185,245,141,212,228,216,94,114,202,83,212,200,50,191,46,219,154,17,177,117,150,232,154,61,41,93,15,47,255,255,58,237,169,62,66,247,211,37,54,36,69,157,200,59,84,60,28,140,40,235,213,232,171,202,28,193,222,53,143,40,37,29,194,10,53,49,8,61,134,43,23,213,6,115,140,102,171,185,178,202,198,136,159,57,12,35,186,175,117,187,242,109,49,231,10,229,4,163,91,130,99,34,28,65,23,18,74,126,121,206,13,16,3,229,126,31,136,6,118,204,191,202,170,31,226,111,217,168,22,58,126,136,171,86,67,83,184,173,71,38,30,130,239,112,124,193,29,118,59,12,231,79,232,232,145,62,147,65,57,92,59,179,119,75,187,164,182,159,40,206,133,252,187,173,45,188,244,150,68,124,70,83,192,30,182,0,85,102,12,191,232,1,115,116,61,114,85,110,252,163,95,98,96,24,162,120,67,95,185,39,74,69,253,95,107,243,36,91,128,61,222,89,143,135,11,175,29,253,81,23,7,7,107,221,26,70,43,245,63,205,84,163,88,182,157,146,110,150,1,98,156,11,13,60,54,106,3,209,128,228,22,211,3,169,144,5,238,53,251,177,243,122,221,116,87,139,190,43,180,149,96,241,227,153,83,215,163,88,18,53,38,254,25,219,62,92,185,117,130,85,161,21,125,175,50,191,168,197,165,216,120,112,94,155,47,112,42,72,7,32,63,30,151,181,106,203,67,133,27,92,225,205,84,9,224,236,181,154,234,172,215,135,94,62,56,243,76,241,238,179,53,197,199,148,152,192,54,53,143,69,148,166,18,55,199,241,163,62,142,208,11,249,143,70,229,202,31,145,57,102,167,16,241,120,38,156,3,109,30,72,1,159,204,196,174,160,92,0,169,95,252,126,25,237,183,133,46,146,33,133,201,152,248,104,163,134,210,247,47,78,46,88,22,101,33,156,137,31,131,162,19,129,15,78,251,33,83,12,87,103,101,11,96,105,99,230,143,52,4,202,1,12,142,129,242,206,93,219,152,65,162,44,75,129,5,170,84,88,90,109,10,10,184,45,98,225,52,213,117,249,79,202,149,141,91,131,53,121,13,253,169,185,130,214,222,66,198,227,216,148,43,191,204,43,179,43,54,217,180,48,119,22,17,11,75,183,76,137,85,147,102,157,20,63,41,15,33,57,127,90,180,23,233,206,118,136,121,193,243,75,139,74,196,149,223,4,92,123,95,234,64,49,154,212,204,205,209,3,60,185,241,238,37,59,121,252,97,23,86,36,16,237,116,121,111,107,5,235,122,55,231,222,49,15,171,214,239,8,27,33,81,15,46,220,34,127,198,217,107,200,115,164,66,63,129,82,50,125,119,75,221,151,184,158,97,179,230,142,170,109,223,226,34,29,138,40,61,52,252,0,105,180,107,145,246,44,71,161,87,207,205,64,116,68,3,121,114,45,148,188,198,131,245,102,218,225,145,49,83,236,109,10,250,177,56,239,101,167,17,253,255,57,69,150,35,35,8,11,38,89,245,176,239,137,120,161,4,59,156,42,90,55,87,222,232,126,164,212,49,18,35,11,105,80,155,255,95,231,112,228,69,37,122,99,25,189,254,142,197,172,30,166,29,141,216,208,146,83,111,96,118,66,154,177,85,161,234,141,254,100,26,126,82,192,151,164,48,187,110,172,48,131,228,142,180,64,245,131,135,77,64,120,194,25,178,216,119,222,54,59,227,138,198,186,53,39,187,241,134,141,116,55,69,19,207,230,193,155,34,129,139,213,53,202,114,62,74,114,117,146,94,235,153,111,168,72,164,41,211,246,107,201,5,235,181,101,152,115,63,215,169,248,28,197,241,224,186,44,112,5,165,67,88,186,117,3,142,64,108,33,175,162,32,225,255,127,163,27,254,166,128,58,177,8,31,98,62,192,217,96,126,194,126,88,108,180,0,5,157,180,57,37,46,38,99,75,138,18,65,211,110,82,73,244,132,135,224,21,207,4,46,129,191,195,179,166,204,143,222,22,170,177,115,110,163,99,138,203,192,13,186,130,170,5,194,126,203,205,58,227,52,253,13,64,121,104,155,51,188,123,34,200,79,19,64,69,130,189,152,120,57,166,58,110,42,140,99,61,252,149,132,156,76,13,33,92,169,142,9,22,251,154,187,21,132,85,122,16,66,210,210,78,234,189,92,157,124,233,114,17,14,141,225,128,220,15,155,124,220,98,177,172,165,32,193,24,167,13,244,71,25,204,160,219,220,238,160,17,82,23,243,37,78,151,203,146,194,166,174,151,64,192,247,182,1,243,215,250,138,215,37,110,98,57,146,53,4,157,235,21,131,202,14,8,119,129,187,74,10,1,40,201,97,76,151,147,4,77,134,70,81,13,178,235,159,42,104,0,43,210,175,45,13,211,90,125,191,144,126,161,125,120,79,208,22,225,217,247,191,178,147,246,246,207,112,9,192,68,205,65,102,107,5,27,79,237,178,147,152,47,199,100,143,126,227,38,131,61,247,227,173,234,197,196,206,27,79,49,126,40,9,176,185,195,200,248,110,87,180,227,76,5,215,48,32,233,209,228,204,230,252,93,48,60,74,221,149,153,84,160,116,1,2,203,97,239,112,8,73,66,249,251,36,71,176,58,29,24,53,84,29,79,12,106,122,110,54,120,144,10,133,139,138,131,230,180,75,204,116,125,140,77,128,176,225,246,167,216,195,71,196,244,96,168,155,224,42,149,122,85,237,28,146,107,216,104,162,8,208,219,225,101,36,32,47,32,23,24,40,160,136,27,165,241,248,121,43,33,30,101,33,10,69,187,151,86,81,66,15,234,111,199,251,56,36,45,88,40,145,237,177,67,121,22,36,10,160,23,93,222,47,245,42,109,91,69,59,19,137,140,3,193,219,116,138,18,41,115,216,110,160,173,159,9,228,156,185,117,79,8,34,61,36,150,112,178,157,66,20,240,22,188,47,57,220,145,101,144,162,73,147,192,42,228,63,23,134,104,34,31,87,84,87,210,37,160,255,234,0,18,123,68,94,211,176,248,141,96,136,13,113,164,8,223,106,230,151,255,17,176,158,34,158,12,16,149,149,70,60,178,180,22,71,222,2,207,223,202,250,240,32,39,27,201,71,148,10,149,193,216,169,253,249,211,170,108,191,17,196,89,150,62,38,201,35,69,184,10,205,70,12,246,128,177,92,115,232,50,103,55,53,235,188,17,68,91,156,66,75,165,124,211,96,28,193,2,45,195,212,225,222,195,61,149,88,117,135,61,185,126,211,196,171,229,153,43,196,178,36,195,112,40,110,135,189,250,222,186,38,206,202,40,22,234,250,216,68,138,128,194,62,174,6,14,246,36,58,94,241,37,67,48,11,94,34,12,215,145,230,117,173,250,146,133,57,209,208,248,173,39,96,64,170,81,157,53,241,231,80,1,219,158,173,228,12,235,1,175,236,230,15,248,209,255,159,123,149,135,218,184,122,194,2,67,114,76,72,235,231,73,39,53,16,170,30,178,187,104,236,190,127,94,43,85,119,82,96,208,120,154,67,33,238,217,10,177,66,27,40,170,245,9,195,207,254,252,5,61,69,228,187,239,181,124,65,24,60,52,127,18,90,73,111,157,75,203,214,134,44,197,99,174,20,169,88,121,146,122,9,19,116,70,218,190,209,216,177,193,120,253,58,171,101,126,181,215,176,212,237,219,205,36,129,215,192,20,50,148,85,237,235,52,33,206,23,90,191,3,252,181,183,22,103,132,33,139,133,193,105,115,248,204,178,78,194,236,114,248,195,244,209,230,174,60,193,7,186,215,44,219,226,210,178,4,17,234,248,112,87,251,43,106,97,234,83,134,60,129,110,120,231,147,5,198,233,53,56,42,62,191,247,221,212,226,245,214,150,120,155,240,163,23,139,229,69,227,197,145,94,113,40,176,36,180,101,116,202,25,74,80,209,80,141,3,171,139,217,21,201,246,223,46,74,235,7,252,214,121,107,168,33,172,186,185,193,69,191,197,142,220,239,141,88,181,15,143,10,127,93,158,237,193,102,214,102,209,43,226,213,51,130,75,95,38,146,32,124,31,193,146,17,141,34,228,141,10,105,135,183,46,227,98,162,133,224,15,37,133,252,190,255,148,122,119,158,43,56,145,35,96,149,79,57,169,35,15,23,174,224,48,29,183,131,121,132,82,226,9,214,228,37,140,31,199,75,101,152,131,66,132,168,151,220,173,213,165,134,208,0,102,114,247,194,245,51,95,141,69,221,23,186,251,107,11,155,149,118,52,152,13,210,122,64,78,124,174,47,104,224,183,228,194,211,19,24,167,242,64,147,153,181,205,52,239,61,91,159,30,252,51,124,161,99,244,210,107,95,22,128,0,33,141,29,137,139,156,212,49,119,50,117,240,51,237,13,98,232,240,164,125,159,46,182,108,79,27,23,247,250,65,72,209,112,74,185,197,45,50,74,161,145,203,196,151,19,101,50,65,32,159,239,12,22,189,31,42,198,115,204,194,22,18,127,192,252,100,83,57,102,121,248,16,121,229,26,253,202,150,244,218,16,217,43,83,146,85,187,22,68,164,115,195,43,208,76,14,152,90,55,43,11,121,58,127,37,205,11,35,245,157,113,84,68,181,239,214,76,145,245,56,61,218,88,84,90,183,61,250,230,19,105,140,29,232,15,61,229,81,202,2,135,51,117,236,41,254,111,226,235,161,71,8,110,196,95,160,29,84,18,169,139,85,240,67,155,159,182,215,75,160,87,195,234,175,11,88,106,212,96,37,57,196,85,10,144,48,201,57,174,35,48,229,205,208,228,159,38,226,0,230,172,4,245,162,115,0,71,253,105,129,86,0,29,59,35,201,139,244,90,26,212,240,1,9,70,5,19,108,17,39,170,220,53,229,37,98,194,185,47,175,243,221,68,215,111,128,191,52,238,239,233,34,118,168,144,127,92,141,71,47,222,96,240,41,32,131,61,64,104,211,229,100,35,193,30,161,147,100,113,56,175,166,126,125,26,19,2,149,197,150,245,43,181,188,40,205,29,232,64,254,246,118,106,224,101,150,219,59,222,204,96,92,190,84,66,216,185,48,136,182,41,0,183,11,114,223,187,18,185,109,195,147,4,13,210,86,243,35,157,201,69,75,250,24,196,125,165,197,192,27,122,229,245,23,30,66,5,98,147,158,81,3,116,165,67,184,100,217,181,204,145,27,13,5,1,22,208,24,19,77,237,223,56,87,227,67,159,44,201,79,108,107,152,38,69,224,161,148,86,95,84,69,54,144,142,135,216,165,26,170,221,226,70,28,163,2,50,93,103,71,107,63,25,198,217,36,139,157,47,211,208,168,37,15,224,209,95,39,58,75,100,29,13,194,50,69,121,213,59,20,142,253,155,113,17,238,231,127,38,144,84,16,129,41,167,4,225,55,251,202,99,49,105,172,129,190,176,0,36,71,46,198,255,146,209,186,151,28,122,34,92,133,146,250,103,103,146,29,97,82,102,76,76,57,247,7,89,247,19,191,57,205,105,218,44,174,223,243,203,127,198,45,58,19,143,24,106,50,100,78,217,200,151,168,68,47,57,182,32,89,202,218,47,254,201,150,23,189,106,93,153,173,233,250,104,252,162,187,80,216,198,151,81,34,241,96,190,115,65,77,112,244,201,166,72,8,57,164,217,189,172,83,112,205,11,67,177,165,95,251,63,142,119,139,62,211,244,150,4,11,103,169,240,104,65,69,42,74,187,118,1,219,205,132,119,80,104,241,173,50,152,250,142,21,101,161,153,115,209,204,99,42,219,36,249,245,27,53,69,19,42,53,114,56,182,10,7,252,27,104,92,225,242,209,124,9,109,21,154,45,95,195,6,232,209,1,52,155,36,53,188,48,155,111,145,81,206,92,250,250,202,253,101,95,186,180,175,226,5,20,250,74,117,149,68,122,13,184,110,137,117,138,144,245,185,224,213,100,99,184,243,80,24,104,68,249,245,85,208,60,250,126,189,25,85,33,114,224,10,40,249,21,231,207,79,138,79,249,125,102,136,138,117,149,43,56,94,193,132,57,99,32,34,93,225,164,221,98,45,128,86,9,84,220,14,24,166,152,146,208,28,21,153,125,201,88,23,250,229,11,76,161,177,41,248,84,94,59,52,96,128,229,103,51,219,254,129,155,243,42,88,239,247,108,77,41,157,165,86,115,206,129,242,48,89,219,62,140,184,133,95,237,231,33,103,107,18,78,78,44,30,85,251,2,177,196,34,216,141,211,83,142,163,182,164,125,35,99,13,171,112,247,3,1,123,2,211,228,108,146,236,251,93,149,119,197,213,154,149,14,63,229,74,86,178,94,83,14,93,27,51,11,136,25,191,61,28,104,110,86,103,175,231,88,233,194,197,59,239,249,146,111,50,71,132,102,15,126,174,177,89,51,107,164,113,77,200,77,188,251,145,107,74,30,86,41,144,240,104,162,129,225,233,95,235,49,240,96,238,131,103,217,143,137,124,151,227,72,86,143,179,177,204,127,82,225,58,197,104,70,105,168,72,19,183,160,254,1,140,35,9,51,47,126,224,166,239,49,249,192,12,91,46,251,247,68,38,58,176,69,135,129,85,92,73,242,19,98,122,225,93,3,243,11,3,171,25,31,15,187,98,254,84,100,60,253,243,17,48,155,221,28,51,85,79,15,71,161,65,87,183,187,14,90,234,80,103,153,159,235,208,199,148,151,58,101,252,5,172,189,22,215,13,104,97,38,53,138,230,8,183,32,240,141,161,178,85,52,109,131,129,116,57,106,147,198,156,4,165,196,15,87,116,72,14,80,148,241,181,178,39,242,19,67,96,39,51,230,165,143,65,154,133,164,117,43,60,30,34,186,52,204,217,124,86,218,144,27,7,100,152,12,150,220,111,247,55,56,126,242,157,185,194,208,202,212,14,185,97,93,27,244,108,199,68,56,238,162,129,218,157,147,248,125,84,116,164,126,159,86,100,158,255,59,24,216,229,98,151,148,164,222,199,29,24,240,153,40,250,108,81,72,191,47,151,73,12,34,24,134,41,203,61,191,234,186,1,184,116,142,247,229,79,217,78,114,204,248,112,44,10,224,238,8,249,63,102,81,199,5,94,160,122,148,214,154,221,122,249,75,68,183,31,229,245,232,162,9,232,178,99,126,212,135,111,69,119,29,35,131,99,92,245,8,35,245,161,215,223,24,102,236,88,41,146,43,237,191,82,201,128,255,220,1,221,100,89,163,17,30,92,40,57,138,66,12,54,62,114,0,99,104,150,214,79,120,252,88,132,19,158,115,218,34,99,160,50,223,33,53,128,228,79,254,130,59,93,216,252,28,236,186,100,165,227,141,80,110,214,91,244,243,122,155,156,79,99,53,251,126,250,120,216,23,241,114,40,35,218,71,140,116,130,129,179,65,159,178,198,44,20,202,210,33,52,58,199,72,169,47,188,225,180,193,238,62,237,63,238,110,135,152,198,249,49,235,14,36,80,253,254,73,133,104,64,214,253,143,167,80,12,55,167,125,150,38,226,144,125,91,0,187,84,75,194,230,168,142,108,231,215,36,106,180,235,82,71,141,17,145,39,19,90,146,56,125,224,231,165,83,189,160,191,59,165,245,74,108,196,155,248,78,62,238,227,25,191,214,109,144,232,165,29,11,123,83,124,149,118,115,153,196,75,114,183,93,255,177,215,0,247,50,111,139,236,157,44,94,69,249,216,169,51,139,158,198,12,114,73,217,148,38,165,10,245,155,69,86,228,91,220,231,184,232,6,188,103,155,39,190,218,206,101,204,244,3,118,61,86,121,53,157,73,103,200,73,1,9,253,107,253,20,136,131,28,165,138,85,123,244,145,227,7,101,75,31,228,222,120,253,78,234,172,53,119,83,100,136,119,127,3,114,13,253,160,80,244,240,224,232,115,32,2,154,144,49,75,52,171,203,236,204,129,122,235,228,247,119,10,240,36,40,194,217,74,204,23,184,173,24,190,207,18,181,161,108,5,158,169,76,207,190,84,239,63,204,92,51,91,131,224,184,233,183,102,136,132,160,22,158,38,146,21,8,173,42,22,221,103,211,35,170,188,104,104,120,110,117,23,190,135,2,228,194,67,237,105,205,197,40,166,18,167,229,251,145,223,121,59,41,241,23,164,0,230,191,132,108,92,190,122,205,149,222,172,25,235,88,200,159,224,143,29,182,254,14,19,181,6,170,217,143,168,243,143,172,206,243,65,167,199,53,59,26,116,111,43,45,149,222,110,115,179,196,193,28,42,39,139,26,197,145,52,132,36,161,211,106,240,75,77,83,157,117,251,170,252,236,216,2,102,228,164,199,35,174,56,235,134,210,212,35,87,168,22,101,225,16,178,181,68,98,5,35,92,46,103,73,114,17,250,228,200,66,86,11,2,48,132,204,65,43,229,195,107,66,39,27,29,176,107,142,112,35,215,254,169,118,183,221,19,91,119,153,38,33,114,43,205,206,19,252,28,213,87,180,23,237,58,173,137,149,229,252,42,68,31,41,159,144,45,185,237,160,37,163,237,232,92,139,20,206,95,71,50,220,211,130,164,133,59,185,75,121,79,212,247,223,21,205,146,4,248,19,161,219,212,80,203,102,46,219,204,49,43,205,116,167,155,156,57,195,194,46,8,119,194,91,29,12,2,74,113,24,53,67,241,143,73,229,69,79,218,194,18,213,168,131,221,215,76,51,178,56,30,226,250,14,253,30,196,74,25,5,132,86,255,99,234,26,55,90,161,126,0,99,68,138,174,90,10,205,157,33,211,175,23,211,211,193,204,27,112,20,244,251,87,107,222,230,7,30,70,191,166,102,228,187,160,41,147,196,22,205,210,96,175,197,213,82,191,13,172,76,35,127,93,41,127,71,203,37,98,182,230,64,68,61,125,28,209,116,204,40,214,10,20,203,78,245,82,203,145,139,1,98,123,63,165,12,141,65,79,91,47,196,249,70,141,36,142,211,39,236,139,174,50,153,207,54,247,53,151,175,230,179,137,90,173,6,187,220,22,136,101,162,137,172,242,125,106,244,48,218,179,231,16,23,28,82,165,255,42,103,235,18,150,180,191,46,208,199,228,46,250,154,196,7,74,186,245,60,111,164,17,166,120,116,221,189,88,146,65,222,221,3,162,108,234,82,3,173,158,106,26,81,84,99,178,62,219,221,139,63,53,239,56,3,188,181,19,58,157,44,112,33,77,166,163,13,217,87,16,66,215,5,80,36,10,197,101,114,86,179,206,73,217,236,51,17,48,236,191,14,146,32,208,247,80,178,19,21,47,140,149,180,191,82,232,217,242,225,224,48,107,23,139,180,4,14,163,223,55,228,167,56,48,111,78,78,102,7,30,123,88,249,221,174,241,98,55,77,219,104,172,79,226,66,178,132,0,53,184,59,65,123,110,201,185,155,136,111,59,63,248,83,50,70,226,212,92,167,201,76,113,174,188,62,11,79,154,241,58,110,86,118,186,39,79,239,96,49,128,128,40,139,63,153,36,25,126,189,28,10,0,94,228,227,108,101,21,128,105,77,173,72,245,69,11,39,138,71,50,74,73,161,53,54,47,134,125,108,53,67,65,19,89,21,45,40,105,53,13,227,125,198,60,88,28,2,242,30,219,212,143,137,84,220,171,193,176,57,151,70,106,98,60,237,218,128,200,181,143,38,77,244,72,45,69,100,132,88,122,14,104,86,63,216,2,211,40,134,40,244,136,137,193,14,106,124,162,154,166,101,182,58,237,147,134,79,26,91,196,93,53,114,219,158,242,254,233,178,23,240,101,102,87,18,203,46,21,31,165,140,160,9,188,201,197,41,210,179,218,38,13,232,184,106,30,78,179,245,75,5,40,12,76,137,39,126,253,193,146,74,147,80,248,244,193,1,140,133,206,103,114,108,175,171,178,207,122,130,115,61,198,217,246,21,242,234,117,23,90,13,183,11,88,207,23,156,25,122,70,75,230,250,201,0,3,238,219,224,137,181,237,184,63,168,144,236,97,140,230,50,190,76,176,197,219,208,138,74,254,124,36,190,254,161,94,133,195,56,90,194,139,118,210,212,172,72,39,106,0,138,60,181,31,178,133,156,238,37,188,56,149,208,192,196,65,251,250,73,6,47,200,142,245,148,87,147,117,129,181,181,211,171,61,111,245,246,203,6,216,40,29,164,197,95,171,168,97,183,173,93,90,13,74,165,253,103,106,145,118,148,40,242,26,53,254,69,195,220,35,146,147,153,93,251,194,137,153,27,184,190,203,122,83,164,198,11,103,48,186,202,25,37,139,136,246,10,0,97,40,165,232,75,103,36,234,31,194,5,253,216,103,54,65,91,94,249,20,192,59,121,9,254,244,175,52,170,63,107,240,226,188,84,193,107,136,62,14,179,74,109,111,152,142,55,193,5,254,148,25,93,203,78,35,66,67,202,99,190,229,25,18,16,28,69,75,64,63,118,194,203,33,79,253,254,90,236,70,223,248,38,182,6,23,53,238,163,189,224,221,75,234,221,125,202,237,110,153,236,120,115,83,125,154,239,2,135,174,170,250,18,39,147,9,172,81,105,182,94,133,250,57,141,240,151,163,218,238,135,119,60,61,244,251,250,135,65,66,112,114,82,219,42,6,229,209,93,137,49,117,46,191,245,19,217,132,165,121,110,77,51,200,31,62,183,97,132,15,222,62,71,147,89,49,233,79,36,223,100,187,39,15,133,208,248,99,138,203,161,114,69,209,105,51,158,97,178,41,80,70,161,66,57,119,127,11,31,252,16,112,0,159,131,222,73,11,88,154,151,224,104,166,47,140,218,230,149,79,229,175,131,192,42,119,170,164,155,56,251,106,175,68,74,125,57,244,48,118,194,198,177,193,159,146,69,246,250,195,165,89,121,21,162,141,31,216,33,116,21,33,191,70,215,94,12,172,149,66,201,34,97,223,97,116,115,251,106,165,51,65,180,33,20,140,61,139,39,112,197,116,39,211,152,132,193,222,232,41,184,72,122,33,190,107,31,94,148,164,17,135,107,5,31,243,255,34,254,222,180,242,147,13,133,37,182,120,198,76,130,113,153,131,60,98,114,202,213,27,250,188,48,60,14,135,193,251,48,226,246,187,235,238,242,120,136,200,168,105,144,33,132,217,118,24,35,71,218,134,1,180,29,147,235,147,161,210,167,160,93,235,142,242,103,99,149,4,236,121,152,84,218,194,86,238,155,200,251,119,145,121,12,92,239,210,233,165,130,197,4,22,107,222,66,55,176,125,246,114,22,115,123,181,184,176,29,222,37,176,22,241,24,1,207,209,234,250,87,220,205,51,150,169,158,176,65,46,248,236,81,134,196,107,144,212,26,53,123,28,98,206,166,117,139,105,35,167,34,102,101,8,95,54,25,219,110,187,93,239,227,94,105,113,154,236,112,180,34,21,162,158,198,212,214,31,127,230,170,58,140,150,54,75,250,82,196,56,190,14,11,45,154,5,162,240,240,254,180,61,221,39,116,135,142,163,215,180,201,246,196,100,229,38,151,205,62,49,8,195,117,77,165,158,236,118,77,11,77,149,24,144,31,241,99,175,94,214,222,103,197,128,138,55,166,187,108,20,161,43,154,134,158,44,164,169,80,148,62,7,87,155,109,152,28,155,32,204,147,176,233,28,129,7,84,156,243,216,45,117,19,192,41,81,69,177,17,241,39,157,161,12,44,26,126,33,125,20,249,151,92,2,193,80,174,140,107,154,108,245,178,33,181,42,254,249,8,189,100,13,78,196,117,113,62,254,209,71,180,129,57,199,217,183,168,50,232,179,82,198,172,136,196,14,132,156,228,175,236,128,110,8,90,250,217,247,1,207,137,159,146,104,196,121,108,73,17,213,163,241,144,196,216,254,50,90,116,104,76,16,71,167,91,252,95,198,111,107,189,184,108,169,84,3,215,19,147,77,180,242,97,178,59,97,42,125,242,9,166,52,35,233,116,40,246,209,77,40,35,32,192,83,27,240,17,160,81,76,67,217,22,82,132,140,24,179,184,112,183,14,215,64,215,30,193,129,164,157,16,138,206,170,120,235,66,96,2,17,169,225,204,84,173,84,122,74,81,92,28,206,224,130,69,182,196,69,227,13,97,156,130,121,50,23,53,215,75,200,60,117,235,106,246,234,60,243,161,178,228,35,11,121,4,67,234,5,60,190,70,37,39,217,80,192,14,209,191,199,89,147,33,124,59,15,184,181,208,53,41,228,207,131,56,1,242,182,111,236,183,103,13,208,201,14,164,245,8,14,238,162,221,227,136,27,120,247,180,124,126,155,9,149,44,125,111,249,80,178,106,201,131,14,46,195,23,208,15,77,128,142,131,129,113,50,213,5,100,175,72,139,170,154,35,161,177,51,95,6,105,168,152,22,49,115,84,231,81,193,39,80,155,120,159,158,86,115,111,77,75,96,105,175,162,160,116,248,237,60,68,95,199,241,162,236,122,83,165,117,190,121,212,32,64,195,204,52,1,251,164,78,153,186,218,79,156,216,234,209,65,138,147,52,29,115,14,21,248,70,226,13,68,150,170,12,186,77,223,120,46,122,106,96,90,48,94,201,187,252,171,180,116,219,85,12,106,188,231,204,8,154,107,140,54,185,214,92,19,81,185,102,207,6,126,19,63,9,131,195,166,185,92,82,213,136,139,254,174,223,54,15,104,33,201,186,146,100,81,139,84,6,46,152,216,27,28,189,16,145,228,118,180,228,14,103,217,188,83,103,30,246,95,55,136,9,173,187,63,141,155,144,29,75,25,173,172,2,196,59,171,102,214,214,209,99,89,84,112,57,9,124,157,27,63,28,177,20,24,229,167,56,203,220,86,210,107,245,84,117,8,65,39,70,203,137,25,98,166,140,89,188,54,32,180,14,217,111,120,0,189,7,3,129,152,70,226,25,213,75,113,17,1,199,9,171,186,198,4,199,83,115,83,10,133,240,206,2,76,181,139,174,246,168,124,55,154,161,41,20,8,226,187,135,220,175,103,121,55,88,154,61,58,28,227,252,213,80,25,47,239,249,134,129,90,119,158,178,191,196,193,57,69,63,160,227,210,138,125,12,5,64,159,104,214,188,59,185,45,227,196,19,142,112,119,90,88,8,75,71,200,32,125,207,81,212,48,93,191,1,141,230,253,176,229,240,101,89,119,172,251,107,107,113,69,168,204,146,167,35,193,202,49,120,127,245,241,148,131,199,235,178,151,228,130,178,15,216,23,22,218,50,213,193,190,185,190,119,42,141,148,136,225,89,203,154,157,145,95,89,212,212,74,139,112,214,103,28,171,206,58,40,145,116,28,199,39,77,43,113,198,191,46,42,124,227,254,31,77,150,222,178,100,165,53,159,129,141,232,33,83,155,255,159,246,192,5,148,5,79,149,218,59,131,109,1,52,246,237,92,44,19,235,96,126,145,57,85,206,176,151,178,94,248,96,130,145,32,132,198,64,170,255,32,234,248,83,103,173,103,163,77,178,90,79,23,211,222,81,141,82,104,129,92,87,241,141,242,239,222,196,67,185,211,73,73,54,231,156,47,163,14,231,117,39,73,96,101,73,237,196,82,224,57,166,171,121,69,160,43,112,57,104,226,175,9,152,109,45,160,143,97,112,129,7,186,90,214,144,45,96,67,40,83,205,177,84,9,148,94,180,121,182,176,39,218,245,5,194,37,16,131,250,137,225,171,93,80,74,177,122,214,175,83,31,154,99,14,147,59,253,241,125,123,227,129,114,114,137,168,31,58,30,147,77,179,122,94,81,10,18,116,75,193,93,214,91,68,245,39,85,89,142,241,141,245,140,213,162,219,161,69,146,89,56,32,131,30,85,230,66,91,47,133,168,156,110,7,63,15,137,169,106,56,151,56,247,204,153,255,111,186,72,107,229,158,206,163,214,214,94,89,193,55,68,252,66,255,70,236,122,73,127,173,238,137,185,43,64,31,213,233,131,222,79,62,231,172,19,12,5,134,145,149,113,130,143,93,249,100,163,220,253,99,245,24,143,47,149,71,144,1,50,69,167,105,237,10,149,66,111,3,46,111,180,205,103,31,148,98,34,47,247,170,229,24,213,243,172,198,14,45,228,251,135,113,179,78,211,216,45,63,185,178,214,14,163,120,123,198,29,70,26,79,137,165,74,212,163,19,115,237,140,251,103,181,234,30,30,225,77,131,146,46,50,109,197,19,165,33,72,139,7,138,84,42,252,131,62,240,52,68,61,228,177,91,168,146,93,66,241,94,124,125,157,88,115,216,148,244,2,46,170,226,167,134,162,233,148,80,192,39,200,242,10,182,214,116,241,163,17,13,135,214,198,230,211,217,112,99,179,165,117,239,83,144,125,132,151,37,145,209,219,143,61,237,216,169,95,177,139,52,81,239,199,214,38,36,245,135,254,224,134,99,107,63,93,214,45,158,40,99,81,168,47,59,107,58,46,149,224,160,45,169,67,92,65,151,238,229,220,231,138,118,81,82,50,59,210,102,131,162,52,139,196,172,179,195,223,62,101,40,60,148,85,118,220,88,202,86,182,169,243,212,35,75,217,209,131,36,158,177,129,115,29,93,102,128,233,159,222,186,185,73,39,51,16,38,207,68,167,155,18,120,141,82,191,210,111,116,102,227,31,235,158,96,70,54,30,104,236,227,233,144,128,87,157,64,30,53,90,253,219,184,224,185,202,25,242,5,98,201,57,253,247,247,235,219,59,26,185,157,21,155,159,39,222,33,134,219,247,30,178,137,115,122,100,216,67,98,24,165,30,53,15,123,117,13,190,63,247,200,219,105,33,40,230,204,168,132,151,234,155,159,114,86,117,26,133,125,90,161,62,242,29,68,176,16,82,26,193,35,65,117,226,254,193,104,221,111,161,162,157,36,196,34,190,147,147,20,211,204,215,128,183,27,127,77,137,132,21,106,73,43,211,198,9,53,132,193,253,111,237,100,18,234,118,191,147,217,83,43,247,122,28,140,40,189,116,108,197,250,194,221,2,45,27,197,2,27,248,132,154,160,247,232,239,91,132,213,116,187,189,49,250,142,29,243,60,150,217,28,194,79,60,141,84,241,168,232,2,89,233,110,90,134,99,150,233,168,188,144,255,136,115,11,206,36,191,19,93,29,181,162,150,142,29,190,139,60,76,203,239,3,238,146,119,155,207,102,63,7,215,56,123,97,118,76,74,154,169,223,139,70,158,51,120,175,50,225,131,132,218,183,134,54,201,154,168,248,80,26,208,134,147,234,8,217,123,166,48,37,155,126,23,141,60,193,26,182,111,234,108,251,109,34,65,185,1,205,54,199,210,39,250,129,16,157,133,86,26,242,200,197,170,169,144,198,118,134,29,157,86,166,15,199,152,95,89,149,51,56,38,89,64,104,138,22,224,52,82,40,163,127,109,116,181,108,90,165,244,5,59,194,65,102,106,52,130,148,249,38,252,125,60,220,6,167,56,145,128,57,73,251,198,219,233,18,178,210,124,30,6,5,104,241,93,148,62,237,46,147,146,150,2,234,90,198,197,12,76,105,102,124,95,141,2,196,253,235,73,194,78,111,70,4,143,56,45,49,160,216,85,194,152,172,181,182,245,202,88,159,78,180,2,228,252,73,120,131,57,244,78,86,58,107,237,136,11,80,202,4,0,2,77,137,122,208,41,203,231,226,177,65,11,205,16,145,155,51,45,52,223,230,74,27,220,108,175,130,250,117,187,248,149,252,18,191,98,3,44,167,240,84,228,8,40,19,183,22,232,177,214,63,170,90,110,10,64,193,217,102,94,48,47,72,219,89,139,160,55,120,16,2,45,99,47,27,108,129,107,106,236,53,115,143,168,159,102,223,80,165,33,123,193,115,188,243,190,195,32,215,6,116,232,57,118,83,46,26,5,42,233,143,13,134,197,101,9,134,128,148,149,222,197,198,202,225,92,133,21,234,60,109,35,15,200,221,136,140,102,142,183,36,33,15,14,47,147,95,117,172,214,254,202,14,60,21,49,212,38,90,52,45,223,83,254,143,231,61,36,171,75,237,10,253,30,126,166,192,57,83,244,35,142,161,195,117,201,226,167,122,1,157,217,205,17,8,255,104,76,134,151,102,102,135,227,79,187,132,231,170,40,244,42,239,8,225,219,78,160,64,203,102,120,160,94,47,15,48,28,219,113,36,131,25,228,133,48,85,176,86,111,2,45,120,53,181,53,86,238,87,128,76,147,217,20,124,25,13,134,148,178,197,61,213,112,219,95,116,175,65,238,76,151,164,214,26,92,143,102,210,183,97,7,8,101,250,163,163,224,169,122,90,65,101,169,230,74,32,248,196,240,250,240,249,230,127,213,159,200,134,83,87,50,147,118,180,168,27,126,147,109,227,201,0,90,179,58,134,167,204,101,57,29,146,228,64,141,33,12,127,107,174,15,138,202,166,200,208,0,242,189,188,119,225,61,147,68,1,229,150,238,92,137,193,188,58,214,200,235,190,224,71,109,96,63,92,175,27,183,175,159,221,15,187,117,243,240,144,235,59,101,221,32,250,24,54,120,63,234,219,218,221,197,2,207,50,122,148,181,119,107,94,57,160,146,125,227,71,38,217,72,87,192,188,18,219,238,113,47,9,166,38,52,115,74,47,192,131,19,123,175,76,218,92,145,27,78,222,198,113,170,113,133,188,34,65,175,208,94,232,136,63,164,8,232,194,24,120,208,221,113,243,151,114,98,171,167,112,166,98,5,91,255,190,6,94,214,141,0,230,168,58,186,83,69,49,62,66,37,34,221,217,46,240,174,9,240,31,131,122,48,64,90,111,12,245,152,50,221,157,143,230,4,25,11,57,14,155,118,194,236,26,199,216,60,142,99,35,206,165,149,153,235,82,160,33,250,58,172,100,209,213,180,87,50,210,227,217,229,0,126,41,118,22,193,255,107,66,90,66,194,69,38,135,44,11,146,230,146,154,199,147,197,79,140,11,47,232,253,216,185,148,133,161,186,195,199,37,236,85,45,139,51,129,100,41,50,132,116,87,131,180,215,101,102,205,240,74,3,240,243,130,150,149,73,2,48,14,19,37,215,68,242,251,3,65,92,157,180,28,214,80,107,158,128,53,80,140,22,195,0,167,171,94,145,123,163,227,21,24,196,0,222,183,215,174,65,198,79,173,53,200,7,12,95,140,109,68,7,185,158,190,151,88,108,220,95,241,230,198,66,236,170,235,129,126,80,146,28,18,199,81,68,88,237,165,182,139,27,217,243,87,189,79,4,181,210,131,191,54,217,91,191,27,122,152,155,170,171,137,142,184,16,35,160,230,175,246,89,145,173,67,37,136,67,198,18,9,207,109,120,170,231,156,145,100,172,166,121,238,15,60,199,241,14,209,73,0,67,30,53,182,155,238,4,170,42,124,191,247,25,9,57,52,116,221,84,215,146,121,57,104,178,43,41,191,239,192,229,36,175,170,28,58,51,130,51,139,75,68,71,0,203,208,215,109,99,59,15,147,39,65,94,14,189,105,102,212,248,231,57,104,32,250,16,115,139,253,69,128,83,127,134,27,89,159,198,117,205,1,18,188,38,110,73,18,51,80,113,243,217,215,173,145,114,205,15,76,235,7,107,120,101,48,244,154,128,192,236,199,79,187,34,93,123,160,227,14,58,252,207,48,159,52,39,233,103,175,22,42,182,221,126,246,212,214,236,20,140,237,147,183,159,86,79,179,124,171,24,206,39,33,164,207,3,119,132,233,199,23,146,239,10,22,5,68,59,175,98,3,71,188,89,20,23,73,68,249,174,201,147,143,225,108,217,180,189,103,203,171,32,91,115,35,60,140,212,197,96,35,48,7,69,128,60,239,183,127,224,164,234,141,230,86,33,218,39,162,44,210,148,88,143,172,171,12,80,237,192,102,110,237,141,74,134,94,88,42,213,246,18,98,215,224,59,171,3,66,91,0,108,127,9,43,159,33,49,235,230,243,175,173,30,130,15,88,57,13,103,196,35,100,123,97,201,181,100,248,6,210,254,60,171,183,151,186,210,229,13,218,244,39,209,56,48,119,78,2,47,210,118,68,50,196,21,128,73,97,55,49,11,0,98,78,246,140,197,103,54,233,122,39,143,34,183,45,11,71,83,213,66,211,36,246,163,22,30,247,103,54,31,191,120,50,164,96,48,148,170,200,193,155,119,79,225,31,24,84,149,60,28,62,154,46,223,8,219,101,215,64,238,221,225,228,242,183,59,192,160,173,176,141,61,120,98,93,218,50,79,200,9,206,41,18,77,19,130,89,114,144,90,130,124,33,249,67,225,156,153,168,86,133,221,108,132,213,135,30,189,247,183,25,241,99,76,78,130,120,255,13,128,11,132,122,81,29,104,90,120,43,195,2,160,221,213,192,160,2,29,211,93,0,141,29,44,81,45,165,97,245,125,129,19,42,74,108,70,18,234,208,76,72,214,216,167,156,186,182,251,102,230,124,157,166,51,132,189,146,35,37,91,232,250,32,252,143,25,208,10,84,96,243,36,182,43,251,125,229,182,6,26,101,230,200,97,219,183,211,37,146,43,192,85,125,32,114,94,241,56,167,60,52,33,167,82,181,62,86,152,170,238,222,19,51,37,253,174,10,165,24,41,22,46,49,76,188,104,228,252,241,150,249,184,231,49,56,231,187,5,226,142,120,188,57,172,130,222,229,71,243,169,243,218,135,136,125,52,66,100,98,236,79,102,93,42,2,126,44,185,3,43,102,210,0,54,13,100,44,69,195,153,154,81,142,171,95,68,120,246,109,181,6,208,245,170,95,177,139,153,213,149,156,168,218,132,63,123,0,67,90,0,12,198,156,4,67,131,120,74,218,169,184,24,195,162,230,12,158,100,179,47,8,201,102,86,17,132,28,177,161,122,88,57,65,247,44,251,51,125,190,134,9,185,132,213,95,212,2,102,16,10,39,125,48,121,44,229,177,156,34,143,100,238,40,43,29,242,207,41,37,119,74,237,79,6,182,93,44,143,25,74,60,181,179,0,4,70,201,232,246,80,240,198,64,52,219,144,224,102,215,123,52,210,112,243,62,40,192,94,141,5,17,58,65,240,107,4,117,74,194,26,123,244,249,44,45,232,59,71,14,192,11,90,61,24,197,218,89,240,140,104,250,54,161,28,153,240,21,18,113,224,145,82,143,160,32,134,26,83,201,149,224,80,151,3,219,134,184,159,104,96,118,243,244,208,220,66,147,249,15,154,46,116,186,30,58,18,53,89,222,13,248,103,237,5,219,57,138,66,239,77,116,166,163,146,55,249,116,248,89,135,57,246,153,25,19,96,33,20,148,115,77,65,167,84,110,42,208,228,222,50,43,124,236,242,76,184,106,134,166,69,188,16,239,50,205,131,204,219,210,201,210,127,67,129,110,150,27,1,168,225,251,214,146,82,229,77,66,190,58,26,249,91,123,106,22,203,12,233,113,233,181,183,236,41,127,154,85,50,33,174,123,72,71,20,219,243,213,124,142,13,25,13,171,172,151,217,185,76,20,27,32,109,113,126,30,186,120,109,222,51,141,175,162,219,46,9,98,195,45,96,58,126,123,79,229,164,135,187,108,250,60,202,203,66,247,80,204,233,7,138,18,209,194,123,12,83,94,2,130,254,176,151,59,208,203,169,184,228,93,78,61,8,70,249,55,218,198,244,168,14,12,36,205,8,211,97,212,152,53,144,252,83,159,56,231,206,222,150,96,23,255,226,88,114,77,192,95,14,91,246,165,76,46,29,22,231,20,37,52,15,210,83,236,54,254,245,61,26,82,151,4,131,167,96,171,190,64,201,69,211,97,49,192,126,206,122,13,237,242,12,136,34,69,238,224,122,217,51,13,187,211,229,92,77,7,100,72,151,10,42,184,132,125,167,37,154,69,120,125,89,229,102,149,44,54,32,16,23,17,8,129,106,176,195,139,205,114,48,65,140,147,251,146,159,63,116,54,90,84,25,235,248,180,70,96,179,251,115,32,187,245,34,140,236,229,190,178,138,42,216,245,87,176,244,157,234,128,225,84,125,8,1,202,191,182,74,202,118,140,100,248,91,175,157,110,165,99,1,153,0,213,249,137,194,39,209,142,215,43,113,55,155,115,174,10,21,168,201,212,75,106,156,194,28,50,232,41,22,84,238,136,70,150,172,188,199,253,67,254,148,188,181,245,65,122,22,138,112,59,193,172,87,227,65,152,182,196,191,204,132,224,52,202,30,21,24,218,219,237,44,175,253,65,189,106,190,117,199,3,117,33,66,134,103,110,233,103,51,218,15,138,242,73,93,74,174,221,34,155,127,11,214,95,81,182,227,202,145,126,3,89,200,114,16,152,73,100,72,219,208,221,91,182,176,204,140,113,149,129,25,40,90,47,237,41,39,131,161,4,64,244,212,163,142,218,224,211,117,27,69,240,105,110,153,96,254,45,30,164,223,40,211,152,225,246,107,195,62,81,128,48,219,90,23,98,124,35,253,171,52,237,57,221,139,13,238,73,20,184,124,32,116,254,211,191,60,142,95,194,41,97,27,167,39,213,69,50,130,0,99,93,124,254,241,223,163,179,43,67,226,145,231,123,114,53,166,251,142,36,51,180,70,28,81,219,58,39,132,168,122,93,64,3,80,1,199,254,237,62,166,130,40,162,62,70,182,233,207,62,35,49,48,160,98,162,157,115,223,73,215,191,245,159,118,113,174,183,211,2,193,45,38,148,188,202,120,235,163,239,26,50,45,168,163,169,211,98,79,32,152,45,167,218,145,179,126,141,175,228,126,50,84,84,241,13,245,148,65,1,110,232,234,193,118,98,204,99,200,109,171,50,110,13,130,240,10,112,27,96,89,56,137,110,195,170,109,12,238,117,128,154,107,255,106,182,229,149,231,130,113,7,21,95,166,113,158,30,132,139,205,21,117,163,62,167,35,148,10,138,35,73,192,17,125,221,132,140,229,115,49,221,52,170,130,63,14,95,210,47,133,157,116,124,251,100,155,7,243,26,253,213,60,234,87,187,204,86,87,38,47,78,5,81,30,221,228,127,187,96,151,196,116,129,17,139,197,173,35,110,184,134,232,231,250,240,248,104,14,130,91,202,157,147,128,247,103,230,2,141,248,45,215,8,68,156,211,166,226,152,113,72,162,183,181,3,252,88,162,5,124,52,240,191,204,236,82,34,75,188,86,55,232,127,55,24,33,113,28,140,39,60,44,229,198,3,197,166,102,105,89,81,135,162,77,215,67,36,179,252,154,199,61,147,6,181,242,110,62,105,215,98,122,136,179,87,254,241,71,156,81,101,47,64,152,20,161,92,64,130,213,182,220,126,192,192,191,185,167,186,30,153,112,126,135,28,111,34,202,85,138,255,66,95,252,80,41,234,206,88,6,167,179,104,58,180,19,112,116,235,157,130,124,101,96,228,157,69,3,12,70,214,49,69,153,63,169,183,21,78,74,96,87,68,232,112,127,39,27,9,222,198,145,217,250,140,231,36,115,104,187,137,136,147,168,171,100,139,77,145,217,207,12,185,130,176,133,136,75,69,224,138,242,156,46,148,3,252,242,53,0,255,94,99,203,49,47,95,213,235,54,209,25,186,75,133,105,130,92,231,33,236,44,63,53,55,252,217,5,34,195,187,181,205,22,200,168,95,161,184,204,145,176,94,61,205,185,165,219,26,216,51,241,141,61,16,38,107,35,103,165,187,229,167,88,192,10,51,99,45,172,146,158,230,113,192,5,247,3,254,169,95,47,112,255,82,227,154,221,255,205,23,19,204,218,63,27,223,74,110,133,94,130,7,137,20,17,84,76,174,171,169,101,181,156,67,225,203,150,107,41,31,96,55,2,3,212,157,14,68,160,221,99,180,159,48,35,242,35,167,225,243,109,121,50,105,124,242,7,43,112,179,178,84,237,139,31,180,191,148,44,59,245,226,131,57,125,66,129,72,162,113,43,116,160,230,58,239,89,154,252,8,197,157,221,98,37,81,34,81,119,187,224,164,205,138,245,223,69,12,184,126,239,221,123,71,208,61,235,76,2,62,77,11,6,82,150,232,49,172,87,183,92,132,201,232,27,238,47,114,124,47,225,6,152,145,236,196,78,113,146,193,49,106,56,196,127,90,123,85,252,96,40,168,123,98,82,39,145,130,184,183,66,61,215,152,36,225,151,232,174,113,97,204,220,182,89,56,90,211,75,134,65,151,80,96,200,163,93,88,154,226,6,179,13,51,31,133,137,24,75,6,186,0,55,41,58,50,121,191,84,74,232,46,101,211,89,252,28,210,6,179,163,115,202,221,96,230,230,3,219,171,11,183,25,7,4,41,239,94,114,142,169,123,103,75,133,220,59,227,3,235,251,26,167,189,194,45,115,37,41,38,235,188,194,134,138,78,54,79,128,47,30,6,238,8,239,38,79,136,226,90,11,99,186,83,148,96,208,205,18,176,139,63,141,225,86,122,208,25,188,10,132,26,135,255,193,144,47,207,6,18,70,233,56,208,222,179,191,163,224,241,241,64,162,145,99,86,88,89,201,2,41,240,234,26,138,121,224,221,16,13,2,110,47,99,133,236,74,205,166,148,240,112,108,234,52,105,215,35,138,90,82,13,6,206,55,209,188,132,20,167,236,9,143,62,234,26,35,7,146,236,36,50,66,71,118,68,217,111,245,203,160,28,207,20,18,176,43,88,45,34,249,72,9,98,122,140,229,79,91,109,131,80,41,210,61,175,46,70,38,105,206,254,159,193,25,38,228,191,0,81,237,12,36,175,105,218,9,146,35,99,114,2,33,123,65,238,73,195,213,3,126,193,164,119,16,163,45,36,97,80,221,143,242,244,53,198,218,76,186,142,76,141,227,23,7,82,51,158,0,45,16,180,2,194,196,63,195,91,0,157,15,182,58,10,134,47,119,109,249,187,100,18,189,115,23,252,194,13,215,86,141,240,151,168,182,166,126,92,180,69,197,82,222,242,253,26,144,53,124,50,133,240,218,101,94,119,54,59,73,218,57,12,153,175,129,96,198,150,151,86,238,177,213,48,253,144,82,22,133,44,7,74,232,88,239,25,205,32,179,12,115,130,28,161,22,155,220,130,150,77,187,57,76,21,56,119,151,59,11,223,68,109,204,78,88,191,66,87,246,64,97,83,31,131,58,211,21,27,139,53,202,174,89,42,213,192,65,157,159,198,15,248,159,73,226,233,117,192,71,137,83,42,44,230,96,79,241,58,97,165,12,12,250,198,13,88,183,171,84,103,127,18,216,78,251,215,226,194,180,88,158,92,83,64,185,69,114,217,131,162,222,29,153,15,76,27,105,32,33,49,129,177,21,53,52,248,135,103,45,209,211,20,73,180,254,187,37,88,20,5,110,221,52,193,65,244,149,104,96,68,176,19,99,16,150,53,166,73,88,3,59,164,87,128,57,59,242,252,139,226,43,236,101,133,186,66,82,215,141,71,17,120,132,254,174,192,84,59,113,189,176,204,159,152,180,9,253,222,53,136,28,53,160,87,132,163,251,192,46,217,140,252,208,83,135,12,119,64,17,82,85,23,239,4,16,0,39,230,144,183,171,98,33,91,85,214,66,61,182,20,242,45,131,69,157,51,13,10,160,202,181,43,244,88,44,102,92,96,63,35,27,196,68,41,62,97,127,145,76,235,88,223,239,35,189,59,153,213,76,95,181,76,192,243,215,252,237,214,61,55,244,228,242,177,171,224,146,19,52,90,11,156,1,234,245,64,105,118,81,47,49,117,51,136,20,130,195,46,184,194,1,82,249,77,167,0,44,251,10,209,148,164,130,34,98,191,75,81,0,153,49,181,201,134,178,253,221,215,173,226,163,55,238,252,38,19,104,11,127,123,69,100,184,65,139,79,201,66,0,176,99,213,132,226,172,131,28,28,172,131,56,80,253,241,92,50,81,189,193,177,191,148,101,247,25,247,243,179,122,207,123,87,165,158,70,195,195,123,218,250,157,51,179,3,45,22,215,45,98,158,25,151,211,118,6,150,172,70,91,218,29,93,227,246,213,162,250,150,176,214,245,69,67,204,116,238,49,109,130,180,22,69,42,21,89,138,205,202,209,209,181,232,193,242,152,227,189,140,220,59,106,239,248,138,210,8,110,124,31,81,250,54,53,154,209,76,138,123,138,240,235,217,152,25,61,223,168,135,213,160,212,142,206,178,131,16,115,226,179,161,144,12,103,42,68,14,60,234,114,142,239,33,161,146,71,239,90,135,221,82,120,233,31,24,202,221,46,182,79,53,220,193,2,184,43,29,177,37,213,33,54,121,134,141,38,6,46,236,222,21,181,112,132,100,244,82,146,47,57,104,229,250,99,114,161,192,151,3,244,25,212,74,191,13,168,219,143,79,110,36,111,5,180,26,13,127,70,80,159,78,150,163,26,130,9,214,82,89,148,31,85,214,85,78,168,15,72,229,36,221,82,249,251,112,153,45,9,175,176,215,99,77,233,109,128,158,31,155,5,230,10,70,118,240,102,2,127,147,168,29,3,42,43,241,240,49,67,188,175,174,99,168,39,203,80,242,113,14,77,27,152,123,171,212,24,253,159,133,188,170,4,90,138,133,68,195,243,42,254,29,204,144,157,19,215,145,228,178,137,60,204,240,76,174,255,151,185,0,164,118,39,127,50,28,251,149,188,210,13,191,88,20,148,40,65,1,115,31,32,75,81,163,179,65,165,168,220,177,127,109,139,240,158,200,42,21,15,21,226,195,102,79,40,227,252,238,113,147,177,50,2,33,99,175,28,92,39,128,18,70,12,12,202,237,164,158,245,250,94,254,125,197,45,173,130,32,157,92,40,48,90,204,174,136,106,182,207,200,154,62,171,75,124,59,129,246,179,118,240,100,210,181,48,228,88,38,128,141,19,148,181,119,246,132,155,175,80,114,148,199,1,57,74,140,176,172,247,102,130,10,166,52,156,17,214,141,89,172,44,133,212,149,17,231,171,163,6,72,191,3,222,22,229,14,181,53,48,7,18,61,36,107,52,24,120,0,97,0,212,202,245,92,194,16,52,116,193,245,126,197,41,136,44,53,70,190,209,127,186,229,251,97,176,115,40,26,220,150,85,20,60,25,14,145,14,150,29,57,95,190,95,86,82,43,161,31,255,21,14,120,53,27,107,236,78,8,217,233,255,1,118,108,195,40,106,234,98,53,149,131,4,84,208,140,98,121,90,199,102,251,48,207,46,205,141,48,101,13,241,98,18,29,162,234,168,159,84,38,246,115,56,206,222,47,177,26,24,246,92,37,237,212,132,75,217,204,123,106,148,88,96,202,136,88,31,64,170,13,69,86,171,22,204,59,114,212,175,28,153,225,32,193,156,125,240,161,104,36,12,115,32,57,238,118,26,95,199,87,102,191,11,55,65,235,136,135,157,216,188,104,103,193,231,188,122,201,255,192,143,233,61,20,10,159,30,190,1,120,85,168,179,37,32,40,53,84,239,214,162,119,43,216,71,226,179,152,167,175,202,98,47,75,17,165,146,33,185,188,161,254,170,20,59,24,247,92,174,37,94,35,26,250,61,50,143,3,54,110,221,111,97,215,143,159,104,6,159,63,156,154,30,29,63,6,55,24,212,124,224,187,200,50,156,181,99,228,62,182,37,134,87,237,206,167,209,192,77,108,211,218,19,57,65,94,161,46,119,187,169,90,240,76,187,150,191,102,236,96,205,33,98,123,186,145,98,157,193,81,125,202,172,59,227,221,8,26,127,19,17,226,143,125,138,243,156,45,111,224,214,75,143,173,40,139,80,100,158,59,249,146,199,185,149,33,35,107,125,82,96,235,113,175,73,154,242,113,178,223,178,211,124,236,97,213,10,149,124,109,172,174,98,123,162,120,81,63,199,185,1,96,39,53,70,80,125,42,220,212,99,215,118,175,149,141,156,130,103,252,94,237,2,208,203,159,133,145,246,151,80,92,87,194,183,88,153,169,24,222,134,76,236,186,149,204,66,98,173,150,177,64,76,136,9,30,229,126,120,247,191,18,205,224,175,31,209,126,113,154,229,190,173,232,107,74,132,91,100,199,240,207,191,66,118,101,75,225,202,33,143,172,26,13,5,26,26,31,195,15,103,201,195,162,154,62,138,115,40,166,38,204,222,180,75,31,129,133,212,18,70,228,230,111,215,120,51,150,197,211,137,138,159,231,224,46,128,89,67,40,234,47,102,83,252,134,132,22,248,111,52,169,63,87,255,83,6,238,186,181,125,0,190,170,132,72,243,72,78,133,4,12,78,117,2,202,76,92,229,96,8,37,55,90,225,239,75,109,16,145,67,119,15,23,0,161,195,42,91,250,151,21,232,179,32,161,162,216,214,33,17,142,126,234,46,236,212,107,75,9,143,151,191,103,164,110,165,53,40,230,78,158,244,41,253,209,75,70,164,118,34,91,177,113,38,56,78,1,122,37,181,197,192,210,123,154,151,214,197,111,124,244,220,47,208,100,144,229,2,109,92,124,146,80,228,204,104,34,179,249,82,48,115,135,209,142,166,18,143,20,140,2,176,190,82,221,71,94,80,115,187,39,116,62,165,79,61,244,118,116,27,242,113,103,127,175,48,159,77,232,95,207,27,17,16,31,14,20,112,201,119,202,114,151,209,177,180,178,169,136,205,171,246,240,55,57,191,1,216,107,229,65,200,91,100,231,16,7,142,138,137,236,13,127,211,58,206,45,78,105,44,255,63,24,60,85,239,76,29,138,94,2,174,213,18,0,27,41,72,194,58,143,69,40,127,214,142,209,194,203,195,168,223,111,115,124,67,94,53,214,182,138,38,156,39,99,253,242,197,134,176,182,129,144,230,198,53,190,141,141,93,53,242,85,122,106,199,204,142,77,73,81,62,110,222,117,141,164,151,197,109,157,130,3,176,69,91,167,18,58,130,240,89,187,153,174,52,89,186,58,21,249,62,164,68,201,52,20,149,125,123,214,104,46,105,245,76,142,9,76,123,179,10,11,61,230,242,214,191,246,144,120,148,24,204,200,215,167,64,244,236,156,62,105,77,214,89,1,223,196,49,155,63,110,69,144,88,141,217,48,50,155,9,239,57,246,135,182,218,57,107,1,79,162,113,32,224,166,23,33,113,106,72,16,148,57,102,151,220,75,6,219,242,87,236,163,103,8,147,250,155,173,76,174,203,229,95,137,119,190,133,170,173,219,67,34,90,31,196,18,44,201,158,197,118,116,61,174,199,59,211,75,20,40,222,227,31,77,223,204,205,216,219,63,242,39,50,83,172,90,247,225,228,203,125,210,226,177,158,39,79,243,76,48,35,184,23,159,143,111,252,90,94,131,92,248,217,241,18,203,111,194,20,100,127,116,246,138,79,79,24,214,165,28,77,150,141,37,235,155,20,227,28,218,28,18,155,129,241,183,4,106,239,83,223,160,252,22,153,58,210,1,159,48,53,23,255,167,151,88,61,116,69,139,42,167,174,208,7,149,147,252,175,240,112,45,213,156,49,184,97,134,43,163,30,177,118,5,33,137,228,161,205,194,129,157,210,80,243,122,170,118,150,133,225,53,212,133,110,155,3,231,107,96,240,70,41,66,135,201,56,95,2,228,111,27,210,168,184,93,34,175,59,45,95,43,222,49,88,67,215,119,58,123,131,180,238,242,139,170,94,222,33,142,161,197,114,91,58,148,180,44,253,42,91,114,127,238,86,115,124,214,35,138,138,16,215,184,125,139,130,159,200,131,146,110,1,251,224,224,81,196,184,42,13,100,40,12,161,151,235,231,160,85,245,172,232,185,214,10,64,96,229,100,238,4,240,234,178,223,89,234,198,134,186,99,203,58,226,181,82,57,91,159,107,70,244,21,143,189,242,157,161,43,6,117,202,106,223,197,195,191,239,245,166,74,252,116,243,123,248,93,119,41,101,7,247,151,86,125,186,218,184,125,15,206,78,158,89,212,137,31,114,3,0,14,78,105,84,31,100,139,220,180,139,59,25,37,215,202,81,43,136,99,153,176,206,111,140,230,255,248,8,106,157,105,106,164,178,70,88,24,230,245,125,109,104,233,171,100,213,77,59,92,20,13,193,41,118,66,19,172,236,161,60,212,4,209,230,242,90,79,177,253,186,138,184,172,61,241,171,53,84,63,128,93,222,121,198,68,255,4,40,119,101,14,46,36,1,250,88,191,59,206,246,8,93,84,128,223,98,212,233,89,248,179,44,198,66,186,28,138,188,191,14,191,31,97,65,91,204,192,202,253,36,91,76,239,99,159,244,100,145,205,192,80,54,10,35,174,199,104,133,217,195,109,87,5,179,151,236,168,137,101,30,79,126,175,99,219,50,7,229,42,98,18,231,78,189,30,73,23,144,245,42,109,109,253,192,110,129,91,36,145,134,94,208,17,163,77,232,128,107,48,94,7,247,57,130,121,130,130,35,52,24,80,225,85,155,241,149,105,246,118,37,107,61,124,113,13,109,23,96,143,147,19,43,243,7,45,176,206,195,85,19,95,117,99,24,248,185,114,52,141,110,207,236,46,108,49,49,61,247,200,22,59,131,49,223,183,143,234,102,61,229,132,102,163,22,247,51,178,187,130,173,10,205,101,163,120,227,247,98,72,177,0,124,192,156,36,67,19,107,168,43,116,44,18,47,198,255,247,57,169,237,252,104,11,156,137,237,133,243,96,114,72,208,30,18,33,89,95,14,42,230,196,201,246,67,138,125,157,21,196,239,65,228,38,47,149,33,20,171,18,134,236,125,90,39,174,252,183,46,236,148,115,241,211,173,253,139,123,218,75,134,106,34,218,232,12,168,60,219,159,89,173,102,159,95,160,50,115,4,33,145,132,84,234,248,176,214,133,181,98,47,33,153,126,209,124,201,67,129,129,111,82,34,34,132,162,250,38,110,97,146,153,126,57,42,79,180,19,82,149,25,171,146,96,232,33,221,142,222,242,145,209,102,216,181,3,130,153,236,199,230,140,225,56,2,160,207,167,183,39,243,189,128,204,114,159,220,98,157,60,244,46,1,218,103,153,220,135,25,103,220,77,87,26,80,246,108,161,129,165,230,228,22,141,122,86,35,141,132,98,35,24,113,106,60,125,148,206,222,70,243,243,42,220,246,53,36,153,116,156,161,219,239,122,197,116,77,250,234,225,168,108,23,225,123,215,199,169,109,88,105,245,92,77,5,51,221,39,187,168,151,46,84,185,217,210,93,50,227,203,116,47,247,169,171,43,182,12,219,188,169,235,176,108,119,114,163,113,246,251,43,125,134,69,116,123,233,170,99,131,134,142,89,53,192,100,143,71,210,100,127,164,204,55,9,138,32,70,59,216,169,172,12,83,154,59,60,77,140,68,202,21,113,99,28,8,240,14,234,175,78,23,127,195,49,136,46,126,1,221,200,77,153,157,184,116,55,3,9,80,32,215,63,55,69,162,221,140,30,48,238,176,60,147,80,42,148,59,158,99,71,210,145,238,210,62,68,218,118,40,113,202,12,129,32,69,114,147,188,49,76,69,195,37,114,222,0,101,235,9,20,241,61,111,246,123,8,36,75,141,21,66,140,161,159,121,183,219,198,65,34,158,227,165,106,67,53,99,179,247,100,67,57,244,170,36,86,55,24,50,16,92,245,247,253,186,183,71,180,81,22,163,30,128,66,234,137,214,253,170,65,204,133,157,146,184,188,50,247,237,213,115,104,32,67,163,235,24,150,242,226,68,54,66,161,9,188,182,38,147,229,181,243,64,93,109,123,252,25,102,127,6,190,52,64,212,109,164,27,215,103,89,127,83,91,8,116,139,42,52,35,93,105,141,213,213,197,124,240,151,187,41,148,36,105,197,107,25,130,194,108,93,57,45,32,70,70,235,22,44,208,117,32,226,161,208,198,27,99,222,169,208,153,165,159,244,180,166,7,114,22,38,243,78,10,95,108,254,77,165,89,10,99,236,222,178,55,228,80,55,71,103,149,229,94,182,141,244,3,12,228,35,52,35,254,1,200,83,124,154,202,207,132,51,251,219,162,217,44,51,36,188,13,96,220,119,194,17,90,118,39,243,100,98,21,176,223,11,73,9,86,132,237,245,51,58,102,171,196,233,90,206,31,202,110,51,128,93,114,88,10,125,185,81,52,197,169,168,197,137,29,221,192,155,251,22,201,57,158,33,163,203,133,93,189,81,40,31,38,169,19,10,223,62,123,248,158,250,251,35,53,93,211,164,236,45,184,74,138,90,144,73,167,162,182,163,118,31,57,215,121,163,38,51,29,215,252,224,226,119,27,146,73,144,120,149,141,8,138,245,118,13,40,24,77,60,139,155,12,170,231,14,5,250,52,12,87,201,196,233,131,58,77,68,185,225,147,186,232,77,37,124,223,120,8,208,13,73,188,250,159,240,78,36,109,159,90,205,203,41,154,73,73,193,12,155,87,154,52,1,235,249,151,146,25,18,17,72,188,106,83,191,208,43,141,43,43,76,99,111,189,0,5,135,218,171,32,217,110,247,52,60,135,25,215,69,166,139,193,146,15,18,4,226,253,201,243,43,136,227,170,42,130,54,191,48,13,225,22,184,175,3,98,51,117,32,100,72,186,232,253,2,171,100,22,23,114,74,13,141,107,16,118,59,16,58,41,206,1,77,195,42,94,81,203,52,50,246,78,140,10,108,153,124,196,111,167,161,175,59,25,65,183,201,17,48,19,180,72,171,12,109,174,78,149,171,126,55,112,238,233,9,247,167,36,105,85,34,239,69,111,237,31,229,4,175,203,141,179,159,142,185,97,2,138,216,255,222,83,217,187,189,52,238,40,49,177,53,141,226,152,159,196,146,236,147,214,90,73,244,124,14,141,85,160,98,243,123,13,193,192,70,174,175,166,17,198,46,124,78,122,134,193,3,127,43,143,171,154,231,20,54,135,242,186,156,96,153,46,150,65,145,18,220,184,191,74,188,44,102,127,46,241,230,41,192,129,7,206,132,58,87,14,104,54,170,18,184,86,137,63,11,180,196,183,227,143,224,10,151,66,12,85,128,101,67,213,200,43,126,219,98,132,109,178,132,14,49,14,64,177,52,68,75,251,255,135,93,88,199,254,145,70,221,51,250,10,72,173,182,13,9,95,255,222,33,23,255,31,140,76,100,18,238,10,121,33,104,37,243,198,85,103,218,133,83,62,12,255,209,96,24,237,67,14,72,33,214,139,86,123,18,217,7,72,72,197,159,164,59,166,140,11,177,182,216,79,27,193,138,137,251,71,237,98,100,174,180,175,46,183,85,13,251,57,48,119,11,67,43,175,64,210,239,163,88,157,96,195,16,63,28,197,21,211,161,10,86,5,177,153,112,202,29,253,151,22,69,174,183,94,23,113,38,4,197,113,61,147,219,218,40,45,2,227,161,226,56,202,235,110,151,251,121,29,196,199,74,52,238,6,120,180,195,107,246,249,223,214,172,140,46,8,178,90,223,131,235,163,64,225,85,0,44,184,202,30,97,172,237,228,130,128,0,94,218,69,1,58,125,203,73,15,133,143,106,187,52,211,240,103,173,115,208,95,155,216,164,101,249,158,148,47,152,254,17,190,126,140,47,116,206,2,51,12,48,210,165,62,212,122,12,217,218,183,79,151,128,45,13,33,176,246,220,246,195,20,208,120,216,179,195,245,106,76,131,222,65,191,107,157,213,136,33,179,249,120,129,133,160,187,198,129,123,243,156,70,6,221,149,252,150,44,245,195,0,253,108,96,32,160,51,245,115,147,156,52,73,173,10,41,90,103,125,25,221,188,188,174,179,2,40,147,135,30,132,73,128,214,235,188,250,111,87,237,164,145,76,196,175,89,250,43,85,172,252,225,81,233,230,85,58,69,101,8,251,86,81,162,208,136,45,123,210,21,57,30,146,186,67,65,101,249,147,3,204,29,60,232,49,248,86,195,218,230,208,242,142,15,26,161,158,118,9,190,205,123,244,105,162,84,250,245,34,188,195,208,198,219,169,218,153,78,66,55,145,135,230,24,188,180,80,88,255,68,238,11,35,37,212,161,62,116,0,204,244,6,122,96,149,146,182,117,255,255,190,144,126,35,205,27,218,74,205,225,181,180,13,236,149,85,161,22,215,142,210,28,48,41,110,86,100,244,119,68,206,153,80,25,154,179,241,60,115,227,210,222,136,62,55,136,5,16,82,225,254,209,127,169,94,33,153,39,87,251,138,108,63,70,93,76,7,254,85,77,221,128,46,143,70,128,194,169,83,41,164,128,255,127,25,122,67,32,236,42,212,242,138,103,110,127,3,147,129,172,74,18,175,190,1,62,253,175,178,201,156,221,161,176,244,143,17,57,120,38,51,103,154,231,205,122,83,110,227,138,224,167,151,1,209,155,180,121,129,183,93,3,96,186,83,175,218,161,218,55,40,113,9,156,98,214,184,138,92,199,83,214,50,7,10,76,7,146,38,26,32,248,23,131,57,140,185,25,182,112,132,159,182,165,241,247,202,227,210,205,77,223,14,251,94,123,184,8,73,189,19,166,60,61,137,78,194,201,216,147,135,159,60,69,61,22,126,211,48,204,175,225,46,109,238,52,148,14,234,93,94,171,255,32,71,26,186,183,7,219,15,72,224,202,43,233,125,143,171,212,143,116,120,244,55,205,128,56,8,77,83,161,78,99,229,243,111,216,234,4,195,56,185,232,145,31,23,67,14,244,213,53,111,25,227,46,104,223,159,113,217,129,109,102,30,9,241,120,122,129,249,190,114,229,194,115,62,126,197,60,37,65,124,215,189,49,133,15,139,94,79,87,197,65,19,147,229,10,219,186,150,121,224,27,170,158,175,233,226,193,65,129,141,237,151,54,183,72,151,85,221,204,78,222,191,91,8,157,227,17,112,77,201,19,119,201,70,109,238,11,116,75,212,164,27,16,237,129,35,143,249,20,90,253,213,230,253,190,22,160,37,75,148,173,159,234,144,252,206,222,34,234,5,72,221,240,6,72,120,217,207,96,44,83,28,200,85,172,227,157,79,210,108,179,208,89,157,64,68,59,54,163,119,90,19,160,214,249,173,138,52,38,2,193,145,161,107,200,105,15,205,156,26,89,219,126,177,217,150,241,194,228,99,132,91,166,118,116,245,218,150,102,208,215,120,215,141,143,208,2,93,58,35,244,177,45,132,222,117,70,207,129,195,46,60,143,136,4,62,220,225,204,168,36,149,63,215,184,143,183,175,170,160,104,15,243,17,126,154,106,222,216,78,123,32,194,226,130,223,237,32,177,26,113,66,231,76,56,10,93,221,246,42,151,62,11,199,15,190,38,78,203,35,26,121,162,55,13,244,109,136,93,61,229,61,23,179,233,74,57,139,200,126,246,185,46,225,78,192,229,132,32,212,170,177,109,46,199,123,46,250,218,229,153,101,141,175,66,194,197,160,185,216,114,123,167,108,224,115,19,149,60,123,208,204,254,198,226,238,133,94,129,238,87,58,101,215,179,170,164,38,66,67,91,50,86,228,166,159,24,132,110,177,28,139,114,242,246,125,133,227,225,236,132,29,93,178,79,31,232,6,53,115,209,6,143,45,109,78,223,16,187,168,100,185,89,158,153,233,91,197,199,182,73,42,23,214,107,28,146,6,133,173,186,137,189,123,154,179,185,245,56,219,174,201,227,34,222,91,246,86,207,12,85,161,240,192,182,44,28,183,89,10,55,111,160,95,190,188,55,189,154,33,205,171,159,6,77,196,237,53,115,172,131,224,146,133,205,221,3,93,233,139,131,47,77,7,91,173,17,214,222,114,27,182,228,228,182,114,161,9,85,113,178,111,35,89,112,212,47,35,143,141,172,61,6,16,67,137,113,59,108,145,221,101,108,193,162,214,174,72,152,114,60,110,77,192,221,236,60,43,130,206,171,52,83,240,88,142,252,165,65,84,12,41,154,252,92,213,44,23,212,23,118,158,192,80,126,163,164,240,37,164,80,34,221,161,124,69,70,114,166,102,8,28,21,235,100,227,219,89,30,124,46,120,152,246,88,50,101,149,35,32,60,168,36,251,132,48,148,64,228,215,122,216,84,121,247,4,97,78,127,168,122,179,235,121,196,225,152,44,203,145,32,9,21,218,234,94,157,217,235,64,40,229,87,73,47,146,133,241,128,198,96,251,208,235,7,187,197,188,206,148,36,213,38,232,65,130,56,0,127,28,229,22,249,44,107,238,233,114,172,89,109,54,218,92,161,216,1,244,81,163,85,111,251,82,110,8,143,168,53,158,206,193,207,107,189,55,15,57,47,88,184,74,26,7,192,100,96,198,23,113,97,164,26,245,138,211,90,17,140,152,165,226,14,83,11,59,115,119,75,50,186,21,216,102,80,37,86,113,73,129,56,47,68,206,114,176,48,163,47,159,191,137,238,225,51,117,53,70,98,232,135,78,127,197,199,27,249,249,114,46,194,147,189,223,40,108,188,9,33,236,196,96,144,98,121,69,235,102,78,200,23,212,13,165,201,172,226,255,233,54,221,192,241,36,165,229,250,191,119,80,248,101,109,136,23,196,16,140,34,221,49,107,200,171,23,218,36,31,243,179,75,250,255,114,230,69,59,3,104,178,162,131,32,94,251,53,93,34,114,199,47,228,123,165,92,174,76,247,102,205,55,136,186,119,130,104,86,21,121,9,112,66,243,131,191,34,7,29,73,204,51,214,225,119,229,3,190,178,90,173,153,26,186,156,226,94,71,11,139,197,252,58,167,143,216,48,74,41,7,170,217,203,51,100,57,141,239,135,214,153,133,28,82,110,117,32,228,173,215,173,26,207,153,225,35,40,166,26,248,95,237,160,207,141,255,131,159,201,182,104,137,107,4,2,122,103,3,61,228,220,193,197,38,174,85,67,0,241,239,155,201,240,219,57,122,58,11,30,186,129,151,48,239,103,163,165,76,207,244,175,53,91,226,112,249,233,59,151,17,137,140,74,220,175,11,239,144,48,154,30,161,233,161,209,73,151,97,239,240,217,181,36,248,206,102,90,119,164,70,174,34,167,104,45,239,141,231,100,220,33,190,163,146,45,166,198,29,222,222,73,70,159,167,68,14,111,17,124,236,146,96,5,59,64,175,44,71,213,34,156,82,7,99,51,105,39,236,61,119,128,145,185,59,193,65,152,100,21,154,33,193,146,90,63,177,173,167,100,24,114,207,186,120,89,225,191,110,0,254,128,171,27,144,61,62,161,16,181,245,177,108,176,239,92,200,17,75,175,216,121,82,122,158,99,79,109,40,192,47,162,49,5,7,155,25,78,250,90,122,198,15,168,169,18,180,43,21,218,228,169,192,90,65,119,124,136,2,206,48,205,120,0,249,221,163,127,255,120,155,55,174,179,124,176,39,84,94,62,185,216,219,36,228,119,35,3,148,36,151,149,44,113,22,115,167,254,176,160,19,146,181,240,20,222,12,6,176,223,88,153,92,183,198,222,214,24,6,109,76,59,41,181,254,4,142,41,122,127,147,61,7,252,247,220,174,215,85,119,56,186,69,241,132,5,118,179,57,72,60,204,124,76,34,117,46,130,183,132,81,9,182,79,215,173,218,8,201,123,244,132,135,244,245,118,110,40,211,208,121,4,194,132,217,182,247,101,89,107,151,189,29,158,61,91,13,90,216,6,170,230,12,199,33,131,241,55,109,55,134,220,0,24,223,79,50,128,245,145,21,183,231,244,190,69,72,103,77,156,102,93,36,43,235,12,231,229,175,239,136,17,104,8,70,235,48,134,91,128,80,186,7,41,111,169,190,252,37,79,225,145,21,17,132,222,161,123,118,35,66,188,191,8,110,16,51,86,147,116,39,122,33,198,219,51,4,105,24,31,128,162,27,32,77,16,81,123,220,93,58,165,13,254,18,227,114,10,170,144,222,181,21,1,181,67,4,45,1,86,233,184,77,137,221,32,196,44,167,243,68,57,30,211,143,107,102,161,54,153,252,156,222,242,207,144,174,158,13,138,109,73,148,226,111,215,196,239,39,72,234,123,142,230,140,72,195,24,244,224,67,127,169,58,226,243,217,165,123,137,179,115,56,204,87,209,147,196,136,188,237,35,20,124,38,132,106,201,160,215,105,222,210,170,111,150,222,80,167,98,87,238,166,152,27,212,213,148,243,149,181,20,207,241,2,233,132,165,190,132,169,133,112,49,94,25,46,165,211,160,200,175,71,35,88,167,63,50,45,248,179,6,182,103,226,121,141,159,90,123,168,147,19,74,127,115,125,210,56,253,225,249,211,77,164,48,110,115,155,18,3,56,13,152,190,254,197,222,62,103,241,146,59,109,169,86,240,54,133,22,31,37,87,213,234,83,68,66,139,68,46,30,80,79,18,141,183,137,117,60,132,219,183,202,9,233,122,29,99,22,241,59,48,3,13,202,59,145,133,171,225,192,221,37,79,204,157,82,160,117,252,185,15,228,75,237,28,213,69,200,193,221,179,68,241,218,56,82,62,93,13,110,29,152,171,82,77,59,14,85,185,225,88,42,151,129,177,5,153,168,48,93,44,202,126,186,131,45,159,29,58,76,8,154,96,183,236,200,160,212,216,20,253,31,214,102,76,117,87,119,239,230,20,151,216,9,13,155,189,178,194,234,228,182,32,7,61,161,53,165,247,57,107,236,220,40,64,203,156,122,105,18,172,110,122,110,124,1,52,164,174,151,143,246,18,122,114,35,246,24,84,232,250,53,56,30,99,146,216,177,106,8,2,164,225,139,50,47,191,106,121,157,224,55,10,126,78,100,65,15,56,121,96,8,145,238,173,126,184,207,6,81,134,75,114,33,130,102,189,156,191,23,94,181,66,24,80,47,127,45,170,196,163,243,238,162,138,132,167,22,162,182,208,109,163,56,17,110,116,134,105,246,10,249,188,157,230,228,20,11,169,79,148,77,151,44,239,203,33,125,100,10,245,191,30,166,13,222,15,215,125,180,10,48,53,75,29,236,6,214,203,75,203,223,221,220,98,196,236,147,141,111,105,45,82,89,71,121,170,19,151,4,203,1,52,104,69,98,249,185,16,248,225,6,141,220,127,171,176,186,28,35,79,144,6,250,79,27,188,131,113,250,171,189,244,96,94,37,61,68,155,125,160,228,97,105,74,170,232,10,210,15,133,12,121,198,41,3,161,101,57,197,239,244,89,180,59,88,83,182,133,71,12,31,85,224,168,195,184,162,65,66,52,158,150,43,93,166,164,20,105,29,69,102,46,20,20,97,14,217,14,140,225,192,125,35,56,15,15,16,127,153,202,212,93,197,204,80,1,64,44,43,183,88,160,110,209,163,123,198,242,142,161,46,144,83,241,87,60,182,84,216,34,3,17,43,4,237,96,27,137,8,199,141,243,16,55,210,219,0,0,239,86,99,233,40,8,29,143,26,22,158,172,184,53,219,255,47,211,112,61,88,59,71,27,102,187,250,106,109,184,226,159,151,217,142,124,244,35,242,136,10,167,233,166,87,8,61,89,189,127,236,212,97,197,109,47,51,131,91,88,43,57,32,145,0,201,255,11,31,12,91,181,220,188,235,214,20,249,146,55,242,167,67,148,165,219,180,122,52,79,149,36,24,161,12,144,133,63,29,4,218,125,186,190,200,212,157,165,144,179,135,71,87,243,240,111,163,141,73,250,246,109,199,122,64,122,119,5,65,22,192,200,90,218,115,231,95,217,146,164,64,110,204,124,13,57,24,95,21,198,173,80,42,88,191,105,174,200,0,14,231,90,42,103,75,188,235,13,121,52,167,210,223,210,177,237,158,18,104,11,190,167,115,219,96,217,143,98,159,118,171,25,157,223,50,253,150,75,30,208,51,188,197,116,219,206,36,18,1,152,212,151,102,159,46,223,226,91,170,12,57,91,83,86,223,204,194,149,214,28,90,63,128,24,240,182,107,46,5,211,43,53,114,230,192,227,42,103,97,243,14,26,33,13,247,245,44,99,178,165,168,221,139,141,127,36,206,27,143,133,156,183,224,248,202,3,96,113,235,183,92,146,133,106,168,77,245,106,128,170,54,116,223,113,101,145,37,221,186,206,46,146,189,59,221,116,227,134,173,170,107,92,166,165,86,120,146,224,114,195,45,243,112,61,204,95,214,122,144,149,198,92,37,243,162,219,186,12,105,112,92,0,199,131,97,128,14,59,217,102,45,185,243,191,8,165,89,97,191,237,18,52,194,218,117,37,145,31,116,91,101,19,18,96,233,8,5,55,247,3,159,181,196,240,51,218,127,251,210,14,141,17,160,158,80,174,169,165,92,233,253,4,98,92,181,235,199,237,66,222,14,161,22,72,215,185,51,74,123,127,46,29,161,178,147,4,79,45,101,189,203,9,216,42,5,107,78,221,104,67,50,208,0,141,31,228,174,171,194,38,238,9,121,75,41,232,91,193,157,64,234,251,65,45,162,67,196,100,102,95,39,244,235,132,10,128,118,162,38,178,76,255,184,246,51,19,124,61,100,144,53,24,159,185,230,77,151,230,137,243,250,104,174,182,201,221,211,105,7,205,57,149,135,184,14,175,79,222,188,68,231,64,172,93,228,158,4,189,208,136,213,59,117,233,197,247,232,232,184,127,63,203,44,122,185,24,156,0,248,140,82,47,106,91,15,228,181,74,255,194,60,82,209,228,120,68,3,167,47,249,183,50,233,128,123,211,114,120,13,93,139,163,139,3,181,186,162,34,117,0,49,65,20,63,144,46,185,43,88,235,151,254,137,107,129,245,157,252,25,166,229,9,189,68,128,231,202,231,69,149,237,72,189,141,52,130,17,77,1,208,244,139,126,91,200,109,121,200,103,53,6,204,120,211,55,197,153,114,121,182,41,128,252,242,61,98,53,250,171,145,122,58,245,45,50,51,46,37,248,142,50,91,140,3,188,25,55,234,28,135,180,126,127,37,109,140,176,218,25,35,109,252,56,175,129,190,99,89,160,241,16,85,102,229,30,166,16,107,74,244,101,5,158,147,238,243,94,171,21,87,86,113,10,101,13,6,19,238,87,19,193,38,201,50,90,192,217,166,173,239,105,18,192,54,50,31,162,234,5,104,171,95,195,236,97,145,74,246,58,37,92,27,127,163,255,132,188,66,223,211,37,125,18,78,242,162,35,244,127,175,67,254,130,68,147,112,9,101,153,195,70,158,81,118,155,188,0,66,213,207,128,86,201,230,135,114,251,85,212,33,176,167,52,7,88,49,21,198,150,199,123,160,232,235,238,182,120,251,84,66,195,216,83,86,3,46,94,245,95,37,10,214,4,48,11,190,21,61,133,47,31,106,196,248,163,89,151,32,173,235,42,82,243,52,52,0,118,175,66,234,93,218,138,128,105,247,115,36,62,155,200,203,202,89,226,185,121,61,153,180,103,232,146,40,96,82,244,218,149,172,120,169,198,107,45,221,61,201,37,50,232,185,10,157,155,37,117,14,80,65,45,92,182,253,70,172,234,55,134,80,46,121,46,67,142,131,11,29,1,13,95,128,127,88,104,123,187,154,108,234,29,188,81,128,214,241,14,65,0,76,195,96,74,182,174,157,158,217,68,44,156,173,36,174,8,186,6,5,0,87,241,211,43,239,134,106,168,222,144,117,31,41,118,61,45,27,108,24,53,77,123,176,203,146,93,160,150,124,16,126,251,34,79,123,196,189,78,235,224,126,178,99,75,168,217,59,52,59,147,160,158,193,166,119,82,243,202,125,135,217,154,68,176,219,11,17,147,134,242,63,205,26,183,219,135,164,85,65,252,216,64,55,172,204,41,87,50,242,233,184,158,107,99,231,100,40,106,212,243,66,48,78,7,178,49,239,23,92,152,27,229,23,209,106,51,113,164,151,156,106,251,188,44,182,88,217,196,3,152,78,155,95,186,71,0,208,242,180,203,175,31,117,38,67,181,133,110,119,253,150,154,191,12,99,55,84,246,9,251,89,250,200,45,44,224,130,90,179,88,148,233,108,203,127,171,147,238,192,252,52,162,84,218,67,254,9,88,50,21,181,189,184,213,179,80,21,210,22,207,36,183,250,229,251,121,76,115,249,249,143,99,95,208,159,19,187,131,70,211,165,102,114,177,30,244,147,195,182,243,158,59,183,95,35,110,88,56,60,10,80,96,29,180,166,138,68,189,38,110,229,124,180,98,82,22,74,129,144,87,134,63,164,144,213,161,6,11,5,163,168,80,185,143,75,246,24,27,10,28,113,59,96,7,173,191,139,88,205,66,133,64,231,158,220,236,248,108,195,107,51,19,41,13,13,253,206,38,81,135,91,78,194,203,233,180,224,216,119,242,188,241,157,45,86,78,100,124,153,153,144,130,156,225,181,115,139,211,96,200,30,125,101,179,46,159,218,253,11,1,53,1,84,49,141,71,116,122,254,196,216,27,66,33,179,54,202,128,93,102,207,133,24,48,111,185,25,47,14,67,0,90,82,94,110,171,51,170,205,118,67,33,71,195,56,234,175,87,120,162,11,57,69,60,70,58,104,209,84,233,62,104,117,225,254,87,42,229,10,193,36,221,193,189,136,164,106,112,234,130,84,33,178,242,155,173,55,8,148,134,78,95,82,216,216,114,63,215,229,44,182,255,40,133,212,46,175,212,171,56,245,247,174,102,212,114,110,176,209,35,210,101,176,73,23,15,3,104,70,212,119,157,145,190,193,108,111,31,197,249,173,11,7,245,5,30,29,137,9,23,22,116,71,8,42,20,16,233,229,218,54,191,62,158,141,170,99,216,121,218,3,31,230,154,134,50,113,170,176,189,78,174,158,155,83,216,74,212,9,148,228,15,193,4,104,181,228,236,253,165,34,69,62,92,34,141,146,50,137,57,77,104,166,135,25,189,12,51,24,253,54,156,110,30,170,178,209,151,108,137,57,165,104,54,117,183,187,191,211,214,102,243,12,144,179,238,138,130,34,222,172,189,0,211,253,83,77,161,23,71,2,110,18,35,135,210,191,16,113,193,96,9,114,165,65,252,97,183,177,137,229,6,230,160,200,28,47,255,53,41,165,222,162,95,124,100,104,146,77,16,231,23,174,171,51,83,174,175,0,32,35,53,201,204,109,203,169,42,207,142,183,166,224,72,123,75,90,184,85,106,174,237,26,213,85,7,68,10,54,191,26,123,41,155,23,128,113,154,228,102,114,241,118,94,0,92,134,95,122,91,151,134,110,36,249,191,57,216,201,201,86,90,184,97,156,230,214,21,200,84,192,222,80,72,152,57,226,215,51,193,125,131,96,72,145,166,221,15,167,225,226,227,28,176,17,60,137,253,73,131,183,198,121,75,97,250,49,99,38,145,220,103,165,54,124,66,156,165,49,249,20,132,184,5,17,54,194,22,221,118,220,245,205,80,26,102,181,34,142,53,188,53,122,116,113,113,232,174,228,134,145,8,157,68,164,13,79,166,73,96,137,195,149,186,21,186,22,50,153,180,55,63,244,216,168,95,85,63,253,168,163,191,159,235,28,36,47,238,214,41,101,21,41,176,241,132,162,146,189,87,27,248,17,14,248,238,71,247,106,82,204,35,58,239,212,149,233,46,37,52,237,197,159,68,144,111,34,87,141,56,47,14,112,101,205,166,171,118,254,215,85,207,37,234,40,76,135,49,6,178,78,194,228,225,17,122,189,180,217,69,115,125,82,79,134,6,29,32,157,218,105,207,100,171,109,133,10,135,9,242,117,18,59,31,134,16,84,4,126,120,26,168,145,228,247,106,81,146,145,45,91,188,249,140,238,173,125,121,33,243,181,30,254,33,168,61,226,178,251,196,55,42,222,0,0,3,13,48,201,123,166,5,205,66,240,73,15,60,79,234,39,64,131,29,8,66,66,111,97,27,205,169,252,196,202,214,232,176,134,93,19,174,26,87,159,88,139,245,79,199,230,16,238,6,94,38,13,138,144,124,188,243,103,104,23,200,66,68,131,11,203,123,54,41,218,70,122,52,180,72,237,119,17,113,230,173,150,203,123,125,160,20,192,98,52,141,63,38,9,44,134,80,251,51,182,123,234,203,172,231,222,223,107,218,39,122,91,73,107,93,230,209,203,65,24,249,107,238,158,36,71,93,113,16,129,40,34,90,183,112,211,26,116,160,172,16,160,190,225,129,6,186,106,32,107,216,178,138,172,123,198,22,129,21,208,179,193,245,141,248,225,172,24,49,24,19,104,122,164,104,181,93,240,101,218,163,212,22,243,151,175,155,22,85,225,76,93,121,190,179,166,173,160,196,250,4,13,207,206,213,29,117,150,182,207,80,137,254,107,28,147,74,225,92,206,102,22,131,253,45,167,61,171,88,231,212,65,80,132,17,194,160,57,167,37,98,59,121,34,36,197,46,42,219,232,97,99,155,227,186,201,24,144,160,228,217,10,16,0,106,242,25,101,64,71,148,81,34,133,47,15,202,201,154,17,215,206,15,155,75,55,89,150,42,214,142,222,132,196,37,241,197,203,223,91,27,76,204,175,2,119,147,255,81,244,171,111,228,223,196,93,62,219,108,70,0,22,225,184,254,111,194,60,153,148,219,239,25,146,184,36,68,81,103,83,36,76,209,218,172,67,44,33,197,211,213,174,23,21,52,134,110,142,97,99,20,104,124,166,196,42,79,1,149,46,170,253,48,255,59,137,110,161,52,85,27,33,215,208,153,145,14,67,200,228,151,52,40,230,0,140,65,168,8,57,121,174,34,72,1,174,249,116,216,149,73,162,64,13,201,38,128,235,44,2,250,196,22,43,95,236,118,127,12,54,180,26,21,33,2,111,68,83,14,80,33,128,188,162,254,1,100,185,90,224,144,223,109,53,1,247,21,165,118,24,133,181,123,204,235,213,31,95,152,24,48,36,184,35,107,199,204,83,114,121,217,19,246,15,105,234,64,164,119,109,70,226,44,215,169,154,132,48,155,84,29,228,208,72,252,92,108,134,150,133,212,135,192,123,21,106,220,127,93,229,162,197,56,62,131,26,171,26,60,246,111,200,255,148,164,2,237,124,15,44,84,194,3,232,235,206,182,75,233,55,205,13,192,68,142,77,126,77,112,230,67,68,206,244,123,174,216,87,63,218,167,241,204,229,228,242,161,120,239,94,134,30,13,164,28,21,77,168,113,37,137,105,55,2,194,110,94,221,132,86,149,55,34,205,2,119,146,0,222,132,46,50,154,69,230,23,51,218,157,196,102,54,153,62,194,60,178,148,52,162,202,71,253,107,20,7,8,207,181,229,222,89,170,233,102,35,93,215,73,196,156,187,85,183,19,91,91,38,150,128,22,115,44,129,6,132,27,234,180,165,64,50,133,49,101,234,37,224,150,98,227,210,214,30,89,189,41,35,246,148,117,222,21,119,119,251,238,36,74,79,151,79,210,83,72,21,29,59,245,178,103,59,243,252,113,248,26,52,180,129,12,117,27,129,200,125,214,77,94,37,246,167,99,240,115,237,209,3,63,68,175,141,35,208,71,120,3,214,163,227,145,186,12,14,7,62,242,6,44,101,188,245,55,129,58,161,96,61,178,29,140,156,197,76,109,18,43,196,92,102,27,21,19,30,216,76,17,26,65,87,207,233,146,142,84,92,115,7,190,193,99,166,204,106,190,105,111,222,233,230,248,157,185,142,211,247,72,75,116,117,39,233,221,245,207,151,65,183,128,210,40,241,35,91,42,5,12,27,82,27,106,174,41,118,249,126,145,202,2,127,226,100,95,19,25,128,55,236,111,192,162,215,253,60,49,35,42,27,198,199,12,117,100,84,104,50,23,240,69,212,3,45,255,251,46,6,32,22,138,167,190,220,158,155,113,142,14,125,124,240,163,104,150,201,136,63,202,145,123,61,177,94,198,19,234,163,170,92,62,74,123,124,194,219,209,245,112,201,56,95,137,17,79,214,218,248,157,44,72,7,211,230,129,7,206,191,86,81,57,125,225,67,245,124,120,27,34,33,123,171,4,223,119,79,143,89,126,35,88,94,23,90,105,38,231,74,12,178,78,168,247,171,162,162,43,73,41,145,88,95,67,219,133,131,67,23,168,75,9,45,29,145,9,32,217,158,114,70,64,162,240,131,134,181,177,30,181,210,174,4,129,239,217,57,34,132,106,228,7,40,89,199,136,246,131,232,89,117,4,235,121,178,192,58,179,163,57,144,33,220,85,115,243,102,175,220,85,114,192,17,18,190,121,32,55,104,246,30,90,120,42,69,96,45,153,4,104,50,110,254,148,157,178,219,254,36,60,223,113,183,50,87,142,194,129,206,43,119,240,155,63,37,169,247,1,139,166,86,56,253,107,11,91,193,248,150,86,66,87,162,29,149,251,93,168,203,148,211,220,30,236,252,238,185,44,94,182,192,69,24,142,61,237,40,69,188,210,203,165,198,199,168,95,102,25,170,208,50,16,130,103,156,226,239,77,156,195,203,230,174,34,12,115,203,152,118,184,27,115,57,159,241,69,42,168,166,178,219,34,21,44,241,199,224,232,184,120,145,39,253,9,136,39,21,28,118,87,47,100,198,254,68,187,69,43,168,59,122,246,116,143,153,126,254,195,27,163,38,191,73,96,213,125,72,211,244,140,106,251,153,220,17,120,237,85,39,28,99,107,98,115,183,139,243,172,125,185,160,78,244,7,71,233,192,15,203,16,71,88,117,144,142,82,218,208,44,168,131,236,73,108,236,165,97,50,176,46,219,77,167,64,231,123,74,215,52,22,191,237,84,187,162,248,205,115,247,134,179,222,7,144,172,233,199,39,119,231,125,78,117,181,22,254,180,163,130,15,192,254,161,91,3,62,25,195,1,159,215,158,19,178,222,142,166,179,92,170,130,45,27,41,142,238,127,254,65,68,27,131,247,28,1,111,169,151,12,103,205,53,101,176,104,101,145,32,96,155,51,146,64,254,17,173,232,228,106,153,84,43,238,26,198,50,206,238,28,67,6,121,151,234,178,186,136,91,205,224,214,4,114,177,48,171,199,99,29,87,31,60,168,248,40,70,255,102,211,183,195,76,90,40,69,27,188,250,5,107,60,134,135,209,162,209,206,46,31,96,4,229,5,139,143,190,94,135,208,168,111,29,140,26,48,220,127,157,36,138,192,126,3,54,41,104,139,228,32,65,98,117,113,88,211,225,231,227,197,69,97,22,163,77,51,44,218,53,239,76,204,204,183,6,156,103,136,152,109,148,251,69,11,223,118,50,115,42,62,76,164,238,234,171,27,55,214,131,162,14,7,207,120,134,186,33,246,153,176,9,130,107,31,60,72,167,220,116,147,54,1,16,163,40,86,195,52,160,250,48,155,14,61,95,36,50,143,137,209,141,235,198,190,112,36,245,216,100,194,49,168,244,25,35,56,152,167,143,9,32,161,176,177,179,33,138,25,209,120,254,20,180,144,246,212,217,135,246,65,243,134,75,62,114,40,247,98,95,50,28,113,97,225,201,230,69,248,180,109,171,250,173,141,230,247,105,238,233,167,144,79,92,163,137,238,16,67,157,25,7,199,20,59,2,37,32,218,86,213,160,16,58,173,28,100,222,26,158,66,234,226,144,242,136,41,246,116,254,87,108,158,234,0,253,31,92,125,49,194,148,208,239,221,50,67,202,76,220,155,224,98,78,105,188,158,191,72,131,187,208,207,219,104,46,240,167,94,117,43,187,36,243,0,16,253,202,5,0,35,111,21,146,36,164,105,102,201,6,196,109,54,81,179,143,141,218,11,68,176,220,209,130,204,64,175,186,37,183,11,249,180,223,150,42,68,49,153,149,239,219,55,118,85,152,95,221,197,77,67,255,205,248,2,108,248,110,62,6,189,145,80,183,62,236,93,80,120,169,249,81,118,129,22,7,210,177,211,52,175,190,196,45,142,138,174,13,132,11,188,122,80,214,203,239,121,147,126,196,103,185,17,215,177,208,171,254,185,175,167,200,160,18,202,161,0,60,214,85,59,176,183,40,242,61,197,138,164,244,84,22,103,71,163,31,70,240,0,151,164,161,86,134,27,141,54,163,42,15,58,42,76,54,243,205,140,67,237,29,6,169,64,81,245,46,138,84,204,208,35,250,131,156,150,145,3,100,28,84,108,162,229,114,54,49,182,98,215,204,179,187,222,171,95,167,133,224,79,251,69,31,60,66,35,94,188,21,170,37,36,39,210,70,93,75,4,91,47,121,191,213,149,57,22,146,126,180,131,148,28,56,215,18,52,195,225,41,115,160,37,95,115,102,50,206,162,91,2,167,137,122,165,18,111,134,114,83,81,150,140,210,140,203,18,63,126,32,27,102,190,85,83,174,124,172,209,154,54,241,75,229,123,122,103,248,91,190,1,50,199,93,174,48,135,236,234,117,59,221,234,30,196,228,55,50,111,234,3,66,70,26,117,160,207,7,120,154,127,93,180,22,18,224,87,209,188,202,54,207,254,241,18,92,104,124,248,93,185,103,161,30,71,165,148,136,179,246,74,0,87,73,89,62,199,213,89,97,41,39,135,108,127,231,31,220,44,243,217,160,171,59,230,88,193,111,252,19,21,101,161,200,8,45,10,246,61,201,82,6,171,71,240,235,42,161,133,30,101,166,99,53,37,236,210,192,21,81,115,240,38,18,117,87,187,29,132,239,18,60,74,186,194,185,170,106,253,100,32,230,51,242,34,82,253,167,55,100,34,72,71,167,36,221,94,130,218,107,213,186,119,40,31,169,28,252,82,134,168,209,185,152,204,187,191,85,5,114,101,87,72,199,166,128,177,198,125,219,141,105,89,48,85,129,255,64,120,10,111,144,149,32,188,109,150,29,75,124,204,15,109,71,16,231,46,174,115,165,78,45,45,47,171,249,79,255,37,242,154,21,203,59,62,198,113,17,91,7,150,182,211,254,160,224,15,101,145,28,140,150,185,97,254,55,153,67,79,141,78,67,220,194,114,63,58,200,235,37,226,113,175,140,6,54,11,206,135,205,214,157,141,158,105,3,225,61,22,189,244,40,134,214,178,45,194,243,53,166,185,6,50,40,97,171,3,79,54,91,45,134,32,226,134,48,65,150,76,44,70,7,100,80,178,178,214,6,244,124,222,207,11,10,26,69,147,241,188,114,76,193,163,70,191,0,161,195,150,57,219,84,142,151,236,141,178,190,193,62,28,187,204,244,109,199,185,101,239,2,166,121,30,153,208,20,94,105,129,129,44,32,146,77,218,72,165,176,39,225,7,64,167,229,49,169,163,144,187,23,92,15,164,35,157,31,111,178,56,97,53,123,110,199,142,220,33,170,70,127,147,140,202,110,68,243,8,227,111,9,179,4,40,24,241,156,195,103,205,132,189,74,174,116,163,30,39,31,138,57,93,47,113,124,18,191,204,186,208,89,105,178,30,249,221,60,43,50,159,225,110,33,170,95,225,23,106,201,174,32,77,64,98,49,69,86,143,81,102,225,130,61,225,5,237,220,51,245,183,201,45,217,65,107,28,12,200,120,49,79,248,56,220,122,45,220,32,136,129,208,70,84,204,44,8,1,3,173,124,27,40,150,180,166,237,15,95,232,124,172,178,55,21,98,40,7,228,222,109,97,203,73,3,97,174,226,41,120,164,90,197,194,52,166,171,146,205,98,194,177,129,25,121,201,234,249,245,31,66,127,34,88,237,80,145,241,186,38,161,35,45,16,11,212,247,106,245,154,196,219,218,253,110,101,248,75,52,130,159,43,87,3,169,0,153,131,199,19,36,65,61,160,223,174,158,164,66,172,77,227,231,17,182,61,173,1,189,134,161,232,217,215,204,234,25,174,206,232,152,44,54,164,11,66,101,242,181,89,253,197,45,244,89,66,103,33,189,183,226,144,20,202,38,254,6,46,155,22,41,117,239,193,127,118,67,46,71,169,80,140,51,66,235,148,159,17,169,123,245,114,13,38,176,241,149,55,250,210,167,80,36,97,20,20,21,179,238,40,104,36,144,79,217,29,102,186,173,10,229,0,51,58,2,195,135,46,85,121,178,125,62,244,82,196,189,51,88,44,213,61,151,112,255,175,107,144,129,142,128,227,162,12,38,181,85,93,249,74,139,94,221,15,137,54,12,39,174,168,225,195,177,184,57,223,157,229,113,112,205,10,128,139,115,74,0,189,190,62,99,60,253,218,237,32,172,221,48,141,41,116,135,77,148,21,57,183,241,74,175,130,109,11,225,122,207,207,237,61,59,139,191,237,68,5,28,28,190,247,208,170,91,158,132,134,19,224,44,159,170,138,235,6,200,6,209,8,226,19,9,186,133,148,18,226,199,71,162,128,222,102,148,161,81,100,201,39,26,220,130,157,127,25,173,182,217,113,216,225,63,180,171,14,91,102,35,101,133,159,92,184,161,197,217,93,241,36,253,66,113,2,193,176,91,108,225,227,132,35,168,1,231,88,207,207,142,108,109,60,85,234,142,193,98,255,128,85,35,70,213,233,195,215,182,254,202,226,163,125,47,132,125,182,39,10,105,216,98,107,2,40,91,85,73,87,29,242,79,118,231,95,152,207,255,73,133,86,158,58,197,245,69,93,36,30,101,23,156,144,171,129,221,40,80,238,13,241,244,64,117,205,30,129,230,177,119,43,245,180,132,186,51,19,88,234,218,231,213,252,160,20,182,190,251,56,3,135,243,255,184,246,179,210,204,166,139,112,4,186,65,216,211,31,133,154,119,37,150,164,73,111,168,175,184,236,62,34,120,126,85,67,181,95,71,187,111,245,4,159,122,25,62,254,147,72,215,4,155,237,242,195,102,91,126,83,83,236,6,156,14,208,169,160,46,190,103,219,141,235,145,119,213,155,208,167,177,161,206,151,41,112,98,145,192,236,202,30,217,1,156,28,123,183,86,149,67,95,131,222,157,165,253,208,50,186,109,110,37,208,94,113,34,134,234,243,178,151,196,60,58,52,239,36,250,27,29,134,180,155,56,112,204,203,97,247,240,117,112,151,217,138,198,253,167,201,235,197,16,29,19,171,221,185,153,122,22,219,211,177,115,55,136,234,222,239,69,159,168,116,45,69,213,143,252,43,74,201,101,5,229,36,207,214,65,115,28,159,139,160,41,43,144,213,39,43,185,239,94,115,164,12,116,81,30,148,163,193,49,195,204,194,107,231,19,159,155,253,128,106,135,40,107,81,190,65,250,137,239,115,2,182,124,67,225,232,121,91,57,146,28,12,61,106,233,41,1,236,106,150,22,92,81,4,124,118,40,33,43,196,19,148,185,255,183,126,159,240,88,166,241,3,51,93,74,115,43,210,206,108,148,104,180,180,245,135,50,216,222,90,78,79,224,49,236,252,93,61,113,192,43,86,159,67,112,62,81,31,102,117,213,37,158,121,163,106,113,241,163,166,166,230,118,89,198,220,55,200,198,87,172,62,80,176,19,37,96,19,123,210,208,153,198,83,237,114,248,147,251,46,166,35,166,240,147,173,216,221,116,156,37,140,214,206,140,239,183,198,230,244,24,248,20,195,249,253,68,52,85,91,119,229,4,233,65,69,44,1,255,216,220,135,144,238,78,136,85,144,229,21,239,9,107,51,207,61,133,94,183,32,122,245,179,35,122,20,172,89,6,37,186,159,178,240,202,206,117,79,217,206,215,70,24,182,109,214,91,248,24,115,7,101,107,55,73,106,141,39,137,44,123,17,187,11,239,184,89,121,222,113,171,228,54,133,88,132,41,69,38,92,140,138,18,185,115,144,244,45,42,185,146,36,79,195,104,164,240,118,126,168,151,180,93,35,191,131,30,128,210,77,175,190,120,45,132,217,55,186,211,158,23,134,253,132,89,32,53,45,94,185,202,28,181,155,57,187,177,215,153,92,145,200,133,119,103,65,253,203,237,225,200,85,252,51,193,109,8,177,165,112,3,81,245,79,124,195,242,235,198,236,129,28,73,126,151,214,12,106,209,253,141,20,189,95,115,158,146,79,137,114,217,222,24,16,101,134,211,141,143,190,20,221,160,106,3,162,117,145,77,183,79,7,208,86,71,96,189,42,89,193,246,50,193,210,81,83,251,182,20,30,65,46,247,40,8,45,147,86,225,97,109,48,246,196,190,108,43,183,144,65,192,124,193,113,174,175,74,227,176,198,39,17,212,10,166,27,208,235,128,81,235,180,254,33,237,88,72,227,181,231,253,124,57,86,139,159,47,92,64,75,130,76,19,5,168,67,109,206,185,21,19,157,146,132,63,9,64,10,127,126,72,15,252,131,79,140,93,81,94,168,41,111,143,252,136,73,192,35,192,222,27,140,105,109,116,89,158,44,184,139,211,102,156,223,96,81,229,178,10,76,233,67,237,30,125,242,121,158,118,24,253,193,149,82,89,12,167,141,77,125,122,1,142,216,67,194,172,37,99,160,72,252,192,42,83,140,12,135,90,113,110,255,159,210,199,208,251,39,175,54,35,156,53,183,224,186,220,192,19,115,211,21,238,61,163,87,98,60,92,96,163,195,28,39,227,112,117,255,88,136,235,24,108,31,16,189,154,52,151,109,161,101,239,112,19,80,40,210,207,51,245,232,133,202,92,73,49,104,180,89,50,165,200,215,106,27,230,157,222,255,135,222,100,135,58,45,110,164,165,36,120,52,110,224,188,24,7,77,227,142,111,17,207,183,145,193,31,38,145,99,141,62,203,24,120,126,35,205,1,160,44,126,215,2,206,104,171,244,154,121,62,115,181,139,241,6,99,52,49,46,176,69,90,73,22,214,98,227,32,204,3,10,205,112,25,134,158,177,223,183,48,137,68,138,171,245,115,225,216,9,10,60,126,240,181,11,89,49,144,59,160,22,240,16,14,20,213,92,64,14,211,54,118,64,50,58,6,154,195,237,62,242,147,118,35,52,163,139,69,30,188,82,78,141,187,123,171,137,65,190,22,162,110,55,202,34,95,249,161,199,43,210,251,196,9,69,2,243,234,84,63,123,236,24,203,105,251,150,28,35,209,212,78,119,37,168,169,72,183,102,64,212,10,247,144,147,211,28,14,233,197,206,186,209,11,45,248,5,41,230,226,182,60,108,58,109,210,25,84,21,91,123,234,182,181,123,149,9,107,250,203,103,20,120,112,63,226,237,11,52,229,254,237,76,8,220,23,240,61,13,68,52,160,184,236,15,135,35,42,10,251,120,10,165,144,189,142,85,220,251,74,29,89,243,154,115,52,91,232,18,50,234,226,140,108,28,157,40,41,95,218,96,238,120,20,78,71,210,60,170,180,20,238,220,223,206,154,36,227,188,27,32,39,62,53,110,177,157,10,156,213,62,250,194,34,11,95,221,127,71,96,236,13,157,251,90,255,91,170,81,107,217,42,2,5,214,66,47,48,180,13,217,222,36,141,118,20,89,229,113,137,134,221,125,132,81,15,182,248,115,30,82,220,108,47,117,79,210,209,46,19,83,102,159,52,121,199,189,15,47,236,51,242,57,61,108,172,175,20,81,86,159,13,14,100,218,46,207,180,47,184,90,33,61,86,104,80,212,191,51,75,187,211,240,83,134,137,174,139,30,53,215,224,41,157,213,94,11,21,121,8,116,124,16,79,64,97,62,144,20,58,86,10,176,114,141,15,180,7,61,38,81,19,64,172,221,238,0,147,199,163,245,85,150,137,98,222,171,97,64,147,235,141,205,36,7,174,48,103,98,184,57,12,174,229,58,1,77,162,189,222,7,138,174,73,176,129,120,110,190,203,136,74,35,78,13,129,167,151,31,162,172,113,227,89,240,131,94,6,90,151,182,89,126,184,201,63,171,112,86,118,189,137,154,147,192,26,139,184,16,197,74,231,127,148,169,250,206,16,193,187,166,220,176,75,254,213,105,105,251,35,234,125,119,228,131,58,185,148,105,35,251,168,162,212,251,105,179,70,24,159,119,11,201,83,117,108,184,114,224,251,71,197,114,118,50,77,26,18,109,8,193,191,22,243,8,117,228,7,96,205,42,236,187,3,81,60,148,157,1,213,55,183,105,72,12,69,26,6,73,209,129,127,7,123,51,55,58,114,58,177,107,79,215,229,254,157,54,60,41,106,124,47,30,30,215,191,215,195,198,111,209,53,63,170,75,8,0,234,178,14,86,146,38,91,61,221,224,22,207,201,121,65,99,242,65,199,47,242,44,34,124,168,155,76,132,182,187,5,47,219,212,188,49,239,225,79,180,54,132,68,21,111,143,46,16,77,223,19,93,103,210,24,147,158,232,190,164,64,72,218,215,217,66,38,54,138,103,53,80,84,34,67,250,208,1,198,41,2,1,168,131,168,46,61,131,27,252,185,44,191,138,123,49,116,247,86,12,71,173,120,214,3,106,173,168,149,120,102,175,25,224,143,226,186,135,176,99,194,66,200,141,136,129,9,213,176,41,240,193,8,215,41,96,201,225,22,219,194,250,115,96,211,171,96,124,54,125,242,89,171,89,246,205,84,202,145,150,57,196,232,124,234,82,110,54,107,235,174,127,188,35,184,13,180,248,80,16,95,95,65,233,112,136,101,224,96,245,46,188,192,203,98,168,207,248,195,138,134,175,165,205,23,137,221,61,248,242,202,44,243,226,152,68,218,39,185,152,145,157,109,48,232,97,11,217,64,206,55,125,139,33,22,60,0,145,154,48,214,138,38,113,140,3,16,56,205,113,48,232,89,232,179,141,10,33,24,174,231,239,94,60,108,204,137,187,92,75,52,131,93,105,46,144,190,96,27,42,68,130,187,202,51,159,68,24,62,14,191,3,87,125,94,193,0,70,255,134,10,104,63,44,97,56,81,21,33,224,161,33,173,41,53,105,223,155,85,95,12,68,222,157,34,108,46,8,209,229,216,50,74,56,4,155,29,61,108,101,43,74,204,134,55,107,2,158,7,175,15,245,133,253,93,249,77,147,56,180,0,231,55,142,71,21,120,174,88,94,158,214,106,139,255,10,196,94,202,56,209,206,158,92,156,131,11,151,185,94,208,77,165,182,206,249,88,71,18,244,238,178,13,14,182,57,141,116,127,251,236,79,40,64,19,192,71,18,167,190,144,81,216,168,161,111,144,105,74,119,29,20,226,45,198,30,66,51,189,39,110,13,35,94,183,1,73,20,8,189,244,207,157,163,34,176,133,59,47,118,138,220,238,160,242,63,238,152,5,230,237,213,133,177,11,180,28,185,201,239,200,19,56,3,210,157,151,195,252,131,75,75,27,53,121,212,0,124,235,101,144,94,167,53,64,94,41,92,238,90,67,111,115,163,163,162,221,182,183,185,99,40,93,123,77,40,26,46,6,105,116,53,33,219,110,104,57,146,85,156,221,79,10,231,70,90,26,130,128,223,245,193,209,233,76,125,241,47,128,113,75,184,178,208,2,114,115,192,172,54,70,151,112,129,37,36,72,57,116,254,32,102,246,66,228,83,1,170,166,83,52,70,249,170,245,78,230,11,231,201,168,63,71,77,1,204,52,236,96,53,251,206,106,129,19,210,12,66,231,114,106,63,17,131,185,255,46,158,19,33,50,48,101,172,85,179,88,36,209,18,91,19,111,124,162,160,134,238,219,12,167,65,13,131,55,135,83,95,234,66,223,168,69,0,231,241,24,200,222,91,140,187,60,117,55,235,168,169,242,158,189,87,104,13,48,8,232,105,52,192,117,169,13,49,137,204,128,185,176,74,126,64,33,246,61,143,198,212,189,126,96,40,227,197,52,225,131,54,112,1,206,137,71,78,252,220,51,162,29,235,226,175,40,245,222,232,254,140,247,192,94,105,205,196,196,81,184,201,251,73,219,85,105,214,14,175,101,34,99,67,149,1,41,42,42,244,123,102,91,217,246,217,239,12,125,131,215,90,163,112,7,83,152,219,83,109,64,92,94,60,153,167,154,22,202,42,67,184,36,159,218,36,201,202,167,16,230,225,121,114,227,67,107,39,192,83,32,237,9,104,9,110,245,60,143,241,169,12,224,93,193,199,34,187,87,226,229,161,180,255,186,124,42,139,90,193,222,143,235,175,6,26,23,227,120,237,28,53,234,34,19,20,45,149,233,69,92,30,15,182,56,214,239,244,180,40,29,210,137,233,240,29,249,41,88,169,87,53,81,84,106,64,80,0,203,121,220,27,89,43,79,135,166,82,95,29,59,218,26,12,33,223,167,69,240,166,91,197,163,226,2,0,106,91,13,86,102,208,71,26,49,103,24,29,173,135,208,189,210,183,142,192,22,199,61,49,141,158,49,187,221,189,189,169,185,48,62,8,136,135,167,100,60,10,195,236,211,16,1,45,103,220,236,107,15,167,24,128,94,237,55,61,179,180,240,3,60,221,73,251,156,37,67,112,160,252,50,127,20,140,163,102,10,72,75,70,177,224,190,169,74,104,197,165,13,228,39,130,224,194,249,119,209,91,159,50,204,103,220,232,61,62,237,7,2,152,20,106,38,154,128,30,209,206,195,132,104,211,178,101,62,111,167,50,236,82,9,54,122,71,249,163,169,1,205,145,99,172,54,57,90,98,156,184,13,228,13,1,115,247,226,142,252,75,129,156,137,248,104,211,128,142,246,53,145,100,33,208,198,208,225,186,242,166,250,167,146,200,142,250,84,45,166,191,4,146,90,215,125,130,187,223,28,168,155,200,171,204,90,157,232,155,192,185,121,97,241,59,159,7,86,232,39,245,91,115,10,178,22,158,246,132,21,95,70,252,65,207,213,24,154,98,228,94,109,67,70,50,102,154,169,60,70,139,46,29,145,41,150,97,158,50,67,187,235,156,229,237,203,142,161,87,142,239,238,51,151,86,235,42,203,84,2,102,133,201,246,161,135,116,130,145,214,196,2,8,127,71,118,61,190,149,8,231,146,18,38,222,58,67,56,30,71,186,9,226,134,37,12,76,75,88,68,85,71,143,233,101,81,35,232,71,30,201,194,163,9,75,73,34,20,83,196,2,39,203,71,233,99,117,170,105,45,159,106,89,52,70,130,215,72,65,207,175,8,249,195,124,143,138,139,12,137,255,242,54,58,225,214,241,39,55,104,77,227,144,107,143,222,72,131,121,8,59,95,160,76,220,139,137,176,91,239,255,53,109,232,194,200,113,63,138,226,104,82,166,64,93,121,102,116,203,135,13,143,47,25,209,179,76,243,166,226,33,38,22,218,110,223,114,197,189,145,124,46,254,53,220,69,144,24,86,100,7,141,190,83,199,9,48,213,49,70,203,102,7,84,182,145,117,48,6,185,121,58,241,231,136,86,50,36,32,248,122,31,103,52,51,227,41,49,77,137,107,79,28,148,23,31,72,110,31,143,194,212,48,82,163,232,16,94,82,153,202,42,219,121,7,28,73,136,189,202,36,52,26,194,217,85,103,70,62,15,106,106,131,143,42,51,227,122,187,98,40,251,81,103,132,52,182,125,112,182,159,16,38,111,107,185,207,84,131,31,175,225,24,104,216,12,112,16,112,246,144,177,162,192,240,83,22,210,106,119,136,89,168,107,249,123,204,113,225,106,56,3,223,79,235,211,164,11,226,232,178,154,164,56,69,49,230,219,192,140,46,165,95,32,46,206,57,14,114,105,191,137,122,18,214,209,7,222,147,166,206,60,117,149,104,125,136,244,93,12,73,89,214,171,131,158,219,183,250,7,234,53,229,7,144,7,207,230,103,203,39,40,6,242,115,149,121,14,84,172,9,112,121,232,62,170,96,97,18,49,40,244,178,66,13,14,120,87,51,196,245,211,31,177,219,164,143,249,134,153,95,172,145,199,60,63,222,106,241,86,149,178,108,90,96,214,162,177,24,32,8,149,186,125,35,116,13,137,20,190,14,142,127,31,159,209,180,238,188,68,18,104,230,16,63,209,30,46,124,164,97,179,62,233,58,6,243,23,189,213,108,14,32,85,129,32,53,244,151,54,46,32,195,135,144,42,100,249,158,212,255,105,255,95,99,215,69,32,66,116,96,173,229,42,219,112,158,213,208,180,214,61,122,194,179,215,72,108,206,73,97,175,162,179,47,86,137,182,195,212,66,18,78,14,41,120,98,152,21,70,200,189,83,8,136,119,232,130,96,54,209,84,204,181,61,48,6,74,160,148,194,139,106,2,41,208,137,114,96,18,6,59,154,142,21,38,3,63,206,9,64,3,143,81,78,110,250,99,23,197,234,199,254,98,80,163,91,48,6,187,6,54,48,53,123,52,94,51,26,92,212,85,156,5,247,220,180,104,188,188,235,106,41,193,101,36,54,155,7,44,131,145,42,175,3,115,220,196,11,18,160,139,117,172,165,130,151,209,244,221,249,33,28,234,16,195,101,182,143,87,224,9,55,254,65,131,212,213,203,140,3,195,136,108,61,133,252,27,140,44,111,75,163,37,253,132,221,107,42,166,93,52,124,218,175,128,33,145,198,43,148,144,17,190,204,237,135,92,53,177,145,124,209,250,25,110,82,123,225,32,190,230,179,29,228,145,151,153,43,13,161,73,216,29,143,123,152,210,152,161,20,189,5,95,100,53,127,207,88,213,57,242,8,11,136,229,96,31,111,201,140,97,255,180,5,68,178,176,1,63,224,181,136,205,230,127,180,100,161,53,205,17,140,84,58,155,149,233,99,233,167,127,78,106,229,7,26,86,45,8,188,13,22,70,209,84,140,205,39,207,70,2,227,0,178,46,240,219,226,85,120,54,149,84,6,190,74,105,189,242,26,41,30,126,70,134,253,187,110,0,248,0,183,52,166,197,178,230,194,15,19,203,250,172,202,95,144,211,43,252,40,2,183,20,11,186,37,118,94,18,45,169,13,255,135,254,14,8,215,248,103,72,187,177,203,7,19,2,187,190,199,135,7,85,44,207,63,228,112,16,120,84,218,102,7,132,215,68,158,165,116,167,114,175,60,143,201,205,35,205,225,228,55,194,17,80,105,5,142,156,154,246,208,51,57,74,14,206,200,157,85,245,72,141,155,74,141,53,221,192,248,193,218,171,226,253,146,58,41,98,160,223,210,233,29,22,70,157,29,6,170,1,3,7,41,96,12,62,150,252,206,155,169,20,17,251,243,129,149,211,91,49,76,44,196,75,244,48,4,192,208,38,4,192,194,61,77,164,133,247,126,107,125,231,13,242,18,28,79,13,99,74,98,85,179,243,84,35,46,47,129,163,199,205,237,104,212,20,22,126,226,221,112,16,194,210,162,199,100,150,22,48,166,181,160,213,227,255,219,57,29,16,8,235,176,44,81,85,234,30,189,106,137,59,40,212,93,49,209,192,61,82,136,202,246,157,247,27,38,37,141,214,218,79,206,136,80,248,16,27,229,151,202,250,23,188,219,240,65,144,101,109,28,30,102,42,48,25,243,209,164,43,248,62,103,55,89,198,45,245,24,112,0,213,17,157,118,183,107,74,54,203,35,226,208,185,157,39,11,158,156,162,179,124,49,241,98,119,53,225,233,172,50,7,157,36,231,184,217,97,247,60,239,91,65,190,145,119,65,75,23,110,233,184,194,248,241,231,124,168,141,57,121,253,56,46,190,255,195,222,176,87,136,138,150,127,204,103,180,144,129,255,25,234,216,233,50,104,98,40,5,20,41,178,28,162,113,44,188,148,17,62,84,23,58,161,142,74,108,33,55,113,240,162,121,135,79,22,147,225,107,111,110,40,16,219,110,169,246,219,213,113,83,227,21,62,85,56,226,2,96,162,192,158,109,206,177,203,83,193,55,112,203,63,52,88,27,40,232,198,153,67,210,119,198,76,168,82,159,115,87,109,149,229,206,28,241,46,135,155,242,151,253,92,68,189,223,170,40,56,64,55,10,180,179,84,190,35,248,146,184,52,184,130,236,75,118,200,67,85,249,41,240,184,110,252,251,36,75,141,66,204,216,115,19,231,115,15,57,56,66,172,36,65,103,250,37,226,255,215,0,133,41,121,16,14,82,78,158,202,56,87,130,106,85,220,161,94,86,231,235,56,106,93,52,232,3,149,139,154,211,148,4,145,176,121,15,233,65,63,123,21,227,20,199,60,195,120,108,216,100,46,104,24,255,27,49,108,252,92,27,13,33,225,151,9,181,139,101,190,95,8,103,143,192,216,74,141,237,99,130,90,100,214,227,91,233,154,206,36,171,140,138,138,116,240,144,84,194,156,84,153,254,190,47,10,84,212,5,184,100,226,70,170,232,146,163,208,252,103,33,185,41,208,251,35,174,173,207,225,53,183,146,65,139,206,120,181,107,158,21,160,18,149,27,14,236,150,76,236,27,191,94,86,73,66,146,111,29,207,45,10,117,109,82,185,162,128,3,93,27,24,167,233,43,47,63,232,173,59,21,218,87,65,55,6,197,159,117,145,134,132,153,240,105,115,250,17,69,44,8,79,247,147,179,48,15,76,115,251,191,226,92,87,135,36,67,117,32,133,185,118,190,206,124,117,129,144,197,238,195,31,47,219,132,228,183,66,152,75,49,95,252,101,201,38,200,227,121,149,197,29,129,124,182,179,104,223,218,201,100,77,10,83,254,6,68,63,149,42,96,4,108,67,253,239,13,176,224,41,138,237,168,210,106,249,44,132,136,167,80,103,1,131,144,206,16,103,6,190,177,103,228,145,229,65,234,205,188,147,231,182,50,199,96,219,78,176,194,7,157,154,81,60,182,253,213,192,40,88,91,94,204,159,115,51,84,250,198,164,231,75,134,125,225,3,203,85,153,105,81,199,15,187,188,229,209,22,127,184,236,95,175,135,249,170,125,100,34,154,152,221,109,66,97,150,165,241,39,91,200,128,252,208,78,82,165,114,60,184,3,228,62,36,107,85,114,111,50,143,255,29,60,157,208,29,87,210,21,143,94,42,144,59,25,168,233,193,246,106,26,253,47,208,150,98,98,170,135,177,138,46,193,171,71,138,30,57,99,109,99,106,36,42,8,233,252,201,239,223,178,223,151,32,221,134,78,129,95,47,99,13,106,27,107,114,174,208,193,246,192,224,9,131,221,238,40,34,156,141,174,69,24,109,37,114,205,218,215,69,204,183,192,150,165,53,38,43,105,63,193,22,152,65,72,217,188,89,131,229,176,105,117,21,35,243,93,114,180,8,185,31,114,93,117,217,50,243,218,158,73,173,140,211,147,158,67,80,61,219,3,52,251,35,83,100,178,43,135,107,140,76,120,60,23,255,100,23,81,42,204,237,178,123,92,146,198,73,68,61,252,186,56,102,186,157,245,84,178,132,154,1,123,141,101,75,15,247,54,46,156,31,229,172,190,103,120,161,43,73,116,156,228,170,173,85,46,151,90,69,177,255,212,231,144,23,19,53,44,66,78,166,144,16,230,62,249,225,29,179,73,10,127,237,186,93,182,237,206,229,92,74,18,255,4,159,84,206,47,188,95,92,8,78,2,126,61,93,68,100,188,96,212,84,213,31,223,212,149,6,136,50,152,84,226,182,57,241,138,33,41,217,107,249,107,219,173,130,188,201,163,88,223,17,172,88,242,78,13,118,93,240,240,187,10,143,134,14,219,23,119,91,101,97,75,198,77,129,207,6,238,128,21,243,5,6,133,76,13,229,138,104,127,240,229,252,180,29,87,126,152,219,164,122,36,126,209,42,65,162,40,72,24,82,129,101,154,125,162,86,114,74,19,49,105,26,96,221,71,169,75,69,125,180,26,117,6,97,232,133,241,144,238,241,250,28,169,185,127,68,89,199,144,7,18,170,46,190,126,233,176,78,175,239,78,39,37,66,219,206,33,245,13,218,177,229,87,248,164,61,114,129,37,62,77,6,110,208,195,123,217,146,111,22,144,214,27,97,174,219,220,11,61,169,6,95,250,44,196,193,188,90,117,133,202,57,142,185,63,189,167,185,46,230,53,232,212,45,139,145,234,168,62,197,183,68,164,197,132,69,159,199,125,202,50,72,169,186,215,71,22,108,3,239,143,212,144,225,29,163,45,86,204,172,99,183,54,19,87,144,150,254,208,80,159,74,198,90,20,78,108,144,87,183,2,187,120,42,7,233,3,26,169,109,7,4,40,191,136,180,208,0,65,37,52,36,188,161,90,45,17,249,121,65,42,90,236,128,113,15,98,136,204,148,147,232,241,175,66,233,127,84,108,16,202,74,10,162,33,16,145,215,72,243,122,212,133,183,206,233,194,60,197,12,6,101,162,32,12,207,13,227,192,67,69,11,230,126,234,51,255,114,8,147,212,132,172,53,180,170,110,224,80,45,174,188,249,255,191,114,57,157,247,240,36,140,101,77,43,249,58,25,143,91,206,30,185,38,140,68,97,44,235,110,12,84,138,125,196,1,140,13,219,204,155,188,79,74,216,178,176,39,254,232,167,69,82,237,124,86,134,219,251,32,235,112,100,169,121,91,208,60,145,108,160,33,219,228,128,3,29,91,64,68,228,105,143,147,54,112,42,5,201,167,135,96,172,247,52,37,118,7,207,109,40,172,200,65,101,118,107,184,117,191,171,120,154,221,213,201,87,208,6,236,189,254,88,174,249,25,106,180,102,194,133,233,224,202,218,253,146,169,186,85,69,106,96,234,248,240,218,105,200,179,245,23,50,25,36,27,61,179,110,231,186,193,22,192,238,93,149,149,83,8,149,79,21,159,34,2,70,220,100,239,170,150,74,244,125,14,8,73,146,124,42,182,76,236,243,79,51,10,229,74,139,61,94,157,236,104,125,82,251,29,16,81,249,169,102,25,158,88,139,43,242,129,163,249,10,154,71,248,117,166,29,127,115,57,21,105,225,230,244,47,158,232,45,127,81,114,247,125,29,28,174,186,175,45,252,41,218,117,126,219,204,59,158,213,85,242,43,236,93,102,193,85,31,29,226,232,129,100,241,1,14,199,70,10,41,131,64,240,38,160,212,100,129,89,35,55,119,153,41,145,32,25,74,199,165,181,165,175,6,175,31,89,188,54,48,136,180,104,72,134,138,28,95,198,234,147,175,139,1,114,14,33,78,194,8,88,109,57,169,98,176,58,40,178,16,120,142,233,137,61,95,155,189,144,229,46,100,226,73,149,97,216,203,185,125,242,25,78,142,43,254,13,186,205,130,168,61,21,24,175,61,94,144,159,208,238,182,59,127,162,195,183,17,253,240,255,125,56,182,108,30,72,48,143,48,108,242,70,107,108,140,119,188,15,152,12,126,235,46,248,224,124,39,254,0,24,2,211,23,55,172,197,52,39,249,192,39,8,231,9,250,114,184,246,139,17,35,48,135,137,29,176,46,227,18,57,95,181,142,114,252,136,165,75,101,237,236,18,76,96,46,161,97,205,22,137,74,210,72,228,67,111,66,88,164,232,179,38,241,23,221,116,150,168,46,84,190,115,13,144,190,252,8,151,152,45,228,248,254,79,8,24,2,214,57,129,60,55,213,255,19,72,151,96,35,22,158,181,235,126,0,40,201,43,20,213,217,61,118,230,188,242,210,252,60,47,153,50,48,177,57,121,53,86,9,94,22,226,159,75,146,181,49,163,181,64,150,184,168,249,225,1,51,87,192,96,198,61,107,214,72,102,99,117,99,3,219,14,28,215,5,61,74,66,243,143,0,27,79,104,236,229,48,177,109,77,177,121,59,187,115,213,85,150,232,103,136,131,147,14,232,236,124,212,251,255,108,162,73,34,48,121,201,9,213,108,62,201,102,125,3,229,61,189,50,225,4,54,174,27,13,63,180,36,91,226,141,95,14,142,151,127,75,173,174,66,172,136,243,37,58,211,204,127,90,179,154,88,132,129,19,6,40,102,116,150,142,108,66,185,0,125,230,136,50,51,93,119,253,178,128,181,31,82,131,229,60,175,240,229,144,152,126,0,143,135,37,133,65,128,201,197,2,68,15,111,234,55,129,182,215,45,100,41,147,89,199,188,90,27,173,137,137,32,57,42,217,89,63,246,51,139,50,236,171,9,246,140,12,169,108,165,127,253,137,247,244,23,83,187,133,246,17,60,174,201,5,89,201,156,220,106,157,162,93,233,97,115,175,129,45,162,232,135,41,74,17,196,142,116,188,80,107,23,11,199,88,45,134,12,119,95,104,243,122,34,14,187,193,244,118,175,90,198,190,243,59,17,53,158,133,121,147,93,111,186,162,93,119,181,175,223,18,209,155,147,86,132,180,86,26,131,116,5,73,69,34,74,130,252,36,232,243,6,15,129,163,117,74,181,64,105,87,147,1,241,90,117,140,0,153,172,59,52,85,36,235,234,11,104,175,144,184,18,120,166,168,4,73,236,31,193,190,106,149,143,112,202,119,178,71,201,98,37,115,111,103,143,113,239,146,52,200,66,23,91,64,87,169,159,234,7,42,140,134,31,130,253,156,4,239,254,52,106,82,132,26,64,178,117,167,101,25,243,116,174,105,184,1,18,208,175,154,48,194,13,22,78,230,78,11,215,8,169,160,3,77,157,94,132,210,207,17,6,37,244,13,110,155,141,163,28,168,240,137,8,68,105,94,123,85,168,212,28,196,24,190,170,159,14,170,73,148,72,215,159,21,83,222,149,74,156,110,209,212,3,90,121,195,151,128,169,166,67,168,59,139,211,109,245,7,50,34,186,131,230,36,51,49,9,57,210,139,150,224,146,204,50,250,59,168,216,155,87,253,43,114,249,163,58,6,144,91,185,206,140,218,208,222,247,8,62,106,179,237,23,212,108,37,10,228,200,106,143,157,177,161,43,26,199,92,20,3,103,106,188,184,61,58,230,242,155,110,79,216,29,151,119,187,217,20,111,184,123,218,133,94,161,222,45,132,251,221,232,219,146,45,210,177,24,195,30,208,30,87,136,138,15,94,48,9,239,27,83,234,101,233,178,104,128,95,79,180,52,136,52,70,95,1,36,127,20,111,129,202,191,139,59,251,148,35,141,170,214,113,248,131,57,71,121,8,179,15,250,41,180,68,154,229,219,54,54,119,26,238,248,222,152,47,246,212,185,155,136,114,110,9,49,179,255,14,84,72,19,99,151,5,49,189,25,206,176,15,35,204,70,17,220,206,138,233,186,139,139,76,172,235,91,14,24,236,171,144,74,225,133,93,215,162,195,249,219,146,70,185,249,80,35,1,185,179,128,31,4,104,40,199,154,210,140,137,58,210,73,181,64,81,28,46,91,105,53,37,118,161,113,119,24,22,189,117,176,140,189,44,125,207,137,56,28,194,30,178,153,147,130,218,203,129,237,66,100,139,70,74,168,4,182,45,59,138,39,61,254,106,219,198,120,96,122,191,254,131,39,181,201,213,222,214,192,51,182,206,6,225,26,244,180,66,220,252,222,35,100,49,10,198,110,174,208,70,154,78,107,100,244,135,107,109,226,63,121,46,252,199,64,249,214,161,59,8,222,230,232,229,251,156,5,211,147,93,42,187,87,52,107,84,194,61,51,242,84,71,198,231,119,114,54,33,176,246,246,149,173,86,50,64,236,12,30,12,250,49,3,247,131,255,138,179,167,192,42,92,88,106,249,243,165,90,144,45,161,37,219,27,52,127,183,223,145,68,208,88,102,20,201,246,19,66,173,111,242,238,194,4,218,127,100,13,22,223,186,203,172,208,246,66,198,0,151,144,179,1,167,35,26,47,158,123,237,201,231,115,125,12,94,141,208,162,141,243,82,56,7,112,171,87,17,24,113,132,93,166,207,61,126,114,176,31,20,148,79,166,113,138,194,122,125,186,59,158,16,116,144,72,167,222,21,182,129,176,91,108,39,94,91,227,91,122,78,71,74,239,228,71,119,130,51,185,139,52,136,213,36,169,132,72,247,2,142,38,95,31,104,240,141,167,73,70,53,116,152,135,72,165,151,24,183,3,85,108,55,49,26,233,74,235,228,81,242,122,176,183,140,135,10,3,152,104,81,32,40,193,2,206,204,247,3,79,97,202,231,195,101,107,199,4,3,134,191,95,208,54,232,97,110,76,183,177,194,248,36,7,248,229,127,71,34,62,157,157,140,28,70,154,60,90,217,99,176,205,190,57,180,119,122,14,167,120,232,37,9,136,246,39,193,11,183,245,78,225,146,171,230,222,83,178,244,200,70,217,156,91,253,91,58,68,52,229,11,51,148,59,27,150,115,48,207,138,92,219,189,193,116,136,250,26,18,217,183,76,254,230,227,99,18,62,18,83,196,144,236,219,65,246,193,165,160,107,17,21,110,122,96,58,1,21,15,67,185,139,147,255,212,158,219,197,247,81,195,147,60,38,13,183,227,238,136,174,230,97,230,166,159,200,155,52,75,6,44,51,98,169,106,92,163,68,99,216,59,62,159,118,90,242,87,74,13,201,164,227,105,76,241,31,71,211,242,22,58,79,4,40,185,179,182,104,30,103,77,9,112,45,238,229,32,210,101,194,133,176,83,252,70,92,121,14,7,219,217,90,54,85,58,72,100,75,57,35,236,9,5,243,196,45,215,76,123,148,72,206,109,153,130,247,148,178,200,221,32,50,224,133,167,255,60,240,81,170,10,186,227,223,75,78,57,34,233,32,254,252,109,200,237,243,214,135,40,163,79,30,5,126,57,175,136,36,23,199,193,214,153,228,83,49,215,11,28,63,118,43,55,132,246,42,60,252,83,70,146,52,112,196,176,158,99,165,59,94,147,206,5,192,66,60,202,100,10,105,93,219,188,102,130,188,96,232,56,251,204,37,109,93,143,69,67,140,212,185,227,208,198,141,190,122,30,230,251,164,222,195,5,253,75,167,188,143,239,100,106,138,54,226,90,36,240,42,33,232,45,58,182,101,140,117,201,174,29,64,225,5,172,209,211,61,66,150,182,175,216,25,178,62,52,118,173,242,40,93,230,102,103,30,91,44,226,159,235,249,46,212,255,156,23,223,204,142,84,135,135,213,204,153,168,106,245,129,219,42,2,95,96,25,200,90,146,238,78,237,10,112,118,227,132,56,215,100,141,20,221,141,66,190,174,117,82,55,248,72,125,159,150,67,89,115,37,152,141,186,244,34,174,32,238,46,255,56,90,63,232,74,200,69,119,42,45,197,223,208,175,126,175,176,181,125,129,248,250,219,78,122,192,47,50,145,156,252,205,39,231,150,203,44,138,19,62,108,133,5,18,177,113,198,123,100,222,74,246,202,181,217,128,83,123,58,192,214,8,156,65,162,69,174,191,234,41,215,235,207,246,27,158,104,170,193,123,143,86,20,147,204,105,157,221,253,73,128,135,53,189,77,221,54,38,157,68,124,46,85,105,140,14,83,14,31,58,45,183,214,200,117,88,124,182,121,254,185,226,64,114,197,65,197,237,108,140,215,169,134,88,11,25,10,231,14,68,88,229,166,199,107,61,172,4,177,249,90,152,169,94,110,111,76,240,217,242,1,162,200,176,156,197,41,253,129,216,72,61,7,144,113,235,82,157,139,95,232,221,239,100,249,83,233,223,246,119,170,137,190,195,215,161,82,44,177,231,205,39,169,6,221,177,114,77,145,93,3,218,151,251,131,83,30,92,230,206,69,193,222,16,114,18,91,115,98,198,189,170,115,99,178,255,254,41,220,67,213,132,248,130,29,189,74,108,76,135,27,18,76,117,229,60,103,78,247,194,106,142,129,243,18,147,248,169,87,74,15,50,11,222,95,38,206,132,204,202,87,19,246,247,62,9,149,43,254,45,161,199,78,203,150,16,117,76,50,183,27,136,162,221,25,44,103,47,113,36,206,40,22,188,97,247,26,239,100,151,72,45,246,134,198,156,136,190,107,79,136,240,119,33,161,71,155,214,42,19,60,86,201,6,68,147,108,96,44,109,105,40,221,27,200,196,3,101,133,188,151,185,182,15,159,25,160,214,238,17,3,45,59,217,148,158,10,233,58,246,114,103,205,121,101,66,69,14,65,62,190,196,137,147,247,240,95,226,104,143,225,123,6,59,118,106,55,68,201,46,79,242,156,181,164,182,191,76,63,35,173,234,30,163,12,31,133,43,14,33,195,242,209,45,185,239,42,218,135,190,241,214,211,166,130,107,52,1,252,176,47,250,206,154,35,154,223,221,42,184,252,49,130,212,219,240,96,198,83,98,12,46,92,176,181,170,204,88,190,251,64,122,212,102,110,73,89,56,172,142,26,12,29,223,42,86,193,96,78,148,34,116,107,9,83,162,202,28,169,145,244,92,160,117,46,71,15,123,57,69,17,235,187,47,35,92,144,119,150,172,107,7,89,183,173,62,201,88,106,84,173,18,216,252,247,167,134,175,228,151,188,178,91,119,37,195,22,184,76,207,162,138,110,221,189,250,31,96,200,161,140,16,204,90,153,124,69,80,100,20,82,112,64,185,135,93,63,8,163,107,5,6,194,69,169,203,142,56,22,31,177,174,145,139,229,128,141,66,11,229,175,12,75,209,237,0,66,28,134,190,210,218,89,0,208,103,174,202,162,209,45,109,26,199,230,158,185,202,236,69,170,28,85,9,136,189,247,63,219,25,232,241,17,18,194,13,79,88,150,148,41,125,160,76,241,201,234,68,17,134,2,225,64,53,90,103,66,255,15,185,18,205,127,42,223,93,52,33,25,10,22,78,228,114,26,78,191,81,149,26,155,138,232,46,126,6,150,210,152,230,68,229,246,107,34,145,166,253,133,151,37,5,113,136,209,183,189,157,121,52,171,8,229,208,61,103,41,199,10,192,197,13,188,245,36,173,180,97,190,150,188,7,67,33,197,158,92,118,101,174,45,30,36,62,248,140,16,207,165,95,151,111,25,56,93,99,41,130,129,154,12,97,36,190,11,179,203,32,129,94,232,221,115,104,150,67,102,217,216,13,194,173,238,27,22,144,150,14,167,142,91,0,183,246,140,201,30,42,93,175,20,62,62,254,85,95,181,150,61,73,93,131,211,100,103,94,91,103,234,64,117,123,22,250,67,163,126,179,251,149,180,202,202,129,242,107,211,64,129,141,171,217,248,245,83,150,102,158,249,184,163,195,230,234,222,90,8,123,182,189,236,47,54,126,121,187,234,117,211,240,155,166,237,94,252,221,87,190,75,74,69,112,117,231,157,132,54,173,167,24,116,164,239,230,246,238,20,238,176,72,130,170,120,188,223,86,32,79,74,1,116,241,217,171,12,123,31,95,123,139,83,5,57,155,44,14,139,100,94,121,67,231,135,225,48,162,226,24,8,12,203,176,224,102,150,65,42,94,103,61,218,170,158,139,52,125,221,61,64,82,218,188,165,199,70,200,217,214,65,133,80,234,205,32,55,56,245,137,35,42,13,248,159,174,156,67,61,158,103,208,20,72,180,164,17,88,50,177,152,129,206,26,106,164,123,105,158,140,128,230,243,198,221,126,0,142,81,146,198,38,248,141,69,73,72,77,115,248,196,88,143,25,100,77,144,21,89,173,162,239,154,238,160,7,130,182,35,84,134,160,63,209,157,215,186,55,127,92,135,36,111,73,62,61,250,183,171,195,12,167,160,211,165,241,160,149,232,18,45,219,28,108,56,39,206,112,90,237,159,62,65,164,220,121,239,56,13,76,27,227,146,252,135,249,92,4,252,250,98,0,223,35,67,124,245,94,193,89,61,107,45,209,186,112,35,13,17,163,127,27,88,137,86,32,107,26,227,65,225,156,17,237,129,100,237,8,14,120,82,112,247,176,219,92,32,60,196,169,182,211,99,17,71,123,62,9,138,149,41,0,207,32,185,46,137,218,169,81,90,243,99,32,218,199,137,82,238,242,238,86,173,37,23,139,32,137,16,7,216,14,171,250,177,73,69,66,206,192,102,174,253,168,199,134,140,53,28,69,252,130,107,183,112,72,12,20,161,253,13,60,195,41,86,36,14,94,37,98,37,135,117,56,108,150,220,127,65,54,15,253,106,1,229,181,201,195,226,13,193,189,56,195,129,227,68,126,65,201,184,79,80,38,56,162,101,10,172,228,247,5,7,50,81,231,224,26,11,219,235,86,45,218,219,187,180,55,173,177,25,53,51,226,114,128,242,250,28,173,33,109,218,200,166,44,5,246,252,146,201,187,245,114,54,245,47,169,182,218,233,142,25,26,119,242,213,157,25,226,191,75,62,210,143,84,130,6,7,19,143,112,156,174,120,206,230,88,162,227,120,156,139,34,144,107,166,138,210,112,10,56,6,22,25,107,103,111,120,65,154,137,226,42,143,81,204,46,78,30,203,157,52,60,233,133,24,155,119,209,20,64,112,206,232,225,87,3,178,7,227,21,163,97,75,186,205,217,22,1,201,97,134,237,158,34,108,109,104,124,246,223,27,217,136,57,134,200,189,25,95,253,118,147,145,53,68,72,173,64,37,123,74,235,132,55,202,242,21,120,236,111,171,217,153,140,109,18,68,225,236,26,36,23,123,15,15,167,166,149,3,220,5,94,233,77,246,218,73,53,238,45,39,69,58,187,232,82,178,160,112,50,159,76,134,203,128,143,23,233,162,43,178,191,193,76,86,172,49,180,150,4,60,145,78,56,38,212,82,112,115,95,39,104,213,230,222,55,230,138,244,94,170,162,28,64,118,122,221,129,71,231,122,2,226,160,237,224,52,134,185,45,214,6,247,170,8,109,236,35,139,85,81,250,87,7,160,226,43,18,114,171,237,205,253,179,197,129,200,201,242,135,181,101,42,182,38,197,90,133,23,113,154,117,167,87,160,1,14,182,27,154,19,179,243,203,35,86,244,119,97,2,146,64,194,36,161,49,215,125,160,37,80,229,201,199,182,31,64,167,52,115,188,104,138,171,37,145,132,90,66,114,27,0,158,251,165,26,74,22,188,227,171,136,193,164,203,222,134,16,198,169,73,241,125,50,58,177,119,188,40,27,110,184,87,238,182,137,21,46,165,225,186,117,57,82,53,158,155,146,20,126,234,117,93,94,7,77,168,222,88,52,82,122,40,72,208,50,204,62,27,236,95,43,228,16,122,206,69,225,130,157,144,227,11,93,133,102,120,166,5,89,208,38,216,177,48,48,125,246,206,3,157,45,92,63,215,27,161,222,153,68,148,234,29,141,94,244,11,26,24,73,25,84,232,207,251,235,98,84,150,0,211,62,64,175,153,4,58,236,198,226,156,104,123,31,157,81,110,18,149,135,63,199,75,166,86,218,39,224,215,202,117,141,234,191,41,54,84,46,212,202,137,109,22,73,47,234,122,174,224,27,130,135,228,8,244,153,121,28,49,254,107,45,50,25,70,131,253,89,241,4,176,95,85,8,163,187,103,180,46,8,182,93,3,145,44,103,42,4,31,114,253,111,95,143,204,42,194,133,189,237,90,63,163,147,67,174,24,140,26,221,235,167,189,37,126,30,21,134,188,247,32,219,22,241,26,121,211,243,205,166,160,148,253,148,8,234,24,109,70,94,234,50,108,13,166,95,183,69,64,180,89,189,89,199,59,53,110,112,214,24,60,158,54,80,26,98,164,247,66,208,105,35,20,44,154,171,177,120,7,83,186,192,100,152,251,21,173,184,34,220,176,159,73,67,132,199,148,118,153,163,27,116,212,150,127,72,227,3,125,188,64,226,184,208,234,174,91,46,103,120,233,237,150,208,48,175,7,38,136,113,144,138,155,208,243,46,2,0,28,246,28,131,217,146,126,214,180,49,49,154,102,106,217,162,247,139,70,74,94,63,60,20,176,223,53,31,127,19,249,202,50,48,179,141,24,75,168,189,170,146,63,85,46,191,24,221,234,40,49,208,17,155,242,61,115,207,209,31,9,198,134,244,73,7,197,214,128,125,195,16,32,138,149,59,134,254,43,67,0,97,162,97,46,26,90,175,4,114,117,177,81,65,161,1,4,98,224,52,221,22,222,225,90,63,71,41,75,194,58,23,204,32,213,137,57,49,193,50,144,123,25,102,83,215,93,189,216,6,227,23,238,130,183,230,250,156,183,253,22,197,18,140,91,202,162,185,72,51,131,95,133,46,47,38,215,88,11,42,153,216,18,88,35,146,159,83,252,214,183,154,246,245,117,173,135,55,1,114,197,134,219,189,212,29,21,252,141,186,54,108,145,148,133,119,13,221,99,3,124,85,237,151,163,88,97,90,57,174,71,212,147,148,240,43,203,249,239,114,202,49,234,106,163,1,226,224,179,28,111,1,223,120,91,70,135,35,255,253,53,168,189,31,9,66,115,36,251,85,244,65,202,213,51,239,254,135,146,191,119,45,116,170,212,235,203,247,70,188,107,172,4,241,89,133,55,101,96,253,33,188,168,202,115,207,30,110,177,110,72,108,203,28,114,25,120,118,213,154,34,228,66,221,106,13,169,29,148,16,8,110,72,77,159,239,253,127,154,154,86,125,187,110,180,121,67,92,30,17,223,140,100,204,104,73,154,92,118,178,34,32,65,246,20,9,25,151,218,65,28,55,205,18,47,66,99,62,36,178,26,120,152,59,187,106,72,144,188,55,198,178,22,234,79,124,199,207,5,101,44,30,238,55,207,251,89,130,179,194,135,3,32,32,12,236,84,109,7,113,120,221,241,95,2,175,239,4,85,172,151,142,205,213,255,253,5,24,250,125,241,180,81,177,242,152,248,137,82,71,233,117,147,120,86,227,216,135,12,140,207,18,182,181,242,231,232,199,125,209,5,218,188,45,153,42,25,103,145,168,2,144,226,190,105,130,38,144,150,91,68,252,149,83,90,2,186,179,26,201,213,63,5,242,50,235,42,157,100,83,69,57,120,17,68,111,41,7,229,10,251,12,157,30,99,242,20,216,138,4,109,114,227,19,12,206,32,81,233,82,174,80,158,138,172,20,131,35,53,198,252,82,217,245,28,105,9,172,104,161,225,230,83,65,128,187,254,55,190,16,8,207,70,65,18,70,21,201,34,227,137,13,116,117,56,50,95,223,112,9,20,246,202,125,38,159,208,95,82,26,37,113,74,235,210,30,56,210,94,205,114,54,180,11,163,215,28,148,220,192,159,55,154,92,120,142,0,187,100,45,218,85,141,249,171,220,250,27,98,156,40,241,47,220,125,77,81,113,79,194,85,153,155,201,201,253,139,173,49,26,55,188,227,178,70,61,23,188,144,210,87,210,3,226,42,36,249,243,230,162,97,169,86,194,42,95,182,236,36,75,136,94,152,84,24,123,116,61,255,13,90,251,239,78,78,213,26,95,6,76,202,164,129,5,203,70,242,42,150,64,163,80,154,7,105,22,173,40,134,56,242,166,222,3,85,184,23,182,183,36,107,194,166,115,16,27,9,81,40,151,216,61,59,79,237,117,122,47,132,85,127,8,165,22,53,79,128,76,69,124,54,97,167,161,11,221,55,238,36,90,43,208,160,158,248,219,229,9,131,142,219,22,180,46,176,12,112,177,253,243,220,2,90,251,190,235,103,103,237,213,41,242,1,130,80,159,36,108,216,189,139,178,214,125,184,169,15,126,22,246,40,51,208,103,146,12,24,94,137,119,69,87,123,145,65,37,106,25,113,96,184,203,185,245,219,241,16,48,149,218,22,227,9,233,204,150,164,95,13,52,197,56,182,42,53,58,106,71,247,172,134,208,19,201,112,187,164,161,53,71,87,111,79,231,2,230,57,3,176,119,148,113,75,193,170,60,30,171,20,215,254,96,196,45,162,116,230,71,122,255,90,198,108,139,40,175,206,194,232,81,106,182,93,17,188,56,42,144,93,66,49,34,236,189,36,128,178,245,119,213,192,71,16,172,57,143,57,136,178,217,3,250,126,209,245,4,169,32,190,98,245,6,107,76,222,160,186,34,197,142,8,74,79,53,47,144,61,193,201,25,237,71,126,240,157,59,230,175,231,172,250,249,32,145,83,71,44,232,165,62,54,169,205,127,172,156,244,165,31,17,65,98,112,77,205,80,84,194,114,174,114,99,84,115,61,184,136,17,249,183,201,71,230,20,174,226,163,86,182,178,50,121,56,215,145,31,221,69,114,205,115,228,105,47,119,89,9,219,45,249,191,217,51,9,104,59,138,203,241,29,58,160,3,224,117,130,165,76,88,97,230,164,76,90,148,197,93,128,212,33,226,183,49,168,74,119,169,26,146,122,108,166,207,29,30,232,121,161,212,29,246,214,233,140,22,136,94,240,177,186,20,94,161,224,24,100,134,170,87,101,220,206,179,8,1,210,250,76,123,186,250,98,151,182,112,208,48,196,239,160,76,20,121,232,10,19,168,116,235,240,62,52,30,79,140,66,113,18,0,131,32,162,214,53,148,213,226,230,102,86,93,212,193,41,118,171,211,240,57,182,137,232,180,70,110,33,88,202,108,5,147,255,42,132,49,56,188,10,220,18,184,98,159,255,22,86,229,115,55,89,121,216,177,180,152,170,91,39,196,16,195,151,22,117,6,172,185,65,134,21,83,79,139,114,135,21,158,248,217,27,64,197,20,103,163,4,128,232,246,252,177,178,214,92,252,160,163,16,56,47,250,142,21,139,227,45,213,54,88,138,153,78,202,67,109,115,130,27,159,176,74,155,225,115,20,140,227,8,85,144,70,159,162,19,220,99,47,209,45,143,102,138,92,60,8,58,254,68,45,99,11,189,47,206,67,185,71,51,56,238,128,186,227,56,109,61,150,6,21,126,78,189,237,199,254,115,38,3,110,126,79,75,202,21,232,214,249,48,8,62,205,49,87,50,46,121,40,54,138,18,103,166,92,64,234,138,219,69,115,82,213,46,83,248,36,28,147,186,44,121,37,38,147,235,108,219,40,86,197,77,217,66,104,128,131,168,157,60,229,27,250,10,153,93,235,36,78,124,89,195,176,156,4,57,101,99,255,38,166,179,220,116,186,165,98,90,198,158,143,39,21,202,58,234,111,108,67,157,23,137,40,192,237,170,149,248,138,91,40,170,167,50,229,36,187,182,67,35,215,125,157,15,23,166,170,233,254,138,126,56,98,103,25,55,20,157,210,129,153,164,52,173,8,111,13,38,170,27,248,187,141,221,118,71,223,102,155,17,104,253,234,153,182,178,49,154,27,192,63,199,164,235,78,132,196,185,128,133,6,206,186,23,78,57,75,43,11,216,133,97,101,237,218,109,160,103,0,148,122,144,63,40,206,3,28,168,163,33,157,239,201,26,139,251,144,250,232,51,81,165,16,11,143,116,117,71,44,218,189,230,128,208,20,188,83,7,51,255,48,231,154,115,100,6,97,237,122,117,162,122,173,106,30,39,183,0,94,91,48,76,103,97,197,34,236,240,92,90,235,131,178,110,74,187,97,112,134,72,161,15,199,194,234,142,32,240,216,43,29,76,234,46,87,202,187,142,168,176,64,120,208,206,54,183,122,111,65,172,192,30,168,85,231,49,198,84,184,169,214,54,49,122,50,228,224,155,30,98,60,194,101,1,156,242,59,117,12,159,219,207,205,191,126,28,17,77,108,219,176,58,37,164,180,25,208,33,25,45,30,161,13,81,4,239,195,17,129,250,211,244,132,58,219,217,119,197,115,167,241,10,39,8,33,133,63,125,127,100,1,99,205,231,158,193,134,112,150,31,42,249,228,103,223,170,115,38,225,180,177,12,224,3,189,252,81,88,228,168,77,197,106,219,234,135,98,189,218,45,18,180,236,16,34,110,152,237,176,116,76,98,131,107,123,177,93,153,94,133,20,143,6,193,128,70,174,206,94,123,139,79,233,35,82,3,88,238,238,53,177,90,80,198,198,51,135,25,198,121,44,32,175,109,77,60,241,222,22,191,130,27,99,81,83,154,132,253,245,173,118,65,219,242,245,83,144,252,254,199,222,25,159,51,40,168,213,133,146,138,105,197,80,4,95,96,52,102,115,246,174,77,9,220,83,218,244,184,15,137,69,116,3,120,140,95,236,110,53,10,23,242,251,76,81,53,126,168,207,163,145,157,227,236,8,155,115,217,36,20,146,120,36,223,155,55,179,229,252,250,144,2,115,4,192,167,32,25,211,112,79,192,240,105,176,152,134,204,150,59,112,152,120,2,1,28,10,217,73,232,159,221,245,226,148,19,43,155,155,41,193,131,74,250,40,34,230,225,152,177,199,161,148,10,9,37,64,103,95,235,251,234,237,80,131,81,233,55,254,215,31,201,227,41,6,116,104,221,78,155,178,214,139,204,22,173,203,100,164,149,160,195,83,0,249,246,196,247,17,58,243,103,236,67,160,93,51,250,237,221,71,27,18,148,112,198,64,132,113,117,160,57,197,214,209,235,215,29,113,66,122,12,54,193,186,251,67,31,51,4,155,94,225,14,79,225,79,37,29,210,145,1,205,46,24,125,207,177,89,76,159,104,6,43,79,90,147,155,88,135,39,234,149,42,254,241,140,150,236,217,8,131,240,225,254,91,48,62,42,113,88,191,74,239,248,156,112,78,48,232,176,151,147,222,43,91,171,233,80,73,202,194,247,59,11,64,253,93,11,32,179,8,211,14,61,139,84,103,198,91,119,113,2,148,47,73,92,33,52,237,25,121,90,25,118,93,19,106,83,140,182,167,66,65,130,8,44,57,189,1,46,159,235,17,149,238,145,234,28,120,139,122,172,89,213,14,184,117,77,169,0,173,187,54,105,69,124,82,228,121,26,196,211,162,210,114,52,154,19,45,190,150,122,169,103,70,116,109,172,22,78,104,116,170,222,3,37,52,35,237,250,1,253,121,18,208,76,83,132,160,174,69,116,137,221,182,124,40,183,138,43,254,145,79,24,204,132,53,223,129,35,212,99,215,36,193,116,203,190,210,136,45,146,10,126,226,226,39,9,126,67,27,184,241,69,237,100,64,150,72,221,90,109,213,220,117,97,58,193,190,36,84,81,175,153,242,176,216,40,104,230,42,167,124,222,180,142,85,181,204,154,157,205,97,6,26,29,248,0,167,111,55,138,105,67,16,251,72,29,68,71,23,185,79,60,211,8,113,192,110,107,141,190,172,76,70,202,15,89,233,116,231,46,186,115,127,237,254,40,192,106,173,143,79,151,148,204,22,163,107,149,220,179,65,205,64,119,174,117,142,183,180,71,170,190,157,85,76,175,155,230,79,10,170,249,133,240,83,195,39,53,182,95,87,113,216,97,75,177,94,126,239,208,190,5,237,248,111,144,122,156,29,68,36,147,122,108,122,42,186,238,161,6,79,223,215,168,232,90,66,111,12,231,202,113,210,163,167,25,249,97,233,56,200,118,206,90,86,8,246,228,15,137,192,184,27,197,0,194,203,42,223,126,244,147,214,80,10,22,77,38,221,43,220,39,48,180,252,182,27,177,9,222,180,152,200,72,186,166,88,129,225,220,251,58,51,252,43,38,145,140,193,197,121,85,113,174,71,237,121,160,66,162,239,130,10,60,218,75,138,25,77,255,188,121,184,5,214,64,145,199,162,97,93,47,14,108,64,120,53,207,145,9,83,131,118,254,224,83,241,41,29,218,21,162,182,240,28,25,39,117,154,3,208,204,238,26,51,235,87,49,174,8,228,235,7,51,129,35,212,42,53,86,28,176,54,192,159,36,127,193,139,129,163,201,161,100,247,225,81,132,133,29,133,93,37,155,232,194,142,173,35,56,118,136,44,135,154,69,62,10,176,243,126,88,12,70,219,91,181,140,228,82,254,96,70,34,103,33,255,220,172,178,13,182,165,60,163,147,214,243,86,126,108,141,115,140,126,84,221,30,192,191,71,169,171,118,62,113,232,203,103,82,0,145,210,68,22,3,69,198,114,41,142,50,109,144,215,117,117,237,241,83,203,177,138,232,142,190,23,166,174,54,186,207,131,42,250,172,56,122,195,66,250,108,71,172,86,89,70,112,112,27,38,66,84,23,228,49,36,181,212,53,42,27,141,84,97,160,16,40,204,50,187,97,238,163,196,149,31,208,29,203,133,239,96,53,198,190,222,71,86,12,152,29,149,116,99,51,191,138,29,14,24,255,177,187,87,79,108,219,107,251,245,243,141,40,24,65,102,34,31,197,163,188,230,243,168,21,253,43,205,6,221,52,111,246,102,110,169,218,74,11,160,164,138,216,208,103,224,108,186,25,10,206,87,45,47,186,215,167,92,104,34,31,57,100,165,12,234,35,69,133,111,112,87,219,38,167,73,222,45,205,35,244,22,28,146,100,4,255,182,143,201,250,144,248,139,161,252,39,45,105,237,124,90,63,58,23,121,39,5,77,220,14,133,111,223,68,191,17,132,180,198,152,141,116,64,237,202,87,41,126,30,80,205,171,248,202,136,215,74,222,8,233,73,152,113,170,60,73,82,38,215,209,132,151,189,140,141,113,171,47,253,55,129,89,32,249,33,242,144,220,10,63,239,84,204,222,198,144,78,206,197,97,117,186,16,205,113,154,147,245,188,7,82,109,243,117,117,106,168,255,156,90,150,146,19,160,53,71,188,252,213,138,188,156,96,143,84,92,159,112,233,5,236,219,147,84,143,68,174,80,55,156,27,17,29,84,151,224,98,85,37,71,120,28,61,204,160,250,246,27,3,22,93,246,215,75,166,248,155,36,176,59,99,10,182,43,205,125,229,220,234,114,26,125,19,120,141,55,189,21,211,58,254,203,19,15,180,168,45,181,136,20,60,89,132,103,59,225,51,79,95,111,108,90,75,13,199,161,85,32,92,255,139,238,13,22,50,23,35,79,120,142,235,210,93,166,214,149,156,211,39,222,157,138,162,87,83,78,99,247,115,236,124,217,123,4,33,94,166,12,96,74,51,75,202,203,167,111,131,255,9,28,97,68,9,116,228,86,163,168,32,167,111,159,165,126,102,137,114,198,40,65,187,193,21,235,128,188,210,226,167,148,227,117,15,97,186,126,46,240,244,214,215,220,199,67,102,41,48,227,7,180,226,167,14,33,148,136,144,196,225,35,221,86,105,0,239,54,48,78,136,242,196,36,65,155,46,244,66,134,136,185,206,237,223,119,42,76,198,18,245,38,33,21,246,76,59,227,199,136,73,2,89,226,126,208,185,17,135,234,30,13,159,126,9,27,4,226,245,51,246,243,108,255,50,60,53,63,199,181,237,56,165,76,183,11,49,245,174,129,248,182,129,143,246,218,110,241,141,37,94,17,121,246,14,59,54,94,155,7,92,188,54,48,114,44,221,236,0,11,44,142,180,219,59,194,82,82,249,168,38,89,181,14,19,162,160,214,72,107,129,211,251,244,110,147,153,69,232,83,139,89,230,32,87,255,31,176,163,39,61,226,234,6,87,236,114,129,244,101,59,110,69,87,3,4,149,179,31,37,45,169,50,221,210,244,231,219,60,216,60,89,20,200,9,168,196,108,240,199,238,163,113,210,251,182,96,177,142,233,131,82,174,141,43,142,44,197,190,31,116,47,145,146,92,11,7,78,35,77,103,175,221,40,11,174,22,203,46,135,167,43,94,207,184,129,53,31,157,231,183,51,107,9,229,176,139,190,238,129,94,238,203,40,56,200,185,195,19,157,241,153,16,160,156,66,213,213,7,98,194,62,153,228,37,113,19,224,167,157,102,124,247,22,189,233,121,186,182,97,215,135,133,148,165,29,225,148,192,181,184,66,229,169,81,98,212,21,229,9,124,250,57,112,84,147,118,35,246,202,92,45,141,199,181,213,139,145,48,159,108,86,173,78,249,39,233,226,167,117,1,198,32,18,29,205,183,236,165,247,191,193,191,178,121,200,220,155,122,245,152,56,29,120,185,185,215,243,226,149,36,81,149,197,165,220,42,56,98,105,215,123,238,170,212,17,194,9,203,183,252,88,43,105,9,83,41,237,230,244,97,141,198,90,6,115,124,143,136,144,239,132,151,116,143,199,70,169,142,249,213,129,104,121,108,235,112,160,146,221,157,51,202,219,167,185,89,17,176,76,165,221,98,206,6,237,44,90,219,103,230,154,144,25,76,213,39,47,182,2,71,181,54,207,212,170,42,127,191,93,86,108,77,250,16,56,108,197,36,173,151,18,242,2,100,55,167,242,187,161,20,88,16,120,228,225,2,231,190,212,55,111,151,116,199,15,231,151,215,158,198,87,14,94,234,31,155,100,224,130,56,71,155,136,34,74,61,185,140,112,191,123,230,10,108,224,87,76,51,44,107,61,36,159,38,31,206,7,28,131,26,83,65,128,21,136,152,167,204,125,190,224,151,33,105,84,6,22,182,45,45,107,47,130,108,255,86,16,71,229,67,169,110,101,171,145,127,159,171,150,175,132,99,185,42,92,107,1,150,32,69,222,116,113,11,18,212,139,179,13,40,215,175,72,247,95,113,163,81,140,78,147,139,112,123,79,159,202,150,176,98,17,170,255,187,117,197,76,189,100,201,185,52,81,95,77,44,72,27,128,145,227,96,10,223,97,128,49,92,214,25,66,123,45,8,189,172,18,107,230,162,189,50,204,251,127,244,137,141,18,190,162,202,96,66,184,234,86,138,51,46,12,226,248,170,60,212,163,80,76,137,251,13,157,30,4,44,168,229,139,131,219,78,176,238,41,53,217,11,238,38,220,108,105,195,56,90,38,142,181,181,222,249,183,106,133,253,87,140,12,140,23,164,57,61,2,80,236,211,93,198,205,200,89,169,66,166,242,73,126,175,191,188,227,194,135,103,146,213,12,251,90,5,222,100,202,27,79,56,106,6,134,118,120,225,50,26,60,162,241,134,8,173,81,66,230,134,209,150,217,90,11,240,223,74,204,103,66,141,18,131,68,236,111,242,22,208,189,18,42,188,100,222,194,16,251,2,238,15,49,139,61,243,164,176,34,106,114,88,136,193,233,21,116,214,38,235,236,129,94,142,91,235,157,52,124,79,123,238,55,85,111,254,180,148,131,4,79,0,148,147,94,88,133,151,3,230,106,25,33,149,185,84,20,87,63,160,187,70,41,205,73,249,132,102,141,97,182,78,197,210,125,20,36,41,140,139,150,23,178,95,192,145,6,124,37,105,193,23,180,109,225,187,89,190,0,92,167,144,225,120,248,19,128,17,89,161,47,135,20,165,171,95,109,227,217,35,48,30,171,191,86,61,96,138,173,246,153,129,5,83,70,148,37,157,41,34,22,94,245,108,59,88,60,65,174,178,9,45,113,93,112,68,203,13,164,225,214,61,223,13,248,211,35,226,127,200,21,219,154,153,3,30,33,101,126,4,208,242,225,197,91,215,90,89,173,37,13,78,113,210,237,132,0,153,111,188,120,153,60,68,86,70,84,100,69,161,98,149,137,152,186,203,201,217,159,16,211,108,15,36,139,0,13,223,108,225,56,115,17,8,152,250,255,183,69,174,195,34,123,54,73,8,176,103,74,108,90,11,154,106,91,154,113,24,108,126,82,220,12,41,22,45,55,165,15,119,62,107,110,138,111,130,158,189,212,73,189,68,91,14,158,208,122,195,30,159,230,113,7,212,1,35,206,54,175,185,180,54,178,155,254,181,87,92,224,232,110,126,178,44,21,104,171,242,211,120,202,240,44,42,162,179,62,66,88,37,108,22,231,130,116,79,47,195,18,83,90,128,240,0,108,93,186,185,216,231,120,114,18,10,120,123,128,146,24,134,222,208,190,155,202,205,132,199,250,72,249,139,98,63,238,152,165,104,71,233,72,172,133,216,212,32,246,251,43,165,203,50,128,77,210,2,79,196,240,176,33,29,202,64,252,49,79,131,11,78,35,220,95,111,238,162,239,121,193,42,90,63,12,245,12,81,77,111,84,77,71,229,168,100,202,191,76,26,59,16,211,34,248,216,43,211,110,160,230,131,111,79,15,97,19,102,129,25,124,176,232,251,46,52,77,182,157,116,127,204,215,169,27,244,25,139,84,54,79,136,51,31,20,72,60,231,119,71,167,109,246,181,233,39,15,39,252,157,96,137,111,136,58,172,217,76,21,168,14,167,16,127,119,47,74,30,62,248,201,148,92,252,67,192,227,90,120,255,58,226,225,3,150,8,159,54,100,200,105,255,178,246,43,130,77,14,141,48,141,207,21,227,107,235,218,245,55,108,111,212,199,53,161,14,170,246,88,36,182,84,196,198,170,137,27,154,17,180,124,102,214,113,24,63,20,98,32,166,85,76,112,231,220,175,198,26,75,187,251,30,169,73,145,108,50,248,1,209,11,200,247,241,13,115,97,213,160,173,238,102,65,44,134,41,36,26,163,19,125,21,57,63,254,219,53,250,251,193,52,156,136,160,171,121,31,59,193,150,38,225,153,139,69,100,42,205,180,240,168,121,253,146,215,233,108,85,97,201,247,118,156,136,0,35,26,233,42,220,17,99,75,217,40,185,36,93,24,68,49,27,129,254,161,120,114,133,31,186,37,158,46,128,215,191,95,112,202,20,37,112,171,245,223,202,250,68,255,160,19,63,225,58,17,191,165,67,188,180,170,230,132,122,50,51,130,199,203,217,38,56,233,54,209,173,242,24,199,188,53,211,9,71,123,44,165,80,36,216,145,235,97,108,211,55,225,244,16,108,26,109,43,202,63,216,35,158,114,238,82,35,102,12,131,166,205,191,190,72,198,12,208,30,183,198,0,212,110,167,186,166,10,220,112,160,7,159,83,221,248,40,161,38,102,206,35,165,214,94,92,208,177,125,197,68,74,63,46,108,236,89,138,204,230,3,248,160,129,188,141,161,78,39,40,255,9,140,213,100,56,31,164,50,180,230,188,159,114,219,111,191,23,20,80,106,94,173,205,157,255,238,248,61,58,200,245,212,197,203,133,139,80,62,79,220,174,226,214,225,36,89,126,224,238,52,47,104,0,101,187,249,27,39,139,22,50,0,150,136,179,87,60,188,117,235,163,108,91,229,35,146,129,158,248,32,121,245,120,89,208,231,35,18,167,249,252,192,132,207,240,169,237,110,79,135,152,191,129,144,75,188,120,7,52,50,252,93,235,126,19,83,69,166,160,190,233,204,165,66,10,232,175,18,67,147,17,1,150,251,225,97,173,154,56,120,27,215,68,67,101,187,219,30,108,248,170,235,204,212,136,162,99,36,251,202,92,139,232,185,45,57,74,13,226,205,62,226,76,204,213,79,5,174,211,193,135,164,127,104,93,160,128,245,40,111,212,145,110,225,62,224,128,36,226,166,24,26,205,220,10,40,103,229,86,63,101,81,38,138,28,144,194,236,22,135,216,2,6,104,63,198,222,65,78,239,59,72,149,189,64,125,244,130,245,18,128,29,182,26,59,147,29,82,117,228,235,203,139,237,211,253,238,173,242,213,110,15,102,48,249,206,166,223,47,236,128,118,238,2,122,149,203,254,200,206,238,245,92,171,228,255,34,16,128,208,141,150,177,77,47,230,52,213,28,78,155,72,219,173,201,126,76,85,12,246,87,236,16,247,98,35,244,157,172,238,231,150,213,84,156,128,228,178,251,97,110,26,176,185,214,199,104,69,183,211,59,90,142,56,229,144,161,14,139,36,35,141,237,179,80,205,228,27,142,74,196,66,33,147,176,54,97,226,129,24,110,84,55,7,20,192,54,233,100,166,46,238,65,126,182,140,147,127,97,164,253,29,25,76,198,20,53,11,174,7,181,34,155,0,119,29,194,59,21,105,50,137,82,219,161,205,178,54,73,43,125,31,185,152,196,77,189,213,113,210,68,111,63,38,6,114,169,97,19,81,120,141,160,60,95,216,58,151,218,240,93,16,246,126,134,225,189,71,29,226,57,15,194,98,199,172,87,7,69,31,152,249,109,143,231,236,154,210,6,133,75,238,151,106,140,238,107,111,40,157,187,169,110,74,60,159,161,199,84,188,172,125,146,59,18,2,68,28,228,222,144,232,206,61,8,233,7,1,56,37,112,221,147,189,124,135,67,205,76,170,213,76,227,29,48,8,97,253,172,15,253,24,197,218,204,108,197,109,152,191,134,181,86,215,60,239,40,125,188,242,236,85,28,146,231,136,208,156,10,1,125,247,146,226,242,113,193,131,31,17,94,243,163,87,105,98,90,89,166,227,90,169,229,2,57,112,168,39,9,128,106,123,131,175,119,185,109,236,230,13,240,218,55,248,229,216,119,150,160,216,84,217,66,29,100,10,138,89,78,80,14,174,15,43,204,149,203,184,203,96,170,44,81,147,73,221,59,68,78,134,121,118,236,207,228,107,232,196,225,199,255,108,143,42,215,58,46,3,126,152,139,236,95,103,212,83,56,69,142,44,126,31,92,0,188,62,53,252,152,71,48,16,114,231,179,245,73,112,167,180,204,3,225,183,177,93,201,71,129,218,27,49,56,173,167,81,19,254,196,199,71,9,92,164,45,226,133,119,14,193,224,2,64,186,248,76,107,30,197,86,121,116,248,35,81,186,172,22,141,247,154,146,20,14,95,124,224,14,150,143,208,231,9,75,78,237,21,121,5,143,93,52,150,228,206,37,19,29,230,162,136,20,64,215,80,126,19,179,198,156,20,4,55,201,91,110,56,52,155,157,113,189,217,90,226,118,168,255,90,83,73,83,26,14,76,177,10,177,160,37,168,184,122,49,39,254,92,237,235,139,201,184,241,234,137,204,44,210,21,176,108,47,230,137,235,230,150,155,132,178,93,115,60,49,182,43,69,117,104,79,147,226,192,39,146,141,115,33,80,78,92,196,103,162,49,203,12,187,154,168,146,176,253,9,25,95,230,112,218,70,96,54,73,154,167,105,73,238,224,35,3,40,143,176,114,45,8,250,7,254,108,32,3,102,234,46,165,69,31,224,137,225,239,111,196,189,159,72,190,154,60,174,184,95,241,28,24,43,116,79,171,83,84,172,79,98,104,27,35,172,216,250,170,182,96,70,82,197,160,186,19,150,182,250,74,131,34,56,162,22,251,1,127,173,19,69,86,224,231,228,32,141,228,216,45,116,67,31,247,91,59,236,208,190,55,101,178,43,117,180,213,145,226,135,250,124,58,218,72,74,82,98,145,204,214,129,197,154,48,173,21,116,82,224,132,195,62,74,119,154,90,88,48,24,62,136,187,37,204,32,58,243,71,181,244,98,245,65,76,212,104,123,31,33,134,185,115,144,194,25,104,127,207,215,11,127,125,125,160,57,41,61,96,127,200,162,29,191,60,47,156,33,100,58,103,205,160,168,55,101,140,215,173,63,250,223,58,59,11,96,137,113,190,120,21,158,135,50,149,58,131,90,176,11,228,67,105,117,71,69,98,17,3,120,184,221,17,92,197,67,243,103,41,243,124,18,134,232,72,191,125,212,208,113,83,185,173,254,115,184,148,152,49,68,8,54,216,30,245,43,21,150,178,151,181,35,188,160,74,207,121,238,9,88,83,181,59,116,132,93,98,31,55,136,102,58,83,217,226,225,178,137,23,170,101,33,41,244,42,17,104,100,195,30,104,32,76,189,62,81,161,74,64,241,232,154,167,131,232,154,198,244,216,82,199,102,30,57,83,24,139,211,137,249,153,204,65,206,68,204,186,35,38,51,204,242,138,168,8,18,248,22,162,182,179,62,18,100,2,254,248,196,183,192,166,124,87,179,109,46,225,92,231,238,31,126,87,43,42,182,52,120,31,16,8,193,88,115,152,71,200,49,70,40,130,30,75,56,101,189,114,30,68,241,138,207,219,239,152,78,114,134,211,55,175,98,40,154,140,96,76,148,29,60,253,191,207,242,88,153,184,169,131,30,224,21,64,41,45,236,191,184,28,87,102,32,150,227,246,80,120,166,114,250,234,136,218,70,204,223,197,158,31,217,171,184,112,176,183,168,215,221,116,29,193,125,188,234,91,100,92,78,91,166,108,240,53,187,47,10,170,7,15,58,155,10,183,211,4,134,149,107,6,109,142,247,147,5,243,14,202,141,189,197,255,96,50,253,119,103,42,203,90,94,96,43,26,83,184,149,169,222,34,134,164,94,192,153,238,240,114,232,10,41,233,193,55,44,155,125,27,208,132,139,47,166,144,185,69,12,42,167,3,246,29,210,47,201,60,54,138,107,151,8,226,215,143,254,241,140,109,33,41,251,99,183,184,175,43,196,179,23,33,235,170,84,19,239,61,34,229,204,208,51,240,16,164,54,126,236,232,177,244,20,248,152,29,34,255,24,223,135,21,167,198,183,150,230,109,86,255,249,159,238,96,223,238,217,169,53,184,145,57,12,252,116,233,81,127,51,213,49,37,194,83,57,37,69,167,142,127,11,187,58,108,202,248,93,115,54,42,35,191,102,150,30,36,163,75,199,162,163,233,141,144,218,112,12,159,71,125,98,23,9,254,193,50,190,119,131,82,176,94,106,249,173,187,112,187,86,193,213,193,67,238,179,25,170,125,84,2,147,154,102,245,239,196,187,157,244,179,63,40,192,101,152,105,132,204,175,62,46,15,23,4,49,125,227,152,212,242,121,46,155,92,60,140,254,8,35,215,19,230,73,205,211,163,241,134,251,114,178,29,128,242,134,168,102,80,143,231,7,201,36,171,16,6,166,90,234,143,244,144,184,6,207,241,179,79,170,191,87,97,239,26,207,97,247,25,226,27,135,207,155,93,231,208,10,141,192,155,32,40,93,71,143,200,245,17,48,2,55,249,189,120,97,142,208,90,107,186,137,28,84,195,144,207,14,222,24,228,185,10,19,142,245,213,253,72,46,54,13,49,222,0,83,99,106,216,217,35,5,61,145,228,218,119,164,74,100,167,125,70,12,114,78,34,35,25,241,123,2,238,39,75,23,198,102,236,255,38,204,147,212,34,29,171,248,158,139,120,131,136,66,125,52,125,128,242,252,79,88,253,100,200,159,102,13,155,155,204,113,100,127,233,43,85,248,94,135,177,232,18,98,132,81,54,234,193,204,217,172,223,145,60,220,87,168,154,137,76,188,230,50,237,209,98,109,178,108,156,12,50,165,228,197,132,59,62,87,245,206,153,46,9,247,22,211,218,181,155,172,71,102,38,75,57,230,12,207,224,128,167,57,236,247,149,254,103,164,31,132,166,107,128,236,143,127,137,236,238,139,158,158,62,67,219,155,30,108,214,168,3,139,232,250,41,74,120,243,180,62,75,125,82,4,160,154,237,225,204,174,116,1,30,10,241,50,102,34,96,112,128,94,59,70,148,127,2,196,109,110,105,178,226,212,81,121,7,93,230,158,22,47,34,219,133,28,227,234,143,97,17,65,148,232,114,108,17,182,111,124,169,211,214,243,74,157,255,20,118,249,169,251,6,44,53,209,206,36,170,253,123,160,116,115,233,83,207,160,105,255,146,243,179,104,122,207,28,25,247,114,223,1,196,137,167,128,102,63,147,205,107,232,66,125,168,240,18,229,25,66,40,36,0,90,14,180,114,23,18,211,251,41,190,204,70,113,103,87,200,60,26,65,217,86,155,140,74,106,237,156,239,154,109,89,49,254,115,125,107,142,207,9,118,237,148,160,111,19,116,89,141,243,221,16,212,72,217,25,23,52,153,123,59,96,93,135,106,214,190,28,25,177,203,18,216,220,13,5,134,152,46,106,244,127,136,78,22,116,59,195,146,183,60,79,209,144,248,55,7,45,37,53,104,86,71,231,221,124,40,22,53,245,33,94,131,101,95,248,202,80,211,175,7,180,97,146,238,85,9,74,218,93,38,227,151,51,27,113,21,12,252,132,16,2,241,240,250,107,4,126,149,105,139,145,226,95,120,188,95,70,84,80,183,148,205,90,154,119,176,119,254,48,142,131,34,115,254,47,20,190,3,233,250,61,64,166,83,67,206,98,135,219,190,220,55,17,142,10,252,150,45,38,98,241,109,200,157,54,171,169,248,243,179,230,5,208,200,8,182,39,51,4,5,5,144,102,50,133,112,176,38,220,70,47,78,185,179,245,208,148,156,58,217,6,129,132,27,228,52,64,182,44,190,229,21,21,63,4,26,119,200,218,95,221,12,243,31,122,20,169,147,149,29,117,163,156,232,238,7,163,245,44,126,15,234,150,79,168,49,174,31,91,212,0,33,204,64,200,219,91,85,255,28,114,71,128,216,197,36,139,144,158,203,221,73,112,165,180,49,8,150,174,50,85,48,99,144,157,138,90,123,110,86,203,196,252,242,84,245,194,52,131,243,234,211,87,24,18,224,125,223,60,112,71,164,104,89,165,147,134,38,33,207,207,254,111,14,250,175,215,169,58,63,0,13,185,13,67,181,77,103,94,253,209,16,63,227,32,244,74,16,38,180,10,13,204,202,227,4,127,94,19,230,190,115,188,181,176,208,200,243,196,113,19,138,246,143,100,175,89,41,194,29,187,146,129,209,25,163,41,181,221,96,221,147,110,192,205,229,228,210,173,232,171,146,10,174,101,194,73,113,28,103,110,46,47,52,31,84,180,10,32,148,79,154,193,104,80,74,247,161,53,107,225,50,100,9,236,34,157,47,76,68,178,139,220,110,238,186,202,131,167,116,105,36,209,36,179,95,45,198,158,218,37,127,199,178,21,52,254,2,239,147,251,70,185,89,138,190,16,91,182,36,85,63,84,194,19,228,249,23,24,17,106,18,30,11,123,224,214,190,56,30,1,223,14,72,5,83,79,133,230,43,77,136,32,7,221,245,95,95,5,55,13,55,145,33,38,214,35,5,74,235,9,122,247,110,227,55,22,106,29,179,168,55,196,156,29,221,57,60,196,61,19,186,87,83,225,239,247,125,246,55,28,168,104,226,235,62,224,89,253,145,197,89,193,136,37,24,210,71,184,139,112,15,139,143,156,191,38,131,160,115,105,4,37,137,66,198,196,28,236,85,214,196,5,211,48,138,75,13,176,189,94,244,142,186,4,90,8,17,33,158,249,43,62,69,246,243,41,107,42,158,181,45,120,103,30,129,64,36,116,1,5,219,179,55,205,104,50,11,214,233,156,237,155,138,72,99,108,89,113,89,208,168,183,223,103,227,169,137,144,247,193,176,185,21,41,29,158,14,28,106,89,168,90,168,166,85,132,91,200,129,95,81,204,28,184,111,46,53,51,219,134,197,93,46,134,194,147,168,36,192,107,76,246,109,235,158,50,109,134,119,183,41,1,168,206,223,181,66,166,166,113,117,133,250,204,89,223,45,12,60,29,235,91,23,122,81,48,6,85,189,79,233,246,207,251,152,182,20,174,205,14,125,3,253,199,173,192,136,21,41,144,159,143,112,236,13,15,181,233,128,77,84,172,153,93,9,191,192,152,2,206,177,5,193,3,253,227,104,67,162,128,59,85,235,158,170,84,85,127,44,139,45,193,121,6,60,182,88,100,230,131,3,177,67,198,124,153,105,202,131,73,139,170,43,57,49,167,244,6,37,134,37,118,155,122,102,138,191,190,188,213,49,195,156,208,95,156,137,176,235,97,108,133,229,224,39,51,166,249,69,20,195,179,74,240,13,28,247,85,129,135,9,62,212,152,111,244,213,40,25,150,172,127,16,132,254,236,248,37,11,161,75,86,212,191,60,100,61,84,162,30,82,29,29,140,85,4,234,107,228,47,198,46,100,45,114,232,101,80,231,173,12,128,159,42,176,40,134,11,44,246,184,193,179,191,223,176,163,126,255,209,35,11,175,57,142,4,95,24,93,51,91,150,255,221,34,12,24,203,241,253,193,59,58,44,253,125,114,144,151,0,204,90,190,9,67,187,42,81,87,83,249,163,47,170,232,35,121,167,158,1,133,219,177,242,232,117,7,199,181,29,255,134,28,160,24,176,48,44,195,203,139,206,37,66,214,224,3,91,240,157,76,59,60,14,173,43,191,115,131,117,171,219,239,71,55,1,102,65,159,236,177,192,105,90,42,118,62,222,106,148,175,129,176,20,127,149,43,37,201,146,220,202,137,193,179,141,133,74,187,110,7,22,115,29,132,17,223,19,138,178,97,141,161,247,189,89,198,81,91,41,204,116,110,190,128,0,178,140,142,147,129,249,78,164,116,150,119,99,142,50,17,107,53,150,231,151,179,8,191,9,61,156,165,225,41,88,43,218,138,129,30,126,33,145,14,76,50,51,244,90,125,122,187,163,67,247,136,77,148,228,166,10,126,203,46,73,9,155,177,170,203,18,26,207,91,239,4,64,210,187,229,19,211,74,67,72,10,84,215,73,205,173,131,53,250,238,126,205,136,80,152,62,57,51,7,187,192,208,248,8,68,243,22,244,106,158,18,80,150,77,109,242,250,77,2,12,186,168,17,48,45,120,64,82,49,211,104,192,153,176,35,43,117,117,191,155,49,90,191,69,31,116,45,143,83,122,150,59,57,148,86,81,42,213,177,197,52,116,178,120,253,91,131,198,154,220,250,49,153,179,160,77,161,122,194,68,211,16,36,42,251,29,123,99,114,179,74,162,142,57,248,62,96,229,45,34,158,214,97,188,110,150,184,148,187,124,97,155,197,37,199,135,13,99,247,99,74,172,162,202,65,180,152,175,162,131,205,184,119,141,206,106,224,92,160,219,33,18,134,192,139,25,129,10,194,18,32,241,229,125,119,37,184,175,187,167,187,255,89,80,92,250,204,119,141,200,58,18,19,110,211,132,142,130,12,179,80,213,164,252,171,165,159,126,26,174,24,9,196,175,1,246,115,231,161,160,99,225,151,155,190,90,219,234,207,115,104,72,219,98,76,9,238,205,90,131,225,169,98,80,186,19,234,45,108,110,130,226,12,194,55,233,249,123,81,184,200,10,126,129,190,59,0,175,109,233,85,17,25,95,116,33,31,29,37,135,87,27,154,36,98,193,247,175,176,185,213,52,57,91,168,47,139,64,7,86,232,243,207,181,241,90,192,207,223,136,54,231,162,245,162,133,252,76,22,39,167,163,83,220,191,40,95,162,12,194,104,21,183,22,196,159,58,159,174,45,216,83,235,7,77,242,140,195,84,109,167,90,169,31,99,116,234,12,131,227,132,157,250,85,77,94,126,180,9,224,74,245,252,191,57,124,210,70,14,145,22,94,163,77,146,129,93,6,85,185,200,208,153,79,99,223,140,143,226,149,172,54,205,116,54,103,228,134,201,152,230,184,97,188,10,136,69,182,213,195,153,145,50,223,133,215,54,1,55,199,112,161,214,42,71,46,81,56,248,70,78,220,183,184,50,88,237,131,220,199,251,202,117,6,163,194,209,19,172,97,29,68,4,188,246,55,11,238,127,123,157,123,254,235,182,3,245,51,76,202,67,142,8,237,203,244,108,215,230,30,145,29,138,108,1,251,115,164,53,49,73,166,51,189,108,212,121,154,40,111,47,90,209,239,211,255,244,115,123,243,191,249,180,193,72,22,224,29,39,149,107,102,12,114,152,226,233,69,135,162,205,185,11,105,227,211,199,133,152,204,82,71,160,239,181,216,16,102,19,163,237,61,181,122,56,238,0,86,133,157,158,28,22,101,101,246,32,159,18,16,217,187,14,182,83,234,161,166,174,209,113,92,46,162,210,23,162,163,79,110,194,231,69,34,10,7,203,220,90,46,48,249,150,123,84,94,251,231,195,182,15,90,124,111,38,142,172,211,56,14,17,168,170,197,202,50,46,254,127,227,7,34,242,34,114,150,136,77,115,214,93,197,133,230,224,78,68,42,169,231,198,48,208,249,210,7,7,211,176,222,180,13,64,5,180,193,20,241,66,145,73,158,55,216,240,88,18,206,167,55,223,167,95,171,36,106,33,242,32,97,51,233,133,137,155,166,218,82,122,102,182,95,127,80,47,113,205,150,167,121,184,18,84,103,71,40,193,158,101,115,142,246,111,129,130,89,143,74,235,149,51,216,122,127,75,14,75,217,170,20,142,132,235,231,247,145,22,203,234,93,247,180,200,180,217,167,233,180,206,200,45,211,138,219,113,117,141,221,206,152,21,210,182,214,229,56,225,15,194,206,61,169,58,188,67,89,36,251,208,233,88,245,194,104,241,114,130,211,174,233,132,26,196,188,228,24,188,165,180,105,21,114,191,229,226,122,233,134,199,220,182,234,148,101,134,250,146,250,216,166,4,177,201,190,78,48,81,242,62,11,230,45,41,1,99,65,122,239,114,66,4,248,240,57,111,51,82,227,164,84,112,99,182,21,252,133,62,26,20,17,55,46,39,242,232,144,37,23,92,27,152,8,190,45,203,90,34,98,207,152,8,50,73,98,235,88,144,105,31,206,107,90,191,40,47,165,93,146,61,0,33,20,222,64,124,31,117,227,232,76,171,208,39,21,3,99,160,160,146,182,203,223,40,91,5,116,48,177,71,213,176,73,230,65,160,52,214,123,61,43,77,237,141,233,172,138,137,53,22,202,6,29,145,81,136,101,76,251,202,140,65,3,78,193,5,131,253,13,245,241,70,195,131,16,177,36,62,249,45,75,158,205,249,183,138,27,241,71,39,24,141,57,135,246,233,233,165,17,221,75,102,20,169,31,64,98,114,228,10,183,62,222,83,96,32,178,177,248,4,250,175,52,243,139,208,228,174,103,254,108,115,207,2,145,145,69,28,237,243,224,164,49,107,146,230,177,140,37,139,228,251,103,112,135,183,200,71,76,90,39,236,33,147,187,127,38,108,5,237,207,176,190,249,143,148,204,105,17,15,90,4,177,202,172,165,237,150,182,104,29,177,8,129,189,187,172,176,194,232,198,195,39,184,12,10,104,209,228,187,253,7,84,236,46,69,251,228,157,241,146,69,176,6,13,210,251,77,203,202,220,127,121,105,179,18,30,125,130,151,241,198,245,159,77,199,19,142,77,114,77,56,141,124,97,219,57,34,156,11,24,18,177,238,243,184,89,124,176,41,23,17,160,99,101,148,244,126,85,200,177,128,121,76,118,213,3,48,142,125,174,57,21,181,57,2,99,37,68,136,236,205,35,155,173,198,3,54,92,240,91,79,121,78,156,42,138,138,97,224,26,45,130,182,186,158,61,249,160,138,34,134,108,248,209,208,234,134,23,234,35,88,191,219,83,157,93,95,43,26,105,86,213,4,154,229,138,52,40,143,27,215,8,205,216,185,15,195,103,254,76,181,118,33,177,196,184,59,17,51,34,188,122,237,82,1,68,217,234,20,101,86,228,107,8,235,94,33,153,184,54,200,29,180,83,102,124,147,235,9,212,65,155,84,61,56,30,216,177,64,240,51,218,128,65,0,86,234,4,125,241,100,160,188,244,11,48,243,9,52,230,113,174,2,80,40,59,237,248,49,53,93,10,4,247,193,53,33,65,51,57,196,87,48,216,162,105,253,161,121,249,34,18,154,30,45,94,154,28,81,182,165,35,96,195,213,106,214,192,75,169,242,232,24,23,232,186,52,117,88,173,247,236,92,184,122,37,173,133,189,97,17,120,254,96,144,246,205,174,159,117,41,124,64,239,7,196,8,230,79,227,121,45,244,164,202,237,119,177,25,237,53,91,68,10,175,134,41,148,93,128,1,122,2,132,243,46,39,151,131,76,178,64,84,34,131,174,245,43,238,21,109,65,82,179,40,249,61,69,251,58,162,194,175,161,171,254,211,164,244,171,71,159,124,180,177,226,84,29,119,177,61,200,52,124,196,230,93,42,95,232,152,235,112,176,204,19,226,177,168,142,2,136,133,252,218,150,233,73,205,194,208,78,148,138,41,12,214,36,102,156,111,188,146,119,93,94,88,146,241,85,193,238,84,143,39,49,84,22,38,135,32,34,49,150,18,243,11,172,149,173,115,207,179,79,73,136,107,196,69,35,205,183,161,238,142,144,42,31,83,93,42,236,92,170,177,145,49,153,151,222,28,205,232,222,9,176,43,63,214,181,210,146,225,220,79,108,190,70,237,67,79,104,66,50,172,188,184,145,29,57,25,250,241,53,214,176,233,49,191,116,158,211,88,25,162,247,158,158,21,74,228,89,174,44,52,74,182,140,194,159,243,219,242,142,108,208,19,170,14,220,126,15,218,165,141,198,127,92,208,134,195,142,228,114,217,186,137,20,102,151,121,169,140,192,134,254,122,200,28,185,48,231,239,241,183,40,63,176,5,32,182,131,35,75,38,237,228,71,66,17,100,229,233,28,63,98,218,159,120,114,239,216,236,177,178,23,191,201,25,106,144,67,107,198,253,132,29,140,55,116,217,55,95,78,113,105,123,194,210,246,218,59,68,120,160,161,126,208,67,105,21,190,185,212,93,241,135,139,24,140,88,150,167,50,58,187,39,239,46,235,113,56,87,137,159,185,69,97,77,89,175,171,72,203,246,79,132,187,137,111,36,209,32,98,201,19,186,197,141,2,44,196,214,38,99,140,243,195,105,10,59,201,173,70,148,20,19,37,190,24,247,109,200,109,178,127,72,234,56,64,57,175,93,213,248,24,77,255,124,153,44,135,161,141,111,144,68,187,237,66,25,245,37,103,206,205,26,205,72,88,168,229,60,233,134,66,192,192,171,120,65,202,113,59,202,228,23,147,82,36,211,78,125,162,209,114,29,99,100,122,183,196,8,8,199,161,63,97,17,119,80,111,142,215,244,241,60,132,193,210,255,151,5,77,33,102,167,226,168,90,193,120,31,154,13,34,163,130,138,113,227,210,132,190,30,153,16,27,159,246,219,215,21,127,175,43,192,203,22,32,153,129,96,192,78,13,23,144,210,222,29,54,141,25,98,66,251,148,114,82,219,245,232,234,225,101,52,151,150,206,169,175,140,25,72,152,162,155,26,193,72,188,28,211,79,98,40,176,5,185,126,237,60,39,174,138,197,46,46,124,89,26,49,214,42,236,50,29,16,118,182,157,85,29,251,83,128,23,252,132,194,171,41,186,125,57,80,81,245,60,94,70,240,27,114,2,225,54,142,136,203,222,36,218,86,249,86,204,241,18,46,132,112,23,98,246,48,216,218,25,238,115,75,45,204,47,84,212,222,6,37,209,64,239,19,101,239,99,164,8,210,60,196,50,207,105,1,130,238,216,164,14,78,173,45,88,2,107,158,236,125,30,17,129,210,134,199,212,140,68,231,232,183,242,254,144,59,135,137,225,36,49,138,128,221,203,94,167,121,218,82,217,241,42,58,169,207,221,218,130,98,60,219,129,174,186,75,43,246,240,125,209,41,137,177,203,206,154,154,188,207,42,237,231,143,239,214,229,97,129,132,176,67,236,25,133,44,97,12,86,62,179,38,195,51,109,84,37,124,90,140,24,111,33,211,72,134,63,90,92,87,25,26,4,109,40,132,166,151,73,186,130,100,182,192,70,239,140,1,27,57,106,184,139,251,117,30,129,119,115,49,215,246,146,81,115,18,18,168,108,212,211,150,242,11,222,186,47,17,185,34,104,163,216,218,196,135,60,100,251,228,203,82,133,181,70,218,202,98,191,157,40,252,89,108,101,28,208,6,14,189,202,111,175,100,76,47,158,136,168,104,255,24,22,149,99,55,18,53,72,218,146,145,59,214,185,166,46,117,115,204,32,18,30,234,38,251,255,89,144,136,201,49,33,188,181,18,147,204,135,155,67,138,204,231,234,224,205,183,112,89,156,75,80,239,92,254,119,216,5,225,121,223,77,103,56,88,112,148,141,116,167,166,173,16,88,227,93,14,68,48,202,144,185,234,97,133,53,176,132,206,104,4,117,113,148,63,106,73,153,0,199,26,1,141,190,104,169,231,21,15,202,32,145,186,212,134,92,64,46,174,72,81,9,252,16,254,229,251,178,123,6,14,102,49,21,105,251,177,128,51,88,134,119,249,117,41,53,104,108,108,102,120,246,72,110,237,2,83,248,77,182,97,156,216,134,16,218,49,116,13,235,176,195,126,142,63,92,72,135,116,51,194,90,7,72,237,30,118,194,149,193,187,157,213,125,40,142,96,131,36,4,59,84,126,11,11,231,147,68,21,105,242,230,9,178,139,126,204,47,179,171,56,112,227,129,58,6,31,230,76,33,95,42,167,168,159,216,134,250,156,144,255,161,202,9,23,144,15,222,98,75,237,129,66,24,14,211,229,233,202,33,226,235,58,125,75,122,11,105,20,241,187,187,139,26,20,95,129,13,154,117,10,214,120,172,250,122,193,157,94,93,120,64,89,45,201,99,69,238,189,29,216,125,103,99,193,142,102,94,226,226,234,152,120,166,129,37,66,169,218,2,149,207,198,155,13,107,221,236,55,67,238,242,41,167,47,200,150,112,184,228,243,232,169,60,234,166,20,223,96,6,102,26,50,252,203,131,78,158,208,10,142,168,211,113,255,99,31,108,230,102,95,28,112,77,100,55,128,180,51,190,89,106,160,230,116,71,6,210,243,102,11,236,253,142,8,48,2,166,38,214,167,83,146,19,216,155,248,49,134,40,188,9,103,236,65,241,15,241,172,227,40,214,5,52,173,79,218,50,9,26,42,100,120,160,167,203,233,83,53,165,152,47,60,37,246,112,237,188,58,182,171,227,185,212,106,3,112,207,37,37,187,158,102,107,37,27,253,113,187,163,135,216,19,236,212,159,252,116,228,166,185,159,60,186,50,254,115,67,85,252,132,30,0,118,97,3,42,18,76,189,27,43,144,215,108,222,117,228,224,133,44,170,205,156,9,55,180,81,107,154,19,50,111,152,134,209,37,122,227,212,46,55,232,142,227,188,99,130,191,90,217,71,156,33,104,203,228,207,64,181,233,32,202,189,148,34,211,222,2,121,5,193,112,61,44,149,38,51,58,253,179,26,186,176,248,233,129,56,190,185,160,109,44,61,178,109,59,112,60,19,238,31,27,147,250,146,188,61,119,207,115,9,164,34,61,166,186,212,236,130,186,87,48,64,51,9,88,223,115,167,178,68,253,187,6,55,110,9,169,150,153,134,52,77,153,139,147,27,28,178,230,112,77,56,177,237,39,211,92,2,59,249,186,152,160,147,233,160,135,34,174,89,190,114,18,245,17,154,209,34,214,226,49,126,36,47,32,77,57,52,102,143,251,112,96,128,2,177,26,174,147,242,51,99,179,39,12,100,132,250,223,210,42,67,80,115,107,161,100,28,72,119,164,169,249,14,42,124,145,96,119,208,102,53,26,42,126,245,51,148,136,186,69,80,209,172,176,45,168,254,99,222,236,84,161,206,246,182,154,241,80,33,36,197,97,132,10,78,214,31,162,252,178,8,65,17,208,60,144,135,50,6,181,251,250,147,0,202,241,223,70,134,81,124,28,66,253,233,139,241,22,181,241,161,55,172,241,95,83,78,115,134,108,25,96,218,86,233,156,226,222,246,43,46,121,26,109,49,17,102,135,208,62,140,39,148,172,144,75,1,156,157,77,188,89,74,173,198,233,240,184,233,97,38,80,217,123,204,9,94,12,209,241,183,179,38,99,101,227,68,172,165,49,200,175,140,126,192,220,169,9,252,11,210,186,9,225,216,33,20,90,222,86,217,157,195,150,199,100,29,235,169,181,67,98,133,98,171,181,9,223,255,67,130,240,81,173,255,237,181,203,123,227,188,253,181,118,224,113,77,21,180,220,53,3,144,120,155,11,226,70,148,68,27,74,11,8,83,121,122,23,123,205,219,247,95,234,131,28,187,118,215,139,57,136,105,190,245,208,79,141,3,201,51,80,218,81,31,238,22,1,12,175,230,195,178,147,83,114,86,246,111,240,67,61,188,39,1,142,186,151,36,56,10,140,116,34,156,112,37,230,230,188,65,10,133,216,75,117,22,243,190,219,12,213,58,77,88,90,79,152,57,4,149,224,196,73,201,98,232,90,104,126,242,141,128,0,137,162,195,205,149,213,233,114,113,9,217,3,16,139,97,126,84,188,121,78,18,107,205,87,68,31,152,11,190,207,180,116,17,43,76,252,110,127,150,185,146,107,156,112,53,117,109,71,44,28,154,233,145,207,37,1,178,94,6,138,105,53,168,143,127,6,200,126,128,128,76,77,153,144,62,55,227,41,47,244,221,75,230,36,163,169,116,231,90,32,218,103,230,190,65,48,36,101,137,46,84,228,164,141,223,166,114,152,6,77,70,229,36,208,237,218,203,196,61,212,234,70,159,67,246,157,149,251,95,69,189,144,177,112,154,65,3,212,202,38,35,15,200,57,32,127,3,107,194,85,180,110,148,173,80,141,216,33,134,86,191,90,163,137,37,111,150,253,187,246,126,198,236,0,243,80,216,21,29,137,218,89,246,228,9,134,206,231,58,73,64,109,251,223,156,121,28,47,56,84,57,171,37,117,199,194,194,47,12,174,104,50,225,68,218,200,211,216,88,127,234,174,180,8,58,193,154,196,250,233,45,106,26,173,159,92,251,87,244,112,114,130,186,247,137,153,249,129,13,206,5,229,43,165,176,76,221,145,84,105,33,222,143,15,75,128,192,11,246,239,100,241,15,23,233,124,83,145,238,160,57,66,34,46,66,213,165,110,156,147,116,5,115,44,214,215,6,188,117,115,234,104,30,134,176,144,74,54,43,189,80,44,78,240,15,31,196,150,150,130,63,118,18,236,138,214,209,178,164,111,222,185,148,164,154,96,213,117,22,196,247,114,181,146,225,27,240,167,93,124,107,16,1,179,200,239,4,144,54,197,159,254,250,192,142,145,249,135,169,7,13,219,116,250,254,118,142,87,180,145,164,177,86,245,92,225,46,231,105,199,115,154,213,149,162,184,152,236,112,93,7,162,209,103,184,156,203,121,99,209,0,145,56,134,50,209,92,105,181,198,150,72,141,122,1,110,197,92,235,249,144,139,158,194,128,211,229,123,187,246,255,138,147,96,181,123,206,12,175,42,209,92,166,231,249,130,234,43,6,224,66,103,247,47,69,70,32,169,83,171,209,159,2,17,252,211,167,35,216,167,172,18,126,156,10,13,244,56,67,4,166,105,234,166,125,174,97,54,225,174,251,221,151,215,104,181,82,219,245,81,104,147,0,140,50,90,52,62,76,114,229,188,116,75,3,137,122,252,96,10,140,72,228,193,243,161,112,166,1,70,45,200,167,78,58,2,89,234,235,123,86,200,235,170,68,166,133,7,227,152,194,110,16,207,46,49,96,121,171,64,196,235,57,80,94,156,10,43,122,181,243,13,162,104,210,251,176,227,193,128,101,140,99,175,26,241,148,38,22,248,239,159,101,227,194,213,101,89,21,221,163,113,161,67,215,164,126,14,106,87,13,200,191,81,162,77,236,209,251,6,83,248,226,169,66,42,233,142,26,194,16,201,185,80,222,60,89,210,170,104,6,184,2,152,81,52,50,120,205,183,222,191,115,92,98,72,254,163,203,243,44,238,234,7,14,188,191,58,138,74,198,208,236,56,152,6,234,247,23,21,179,101,23,41,214,59,148,41,222,217,70,204,47,230,248,118,174,44,80,94,209,185,212,183,91,197,206,34,11,105,16,213,253,129,101,51,89,235,135,131,7,205,5,71,121,41,3,5,107,74,186,201,71,21,201,220,234,237,118,226,124,156,160,89,196,31,190,233,162,249,9,72,233,188,60,183,12,192,204,4,230,35,104,61,180,70,51,59,49,87,168,168,90,11,176,52,127,197,33,99,13,82,31,16,47,174,110,226,126,11,47,243,85,139,24,162,221,178,152,66,74,204,197,114,175,243,6,57,126,13,231,136,154,28,227,170,166,254,137,19,46,235,64,213,250,102,66,64,16,94,44,33,179,87,188,244,32,149,201,149,180,237,182,102,128,248,87,10,215,86,22,118,167,133,150,241,177,99,126,195,137,111,100,158,161,193,39,40,243,217,62,59,34,211,42,255,15,158,16,249,105,104,117,60,89,68,217,222,171,144,27,134,113,22,1,114,117,181,239,168,51,119,113,172,169,109,157,53,98,226,79,27,194,25,134,141,84,113,212,128,187,175,214,215,100,58,51,122,172,78,0,72,142,141,83,64,224,53,198,148,115,100,174,44,172,242,74,251,223,209,5,119,78,127,221,76,191,34,63,163,167,116,242,50,164,155,237,234,137,164,56,7,128,20,86,181,152,199,194,43,237,49,192,235,251,83,154,234,153,98,183,181,224,12,212,54,49,158,56,237,152,122,6,220,123,37,111,106,33,244,176,230,46,81,213,195,128,81,216,127,212,60,150,255,9,55,80,34,116,3,16,161,216,114,116,68,58,237,105,205,185,8,180,99,199,207,193,108,39,99,121,198,251,127,228,162,220,150,71,179,51,225,100,220,87,216,250,172,108,155,96,32,244,205,16,136,153,8,73,241,24,253,215,67,218,21,51,41,81,112,5,216,184,175,239,184,44,215,213,8,18,89,151,124,174,133,162,97,152,27,213,12,105,113,165,59,57,99,1,30,203,19,35,173,38,25,114,203,34,52,67,144,227,73,34,139,245,106,216,39,213,25,230,199,67,63,7,239,205,143,53,229,62,133,156,176,48,115,237,158,84,3,109,18,107,57,119,37,250,52,20,146,245,55,115,254,8,36,174,38,51,50,134,105,45,237,216,229,28,75,32,194,210,92,34,253,26,215,11,80,4,123,160,132,40,164,214,80,51,41,240,225,77,95,149,207,79,192,12,254,8,99,67,209,14,135,45,230,26,181,1,13,224,96,31,106,210,89,104,67,79,9,130,53,16,36,254,125,96,222,57,141,211,252,64,13,9,89,43,7,72,222,131,178,233,75,227,174,9,112,48,216,246,11,169,159,84,168,114,234,22,66,139,117,124,2,36,161,54,242,151,230,146,88,74,60,71,120,183,150,35,59,233,113,191,207,14,230,212,68,112,41,43,140,7,96,154,215,196,121,172,161,174,216,123,162,226,176,32,40,108,106,111,159,149,40,68,87,93,205,40,29,210,60,44,82,232,242,228,21,110,116,217,43,159,121,149,93,246,239,40,160,164,56,213,113,140,176,168,160,69,191,15,238,107,199,167,243,64,27,196,5,3,16,107,118,29,244,57,73,231,188,237,62,144,59,116,108,238,226,198,21,117,82,161,34,22,63,95,22,206,9,156,193,37,111,6,42,52,39,154,190,204,129,230,141,227,89,66,42,151,191,148,27,113,54,110,198,178,107,108,44,20,47,124,27,254,5,67,22,26,82,83,169,117,67,50,37,101,28,50,229,53,234,122,58,60,190,40,77,206,118,245,143,3,0,228,29,149,74,59,240,226,24,136,127,89,24,232,19,6,128,176,216,211,86,56,127,72,28,45,83,147,135,222,211,184,19,74,241,120,232,172,49,129,216,166,17,176,214,255,224,151,186,239,225,61,132,90,165,178,99,56,7,174,251,83,10,235,185,40,82,188,36,102,199,75,225,238,243,103,59,92,123,22,174,139,3,147,90,145,194,79,99,241,120,244,204,60,163,247,243,77,61,8,95,240,192,16,13,53,12,60,32,182,139,34,175,48,230,136,119,84,219,174,1,79,17,208,27,245,189,218,195,85,221,62,207,94,65,115,96,56,228,173,98,42,108,19,3,138,197,69,27,193,16,228,51,198,44,110,146,12,97,32,83,48,31,114,207,104,187,162,243,242,247,232,234,166,20,39,156,107,161,145,244,34,78,134,147,104,96,78,246,244,68,78,148,40,87,111,31,4,41,4,211,142,116,4,193,203,23,114,162,220,84,175,118,117,82,55,137,180,172,198,97,231,0,79,73,233,142,240,182,252,230,251,231,36,223,133,95,40,32,181,102,196,84,64,15,39,127,185,204,239,10,18,36,139,117,238,104,200,217,127,104,87,24,38,99,163,87,154,97,179,34,156,95,111,249,241,157,200,58,236,13,180,186,52,42,49,213,137,17,209,101,111,148,47,96,255,145,89,45,59,148,203,78,27,252,139,168,122,29,157,79,242,13,110,186,212,68,192,241,42,148,81,250,162,100,175,169,93,40,162,147,121,231,112,242,86,171,6,193,98,114,39,14,145,36,170,117,236,228,95,55,207,188,225,147,28,95,159,168,251,47,76,207,145,122,65,128,169,62,67,102,90,190,109,24,4,156,18,101,143,149,232,19,180,204,76,249,57,245,1,77,96,57,109,135,70,159,115,255,206,150,34,198,11,81,246,229,213,8,204,236,172,62,90,102,113,91,237,57,216,13,74,154,6,39,42,38,77,108,160,72,92,118,75,181,149,65,182,186,16,95,83,211,48,24,193,144,223,40,227,158,26,208,247,189,122,142,117,214,108,236,175,56,236,206,191,168,155,72,142,135,142,79,182,54,191,246,15,193,115,231,87,252,140,22,114,53,3,249,142,7,91,13,157,128,224,240,164,160,56,9,122,214,30,97,215,112,11,135,247,68,95,21,108,73,200,119,207,211,188,101,99,130,145,206,1,224,67,104,137,244,66,76,80,176,251,109,211,185,195,36,106,48,249,241,207,53,75,32,243,140,131,189,145,179,175,114,204,29,34,150,155,219,76,236,173,158,123,217,21,168,4,205,35,155,171,162,151,15,240,153,95,116,55,228,12,157,132,35,119,231,157,236,46,58,133,79,4,9,182,43,203,190,179,43,120,158,24,111,112,12,235,68,127,110,93,140,75,162,47,234,182,107,38,32,126,42,42,76,111,128,221,165,121,104,182,59,229,253,81,16,169,201,206,120,166,117,22,101,81,229,68,6,146,221,147,214,232,69,252,31,90,41,252,253,87,41,152,253,185,71,34,109,240,138,22,185,155,2,166,238,19,111,75,34,95,107,74,88,12,245,160,233,15,77,236,194,191,246,96,232,3,199,212,9,17,195,247,67,41,109,201,205,75,31,253,39,131,117,213,176,70,184,82,33,105,112,154,229,226,181,237,71,168,231,250,158,80,13,224,144,77,69,87,220,87,250,99,214,251,60,44,186,116,133,142,253,252,138,177,212,33,139,103,109,146,18,104,78,122,29,206,10,9,36,122,213,172,236,41,253,57,71,219,96,104,206,53,119,51,188,240,137,196,123,175,28,30,254,54,46,53,254,113,8,224,150,9,220,226,83,42,41,171,184,252,108,136,231,94,171,154,108,89,46,45,89,15,121,44,145,94,184,58,181,67,119,114,14,51,142,206,146,167,38,13,189,95,195,244,2,142,236,72,234,51,163,137,130,149,6,124,209,254,233,4,206,188,247,242,75,84,229,50,34,235,200,232,1,9,252,176,66,91,184,99,168,173,174,79,255,18,101,184,196,35,185,209,238,52,182,197,84,126,50,147,248,171,46,244,16,138,229,44,179,202,9,72,20,75,64,83,119,54,229,87,158,204,125,37,18,81,250,150,121,117,208,69,4,32,26,148,214,219,140,8,180,199,77,143,84,202,209,178,14,227,103,6,118,27,87,208,26,247,60,60,44,239,249,28,47,148,38,197,215,7,226,118,135,58,15,139,125,162,252,220,186,205,25,177,150,148,104,56,175,122,30,207,123,199,160,156,95,132,160,178,88,46,224,19,30,14,56,228,85,94,48,69,45,146,240,213,196,194,125,4,178,153,52,21,103,145,160,23,44,153,126,209,44,246,193,94,0,199,59,221,153,95,185,242,95,151,93,150,249,204,96,9,111,144,169,199,71,252,159,80,64,68,40,139,66,86,192,81,140,207,169,157,207,89,0,36,195,63,202,154,107,131,244,237,102,250,111,179,236,113,16,218,132,209,164,130,49,145,167,163,177,25,24,84,45,48,56,67,244,233,20,2,141,237,54,179,118,173,29,45,3,237,76,236,175,112,107,222,239,89,218,147,17,240,87,15,144,103,104,154,227,254,171,61,182,26,68,17,76,6,55,254,78,42,173,182,109,39,121,108,37,199,26,66,179,115,84,152,10,177,31,131,22,30,5,51,129,112,22,227,177,135,108,135,234,129,66,93,137,16,76,9,20,14,63,166,70,220,20,193,115,120,6,188,95,111,93,89,17,65,63,30,3,156,73,38,8,84,111,211,96,169,170,56,118,14,40,2,8,80,118,37,205,203,87,193,32,242,215,165,128,203,130,11,12,20,192,77,134,67,252,254,174,215,3,28,188,4,91,166,107,11,177,203,133,56,178,31,63,111,63,7,53,28,238,138,116,189,121,160,73,103,115,156,239,214,36,217,90,58,245,101,84,83,174,147,175,66,34,130,82,192,190,244,95,163,101,51,163,248,60,122,250,17,124,242,147,32,17,28,187,114,176,205,221,240,167,5,94,152,195,151,250,172,132,129,214,35,13,53,170,93,15,242,85,161,30,231,45,241,47,70,62,246,145,72,166,49,76,185,86,180,209,104,7,65,138,10,202,69,59,118,180,101,213,158,133,180,155,6,46,55,54,36,181,15,100,196,149,120,36,63,53,255,86,112,10,9,248,82,7,87,225,58,210,238,186,6,163,140,187,195,183,238,214,76,47,0,217,36,77,178,89,189,82,91,174,223,118,106,56,14,207,37,86,139,213,19,94,19,51,44,191,54,131,215,85,217,220,106,233,57,193,255,43,22,253,163,114,134,131,98,104,105,217,93,172,103,189,78,150,94,151,137,1,2,50,162,168,19,33,105,103,135,90,175,8,95,23,162,119,223,83,199,207,106,164,59,5,11,36,170,95,197,173,70,168,203,152,240,43,53,225,50,51,46,13,106,187,203,110,255,114,200,214,163,57,242,255,2,235,164,34,164,160,188,199,173,189,143,182,68,210,220,165,88,179,192,19,162,5,54,32,144,207,56,205,132,89,190,81,163,123,28,191,0,116,4,35,201,61,7,253,222,90,135,102,112,87,88,85,50,73,119,97,144,243,216,86,202,175,209,63,186,69,166,230,100,249,46,18,247,232,88,172,186,148,193,142,244,14,98,214,249,193,191,34,193,176,44,126,137,251,75,181,60,255,38,244,177,239,43,79,99,20,157,149,100,73,237,30,204,37,31,85,79,145,32,15,117,251,90,48,251,223,255,188,3,189,62,186,103,98,212,77,232,158,217,208,191,105,69,221,72,160,233,188,48,58,11,184,107,220,102,249,66,173,7,107,37,196,41,212,223,251,70,134,20,147,220,236,122,172,55,18,234,77,115,181,168,154,243,58,25,39,236,204,179,7,94,67,174,94,2,91,203,174,164,45,175,137,141,113,177,148,224,253,90,130,45,75,18,145,188,198,2,179,40,255,154,232,215,107,113,146,164,164,147,168,244,209,136,27,1,24,255,4,191,99,155,167,161,41,19,240,35,28,226,14,110,250,87,123,86,181,166,101,241,240,182,170,126,96,187,163,180,144,92,185,197,156,147,237,101,120,211,249,72,175,84,183,150,207,211,35,53,54,70,245,168,106,181,153,68,113,220,177,133,222,24,153,113,7,68,195,0,233,73,51,80,229,205,8,78,58,157,182,216,190,222,245,105,165,204,36,202,86,223,162,46,248,135,65,138,246,114,143,2,35,193,84,133,157,105,91,28,177,96,108,201,152,136,202,84,50,153,182,21,250,114,190,30,26,5,147,171,98,218,113,249,160,152,210,223,195,40,12,180,0,102,237,131,247,108,209,27,90,111,25,135,182,11,109,102,224,15,152,180,60,117,110,134,176,178,175,62,49,34,229,113,48,226,165,195,254,82,54,104,185,173,81,142,244,59,162,123,254,101,39,180,75,4,77,179,149,131,121,219,232,190,15,106,120,199,60,249,111,101,136,74,123,207,171,177,134,143,78,17,244,66,151,12,37,73,230,40,135,237,221,119,232,121,92,188,196,190,65,169,60,48,222,78,244,26,12,13,67,99,149,136,30,47,160,120,230,15,125,204,162,223,148,41,16,127,115,159,148,76,172,129,12,152,73,137,162,66,98,66,172,253,146,66,240,183,182,159,77,24,208,131,153,65,247,244,110,35,99,102,168,228,155,155,134,7,34,37,229,241,93,157,209,107,233,184,206,146,4,233,172,143,96,214,19,116,136,183,78,173,40,150,120,74,115,205,7,81,142,21,232,35,96,250,181,69,185,86,22,31,190,171,71,0,38,117,155,57,234,181,160,88,241,135,157,176,106,209,50,22,160,182,231,74,121,26,208,76,76,223,27,130,153,90,170,31,194,125,132,217,49,144,236,115,247,84,80,24,128,199,220,60,51,221,48,203,69,180,149,46,10,245,171,96,40,212,116,255,88,10,145,252,103,125,252,5,72,97,80,47,201,85,109,57,159,179,174,249,20,112,136,186,203,173,61,179,3,210,57,112,149,104,3,58,56,168,48,196,31,117,219,176,224,4,203,29,74,214,41,104,147,19,165,175,255,250,185,138,50,199,166,107,237,60,204,173,242,87,251,254,195,120,205,56,140,147,66,136,136,124,185,124,215,85,106,145,50,222,154,34,108,16,12,120,87,94,33,198,237,128,63,89,4,9,86,64,224,210,49,234,24,188,188,144,176,159,149,13,57,204,120,53,217,168,211,56,1,132,47,96,112,138,241,251,80,218,13,162,31,222,133,109,64,188,210,4,43,134,207,85,202,12,248,62,246,176,10,218,128,3,137,6,131,222,252,94,231,57,109,105,240,163,69,39,76,192,156,139,85,251,224,234,96,240,186,181,151,180,230,10,6,176,215,146,53,97,127,50,185,155,94,201,120,236,105,59,131,59,208,48,184,207,208,227,122,140,60,250,130,108,45,174,209,148,105,26,115,228,142,251,141,56,86,232,118,154,45,58,119,118,245,179,218,15,106,165,125,143,246,118,237,52,210,110,5,3,187,53,113,192,104,62,38,236,153,220,158,113,80,79,228,96,235,45,147,203,39,49,198,231,183,222,231,246,81,7,125,222,247,30,221,138,171,195,222,147,42,140,171,119,64,180,225,182,19,175,215,26,144,176,178,214,171,103,205,41,50,148,219,57,15,72,7,232,19,217,35,141,102,74,162,57,92,216,166,117,9,62,102,96,229,118,33,172,111,222,159,143,192,141,211,229,86,99,236,173,229,99,75,3,175,158,114,59,160,73,221,186,244,111,77,199,92,186,132,212,242,229,212,155,29,94,62,151,146,252,82,255,182,224,29,71,132,96,7,70,10,12,99,173,182,127,255,201,86,180,82,67,59,22,220,184,20,66,26,46,35,132,219,73,46,171,62,136,89,110,36,161,28,221,128,24,22,157,61,145,238,3,249,216,160,66,151,108,22,139,168,125,80,142,166,38,152,186,220,220,61,113,226,226,238,68,126,19,60,216,230,183,88,153,108,238,29,20,137,67,49,5,97,34,130,162,231,145,142,18,56,103,241,157,45,100,250,191,28,246,106,58,184,164,23,121,35,35,207,206,221,60,108,139,254,43,123,147,180,108,65,51,79,20,58,206,166,0,248,199,119,97,139,182,203,116,136,2,237,172,90,135,50,181,109,187,172,116,226,132,65,133,222,242,128,16,69,109,51,212,121,43,204,167,43,133,162,43,209,203,158,204,19,58,196,225,142,213,16,250,241,29,214,156,100,226,215,94,233,202,253,85,20,130,232,206,145,86,201,129,250,118,84,109,186,189,81,251,110,208,58,3,69,197,204,219,134,68,6,218,171,245,205,87,14,56,214,233,107,56,164,176,63,131,58,219,17,20,53,243,52,192,130,30,226,82,62,142,200,220,197,69,114,21,130,97,135,25,235,16,155,199,189,105,222,43,124,74,252,228,121,28,54,175,69,238,165,176,219,179,33,184,59,57,20,123,114,223,144,172,138,232,86,55,219,49,121,13,208,192,12,204,7,135,51,225,34,253,207,229,216,188,0,31,142,69,212,64,130,144,185,190,138,251,158,160,35,86,45,217,137,141,34,109,230,244,167,93,50,75,150,93,108,216,72,131,17,33,109,57,230,16,233,216,176,218,119,75,73,6,166,40,133,27,209,88,148,238,214,118,176,86,68,60,55,120,87,78,9,6,159,242,217,1,131,9,238,44,193,196,139,153,161,23,15,21,33,7,229,69,204,66,170,229,195,156,184,250,138,83,219,80,234,241,130,162,44,154,211,137,109,182,147,194,129,253,225,48,29,168,3,74,191,80,153,215,235,219,166,179,23,9,70,86,189,56,87,213,133,125,21,9,81,32,235,250,184,38,158,244,238,227,38,73,58,135,60,171,63,65,46,254,116,192,35,113,197,193,111,161,40,222,233,200,143,35,41,6,65,220,2,185,76,87,203,49,26,50,50,20,195,115,114,45,153,67,78,232,180,134,218,67,31,91,11,101,22,6,195,234,53,233,90,170,67,96,43,2,168,152,172,17,46,167,129,111,45,209,186,235,176,164,195,32,33,117,198,3,92,117,217,229,90,24,250,52,99,226,132,196,195,249,185,191,203,7,116,120,197,194,248,70,51,195,54,144,146,145,32,84,78,228,89,199,171,108,59,236,45,169,238,136,130,147,128,5,96,173,46,118,221,216,149,62,23,11,95,189,255,15,175,54,127,136,14,200,143,229,215,80,6,37,35,12,30,149,24,186,206,227,137,162,99,53,41,202,231,151,74,43,81,76,99,113,131,228,204,243,205,99,214,85,83,246,177,187,207,211,246,12,40,210,76,110,41,148,90,121,188,68,9,233,137,162,6,11,236,147,123,52,4,225,250,57,130,223,51,114,50,24,179,176,158,72,170,44,239,144,6,147,98,156,179,115,114,113,178,191,56,91,116,148,28,95,206,63,115,183,8,223,96,35,255,212,51,11,98,62,18,179,227,10,195,34,18,147,21,109,184,246,73,71,187,207,110,209,176,167,21,87,24,80,37,205,34,220,180,22,125,226,171,38,92,156,67,201,65,36,155,151,202,107,118,77,116,219,40,187,108,130,230,209,88,212,91,72,197,82,151,117,81,97,99,101,120,179,49,156,62,2,188,57,150,223,17,218,203,197,125,142,123,64,53,184,11,208,15,196,247,135,45,101,3,171,65,212,27,134,164,24,34,154,255,53,110,201,68,20,140,85,128,152,44,249,241,217,165,11,235,189,108,3,123,25,212,50,153,224,57,99,191,158,64,83,182,108,76,22,148,142,56,152,145,43,207,85,209,209,252,1,147,5,180,233,160,64,131,250,3,113,236,44,7,168,225,161,154,62,66,17,218,0,219,180,101,253,249,125,145,138,245,44,5,141,23,219,48,234,114,238,240,227,186,143,212,234,237,49,109,208,109,30,67,170,85,193,253,41,230,229,32,234,179,15,187,255,229,203,221,39,225,239,172,233,105,210,118,118,89,227,243,4,187,232,63,19,53,35,152,133,241,158,177,89,42,119,129,39,108,247,188,162,237,7,88,163,121,124,204,91,7,222,231,125,53,26,94,193,22,254,14,141,80,217,5,19,125,236,63,42,236,182,76,56,89,126,139,123,77,6,224,39,58,166,181,133,0,60,15,78,118,232,39,195,137,95,21,68,215,33,28,96,174,45,170,99,90,15,91,29,137,195,118,189,69,236,103,236,100,170,4,41,109,207,22,124,205,243,234,205,241,51,120,217,102,41,158,3,157,84,249,78,60,5,130,6,86,135,13,235,92,207,161,246,23,152,219,123,207,28,109,143,143,110,162,65,79,64,175,219,242,10,231,170,119,133,213,213,6,179,84,48,104,124,72,47,103,3,73,242,69,2,58,227,45,78,40,155,24,64,231,33,228,153,69,161,230,127,168,118,218,78,229,237,229,208,175,85,132,161,141,113,207,58,25,246,231,86,125,163,222,82,176,112,140,216,17,110,240,179,31,174,31,182,147,186,10,254,166,233,251,3,131,19,6,93,131,79,138,109,252,9,232,172,83,205,189,208,103,92,39,130,9,98,148,117,104,59,105,24,114,182,241,58,221,188,81,146,227,110,97,100,151,2,59,163,21,38,87,167,131,52,143,84,145,233,99,45,35,42,169,135,202,60,227,19,153,246,97,0,147,232,177,141,158,241,174,55,202,231,106,59,192,93,235,127,37,130,157,111,59,25,160,204,117,79,10,62,136,226,35,159,140,192,55,241,121,210,225,33,223,56,233,152,154,116,147,148,108,74,179,120,137,27,177,222,169,9,192,12,21,206,114,9,78,73,102,65,200,1,66,37,134,6,84,164,114,161,16,170,48,156,207,102,130,217,83,157,171,110,30,48,66,141,224,227,21,51,182,49,129,98,143,122,85,28,4,182,220,88,181,78,22,28,165,199,201,208,235,63,63,61,114,153,232,160,49,104,10,10,57,196,6,29,200,48,88,13,17,61,42,47,96,78,178,196,21,75,111,101,140,55,23,82,188,140,15,234,251,223,95,74,220,186,179,113,86,90,169,152,245,233,36,36,29,16,208,11,54,223,208,170,152,97,20,111,151,37,175,196,161,17,157,61,194,38,30,87,207,125,117,171,227,234,8,8,211,183,24,91,205,91,133,61,127,138,174,99,167,155,54,253,12,219,109,182,158,238,210,253,144,118,149,203,205,51,72,40,64,49,39,22,129,227,175,134,227,60,24,215,142,73,24,7,132,123,50,48,110,249,62,226,71,220,124,187,97,109,33,203,62,176,180,206,214,159,186,3,254,72,82,96,176,147,11,76,230,230,50,228,167,246,135,125,4,94,190,71,236,82,254,131,231,130,26,215,69,160,138,37,132,236,246,53,252,216,159,169,242,252,61,227,109,58,252,176,206,235,64,69,52,207,102,72,128,171,19,231,185,121,243,190,159,27,109,131,47,136,89,198,81,40,138,117,181,42,246,147,125,198,199,73,44,247,194,212,109,35,238,87,12,129,79,197,209,84,148,12,158,238,106,197,112,113,250,82,62,170,42,89,64,43,173,166,173,80,29,73,211,141,25,195,19,82,193,1,128,129,40,115,14,165,30,86,133,168,252,148,153,75,99,62,76,196,169,63,236,168,90,170,50,177,177,192,21,124,156,185,135,73,90,77,86,205,111,216,202,230,175,31,111,159,134,153,227,222,203,180,88,216,16,77,80,115,244,230,0,113,23,237,42,100,7,87,51,43,112,163,91,239,137,101,190,218,243,107,45,44,29,55,148,87,93,138,157,117,11,120,229,240,187,169,60,89,37,75,111,51,143,140,13,158,200,213,55,127,224,246,6,237,99,27,136,191,17,5,171,128,217,216,18,105,188,227,219,79,54,42,208,174,192,52,127,118,223,11,122,149,148,28,61,0,72,254,127,25,11,108,185,19,99,37,70,187,17,152,250,51,63,56,27,63,65,74,47,114,191,251,143,4,117,231,40,8,127,186,81,149,211,5,230,108,94,34,77,218,136,118,87,95,196,219,59,60,222,223,242,48,143,238,2,24,126,50,173,197,45,148,233,116,200,25,23,21,24,124,157,18,41,31,94,75,33,168,182,73,114,88,32,54,249,254,231,176,210,66,156,161,183,202,75,237,56,59,239,198,130,43,245,238,224,191,233,191,125,249,155,99,120,43,144,150,241,114,69,228,99,239,84,48,113,2,4,159,38,131,195,202,150,14,134,128,88,213,141,7,176,136,209,99,2,235,29,74,214,99,148,187,86,11,79,51,182,187,227,65,245,23,232,163,89,211,16,51,194,101,242,185,251,188,99,8,249,206,137,204,83,153,32,226,191,1,246,86,33,152,184,81,212,118,189,57,195,141,90,149,103,15,14,155,86,35,202,44,125,241,130,208,104,9,143,147,227,199,93,243,174,196,222,224,207,73,31,3,87,149,109,191,123,140,240,239,237,194,74,33,244,231,33,242,14,177,251,197,118,202,34,115,98,244,100,107,60,190,151,174,88,52,11,186,120,134,45,94,211,8,225,9,66,193,169,114,166,80,68,8,137,134,236,56,33,79,213,218,180,156,64,240,214,213,218,228,74,161,34,85,133,102,137,7,87,73,18,61,249,129,102,199,203,48,181,151,90,114,189,161,239,100,253,182,232,249,193,192,50,198,143,196,205,183,17,252,90,92,49,26,157,235,171,14,220,68,130,2,194,98,180,25,123,158,64,103,85,6,107,59,221,85,94,129,124,23,177,242,248,140,233,120,26,71,87,246,192,1,156,248,62,194,159,35,225,29,86,22,48,180,251,81,52,104,50,114,64,184,76,124,102,66,187,210,33,49,7,163,220,236,160,59,162,182,42,12,72,35,142,110,29,65,26,42,128,109,175,43,167,142,79,132,226,234,198,94,81,128,39,23,235,132,179,125,201,180,6,75,188,250,129,43,54,87,3,118,1,165,230,36,170,6,207,211,161,24,70,99,110,27,105,254,101,123,63,22,95,50,35,205,78,11,117,173,162,105,30,254,173,106,151,110,19,4,224,128,47,51,98,120,208,26,13,211,25,134,120,112,32,38,179,204,225,147,212,27,67,28,100,42,197,119,59,227,215,195,119,103,34,65,112,110,242,31,170,247,49,171,215,11,51,16,9,99,102,248,234,202,117,144,112,128,21,235,173,125,151,218,90,194,36,0,197,32,73,184,184,241,239,254,130,17,44,28,192,113,229,2,249,46,161,78,63,19,125,1,18,9,142,232,75,177,125,208,113,248,53,52,249,232,128,121,104,157,103,99,65,148,97,161,80,228,231,44,239,111,156,78,200,10,234,31,87,98,44,157,180,10,115,47,209,139,148,61,215,171,119,88,154,244,76,186,100,238,139,16,165,26,32,155,25,178,141,123,221,36,232,109,180,93,253,137,103,247,148,175,125,115,169,249,179,10,96,75,37,118,246,50,7,30,169,191,123,156,207,19,217,46,35,190,224,47,233,251,160,211,16,20,173,237,215,129,238,168,95,205,43,149,110,143,97,206,56,97,153,199,215,94,232,182,8,120,110,39,162,15,207,237,88,155,140,99,203,136,83,210,16,194,124,148,234,248,243,188,135,30,176,225,206,139,232,123,147,180,248,172,55,7,236,187,97,93,168,152,189,149,180,3,20,47,193,13,144,201,160,151,31,250,137,220,191,232,56,156,112,96,179,178,95,29,47,143,221,157,104,94,100,121,157,3,113,227,48,12,197,53,159,166,202,54,79,74,179,229,136,208,227,54,46,97,25,176,116,175,157,244,138,129,98,112,229,39,187,43,216,247,226,49,178,230,248,132,185,132,70,73,87,143,162,16,13,24,2,105,254,252,132,33,178,117,116,92,170,6,204,240,247,84,238,146,57,181,171,155,232,148,72,180,106,249,113,34,3,69,23,19,22,236,54,132,123,102,206,86,6,116,98,249,142,189,19,78,195,54,97,104,255,0,5,48,161,88,0,121,187,204,124,123,29,174,243,89,132,23,52,26,196,157,114,86,30,36,156,52,25,72,151,150,253,157,177,114,72,149,254,130,190,201,95,248,46,124,136,231,146,128,111,39,197,163,50,213,125,6,137,199,90,110,191,40,162,73,211,55,231,20,19,242,158,158,91,111,82,135,132,189,249,51,238,17,92,78,128,20,46,12,76,53,163,244,187,107,147,255,39,216,199,30,193,131,20,188,112,140,149,200,109,226,177,224,247,192,211,87,81,121,247,2,245,155,120,253,59,61,234,91,15,123,100,74,62,208,103,37,80,237,109,220,24,70,79,233,21,77,196,244,232,130,159,51,236,117,228,18,187,134,195,125,52,9,112,192,66,108,253,254,140,134,118,233,216,69,219,24,192,99,30,116,109,149,0,75,106,83,223,209,5,66,138,241,11,17,220,14,184,113,13,129,154,134,77,102,25,218,160,254,66,28,119,209,119,31,101,77,10,158,58,26,230,121,93,90,254,99,222,29,18,65,36,114,173,95,158,205,16,69,210,49,237,49,196,129,133,47,105,76,16,204,249,203,184,163,81,187,241,221,43,244,31,156,112,160,145,49,87,150,153,106,51,94,56,246,62,106,161,190,251,133,167,156,252,28,123,129,194,255,217,199,119,215,152,206,21,135,24,189,153,152,149,249,243,177,175,224,109,63,42,168,218,243,113,105,196,87,8,102,130,225,231,247,240,211,128,35,108,24,28,206,87,41,150,130,198,39,195,91,228,67,241,37,253,222,35,9,73,7,96,109,179,167,69,57,252,221,138,139,61,75,83,127,48,1,240,108,90,186,139,165,15,180,87,181,95,87,229,250,157,107,23,160,235,5,88,110,61,69,50,99,253,62,168,47,24,63,41,102,22,219,140,31,184,158,212,181,13,31,207,35,223,31,202,147,170,189,139,101,101,30,105,204,123,125,252,183,203,146,117,145,51,242,197,246,188,119,20,132,159,74,246,52,24,175,38,28,46,58,166,180,132,77,121,190,1,112,174,40,144,52,26,25,109,130,168,236,234,221,103,110,115,34,217,148,237,228,155,34,227,180,247,79,201,164,110,245,83,89,40,127,198,245,65,164,138,173,123,55,11,48,104,73,138,234,72,246,193,223,82,237,229,58,198,193,215,178,108,62,76,0,61,65,77,245,22,38,199,154,146,85,235,78,242,208,130,127,246,20,157,21,204,135,9,64,54,195,46,74,148,76,222,42,115,31,100,210,166,82,75,119,184,201,122,61,23,114,229,79,121,75,220,145,106,139,13,234,228,113,113,240,252,69,238,64,223,201,66,46,4,54,25,77,92,10,240,84,43,190,111,109,237,58,156,16,220,143,51,181,115,114,160,234,208,111,78,134,76,86,81,57,72,93,220,81,143,238,42,118,93,158,165,191,37,255,240,24,106,61,254,216,103,51,62,76,138,245,75,169,93,216,209,189,80,195,45,135,102,255,13,152,236,147,171,73,62,117,209,34,252,109,128,241,9,83,93,255,100,170,99,171,0,103,249,163,174,88,215,70,195,161,120,83,86,232,168,240,80,126,199,100,206,131,180,241,234,223,139,84,139,119,229,169,179,216,4,136,254,166,165,216,217,248,238,208,199,27,244,20,139,185,94,144,179,186,250,123,67,118,43,16,252,105,24,78,13,74,107,175,119,213,11,25,63,135,208,200,186,82,98,183,40,122,69,30,113,100,246,209,236,254,216,67,132,51,25,45,97,1,57,135,3,132,136,54,206,200,91,85,48,108,132,84,120,237,22,66,239,49,74,189,134,102,3,173,175,100,47,201,58,1,188,242,81,173,247,168,133,91,148,136,38,201,83,66,92,1,68,104,87,209,217,120,236,241,210,162,169,12,54,62,157,223,162,19,34,107,21,81,117,202,4,228,184,20,133,100,157,2,98,66,75,226,51,117,208,43,151,98,63,145,245,191,138,230,63,231,125,234,205,81,252,120,30,49,8,32,77,5,51,15,163,204,110,92,247,32,160,139,255,221,32,35,109,129,205,25,91,95,50,83,34,83,242,166,6,128,64,30,6,1,112,93,211,178,94,220,27,41,12,24,60,84,216,7,49,250,81,188,176,100,180,115,173,5,70,58,128,226,157,65,209,206,15,126,23,223,69,86,103,191,12,151,196,60,197,57,52,101,78,168,249,145,241,75,3,205,123,59,253,65,181,48,229,167,221,69,24,248,233,95,160,36,72,194,172,107,7,34,194,230,231,98,218,36,85,112,61,144,187,242,68,149,45,215,94,134,120,202,101,99,222,140,195,198,52,6,225,208,142,91,67,53,248,146,253,34,239,183,40,27,111,216,146,235,238,139,6,246,21,135,171,48,148,182,108,73,100,28,229,239,32,178,221,63,60,85,16,161,213,147,23,180,54,4,24,31,66,87,30,188,235,153,171,214,220,181,132,30,126,240,92,187,251,195,205,172,97,5,214,225,251,216,64,194,8,79,40,235,0,213,58,242,240,188,231,27,49,123,124,55,157,9,178,155,119,13,67,80,98,88,64,212,252,176,119,131,217,158,231,255,27,162,232,219,67,246,55,145,169,8,46,63,137,180,194,220,86,150,105,82,121,134,69,59,139,36,116,254,51,54,6,240,59,235,236,115,106,228,175,179,215,65,172,189,153,164,29,210,56,168,189,162,97,111,175,162,94,252,245,106,47,253,185,56,17,94,95,143,82,23,141,201,129,46,113,38,126,119,39,53,117,169,54,213,34,221,113,129,248,118,244,185,249,199,197,1,133,129,63,130,51,255,178,94,103,230,27,162,154,22,156,57,131,10,247,254,255,68,24,132,122,92,90,143,181,145,173,114,232,141,243,114,214,170,114,188,15,71,40,240,128,24,105,75,158,214,112,98,230,184,23,152,216,205,167,209,188,246,74,156,254,70,160,146,59,121,17,73,195,232,158,90,229,37,171,24,210,135,66,140,156,69,39,4,185,37,155,113,245,64,101,218,94,77,79,251,212,151,8,30,23,150,42,32,131,5,100,152,41,145,69,72,113,156,206,99,178,225,203,170,254,52,169,153,5,35,67,13,177,189,33,124,144,234,228,95,216,77,34,134,194,19,102,113,114,45,84,213,26,166,21,63,197,111,227,160,232,198,236,102,50,198,168,133,12,7,66,138,61,59,252,14,154,160,90,120,8,214,97,230,30,183,192,80,176,234,250,116,98,64,70,96,60,162,159,205,87,199,131,192,9,76,54,186,43,33,30,145,116,22,251,202,157,70,212,112,65,71,244,184,141,247,226,183,94,203,229,108,192,74,150,207,187,237,118,252,240,81,77,77,218,143,55,217,215,125,46,99,49,200,132,105,153,250,23,69,65,186,24,240,223,62,63,252,33,44,246,145,35,183,179,243,180,24,85,80,92,209,202,14,206,216,89,108,218,126,104,186,198,141,68,64,236,0,242,76,86,133,14,22,53,134,209,124,209,204,97,195,149,118,204,45,142,16,123,186,168,4,89,213,67,97,127,0,2,52,149,134,198,236,215,254,141,180,251,247,1,234,96,243,56,11,220,2,14,250,179,208,236,70,152,157,93,134,218,184,81,209,229,134,42,159,76,209,93,51,189,29,30,107,55,13,97,219,165,190,33,171,223,170,143,235,138,86,123,79,205,163,77,245,5,37,60,176,175,77,183,35,43,208,253,38,61,181,34,71,148,150,201,229,103,222,195,255,141,159,129,115,7,29,173,205,213,164,62,26,230,17,55,31,155,17,23,31,64,210,3,37,4,221,143,223,131,95,66,205,93,189,131,38,119,188,190,23,63,13,0,76,63,197,240,105,43,240,171,83,4,250,193,1,123,196,186,42,34,162,73,28,247,181,174,13,93,35,26,254,194,194,154,190,71,178,53,43,146,212,79,169,44,253,34,36,201,172,199,172,141,187,196,96,222,67,252,164,220,76,161,115,185,30,112,58,172,42,210,156,80,249,16,105,138,67,202,12,42,153,73,162,7,235,150,83,167,217,45,100,19,108,219,190,214,56,91,131,171,52,26,113,21,250,79,55,240,168,117,189,86,104,63,5,73,7,149,123,104,18,132,96,53,28,6,83,51,21,52,42,46,209,154,54,169,214,205,133,113,98,17,151,61,49,186,121,195,26,58,35,110,72,201,97,9,242,211,181,2,46,114,138,26,240,111,210,21,106,178,175,99,167,73,163,179,16,31,26,41,17,6,205,141,23,230,233,47,185,35,187,30,53,189,105,67,246,61,147,175,75,42,62,111,154,146,67,141,218,71,255,112,242,224,142,10,64,58,151,225,131,138,191,66,134,9,168,55,60,147,160,52,230,118,220,178,59,67,36,136,170,65,207,5,84,162,232,150,136,152,71,33,162,239,177,85,198,233,21,120,131,1,222,139,226,42,221,108,14,123,141,12,57,162,87,199,191,189,185,250,64,63,151,251,198,13,58,148,47,6,107,72,239,223,99,48,88,114,177,0,11,140,157,73,49,250,111,119,90,76,117,138,100,207,82,224,145,57,233,145,65,102,153,82,41,139,141,183,109,130,19,112,78,34,164,148,119,242,170,213,178,205,151,54,211,143,55,233,83,142,116,85,38,79,27,68,3,194,132,139,241,97,245,21,18,116,195,199,205,137,68,169,66,29,246,156,37,210,198,192,122,187,97,241,114,179,185,105,69,205,164,46,247,247,92,157,104,124,103,76,194,70,200,145,138,79,139,216,248,150,210,40,115,29,123,224,237,4,68,16,200,126,129,187,66,17,137,127,179,18,181,118,122,77,110,159,255,82,53,104,8,175,125,193,203,46,92,249,121,215,130,246,47,7,188,48,159,186,238,2,7,91,107,53,167,247,0,139,50,189,92,83,120,233,216,255,44,25,233,131,12,171,53,103,154,19,212,50,152,198,212,8,234,206,83,144,59,33,194,226,125,89,120,211,205,16,21,146,24,149,131,114,252,219,224,201,73,51,177,27,233,76,176,235,28,113,185,212,215,102,140,135,101,177,115,195,160,219,103,100,180,25,214,78,47,207,244,57,195,61,13,251,69,68,180,167,169,105,28,174,149,102,151,16,134,196,74,28,138,222,71,130,43,54,169,93,96,174,120,14,83,249,146,138,92,213,205,115,26,204,224,66,186,77,49,184,45,94,81,226,201,65,74,227,242,246,114,124,161,204,237,134,35,120,29,192,141,80,206,173,27,184,18,110,39,218,139,204,215,202,213,63,41,70,243,189,102,61,185,36,221,123,192,143,190,76,122,39,161,72,49,205,67,34,7,109,178,241,115,229,58,121,85,60,94,126,38,177,235,54,219,31,103,209,83,233,130,129,206,115,255,226,218,140,154,167,137,240,202,92,96,34,38,26,88,1,26,107,115,128,192,109,178,74,124,61,42,8,184,35,111,142,157,75,21,165,3,169,2,149,112,236,18,49,194,224,254,49,121,135,237,94,129,155,233,98,34,19,185,196,183,160,143,7,28,173,169,171,112,174,173,244,165,74,235,30,205,142,236,43,179,37,123,218,127,233,23,173,6,104,139,85,159,223,122,189,62,90,56,19,215,121,152,30,67,171,119,96,26,235,124,111,174,14,70,6,14,90,11,174,137,248,22,187,30,136,174,63,176,188,46,77,189,168,55,1,139,39,232,15,241,143,135,164,170,79,54,177,29,45,145,17,174,145,68,15,86,181,83,153,106,134,43,153,18,90,132,72,22,26,47,54,31,152,191,198,79,131,250,249,181,9,19,108,14,119,110,211,254,173,80,100,143,115,18,56,36,203,219,8,208,172,168,109,245,90,244,90,162,8,156,189,130,252,135,229,107,116,42,45,248,122,193,151,152,78,140,119,183,14,96,197,46,226,11,28,139,160,166,124,211,193,161,12,74,205,2,42,233,104,78,107,148,8,135,145,252,173,164,147,201,138,73,212,60,122,133,12,112,25,60,201,108,147,84,88,134,106,186,73,129,9,196,34,25,62,93,115,75,239,116,250,197,141,184,124,56,170,180,108,108,218,226,21,91,213,238,167,23,218,191,162,244,188,240,64,237,43,86,253,82,226,145,217,22,186,144,34,160,78,49,157,5,14,212,148,194,64,6,254,14,80,149,75,140,37,57,188,103,149,49,82,220,116,190,50,188,101,239,17,20,83,72,155,68,218,33,29,163,243,129,126,97,154,209,77,203,194,137,167,215,180,160,250,155,57,77,221,120,49,84,74,166,108,140,57,2,129,163,216,195,201,111,153,224,34,188,18,184,147,246,187,247,200,62,115,7,55,241,52,53,119,199,231,68,108,18,102,121,249,201,33,124,167,219,36,53,201,20,174,93,6,146,33,209,98,212,176,145,63,106,114,83,100,132,234,236,135,64,141,8,56,185,21,218,69,23,244,169,52,155,139,141,38,98,74,127,222,75,235,30,82,165,140,55,190,243,37,2,246,252,51,153,165,228,186,119,110,163,254,46,144,31,97,194,216,209,115,207,36,158,98,241,237,41,95,85,143,99,249,38,35,248,65,227,149,170,61,91,188,154,28,192,111,209,64,12,123,48,25,251,6,102,110,153,5,10,243,55,128,55,55,36,12,225,144,90,153,196,159,134,72,96,198,196,222,226,33,246,128,125,183,129,127,41,1,64,228,68,97,71,58,20,72,235,209,52,231,112,244,101,235,177,59,245,75,235,197,137,154,254,7,61,244,64,101,246,202,137,81,214,240,188,49,53,220,81,85,189,125,131,216,82,69,128,187,229,74,153,45,238,8,239,125,76,202,142,106,178,12,149,88,43,93,158,190,150,183,29,118,205,79,59,207,83,62,198,242,21,197,87,151,24,223,170,241,79,104,32,24,194,43,114,15,151,21,14,167,186,106,184,56,107,76,200,184,164,230,166,216,68,40,45,152,218,1,206,235,204,196,37,40,146,10,142,86,156,59,116,2,222,95,142,251,199,142,190,174,61,116,192,68,184,247,13,20,198,43,71,13,56,120,8,62,10,124,177,81,172,187,180,90,229,100,217,15,37,225,73,47,178,70,11,7,57,37,36,103,188,121,228,175,175,136,34,185,10,197,33,225,83,83,96,125,228,242,44,49,18,154,120,61,171,224,66,136,155,158,51,159,27,189,128,50,232,143,110,13,196,230,1,137,162,58,99,176,138,151,74,67,14,67,101,37,219,92,210,27,201,46,195,124,37,58,48,196,170,74,110,102,156,70,200,75,77,192,243,99,55,86,120,92,178,165,189,229,2,63,13,130,225,64,67,164,153,153,230,62,101,220,162,16,207,228,186,27,45,193,240,220,209,124,17,101,249,83,251,41,14,188,197,245,177,61,2,95,93,204,202,63,156,89,126,144,126,158,155,186,239,133,223,216,215,129,227,84,118,180,1,113,123,196,212,240,142,221,117,193,200,111,63,146,4,102,233,129,255,246,4,231,158,237,73,40,60,61,229,162,218,196,135,209,4,250,108,253,15,39,76,75,148,233,226,198,49,34,251,63,204,107,195,106,42,229,115,92,247,163,223,229,179,92,138,71,40,130,28,61,86,238,188,140,43,76,198,174,189,195,216,55,28,34,181,45,63,100,120,17,77,132,202,19,89,41,6,208,84,10,81,60,1,4,198,186,153,185,7,167,247,66,242,17,241,212,35,153,137,163,104,49,195,173,111,160,35,33,45,173,252,29,77,15,89,176,236,221,149,10,17,193,237,191,122,71,161,217,53,40,230,12,63,101,84,123,127,25,80,111,37,145,28,17,217,177,211,238,86,102,65,86,153,187,169,130,221,54,90,237,87,194,39,137,104,33,235,153,218,213,31,32,28,192,139,22,105,74,114,171,38,64,43,206,92,236,186,9,226,251,224,10,127,59,47,93,242,219,63,72,224,80,208,95,53,208,173,229,156,160,19,57,203,46,243,39,97,253,212,50,91,102,84,157,91,152,161,136,90,203,227,137,241,209,237,208,36,201,40,142,92,163,120,158,13,152,198,47,229,23,100,104,232,229,111,102,148,226,108,218,48,121,216,226,206,214,5,240,155,223,83,217,13,247,115,116,87,61,242,13,236,231,161,189,229,49,47,165,5,228,86,153,29,89,90,61,8,12,231,202,69,193,13,155,136,149,233,20,55,96,90,41,215,1,16,221,82,12,229,132,156,234,187,147,135,204,190,73,130,138,203,76,171,116,55,67,66,148,59,204,104,243,230,148,46,3,205,118,165,147,186,27,12,212,237,21,189,33,226,215,129,235,235,69,223,33,108,168,157,219,215,128,13,255,61,8,71,177,30,180,120,145,2,76,29,69,54,246,0,122,16,222,138,93,27,0,185,101,184,233,249,251,3,62,223,86,46,188,139,118,58,110,171,140,250,86,124,213,82,229,194,177,69,59,106,59,202,104,58,232,124,24,19,211,221,202,80,111,79,230,52,183,61,221,17,244,78,156,84,46,247,163,186,237,174,43,184,8,192,112,240,170,187,126,103,142,43,14,244,241,244,174,74,223,216,214,22,81,27,62,0,119,123,96,237,98,147,17,136,205,29,187,190,72,211,110,96,90,124,227,201,163,80,127,12,178,86,126,171,33,169,10,82,250,34,33,251,105,97,76,50,152,170,99,69,68,5,94,13,222,91,184,13,91,68,62,16,119,14,0,31,233,24,138,175,209,223,6,255,192,98,239,240,108,155,223,97,171,192,67,178,135,246,241,238,129,83,117,152,30,238,72,221,89,25,218,195,251,118,148,194,29,131,118,4,73,35,247,120,189,66,34,168,197,89,73,93,40,127,0,150,11,14,232,19,220,180,204,25,187,158,209,245,174,198,175,72,75,110,42,189,192,139,228,96,199,237,165,153,224,72,2,209,205,28,180,135,112,186,113,161,154,160,223,90,42,63,175,123,166,217,97,40,217,18,200,94,215,160,20,6,113,226,82,19,62,129,108,22,45,255,130,151,93,99,248,179,211,2,209,217,175,6,41,24,185,161,218,113,167,87,125,165,132,119,68,164,150,201,176,244,76,196,101,211,202,37,79,68,228,145,240,35,103,68,93,236,145,213,75,69,240,118,55,219,81,64,13,47,221,134,101,113,107,13,200,134,232,39,215,87,246,197,158,215,32,120,231,153,226,63,2,190,67,144,253,207,106,104,132,249,153,83,158,227,216,50,72,138,99,213,51,252,142,243,243,146,83,214,126,133,56,110,162,203,79,163,89,154,188,220,152,102,105,252,150,114,87,227,204,250,60,54,183,86,237,143,185,169,237,98,131,21,180,76,5,178,120,248,215,210,142,57,234,23,108,153,3,47,240,213,163,129,68,75,206,85,188,152,119,63,241,0,187,9,221,199,131,8,178,219,106,126,86,198,206,206,157,0,239,115,245,59,9,166,170,220,233,160,211,70,82,96,152,129,57,110,182,106,246,88,116,250,81,164,130,234,92,147,223,210,31,211,176,159,31,112,40,130,71,13,144,239,25,173,176,87,26,175,151,251,184,16,86,51,229,97,246,12,195,240,194,105,93,136,220,113,248,191,194,172,229,175,125,62,251,136,175,60,236,195,245,113,37,167,34,245,146,17,38,122,74,225,239,209,128,237,189,166,86,92,101,170,166,42,142,56,103,245,157,144,4,68,74,133,239,221,73,127,241,47,59,244,228,48,234,54,72,20,28,6,90,138,72,111,215,142,29,161,17,69,204,187,43,212,92,36,45,178,176,74,113,159,250,42,64,151,249,236,48,56,112,221,1,120,64,164,94,31,191,212,174,27,48,74,80,209,86,177,139,160,29,203,81,58,164,242,81,255,169,75,154,175,224,193,36,25,177,226,154,74,211,166,237,37,150,219,42,119,182,171,99,253,62,19,120,139,240,107,221,175,220,106,191,34,176,124,11,144,167,156,7,26,89,251,75,245,148,233,125,139,80,1,253,163,133,162,53,182,250,171,237,235,3,200,208,168,89,73,169,171,156,147,129,196,41,23,246,8,233,188,34,202,82,39,206,164,192,77,62,37,243,148,229,197,165,16,255,82,98,231,164,155,142,21,107,226,12,186,4,159,30,231,210,144,247,134,187,30,181,176,108,73,159,239,215,183,72,56,214,61,252,43,203,5,205,232,64,154,211,106,179,3,48,255,148,160,126,44,111,234,105,52,230,9,104,63,148,184,0,238,174,162,85,199,211,187,221,125,53,208,77,190,145,92,41,79,49,111,86,172,116,63,15,153,20,3,195,6,57,230,153,74,163,147,120,186,190,176,239,26,137,148,222,153,215,99,105,61,40,197,255,251,84,188,30,180,49,179,91,4,2,48,229,166,181,101,238,58,74,224,132,72,44,193,196,93,172,60,154,238,105,106,199,140,22,190,96,45,0,114,163,172,144,111,26,147,62,169,82,106,75,193,22,228,247,95,37,13,12,107,130,48,109,95,125,114,17,190,44,198,161,175,35,140,184,87,172,36,188,152,93,215,31,30,25,226,253,196,92,176,204,104,187,211,19,152,41,17,113,42,177,44,5,133,225,82,237,99,241,86,78,226,127,166,142,193,235,23,153,138,83,26,141,218,130,13,31,73,107,157,166,2,189,36,105,240,147,207,192,149,60,69,39,171,206,255,63,194,147,67,78,101,174,146,117,183,162,237,194,121,8,255,163,255,36,115,235,204,36,48,212,137,142,46,144,253,178,201,236,36,9,64,39,144,94,49,89,170,158,86,71,96,221,140,155,89,238,191,219,119,137,146,207,37,99,201,75,197,126,118,105,114,83,53,32,94,27,95,115,134,253,203,252,123,207,31,69,154,32,13,199,159,124,69,56,123,42,238,8,183,183,126,150,147,104,55,69,17,217,125,12,222,178,67,32,212,12,146,179,129,32,0,243,249,151,65,48,161,179,139,100,27,102,206,90,7,198,207,152,139,67,122,242,85,184,9,207,45,61,132,24,62,45,243,218,244,245,239,92,73,118,143,104,232,81,216,23,173,70,229,188,150,28,45,11,116,12,22,183,176,136,185,56,76,227,114,231,96,216,44,74,167,199,148,46,63,60,229,102,214,105,234,253,141,143,199,97,150,85,158,174,32,46,2,114,197,34,111,206,71,89,232,75,20,92,242,78,35,70,195,27,99,234,239,137,186,110,39,179,60,18,148,137,231,8,75,255,149,127,228,113,224,201,237,217,127,115,102,203,29,250,150,232,255,234,158,182,242,128,108,149,252,95,240,239,62,111,204,36,175,119,3,11,216,54,37,11,56,233,249,163,8,134,145,120,45,92,155,255,224,128,214,95,171,162,236,201,240,12,216,26,21,10,18,143,140,186,42,121,227,61,106,226,88,37,135,122,71,191,142,225,38,186,47,52,54,5,180,32,158,64,113,42,17,186,108,136,37,67,129,132,87,107,86,7,67,24,176,109,121,73,3,1,63,131,75,196,234,30,21,146,242,152,108,185,152,109,240,217,246,27,156,118,136,210,199,184,40,202,191,211,217,61,183,229,212,72,47,224,211,179,143,166,0,37,128,252,39,39,213,253,95,193,48,204,56,203,18,5,207,244,155,215,231,113,122,181,57,201,107,231,224,188,181,57,89,149,136,82,152,48,229,178,103,35,208,80,253,221,118,235,0,152,64,20,95,242,13,121,64,98,183,196,0,43,198,222,52,27,47,72,132,131,114,76,23,156,64,247,46,22,75,223,205,77,250,72,132,1,150,186,71,55,56,222,224,252,123,248,63,160,128,203,156,14,0,108,106,219,180,6,123,175,34,250,250,252,88,65,179,51,238,198,54,39,151,249,68,197,71,160,191,89,216,39,24,134,43,120,211,239,46,146,104,99,219,13,9,220,215,134,10,232,187,93,10,69,25,100,218,121,120,134,60,78,212,104,69,9,178,50,250,4,65,60,8,93,151,86,220,32,61,199,175,175,99,148,40,111,255,170,175,250,240,161,226,1,80,226,233,190,68,203,164,56,18,144,49,164,193,246,108,91,151,196,184,205,170,251,202,224,230,161,192,189,67,163,225,63,46,167,11,255,159,2,167,76,30,232,82,26,48,100,217,6,205,50,71,255,224,121,97,110,90,150,143,156,156,56,152,207,186,31,85,86,36,240,89,242,142,68,36,125,209,224,5,200,99,33,156,242,48,120,150,171,157,139,226,48,47,73,187,23,107,165,80,67,173,38,245,191,169,45,232,122,68,19,231,145,135,242,70,5,223,155,91,173,205,207,26,200,17,72,210,243,237,178,81,224,72,126,29,17,73,211,15,12,196,124,213,168,35,109,235,164,97,94,250,1,121,125,64,81,175,82,189,75,225,105,218,9,132,122,16,115,128,179,52,144,195,192,117,128,72,208,87,138,149,201,19,179,107,154,118,36,201,97,243,215,145,46,64,172,62,173,119,92,170,72,240,252,227,168,20,186,63,125,96,232,170,43,104,93,81,128,133,132,123,135,67,159,250,207,162,66,241,223,241,25,19,36,248,24,30,1,200,203,108,107,68,229,180,73,61,122,93,234,8,121,191,143,40,178,240,77,67,113,136,170,247,204,70,18,105,216,223,151,56,74,181,44,58,191,184,251,239,76,246,172,97,52,231,179,5,76,195,255,225,67,92,230,168,170,73,49,204,56,63,234,24,216,58,230,213,104,186,226,107,141,109,2,152,255,156,84,142,238,150,217,73,240,85,66,19,122,215,108,180,130,236,63,2,4,196,246,169,126,66,187,46,36,180,14,78,14,189,122,139,91,82,166,162,135,127,200,150,238,56,130,250,179,76,133,85,221,162,138,145,30,233,209,106,82,144,39,86,37,153,115,35,106,36,151,20,118,176,55,214,198,243,194,231,214,76,198,113,90,63,177,47,73,99,30,116,2,229,118,80,214,34,201,189,154,75,90,170,108,113,206,222,9,205,30,123,6,92,141,169,18,225,162,163,237,115,67,85,62,67,246,222,143,150,49,153,134,86,9,154,3,108,122,182,209,30,33,89,96,186,158,35,229,116,67,178,2,16,229,80,70,34,253,243,122,203,130,62,29,46,166,93,76,28,112,158,250,242,213,78,25,190,92,149,209,22,21,231,83,242,0,43,85,109,254,161,181,144,176,38,235,10,51,192,210,30,136,89,65,203,16,15,149,218,248,241,65,4,118,34,124,32,208,199,228,172,74,213,20,148,252,136,210,233,16,108,136,126,47,49,40,155,219,255,204,1,124,80,138,138,84,195,133,89,214,91,23,189,229,126,34,129,148,76,200,213,227,229,212,192,1,51,164,14,54,35,226,221,214,233,185,49,68,64,203,163,51,185,206,241,246,102,94,75,54,71,45,166,15,25,146,62,91,25,226,125,207,232,147,254,44,104,5,107,93,189,162,17,32,143,67,130,216,212,135,31,146,242,222,189,50,225,198,28,113,54,230,24,162,51,181,130,192,245,39,201,214,251,169,148,101,247,102,147,36,195,193,114,174,76,88,130,130,33,228,151,44,160,191,103,69,171,181,121,99,221,80,169,45,60,210,57,254,203,212,40,75,124,199,92,229,1,102,173,146,92,230,193,171,3,197,21,169,221,132,139,53,109,26,113,54,78,5,24,173,83,168,148,211,246,83,42,88,25,136,196,150,196,158,113,168,183,40,43,156,33,170,45,245,136,13,82,199,144,240,176,223,251,178,241,150,82,76,249,44,179,244,44,73,56,234,193,176,96,195,87,135,12,25,36,52,253,45,105,219,217,243,198,81,23,161,239,176,59,77,67,252,96,5,138,210,200,136,97,98,189,167,74,108,42,96,136,62,156,222,211,221,176,44,8,157,29,184,58,137,233,135,124,224,177,171,241,162,94,203,241,203,26,142,219,74,177,86,19,238,16,218,85,93,23,21,238,24,238,177,37,136,87,60,149,111,47,48,234,216,162,204,111,170,44,121,82,70,66,129,45,46,250,209,233,45,38,70,138,170,186,131,51,248,26,221,43,145,218,209,22,16,77,134,76,126,34,231,245,128,204,199,35,11,22,126,9,146,75,227,105,55,60,39,160,191,110,116,5,172,79,133,41,125,159,84,249,251,142,178,103,32,163,239,149,215,239,114,71,121,73,67,103,104,206,212,69,148,124,30,114,244,11,224,197,208,102,205,84,85,119,126,63,93,232,157,162,193,99,130,226,234,50,67,19,64,246,40,90,220,35,219,93,23,211,187,198,172,197,54,48,33,142,91,139,250,180,121,76,229,233,147,189,114,98,209,199,242,247,68,98,158,133,36,129,215,6,189,235,128,225,11,180,174,64,164,36,10,64,25,40,188,188,192,82,154,86,34,156,30,41,161,104,195,23,33,90,67,110,16,167,131,127,159,172,204,52,93,101,174,173,134,117,116,107,67,159,141,250,110,82,38,8,216,234,152,48,173,186,179,253,109,216,210,173,53,110,231,189,60,49,64,88,202,3,10,86,91,175,62,72,191,171,127,124,8,79,102,161,19,65,145,86,181,110,6,41,239,123,116,75,253,148,64,189,148,53,193,250,247,223,159,239,47,184,72,169,22,35,135,170,73,29,18,103,195,24,26,42,164,54,233,6,167,161,72,100,90,83,160,17,93,4,57,151,127,80,220,247,41,39,141,91,46,30,23,249,217,111,194,29,27,230,128,80,229,51,173,107,163,98,191,177,231,250,132,45,199,15,86,83,10,51,12,33,27,253,10,180,184,123,4,126,242,83,207,249,76,98,214,44,154,202,241,34,118,185,239,23,22,157,153,211,196,7,242,83,167,210,33,42,238,193,180,76,58,142,77,139,249,190,76,126,142,25,227,227,73,223,61,183,140,109,132,148,196,21,6,128,113,243,32,89,245,141,11,42,206,52,20,5,59,217,86,127,228,193,198,204,118,19,126,88,170,35,151,181,59,174,126,36,240,113,134,210,222,29,164,126,19,125,189,90,197,98,204,25,121,105,119,72,95,150,97,51,86,158,154,51,249,242,105,1,196,121,206,146,79,180,160,136,64,150,37,221,155,163,33,224,242,197,97,83,4,125,229,78,148,130,3,6,171,183,232,35,44,251,149,112,221,26,204,106,247,171,140,62,79,231,137,221,137,8,46,104,14,197,50,133,105,130,183,180,104,110,177,155,144,200,147,132,9,186,168,230,53,38,95,218,64,77,25,249,66,81,116,173,21,134,13,107,107,217,120,155,42,49,39,23,245,123,171,94,171,36,220,106,95,130,3,161,100,190,99,7,123,14,142,83,141,29,15,110,216,159,142,15,74,73,185,8,15,230,0,96,234,186,155,133,83,51,82,120,164,208,84,88,0,75,210,232,228,29,206,64,234,161,68,201,119,164,17,135,193,232,124,129,60,98,132,62,98,61,239,94,24,206,172,255,60,66,53,124,96,3,237,60,1,205,48,253,77,199,69,96,169,91,117,74,228,243,190,192,182,237,83,48,221,168,109,63,41,31,108,22,47,248,246,228,150,153,107,219,121,4,208,172,7,216,177,137,169,78,94,123,119,254,28,101,231,192,103,173,252,40,80,171,100,229,56,4,211,208,109,99,35,46,87,190,152,136,43,47,90,47,153,10,176,30,68,148,43,122,81,253,16,119,97,88,14,202,127,124,75,173,112,214,72,62,125,50,96,35,9,125,116,159,70,200,161,84,155,42,164,177,226,155,5,125,100,208,233,129,7,83,5,134,64,218,161,91,254,182,35,97,26,119,175,71,79,246,31,99,158,131,177,240,206,51,100,246,27,193,108,211,140,234,155,209,229,15,22,186,185,235,70,161,231,0,154,214,235,151,238,255,59,48,245,96,165,223,40,244,158,2,221,134,14,192,154,3,62,223,248,123,223,21,84,14,170,40,177,254,134,177,170,217,127,134,47,77,33,1,23,221,248,172,251,68,140,144,103,187,43,198,201,165,176,119,209,71,238,184,186,224,201,16,228,199,150,79,241,128,153,48,120,255,223,202,153,97,182,247,177,58,82,235,89,158,55,1,132,49,151,124,30,53,236,255,82,12,137,205,162,7,183,231,58,230,204,161,35,151,131,42,127,5,85,17,110,22,206,142,51,127,57,219,67,122,6,252,201,129,186,99,40,126,240,218,80,170,17,119,93,89,160,128,27,107,22,88,221,12,109,155,194,10,72,206,190,242,15,70,161,55,179,27,70,14,221,15,79,198,207,122,8,222,231,68,71,162,141,224,121,171,151,11,168,65,124,20,140,154,250,100,213,105,9,16,253,134,32,94,44,178,91,218,175,46,122,109,228,217,54,105,203,97,179,36,178,228,100,244,249,188,78,219,129,10,194,227,124,197,197,43,246,155,43,235,143,53,49,51,94,217,83,16,3,101,154,141,108,51,138,209,207,164,112,239,155,195,219,137,17,148,227,93,39,208,95,182,198,162,38,17,130,163,178,228,132,24,137,61,8,166,38,208,24,202,69,94,47,38,128,51,104,30,29,36,63,95,56,38,215,151,97,218,169,143,87,51,150,2,36,120,56,246,24,202,121,49,189,130,118,9,103,163,250,237,239,96,65,123,183,197,203,58,6,196,75,210,210,184,232,191,24,216,253,7,154,139,220,30,32,101,145,31,57,205,149,141,180,181,137,108,38,16,41,45,248,135,215,85,243,29,103,92,93,255,114,162,154,3,177,190,195,185,21,223,45,166,40,133,238,48,59,228,71,203,29,231,56,92,45,58,243,144,187,5,151,103,119,99,156,212,69,13,37,217,94,22,171,89,50,80,254,129,212,220,170,147,135,76,153,73,41,116,59,118,157,135,123,230,166,252,234,38,244,226,23,3,67,132,76,187,119,29,202,128,161,77,238,253,64,163,178,103,31,201,23,149,235,105,226,8,43,208,206,238,163,106,19,213,81,24,159,151,56,114,165,141,1,227,186,41,28,68,194,135,245,179,194,201,154,131,169,59,119,45,73,177,59,38,19,156,53,215,127,251,145,158,9,23,133,86,37,219,162,51,202,68,49,101,101,33,206,14,110,120,119,36,135,192,239,18,159,252,89,132,244,115,202,214,29,193,174,183,239,32,36,145,191,5,82,27,144,245,251,104,117,25,184,101,108,12,137,12,43,184,252,3,34,95,96,126,246,45,241,142,62,172,142,174,156,218,215,113,13,1,174,88,245,143,245,245,146,76,91,239,218,116,73,218,85,11,230,78,76,111,146,191,14,174,221,115,233,47,77,249,219,213,137,200,208,69,121,173,218,137,248,46,101,181,206,60,202,164,109,195,31,140,46,137,86,36,61,154,134,252,98,10,136,31,110,62,18,114,29,234,127,238,44,177,81,78,80,86,123,41,184,237,237,160,174,190,213,192,70,148,64,99,87,172,182,39,42,171,183,153,119,133,42,211,138,71,115,119,98,117,243,117,153,247,107,48,27,31,171,242,162,18,29,174,80,60,41,71,195,109,87,86,237,227,107,35,40,21,55,190,208,40,212,24,167,206,122,171,125,179,105,211,227,213,167,211,247,135,100,129,160,157,255,215,80,1,67,152,255,117,19,187,235,76,105,18,18,56,92,132,38,160,217,227,161,246,212,207,75,80,8,115,224,48,16,155,105,160,23,189,25,184,2,166,241,215,82,84,117,246,21,43,125,112,37,139,13,36,42,189,125,179,56,187,152,97,109,246,131,35,20,136,141,53,17,124,153,62,71,7,184,13,88,84,57,56,172,190,83,192,216,180,138,15,88,70,102,23,246,231,61,169,21,62,104,219,41,37,196,44,33,234,216,1,7,73,184,101,45,89,101,116,194,252,11,110,232,19,156,23,152,253,230,189,194,59,1,39,48,120,253,87,186,76,82,223,133,10,128,33,130,7,211,5,249,81,171,89,2,135,177,201,35,21,117,30,175,174,0,106,10,76,139,9,7,5,183,39,54,12,45,240,75,77,82,93,57,119,31,197,196,39,56,66,185,129,37,227,242,143,10,152,210,155,250,15,94,235,82,97,41,48,82,235,13,169,154,16,99,106,184,43,225,153,231,242,65,165,214,245,221,241,27,171,139,250,75,194,15,57,20,8,129,209,235,80,85,91,140,85,149,105,248,14,66,174,236,160,33,63,82,50,246,79,15,131,96,200,19,85,11,168,133,35,49,246,196,101,166,122,101,211,228,253,76,171,153,31,153,45,171,199,170,155,200,160,157,154,51,255,26,159,185,105,167,233,64,37,224,56,19,3,87,11,121,141,130,86,167,22,3,170,112,50,3,21,41,108,77,65,4,238,226,95,87,225,4,12,253,82,63,171,249,188,154,75,130,132,24,233,77,0,235,129,232,88,220,127,48,205,13,109,62,25,42,55,2,189,184,77,114,114,127,96,107,118,181,227,28,165,19,37,232,98,64,44,250,87,204,106,128,62,198,56,77,18,114,180,211,118,230,144,82,197,227,77,117,157,79,79,222,158,114,59,128,119,18,90,5,42,94,37,15,194,72,93,49,250,85,120,161,41,231,94,150,173,5,233,126,232,62,93,219,195,33,60,135,147,143,65,242,41,123,141,198,79,223,201,217,242,188,5,73,78,87,2,178,58,73,225,4,53,13,205,125,112,91,76,44,241,88,0,56,151,194,227,132,144,203,127,80,53,100,147,181,56,151,61,115,244,67,24,233,194,56,6,211,196,56,179,255,179,99,67,25,4,20,94,72,111,190,2,191,63,124,86,244,55,236,86,238,65,218,38,197,108,126,236,184,32,103,83,38,172,106,114,41,97,159,67,151,41,40,164,143,173,98,247,128,99,16,73,237,68,141,223,72,67,203,232,82,225,3,113,115,229,137,221,141,105,81,125,60,186,213,243,35,160,21,132,128,245,46,156,7,139,203,17,234,154,197,167,161,163,175,134,72,38,184,213,78,232,228,228,165,254,171,118,51,151,115,207,107,12,231,211,236,13,200,73,107,81,211,56,202,111,234,140,233,95,134,231,127,224,128,46,147,240,174,154,88,84,173,92,19,67,67,103,113,134,84,11,232,174,237,203,123,247,213,24,32,181,100,223,148,246,9,43,111,222,198,22,108,33,48,250,212,40,44,109,11,40,189,149,238,36,174,235,50,8,147,184,24,240,3,15,88,163,250,99,173,141,206,35,44,211,16,24,10,169,169,86,141,201,88,179,189,196,17,204,232,216,144,173,123,72,17,16,246,126,176,142,174,55,72,44,123,140,177,224,251,219,224,188,98,211,197,132,59,71,136,22,197,71,222,248,60,158,20,253,150,77,120,32,235,211,123,242,126,32,93,2,186,17,139,160,188,75,231,211,38,240,15,119,51,178,185,151,201,82,183,78,149,87,216,190,4,165,89,180,216,29,255,89,41,143,168,202,78,49,42,34,73,226,77,186,12,94,55,95,245,70,216,194,60,73,207,82,19,49,101,215,226,152,28,231,93,108,211,45,174,93,228,119,189,14,10,141,41,25,101,8,73,184,33,244,157,19,186,158,116,208,221,10,30,220,51,33,194,128,140,191,102,3,25,102,85,137,21,62,112,74,40,143,75,127,136,217,61,156,123,90,243,141,168,97,191,73,212,80,120,233,37,73,107,128,75,12,111,93,73,241,141,169,232,210,212,79,214,82,63,198,196,137,172,126,69,190,34,138,178,134,85,52,90,41,127,112,215,203,29,160,218,133,10,32,243,73,155,31,232,241,39,85,13,193,145,194,205,160,55,75,242,69,180,180,171,191,154,25,212,108,13,10,131,15,166,111,48,1,95,100,60,124,31,13,236,235,55,162,134,9,245,194,197,82,67,8,103,236,112,97,217,27,12,10,7,199,203,159,182,208,35,72,225,101,189,24,20,223,231,6,129,27,159,177,110,7,215,66,50,87,137,239,222,111,172,13,206,2,57,197,17,90,221,130,202,85,69,180,56,134,228,191,195,159,41,88,78,237,152,226,84,126,104,109,138,37,141,103,36,24,76,78,214,224,205,29,176,176,110,173,50,201,170,196,4,192,47,148,225,86,11,100,240,9,175,185,107,218,40,151,10,69,114,69,72,22,62,66,36,228,127,127,4,56,150,165,144,32,99,12,146,243,13,96,204,216,182,189,215,82,81,163,88,78,232,81,107,205,103,72,248,167,238,31,30,143,196,25,95,238,126,54,71,85,112,232,217,97,36,72,78,16,17,32,255,149,168,239,248,137,229,206,121,195,64,188,63,9,220,14,85,32,133,223,173,75,40,85,247,137,169,127,241,98,221,190,60,228,126,174,68,128,185,249,115,43,247,214,119,182,86,116,73,73,106,11,222,169,55,227,29,236,2,211,2,120,206,225,242,59,168,151,171,29,65,41,168,216,198,87,64,30,172,73,13,39,245,26,71,39,111,133,40,214,35,142,19,21,209,242,159,37,5,72,115,230,98,54,179,223,70,34,28,195,54,130,247,234,27,32,132,17,191,72,126,217,173,130,57,105,248,91,167,94,129,176,99,58,133,0,1,188,238,37,4,104,26,215,41,82,86,239,69,241,34,94,126,219,40,66,5,211,166,59,201,27,250,210,150,21,243,110,140,87,194,214,16,218,202,8,183,232,81,4,157,223,20,166,47,52,52,227,179,40,196,148,131,229,226,66,231,31,246,164,16,74,74,175,153,83,223,241,173,126,161,46,239,215,184,245,68,142,84,206,171,246,98,252,218,178,203,159,195,73,28,158,237,89,175,102,180,40,5,67,171,123,33,186,87,160,66,87,110,169,229,139,245,123,138,171,36,10,201,210,12,75,158,56,105,246,168,24,227,84,49,251,74,51,100,245,236,0,202,39,11,187,88,120,114,100,122,71,113,179,189,59,144,238,189,61,231,142,98,113,28,11,252,15,26,241,105,132,247,125,20,135,13,82,108,62,209,48,99,67,144,97,29,78,100,167,33,172,107,75,244,233,16,152,102,50,118,223,228,214,197,118,87,197,243,124,209,237,183,217,16,130,76,14,73,56,152,52,114,250,240,113,101,253,111,225,207,123,92,73,253,219,196,5,128,89,241,59,81,185,46,164,248,120,48,60,55,95,121,122,87,229,66,27,103,15,80,107,226,135,23,190,192,13,242,144,171,116,160,254,177,152,220,60,50,157,180,233,194,10,165,174,11,246,236,137,96,33,33,76,155,16,190,189,136,206,71,77,80,71,23,243,104,197,171,160,219,8,153,164,62,141,6,229,59,214,137,54,253,54,7,65,255,152,243,192,144,204,148,167,1,9,83,26,154,168,164,91,214,34,152,197,88,114,23,105,166,229,240,117,5,62,134,31,31,144,222,26,80,191,251,163,66,247,37,78,52,73,230,145,160,100,167,216,76,29,90,114,92,243,8,40,247,72,173,119,59,125,93,167,194,26,225,247,8,155,61,185,75,244,70,60,79,86,162,90,101,201,174,131,29,101,84,171,14,247,157,106,127,93,110,250,191,54,238,22,59,144,96,161,47,191,229,75,193,29,80,247,78,248,3,126,6,34,254,233,162,48,255,36,1,244,15,2,28,16,175,64,242,189,72,85,237,181,192,194,161,0,250,200,180,27,229,125,243,13,30,192,223,104,180,63,110,45,95,43,183,226,200,204,129,223,250,2,38,105,79,155,245,182,197,91,252,52,190,234,85,154,237,250,181,252,250,82,81,246,200,142,240,105,132,204,71,179,19,114,32,47,166,116,198,125,81,72,108,98,89,134,82,183,115,168,80,166,182,3,236,142,49,81,255,87,104,30,112,199,132,186,170,228,136,248,46,56,183,246,115,186,92,100,244,227,101,58,42,100,2,162,240,112,57,211,101,239,22,94,27,55,32,39,213,186,106,26,99,197,108,80,90,132,229,106,63,56,68,28,57,118,205,158,130,82,104,78,151,249,244,22,151,248,69,152,47,214,71,160,47,249,107,5,182,157,19,119,233,42,219,117,138,81,145,78,50,75,48,48,142,187,117,52,218,7,197,104,70,117,237,0,1,114,94,202,220,150,198,227,203,225,124,239,68,29,179,166,54,113,30,14,220,148,150,156,144,152,234,47,132,113,159,95,218,4,210,232,100,190,111,189,27,51,240,48,187,70,182,134,116,98,216,57,53,169,154,120,20,114,164,188,160,29,125,61,192,105,240,22,170,172,41,90,154,183,79,250,240,208,111,45,23,224,147,138,200,1,130,74,225,58,46,227,22,19,74,147,86,158,114,5,137,206,246,198,244,85,20,77,173,171,225,12,192,69,189,200,19,225,168,42,97,23,157,109,54,219,217,247,14,156,170,180,131,6,59,6,81,93,65,139,40,235,107,186,98,190,243,254,64,99,30,177,39,246,163,7,37,234,22,116,142,30,39,207,27,213,94,245,178,127,133,211,209,155,188,81,46,126,173,87,173,137,225,62,106,55,248,136,29,16,170,179,235,19,115,168,103,49,153,162,109,138,14,225,77,222,32,160,190,106,182,13,11,195,206,250,111,180,106,143,66,171,127,94,198,235,77,113,236,103,254,200,135,83,41,39,31,186,212,101,130,137,223,28,50,140,82,128,93,155,71,232,168,223,239,54,104,212,170,143,39,62,86,68,249,10,30,249,249,145,177,104,113,104,236,164,39,204,250,154,253,186,18,84,64,241,155,177,8,186,178,156,63,59,171,208,142,81,87,93,10,8,238,158,199,153,26,101,93,115,50,88,191,28,104,19,30,46,57,121,0,70,87,119,11,152,116,133,164,143,8,143,156,233,246,255,57,102,243,248,223,242,159,28,1,3,149,10,45,12,104,228,179,49,225,30,141,74,58,180,15,237,232,99,174,229,3,23,122,254,30,170,168,20,125,39,184,62,22,250,231,33,192,230,201,193,125,87,150,127,103,181,160,246,247,216,151,9,167,205,65,146,234,18,191,102,146,128,106,66,126,14,31,175,197,9,172,90,7,59,99,33,190,25,91,153,127,39,253,118,15,79,120,23,17,204,195,72,133,2,222,75,54,38,13,19,166,37,174,43,168,40,76,206,149,100,199,140,49,104,251,52,32,188,181,28,16,136,123,90,129,56,210,141,82,34,126,172,21,218,50,193,11,97,181,204,177,231,175,113,77,161,2,55,124,43,222,91,37,19,121,231,5,26,103,135,169,142,207,11,5,169,85,122,193,240,239,80,189,35,21,63,67,38,20,138,34,82,58,246,113,119,206,208,18,163,209,149,175,190,197,151,82,56,191,23,63,156,251,192,42,102,47,115,13,55,93,173,47,187,146,234,156,139,24,41,88,161,203,102,222,169,73,105,254,221,207,155,6,213,127,226,98,8,180,25,114,175,246,46,222,125,102,73,147,135,60,9,51,248,98,188,77,238,243,94,144,59,74,173,130,71,184,43,4,139,52,85,34,43,253,223,48,169,126,243,154,109,223,68,43,25,20,56,188,159,151,17,216,176,54,247,58,31,233,30,149,80,125,163,39,89,240,114,235,22,122,230,85,56,62,17,127,31,158,42,64,13,126,173,75,195,21,133,226,214,189,253,104,194,149,82,140,127,12,83,17,157,56,106,194,138,149,129,149,186,238,88,3,81,195,251,162,21,67,236,125,182,228,208,76,159,27,186,53,173,20,15,236,234,155,160,202,158,53,248,28,92,134,28,134,214,47,220,205,66,204,225,225,201,165,167,177,150,27,42,121,90,39,36,212,69,103,72,147,97,229,116,40,230,79,159,222,153,13,106,20,70,9,208,219,149,132,60,218,219,5,190,251,101,46,188,174,145,102,201,13,33,183,119,131,44,102,246,33,15,11,67,13,210,115,122,61,181,36,59,114,80,88,223,120,68,54,2,2,20,212,230,145,11,171,203,158,110,172,249,190,108,13,252,168,5,25,223,110,73,175,168,83,165,85,48,141,135,254,181,62,240,221,231,198,35,224,59,56,160,175,250,168,170,128,107,149,230,199,22,191,65,202,129,38,20,215,67,112,72,121,67,82,58,150,138,58,152,127,5,208,39,47,196,101,98,175,16,124,102,0,102,2,38,32,201,209,68,192,148,245,139,126,176,41,65,78,21,121,9,118,146,75,62,46,95,52,98,100,177,206,229,131,79,177,92,53,252,5,49,166,150,157,147,100,89,182,118,50,199,161,226,175,161,39,253,122,134,56,25,73,16,150,0,171,174,67,224,238,90,130,14,198,98,5,41,159,165,23,201,114,163,60,199,233,39,106,244,183,159,216,213,20,118,105,243,231,32,64,28,33,127,85,222,75,68,172,206,134,26,63,12,88,186,250,139,188,51,127,114,139,248,170,175,213,243,249,76,76,218,59,70,237,221,151,23,163,181,21,136,152,170,160,42,255,158,89,198,202,90,84,224,179,238,45,250,155,31,38,24,36,230,167,255,32,106,28,122,157,215,198,93,18,158,110,79,112,152,82,67,108,77,70,9,166,208,165,82,216,14,54,92,99,174,13,189,233,121,241,50,183,43,111,72,145,248,92,122,116,86,160,79,103,75,38,39,100,232,0,218,194,141,15,73,90,44,88,62,82,167,181,146,11,236,234,99,28,241,95,196,174,25,230,55,5,102,194,91,190,39,51,3,168,154,82,40,24,221,31,70,159,21,204,125,128,148,198,120,226,123,123,71,107,100,190,249,178,3,229,133,193,45,159,125,56,48,57,244,70,175,191,20,97,109,180,229,51,95,97,4,164,25,238,196,153,112,69,12,8,249,218,168,69,121,13,226,207,87,186,219,45,69,138,146,197,125,196,37,229,85,21,216,171,139,64,206,129,21,51,106,31,23,8,161,57,231,162,28,234,125,168,13,185,48,66,163,30,157,227,36,95,184,69,206,129,162,10,91,79,115,102,116,13,194,14,37,38,112,176,8,100,251,102,200,200,63,24,173,100,11,30,182,129,230,252,204,220,192,47,45,134,1,84,21,117,168,220,218,71,235,121,219,90,32,159,241,242,70,210,67,223,83,230,52,162,250,187,0,104,115,31,223,43,77,156,51,134,86,190,85,32,163,245,102,182,40,224,151,227,10,169,20,215,246,95,168,119,39,75,0,169,67,163,211,150,88,191,235,173,8,203,144,101,36,19,48,103,31,230,150,210,127,94,196,31,216,81,79,29,38,69,74,50,154,152,196,52,27,185,153,237,129,238,204,87,68,64,158,86,206,124,16,224,24,25,95,2,51,142,89,5,113,224,43,222,149,246,52,105,25,152,242,23,175,20,6,21,186,139,246,148,90,69,104,19,105,207,202,81,124,255,49,34,91,169,27,135,229,106,82,142,248,233,21,202,100,39,197,238,184,141,252,77,44,207,156,205,77,203,93,233,10,159,90,241,137,165,112,117,17,25,167,119,198,224,12,102,237,63,89,111,177,250,211,57,232,117,182,216,36,91,217,96,121,81,131,112,8,161,181,37,82,1,94,178,225,12,118,67,97,136,144,209,50,152,198,13,228,119,83,98,226,62,215,69,33,200,255,26,247,80,168,18,147,181,209,74,119,43,138,160,217,149,96,116,147,100,231,183,7,51,74,230,42,157,129,20,17,168,9,149,69,46,87,242,64,140,75,153,219,93,226,72,231,236,197,6,7,104,253,194,148,220,246,147,38,250,6,142,57,43,61,234,233,81,86,42,192,179,0,210,73,53,110,240,254,21,155,218,131,196,12,149,160,166,220,238,19,227,39,8,129,88,154,66,206,117,197,163,247,248,246,138,42,4,199,118,118,123,209,186,196,141,151,76,39,74,203,107,21,52,126,222,77,165,140,127,253,154,121,64,205,238,223,40,109,200,246,232,186,21,211,188,236,170,49,166,93,210,71,16,53,96,219,8,164,136,34,101,235,60,149,214,73,232,250,72,50,234,40,182,189,42,61,6,47,105,119,251,234,10,107,49,219,131,189,178,210,145,195,178,77,242,44,146,149,243,59,58,121,117,227,169,46,148,201,217,65,180,59,5,198,168,147,80,21,198,26,76,140,124,196,108,16,160,113,123,92,250,6,23,111,71,40,120,6,112,60,145,152,176,207,84,167,147,118,204,245,8,211,30,192,17,165,128,162,66,63,48,234,43,248,180,2,101,243,115,244,165,193,54,135,82,216,251,252,159,181,89,176,0,161,126,197,185,237,46,49,69,24,77,183,27,41,179,245,83,228,44,124,250,157,245,30,213,176,151,229,111,110,230,236,233,9,232,193,85,43,231,67,255,88,210,7,29,92,85,99,198,232,136,207,172,99,137,159,34,165,93,247,24,174,124,126,154,138,26,190,222,64,94,168,150,236,84,175,161,226,29,237,22,91,231,224,107,170,171,3,103,136,199,213,90,233,97,49,250,48,76,243,61,143,37,109,132,118,212,43,40,117,156,120,186,55,46,213,122,113,109,52,37,199,82,108,59,18,56,135,5,63,236,165,96,24,129,12,132,2,114,75,21,17,95,164,213,82,16,225,234,205,12,32,91,45,232,153,147,61,76,213,28,208,0,152,200,88,3,139,185,173,247,76,72,61,237,236,124,124,74,21,224,141,78,231,240,137,155,83,11,106,208,142,69,224,200,59,52,37,220,254,143,224,152,34,234,47,151,23,1,223,32,209,15,82,22,121,129,167,69,83,123,183,198,195,4,240,241,147,23,127,171,112,40,39,167,224,110,89,121,144,212,36,114,154,59,62,22,205,95,21,16,172,160,57,182,232,106,39,224,244,14,124,59,176,157,148,249,175,143,51,15,155,251,167,123,72,196,255,1,77,255,252,72,171,25,16,99,99,60,231,253,195,174,24,205,130,148,24,21,1,79,188,105,136,47,178,18,172,207,110,197,12,56,178,77,66,167,141,207,67,118,117,103,235,139,239,114,120,153,20,19,36,16,219,208,131,180,96,255,132,103,150,45,94,84,14,64,30,34,253,44,59,238,36,218,178,145,116,38,204,191,147,236,205,112,135,120,135,14,169,121,168,77,102,17,73,151,214,132,131,186,182,150,238,209,43,202,228,249,54,2,91,229,86,84,213,183,169,17,131,21,253,9,52,215,149,234,184,235,78,15,145,181,121,158,239,251,194,100,64,33,71,16,172,123,36,207,47,252,211,177,233,86,199,119,15,127,198,31,124,13,178,153,205,67,237,247,136,16,237,68,142,94,141,44,108,231,58,160,193,164,78,205,204,192,36,220,4,127,3,151,153,32,243,99,168,87,238,230,70,139,103,193,127,185,82,71,171,90,10,170,157,61,194,27,154,48,103,232,30,160,143,61,0,10,119,109,220,163,98,250,166,149,27,231,171,187,86,64,151,59,105,22,249,18,166,8,248,94,78,83,57,134,71,239,120,70,185,207,68,3,67,83,118,223,194,239,38,66,183,159,218,225,253,114,93,11,111,202,191,77,173,229,63,127,226,105,243,246,45,248,46,0,127,5,73,163,107,112,93,126,74,241,16,236,180,91,177,165,61,173,130,80,118,32,172,58,228,150,104,107,212,31,123,237,17,30,44,234,233,185,211,210,223,8,247,137,137,217,197,59,244,40,250,213,11,73,120,177,228,176,192,253,34,225,238,251,157,6,171,253,219,234,147,146,74,189,92,89,238,6,160,85,194,160,135,70,101,76,97,248,151,253,134,255,9,14,43,25,242,169,44,130,204,141,216,55,195,67,103,30,134,192,209,244,173,248,241,20,61,226,163,118,99,145,118,72,254,180,96,123,160,176,7,226,127,54,184,167,252,243,191,57,161,130,49,12,97,241,199,141,41,55,60,162,19,146,155,247,75,10,225,226,220,221,128,154,206,168,220,222,125,135,76,0,146,242,55,164,53,137,215,149,82,154,56,124,6,77,148,15,65,24,81,1,117,203,216,53,159,69,156,0,158,250,179,142,235,45,62,67,216,175,173,50,167,199,33,142,128,195,151,113,210,136,85,170,24,161,43,66,44,82,248,89,161,177,208,190,76,191,149,65,229,201,170,243,218,208,237,136,110,254,110,168,4,121,80,90,21,153,98,250,112,140,237,35,124,247,172,29,105,54,190,30,106,61,169,159,11,59,112,177,65,232,237,109,93,23,169,37,80,16,14,218,33,159,119,19,185,71,40,153,21,22,189,194,182,201,96,171,78,127,218,65,132,42,95,7,6,247,150,154,97,145,162,11,89,44,126,63,23,148,68,80,252,184,139,113,52,224,108,19,37,212,33,60,233,158,135,31,200,9,45,223,226,14,35,67,209,254,3,73,179,96,45,182,104,190,25,103,144,158,123,190,198,202,195,124,164,50,187,208,234,121,188,224,78,28,82,115,150,8,231,149,30,87,238,45,223,117,224,16,200,35,50,226,22,36,250,125,135,42,68,113,230,235,213,161,1,183,10,189,204,177,60,193,198,142,169,158,138,250,207,231,39,208,4,25,117,97,183,158,232,102,94,122,3,190,30,178,177,247,86,37,86,100,254,44,94,27,128,45,112,247,59,100,128,3,207,185,135,40,205,193,248,175,143,195,94,136,145,227,219,239,30,142,214,211,163,25,173,162,55,114,111,171,214,53,7,48,184,22,158,182,122,46,93,216,135,225,114,54,181,104,30,122,85,80,82,111,198,200,108,31,80,32,206,219,106,70,139,254,49,115,197,185,35,246,184,9,30,153,252,233,28,50,24,26,238,147,79,155,17,26,209,144,214,30,165,35,111,123,8,207,99,21,209,242,110,142,183,71,77,82,148,75,128,47,125,223,188,58,221,164,247,148,72,59,92,254,111,216,178,191,110,66,92,36,220,84,10,109,162,215,37,171,139,246,112,185,172,26,113,32,98,39,205,53,63,55,164,24,202,68,254,189,27,124,65,88,135,3,118,202,243,106,15,61,37,200,176,150,114,107,215,213,168,182,100,160,26,21,36,186,19,13,99,128,139,154,213,252,211,126,137,140,203,34,7,245,79,10,9,139,65,139,63,165,8,117,178,247,51,195,27,98,182,46,221,245,98,40,82,89,235,191,117,28,77,218,40,50,149,119,234,74,182,123,42,180,48,72,204,205,184,173,255,194,119,130,136,69,244,199,224,76,30,168,235,253,23,40,18,1,44,194,21,112,213,116,140,109,150,188,19,249,99,22,168,81,169,46,138,199,236,35,207,220,124,149,114,146,57,70,137,121,191,253,182,66,189,2,59,23,9,192,66,246,17,13,201,62,49,240,87,30,14,186,144,221,77,105,0,185,10,121,89,140,201,194,74,46,146,98,253,45,227,236,144,222,164,189,7,167,92,81,108,231,102,170,158,141,29,167,64,8,106,74,123,58,173,21,152,22,233,8,173,62,104,191,141,239,40,164,30,114,83,48,107,243,204,231,156,126,185,106,37,85,251,151,196,141,13,89,138,11,172,61,25,229,17,224,179,205,226,67,254,139,114,87,69,153,135,201,180,201,145,233,159,229,155,95,197,239,247,43,132,7,188,225,196,122,79,34,73,3,223,98,56,49,3,207,101,92,206,191,246,237,111,70,236,37,246,127,146,164,130,234,55,220,20,221,6,222,67,127,85,105,35,127,91,13,49,238,117,0,39,161,129,178,54,79,66,73,82,33,209,83,158,233,38,200,7,118,189,118,237,106,242,145,174,202,71,42,175,114,47,55,106,144,44,196,199,57,237,172,195,246,219,61,49,189,203,8,39,204,48,155,37,255,235,120,229,120,161,184,177,188,143,249,193,78,67,201,172,60,134,109,179,209,228,172,122,195,215,210,44,86,145,2,152,172,253,21,160,40,209,241,0,237,110,119,242,187,221,54,22,124,97,189,129,27,37,77,46,48,9,18,232,88,64,206,216,82,34,67,47,145,179,125,189,115,63,85,20,206,213,69,224,237,20,230,101,30,159,177,169,212,183,180,231,29,173,49,88,81,77,103,175,210,103,4,105,212,6,215,23,144,186,244,151,117,94,148,81,199,66,29,214,220,239,169,14,217,229,122,207,116,130,65,139,12,56,95,158,88,40,115,112,47,157,230,241,125,127,26,67,212,220,90,189,252,97,42,23,237,66,72,133,103,226,25,115,223,25,29,28,233,104,235,24,15,220,47,228,66,97,73,156,185,173,133,63,150,214,28,0,195,25,184,69,209,15,90,131,28,60,39,155,24,10,226,244,136,0,107,240,47,144,215,232,58,253,92,61,196,110,172,28,156,95,4,107,136,221,129,62,117,178,241,180,164,226,219,25,223,240,222,130,106,23,199,86,9,198,158,183,252,211,235,216,42,236,60,135,54,229,12,108,180,91,213,91,211,12,20,131,131,162,74,120,85,179,224,88,96,187,216,176,125,139,97,9,85,73,119,24,233,79,110,45,195,25,135,171,190,154,240,31,95,130,225,212,91,148,142,132,109,97,127,225,237,200,1,51,34,90,3,20,64,154,121,159,163,35,69,252,116,241,143,126,120,100,42,87,205,43,231,252,215,181,241,3,102,242,170,162,168,236,82,115,226,240,52,201,206,53,171,141,3,66,90,204,39,41,59,16,110,244,253,129,74,129,67,245,214,224,79,29,45,210,117,150,226,205,171,212,230,252,237,31,128,167,0,209,72,89,21,176,145,249,23,190,243,112,233,130,223,253,199,90,245,36,81,235,224,239,81,29,141,2,36,183,65,160,54,228,152,8,130,60,114,6,56,79,223,232,209,222,48,211,41,97,84,59,4,214,99,23,155,243,202,66,171,10,231,8,71,215,218,233,62,179,1,141,242,144,124,167,87,58,34,11,207,137,137,201,97,144,145,96,57,171,56,41,14,74,192,229,128,189,155,33,119,31,170,225,92,105,198,98,155,72,90,188,129,4,138,84,60,12,116,219,102,237,79,232,14,91,10,46,139,128,50,156,148,71,134,127,146,126,180,125,173,145,193,98,82,33,178,65,156,145,97,87,230,212,30,43,14,153,249,160,57,109,98,11,244,185,16,92,199,251,81,207,220,13,109,96,181,38,151,164,233,110,83,73,37,221,17,32,187,152,115,189,111,19,102,11,49,154,241,28,14,69,14,55,121,199,14,150,20,255,85,212,76,117,47,214,5,52,106,227,167,61,39,65,124,34,154,160,252,5,157,119,254,84,125,219,74,248,167,137,25,253,71,205,163,205,233,35,146,193,169,56,93,150,48,178,103,193,11,162,195,232,16,115,6,4,53,119,232,121,173,248,91,183,179,172,72,109,20,188,221,235,51,191,231,176,99,91,38,26,185,72,123,14,51,245,213,160,28,52,67,94,48,160,168,211,151,119,168,135,97,83,136,15,95,167,45,243,12,39,140,104,140,90,5,94,31,68,243,43,74,135,54,65,136,174,58,218,89,42,83,65,196,119,84,63,139,65,46,159,201,171,233,97,115,56,159,222,148,108,225,172,23,203,123,237,34,208,79,241,170,188,215,83,47,142,73,150,93,253,182,104,89,90,167,151,231,219,93,142,102,166,4,71,4,35,219,237,192,230,250,121,84,237,240,54,162,21,123,210,225,155,65,227,116,12,234,56,96,252,23,15,137,165,191,222,147,177,166,254,66,66,80,114,235,64,48,206,14,116,161,248,217,26,49,7,107,164,95,59,199,24,130,219,211,86,212,3,134,205,8,231,123,21,179,161,199,217,129,174,187,227,135,73,36,251,192,27,42,104,155,16,90,254,35,248,146,95,164,9,239,54,13,68,221,243,199,137,103,231,211,36,43,238,39,237,36,202,100,223,68,210,187,189,138,24,152,172,187,15,183,237,115,146,6,55,242,177,223,46,86,135,150,10,125,174,110,150,4,63,172,122,132,165,240,184,249,92,178,27,136,123,112,139,249,36,19,200,14,66,196,204,143,92,73,135,153,187,196,250,74,175,250,40,62,96,143,80,60,160,120,41,145,142,194,146,180,84,253,64,96,235,45,105,103,253,4,104,228,228,116,12,172,180,232,16,110,229,204,35,121,237,218,136,104,213,147,139,67,1,113,46,101,169,59,19,89,210,237,112,253,6,126,254,238,78,133,15,23,251,50,50,218,143,79,100,102,80,95,217,137,50,199,91,157,38,236,184,7,61,92,70,189,18,147,139,248,209,146,200,229,244,242,220,222,41,216,239,158,229,72,189,131,182,170,16,68,159,26,105,204,225,245,239,59,210,225,170,171,24,220,38,101,103,186,225,145,107,187,96,162,198,11,4,165,34,139,10,216,160,24,190,180,98,67,48,177,2,21,194,89,248,49,21,110,207,105,217,248,35,177,50,220,161,245,34,91,23,31,56,78,109,0,68,170,34,252,48,53,219,136,52,31,212,160,253,235,190,100,82,73,224,39,192,79,137,54,56,190,40,159,172,188,230,88,211,252,240,191,91,235,9,160,35,170,44,203,191,157,240,255,67,61,85,166,111,57,140,73,203,164,231,188,28,16,123,106,152,248,136,66,113,81,45,153,240,86,66,139,201,235,215,42,37,32,101,46,37,150,146,115,100,191,129,136,38,6,191,95,25,63,102,167,99,104,166,207,255,176,148,170,10,22,81,227,90,159,223,137,209,85,22,181,42,253,148,54,243,239,251,189,20,116,27,70,175,94,55,176,121,116,22,111,229,13,187,171,156,53,196,92,30,77,200,192,72,200,102,20,184,209,76,208,226,82,142,164,100,112,179,93,56,3,216,13,74,213,123,0,182,19,151,123,53,27,23,222,123,23,64,253,25,4,80,123,94,189,2,133,124,107,165,166,169,29,32,239,22,192,116,203,111,67,73,89,150,83,46,83,71,255,114,208,100,186,119,162,36,35,210,109,85,111,190,77,240,65,29,28,61,207,225,175,147,149,193,228,76,164,50,254,180,1,117,119,194,173,97,184,188,188,140,196,54,153,180,222,110,216,51,43,173,50,195,37,254,253,87,40,74,167,24,78,130,124,27,135,88,242,23,233,114,76,161,217,212,156,179,201,6,207,65,183,27,197,212,130,138,241,12,83,125,73,32,151,229,68,118,56,19,145,133,139,24,105,201,42,160,203,159,107,8,128,180,25,221,188,79,165,37,72,5,61,115,195,144,217,102,226,62,30,250,245,122,133,225,75,92,81,89,249,71,225,216,187,50,172,91,24,188,123,100,133,195,38,125,182,233,195,130,92,129,16,250,59,97,131,157,211,181,58,146,195,5,124,64,119,76,124,148,64,168,250,224,218,229,40,165,40,224,137,8,30,55,157,79,67,3,216,140,211,123,15,122,130,44,109,33,234,28,184,90,162,26,88,43,65,237,187,249,58,230,72,114,63,209,94,56,152,177,142,249,128,63,152,203,222,144,40,43,16,251,46,248,103,201,207,44,186,225,93,244,142,62,64,137,40,155,29,50,3,193,232,209,156,128,60,187,35,8,91,181,24,139,199,97,178,39,177,196,221,148,75,187,156,3,17,229,28,134,152,67,205,201,176,135,9,123,240,22,187,131,240,228,206,5,173,148,152,221,76,66,90,192,7,223,173,168,169,61,219,134,16,21,42,119,228,64,9,131,171,159,81,183,117,85,160,194,25,108,232,88,250,111,34,233,78,161,184,169,14,170,157,243,159,120,170,6,249,245,223,231,205,104,79,240,133,32,189,194,103,9,206,160,194,157,221,62,211,192,95,141,136,6,196,92,137,129,148,135,167,81,26,124,63,192,214,155,207,111,215,252,22,96,116,86,171,41,4,125,117,81,152,44,146,200,88,23,230,11,245,254,208,28,85,86,101,15,5,38,48,96,50,208,30,105,248,37,74,196,65,34,46,176,145,72,110,254,108,211,134,32,216,115,212,41,210,86,181,214,160,51,186,31,254,242,187,162,215,96,1,226,46,1,80,66,0,224,183,129,202,47,176,39,108,157,13,211,110,6,21,21,47,64,149,1,199,110,223,230,178,189,243,152,162,215,175,33,150,95,4,121,114,42,242,89,200,39,161,237,34,246,76,33,112,165,226,48,69,180,227,12,244,142,208,231,116,194,123,192,113,174,79,200,162,138,156,191,73,131,109,152,147,123,179,125,6,132,95,217,209,58,72,28,51,17,81,88,105,83,226,106,47,66,248,30,217,133,165,16,136,88,58,105,207,220,34,214,241,111,156,227,231,131,69,183,188,190,174,212,19,67,63,242,215,2,214,249,145,41,150,176,236,234,230,132,203,123,166,79,177,171,83,202,127,222,0,192,132,9,197,165,19,111,80,96,28,59,121,87,137,23,241,168,48,76,193,87,210,14,116,45,29,167,115,29,229,85,75,229,177,242,88,112,55,17,141,106,39,146,231,66,49,12,221,144,33,119,206,17,151,173,196,205,248,130,74,126,131,60,163,115,16,39,21,13,24,255,46,7,162,241,229,93,215,250,234,183,203,7,120,45,171,67,208,202,175,75,206,215,95,15,108,96,228,171,227,92,229,107,144,43,222,179,212,4,165,135,30,53,136,222,100,41,210,198,142,88,31,112,70,59,181,144,224,131,213,47,251,120,132,103,120,61,172,101,112,104,62,220,222,213,248,193,227,32,200,28,40,201,197,226,142,152,247,204,84,33,150,178,122,66,221,125,117,117,111,139,57,199,56,215,251,142,235,76,216,200,180,111,148,113,157,175,42,234,226,129,12,174,6,58,85,184,5,25,98,67,10,74,248,159,250,1,180,50,39,15,38,109,61,230,2,123,220,192,133,96,134,233,47,251,104,40,222,59,102,180,195,46,161,223,39,95,186,130,8,202,138,141,200,168,11,77,26,45,244,31,220,105,237,24,25,154,179,198,164,227,179,20,243,165,175,81,222,97,12,73,40,32,178,119,50,135,124,46,206,16,220,131,184,202,32,81,226,193,29,152,75,188,254,47,5,177,218,189,255,159,77,91,137,58,235,125,77,72,106,104,33,170,166,245,41,186,9,60,221,15,228,82,88,2,39,137,123,108,56,249,158,157,122,9,56,115,154,2,239,114,17,246,78,10,187,133,142,83,240,55,222,193,3,252,64,255,177,4,242,122,102,86,224,78,145,179,206,190,71,184,54,31,41,30,121,221,51,244,201,198,127,128,229,220,99,82,47,44,1,144,127,61,27,221,95,2,206,172,133,62,236,202,204,102,144,137,63,67,29,172,249,241,241,116,64,152,103,105,218,197,247,112,194,42,30,0,71,79,59,63,179,109,138,203,21,102,149,221,7,72,43,98,45,61,89,30,94,191,176,18,151,155,204,15,204,239,139,41,184,67,179,235,73,214,59,102,102,96,200,65,111,147,164,237,116,89,12,151,197,177,38,83,140,102,151,189,50,94,233,111,204,48,58,247,103,97,144,236,195,13,61,160,76,220,255,248,61,62,167,205,132,156,240,81,118,195,38,233,112,77,172,60,151,90,99,92,54,29,66,56,254,174,255,241,7,45,153,50,65,37,227,248,179,146,60,252,154,243,53,8,159,165,141,225,6,144,178,120,29,206,113,61,195,124,239,61,90,100,98,83,117,23,181,117,92,74,224,252,14,114,100,231,65,55,119,86,59,79,139,165,39,105,28,12,226,189,169,21,108,93,198,66,173,208,107,192,30,41,12,111,104,84,16,131,78,171,164,238,207,173,55,123,75,227,15,58,135,160,10,210,17,154,221,200,17,8,75,165,162,177,55,102,112,104,199,72,31,178,180,222,122,207,123,192,155,181,105,236,40,44,67,142,140,26,32,176,162,154,221,81,40,115,122,28,148,211,127,163,0,58,247,83,228,1,99,39,100,129,207,136,177,12,11,208,219,231,111,76,63,120,178,188,24,168,15,58,60,252,100,157,234,246,196,93,19,163,22,153,131,91,10,146,0,109,252,194,150,46,227,113,86,51,90,186,185,237,152,139,170,167,118,254,221,24,247,201,67,107,229,171,43,213,199,228,229,133,125,25,55,171,249,86,111,205,115,38,147,197,146,127,216,32,247,112,83,34,239,158,122,215,147,89,228,7,166,213,73,38,140,202,170,248,176,176,124,246,185,39,17,222,115,136,8,140,53,93,149,13,105,100,69,13,173,238,234,39,181,124,103,122,221,133,211,237,136,9,218,32,223,57,64,53,35,27,246,53,137,148,127,81,177,115,87,21,8,154,164,3,124,151,224,196,242,35,30,28,238,77,173,117,164,49,227,235,44,237,77,255,81,197,35,11,180,57,51,0,98,116,55,22,253,214,63,175,81,212,88,246,20,132,66,110,8,63,61,47,220,184,170,78,188,35,21,26,2,238,151,57,255,6,187,249,137,80,153,185,244,5,31,50,180,200,222,202,213,214,77,168,197,9,248,29,178,47,204,115,43,75,183,61,54,45,140,7,110,75,0,15,52,70,107,165,241,158,56,136,10,1,10,207,96,32,96,189,74,161,10,116,242,115,44,143,238,102,53,158,72,147,11,207,172,182,212,193,23,208,109,226,90,83,121,175,192,208,223,25,145,133,218,190,105,121,130,155,182,124,116,227,47,102,28,163,77,230,41,29,227,88,161,29,192,58,83,92,237,138,134,225,176,172,37,98,161,200,199,112,22,212,201,62,190,9,190,54,20,110,138,28,237,72,54,134,186,153,230,200,43,25,17,207,167,193,101,104,172,186,189,82,2,242,114,59,55,11,161,8,244,1,32,59,181,71,10,95,74,196,39,72,140,82,209,49,4,234,170,30,111,174,101,115,76,115,0,248,37,222,166,242,140,164,242,20,254,104,144,149,216,40,161,130,232,193,143,212,153,245,237,135,78,60,235,47,77,245,110,120,167,192,95,59,11,165,42,149,19,142,74,88,12,178,128,101,115,175,184,173,139,205,49,214,38,45,19,36,252,176,210,47,107,239,0,70,91,159,184,235,2,252,84,52,177,11,150,157,223,89,5,188,19,117,27,240,226,184,236,142,167,63,103,223,118,6,146,164,220,184,119,86,78,195,112,225,126,115,70,29,51,212,194,169,51,210,210,151,10,248,178,28,101,191,255,217,85,187,216,61,136,115,68,154,228,164,183,0,21,136,187,62,239,212,200,185,29,181,92,74,74,51,231,194,215,77,159,209,204,114,133,73,30,165,164,184,206,252,228,51,128,22,168,80,141,164,3,4,1,176,65,246,203,181,227,70,211,30,44,60,244,200,133,163,160,113,7,79,52,115,194,223,104,42,167,205,169,79,187,249,220,254,250,242,117,60,229,136,25,157,121,243,179,98,14,205,52,203,23,73,22,216,30,134,246,88,120,74,134,165,149,85,188,121,243,79,121,147,96,82,110,31,18,36,100,21,1,30,94,219,105,133,52,117,107,132,86,56,78,206,245,233,23,122,203,90,18,74,139,54,82,31,125,231,142,9,203,191,193,63,85,91,152,163,224,133,69,233,252,8,195,208,191,8,119,235,49,215,218,243,234,1,224,34,238,247,174,130,179,128,164,81,93,185,46,87,132,223,217,159,101,192,165,214,190,160,108,179,199,188,151,239,58,121,51,60,240,92,241,25,101,157,33,231,160,137,114,185,125,131,103,155,31,69,58,113,60,211,135,16,127,178,162,141,228,135,5,223,171,116,74,144,89,244,154,53,243,46,200,229,67,67,9,12,2,104,224,115,44,54,38,139,184,95,127,171,142,27,104,86,226,171,146,150,109,191,116,121,3,248,10,99,5,15,212,78,131,54,109,48,141,32,10,148,195,13,14,237,28,192,49,84,25,48,230,33,17,247,236,4,164,167,143,86,96,230,20,194,194,101,255,246,117,196,177,216,141,61,57,141,224,58,96,1,18,218,139,12,249,71,147,90,22,216,13,235,215,21,49,151,11,154,254,173,172,7,141,231,46,28,178,242,88,136,183,45,1,91,39,134,25,191,212,7,172,207,143,130,67,59,89,236,39,188,52,53,253,43,223,30,114,57,77,247,243,197,48,58,162,114,45,20,239,100,44,219,74,160,50,90,185,20,213,213,236,81,115,163,134,41,60,35,155,180,236,118,32,122,89,168,42,126,0,153,78,150,8,72,28,187,182,197,44,140,246,232,86,5,167,157,178,237,206,73,86,70,235,113,45,114,223,23,145,32,128,73,190,184,61,192,38,109,153,221,131,229,102,135,49,99,115,73,220,28,78,147,95,85,253,21,129,57,129,168,137,121,153,238,125,100,16,212,238,0,242,190,149,219,117,152,217,183,105,65,60,32,94,162,49,104,208,172,155,109,107,242,172,204,131,53,244,35,138,76,158,130,104,186,85,19,22,195,208,115,255,67,215,250,42,246,151,174,153,17,25,0,39,74,206,32,32,243,16,68,29,99,253,151,121,48,56,233,48,44,179,172,48,25,53,169,153,169,195,166,164,113,43,85,195,73,38,132,99,206,44,139,107,177,239,57,146,38,76,219,152,109,91,198,216,168,117,194,41,212,10,4,239,211,40,132,182,70,32,240,21,117,90,35,144,172,189,82,27,91,146,123,19,20,193,138,93,0,79,175,19,93,124,252,4,237,125,38,122,61,120,238,136,22,207,201,237,107,194,26,189,232,77,116,31,161,129,69,121,89,103,158,47,33,194,151,68,227,239,231,124,241,173,134,153,107,238,161,242,11,166,203,194,43,244,57,111,48,123,153,160,218,168,236,58,5,119,97,49,243,93,141,189,71,226,225,42,189,47,227,227,116,156,32,22,213,148,59,19,43,75,233,170,63,236,203,65,227,126,253,94,49,67,31,141,0,15,33,181,216,62,162,252,72,66,79,181,233,132,160,77,166,57,55,32,108,189,13,65,39,14,160,155,49,105,20,236,106,62,31,249,13,13,44,182,99,19,199,223,98,69,251,15,79,227,109,209,181,206,125,56,37,122,166,190,12,122,12,225,20,178,171,89,119,221,133,153,251,235,216,33,37,108,220,107,65,233,160,5,36,158,189,13,246,80,187,59,13,110,203,135,39,61,67,17,206,186,204,47,51,19,129,140,71,223,164,146,253,45,174,64,201,158,110,120,235,74,174,153,152,28,153,68,153,0,92,162,45,2,132,5,20,215,253,81,250,66,165,199,209,205,217,192,92,54,208,218,241,106,59,65,215,141,182,165,9,135,192,218,231,16,135,1,233,59,133,196,25,101,101,0,182,54,58,175,196,179,212,46,76,142,248,64,35,143,208,145,195,70,104,168,28,224,42,162,231,47,202,223,236,170,30,37,209,234,165,104,55,114,122,179,212,113,215,173,1,162,98,126,11,179,102,216,76,193,28,8,226,192,100,171,42,24,146,175,118,121,137,39,65,98,0,203,17,156,64,148,197,220,168,110,73,98,41,179,41,83,201,153,252,77,64,46,247,136,106,203,59,47,116,187,166,227,134,172,247,157,196,187,17,117,56,92,173,73,140,35,153,102,95,163,168,148,109,36,203,74,43,137,142,197,88,210,230,16,137,188,205,113,230,128,145,239,240,72,22,229,3,185,119,121,150,197,152,80,216,163,24,86,189,0,82,125,120,144,77,179,209,210,30,42,83,24,27,244,106,153,46,93,57,85,5,12,187,102,174,107,36,38,241,17,126,41,238,185,113,146,132,26,8,101,86,45,161,102,200,90,30,201,206,126,64,85,214,41,200,47,160,211,237,253,46,135,33,172,64,210,119,123,86,81,253,193,131,12,175,89,131,188,119,172,4,148,90,245,122,47,70,104,71,224,0,38,108,167,71,200,114,103,181,125,186,18,111,93,189,73,65,147,149,245,146,244,28,29,248,12,101,218,169,68,43,73,156,242,182,229,134,32,118,233,230,114,42,211,89,185,176,135,178,189,49,170,10,88,239,75,8,2,5,55,35,221,122,217,223,174,202,146,98,24,151,84,50,135,224,104,176,129,111,245,89,4,73,127,123,54,0,223,101,177,18,56,220,28,113,161,181,230,80,24,176,101,86,52,76,168,25,6,149,85,166,116,108,31,68,87,91,21,89,93,237,78,191,192,42,56,15,101,252,154,40,119,226,156,140,128,85,226,225,95,210,120,40,188,65,115,133,16,15,146,21,83,89,192,179,202,140,96,76,147,141,100,131,94,103,141,146,220,69,122,121,20,70,48,61,82,118,139,209,176,188,216,241,91,98,54,183,64,33,230,174,198,188,25,182,53,116,17,200,99,195,112,132,250,106,172,48,64,247,213,148,109,12,90,40,193,25,72,117,197,210,231,233,140,124,187,32,7,68,238,122,51,135,253,150,202,126,133,60,101,215,196,68,73,12,67,56,59,245,107,109,246,54,231,73,235,148,220,85,107,204,97,84,104,137,89,35,150,247,80,5,110,228,12,61,205,174,27,94,135,39,235,118,133,91,102,33,0,215,112,76,26,255,126,144,81,2,209,204,105,157,144,134,30,116,24,145,246,75,119,230,208,167,239,192,161,39,95,30,92,194,4,192,220,99,137,237,243,58,127,2,48,67,132,181,193,133,192,209,181,229,40,230,184,29,168,60,177,3,42,78,246,240,232,4,193,173,42,127,184,198,64,96,163,246,18,111,103,21,113,41,40,23,56,83,197,53,42,224,66,227,59,167,248,123,151,116,1,255,148,178,87,243,174,24,88,137,104,52,54,207,230,243,170,115,94,168,169,245,21,86,21,179,43,187,227,208,150,182,160,113,111,125,142,87,194,166,11,75,50,45,114,11,36,57,110,113,161,240,120,220,134,34,51,43,154,63,86,233,43,244,126,5,14,84,163,127,127,159,204,55,246,16,215,154,228,125,34,235,97,1,168,196,176,28,43,78,157,118,104,56,35,178,3,156,3,255,9,217,114,254,143,106,228,35,164,131,45,90,23,86,99,244,58,41,97,182,84,169,210,28,250,95,7,197,211,51,144,211,191,156,243,132,154,220,172,210,36,116,247,0,184,7,220,89,145,221,112,174,220,249,242,229,208,132,14,0,84,199,151,165,32,11,250,86,199,12,189,125,230,124,93,160,243,7,30,82,73,11,153,50,132,113,142,212,215,13,219,9,63,68,203,195,148,227,118,250,65,243,184,243,49,18,77,35,11,95,18,116,192,124,242,136,201,103,232,143,1,106,68,33,166,194,172,245,43,249,118,157,38,152,228,206,156,131,7,65,27,221,81,27,217,229,80,130,87,133,255,65,66,133,188,209,124,183,136,100,143,50,153,169,163,64,64,211,142,81,169,66,34,248,173,178,231,133,201,1,166,41,4,121,201,88,58,56,52,103,253,24,80,225,139,104,107,133,78,113,148,61,119,233,203,166,192,99,52,122,254,135,196,78,183,154,79,250,102,253,244,165,82,22,75,105,195,94,253,73,42,116,14,45,11,121,36,140,217,105,224,202,145,118,88,135,158,6,91,224,14,162,118,241,125,112,163,35,250,214,237,115,42,63,215,208,164,3,154,55,168,121,81,16,115,88,117,253,180,188,224,239,68,151,57,22,41,234,171,99,59,241,204,242,84,45,159,255,222,38,9,84,1,49,56,134,143,89,181,165,185,29,29,239,16,48,195,232,213,237,183,43,32,139,187,1,195,167,199,153,156,240,42,87,152,157,141,162,26,148,22,150,111,60,129,149,227,200,64,210,137,163,184,98,16,240,12,161,237,87,228,187,185,73,229,127,138,117,39,19,27,130,86,222,44,214,126,106,215,234,202,13,191,206,183,138,68,117,178,105,17,49,224,155,150,176,8,230,244,239,117,182,213,116,208,209,33,0,136,126,181,235,249,232,3,58,68,125,108,31,223,80,19,207,204,175,222,91,74,254,43,173,133,182,154,93,236,129,116,221,176,81,207,56,127,179,172,213,198,5,79,100,43,226,186,177,18,163,184,43,32,46,36,91,186,101,229,164,121,81,164,227,252,80,101,22,79,135,89,81,253,133,158,91,31,76,8,47,206,31,0,238,182,247,79,129,89,169,157,137,128,33,28,6,233,229,57,45,42,206,136,196,76,136,12,241,34,166,7,217,222,107,184,55,157,102,158,38,20,29,95,130,215,25,240,85,90,39,233,41,152,190,142,150,206,81,118,212,142,178,8,109,137,189,184,163,99,199,115,57,163,0,79,93,51,195,20,200,211,202,8,31,177,0,125,249,48,231,196,169,143,146,215,10,145,6,131,100,232,89,38,149,185,145,53,228,252,70,173,97,26,83,201,29,181,20,106,65,58,41,58,72,230,237,38,244,183,23,245,192,99,172,255,26,25,192,248,157,26,123,187,74,143,144,94,222,96,145,174,132,240,9,72,74,241,66,75,77,186,26,222,36,170,164,39,29,201,187,47,230,32,72,138,96,202,237,235,52,221,97,103,197,87,164,85,29,189,47,240,64,198,185,232,104,35,157,214,194,130,237,141,72,109,207,206,172,16,130,212,126,158,35,51,213,13,50,16,167,26,43,129,242,225,133,46,79,56,112,230,170,124,171,114,90,7,125,123,9,84,82,255,81,243,165,152,115,217,170,205,251,162,202,54,78,33,62,155,172,205,30,234,122,68,211,75,33,87,63,205,135,127,237,37,206,113,121,213,191,16,154,67,235,95,181,165,236,173,151,140,159,125,75,19,4,27,199,243,36,37,225,176,4,165,34,122,194,17,190,155,124,235,209,71,46,31,71,32,146,5,6,92,5,86,25,123,40,55,80,59,30,250,213,11,96,93,161,223,222,158,170,35,183,59,30,148,55,55,247,58,229,44,112,100,11,241,30,100,195,100,168,105,199,10,152,58,19,229,151,248,188,90,240,247,122,75,114,194,146,135,57,221,111,240,72,68,86,156,5,102,224,223,41,246,126,31,192,159,143,32,230,138,25,124,47,173,9,1,247,205,168,21,216,132,155,83,25,178,142,91,111,12,146,151,195,220,36,0,60,66,223,243,141,254,137,201,59,233,166,47,244,220,221,112,92,216,236,73,28,141,151,34,152,160,102,210,190,173,127,155,47,21,56,77,190,232,14,146,181,151,62,221,239,209,247,75,0,213,202,141,13,129,110,7,230,221,74,3,68,234,39,151,136,233,39,245,187,213,91,90,200,169,103,49,202,91,148,87,55,68,249,151,155,85,177,138,218,207,22,119,151,106,249,99,60,4,213,58,240,151,60,98,235,232,196,10,63,86,225,58,214,141,15,94,70,120,3,18,13,180,115,43,181,56,100,65,112,88,66,177,93,154,69,244,129,7,39,28,21,83,63,203,200,113,212,227,87,52,181,15,44,35,149,110,43,110,100,80,220,19,97,99,185,68,205,106,183,58,135,189,214,233,11,138,76,146,253,231,180,214,241,234,101,47,244,81,85,176,181,77,156,101,146,24,175,230,71,51,165,88,19,47,223,245,126,247,186,194,179,85,82,205,254,252,182,97,157,159,51,195,43,94,122,27,138,83,19,105,240,20,47,196,203,209,218,57,175,249,61,22,66,191,90,48,119,135,100,193,147,153,54,174,58,193,247,76,191,124,111,75,115,1,192,98,137,192,32,14,24,195,160,31,4,207,206,250,213,101,120,203,119,163,5,229,219,183,63,80,165,101,252,91,93,246,199,226,158,27,14,79,78,17,149,190,29,26,198,29,207,89,193,253,157,115,102,106,47,253,52,201,223,149,20,115,26,70,115,237,247,243,245,231,42,179,109,163,47,55,225,51,150,149,216,0,25,164,178,26,190,207,49,247,168,233,27,109,171,140,74,167,74,100,31,179,218,30,2,156,155,126,226,32,2,75,81,136,17,79,58,2,83,235,197,151,140,223,102,186,70,156,44,244,96,233,31,153,171,144,128,103,221,233,144,38,254,9,154,67,168,128,48,99,14,16,201,9,106,165,203,132,243,216,81,80,173,107,255,57,58,131,184,196,96,122,232,83,217,230,171,106,198,50,202,248,105,111,224,251,75,9,145,82,17,58,28,250,71,197,96,148,141,101,34,142,212,85,181,62,123,175,249,213,54,24,255,135,62,105,46,125,184,48,235,173,0,194,142,229,236,226,179,248,89,166,7,241,7,46,99,248,20,63,101,222,118,125,107,146,45,72,51,77,106,215,68,59,72,100,10,188,240,137,47,149,143,148,57,16,252,82,73,160,211,113,142,142,201,95,221,215,203,212,123,56,33,199,26,157,47,199,218,0,39,155,41,253,131,93,102,93,170,157,68,10,235,28,243,30,97,223,18,175,228,147,128,136,38,250,157,10,201,60,190,196,180,153,222,37,5,164,170,2,35,23,204,121,159,54,90,98,126,30,163,24,236,226,137,46,75,120,143,67,122,177,147,90,2,90,7,79,170,32,164,206,97,117,63,222,73,125,145,230,146,78,99,35,214,47,13,107,205,111,152,23,234,181,67,0,72,48,200,25,29,118,17,185,39,76,143,210,111,253,111,0,110,234,128,80,15,237,167,89,11,112,189,109,234,87,218,59,43,234,184,250,248,149,54,215,251,242,193,227,60,238,105,159,132,62,35,68,4,87,128,245,22,16,244,200,84,43,180,65,166,109,136,73,175,56,76,156,206,114,237,130,166,181,240,130,143,31,35,19,95,105,46,204,214,131,2,199,193,198,197,3,150,86,226,175,224,158,149,130,126,45,44,138,29,234,225,8,35,106,217,104,130,180,139,109,237,136,66,29,90,137,130,207,34,233,38,20,85,117,120,234,125,197,21,185,151,135,245,143,37,127,134,240,161,113,60,71,96,69,228,52,159,49,18,253,141,59,2,94,175,165,71,143,121,189,195,119,246,24,75,27,236,145,157,0,22,104,121,183,140,30,17,78,222,94,7,223,46,168,236,100,168,22,255,182,182,223,136,217,238,107,186,187,232,107,236,168,241,254,9,141,42,8,185,196,130,129,200,187,230,27,174,32,111,210,104,61,218,82,73,139,199,197,109,254,194,133,62,168,130,191,160,27,255,222,21,193,142,39,82,238,60,85,250,232,121,84,10,240,217,205,191,31,101,206,26,19,30,177,160,124,201,30,0,34,109,165,83,232,71,178,136,155,197,239,160,140,240,180,86,15,81,125,206,219,237,25,58,4,44,69,239,78,138,148,216,137,69,170,73,115,213,212,93,242,137,199,63,229,242,30,11,74,158,152,90,138,39,233,218,19,91,173,1,179,74,99,55,24,6,156,29,62,118,206,148,170,125,230,185,213,104,101,130,13,252,57,97,204,93,235,78,225,172,9,231,157,97,246,101,139,250,191,57,78,51,75,32,177,127,240,88,139,111,6,64,5,229,171,95,219,139,81,224,69,73,24,30,233,212,37,26,250,252,116,65,104,43,46,90,231,14,195,3,100,60,11,220,121,176,69,190,120,35,215,165,163,235,31,16,248,142,121,248,36,162,244,153,5,132,247,179,24,119,149,138,224,122,212,91,194,207,253,84,217,246,150,20,255,50,198,181,45,59,130,10,103,43,180,98,14,49,53,161,186,76,10,97,193,140,95,27,92,139,166,34,60,172,24,65,208,134,16,232,195,157,165,32,35,219,159,136,81,185,104,197,26,141,159,166,203,45,114,38,188,174,25,246,2,102,194,226,148,15,89,37,237,87,46,12,26,69,223,206,96,28,21,111,112,116,144,151,127,69,226,182,253,33,56,236,53,136,167,198,186,45,153,231,149,115,104,165,135,36,98,23,103,23,118,139,9,225,137,45,169,27,234,69,226,115,226,65,90,2,185,20,153,65,38,144,241,38,241,106,170,208,106,74,23,108,103,29,76,246,163,17,151,171,8,77,75,133,215,58,250,79,206,202,254,227,16,8,25,45,92,41,234,158,245,193,107,194,78,241,145,122,84,118,151,177,249,183,83,70,190,41,199,120,113,212,37,239,206,233,174,160,56,238,121,50,105,40,33,141,12,16,10,239,238,131,16,229,88,86,215,67,75,28,155,157,201,10,190,228,94,28,13,165,240,158,233,223,45,163,17,112,137,135,136,167,14,171,92,214,197,34,24,237,3,207,244,29,241,17,158,131,69,131,189,86,227,204,233,97,39,114,132,102,172,185,239,255,38,120,50,245,254,139,220,103,120,66,188,18,198,5,213,83,195,190,70,48,190,45,33,118,174,209,233,178,215,223,218,172,4,151,148,156,100,11,111,41,73,221,191,179,28,181,216,233,44,86,189,124,86,177,35,31,219,43,199,205,198,100,104,167,168,235,226,73,191,241,32,66,235,185,96,156,146,254,207,237,87,10,105,122,248,223,28,6,102,108,11,202,236,97,187,171,30,78,74,13,87,121,43,94,95,116,207,86,206,231,180,28,119,207,56,190,247,228,10,4,161,20,150,70,249,219,223,56,254,210,207,216,250,52,172,223,83,143,182,136,117,89,91,4,92,185,86,247,3,125,98,43,203,211,36,202,219,38,192,33,148,164,182,148,120,69,46,9,209,247,249,178,70,211,73,53,36,112,238,209,139,50,211,249,161,211,178,237,176,203,179,82,34,169,141,215,110,161,189,200,100,105,204,2,126,144,47,138,193,235,239,214,226,211,66,244,177,190,86,50,80,108,245,82,197,40,56,98,137,8,185,65,182,102,75,75,226,244,230,63,81,139,188,48,110,182,132,94,56,209,251,158,67,69,223,87,162,144,194,235,158,67,38,225,20,203,122,184,172,205,76,135,248,200,179,137,25,230,6,207,56,223,87,119,54,81,82,60,131,179,237,201,226,160,224,3,237,116,191,177,187,116,164,78,114,96,54,102,19,68,119,154,205,223,24,38,198,131,105,56,76,87,88,191,133,38,47,202,139,137,168,7,154,87,126,73,134,156,74,5,63,134,53,237,160,193,94,100,136,183,217,226,65,140,187,35,12,77,52,174,197,243,124,190,106,148,54,189,180,43,237,251,23,97,14,94,210,44,84,13,110,183,127,255,178,116,63,209,64,123,60,157,27,83,251,34,30,156,87,242,125,143,195,173,192,222,236,43,37,138,137,123,82,39,209,185,66,116,242,74,49,186,142,137,105,207,162,67,163,193,35,249,140,90,140,104,211,63,172,190,14,175,37,32,123,115,193,213,238,181,97,205,117,111,56,228,104,226,252,151,87,47,109,4,195,16,28,145,198,104,203,50,17,110,119,225,150,107,43,96,3,216,249,158,252,142,211,89,197,31,143,134,88,223,117,48,93,73,250,35,195,88,227,16,191,71,73,174,18,162,148,80,15,119,94,190,64,106,176,63,62,160,205,0,97,171,192,51,187,242,42,246,235,34,184,232,13,224,148,223,0,90,125,19,204,91,245,4,187,63,105,9,105,222,115,36,58,246,121,79,18,125,20,172,106,3,154,33,109,95,93,187,135,112,116,3,128,159,20,165,8,114,171,144,230,45,122,176,204,41,128,124,238,105,36,94,91,124,22,61,133,34,68,151,115,111,167,75,1,139,38,200,132,169,156,42,151,155,199,168,202,26,227,8,53,108,114,153,77,215,236,168,141,114,228,145,212,99,184,136,164,194,82,71,174,141,155,140,112,144,124,42,119,54,119,7,39,138,190,93,41,204,131,85,230,147,52,46,245,22,47,48,183,242,181,65,55,25,215,183,232,35,198,177,143,96,116,156,120,227,149,193,69,115,75,133,247,163,204,115,49,176,72,202,166,232,28,171,189,132,145,36,92,64,158,114,72,91,57,104,31,124,115,122,39,241,69,50,183,137,124,206,92,11,86,30,86,144,177,59,57,131,72,77,210,73,81,25,64,215,124,134,188,253,48,121,30,195,189,8,146,27,121,217,72,93,5,4,39,255,124,187,170,242,34,105,219,193,132,239,19,5,5,176,38,251,14,230,211,141,91,251,11,90,184,160,235,244,160,196,75,35,244,104,191,236,251,233,132,231,165,142,177,221,67,186,57,196,199,78,112,145,2,42,159,36,67,211,69,178,164,201,220,128,203,219,190,139,32,22,124,219,168,160,236,241,31,208,249,40,201,35,203,200,49,208,51,222,68,216,14,69,88,211,113,18,225,197,175,148,212,155,109,176,134,230,53,201,235,178,173,52,38,55,63,208,23,166,16,215,125,38,175,173,224,161,245,155,128,154,249,140,163,238,225,90,102,197,156,36,167,161,92,124,193,140,92,26,136,79,105,51,227,99,195,188,238,97,250,65,240,191,20,70,36,133,26,160,158,163,64,234,174,2,123,251,194,152,134,187,121,81,84,198,63,113,215,25,233,199,56,49,108,178,168,72,16,243,20,215,139,132,72,175,128,35,119,217,88,161,43,106,209,183,210,68,238,94,111,212,184,204,106,165,134,112,223,234,199,241,164,96,172,98,75,174,102,135,229,120,219,131,85,145,141,124,133,156,144,10,19,74,152,183,78,203,130,36,158,107,111,46,63,182,3,221,172,31,233,135,135,130,49,95,3,128,132,223,250,85,22,233,195,208,3,253,82,40,42,97,68,99,91,177,204,116,200,137,174,231,169,61,139,162,214,50,122,111,193,253,128,82,223,190,113,178,27,83,51,2,119,129,219,47,65,141,254,76,151,77,88,105,106,31,133,137,6,204,81,18,91,157,204,57,112,57,134,41,97,27,177,162,241,114,64,201,144,222,33,132,179,219,138,60,246,202,226,182,110,29,236,107,157,57,66,4,39,224,37,8,124,73,193,200,110,27,83,228,113,131,234,9,211,111,102,148,245,88,75,217,172,85,162,62,31,249,14,241,228,198,44,98,120,59,1,24,213,63,22,22,237,200,233,176,125,99,224,35,126,94,128,72,49,27,104,153,245,84,210,42,17,0,144,104,243,129,119,133,89,94,52,28,22,189,228,157,37,140,30,47,184,218,119,8,54,217,69,83,34,130,74,250,73,184,113,130,215,201,131,99,189,1,8,200,29,178,50,92,12,84,149,5,93,213,17,188,67,176,235,109,191,159,4,7,187,117,147,163,62,152,211,208,76,24,35,192,181,176,135,176,78,201,5,28,187,5,227,27,72,252,78,176,13,79,97,158,113,180,46,184,180,198,237,144,195,190,104,235,89,14,95,97,83,212,112,54,28,78,211,161,54,136,211,33,205,95,178,41,74,178,92,199,248,164,96,19,0,120,130,27,73,193,1,135,242,110,50,3,169,161,148,48,249,94,117,238,7,167,21,219,46,180,70,215,190,197,232,169,5,234,167,255,112,209,29,82,219,0,194,171,131,110,170,216,205,164,214,224,105,18,197,65,165,245,254,55,46,87,50,252,13,53,214,253,143,103,189,124,144,222,145,209,124,125,107,56,6,187,101,50,5,188,179,18,174,115,200,127,104,111,53,150,3,132,139,68,220,91,148,177,137,6,141,220,149,31,39,222,221,110,64,92,16,159,163,255,164,184,206,13,135,251,208,4,164,99,8,231,136,42,161,199,103,200,183,56,61,122,109,184,64,223,218,22,73,35,77,212,113,195,57,175,39,71,183,168,55,171,185,248,87,0,242,149,17,111,225,122,73,125,112,245,220,95,15,185,195,12,194,26,43,209,168,42,252,104,143,110,211,129,200,30,81,146,12,213,98,108,105,203,244,184,177,50,208,89,145,213,118,203,216,245,175,188,137,27,55,178,117,129,93,112,147,211,147,58,137,159,177,70,6,206,210,219,123,37,224,151,170,169,97,101,214,176,245,116,13,43,17,226,190,247,51,15,199,19,205,10,62,214,1,25,79,200,80,249,35,169,89,246,224,58,104,176,130,95,161,117,212,9,200,205,166,205,51,210,77,121,46,88,199,42,91,39,12,255,70,140,211,81,37,223,8,100,25,121,71,129,194,142,178,88,248,224,229,184,66,254,214,35,132,127,49,111,7,167,104,157,5,217,115,66,33,69,81,92,2,176,166,123,165,15,183,110,185,62,222,31,10,206,8,42,119,197,140,95,242,199,149,239,200,122,200,11,187,158,232,235,47,185,102,110,154,153,6,120,54,107,8,58,117,181,1,16,201,50,63,248,217,31,29,171,250,222,3,129,9,238,84,92,69,169,208,103,69,169,16,37,102,170,25,242,245,36,106,243,193,239,2,50,184,190,26,2,227,111,31,73,133,106,223,164,76,194,161,51,214,12,4,3,210,62,223,139,216,82,137,141,74,84,93,185,43,215,136,101,176,170,130,52,168,25,198,48,169,37,176,21,102,9,153,228,159,208,198,195,68,227,22,247,36,46,19,136,111,170,200,54,60,96,249,9,60,150,116,225,90,132,168,106,195,179,44,68,52,66,25,158,64,96,208,102,90,10,179,160,210,10,155,110,108,24,218,78,240,99,174,144,194,186,161,128,240,123,36,235,118,57,67,65,56,7,91,62,112,67,53,105,204,214,106,166,104,138,129,217,201,42,39,190,78,205,220,159,109,172,180,75,25,250,127,125,14,192,46,8,131,116,184,100,183,98,163,127,202,40,223,121,80,132,219,103,23,222,61,246,247,153,43,82,132,112,1,176,178,93,151,67,215,171,211,87,85,255,185,132,218,251,1,134,117,68,220,65,73,87,184,177,31,29,151,161,156,7,229,216,11,116,29,159,108,185,79,141,197,222,130,249,127,107,123,132,248,243,82,195,43,32,216,6,233,47,47,48,145,165,164,152,18,30,233,65,188,88,59,70,73,34,5,199,51,99,78,190,251,237,63,232,15,163,38,15,169,178,193,58,235,27,99,39,233,200,188,104,177,78,139,252,205,148,8,210,218,112,82,70,157,253,105,46,181,129,47,251,162,157,234,92,36,18,113,94,143,65,249,138,5,235,212,59,136,226,223,26,171,96,71,30,113,1,209,158,244,213,117,155,102,103,166,208,139,27,175,37,61,211,29,224,127,194,182,201,45,238,209,193,29,207,214,1,167,190,40,137,48,51,79,236,153,62,47,5,28,123,120,106,178,251,16,188,118,145,156,166,77,83,153,202,10,230,5,93,2,159,92,51,42,163,39,166,215,204,178,112,2,219,159,52,163,231,205,19,130,115,60,50,65,58,216,220,36,15,129,156,40,128,73,185,71,89,17,128,94,191,133,86,249,33,181,73,176,107,92,98,189,185,180,150,148,157,55,121,218,199,71,105,122,224,218,17,132,161,63,54,58,165,163,214,231,209,189,197,127,33,211,99,149,24,2,215,157,126,242,151,138,30,243,91,123,207,132,190,8,71,214,45,95,145,204,100,123,58,44,117,220,242,185,44,229,141,134,8,48,212,210,146,165,93,95,12,246,137,25,117,253,5,137,193,245,164,118,4,45,47,77,152,13,111,206,128,197,103,177,31,53,189,233,5,74,67,54,99,209,12,169,155,198,16,181,1,228,60,36,16,226,48,39,128,190,52,87,82,15,197,106,102,251,152,252,254,74,51,164,199,114,230,248,198,177,230,246,47,156,204,210,182,210,26,211,237,107,49,81,211,10,169,223,205,212,207,24,120,5,85,200,218,89,142,189,167,137,162,77,114,117,208,40,146,250,247,221,42,173,187,1,60,134,61,9,107,79,242,208,199,63,91,114,191,228,21,127,116,157,36,150,159,18,8,156,192,247,5,98,208,179,216,102,44,123,54,28,37,65,141,25,107,201,191,28,70,189,103,157,180,33,125,148,242,183,54,75,72,21,134,251,217,251,10,220,180,75,123,6,120,129,171,225,30,167,179,84,25,24,127,136,40,1,211,42,30,202,61,245,6,38,56,223,61,29,151,133,192,67,179,159,255,6,129,55,188,72,112,217,213,178,225,96,67,194,92,41,44,2,59,222,89,101,64,248,218,52,63,152,55,211,130,56,47,82,123,17,186,169,202,11,223,74,22,19,208,203,0,87,180,81,108,181,99,197,235,147,17,108,62,147,71,109,29,37,39,176,236,39,152,53,66,141,212,210,31,233,149,82,38,14,59,51,47,16,173,145,249,226,125,36,54,129,15,249,97,69,226,16,12,49,237,229,36,34,66,79,82,178,105,221,27,153,206,91,64,195,217,35,139,7,120,124,233,15,213,253,195,219,152,62,171,88,191,238,56,83,21,57,87,193,205,185,186,104,215,179,133,151,154,71,48,13,40,205,27,248,144,131,180,28,46,36,92,129,182,10,99,140,228,134,116,17,125,105,254,91,143,125,86,108,50,78,133,243,98,226,5,241,123,231,59,177,1,34,38,223,226,204,252,193,175,131,134,222,62,19,225,252,53,139,238,107,41,183,2,175,80,54,142,161,202,4,240,223,44,125,114,239,7,185,92,161,77,74,52,170,43,92,182,164,25,37,254,241,156,168,149,24,24,131,41,100,243,172,242,112,201,218,99,194,156,73,107,76,185,252,51,44,126,211,95,191,79,191,11,136,220,144,75,4,246,78,246,118,20,171,4,158,60,65,199,211,43,10,166,239,119,104,124,86,151,137,210,121,98,240,177,40,27,3,244,216,117,69,203,227,70,117,247,70,83,40,50,144,191,216,200,120,99,127,194,181,85,30,131,43,241,33,235,243,14,197,184,178,229,204,78,243,150,179,242,92,190,244,35,173,61,128,122,85,61,138,112,83,95,174,142,204,217,234,129,193,166,29,248,2,240,106,82,1,230,98,119,122,5,90,39,158,34,240,83,166,187,99,73,100,49,78,8,37,161,154,166,29,74,29,56,218,139,81,128,225,238,129,208,154,166,211,156,27,18,195,102,235,13,121,195,155,209,74,21,162,209,158,228,231,232,234,189,201,63,16,3,139,137,137,90,84,36,248,68,54,215,46,190,24,175,19,93,26,174,149,29,110,203,171,52,103,18,247,48,64,208,76,243,10,139,188,174,118,164,0,53,23,135,239,147,163,116,241,217,130,245,97,219,232,222,236,144,211,158,13,166,255,55,138,202,14,206,227,56,41,220,121,132,155,132,215,126,78,232,161,32,196,241,181,238,73,184,192,44,169,148,3,82,28,237,235,51,87,133,230,143,105,12,113,106,144,1,26,14,26,81,19,29,90,34,136,104,167,83,206,196,125,230,254,237,240,230,144,121,63,56,89,107,204,41,123,79,5,92,205,26,132,176,218,168,32,8,187,71,83,39,172,45,163,58,46,102,231,3,48,163,165,7,152,183,96,80,11,176,230,112,30,42,231,240,62,171,119,74,135,174,136,104,81,128,128,20,44,157,227,208,221,92,105,52,234,188,48,45,151,158,75,99,80,83,100,28,10,132,19,60,173,237,24,221,4,196,191,109,51,23,144,232,32,1,9,242,134,243,217,157,139,238,236,21,215,2,25,226,90,184,57,202,75,70,179,81,42,201,122,182,45,71,252,245,153,4,21,93,67,167,163,240,125,179,135,113,223,48,38,64,33,198,207,80,41,108,175,200,183,63,255,46,113,5,10,30,10,75,147,116,87,163,22,246,77,249,87,185,41,151,152,140,199,4,9,211,116,228,129,98,213,90,138,40,50,220,6,181,56,14,67,87,29,219,57,252,198,241,129,23,167,134,182,229,39,14,186,157,194,77,117,179,252,60,208,193,65,72,154,20,156,85,209,130,232,3,185,123,89,46,121,90,75,127,121,102,131,69,241,52,211,249,48,48,126,120,112,4,137,205,61,232,155,31,70,196,109,141,23,64,252,92,5,101,210,118,120,43,111,239,113,236,237,238,6,87,94,242,147,93,193,236,177,48,221,250,56,57,132,80,52,33,176,164,53,112,172,177,215,171,197,109,75,5,40,203,25,113,60,131,156,180,36,26,87,93,114,12,163,7,189,220,157,149,73,60,208,51,148,125,20,132,13,225,248,214,106,128,189,45,25,140,232,155,7,69,141,5,54,48,125,140,128,175,166,82,132,109,166,221,202,10,162,2,182,197,153,133,16,212,6,22,90,125,220,47,165,115,12,166,119,199,162,211,148,69,74,154,60,71,45,132,207,237,216,133,241,188,138,56,66,146,74,49,148,86,206,91,40,190,208,197,58,181,66,234,49,75,200,180,29,67,102,24,113,132,181,95,113,206,204,234,86,226,114,200,251,157,90,110,220,232,175,216,58,235,25,58,204,8,142,138,150,79,177,216,109,31,194,243,43,130,111,127,49,62,98,5,162,76,98,14,153,176,129,90,50,240,100,202,112,230,170,141,244,10,206,124,241,51,155,238,172,40,107,63,185,171,11,75,46,76,61,127,129,237,54,237,215,152,4,154,182,60,106,109,150,236,182,147,202,208,155,211,131,43,194,25,217,99,212,249,49,108,54,219,55,70,180,3,66,84,70,39,118,141,158,55,176,92,221,227,115,202,231,25,71,188,253,162,152,247,213,149,113,29,234,93,84,68,93,236,216,203,187,26,80,144,65,95,82,104,15,9,245,88,163,137,107,7,17,13,9,42,213,114,18,39,234,65,129,222,234,17,145,113,98,103,63,116,184,67,167,32,75,124,244,234,145,242,3,197,192,187,204,29,218,51,14,129,129,21,221,14,104,144,190,125,215,221,231,185,108,203,187,220,140,238,174,27,233,189,250,121,87,252,56,137,173,75,198,250,203,109,85,122,233,108,140,208,229,200,166,14,52,5,57,16,204,166,40,130,159,172,26,175,19,215,23,81,208,196,57,119,141,86,149,248,160,80,104,85,167,247,10,11,22,134,121,140,67,194,205,52,112,249,131,54,120,179,101,32,251,141,220,106,111,52,38,105,61,38,157,147,251,245,22,47,93,17,252,179,75,72,52,141,124,108,26,135,163,85,181,120,48,204,125,135,14,115,198,158,181,30,151,214,33,125,38,161,116,166,182,101,176,174,46,178,206,227,89,134,211,215,2,217,155,186,6,22,114,163,231,64,52,143,146,180,62,91,138,23,224,92,128,88,97,71,0,192,238,116,228,169,253,233,53,14,244,86,98,255,109,188,179,65,90,137,215,53,94,66,154,135,46,117,150,148,208,91,52,210,189,91,186,94,48,7,129,106,221,159,17,185,92,132,42,13,153,214,186,241,150,255,73,167,225,75,167,253,26,5,37,79,186,136,31,194,84,34,30,106,126,80,237,132,140,242,47,60,124,4,131,64,253,121,137,50,42,69,178,143,191,98,1,95,153,145,148,114,111,3,166,54,159,105,235,79,255,127,60,246,236,130,153,34,79,13,208,202,25,183,46,181,49,50,134,18,192,9,106,231,89,218,7,205,105,72,142,62,154,20,78,67,222,2,25,232,66,65,132,129,175,49,238,84,32,166,252,168,124,245,23,242,163,50,171,167,212,65,24,198,12,200,219,202,14,4,165,170,30,166,95,22,133,163,94,117,47,95,130,227,46,46,11,146,127,109,166,48,200,26,229,71,126,74,117,166,67,232,82,31,180,131,234,32,125,226,180,70,255,189,173,181,53,253,62,133,158,223,184,101,26,152,27,108,8,197,68,198,109,197,11,90,61,120,94,19,33,49,74,202,73,54,160,248,142,4,203,236,180,213,59,195,57,218,94,183,50,171,77,251,16,249,237,249,241,186,177,221,66,167,167,162,53,80,11,28,235,125,236,226,116,84,224,175,251,208,180,36,11,250,23,95,160,189,202,191,120,90,181,157,47,223,168,141,164,33,113,216,150,21,40,66,149,147,229,54,3,36,149,92,3,105,111,127,23,68,231,102,217,162,199,40,146,157,0,2,150,49,70,245,43,6,0,167,176,56,200,87,82,57,61,235,30,232,173,211,43,61,138,143,26,141,214,118,17,208,45,214,242,205,146,64,57,25,129,143,98,51,175,144,122,20,51,246,62,232,8,15,187,153,109,199,225,107,93,37,209,229,68,19,47,230,32,123,94,135,127,228,108,217,91,195,228,208,129,253,213,37,51,162,57,31,6,28,82,9,220,187,190,193,44,35,163,70,162,46,230,169,109,92,74,185,158,153,245,242,211,4,206,230,187,88,148,42,245,33,156,195,93,242,150,140,89,226,179,55,158,32,110,226,230,25,53,254,177,3,61,127,181,13,89,50,161,36,248,80,246,53,133,150,153,40,10,84,142,208,67,232,36,106,175,120,92,14,228,207,27,149,18,153,25,228,40,111,126,187,73,211,242,106,177,20,69,51,60,27,69,191,197,114,227,73,231,32,231,79,149,210,200,196,124,239,61,207,180,233,140,62,209,71,64,219,196,190,163,112,81,178,41,7,238,199,38,181,227,134,46,161,91,176,218,104,63,46,17,131,221,100,97,39,194,114,25,157,178,112,238,248,127,65,55,106,242,7,219,137,25,107,155,62,160,251,112,218,12,227,145,185,199,152,144,245,151,62,11,242,131,217,121,13,143,250,221,184,13,38,213,118,97,77,182,246,112,76,35,42,50,146,67,144,161,74,229,26,125,1,108,209,247,18,8,107,184,50,210,228,237,126,67,243,239,183,102,8,24,61,72,132,120,96,84,202,26,36,21,220,101,149,183,77,12,7,175,215,193,27,159,189,72,222,232,240,255,121,170,35,236,139,145,234,80,41,87,98,125,76,236,148,59,153,58,197,15,211,254,4,180,166,247,185,234,182,65,196,14,53,120,38,95,86,168,151,107,194,77,120,157,117,127,174,208,52,223,143,110,99,5,185,31,218,127,248,232,192,45,55,1,221,255,124,139,175,62,216,88,236,37,189,85,170,164,161,40,60,196,170,5,4,98,99,195,46,30,222,155,126,75,171,244,179,131,99,152,87,198,229,153,78,51,130,78,162,60,243,30,146,229,212,31,115,104,174,163,244,103,153,194,204,159,19,31,175,57,47,170,0,181,251,63,204,152,242,65,98,68,206,248,33,155,29,180,203,115,195,56,124,93,134,36,171,92,36,121,125,213,87,149,176,132,217,162,248,59,146,254,140,226,58,59,254,195,11,162,13,219,155,69,16,167,53,75,16,13,110,117,3,90,222,135,251,139,118,128,106,209,176,195,165,250,164,86,179,215,178,230,175,165,43,53,169,159,1,201,125,95,206,40,150,31,67,238,149,215,22,65,74,34,52,170,75,137,152,198,121,77,126,44,143,89,81,114,67,199,23,61,224,163,103,163,47,175,112,239,184,59,177,255,237,48,192,184,244,126,156,33,46,229,163,154,187,152,104,227,19,11,159,41,237,94,226,234,70,225,253,245,130,124,133,158,20,177,0,191,252,134,215,31,217,140,118,40,15,15,190,76,21,234,12,71,38,226,43,127,53,123,33,137,18,126,58,173,195,1,202,207,103,19,172,236,182,254,22,168,61,2,195,26,228,143,230,225,103,79,38,255,122,35,131,175,58,160,77,127,246,220,96,184,239,212,60,189,180,56,61,204,194,4,116,195,182,150,218,224,23,174,253,230,37,46,142,99,94,70,161,177,124,69,183,57,164,178,170,114,82,106,127,7,183,17,73,230,246,12,33,163,223,131,199,245,152,125,58,199,161,161,220,44,58,13,50,150,200,138,2,170,10,12,5,217,120,145,243,199,8,160,137,85,198,112,118,80,90,73,237,223,4,3,138,94,28,159,35,238,5,138,75,98,208,51,27,17,123,10,113,218,248,141,13,253,6,234,94,11,31,43,240,207,100,86,240,17,188,140,151,211,231,102,229,182,102,230,153,143,13,102,161,146,200,115,237,144,62,1,237,68,234,223,135,53,187,4,108,0,164,166,43,126,154,117,231,168,141,251,249,39,105,28,43,34,84,198,107,177,229,18,82,167,68,69,155,196,164,42,157,180,151,153,194,170,0,6,66,207,132,72,33,137,148,12,148,66,90,105,193,28,100,118,248,100,159,251,11,34,113,56,41,73,245,152,110,173,224,21,54,128,12,170,170,236,99,143,250,137,31,245,175,100,43,160,138,206,75,85,255,147,35,3,134,83,60,227,97,172,166,82,222,60,10,160,161,32,230,75,210,191,149,26,194,204,254,218,92,234,10,21,214,191,107,205,52,83,68,164,184,88,193,149,126,195,187,111,1,222,7,142,187,65,19,100,249,74,217,213,30,196,90,141,229,133,111,190,236,136,118,116,186,229,221,31,55,52,86,35,87,102,13,33,239,106,23,201,47,61,194,49,178,134,95,104,122,174,145,95,112,49,78,158,187,32,236,176,138,238,222,144,70,64,53,119,215,94,164,188,38,183,42,214,245,26,190,39,63,136,199,247,23,7,136,24,217,142,130,115,119,254,199,115,244,122,235,51,84,220,61,244,131,29,245,255,97,5,64,112,119,210,139,163,176,45,90,152,63,115,80,62,133,80,160,132,36,58,177,61,211,215,101,236,218,13,232,61,5,160,187,69,69,28,73,179,113,229,12,21,189,107,98,20,172,171,9,54,86,214,176,186,253,1,99,48,3,5,67,46,61,83,251,11,219,240,54,253,11,127,134,84,56,142,217,71,123,251,49,104,180,246,248,201,74,1,100,161,248,156,132,19,145,70,89,61,140,157,149,237,24,38,58,88,89,218,255,13,241,142,208,186,178,125,130,88,84,211,228,211,175,171,194,153,24,225,72,162,251,51,25,179,153,94,237,5,125,17,118,57,141,160,227,174,189,25,178,89,113,186,114,225,49,23,250,243,30,120,152,136,155,22,120,150,150,111,142,102,68,249,129,233,201,92,12,242,45,94,97,242,58,24,238,112,172,242,9,27,161,40,34,67,226,208,140,115,106,40,56,157,29,140,52,80,38,148,82,45,57,194,107,105,85,197,120,42,79,77,151,38,205,13,208,93,62,4,220,219,194,227,239,209,73,146,255,3,11,161,11,233,234,50,7,33,177,212,83,223,52,78,122,214,236,29,37,6,92,19,176,221,35,123,7,200,140,148,102,106,81,65,76,118,65,177,16,206,215,225,233,239,169,130,41,9,255,198,149,20,198,42,43,204,14,87,94,39,184,92,18,82,214,150,0,142,149,249,169,70,235,192,12,14,38,54,67,144,34,166,54,102,17,71,90,28,110,115,34,245,127,86,132,249,177,159,247,74,192,206,248,0,94,226,70,168,146,146,34,148,149,110,230,0,56,63,36,203,202,101,179,91,237,230,133,114,134,212,7,108,13,87,178,178,122,42,122,245,219,138,55,45,51,160,191,154,34,207,201,90,4,148,241,202,162,231,170,58,128,180,104,185,207,21,163,193,71,232,228,46,101,236,117,242,219,91,181,17,176,187,77,29,189,229,210,112,62,151,228,99,65,133,215,181,72,238,219,86,18,241,184,215,193,54,155,80,222,212,121,254,253,173,145,96,157,255,96,165,45,154,82,53,242,46,12,148,253,2,44,94,64,168,82,252,56,64,224,49,239,227,124,39,237,133,253,97,122,103,5,157,44,224,171,121,11,164,35,98,47,101,136,238,248,18,63,203,121,149,94,26,39,188,80,92,44,131,173,95,243,202,137,253,78,37,211,160,103,87,249,175,67,170,97,55,28,7,87,199,51,222,48,108,144,104,79,72,108,196,222,192,80,165,52,248,89,83,167,13,184,230,242,254,208,104,196,98,154,176,227,208,12,198,238,30,116,195,93,118,242,130,42,189,70,203,158,90,14,9,228,66,74,9,120,219,104,230,254,10,121,166,9,123,189,11,73,242,16,125,93,223,77,13,206,224,229,9,200,83,221,44,165,186,49,82,216,152,3,113,39,221,14,7,117,154,178,178,206,123,32,240,90,28,192,101,165,51,218,37,150,51,213,177,70,52,173,219,44,221,25,193,184,139,198,190,175,181,174,237,198,56,183,20,83,36,219,172,133,64,70,82,96,85,233,17,251,200,165,150,66,161,41,3,48,52,129,27,213,46,254,61,124,114,227,242,125,198,13,89,186,94,24,138,41,91,121,3,252,162,1,38,161,221,54,113,168,57,62,242,245,122,86,72,91,150,26,121,83,73,38,152,246,239,31,189,231,185,170,181,22,138,105,59,166,9,209,100,248,6,173,58,62,238,216,63,92,78,48,39,202,135,232,72,73,153,112,247,28,64,61,252,243,228,148,117,0,184,42,43,30,237,76,242,176,62,163,134,250,148,91,121,190,183,162,26,207,9,30,130,127,8,112,222,142,174,194,157,91,184,159,166,175,75,159,223,47,133,65,123,94,247,104,4,176,209,142,12,190,156,15,6,201,31,208,214,76,97,123,140,60,178,189,186,106,84,108,45,68,132,211,12,225,54,185,190,252,186,22,21,120,28,194,95,234,56,159,66,65,104,95,0,125,71,99,121,170,54,156,230,80,156,137,208,129,101,165,111,232,243,225,223,177,228,76,20,57,156,166,154,227,196,185,245,96,62,141,140,44,174,192,174,244,49,76,35,124,111,130,251,147,115,91,229,241,37,122,148,105,17,5,186,253,249,172,163,51,97,21,78,180,149,2,176,100,187,250,10,150,98,93,121,188,192,65,97,13,23,213,20,184,53,51,155,103,167,88,79,119,218,135,140,77,42,9,42,249,209,192,29,48,1,168,173,71,255,73,61,75,112,148,126,26,84,57,78,133,146,86,16,245,1,203,24,191,69,163,100,50,99,32,25,210,95,127,169,13,30,154,70,164,248,28,76,2,197,254,215,236,114,74,13,3,97,161,102,190,245,36,48,78,111,68,93,156,174,101,95,158,56,18,229,125,126,110,165,79,162,37,31,27,252,68,53,32,154,99,146,208,54,205,200,160,128,112,106,20,16,135,90,54,173,69,234,19,122,119,202,220,56,14,91,41,148,70,59,109,23,56,207,58,173,143,117,133,36,105,139,192,124,1,105,29,141,7,173,175,217,198,102,6,96,228,197,37,162,69,162,42,192,126,102,26,38,117,5,20,83,56,27,226,169,148,132,25,49,247,89,185,15,221,165,43,141,29,166,18,64,73,12,145,127,218,105,68,245,224,48,188,157,98,123,126,167,0,45,246,243,195,153,54,172,90,12,161,201,229,78,90,25,51,214,193,166,25,29,63,116,99,67,127,76,177,98,202,181,65,254,208,46,166,203,151,49,125,153,23,210,113,152,15,68,10,25,228,124,174,77,183,5,129,78,164,196,208,52,198,33,12,110,74,207,14,234,42,152,213,191,180,172,109,85,123,110,137,218,57,230,143,127,118,90,154,183,209,173,7,57,153,35,30,144,33,40,221,37,196,197,122,0,197,66,173,118,39,131,4,222,7,140,243,198,28,84,195,78,78,246,2,221,94,225,59,34,170,74,74,124,68,113,77,139,32,105,255,212,109,177,21,252,238,133,14,206,227,210,206,75,196,25,252,89,43,48,60,207,254,162,51,216,3,160,83,248,83,72,67,33,236,82,106,22,7,52,100,249,218,188,57,93,216,173,18,237,112,43,150,192,50,39,221,96,223,105,100,21,93,137,87,185,229,232,167,11,202,9,238,44,72,24,227,84,221,161,53,240,122,189,109,228,90,2,87,152,247,244,100,90,42,187,246,158,252,0,35,46,201,70,182,244,141,172,76,20,110,55,13,138,236,125,133,81,33,20,250,242,57,187,198,131,146,162,40,48,38,0,97,205,189,65,102,46,236,212,243,138,64,200,82,132,22,226,184,167,152,189,146,148,248,175,134,10,225,144,23,249,226,19,204,156,179,54,224,209,249,77,135,165,25,123,128,209,104,5,177,114,199,154,196,110,112,68,172,42,123,180,205,193,132,61,218,230,152,246,13,134,204,36,55,14,224,123,105,81,57,18,118,51,101,15,187,223,1,84,26,234,183,130,138,140,194,35,65,189,152,118,122,101,35,213,135,138,54,209,146,70,241,62,196,58,26,84,144,139,122,171,84,65,156,208,232,112,171,69,132,32,246,119,168,10,219,92,247,114,180,1,161,212,106,76,126,139,17,44,126,135,209,233,4,83,43,87,221,168,17,102,167,113,219,96,122,174,25,4,55,184,161,77,135,201,10,132,195,241,164,255,115,101,23,77,91,196,13,162,167,107,203,185,187,9,53,9,86,62,30,46,113,110,179,99,5,138,158,211,236,103,68,194,248,16,103,201,144,91,129,162,109,24,120,117,245,253,3,136,54,168,237,113,68,178,239,238,115,138,12,48,51,109,114,180,251,208,172,44,219,213,38,157,154,72,240,19,127,252,46,198,86,160,115,239,74,191,129,183,254,166,76,13,47,50,177,56,32,157,115,162,187,147,211,208,3,60,80,206,192,115,255,251,164,85,172,222,232,211,56,199,255,39,249,109,222,93,133,50,125,24,39,83,24,243,210,80,47,20,130,251,48,94,16,27,173,16,94,11,237,150,236,46,253,169,54,37,3,149,133,77,25,30,29,104,42,73,101,217,99,0,194,29,237,218,77,117,201,175,157,191,119,188,1,25,0,146,129,123,157,48,111,156,122,112,36,55,20,112,209,169,39,49,196,67,211,204,158,2,141,68,90,61,81,136,127,63,181,135,104,129,129,52,67,145,240,194,128,28,13,220,126,235,219,97,157,233,62,176,103,22,4,250,32,236,158,133,25,46,90,2,97,190,28,197,107,204,32,217,130,132,25,255,163,211,87,36,120,206,59,229,73,53,146,145,114,46,30,96,182,178,70,173,76,83,214,79,8,209,45,243,244,95,145,21,219,26,206,36,64,206,245,102,0,81,84,105,167,211,6,238,162,245,219,99,49,242,246,16,73,200,154,233,155,88,57,159,177,70,101,50,118,67,233,205,242,9,172,12,54,250,152,23,133,128,82,45,146,169,246,67,86,29,1,218,69,60,35,104,135,123,164,251,215,64,165,117,229,165,96,2,38,232,129,202,63,170,14,199,252,92,98,255,222,227,235,172,137,0,254,67,216,77,130,21,203,23,208,182,54,161,8,16,2,100,31,1,223,136,120,160,13,233,69,51,200,42,211,249,207,217,192,26,160,102,8,83,61,188,239,115,17,13,163,43,213,14,56,183,91,195,113,227,115,12,174,50,184,158,199,66,134,154,71,123,83,5,176,171,4,220,51,129,180,184,205,206,147,73,181,132,100,210,29,221,206,168,224,134,81,60,220,178,10,215,103,188,27,26,217,86,7,63,243,175,126,118,118,60,68,252,151,62,72,198,206,230,86,77,222,227,48,56,19,112,139,182,6,215,193,216,159,43,203,223,37,100,14,173,188,74,209,119,117,239,81,235,184,36,12,254,11,168,4,208,149,242,167,203,177,200,94,60,215,152,91,132,98,144,252,211,95,194,6,25,146,4,245,18,129,141,41,242,172,189,233,92,2,51,89,207,122,217,227,222,48,134,38,14,78,162,214,28,127,28,47,151,3,120,61,242,250,163,85,55,226,241,162,105,12,165,13,60,26,92,149,200,38,20,74,221,63,195,2,118,194,31,224,158,249,112,88,93,180,149,248,198,170,16,37,163,242,105,160,163,246,6,248,0,205,211,241,117,164,43,10,69,84,179,177,6,121,105,225,96,72,114,69,102,72,164,123,18,117,137,134,187,143,60,1,96,106,92,101,180,21,89,186,6,17,16,215,20,228,125,244,137,145,86,70,39,54,154,8,9,124,147,170,152,184,220,110,163,81,74,229,51,206,122,124,227,81,245,62,232,87,104,48,210,102,102,187,73,46,79,179,100,6,29,125,193,8,61,234,48,46,189,21,38,180,110,33,85,89,85,44,70,237,75,121,229,3,125,1,28,237,176,29,224,222,238,248,82,68,250,27,99,250,133,83,223,38,82,40,206,27,141,144,42,87,102,22,71,78,45,41,67,78,31,104,149,43,92,36,198,33,230,152,249,137,7,222,188,124,253,159,167,20,78,126,8,191,173,56,140,115,192,20,91,36,197,68,56,131,157,199,238,184,15,21,51,188,71,77,252,195,74,116,249,62,7,191,26,141,185,95,133,161,120,96,95,91,243,218,245,252,71,227,235,14,229,153,3,21,3,34,105,76,22,204,108,90,13,50,196,203,55,109,212,179,81,87,141,18,4,176,249,5,89,61,111,242,172,110,68,242,13,65,16,109,143,75,193,153,202,167,125,173,154,125,103,178,64,196,121,80,74,147,8,192,22,133,176,250,143,114,148,230,239,134,119,100,234,90,61,21,48,217,129,223,231,238,120,82,220,20,27,164,123,96,235,222,246,140,232,245,192,230,186,189,197,154,134,117,115,243,69,139,82,148,38,53,40,77,244,35,78,181,199,65,122,1,133,91,195,181,20,21,218,65,34,155,120,205,70,93,247,255,204,164,20,189,92,71,84,84,60,183,143,228,1,133,199,33,113,7,74,246,105,3,35,203,214,254,127,36,254,240,104,132,153,155,210,159,87,75,106,84,162,91,111,97,98,131,226,133,247,54,230,114,91,23,197,57,91,36,15,224,51,112,149,115,204,43,76,144,80,198,136,77,249,37,252,236,223,141,43,38,4,141,164,204,75,185,212,4,124,16,57,0,127,143,107,130,44,221,196,25,73,84,83,78,17,57,215,169,67,208,36,190,192,216,150,7,255,62,68,83,175,110,140,148,184,173,41,134,134,206,26,84,37,170,161,123,154,132,173,32,207,107,96,66,47,31,144,223,5,156,221,174,119,112,235,241,174,89,214,162,159,46,115,38,235,106,11,127,84,151,77,154,77,163,47,243,123,237,6,107,30,227,50,52,63,29,212,37,176,186,168,41,200,166,93,75,244,172,231,90,59,107,236,73,31,101,250,114,244,23,79,36,235,27,171,33,30,208,104,255,139,7,219,205,247,211,35,62,231,89,82,15,178,52,57,153,210,158,145,95,94,51,167,168,161,249,232,191,160,205,186,87,82,152,124,37,152,126,211,184,168,91,202,20,124,31,88,220,197,237,151,240,122,238,160,48,9,109,253,49,157,58,249,9,170,248,213,99,143,235,113,154,173,4,37,142,128,71,98,35,201,109,51,107,104,134,87,120,170,114,138,123,161,51,25,19,124,52,33,207,207,236,72,94,3,253,195,161,169,249,224,207,120,102,122,30,226,155,116,23,43,124,33,193,236,196,170,69,107,137,186,117,156,94,173,231,23,43,44,18,40,8,102,66,229,205,167,31,148,248,53,6,138,156,44,201,37,166,71,57,79,198,102,27,56,187,221,119,20,243,153,46,21,198,65,136,96,199,132,153,68,228,121,35,38,62,216,121,124,140,102,252,205,107,212,156,45,206,243,239,133,6,197,4,49,170,113,74,171,54,165,143,9,244,126,162,85,135,16,147,153,235,156,93,172,10,7,119,171,13,195,23,142,153,154,56,240,47,119,32,238,219,15,71,77,247,239,209,66,129,197,144,248,24,127,47,40,79,191,97,144,149,78,86,167,219,23,101,117,70,133,37,94,13,140,106,182,54,16,84,32,18,238,47,222,155,249,192,40,38,99,19,167,153,126,236,139,240,102,201,144,197,185,40,196,119,92,24,231,64,205,41,34,143,18,106,207,252,137,158,77,76,91,42,29,206,15,109,158,234,194,74,130,167,179,72,50,49,51,61,145,227,204,141,99,81,113,174,142,144,124,222,91,74,226,202,178,200,90,106,34,159,232,42,243,218,204,2,121,80,93,231,133,163,189,135,71,181,8,162,106,67,224,223,140,140,158,45,112,44,223,145,4,158,93,145,77,144,154,14,164,119,218,96,102,229,51,115,231,237,92,232,80,24,64,58,141,250,165,99,233,192,129,239,111,196,235,56,247,177,120,153,236,131,237,203,92,148,218,95,251,254,145,130,45,148,176,199,129,101,41,74,110,56,228,184,142,60,107,4,147,206,112,213,28,228,58,178,56,158,218,177,254,88,87,69,191,166,65,47,218,219,236,142,37,235,232,228,85,16,25,190,97,0,90,191,160,241,189,79,42,187,209,145,207,121,201,97,5,128,8,147,136,51,242,168,151,78,8,74,110,74,30,0,46,144,103,80,128,34,43,119,136,163,145,113,81,203,152,204,250,188,123,86,3,225,41,30,3,122,209,133,118,156,226,131,116,180,25,101,236,87,26,224,211,11,177,173,117,115,254,80,83,52,193,251,133,179,209,31,131,8,21,59,12,158,245,107,47,248,177,93,70,172,88,53,109,232,126,226,86,184,48,231,2,234,19,173,215,205,253,88,25,131,63,101,229,250,88,137,35,180,109,150,30,152,2,19,157,254,104,128,189,253,219,99,21,85,13,223,106,38,121,158,12,5,41,29,174,115,53,0,94,217,169,6,12,12,156,51,184,236,207,224,72,42,19,16,36,150,54,90,119,60,157,5,136,103,71,98,195,123,183,110,21,44,227,16,41,138,14,9,111,121,19,145,58,58,37,20,224,78,73,4,25,248,60,153,100,173,213,184,33,24,171,238,253,68,126,247,14,24,142,172,94,63,80,60,159,130,223,208,51,156,104,242,201,1,24,133,215,213,97,216,53,203,87,184,157,100,65,24,83,128,76,13,193,61,93,99,99,32,83,101,65,54,236,89,215,81,235,190,96,232,232,106,14,23,166,159,145,105,212,28,182,227,83,19,105,45,28,110,241,99,40,7,229,98,4,96,68,172,248,57,164,46,182,195,168,219,47,32,205,48,54,175,232,112,138,94,146,236,48,73,4,52,130,162,47,143,67,198,21,43,89,30,132,101,18,135,101,197,194,106,241,118,191,216,84,217,167,25,198,22,63,44,15,154,23,65,40,32,163,54,106,225,56,134,209,148,43,208,132,253,7,186,121,194,46,36,2,171,172,118,74,224,139,183,106,39,181,84,132,94,117,75,37,74,197,170,235,106,249,176,18,24,23,108,184,62,74,207,119,63,253,96,74,0,238,124,5,225,227,160,90,108,58,172,157,242,91,86,226,39,52,7,133,237,30,24,98,211,131,28,19,18,148,136,216,155,50,83,67,10,10,108,34,200,87,46,156,53,183,23,193,195,196,105,167,255,125,220,191,182,14,223,187,126,166,207,7,70,30,97,225,39,172,130,190,241,87,55,86,67,25,17,136,188,255,117,43,118,62,201,124,86,62,161,65,75,78,180,131,155,229,122,129,218,232,44,166,242,238,37,116,52,10,3,88,144,19,143,25,101,148,171,43,122,171,202,175,166,92,151,216,53,107,218,77,75,228,248,177,157,226,164,59,103,155,79,29,242,249,193,57,9,25,0,210,17,201,114,152,38,93,71,56,109,180,171,38,12,178,146,206,173,247,75,139,193,176,222,44,192,219,93,28,70,133,173,15,158,61,165,222,143,179,7,251,98,247,119,32,72,118,18,143,155,210,1,165,166,186,129,217,44,76,18,145,219,169,62,58,187,34,34,86,34,8,74,118,61,114,56,180,3,219,162,130,239,11,197,216,11,102,34,13,37,17,135,68,206,9,66,179,216,11};

// The ranking tile of 128x128 pixels.
// Each pixel contains an optimized 8d key used to scramble the sequence.
// The keys are optimized for all the powers of two spp below 2in 8d.
static const int rankingTile[128*128*8] = {1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1};

float samplerBlueNoiseErrorDistribution_128x128_OptimizedFor_2d2d2d2d_2spp(int pixel_i, int pixel_j, int sampleIndex, int sampleDimension)
{
	// wrap arguments
	pixel_i = pixel_i & 127;
	pixel_j = pixel_j & 127;
	sampleIndex = sampleIndex & 255;
	sampleDimension = sampleDimension & 255;

	// xor index based on optimized ranking
	int rankedSampleIndex = sampleIndex ^ rankingTile[sampleDimension + (pixel_i + pixel_j*128)*8];

	// fetch value in sequence
	int value = sobol_256spp_256d[sampleDimension + rankedSampleIndex*256];

	// If the dimension is optimized, xor sequence value based on optimized scrambling
	value = value ^ scramblingTile[(sampleDimension%8) + (pixel_i + pixel_j*128)*8];

	// convert to float and return
	float v = (0.5f+value)/256.0f;
	return v;
}
