// This file is part of the FidelityFX SDK.
//
// Copyright (C) 2024 Advanced Micro Devices, Inc.
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files(the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and /or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions :
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// An Owen-scrambled Sobol sequence of 256 samples of 256 dimensions
static const int sobol_256spp_256d[256*256] = {32,226,72,70,57,171,246,75,112,81,109,239,120,101,230,103,103,41,249,86,253,99,132,184,214,147,128,248,17,149,163,17,60,40,169,196,77,79,102,23,250,77,75,151,95,123,234,198,25,26,184,114,230,188,105,18,231,233,175,151,19,174,202,71,84,229,247,148,182,127,92,14,41,112,162,253,35,101,137,30,111,134,95,122,28,2,41,254,181,91,101,188,145,31,166,38,53,193,1,122,99,86,178,36,198,169,113,255,97,221,227,231,29,100,30,141,250,254,16,157,2,220,187,95,181,125,207,187,105,119,156,41,16,194,93,216,227,124,138,90,227,1,88,153,233,69,120,36,19,189,120,4,185,220,185,109,184,96,247,173,210,227,54,3,18,9,139,213,156,57,61,101,37,247,21,201,10,143,11,38,146,18,118,129,95,191,75,207,12,252,238,104,47,39,190,229,31,56,20,127,42,178,100,141,93,222,192,247,186,7,224,161,72,100,87,69,218,44,25,195,185,118,179,123,231,170,96,225,204,52,117,60,3,86,25,143,230,18,11,165,72,188,158,3,66,105,50,200,226,145,227,45,183,62,82,176,191,36,248,191,189,122,96,185,146,166,203,78,144,189,67,174,154,182,86,169,90,236,101,40,71,107,81,93,159,82,75,230,157,191,34,35,235,139,150,193,10,142,217,77,154,249,74,13,196,248,56,154,27,6,242,226,105,94,66,67,145,112,31,145,133,68,21,0,44,212,254,153,183,238,98,102,145,199,100,213,196,52,131,141,216,209,236,122,58,249,188,108,8,206,62,199,207,103,160,247,207,255,101,185,1,113,223,126,182,0,50,93,250,174,194,18,65,111,206,104,156,3,48,195,122,212,10,101,235,200,13,183,173,7,192,3,101,228,84,168,121,241,205,122,115,132,155,242,215,22,236,242,69,35,48,245,3,175,68,57,4,15,226,155,222,140,54,48,80,200,194,149,213,68,225,14,182,122,147,195,69,166,191,17,176,58,222,58,190,70,66,153,196,215,121,123,176,190,161,145,203,121,255,27,207,28,113,22,44,232,46,84,181,131,245,220,27,202,161,38,94,208,39,143,52,5,154,85,121,139,226,223,159,246,170,56,94,209,188,71,205,76,16,233,168,172,200,37,19,123,120,202,28,175,232,88,120,107,157,198,111,253,18,24,36,35,43,169,199,197,137,194,12,238,138,232,17,17,58,115,39,234,4,164,225,215,14,185,232,76,215,171,142,206,206,132,90,31,130,24,0,165,34,91,126,113,64,202,144,114,132,125,58,184,234,211,246,238,168,7,1,172,169,218,67,29,185,66,73,49,222,167,243,189,36,116,23,223,219,200,84,67,94,53,79,26,202,204,91,180,221,166,106,18,207,17,128,137,246,235,162,13,129,130,49,76,104,189,138,55,174,71,152,49,116,204,207,103,198,147,225,142,79,8,172,59,234,225,192,168,181,144,185,6,233,243,61,123,46,55,44,16,228,79,156,235,190,115,61,162,115,182,122,230,138,204,140,86,173,80,99,207,211,181,23,141,152,17,180,35,121,168,67,205,107,74,55,229,234,210,6,94,48,186,210,189,2,200,190,181,227,128,211,225,215,228,74,7,188,195,36,82,10,131,96,99,138,63,1,210,39,134,153,112,72,163,196,55,126,37,125,107,234,166,129,80,61,97,121,20,123,222,3,155,219,62,49,207,87,182,26,214,167,142,89,38,36,112,87,100,56,245,240,152,23,7,237,11,185,206,233,203,131,42,53,35,60,40,211,114,9,13,189,130,196,210,173,39,208,56,110,34,240,65,75,234,76,73,34,39,2,118,174,237,52,194,197,28,155,161,135,180,200,3,89,210,26,154,145,45,57,54,85,26,118,207,212,58,101,69,202,184,36,234,219,155,41,29,80,22,193,175,145,100,50,29,149,166,168,162,213,130,36,25,234,78,84,97,191,139,95,156,9,12,41,97,110,222,8,16,250,161,130,45,111,195,83,213,16,141,154,48,124,175,89,25,27,9,172,242,51,167,76,109,69,107,23,80,23,166,12,16,180,156,182,238,148,249,59,130,75,122,59,134,240,69,220,21,230,47,1,124,66,180,77,247,147,103,66,98,211,96,105,213,127,178,144,102,213,33,247,141,232,67,62,86,230,222,146,68,122,27,147,7,85,69,31,22,67,67,78,13,149,221,57,121,176,133,161,84,201,146,119,196,217,19,132,52,76,135,247,107,29,131,248,220,156,248,29,41,36,202,174,136,253,191,226,91,179,96,69,213,172,0,206,75,192,54,69,120,138,218,171,185,232,211,139,8,31,11,50,119,28,197,83,158,170,229,244,195,190,23,213,87,70,17,102,197,39,59,88,152,234,95,106,29,195,236,114,136,6,159,105,101,2,119,184,47,212,218,188,165,163,138,174,114,71,54,127,64,183,39,51,42,209,202,106,96,215,154,56,33,102,25,62,111,9,49,4,98,142,198,128,138,13,74,95,229,42,164,19,175,179,111,138,19,157,125,94,34,221,103,246,144,141,176,129,201,55,100,23,12,139,33,227,91,223,224,69,120,83,245,50,57,190,21,54,86,245,95,250,34,71,249,100,201,144,16,221,0,40,74,133,38,145,48,217,119,132,34,138,67,161,62,221,126,108,207,140,42,156,13,224,198,142,19,55,85,254,155,140,168,250,58,118,137,42,78,8,48,89,195,167,91,243,246,88,23,22,206,17,190,56,125,171,116,245,129,121,57,144,228,159,197,243,217,239,86,188,152,88,239,112,120,245,119,147,189,25,128,240,72,208,29,162,23,152,24,143,226,136,174,171,58,178,10,5,250,209,239,88,62,34,251,156,163,231,247,102,112,46,48,61,233,24,71,54,73,12,81,195,243,115,138,145,194,164,135,148,51,201,104,74,24,78,107,65,246,118,159,165,130,206,34,157,177,180,10,126,163,167,129,75,0,149,115,172,21,242,139,162,170,92,238,35,46,24,108,101,62,26,147,180,210,227,166,103,149,188,192,92,115,141,161,120,90,231,250,181,130,208,232,151,157,141,208,27,81,82,42,162,244,186,62,163,6,254,94,107,138,123,144,14,216,138,235,104,135,98,77,82,57,47,77,171,213,192,134,69,226,93,197,9,63,181,197,169,22,248,190,55,178,250,167,76,157,101,170,138,94,156,44,12,155,102,133,133,149,43,224,51,130,44,138,3,195,25,161,29,216,1,188,160,73,4,196,125,240,92,88,50,192,176,234,39,109,96,39,60,165,226,80,248,179,232,244,141,102,81,131,110,19,206,225,222,115,198,63,195,251,19,155,77,51,194,251,124,13,77,69,106,112,114,187,126,67,222,81,227,163,80,172,25,70,205,111,48,160,111,165,112,243,47,236,107,81,15,83,95,132,80,133,178,116,87,10,195,139,151,122,44,82,111,24,234,156,187,202,250,20,233,186,204,184,154,149,117,78,205,119,71,166,192,239,88,148,154,229,200,139,163,129,12,155,167,252,50,198,46,106,221,91,235,75,2,14,240,122,62,178,218,42,223,213,6,17,212,242,32,190,96,163,121,63,228,65,111,229,63,70,140,232,221,248,216,80,5,145,12,27,33,195,86,111,42,125,70,44,232,82,209,40,234,168,224,215,215,133,247,128,76,248,178,34,253,61,204,193,105,44,227,66,45,238,159,16,241,67,99,178,235,181,68,204,234,144,58,40,132,125,203,25,204,148,151,253,195,198,81,8,54,248,148,248,58,54,235,82,71,67,181,212,241,43,111,111,202,69,166,200,66,87,245,207,70,112,64,26,240,149,82,86,28,104,17,59,72,154,106,1,173,59,21,204,184,231,15,224,161,253,174,78,249,25,217,35,144,180,57,102,174,57,138,227,125,141,246,16,35,201,173,170,31,107,205,169,59,19,52,209,226,49,136,168,13,238,63,53,78,203,68,18,146,228,165,245,244,84,215,78,230,167,83,239,15,210,34,99,90,184,143,187,50,98,95,182,121,47,53,112,15,53,239,130,105,66,142,11,185,224,203,20,44,156,28,197,195,65,118,36,206,88,55,37,18,112,9,20,231,73,6,11,225,79,180,145,124,204,29,245,148,198,53,210,171,103,53,215,106,111,154,237,107,2,249,79,145,126,255,255,53,222,196,57,237,131,6,63,45,70,68,190,191,12,210,247,162,41,135,184,234,206,153,176,115,255,114,178,110,24,25,66,114,55,29,79,253,67,124,245,37,236,13,88,232,186,18,143,178,59,5,237,10,249,253,37,88,46,134,71,53,74,172,186,69,137,11,154,60,68,120,125,100,91,182,239,177,38,28,125,208,165,38,150,207,244,41,88,127,241,251,168,84,195,111,37,211,165,113,3,212,184,180,207,48,52,204,171,213,128,154,138,218,69,214,154,99,201,203,109,93,71,190,5,99,1,72,173,15,149,49,253,51,82,171,179,114,131,68,114,133,15,104,227,141,109,39,68,225,130,50,51,133,154,148,48,28,230,9,43,157,50,133,203,239,37,160,233,120,54,20,116,57,174,116,158,45,8,196,14,200,80,203,212,233,1,0,88,172,214,196,22,192,224,142,138,146,230,105,100,153,155,112,241,124,26,71,253,143,4,191,50,49,88,226,25,142,141,13,12,50,159,122,211,42,168,23,217,253,218,151,135,3,152,114,102,191,76,186,42,124,70,19,56,25,85,234,58,57,225,230,253,56,194,107,134,142,201,213,43,14,33,242,16,141,205,196,99,143,100,115,5,99,128,100,221,174,110,191,83,165,164,78,60,124,209,199,63,185,120,175,43,3,24,40,153,1,83,147,223,112,72,242,148,166,115,36,138,42,13,63,1,45,173,225,83,121,19,23,208,171,146,240,108,150,3,213,83,210,238,72,120,80,197,2,4,159,197,138,216,19,178,24,173,212,237,169,129,129,102,51,63,203,142,11,134,180,207,105,98,133,253,20,224,6,126,194,167,33,132,90,101,179,113,216,222,132,30,88,23,229,210,85,6,154,226,252,17,39,174,208,255,8,11,252,159,110,195,86,250,59,161,218,31,140,167,41,33,201,143,250,68,82,205,44,4,77,43,214,212,60,82,214,41,44,125,236,152,34,64,133,184,58,145,227,65,70,73,166,49,21,158,242,114,42,75,209,36,72,188,192,146,223,138,76,27,235,115,153,105,169,96,209,231,4,33,105,226,175,187,91,218,12,73,168,214,254,98,208,113,214,116,177,49,34,94,22,127,175,12,155,193,56,187,115,187,240,136,234,206,189,250,115,219,154,17,52,62,198,63,225,81,77,90,127,246,219,192,106,223,78,102,88,142,46,208,156,230,196,67,182,18,112,210,126,198,59,15,234,166,243,77,61,149,24,223,70,245,142,178,199,101,195,190,109,78,244,224,12,84,52,158,184,88,212,155,159,128,187,54,48,209,190,202,157,70,122,109,33,221,124,227,1,196,124,121,163,138,238,25,129,134,83,111,124,60,142,46,143,48,85,63,5,77,46,251,193,209,81,108,149,108,1,47,137,175,85,106,148,27,204,145,104,3,152,84,228,215,113,141,6,117,115,151,206,248,61,43,182,198,76,88,12,222,132,75,73,8,205,190,32,12,159,70,205,4,158,0,107,220,104,90,223,181,80,7,111,166,130,16,168,145,218,242,101,35,165,172,12,217,239,157,76,37,238,176,63,124,243,45,101,181,191,200,64,186,170,42,104,154,191,224,67,145,240,72,82,103,93,108,220,251,36,178,110,145,98,136,83,2,171,177,220,23,98,221,2,160,216,219,237,90,105,255,48,157,136,55,102,122,181,7,225,55,229,254,215,169,94,22,44,65,136,50,190,151,198,54,132,81,245,106,71,91,141,176,162,15,210,33,14,140,108,81,17,135,249,17,44,15,121,28,16,114,178,210,7,129,250,11,239,18,86,203,161,124,2,185,178,83,110,168,3,81,125,80,149,8,67,30,212,0,129,8,77,255,114,243,68,8,119,210,232,104,244,127,165,159,26,176,206,160,228,34,116,10,3,91,65,149,163,43,43,44,171,113,113,223,206,17,63,64,215,216,94,118,5,139,66,201,213,30,120,149,18,236,99,41,81,175,245,1,7,171,209,151,134,28,32,122,201,13,18,46,236,215,113,188,192,221,39,69,117,121,255,119,26,59,142,121,126,238,179,163,183,245,98,199,32,46,39,137,236,232,52,138,4,60,86,83,12,100,44,195,49,107,228,105,56,183,18,177,222,50,189,188,97,197,148,94,99,1,198,221,121,206,54,31,212,145,62,73,77,213,189,38,66,13,139,69,173,57,26,11,176,245,141,166,141,203,10,48,45,201,17,131,241,115,13,165,235,28,129,88,72,36,124,169,128,6,145,10,109,219,198,187,90,149,67,215,68,116,33,56,204,217,236,231,0,205,84,97,113,175,30,185,95,187,166,164,123,103,0,218,18,150,180,103,151,153,146,97,15,161,171,246,252,131,198,186,58,55,210,93,58,157,3,142,220,98,50,202,151,2,115,205,200,3,236,146,210,233,71,222,129,198,18,131,29,157,152,63,201,45,197,253,170,121,124,232,64,197,112,22,208,106,99,54,41,247,146,135,234,142,177,3,38,157,234,222,46,189,233,76,41,150,255,135,82,99,244,246,187,81,215,16,76,188,188,104,156,21,239,255,206,97,35,217,194,13,70,106,106,238,171,232,93,223,145,190,50,39,144,48,13,113,146,151,178,156,18,131,231,168,108,178,224,7,44,122,98,87,166,65,220,174,138,98,95,93,188,127,246,195,136,215,160,201,137,35,217,167,126,219,175,109,180,111,127,222,93,69,133,2,58,198,186,238,108,57,157,101,174,249,26,46,210,254,251,76,43,197,209,161,52,197,28,246,173,229,35,43,13,81,122,34,245,212,223,50,135,69,70,192,171,78,9,135,189,54,168,232,131,250,208,59,227,252,247,231,40,235,203,254,51,25,198,223,165,81,140,141,67,194,180,31,194,172,47,195,56,153,118,221,30,217,17,85,154,184,122,15,130,179,86,8,37,33,200,95,144,73,175,68,185,197,128,182,154,171,147,182,86,172,23,236,20,92,194,110,253,124,133,82,127,206,92,34,108,69,170,47,61,41,87,108,218,3,244,7,124,51,153,83,186,164,116,154,85,123,43,135,177,107,28,189,81,241,214,189,235,233,142,6,109,183,130,75,79,107,99,67,31,164,248,227,114,159,230,115,116,115,252,33,75,4,171,191,217,88,245,156,203,48,239,140,253,211,46,184,136,34,21,248,161,128,156,16,88,64,71,34,174,125,70,164,125,92,205,214,79,157,199,223,143,214,138,213,150,169,17,16,181,95,200,208,91,91,55,125,7,1,39,91,6,103,252,246,22,71,110,149,236,73,1,247,51,2,168,88,124,234,86,100,6,94,1,17,215,157,34,238,126,194,222,109,67,175,96,45,252,99,58,3,34,192,251,95,240,36,188,243,191,229,74,164,55,171,108,239,73,208,140,114,46,244,36,30,33,56,14,209,94,86,28,9,153,30,23,102,165,252,98,77,72,233,22,126,152,98,40,246,35,93,137,114,191,114,200,54,214,8,238,145,43,119,180,186,55,74,170,232,166,247,56,233,9,162,16,241,95,47,5,109,72,125,67,35,130,55,138,75,157,246,85,244,3,230,60,226,159,12,234,155,160,180,119,243,253,179,202,194,53,218,65,208,230,212,71,228,29,49,220,31,146,244,249,84,46,237,203,93,171,73,33,115,46,109,10,163,137,73,18,133,213,236,174,230,216,119,127,80,199,18,100,180,236,191,127,152,158,226,45,72,70,181,106,90,21,229,46,41,109,55,237,81,0,158,169,63,40,22,85,246,181,235,161,180,28,175,136,87,132,184,54,121,185,69,89,58,20,54,81,101,87,37,251,152,4,162,108,113,248,178,219,151,240,144,158,242,185,138,4,34,148,255,250,66,75,144,141,25,248,244,89,180,203,97,141,149,179,129,213,186,64,101,242,119,130,121,108,230,198,74,228,155,96,237,140,201,158,44,127,161,120,219,94,11,95,27,145,80,184,107,215,88,252,32,89,59,97,159,249,183,75,131,180,65,184,179,85,80,88,74,128,53,126,191,54,169,0,133,100,248,196,158,91,121,110,12,248,130,87,248,186,85,136,101,181,0,90,45,34,227,84,17,40,96,221,187,167,131,112,48,70,62,240,138,78,245,248,226,203,255,32,242,246,141,200,17,167,32,151,12,72,159,221,190,56,115,237,233,226,113,71,228,167,60,113,127,28,174,27,176,227,160,77,221,157,64,14,166,82,60,78,7,91,16,214,169,78,222,97,33,229,210,4,255,104,234,42,181,7,177,190,23,40,135,53,67,63,28,151,60,167,81,21,190,110,214,160,222,51,228,87,83,113,220,46,182,163,193,79,214,249,120,197,244,197,169,252,20,33,253,246,46,198,16,208,35,110,5,37,236,172,149,234,155,32,36,8,249,70,224,226,40,16,146,131,224,173,250,111,102,227,160,196,255,167,81,196,62,24,6,39,4,245,139,98,158,201,247,5,6,2,61,92,5,65,70,24,206,135,30,246,146,155,22,29,247,25,112,186,5,208,134,240,95,137,29,48,148,222,92,36,165,248,10,244,222,158,131,46,156,217,243,219,101,123,98,209,124,89,178,16,48,173,142,241,134,127,160,217,64,134,35,244,28,253,59,26,10,212,162,143,252,94,0,198,0,16,156,116,145,64,255,206,234,251,104,250,213,247,171,89,86,125,48,237,216,196,160,45,90,227,12,33,58,31,88,200,117,101,36,105,135,49,134,64,181,233,40,63,100,189,192,13,48,58,159,183,105,34,162,170,166,132,83,141,116,29,39,216,84,29,224,211,54,145,251,248,148,150,203,26,51,179,47,134,175,80,66,223,24,221,52,170,59,241,37,95,232,183,15,162,203,144,221,60,248,8,211,255,78,249,55,59,23,131,11,165,152,182,82,168,71,89,48,249,78,107,182,117,73,21,79,42,128,232,89,103,207,13,224,32,236,175,138,201,54,26,98,122,91,253,144,222,108,171,101,120,208,168,40,29,46,64,23,171,248,115,40,80,28,107,143,65,188,142,205,155,234,86,121,157,124,23,44,177,188,201,222,229,244,169,241,155,62,102,187,15,28,49,168,157,29,135,202,9,160,102,125,112,184,31,209,162,114,13,130,215,93,15,255,110,50,54,19,144,98,47,46,170,252,210,5,161,176,69,185,97,187,253,94,124,215,85,69,73,136,150,68,137,217,52,113,151,241,70,44,102,126,10,143,167,133,81,239,233,109,73,171,141,93,133,112,185,133,103,206,49,208,130,79,127,234,48,173,231,82,200,74,68,194,188,185,26,56,199,134,122,3,153,227,174,245,23,34,49,20,68,184,202,1,232,252,31,171,45,85,7,114,187,66,203,169,98,117,144,15,165,104,143,111,174,100,197,60,7,53,248,238,100,12,162,96,40,189,247,101,64,57,57,14,195,114,229,155,228,32,111,37,141,8,8,163,2,223,6,96,54,144,175,85,141,51,77,41,60,192,113,15,103,101,44,30,102,189,100,251,227,71,37,62,123,4,63,119,25,116,47,205,191,156,1,106,136,248,37,151,162,72,226,41,208,133,69,146,114,137,43,245,90,115,117,90,122,134,180,218,136,10,36,210,53,138,90,139,213,130,56,173,119,174,71,72,213,138,87,171,101,156,110,0,164,38,191,156,215,148,220,106,138,50,237,54,37,49,215,127,45,81,226,61,181,195,147,154,208,170,94,34,8,228,121,71,182,239,63,56,65,244,0,70,162,73,198,63,16,134,216,58,187,203,234,115,44,209,105,127,183,130,74,82,203,219,128,128,162,13,47,106,252,31,56,155,184,119,56,139,70,241,3,104,153,43,183,28,68,241,224,25,154,52,51,131,108,142,150,13,106,43,251,166,76,47,218,150,11,125,109,109,179,145,213,217,241,16,32,208,48,33,217,59,171,245,248,174,34,191,77,111,183,221,49,141,59,221,76,224,103,190,107,171,215,232,44,84,133,236,88,227,175,24,57,144,252,229,182,140,36,219,42,92,101,187,212,188,34,205,167,99,168,91,224,154,187,112,52,190,62,212,191,250,250,68,229,248,142,143,161,185,243,117,222,69,61,162,247,179,140,133,135,164,217,144,222,8,114,20,240,161,44,27,187,82,122,237,53,167,43,2,215,122,219,61,163,54,181,154,176,222,239,12,13,63,88,213,167,98,162,94,254,89,113,112,242,88,158,65,229,215,16,126,234,96,129,34,233,231,85,152,90,16,97,32,90,134,18,131,114,130,148,249,76,135,186,171,103,192,83,45,100,96,36,88,217,197,165,86,194,168,112,149,125,108,133,112,117,199,26,221,35,245,88,233,9,113,47,138,31,61,114,47,51,32,197,55,17,175,164,93,204,223,215,203,221,224,147,103,78,214,230,214,71,214,220,169,117,39,0,147,198,108,242,153,155,144,235,250,162,35,53,61,45,156,227,244,108,123,32,227,129,77,252,146,213,168,197,237,147,123,38,228,75,144,165,144,102,113,198,22,145,14,101,195,177,43,62,151,113,96,81,189,204,180,207,197,24,72,76,135,127,181,246,81,18,167,113,85,184,62,190,140,86,209,148,134,111,32,60,108,33,233,115,99,216,239,112,146,92,217,236,252,213,215,98,122,215,64,175,155,179,121,195,7,207,252,163,51,58,143,187,255,188,122,6,199,73,36,149,218,141,142,43,108,99,2,232,187,65,216,24,169,125,102,148,113,59,233,176,194,207,77,204,245,20,43,145,104,88,88,212,187,237,152,64,18,141,254,53,255,111,53,61,62,49,143,145,197,10,207,36,198,166,88,7,199,42,201,145,219,135,53,239,108,162,82,202,181,4,255,82,23,38,141,213,120,0,218,105,2,141,120,255,138,20,27,255,97,202,151,0,166,227,16,196,48,139,91,164,4,170,177,243,27,154,220,212,167,205,179,84,245,205,50,51,155,45,39,99,124,70,27,48,182,173,3,26,38,214,1,26,23,216,248,214,89,78,142,7,44,2,118,103,73,72,202,187,222,242,74,37,84,166,251,191,67,11,231,116,61,33,17,96,93,116,165,173,88,153,105,123,125,159,243,89,143,66,211,213,23,47,204,192,2,231,229,224,32,30,45,9,31,149,216,137,119,152,34,22,131,206,47,216,201,89,197,58,66,204,67,92,0,150,199,161,213,185,96,252,164,78,46,247,41,134,48,118,14,77,30,250,176,12,138,96,58,51,142,9,249,103,99,29,247,189,31,126,29,86,211,201,108,216,195,90,32,119,124,219,207,128,192,119,91,217,60,215,24,182,244,100,241,153,24,3,99,115,167,33,25,239,186,42,198,202,179,57,117,112,11,208,212,50,26,170,22,148,206,252,232,159,56,64,37,184,40,232,109,62,164,199,64,198,112,56,71,12,215,108,220,20,211,118,70,182,19,212,219,182,104,5,188,255,61,162,241,25,176,78,25,176,239,21,205,246,214,246,86,45,101,158,9,252,149,38,59,72,225,119,121,209,20,85,6,84,253,24,182,126,20,150,105,176,238,54,59,96,46,28,214,21,80,112,19,118,125,115,134,244,30,35,230,238,255,199,220,32,200,9,142,2,182,14,101,191,176,143,96,217,200,124,194,43,105,61,93,143,135,53,12,228,233,30,150,173,228,73,179,184,84,21,117,63,245,231,49,129,29,249,46,23,172,195,94,36,76,227,246,71,159,188,8,88,119,49,177,156,203,88,101,195,170,151,183,106,100,9,246,64,254,1,90,4,9,163,154,231,88,68,182,99,67,75,171,107,142,196,79,237,114,70,178,128,33,83,168,67,129,82,214,135,38,206,41,152,140,168,52,239,28,171,28,29,180,246,185,183,243,85,129,112,168,63,139,133,0,162,86,166,48,132,244,159,151,235,175,64,110,168,85,97,233,11,62,25,177,16,57,124,63,250,59,218,136,209,136,192,23,168,160,206,65,84,30,73,213,235,181,104,66,27,98,126,183,219,93,200,115,84,141,57,55,20,131,91,14,228,85,181,19,4,110,176,90,101,40,91,107,155,7,70,21,114,154,141,146,125,246,64,1,216,213,232,23,143,224,115,244,247,144,186,71,134,69,183,141,25,186,91,29,145,163,250,202,181,57,216,172,131,228,242,181,187,52,94,218,252,4,118,44,52,124,160,37,176,17,218,121,140,191,107,102,91,222,49,91,229,106,179,221,170,200,88,38,138,167,10,48,157,47,99,57,137,88,76,206,141,214,208,48,80,226,18,227,6,175,180,63,107,247,251,197,59,51,247,13,109,209,162,206,192,125,112,94,235,247,26,88,14,126,241,225,249,81,162,7,157,238,150,138,24,69,121,155,219,17,169,180,218,93,230,99,92,139,53,179,145,30,14,205,171,75,247,49,194,3,14,177,24,222,122,30,75,174,121,243,104,233,244,81,4,47,70,43,206,113,229,119,231,49,72,144,78,214,29,193,41,75,14,97,19,84,148,246,3,250,243,7,246,233,153,48,135,226,204,199,93,210,3,97,11,106,117,170,122,92,97,150,179,177,220,46,59,17,151,242,160,233,237,81,78,255,87,243,237,113,135,216,131,97,197,224,41,142,85,234,243,135,58,152,220,191,227,149,78,77,30,82,167,63,217,43,227,106,173,223,128,161,49,70,29,184,169,178,179,124,224,2,243,210,229,112,103,15,29,78,229,91,9,68,198,94,135,241,207,69,183,229,46,78,63,189,93,163,10,91,172,13,205,180,217,216,102,237,239,3,217,247,218,0,147,130,158,175,242,39,94,23,238,221,229,211,72,140,103,207,7,73,10,200,247,155,254,35,165,152,2,137,237,154,128,235,215,210,1,132,104,143,128,91,191,225,241,171,220,16,165,209,59,10,1,128,151,229,116,17,20,188,108,57,196,105,197,5,64,216,75,255,49,10,35,243,39,238,142,201,1,32,8,28,116,21,216,226,89,90,231,210,128,81,149,93,249,111,150,128,11,228,231,236,178,74,34,174,187,230,84,78,197,136,17,197,25,242,154,123,24,78,245,178,254,76,70,182,72,15,115,54,62,10,89,172,129,113,97,148,204,240,100,172,169,122,13,95,182,26,184,25,191,255,250,250,137,18,19,72,145,135,112,125,227,63,65,26,54,228,181,30,158,27,191,9,236,168,115,248,144,187,132,253,45,84,154,196,103,30,149,123,53,42,206,172,146,175,44,203,69,239,45,147,0,121,103,125,132,136,192,38,62,79,29,241,17,151,110,28,38,221,234,230,228,182,64,241,144,165,124,145,120,49,50,129,18,33,242,212,143,68,167,109,134,179,113,176,85,93,87,105,133,15,66,249,8,43,9,147,72,30,6,2,85,185,204,160,20,76,70,119,163,67,200,121,228,185,204,22,48,31,122,177,123,93,159,108,114,65,90,91,67,95,139,6,187,3,78,142,38,96,61,68,23,146,93,32,245,153,131,61,126,1,194,201,158,51,161,172,0,176,76,143,229,81,201,36,157,210,139,109,215,12,9,41,152,243,188,240,144,194,27,114,193,162,39,43,9,203,46,137,76,217,93,125,215,74,43,75,0,153,246,95,88,44,134,248,43,87,166,46,133,1,77,197,205,206,31,50,102,178,248,22,226,192,156,203,195,155,193,32,35,158,173,76,75,79,240,112,7,161,130,162,85,225,67,223,15,127,53,24,49,231,201,248,16,114,146,228,17,178,247,166,162,2,32,180,41,188,9,197,103,77,246,35,30,71,112,6,222,168,64,60,248,242,61,201,130,219,58,182,38,143,103,45,104,219,7,121,119,138,183,148,149,107,216,169,2,89,111,185,120,49,74,173,174,35,38,194,214,86,32,216,229,123,41,64,108,178,152,13,174,71,86,192,147,84,112,246,98,151,238,63,210,134,112,5,28,254,154,125,236,82,78,22,114,230,212,88,97,54,211,70,203,48,159,59,21,36,55,56,141,194,247,133,160,138,224,66,180,74,137,37,94,5,120,135,170,119,209,147,221,28,19,215,139,29,199,87,234,102,225,111,74,180,27,169,131,129,29,44,138,81,235,206,181,229,133,192,201,163,110,48,203,245,95,200,183,29,29,31,255,74,216,148,92,109,191,130,29,236,248,204,126,228,208,76,200,13,128,197,198,255,211,23,197,132,124,133,71,155,21,132,233,191,189,212,255,108,47,94,109,53,232,234,95,174,83,223,18,188,255,239,215,139,141,51,127,243,199,103,111,117,45,101,67,184,104,196,20,34,25,184,251,144,47,226,217,214,217,125,47,52,41,242,113,104,13,56,74,44,166,36,63,154,133,145,18,80,160,124,59,47,48,219,63,43,134,67,115,238,189,252,67,6,164,83,181,123,230,213,252,7,222,130,221,30,79,68,34,162,2,61,134,162,207,49,146,161,216,82,98,181,190,57,57,164,128,97,121,148,131,128,152,66,106,247,15,154,148,82,42,174,142,17,249,123,23,138,78,106,245,159,202,19,26,160,50,138,153,136,182,101,89,247,195,169,69,220,50,155,45,140,251,248,183,139,84,17,44,98,83,13,102,234,106,135,22,255,212,246,163,28,11,251,123,18,5,150,221,6,2,137,17,176,56,215,12,166,187,52,149,11,97,119,140,245,13,201,20,98,80,27,26,125,126,58,232,231,83,52,195,75,116,248,147,230,123,171,77,81,168,163,120,39,158,18,54,60,212,117,67,148,122,151,78,51,30,88,27,152,83,92,191,105,162,106,233,12,27,116,4,53,100,189,242,253,169,182,10,105,196,84,229,122,141,80,15,0,38,26,50,176,229,18,32,169,241,202,190,190,225,100,193,44,196,209,193,83,89,43,228,8,127,48,9,221,186,199,251,97,138,218,190,131,202,206,62,148,128,44,48,107,164,177,57,149,171,214,244,57,198,194,87,179,232,10,17,65,243,255,109,19,208,42,55,68,178,164,84,21,57,206,5,27,252,203,144,108,90,231,137,198,221,204,164,204,56,73,223,129,127,246,244,144,140,13,229,195,199,39,42,93,103,202,8,45,68,203,17,186,154,9,154,228,59,255,134,120,125,170,90,18,141,31,17,116,10,189,48,63,147,112,188,11,184,92,95,253,180,92,80,106,57,112,187,229,228,69,3,1,47,47,72,146,48,135,37,111,82,27,20,77,157,222,115,123,120,119,159,196,99,7,116,57,222,119,79,79,212,213,215,145,225,154,187,25,22,126,89,170,169,123,159,94,29,177,63,137,207,167,192,97,134,193,17,236,199,8,35,214,220,156,72,183,180,8,63,200,171,93,216,103,110,145,159,209,158,236,233,50,228,220,144,113,159,214,222,157,156,27,133,183,240,127,191,28,41,222,148,155,247,32,97,96,128,237,98,236,159,107,157,192,176,19,81,248,145,219,183,179,73,178,81,38,137,81,108,189,148,180,164,63,244,107,140,13,253,2,84,88,16,121,200,120,77,203,104,24,207,202,194,62,253,155,102,96,168,116,28,237,163,138,91,149,34,82,230,211,109,230,176,130,28,82,186,233,159,99,238,249,81,38,106,243,246,4,63,80,43,104,47,1,253,236,84,79,158,5,81,26,18,242,70,42,11,229,216,154,236,16,203,159,227,7,207,120,26,197,81,87,177,4,32,197,147,111,255,229,91,211,194,195,230,35,169,151,31,196,33,181,120,192,254,71,84,152,228,208,209,129,98,55,39,210,144,146,192,231,249,121,170,81,218,202,197,150,149,234,93,90,178,167,209,244,86,25,140,141,156,206,14,247,240,217,14,39,99,82,121,16,119,157,210,169,220,50,58,255,48,130,189,120,154,59,60,85,94,135,23,15,171,6,31,212,224,89,73,100,179,91,61,170,128,28,33,227,9,149,128,12,110,120,44,9,52,192,4,24,65,221,114,24,77,109,0,237,94,4,42,232,84,150,134,32,50,33,84,234,130,136,89,117,253,79,60,135,69,29,50,128,196,38,41,43,37,78,168,73,163,249,45,207,177,76,38,115,76,143,118,145,106,166,6,142,230,193,147,145,87,195,222,73,219,219,89,33,68,237,118,120,146,164,74,130,237,16,47,79,228,9,153,184,5,127,80,182,81,105,196,51,244,192,237,160,118,200,191,94,235,152,191,202,161,231,171,19,116,102,94,206,253,175,4,193,18,70,53,214,98,123,181,137,167,190,84,96,169,2,204,232,54,221,169,175,186,172,137,170,75,32,249,57,119,86,19,52,123,234,142,11,108,19,58,84,98,250,242,114,170,31,205,195,117,12,243,41,93,222,0,101,219,102,129,196,192,91,8,186,233,243,37,194,183,162,121,59,93,71,52,178,114,96,72,252,185,254,109,31,107,112,168,64,226,160,216,43,49,74,50,139,112,148,135,148,88,184,35,26,29,171,245,47,96,61,39,146,159,194,252,57,202,244,245,218,216,18,29,71,237,39,25,197,164,184,67,97,53,45,16,218,207,244,97,249,96,167,93,62,103,162,164,67,186,159,2,26,136,32,184,9,167,169,183,210,72,43,253,167,72,211,171,205,117,92,82,32,5,197,107,8,68,106,237,8,142,148,101,227,90,210,67,13,252,233,3,242,79,95,172,175,195,246,251,254,247,71,7,224,252,37,255,4,158,178,131,23,77,77,22,178,114,155,151,162,207,53,98,63,132,143,232,73,194,185,91,243,57,47,83,36,154,42,31,150,56,15,33,40,14,111,70,137,225,158,138,108,119,114,255,48,176,231,182,51,219,163,86,122,80,104,197,169,107,181,97,55,228,63,47,73,106,27,23,65,207,177,34,218,221,147,192,237,165,74,89,152,255,181,169,250,226,99,10,232,6,181,45,3,222,174,26,248,155,12,199,237,65,205,85,22,125,164,146,124,17,73,140,71,36,57,173,173,157,157,161,35,164,157,190,71,67,29,142,133,206,231,64,185,95,111,65,166,220,233,245,73,242,25,16,29,223,124,142,199,177,13,24,198,245,218,190,115,38,32,45,236,12,96,101,63,17,230,151,217,117,234,153,112,111,91,162,196,247,185,166,60,2,8,145,56,160,48,175,226,250,67,51,132,106,42,213,138,119,167,9,240,25,8,56,22,165,218,9,62,218,121,29,43,177,130,210,166,150,15,220,225,225,152,34,255,104,115,223,108,131,55,250,255,49,92,130,20,179,218,73,38,116,122,102,17,118,237,183,109,65,232,122,235,4,68,3,245,160,150,224,73,183,115,6,100,124,166,210,201,82,249,142,15,23,20,60,118,137,170,181,229,205,108,201,240,169,87,195,99,76,138,15,228,158,47,216,146,8,248,175,110,207,39,94,180,173,250,47,24,2,201,150,241,233,238,16,120,75,140,84,49,212,106,98,213,162,86,181,76,170,35,124,116,48,164,197,74,131,117,229,28,19,139,154,0,123,202,110,178,10,79,113,166,22,172,117,191,54,48,27,183,59,223,105,57,148,54,241,188,72,118,58,255,33,235,238,206,33,254,197,162,45,154,226,221,57,145,225,19,36,11,164,245,79,188,132,50,190,248,255,75,183,214,242,69,109,232,147,130,166,70,86,58,124,161,96,88,92,166,32,184,117,117,232,148,14,163,81,163,242,0,239,41,82,240,105,189,74,68,200,164,195,85,62,74,56,226,196,41,2,105,154,95,205,207,232,106,98,226,99,112,210,188,162,203,188,28,65,78,18,252,134,93,120,74,188,64,154,12,133,146,228,14,25,9,13,157,22,83,145,169,201,189,221,137,49,232,138,179,182,165,146,2,109,172,21,172,40,157,230,199,70,170,17,231,133,250,192,45,75,214,33,111,3,120,209,54,12,206,159,226,150,136,96,94,25,66,56,178,106,7,73,214,104,156,236,28,249,93,15,229,9,0,132,16,69,155,125,179,207,94,14,13,244,207,241,54,32,52,63,98,162,154,191,75,209,229,33,193,255,57,31,229,86,153,43,207,166,165,245,54,40,212,29,222,70,136,130,40,74,185,218,104,130,108,129,245,188,86,215,76,131,33,190,168,234,99,175,11,251,216,73,187,108,44,255,201,238,119,247,44,86,81,235,45,3,57,216,75,34,73,180,36,35,240,164,214,36,117,135,41,119,211,38,76,81,196,8,21,97,136,235,119,71,123,36,176,199,227,228,108,128,149,137,5,164,77,148,159,81,47,176,108,234,54,46,235,56,167,178,84,254,105,129,190,49,65,57,236,213,149,152,10,85,206,195,221,92,221,54,74,114,134,198,83,208,132,62,75,99,76,23,147,221,170,238,47,2,231,238,159,31,157,21,230,120,116,37,205,171,183,193,105,172,143,117,1,93,76,23,54,218,89,41,8,34,70,14,172,247,13,165,93,149,104,106,13,209,88,202,31,127,1,56,213,196,57,128,219,160,128,36,102,11,50,241,144,120,109,249,181,6,101,158,193,159,198,121,72,53,117,201,226,238,36,19,89,190,170,97,242,166,133,255,187,116,117,149,110,240,34,46,115,10,173,23,253,193,26,88,218,204,250,37,212,109,250,201,191,194,118,95,136,247,161,207,241,204,135,2,78,149,74,112,131,147,47,174,61,6,17,165,170,245,205,230,27,4,219,42,253,132,224,5,105,216,149,164,189,139,111,218,70,124,62,36,131,167,58,160,166,166,15,182,6,55,43,51,18,46,56,174,90,10,0,14,29,74,85,33,208,147,69,176,90,198,106,36,37,30,25,35,124,178,130,4,84,25,198,20,229,53,83,27,191,7,155,221,115,87,5,220,83,80,84,102,251,48,221,102,199,149,98,72,199,4,97,43,61,78,97,140,141,115,8,36,76,209,170,73,151,35,27,50,135,70,240,173,0,121,54,23,163,78,109,212,129,93,171,216,134,28,83,113,141,233,192,101,187,144,201,55,84,241,226,162,50,111,152,243,114,9,111,93,4,89,234,55,65,28,241,78,143,188,189,252,70,80,238,69,204,212,181,122,171,109,189,186,144,136,240,116,95,234,155,53,70,170,203,113,36,46,45,134,195,163,140,104,104,25,181,136,167,116,55,237,25,77,120,91,44,239,159,52,190,41,227,220,175,171,101,213,127,105,222,163,58,68,40,210,118,247,1,76,42,20,189,248,76,43,113,25,81,37,26,154,234,25,226,251,39,69,143,3,138,235,220,47,9,31,25,63,195,193,72,173,92,80,43,152,143,80,74,126,49,33,238,113,228,171,168,241,82,49,174,116,73,94,130,72,230,253,161,187,183,237,195,41,153,143,130,252,152,169,147,185,106,2,207,13,134,90,175,141,157,242,255,161,154,42,107,178,145,195,16,211,119,181,175,211,84,142,39,77,187,239,159,12,177,186,243,150,95,140,58,167,52,103,146,158,98,247,173,141,219,214,180,87,55,184,155,216,203,67,81,243,45,171,219,220,110,144,106,5,138,225,212,232,110,202,220,68,84,250,115,120,118,200,167,154,108,73,90,190,72,34,47,249,229,114,4,80,142,144,22,68,254,128,128,196,171,194,100,131,176,168,30,203,107,42,65,59,156,176,21,156,53,86,125,203,58,216,87,127,233,238,153,162,195,175,35,133,212,69,25,61,96,246,99,19,132,120,219,58,140,93,223,248,9,43,246,147,166,10,33,40,237,26,6,87,228,81,182,159,34,234,48,74,27,30,186,36,136,63,92,110,3,131,130,27,239,155,0,156,219,146,232,148,189,133,204,227,35,102,6,13,242,251,69,127,251,171,127,248,242,116,126,174,84,115,6,193,135,29,128,225,230,162,23,222,79,106,4,26,156,61,251,88,57,81,76,237,7,19,107,37,95,147,230,99,193,76,98,87,252,124,217,105,200,201,204,245,189,226,154,95,54,19,34,64,85,66,163,243,6,203,46,201,0,174,183,154,181,226,46,152,199,255,75,54,243,29,83,133,231,240,6,21,38,68,184,253,109,54,23,224,31,102,11,112,103,43,17,38,125,238,71,104,161,159,219,136,215,196,141,170,10,56,156,93,207,152,188,114,22,157,0,165,25,138,205,58,248,67,193,58,28,147,32,38,229,221,175,114,14,42,161,2,223,231,204,164,6,92,49,52,64,37,164,223,252,197,118,55,243,108,10,158,239,219,175,244,102,22,194,134,212,9,249,244,43,86,97,41,53,9,224,110,61,250,140,202,187,95,171,204,21,221,58,141,24,176,120,96,194,232,84,28,125,246,218,142,73,131,254,249,22,179,71,110,208,97,247,139,162,171,64,251,79,190,180,190,186,29,110,165,88,119,225,30,58,64,49,68,45,83,93,122,136,199,146,158,106,5,211,222,64,64,160,74,72,185,138,112,186,135,133,95,31,236,77,86,54,59,235,32,245,245,133,152,27,233,115,154,253,233,222,36,218,216,218,211,137,127,103,199,95,165,151,234,33,228,72,167,103,13,43,119,38,71,23,218,227,177,230,222,214,149,81,102,246,94,251,84,233,90,116,77,26,118,194,122,55,75,208,137,52,159,238,73,8,33,157,218,178,213,108,45,131,207,210,31,144,133,204,239,144,183,230,251,195,57,195,154,39,61,36,39,117,126,121,69,224,198,15,198,98,59,82,181,202,28,149,49,219,53,48,163,19,164,57,251,219,61,159,235,12,121,100,151,160,191,93,194,90,22,119,28,191,219,210,170,234,145,2,111,53,86,140,171,46,232,231,111,18,43,83,2,142,131,38,36,99,174,3,26,169,105,31,214,250,212,191,8,1,141,69,73,158,180,248,93,117,146,242,10,188,63,7,61,149,69,118,161,141,117,25,193,18,187,220,194,82,13,30,5,225,194,158,252,56,159,129,5,240,0,213,85,67,54,209,242,151,41,141,172,187,12,215,255,6,5,126,185,11,225,35,202,5,182,98,154,26,217,237,193,140,136,38,71,118,166,44,17,223,179,101,97,16,153,33,21,204,15,219,189,120,219,24,117,23,4,153,22,143,40,174,238,185,27,159,69,251,1,227,108,218,69,111,198,184,236,14,216,136,208,115,154,211,47,149,116,98,114,40,90,83,116,92,109,38,134,140,104,157,197,116,57,122,111,5,224,4,175,201,244,62,210,203,188,216,230,131,214,184,164,54,48,242,179,251,201,77,16,77,13,77,23,34,66,146,24,12,187,238,151,92,139,64,114,217,125,244,175,10,155,138,118,58,245,52,121,17,241,62,231,105,214,169,120,184,4,155,16,20,12,215,206,40,237,161,186,68,63,141,166,178,6,127,126,151,70,195,245,163,96,91,23,138,173,211,99,103,164,14,51,246,20,75,76,135,150,74,215,220,71,15,76,77,215,250,38,227,176,76,17,15,179,232,18,19,165,54,194,146,187,110,158,216,55,66,145,232,119,152,61,63,121,155,194,202,244,22,81,66,36,140,38,108,209,21,139,25,159,255,185,60,117,9,245,95,46,99,220,27,61,151,235,253,38,161,64,188,88,189,117,249,42,176,56,54,107,62,80,240,135,153,86,180,137,121,111,177,208,196,3,194,236,106,173,82,40,195,1,146,180,204,141,11,192,120,252,52,4,116,199,14,254,104,216,4,219,7,221,233,33,47,34,247,94,0,104,240,54,18,128,85,240,255,179,195,197,161,240,178,242,197,103,68,166,60,95,131,245,148,198,163,124,209,39,120,42,206,15,106,91,118,113,89,19,66,66,241,200,64,65,37,82,169,139,136,203,234,192,172,175,27,160,244,10,91,4,183,109,177,183,93,233,92,26,227,67,87,232,184,97,234,202,240,80,213,42,133,15,68,206,0,206,110,170,227,223,113,90,208,60,11,93,245,151,50,51,86,152,199,229,35,248,13,119,64,238,165,152,108,70,48,149,157,110,249,189,25,187,246,251,124,64,0,176,165,128,174,39,200,94,100,193,34,233,19,192,83,39,177,228,74,234,195,128,251,203,238,192,16,66,200,223,179,30,106,195,189,26,217,157,142,161,132,38,20,179,217,79,34,97,189,231,106,19,144,223,172,39,206,91,192,115,254,111,141,170,103,121,61,72,101,60,110,173,73,193,25,89,206,122,137,151,213,60,169,7,42,226,224,249,190,43,17,190,187,240,163,77,26,192,162,70,170,154,216,20,183,212,229,81,56,157,247,123,219,168,91,21,53,107,174,135,98,32,176,146,78,98,190,30,232,190,171,107,188,254,223,5,25,58,134,150,36,28,218,134,107,40,253,245,199,11,1,191,26,173,238,5,142,204,170,161,157,127,172,254,27,185,235,87,15,3,74,170,36,195,132,163,3,126,33,178,173,141,106,23,111,96,111,124,164,68,230,2,210,18,190,148,45,70,148,194,38,160,67,130,166,172,81,5,91,142,239,190,58,3,102,81,212,68,68,73,134,6,117,116,100,47,57,100,207,232,224,125,32,30,193,162,117,36,57,8,27,203,56,199,110,251,56,35,162,240,157,224,0,42,206,199,201,33,95,5,127,132,29,178,152,101,166,1,242,99,155,248,47,71,180,75,84,99,65,91,32,31,136,206,52,48,74,184,208,83,85,179,51,105,125,87,66,145,207,127,71,239,255,157,126,120,139,232,35,64,70,128,118,191,41,217,7,185,86,117,216,187,163,194,206,174,218,56,214,58,160,248,111,154,70,17,108,212,91,199,245,32,108,125,43,198,192,38,68,101,100,147,129,87,52,240,50,91,92,218,108,127,101,155,228,123,77,147,41,86,207,159,139,140,93,22,169,163,63,89,236,154,98,131,93,39,55,237,122,107,6,174,184,202,126,27,199,141,16,52,167,250,44,52,64,134,244,66,235,39,127,190,88,127,61,105,107,157,35,59,146,10,14,155,241,227,170,104,180,47,95,20,235,236,196,100,29,66,255,252,236,249,128,214,5,234,40,241,34,234,45,47,166,217,121,36,243,35,251,23,126,3,133,136,164,113,22,69,236,180,239,139,48,255,146,161,48,135,129,150,245,193,181,210,85,120,4,249,147,174,66,17,136,154,208,148,214,82,198,29,171,4,223,212,84,104,93,95,153,151,59,52,212,150,113,85,179,189,60,151,118,28,93,220,49,114,124,228,164,99,165,40,1,5,200,121,138,132,77,15,5,21,162,216,252,37,141,224,202,125,209,225,242,62,177,195,93,254,238,77,226,148,168,119,167,195,151,180,25,60,215,48,166,94,44,45,114,159,78,24,155,132,119,38,31,231,227,51,37,35,33,239,40,171,12,250,68,190,248,231,228,59,213,61,15,65,53,179,92,176,23,172,176,32,72,135,37,241,24,107,242,184,186,57,99,239,241,14,0,114,211,202,79,176,88,52,130,56,18,75,55,22,208,79,100,1,57,105,53,174,100,13,234,232,158,118,211,9,144,128,160,76,177,166,10,90,95,110,144,254,243,190,208,135,184,198,226,200,27,9,38,241,0,208,210,237,180,2,22,149,157,19,155,249,21,3,55,195,149,105,206,24,110,148,19,249,58,78,186,176,25,100,216,4,198,194,104,71,150,103,193,54,223,28,146,80,51,157,194,14,178,180,189,161,192,44,225,168,111,47,225,151,43,100,26,191,125,146,222,221,199,216,186,126,173,89,90,229,77,60,34,228,75,219,182,85,232,170,22,24,130,197,101,20,253,116,141,176,241,34,223,208,190,53,49,201,93,144,151,241,108,236,120,86,232,128,234,238,83,111,80,172,96,67,34,128,6,29,10,136,122,7,204,83,50,186,1,23,79,169,21,92,114,15,132,236,51,188,123,139,240,236,199,67,208,132,52,13,194,187,174,29,120,140,151,198,252,88,147,102,219,35,162,73,126,98,77,213,8,169,217,193,210,100,239,19,153,49,43,252,194,75,228,65,143,184,39,77,42,202,171,40,113,137,164,157,33,120,131,63,197,218,5,250,238,192,175,128,92,206,161,173,254,238,133,100,158,136,16,101,127,238,52,208,92,82,3,217,66,93,246,228,193,254,74,72,78,122,33,105,54,8,66,93,246,194,222,27,194,33,125,31,125,186,243,13,92,218,44,36,132,226,180,89,124,205,104,135,159,122,252,15,162,223,62,10,250,171,0,131,127,85,178,231,79,207,40,253,46,196,118,242,128,72,35,191,117,82,21,59,50,253,123,77,220,143,104,20,203,224,176,13,252,32,28,67,43,91,75,244,94,186,135,19,180,199,223,127,142,98,37,239,28,103,87,65,235,18,238,103,120,238,30,86,59,98,172,2,220,161,99,43,3,209,122,161,55,146,255,1,36,249,99,184,3,3,168,72,232,46,73,223,106,79,159,210,38,156,147,51,126,50,165,108,52,49,96,42,238,80,99,70,146,206,224,54,97,97,16,213,14,248,251,126,49,66,87,134,179,227,232,143,91,185,125,0,158,183,5,242,48,7,152,160,171,198,163,34,181,199,170,68,125,93,97,109,136,230,150,33,113,56,104,7,226,175,49,100,51,84,213,22,135,7,237,200,148,72,116,142,163,153,122,86,4,164,15,210,118,24,67,210,223,220,137,144,48,144,180,185,234,2,241,154,213,43,109,156,143,172,26,128,135,231,119,24,217,131,61,148,77,141,150,92,115,120,2,154,217,75,86,241,208,171,108,103,82,89,209,129,238,172,132,255,207,27,146,164,74,184,68,92,141,13,124,214,138,185,244,149,236,189,182,103,67,87,10,32,216,220,143,80,210,206,245,104,149,139,20,55,5,113,172,207,125,29,89,249,19,112,108,14,88,182,201,165,18,10,245,121,6,178,148,34,12,59,196,61,173,239,178,241,33,155,25,242,134,32,227,233,188,135,113,163,52,64,251,178,224,118,246,79,167,5,63,212,177,112,180,80,242,169,49,210,21,134,141,17,157,190,91,64,227,91,38,133,159,225,105,247,226,195,200,172,31,220,215,170,68,107,20,234,183,178,143,56,158,107,86,223,172,215,193,84,10,65,89,99,158,61,203,224,96,108,213,54,164,149,13,125,118,120,95,189,114,57,41,211,241,237,209,190,6,62,79,184,242,245,149,195,91,85,198,131,178,227,71,202,112,154,51,82,29,130,223,121,113,6,199,251,129,30,201,68,187,181,197,35,52,79,104,12,235,40,127,72,62,197,101,25,50,235,135,22,61,18,204,9,17,58,139,193,112,118,161,34,157,65,113,190,135,176,140,117,20,216,176,111,50,116,217,162,214,180,80,45,31,21,53,93,2,228,123,100,207,17,230,207,97,240,183,85,31,41,46,45,3,43,72,155,187,165,203,128,67,28,120,236,54,20,65,238,109,110,179,222,136,198,17,77,149,130,251,103,177,204,150,184,189,37,5,55,241,217,14,130,255,116,126,175,235,144,116,140,66,14,51,205,67,99,220,51,208,79,206,154,127,22,85,71,77,215,145,255,44,243,64,209,227,67,73,110,151,218,87,197,55,237,118,245,39,169,244,170,245,203,108,245,142,50,189,176,80,21,202,93,146,1,53,148,177,158,56,213,31,235,149,163,76,7,160,96,185,175,209,247,27,135,158,217,147,16,10,240,197,137,20,206,239,82,56,27,22,220,198,2,89,79,127,31,142,1,6,55,182,200,142,137,107,201,174,111,181,210,207,62,30,104,243,208,79,121,233,86,23,51,192,246,38,237,63,185,68,166,75,123,229,116,251,234,207,59,122,231,68,113,211,62,70,25,143,151,209,232,208,160,147,131,216,54,242,90,239,63,40,144,174,63,16,36,202,26,114,183,89,217,89,136,230,91,48,252,125,202,164,150,89,145,56,123,247,12,54,155,187,186,61,40,196,208,28,136,119,101,36,210,226,52,175,235,200,109,39,72,109,208,243,138,191,212,112,241,255,140,84,135,41,149,18,74,71,117,169,225,47,36,251,47,104,143,61,234,88,50,148,255,119,218,157,33,205,193,198,233,229,11,62,162,92,119,220,137,255,123,184,226,35,157,8,174,39,63,216,248,137,225,131,8,2,82,204,80,214,39,91,209,189,161,6,81,144,36,198,76,197,109,194,10,4,72,54,53,184,115,91,225,10,11,168,200,46,218,124,246,135,15,89,53,166,8,241,71,83,123,154,209,50,174,37,55,123,83,140,20,54,44,56,182,163,26,6,6,190,38,53,147,232,222,149,68,107,255,157,252,151,137,92,252,145,148,33,103,9,72,231,13,116,195,38,2,23,236,159,143,19,6,218,213,124,179,244,182,30,110,173,19,168,90,131,57,252,205,106,250,34,115,21,156,227,2,178,233,51,164,166,165,72,112,14,41,93,38,111,111,37,191,106,207,33,185,185,90,72,233,134,236,98,171,160,112,169,40,190,94,93,171,234,98,137,93,127,65,248,80,186,131,116,191,197,63,31,50,255,195,58,34,142,54,220,246,198,63,55,183,44,126,0,217,209,232,158,8,7,110,86,107,240,61,28,52,138,97,149,20,247,180,192,143,33,83,155,177,22,187,216,48,139,83,169,139,99,123,154,74,125,236,38,59,46,27,30,157,211,15,232,203,47,94,136,56,194,51,139,205,174,21,161,217,7,160,227,59,236,156,91,143,154,27,42,117,22,168,18,246,201,35,37,107,157,58,5,158,76,100,112,62,84,117,50,22,6,96,111,120,207,116,151,161,13,67,239,116,206,98,64,136,103,8,201,197,9,81,239,18,226,93,190,46,81,229,232,167,200,193,215,90,182,212,93,78,67,26,105,97,197,49,164,150,52,143,248,121,13,95,217,227,206,14,80,200,179,171,10,146,200,142,90,137,125,253,146,71,131,33,45,48,69,241,119,153,254,188,241,25,222,97,30,63,46,136,159,57,134,89,0,129,234,189,184,64,200,208,245,48,167,116,134,99,230,3,164,217,19,159,106,99,97,202,22,164,70,66,13,97,32,58,239,114,37,9,60,59,67,157,37,172,251,50,177,13,116,63,7,119,74,90,248,108,175,187,95,134,112,101,157,132,160,143,70,245,232,144,69,184,106,150,9,184,122,224,32,162,162,167,166,203,10,237,99,78,75,217,159,250,237,184,75,97,163,68,55,215,93,14,236,225,12,141,49,8,40,126,117,77,135,80,77,205,97,75,21,26,145,221,123,172,2,182,77,86,93,204,86,114,144,92,13,141,25,97,222,15,100,182,160,159,142,35,220,49,107,187,208,137,105,153,135,0,174,222,172,239,170,133,207,178,208,164,230,211,2,139,92,32,192,133,89,232,32,239,245,110,166,136,37,21,196,131,79,242,98,209,25,180,252,102,119,100,85,102,115,189,106,122,226,157,178,221,143,154,92,187,57,68,241,18,33,225,250,134,114,116,72,134,250,27,40,97,219,30,86,74,184,102,193,26,66,181,24,165,153,255,190,75,185,18,121,114,85,220,59,224,145,174,176,36,67,144,74,196,161,88,9,48,79,220,4,67,25,232,105,176,32,242,28,201,66,116,178,36,164,218,208,31,240,68,239,166,138,242,198,226,27,136,232,255,174,210,152,60,200,61,15,238,2,218,231,198,130,236,180,235,65,221,66,82,162,92,235,251,20,38,65,92,156,106,85,0,144,25,182,28,226,88,153,34,253,19,27,116,90,101,248,35,202,216,184,19,35,2,94,8,209,254,66,212,135,68,219,185,32,107,225,25,227,136,211,138,181,174,112,128,190,66,165,251,135,185,108,40,159,222,177,26,58,26,148,218,89,13,15,27,236,24,118,78,33,185,174,168,219,230,119,230,179,169,161,57,118,97,227,203,9,125,55,136,197,112,94,138,136,230,112,204,245,136,116,59,13,75,68,121,43,122,9,22,252,149,172,182,118,113,61,53,171,44,42,118,178,166,69,222,44,157,34,128,126,179,24,154,159,106,149,17,227,58,143,176,241,222,56,42,62,181,26,208,33,24,30,33,112,83,127,84,65,41,251,206,115,178,2,222,106,153,209,238,98,208,200,210,177,133,86,65,23,104,110,177,161,96,79,57,142,162,15,207,173,153,56,254,250,73,76,74,43,36,200,57,145,60,95,227,21,147,221,41,171,192,107,234,251,74,126,3,247,128,122,243,153,128,202,238,189,17,198,179,70,97,245,190,200,231,176,186,98,217,254,45,230,228,185,78,204,155,64,247,183,255,152,161,26,12,21,183,209,199,194,177,1,221,95,77,76,253,203,104,7,192,167,209,180,50,138,227,189,182,231,239,238,168,59,221,119,154,107,247,102,200,51,40,120,192,133,47,249,238,189,123,233,117,188,210,82,68,72,178,111,103,77,144,205,181,97,1,172,166,152,242,0,187,181,174,188,39,82,5,75,21,213,113,66,102,62,173,169,132,21,120,138,226,211,39,44,143,160,126,74,108,191,13,117,58,148,234,239,194,161,161,156,231,240,170,77,120,106,63,168,175,231,243,60,192,181,236,20,52,239,78,141,78,130,59,219,80,208,24,37,165,109,209,49,251,9,62,80,50,249,181,232,42,228,47,166,191,144,176,206,148,242,148,153,182,121,24,128,65,137,42,161,119,66,94,240,11,55,102,122,7,205,142,144,144,180,47,60,218,192,149,85,15,213,83,8,79,215,104,8,209,172,222,200,242,28,255,51,185,167,33,226,26,65,147,100,114,222,54,27,170,212,207,83,56,170,37,126,121,14,18,40,231,4,14,164,248,6,110,118,48,51,83,228,76,3,131,87,77,86,163,48,72,194,109,53,105,118,111,198,140,133,34,20,119,56,35,236,7,170,176,164,95,86,183,232,105,108,7,25,169,127,50,26,86,83,94,101,58,219,72,205,46,231,78,158,94,221,190,147,92,96,224,0,30,65,191,21,237,118,106,224,247,161,116,33,41,10,92,81,248,232,191,41,72,116,171,89,110,208,62,230,196,11,67,172,81,188,8,212,62,255,199,22,201,68,20,120,21,90,72,70,211,251,61,232,5,238,147,16,91,225,65,103,178,238,63,246,157,100,192,170,206,249,101,28,25,120,125,225,94,105,146,218,75,10,178,103,244,73,77,174,18,113,205,198,233,5,88,129,66,64,72,137,118,81,217,130,206,156,174,224,223,115,249,164,10,160,47,237,255,135,146,236,13,99,71,63,62,20,134,132,135,155,27,21,239,159,60,195,224,248,123,205,45,147,225,233,72,95,151,236,249,144,43,148,51,197,175,100,140,185,170,200,234,37,87,113,85,41,197,41,164,33,181,64,228,58,125,41,220,43,111,47,37,139,69,75,126,166,210,12,7,175,6,63,122,236,237,156,149,142,254,174,11,37,215,82,200,54,62,74,43,2,249,172,218,115,203,91,14,165,110,103,178,200,5,226,141,45,42,68,130,198,173,253,230,217,122,113,39,163,182,160,231,100,179,40,207,8,27,212,22,174,85,58,27,55,118,83,118,244,201,68,167,205,50,31,36,17,250,228,187,200,203,159,109,44,83,197,240,214,82,128,207,62,237,127,108,238,226,36,190,44,152,27,248,90,79,254,43,191,182,206,138,179,239,133,27,56,192,25,166,40,83,172,241,62,178,172,53,58,205,73,6,139,66,50,24,22,193,232,205,173,161,67,139,236,13,114,239,156,46,253,12,218,238,6,255,169,98,117,8,215,156,102,178,212,208,18,175,147,108,96,73,71,115,87,75,254,77,61,212,49,252,42,72,23,95,49,206,208,189,203,240,139,4,56,101,109,139,204,117,23,213,104,47,1,254,115,179,25,96,58,221,157,53,112,19,110,172,118,168,11,21,171,109,123,100,79,124,202,172,155,236,144,86,224,44,183,119,167,51,180,139,191,76,201,173,212,215,120,148,255,149,110,69,229,152,112,197,133,178,122,15,23,55,103,67,13,152,239,59,168,53,175,130,232,143,236,0,96,95,206,91,141,167,127,199,149,82,51,222,51,43,148,225,183,56,32,68,76,97,35,154,233,207,47,2,29,114,143,36,159,81,168,169,22,163,74,208,233,149,204,129,138,138,13,48,180,42,41,155,141,156,228,19,71,135,137,63,119,146,67,61,236,133,52,209,164,39,67,110,28,5,36,100,159,52,79,220,118,89,126,230,63,180,117,243,165,179,147,209,255,162,97,177,43,45,86,56,48,223,195,122,39,130,118,8,183,36,55,42,221,83,72,74,95,130,91,23,121,226,221,206,241,204,44,105,177,188,105,190,84,106,225,244,183,44,76,188,169,150,98,155,208,244,161,94,75,232,173,64,126,153,184,124,75,229,87,31,209,154,93,125,64,53,167,155,250,167,122,169,184,231,14,34,61,208,47,179,182,194,37,87,240,10,125,2,26,125,232,189,207,199,3,153,204,157,148,33,93,160,134,67,238,203,126,198,203,210,112,25,199,23,136,192,135,207,227,224,213,125,17,93,230,177,178,164,152,162,80,107,50,52,221,42,20,128,143,202,168,22,91,223,159,118,214,249,29,184,124,24,124,1,183,54,43,61,91,155,116,241,94,157,187,60,100,244,97,97,177,9,57,90,72,245,38,31,86,172,41,102,15,35,39,4,233,141,9,165,41,137,229,44,122,16,181,99,178,84,124,207,34,140,41,145,250,172,186,100,100,156,162,5,126,187,160,57,183,240,17,46,181,44,120,144,141,151,142,129,195,192,11,203,241,78,134,142,214,106,198,94,141,84,62,51,127,110,9,65,150,68,221,157,131,236,130,114,10,128,197,13,157,252,8,165,223,138,108,179,156,231,156,82,132,196,202,13,64,69,92,110,180,238,15,125,240,30,231,134,56,66,31,193,191,100,72,106,233,11,113,8,121,238,178,117,107,157,215,58,43,212,236,53,215,214,1,16,192,173,175,231,62,113,26,94,248,47,30,36,232,160,227,75,161,127,33,5,192,210,69,155,249,190,217,224,42,17,77,54,231,20,45,5,116,154,154,80,74,148,126,85,137,13,59,123,226,167,20,148,24,19,123,17,78,46,126,232,255,147,20,83,85,103,16,86,141,246,211,162,58,245,162,77,31,51,40,174,164,117,38,201,18,8,240,124,226,180,213,190,92,223,249,184,227,8,168,86,142,19,66,247,142,54,135,218,13,197,216,225,152,61,155,156,171,88,150,158,129,132,144,138,13,21,166,17,156,62,40,147,131,134,66,228,77,177,184,53,207,92,208,3,16,2,45,215,154,73,196,92,47,104,0,94,23,103,132,206,81,105,63,84,231,7,205,95,148,128,250,142,158,42,49,223,26,22,72,27,211,39,245,201,245,4,127,48,221,21,121,201,223,108,209,6,93,31,85,112,207,74,123,201,78,249,139,38,60,134,47,225,21,74,31,177,146,41,144,16,100,28,219,207,21,104,154,200,135,169,238,147,227,243,217,211,187,109,182,74,223,148,201,132,46,26,159,121,196,145,148,161,153,126,127,103,44,44,215,135,248,8,157,23,184,220,82,173,81,229,136,173,243,230,69,68,158,137,156,73,166,209,116,155,166,231,141,186,187,84,175,227,63,227,13,18,245,222,185,2,9,97,179,58,174,246,67,94,255,153,44,100,138,172,19,5,67,221,82,20,224,61,104,222,44,53,106,82,147,130,225,31,218,140,64,109,45,5,216,165,119,100,159,228,18,213,150,192,59,85,135,249,36,228,230,57,28,67,206,105,230,148,212,28,106,92,97,2,31,152,107,208,11,10,205,238,102,126,66,83,190,233,77,232,77,96,85,249,251,119,192,179,5,0,198,67,127,22,157,78,146,64,204,6,39,200,12,229,227,234,242,193,195,141,125,107,248,143,210,251,18,220,67,240,110,48,114,110,15,160,241,14,133,152,132,225,44,134,92,88,11,167,164,225,12,234,164,92,9,175,74,190,164,193,157,232,4,137,216,80,165,124,20,254,221,2,198,63,217,156,135,119,4,178,58,153,215,139,67,52,172,206,47,40,75,33,86,67,63,41,10,20,37,237,37,156,4,13,25,23,201,228,9,237,67,16,22,116,17,184,162,203,188,227,13,110,65,231,79,200,61,118,207,68,161,90,71,47,113,31,224,165,90,23,21,239,63,80,176,54,103,99,60,125,72,207,90,110,231,121,225,205,35,28,16,137,252,136,94,179,14,97,157,227,66,82,219,137,26,78,157,181,147,28,161,251,43,196,201,53,245,149,152,194,86,91,70,203,91,114,199,241,212,180,125,44,131,135,116,26,132,69,27,84,222,132,88,96,163,119,62,129,249,230,33,147,28,124,23,172,231,132,144,182,235,125,193,70,233,206,77,27,210,203,223,213,95,105,230,117,205,214,164,126,23,240,10,34,237,211,43,162,138,230,118,192,86,247,125,167,215,62,26,113,209,175,19,231,246,167,150,22,44,69,31,236,205,198,210,214,123,93,60,9,175,131,96,145,71,92,190,209,201,225,103,43,204,242,98,253,129,95,56,223,107,29,87,165,180,44,49,28,37,42,83,215,122,91,126,77,38,243,71,213,191,223,14,76,247,97,110,190,120,147,167,234,237,10,98,148,45,218,3,23,117,15,148,142,173,118,236,90,31,27,85,54,188,202,253,43,102,109,130,17,8,239,241,89,212,14,29,172,179,90,8,104,5,203,117,188,43,184,167,54,8,100,136,17,55,201,102,193,221,245,173,86,65,162,176,40,92,214,101,18,82,59,131,63,156,187,219,65,190,115,172,242,52,181,80,109,165,136,98,148,149,152,234,86,143,132,100,239,159,119,163,250,30,130,119,190,45,58,208,104,161,144,10,202,200,31,177,215,242,236,78,3,151,34,8,16,172,231,112,71,159,168,32,208,230,50,84,234,214,40,92,65,60,148,117,76,216,111,91,121,177,66,86,123,55,54,126,46,118,241,103,105,245,89,242,0,0,166,87,7,145,164,227,90,30,10,4,88,64,114,70,127,14,161,218,198,16,35,230,115,54,65,108,190,175,186,252,79,33,24,82,118,130,249,181,253,61,28,154,77,227,209,111,63,61,68,223,162,41,90,176,37,114,169,199,77,160,219,199,22,79,240,212,158,243,217,226,74,158,215,193,166,204,82,135,0,106,12,155,150,113,241,197,33,205,6,16,19,118,164,194,115,243,112,162,251,134,203,122,124,61,242,68,140,200,131,168,172,123,48,70,132,227,199,3,196,130,48,55,231,64,216,195,86,36,160,233,137,145,108,224,93,218,61,107,191,138,171,13,215,212,65,223,117,85,120,109,207,141,12,23,221,175,68,130,129,185,138,67,225,85,127,85,215,75,146,79,69,133,10,129,210,51,71,147,116,11,104,76,194,87,78,137,12,108,185,53,10,210,35,135,33,203,224,96,175,47,98,138,83,60,163,16,100,51,21,186,245,7,153,128,164,73,27,189,195,13,61,255,96,12,174,169,37,39,235,177,224,137,71,128,240,63,137,238,255,68,185,212,135,190,156,240,184,158,113,210,241,119,224,63,177,236,63,172,135,117,74,27,187,227,253,246,222,134,197,251,197,243,107,188,160,85,252,111,4,141,195,243,91,73,226,144,131,109,136,10,172,209,186,95,172,96,107,43,22,44,176,226,122,100,50,28,65,163,62,235,88,16,254,97,48,250,64,155,101,21,83,64,255,189,98,142,60,20,184,3,54,87,20,50,178,254,138,105,53,169,141,5,88,57,244,207,138,191,208,185,54,87,134,70,182,197,77,248,201,118,133,148,231,106,241,215,91,61,184,61,250,9,140,91,66,203,141,93,171,166,65,183,29,234,196,85,230,194,177,148,240,126,71,14,92,212,2,120,179,141,11,42,166,15,45,196,187,30,249,247,104,244,5,25,126,208,252,253,157,224,36,138,145,222,221,213,15,204,112,217,50,193,215,194,2,248,214,48,43,229,7,204,79,218,223,82,137,114,228,41,220,68,157,35,245,242,213,255,141,189,192,243,63,72,119,222,107,252,230,192,211,47,186,209,144,213,221,185,22,152,208,54,130,76,100,242,54,210,211,40,29,189,40,7,183,252,209,130,240,76,107,14,110,35,151,57,0,187,180,78,210,153,198,18,212,33,205,72,211,89,150,175,136,7,138,13,18,93,226,93,52,171,126,188,165,113,29,15,231,234,11,67,54,164,115,158,58,48,20,202,65,198,247,224,202,190,45,10,153,146,148,150,218,67,157,27,190,197,15,182,135,56,130,43,203,209,174,134,100,81,179,58,182,229,1,155,224,135,148,214,99,38,92,212,220,49,17,170,248,161,123,88,92,5,119,19,210,149,12,254,121,21,140,38,10,247,25,4,22,186,68,1,211,221,109,182,103,137,4,242,129,66,67,138,61,50,131,83,208,81,53,132,36,86,63,33,62,142,250,210,195,68,246,210,84,77,150,182,48,140,129,1,24,195,122,107,160,22,129,227,250,27,102,21,127,52,229,47,19,58,21,47,132,85,233,11,183,119,3,54,223,94,30,168,153,3,202,62,170,29,46,235,105,186,122,192,71,128,73,149,47,98,46,122,34,64,101,76,177,160,154,47,174,96,118,108,73,203,121,15,19,101,72,99,177,70,118,219,124,182,128,41,154,76,22,204,166,120,224,174,35,27,29,63,8,248,217,183,247,192,11,141,178,28,4,184,73,111,64,221,65,220,21,145,34,163,79,94,28,225,40,146,182,182,2,244,18,250,136,64,65,3,121,52,149,19,150,105,221,244,244,247,77,249,155,100,216,128,178,170,122,153,140,221,2,88,211,227,255,108,191,91,6,185,100,148,31,75,245,179,229,46,107,30,214,20,93,198,142,86,108,83,131,235,38,107,38,203,229,248,160,22,216,41,215,22,55,59,211,156,38,76,79,202,176,49,88,161,162,206,46,81,83,200,99,138,117,40,110,2,84,142,165,212,63,185,183,35,165,96,218,110,177,40,36,21,19,181,76,171,145,175,144,249,115,42,97,99,152,49,128,122,54,8,136,236,196,46,137,181,211,218,83,112,177,64,193,136,89,220,176,221,204,172,174,154,77,96,166,191,132,59,141,90,169,6,46,45,84,193,160,209,49,6,199,255,3,129,73,146,92,31,226,30,164,12,7,148,241,217,3,113,226,199,81,146,95,141,45,176,205,253,233,128,78,74,123,244,138,154,234,99,11,241,18,251,174,123,196,122,254,82,210,2,90,216,87,97,38,253,160,197,255,134,152,168,162,17,72,133,41,122,235,85,154,133,172,162,240,103,107,149,216,192,182,55,27,163,94,52,129,61,154,61,11,135,223,222,154,217,53,135,124,181,120,2,41,107,239,28,32,232,45,27,51,86,176,14,7,40,249,170,100,67,101,131,23,151,200,74,151,82,184,146,40,7,64,240,146,253,80,218,150,108,16,186,224,225,98,8,166,177,252,0,35,95,107,137,80,130,116,129,161,149,37,52,149,240,167,11,50,129,134,80,126,16,233,201,206,97,186,68,205,245,254,241,139,20,5,89,162,39,98,188,107,186,119,233,101,250,245,150,241,120,191,39,29,12,121,31,198,242,252,230,85,160,112,172,171,128,29,103,65,246,39,126,74,92,140,142,56,181,82,101,195,59,71,4,8,9,42,98,180,136,41,26,56,252,4,230,102,239,251,161,183,106,22,54,238,250,59,61,243,9,189,77,195,254,119,234,124,186,211,5,26,88,176,159,87,101,242,100,179,102,218,39,85,82,118,109,146,144,225,73,28,78,77,189,135,29,192,12,95,153,113,248,50,171,113,241,189,121,194,155,247,109,70,124,72,61,27,79,56,185,218,51,155,130,98,183,1,100,60,85,55,160,158,110,41,58,63,216,176,49,228,195,87,118,254,105,223,41,138,84,41,78,214,111,49,206,175,91,190,57,25,68,120,22,127,85,81,202,226,197,123,156,169,249,12,182,148,31,115,211,146,41,208,248,249,197,188,103,47,138,8,117,43,130,28,28,102,44,149,38,221,176,211,11,76,148,186,176,252,87,62,69,3,88,80,123,168,196,245,128,224,186,224,99,220,46,237,181,88,159,161,175,204,237,160,154,13,131,12,99,88,171,231,111,242,238,194,193,15,3,254,152,148,114,131,215,216,106,245,73,197,176,147,149,25,185,200,252,52,225,236,86,240,34,22,76,102,243,132,148,11,204,125,58,185,37,184,188,4,169,89,249,104,232,254,3,96,102,68,177,242,8,251,188,177,100,48,1,248,177,185,181,108,161,130,117,35,229,28,94,131,105,31,242,158,200,167,63,124,21,55,142,139,10,202,5,82,209,8,37,48,22,47,237,174,182,254,11,32,46,255,142,78,113,207,192,187,172,174,16,156,90,26,138,142,57,129,2,59,148,175,197,194,242,205,81,57,214,199,206,60,204,225,254,113,28,148,222,242,209,101,104,98,108,237,223,49,114,212,129,78,146,78,208,40,162,230,188,127,198,195,47,15,146,82,173,159,186,217,133,148,237,194,5,33,102,245,90,65,8,165,35,12,231,205,62,97,232,36,7,127,30,119,233,149,99,221,178,173,102,226,168,250,196,60,181,5,125,126,243,158,64,110,37,30,195,162,229,136,241,198,229,105,88,85,49,14,96,84,216,55,253,53,92,172,24,38,54,35,37,50,118,149,84,244,199,203,56,87,218,44,100,7,25,135,147,55,101,115,200,99,37,8,239,72,221,30,76,8,86,146,55,44,91,241,31,111,230,90,185,168,144,245,50,43,46,238,33,229,223,34,244,14,118,219,103,141,110,249,21,49,255,202,251,214,126,66,144,34,95,94,195,240,131,109,100,123,73,158,69,82,217,206,59,169,190,31,185,211,83,88,73,74,185,229,228,147,57,21,198,39,234,143,84,167,170,144,247,206,56,43,55,104,193,157,220,89,125,173,151,17,4,10,18,124,244,41,133,194,59,11,202,98,174,212,26,19,95,71,26,82,242,133,85,125,4,131,36,108,37,250,255,99,63,15,53,173,129,255,175,83,105,132,142,35,4,243,133,67,237,220,88,25,169,219,83,229,33,83,46,251,0,111,226,87,41,226,98,245,208,93,251,94,207,210,41,146,56,119,137,32,0,61,212,6,161,219,144,112,202,88,124,132,83,197,240,185,196,152,34,202,136,59,198,165,5,136,11,246,158,60,3,176,105,203,207,70,162,187,45,160,39,60,82,115,113,239,37,166,188,235,215,222,227,65,73,188,70,178,98,215,247,7,12,10,4,216,139,202,178,125,231,103,79,61,127,58,10,202,75,42,107,139,214,172,4,14,3,23,73,247,52,158,78,61,218,235,79,191,182,70,127,157,34,208,242,177,248,153,110,42,50,168,186,212,159,202,174,245,161,60,197,47,221,200,111,195,231,35,136,145,196,62,119,52,247,41,50,41,64,94,231,136,149,213,174,127,157,61,143,47,166,152,59,245,186,16,70,32,201,49,239,157,90,225,122,138,88,158,93,59,121,246,69,151,25,182,189,199,100,74,131,123,99,103,185,138,240,169,255,83,8,240,13,159,156,5,223,181,247,243,244,179,90,207,159,36,69,34,174,29,39,12,198,108,220,130,2,10,203,188,206,67,116,209,27,67,170,198,93,113,250,14,198,254,196,37,146,198,0,245,162,19,196,105,30,136,94,211,48,61,213,53,160,236,102,140,240,236,1,246,124,73,73,184,88,243,157,125,154,77,39,104,111,1,205,78,22,233,44,37,253,92,198,51,8,211,150,43,192,106,122,208,21,123,140,14,148,222,144,217,194,15,242,120,80,45,66,71,74,147,132,37,185,45,165,41,76,166,143,130,134,3,4,15,104,214,102,179,162,238,195,200,235,20,223,172,249,110,37,43,216,136,128,232,235,48,215,2,250,173,82,109,146,30,125,217,231,73,206,65,2,40,45,35,163,248,230,102,19,67,102,0,76,64,7,130,23,167,105,28,152,26,73,234,15,36,35,231,146,205,50,217,164,199,154,192,15,19,80,26,30,181,14,197,12,131,88,61,140,86,85,233,182,210,78,143,77,63,177,30,176,10,224,14,137,130,162,84,191,108,227,75,85,115,237,159,119,222,168,131,18,13,22,92,110,176,134,71,180,31,116,154,111,4,116,74,59,2,191,75,114,181,184,238,106,236,202,251,63,247,48,35,155,172,61,122,174,26,38,3,176,42,15,71,195,153,55,66,191,33,169,177,220,36,95,177,66,86,173,31,180,219,166,178,139,120,139,67,88,25,238,233,169,169,111,163,217,54,29,44,34,138,236,199,35,50,82,214,30,125,91,25,222,65,137,125,96,232,78,167,209,68,71,70,1,22,163,34,202,200,71,113,235,157,41,14,32,110,171,235,197,174,10,51,158,251,44,98,199,201,196,168,50,201,99,205,245,153,75,169,17,143,154,52,222,138,28,173,86,92,134,115,136,220,131,85,171,122,218,117,190,117,143,79,26,121,10,50,45,80,241,33,4,253,140,1,159,201,105,123,35,133,81,59,236,16,238,109,215,10,124,211,64,112,180,147,203,106,142,69,97,205,162,177,217,151,174,189,239,69,50,30,166,238,219,120,79,225,197,121,127,91,215,89,102,17,39,158,213,94,164,254,49,125,216,191,222,90,38,224,214,242,60,2,38,241,139,218,34,185,186,30,206,33,43,38,242,81,191,12,1,200,96,167,125,197,194,127,129,244,184,30,74,74,196,174,229,224,226,124,52,137,122,146,108,187,169,127,72,111,131,243,79,149,236,134,103,137,212,161,44,61,183,188,103,150,96,95,88,187,167,31,213,185,63,128,70,10,58,47,69,155,112,231,242,129,19,78,116,74,152,85,44,128,199,241,148,56,48,27,194,180,191,35,170,227,179,166,110,172,88,208,185,53,153,120,109,155,216,205,172,159,59,191,94,49,209,213,90,125,246,132,153,163,89,50,28,91,141,185,11,4,229,210,18,79,36,117,191,90,231,97,92,89,193,98,201,7,9,252,3,100,157,87,134,164,29,218,54,7,117,232,97,226,74,185,43,135,78,199,151,206,137,157,244,201,49,137,164,23,115,134,121,92,128,224,192,100,154,252,124,146,17,129,44,130,237,65,159,194,35,88,56,132,29,163,200,91,112,118,35,100,76,112,87,180,233,171,69,124,62,161,232,54,66,129,248,193,47,232,197,143,236,112,36,132,61,97,179,231,60,124,4,220,161,114,16,84,196,143,200,58,98,2,255,8,3,222,42,146,204,234,68,199,78,202,173,32,215,30,242,64,32,250,49,111,31,174,191,209,40,51,55,101,12,137,212,116,140,72,132,52,104,204,245,218,122,29,236,175,188,112,137,112,129,225,22,84,118,55,75,104,13,207,51,243,102,148,120,49,86,192,53,173,30,143,161,0,187,160,141,185,32,104,37,221,242,44,29,27,162,135,12,4,205,239,98,8,217,237,81,207,29,240,169,209,6,80,56,120,99,193,90,244,235,14,45,162,130,224,62,152,96,147,9,238,188,49,82,151,207,8,240,126,39,228,192,121,199,227,52,238,238,69,130,134,174,90,34,126,176,133,63,234,79,219,126,186,224,106,183,242,244,90,180,161,17,110,155,66,109,222,205,83,121,103,49,85,234,220,198,98,67,0,50,194,21,182,193,118,19,220,4,173,96,221,203,40,186,232,98,162,37,12,169,225,26,229,12,71,121,194,162,100,159,139,30,0,151,86,14,131,219,129,154,212,170,79,126,26,171,90,92,239,0,106,79,97,213,183,128,12,238,216,30,67,114,73,64,191,22,179,225,12,252,220,234,87,55,51,145,66,34,63,168,252,148,87,47,176,54,228,85,152,226,61,198,41,76,94,182,131,134,142,127,97,14,232,78,147,107,91,23,55,184,220,0,132,128,230,214,41,253,146,45,59,69,244,78,228,127,47,234,235,212,197,152,203,251,16,167,93,153,46,245,207,238,82,246,96,131,4,123,250,67,9,15,63,198,214,205,18,51,223,238,190,104,69,185,188,1,61,168,132,22,21,224,86,237,119,49,15,228,241,216,161,180,19,252,22,109,144,133,49,21,97,145,73,250,32,160,0,103,179,235,69,26,206,44,140,184,97,110,167,21,84,228,112,18,154,24,41,60,232,190,168,43,72,248,82,221,13,138,79,89,140,122,61,117,232,17,75,243,217,88,218,235,50,96,182,174,230,168,249,99,90,3,240,143,171,128,49,247,62,32,242,216,73,239,88,172,30,77,172,78,40,138,46,152,178,103,92,139,57,224,167,208,14,63,245,78,69,235,225,103,133,134,96,22,32,104,77,117,153,192,206,38,183,221,117,253,207,240,211,16,89,105,251,119,74,144,222,156,150,154,58,135,38,58,165,24,125,4,181,205,243,117,226,156,243,80,70,66,176,146,37,197,55,215,99,87,148,92,191,170,198,29,60,48,57,132,232,226,100,191,28,143,184,235,205,69,47,243,18,71,89,96,148,5,68,98,120,4,46,222,166,248,156,123,31,13,147,244,29,153,133,248,130,207,112,2,139,131,49,115,58,120,121,244,170,19,97,201,192,75,161,137,127,83,157,78,253,58,222,224,220,83,182,11,236,101,153,140,34,113,36,254,143,112,151,78,23,46,155,32,170,178,239,64,77,243,128,127,240,27,82,213,68,205,87,27,42,124,75,156,9,234,4,161,210,181,7,140,130,78,31,105,100,208,169,223,62,105,229,132,50,56,128,226,5,184,254,213,116,54,2,93,233,67,132,34,39,179,133,27,209,227,163,127,21,38,10,175,140,28,114,70,190,173,123,166,31,176,23,83,27,2,64,147,250,217,95,1,100,211,238,42,151,65,188,182,234,61,134,64,31,245,14,173,167,214,244,223,242,182,230,208,180,241,228,142,135,251,1,188,189,100,175,18,181,117,35,14,102,136,20,208,168,235,41,228,102,112,204,114,197,137,63,144,1,174,122,8,52,194,119,247,169,229,16,103,124,105,126,128,30,165,102,132,107,24,55,253,220,212,101,202,129,150,144,2,88,195,9,152,160,243,97,168,80,228,18,168,79,186,193,151,206,197,164,32,6,58,126,128,178,154,122,20,188,81,123,96,6,46,214,149,107,24,177,129,255,208,247,29,66,228,212,126,81,168,1,76,131,174,108,141,122,248,24,107,113,170,68,235,117,129,83,56,163,148,130,79,104,185,22,138,198,242,77,180,102,47,117,225,233,90,16,225,8,163,241,112,173,15,227,176,197,136,139,114,202,96,151,63,60,96,154,107,17,147,224,206,248,93,53,106,235,229,60,87,165,173,67,60,192,40,25,38,154,183,128,195,41,187,21,254,166,61,76,158,20,29,63,194,131,191,180,111,32,193,245,193,122,94,224,84,142,94,172,150,192,219,151,49,107,61,164,252,204,72,119,227,21,253,120,84,60,176,113,224,172,24,196,92,64,19,6,114,3,127,121,48,40,3,60,52,74,110,225,56,14,140,23,179,58,129,206,230,166,25,190,123,31,5,201,50,253,204,94,174,116,91,166,97,216,90,145,201,152,88,164,18,19,17,202,204,251,146,159,61,233,43,209,63,240,241,168,94,78,86,211,0,62,97,12,204,199,62,218,65,64,9,170,91,210,0,191,56,249,81,51,140,84,246,229,192,59,27,87,104,195,108,174,216,168,188,98,234,57,57,162,193,13,190,155,45,124,40,58,32,99,14,179,68,39,112,92,159,159,36,201,2,226,129,171,120,102,185,148,114,152,162,196,181,56,69,182,37,197,98,228,38,41,142,10,57,84,197,160,183,210,236,9,42,214,224,63,62,31,118,26,251,177,236,185,210,104,244,19,251,195,113,141,34,50,255,204,42,56,117,66,203,139,249,119,14,28,203,175,32,42,245,180,104,11,154,25,127,248,60,200,28,180,91,39,244,161,108,240,140,189,72,32,119,76,235,30,100,46,74,250,110,234,232,192,243,51,124,39,251,186,123,64,23,149,105,161,56,180,49,163,245,34,42,187,145,64,13,82,135,95,186,146,44,214,135,104,194,94,110,93,178,242,130,21,226,63,156,184,127,204,241,167,193,180,9,237,106,90,105,165,19,198,246,140,189,35,66,77,27,170,145,237,170,99,161,189,234,238,51,219,82,212,214,32,43,128,193,45,163,2,216,44,192,84,104,92,99,93,116,94,163,255,90,174,176,184,147,127,46,68,22,63,23,62,151,173,125,237,52,101,54,144,205,184,145,103,197,86,53,11,127,158,118,175,217,13,86,251,47,11,230,181,185,174,212,134,254,17,229,174,154,246,87,107,230,55,252,104,84,104,251,201,66,110,183,24,71,54,10,178,175,12,182,18,163,73,203,244,85,216,175,129,81,60,17,112,71,155,136,34,122,134,137,245,172,152,64,127,55,97,0,148,116,138,88,45,172,16,250,169,10,55,168,155,249,246,117,74,112,183,220,144,84,127,245,255,79,75,162,219,9,150,235,53,199,122,194,58,198,192,83,66,183,114,7,36,198,143,179,218,40,178,248,218,185,108,140,103,50,91,31,235,191,230,109,62,140,189,224,31,241,31,255,48,167,106,18,242,164,95,24,208,232,159,107,188,95,66,187,61,92,245,43,201,191,135,1,41,19,255,103,156,115,9,219,112,48,74,62,113,152,120,196,200,133,105,206,67,75,26,102,159,159,237,244,74,119,46,70,217,24,102,5,82,212,11,224,67,44,241,148,125,122,140,30,141,56,185,122,202,228,228,152,203,143,221,92,116,168,69,113,89,106,187,215,201,255,151,132,143,105,97,52,138,102,179,146,194,72,5,11,142,16,31,119,218,54,11,45,117,143,78,191,169,116,115,101,231,67,196,81,203,175,126,36,74,3,153,52,15,176,118,87,2,10,235,166,166,25,217,24,97,56,174,121,208,62,83,81,159,25,1,81,67,213,89,71,34,140,83,221,7,159,118,96,172,176,235,249,185,28,97,166,17,64,245,165,23,63,251,128,105,12,76,148,92,91,188,236,238,25,184,58,203,60,22,171,192,183,224,144,158,173,39,61,188,92,76,155,181,102,5,187,207,150,94,58,3,250,36,236,210,151,254,24,164,165,111,28,108,229,47,22,146,124,12,137,148,24,184,174,127,13,247,114,83,177,100,178,209,116,247,77,184,99,249,116,52,90,208,48,242,239,23,251,172,248,54,133,62,24,240,90,110,209,64,19,65,231,127,36,40,74,61,89,232,108,40,133,183,241,255,164,20,180,249,37,233,11,144,123,198,10,134,56,30,115,232,181,188,113,167,11,26,133,132,207,13,144,114,236,85,141,70,151,42,10,176,211,160,243,33,210,57,247,197,33,32,215,207,152,153,82,222,95,87,217,232,251,9,157,52,92,92,186,221,244,36,132,244,171,126,222,212,178,213,118,239,52,68,215,228,157,37,229,77,151,40,95,205,177,209,250,59,223,193,65,135,147,161,220,60,30,20,221,12,251,251,237,115,218,76,211,222,227,113,244,133,150,144,25,141,230,202,17,219,118,142,8,254,249,111,8,74,66,92,214,206,5,252,176,47,65,208,174,127,25,182,208,254,125,215,136,104,95,122,148,47,160,24,171,217,115,108,36,46,111,121,54,209,200,78,201,242,47,82,146,153,116,84,30,151,175,199,2,189,89,106,30,113,219,11,101,233,191,165,1,168,238,15,156,187,76,114,205,125,10,232,251,59,152,234,16,241,125,111,195,40,170,83,198,62,219,137,128,20,195,25,33,235,77,95,39,151,116,175,239,44,250,171,84,173,154,211,23,212,157,160,162,208,164,16,244,147,14,14,17,6,104,150,53,108,250,78,227,27,137,22,252,98,238,175,243,37,70,13,183,79,164,152,113,101,78,244,30,197,103,210,103,214,38,156,171,0,17,21,28,178,30,168,20,31,200,208,51,52,113,15,151,103,235,237,40,10,81,34,216,193,173,182,231,138,223,70,74,110,140,135,128,67,193,157,182,109,142,223,157,163,206,148,192,228,100,183,148,130,219,246,217,18,184,83,27,227,178,40,188,85,136,45,33,244,69,87,159,128,40,97,108,157,0,46,148,60,23,222,235,38,205,188,53,18,244,187,182,168,183,237,144,27,24,195,130,65,220,216,15,20,137,249,27,41,218,232,246,197,92,106,119,80,113,188,192,30,233,34,219,39,146,187,114,27,18,165,104,236,249,38,44,105,166,205,230,49,128,243,36,251,113,40,38,25,215,224,120,27,235,159,12,92,34,87,109,158,74,60,6,136,178,187,38,91,137,86,88,121,201,214,195,151,83,64,228,135,143,158,147,97,176,188,111,251,247,113,197,192,23,113,9,177,188,15,65,193,111,153,189,107,45,251,63,75,15,75,144,12,21,147,41,0,174,131,76,50,32,230,156,172,12,21,217,99,174,122,176,90,142,255,218,205,218,102,252,254,211,225,2,68,190,66,50,226,64,173,14,103,174,112,42,47,226,144,59,125,110,69,123,255,9,156,24,136,238,168,115,76,198,25,170,142,181,178,27,82,125,25,38,98,50,248,232,139,82,51,79,162,74,26,73,204,26,40,13,40,2,73,96,105,177,92,99,35,99,110,56,185,105,177,205,31,100,153,114,150,60,150,252,43,129,210,116,71,159,252,129,54,152,242,65,180,226,15,50,224,127,124,175,143,91,38,46,62,8,22,59,186,178,38,77,246,103,48,216,212,109,56,156,174,127,24,51,123,161,249,178,142,219,27,68,158,78,254,94,242,73,34,240,204,200,93,216,7,25,228,165,205,3,19,2,181,77,104,175,11,217,230,194,135,111,69,253,161,56,50,214,192,155,137,146,17,189,167,202,57,121,74,241,142,45,201,161,154,57,125,92,44,130,241,88,74,115,124,14,144,36,13,187,40,11,139,4,59,158,157,206,13,92,151,135,1,219,94,61,152,173,99,202,240,172,225,103,253,248,69,184,171,34,33,169,218,245,125,15,58,199,178,40,202,80,134,75,170,110,92,65,6,58,200,15,51,116,102,229,188,24,164,185,80,221,62,235,227,1,238,159,158,44,47,211,248,136,211,153,57,241,104,231,90,19,39,187,253,118,187,69,91,208,213,90,157,249,110,157,246,186,4,46,212,11,235,27,55,22,236,16,139,224,123,76,76,174,18,156,21,2,25,59,83,147,157,186,202,18,243,139,77,192,205,43,11,67,231,130,169,53,171,6,241,244,138,2,96,125,93,209,194,120,187,162,104,129,237,118,242,149,94,212,207,222,141,202,202,204,103,231,34,132,92,157,95,239,176,202,195,185,87,154,63,219,10,215,8,146,73,190,222,17,110,27,90,35,66,27,93,191,17,12,120,158,138,224,58,68,152,169,243,48,157,252,163,132,148,157,222,184,145,161,202,141,123,93,61,82,14,213,82,53,66,165,100,215,10,77,207,216,139,35,208,176,63,63,80,219,7,147,222,36,12,252,16,92,225,56,96,70,218,129,99,205,25,99,208,253,109,43,104,153,0,224,39,192,163,67,138,85,157,8,128,148,197,89,194,87,99,206,81,141,47,214,217,156,211,187,184,220,33,32,20,31,143,48,136,147,54,141,147,129,53,91,215,115,208,74,187,36,225,92,30,238,23,79,195,80,124,161,28,40,129,212,156,128,13,94,16,64,122,47,166,181,116,236,218,16,106,162,20,12,250,106,59,75,168,173,41,229,75,239,230,135,79,240,61,106,144,243,222,80,207,8,155,238,226,204,246,25,2,83,116,227,42,121,189,61,88,237,200,221,66,111,84,209,44,204,5,74,21,249,236,194,187,52,103,164,109,114,191,27,0,240,99,60,253,103,92,69,90,87,109,109,138,61,171,55,129,98,152,62,65,82,93,47,130,95,171,12,145,48,243,4,220,47,118,144,188,144,153,224,242,141,144,94,218,128,144,77,106,98,182,215,118,91,73,238,22,122,110,3,109,89,91,34,0,57,72,86,228,158,153,209,235,58,200,213,223,68,254,49,210,128,11,87,0,207,25,93,183,141,193,9,142,11,15,213,209,90,220,249,117,222,163,188,42,116,162,111,235,175,70,29,243,205,184,46,214,112,219,68,27,190,37,228,13,196,98,127,58,220,90,248,241,41,128,82,170,102,78,72,99,103,47,49,238,210,203,217,40,130,83,98,143,81,119,52,173,166,24,234,61,253,11,147,118,189,128,69,161,207,122,161,251,67,139,246,0,44,109,95,241,166,224,177,225,201,10,38,201,24,44,192,55,22,191,109,159,167,39,67,213,33,100,6,197,183,223,105,223,51,37,21,232,53,7,12,64,243,13,77,22,76,175,156,127,201,50,147,144,135,179,71,59,88,161,195,29,23,213,184,66,77,202,54,134,198,21,205,74,59,68,197,2,150,28,192,219,164,192,158,231,193,240,26,176,33,136,97,129,95,91,76,114,79,86,97,220,135,80,233,39,150,150,27,223,206,160,84,151,120,226,45,231,200,167,121,200,46,1,132,39,112,88,96,85,173,249,29,67,46,208,224,131,84,81,64,218,16,15,12,243,215,86,157,212,204,147,221,26,11,10,114,75,9,240,8,16,58,152,196,219,149,51,8,94,225,203,7,157,156,249,220,220,207,80,128,47,103,189,58,38,83,183,122,51,230,254,146,160,37,235,226,233,55,164,177,33,246,224,67,54,25,126,27,216,100,83,102,46,231,99,215,206,57,243,30,174,54,153,209,116,17,156,121,215,104,69,33,59,37,187,95,75,158,233,68,148,64,236,174,32,201,143,189,99,126,50,216,65,155,184,98,84,102,243,47,178,99,59,227,198,213,53,206,39,35,180,9,162,212,58,190,48,80,234,176,124,165,130,234,100,117,5,245,122,210,159,134,31,165,144,196,154,81,131,130,236,180,4,23,225,45,144,92,99,117,71,130,142,141,103,81,168,211,2,123,203,171,59,133,24,46,169,116,160,216,233,44,215,66,201,119,51,58,75,50,68,116,127,170,113,129,55,193,109,155,237,246,191,189,150,135,24,5,204,65,201,86,15,202,87,40,122,227,52,245,82,182,54,65,104,165,101,190,208,117,246,203,163,168,171,35,67,186,170,221,100,63,0,206,157,229,28,237,147,132,88,91,215,64,64,22,48,88,246,232,140,146,211,199,110,230,207,238,78,66,78,104,253,244,227,114,94,210,30,6,33,43,1,110,176,2,156,178,126,202,213,183,124,213,218,56,96,100,54,192,53,69,60,180,73,48,142,15,85,251,191,216,147,246,47,251,203,203,138,14,174,9,73,186,102,220,0,200,22,56,137,234,117,155,105,229,151,192,129,193,93,234,222,103,57,195,107,240,92,18,180,41,23,23,255,255,135,26,222,109,47,129,205,129,52,192,82,153,195,24,72,58,156,127,159,210,114,67,196,173,239,17,84,216,115,57,151,70,218,133,179,61,149,175,160,128,222,103,91,202,239,92,198,173,251,58,186,236,105,215,23,167,254,58,4,21,22,17,213,211,230,47,195,183,154,245,187,224,165,236,107,184,195,149,49,79,138,158,97,201,64,138,145,249,37,253,56,175,148,83,197,74,69,186,47,38,63,14,241,224,30,52,152,74,163,144,190,253,92,176,164,109,217,165,118,19,56,214,162,10,193,213,18,95,72,55,150,22,199,50,196,111,155,204,32,122,25,68,234,156,43,178,92,160,204,83,138,2,184,248,7,132,201,144,69,176,216,12,49,175,55,89,163,91,23,159,27,226,183,111,153,13,35,140,237,237,170,126,119,171,55,105,81,53,55,142,131,46,39,136,83,145,158,216,192,73,71,22,117,124,243,85,81,130,52,28,216,143,226,153,141,3,162,141,249,125,8,119,27,65,133,135,123,117,71,161,45,130,255,194,160,178,21,123,106,105,199,3,146,205,115,157,18,61,181,226,101,151,234,244,10,17,216,104,186,3,215,32,157,200,151,190,41,62,181,74,5,160,213,185,70,97,253,164,115,81,108,228,207,4,144,210,54,224,36,93,21,210,109,58,54,121,127,235,182,110,122,161,24,48,114,193,83,31,221,109,136,70,83,212,203,195,232,231,69,5,55,157,106,77,101,19,58,55,127,91,240,85,64,11,229,155,10,93,177,2,144,20,75,121,186,81,171,50,1,196,62,217,231,16,206,250,186,173,24,60,218,230,99,216,36,3,103,61,237,73,61,170,38,35,224,158,166,103,119,128,4,5,152,194,141,234,113,149,54,196,25,235,18,81,227,137,137,138,115,20,204,38,189,115,69,224,31,135,6,32,171,72,87,42,144,71,72,255,171,79,132,159,83,151,209,62,152,25,79,133,19,172,154,90,84,80,101,131,150,37,245,195,199,210,235,98,122,229,215,7,164,79,63,62,80,142,144,161,189,235,24,212,200,109,145,185,104,122,29,112,81,147,15,4,108,147,244,184,155,249,18,80,201,174,227,93,226,109,63,7,17,14,209,141,194,160,30,170,18,60,144,32,224,177,0,106,248,126,107,84,185,179,106,146,13,238,80,251,18,50,96,122,216,217,112,187,148,102,111,47,244,158,22,39,76,59,150,43,22,117,202,253,88,26,166,126,243,142,239,81,69,185,255,93,56,20,32,232,185,22,217,19,198,221,159,42,176,105,127,180,90,189,136,213,241,120,92,0,77,136,165,142,142,126,142,164,219,231,41,237,134,253,191,235,254,252,57,52,25,89,120,215,145,142,87,152,149,107,177,79,86,176,4,105,59,150,254,14,74,110,116,206,16,0,218,98,156,66,18,10,16,202,136,15,80,236,236,233,75,132,186,168,174,233,16,240,124,0,189,243,98,252,33,121,215,44,173,199,127,71,233,97,165,227,102,12,62,59,225,180,119,55,117,95,159,229,177,99,143,111,247,182,37,180,23,219,51,67,250,113,124,122,213,160,93,82,156,170,252,0,1,76,22,11,250,91,147,112,1,233,251,21,112,60,137,25,215,114,231,83,28,55,129,94,198,200,247,80,156,163,198,211,214,235,239,111,210,160,137,128,181,114,163,61,8,94,83,46,49,30,181,239,140,222,109,66,167,226,89,159,32,73,145,21,222,213,65,62,66,94,137,206,128,169,236,73,167,141,150,232,238,36,44,136,68,28,4,21,153,225,253,254,31,210,190,138,17,5,228,142,90,163,91,64,60,208,230,70,88,201,198,140,171,37,112,143,83,251,39,36,63,189,48,135,196,100,189,76,124,37,117,179,153,183,236,97,94,72,5,144,76,23,71,22,137,91,101,17,51,31,37,37,248,167,248,202,225,125,28,24,192,51,67,242,20,243,183,110,138,211,210,110,39,221,189,226,241,100,225,217,111,128,6,152,234,156,179,79,2,139,150,103,51,47,252,21,104,71,84,83,243,17,144,151,52,96,128,26,163,179,77,162,97,109,136,128,106,219,50,111,229,203,148,252,102,19,181,220,239,169,7,60,6,173,111,160,55,24,162,69,223,39,186,222,104,184,206,203,0,68,178,244,108,51,107,230,205,176,248,207,12,225,122,184,184,1,99,226,173,135,71,136,45,243,127,168,160,134,31,180,45,53,1,213,36,43,83,51,59,61,115,223,67,123,54,86,38,128,71,198,210,179,241,150,253,253,1,26,104,127,234,182,86,121,188,19,134,211,19,249,75,96,210,137,255,175,48,38,23,82,107,180,73,87,97,17,31,217,160,77,243,143,164,224,77,154,152,148,205,66,240,48,168,156,21,103,19,214,154,17,173,156,16,31,18,63,134,224,211,145,46,114,33,113,105,125,72,78,202,25,183,28,255,45,63,169,16,225,2,237,156,45,254,223,125,195,250,99,49,156,250,188,216,169,104,171,157,188,114,72,110,29,153,187,99,254,51,237,255,23,98,131,248,193,121,59,142,7,176,78,52,182,134,170,136,125,40,234,245,225,74,212,208,176,105,253,8,32,143,69,180,249,246,10,31,176,129,144,255,199,193,59,12,181,231,207,169,241,243,19,253,220,49,45,195,42,147,102,239,117,186,240,63,156,184,43,225,119,87,44,38,11,106,231,241,208,145,167,222,147,22,240,37,62,139,30,249,0,209,78,164,84,131,254,178,126,91,170,226,29,73,170,154,101,221,202,18,92,146,134,178,38,195,106,88,228,86,86,172,34,113,89,4,85,139,78,39,3,161,49,94,245,107,21,206,162,64,240,35,201,126,89,226,156,229,141,165,29,4,22,197,202,125,44,200,64,176,137,55,95,167,234,104,86,244,217,45,234,206,4,6,171,85,146,235,237,168,81,103,77,204,104,16,110,90,132,100,240,72,96,188,201,254,56,43,229,76,8,144,250,190,182,102,89,64,104,238,222,184,173,138,130,235,233,91,226,30,237,38,236,194,116,180,36,198,97,37,242,32,60,224,15,13,203,190,121,127,41,1,108,205,117,79,104,173,232,164,128,0,31,193,82,164,115,1,175,199,50,22,0,215,136,87,212,105,174,240,47,27,51,93,165,183,61,96,31,150,125,70,38,192,85,215,191,65,159,42,123,59,211,210,39,96,64,53,80,103,134,214,75,89,23,40,114,4,148,61,56,175,176,119,180,61,162,119,184,21,110,204,103,52,202,109,151,202,204,240,215,165,116,96,52,113,64,112,42,171,54,172,169,69,253,44,153,24,232,19,141,73,3,80,141,143,57,23,209,218,79,5,176,20,117,197,223,97,0,0,216,103,205,251,42,189,173,104,182,224,240,187,184,90,150,165,151,54,237,248,21,195,252,26,86,186,43,130,85,173,165,88,77,47,61,60,251,197,177,40,114,201,153,72,161,39,61,136,217,22,39,227,180,112,20,184,0,22,255,248,87,132,120,113,8,6,226,212,166,57,112,185,75,15,83,79,196,106,136,205,5,59,250,63,35,80,140,176,236,196,248,3,221,98,250,104,32,99,152,165,109,139,192,40,49,68,14,50,89,102,202,12,64,120,114,49,227,205,144,18,43,180,65,47,167,89,67,145,180,44,241,173,23,232,86,141,103,210,72,240,225,180,133,221,238,4,125,161,121,44,204,5,162,64,34,84,167,152,247,154,190,162,116,71,83,180,181,174,3,151,227,180,162,28,198,133,1,195,199,54,251,220,4,182,126,209,15,24,207,187,240,50,11,120,250,158,87,125,246,74,64,175,190,21,150,255,202,170,125,38,228,16,24,166,186,7,113,0,133,182,112,138,188,2,24,120,236,10,76,154,89,48,23,228,159,219,144,219,209,76,59,25,100,202,46,203,178,117,252,97,240,97,42,143,205,52,199,220,7,0,109,217,139,126,170,178,227,213,192,16,171,133,173,237,240,186,6,14,155,94,157,194,99,123,174,181,74,164,126,56,178,0,172,77,163,74,172,53,5,161,130,161,162,149,232,150,69,170,172,59,70,142,112,87,58,16,192,67,8,250,29,140,221,17,117,167,133,43,180,141,157,214,18,131,114,105,147,206,25,138,207,188,30,41,9,97,113,247,123,251,56,165,182,239,95,79,152,45,113,160,213,230,249,227,167,149,52,172,156,182,242,134,61,19,90,144,248,100,252,168,76,213,246,126,123,175,8,114,218,41,247,90,229,94,238,86,73,43,35,42,116,168,217,75,167,166,122,230,82,130,255,164,51,9,86,79,111,49,152,198,132,96,62,12,131,23,66,96,51,213,29,13,144,20,26,228,66,41,228,68,254,126,173,192,51,62,41,184,136,182,93,102,144,250,65,236,200,19,121,182,87,125,72,97,132,164,29,130,211,26,115,217,177,199,35,54,132,98,87,138,188,229,34,130,240,81,186,231,130,41,17,74,64,27,41,169,251,229,192,38,247,81,85,224,10,181,80,164,164,112,73,150,53,119,166,144,157,52,98,187,48,28,64,77,33,237,100,1,46,123,40,27,232,128,105,190,126,27,132,205,16,107,184,30,187,240,29,128,81,177,9,175,37,159,188,53,109,59,15,33,102,39,182,31,73,163,176,14,150,178,216,231,41,152,253,100,240,46,106,181,137,111,240,101,204,74,57,134,179,49,230,134,124,152,70,64,166,43,65,203,80,53,157,166,39,138,142,243,74,145,217,9,194,93,128,67,93,129,161,161,254,211,189,239,205,32,171,253,118,141,204,240,183,222,146,198,220,187,58,201,238,218,179,206,89,183,40,198,33,53,38,40,144,216,247,161,189,216,173,9,22,72,148,174,45,3,127,35,125,111,140,15,207,119,246,38,244,195,69,85,106,121,28,241,125,124,103,116,108,152,84,133,165,68,92,5,189,160,223,125,159,69,84,91,214,24,52,36,207,180,152,8,156,70,209,194,220,165,138,212,192,246,132,124,186,64,218,179,23,131,210,117,7,15,197,250,249,187,104,74,19,195,232,168,66,171,125,133,252,89,123,236,67,152,150,187,82,161,241,29,160,206,15,254,101,201,34,79,182,6,88,237,204,67,3,24,199,64,58,22,71,118,31,80,235,148,111,111,74,248,229,15,0,160,215,0,121,227,15,243,58,122,251,203,236,223,102,217,235,105,113,239,209,206,227,198,166,116,250,85,48,71,14,78,216,2,167,129,129,240,167,56,89,118,161,125,49,228,56,221,13,219,207,36,68,253,27,45,219,117,151,229,111,247,206,97,173,132,8,74,182,16,125,54,238,31,46,244,50,250,3,216,182,42,120,67,61,39,106,101,23,248,21,80,151,115,41,105,95,47,32,90,53,3,164,31,12,113,105,26,135,101,186,43,191,173,143,177,4,75,109,96,7,121,5,231,218,250,45,96,254,193,146,225,251,238,21,240,27,207,43,187,7,61,254,195,234,210,152,46,241,186,188,216,234,82,179,109,61,190,139,211,58,36,74,149,107,249,150,196,71,226,167,232,40,42,19,152,17,194,16,94,5,11,57,37,43,99,98,248,81,211,60,69,192,80,94,225,241,197,53,76,100,1,166,253,132,17,3,72,232,72,214,60,18,151,159,15,167,78,27,76,142,22,21,129,121,10,185,35,246,49,165,218,73,182,236,65,1,175,236,230,71,209,189,163,164,179,194,209,86,6,180,219,147,94,15,212,246,83,21,183,250,40,230,78,222,159,74,94,13,20,247,51,90,218,253,125,50,81,72,93,1,200,50,199,223,192,197,223,38,208,98,122,118,7,82,178,154,193,50,199,199,7,184,231,120,39,2,232,41,182,32,75,56,236,176,5,0,113,190,13,109,1,175,212,249,89,21,130,204,162,228,119,244,190,87,252,151,13,40,209,103,93,95,199,103,141,133,122,94,189,161,222,26,229,214,114,137,110,97,84,81,251,213,80,122,215,144,113,154,105,12,130,191,24,0,226,159,46,86,119,142,104,231,72,118,224,91,195,94,179,212,168,32,243,2,25,219,4,197,34,167,252,198,18,155,87,88,62,165,118,253,176,96,152,186,128,214,140,226,59,11,113,104,102,96,136,126,9,13,140,165,46,116,134,52,249,105,131,168,226,83,93,216,194,247,236,251,159,42,118,243,93,85,175,120,106,134,75,146,217,187,183,49,138,190,5,189,3,203,106,166,110,104,108,70,111,165,41,203,34,212,254,32,10,2,238,30,243,126,47,119,175,63,107,73,75,131,105,17,54,253,158,128,179,196,198,64,151,178,55,47,159,191,106,78,234,208,198,108,42,131,2,33,44,121,43,48,137,107,252,205,15,84,242,200,169,148,239,199,117,248,6,151,51,83,45,149,57,75,160,202,27,122,235,14,50,90,135,90,94,140,171,241,123,236,90,200,243,190,6,111,165,246,139,34,141,151,172,38,34,66,201,218,83,110,52,12,146,6,26,248,102,120,174,193,25,147,171,152,87,174,79,55,208,166,73,111,90,214,25,117,239,102,226,213,182,128,93,49,129,174,3,2,180,9,250,166,8,32,141,187,26,55,157,229,144,64,195,91,154,133,56,176,6,198,60,119,115,232,70,213,143,59,250,97,136,50,75,125,198,19,151,141,168,48,163,47,67,211,114,119,103,69,9,119,244,236,196,164,248,228,69,215,205,245,16,57,177,244,43,224,109,172,45,14,5,161,195,63,81,38,117,19,125,248,179,103,199,168,84,151,192,55,216,72,96,43,117,199,103,51,202,42,177,40,169,84,157,153,173,244,141,108,142,38,188,53,35,151,221,147,12,148,111,151,129,212,37,253,142,191,152,21,241,153,150,30,71,95,49,124,83,150,47,109,169,199,96,70,141,167,74,79,11,152,159,93,215,159,185,141,249,140,114,217,75,87,133,177,114,114,27,32,86,10,246,20,157,127,160,164,227,79,194,177,107,49,142,179,84,144,135,178,81,30,7,228,120,116,11,103,210,83,15,94,77,40,116,144,27,125,81,192,231,217,112,4,184,78,6,144,65,184,221,84,114,52,150,241,217,130,114,219,252,15,34,244,209,76,178,193,231,229,38,137,147,0,147,242,150,26,33,32,28,132,60,63,134,221,9,214,135,97,120,217,109,78,130,199,253,153,215,234,19,186,201,199,169,20,132,151,74,179,54,65,25,171,126,126,88,23,247,222,39,52,65,85,45,245,229,214,38,98,14,0,10,216,42,17,230,34,91,84,144,209,31,186,211,140,175,188,80,202,99,174,124,88,40,32,214,235,133,253,145,179,186,102,42,135,61,67,235,163,133,41,35,25,168,87,141,24,186,210,233,150,19,220,120,81,123,169,245,18,197,27,207,176,15,197,115,139,69,152,82,211,148,77,184,232,173,29,253,46,123,173,245,217,54,231,135,218,236,101,196,45,109,136,189,206,68,215,214,77,251,43,39,224,144,62,135,50,114,247,67,110,247,38,143,220,5,1,173,142,88,7,149,152,225,194,10,114,152,121,105,239,242,249,117,29,172,2,39,98,218,33,31,69,93,11,210,222,132,40,251,162,173,144,13,165,165,242,181,202,215,89,196,228,253,39,70,73,153,144,63,184,211,2,204,107,51,166,197,173,14,15,96,66,141,11,12,244,148,50,16,214,9,8,52,6,165,105,91,184,10,10,62,135,250,200,159,69,227,229,86,98,229,73,27,200,217,108,233,211,81,90,93,45,50,50,149,19,35,23,116,202,113,21,211,33,217,140,128,86,228,185,130,140,104,87,180,174,131,213,254,48,90,67,239,159,204,139,229,42,236,142,82,151,187,165,11,12,150,53,56,10,76,97,213,117,217,51,242,133,135,229,78,117,95,26,31,69,32,138,147,70,226,136,42,0,8,199,224,233,35,206,48,207,61,99,52,101,204,118,143,245,236,120,33,226,57,223,53,32,255,6,236,127,223,89,137,99,84,204,80,106,20,237,64,149,193,65,7,41,202,120,56,115,112,137,35,254,243,28,47,4,229,33,115,177,48,219,231,48,63,139,95,214,209,6,170,197,116,222,104,88,254,141,16,48,222,226,9,47,121,65,188,142,38,129,229,60,122,25,131,229,78,249,211,139,93,199,181,248,231,247,38,161,131,223,146,216,88,123,189,77,186,220,2,185,53,173,226,101,153,213,103,171,140,207,44,51,120,168,36,182,213,176,87,166,170,61,250,49,139,249,215,135,168,170,59,95,118,142,249,166,177,121,94,175,159,219,228,219,117,28,222,43,180,225,108,140,7,25,5,94,45,171,5,65,137,255,40,123,190,89,181,94,76,172,91,161,197,240,85,79,172,28,47,57,205,233,102,137,143,28,155,20,20,157,41,148,175,43,167,5,82,171,148,109,247,237,236,176,176,124,1,158,189,93,168,51,115,231,208,228,55,164,123,212,27,25,190,38,1,120,25,153,91,236,95,116,67,210,173,224,156,220,91,207,120,91,114,212,191,71,198,205,146,136,65,91,33,204,192,154,155,243,71,11,55,239,100,89,204,247,199,59,120,22,68,109,137,194,203,81,61,247,11,226,242,210,155,195,209,1,193,108,163,178,20,22,170,30,148,214,80,229,153,91,103,246,237,10,245,110,211,150,205,98,239,92,94,71,206,91,253,204,90,157,216,152,35,148,167,8,201,167,24,239,191,158,102,23,131,159,64,99,81,159,58,193,185,68,1,28,24,38,198,132,80,191,19,122,235,99,129,100,49,253,29,52,194,32,108,106,166,243,179,53,189,96,59,73,241,61,32,223,84,218,118,59,32,64,9,98,239,207,219,101,38,106,54,148,148,25,5,50,107,106,152,242,117,192,102,56,184,19,232,133,157,243,182,52,144,217,94,101,153,221,88,157,52,224,159,93,159,71,2,115,200,230,116,202,177,236,75,20,176,16,39,147,24,150,195,21,251,77,57,185,113,216,168,48,127,164,56,104,92,23,85,141,159,93,53,192,103,163,130,24,85,85,160,61,246,23,185,196,18,158,228,129,148,126,206,52,198,191,182,12,98,112,31,56,160,62,208,196,234,1,56,249,23,61,115,25,164,254,151,45,11,124,107,53,151,131,221,52,249,185,90,5,4,129,177,134,168,239,37,50,111,225,178,53,251,9,5,87,32,111,75,239,38,160,33,50,128,211,5,250,31,61,177,31,115,182,221,118,33,225,75,165,5,43,89,152,62,217,185,246,122,194,98,47,193,42,74,46,144,111,16,231,76,88,151,7,93,68,144,237,82,117,206,167,239,6,137,55,125,14,88,92,201,143,148,62,216,55,224,150,178,38,77,42,167,163,233,124,131,220,55,50,219,117,225,244,220,233,124,27,133,246,213,86,54,152,29,92,98,226,98,54,110,144,186,41,161,225,72,199,30,105,121,160,56,141,23,100,40,88,208,169,32,196,122,95,231,57,244,199,120,13,232,165,250,170,24,34,231,23,205,33,18,214,128,56,165,14,48,104,223,133,183,73,58,100,111,112,115,239,70,81,81,38,94,88,232,164,212,242,0,59,114,36,133,89,252,41,204,37,193,144,244,255,242,124,20,131,112,126,131,187,205,71,229,86,90,197,199,245,45,120,190,56,223,164,63,177,75,188,238,180,176,137,182,95,221,29,158,104,4,224,38,183,94,172,67,44,62,168,237,218,85,159,58,25,168,173,108,204,228,81,18,145,207,176,19,10,212,78,133,108,169,178,117,11,19,155,152,200,117,243,99,143,126,93,75,167,4,103,249,245,27,30,184,78,162,35,174,200,4,59,119,138,195,58,130,59,179,147,48,207,134,201,207,31,90,145,168,212,195,79,220,16,253,80,24,42,159,61,178,241,81,140,246,198,225,166,94,74,63,254,3,218,93,2,74,194,239,192,68,55,75,132,51,79,200,162,72,133,34,87,86,7,157,235,37,94,78,191,150,81,213,162,147,20,232,243,173,36,1,244,91,3,192,10,224,194,229,74,147,19,192,165,168,153,5,127,230,113,185,206,127,146,80,114,246,179,16,31,90,0,242,254,82,189,36,246,211,7,118,168,33,154,220,184,107,101,40,150,196,194,242,253,216,72,132,210,147,230,224,198,34,75,25,74,233,205,159,168,6,197,50,217,127,251,94,27,0,89,55,171,138,10,197,251,46,127,84,139,97,212,131,44,89,5,181,154,11,223,2,106,249,29,222,72,44,89,57,56,8,138,102,140,86,159,219,77,239,32,203,126,142,214,192,72,16,119,161,71,155,250,58,115,189,112,51,213,249,25,85,78,170,171,102,164,103,133,109,37,229,130,167,116,64,21,234,76,246,89,206,141,235,89,223,141,56,47,168,166,97,190,26,197,70,97,133,200,148,53,45,183,39,129,38,122,174,116,58,75,115,221,204,101,52,24,94,177,14,237,2,172,234,210,8,208,25,77,235,113,24,108,216,242,184,180,255,173,101,240,51,246,200,240,13,156,209,93,60,66,170,252,82,230,13,215,146,117,255,210,7,34,122,10,106,156,176,21,68,222,248,33,83,152,206,191,60,18,158,149,114,74,41,60,203,244,210,249,189,212,25,25,75,131,95,76,207,254,188,23,124,249,162,255,170,137,0,81,97,181,221,127,2,120,240,234,80,28,115,105,158,136,89,77,135,103,255,251,8,186,242,63,176,164,122,8,11,128,19,58,243,8,212,252,204,84,170,108,158,179,247,0,254,32,87,139,213,136,45,180,92,145,67,92,246,247,205,97,103,87,101,163,137,0,61,23,230,147,218,153,102,235,104,17,24,246,70,190,79,179,238,178,41,56,128,115,241,148,114,229,173,144,63,54,151,123,191,45,145,222,89,230,29,59,34,163,123,120,56,34,137,149,161,32,221,255,87,39,50,57,112,84,159,209,51,170,143,167,190,117,145,202,12,127,248,132,142,52,118,154,247,22,242,179,161,240,146,155,7,176,79,18,1,228,242,227,81,34,121,92,236,105,176,207,233,51,86,159,119,70,173,14,42,103,31,241,149,157,98,49,61,96,106,94,142,12,146,88,63,16,173,84,14,216,170,188,7,119,188,94,156,24,78,218,117,39,252,216,201,136,241,118,24,231,164,15,9,211,193,68,14,9,140,214,99,95,235,172,219,136,83,12,95,75,88,48,152,236,153,95,137,236,38,125,35,176,220,87,52,101,106,40,172,224,140,105,118,201,227,143,43,59,162,152,247,197,72,70,232,183,21,160,2,64,169,41,69,166,102,52,189,217,130,19,196,230,34,133,35,31,17,193,45,252,112,79,79,223,99,168,154,14,19,74,179,41,246,27,199,128,101,54,80,252,173,165,241,80,26,204,142,255,57,94,25,56,246,22,133,229,144,110,212,118,251,36,49,81,254,183,116,222,99,70,181,22,74,96,199,161,124,176,7,199,9,56,128,64,200,185,222,37,225,144,156,152,22,99,76,208,43,99,207,169,146,220,182,136,30,96,166,118,49,125,40,132,106,49,212,158,91,55,84,208,213,75,63,190,113,71,83,98,109,21,176,11,204,253,157,79,106,111,232,239,253,187,98,141,32,52,39,209,183,100,176,183,32,232,137,209,189,13,67,230,44,99,233,235,31,211,62,149,120,185,114,79,123,8,153,151,112,255,65,154,228,16,226,177,21,18,10,146,172,134,181,123,4,253,122,188,229,98,89,112,147,19,145,108,246,176,210,201,128,231,96,230,39,140,7,175,246,144,253,114,34,223,14,48,134,160,78,112,135,138,197,142,208,213,221,156,197,198,131,42,169,203,191,140,36,205,131,59,11,239,147,205,235,193,132,59,199,198,42,204,244,120,24,172,221,253,85,141,118,110,76,153,91,146,222,142,200,251,52,172,145,250,47,123,86,49,253,220,27,77,170,51,36,179,148,26,32,251,162,197,246,163,248,65,123,233,68,194,166,153,206,118,238,22,134,49,13,218,176,11,183,124,197,148,169,251,224,80,11,209,166,233,229,19,220,114,244,144,246,17,131,119,108,78,6,26,238,121,82,13,57,179,139,149,164,255,235,181,20,240,76,155,71,61,89,192,100,16,244,93,71,199,139,70,203,107,44,233,154,66,40,255,1,15,20,206,89,244,23,68,123,164,177,175,187,170,150,195,150,44,96,99,142,169,220,220,197,235,124,72,198,60,112,180,196,35,190,154,107,29,177,10,243,111,210,61,157,156,223,255,101,5,210,27,224,15,23,138,119,65,201,139,134,84,70,122,22,204,153,5,193,108,54,149,173,173,37,200,81,229,93,72,7,45,14,51,177,85,166,96,189,55,43,70,88,172,251,17,221,163,81,62,196,216,14,31,82,46,38,65,125,42,32,4,9,145,100,31,102,106,231,86,31,167,246,39,11,28,118,34,92,179,80,65,191,115,43,247,211,118,115,124,156,122,145,222,177,73,161,7,117,51,20,29,178,100,26,127,202,208,177,209,121,101,140,194,20,229,139,123,55,186,209,31,33,39,115,64,97,128,152,60,147,70,35,97,4,156,87,181,58,244,132,109,115,229,91,215,10,28,25,21,57,163,234,21,101,81,18,220,78,130,105,85,41,164,78,228,156,201,182,234,93,221,241,194,212,66,84,4,11,81,116,94,234,37,200,8,214,228,253,58,205,250,62,168,189,1,46,223,0,158,154,29,127,247,188,25,193,165,228,117,234,121,149,167,254,11,3,15,12,91,42,46,11,240,230,134,120,108,46,58,63,23,230,140,113,173,206,94,55,63,20,187,32,255,142,32,192,135,161,231,95,115,204,50,125,129,245,15,153,89,124,35,87,200,91,78,68,126,100,158,103,224,232,192,132,174,34,19,19,48,139,182,247,255,70,88,227,139,253,31,10,222,62,188,140,85,169,143,143,14,29,108,159,46,98,211,30,129,63,149,77,230,246,61,181,103,153,124,242,214,63,70,78,193,78,208,159,94,20,59,30,81,88,112,124,123,183,101,239,217,86,232,137,59,250,5,110,107,71,27,31,15,33,62,200,161,218,153,82,134,5,7,141,180,7,152,169,23,182,33,150,252,223,90,209,54,177,15,50,19,8,253,37,226,84,143,33,164,230,38,215,102,42,156,198,36,35,149,175,75,79,102,252,69,215,7,165,103,252,189,221,18,204,32,86,110,22,47,74,38,247,11,126,5,145,242,247,20,9,190,177,121,79,16,110,73,41,45,141,3,247,35,3,252,191,45,7,156,127,115,198,74,194,5,25,124,110,61,109,115,151,84,72,182,140,170,23,217,123,133,98,143,18,53,128,55,78,61,89,152,214,253,63,133,196,183,215,107,107,158,245,129,15,153,169,246,158,65,172,8,47,226,30,126,10,64,163,175,108,218,130,19,89,235,34,206,150,176,199,6,140,234,201,165,130,107,208,64,112,36,44,115,250,199,236,204,60,127,43,124,225,163,49,76,103,210,254,126,180,82,44,230,68,93,12,246,201,186,72,190,172,76,128,42,173,0,221,120,14,150,19,197,121,163,71,111,214,183,143,24,187,70,13,255,228,250,134,173,209,183,166,208,21,225,94,109,145,98,70,255,76,151,190,150,183,152,248,238,224,187,111,4,2,111,236,73,135,133,67,34,193,94,52,159,42,187,59,38,75,152,72,134,112,236,191,233,150,43,156,14,167,70,226,7,114,200,31,140,164,33,84,232,169,15,96,172,175,192,57,229,71,227,101,139,17,90,45,154,32,255,204,159,141,200,159,147,45,152,135,128,51,11,78,181,154,83,92,144,157,134,244,234,140,201,95,218,104,165,146,35,28,223,139,111,128,149,30,162,119,191,217,136,196,219,138,212,22,168,182,19,118,34,168,68,234,104,231,59,166,128,52,254,212,215,218,117,66,31,249,88,61,78,33,130,242,94,66,17,169,102,100,130,251,1,125,169,71,110,165,239,246,162,251,220,185,184,20,76,133,171,122,57,219,218,181,169,220,38,166,27,206,53,166,180,135,172,64,7,187,131,182,110,67,34,191,25,145,197,184,217,30,140,72,15,212,194,123,34,239,194,64,110,117,35,199,82,17,157,252,230,226,228,44,151,158,81,101,191,59,18,175,143,139,235,12,185,50,15,106,29,143,82,247,211,52,208,35,153,64,11,50,37,13,38,232,128,45,104,62,240,201,122,137,83,140,250,178,64,142,202,168,54,119,221,215,71,166,35,108,71,223,239,99,153,12,8,134,64,200,182,235,107,96,111,231,153,200,254,189,247,49,93,127,4,200,77,43,160,120,224,252,243,224,46,190,166,143,82,46,207,86,235,116,203,190,88,18,55,121,70,227,215,107,69,58,245,221,133,33,73,230,34,36,254,49,127,129,180,253,175,209,180,54,94,124,96,104,97,243,225,38,248,166,230,189,233,78,38,61,122,43,51,76,9,219,127,1,239,79,151,48,213,26,208,118,80,108,178,180,167,38,224,5,87,106,12,73,252,109,195,190,244,1,237,106,212,236,116,74,192,255,121,219,152,67,18,77,38,21,51,27,121,200,196,0,84,219,179,46,124,54,85,12,179,49,241,46,197,14,33,28,79,227,246,94,112,66,187,209,230,116,161,40,15,78,57,156,110,138,178,73,41,255,178,62,43,236,180,171,248,21,243,240,13,110,71,67,79,176,57,76,207,194,20,219,223,36,60,83,50,200,87,245,137,235,132,89,144,67,4,174,55,221,14,212,138,175,187,209,186,54,80,178,238,243,36,9,199,108,128,111,120,61,208,105,53,44,233,236,78,63,226,71,197,238,242,101,100,227,70,160,209,41,198,56,65,115,138,237,132,126,95,23,46,122,98,177,164,159,251,98,212,145,111,203,95,36,21,53,163,88,57,51,139,255,60,181,38,187,107,75,128,165,215,232,130,56,103,173,192,192,119,72,104,142,246,79,232,200,17,207,225,61,55,106,74,61,126,180,229,233,187,223,190,82,11,232,15,84,52,13,98,154,199,134,191,227,132,219,235,17,230,249,92,249,34,165,54,132,101,234,209,220,66,6,69,181,50,132,160,155,246,171,5,167,56,49,27,175,90,222,36,13,217,116,128,9,151,3,203,43,43,40,205,132,14,248,28,88,180,107,146,95,19,175,0,109,41,170,148,148,54,179,0,71,101,59,99,221,143,205,42,59,156,112,136,31,59,18,231,136,191,41,46,122,77,101,152,172,123,108,116,111,53,229,4,163,218,156,39,171,198,100,223,236,90,205,126,143,72,67,138,159,241,118,154,239,154,219,34,182,123,33,163,113,46,15,249,238,36,50,215,132,241,226,207,196,181,96,162,212,88,224,190,81,179,12,136,146,122,238,83,129,26,72,105,125,20,146,253,67,112,232,12,188,96,52,161,160,121,241,50,77,49,218,20,78,169,246,196,95,213,12,11,243,170,71,1,244,78,233,115,143,34,201,250,23,100,9,97,17,4,211,193,128,42,106,170,138,9,75,28,208,247,157,32,4,210,106,87,15,97,167,209,22,160,123,52,183,148,194,21,14,53,212,119,43,76,147,154,56,43,175,79,109,103,68,93,115,95,230,242,89,230,162,136,47,37,79,109,220,24,217,83,40,241,45,113,250,138,133,115,120,72,115,222,65,36,226,44,1,172,128,192,152,113,44,162,139,24,194,114,139,90,162,31,228,198,129,96,97,224,87,232,183,43,193,104,251,129,67,148,240,227,100,4,27,202,89,241,226,221,189,142,102,74,1,234,197,88,247,95,217,142,161,58,118,124,174,252,162,242,248,126,19,199,138,191,202,209,59,204,127,100,65,187,50,108,197,107,107,205,55,228,48,246,168,68,28,74,186,102,54,116,29,188,57,221,206,122,202,240,151,15,23,162,146,91,12,88,51,69,3,110,205,52,5,186,49,46,171,126,221,23,30,236,45,162,17,198,211,238,177,147,106,5,203,206,78,143,1,167,153,96,15,225,28,219,223,209,68,221,218,102,32,19,138,90,130,254,63,73,240,165,99,150,83,198,65,210,22,92,216,204,186,182,213,249,35,2,80,190,138,101,47,225,210,232,29,85,90,174,228,82,244,173,189,193,47,20,238,93,189,172,27,25,87,244,243,224,87,201,186,153,42,69,160,195,77,180,136,128,231,197,161,163,94,0,191,87,57,125,254,155,170,223,110,165,95,181,188,82,153,240,68,118,58,137,253,184,248,35,170,207,20,197,246,93,21,36,48,195,147,75,92,94,166,34,77,198,225,189,122,91,111,136,32,138,146,132,33,113,35,32,184,97,10,255,132,98,61,203,100,65,30,160,150,30,85,22,8,32,101,187,142,240,176,3,67,219,207,113,202,242,213,177,61,155,141,225,69,7,10,3,184,65,132,69,241,149,214,97,91,168,150,187,136,18,190,15,66,134,232,239,202,169,247,10,160,246,157,238,77,41,185,221,165,157,108,94,145,231,229,169,101,1,167,15,161,20,158,211,139,204,107,228,206,211,185,65,246,158,167,12,107,190,45,182,28,192,44,106,148,62,159,222,82,10,227,237,251,3,151,152,139,76,162,183,169,202,107,181,200,129,195,124,71,208,135,234,26,203,154,53,208,137,99,150,100,142,114,50,153,183,126,133,1,253,9,202,235,65,46,106,126,8,5,105,93,53,17,35,209,62,117,114,152,57,29,66,71,127,2,130,103,158,7,17,86,195,64,229,219,75,195,212,33,209,50,154,59,27,177,135,24,163,107,219,137,197,220,7,153,96,131,0,65,187,83,25,18,15,100,245,27,6,174,119,25,182,124,115,158,7,84,182,105,34,75,231,222,190,48,233,221,49,119,79,153,174,200,28,223,87,37,72,254,237,189,199,23,239,255,69,27,152,251,104,233,142,231,80,48,149,197,234,170,200,149,73,120,9,20,212,128,69,99,144,23,22,83,89,207,47,19,17,198,156,214,226,55,130,85,146,54,5,58,224,214,6,27,36,31,164,126,182,225,53,4,52,100,11,28,220,125,41,101,102,215,188,97,6,55,113,252,140,78,81,115,58,203,129,115,132,109,206,21,68,78,20,128,95,62,34,72,211,75,41,78,234,223,115,175,57,229,107,227,179,9,162,15,86,211,207,126,44,120,162,65,99,15,187,57,91,18,41,138,119,15,37,90,138,187,40,13,121,164,30,26,160,7,116,143,9,149,10,228,215,85,75,134,113,241,72,248,12,116,160,177,187,166,188,208,252,178,182,169,220,121,139,203,135,116,198,224,193,215,214,189,110,168,68,129,130,192,8,226,15,122,181,16,37,227,17,156,38,246,249,4,89,193,12,237,32,109,66,52,139,50,235,10,231,210,19,204,191,161,192,238,27,142,203,62,146,194,119,135,132,70,245,214,127,209,179,254,19,43,72,110,124,118,71,34,142,134,163,182,130,140,131,160,56,194,13,10,6,8,136,131,171,206,237,108,163,127,8,17,208,116,17,165,125,236,166,45,180,115,123,110,117,255,84,33,201,176,66,60,220,2,92,128,59,50,147,27,232,7,251,48,118,128,215,225,182,113,163,1,165,184,212,132,246,28,57,13,84,140,97,222,230,172,120,254,160,216,70,239,215,0,111,160,68,51,0,31,109,79,49,38,221,94,95,37,226,200,239,75,160,227,1,122,27,49,244,122,133,67,125,60,12,216,60,89,219,92,146,252,169,205,31,71,112,119,174,142,76,205,10,173,28,31,26,119,222,159,151,151,214,150,124,197,51,174,17,3,58,240,120,130,175,51,87,155,106,76,197,143,86,226,95,45,72,196,34,230,99,248,121,236,163,207,67,132,152,165,42,252,107,111,171,10,114,221,71,94,190,87,197,251,236,116,86,60,82,253,64,166,236,178,150,126,252,230,179,186,45,52,123,29,16,175,237,157,13,213,215,69,153,217,233,51,38,227,186,80,200,188,65,110,196,78,3,202,66,175,161,253,111,249,120,23,44,176,170,211,138,243,128,128,115,108,85,27,23,107,91,1,212,31,154,136,228,166,30,96,59,92,34,162,61,242,225,232,47,195,154,45,144,74,125,246,69,128,166,229,187,39,196,152,5,66,133,189,18,245,235,31,214,153,14,205,11,130,1,238,167,83,107,14,41,235,8,139,62,37,74,87,110,189,142,226,150,1,219,52,58,115,150,62,55,66,239,30,11,157,138,57,159,200,148,184,237,250,169,248,88,159,137,188,98,30,50,189,59,15,225,149,129,184,102,146,114,254,181,178,143,54,171,186,63,219,29,83,52,76,222,208,189,242,11,81,188,87,249,54,213,162,246,147,7,72,54,22,48,119,146,108,131,16,194,137,175,45,132,109,33,243,243,40,190,135,54,116,177,29,228,193,151,91,207,114,183,37,198,58,44,53,196,42,118,27,144,95,155,137,80,255,233,76,228,204,81,135,24,99,82,230,130,134,134,90,185,64,21,78,113,200,124,44,66,8,202,250,219,158,245,90,117,100,130,99,79,193,113,76,66,140,147,91,76,194,35,42,183,235,58,162,251,48,190,103,86,96,173,72,202,179,222,118,203,182,225,42,46,211,245,250,204,238,192,46,2,210,178,141,212,84,160,233,228,60,100,58,151,244,252,138,108,189,119,187,104,222,9,36,11,182,33,204,41,164,233,176,152,233,86,233,50,206,99,64,128,110,66,233,201,123,179,225,189,88,55,210,152,178,238,149,204,213,200,212,190,228,170,205,255,165,46,209,51,91,74,229,36,181,120,52,6,82,169,229,225,218,231,110,222,218,6,179,193,106,30,34,243,244,157,149,112,198,254,119,89,250,217,97,62,28,209,188,203,80,211,129,242,222,66,129,254,133,112,29,113,174,62,6,239,237,224,23,116,214,189,215,75,239,171,17,204,68,178,19,31,37,201,108,153,71,126,166,217,28,201,87,186,193,62,200,110,44,41,74,172,66,60,174,120,134,18,85,137,113,240,138,170,198,225,97,115,26,202,243,51,96,31,18,185,179,52,52,98,63,170,11,216,247,18,9,35,203,107,220,12,6,21,178,236,232,102,112,57,211,73,9,28,24,100,146,157,25,199,182,169,71,71,6,60,175,82,210,8,190,110,18,136,70,15,43,13,60,52,12,43,123,111,248,2,36,45,160,215,73,52,54,36,80,105,210,238,113,115,116,84,251,91,72,109,192,195,188,108,51,89,2,189,86,142,28,210,69,246,138,253,85,224,49,223,6,47,125,40,72,173,56,214,70,132,134,51,244,168,101,112,151,126,77,102,143,239,4,13,116,106,10,103,119,126,65,6,31,18,107,68,76,241,127,130,133,186,61,250,68,253,189,150,134,117,83,51,83,25,187,118,78,134,35,123,184,148,245,53,68,14,88,131,0,68,159,141,48,76,196,130,198,34,56,19,203,64,75,87,26,133,28,73,19,242,167,183,2,251,172,114,9,7,155,151,79,86,68,141,54,101,212,74,210,65,219,237,175,83,252,71,245,207,108,46,196,105,180,46,85,217,5,128,221,226,157,62,176,224,25,140,26,228,142,51,187,96,116,42,92,18,197,211,133,4,0,207,161,141,187,60,8,215,220,174,187,41,153,27,83,242,133,205,30,135,7,207,178,168,111,3,85,173,149,137,68,187,204,184,237,209,59,41,154,36,35,7,212,199,183,241,25,178,86,195,41,137,201,81,164,246,218,251,180,218,161,189,193,147,17,147,15,78,69,23,170,86,93,28,58,170,81,208,143,20,240,63,182,158,203,197,94,135,254,11,135,124,183,89,193,71,88,184,98,208,164,134,197,140,75,234,159,83,20,177,109,123,195,118,229,245,116,207,220,6,11,187,253,37,198,220,195,29,176,38,46,67,200,232,90,245,23,105,165,133,57,29,208,185,232,69,180,3,5,19,111,91,226,98,197,90,102,20,243,203,137,88,156,217,18,24,141,253,17,194,150,75,120,212,232,5,187,191,80,176,71,27,94,71,149,230,108,103,17,129,248,166,186,196,171,152,249,136,146,130,38,204,223,106,175,46,105,241,113,125,212,159,243,233,110,229,177,187,141,186,157,99,212,232,218,25,58,4,212,122,110,11,236,187,184,12,168,127,135,212,37,81,184,79,102,171,143,151,189,158,113,56,80,94,110,58,223,118,37,73,53,158,134,151,251,250,216,143,88,233,8,206,211,238,115,195,53,186,238,140,128,150,50,225,14,236,49,195,224,75,85,229,24,20,244,72,136,144,15,96,152,6,156,158,133,144,200,229,50,186,234,205,77,101,31,5,147,136,55,31,158,100,141,179,213,225,15,161,176,225,156,40,169,60,57,227,45,170,44,97,107,83,178,31,102,192,84,212,43,159,32,188,252,47,248,53,6,68,8,126,187,27,46,133,214,4,199,153,29,177,123,35,170,100,66,253,178,46,37,206,97,62,17,208,98,178,195,223,64,76,251,94,132,241,102,36,130,182,53,98,94,253,122,211,197,204,144,195,101,203,40,158,215,192,102,44,87,233,61,81,147,158,79,117,222,27,26,219,168,15,59,142,65,113,172,49,253,190,191,188,12,59,244,226,238,7,59,116,34,120,56,20,118,83,59,78,142,79,43,150,41,207,228,35,234,182,14,86,50,120,254,31,74,82,5,29,39,173,104,87,10,249,237,158,29,211,250,239,50,64,90,200,107,209,100,26,135,182,38,139,177,27,64,6,87,21,235,204,230,235,222,248,48,156,212,204,138,22,36,123,3,40,93,25,200,55,162,51,116,3,140,58,246,81,78,59,89,103,138,23,220,89,171,48,48,203,181,80,163,171,109,173,17,34,188,238,42,205,32,106,18,122,80,8,247,127,26,32,148,141,138,226,57,27,129,234,74,40,235,202,6,106,127,1,11,117,117,236,240,123,227,139,185,241,205,42,57,186,237,83,21,90,3,25,88,42,109,224,140,238,11,177,108,46,111,28,229,139,95,217,72,101,173,235,131,28,2,85,51,19,52,105,218,235,176,84,57,140,165,80,238,93,92,6,47,138,188,132,100,36,219,223,236,201,112,201,190,0,20,146,68,95,16,147,1,52,108,54,185,188,154,104,247,173,127,160,214,230,207,56,112,98,105,62,42,66,97,101,47,220,193,114,23,202,61,21,118,64,16,191,112,119,123,20,117,173,202,70,39,239,112,202,66,142,163,211,106,89,2,97,150,55,78,226,111,190,170,144,53,195,72,96,89,229,178,153,130,164,161,86,154,154,21,95,120,12,31,122,50,142,245,189,124,17,218,35,201,75,20,203,234,97,11,70,151,3,185,169,71,243,91,56,248,117,103,8,162,90,14,193,33,124,194,169,48,150,40,80,127,37,151,74,195,221,99,145,74,172,228,150,120,147,204,160,67,110,187,30,236,197,101,7,127,128,115,7,243,235,20,66,101,40,114,136,254,206,220,67,96,231,89,65,202,234,82,8,131,187,238,220,213,142,223,77,25,167,69,68,87,110,101,200,142,51,26,234,143,164,214,134,215,222,141,23,42,75,147,88,211,199,154,201,24,72,202,13,136,234,25,52,120,254,136,185,193,163,187,133,84,93,81,133,177,73,126,136,46,251,136,144,180,33,34,18,230,128,47,79,79,106,150,8,58,160,248,106,132,183,215,17,146,173,177,243,32,65,1,175,14,45,235,55,127,69,29,175,177,184,199,168,231,173,143,212,218,44,28,243,157,87,243,247,193,142,155,49,191,221,140,235,246,53,125,204,139,60,232,18,220,63,106,61,252,172,154,140,47,208,189,55,163,20,44,108,250,50,252,255,204,45,52,2,76,66,64,241,107,21,163,134,187,242,247,136,203,1,7,118,226,244,67,198,15,238,194,74,9,230,186,185,49,162,49,71,168,31,130,160,103,223,244,225,108,133,142,123,181,164,114,112,172,100,229,165,150,250,57,212,15,63,204,70,163,4,98,111,152,45,37,45,245,228,45,244,111,124,250,163,197,120,243,232,117,56,154,191,145,196,141,125,8,55,90,132,216,85,224,174,60,253,201,63,198,114,202,235,236,103,174,176,192,65,93,161,74,226,65,222,241,126,119,113,174,16,71,68,19,253,160,250,79,117,231,129,159,61,132,104,164,251,78,110,48,246,12,36,172,100,111,152,87,36,40,95,115,60,227,74,123,204,149,244,119,65,162,114,102,121,19,155,249,117,248,51,151,33,42,115,199,237,144,43,180,51,121,129,23,83,127,226,56,9,32,222,44,201,44,21,7,249,122,183,224,239,85,204,10,181,91,19,103,103,133,205,12,229,38,97,31,108,141,82,255,186,32,185,59,95,66,45,15,41,179,36,56,178,53,39,230,128,252,12,104,165,98,132,4,223,238,44,36,222,188,218,52,250,146,212,148,237,85,68,175,72,79,155,38,36,230,62,122,67,208,138,241,5,49,158,119,106,100,178,247,61,154,161,134,111,198,28,192,44,150,189,7,205,154,142,45,190,172,69,107,176,36,105,64,30,153,120,233,138,210,10,19,201,37,119,182,152,85,43,37,56,68,199,14,82,214,220,245,249,231,141,77,20,190,252,61,102,166,209,230,24,109,225,229,78,195,145,93,109,32,127,163,49,126,248,87,165,80,47,35,155,3,51,50,146,244,105,171,122,226,62,82,242,157,209,37,222,157,224,156,21,73,10,238,198,123,110,60,209,122,158,82,5,221,166,227,119,183,251,80,175,245,112,156,150,175,183,247,162,53,159,213,33,71,40,168,227,104,244,244,210,154,12,114,234,6,153,36,147,203,170,108,85,64,250,110,225,137,2,143,243,163,40,173,220,191,63,210,108,131,154,142,83,175,46,56,41,236,83,221,81,161,144,135,172,99,88,139,115,229,148,143,162,9,203,12,44,238,102,165,234,230,179,179,242,16,227,158,20,196,203,126,102,121,194,246,105,131,73,192,81,122,192,229,32,52,68,139,60,16,102,94,4,190,236,77,238,222,73,240,221,6,252,179,240,56,85,108,237,167,95,168,223,161,49,28,186,57,93,43,203,125,223,42,221,67,47,174,96,56,99,204,115,41,252,252,106,153,180,228,242,100,155,42,105,108,181,215,47,150,176,81,36,192,211,244,135,162,127,189,201,80,62,117,91,125,58,245,215,9,16,165,134,52,42,43,225,155,28,21,189,76,85,226,216,155,133,105,120,60,145,152,6,52,150,149,2,255,255,126,255,45,36,58,37,21,112,25,5,210,187,69,74,195,46,226,170,12,90,154,7,142,228,89,148,22,211,1,150,132,252,99,19,215,135,242,15,150,0,17,251,192,38,133,71,164,62,161,144,240,178,62,63,254,50,137,26,207,233,156,52,145,94,86,239,132,26,146,181,46,165,248,100,14,76,252,16,214,130,195,166,67,120,113,30,255,126,197,11,57,108,130,66,163,177,70,30,223,117,244,53,44,13,86,39,70,58,213,212,230,152,164,76,152,10,227,3,6,230,216,73,88,108,91,245,126,137,58,224,132,168,129,199,254,247,134,142,56,81,168,160,119,44,222,123,230,189,204,92,245,18,227,172,58,240,174,149,68,71,210,183,169,241,146,73,86,210,216,156,250,239,161,219,212,210,69,48,33,137,81,185,192,218,197,2,122,26,76,13,121,61,31,44,239,37,158,126,254,241,131,26,167,224,67,133,125,52,204,195,141,119,131,208,214,151,86,54,137,139,144,178,173,220,170,156,70,125,66,38,125,127,135,146,246,160,95,230,1,248,184,55,65,56,225,139,169,106,17,246,153,98,119,248,67,85,148,28,157,200,233,186,149,138,180,147,37,42,212,190,28,189,109,117,242,168,56,133,17,29,241,89,218,5,242,81,50,61,166,175,124,106,47,237,20,201,235,69,95,202,35,243,79,223,34,85,47,100,252,168,29,171,20,189,109,65,14,156,71,195,246,94,104,211,21,29,195,84,33,131,207,221,120,139,57,78,126,88,195,191,172,133,96,242,110,140,236,227,76,154,55,32,134,193,20,204,21,192,232,157,224,147,175,193,96,9,127,18,107,239,96,240,98,139,149,104,92,151,196,170,198,104,185,117,179,26,20,72,48,36,47,32,86,42,189,173,80,71,219,151,79,181,88,45,26,191,38,133,45,54,131,31,109,115,161,163,34,38,89,40,49,173,198,48,17,40,39,121,77,90,70,42,251,130,168,125,184,76,60,95,94,136,227,248,145,210,226,191,137,247,72,210,17,141,52,5,102,220,23,111,146,114,218,208,22,105,9,130,97,83,57,25,228,137,6,99,12,24,29,89,25,101,217,133,196,253,246,158,114,75,8,90,142,28,147,19,22,164,240,205,1,21,145,19,225,61,98,21,22,215,32,158,9,44,97,148,104,201,219,76,43,45,162,73,151,252,188,155,192,134,113,103,109,255,54,42,206,24,76,87,154,98,187,78,193,50,86,191,222,86,162,165,38,191,118,117,72,31,6,174,147,231,105,158,70,133,79,138,223,55,73,210,90,194,194,112,167,14,253,133,160,197,234,193,24,75,239,106,47,115,70,102,75,122,123,87,158,185,162,180,84,210,222,141,172,125,211,117,181,155,250,182,51,247,178,100,123,8,8,173,224,246,222,40,35,31,171,203,195,36,34,6,53,171,105,219,106,216,77,18,130,182,37,225,3,235,196,203,114,168,7,2,10,14,230,118,6,134,118,20,184,145,213,218,127,110,182,193,145,91,202,110,11,96,118,1,8,96,103,167,236,180,15,141,151,253,100,7,112,25,70,89,121,233,178,158,234,47,68,162,185,146,146,7,74,2,17,238,108,171,91,64,92,173,85,82,121,240,175,136,132,26,123,225,64,169,132,53,192,187,113,8,165,133,192,249,61,166,108,170,2,175,11,243,183,162,93,109,51,151,40,206,39,150,0,84,130,215,29,211,96,200,244,193,206,63,137,9,225,205,195,93,147,70,125,177,146,164,76,247,0,61,118,12,73,75,151,145,218,82,180,207,112,233,175,169,104,180,29,149,4,129,248,70,10,159,34,67,208,4,235,146,205,128,223,104,17,16,189,72,150,29,148,21,85,152,237,97,200,84,57,234,9,165,16,73,40,118,10,18,222,171,43,231,169,211,149,179,250,145,227,129,66,53,2,35,228,99,7,1,101,161,122,247,98,103,47,32,194,21,66,228,215,171,211,95,93,47,71,164,197,154,72,46,73,190,186,131,152,104,252,1,237,94,154,240,6,67,188,57,183,3,28,30,181,14,142,247,193,242,88,231,188,86,198,130,125,97,9,115,137,196,6,38,94,170,51,157,253,197,152,195,181,150,253,125,49,6,217,29,102,120,252,248,217,191,232,176,151,7,118,12,126,164,219,67,123,72,16,146,223,203,183,0,196,87,186,185,173,67,246,204,171,20,21,86,98,182,253,7,186,6,120,189,118,3,229,237,60,53,90,120,139,87,229,79,153,85,139,16,81,100,189,150,202,125,164,42,132,10,163,190,85,177,69,169,181,85,186,64,77,182,99,209,185,183,19,5,1,24,167,247,211,71,7,154,124,136,40,199,61,196,217,202,170,170,93,64,20,178,234,247,41,59,124,192,158,211,128,28,144,37,95,61,108,113,150,27,161,102,97,250,86,162,10,193,27,201,55,193,56,84,164,176,59,172,180,2,117,209,83,226,255,156,104,115,80,9,171,177,196,38,252,19,138,252,29,242,231,74,93,205,161,41,158,79,204,211,0,30,248,42,125,237,167,151,3,163,35,219,102,225,38,80,160,246,91,202,15,81,5,104,108,210,239,193,131,146,27,150,17,171,71,221,84,112,204,146,94,186,237,255,206,118,141,107,20,169,226,15,43,75,224,52,120,186,0,134,235,166,30,237,98,31,139,146,29,104,64,56,3,249,66,92,147,217,211,9,31,96,178,69,148,227,230,101,236,243,45,246,172,39,229,59,69,106,63,147,212,148,179,217,10,220,19,61,36,147,54,173,248,250,238,79,181,163,211,105,11,79,136,249,56,91,202,219,147,180,212,42,140,52,110,222,216,92,215,61,213,55,188,33,239,190,201,255,96,1,215,85,244,86,49,152,17,180,172,68,196,115,71,107,182,243,219,136,48,23,116,210,242,8,233,123,235,101,169,61,55,63,1,51,205,161,189,96,59,52,218,197,250,26,88,73,52,217,104,199,216,234,189,209,12,232,29,210,128,20,244,127,219,15,204,123,222,84,167,249,54,43,174,28,118,186,210,116,176,58,78,38,166,130,144,219,92,43,91,180,1,195,20,39,139,0,25,240,204,75,61,178,95,199,10,3,136,139,50,249,155,86,95,70,214,41,166,76,132,6,166,146,35,118,145,100,203,149,154,211,215,94,104,5,44,83,183,45,251,89,212,57,197,144,82,87,170,120,45,105,80,129,100,131,159,10,127,221,163,246,63,192,154,53,205,6,127,117,223,24,147,216,93,28,239,163,214,221,158,12,149,255,83,88,41,136,165,138,1,254,6,44,25,143,22,104,150,94,24,196,25,238,193,216,170,71,103,76,33,52,211,45,205,235,134,41,248,86,65,9,32,255,32,95,30,250,243,251,43,119,170,184,85,107,38,21,98,231,54,218,226,16,72,174,6,221,38,211,120,221,119,117,120,67,209,251,33,84,155,163,163,47,53,96,15,51,76,204,87,153,85,170,54,66,113,12,174,34,104,136,90,62,76,103,210,150,82,37,200,148,44,89,113,229,33,173,240,114,61,21,131,193,157,216,181,193,207,219,29,42,99,21,186,158,11,145,155,4,216,22,244,162,245,120,63,128,57,117,241,213,60,251,251,149,87,153,99,63,22,75,81,103,103,239,199,225,110,110,88,38,125,240,116,161,226,53,38,183,2,223,68,221,87,205,73,201,187,129,82,39,35,166,109,116,96,250,15,15,242,104,227,86,21,140,48,172,188,54,214,185,33,4,199,217,220,218,185,44,244,170,133,64,135,231,135,80,159,130,65,112,36,250,209,241,226,74,174,130,199,202,217,218,87,161,162,130,254,242,150,34,63,117,178,224,76,211,80,201,111,72,69,137,93,62,24,23,249,115,80,83,95,17,166,84,223,132,120,6,53,34,199,208,205,80,109,133,213,92,49,18,214,230,123,245,73,80,228,94,106,241,165,216,84,255,96,177,178,90,92,5,219,185,153,238,208,136,79,150,15,232,139,179,52,146,235,158,62,239,136,154,45,92,190,176,19,91,40,214,152,149,209,222,247,97,175,74,250,98,231,204,211,233,2,168,136,18,202,254,144,196,95,80,187,220,123,31,164,176,207,23,248,81,3,174,138,206,65,83,36,29,70,32,71,21,227,157,254,228,2,4,215,71,27,252,9,219,49,49,23,248,163,43,170,192,126,75,198,97,91,38,182,93,204,141,250,187,145,128,158,103,88,73,178,191,233,253,231,3,169,38,117,163,181,44,217,91,138,15,239,82,140,19,78,13,168,212,227,46,202,225,130,28,150,211,105,239,25,243,208,76,174,52,37,170,87,125,141,221,90,95,41,51,53,205,112,75,54,129,102,51,87,222,28,117,188,154,174,103,66,55,95,247,97,127,31,107,22,117,195,115,97,108,19,52,70,179,212,190,15,8,213,49,139,119,170,201,169,8,199,203,166,183,90,134,185,169,133,135,9,251,66,104,187,220,182,164,82,21,125,132,197,116,14,169,241,211,104,107,169,17,246,140,46,235,236,23,84,93,180,72,214,10,39,185,197,170,73,30,43,35,75,114,202,126,143,2,127,114,206,107,25,116,183,11,43,3,146,183,121,214,79,26,240,70,203,45,88,74,11,137,245,21,38,44,66,143,61,168,69,76,204,92,186,121,203,15,46,213,237,131,23,220,68,52,188,111,185,48,81,35,208,159,218,44,76,71,236,152,61,103,92,247,136,123,88,196,109,213,91,97,190,88,164,237,171,59,217,231,230,51,149,191,114,162,41,91,249,249,25,109,183,231,25,48,30,35,44,156,199,26,146,144,26,85,40,82,54,83,253,102,88,29,52,114,160,176,0,95,4,217,205,123,143,97,62,149,15,178,195,166,156,183,183,170,183,54,232,197,211,241,7,215,241,86,159,151,161,98,116,91,139,14,111,22,41,155,5,43,72,245,246,20,196,27,62,112,149,21,253,42,111,173,148,25,42,199,41,53,84,169,17,246,92,25,211,161,41,159,252,62,243,4,19,121,43,66,199,74,28,208,193,205,33,126,84,173,30,16,26,179,244,95,188,90,6,16,178,251,191,203,121,130,161,12,52,170,24,14,141,2,163,190,6,52,205,187,57,245,252,9,53,65,132,246,126,90,3,26,54,238,222,74,237,35,163,214,83,43,254,139,112,244,74,15,241,20,255,217,117,129,81,233,181,187,160,29,30,245,145,199,163,29,171,87,228,222,50,229,60,139,23,152,179,33,23,124,180,100,223,209,21,191,93,240,166,209,66,67,28,158,237,190,62,80,188,131,151,72,22,159,212,121,139,49,254,184,106,134,122,77,103,165,81,70,69,174,0,7,179,26,152,234,23,37,155,212,120,59,223,226,216,189,170,9,42,206,10,123,140,130,214,229,149,218,74,215,152,151,235,170,53,33,209,190,193,105,61,182,108,226,176,32,213,78,117,106,23,56,121,61,82,213,107,121,107,114,185,20,99,151,57,44,105,153,238,174,24,192,241,254,251,80,193,143,221,0,58,227,109,190,129,185,22,131,37,221,129,34,101,144,152,33,250,198,183,73,236,69,174,215,68,64,181,94,33,132,40,149,248,252,133,191,99,245,130,21,43,49,211,224,204,33,169,240,230,120,107,228,46,140,168,241,32,17,95,48,147,101,16,176,251,83,160,253,105,171,56,79,198,139,36,48,144,120,99,236,171,235,56,117,196,171,178,244,170,61,79,183,32,202,66,50,130,211,99,78,199,73,255,242,30,138,199,156,129,107,187,182,255,144,201,230,138,199,111,154,10,126,232,144,99,117,187,160,97,221,177,191,5,239,139,181,240,32,249,247,61,216,207,154,217,224,246,49,118,3,194,107,197,233,3,242,99,182,58,45,151,176,238,101,118,57,44,123,195,112,61,129,140,199,98,25,86,104,2,141,220,161,128,109,32,8,89,147,249,11,246,14,255,195,81,233,46,89,37,122,225,211,69,132,120,138,169,254,0,72,208,116,247,244,60,55,28,135,15,11,28,174,65,40,253,148,181,6,57,220,134,224,205,255,225,22,228,49,200,228,182,179,141,237,217,9,47,114,203,57,24,173,236,15,100,174,120,178,73,84,236,141,45,188,142,252,66,85,56,248,161,247,21,240,209,145,198,24,158,227,106,158,18,248,204,21,1,99,35,91,187,157,228,98,106,35,231,158,103,53,119,135,62,168,207,48,5,118,236,117,255,204,65,60,49,102,180,55,82,149,17,205,214,182,198,223,77,55,234,99,156,29,161,90,22,138,7,126,240,213,226,110,63,214,97,71,161,203,216,10,31,25,62,71,223,163,238,97,14,115,144,121,112,103,4,186,16,66,51,105,110,65,111,32,206,82,213,231,74,107,199,255,85,48,249,19,123,45,142,3,104,77,86,181,99,8,158,50,3,108,43,23,113,246,189,180,107,134,24,9,137,36,178,9,176,197,63,33,63,164,220,217,243,175,16,197,210,28,16,109,192,143,193,240,252,44,124,8,108,179,168,171,135,107,32,216,49,136,123,109,133,33,176,167,185,189,30,120,210,5,211,14,127,118,199,147,121,246,58,33,239,172,251,87,223,152,144,13,169,216,65,87,59,132,210,118,116,30,68,72,68,155,103,230,81,33,26,21,82,14,73,251,183,147,86,222,194,97,44,169,244,82,155,95,253,205,116,91,165,44,64,31,163,242,253,93,23,26,209,14,33,97,62,148,115,63,247,111,137,13,9,163,215,243,223,218,10,114,82,195,219,233,24,117,167,173,231,13,156,77,46,231,130,200,122,169,91,49,229,215,250,140,73,229,240,44,212,41,117,112,31,126,218,196,58,241,101,147,26,195,148,98,153,198,104,87,90,149,128,60,239,177,50,49,11,242,239,230,196,182,89,101,80,215,168,143,70,48,53,53,215,22,99,194,129,245,128,163,40,102,25,14,99,189,152,35,135,13,16,105,137,188,32,226,246,176,38,30,36,65,146,145,240,83,103,2,107,133,21,172,41,239,28,250,134,170,228,80,43,122,211,87,111,228,168,29,171,79,69,62,152,18,69,203,96,169,144,83,50,37,65,208,1,113,46,2,67,73,221,2,181,73,185,209,20,163,237,141,222,221,69,220,155,12,177,239,150,84,234,58,111,225,3,31,187,110,139,78,139,234,186,202,73,72,34,125,59,43,206,220,68,6,49,123,14,147,144,206,60,95,31,173,236,244,239,64,11,119,89,226,7,117,175,218,115,104,165,195,209,202,140,132,15,6,115,213,209,69,238,7,89,37,249,156,158,67,124,208,100,194,232,148,52,214,125,166,99,224,152,46,109,187,234,230,51,60,189,191,120,28,13,67,152,105,230,40,147,153,215,16,149,231,51,170,159,88,97,228,216,161,34,87,65,129,153,213,186,140,150,104,113,164,25,120,246,58,78,221,124,33,179,135,7,220,233,68,9,15,123,101,187,131,139,95,177,234,29,215,24,57,107,53,194,252,161,247,70,224,245,22,104,10,41,39,213,190,186,249,159,32,28,196,55,153,225,205,18,72,227,70,120,101,199,237,132,225,10,124,88,154,151,215,153,67,177,100,244,99,169,37,127,97,122,188,216,217,79,187,227,87,69,243,42,139,151,228,79,141,154,88,240,7,29,255,165,129,150,70,173,212,207,194,245,243,54,210,111,168,77,71,140,61,28,64,106,8,196,60,68,154,18,110,22,252,63,172,163,34,138,138,105,145,101,244,110,11,75,95,244,220,224,140,191,243,85,79,137,128,246,173,146,28,1,68,146,131,190,104,107,105,10,183,141,149,204,59,176,190,91,3,180,254,33,47,24,58,4,53,177,211,193,103,6,161,57,156,191,177,108,76,83,185,133,20,167,103,26,75,148,54,239,124,182,71,95,160,157,60,112,22,149,136,53,82,150,241,250,192,35,199,124,207,79,66,84,131,7,63,140,114,16,166,158,30,0,73,131,202,144,116,46,50,92,60,23,147,147,14,236,195,64,128,205,63,248,146,1,49,182,30,96,166,149,196,243,131,88,93,119,167,118,22,137,56,179,169,223,194,48,235,4,196,19,7,210,55,75,235,92,247,15,83,174,53,132,172,34,214,91,205,147,70,34,195,103,132,175,68,245,7,227,205,122,160,7,72,137,123,51,243,8,7,82,113,179,53,171,249,151,156,75,82,204,101,194,53,247,2,201,39,125,151,8,4,189,190,40,95,41,72,181,116,99,58,100,136,118,164,13,191,107,164,69,39,229,204,2,248,254,87,112,64,247,106,105,66,193,73,104,67,75,181,248,105,39,227,153,139,164,41,215,76,244,118,95,99,56,13,94,20,67,33,205,238,108,249,81,105,60,177,18,155,229,73,173,205,78,164,144,180,161,191,210,203,150,190,16,55,228,110,203,212,118,15,103,25,67,152,199,2,36,17,117,201,129,88,197,112,153,188,44,58,196,160,131,198,150,19,223,209,224,90,127,231,71,1,40,82,195,12,242,223,233,211,68,210,32,176,1,106,119,179,211,33,221,107,210,194,227,213,88,3,122,19,130,145,199,16,66,179,41,215,40,18,133,40,191,25,49,31,101,27,16,11,60,119,20,186,217,168,204,250,28,173,159,38,166,106,2,35,49,133,30,16,174,41,134,5,154,247,72,247,171,23,225,89,228,141,14,221,122,56,188,54,252,90,121,252,169,8,168,27,59,138,8,245,70,122,230,65,165,140,117,136,206,11,169,209,146,240,8,234,87,27,21,119,136,227,84,138,65,172,42,227,109,202,167,67,219,148,125,32,179,242,176,224,42,235,163,145,195,63,145,122,135,21,164,85,133,249,38,87,145,90,3,151,203,189,99,172,189,248,86,207,193,226,138,44,42,179,190,99,83,127,92,185,32,159,58,246,239,241,246,235,227,205,219,169,42,77,149,0,212,210,172,47,174,68,122,133,7,78,152,86,30,65,58,84,65,40,113,125,213,150,112,146,1,46,218,175,242,206,243,3,22,233,246,135,129,96,57,130,15,151,104,91,220,169,42,107,34,44,14,229,23,97,55,219,134,96,213,252,133,227,120,195,1,46,17,86,212,120,130,91,248,166,233,51,66,254,106,183,117,42,44,36,169,196,204,173,91,96,109,228,171,28,189,45,250,183,121,167,12,164,164,245,225,177,164,170,138,139,161,93,90,83,85,26,198,104,106,203,108,131,144,196,153,22,188,229,99,101,228,68,84,115,35,112,19,129,18,184,189,228,220,191,206,106,106,126,188,176,42,150,208,166,249,215,76,49,78,167,49,137,16,206,210,203,31,206,130,158,233,143,12,168,123,152,246,181,110,5,9,143,33,8,20,72,188,117,52,80,18,200,90,101,236,228,207,56,241,5,217,53,40,86,180,67,214,216,113,227,232,42,4,123,161,29,225,131,69,60,164,193,158,200,54,177,14,32,137,153,25,110,144,200,246,156,194,61,16,88,79,24,113,181,5,133,88,82,165,176,38,251,156,45,231,111,141,37,120,107,195,254,51,23,243,143,18,30,92,222,216,31,27,168,49,204,158,75,50,29,108,173,189,227,162,147,5,233,159,187,189,71,11,14,221,15,68,223,60,234,186,227,182,193,229,131,242,98,115,34,126,30,59,20,56,101,249,9,38,148,110,79,181,179,181,29,240,61,110,204,161,242,160,184,30,38,49,180,136,78,22,156,1,249,192,217,132,67,3,250,243,132,141,231,10,84,231,97,122,73,28,88,116,105,213,193,202,47,183,216,19,80,71,55,14,123,32,194,193,121,208,234,113,73,234,146,93,189,196,164,129,140,201,122,187,60,67,10,121,125,17,246,192,134,16,58,220,3,66,88,63,127,197,206,164,85,151,11,143,43,109,35,215,25,113,90,99,90,205,22,209,122,41,112,244,206,253,59,161,241,168,251,89,190,186,151,193,3,142,219,1,102,68,147,87,145,74,157,223,203,18,248,51,21,219,92,9,251,196,149,82,153,103,27,151,252,54,21,4,47,205,56,172,183,3,29,202,225,83,16,70,15,21,227,219,225,178,248,157,53,135,57,185,163,37,123,167,126,80,187,41,181,17,191,207,228,71,37,158,205,118,62,248,250,194,59,71,214,167,103,233,25,73,205,178,231,128,78,53,113,28,73,140,86,87,88,87,238,196,137,77,234,138,39,195,39,117,89,71,3,123,115,108,182,175,148,180,142,193,159,155,141,71,168,172,98,136,187,112,36,25,146,98,217,160,17,34,77,55,98,189,208,173,74,117,181,200,124,182,123,12,56,62,149,214,75,112,112,107,126,242,224,85,234,235,172,131,250,233,229,99,14,92,194,36,21,156,167,172,215,243,141,214,57,79,177,104,94,207,160,8,3,102,237,50,84,126,223,147,92,211,221,196,52,130,24,176,159,132,65,156,131,71,126,4,33,143,91,104,28,50,153,209,95,181,28,75,113,70,67,27,109,192,39,174,135,252,172,218,211,94,160,62,199,154,79,251,16,22,195,15,22,140,253,36,242,85,72,147,22,121,33,25,195,83,123,67,179,160,66,85,146,45,114,228,93,116,57,55,217,212,216,31,50,167,229,242,19,107,240,57,124,255,142,191,249,148,74,39,163,43,156,151,201,207,220,46,185,27,203,141,137,15,92,5,101,198,159,181,2,84,128,42,9,10,185,221,175,55,128,247,131,98,98,146,152,8,240,110,121,15,67,233,2,21,145,83,105,182,127,239,100,153,185,165,225,124,59,119,26,175,192,81,4,98,42,93,184,200,34,68,13,134,123,5,43,164,167,218,32,67,79,70,4,196,254,131,50,201,157,133,80,79,208,242,155,224,237,252,110,27,249,238,45,235,77,229,182,93,205,123,32,5,3,78,154,69,213,117,216,130,198,46,105,47,78,76,255,250,230,254,99,106,218,110,21,186,185,71,173,236,91,67,119,59,38,141,202,223,39,183,153,239,2,113,168,121,123,54,217,55,237,94,11,1,190,38,16,170,216,147,239,88,254,229,245,220,108,102,247,55,229,237,173,167,179,231,185,82,226,109,53,81,87,15,55,217,69,204,109,3,164,126,143,193,42,141,227,90,36,226,83,128,215,12,177,216,190,140,85,129,225,224,25,74,141,225,41,192,131,60,180,130,169,191,124,58,1,135,224,63,27,9,138,244,124,167,199,35,2,120,62,25,218,238,78,254,29,125,60,19,72,168,31,194,52,28,70,137,193,242,203,2,91,43,138,248,5,135,204,165,116,67,10,198,121,98,100,238,143,43,94,209,39,162,232,129,176,41,254,158,40,195,167,51,206,48,151,123,55,64,65,233,220,176,238,73,3,129,139,129,242,194,88,95,199,147,187,75,237,229,171,30,89,115,154,239,165,169,235,59,98,63,177,91,115,84,142,203,97,103,79,66,2,91,157,207,14,45,246,75,211,46,69,228,42,158,158,132,228,178,36,163,98,194,69,11,37,186,217,155,206,244,54,125,9,122,128,237,37,159,232,91,68,159,92,116,153,244,199,136,214,88,171,186,117,98,60,171,163,232,45,147,151,123,170,237,130,250,83,244,253,125,237,248,178,237,111,15,63,154,122,147,51,15,60,204,111,139,245,231,228,185,51,36,176,237,79,48,4,150,130,163,59,120,29,126,54,40,104,116,142,238,121,237,189,107,191,35,8,119,113,131,109,108,173,24,9,142,108,8,49,51,202,146,192,173,17,1,241,218,187,124,164,246,139,220,70,143,192,138,152,227,175,189,77,209,86,106,63,119,2,159,194,2,163,89,30,119,83,127,152,98,60,123,145,96,155,67,36,124,94,20,93,243,98,219,253,143,238,124,45,39,226,10,242,116,227,184,129,242,21,192,51,94,97,231,64,148,237,211,59,177,198,10,216,238,62,4,109,230,168,9,132,240,215,0,86,29,251,174,78,233,243,27,50,92,197,253,214,2,123,146,246,222,140,146,148,108,237,15,4,222,247,156,154,132,10,40,151,8,10,70,114,132,181,145,136,176,233,7,169,57,111,204,90,220,67,215,132,40,150,216,152,69,54,80,43,171,67,46,100,140,33,185,115,58,154,35,242,247,6,43,31,174,39,80,101,216,73,40,132,227,201,14,85,37,194,50,3,146,118,78,76,36,211,88,24,220,98,14,33,120,148,222,160,20,160,118,195,167,167,92,128,37,5,53,38,72,206,146,123,57,213,135,200,109,71,35,239,160,169,225,222,136,217,153,92,67,165,51,105,189,47,203,155,237,217,9,216,232,29,225,177,49,205,230,232,177,124,66,19,114,207,198,114,64,45,161,124,66,110,85,157,81,102,32,22,83,53,111,196,27,133,196,169,162,223,120,126,235,105,163,132,221,206,150,110,214,226,227,26,172,30,160,193,251,235,130,209,125,165,77,58,39,115,187,196,165,24,148,33,237,15,73,76,51,191,88,212,165,137,89,220,47,35,108,174,114,48,214,113,39,163,180,185,63,88,233,112,0,120,241,137,168,24,63,138,54,82,207,177,179,66,101,46,177,222,3,52,49,103,68,5,246,78,182,234,55,35,29,9,19,192,144,78,132,224,162,148,96,89,62,61,109,6,178,98,241,196,88,167,22,196,56,11,139,35,94,112,213,134,206,158,24,179,145,144,24,250,44,149,253,67,210,8,0,244,166,243,0,180,234,155,46,191,122,41,93,142,70,154,56,201,66,159,207,162,193,63,26,46,204,221,206,29,100,232,161,225,87,106,130,47,154,66,253,50,33,4,103,71,134,239,65,137,220,222,90,200,221,145,253,16,73,125,66,213,113,239,82,209,96,85,98,196,87,143,30,250,24,217,92,120,23,123,71,64,51,243,204,192,239,147,75,30,170,32,161,187,95,176,78,235,9,173,103,112,9,93,39,55,89,66,223,135,55,158,58,28,249,4,53,46,175,138,48,65,135,70,136,1,162,20,77,236,103,41,150,88,60,162,162,221,75,62,108,114,118,100,40,120,101,241,122,160,0,109,225,54,161,239,188,6,149,136,139,198,177,179,32,43,126,52,149,57,217,226,136,215,201,55,32,213,229,87,28,109,36,223,42,151,98,71,107,140,255,230,206,183,84,127,109,108,57,226,37,11,140,188,250,216,82,32,241,186,122,68,173,128,81,29,57,2,23,81,10,233,198,238,113,91,11,7,17,184,180,159,230,116,147,143,120,21,24,1,220,118,49,16,80,204,12,78,41,111,117,193,98,56,148,193,219,160,156,230,56,126,1,172,183,95,204,229,202,75,218,108,245,33,254,8,58,127,98,209,197,176,100,60,110,139,133,80,43,42,133,200,12,216,121,186,89,171,171,252,220,132,121,46,180,75,79,8,157,91,112,112,34,247,193,147,132,119,236,30,223,101,129,132,197,45,134,84,202,92,249,70,208,211,158,206,209,216,202,106,106,96,1,80,249,182,103,247,124,85,169,42,212,67,245,112,214,156,147,143,216,186,202,197,119,5,230,23,226,199,79,150,253,252,85,1,193,145,96,212,15,165,73,246,244,50,249,165,95,254,252,112,62,100,237,167,234,181,238,164,135,224,175,19,225,82,153,135,122,209,81,59,123,165,21,127,99,54,56,18,153,226,205,161,95,202,7,79,126,124,92,208,244,46,5,176,227,206,200,16,140,97,250,131,187,54,34,117,52,52,206,150,201,200,182,45,201,225,80,46,100,113,199,193,12,116,224,253,59,85,244,248,161,239,199,164,208,63,114,103,163,167,185,246,203,19,33,102,53,236,108,3,205,170,155,230,73,204,142,178,233,7,187,171,191,137,254,60,149,218,98,40,42,87,10,3,146,207,162,67,113,25,173,141,27,217,143,225,97,164,2,208,116,57,181,180,112,233,183,114,62,110,197,29,79,155,213,7,115,94,60,229,43,83,79,119,171,196,20,78,239,233,51,87,6,32,5,59,166,121,176,193,0,2,145,150,183,130,7,36,179,159,57,212,66,179,111,151,174,27,202,58,35,12,121,174,29,17,69,244,46,87,1,173,238,194,40,107,180,147,157,209,184,241,104,251,123,242,164,42,31,93,118,82,79,189,47,105,102,158,30,210,164,16,47,140,226,212,235,70,176,78,30,247,193,162,137,19,102,181,9,248,156,29,149,41,73,2,34,88,183,198,106,254,34,124,19,150,32,99,71,253,14,190,121,107,200,168,38,114,205,153,112,139,204,16,149,101,168,127,70,40,156,157,78,179,113,220,4,46,194,124,96,187,139,83,36,28,169,50,209,88,176,134,217,219,55,18,186,165,170,11,175,60,216,24,132,95,218,101,75,194,66,64,184,1,56,29,86,92,86,243,122,204,124,185,21,219,37,111,68,82,178,41,69,127,186,121,223,219,84,41,169,105,54,165,5,128,102,12,67,130,217,46,97,233,254,216,57,121,145,39,46,34,136,82,175,114,153,215,16,119,138,116,45,137,136,230,59,132,221,97,0,150,250,153,211,18,141,254,212,157,9,45,217,191,16,24,133,130,194,151,189,230,92,187,55,12,247,187,8,115,13,29,222,207,59,92,230,24,146,39,165,2,54,188,107,162,190,178,185,22,188,187,172,42,164,239,225,92,55,26,237,230,59,0,75,13,33,47,250,12,161,72,4,185,159,244,163,208,129,102,176,239,178,99,211,97,92,241,234,19,85,70,42,189,55,130,151,119,38,50,126,239,231,40,153,124,51,220,63,234,208,163,211,170,63,37,231,40,152,183,204,90,227,246,208,8,196,85,209,243,92,102,174,199,27,110,145,27,1,158,35,176,107,152,163,227,75,21,184,120,238,57,155,201,3,194,165,57,117,211,136,236,17,128,98,177,93,111,46,94,137,155,5,70,101,212,42,190,79,218,62,143,123,151,171,59,185,175,9,185,245,254,235,130,177,69,252,61,157,29,229,105,128,229,192,180,37,158,214,254,13,129,64,53,209,247,56,140,241,97,250,119,174,250,204,68,97,184,208,29,20,117,25,12,105,234,224,76,223,115,197,177,7,235,247,19,42,20,85,78,15,81,181,192,153,4,160,176,82,106,67,212,194,132,240,190,45,126,79,192,122,42,28,239,165,14,139,14,152,62,129,78,48,66,45,207,97,240,165,178,129,234,169,234,59,12,218,46,249,54,76,20,225,254,11,128,237,242,61,101,16,36,207,202,13,244,205,77,104,204,51,50,1,5,95,211,151,110,251,255,185,191,151,167,102,140,98,163,129,27,38,60,101,197,176,252,212,232,136,208,157,118,51,83,111,209,188,223,78,130,47,24,91,236,170,159,121,55,3,202,0,155,212,180,173,74,37,161,201,91,108,166,174,27,239,60,20,65,158,225,185,85,89,127,76,244,27,86,150,160,201,13,106,79,143,68,200,236,55,107,243,76,149,215,188,118,183,198,159,26,140,136,153,211,173,159,16,57,139,31,93,149,70,6,141,53,112,164,6,184,239,106,159,222,67,158,26,121,136,223,39,46,140,67,170,202,95,88,179,214,186,212,140,8,12,94,34,77,226,17,17,162,210,225,20,151,177,74,9,100,126,170,73,142,33,144,154,131,151,205,235,28,118,190,6,137,98,50,237,7,94,230,246,133,250,179,160,199,89,103,9,203,111,37,216,185,171,40,117,6,107,87,133,165,172,22,140,220,186,41,97,187,57,196,102,220,15,169,194,254,170,33,237,69,78,127,4,30,119,51,251,153,50,179,106,153,232,131,96,100,243,32,78,78,223,191,150,158,39,30,201,43,12,220,233,103,223,247,156,210,213,52,75,203,102,114,46,35,81,55,175,89,207,53,66,198,247,164,132,51,64,124,120,125,108,35,3,184,185,202,162,122,93,58,198,11,176,146,221,62,6,92,250,135,230,38,135,125,76,89,22,140,243,110,14,212,252,94,85,234,86,142,168,158,28,94,124,183,180,213,174,80,170,142,88,83,48,201,169,249,109,156,83,4,161,186,46,235,85,83,86,244,7,52,58,188,19,124,117,35,105,13,185,191,47,252,142,77,194,147,27,235,193,126,138,65,32,134,118,24,227,33,219,142,48,59,235,147,8,183,94,74,184,233,4,78,44,55,20,167,190,216,145,187,105,253,135,93,68,15,204,76,81,176,255,140,229,106,248,29,154,109,79,247,240,181,62,181,2,28,187,26,136,254,180,92,158,140,81,194,11,245,237,48,28,57,112,87,48,233,185,13,251,113,29,199,152,222,226,254,232,119,199,120,251,113,224,226,89,162,215,74,115,227,118,145,197,176,156,161,226,233,79,170,203,163,113,106,144,108,25,85,163,91,129,143,75,216,56,51,156,13,106,116,79,121,79,152,139,128,156,169,174,94,228,172,49,115,235,134,42,145,67,107,214,122,8,49,156,210,218,178,151,67,247,169,0,56,164,44,222,132,125,193,90,153,10,15,29,69,159,229,98,193,181,138,65,215,14,65,89,116,209,247,174,22,72,27,141,214,94,36,169,203,34,123,25,192,248,196,238,148,225,225,253,59,44,43,96,2,26,21,96,123,202,184,253,55,162,172,81,29,95,172,11,133,235,129,224,183,94,71,85,29,23,65,246,242,222,224,109,136,62,63,145,107,248,167,160,195,242,204,135,237,253,107,53,91,77,34,207,186,102,102,84,28,14,44,194,39,232,156,245,132,232,76,102,63,206,240,49,132,118,211,1,70,75,30,42,3,149,207,174,223,160,227,64,221,207,62,64,74,186,97,163,201,85,231,33,84,76,132,47,66,189,73,137,21,77,184,234,168,231,171,247,76,32,229,1,138,186,116,5,60,65,8,57,133,57,165,125,190,51,105,242,89,1,141,234,53,168,34,89,88,55,63,52,10,226,116,30,115,175,214,74,234,133,248,48,242,17,47,155,75,131,130,124,207,192,199,156,142,142,119,122,3,15,49,119,155,82,80,171,180,19,29,133,31,247,222,9,245,206,244,22,69,12,85,112,250,23,97,212,191,32,152,5,115,206,31,197,19,250,138,219,130,3,84,216,78,11,80,213,13,161,199,128,136,64,7,53,223,221,247,108,10,139,128,47,36,225,149,145,94,106,22,86,14,62,13,43,181,226,188,243,228,218,231,144,137,51,46,13,237,21,72,193,233,132,28,220,20,8,4,122,72,237,253,246,222,239,176,0,105,79,66,248,100,211,232,18,217,109,127,11,57,83,34,123,20,60,137,153,193,152,195,96,127,130,205,193,250,201,146,44,174,91,40,108,105,104,231,248,136,114,61,136,124,241,31,128,186,165,230,218,248,76,54,35,51,13,80,241,46,59,34,214,111,253,168,149,252,124,4,81,171,131,110,58,165,172,223,166,5,45,240,154,11,195,26,117,137,238,192,41,98,219,74,113,235,25,234,46,9,144,57,228,196,138,122,230,73,229,42,31,24,18,166,217,131,24,95,177,251,18,240,249,10,235,122,112,16,73,162,6,70,8,231,108,54,87,216,194,174,60,128,244,234,190,212,213,146,128,244,187,133,74,29,128,195,60,234,120,57,168,116,97,234,156,164,173,42,225,70,177,38,184,43,121,148,186,19,207,224,19,253,214,102,184,227,77,205,223,63,242,184,142,75,134,48,96,96,243,151,83,50,87,123,186,147,177,176,62,113,237,99,50,108,201,126,185,218,219,219,241,171,55,44,28,194,49,254,72,63,140,63,178,112,216,15,3,183,189,172,230,154,116,254,246,200,73,82,76,41,15,168,132,147,25,115,46,90,151,15,180,193,60,237,178,105,74,47,191,86,59,221,105,248,98,26,140,49,149,76,146,83,229,173,71,134,78,113,171,186,136,69,240,102,228,167,251,86,198,107,167,79,180,215,210,44,58,98,143,79,188,44,133,107,54,248,165,231,104,149,127,120,62,61,159,252,239,41,101,177,140,108,77,90,49,230,151,125,115,153,80,213,191,17,98,59,202,149,108,239,233,23,177,26,245,216,97,198,111,31,75,248,67,177,55,207,157,212,233,20,69,111,167,232,80,21,144,9,32,199,43,200,181,141,195,9,143,237,154,121,175,158,247,124,39,117,184,48,30,51,103,4,19,16,28,84,98,72,251,204,19,32,194,90,236,170,52,202,181,96,92,120,59,184,47,169,66,177,66,217,150,2,50,182,17,7,131,32,76,227,116,70,174,42,90,163,89,35,33,148,41,240,228,253,31,107,201,210,198,152,13,86,70,112,248,225,121,155,252,134,99,239,2,8,98,108,44,76,227,160,213,104,141,16,130,205,118,253,123,220,48,200,187,80,35,114,62,45,188,107,29,79,220,169,244,147,158,70,102,122,231,232,149,243,55,230,115,28,185,83,39,179,237,221,41,170,240,44,143,39,216,163,87,213,39,157,118,225,99,80,190,57,171,200,20,2,7,166,112,211,127,0,69,167,84,159,62,190,37,46,1,194,192,152,94,188,50,203,38,220,128,2,108,156,32,255,174,254,89,135,44,97,26,237,37,203,70,32,238,3,218,163,213,145,32,244,50,67,233,217,30,131,135,205,0,46,29,143,192,99,180,144,34,96,7,74,212,164,44,215,190,88,252,138,84,97,50,251,203,44,252,175,247,178,155,79,180,28,8,80,184,205,211,9,119,150,32,91,150,4,102,212,89,217,117,71,241,163,146,90,113,142,34,228,139,182,236,101,97,47,152,88,91,161,47,37,246,4,92,89,174,210,15,82,44,118,249,82,198,192,155,172,220,91,168,190,233,35,204,84,24,113,139,102,112,42,108,124,19,27,148,60,159,78,38,239,90,234,5,193,172,28,58,20,182,11,43,162,123,82,184,178,167,19,172,101,106,3,69,146,204,136,46,70,35,133,166,103,74,245,222,246,76,109,232,173,160,36,50,39,140,112,227,59,10,18,127,30,232,161,113,146,233,102,248,171,205,245,154,98,101,53,109,65,36,82,31,241,200,111,216,27,255,10,48,237,213,82,221,17,250,248,215,19,150,56,175,233,19,230,30,233,199,3,100,121,176,189,175,63,20,231,105,113,121,51,88,188,231,109,177,58,34,9,199,121,226,157,183,76,219,41,224,204,61,144,124,88,115,7,214,74,179,178,42,119,144,76,98,58,171,185,134,98,123,177,87,100,213,183,165,147,22,29,151,19,74,146,102,107,158,201,189,0,79,185,36,105,84,104,73,152,103,132,228,196,39,102,113,158,255,56,212,198,37,172,139,31,238,98,184,182,42,69,108,194,245,23,205,45,21,76,115,162,181,174,59,213,233,59,240,184,32,212,226,199,126,11,205,232,217,187,51,197,98,94,117,94,105,152,41,48,22,181,8,146,134,207,30,237,255,240,248,183,191,187,67,210,16,185,191,54,193,2,218,22,99,176,191,233,78,247,165,4,231,131,62,37,109,244,76,194,155,129,212,66,0,101,223,162,211,13,80,169,217,16,68,4,155,216,61,35,76,162,144,217,34,209,73,249,250,253,186,140,124,41,237,124,22,168,97,40,95,47,38,188,204,216,150,184,229,185,174,113,3,154,126,238,50,165,170,12,27,209,53,157,76,118,81,252,10,140,31,103,160,43,171,6,65,205,225,154,85,121,76,216,228,29,241,184,200,160,225,86,4,199,137,80,222,199,30,9,163,177,222,131,91,24,3,147,148,250,20,157,246,166,73,41,246,240,159,85,53,172,227,255,239,211,188,78,85,210,198,63,175,149,47,251,126,139,167,245,143,5,212,41,111,52,133,173,37,114,122,63,214,212,6,98,213,169,140,241,226,233,95,47,169,91,89,117,116,228,30,78,123,163,137,11,19,142,70,121,166,215,141,20,57,100,202,75,131,150,222,136,204,79,199,205,220,46,9,129,92,116,55,148,224,138,82,32,255,250,251,59,239,99,130,13,77,106,233,191,37,70,164,141,160,195,95,192,54,39,178,189,46,17,135,160,255,198,62,249,69,57,5,74,22,165,134,209,143,179,8,28,219,212,141,148,242,233,231,171,234,72,186,111,252,84,120,130,253,206,225,145,123,88,19,194,150,24,168,247,191,92,162,203,56,94,55,72,199,142,76,50,37,253,13,142,159,201,100,153,149,243,217,240,192,204,254,66,239,13,23,161,166,210,210,120,35,7,141,179,109,83,57,146,163,16,195,195,129,214,39,34,155,158,29,244,128,143,18,233,121,150,87,80,227,145,22,207,133,15,10,172,79,48,176,209,68,66,116,22,167,251,162,90,108,98,148,98,84,46,164,185,106,48,68,247,163,112,24,15,78,105,58,173,251,63,10,252,91,83,158,57,178,63,21,40,113,231,82,251,191,134,27,71,131,203,150,222,121,48,211,181,0,62,91,119,123,77,252,183,63,204,142,239,211,87,244,129,213,2,81,221,210,104,182,252,35,116,91,198,172,132,76,148,89,3,74,8,96,232,19,70,18,232,128,18,145,133,229,23,13,93,175,174,68,105,55,192,81,168,1,142,132,193,37,99,188,243,51,14,26,6,195,29,149,159,115,77,169,235,22,66,101,37,224,43,146,152,141,191,222,67,12,74,51,124,129,141,11,37,97,10,50,79,112,123,54,180,89,156,10,237,145,90,99,35,116,84,163,249,196,70,103,144,16,14,13,233,42,5,213,163,203,205,92,6,212,210,195,46,141,24,15,1,215,71,30,31,0,4,24,15,93,217,35,228,173,104,78,117,69,140,243,168,119,62,223,200,171,123,57,184,88,64,53,21,153,201,0,115,146,22,119,84,228,16,189,124,213,148,92,15,178,58,83,69,87,213,137,150,254,92,197,211,157,193,255,150,115,3,222,48,64,41,28,208,245,211,29,135,30,54,205,250,93,94,57,155,196,37,151,90,109,165,11,249,203,106,37,64,103,100,206,108,40,181,36,238,104,208,241,13,26,75,32,133,101,47,132,226,199,174,3,139,186,102,206,19,21,6,166,44,184,63,7,255,61,155,90,233,60,161,86,176,23,97,194,237,176,234,251,116,25,226,11,145,130,13,179,158,222,252,26,235,132,202,117,229,195,232,158,52,183,96,47,219,235,210,51,146,103,15,241,22,194,84,73,169,183,142,81,87,203,6,251,105,254,2,56,164,156,137,219,71,205,59,144,217,70,38,73,57,73,70,131,114,20,249,181,50,184,200,127,251,28,30,92,166,20,252,156,141,128,223,214,176,136,154,210,238,245,131,123,1,114,106,160,197,74,57,4,101,162,185,66,93,219,192,225,68,181,231,74,140,180,121,162,114,142,129,187,73,66,192,218,128,28,39,134,251,0,243,48,55,112,205,204,80,144,149,109,100,247,179,224,228,198,89,225,7,131,170,203,32,130,21,23,249,122,134,208,160,239,23,10,91,107,175,27,56,59,104,18,71,209,245,4,165,227,203,178,69,1,114,130,119,193,171,64,18,182,174,155,16,84,193,55,150,153,90,251,6,94,161,253,223,200,143,16,162,175,93,211,88,243,61,118,144,204,158,163,68,183,243,85,64,42,52,155,32,39,213,93,165,239,188,8,152,93,228,136,71,213,103,158,57,252,54,203,34,230,180,127,56,46,22,5,220,190,103,131,16,64,135,114,68,112,125,205,54,108,113,157,5,31,108,20,138,80,149,170,6,114,65,223,21,159,246,115,158,118,220,203,106,20,66,204,213,59,225,109,136,122,206,137,104,126,66,24,195,83,223,112,36,241,154,219,254,255,248,77,142,202,95,86,171,11,42,188,7,245,217,138,49,224,34,61,121,28,57,25,3,70,9,40,108,107,108,211,160,206,154,77,59,153,161,172,200,23,84,154,131,94,122,115,145,19,13,234,127,86,154,80,149,41,50,98,186,251,36,10,53,159,223,103,104,248,67,154,136,228,46,83,243,36,33,221,157,116,83,109,54,89,171,46,252,120,86,50,220,23,252,185,68,192,125,37,223,233,232,110,16,135,71,175,199,37,75,162,17,48,41,32,39,131,59,145,161,20,26,149,216,99,1,188,240,87,189,8,24,224,227,175,207,156,151,37,76,105,62,202,86,172,9,208,0,186,72,213,78,103,254,132,192,92,113,242,42,224,245,111,181,206,107,130,182,212,63,185,27,28,41,112,220,209,148,172,7,140,225,168,124,67,203,73,76,139,41,226,87,30,125,197,216,76,36,160,168,194,202,181,254,134,0,148,187,242,94,239,72,9,21,148,168,92,66,161,144,73,37,106,39,176,127,116,44,183,89,77,47,138,171,10,169,117,147,107,92,29,184,69,82,220,13,130,34,214,197,214,6,152,46,180,228,77,211,162,47,149,169,145,56,196,174,84,97,93,246,216,30,34,211,137,93,8,161,64,73,106,220,60,107,201,86,86,124,51,9,66,244,168,8,22,125,147,200,68,23,23,247,75,139,87,52,54,5,53,175,14,218,127,126,196,104,220,88,75,122,52,99,226,111,88,137,95,199,196,6,2,87,182,200,67,133,205,210,73,174,53,64,12,134,84,182,73,199,7,65,88,7,24,83,187,31,81,35,236,229,37,177,78,42,143,233,94,241,133,195,255,185,7,218,41,43,231,129,3,23,175,147,37,26,188,70,161,146,126,24,12,38,104,96,209,143,227,254,9,198,24,192,4,227,59,174,32,240,251,5,34,127,186,184,83,193,62,41,187,33,39,239,28,16,118,164,36,171,230,136,212,122,52,86,39,165,85,61,117,145,179,83,209,229,95,227,85,170,136,187,59,115,217,179,60,48,21,67,116,58,14,145,89,89,35,229,5,152,217,138,26,10,189,186,35,83,210,174,165,179,87,168,247,177,43,213,204,247,37,109,164,15,182,108,253,170,140,83,214,151,0,211,81,132,64,43,30,248,18,149,11,44,248,98,107,216,117,38,96,167,82,124,152,140,191,51,40,145,207,31,45,189,144,120,151,236,172,94,196,233,80,172,227,217,187,197,174,24,108,153,189,212,51,44,156,203,149,74,222,95,240,202,168,235,255,91,215,29,201,254,8,156,120,134,162,218,172,153,51,254,189,4,238,93,65,227,158,247,6,74,254,126,91,58,204,84,167,188,223,91,180,79,147,62,150,135,231,158,186,185,126,91,13,115,56,108,78,17,205,175,102,47,20,157,73,175,89,225,242,141,119,215,191,236,127,186,252,109,87,164,233,22,213,98,137,134,97,78,12,13,150,30,160,164,149,154,108,167,156,104,67,228,187,152,143,135,114,154,47,7,21,89,131,179,34,253,135,40,109,220,0,127,213,82,85,64,161,1,113,242,240,66,56,78,225,32,59,26,177,12,19,79,6,212,120,217,177,7,187,76,85,122,133,9,219,81,118,109,201,21,119,47,122,30,190,208,241,78,63,16,91,45,44,253,13,228,18,228,187,96,222,132,166,77,100,226,124,234,61,59,174,40,117,26,163,5,65,107,1,95,18,170,126,100,95,216,113,98,15,186,246,133,3,205,221,228,159,206,212,201,240,175,113,198,72,187,233,28,104,253,239,168,246,139,120,149,143,34,146,39,220,145,216,114,243,109,219,151,117,75,33,162,197,181,62,19,128,118,215,96,101,54,68,109,7,171,133,54,145,1,15,56,224,58,123,172,196,221,3,133,158,85,120,21,246,153,166,1,17,66,48,223,247,230,95,15,223,253,250,109,197,6,190,76,117,7,245,185,143,129,188,191,215,198,20,90,194,172,250,78,233,102,182,120,92,116,208,65,80,84,235,77,57,207,221,127,16,225,96,218,22,104,216,138,195,220,101,236,3,109,87,42,198,95,96,164,202,48,107,45,17,107,246,2,243,229,149,152,83,101,228,91,80,183,254,119,138,201,64,197,135,212,15,171,151,44,69,249,208,188,57,253,250,157,63,153,226,131,155,3,224,56,103,144,28,200,229,192,71,131,21,129,219,235,31,205,144,191,146,253,77,67,78,216,241,242,228,244,174,123,254,65,212,26,35,218,100,1,28,145,247,37,254,116,206,212,40,200,241,209,30,238,181,165,198,211,144,87,158,142,226,70,232,172,134,42,41,121,222,108,17,68,45,47,16,56,26,77,188,99,188,115,118,252,245,11,51,25,44,27,128,31,32,221,54,158,109,102,53,155,4,245,73,26,234,174,198,111,64,52,171,213,56,173,114,145,152,204,191,140,179,22,93,211,35,243,221,136,103,201,155,0,41,110,183,62,30,176,252,190,108,47,23,203,166,160,173,17,124,11,189,244,44,4,13,133,74,224,19,240,200,254,27,57,180,193,89,67,10,147,117,127,169,109,96,98,8,10,21,26,37,181,81,247,202,60,172,58,139,237,116,143,140,46,52,176,49,71,231,243,80,161,14,219,152,25,62,178,232,150,162,47,124,122,155,221,61,212,160,224,158,136,39,24,24,159,93,108,6,145,49,245,189,95,22,153,45,100,83,225,12,97,201,53,242,6,2,23,210,62,108,106,189,178,189,42,64,247,93,171,233,157,196,159,103,239,240,111,60,164,43,151,83,198,183,204,37,185,207,113,120,130,103,10,4,90,144,149,54,51,128,82,233,108,119,172,85,82,79,203,25,184,22,113,202,100,46,34,121,95,234,102,43,243,242,211,223,171,133,152,188,18,134,67,47,2,94,11,17,249,254,0,115,150,132,37,136,76,84,42,91,153,219,138,4,233,91,164,1,243,162,12,134,75,244,55,138,40,252,182,74,245,239,39,45,157,106,56,118,130,15,190,210,138,155,237,239,57,182,77,69,190,113,237,27,178,173,214,149,95,133,12,106,208,89,63,129,174,51,58,43,142,103,103,138,109,123,39,101,45,171,1,233,54,34,208,63,121,151,241,39,0,207,133,172,100,150,134,5,196,133,184,171,253,201,139,186,75,242,123,53,174,38,249,95,72,254,64,108,209,147,37,177,166,69,3,178,95,255,47,41,195,232,6,73,119,89,203,225,150,80,125,183,56,28,82,112,89,167,237,204,73,139,208,233,7,168,90,35,244,133,50,216,254,240,80,227,187,102,135,27,213,192,201,21,175,236,199,100,103,36,247,192,4,133,40,125,16,111,25,177,101,37,180,170,49,230,106,169,123,73,58,231,60,106,230,145,116,211,215,134,199,90,18,243,210,29,225,79,224,248,108,204,147,215,73,244,75,154,145,95,137,151,193,154,146,43,242,175,5,62,42,113,9,57,70,59,133,75,165,250,154,186,143,167,22,47,252,137,102,87,181,104,147,207,195,205,88,18,48,209,126,182,35,179,10,30,175,25,163,6,202,85,185,99,52,208,20,19,242,169,14,253,227,198,85,129,68,11,99,112,59,79,142,105,188,254,123,148,88,153,70,89,84,106,236,34,181,241,51,194,138,62,14,134,245,151,117,235,135,10,139,140,204,146,196,96,242,114,217,131,102,142,129,65,132,108,64,29,42,233,238,33,19,249,17,222,195,125,158,124,202,110,18,183,150,111,199,70,127,8,180,135,203,33,143,230,228,90,44,43,118,241,57,168,162,89,150,106,102,32,60,250,93,143,196,239,12,214,171,73,180,196,199,210,115,112,192,13,9,123,222,213,148,91,19,101,236,101,30,146,43,164,10,156,101,112,151,65,89,151,245,154,56,37,194,99,153,35,80,3,93,62,246,6,68,42,34,155,207,230,215,121,37,213,153,36,165,136,123,181,144,31,215,138,161,118,151,196,108,131,138,93,13,158,182,138,197,184,0,44,139,70,0,204,15,179,245,235,111,229,61,119,1,248,135,70,169,50,116,69,16,223,77,223,248,176,81,63,205,104,150,100,178,216,215,7,243,251,58,16,117,59,213,117,122,156,183,0,72,126,132,100,86,92,240,106,174,220,88,51,75,166,111,176,139,229,215,30,173,166,246,249,201,187,24,250,69,150,214,224,9,17,218,53,173,213,254,11,60,19,32,202,124,40,131,51,99,223,226,217,190,252,29,14,39,73,199,37,180,254,114,46,169,46,109,205,172,86,62,198,113,209,186,149,211,122,42,239,238,71,133,33,39,217,86,131,68,199,243,26,0,143,97,215,140,217,34,11,55,192,118,66,69,203,200,128,171,40,250,94,127,204,76,168,232,153,226,37,150,4,8,22,177,75,64,204,39,19,45,127,173,174,14,222,159,184,66,88,61,250,133,231,114,166,164,33,157,77,203,31,222,189,111,131,178,107,117,10,165,203,18,211,117,188,134,254,238,158,123,143,231,245,189,89,21,88,66,169,241,24,26,210,108,105,249,56,37,196,36,26,110,237,31,34,198,114,72,218,133,14,40,38,0,26,218,130,56,146,228,86,253,43,36,112,162,58,232,178,162,105,114,186,74,187,229,215,195,101,241,14,24,95,246,248,101,255,68,164,79,41,18,245,65,11,228,167,132,169,52,170,196,91,52,224,204,230,105,193,231,254,49,143,85,42,221,140,233,18,131,116,86,127,103,136,113,15,23,95,39,90,226,59,168,56,73,43,227,171,60,251,5,66,24,207,129,225,168,127,243,190,108,173,215,76,110,107,75,120,242,147,252,217,57,234,116,1,133,221,90,162,174,126,61,236,200,53,105,71,155,217,56,85,6,214,13,60,119,234,225,200,186,152,215,237,225,105,85,252,240,252,38,75,220,200,6,243,144,34,127,161,14,197,107,63,75,235,195,72,44,27,244,129,243,201,59,241,45,173,62,200,145,232,76,142,208,183,15,77,119,157,26,157,170,159,104,206,13,248,132,68,229,234,196,252,168,229,154,203,44,177,54,200,235,132,93,52,10,196,60,152,226,220,27,98,85,215,82,144,161,12,76,202,47,71,231,225,223,105,35,201,195,174,188,10,168,199,141,255,108,74,166,226,33,4,203,54,202,178,27,127,250,86,181,225,246,70,219,65,173,49,214,202,71,22,67,184,54,90,182,251,202,40,14,235,63,201,190,75,65,15,33,62,81,56,157,55,187,67,3,223,5,188,105,211,72,202,95,229,207,20,1,219,121,116,56,5,116,227,97,48,200,192,252,86,238,56,125,89,89,89,100,76,5,180,81,31,33,111,202,211,182,51,25,81,28,239,153,125,85,67,149,136,118,157,65,84,65,43,74,86,81,238,45,7,227,222,145,234,95,152,157,225,22,53,47,59,189,252,16,40,26,171,155,247,98,73,206,206,218,9,241,152,213,3,15,107,123,100,86,78,2,200,194,8,78,101,235,150,113,69,232,13,102,131,200,41,240,126,186,238,184,20,62,218,235,221,116,53,44,20,219,104,254,112,139,81,119,100,253,105,53,62,247,159,166,75,128,64,51,7,193,108,154,115,34,146,127,75,102,17,112,81,35,33,255,104,228,11,97,24,252,219,214,122,235,2,28,34,128,252,220,126,248,87,48,200,149,102,191,135,59,48,111,142,210,22,87,41,25,209,90,114,67,98,234,128,53,45,198,155,116,161,66,14,216,226,63,200,18,7,20,213,60,221,77,128,48,20,142,208,197,61,210,161,90,77,80,146,220,80,168,29,93,171,234,195,182,134,136,225,120,206,94,147,141,52,199,5,155,74,143,12,252,50,79,254,135,78,145,222,143,150,128,28,137,206,79,88,83,195,0,213,182,223,225,201,191,235,235,39,175,202,211,139,11,109,8,255,251,237,232,33,37,250,169,184,42,115,205,55,220,211,160,190,225,201,208,87,227,181,15,92,123,111,172,104,71,23,236,206,214,177,119,77,128,149,238,102,224,147,48,143,82,158,83,179,110,112,12,75,86,190,48,208,14,156,92,140,55,64,14,23,106,204,140,48,97,72,62,247,14,217,121,31,224,171,233,69,177,129,185,71,17,87,96,138,78,19,178,198,229,37,235,51,51,208,149,100,111,39,54,197,126,215,245,125,0,18,64,157,246,4,183,62,21,82,209,182,193,74,163,255,99,143,38,119,30,171,116,62,129,241,64,167,205,128,48,19,141,208,126,96,231,17,94,11,123,106,132,252,127,95,4,217,84,100,231,9,56,144,178,55,92,107,154,194,164,113,19,93,117,152,188,49,241,135,95,131,177,63,10,247,179,86,47,153,63,125,70,239,205,3,48,196,135,152,123,146,5,229,21,112,255,72,4,180,42,148,238,234,211,163,111,223,49,176,36,101,182,121,145,65,242,151,27,181,100,235,212,127,238,78,165,2,36,188,117,89,217,137,39,32,249,156,72,106,48,65,177,35,119,166,109,125,93,15,74,133,194,177,8,208,79,4,23,216,37,3,20,67,12,40,52,11,160,213,96,177,234,40,240,251,19,126,81,186,153,249,204,11,91,78,70,238,38,31,243,13,156,49,165,95,148,218,155,179,139,30,216,15,153,27,164,59,189,173,159,141,146,16,21,167,183,161,203,82,140,66,150,182,16,73,40,176,102,55,118,132,173,249,137,117,137,145,90,53,86,164,24,152,171,14,64,192,181,253,238,22,204,59,115,228,173,155,232,15,108,250,14,135,190,177,25,54,114,152,83,38,132,125,185,243,134,112,168,170,99,100,155,125,107,46,165,146,10,12,243,170,39,155,195,220,140,129,9,27,178,166,144,112,200,134,3,146,228,27,60,217,251,147,93,72,56,196,158,217,177,53,113,146,111,93,172,7,71,165,196,105,120,164,255,79,158,235,183,45,61,139,128,87,87,24,202,89,236,50,129,135,90,217,225,115,211,102,32,22,124,87,167,76,209,47,193,179,5,176,1,172,115,53,235,4,198,69,17,146,1,156,60,169,171,3,154,137,1,8,160,180,39,33,145,194,221,167,74,225,147,22,226,175,161,190,155,99,104,36,234,28,206,255,153,106,146,140,248,208,160,159,129,189,81,79,151,34,57,191,19,60,238,132,173,126,112,102,40,167,236,248,169,15,165,62,167,248,117,241,242,52,190,179,82,62,174,253,135,166,242,116,101,164,25,44,212,205,199,182,51,26,85,54,11,16,243,103,183,145,84,222,115,193,84,191,14,243,49,214,76,187,20,39,29,243,173,156,181,219,109,64,24,75,52,179,28,160,231,99,85,33,44,165,96,91,1,116,151,203,247,43,74,128,179,172,198,31,77,89,11,160,120,13,159,140,72,217,110,79,78,206,233,178,98,50,152,74,216,73,133,249,217,70,75,56,129,241,107,234,100,37,103,60,16,188,2,190,11,70,104,226,153,93,247,153,143,161,19,20,220,168,207,59,231,145,117,83,136,104,18,107,25,84,26,105,116,169,98,24,122,32,236,228,193,206,223,235,29,238,49,143,225,2,196,58,61,127,140,102,14,140,100,86,158,130,245,106,213,21,195,130,77,170,38,87,189,28,239,43,9,141,221,172,71,101,23,117,196,97,176,152,245,228,11,197,252,84,206,70,36,202,196,205,27,80,137,39,25,75,180,73,162,224,150,97,44,115,24,151,153,239,190,250,64,81,124,193,49,199,158,225,239,216,251,150,194,11,43,136,66,171,93,122,163,101,50,248,76,30,251,201,114,80,75,69,109,212,155,11,141,217,118,95,15,127,174,149,147,216,251,178,89,253,92,51,157,16,128,60,144,26,219,47,131,125,182,76,241,164,209,6,26,7,92,85,220,173,245,230,208,98,209,124,70,173,192,190,132,55,211,201,186,183,60,108,73,202,134,11,25,98,22,219,173,173,140,39,222,243,91,17,177,81,168,144,244,94,105,34,211,227,16,134,9,254,20,51,4,182,243,203,82,63,238,89,246,230,147,185,200,52,129,113,141,167,177,99,18,247,119,52,84,13,203,187,89,98,35,178,30,13,149,205,77,136,197,164,183,202,225,132,158,34,253,166,180,170,81,56,53,16,116,34,149,120,212,66,17,226,5,193,175,148,81,251,230,23,177,141,43,79,103,153,84,172,51,44,242,34,237,188,74,225,118,144,129,40,56,96,157,254,134,231,14,209,110,23,26,41,253,29,33,247,80,149,196,100,34,23,183,198,124,246,191,174,56,254,31,119,127,229,154,236,190,38,98,101,91,126,182,201,156,27,210,62,101,17,18,95,17,62,112,173,218,95,8,203,29,169,3,23,137,111,219,234,54,156,50,148,31,227,60,56,205,74,105,149,45,57,162,39,83,232,38,150,169,204,161,15,212,82,220,124,196,127,1,123,135,186,208,13,210,224,127,223,143,131,107,123,201,10,21,58,99,135,64,212,81,242,174,16,20,198,65,72,42,58,79,59,206,26,52,133,57,223,232,6,119,87,13,47,214,82,42,153,242,77,203,163,205,22,188,0,129,78,179,114,86,63,119,183,248,180,74,200,49,174,239,118,170,130,129,69,61,251,182,192,219,239,214,192,255,58,247,26,49,105,232,74,79,103,145,214,114,231,134,233,230,182,242,244,118,246,117,136,107,207,19,107,184,247,251,123,157,189,96,101,189,162,223,179,99,10,86,165,128,163,231,16,244,57,68,233,20,250,104,28,166,38,49,110,177,66,17,127,187,199,42,122,137,238,193,107,95,247,227,189,113,10,75,176,213,70,136,141,144,164,87,37,42,23,127,141,164,183,78,139,218,128,235,216,244,18,237,172,200,24,113,21,112,117,16,59,41,136,9,155,210,169,170,75,221,91,65,24,147,102,178,110,106,220,193,124,222,37,240,191,119,132,54,85,182,115,221,35,234,48,168,174,45,235,227,126,189,190,94,228,240,101,211,112,91,127,57,151,48,255,55,129,17,139,254,252,80,114,75,182,22,51,188,91,109,69,192,230,36,179,138,232,162,3,131,1,137,52,56,241,139,77,224,236,177,175,210,192,80,187,135,105,224,116,81,229,132,151,223,232,67,207,191,76,55,255,26,58,42,239,48,161,0,251,40,166,214,231,173,40,122,99,165,8,170,84,14,152,38,0,60,172,198,70,127,95,75,16,127,6,6,164,64,141,172,238,59,222,131,224,43,38,141,127,96,100,62,2,30,34,180,54,230,3,150,5,231,193,31,96,61,201,7,121,144,136,49,68,114,1,180,193,165,67,117,98,92,230,45,153,167,120,227,39,220,201,40,218,176,242,79,255,176,197,84,44,219,188,24,123,109,252,180,10,54,56,205,152,158,23,34,226,122,114,118,86,190,135,145,210,139,53,111,80,254,12,33,99,114,50,69,174,102,63,40,134,203,163,241,201,210,132,197,30,194,21,41,67,111,169,59,137,176,140,87,223,35,219,148,41,17,47,87,132,177,195,184,155,62,44,57,51,61,166,176,0,78,17,239,248,132,24,90,111,0,114,11,243,116,156,217,62,172,237,169,184,102,49,203,132,170,173,228,19,92,247,110,129,213,51,246,166,189,117,14,122,133,32,168,49,250,110,109,130,233,47,207,247,73,245,53,4,163,18,37,68,143,96,159,144,46,41,170,94,167,114,150,192,69,209,251,219,13,111,213,186,98,240,94,100,151,249,137,215,40,31,202,233,102,233,87,154,45,180,231,125,239,156,180,218,112,223,97,62,42,141,65,252,126,67,80,247,250,233,208,232,35,192,160,163,194,226,126,10,45,236,6,185,108,216,204,37,163,11,79,111,48,215,146,155,158,134,141,203,55,89,61,222,33,78,82,125,74,58,124,11,39,39,25,125,19,251,109,165,69,192,6,62,4,243,172,60,180,97,171,114,245,37,98,216,173,83,172,42,223,203,123,98,129,233,163,55,50,102,117,207,223,131,8,155,151,246,17,163,194,153,249,69,72,100,93,139,51,97,70,143,174,24,21,44,73,67,97,203,26,232,224,113,226,185,74,242,203,51,164,179,209,188,168,1,102,93,74,120,214,135,191,193,209,7,112,218,199,145,10,92,23,239,226,242,205,187,159,126,171,125,35,158,53,118,74,19,183,224,31,116,118,13,32,211,205,92,131,123,48,181,32,124,7,233,247,254,24,251,109,189,0,184,187,80,73,194,94,100,239,81,170,145,20,235,132,230,56,141,90,22,151,198,88,153,66,134,20,94,237,62,58,110,218,255,50,111,198,109,211,202,21,39,7,30,238,147,85,35,154,58,236,112,221,70,102,211,120,115,74,109,188,70,229,214,191,122,134,120,195,231,217,122,35,113,9,110,154,50,82,32,35,111,159,191,205,52,223,124,250,77,32,228,68,131,215,255,245,107,10,80,105,104,31,4,173,207,219,31,219,171,182,182,254,211,181,183,202,185,238,165,167,38,248,72,193,90,249,154,165,80,64,209,68,160,49,226,93,135,143,48,97,211,47,187,29,120,160,203,115,39,87,245,227,220,244,5,60,57,251,126,42,117,244,81,69,98,77,242,210,249,188,19,130,253,198,56,95,174,249,187,185,215,132,16,226,25,29,180,25,54,143,69,121,134,79,117,180,218,210,211,236,58,207,231,69,104,95,149,166,212,59,105,131,68,83,21,233,177,143,135,83,237,99,3,20,58,123,234,249,128,199,117,238,163,124,52,215,100,124,76,146,61,253,192,135,196,87,201,115,149,98,141,214,85,252,207,188,13,34,208,166,93,132,22,39,44,115,121,203,93,78,137,69,196,253,197,120,148,36,21,208,5,95,43,5,122,145,41,160,12,117,201,143,36,62,133,73,185,73,185,155,194,182,166,248,96,33,9,112,7,42,39,42,203,253,23,196,161,187,66,234,58,217,44,48,7,139,47,158,58,153,179,83,189,27,100,164,156,234,199,98,117,100,38,11,24,163,169,221,244,159,173,191,177,229,194,60,25,229,142,239,38,104,95,145,238,47,214,188,90,21,66,126,66,111,210,228,101,36,242,172,130,97,234,90,20,62,166,38,11,198,159,44,245,249,131,27,135,234,87,83,2,62,185,253,129,60,125,165,26,164,138,148,193,87,246,201,45,72,3,33,31,191,29,45,33,15,238,109,8,39,100,38,195,128,83,7,133,205,161,144,113,161,194,75,111,13,7,188,92,227,251,80,96,18,64,26,145,25,40,183,204,243,127,122,119,214,146,16,231,175,187,101,92,23,25,172,45,195,139,252,212,135,73,86,24,33,203,30,64,143,202,39,238,180,143,39,141,32,30,65,76,186,57,211,14,143,45,98,183,16,106,103,221,249,6,53,137,24,139,142,183,198,247,95,139,222,54,254,33,32,110,206,70,243,213,3,192,199,172,149,164,83,182,93,148,177,50,21,141,173,13,238,107,195,127,67,110,37,112,43,142,183,230,190,209,160,162,156,23,27,134,24,34,52,140,72,249,61,178,169,148,8,130,66,147,91,31,208,121,252,240,86,4,49,94,172,145,170,231,175,155,91,81,34,65,35,19,119,54,89,16,204,192,75,121,73,147,188,144,117,13,228,38,41,170,216,212,138,219,190,30,66,160,168,25,44,46,139,91,239,138,252,75,214,254,70,38,167,102,27,83,199,3,87,193,132,173,198,46,20,126,199,149,77,169,28,80,101,104,137,62,96,184,186,195,156,232,54,165,152,181,234,109,221,187,146,210,235,81,120,213,202,4,54,76,73,143,91,58,186,245,234,169,42,230,22,18,250,90,107,166,223,111,105,64,154,164,4,224,90,136,137,59,115,161,111,33,203,195,109,85,228,153,230,42,60,71,72,5,2,62,18,247,95,210,226,191,18,86,215,250,188,187,220,235,252,237,222,248,38,43,49,68,167,200,78,234,221,147,5,179,21,224,63,87,13,134,86,163,63,36,111,99,183,191,107,252,17,109,125,244,237,227,124,248,96,249,123,151,124,55,89,15,60,83,228,51,167,78,178,149,160,185,115,84,80,74,205,223,140,130,90,11,7,178,123,40,235,140,10,228,159,27,22,21,27,35,97,198,101,3,45,152,101,159,133,198,240,50,167,96,88,76,87,206,44,39,249,11,105,101,233,91,94,0,117,182,228,62,63,40,7,175,93,108,94,109,10,13,105,155,235,242,84,115,42,225,207,146,64,214,155,15,160,204,116,101,205,129,106,90,130,161,1,205,66,106,134,110,197,2,121,251,255,76,57,17,131,177,22,249,53,191,239,3,209,175,23,202,194,236,120,82,27,150,175,201,140,218,92,66,6,242,27,242,72,21,153,249,76,147,161,201,108,133,37,82,63,157,26,16,157,157,53,227,144,45,33,251,159,166,102,14,146,8,130,61,71,232,239,55,149,154,94,62,201,196,46,66,64,182,197,173,177,174,129,184,239,93,144,26,35,78,229,198,0,35,11,0,24,58,31,116,17,14,148,173,217,199,57,30,154,70,63,65,205,96,139,15,161,221,167,15,248,53,144,210,247,198,28,89,183,77,185,161,137,46,60,33,250,124,201,6,162,14,149,173,139,246,183,196,97,174,62,140,41,85,124,32,241,157,180,188,116,43,88,101,206,143,162,87,136,175,53,8,137,29,26,223,233,139,150,187,232,66,160,175,236,60,249,74,124,88,0,169,71,249,158,190,158,10,136,161,14,192,129,205,123,206,139,139,194,116,10,232,178,229,135,29,133,175,175,159,206,251,200,116,49,111,179,231,204,59,114,82,198,44,18,188,92,104,214,214,0,99,131,131,20,13,139,95,163,166,89,240,125,147,162,92,27,236,208,194,108,76,213,90,135,100,0,183,53,71,191,95,49,61,227,177,149,62,19,73,102,79,254,208,162,75,217,114,173,130,116,114,179,103,102,51,151,84,216,208,210,52,137,180,99,72,124,128,249,247,136,183,36,28,249,242,125,70,239,231,22,75,183,222,194,216,180,98,166,182,159,27,186,214,74,253,234,220,112,80,103,58,215,113,70,28,68,149,92,181,110,119,67,179,179,9,96,140,249,194,72,173,244,144,58,9,141,246,68,237,118,179,124,164,96,125,30,196,126,104,19,176,107,25,7,162,89,236,206,184,139,167,166,16,55,67,7,93,251,90,252,86,252,171,140,238,114,28,106,253,2,64,26,18,192,199,145,70,224,41,158,81,211,254,47,235,74,231,215,176,97,187,165,209,79,109,189,21,14,209,97,193,29,254,42,24,157,72,5,143,9,214,54,90,86,243,143,140,12,163,2,158,213,69,48,232,80,165,123,73,197,247,8,241,232,198,127,142,153,236,153,145,20,27,64,72,56,14,13,147,102,116,211,20,44,176,108,13,229,36,230,81,206,9,197,5,42,177,137,125,239,52,138,145,92,76,16,223,134,138,221,234,177,91,177,210,67,1,151,117,176,201,125,211,227,144,217,180,31,53,97,31,147,33,222,114,225,63,236,245,62,68,54,30,147,134,96,110,84,124,209,201,141,3,62,115,79,24,228,194,3,74,218,184,3,66,224,170,40,123,37,121,61,129,54,53,103,197,43,89,135,6,26,104,193,193,136,152,56,142,183,224,128,35,138,123,231,218,184,64,116,133,134,79,71,93,163,18,65,127,217,137,72,42,147,44,193,117,255,58,201,221,139,83,224,169,171,21,200,243,196,43,229,12,27,96,110,87,50,136,174,144,220,236,35,210,9,136,71,10,14,95,205,206,230,46,210,240,140,197,31,1,18,188,0,238,15,228,67,49,220,86,132,126,70,124,204,88,118,84,251,214,36,171,200,70,160,93,190,20,193,149,122,208,201,60,231,13,227,143,217,98,120,101,241,47,166,37,0,246,166,53,179,69,210,170,111,102,237,39,29,58,140,90,17,30,66,50,240,135,134,156,130,216,158,96,227,238,43,173,150,62,156,252,12,213,121,200,99,178,38,253,248,51,29,232,51,139,88,26,160,174,235,4,96,47,68,39,65,224,118,4,246,129,110,151,23,33,196,101,107,18,57,33,181,138,239,175,105,157,49,247,51,175,4,49,223,166,210,239,121,16,164,212,230,198,33,63,150,165,9,54,147,43,215,241,224,55,27,106,204,89,39,184,161,80,49,4,115,240,147,14,244,80,211,157,188,47,240,27,232,175,82,215,194,147,55,86,12,143,240,196,252,206,171,147,238,96,167,220,204,222,124,57,43,217,33,94,205,196,224,116,99,78,12,233,159,227,1,76,43,79,235,217,146,66,161,211,175,94,65,74,199,243,183,6,81,84,203,242,106,233,76,173,158,214,45,43,108,174,250,106,136,126,230,63,14,251,213,18,71,87,50,64,255,236,85,183,102,109,45,1,174,202,9,149,185,253,197,58,210,45,138,136,51,85,221,138,73,184,106,127,134,253,72,58,18,180,62,151,29,82,139,220,202,116,64,248,20,81,96,109,47,138,242,186,193,36,58,228,83,194,172,38,0,252,218,244,10,112,115,142,57,210,57,11,64,200,229,159,61,193,101,132,118,218,80,148,208,24,56,50,42,216,65,221,198,222,42,94,40,195,189,60,175,28,71,25,114,164,42,45,8,67,46,142,204,238,25,167,37,150,221,46,11,216,39,161,104,150,116,113,1,94,67,6,9,155,180,85,217,5,244,160,99,51,203,177,93,136,13,60,29,150,143,141,45,240,202,86,52,252,208,169,251,4,6,159,54,129,123,18,109,207,1,191,79,38,187,105,43,96,244,160,246,58,53,1,126,98,82,106,12,250,65,44,103,65,155,146,190,0,201,249,32,20,57,171,220,149,156,114,51,66,148,220,137,156,113,120,32,169,126,124,13,130,177,138,31,55,46,148,240,128,29,71,141,116,145,112,8,66,189,190,216,123,114,164,94,213,103,242,213,46,100,240,150,169,179,251,110,47,164,50,174,245,163,245,59,14,243,8,35,82,74,151,19,130,70,32,129,139,54,14,190,35,131,230,71,44,133,253,187,52,219,118,239,235,58,76,31,196,252,32,242,187,197,157,187,55,29,121,51,214,250,24,234,46,96,133,232,102,63,43,191,186,226,113,189,64,205,186,249,119,43,113,194,61,250,58,221,69,191,75,14,152,187,167,243,108,156,124,46,5,218,175,243,118,7,240,85,167,144,192,213,61,210,252,162,165,162,46,86,124,240,63,149,35,88,159,198,71,207,56,140,25,144,133,248,190,191,241,252,13,124,234,108,165,9,106,44,119,178,102,193,221,168,140,143,125,102,211,106,41,163,241,103,12,131,227,10,78,64,224,131,209,128,108,224,131,81,196,188,208,57,0,65,7,171,245,92,68,97,155,26,19,0,220,173,153,62,182,16,55,19,229,89,135,80,157,145,162,168,60,3,54,77,8,252,62,78,45,97,13,187,5,95,233,221,143,244,218,237,9,191,191,111,230,19,235,185,24,229,133,236,211,127,22,70,243,186,237,63,6,52,140,155,111,172,124,143,130,20,198,240,17,48,164,10,74,221,17,240,102,82,73,186,66,214,132,28,226,189,253,197,216,71,13,102,76,54,192,250,157,250,97,33,169,125,119,76,18,127,148,89,55,79,41,27,171,173,241,40,25,242,210,152,51,104,129,66,79,162,178,205,127,78,159,148,90,244,237,62,200,220,157,71,215,30,45,95,17,166,151,2,107,156,25,214,202,113,205,64,70,182,24,9,62,176,176,190,16,176,188,96,117,242,77,22,88,50,108,118,138,246,209,82,199,143,160,77,201,121,197,140,194,143,8,181,195,45,95,221,40,139,214,14,153,166,70,195,180,165,102,177,227,237,193,79,231,55,66,91,102,116,212,200,47,182,152,106,44,255,140,122,66,158,160,250,117,112,5,28,227,9,101,161,115,43,75,216,160,129,201,85,4,155,212,168,94,163,160,204,9,102,25,233,102,160,184,227,106,238,100,129,31,84,122,126,254,145,223,210,150,80,172,229,177,248,245,3,169,238,5,16,2,78,51,54,207,82,72,227,99,136,26,105,129,53,22,17,45,214,181,195,68,36,56,169,195,242,5,8,191,67,154,4,98,246,26,112,153,140,77,237,240,2,154,115,169,245,170,100,202,110,18,149,98,123,104,24,71,192,232,157,222,215,83,47,36,18,129,246,103,237,227,185,218,144,30,199,136,151,160,138,100,74,32,166,208,86,67,75,237,132,120,166,153,52,64,10,225,171,2,81,131,86,59,191,48,93,62,184,125,186,164,181,232,91,66,146,242,21,173,53,43,188,74,248,215,108,185,224,167,76,81,71,206,93,12,235,166,22,241,224,190,133,235,131,111,103,60,230,112,49,52,171,86,194,94,59,123,115,191,87,69,241,194,32,229,82,37,247,66,83,202,39,30,54,213,89,3,78,249,44,22,248,167,57,0,84,189,32,168,147,103,6,140,148,202,187,193,37,38,180,46,29,166,57,72,223,230,106,44,108,111,251,141,251,89,7,111,191,116,203,52,57,144,49,241,196,170,155,145,94,130,81,6,8,48,239,173,230,55,130,69,187,163,225,66,214,151,106,237,182,124,152,252,164,152,71,188,138,18,156,234,158,96,75,48,112,107,71,163,19,180,198,24,225,112,151,114,89,6,217,49,26,232,78,138,51,90,69,91,193,126,130,54,20,217,158,121,249,61,85,203,2,97,83,109,237,170,254,0,91,197,122,244,126,45,233,234,109,127,179,19,219,93,31,65,76,94,19,176,192,62,20,225,161,144,181,212,117,211,254,177,20,119,165,4,191,21,105,172,116,103,36,198,101,166,240,111,212,21,87,239,249,26,153,242,52,76,142,34,251,237,81,66,187,57,122,29,236,37,110,21,148,230,218,247,104,63,1,234,5,69,199,73,134,157,172,42,231,147,224,75,141,129,211,82,4,89,195,246,70,171,181,93,183,55,108,159,166,33,84,4,185,111,204,210,203,121,247,47,11,38,196,128,175,73,224,158,13,7,251,219,162,20,164,80,64,199,241,117,6,96,69,101,173,208,37,165,211,107,165,193,43,31,159,138,214,247,2,33,12,191,208,158,105,240,17,229,141,41,237,45,38,45,115,88,232,28,191,188,150,228,13,47,17,235,94,149,41,105,96,203,124,26,222,106,9,189,50,92,15,120,136,57,57,255,99,51,112,155,217,186,209,181,137,48,198,43,39,230,86,230,26,217,240,223,93,238,195,80,220,79,238,160,255,161,52,146,25,191,179,0,106,203,39,179,207,46,133,153,151,239,88,57,122,189,135,89,178,115,230,216,10,114,143,251,93,168,61,169,202,150,202,196,237,75,49,182,183,125,110,19,34,1,136,14,89,81,155,227,118,201,69,250,152,109,216,132,250,88,147,48,2,191,100,195,211,13,126,162,119,72,133,229,123,207,22,23,212,210,63,155,150,227,57,166,222,129,67,70,42,85,154,245,247,41,193,230,95,156,113,40,103,226,86,19,6,181,49,124,103,224,189,223,33,119,236,24,20,229,68,141,154,5,89,177,163,212,125,152,33,38,48,226,24,141,151,158,51,86,207,22,139,80,172,113,125,82,37,229,71,24,29,22,151,195,95,177,29,49,74,158,121,217,68,52,92,168,158,88,196,251,22,3,155,79,122,252,156,221,200,181,70,100,216,71,156,175,156,86,2,231,130,108,43,211,119,75,181,114,163,95,222,24,246,255,186,183,186,101,37,137,223,53,194,47,117,58,55,235,209,179,14,167,242,26,134,221,36,193,38,118,184,207,96,67,32,145,250,154,128,94,25,66,185,48,57,213,130,222,58,197,173,252,78,101,199,141,206,155,94,81,157,155,216,239,200,168,141,203,59,210,55,17,55,170,5,110,70,51,20,19,17,219,187,198,121,220,48,135,101,52,185,215,244,4,37,229,220,138,211,126,144,244,210,14,194,134,9,176,26,52,128,5,94,173,63,199,171,196,37,142,16,185,13,98,224,38,105,153,24,182,124,179,35,177,69,226,224,127,75,236,2,98,7,44,185,3,14,107,156,129,152,51,36,29,203,211,203,108,162,74,162,216,89,12,128,9,112,14,157,147,3,227,248,177,51,228,239,231,213,231,254,82,42,244,137,106,99,170,156,192,66,71,139,213,5,156,125,195,124,229,130,190,205,89,225,241,254,176,95,30,219,40,248,129,218,116,222,75,183,241,249,60,88,178,52,92,157,156,113,232,162,36,107,47,55,17,155,162,70,224,125,82,84,211,203,26,49,246,193,94,207,161,122,216,126,138,16,206,87,28,38,45,30,196,186,30,68,206,95,156,208,218,236,93,107,125,217,121,46,223,4,69,183,46,238,206,71,72,167,159,167,48,118,25,0,159,147,140,99,166,172,4,113,21,161,52,102,54,219,194,90,106,50,6,156,202,21,86,112,33,45,53,6,124,162,83,226,178,246,1,165,167,177,190,237,128,219,79,114,30,187,31,146,10,157,251,80,124,108,191,233,91,104,68,35,156,13,54,123,191,37,77,245,82,222,206,8,246,133,27,217,87,116,7,145,65,128,81,142,250,19,137,207,10,217,88,150,119,183,30,231,123,9,189,145,113,150,247,204,148,101,142,228,144,127,101,122,157,153,221,45,112,44,139,13,223,94,18,221,245,14,185,252,132,117,15,173,122,121,1,251,109,2,107,25,97,29,180,199,11,124,161,138,37,92,119,254,245,118,34,128,28,100,200,80,5,114,99,208,232,126,215,247,226,193,129,111,229,166,12,107,30,67,118,84,156,100,158,204,44,28,118,134,227,10,22,153,126,77,13,134,137,18,167,115,62,98,60,182,179,66,109,93,146,39,135,247,137,193,45,175,156,83,87,217,63,250,57,154,128,151,152,45,35,43,126,198,229,219,126,200,145,4,236,251,153,196,162,89,73,134,96,119,107,128,190,147,228,64,73,220,100,124,73,203,91,213,77,92,68,50,107,69,237,110,138,228,193,175,162,213,78,39,118,105,39,11,196,157,25,195,35,53,250,121,123,219,197,179,143,206,30,210,251,106,231,243,37,84,55,23,7,30,84,11,121,92,53,9,191,28,49,57,237,112,78,183,12,215,243,99,159,238,14,246,197,136,207,69,0,120,99,89,37,184,54,94,128,204,224,174,118,50,226,59,151,162,115,167,144,223,213,199,4,87,55,193,10,212,169,238,242,254,70,213,252,87,32,245,18,157,79,122,232,143,103,31,93,140,93,243,91,156,91,223,136,12,68,98,200,179,170,185,195,112,27,104,3,205,165,28,186,174,118,57,189,119,144,158,95,158,164,143,139,58,87,217,43,22,68,43,126,240,70,94,163,225,233,248,227,168,70,198,16,51,205,239,192,4,124,244,190,80,130,188,253,65,63,201,98,243,142,139,238,115,52,164,188,234,11,203,33,66,111,40,174,113,78,139,135,102,209,122,166,53,10,2,10,140,215,139,223,100,11,23,208,126,65,214,52,37,98,93,37,250,159,75,209,155,248,86,107,5,114,199,254,105,179,240,132,18,228,65,136,188,180,168,141,149,43,234,13,114,25,92,32,8,212,172,186,194,234,241,77,20,142,76,140,225,110,176,248,93,52,69,8,47,143,25,99,166,56,37,228,218,183,234,205,236,237,168,228,136,179,145,123,254,230,182,37,220,223,96,199,45,24,147,73,86,254,47,90,124,89,129,192,199,167,216,217,62,148,163,46,107,74,67,155,206,30,163,44,42,238,69,77,5,86,126,151,131,136,59,134,63,72,23,50,35,228,75,48,172,147,4,200,35,217,142,56,51,159,145,237,51,218,27,192,43,193,90,63,194,218,149,77,69,58,68,24,177,235,144,245,52,41,241,21,63,202,204,123,60,245,245,147,59,230,53,58,179,177,6,108,72,142,101,202,171,147,1,238,27,183,145,157,7,29,13,111,137,129,183,185,196,139,126,204,48,220,237,170,227,65,153,226,170,245,241,69,250,74,235,39,129,115,94,113,165,212,140,219,239,255,30,2,150,71,167,222,250,123,230,253,102,110,67,175,23,73,166,0,144,47,148,163,151,221,23,81,24,247,230,191,244,11,1,206,112,51,40,182,33,40,163,61,107,169,167,6,202,202,72,255,23,102,172,225,38,148,226,88,109,43,255,21,145,157,184,0,241,95,26,253,89,42,53,13,149,184,8,74,173,119,80,63,39,122,131,186,46,224,96,135,125,146,230,186,215,105,91,230,163,169,125,167,150,59,214,137,125,94,22,30,51,110,143,175,201,170,44,185,136,253,28,105,89,77,41,65,135,12,60,237,170,191,75,127,88,149,34,205,123,6,139,121,217,249,166,254,165,197,104,144,84,48,58,172,21,122,128,85,199,148,36,114,91,239,123,1,206,8,169,49,206,39,142,97,137,189,224,169,198,119,13,171,201,140,49,157,103,118,88,94,210,27,126,242,245,68,55,25,204,114,244,247,64,29,145,137,154,56,172,22,62,19,227,79,143,90,5,12,201,194,154,224,71,103,79,31,119,20,146,114,219,19,44,92,21,211,69,49,20,95,47,183,25,195,60,209,50,238,182,244,59,9,94,112,27,36,210,214,7,152,57,84,87,219,76,117,252,173,214,2,188,162,120,141,43,194,108,127,121,25,148,205,129,10,46,39,41,144,243,52,218,147,187,37,188,247,50,228,177,63,51,214,17,10,240,24,244,129,34,87,146,124,5,230,163,171,120,234,22,101,103,156,68,245,144,114,132,132,244,163,47,127,235,219,88,243,187,140,196,153,78,126,139,116,152,107,147,27,119,0,2,213,231,59,70,73,214,67,31,130,51,71,155,189,211,225,165,140,83,24,36,56,202,105,50,33,140,155,216,216,209,252,54,156,254,20,81,120,206,235,241,53,194,44,177,128,30,239,26,95,124,88,90,21,132,123,188,158,141,127,241,223,95,178,108,21,221,145,222,26,192,180,84,129,78,175,117,146,57,215,116,10,13,53,12,252,227,64,32,115,213,68,143,238,155,225,101,184,132,28,92,127,89,232,1,139,160,185,99,115,92,29,188,211,254,180,85,121,47,205,53,199,122,73,153,119,188,74,163,229,129,90,48,50,178,91,189,168,116,38,32,114,55,89,132,116,208,124,128,113,113,16,206,199,26,163,212,71,1,250,155,96,53,100,44,246,31,136,208,243,220,60,176,23,103,88,245,48,51,59,225,235,226,76,182,53,49,135,126,117,23,4,0,51,62,11,237,65,252,21,246,193,84,14,85,217,111,240,108,226,134,59,194,210,198,214,9,245,99,101,81,3,89,134,225,173,80,61,204,115,250,25,191,22,137,42,177,155,159,237,248,200,39,189,1,66,189,88,8,198,57,47,194,59,150,74,50,244,192,145,124,139,137,9,88,183,226,179,162,219,55,201,222,186,109,36,242,146,104,134,170,9,120,67,123,240,251,118,184,113,206,203,242,204,29,95,103,160,139,24,229,246,174,44,232,1,92,51,119,121,192,74,200,193,169,150,115,168,56,37,31,105,175,166,10,183,252,135,115,233,34,0,229,124,183,246,177,143,42,237,125,2,142,154,240,49,228,213,15,77,123,202,79,84,0,147,189,200,161,106,243,41,87,86,158,216,240,246,100,112,9,91,213,220,206,108,190,57,220,218,99,189,47,194,120,28,127,254,169,178,91,243,109,75,134,210,210,244,242,159,54,217,20,133,68,233,153,234,101,91,233,30,96,171,224,92,91,176,236,182,188,20,131,21,122,84,104,171,14,236,252,249,75,212,235,191,95,11,62,141,94,241,165,26,219,173,197,153,214,168,223,240,94,213,113,148,95,22,212,203,134,117,232,60,147,51,11,201,54,4,81,122,170,58,150,209,147,128,196,78,68,78,148,160,114,198,127,162,120,180,68,133,22,76,101,119,11,93,246,9,232,183,127,140,173,92,221,236,51,178,45,217,246,70,118,91,129,102,24,199,252,7,6,116,81,43,240,49,115,77,164,134,23,10,184,92,26,223,238,174,254,108,5,221,29,205,3,38,30,51,143,196,202,21,102,228,51,105,45,191,54,175,140,175,135,132,56,183,9,116,20,68,132,18,220,233,176,239,82,87,160,87,75,33,255,121,193,156,78,230,23,79,64,52,198,99,148,130,106,107,8,203,26,34,248,194,178,123,242,238,250,69,219,168,219,185,118,64,221,220,7,62,58,172,34,161,85,252,155,52,152,60,87,103,183,167,226,234,225,170,247,90,38,143,81,89,210,156,20,60,194,148,113,179,171,5,77,184,78,26,208,131,200,86,18,46,116,74,134,61,119,29,194,3,117,40,80,168,90,103,191,42,184,95,218,91,28,155,54,146,65,95,188,105,77,14,205,75,249,117,46,221,98,224,169,93,190,83,43,182,146,208,7,135,154,99,250,12,2,189,246,105,220,172,175,69,1,167,218,186,57,136,247,112,149,221,32,11,202,229,160,52,60,200,208,193,198,75,246,250,53,55,150,176,139,93,85,222,206,205,111,9,73,162,186,211,69,140,188,136,164,203,223,18,225,119,181,234,138,60,23,112,75,105,15,203,7,125,177,246,31,45,74,151,48,22,139,175,136,183,250,161,111,94,119,158,113,175,140,79,29,122,65,55,233,80,125,200,31,209,18,35,82,3,116,190,125,208,46,253,125,100,73,160,238,5,244,38,184,200,7,167,119,122,165,28,250,26,52,110,188,151,63,208,63,248,94,165,164,111,163,146,32,37,5,60,85,192,27,61,24,60,161,222,0,4,254,155,189,84,196,0,157,35,12,162,103,138,192,135,38,45,40,41,69,63,30,177,222,41,253,200,54,63,230,237,20,103,172,23,99,192,215,2,181,198,52,12,1,157,162,169,147,206,27,237,188,158,40,214,164,233,240,100,201,245,24,178,38,205,66,140,166,43,132,117,143,233,22,167,190,202,18,188,127,240,184,49,182,87,84,214,121,140,169,20,29,122,133,69,18,168,61,132,146,108,35,131,109,86,101,183,150,34,77,90,194,24,46,232,28,48,183,206,47,100,61,163,165,74,17,92,27,210,106,16,222,186,117,41,103,197,144,3,27,9,248,132,189,88,83,122,219,49,116,2,50,30,40,205,76,130,35,126,83,228,228,138,171,171,135,39,196,227,87,106,235,241,239,86,179,253,11,23,99,7,66,41,158,178,157,76,234,6,5,214,254,184,155,181,84,197,165,122,251,119,249,236,166,219,144,14,253,20,200,71,185,128,249,58,15,196,101,206,51,124,190,50,159,255,10,172,123,168,253,230,89,10,236,71,194,62,129,71,92,165,85,0,198,135,157,141,191,50,13,140,37,124,110,249,46,46,25,251,68,145,8,18,120,51,137,142,119,244,148,246,141,26,132,163,135,241,35,159,49,77,209,163,230,111,6,242,146,195,49,170,2,124,194,17,165,42,155,254,34,50,37,48,67,234,117,90,102,69,129,61,195,172,78,87,34,46,79,146,168,210,166,122,231,226,222,204,251,20,75,223,196,242,130,34,225,110,75,207,175,78,24,239,45,171,104,198,59,0,19,49,11,243,112,43,250,158,62,80,155,237,46,52,188,185,245,171,68,197,202,251,110,93,211,94,67,191,87,157,87,233,13,61,47,52,206,80,194,167,66,67,198,170,244,247,174,171,50,79,255,184,161,14,254,202,162,162,254,221,148,221,251,90,102,154,71,98,61,150,1,32,250,227,57,240,168,21,174,152,107,235,75,2,198,35,117,161,148,210,231,214,184,87,241,102,16,184,144,221,165,158,108,17,177,46,228,156,159,149,123,171,239,250,40,10,62,189,159,144,124,7,64,76,122,161,214,158,46,206,191,99,142,189,68,40,168,172,65,88,130,102,169,121,107,188,201,117,35,139,212,14,176,77,110,172,197,14,238,254,189,108,234,224,228,68,226,121,230,183,185,224,25,14,142,86,3,2,21,133,116,109,24,125,214,126,192,236,107,42,30,208,247,43,102,62,205,11,213,177,80,163,92,245,82,101,244,192,151,191,169,102,204,190,167,232,66,226,12,115,238,131,188,181,235,30,55,68,17,186,125,64,121,44,39,147,240,53,20,40,101,224,109,239,226,32,115,253,200,113,202,118,207,81,168,138,146,224,129,38,168,181,120,87,225,170,24,6,223,254,59,48,103,66,191,112,18,100,232,149,121,191,132,39,231,12,223,111,202,150,238,150,76,143,41,37,183,222,8,16,24,33,99,101,144,218,10,68,70,133,97,95,109,42,67,13,102,0,93,189,206,41,149,160,206,101,195,209,76,22,231,109,76,142,113,78,222,63,202,227,65,140,154,29,47,96,41,58,77,137,107,249,152,7,126,53,105,31,221,134,107,150,14,18,108,110,152,91,57,88,146,199,220,12,79,116,220,134,180,176,224,71,97,52,154,76,94,230,58,14,196,154,89,27,162,219,96,227,91,143,175,92,36,179,222,30,59,163,32,250,146,96,163,83,134,33,18,27,99,127,113,171,35,52,143,96,219,71,71,254,216,30,244,75,88,241,242,50,213,1,83,56,154,152,153,219,130,166,175,82,10,125,111,96,137,38,46,205,11,85,195,29,184,117,250,218,58,49,10,40,30,139,211,81,157,249,51,33,100,201,34,96,197,189,206,48,180,50,2,111,154,109,10,90,116,189,224,85,45,153,10,96,210,142,179,131,174,213,131,9,90,194,235,113,201,152,223,253,134,198,136,215,196,121,114,145,127,197,63,226,22,10,124,149,177,37,12,217,218,113,9,235,142,49,103,237,98,82,140,8,127,97,56,61,78,76,142,106,216,56,78,153,139,60,223,243,28,34,38,199,137,132,50,118,151,58,141,192,20,249,138,53,114,177,45,146,78,147,234,123,244,61,157,119,7,88,41,82,17,102,213,59,93,79,45,40,157,139,219,81,12,134,18,77,1,101,45,228,155,66,227,243,242,202,71,136,205,94,102,239,237,253,62,207,30,222,178,58,135,219,74,150,232,27,209,251,37,198,33,83,209,39,249,183,21,38,213,39,143,198,149,91,161,250,193,43,45,233,70,234,118,173,231,180,151,157,138,7,167,198,81,194,51,164,200,83,56,176,121,167,225,108,50,245,125,137,148,215,111,59,19,64,109,5,114,176,218,137,186,235,94,254,156,96,194,168,34,159,84,171,68,70,215,155,148,244,240,11,54,128,75,56,161,201,231,65,137,194,113,32,89,201,13,141,169,131,94,198,168,132,135,101,50,165,181,8,159,184,15,19,74,16,105,43,25,168,214,106,76,164,64,91,12,74,22,16,124,27,121,145,188,125,255,96,131,33,245,145,180,29,62,194,137,30,62,243,129,77,13,158,163,117,162,206,61,236,135,244,220,166,174,217,73,139,0,254,201,26,125,241,33,68,187,155,235,119,25,72,196,151,8,255,8,84,250,43,102,204,134,121,186,123,144,48,2,235,7,229,41,190,150,181,169,203,226,194,118,180,182,162,220,222,14,52,114,197,229,86,207,201,148,241,246,69,68,231,8,57,6,21,171,44,83,134,151,83,25,48,142,91,248,21,21,213,9,104,208,21,12,133,100,100,144,124,237,193,56,180,34,39,246,232,53,212,121,61,127,221,103,74,114,150,223,11,229,210,6,76,40,95,192,199,167,100,100,64,117,44,73,13,187,42,241,47,212,35,164,55,64,85,88,41,102,68,165,110,72,100,66,38,33,14,166,233,157,80,35,137,1,69,63,111,169,42,19,65,190,106,104,216,90,154,147,190,183,207,177,145,142,190,213,148,10,228,251,99,58,72,148,192,227,20,1,79,110,181,47,89,218,133,7,75,111,229,49,60,97,179,158,28,51,110,139,80,56,147,33,182,227,153,92,32,1,241,44,181,143,24,16,252,26,129,134,63,65,186,1,160,90,254,21,88,43,220,101,222,156,214,211,98,172,42,254,193,103,147,61,229,181,85,228,223,127,163,201,157,106,97,82,251,201,89,32,245,234,92,103,151,70,111,44,210,74,166,88,95,204,82,185,9,218,72,146,27,181,139,97,122,22,228,206,84,237,87,140,101,100,110,216,186,226,110,186,109,140,162,59,52,3,26,96,176,41,84,66,47,216,100,110,106,2,55,106,165,232,43,156,42,193,122,42,74,224,96,101,41,240,141,4,88,29,113,31,121,80,196,152,15,234,154,70,129,228,97,137,99,89,108,64,143,32,111,199,220,209,192,20,24,80,192,202,191,169,156,133,210,36,179,17,149,67,213,52,180,176,134,253,181,179,174,87,217,236,254,162,137,201,192,88,23,89,195,231,73,182,226,224,149,99,172,221,135,5,241,132,86,236,118,69,50,108,27,103,65,17,127,75,11,160,71,85,227,148,153,62,103,83,250,192,254,215,123,252,157,8,112,132,210,193,21,244,168,131,44,69,226,190,243,10,225,163,84,190,118,32,19,193,234,220,32,188,74,90,197,143,70,191,99,113,186,143,49,131,109,253,62,234,221,183,103,238,89,65,67,11,230,9,222,24,95,129,14,228,125,126,166,49,29,239,36,39,124,130,203,200,105,29,231,182,43,1,179,193,103,230,251,205,22,182,65,191,137,110,165,113,180,60,209,87,212,7,69,241,130,157,125,59,225,89,244,120,134,142,170,92,19,65,251,87,163,83,32,185,163,202,187,191,34,192,183,186,236,30,222,225,180,237,142,162,77,93,190,100,248,70,134,164,253,105,255,142,189,83,50,161,225,223,241,240,252,170,90,122,221,22,108,187,81,31,252,76,218,238,217,175,90,110,37,190,8,65,147,181,160,202,39,24,230,218,92,233,102,123,98,72,215,163,152,111,198,25,215,60,213,1,254,4,168,45,13,40,238,142,158,60,70,241,144,183,215,236,146,149,13,234,215,133,3,112,135,7,8,40,195,214,105,244,172,246,200,198,238,153,112,100,59,137,18,122,9,204,17,41,181,111,41,61,21,160,16,170,194,218,178,62,88,92,199,233,200,24,70,246,142,224,164,200,210,237,216,75,100,45,115,160,117,92,38,226,170,215,156,203,215,210,248,231,199,216,248,161,125,167,132,103,180,186,9,249,4,154,16,237,107,80,28,27,235,150,39,210,201,153,66,17,97,165,29,15,167,130,23,77,17,106,160,90,248,47,219,164,20,127,81,248,1,36,254,22,50,208,65,145,45,220,160,93,16,45,62,229,177,187,144,167,142,26,248,232,6,191,77,59,136,49,2,33,116,66,65,146,218,44,111,73,2,222,99,111,24,180,41,67,103,39,216,168,240,207,142,34,241,86,17,173,37,58,64,186,213,98,181,151,159,141,26,22,31,45,92,64,9,10,26,76,181,236,145,18,8,30,219,158,183,71,138,134,56,65,70,34,140,141,13,54,245,29,155,227,200,183,113,40,113,203,86,214,2,162,90,237,5,247,2,186,149,205,73,75,106,255,178,8,39,126,21,96,43,117,216,10,81,98,244,208,25,252,177,189,21,50,204,13,115,42,29,115,2,10,234,207,168,29,131,228,241,82,183,158,85,177,161,142,249,81,208,74,7,73,61,160,142,153,121,63,78,230,152,77,38,100,58,119,15,102,23,145,201,189,165,77,147,230,208,2,84,68,22,86,13,32,68,58,88,73,8,48,139,117,27,222,40,32,182,33,168,89,188,113,162,162,146,225,102,118,158,53,22,82,149,184,240,92,212,243,40,50,170,149,147,223,104,185,45,162,20,59,162,173,157,5,224,233,8,159,219,28,215,102,178,59,121,254,199,162,199,99,2,69,53,6,16,218,9,6,241,44,220,188,45,208,250,244,235,250,209,70,110,222,198,183,219,47,135,143,170,11,226,178,201,194,8,0,115,63,105,158,9,227,172,16,176,218,211,18,70,236,5,109,35,119,143,218,145,213,190,153,247,240,232,191,61,9,58,130,175,235,45,122,195,207,43,194,102,133,91,46,230,18,78,212,122,114,168,4,94,120,96,72,18,12,142,191,141,105,202,78,241,114,85,34,238,84,11,10,254,50,188,122,76,216,117,121,110,3,95,91,62,253,60,174,139,195,120,183,220,61,229,75,22,220,190,134,216,68,90,111,184,152,40,130,43,39,76,144,94,215,83,252,62,127,27,6,175,158,50,87,41,85,95,32,24,14,193,22,92,54,156,254,77,61,50,7,243,25,48,156,89,56,17,33,107,135,110,160,52,80,216,55,217,98,40,102,1,34,70,233,200,205,172,234,156,17,180,123,113,143,67,81,224,51,149,12,213,251,3,2,63,30,249,181,254,120,160,155,133,96,137,181,35,5,182,121,214,39,128,129,237,203,19,137,24,93,101,255,228,209,34,58,241,253,187,131,60,8,241,178,36,11,26,109,21,150,214,31,242,19,60,118,147,158,111,23,164,168,73,67,92,231,211,6,86,222,242,248,107,142,231,119,143,1,168,27,187,91,70,38,230,162,216,232,152,83,71,41,183,182,189,94,221,128,7,217,182,42,49,232,20,23,3,87,95,213,181,137,117,14,161,52,243,122,183,193,90,134,182,58,222,179,72,150,241,129,197,216,227,156,20,75,90,202,71,128,15,137,242,183,117,188,168,252,39,243,76,167,222,12,190,250,197,206,164,145,191,47,206,24,20,40,253,36,4,220,72,143,199,19,105,30,48,219,215,196,37,15,182,38,220,134,239,35,187,29,230,68,215,139,220,215,90,25,184,246,196,149,239,249,142,248,63,141,205,161,28,87,142,170,237,214,67,142,251,97,163,163,242,208,139,28,201,5,249,160,111,232,64,231,207,201,197,196,206,92,127,71,17,57,48,200,25,226,176,113,210,162,108,233,45,224,15,40,196,161,187,228,55,88,74,235,30,68,12,209,70,87,243,159,85,208,70,192,75,111,14,15,239,6,234,134,248,30,113,51,255,128,43,104,82,6,158,241,74,19,174,199,229,132,238,6,70,145,96,242,208,185,17,12,251,210,13,113,233,186,188,29,9,195,244,71,62,26,195,82,44,209,10,230,93,188,92,234,241,145,115,67,77,67,44,210,249,228,5,84,43,160,77,103,214,59,87,195,200,20,129,254,173,229,229,37,115,254,49,72,119,145,188,255,12,95,191,110,239,124,12,213,234,217,4,211,133,39,184,242,103,223,13,5,50,56,74,214,135,66,130,62,223,167,91,175,30,40,134,82,42,167,175,169,33,40,205,88,123,104,96,189,142,226,130,73,0,60,121,128,225,203,146,1,170,4,93,235,72,243,97,77,129,92,246,173,53,161,138,204,83,70,234,80,223,20,176,62,149,150,127,141,182,196,163,80,117,13,31,248,64,166,35,112,96,44,221,70,128,124,229,74,60,65,83,15,20,135,165,184,82,153,163,153,145,137,168,21,68,140,120,76,239,1,57,32,133,38,158,157,114,92,79,139,129,100,233,109,73,206,6,164,101,18,250,41,214,14,185,87,241,153,142,116,3,55,77,138,149,123,112,38,59,191,132,156,136,205,108,175,236,117,66,107,36,241,192,147,149,227,116,253,26,209,34,134,94,214,68,212,25,142,117,207,151,32,13,101,187,154,38,54,165,162,58,254,142,54,86,89,13,232,46,36,31,67,169,250,183,168,205,55,163,165,77,37,211,28,12,51,80,99,47,117,190,69,215,83,246,24,48,152,252,50,167,183,242,94,21,63,211,171,23,199,4,160,172,57,57,92,128,50,52,174,87,77,255,17,221,149,165,195,162,43,38,226,27,221,101,124,188,82,226,222,49,132,246,31,27,81,255,205,69,176,163,195,253,83,47,80,99,157,132,223,160,92,39,120,73,149,51,171,255,67,218,107,160,220,58,236,28,119,180,1,82,24,146,160,44,200,70,141,109,254,12,126,229,95,99,96,3,216,221,136,205,113,142,122,186,243,183,255,22,253,97,176,39,222,179,209,180,233,133,72,37,54,158,28,65,95,13,1,59,153,193,87,230,128,104,160,201,205,2,196,6,125,232,155,188,65,83,240,126,145,178,63,143,0,240,193,78,184,2,226,82,240,49,22,50,167,206,196,168,121,68,212,156,249,154,95,24,93,83,113,168,33,14,246,208,135,139,78,122,101,123,8,177,97,182,122,128,106,140,8,192,100,143,88,196,50,29,207,215,143,65,120,133,133,118,94,128,12,106,130,195,165,203,112,192,173,166,222,59,23,34,6,82,131,16,84,214,205,87,208,140,201,182,166,221,131,122,181,85,150,65,139,133,103,23,179,159,231,7,175,204,95,130,131,126,45,155,135,76,69,145,54,197,251,173,9,206,46,189,122,101,178,24,17,52,231,121,151,60,255,66,47,5,0,134,235,185,232,129,137,35,158,3,110,230,211,73,61,209,224,71,153,55,248,61,100,233,170,140,66,27,177,253,40,208,209,143,4,27,108,105,166,136,60,8,218,119,168,182,107,8,119,5,118,31,219,43,94,70,182,91,68,254,135,245,212,250,26,105,156,109,180,133,177,249,140,89,130,79,55,31,123,18,154,42,191,139,9,240,237,151,107,173,188,134,243,132,118,79,249,197,52,29,174,60,127,48,203,213,101,118,178,117,92,200,49,217,119,172,213,150,231,103,134,168,200,159,174,105,85,8,72,53,243,196,179,102,171,173,207,190,134,186,250,180,231,155,193,203,81,248,175,8,196,145,73,186,178,63,177,60,238,12,42,169,79,173,245,76,171,131,19,102,237,156,201,116,42,209,167,158,198,227,114,197,227,182,212,229,151,110,140,149,239,82,124,137,145,167,26,54,159,102,237,132,139,121,181,115,78,145,179,231,40,243,114,107,190,126,230,152,86,21,43,130,126,87,172,107,120,215,174,119,95,238,138,107,162,109,30,0,156,48,191,59,137,171,39,151,249,219,16,202,29,186,7,225,198,202,213,119,26,30,46,66,61,154,127,212,160,121,30,139,137,77,16,197,1,225,23,181,190,52,124,88,224,250,45,111,131,115,99,26,188,227,244,207,13,101,230,130,96,187,90,109,141,203,246,150,213,238,2,180,162,199,113,129,255,97,7,65,101,37,145,166,70,193,39,68,86,45,6,162,80,189,182,147,237,204,108,173,114,12,139,6,79,110,178,50,39,17,113,41,178,217,61,88,132,240,93,181,152,170,7,71,170,146,115,177,209,87,215,16,157,38,76,45,46,220,16,103,58,125,32,153,241,187,154,232,13,56,84,165,56,94,8,6,118,36,14,96,65,93,68,50,208,97,85,185,103,1,161,83,67,194,38,128,76,181,204,102,151,40,72,219,119,58,243,206,0,99,50,157,241,110,31,75,39,89,181,28,80,34,47,54,40,145,0,60,100,212,148,16,35,19,189,130,103,237,1,19,109,241,72,134,148,103,72,23,209,106,186,211,41,196,18,76,23,75,122,68,251,50,11,252,232,52,72,57,5,52,226,217,252,184,71,71,112,106,214,93,60,250,235,235,115,148,64,183,222,82,158,135,135,145,153,54,138,126,116,216,66,235,51,100,7,1,111,11,231,57,153,174,195,76,173,195,2,137,227,217,61,109,233,31,68,5,179,235,72,80,16,191,118,37,76,119,131,246,39,251,58,127,172,229,32,135,167,216,216,39,54,7,180,45,236,44,47,186,218,5,45,145,201,222,24,126,214,198,237,218,245,74,159,119,201,233,27,224,213,175,46,43,252,104,209,254,53,126,25,166,190,157,66,64,23,226,4,74,69,28,42,238,195,233,33,1,64,116,16,110,32,81,97,57,242,250,108,13,200,31,184,115,30,190,65,111,225,197,90,215,174,221,193,216,165,11,16,3,153,141,181,161,223,213,141,64,243,41,33,65,208,245,48,203,171,242,234,120,183,57,60,85,83,188,148,249,94,62,178,164,119,223,137,180,49,184,166,120,134,127,76,230,216,208,161,5,42,237,196,235,114,222,23,134,110,242,244,163,1,42,228,3,251,93,156,48,46,154,200,19,163,205,213,250,142,212,14,156,210,48,20,148,235,204,232,128,21,3,100,38,184,230,249,138,117,207,253,60,79,102,174,115,184,21,102,194,116,47,69,98,110,200,73,248,186,30,220,75,239,155,228,138,141,255,84,179,127,17,124,167,107,102,248,93,59,11,170,167,110,129,228,140,41,111,215,131,169,31,210,192,131,220,50,29,241,34,235,141,60,96,178,83,126,109,14,186,209,248,63,130,108,186,180,105,95,192,234,29,87,8,197,153,103,55,13,10,116,247,40,153,54,84,199,120,69,98,185,228,4,234,107,80,168,240,218,9,114,58,196,150,245,120,244,210,164,160,201,55,20,40,135,138,179,149,228,199,157,192,174,190,79,35,154,208,104,215,44,229,241,125,186,156,42,60,224,60,98,79,40,64,126,207,165,212,10,115,54,25,33,126,58,236,50,194,209,149,85,111,178,89,79,15,60,227,54,174,229,243,135,42,102,50,171,254,95,21,247,31,125,0,215,95,9,254,115,158,204,23,106,103,28,139,202,110,125,119,242,110,213,56,152,116,42,49,235,231,28,252,0,141,119,191,200,51,122,183,74,56,200,99,174,153,239,174,227,16,247,241,53,17,43,147,201,28,236,24,172,158,183,250,239,232,109,178,138,191,154,85,92,101,93,173,175,120,149,115,204,109,250,109,193,172,203,85,254,72,122,109,173,97,223,35,161,59,23,39,177,164,124,186,70,76,36,143,143,79,179,160,167,125,30,112,233,209,141,126,247,37,119,77,159,6,86,22,186,250,64,148,109,116,69,157,161,219,213,126,74,234,55,4,74,150,191,164,59,229,208,73,147,153,74,155,93,93,177,111,177,180,36,107,46,26,222,118,125,41,31,110,95,84,199,96,81,223,99,229,230,111,208,187,44,207,189,197,162,155,118,66,246,102,5,157,180,61,121,27,171,235,38,194,219,47,109,32,238,247,114,130,158,184,151,243,155,87,210,50,16,172,39,124,229,145,237,44,49,206,229,30,118,171,255,129,65,10,175,28,62,65,30,217,20,113,253,179,149,240,28,118,112,140,20,237,39,7,159,242,230,64,144,209,53,33,213,116,176,141,135,111,225,244,248,107,202,235,131,88,130,60,113,17,151,144,193,21,155,78,5,33,221,177,64,101,141,166,1,217,83,16,24,8,33,203,8,73,180,252,201,36,37,193,112,158,81,36,62,12,87,125,150,121,19,39,92,191,173,210,244,36,77,195,88,140,26,156,4,231,27,111,89,251,35,188,185,246,75,176,127,162,75,144,137,255,124,36,161,108,144,154,177,88,19,197,21,51,61,242,175,177,115,118,58,158,40,174,196,158,97,198,184,209,36,126,232,71,189,204,186,7,102,36,124,234,204,89,172,220,192,86,101,51,175,40,9,191,17,115,155,117,200,237,22,138,77,48,250,240,160,224,117,133,170,182,144,213,211,213,2,243,145,65,254,0,2,248,48,33,249,80,119,29,108,76,228,213,3,143,250,23,23,131,183,155,60,55,214,27,114,225,198,150,10,35,148,123,109,118,26,2,65,205,51,165,231,113,146,183,118,99,110,128,192,107,84,128,130,68,16,88,195,165,35,170,219,153,195,92,132,226,34,20,77,81,240,139,150,107,214,77,155,204,106,79,19,168,44,71,198,240,87,142,60,44,60,246,5,116,90,243,72,82,123,206,123,164,157,159,113,100,46,227,97,151,247,172,49,26,253,214,112,110,75,191,20,199,178,121,153,73,146,167,80,165,179,249,104,118,42,76,8,126,200,69,25,1,35,35,219,85,218,235,253,164,63,211,195,178,60,208,120,222,151,167,79,238,35,131,109,53,18,149,50,40,14,206,218,230,111,82,234,124,19,223,6,18,94,196,199,189,219,79,203,3,86,63,184,11,70,220,145,70,39,204,13,70,25,105,99,18,2,0,24,161,197,244,35,162,11,157,34,54,196,92,138,255,30,83,77,170,69,196,207,11,28,60,155,7,88,6,248,72,159,21,242,123,4,244,230,249,74,32,130,186,174,143,2,140,24,130,73,170,186,195,129,0,221,95,213,21,27,147,128,194,103,91,111,210,249,82,200,180,140,107,187,79,132,95,135,105,220,39,219,47,101,130,232,19,153,84,96,21,214,227,184,212,26,88,77,22,173,250,215,51,120,214,55,206,86,220,178,39,170,15,114,12,97,98,239,4,124,47,250,230,133,149,196,82,209,165,151,0,207,30,106,133,62,251,241,196,196,47,179,145,179,2,155,15,5,165,22,67,52,207,39,246,123,134,219,252,174,231,168,82,8,7,192,229,168,45,215,86,100,235,111,169,107,12,249,89,109,86,160,142,181,238,237,223,92,168,130,150,236,224,116,222,45,18,13,13,164,73,38,27,208,24,138,45,80,4,148,58,149,54,128,230,244,22,230,218,179,87,51,104,223,178,9,209,228,14,206,192,249,41,82,34,115,235,125,150,192,196,1,165,252,62,83,243,157,37,218,134,192,149,232,139,145,253,205,51,17,97,192,121,157,60,181,170,126,156,5,44,196,235,223,123,170,2,118,228,255,243,8,132,196,221,30,242,92,159,112,180,131,51,25,126,253,184,7,4,110,34,217,37,185,91,186,44,77,80,104,181,58,171,9,210,180,17,119,8,141,229,247,64,62,232,121,118,112,133,52,173,5,202,94,170,37,212,28,222,193,97,51,164,107,197,181,220,102,52,58,47,147,194,179,174,14,89,19,221,145,39,174,86,249,64,89,192,101,143,207,156,186,210,1,137,143,225,13,38,98,59,92,137,53,31,64,212,100,157,144,100,131,3,65,115,94,185,87,13,25,176,45,184,207,19,250,197,231,86,217,51,191,125,60,11,95,125,105,236,148,166,54,6,42,0,150,180,138,38,30,235,72,106,14,217,69,184,242,46,197,173,38,89,234,41,197,213,165,79,86,118,231,142,207,69,207,108,20,53,179,160,231,84,99,156,253,80,13,15,65,18,73,160,149,31,76,124,141,4,48,207,86,81,87,66,32,121,213,115,116,230,240,201,247,195,159,66,154,244,180,174,14,101,84,3,66,175,40,177,65,194,101,162,234,26,55,222,21,72,164,219,243,129,30,172,104,212,50,6,152,90,233,235,35,221,207,165,225,44,109,74,127,123,173,56,87,209,84,211,48,214,123,5,105,101,78,188,169,175,36,172,214,19,232,125,217,130,252,99,237,244,61,173,193,82,209,216,57,13,12,202,82,193,78,70,69,206,74,240,191,91,25,179,254,242,177,68,23,139,165,101,32,52,246,25,212,240,38,237,147,60,156,190,36,3,56,163,125,228,107,228,6,235,44,250,90,92,77,158,36,217,168,161,77,26,49,125,99,103,191,115,41,120,16,231,243,69,108,169,115,81,127,195,48,164,132,75,173,147,62,148,220,3,189,186,165,200,86,60,18,172,193,207,129,196,167,69,181,134,232,130,109,48,76,133,202,38,184,207,153,39,149,26,4,242,77,59,193,254,102,222,99,68,91,147,245,252,14,111,57,224,121,244,233,148,97,66,37,162,181,44,60,144,184,181,187,204,143,33,120,225,243,226,97,190,168,25,134,240,146,145,251,166,104,183,243,126,93,104,93,84,55,148,49,84,30,71,204,203,236,226,179,113,247,64,213,92,207,126,35,130,231,86,232,149,34,79,127,8,155,120,228,29,247,142,10,151,52,57,180,40,56,93,99,171,253,160,143,201,101,183,204,59,240,23,208,83,198,151,231,231,147,28,110,4,156,102,57,157,18,249,18,50,20,130,56,53,156,41,45,170,41,117,136,179,222,121,239,18,168,166,237,2,237,98,107,148,236,81,60,2,33,181,218,46,71,254,197,234,84,204,80,27,160,118,123,153,37,55,238,240,199,98,227,116,197,126,232,21,255,98,226,206,152,34,211,121,85,69,183,195,225,202,232,188,79,208,206,156,187,96,21,189,252,76,203,227,241,70,211,61,52,217,12,33,243,41,50,152,77,47,82,19,140,197,235,100,59,65,70,115,52,246,95,80,145,224,57,224,221,213,78,145,49,47,117,102,248,205,92,84,18,215,150,191,135,145,62,36,193,200,52,133,187,34,96,149,139,1,97,248,25,51,64,247,58,93,111,15,225,212,223,114,61,92,11,95,154,153,245,208,78,148,39,150,34,40,110,50,154,11,54,4,145,21,134,166,233,0,193,39,105,2,102,29,28,168,238,231,117,248,142,40,50,56,142,240,142,165,151,16,85,30,155,98,225,239,177,187,143,215,228,29,118,98,85,69,167,21,45,116,143,40,42,152,1,87,158,139,169,81,137,18,54,65,178,145,44,82,225,241,84,208,111,202,139,17,95,107,130,255,148,105,65,106,172,230,171,55,197,239,133,168,4,152,247,235,19,138,175,168,216,216,171,23,160,83,71,40,126,234,228,1,76,145,9,132,135,166,202,190,232,233,218,105,184,138,161,252,19,33,132,61,159,183,129,62,37,37,194,79,104,59,218,204,215,82,166,4,190,36,224,43,97,59,71,51,188,214,175,54,18,10,15,153,110,203,218,59,225,113,185,123,75,111,206,104,24,163,254,170,85,40,105,9,229,41,218,37,240,211,103,89,253,97,34,77,188,114,220,132,215,129,26,109,149,186,128,119,108,19,20,122,172,175,10,20,169,9,104,195,150,51,8,159,140,86,232,226,177,7,196,200,167,207,106,126,27,140,222,219,198,149,46,0,13,93,255,121,205,23,206,245,185,247,15,231,173,156,59,156,16,48,118,254,93,148,203,237,189,158,180,101,52,62,155,57,8,175,171,215,67,69,104,60,72,232,226,185,20,206,65,59,42,125,90,124,100,202,134,141,239,191,110,203,164,223,50,232,219,4,222,205,22,70,62,180,75,143,174,228,44,62,245,202,39,117,215,33,145,80,106,131,177,244,66,46,89,167,198,251,80,38,72,190,90,118,85,34,158,83,17,61,132,124,53,24,63,24,90,249,68,131,245,198,183,117,13,157,137,70,189,73,23,75,77,13,25,88,126,217,87,108,92,8,133,154,15,158,112,113,94,186,162,177,9,232,181,162,55,24,38,161,79,176,4,233,11,158,170,242,240,168,77,25,3,223,158,186,182,26,129,84,106,135,108,205,79,254,175,227,1,238,248,79,5,72,169,217,128,158,1,139,110,157,12,39,55,95,3,2,113,179,81,229,38,144,253,35,77,155,97,157,9,47,133,35,238,97,246,176,156,164,3,236,181,42,140,173,1,46,164,218,168,228,127,219,160,224,59,249,247,7,155,98,77,199,215,146,55,151,221,185,163,241,26,122,137,164,190,205,207,4,237,134,165,74,238,223,226,15,248,242,139,107,210,187,234,4,145,23,231,180,229,53,254,166,201,220,10,14,58,33,230,72,92,230,207,170,109,188,229,137,28,147,22,41,192,213,40,215,216,127,14,228,9,13,85,247,106,247,1,155,206,136,4,23,190,148,170,106,194,155,170,96,227,85,168,247,195,20,113,172,17,34,38,123,79,167,110,206,207,53,66,173,162,178,166,84,120,160,160,218,186,227,34,87,100,212,219,28,84,255,59,138,26,28,227,102,205,94,75,152,55,216,163,46,225,96,152,57,32,57,159,27,251,178,201,231,5,139,31,163,136,69,71,125,19,213,46,252,84,88,215,163,249,153,181,25,227,174,4,105,93,98,251,60,164,4,222,26,165,85,83,87,45,206,132,134,6,108,89,96,76,139,144,143,144,116,59,72,48,184,248,230,195,135,167,29,166,42,207,49,87,221,159,42,168,96,157,181,125,152,96,130,72,48,100,105,145,96,98,200,116,7,131,166,69,99,117,55,141,40,125,106,249,33,118,191,121,159,138,79,27,90,132,13,52,0,61,44,246,212,77,127,107,26,124,234,104,26,14,238,68,79,124,247,99,81,60,135,27,62,83,231,104,214,53,69,104,188,95,120,30,105,222,150,218,223,80,221,209,86,113,125,226,123,36,1,136,94,206,253,124,34,218,2,77,208,172,39,238,148,151,111,237,3,135,99,41,22,142,129,39,56,105,255,31,62,12,171,5,206,94,114,13,174,185,89,199,225,131,239,187,92,132,102,86,138,156,36,55,112,65,191,209,70,60,75,110,59,216,180,148,36,118,238,139,97,222,17,236,209,68,163,76,177,206,58,196,113,2,166,47,131,113,199,180,134,23,174,24,119,20,124,144,29,221,9,90,224,188,131,232,13,244,94,200,129,51,27,11,124,24,154,5,91,171,150,238,212,117,175,71,155,110,168,3,236,162,196,193,74,101,6,238,157,132,151,181,88,122,26,84,194,170,253,198,124,142,133,185,66,4,105,5,152,87,209,178,134,243,242,197,214,209,103,53,218,128,193,9,83,231,55,111,29,235,133,45,107,115,71,203,15,1,69,200,105,216,1,163,183,18,222,54,6,56,48,104,228,237,119,166,90,242,184,97,160,218,194,255,151,131,120,180,104,202,167,157,179,147,77,161,34,65,201,171,236,177,175,0,92,134,255,40,217,133,61,187,44,165,109,184,127,37,189,61,62,60,232,182,210,78,123,118,207,185,156,158,77,117,67,26,37,222,174,87,192,241,152,180,170,218,35,86,86,91,87,98,97,192,129,140,194,233,36,79,152,203,136,73,223,63,26,117,190,88,188,60,42,9,45,54,223,198,207,196,237,26,244,60,233,67,132,223,113,147,253,16,126,10,119,41,159,99,237,109,167,23,248,146,7,166,214,75,0,234,202,90,254,26,71,82,240,116,216,96,236,109,46,104,255,134,115,253,155,36,36,129,188,183,140,151,14,153,244,139,244,252,214,160,8,249,226,35,58,185,116,255,126,128,120,235,190,225,169,185,175,255,64,176,56,247,249,7,18,39,92,249,142,98,47,116,247,126,6,66,208,245,253,217,123,160,123,49,99,18,90,47,9,80,207,212,123,18,61,155,193,44,242,205,146,4,96,210,222,194,220,47,172,241,165,29,155,45,163,105,121,174,115,233,211,216,182,136,24,90,234,77,214,70,94,160,35,59,16,39,71,24,186,43,251,99,53,11,47,60,159,24,144,250,41,114,90,26,97,209,154,96,63,178,67,28,211,107,179,90,253,127,165,163,26,175,163,165,60,47,25,151,210,245,25,91,122,31,176,184,179,128,161,75,71,166,119,40,19,58,101,115,237,145,211,239,250,235,224,4,46,64,94,118,213,191,21,42,27,169,75,217,193,182,121,215,57,216,234,245,160,135,78,21,125,113,51,250,39,177,32,227,61,57,182,118,16,212,181,130,153,240,62,148,127,188,127,160,37,3,231,33,68,181,179,95,116,179,14,247,145,214,104,222,71,140,17,161,171,218,105,81,195,25,20,202,235,110,70,90,42,47,194,109,74,85,60,77,65,92,205,106,16,171,147,0,227,16,251,48,224,101,8,46,29,94,50,36,213,78,254,13,7,254,227,219,219,18,45,213,145,136,25,210,42,32,47,62,61,139,31,140,17,210,249,37,178,80,160,59,139,26,250,178,179,208,129,81,82,239,54,209,224,20,156,174,251,26,130,136,28,68,243,28,42,28,17,51,90,6,39,125,11,249,223,165,193,243,148,129,17,210,146,186,89,202,253,59,205,5,52,237,17,181,104,92,54,142,214,177,178,59,214,195,73,72,186,175,17,1,0,220,146,69,144,120,89,133,146,152,239,230,141,237,0,78,250,117,54,179,45,38,167,90,149,136,233,115,8,227,210,205,255,208,177,5,45,173,12,189,122,109,122,136,191,40,176,51,234,201,4,208,42,147,44,56,120,17,43,69,93,97,143,103,130,166,129,101,7,40,85,92,157,218,212,230,114,139,2,233,64,93,127,49,140,232,168,194,0,74,215,40,158,61,12,247,57,151,103,148,42,210,155,139,211,87,19,0,208,70,224,199,34,241,199,70,169,161,135,61,105,233,172,62,114,0,96,15,45,231,45,55,172,39,55,41,225,133,190,138,162,53,142,120,95,183,32,192,36,208,155,102,233,86,61,53,30,206,83,199,125,72,101,207,29,247,104,10,148,18,184,234,165,202,151,116,193,119,185,112,23,192,20,152,65,174,8,254,94,56,95,112,30,175,131,75,160,36,26,226,61,55,97,225,40,77,212,181,0,239,155,198,208,128,240,202,248,190,135,42,46,22,94,11,61,30,199,55,16,98,142,1,63,173,36,147,172,74,152,45,239,201,204,46,115,27,81,227,120,112,155,184,99,79,214,130,147,122,64,139,9,147,208,82,76,15,123,98,5,74,218,198,40,175,162,34,226,243,95,227,126,94,45,242,141,118,9,49,66,13,62,135,201,56,200,96,255,212,204,11,3,243,18,242,108,74,227,62,173,115,180,224,226,248,249,141,136,245,6,158,110,65,8,248,189,225,236,226,84,45,8,72,133,12,176,12,140,172,135,245,88,80,88,0,185,175,79,207,75,134,219,100,194,29,255,125,135,114,8,126,63,172,235,145,65,229,120,37,197,36,66,254,60,122,61,197,192,6,79,197,152,198,219,179,231,14,155,211,69,154,175,209,49,59,91,6,25,138,1,144,199,28,148,67,149,19,37,147,101,173,173,206,196,37,179,47,184,185,251,43,182,74,221,246,66,82,220,131,113,87,197,241,66,226,95,156,93,186,196,250,229,244,248,189,22,207,27,43,104,3,210,183,207,145,95,190,74,251,145,107,71,36,138,225,83,79,207,145,78,210,137,175,90,23,239,94,181,98,41,136,109,211,114,150,87,255,49,149,169,69,132,65,211,140,205,214,29,22,127,210,12,110,19,72,139,152,200,229,246,220,110,222,227,189,5,36,90,254,53,6,237,122,57,142,108,23,90,140,146,218,237,207,124,148,18,43,1,231,98,177,83,35,133,156,57,105,201,222,84,80,168,12,176,33,62,83,81,72,91,127,176,136,94,105,255,254,90,145,155,68,132,45,203,4,81,16,2,218,66,189,227,170,31,12,196,122,121,143,12,99,122,129,195,234,210,79,14,55,209,162,72,6,182,66,57,203,144,165,124,104,28,239,250,145,78,30,73,201,115,103,29,184,58,64,70,85,21,63,220,48,82,120,182,147,193,160,57,159,29,228,110,185,119,116,208,106,226,116,121,81,43,222,244,81,208,45,54,252,92,150,203,97,118,228,145,19,251,135,68,118,217,134,205,225,179,191,233,152,12,91,197,183,100,112,245,155,90,49,164,31,226,11,161,97,101,12,52,104,87,67,185,88,236,186,244,207,7,33,67,86,181,69,233,84,8,132,228,204,119,32,165,140,91,72,140,72,59,85,160,243,119,182,101,202,174,103,225,103,157,66,245,6,239,65,118,228,82,220,95,37,111,101,138,161,191,68,163,207,254,132,5,33,34,56,45,15,145,79,100,40,250,236,235,36,175,245,20,209,154,13,198,149,155,0,80,11,84,80,172,105,217,187,232,7,132,48,231,150,103,105,189,165,83,77,153,247,75,244,46,186,175,219,208,150,199,180,28,58,132,148,105,13,207,113,32,133,101,252,13,167,207,239,200,38,246,25,126,101,156,150,20,134,155,28,193,203,237,91,8,31,34,172,248,160,57,105,219,239,42,133,226,116,81,43,132,235,167,30,68,43,231,221,164,52,182,249,179,61,153,161,159,137,151,189,73,236,246,163,36,98,19,85,248,126,173,105,179,75,212,179,6,192,100,128,153,211,199,108,66,203,86,207,169,95,199,34,119,154,244,10,13,220,112,98,175,183,40,113,55,27,57,116,86,1,170,179,54,173,252,94,178,69,116,19,143,251,130,194,112,136,117,223,38,229,127,85,195,14,156,30,223,71,155,223,129,124,152,171,136,110,120,95,180,53,100,168,25,3,216,42,54,85,46,69,119,107,155,145,251,64,53,185,193,15,13,139,6,167,11,60,47,89,97,48,152,126,89,204,146,71,95,57,111,150,78,240,251,102,115,113,11,147,15,192,253,231,25,248,245,109,134,153,56,58,101,46,144,2,253,31,2,83,198,61,64,121,63,76,80,67,29,12,66,28,147,254,92,69,68,35,212,156,221,161,237,249,146,56,121,137,145,156,246,183,247,139,124,62,163,212,103,229,186,93,174,69,23,160,26,196,181,43,175,176,60,110,211,55,131,146,61,179,46,79,154,194,63,7,77,202,244,150,202,18,92,217,129,241,239,222,111,51,135,13,231,255,23,171,205,2,165,228,225,46,247,213,245,181,190,140,154,241,182,186,251,24,83,159,137,53,64,138,170,164,60,147,27,90,82,193,36,201,173,182,188,108,188,229,45,193,211,18,253,200,185,25,95,180,93,30,219,69,195,239,222,97,161,110,214,36,114,96,168,76,77,164,53,131,226,197,100,0,42,106,159,84,214,55,249,124,216,170,102,155,118,134,77,181,65,115,14,167,123,89,46,212,228,181,29,222,148,86,228,253,74,236,231,197,148,188,137,167,27,127,12,253,186,84,67,146,211,91,131,122,218,230,239,254,175,168,1,213,249,121,7,221,136,146,201,36,166,47,73,221,190,128,205,126,206,89,121,78,233,57,64,136,20,67,198,178,249,191,17,131,33,149,197,130,104,170,130,142,237,246,170,147,192,156,248,187,123,25,225,139,220,171,61,24,24,114,110,77,3,160,244,82,56,94,113,16,27,118,228,217,56,29,253,10,75,145,97,193,150,89,210,52,60,146,17,127,187,216,5,195,108,15,251,39,157,158,86,49,193,199,155,106,6,73,80,247,203,61,88,81,56,93,158,179,40,245,81,68,136,69,32,237,101,122,112,165,100,55,9,127,59,26,9,41,16,102,92,246,179,125,108,231,225,63,120,88,135,69,195,239,197,51,245,72,72,59,15,231,42,3,184,123,64,176,64,2,15,246,220,67,193,252,8,159,56,20,44,137,45,172,109,183,204,159,101,6,17,221,228,44,160,69,242,153,202,128,203,12,4,126,92,35,50,234,50,118,36,235,41,31,25,142,113,24,62,9,95,20,19,50,125,158,204,53,186,86,53,189,102,153,228,219,22,2,99,14,143,147,221,199,23,113,107,196,224,225,104,121,99,34,19,112,121,28,191,160,245,10,17,84,184,88,225,151,167,54,240,195,72,254,120,18,22,155,131,146,29,227,234,30,101,250,135,69,125,243,191,220,108,252,27,73,15,229,136,53,207,18,173,204,19,205,199,182,167,225,33,249,143,99,91,17,55,149,227,252,128,238,114,212,169,242,145,36,176,68,219,87,139,157,11,63,61,59,211,206,153,189,127,223,109,58,97,39,141,146,29,253,92,94,80,25,18,106,154,118,230,19,134,225,160,83,60,150,40,14,114,137,33,215,197,110,48,190,240,56,91,138,248,129,37,247,39,83,175,2,103,194,229,110,102,216,12,120,6,3,226,163,55,78,249,252,111,226,91,6,137,148,130,47,48,247,229,23,243,182,71,150,137,124,20,124,66,139,32,193,148,161,185,236,79,174,99,200,112,53,55,117,29,34,237,204,153,30,100,212,1,178,63,101,108,21,60,226,164,189,178,191,164,14,130,253,211,82,162,209,199,23,248,243,208,248,249,158,141,215,199,86,0,246,74,146,131,115,160,41,65,31,203,224,248,194,77,33,67,47,171,200,140,46,76,21,188,172,177,183,243,246,224,185,32,56,122,180,233,201,25,233,15,85,45,133,25,16,136,35,136,145,142,15,86,80,133,48,119,224,178,65,40,193,213,90,108,89,160,56,151,217,217,57,103,175,63,242,81,89,154,80,29,72,39,62,162,124,64,207,184,236,170,24,70,121,44,61,235,14,3,108,68,201,57,178,69,188,58,91,211,235,251,154,69,34,123,86,213,66,253,253,216,176,67,99,197,91,185,250,198,244,215,134,106,130,27,155,101,61,23,181,173,83,247,184,185,24,221,87,94,129,150,24,83,250,180,99,14,23,157,95,133,189,98,219,252,120,118,181,213,41,131,138,220,245,32,75,155,209,55,31,197,21,188,175,14,108,96,144,219,70,87,169,105,80,215,39,54,253,164,135,220,113,179,11,26,86,90,17,173,82,168,51,234,219,159,197,190,211,12,96,163,96,156,21,216,237,81,71,8,238,177,222,65,238,18,207,224,198,6,78,77,58,229,128,113,49,80,53,64,60,188,235,183,243,253,19,186,159,48,179,25,11,199,176,100,249,48,94,85,170,164,215,111,157,248,47,235,115,199,148,241,90,5,156,158,194,36,48,2,128,54,251,107,121,73,162,149,9,148,65,58,167,164,203,170,52,197,196,44,120,167,22,204,41,135,101,200,149,248,38,73,57,71,205,69,158,255,72,185,219,30,199,49,162,53,242,190,45,142,206,11,94,30,40,120,221,10,171,209,31,64,30,69,102,138,222,180,169,4,28,97,34,15,174,50,15,217,31,255,141,56,24,233,173,156,216,252,142,255,94,59,43,223,147,253,34,44,189,10,93,55,252,67,27,40,123,12,243,5,33,140,234,16,240,115,171,26,131,179,201,114,216,135,196,14,204,11,226,91,159,139,238,182,65,152,10,212,173,146,189,31,16,197,251,214,140,176,101,41,217,127,19,65,118,112,116,119,159,28,52,102,175,254,92,132,73,106,70,124,121,229,34,136,208,230,102,14,165,73,4,170,233,83,76,138,148,54,152,21,227,68,40,188,180,162,79,72,48,228,26,205,64,66,33,171,221,163,170,114,114,184,172,219,201,168,200,24,77,52,12,80,226,95,105,205,101,189,221,3,5,202,38,226,148,208,76,126,116,245,120,125,186,56,187,96,82,46,133,211,10,66,86,187,156,137,23,160,98,171,226,232,11,114,200,18,250,211,87,122,21,93,163,90,104,194,160,53,194,74,207,94,195,91,24,76,184,136,174,136,22,245,12,54,167,76,106,249,48,251,40,188,97,95,223,30,22,142,194,231,189,143,57,151,51,105,150,197,223,211,167,34,90,118,91,128,229,236,240,185,96,234,208,26,179,111,122,244,232,80,12,38,10,75,30,38,189,236,165,19,26,106,197,252,71,235,185,204,73,177,213,143,142,148,0,198,150,67,125,250,112,233,80,164,49,60,6,157,40,93,68,163,97,177,11,138,69,11,80,35,151,37,226,112,83,104,68,199,208,112,120,18,122,5,174,225,120,249,246,187,239,139,207,193,43,156,214,226,0,98,218,49,189,224,164,249,146,98,223,125,50,17,156,249,81,199,227,5,93,233,167,93,238,114,241,192,104,44,145,2,60,79,168,0,112,62,78,120,31,150,105,225,33,243,194,10,247,239,80,186,67,248,147,112,190,206,149,49,185,35,4,129,193,254,128,152,100,164,105,79,44,168,54,203,1,129,230,43,92,174,4,56,200,148,20,82,211,212,136,193,83,214,240,81,138,39,11,132,114,55,99,194,4,143,40,233,177,238,255,46,166,183,5,115,190,182,171,253,136,6,248,32,219,26,252,55,109,189,224,176,219,6,131,136,170,148,101,102,58,242,121,97,120,125,146,126,232,251,70,200,193,191,199,169,112,172,43,218,147,205,17,215,99,9,141,194,206,149,104,71,115,45,250,190,121,28,115,88,81,131,250,172,238,160,98,146,119,165,113,166,10,172,34,174,43,44,119,114,32,110,169,188,210,22,181,71,3,8,218,196,202,103,105,234,72,209,168,202,3,206,120,58,52,91,169,202,207,73,67,52,223,246,40,85,129,186,17,147,193,231,46,110,139,178,74,210,186,252,20,42,212,66,107,31,239,184,60,105,247,138,212,29,59,35,147,239,109,123,57,144,11,149,66,71,134,57,20,223,47,197,51,83,184,140,102,217,213,245,43,232,173,139,129,135,141,23,147,64,170,6,101,154,52,47,242,34,140,3,101,199,41,95,122,146,104,251,210,114,60,120,85,93,235,23,132,185,200,46,225,58,185,30,23,139,234,67,231,176,36,70,216,129,111,57,23,74,254,117,89,199,41,209,178,61,214,211,184,105,167,86,249,49,90,42,123,168,58,104,222,200,67,41,108,0,17,167,116,177,110,201,116,233,182,36,97,100,6,194,14,109,98,123,229,192,135,60,139,212,178,229,24,178,75,57,129,64,124,38,73,23,182,0,233,69,40,62,242,69,133,151,96,88,46,115,166,144,227,171,12,67,150,150,224,205,128,11,68,98,7,65,199,98,217,18,163,103,246,75,237,111,191,192,188,237,204,240,118,109,98,193,54,170,132,185,37,96,110,213,152,18,190,35,50,82,137,93,149,215,225,221,42,90,5,238,158,171,51,61,216,167,102,11,175,66,32,95,200,136,58,38,185,31,31,7,154,137,77,199,135,129,68,11,138,218,56,51,63,138,232,178,118,35,168,128,222,75,254,4,133,240,20,138,225,42,242,179,147,238,252,236,171,207,216,158,161,187,121,28,211,191,97,168,90,83,211,109,149,65,124,180,9,172,11,247,233,144,178,35,236,201,59,110,14,121,70,14,224,61,254,78,212,28,174,65,117,240,197,140,63,81,231,180,236,142,119,35,45,55,146,227,92,243,89,103,227,113,113,7,241,196,218,216,222,133,210,176,201,227,29,129,190,164,242,224,9,230,82,122,179,114,75,246,39,15,229,149,39,223,54,20,209,236,251,52,201,186,78,73,37,151,126,3,228,78,186,96,42,131,8,164,251,31,66,192,181,12,97,55,186,77,32,219,199,151,33,3,42,85,29,142,29,6,107,115,68,114,214,114,140,199,143,20,245,129,9,78,83,246,169,65,41,122,99,69,204,115,173,8,254,95,66,163,162,48,175,244,113,209,100,147,112,188,220,233,113,5,212,201,138,91,38,191,72,7,99,178,116,234,92,48,244,0,211,154,27,247,206,232,89,85,99,233,132,72,85,200,139,238,153,179,24,123,99,134,246,142,188,239,9,157,112,162,234,185,118,245,59,130,224,204,31,163,171,38,159,221,225,99,216,177,58,35,104,109,10,125,89,23,53,56,37,68,165,189,60,83,249,63,161,240,70,141,1,210,143,125,157,56,227,11,24,55,38,168,16,119,213,155,223,143,131,175,37,234,125,238,16,194,101,201,158,4,110,18,210,221,84,87,14,13,169,250,241,240,1,12,205,98,246,198,75,250,239,249,104,97,127,57,19,15,104,126,28,59,196,119,32,32,82,17,212,81,175,226,118,175,241,105,177,135,71,82,187,16,240,159,71,37,41,230,115,64,156,184,169,24,234,219,0,246,117,253,167,73,143,69,3,130,245,116,43,177,166,154,119,212,153,47,46,26,192,155,252,200,241,110,201,195,252,231,181,147,45,221,62,85,89,150,72,79,230,174,245,52,49,209,202,184,143,160,9,190,63,249,33,193,163,53,123,237,31,46,225,42,225,49,158,14,120,71,133,247,37,52,27,195,168,0,173,254,175,48,203,127,136,142,20,140,58,102,224,52,13,72,195,143,146,84,91,160,228,92,126,63,39,81,150,207,232,13,28,22,22,113,169,45,140,23,5,46,155,127,197,116,25,54,226,104,89,169,95,100,83,211,41,119,115,107,60,190,170,12,213,173,189,220,228,10,211,105,116,245,166,208,229,181,165,201,68,170,57,36,97,78,110,76,75,65,230,77,138,17,146,196,148,196,16,237,121,105,24,158,75,121,236,185,205,129,31,100,68,181,179,248,183,65,29,74,96,126,223,176,27,19,62,148,147,12,48,70,173,22,7,123,162,216,137,16,123,171,81,196,100,84,138,92,119,3,209,28,49,46,184,35,78,201,26,213,233,176,139,204,161,161,100,134,151,46,27,220,236,243,154,104,171,179,29,24,244,219,213,4,109,217,17,167,110,219,11,225,255,47,80,164,122,91,85,104,133,179,78,39,122,132,12,176,53,220,175,184,93,42,5,93,129,217,176,225,1,179,77,53,121,239,203,231,143,218,94,107,129,31,11,195,254,148,78,105,60,149,153,223,20,120,153,7,211,141,71,154,236,170,254,85,202,104,196,108,18,145,215,252,129,244,163,252,137,151,112,146,157,1,59,187,240,13,15,2,216,118,65,35,126,38,27,221,174,235,245,160,106,120,196,95,105,214,48,54,136,226,74,65,88,37,3,224,245,60,140,2,150,249,134,212,251,59,123,169,14,76,79,118,67,227,62,202,182,40,50,114,7,24,44,54,254,33,251,230,193,198,191,167,178,228,71,214,100,187,93,9,99,58,230,102,178,170,160,39,178,130,14,57,7,70,171,249,174,14,35,35,120,237,233,152,182,162,97,118,134,142,150,24,7,159,154,144,20,178,175,155,125,114,58,253,140,118,189,3,236,201,17,137,170,158,6,138,214,209,52,137,203,102,157,11,99,113,92,97,55,117,153,111,20,219,251,13,105,77,46,143,89,53,195,147,116,53,124,195,182,95,154,49,226,94,206,124,56,128,210,109,131,196,167,229,110,5,138,241,184,84,170,48,209,20,77,49,194,144,208,224,23,8,82,52,152,83,235,136,168,48,59,7,125,42,229,139,89,170,227,83,9,67,233,174,188,101,17,74,229,208,35,149,23,105,183,73,116,1,80,193,46,164,25,242,129,1,17,88,87,87,94,55,96,126,151,60,35,202,219,9,3,222,161,131,34,149,198,202,198,131,167,91,75,106,85,22,230,193,8,201,156,81,226,164,111,44,147,161,162,209,240,123,26,148,30,161,104,16,29,236,170,204,149,74,126,34,109,24,139,125,1,32,228,137,89,30,201,147,146,189,177,123,185,72,228,107,91,49,121,163,27,243,72,155,29,183,58,67,212,196,210,201,58,31,102,67,158,141,70,175,80,213,3,99,198,124,34,110,94,209,77,20,85,45,162,82,18,61,189,203,199,56,131,228,230,7,53,226,247,217,35,66,115,37,68,130,210,200,156,186,44,33,11,229,31,84,159,92,194,52,14,158,187,179,106,80,194,179,80,226,202,110,147,204,167,44,63,158,49,55,80,115,164,46,156,244,58,137,134,55,253,220,75,9,103,136,249,242,3,215,220,53,123,17,75,112,40,131,105,76,0,16,17,245,242,195,47,165,106,200,206,26,130,189,65,203,2,99,181,5,143,191,100,128,52,249,154,169,127,159,85,163,175,105,201,79,170,124,33,172,15,229,166,146,194,104,108,129,91,132,33,195,224,4,116,61,113,89,52,79,251,121,2,32,71,98,121,115,214,245,87,160,16,97,250,177,149,55,39,223,212,203,76,231,248,127,176,129,187,75,9,209,101,237,148,65,111,200,193,164,44,66,237,159,220,85,84,91,89,208,128,237,151,180,31,151,237,151,16,114,221,155,43,42,4,83,34,238,79,149,66,231,157,222,132,11,145,104,170,56,236,84,248,183,36,85,4,10,143,170,141,177,87,7,163,114,225,72,248,238,122,146,203,203,157,4,155,198,245,193,60,218,180,175,34,89,80,195,35,71,85,234,238,86,77,49,244,128,157,230,211,30,114,38,88,35,242,190,254,27,132,194,18,236,121,228,133,95,97,44,236,154,28,64,235,14,62,141,6,104,2,239,196,0,239,190,200,189,55,225,88,118,166,28,3,155,39,73,135,166,250,86,28,103,243,78,21,135,177,206,135,183,141,13,148,181,253,155,176,98,53,113,191,110,156,23,111,210,0,12,145,6,255,146,80,247,0,74,171,33,213,96,90,118,193,89,208,79,47,247,61,246,11,199,235,65,231,27,63,41,110,254,129,80,132,0,167,84,59,171,175,164,131,185,207,179,36,207,187,236,180,205,188,150,112,119,170,82,180,155,78,6,33,163,196,74,97,85,204,95,48,248,81,22,74,219,228,3,163,28,111,155,134,69,37,9,187,242,25,75,186,8,17,151,196,130,59,118,14,82,207,194,129,82,65,199,147,72,96,117,243,22,125,145,219,206,184,153,41,144,219,98,96,155,34,94,181,44,163,237,168,33,89,151,218,192,247,57,198,126,236,197,141,63,109,159,157,29,83,185,46,181,8,73,42,95,252,161,116,224,219,172,169,119,219,52,46,170,69,178,172,93,174,0,45,81,139,114,181,102,240,100,159,66,137,156,200,175,244,173,51,117,206,244,24,77,6,23,82,12,37,118,160,225,85,183,69,79,100,126,129,93,155,18,95,145,39,32,118,241,90,236,152,14,20,126,31,234,84,34,120,172,90,243,50,162,34,238,83,91,24,255,99,225,240,27,114,166,100,243,207,98,170,111,107,224,19,79,177,203,231,135,126,205,13,231,108,153,215,16,143,6,18,244,71,18,188,143,224,169,189,54,129,185,202,121,10,142,246,219,251,81,92,184,115,207,55,223,23,9,172,6,80,2,236,96,4,51,62,54,135,46,10,0,229,235,188,235,218,127,115,177,136,157,40,2,71,146,32,245,200,137,190,179,220,117,208,242,197,14,183,79,124,35,171,203,89,139,208,30,50,32,249,148,242,236,98,48,88,255,143,25,1,235,159,210,127,229,219,6,20,19,41,23,220,116,32,214,217,7,197,244,101,247,93,18,117,151,140,84,68,104,42,232,36,226,57,55,57,181,128,52,6,203,130,54,199,103,197,158,184,138,127,61,223,65,111,57,25,181,72,139,155,65,139,48,15,128,95,194,241,163,12,246,39,191,53,212,114,194,90,65,109,13,121,48,171,160,68,35,192,251,149,193,182,207,178,158,107,32,192,59,214,166,145,205,76,194,17,236,248,105,195,184,201,91,214,106,71,163,206,253,189,15,166,160,158,55,182,108,213,82,244,47,221,194,227,48,139,93,104,165,186,46,214,47,63,142,36,158,192,116,253,133,77,50,45,85,208,33,203,120,156,6,55,217,53,210,131,30,194,170,65,32,80,32,81,218,104,125,77,236,131,42,23,51,41,208,230,40,175,127,201,126,254,209,89,221,187,181,101,185,235,139,217,248,49,187,232,192,124,28,52,88,70,236,155,38,60,43,157,178,180,45,203,113,4,9,67,86,60,136,52,5,61,152,126,254,205,152,68,61,64,58,226,75,218,19,204,177,16,138,148,243,180,234,110,6,134,194,139,167,50,151,95,62,160,137,209,208,255,81,199,177,240,114,1,163,160,235,235,172,203,57,245,240,94,121,56,11,132,16,23,152,180,38,90,26,107,103,77,223,70,133,160,220,55,161,159,238,135,127,195,39,208,86,53,94,195,241,255,207,90,238,9,252,64,51,154,107,238,114,42,193,58,242,19,108,172,209,86,71,42,197,80,100,152,114,254,57,174,37,64,50,36,160,251,173,106,84,18,16,170,209,101,166,151,240,142,96,134,97,50,207,93,244,231,22,49,72,181,188,188,85,53,41,160,158,84,157,23,30,169,226,115,33,73,115,107,143,0,226,138,147,191,74,190,144,231,29,158,45,154,232,182,228,53,105,112,118,75,176,179,123,111,233,14,139,90,157,138,223,14,191,88,106,91,191,149,119,119,125,12,238,211,244,188,43,214,146,153,165,147,172,221,81,131,160,19,124,234,236,188,144,176,73,96,127,208,169,247,17,186,160,163,61,186,59,233,72,217,58,90,43,43,23,250,105,188,236,66,19,98,125,250,90,130,162,167,174,46,218,37,184,26,92,237,34,0,26,104,74,167,221,23,105,113,9,187,125,231,185,93,92,121,93,23,185,54,19,90,235,249,3,121,58,43,88,53,140,51,45,206,210,228,223,67,147,216,82,11,167,178,164,218,132,152,116,134,84,112,15,165,106,15,116,46,222,118,186,76,133,157,255,99,27,35,96,230,14,223,36,164,244,30,234,71,169,225,124,239,103,239,185,44,71,223,241,177,16,211,173,64,220,127,244,65,244,249,195,214,90,121,43,248,177,241,128,96,74,224,104,16,53,79,225,14,219,175,78,129,103,35,184,131,156,66,49,75,196,237,145,109,124,157,74,188,157,84,32,153,170,210,235,165,6,155,60,118,114,50,169,40,37,1,220,122,220,107,20,39,19,238,244,128,227,140,103,0,179,250,11,140,38,165,57,63,111,193,84,165,175,223,21,24,232,153,190,211,114,99,96,103,146,32,24,107,66,117,93,27,243,49,114,246,219,30,34,20,17,69,183,243,131,101,22,123,146,89,58,14,130,29,141,36,211,54,162,164,189,208,207,2,157,64,29,178,133,166,206,71,226,123,104,195,207,127,14,140,247,187,212,124,199,222,83,46,134,206,111,75,190,63,73,82,47,139,200,197,11,130,44,168,239,104,124,162,31,115,106,15,77,72,8,188,215,102,185,145,177,146,105,215,243,128,236,120,202,35,200,18,3,56,41,51,228,233,136,75,253,209,15,226,133,173,67,184,30,89,158,18,91,156,153,18,111,152,178,1,79,85,158,151,216,76,58,134,155,146,49,89,17,51,188,208,128,156,11,43,131,131,106,12,149,63,166,121,16,63,219,137,51,65,222,5,172,189,253,110,113,53,167,226,44,245,31,50,38,174,100,68,22,13,112,212,36,155,239,195,60,53,18,123,223,198,86,22,195,153,183,238,240,84,186,32,5,221,42,82,204,140,146,40,142,221,64,66,150,70,55,47,30,39,14,91,230,39,190,250,204,44,92,192,48,150,46,192,2,42,75,126,145,237,31,191,38,153,131,36,227,179,79,231,201,9,204,104,33,64,247,81,36,153,134,244,72,253,218,167,247,131,248,178,75,238,207,226,79,244,209,92,176,76,70,26,233,159,72,80,240,245,86,236,211,60,129,147,52,202,224,10,121,136,140,72,97,73,10,133,96,120,170,207,50,34,150,192,32,223,232,196,218,17,88,13,218,31,177,119,20,156,206,58,133,152,213,248,174,186,249,107,70,175,113,37,10,115,145,51,107,100,20,219,82,204,77,140,219,219,169,215,58,48,94,235,31,79,145,66,12,48,214,3,229,197,44,184,188,88,27,187,162,100,106,211,186,207,12,7,55,129,174,102,0,79,203,232,178,166,41,96,67,20,205,236,10,17,185,214,114,166,94,180,205,186,114,55,253,184,106,217,46,50,15,196,129,214,56,81,178,117,165,228,136,107,226,194,252,239,232,52,189,121,119,33,227,225,214,234,74,40,173,225,105,36,9,32,65,235,127,209,218,119,230,246,90,85,92,208,117,25,145,241,125,158,150,196,130,194,200,251,49,170,85,124,87,213,239,96,184,96,197,63,244,187,217,215,49,3,224,114,164,10,22,251,65,108,238,13,29,254,18,139,129,219,58,169,151,73,96,64,221,26,16,12,14,12,78,9,203,11,80,73,221,118,103,173,1,169,193,215,109,126,166,137,12,12,135,17,81,209,32,12,131,60,0,153,66,201,121,182,155,39,109,173,1,186,45,253,219,88,63,179,91,22,106,108,66,107,17,105,97,59,6,133,136,82,129,125,190,184,234,131,23,198,146,94,243,204,25,190,50,160,81,176,220,38,215,41,120,112,38,74,163,171,24,106,116,214,231,194,77,99,71,195,47,141,134,111,103,119,122,241,34,5,170,123,150,232,85,63,156,112,76,202,78,176,136,79,161,164,245,223,119,235,27,8,99,121,57,0,225,90,143,129,173,209,102,133,158,64,233,181,113,212,237,35,132,15,88,36,85,226,152,217,11,16,251,213,25,7,85,125,48,155,221,141,133,205,66,237,6,5,241,72,247,133,199,177,78,236,71,27,110,205,207,241,40,22,141,156,101,179,172,227,30,248,161,147,84,177,176,26,32,103,36,110,30,67,137,223,121,255,110,247,94,76,30,149,83,111,96,72,165,93,200,58,207,176,213,13,29,75,187,45,112,179,43,234,213,242,216,43,249,33,207,40,167,96,46,219,167,44,111,57,183,96,243,201,5,215,73,106,130,134,7,142,153,17,97,126,88,35,57,154,246,15,16,48,120,187,131,106,242,11,250,99,54,230,135,88,172,62,208,30,127,145,236,44,247,246,202,229,174,206,139,144,172,167,141,73,106,163,33,202,57,80,76,67,219,18,99,153,119,22,223,8,132,90,173,119,88,241,34,158,228,149,129,248,73,110,153,176,170,26,33,117,151,227,204,107,181,26,21,245,164,236,219,77,199,199,35,205,68,49,148,238,100,242,214,99,155,100,23,181,56,99,13,119,225,107,153,143,182,246,225,208,95,196,75,114,87,98,134,84,115,210,91,16,159,38,83,255,6,141,147,176,178,28,7,98,154,157,117,22,186,222,203,229,195,97,78,111,21,1,209,7,216,220,49,206,103,113,12,92,248,125,213,205,208,125,25,23,255,131,122,18,244,102,110,19,246,57,97,29,160,122,12,249,191,178,249,218,202,196,118,95,227,2,202,72,253,166,224,126,142,247,255,235,17,182,40,239,72,49,69,198,190,146,45,197,143,72,232,60,106,114,24,207,64,199,21,148,63,154,255,94,65,161,221,130,35,137,115,115,180,84,241,144,61,126,156,106,22,242,150,187,185,206,193,114,109,233,188,162,195,80,84,37,148,76,38,233,82,107,55,196,65,244,142,66,169,247,79,119,3,176,143,31,254,163,250,36,254,95,244,199,37,243,80,12,199,218,35,41,133,113,33,14,19,65,68,109,255,12,46,255,36,190,184,245,158,28,243,54,230,255,252,10,28,140,185,137,52,36,177,174,246,253,228,33,46,4,171,48,142,104,247,44,43,68,29,108,218,170,183,172,241,193,73,207,219,37,138,1,150,130,219,251,45,165,77,163,56,41,211,48,28,136,245,232,57,137,129,92,21,128,45,154,238,208,32,231,214,120,74,179,72,201,37,186,206,84,50,7,123,49,12,239,253,65,164,149,178,102,109,53,34,240,96,200,137,6,135,145,49,172,151,73,182,67,200,127,30,211,36,85,185,165,56,97,54,221,209,90,70,22,143,152,129,15,204,59,5,143,171,180,132,244,145,20,44,11,142,181,72,223,151,147,26,241,164,157,222,7,97,79,43,35,103,66,163,25,155,118,174,109,181,98,111,56,136,55,63,81,51,89,250,61,148,153,110,132,172,218,99,18,104,242,83,175,53,197,209,126,182,44,53,73,229,104,21,252,214,227,27,176,170,31,200,156,251,40,253,90,104,145,10,1,175,235,135,77,56,137,11,51,99,233,59,250,122,62,196,2,245,142,86,59,143,192,123,130,214,245,182,157,134,228,82,199,243,29,167,83,105,75,4,236,116,174,50,18,89,242,200,87,109,23,221,184,42,3,82,80,103,135,218,190,7,129,98,180,64,149,196,181,217,136,28,58,56,53,14,16,248,30,82,197,85,149,53,2,112,81,243,53,131,126,174,187,3,237,209,3,20,9,246,22,3,194,201,118,169,89,116,66,199,66,16,175,193,47,238,65,137,126,87,148,144,167,191,216,137,23,120,162,24,80,68,168,161,148,167,6,137,56,1,160,59,75,181,56,92,175,90,233,7,212,173,52,242,167,91,64,194,196,220,18,71,186,221,224,84,47,76,156,55,190,180,102,18,21,27,55,125,249,219,154,48,54,210,58,72,73,154,78,48,73,105,233,200,178,230,208,130,172,18,160,79,130,20,166,83,203,232,203,108,136,211,228,152,192,103,222,8,46,245,50,29,25,234,254,228,47,202,93,242,41,33,139,115,212,186,141,90,222,177,4};

// The scrambling tile of 128x128 pixels.
// Each pixel contains an optimized 8d key used to scramble the sequence.
// The keys are optimized for 32spp in 8d.
static const int scramblingTile[128*128*8] = {103,20,250,72,11,150,130,88,69,181,73,241,71,230,14,192,45,227,98,159,135,12,16,204,91,209,92,11,123,134,200,110,43,29,180,1,158,202,231,100,226,75,142,167,24,167,96,173,178,85,79,58,83,160,7,142,126,19,3,128,168,77,27,197,202,19,108,180,101,96,139,46,127,207,234,8,199,227,143,185,171,142,199,119,250,99,80,244,174,235,105,84,50,59,122,10,127,249,102,70,135,113,143,47,5,121,22,176,242,21,192,47,13,37,168,124,84,216,43,202,102,37,143,101,85,181,172,190,177,145,232,107,175,66,117,63,42,62,75,221,115,152,181,183,30,89,227,190,253,26,26,206,18,120,252,156,111,86,222,148,184,254,84,137,243,154,97,181,97,162,36,173,12,115,61,228,66,179,30,82,182,97,247,43,191,4,155,126,88,210,148,33,212,88,156,152,25,123,117,251,33,0,149,95,40,193,241,246,211,202,191,42,85,22,141,190,239,211,245,18,178,16,70,73,139,188,55,6,151,248,136,239,6,156,173,145,38,154,154,211,154,184,88,154,116,156,120,107,46,139,110,121,153,126,90,100,14,106,176,117,15,178,32,237,26,127,82,219,249,128,119,253,155,231,172,69,36,186,32,166,58,254,85,64,239,214,189,116,207,106,74,3,3,33,150,59,71,13,96,236,94,182,126,44,197,31,132,128,15,98,133,71,103,209,96,118,41,167,97,194,192,210,61,163,151,56,232,97,136,92,104,162,206,212,219,91,16,183,143,190,215,202,170,30,117,127,16,225,75,195,7,29,17,215,130,3,246,196,32,239,24,134,115,67,201,136,177,38,135,79,194,31,107,217,243,59,130,30,154,229,58,17,5,164,68,252,236,48,45,35,252,89,166,29,40,211,63,137,95,1,238,17,198,220,40,161,16,58,156,140,194,3,84,45,210,125,152,56,153,247,28,42,166,129,170,148,36,153,70,54,68,57,116,231,121,238,167,176,81,226,2,39,60,151,75,77,95,39,170,246,36,169,189,65,133,252,7,20,34,139,90,153,92,96,246,217,181,76,245,82,18,75,11,24,199,189,73,58,236,181,7,51,205,93,69,175,147,1,164,67,192,249,245,114,174,9,65,124,8,95,219,89,71,223,21,28,128,68,47,193,66,15,235,14,246,107,64,115,255,39,107,166,57,163,183,62,158,176,127,81,255,216,201,37,66,234,244,126,68,86,177,161,76,245,128,45,109,196,179,249,153,54,132,95,140,109,226,189,246,140,123,198,89,3,149,194,168,250,195,76,113,10,232,111,135,229,20,216,58,113,230,83,163,134,47,66,54,88,133,22,168,51,110,74,213,238,242,27,205,115,28,210,168,249,191,123,187,156,222,177,58,97,126,121,189,114,183,83,126,182,24,27,233,32,255,170,9,44,172,94,161,47,235,70,8,188,137,43,231,48,104,241,85,77,161,54,214,78,224,211,118,64,18,35,41,135,59,150,166,6,252,14,21,136,174,1,224,19,92,133,142,209,190,219,1,28,211,57,55,249,248,138,212,24,189,118,162,209,56,84,44,28,216,201,102,16,47,106,53,86,136,133,177,191,66,30,15,77,229,127,216,182,5,177,19,20,26,144,19,98,229,246,9,43,147,151,161,102,43,241,0,151,173,167,61,106,199,181,65,175,237,74,90,250,171,131,76,27,26,208,208,43,100,146,218,89,92,205,150,54,139,213,56,105,154,67,129,7,12,178,17,30,50,147,25,18,55,202,227,94,88,139,216,157,230,154,231,185,219,220,207,188,143,67,18,4,109,223,101,120,140,110,14,244,239,82,141,11,57,215,3,212,29,46,174,1,156,11,67,33,92,95,41,39,181,206,118,80,209,207,245,132,215,98,240,151,219,104,225,50,62,64,108,122,127,63,77,244,70,130,90,96,15,135,27,90,108,155,56,180,244,135,51,142,62,212,252,79,19,142,91,40,239,22,51,34,86,62,164,214,245,199,29,117,20,175,149,119,124,209,107,142,91,13,124,10,53,86,159,43,196,93,20,113,195,112,11,28,178,147,24,89,169,201,81,147,137,143,57,86,144,98,113,154,125,35,79,23,20,8,15,95,55,236,210,2,1,54,4,67,226,167,129,136,185,160,85,54,99,222,78,2,41,148,204,97,58,193,170,232,131,78,157,163,71,147,76,5,69,170,138,133,198,112,83,32,241,64,228,119,167,116,84,149,48,174,239,206,212,181,56,90,152,78,200,194,4,133,188,246,76,21,206,133,187,128,164,207,52,52,80,107,126,83,125,148,95,121,85,141,35,139,229,60,29,62,251,196,161,154,61,118,97,161,126,235,222,231,80,24,253,180,153,245,66,172,110,227,244,210,58,16,38,165,202,138,191,60,146,8,35,198,118,84,155,13,94,95,150,165,186,15,188,16,60,202,77,150,208,204,247,125,29,210,67,14,13,87,251,6,74,251,76,78,30,99,199,70,153,254,119,18,93,105,98,239,237,106,197,66,231,239,182,254,250,82,153,109,64,247,67,157,190,11,52,102,67,141,13,250,201,71,255,48,194,181,20,16,89,241,160,22,206,13,254,118,42,240,78,158,109,10,218,107,30,252,84,132,71,221,171,83,25,20,88,25,205,128,124,83,83,163,119,114,215,97,16,28,81,88,44,145,240,3,3,154,254,180,43,163,254,198,38,222,155,70,27,179,212,143,54,194,247,189,228,142,218,39,47,252,132,65,43,111,222,115,69,60,138,50,102,167,93,246,54,227,165,75,123,130,231,151,157,22,183,159,102,199,219,240,26,69,226,82,4,24,28,90,133,230,214,13,227,167,196,17,86,145,159,115,159,184,59,192,18,147,90,253,57,96,154,164,247,80,11,95,150,98,146,129,167,103,64,168,94,91,209,142,208,89,178,173,166,202,172,205,111,89,166,144,168,114,18,169,199,216,75,98,161,216,160,237,94,245,158,214,152,18,242,148,212,46,93,27,244,13,236,20,193,194,90,42,86,30,87,193,196,172,155,230,151,177,148,8,143,171,201,23,49,66,237,76,199,160,243,218,9,189,152,4,18,251,182,162,12,62,222,49,7,64,179,10,82,38,95,0,123,19,30,105,7,187,113,2,91,27,3,79,162,106,124,159,48,90,107,74,44,109,78,134,219,154,64,68,238,160,27,253,189,5,227,20,187,6,0,213,67,71,232,211,7,55,28,34,93,126,226,235,183,103,115,100,93,84,60,239,108,177,155,18,200,217,171,244,162,133,125,109,59,245,26,132,9,55,9,47,123,181,112,61,116,219,94,111,203,214,39,233,187,104,165,242,213,203,50,197,77,252,25,101,22,59,46,156,11,233,26,191,115,54,150,141,252,51,208,17,141,74,195,21,40,28,205,26,225,254,196,139,7,200,174,72,29,2,202,32,3,176,81,240,211,23,244,228,133,13,211,98,211,160,139,190,70,49,89,49,91,65,190,233,251,121,157,109,234,61,169,223,215,86,252,244,24,0,173,5,200,183,190,142,193,204,102,91,202,99,140,30,194,114,209,252,189,181,81,200,246,251,160,196,50,39,154,236,16,203,143,202,175,219,225,206,12,45,68,108,229,197,244,119,26,238,92,182,152,249,148,210,178,153,64,173,128,214,156,80,188,182,193,176,238,36,188,160,110,233,27,22,36,113,166,66,138,5,139,232,66,95,121,173,70,96,109,159,111,112,18,204,178,203,126,114,101,13,48,195,72,87,112,238,128,11,170,140,24,172,90,241,171,116,171,12,1,246,204,80,164,66,28,18,235,139,109,2,177,99,23,43,253,72,228,169,219,46,237,232,186,19,142,62,55,10,124,243,53,72,222,153,221,140,78,73,246,205,187,97,208,239,82,165,91,57,87,135,200,251,121,84,187,52,82,188,172,44,255,170,154,17,86,99,175,246,228,224,11,55,88,156,115,26,154,147,44,179,62,49,132,134,2,230,141,178,5,160,107,78,167,135,216,134,3,92,218,221,204,155,21,145,98,23,150,207,165,229,79,65,181,132,102,251,109,54,18,191,225,141,95,56,151,147,155,98,50,253,25,178,230,127,196,163,12,109,21,132,135,214,15,68,18,65,139,91,35,48,124,255,15,46,52,3,124,245,206,245,168,25,206,215,71,227,50,96,89,1,81,47,189,54,255,178,67,78,99,2,12,87,155,119,213,148,128,105,117,19,120,84,96,170,55,36,99,255,203,27,197,168,181,62,47,175,43,196,228,78,184,133,90,176,226,200,22,168,228,172,250,166,207,9,74,43,229,233,163,179,69,139,71,156,246,200,46,146,223,209,151,11,29,141,86,141,252,196,6,169,207,208,246,118,249,135,13,106,185,206,82,51,141,161,96,32,37,154,62,115,177,173,111,143,24,216,215,244,146,171,15,129,59,69,181,125,85,105,28,101,203,56,172,192,95,30,190,247,225,195,67,44,177,63,81,240,5,137,101,87,198,18,146,12,65,34,212,53,68,1,138,23,25,244,128,128,244,2,46,49,204,110,185,146,11,193,75,4,217,169,246,224,135,102,63,114,202,158,61,8,254,74,207,94,60,39,5,243,189,117,171,111,239,92,158,43,113,111,162,179,138,93,180,41,19,80,148,164,29,165,122,47,169,67,129,207,79,180,148,86,93,172,119,57,200,246,98,206,42,208,32,102,192,170,220,191,225,56,23,127,155,177,113,193,56,35,2,167,45,237,67,221,85,21,119,80,101,226,137,76,151,90,123,251,210,17,119,147,69,121,4,250,154,60,193,69,239,203,157,47,115,49,161,218,235,132,45,88,165,20,188,235,196,65,153,58,199,15,12,249,95,186,170,37,42,140,93,57,159,117,201,246,90,203,30,70,186,6,196,111,252,86,135,116,85,114,86,214,49,26,11,10,48,32,178,99,8,190,189,85,191,182,21,209,170,160,222,191,179,243,73,124,178,173,2,110,156,244,163,87,11,185,233,169,154,171,150,4,237,235,62,244,19,137,74,80,227,202,204,69,56,226,216,190,206,174,77,114,175,53,1,124,223,251,169,27,239,225,155,109,215,93,137,18,45,27,96,249,219,70,230,124,55,2,166,173,2,110,137,85,2,114,14,95,8,35,110,115,253,202,226,170,240,74,255,28,214,216,205,61,20,19,92,105,133,134,130,159,173,196,211,83,61,156,9,244,45,116,27,163,212,18,0,219,216,77,84,186,159,208,229,65,35,32,210,242,54,93,195,70,92,77,86,249,132,33,198,222,18,208,110,247,76,83,142,227,48,231,145,9,15,90,193,110,104,33,90,226,244,21,13,206,143,20,246,167,3,223,18,99,157,44,99,110,96,90,238,8,100,180,41,73,202,204,229,175,191,95,51,137,120,208,117,172,37,173,71,160,238,118,25,206,170,74,211,29,116,189,175,141,248,45,127,212,184,228,101,105,189,137,105,52,65,213,103,233,25,208,203,250,95,4,65,247,122,187,14,91,144,17,183,23,115,32,19,219,134,28,163,202,190,86,249,76,171,0,174,11,107,62,32,53,211,58,228,10,215,167,42,129,221,3,105,4,8,103,184,184,71,169,36,52,221,139,29,16,104,30,101,23,192,181,12,170,121,215,107,232,61,12,170,14,238,160,145,173,47,63,62,104,226,0,137,192,89,50,9,232,112,177,7,54,166,19,130,182,65,73,124,192,114,89,59,237,14,131,29,218,76,22,34,123,61,114,23,26,65,190,84,43,234,184,203,229,235,0,56,27,17,104,237,134,114,200,171,217,228,85,186,81,43,44,9,210,174,23,66,47,99,185,104,171,46,91,176,230,9,214,203,243,229,74,249,187,190,210,147,36,2,206,216,185,221,189,148,102,186,75,222,90,211,31,133,157,188,100,110,101,214,126,246,164,134,253,222,130,88,109,238,233,93,98,2,79,176,62,241,203,197,199,95,250,114,144,214,78,152,18,251,231,41,11,28,57,185,13,255,19,248,95,217,209,93,89,192,236,113,65,55,191,115,37,59,24,192,198,190,224,133,69,206,37,219,28,26,68,11,113,248,46,159,234,209,163,153,65,13,116,246,79,94,246,39,230,237,71,129,93,3,235,15,101,195,188,231,2,50,94,136,13,31,37,152,122,222,240,110,172,215,109,54,204,113,209,205,98,146,11,79,67,65,97,8,187,90,84,196,218,250,69,91,177,228,205,56,49,205,73,176,10,240,40,100,250,39,88,217,15,233,20,179,54,202,50,156,174,214,131,1,132,225,150,235,120,61,161,102,208,231,205,149,229,173,219,32,74,135,230,160,173,185,180,8,227,33,226,36,21,168,153,32,40,80,227,40,115,173,162,224,145,99,252,233,186,63,217,169,82,69,144,92,185,170,33,106,28,107,20,72,166,157,56,208,87,53,214,144,189,131,225,16,215,139,253,7,89,186,57,29,224,71,0,18,151,32,168,84,233,185,16,69,88,94,178,38,251,108,253,16,36,70,151,24,98,166,71,86,115,110,114,0,142,31,96,142,96,75,106,217,84,63,148,25,9,234,202,208,45,195,225,93,151,225,97,102,95,40,246,165,194,50,106,202,144,154,229,177,206,35,20,186,215,36,29,34,173,191,105,43,199,144,210,44,216,178,151,125,114,252,181,236,86,13,141,55,113,208,234,86,89,127,83,217,29,112,62,210,112,58,118,1,32,216,186,5,200,76,134,97,49,1,4,167,177,86,153,5,193,67,10,130,180,125,246,130,203,189,14,232,155,194,157,40,160,128,203,11,168,22,146,251,242,187,198,75,162,138,57,206,78,201,30,105,25,102,99,207,207,142,79,220,5,115,77,147,21,136,39,52,121,79,135,12,233,235,95,127,3,43,24,222,221,187,35,31,241,132,113,125,36,54,236,84,66,201,106,146,79,120,217,158,133,120,142,189,126,92,199,11,151,253,99,152,248,35,78,173,210,232,232,224,101,41,88,188,252,45,203,163,239,199,47,65,215,6,214,217,122,230,244,163,50,10,105,66,246,198,12,49,16,212,231,42,245,224,209,111,15,197,192,39,64,122,212,31,119,207,39,48,20,74,88,73,4,31,197,73,2,115,43,160,194,151,220,114,132,223,148,164,113,185,52,239,238,55,234,115,81,245,124,125,58,108,158,30,25,245,146,120,145,64,10,169,14,141,96,127,245,117,6,248,84,189,51,91,131,2,45,44,193,81,114,199,148,102,154,77,123,80,65,97,160,31,223,98,189,87,102,49,160,252,78,202,167,64,88,42,169,5,32,69,128,73,155,83,175,86,30,144,154,176,17,250,247,195,107,147,192,85,123,142,237,53,117,158,70,107,209,208,150,213,8,99,49,153,178,6,171,46,245,198,211,147,86,249,141,83,200,42,58,97,6,224,39,85,237,114,73,107,216,119,40,102,87,206,46,15,182,106,241,209,123,23,196,236,131,112,233,182,67,98,224,152,184,72,219,134,85,100,199,242,228,176,10,215,25,238,107,18,192,229,216,52,57,46,170,208,95,87,49,30,183,58,42,175,236,75,244,30,6,52,108,226,193,28,111,158,121,1,24,56,59,127,124,166,154,180,28,44,111,123,50,205,171,88,53,137,153,170,11,43,77,75,31,1,38,6,187,228,8,229,51,254,224,107,146,44,20,155,100,5,0,28,169,123,8,127,171,199,197,10,156,12,134,245,129,115,54,107,127,73,144,55,123,47,160,118,184,161,52,37,71,172,45,152,234,0,252,91,121,0,176,85,168,174,147,203,183,170,169,46,250,176,187,73,232,168,70,212,222,5,97,2,8,77,110,97,110,24,165,46,5,171,43,69,122,35,185,164,157,162,237,113,219,126,50,24,202,222,199,208,223,21,42,35,182,50,105,178,115,74,218,20,255,78,13,1,123,131,6,233,158,75,234,160,120,7,34,134,175,88,252,192,60,213,125,241,151,106,63,205,7,205,169,34,5,76,202,53,255,148,133,129,7,4,135,144,236,80,24,229,79,50,179,81,97,14,241,78,48,93,215,169,140,91,252,60,18,1,96,245,21,251,59,205,179,205,79,114,134,102,59,88,255,211,127,76,101,45,200,107,68,249,163,43,105,102,142,125,168,243,112,197,173,5,238,255,134,179,120,68,172,106,150,164,70,127,18,44,190,113,9,31,197,177,179,166,164,220,50,130,107,8,174,208,220,107,2,189,215,202,203,238,34,8,61,156,17,196,233,128,109,15,1,191,234,240,126,147,74,25,163,150,55,142,8,49,134,15,115,126,223,27,63,41,150,14,220,91,157,24,194,237,78,32,120,153,7,19,238,117,199,25,104,96,60,245,231,229,33,7,30,24,30,15,218,67,198,184,87,206,214,96,48,17,244,145,74,62,235,146,190,94,84,120,254,24,248,224,113,196,217,218,55,98,176,140,149,241,248,229,226,218,13,255,1,65,88,147,176,115,139,163,109,75,195,37,140,235,182,189,93,102,216,111,110,137,137,187,250,210,200,56,22,219,140,250,240,144,223,30,173,189,78,235,13,192,54,206,255,28,140,196,195,136,42,35,37,30,11,14,186,102,205,185,152,59,100,37,222,72,231,53,136,226,86,36,246,106,244,111,151,223,239,164,238,68,80,158,54,33,134,184,241,222,188,139,8,45,36,221,39,227,25,49,195,72,105,249,38,103,146,6,128,218,0,28,112,1,131,21,215,64,36,254,245,6,224,52,124,101,47,115,196,225,107,152,95,178,228,11,223,207,238,225,214,162,129,141,71,203,187,220,95,21,247,52,70,96,27,122,220,178,233,30,92,6,21,154,87,26,119,231,212,211,72,7,87,206,45,188,150,60,171,96,222,38,170,225,251,82,73,36,211,9,223,234,68,34,78,122,217,44,230,5,119,101,37,132,217,16,175,236,3,81,4,18,237,88,162,203,87,47,149,62,254,18,195,111,31,148,198,2,28,89,70,239,75,67,131,129,242,216,23,201,131,185,173,21,76,60,210,114,13,142,245,146,36,112,101,204,176,239,94,171,212,33,25,25,212,238,253,88,179,66,190,106,128,233,112,122,90,235,101,231,147,44,203,158,182,236,12,144,124,180,66,107,112,178,103,151,93,25,100,142,98,220,79,69,162,46,79,36,14,70,36,76,81,155,180,70,126,111,48,23,243,192,5,90,205,56,236,161,106,128,154,202,81,108,3,72,18,70,120,214,99,145,181,210,42,74,171,233,169,242,176,227,203,181,197,49,103,129,124,235,61,147,221,231,154,195,151,31,125,26,29,246,145,42,156,242,172,68,111,222,233,45,236,37,102,229,244,8,68,183,92,184,229,81,136,10,228,203,123,163,243,81,161,122,248,230,87,13,22,40,202,124,56,148,239,15,199,117,10,89,181,41,240,94,159,143,230,127,28,195,33,136,129,176,219,89,143,76,153,199,10,44,222,27,35,222,69,198,38,66,28,247,84,21,81,128,86,135,192,118,175,203,40,138,210,80,235,34,74,28,8,240,97,250,240,224,114,142,220,17,15,160,128,154,19,227,111,160,78,241,143,232,167,199,185,193,184,28,188,156,70,232,71,175,237,7,138,140,155,15,102,184,207,182,88,22,101,131,36,10,67,137,123,210,223,174,32,21,94,251,141,103,106,159,230,250,107,204,225,84,126,232,119,140,100,230,173,188,253,123,210,76,20,241,27,42,220,11,218,30,114,236,8,237,75,20,125,36,121,157,179,169,25,237,234,60,41,26,241,114,176,135,193,53,119,237,246,43,81,196,61,66,113,44,177,10,86,106,134,199,238,169,225,157,89,60,71,251,37,236,145,36,170,165,135,212,193,106,194,197,84,106,20,173,189,108,114,230,193,80,9,253,148,109,209,11,174,201,98,48,13,90,14,189,202,45,111,45,41,199,20,177,23,39,199,189,231,100,164,54,221,173,22,249,145,178,193,174,39,142,116,195,37,235,143,53,71,24,2,236,201,48,137,244,14,234,186,174,202,130,66,39,48,241,115,240,195,131,115,75,83,23,130,62,148,102,75,239,159,189,120,134,129,34,235,192,103,58,81,189,140,63,197,68,49,27,11,130,71,135,38,134,25,83,36,94,33,15,238,104,101,125,63,17,3,148,75,117,236,101,14,82,39,29,255,186,139,123,231,63,35,58,38,67,36,112,207,42,8,185,61,10,13,228,164,200,235,21,176,56,167,251,200,180,44,236,233,135,140,84,131,64,221,165,247,57,196,62,189,195,43,51,76,146,79,152,83,233,89,150,79,143,112,61,58,178,175,250,67,95,194,40,16,239,126,237,120,185,97,35,71,31,190,175,60,246,127,133,105,18,91,149,17,154,22,126,63,196,174,196,141,211,110,159,251,200,99,142,29,220,166,134,19,125,243,25,114,49,230,180,0,97,98,94,126,189,136,75,33,121,234,125,76,31,223,7,175,78,225,27,18,111,184,17,72,109,84,161,31,100,205,167,211,24,145,46,231,186,149,9,83,58,16,237,84,144,113,159,4,4,53,168,55,19,102,55,1,2,135,204,244,77,37,145,9,149,104,52,163,46,115,11,16,1,18,99,130,193,128,208,200,153,79,157,94,177,184,26,19,224,55,51,214,212,149,0,236,66,177,217,163,189,124,104,35,153,154,99,46,40,132,166,164,13,226,121,255,238,104,164,6,174,99,230,69,94,81,151,4,139,204,80,237,127,92,23,108,33,131,160,102,214,235,240,138,79,172,147,229,43,77,124,92,90,159,174,185,24,2,244,39,192,100,74,15,246,20,44,188,254,160,79,27,151,12,214,41,226,114,214,31,96,116,145,235,47,14,232,245,32,46,29,90,229,212,150,255,94,121,24,195,18,134,141,224,250,139,72,219,19,148,118,194,170,186,10,32,51,128,119,3,1,253,114,108,190,213,128,53,65,150,22,92,96,34,143,162,196,110,58,67,116,8,80,112,107,233,44,168,132,231,72,162,90,243,211,66,212,50,111,133,57,111,194,235,22,65,201,140,54,65,140,73,21,215,199,161,147,125,169,37,18,252,214,220,22,126,78,83,53,137,46,182,89,166,158,192,156,122,48,132,247,232,153,152,49,167,59,51,237,178,173,39,47,145,148,177,174,77,77,109,241,241,210,21,151,91,244,154,50,240,138,72,51,25,38,2,131,138,124,5,111,253,247,91,239,230,170,42,245,128,69,82,2,151,174,92,246,168,20,64,72,200,141,150,201,165,58,92,254,38,121,53,213,63,248,176,71,16,88,187,176,70,214,63,81,93,103,157,189,107,196,233,233,143,190,96,169,249,170,58,58,68,9,121,78,232,13,85,11,135,226,230,88,60,149,96,209,144,229,197,251,235,87,108,73,139,162,215,94,253,13,219,156,206,188,6,183,112,41,9,174,208,56,74,250,74,88,81,80,129,29,24,249,142,39,118,156,189,18,41,74,244,84,1,110,78,105,36,5,26,232,5,217,78,203,46,6,186,90,69,146,111,233,100,123,109,216,106,87,61,237,30,63,184,173,25,236,46,79,255,225,142,160,50,5,157,81,4,146,242,142,233,22,203,153,159,244,174,199,225,32,107,51,206,200,58,69,167,213,160,203,53,3,247,204,13,129,238,8,9,214,29,187,196,231,144,82,22,108,65,44,70,144,232,79,141,70,79,163,83,137,245,114,180,145,233,205,188,4,41,25,13,183,41,57,13,78,186,207,93,168,211,196,56,88,142,214,137,175,237,5,47,39,132,21,83,206,234,26,194,241,170,117,183,168,37,207,165,187,17,149,222,55,207,180,22,184,202,45,132,115,42,240,110,29,214,28,48,162,6,154,27,244,181,235,236,226,82,228,57,22,69,116,135,75,147,244,42,103,75,4,204,242,105,55,157,170,248,155,176,4,224,91,46,99,185,22,184,0,146,6,250,17,104,65,228,44,104,93,76,113,206,182,76,10,153,102,83,113,229,16,160,123,174,99,193,134,64,26,195,241,177,101,224,24,248,58,46,87,137,115,142,94,9,6,54,14,188,179,124,144,23,204,171,210,85,22,141,38,87,88,11,55,172,71,100,96,118,23,209,41,146,168,220,200,208,214,233,160,168,48,255,207,75,76,200,226,177,4,87,118,246,43,213,189,223,203,96,149,180,221,161,234,225,102,115,162,57,217,39,45,17,80,209,43,210,145,66,68,62,231,105,43,76,195,220,67,246,27,3,186,83,22,224,67,163,83,92,120,231,230,217,117,77,27,184,102,214,198,190,94,244,235,89,223,10,62,209,123,96,24,144,31,225,51,185,235,230,189,19,208,186,61,193,140,22,86,223,219,15,151,113,161,225,91,252,202,33,248,201,218,89,80,153,9,149,9,254,151,129,150,45,139,55,212,34,29,34,54,205,124,176,19,34,96,53,40,221,64,51,43,14,209,32,242,220,96,40,169,5,204,178,32,103,239,117,123,147,147,130,157,227,75,9,18,217,152,12,220,0,224,172,200,120,164,17,132,151,68,40,157,189,28,169,70,136,199,11,245,240,26,2,234,199,160,20,194,147,14,49,65,208,175,240,178,70,180,84,86,12,235,204,7,233,222,117,99,22,239,40,139,229,211,80,64,25,192,36,145,2,25,4,64,122,181,125,159,182,115,121,188,230,174,24,37,175,248,26,95,38,183,88,236,24,230,243,121,76,119,82,95,21,245,37,219,73,114,100,113,59,3,32,186,175,164,144,80,43,14,31,152,230,111,215,213,147,114,192,57,210,113,62,203,75,55,193,212,60,8,183,145,132,73,28,115,218,178,23,163,69,81,123,129,38,7,114,28,193,121,207,1,21,24,18,133,208,74,113,31,55,37,141,139,230,171,190,251,39,155,218,58,137,171,141,156,0,182,195,83,201,80,123,16,38,71,196,84,234,98,232,214,71,133,57,223,246,121,191,145,88,213,60,15,152,210,177,194,79,78,102,237,38,253,206,32,129,154,119,75,48,104,236,17,76,173,201,153,95,187,168,228,10,250,194,34,228,204,65,53,31,221,19,158,204,206,177,239,111,74,9,128,47,56,222,29,83,196,79,206,166,195,169,31,175,178,50,86,35,81,243,7,111,61,96,114,240,54,168,54,153,0,119,204,192,209,6,148,72,233,252,81,150,18,92,47,95,94,115,143,192,56,67,109,200,233,94,0,161,242,190,107,86,232,145,8,55,0,70,108,122,229,125,122,170,22,201,232,203,34,82,130,154,228,108,16,226,3,242,15,140,115,38,214,137,34,250,88,67,83,43,221,202,178,191,230,160,235,158,71,243,217,16,145,194,209,107,198,199,0,87,217,83,94,59,67,219,27,99,129,227,84,70,42,252,142,198,230,235,243,243,175,218,43,234,197,243,221,122,186,194,29,110,77,242,156,239,31,164,109,80,148,53,229,103,147,142,71,83,13,180,173,152,102,50,164,245,180,1,94,233,102,180,198,248,2,122,173,10,48,194,106,56,3,20,172,64,226,175,133,48,166,9,133,181,252,50,192,227,46,94,166,191,26,15,59,25,45,203,19,158,17,51,45,36,85,31,7,110,7,241,170,83,221,166,124,224,177,119,121,147,124,171,59,144,193,35,25,220,19,105,23,139,160,105,202,75,149,113,175,64,28,162,60,145,128,123,50,90,82,209,116,245,103,69,69,25,245,27,41,75,68,226,169,143,244,165,21,92,185,200,80,236,240,249,232,56,200,108,89,117,173,106,212,149,216,77,111,102,245,103,147,153,107,128,123,253,165,9,106,96,4,108,9,241,136,5,113,88,115,100,109,223,134,64,37,225,181,187,210,95,85,27,160,244,194,36,27,13,131,116,46,205,252,13,92,5,170,102,113,61,35,177,127,159,56,145,246,0,220,141,13,218,21,19,36,193,37,210,68,150,5,12,61,95,79,15,119,116,235,226,151,186,203,132,193,28,219,234,21,242,186,18,230,30,49,154,171,227,221,0,230,93,170,54,185,148,125,201,194,250,195,226,206,156,134,198,226,245,37,218,130,192,132,72,33,195,60,215,5,130,190,130,1,218,152,223,149,191,209,214,215,65,166,195,180,167,209,103,65,77,51,175,146,12,199,166,58,58,236,170,152,133,152,227,46,112,106,190,103,120,158,96,141,140,224,138,62,22,94,43,22,197,64,197,46,79,241,206,232,209,174,46,89,82,238,250,182,132,51,19,44,239,35,251,48,240,67,38,6,181,80,250,38,72,212,26,21,251,18,224,22,160,148,49,83,38,60,66,76,191,132,5,73,9,150,160,218,69,128,164,99,148,36,238,236,139,122,23,24,223,149,237,53,18,130,124,121,0,237,160,169,242,165,107,127,65,150,51,190,99,217,154,53,71,243,12,180,89,160,85,3,34,62,196,157,163,168,22,118,55,179,27,131,197,179,210,163,120,229,4,193,29,193,65,180,83,234,143,162,99,110,85,244,160,179,88,238,44,84,246,118,33,138,56,63,102,78,5,252,70,133,100,56,24,191,181,195,78,210,6,34,198,110,119,72,1,174,10,101,154,165,110,223,104,217,169,112,184,68,105,48,93,9,147,166,136,4,171,31,32,15,232,58,167,208,160,206,87,112,171,44,42,82,250,244,167,116,219,131,225,226,233,234,226,47,26,14,234,127,241,228,204,65,147,224,142,53,240,111,157,95,167,221,146,217,127,164,221,29,18,40,61,139,201,134,30,200,3,199,14,245,92,108,38,102,2,222,183,194,66,133,221,94,143,57,199,54,5,175,118,63,25,208,103,94,233,166,208,30,148,229,126,109,26,166,108,141,116,108,140,152,141,160,87,249,190,98,163,149,251,155,245,198,223,145,8,2,239,162,193,216,175,180,7,82,32,248,222,19,245,152,174,68,3,230,246,106,251,118,101,33,86,118,87,30,250,172,121,132,232,152,210,207,241,110,56,49,78,178,162,192,168,210,32,149,237,230,160,24,25,0,108,37,46,226,46,104,116,33,194,29,138,238,142,155,29,240,101,202,150,32,45,163,127,3,252,71,21,95,108,75,20,182,39,198,234,169,58,77,134,65,94,66,78,5,110,199,95,108,232,22,60,184,48,197,21,41,23,124,236,167,33,90,28,244,93,115,137,155,159,147,205,84,35,214,128,147,14,148,43,141,34,209,43,223,33,101,239,214,80,230,50,212,204,219,131,220,233,170,115,202,166,61,23,157,40,177,59,84,230,153,231,239,73,147,48,201,66,12,242,16,145,114,85,89,41,78,243,216,63,17,213,80,60,63,160,92,247,156,123,220,6,95,194,202,209,234,68,210,212,157,244,104,246,42,2,208,198,116,247,61,205,216,48,218,39,57,34,207,12,2,77,133,173,189,143,14,64,209,16,65,202,48,78,178,92,33,33,7,180,208,76,111,225,46,113,158,58,192,155,10,79,184,31,69,74,32,255,95,59,137,165,179,78,24,201,189,87,33,5,143,83,93,195,57,83,206,93,207,107,133,170,242,145,67,102,30,87,254,8,219,8,255,234,158,68,53,120,155,203,21,232,11,81,9,211,140,95,36,249,8,193,114,148,67,210,167,133,19,231,83,24,208,86,80,19,172,237,166,166,227,186,175,42,180,142,224,211,3,54,194,64,42,161,6,107,175,93,206,102,86,206,188,210,134,236,240,222,42,109,79,229,25,74,180,205,45,216,222,32,249,225,66,5,107,149,46,64,100,65,141,122,83,37,4,147,245,95,73,184,84,7,21,162,1,209,56,152,129,250,129,194,151,1,169,179,108,255,126,103,201,55,148,26,174,44,183,245,175,119,85,181,36,48,74,162,210,205,15,238,93,53,143,57,188,195,121,124,194,116,72,218,242,185,0,213,9,143,171,43,192,178,171,88,105,212,73,180,86,243,240,136,40,55,109,75,51,129,209,15,201,201,75,193,145,160,207,64,3,245,231,10,127,226,207,27,6,57,164,74,58,173,29,21,75,250,165,228,203,41,231,39,82,236,105,222,133,218,165,242,138,151,37,67,178,12,24,25,254,122,225,126,150,234,61,188,133,185,179,87,179,53,122,177,225,77,200,90,216,62,77,24,16,248,24,159,221,249,139,132,57,171,93,153,106,242,102,116,248,74,6,15,31,181,220,233,116,127,249,107,187,156,205,196,181,216,199,114,234,167,141,38,53,142,195,149,99,172,83,69,82,34,83,220,155,52,74,160,29,45,168,128,100,151,185,107,202,231,217,15,57,197,87,107,30,13,159,39,37,252,243,11,96,176,204,29,53,244,205,30,23,218,179,141,63,248,41,184,10,151,113,254,113,235,3,243,249,67,102,12,114,145,30,193,142,106,58,0,75,231,250,79,12,162,137,11,119,240,156,101,85,111,140,194,31,7,144,78,115,168,179,34,246,158,67,57,108,136,140,11,96,37,227,40,164,244,5,17,250,137,223,173,226,29,156,66,140,78,78,158,40,89,199,137,131,167,40,105,238,185,69,200,237,237,16,234,105,130,73,239,132,140,135,201,212,157,183,194,9,153,76,160,221,186,7,79,35,99,196,0,124,32,52,248,99,113,22,7,175,90,30,117,120,67,92,30,130,238,62,222,237,85,236,9,75,134,56,240,36,202,139,62,64,39,236,250,168,162,114,77,114,191,152,189,171,13,81,196,126,230,87,14,57,60,193,83,92,34,82,99,183,170,206,35,26,21,142,178,177,112,136,89,69,100,76,82,225,250,135,45,124,27,164,119,116,40,80,44,126,197,156,152,213,49,39,18,50,83,63,50,58,216,56,38,128,52,138,115,219,97,218,44,7,74,174,95,244,136,103,201,131,12,245,203,215,176,46,117,69,170,166,120,219,28,231,45,47,103,36,122,76,113,116,6,168,69,8,191,187,28,135,112,4,2,222,227,100,144,197,87,230,69,117,255,210,68,231,113,217,115,45,59,9,163,146,127,230,114,139,66,170,181,2,91,234,43,63,41,180,149,124,100,116,183,251,67,67,19,70,52,29,192,151,152,107,5,1,109,187,210,135,13,45,29,173,14,100,128,142,107,102,40,142,16,80,220,208,153,77,132,199,193,118,97,254,119,196,246,193,50,9,85,94,122,50,144,119,32,240,167,242,26,188,18,99,186,226,159,60,150,160,235,27,146,39,208,230,36,211,228,177,140,167,100,190,101,156,136,66,242,158,209,183,61,210,192,81,221,157,255,124,28,227,89,232,10,59,109,99,227,108,90,134,72,137,159,67,247,72,194,175,240,183,129,163,77,124,107,139,245,161,158,21,84,218,160,71,31,48,45,144,94,31,144,56,231,115,179,18,22,193,110,135,227,174,124,48,81,94,130,24,27,174,178,160,95,159,119,130,14,121,252,100,80,105,143,178,141,37,122,232,1,62,234,144,212,175,2,35,48,81,50,210,100,176,86,76,7,102,99,19,107,178,139,60,17,253,108,252,103,64,35,80,246,56,53,232,147,175,236,83,105,191,133,118,49,19,52,110,221,125,56,253,16,210,144,125,1,78,35,19,218,200,251,226,184,30,53,250,54,195,101,255,148,114,56,218,80,249,128,7,184,230,178,237,136,23,166,2,4,3,0,79,96,113,32,189,202,134,32,191,93,223,61,202,143,69,98,124,33,224,204,33,168,133,52,190,200,215,169,247,151,2,53,93,47,155,152,249,43,176,110,118,139,43,29,43,150,219,172,91,144,45,178,237,98,44,209,136,127,60,212,86,237,18,185,47,177,49,4,175,208,7,132,152,109,210,40,151,168,203,61,98,26,235,49,8,216,130,77,218,177,199,245,12,172,253,13,104,180,80,120,192,236,222,233,14,141,78,86,210,47,39,151,6,203,14,35,224,128,118,206,5,227,175,140,2,130,85,12,99,91,179,199,68,148,28,10,219,161,59,243,142,211,52,86,62,209,14,170,246,12,121,90,15,168,178,69,127,96,94,161,48,234,58,72,15,60,192,159,42,221,62,231,154,48,24,53,54,53,255,67,211,25,220,5,68,136,221,71,210,152,174,20,102,194,68,93,206,117,29,234,124,27,5,243,129,162,30,33,178,241,114,197,160,224,79,230,182,101,26,53,254,240,249,170,226,100,52,57,117,135,88,191,7,77,45,17,249,151,30,153,220,236,71,30,237,109,84,194,100,171,71,53,152,198,39,108,71,132,104,67,218,209,60,157,101,131,33,246,223,187,199,241,164,132,116,1,243,205,234,27,210,183,34,238,41,58,74,255,99,161,109,200,4,95,164,98,89,207,61,54,97,117,48,76,147,136,84,204,11,228,6,177,240,44,206,148,13,189,91,31,16,94,56,19,178,235,125,24,250,96,247,157,246,78,25,72,68,15,238,153,154,67,46,85,180,107,88,106,19,15,100,35,2,0,151,196,52,133,25,207,99,10,193,170,112,203,101,225,53,23,127,167,92,241,69,39,49,42,69,51,117,115,107,219,164,20,89,24,219,77,106,92,234,205,183,6,61,74,118,155,171,27,214,10,94,139,75,225,6,60,17,3,92,89,165,35,75,21,137,236,78,176,144,249,67,94,68,250,81,24,122,237,216,137,126,145,29,70,246,20,203,189,72,221,152,11,23,255,27,5,249,146,250,144,188,90,9,167,142,77,163,97,86,141,166,70,244,127,36,23,153,92,90,223,179,113,255,124,67,104,81,250,118,125,182,107,238,176,25,129,55,95,44,215,17,65,135,167,51,237,102,43,36,81,61,63,231,205,95,7,175,154,201,100,45,197,253,160,156,122,77,70,100,90,46,128,153,194,107,222,0,85,152,27,82,155,121,16,251,149,168,48,128,58,4,76,255,22,18,60,122,25,66,140,233,58,203,121,150,213,130,215,96,0,220,161,114,226,244,0,96,198,105,234,166,165,45,22,166,128,60,153,102,16,144,187,58,122,128,242,211,113,85,86,122,136,50,165,98,58,22,82,182,115,225,129,185,56,231,217,203,252,240,167,217,90,248,196,247,205,151,88,151,97,217,61,245,232,83,199,175,128,9,198,243,122,243,69,16,136,75,194,34,70,102,159,132,148,42,200,88,3,236,37,186,106,248,201,149,3,88,44,204,12,66,17,85,46,6,146,57,247,93,210,17,43,179,65,53,215,106,95,230,52,253,147,236,187,176,158,53,87,74,117,215,59,239,103,151,74,68,206,225,166,166,185,208,142,122,179,246,24,77,29,219,90,184,250,148,64,222,125,34,230,20,83,77,161,193,113,51,132,215,110,199,131,31,207,255,1,244,88,172,106,27,79,213,23,82,56,139,135,192,151,30,234,32,202,254,234,86,33,223,197,206,250,145,160,193,1,151,197,25,102,66,34,107,99,184,23,130,44,73,175,34,61,72,137,37,255,26,183,168,19,245,54,193,107,217,107,125,132,188,57,73,184,199,231,17,102,152,53,245,37,209,45,13,186,170,213,37,124,246,231,147,131,150,197,101,213,141,161,79,165,17,172,191,34,225,36,68,52,150,105,7,52,86,103,145,143,211,240,8,6,100,147,162,202,26,121,151,198,106,164,191,12,147,7,194,82,97,36,150,153,122,85,122,204,222,63,178,139,145,141,156,243,185,193,66,184,76,76,176,161,74,108,20,241,42,75,65,81,110,151,128,170,169,55,214,190,53,240,205,165,119,76,191,181,236,80,43,19,82,73,59,201,233,180,12,192,147,149,135,200,248,106,135,23,86,109,127,94,225,93,103,19,132,75,159,109,188,79,228,173,148,40,186,114,2,89,131,72,28,155,47,100,143,7,16,33,1,219,127,24,128,41,184,56,249,112,204,99,85,243,0,61,21,165,57,99,75,116,163,206,181,153,165,108,35,45,139,14,206,213,173,34,46,225,192,131,170,178,217,140,108,3,133,132,91,3,251,37,5,55,225,231,171,64,198,222,9,61,189,255,127,6,61,136,73,251,231,123,177,107,0,183,247,78,192,189,245,191,249,22,180,62,222,143,20,157,133,128,181,162,201,14,14,224,248,123,54,48,152,132,4,117,37,230,239,40,183,146,83,235,234,79,26,45,104,89,213,243,90,66,205,113,141,108,68,228,229,87,215,163,30,81,205,76,194,175,16,82,79,232,13,14,82,183,54,156,226,244,207,171,199,71,53,93,233,167,120,36,34,176,2,238,177,92,187,169,133,52,38,89,216,246,59,39,155,42,180,57,184,84,194,161,50,4,170,13,2,164,111,74,125,12,17,58,75,231,90,84,99,130,132,72,108,143,192,188,228,62,75,131,198,90,238,230,210,108,10,19,199,3,200,35,101,115,254,208,218,30,238,45,32,46,100,1,125,202,36,241,178,90,73,245,165,199,205,65,38,176,41,110,69,204,178,28,153,69,46,182,186,131,168,55,122,118,39,156,19,155,10,72,180,36,246,61,71,65,198,177,116,28,128,255,97,48,140,46,40,69,33,229,145,144,4,55,210,52,143,110,253,249,229,27,231,169,88,227,73,239,121,37,230,47,94,195,216,2,18,242,34,252,148,164,167,13,41,13,240,240,165,93,215,54,90,123,160,252,219,130,87,229,154,221,180,81,221,78,108,211,32,114,168,106,157,144,87,86,61,82,184,227,189,120,201,128,216,235,13,144,166,222,233,244,30,126,188,82,198,83,202,219,221,140,229,66,103,126,12,217,216,4,232,80,151,181,185,221,85,166,53,38,104,11,97,215,49,83,11,187,116,208,238,61,125,128,18,174,115,49,250,243,120,63,94,185,103,57,204,41,53,62,186,12,111,201,56,119,184,230,134,75,73,63,249,23,30,49,159,83,161,137,31,20,130,221,20,138,174,209,61,55,8,61,140,128,97,23,218,207,4,43,96,125,109,55,164,253,149,201,150,64,51,216,94,169,87,199,91,79,200,6,89,15,83,131,142,198,79,52,21,89,16,191,169,36,225,82,85,9,125,230,13,161,75,236,106,159,158,27,5,58,193,66,67,27,174,18,176,236,183,10,70,62,235,213,67,202,139,160,5,96,255,235,118,1,217,207,4,199,95,4,102,202,45,174,163,31,120,7,210,127,168,198,33,91,178,251,229,86,178,49,225,226,100,139,202,178,213,138,163,137,236,146,129,15,3,124,116,206,55,231,152,217,208,61,135,101,141,198,11,203,125,56,176,213,170,252,234,146,97,165,212,208,187,226,26,161,188,44,47,188,167,160,242,159,60,233,159,218,150,204,222,239,85,67,164,206,67,196,65,240,37,27,42,164,122,51,142,156,239,45,149,125,169,73,193,134,160,132,233,84,227,231,233,9,191,106,28,233,122,34,121,29,107,199,199,48,6,85,158,249,3,253,93,5,38,182,247,2,251,65,10,41,163,13,146,184,0,90,84,238,141,18,157,209,198,195,194,49,144,33,78,230,113,48,163,25,2,252,229,177,120,235,168,72,195,57,35,89,33,29,40,80,24,205,13,253,246,76,165,121,7,236,55,125,0,194,113,113,126,74,160,158,183,211,65,127,62,242,2,206,61,68,132,182,140,12,166,192,193,174,141,25,160,89,114,147,85,12,113,142,52,218,41,104,74,128,229,60,202,11,137,194,211,3,25,96,229,27,188,15,99,147,155,88,123,6,128,40,90,13,203,244,19,57,157,199,101,176,83,217,208,62,234,223,191,243,212,233,146,236,163,22,36,218,222,203,6,39,8,163,145,239,183,2,79,40,27,189,24,196,18,209,39,80,122,254,89,190,35,109,188,177,129,136,139,232,153,233,108,188,36,73,37,253,135,168,47,77,203,184,181,77,137,51,1,129,29,221,108,106,254,166,205,212,229,220,237,6,122,196,197,238,109,120,140,91,236,176,119,78,4,124,83,64,167,99,100,99,223,33,118,153,240,108,73,42,218,135,121,9,37,155,201,122,53,116,203,158,124,30,133,217,81,110,167,26,49,189,236,221,47,64,120,154,215,189,230,10,213,125,247,163,181,34,135,177,121,153,150,249,81,138,253,185,63,83,4,206,119,153,219,204,138,92,192,210,171,206,254,127,149,103,82,144,223,6,238,2,9,175,100,74,28,214,58,87,12,14,212,13,76,174,192,174,147,218,113,1,90,130,25,232,85,243,248,53,173,33,242,100,130,45,195,42,51,163,246,185,83,103,149,33,249,165,161,177,151,22,173,137,12,212,229,201,82,34,13,57,2,245,218,77,238,60,10,22,200,247,171,101,0,92,29,226,11,174,6,131,167,51,240,146,7,245,191,188,12,48,222,27,212,240,254,67,23,42,199,141,233,79,228,104,216,13,155,190,199,159,242,96,110,187,181,66,78,66,28,197,147,134,63,24,118,12,1,219,66,115,193,159,16,231,202,131,16,115,83,150,39,39,225,137,10,96,236,206,121,183,24,25,253,78,176,8,97,101,37,113,242,89,50,64,118,146,13,127,100,162,9,146,69,135,252,200,250,108,109,171,172,69,229,182,209,189,31,74,165,102,69,167,193,52,164,253,156,242,29,32,96,24,161,217,190,245,178,110,62,129,67,61,131,11,10,105,217,136,86,178,47,31,244,96,128,140,76,21,79,128,230,86,140,161,89,184,51,219,217,155,148,181,73,77,145,200,246,193,105,48,137,7,67,63,89,190,19,167,135,173,177,223,127,168,9,89,238,241,191,237,117,97,65,203,44,82,190,199,250,143,254,90,184,206,15,146,74,100,14,116,84,184,191,29,215,139,43,116,33,238,136,3,231,78,111,181,86,171,90,148,196,136,69,159,45,205,232,13,203,82,57,2,65,78,218,19,107,5,212,140,38,250,22,241,16,17,201,107,130,138,88,55,235,49,225,23,18,194,65,221,227,252,185,236,117,108,40,103,210,143,146,204,207,116,198,56,98,121,99,86,173,120,109,246,18,176,134,195,85,11,216,114,22,111,122,89,255,25,210,64,231,100,247,62,150,217,217,235,15,75,108,61,98,84,226,83,33,103,225,52,103,42,32,12,135,252,107,45,96,223,123,104,114,168,104,243,139,75,108,119,108,175,232,32,214,43,1,74,82,73,237,13,121,247,73,237,201,83,98,228,176,115,220,247,58,162,38,64,98,214,250,146,137,249,222,252,76,207,56,0,48,45,214,220,117,32,95,164,148,136,129,146,74,71,208,139,175,99,0,46,98,150,1,87,249,238,7,108,47,139,26,177,81,241,82,106,78,155,19,5,77,205,29,205,135,196,125,201,155,49,129,130,78,117,242,20,89,176,0,3,12,127,27,173,57,190,233,132,80,15,36,41,124,187,243,158,129,77,141,71,83,235,245,24,124,209,10,220,87,192,14,104,188,233,97,242,197,21,185,13,111,50,71,233,218,40,221,15,133,71,164,62,193,197,143,246,103,194,238,130,169,196,213,27,49,70,163,106,252,179,116,187,72,238,173,201,91,68,183,69,217,180,164,127,132,16,109,242,122,81,175,217,10,221,158,67,98,125,4,206,184,200,58,66,28,153,40,108,52,63,12,157,69,170,82,138,54,188,57,163,57,21,138,199,170,99,250,252,15,242,46,222,76,126,39,176,14,16,101,5,171,53,103,75,99,90,90,19,10,136,174,118,125,107,75,225,165,99,63,83,128,141,104,231,116,144,42,180,31,194,184,59,21,121,244,16,234,117,20,208,119,189,67,217,98,105,162,52,87,177,10,160,51,69,68,192,117,77,233,206,211,89,152,134,210,15,120,217,233,216,118,71,181,57,56,127,151,131,157,5,150,224,79,0,230,250,214,193,179,235,243,164,85,235,239,214,11,252,99,233,115,150,184,64,120,213,218,136,232,168,19,118,146,24,35,223,231,164,103,176,136,45,242,225,107,152,124,128,137,188,195,245,22,36,62,8,135,155,20,221,200,127,213,129,53,1,130,98,140,24,4,123,241,47,169,116,196,161,32,217,157,66,135,228,12,252,45,176,47,41,166,211,75,244,169,70,77,218,236,100,158,123,41,125,137,215,238,87,178,192,30,68,196,44,11,88,222,188,151,124,17,68,81,190,133,203,240,227,71,226,132,191,10,247,231,14,19,211,64,63,186,82,215,142,12,231,175,165,138,90,88,164,74,184,250,138,28,21,94,90,192,54,230,116,76,46,161,120,48,123,206,224,204,37,16,31,115,12,241,253,56,1,101,22,235,164,50,23,43,243,254,121,119,250,147,52,55,29,14,76,64,244,86,130,224,26,151,228,2,1,165,33,36,75,146,208,45,23,112,114,155,249,28,177,157,253,73,68,212,199,51,225,33,219,90,165,12,48,76,146,170,244,116,55,154,81,8,36,153,135,64,96,62,125,1,166,115,167,107,81,156,218,185,18,131,250,6,138,254,49,5,5,33,95,61,182,91,5,140,46,241,95,174,80,89,85,155,148,5,8,204,59,6,78,253,230,18,63,203,145,143,23,15,171,232,86,45,8,53,145,218,100,219,164,124,30,187,170,14,97,144,39,220,103,114,64,9,225,24,8,93,228,132,46,18,47,3,83,76,57,162,242,186,183,123,22,239,184,171,211,18,114,84,217,2,118,246,212,22,237,202,193,185,47,50,145,115,198,248,121,38,134,134,187,48,82,225,82,213,181,114,26,154,78,255,75,138,166,107,220,103,8,176,223,244,207,122,2,152,116,59,204,149,4,29,193,230,40,35,220,114,51,76,174,98,74,104,150,170,128,30,231,92,73,120,232,16,255,213,214,232,92,63,223,211,123,222,33,222,221,63,29,162,113,76,13,232,148,253,237,199,112,94,62,221,231,149,186,232,19,207,159,184,180,163,100,38,56,35,242,128,50,135,108,1,22,64,104,13,236,102,105,156,144,129,219,55,56,37,127,186,159,102,161,11,207,251,208,181,37,84,126,5,82,24,81,248,179,19,116,75,42,242,36,147,66,233,131,189,83,186,179,159,29,155,135,100,55,111,190,242,87,104,230,49,245,213,192,182,233,93,234,162,43,184,7,47,5,188,89,145,60,180,213,7,53,242,128,225,147,201,233,155,243,236,182,137,162,250,146,132,118,240,31,130,176,232,175,106,210,54,132,141,133,214,235,106,160,92,147,253,221,213,191,146,17,4,84,57,134,135,13,173,42,248,176,113,28,153,43,123,18,132,175,55,20,56,15,34,67,238,187,251,206,221,98,172,26,189,196,202,81,76,22,116,50,16,222,42,227,174,59,98,21,90,193,4,39,30,101,42,73,78,149,68,85,167,166,65,159,117,97,0,128,77,137,228,47,126,222,193,149,247,66,180,33,157,85,199,207,228,153,90,78,49,87,236,218,241,187,23,186,222,55,137,167,255,14,149,32,84,105,76,49,71,4,171,184,132,109,193,52,184,3,7,229,157,216,211,193,74,147,245,192,42,150,232,6,70,82,32,249,189,184,92,135,135,108,192,30,188,109,164,220,9,217,27,17,227,204,120,170,160,230,103,190,161,162,117,237,211,137,76,161,95,219,62,67,97,236,138,53,128,153,16,148,60,135,158,216,205,141,63,215,191,51,186,244,215,67,94,12,189,153,142,166,248,234,240,135,242,158,15,37,27,70,100,44,96,112,113,131,148,64,36,91,101,159,86,149,25,137,4,101,93,122,240,84,12,165,241,31,16,12,16,56,12,16,241,67,197,241,132,48,141,242,188,221,153,112,124,214,11,52,75,137,206,94,158,12,134,101,47,143,235,192,191,234,194,209,68,243,113,218,152,131,36,116,208,225,7,39,184,203,233,184,2,96,123,91,74,107,78,151,11,116,140,135,77,58,84,170,175,5,39,213,215,179,114,171,37,52,48,255,85,176,13,187,60,80,160,211,185,8,18,29,131,153,42,142,126,157,106,84,87,104,244,123,98,224,46,24,122,246,200,229,1,137,17,71,82,94,81,53,58,161,167,36,135,180,123,100,225,142,183,149,103,79,115,70,56,112,212,145,242,101,202,127,218,47,104,191,41,204,121,81,196,141,61,174,200,29,119,119,222,144,80,127,232,208,120,194,205,171,18,168,16,233,220,157,208,141,20,124,222,235,158,52,57,78,212,37,246,43,14,0,45,1,130,10,251,62,116,158,142,183,111,102,130,26,122,116,152,118,242,131,213,17,227,152,144,221,9,80,211,123,9,98,221,247,171,62,183,36,15,187,25,195,56,63,66,117,151,253,95,175,66,34,164,211,211,45,69,94,93,27,101,154,87,244,112,42,112,117,182,54,185,81,117,171,159,184,8,91,91,202,132,79,2,5,123,154,43,205,98,224,164,112,180,110,106,212,184,192,144,205,216,78,213,207,255,204,206,182,157,194,204,224,78,74,44,203,176,69,42,88,135,209,205,116,204,247,113,255,136,144,199,162,210,18,72,16,69,96,156,228,59,162,237,160,32,36,71,186,156,165,168,128,23,185,16,36,73,65,97,135,222,242,44,130,171,6,227,214,155,224,53,66,212,12,133,80,221,17,112,79,169,207,248,236,150,30,14,10,119,210,255,178,82,27,50,142,129,5,19,33,33,98,34,187,131,217,43,63,182,50,179,66,30,249,212,239,189,31,241,17,237,74,128,224,143,148,242,213,188,77,158,164,136,30,228,79,182,209,88,89,123,95,117,43,111,134,251,77,193,35,242,42,211,43,207,241,25,166,222,232,121,249,121,8,32,146,92,32,177,81,221,88,119,97,241,74,72,115,25,85,122,172,23,72,36,77,201,92,209,173,44,177,146,194,69,56,51,171,150,105,138,55,115,44,150,112,21,121,83,155,160,43,118,70,231,10,222,247,4,235,84,198,176,110,165,96,25,207,134,117,96,194,48,138,208,224,72,16,180,80,111,149,94,14,168,170,137,60,48,229,15,187,243,166,65,198,157,241,147,90,161,216,80,24,226,92,147,118,223,62,123,220,84,92,168,247,218,254,29,141,143,156,34,21,153,111,148,120,108,73,16,29,219,26,34,57,103,63,93,19,133,223,45,5,5,219,86,34,118,106,146,117,74,85,79,8,236,147,197,44,75,169,43,86,89,232,223,120,171,112,60,110,30,124,56,7,228,192,11,161,120,120,60,77,209,152,133,203,98,147,146,198,69,97,138,86,190,104,143,146,143,234,145,123,218,157,185,73,163,37,129,57,129,140,7,57,43,237,149,18,116,175,109,219,22,38,12,214,201,133,215,150,72,168,205,118,139,24,221,236,246,9,205,166,254,141,224,25,184,0,93,59,99,103,4,250,54,27,221,108,188,48,233,15,37,51,47,72,155,223,247,216,184,203,27,200,133,12,136,82,166,7,190,36,71,185,94,89,54,50,129,199,135,54,77,144,235,215,238,182,171,219,232,185,192,103,226,159,248,12,225,90,181,211,223,81,42,108,51,166,225,143,32,83,97,130,194,84,211,8,224,231,109,252,58,52,215,67,79,10,192,248,53,173,170,190,211,40,190,254,225,53,71,187,157,155,59,100,201,60,143,182,26,237,144,211,33,168,177,120,230,107,151,59,54,152,147,67,69,52,159,252,171,225,189,55,4,46,107,37,144,33,194,110,52,105,225,156,82,108,244,249,176,135,121,46,78,202,160,229,96,134,217,77,237,114,92,160,133,63,126,2,158,4,2,241,163,147,27,242,222,23,53,17,100,200,215,55,139,40,6,159,204,119,208,164,146,254,241,204,112,154,56,71,228,37,81,21,200,243,200,109,212,134,234,149,32,127,53,42,76,222,119,250,125,189,28,51,199,89,86,224,73,162,22,171,184,57,3,131,146,253,16,115,189,193,210,50,185,245,158,109,216,229,193,230,237,243,101,253,157,178,8,89,131,235,97,103,14,197,32,154,118,165,199,228,219,96,122,2,84,170,70,134,214,241,109,18,101,179,40,145,153,149,83,105,141,35,130,225,166,142,105,84,147,11,203,130,159,252,101,126,166,29,69,210,190,247,129,180,36,193,159,43,138,30,48,166,142,127,94,240,213,148,74,208,130,92,36,181,106,26,109,40,171,18,112,183,67,205,77,75,201,220,147,33,239,68,142,85,252,148,110,160,142,120,143,246,130,157,205,111,4,124,161,69,101,241,113,112,0,194,226,94,119,216,51,43,56,126,31,177,184,14,75,69,175,126,45,75,135,27,7,177,104,124,187,110,58,108,56,140,203,246,172,157,17,118,20,142,157,225,188,129,247,249,244,137,41,95,194,4,51,26,73,40,135,66,161,161,72,15,217,205,115,210,188,188,126,131,225,251,76,95,65,101,190,76,212,91,197,56,54,31,126,168,108,66,90,7,181,48,43,86,29,89,181,1,110,41,101,37,218,180,7,0,175,75,93,55,127,110,235,14,170,217,254,91,52,248,86,81,214,253,194,221,57,216,133,80,114,235,113,181,199,220,65,219,85,147,73,28,166,159,118,110,60,47,125,82,94,67,113,229,18,32,86,201,139,236,229,132,177,233,181,15,33,20,116,190,178,70,62,98,61,63,109,59,173,140,8,231,24,178,201,158,19,199,50,46,5,57,48,7,207,142,241,164,243,179,192,113,27,104,246,55,11,225,196,216,60,66,250,159,141,225,19,63,171,144,174,50,222,207,20,53,108,192,190,9,6,36,188,79,105,76,63,26,146,215,216,96,198,77,20,20,87,255,23,246,39,218,75,200,179,206,198,87,177,117,97,223,14,198,201,88,22,103,227,46,102,33,237,243,30,26,182,223,223,120,27,42,172,208,199,168,129,58,207,238,2,194,241,164,152,10,229,67,181,199,112,187,134,246,201,156,113,25,223,162,66,29,106,144,221,178,112,86,192,9,87,135,221,151,46,191,191,231,243,191,192,20,28,161,51,84,16,114,221,11,54,72,99,191,90,162,6,26,216,13,86,29,66,47,17,196,41,253,8,25,132,4,232,59,90,173,86,156,120,236,11,180,82,143,54,154,142,129,172,216,102,80,167,52,238,184,97,220,200,78,0,168,169,66,11,143,219,152,195,4,245,12,175,139,127,171,14,7,166,2,231,69,40,80,177,73,128,86,204,180,30,36,99,178,161,219,3,193,204,125,237,5,97,197,229,254,76,189,96,84,99,104,246,239,202,140,42,64,148,164,173,10,35,242,66,42,156,124,11,7,29,107,224,195,131,243,162,79,198,192,206,176,235,38,111,25,150,142,110,211,174,48,100,188,85,25,148,240,241,73,185,130,8,70,139,30,63,236,126,111,31,108,12,70,37,115,89,126,35,97,208,124,43,78,15,190,60,10,206,111,179,135,14,253,167,162,6,204,8,130,98,76,98,160,94,0,218,204,243,228,118,237,245,109,192,120,236,161,127,200,79,241,120,25,176,130,91,214,96,198,60,238,71,44,78,162,80,254,220,250,221,132,7,114,92,219,247,243,121,109,171,199,181,34,233,17,13,242,167,33,139,160,64,59,67,227,135,46,144,68,239,58,73,95,140,250,87,8,188,121,240,224,0,1,184,196,33,91,182,253,182,48,55,24,135,54,50,215,28,229,251,162,228,6,98,218,116,61,177,215,95,60,175,209,57,93,244,193,25,100,5,205,154,102,53,229,32,154,207,120,167,199,195,117,75,10,93,95,34,214,241,16,142,162,54,115,94,144,142,69,42,59,137,248,154,149,6,166,215,64,207,94,166,147,178,240,51,242,135,37,181,201,136,23,42,92,200,47,146,201,166,234,198,218,78,70,52,125,210,237,37,168,67,82,197,248,95,116,41,162,59,12,135,201,216,245,246,235,61,153,251,54,155,119,250,230,88,108,196,34,217,109,53,254,41,90,104,176,89,30,110,240,211,85,141,59,145,82,117,205,2,83,170,120,128,31,204,231,204,69,39,61,177,70,172,180,98,32,192,146,131,106,65,106,22,160,243,154,218,50,159,39,189,22,133,73,117,154,120,170,70,173,133,141,205,149,46,152,206,110,169,71,53,215,226,14,227,171,200,180,42,238,27,252,119,198,193,65,223,32,30,194,113,86,149,186,202,220,247,22,7,242,79,198,91,163,249,152,121,218,210,189,83,59,102,45,234,122,64,115,202,2,15,5,254,196,6,118,22,38,185,21,80,216,224,0,27,7,178,41,182,9,252,216,17,48,157,53,169,30,243,32,155,247,62,154,249,104,197,196,158,64,187,82,174,54,251,200,44,19,89,175,241,60,251,107,237,47,126,29,190,11,89,36,74,197,234,228,106,14,194,39,5,84,106,144,36,209,251,165,51,117,248,165,227,129,108,190,196,194,53,87,156,118,212,204,139,216,33,111,163,245,172,189,13,36,244,116,45,69,108,77,159,177,94,241,217,99,102,233,179,206,211,230,181,62,192,100,218,86,98,4,57,20,141,73,60,117,180,204,161,37,248,184,133,123,237,168,18,82,187,137,91,59,131,221,18,203,93,119,130,240,83,114,96,152,66,90,197,245,246,33,136,152,121,76,142,181,46,111,136,61,6,91,46,166,77,10,75,38,136,209,55,173,182,254,96,202,190,176,253,49,126,104,74,79,129,15,234,163,129,96,235,238,182,120,158,66,65,205,95,52,181,233,44,134,132,21,162,135,173,55,46,35,241,39,253,21,184,116,149,41,26,176,74,246,12,88,205,212,58,4,94,48,68,89,123,79,17,8,59,202,218,37,109,95,21,129,15,161,237,51,200,134,142,102,223,126,240,115,77,71,106,151,215,57,68,53,222,251,108,210,57,69,220,245,178,162,137,17,73,126,65,174,197,239,244,64,110,141,163,57,151,25,47,170,125,109,7,20,122,236,9,57,21,56,18,200,184,98,123,137,71,213,79,145,183,60,45,58,21,140,78,191,162,230,55,88,82,221,149,127,131,162,100,80,51,7,162,97,240,93,41,237,184,110,158,106,106,208,139,40,234,136,121,195,178,218,164,53,53,223,131,6,36,24,61,154,60,140,88,208,240,154,246,196,27,148,183,78,114,80,105,189,159,182,70,228,179,246,55,180,174,166,198,84,238,44,60,54,177,170,32,221,75,194,35,141,185,15,30,192,205,42,2,126,10,82,165,243,167,101,167,46,207,206,145,28,171,36,69,87,98,195,169,208,70,177,15,32,92,236,136,159,176,205,70,6,128,56,69,70,13,116,178,101,221,53,86,52,145,217,5,72,206,57,38,107,254,234,69,59,162,254,145,132,152,135,142,247,117,32,151,62,177,179,101,40,10,14,207,56,164,45,249,3,42,106,77,108,33,218,121,105,66,34,3,24,138,219,114,114,254,218,116,47,185,182,81,195,23,99,219,22,14,184,113,28,64,139,2,12,137,27,195,64,70,214,242,247,105,17,117,173,153,208,60,2,228,85,155,115,0,72,182,59,81,76,99,146,247,247,160,24,111,2,122,1,221,129,142,12,94,112,135,20,226,194,180,28,136,31,87,253,104,215,220,150,134,78,100,123,190,21,244,40,48,55,96,85,54,185,36,52,191,210,131,221,10,132,26,229,204,12,53,253,31,85,66,51,88,174,104,122,237,52,200,221,10,16,190,214,182,91,142,93,52,116,211,131,118,115,161,67,95,111,147,17,25,126,72,44,223,195,128,46,46,226,91,15,254,236,104,177,12,104,91,182,170,159,5,139,146,13,212,248,48,159,28,33,154,61,111,172,63,129,142,157,193,255,126,30,102,134,7,157,196,169,206,120,88,127,182,139,190,0,158,191,135,9,216,149,113,190,60,33,72,142,207,27,121,221,40,188,101,255,232,100,10,72,32,175,44,166,77,25,16,117,248,243,117,193,46,122,129,93,102,167,243,195,107,90,205,143,148,45,31,205,3,109,96,124,233,168,9,51,220,197,27,234,103,24,148,53,207,83,25,15,60,235,167,241,195,32,255,13,149,223,190,224,8,105,85,13,180,129,120,64,191,191,16,10,36,252,14,90,62,206,180,26,2,248,56,32,65,117,210,250,163,39,180,56,128,223,203,58,157,17,97,204,166,72,130,168,134,37,208,164,254,9,30,178,156,110,161,107,17,117,247,92,198,205,131,42,194,204,102,238,131,33,191,92,147,236,96,93,209,156,181,232,106,158,217,36,193,19,156,208,138,246,162,104,68,48,146,101,198,251,121,127,78,237,12,14,177,203,26,94,104,127,247,67,29,229,78,80,42,101,159,149,136,0,248,31,218,149,236,248,99,249,134,41,237,136,7,201,66,74,150,207,65,78,138,32,42,48,33,205,251,143,156,210,39,12,94,78,225,192,223,136,232,168,254,177,70,180,230,167,8,207,69,176,141,78,32,162,98,209,105,23,137,251,120,32,31,126,252,250,207,223,84,223,41,222,63,249,38,180,19,179,223,53,21,196,244,81,18,52,216,162,84,196,243,181,15,195,238,177,82,132,255,90,2,225,240,123,124,36,226,182,4,214,91,197,131,3,96,122,111,198,132,136,5,22,98,95,87,220,52,52,200,159,108,224,194,237,89,46,173,173,225,34,219,212,83,157,237,32,38,177,248,250,153,116,13,28,237,176,114,238,131,231,26,50,212,10,139,93,46,224,31,220,224,156,54,191,97,127,67,107,95,181,193,144,132,13,237,225,196,235,181,128,168,10,132,207,252,12,160,113,247,146,142,86,142,221,182,149,172,59,215,64,207,241,211,220,225,80,97,45,13,49,106,199,211,171,31,16,55,63,114,14,76,244,208,26,92,213,59,221,79,21,64,30,167,167,121,192,67,33,51,42,249,245,254,127,80,90,50,140,17,106,124,153,227,42,1,115,128,188,153,165,127,123,32,45,255,9,110,60,62,105,215,164,153,182,70,237,78,127,13,228,107,214,230,224,72,215,63,124,205,74,34,52,103,205,117,205,252,177,7,69,174,49,63,224,30,186,142,137,112,103,175,198,145,35,207,13,15,23,247,88,180,88,200,65,254,195,216,25,95,87,178,201,247,6,73,39,104,81,191,189,143,26,57,25,120,79,14,176,250,38,191,160,53,114,153,25,192,223,241,62,56,182,222,233,73,130,244,98,112,41,114,16,59,216,66,98,75,181,51,172,83,145,35,88,158,152,152,248,29,235,144,22,93,155,85,48,167,178,0,69,34,3,43,248,83,222,18,153,188,47,90,73,216,202,27,167,93,247,95,55,107,66,70,70,128,58,4,105,136,138,29,13,46,81,67,199,214,242,31,130,240,192,129,248,74,205,68,57,163,203,178,94,216,39,76,188,176,18,211,161,49,39,190,230,66,204,242,211,54,95,152,198,193,0,37,167,52,29,219,86,20,215,127,222,199,169,207,187,235,186,183,97,32,133,227,173,208,105,2,119,44,188,134,176,46,108,158,155,57,100,219,102,61,132,245,83,91,10,95,95,178,175,231,99,73,145,22,115,64,157,67,80,98,214,83,124,98,151,30,164,183,50,106,245,156,196,253,219,195,112,124,58,38,128,185,114,20,133,226,44,42,79,119,225,197,160,152,200,242,78,237,206,136,136,220,211,238,42,188,83,147,174,82,203,179,43,167,108,19,234,180,13,7,162,71,209,205,12,74,154,130,102,253,168,221,1,12,136,96,96,162,113,142,10,227,61,72,155,180,38,21,95,236,82,19,33,14,47,208,15,0,153,102,246,253,146,66,12,188,123,98,131,101,50,130,21,161,75,118,186,158,18,182,228,150,119,250,174,148,149,241,163,231,236,226,234,64,171,218,89,215,168,24,116,4,177,73,146,142,219,188,254,113,174,248,202,17,253,213,162,252,11,60,61,14,228,240,255,142,21,202,181,70,129,149,215,172,48,100,232,162,143,16,195,36,213,40,196,240,219,127,240,46,188,167,222,184,61,190,254,208,30,28,50,29,146,241,106,214,42,107,21,49,136,203,152,218,139,160,188,76,105,125,184,210,237,198,76,47,174,201,164,168,30,45,34,160,78,86,16,89,42,37,145,19,230,196,158,49,225,181,95,73,100,104,136,90,152,115,229,49,220,37,19,191,43,25,162,44,243,53,84,183,88,4,21,115,237,206,214,159,200,91,229,106,253,19,81,215,152,116,55,241,143,56,149,81,207,165,125,113,245,115,216,125,227,2,102,117,99,197,232,139,61,41,167,174,246,177,247,28,254,47,33,211,179,172,229,239,251,47,101,48,176,112,100,227,89,224,144,201,237,72,227,165,67,30,13,1,244,163,199,238,45,97,77,204,19,116,250,187,111,67,41,7,8,94,241,90,198,159,41,71,88,175,156,46,74,1,7,185,43,101,155,5,61,220,84,170,10,172,6,178,120,161,11,20,132,150,206,209,110,139,228,111,71,151,75,200,152,92,62,54,175,53,159,145,241,93,166,229,181,140,141,150,16,239,214,88,76,169,54,151,71,57,35,49,181,204,142,123,221,243,116,27,42,7,206,156,244,5,225,88,48,3,237,28,16,232,229,0,233,113,243,180,29,167,242,183,5,60,73,67,17,62,231,10,76,95,198,1,25,144,207,111,115,6,195,3,152,233,98,45,103,123,85,188,114,32,34,32,210,209,128,107,6,139,24,90,225,238,236,146,159,232,202,43,125,174,140,125,213,212,176,204,199,52,158,223,208,244,13,122,27,193,32,52,157,100,253,119,63,205,241,86,23,188,95,41,202,51,163,84,190,51,255,232,205,69,30,63,170,196,114,30,82,64,57,35,8,242,61,221,62,244,124,205,138,217,39,251,112,237,24,254,35,108,106,204,152,231,61,126,203,24,236,154,11,65,145,231,9,60,211,244,35,161,146,204,219,67,147,118,61,185,166,103,149,32,7,111,22,77,238,127,231,25,146,242,126,35,23,61,169,177,249,73,151,97,224,108,211,33,112,111,167,104,63,36,70,106,30,20,142,220,160,146,104,212,34,231,127,68,209,227,121,78,197,89,98,9,84,249,143,76,151,63,216,218,5,28,6,148,209,48,173,253,234,115,70,163,30,6,178,12,252,17,217,162,231,225,94,32,55,118,206,37,196,145,124,125,60,191,57,216,76,220,121,94,94,105,21,52,50,222,47,98,123,110,36,77,12,41,72,63,117,225,65,8,65,90,23,51,159,3,145,88,135,84,127,84,19,236,86,65,112,83,142,172,187,151,85,192,132,106,226,183,93,169,184,87,154,126,208,176,204,214,75,138,89,173,103,237,133,214,28,140,63,198,222,169,86,157,230,246,123,36,212,240,147,132,194,243,18,20,106,231,210,190,72,1,209,98,132,117,12,150,182,232,119,95,229,185,105,6,189,131,63,252,247,65,77,198,92,185,95,13,200,22,125,12,2,220,178,51,127,85,90,16,166,157,201,177,6,60,146,221,153,220,236,182,175,221,197,142,254,140,161,191,48,234,155,15,27,89,166,72,19,255,167,161,184,26,203,192,220,67,202,196,45,227,179,151,180,76,239,235,77,233,142,152,27,191,219,80,29,141,73,79,99,83,223,57,92,30,111,64,0,188,254,4,41,231,111,6,216,131,30,203,9,246,232,29,213,255,18,119,158,128,51,134,187,166,120,92,84,192,29,87,216,39,221,99,168,72,65,3,218,253,31,213,45,119,90,213,206,201,243,218,52,48,121,199,17,247,128,87,79,223,107,181,59,241,227,9,209,89,174,157,36,230,204,104,209,86,7,197,202,126,147,204,15,95,154,203,146,116,117,199,67,123,29,46,36,37,176,209,208,130,194,47,199,56,97,251,228,230,242,2,71,174,107,245,92,148,206,238,29,238,26,178,9,87,159,63,59,99,67,207,123,195,196,109,57,129,184,1,236,108,137,52,201,175,7,128,47,115,189,141,211,39,121,17,134,206,178,1,31,171,103,138,118,211,235,41,234,121,39,134,243,241,239,113,255,197,9,235,102,86,156,120,140,196,142,27,122,158,206,114,10,251,138,229,39,249,232,230,20,120,155,238,120,246,172,128,132,125,223,136,135,130,67,89,131,186,9,191,228,170,232,195,201,73,106,38,152,186,220,130,88,230,242,131,130,27,204,147,198,243,212,225,119,45,51,205,140,77,240,57,201,97,129,130,224,170,200,208,103,206,219,102,2,216,56,18,236,48,6,122,194,56,152,22,180,6,228,224,155,152,57,105,174,219,212,172,194,176,40,252,138,160,174,101,28,185,220,166,222,241,130,123,81,252,221,175,27,187,236,243,68,246,252,195,24,113,37,101,187,196,124,187,22,180,121,182,188,76,166,60,30,188,250,7,33,73,62,104,185,187,88,46,104,172,153,81,228,198,11,109,209,199,60,18,244,180,99,128,255,203,29,224,207,253,2,58,248,26,31,106,161,231,105,127,129,23,177,194,135,108,26,0,203,225,164,104,133,53,235,98,230,11,124,103,227,23,159,189,229,181,0,208,96,238,4,91,34,74,220,194,85,38,223,25,179,181,40,116,95,196,75,83,178,158,237,162,234,36,138,227,252,116,134,145,245,221,139,151,190,229,24,203,141,7,142,148,212,70,59,3,163,146,101,157,158,96,232,125,38,147,170,65,132,191,171,135,24,236,212,76,2,66,151,119,53,229,3,65,18,133,159,160,71,22,208,179,106,159,232,180,90,215,136,32,240,233,209,178,224,154,236,103,245,160,190,211,61,90,118,17,110,122,187,77,58,32,13,16,201,136,20,167,201,125,90,224,51,197,18,133,210,82,79,160,115,206,177,120,114,140,12,200,229,216,199,193,216,228,127,79,62,6,120,109,210,142,79,1,49,194,129,55,209,65,247,179,87,42,104,200,83,136,174,32,99,245,148,87,88,159,43,91,50,116,209,12,170,142,157,42,0,23,252,229,162,239,244,82,53,100,98,101,86,223,159,207,175,92,73,90,46,129,129,248,34,96,85,176,237,15,29,153,15,110,130,208,227,110,235,8,149,229,7,207,209,190,21,56,254,251,42,63,238,168,167,90,13,27,79,42,186,163,127,104,206,46,137,190,81,105,247,122,229,32,166,2,68,54,180,108,225,229,39,45,132,30,168,172,83,249,240,125,75,47,253,210,106,145,134,36,38,125,160,179,68,181,176,97,247,14,214,208,165,230,129,247,45,189,170,216,55,161,129,242,114,95,175,38,14,9,59,113,119,157,27,192,12,14,232,156,170,147,52,76,58,192,118,9,136,255,253,99,130,168,160,68,195,190,211,14,232,109,210,246,116,23,119,22,203,83,212,45,112,125,42,180,82,117,206,123,97,248,229,139,220,97,164,86,21,112,81,83,248,90,47,89,158,18,154,32,177,178,200,103,176,108,225,79,210,17,223,35,94,161,192,180,70,96,2,221,245,129,110,235,197,138,218,222,174,115,6,6,238,124,85,205,126,64,212,209,7,2,107,84,9,255,42,36,35,45,49,68,18,108,8,216,109,154,69,78,71,104,158,213,85,134,26,105,136,221,168,86,0,114,76,243,65,121,149,196,109,144,91,51,185,127,198,7,130,128,39,243,99,228,102,195,74,157,69,242,52,81,123,191,125,177,66,243,1,215,110,235,220,35,93,39,64,132,55,38,22,178,103,48,155,131,30,36,142,74,226,62,210,246,73,83,242,185,182,2,197,250,229,64,5,180,153,71,220,155,232,11,101,254,118,8,128,140,195,80,42,106,70,51,193,148,229,18,3,71,16,30,238,215,204,22,173,88,75,153,228,0,199,161,19,197,248,90,206,125,108,238,195,221,221,148,131,94,224,100,95,165,33,232,19,95,195,62,245,214,5,205,106,190,247,181,95,163,241,186,237,186,198,36,181,86,108,18,224,100,56,41,211,7,216,59,1,69,168,93,33,169,218,162,21,132,247,121,246,188,231,69,121,46,113,122,39,229,36,193,245,101,93,102,127,157,177,31,247,206,9,219,192,57,231,65,40,130,93,94,33,202,214,196,206,71,9,72,50,214,141,9,72,137,82,205,101,177,115,81,50,128,71,240,105,211,91,177,223,50,81,233,139,175,62,129,94,53,107,67,88,124,64,209,124,1,146,94,178,100,122,213,77,50,128,5,208,107,158,70,245,203,19,79,188,38,79,62,11,131,169,236,181,165,205,189,167,84,34,76,255,35,170,28,18,65,27,191,38,155,158,78,116,183,15,172,62,59,160,239,59,119,64,207,131,167,68,16,127,101,133,252,39,1,123,29,30,138,229,6,138,150,67,32,33,192,155,63,241,125,231,113,163,142,197,196,81,229,6,12,75,204,230,197,26,11,85,31,92,40,230,82,7,26,11,125,35,180,166,141,206,232,163,12,131,110,231,3,104,67,132,176,194,180,69,250,81,69,168,119,59,157,57,28,117,66,77,166,12,237,28,140,31,203,55,144,203,98,78,205,11,234,53,26,84,69,73,91,190,82,199,204,84,186,102,158,36,209,159,43,209,175,178,224,24,165,79,179,91,176,145,196,144,13,153,124,118,45,14,250,141,230,222,155,144,43,183,191,26,230,11,158,89,21,22,29,171,145,241,210,92,219,138,168,191,151,214,219,235,35,76,229,167,71,28,93,17,31,92,52,164,65,138,65,46,0,101,4,183,215,16,2,182,201,213,21,103,131,235,53,42,194,38,124,16,196,170,184,35,60,242,148,217,65,214,124,78,57,196,64,28,77,237,198,64,243,233,28,187,255,178,181,21,170,160,196,36,13,131,142,91,113,248,139,64,18,90,205,64,167,184,48,202,202,14,183,40,218,167,104,205,100,199,12,37,120,233,26,57,37,51,10,228,201,163,54,127,234,237,39,12,133,240,254,208,252,195,144,89,74,170,235,232,5,60,24,188,71,136,195,245,125,215,20,136,205,145,182,223,228,175,22,170,59,5,211,46,101,202,182,163,28,199,99,60,93,216,11,164,101,175,246,143,115,53,123,179,22,165,12,26,120,170,109,121,69,190,237,108,137,174,11,103,0,104,209,8,129,123,108,49,52,252,203,196,139,248,176,6,112,112,14,11,235,15,77,69,50,51,198,121,226,172,115,245,86,10,201,34,121,114,36,211,132,233,127,160,98,67,151,216,30,183,81,32,169,185,232,39,133,207,131,53,63,118,112,92,189,218,169,128,124,73,143,60,80,96,76,44,123,114,132,169,65,83,49,126,54,23,68,8,86,199,53,26,25,7,105,244,144,2,73,62,247,204,81,220,142,250,93,81,217,116,66,29,203,87,28,89,158,50,178,98,238,128,33,20,87,147,127,107,85,94,36,156,78,206,247,204,66,103,241,178,132,100,41,231,84,104,130,9,2,114,222,198,91,83,128,141,12,103,166,110,211,69,179,149,33,72,66,52,92,248,177,3,242,111,203,58,48,201,93,186,253,71,22,191,74,241,86,25,132,196,66,33,181,237,194,104,233,47,119,164,206,212,173,92,193,55,121,21,237,192,47,77,189,81,211,16,184,0,36,195,174,118,151,31,50,50,112,15,120,18,215,179,143,16,60,1,245,27,13,22,69,249,76,119,219,89,34,197,88,22,101,61,141,250,8,220,106,15,35,65,167,52,253,8,105,207,129,66,178,34,134,16,93,198,204,201,184,23,151,46,159,225,210,212,246,123,3,242,253,199,39,243,116,42,250,206,227,236,122,44,184,100,43,32,234,31,90,219,142,20,231,143,43,228,80,67,229,120,8,172,114,159,11,213,235,147,32,154,78,112,19,205,59,130,193,94,185,214,58,223,14,142,202,16,34,143,222,2,42,153,190,199,237,223,158,0,105,196,64,245,186,195,150,8,99,19,130,190,210,143,112,58,148,122,244,241,111,57,170,73,128,3,251,89,71,51,3,169,150,27,249,121,205,10,48,222,223,148,254,79,234,24,255,0,132,203,131,245,218,152,175,183,105,248,176,94,9,109,111,238,187,198,164,16,195,57,158,237,182,86,176,213,199,250,68,211,167,135,54,216,44,186,19,74,101,152,198,111,96,180,215,201,80,192,53,69,236,192,8,185,89,42,139,197,218,138,35,176,165,180,172,189,86,246,172,165,126,78,20,54,100,253,39,87,208,36,28,88,93,115,99,247,132,33,52,255,188,210,48,120,27,249,209,119,215,129,76,202,231,128,236,92,1,201,169,95,191,58,253,150,39,54,221,96,130,204,169,0,53,220,240,216,6,248,188,53,0,169,124,148,178,93,1,133,33,170,110,51,188,168,113,77,14,89,23,200,44,97,251,201,253,205,52,246,89,190,196,72,26,13,238,140,87,100,133,94,219,62,238,40,218,163,61,237,116,46,245,205,231,172,227,210,74,16,54,128,213,186,84,22,96,189,59,227,43,44,209,76,10,186,117,233,27,112,75,202,104,159,243,174,237,183,239,42,157,255,65,246,214,116,25,31,209,180,207,217,68,243,70,84,167,68,75,175,166,16,195,61,171,189,220,8,25,37,181,58,140,176,100,41,23,163,242,161,224,114,179,62,66,97,1,50,254,88,143,145,7,96,126,201,121,110,155,157,31,95,233,185,152,29,154,109,208,27,29,182,143,181,194,141,35,234,223,21,117,197,242,26,148,242,37,141,0,178,49,100,125,183,129,141,171,130,183,192,82,167,122,141,77,146,1,26,233,72,136,12,249,185,138,34,30,23,148,61,180,204,151,59,24,12,168,21,229,177,161,186,35,205,103,35,238,205,161,92,130,104,76,13,25,96,222,32,101,21,77,68,162,75,190,152,122,42,118,45,70,211,241,120,117,195,52,63,188,188,12,245,5,94,203,230,46,135,71,22,131,69,242,11,52,87,22,29,151,44,194,150,107,92,4,6,121,31,129,141,158,38,179,93,76,158,208,77,234,23,232,213,155,97,130,253,183,32,34,161,147,92,227,12,179,73,173,78,102,11,125,191,174,126,66,92,66,15,237,191,38,183,196,107,222,239,189,206,65,249,93,179,178,227,232,220,142,145,107,7,97,152,83,88,172,138,38,214,126,139,159,63,74,239,147,81,169,73,61,177,212,142,64,83,92,244,55,248,248,103,221,31,1,97,189,143,106,111,52,88,209,97,224,198,206,113,74,8,52,26,222,144,202,207,63,206,173,118,172,133,220,126,126,112,59,102,91,23,48,212,106,153,232,243,235,150,204,177,168,50,23,13,160,144,193,186,133,41,64,192,14,154,103,193,213,211,147,231,63,183,50,57,2,56,111,19,185,1,40,215,171,56,117,210,65,33,137,116,198,55,36,190,150,4,180,225,205,115,138,83,122,223,118,174,73,230,42,97,149,131,240,176,64,254,141,211,187,114,104,57,120,177,133,44,127,214,36,96,245,143,227,44,173,150,49,5,2,50,230,137,125,173,62,63,159,51,180,22,209,146,132,29,94,66,180,150,139,211,113,157,18,238,44,54,215,213,187,82,132,66,98,123,230,176,79,80,127,138,24,240,197,58,216,88,228,217,113,193,87,199,3,5,226,183,214,252,163,255,69,28,192,184,67,115,8,18,170,99,36,184,244,25,92,169,149,197,68,133,55,54,34,49,158,120,143,103,149,213,60,0,175,119,129,2,141,90,243,123,41,127,164,192,146,104,57,244,44,14,183,6,182,106,86,172,217,109,248,5,164,13,193,109,219,8,187,8,16,92,70,96,47,132,23,167,28,66,64,82,233,90,173,224,114,199,54,152,175,130,88,47,232,57,119,136,22,168,72,217,213,49,225,254,77,219,78,178,228,223,176,47,102,129,144,192,127,48,215,70,68,194,201,121,205,222,83,41,185,45,221,104,13,215,128,41,204,73,110,7,150,21,50,58,45,84,99,28,191,16,50,74,191,157,67,7,177,239,169,18,65,69,38,58,85,92,228,28,249,69,89,124,132,47,155,4,131,28,139,3,177,162,204,155,104,134,22,41,185,0,178,60,129,134,17,109,124,107,162,11,249,210,110,38,183,137,94,65,85,175,172,230,164,131,227,20,90,63,72,54,140,135,248,3,174,221,201,181,143,50,252,150,104,110,185,127,123,140,226,77,183,171,179,206,111,170,29,113,32,216,193,235,106,250,121,80,12,49,39,61,118,213,48,89,111,79,184,233,106,238,203,122,77,69,185,223,222,195,149,140,111,252,161,62,147,153,55,12,183,200,225,140,129,197,133,254,148,204,212,74,135,32,245,251,45,226,176,15,184,194,34,139,244,101,156,62,7,164,246,234,65,42,21,15,158,186,166,137,153,215,164,155,169,182,32,228,145,244,91,238,240,64,144,61,143,5,66,254,31,228,11,66,89,172,221,67,175,174,149,143,34,155,70,174,166,113,41,81,70,204,90,80,129,109,9,106,29,68,95,252,104,58,28,184,113,20,41,206,142,197,163,54,107,237,38,225,114,103,196,193,99,22,201,207,209,244,218,57,214,216,128,197,166,239,92,73,47,117,38,244,217,102,40,202,48,177,208,254,177,194,205,227,186,132,216,167,130,37,214,4,207,176,137,170,45,26,184,252,236,5,119,228,6,21,15,37,129,63,168,75,28,12,199,161,126,246,3,4,158,67,35,67,52,144,21,235,59,86,27,205,158,98,16,122,104,115,0,248,25,24,112,157,59,189,216,205,218,92,197,220,65,76,189,192,201,83,49,103,73,113,11,212,163,125,63,41,85,90,193,101,82,86,215,11,44,126,41,7,5,137,123,131,208,171,47,35,43,4,216,192,236,227,131,45,236,191,168,49,212,238,5,231,33,231,143,37,85,197,42,56,255,73,114,2,220,34,252,177,175,94,112,35,79,244,154,184,96,5,112,205,122,254,99,214,20,174,143,4,255,208,177,250,35,25,88,2,236,238,28,53,53,41,219,46,80,15,149,203,90,86,88,104,16,127,221,99,80,112,179,18,35,96,249,118,46,167,53,212,226,154,125,195,58,76,211,235,206,62,17,55,4,193,10,120,19,53,45,31,145,212,243,72,21,206,198,29,146,138,78,35,6,37,212,38,10,206,68,91,217,246,239,81,10,108,34,19,193,152,86,160,234,16,94,125,239,249,107,227,194,212,117,211,15,100,161,208,138,190,249,251,125,105,212,76,52,141,71,177,219,27,8,101,233,203,133,199,55,49,221,221,247,106,200,113,18,203,146,24,40,49,193,2,142,26,104,81,59,130,235,245,203,201,33,236,234,50,59,62,22,131,238,114,113,107,141,189,50,246,54,32,216,68,194,116,187,65,133,157,55,34,209,127,197,235,86,161,235,237,105,221,15,80,55,119,106,231,204,22,95,149,205,78,188,50,142,238,221,75,209,90,95,81,78,79,171,127,111,120,168,233,9,197,174,154,231,156,213,244,128,73,124,224,131,232,154,242,29,104,35,5,189,205,79,96,165,124,202,93,169,215,236,207,187,108,96,233,179,157,120,157,186,37,4,106,6,81,207,227,33,147,239,7,242,111,203,82,59,102,93,107,91,126,211,58,244,242,202,243,9,207,184,149,229,223,150,192,150,61,77,105,138,184,209,205,155,28,178,26,201,7,106,221,131,211,94,201,202,56,114,6,51,220,112,214,132,61,169,224,35,120,102,22,186,94,191,223,103,206,128,98,82,219,206,169,1,209,120,129,153,202,194,159,9,199,90,61,250,235,206,32,0,154,43,73,1,216,166,47,77,157,109,24,82,63,0,243,65,51,131,93,167,78,236,104,45,174,186,155,104,68,145,143,220,165,144,49,197,82,208,252,88,180,4,79,44,159,214,42,220,25,2,210,29,129,91,197,146,197,68,118,63,150,51,62,123,61,131,156,225,125,39,10,68,180,61,27,218,113,69,198,174,153,182,160,49,184,50,237,240,252,84,80,235,164,78,81,120,247,50,33,202,231,147,21,38,28,20,225,213,62,151,253,28,168,76,189,60,29,65,148,9,184,13,210,87,4,110,159,243,91,192,130,148,6,50,16,253,4,2,63,195,95,241,242,223,176,55,228,63,80,249,102,89,181,240,207,173,109,177,89,51,255,199,69,73,92,22,185,89,245,42,179,186,31,83,222,48,102,172,217,7,198,190,249,134,15,124,1,10,232,180,210,245,152,108,167,134,219,231,27,229,52,141,120,142,120,251,46,229,96,161,114,141,43,160,76,91,218,93,41,5,233,9,255,191,74,16,95,159,52,34,170,77,16,94,117,145,96,200,240,254,226,140,150,142,177,231,254,121,67,14,170,223,27,191,56,202,29,76,66,91,246,31,206,165,31,104,89,133,195,245,135,169,158,238,82,255,226,129,148,13,132,0,207,102,137,73,235,155,137,142,121,64,147,212,139,9,54,253,169,221,123,168,119,236,54,22,53,124,47,164,147,170,32,169,79,174,57,224,180,186,254,218,96,242,57,25,247,58,72,120,243,166,208,33,69,253,59,166,164,228,52,33,224,234,15,94,251,219,173,6,238,202,56,70,90,120,92,30,149,132,171,223,162,164,31,122,73,42,114,7,245,159,160,197,194,35,203,87,58,197,90,200,244,48,66,64,7,161,44,203,31,87,153,75,158,202,0,212,63,78,140,190,34,5,149,132,213,125,178,78,94,170,140,218,177,85,80,240,137,188,104,248,185,224,34,225,96,201,68,233,80,212,121,184,122,14,86,146,15,147,211,125,34,19,162,45,21,28,79,65,225,207,6,111,106,224,215,118,51,202,148,42,251,244,240,104,61,193,166,123,135,111,238,186,250,65,236,1,190,36,225,21,117,53,198,15,152,3,159,101,107,113,225,27,223,43,95,59,121,226,242,37,210,223,21,111,91,98,207,132,149,4,60,198,29,10,228,65,254,204,108,208,235,8,65,171,54,113,106,191,197,97,222,87,74,61,119,119,221,136,33,99,167,8,229,255,199,1,77,53,143,55,129,159,183,190,142,48,107,39,18,27,197,114,216,192,143,211,139,107,127,3,29,184,249,109,151,52,62,221,25,219,159,75,101,233,29,227,223,107,123,84,112,91,0,8,210,91,117,0,16,128,252,205,216,58,86,195,42,99,23,66,28,243,202,134,143,254,2,130,74,245,226,192,213,27,62,237,201,39,194,76,175,61,199,243,24,70,232,99,102,192,240,178,89,94,204,14,121,208,54,70,106,125,100,244,220,24,107,97,52,250,136,42,4,205,225,82,71,225,207,51,158,27,189,240,163,168,148,223,219,111,162,23,233,158,58,90,98,11,23,183,94,194,177,47,42,254,105,128,195,181,103,58,205,94,228,200,192,161,75,50,153,47,199,186,237,67,194,23,83,169,62,100,86,112,60,13,169,88,210,34,90,77,41,16,97,25,193,75,119,24,80,52,27,192,132,41,118,188,202,215,175,218,95,25,101,151,189,192,98,123,192,121,139,134,211,27,102,212,231,156,81,143,233,65,245,37,184,184,148,146,162,55,46,1,3,107,101,57,204,5,1,252,113,136,101,11,166,185,3,16,233,64,33,26,139,59,131,28,111,10,39,166,109,55,200,167,247,23,55,1,168,57,72,66,147,28,47,55,109,95,253,46,155,4,234,138,232,216,120,36,10,77,15,105,158,183,175,2,41,203,79,51,46,132,24,172,10,206,113,14,150,36,31,176,41,3,116,89,116,25,98,139,228,150,89,135,75,224,45,81,112,13,138,88,144,109,60,169,147,4,160,167,82,242,106,33,148,69,72,79,38,135,180,70,243,42,219,118,204,54,198,146,255,168,255,225,58,165,89,231,228,107,113,43,48,43,79,213,175,183,124,124,59,207,141,201,6,180,93,240,37,3,238,242,232,140,217,197,194,54,104,204,132,67,165,197,103,127,175,28,50,190,63,187,9,134,47,104,211,145,95,78,205,168,117,136,22,195,83,73,24,46,30,52,39,197,110,175,82,163,250,76,203,18,89,112,217,14,84,159,78,178,214,10,194,60,65,146,236,4,155,23,144,7,107,51,105,63,137,164,7,229,239,251,230,10,128,36,62,191,161,23,118,79,218,148,96,134,152,157,117,87,41,33,137,109,212,132,139,225,82,248,60,39,201,79,38,4,211,150,210,36,19,154,233,72,77,193,101,157,13,12,254,149,65,58,28,135,225,155,200,236,58,221,12,133,206,140,231,149,232,20,241,93,154,185,21,126,219,146,203,216,58,72,120,241,97,168,4,103,33,98,167,103,253,255,32,85,227,2,57,95,96,127,198,193,57,176,214,4,137,166,152,56,142,60,153,138,11,230,199,147,116,187,223,110,130,6,109,172,162,147,212,78,235,59,253,64,85,199,56,204,117,46,169,242,152,142,9,206,223,40,203,240,187,103,114,45,125,30,126,120,235,13,88,106,172,15,94,232,90,100,37,71,43,174,176,43,125,127,115,29,208,176,108,170,196,121,32,166,204,222,212,194,182,250,47,25,17,172,236,29,74,229,3,127,149,142,36,72,50,172,186,146,115,135,16,106,30,247,167,147,186,230,24,182,55,219,12,17,21,57,244,182,82,135,60,254,152,31,110,170,154,244,209,216,160,130,246,151,121,25,39,61,212,67,137,111,169,251,87,103,189,140,211,205,211,114,229,235,145,95,236,124,209,7,183,152,2,132,119,135,82,233,112,23,44,170,125,141,100,230,90,17,25,180,61,128,95,10,30,145,116,22,112,244,31,68,49,153,245,87,176,251,63,9,192,177,35,242,156,107,155,7,207,224,252,103,37,238,248,97,56,155,207,6,41,59,195,65,86,154,182,9,220,210,16,87,97,134,98,212,32,225,158,197,41,116,45,198,31,167,143,217,96,149,1,223,108,102,106,217,72,203,171,65,232,121,133,90,135,109,93,204,35,58,119,154,221,47,62,181,233,5,7,211,101,0,43,176,214,41,147,3,207,230,28,172,206,192,222,8,14,26,236,129,181,194,83,221,141,23,152,195,175,124,116,251,51,149,181,125,129,235,98,38,49,132,137,103,188,236,200,14,33,54,116,44,33,78,99,80,57,136,157,121,40,179,74,176,192,63,37,130,17,163,191,118,88,110,230,127,75,60,26,237,10,60,238,69,3,167,117,203,136,122,164,86,34,143,208,208,185,254,199,213,236,179,152,42,81,149,197,127,5,22,40,135,7,4,248,49,138,142,41,139,45,112,43,179,1,184,186,2,0,186,83,95,192,219,167,160,52,30,90,92,230,238,136,4,208,127,224,23,153,62,217,8,1,107,11,210,155,243,124,74,19,62,154,82,226,8,200,113,161,120,234,210,181,90,138,229,177,182,20,150,232,54,121,75,109,22,17,81,154,97,205,210,165,150,97,86,185,218,127,238,84,225,29,172,79,127,115,54,153,68,113,162,168,4,131,165,253,103,111,93,215,115,205,240,216,106,34,49,224,101,131,195,8,1,104,236,151,4,25,59,150,168,87,100,249,120,181,57,34,104,10,74,22,0,235,127,7,67,200,48,96,127,198,26,32,166,252,219,209,227,187,131,148,244,95,106,201,28,141,50,186,232,157,32,157,34,122,247,185,78,226,85,106,133,158,53,250,203,38,243,175,61,255,81,212,58,116,94,72,39,9,52,149,194,91,93,136,199,6,194,248,224,69,206,166,61,244,91,146,133,111,231,221,167,17,151,202,85,55,85,106,54,181,215,142,240,221,108,99,5,157,4,91,197,138,161,231,58,83,45,69,169,60,36,148,17,78,88,99,32,73,159,128,103,161,111,201,15,202,234,222,38,51,38,232,28,250,167,14,37,236,226,233,168,135,200,120,29,20,105,198,170,4,219,57,187,137,249,221,251,252,166,140,123,115,147,146,153,73,195,119,49,8,13,217,87,52,156,134,253,172,49,190,95,60,19,240,181,211,191,46,70,40,46,77,54,89,232,75,184,147,113,186,74,54,158,64,216,81,191,185,40,77,195,103,79,32,144,142,65,128,173,154,44,165,128,216,6,148,83,95,97,192,140,96,26,164,143,151,176,48,144,61,229,57,126,22,12,34,213,49,189,126,169,230,244,30,33,230,121,58,254,194,69,240,170,95,1,167,232,77,11,66,52,60,89,216,10,245,78,222,212,59,221,32,72,137,187,64,197,117,124,93,199,16,169,97,197,87,224,66,27,250,179,31,197,225,182,140,22,21,226,238,194,211,53,58,24,128,84,136,149,21,41,201,163,207,205,67,19,166,176,99,37,217,148,54,26,42,52,102,165,16,0,206,230,166,200,37,119,52,144,222,0,4,20,121,95,232,187,123,118,155,77,221,211,241,57,15,95,158,139,232,139,126,97,98,26,47,49,234,27,134,31,77,32,235,52,219,3,79,29,41,249,83,219,212,84,4,140,203,209,95,226,157,57,68,105,225,10,145,159,182,106,47,121,69,67,36,229,36,170,48,91,90,98,37,197,18,148,208,137,76,248,229,130,100,116,107,159,96,140,105,140,95,179,44,144,12,83,152,62,212,92,214,99,197,153,20,96,222,134,214,112,10,202,210,126,204,56,202,180,102,91,194,71,48,219,188,235,45,251,151,147,135,122,142,41,146,145,57,105,203,67,4,56,142,131,131,63,222,153,78,240,82,53,200,76,122,77,11,2,227,16,99,90,165,132,40,53,147,25,177,224,169,17,8,229,44,227,161,149,233,205,34,104,15,34,43,30,226,240,54,3,135,129,209,40,105,137,25,45,2,50,172,63,165,222,96,47,155,206,173,154,167,255,108,11,251,13,93,153,232,91,74,199,26,118,148,111,87,136,0,243,130,188,219,78,111,22,124,129,68,129,197,56,214,109,160,142,94,36,235,127,200,178,74,10,197,235,238,252,73,181,135,228,133,155,200,83,10,176,220,200,136,130,179,220,5,102,159,223,230,212,99,111,236,38,151,98,89,106,240,39,254,213,248,25,37,226,241,219,17,95,242,88,144,103,237,153,75,199,66,29,152,182,103,221,89,202,139,114,91,164,76,38,132,197,16,169,182,39,37,167,145,230,27,154,102,151,116,252,153,192,7,236,195,146,69,187,97,238,160,74,115,5,172,239,118,191,198,233,114,24,1,120,49,242,63,0,34,192,90,41,50,34,109,130,145,62,209,28,46,193,245,124,185,50,11,213,255,122,116,127,7,197,93,198,134,172,48,177,228,65,122,221,117,236,194,1,160,162,210,199,144,54,129,180,14,111,130,76,27,207,241,245,236,138,193,104,230,108,56,45,106,232,43,60,163,25,53,246,6,244,196,249,121,4,87,183,17,255,23,118,40,182,114,191,168,100,148,20,80,148,114,207,42,118,161,149,68,103,28,78,1,63,100,153,102,233,34,68,43,97,127,66,75,184,226,236,175,114,68,166,203,159,41,6,81,237,194,34,46,33,43,164,76,250,236,141,152,172,59,59,175,228,152,83,191,75,140,230,250,186,100,110,154,37,70,60,190,117,39,85,217,203,35,158,248,226,129,189,238,147,140,188,224,103,59,232,82,111,66,40,249,52,51,94,74,34,28,68,144,123,252,14,90,177,4,132,131,133,113,29,173,25,238,79,18,54,157,146,221,78,176,136,149,112,81,236,153,167,105,30,123,115,254,117,153,136,176,25,237,9,118,201,156,132,159,102,24,100,215,214,89,75,69,200,24,68,218,81,239,99,225,9,245,113,83,92,68,80,26,103,157,53,158,145,130,125,221,216,56,110,113,131,186,109,184,76,86,81,100,153,160,4,176,28,92,91,228,125,81,186,179,248,91,34,156,82,251,7,57,159,95,85,100,255,164,186,31,254,33,45,67,113,229,174,34,201,67,167,118,155,26,39,94,246,128,68,9,242,162,80,176,239,181,176,86,171,197,252,116,65,165,113,109,66,58,179,8,252,187,111,66,141,19,209,187,167,91,175,64,9,213,196,61,129,63,114,76,44,53,75,85,140,124,103,104,187,251,10,231,239,233,214,133,231,0,31,220,149,113,193,222,67,196,87,155,204,8,172,23,8,206,17,201,255,247,110,230,0,106,105,123,146,19,220,154,27,238,8,189,104,73,24,93,6,163,124,244,154,59,232,58,205,16,62,38,109,0,180,103,36,171,88,202,122,144,166,36,124,242,240,194,20,195,135,49,45,137,249,255,185,214,53,110,140,213,103,237,185,69,36,50,180,175,56,199,198,142,236,148,38,110,41,127,178,29,132,109,233,101,51,76,68,80,188,110,255,188,162,26,191,15,178,136,250,216,82,229,212,107,243,215,139,79,114,41,221,192,88,191,205,66,216,64,31,63,65,182,206,252,29,231,148,189,183,135,25,29,225,88,164,197,162,197,124,229,189,65,197,206,169,243,242,54,179,159,255,69,142,68,243,246,191,23,190,64,11,243,71,233,61,234,206,180,212,81,7,240,185,225,75,133,221,142,189,229,32,122,41,97,206,222,39,21,93,22,84,252,91,64,212,88,104,166,6,3,190,127,157,64,98,15,234,180,164,25,244,232,245,254,137,81,137,220,194,194,55,119,38,69,93,41,109,222,140,207,52,192,117,38,76,215,98,160,183,58,174,157,25,200,145,65,6,124,160,191,159,222,139,188,157,103,90,180,90,124,25,173,115,12,90,99,90,27,197,2,118,68,128,106,47,7,99,5,159,62,225,64,11,36,37,64,41,62,170,171,60,252,69,63,81,136,186,238,56,70,214,33,58,85,12,5,77,159,241,94,27,90,43,26,169,159,202,78,128,114,26,212,154,164,12,60,204,208,220,236,194,122,209,124,3,87,147,95,125,119,173,65,243,217,38,246,113,16,172,4,111,234,102,205,28,199,126,68,113,223,211,255,65,167,61,75,138,234,198,85,186,21,96,137,220,144,141,4,88,88,11,239,168,186,185,71,130,104,20,140,11,163,223,97,169,89,80,149,187,85,182,147,52,168,101,140,166,95,233,111,3,48,216,133,86,168,151,174,12,106,237,119,181,73,18,54,27,78,101,13,76,230,242,215,31,117,236,180,248,64,44,233,222,68,44,243,32,38,7,224,78,127,47,99,253,152,222,147,242,119,139,84,71,155,112,9,253,7,232,83,8,10,153,184,191,22,215,242,71,225,65,123,31,243,93,168,138,224,1,13,212,255,28,162,123,112,28,234,102,74,79,99,42,139,250,195,50,99,182,102,33,197,47,207,51,220,83,103,228,196,8,211,250,52,154,51,240,107,240,133,200,251,89,4,194,35,138,138,107,23,125,243,105,248,159,151,179,237,60,155,58,231,222,242,236,64,219,228,183,161,249,243,187,69,220,176,26,181,32,6,226,53,250,129,139,182,158,80,35,16,196,159,15,49,137,110,130,202,229,102,80,133,8,46,189,75,190,179,49,186,0,19,244,93,81,48,234,86,20,57,137,24,206,34,188,63,72,191,105,63,214,222,13,70,68,103,78,71,251,215,30,93,64,131,207,219,63,72,44,80,219,126,187,99,149,128,103,41,89,56,54,164,248,75,78,44,129,167,169,108,161,4,83,55,178,62,193,251,123,171,252,131,231,243,183,127,83,45,83,86,80,144,30,137,101,198,215,246,2,17,73,51,247,232,180,135,62,105,197,35,247,25,9,195,208,6,10,156,236,51,77,151,4,138,134,142,227,22,63,15,27,207,19,10,61,148,34,234,58,193,125,197,21,128,59,171,220,201,148,227,11,20,13,102,87,43,142,49,202,64,174,80,202,231,122,226,79,67,214,119,244,216,126,144,60,162,6,38,246,8,15,133,113,97,239,169,225,56,106,225,106,239,4,67,246,185,173,213,145,46,227,2,6,102,243,122,107,1,96,255,99,178,134,207,16,13,26,113,38,119,192,109,12,195,99,184,252,141,34,34,30,105,93,0,58,88,37,145,50,11,156,3,248,46,225,164,151,135,202,125,80,49,62,154,25,174,201,239,128,50,163,75,53,75,204,14,137,218,250,244,174,48,252,5,102,115,255,100,144,151,30,37,166,114,26,89,186,100,206,171,40,174,185,157,161,111,192,240,226,255,42,161,72,7,31,163,100,234,146,199,188,144,114,241,250,170,73,112,3,127,186,25,59,171,88,127,102,93,128,104,13,173,32,129,190,233,240,51,21,239,13,244,250,14,95,51,46,7,109,33,251,163,124,44,10,9,1,147,45,113,181,192,69,174,68,30,151,29,117,169,166,106,43,204,20,19,51,30,179,189,141,78,52,192,185,188,99,146,47,21,248,88,136,30,200,119,164,109,252,36,183,102,174,163,160,3,120,130,82,101,147,175,41,3,68,156,229,198,144,79,129,21,142,207,85,175,2,170,108,31,205,135,25,240,97,58,116,211,150,188,70,252,76,63,130,228,205,93,159,130,163,51,8,233,193,185,172,146,121,91,210,210,6,155,70,192,3,22,119,182,184,139,27,84,0,139,27,143,99,214,13,214,230,248,56,188,26,204,178,122,243,202,53,164,251,87,122,14,6,77,230,85,247,237,71,235,40,17,229,49,2,50,51,13,4,1,239,76,19,13,87,198,32,226,225,240,116,68,234,28,171,228,24,253,177,138,214,238,179,155,116,73,126,195,207,253,188,66,115,31,133,94,140,149,186,119,1,216,234,152,0,8,153,225,216,231,42,25,40,255,242,50,6,19,242,147,206,132,204,42,110,250,140,232,232,120,189,229,8,98,161,35,193,7,28,220,172,49,3,124,102,15,96,72,118,15,164,59,114,52,114,57,1,110,118,22,41,214,233,159,103,19,33,14,254,122,92,161,187,207,131,20,122,179,111,165,223,223,109,128,11,155,166,173,134,94,5,110,128,48,153,169,222,9,166,86,232,211,226,90,138,14,191,102,94,15,104,125,3,198,142,125,24,19,161,121,194,25,157,178,26,82,81,139,243,205,148,136,243,36,84,83,63,120,202,14,156,253,241,13,237,125,222,51,131,122,249,39,141,174,189,175,146,169,19,246,3,177,63,107,220,172,165,142,180,230,173,41,233,198,234,127,233,117,0,38,112,88,97,44,61,2,121,104,37,187,157,227,56,243,28,174,63,172,179,7,242,183,95,104,75,156,15,15,186,6,249,32,67,188,50,229,67,63,8,156,229,54,48,199,40,132,26,80,196,205,64,194,51,182,165,213,97,19,215,100,106,65,94,91,60,151,188,97,28,84,171,41,176,76,157,47,253,83,53,56,192,182,157,90,249,116,13,207,216,165,127,252,24,235,96,240,45,139,99,131,33,113,123,217,197,96,161,237,52,91,174,68,64,8,96,24,62,23,159,243,194,197,186,222,241,65,245,232,170,154,53,1,51,150,79,229,8,230,187,93,118,72,119,255,247,35,249,94,106,169,100,47,130,182,108,50,172,133,208,113,13,93,154,111,171,33,148,104,165,163,123,183,116,75,127,168,33,22,143,68,27,70,226,175,175,232,235,74,25,219,173,172,22,63,17,32,67,145,41,49,211,185,58,176,214,93,107,135,55,54,231,252,161,219,222,29,67,15,189,95,20,8,234,19,88,197,3,11,152,94,213,8,89,93,147,189,4,5,217,113,241,95,36,0,213,47,219,246,122,135,1,4,122,71,206,84,126,30,50,52,214,81,20,19,117,191,24,138,215,28,199,83,15,124,147,129,51,58,5,180,230,66,81,125,210,207,192,105,60,173,79,88,15,199,129,187,177,178,35,46,103,200,90,15,246,75,250,27,75,249,79,77,239,99,98,218,6,243,33,44,149,51,107,122,49,94,133,83,131,249,120,64,161,78,90,208,92,166,129,142,99,67,234,228,100,255,131,54,21,185,106,92,14,32,140,29,106,237,122,235,21,243,162,7,240,108,11,61,125,35,254,28,18,39,136,199,183,105,130,7,136,209,178,18,202,60,83,198,72,147,121,72,37,4,114,202,190,232,211,21,136,234,238,173,138,150,167,199,43,37,155,245,123,53,192,247,57,221,255,205,102,20,160,95,247,179,227,242,45,95,74,150,255,237,83,240,24,106,132,122,32,121,181,68,155,71,127,75,60,10,144,81,153,102,235,48,222,58,140,176,132,189,226,24,78,47,219,54,109,72,153,9,50,167,25,135,80,96,142,4,22,163,85,32,161,233,176,178,219,111,89,171,169,98,71,14,81,164,146,5,77,125,132,184,105,226,100,86,87,103,16,69,228,175,230,198,3,97,141,10,170,117,255,175,169,86,4,5,153,157,167,169,200,67,178,74,4,174,175,68,8,161,204,232,4,11,137,10,21,63,2,61,113,141,224,70,45,162,10,69,55,134,239,214,87,53,50,206,22,3,247,229,97,190,119,255,96,182,102,175,5,126,138,210,82,13,164,254,11,66,0,75,25,205,34,233,187,34,70,9,207,75,176,52,106,26,93,61,6,146,230,147,41,216,140,245,129,185,33,176,232,104,245,161,128,248,25,24,101,53,235,153,181,118,51,13,37,52,253,146,2,133,118,182,86,244,33,50,110,175,16,50,9,233,237,163,10,172,77,57,142,211,4,26,144,131,184,100,186,112,1,45,45,61,237,102,207,110,45,255,227,54,168,104,83,103,160,63,99,216,91,152,152,68,40,130,231,183,150,218,146,45,29,249,129,116,166,52,103,124,141,132,146,231,180,66,134,86,75,23,228,127,140,74,1,10,68,52,110,197,71,148,29,26,38,32,147,40,239,133,39,79,201,140,74,90,226,70,96,81,198,168,20,44,73,248,17,252,192,203,247,188,55,236,101,27,255,190,188,86,53,183,18,109,10,56,1,193,193,186,74,182,123,95,89,17,227,179,176,66,20,60,217,71,51,65,148,57,189,24,61,119,86,211,38,68,126,67,13,19,198,198,24,213,104,117,80,184,112,82,102,105,99,75,77,131,61,10,3,243,249,227,185,218,180,220,41,218,220,120,120,6,3,5,251,243,115,124,241,117,138,193,115,255,236,27,50,9,213,6,3,93,37,246,55,164,249,233,108,223,28,238,36,125,74,174,41,125,203,123,6,12,75,78,76,115,205,50,129,210,120,161,143,33,92,135,183,40,254,209,94,11,165,31,203,223,219,245,191,60,103,158,158,200,235,51,156,43,175,23,19,128,99,0,145,30,215,72,246,162,182,207,7,12,152,39,237,77,112,55,180,97,30,77,160,57,244,100,176,31,81,154,10,84,150,111,197,141,9,136,18,126,76,35,238,32,51,222,120,175,172,224,7,30,209,181,237,57,83,22,122,99,168,15,85,35,20,106,179,23,159,31,214,53,69,75,110,122,94,85,112,63,14,72,214,243,140,21,246,231,108,91,119,169,75,68,92,194,187,163,162,26,167,55,30,160,34,241,137,135,54,94,141,113,173,123,70,169,217,110,77,42,186,232,248,252,252,212,37,150,54,177,179,160,223,68,87,73,151,227,61,125,180,46,231,71,176,224,171,113,198,63,23,18,52,145,211,9,138,33,191,3,233,209,216,190,45,75,37,176,217,222,190,174,250,7,53,37,137,98,95,141,122,201,55,154,173,43,231,145,102,163,125,160,184,15,62,78,35,203,249,15,59,128,53,4,69,59,35,203,38,179,147,238,157,165,125,105,246,73,159,92,232,200,50,102,34,36,90,111,22,79,167,33,49,56,188,255,76,164,242,115,252,116,115,136,208,141,255,47,205,183,136,24,216,168,16,150,2,176,136,168,16,246,119,110,223,68,167,0,220,79,165,247,62,64,209,86,138,195,119,240,176,181,164,64,7,187,172,132,156,3,164,244,176,145,80,34,3,84,53,250,222,91,223,196,8,118,13,55,173,28,27,202,155,83,133,51,163,43,24,80,110,216,211,43,33,229,251,21,49,8,0,36,0,237,180,5,15,233,171,39,232,31,94,204,140,233,245,84,202,222,39,252,24,10,198,13,174,94,225,33,187,147,196,44,201,123,175,175,89,197,108,95,233,162,229,245,218,87,177,51,92,140,98,8,224,89,204,99,63,175,20,176,170,254,204,232,239,247,49,249,153,60,114,228,56,247,82,215,87,49,191,192,186,139,37,80,198,231,183,88,22,62,44,43,116,156,13,67,141,101,245,180,224,80,45,95,76,217,224,193,91,68,213,92,7,144,78,122,193,81,96,165,182,163,37,159,103,197,214,233,41,241,49,77,78,105,117,243,251,163,109,214,251,250,51,14,252,58,237,172,76,242,112,236,5,71,226,250,177,255,241,238,35,90,118,149,89,214,17,235,150,60,178,245,92,77,181,161,246,170,145,35,75,228,71,223,198,165,60,182,77,40,50,192,17,23,144,164,225,217,55,128,47,198,56,122,15,254,9,68,176,252,201,116,59,31,237,32,124,109,227,123,248,98,152,216,165,220,66,105,0,230,80,131,170,245,35,1,245,37,157,207,122,116,241,212,9,201,247,21,22,27,241,126,173,71,3,199,60,21,169,237,132,38,172,72,61,143,68,183,126,47,140,91,10,124,1,221,164,96,12,29,44,194,16,228,102,251,166,25,250,137,147,11,180,0,107,143,195,155,112,32,170,115,37,137,202,39,19,178,44,68,155,51,32,148,225,59,185,113,197,11,24,122,97,154,213,138,16,249,28,194,25,152,31,221,52,210,189,86,53,209,203,208,79,24,145,227,69,246,10,235,45,236,61,247,248,8,74,182,144,234,76,35,45,190,136,185,39,108,169,73,152,162,88,206,117,200,160,230,130,76,151,103,1,224,47,224,205,160,58,243,250,181,78,148,152,164,149,198,176,244,13,13,106,141,154,97,143,10,12,253,157,27,153,213,207,16,199,93,12,197,54,33,56,199,39,249,63,160,50,152,16,230,11,34,211,102,146,107,196,195,69,34,94,137,77,150,143,106,221,131,16,119,236,177,165,95,34,5,87,194,249,140,99,162,194,124,7,108,76,168,195,191,248,112,109,82,49,34,160,114,124,20,131,66,116,37,192,33,6,19,121,213,84,49,3,77,57,13,5,250,251,173,241,66,56,77,23,11,206,36,247,113,242,23,188,154,219,74,41,43,187,245,228,147,107,25,90,105,190,197,225,90,98,233,118,55,209,11,156,126,53,116,224,184,105,219,245,87,9,107,83,127,241,164,136,241,208,181,27,99,34,35,19,18,25,78,26,58,39,167,114,29,236,94,142,37,68,142,139,97,86,67,24,115,130,191,6,68,11,207,125,173,123,208,59,14,47,35,212,170,65,202,122,102,17,111,226,252,147,151,251,56,240,217,120,65,83,192,11,68,4,33,201,239,132,19,135,67,255,13,224,57,242,92,146,106,84,155,78,229,51,12,31,229,217,235,113,17,45,153,150,53,73,98,133,29,43,251,169,62,176,47,131,117,83,69,222,13,193,218,182,98,168,48,115,189,239,184,188,10,220,103,214,28,76,24,237,240,132,234,76,13,229,126,95,21,130,31,199,63,108,31,152,123,247,2,170,65,38,105,14,104,136,27,130,251,195,111,215,181,103,25,189,0,135,119,224,27,46,81,127,29,170,104,219,162,24,77,130,151,192,56,114,85,106,163,86,178,241,52,182,178,24,229,149,162,36,30,198,195,130,191,255,195,111,67,240,1,82,75,29,72,116,104,234,218,192,67,81,79,14,217,20,186,226,35,111,45,59,196,105,191,5,0,113,220,45,17,61,29,7,58,56,114,49,37,208,204,36,155,64,7,56,163,1,34,32,230,184,117,132,10,10,176,215,116,252,92,58,15,206,95,154,32,215,89,174,136,116,129,23,116,65,79,28,138,34,155,188,39,170,17,248,159,155,24,86,126,183,28,9,127,125,89,127,97,108,45,122,84,184,141,19,157,67,182,75,13,159,186,86,11,120,61,203,43,79,133,93,51,86,190,136,246,181,9,136,152,166,230,139,88,74,110,74,54,15,215,133,20,188,64,174,163,244,221,170,226,193,227,162,88,125,56,22,36,143,190,183,114,105,193,198,150,10,231,50,12,252,11,234,83,77,244,248,93,245,177,60,89,110,192,247,114,236,162,50,126,183,46,160,99,186,177,45,24,77,156,60,95,44,109,70,244,248,240,119,98,224,110,132,42,210,152,251,145,126,130,155,197,78,37,126,185,113,192,192,168,156,45,235,176,225,173,223,166,26,32,8,85,216,20,18,167,32,24,242,105,233,224,139,125,208,76,247,143,175,254,214,133,179,75,213,239,99,191,202,164,189,25,138,78,48,196,3,42,217,20,62,10,71,35,187,43,74,67,0,32,245,61,233,41,233,85,100,92,139,203,176,166,255,73,125,207,233,193,186,159,24,55,126,135,249,11,99,68,16,16,142,84,21,252,87,26,20,90,206,104,240,164,255,242,8,181,71,0,179,255,131,230,112,37,249,137,146,138,149,186,131,14,81,251,140,156,103,177,118,93,150,79,253,222,74,115,115,153,129,141,238,104,124,143,169,160,105,227,118,1,123,34,23,232,109,75,20,58,79,223,81,98,246,23,20,157,113,21,114,112,219,196,195,181,79,186,113,189,170,55,213,39,217,215,242,183,232,143,137,221,204,160,119,35,181,136,63,50,230,103,137,248,20,81,150,179,70,6,41,45,233,132,219,186,208,203,41,225,35,11,207,172,232,206,212,236,77,254,222,114,24,219,232,180,186,114,118,102,71,153,46,206,44,123,239,212,28,156,200,241,72,100,66,36,47,8,182,226,2,178,29,55,111,53,3,144,120,160,85,63,235,122,215,41,79,49,76,213,240,75,49,250,157,178,45,148,189,41,116,135,213,251,219,209,78,194,188,119,226,23,210,89,157,122,5,152,99,204,212,247,64,248,169,132,8,211,27,240,130,3,109,52,4,104,92,83,158,54,145,6,190,105,94,56,62,111,174,252,71,179,236,190,241,138,178,26,22,104,9,112,228,247,36,203,14,242,28,205,196,233,134,194,36,62,119,87,55,111,89,192,55,232,155,36,96,74,143,231,28,233,180,222,43,8,97,155,94,228,126,55,52,78,168,195,72,211,195,93,148,130,133,225,214,91,172,160,114,186,59,192,34,212,218,157,125,102,148,18,33,166,244,56,183,223,143,189,138,149,158,255,158,234,81,222,148,109,238,199,217,155,197,125,196,29,224,80,196,174,13,255,55,197,156,225,150,49,158,135,13,210,62,131,159,161,104,181,3,63,128,159,157,118,127,136,207,107,140,218,254,108,193,127,131,157,40,196,177,188,207,244,118,14,58,10,87,137,32,217,120,113,95,130,142,174,196,2,216,20,102,193,69,39,207,108,127,90,189,201,245,135,163,17,166,93,60,232,5,100,215,125,55,137,98,126,234,188,229,67,230,213,167,190,217,97,100,206,109,70,25,7,102,136,99,74,112,22,34,130,118,94,0,94,35,215,3,148,1,183,245,104,98,245,157,233,203,202,186,178,198,166,130,220,64,157,168,133,100,249,155,57,222,56,86,180,221,161,32,189,228,206,192,50,72,77,44,151,187,11,15,106,125,157,193,174,48,54,52,202,53,205,245,5,1,120,204,187,2,221,41,3,47,24,246,143,108,56,73,41,23,28,194,208,206,115,242,97,105,29,238,151,209,229,200,163,125,63,65,56,42,148,178,52,65,252,93,40,112,106,191,151,38,98,87,48,160,232,134,9,165,24,63,112,242,2,241,145,60,107,74,44,44,74,78,27,133,228,42,100,122,235,61,44,228,58,126,139,118,92,191,51,6,23,138,224,153,41,58,123,243,16,95,174,33,184,189,89,111,240,120,158,9,122,183,136,151,149,213,149,179,1,223,165,102,90,171,25,162,252,101,8,215,44,191,223,106,39,133,55,229,59,88,212,127,77,151,60,124,39,118,17,89,170,201,37,253,227,237,209,195,12,25,40,55,61,255,19,123,92,201,174,247,68,139,1,29,118,46,35,42,53,197,249,223,40,85,209,249,27,215,30,167,64,107,12,57,24,3,64,71,50,97,136,25,111,60,49,5,41,168,131,24,71,151,56,24,75,71,178,155,59,93,139,17,252,186,198,11,41,52,26,246,125,207,84,246,7,210,142,12,165,222,121,31,87,246,192,202,253,54,119,219,92,164,24,93,235,217,43,6,219,138,210,114,165,5,8,255,176,52,70,174,158,109,177,174,63,213,161,144,82,57,185,67,200,35,155,252,28,116,166,82,81,228,195,153,147,41,88,140,44,5,253,151,186,160,201,181,189,79,237,91,211,177,198,231,29,198,104,198,173,201,39,221,23,236,172,212,16,214,197,18,185,163,237,16,13,129,243,159,244,201,5,203,165,78,69,217,190,187,175,187,86,159,148,149,6,102,93,199,119,50,109,144,184,56,82,94,253,166,130,180,10,121,248,227,185,160,199,66,68,126,180,12,66,57,157,207,167,198,191,99,75,236,68,210,138,68,167,183,252,95,85,28,58,98,14,45,141,142,77,204,145,165,162,41,92,28,19,100,133,131,92,16,153,63,72,145,77,126,19,217,99,154,146,60,174,140,35,74,213,42,239,228,145,204,96,159,146,135,58,111,119,139,3,229,69,152,197,75,124,43,1,187,14,226,204,67,179,160,31,99,13,68,203,114,43,135,191,179,75,83,223,101,7,73,40,96,143,196,5,145,244,104,146,124,176,74,60,75,70,44,51,229,124,243,99,12,178,119,175,113,17,144,25,96,71,22,43,195,121,214,19,164,244,84,96,79,24,150,123,184,177,71,253,163,148,154,84,31,125,205,120,189,7,37,201,54,28,175,250,4,184,100,227,252,152,169,73,182,151,85,100,122,181,102,150,151,57,67,144,96,50,184,69,71,131,147,173,88,253,160,89,83,178,115,50,195,168,97,171,43,192,202,250,217,139,214,170,66,247,102,236,238,154,106,195,214,145,143,190,226,74,213,194,221,112,134,162,112,237,32,114,162,13,28,126,253,245,203,206,139,22,37,173,47,59,101,51,201,0,157,107,167,182,101,188,143,98,251,250,244,190,184,144,199,30,47,109,37,35,63,16,157,222,20,27,69,37,21,40,101,51,1,23,22,129,41,20,6,17,59,6,130,39,131,21,66,6,90,119,255,42,79,230,217,188,65,157,64,41,137,215,43,144,175,165,105,59,60,197,130,180,144,156,189,126,231,149,230,164,146,25,128,99,59,38,202,93,172,104,233,251,190,63,141,244,43,185,243,202,130,212,26,139,125,95,237,180,151,35,33,123,208,218,242,145,205,52,29,161,215,145,109,149,213,200,91,207,193,87,216,255,17,106,248,38,158,10,61,218,208,89,12,231,39,183,217,153,248,64,241,40,68,119,24,159,108,28,219,211,47,32,149,165,34,11,97,197,178,39,69,101,99,216,251,47,109,43,19,230,178,32,190,113,254,99,184,11,128,59,157,180,249,18,155,4,86,125,216,102,111,59,223,15,55,175,163,33,239,125,98,88,7,130,218,40,230,19,179,56,227,208,142,138,46,135,134,69,223,248,26,141,42,171,26,110,187,182,3,92,54,138,188,79,139,234,139,52,52,211,225,26,123,157,118,84,227,215,155,222,58,46,60,114,254,8,118,131,112,83,43,126,96,146,92,23,120,48,160,11,197,146,220,111,95,116,64,63,181,112,28,113,222,98,222,83,32,218,236,147,222,2,138,250,84,10,175,178,156,241,163,182,184,236,197,70,165,134,150,109,178,108,114,205,89,234,90,201,101,64,111,40,170,164,74,224,248,198,199,100,180,149,234,174,186,39,47,54,123,179,209,77,113,253,241,134,200,188,82,132,209,233,91,122,96,126,30,233,202,13,156,10,7,227,44,224,196,135,227,103,125,116,117,160,208,117,192,122,184,158,77,79,77,1,173,150,189,217,31,128,74,140,236,234,185,69,35,140,104,92,96,142,199,78,171,215,224,105,66,209,187,110,10,55,45,16,191,121,190,14,182,229,180,255,253,146,159,18,191,35,95,8,102,124,151,121,159,244,169,146,211,38,54,10,77,7,60,120,131,112,99,16,187,89,67,77,225,252,23,139,160,200,187,79,241,223,22,187,134,207,207,242,85,234,81,48,41,159,70,104,89,111,118,56,6,90,55,167,158,46,69,118,20,173,174,149,107,238,66,47,157,247,65,160,86,64,14,171,188,155,171,31,77,57,52,202,126,26,6,182,209,209,83,187,73,158,176,46,238,195,19,163,4,182,17,190,250,211,232,243,87,185,78,148,14,77,230,225,137,155,62,242,236,115,237,103,169,110,24,50,236,61,208,199,4,121,12,220,6,22,124,69,31,186,197,208,107,96,149,97,34,166,150,133,182,87,73,81,238,248,180,152,62,159,202,248,6,112,206,235,62,46,51,131,23,93,193,88,232,42,157,96,228,118,221,68,72,223,133,77,211,126,43,167,181,139,213,13,7,226,215,86,40,218,62,7,183,164,235,53,172,182,215,223,217,230,226,148,136,83,71,213,3,168,133,22,86,166,107,144,216,126,212,149,107,184,111,59,3,60,102,94,25,48,84,3,67,29,151,215,140,223,37,224,221,248,195,101,20,139,252,129,220,27,241,41,131,237,205,74,235,173,109,219,130,171,183,27,236,10,218,32,221,255,247,115,147,41,243,66,180,26,93,137,160,51,14,242,214,97,202,47,173,10,116,150,221,132,198,108,119,68,49,239,166,38,6,65,2,75,210,81,54,48,185,71,131,57,233,28,244,58,80,101,0,110,52,10,158,27,203,161,48,222,109,14,158,245,38,157,226,124,1,224,159,38,67,132,45,248,203,241,158,145,251,22,237,101,13,247,231,229,0,79,235,173,39,84,13,173,115,74,33,153,47,121,0,77,132,112,22,44,40,201,125,122,163,184,189,123,74,65,42,76,17,93,97,77,227,235,86,102,246,109,40,33,246,17,79,107,236,120,74,129,93,239,113,108,90,132,86,62,19,228,151,19,215,139,114,54,13,51,172,11,170,55,113,117,21,95,101,148,18,102,53,104,74,102,187,232,146,45,118,87,31,255,189,201,141,171,179,28,9,20,162,215,43,26,33,99,188,168,6,91,206,255,248,131,254,86,240,115,76,118,36,68,83,255,34,103,243,179,235,28,22,104,164,129,237,88,25,153,87,63,65,243,46,229,233,194,146,59,91,213,173,24,21,78,36,223,99,21,84,98,137,131,126,8,236,63,28,22,165,130,109,102,195,132,7,140,226,148,150,154,251,1,172,142,204,247,248,112,107,194,79,223,50,3,77,252,19,203,202,153,252,78,241,92,241,195,75,31,63,22,50,121,38,175,145,229,249,191,111,56,255,85,163,69,145,69,203,73,37,136,26,84,103,28,197,8,186,158,251,27,31,45,103,45,73,204,231,194,202,158,81,222,216,45,217,88,27,115,33,233,204,39,174,50,13,89,130,138,86,244,146,41,234,92,195,139,43,245,32,56,59,164,209,147,165,118,80,37,214,160,152,0,79,191,116,50,36,50,80,14,186,75,215,198,123,33,235,97,236,238,75,181,193,78,213,20,207,248,250,210,22,185,209,188,163,179,144,198,24,250,246,174,231,115,192,83,107,198,225,178,254,84,2,133,54,250,94,200,51,242,86,205,56,127,192,237,44,156,119,92,95,13,8,182,63,234,2,19,115,241,75,19,32,146,55,64,196,230,149,107,28,107,233,44,87,27,75,112,127,173,36,123,26,70,149,93,227,83,134,164,228,251,121,43,202,34,202,44,132,103,245,83,147,44,220,112,135,41,134,120,111,177,233,86,30,97,219,28,97,26,240,167,93,205,168,163,154,215,148,176,53,205,246,65,30,80,93,158,19,168,3,10,15,86,63,14,214,29,31,216,194,18,136,168,162,90,37,108,118,6,186,102,249,45,200,131,116,195,25,129,107,91,77,66,170,25,106,16,112,253,211,152,174,155,145,59,117,212,126,134,86,78,95,108,143,171,126,33,249,134,83,28,50,210,220,225,191,237,71,217,146,60,12,239,100,248,195,51,148,188,120,111,167,50,174,215,242,154,72,173,4,148,14,218,93,235,29,179,13,33,153,184,20,130,158,55,212,64,253,124,248,232,80,239,223,98,182,9,11,117,108,240,237,240,41,16,254,2,236,26,80,88,89,4,218,134,130,18,139,94,45,140,188,180,250,123,213,51,160,112,136,189,116,133,186,182,63,222,229,123,232,122,177,141,236,82,216,100,151,93,205,249,53,127,205,186,14,142,212,215,56,101,250,181,183,117,19,148,200,216,0,119,180,56,227,197,133,93,132,254,181,171,26,99,100,218,170,5,90,236,207,91,50,43,93,32,81,191,4,92,45,214,48,16,84,145,37,38,10,151,186,124,19,130,32,247,252,211,201,61,27,67,129,32,193,233,38,66,174,68,223,216,150,28,206,227,24,142,105,205,175,130,222,35,197,124,35,174,195,157,134,93,78,236,141,68,0,159,236,34,62,45,99,88,141,151,230,202,94,100,193,215,84,35,114,53,120,119,221,2,31,208,16,74,84,187,88,199,151,28,205,128,125,230,217,50,51,104,209,186,51,177,219,219,112,115,57,215,209,178,232,143,65,239,27,64,200,138,204,146,73,222,89,145,96,29,91,121,167,189,42,173,201,201,121,99,212,210,30,32,222,54,79,105,106,82,200,118,97,248,180,196,128,143,168,108,252,84,78,131,108,111,228,209,131,43,94,252,159,88,5,186,177,112,38,82,204,57,3,203,27,96,231,136,20,78,108,245,128,83,162,156,76,91,64,27,103,220,80,46,59,138,53,23,218,194,86,13,165,6,44,202,237,211,67,114,80,33,49,170,36,12,55,62,43,141,21,165,50,34,167,21,87,158,0,175,115,119,44,111,251,3,45,121,195,193,134,105,189,144,112,64,6,37,67,79,134,184,92,93,241,153,176,181,122,149,111,253,252,61,45,5,110,124,28,61,188,140,5,31,120,103,209,131,45,41,39,13,135,242,210,163,99,85,217,174,188,223,46,170,215,23,201,129,187,207,81,135,103,1,227,16,196,199,204,107,104,155,132,193,45,25,99,0,238,226,159,175,179,13,0,72,166,86,230,167,33,77,116,9,16,63,250,159,210,243,13,126,96,200,243,189,57,52,73,106,37,252,246,170,159,33,191,162,137,86,99,84,69,34,135,100,9,30,133,125,45,198,195,70,164,25,195,127,165,152,8,16,179,251,64,68,224,1,76,26,195,31,85,113,90,18,208,84,7,23,182,19,78,108,214,14,216,245,138,14,16,134,91,123,115,98,211,19,31,62,110,226,33,53,107,76,194,177,44,251,91,182,92,151,157,105,242,61,144,182,150,37,136,159,239,100,160,3,145,160,142,7,205,194,78,239,215,109,73,244,29,132,171,81,50,183,1,251,41,112,199,203,52,45,42,142,18,185,122,58,25,106,210,220,180,9,83,161,105,150,244,200,224,36,160,146,114,154,114,18,216,212,96,57,162,41,125,119,212,243,110,30,196,37,52,117,162,215,59,19,237,26,208,77,236,155,107,255,142,250,224,116,46,47,86,112,215,11,1,70,65,0,252,19,49,196,188,131,146,24,43,216,234,230,233,120,200,18,162,241,164,8,187,223,66,169,195,43,58,234,188,122,155,136,3,75,161,199,140,89,92,144,97,111,159,7,154,107,48,155,202,44,69,4,211,242,185,255,207,109,62,240,255,102,39,245,91,150,32,35,232,49,44,250,150,142,233,42,172,163,148,38,139,145,159,165,28,81,82,216,120,224,7,185,178,138,35,150,94,26,124,229,244,40,134,209,72,21,68,97,233,59,140,92,254,10,175,46,80,74,125,4,46,235,159,163,182,216,120,197,12,248,208,144,155,120,97,229,188,179,178,206,251,110,102,206,64,225,215,48,187,39,112,9,229,58,148,237,56,173,161,16,8,15,155,115,142,30,151,8,237,158,7,229,93,93,169,198,140,226,124,238,99,107,82,50,155,204,104,157,56,42,198,11,177,86,191,173,54,179,183,203,253,185,245,43,163,63,42,184,114,121,50,246,237,66,92,183,118,24,143,75,207,96,244,5,234,84,104,149,51,153,23,177,165,130,172,74,228,74,31,191,171,237,186,211,222,120,5,134,28,252,21,135,75,138,147,247,8,45,3,97,57,254,126,158,213,220,150,74,211,208,201,175,216,74,110,228,138,216,243,7,93,104,74,1,200,203,175,5,120,150,67,32,157,128,131,135,62,19,87,105,18,62,59,196,65,71,11,177,91,61,125,219,120,10,138,245,104,243,140,22,96,30,170,249,161,69,37,242,203,35,203,154,44,229,235,7,189,243,156,56,9,25,219,148,72,192,167,212,2,67,127,45,17,223,26,254,7,251,51,62,42,206,156,207,219,67,205,229,200,55,154,34,239,105,24,126,3,62,236,213,238,30,140,16,160,174,24,14,46,165,95,166,111,68,19,149,243,140,236,225,109,107,148,117,85,70,156,104,5,79,37,95,74,148,190,105,236,246,31,64,187,161,129,148,40,229,73,205,114,244,163,72,32,75,86,232,14,224,16,77,49,39,118,68,83,121,195,160,253,138,122,75,110,53,159,116,27,179,126,226,136,5,53,123,211,135,37,87,130,131,22,115,102,249,204,120,218,225,37,43,70,126,132,5,198,240,140,102,28,201,50,178,88,153,138,52,161,204,204,166,181,171,242,128,31,7,121,247,183,93,155,180,111,160,205,130,103,136,177,65,8,235,198,208,31,153,93,236,85,125,122,65,192,241,246,232,6,172,95,95,222,37,111,217,31,108,111,77,81,129,65,32,177,109,200,99,135,221,124,223,200,21,116,184,50,208,185,135,213,248,235,171,194,217,214,193,105,109,220,238,201,69,167,185,61,13,81,249,136,210,198,167,165,138,227,95,186,131,38,217,148,40,246,23,145,35,160,188,126,198,62,84,181,160,168,182,120,35,201,217,225,177,165,80,224,71,180,239,145,186,170,19,233,216,177,39,177,150,86,192,192,39,251,235,102,243,172,198,193,121,247,86,65,216,27,79,34,192,143,143,201,102,161,30,229,46,235,35,108,186,79,103,124,227,223,53,202,82,202,117,224,221,207,26,152,88,49,240,3,31,118,235,154,19,209,36,19,213,217,49,170,102,16,126,120,228,217,100,2,101,3,113,246,62,144,1,210,112,108,139,5,172,183,15,133,12,149,239,116,212,87,26,189,39,34,253,139,9,75,115,121,209,178,48,192,238,32,218,165,90,173,229,21,38,105,67,176,188,125,186,164,95,98,190,129,85,120,248,116,240,8,245,123,139,254,51,120,149,182,18,129,102,203,201,1,170,170,109,101,66,13,202,35,96,241,194,99,11,158,114,250,166,111,41,48,171,88,31,139,215,95,87,45,101,24,26,244,224,243,122,1,135,196,67,118,246,151,22,106,241,169,181,44,187,71,187,252,56,139,187,26,186,39,161,197,36,162,111,248,33,71,16,76,82,46,64,81,249,183,104,160,29,120,96,38,36,163,40,251,238,122,195,52,197,91,85,254,115,6,247,239,36,61,126,95,127,25,198,242,201,87,243,127,72,61,116,243,230,178,177,214,171,173,21,226,48,205,51,130,188,79,239,228,119,186,68,114,208,49,193,166,238,234,90,234,209,222,110,225,84,133,201,202,245,200,90,117,186,146,193,3,84,194,100,251,133,56,3,12,97,9,252,247,36,8,73,166,154,186,232,194,160,77,147,152,199,165,62,236,107,102,231,136,94,52,127,213,45,50,104,201,5,71,172,143,90,86,132,214,20,230,248,130,51,138,47,214,208,250,163,100,13,253,45,27,146,169,241,41,128,249,169,238,20,61,229,145,27,229,149,85,23,230,5,41,11,35,155,102,116,152,49,47,73,172,184,99,33,129,242,114,60,168,154,239,205,239,158,4,143,128,0,86,229,127,80,16,180,81,201,201,97,206,44,43,181,122,12,49,157,143,37,49,67,117,212,145,122,192,79,186,231,212,149,167,179,65,128,71,69,163,126,168,147,14,241,63,24,186,41,157,245,85,249,162,41,159,71,195,226,81,142,215,224,58,165,104,80,44,168,92,241,75,141,255,82,35,92,69,46,73,86,172,50,118,210,191,171,162,17,203,79,135,242,252,162,202,117,11,223,86,73,197,152,38,6,52,103,111,8,100,132,12,192,57,34,105,241,19,30,156,91,237,35,78,100,203,252,193,20,21,101,45,122,35,194,255,90,178,110,23,96,229,204,236,105,205,23,182,171,73,88,17,147,225,9,148,104,87,130,37,36,90,48,185,239,173,182,4,39,236,60,65,60,1,254,84,216,136,249,102,205,206,246,82,25,167,143,143,28,116,67,74,77,120,230,23,152,52,80,63,55,238,6,227,132,153,98,10,63,79,79,147,176,62,111,53,234,88,191,95,169,227,117,84,93,77,117,175,170,20,213,2,228,235,121,123,95,24,141,52,31,40,48,19,224,109,51,63,144,134,146,111,148,172,58,42,244,165,165,45,243,167,178,17,102,30,171,61,215,61,198,0,15,228,12,87,149,63,115,10,133,186,21,252,132,167,212,243,112,162,214,76,193,95,138,11,122,0,10,3,66,244,53,74,94,60,204,208,9,82,207,201,176,33,223,34,253,3,85,56,253,40,101,174,216,64,231,187,189,29,196,205,186,21,126,32,240,60,184,52,125,228,206,60,157,95,238,227,232,6,71,99,253,231,156,251,208,38,192,34,129,44,234,16,115,174,136,211,95,32,176,212,48,131,86,197,69,252,198,188,173,24,136,238,73,0,253,168,159,91,138,250,145,115,168,55,196,215,176,168,109,151,146,9,214,188,137,101,101,44,53,94,223,186,12,98,117,25,44,138,95,178,133,176,224,114,63,34,88,231,136,114,103,240,151,144,103,144,218,149,74,95,133,197,245,59,194,239,101,61,204,177,158,222,147,176,224,73,133,214,138,89,66,55,110,200,89,197,40,20,148,145,121,172,72,212,14,10,170,167,134,40,89,180,109,98,45,232,219,113,130,230,71,152,114,162,245,75,163,218,157,49,161,112,156,153,141,205,95,3,98,121,107,23,201,254,66,63,119,137,147,18,154,109,249,133,120,104,150,90,205,211,172,14,223,120,126,139,199,212,236,45,223,229,51,228,83,158,154,146,94,147,250,137,95,26,57,227,4,117,247,188,247,160,144,96,238,233,44,116,249,46,250,61,174,226,165,67,96,168,140,139,232,28,85,236,55,82,45,38,248,29,187,213,126,142,8,234,105,128,138,205,92,1,177,141,141,130,89,64,252,151,144,101,125,91,220,154,197,27,141,154,121,239,180,180,184,48,67,107,30,235,112,8,183,170,61,139,32,252,90,210,180,90,235,96,10,197,59,172,130,176,236,120,38,209,86,156,40,102,188,241,59,52,20,247,28,207,204,17,157,239,106,90,18,199,57,19,236,253,44,14,31,118,23,217,236,103,249,202,67,77,16,119,242,175,7,180,87,216,250,234,230,142,26,11,74,255,64,54,197,85,66,172,251,111,195,221,248,102,148,213,12,141,235,45,78,131,154,0,228,239,246,217,122,103,99,201,158,180,252,134,188,115,82,220,83,154,152,39,184,108,0,6,118,204,139,139,12,194,215,209,241,19,60,234,72,235,180,169,1,238,9,133,139,111,240,10,7,30,121,141,225,83,233,6,92,162,121,133,91,141,241,107,74,218,135,112,210,136,33,97,127,190,22,12,132,7,175,170,58,208,185,154,167,124,31,187,47,250,172,207,197,14,103,209,143,45,107,208,53,35,141,60,175,96,75,64,26,176,17,62,194,180,197,145,63,35,111,32,15,128,73,128,22,234,214,47,113,115,233,121,51,204,202,126,224,9,238,111,4,210,212,44,18,29,5,240,22,206,10,201,223,21,218,61,170,221,34,127,178,250,23,58,25,52,82,116,136,140,82,180,40,237,165,182,177,10,159,16,0,135,236,24,147,54,46,238,139,46,86,97,154,10,142,187,146,19,102,249,171,191,204,49,75,103,193,225,140,246,141,241,87,149,51,42,86,43,76,174,223,38,77,132,22,237,130,210,189,97,117,21,103,59,26,204,61,246,151,19,242,186,190,38,10,52,167,21,52,197,153,58,4,46,168,20,171,107,189,200,189,178,241,18,135,193,248,185,23,238,0,202,113,222,132,91,77,167,95,12,246,149,203,75,139,169,126,5,203,253,190,8,154,158,114,59,237,71,76,156,45,64,141,113,20,252,203,201,125,207,2,211,20,183,154,117,177,191,3,186,144,131,17,209,208,82,122,111,156,13,182,197,192,67,83,208,233,41,46,40,244,30,175,35,229,20,146,213,217,3,178,119,65,94,95,181,231,42,162,80,168,75,100,84,201,224,179,69,86,192,46,37,116,98,156,100,151,147,8,88,139,48,199,107,50,114,142,102,93,13,13,223,144,152,125,160,87,142,78,104,123,97,141,80,234,4,37,38,26,79,139,31,252,13,22,94,98,10,187,44,94,26,95,12,252,172,12,34,124,33,87,176,225,171,146,122,235,150,153,97,1,45,149,107,61,173,112,111,25,49,166,220,47,99,216,118,42,87,209,180,124,185,36,134,219,85,120,225,118,198,220,184,168,189,212,49,107,217,172,234,237,67,91,252,126,104,67,246,230,123,244,210,243,189,74,42,210,151,144,34,99,193,111,56,245,148,226,183,195,189,106,166,148,188,117,40,113,28,1,112,244,168,89,144,194,214,93,116,109,200,101,29,241,222,183,207,29,82,129,103,164,46,36,199,132,54,28,14,184,36,197,26,227,233,69,140,96,36,208,164,243,237,214,74,15,44,230,207,238,131,222,146,215,81,131,101,168,3,189,254,52,25,233,7,167,173,5,30,137,58,126,90,14,183,171,249,185,80,114,78,17,213,155,94,215,27,229,74,154,163,237,26,115,152,160,213,233,97,96,22,251,105,9,225,245,113,144,50,5,10,140,32,86,28,235,24,88,100,202,127,197,96,156,186,89,3,151,44,46,73,146,42,150,61,9,96,252,91,76,195,183,8,65,213,41,2,126,165,79,143,65,19,240,170,63,22,15,238,189,118,238,159,60,28,191,18,204,122,187,214,65,136,210,167,154,200,101,108,254,225,229,130,121,223,84,133,134,189,56,121,80,148,59,211,140,49,164,149,228,163,79,187,237,251,46,188,36,208,66,128,70,170,208,74,239,57,64,205,198,65,187,193,184,33,119,105,211,252,67,232,165,49,131,149,24,139,138,150,255,126,156,167,190,126,45,66,99,198,55,229,133,4,17,220,176,58,77,40,205,0,150,23,244,87,162,20,47,144,215,88,129,28,118,16,57,50,11,82,88,203,72,88,106,185,216,21,173,154,212,151,54,191,16,51,207,232,145,59,9,165,60,201,160,224,201,255,163,117,247,194,74,221,212,24,188,127,124,124,214,174,67,45,42,251,94,228,23,200,239,14,130,243,193,91,190,240,70,9,245,223,65,89,48,242,246,72,227,208,20,127,49,4,104,33,203,215,90,226,211,41,168,0,49,146,71,149,185,211,253,184,136,252,173,143,173,122,181,11,119,41,6,103,169,187,196,181,104,30,67,74,241,207,214,198,60,158,56,185,40,123,58,233,219,236,79,170,114,220,39,217,28,160,136,229,52,248,157,84,43,48,34,59,163,230,123,26,242,2,139,61,59,147,100,129,40,205,146,241,69,254,107,253,218,173,36,200,211,69,111,104,110,122,33,195,56,83,182,195,74,248,28,83,170,215,139,62,101,88,248,130,89,171,145,241,160,70,229,83,100,89,148,9,53,245,36,242,92,12,132,169,10,37,210,156,185,37,187,227,219,225,31,229,118,148,143,41,120,9,144,188,34,227,222,250,158,99,178,114,208,6,222,215,135,176,244,113,52,233,124,240,32,121,99,144,101,130,173,250,58,142,174,204,0,191,57,80,34,156,104,85,231,190,15,190,64,103,210,44,69,190,183,235,30,14,63,138,220,255,187,63,177,26,165,20,127,63,179,205,29,250,110,15,67,1,133,21,64,63,183,237,83,13,55,255,89,57,102,241,51,78,113,221,171,201,87,8,142,227,243,110,101,117,228,169,62,0,71,63,52,190,41,27,131,137,17,165,241,126,101,45,73,219,226,143,97,106,197,206,30,77,104,39,72,18,51,194,225,86,170,222,130,76,111,105,254,115,219,131,87,133,176,164,242,230,93,142,114,61,184,142,255,111,95,244,100,182,143,30,86,141,82,11,183,179,6,225,4,50,138,212,222,229,232,218,81,243,189,34,20,39,131,73,186,248,43,59,145,253,241,182,54,65,165,225,186,171,150,43,182,186,215,61,69,60,252,34,144,117,139,229,175,48,204,73,177,62,74,224,66,215,34,111,82,8,209,207,167,253,13,83,217,235,102,3,203,188,151,37,130,51,80,117,232,143,15,154,183,193,196,22,207,189,125,175,247,234,248,219,63,65,190,171,223,27,196,75,130,38,100,25,157,203,252,213,31,187,54,50,158,232,239,118,218,173,61,54,73,199,2,216,198,78,57,83,160,104,5,158,218,114,46,211,75,113,225,125,220,244,235,129,176,66,79,196,27,149,209,70,210,12,144,218,95,74,241,169,170,128,255,52,20,231,95,161,66,73,107,126,82,64,203,77,10,174,146,38,60,190,185,124,90,120,125,161,91,91,32,240,182,84,29,88,90,81,31,48,100,67,208,210,39,179,172,3,211,65,148,197,195,3,225,105,1,206,102,62,254,161,237,62,163,14,61,250,217,4,20,205,167,20,0,183,232,220,22,193,66,26,243,195,86,49,98,64,21,153,248,143,51,50,254,148,126,212,241,113,202,118,101,58,105,250,228,72,51,39,17,169,7,133,247,69,234,117,223,204,249,30,169,74,19,85,193,161,10,157,234,82,190,77,243,178,40,53,179,73,64,69,212,184,238,59,225,53,17,74,104,207,152,250,222,80,104,176,249,210,64,17,44,188,95,178,189,201,95,122,214,7,14,103,119,171,95,194,145,209,136,250,104,62,91,85,145,41,18,153,159,42,8,57,112,84,46,210,83,204,244,120,17,58,250,233,81,29,203,245,6,82,6,105,102,36,1,77,250,119,11,28,14,196,239,226,243,97,182,206,193,11,238,109,227,154,113,193,138,56,230,8,3,200,75,72,163,252,229,39,11,190,106,84,159,21,7,64,183,164,56,33,175,208,153,144,183,148,253,214,249,194,175,252,254,35,204,17,15,196,140,141,230,114,184,9,28,14,114,1,149,250,48,238,8,96,78,175,37,113,7,227,158,246,27,188,54,139,6,113,189,107,221,160,33,90,7,221,188,193,179,19,156,175,100,250,173,107,231,232,176,58,103,185,190,152,45,186,208,46,161,194,185,51,195,135,204,1,209,240,252,146,236,253,209,226,91,1,81,130,158,74,42,193,135,52,238,141,187,230,35,63,248,88,58,230,189,3,42,197,97,31,33,187,0,64,46,194,43,81,143,117,167,88,93,157,235,21,193,224,179,3,66,103,137,189,208,1,157,107,79,192,129,102,205,133,201,125,84,79,216,118,161,141,21,232,72,191,199,136,147,66,198,195,127,184,79,19,174,254,145,47,177,156,90,253,171,45,255,75,230,13,12,254,30,122,87,142,119,115,35,62,120,26,116,163,94,20,6,231,13,53,16,104,136,224,240,75,77,253,169,57,20,105,164,152,86,208,192,107,218,98,132,248,208,214,4,161,28,194,185,128,161,99,5,227,174,59,45,57,51,116,34,193,108,11,38,243,22,221,233,238,224,219,165,167,115,211,215,228,134,240,89,91,59,99,116,92,160,126,104,164,48,142,233,157,156,171,188,25,91,144,254,191,132,56,48,43,67,44,33,176,249,246,97,211,54,35,245,172,215,159,63,232,8,48,200,192,91,3,187,179,218,82,22,241,56,249,14,235,62,81,50,139,52,3,106,238,129,151,59,151,39,159,231,140,107,46,72,206,38,93,183,113,20,109,242,233,56,70,214,116,40,178,253,91,140,105,91,177,54,171,221,178,189,75,244,133,36,123,164,212,201,226,57,92,22,144,96,127,93,227,137,51,38,236,118,117,76,244,73,186,137,82,224,228,143,70,110,18,159,80,32,48,221,146,110,146,200,145,45,32,40,128,93,116,110,17,224,98,206,84,194,69,114,248,65,246,246,250,231,187,121,240,96,15,206,26,69,40,24,151,198,245,224,82,114,191,216,99,25,106,231,232,83,46,114,85,16,22,85,243,39,155,238,18,216,221,112,180,77,42,50,57,52,255,22,150,236,110,152,119,187,222,7,165,51,29,227,192,85,60,39,124,101,175,119,143,171,115,158,192,252,244,14,115,43,254,118,88,141,143,200,110,8,59,4,228,119,125,80,163,163,55,223,103,41,248,59,24,84,194,123,16,194,249,74,16,161,83,101,175,102,43,90,200,195,66,84,34,99,77,204,46,133,245,174,194,80,75,237,134,188,252,186,196,115,59,206,144,150,107,74,246,6,79,43,31,208,226,180,21,116,127,190,134,44,131,123,11,22,223,174,192,26,122,83,96,197,6,249,127,179,223,174,31,140,65,244,82,82,245,11,176,233,161,242,157,180,226,195,23,92,91,102,79,104,46,189,86,139,55,67,76,69,7,126,196,150,48,9,70,159,137,63,11,33,43,17,105,197,174,44,236,171,216,253,17,157,45,66,44,40,200,22,176,183,210,1,110,102,248,145,92,185,48,148,65,98,93,145,58,231,10,127,250,65,135,115,133,65,16,74,83,117,120,173,182,137,13,219,40,164,123,50,242,187,188,67,168,132,2,52,54,207,130,130,180,220,87,48,7,15,68,231,80,100,59,177,28,119,197,235,127,115,131,197,165,36,169,118,56,190,78,126,171,191,155,189,15,175,60,201,184,148,39,181,242,65,188,143,121,183,109,249,217,182,86,71,79,39,108,72,28,47,181,11,242,237,145,166,57,63,102,190,218,188,196,151,113,21,159,17,219,159,179,252,210,1,23,89,229,150,211,128,56,78,189,27,253,129,130,174,101,236,37,29,18,241,6,167,28,245,206,24,252,162,14,135,152,255,168,47,55,25,14,207,33,103,184,33,204,143,185,90,177,61,89,40,14,21,101,142,224,165,102,172,157,182,164,188,148,233,51,198,46,93,145,29,69,222,161,176,204,121,160,37,173,21,97,14,96,93,92,179,146,10,27,204,102,240,60,221,3,43,214,194,111,208,221,54,7,25,16,173,169,51,161,46,22,226,137,159,151,84,113,59,25,112,148,184,237,151,120,146,227,144,132,70,163,162,12,148,244,154,99,72,144,169,161,154,128,188,231,201,165,67,180,25,101,210,9,246,44,201,213,24,23,154,218,238,63,160,239,238,205,43,108,66,133,215,253,45,137,250,139,218,91,78,39,22,134,192,217,213,239,233,50,37,86,104,107,149,198,99,2,52,202,127,72,138,194,248,217,104,11,123,120,114,156,44,109,153,39,39,45,162,163,57,121,129,253,132,161,123,152,38,122,237,120,130,222,10,210,210,42,20,11,162,72,85,215,11,133,128,229,100,36,2,109,236,130,22,194,85,253,90,49,207,165,72,252,77,109,121,108,13,216,78,190,151,185,129,82,62,241,99,253,121,42,189,19,64,99,20,205,114,30,78,112,214,192,197,183,193,201,235,18,104,132,70,214,138,204,92,159,221,120,119,170,95,214,75,165,38,135,21,18,51,152,53,117,181,172,37,182,214,78,105,130,231,86,195,117,34,94,147,243,152,204,188,94,69,2,27,37,107,66,188,46,165,125,49,54,124,245,175,198,160,22,126,190,220,4,242,121,211,102,71,132,35,133,127,13,242,114,71,219,148,41,150,94,80,159,65,108,218,122,40,52,55,247,158,104,121,88,42,195,64,235,147,95,183,75,13,69,177,143,33,27,233,112,89,190,194,124,120,211,142,63,6,23,158,87,16,63,255,119,0,86,160,73,12,212,183,23,245,129,8,83,80,223,45,154,254,31,97,93,25,233,204,17,68,68,126,35,44,211,37,139,185,129,47,79,28,223,207,17,103,131,102,59,139,182,72,153,226,222,233,214,5,210,101,86,147,228,12,15,105,223,73,81,229,155,25,168,108,171,245,19,6,138,19,70,217,230,79,163,174,85,75,172,49,186,162,175,228,115,87,96,37,153,210,166,130,31,15,240,49,111,33,179,152,12,135,238,21,77,32,38,122,247,177,95,230,70,7,103,207,178,64,160,192,103,205,103,110,155,67,249,44,93,148,213,209,115,49,115,48,118,230,224,147,167,176,99,35,1,54,91,36,168,140,247,166,16,69,104,154,191,123,105,45,240,42,52,238,38,195,196,42,244,101,171,102,175,230,0,157,99,234,122,20,72,63,89,7,38,215,6,183,0,45,171,125,97,46,138,171,240,94,72,194,22,9,17,161,37,176,182,198,52,237,222,144,142,241,30,104,177,251,247,122,161,78,100,151,245,202,192,189,37,246,245,222,95,151,104,97,51,125,156,14,100,131,226,62,103,104,119,216,78,240,28,114,173,77,90,198,82,209,42,77,168,116,127,204,95,180,89,9,242,77,105,48,51,208,197,215,107,240,147,4,19,51,140,213,37,129,42,152,26,176,39,209,75,115,31,42,182,164,49,43,124,140,57,74,171,140,25,72,102,19,104,101,53,66,16,36,81,157,63,49,81,113,50,17,177,242,42,13,66,87,177,238,90,135,215,210,223,139,125,125,113,123,74,185,38,95,126,178,254,140,194,108,22,75,19,81,9,213,51,86,9,160,78,163,180,5,151,134,179,237,255,112,21,232,119,132,180,49,136,238,247,212,176,150,152,70,105,125,184,194,188,160,43,67,157,209,250,198,115,100,202,139,89,168,216,169,68,127,214,188,144,171,232,33,3,179,117,32,169,207,114,72,197,178,97,50,153,224,125,106,207,61,49,205,215,42,7,51,129,179,76,92,199,254,53,143,39,162,180,106,237,61,173,233,255,203,59,134,208,122,9,32,187,216,131,185,122,209,138,238,221,213,41,161,191,154,136,61,125,221,24,254,250,234,240,137,194,216,142,153,164,80,33,178,23,211,6,142,187,119,24,162,92,216,36,147,130,5,73,169,170,2,86,6,217,251,80,33,115,243,94,128,37,97,8,1,71,32,177,253,175,228,159,118,70,83,85,177,192,103,62,4,114,102,162,142,209,251,237,184,223,96,65,184,218,89,71,135,194,191,212,227,77,192,83,70,223,117,112,166,189,139,204,169,194,120,106,226,148,29,67,111,246,96,85,252,201,13,242,15,20,202,190,153,45,61,170,107,52,32,163,77,80,138,105,222,179,60,71,191,10,12,232,136,225,115,245,26,115,29,66,84,174,202,214,172,242,255,216,246,77,229,202,21,27,42,7,18,72,1,54,153,33,97,102,135,217,63,229,20,77,150,130,78,120,205,205,36,74,120,180,71,212,198,171,210,103,212,236,25,222,136,233,113,232,186,14,9,5,37,99,117,199,61,21,33,88,228,244,158,94,35,255,147,15,71,186,104,210,182,219,45,60,221,183,238,147,173,108,107,98,14,182,73,246,161,82,128,27,55,102,170,109,164,196,150,163,189,153,67,45,28,155,214,103,254,201,197,168,227,213,208,137,188,84,108,217,90,237,84,12,101,78,62,108,77,13,247,243,242,211,223,69,102,235,44,116,87,66,0,54,182,4,255,50,61,0,248,124,162,130,54,76,72,224,221,86,114,198,81,65,13,214,76,231,3,131,29,248,24,247,243,72,162,98,126,132,168,158,213,21,179,22,144,94,70,230,208,225,63,230,82,248,87,85,136,155,76,1,156,38,122,57,99,39,67,30,173,46,83,107,100,98,226,89,39,170,23,78,89,187,103,142,123,188,193,85,118,75,250,99,117,200,250,104,32,205,159,159,28,36,198,236,36,52,12,15,228,22,219,249,20,51,81,201,176,199,215,80,111,67,181,85,194,202,142,53,32,97,132,164,232,228,159,146,54,253,109,178,101,184,54,61,192,232,155,160,106,153,179,154,149,231,205,19,124,106,89,39,28,239,84,117,83,1,137,32,194,23,32,191,184,68,141,159,192,143,41,138,191,179,162,19,123,246,40,229,245,190,67,217,222,77,231,202,69,116,31,69,74,206,187,36,171,236,114,93,18,21,57,172,53,60,154,141,69,183,105,199,208,96,96,188,45,178,93,183,54,196,98,176,140,9,69,104,107,168,27,228,113,122,20,202,221,249,16,175,8,113,154,113,175,55,33,170,55,48,23,161,251,181,101,93,95,60,139,27,66,226,13,154,32,180,232,245,160,27,73,236,39,135,218,42,26,123,110,181,137,102,230,43,56,92,171,201,204,151,114,68,130,194,8,211,252,151,168,182,2,184,36,215,193,0,248,144,201,163,14,31,146,46,36,138,232,243,161,80,148,6,233,92,90,112,154,157,69,161,187,97,83,122,52,178,50,58,88,118,204,137,244,234,203,41,97,169,163,122,214,27,12,105,240,163,141,227,46,55,111,50,141,67,142,128,215,3,10,10,220,24,76,82,59,4,17,219,229,76,99,217,33,254,136,156,67,97,62,131,140,168,42,138,110,142,66,111,11,123,6,102,171,251,0,103,76,56,90,253,118,237,151,82,88,48,220,15,77,173,192,139,1,35,236,143,114,182,196,158,213,29,18,203,100,51,141,240,52,35,9,137,35,56,1,126,201,16,82,252,143,223,132,132,204,210,210,7,88,213,11,144,243,133,158,211,88,107,158,227,9,126,82,230,105,178,70,108,253,229,250,204,168,139,90,151,102,125,150,179,189,149,215,114,83,15,190,212,16,70,209,13,180,207,204,19,24,2,185,140,12,85,46,38,57,90,234,32,66,61,76,147,192,203,245,42,102,16,29,106,168,200,45,50,111,97,205,60,234,40,73,98,18,104,93,64,33,148,242,109,149,161,10,90,50,231,208,250,175,43,102,123,215,63,150,203,15,92,104,32,32,5,226,143,22,190,18,182,220,136,131,69,226,141,141,170,255,160,158,65,159,149,207,171,89,210,144,46,156,219,236,254,195,88,159,202,119,4,26,122,140,171,61,193,253,248,175,243,244,197,74,210,225,10,250,73,116,33,159,33,109,217,54,218,117,53,97,159,174,116,71,74,178,191,101,198,111,210,244,119,145,18,19,235,118,107,106,149,144,242,177,245,138,222,61,4,148,19,33,146,88,132,206,126,57,12,116,98,182,90,61,13,39,213,119,143,137,178,11,11,160,225,203,81,51,183,210,51,93,117,179,142,163,69,128,117,128,59,138,125,52,101,67,199,213,253,144,34,140,77,34,33,53,92,190,237,155,176,238,71,120,57,83,237,197,59,136,180,43,43,125,66,204,39,240,252,152,82,113,5,74,60,189,143,59,2,115,77,10,87,73,194,91,2,59,224,194,134,48,213,177,217,173,67,100,28,235,79,108,154,249,128,53,113,168,67,123,160,236,104,122,190,24,216,145,233,243,99,105,162,60,251,116,142,218,154,223,86,250,249,90,163,71,97,253,126,141,99,59,188,132,103,97,239,186,151,148,130,112,2,214,220,17,162,221,166,237,74,216,163,169,46,11,117,32,165,219,161,140,58,33,90,138,76,27,117,116,70,174,222,134,78,191,0,174,181,134,71,174,254,186,172,131,82,178,29,185,52,186,192,211,19,74,34,88,218,25,13,138,158,56,108,61,201,204,234,197,39,131,122,171,130,195,202,213,139,240,192,252,13,183,253,47,223,210,129,85,201,40,169,121,241,118,238,161,234,155,143,119,91,85,129,126,136,231,203,119,109,49,176,108,177,234,178,65,21,52,148,214,63,85,68,16,143,84,100,186,27,86,206,69,155,18,123,67,156,160,122,134,147,144,71,184,211,35,220,36,235,37,103,185,255,212,172,9,59,238,50,232,177,175,12,198,212,72,218,73,46,148,41,210,75,234,78,24,72,16,194,226,240,101,255,130,17,193,202,87,85,106,58,45,217,91,63,74,240,185,107,5,137,46,27,217,76,128,32,123,167,55,243,231,104,188,2,114,84,24,240,86,145,135,39,158,142,211,155,119,232,15,249,100,202,210,128,65,136,164,62,190,218,213,172,165,28,134,243,104,84,113,31,246,52,68,225,79,216,84,53,229,34,96,55,46,35,40,226,99,209,226,232,114,165,166,250,179,43,231,173,166,184,87,101,3,219,168,180,25,164,136,123,48,173,96,66,193,27,140,81,42,179,87,144,148,233,21,71,75,184,13,58,233,206,15,165,150,196,8,159,141,152,25,112,56,204,82,109,180,233,140,48,249,226,121,129,193,162,10,52,126,77,250,200,90,131,97,202,48,211,16,239,9,0,117,13,215,174,84,66,67,186,62,1,118,247,79,132,5,118,79,63,137,86,37,114,208,6,190,34,188,53,40,71,203,184,3,72,126,215,152,123,220,147,223,155,26,13,30,187,151,100,76,152,52,72,102,174,182,7,97,192,183,43,147,37,32,38,110,196,121,210,23,229,100,47,43,151,130,218,117,235,125,171,75,142,192,56,159,198,206,45,250,170,220,252,206,235,199,46,0,173,232,89,199,195,173,148,225,82,219,140,196,243,62,220,191,129,89,59,189,190,251,217,152,216,234,220,108,29,212,88,25,201,140,148,208,181,49,82,38,5,172,229,251,29,180,152,169,211,86,243,3,120,184,125,215,220,225,48,210,54,253,249,211,226,253,173,3,197,88,177,53,223,55,248,216,84,177,5,88,246,42,141,207,155,177,162,235,248,158,56,191,124,21,16,239,4,40,37,78,172,74,11,30,10,28,165,203,93,71,252,252,18,56,229,96,47,77,154,127,98,96,214,72,85,93,91,109,32,17,134,80,58,70,238,62,246,51,113,99,11,58,255,17,225,24,8,62,22,108,198,0,183,22,239,97,96,159,51,125,241,91,113,66,33,150,140,181,243,217,135,44,17,147,214,209,101,174,121,117,174,18,247,232,31,219,68,10,208,100,228,249,53,94,138,68,221,52,150,220,160,133,24,213,173,117,80,72,64,81,215,2,189,87,120,82,1,95,166,190,161,200,123,62,254,140,235,73,79,144,79,206,33,206,219,113,4,251,116,115,148,38,227,140,216,254,208,168,36,105,83,132,42,24,92,233,141,160,134,241,245,65,47,196,176,41,73,122,77,12,182,235,32,159,187,233,204,220,178,126,152,172,82,45,223,242,153,175,170,166,110,7,190,252,157,205,67,84,56,204,186,83,211,108,1,55,70,154,71,197,222,210,8,136,32,7,41,69,91,244,181,151,132,162,2,243,83,128,85,147,141,197,195,170,76,181,239,115,160,215,252,197,62,89,143,17,35,68,94,236,162,66,199,178,101,174,200,111,239,248,26,203,255,124,177,160,91,140,215,152,103,100,19,111,228,243,23,213,4,165,190,1,147,160,77,221,187,152,158,98,175,184,96,53,89,241,236,147,111,81,71,33,61,250,36,118,189,70,238,55,218,94,249,159,168,166,229,208,216,249,209,35,171,194,152,248,137,168,251,184,146,183,129,175,13,20,7,101,11,230,74,115,161,186,197,39,127,137,80,93,28,4,59,204,19,7,148,140,254,57,69,233,255,95,75,73,234,8,53,221,15,158,139,85,64,3,153,236,31,94,43,178,219,220,76,78,75,71,45,19,142,206,49,117,136,238,42,45,132,153,191,211,235,107,82,102,157,79,220,140,104,13,64,72,213,133,173,95,53,189,151,93,197,97,83,42,36,111,24,142,4,109,174,215,72,59,127,121,88,159,195,179,94,203,24,246,0,222,57,189,240,75,148,252,178,132,102,164,158,100,173,143,111,168,93,233,147,202,193,176,232,37,98,241,169,11,80,40,202,202,106,30,119,120,183,188,164,110,126,177,158,77,23,211,116,86,137,19,133,167,39,188,207,2,118,162,219,240,158,208,97,19,26,220,111,82,13,85,128,153,225,124,32,46,140,231,176,227,146,70,165,88,211,238,197,174,226,152,46,192,229,225,238,177,14,67,138,141,85,4,187,208,139,217,222,232,10,72,198,232,97,167,196,75,35,74,158,125,28,62,37,215,224,64,78,115,253,213,127,72,255,13,56,118,102,172,2,108,28,250,161,102,158,112,245,44,191,86,195,88,68,54,243,149,182,129,248,21,28,43,62,231,71,0,89,173,177,25,122,239,22,187,91,44,190,185,28,39,178,94,162,240,51,202,141,228,158,194,209,233,59,49,54,131,203,242,175,186,41,233,170,167,197,116,50,172,241,5,113,134,81,246,132,172,87,220,75,144,51,138,13,203,247,136,75,56,229,115,8,130,228,128,178,208,96,74,81,38,157,144,199,237,139,236,28,54,62,10,178,33,246,202,154,188,199,125,161,232,132,173,133,154,253,245,79,187,114,17,211,170,202,85,238,117,173,242,81,70,114,70,29,221,94,11,197,104,253,214,193,118,236,228,39,75,156,112,214,228,101,181,229,222,55,63,195,51,250,60,32,115,180,155,163,21,183,129,219,93,160,33,82,26,164,163,225,118,161,119,143,25,162,182,238,242,155,100,216,28,166,57,147,141,42,203,229,37,105,31,182,114,238,236,166,39,49,82,52,152,241,200,172,151,47,49,182,206,211,183,196,126,59,215,64,120,229,168,166,117,25,195,122,83,135,253,90,67,12,158,112,10,129,200,129,60,9,73,255,10,209,131,51,44,202,131,155,11,198,189,197,40,69,187,110,55,108,105,203,185,74,128,189,24,0,197,74,158,5,253,18,187,56,202,26,77,44,246,246,51,169,0,124,103,155,106,153,142,138,160,19,224,127,23,61,88,28,138,169,118,143,66,77,108,218,96,40,82,1,100,45,122,113,16,41,181,164,50,174,6,86,17,20,185,76,229,114,144,206,45,218,38,189,180,206,153,82,49,205,48,124,7,107,39,57,49,208,0,219,169,5,219,248,111,65,43,18,128,231,200,0,137,51,169,231,84,42,199,70,200,154,232,197,79,133,215,211,225,15,137,232,76,220,17,20,174,154,90,198,82,145,199,207,127,140,142,253,202,115,61,31,176,81,87,4,165,209,136,159,240,3,48,189,131,147,0,220,99,35,250,160,186,110,85,151,90,148,240,28,39,49,74,224,104,245,64,47,51,22,200,236,72,215,123,58,239,196,244,54,110,163,77,43,203,219,193,23,166,136,185,120,50,196,17,42,193,134,53,125,184,178,217,2,145,51,77,60,37,165,29,174,135,33,172,44,5,17,255,177,188,69,254,140,171,88,233,71,98,115,162,67,162,173,86,30,216,3,137,243,143,161,102,152,60,174,127,105,210,135,23,169,212,61,105,74,215,87,40,184,125,52,43,38,85,27,57,142,50,125,196,28,180,237,252,145,198,245,72,11,195,143,226,232,82,206,68,216,218,134,139,23,189,81,118,245,214,203,241,245,211,68,122,148,132,238,234,254,148,46,70,61,242,191,89,78,45,160,219,25,142,81,134,220,29,212,82,127,40,127,19,215,33,229,148,186,168,137,46,48,141,255,126,3,188,129,189,151,170,102,228,217,189,23,58,79,233,167,247,68,25,57,22,42,236,168,161,11,30,254,199,237,9,40,222,88,42,133,144,158,232,35,188,89,202,26,205,117,130,82,109,129,176,69,154,222,158,181,140,157,255,150,167,248,146,245,247,148,101,167,48,147,164,163,168,28,17,182,8,156,7,75,81,164,156,44,121,184,129,170,235,123,29,237,165,21,3,181,169,200,162,0,146,62,21,107,168,135,161,194,121,228,186,38,232,237,253,220,120,218,101,164,143,221,108,186,139,143,63,90,30,21,229,223,197,244,144,77,238,17,72,80,92,224,232,41,237,23,253,194,206,250,140,242,34,144,209,90,31,239,218,243,184,81,23,106,217,163,154,126,98,14,155,95,93,189,50,238,85,23,185,78,32,245,129,79,31,211,218,15,97,81,68,240,191,113,125,136,111,166,35,69,4,105,94,130,247,49,53,88,20,6,86,209,44,13,227,163,175,28,65,129,127,238,113,110,185,37,79,184,243,109,136,215,8,239,225,101,213,2,237,228,29,191,21,178,97,136,167,179,1,73,207,114,57,91,48,229,69,73,241,79,191,193,34,96,174,130,137,229,165,90,46,31,230,166,38,228,134,71,2,88,116,114,37,197,101,121,19,230,176,10,236,187,85,172,234,167,181,1,207,190,30,131,210,217,73,137,172,233,172,148,115,174,201,214,92,251,157,89,168,195,24,248,5,211,254,239,94,50,221,149,248,99,168,16,38,149,223,179,24,120,164,28,247,188,114,75,9,182,166,155,75,83,90,65,58,119,232,115,60,215,223,195,228,140,147,36,233,209,180,36,165,137,89,37,34,113,195,243,239,218,64,38,51,175,154,34,34,239,121,7,49,200,110,52,24,189,64,212,202,172,250,31,16,179,19,164,240,246,243,122,18,233,96,192,109,92,2,70,133,173,107,148,22,56,33,187,120,132,237,153,0,76,8,50,82,102,7,99,164,128,131,176,186,203,3,162,233,202,137,228,244,72,24,187,108,200,83,62,122,33,228,141,224,188,112,213,17,201,25,64,23,26,71,34,164,245,235,242,162,56,92,228,165,196,136,227,174,252,168,117,27,12,56,73,221,84,210,152,196,155,157,66,119,45,209,115,63,91,150,172,52,255,117,182,203,185,178,145,60,89,101,159,120,76,72,244,66,116,175,71,126,66,61,44,73,173,196,58,82,64,107,92,53,145,113,117,145,197,206,182,116,84,173,78,125,246,114,139,120,79,17,75,93,193,72,45,72,247,114,219,51,210,193,167,88,50,152,192,101,171,204,0,12,52,94,144,170,218,215,226,60,20,91,110,54,59,244,40,119,166,129,124,108,65,80,231,40,17,129,122,50,136,81,153,169,90,84,102,83,201,218,133,156,90,11,210,25,48,221,76,76,106,22,93,88,123,151,83,121,118,205,196,76,114,204,47,20,63,71,240,131,31,203,213,16,221,118,219,106,232,231,164,45,217,210,218,192,94,245,42,43,234,141,94,254,219,133,32,15,238,165,97,245,106,196,236,81,33,253,16,201,100,237,37,253,231,191,154,36,7,123,61,178,1,51,221,157,69,50,231,76,219,34,252,10,33,78,72,28,39,31,54,160,183,17,143,134,156,87,240,223,46,11,149,171,73,3,222,62,2,209,82,69,233,226,221,207,77,192,160,80,105,216,76,11,186,13,190,53,70,17,123,184,94,207,117,208,187,135,177,8,99,60,247,69,227,135,152,8,72,11,65,24,157,186,146,157,40,93,29,178,244,188,231,168,248,108,164,223,161,212,136,55,37,40,176,74,62,157,248,11,54,199,13,251,74,54,252,243,146,147,210,225,246,252,172,107,228,74,24,60,36,26,243,220,157,51,82,109,183,239,26,245,39,138,240,243,176,190,160,20,206,172,82,86,80,181,13,33,133,240,98,93,185,152,246,27,228,225,28,122,165,250,227,34,111,27,165,241,130,230,162,32,95,37,25,186,191,82,94,37,190,147,200,47,249,72,81,206,110,107,78,113,37,66,146,198,204,250,81,173,205,44,238,165,23,76,188,148,158,191,99,51,174,215,93,102,213,90,231,207,85,95,156,100,167,203,32,218,80,172,47,14,200,72,10,208,20,179,249,90,86,237,47,200,174,243,71,126,153,131,72,48,42,242,241,105,118,180,66,204,104,11,143,156,20,118,101,197,176,178,152,41,106,82,46,230,161,77,255,2,94,133,177,161,212,199,183,215,58,191,154,176,54,242,72,164,122,64,142,236,119,190,47,227,97,166,40,212,60,178,185,204,239,188,25,212,83,116,86,84,31,155,8,146,194,179,226,222,38,135,58,156,17,87,72,90,136,155,233,224,88,18,115,237,164,146,166,207,124,214,212,148,136,91,177,231,90,66,114,174,158,78,250,171,171,118,79,121,222,77,74,189,105,141,250,53,171,242,255,81,34,206,244,157,8,243,255,198,155,199,22,254,189,247,196,242,83,178,138,140,192,209,194,94,199,90,21,235,126,89,136,80,230,255,13,98,102,150,112,229,240,220,52,226,125,165,124,36,94,126,244,55,14,241,217,183,153,127,124,86,229,16,21,109,228,99,219,56,55,201,152,139,144,194,217,16,182,165,50,225,100,2,22,75,93,117,140,239,226,5,228,54,13,46,246,80,58,2,3,221,253,7,59,87,94,19,20,100,233,168,121,94,78,100,34,39,135,105,102,61,162,214,216,52,106,26,238,214,152,82,13,200,49,50,118,98,153,230,118,101,243,168,126,72,14,234,178,193,224,13,117,163,185,86,33,246,149,4,162,82,112,194,204,125,84,204,249,219,69,240,50,250,230,143,254,253,25,198,170,222,69,195,236,210,202,238,94,7,20,139,1,190,227,250,150,203,83,234,239,115,252,176,121,162,182,87,173,133,61,92,242,148,46,191,13,219,199,243,170,203,81,57,21,243,32,66,168,189,111,60,36,152,240,71,85,65,40,50,176,125,14,151,183,126,82,76,165,86,122,36,158,242,199,115,7,9,136,16,141,12,255,104,248,160,24,179,9,253,142,55,86,45,235,54,56,6,178,58,207,135,71,44,54,46,43,92,61,76,3,118,124,35,92,101,16,90,75,99,139,74,187,154,248,99,143,188,234,187,123,116,130,26,145,82,50,158,218,244,245,38,85,0,25,202,125,229,61,177,66,39,151,186,136,121,203,229,190,114,129,139,222,103,92,229,216,10,162,0,64,226,117,247,129,70,125,242,46,58,9,172,236,252,92,86,38,114,114,96,21,102,76,95,118,190,115,84,17,13,86,100,212,171,155,170,187,25,178,78,73,116,116,198,85,237,78,60,195,62,110,254,175,1,26,106,58,31,112,138,135,234,62,14,117,79,53,186,68,59,230,16,27,52,40,230,209,142,168,238,133,222,194,161,90,42,159,50,4,197,97,118,67,85,55,110,196,53,130,90,61,95,195,14,62,132,187,117,189,2,144,42,165,171,95,83,185,106,29,86,126,152,29,77,187,74,181,92,169,4,223,58,74,201,46,9,158,25,8,1,56,69,104,191,115,25,255,251,53,119,36,251,123,92,83,98,179,215,242,81,179,16,157,109,72,248,21,140,211,172,175,27,190,195,216,94,60,52,32,115,11,208,21,195,81,219,93,133,201,45,232,170,246,221,130,146,196,176,144,145,240,189,245,199,245,74,92,46,62,176,250,7,62,155,151,178,50,217,157,52,82,131,29,15,214,109,178,112,25,129,144,59,8,236,195,136,128,240,171,140,110,63,220,231,222,174,151,76,98,7,43,164,15,234,240,241,239,33,47,138,71,225,3,154,234,30,52,249,4,131,236,15,103,241,139,69,199,10,124,89,213,183,129,102,122,9,232,67,197,59,243,157,39,245,55,157,167,0,219,123,191,85,0,33,233,195,208,88,159,251,44,178,56,89,49,18,130,212,106,177,172,55,184,5,73,210,165,117,140,205,245,43,83,249,14,38,191,56,115,229,83,183,38,128,30,156,205,200,173,16,218,89,161,128,23,238,37,163,154,86,39,165,10,206,161,94,197,12,228,215,3,122,39,233,39,108,224,74,216,7,54,73,183,236,139,103,204,71,56,93,38,9,188,235,69,237,252,142,168,170,62,1,193,10,148,199,144,19,90,229,233,21,25,19,73,230,230,240,254,52,83,10,72,160,41,41,168,169,237,138,255,91,175,150,17,193,147,194,131,96,131,134,14,254,13,44,69,177,28,109,201,206,13,28,109,175,69,190,205,221,78,27,48,159,84,103,174,129,132,29,141,255,173,89,99,168,8,195,100,1,11,242,124,129,134,184,116,96,164,248,231,14,185,86,98,161,158,33,208,68,67,255,139,145,160,49,241,157,155,251,175,249,168,106,50,205,96,221,60,51,227,34,45,244,82,254,150,219,117,51,120,198,135,102,14,206,192,192,47,20,155,173,137,40,126,11,151,251,177,59,84,84,168,192,238,219,198,124,149,19,112,151,7,10,236,95,89,129,218,27,51,198,123,106,180,248,34,248,112,200,45,40,12,244,42,65,104,130,197,218,111,112,94,189,128,192,248,217,14,233,241,89,178,11,118,211,166,249,241,156,61,133,217,114,240,225,114,164,154,27,77,183,111,87,56,112,222,236,167,184,81,152,101,168,14,229,128,142,232,154,45,19,12,215,84,60,129,95,40,75,245,102,96,119,180,80,134,142,58,80,181,175,33,17,240,186,45,114,100,195,131,218,138,193,18,55,217,198,24,233,136,177,202,20,240,25,14,91,195,68,128,93,170,96,254,144,219,204,164,86,172,231,49,119,92,230,81,163,130,194,108,91,240,247,93,44,138,117,193,45,241,183,245,161,236,216,236,170,92,163,232,118,167,192,201,60,178,2,18,139,213,88,90,80,187,71,180,240,121,112,106,140,41,42,70,65,203,123,184,36,81,29,38,255,168,181,254,14,168,77,5,68,189,152,80,92,41,39,225,75,91,8,43,239,87,19,69,184,172,152,18,42,211,191,59,176,140,49,114,72,125,29,65,55,104,216,8,110,84,4,125,162,224,123,217,107,243,7,112,140,98,122,56,178,212,23,90,172,64,37,94,119,230,165,180,101,41,210,73,93,41,242,226,152,180,207,122,199,51,238,216,100,137,253,89,160,129,121,156,167,252,60,95,127,26,171,12,10,250,213,49,223,86,255,182,21,225,124,162,19,20,250,161,101,94,23,73,216,21,165,154,23,74,228,251,183,133,77,156,221,171,33,89,103,217,203,173,162,121,245,29,90,34,67,254,171,159,72,187,135,99,43,241,138,15,162,62,237,248,0,229,144,182,45,38,56,194,247,237,133,161,12,35,224,102,68,154,210,82,50,229,38,82,15,20,53,87,136,118,146,177,224,97,80,128,215,141,242,23,52,17,173,46,53,103,152,220,51,52,182,188,58,253,53,155,250,169,107,224,253,37,112,158,134,17,178,160,157,240,182,205,62,111,31,100,171,79,147,153,68,80,0,98,227,254,202,83,136,164,127,238,129,83,104,175,6,174,67,217,172,13,37,254,111,190,78,179,99,244,21,89,37,188,153,32,73,230,67,203,65,106,127,153,5,29,36,197,248,61,195,114,41,189,169,27,109,112,228,216,5,100,230,75,227,101,194,191,198,174,46,11,118,50,174,154,19,83,252,124,8,92,224,183,132,33,75,253,118,108,236,128,154,57,159,143,245,221,192,132,255,236,42,130,68,10,57,217,236,254,166,79,21,39,76,106,182,19,64,184,66,165,89,19,167,132,17,4,178,178,71,188,192,8,230,174,158,81,118,9,206,182,215,148,164,84,158,93,190,250,66,96,171,197,4,74,141,66,10,91,21,42,8,212,144,173,118,144,20,81,47,223,15,19,64,168,78,58,150,149,254,67,95,7,67,180,32,151,4,115,77,34,255,189,169,151,58,242,8,38,158,19,146,175,38,229,166,134,154,193,222,236,84,157,229,145,65,238,217,42,129,131,210,171,94,217,206,62,111,0,231,115,187,215,13,126,159,105,22,111,223,241,20,50,152,143,124,41,92,246,55,82,219,203,16,152,160,92,150,14,125,42,119,123,218,49,194,226,191,169,189,68,206,50,163,48,99,49,11,158,155,34,154,21,66,95,82,86,149,49,215,215,251,22,174,213,31,121,253,217,234,26,45,90,63,94,232,230,192,82,63,43,48,151,12,67,34,127,147,226,88,65,148,70,160,46,147,34,186,107,120,211,160,112,83,26,163,66,4,216,222,73,191,81,26,237,3,196,175,219,112,95,7,59,58,68,228,45,168,165,33,101,190,62,70,200,105,180,186,175,96,171,65,109,62,57,130,18,29,164,0,193,176,226,98,167,156,133,59,29,236,187,221,242,159,109,83,36,188,212,180,61,2,222,166,236,143,203,83,207,253,195,116,57,53,190,107,92,229,56,35,67,212,74,223,244,1,220,182,159,48,19,10,210,94,102,24,213,246,230,88,183,166,28,168,184,206,40,135,167,151,9,116,163,145,53,142,86,82,215,196,62,153,144,70,223,250,31,0,237,212,143,81,206,122,129,167,255,220,7,189,115,156,36,16,81,182,247,13,110,42,141,37,21,119,213,11,108,160,154,78,76,27,249,214,106,106,242,65,66,150,117,253,238,225,93,219,121,30,105,54,149,110,225,130,130,106,210,56,68,58,165,144,163,30,80,39,205,44,85,78,139,234,92,143,238,32,122,95,84,114,252,210,4,75,189,80,46,101,249,132,139,211,46,168,206,5,28,168,205,39,88,84,171,249,59,8,24,34,74,69,228,174,149,29,75,157,185,252,26,213,75,69,157,158,70,210,151,31,163,127,175,215,95,52,68,152,236,156,64,150,186,179,244,103,63,94,250,240,243,184,141,74,224,191,17,136,57,77,247,4,22,151,241,29,3,113,235,45,108,156,148,152,69,132,136,218,127,115,133,202,174,169,202,34,23,90,159,224,65,233,21,101,85,58,174,249,252,187,39,234,90,129,63,30,144,72,229,78,109,242,174,31,95,174,199,10,214,106,44,61,208,166,33,137,55,76,181,36,72,74,166,206,218,119,248,31,243,58,227,194,211,252,95,0,36,106,228,236,223,73,40,9,121,48,80,76,197,166,91,128,70,86,6,119,212,184,48,39,234,137,119,51,59,64,104,65,167,73,45,244,205,132,230,199,218,34,241,34,35,101,58,196,83,140,80,102,52,130,172,149,108,127,166,15,44,119,77,100,65,72,108,93,94,181,45,13,85,108,192,144,5,110,126,13,36,26,225,73,192,126,9,207,56,207,209,157,83,174,152,47,65,16,250,57,9,160,160,170,23,223,196,156,202,31,91,8,78,51,215,76,79,10,115,14,83,29,195,200,141,150,139,166,4,155,215,43,53,21,98,231,144,127,49,2,142,73,6,97,162,212,60,208,6,104,3,150,152,207,55,86,15,80,187,227,209,202,95,39,228,235,156,112,254,114,37,54,161,181,174,205,106,33,239,122,99,166,87,51,253,145,130,139,10,115,135,61,35,250,73,185,250,193,161,56,143,93,95,142,196,214,103,228,201,254,133,59,16,205,233,156,38,242,147,100,25,68,236,95,16,63,130,111,251,77,231,166,197,213,144,238,189,69,103,180,151,196,53,234,71,57,44,51,169,87,201,139,97,17,190,219,145,169,225,192,46,136,218,232,173,109,239,249,47,207,95,149,143,67,240,100,54,49,42,169,26,207,128,21,65,241,101,137,141,101,179,185,21,35,65,19,125,70,183,251,238,240,231,0,42,246,30,239,185,241,248,123,211,176,98,172,88,56,250,191,51,143,191,8,83,5,60,85,207,100,107,136,94,134,78,107,219,55,149,119,128,245,184,110,151,174,74,60,119,64,131,236,151,37,207,133,29,165,243,194,191,17,217,85,12,67,5,200,0,159,28,183,150,233,48,8,203,19,180,164,92,202,13,28,187,14,224,218,12,203,112,218,4,226,214,214,84,46,166,85,133,176,233,202,22,159,38,151,116,97,124,74,6,90,127,75,65,249,227,28,238,18,105,102,104,225,246,32,157,144,53,47,93,94,53,236,18,141,4,92,55,150,192,121,30,145,37,88,57,164,49,240,249,153,197,236,124,172,157,209,192,179,83,14,28,163,150,83,189,28,59,13,234,66,140,167,25,95,52,35,113,154,159,96,189,64,138,26,104,177,90,57,41,183,190,126,116,143,33,38,219,142,184,255,4,128,35,67,34,217,191,130,101,153,176,15,136,178,234,64,253,57,81,9,183,170,215,220,67,112,231,135,204,233,198,237,112,87,157,153,246,131,135,0,167,131,253,106,96,149,246,138,119,20,18,167,135,93,206,9,94,132,200,109,199,95,230,5,23,146,10,216,202,217,54,76,223,79,1,246,233,196,120,233,205,132,206,15,96,209,107,218,25,221,63,123,179,54,39,133,131,236,109,254,247,154,196,255,216,162,131,157,124,61,108,67,25,62,209,247,16,124,247,70,76,7,197,106,105,53,104,150,220,251,109,166,110,164,95,207,67,178,58,68,202,48,76,147,33,166,69,31,33,113,25,0,164,177,51,25,47,221,123,204,161,200,240,132,160,88,35,119,61,29,4,252,200,115,99,157,28,13,42,112,195,18,73,234,32,64,206,168,225,11,78,202,118,11,149,214,230,53,207,51,112,167,175,192,0,64,32,173,248,0,16,181,15,24,43,54,213,36,43,194,254,85,74,199,108,176,170,210,177,91,231,64,55,12,46,227,184,25,146,182,132,160,49,153,43,75,82,145,14,190,249,123,38,13,35,104,81,169,105,9,74,252,140,158,14,233,70,249,30,245,61,136,16,36,73,211,11,43,238,117,40,65,26,163,136,8,102,151,114,152,92,118,197,6,216,121,28,38,196,63,63,7,61,119,215,93,106,18,77,145,97,69,27,181,169,229,39,173,123,120,48,119,118,50,212,143,166,0,11,68,190,218,236,147,28,140,29,141,226,7,50,15,38,92,106,124,105,1,73,37,40,202,115,104,237,62,106,228,20,126,30,132,178,90,89,245,246,207,112,122,78,37,126,167,22,58,65,99,106,51,175,98,27,28,99,116,182,221,5,228,120,146,56,17,233,82,10,176,79,213,1,124,115,143,131,172,92,225,150,164,34,3,64,89,240,213,149,153,38,32,249,77,131,157,154,19,233,105,236,217,228,199,137,46,204,217,112,126,146,229,87,151,130,234,240,168,243,225,63,133,159,114,83,117,245,56,185,105,252,253,91,3,128,189,78,211,62,65,222,44,241,135,97,247,23,232,104,71,118,26,226,237,14,79,50,173,124,59,198,0,27,140,100,123,168,71,117,104,0,236,200,103,156,74,92,162,119,135,211,93,139,58,53,84,221,51,222,192,12,114,244,96,60,90,202,25,97,71,219,93,5,53,225,168,123,0,185,140,131,76,211,41,84,84,169,109,235,28,59,2,199,201,81,198,46,46,246,5,31,48,144,93,222,149,64,54,210,63,26,20,238,98,203,8,183,177,24,149,125,223,65,68,223,203,204,202,196,31,77,103,238,214,31,195,221,44,63,128,248,236,64,203,142,178,207,31,245,112,7,138,207,179,239,3,165,36,176,205,140,230,83,49,143,56,83,254,207,116,211,222,229,103,188,212,184,113,88,60,190,221,119,104,227,107,248,226,170,75,93,80,33,80,84,50,5,185,175,93,230,239,191,207,63,110,43,176,118,226,82,146,172,189,84,173,168,80,25,75,99,103,163,103,191,157,55,86,86,123,120,216,42,242,231,114,21,67,10,43,216,151,158,136,113,127,67,61,4,164,111,246,72,99,153,131,213,167,0,39,114,204,207,68,28,238,12,20,172,26,15,220,155,173,137,200,244,178,101,236,131,66,155,211,156,132,3,236,135,201,118,236,76,207,174,57,11,245,102,60,61,9,251,63,43,124,150,29,130,183,148,120,250,45,127,46,197,182,164,233,119,251,226,119,175,190,129,138,159,151,251,108,190,137,5,54,138,24,228,150,205,166,122,35,158,39,243,186,217,143,251,196,101,189,42,146,242,156,134,166,44,250,235,176,163,22,247,59,56,106,181,185,110,165,193,166,200,229,220,42,25,91,36,101,138,232,90,175,121,99,81,161,65,119,230,72,219,190,226,168,181,18,246,84,74,227,252,167,112,203,3,119,166,59,57,119,222,0,40,189,99,236,38,170,84,10,128,142,109,14,64,98,15,11,83,130,202,218,111,228,236,199,89,179,41,210,124,247,51,145,163,112,7,214,113,95,1,64,171,19,14,66,133,95,54,82,161,153,202,149,202,253,240,19,52,18,71,140,65,25,154,77,192,77,160,190,131,192,164,230,121,15,195,241,145,229,112,2,126,86,140,194,73,108,125,40,96,177,1,204,152,93,14,54,77,154,193,104,236,36,82,98,143,193,117,5,32,109,154,34,43,192,255,220,132,180,250,86,41,37,105,61,50,98,244,122,177,0,93,220,121,201,95,167,95,241,125,168,19,157,103,71,226,198,185,20,247,41,3,84,49,211,185,46,82,40,155,66,10,34,252,216,64,48,4,57,198,208,111,50,36,56,199,26,220,214,113,7,19,115,248,27,182,154,74,11,215,155,43,191,14,72,215,142,127,76,60,61,164,90,187,192,181,125,89,114,251,164,85,107,214,125,188,235,239,147,54,159,206,91,70,37,70,14,132,166,23,255,180,39,64,142,37,126,70,10,135,116,113,248,217,170,185,137,134,87,201,11,51,172,45,153,107,45,183,149,32,200,218,10,152,252,164,101,146,184,8,0,77,11,25,245,234,121,244,55,193,179,53,77,71,21,223,111,162,247,61,106,23,144,238,204,72,43,164,245,99,128,174,215,201,214,237,102,15,52,57,196,134,188,225,203,163,66,240,62,120,211,183,217,122,255,94,11,54,25,8,5,112,227,201,119,87,136,226,142,204,208,52,5,37,212,215,242,62,236,79,70,204,105,227,108,36,159,245,51,237,121,128,169,41,66,50,174,48,75,22,37,240,92,210,19,243,194,223,51,195,208,161,129,194,47,26,157,95,2,124,172,88,5,204,56,109,7,27,176,159,202,79,121,192,35,144,124,206,172,125,137,139,88,54,192,230,173,1,28,127,11,99,63,19,108,47,251,116,160,38,89,19,95,25,209,74,157,168,68,26,123,93,221,104,143,54,110,112,117,108,31,244,126,60,235,143,106,182,53,60,134,151,184,225,26,133,148,185,31,253,112,164,96,1,82,54,2,35,167,120,134,130,213,139,67,9,93,131,31,110,242,198,129,199,100,109,105,46,25,26,92,1,153,94,117,169,172,31,198,110,140,219,62,72,103,31,96,157,20,223,8,146,175,16,213,70,67,35,107,142,107,19,161,182,110,233,108,121,18,100,228,204,165,107,100,233,51,84,250,157,15,118,12,83,74,4,45,163,137,112,32,25,70,20,11,119,204,124,24,210,139,237,152,154,177,172,64,9,216,168,146,94,39,111,103,95,196,104,46,194,40,29,140,212,186,252,193,113,134,61,254,16,6,147,17,46,144,182,124,91,82,134,118,76,76,25,79,35,82,33,214,233,170,45,230,114,179,107,66,149,252,43,7,136,63,168,137,125,108,203,223,67,50,163,165,123,15,187,133,151,15,136,25,144,39,255,141,71,9,144,65,16,109,43,150,156,73,233,7,190,97,213,148,140,170,10,254,135,123,46,48,223,48,47,243,103,66,14,47,11,93,14,237,197,201,219,132,91,0,132,244,108,103,253,139,53,65,122,221,189,168,65,104,208,251,104,244,197,171,87,185,168,143,38,200,246,77,157,179,6,134,228,49,122,86,17,227,229,100,240,69,167,193,223,202,204,162,240,10,234,188,219,190,217,182,123,94,69,229,202,153,115,206,193,55,37,6,193,151,16,59,141,24,149,200,130,219,119,20,17,13,1,196,136,123,101,201,121,177,239,25,39,49,117,60,106,220,99,114,222,246,28,56,84,187,34,162,107,125,192,161,186,209,175,231,54,248,84,85,11,0,95,196,113,198,38,125,192,243,243,203,36,41,227,167,148,167,252,137,44,26,93,123,180,242,17,215,39,11,60,126,21,125,162,5,24,19,170,254,68,176,30,147,13,67,189,167,39,184,150,244,251,34,206,136,40,24,73,193,6,220,111,224,38,145,176,239,13,87,68,35,62,203,174,191,18,127,74,17,143,160,173,226,10,116,38,91,18,0,114,52,197,189,151,72,7,58,245,175,229,185,50,190,204,145,50,152,120,9,17,43,197,77,137,45,4,77,54,253,44,103,98,216,147,77,31,186,16,104,157,177,149,43,189,187,195,153,228,188,191,136,144,133,222,250,99,21,114,117,60,162,239,238,250,29,50,204,5,186,197,132,74,123,57,229,18,76,122,233,94,109,251,90,209,73,44,90,86,250,62,93,249,71,2,74,125,98,108,39,225,112,10,246,214,146,144,186,78,13,161,228,159,85,148,28,255,26,60,244,72,116,53,249,123,60,35,248,138,71,101,242,116,164,67,4,247,137,178,178,123,4,148,176,210,250,147,175,175,239,4,164,209,93,36,197,210,68,50,209,214,214,36,89,50,129,91,248,136,38,142,111,157,135,40,188,81,19,91,140,250,185,139,160,34,31,75,15,10,147,46,240,166,35,50,25,21,42,6,254,11,35,15,124,175,228,204,196,181,45,81,63,10,153,113,130,11,92,181,136,171,137,129,249,44,25,74,234,44,160,111,153,144,103,225,243,176,101,235,133,222,147,145,30,185,213,205,125,28,161,118,168,19,243,103,189,126,148,186,29,254,222,182,164,240,147,96,47,219,211,192,208,180,237,155,223,189,33,236,173,225,225,156,240,105,198,14,153,106,229,206,137,174,135,66,197,229,80,83,213,127,51,1,41,170,38,167,115,56,58,10,5,78,112,64,68,136,58,184,106,74,81,222,86,198,43,138,126,232,179,141,225,206,67,89,241,239,154,149,107,91,202,0,0,18,116,240,73,152,218,204,128,67,143,11,35,199,82,106,175,20,140,182,16,1,1,9,97,144,247,155,175,131,105,142,128,239,83,198,207,103,11,5,34,46,236,246,196,56,228,123,208,233,210,198,148,28,98,104,4,44,250,75,132,228,38,235,174,232,150,25,198,240,54,3,218,228,161,228,15,129,236,130,141,198,253,221,234,246,95,54,104,158,165,185,121,107,124,94,225,96,235,167,226,85,2,226,65,35,20,135,12,66,231,162,189,20,90,43,173,184,120,188,231,29,61,53,217,241,234,66,235,141,37,16,211,135,223,91,184,211,134,99,75,115,154,49,99,126,26,149,203,242,39,154,39,163,23,153,38,181,137,96,13,90,61,130,247,215,32,191,0,92,184,37,188,104,152,156,112,155,224,199,96,93,249,74,31,63,248,223,162,248,36,205,67,185,146,120,160,5,236,31,133,216,133,65,24,173,219,215,213,34,79,187,117,27,102,193,225,199,151,194,29,198,144,2,234,118,151,40,166,190,96,58,40,147,238,171,129,154,117,137,21,228,175,158,148,227,140,64,101,217,220,205,202,116,226,171,63,240,125,194,22,144,14,29,47,205,247,222,115,110,163,27,165,67,159,23,41,74,229,217,169,137,253,158,35,193,164,25,227,249,10,94,38,235,157,211,110,173,74,177,34,169,202,38,216,249,116,35,205,136,215,94,83,196,241,46,240,59,164,97,223,45,134,143,252,190,111,113,241,108,218,167,175,82,151,19,254,232,212,245,172,116,138,93,35,69,135,163,197,183,202,216,207,116,242,141,211,44,201,202,192,8,126,184,201,15,38,49,51,233,114,69,202,150,185,201,154,31,165,137,201,12,73,17,108,204,158,133,235,158,234,135,249,55,79,67,25,216,162,50,235,75,201,247,214,222,244,50,63,134,56,208,104,136,69,52,11,131,10,201,185,188,244,156,103,248,141,98,191,248,252,34,33,53,167,40,184,177,64,161,76,168,175,17,124,50,84,21,162,250,47,242,158,45,64,53,252,176,65,19,13,28,148,53,30,112,174,118,33,212,135,3,219,241,185,17,68,15,37,3,82,242,3,145,140,10,240,47,92,196,57,106,14,123,87,19,94,133,200,199,173,104,129,254,98,237,116,142,102,27,98,255,146,162,105,142,189,135,190,140,1,153,22,87,225,169,40,149,40,254,136,249,99,157,78,198,28,125,18,110,155,255,248,88,42,169,154,32,154,207,41,185,104,93,9,121,20,57,246,6,37,57,112,126,82,39,217,84,209,190,242,78,200,179,237,18,46,106,209,219,40,52,215,70,211,101,84,10,112,25,217,81,147,254,156,117,31,181,160,38,1,74,147,25,235,89,212,118,151,160,155,89,121,85,254,223,139,86,50,74,74,236,240,82,142,177,56,28,122,50,40,233,172,99,215,106,94,165,144,187,84,168,209,6,141,23,252,237,76,86,255,175,174,128,218,174,79,170,205,228,232,92,213,148,66,145,105,79,149,106,84,60,148,230,248,43,203,36,231,11,154,190,156,29,64,218,231,140,119,164,85,42,15,9,228,76,131,31,229,41,229,62,153,50,75,77,21,90,5,227,65,235,69,30,178,227,47,129,233,62,125,92,12,238,8,136,73,237,247,237,250,134,2,114,123,11,124,128,127,188,175,98,168,180,88,242,106,120,248,236,54,18,67,153,83,169,53,217,66,24,225,219,40,157,56,206,80,157,68,13,157,6,69,235,39,60,231,0,250,68,49,5,241,18,23,61,28,44,203,27,17,23,177,132,119,76,227,94,22,36,208,158,64,73,217,107,205,210,215,170,110,7,173,33,198,105,192,242,166,131,94,117,116,22,157,131,204,250,111,252,89,22,219,153,27,82,16,253,143,200,221,222,101,86,68,170,196,203,34,193,230,129,66,58,46,134,101,247,103,180,235,158,59,236,33,44,84,120,85,238,162,0,119,75,193,135,57,193,225,229,252,241,202,29,87,1,252,219,242,6,42,121,63,239,159,42,149,41,236,67,231,27,111,132,186,245,191,32,208,165,236,146,220,211,165,135,255,226,106,200,135,209,208,132,219,40,250,83,51,176,185,12,23,132,224,9,138,243,202,27,248,120,236,217,162,11,184,161,209,140,223,238,188,7,225,45,92,120,33,226,104,184,217,94,117,102,212,240,102,173,21,56,239,243,143,140,50,176,52,225,236,169,88,9,196,244,46,232,121,32,179,66,96,195,62,2,127,197,180,223,72,179,33,178,60,182,113,111,234,254,148,83,75,228,187,123,130,108,235,145,238,203,52,9,135,90,45,86,32,204,227,127,255,22,81,216,121,73,209,46,161,27,241,77,245,13,68,13,182,230,97,10,201,223,28,9,166,238,195,91,197,106,76,233,41,241,47,84,228,127,172,10,10,40,161,132,250,188,207,103,182,105,134,233,195,115,200,246,138,179,237,157,203,205,58,92,19,144,212,76,80,179,81,80,240,174,226,131,224,141,175,148,160,20,244,120,39,176,180,47,78,244,95,170,145,98,64,201,77,108,91,197,211,206,71,93,80,211,187,49,92,7,176,141,163,12,72,53,22,140,101,85,167,149,60,238,95,191,193,78,210,71,92,38,158,54,41,176,45,157,121,226,72,120,254,255,209,116,73,247,226,232,43,123,115,216,69,194,66,166,126,69,126,144,82,206,113,155,175,92,47,103,195,57,216,200,80,79,204,95,1,211,185,108,59,199,170,182,143,38,101,146,9,157,195,49,129,23,247,121,211,190,107,56,173,0,28,147,140,63,92,147,147,199,82,121,46,236,150,55,147,160,165,5,124,7,154,43,140,34,131,176,215,158,61,144,195,156,176,145,207,95,56,237,139,245,222,79,87,168,95,12,137,56,158,174,123,51,34,191,34,223,40,116,170,223,92,116,196,202,26,64,92,146,57,76,252,101,50,87,142,215,69,185,196,17,60,35,209,34,108,242,128,25,29,143,45,96,93,246,76,65,217,148,206,36,161,230,179,20,176,198,44,31,103,62,115,173,247,216,218,63,253,250,204,251,179,59,83,207,251,131,161,138,160,98,95,179,69,133,98,142,75,122,91,209,33,79,214,65,172,163,250,199,19,66,188,213,194,213,155,166,229,125,202,167,32,103,141,164,3,128,113,138,148,185,81,209,213,31,147,119,37,190,242,27,237,129,19,188,102,126,245,152,212,207,200,203,62,156,220,127,78,238,228,239,63,174,192,121,162,136,66,22,243,185,74,48,163,232,74,204,52,252,70,229,44,42,184,226,208,121,81,226,190,196,3,239,19,212,96,133,75,39,172,126,60,81,77,119,59,45,158,95,6,128,109,27,254,182,147,96,11,5,70,29,3,112,221,206,14,111,78,198,253,127,233,85,89,251,106,196,21,66,167,82,220,69,102,205,224,144,229,83,153,40,173,19,146,234,1,173,174,13,166,48,147,58,46,32,163,31,38,108,45,237,149,23,15,155,163,135,28,98,45,151,63,242,153,28,100,178,88,60,8,35,9,117,92,181,119,164,177,140,191,132,164,158,177,169,200,74,248,216,175,154,218,105,113,123,10,75,51,27,50,14,42,232,239,29,170,72,252,236,229,37,238,61,213,50,73,32,196,9,46,78,246,156,100,28,206,55,158,99,213,80,73,35,33,237,229,91,159,249,237,95,137,93,67,132,219,24,48,156,213,205,238,5,28,248,59,44,139,56,178,150,242,36,129,164,17,115,4,144,94,246,220,20,128,38,79,237,208,191,32,183,150,150,198,227,109,196,47,154,110,161,211,37,169,206,163,235,215,88,225,40,134,10,121,165,126,102,246,176,175,243,58,66,30,223,70,169,123,64,110,58,46,17,79,78,7,9,3,79,10,228,1,84,80,87,253,134,211,59,69,218,70,98,60,36,41,107,107,106,160,109,70,135,39,66,125,19,161,239,221,5,61,194,22,187,127,95,113,69,2,119,9,144,230,237,130,14,16,174,101,245,69,214,167,16,56,97,190,181,8,237,253,19,79,244,76,178,70,69,50,59,190,157,121,24,173,66,88,236,111,220,98,57,187,163,254,71,247,219,242,227,216,89,242,209,237,76,208,28,100,71,20,180,204,121,195,206,173,191,95,205,228,1,198,82,217,230,153,192,99,126,255,199,150,105,246,242,132,62,20,85,11,220,13,224,85,66,42,237,150,49,0,7,74,13,208,43,222,75,109,95,2,235,218,35,93,168,248,70,141,74,46,14,208,17,225,208,153,210,62,53,142,178,239,13,89,150,111,7,144,64,75,190,96,146,238,61,240,156,242,15,26,123,75,138,94,66,34,3,32,232,228,88,148,240,59,90,46,119,53,123,224,86,181,36,170,224,241,100,220,195,6,3,199,53,245,14,253,47,0,205,146,127,85,38,20,44,125,202,68,166,51,105,40,69,97,224,234,32,17,45,32,165,49,186,4,105,137,56,0,254,204,252,27,44,221,44,102,70,229,234,167,184,140,147,80,233,238,230,94,231,92,40,196,38,157,97,47,42,44,101,108,187,150,223,42,115,194,147,108,134,52,193,103,68,175,192,115,31,152,149,207,64,3,32,135,153,134,178,75,197,73,57,143,114,25,87,102,250,85,200,50,182,45,26,79,144,136,249,176,61,63,205,248,218,77,165,251,71,33,4,183,80,247,247,3,247,107,66,253,60,61,103,248,183,112,121,26,160,29,5,214,226,141,154,199,5,158,1,64,70,102,206,204,100,10,2,238,249,126,39,218,192,156,173,114,191,246,159,158,162,160,105,118,17,136,160,138,197,101,56,77,111,156,198,217,145,177,199,228,107,74,7,26,31,111,27,141,123,102,72,230,187,160,191,173,148,83,117,47,205,193,158,245,110,171,188,184,108,87,89,158,171,126,70,54,115,106,21,221,145,244,33,28,176,241,117,164,64,200,45,22,78,147,229,176,66,127,27,135,139,157,234,148,120,237,35,215,111,171,147,163,148,205,197,165,57,183,234,82,181,241,39,15,83,140,68,255,67,40,57,80,200,199,89,192,180,0,146,33,1,84,225,172,207,25,10,197,214,153,166,92,231,130,1,207,124,142,50,234,126,196,181,55,176,43,230,32,247,174,2,142,25,103,238,163,219,88,67,52,182,123,166,241,28,166,180,67,70,117,31,191,26,189,234,117,130,218,131,69,42,22,252,120,18,226,29,94,187,97,67,113,36,178,47,84,116,13,15,166,185,102,234,88,188,173,41,40,28,159,201,102,178,151,99,114,131,186,24,102,136,13,67,126,190,208,126,0,149,227,152,134,96,63,189,122,91,183,231,100,172,222,162,77,105,117,255,86,251,212,1,85,109,59,1,56,54,206,147,69,35,75,43,244,148,211,211,113,28,104,45,3,210,70,192,102,129,60,8,24,128,250,161,175,101,28,230,148,54,238,182,216,15,178,76,73,153,238,155,31,219,118,149,168,208,231,202,185,28,205,68,87,233,165,22,218,113,80,16,13,215,198,8,205,19,18,44,131,156,67,117,148,24,167,35,186,170,146,102,172,21,62,230,121,60,94,53,217,158,173,232,246,111,159,124,235,48,170,207,112,34,148,84,241,48,135,225,128,225,120,192,21,9,184,207,61,12,146,78,38,118,102,105,21,31,72,220,254,161,141,29,61,196,149,211,39,87,169,66,213,116,108,188,217,118,183,160,90,232,127,196,86,220,191,235,238,200,161,193,104,208,242,245,217,253,166,80,246,170,119,139,177,83,72,95,44,62,110,121,56,18,78,131,43,165,253,131,80,191,204,82,255,34,74,139,16,113,197,73,153,128,45,132,5,81,59,145,134,35,211,161,199,201,210,76,70,217,176,154,214,79,88,104,34,133,112,233,128,228,229,60,107,21,17,246,64,12,199,55,69,14,248,222,21,222,214,187,9,79,83,13,87,69,40,56,83,89,101,45,4,60,243,115,251,173,242,36,10,0,147,97,225,29,80,231,253,241,1,121,142,210,19,137,16,60,108,198,168,137,138,87,150,25,73,197,105,19,220,176,163,34,28,32,18,219,236,178,215,197,104,135,104,114,86,171,245,186,0,27,66,45,37,31,177,92,191,37,69,200,17,16,80,218,150,103,54,158,114,24,31,169,154,111,162,31,143,1,223,87,172,191,85,60,26,221,30,111,181,159,2,124,169,140,65,90,186,85,160,247,49,24,54,196,79,97,54,142,58,29,173,237,63,34,166,16,242,136,8,22,207,179,185,66,180,175,244,71,55,150,207,89,138,132,92,10,138,172,42,159,77,122,11,123,160,242,216,157,227,249,58,118,135,236,152,233,239,206,150,213,192,176,130,240,53,234,83,168,55,61,89,151,98,209,215,188,249,48,121,244,246,178,128,236,133,41,215,41,246,185,48,243,118,215,189,224,12,133,44,203,194,107,149,194,52,217,35,132,56,217,142,243,252,93,1,208,54,101,30,58,187,239,176,124,75,28,106,108,197,114,27,20,153,40,96,116,24,212,73,55,146,112,48,4,210,75,27,247,44,83,174,199,136,30,6,148,231,79,139,189,250,156,75,232,61,11,75,138,198,24,116,115,42,149,74,65,115,87,23,156,183,142,108,71,195,103,71,148,198,213,149,101,63,89,138,189,61,115,84,232,41,182,230,238,95,141,165,97,116,137,96,81,60,118,240,212,38,201,57,92,177,31,184,86,101,239,59,122,252,162,209,176,1,161,99,179,12,139,208,225,51,119,187,204,89,202,139,180,190,3,62,103,31,154,40,135,53,121,93,49,192,137,20,190,201,241,59,112,38,35,69,2,182,226,112,21,207,8,173,138,172,163,119,174,213,91,51,110,92,206,238,239,170,201,174,125,151,74,19,26,225,107,199,153,5,96,20,134,231,12,63,35,238,110,5,201,118,20,102,153,202,204,86,148,24,59,51,32,204,55,66,76,30,118,174,19,210,50,217,52,141,208,188,160,5,16,121,224,130,25,255,78,55,172,145,118,239,100,222,253,160,160,56,181,25,107,16,53,117,117,32,253,216,75,170,208,19,128,128,250,229,216,177,151,102,177,144,230,43,124,82,15,159,43,247,0,148,247,189,76,91,0,42,5,28,225,249,207,51,222,238,186,27,61,146,22,228,101,21,185,97,7,130,177,64,1,57,184,196,171,153,212,13,140,88,141,220,202,132,86,12,178,156,75,242,243,78,4,123,49,228,191,116,111,144,92,212,216,128,146,221,16,48,29,177,157,217,67,52,150,146,9,104,56,54,136,35,192,155,11,174,94,136,252,0,18,148,81,170,203,87,145,58,179,170,188,109,2,191,69,148,196,156,8,97,8,129,7,201,111,177,62,82,55,107,113,228,89,126,232,209,251,107,9,104,111,31,47,131,23,17,217,207,153,125,71,155,140,182,127,94,154,212,132,168,174,179,19,43,243,13,6,113,221,52,82,157,174,198,21,59,219,96,9,254,148,40,172,184,253,205,44,84,145,234,221,37,26,91,66,67,19,163,132,0,16,120,104,185,157,16,121,94,205,249,18,20,124,223,117,69,36,0,154,132,217,83,148,137,181,105,151,160,112,42,199,23,249,46,34,78,149,32,105,50,51,248,44,52,140,3,56,242,16,245,219,109,217,205,209,50,206,232,187,29,244,193,177,157,249,241,162,158,193,41,173,81,206,144,204,166,107,207,28,35,88,234,28,84,246,98,124,48,2,235,52,155,234,17,198,211,43,92,255,147,236,246,152,49,20,88,37,65,228,222,80,124,101,82,32,207,75,102,140,205,44,21,193,199,16,75,116,200,131,74,52,225,202,43,207,65,201,35,17,18,121,116,201,138,180,49,177,254,58,56,110,76,245,79,36,97,6,42,96,62,239,112,51,200,47,238,54,42,222,145,57,137,244,31,98,164,96,208,149,139,254,229,5,162,110,252,193,115,167,233,156,69,43,210,17,82,145,109,185,80,143,156,111,103,131,36,53,88,204,116,226,138,47,207,36,184,196,231,203,127,165,227,168,95,191,166,215,101,195,192,185,103,137,208,55,79,106,224,239,209,41,130,3,23,89,108,186,213,151,230,145,91,39,175,80,214,215,126,254,40,113,227,22,178,59,5,129,98,242,169,129,183,123,124,171,100,93,50,44,112,34,215,198,130,69,116,43,251,177,133,141,158,26,114,130,252,126,50,1,191,44,86,236,168,186,64,95,108,52,124,28,136,141,88,247,22,43,111,12,126,34,158,206,10,113,102,80,197,234,202,185,44,80,100,180,195,18,103,91,240,92,240,222,143,225,100,182,10,55,251,31,117,250,172,34,136,211,150,253,91,4,135,15,112,214,22,242,42,74,196,209,71,37,144,126,38,117,91,202,63,18,154,126,15,57,142,206,123,31,189,125,117,3,137,16,147,249,183,44,145,42,79,107,249,230,218,195,124,127,54,165,233,155,154,129,153,31,81,236,226,159,77,53,113,221,128,72,158,239,76,2,188,213,54,233,44,151,177,129,16,50,150,160,108,224,223,139,127,17,145,35,132,184,93,91,86,212,104,188,58,213,143,33,85,190,207,211,16,240,203,141,128,224,101,123,204,57,80,67,164,98,49,226,133,11,157,226,247,118,194,90,79,39,34,48,29,25,160,197,234,43,21,239,201,53,172,193,222,248,142,180,87,2,42,168,229,74,85,218,175,49,249,154,246,51,252,93,187,159,193,43,229,219,36,222,195,23,173,74,167,188,144,107,53,195,25,246,161,94,152,42,204,177,139,58,73,210,80,47,146,43,85,241,34,220,152,181,240,254,140,70,158,170,139,93,66,192,124,5,247,160,29,225,242,131,68,4,127,86,37,240,232,130,215,193,32,43,125,176,80,222,94,112,91,28,155,94,37,172,139,83,111,155,182,229,35,20,147,112,123,129,144,83,100,113,100,187,173,255,159,27,98,186,236,53,226,162,106,51,127,177,115,24,247,0,192,230,30,202,221,51,150,208,237,29,29,132,234,59,225,11,230,123,65,5,211,123,119,35,134,10,7,98,137,184,145,102,226,213,171,230,190,191,47,246,155,145,32,108,145,81,146,219,208,47,44,139,144,192,123,175,109,228,38,152,73,116,118,16,140,208,13,158,252,47,118,99,74,226,214,110,40,111,178,90,24,99,120,88,223,18,139,53,193,138,203,133,158,91,232,84,201,16,218,28,44,171,71,67,152,49,198,155,215,204,241,232,24,92,54,91,128,118,171,123,13,95,179,171,21,11,255,215,28,136,220,12,91,246,139,208,155,150,195,176,56,238,221,153,147,64,121,101,220,213,34,205,149,29,134,183,2,174,13,79,27,45,153,26,55,66,48,217,116,88,97,174,203,70,140,111,103,109,157,45,228,240,194,99,178,113,132,37,203,211,154,236,208,195,68,123,175,10,126,249,158,81,82,244,228,163,12,197,123,156,112,9,33,10,9,197,80,137,110,14,10,255,191,245,38,235,197,14,191,101,222,238,50,6,0,63,48,10,226,102,43,187,103,238,215,64,178,199,86,150,182,123,196,165,0,34,166,13,206,235,157,174,91,191,138,1,133,83,47,166,218,76,8,76,106,153,113,67,21,247,147,98,159,215,126,123,25,212,147,98,54,252,44,110,229,106,165,192,45,191,125,0,158,204,177,214,233,8,21,127,246,163,135,252,160,175,75,115,204,13,17,211,188,108,79,104,213,147,241,241,197,184,13,149,127,18,102,82,164,174,7,249,241,94,27,17,165,155,225,113,132,27,91,46,4,39,139,142,251,25,139,16,20,245,51,3,92,189,74,156,154,91,42,97,134,161,225,178,50,37,156,20,78,248,23,142,106,211,120,80,75,112,22,218,94,46,125,134,150,104,54,107,165,166,88,138,178,116,235,22,106,15,88,231,158,90,40,39,53,133,51,204,138,94,168,208,168,84,156,248,150,108,42,99,40,215,108,51,63,173,111,32,150,235,96,70,148,80,208,155,127,22,19,79,195,2,90,34,14,127,106,247,148,215,95,164,18,192,95,151,172,23,119,73,29,185,57,203,165,174,117,241,156,188,20,237,80,251,172,26,168,8,31,33,81,143,100,41,56,207,24,29,27,73,230,89,240,70,28,140,45,119,195,197,57,40,76,172,207,64,206,120,50,196,15,107,18,42,34,122,150,240,153,59,112,187,118,100,120,28,147,51,94,199,241,60,108,1,196,52,4,118,251,42,91,10,203,133,125,83,93,68,186,132,55,18,170,171,211,91,123,152,146,255,103,70,237,207,206,68,22,169,6,28,113,238,224,62,147,34,134,237,250,121,170,184,110,17,216,222,73,138,246,120,252,57,111,91,35,139,67,175,171,160,1,161,63,133,6,118,2,219,248,76,29,206,16,10,227,234,16,112,173,145,230,113,146,210,6,109,143,88,65,73,31,33,48,209,189,237,58,254,61,206,23,228,179,178,223,54,120,37,74,19,72,192,152,193,163,224,77,17,147,149,224,75,33,209,149,47,117,71,29,32,25,231,202,160,228,178,96,174,187,57,79,110,74,129,124,105,248,112,182,102,231,9,185,134,99,211,214,34,196,156,238,167,98,81,202,252,51,164,242,23,19,87,182,47,151,197,244,153,43,187,152,199,242,242,5,145,245,181,197,245,31,72,175,93,166,77,117,43,178,230,244,124,113,202,87,8,182,2,1,90,151,4,157,192,185,21,204,213,75,81,145,217,167,20,22,222,102,59,156,77,60,50,47,173,52,159,129,157,168,24,197,126,26,50,234,201,74,73,115,241,145,240,255,96,116,191,203,45,50,85,49,249,150,241,15,184,173,142,7,248,60,166,14,78,67,234,240,250,130,76,168,14,51,253,193,228,225,246,185,227,164,137,139,211,80,160,253,158,62,146,188,97,22,15,243,54,33,69,93,30,177,184,27,75,123,205,123,231,160,13,210,43,76,131,184,175,166,213,28,43,206,159,118,163,133,140,2,199,97,2,44,92,13,237,41,66,0,144,134,14,52,103,120,208,109,138,80,26,40,231,187,25,35,22,70,22,119,234,32,215,158,65,210,117,197,176,48,111,206,3,204,32,247,150,213,137,25,249,99,97,178,83,5,6,73,158,144,161,96,192,17,190,71,245,194,168,167,3,162,254,241,246,121,147,9,65,1,6,155,95,238,234,114,120,57,124,199,47,173,106,110,73,195,240,254,12,234,129,163,240,199,197,101,116,184,47,93,82,63,98,171,111,67,33,211,161,232,215,173,152,189,181,89,130,215,239,4,147,111,199,205,174,153,171,237,92,106,250,57,131,11,41,12,48,179,86,243,21,139,9,169,247,235,72,236,177,157,253,65,24,220,144,158,18,116,205,167,39,21,18,104,26,56,171,14,209,101,241,31,145,50,76,223,213,136,167,229,156,66,24,162,88,227,48,243,224,86,20,132,54,94,135,98,53,214,198,122,101,242,91,159,212,252,131,85,102,215,99,142,201,233,36,58,103,75,214,240,133,252,72,2,49,44,125,159,205,227,104,14,119,41,199,124,94,204,18,191,58,181,249,119,155,132,200,125,84,60,234,145,0,210,124,76,80,128,27,32,195,112,84,68,226,69,132,181,245,220,237,133,218,15,188,181,223,243,16,31,167,125,121,105,104,7,253,186,184,142,62,102,202,203,74,47,117,155,8,97,247,105,194,46,45,120,157,204,142,200,119,159,36,100,81,116,179,62,26,227,219,42,91,153,71,73,63,225,78,135,221,73,39,79,169,226,41,98,250,213,162,73,3,145,9,134,221,60,246,33,48,6,31,99,169,118,1,250,41,179,46,26,165,85,126,94,163,222,210,156,178,107,132,122,52,193,229,139,23,21,136,89,189,148,105,86,66,53,230,67,13,52,34,236,232,128,215,110,122,101,77,47,27,199,141,244,176,188,174,244,161,236,163,166,39,203,182,23,191,165,225,101,62,30,154,9,125,141,40,206,223,218,1,46,1,146,210,250,1,128,73,98,126,206,172,176,27,29,147,246,102,178,59,147,22,54,221,165,91,170,87,214,86,125,235,207,104,19,211,60,205,247,117,214,123,110,33,176,173,71,224,214,186,151,240,48,210,36,56,170,134,85,130,113,173,174,160,133,148,64,153,68,209,233,105,0,181,134,177,202,253,112,19,55,221,113,96,240,2,249,183,118,122,56,253,64,210,21,116,101,74,54,44,30,77,115,218,121,68,240,255,60,45,39,21,204,121,68,76,102,18,144,10,234,98,190,133,93,82,1,116,217,177,15,137,96,94,35,55,168,61,64,232,112,168,255,127,168,122,212,51,251,182,41,38,180,238,68,114,159,171,200,61,227,1,105,112,57,128,76,54,72,249,44,185,139,18,65,224,79,75,65,41,96,197,153,177,5,89,115,44,14,18,53,141,76,85,178,205,8,162,9,136,117,19,123,61,56,194,52,50,65,12,56,43,246,96,101,9,48,130,15,59,1,189,77,189,50,167,1,6,57,140,191,120,198,38,61,9,168,204,105,55,220,101,213,184,53,44,105,113,83,189,129,188,79,47,199,128,81,180,101,48,76,71,222,23,0,102,225,57,101,85,209,110,138,232,218,185,218,237,221,37,24,32,247,119,136,29,93,61,36,83,195,13,192,173,71,85,77,114,194,117,220,174,20,195,206,121,122,203,159,142,163,40,171,59,122,152,237,7,223,58,241,162,189,224,76,83,228,47,6,177,136,16,8,101,172,54,37,205,180,250,196,76,59,223,195,225,85,21,186,44,236,96,86,23,180,39,15,203,150,72,78,236,74,20,144,90,149,85,184,53,13,179,88,145,195,114,158,34,65,182,201,79,153,170,204,49,76,46,150,29,200,63,227,175,31,57,12,228,66,28,81,81,235,248,49,240,125,19,207,241,130,213,235,94,187,46,69,151,182,201,197,166,49,182,191,255,144,90,7,61,225,72,227,54,165,222,171,99,33,100,69,237,56,2,174,83,51,169,209,60,133,162,74,233,88,148,114,40,193,115,96,36,177,7,63,211,191,122,223,8,178,36,63,219,80,236,132,5,89,97,77,156,57,175,206,180,6,75,94,150,186,202,22,153,131,238,204,120,45,160,242,42,24,247,54,141,44,198,185,112,245,226,32,150,15,108,184,127,79,39,251,31,23,237,30,142,29,61,195,33,3,183,51,8,117,66,75,6,79,43,48,44,122,123,67,201,3,5,200,205,11,111,137,215,46,143,9,53,27,92,149,47,174,142,91,24,70,89,103,237,115,145,212,216,175,66,161,172,4,181,56,226,0,12,164,215,184,50,28,165,124,183,61,235,171,96,204,12,149,218,69,51,47,46,18,234,128,133,213,75,32,80,92,180,200,208,203,170,157,86,16,149,88,31,208,14,20,114,222,182,90,215,112,84,188,60,220,82,69,32,40,55,190,252,90,209,112,154,190,185,136,180,101,189,135,152,84,95,160,135,51,165,187,19,62,215,5,231,198,80,12,141,127,172,176,225,56,113,6,182,43,80,57,18,120,233,3,22,204,88,154,221,61,86,115,232,243,14,67,214,112,236,177,53,167,96,108,182,96,189,204,93,225,248,118,149,20,16,221,22,238,47,50,64,46,241,204,18,97,209,186,5,80,235,172,161,125,115,235,131,180,47,179,175,94,236,13,212,142,238,125,45,181,141,134,213,33,182,50,198,134,231,53,148,98,119,196,21,131,176,205,115,247,105,162,82,213,110,232,11,229,166,238,120,5,90,173,162,190,188,70,105,167,88,71,27,212,168,95,51,75,162,217,153,58,143,89,50,21,184,247,212,242,183,192,180,50,86,145,239,208,178,224,4,118,194,223,99,125,192,227,177,139,211,147,31,52,6,97,41,69,227,29,175,57,30,92,199,29,177,27,61,145,84,195,114,117,1,95,254,189,155,116,237,24,6,136,57,221,32,0,239,133,102,85,53,254,202,220,92,87,35,33,49,181,204,6,134,16,159,250,242,222,213,176,138,122,193,145,144,5,145,117,231,23,214,196,12,221,114,224,254,43,102,136,190,162,89,228,161,184,87,73,179,142,104,175,154,96,196,22,224,9,189,115,51,92,208,100,233,129,182,93,80,100,45,155,229,174,218,57,162,54,187,72,240,184,199,216,108,175,221,204,96,184,146,208,202,94,44,11,35,173,72,104,207,209,123,250,137,204,29,14,61,241,57,193,42,38,36,243,99,236,145,13,153,223,93,111,16,91,191,1,84,217,82,219,227,84,83,233,47,162,133,47,157,115,179,159,212,74,242,30,147,98,43,116,83,251,25,109,134,132,54,6,44,127,254,182,20,167,192,80,168,148,234,26,95,118,75,165,216,33,200,14,219,11,77,117,144,33,92,170,125,187,89,121,83,178,29,180,21,123,134,123,19,53,203,212,123,69,183,166,140,89,199,230,118,57,177,91,191,160,177,128,111,100,234,23,158,250,226,142,17,140,248,45,148,78,228,243,158,166,114,171,97,207,189,223,188,7,51,169,34,217,66,160,148,234,73,93,57,199,224,248,16,97,96,72,135,150,44,102,18,214,15,121,79,210,172,123,133,250,97,12,65,246,93,146,166,140,119,97,148,253,117,41,28,25,121,71,84,249,177,31,180,172,152,124,208,165,166,231,54,141,56,106,139,190,192,19,117,25,20,45,107,184,30,196,250,92,179,60,166,134,180,70,204,83,27,180,113,20,102,25,132,10,131,67,24,234,187,208,88,113,55,118,171,146,66,104,208,145,20,17,232,194,68,41,73,123,115,140,243,56,243,13,50,46,150,104,83,201,72,59,160,31,89,109,10,130,85,235,222,43,28,95,50,69,171,80,154,115,87,197,32,176,129,74,50,73,127,142,62,194,144,137,220,116,34,131,74,3,203,223,28,173,94,135,93,246,54,247,156,112,161,43,110,104,190,192,13,155,151,128,114,191,75,41,48,123,205,252,149,214,190,77,16,114,216,187,77,150,61,39,56,140,40,64,32,253,18,67,196,211,31,157,203,133,111,27,84,29,72,67,55,231,71,22,21,109,221,147,32,57,84,179,7,152,148,105,251,93,40,12,207,150,215,94,18,173,197,125,18,176,232,159,8,101,119,109,0,183,204,89,218,69,246,131,138,30,157,153,193,176,3,240,114,33,95,79,39,221,228,51,199,204,30,68,120,186,4,225,229,30,51,239,226,177,65,60,40,138,245,19,223,250,34,150,189,36,60,196,28,241,200,16,13,74,198,9,178,56,195,50,44,10,10,33,18,193,24,127,12,12,104,36,234,131,94,184,47,244,142,216,235,42,135,3,154,52,202,101,142,81,134,45,195,56,199,142,253,193,120,208,25,38,183,162,156,148,172,131,22,182,160,206,209,154,230,115,216,132,86,114,2,197,198,172,231,149,161,127,169,209,229,166,129,172,1,110,99,161,242,238,77,38,188,64,165,128,105,157,29,123,37,238,218,172,227,22,183,24,185,233,220,150,67,78,69,198,128,89,160,211,126,31,58,110,128,6,195,18,74,15,146,177,168,169,150,43,116,0,57,160,72,154,79,107,121,35,76,139,228,202,31,53,220,19,133,97,122,208,116,2,140,240,54,28,125,0,170,243,122,153,38,226,74,30,80,4,166,93,131,242,44,126,140,112,107,148,109,23,87,10,109,253,64,77,176,18,167,125,247,232,129,159,183,71,175,90,69,68,70,173,245,233,215,128,80,148,84,147,157,47,152,245,9,104,25,198,142,141,65,255,254,33,238,182,105,142,74,218,193,123,37,31,11,166,238,226,152,219,107,239,7,220,223,179,201,67,205,233,50,196,192,238,196,39,221,83,13,60,41,29,131,49,104,155,204,131,8,230,116,188,217,165,205,202,54,247,237,189,36,171,249,38,43,251,45,151,44,146,249,183,226,0,102,53,205,122,156,193,236,44,228,167,133,238,245,19,144,185,252,180,169,224,18,241,139,163,226,168,36,139,44,49,98,53,21,3,36,37,251,119,242,36,172,87,187,39,204,255,82,48,94,60,166,21,179,110,101,44,5,184,189,138,205,2,33,234,164,219,190,111,193,24,159,60,84,18,69,232,54,105,161,40,243,221,71,167,66,142,79,7,155,25,43,165,55,189,196,75,9,222,224,238,140,65,195,136,140,199,9,87,156,90,1,114,216,6,35,244,154,134,254,87,155,29,128,123,201,123,129,27,128,254,99,8,193,172,194,232,176,209,62,81,224,165,97,115,32,32,11,73,119,42,7,63,17,142,20,64,176,97,160,116,171,57,250,132,180,8,153,126,240,244,215,36,169,2,45,171,116,98,111,9,242,9,134,154,123,84,82,232,54,137,155,231,91,123,84,32,99,99,158,116,35,44,246,236,245,131,214,90,37,102,236,219,248,92,157,20,201,187,20,115,182,210,211,19,170,173,9,25,101,56,174,231,175,2,14,215,8,93,115,20,90,120,214,38,115,160,162,97,88,59,239,168,78,91,147,212,219,121,255,114,251,69,111,206,44,196,179,227,105,106,58,63,87,112,123,5,240,85,74,196,18,217,255,17,0,100,19,120,58,99,255,151,87,42,78,247,20,131,9,103,225,39,71,43,27,255,244,100,45,47,198,233,170,42,93,50,56,198,91,79,63,44,232,213,55,89,72,75,50,122,2,209,46,61,167,153,51,195,180,209,58,35,76,63,169,52,206,21,99,141,155,64,34,24,151,35,225,234,138,79,214,179,213,45,192,70,223,208,87,113,145,101,43,110,31,235,80,66,46,49,123,98,60,231,18,71,241,162,238,229,252,8,61,231,109,199,241,239,96,143,114,53,63,183,153,210,59,1,124,189,21,52,159,152,112,248,166,181,209,242,128,75,213,30,5,114,65,244,35,13,219,169,127,197,142,211,47,184,79,104,159,168,168,109,197,143,71,141,95,120,234,77,195,27,11,179,148,205,219,91,202,75,53,191,25,135,171,47,148,52,206,40,245,178,92,189,162,141,108,107,125,124,198,108,236,93,97,250,201,128,35,15,249,137,151,44,122,52,114,124,147,34,109,230,127,166,227,13,163,70,192,136,186,89,34,84,88,27,229,158,36,67,185,178,77,210,226,30,64,253,216,180,177,231,32,216,84,87,219,135,160,54,106,216,202,188,101,191,235,51,38,157,247,149,94,170,41,179,69,151,93,193,157,178,61,91,112,60,96,102,98,221,120,94,56,179,224,121,53,177,212,40,72,39,196,108,102,240,59,208,161,12,155,98,202,20,136,99,81,117,144,82,238,107,62,98,181,6,108,231,113,89,25,151,185,17,211,119,160,28,218,63,74,136,183,5,156,184,192,242,69,98,80,32,168,18,194,14,78,214,55,18,6,1,151,112,180,110,31,35,108,90,160,166,89,232,118,59,149,43,144,50,138,25,25,151,214,47,148,94,107,23,77,9,232,218,13,222,76,20,155,110,234,29,56,121,123,68,33,255,246,164,201,184,67,80,236,216,220,83,177,23,192,80,216,114,254,103,172,199,142,170,154,97,124,194,120,200,54,229,126,43,163,91,34,17,55,50,12,57,132,239,171,44,29,100,45,234,65,55,41,70,162,100,58,221,125,46,103,53,72,45,249,233,179,184,188,49,135,89,95,114,126,240,36,175,184,76,122,103,122,50,9,162,151,179,245,107,173,99,87,175,137,221,157,1,253,163,126,0,213,97,53,80,139,170,8,127,86,232,54,215,177,191,254,133,79,201,116,187,90,74,170,221,181,115,186,153,62,249,169,125,163,146,191,178,161,197,91,40,156,33,248,35,244,64,8,205,16,128,194,77,134,27,162,199,158,187,21,43,105,43,45,114,14,239,25,98,16,7,35,165,93,208,128,63,243,42,234,10,99,150,219,140,98,115,239,166,206,172,77,239,154,29,140,232,115,226,47,252,203,185,216,228,205,253,64,193,71,45,56,8,115,26,71,87,129,242,34,198,128,252,73,232,134,27,48,115,133,94,113,32,108,230,36,49,191,76,5,94,201,213,96,68,148,66,110,191,235,210,180,250,16,123,2,36,91,208,240,166,125,129,212,3,43,207,225,181,180,9,205,51,122,221,25,187,194,157,219,101,85,89,40,57,39,225,229,90,168,32,102,146,54,207,234,5,155,129,9,218,218,236,249,115,69,72,195,168,179,203,255,167,52,34,188,95,92,197,163,118,56,30,142,42,171,24,133,89,35,43,69,32,9,55,249,36,43,23,47,17,202,201,107,187,174,72,225,201,227,170,75,172,129,200,215,2,76,68,3,21,68,158,213,141,130,124,108,31,237,136,16,84,203,216,7,232,33,118,146,119,144,174,0,40,54,73,190,55,113,58,184,141,45,132,103,219,122,172,251,147,47,165,197,48,78,75,145,148,158,190,201,95,142,107,89,70,241,237,227,152,167,129,243,243,230,32,76,16,131,64,207,7,179,165,165,26,221,135,135,67,70,5,7,197,242,140,205,49,70,215,122,96,40,232,165,147,105,24,207,53,54,13,64,212,62,112,112,200,34,36,7,139,27,162,154,32,0,239,165,132,2,153,223,62,45,49,235,17,170,118,22,229,39,14,101,25,32,161,161,47,184,42,78,68,147,190,171,87,228,37,79,242,22,116,193,4,203,36,100,94,48,126,225,54,152,217,91,37,84,20,226,81,206,238,225,148,180,152,149,15,252,238,32,187,121,198,17,167,135,90,52,89,187,80,4,81,194,66,1,102,171,99,18,64,34,177,108,44,205,89,172,72,76,213,62,54,193,249,209,183,124,209,208,195,199,160,5,14,249,109,231,250,125,215,241,39,204,97,128,50,217,148,41,34,22,59,145,32,216,18,11,107,10,102,21,146,192,194,201,240,81,240,237,171,190,164,177,33,252,57,66,172,225,162,179,104,72,160,120,150,57,131,203,29,176,54,149,125,243,94,113,162,14,187,81,92,45,97,207,5,118,87,225,66,32,215,244,70,101,110,244,84,74,192,199,4,149,104,40,130,124,69,15,183,215,253,185,21,97,191,159,195,184,85,189,247,181,241,245,8,211,20,85,194,182,104,230,6,71,161,240,170,140,156,191,126,38,167,108,251,66,220,137,218,170,12,48,144,109,142,235,1,51,130,235,188,144,17,32,104,146,4,112,1,2,3,154,123,44,124,54,183,29,176,153,8,123,116,168,134,13,13,0,62,218,32,190,120,217,79,206,58,73,180,83,41,79,7,227,115,73,73,110,21,198,154,170,160,110,54,56,111,83,153,197,222,120,0,63,206,81,91,161,41,113,205,241,206,164,135,196,19,127,71,181,155,109,86,77,162,166,60,126,181,185,102,128,162,122,200,154,134,43,46,67,194,160,198,187,131,191,95,45,232,188,224,52,82,203,187,81,54,245,146,168,160,117,172,74,10,62,158,201,172,124,147,13,124,20,212,51,91,131,109,24,171,50,223,40,145,158,200,125,77,55,138,251,25,197,209,70,39,221,40,48,121,185,63,73,156,122,217,124,116,237,217,73,31,72,191,13,25,153,63,211,104,144,162,100,195,85,251,23,222,101,33,151,21,249,147,212,152,83,249,243,8,25,224,138,197,166,38,125,236,119,229,234,249,89,84,137,204,174,169,216,198,85,132,9,80,63,170,45,246,48,221,19,165,207,89,58,204,36,248,167,76,56,152,29,194,186,194,58,63,133,24,153,88,189,237,187,163,196,31,237,4,5,25,113,107,116,230,149,246,68,215,254,107,210,195,232,97,76,245,45,99,255,21,143,111,151,163,9,181,235,44,25,12,110,16,70,219,219,181,99,55,106,63,120,247,238,65,179,222,111,144,147,40,66,116,3,198,166,174,157,0,75,89,125,112,42,213,68,88,155,210,14,85,16,116,1,39,175,109,79,199,41,127,182,39,69,136,202,254,196,58,148,231,39,30,250,160,244,124,254,249,89,56,150,75,127,230,144,44,115,34,182,65,121,201,201,128,186,168,80,70,164,57,174,133,79,169,27,48,166,216,15,248,83,157,77,126,101,45,117,150,162,33,92,157,125,121,63,101,135,163,233,130,100,89,123,210,151,5,127,216,226,226,122,156,29,246,121,79,6,207,83,72,45,76,123,100,51,214,206,8,123,224,245,120,154,13,166,77,233,7,170,48,42,231,157,114,128,95,42,27,151,148,199,181,28,68,55,11,208,194,50,249,209,233,30,48,66,131,83,250,196,36,253,151,83,98,12,2,11,110,102,128,118,51,13,42,120,218,178,91,81,83,86,45,224,108,94,144,3,153,59,62,178,99,32,122,26,197,226,80,153,122,46,92,0,255,93,63,224,3,192,78,73,193,112,147,249,51,234,228,105,204,199,134,144,97,50,59,220,14,195,22,13,195,174,171,183,181,210,71,30,236,103,198,183,154,19,99,147,150,254,143,184,65,221,54,117,228,71,110,45,218,197,203,48,94,96,118,2,25,115,125,0,241,13,191,65,235,180,189,103,59,230,84,223,40,168,33,179,211,153,10,10,243,136,9,243,192,58,198,55,77,54,174,143,68,235,163,198,230,42,187,83,103,228,141,221,186,190,55,171,8,151,202,241,173,171,23,104,78,12,39,61,83,148,54,45,169,155,169,40,9,175,250,145,83,165,222,139,154,177,237,135,97,85,223,253,252,9,146,180,131,212,5,56,66,188,58,35,108,34,72,39,122,26,85,162,175,212,37,3,16,170,43,33,222,21,249,50,105,64,118,167,136,92,59,139,254,39,58,84,54,223,95,87,194,173,62,4,181,253,227,44,142,130,235,35,89,57,132,41,61,8,154,153,153,12,95,164,133,186,142,202,241,120,122,140,128,53,28,38,53,125,238,52,109,203,128,123,59,54,60,242,251,33,98,252,29,70,5,1,1,98,108,67,0,86,234,147,153,72,12,167,104,129,238,153,68,109,59,35,148,120,86,170,138,93,21,45,173,157,13,224,150,20,248,143,78,158,103,104,113,42,161,119,209,144,129,146,125,244,135,219,213,37,1,248,93,35,83,72,128,141,102,89,173,163,188,81,182,200,49,160,213,192,214,191,247,197,68,167,39,39,235,33,158,196,191,68,19,24,168,66,156,218,132,140,102,53,151,75,207,62,142,179,110,248,32,13,193,84,168,242,157,216,218,218,75,29,174,236,189,188,199,61,127,132,35,237,30,2,168,95,160,166,192,85,134,77,247,57,165,171,169,169,18,28,108,103,232,147,217,4,249,37,207,78,243,134,242,220,135,28,237,45,227,216,104,248,77,130,50,218,168,185,71,88,96,247,58,142,222,182,57,37,15,176,64,159,104,187,48,144,147,117,99,53,236,158,35,189,167,206,120,213,126,131,41,113,172,211,99,203,75,16,254,24,24,65,104,141,12,234,99,168,180,160,73,227,246,63,2,96,245,229,40,158,44,125,249,249,48,212,228,145,50,102,206,58,59,81,254,239,109,43,31,131,47,212,2,85,103,238,73,130,164,193,155,184,74,225,5,209,128,10,105,138,80,231,235,124,30,58,199,254,64,210,245,99,40,246,228,226,144,112,180,107,22,90,3,80,79,99,147,127,241,154,60,217,52,124,181,102,237,66,194,122,93,77,5,102,210,68,164,170,166,132,28,120,150,34,185,1,156,101,219,146,180,31,131,176,84,128,0,56,9,92,128,70,212,197,3,47,46,173,68,25,235,195,81,3,134,173,49,72,219,14,245,16,145,1,240,38,131,96,141,83,223,117,237,241,198,91,7,167,145,134,202,241,129,182,213,45,185,122,29,114,143,55,235,224,206,157,22,130,233,100,160,210,35,10,202,83,155,204,177,137,214,23,221,174,232,62,33,26,130,6,131,70,105,32,18,30,179,38,69,253,244,126,156,153,168,138,26,17,71,207,219,67,196,159,209,238,40,172,244,91,171,162,227,2,179,223,183,201,120,60,108,193,112,69,45,16,217,22,43,238,137,99,253,34,222,42,12,10,31,66,146,51,246,48,160,249,106,176,44,184,1,124,17,178,52,216,86,81,149,79,136,166,20,192,68,38,98,110,152,200,175,168,115,155,178,228,91,163,176,188,109,185,162,39,233,151,10,73,234,5,101,45,169,154,51,203,221,12,215,119,174,197,156,152,220,145,193,8,160,116,242,159,126,177,204,164,173,156,181,103,67,22,189,10,131,215,187,112,93,38,19,113,146,89,195,174,66,132,255,57,74,119,33,72,110,127,109,189,76,180,253,190,74,208,1,137,21,251,240,108,108,127,43,240,223,19,8,135,90,198,127,4,208,61,94,205,185,63,202,24,2,223,178,77,190,111,151,47,133,28,181,166,152,63,39,147,8,42,187,37,131,161,13,13,201,8,107,91,9,196,14,230,138,7,69,176,71,129,126,79,123,100,124,207,62,141,158,72,136,137,8,84,148,157,49,194,139,87,225,253,58,128,113,240,177,158,52,181,31,253,107,134,176,202,246,26,0,143,179,150,245,84,148,201,42,144,84,146,18,237,245,22,95,91,175,17,238,4,122,27,117,254,178,232,14,26,175,234,91,126,250,239,32,227,169,122,189,36,92,227,145,238,90,98,118,28,228,88,149,239,46,70,184,0,202,154,228,228,237,118,83,117,203,196,122,216,123,251,221,47,55,197,231,72,62,131,228,36,251,102,20,22,0,37,232,70,139,1,102,75,147,55,176,251,149,97,44,176,230,150,245,70,190,45,59,40,251,101,89,33,123,226,238,191,154,176,94,207,138,241,26,199,204,67,159,159,69,140,8,58,111,132,117,76,81,177,37,109,31,88,170,182,101,52,38,167,238,241,176,167,38,136,59,15,191,248,206,14,83,155,241,79,247,227,246,24,224,13,129,23,13,235,195,43,145,2,157,67,217,28,247,226,156,251,46,217,102,156,239,191,12,224,164,251,104,244,146,183,239,218,233,98,201,118,223,4,79,237,159,246,115,184,208,143,161,246,43,182,108,182,120,184,48,228,92,254,134,162,179,208,231,39,100,40,194,87,129,63,215,55,114,144,126,93,103,51,245,225,62,203,121,227,202,188,247,230,87,254,215,113,27,97,202,48,234,202,28,48,6,157,139,41,82,97,153,11,211,92,121,213,26,38,152,191,212,43,93,89,196,249,104,130,201,25,159,252,51,132,36,209,130,216,72,254,195,218,16,95,18,243,53,95,125,123,247,210,181,249,193,153,12,134,148,38,88,129,51,242,9,26,107,14,186,92,75,158,92,32,75,205,87,73,109,124,102,108,58,216,103,215,117,97,105,26,70,141,99,218,144,91,234,106,249,87,97,109,253,47,23,145,209,93,48,197,18,50,184,219,148,220,14,107,221,252,185,70,34,103,101,234,107,69,233,181,222,54,97,65,134,142,177,230,172,150,223,137,82,2,126,76,175,163,118,73,169,151,153,8,179,178,83,74,139,67,185,118,105,233,249,152,122,140,128,214,142,209,46,240,207,224,197,10,212,138,130,39,137,249,249,16,246,172,129,166,62,32,153,148,244,65,74,168,233,39,70,37,255,111,182,37,251,154,217,131,98,64,170,73,205,121,228,66,220,206,79,66,34,175,230,197,145,133,181,46,182,231,224,253,9,5,42,40,33,112,57,185,100,254,144,112,63,222,211,61,207,25,184,110,146,214,73,220,171,160,52,144,169,200,143,61,153,23,96,92,225,205,183,221,104,58,104,96,69,245,23,8,149,107,218,173,58,88,124,49,109,20,244,249,179,207,7,141,189,250,67,42,161,68,238,98,193,98,112,141,235,241,250,64,93,130,59,152,142,219,85,165,195,124,106,55,40,111,90,123,74,208,23,114,63,226,49,127,136,103,186,46,55,191,34,191,192,99,137,211,56,72,14,81,14,99,211,128,64,203,29,41,66,37,60,80,176,171,4,214,197,150,242,64,129,49,108,70,77,46,225,2,222,46,174,82,217,40,79,72,118,212,143,175,170,39,105,77,161,197,118,92,54,41,14,52,25,198,95,49,12,148,192,199,75,99,14,255,249,95,155,31,193,241,138,145,134,252,78,108,197,116,132,71,199,26,150,184,173,207,220,73,135,71,143,98,40,152,25,10,144,3,129,17,79,98,40,224,239,194,166,220,11,75,49,61,172,85,235,121,20,131,13,160,121,228,99,74,117,124,39,130,184,194,129,0,223,236,211,194,17,153,35,21,53,76,138,182,161,223,40,156,130,234,0,224,158,188,21,60,156,1,14,223,133,220,149,177,48,226,237,123,166,188,118,13,225,0,81,177,94,194,255,162,141,197,211,192,181,217,5,127,7,248,243,132,222,90,28,234,140,136,58,139,226,55,242,52,42,213,233,155,210,51,157,42,90,109,24,208,58,63,193,159,101,205,148,34,194,80,47,55,121,30,202,96,233,219,198,121,33,56,219,19,47,209,102,119,163,169,168,156,130,171,227,33,201,185,114,153,93,122,89,114,52,247,8,219,175,52,204,139,33,31,179,174,165,52,71,38,186,38,153,152,103,141,119,152,198,119,43,186,125,66,123,113,79,243,71,103,180,155,94,222,171,247,136,16,139,127,116,247,207,143,211,44,27,238,87,189,194,129,123,234,182,132,179,164,248,14,122,200,188,95,99,53,27,209,240,195,45,224,137,118,73,252,76,255,88,49,125,135,28,62,126,31,233,149,9,102,210,32,97,250,87,116,129,58,137,2,137,46,8,12,62,73,193,85,128,228,197,242,165,139,89,157,16,232,81,188,35,242,217,112,44,212,27,82,121,216,18,215,174,1,186,151,237,21,153,156,191,195,226,216,58,208,76,206,108,173,244,1,163,184,72,239,167,4,85,237,38,100,222,43,145,232,35,188,38,54,79,5,76,5,216,244,174,31,68,163,245,241,9,84,176,222,178,83,223,62,212,147,90,105,177,191,223,52,12,133,160,229,161,230,144,35,238,170,185,157,254,195,205,17,37,165,208,81,189,244,209,42,25,218,125,84,104,20,187,2,233,193,141,142,151,160,184,166,103,49,240,151,186,134,134,63,80,170,90,7,116,29,138,80,45,155,75,53,163,3,88,188,74,83,99,168,80,178,128,69,238,186,50,44,127,167,89,91,195,48,31,55,52,131,116,102,208,70,162,82,53,205,252,146,1,243,86,92,231,130,70,107,124,66,192,61,237,31,155,224,117,21,201,252,220,190,136,139,108,10,20,187,37,78,62,252,137,250,29,184,201,184,235,228,182,27,209,24,15,3,100,38,150,204,106,90,20,59,245,150,163,200,255,72,60,186,137,99,194,33,137,102,55,184,161,248,223,29,7,0,136,153,234,168,212,81,4,5,55,245,22,216,184,209,216,246,177,45,139,42,125,228,116,253,5,75,89,136,17,139,82,81,4,168,87,148,233,242,84,79,223,234,53,215,192,18,245,167,114,95,107,51,163,87,242,36,135,104,93,136,26,82,115,129,120,36,205,104,190,61,161,224,221,90,214,7,239,146,227,170,124,14,174,245,159,208,248,137,23,30,113,46,212,39,117,220,174,18,9,2,80,46,195,254,7,72,123,16,94,195,0,194,8,111,120,221,196,115,31,24,38,34,124,211,30,74,129,45,147,233,113,49,214,255,204,220,40,77,16,238,155,212,163,243,76,67,188,89,141,73,32,114,180,135,214,112,49,250,73,179,194,118,221,63,70,148,38,169,248,59,185,235,155,85,91,144,122,86,102,44,97,138,247,213,125,164,182,107,51,34,24,199,99,231,170,40,64,58,246,70,60,128,218,236,13,213,189,124,33,118,246,56,62,25,182,5,135,51,150,37,238,36,235,100,124,160,202,124,86,152,75,164,201,241,203,21,27,134,164,239,54,244,103,212,237,203,108,222,90,112,100,16,109,111,126,131,80,223,159,179,119,13,79,68,14,162,135,51,44,233,142,89,66,193,236,251,105,229,190,70,91,200,195,197,112,169,235,156,89,136,171,232,212,146,38,149,118,233,103,40,120,164,109,213,84,36,65,3,139,180,191,95,54,223,113,216,14,160,138,219,173,240,157,177,52,155,125,63,148,32,231,178,119,137,132,164,189,216,53,102,186,66,129,79,158,52,197,245,174,186,33,237,39,146,164,66,170,147,229,137,202,147,199,193,109,68,224,34,18,70,157,222,95,34,36,62,117,141,188,191,123,125,151,156,84,54,94,73,44,233,56,80,21,25,163,146,205,132,238,159,55,42,124,77,134,18,182,218,204,175,114,141,164,116,198,200,218,106,44,31,247,83,30,235,215,25,49,214,41,54,193,109,111,172,231,78,83,150,19,235,15,92,165,151,149,43,204,40,5,168,150,194,239,172,86,179,76,234,156,190,106,9,142,5,243,235,100,250,41,17,195,248,200,57,71,34,204,38,132,36,95,50,23,192,178,196,22,35,218,70,87,216,107,202,112,211,204,166,202,171,229,230,244,181,193,191,17,240,225,212,116,236,219,161,33,244,102,27,159,190,180,46,236,10,241,149,79,14,12,86,90,114,32,99,97,76,209,177,20,225,29,196,67,148,63,181,167,209,253,92,8,186,135,72,134,179,247,167,81,48,9,140,15,83,49,248,115,242,119,165,189,88,147,251,233,99,52,209,212,20,236,35,57,125,153,203,27,43,246,87,164,239,38,129,25,187,122,40,21,227,9,231,124,223,18,13,96,247,70,184,60,44,251,57,23,85,230,148,8,54,200,89,65,237,92,90,212,153,155,213,239,57,234,198,165,98,85,217,88,127,25,93,114,157,234,83,198,114,231,121,3,123,57,58,229,169,37,177,0,216,97,92,124,80,77,70,149,228,187,8,40,31,1,254,42,115,220,220,65,161,68,140,144,97,231,83,149,224,161,17,14,33,49,205,104,63,215,135,129,129,210,170,85,31,211,49,69,7,162,195,212,73,38,159,84,55,114,146,100,55,126,212,160,220,239,180,79,218,50,252,217,96,57,34,80,56,188,250,235,137,137,100,81,55,90,131,120,45,248,245,191,133,79,21,193,203,145,130,20,243,137,163,88,144,45,14,132,240,87,185,179,189,46,239,244,151,16,109,190,111,41,33,251,207,207,203,162,157,166,245,50,64,82,45,11,128,147,80,95,48,147,91,101,184,119,86,189,246,66,161,230,237,179,107,211,172,209,101,133,156,109,48,252,234,235,189,42,97,191,49,182,72,59,22,168,29,215,20,181,223,155,9,123,208,240,197,160,111,59,157,247,28,12,145,172,85,49,55,196,105,3,122,35,75,4,223,255,99,47,178,95,77,134,197,92,38,152,30,168,236,153,81,190,102,153,81,166,32,70,213,79,120,169,70,84,153,155,204,80,90,14,62,108,45,193,81,235,215,90,165,82,76,102,169,86,251,80,244,244,36,231,70,209,13,145,180,89,145,122,30,55,176,69,69,111,198,237,135,60,67,108,140,3,55,225,208,221,85,202,245,55,214,200,152,159,247,75,158,125,89,222,250,232,237,126,188,185,89,62,117,12,118,31,132,47,35,88,102,30,6,104,229,102,189,27,234,248,22,206,40,29,37,236,129,246,93,177,95,207,181,43,130,105,146,238,216,190,80,40,234,30,105,110,221,239,166,18,185,11,105,36,29,125,143,1,118,142,146,221,250,35,175,31,162,99,155,167,144,76,155,144,235,42,151,33,8,215,83,197,107,154,214,189,197,213,61,196,20,7,49,198,231,213,206,75,251,210,218,66,68,38,3,151,178,139,59,57,186,189,91,232,154,167,112,149,143,181,250,240,34,146,0,188,129,37,22,96,215,19,232,3,137,26,133,186,221,168,79,204,94,148,143,249,128,124,66,34,38,169,142,85,208,150,69,1,222,57,72,86,204,104,55,178,209,64,82,19,170,20,0,242,185,132,76,115,102,61,104,163,70,182,202,78,220,86,30,194,87,141,48,64,200,107,115,44,141,186,25,69,169,159,92,39,38,66,105,245,12,155,74,187,239,155,79,176,75,254,119,246,9,2,143,60,31,130,54,233,180,228,76,54,69,72,108,13,44,15,194,15,2,94,40,48,93,53,249,20,189,64,150,149,89,73,226,112,91,212,88,57,51,113,83,87,184,245,7,221,249,100,3,230,189,146,198,13,195,218,9,1,219,46,224,100,14,153,18,143,154,129,143,42,235,170,52,145,238,19,232,18,46,100,222,244,241,14,55,139,156,34,230,244,143,10,75,237,126,220,45,134,196,114,119,43,178,41,102,82,207,97,124,49,1,142,89,86,70,129,130,3,158,156,80,112,120,194,243,35,115,231,145,156,136,152,233,64,100,97,207,123,158,142,70,93,71,109,136,170,96,25,62,113,230,128,82,179,81,254,177,162,90,125,206,167,21,180,240,180,199,85,124,249,31,243,97,144,233,74,147,168,171,95,144,27,99,203,104,194,82,232,178,168,244,228,246,23,51,66,159,63,198,255,157,231,63,12,226,171,140,254,77,112,51,19,204,71,146,50,60,75,223,45,80,248,46,158,197,191,49,101,190,65,51,250,137,117,30,195,69,49,60,117,222,138,167,184,209,188,204,194,246,203,248,233,47,186,220,197,159,19,169,174,137,28,2,221,122,56,53,190,98,255,142,52,222,2,96,216,217,102,44,98,170,54,75,68,151,98,37,122,56,9,89,149,139,174,95,255,176,141,239,196,135,132,77,81,13,31,154,221,10,175,241,237,7,195,250,44,231,127,56,36,123,30,165,159,132,237,91,152,179,52,195,85,155,22,79,251,117,56,208,142,81,255,150,108,126,195,228,217,172,239,134,116,52,167,89,25,161,202,120,120,145,185,231,176,65,57,132,84,81,248,61,152,189,155,208,84,192,55,228,84,236,50,53,114,214,24,232,110,205,207,21,5,166,181,227,29,218,253,207,239,29,29,168,144,172,151,16,155,24,48,174,206,143,57,185,157,72,138,229,201,67,215,34,169,12,54,162,111,90,237,229,170,126,19,172,37,189,47,92,50,244,4,25,211,76,230,222,110,80,36,2,8,23,21,5,130,219,232,133,220,189,115,38,103,115,140,84,20,200,14,216,217,65,66,75,46,240,29,89,147,175,231,183,78,48,187,168,194,222,42,68,69,135,162,89,237,216,214,201,154,219,176,144,75,112,47,2,25,218,194,195,124,185,17,253,155,220,225,138,149,159,89,240,12,52,143,220,112,192,217,206,47,149,0,217,7,244,213,157,67,153,168,121,193,103,82,100,183,8,102,97,50,36,35,74,125,225,232,211,4,0,61,250,126,188,131,179,51,116,248,133,192,239,152,253,62,158,111,247,205,206,101,237,206,65,226,147,217,115,251,23,255,139,198,143,210,55,9,10,195,177,173,165,125,16,11,60,112,150,163,118,156,170,212,196,95,165,15,114,171,123,18,19,12,140,130,237,146,125,55,149,57,149,173,155,99,144,174,28,70,104,45,158,207,10,210,250,248,175,43,227,245,154,206,105,74,253,213,3,47,236,187,139,109,138,206,89,188,36,106,14,64,75,24,193,132,14,189,192,219,197,173,209,91,112,235,113,104,129,195,153,199,28,16,35,53,122,249,150,238,207,88,116,76,80,232,141,220,233,175,173,67,135,171,251,178,103,214,27,9,184,90,11,96,33,2,77,224,2,214,237,110,250,233,27,229,40,223,41,161,185,40,167,233,254,124,190,74,184,97,99,205,200,16,62,77,68,206,1,52,156,252,182,45,117,103,32,63,177,230,189,183,104,174,63,16,58,2,152,207,239,135,137,111,71,214,35,152,142,70,141,164,142,112,242,181,131,102,149,74,12,83,216,16,17,219,155,48,121,163,138,233,212,109,163,62,154,121,76,130,243,110,160,113,241,218,36,17,79,47,17,101,71,126,103,5,74,11,216,18,198,207,149,73,141,183,252,8,225,211,248,209,54,142,13,233,199,31,119,218,220,66,228,7,155,65,55,157,58,134,77,64,147,4,24,238,65,255,103,23,209,56,215,191,211,121,172,30,24,137,241,140,200,69,185,251,48,24,57,91,124,139,149,167,195,148,198,231,139,33,196,242,141,245,132,153,255,222,195,39,67,202,160,132,230,137,195,176,64,126,117,160,56,77,200,141,109,119,138,241,88,65,121,158,114,80,223,60,190,169,175,84,185,94,36,67,115,231,14,176,18,254,0,101,51,44,61,49,197,147,24,106,237,106,237,130,129,242,78,212,86,177,215,1,14,135,94,44,147,172,239,59,228,39,111,176,111,216,179,201,37,72,220,24,153,185,228,35,17,213,97,0,255,145,169,240,150,79,129,131,143,148,126,176,121,52,26,109,29,244,199,38,246,6,157,213,129,167,136,94,212,8,128,60,208,70,206,76,176,114,4,41,52,170,142,255,16,255,128,190,138,121,204,27,87,50,218,185,166,139,194,122,43,153,182,203,51,195,1,168,79,97,166,179,218,113,15,59,160,66,181,164,165,98,252,159,30,94,199,141,21,57,164,42,30,120,12,39,98,235,70,80,132,240,238,163,74,54,105,81,95,123,57,146,154,203,249,125,57,167,82,106,250,35,149,186,74,81,228,145,68,54,248,178,14,164,242,142,41,3,95,116,93,20,74,181,239,245,9,111,98,144,70,0,89,8,206,158,95,153,90,63,132,90,63,38,69,150,144,184,30,33,183,150,239,254,243,185,0,211,168,110,196,76,230,23,24,182,86,81,214,226,171,14,162,142,234,34,202,210,217,186,54,79,192,153,183,122,46,11,227,232,144,19,161,91,210,49,49,91,119,54,129,177,206,43,115,94,92,55,107,204,204,234,41,36,90,86,225,180,38,31,212,235,7,133,20,112,191,23,231,9,174,113,111,245,164,35,246,62,190,89,41,142,171,17,83,240,110,198,29,60,107,150,85,167,116,26,240,114,247,242,248,240,129,119,172,250,60,196,218,225,52,116,157,129,114,164,188,123,30,171,132,224,129,115,133,146,22,247,174,241,177,221,104,118,49,131,51,187,90,191,128,8,156,56,255,76,50,103,167,143,139,153,96,60,40,203,208,138,198,99,98,17,5,59,180,27,94,47,183,22,9,15,1,140,28,42,202,175,203,230,21,184,74,117,67,34,222,154,69,252,71,99,48,6,245,76,13,191,207,194,179,209,50,7,188,227,53,251,170,157,109,10,64,125,168,189,149,121,218,221,180,217,175,220,186,166,38,134,226,116,160,191,30,143,152,141,236,155,3,123,106,137,57,153,69,242,223,148,14,139,98,205,76,122,209,244,126,59,60,124,235,183,99,180,126,147,65,102,217,92,6,224,147,222,69,26,165,26,240,171,68,5,151,24,168,159,93,214,71,236,186,231,163,95,4,217,88,148,252,132,214,132,118,27,144,75,35,100,191,225,118,158,160,7,70,107,192,214,32,235,211,251,120,118,71,18,30,226,137,232,203,23,73,189,120,0,16,38,205,51,247,17,255,114,74,56,235,173,18,107,174,157,202,14,239,61,148,156,147,152,221,61,248,70,168,22,26,21,234,179,69,138,180,160,121,23,43,203,38,73,246,208,111,26,215,176,11,120,113,207,136,172,97,213,58,83,129,152,246,83,80,59,13,206,114,14,118,105,42,85,251,111,189,21,251,244,68,31,62,85,146,19,164,11,118,9,119,232,125,218,54,250,45,168,105,55,193,171,158,114,186,24,100,135,71,86,226,231,195,84,218,59,236,112,144,80,107,34,209,98,127,86,163,39,117,4,154,249,132,139,62,68,32,128,176,229,156,239,71,66,13,150,200,126,213,213,138,72,159,32,225,156,155,145,142,41,185,44,70,159,193,23,150,11,6,84,116,142,14,241,131,49,33,89,35,172,141,159,121,13,88,62,201,156,156,95,252,95,21,120,227,124,13,90,95,174,137,60,186,20,82,54,225,36,27,254,172,37,62,57,133,227,80,85,171,127,246,203,48,141,117,243,73,114,169,140,132,249,116,87,178,172,139,216,109,138,250,154,19,89,2,123,149,243,118,120,93,66,102,202,172,139,156,223,27,9,152,39,157,93,151,86,138,14,167,181,126,108,155,155,218,161,57,221,83,173,244,201,145,226,93,220,175,153,243,14,236,145,170,200,175,39,226,45,14,144,188,244,192,11,97,134,43,88,72,120,134,232,255,95,214,141,216,127,49,242,129,89,19,115,144,53,183,80,65,46,160,124,102,92,68,158,76,204,103,200,235,64,63,5,239,2,104,77,238,178,15,79,27,82,182,124,84,226,235,57,134,119,71,93,98,183,174,93,1,100,120,42,14,236,164,118,193,29,23,139,160,102,237,88,2,186,195,119,87,5,59,221,230,27,89,158,112,77,94,211,228,129,27,109,140,229,239,144,71,82,185,179,78,225,108,62,68,253,169,199,164,148,205,53,200,147,122,9,90,115,198,12,102,240,59,23,91,102,208,111,181,231,79,215,160,163,166,241,152,22,52,125,164,121,31,64,158,149,22,71,137,124,207,161,213,218,27,207,51,134,67,19,157,229,175,157,142,91,145,2,236,199,21,41,126,211,21,24,202,123,195,195,19,226,123,206,95,106,229,68,217,86,130,207,105,198,92,30,21,234,230,132,85,212,62,252,224,83,46,214,134,10,155,242,172,13,251,156,227,120,205,95,162,172,240,161,162,12,87,187,202,206,26,38,129,7,24,220,158,233,118,193,185,225,222,233,86,42,86,34,55,233,108,184,210,98,66,167,90,22,84,232,115,195,150,1,29,53,212,163,121,68,117,4,185,102,50,162,76,174,193,22,157,128,210,117,68,3,78,39,8,26,245,65,96,179,189,13,160,255,221,189,165,118,6,126,1,188,197,99,147,110,114,67,15,89,67,111,209,43,114,202,82,103,80,70,131,38,187,185,83,60,132,134,157,158,193,143,232,84,134,46,117,229,80,102,92,141,131,142,247,221,119,98,120,134,207,0,188,165,58,23,232,124,243,250,113,250,155,254,253,168,145,242,229,51,94,248,81,251,56,30,37,108,7,11,139,255,84,105,47,174,25,4,142,56,69,183,141,6,190,7,89,61,91,167,248,209,182,66,10,166,54,163,131,129,157,82,172,252,237,206,214,51,115,175,204,35,232,18,113,120,115,244,231,46,43,85,35,3,151,37,111,16,148,15,226,90,43,60,251,20,120,57,235,174,164,81,11,2,92,45,246,232,209,99,255,159,195,139,199,255,176,132,153,63,118,254,71,156,52,162,210,197,117,118,227,4,19,180,23,197,120,218,252,108,53,181,57,159,115,233,141,111,42,83,168,46,77,74,235,100,88,161,128,50,14,85,136,176,131,222,0,50,159,102,131,148,179,205,108,249,94,163,105,151,77,182,197,159,173,49,72,140,64,206,215,225,150,31,45,232,69,237,188,235,127,155,196,46,79,209,243,153,184,74,49,189,29,115,72,7,122,245,143,172,177,168,68,238,35,21,154,63,207,128,143,61,154,3,122,195,224,186,162,236,35,225,150,42,244,182,230,226,174,32,147,21,238,185,64,242,231,32,201,122,186,106,160,219,65,55,14,129,19,157,64,213,191,230,60,112,225,153,7,171,63,53,61,93,29,249,241,34,193,59,89,250,19,222,227,126,8,14,83,123,33,167,180,217,16,28,46,167,189,92,140,57,7,63,20,62,108,220,103,129,174,32,11,220,254,185,137,107,214,190,205,125,208,140,158,238,4,233,177,202,155,92,43,3,133,248,9,203,162,64,30,10,232,91,41,123,4,185,98,60,30,102,193,201,86,181,39,203,114,170,47,161,161,245,1,190,34,175,119,233,138,191,24,91,242,245,238,189,150,101,0,47,115,68,210,214,39,27,18,120,149,251,225,41,104,149,79,30,124,40,17,243,20,188,21,158,64,195,126,234,63,185,37,232,180,249,65,16,52,60,244,133,188,219,22,71,123,42,231,173,65,72,133,224,20,22,78,195,76,0,172,228,12,226,64,94,118,66,199,149,53,217,214,51,19,138,96,228,155,200,219,26,163,193,111,80,209,96,78,50,21,51,80,215,59,58,177,65,103,202,142,50,234,172,132,254,0,16,252,97,197,151,184,97,228,58,118,23,208,142,142,97,152,41,56,51,31,129,107,103,91,124,117,90,21,224,180,191,74,183,60,4,147,204,29,58,102,86,18,150,100,53,50,127,35,255,184,88,227,96,109,194,234,208,35,94,36,153,81,142,76,37,189,74,232,86,213,198,93,24,176,47,133,142,118,43,76,74,2,210,112,70,66,69,86,73,37,220,84,71,202,104,112,57,83,235,54,106,237,216,23,98,235,231,70,73,55,201,39,42,189,139,126,145,111,62,235,41,254,214,203,102,135,189,60,20,85,216,215,179,177,57,96,130,48,229,209,241,191,143,96,68,169,170,87,197,114,83,244,249,250,182,138,228,102,50,240,115,250,155,42,244,119,10,190,128,63,203,207,72,254,115,111,132,246,115,125,10,187,169,7,104,50,14,189,106,75,244,235,89,148,47,77,56,13,185,230,51,161,212,132,15,147,41,98,40,247,137,228,66,29,229,226,204,51,169,34,69,116,35,168,108,23,28,92,188,73,38,184,91,55,228,205,154,71,244,136,130,122,242,4,104,120,235,76,112,53,104,165,228,193,190,173,174,31,29,136,119,141,42,85,247,140,120,114,35,159,108,187,254,139,82,201,144,46,130,89,240,185,75,101,19,198,98,116,132,191,237,83,230,253,230,165,222,41,1,37,162,42,255,82,12,135,178,33,200,30,125,232,19,110,127,93,193,181,123,227,71,8,37,0,127,134,220,166,215,204,36,73,154,241,210,143,168,255,190,23,133,175,130,243,218,31,36,214,141,211,112,161,222,79,34,252,238,217,74,118,74,205,218,231,247,29,248,42,4,8,100,211,48,114,217,141,55,179,41,35,144,196,124,9,130,118,29,188,2,89,109,130,29,86,31,216,169,166,30,81,155,149,206,253,235,73,186,130,80,83,109,151,212,21,64,35,188,119,125,149,32,77,117,161,195,194,67,182,45,100,104,40,206,69,37,187,2,121,17,96,195,171,146,251,89,185,212,66,4,40,5,204,64,138,172,7,30,59,168,62,168,12,68,39,49,163,55,189,139,41,95,27,108,102,110,222,36,69,40,219,134,121,188,5,254,255,28,163,216,88,3,252,134,83,207,85,129,88,181,204,33,11,54,207,220,221,236,54,171,87,186,14,93,27,160,108,115,61,0,128,6,144,229,19,37,253,1,27,7,35,237,145,67,93,235,187,172,39,206,221,234,64,163,29,45,199,203,207,38,132,86,159,177,39,179,30,45,135,222,240,119,145,129,88,0,75,83,247,249,189,228,127,16,107,39,183,228,82,143,109,232,121,74,35,184,86,201,134,94,180,177,166,183,101,115,175,162,56,214,67,203,157,16,176,79,61,237,133,241,4,193,170,108,222,198,161,82,20,241,165,226,160,176,6,77,160,214,167,22,67,241,202,161,27,45,191,34,240,137,119,64,197,114,111,37,203,159,123,49,90,17,138,41,124,12,1,99,74,37,238,4,220,233,184,119,4,104,37,113,210,106,78,194,53,128,2,100,161,161,99,248,0,12,52,144,253,27,81,82,96,10,107,80,199,253,233,81,179,80,169,59,129,221,229,240,190,69,76,241,51,62,47,174,131,76,108,226,227,120,84,253,205,106,72,136,223,204,227,112,249,170,145,199,254,5,228,132,144,161,104,91,183,3,180,118,153,102,209,68,68,203,169,105,107,186,174,180,153,16,81,87,101,76,203,190,234,117,147,135,101,241,198,245,39,55,91,46,221,114,5,242,77,107,6,37,238,107,114,152,110,115,143,107,100,57,232,3,27,182,183,147,94,70,161,4,151,214,179,197,39,131,203,71,28,139,37,23,131,169,228,91,211,35,24,165,77,168,91,94,85,121,67,92,22,187,254,77,140,215,31,64,224,66,77,196,141,237,61,134,117,5,219,167,21,244,26,47,43,26,207,183,179,230,210,109,243,184,60,57,171,162,242,156,11,136,11,36,60,74,251,172,39,85,211,79,32,26,196,100,185,121,175,206,12,2,6,208,89,132,146,77,28,134,134,173,17,197,129,151,248,171,166,182,20,46,234,166,231,116,250,209,80,214,194,16,252,95,116,221,215,162,108,239,53,137,119,10,48,56,207,228,96,151,117,143,158,123,161,234,29,37,125,185,34,227,169,100,242,235,75,168,127,136,32,157,97,17,61,184,35,156,113,170,31,194,227,129,46,188,117,149,62,207,120,50,43,146,102,105,170,43,196,63,137,155,247,177,69,214,61,24,125,196,31,107,117,46,172,142,253,244,106,32,171,100,86,180,96,52,129,205,22,136,111,227,106,234,32,180,11,168,240,38,44,191,8,96,141,178,205,232,136,119,52,148,98,196,40,129,160,135,119,28,35,21,26,182,94,48,30,100,51,40,183,102,165,147,196,39,23,227,50,33,249,243,255,56,156,205,36,54,9,14,223,18,118,128,152,47,107,154,17,16,86,101,227,76,121,125,161,70,6,215,23,235,189,134,207,240,218,127,41,91,125,212,82,201,217,85,40,32,190,73,66,229,108,106,123,151,158,75,42,115,57,224,23,3,186,243,18,103,65,148,23,17,214,220,182,157,80,183,135,174,97,69,89,157,126,182,54,39,239,215,32,10,168,2,215,21,138,150,167,43,168,175,108,19,175,129,139,101,35,202,171,103,26,53,174,114,253,195,184,116,53,35,222,25,47,13,60,147,87,152,4,112,245,240,58,55,141,23,198,30,218,230,23,192,95,214,137,130,240,239,26,106,166,177,95,242,85,144,180,219,251,247,224,41,20,206,71,58,89,213,147,242,71,197,251,36,146,96,44,57,28,125,140,245,104,79,67,252,186,99,252,80,83,64,224,135,146,110,122,81,10,125,219,146,248,84,87,110,212,157,3,254,167,43,88,210,24,195,8,94,150,93,67,202,143,204,211,164,160,228,133,56,121,166,111,124,238,174,61,138,191,28,184,201,202,184,168,136,164,118,221,17,156,59,108,172,176,90,95,151,106,126,65,229,234,64,175,231,95,109,199,8,253,146,249,213,133,55,27,56,7,149,94,122,220,212,159,77,193,102,116,143,241,23,109,209,77,116,28,224,132,248,152,176,238,66,110,207,230,199,107,144,12,41,114,221,124,254,9,56,4,25,126,155,25,78,94,171,207,80,220,158,65,66,175,138,166,154,98,20,227,104,156,36,32,171,26,175,206,118,64,112,125,170,148,66,174,175,91,169,148,218,235,109,76,60,69,121,192,100,205,7,246,118,51,249,102,46,58,98,159,4,36,109,11,245,80,90,66,251,214,1,218,168,236,148,169,230,176,15,188,7,152,190,190,202,63,3,251,78,141,88,68,192,15,144,104,191,236,135,31,58,114,137,116,139,179,24,87,24,2,84,203,123,250,254,254,131,88,238,168,117,138,143,11,133,140,183,146,253,76,132,251,51,9,236,238,69,60,24,48,58,65,72,198,225,171,33,39,46,249,217,224,57,80,41,248,176,77,26,24,65,87,64,143,191,248,177,74,50,226,248,111,178,42,185,171,162,19,87,241,57,154,202,69,203,11,49,236,27,146,135,18,188,155,25,68,178,5,77,236,48,81,115,137,248,113,90,83,39,52,252,165,29,179,91,173,37,94,81,70,108,210,246,253,107,160,224,35,161,33,160,12,8,31,250,203,209,144,50,3,5,13,194,143,196,234,152,14,40,252,224,115,64,94,131,43,134,33,144,117,239,196,60,124,136,107,193,142,91,158,20,187,101,98,114,200,117,85,120,65,23,233,223,53,45,106,78,160,0,29,143,34,10,105,216,47,105,214,215,73,251,150,238,50,180,242,195,129,169,189,212,252,131,99,41,88,193,84,49,39,161,177,84,22,122,183,95,35,13,148,45,140,252,27,221,143,67,196,158,64,124,237,235,180,216,106,114,118,62,30,136,236,100,140,231,116,120,31,238,124,64,61,244,101,75,220,190,183,175,26,250,43,75,199,110,159,70,104,187,48,58,205,114,98,98,158,44,191,247,61,73,170,246,172,166,179,218,49,46,33,242,219,53,114,174,175,125,253,223,204,214,8,249,41,135,24,179,189,8,159,116,57,124,138,190,100,165,143,51,48,108,188,108,245,75,174,216,220,134,187,200,194,60,171,125,185,244,89,97,10,103,212,126,224,39,105,103,239,77,36,135,185,117,105,178,185,155,76,54,12,113,236,100,135,24,98,126,118,230,82,174,87,30,73,97,116,150,74,20,48,148,55,240,106,48,236,136,146,56,15,23,252,54,14,31,119,176,60,100,74,41,136,202,195,162,254,145,145,208,37,5,98,145,34,96,147,117,221,128,138,166,177,244,117,130,162,93,230,172,154,234,72,151,6,21,99,134,251,223,117,100,205,175,19,22,136,219,83,197,2,33,90,25,32,148,206,200,190,104,241,4,177,215,17,231,234,97,106,138,142,204,2,254,78,52,27,34,237,176,66,150,219,15,134,106,56,190,33,83,172,136,23,144,79,253,226,25,142,240,53,111,87,176,203,92,161,100,247,200,98,122,171,29,205,8,10,159,148,88,43,14,58,103,136,243,124,210,100,161,103,30,241,90,149,218,129,90,188,255,246,73,65,37,169,157,108,188,54,163,21,231,192,101,147,158,4,239,112,232,32,14,13,188,0,36,77,177,87,246,166,167,196,102,32,167,12,174,67,10,131,61,35,77,33,100,210,178,203,115,58,237,91,213,83,250,167,237,112,230,128,229,58,8,190,174,44,26,76,207,74,124,141,91,100,18,196,19,10,60,71,203,45,219,244,132,137,154,189,148,211,177,89,81,158,81,66,55,215,151,35,69,114,246,15,115,124,133,164,64,225,217,61,125,113,30,113,24,203,94,168,29,38,147,18,138,19,6,48,52,113,88,214,79,121,198,204,242,120,132,207,111,126,242,194,178,166,128,75,103,24,187,98,164,192,47,72,237,9,131,162,102,173,238,38,126,237,230,222,88,235,236,53,13,243,213,204,5,207,4,95,40,230,235,179,116,51,129,40,166,1,150,157,68,242,53,20,227,251,228,223,152,120,14,5,21,74,219,117,183,36,204,128,204,37,182,154,177,113,192,89,250,146,145,223,218,4,165,22,251,127,16,90,254,180,132,4,239,62,112,230,32,185,161,56,248,174,188,76,222,232,101,42,63,77,122,111,193,125,121,56,204,36,127,114,223,138,61,24,114,161,126,157,163,112,1,145,39,35,29,202,175,115,232,158,2,47,153,65,10,104,214,53,215,199,5,33,226,182,35,122,202,200,57,16,3,119,168,114,185,125,71,16,66,110,234,98,255,90,18,252,228,90,250,145,218,56,116,250,117,160,217,12,38,56,64,251,2,166,34,130,49,227,101,75,27,177,153,108,140,254,44,47,243,164,180,251,82,75,70,3,231,144,194,120,89,191,34,43,131,177,83,188,175,188,67,218,188,161,24,74,130,175,16,216,220,82,197,47,198,61,115,215,235,91,119,167,204,189,25,31,233,143,18,84,138,126,178,168,247,44,72,56,98,85,102,9,226,45,197,181,235,180,177,202,69,220,159,183,112,206,86,168,245,158,133,56,203,12,119,22,4,118,177,38,4,202,63,154,227,110,231,90,11,78,119,27,242,40,226,103,118,181,15,53,254,253,238,127,150,53,133,76,69,146,218,116,221,29,35,220,242,160,19,98,73,181,37,189,250,183,59,116,153,178,3,17,186,42,153,28,187,233,230,237,141,240,177,67,254,39,224,255,70,135,161,122,216,211,35,174,191,185,71,78,60,216,147,99,93,127,236,67,171,177,80,23,100,224,134,150,169,200,113,30,34,54,178,66,50,186,203,157,8,238,146,95,22,133,63,160,143,30,196,42,173,123,20,161,12,73,114,21,128,136,168,18,14,11,237,71,113,99,53,93,247,71,87,158,173,144,139,45,195,92,99,9,67,89,83,39,129,182,33,213,196,187,47,14,150,184,143,17,41,167,123,39,140,155,142,70,80,220,40,118,136,176,158,206,72,27,136,33,119,66,73,50,16,7,242,86,200,33,223,83,182,113,236,133,153,34,114,73,163,192,5,76,199,131,178,157,159,84,42,210,133,68,7,252,96,238,104,42,133,75,223,119,232,21,6,149,121,87,227,235,60,148,112,11,5,211,166,104,111,223,119,138,78,219,47,59,193,229,226,213,76,106,114,106,214,213,110,23,142,83,97,27,185,115,75,90,111,61,138,76,234,147,214,26,221,108,87,113,23,123,109,77,173,104,146,56,88,73,154,202,181,113,182,48,1,186,53,155,7,10,242,168,118,54,16,241,11,79,15,194,103,194,115,121,162,113,81,83,186,157,104,9,106,34,168,131,158,133,158,73,6,119,126,133,222,5,86,23,30,137,173,75,158,193,181,125,145,81,208,216,78,185,175,222,166,187,227,196,69,106,53,56,26,23,156,191,77,188,224,239,47,0,150,178,111,135,242,81,227,160,130,69,255,48,204,95,74,182,203,32,232,148,43,61,255,45,105,115,204,182,38,156,137,129,26,176,36,218,115,113,106,212,230,213,46,81,90,73,240,197,204,72,112,68,205,118,15,7,245,246,45,133,16,30,190,146,78,227,209,218,195,127,93,34,88,12,140,111,210,163,183,4,102,241,58,135,78,220,152,59,21,9,98,27,51,161,39,125,21,81,133,238,162,235,159,121,146,45,159,147,150,102,171,243,117,50,189,213,159,234,18,234,51,22,196,235,78,230,188,253,219,73,250,195,64,197,118,37,139,153,186,168,34,106,103,115,55,86,91,174,253,147,129,99,175,252,61,89,126,131,91,139,208,201,118,249,18,149,176,157,245,34,176,197,2,147,252,105,166,45,195,132,106,76,249,96,10,159,145,227,197,124,244,76,199,139,117,44,73,53,231,90,245,150,102,47,193,250,237,42,253,122,160,5,145,173,252,209,74,147,118,73,202,26,132,233,90,55,32,3,180,206,232,129,37,239,141,164,151,73,174,52,48,153,109,249,80,139,114,65,91,141,143,170,128,170,104,248,61,6,129,110,8,25,118,139,91,243,175,118,107,128,78,252,173,25,46,208,108,49,14,51,60,251,177,187,32,169,68,207,254,138,211,229,118,197,171,104,171,84,34,39,52,26,169,237,54,3,88,235,249,142,51,150,165,216,27,230,200,184,206,55,205,212,214,69,144,7,155,49,113,80,148,5,182,17,132,144,253,6,96,251,221,78,92,19,125,193,228,95,185,29,157,183,219,12,21,241,170,113,78,250,165,59,67,80,153,176,104,202,226,82,6,164,251,168,85,168,55,195,46,226,33,133,2,14,158,121,59,155,200,248,119,21,129,19,37,161,184,114,252,49,151,69,133,235,232,233,132,28,4,66,235,179,182,27,192,27,144,252,140,99,48,70,195,58,185,118,137,148,194,129,32,46,111,237,215,254,60,115,6,223,108,150,42,64,96,195,118,226,169,81,37,91,82,117,135,81,112,68,17,110,187,128,76,76,29,90,8,67,238,100,35,41,240,138,51,113,54,19,122,136,188,174,23,58,34,202,54,56,233,245,18,33,183,144,245,37,160,254,101,121,114,242,14,12,111,122,136,68,156,15,83,34,86,20,102,65,196,51,242,5,75,231,65,175,114,155,44,188,10,146,47,176,91,59,152,189,73,43,40,188,117,153,180,8,18,68,228,229,191,156,59,246,236,100,187,44,127,106,234,26,118,19,171,235,37,161,130,38,252,112,124,45,245,80,242,216,95,172,74,29,75,78,204,205,103,31,66,168,103,226,144,97,223,115,192,222,134,181,239,150,35,143,62,177,226,5,166,146,4,166,17,162,31,251,100,202,253,139,41,105,81,172,111,69,24,88,43,104,6,88,106,255,148,200,37,60,201,92,13,217,142,220,43,1,127,75,250,110,153,81,41,228,50,2,246,38,59,8,110,59,105,244,202,73,102,102,182,219,234,181,213,232,165,123,161,133,147,62,198,3,219,138,153,2,203,5,93,10,4,54,143,84,189,2,212,52,182,153,167,12,42,135,246,187,199,76,80,114,251,8,99,60,142,70,115,175,176,65,152,114,16,158,30,88,46,225,64,60,26,100,40,230,112,110,33,238,162,54,180,208,229,211,52,225,78,114,163,224,144,26,65,203,129,190,51,180,89,219,67,204,165,32,55,166,187,146,21,204,153,89,61,2,88,142,29,89,49,91,173,86,47,113,48,20,195,168,154,125,247,37,102,194,227,46,185,75,6,208,58,201,131,158,190,18,6,12,76,207,123,124,219,148,249,72,222,222,174,228,161,160,31,35,246,194,149,113,166,16,121,52,158,194,170,240,190,23,204,143,215,31,233,233,174,159,234,233,72,19,206,27,223,16,68,186,100,224,187,45,246,158,97,93,109,144,176,152,126,235,21,75,183,205,178,192,7,88,38,45,199,218,140,219,247,162,252,102,12,195,153,108,228,11,59,118,245,199,10,47,240,155,196,206,101,92,210,132,213,219,31,145,179,65,133,191,227,115,107,6,82,100,98,14,173,59,99,229,176,47,206,40,25,207,23,10,3,24,218,150,9,171,60,72,27,107,194,147,93,166,230,70,114,201,255,14,83,74,130,86,146,243,138,242,17,20,148,87,29,167,210,193,142,226,234,197,34,175,251,60,163,131,67,210,27,135,42,108,232,181,132,0,15,65,122,62,205,237,177,5,163,143,20,90,184,90,212,8,8,59,249,234,87,105,210,74,152,46,153,157,85,149,73,116,3,228,151,201,240,176,230,80,98,169,160,66,36,219,180,91,200,193,84,57,49,195,123,201,146,220,16,106,35,236,121,236,245,106,201,174,119,250,191,227,179,235,231,194,125,104,172,183,162,124,253,155,55,160,42,69,100,20,193,212,116,119,97,243,63,240,61,242,238,82,154,255,100,55,60,205,1,105,255,33,162,24,77,248,95,255,2,225,34,207,18,248,108,159,66,120,117,233,8,230,128,24,16,116,53,237,158,165,141,180,62,113,187,211,96,199,154,190,145,182,187,174,205,68,218,160,250,203,2,37,111,156,37,176,68,199,137,63,81,150,157,137,85,129,152,253,249,128,172,129,125,98,120,99,18,196,86,151,61,202,100,108,51,238,147,157,45,230,106,82,6,241,105,101,95,154,159,227,104,71,210,253,225,93,34,150,200,47,228,223,25,187,91,53,103,111,163,253,5,253,41,64,104,188,92,228,128,3,175,10,240,67,92,40,6,224,242,113,103,232,4,26,96,171,38,252,82,133,149,163,56,40,217,146,20,4,138,33,161,35,153,182,6,45,13,202,230,14,19,21,83,147,120,36,158,202,154,42,179,133,179,75,3,103,131,170,84,122,42,7,112,151,115,11,28,254,43,36,136,83,34,41,11,148,86,101,49,104,64,165,171,126,234,68,73,117,158,79,161,246,119,144,150,49,135,186,170,46,36,192,75,53,40,242,88,191,14,59,139,150,197,246,163,209,126,134,222,59,133,52,90,114,44,204,210,243,93,108,197,185,101,244,48,100,244,11,195,49,227,140,240,107,186,16,108,84,241,203,15,32,65,35,164,126,83,190,183,214,59,78,251,21,246,131,29,146,225,83,203,6,81,110,177,135,136,202,170,164,88,52,200,133,185,10,168,237,154,223,228,7,219,0,98,145,134,62,86,226,150,157,51,107,60,146,179,230,10,135,213,179,220,32,135,15,34,154,231,75,253,168,202,79,95,63,94,12,224,249,182,247,222,52,109,243,205,3,90,74,148,93,188,237,60,49,79,139,120,77,156,180,40,250,163,243,234,112,107,58,13,115,228,123,6,207,214,38,20,242,221,90,42,48,215,179,2,28,162,28,36,47,155,115,102,100,139,1,56,191,14,113,2,84,150,155,225,231,175,211,95,138,46,199,248,41,121,4,159,196,179,192,162,153,120,193,102,62,212,8,131,60,95,101,177,48,125,170,46,17,93,92,175,32,77,171,177,60,112,187,139,221,37,226,6,213,13,66,179,54,254,178,114,173,98,3,189,208,132,105,130,65,139,175,191,251,75,15,157,109,252,153,26,75,102,212,158,112,129,178,141,132,130,121,104,96,243,20,219,122,160,129,149,121,189,41,138,221,164,2,250,124,102,102,19,153,168,130,95,74,162,172,57,66,172,133,255,29,0,103,160,132,227,8,101,74,143,206,171,33,113,39,151,66,118,208,98,48,226,175,176,55,26,161,151,12,169,51,132,34,201,116,202,22,82,110,29,81,65,54,209,166,5,15,179,169,34,154,132,221,140,36,167,0,242,211,239,125,244,46,217,26,196,57,44,181,118,10,134,136,213,144,196,145,99,41,156,68,169,126,202,119,28,252,106,173,169,115,110,241,50,70,226,56,229,121,59,103,33,242,109,16,25,69,253,80,184,38,147,103,155,63,165,105,174,183,250,201,75,21,234,18,185,235,253,156,120,219,133,96,244,148,150,110,61,230,174,61,204,167,3,217,138,232,229,29,202,185,16,193,189,152,141,148,152,12,109,211,213,57,120,158,53,47,210,196,10,166,51,220,58,19,172,226,116,120,189,93,9,22,51,133,224,18,175,47,16,68,66,75,134,74,243,164,62,167,100,96,130,157,218,46,100,245,159,43,153,177,168,103,151,223,92,0,210,12,252,187,111,96,115,57,174,170,129,200,180,12,115,10,251,162,240,202,28,234,24,141,144,93,166,0,169,250,198,21,222,235,98,38,198,127,60,50,220,38,99,66,139,55,23,204,36,245,46,157,72,125,193,224,33,98,250,223,155,129,30,13,220,115,85,149,105,140,115,56,218,76,165,182,207,196,177,91,248,150,171,161,41,80,125,79,197,38,6,127,99,163,220,35,109,63,60,172,155,72,255,184,206,45,9,217,130,121,130,188,225,207,230,133,47,184,34,58,40,157,10,76,186,32,182,163,61,28,176,87,132,127,38,251,63,110,168,225,77,201,60,172,53,179,80,146,114,44,173,40,122,144,206,176,69,65,238,93,80,206,121,126,1,113,45,20,252,237,250,109,179,229,97,34,21,151,224,240,226,10,145,36,34,230,232,29,241,192,75,236,16,92,231,178,190,174,146,153,79,213,55,104,61,190,164,41,203,7,219,167,199,184,5,98,34,215,107,189,247,110,19,123,120,21,36,62,76,91,127,121,84,104,124,199,75,121,25,198,217,125,131,47,235,0,97,146,98,30,221,240,206,198,33,131,91,235,250,119,159,192,134,110,82,40,189,194,134,94,34,38,89,42,141,180,70,93,140,218,85,36,39,40,70,237,85,40,146,148,196,74,255,238,43,56,183,106,245,130,54,127,159,190,243,172,175,35,252,191,59,160,217,223,86,63,204,135,5,244,106,85,20,21,21,142,74,238,170,180,139,149,224,252,201,197,253,56,206,115,133,243,122,224,130,77,82,130,239,249,102,117,5,215,86,250,31,13,56,229,234,142,190,240,49,142,160,77,113,100,225,246,21,205,151,18,111,39,189,224,237,27,129,77,161,135,112,5,132,144,106,118,188,144,129,1,247,249,216,88,199,137,107,226,76,4,151,24,195,199,204,35,13,250,179,55,202,66,13,1,168,251,50,166,26,32,22,182,165,10,141,158,11,111,76,50,100,16,41,44,24,101,20,193,38,155,19,181,27,225,176,242,25,47,208,45,250,231,251,236,118,121,165,35,24,104,49,167,118,96,4,137,167,121,124,169,142,234,43,45,167,219,74,14,146,157,124,232,242,43,112,18,192,61,30,59,244,252,4,74,139,187,67,154,62,200,89,168,138,85,170,48,216,88,3,219,225,176,239,5,30,20,159,47,127,237,113,39,222,247,39,239,254,213,6,23,163,94,166,113,91,86,37,88,230,26,183,136,108,117,219,204,203,116,25,78,68,165,149,209,164,9,24,169,186,0,66,81,101,217,49,6,211,137,18,200,155,103,47,131,180,21,63,206,29,94,99,140,157,96,230,133,23,88,14,88,91,115,69,246,239,62,38,177,55,187,35,212,232,54,102,61,71,16,13,187,120,100,210,38,190,76,216,49,76,183,14,1,181,213,169,215,65,107,158,76,83,138,216,135,162,179,161,172,188,163,156,123,130,36,213,10,219,98,62,125,78,15,47,70,221,4,203,83,4,128,45,136,201,74,40,225,242,126,75,70,152,89,238,240,155,74,89,115,92,76,235,173,52,56,6,129,163,15,12,97,29,80,156,102,155,75,142,156,184,166,26,131,136,93,159,164,110,67,138,255,32,43,104,234,248,152,62,94,2,151,56,57,146,23,72,86,55,225,117,196,61,91,93,116,57,108,206,88,175,237,188,183,143,137,254,135,131,100,44,208,67,170,152,206,183,97,99,43,151,68,99,111,194,210,255,16,99,143,59,124,145,220,116,77,33,8,238,202,108,35,28,78,8,165,254,79,112,180,28,59,211,68,245,224,109,87,121,131,156,254,51,0,45,163,125,152,60,207,105,157,115,215,49,53,194,70,92,189,125,190,178,192,69,20,36,244,229,52,21,27,250,8,7,104,63,13,88,86,167,6,34,11,212,105,167,10,193,252,120,73,37,47,59,162,219,13,113,167,17,210,3,119,222,243,178,95,191,61,206,122,39,240,26,125,41,63,172,114,170,193,108,65,139,243,218,4,225,235,82,18,45,244,125,22,50,114,64,62,59,135,13,49,234,112,238,54,15,203,133,236,70,5,152,26,12,16,53,204,154,215,186,137,68,228,155,230,211,44,35,249,155,17,160,168,244,102,202,14,106,208,212,141,240,107,224,191,113,237,197,239,53,123,243,106,142,130,118,96,74,148,3,137,35,144,177,1,113,153,121,49,77,233,37,103,0,92,110,78,31,134,153,195,120,23,134,109,22,250,102,30,153,140,195,233,100,169,109,143,241,24,162,180,121,147,245,169,54,214,105,138,158,115,236,153,105,5,0,180,142,97,246,96,111,164,17,51,122,165,164,199,62,20,69,250,127,100,196,6,142,216,225,255,222,13,87,237,7,163,200,4,133,203,167,60,73,46,44,36,140,181,97,12,141,29,202,149,137,186,52,144,213,208,195,6,36,186,195,75,148,194,10,231,190,171,253,142,68,168,57,192,39,145,127,117,147,42,127,33,14,105,153,157,100,166,74,56,42,153,26,37,254,12,189,93,214,131,12,184,172,175,61,183,1,206,170,45,120,107,157,113,148,230,15,212,165,190,156,139,63,134,28,121,75,179,131,180,119,227,149,8,57,214,49,71,154,139,117,148,72,54,231,118,104,145,78,171,225,154,40,45,147,227,87,162,213,238,243,200,71,201,129,110,151,69,65,21,108,232,176,58,230,214,97,89,99,237,76,76,188,55,111,254,161,190,115,180,150,37,136,233,132,237,107,247,142,115,87,28,187,161,43,214,237,84,182,77,62,123,110,73,33,222,80,234,70,111,77,199,220,161,103,31,131,95,50,170,30,148,17,179,249,208,145,157,223,69,23,67,54,176,131,72,145,214,50,71,94,203,133,69,93,46,14,170,130,39,187,84,229,160,24,168,92,227,149,173,61,240,57,111,234,69,119,113,101,211,60,5,92,201,173,175,137,236,254,9,105,252,211,250,189,24,164,185,10,140,149,241,98,222,255,6,225,110,41,252,81,124,72,243,73,10,33,85,156,192,14,230,70,35,106,12,54,118,67,28,191,81,211,105,53,121,102,1,128,184,49,199,251,169,148,211,64,181,19,15,166,137,20,198,102,234,6,65,115,247,70,235,76,43,168,78,66,146,144,228,199,104,179,103,76,130,118,90,24,82,255,109,125,151,94,122,109,86,87,76,203,186,77,200,244,20,150,205,58,48,146,71,173,93,75,77,33,20,128,243,76,180,81,86,82,160,135,254,196,52,248,21,75,1,135,203,80,210,223,110,13,105,20,104,31,5,90,242,62,110,189,43,218,58,1,93,111,210,127,196,245,67,90,160,111,62,12,229,249,52,73,144,104,35,163,21,4,77,255,25,18,105,112,56,5,81,83,122,209,67,59,56,186,74,105,234,175,36,192,164,169,175,45,143,181,214,115,157,165,167,28,41,145,202,98,183,179,85,32,79,240,196,130,63,224,83,142,251,152,204,205,42,10,103,36,249,39,37,32,82,33,240,174,243,170,87,126,10,178,120,55,193,53,34,184,192,12,119,74,87,210,238,238,222,36,55,87,78,55,237,66,69,32,37,109,133,160,53,248,84,65,38,220,79,99,205,72,109,132,30,254,161,87,27,190,242,250,28,151,164,116,16,236,165,45,31,24,198,236,228,201,229,209,31,131,49,21,255,36,65,38,79,57,100,210,73,14,110,56,157,238,24,86,108,150,208,26,164,6,51,93,131,161,62,176,78,34,83,207,44,38,166,100,105,50,152,20,56,175,184,176,208,51,92,237,203,23,84,58,253,111,43,203,198,189,187,73,13,228,47,153,205,174,43,183,179,104,229,201,124,55,36,88,239,114,117,206,187,208,189,28,132,121,89,10,18,59,144,100,63,24,109,20,245,115,152,211,162,179,100,253,72,82,135,248,147,153,90,34,247,24,48,181,220,71,229,147,105,111,143,113,27,49,20,59,173,126,207,22,29,22,222,104,120,253,139,91,164,23,175,3,73,11,130,101,39,101,135,30,185,76,227,168,226,138,98,145,35,103,123,183,210,222,179,15,121,241,145,252,104,116,137,174,121,167,147,156,14,65,79,155,141,248,216,48,55,3,122,132,253,104,214,211,62,104,6,154,197,45,229,178,30,125,59,34,231,24,150,147,23,17,114,74,249,46,161,40,18,176,102,194,133,30,230,208,4,54,88,141,27,59,41,73,71,72,22,203,149,23,29,205,169,134,130,190,108,94,192,153,42,229,179,78,8,43,251,151,108,30,142,74,104,127,217,137,207,16,7,26,23,34,110,31,243,151,100,102,147,117,78,33,155,198,29,68,1,130,20,130,70,36,122,1,237,122,244,124,125,130,167,254,233,251,239,90,202,21,73,96,11,201,25,191,116,2,112,160,7,164,105,180,181,56,191,190,24,108,231,179,82,55,36,138,54,38,2,201,231,232,122,112,125,42,99,30,26,230,189,252,253,194,115,152,246,229,241,181,248,82,152,109,201,198,165,214,246,53,120,98,22,90,221,90,168,197,159,195,52,153,211,214,36,240,88,122,227,118,215,176,89,205,183,217,146,126,144,34,20,230,84,245,31,241,22,21,17,53,178,253,5,160,151,251,38,47,146,171,63,227,25,237,164,85,15,190,160,37,3,0,44,123,17,156,194,61,11,177,175,65,208,202,189,30,19,150,197,17,150,182,43,29,28,184,56,54,139,145,86,238,14,67,34,84,134,188,158,212,43,238,82,44,139,85,133,7,235,181,93,165,194,172,157,37,183,222,63,146,211,176,172,81,107,155,153,40,123,2,83,206,139,80,248,234,81,122,134,40,140,178,79,173,52,55,222,177,211,249,186,248,94,254,26,144,78,17,109,124,209,192,168,241,146,164,212,110,166,93,105,195,90,140,56,172,44,1,168,89,116,138,180,241,155,24,43,243,77,77,157,250,73,126,37,81,76,50,60,134,226,67,242,85,4,59,165,46,60,195,106,91,135,122,68,197,37,227,191,255,236,184,242,132,195,26,108,75,100,167,224,156,37,174,108,26,90,39,47,240,197,140,160,132,115,163,76,77,74,182,22,128,229,88,73,211,109,165,145,14,155,184,75,106,62,146,16,160,113,90,80,64,229,251,10,149,73,153,171,13,241,223,37,63,154,17,82,1,202,1,216,72,233,232,96,95,89,56,194,234,181,226,55,254,208,34,206,96,140,90,241,240,99,51,131,229,221,2,235,3,11,234,93,98,6,77,236,37,11,76,209,118,36,252,248,195,8,163,49,250,156,146,235,26,151,116,1,154,162,108,121,53,126,88,253,254,161,34,181,39,49,38,162,245,111,116,1,107,188,48,128,43,245,213,51,207,59,1,5,147,93,44,104,94,139,61,93,121,39,49,24,55,30,148,191,138,113,154,79,51,190,127,232,146,47,4,182,243,119,80,96,196,18,99,124,153,48,38,130,253,63,125,208,112,178,204,70,195,55,67,14,50,132,13,102,222,2,196,233,23,243,240,65,142,52,249,15,249,164,100,105,99,139,166,244,62,197,211,126,118,189,73,126,253,133,110,175,70,249,42,13,205,165,49,222,159,16,186,122,85,120,54,179,131,91,11,57,193,19,204,114,197,247,89,115,104,52,168,172,22,225,58,208,83,220,163,191,12,173,121,103,153,217,123,39,14,37,11,50,115,142,26,253,62,4,187,6,56,179,239,86,21,106,222,99,199,50,132,222,186,161,229,62,34,71,160,161,78,27,129,227,121,59,34,154,12,150,38,226,237,161,53,225,151,126,87,195,243,188,19,149,18,87,84,70,152,79,27,193,11,183,248,112,243,154,26,116,160,158,245,215,245,245,207,61,178,40,168,170,158,29,246,3,78,168,168,181,67,109,51,27,128,49,134,63,194,105,88,38,186,213,20,52,169,91,233,33,155,226,13,131,209,154,33,96,139,231,90,44,182,171,137,95,226,21,163,113,17,228,176,156,149,150,190,104,117,203,190,99,193,132,116,101,0,99,148,89,219,90,41,15,116,88,70,94,181,50,107,124,171,145,117,89,52,232,246,41,176,169,95,247,40,70,190,203,144,191,124,162,158,28,215,116,20,80,140,87,172,152,236,55,98,158,93,216,168,124,129,124,156,132,120,181,230,197,197,187,148,226,208,160,2,199,29,112,9,3,88,120,0,126,228,173,47,95,236,25,152,212,217,213,127,223,45,236,234,73,22,149,85,60,50,52,99,38,110,107,55,202,128,65,180,34,218,9,78,174,117,177,134,178,156,251,127,111,34,253,88,145,17,119,175,100,13,41,14,30,42,64,121,99,195,42,83,30,170,26,121,86,113,204,109,189,146,100,202,111,148,196,240,67,112,112,212,183,56,91,2,161,172,125,131,222,234,218,97,146,30,201,156,40,22,206,112,241,16,20,55,1,100,203,78,61,132,214,15,207,106,85,28,60,253,241,3,167,119,41,109,103,230,34,111,177,109,167,161,194,9,143,126,102,243,142,102,17,226,103,64,51,37,116,93,194,36,247,32,8,231,244,16,117,20,252,75,202,30,33,138,143,15,245,22,246,24,81,115,9,63,31,19,132,42,194,44,177,227,17,137,215,29,126,50,108,73,129,91,186,158,221,215,133,241,128,227,96,155,74,127,95,29,226,192,10,246,71,200,176,204,99,228,119,141,176,136,122,127,24,169,228,121,141,158,162,236,59,114,233,65,72,191,118,94,31,51,10,66,117,27,209,254,19,24,31,78,137,241,7,91,147,42,127,73,12,21,127,11,92,45,182,226,207,241,182,244,253,69,221,26,4,165,233,232,83,180,149,65,186,0,119,149,122,127,121,14,3,8,57,169,253,2,66,152,255,219,130,232,225,206,97,142,255,144,117,138,209,129,216,221,19,234,242,152,241,146,70,193,23,119,56,94,93,131,167,163,193,16,254,132,186,142,209,88,163,0,220,88,50,184,95,159,199,123,26,128,213,115,116,146,23,161,226,127,172,221,128,106,41,190,10,23,209,13,37,57,151,176,90,43,238,152,219,110,117,10,78,22,164,3,98,131,113,150,13,10,159,199,70,202,48,141,88,164,96,88,198,244,130,157,147,25,136,206,205,105,172,12,178,180,206,227,125,20,240,157,237,180,124,22,98,123,225,96,217,26,35,219,209,234,137,44,201,194,185,104,206,207,118,223,159,146,58,237,85,34,144,225,49,195,74,164,15,21,166,121,169,222,14,210,214,83,204,118,86,21,121,244,138,160,40,196,15,48,218,163,80,89,246,4,125,64,219,40,115,93,108,1,232,72,140,51,124,181,101,217,155,50,14,163,74,29,222,131,107,221,141,234,120,19,98,55,107,43,95,86,202,161,155,65,229,184,72,245,221,188,175,239,250,133,190,141,189,121,89,126,156,205,75,83,33,170,16,14,131,34,128,198,44,126,17,179,165,175,200,78,252,88,14,17,164,237,167,137,82,71,157,75,79,222,67,169,24,60,111,234,5,248,180,214,134,248,255,135,240,18,44,224,102,215,244,157,182,84,226,42,90,42,95,193,160,128,119,31,214,79,51,120,26,146,86,246,30,75,220,73,253,255,249,239,108,6,232,205,254,28,30,59,67,181,210,229,49,67,206,32,236,218,188,0,170,250,254,44,138,43,145,116,147,114,207,153,130,234,113,154,246,32,5,144,149,38,27,106,243,99,2,208,169,47,88,233,122,74,176,185,241,32,146,234,12,13,97,83,43,65,196,160,219,240,176,157,52,169,170,105,85,48,229,111,148,25,166,228,92,12,7,85,158,55,67,101,61,115,202,42,173,247,41,124,13,244,255,48,229,105,104,126,102,167,215,236,230,170,43,54,57,237,83,61,147,94,223,24,221,35,19,57,129,47,39,67,182,206,132,103,10,140,176,78,12,128,119,194,193,11,166,168,240,112,243,78,10,162,87,241,24,132,163,81,24,167,55,228,20,78,165,51,195,44,42,121,54,79,110,250,137,139,201,70,121,46,181,87,181,64,18,18,158,86,229,72,165,111,168,90,90,137,221,82,9,238,157,113,165,92,203,173,80,231,236,141,237,31,224,72,216,240,209,11,250,79,165,74,105,21,183,8,61,106,122,146,203,190,174,5,176,119,58,243,131,58,153,168,107,53,100,249,180,251,45,92,201,205,45,241,156,226,218,132,5,63,222,180,189,235,233,188,1,8,66,148,216,141,247,106,45,163,88,200,215,94,189,114,43,222,42,121,141,23,96,248,160,191,175,50,226,208,31,249,221,76,171,21,248,238,232,34,94,48,216,27,47,234,128,49,190,5,168,1,189,152,196,49,156,12,166,96,111,175,86,134,54,169,181,6,191,17,209,217,145,252,236,153,113,9,249,62,191,16,142,108,27,177,144,207,31,159,111,123,220,101,179,142,205,24,95,141,229,216,164,255,152,47,36,128,108,134,109,223,202,86,3,42,145,32,121,203,193,128,202,160,140,22,101,238,231,157,211,129,88,48,49,169,43,102,11,80,79,5,35,81,247,43,24,104,166,121,44,125,220,255,15,135,64,199,222,80,203,12,217,129,147,205,43,111,185,104,227,23,174,194,165,179,135,137,203,235,91,200,58,117,89,252,2,156,157,51,125,20,142,32,46,57,11,127,222,82,83,244,228,231,180,0,58,2,151,210,177,114,33,157,230,10,103,115,19,111,169,21,162,146,115,127,109,68,232,101,13,33,22,118,45,44,144,245,36,7,211,43,60,15,249,220,45,67,179,3,235,9,167,183,161,201,10,45,97,105,172,88,156,232,58,249,228,15,54,13,132,29,228,200,111,204,53,245,232,0,79,177,153,119,162,195,14,36,70,242,193,62,151,21,200,110,67,144,25,63,19,186,230,186,18,109,5,54,115,7,63,152,105,123,196,141,86,3,82,140,50,58,21,98,36,197,151,189,214,229,27,198,5,209,251,43,35,141,134,241,5,183,193,199,169,157,15,194,27,136,200,150,146,145,90,163,51,116,42,157,10,232,13,130,149,55,43,102,127,161,13,14,0,108,153,233,107,53,238,208,52,162,3,112,119,170,68,215,196,8,122,110,185,194,36,37,230,11,164,227,130,96,135,245,3,120,35,110,54,81,243,105,101,39,70,161,196,223,23,189,77,27,208,245,220,46,12,40,70,203,81,245,190,138,30,134,227,183,35,145,220,184,25,146,212,85,212,69,56,214,0,90,196,10,50,65,51,98,250,4,52,70,92,250,49,89,181,174,182,203,151,140,31,170,122,114,101,132,131,171,118,134,34,42,45,23,178,179,176,195,212,138,166,96,127,51,58,180,90,142,48,3,91,191,207,21,42,38,199,71,24,25,9,37,179,249,100,58,124,244,118,107,214,206,22,192,175,183,43,252,155,105,35,106,200,166,155,254,7,233,38,90,169,133,198,182,98,12,9,76,215,4,193,54,25,42,135,78,232,62,200,19,30,201,219,72,211,34,222,48,242,253,10,206,166,50,91,38,160,22,74,27,109,23,121,64,69,130,205,252,161,249,191,232,3,110,187,248,37,230,166,124,30,204,152,253,234,119,3,18,129,58,228,150,211,138,248,37,70,48,125,123,44,2,131,118,184,6,217,91,111,128,96,255,135,183,156,30,140,233,183,97,63,180,170,161,12,231,94,214,11,74,199,111,212,92,46,31,16,86,137,186,243,174,77,84,69,74,78,138,161,163,186,201,99,80,14,121,149,183,127,37,104,236,109,131,160,20,88,139,196,197,35,81,140,187,173,38,184,122,249,23,235,226,187,188,116,122,162,231,171,118,40,240,217,131,140,65,75,139,143,244,2,89,3,113,106,149,168,105,10,26,212,10,252,23,69,241,48,4,198,87,250,221,10,155,117,239,170,131,203,80,41,75,156,39,100,210,155,134,134,252,183,106,222,91,110,68,225,192,242,107,237,87,22,138,212,42,213,57,218,76,142,82,63,140,215,132,161,228,136,187,202,36,253,146,90,147,84,81,225,105,217,159,84,88,5,253,159,73,21,159,215,73,108,214,95,3,98,245,39,157,150,173,232,251,228,203,142,63,178,180,53,110,80,155,87,104,231,120,35,79,109,130,97,162,89,90,94,237,3,143,230,139,223,208,65,48,10,165,60,41,247,124,139,217,40,219,47,93,86,181,205,132,34,167,193,172,69,159,172,251,15,5,21,224,64,253,225,223,6,93,197,239,7,250,218,198,35,15,207,61,213,85,41,152,3,248,205,221,33,21,108,252,23,199,3,157,16,109,229,178,136,71,167,115,197,81,159,49,110,177,180,28,106,87,251,81,161,65,60,152,244,114,62,11,255,169,191,131,112,118,194,213,24,60,181,53,133,67,226,56,17,218,24,175,94,151,189,107,14,6,103,163,109,138,57,29,27,246,185,79,134,173,23,199,118,45,202,65,30,166,96,174,246,28,134,149,144,38,158,175,251,150,136,14,47,121,206,144,132,229,102,144,247,169,114,239,132,52,67,21,31,110,35,138,28,11,67,53,172,99,201,65,86,137,89,2,26,236,0,171,130,65,101,29,75,38,227,220,161,90,178,29,100,157,64,20,196,219,214,239,190,176,20,20,188,24,232,14,184,34,208,81,137,23,10,178,247,223,238,55,150,7,159,84,254,116,55,55,47,55,244,27,119,168,171,53,106,184,26,99,49,4,81,146,102,49,51,178,70,185,194,42,108,90,150,217,80,165,142,23,34,119,202,20,1,159,18,114,71,191,224,241,168,151,54,126,62,90,186,119,104,46,8,29,33,111,115,160,82,137,246,148,216,197,100,143,53,109,51,107,111,212,216,149,150,161,201,134,29,137,140,99,219,61,94,129,134,184,88,228,202,84,49,105,243,116,196,59,180,20,79,5,154,152,97,205,166,40,240,179,70,207,186,67,162,130,139,168,21,47,6,133,63,96,164,46,23,112,236,75,80,232,6,117,97,245,164,63,98,213,163,113,89,121,96,171,58,147,0,91,5,116,229,188,248,179,228,90,242,203,43,179,188,191,147,23,40,166,181,157,62,49,87,89,6,227,238,249,206,107,93,124,26,7,127,2,116,63,24,121,103,57,130,176,153,220,245,29,248,62,221,110,145,240,192,206,31,242,129,104,136,47,248,173,131,109,144,53,220,59,54,75,159,74,4,148,77,108,224,164,19,168,61,93,41,28,206,62,18,26,181,6,109,73,236,128,194,54,217,160,253,147,39,15,168,103,32,121,186,129,142,254,190,119,8,55,246,113,185,36,145,237,164,104,42,7,45,146,25,98,60,129,91,25,214,239,0,94,84,113,93,153,93,143,247,10,116,113,53,70,131,222,162,191,27,41,81,157,0,217,6,59,0,92,54,231,106,154,90,17,65,90,236,63,76,47,76,236,160,223,94,82,193,180,160,80,180,174,66,121,36,103,171,63,161,40,89,156,59,181,67,127,93,44,97,5,253,193,130,165,75,120,125,139,53,141,28,61,18,113,114,151,41,6,18,1,240,233,33,104,186,18,29,101,131,170,59,243,98,94,38,0,204,236,239,121,34,111,21,187,65,74,239,255,242,218,135,49,211,150,250,234,5,165,32,187,116,234,76,142,100,62,32,245,16,181,7,91,144,87,81,201,109,199,123,28,95,21,178,178,46,19,171,146,19,85,20,86,11,22,173,207,164,117,190,133,74,60,41,199,113,154,179,174,148,9,141,33,252,184,33,2,103,110,196,56,75,13,91,159,22,63,201,38,218,186,36,170,14,10,28,2,83,50,159,18,219,205,30,70,113,145,187,252,61,9,210,146,139,250,10,253,56,76,88,49,188,170,69,54,239,255,169,83,39,193,59,52,232,64,163,101,1,201,223,14,125,148,137,120,217,54,79,132,59,52,62,55,126,102,222,158,51,235,32,65,126,241,70,170,219,229,138,92,181,54,128,18,234,85,35,38,67,237,4,220,26,166,247,68,38,146,77,95,235,10,52,120,213,105,151,127,121,239,100,195,20,222,84,120,99,138,36,102,180,32,100,207,123,255,35,30,79,36,60,224,103,174,75,146,239,23,229,218,114,242,77,4,209,253,82,96,118,200,214,251,146,38,17,244,131,155,59,207,89,188,211,249,84,202,227,142,220,177,97,131,24,90,35,19,228,21,127,107,76,27,226,32,59,151,58,129,192,112,224,227,37,111,186,244,35,223,16,210,197,132,157,19,182,167,163,57,50,217,41,65,254,65,128,178,127,119,2,46,209,175,5,183,173,51,129,86,169,60,131,121,242,50,23,242,234,211,134,3,115,96,167,122,255,184,31,94,171,88,54,149,220,123,192,209,205,108,111,215,225,4,7,87,233,99,245,157,146,33,144,144,45,127,248,231,153,3,65,252,66,60,251,214,145,223,156,202,99,152,88,195,220,12,16,79,9,224,232,206,192,63,43,9,108,189,14,28,56,200,203,39,210,177,78,247,29,84,8,29,104,78,237,1,203,22,184,101,27,102,8,213,181,66,198,255,214,57,149,135,40,144,175,250,184,134,42,77,145,132,209,252,166,6,140,198,133,243,69,234,157,150,142,230,153,223,73,129,236,154,101,247,222,142,105,7,6,68,99,172,169,85,217,180,172,61,225,150,176,47,80,104,208,134,41,117,209,171,249,105,115,138,151,238,240,5,99,127,140,184,170,173,107,232,219,151,127,117,25,215,99,48,23,63,158,101,48,1,223,102,45,3,11,184,1,16,219,146,120,144,200,246,186,156,128,178,156,17,82,182,102,80,33,168,137,6,206,186,119,187,213,12,111,100,23,7,184,91,106,11,200,111,86,96,24,85,147,248,29,37,198,224,167,77,229,0,106,182,146,188,206,191,226,50,144,37,107,194,184,150,167,47,90,253,154,179,65,38,136,227,246,46,199,211,122,71,212,19,250,168,208,244,119,209,179,93,237,245,251,16,46,181,223,251,146,182,242,244,47,21,210,109,208,180,89,86,107,111,27,175,142,203,32,178,52,15,26,83,240,217,37,253,28,22,255,112,71,137,36,43,148,254,145,23,125,103,105,6,218,94,144,248,107,70,110,83,62,123,254,214,149,26,145,32,75,89,134,246,234,131,43,205,178,226,36,240,30,233,65,136,66,223,35,89,65,45,28,234,10,97,246,147,215,180,61,226,220,107,7,87,188,71,98,107,65,48,186,205,84,42,199,111,247,47,53,159,179,244,17,39,77,137,40,254,173,1,193,30,212,157,32,17,191,193,235,243,147,79,192,63,133,226,62,101,158,88,114,235,132,217,135,115,235,126,113,61,51,49,181,123,30,112,37,15,70,45,189,199,252,191,237,34,223,114,38,20,200,194,178,165,50,95,31,103,239,222,167,243,176,63,25,30,232,38,119,229,40,42,74,125,108,76,121,58,251,43,107,108,140,240,72,139,66,46,156,212,29,76,131,131,239,248,64,129,15,93,153,171,225,90,25,208,242,103,231,198,194,25,22,192,142,152,152,193,17,49,82,111,17,158,190,221,27,2,77,71,171,92,227,4,228,174,47,232,199,69,136,102,224,137,2,109,204,228,148,15,80,99,146,207,244,84,179,92,201,98,190,170,10,122,157,48,120,43,17,158,200,52,27,114,106,61,255,235,26,63,47,35,121,181,218,208,192,133,124,223,66,139,228,69,209,155,87,210,123,166,245,223,17,243,108,86,15,31,36,220,255,14,142,34,61,8,161,240,52,29,31,51,54,178,40,92,26,231,105,138,222,102,174,193,84,80,12,137,221,149,167,4,132,235,58,117,112,38,50,39,82,51,43,127,123,18,18,115,231,102,33,207,38,8,158,224,93,6,239,155,115,255,117,122,212,237,14,189,45,49,186,229,219,96,112,163,127,125,197,109,88,114,100,73,8,208,25,34,108,11,171,65,165,168,194,18,169,12,5,130,55,127,231,16,25,131,191,90,120,45,6,171,157,166,52,194,219,17,65,166,239,100,45,184,167,131,234,216,121,41,7,186,95,23,139,246,197,62,125,48,58,232,13,48,158,203,154,167,39,8,194,4,239,247,137,229,49,31,250,10,78,139,137,111,16,44,84,67,51,50,138,191,192,102,165,53,98,251,31,17,100,110,219,22,46,248,37,100,228,228,31,180,118,35,24,253,95,82,74,201,136,38,88,38,81,118,88,242,161,126,73,12,199,103,50,144,209,36,150,218,133,86,247,197,209,177,72,201,206,69,132,155,157,117,136,81,146,67,241,174,126,78,249,25,182,107,69,163,9,141,229,61,75,95,237,34,246,173,246,32,73,3,36,203,127,185,242,225,226,23,80,150,128,139,202,241,34,68,189,249,129,235,89,247,136,250,116,250,106,178,225,19,189,156,178,94,43,210,90,53,78,246,206,219,229,12,112,37,92,254,184,136,128,228,128,115,31,107,35,52,64,234,84,85,216,64,218,229,152,246,65,244,226,251,8,244,93,112,12,103,112,238,35,77,23,118,33,52,205,253,139,198,109,135,45,1,165,176,1,97,24,48,190,145,175,131,220,58,130,1,174,224,125,185,1,203,185,38,162,202,85,143,238,68,91,38,65,30,241,61,245,119,59,27,73,51,41,210,42,49,128,106,113,148,109,48,29,136,252,233,87,125,68,74,148,80,141,57,71,232,219,54,53,65,116,203,102,110,93,201,32,195,110,255,86,204,128,64,108,235,101,210,147,108,124,144,24,208,114,58,47,201,8,153,145,116,242,238,124,154,35,88,222,29,122,171,199,136,120,153,174,6,127,49,40,245,123,165,230,113,231,46,133,126,237,123,217,180,18,232,146,74,141,39,231,160,233,190,203,73,240,62,171,189,38,44,212,112,151,228,172,48,57,104,138,179,200,129,46,42,223,184,83,216,91,173,18,109,14,219,173,142,48,126,221,158,131,147,200,191,144,185,209,19,228,220,232,169,237,22,21,35,151,168,236,71,15,91,46,166,129,15,226,105,236,46,128,146,159,207,161,12,92,37,120,81,31,172,19,25,235,122,252,9,76,171,226,140,228,81,50,168,35,213,190,96,41,118,4,8,23,43,141,118,244,18,185,202,181,227,191,8,65,161,107,109,252,25,67,119,242,162,145,73,91,88,67,155,99,48,83,248,10,88,118,255,110,248,33,41,26,138,185,244,145,178,225,97,138,155,172,171,84,130,159,53,194,29,255,45,157,161,66,122,85,195,242,163,8,251,105,212,30,0,243,30,183,183,84,55,53,170,162,77,193,111,189,92,248,168,179,96,232,161,162,142,143,226,218,204,249,76,171,181,218,236,46,176,6,178,56,47,94,193,2,123,230,57,5,51,124,162,246,223,174,55,232,167,173,81,240,250,107,138,234,104,127,68,253,39,122,161,151,117,227,21,68,71,23,141,35,7,80,92,218,241,90,245,10,194,153,94,26,230,41,179,51,87,223,9,254,9,178,108,71,178,56,150,249,163,9,60,55,5,73,179,6,197,254,72,115,83,183,236,78,196,179,217,73,212,165,54,174,24,178,125,107,28,17,44,44,206,77,11,84,2,201,90,249,48,31,27,111,14,97,22,160,23,206,82,63,2,145,205,185,49,48,6,35,42,202,10,22,141,56,180,109,58,215,212,30,5,37,65,56,190,242,157,245,87,174,41,31,178,117,71,229,9,137,198,201,82,234,93,107,8,232,59,65,82,92,36,150,149,189,40,199,75,41,95,230,206,230,177,134,1,90,154,72,32,69,189,36,42,89,240,69,14,129,9,25,247,25,159,38,126,73,87,35,99,27,161,51,90,160,92,42,64,143,48,190,65,235,68,241,172,244,90,60,137,156,13,17,23,146,27,73,28,250,73,196,146,147,84,25,23,138,50,163,102,247,226,138,66,20,40,213,156,19,112,218,248,43,85,243,26,218,127,152,247,8,44,141,176,5,33,220,221,70,73,154,228,236,198,13,44,220,179,190,234,194,72,61,45,155,178,251,112,159,151,99,219,54,109,91,157,158,22,178,226,249,49,47,124,61,8,151,3,109,99,53,136,59,121,166,143,1,147,52,237,135,124,1,102,5,83,50,206,179,224,232,184,13,248,47,116,152,251,47,77,242,177,186,58,141,214,2,63,139,179,190,76,15,235,248,192,90,180,131,92,219,117,6,102,151,106,230,88,211,216,65,189,137,39,175,56,35,32,2,149,240,106,73,23,254,107,122,86,10,65,69,56,21,173,118,124,92,145,164,161,162,152,68,15,96,8,184,156,144,45,224,238,85,205,10,125,160,60,176,239,27,55,31,195,71,125,229,68,151,18,198,122,199,163,246,16,24,16,134,42,131,34,184,27,77,182,155,7,70,61,155,200,87,25,70,255,188,30,142,129,40,63,118,5,89,185,47,88,109,206,28,63,123,223,110,30,227,125,163,81,156,42,47,73,91,226,205,198,211,204,228,191,148,142,16,32,98,209,83,248,178,123,226,207,244,7,18,33,218,153,120,3,35,21,180,135,199,172,64,195,190,178,160,152,194,205,87,3,149,46,132,150,245,8,114,177,104,177,208,109,158,92,190,1,205,126,221,218,33,244,200,86,21,117,193,54,255,192,58,245,212,121,26,95,55,23,92,108,22,148,4,125,89,17,46,87,76,97,47,53,58,131,9,242,143,148,52,125,174,197,123,196,193,136,20,200,58,250,34,239,245,213,195,246,254,250,47,96,4,59,241,69,134,121,2,194,153,43,151,93,14,114,61,205,27,28,174,201,34,245,149,251,135,15,103,71,96,234,59,239,246,50,87,192,82,253,171,56,120,168,178,182,218,249,90,90,24,20,218,82,185,150,159,238,224,18,191,119,80,16,18,198,173,28,178,214,135,35,145,240,47,10,203,76,185,86,11,138,159,87,75,144,50,233,138,83,235,103,125,82,134,50,47,149,58,187,84,85,250,90,18,76,247,191,200,68,192,243,101,206,129,154,93,174,35,103,5,222,99,66,214,253,15,195,70,106,12,11,18,53,130,205,100,223,133,64,191,19,122,10,254,187,238,143,30,196,71,239,70,238,136,124,10,193,101,65,214,56,110,219,134,211,85,226,78,117,55,223,248,2,59,35,234,93,15,227,158,164,189,225,53,49,149,201,118,140,110,16,149,70,79,184,67,4,81,212,79,149,92,115,64,224,94,158,97,110,53,12,215,69,172,151,181,62,60,43,218,171,120,111,0,103,173,53,246,73,229,253,254,252,157,191,172,163,15,205,32,120,14,145,216,21,24,185,49,235,28,53,111,89,231,123,55,51,247,202,86,71,34,78,251,231,251,239,232,127,238,106,118,166,217,8,97,84,246,161,0,97,2,144,93,91,249,131,233,116,44,146,101,187,113,20,57,146,107,199,189,182,217,6,79,99,155,248,228,89,220,249,167,198,45,156,106,126,144,224,203,84,43,25,20,33,61,242,213,4,189,153,113,41,8,238,110,64,5,135,121,3,169,136,116,13,39,152,215,111,68,89,158,99,201,153,192,51,180,102,129,190,97,78,253,139,187,59,77,171,68,6,151,134,250,187,253,12,30,103,252,57,83,4,155,253,226,188,190,71,205,14,207,186,9,200,215,236,90,178,208,150,116,152,157,227,148,214,41,164,84,122,252,42,168,81,244,240,250,129,19,125,25,184,171,89,144,139,87,24,32,153,210,122,84,108,243,168,160,140,231,115,204,78,249,157,94,136,248,72,201,2,168,157,52,22,36,107,162,35,223,27,20,46,5,238,42,56,225,233,27,107,12,109,151,82,248,202,74,194,57,134,50,252,51,87,24,17,93,230,186,200,91,164,96,172,207,212,150,41,161,136,240,169,154,154,20,13,169,171,53,123,228,126,17,165,51,183,90,165,43,32,207,254,153,176,88,216,36,58,126,242,16,224,22,222,32,136,214,227,4,170,126,0,45,12,78,157,250,255,91,188,240,77,146,150,120,139,244,216,254,128,110,107,75,111,189,8,220,130,225,224,90,12,159,45,40,62,253,48,0,187,211,212,68,79,27,211,232,17,39,99,110,237,86,211,210,132,129,135,60,250,124,204,114,217,125,127,122,102,16,206,77,210,13,221,245,40,182,197,141,222,76,198,146,154,10,109,65,173,89,46,98,240,173,8,101,67,53,119,204,81,248,203,213,171,20,121,163,209,144,225,89,73,85,106,41,245,170,252,84,97,7,96,45,114,104,124,90,193,144,222,58,73,6,150,178,249,233,153,16,193,63,106,75,220,41,59,84,74,160,32,190,14,138,245,76,106,206,201,125,112,59,68,15,250,107,36,69,222,10,60,13,214,239,156,66,162,234,25,1,198,167,44,163,173,102,12,23,148,174,110,170,114,139,80,249,94,53,79,164,78,52,10,120,121,30,181,32,125,15,62,76,103,37,99,220,181,189,253,16,110,220,19,191,41,101,15,48,103,149,195,99,199,231,8,119,58,84,154,131,76,155,6,31,51,161,67,165,204,21,85,79,66,94,25,218,72,59,110,80,141,52,243,66,154,43,81,5,151,57,167,10,43,91,73,6,186,64,172,210,225,174,47,216,226,143,203,71,252,20,65,237,179,212,51,175,210,114,225,115,179,87,185,4,5,95,161,161,76,157,41,194,13,31,162,58,106,47,52,212,27,104,85,123,21,4,109,142,180,218,187,172,149,66,111,185,190,234,216,172,65,106,28,159,185,201,8,13,9,6,103,163,91,207,30,1,20,158,181,115,74,76,16,136,187,223,118,209,208,247,148,83,227,94,167,94,110,51,164,242,163,79,143,132,147,20,150,83,207,124,19,1,14,67,163,89,229,69,156,176,197,205,66,122,95,14,198,157,192,196,39,211,97,75,200,241,100,132,72,72,100,229,18,16,215,205,77,22,16,86,111,212,91,223,137,41,60,66,84,204,222,212,215,156,63,64,228,239,204,255,254,202,58,61,83,206,114,221,104,254,169,43,137,198,199,28,192,148,40,46,169,176,1,51,184,12,24,121,186,202,93,45,149,133,170,37,190,246,156,63,118,171,176,14,20,204,129,2,62,156,7,212,68,110,135,98,123,9,88,226,38,190,131,145,77,4,118,15,127,104,197,238,85,126,158,107,66,252,103,94,65,221,148,99,47,43,237,74,12,217,66,82,65,177,81,8,27,203,241,47,110,74,222,0,43,6,247,223,83,209,124,92,228,7,66,229,4,82,183,204,235,88,190,4,53,129,126,25,61,49,82,177,147,56,27,249,111,116,85,162,97,192,188,246,237,107,236,104,8,40,10,179,125,68,74,41,153,208,35,195,198,71,210,85,203,238,225,144,3,235,12,24,218,183,41,46,30,112,37,64,195,184,220,7,5,112,247,249,191,12,247,134,79,81,40,156,132,223,8,22,243,143,63,149,169,181,124,217,247,235,97,56,233,116,237,14,187,165,54,172,193,96,200,154,160,75,167,20,111,104,228,145,52,152,123,100,100,155,30,91,232,49,23,209,10,172,176,37,134,195,255,38,204,156,195,129,191,52,118,43,225,192,59,226,178,46,195,58,54,26,76,201,34,31,98,17,139,137,162,66,172,230,174,189,103,87,162,154,23,120,228,186,193,88,156,215,8,60,168,215,79,202,114,26,84,138,84,223,226,91,214,230,62,98,143,103,85,159,174,71,56,47,159,194,220,66,178,46,219,2,44,177,137,21,182,202,38,169,253,99,155,135,93,96,148,9,242,242,140,157,27,146,162,170,91,233,137,4,27,133,244,67,79,238,121,208,31,187,185,162,69,183,46,105,30,0,184,99,253,175,72,107,49,133,165,93,237,90,184,228,208,206,190,237,220,72,164,162,145,94,84,108,14,145,209,171,30,176,9,161,67,100,241,145,21,106,109,75,70,236,17,204,144,253,94,111,142,65,15,206,180,86,233,219,179,14,231,179,4,47,105,66,149,202,156,162,44,11,91,188,137,32,93,192,139,97,182,89,162,93,39,206,191,96,224,196,171,44,21,255,60,174,218,109,10,56,206,240,17,155,102,25,230,245,89,216,89,171,31,230,154,143,104,47,229,3,103,110,46,46,103,26,87,109,221,190,105,22,125,155,72,95,242,42,111,55,80,38,93,127,233,18,130,71,113,73,134,131,30,6,141,80,151,56,113,136,53,184,139,216,170,244,214,36,182,254,254,64,177,152,21,18,177,249,132,199,116,135,111,222,133,29,147,153,122,133,252,45,160,194,238,163,170,124,94,176,178,215,209,158,188,207,55,60,168,149,217,20,83,71,130,233,216,90,130,6,100,154,246,209,158,38,20,7,41,153,174,208,190,102,95,72,52,13,12,46,244,134,253,60,145,208,6,95,9,135,103,82,163,99,145,104,98,73,229,191,215,1,40,159,86,246,168,116,81,84,151,87,63,73,55,224,158,33,48,199,223,235,152,44,229,37,182,160,17,19,158,38,191,41,30,161,177,226,245,103,232,132,36,170,213,85,162,45,153,144,4,90,226,100,98,239,92,255,254,51,25,76,98,22,48,87,228,46,217,152,119,203,208,164,21,68,252,238,179,110,194,185,58,152,200,130,159,166,182,109,51,62,6,24,64,16,35,217,242,67,201,11,100,173,154,225,48,32,23,40,247,79,154,228,239,254,221,208,6,103,98,170,149,226,84,8,64,19,161,168,8,92,90,25,36,221,171,250,132,37,46,228,63,3,67,70,112,29,1,212,93,180,65,244,119,44,23,226,71,252,242,88,105,245,231,172,29,73,181,125,241,39,183,147,255,114,17,246,186,69,64,142,26,211,110,180,241,120,167,51,53,35,159,105,81,15,187,65,177,216,200,160,18,133,211,124,236,194,47,80,186,135,77,83,236,123,37,211,16,85,103,3,65,198,196,238,6,111,43,19,180,44,140,4,205,32,105,194,227,96,113,203,202,198,224,197,221,52,1,59,11,214,21,173,229,23,12,132,26,188,120,25,124,39,99,77,186,221,144,29,166,172,143,71,55,13,240,232,126,54,172,174,197,48,80,0,244,19,105,124,196,128,80,205,237,223,252,202,181,151,127,222,90,242,245,199,167,93,203,93,40,77,84,14,166,210,166,66,236,85,150,96,153,47,175,87,237,62,23,129,74,14,123,132,91,172,185,195,1,48,180,198,64,21,1,121,12,36,78,151,52,163,150,217,101,15,159,155,100,162,29,13,11,107,152,129,81,217,116,174,145,139,148,240,104,25,123,203,1,6,10,27,215,33,30,206,154,105,149,68,195,147,86,153,144,189,164,234,159,200,191,109,28,76,239,178,203,53,96,167,46,73,119,126,65,69,223,115,116,227,252,249,197,252,98,112,90,18,175,17,120,2,94,110,63,156,232,182,14,123,200,194,65,47,235,16,163,24,78,241,47,109,153,32,9,23,22,216,40,133,186,222,117,20,100,197,106,127,149,10,194,225,89,41,32,53,89,62,151,225,61,10,47,75,85,4,2,85,240,123,218,185,108,36,75,225,175,56,223,85,187,29,179,87,186,210,218,151,62,232,158,178,185,148,93,226,167,150,148,133,27,112,80,185,246,89,64,243,61,48,99,236,55,4,250,78,144,91,47,236,178,180,179,78,25,255,59,212,17,55,136,38,247,7,160,109,76,245,55,62,201,26,231,123,96,110,7,180,242,155,199,248,101,103,250,40,227,8,122,87,123,144,159,134,153,85,116,152,125,234,35,145,255,161,96,235,217,141,111,157,222,166,207,25,171,124,111,164,160,178,225,128,221,70,132,0,181,200,167,190,157,92,85,172,125,79,235,37,146,205,112,150,23,182,103,32,240,233,250,70,18,143,231,198,175,194,89,147,240,92,62,77,66,250,158,2,171,108,255,174,47,200,87,197,20,14,104,182,209,64,244,164,39,153,231,31,117,18,175,146,206,140,253,98,227,92,2,224,46,136,114,98,90,0,13,3,229,57,233,110,211,31,147,0,214,45,213,148,89,102,47,59,239,55,179,139,123,185,106,67,65,230,0,230,111,238,41,56,177,0,140,26,249,108,196,151,78,78,28,156,248,113,254,164,141,10,246,48,163,14,73,249,130,255,26,67,202,129,85,178,135,247,247,10,48,10,11,46,178,217,222,118,62,60,28,43,231,180,223,108,214,185,212,134,254,181,7,217,154,31,218,237,169,136,10,30,88,179,37,189,204,34,231,125,95,143,224,152,142,238,24,74,34,144,188,131,84,217,222,168,211,204,158,59,71,175,27,222,181,100,152,91,52,194,62,2,28,136,147,214,131,178,89,183,183,29,235,190,22,51,56,58,119,171,204,24,116,78,114,112,100,97,201,46,247,161,92,160,76,152,44,226,136,5,240,239,26,125,233,40,130,36,253,183,7,220,110,83,22,19,238,120,126,34,178,75,87,164,66,101,152,223,23,185,125,245,151,61,252,63,127,166,170,172,235,116,156,235,249,178,64,182,208,12,76,65,234,223,140,106,19,207,153,156,237,107,43,25,95,210,56,69,191,188,199,233,152,238,45,112,116,170,202,237,46,183,45,180,196,163,231,44,164,84,219,94,164,213,178,239,157,96,85,217,144,164,239,216,9,168,105,63,174,252,36,65,82,119,90,248,246,15,16,186,226,199,68,86,78,9,109,139,129,107,74,184,246,77,176,240,26,190,39,148,1,6,212,231,117,146,218,83,217,103,175,177,212,151,234,179,215,167,221,17,92,150,121,153,211,19,166,102,137,62,237,228,86,226,56,4,83,220,42,66,20,122,8,209,20,144,146,127,246,159,143,137,189,217,143,94,232,43,85,246,32,220,85,90,130,123,187,158,143,158,84,188,227,169,210,216,186,49,253,209,8,11,205,252,125,32,193,20,92,97,189,204,170,63,232,151,77,65,129,235,177,88,34,174,68,69,37,91,148,211,204,138,174,160,255,153,107,126,84,61,116,222,188,213,37,246,66,51,219,83,167,241,203,83,72,137,35,212,32,231,241,82,216,150,17,3,162,114,107,3,195,148,114,31,116,75,193,54,231,177,125,73,67,104,216,47,57,161,43,198,230,83,204,57,227,153,202,122,73,232,41,64,245,44,223,75,13,131,180,184,215,30,125,91,227,64,83,251,194,194,170,99,153,208,206,177,193,14,141,26,200,67,32,50,204,30,169,167,37,213,55,174,13,227,48,194,153,93,121,175,181,150,48,60,148,199,10,208,46,12,4,142,151,208,151,39,17,128,217,103,89,176,219,159,25,255,123,161,34,22,230,79,151,82,47,177,31,108,140,200,206,93,10,173,19,72,231,231,52,199,233,254,241,103,181,17,3,162,232,7,86,115,245,136,12,251,141,41,151,129,202,119,93,194,173,89,182,41,228,174,136,45,50,56,124,198,136,248,138,89,104,150,64,21,146,113,143,86,81,186,92,66,148,215,148,251,190,72,135,166,174,114,117,151,206,11,18,30,12,120,214,107,52,69,232,22,43,217,215,189,165,22,226,96,62,190,60,28,48,79,84,246,241,130,28,84,166,55,142,171,180,12,142,188,74,220,56,159,36,108,161,30,134,204,219,198,45,16,251,51,63,237,21,61,219,74,139,181,90,228,108,128,185,242,224,121,200,140,59,208,10,85,14,135,188,246,106,203,33,187,243,246,252,162,252,238,105,124,160,183,189,85,198,104,121,127,133,178,99,208,134,102,83,36,131,95,14,74,221,235,82,174,116,211,123,93,196,72,66,30,107,59,131,157,33,125,142,32,14,48,190,30,4,47,68,160,2,111,141,119,10,50,51,183,198,141,11,147,148,99,248,114,44,104,202,152,248,223,229,98,227,132,167,92,129,26,211,152,2,159,110,66,96,42,219,158,190,145,78,134,131,200,215,161,47,174,195,228,49,54,250,106,178,239,59,76,195,57,80,107,219,37,113,141,15,253,164,122,30,221,137,184,170,94,27,190,58,86,182,8,61,74,83,119,123,0,197,224,213,216,186,121,7,230,161,246,240,159,76,57,96,80,107,42,112,139,100,8,165,138,42,62,31,155,120,77,183,237,68,32,35,46,126,109,160,109,91,142,60,63,40,129,155,58,55,64,168,201,114,224,209,220,245,140,23,255,57,159,133,45,28,92,227,122,0,248,69,33,229,40,107,73,18,233,144,180,155,140,26,144,61,202,207,142,71,10,203,157,4,9,83,254,74,160,222,44,19,62,168,5,149,177,203,134,212,214,80,13,109,31,219,40,192,185,194,46,124,33,142,83,102,181,100,218,168,57,187,92,245,97,159,213,101,52,183,117,238,47,143,93,149,131,255,224,153,77,203,133,27,48,151,46,147,61,204,224,10,163,68,192,95,7,226,181,14,189,131,12,89,67,167,5,217,66,240,51,86,50,109,42,169,104,238,147,206,161,100,87,205,107,93,8,215,157,62,238,160,117,172,202,249,52,40,10,165,165,172,213,117,10,76,240,217,33,248,252,126,95,232,12,6,166,17,234,80,191,139,161,238,131,149,249,97,226,12,153,153,24,222,7,118,238,33,116,7,167,159,117,115,177,31,243,234,190,189,2,186,149,185,83,252,147,92,170,135,59,184,149,31,133,157,172,18,245,39,149,62,211,210,37,119,5,229,85,117,94,126,190,119,226,219,79,206,65,130,54,233,250,4,255,187,65,104,44,212,91,195,114,223,157,129,104,140,249,192,210,200,63,105,59,181,169,166,240,13,86,134,203,24,188,154,11,185,94,170,239,217,74,177,208,0,175,131,77,127,175,66,16,145,174,58,37,52,192,254,30,128,221,59,103,49,169,48,121,13,255,192,100,201,47,82,92,23,12,185,6,104,165,89,129,21,206,90,183,45,229,2,88,132,167,143,211,43,198,65,210,186,91,213,25,164,209,92,108,191,27,254,152,222,201,124,79,177,139,47,136,165,13,70,132,154,50,98,195,219,85,188,191,133,53,6,198,131,77,88,225,220,141,85,250,156,168,108,213,59,51,138,242,44,166,242,70,80,73,69,213,227,112,83,237,205,56,180,181,21,55,121,12,43,161,98,190,40,140,109,147,20,81,229,53,38,204,23,87,242,129,126,180,178,27,22,79,56,34,123,246,218,37,58,114,54,237,10,249,0,236,246,80,136,61,181,84,210,18,90,188,115,104,208,240,206,38,215,162,239,204,36,212,148,81,52,145,58,210,220,233,50,159,17,242,37,197,236,239,19,253,56,99,17,237,252,90,183,100,75,148,152,164,189,18,5,198,44,190,66,24,114,161,116,118,116,142,84,204,103,175,190,101,101,237,85,179,166,143,196,117,82,11,44,205,70,172,204,118,113,218,36,153,93,211,63,205,196,110,105,194,154,140,173,228,99,166,204,67,32,178,244,136,176,129,20,247,254,228,251,95,226,223,183,193,176,156,146,164,27,92,231,231,117,122,68,38,174,248,164,10,238,230,222,48,87,43,109,41,145,192,155,192,23,179,81,164,183,219,237,18,219,114,151,40,85,233,230,104,149,160,49,208,30,198,205,41,176,113,178,245,13,151,201,172,15,47,151,106,59,236,107,233,128,195,2,162,247,26,99,62,30,150,255,177,61,199,47,59,237,235,24,244,216,116,203,132,59,249,35,250,98,221,104,232,12,178,211,138,74,21,80,10,51,119,237,208,170,220,87,215,202,63,210,160,249,19,120,244,25,66,255,215,80,173,139,23,89,224,115,143,93,201,49,14,140,141,180,116,104,95,219,78,145,234,134,171,183,65,236,210,131,98,164,6,160,62,173,213,197,115,226,120,145,151,8,37,98,142,66,30,115,156,144,90,59,0,247,209,187,172,58,26,251,134,238,37,127,169,238,82,104,139,86,89,9,255,38,73,159,97,185,15,212,62,143,69,241,38,6,3,79,60,32,2,237,102,7,14,45,59,234,109,227,179,1,240,14,37,207,16,80,149,8,242,76,239,154,83,73,92,81,186,225,225,186,222,172,189,145,71,200,228,71,58,155,242,18,178,191,118,22,119,159,219,0,23,221,254,106,90,76,88,32,82,253,197,97,61,42,63,8,125,210,123,32,177,94,99,144,69,209,99,31,154,115,110,162,239,35,118,70,37,117,113,13,112,174,76,88,119,62,99,63,12,171,186,12,195,68,213,227,143,146,201,244,180,199,148,131,93,75,191,54,14,202,158,168,67,152,214,254,196,179,127,43,239,25,62,210,41,111,164,227,250,223,88,12,101,251,179,112,232,41,189,188,10,112,53,238,131,22,23,2,82,228,137,235,59,158,77,109,229,167,124,48,234,143,11,98,73,179,135,254,71,121,95,232,110,174,226,21,150,189,72,106,162,219,3,159,35,253,88,64,130,49,210,92,171,200,143,84,192,253,171,228,115,0,10,42,250,192,123,31,10,190,36,55,178,198,92,17,244,48,26,49,73,162,200,104,224,44,186,148,221,103,231,224,150,231,54,125,176,134,174,245,250,137,155,176,31,153,177,93,200,85,148,153,7,149,79,239,98,70,50,61,138,76,80,93,175,172,186,104,41,133,73,100,192,128,13,183,181,230,208,20,160,171,82,229,78,87,120,99,179,101,199,12,241,187,43,204,3,166,198,142,111,28,152,172,34,174,35,106,47,222,116,123,160,116,197,2,39,248,14,8,150,30,57,252,70,179,89,115,101,134,82,89,13,162,105,181,193,207,150,232,129,202,18,185,236,223,105,93,234,219,111,209,227,102,71,224,252,159,234,148,207,20,216,155,151,131,115,185,66,175,34,221,122,58,125,156,145,93,54,57,40,159,52,131,21,182,35,20,187,10,120,126,162,172,186,161,255,24,152,6,245,162,129,35,107,154,112,130,96,232,174,216,100,240,76,153,132,218,214,188,223,16,177,120,109,163,38,190,70,225,104,228,101,194,91,224,234,61,224,71,81,117,91,116,194,29,158,47,94,159,32,230,6,129,3,77,128,111,21,253,149,16,44,5,80,148,52,251,152,113,148,8,196,70,153,114,58,121,53,180,130,236,181,152,13,81,196,92,57,241,133,81,96,155,182,104,123,17,190,63,139,188,113,40,17,251,15,210,73,251,103,234,232,66,167,8,174,9,223,61,80,13,73,214,87,63,251,51,25,154,229,169,160,72,202,57,112,30,160,117,226,90,255,34,248,53,30,82,225,50,114,157,86,68,217,246,226,127,20,254,229,195,61,177,217,108,149,100,81,110,73,218,20,82,125,182,201,65,183,179,140,137,23,195,48,62,164,220,112,165,208,189,28,5,227,210,99,111,238,160,196,89,51,213,20,124,93,235,24,133,253,7,242,248,45,154,3,69,218,12,219,81,61,252,54,241,35,200,36,103,60,62,143,237,167,54,222,180,9,164,77,19,49,159,209,63,60,25,58,137,60,160,134,196,40,162,149,82,158,177,60,198,108,59,232,183,209,206,242,22,18,191,140,177,193,132,8,65,33,163,139,253,130,121,129,12,101,81,184,224,139,184,152,219,152,251,168,227,150,81,106,91,130,107,146,250,130,64,163,109,194,43,152,192,1,50,235,14,193,135,198,108,170,95,112,55,53,93,148,105,144,178,182,186,203,49,155,80,149,238,244,10,42,251,215,135,181,251,158,225,192,20,130,57,115,130,133,196,121,62,255,151,126,166,222,3,213,113,87,219,141,90,43,38,141,199,74,2,161,177,244,167,233,127,238,217,142,112,189,60,90,163,208,25,152,23,154,48,9,252,82,3,37,41,130,4,170,152,150,20,0,87,135,177,172,187,39,6,22,106,217,3,92,49,221,45,120,14,87,213,151,227,201,12,142,184,193,247,183,11,229,3,161,203,104,50,105,47,179,230,181,172,211,26,209,60,201,32,235,168,190,31,174,97,144,40,168,146,131,146,192,146,243,16,73,100,202,145,23,221,42,202,162,53,18,40,12,163,60,218,190,75,142,43,114,19,57,248,199,21,168,213,62,105,188,146,163,6,179,3,68,84,99,255,161,39,237,235,6,118,92,69,54,201,44,125,52,193,39,96,242,19,89,95,57,110,251,0,33,206,94,146,80,125,74,4,154,46,122,101,64,70,160,59,181,193,61,120,102,212,66,217,181,21,24,70,50,108,160,252,21,130,139,125,246,150,223,217,224,205,180,104,181,224,228,24,255,131,85,75,155,101,213,225,184,205,136,246,117,60,218,65,173,154,135,163,172,165,37,10,54,3,15,175,213,250,252,112,182,54,111,80,22,68,205,221,168,3,150,228,76,205,118,90,237,53,208,241,180,168,174,71,46,119,130,8,3,125,162,46,134,16,157,20,200,209,194,228,149,28,247,26,209,154,15,23,200,174,92,231,178,171,193,200,62,106,54,89,249,167,78,22,216,61,164,47,65,80,73,146,90,38,247,90,127,164,203,46,40,162,206,124,116,130,127,59,62,69,174,0,118,171,228,145,43,34,100,9,131,179,255,148,76,247,215,122,56,130,148,80,134,251,92,247,254,215,113,227,68,24,122,208,170,116,66,236,143,37,150,214,184,166,11,224,99,22,39,75,145,127,130,126,255,246,106,180,190,207,12,90,226,176,226,241,184,124,1,110,159,27,226,209,131,220,21,137,83,49,94,198,228,224,29,166,76,10,190,47,239,58,66,61,72,220,110,9,121,196,138,136,158,231,226,204,116,1,134,172,134,195,53,165,142,108,113,136,193,206,139,13,223,70,30,125,185,66,54,151,222,9,121,157,153,94,166,145,91,105,79,54,194,62,3,107,231,124,169,153,206,223,38,88,215,111,52,102,141,237,162,159,39,189,209,92,14,4,93,149,214,215,106,238,23,40,141,206,50,14,110,98,234,144,249,196,71,221,128,217,53,132,177,137,175,46,73,72,39,169,137,165,251,109,77,218,245,192,198,233,213,177,94,59,222,221,19,142,221,188,132,109,98,158,181,34,18,227,162,147,93,44,172,242,63,27,105,46,69,124,187,23,90,169,22,116,252,150,57,4,69,114,127,71,60,208,251,60,219,33,71,188,126,44,5,210,19,126,64,86,222,179,138,152,46,190,196,121,89,214,237,243,124,193,87,94,229,37,17,45,0,235,147,179,98,191,92,36,210,77,187,166,225,236,132,157,195,74,137,168,152,162,134,16,211,40,5,19,151,21,190,185,159,124,54,183,219,130,186,6,115,122,200,50,222,34,1,239,55,22,137,160,215,12,28,40,65,242,89,208,89,24,90,207,169,35,93,56,136,27,145,142,249,51,6,115,24,2,230,0,42,191,230,150,68,205,153,6,22,115,161,14,149,229,203,212,66,71,111,12,223,208,85,161,234,87,132,75,218,60,126,143,78,76,154,46,212,30,75,187,116,202,240,100,47,222,20,80,254,86,215,254,130,251,241,173,72,109,246,40,40,61,202,223,161,9,9,172,92,254,182,27,225,239,101,111,166,128,67,67,245,17,151,250,244,136,188,184,50,219,147,29,215,31,145,148,54,230,226,36,19,183,216,229,235,25,228,94,93,195,10,138,159,92,255,125,0,138,71,33,202,148,112,5,28,194,205,47,119,130,234,161,60,217,254,217,64,139,69,12,21,218,151,195,129,72,187,46,61,108,33,217,200,90,75,25,24,48,152,84,109,241,180,33,154,211,254,78,189,197,63,202,189,155,231,244,135,53,245,152,28,221,237,90,28,53,43,87,158,59,135,161,242,69,131,247,48,84,141,158,47,52,89,177,143,222,51,247,109,246,242,145,183,211,242,110,119,141,135,145,122,37,40,201,143,245,227,52,239,137,78,40,111,209,145,29,146,151,89,101,193,221,136,233,146,125,126,76,169,231,19,116,133,46,219,198,10,200,150,175,29,231,71,42,123,229,57,73,148,149,83,10,89,240,166,26,208,225,10,57,62,251,173,162,62,221,71,70,28,53,131,190,236,19,101,95,43,222,42,46,246,67,74,19,63,255,37,120,162,145,16,8,190,104,204,145,59,199,200,79,226,175,213,73,183,138,51,52,109,178,31,30,108,127,42,249,246,253,198,21,142,161,42,128,242,141,178,47,36,195,1,190,10,117,196,225,45,252,232,106,71,81,82,165,241,229,183,22,77,173,217,205,100,51,210,57,124,11,39,174,220,178,231,142,101,188,183,127,166,236,237,62,198,254,127,228,174,116,112,40,115,154,2,127,175,173,228,165,250,59,115,89,90,32,70,74,175,80,126,211,175,28,229,132,177,244,162,208,81,51,107,144,207,253,146,219,106,251,239,207,48,72,73,212,242,5,206,219,70,127,135,215,148,237,35,225,110,64,187,210,72,71,246,192,2,63,252,81,89,5,57,67,114,111,81,85,0,195,237,46,163,178,80,16,235,58,170,217,199,14,200,19,177,32,214,77,138,123,210,0,115,45,41,40,0,219,50,146,191,233,175,79,37,214,62,220,137,40,187,80,61,115,242,47,254,231,187,238,100,103,30,46,253,22,77,94,55,58,255,251,48,141,132,206,136,69,17,71,113,129,27,70,191,154,66,173,146,220,65,175,63,75,172,44,219,91,114,152,4,187,159,139,25,23,250,94,91,19,9,169,153,0,247,1,87,46,39,9,64,24,242,148,37,183,97,164,95,82,248,10,184,162,104,243,133,205,72,31,142,184,72,29,93,197,0,81,146,197,197,76,230,184,159,67,180,206,7,74,76,109,32,71,100,65,65,183,106,85,222,134,214,216,184,231,217,178,163,137,59,181,114,135,34,24,215,73,201,213,128,20,50,127,237,100,7,122,222,154,11,144,17,71,183,171,190,145,16,125,166,47,146,188,249,107,4,91,19,220,255,229,54,160,209,216,148,131,147,171,124,64,113,83,45,46,121,65,249,186,182,36,11,186,58,1,163,181,237,158,143,39,165,6,101,84,136,50,84,161,68,249,121,97,141,159,236,184,180,4,17,46,5,250,209,160,83,195,223,161,13,47,60,44,179,47,0,231,80,114,169,218,143,52,141,48,56,43,80,83,117,191,15,172,122,223,163,60,106,131,60,235,104,241,172,29,111,220,174,27,139,68,48,22,113,98,52,135,179,77,192,152,248,49,36,114,144,81,215,107,233,243,198,67,151,221,58,70,115,163,87,120,149,63,173,92,66,26,231,205,71,32,148,2,221,96,102,216,74,251,37,13,198,219,45,218,70,220,132,215,132,139,212,226,126,246,14,83,4,119,209,91,217,58,209,212,237,88,223,31,173,46,97,144,250,11,232,89,168,14,64,112,129,133,39,177,157,200,92,37,56,129,36,251,145,22,67,31,218,22,152,113,149,45,250,1,186,27,67,121,234,171,3,149,103,146,68,21,22,127,252,242,46,149,183,39,123,23,243,84,44,217,118,179,142,225,146,70,31,76,216,112,154,187,230,145,51,79,53,93,119,146,224,72,156,64,209,210,199,123,95,4,243,179,109,195,215,80,143,167,224,241,121,44,122,148,81,42,70,174,187,4,19,143,9,199,193,103,163,27,3,241,19,27,144,12,90,179,7,22,59,136,159,54,71,221,225,201,197,199,83,144,185,243,178,176,25,148,198,201,169,230,252,165,168,215,154,104,63,205,151,51,174,156,57,132,209,119,145,157,168,95,237,11,139,209,223,155,90,48,86,121,114,229,235,153,35,70,220,27,176,38,253,243,105,87,58,26,112,124,213,253,7,160,226,201,157,64,27,130,176,218,33,45,243,249,141,17,208,237,152,105,100,2,47,250,186,126,179,102,231,195,176,172,74,33,37,80,166,186,149,111,3,185,219,160,9,53,110,10,137,124,252,159,3,173,12,105,7,203,161,142,139,238,125,214,159,21,187,180,88,250,198,134,14,73,92,129,185,239,225,27,57,105,171,12,174,214,56,95,179,100,130,216,126,141,16,29,130,215,132,96,110,42,34,8,130,89,188,176,104,7,2,4,15,74,101,62,195,224,141,254,36,181,169,121,173,0,171,189,204,116,215,145,152,28,122,74,219,220,13,200,33,230,112,149,155,88,117,90,126,189,153,128,47,10,139,45,181,81,49,97,167,116,29,39,63,141,179,119,13,219,164,109,78,36,183,89,38,108,152,195,224,99,105,21,67,105,207,155,249,41,153,82,133,36,109,238,102,46,26,87,61,34,154,134,98,159,183,52,16,248,96,25,125,70,130,153,51,58,124,37,60,32,218,86,148,41,51,245,21,10,43,235,239,91,53,215,220,169,13,23,251,74,206,114,204,173,20,51,137,53,231,136,11,63,7,116,218,57,174,201,235,113,215,82,198,253,112,140,166,226,180,211,6,18,21,48,24,76,62,27,83,232,228,131,242,190,187,127,27,69,14,122,247,236,79,125,92,83,47,119,170,229,216,25,139,101,146,28,182,109,42,19,172,123,147,145,216,76,140,76,187,86,71,6,174,227,15,23,243,196,101,227,45,204,45,0,222,22,182,83,47,151,232,184,66,251,33,104,55,108,38,188,51,129,80,42,202,162,8,190,179,99,211,218,144,167,252,166,248,36,15,69,173,247,68,78,98,50,167,201,205,16,97,68,6,60,55,1,87,7,153,157,120,126,21,24,41,32,64,101,8,224,82,89,145,37,213,235,217,212,112,222,31,198,87,50,175,89,254,66,224,188,116,228,235,75,155,24,48,93,75,40,50,211,54,170,170,52,231,154,169,94,250,28,125,154,203,148,44,8,5,241,4,25,104,26,51,31,163,237,203,246,199,189,36,184,97,178,205,109,181,59,176,189,18,159,186,243,232,177,204,244,30,118,164,59,245,203,168,97,141,29,98,157,236,45,26,203,154,35,191,246,176,235,160,222,166,171,78,136,135,229,128,3,235,175,228,183,145,241,233,159,125,243,177,28,11,39,211,28,176,190,192,45,221,66,22,41,107,246,70,74,205,13,189,254,100,55,49,247,179,99,235,239,187,111,17,249,193,145,123,131,221,168,6,0,143,106,153,63,118,32,10,95,91,76,66,72,194,197,171,77,200,217,16,131,136,193,200,75,154,223,150,138,143,165,50,123,11,164,10,142,241,14,225,239,60,207,239,4,1,228,36,226,226,162,99,53,182,121,178,247,157,159,114,12,95,6,23,230,127,169,177,215,157,166,228,80,223,8,1,202,110,199,166,248,165,42,237,241,174,8,100,174,253,213,176,59,87,174,231,157,204,4,52,223,114,87,121,188,209,35,224,231,203,105,110,111,174,73,200,50,173,40,209,124,209,55,90,228,15,137,86,155,20,192,183,91,12,198,221,227,77,80,29,17,172,242,56,238,90,75,158,113,127,163,47,230,40,7,178,43,114,29,140,245,202,115,216,151,164,76,12,231,164,160,116,74,133,64,153,12,190,135,222,160,254,23,0,155,164,94,218,245,145,79,45,89,69,17,191,229,42,178,93,28,166,67,165,42,160,235,250,10,185,29,166,254,32,232,234,222,74,197,68,100,32,161,116,48,65,18,47,156,130,240,106,247,81,253,116,246,151,63,217,119,57,182,242,31,152,30,76,244,114,77,113,7,150,18,79,40,186,9,15,26,168,3,74,98,243,49,26,235,87,207,215,68,222,49,68,138,195,27,106,72,61,114,38,135,174,63,8,152,3,62,235,246,183,223,182,131,126,65,70,148,49,189,137,226,123,140,134,236,25,23,237,49,75,154,193,224,16,58,243,222,94,229,22,196,234,248,28,145,92,121,10,21,191,58,248,175,38,99,252,170,223,115,200,17,216,92,21,121,218,1,58,37,4,165,179,40,0,116,89,35,210,118,196,225,22,75,245,250,55,251,250,204,52,170,113,167,209,212,189,109,213,153,152,106,229,141,156,144,228,121,85,244,73,111,138,197,60,55,86,203,244,191,105,235,157,206,82,126,232,234,245,120,33,125,199,151,145,200,57,95,245,51,72,80,54,180,163,30,104,4,14,120,250,198,183,201,77,173,220,138,9,149,205,142,8,245,45,58,255,218,106,66,196,194,116,54,45,159,175,23,245,126,222,79,178,3,63,11,117,21,232,231,178,236,210,112,164,214,37,15,104,164,63,147,138,210,115,250,179,223,139,249,113,54,86,11,45,125,112,219,4,90,154,3,156,203,0,37,203,130,142,8,177,10,209,5,78,155,144,250,249,146,196,31,189,233,222,225,238,176,202,100,144,6,101,140,246,81,53,4,157,31,114,183,199,90,255,46,168,207,163,227,185,3,129,35,57,78,112,2,144,127,243,159,142,95,27,46,194,250,177,241,185,230,119,19,160,233,194,106,127,164,58,141,123,171,8,245,191,253,218,175,126,33,199,201,152,138,125,24,25,26,159,223,114,190,130,63,126,23,145,106,103,44,28,154,47,78,125,80,189,186,251,169,253,39,134,160,106,184,36,147,184,178,71,121,91,90,69,116,154,180,186,151,252,206,98,139,16,179,80,94,57,233,43,35,14,195,116,186,13,243,55,8,13,121,108,108,220,58,30,22,189,144,50,164,20,97,129,35,182,0,119,165,46,101,61,223,5,230,178,62,211,252,16,170,133,12,200,42,60,109,170,60,27,153,216,13,207,4,159,165,19,166,131,96,128,30,225,236,29,57,241,121,228,106,60,187,28,18,181,231,16,224,166,174,162,55,24,249,181,107,197,174,154,205,178,85,42,219,44,66,73,90,26,49,171,139,197,185,54,46,88,58,12,158,57,71,157,71,172,58,169,130,210,25,179,80,135,216,212,210,20,160,31,189,53,51,117,219,144,105,183,201,77,145,226,205,58,79,228,62,34,71,239,38,193,30,176,150,149,74,64,249,194,203,200,91,100,26,239,113,199,7,230,233,177,49,196,129,213,48,104,209,70,184,130,87,80,123,128,214,24,106,173,67,243,13,157,255,221,178,212,133,53,59,149,75,104,163,26,58,134,198,136,107,189,77,104,230,177,167,23,225,141,113,252,246,157,236,125,53,1,113,48,187,48,2,99,53,54,179,145,190,127,238,224,31,223,225,185,10,54,150,215,243,225,42,166,204,47,130,94,135,150,189,224,119,7,142,66,187,227,77,167,120,189,41,185,188,205,177,5,164,37,18,240,234,212,113,235,29,216,223,200,32,20,118,233,97,101,191,135,135,45,1,96,249,241,98,132,89,28,97,104,70,74,214,235,81,88,214,61,36,118,157,255,75,205,25,254,205,156,197,65,159,51,56,15,178,86,99,220,222,55,40,122,207,194,99,96,103,240,6,167,151,32,101,152,254,127,3,24,88,64,84,203,56,237,218,43,170,66,130,113,211,56,232,57,69,189,190,85,171,114,232,172,202,75,233,183,210,161,217,253,217,203,33,32,193,144,246,6,106,126,164,42,237,166,161,251,142,106,176,57,226,176,158,138,131,52,38,36,221,176,3,253,105,174,14,151,84,83,36,47,236,220,200,80,165,237,43,107,9,3,235,158,250,115,92,26,253,147,190,95,67,79,166,48,53,251,144,186,1,12,58,49,17,213,67,36,243,11,141,190,14,198,74,225,87,206,185,176,208,219,98,52,171,150,165,169,159,90,231,168,141,15,88,222,37,138,134,205,12,121,217,102,41,119,253,191,215,39,157,86,130,67,202,5,246,47,223,80,100,209,238,219,42,40,46,120,110,150,254,222,248,243,94,83,223,203,229,190,125,29,81,114,141,205,118,49,178,122,26,180,71,223,106,255,122,189,50,88,215,137,25,232,75,45,45,3,190,67,9,95,33,13,30,195,91,81,3,76,55,187,213,36,45,52,57,250,27,51,55,86,26,97,225,79,233,88,133,131,94,171,233,240,249,104,46,75,188,108,178,245,42,179,10,223,62,38,200,59,86,188,72,208,10,226,27,27,74,229,45,65,0,182,75,31,101,1,159,164,52,145,228,29,232,67,43,42,127,119,94,2,206,46,63,181,13,9,253,58,37,16,167,115,86,218,250,140,117,95,235,127,164,90,117,151,109,94,88,136,51,230,121,222,70,170,202,42,255,125,146,37,209,31,87,225,37,95,152,101,155,46,193,155,196,95,43,232,156,30,244,242,23,49,105,214,157,226,89,192,197,125,38,31,154,79,163,228,194,157,255,42,192,153,240,41,159,41,232,75,154,120,219,232,97,174,179,104,146,135,72,122,174,170,248,70,9,170,177,252,149,28,78,82,78,0,165,133,10,195,87,241,132,1,57,134,56,80,130,2,95,152,231,58,210,31,8,53,40,241,239,77,136,226,50,91,148,4,195,206,186,149,158,130,237,120,174,64,190,130,132,38,148,221,161,185,221,144,73,237,191,37,64,21,202,124,78,107,144,23,31,97,241,198,86,125,19,148,165,191,176,117,194,90,29,114,112,161,55,127,215,169,153,244,145,231,20,110,220,91,186,78,142,12,116,29,30,29,190,86,162,196,149,30,149,143,237,70,139,101,209,181,20,135,64,33,76,76,117,172,7,149,11,191,163,123,104,213,147,8,37,138,18,66,213,190,220,10,162,56,78,219,183,247,157,13,149,49,103,214,139,112,215,131,29,203,214,112,136,31,185,163,108,5,47,207,205,134,250,17,82,180,108,131,39,156,234,59,88,156,165,107,165,52,232,149,189,39,233,176,32,8,63,226,234,255,222,107,235,221,220,245,108,195,37,16,152,140,68,14,56,170,224,233,181,90,173,9,239,55,229,201,160,119,106,216,177,197,231,113,81,91,100,202,214,193,94,183,129,114,133,215,241,191,95,131,147,89,159,38,14,160,128,44,224,124,222,245,74,11,153,86,149,159,252,52,214,200,175,115,247,239,114,249,151,255,3,73,18,78,114,246,53,195,61,162,122,215,20,214,218,141,160,200,157,79,255,236,58,137,248,75,158,109,60,31,18,136,73,156,27,108,147,154,118,137,13,174,8,193,27,111,192,14,10,216,124,206,54,83,103,45,136,105,216,53,128,143,208,235,190,62,74,220,110,194,198,116,204,5,57,142,185,83,28,160,138,89,252,158,81,95,12,9,193,60,208,40,141,119,0,30,136,126,215,161,100,104,69,26,222,171,98,174,124,9,134,76,47,93,201,246,105,236,136,158,44,161,18,129,71,234,8,239,241,183,51,37,182,174,168,241,7,121,121,237,15,227,55,113,4,104,229,129,123,62,222,1,167,17,218,93,19,75,212,8,189,35,12,78,214,208,113,195,138,221,166,250,135,202,87,61,222,1,4,87,8,139,160,237,232,7,166,113,22,67,75,124,144,128,210,209,94,9,207,131,246,14,220,59,127,76,105,144,210,176,204,195,89,77,242,10,195,108,204,96,199,83,39,192,249,247,239,61,22,89,233,198,21,225,196,219,217,81,173,170,235,6,31,196,47,79,136,80,176,189,86,125,216,163,135,61,178,213,8,40,110,245,55,27,57,1,222,11,99,197,6,115,98,32,215,130,188,154,181,111,255,214,180,83,169,222,71,116,233,50,80,245,69,129,188,82,155,29,66,204,159,245,98,85,28,243,213,39,221,78,118,61,27,121,188,96,123,196,34,0,183,122,10,119,142,219,59,77,189,103,113,86,78,145,110,118,50,217,20,231,80,132,76,203,39,14,80,210,237,31,166,213,137,131,12,253,55,49,175,12,95,71,55,236,45,234,208,32,250,87,224,75,206,43,120,53,171,228,231,122,79,22,180,152,142,50,161,61,78,114,31,28,155,36,220,201,9,81,26,108,15,204,123,73,70,45,108,176,245,83,146,192,9,12,255,79,42,154,96,26,206,78,251,90,141,228,51,16,152,209,224,193,206,170,119,139,70,34,87,64,195,143,5,133,92,227,249,88,35,94,31,149,102,214,150,34,46,140,85,131,155,64,252,159,38,178,178,25,189,44,253,188,50,52,141,195,133,226,119,109,26,146,71,241,202,141,218,73,138,196,101,78,100,231,188,16,93,145,205,56,94,162,137,38,116,180,72,156,151,163,89,63,103,119,185,88,218,122,173,163,36,111,203,98,107,46,158,71,232,217,171,27,134,127,93,1,96,55,221,229,23,15,134,244,42,28,126,153,235,101,58,215,46,73,253,238,26,60,234,42,15,235,191,249,49,115,114,39,33,6,33,162,148,135,181,226,1,97,183,242,45,118,234,35,215,113,60,87,60,149,192,3,81,176,99,165,186,237,94,134,134,95,146,184,26,199,59,199,30,185,0,104,147,20,140,239,76,243,93,107,213,22,207,68,24,164,3,175,143,118,26,190,251,93,151,248,56,206,120,246,132,120,129,108,105,203,164,36,254,35,218,6,149,160,122,227,247,6,39,34,55,67,83,106,255,7,136,207,141,71,116,184,220,21,77,145,114,70,135,233,47,173,11,59,183,162,168,238,120,9,197,182,179,247,244,61,84,84,215,42,94,36,150,67,243,134,120,51,69,131,125,220,252,36,32,62,54,0,223,150,136,120,110,203,129,170,98,193,43,72,169,35,201,158,154,104,190,153,6,90,73,120,162,111,36,200,114,211,166,232,162,235,135,128,40,184,112,2,211,133,40,86,119,27,142,101,130,181,92,166,195,18,201,139,206,240,163,40,214,23,168,144,196,51,117,183,79,3,81,137,137,59,232,10,153,40,31,115,202,247,194,217,207,230,110,139,105,89,228,103,146,1,229,158,230,235,190,109,104,159,73,143,238,250,174,191,107,227,127,159,208,228,181,79,26,148,252,105,20,151,68,127,3,17,48,5,211,126,154,150,172,17,160,84,21,74,191,203,68,165,40,185,245,115,232,68,120,186,42,24,29,59,160,136,200,73,183,147,238,143,73,162,214,181,143,142,205,129,12,137,39,222,213,61,244,78,46,225,10,108,53,91,101,91,220,206,90,85,226,92,82,132,150,255,220,229,153,66,107,235,6,56,41,233,26,193,10,174,142,27,250,6,72,78,188,168,2,140,61,192,191,229,126,98,57,79,133,45,33,229,89,248,68,1,162,43,148,64,182,23,103,190,237,49,128,226,114,19,192,154,229,39,109,224,179,59,217,131,213,156,216,208,51,8,231,193,222,27,61,141,243,144,179,192,83,251,225,144,238,152,236,23,253,159,29,160,228,197,240,14,152,122,141,234,175,248,218,43,148,70,248,36,145,4,49,174,184,8,17,249,220,206,163,211,101,104,33,251,16,247,102,237,150,114,15,59,15,244,32,167,245,108,248,115,104,101,211,184,2,208,48,121,171,213,85,149,173,163,239,120,133,160,232,150,16,36,105,103,235,31,234,136,125,48,80,28,176,199,84,243,80,37,148,97,9,198,198,253,245,185,109,33,204,56,88,70,54,221,174,210,31,215,121,118,32,0,122,125,221,254,173,224,10,167,144,96,232,161,97,35,78,178,97,194,133,175,19,115,55,125,140,176,248,68,30,43,126,215,232,224,164,24,214,126,190,203,135,19,112,227,229,23,167,237,71,253,3,127,28,157,139,180,247,253,218,220,20,12,140,254,88,178,133,230,141,243,78,241,211,170,251,156,139,229,215,205,137,154,228,48,228,191,192,82,144,166,239,61,138,217,142,131,47,225,233,8,195,172,162,239,14,111,85,143,195,204,150,230,153,90,67,102,171,236,61,45,86,196,220,112,99,242,249,247,76,87,203,40,37,61,108,155,130,238,254,255,4,38,241,37,43,66,151,92,225,31,233,162,2,253,131,199,228,25,64,93,42,239,7,46,30,185,6,226,63,112,168,99,115,208,104,240,19,163,160,33,114,119,57,246,195,144,104,246,240,191,199,68,189,215,253,247,55,189,108,218,130,156,148,230,245,126,40,33,170,99,137,226,215,54,146,186,239,79,8,225,152,112,59,84,43,80,52,108,37,110,153,234,224,221,8,22,163,91,111,87,252,10,49,19,148,70,18,107,136,231,158,54,161,217,199,220,205,146,0,208,19,100,132,118,5,227,50,142,238,13,126,58,193,194,173,161,171,197,50,6,194,112,49,17,54,24,247,111,156,71,181,212,114,205,12,116,220,205,164,48,11,65,197,77,215,95,179,35,244,254,233,72,47,114,160,121,145,78,185,254,189,39,248,63,134,53,26,250,25,98,250,108,192,249,27,127,202,91,243,114,211,29,136,255,160,22,158,208,219,21,27,146,156,237,5,123,240,140,224,145,68,110,230,4,229,130,223,194,147,51,82,123,230,4,151,89,217,114,139,187,216,84,183,84,162,140,69,11,164,89,145,86,193,34,48,159,165,108,109,106,122,44,246,74,207,195,40,123,31,68,170,225,230,215,226,54,19,202,248,64,148,192,110,239,178,21,172,145,172,153,88,17,221,222,231,8,28,11,105,189,75,194,243,251,83,35,109,169,144,182,85,238,227,60,239,161,156,37,220,1,221,179,80,255,112,220,209,3,169,206,122,157,157,178,18,200,25,215,134,136,129,182,48,163,17,41,255,60,131,102,65,131,216,130,178,106,53,103,150,62,29,210,251,43,140,94,141,33,41,127,168,74,73,235,249,157,85,196,81,90,134,28,44,216,1,50,186,148,91,193,246,166,27,41,153,219,36,18,23,154,211,217,242,95,185,75,28,91,134,22,42,242,91,177,37,51,194,57,53,39,139,91,67,253,192,253,243,28,75,92,105,248,94,165,216,152,55,97,70,112,45,73,18,218,165,54,128,113,224,27,244,80,189,86,81,16,12,203,220,181,151,49,208,21,113,238,211,190,30,167,119,49,51,132,230,204,97,106,40,228,204,254,104,176,8,67,61,80,204,177,54,232,152,89,214,44,196,117,137,228,63,11,80,105,48,203,130,236,3,99,247,225,173,140,232,170,15,107,96,220,58,35,14,210,95,90,154,254,145,192,101,17,135,188,150,150,127,138,200,236,128,155,238,114,205,216,171,47,129,51,214,243,197,71,134,0,5,145,155,237,218,93,172,79,77,138,170,30,252,170,215,67,238,71,107,32,224,231,209,6,137,136,193,41,73,117,255,143,89,106,61,251,103,108,219,166,118,70,212,233,129,11,103,86,125,239,39,139,81,145,140,38,70,195,46,108,114,92,19,229,156,165,226,34,211,70,84,13,172,239,65,109,200,221,126,40,194,141,175,56,251,237,211,200,252,23,128,190,205,55,156,126,175,215,94,240,180,127,147,89,180,44,155,182,176,238,91,73,42,99,151,54,209,200,215,34,155,195,179,105,188,97,216,100,252,145,246,217,241,223,65,107,118,225,144,200,58,235,128,137,84,236,85,17,141,175,94,19,186,142,210,252,128,136,204,240,196,16,170,190,55,114,227,1,102,183,96,34,254,35,206,237,164,12,191,135,127,30,135,246,153,202,109,184,16,223,117,113,76,243,172,13,121,52,195,151,104,193,171,65,128,250,127,55,145,188,243,2,218,35,44,104,61,21,205,219,224,45,52,113,164,147,247,11,140,20,45,167,166,237,75,115,135,190,113,74,173,56,182,199,93,78,9,180,144,211,13,119,172,176,195,163,89,110,12,147,96,113,144,170,98,177,101,155,39,78,242,89,149,201,154,14,236,146,45,23,33,53,36,179,236,214,47,71,91,8,157,230,127,128,87,70,239,99,211,228,211,3,154,34,223,136,88,43,228,128,179,11,105,56,254,40,143,123,165,6,246,88,208,250,232,58,247,117,88,221,194,55,230,113,227,109,116,248,110,202,132,216,150,227,154,195,100,175,73,157,147,84,106,254,231,111,34,110,10,155,107,72,190,8,54,110,142,8,241,77,43,254,22,219,251,175,31,81,107,100,248,15,76,119,16,229,132,235,6,48,155,138,24,161,218,102,0,105,205,167,215,101,46,188,151,203,137,2,141,218,72,22,157,88,178,82,40,64,210,51,188,213,160,122,46,86,238,148,10,163,159,126,133,21,155,18,1,101,24,10,182,193,108,70,24,222,48,137,79,7,215,73,72,16,237,252,14,1,2,6,216,236,34,255,39,205,242,13,254,84,157,84,88,122,157,246,44,72,165,33,190,233,161,243,96,95,133,173,145,127,48,14,204,109,85,141,136,112,3,207,122,14,42,4,31,190,117,52,149,141,71,32,124,162,14,103,223,171,255,184,139,35,49,161,10,164,12,35,47,109,26,152,36,166,201,167,47,44,218,241,228,250,72,87,160,50,183,223,48,251,99,231,179,219,179,204,240,219,113,123,169,106,82,116,228,34,126,210,170,30,3,18,61,59,92,44,249,236,67,30,23,165,18,105,104,176,31,22,47,78,148,14,109,189,138,176,0,167,77,73,125,176,206,60,227,161,113,13,127,153,199,147,40,199,182,133,106,114,253,63,65,208,40,213,28,18,197,29,200,32,204,82,57,14,218,16,145,10,156,134,216,26,234,209,42,201,186,50,179,31,103,55,25,10,250,29,132,147,14,124,30,1,123,24,225,43,11,75,154,163,11,202,92,31,189,139,173,234,29,66,40,8,252,28,10,143,127,77,134,181,24,23,55,125,17,65,185,167,35,76,75,139,254,88,78,39,117,9,249,78,9,105,200,176,135,235,198,202,236,234,216,111,240,169,22,132,26,122,139,108,169,157,35,195,205,125,91,228,247,208,219,240,36,11,186,14,242,71,15,171,78,144,159,245,253,180,10,5,235,248,147,62,164,64,81,81,129,239,78,19,186,243,231,57,194,107,57,57,70,23,233,109,24,102,90,24,46,106,155,29,60,142,19,181,160,138,190,4,123,20,2,80,30,160,167,72,55,233,53,86,154,110,162,110,204,74,48,114,63,208,24,77,110,33,58,190,138,142,195,90,168,143,134,107,117,54,47,6,182,113,85,213,101,170,45,33,163,249,69,90,125,15,61,214,91,199,37,16,250,135,182,28,17,146,63,182,210,139,63,46,10,118,123,147,120,231,112,121,21,192,98,21,105,64,118,118,60,218,71,52,235,252,251,113,137,12,157,20,37,244,108,121,3,197,188,9,11,248,48,171,164,185,158,111,216,80,210,96,162,47,132,51,15,238,207,87,183,80,37,89,214,129,214,155,237,180,47,55,227,1,174,35,141,108,231,198,83,241,25,73,41,155,30,135,165,11,45,35,109,244,207,64,163,250,16,78,158,64,53,9,233,154,23,87,236,140,60,114,203,41,162,135,123,141,6,3,62,88,221,231,137,20,174,174,241,216,173,128,209,248,140,143,149,35,155,74,18,129,182,60,240,86,12,70,37,79,106,106,96,153,69,163,134,128,134,91,168,73,43,48,129,236,142,200,95,45,36,46,176,63,228,113,100,77,255,89,143,163,195,27,105,225,151,56,134,209,63,198,231,149,202,50,193,38,136,95,241,228,66,147,222,87,250,40,209,252,91,67,46,84,23,88,132,128,201,187,209,62,86,245,43,141,216,207,53,136,145,117,156,116,238,66,75,183,249,131,103,137,164,80,213,62,53,248,81,244,205,94,52,28,33,207,181,42,197,140,245,24,83,155,248,251,254,206,243,240,158,139,191,147,136,204,178,147,123,40,146,213,226,195,201,176,155,231,189,18,193,83,189,182,31,233,126,241,27,35,110,138,22,210,33,128,252,152,95,172,13,21,197,130,153,148,87,105,140,7,129,135,14,157,133,92,199,17,138,90,140,41,241,204,250,90,0,152,95,36,149,191,203,97,2,237,21,14,146,3,17,178,87,119,201,25,6,2,202,255,43,3,66,171,71,214,184,149,171,112,45,138,93,217,150,139,249,23,87,200,172,101,78,131,219,221,111,211,139,106,109,225,145,25,158,93,219,179,187,215,139,89,40,205,107,153,71,128,14,173,67,193,242,131,99,92,15,195,194,81,43,48,113,253,230,55,122,132,27,250,125,85,127,33,121,161,72,23,74,96,251,24,62,48,61,140,237,116,227,120,219,239,112,143,115,43,232,85,126,62,239,15,27,55,214,171,90,99,45,208,106,60,123,175,3,77,179,106,209,189,69,36,200,104,195,171,139,232,115,132,226,240,247,247,132,9,192,4,185,135,153,33,60,230,98,213,191,99,229,164,231,249,0,179,183,184,59,39,209,64,15,62,238,41,22,138,205,98,169,127,233,155,56,127,26,252,187,27,123,80,117,119,75,181,242,151,102,98,239,248,117,196,10,215,157,206,169,242,53,116,111,168,2,95,107,180,61,44,167,186,53,178,200,195,131,237,92,112,69,136,47,105,51,247,60,128,118,182,53,54,219,24,171,53,223,124,210,28,0,74,14,84,45,106,51,240,47,31,57,23,51,176,154,201,96,120,72,226,248,235,156,253,111,197,114,19,11,18,244,59,108,121,117,139,106,165,8,79,131,57,136,161,153,24,138,40,19,115,223,125,14,213,26,47,84,109,230,143,125,4,58,147,36,45,195,40,178,12,186,134,63,173,38,185,53,84,135,176,193,38,26,121,249,133,31,77,92,195,200,245,39,160,224,192,19,29,201,149,79,206,137,143,249,217,24,92,250,33,252,62,134,251,26,176,156,11,226,113,217,114,46,30,153,18,41,66,196,125,8,196,25,74,119,223,129,201,65,8,56,129,92,96,58,205,141,130,125,31,60,244,81,138,241,66,42,77,19,116,17,172,248,94,241,218,105,115,193,56,233,40,250,37,180,242,232,55,1,27,164,146,147,255,91,73,96,39,139,195,30,129,94,204,64,214,186,102,251,239,113,176,232,76,88,13,178,140,121,86,233,233,146,126,209,97,194,67,222,46,211,146,195,48,145,174,227,238,91,107,93,140,128,53,84,214,150,187,1,184,28,50,120,39,170,12,122,54,7,113,115,60,65,17,94,253,244,182,15,164,68,26,123,210,150,1,30,211,67,198,175,101,233,118,234,70,36,238,6,97,73,80,133,68,194,229,34,101,106,115,130,241,199,96,125,221,6,188,9,200,6,18,68,1,18,16,221,143,194,39,252,141,147,133,62,128,191,182,233,123,212,144,84,7,84,246,151,33,223,4,195,143,255,85,161,37,94,128,40,87,251,142,239,42,250,112,130,82,104,68,6,138,180,129,173,108,16,132,219,217,187,118,17,96,35,28,19,212,9,77,165,223,168,172,24,197,132,205,33,35,204,18,83,50,48,143,157,240,185,19,124,114,208,77,103,123,227,188,181,170,171,96,175,82,219,10,165,238,126,98,114,71,45,36,43,110,55,167,248,28,219,53,150,233,160,74,245,156,126,148,37,179,43,252,94,9,186,160,150,137,48,4,87,225,35,238,145,26,130,58,92,2,141,133,239,186,133,124,86,0,85,208,130,163,145,116,254,186,43,81,177,162,185,139,112,126,154,167,109,85,153,156,16,250,138,218,224,198,118,173,29,233,80,236,0,163,0,78,183,142,86,171,224,197,255,23,6,136,167,165,86,243,74,223,7,153,45,36,207,122,245,220,180,73,17,244,200,190,18,193,210,66,33,34,144,14,119,102,193,160,0,81,215,129,65,4,158,82,193,81,52,198,112,12,24,144,252,15,228,248,122,133,87,208,15,145,238,188,171,6,32,223,182,61,147,64,253,78,139,54,79,31,64,100,230,216,111,58,239,251,34,212,130,75,206,116,191,144,45,194,149,206,45,194,127,167,35,152,76,195,207,238,163,122,158,211,199,86,98,236,209,10,33,194,2,124,143,153,15,122,189,11,130,106,225,186,37,99,40,252,177,234,96,123,92,219,177,158,91,150,45,180,227,128,25,142,64,103,163,57,156,95,115,124,241,138,64,49,172,172,165,178,170,59,252,47,126,162,87,90,92,207,63,159,201,40,206,139,151,219,143,112,131,104,241,94,44,217,3,235,140,156,237,159,82,198,87,238,198,227,192,133,128,61,185,248,40,156,252,64,167,224,68,35,246,193,140,122,21,83,38,154,233,147,251,255,217,51,222,53,238,170,72,83,225,111,63,239,209,130,179,198,190,117,27,189,184,160,229,139,165,194,148,36,248,134,147,55,120,252,31,38,89,163,144,141,116,48,25,193,115,79,79,186,144,41,37,90,5,85,119,33,195,51,96,102,30,134,227,131,16,30,112,22,3,152,216,153,213,137,103,96,128,247,50,8,66,2,175,36,134,101,46,23,164,188,20,157,25,21,168,63,149,150,32,25,166,40,99,111,145,125,83,186,120,169,248,152,104,232,190,60,78,146,225,19,255,239,146,211,67,45,88,250,216,64,66,61,171,67,102,234,211,252,171,69,173,115,101,174,2,79,227,97,83,64,196,143,56,203,81,34,163,22,253,157,213,58,85,68,115,104,181,145,232,112,213,74,62,23,240,152,139,3,19,236,253,221,245,236,139,246,202,11,8,226,144,125,188,252,41,103,238,105,111,117,46,166,186,34,225,56,42,32,126,198,224,40,201,6,160,125,117,155,95,246,86,202,21,197,231,223,171,120,87,30,246,45,8,235,14,201,31,249,74,202,4,15,97,238,40,225,42,233,215,66,98,153,55,125,140,20,114,168,74,162,43,185,216,134,138,87,128,148,75,132,34,80,97,222,146,80,115,62,103,121,185,208,85,179,215,5,121,226,206,115,2,94,60,54,121,24,106,96,3,70,43,124,31,207,220,173,81,32,195,95,234,183,183,150,77,131,247,109,69,253,199,159,254,77,217,141,164,73,60,105,51,0,145,164,117,144,217,204,55,242,5,6,94,81,171,143,199,30,10,37,61,95,40,99,116,135,3,248,196,119,109,139,34,126,234,56,90,57,99,206,94,75,176,229,176,117,208,33,199,34,177,168,218,217,215,16,34,75,35,213,163,240,80,164,125,50,75,52,184,77,165,178,91,84,61,237,12,224,128,210,21,167,137,13,110,152,253,146,38,81,218,191,16,92,205,146,133,182,97,243,64,233,218,239,143,4,109,121,187,135,224,234,193,79,226,149,82,251,44,225,126,122,205,99,147,132,126,229,86,134,255,108,185,115,181,90,190,42,235,28,174,245,124,88,94,54,42,96,163,246,18,254,17,43,11,46,189,238,82,167,141,122,217,105,222,234,247,152,147,125,71,112,168,138,249,12,75,239,78,113,80,192,245,42,136,137,67,231,23,49,40,63,236,232,217,211,240,102,112,119,149,70,219,4,96,226,19,92,120,75,68,74,96,194,170,72,195,101,52,41,215,242,207,111,194,79,187,184,26,133,146,237,36,52,67,76,163,119,232,172,24,76,76,153,16,26,219,182,241,208,178,5,64,91,96,189,36,59,131,34,93,125,126,175,52,155,7,56,207,21,179,158,114,250,187,156,226,181,109,204,64,240,15,189,229,193,85,50,143,133,192,205,193,208,162,149,8,22,126,94,231,233,253,61,173,38,100,185,116,56,225,114,92,165,39,82,12,234,124,149,120,201,212,118,76,120,26,193,198,105,4,185,207,250,48,112,196,112,37,52,170,198,11,139,24,246,243,49,244,185,186,199,184,8,52,251,162,157,185,202,92,138,43,198,90,56,66,201,173,96,198,253,201,96,144,23,81,119,20,139,169,155,154,108,254,209,186,58,235,57,109,88,169,208,22,119,222,185,79,55,148,44,30,64,108,93,137,32,189,14,32,248,156,60,204,66,162,161,197,90,204,21,215,114,165,172,233,82,237,44,112,131,82,95,134,58,141,191,90,237,118,44,130,59,29,49,95,26,12,118,50,88,1,40,191,10,33,5,54,83,34,241,229,209,45,3,93,171,157,23,121,70,91,232,56,25,218,164,56,30,208,88,252,25,7,131,178,96,46,11,230,70,82,247,2,205,227,49,104,240,117,26,233,221,149,181,227,35,46,228,136,154,99,78,197,161,91,224,109,133,14,135,31,196,28,63,127,48,33,239,16,201,225,149,110,218,90,211,36,35,172,184,205,100,137,74,227,175,52,101,180,92,133,41,246,27,88,34,190,236,39,213,182,188,121,154,196,202,101,196,69,28,8,210,45,172,134,179,74,203,196,74,171,187,233,83,73,106,8,57,45,95,67,40,230,227,146,65,218,65,102,251,44,163,239,39,95,169,51,190,167,173,247,172,236,118,130,244,182,141,252,128,246,218,73,63,229,154,198,189,236,96,43,209,83,172,221,248,170,13,86,128,47,62,236,73,207,5,137,252,132,204,206,249,188,226,5,161,136,172,247,253,213,69,16,198,158,50,197,167,56,43,180,180,60,43,253,138,49,232,179,237,37,250,56,108,197,173,73,162,128,108,218,107,51,133,70,226,149,151,188,78,200,199,132,87,216,59,162,114,233,179,195,187,251,135,227,171,250,86,197,231,201,185,75,172,213,212,164,30,155,30,209,83,190,126,64,251,208,43,58,182,244,240,167,180,195,202,65,211,116,248,103,10,126,175,4,243,111,171,172,25,152,248,29,59,0,174,28,195,83,110,6,131,240,203,83,113,147,130,159,138,124,161,53,189,39,20,221,129,212,244,147,190,188,220,23,223,61,102,2,34,107,183,31,122,221,245,216,96,229,156,25,114,246,68,50,21,234,188,21,174,49,247,8,19,100,131,58,119,119,110,213,44,196,85,149,162,98,112,247,86,110,80,226,134,6,202,229,1,97,26,217,146,15,210,204,143,172,34,62,1,188,247,213,85,208,239,132,185,246,43,210,107,250,184,227,35,151,59,222,70,201,153,228,163,212,240,31,98,64,178,55,167,65,126,199,127,8,193,41,179,37,177,148,241,3,74,217,190,130,121,231,238,231,181,165,241,173,210,4,0,38,238,100,48,201,46,103,71,60,146,41,139,20,165,161,122,21,197,185,40,199,223,155,239,69,234,181,67,109,200,206,107,13,131,30,217,121,54,49,117,6,107,238,49,47,204,186,80,231,185,48,107,116,181,177,26,142,164,97,121,107,87,3,236,51,167,69,171,119,219,19,147,152,98,100,71,122,170,243,85,168,221,37,178,235,109,34,44,253,197,15,53,203,152,44,141,80,106,201,248,229,155,192,25,55,162,95,139,59,170,203,17,142,49,223,128,25,154,182,253,191,90,23,120,54,131,234,2,228,30,199,195,126,242,136,219,226,98,158,150,120,150,192,96,40,24,170,49,70,153,41,33,46,103,144,54,215,194,172,204,152,1,62,149,215,8,30,96,148,205,197,211,73,82,125,17,53,92,133,57,244,9,228,166,73,231,184,35,232,212,247,168,233,235,156,87,152,235,24,61,23,186,165,125,207,221,211,154,212,31,155,252,22,195,130,103,6,33,236,231,58,48,120,53,220,19,121,94,112,18,113,93,38,70,30,252,219,234,171,26,55,71,176,122,250,211,31,209,233,60,193,235,59,30,86,53,218,245,157,203,239,154,26,162,120,117,241,163,224,58,86,179,104,185,3,165,68,3,149,103,68,68,220,96,67,32,69,175,212,19,172,239,81,57,104,141,254,223,14,194,103,76,44,143,188,100,110,247,180,13,143,253,178,48,104,228,238,134,185,146,117,44,102,145,141,69,39,174,78,213,78,92,244,48,181,249,175,166,205,187,158,230,57,155,72,13,238,199,92,187,43,205,134,77,71,78,103,157,62,247,220,48,54,150,164,128,76,231,16,79,24,23,8,61,27,28,178,213,55,102,72,56,182,19,153,157,94,24,190,36,145,146,11,38,95,223,39,236,172,236,28,69,96,214,93,84,147,213,92,152,165,74,123,138,52,34,252,131,158,237,60,56,96,151,64,170,113,96,181,142,67,196,92,66,187,75,100,46,54,136,188,202,219,120,152,107,226,197,224,150,180,125,179,63,85,10,189,241,26,145,149,199,136,161,239,156,82,181,155,86,21,5,173,188,245,237,43,22,214,228,52,178,209,216,248,99,31,169,160,214,149,229,120,122,108,192,104,0,31,183,114,89,41,169,103,158,165,42,162,84,149,193,219,37,200,77,159,88,184,246,114,29,51,59,94,11,83,175,191,217,171,189,98,137,141,131,16,233,74,130,226,65,186,104,33,23,241,177,25,253,144,216,54,61,246,152,20,246,74,90,67,226,71,215,158,76,133,128,55,197,89,134,54,62,219,205,34,119,206,182,169,97,144,143,35,151,249,200,164,209,133,23,241,116,142,142,38,181,182,143,113,187,34,146,165,176,116,245,207,90,39,136,180,208,111,179,104,237,152,143,212,238,84,104,87,230,16,103,242,32,23,119,155,200,19,115,39,205,115,253,9,234,9,209,235,233,230,65,162,120,116,46,203,236,192,49,40,6,122,68,164,75,249,152,120,3,60,30,167,17,11,212,136,18,48,106,126,187,168,75,148,59,55,109,37,41,4,159,97,222,245,197,250,34,236,122,227,223,47,192,154,107,89,10,250,156,250,25,65,123,116,59,193,205,151,203,227,246,207,253,31,181,44,3,160,207,172,18,50,120,124,15,246,181,239,75,77,72,10,93,253,132,233,31,47,150,201,90,105,214,21,119,231,245,63,47,87,120,20,189,72,182,166,110,52,228,247,95,96,18,78,50,209,228,35,196,179,154,72,147,61,247,79,215,123,32,115,75,212,238,2,89,198,59,194,107,5,217,180,97,252,209,194,253,165,83,233,45,230,192,161,54,228,216,136,249,58,45,171,218,171,66,5,17,191,203,44,158,178,65,76,245,189,222,34,19,211,116,136,150,220,153,114,3,237,212,99,89,126,163,124,128,190,211,174,19,178,233,254,137,223,204,129,34,106,243,40,251,71,147,86,207,56,159,6,155,236,156,244,59,84,228,12,226,156,155,219,110,73,62,199,153,149,237,189,169,106,64,200,230,254,216,220,15,162,195,222,115,75,23,221,91,75,233,12,156,211,118,35,106,195,162,180,4,34,82,94,230,92,160,250,137,228,96,76,117,45,193,169,61,16,3,236,87,221,125,83,173,205,135,187,143,231,69,209,123,48,196,221,112,192,192,222,32,208,60,141,72,237,16,220,87,230,55,14,202,54,96,195,161,183,5,194,254,68,175,155,32,96,7,83,64,110,74,74,181,126,222,28,93,29,219,166,21,221,172,154,203,195,32,191,160,163,204,17,249,78,237,229,139,126,251,100,236,189,232,173,80,183,178,201,135,169,40,252,173,229,147,206,109,77,142,249,190,77,117,162,98,44,137,217,25,210,248,199,235,230,116,113,5,40,83,164,196,4,183,179,126,120,206,71,164,56,200,10,109,166,236,64,22,223,79,171,55,112,165,151,131,133,141,224,45,167,151,86,50,226,80,209,101,117,211,133,5,142,91,24,101,229,117,3,187,130,170,112,29,193,135,22,215,185,132,188,246,165,172,112,16,190,59,237,79,166,79,205,254,143,163,121,135,171,100,200,242,219,117,182,176,36,75,50,151,19,80,203,250,40,53,119,164,184,75,78,140,152,118,180,44,71,97,176,193,227,218,119,38,105,36,182,137,187,245,163,108,250,218,13,22,147,85,182,211,225,158,219,146,65,160,16,213,69,114,18,122,185,214,80,169,186,253,146,0,239,73,239,98,104,48,16,220,208,23,191,101,231,234,178,93,235,80,140,254,40,104,224,59,214,56,191,113,33,159,98,238,30,220,191,120,29,167,226,79,140,228,190,222,4,166,110,57,223,225,139,144,255,94,136,247,192,180,23,96,78,172,242,72,191,86,11,82,115,59,154,25,124,117,25,23,193,246,212,207,119,72,28,175,66,242,134,118,224,183,232,204,93,15,237,119,97,178,84,241,166,62,114,90,5,54,221,229,92,235,153,225,122,55,11,142,173,53,197,13,144,111,185,251,252,100,69,101,166,26,82,1,202,227,137,138,172,109,123,130,103,77,80,118,80,13,87,90,73,183,60,144,111,254,102,175,100,53,63,89,174,172,96,85,109,30,221,213,71,202,144,103,218,63,254,5,138,148,101,150,96,98,75,27,154,221,16,2,129,72,85,26,32,203,205,222,115,159,251,58,160,223,243,116,67,110,50,172,115,20,83,208,50,16,88,24,53,187,223,120,61,109,97,86,171,176,251,170,30,139,161,47,229,161,210,37,61,72,1,14,250,163,94,141,56,117,204,114,173,3,61,13,49,140,126,118,213,161,5,202,98,96,170,67,46,74,13,126,239,40,183,108,184,5,73,117,181,198,3,136,66,6,254,249,253,36,151,248,3,122,217,161,35,127,198,41,158,80,8,51,197,221,239,45,100,75,31,49,109,68,89,233,107,76,198,56,51,199,194,44,252,117,209,205,77,25,101,146,69,125,118,143,195,58,199,198,22,10,121,18,77,199,162,57,76,73,131,139,70,237,54,157,54,59,181,40,233,138,173,158,92,42,156,51,214,49,101,249,81,109,137,133,97,190,15,244,104,255,223,77,95,47,144,18,95,225,239,218,243,246,220,115,169,88,87,145,228,196,136,126,178,162,131,138,249,92,2,40,161,248,131,39,145,104,226,44,29,63,227,255,126,84,234,136,15,244,96,178,49,159,166,132,140,242,64,191,24,103,56,249,13,23,211,56,247,206,15,200,77,39,52,190,166,249,155,61,230,251,242,165,144,89,125,162,210,130,129,10,126,127,153,139,51,223,83,164,38,33,156,85,119,159,166,97,73,229,194,88,199,161,180,61,131,98,12,94,103,44,197,38,146,71,0,100,21,118,121,96,55,21,29,25,238,49,187,27,40,66,40,65,188,217,196,31,10,1,218,16,145,31,160,149,211,59,64,4,141,241,183,42,54,194,45,8,157,235,154,182,44,247,223,144,253,45,67,162,195,181,196,199,219,87,12,20,94,216,198,230,206,209,128,152,90,48,186,110,86,222,60,147,13,168,95,53,45,254,99,226,136,129,232,57,127,233,58,162,169,98,40,61,86,185,115,234,170,241,43,31,133,224,164,175,252,178,187,82,159,73,205,152,44,151,163,120,142,64,235,139,50,168,116,163,100,133,193,57,158,39,130,212,212,80,68,63,86,62,82,219,78,17,177,3,96,255,63,102,224,229,0,25,129,135,9,193,80,199,71,229,200,62,114,221,73,63,55,236,88,247,22,169,174,247,95,105,55,89,78,149,183,74,17,168,70,212,3,214,231,23,145,106,27,234,30,155,50,223,6,174,208,194,245,36,55,20,65,132,163,202,236,34,86,120,30,237,70,151,252,154,65,99,52,130,76,15,171,155,244,162,192,233,192,147,184,174,236,101,16,252,43,47,220,183,62,119,55,124,156,167,80,194,85,184,15,245,122,61,86,25,161,10,104,124,127,13,138,180,180,204,2,248,141,154,181,204,187,234,7,231,165,51,198,140,18,60,59,41,253,205,237,13,177,64,87,133,71,21,47,139,113,86,9,241,15,236,163,122,158,224,26,11,71,186,190,112,240,113,14,113,210,240,60,11,161,69,11,6,98,25,64,64,112,220,50,100,18,208,146,176,13,98,236,37,72,163,245,8,12,211,188,33,40,16,199,8,71,226,227,92,91,99,180,159,243,211,111,182,12,249,247,247,170,206,15,32,175,54,119,48,169,250,26,194,228,178,97,233,76,134,126,208,236,191,66,115,125,160,35,4,218,18,229,100,90,52,197,126,140,237,136,228,178,116,60,150,167,101,57,255,78,41,147,107,162,131,221,176,160,19,67,16,3,159,235,7,230,23,148,236,66,17,113,98,212,158,199,98,17,98,132,230,228,101,33,38,4,178,77,54,63,56,233,80,245,96,26,165,205,88,150,127,84,48,117,170,179,235,224,7,50,113,38,148,136,234,197,121,35,150,232,106,182,170,60,246,48,107,85,60,89,140,28,23,1,70,233,10,70,144,75,19,163,37,37,244,28,115,226,46,246,125,229,186,162,255,177,172,90,237,242,126,42,11,228,33,252,87,227,71,255,62,66,53,166,86,133,156,28,28,209,175,169,9,236,156,53,247,161,10,69,226,70,109,191,158,248,23,93,207,191,237,220,167,71,78,92,44,110,39,195,238,198,89,85,33,74,159,162,214,52,85,221,77,227,145,238,183,198,219,103,19,3,242,197,122,148,104,14,245,195,42,194,59,227,65,107,112,217,235,201,71,158,108,87,58,72,132,112,79,169,255,217,117,186,139,7,30,172,248,233,127,155,119,154,20,112,240,157,46,85,110,142,22,217,97,22,32,88,113,246,224,3,78,95,67,168,242,159,140,3,121,67,194,218,49,250,84,6,244,76,209,64,196,137,245,141,222,114,196,96,18,134,82,110,118,254,194,78,246,187,3,1,204,104,252,100,175,83,86,212,28,64,148,64,59,200,170,74,180,113,172,228,244,196,61,6,126,115,222,223,218,50,170,128,35,98,25,148,229,162,155,84,145,53,75,235,105,188,52,202,36,187,184,122,14,128,83,90,22,7,124,232,225,196,67,4,186,47,193,246,57,213,152,2,244,72,3,219,29,35,75,145,207,142,8,4,253,157,133,27,73,41,150,97,188,72,57,245,20,115,177,219,172,180,116,0,121,8,78,178,127,163,135,210,203,234,174,50,255,156,169,105,45,229,40,30,122,133,146,209,54,173,109,134,139,76,39,155,190,251,50,111,47,65,32,116,168,61,110,174,117,65,1,205,220,222,3,254,134,31,147,180,144,96,76,254,231,17,127,126,53,17,113,39,230,97,72,105,152,21,182,20,232,145,152,120,131,1,150,9,211,254,142,79,25,94,60,94,242,226,229,76,44,245,132,218,148,108,49,24,253,57,109,178,96,169,137,157,248,170,45,244,198,164,9,43,111,194,166,178,107,163,179,85,98,25,133,7,108,129,255,120,93,52,188,101,230,221,249,232,177,160,73,25,71,156,41,197,252,216,200,43,208,104,153,213,243,123,21,227,180,219,151,244,241,36,250,4,47,152,163,88,142,63,178,194,151,234,100,15,229,39,249,169,47,255,29,145,171,144,53,99,251,102,47,131,101,204,245,46,249,223,55,247,5,189,247,243,120,226,236,229,189,128,233,97,174,249,207,181,131,205,229,113,135,89,22,28,191,234,71,9,147,185,55,89,124,40,214,35,35,138,16,71,247,49,95,51,5,194,23,7,253,87,241,83,123,166,14,32,108,37,190,104,123,193,79,36,154,0,62,160,62,76,118,238,210,19,227,7,35,38,157,60,220,88,214,214,115,44,192,61,125,93,93,172,166,242,245,212,249,92,10,223,188,238,238,244,134,217,191,46,179,151,223,168,17,120,90,162,84,18,239,12,198,63,168,218,168,52,28,119,47,90,5,141,28,112,136,1,204,125,225,203,90,123,36,188,111,65,207,48,106,203,69,124,48,56,41,83,113,218,140,112,59,121,32,217,170,123,211,21,156,138,249,61,204,120,200,200,218,150,244,222,217,147,251,195,182,154,143,25,13,149,241,221,177,89,168,21,164,123,92,41,120,36,4,211,22,181,223,197,96,0,55,55,154,165,254,203,205,22,39,236,184,168,69,223,129,6,210,136,108,170,133,109,134,106,181,241,183,218,233,99,232,18,4,138,187,254,136,119,94,162,242,36,53,107,247,19,183,102,25,73,210,75,207,17,223,149,159,81,252,47,68,40,183,130,125,186,57,43,121,69,18,143,236,114,199,241,74,206,199,185,98,210,243,166,137,37,129,248,207,192,101,120,35,11,232,105,163,189,232,185,187,189,51,227,151,178,14,54,107,25,144,161,42,159,158,177,137,199,252,102,244,126,202,169,76,176,23,183,25,12,215,167,121,166,246,78,29,211,139,45,151,227,43,11,95,221,169,65,222,72,50,216,239,195,156,20,149,110,180,131,175,59,239,70,158,64,126,181,9,157,42,69,127,67,61,188,111,9,4,164,4,180,42,143,31,42,245,111,183,23,220,108,204,84,255,73,20,195,39,202,230,68,124,111,135,65,77,165,52,77,108,17,120,229,121,44,216,51,45,184,17,172,48,66,3,201,214,72,134,199,19,51,248,180,244,187,20,116,33,116,240,12,117,39,149,249,119,200,214,190,43,235,90,63,46,16,27,234,148,68,183,188,160,156,198,46,96,121,76,181,81,127,6,110,74,146,248,251,216,11,125,29,158,13,218,248,56,158,144,33,89,10,137,57,59,221,128,212,237,119,190,14,198,41,10,252,232,201,190,95,4,117,248,33,49,11,184,167,123,190,185,83,145,30,27,77,152,243,106,10,45,213,30,130,30,219,50,72,179,10,51,132,39,123,179,55,12,25,214,66,204,171,211,184,43,4,63,214,25,230,194,72,56,196,214,33,145,106,253,178,118,145,197,19,148,91,212,225,41,186,229,76,192,82,209,214,252,64,199,8,2,231,117,47,245,117,43,144,1,205,27,32,15,205,35,127,65,200,57,111,217,101,124,27,167,53,96,7,243,5,200,85,162,85,117,87,28,67,220,122,152,23,84,87,56,7,67,126,224,200,246,24,44,24,79,149,87,61,133,0,34,128,186,207,99,152,76,3,121,71,75,103,59,65,140,230,24,113,242,85,186,37,158,232,39,28,17,89,209,86,7,238,247,79,183,19,205,132,132,72,230,166,224,144,136,153,57,77,118,127,238,127,185,195,26,235,151,68,3,219,3,216,121,184,175,243,210,36,234,101,227,90,153,33,0,29,139,60,187,157,81,252,181,43,202,250,96,26,242,151,6,55,21,198,63,53,25,157,90,123,206,147,18,43,103,167,157,221,113,30,162,53,231,139,222,74,124,147,213,97,112,66,75,34,61,111,103,125,81,49,46,63,119,133,29,255,12,54,69,180,39,66,36,255,124,69,41,151,162,241,195,45,85,72,68,211,72,126,157,34,123,254,75,39,52,4,113,21,187,23,145,226,47,204,185,206,116,245,82,96,199,229,247,134,13,116,67,244,161,182,44,172,241,231,86,181,192,165,32,130,255,215,49,73,24,231,78,175,94,212,129,247,106,90,153,249,195,237,82,22,179,169,157,90,105,253,191,224,154,85,111,171,85,97,58,172,17,13,144,213,126,67,46,144,22,195,2,41,101,112,58,39,74,77,123,75,18,35,117,80,124,54,117,31,1,195,19,22,29,137,107,238,22,25,39,112,80,154,146,47,187,98,51,79,214,148,225,85,159,43,40,83,152,136,187,30,254,233,251,206,72,49,99,164,141,34,236,168,5,79,189,106,178,79,143,224,26,157,79,233,36,254,149,194,6,184,18,104,118,58,55,75,170,213,10,170,135,11,59,148,45,80,193,185,201,88,87,153,209,135,198,127,226,163,43,154,91,229,105,182,81,108,55,211,29,137,214,249,26,100,213,232,30,105,241,141,89,91,23,203,103,113,6,11,72,141,234,175,228,35,253,176,137,142,109,228,225,115,243,93,35,196,12,51,36,81,172,89,157,110,106,42,157,79,206,7,140,246,236,9,107,67,90,2,251,208,85,224,102,2,217,32,92,208,223,9,231,145,7,125,113,73,253,242,47,112,242,13,127,126,225,50,248,180,144,54,184,63,232,220,60,222,106,177,29,69,254,233,229,44,133,253,106,132,200,132,109,48,191,13,4,132,85,112,78,71,7,251,56,147,143,71,142,201,190,212,223,105,31,216,58,28,159,58,7,107,11,254,101,122,245,223,234,37,151,83,145,57,213,223,138,28,145,98,60,144,13,217,180,116,208,154,166,98,21,42,13,110,126,123,241,191,57,141,31,120,220,192,127,220,245,5,75,127,253,13,77,121,19,21,131,143,41,197,40,95,63,6,69,68,215,72,51,99,5,247,88,86,29,25,172,73,0,14,48,116,156,95,130,232,14,36,161,189,127,57,182,197,210,104,191,69,164,111,163,19,38,144,51,231,245,73,13,20,151,232,85,30,149,18,176,158,45,154,174,36,174,31,129,5,152,210,86,100,142,3,175,151,4,9,82,226,110,38,192,15,115,85,53,125,91,184,182,3,142,39,212,194,211,151,131,175,140,185,124,134,152,20,87,240,166,58,154,129,4,90,174,221,59,3,49,153,148,233,230,178,9,232,159,217,116,54,181,106,202,175,153,240,32,193,67,245,75,90,209,35,39,111,92,72,197,158,182,153,195,94,27,246,151,133,168,24,245,70,2,228,216,218,137,193,134,77,55,138,114,169,25,149,19,229,176,35,148,219,244,132,80,129,255,136,99,37,214,127,127,230,242,220,242,65,246,27,25,228,93,110,44,211,157,172,159,89,108,219,6,179,52,24,246,205,65,200,217,69,112,202,123,183,67,234,133,74,206,149,162,200,84,60,128,236,254,155,130,38,139,137,109,138,233,82,212,153,78,100,197,185,52,46,59,18,243,117,117,27,122,191,162,244,196,41,51,68,163,75,235,178,232,194,133,148,121,101,233,34,196,252,146,127,168,159,150,68,42,53,248,28,50,28,192,237,180,214,104,35,38,113,145,99,137,114,70,156,43,187,82,149,59,117,47,241,44,1,137,177,223,234,91,202,173,84,143,87,210,160,169,163,58,143,138,96,36,153,69,86,46,161,138,248,27,90,236,26,112,98,93,116,67,24,87,215,225,87,129,215,101,216,186,19,11,136,61,120,72,245,203,88,186,227,254,4,188,75,245,79,195,156,210,8,61,74,215,75,98,109,233,18,93,137,43,88,51,100,30,151,152,17,27,17,199,47,81,149,18,217,191,120,28,196,21,97,212,77,25,103,85,16,141,170,155,156,178,109,144,240,190,172,143,67,161,87,54,71,211,82,236,10,162,144,34,34,45,169,112,206,52,221,238,108,67,69,253,208,102,213,193,169,174,186,138,11,29,227,81,82,91,87,195,254,9,220,50,159,63,222,42,136,80,182,30,146,162,58,98,237,156,118,92,41,51,91,254,105,90,185,101,148,3,237,74,204,91,235,210,77,24,156,86,226,192,220,113,161,148,65,238,224,41,185,214,163,241,189,57,229,118,43,17,81,7,252,45,220,194,191,145,118,166,24,233,129,152,115,137,253,42,49,253,184,36,138,119,188,61,126,71,211,131,195,68,29,110,116,202,219,29,181,171,69,22,177,27,159,214,37,174,10,244,183,121,13,224,121,140,4,221,55,253,45,53,44,94,69,234,194,246,151,96,159,230,253,18,74,8,123,98,78,195,233,125,197,26,101,101,176,161,214,109,45,244,76,166,239,161,42,78,63,161,22,106,55,85,230,225,20,248,4,32,47,175,97,150,241,15,139,134,14,246,183,252,108,173,15,86,206,230,218,140,72,184,20,159,68,82,194,209,115,141,97,143,96,72,249,111,3,207,21,92,166,253,188,43,113,5,167,188,49,80,176,247,39,33,67,145,120,99,37,233,23,29,103,160,14,145,7,122,245,16,41,245,83,241,155,55,175,115,123,242,122,76,207,254,216,99,230,117,138,52,127,32,73,106,131,71,129,148,122,39,152,92,32,60,208,112,119,129,78,244,49,46,20,85,142,216,45,43,50,132,217,58,148,255,59,58,165,188,65,73,202,191,28,129,206,107,109,127,146,5,47,75,252,78,200,121,73,146,240,35,21,234,208,50,105,62,167,100,229,228,223,196,28,248,156,183,85,199,222,202,36,230,195,51,71,26,52,191,112,140,237,43,170,231,181,229,40,78,149,143,179,183,150,253,137,244,228,107,48,78,255,234,174,19,47,75,188,224,128,163,162,84,45,99,198,13,38,169,42,55,47,229,88,189,49,21,210,123,112,211,208,213,61,99,78,229,243,5,81,160,22,123,106,72,151,195,30,220,9,85,207,218,232,36,33,188,50,185,21,214,51,32,180,118,13,31,86,0,14,187,119,205,180,7,123,146,116,255,243,170,245,230,231,152,80,0,151,237,178,226,181,98,148,105,104,177,50,19,143,166,116,8,204,209,27,159,108,178,31,14,80,211,57,194,205,225,184,175,11,104,251,20,120,149,179,159,22,92,255,7,45,141,207,214,30,134,222,196,200,27,124,36,186,73,220,178,22,174,184,231,125,167,168,199,170,146,55,177,162,148,176,155,161,148,134,249,32,107,110,234,134,173,158,41,193,109,71,95,77,98,194,152,182,112,61,239,69,162,79,36,19,46,5,236,51,197,84,27,79,163,115,45,97,223,20,181,182,167,92,42,52,172,146,246,163,15,214,44,235,250,111,147,61,9,148,24,253,228,94,142,34,47,132,125,252,245,178,247,141,209,85,116,124,190,22,162,59,99,88,156,76,113,96,167,27,76,75,131,103,52,105,13,152,7,52,175,76,81,132,8,2,94,108,144,248,252,82,190,134,170,177,165,116,35,87,216,68,97,96,248,120,5,241,79,140,163,165,214,27,219,45,161,188,94,166,203,202,90,204,79,177,94,215,143,204,122,193,59,240,90,102,220,183,1,199,188,250,217,119,178,220,97,139,50,90,210,70,254,29,212,110,7,116,129,129,104,41,137,105,63,59,112,239,233,25,246,104,126,41,63,83,182,221,226,64,82,198,51,122,183,140,123,205,48,245,27,203,131,203,26,107,44,221,66,144,212,219,1,140,49,166,13,134,198,212,208,193,181,93,196,18,60,122,135,182,171,145,103,32,28,120,116,110,193,111,86,63,99,116,38,104,206,56,165,84,3,37,239,100,245,1,99,174,11,157,20,29,0,2,144,124,112,233,69,49,144,187,168,153,53,237,82,33,247,213,109,18,109,71,122,40,83,39,201,246,123,156,155,222,29,46,97,9,58,125,245,75,188,243,142,167,40,52,73,194,40,106,166,178,253,179,213,5,139,57,145,86,125,174,198,68,68,4,31,242,63,171,214,91,146,130,60,255,132,1,127,223,213,28,90,191,236,31,94,210,44,130,84,20,174,132,65,13,239,172,25,150,24,227,209,30,30,197,202,113,194,97,68,208,72,187,251,250,228,122,170,187,11,250,103,6,66,134,235,156,52,195,104,50,149,144,237,218,151,164,15,253,251,33,15,212,134,89,254,130,219,55,10,119,175,190,154,143,123,225,9,251,187,134,94,12,168,224,224,93,62,136,168,155,141,20,239,176,41,144,58,118,48,27,63,124,210,80,253,156,61,97,245,5,227,68,97,172,130,174,59,140,127,181,158,72,240,133,91,114,37,118,16,40,110,94,1,92,48,166,52,33,79,177,22,24,253,167,23,230,85,156,34,4,20,151,216,186,166,30,243,31,105,112,128,225,90,217,91,7,27,9,107,94,30,223,132,80,143,29,191,130,7,229,79,80,252,183,131,114,60,165,145,126,8,154,0,105,243,113,208,243,38,181,207,57,146,244,38,155,233,36,217,1,108,164,33,35,247,194,26,59,36,237,22,124,220,12,62,207,60,168,79,120,26,46,242,43,186,139,215,186,216,17,71,54,75,125,208,153,23,19,42,170,135,146,237,157,185,130,249,251,131,55,132,233,186,54,94,16,255,4,63,205,55,87,147,54,46,236,90,199,219,87,118,191,185,244,247,201,185,68,102,130,128,136,129,202,189,33,137,1,66,25,227,242,18,225,18,98,53,68,145,42,144,226,106,112,140,251,61,172,3,12,130,130,173,5,137,164,244,15,3,32,71,222,150,50,155,80,248,177,10,28,7,41,14,95,162,169,226,25,36,208,103,175,104,253,156,109,44,46,205,171,228,91,72,133,101,34,35,139,83,159,4,231,125,20,96,97,219,140,183,240,58,24,99,159,209,176,142,199,73,229,209,134,30,232,73,186,220,191,193,131,58,245,100,179,161,254,103,235,56,142,250,42,150,17,227,251,0,83,158,211,193,102,202,139,226,195,42,183,252,234,215,112,7,17,51,136,188,242,50,202,44,195,83,134,213,253,245,193,42,231,200,166,51,117,63,224,8,83,246,117,219,13,141,20,8,45,76,114,93,115,164,74,208,102,115,156,146,59,208,174,130,115,63,82,143,102,27,224,13,208,246,206,188,106,65,248,47,114,239,88,110,13,87,144,115,122,117,0,113,32,57,165,104,56,62,11,95,171,180,184,112,15,162,73,118,64,49,219,239,60,82,182,112,221,100,42,172,11,111,249,102,235,99,70,129,28,85,139,79,54,97,98,232,242,167,244,116,142,225,12,239,69,34,230,197,91,137,69,242,126,55,34,142,109,20,156,153,126,61,2,139,56,52,173,141,241,165,93,141,29,64,236,39,133,100,7,235,130,178,223,198,43,253,174,151,146,241,169,165,232,192,96,166,83,255,224,43,156,210,118,26,95,80,59,102,217,142,155,5,98,234,48,195,147,177,148,146,153,154,85,194,211,86,59,153,166,95,104,14,139,206,146,28,218,196,109,47,159,193,58,165,103,67,241,7,96,137,104,21,184,94,47,90,41,249,66,42,90,67,50,34,15,122,94,124,227,3,213,182,110,103,163,172,213,17,38,190,196,234,116,36,16,54,233,174,253,35,121,33,137,77,249,74,47,221,185,107,76,83,236,70,133,210,218,122,30,77,206,111,139,202,225,157,102,251,46,78,141,5,61,177,25,184,232,104,132,132,81,251,26,196,45,30,141,203,140,235,59,69,42,16,8,122,233,35,70,93,216,252,233,78,248,93,63,50,196,252,86,174,224,232,17,9,104,237,209,233,170,169,17,116,207,111,237,173,50,159,112,91,237,240,239,168,141,207,27,83,191,46,190,95,160,14,119,4,180,95,135,131,111,111,150,197,127,234,250,32,152,191,193,103,106,58,65,207,97,127,184,63,108,14,129,251,139,245,193,179,221,158,51,166,73,174,102,255,197,81,103,7,167,114,148,159,134,30,182,167,147,103,233,20,214,143,66,254,129,128,117,83,235,85,13,108,234,4,76,216,163,107,147,146,213,218,71,84,162,105,223,81,22,29,195,74,110,234,181,48,57,71,108,192,40,247,9,61,167,19,106,207,79,115,208,180,98,65,174,87,183,170,143,14,189,77,128,11,77,246,191,40,77,231,145,251,108,179,189,62,145,105,55,120,124,46,115,168,250,142,13,240,174,97,36,199,41,220,55,65,59,248,64,83,24,93,37,201,97,85,156,241,118,81,240,39,72,121,87,114,27,79,18,130,151,154,97,222,191,192,38,70,189,28,95,134,20,82,38,115,19,127,253,78,14,136,209,14,78,105,245,165,5,158,250,236,12,118,24,182,19,163,22,73,111,77,129,153,205,135,25,49,122,97,20,139,26,52,33,135,178,186,85,30,126,254,114,24,93,252,60,175,250,145,176,9,175,122,198,74,202,237,79,41,234,220,93,63,60,200,91,145,145,213,117,144,42,250,241,134,111,2,237,248,204,0,94,201,174,33,14,129,10,20,178,81,212,112,203,237,35,241,142,211,75,74,0,207,28,120,21,179,87,234,88,13,9,57,188,140,150,222,186,183,184,51,155,208,122,156,111,235,64,243,225,74,212,65,204,164,150,87,82,46,206,4,211,180,130,14,142,90,61,194,87,158,3,41,136,107,4,133,28,11,45,24,206,219,171,151,247,167,69,241,206,162,226,153,36,221,54,26,186,174,192,209,124,222,0,101,16,166,117,231,113,42,96,141,111,254,0,90,49,9,190,84,16,177,26,36,100,193,146,43,78,216,19,250,177,220,166,6,81,154,200,210,21,156,84,17,36,44,165,151,65,72,161,19,136,13,177,6,91,206,49,43,74,8,48,241,150,192,17,218,49,207,22,204,70,65,45,221,26,90,20,21,24,98,174,39,204,75,101,81,140,0,125,162,154,227,118,242,117,197,115,135,9,164,213,158,73,42,8,231,179,190,170,101,218,135,249,100,204,17,188,151,97,175,20,76,200,236,53,141,64,173,148,197,247,18,127,133,224,78,217,166,98,132,9,189,229,240,102,232,88,170,204,243,190,246,218,151,218,16,204,131,255,107,201,203,174,107,136,70,168,83,11,106,187,89,13,25,191,13,65,185,194,144,50,237,209,78,161,174,175,20,89,20,161,241,209,182,112,180,73,9,149,90,169,196,167,99,69,207,96,191,115,225,227,100,42,74,15,206,145,232,102,47,162,188,124,187,202,22,251,50,133,239,17,115,148,218,14,171,72,30,108,127,250,82,62,30,166,12,102,155,69,31,170,164,187,234,229,0,119,49,184,206,170,89,218,184,226,208,67,48,249,89,249,44,133,42,46,65,184,68,156,214,183,201,220,71,116,253,227,228,113,196,103,54,66,183,172,227,240,186,115,253,66,120,3,143,0,210,60,7,245,83,199,0,175,5,163,38,206,91,51,25,180,23,141,99,165,236,92,8,119,110,163,241,33,246,172,167,25,238,68,11,190,38,54,101,205,57,75,54,133,207,48,46,200,157,141,113,11,144,122,202,131,110,57,179,215,128,135,72,189,244,118,182,157,95,206,164,115,135,124,57,59,66,185,70,230,105,219,213,178,253,240,25,243,227,87,57,141,43,169,3,25,146,89,220,47,118,244,6,171,27,38,214,110,117,26,236,237,71,239,27,110,241,58,241,32,159,35,109,36,53,173,131,159,57,196,38,128,156,253,196,253,165,140,247,193,81,35,86,3,184,184,84,45,206,183,213,42,141,254,95,94,70,189,88,30,90,161,225,93,90,150,45,170,136,164,129,160,133,160,74,23,57,116,160,191,184,76,231,36,30,53,13,186,172,116,253,44,37,98,153,3,53,104,56,91,74,179,188,198,186,67,84,190,44,135,170,205,2,10,59,119,182,150,228,221,135,49,53,82,167,242,87,53,16,204,67,113,87,245,31,233,48,125,175,128,185,179,77,37,168,57,223,240,54,85,83,7,45,90,127,4,146,184,178,36,156,47,65,107,109,28,125,27,219,132,187,171,193,4,63,131,133,252,146,108,157,6,0,171,253,136,88,18,103,33,243,245,23,61,26,25,235,212,191,1,87,181,145,151,251,242,241,70,169,205,126,20,166,160,123,210,73,120,84,15,169,157,166,130,85,66,155,113,166,102,226,230,60,17,218,9,150,154,233,133,42,207,143,82,91,158,188,135,22,1,156,98,146,45,79,118,16,65,236,40,182,57,58,175,108,54,111,203,208,206,183,160,153,77,111,146,85,151,130,99,229,21,176,127,25,63,153,182,152,127,216,254,250,32,235,240,253,78,231,146,247,1,237,106,45,11,230,98,107,55,214,229,191,148,136,213,140,134,31,94,116,13,223,87,188,105,221,111,210,174,150,201,233,194,107,47,205,4,160,77,53,113,93,65,50,128,152,81,243,226,107,123,71,46,110,151,194,146,15,108,200,183,122,152,208,142,126,19,62,76,23,86,193,222,86,98,127,29,209,5,86,121,54,230,177,236,245,101,210,226,49,46,61,242,110,186,90,86,208,127,32,248,166,108,86,167,205,74,151,196,238,173,0,24,222,229,99,103,205,171,137,9,90,253,226,52,96,179,234,50,123,51,121,111,242,134,93,235,118,83,166,181,250,31,238,1,45,43,209,204,71,144,133,189,156,74,230,5,85,164,230,19,81,126,138,26,170,29,205,22,41,108,23,42,113,50,59,164,12,185,198,143,237,248,13,174,88,77,84,185,228,155,235,170,85,166,123,12,230,198,198,213,64,101,24,199,234,236,217,238,249,67,244,138,190,177,46,83,8,119,158,177,168,171,247,30,17,108,130,65,230,9,216,138,117,30,132,24,181,245,89,12,219,216,148,36,30,212,95,245,1,84,221,106,3,187,203,25,236,164,6,129,155,242,11,112,100,162,11,79,208,81,67,127,94,206,226,191,39,161,239,181,194,58,239,58,133,241,240,229,228,112,66,64,182,231,114,123,138,55,69,188,27,196,4,224,149,218,158,67,214,138,163,184,97,230,166,65,88,111,78,78,110,79,242,130,154,15,223,193,54,154,238,177,47,165,69,103,69,27,145,46,245,219,195,219,166,237,43,124,210,131,57,67,85,75,6,167,18,28,53,148,235,82,242,215,22,73,33,194,255,131,146,131,170,223,148,164,231,119,251,182,89,38,22,203,146,206,79,218,237,94,205,127,67,22,184,72,150,42,59,47,24,113,213,193,213,81,56,109,69,0,155,222,6,204,53,238,228,187,72,212,137,225,32,49,122,64,215,210,215,45,178,198,102,175,119,229,51,182,238,37,171,98,207,144,247,66,167,157,105,39,107,146,157,130,227,145,222,242,205,213,44,77,132,156,193,194,251,131,33,55,216,146,185,213,115,31,0,33,97,55,121,78,134,229,68,201,7,77,144,180,250,219,71,25,47,75,209,86,38,53,50,55,198,64,191,94,28,42,222,199,190,233,7,33,227,255,146,125,216,246,194,72,8,34,147,23,161,74,141,40,215,75,187,164,240,65,95,7,40,78,60,4,119,100,213,168,163,64,90,136,64,9,163,204,153,202,108,6,101,220,174,236,57,222,215,12,69,27,64,234,252,142,86,22,102,12,53,66,245,133,130,238,134,228,24,162,184,236,148,245,215,128,49,115,175,46,148,77,218,174,9,105,19,138,171,239,115,121,63,17,180,248,56,117,27,171,215,109,250,201,56,28,186,67,25,96,139,117,171,25,138,191,117,113,166,170,48,199,89,17,72,81,208,67,227,79,221,55,57,131,183,56,224,251,203,12,202,14,17,51,6,193,106,22,224,23,122,246,16,120,129,108,249,215,127,6,174,105,132,236,142,128,113,100,25,10,35,121,65,181,156,251,181,179,64,130,16,34,3,40,130,245,119,254,81,204,75,255,21,154,90,191,140,50,33,211,102,168,29,218,76,124,71,238,202,198,201,46,166,105,204,37,171,225,13,138,190,125,84,178,57,46,54,24,65,28,233,249,67,221,162,193,81,4,39,162,40,49,48,39,206,219,30,58,32,159,134,115,48,225,76,193,18,145,178,123,128,1,157,26,171,133,183,229,124,130,49,209,10,247,231,119,130,104,135,40,14,167,41,73,70,64,83,164,128,27,249,161,175,151,28,82,23,174,206,199,186,171,177,85,255,173,142,155,23,193,216,23,6,237,76,101,90,197,136,29,83,228,73,81,184,236,94,192,43,79,176,69,246,236,64,14,124,250,69,184,84,139,24,98,124,167,96,183,18,151,202,146,212,177,113,58,158,1,235,148,58,235,114,149,172,60,41,125,130,13,17,48,203,165,108,76,148,220,69,86,100,203,184,18,118,214,112,64,103,229,167,243,78,203,98,104,124,242,237,228,151,50,109,191,126,61,78,112,153,37,236,226,182,82,70,89,214,149,54,12,68,171,79,209,49,163,105,240,106,241,121,201,138,91,71,243,192,218,140,160,19,99,221,43,38,136,11,196,35,59,86,182,1,228,54,181,145,121,55,7,175,84,63,148,81,107,78,253,22,212,21,125,220,130,64,210,61,20,55,127,9,0,220,175,167,89,181,225,71,181,249,168,123,85,18,118,41,123,245,125,228,86,34,226,53,133,137,103,123,75,219,33,122,241,11,242,67,237,81,32,233,16,132,168,13,130,121,36,227,67,136,62,200,165,176,151,242,95,128,101,211,35,46,109,25,235,153,126,152,145,240,218,84,64,217,4,150,42,133,241,100,235,222,177,189,129,108,132,48,232,147,135,123,191,221,131,144,108,223,149,233,125,238,107,20,190,201,247,118,46,26,242,187,191,34,91,61,150,137,240,127,82,95,100,199,165,42,217,115,112,143,97,231,185,71,174,13,42,152,95,209,151,160,212,178,147,188,176,139,133,176,43,97,55,251,121,68,3,32,165,208,246,219,157,250,3,170,77,131,253,169,30,153,219,230,218,148,100,180,15,203,44,199,27,166,151,103,13,157,156,148,219,169,212,140,133,55,157,19,3,96,210,76,20,163,114,63,20,194,208,38,250,17,209,101,178,60,229,102,252,165,221,36,201,0,178,207,55,87,255,227,122,234,191,84,75,111,75,219,99,104,172,83,146,32,65,1,122,165,23,137,29,72,43,240,163,0,6,186,199,199,254,243,8,214,219,176,4,7,23,186,156,219,202,217,69,148,220,240,105,230,109,32,226,97,255,253,249,92,174,172,110,222,217,80,229,161,239,17,83,190,192,151,211,106,220,191,58,52,219,166,207,123,137,97,51,69,191,80,100,205,157,255,55,200,179,87,236,101,70,72,215,107,164,137,170,103,231,134,186,3,136,243,122,242,120,99,69,25,178,237,32,230,184,201,250,66,90,49,107,88,202,5,147,2,7,38,82,17,99,250,66,69,114,2,195,70,161,210,72,159,67,43,32,153,60,14,68,82,106,57,32,234,193,57,154,203,97,145,113,83,67,145,39,68,56,108,162,90,248,59,177,148,96,36,28,199,81,222,159,245,174,80,61,208,51,215,18,165,42,133,147,126,75,202,63,153,106,45,248,9,248,38,140,150,3,11,140,20,222,28,35,106,188,133,150,141,183,232,174,213,26,3,53,184,234,5,128,75,96,213,251,41,100,235,21,250,199,154,237,86,245,198,156,118,199,149,204,13,82,135,204,228,204,247,107,179,216,70,176,37,248,225,92,95,216,207,189,186,250,225,237,24,199,197,152,207,36,60,177,75,92,253,50,147,225,220,53,182,135,221,125,110,54,83,114,22,81,211,90,231,43,97,109,40,168,154,5,134,99,202,126,157,61,133,95,175,78,111,17,145,171,166,144,132,11,208,48,166,40,89,107,169,209,35,88,139,53,102,7,108,65,109,1,183,50,41,38,63,78,142,232,167,34,80,88,58,252,41,215,141,105,111,236,118,157,85,196,221,40,169,251,38,131,206,235,21,33,245,252,176,253,108,209,11,199,46,248,186,120,169,137,2,102,246,62,182,20,22,170,182,32,17,124,181,187,218,79,184,8,0,153,48,170,65,145,12,3,59,8,21,83,87,47,218,225,227,132,221,143,156,119,96,85,37,80,90,134,211,22,57,243,210,216,200,184,90,61,158,244,228,167,121,24,175,184,97,12,38,169,240,252,124,74,99,122,36,84,22,221,105,132,137,140,57,72,18,139,187,115,66,154,151,168,78,194,162,38,191,225,132,193,218,8,57,37,98,39,80,141,203,192,182,159,100,27,86,11,128,21,180,51,217,96,125,127,10,96,94,79,33,255,43,33,207,143,213,213,54,15,35,11,118,151,108,185,73,153,133,199,208,235,255,12,151,137,170,100,237,25,79,77,21,75,234,20,231,196,63,152,159,140,254,122,191,129,112,223,33,84,151,233,90,206,77,147,39,239,19,190,107,184,35,238,14,42,250,74,156,137,40,28,155,0,33,178,45,153,64,55,147,154,78,150,254,191,52,78,67,177,65,2,239,146,110,7,27,40,74,230,238,172,31,94,157,89,19,81,93,230,133,21,131,128,179,245,249,153,22,69,87,116,115,240,134,142,68,95,50,78,39,73,141,240,43,43,232,234,116,184,228,251,52,30,28,228,176,76,175,224,39,76,36,30,179,7,2,226,26,154,194,214,188,150,177,231,56,52,42,177,242,18,215,149,74,134,167,134,190,101,32,244,240,200,169,34,182,72,37,36,50,70,141,52,238,76,32,94,86,238,46,182,108,81,35,233,73,77,80,237,42,41,178,156,35,45,171,192,105,103,163,115,47,199,36,119,137,218,135,87,222,47,153,66,233,131,3,89,234,132,218,21,236,84,183,179,133,253,224,127,40,70,116,49,248,167,116,12,195,177,73,13,18,60,220,28,205,149,199,87,10,170,89,75,237,203,7,211,65,122,227,229,254,246,57,85,238,182,200,227,154,33,36,161,238,46,36,16,194,156,27,129,10,182,2,152,49,56,241,58,102,208,77,201,145,70,232,235,221,185,5,214,234,5,11,151,28,224,75,6,156,73,41,23,106,139,85,249,59,165,11,49,199,203,85,41,251,10,197,134,155,216,199,103,36,98,3,241,90,129,98,226,25,97,180,25,214,174,220,177,53,109,76,120,0,168,239,191,16,222,206,181,78,179,109,74,131,68,30,130,35,84,214,83,190,82,195,50,37,212,155,55,15,50,133,188,50,252,177,56,42,93,52,190,196,124,182,166,157,213,117,181,213,61,222,113,230,112,206,222,219,30,221,255,220,119,228,204,33,110,221,101,238,222,98,169,246,244,141,144,180,73,87,41,7,170,142,207,176,144,184,81,120,117,140,163,117,13,49,247,35,241,70,204,44,67,53,201,130,20,76,185,201,6,177,201,204,96,108,136,65,124,102,56,170,15,189,42,153,176,77,234,180,57,205,25,139,143,149,214,51,99,141,169,183,17,110,0,74,29,219,229,244,57,128,242,129,142,213,122,117,7,243,37,160,29,200,27,164,43,240,118,71,40,90,36,222,166,176,204,6,107,105,83,230,109,249,217,177,81,176,102,16,227,178,147,105,16,219,223,67,82,212,238,162,97,97,126,113,67,59,74,78,15,93,207,218,53,34,122,81,128,48,37,252,215,64,83,125,107,53,175,22,171,170,125,24,8,219,246,137,127,159,216,249,249,59,250,64,149,161,101,128,177,15,123,186,74,192,65,125,88,238,74,223,131,249,113,111,254,199,148,46,174,60,163,142,8,56,205,141,8,186,172,38,19,88,169,204,104,105,219,159,91,102,183,49,39,180,236,132,204,50,17,210,40,208,51,187,56,201,212,175,34,221,147,54,32,217,177,36,48,110,102,69,59,116,62,176,13,198,142,29,60,199,182,182,195,170,36,56,196,184,92,173,232,101,149,229,58,82,103,29,168,222,119,94,42,198,200,22,158,199,176,191,86,39,74,231,141,141,91,178,70,34,205,113,138,26,87,161,124,86,15,95,137,28,123,252,173,74,254,155,188,196,93,124,52,80,212,77,91,218,22,72,208,0,211,88,35,33,30,255,149,67,69,95,186,170,101,104,175,99,149,197,46,87,81,13,110,88,142,204,192,147,117,226,215,252,56,235,104,188,52,108,64,30,15,144,63,56,108,133,151,165,177,173,180,90,102,130,122,92,118,103,107,112,76,146,20,99,103,38,48,104,236,46,238,24,250,49,7,16,90,56,84,110,72,217,213,66,178,254,8,210,187,111,202,244,121,94,238,253,208,182,160,188,190,230,226,17,162,149,174,112,198,12,112,20,227,185,108,131,57,237,186,208,228,232,19,213,168,67,238,168,219,41,182,15,150,208,214,142,142,135,230,193,164,137,129,29,16,132,86,207,216,83,184,1,112,240,161,68,64,211,118,97,139,65,46,10,78,29,42,174,88,240,221,251,146,72,69,185,163,182,170,187,57,180,82,172,227,149,180,75,167,37,86,105,79,228,64,153,156,84,147,18,39,147,5,64,158,155,120,15,15,182,123,216,69,135,60,119,6,174,1,144,248,53,241,29,58,128,117,215,118,147,59,201,93,69,221,118,153,237,114,169,184,195,150,195,1,20,155,148,161,38,192,199,246,151,141,155,63,121,195,116,241,233,219,224,52,66,206,254,241,1,107,4,115,77,64,241,223,220,152,249,129,202,31,135,58,221,244,51,142,57,236,201,152,84,189,30,56,4,245,108,231,98,69,148,31,111,29,27,99,214,112,91,215,97,142,180,102,135,108,166,107,85,218,99,239,0,9,179,137,21,171,34,236,132,5,0,176,199,88,5,192,216,9,17,185,144,176,67,206,100,112,154,217,130,152,194,232,200,8,146,113,126,45,4,124,112,126,190,186,100,241,24,142,123,223,251,189,165,32,133,145,141,3,129,202,157,60,177,196,189,11,29,185,173,52,192,59,215,152,162,85,100,244,186,245,2,51,24,22,66,249,179,180,108,41,42,15,37,112,23,163,96,19,114,110,170,17,26,50,120,142,162,60,27,53,67,35,183,173,42,6,32,217,236,125,177,138,166,85,199,70,182,174,134,13,240,21,217,165,182,14,36,234,243,205,104,227,180,75,66,88,204,75,52,180,51,159,195,131,217,68,49,54,74,129,219,23,205,182,96,196,176,220,109,136,250,87,188,9,101,42,69,60,9,188,43,151,120,31,172,14,159,226,185,53,12,188,127,139,22,193,250,232,1,113,110,176,37,38,252,96,193,253,19,36,127,227,251,73,55,96,99,149,39,229,81,136,59,193,246,216,147,17,96,72,44,31,123,189,211,29,249,193,247,201,89,193,186,206,245,21,130,48,11,213,191,70,208,196,6,46,145,157,101,139,8,170,176,247,183,57,195,195,146,180,216,177,198,225,95,142,23,223,147,233,201,197,67,232,16,249,112,128,89,208,51,188,158,116,147,253,161,255,247,169,249,1,245,7,167,126,237,99,225,49,171,114,86,133,172,100,16,76,163,47,57,236,12,150,237,39,165,89,13,89,80,156,207,50,153,100,22,155,71,103,53,53,186,121,236,152,198,64,33,124,120,216,39,209,38,203,41,208,74,205,200,19,220,155,73,234,124,110,241,212,62,164,107,228,205,163,200,90,10,22,77,196,203,202,93,119,80,161,107,42,61,224,34,42,198,78,230,16,40,44,199,70,22,216,208,106,104,89,127,102,172,2,138,243,183,115,213,68,32,213,225,189,62,49,236,39,151,205,132,109,89,241,105,105,139,251,46,240,44,255,167,107,119,128,195,36,175,35,53,94,112,208,227,18,218,55,71,123,17,107,231,42,246,202,24,22,115,150,166,193,177,125,128,19,87,51,16,2,123,207,229,74,159,107,77,139,210,47,6,40,101,145,118,229,163,170,145,207,0,92,241,45,166,135,20,168,246,39,229,241,6,95,118,133,97,184,117,80,198,240,253,173,101,250,250,41,218,222,98,3,97,80,196,36,106,68,36,182,150,86,208,20,98,240,91,254,244,179,167,187,25,229,238,220,87,163,33,142,196,235,99,121,211,141,31,127,252,218,237,160,155,142,46,189,247,240,189,216,196,93,227,45,83,226,83,26,181,157,47,17,159,219,165,127,62,97,241,36,83,86,103,43,250,17,164,9,122,67,122,174,172,255,185,41,120,253,235,97,240,113,59,94,85,34,94,86,48,143,2,21,106,0,4,93,216,141,47,99,165,152,39,128,227,196,211,127,236,82,159,208,156,230,198,109,247,132,40,62,165,240,234,100,197,56,7,109,213,53,94,105,23,50,236,2,192,42,188,146,244,7,133,41,208,137,132,142,147,17,62,7,85,83,75,1,34,118,17,16,206,127,125,188,31,236,242,139,188,213,230,36,114,225,250,189,82,232,74,163,202,155,102,130,255,139,231,204,202,237,64,78,50,154,25,12,185,89,175,219,164,129,165,69,161,103,133,209,168,248,10,229,217,223,184,17,162,197,114,69,159,194,19,30,188,81,1,116,111,114,241,5,105,197,159,162,87,93,80,94,95,82,64,15,41,22,15,155,248,173,129,186,97,17,13,208,24,139,137,137,4,9,69,219,204,134,83,114,186,18,237,232,173,176,1,189,240,68,115,195,217,185,223,234,143,93,66,206,153,177,20,160,68,132,120,226,20,162,25,74,48,142,111,29,232,35,10,7,72,210,20,150,120,66,170,81,6,65,63,236,227,185,205,111,77,82,132,27,100,39,97,171,215,75,227,7,249,180,126,79,176,94,241,87,193,60,250,88,78,31,197,137,0,44,228,100,158,32,62,103,127,37,252,115,218,131,192,22,8,180,24,23,223,110,205,57,16,112,18,36,218,253,124,67,240,79,24,161,145,100,119,148,128,223,0,134,228,55,9,70,0,241,235,143,139,160,206,118,148,20,181,116,63,9,138,121,176,41,28,192,22,223,160,135,59,106,116,126,172,192,218,208,192,37,130,69,201,37,7,37,20,97,55,203,128,154,157,147,203,139,68,203,64,202,85,81,180,200,239,223,119,214,149,160,148,156,42,167,121,243,37,150,182,76,57,217,182,213,203,16,95,73,78,246,96,211,69,1,62,190,241,230,206,193,40,117,59,77,202,226,124,8,38,8,172,97,18,238,253,77,58,193,184,173,190,38,145,240,52,10,2,64,107,96,230,178,88,97,47,96,101,213,203,75,93,52,38,92,165,15,249,137,179,135,140,17,181,42,158,141,153,212,213,175,180,108,117,92,147,244,37,57,187,180,136,93,167,100,134,42,16,218,252,230,94,155,28,182,5,10,235,249,84,9,161,97,13,183,185,242,166,197,138,161,197,77,178,111,7,171,110,16,1,68,52,252,43,206,80,6,202,130,117,254,27,215,60,98,77,9,105,32,197,91,213,87,16,87,248,11,39,111,5,51,6,60,142,17,21,48,200,106,61,40,7,207,236,243,37,141,137,16,9,214,36,11,205,210,183,228,100,14,235,9,47,162,209,229,117,41,130,0,152,217,170,16,92,181,177,141,181,17,60,206,188,226,67,79,135,239,60,101,53,251,128,127,114,177,159,223,188,49,121,0,102,158,66,173,40,56,243,37,205,21,121,119,39,13,19,246,87,151,134,76,167,29,81,19,113,159,155,159,180,43,191,213,6,181,53,55,233,43,117,126,64,149,137,136,158,213,160,153,254,200,109,128,8,137,150,246,231,248,32,129,114,242,81,245,186,81,86,217,159,161,227,210,135,235,154,164,65,192,139,241,10,215,188,103,255,110,107,40,186,125,194,27,8,36,35,173,254,108,250,23,114,88,206,21,55,102,0,21,170,3,204,205,220,102,135,189,187,41,104,255,106,120,174,223,116,71,122,127,62,254,30,96,176,73,38,6,111,90,221,214,250,193,32,122,105,195,219,154,21,121,34,158,38,148,85,245,201,130,90,220,214,16,104,12,239,65,109,148,211,158,94,226,18,6,15,182,193,111,234,242,104,6,242,122,11,124,230,194,22,14,219,117,64,150,192,188,118,42,106,95,16,178,134,74,193,99,97,76,126,142,146,107,206,250,51,58,115,62,204,166,34,158,55,16,202,192,37,45,90,150,150,177,76,142,185,237,84,43,74,253,140,9,241,93,40,153,69,13,147,54,13,43,58,8,235,121,82,107,211,110,213,98,33,155,65,155,142,2,17,16,3,126,160,145,38,231,83,137,29,164,134,110,228,43,229,139,62,18,191,226,125,109,208,83,111,186,36,189,112,139,53,110,59,230,100,221,145,39,228,66,36,118,84,74,230,12,208,226,214,90,246,228,115,16,145,150,40,74,125,98,167,17,101,177,225,225,123,175,26,171,41,247,2,64,69,184,32,110,102,148,237,25,12,81,15,163,238,210,207,228,75,187,245,17,91,137,145,193,154,209,235,30,184,121,182,132,163,187,235,47,232,81,156,43,231,224,39,106,236,31,91,174,49,12,57,24,81,134,172,54,6,15,61,214,21,51,249,87,127,12,232,16,31,18,145,8,81,168,252,116,23,123,88,23,202,187,227,55,207,146,118,189,84,140,91,147,54,84,177,60,9,58,212,67,72,132,178,125,251,58,11,109,76,72,95,15,81,199,174,255,10,0,186,203,171,231,113,15,251,41,8,211,86,177,64,198,127,237,40,188,175,197,248,24,73,114,78,186,69,18,117,93,188,85,62,103,182,98,119,186,86,149,126,161,232,117,199,77,67,160,250,242,72,113,232,77,86,227,105,57,196,186,6,58,224,150,166,192,90,167,176,106,221,107,99,20,150,208,191,76,156,121,95,2,212,102,160,98,144,94,187,193,177,201,130,223,75,137,61,245,150,176,216,33,154,108,28,237,85,237,99,9,49,193,150,155,151,156,133,94,190,122,150,253,145,4,68,87,9,110,209,245,80,206,59,21,191,41,109,69,85,133,37,58,234,188,191,27,173,233,251,4,195,15,121,43,30,159,35,125,109,203,146,103,148,128,139,98,142,250,141,243,44,145,227,164,74,25,58,157,67,44,251,11,76,247,194,114,223,53,232,63,221,255,110,6,255,34,168,233,159,20,209,220,127,15,19,146,133,239,29,194,108,34,128,105,196,85,78,156,220,36,225,246,202,121,18,184,202,50,156,137,14,220,116,129,217,45,4,207,16,240,5,148,132,159,3,24,134,121,206,9,203,21,24,139,10,13,210,217,3,125,254,167,143,5,248,202,173,123,175,81,228,235,173,12,167,222,66,221,84,156,68,130,247,214,163,178,211,55,5,157,135,213,61,122,226,142,43,59,230,65,23,199,45,182,69,144,168,45,154,217,94,7,162,119,228,43,28,24,124,65,70,237,238,182,61,253,34,13,243,216,190,100,112,201,4,160,234,114,173,112,10,198,235,41,158,55,47,140,230,128,212,12,135,87,233,54,77,255,141,88,44,32,55,46,129,249,246,11,76,123,100,118,106,219,53,99,109,152,225,176,107,28,212,97,105,212,98,214,185,72,192,95,176,206,148,63,151,163,178,241,134,125,194,41,116,157,147,219,48,166,143,70,106,182,140,227,214,191,166,14,97,46,124,115,170,236,176,218,169,229,74,10,156,9,221,245,18,56,136,228,123,148,243,236,232,78,142,78,39,167,195,20,169,182,126,69,113,101,28,106,161,120,103,4,139,254,41,174,57,255,120,233,252,72,12,225,57,85,176,210,88,8,88,253,65,233,61,90,239,52,104,235,43,37,255,182,119,30,201,58,40,254,156,206,35,49,144,220,37,10,225,138,107,28,106,170,117,228,223,40,123,33,105,132,205,193,91,48,79,225,179,66,76,236,35,162,248,89,138,222,67,95,253,81,6,153,159,9,148,173,80,229,150,226,41,12,141,205,161,223,226,232,84,94,185,196,183,23,229,13,72,49,34,118,232,10,121,219,189,173,168,67,109,30,103,24,250,75,147,172,171,92,120,131,18,70,246,172,160,122,144,77,201,70,89,141,101,37,240,90,188,44,80,125,105,113,16,212,43,242,13,140,75,209,63,155,19,68,177,200,65,119,173,247,77,148,72,174,194,73,115,13,245,145,28,213,252,127,213,199,135,12,8,225,190,126,123,201,111,34,243,20,167,111,205,139,29,111,35,25,183,16,226,5,52,85,155,132,171,59,203,196,125,173,24,58,189,111,4,26,209,205,177,242,19,157,108,67,184,198,217,120,147,11,21,248,105,17,210,191,23,22,166,218,104,157,192,149,225,119,171,163,29,207,126,120,185,12,163,114,103,154,118,89,233,225,121,184,157,247,125,230,12,30,230,206,20,105,158,246,122,13,46,135,217,124,154,79,153,3,191,135,153,154,147,123,236,152,169,20,152,22,96,107,15,181,40,244,146,0,15,94,85,231,106,55,133,216,50,7,40,89,243,169,150,211,174,183,53,139,90,41,61,209,175,228,144,25,157,165,120,196,229,188,194,88,177,27,96,2,129,165,75,152,22,149,129,43,75,125,27,135,145,168,119,141,133,216,166,247,72,236,76,50,119,92,251,97,250,203,214,205,176,223,18,104,49,84,103,179,185,41,239,2,1,244,102,34,66,25,62,211,149,99,209,33,213,4,208,19,182,151,63,28,218,142,18,43,190,40,142,172,227,108,154,255,2,10,100,137,42,176,248,240,19,148,93,154,108,242,253,197,212,9,29,151,33,148,243,147,14,199,105,165,22,229,232,128,151,142,204,111,196,82,40,113,153,10,81,89,5,238,25,136,115,167,53,91,17,219,25,37,96,2,161,209,35,46,231,91,86,9,206,1,221,215,30,142,198,44,113,75,52,124,47,156,48,185,17,54,56,64,234,171,192,114,61,128,80,103,51,240,143,39,53,35,203,42,127,63,7,43,243,155,53,105,26,134,235,46,190,52,10,225,91,156,27,83,229,32,74,74,6,153,189,108,199,173,42,233,152,41,205,22,133,174,125,210,185,55,5,237,55,45,179,32,204,57,238,229,141,130,10,205,123,110,24,100,0,99,43,181,170,64,229,202,169,116,61,185,177,48,195,31,75,219,1,118,189,143,108,103,68,71,212,197,159,155,216,39,154,71,185,128,148,220,110,9,105,114,126,174,161,66,148,201,62,112,181,89,239,223,34,189,112,144,155,143,197,84,77,223,156,48,209,18,94,218,253,242,138,236,165,93,153,161,175,236,211,241,172,141,55,112,121,78,198,8,131,123,179,109,83,219,170,79,175,100,23,134,183,188,73,145,104,132,236,53,83,56,168,164,234,56,50,60,3,23,237,18,35,196,143,8,125,150,211,2,178,104,0,1,230,58,112,236,230,19,102,208,235,50,88,22,234,113,68,124,237,205,183,224,156,40,107,130,213,75,154,229,228,146,173,50,160,166,188,196,120,188,84,134,165,240,253,207,76,22,103,177,29,140,225,62,60,13,109,7,5,132,242,147,195,19,11,244,236,226,107,230,222,33,38,201,122,172,26,80,182,158,168,66,45,12,6,168,151,152,132,226,51,159,213,253,156,91,70,127,40,119,111,112,137,70,224,191,38,76,87,85,73,44,227,25,152,29,191,173,133,42,68,234,185,234,212,223,163,47,230,12,52,139,95,251,156,33,181,198,61,19,103,109,76,46,211,196,68,97,84,117,55,16,22,66,166,85,89,235,152,126,185,177,68,214,214,60,40,193,111,190,89,234,20,50,91,205,114,45,155,22,230,131,160,140,137,101,147,248,166,48,179,25,6,185,174,8,236,209,233,20,238,130,127,179,233,246,185,239,52,51,85,120,175,117,110,241,223,74,129,211,213,59,127,143,49,106,206,129,189,222,248,60,198,39,225,95,190,121,113,8,254,71,16,177,252,33,2,214,70,62,146,135,227,15,188,244,121,211,171,144,20,146,154,232,67,140,38,199,190,163,104,111,38,30,103,195,198,233,173,144,52,74,142,86,192,47,195,54,48,9,152,250,47,29,116,132,216,157,108,149,214,241,9,243,40,33,127,71,217,238,135,127,85,48,73,89,31,41,202,4,22,111,10,0,232,64,160,234,13,221,159,125,239,234,13,245,182,212,185,215,151,138,92,47,38,30,189,88,151,46,73,12,157,130,72,197,210,33,210,145,227,175,199,211,244,25,207,251,228,61,216,171,144,47,70,122,228,120,30,230,142,30,210,157,42,86,98,139,53,105,178,210,38,147,157,225,50,3,143,79,217,201,88,17,89,63,157,92,125,3,129,47,31,60,254,137,157,217,174,220,196,247,151,124,48,93,160,78,241,123,253,50,122,250,126,85,244,193,64,13,235,121,2,36,24,255,87,68,26,59,8,226,33,116,35,250,126,82,204,156,61,77,45,98,241,25,85,152,251,219,87,159,4,40,133,110,29,235,170,136,207,106,26,98,88,190,149,24,54,13,174,141,22,26,241,132,199,3,232,150,18,91,103,31,184,165,55,29,236,167,203,78,131,88,229,205,107,130,107,95,112,6,47,72,134,194,1,2,218,169,96,184,213,3,72,94,216,252,214,187,213,150,151,244,250,66,72,164,97,247,118,233,208,186,254,180,108,198,47,238,172,233,164,60,44,196,62,54,242,158,85,91,238,196,236,26,254,173,115,173,254,18,224,48,207,131,108,145,206,249,39,28,185,46,147,148,145,227,157,163,247,72,173,139,58,17,158,145,251,83,101,136,70,151,151,191,252,237,183,196,64,223,98,180,139,83,134,141,74,210,143,225,166,149,245,142,109,54,30,1,147,143,90,10,228,21,188,188,139,78,36,46,42,89,182,61,157,145,58,6,243,30,97,123,18,248,73,125,255,82,215,218,240,83,45,173,48,24,32,86,25,238,230,243,132,89,37,174,235,79,58,40,190,85,26,53,213,61,242,13,192,40,69,182,82,24,220,10,45,4,189,189,210,136,159,35,51,32,206,254,188,25,173,45,252,117,239,135,241,217,251,107,215,102,114,189,186,84,250,227,238,174,194,110,254,85,248,166,33,28,42,5,252,240,156,0,55,212,56,41,241,191,145,33,109,254,217,111,18,191,254,1,40,247,189,100,65,84,233,45,211,96,99,212,57,27,253,202,135,27,74,210,19,105,164,217,225,209,51,245,129,145,113,13,109,9,90,170,120,144,13,105,37,85,178,155,45,63,254,241,229,128,6,167,183,255,11,59,135,161,169,185,247,98,68,126,38,35,3,119,175,3,89,254,132,42,42,126,1,86,79,12,230,175,176,129,85,221,186,12,67,171,64,119,230,220,27,38,150,167,208,20,232,151,35,110,255,81,181,198,28,73,175,36,224,163,77,189,145,44,198,65,168,136,69,31,18,145,65,42,248,110,121,5,110,13,68,109,67,244,70,128,161,46,170,245,144,161,152,143,200,47,168,58,130,70,83,181,154,206,228,40,211,247,151,83,230,198,255,26,208,79,22,147,222,65,151,115,113,0,132,239,91,83,76,139,133,202,77,83,67,144,187,234,96,235,182,104,131,189,116,160,2,106,76,250,174,159,110,115,78,213,140,147,111,159,193,120,135,83,94,105,208,129,164,85,71,166,246,144,196,109,146,239,86,156,233,143,231,167,211,236,201,30,202,99,156,63,214,218,31,29,243,106,207,121,225,24,91,206,158,130,109,150,133,93,204,55,221,101,167,167,24,80,161,16,39,197,0,122,167,69,44,244,128,2,101,189,119,160,251,114,242,172,192,239,9,124,143,11,213,252,76,159,120,12,254,211,41,33,63,9,215,32,241,201,155,126,19,227,208,86,52,150,158,174,35,219,22,114,21,70,18,160,41,240,216,210,254,22,27,68,121,147,32,183,58,216,26,38,73,53,171,142,138,86,22,152,177,171,58,147,204,50,26,172,162,91,205,50,44,7,210,251,174,8,112,116,43,173,250,251,88,44,231,33,142,99,134,120,81,112,166,240,2,35,1,99,114,87,149,78,105,244,186,120,163,48,187,136,208,167,40,7,33,184,165,176,104,175,14,7,68,87,241,251,153,124,99,114,133,14,8,5,220,180,165,112,188,41,216,251,23,177,80,126,115,13,6,34,24,32,182,95,15,245,161,20,101,42,158,3,102,54,227,194,73,44,129,38,99,35,62,65,117,37,167,40,237,57,35,135,25,35,229,28,6,21,182,190,147,104,21,233,89,226,162,142,133,114,190,208,215,108,42,169,181,225,20,242,165,21,216,199,150,163,110,145,116,186,129,194,132,187,215,167,63,203,213,212,94,222,51,59,243,43,255,114,224,23,166,83,69,193,132,123,21,112,99,173,187,133,221,165,222,222,159,59,143,62,173,135,188,210,154,30,2,149,65,79,221,90,222,91,239,43,149,1,92,64,201,42,13,127,131,70,53,156,253,155,156,254,182,240,201,176,167,32,57,12,243,156,160,227,217,134,119,164,119,209,153,91,75,78,14,209,127,251,180,19,54,49,160,205,172,125,31,52,226,19,50,137,179,136,52,234,47,31,223,96,165,168,65,193,184,9,178,157,185,120,171,50,37,52,130,61,174,118,173,120,176,41,249,31,6,7,61,133,37,139,55,199,112,79,118,227,63,180,184,149,106,233,243,255,56,140,143,79,176,182,173,238,52,90,61,249,230,143,108,161,58,184,214,211,106,223,122,83,46,39,152,149,177,147,148,147,42,241,130,129,144,154,35,76,148,46,14,66,60,111,241,181,155,202,51,104,134,9,216,226,210,142,135,23,93,68,38,157,143,37,227,238,240,42,186,112,248,217,110,138,225,26,241,148,127,60,74,94,79,33,254,229,166,145,181,61,169,16,224,14,67,252,52,168,20,81,7,120,125,48,200,25,188,121,78,125,25,227,224,53,108,59,102,135,73,231,252,22,221,116,151,193,34,91,41,24,25,53,58,41,9,42,23,71,182,255,43,23,238,152,255,57,191,73,64,109,255,125,136,54,142,91,244,123,50,58,209,169,217,216,128,253,157,88,121,77,60,167,18,197,114,247,112,214,130,88,20,134,246,60,39,110,5,230,69,251,104,147,140,237,43,116,79,74,111,77,155,171,145,175,35,244,182,29,100,161,115,133,38,25,2,111,14,94,247,132,1,173,233,59,26,146,114,27,126,56,17,184,42,223,223,120,169,214,20,35,172,132,115,107,188,67,146,53,163,166,248,28,171,156,102,81,89,51,15,199,61,142,75,57,116,66,52,160,191,248,43,53,236,191,255,5,162,229,60,4,137,121,45,255,157,143,215,225,139,38,172,18,101,173,242,236,152,61,253,33,159,26,89,175,21,253,177,212,251,158,223,187,57,142,94,163,227,208,79,234,119,235,167,216,207,231,36,25,128,222,237,235,120,89,186,194,52,74,102,151,111,168,249,35,224,183,30,176,174,169,9,8,245,90,67,1,195,106,120,178,164,31,118,220,92,27,3,138,104,167,36,114,14,254,93,15,70,176,169,93,212,144,185,85,112,39,227,41,151,12,83,48,220,86,236,91,154,73,3,245,107,58,239,166,16,198,20,215,160,85,157,73,114,196,113,179,191,250,147,168,54,209,74,212,140,211,95,105,155,213,181,45,85,129,195,105,99,143,171,249,51,102,191,19,223,84,213,195,9,92,192,11,222,21,17,191,192,111,61,56,253,236,70,75,158,12,60,125,134,75,71,226,108,143,76,136,199,141,97,230,194,129,166,11,49,69,88,136,206,212,140,233,95,199,71,163,63,11,213,142,86,212,159,198,211,92,225,126,169,242,6,188,105,204,147,73,97,108,71,183,248,239,246,239,242,82,117,81,177,166,37,188,136,150,174,46,231,189,0,122,29,180,216,16,248,122,150,8,61,251,217,48,84,107,159,36,67,138,161,7,106,214,81,127,64,61,190,58,179,116,59,23,169,156,195,146,220,193,3,203,33,164,109,137,74,118,132,51,68,147,215,129,198,50,46,26,167,225,212,6,244,145,113,6,77,232,244,11,88,237,166,87,4,3,145,102,158,133,79,32,251,202,128,33,147,251,237,176,219,134,196,222,213,252,192,184,217,10,134,72,0,194,82,1,254,252,107,253,7,78,42,38,50,202,107,84,157,187,166,101,249,97,68,93,27,184,250,167,198,242,225,228,39,127,211,59,134,109,109,147,52,44,86,228,172,241,161,65,58,63,175,255,241,125,108,246,42,17,214,237,134,38,188,40,181,17,68,249,51,107,71,93,233,92,95,116,173,131,28,7,231,121,43,180,135,1,168,157,75,187,229,79,111,93,24,178,190,243,74,233,179,74,116,128,198,37,94,62,193,116,125,107,249,55,78,13,128,113,197,128,104,240,23,33,241,184,65,13,69,46,236,196,132,19,118,27,231,243,221,141,76,7,92,234,172,242,9,46,151,27,70,9,177,234,5,12,82,196,23,137,151,10,239,244,1,201,0,192,118,62,19,55,201,62,36,206,25,24,40,142,119,172,3,54,179,211,231,220,165,191,27,13,235,244,214,223,206,115,162,235,3,73,72,139,148,248,167,166,134,212,40,220,250,241,104,166,136,141,89,141,203,177,203,130,236,89,112,134,206,12,240,57,95,4,216,1,34,180,53,176,0,189,63,115,119,76,59,157,125,190,3,229,53,100,155,223,237,174,94,251,199,226,198,141,139,120,217,83,82,246,220,213,231,188,154,234,124,2,157,42,248,232,92,183,38,178,214,2,178,101,105,175,21,218,54,253,64,11,217,137,89,215,53,112,224,253,220,27,156,168,232,131,151,12,254,143,64,64,231,52,55,18,156,125,251,15,229,153,173,130,172,186,53,9,26,137,172,215,0,191,165,37,34,156,37,205,83,171,123,143,170,85,139,180,144,243,176,16,181,235,187,14,94,175,65,66,5,135,53,130,209,168,218,227,205,113,138,182,160,21,130,130,46,254,108,37,111,249,46,13,70,218,79,9,254,177,218,82,163,253,255,6,234,47,106,145,131,234,249,155,208,191,225,26,175,148,233,147,167,99,145,55,11,96,46,148,30,104,254,244,147,138,91,101,87,60,18,132,169,38,237,135,105,177,190,8,217,127,101,229,35,215,233,109,236,215,14,65,235,208,207,83,183,201,124,96,77,22,176,122,139,130,130,12,14,4,10,209,139,84,142,164,81,16,242,251,72,122,173,182,204,73,65,251,125,152,249,34,143,189,79,152,124,16,3,121,180,107,72,221,28,22,225,255,29,206,178,20,186,98,70,12,191,210,90,98,208,95,135,243,9,181,186,69,195,107,159,221,73,211,168,83,7,172,211,131,190,182,248,89,9,209,50,37,161,230,255,25,51,200,42,192,78,143,240,128,43,236,127,125,255,137,57,96,114,202,24,234,195,153,122,29,4,145,198,83,224,133,7,55,182,249,122,84,236,160,2,2,156,26,113,72,144,225,212,166,58,114,58,10,186,66,243,213,178,117,255,135,203,119,209,38,29,149,242,233,253,105,172,76,177,52,121,243,212,31,230,140,141,124,161,71,2,227,242,138,106,62,64,231,70,78,167,199,105,186,28,139,101,76,186,218,232,253,55,114,91,217,222,99,170,141,252,242,79,187,145,152,219,249,236,35,243,216,111,46,196,232,72,142,189,116,37,204,248,127,63,42,127,195,244,16,216,114,2,199,197,192,139,226,170,188,10,121,164,143,252,109,253,186,148,27,95,141,159,173,75,205,149,175,220,131,180,163,94,171,84,34,167,148,38,80,85,188,219,96,73,63,198,156,160,74,20,179,34,225,39,187,32,12,4,164,175,246,153,45,51,83,126,173,49,179,132,49,170,76,73,2,46,129,15,46,181,20,84,234,222,94,188,174,171,56,91,108,158,163,95,221,84,163,87,45,185,175,33,225,158,240,82,122,172,1,47,166,169,19,103,252,170,115,156,179,60,226,8,159,25,79,120,64,11,232,10,231,141,3,178,45,177,239,206,200,181,30,78,2,121,224,57,205,253,203,193,171,37,234,108,34,92,83,38,166,106,67,126,211,174,151,227,73,253,43,123,154,178,13,72,229,212,81,110,101,85,111,74,29,172,70,88,13,42,92,181,220,95,186,159,94,148,38,131,93,114,72,37,199,35,100,168,80,122,181,201,205,133,46,43,117,127,145,172,176,129,137,4,90,104,190,73,179,243,12,33,220,88,166,142,43,82,70,80,178,202,0,175,3,121,239,78,169,31,133,226,16,215,111,40,26,86,137,238,129,240,79,50,71,136,132,209,119,99,77,66,211,116,190,80,146,59,24,68,229,212,166,17,241,237,47,92,222,175,136,183,36,238,7,85,212,167,35,155,199,5,215,150,141,120,155,201,91,71,167,237,243,128,220,123,136,194,125,26,13,47,156,218,151,231,123,4,62,80,34,65,29,184,92,37,243,28,154,3,171,220,36,251,177,27,19,173,118,206,246,94,0,100,38,69,178,204,13,3,19,216,72,42,221,188,40,236,96,37,229,181,109,44,154,17,74,184,5,186,38,210,177,18,8,156,53,197,159,168,147,158,233,83,115,11,187,210,200,244,168,219,254,136,140,22,207,252,154,45,161,114,219,152,160,99,5,211,35,22,199,46,9,146,121,101,190,159,208,158,96,91,107,202,111,46,21,163,123,206,36,87,124,14,63,145,191,65,23,127,194,22,253,3,28,201,172,65,219,50,153,39,225,10,188,70,240,251,46,57,136,79,221,95,94,111,45,155,160,33,83,132,32,139,210,199,68,193,90,128,148,65,1,246,95,154,34,48,137,157,24,8,134,40,59,55,238,41,192,144,224,144,126,61,66,48,208,83,167,246,87,95,69,117,228,189,233,18,189,33,137,45,20,220,180,222,169,107,72,204,146,20,173,84,243,92,134,165,76,52,166,41,155,128,241,168,62,7,154,124,5,148,195,158,185,214,220,7,141,124,157,230,188,161,6,196,51,38,242,128,24,147,250,106,41,239,144,109,167,237,176,35,126,60,142,20,19,137,122,189,111,221,248,110,182,219,212,92,132,164,198,244,68,20,144,1,59,196,52,160,90,113,243,14,53,221,41,141,251,27,177,79,196,228,125,112,136,69,189,254,130,227,186,1,149,206,38,51,144,46,79,61,220,202,235,219,148,59,52,89,15,251,43,77,120,16,157,248,16,96,58,104,121,213,116,241,35,243,198,148,226,253,122,211,178,200,221,198,52,167,168,131,138,33,104,115,94,147,181,204,36,31,157,102,138,157,29,133,226,183,173,154,77,244,177,253,70,240,130,103,197,196,222,71,161,248,0,86,67,197,115,167,134,206,134,116,59,132,122,134,84,140,220,104,3,36,125,188,156,94,18,200,133,80,118,48,134,37,253,13,141,157,73,119,157,29,92,132,145,123,96,134,48,208,2,217,175,211,216,24,114,139,136,47,99,251,119,68,229,118,176,211,147,158,181,61,244,184,233,129,147,133,146,153,255,123,17,115,225,98,148,196,187,34,158,194,172,14,198,60,147,182,223,206,236,204,7,67,49,97,41,129,12,92,30,148,4,14,246,61,69,54,25,92,56,179,161,13,88,60,170,108,73,173,242,43,81,166,186,115,97,79,105,35,26,30,155,223,202,254,34,234,128,129,119,107,216,35,150,116,178,4,9,123,54,42,153,33,139,253,26,218,197,176,235,211,208,24,190,20,171,99,160,212,93,139,53,197,234,10,197,150,85,182,42,116,5,104,187,36,58,103,210,33,28,137,44,101,236,184,205,201,185,126,149,43,40,61,137,247,37,84,65,174,102,121,189,170,255,119,68,137,196,177,249,127,157,125,124,116,82,41,227,54,70,147,237,58,48,83,198,53,254,221,103,142,197,130,206,1,80,73,237,142,129,29,65,212,172,207,138,121,190,4,98,25,47,173,187,157,219,199,214,249,209,253,241,216,50,138,219,78,34,126,128,197,245,218,96,77,103,86,9,131,167,211,176,217,22,149,197,172,16,85,214,195,226,42,167,159,196,55,35,246,207,13,222,183,49,89,24,100,60,206,167,64,114,126,14,67,30,117,147,246,99,82,2,125,136,160,212,208,132,129,5,245,143,6,225,188,165,175,106,55,166,143,251,56,149,183,112,168,169,157,84,117,11,38,109,129,155,238,8,168,217,47,89,166,218,139,150,166,138,32,223,155,85,85,62,183,205,23,22,176,67,40,146,151,194,67,237,154,207,31,70,211,197,70,97,121,239,0,119,199,238,6,44,232,228,213,192,110,253,203,69,36,174,181,164,167,234,202,149,24,210,228,154,139,107,172,200,194,226,164,158,128,167,164,235,104,187,182,43,185,195,249,228,17,214,81,233,103,33,217,248,9,111,67,105,115,19,169,223,19,122,7,88,110,120,217,185,198,79,43,189,118,93,121,167,71,136,168,197,79,174,142,168,55,228,182,231,72,224,1,77,162,205,137,169,207,198,130,121,92,158,28,174,254,221,203,90,68,113,76,117,28,103,221,135,144,241,143,136,205,168,63,227,229,98,206,165,216,111,0,249,52,37,201,226,57,16,75,134,81,98,179,182,218,59,97,133,35,26,84,0,88,28,154,226,169,246,89,44,180,236,45,64,82,110,237,79,22,137,33,109,167,210,228,252,88,134,43,196,23,214,177,143,115,131,107,189,59,40,206,136,190,78,52,177,199,141,189,203,16,92,216,176,147,82,34,229,155,198,124,42,41,11,189,0,63,219,187,15,73,113,204,28,114,129,26,208,154,69,254,227,146,6,62,134,215,0,33,87,120,63,198,124,65,38,177,24,192,100,148,194,124,216,149,172,106,39,89,150,182,84,209,136,205,35,69,230,42,168,73,230,152,46,86,201,230,134,192,71,6,215,207,169,238,244,107,119,241,37,39,47,134,209,8,129,20,171,203,22,174,237,219,215,18,45,18,101,206,26,89,226,154,202,191,184,45,173,212,102,239,44,131,121,179,163,130,95,225,145,114,32,97,224,233,139,196,155,112,19,33,173,255,98,9,86,85,214,71,52,187,166,46,78,35,123,31,33,236,170,50,117,248,207,116,98,241,150,151,71,62,55,73,88,16,241,32,160,221,202,122,40,163,211,136,36,31,39,172,36,189,21,18,84,90,221,134,194,74,108,181,76,115,208,8,249,242,208,5,102,54,191,64,251,87,194,85,179,137,86,85,21,91,231,180,138,81,78,199,10,10,22,147,102,217,51,120,129,104,176,242,32,213,242,16,34,152,193,206,135,105,176,95,32,138,244,27,152,73,128,38,236,149,213,45,92,102,141,66,239,219,186,105,134,46,208,49,104,57,52,81,52,26,196,77,139,53,184,155,42,149,209,205,137,242,52,125,15,231,239,237,183,54,226,65,162,121,46,222,174,163,77,118,167,94,154,66,189,119,79,188,126,72,206,205,237,106,179,188,227,29,74,201,187,153,80,147,248,94,189,17,149,96,136,79,162,23,42,237,231,146,230,177,253,59,130,48,136,226,250,22,129,95,144,51,180,110,224,133,72,71,164,141,168,238,176,47,74,221,43,75,54,140,228,108,183,196,187,63,241,175,9,96,204,134,116,131,82,181,138,87,208,240,51,89,225,89,0,129,88,169,123,30,191,47,197,73,176,195,129,229,131,101,174,158,66,72,12,108,56,136,237,57,18,169,13,52,35,77,26,204,42,214,64,102,130,225,165,250,191,188,22,195,38,80,21,238,186,175,44,247,126,125,12,137,190,183,1,218,254,123,88,176,66,102,186,162,239,200,0,249,221,103,109,217,80,227,193,110,20,173,61,147,204,128,144,206,179,212,49,109,132,105,130,69,125,59,11,141,48,186,238,51,119,17,24,137,169,219,184,137,112,12,11,129,15,179,195,22,107,28,23,163,48,233,176,110,216,2,75,92,137,215,69,110,77,5,119,251,105,76,61,57,195,131,77,101,238,141,167,217,65,27,54,149,209,217,248,117,43,231,93,214,102,198,47,37,164,192,190,35,101,133,58,145,202,70,212,69,51,87,173,83,205,134,218,61,201,134,10,44,91,222,14,67,102,167,252,113,47,205,48,68,207,62,40,227,59,112,132,129,67,185,48,132,173,104,150,37,237,176,221,148,12,64,116,93,71,122,39,162,23,113,113,68,166,10,51,92,152,66,187,245,118,18,200,26,182,11,177,235,106,130,76,186,119,24,247,234,3,2,84,84,78,231,55,224,25,247,57,116,254,201,246,191,219,247,169,201,230,67,163,189,79,228,60,138,240,238,35,243,34,110,173,252,140,151,246,67,65,30,225,94,111,142,211,36,91,61,69,255,225,236,212,33,206,45,108,254,55,203,215,189,204,252,113,189,180,141,35,98,249,17,224,240,72,43,153,160,19,196,191,186,250,234,94,135,209,105,214,254,255,181,25,182,254,143,215,36,245,161,57,8,248,192,194,51,36,152,44,226,219,193,3,228,210,148,132,114,223,224,200,28,219,17,220,62,66,73,1,248,54,27,239,251,35,79,196,237,238,9,154,148,97,223,225,251,27,141,230,208,109,120,202,68,234,128,195,117,106,75,196,229,226,201,116,38,203,92,195,9,84,197,165,211,229,49,215,16,177,157,13,54,237,122,177,140,40,154,161,254,92,188,28,9,25,179,175,21,162,67,170,35,226,84,171,153,187,51,75,99,243,222,33,169,219,26,1,102,27,227,47,68,31,103,100,107,49,104,145,205,6,174,34,222,132,4,179,250,142,218,195,153,17,28,98,10,160,199,128,41,212,69,191,250,23,21,127,253,97,204,217,112,183,100,206,75,131,206,129,171,100,89,211,43,129,125,74,219,11,29,234,73,148,214,214,201,19,231,241,221,76,101,109,32,128,180,200,152,30,199,56,58,177,131,220,131,234,24,243,217,43,184,209,219,159,156,62,245,106,140,30,16,5,176,55,204,217,160,190,243,180,54,40,158,92,52,161,119,38,217,111,100,129,78,227,3,185,234,226,188,192,200,208,138,16,236,105,188,130,242,65,160,141,210,102,119,202,143,30,105,228,79,200,71,13,189,217,143,3,93,46,153,223,149,214,84,99,210,120,47,48,190,33,160,164,93,108,191,66,27,87,103,123,120,249,181,13,26,60,124,97,65,68,53,9,43,254,64,56,158,21,26,46,189,178,172,249,79,210,15,205,171,141,134,228,80,238,110,237,65,123,74,108,78,242,65,111,115,200,137,114,236,117,134,69,187,151,215,120,211,244,8,134,152,5,244,11,201,149,18,76,234,122,220,222,107,4,198,113,193,129,114,127,2,39,22,138,143,138,0,13,97,37,25,180,229,187,66,186,86,228,153,160,10,6,192,73,203,66,93,60,230,154,90,113,190,145,24,126,36,74,191,159,134,8,23,73,160,243,221,146,138,55,16,11,229,96,114,96,109,67,72,20,247,128,114,191,65,207,55,32,17,25,151,81,106,208,66,111,203,213,109,96,34,208,123,89,57,28,219,3,220,171,212,251,69,24,46,126,154,115,114,3,94,76,37,196,107,142,229,39,157,30,30,3,98,165,133,46,165,121,224,244,17,248,26,67,65,15,91,146,102,122,71,255,216,236,84,229,160,138,127,127,244,231,32,215,208,95,250,102,202,87,176,72,238,90,173,115,225,188,140,32,119,233,29,119,194,43,132,7,104,250,162,221,116,223,53,139,232,194,182,170,181,217,75,181,125,136,212,1,162,4,217,94,96,202,101,140,150,126,102,149,139,52,32,56,114,212,21,21,48,34,87,94,159,69,64,200,174,50,20,177,6,29,8,121,215,151,4,203,212,185,151,182,154,171,0,122,0,63,122,77,190,163,239,61,69,226,52,176,157,45,29,168,238,209,87,74,250,81,54,189,112,87,65,134,134,199,20,63,34,51,133,244,161,146,19,159,7,52,12,48,241,22,87,96,217,183,155,186,212,170,234,183,191,241,227,77,57,37,22,53,83,34,56,83,44,59,184,53,0,33,72,130,215,169,19,2,42,37,26,244,238,72,245,142,34,3,38,236,43,69,43,68,156,131,95,182,124,250,226,118,105,226,9,251,141,209,93,47,9,75,230,62,137,31,228,46,174,63,158,69,186,19,149,83,141,228,209,150,74,155,129,29,181,2,66,86,103,236,143,131,98,174,39,121,154,28,31,215,199,177,87,119,143,55,163,135,35,173,236,231,60,142,251,145,166,4,231,180,9,202,194,94,205,117,157,75,173,32,209,71,64,20,208,226,177,18,237,141,130,190,38,210,91,64,4,59,187,172,103,223,69,27,33,34,72,1,77,98,217,146,78,111,128,88,71,47,179,209,228,55,125,167,98,53,219,213,99,143,221,6,142,194,3,134,216,141,10,183,181,123,195,236,117,236,250,118,137,16,22,16,10,135,112,21,233,101,127,171,24,72,162,240,52,206,110,180,159,167,17,28,250,148,28,136,31,191,74,107,129,157,31,168,151,123,28,58,157,149,6,156,115,224,175,24,217,180,200,88,237,44,113,43,21,52,192,42,89,113,72,121,90,204,66,23,153,169,179,207,214,37,239,227,84,253,123,36,224,166,76,142,165,104,19,204,150,253,174,21,83,169,197,52,135,202,213,58,226,10,250,229,44,238,152,49,238,31,235,236,108,127,236,136,146,6,27,11,210,195,184,57,122,32,228,32,19,66,217,148,245,28,37,179,62,79,81,199,48,24,142,188,66,248,181,230,33,232,186,47,89,5,110,30,79,162,209,238,192,248,188,53,38,185,207,49,239,255,101,41,170,87,98,255,52,218,123,16,124,87,216,203,28,64,26,75,237,54,80,150,150,219,141,84,69,58,222,178,236,184,135,117,9,232,194,133,157,228,17,69,205,115,188,71,133,118,17,100,254,205,144,89,48,59,148,169,7,197,184,181,249,218,80,88,249,173,54,162,54,216,188,161,250,153,145,246,43,248,111,93,240,211,169,45,7,185,106,198,55,176,212,156,68,10,188,254,65,101,244,138,101,92,184,217,148,245,0,60,133,208,22,231,232,0,235,83,178,72,247,67,246,42,105,199,46,3,199,237,225,108,132,185,141,1,213,164,16,55,194,248,210,175,193,11,20,103,153,84,83,184,179,38,65,156,164,182,81,254,44,130,146,160,129,187,60,75,37,191,30,44,132,198,83,119,168,238,145,224,101,93,139,195,7,181,242,238,158,49,162,16,204,231,108,126,126,36,102,38,7,229,20,127,71,79,51,57,244,193,125,116,135,179,232,129,35,247,104,104,177,85,171,162,69,119,99,59,7,152,141,66,41,109,227,222,89,201,167,11,86,8,240,192,131,57,251,52,76,91,100,231,226,210,83,240,29,148,248,140,36,116,10,53,82,158,199,203,233,235,231,1,182,169,212,219,63,90,123,173,226,5,221,155,157,38,67,163,126,25,91,119,106,88,233,48,213,117,186,126,196,107,73,34,102,203,59,97,187,126,253,35,201,70,55,248,226,181,237,46,158,182,203,23,245,51,128,28,235,67,53,54,132,91,224,16,52,130,147,100,69,92,56,5,247,250,162,93,181,95,18,164,249,226,22,186,46,49,63,238,223,231,2,144,228,107,106,97,23,24,13,162,93,218,106,91,50,64,49,243,128,45,98,220,56,156,127,46,188,53,126,52,254,57,98,16,236,18,128,103,169,203,157,238,161,94,69,162,132,140,191,206,30,129,98,82,149,234,91,14,76,141,20,199,97,99,58,200,46,207,234,243,66,231,5,11,85,174,219,184,119,13,59,118,120,167,216,53,227,99,133,98,241,234,247,210,74,119,182,230,70,160,125,235,132,106,110,119,162,101,29,222,154,66,175,56,253,105,235,209,109,44,80,84,34,60,31,141,39,174,220,34,121,247,47,18,19,31,85,62,211,198,182,201,138,129,101,13,40,96,157,200,101,214,70,203,47,60,95,177,134,83,19,83,6,106,19,72,120,198,182,250,151,87,135,127,71,229,44,136,34,201,93,168,232,92,219,49,147,195,136,175,207,2,106,72,169,139,244,253,218,86,46,91,53,75,101,162,182,201,49,148,13,253,153,38,119,188,46,25,24,35,222,100,174,187,119,126,8,156,189,97,56,188,43,110,27,252,209,74,38,98,176,125,180,124,183,72,124,215,154,189,119,55,167,169,58,250,25,9,81,132,161,179,236,124,55,128,177,243,143,78,123,232,255,251,95,44,205,90,190,141,20,30,175,64,79,229,47,31,241,100,146,189,55,179,2,87,223,154,69,244,239,10,200,139,140,105,72,114,56,208,164,220,55,228,21,45,177,251,187,132,167,16,145,87,174,188,7,63,26,24,101,50,109,99,34,167,44,82,117,28,215,124,25,1,53,188,107,38,200,134,42,147,54,44,109,125,168,138,135,247,185,43,124,118,45,83,187,97,29,23,10,39,103,132,42,69,185,96,91,114,100,62,70,179,29,128,41,161,32,236,141,124,23,245,76,174,15,224,37,165,189,44,214,34,224,216,162,152,100,175,139,13,109,110,15,106,90,134,146,241,216,195,63,123,132,81,124,120,28,28,143,159,139,240,87,127,10,47,151,10,171,61,202,252,247,101,82,135,87,60,83,215,149,88,215,31,94,182,22,188,116,90,68,10,210,239,201,59,247,122,230,7,96,32,161,17,153,207,31,162,15,169,187,245,76,41,178,194,176,203,128,22,48,171,48,240,79,154,161,214,254,207,48,23,39,120,161,19,69,26,123,149,1,180,250,202,113,169,4,188,220,1,196,213,111,190,79,61,157,56,42,58,6,78,73,30,161,221,228,60,172,35,89,93,49,171,9,70,179,49,136,29,46,124,9,118,143,34,151,34,164,202,162,249,212,124,55,192,0,181,245,214,198,100,2,15,189,174,175,119,159,221,153,19,216,177,42,88,95,219,235,55,249,45,50,173,247,135,232,86,126,198,60,178,8,175,203,252,131,25,129,207,224,97,215,184,162,36,208,221,80,120,122,203,98,30,250,9,60,207,111,215,134,29,198,217,89,233,242,25,64,252,121,205,241,232,246,188,225,46,171,25,23,155,118,50,253,21,144,18,89,154,106,11,196,65,108,200,107,236,28,250,204,9,39,203,57,190,8,207,202,166,72,189,24,197,20,184,1,77,196,76,50,204,137,163,47,198,227,239,163,120,29,154,201,239,155,139,120,36,25,223,25,226,134,175,18,220,7,190,128,203,123,44,43,223,144,32,142,177,208,205,236,212,189,62,87,83,171,224,10,245,173,114,58,127,233,75,169,181,171,194,173,175,150,252,182,79,251,50,68,171,223,133,200,171,119,39,147,135,32,57,121,251,110,66,4,39,29,251,168,169,160,214,245,24,217,165,60,246,167,67,134,160,253,133,23,56,185,124,27,167,60,125,255,182,36,91,64,164,186,10,9,192,24,76,193,59,87,11,86,215,0,116,114,130,251,196,112,230,163,49,52,26,137,153,121,137,33,14,235,246,82,199,64,145,118,129,140,243,238,197,69,218,60,236,47,96,29,7,200,245,13,114,62,82,173,213,88,220,246,231,51,97,150,72,32,243,237,163,31,37,5,94,158,113,45,84,214,95,238,243,246,118,135,25,98,195,46,121,240,16,203,59,49,238,9,136,44,137,164,8,55,243,176,198,99,128,230,63,128,54,46,87,108,169,133,162,135,117,214,211,35,3,252,19,3,252,48,119,123,248,120,162,22,224,4,156,40,136,235,200,72,70,252,71,173,98,240,104,2,233,21,47,189,145,80,1,55,210,168,156,246,61,71,107,106,163,136,114,119,131,113,226,48,125,37,36,249,51,187,237,143,146,135,13,117,180,37,171,236,125,245,22,189,162,233,236,189,184,77,149,227,227,73,251,166,119,176,114,175,40,113,16,37,117,248,139,108,39,64,6,36,221,180,91,98,68,120,13,81,60,99,165,97,42,60,124,87,22,162,226,12,17,246,174,87,117,146,102,199,126,255,138,163,193,188,98,196,25,188,229,230,114,242,88,131,5,99,210,71,55,44,224,100,238,139,158,242,81,251,255,76,35,9,178,195,124,44,191,169,9,33,94,142,23,254,203,177,110,114,138,137,122,69,193,204,236,67,151,0,107,35,44,253,255,49,87,9,66,166,198,4,192,84,195,134,129,195,199,236,251,61,234,4,226,137,112,240,242,177,61,242,49,123,182,39,83,204,98,178,53,211,246,108,203,135,100,210,100,49,81,148,170,17,35,67,138,34,229,155,181,78,214,196,87,136,117,14,175,66,39,248,122,81,84,119,162,115,128,142,140,97,179,162,110,34,91,232,93,155,65,118,202,122,70,18,0,149,132,101,36,34,80,3,96,129,143,145,210,253,108,44,81,31,169,233,112,180,38,35,67,42,117,169,176,177,233,51,124,133,103,219,61,56,19,6,187,6,104,208,3,140,90,53,225,41,100,244,230,24,243,6,253,21,110,242,170,79,80,178,226,36,158,163,243,134,26,6,33,5,138,67,213,169,29,154,226,51,51,194,253,191,64,44,92,177,105,200,197,141,75,91,14,154,149,143,167,192,235,197,116,139,72,8,177,218,179,211,2,153,44,217,17,0,179,8,220,38,40,236,100,201,234,31,124,53,241,199,125,206,126,61,131,47,61,187,179,153,140,62,161,12,42,112,179,61,194,88,165,243,82,76,167,165,64,44,205,160,33,82,176,100,158,124,215,28,46,166,63,48,94,94,27,49,61,60,103,13,74,4,9,40,232,157,96,208,34,243,212,197,220,196,239,250,42,158,90,200,9,124,86,146,0,164,28,235,224,117,121,100,102,201,163,168,155,118,46,202,4,113,240,159,201,180,177,29,1,164,206,146,56,208,76,160,129,142,221,153,225,34,49,34,69,111,142,156,40,195,6,121,128,97,20,165,163,176,51,84,33,171,131,38,13,115,254,162,255,215,173,124,68,85,7,222,227,239,97,198,228,172,152,30,22,138,174,119,78,85,189,141,217,13,100,172,9,243,172,3,100,203,142,44,86,221,206,199,71,63,87,36,127,55,68,212,20,53,208,207,237,211,114,147,72,150,22,44,13,59,44,52,106,68,21,61,107,36,9,184,126,147,19,35,191,56,3,43,225,118,59,211,211,124,114,76,114,172,120,243,87,233,221,76,155,157,251,63,136,246,199,68,52,241,87,228,81,8,122,54,20,162,66,185,69,98,124,165,164,251,14,63,106,210,120,164,128,223,56,209,105,154,173,225,234,30,3,4,219,112,94,236,250,193,198,42,2,137,56,244,182,234,253,25,27,41,60,196,172,199,235,35,236,52,229,224,10,193,132,208,234,32,15,249,40,78,128,180,203,47,40,27,189,224,8,2,89,4,73,52,178,234,111,196,22,25,212,30,217,241,88,14,120,63,158,165,232,201,34,43,254,27,123,37,176,241,109,151,48,166,160,54,164,214,113,110,177,223,206,147,129,57,25,169,131,38,32,72,151,158,31,238,202,106,47,114,251,131,7,216,208,251,19,56,120,101,249,235,91,74,35,60,182,143,60,28,53,91,15,187,29,41,86,56,186,184,119,163,80,228,86,235,185,133,236,148,85,49,87,253,131,79,117,156,179,89,140,241,100,120,147,102,120,102,186,38,156,239,177,229,104,69,140,173,159,125,21,88,163,223,13,195,89,2,177,138,166,102,25,34,164,218,57,140,53,213,168,220,125,65,216,191,168,193,146,109,254,118,168,136,173,64,57,40,29,106,195,135,106,198,83,211,221,102,160,244,171,100,187,115,11,70,29,105,179,110,153,78,149,170,40,60,120,107,204,98,34,100,157,48,64,115,105,68,62,169,32,123,177,23,157,168,232,250,60,115,60,59,175,140,126,254,163,81,120,36,127,216,26,107,16,202,25,69,217,212,23,152,225,219,23,112,242,86,194,146,75,209,46,165,228,165,91,78,183,137,239,120,80,188,101,176,99,158,197,11,235,114,159,106,232,209,164,49,44,240,223,23,208,191,23,250,200,47,30,174,24,35,73,58,157,229,254,170,67,119,153,243,212,85,129,176,162,234,76,244,82,153,12,109,29,140,189,237,187,22,194,123,12,82,73,2,95,85,93,116,234,174,183,174,56,36,9,146,52,141,185,162,184,203,103,242,3,235,31,186,138,243,239,30,189,123,248,79,86,50,169,43,254,152,245,44,29,136,211,32,185,236,55,25,224,60,80,48,60,224,186,3,194,54,113,146,163,239,159,138,203,255,175,81,173,175,242,53,96,73,49,5,180,234,237,154,56,149,245,219,190,222,75,21,57,43,76,192,181,187,211,181,241,56,178,227,11,132,213,88,47,2,93,9,56,174,151,160,218,15,88,176,236,199,40,52,91,185,199,26,107,59,187,9,116,132,26,21,7,44,222,76,55,66,76,111,3,170,106,95,66,148,21,225,232,103,158,207,244,76,86,155,188,114,176,180,75,62,106,50,165,83,83,173,229,38,175,42,100,238,234,230,238,202,204,54,237,87,201,58,107,169,244,44,207,142,189,215,70,45,199,156,248,146,88,110,86,44,227,173,191,153,115,180,171,13,64,177,165,153,181,158,133,21,78,72,57,28,84,60,89,234,123,190,167,0,74,116,200,4,186,181,188,117,161,247,80,224,201,189,194,216,45,236,105,25,209,231,27,203,17,143,141,172,144,208,221,127,123,61,142,74,99,9,170,180,6,146,147,232,66,193,55,13,17,20,140,13,193,53,3,129,132,131,129,162,243,45,55,237,243,142,249,137,29,200,248,152,102,44,239,53,35,238,252,67,98,139,37,176,212,73,97,170,145,101,27,170,90,69,79,235,68,227,101,22,53,183,128,56,87,52,21,228,162,171,181,214,199,16,68,64,150,147,96,41,179,17,48,134,108,144,197,205,220,157,216,30,51,147,146,71,255,70,41,232,16,156,31,219,194,32,91,27,243,204,0,105,205,28,159,35,255,249,244,233,67,56,105,35,143,89,152,233,205,117,150,110,240,91,196,9,149,113,178,91,10,148,203,39,245,208,93,187,197,246,109,14,234,8,103,233,223,141,94,241,196,32,239,193,43,143,12,212,197,208,76,98,177,21,238,60,202,154,59,94,173,234,78,21,41,208,84,245,192,50,134,23,181,93,177,243,137,61,202,181,3,237,218,170,191,117,74,242,0,132,126,118,67,150,76,123,45,177,224,209,85,212,0,166,8,172,221,16,227,162,58,248,181,41,140,198,12,2,196,109,91,23,210,86,72,98,170,194,182,197,142,136,162,179,168,244,90,182,126,70,229,65,94,236,29,197,197,220,85,179,4,178,21,38,78,245,81,171,37,188,197,194,181,117,52,195,230,185,80,244,224,167,179,217,40,113,170,91,168,201,195,216,0,113,13,179,195,201,8,158,122,70,188,82,252,103,115,8,68,123,22,72,234,44,169,107,161,108,51,31,245,23,33,151,227,36,62,151,90,42,30,97,156,72,198,178,205,163,126,208,193,86,226,114,18,35,12,216,139,121,186,100,5,99,28,202,117,191,179,11,13,0,184,127,104,8,88,79,72,130,159,4,225,158,176,254,14,158,107,167,89,194,16,217,48,174,120,234,49,70,22,138,137,100,246,166,207,102,188,73,53,220,31,206,202,124,239,202,147,250,188,235,168,98,40,52,35,197,175,49,22,196,166,226,70,191,18,171,187,104,178,48,105,186,38,167,111,198,117,56,13,176,204,172,202,64,172,167,105,119,12,200,225,45,153,30,87,75,177,176,129,97,145,14,72,40,134,214,172,188,99,233,100,78,227,56,30,135,106,136,35,237,125,37,224,41,31,92,81,79,179,65,16,43,153,2,70,153,84,1,219,57,135,142,135,148,227,13,107,100,60,198,153,118,212,68,248,108,232,251,120,109,159,199,138,96,12,120,117,20,200,203,233,99,195,115,66,87,233,172,235,125,164,108,172,140,65,222,22,229,74,77,2,96,119,195,239,90,243,246,122,160,88,198,89,94,60,199,87,73,107,209,122,187,56,8,123,5,81,97,133,216,164,30,94,245,237,117,200,251,70,115,165,13,155,82,47,109,61,218,116,2,76,172,21,16,112,245,60,20,98,162,93,255,4,229,204,180,237,94,89,231,47,23,179,48,11,251,183,121,7,131,177,67,127,83,123,234,219,127,53,110,187,183,172,203,220,207,150,73,127,37,134,223,53,150,153,155,43,106,64,80,220,221,249,85,234,108,212,207,5,179,248,158,77,163,193,143,113,62,79,92,3,234,178,21,252,173,36,0,79,88,172,136,26,147,8,92,74,86,46,239,26,234,26,135,224,164,34,46,174,139,155,79,73,243,218,244,46,171,71,179,255,235,76,205,136,209,206,82,251,232,241,13,248,231,240,188,18,182,232,224,246,143,39,114,191,197,227,139,7,201,62,178,230,39,43,216,4,251,11,9,206,165,180,203,34,81,106,198,240,18,41,93,255,93,24,90,153,238,151,172,238,93,118,224,224,105,218,50,73,41,88,71,26,91,132,26,13,20,208,66,49,30,238,203,35,184,213,17,122,96,1,132,230,245,34,131,207,139,118,104,199,41,200,115,44,77,106,173,152,243,255,26,82,216,144,202,9,104,246,145,49,232,63,78,222,115,21,78,97,55,42,212,22,92,78,161,30,61,100,25,33,113,7,19,103,122,108,125,148,87,21,60,21,95,173,100,189,36,85,216,119,34,11,111,63,51,41,66,22,206,224,36,101,215,35,163,224,13,23,68,88,53,28,50,212,234,55,6,167,187,245,184,206,118,183,87,118,61,7,88,245,72,201,159,244,228,89,71,50,94,247,129,229,104,242,82,203,124,50,156,205,143,182,246,111,98,24,156,147,235,108,109,2,4,169,21,183,223,245,43,159,185,10,21,146,220,121,53,70,139,170,185,217,250,206,96,144,221,48,252,220,140,26,213,141,232,150,102,114,47,230,210,98,35,157,121,85,30,193,109,113,48,29,166,42,68,198,10,126,119,220,115,209,38,222,50,223,77,179,227,21,27,149,97,97,233,188,47,69,7,157,171,219,199,104,246,192,18,166,62,190,137,216,244,70,94,24,123,97,244,238,225,147,243,103,51,9,80,127,250,119,161,40,125,21,32,71,73,164,52,144,77,179,72,22,89,232,24,130,155,230,91,194,220,44,165,138,133,37,251,152,64,130,147,66,183,149,34,142,66,111,12,76,148,41,183,158,114,234,203,46,115,1,175,106,134,81,65,85,241,116,68,231,204,87,111,47,200,17,190,86,103,125,216,87,7,8,202,104,194,194,84,142,215,94,187,229,1,67,52,93,93,94,11,249,46,95,237,141,148,90,208,223,200,214,211,164,39,253,231,91,97,204,42,167,167,131,201,232,16,202,241,129,239,171,249,155,103,191,219,230,103,201,89,129,223,140,42,109,154,106,52,66,143,31,232,83,233,185,99,87,248,132,25,235,198,122,236,189,198,150,1,125,189,19,9,114,201,3,16,129,167,148,100,72,166,73,218,54,193,50,107,24,181,37,193,3,98,0,221,26,253,9,50,230,253,26,12,253,237,53,73,139,239,248,5,65,240,43,238,112,221,50,72,107,227,107,89,115,97,29,173,187,28,123,103,65,217,226,235,151,233,77,238,240,107,9,146,158,73,87,88,0,188,138,223,139,84,25,136,254,156,65,228,252,72,14,41,4,191,215,38,48,144,112,165,48,142,12,9,18,130,56,17,237,231,81,157,152,118,218,78,29,125,124,24,111,143,19,91,245,189,47,99,30,254,26,160,216,140,55,150,145,249,254,128,242,227,41,185,137,2,194,20,28,10,92,213,164,24,225,201,70,219,239,4,48,8,244,65,24,94,213,106,3,11,102,211,145,223,159,153,5,247,14,62,198,49,126,9,220,99,140,127,191,54,238,220,93,88,50,213,176,247,161,96,207,153,236,236,79,216,120,58,91,99,158,35,192,200,77,68,172,194,50,193,238,25,171,33,78,229,177,221,191,232,24,226,125,46,232,93,12,206,245,241,174,33,52,108,160,191,233,8,150,43,15,112,176,201,217,94,37,190,133,50,161,24,146,46,144,130,152,212,66,252,172,35,215,116,38,233,47,94,33,154,28,59,65,165,58,225,248,102,227,39,160,15,46,87,30,48,207,159,190,91,68,48,181,11,149,102,223,202,201,52,155,53,49,37,208,35,250,110,232,162,164,99,40,62,206,53,207,201,209,209,20,103,90,95,228,254,165,252,19,176,105,112,147,137,134,98,255,137,138,177,204,141,253,167,11,199,8,198,47,170,8,110,172,145,163,13,124,96,9,219,194,201,3,112,127,174,210,199,254,207,115,175,182,119,231,106,157,126,159,24,21,8,233,246,112,190,229,119,121,239,91,193,1,167,45,45,151,14,89,137,241,147,175,37,152,156,95,155,221,142,58,171,185,185,185,125,225,54,42,206,26,137,198,155,121,206,46,41,191,147,237,255,160,138,140,15,78,185,72,216,164,62,150,203,139,32,151,200,67,223,157,149,193,190,252,68,230,19,146,132,235,48,87,255,178,142,193,252,89,17,130,180,23,196,215,124,13,76,22,72,149,97,4,132,211,164,73,48,7,28,28,70,116,168,105,245,9,48,230,40,231,127,237,236,127,2,251,195,137,112,96,154,186,233,145,112,252,14,164,30,129,171,52,219,231,228,224,49,155,173,128,165,40,93,228,58,6,41,57,40,12,184,175,1,24,31,8,217,131,38,154,144,169,238,214,176,235,179,143,126,92,100,72,46,120,96,143,157,35,0,219,234,199,207,184,187,242,55,118,35,53,119,184,171,204,238,238,235,158,12,211,233,51,67,254,208,67,96,151,178,147,103,34,1,24,135,68,115,232,113,60,189,114,231,169,144,150,52,45,162,38,194,164,92,170,85,63,80,159,244,118,83,144,205,90,38,92,135,80,26,173,208,71,8,254,133,8,56,49,65,56,193,36,36,161,55,219,108,45,85,25,86,159,99,222,122,88,106,4,76,100,215,173,124,35,99,191,34,211,255,176,226,83,65,209,136,7,253,99,66,161,221,172,19,216,248,213,39,237,237,42,162,48,11,114,79,28,221,48,15,193,151,218,3,230,234,251,246,48,59,135,98,224,185,219,112,7,44,179,234,238,96,53,150,67,81,250,82,98,211,12,231,124,68,211,176,50,121,9,107,74,20,124,171,7,202,42,97,250,92,230,122,173,65,152,205,230,86,7,15,16,139,13,166,8,47,57,138,156,173,198,172,118,143,42,69,180,110,34,66,198,22,220,242,21,86,253,3,112,94,126,129,20,20,95,12,31,118,97,73,73,51,167,43,191,238,186,186,148,206,92,199,73,13,73,117,104,249,241,216,83,225,41,213,120,37,1,248,94,51,164,3,90,239,91,37,88,74,132,31,72,184,59,45,50,160,18,162,29,167,80,15,180,74,107,100,139,184,233,14,8,107,123,38,241,158,9,184,252,53,214,232,195,235,134,132,154,195,104,13,193,87,190,35,113,203,134,213,243,78,133,90,211,35,19,233,62,223,218,117,18,236,145,243,215,246,8,213,231,43,53,51,234,49,176,186,56,221,32,234,158,110,72,122,129,203,10,254,122,121,252,221,87,33,211,133,136,187,191,89,151,19,192,206,134,46,52,164,45,64,194,29,113,189,81,55,224,46,196,45,220,229,48,107,243,212,26,63,219,97,116,171,106,117,144,19,51,160,112,216,251,233,221,199,103,114,166,33,169,177,187,157,139,126,150,224,21,163,209,76,127,11,180,103,54,171,244,153,32,28,146,232,124,161,100,168,144,111,70,195,12,245,243,70,149,109,34,146,233,184,243,155,190,248,53,189,233,173,203,106,144,246,42,196,228,169,44,12,131,19,145,181,90,231,237,244,110,202,59,140,167,235,207,55,85,11,187,105,160,248,18,162,232,205,30,116,96,51,229,26,74,216,34,133,78,31,241,105,50,35,195,123,54,235,206,173,7,187,243,116,147,129,27,153,153,235,92,164,203,242,26,93,2,96,28,100,193,241,62,67,43,99,174,162,108,39,172,78,52,100,137,34,22,147,195,82,219,179,57,132,165,141,242,189,227,229,60,59,33,101,159,116,219,233,183,229,106,27,134,135,70,30,177,227,217,224,31,10,69,179,218,100,49,49,153,104,211,162,252,3,73,233,43,107,129,63,252,85,217,101,250,44,248,57,65,70,51,84,31,128,247,198,42,201,126,140,205,186,87,109,64,231,227,2,242,164,166,45,94,228,189,231,95,155,34,135,250,63,116,81,196,136,243,112,150,197,194,233,110,97,193,77,13,223,17,249,77,66,154,160,221,177,196,224,49,223,119,195,82,230,162,232,13,129,12,42,37,119,150,245,93,81,48,39,44,123,56,195,74,107,118,28,39,177,205,96,151,200,115,201,35,128,192,69,52,140,46,153,252,53,161,101,73,50,225,82,191,139,176,72,173,168,22,14,228,203,158,245,150,46,200,0,199,58,185,44,111,26,229,171,151,69,9,192,1,164,114,101,52,0,11,176,91,116,87,100,86,30,234,93,161,57,146,130,223,225,198,172,61,154,146,148,60,238,96,187,17,247,74,76,117,198,152,79,23,150,6,65,103,97,217,126,227,155,30,108,232,207,16,238,231,247,81,194,188,33,228,237,2,56,95,61,186,98,51,68,42,176,210,134,177,191,73,226,68,59,160,203,227,160,82,71,238,148,199,35,142,11,61,141,116,81,52,185,250,46,48,132,95,242,211,166,29,181,216,222,180,184,160,141,181,11,217,208,149,254,171,37,136,55,198,221,118,231,182,239,214,208,197,172,176,182,139,145,29,112,40,166,59,133,75,145,100,127,182,13,157,202,89,5,119,226,213,110,117,37,152,165,235,233,254,35,41,63,82,140,246,159,48,41,116,255,217,100,239,64,111,201,121,9,64,115,192,88,230,185,180,77,14,192,216,62,232,12,174,131,78,209,100,247,244,77,136,85,20,78,174,25,177,66,88,209,113,152,61,138,43,155,69,179,26,162,197,86,45,180,79,217,241,150,202,154,240,90,66,4,254,134,9,105,170,123,128,3,142,104,212,63,27,184,45,246,247,144,163,184,177,2,17,155,249,244,175,80,214,47,20,150,148,94,141,147,73,246,111,237,36,207,180,239,122,83,144,114,195,153,119,149,149,196,50,186,168,110,140,168,21,122,215,8,217,37,132,169,151,18,157,179,58,100,136,195,45,7,219,205,104,54,136,245,33,224,201,229,134,199,225,180,121,75,153,234,56,198,97,132,123,162,202,183,113,145,204,34,74,22,29,250,103,55,242,96,65,33,215,152,145,135,111,74,67,200,126,213,79,154,88,71,3,250,249,55,121,29,120,44,202,227,219,103,255,222,139,250,154,77,40,76,90,43,228,64,91,205,197,106,73,57,18,235,20,75,185,238,92,236,94,213,14,104,181,80,8,218,35,172,174,110,238,240,191,186,73,145,0,121,218,175,162,221,224,220,194,39,100,60,190,132,42,122,208,77,55,120,70,50,72,132,98,153,66,110,163,157,207,163,56,88,79,60,61,145,74,84,57,177,60,202,8,85,107,162,8,115,76,105,122,47,57,112,185,122,254,147,201,246,234,124,213,64,52,76,48,21,16,36,221,70,21,139,220,93,98,170,35,48,69,216,103,172,237,124,41,192,171,28,92,179,222,107,63,162,240,194,117,122,8,75,50,172,32,146,61,117,167,40,22,179,62,236,103,61,58,35,171,57,69,102,234,34,134,39,196,95,178,97,110,74,199,126,234,21,181,55,241,233,229,29,48,119,14,140,39,206,230,229,114,131,253,93,74,56,184,85,251,173,248,50,155,36,249,61,27,63,28,127,136,70,84,240,250,141,245,205,62,184,172,123,162,50,218,133,48,191,74,109,85,4,208,206,96,165,16,190,155,166,54,94,103,151,3,224,42,140,127,20,9,109,11,44,63,70,3,201,39,39,23,120,233,214,201,133,218,11,66,174,79,44,45,155,54,169,142,165,12,189,147,95,97,52,238,171,121,124,89,38,147,144,224,7,253,203,65,48,107,151,37,115,212,70,254,91,186,1,18,188,53,218,27,218,218,162,183,251,171,41,91,82,183,77,88,249,157,78,95,28,177,138,90,103,6,14,82,132,98,132,106,249,242,169,237,57,121,64,133,42,212,231,88,237,148,14,230,64,205,144,53,232,171,247,36,124,199,223,136,29,250,76,17,190,108,193,187,154,73,100,23,63,63,248,180,151,31,75,237,180,194,237,232,16,25,60,11,24,192,255,135,168,183,186,69,14,206,146,80,2,57,173,68,166,4,190,71,106,52,72,111,173,95,108,197,240,95,116,164,169,121,4,176,77,84,166,10,157,199,28,165,84,117,19,90,40,164,30,25,64,28,71,188,209,213,24,108,138,83,228,131,163,131,2,40,252,205,96,200,120,3,77,148,207,102,43,94,75,192,242,8,192,11,40,223,204,191,67,101,6,94,193,165,204,28,57,66,80,26,142,119,48,227,32,235,73,200,7,77,132,247,53,154,112,255,106,19,8,207,84,72,240,144,69,28,123,148,99,78,137,110,86,62,223,251,33,56,227,118,198,113,243,224,212,82,119,35,147,60,61,21,39,146,14,79,207,145,223,229,31,155,62,18,39,233,191,138,24,26,151,19,19,174,113,139,115,197,212,99,16,136,51,148,80,207,10,204,22,200,40,143,81,84,3,87,29,242,254,230,212,46,149,61,125,223,70,95,205,27,149,148,196,87,207,250,74,59,2,243,0,14,252,53,58,67,204,202,205,169,242,188,205,231,173,131,139,61,254,7,226,145,165,204,153,237,74,235,39,181,236,149,38,143,202,248,156,87,97,127,102,182,78,170,231,112,2,103,249,25,166,163,83,94,226,191,44,245,159,121,114,10,30,113,146,38,156,25,116,58,240,21,40,13,64,63,255,171,71,237,168,73,79,9,229,142,59,60,96,223,83,42,105,224,4,209,99,160,77,52,204,175,231,219,64,192,179,156,152,66,75,207,174,41,170,129,194,130,31,6,168,58,26,213,176,194,99,21,247,3,46,204,222,93,27,159,20,215,2,150,103,98,236,156,213,116,99,222,87,207,5,71,101,235,189,134,40,210,244,187,206,36,190,42,49,157,228,124,75,88,42,214,233,97,145,198,177,40,102,28,185,168,220,175,81,83,132,243,32,175,200,126,30,226,244,109,203,187,236,109,119,237,94,115,207,94,226,213,11,223,153,103,222,98,4,31,189,72,143,112,227,108,44,83,215,37,164,104,83,117,1,73,134,95,78,61,232,15,72,131,145,51,87,204,244,34,201,143,165,209,183,227,118,170,71,140,165,108,176,186,193,176,223,82,16,189,241,9,101,221,173,130,44,240,39,53,191,128,190,173,51,222,78,244,132,62,172,178,4,73,35,94,176,190,143,25,194,146,246,184,245,223,141,158,42,76,83,192,108,246,15,23,82,154,31,194,136,141,5,157,246,193,26,75,216,209,231,162,62,72,158,47,0,255,27,49,194,60,100,115,209,115,84,51,253,151,157,180,19,204,21,188,73,133,173,168,31,42,245,226,124,89,178,128,115,254,97,188,200,65,66,73,20,195,237,115,89,53,1,196,133,35,131,111,35,52,50,223,139,12,82,166,234,96,251,64,239,253,78,181,44,215,135,2,18,238,32,81,30,21,15,60,122,45,158,222,31,147,6,4,232,130,56,217,143,47,210,145,104,49,84,85,244,251,98,57,241,170,144,42,172,138,143,223,56,22,155,93,140,135,109,223,11,3,221,71,240,173,76,193,231,65,41,78,146,18,196,112,30,62,221,31,213,127,181,234,190,209,213,60,91,73,34,30,4,176,54,27,204,73,185,193,51,41,246,46,161,130,95,195,107,33,244,132,56,234,118,36,233,125,104,236,192,18,114,79,74,235,122,8,55,212,143,47,255,9,54,161,107,222,20,30,74,191,61,140,71,6,151,3,85,179,50,207,182,17,250,142,132,59,33,181,187,225,245,47,10,62,29,230,111,5,42,233,95,9,246,135,48,186,26,215,53,100,248,182,72,255,3,210,201,170,166,93,230,79,174,45,88,24,42,219,201,66,2,58,207,9,116,63,211,105,27,92,19,29,14,84,49,105,160,196,125,180,53,115,9,101,65,243,42,73,3,60,127,73,58,166,193,123,197,88,77,196,253,123,47,54,198,39,201,33,220,124,222,95,127,24,198,50,108,48,160,113,221,7,67,224,118,249,174,251,22,45,36,202,185,101,191,246,24,166,65,124,186,187,195,215,135,253,52,81,141,172,13,52,157,0,39,229,26,27,109,111,233,156,78,11,245,171,205,25,165,141,30,128,31,142,106,246,36,155,202,12,72,171,3,91,76,136,204,78,237,91,243,17,247,68,145,167,173,215,145,76,119,167,9,64,128,220,141,43,199,115,30,79,42,144,254,31,154,133,105,28,218,232,122,103,30,151,209,177,55,232,109,78,130,153,43,117,149,155,64,9,250,150,204,65,124,139,150,183,156,136,205,224,210,12,13,25,42,88,31,101,249,79,41,179,13,241,33,150,142,208,142,2,57,125,148,75,7,29,91,108,40,76,206,36,46,39,9,110,60,37,82,178,117,225,241,151,26,99,83,80,2,146,105,73,66,49,157,226,156,188,78,133,213,37,214,120,56,168,196,25,174,237,27,244,113,55,10,22,255,27,244,142,100,25,240,153,151,110,129,16,65,102,28,49,228,46,7,236,129,96,109,192,102,167,140,187,170,135,101,24,191,31,165,182,57,159,86,126,45,29,88,117,151,224,58,162,94,214,122,119,166,251,20,138,207,162,15,88,148,59,110,197,224,91,162,12,152,144,33,194,195,109,5,34,159,30,190,149,151,120,176,38,183,228,62,223,10,57,136,84,244,137,22,133,245,115,114,162,186,150,17,55,228,22,113,248,101,159,57,138,135,3,111,196,131,28,52,100,250,25,34,81,107,216,164,195,8,66,200,103,149,141,145,113,85,250,220,77,73,242,4,102,112,219,127,0,244,67,79,29,11,156,230,225,208,61,183,203,206,119,234,205,132,24,176,31,202,157,94,143,105,18,75,128,91,23,72,108,151,49,142,87,108,57,161,138,210,31,148,143,101,252,18,133,118,235,165,131,102,159,157,55,225,1,174,183,111,213,11,121,73,214,120,158,26,132,13,66,235,47,123,187,146,100,39,213,55,245,246,33,75,191,69,231,11,236,87,125,60,115,74,214,93,20,42,143,99,175,125,159,138,61,141,226,105,217,209,229,225,67,181,31,154,246,148,52,218,169,98,72,139,195,70,159,89,187,13,119,195,203,64,253,88,50,127,104,42,175,164,138,109,172,95,117,210,226,161,11,155,136,97,112,69,82,22,63,109,65,98,158,13,95,120,27,95,129,36,240,43,66,78,76,135,157,240,120,243,122,148,172,243,49,176,78,230,96,95,140,242,215,5,73,175,20,84,181,251,194,37,77,88,43,135,68,175,16,51,18,171,118,108,217,192,212,165,223,242,254,201,226,9,81,166,16,95,235,90,209,73,118,168,32,252,109,66,230,81,231,56,171,105,67,125,79,58,29,187,184,118,189,65,183,112,68,67,204,244,205,130,102,125,123,244,177,1,121,202,73,164,178,83,174,254,21,170,230,0,186,0,218,173,93,87,201,102,59,218,82,68,130,55,24,76,55,150,86,46,19,227,151,52,74,86,115,194,17,23,249,155,192,152,212,132,142,62,103,239,66,131,171,63,60,51,146,13,5,190,64,68,15,132,16,13,163,148,167,90,41,16,1,12,129,133,164,79,0,116,108,208,198,129,72,88,242,213,7,101,196,72,169,56,204,118,100,145,38,179,255,47,59,188,127,204,47,24,19,225,4,128,146,134,209,253,110,104,238,36,195,27,248,66,91,238,227,39,122,61,64,143,166,36,123,206,231,249,160,30,36,26,182,40,139,244,201,108,24,56,68,255,109,104,36,230,82,166,87,231,146,184,114,90,109,24,83,65,202,84,224,125,20,26,206,210,218,55,90,219,108,220,90,181,237,206,213,113,134,83,194,118,180,129,174,192,199,39,56,230,151,108,141,28,185,17,139,69,148,213,94,162,205,176,157,11,37,34,117,3,239,254,139,137,112,24,167,64,234,199,171,254,176,57,253,160,252,229,122,191,190,227,17,65,108,248,180,255,246,91,188,108,248,130,116,18,110,11,111,244,45,181,61,47,107,186,44,252,132,170,216,65,36,31,152,30,34,87,24,148,187,71,147,126,225,254,224,62,225,220,135,37,32,247,200,129,7,128,17,224,186,70,216,132,131,23,111,25,23,253,222,201,94,57,218,16,14,43,237,15,183,29,230,26,140,44,81,210,24,161,151,159,235,99,194,27,229,228,130,163,254,61,62,242,138,27,23,90,173,175,140,39,211,236,232,236,13,160,210,24,111,227,190,104,231,114,239,125,6,98,1,166,29,11,31,197,183,198,174,180,81,129,79,2,255,121,223,142,253,219,78,210,5,255,3,48,15,202,170,171,20,138,211,252,5,246,145,46,25,108,217,246,219,17,151,250,45,126,23,250,51,111,50,60,117,196,11,190,121,71,137,2,231,146,133,138,110,234,11,26,20,148,35,208,38,79,112,248,16,227,177,216,168,168,7,252,178,58,75,195,134,124,63,50,134,33,88,250,157,146,93,251,145,53,153,164,29,93,102,10,249,214,171,190,49,203,194,54,90,152,228,242,142,101,215,92,240,191,25,111,33,208,210,186,67,84,215,125,26,157,180,23,195,57,129,193,72,45,75,87,205,217,149,200,100,171,72,253,235,155,5,46,21,50,190,181,244,102,102,24,98,189,118,167,43,167,200,179,26,9,220,26,104,96,32,62,26,134,75,220,2,243,128,215,147,62,22,188,48,190,99,12,156,33,36,91,175,151,216,104,111,170,63,52,162,174,205,63,195,200,52,232,239,149,172,44,18,8,17,21,39,64,119,31,84,230,252,187,163,31,97,227,216,232,126,133,177,155,144,88,191,224,76,172,164,79,252,104,62,162,49,37,155,74,191,67,52,9,98,3,56,50,52,247,240,223,71,3,123,148,119,55,140,57,197,196,247,151,146,167,15,63,41,87,209,200,143,160,187,87,149,240,36,44,131,147,183,220,127,92,249,215,220,238,151,115,114,0,84,128,55,218,203,214,110,110,59,179,154,21,19,103,117,167,228,201,202,121,230,182,112,211,243,221,95,21,97,98,245,229,187,41,120,24,128,0,107,243,135,35,7,157,147,6,238,10,174,134,128,200,145,82,218,217,156,192,217,87,123,65,238,160,201,164,217,21,29,157,227,166,227,104,43,24,32,74,145,184,183,9,55,216,159,229,137,115,16,32,238,195,213,97,150,131,220,145,169,221,192,153,184,22,50,213,161,138,103,202,162,99,195,191,104,189,153,144,66,116,67,32,131,186,252,253,129,7,107,46,239,61,161,255,194,60,251,195,174,159,163,174,226,175,216,125,182,80,173,159,217,142,25,240,24,154,122,224,166,175,125,94,190,131,28,134,60,232,232,239,13,55,213,111,254,30,177,88,246,155,204,97,201,215,246,18,253,242,232,10,30,75,30,130,38,215,133,77,1,69,185,159,239,133,132,150,97,169,122,147,254,78,100,55,190,181,49,219,90,60,171,151,86,183,76,120,180,100,175,217,154,24,237,148,142,101,86,197,111,155,141,22,195,37,95,108,98,164,39,126,233,203,107,169,98,132,0,253,76,162,31,40,134,119,210,109,113,198,231,6,77,114,142,247,136,224,229,120,52,48,142,32,149,164,248,62,36,26,102,206,88,201,35,113,136,141,80,66,23,222,3,138,208,180,86,182,88,225,222,117,60,172,223,65,46,214,25,163,204,255,134,137,28,57,166,161,139,228,83,227,221,176,141,204,87,138,60,104,178,218,173,170,78,134,36,94,11,232,182,180,97,161,171,89,96,24,153,125,108,81,38,73,120,50,152,194,49,15,125,97,40,180,88,34,152,251,158,153,147,62,185,208,53,130,232,10,59,169,102,230,2,73,190,232,15,81,235,70,235,101,99,8,116,134,134,189,154,3,61,158,147,140,39,105,168,86,100,9,23,32,208,225,227,150,103,194,58,72,39,11,224,185,234,48,224,17,221,16,235,159,236,15,149,185,33,168,99,30,250,137,83,85,26,137,233,221,86,233,102,71,123,254,163,6,14,230,75,0,65,227,188,204,178,139,159,212,107,108,11,205,49,38,126,255,114,28,103,23,15,58,87,122,78,179,79,219,138,137,45,66,76,248,238,98,206,125,224,213,233,221,233,60,183,48,230,114,86,27,218,135,152,120,91,201,65,1,194,13,251,54,75,135,50,201,24,117,141,87,207,189,248,211,12,7,247,30,12,69,128,194,56,34,187,10,184,87,181,94,151,35,110,76,91,236,205,40,139,162,118,55,190,192,32,102,115,241,39,167,155,84,59,12,139,57,175,201,154,56,121,49,121,36,115,213,108,62,158,226,131,94,23,192,187,220,206,51,211,199,197,9,51,75,153,183,155,30,29,50,67,143,176,168,172,108,196,20,77,139,20,236,221,122,251,27,36,7,46,155,2,183,64,108,20,180,13,213,158,248,82,168,199,34,28,78,133,133,208,136,205,79,53,82,89,227,204,94,92,74,113,65,101,243,16,30,215,98,102,168,231,85,20,39,5,173,41,247,235,55,109,11,12,244,41,175,170,56,103,177,26,227,232,168,28,54,26,153,187,216,42,88,37,67,252,197,216,196,15,25,14,108,235,165,28,212,128,161,87,167,35,104,96,195,178,240,94,34,141,104,233,155,255,101,95,5,0,157,50,77,138,247,189,27,211,142,21,221,42,145,166,115,17,154,234,202,32,70,81,64,23,149,204,179,220,194,55,55,69,208,172,138,216,200,105,168,63,226,31,196,165,147,115,76,178,167,112,40,170,150,19,183,216,209,121,222,220,159,219,117,129,132,38,151,156,1,127,204,141,180,54,152,169,237,204,200,208,52,172,123,58,86,193,207,78,219,152,229,206,222,185,212,112,200,57,48,64,13,97,29,228,207,98,172,132,127,116,135,94,155,150,158,102,91,40,117,198,16,56,106,74,26,33,101,243,98,3,196,236,89,65,174,17,139,39,117,30,94,194,240,20,103,86,116,59,251,93,113,45,90,75,229,36,34,231,140,244,86,93,221,80,55,61,238,231,237,144,247,80,183,198,142,177,245,166,17,140,171,254,30,132,7,30,81,24,233,226,70,64,178,14,205,204,218,52,93,178,12,118,194,22,105,73,84,64,203,152,199,250,204,142,145,176,163,218,240,85,218,183,192,219,3,54,49,56,203,171,236,43,43,198,200,233,69,170,214,59,157,208,84,90,149,175,172,53,181,53,208,177,237,27,41,230,107,155,244,183,204,114,250,245,5,68,145,22,50,142,198,131,138,105,223,43,244,108,27,104,234,74,189,178,58,211,195,223,179,56,242,181,246,243,191,182,125,159,82,43,100,84,31,174,61,237,76,14,219,232,54,100,59,144,190,132,188,241,219,90,6,25,254,85,71,23,45,3,22,215,3,157,236,186,75,161,185,249,42,211,123,34,95,14,249,246,248,100,142,0,149,160,96,7,210,19,101,210,89,22,100,67,223,51,83,141,99,182,60,193,71,173,138,171,211,139,40,163,83,144,212,104,211,174,166,148,90,172,155,120,246,168,71,77,150,122,36,201,243,64,118,89,176,108,97,219,106,36,163,95,136,150,201,56,176,109,104,66,172,127,167,157,41,11,75,189,85,129,236,232,159,213,40,133,253,231,76,12,94,17,240,77,231,202,84,229,153,225,61,72,12,194,202,86,152,145,44,210,236,148,2,45,103,254,113,18,41,184,108,89,209,97,153,101,38,102,82,223,220,207,213,234,14,170,151,224,222,117,89,119,129,52,104,230,47,27,219,252,23,161,155,217,239,78,248,26,197,115,37,77,12,122,250,131,196,153,149,156,48,110,114,185,198,196,13,149,175,10,142,229,30,144,180,132,114,233,23,212,255,236,208,103,54,216,4,188,8,225,204,121,181,206,23,178,100,191,41,40,51,204,17,23,72,170,77,244,61,104,150,130,237,22,251,155,203,24,188,216,100,19,0,71,113,152,120,178,122,60,200,50,215,141,187,96,248,215,6,163,64,205,209,185,224,137,164,251,218,128,161,9,171,178,50,135,153,227,252,28,184,163,44,88,78,100,126,230,174,154,72,68,184,51,251,121,239,147,231,190,107,177,15,201,135,71,19,134,191,254,200,45,116,195,234,206,212,144,98,162,189,140,218,29,25,90,53,195,240,115,51,130,86,108,200,105,168,147,128,223,81,33,132,63,223,84,199,15,154,250,70,236,161,57,67,101,198,83,195,143,208,126,129,250,60,61,166,18,64,157,38,18,198,212,248,233,75,118,191,1,26,32,204,148,3,251,228,116,222,122,122,40,89,35,135,183,43,253,7,208,132,160,69,221,43,85,217,35,208,249,26,155,154,68,251,227,27,127,92,195,251,198,226,219,31,158,23,23,9,54,241,6,123,152,41,61,38,253,235,251,104,167,249,76,73,142,199,60,116,192,57,216,83,217,25,93,117,160,31,232,93,23,206,124,112,114,77,214,239,129,199,25,133,229,47,32,101,134,230,210,84,236,236,97,56,228,73,9,87,197,253,126,138,151,58,196,33,130,83,177,183,131,36,217,157,61,81,226,106,56,216,188,34,69,135,63,37,101,18,101,56,237,120,137,57,141,108,245,40,164,54,58,239,40,141,197,242,165,228,166,224,37,58,154,207,223,134,118,35,177,24,57,216,234,89,65,243,179,76,221,105,188,227,161,251,115,215,146,184,191,27,26,176,19,189,84,125,151,23,165,150,27,137,53,236,16,163,39,74,49,155,219,172,48,8,199,46,194,103,145,242,46,187,3,139,251,47,218,91,13,8,154,228,133,100,30,212,208,0,2,141,83,120,8,197,233,16,236,14,125,51,0,216,230,96,235,181,115,59,189,221,7,142,14,247,200,238,52,206,57,189,218,248,252,176,135,140,74,15,204,59,6,215,46,215,64,39,51,218,170,14,41,179,115,240,233,140,148,105,26,82,81,247,211,9,239,10,91,144,124,253,240,135,164,2,33,146,46,251,84,61,160,113,114,157,211,73,46,55,49,148,175,227,38,215,78,48,17,253,101,235,210,17,110,103,104,196,123,45,63,19,0,118,21,144,52,169,208,25,123,17,71,196,84,218,86,202,164,34,229,135,135,128,223,27,174,177,187,117,163,166,81,202,135,64,210,163,6,101,95,32,187,191,91,212,54,98,221,159,163,171,113,114,40,242,167,141,116,43,29,109,205,181,108,91,72,138,157,147,135,229,237,64,237,40,68,216,142,97,249,100,113,17,170,112,152,46,121,128,22,98,72,229,134,9,112,51,193,82,219,79,151,97,94,63,129,140,47,134,32,44,42,69,233,105,31,116,68,208,182,64,247,169,180,66,181,208,120,89,41,181,36,119,206,40,25,114,50,25,22,113,109,42,208,131,24,90,157,89,43,3,31,48,223,110,95,92,120,135,120,208,84,195,144,95,107,204,216,44,5,36,235,145,10,242,150,3,48,242,22,249,21,194,37,222,158,32,200,8,33,135,161,125,207,1,111,9,165,103,206,161,7,117,110,178,183,190,50,176,246,216,33,32,94,160,28,21,242,15,33,150,186,234,176,89,107,38,174,198,168,5,40,94,116,28,51,77,246,33,62,52,111,244,213,242,70,97,203,224,91,198,53,237,178,214,184,146,229,40,75,186,181,26,37,154,196,251,182,175,109,251,223,100,102,57,76,244,140,30,170,253,100,84,46,159,186,2,187,14,188,173,198,233,46,16,193,199,149,199,175,102,16,86,136,238,145,173,100,120,56,100,65,128,42,245,9,196,183,66,141,230,53,95,84,243,163,245,210,209,11,75,193,0,89,69,183,13,91,73,152,237,6,79,135,52,36,166,103,65,20,57,121,107,204,36,28,193,93,81,233,70,50,0,143,138,84,121,14,60,194,1,7,93,90,67,204,163,50,126,44,212,254,150,112,197,126,124,104,113,250,177,120,218,135,40,73,196,14,21,153,144,45,77,115,86,133,74,225,82,181,17,44,78,225,83,223,76,90,210,155,74,96,68,189,129,238,194,89,100,83,88,252,157,254,196,170,131,199,173,253,146,190,217,231,138,230,30,137,111,107,92,21,92,16,184,42,30,113,202,34,50,23,158,39,206,72,60,139,191,95,195,67,166,91,115,21,126,41,143,192,77,108,178,162,220,186,119,78,21,108,72,11,181,183,123,138,212,66,71,39,9,132,88,64,204,215,221,15,166,173,182,187,182,198,70,4,161,207,98,74,110,202,177,98,91,250,100,219,59,100,78,8,71,247,66,207,23,175,71,148,130,120,209,217,172,161,147,95,55,186,6,107,221,112,143,99,219,136,65,155,114,194,251,138,223,248,12,213,212,133,205,32,238,230,236,73,20,169,93,164,1,223,39,70,205,169,65,157,164,53,47,190,193,136,179,77,119,254,18,46,220,135,34,202,159,39,12,2,238,162,86,158,107,207,128,158,60,163,208,6,68,178,165,128,133,201,107,37,236,121,18,49,198,201,178,149,80,11,10,22,199,102,130,159,140,87,220,233,149,27,201,233,212,79,13,201,239,27,250,169,65,248,215,56,215,168,48,180,8,129,208,173,216,51,255,34,187,40,110,45,48,2,28,175,188,90,38,57,204,102,25,143,165,214,199,198,165,118,194,207,136,203,151,249,23,218,161,80,112,116,119,93,29,87,202,96,208,28,118,190,225,215,255,187,55,101,28,72,61,122,90,119,50,240,219,5,19,167,88,81,50,171,221,78,217,129,166,121,89,94,70,32,134,228,58,42,184,89,168,46,119,137,168,118,180,36,153,52,127,162,149,224,49,49,230,193,36,183,66,195,33,56,211,42,191,112,139,52,48,108,75,177,156,222,93,49,75,244,49,166,243,179,111,38,179,112,143,69,62,248,25,120,153,215,0,94,50,145,216,176,200,219,87,184,140,49,5,249,227,146,222,176,13,121,41,127,231,192,209,56,188,99,41,55,165,65,77,91,246,168,48,159,79,73,126,195,73,168,200,41,35,107,106,129,69,222,16,110,187,204,251,43,82,10,17,25,72,108,186,229,91,165,59,2,219,129,55,41,117,79,173,187,106,128,82,189,62,92,180,46,140,93,133,219,52,115,167,155,134,197,221,119,242,120,95,190,67,115,202,14,66,126,41,97,84,134,203,192,99,67,104,34,75,37,219,213,145,44,8,46,127,103,89,145,121,97,255,82,229,93,224,52,138,79,77,43,93,70,114,207,52,236,95,15,117,93,224,164,105,36,130,178,242,41,64,47,207,207,92,132,62,186,5,41,213,51,149,99,208,190,17,21,50,48,215,21,159,185,69,16,95,219,94,57,232,91,81,115,254,208,92,30,178,76,195,56,61,252,2,1,187,15,1,199,39,51,221,235,62,42,29,243,62,147,57,84,97,187,48,4,190,244,189,152,65,76,36,44,12,92,186,52,189,241,252,40,93,73,33,94,125,1,110,7,20,131,66,243,127,90,241,16,171,140,93,51,161,154,107,76,94,193,101,234,51,181,86,69,87,3,182,66,194,158,193,169,120,223,82,55,225,3,42,215,149,44,14,43,220,84,128,194,149,201,225,68,205,129,14,95,238,121,130,53,135,123,224,251,110,36,21,35,173,56,176,242,9,250,223,118,23,245,196,34,230,41,24,40,174,145,213,20,201,205,151,34,15,1,240,115,120,145,171,65,101,75,65,41,129,221,10,211,89,12,120,42,54,97,153,201,101,98,239,212,137,114,137,242,101,50,237,140,194,101,220,24,29,44,219,205,166,20,173,58,234,5,212,139,13,164,114,17,96,35,222,0,102,41,62,62,34,228,109,70,165,135,152,109,163,18,78,192,12,131,147,88,7,211,14,57,78,158,150,188,159,229,249,228,20,119,59,156,178,27,119,69,72,98,15,14,114,23,91,196,73,89,108,5,96,228,132,183,28,63,188,78,92,92,58,44,122,45,69,143,202,106,99,221,206,212,239,139,219,92,125,224,150,173,165,249,38,213,63,163,16,253,197,198,134,97,88,99,58,145,230,209,191,229,66,95,227,216,49,64,85,167,155,47,111,199,39,127,69,153,107,148,133,107,108,79,248,6,181,203,115,0,108,105,32,7,229,228,112,72,181,36,9,139,26,125,80,49,133,135,175,140,219,42,50,210,190,91,161,217,52,83,105,67,232,27,137,0,51,178,126,96,31,180,122,202,119,37,216,55,69,195,200,214,63,139,206,254,155,70,48,88,164,98,228,222,179,208,9,74,182,30,120,109,136,198,81,232,69,43,2,160,111,6,18,234,242,254,218,112,215,119,209,243,114,210,45,79,45,226,4,253,111,231,108,216,251,191,145,32,50,35,161,213,255,58,177,82,234,91,242,249,86,145,149,218,180,194,167,227,80,47,74,52,44,53,247,118,53,13,57,101,147,222,173,135,215,15,62,56,62,18,168,24,79,102,13,33,161,191,155,61,104,226,234,22,157,181,122,193,153,143,124,190,52,112,14,79,161,145,246,31,209,29,206,151,234,148,130,32,55,184,53,123,156,203,160,110,62,216,47,69,62,66,71,165,238,198,81,233,49,117,255,181,178,24,43,181,212,174,247,225,113,103,195,137,148,211,176,243,26,97,15,167,196,108,1,226,168,231,214,65,22,225,51,244,46,223,194,163,216,11,243,55,3,59,62,145,148,65,99,249,196,65,38,140,115,104,131,205,204,156,221,189,66,198,99,234,109,218,161,195,63,241,72,196,80,74,90,170,32,255,187,246,74,121,235,42,181,11,2,183,210,84,62,198,213,58,198,177,59,123,89,154,194,235,64,35,216,119,80,22,34,156,1,132,187,6,137,223,135,216,144,162,25,145,102,230,27,213,22,225,60,140,60,233,12,68,205,95,38,197,36,149,84,123,178,8,125,114,8,73,237,43,65,99,234,164,38,226,176,171,64,233,239,197,194,224,227,15,115,248,148,137,235,219,131,160,116,94,68,177,154,192,82,238,127,194,69,71,242,17,179,198,231,161,8,75,99,176,155,201,2,121,207,36,214,170,206,112,128,187,237,178,91,197,211,75,181,104,195,234,114,223,124,151,84,38,231,106,160,254,127,47,201,4,51,20,31,136,84,70,221,12,40,93,243,102,101,72,219,17,115,6,160,150,36,206,121,155,112,173,166,185,115,204,44,154,82,185,36,61,70,245,112,121,169,72,226,171,190,159,67,225,155,14,144,238,8,221,180,158,52,74,50,48,243,162,182,176,224,171,22,141,222,86,71,210,206,237,168,96,26,213,164,169,249,44,119,216,53,30,186,127,121,157,252,97,134,73,251,83,15,155,37,67,165,64,158,110,18,167,200,28,199,250,92,180,32,39,33,176,204,195,195,145,185,76,49,79,120,124,153,243,159,252,38,81,62,14,111,104,225,104,222,177,232,220,247,113,82,35,41,139,108,53,140,138,232,13,154,141,116,13,91,171,192,228,174,64,93,51,76,125,156,46,179,101,208,4,112,12,29,152,49,213,106,54,70,26,179,95,214,60,2,80,0,204,234,18,76,248,68,231,106,78,146,81,57,186,199,214,247,14,82,28,115,216,150,57,40,87,0,201,154,45,170,168,135,179,94,41,105,113,219,210,95,17,232,108,63,110,20,78,207,176,253,82,5,136,123,4,51,227,49,120,114,157,216,84,187,117,17,113,118,117,96,33,141,242,76,3,125,247,116,47,107,251,110,3,245,241,124,14,133,171,21,89,137,121,74,64,117,23,226,84,205,90,59,141,67,13,212,68,184,64,163,139,161,11,232,88,46,193,97,68,124,13,88,199,87,132,151,53,130,157,147,131,194,8,122,71,248,224,16,211,78,240,6,5,208,18,28,123,54,174,181,7,162,123,28,76,63,59,183,40,171,244,151,231,228,48,105,139,173,117,211,75,151,102,159,78,47,88,106,215,4,101,122,39,93,14,176,38,249,255,59,71,82,171,155,36,225,6,252,8,107,1,47,119,52,47,113,150,48,85,203,117,214,41,167,117,248,61,85,60,130,183,184,190,26,30,155,43,21,25,5,144,156,6,63,138,173,167,64,70,121,238,208,39,211,88,98,135,169,93,60,240,130,36,73,147,219,105,16,13,106,7,108,61,241,13,99,175,130,148,46,15,49,219,181,86,0,243,246,156,60,159,79,61,4,58,94,252,89,45,29,26,205,209,2,59,178,164,24,129,244,253,217,137,36,72,123,217,201,97,246,128,146,83,134,82,196,92,99,224,51,80,62,11,128,212,47,185,68,77,193,146,75,136,38,157,71,244,108,203,152,246,235,2,71,135,119,249,36,68,249,86,123,0,52,82,158,67,60,193,132,252,25,91,21,175,40,1,193,232,151,151,220,161,31,10,105,162,135,131,188,70,42,184,33,106,169,157,141,236,6,105,245,97,176,77,54,238,251,6,215,76,129,156,188,10,221,213,191,129,150,20,171,237,77,214,43,175,129,45,171,71,49,85,94,226,16,165,234,91,2,211,138,243,195,66,201,102,145,157,198,96,193,22,245,227,123,63,129,101,188,179,251,192,151,88,149,130,150,167,181,98,31,69,17,127,218,230,176,27,58,167,151,149,219,60,118,43,180,89,250,23,160,40,43,193,75,237,218,144,177,26,202,91,2,48,15,138,120,253,138,233,199,131,41,44,215,68,116,213,86,184,51,25,234,142,102,230,173,189,107,151,147,55,103,196,57,150,130,113,133,5,210,151,56,185,125,7,131,224,140,209,57,114,76,128,34,101,64,233,119,54,175,187,54,84,128,94,104,0,89,123,56,236,168,159,31,88,173,159,2,51,26,60,215,219,238,7,78,28,159,133,198,153,202,237,62,68,162,44,60,23,230,118,52,194,106,164,191,109,62,167,57,107,74,219,5,230,244,160,160,47,154,237,119,186,110,129,214,76,148,127,241,134,237,192,13,24,158,84,4,59,202,206,102,224,171,43,250,175,222,35,88,191,167,186,188,253,55,180,103,3,117,156,107,93,220,70,80,0,66,188,95,252,7,163,71,96,133,150,145,197,227,210,113,228,135,242,42,195,15,236,230,244,85,200,55,100,183,180,236,65,47,4,228,133,49,158,95,74,23,157,95,151,29,188,16,188,171,206,196,230,210,21,210,76,152,154,9,23,2,21,25,71,42,29,3,190,77,112,47,209,121,254,138,214,3,12,59,229,215,96,162,97,208,114,149,168,51,81,9,83,119,197,193,182,31,99,44,195,0,242,110,76,204,191,50,82,110,211,223,171,124,13,101,28,62,179,84,220,56,30,112,22,120,28,117,192,103,30,136,104,88,223,108,236,92,175,230,157,8,38,236,35,226,43,240,144,43,123,90,93,107,144,77,69,12,59,109,62,125,132,177,199,13,152,27,0,193,140,230,248,119,50,38,121,157,138,88,241,199,51,65,196,144,206,106,249,192,247,119,218,250,209,190,197,39,65,11,73,125,117,13,155,109,144,60,131,250,4,69,210,36,44,118,191,100,190,253,179,43,10,183,8,184,248,113,130,245,148,28,38,250,227,66,138,226,169,116,212,152,255,45,85,185,135,45,46,1,108,207,154,8,208,111,245,123,158,40,36,88,132,53,105,171,240,69,115,57,162,161,245,61,96,146,148,143,168,198,216,16,253,13,99,198,167,216,150,89,240,11,67,90,61,56,14,74,82,178,153,250,196,221,135,24,159,240,65,154,82,56,59,133,145,213,203,207,50,77,31,83,168,98,175,87,20,189,33,115,102,14,110,102,184,221,182,31,38,238,22,78,180,42,96,3,11,103,42,247,102,103,109,141,197,157,92,112,65,116,89,141,89,207,70,68,94,227,143,87,194,89,126,97,20,19,119,109,225,73,195,187,104,7,82,132,13,10,140,203,85,89,160,120,154,53,33,155,86,68,207,111,64,36,15,70,58,106,39,100,34,199,105,214,150,90,214,102,110,57,244,92,219,30,211,169,183,239,72,70,196,126,127,122,61,221,50,157,214,10,1,190,83,77,137,129,207,90,7,208,186,239,61,124,89,63,15,198,236,242,110,160,230,254,119,142,244,223,32,123,123,175,240,183,177,78,242,23,64,179,228,225,249,252,74,82,244,70,235,47,136,113,221,49,19,52,31,253,170,98,247,136,183,113,36,66,171,246,117,105,139,108,17,188,220,235,158,224,100,199,59,209,18,50,220,39,106,239,70,107,246,162,212,138,111,102,17,112,54,213,11,142,241,8,181,7,206,180,91,53,119,113,186,115,202,148,92,195,249,156,17,72,225,174,45,30,246,137,57,42,243,135,240,116,73,145,217,5,31,234,166,61,216,153,4,81,132,141,170,134,50,252,135,96,190,213,193,223,243,224,218,208,189,222,56,210,125,34,218,154,48,183,50,45,72,128,239,103,173,12,112,218,221,31,171,89,21,254,130,244,151,30,136,212,27,86,214,130,45,168,11,78,230,228,178,117,28,13,206,0,145,57,33,211,98,200,230,122,142,186,113,215,24,97,5,172,178,146,146,110,208,151,107,15,220,137,153,181,132,133,119,175,201,223,196,169,98,79,204,223,194,1,11,106,147,138,238,221,4,21,55,223,131,100,234,179,23,190,188,115,92,183,102,125,198,201,236,214,175,60,79,181,170,253,227,87,241,8,77,206,19,37,18,0,145,51,182,231,133,63,152,81,1,144,161,43,111,71,132,169,123,133,212,139,112,113,86,64,140,174,25,58,150,21,110,185,53,157,210,240,18,115,31,113,56,99,209,20,243,93,18,73,128,117,163,108,120,28,234,247,57,71,167,54,209,63,93,189,219,50,18,229,39,124,69,255,92,36,80,95,66,238,16,158,159,97,173,190,70,143,191,180,149,171,249,208,178,122,214,144,83,148,76,161,71,205,206,154,21,159,118,188,77,76,220,107,45,4,161,118,102,132,72,158,170,29,141,28,100,212,50,253,132,29,50,218,101,42,249,229,65,198,50,71,89,236,70,152,167,209,7,217,132,248,149,199,147,73,216,186,110,149,242,181,3,179,3,180,255,68,21,140,37,194,198,33,246,187,100,48,65,149,66,140,113,18,123,33,141,163,26,56,32,249,140,164,234,171,41,81,40,52,218,159,61,48,110,125,197,51,53,170,198,51,79,35,156,193,232,48,118,204,200,84,100,48,56,162,216,17,160,106,47,163,99,162,116,54,173,78,28,52,4,97,197,33,123,69,85,100,132,197,129,251,160,126,165,79,140,83,186,213,174,102,180,210,175,134,84,74,225,107,141,130,198,234,80,227,84,98,5,156,230,211,10,86,20,102,128,194,17,239,200,116,6,90,125,3,249,56,200,194,160,118,36,157,235,85,44,213,130,92,252,135,145,75,0,219,60,77,217,131,189,145,86,255,38,123,254,135,36,210,177,91,173,108,230,199,144,149,116,20,5,191,195,223,168,27,217,93,53,165,5,105,182,171,175,211,217,231,157,255,185,121,48,43,73,151,197,85,146,238,218,148,41,189,255,100,153,143,189,149,118,51,162,45,159,8,147,183,248,230,196,129,247,81,193,123,52,116,122,40,133,19,124,89,49,26,158,126,59,242,182,202,141,123,83,253,114,44,174,215,173,104,107,59,42,193,144,237,218,99,35,236,165,169,39,204,186,204,147,42,121,5,107,123,84,56,151,189,41,185,46,234,207,141,31,56,58,52,220,87,32,39,1,17,99,206,157,15,101,191,13,39,167,105,28,94,131,178,112,239,25,206,210,113,110,184,66,232,158,192,124,119,130,131,162,131,53,232,177,246,115,194,101,9,175,230,243,100,244,240,92,77,250,59,212,151,156,190,76,25,197,187,60,16,160,101,46,15,147,191,251,7,51,29,184,137,152,17,224,243,131,45,152,98,100,7,129,195,62,101,104,50,122,167,66,243,87,139,60,81,74,244,173,88,59,79,181,55,92,210,162,83,166,9,171,131,195,37,168,98,177,69,198,193,204,106,165,64,170,9,56,30,143,253,129,206,176,179,18,154,133,223,204,60,227,183,92,203,228,138,66,57,24,199,173,144,39,124,176,160,10,135,220,111,78,79,243,175,54,247,121,134,47,200,222,65,94,234,91,31,49,51,130,42,229,160,236,207,102,82,188,24,233,163,188,251,90,224,49,118,120,106,138,129,55,109,158,14,108,100,191,91,7,7,52,24,85,130,34,229,14,90,55,214,126,183,185,14,240,182,247,73,147,107,7,218,183,219,5,81,141,59,62,27,248,79,118,198,76,63,121,208,80,34,92,158,133,156,148,206,223,52,113,101,89,161,169,79,47,253,125,120,30,147,254,55,205,116,192,6,179,186,136,134,195,37,92,78,78,149,66,83,34,141,239,245,50,162,94,145,97,39,206,162,115,83,112,237,239,86,103,132,147,70,130,54,249,144,101,172,142,67,33,199,153,111,0,137,148,71,64,200,85,99,110,64,31,135,30,157,94,1,165,29,226,146,7,195,122,165,212,239,221,36,173,128,200,32,43,29,105,202,224,239,210,132,210,91,29,213,155,6,196,158,225,45,201,111,19,233,16,210,231,93,220,181,119,154,166,71,199,71,173,19,160,37,17,222,135,103,87,16,220,171,12,213,245,67,65,63,61,212,178,56,56,230,228,248,104,27,103,178,197,251,250,19,33,28,25,149,43,162,133,40,177,59,193,192,95,125,193,74,25,230,102,69,107,31,31,144,33,46,212,166,229,161,146,122,10,224,29,128,189,198,81,53,123,140,67,133,100,183,20,72,107,248,231,57,251,217,209,132,50,130,186,160,168,39,215,11,0,105,54,226,254,51,240,40,50,171,143,178,35,101,166,238,136,228,122,0,208,114,39,215,164,241,151,28,238,86,170,75,198,30,247,82,82,87,138,247,98,173,51,66,90,212,165,252,5,194,240,139,95,1,179,40,217,141,167,95,64,242,191,25,55,130,121,63,102,242,70,134,138,230,90,198,155,33,57,89,20,35,163,127,25,117,211,188,228,42,169,58,179,133,240,232,228,109,54,9,103,97,174,107,236,175,230,23,77,40,24,159,124,199,39,232,31,10,13,99,75,162,99,88,85,3,154,237,248,34,102,184,82,209,37,150,58,212,54,207,19,64,82,211,163,128,53,212,228,47,34,207,70,11,206,91,71,136,225,231,5,50,185,45,142,85,77,204,152,175,62,145,57,73,116,9,36,127,175,255,238,142,53,171,209,180,246,90,234,78,170,116,59,235,123,167,21,189,228,179,15,46,78,129,9,30,243,184,100,11,241,153,63,53,243,191,133,219,92,141,29,255,203,18,81,33,208,14,154,180,142,155,150,83,184,139,68,56,61,126,70,61,175,182,35,128,21,245,6,29,74,149,60,220,232,33,61,237,34,142,252,57,254,76,235,196,48,19,149,146,132,114,94,193,105,60,85,20,88,9,221,230,146,76,36,55,172,35,9,6,50,250,210,61,239,121,5,155,229,176,74,223,238,64,248,111,46,232,175,33,228,104,223,157,115,195,199,166,70,160,110,149,75,105,168,242,68,178,137,158,88,176,188,201,253,222,230,252,186,0,185,138,241,153,226,233,11,117,102,44,90,163,220,243,180,96,116,167,158,211,105,10,220,109,237,100,106,115,172,217,86,72,250,177,159,66,29,33,137,175,19,106,133,148,34,226,215,228,105,243,199,148,28,169,58,191,81,37,232,102,205,72,151,158,21,87,105,59,11,75,179,86,123,50,180,63,123,59,81,199,129,163,88,80,152,99,142,200,169,73,107,145,238,125,35,39,143,125,135,237,213,160,203,175,161,86,47,113,192,26,250,39,77,130,74,113,213,209,176,23,190,12,50,107,195,112,148,88,167,161,178,198,216,51,189,104,5,73,0,53,128,62,113,81,24,204,77,226,168,178,221,79,6,28,29,22,45,123,71,7,119,54,221,197,219,31,114,217,179,75,229,124,136,82,216,61,147,43,231,204,192,24,214,190,255,15,138,141,220,34,207,95,163,144,15,58,22,227,9,41,230,212,113,134,240,218,198,45,30,132,54,194,234,198,205,87,82,183,128,6,221,159,204,205,81,143,3,129,133,4,144,215,190,237,85,62,55,68,140,63,237,101,101,226,56,114,40,244,214,33,167,79,192,37,29,210,239,23,49,118,221,230,252,220,75,1,18,135,181,117,178,192,106,24,36,108,4,182,46,26,136,221,42,159,210,194,248,94,3,232,241,188,0,60,98,80,62,160,196,162,47,8,187,252,205,59,255,185,255,33,183,74,204,13,90,181,59,168,200,255,60,14,189,179,134,173,45,17,26,182,253,128,34,168,22,29,118,176,46,2,148,62,106,124,195,116,164,25,95,14,63,160,27,112,91,244,200,47,47,11,11,247,110,196,101,36,164,205,112,231,69,9,61,35,32,63,250,121,80,5,80,30,187,240,244,120,161,1,30,97,75,107,180,223,231,122,106,225,153,112,172,184,24,215,60,225,34,8,124,254,109,76,76,148,64,249,249,201,97,142,127,109,177,129,129,12,102,212,163,2,114,43,154,106,144,127,118,68,31,40,54,237,68,219,3,186,164,62,175,209,141,251,67,5,134,232,173,164,86,112,27,106,56,68,161,190,96,38,244,175,213,114,227,109,251,204,158,209,217,213,197,233,114,127,44,227,110,151,38,246,173,16,233,190,149,16,8,179,84,73,151,51,170,123,216,170,214,119,186,187,135,124,232,234,35,143,6,159,46,83,19,232,179,35,3,185,41,230,144,35,28,105,107,201,5,129,208,45,245,86,181,198,47,150,63,227,14,33,219,154,19,60,38,110,239,240,111,64,94,152,50,97,204,192,66,128,236,40,47,42,227,198,166,222,155,219,84,220,61,116,64,86,227,106,215,144,171,100,89,49,74,208,175,182,166,75,117,230,188,41,209,188,188,46,2,132,202,43,246,28,38,85,153,125,73,3,181,57,39,134,41,226,104,142,138,162,49,79,108,229,138,152,111,127,25,52,127,33,81,235,95,215,85,42,130,57,134,122,227,205,112,172,107,229,56,169,90,208,107,75,232,6,57,215,111,208,59,105,207,132,154,174,35,237,221,61,57,66,30,17,241,189,195,22,23,197,19,98,101,79,49,97,198,59,138,139,57,103,51,227,183,72,57,160,202,85,42,251,134,204,106,96,237,124,66,125,13,251,127,156,202,9,72,46,8,15,1,132,193,113,200,50,199,158,61,16,64,149,122,108,218,90,63,150,107,224,177,44,175,22,74,161,118,125,157,47,255,241,61,143,100,245,205,57,230,255,15,211,91,116,97,102,120,60,145,49,21,233,252,50,103,56,61,148,86,41,172,177,33,136,242,187,114,103,66,112,25,8,189,166,82,102,109,108,1,16,126,168,17,235,217,46,198,255,58,209,45,196,14,248,157,126,3,196,33,161,5,241,13,63,215,35,221,145,182,201,59,30,58,114,146,56,3,101,117,220,14,8,203,167,22,194,167,179,109,124,246,137,25,165,202,64,13,221,241,177,41,147,227,45,158,222,178,45,246,166,82,144,87,69,17,52,230,156,112,149,109,233,0,3,253,250,127,250,131,59,233,107,34,143,221,54,17,160,21,202,197,250,156,207,198,104,99,28,58,77,27,136,187,140,212,251,58,46,15,64,234,166,60,40,177,175,239,72,229,180,233,87,212,185,193,134,75,12,87,135,91,46,29,137,97,94,237,243,173,50,252,135,3,45,134,60,80,201,244,21,55,13,135,198,170,198,174,121,119,239,56,47,193,124,167,209,137,181,202,156,185,65,90,221,125,148,10,39,84,48,128,2,32,238,39,50,61,122,50,200,117,215,154,3,135,131,69,227,124,135,205,7,84,91,102,44,251,250,231,48,75,101,227,224,42,189,14,30,42,35,225,126,0,76,63,48,113,227,217,188,249,250,37,87,102,84,213,150,48,39,51,66,106,244,220,122,66,9,27,111,107,235,169,7,105,76,156,217,218,169,169,158,218,231,57,14,217,125,112,1,253,160,107,69,141,101,151,126,168,114,114,67,64,99,177,0,181,179,199,62,28,146,4,94,48,194,241,49,55,148,34,19,209,221,199,120,48,191,16,222,106,239,0,48,77,245,9,22,57,228,77,33,88,243,207,20,239,54,82,190,92,236,22,187,221,253,83,115,131,192,42,161,2,229,125,76,159,250,176,205,177,97,25,172,58,253,81,125,131,223,170,244,204,25,103,223,181,172,137,235,176,115,218,141,41,47,233,48,184,156,212,85,65,57,48,7,186,240,155,78,211,215,202,90,178,56,218,156,30,77,187,83,158,242,85,171,183,162,204,131,217,138,144,2,152,51,248,135,244,233,137,210,6,254,65,161,147,171,226,24,7,15,2,127,67,185,203,117,82,109,46,227,169,25,4,178,217,183,206,213,95,6,23,201,112,188,132,28,17,40,215,222,231,100,129,50,209,45,94,141,220,80,204,13,1,218,103,28,228,152,170,190,4,218,215,208,52,79,240,25,121,102,131,194,31,197,165,50,110,6,109,42,95,224,185,34,33,177,198,41,184,70,218,53,90,220,56,46,111,252,182,62,216,180,172,217,169,152,58,38,232,96,172,140,249,163,125,47,207,3,79,212,31,83,236,57,169,30,121,110,82,250,246,218,196,68,145,58,45,120,112,209,72,179,162,93,26,162,166,105,130,160,102,24,182,192,105,82,67,24,253,238,126,221,81,222,67,240,125,224,104,118,124,123,221,125,225,184,163,90,242,241,238,15,59,23,246,191,103,152,218,229,21,237,63,4,98,8,180,194,4,225,20,172,179,143,104,132,59,163,11,57,155,171,100,194,203,138,210,202,67,203,171,193,125,122,13,221,160,231,150,236,139,40,107,72,199,76,88,5,229,186,145,133,44,242,214,169,141,175,243,144,48,97,99,104,240,245,208,236,23,75,158,126,13,106,153,243,199,124,158,114,113,125,207,29,199,7,48,47,133,181,102,31,74,21,75,212,201,39,51,137,109,187,227,40,111,125,160,79,110,254,28,140,109,100,43,123,150,153,32,155,128,215,120,81,140,232,58,222,0,45,153,181,45,94,56,122,92,180,17,184,178,214,126,156,194,60,244,167,189,157,16,251,213,69,156,140,54,195,27,251,224,74,160,231,79,32,58,198,196,235,130,41,4,111,25,17,145,87,1,1,249,1,50,98,5,191,102,24,28,88,143,242,251,2,1,69,31,107,212,207,55,226,255,163,45,70,210,73,160,61,116,170,164,169,151,199,2,24,120,237,187,72,28,175,222,149,10,229,212,210,253,109,4,98,151,228,71,189,172,168,58,87,137,231,61,51,100,104,17,60,216,34,240,36,60,48,104,11,6,162,222,78,158,144,59,97,18,187,58,165,255,112,18,215,230,214,6,0,145,42,219,150,183,3,216,236,97,250,49,83,234,100,216,230,78,253,150,194,69,158,222,229,161,24,204,17,252,113,53,161,87,205,162,229,138,176,211,179,35,46,69,56,19,187,141,13,111,46,108,220,22,65,41,31,100,135,5,94,228,134,119,24,76,92,178,58,140,100,104,240,240,32,202,63,202,23,66,57,4,175,67,57,234,39,255,122,69,184,175,45,10,144,247,19,178,96,44,127,101,146,2,41,4,110,113,141,25,153,96,42,50,28,113,173,20,19,49,225,56,87,210,19,42,25,66,195,54,239,191,162,44,46,122,32,0,43,241,58,109,221,217,160,166,57,61,218,1,93,242,146,23,101,244,41,107,217,208,150,206,224,126,196,209,178,253,59,181,91,186,29,75,185,165,247,77,87,52,144,130,250,181,167,119,211,161,89,200,94,156,3,185,141,115,56,108,161,158,168,173,239,130,17,157,192,214,21,209,245,110,245,75,159,7,48,109,127,104,243,10,147,46,214,158,199,164,156,64,221,34,230,3,41,157,249,49,27,252,105,119,80,229,106,75,19,93,170,80,68,202,82,44,123,237,48,205,240,47,99,233,73,90,3,47,15,193,172,5,23,78,152,124,229,60,213,80,253,160,169,127,180,237,228,93,55,211,218,134,30,21,237,236,38,144,57,104,197,222,41,29,232,94,17,14,60,234,188,120,34,242,23,212,132,136,243,115,239,137,182,111,188,230,150,116,0,234,190,253,135,109,107,140,91,44,84,218,226,251,172,203,7,207,70,145,155,94,105,56,75,177,43,44,215,69,110,177,246,140,56,157,109,91,67,253,181,129,204,215,239,68,181,235,35,115,222,251,174,49,94,152,101,33,145,159,40,147,44,121,135,149,85,101,52,166,135,50,95,104,90,215,129,8,84,98,231,170,217,204,214,196,203,74,250,187,115,217,160,37,56,175,12,53,202,224,150,184,54,106,175,62,22,78,9,237,2,149,175,253,58,217,9,88,113,120,220,61,38,3,91,39,103,248,28,50,201,69,37,35,197,163,194,210,200,100,19,60,54,121,164,175,34,77,6,25,200,104,159,204,120,85,87,85,244,169,177,142,53,41,211,227,19,69,109,88,54,246,230,254,113,91,222,200,53,115,30,216,20,72,151,34,8,106,213,217,130,129,175,195,161,148,246,233,37,4,49,237,68,251,116,152,70,82,163,133,111,144,26,37,108,181,65,51,152,187,54,162,204,204,213,25,10,25,60,229,20,40,220,126,162,179,73,47,111,111,10,178,233,158,74,122,144,125,251,12,242,138,16,207,77,172,238,51,207,78,22,184,85,69,56,64,7,61,23,156,58,131,149,190,42,254,95,249,165,141,89,243,230,246,100,60,56,226,249,127,15,207,106,213,91,67,248,236,121,206,113,43,58,114,69,142,102,245,212,220,241,141,193,229,242,222,221,80,61,221,7,145,56,113,144,59,230,53,5,191,23,183,36,50,171,2,56,63,87,180,182,150,154,199,179,181,46,6,132,248,102,69,183,84,32,226,159,200,224,139,164,99,226,12,82,132,114,217,208,86,247,47,111,71,193,245,66,246,230,201,164,64,222,60,184,94,192,195,75,111,200,205,64,117,197,87,237,107,222,229,214,31,71,8,160,50,72,208,11,1,238,132,19,42,234,30,107,143,78,211,230,135,101,18,241,206,235,110,165,14,127,39,98,151,225,176,74,211,167,194,151,171,223,151,24,205,109,87,42,108,57,102,80,217,233,52,55,24,21,107,223,87,81,7,138,174,77,192,122,80,5,172,126,97,79,226,150,178,149,249,230,196,231,241,29,176,209,202,20,92,117,67,177,46,125,191,218,75,37,70,132,14,90,61,225,8,126,194,205,84,174,76,232,178,231,215,124,32,126,35,191,190,135,94,206,226,107,156,136,208,225,1,44,53,81,235,126,119,135,6,50,10,97,2,141,80,140,53,74,23,214,63,161,72,21,166,68,113,213,45,9,76,157,56,230,21,15,137,35,63,135,49,206,35,39,101,153,182,199,56,68,243,53,219,249,109,77,14,174,211,173,139,115,210,192,87,98,63,233,165,30,237,201,204,171,233,25,44,2,14,35,120,183,32,207,224,14,220,99,65,213,220,187,218,51,192,187,146,119,129,84,111,175,28,106,30,29,62,175,19,145,146,67,209,118,242,81,77,198,133,120,119,191,207,62,114,170,214,239,97,113,234,98,123,32,76,136,64,134,238,60,190,172,188,66,191,248,241,142,99,37,145,212,202,56,85,227,116,15,94,26,41,98,67,153,108,223,74,12,22,5,14,130,86,111,245,47,150,126,145,64,60,68,220,226,192,26,108,179,75,143,26,168,246,228,67,220,100,97,106,164,123,222,236,42,211,117,141,12,176,86,181,96,234,67,132,38,117,76,151,196,208,252,148,157,202,10,3,90,100,129,177,215,233,14,69,199,26,26,44,0,6,13,182,108,210,229,142,141,17,3,31,107,245,148,178,44,53,32,50,163,169,29,236,102,117,13,169,123,254,29,87,108,193,27,32,0,131,150,33,97,241,244,162,14,4,253,30,65,150,51,14,107,50,138,99,20,206,55,72,251,70,61,139,30,9,121,229,176,34,56,234,239,2,213,246,151,62,237,183,155,36,22,115,211,17,199,59,205,13,52,90,191,120,13,99,221,73,108,22,159,121,130,80,95,55,158,97,223,0,141,11,183,1,85,67,71,61,245,41,80,209,217,201,87,243,210,206,51,60,196,22,50,132,222,236,61,221,181,110,212,21,110,64,26,96,179,252,61,223,190,222,97,239,65,151,227,117,149,99,178,133,94,115,156,35,227,165,168,170,134,238,91,23,98,59,170,148,118,116,34,117,245,208,167,120,140,72,172,219,36,83,59,40,20,11,253,194,145,230,96,212,177,113,82,137,93,182,224,121,50,234,225,255,2,158,14,35,90,2,231,215,225,6,147,143,91,133,205,116,205,244,182,205,0,242,169,45,29,216,19,89,115,28,198,109,218,200,23,224,204,44,177,114,111,237,24,105,239,222,135,14,121,74,114,130,167,218,214,135,209,157,203,206,34,108,101,147,91,115,236,223,200,84,73,212,140,184,59,67,139,86,142,87,226,131,46,169,68,201,119,45,209,66,64,225,29,222,98,79,44,105,81,195,61,124,172,71,151,116,71,233,128,118,104,112,218,88,73,13,69,45,41,32,182,110,66,49,56,224,79,180,138,116,64,212,188,0,23,98,151,128,43,73,217,188,32,157,89,210,46,165,4,105,208,125,68,24,40,229,171,7,131,188,16,89,33,55,38,184,153,13,153,126,198,161,80,163,112,200,231,5,51,109,119,114,92,53,39,240,176,224,209,98,116,51,136,43,54,196,139,158,200,28,143,225,173,107,97,249,231,162,139,207,196,189,228,88,196,18,111,201,107,140,123,46,109,12,239,134,243,244,108,92,23,161,126,212,229,150,175,119,15,15,161,240,69,219,234,250,51,218,39,40,156,7,150,187,21,1,120,59,170,171,180,166,161,63,77,89,6,206,245,19,162,136,172,90,57,120,20,51,79,60,64,81,225,191,172,78,55,12,202,242,214,97,33,243,11,201,214,250,66,24,239,253,131,11,193,202,82,58,10,169,74,229,81,163,210,3,120,0,3,102,190,122,105,218,4,12,129,132,35,207,71,169,91,31,152,27,51,232,63,86,213,137,31,142,117,251,7,151,207,74,242,252,206,188,234,161,204,40,44,72,0,41,83,64,12,11,51,100,46,47,148,178,34,117,91,115,172,171,48,183,118,205,166,181,241,42,211,138,157,19,174,129,167,156,219,166,237,6,245,185,176,124,80,16,221,138,99,114,250,90,65,40,51,135,138,182,218,215,103,68,27,72,208,161,168,113,228,82,142,143,199,118,243,18,15,6,85,187,42,184,183,27,76,48,86,120,13,186,138,255,252,183,175,43,195,16,224,223,194,24,54,48,244,144,103,235,241,80,101,59,99,150,87,38,253,128,13,171,233,197,56,86,132,11,176,215,172,211,61,7,94,96,132,26,123,125,32,37,94,246,163,226,32,99,48,55,88,36,16,99,210,254,36,206,74,123,120,108,55,53,237,116,33,31,4,116,243,194,229,83,48,58,139,174,129,173,224,249,117,228,193,118,193,132,229,237,221,17,127,154,108,234,223,187,234,250,66,239,179,118,96,172,189,64,51,123,33,25,220,33,194,95,8,226,59,227,211,143,208,11,55,201,13,228,155,138,153,2,225,144,142,161,182,144,40,165,40,205,210,174,149,37,26,76,128,211,17,112,54,249,157,113,231,195,48,200,147,235,88,37,164,196,217,181,19,16,201,232,186,247,86,152,183,139,198,102,125,29,204,44,5,222,219,46,133,50,239,228,21,49,61,32,143,167,4,127,116,161,77,86,23,230,11,121,62,75,64,52,10,234,60,103,140,82,96,50,241,20,81,13,173,75,106,223,104,224,89,218,163,237,160,214,129,217,74,99,68,150,182,137,186,77,75,226,46,81,235,239,126,121,107,239,138,186,205,225,171,84,156,136,160,250,42,70,178,242,104,15,246,151,4,193,232,60,15,4,221,39,69,169,184,176,237,11,216,172,5,85,141,195,251,116,2,189,232,103,226,134,218,30,21,61,31,111,249,110,32,178,6,46,154,121,41,74,0,67,139,163,205,189,27,215,218,189,50,161,204,106,78,21,249,178,56,203,31,151,182,183,116,194,240,199,77,7,196,249,131,168,183,214,106,191,3,121,225,200,135,71,129,202,12,54,222,197,34,178,53,41,209,94,55,198,16,208,52,114,144,65,138,11,80,158,116,211,122,184,97,246,141,192,24,255,31,148,172,173,229,88,62,246,237,151,211,201,53,184,5,227,251,102,243,4,187,214,107,71,225,168,123,124,121,129,162,216,236,56,99,185,50,246,120,28,201,227,76,20,212,242,195,38,232,28,27,50,28,242,104,72,245,202,237,67,245,241,123,61,72,156,83,48,3,60,160,75,88,90,175,69,6,116,37,24,222,232,22,140,171,42,18,145,193,44,212,46,154,140,240,76,112,253,61,252,129,200,123,172,87,215,63,172,126,186,178,18,17,133,123,207,13,158,212,183,158,79,61,114,237,215,242,91,95,219,186,37,75,44,194,213,116,216,216,102,46,22,33,77,130,240,241,254,235,7,118,210,93,28,223,173,103,120,106,244,178,230,103,157,92,250,65,26,243,231,114,91,235,188,232,253,74,235,79,163,104,63,121,20,238,0,196,88,85,221,91,171,80,11,85,79,4,245,19,217,32,10,144,120,161,95,58,134,134,37,207,107,40,224,27,222,131,119,168,15,186,169,254,129,131,196,67,147,205,76,136,6,109,146,65,62,178,120,12,83,142,238,98,39,41,67,206,84,93,234,106,110,241,69,12,188,104,208,170,193,173,64,65,77,29,75,152,88,43,42,76,220,11,57,195,20,2,191,233,140,240,122,0,33,139,147,57,230,128,240,148,87,138,36,16,138,174,32,100,178,180,42,254,234,244,94,21,169,98,201,0,171,31,190,46,12,229,86,33,181,94,175,162,170,49,72,202,25,118,108,254,240,213,113,196,58,148,82,253,131,146,44,166,5,36,232,106,246,153,129,169,195,162,119,28,227,50,229,178,134,223,216,14,222,168,222,190,117,44,138,18,45,115,239,179,73,173,133,80,55,147,210,204,44,123,180,216,33,205,207,113,161,183,27,20,63,58,173,246,127,182,138,226,223,119,165,122,29,88,118,58,225,212,214,78,2,146,84,241,125,202,200,160,1,29,176,75,184,103,42,25,247,101,48,45,165,178,145,200,246,231,55,3,18,67,209,5,211,179,135,3,189,40,1,252,141,17,84,115,220,91,165,254,125,96,5,35,56,232,233,234,86,202,9,131,180,86,233,252,77,78,234,178,186,36,86,225,109,69,204,246,235,16,142,36,1,121,170,146,176,36,69,102,0,82,159,39,31,136,64,39,149,130,70,198,119,191,134,58,133,70,77,63,72,100,109,141,82,158,158,192,35,97,47,197,186,0,152,108,106,68,155,187,190,115,97,164,41,144,184,102,3,44,102,17,214,114,141,85,235,57,120,85,235,209,159,107,229,233,75,168,151,63,93,215,127,80,20,157,158,254,62,212,83,21,3,41,181,117,9,92,87,80,141,36,85,181,248,26,168,8,159,3,188,169,239,59,16,253,154,230,0,83,17,9,138,82,154,197,12,151,16,224,184,97,135,120,87,152,172,204,178,138,58,84,231,92,78,226,10,157,16,2,184,22,69,91,191,8,249,246,202,130,82,62,182,124,239,116,147,245,134,5,113,26,227,132,5,249,193,169,9,209,2,35,236,255,159,92,6,59,15,196,247,221,143,61,139,237,48,58,137,198,122,211,249,169,121,145,153,107,105,11,244,188,97,115,55,223,109,196,58,46,117,210,68,154,179,255,244,220,247,94,233,94,55,245,221,222,120,214,226,23,156,137,255,182,118,208,103,242,51,176,140,126,163,230,168,142,130,62,96,131,132,60,241,59,218,56,210,139,158,160,64,167,59,78,145,182,205,208,10,151,150,128,21,123,70,58,108,68,49,88,167,109,125,112,40,159,240,105,185,178,195,206,9,135,57,209,203,117,160,133,137,2,6,110,97,126,196,251,192,131,136,107,66,176,133,129,200,136,236,100,156,126,235,81,98,104,210,65,130,200,58,204,134,24,86,239,12,98,255,239,96,137,54,174,15,19,249,250,81,75,62,184,125,8,34,112,0,124,125,172,75,39,28,229,61,26,144,38,99,130,113,209,139,81,113,21,106,24,131,41,248,44,215,33,197,152,13,174,237,167,121,100,5,106,219,234,121,70,6,139,52,183,40,250,240,166,92,73,73,3,197,29,158,209,236,252,88,30,213,254,248,199,247,205,196,121,142,29,119,138,18,41,199,214,162,235,29,27,223,1,57,91,68,38,235,73,204,35,216,45,237,224,57,133,16,242,112,2,221,70,185,247,213,29,113,15,19,196,94,55,132,137,251,94,3,166,123,203,77,112,247,32,2,29,167,24,200,156,216,37,171,158,243,97,103,22,59,204,131,176,166,46,213,92,167,212,170,54,91,84,52,105,237,239,253,88,89,232,33,29,87,27,184,78,45,7,98,167,16,227,189,214,95,32,132,20,137,238,133,63,163,220,250,157,79,32,70,113,155,161,6,101,219,171,36,106,31,2,252,242,73,29,203,250,2,150,98,247,221,20,142,248,251,97,70,103,196,230,169,154,144,252,145,109,4,218,128,40,182,230,187,229,227,201,144,182,192,58,60,192,166,26,43,105,156,105,56,82,7,122,62,195,215,35,51,99,156,101,6,9,14,152,48,10,187,67,205,192,207,200,220,240,235,183,79,0,167,216,46,15,18,158,237,212,2,224,102,110,255,10,69,232,112,14,75,32,190,128,88,86,67,28,95,40,120,37,68,17,153,229,26,212,132,237,123,116,254,108,80,77,199,16,27,225,5,198,178,50,198,38,9,165,23,208,109,28,199,69,67,131,244,185,48,84,125,226,150,157,58,7,186,116,54,191,99,115,65,212,251,119,202,54,199,143,168,68,238,68,210,53,126,0,56,189,47,248,44,215,218,37,11,133,50,36,223,52,104,175,250,53,54,134,218,118,117,184,178,149,153,92,157,85,139,229,22,231,101,21,44,24,226,127,90,93,200,127,87,105,86,140,210,225,92,69,12,54,15,55,126,245,78,111,82,45,198,255,50,84,232,105,180,231,234,205,211,104,150,10,179,239,66,1,66,5,26,17,234,224,96,233,134,221,20,115,190,84,6,27,150,215,157,177,71,36,4,51,173,85,69,61,150,252,39,73,61,86,56,178,22,99,35,57,27,105,190,133,24,232,100,110,194,111,227,61,83,139,144,145,168,33,50,37,92,141,190,0,238,30,182,83,53,246,160,39,40,38,57,187,160,47,158,21,48,25,45,100,220,34,239,18,9,59,39,161,220,188,157,100,61,4,84,76,107,45,144,56,93,163,87,22,132,237,124,99,55,206,2,246,187,124,187,183,196,86,90,213,145,237,56,198,202,217,243,208,0,80,111,143,114,221,115,220,35,62,167,102,191,127,193,26,171,198,227,130,80,209,41,205,106,60,197,152,104,54,16,177,208,26,21,152,172,224,160,130,197,97,164,10,146,104,183,183,112,112,158,241,191,102,250,10,16,77,188,99,100,242,209,199,92,198,114,145,15,130,163,79,70,50,169,200,131,133,13,32,47,110,185,14,221,60,176,63,121,70,107,113,101,132,201,22,158,230,147,35,205,100,185,72,164,98,155,193,188,42,169,211,158,17,131,89,150,255,137,134,182,123,122,188,1,46,125,96,181,56,201,126,240,230,31,80,10,231,91,24,223,210,200,126,235,45,128,250,194,227,90,146,128,164,130,14,186,235,203,131,226,212,1,242,13,233,110,48,161,13,202,3,249,97,240,75,8,123,92,216,80,218,115,103,214,229,92,31,202,172,27,126,248,210,193,186,185,235,114,39,60,49,115,206,157,239,55,125,166,26,146,67,223,21,151,220,158,160,251,173,146,19,60,93,15,13,134,93,247,60,137,15,194,240,3,204,222,63,46,214,128,211,110,39,75,17,246,33,15,220,45,238,124,227,161,209,127,38,250,23,4,44,126,188,35,42,167,130,191,129,144,32,251,149,45,160,167,32,246,241,163,175,170,77,59,137,102,242,113,42,40,116,140,18,53,196,108,208,179,89,136,199,107,52,171,145,111,86,122,198,186,179,241,167,75,179,202,77,140,76,20,6,170,202,69,254,140,30,122,115,18,30,17,207,139,142,52,27,15,124,15,246,209,63,87,185,232,175,165,12,143,160,208,159,34,144,83,18,109,157,85,162,16,134,88,92,255,92,3,208,221,111,224,166,196,205,253,152,56,119,59,182,1,164,102,56,183,78,49,173,134,15,152,166,163,154,241,10,78,238,167,127,173,242,1,6,16,232,46,136,216,117,116,110,108,67,25,79,229,40,145,16,211,222,194,165,43,32,236,158,247,168,61,178,19,30,247,90,48,200,151,184,89,195,66,137,195,129,42,248,217,96,198,127,181,122,216,153,215,218,135,74,179,122,61,153,149,233,145,170,241,22,129,36,206,130,190,13,0,132,223,20,224,2,150,26,227,82,117,16,252,163,179,98,232,242,210,110,144,83,222,2,233,125,31,64,206,11,171,115,144,218,202,245,153,68,93,133,190,157,193,217,218,0,237,64,175,50,191,238,166,74,133,248,142,175,132,11,136,7,151,55,12,38,99,235,20,203,102,184,167,184,251,231,186,183,65,194,222,235,39,27,41,127,159,51,27,49,34,40,132,116,140,50,211,43,20,197,165,29,192,154,215,162,109,46,21,193,139,218,219,158,99,96,171,210,62,69,51,202,174,179,227,236,41,240,193,83,124,38,37,132,125,74,110,151,225,233,18,245,85,161,148,242,22,233,40,234,238,212,191,205,25,165,53,228,98,49,97,126,251,191,57,60,219,153,236,31,120,12,45,193,10,190,233,184,111,197,141,13,11,45,255,106,239,242,178,140,13,229,209,60,106,8,176,169,12,152,227,24,105,111,34,89,99,165,185,106,27,233,178,50,31,166,216,102,200,150,249,176,5,222,66,67,212,176,5,20,118,15,216,77,103,71,64,10,79,30,71,234,209,2,90,252,218,109,79,12,172,35,183,252,245,82,153,191,243,60,17,52,100,113,103,239,114,55,135,14,173,158,99,234,151,41,87,135,144,119,72,84,241,231,62,123,82,212,65,178,221,37,186,116,17,232,36,239,193,72,17,86,166,167,255,5,142,37,124,141,225,212,172,245,208,160,126,92,173,252,42,35,151,86,210,124,168,80,211,255,240,89,188,4,170,181,115,39,58,202,32,115,74,51,186,246,24,246,27,251,216,186,21,83,100,236,128,217,215,40,252,120,4,247,102,118,236,207,116,117,130,59,75,226,33,96,27,82,38,117,150,180,11,136,96,4,19,7,19,115,67,89,189,162,5,139,5,178,4,13,121,225,152,33,231,237,76,45,128,193,157,205,0,77,176,253,87,207,76,250,184,2,243,51,88,32,190,3,131,152,182,179,99,187,147,194,13,50,149,29,244,90,190,194,103,122,130,105,251,149,9,159,250,252,79,80,240,165,117,151,111,98,55,243,211,110,211,99,189,249,224,43,160,17,80,1,214,254,109,21,229,14,59,113,74,102,218,11,222,183,71,177,200,75,64,30,203,171,46,55,68,72,109,5,213,197,72,16,192,161,12,125,243,220,108,12,23,91,41,243,80,16,103,61,171,36,107,22,185,42,159,17,6,18,98,85,161,229,146,5,201,173,16,102,5,185,34,91,91,244,2,214,161,76,172,140,186,39,181,234,234,77,200,65,183,229,25,4,146,106,139,252,253,104,211,57,41,142,79,230,124,250,207,68,187,181,92,77,98,227,131,49,191,182,206,103,121,6,37,195,37,27,88,49,221,58,74,195,137,118,113,32,254,137,154,9,137,121,174,207,211,73,179,158,169,112,54,71,130,208,43,231,49,156,16,57,12,207,89,109,228,25,113,249,129,137,8,86,167,140,60,5,91,200,22,114,171,75,54,166,72,178,244,45,13,216,177,184,157,217,61,190,241,131,58,47,31,42,198,142,119,140,30,9,153,187,193,21,84,121,201,79,141,163,67,247,147,166,157,234,33,46,11,34,105,176,245,136,217,237,144,177,177,111,13,194,192,25,8,173,242,58,39,182,197,12,245,227,104,157,76,105,204,137,219,93,62,229,17,210,157,249,146,169,126,205,115,14,81,142,235,233,162,88,168,163,182,59,233,147,31,242,125,197,255,62,150,237,29,136,43,85,253,53,183,135,236,99,30,174,120,190,196,240,214,245,148,188,141,125,2,229,9,58,42,171,111,129,216,164,164,144,120,213,68,172,89,43,135,11,132,216,122,163,101,42,21,9,27,210,100,186,79,43,179,208,222,34,60,92,221,118,23,17,67,80,54,29,168,200,1,218,119,18,132,180,14,226,186,252,8,163,113,176,83,198,34,141,30,194,132,200,132,199,15,189,89,23,176,97,97,7,7,8,26,74,188,219,74,52,136,67,127,17,129,66,236,132,221,61,199,226,42,81,12,106,240,150,122,243,52,145,179,12,175,64,226,26,7,113,215,243,43,98,237,135,13,4,161,130,7,43,74,124,49,222,227,180,75,169,221,24,49,175,153,249,158,29,138,202,15,201,204,58,146,22,171,193,177,19,112,197,241,17,51,118,181,58,166,206,167,216,128,66,219,13,15,230,232,9,167,129,129,254,127,121,216,170,144,32,91,232,90,155,38,52,54,113,88,180,114,64,198,212,231,40,150,4,89,110,116,222,79,42,222,169,60,115,56,27,173,41,123,231,89,247,110,118,24,45,217,247,225,249,43,132,46,44,81,128,225,210,233,4,237,79,64,46,227,217,157,39,230,80,84,248,5,47,9,221,233,145,119,46,162,113,199,149,231,143,172,55,96,26,188,48,75,88,43,236,39,213,118,82,181,160,183,117,97,66,136,165,101,188,107,121,67,72,252,9,119,188,88,84,131,77,33,186,107,223,128,129,94,242,64,242,11,55,222,145,238,235,213,131,240,250,83,120,6,75,121,177,67,22,115,25,76,224,132,14,87,141,18,121,92,165,158,23,122,79,103,227,3,142,63,205,52,135,76,109,11,51,194,90,176,180,106,163,216,219,179,177,138,37,130,87,36,154,252,172,231,28,190,44,75,192,159,221,79,63,243,160,213,62,253,93,3,41,218,120,112,245,106,230,0,179,16,155,7,0,71,9,7,253,119,38,10,224,107,155,113,79,55,239,11,74,196,57,220,187,17,31,106,7,223,34,233,36,159,76,146,147,181,43,14,124,220,75,181,181,146,190,212,24,152,222,174,106,70,51,19,106,49,161,62,0,120,1,156,147,126,246,112,20,72,74,230,132,62,40,183,141,155,74,205,182,25,44,53,88,192,133,152,146,177,54,10,156,146,43,89,138,154,35,174,225,171,93,23,73,176,140,187,180,166,119,11,8,119,145,36,177,195,189,2,28,67,14,7,68,63,172,62,244,31,187,86,4,45,206,221,62,77,176,22,129,240,216,195,124,93,152,28,210,37,237,206,62,242,235,175,194,52,32,3,92,123,124,205,205,235,236,85,9,20,222,135,99,241,227,137,197,156,248,86,92,138,156,230,158,27,45,2,134,141,149,243,231,188,217,175,153,151,93,3,238,152,172,58,249,163,87,149,38,145,190,26,202,6,159,116,59,139,109,180,130,232,100,134,102,224,45,18,132,215,247,155,106,82,23,200,142,186,128,102,217,35,169,46,215,180,226,73,253,92,244,126,81,80,70,24,46,104,231,56,42,119,234,253,152,116,234,26,112,37,246,153,183,107,122,162,26,88,110,115,184,22,136,4,225,204,49,184,141,180,103,69,40,192,21,183,65,152,215,31,129,40,26,116,240,68,206,230,36,133,44,186,31,202,56,92,116,248,143,117,247,51,71,121,152,255,186,97,96,54,126,247,6,49,93,221,62,58,80,254,61,92,92,91,216,152,2,85,53,51,161,43,12,189,92,80,162,4,53,163,188,215,103,74,134,86,20,146,67,187,181,139,162,214,122,168,225,42,6,138,108,189,111,188,80,115,1,166,121,160,42,166,59,179,18,106,101,182,205,166,246,81,226,34,128,225,33,0,126,92,36,128,36,7,68,249,30,114,10,84,62,246,79,92,25,71,61,49,56,10,216,88,66,7,211,209,199,194,96,79,200,97,53,182,206,168,204,125,53,232,46,47,191,148,55,57,202,52,197,146,28,131,232,21,218,63,184,19,152,195,103,115,73,33,202,60,29,160,244,199,11,175,206,248,80,244,187,96,27,144,252,235,118,2,120,160,210,46,219,236,165,19,62,242,220,182,62,238,237,127,31,254,220,150,34,47,86,55,50,247,50,118,81,191,157,171,63,62,233,78,157,85,17,188,212,106,106,168,198,27,232,236,47,8,73,147,162,138,187,235,111,227,163,169,230,157,58,131,51,139,240,164,25,241,80,105,139,173,214,102,52,103,49,214,209,23,200,186,51,193,2,40,63,126,118,139,246,58,232,99,162,40,107,147,180,170,18,247,210,115,123,135,98,226,188,10,199,35,230,112,3,177,7,255,58,173,26,129,67,175,238,48,22,156,45,149,36,193,166,52,59,158,37,213,209,186,81,135,235,187,119,94,166,209,157,177,29,240,189,105,163,70,139,168,14,171,66,145,186,170,170,110,29,151,94,113,156,198,99,16,228,155,197,108,154,71,203,90,3,188,11,108,66,134,136,41,152,59,78,242,179,238,110,241,49,73,215,28,62,47,112,149,20,36,188,140,84,110,79,230,27,197,252,131,113,236,77,168,120,206,229,181,59,222,137,246,88,192,183,41,254,115,233,18,249,251,191,50,56,141,186,233,34,108,96,222,22,126,14,31,37,137,140,187,124,217,67,3,148,59,197,52,10,81,138,93,224,238,215,169,81,84,79,53,247,196,8,253,17,55,5,56,229,171,94,234,205,211,24,228,196,164,117,253,114,129,231,83,24,131,66,87,97,64,242,1,168,225,82,23,106,60,222,91,173,97,232,83,139,245,133,188,208,197,2,237,17,146,113,131,14,134,144,194,211,77,52,99,104,90,96,74,191,20,53,63,70,84,32,253,220,68,219,196,76,220,232,177,207,132,177,226,237,234,115,188,137,193,163,33,133,189,67,118,180,119,195,187,123,187,121,138,185,92,68,108,162,248,133,11,95,160,232,180,133,247,125,53,207,24,157,138,49,101,111,26,145,14,66,80,159,142,164,135,143,192,33,202,114,177,125,2,106,33,49,209,8,225,184,33,14,13,207,162,6,207,106,207,125,53,69,86,1,121,43,87,93,11,85,111,226,58,208,179,246,120,49,133,116,170,17,250,206,8,151,246,12,12,70,61,70,80,220,163,33,8,124,70,144,211,176,152,215,3,131,16,67,20,239,192,250,212,33,244,251,23,144,190,82,26,207,211,108,92,71,87,79,59,184,27,102,79,223,162,200,159,12,159,166,238,59,50,226,132,109,200,38,35,242,240,55,2,185,143,235,138,253,115,178,107,129,110,240,180,87,26,85,168,80,47,23,102,1,79,109,98,161,8,154,70,114,8,33,59,98,49,3,240,140,135,61,53,188,24,12,71,224,219,149,216,184,132,6,102,30,224,20,166,165,182,251,84,123,125,240,144,120,92,13,177,88,141,155,178,138,84,10,100,130,170,85,243,127,152,49,238,151,24,43,229,255,83,142,87,182,13,169,130,27,121,192,47,125,84,122,143,61,109,169,75,117,197,167,225,74,3,146,237,65,137,27,163,233,5,224,152,122,121,208,153,92,243,200,252,38,235,218,110,63,101,176,246,135,35,231,122,245,215,186,237,231,35,220,179,1,179,87,155,193,197,62,71,240,71,124,149,208,56,22,62,188,140,132,32,117,14,192,24,84,162,212,91,36,139,140,211,47,176,44,198,193,29,197,133,211,252,38,126,130,24,250,137,107,238,35,80,43,54,136,85,213,160,74,186,220,141,221,145,234,225,234,183,130,101,93,124,174,111,81,222,81,174,152,39,61,126,165,169,25,233,103,100,34,221,139,32,85,128,56,150,25,134,214,106,38,54,40,204,135,218,227,204,130,115,52,224,58,97,148,36,160,247,15,39,128,94,132,35,176,216,160,175,0,230,90,161,14,67,15,104,144,190,65,154,143,122,58,110,97,141,81,82,117,113,35,102,37,243,253,253,82,113,167,113,29,95,67,213,106,9,254,45,68,75,3,237,72,143,52,221,126,32,249,48,199,251,59,74,180,124,131,19,217,233,22,84,103,16,132,154,205,224,86,173,230,102,5,171,176,221,23,162,226,175,74,167,101,208,98,139,235,238,162,167,97,159,45,134,81,34,21,168,183,14,153,146,167,243,231,14,142,133,140,164,121,45,90,101,137,74,124,247,18,61,208,246,37,229,156,4,104,33,107,255,132,21,20,208,236,124,148,49,191,147,131,45,110,223,229,51,63,138,85,200,149,235,199,74,225,148,222,84,212,124,57,151,205,253,126,6,94,62,246,132,17,168,217,23,4,22,190,203,19,249,68,6,243,123,49,68,228,169,216,185,253,42,245,254,117,130,190,204,148,43,71,237,219,123,135,208,40,194,68,128,63,197,9,25,200,242,161,1,131,192,129,66,86,136,175,62,195,189,110,144,80,46,204,129,202,17,131,144,91,184,116,171,238,251,8,53,208,202,58,219,61,111,49,229,170,218,181,169,247,1,86,11,158,104,248,242,240,140,54,183,167,233,232,45,235,32,38,238,82,136,157,236,236,203,34,73,176,189,118,146,100,16,143,105,95,184,80,99,105,159,94,154,83,18,252,45,220,228,89,20,156,45,54,210,126,123,193,243,76,175,6,197,65,96,251,81,238,209,0,124,59,89,25,98,226,241,73,138,126,64,60,113,216,232,142,212,97,128,236,103,111,148,43,105,12,123,33,40,86,189,102,29,137,107,247,210,135,234,212,133,248,254,30,221,38,235,191,211,230,54,105,207,95,84,255,212,100,213,22,151,107,102,24,69,114,21,100,71,69,162,216,166,163,233,22,14,253,48,188,90,206,154,250,111,248,1,75,37,36,203,161,97,222,152,102,118,197,54,251,219,32,212,198,63,74,135,131,141,82,205,10,133,71,0,228,199,58,50,255,59,178,176,117,217,219,198,21,57,95,21,129,21,251,209,116,29,8,178,219,239,215,252,166,86,118,113,81,10,0,153,165,59,45,117,16,9,90,102,59,57,84,37,56,87,109,52,207,84,51,82,251,129,128,211,211,221,245,58,181,205,214,80,40,65,254,66,30,180,83,70,197,43,201,179,132,0,178,41,172,30,187,129,183,25,163,227,199,125,152,137,164,48,103,228,51,155,195,251,168,144,210,78,180,238,180,96,98,60,46,159,181,52,190,196,49,133,82,7,108,168,210,168,59,93,87,163,55,93,213,132,232,33,62,176,65,4,214,38,87,200,179,179,100,188,116,136,203,142,28,124,71,115,127,150,150,53,155,28,206,33,175,9,180,129,167,160,185,126,162,154,44,113,68,139,107,169,169,232,2,98,113,43,148,88,134,210,94,198,72,180,166,240,67,0,95,31,169,15,94,49,243,28,185,94,171,82,221,111,1,140,113,138,98,80,97,108,178,239,253,10,146,230,185,204,219,48,232,6,154,108,108,86,57,165,194,1,73,20,107,231,82,20,89,62,13,14,167,61,231,135,218,211,251,6,180,20,109,152,50,42,85,228,148,204,227,71,232,138,31,226,95,89,203,133,184,57,205,165,155,246,141,62,162,28,64,36,53,203,128,85,98,199,132,4,66,33,118,201,75,210,153,165,9,70,67,215,99,179,224,148,80,23,70,240,234,174,16,164,26,76,243,136,218,253,137,169,164,20,131,211,170,213,67,255,70,147,253,27,24,53,15,158,43,216,163,139,97,39,180,145,170,40,166,104,228,162,208,80,128,34,181,165,60,195,132,99,44,111,185,41,237,229,200,45,25,227,38,188,217,226,241,17,147,128,252,214,211,61,200,78,229,42,180,68,159,30,246,61,29,189,169,204,168,8,65,55,10,128,104,144,162,159,237,231,82,243,165,152,225,145,207,45,120,239,23,234,149,110,3,12,74,146,247,144,16,229,197,51,29,221,22,170,164,249,132,177,115,10,241,70,71,4,126,86,94,150,75,75,28,15,218,165,168,60,165,14,219,191,200,91,205,105,114,214,212,92,2,101,253,213,12,240,90,97,56,157,39,8,108,25,61,226,25,165,3,253,105,58,105,111,123,245,223,160,218,7,237,122,252,154,84,156,12,206,67,98,64,140,39,141,196,116,88,32,193,247,34,175,93,61,168,96,247,219,228,27,134,220,39,74,225,239,179,38,209,206,40,172,8,185,18,216,132,196,18,5,63,200,15,100,156,154,237,21,211,177,85,122,102,106,172,16,74,104,232,121,205,249,9,248,106,83,219,41,12,254,96,99,127,71,103,95,227,29,229,12,249,252,69,171,221,109,35,56,18,218,91,235,87,238,62,8,129,187,63,151,108,133,17,208,37,97,79,255,51,213,3,188,98,152,162,119,216,30,88,2,182,232,68,221,179,193,208,17,62,133,107,110,14,111,163,77,107,104,93,140,107,174,1,141,108,63,149,19,43,73,36,16,4,35,129,165,234,130,47,196,167,186,105,110,61,50,204,147,168,166,76,248,22,47,13,240,82,135,160,28,171,219,128,57,12,123,221,117,204,213,142,166,245,81,129,28,201,182,239,2,231,165,161,32,238,207,247,43,167,53,131,175,178,195,96,44,110,122,103,213,165,200,199,104,97,27,104,50,66,234,83,62,241,200,12,159,234,255,110,170,52,87,47,122,76,227,67,184,205,87,29,137,135,46,35,76,205,53,171,150,215,42,23,55,195,29,109,80,86,249,134,253,18,58,141,213,211,148,13,165,15,22,75,145,220,219,51,19,17,40,232,113,147,196,189,64,19,12,41,234,238,65,175,42,236,170,167,224,119,116,31,125,50,24,139,181,100,143,225,145,99,89,231,183,70,139,172,148,32,243,131,178,233,104,7,234,208,248,59,251,88,88,126,180,173,182,83,62,70,118,51,229,18,186,22,162,210,137,74,187,148,170,165,230,103,142,221,165,7,89,231,220,141,200,91,167,139,84,203,42,109,180,118,101,91,152,229,199,243,124,111,84,78,228,50,207,28,134,128,180,217,91,253,150,168,133,133,28,28,54,152,35,154,67,226,140,21,6,202,20,163,177,135,138,58,252,128,207,155,194,146,191,87,22,155,24,226,113,189,59,7,205,63,40,10,64,78,204,155,193,18,184,198,221,227,186,30,193,127,254,29,97,71,84,241,174,148,136,70,251,164,204,58,107,103,254,80,186,172,226,150,198,8,137,248,167,154,253,146,111,1,9,59,56,15,98,171,137,151,5,223,5,169,141,180,94,122,6,191,37,143,5,135,117,214,61,133,83,131,225,245,237,99,10,120,231,68,45,194,116,132,179,65,180,179,49,217,192,109,77,75,239,26,36,167,87,151,189,78,192,17,151,12,208,205,248,95,63,218,194,26,204,72,48,83,84,106,176,161,193,86,250,105,223,110,147,242,75,34,131,200,108,171,22,163,64,220,237,244,112,199,207,15,89,172,60,191,194,177,57,71,77,166,203,55,64,188,166,165,152,15,150,67,150,76,242,93,84,228,12,180,84,85,157,249,162,138,44,211,229,108,232,49,19,173,50,24,58,150,102,174,175,134,201,251,8,26,115,130,143,149,66,187,10,229,136,42,19,228,242,228,161,198,190,88,129,193,22,97,75,184,50,190,84,148,117,148,133,50,219,129,178,15,94,251,162,166,121,193,72,240,235,149,18,199,102,58,164,8,59,24,230,30,29,157,251,83,35,210,87,99,214,39,73,23,79,194,135,68,203,11,86,82,30,31,151,3,251,213,25,111,21,58,135,86,228,133,161,79,228,42,158,232,211,31,43,162,29,222,144,93,149,191,131,118,227,194,70,119,37,13,151,122,212,154,23,116,14,255,183,169,192,187,73,232,62,17,139,88,11,219,254,198,97,46,176,130,194,188,202,78,124,225,139,146,231,246,127,123,106,121,135,146,96,143,68,116,235,174,245,74,210,23,186,246,149,160,137,223,20,142,242,237,124,186,185,176,33,140,79,212,100,252,199,138,79,214,94,216,201,217,239,10,3,133,86,225,53,33,188,8,220,71,78,17,224,52,131,120,136,117,57,21,8,1,229,177,218,178,158,20,221,207,119,140,194,159,104,243,189,38,136,154,98,201,151,20,232,179,84,111,170,219,23,252,144,241,125,30,208,185,211,240,51,144,111,97,232,154,221,107,132,14,167,190,62,82,238,161,189,49,107,13,10,37,106,110,36,47,88,244,224,88,83,143,32,194,0,234,182,234,66,160,99,207,185,194,21,210,227,165,220,110,190,169,77,71,10,163,38,59,147,132,180,16,69,162,160,53,207,23,198,68,169,239,81,184,203,228,147,122,183,88,75,254,96,57,55,138,128,241,74,184,224,201,219,133,162,42,188,22,243,36,107,116,34,42,151,164,119,117,33,42,33,121,4,204,134,170,113,205,39,236,200,253,182,22,1,110,97,196,194,219,128,193,5,126,34,115,44,29,57,93,120,33,192,177,94,30,181,145,41,68,217,196,160,193,104,17,75,222,157,10,66,26,90,93,204,224,247,227,160,50,155,68,245,151,249,225,76,202,30,58,210,158,214,6,196,179,106,170,9,145,85,102,225,221,191,216,126,210,14,247,52,67,95,197,208,175,87,173,218,240,222,24,137,218,138,93,211,202,187,165,134,59,168,134,173,187,219,120,113,80,69,252,134,56,80,135,118,176,107,246,29,75,174,66,175,235,153,56,89,198,186,90,154,240,130,176,108,19,125,201,235,21,66,60,113,39,50,102,102,114,166,13,7,64,74,120,88,160,221,220,170,244,245,71,229,50,90,4,24,188,101,144,160,2,200,4,222,167,204,190,45,101,176,22,183,125,252,173,164,207,87,128,99,172,106,34,30,67,250,219,115,3,139,38,249,255,59,164,119,135,29,90,76,187,223,194,89,135,132,155,161,230,209,52,231,7,140,228,171,236,65,175,162,250,247,245,40,89,32,242,213,249,111,198,209,200,187,183,143,145,94,224,121,189,176,166,255,216,35,113,124,106,188,26,185,226,0,243,179,146,33,56,172,51,72,110,214,116,157,203,152,145,246,254,201,67,207,187,246,9,52,244,90,126,197,142,29,13,240,208,235,145,123,171,11,110,0,58,148,78,58,9,175,79,29,228,201,96,39,18,149,134,126,146,129,190,44,21,187,196,222,19,182,96,227,105,24,173,233,94,245,230,76,84,3,136,135,185,137,229,251,89,160,144,248,188,238,26,125,79,138,112,253,141,250,182,132,26,103,69,205,126,105,109,251,15,88,170,158,190,195,109,32,125,182,163,201,196,125,77,61,237,129,119,171,203,222,189,159,152,193,76,141,235,113,136,122,148,254,38,27,58,119,15,57,132,40,164,118,123,77,13,169,4,56,154,255,209,64,171,212,26,7,211,229,249,135,176,21,207,224,168,174,216,89,74,198,15,182,173,158,172,28,125,66,249,128,120,197,79,27,231,214,121,60,126,107,171,119,137,251,90,55,35,167,114,55,23,21,175,29,82,249,76,251,205,84,31,9,172,70,121,114,72,24,165,95,90,199,103,166,162,91,181,227,196,121,191,24,235,12,50,218,190,3,173,78,14,209,170,9,178,163,163,91,136,10,228,247,179,241,239,92,16,61,131,35,88,120,88,94,25,121,60,117,148,222,155,140,95,29,116,209,106,215,137,54,182,97,199,230,175,76,116,254,135,61,213,51,190,57,116,47,57,53,183,182,46,60,171,228,164,87,165,158,118,23,33,30,233,135,162,4,80,32,50,34,214,116,178,9,152,186,164,233,33,114,29,178,194,83,220,198,35,238,8,128,12,141,23,113,221,137,21,100,221,226,149,132,101,152,226,14,208,90,117,95,140,209,119,149,133,25,129,187,186,212,106,168,111,140,130,148,49,156,216,146,150,179,137,128,87,226,93,15,227,73,184,158,231,2,236,92,4,203,40,160,14,197,38,254,65,8,44,81,63,163,143,107,234,127,16,251,1,251,252,12,42,243,31,11,193,250,30,201,229,105,18,56,202,212,185,216,27,134,18,122,217,12,177,114,87,204,160,55,57,216,145,206,131,31,216,82,230,222,159,34,196,6,228,193,237,150,174,37,97,219,112,137,197,157,177,0,175,153,253,240,149,71,36,98,250,144,241,148,193,57,126,193,245,117,109,238,104,38,38,196,241,55,127,12,170,96,210,130,160,227,2,208,147,167,233,253,84,216,180,251,97,219,89,173,246,88,140,67,234,111,14,84,32,16,252,40,20,41,94,10,155,149,25,160,162,249,121,131,76,179,69,204,221,253,229,131,181,210,235,108,95,208,136,202,125,12,103,45,175,120,191,196,113,66,240,47,150,241,28,85,152,134,226,179,120,31,166,90,219,105,254,107,112,129,146,79,188,250,143,94,119,84,24,43,203,236,116,247,66,11,27,12,57,95,27,159,121,20,82,134,242,211,48,218,173,42,56,164,153,213,82,166,128,47,57,66,121,212,201,216,84,218,7,160,223,214,23,63,186,87,164,43,14,145,44,76,92,96,110,144,197,156,38,111,77,78,73,36,206,61,209,241,64,58,33,166,55,19,42,237,39,62,100,103,102,130,149,129,214,85,140,176,111,7,13,244,112,235,71,143,230,144,6,238,76,250,66,106,190,110,98,162,247,69,237,109,129,119,85,60,62,223,13,238,155,72,171,62,56,61,51,160,189,82,104,138,57,188,102,47,245,247,206,69,100,58,199,161,128,81,148,23,101,215,247,163,1,214,11,109,110,155,193,78,246,72,232,10,41,239,48,8,62,158,116,3,117,85,6,104,236,146,230,59,37,246,68,176,249,238,77,114,14,98,75,106,224,39,28,2,236,72,60,55,196,113,157,75,109,4,13,59,185,4,223,83,32,8,199,49,253,158,32,83,37,79,178,231,255,89,188,81,1,138,129,31,116,223,27,55,78,113,92,85,54,148,187,223,213,104,4,175,45,121,58,160,191,137,241,169,254,162,16,28,42,71,97,26,122,48,106,80,156,207,43,16,207,254,103,112,21,168,23,237,21,44,188,172,6,112,151,128,124,193,207,73,4,95,50,146,57,220,161,144,61,249,56,162,1,180,53,133,109,186,222,226,32,169,13,136,190,211,224,229,198,213,134,168,242,88,29,38,163,211,174,17,97,212,130,141,30,97,190,112,22,248,128,121,156,254,209,115,204,222,141,155,206,231,213,133,250,204,127,71,48,149,155,219,172,41,125,103,138,227,139,3,93,11,73,225,137,159,74,251,46,147,195,81,246,2,239,84,192,49,71,11,127,224,245,154,8,73,101,26,160,221,174,156,180,208,247,114,21,105,94,232,153,185,232,90,142,228,38,4,217,230,224,132,88,205,123,4,179,118,215,199,30,4,22,162,207,205,216,43,233,176,223,11,201,148,207,29,124,227,167,161,143,125,225,6,83,40,48,134,139,89,1,153,220,32,181,142,55,246,65,25,203,243,234,211,8,35,42,119,63,67,11,226,84,32,166,109,119,93,121,220,197,12,168,182,66,214,166,46,187,102,147,114,91,40,131,32,52,178,14,26,165,30,170,32,61,41,176,12,184,8,12,99,120,206,188,51,205,216,237,210,239,148,223,50,180,201,27,197,126,77,115,77,167,239,74,195,102,124,147,62,145,74,133,30,11,86,224,2,33,41,214,26,176,183,0,118,46,166,69,81,240,29,194,9,245,192,1,13,35,146,149,109,138,137,214,129,236,204,236,230,245,68,226,47,135,158,113,9,144,91,58,108,229,184,96,7,70,168,105,153,7,42,99,42,90,189,37,79,83,28,43,89,52,12,105,242,164,225,9,57,30,39,134,15,52,122,10,183,91,106,64,212,81,194,162,167,254,30,102,213,25,207,123,85,230,204,38,99,121,132,203,136,146,135,225,34,88,136,45,95,131,212,48,104,47,187,195,97,168,59,227,192,57,139,31,9,35,40,2,38,60,179,12,110,217,205,170,50,52,190,103,146,188,134,19,64,58,210,99,90,247,131,65,63,54,85,238,213,31,67,34,79,6,94,174,43,240,26,29,151,204,124,21,22,75,9,38,158,254,96,97,12,42,164,203,67,154,111,199,139,8,178,193,146,203,121,17,159,74,32,199,119,117,242,147,200,85,20,139,81,41,126,179,251,169,60,118,58,254,174,219,197,122,91,254,40,183,68,114,198,170,143,113,42,162,114,210,121,121,191,194,134,90,161,61,240,239,203,5,194,170,210,55,41,127,197,42,39,24,174,213,7,46,17,110,64,213,101,151,58,162,134,4,52,86,77,182,52,198,158,185,73,94,225,124,182,231,211,218,187,185,99,135,40,6,210,52,143,224,183,191,82,8,108,206,111,198,252,5,73,201,86,45,217,87,220,3,35,30,110,56,33,171,189,133,95,239,211,75,158,72,247,182,41,131,224,75,246,29,255,165,19,233,76,234,198,18,184,121,158,78,42,234,28,112,60,218,92,132,179,1,129,112,147,17,95,183,46,130,232,105,246,64,228,87,76,237,229,83,211,78,48,90,244,43,114,176,208,147,234,104,87,248,163,213,99,162,129,105,222,126,208,117,144,76,50,93,236,230,159,218,180,138,116,140,138,221,140,245,185,84,211,74,127,13,91,133,58,89,62,138,170,176,125,109,12,153,220,118,57,65,151,34,225,9,103,192,70,47,248,223,151,105,219,205,80,234,250,232,69,98,98,180,152,111,194,229,240,75,98,27,170,49,130,176,246,85,71,172,168,243,94,19,193,15,57,227,203,202,67,212,200,246,153,63,13,225,79,236,125,119,254,216,159,0,144,120,203,35,8,228,184,41,220,248,148,177,152,254,172,196,73,75,150,172,254,74,228,36,144,234,41,20,180,41,231,143,201,247,58,109,133,141,123,154,250,159,84,252,100,53,117,28,55,203,88,72,118,205,13,18,56,49,212,119,122,123,200,172,227,246,196,100,7,125,230,170,8,124,218,13,199,117,181,116,143,79,109,27,177,84,121,102,185,173,70,28,164,88,231,28,236,62,101,254,44,113,119,16,91,61,35,201,91,216,8,74,85,91,221,204,194,254,25,114,40,62,211,120,117,84,71,5,71,59,252,119,100,214,198,251,53,60,196,6,150,3,174,96,57,208,253,124,118,193,214,69,92,179,212,123,198,29,28,141,189,134,206,58,128,102,124,187,42,177,89,220,20,163,24,77,153,222,122,179,105,15,21,105,12,25,47,33,245,111,3,125,135,6,234,77,116,225,174,198,202,217,38,244,99,123,101,202,56,159,40,28,189,201,42,52,150,74,58,211,109,242,217,200,64,48,110,19,158,25,11,127,93,151,159,12,130,155,121,151,203,49,217,255,198,166,33,27,231,220,88,114,244,123,38,129,149,90,181,151,192,164,203,135,19,67,119,219,85,38,46,21,202,143,159,81,46,24,110,141,141,242,247,225,41,249,151,128,185,22,85,90,4,225,81,122,213,168,252,123,214,203,110,87,28,58,96,149,216,212,249,237,100,192,67,141,254,188,40,135,145,185,51,70,117,65,138,26,35,8,159,249,14,202,137,166,135,212,205,210,118,185,207,116,60,104,119,127,180,143,121,234,222,59,21,96,149,157,23,126,98,217,241,119,242,71,195,169,42,218,182,9,173,93,223,236,84,110,133,11,51,83,100,96,59,143,178,188,19,51,120,200,53,217,93,31,133,35,135,158,176,121,135,206,248,39,47,215,143,156,70,242,19,228,26,115,243,142,164,151,52,185,35,80,252,121,243,27,223,222,107,185,125,81,224,133,26,69,61,5,88,89,68,197,237,253,45,223,174,202,110,141,170,1,36,130,109,125,119,13,154,108,234,60,36,72,75,119,96,84,63,30,38,181,253,160,76,226,169,1,234,20,236,36,38,196,67,231,10,117,107,94,55,220,139,117,111,113,81,39,75,247,148,98,204,158,14,50,17,82,145,109,104,71,209,177,161,252,241,156,216,142,216,28,47,27,136,70,150,119,219,200,219,21,250,137,13,231,239,175,114,131,199,246,157,242,59,54,154,113,87,215,33,129,230,52,10,119,225,111,31,22,138,102,57,32,250,85,12,4,129,107,151,223,69,184,112,236,111,100,21,199,161,219,57,7,19,136,179,193,135,89,1,245,227,186,117,32,205,86,45,11,57,61,89,59,54,92,53,254,243,120,167,224,14,129,101,11,51,172,91,231,226,102,100,110,8,214,36,183,76,172,127,226,225,26,188,186,237,74,28,43,142,34,22,222,44,138,132,51,236,26,25,207,241,228,44,145,174,20,3,104,168,154,62,134,76,39,224,41,184,29,93,187,241,254,238,12,83,174,43,31,138,84,193,196,103,194,126,144,103,19,193,54,138,86,93,237,105,31,41,211,125,96,165,199,229,95,218,238,12,219,253,55,124,223,207,184,28,118,40,39,73,188,198,67,63,153,175,36,23,36,120,73,24,118,116,246,21,176,203,59,134,207,37,179,160,10,205,199,92,86,206,43,98,13,61,141,138,244,110,108,101,239,219,29,247,193,198,83,78,230,5,72,95,146,45,57,107,173,47,70,235,245,145,105,254,132,91,28,77,226,51,12,160,102,149,53,62,132,173,203,179,134,140,87,150,111,5,171,127,25,54,99,209,131,197,57,81,6,121,223,106,158,225,32,68,220,14,208,78,48,14,87,138,197,45,78,23,141,122,94,234,66,215,81,61,122,25,90,192,244,209,67,213,250,100,31,211,232,228,87,199,61,196,185,183,146,98,242,187,144,122,54,59,128,93,253,34,239,57,69,58,30,185,75,129,10,252,104,203,72,72,148,131,226,45,191,238,135,207,80,97,220,90,47,51,118,42,103,22,36,188,239,237,72,167,219,132,134,214,92,146,76,134,72,198,37,58,247,248,21,61,73,47,237,133,201,242,91,23,157,77,166,95,12,6,100,213,51,50,161,120,187,17,156,189,140,11,31,83,209,215,136,144,244,114,131,199,0,3,161,139,61,117,141,68,33,27,108,176,52,149,177,139,210,39,117,140,100,167,139,227,23,122,220,95,246,247,22,141,245,255,215,141,114,29,77,103,221,157,130,177,117,119,151,37,190,33,36,62,202,172,3,221,188,157,169,13,213,136,174,38,254,21,221,176,42,21,223,112,82,9,6,233,5,61,38,250,101,103,17,50,145,128,24,241};

// The ranking tile of 128x128 pixels.
// Each pixel contains an optimized 8d key used to scramble the sequence.
// The keys are optimized for all the powers of two spp below 32in 8d.
static const int rankingTile[128*128*8] = {9,9,26,26,21,21,11,11,10,10,20,20,9,9,21,21,26,26,14,14,9,9,7,7,12,12,23,23,9,9,11,11,27,27,7,7,29,29,9,9,30,30,4,4,6,6,0,0,8,8,3,3,13,13,12,12,1,1,4,4,1,1,15,15,9,9,8,8,2,2,13,13,7,7,22,22,28,28,19,19,25,25,20,20,31,31,4,4,9,9,21,21,3,3,7,7,31,31,6,6,22,22,2,2,2,2,7,7,31,31,5,5,7,7,26,26,18,18,5,5,10,10,10,10,14,14,5,5,22,22,17,17,1,1,24,24,11,11,16,16,30,30,16,16,20,20,0,0,21,21,16,16,22,22,7,7,12,12,6,6,20,20,11,11,5,5,31,31,0,0,9,9,20,20,25,25,26,26,18,18,26,26,17,17,28,28,13,13,27,27,5,5,1,1,15,15,17,17,19,19,4,4,30,30,10,10,15,15,1,1,1,1,7,7,8,8,13,13,6,6,0,0,13,13,23,23,18,18,5,5,0,0,8,8,24,24,3,3,2,2,16,16,4,4,28,28,2,2,13,13,3,3,15,15,14,14,7,7,5,5,7,7,24,24,9,9,31,31,20,20,19,19,3,3,5,5,27,27,28,28,0,0,11,11,11,11,4,4,16,16,15,15,20,20,10,10,10,10,15,15,23,23,4,4,12,12,25,25,9,9,4,4,28,28,22,22,24,24,1,1,22,22,15,15,11,11,27,27,14,14,21,21,8,8,4,4,8,8,8,8,3,3,0,0,0,0,12,12,27,27,2,2,13,13,21,21,23,23,16,16,24,24,9,9,7,7,8,8,2,2,10,10,8,8,5,5,6,6,12,12,27,27,3,3,7,7,22,22,10,10,1,1,20,20,12,12,27,27,14,14,14,14,3,3,25,25,11,11,13,13,3,3,10,10,24,24,22,22,26,26,14,14,18,18,7,7,25,25,4,4,5,5,24,24,23,23,17,17,20,20,25,25,0,0,9,9,23,23,26,26,11,11,5,5,17,17,21,21,28,28,26,26,14,14,2,2,2,2,18,18,15,15,0,0,3,3,28,28,30,30,8,8,6,6,13,13,4,4,10,10,9,9,24,24,17,17,6,6,16,16,8,8,4,4,27,27,7,7,22,22,20,20,7,7,23,23,2,2,25,25,26,26,2,2,2,2,27,27,4,4,1,1,6,6,6,6,26,26,31,31,20,20,27,27,12,12,13,13,11,11,8,8,26,26,4,4,2,2,20,20,10,10,18,18,31,31,4,4,10,10,6,6,12,12,16,16,3,3,12,12,29,29,19,19,2,2,10,10,6,6,15,15,14,14,10,10,16,16,30,30,9,9,2,2,6,6,29,29,17,17,3,3,22,22,10,10,18,18,5,5,28,28,30,30,20,20,0,0,1,1,8,8,14,14,25,25,10,10,0,0,8,8,8,8,9,9,0,0,21,21,24,24,12,12,9,9,11,11,3,3,2,2,15,15,3,3,9,9,29,29,30,30,20,20,21,21,19,19,26,26,28,28,14,14,9,9,6,6,26,26,28,28,22,22,18,18,21,21,5,5,26,26,18,18,21,21,29,29,24,24,29,29,11,11,24,24,2,2,2,2,2,2,5,5,23,23,30,30,23,23,28,28,26,26,0,0,28,28,16,16,27,27,19,19,12,12,23,23,0,0,3,3,16,16,11,11,12,12,30,30,10,10,28,28,8,8,1,1,4,4,0,0,7,7,14,14,3,3,22,22,30,30,10,10,7,7,6,6,20,20,23,23,27,27,25,25,20,20,6,6,2,2,16,16,8,8,22,22,28,28,22,22,26,26,30,30,14,14,7,7,7,7,6,6,1,1,28,28,9,9,28,28,11,11,13,13,3,3,9,9,21,21,21,21,23,23,18,18,8,8,17,17,12,12,3,3,19,19,18,18,12,12,3,3,27,27,28,28,4,4,18,18,7,7,4,4,2,2,26,26,16,16,13,13,20,20,17,17,17,17,12,12,28,28,11,11,12,12,17,17,25,25,0,0,7,7,7,7,24,24,17,17,6,6,22,22,16,16,18,18,9,9,15,15,8,8,29,29,14,14,27,27,12,12,11,11,8,8,6,6,11,11,0,0,13,13,8,8,17,17,26,26,27,27,3,3,16,16,7,7,17,17,20,20,31,31,20,20,30,30,25,25,19,19,9,9,23,23,10,10,15,15,2,2,10,10,25,25,30,30,11,11,4,4,21,21,0,0,11,11,20,20,26,26,19,19,13,13,13,13,0,0,12,12,29,29,22,22,5,5,9,9,21,21,25,25,3,3,26,26,16,16,29,29,0,0,2,2,17,17,4,4,26,26,17,17,9,9,18,18,22,22,18,18,24,24,21,21,19,19,31,31,9,9,23,23,26,26,15,15,0,0,29,29,14,14,14,14,0,0,18,18,10,10,18,18,26,26,26,26,16,16,26,26,7,7,0,0,17,17,4,4,26,26,8,8,21,21,21,21,30,30,30,30,30,30,17,17,25,25,5,5,0,0,23,23,8,8,12,12,15,15,15,15,18,18,22,22,18,18,14,14,23,23,30,30,18,18,20,20,2,2,27,27,8,8,17,17,16,16,12,12,24,24,22,22,20,20,4,4,24,24,9,9,27,27,10,10,10,10,13,13,18,18,27,27,28,28,16,16,28,28,1,1,16,16,23,23,23,23,10,10,13,13,15,15,15,15,1,1,11,11,11,11,9,9,30,30,3,3,18,18,3,3,12,12,27,27,17,17,2,2,12,12,28,28,17,17,25,25,25,25,29,29,16,16,22,22,29,29,0,0,12,12,5,5,5,5,9,9,3,3,29,29,6,6,15,15,22,22,23,23,15,15,30,30,2,2,3,3,11,11,28,28,28,28,27,27,4,4,9,9,6,6,18,18,14,14,6,6,4,4,8,8,4,4,6,6,14,14,6,6,23,23,15,15,27,27,1,1,30,30,21,21,26,26,13,13,0,0,12,12,31,31,31,31,29,29,17,17,0,0,3,3,13,13,18,18,10,10,6,6,9,9,6,6,13,13,25,25,1,1,13,13,8,8,8,8,19,19,11,11,13,13,1,1,2,2,23,23,4,4,16,16,10,10,0,0,19,19,15,15,10,10,25,25,24,24,27,27,9,9,4,4,19,19,1,1,3,3,28,28,5,5,14,14,25,25,27,27,21,21,22,22,30,30,29,29,3,3,30,30,27,27,29,29,8,8,11,11,17,17,23,23,23,23,15,15,17,17,28,28,26,26,17,17,10,10,27,27,28,28,3,3,0,0,15,15,23,23,29,29,11,11,1,1,25,25,18,18,16,16,7,7,28,28,3,3,24,24,18,18,0,0,14,14,6,6,7,7,16,16,19,19,6,6,21,21,31,31,5,5,10,10,12,12,3,3,5,5,21,21,15,15,1,1,9,9,18,18,0,0,22,22,3,3,0,0,23,23,18,18,7,7,24,24,18,18,5,5,22,22,31,31,20,20,21,21,2,2,28,28,15,15,20,20,11,11,7,7,22,22,1,1,29,29,29,29,1,1,28,28,22,22,14,14,8,8,6,6,21,21,22,22,9,9,15,15,11,11,8,8,13,13,30,30,18,18,14,14,30,30,2,2,7,7,11,11,5,5,27,27,20,20,31,31,27,27,23,23,31,31,5,5,15,15,25,25,25,25,25,25,11,11,18,18,7,7,0,0,9,9,6,6,25,25,16,16,3,3,19,19,22,22,25,25,31,31,7,7,1,1,28,28,8,8,25,25,14,14,23,23,24,24,10,10,7,7,14,14,23,23,3,3,19,19,17,17,2,2,0,0,6,6,5,5,24,24,8,8,26,26,12,12,23,23,4,4,23,23,15,15,10,10,8,8,17,17,9,9,12,12,12,12,14,14,1,1,0,0,12,12,2,2,20,20,5,5,18,18,22,22,29,29,24,24,14,14,24,24,17,17,30,30,21,21,24,24,13,13,25,25,0,0,12,12,25,25,14,14,9,9,7,7,11,11,17,17,17,17,2,2,10,10,28,28,1,1,1,1,6,6,8,8,22,22,10,10,26,26,10,10,29,29,25,25,28,28,0,0,7,7,10,10,0,0,1,1,7,7,28,28,14,14,31,31,13,13,6,6,1,1,3,3,29,29,4,4,3,3,5,5,17,17,20,20,6,6,24,24,24,24,16,16,22,22,15,15,27,27,12,12,26,26,8,8,17,17,24,24,18,18,15,15,7,7,12,12,13,13,19,19,28,28,26,26,14,14,16,16,0,0,18,18,1,1,1,1,4,4,1,1,19,19,27,27,18,18,25,25,8,8,31,31,19,19,8,8,13,13,12,12,5,5,24,24,17,17,19,19,4,4,3,3,21,21,5,5,17,17,6,6,6,6,3,3,19,19,13,13,17,17,18,18,8,8,12,12,4,4,26,26,27,27,25,25,20,20,0,0,14,14,18,18,4,4,10,10,6,6,8,8,31,31,12,12,4,4,13,13,0,0,25,25,24,24,31,31,20,20,11,11,5,5,6,6,8,8,3,3,26,26,30,30,11,11,0,0,1,1,15,15,23,23,27,27,20,20,19,19,4,4,3,3,14,14,2,2,12,12,8,8,6,6,11,11,15,15,1,1,22,22,18,18,7,7,15,15,18,18,20,20,4,4,19,19,27,27,26,26,18,18,3,3,16,16,11,11,7,7,6,6,0,0,9,9,4,4,24,24,15,15,26,26,10,10,6,6,2,2,26,26,26,26,29,29,26,26,12,12,5,5,19,19,26,26,9,9,10,10,18,18,13,13,19,19,17,17,2,2,13,13,31,31,25,25,3,3,20,20,20,20,9,9,22,22,2,2,5,5,22,22,25,25,18,18,16,16,28,28,6,6,18,18,17,17,30,30,11,11,28,28,27,27,10,10,29,29,9,9,9,9,0,0,30,30,0,0,23,23,26,26,16,16,28,28,28,28,5,5,12,12,12,12,14,14,29,29,8,8,3,3,10,10,7,7,4,4,19,19,11,11,25,25,28,28,20,20,29,29,20,20,27,27,28,28,17,17,3,3,4,4,4,4,15,15,15,15,13,13,0,0,4,4,30,30,1,1,0,0,29,29,8,8,30,30,19,19,2,2,26,26,26,26,13,13,3,3,18,18,11,11,26,26,16,16,24,24,1,1,2,2,3,3,17,17,7,7,15,15,6,6,26,26,24,24,17,17,21,21,25,25,6,6,9,9,2,2,3,3,31,31,11,11,10,10,14,14,21,21,18,18,31,31,3,3,2,2,24,24,19,19,25,25,10,10,10,10,9,9,16,16,24,24,0,0,26,26,25,25,5,5,9,9,17,17,2,2,22,22,1,1,20,20,24,24,31,31,25,25,28,28,26,26,17,17,8,8,30,30,5,5,28,28,26,26,1,1,27,27,31,31,16,16,2,2,19,19,15,15,3,3,14,14,30,30,18,18,11,11,28,28,4,4,6,6,23,23,2,2,18,18,1,1,23,23,29,29,27,27,12,12,2,2,4,4,13,13,4,4,10,10,10,10,8,8,9,9,0,0,0,0,2,2,11,11,8,8,12,12,15,15,18,18,4,4,7,7,8,8,31,31,10,10,19,19,16,16,24,24,13,13,27,27,23,23,23,23,27,27,0,0,29,29,3,3,26,26,28,28,4,4,2,2,11,11,8,8,9,9,12,12,31,31,15,15,31,31,9,9,17,17,23,23,3,3,22,22,10,10,5,5,6,6,28,28,27,27,25,25,6,6,11,11,27,27,4,4,4,4,25,25,24,24,6,6,4,4,17,17,29,29,6,6,29,29,5,5,7,7,16,16,17,17,26,26,11,11,23,23,6,6,17,17,13,13,11,11,21,21,5,5,2,2,24,24,16,16,14,14,0,0,25,25,19,19,22,22,27,27,6,6,6,6,16,16,19,19,25,25,14,14,18,18,27,27,18,18,18,18,21,21,28,28,11,11,8,8,7,7,26,26,28,28,24,24,12,12,1,1,9,9,21,21,10,10,2,2,9,9,3,3,26,26,21,21,25,25,22,22,26,26,1,1,3,3,18,18,24,24,26,26,9,9,3,3,7,7,20,20,13,13,26,26,14,14,17,17,21,21,16,16,9,9,11,11,16,16,13,13,13,13,25,25,1,1,21,21,3,3,3,3,6,6,2,2,28,28,27,27,14,14,7,7,19,19,8,8,11,11,20,20,5,5,2,2,10,10,31,31,4,4,13,13,13,13,13,13,9,9,20,20,1,1,22,22,8,8,9,9,26,26,20,20,7,7,7,7,6,6,26,26,1,1,2,2,27,27,6,6,29,29,16,16,1,1,18,18,13,13,2,2,0,0,18,18,23,23,17,17,19,19,28,28,24,24,22,22,22,22,14,14,29,29,5,5,16,16,1,1,2,2,9,9,23,23,28,28,1,1,2,2,25,25,16,16,4,4,8,8,0,0,19,19,20,20,17,17,30,30,10,10,7,7,0,0,18,18,23,23,24,24,31,31,2,2,3,3,9,9,16,16,2,2,6,6,27,27,7,7,7,7,24,24,31,31,8,8,17,17,21,21,27,27,1,1,9,9,26,26,11,11,6,6,28,28,20,20,26,26,4,4,8,8,10,10,22,22,28,28,3,3,8,8,22,22,6,6,11,11,4,4,10,10,3,3,4,4,31,31,12,12,20,20,10,10,16,16,6,6,3,3,20,20,11,11,28,28,19,19,24,24,19,19,3,3,18,18,5,5,18,18,29,29,1,1,25,25,6,6,1,1,2,2,19,19,12,12,11,11,27,27,29,29,24,24,21,21,12,12,12,12,5,5,30,30,19,19,24,24,12,12,7,7,19,19,23,23,11,11,19,19,4,4,9,9,7,7,23,23,4,4,8,8,22,22,1,1,24,24,1,1,12,12,4,4,19,19,5,5,12,12,21,21,29,29,17,17,9,9,10,10,11,11,1,1,20,20,20,20,11,11,22,22,28,28,14,14,1,1,29,29,0,0,4,4,8,8,2,2,2,2,18,18,16,16,23,23,21,21,19,19,24,24,12,12,20,20,25,25,10,10,10,10,9,9,2,2,26,26,4,4,12,12,0,0,29,29,28,28,7,7,27,27,17,17,29,29,22,22,4,4,20,20,23,23,14,14,16,16,8,8,12,12,18,18,6,6,28,28,7,7,6,6,20,20,31,31,2,2,7,7,10,10,31,31,20,20,18,18,13,13,2,2,23,23,5,5,7,7,10,10,22,22,11,11,11,11,4,4,6,6,31,31,15,15,6,6,2,2,24,24,24,24,15,15,12,12,3,3,9,9,24,24,7,7,31,31,3,3,19,19,4,4,19,19,4,4,18,18,14,14,1,1,0,0,23,23,7,7,2,2,24,24,9,9,2,2,18,18,12,12,27,27,4,4,10,10,15,15,20,20,30,30,8,8,28,28,12,12,4,4,14,14,5,5,25,25,16,16,0,0,30,30,30,30,20,20,29,29,8,8,25,25,30,30,24,24,13,13,19,19,7,7,17,17,0,0,22,22,1,1,0,0,17,17,20,20,24,24,3,3,21,21,8,8,2,2,11,11,31,31,29,29,11,11,23,23,1,1,8,8,22,22,8,8,2,2,2,2,31,31,24,24,8,8,24,24,5,5,20,20,0,0,7,7,28,28,0,0,25,25,9,9,11,11,18,18,3,3,7,7,24,24,20,20,10,10,2,2,9,9,23,23,10,10,2,2,15,15,12,12,11,11,12,12,26,26,3,3,8,8,11,11,6,6,8,8,5,5,22,22,10,10,17,17,4,4,26,26,13,13,20,20,6,6,10,10,19,19,20,20,24,24,26,26,15,15,1,1,0,0,6,6,14,14,28,28,20,20,8,8,10,10,29,29,2,2,13,13,10,10,26,26,18,18,12,12,23,23,10,10,6,6,30,30,10,10,11,11,18,18,30,30,11,11,20,20,29,29,12,12,0,0,11,11,21,21,25,25,14,14,5,5,10,10,16,16,25,25,9,9,12,12,13,13,10,10,11,11,4,4,23,23,7,7,25,25,26,26,14,14,3,3,10,10,15,15,26,26,19,19,12,12,7,7,1,1,19,19,2,2,8,8,3,3,23,23,5,5,12,12,2,2,28,28,3,3,3,3,11,11,18,18,7,7,10,10,11,11,1,1,18,18,10,10,14,14,7,7,6,6,1,1,7,7,16,16,11,11,10,10,9,9,10,10,11,11,2,2,5,5,28,28,6,6,28,28,15,15,14,14,2,2,26,26,4,4,27,27,0,0,10,10,26,26,24,24,3,3,24,24,3,3,22,22,13,13,17,17,20,20,3,3,1,1,16,16,30,30,22,22,5,5,13,13,19,19,22,22,21,21,1,1,26,26,6,6,27,27,14,14,6,6,7,7,24,24,8,8,19,19,17,17,19,19,17,17,0,0,9,9,31,31,20,20,25,25,13,13,10,10,9,9,26,26,22,22,29,29,19,19,7,7,28,28,2,2,27,27,22,22,4,4,24,24,27,27,0,0,15,15,10,10,12,12,13,13,26,26,17,17,1,1,12,12,27,27,19,19,16,16,26,26,30,30,11,11,1,1,16,16,24,24,15,15,24,24,15,15,14,14,17,17,4,4,5,5,20,20,14,14,24,24,14,14,22,22,29,29,0,0,4,4,27,27,19,19,13,13,29,29,23,23,15,15,27,27,11,11,7,7,29,29,23,23,9,9,26,26,31,31,12,12,18,18,8,8,31,31,2,2,30,30,7,7,28,28,7,7,29,29,10,10,13,13,14,14,9,9,16,16,9,9,4,4,17,17,6,6,5,5,2,2,17,17,12,12,26,26,17,17,7,7,27,27,24,24,4,4,27,27,18,18,19,19,14,14,2,2,17,17,20,20,21,21,22,22,6,6,3,3,23,23,12,12,1,1,30,30,4,4,25,25,21,21,24,24,21,21,22,22,21,21,17,17,24,24,29,29,11,11,6,6,19,19,6,6,26,26,4,4,8,8,5,5,27,27,15,15,3,3,3,3,10,10,20,20,14,14,31,31,2,2,6,6,17,17,20,20,6,6,4,4,12,12,3,3,1,1,15,15,11,11,5,5,4,4,20,20,10,10,9,9,23,23,7,7,17,17,22,22,3,3,18,18,17,17,5,5,6,6,26,26,5,5,15,15,0,0,20,20,27,27,15,15,24,24,15,15,19,19,8,8,31,31,18,18,30,30,29,29,23,23,17,17,24,24,7,7,10,10,11,11,31,31,21,21,7,7,14,14,7,7,10,10,28,28,14,14,2,2,9,9,1,1,1,1,13,13,7,7,26,26,24,24,18,18,17,17,4,4,19,19,9,9,4,4,20,20,21,21,16,16,18,18,13,13,24,24,1,1,29,29,19,19,12,12,19,19,14,14,14,14,29,29,2,2,30,30,0,0,5,5,12,12,6,6,26,26,23,23,31,31,0,0,29,29,24,24,29,29,21,21,29,29,14,14,19,19,9,9,1,1,15,15,4,4,27,27,26,26,26,26,1,1,9,9,16,16,12,12,30,30,22,22,16,16,24,24,9,9,18,18,12,12,31,31,2,2,25,25,23,23,12,12,26,26,14,14,17,17,23,23,20,20,19,19,23,23,18,18,6,6,5,5,2,2,28,28,16,16,20,20,8,8,31,31,14,14,11,11,7,7,26,26,24,24,4,4,8,8,11,11,1,1,4,4,8,8,12,12,12,12,16,16,8,8,11,11,2,2,2,2,17,17,15,15,16,16,23,23,25,25,17,17,0,0,25,25,0,0,11,11,25,25,14,14,23,23,13,13,6,6,21,21,5,5,4,4,25,25,2,2,26,26,8,8,15,15,25,25,31,31,27,27,8,8,20,20,19,19,21,21,17,17,8,8,16,16,9,9,30,30,24,24,9,9,19,19,19,19,6,6,2,2,12,12,7,7,1,1,26,26,3,3,30,30,10,10,28,28,12,12,16,16,31,31,24,24,24,24,11,11,12,12,15,15,30,30,10,10,24,24,6,6,0,0,18,18,0,0,4,4,22,22,21,21,10,10,4,4,8,8,21,21,20,20,10,10,13,13,12,12,22,22,29,29,0,0,1,1,24,24,4,4,24,24,13,13,13,13,17,17,28,28,2,2,26,26,12,12,8,8,15,15,11,11,9,9,30,30,19,19,4,4,0,0,28,28,25,25,31,31,9,9,12,12,25,25,24,24,1,1,3,3,5,5,4,4,6,6,4,4,9,9,0,0,28,28,12,12,15,15,12,12,10,10,14,14,5,5,24,24,23,23,27,27,3,3,27,27,30,30,21,21,22,22,24,24,3,3,3,3,23,23,10,10,2,2,4,4,24,24,22,22,30,30,23,23,20,20,27,27,25,25,2,2,12,12,7,7,9,9,15,15,22,22,11,11,30,30,15,15,28,28,12,12,17,17,1,1,27,27,24,24,7,7,5,5,9,9,28,28,19,19,27,27,10,10,14,14,29,29,24,24,25,25,24,24,19,19,21,21,6,6,2,2,23,23,17,17,11,11,31,31,5,5,7,7,9,9,1,1,4,4,7,7,3,3,13,13,28,28,24,24,21,21,26,26,14,14,16,16,20,20,20,20,29,29,13,13,24,24,23,23,2,2,18,18,18,18,11,11,5,5,13,13,2,2,21,21,17,17,10,10,27,27,0,0,4,4,9,9,12,12,4,4,28,28,26,26,22,22,31,31,22,22,26,26,30,30,10,10,0,0,7,7,4,4,1,1,18,18,13,13,11,11,16,16,19,19,4,4,28,28,20,20,27,27,12,12,31,31,3,3,11,11,9,9,31,31,4,4,20,20,25,25,0,0,21,21,13,13,21,21,10,10,27,27,24,24,0,0,7,7,2,2,6,6,19,19,25,25,29,29,23,23,5,5,20,20,22,22,29,29,10,10,12,12,24,24,6,6,24,24,29,29,1,1,18,18,6,6,10,10,22,22,0,0,3,3,5,5,26,26,18,18,6,6,12,12,25,25,13,13,28,28,26,26,26,26,0,0,30,30,29,29,31,31,11,11,24,24,4,4,28,28,13,13,27,27,6,6,18,18,3,3,29,29,26,26,17,17,22,22,3,3,15,15,13,13,16,16,23,23,26,26,12,12,23,23,3,3,3,3,19,19,22,22,1,1,22,22,25,25,8,8,22,22,2,2,29,29,21,21,5,5,9,9,18,18,11,11,30,30,9,9,9,9,14,14,17,17,3,3,20,20,27,27,26,26,9,9,24,24,22,22,25,25,5,5,0,0,24,24,19,19,19,19,12,12,3,3,31,31,11,11,0,0,10,10,12,12,12,12,9,9,31,31,23,23,22,22,20,20,10,10,0,0,26,26,0,0,10,10,4,4,28,28,31,31,18,18,3,3,27,27,11,11,9,9,26,26,16,16,0,0,6,6,7,7,26,26,13,13,19,19,23,23,0,0,23,23,28,28,0,0,21,21,4,4,27,27,27,27,6,6,10,10,8,8,23,23,20,20,31,31,19,19,10,10,28,28,21,21,6,6,14,14,23,23,4,4,4,4,23,23,8,8,19,19,18,18,3,3,24,24,5,5,7,7,28,28,4,4,28,28,24,24,8,8,8,8,13,13,5,5,28,28,31,31,14,14,30,30,12,12,27,27,14,14,6,6,24,24,7,7,2,2,4,4,16,16,1,1,0,0,21,21,6,6,15,15,8,8,25,25,9,9,1,1,24,24,17,17,16,16,28,28,15,15,10,10,21,21,29,29,0,0,4,4,16,16,19,19,2,2,13,13,1,1,25,25,19,19,13,13,16,16,3,3,2,2,22,22,28,28,5,5,8,8,12,12,8,8,10,10,20,20,24,24,21,21,13,13,29,29,13,13,3,3,24,24,5,5,14,14,9,9,15,15,8,8,19,19,26,26,13,13,21,21,2,2,29,29,22,22,11,11,29,29,0,0,10,10,29,29,27,27,15,15,15,15,27,27,1,1,21,21,30,30,1,1,29,29,23,23,15,15,24,24,13,13,14,14,22,22,14,14,0,0,26,26,26,26,15,15,10,10,14,14,2,2,1,1,11,11,22,22,2,2,9,9,11,11,24,24,18,18,27,27,12,12,16,16,22,22,19,19,5,5,31,31,24,24,25,25,29,29,23,23,3,3,31,31,31,31,26,26,14,14,11,11,15,15,7,7,0,0,20,20,7,7,27,27,27,27,12,12,16,16,10,10,21,21,19,19,16,16,11,11,15,15,29,29,24,24,15,15,24,24,7,7,19,19,15,15,5,5,9,9,30,30,19,19,13,13,10,10,7,7,29,29,0,0,26,26,11,11,5,5,25,25,19,19,16,16,3,3,22,22,1,1,13,13,21,21,19,19,24,24,12,12,19,19,30,30,13,13,25,25,15,15,16,16,24,24,24,24,8,8,5,5,16,16,16,16,2,2,25,25,1,1,1,1,27,27,21,21,1,1,1,1,4,4,0,0,14,14,9,9,22,22,11,11,26,26,13,13,29,29,13,13,12,12,28,28,30,30,0,0,24,24,24,24,29,29,13,13,21,21,9,9,1,1,16,16,4,4,23,23,29,29,16,16,25,25,10,10,1,1,13,13,20,20,3,3,19,19,22,22,16,16,3,3,2,2,0,0,17,17,8,8,12,12,30,30,9,9,6,6,18,18,13,13,6,6,19,19,22,22,2,2,5,5,22,22,4,4,4,4,4,4,27,27,21,21,13,13,21,21,16,16,23,23,7,7,19,19,20,20,21,21,1,1,17,17,6,6,2,2,12,12,27,27,26,26,21,21,9,9,2,2,3,3,16,16,27,27,9,9,8,8,3,3,2,2,7,7,20,20,23,23,28,28,14,14,19,19,2,2,13,13,9,9,28,28,23,23,5,5,4,4,14,14,16,16,8,8,30,30,15,15,25,25,24,24,0,0,5,5,2,2,15,15,17,17,30,30,4,4,14,14,29,29,19,19,5,5,20,20,10,10,10,10,23,23,1,1,27,27,4,4,31,31,17,17,26,26,15,15,2,2,17,17,4,4,20,20,28,28,17,17,29,29,27,27,15,15,10,10,27,27,16,16,3,3,0,0,3,3,17,17,5,5,3,3,13,13,5,5,8,8,16,16,17,17,3,3,14,14,17,17,20,20,29,29,9,9,20,20,6,6,3,3,14,14,5,5,22,22,13,13,10,10,22,22,26,26,20,20,7,7,9,9,10,10,14,14,13,13,14,14,0,0,20,20,27,27,25,25,30,30,24,24,24,24,26,26,3,3,18,18,30,30,19,19,17,17,27,27,16,16,29,29,8,8,28,28,8,8,22,22,0,0,20,20,13,13,25,25,17,17,6,6,0,0,1,1,17,17,18,18,15,15,4,4,27,27,21,21,7,7,2,2,1,1,31,31,30,30,13,13,2,2,23,23,27,27,0,0,26,26,26,26,10,10,6,6,15,15,14,14,30,30,22,22,8,8,17,17,30,30,22,22,9,9,17,17,21,21,28,28,8,8,23,23,22,22,29,29,6,6,3,3,11,11,5,5,17,17,13,13,28,28,26,26,25,25,24,24,7,7,16,16,13,13,8,8,7,7,13,13,19,19,10,10,3,3,21,21,17,17,27,27,30,30,0,0,31,31,8,8,29,29,30,30,28,28,8,8,27,27,11,11,26,26,4,4,22,22,15,15,8,8,13,13,17,17,10,10,5,5,1,1,4,4,3,3,5,5,7,7,14,14,9,9,15,15,14,14,29,29,12,12,4,4,10,10,16,16,15,15,27,27,21,21,8,8,26,26,20,20,8,8,10,10,29,29,9,9,1,1,16,16,1,1,18,18,25,25,30,30,6,6,1,1,3,3,16,16,16,16,0,0,4,4,25,25,19,19,16,16,25,25,4,4,24,24,6,6,12,12,4,4,28,28,20,20,9,9,15,15,3,3,27,27,6,6,29,29,16,16,22,22,14,14,1,1,17,17,18,18,1,1,30,30,13,13,4,4,25,25,20,20,8,8,30,30,2,2,1,1,28,28,12,12,20,20,18,18,20,20,24,24,16,16,13,13,17,17,22,22,20,20,9,9,4,4,7,7,5,5,7,7,20,20,12,12,24,24,21,21,8,8,17,17,19,19,7,7,0,0,27,27,1,1,16,16,18,18,4,4,0,0,3,3,15,15,18,18,30,30,14,14,1,1,19,19,29,29,23,23,28,28,5,5,0,0,16,16,20,20,17,17,22,22,13,13,30,30,5,5,2,2,3,3,18,18,4,4,2,2,15,15,2,2,12,12,5,5,24,24,13,13,8,8,30,30,8,8,2,2,23,23,23,23,14,14,27,27,9,9,4,4,7,7,21,21,25,25,1,1,0,0,28,28,2,2,11,11,7,7,13,13,4,4,25,25,15,15,16,16,25,25,3,3,17,17,26,26,23,23,30,30,19,19,28,28,28,28,16,16,31,31,7,7,14,14,23,23,15,15,31,31,19,19,20,20,27,27,17,17,4,4,22,22,24,24,2,2,7,7,22,22,12,12,20,20,11,11,21,21,7,7,20,20,25,25,18,18,3,3,0,0,4,4,2,2,25,25,19,19,27,27,6,6,0,0,27,27,12,12,17,17,4,4,13,13,1,1,6,6,11,11,24,24,13,13,9,9,24,24,28,28,27,27,26,26,29,29,14,14,18,18,4,4,2,2,19,19,7,7,5,5,16,16,31,31,28,28,29,29,15,15,6,6,12,12,5,5,0,0,22,22,28,28,30,30,18,18,31,31,28,28,21,21,16,16,20,20,18,18,6,6,30,30,28,28,21,21,21,21,17,17,25,25,29,29,29,29,18,18,6,6,17,17,15,15,2,2,17,17,0,0,10,10,28,28,24,24,2,2,21,21,11,11,19,19,1,1,28,28,17,17,3,3,19,19,25,25,30,30,23,23,5,5,2,2,31,31,8,8,4,4,28,28,11,11,6,6,28,28,2,2,0,0,0,0,8,8,27,27,23,23,16,16,21,21,7,7,11,11,5,5,24,24,26,26,10,10,0,0,22,22,20,20,19,19,16,16,6,6,11,11,5,5,17,17,15,15,18,18,7,7,12,12,9,9,27,27,0,0,16,16,22,22,13,13,6,6,0,0,29,29,28,28,31,31,11,11,2,2,17,17,30,30,20,20,25,25,6,6,13,13,21,21,28,28,23,23,10,10,17,17,24,24,19,19,7,7,2,2,1,1,7,7,0,0,29,29,10,10,21,21,3,3,12,12,8,8,21,21,13,13,18,18,13,13,22,22,13,13,30,30,19,19,28,28,27,27,26,26,13,13,12,12,3,3,13,13,3,3,8,8,3,3,25,25,20,20,23,23,1,1,1,1,9,9,0,0,25,25,25,25,9,9,26,26,0,0,2,2,10,10,19,19,26,26,7,7,9,9,21,21,22,22,18,18,4,4,27,27,0,0,19,19,23,23,9,9,0,0,0,0,19,19,26,26,28,28,25,25,29,29,4,4,5,5,15,15,23,23,13,13,16,16,0,0,24,24,7,7,4,4,10,10,7,7,14,14,20,20,4,4,9,9,2,2,29,29,13,13,18,18,8,8,31,31,1,1,18,18,8,8,6,6,4,4,5,5,22,22,7,7,26,26,20,20,4,4,15,15,23,23,6,6,7,7,28,28,22,22,30,30,16,16,8,8,29,29,22,22,28,28,27,27,8,8,6,6,2,2,13,13,15,15,28,28,0,0,10,10,17,17,3,3,0,0,10,10,3,3,14,14,4,4,18,18,8,8,5,5,20,20,10,10,30,30,31,31,31,31,20,20,2,2,7,7,1,1,6,6,26,26,24,24,19,19,6,6,10,10,26,26,27,27,23,23,9,9,30,30,18,18,23,23,28,28,20,20,19,19,29,29,19,19,11,11,25,25,0,0,1,1,10,10,16,16,7,7,17,17,11,11,6,6,2,2,2,2,4,4,23,23,10,10,22,22,17,17,4,4,5,5,17,17,13,13,24,24,7,7,16,16,3,3,20,20,29,29,8,8,26,26,9,9,21,21,23,23,18,18,20,20,21,21,11,11,26,26,15,15,1,1,20,20,26,26,1,1,7,7,27,27,22,22,0,0,13,13,10,10,30,30,2,2,21,21,25,25,20,20,2,2,1,1,7,7,5,5,24,24,21,21,11,11,22,22,10,10,13,13,13,13,23,23,26,26,25,25,12,12,24,24,0,0,8,8,3,3,7,7,15,15,1,1,10,10,3,3,11,11,0,0,19,19,13,13,5,5,19,19,0,0,6,6,9,9,9,9,8,8,1,1,18,18,21,21,14,14,5,5,21,21,26,26,26,26,5,5,9,9,15,15,31,31,24,24,29,29,22,22,10,10,19,19,25,25,4,4,6,6,9,9,29,29,4,4,17,17,11,11,27,27,17,17,9,9,30,30,1,1,8,8,22,22,3,3,16,16,26,26,7,7,21,21,0,0,14,14,9,9,0,0,0,0,25,25,21,21,16,16,22,22,17,17,14,14,20,20,23,23,18,18,10,10,21,21,17,17,5,5,5,5,0,0,16,16,18,18,21,21,18,18,2,2,8,8,5,5,21,21,23,23,12,12,10,10,12,12,20,20,14,14,10,10,7,7,25,25,27,27,22,22,25,25,26,26,27,27,8,8,7,7,3,3,12,12,28,28,5,5,11,11,18,18,4,4,20,20,23,23,6,6,4,4,26,26,31,31,0,0,1,1,9,9,17,17,7,7,28,28,5,5,19,19,15,15,26,26,9,9,3,3,3,3,9,9,0,0,20,20,19,19,4,4,7,7,23,23,7,7,19,19,19,19,22,22,6,6,0,0,17,17,18,18,16,16,16,16,0,0,24,24,21,21,18,18,4,4,2,2,24,24,5,5,14,14,19,19,15,15,27,27,15,15,3,3,31,31,16,16,26,26,24,24,15,15,30,30,30,30,0,0,22,22,9,9,10,10,17,17,25,25,25,25,22,22,9,9,10,10,7,7,15,15,14,14,25,25,25,25,12,12,31,31,20,20,5,5,25,25,3,3,2,2,8,8,10,10,13,13,2,2,11,11,16,16,0,0,17,17,30,30,1,1,12,12,17,17,19,19,4,4,7,7,27,27,18,18,2,2,2,2,19,19,30,30,4,4,25,25,26,26,15,15,14,14,1,1,15,15,17,17,22,22,12,12,12,12,11,11,22,22,23,23,21,21,27,27,22,22,2,2,2,2,16,16,16,16,3,3,7,7,27,27,5,5,13,13,0,0,1,1,29,29,11,11,14,14,10,10,22,22,1,1,22,22,11,11,0,0,23,23,28,28,3,3,2,2,17,17,3,3,21,21,14,14,28,28,5,5,25,25,2,2,27,27,3,3,8,8,20,20,29,29,31,31,2,2,16,16,7,7,2,2,25,25,23,23,5,5,6,6,1,1,25,25,6,6,1,1,12,12,8,8,20,20,21,21,3,3,25,25,25,25,4,4,29,29,28,28,28,28,5,5,8,8,29,29,17,17,29,29,6,6,15,15,10,10,19,19,8,8,11,11,16,16,3,3,10,10,17,17,0,0,26,26,8,8,19,19,0,0,28,28,24,24,9,9,28,28,21,21,4,4,11,11,11,11,28,28,25,25,2,2,9,9,18,18,0,0,13,13,6,6,10,10,15,15,25,25,7,7,8,8,21,21,12,12,15,15,11,11,27,27,15,15,3,3,24,24,30,30,19,19,2,2,8,8,0,0,15,15,10,10,19,19,14,14,12,12,24,24,10,10,21,21,6,6,8,8,14,14,21,21,0,0,23,23,1,1,29,29,20,20,23,23,0,0,22,22,11,11,26,26,15,15,9,9,6,6,24,24,9,9,22,22,6,6,9,9,10,10,6,6,4,4,17,17,11,11,11,11,16,16,12,12,14,14,28,28,4,4,17,17,23,23,5,5,11,11,3,3,12,12,19,19,30,30,1,1,9,9,20,20,26,26,30,30,5,5,13,13,14,14,0,0,5,5,0,0,16,16,5,5,11,11,0,0,21,21,8,8,6,6,20,20,22,22,13,13,24,24,28,28,27,27,25,25,20,20,14,14,8,8,17,17,31,31,16,16,26,26,10,10,17,17,13,13,5,5,22,22,0,0,15,15,28,28,14,14,16,16,31,31,19,19,0,0,3,3,30,30,8,8,8,8,29,29,1,1,18,18,5,5,7,7,15,15,13,13,13,13,23,23,9,9,22,22,17,17,28,28,4,4,5,5,0,0,21,21,29,29,12,12,22,22,17,17,18,18,18,18,0,0,31,31,5,5,6,6,2,2,1,1,27,27,3,3,24,24,26,26,23,23,17,17,26,26,27,27,31,31,27,27,0,0,22,22,18,18,11,11,24,24,9,9,29,29,14,14,16,16,20,20,4,4,25,25,22,22,5,5,27,27,1,1,29,29,16,16,15,15,6,6,19,19,25,25,25,25,7,7,22,22,5,5,17,17,9,9,5,5,11,11,2,2,18,18,7,7,19,19,24,24,28,28,19,19,20,20,1,1,0,0,25,25,20,20,17,17,0,0,20,20,18,18,20,20,17,17,2,2,16,16,11,11,1,1,28,28,19,19,17,17,4,4,31,31,28,28,18,18,15,15,14,14,9,9,13,13,15,15,1,1,23,23,30,30,15,15,21,21,0,0,31,31,8,8,23,23,11,11,12,12,29,29,28,28,2,2,31,31,30,30,26,26,5,5,5,5,15,15,20,20,11,11,14,14,16,16,0,0,11,11,10,10,0,0,24,24,8,8,12,12,9,9,6,6,28,28,27,27,14,14,8,8,8,8,23,23,24,24,20,20,26,26,20,20,1,1,30,30,6,6,16,16,21,21,10,10,3,3,7,7,18,18,23,23,1,1,24,24,13,13,10,10,11,11,27,27,25,25,16,16,14,14,17,17,25,25,7,7,4,4,24,24,20,20,31,31,20,20,12,12,0,0,19,19,21,21,0,0,29,29,1,1,3,3,26,26,0,0,31,31,28,28,27,27,3,3,21,21,16,16,23,23,7,7,5,5,21,21,15,15,14,14,19,19,0,0,24,24,21,21,14,14,29,29,11,11,9,9,9,9,20,20,24,24,24,24,1,1,25,25,31,31,4,4,24,24,3,3,18,18,18,18,28,28,13,13,31,31,29,29,3,3,31,31,26,26,16,16,16,16,27,27,29,29,13,13,17,17,6,6,17,17,14,14,2,2,23,23,9,9,13,13,6,6,24,24,8,8,23,23,24,24,14,14,16,16,9,9,17,17,1,1,0,0,27,27,6,6,0,0,9,9,12,12,9,9,28,28,5,5,9,9,16,16,20,20,12,12,6,6,7,7,30,30,0,0,22,22,5,5,11,11,20,20,22,22,20,20,13,13,24,24,24,24,16,16,0,0,13,13,11,11,13,13,5,5,8,8,19,19,2,2,10,10,27,27,30,30,12,12,11,11,6,6,15,15,5,5,21,21,5,5,31,31,10,10,26,26,0,0,23,23,9,9,3,3,19,19,26,26,16,16,29,29,8,8,10,10,16,16,21,21,29,29,19,19,26,26,11,11,10,10,3,3,11,11,4,4,23,23,2,2,21,21,20,20,9,9,31,31,4,4,29,29,9,9,7,7,4,4,7,7,1,1,18,18,31,31,21,21,8,8,5,5,18,18,6,6,4,4,16,16,23,23,22,22,6,6,28,28,0,0,22,22,2,2,6,6,13,13,16,16,15,15,3,3,1,1,19,19,13,13,20,20,29,29,13,13,10,10,10,10,12,12,4,4,4,4,13,13,24,24,2,2,29,29,25,25,16,16,22,22,1,1,28,28,17,17,3,3,26,26,18,18,6,6,7,7,29,29,16,16,2,2,26,26,15,15,26,26,0,0,16,16,17,17,26,26,31,31,23,23,13,13,9,9,28,28,1,1,6,6,8,8,24,24,4,4,3,3,19,19,18,18,6,6,15,15,27,27,20,20,0,0,9,9,26,26,13,13,28,28,18,18,14,14,4,4,17,17,5,5,23,23,29,29,9,9,18,18,20,20,4,4,3,3,13,13,11,11,16,16,6,6,6,6,19,19,5,5,5,5,30,30,27,27,15,15,28,28,30,30,19,19,22,22,22,22,0,0,13,13,31,31,19,19,25,25,17,17,22,22,16,16,16,16,0,0,12,12,17,17,20,20,3,3,10,10,22,22,3,3,22,22,10,10,7,7,18,18,6,6,8,8,26,26,14,14,30,30,0,0,18,18,27,27,10,10,18,18,13,13,3,3,22,22,0,0,15,15,2,2,27,27,30,30,1,1,9,9,12,12,4,4,3,3,8,8,1,1,6,6,21,21,10,10,19,19,9,9,11,11,15,15,5,5,13,13,22,22,23,23,7,7,5,5,3,3,3,3,4,4,25,25,1,1,18,18,24,24,2,2,17,17,2,2,4,4,28,28,28,28,4,4,1,1,10,10,12,12,4,4,30,30,2,2,24,24,1,1,15,15,14,14,31,31,10,10,29,29,1,1,13,13,16,16,1,1,1,1,19,19,29,29,10,10,26,26,15,15,10,10,29,29,9,9,21,21,9,9,14,14,18,18,1,1,24,24,23,23,27,27,25,25,23,23,19,19,20,20,4,4,23,23,18,18,2,2,22,22,13,13,21,21,31,31,11,11,19,19,9,9,2,2,21,21,17,17,19,19,4,4,11,11,30,30,15,15,21,21,5,5,25,25,6,6,25,25,16,16,30,30,13,13,23,23,18,18,19,19,25,25,24,24,1,1,0,0,10,10,2,2,17,17,30,30,16,16,6,6,11,11,14,14,6,6,0,0,28,28,4,4,20,20,0,0,29,29,24,24,1,1,26,26,2,2,6,6,14,14,21,21,5,5,13,13,4,4,23,23,10,10,23,23,13,13,26,26,4,4,16,16,0,0,31,31,3,3,10,10,29,29,1,1,13,13,10,10,5,5,1,1,22,22,3,3,9,9,24,24,3,3,23,23,31,31,27,27,29,29,23,23,9,9,16,16,8,8,23,23,1,1,25,25,1,1,24,24,5,5,11,11,21,21,8,8,18,18,15,15,5,5,11,11,13,13,8,8,8,8,22,22,24,24,1,1,8,8,5,5,9,9,23,23,8,8,12,12,17,17,4,4,7,7,30,30,4,4,10,10,0,0,10,10,5,5,8,8,15,15,27,27,21,21,24,24,28,28,15,15,25,25,11,11,19,19,18,18,5,5,10,10,19,19,5,5,31,31,21,21,18,18,22,22,14,14,12,12,21,21,10,10,29,29,12,12,18,18,0,0,18,18,9,9,4,4,5,5,20,20,21,21,0,0,13,13,31,31,18,18,21,21,15,15,16,16,18,18,21,21,3,3,4,4,10,10,3,3,0,0,16,16,25,25,11,11,9,9,7,7,10,10,16,16,26,26,1,1,0,0,1,1,5,5,2,2,24,24,20,20,31,31,7,7,29,29,22,22,21,21,16,16,31,31,2,2,18,18,31,31,16,16,0,0,15,15,8,8,15,15,20,20,14,14,20,20,28,28,4,4,19,19,26,26,27,27,24,24,1,1,30,30,20,20,1,1,20,20,2,2,13,13,3,3,25,25,2,2,23,23,26,26,23,23,20,20,5,5,1,1,10,10,28,28,2,2,7,7,21,21,17,17,31,31,17,17,13,13,8,8,19,19,18,18,16,16,18,18,2,2,23,23,5,5,1,1,11,11,23,23,29,29,8,8,24,24,22,22,6,6,5,5,6,6,5,5,24,24,22,22,13,13,22,22,5,5,17,17,4,4,18,18,8,8,19,19,31,31,4,4,23,23,0,0,31,31,13,13,18,18,22,22,9,9,16,16,26,26,27,27,0,0,9,9,11,11,22,22,19,19,14,14,24,24,17,17,4,4,25,25,30,30,8,8,19,19,10,10,16,16,7,7,21,21,18,18,21,21,30,30,14,14,15,15,16,16,20,20,23,23,1,1,3,3,0,0,7,7,14,14,4,4,17,17,11,11,1,1,14,14,7,7,24,24,27,27,23,23,6,6,27,27,21,21,21,21,2,2,8,8,9,9,12,12,16,16,0,0,12,12,24,24,8,8,1,1,18,18,29,29,10,10,20,20,13,13,20,20,29,29,12,12,9,9,3,3,22,22,16,16,7,7,22,22,19,19,1,1,27,27,16,16,11,11,2,2,9,9,17,17,1,1,2,2,30,30,1,1,25,25,17,17,6,6,0,0,24,24,21,21,24,24,27,27,9,9,31,31,9,9,11,11,22,22,17,17,5,5,31,31,27,27,5,5,24,24,20,20,11,11,11,11,10,10,4,4,1,1,12,12,28,28,12,12,28,28,17,17,21,21,16,16,22,22,3,3,16,16,27,27,23,23,8,8,20,20,12,12,12,12,10,10,5,5,15,15,16,16,2,2,24,24,16,16,24,24,26,26,17,17,7,7,13,13,10,10,4,4,5,5,23,23,30,30,14,14,0,0,18,18,23,23,6,6,1,1,28,28,10,10,4,4,11,11,20,20,15,15,24,24,28,28,16,16,26,26,2,2,20,20,19,19,19,19,31,31,21,21,16,16,12,12,23,23,11,11,13,13,0,0,25,25,3,3,26,26,14,14,25,25,19,19,1,1,27,27,9,9,20,20,16,16,26,26,0,0,4,4,1,1,26,26,31,31,20,20,23,23,6,6,29,29,6,6,31,31,16,16,5,5,13,13,0,0,6,6,1,1,13,13,11,11,9,9,28,28,24,24,1,1,19,19,13,13,15,15,29,29,7,7,5,5,11,11,25,25,6,6,2,2,13,13,25,25,30,30,22,22,29,29,5,5,26,26,10,10,25,25,18,18,17,17,19,19,7,7,29,29,17,17,20,20,4,4,13,13,31,31,26,26,29,29,11,11,12,12,21,21,18,18,9,9,0,0,7,7,13,13,24,24,17,17,10,10,25,25,9,9,29,29,5,5,23,23,21,21,12,12,3,3,6,6,11,11,9,9,31,31,3,3,5,5,28,28,23,23,7,7,0,0,19,19,31,31,13,13,28,28,18,18,9,9,18,18,23,23,22,22,14,14,19,19,7,7,25,25,9,9,23,23,12,12,13,13,19,19,25,25,27,27,2,2,20,20,18,18,9,9,12,12,0,0,31,31,5,5,20,20,26,26,20,20,12,12,4,4,21,21,27,27,10,10,25,25,21,21,17,17,28,28,22,22,7,7,25,25,3,3,18,18,8,8,14,14,8,8,16,16,18,18,21,21,15,15,21,21,27,27,21,21,5,5,20,20,6,6,25,25,21,21,9,9,17,17,3,3,0,0,28,28,7,7,14,14,15,15,5,5,5,5,18,18,8,8,27,27,20,20,28,28,20,20,7,7,22,22,13,13,21,21,15,15,1,1,26,26,0,0,24,24,24,24,2,2,22,22,19,19,14,14,8,8,18,18,17,17,4,4,25,25,28,28,26,26,11,11,17,17,15,15,17,17,5,5,14,14,16,16,14,14,20,20,3,3,31,31,16,16,28,28,10,10,3,3,4,4,0,0,29,29,26,26,31,31,7,7,21,21,0,0,10,10,31,31,24,24,15,15,18,18,11,11,10,10,9,9,17,17,21,21,24,24,26,26,11,11,20,20,4,4,0,0,12,12,16,16,21,21,21,21,14,14,28,28,9,9,24,24,27,27,12,12,25,25,0,0,28,28,25,25,13,13,15,15,12,12,5,5,29,29,27,27,17,17,5,5,7,7,27,27,18,18,3,3,1,1,17,17,12,12,15,15,26,26,24,24,28,28,17,17,20,20,20,20,24,24,8,8,17,17,21,21,9,9,15,15,24,24,17,17,20,20,28,28,29,29,23,23,18,18,1,1,21,21,8,8,4,4,21,21,3,3,25,25,10,10,29,29,5,5,3,3,26,26,10,10,18,18,16,16,8,8,11,11,18,18,3,3,18,18,21,21,6,6,27,27,20,20,14,14,3,3,29,29,26,26,15,15,17,17,16,16,11,11,9,9,31,31,1,1,2,2,0,0,26,26,11,11,1,1,15,15,2,2,3,3,25,25,3,3,8,8,24,24,28,28,27,27,23,23,10,10,18,18,31,31,14,14,25,25,31,31,23,23,18,18,18,18,3,3,20,20,17,17,27,27,3,3,10,10,15,15,18,18,26,26,25,25,4,4,10,10,24,24,22,22,16,16,4,4,27,27,16,16,3,3,22,22,8,8,21,21,0,0,12,12,1,1,15,15,5,5,23,23,11,11,26,26,23,23,27,27,26,26,8,8,18,18,18,18,16,16,31,31,31,31,19,19,5,5,15,15,2,2,7,7,15,15,13,13,21,21,20,20,0,0,1,1,11,11,10,10,3,3,31,31,26,26,3,3,12,12,4,4,13,13,12,12,20,20,27,27,2,2,0,0,13,13,0,0,3,3,25,25,4,4,18,18,2,2,1,1,25,25,9,9,4,4,17,17,12,12,8,8,4,4,24,24,28,28,23,23,29,29,23,23,7,7,1,1,14,14,8,8,16,16,13,13,0,0,3,3,1,1,11,11,5,5,14,14,5,5,7,7,12,12,14,14,14,14,5,5,13,13,17,17,9,9,12,12,19,19,4,4,9,9,10,10,10,10,31,31,2,2,10,10,13,13,6,6,5,5,23,23,22,22,28,28,27,27,21,21,29,29,21,21,17,17,23,23,30,30,9,9,16,16,7,7,10,10,24,24,13,13,26,26,4,4,26,26,19,19,3,3,2,2,21,21,21,21,15,15,27,27,18,18,30,30,9,9,20,20,4,4,18,18,20,20,1,1,15,15,30,30,4,4,18,18,20,20,7,7,18,18,5,5,26,26,7,7,30,30,26,26,31,31,21,21,2,2,31,31,7,7,11,11,24,24,19,19,11,11,4,4,9,9,27,27,16,16,2,2,14,14,7,7,3,3,14,14,19,19,31,31,12,12,24,24,20,20,9,9,6,6,15,15,7,7,6,6,9,9,0,0,21,21,0,0,5,5,5,5,26,26,8,8,4,4,25,25,24,24,18,18,13,13,13,13,14,14,21,21,6,6,28,28,11,11,23,23,4,4,7,7,3,3,31,31,1,1,5,5,25,25,12,12,19,19,1,1,4,4,8,8,6,6,5,5,12,12,8,8,23,23,21,21,25,25,23,23,8,8,21,21,22,22,22,22,30,30,30,30,30,30,28,28,30,30,21,21,22,22,13,13,19,19,14,14,28,28,15,15,28,28,8,8,31,31,31,31,23,23,20,20,8,8,24,24,6,6,22,22,30,30,27,27,13,13,25,25,29,29,26,26,21,21,3,3,26,26,19,19,13,13,8,8,5,5,16,16,12,12,23,23,2,2,4,4,2,2,23,23,29,29,20,20,19,19,10,10,22,22,28,28,5,5,22,22,25,25,5,5,10,10,30,30,10,10,22,22,3,3,12,12,27,27,8,8,12,12,6,6,19,19,23,23,18,18,20,20,18,18,5,5,14,14,10,10,9,9,7,7,1,1,16,16,4,4,30,30,17,17,4,4,14,14,5,5,5,5,17,17,5,5,2,2,23,23,13,13,15,15,11,11,21,21,4,4,7,7,11,11,0,0,26,26,5,5,6,6,22,22,15,15,27,27,22,22,13,13,9,9,17,17,25,25,2,2,0,0,15,15,22,22,27,27,30,30,15,15,8,8,16,16,6,6,5,5,24,24,25,25,16,16,13,13,7,7,24,24,12,12,5,5,22,22,17,17,9,9,21,21,13,13,22,22,4,4,4,4,1,1,10,10,2,2,15,15,6,6,30,30,31,31,0,0,24,24,27,27,14,14,26,26,14,14,17,17,8,8,23,23,15,15,10,10,1,1,15,15,5,5,28,28,25,25,29,29,6,6,21,21,16,16,21,21,18,18,24,24,17,17,19,19,1,1,19,19,26,26,22,22,16,16,28,28,26,26,17,17,14,14,31,31,7,7,11,11,9,9,6,6,17,17,9,9,19,19,27,27,11,11,13,13,13,13,6,6,20,20,24,24,24,24,31,31,12,12,15,15,11,11,13,13,14,14,2,2,11,11,23,23,27,27,28,28,26,26,10,10,25,25,16,16,7,7,17,17,23,23,16,16,8,8,25,25,5,5,3,3,20,20,5,5,15,15,3,3,27,27,9,9,30,30,14,14,30,30,15,15,21,21,20,20,14,14,10,10,13,13,25,25,1,1,20,20,6,6,19,19,24,24,29,29,28,28,25,25,26,26,19,19,0,0,2,2,1,1,19,19,4,4,28,28,23,23,13,13,28,28,31,31,12,12,8,8,28,28,2,2,29,29,0,0,22,22,4,4,6,6,7,7,18,18,29,29,4,4,19,19,13,13,0,0,2,2,1,1,17,17,30,30,18,18,25,25,3,3,27,27,25,25,26,26,31,31,28,28,13,13,7,7,4,4,11,11,13,13,9,9,2,2,31,31,22,22,27,27,14,14,23,23,0,0,29,29,7,7,18,18,30,30,8,8,12,12,20,20,13,13,7,7,25,25,23,23,2,2,30,30,19,19,27,27,30,30,28,28,7,7,20,20,3,3,27,27,6,6,4,4,7,7,30,30,17,17,19,19,22,22,10,10,20,20,9,9,3,3,11,11,8,8,30,30,7,7,20,20,24,24,23,23,18,18,0,0,25,25,19,19,14,14,10,10,5,5,20,20,30,30,19,19,7,7,12,12,28,28,26,26,25,25,9,9,23,23,2,2,24,24,21,21,21,21,31,31,12,12,15,15,12,12,19,19,20,20,11,11,2,2,21,21,14,14,7,7,7,7,16,16,30,30,28,28,28,28,3,3,11,11,25,25,21,21,30,30,20,20,17,17,11,11,24,24,5,5,9,9,9,9,20,20,4,4,22,22,7,7,12,12,4,4,17,17,28,28,30,30,6,6,4,4,6,6,12,12,3,3,29,29,0,0,18,18,1,1,1,1,2,2,6,6,9,9,29,29,21,21,8,8,4,4,1,1,22,22,4,4,21,21,22,22,6,6,28,28,16,16,1,1,5,5,24,24,24,24,25,25,1,1,1,1,22,22,0,0,30,30,16,16,24,24,7,7,8,8,15,15,1,1,16,16,6,6,11,11,2,2,23,23,0,0,0,0,22,22,31,31,21,21,1,1,4,4,8,8,11,11,10,10,22,22,17,17,21,21,3,3,18,18,4,4,11,11,27,27,18,18,1,1,12,12,9,9,17,17,2,2,22,22,14,14,13,13,6,6,23,23,6,6,4,4,2,2,5,5,22,22,28,28,4,4,23,23,26,26,4,4,0,0,13,13,13,13,1,1,19,19,18,18,0,0,1,1,21,21,25,25,20,20,22,22,3,3,13,13,29,29,5,5,9,9,5,5,13,13,4,4,3,3,25,25,24,24,4,4,31,31,22,22,13,13,16,16,18,18,1,1,17,17,16,16,24,24,24,24,23,23,15,15,14,14,0,0,15,15,31,31,18,18,22,22,10,10,27,27,22,22,6,6,7,7,14,14,29,29,9,9,13,13,15,15,16,16,17,17,5,5,25,25,21,21,7,7,20,20,22,22,7,7,0,0,6,6,10,10,21,21,11,11,7,7,3,3,10,10,25,25,28,28,25,25,26,26,4,4,31,31,15,15,23,23,22,22,25,25,18,18,31,31,15,15,14,14,19,19,8,8,21,21,8,8,20,20,20,20,26,26,13,13,3,3,12,12,10,10,6,6,22,22,17,17,23,23,19,19,19,19,25,25,27,27,29,29,25,25,2,2,31,31,18,18,29,29,5,5,19,19,5,5,21,21,8,8,31,31,1,1,28,28,13,13,6,6,0,0,28,28,17,17,23,23,5,5,10,10,25,25,14,14,11,11,5,5,26,26,22,22,28,28,12,12,4,4,18,18,20,20,15,15,17,17,4,4,27,27,1,1,22,22,23,23,23,23,8,8,3,3,0,0,11,11,31,31,13,13,13,13,22,22,3,3,4,4,1,1,8,8,9,9,19,19,4,4,2,2,7,7,0,0,28,28,1,1,4,4,31,31,4,4,8,8,25,25,23,23,14,14,3,3,17,17,11,11,14,14,14,14,29,29,15,15,12,12,4,4,22,22,25,25,8,8,24,24,22,22,21,21,27,27,13,13,21,21,14,14,3,3,11,11,9,9,17,17,29,29,20,20,21,21,2,2,0,0,31,31,2,2,4,4,26,26,21,21,2,2,0,0,13,13,4,4,13,13,5,5,2,2,14,14,1,1,15,15,30,30,9,9,13,13,16,16,8,8,22,22,12,12,27,27,24,24,26,26,8,8,9,9,18,18,8,8,25,25,19,19,24,24,18,18,31,31,2,2,8,8,10,10,2,2,1,1,8,8,30,30,23,23,23,23,15,15,7,7,28,28,9,9,9,9,14,14,10,10,17,17,31,31,24,24,30,30,18,18,7,7,15,15,9,9,9,9,23,23,10,10,28,28,1,1,0,0,4,4,6,6,12,12,0,0,9,9,9,9,7,7,12,12,5,5,28,28,17,17,25,25,17,17,12,12,26,26,16,16,22,22,17,17,29,29,23,23,8,8,9,9,22,22,16,16,10,10,1,1,30,30,31,31,0,0,8,8,31,31,2,2,2,2,0,0,31,31,4,4,12,12,18,18,28,28,21,21,16,16,15,15,8,8,31,31,27,27,6,6,11,11,19,19,18,18,2,2,24,24,9,9,3,3,17,17,31,31,23,23,26,26,8,8,0,0,4,4,2,2,29,29,23,23,0,0,9,9,5,5,23,23,24,24,5,5,8,8,5,5,19,19,19,19,8,8,4,4,10,10,13,13,9,9,16,16,19,19,29,29,8,8,11,11,17,17,1,1,12,12,9,9,4,4,26,26,7,7,24,24,5,5,30,30,14,14,19,19,10,10,27,27,20,20,3,3,2,2,17,17,3,3,11,11,25,25,15,15,14,14,5,5,8,8,18,18,7,7,3,3,30,30,27,27,3,3,15,15,29,29,20,20,4,4,31,31,11,11,24,24,0,0,6,6,11,11,28,28,20,20,1,1,6,6,16,16,5,5,11,11,25,25,5,5,25,25,6,6,16,16,2,2,21,21,25,25,28,28,18,18,0,0,10,10,12,12,24,24,18,18,8,8,12,12,1,1,24,24,2,2,9,9,28,28,29,29,13,13,30,30,29,29,26,26,13,13,23,23,12,12,4,4,17,17,19,19,17,17,5,5,5,5,9,9,1,1,3,3,21,21,30,30,28,28,19,19,15,15,20,20,20,20,17,17,9,9,24,24,28,28,9,9,30,30,29,29,30,30,31,31,26,26,7,7,26,26,5,5,0,0,3,3,4,4,29,29,5,5,4,4,14,14,4,4,11,11,26,26,17,17,23,23,2,2,3,3,7,7,13,13,6,6,29,29,3,3,0,0,0,0,6,6,23,23,2,2,24,24,5,5,0,0,26,26,23,23,18,18,18,18,26,26,14,14,25,25,9,9,16,16,24,24,22,22,7,7,12,12,5,5,5,5,4,4,12,12,8,8,14,14,23,23,1,1,7,7,6,6,10,10,27,27,16,16,31,31,29,29,17,17,6,6,24,24,20,20,6,6,26,26,4,4,0,0,27,27,5,5,26,26,7,7,5,5,0,0,28,28,21,21,9,9,19,19,16,16,19,19,7,7,7,7,26,26,23,23,0,0,25,25,2,2,8,8,23,23,12,12,17,17,0,0,0,0,2,2,25,25,3,3,13,13,5,5,16,16,29,29,25,25,19,19,24,24,2,2,1,1,14,14,19,19,4,4,25,25,20,20,1,1,17,17,20,20,29,29,30,30,30,30,25,25,27,27,24,24,2,2,9,9,1,1,20,20,8,8,17,17,12,12,20,20,18,18,26,26,13,13,17,17,21,21,10,10,2,2,8,8,5,5,3,3,23,23,17,17,23,23,6,6,1,1,19,19,22,22,27,27,15,15,4,4,11,11,28,28,28,28,18,18,13,13,29,29,28,28,23,23,28,28,14,14,31,31,10,10,10,10,1,1,24,24,27,27,25,25,5,5,13,13,11,11,20,20,13,13,20,20,0,0,11,11,24,24,29,29,23,23,12,12,18,18,29,29,7,7,4,4,21,21,12,12,5,5,1,1,23,23,23,23,17,17,22,22,17,17,18,18,30,30,17,17,28,28,16,16,3,3,27,27,21,21,12,12,29,29,6,6,4,4,20,20,20,20,17,17,11,11,14,14,10,10,8,8,11,11,21,21,21,21,1,1,10,10,20,20,13,13,31,31,14,14,21,21,19,19,1,1,13,13,23,23,22,22,5,5,30,30,17,17,20,20,29,29,21,21,6,6,23,23,17,17,31,31,25,25,0,0,23,23,17,17,23,23,2,2,7,7,21,21,0,0,26,26,3,3,12,12,3,3,10,10,30,30,0,0,6,6,11,11,29,29,0,0,18,18,4,4,16,16,26,26,21,21,20,20,28,28,26,26,11,11,24,24,4,4,29,29,11,11,27,27,8,8,18,18,26,26,18,18,16,16,13,13,11,11,2,2,0,0,29,29,0,0,31,31,14,14,24,24,1,1,14,14,6,6,17,17,18,18,13,13,24,24,4,4,10,10,8,8,10,10,18,18,19,19,28,28,16,16,9,9,2,2,13,13,11,11,22,22,31,31,21,21,3,3,11,11,28,28,29,29,30,30,16,16,27,27,12,12,14,14,11,11,6,6,18,18,15,15,21,21,24,24,2,2,17,17,25,25,5,5,27,27,0,0,10,10,9,9,20,20,20,20,15,15,0,0,31,31,8,8,24,24,19,19,1,1,19,19,24,24,19,19,14,14,1,1,22,22,4,4,2,2,1,1,12,12,17,17,26,26,25,25,24,24,16,16,23,23,5,5,3,3,0,0,7,7,14,14,12,12,22,22,16,16,0,0,8,8,27,27,24,24,24,24,29,29,18,18,0,0,2,2,28,28,2,2,27,27,29,29,12,12,6,6,1,1,28,28,14,14,21,21,11,11,2,2,2,2,6,6,0,0,14,14,27,27,19,19,25,25,24,24,5,5,22,22,18,18,13,13,28,28,9,9,19,19,24,24,26,26,21,21,24,24,1,1,15,15,23,23,0,0,24,24,21,21,2,2,22,22,1,1,12,12,3,3,17,17,13,13,28,28,8,8,19,19,27,27,6,6,28,28,11,11,14,14,22,22,2,2,27,27,27,27,13,13,18,18,11,11,1,1,0,0,16,16,22,22,2,2,5,5,22,22,17,17,17,17,26,26,29,29,5,5,10,10,11,11,25,25,1,1,11,11,2,2,9,9,23,23,2,2,7,7,2,2,9,9,16,16,15,15,28,28,17,17,18,18,4,4,18,18,29,29,20,20,18,18,6,6,0,0,10,10,28,28,11,11,8,8,3,3,10,10,17,17,1,1,11,11,16,16,16,16,23,23,1,1,25,25,7,7,19,19,17,17,13,13,25,25,12,12,21,21,13,13,30,30,27,27,5,5,17,17,30,30,2,2,15,15,31,31,17,17,17,17,16,16,12,12,14,14,5,5,17,17,2,2,2,2,28,28,14,14,9,9,17,17,2,2,6,6,25,25,15,15,19,19,28,28,17,17,3,3,8,8,2,2,12,12,11,11,30,30,3,3,5,5,6,6,21,21,1,1,14,14,0,0,29,29,13,13,1,1,13,13,14,14,21,21,12,12,1,1,25,25,7,7,0,0,17,17,0,0,2,2,21,21,28,28,4,4,22,22,11,11,12,12,16,16,0,0,8,8,14,14,19,19,15,15,16,16,16,16,29,29,22,22,14,14,13,13,17,17,27,27,10,10,8,8,23,23,31,31,5,5,6,6,27,27,15,15,26,26,4,4,9,9,29,29,12,12,6,6,8,8,21,21,23,23,3,3,15,15,8,8,5,5,16,16,19,19,3,3,19,19,29,29,16,16,18,18,4,4,15,15,3,3,0,0,6,6,21,21,20,20,1,1,11,11,0,0,19,19,26,26,21,21,19,19,14,14,4,4,19,19,3,3,13,13,31,31,0,0,1,1,20,20,2,2,1,1,27,27,10,10,28,28,22,22,27,27,10,10,1,1,0,0,24,24,26,26,2,2,27,27,31,31,22,22,23,23,24,24,30,30,16,16,6,6,9,9,23,23,18,18,29,29,27,27,21,21,18,18,24,24,3,3,8,8,12,12,5,5,13,13,21,21,29,29,1,1,26,26,4,4,22,22,5,5,2,2,14,14,2,2,9,9,8,8,4,4,15,15,0,0,2,2,18,18,7,7,24,24,1,1,22,22,21,21,29,29,28,28,13,13,8,8,21,21,20,20,29,29,18,18,8,8,22,22,21,21,2,2,26,26,18,18,3,3,20,20,26,26,11,11,4,4,21,21,19,19,14,14,20,20,2,2,7,7,14,14,12,12,12,12,28,28,25,25,29,29,26,26,3,3,10,10,24,24,6,6,7,7,22,22,13,13,5,5,31,31,18,18,11,11,12,12,29,29,0,0,28,28,24,24,31,31,5,5,28,28,30,30,4,4,12,12,28,28,2,2,20,20,7,7,12,12,9,9,8,8,9,9,21,21,8,8,16,16,16,16,10,10,30,30,28,28,31,31,19,19,7,7,17,17,11,11,8,8,26,26,17,17,26,26,24,24,16,16,1,1,26,26,10,10,15,15,1,1,10,10,2,2,18,18,9,9,16,16,31,31,7,7,30,30,22,22,3,3,9,9,31,31,6,6,5,5,16,16,15,15,3,3,27,27,22,22,22,22,20,20,14,14,14,14,4,4,30,30,18,18,21,21,2,2,29,29,16,16,15,15,4,4,22,22,27,27,10,10,2,2,5,5,17,17,1,1,12,12,15,15,2,2,9,9,11,11,26,26,19,19,0,0,4,4,24,24,26,26,19,19,9,9,25,25,3,3,23,23,12,12,12,12,0,0,7,7,24,24,25,25,31,31,24,24,4,4,3,3,25,25,3,3,20,20,6,6,28,28,18,18,28,28,1,1,30,30,25,25,28,28,11,11,1,1,0,0,14,14,21,21,26,26,17,17,26,26,31,31,15,15,15,15,18,18,17,17,6,6,18,18,23,23,23,23,3,3,26,26,10,10,24,24,5,5,27,27,5,5,11,11,29,29,15,15,16,16,9,9,25,25,10,10,9,9,11,11,9,9,31,31,8,8,10,10,21,21,24,24,11,11,11,11,8,8,27,27,22,22,3,3,17,17,2,2,2,2,27,27,16,16,6,6,24,24,28,28,27,27,4,4,5,5,0,0,2,2,4,4,11,11,14,14,1,1,2,2,11,11,24,24,2,2,6,6,22,22,5,5,5,5,29,29,28,28,5,5,20,20,1,1,26,26,5,5,24,24,11,11,24,24,24,24,28,28,17,17,11,11,16,16,9,9,11,11,3,3,3,3,6,6,11,11,2,2,26,26,22,22,30,30,24,24,31,31,16,16,18,18,22,22,17,17,21,21,19,19,22,22,22,22,29,29,16,16,5,5,30,30,25,25,11,11,0,0,15,15,9,9,16,16,18,18,30,30,4,4,8,8,25,25,8,8,16,16,20,20,7,7,20,20,6,6,7,7,24,24,18,18,25,25,9,9,12,12,6,6,4,4,1,1,20,20,18,18,19,19,8,8,30,30,20,20,28,28,11,11,11,11,14,14,30,30,24,24,20,20,20,20,12,12,19,19,29,29,21,21,29,29,3,3,5,5,16,16,26,26,13,13,5,5,5,5,30,30,7,7,8,8,5,5,4,4,3,3,9,9,22,22,21,21,19,19,10,10,6,6,28,28,10,10,6,6,10,10,21,21,16,16,1,1,14,14,2,2,30,30,3,3,18,18,12,12,1,1,27,27,10,10,23,23,3,3,8,8,10,10,26,26,26,26,14,14,31,31,11,11,1,1,21,21,8,8,11,11,15,15,16,16,28,28,2,2,4,4,19,19,20,20,23,23,0,0,27,27,9,9,16,16,11,11,3,3,16,16,6,6,13,13,24,24,0,0,22,22,4,4,5,5,16,16,9,9,3,3,3,3,28,28,1,1,23,23,5,5,1,1,3,3,20,20,8,8,25,25,17,17,20,20,10,10,7,7,1,1,21,21,25,25,13,13,7,7,31,31,28,28,4,4,2,2,0,0,0,0,9,9,28,28,16,16,0,0,28,28,7,7,24,24,18,18,27,27,4,4,31,31,24,24,6,6,7,7,28,28,19,19,6,6,28,28,6,6,25,25,30,30,11,11,9,9,24,24,0,0,19,19,12,12,16,16,19,19,3,3,22,22,21,21,24,24,1,1,29,29,4,4,13,13,2,2,4,4,2,2,31,31,7,7,29,29,19,19,26,26,10,10,15,15,27,27,20,20,12,12,5,5,25,25,16,16,25,25,15,15,11,11,9,9,18,18,1,1,16,16,16,16,29,29,24,24,13,13,25,25,23,23,2,2,17,17,2,2,17,17,7,7,18,18,20,20,7,7,25,25,9,9,23,23,8,8,8,8,0,0,10,10,23,23,13,13,27,27,11,11,26,26,6,6,7,7,3,3,19,19,16,16,26,26,19,19,0,0,23,23,14,14,23,23,2,2,0,0,10,10,0,0,16,16,1,1,9,9,2,2,8,8,2,2,1,1,20,20,7,7,20,20,31,31,31,31,24,24,2,2,29,29,0,0,1,1,2,2,10,10,19,19,11,11,20,20,23,23,3,3,29,29,6,6,2,2,22,22,4,4,1,1,13,13,11,11,23,23,24,24,10,10,6,6,16,16,3,3,14,14,11,11,17,17,23,23,24,24,22,22,18,18,22,22,20,20,22,22,29,29,0,0,22,22,24,24,10,10,10,10,12,12,19,19,13,13,1,1,10,10,31,31,20,20,27,27,29,29,18,18,7,7,2,2,7,7,22,22,24,24,4,4,17,17,1,1,19,19,8,8,4,4,7,7,14,14,10,10,3,3,27,27,8,8,22,22,0,0,24,24,24,24,20,20,7,7,5,5,4,4,19,19,6,6,9,9,4,4,31,31,6,6,0,0,29,29,1,1,10,10,17,17,2,2,9,9,0,0,9,9,8,8,8,8,0,0,25,25,0,0,27,27,16,16,16,16,7,7,16,16,13,13,24,24,4,4,4,4,12,12,12,12,26,26,10,10,19,19,28,28,0,0,28,28,30,30,24,24,8,8,26,26,28,28,8,8,26,26,26,26,26,26,1,1,20,20,0,0,2,2,17,17,23,23,0,0,8,8,8,8,2,2,21,21,4,4,17,17,19,19,10,10,8,8,30,30,21,21,31,31,21,21,8,8,31,31,22,22,9,9,2,2,12,12,30,30,11,11,20,20,28,28,8,8,8,8,4,4,1,1,23,23,3,3,29,29,30,30,23,23,28,28,28,28,11,11,31,31,29,29,29,29,26,26,27,27,16,16,5,5,28,28,4,4,19,19,18,18,24,24,25,25,10,10,4,4,4,4,11,11,3,3,21,21,17,17,9,9,24,24,5,5,8,8,5,5,27,27,7,7,2,2,0,0,29,29,1,1,2,2,28,28,13,13,4,4,2,2,3,3,30,30,26,26,14,14,15,15,21,21,22,22,26,26,10,10,11,11,0,0,25,25,29,29,9,9,9,9,2,2,16,16,22,22,7,7,8,8,2,2,24,24,18,18,5,5,23,23,7,7,8,8,21,21,13,13,0,0,18,18,19,19,29,29,6,6,31,31,24,24,24,24,25,25,16,16,29,29,16,16,14,14,16,16,25,25,29,29,18,18,9,9,12,12,13,13,10,10,17,17,25,25,21,21,30,30,6,6,8,8,13,13,8,8,5,5,5,5,27,27,31,31,22,22,10,10,18,18,22,22,18,18,6,6,4,4,30,30,2,2,17,17,29,29,0,0,25,25,1,1,5,5,3,3,28,28,20,20,29,29,18,18,22,22,14,14,7,7,8,8,18,18,5,5,27,27,4,4,24,24,2,2,0,0,31,31,9,9,16,16,21,21,14,14,17,17,18,18,0,0,29,29,20,20,16,16,16,16,29,29,25,25,1,1,12,12,5,5,13,13,20,20,28,28,19,19,31,31,5,5,5,5,18,18,21,21,13,13,17,17,19,19,18,18,8,8,1,1,5,5,0,0,17,17,2,2,29,29,2,2,19,19,11,11,18,18,25,25,31,31,11,11,6,6,8,8,13,13,9,9,14,14,7,7,24,24,3,3,9,9,13,13,1,1,26,26,20,20,0,0,3,3,13,13,31,31,10,10,24,24,4,4,7,7,12,12,19,19,13,13,12,12,11,11,25,25,13,13,12,12,28,28,5,5,3,3,4,4,0,0,16,16,5,5,0,0,20,20,11,11,2,2,7,7,9,9,1,1,0,0,8,8,30,30,10,10,16,16,2,2,19,19,13,13,8,8,0,0,8,8,28,28,19,19,0,0,19,19,28,28,30,30,27,27,3,3,10,10,5,5,1,1,17,17,11,11,10,10,5,5,20,20,1,1,17,17,27,27,1,1,23,23,6,6,18,18,5,5,16,16,14,14,30,30,8,8,17,17,1,1,17,17,13,13,6,6,2,2,26,26,2,2,2,2,7,7,16,16,6,6,21,21,27,27,18,18,13,13,27,27,27,27,3,3,12,12,30,30,6,6,17,17,23,23,18,18,3,3,10,10,21,21,11,11,18,18,28,28,20,20,5,5,11,11,1,1,13,13,20,20,14,14,25,25,13,13,31,31,21,21,26,26,4,4,16,16,4,4,28,28,29,29,12,12,15,15,6,6,6,6,26,26,18,18,3,3,18,18,0,0,7,7,2,2,24,24,13,13,14,14,28,28,12,12,9,9,1,1,10,10,4,4,24,24,21,21,31,31,26,26,3,3,15,15,0,0,20,20,7,7,26,26,12,12,14,14,18,18,28,28,27,27,3,3,18,18,3,3,28,28,9,9,22,22,30,30,6,6,0,0,2,2,13,13,24,24,1,1,5,5,17,17,8,8,12,12,23,23,20,20,18,18,10,10,0,0,13,13,28,28,7,7,12,12,6,6,29,29,15,15,1,1,9,9,26,26,14,14,30,30,12,12,13,13,5,5,20,20,13,13,12,12,30,30,30,30,31,31,23,23,15,15,28,28,30,30,29,29,18,18,1,1,12,12,13,13,16,16,16,16,4,4,17,17,24,24,0,0,22,22,13,13,16,16,19,19,18,18,25,25,8,8,5,5,24,24,12,12,0,0,17,17,12,12,20,20,14,14,3,3,28,28,28,28,16,16,25,25,22,22,12,12,2,2,0,0,12,12,16,16,9,9,17,17,26,26,19,19,13,13,19,19,26,26,23,23,26,26,19,19,0,0,8,8,22,22,19,19,10,10,29,29,8,8,20,20,1,1,28,28,15,15,25,25,14,14,4,4,13,13,17,17,27,27,29,29,16,16,12,12,1,1,16,16,1,1,18,18,0,0,27,27,6,6,12,12,12,12,8,8,26,26,19,19,23,23,22,22,21,21,0,0,18,18,20,20,25,25,30,30,12,12,27,27,16,16,9,9,29,29,4,4,5,5,31,31,18,18,3,3,21,21,8,8,26,26,20,20,13,13,20,20,25,25,20,20,17,17,6,6,0,0,20,20,24,24,13,13,7,7,18,18,27,27,9,9,30,30,5,5,0,0,23,23,13,13,27,27,18,18,0,0,30,30,18,18,19,19,5,5,18,18,23,23,5,5,1,1,12,12,0,0,19,19,18,18,5,5,17,17,15,15,27,27,1,1,17,17,7,7,28,28,16,16,15,15,0,0,8,8,24,24,31,31,26,26,3,3,17,17,31,31,15,15,22,22,7,7,27,27,10,10,13,13,25,25,7,7,31,31,27,27,16,16,30,30,11,11,30,30,14,14,2,2,12,12,14,14,25,25,0,0,17,17,6,6,15,15,12,12,7,7,10,10,5,5,1,1,27,27,31,31,25,25,2,2,26,26,24,24,15,15,14,14,15,15,19,19,0,0,11,11,20,20,0,0,7,7,16,16,20,20,2,2,2,2,24,24,17,17,3,3,12,12,10,10,9,9,13,13,8,8,30,30,29,29,15,15,1,1,26,26,21,21,7,7,5,5,17,17,12,12,17,17,23,23,18,18,18,18,6,6,1,1,9,9,2,2,14,14,8,8,19,19,3,3,0,0,30,30,29,29,15,15,2,2,4,4,2,2,18,18,22,22,13,13,7,7,30,30,21,21,9,9,29,29,24,24,18,18,3,3,24,24,12,12,22,22,5,5,28,28,8,8,8,8,29,29,9,9,7,7,31,31,4,4,20,20,23,23,21,21,23,23,13,13,20,20,11,11,8,8,30,30,1,1,18,18,26,26,17,17,18,18,15,15,5,5,24,24,27,27,3,3,2,2,29,29,10,10,24,24,8,8,24,24,9,9,18,18,12,12,23,23,14,14,8,8,12,12,31,31,4,4,6,6,20,20,3,3,28,28,12,12,16,16,14,14,24,24,20,20,22,22,9,9,22,22,24,24,6,6,27,27,3,3,6,6,9,9,27,27,28,28,26,26,7,7,15,15,18,18,19,19,13,13,22,22,6,6,5,5,11,11,2,2,12,12,8,8,27,27,25,25,28,28,0,0,7,7,18,18,7,7,20,20,8,8,31,31,25,25,16,16,10,10,2,2,4,4,17,17,5,5,12,12,28,28,8,8,22,22,8,8,22,22,9,9,12,12,13,13,20,20,6,6,24,24,30,30,16,16,18,18,27,27,27,27,8,8,11,11,3,3,13,13,24,24,28,28,28,28,3,3,24,24,12,12,18,18,19,19,25,25,7,7,30,30,3,3,26,26,17,17,14,14,19,19,1,1,18,18,21,21,30,30,29,29,13,13,11,11,10,10,27,27,17,17,5,5,2,2,20,20,2,2,16,16,17,17,12,12,20,20,24,24,21,21,3,3,1,1,31,31,31,31,26,26,12,12,6,6,11,11,11,11,23,23,1,1,17,17,16,16,24,24,5,5,13,13,12,12,8,8,1,1,19,19,18,18,8,8,25,25,6,6,10,10,17,17,22,22,2,2,31,31,2,2,31,31,21,21,19,19,1,1,23,23,24,24,27,27,3,3,30,30,7,7,13,13,12,12,28,28,24,24,8,8,24,24,27,27,22,22,11,11,11,11,19,19,24,24,16,16,9,9,27,27,28,28,20,20,4,4,13,13,29,29,6,6,16,16,27,27,17,17,25,25,19,19,29,29,25,25,10,10,14,14,10,10,8,8,25,25,21,21,24,24,17,17,16,16,20,20,24,24,10,10,17,17,18,18,11,11,7,7,14,14,12,12,6,6,14,14,4,4,27,27,21,21,3,3,24,24,8,8,22,22,7,7,0,0,9,9,30,30,31,31,7,7,8,8,21,21,6,6,11,11,13,13,12,12,5,5,0,0,6,6,4,4,19,19,12,12,25,25,25,25,13,13,31,31,14,14,0,0,21,21,12,12,12,12,9,9,13,13,7,7,9,9,27,27,12,12,0,0,16,16,11,11,12,12,21,21,2,2,16,16,9,9,23,23,17,17,21,21,29,29,5,5,13,13,13,13,2,2,20,20,12,12,11,11,18,18,4,4,9,9,4,4,28,28,6,6,29,29,7,7,9,9,21,21,27,27,3,3,10,10,17,17,3,3,7,7,11,11,9,9,0,0,7,7,5,5,16,16,20,20,21,21,5,5,30,30,14,14,2,2,1,1,27,27,26,26,4,4,26,26,0,0,3,3,25,25,7,7,25,25,25,25,4,4,16,16,1,1,13,13,27,27,27,27,28,28,5,5,20,20,17,17,28,28,16,16,16,16,30,30,8,8,19,19,7,7,20,20,17,17,2,2,18,18,3,3,25,25,19,19,6,6,3,3,27,27,18,18,7,7,10,10,17,17,20,20,11,11,1,1,22,22,7,7,15,15,9,9,4,4,4,4,23,23,20,20,11,11,6,6,10,10,15,15,6,6,30,30,29,29,6,6,0,0,10,10,8,8,23,23,9,9,20,20,23,23,23,23,23,23,4,4,27,27,25,25,6,6,22,22,4,4,10,10,9,9,27,27,4,4,4,4,8,8,31,31,27,27,21,21,17,17,24,24,18,18,25,25,21,21,22,22,28,28,23,23,13,13,5,5,1,1,7,7,26,26,6,6,20,20,17,17,29,29,24,24,13,13,2,2,27,27,7,7,30,30,2,2,25,25,9,9,31,31,23,23,28,28,30,30,9,9,5,5,12,12,19,19,3,3,3,3,16,16,25,25,3,3,29,29,10,10,22,22,21,21,18,18,21,21,18,18,5,5,24,24,15,15,20,20,7,7,9,9,9,9,6,6,31,31,9,9,22,22,12,12,17,17,2,2,5,5,27,27,10,10,13,13,4,4,27,27,24,24,7,7,9,9,18,18,14,14,26,26,26,26,1,1,22,22,5,5,31,31,6,6,12,12,6,6,31,31,1,1,28,28,9,9,17,17,10,10,14,14,5,5,29,29,1,1,9,9,27,27,0,0,24,24,20,20,26,26,28,28,14,14,20,20,8,8,28,28,21,21,21,21,12,12,9,9,10,10,25,25,27,27,20,20,3,3,28,28,17,17,24,24,31,31,25,25,12,12,11,11,6,6,1,1,24,24,20,20,26,26,8,8,10,10,1,1,29,29,10,10,28,28,14,14,10,10,30,30,6,6,31,31,9,9,27,27,15,15,20,20,10,10,20,20,21,21,5,5,22,22,18,18,7,7,14,14,15,15,25,25,0,0,27,27,1,1,28,28,4,4,28,28,15,15,5,5,30,30,20,20,19,19,18,18,18,18,5,5,11,11,3,3,9,9,31,31,9,9,24,24,5,5,21,21,20,20,21,21,8,8,5,5,2,2,9,9,28,28,25,25,3,3,4,4,0,0,16,16,21,21,11,11,16,16,22,22,1,1,10,10,27,27,27,27,23,23,4,4,25,25,10,10,1,1,13,13,29,29,11,11,1,1,10,10,16,16,6,6,18,18,27,27,12,12,29,29,22,22,8,8,17,17,21,21,24,24,5,5,2,2,28,28,3,3,9,9,4,4,26,26,5,5,11,11,25,25,16,16,25,25,28,28,23,23,1,1,7,7,16,16,18,18,4,4,15,15,12,12,8,8,2,2,13,13,12,12,0,0,14,14,15,15,22,22,28,28,22,22,19,19,29,29,26,26,16,16,24,24,25,25,7,7,13,13,28,28,11,11,9,9,31,31,12,12,10,10,18,18,11,11,17,17,7,7,28,28,3,3,14,14,30,30,26,26,30,30,6,6,24,24,18,18,16,16,27,27,29,29,26,26,12,12,13,13,24,24,21,21,25,25,22,22,26,26,11,11,19,19,16,16,1,1,26,26,28,28,2,2,9,9,22,22,23,23,3,3,28,28,31,31,26,26,9,9,1,1,3,3,8,8,28,28,16,16,3,3,9,9,12,12,25,25,14,14,2,2,8,8,8,8,22,22,13,13,25,25,27,27,18,18,27,27,9,9,7,7,10,10,24,24,20,20,13,13,17,17,1,1,26,26,27,27,14,14,29,29,27,27,0,0,5,5,0,0,21,21,1,1,0,0,4,4,1,1,0,0,4,4,4,4,29,29,22,22,22,22,10,10,6,6,18,18,6,6,31,31,31,31,8,8,5,5,15,15,14,14,25,25,1,1,6,6,4,4,3,3,31,31,16,16,22,22,19,19,22,22,29,29,4,4,9,9,23,23,11,11,7,7,23,23,4,4,25,25,20,20,18,18,23,23,2,2,24,24,11,11,15,15,8,8,30,30,7,7,12,12,15,15,16,16,18,18,18,18,5,5,23,23,4,4,13,13,29,29,4,4,1,1,6,6,9,9,29,29,2,2,20,20,19,19,18,18,20,20,29,29,26,26,10,10,6,6,1,1,13,13,21,21,1,1,12,12,17,17,19,19,24,24,23,23,24,24,9,9,8,8,29,29,3,3,31,31,21,21,5,5,28,28,22,22,23,23,29,29,13,13,17,17,13,13,6,6,18,18,16,16,7,7,4,4,3,3,30,30,2,2,0,0,8,8,25,25,24,24,20,20,30,30,22,22,7,7,2,2,22,22,16,16,10,10,29,29,6,6,12,12,2,2,14,14,24,24,4,4,31,31,30,30,26,26,29,29,25,25,26,26,20,20,22,22,7,7,11,11,6,6,26,26,5,5,8,8,28,28,31,31,15,15,20,20,30,30,2,2,0,0,10,10,24,24,6,6,17,17,3,3,22,22,27,27,20,20,0,0,10,10,14,14,13,13,24,24,1,1,10,10,26,26,26,26,15,15,6,6,13,13,22,22,18,18,26,26,16,16,6,6,6,6,23,23,28,28,2,2,13,13,30,30,9,9,17,17,20,20,9,9,7,7,7,7,7,7,4,4,17,17,22,22,7,7,21,21,4,4,8,8,2,2,7,7,2,2,14,14,18,18,7,7,8,8,20,20,16,16,10,10,7,7,12,12,9,9,3,3,24,24,16,16,29,29,10,10,2,2,22,22,3,3,10,10,21,21,30,30,25,25,23,23,23,23,9,9,6,6,23,23,8,8,1,1,18,18,6,6,3,3,26,26,0,0,18,18,19,19,28,28,20,20,4,4,5,5,30,30,4,4,11,11,30,30,28,28,17,17,12,12,14,14,8,8,21,21,7,7,9,9,16,16,0,0,21,21,14,14,27,27,6,6,21,21,13,13,16,16,7,7,0,0,26,26,5,5,6,6,11,11,12,12,4,4,8,8,28,28,3,3,21,21,1,1,10,10,27,27,31,31,19,19,21,21,21,21,25,25,4,4,4,4,23,23,26,26,5,5,6,6,14,14,2,2,20,20,15,15,16,16,3,3,24,24,22,22,20,20,15,15,0,0,22,22,3,3,2,2,3,3,7,7,25,25,1,1,22,22,16,16,25,25,6,6,26,26,6,6,6,6,16,16,16,16,13,13,28,28,28,28,23,23,8,8,19,19,22,22,11,11,12,12,3,3,11,11,27,27,29,29,4,4,22,22,11,11,17,17,31,31,26,26,29,29,7,7,0,0,3,3,1,1,30,30,17,17,11,11,12,12,15,15,0,0,8,8,26,26,4,4,19,19,6,6,19,19,0,0,11,11,6,6,24,24,14,14,9,9,7,7,24,24,31,31,28,28,9,9,14,14,18,18,8,8,17,17,23,23,7,7,15,15,26,26,10,10,27,27,27,27,7,7,18,18,8,8,15,15,1,1,27,27,9,9,6,6,23,23,21,21,26,26,2,2,4,4,14,14,15,15,31,31,3,3,31,31,17,17,8,8,20,20,0,0,8,8,14,14,8,8,2,2,30,30,15,15,7,7,8,8,15,15,7,7,6,6,29,29,5,5,24,24,29,29,28,28,2,2,26,26,11,11,7,7,2,2,16,16,18,18,1,1,20,20,10,10,29,29,30,30,5,5,6,6,6,6,0,0,30,30,7,7,11,11,22,22,12,12,16,16,12,12,23,23,31,31,0,0,28,28,20,20,13,13,25,25,10,10,15,15,10,10,14,14,1,1,4,4,1,1,30,30,23,23,5,5,25,25,14,14,19,19,24,24,4,4,7,7,10,10,6,6,3,3,19,19,22,22,30,30,5,5,1,1,11,11,19,19,7,7,29,29,1,1,16,16,17,17,3,3,31,31,16,16,7,7,1,1,4,4,4,4,10,10,15,15,13,13,7,7,1,1,6,6,30,30,21,21,13,13,8,8,28,28,17,17,0,0,0,0,28,28,0,0,7,7,14,14,6,6,12,12,20,20,19,19,5,5,1,1,4,4,8,8,25,25,17,17,16,16,18,18,22,22,21,21,28,28,8,8,8,8,28,28,10,10,29,29,4,4,0,0,13,13,31,31,21,21,17,17,21,21,16,16,2,2,28,28,26,26,14,14,26,26,26,26,9,9,7,7,18,18,20,20,18,18,7,7,4,4,26,26,16,16,23,23,4,4,25,25,11,11,5,5,13,13,1,1,23,23,3,3,4,4,12,12,16,16,11,11,30,30,20,20,5,5,17,17,27,27,9,9,11,11,16,16,8,8,5,5,4,4,16,16,11,11,10,10,13,13,20,20,0,0,21,21,13,13,27,27,2,2,26,26,9,9,2,2,21,21,22,22,4,4,12,12,15,15,11,11,9,9,4,4,21,21,28,28,8,8,1,1,8,8,1,1,29,29,18,18,5,5,15,15,28,28,24,24,14,14,8,8,6,6,15,15,1,1,24,24,5,5,22,22,13,13,27,27,5,5,31,31,11,11,8,8,12,12,18,18,3,3,19,19,16,16,20,20,15,15,3,3,22,22,17,17,7,7,29,29,23,23,31,31,15,15,23,23,26,26,2,2,0,0,16,16,29,29,12,12,30,30,8,8,13,13,22,22,21,21,13,13,0,0,21,21,10,10,28,28,28,28,30,30,28,28,6,6,5,5,10,10,6,6,16,16,17,17,26,26,0,0,2,2,28,28,10,10,4,4,1,1,6,6,16,16,3,3,25,25,6,6,19,19,0,0,15,15,18,18,5,5,3,3,25,25,9,9,22,22,17,17,4,4,25,25,3,3,1,1,21,21,29,29,28,28,25,25,9,9,0,0,17,17,0,0,25,25,4,4,21,21,22,22,18,18,22,22,11,11,5,5,8,8,10,10,3,3,13,13,23,23,3,3,24,24,29,29,15,15,6,6,13,13,19,19,26,26,8,8,29,29,22,22,25,25,21,21,11,11,19,19,17,17,28,28,23,23,5,5,3,3,25,25,25,25,7,7,11,11,24,24,14,14,9,9,18,18,8,8,9,9,1,1,24,24,25,25,13,13,25,25,10,10,27,27,1,1,22,22,23,23,5,5,23,23,20,20,10,10,26,26,28,28,26,26,5,5,17,17,14,14,3,3,8,8,7,7,3,3,8,8,12,12,28,28,12,12,12,12,24,24,22,22,12,12,26,26,8,8,24,24,19,19,3,3,31,31,26,26,18,18,30,30,15,15,9,9,18,18,6,6,1,1,0,0,3,3,16,16,16,16,3,3,6,6,6,6,29,29,23,23,30,30,19,19,7,7,20,20,27,27,21,21,19,19,3,3,2,2,3,3,18,18,8,8,31,31,23,23,18,18,17,17,22,22,2,2,7,7,12,12,0,0,10,10,5,5,7,7,11,11,30,30,24,24,24,24,12,12,1,1,5,5,26,26,5,5,5,5,17,17,7,7,5,5,0,0,9,9,24,24,23,23,17,17,21,21,7,7,21,21,19,19,10,10,27,27,6,6,10,10,14,14,25,25,0,0,13,13,2,2,15,15,11,11,23,23,28,28,2,2,4,4,7,7,26,26,2,2,31,31,0,0,19,19,1,1,14,14,26,26,14,14,27,27,8,8,24,24,0,0,24,24,29,29,15,15,21,21,6,6,24,24,23,23,27,27,14,14,9,9,7,7,21,21,11,11,7,7,12,12,22,22,21,21,25,25,19,19,5,5,31,31,18,18,27,27,13,13,12,12,12,12,0,0,20,20,13,13,8,8,24,24,30,30,30,30,19,19,6,6,8,8,18,18,0,0,19,19,8,8,16,16,15,15,12,12,16,16,5,5,28,28,20,20,24,24,2,2,2,2,22,22,23,23,16,16,30,30,10,10,18,18,17,17,30,30,15,15,6,6,28,28,26,26,24,24,4,4,10,10,0,0,21,21,9,9,2,2,30,30,17,17,9,9,10,10,8,8,4,4,15,15,30,30,10,10,23,23,9,9,16,16,14,14,3,3,20,20,12,12,17,17,4,4,25,25,8,8,6,6,11,11,6,6,13,13,18,18,6,6,16,16,9,9,13,13,31,31,3,3,14,14,16,16,6,6,18,18,7,7,20,20,11,11,3,3,5,5,30,30,0,0,15,15,9,9,22,22,22,22,26,26,21,21,18,18,9,9,24,24,0,0,29,29,2,2,3,3,1,1,24,24,9,9,17,17,25,25,30,30,12,12,0,0,25,25,8,8,21,21,16,16,8,8,5,5,22,22,21,21,31,31,16,16,16,16,29,29,22,22,27,27,31,31,2,2,20,20,6,6,6,6,22,22,7,7,20,20,16,16,7,7,1,1,24,24,0,0,0,0,6,6,21,21,4,4,27,27,18,18,11,11,13,13,0,0,26,26,0,0,12,12,2,2,11,11,17,17,24,24,22,22,15,15,9,9,23,23,25,25,5,5,9,9,31,31,31,31,16,16,7,7,30,30,20,20,11,11,1,1,21,21,10,10,20,20,30,30,28,28,26,26,25,25,31,31,12,12,10,10,27,27,14,14,21,21,11,11,29,29,8,8,5,5,0,0,12,12,19,19,13,13,23,23,4,4,10,10,21,21,29,29,23,23,0,0,11,11,22,22,4,4,22,22,7,7,2,2,4,4,4,4,3,3,25,25,14,14,16,16,28,28,29,29,12,12,26,26,6,6,6,6,5,5,16,16,25,25,19,19,10,10,6,6,0,0,1,1,22,22,8,8,11,11,22,22,29,29,23,23,11,11,11,11,15,15,16,16,6,6,2,2,7,7,13,13,29,29,5,5,23,23,5,5,12,12,10,10,11,11,29,29,27,27,5,5,14,14,13,13,6,6,29,29,13,13,11,11,28,28,26,26,2,2,16,16,10,10,24,24,6,6,25,25,28,28,18,18,9,9,10,10,26,26,13,13,4,4,7,7,19,19,7,7,7,7,16,16,19,19,0,0,20,20,13,13,7,7,27,27,4,4,15,15,20,20,15,15,25,25,11,11,10,10,16,16,8,8,8,8,8,8,3,3,4,4,16,16,12,12,5,5,13,13,18,18,24,24,19,19,0,0,30,30,10,10,5,5,3,3,5,5,29,29,24,24,26,26,8,8,16,16,19,19,20,20,24,24,8,8,28,28,10,10,25,25,4,4,14,14,12,12,24,24,16,16,21,21,24,24,2,2,8,8,23,23,9,9,10,10,8,8,20,20,5,5,1,1,2,2,27,27,21,21,0,0,1,1,18,18,3,3,28,28,2,2,19,19,26,26,25,25,12,12,28,28,18,18,27,27,13,13,3,3,3,3,24,24,4,4,25,25,9,9,2,2,28,28,25,25,8,8,20,20,8,8,19,19,16,16,4,4,20,20,2,2,28,28,22,22,17,17,1,1,12,12,1,1,9,9,4,4,17,17,17,17,16,16,15,15,20,20,24,24,20,20,2,2,28,28,9,9,29,29,7,7,21,21,8,8,2,2,24,24,15,15,21,21,9,9,1,1,21,21,30,30,20,20,16,16,4,4,14,14,16,16,29,29,5,5,2,2,17,17,13,13,14,14,21,21,12,12,13,13,14,14,28,28,8,8,7,7,0,0,4,4,18,18,25,25,7,7,23,23,16,16,24,24,5,5,30,30,19,19,17,17,31,31,5,5,11,11,17,17,9,9,3,3,0,0,4,4,3,3,11,11,7,7,21,21,11,11,26,26,20,20,28,28,29,29,14,14,19,19,17,17,22,22,19,19,21,21,9,9,28,28,22,22,25,25,17,17,1,1,13,13,17,17,24,24,31,31,1,1,0,0,11,11,2,2,12,12,4,4,27,27,1,1,30,30,1,1,2,2,16,16,19,19,28,28,3,3,3,3,28,28,3,3,16,16,3,3,26,26,14,14,3,3,2,2,21,21,2,2,31,31,13,13,5,5,16,16,4,4,18,18,21,21,15,15,15,15,24,24,29,29,11,11,6,6,16,16,22,22,14,14,6,6,21,21,15,15,16,16,26,26,25,25,22,22,3,3,24,24,23,23,17,17,5,5,7,7,11,11,9,9,9,9,3,3,2,2,16,16,7,7,29,29,16,16,20,20,18,18,30,30,27,27,1,1,26,26,21,21,31,31,5,5,26,26,22,22,7,7,26,26,26,26,10,10,14,14,3,3,0,0,19,19,25,25,26,26,27,27,16,16,15,15,2,2,2,2,31,31,6,6,22,22,10,10,2,2,14,14,31,31,23,23,5,5,29,29,22,22,13,13,0,0,25,25,30,30,20,20,22,22,15,15,3,3,2,2,16,16,9,9,6,6,5,5,12,12,1,1,23,23,24,24,31,31,5,5,13,13,3,3,26,26,10,10,13,13,9,9,30,30,20,20,10,10,12,12,3,3,26,26,26,26,1,1,7,7,31,31,24,24,0,0,9,9,15,15,2,2,16,16,21,21,13,13,26,26,1,1,21,21,29,29,25,25,2,2,19,19,12,12,9,9,15,15,18,18,9,9,14,14,1,1,20,20,31,31,7,7,21,21,23,23,0,0,3,3,0,0,21,21,7,7,9,9,16,16,0,0,24,24,4,4,8,8,12,12,27,27,13,13,0,0,28,28,1,1,15,15,5,5,1,1,0,0,14,14,24,24,29,29,6,6,2,2,20,20,16,16,19,19,19,19,10,10,12,12,20,20,20,20,8,8,8,8,14,14,12,12,12,12,6,6,21,21,13,13,21,21,7,7,30,30,16,16,30,30,0,0,29,29,28,28,31,31,18,18,5,5,17,17,0,0,20,20,29,29,20,20,18,18,24,24,20,20,26,26,21,21,17,17,5,5,16,16,2,2,22,22,6,6,26,26,23,23,1,1,14,14,29,29,18,18,6,6,10,10,23,23,1,1,23,23,30,30,16,16,4,4,21,21,4,4,6,6,30,30,29,29,0,0,14,14,22,22,5,5,3,3,27,27,20,20,10,10,1,1,2,2,27,27,3,3,20,20,30,30,24,24,2,2,14,14,8,8,9,9,12,12,27,27,2,2,12,12,8,8,0,0,30,30,20,20,18,18,17,17,9,9,6,6,3,3,31,31,6,6,20,20,5,5,2,2,7,7,9,9,4,4,5,5,5,5,15,15,5,5,9,9,5,5,23,23,30,30,5,5,30,30,19,19,5,5,19,19,24,24,8,8,16,16,2,2,18,18,12,12,16,16,2,2,25,25,1,1,27,27,7,7,2,2,22,22,4,4,1,1,28,28,3,3,28,28,10,10,26,26,5,5,25,25,18,18,26,26,6,6,29,29,4,4,18,18,21,21,7,7,0,0,25,25,23,23,3,3,17,17,15,15,23,23,12,12,11,11,20,20,19,19,1,1,16,16,24,24,3,3,13,13,27,27,23,23,19,19,23,23,21,21,16,16,7,7,10,10,16,16,31,31,14,14,22,22,25,25,11,11,16,16,21,21,2,2,10,10,20,20,23,23,1,1,16,16,5,5,2,2,25,25,28,28,10,10,31,31,13,13,28,28,11,11,4,4,22,22,26,26,17,17,27,27,21,21,15,15,1,1,20,20,11,11,18,18,2,2,5,5,12,12,30,30,3,3,11,11,22,22,2,2,23,23,1,1,5,5,7,7,20,20,16,16,21,21,29,29,16,16,18,18,3,3,3,3,11,11,3,3,11,11,2,2,25,25,27,27,29,29,8,8,31,31,11,11,19,19,26,26,16,16,20,20,10,10,0,0,27,27,0,0,6,6,21,21,0,0,30,30,4,4,17,17,6,6,7,7,9,9,29,29,28,28,16,16,16,16,5,5,13,13,13,13,4,4,29,29,21,21,4,4,7,7,24,24,24,24,9,9,14,14,20,20,18,18,31,31,12,12,25,25,6,6,6,6,10,10,3,3,7,7,25,25,22,22,9,9,3,3,7,7,24,24,18,18,5,5,0,0,26,26,8,8,10,10,15,15,3,3,13,13,21,21,7,7,16,16,15,15,9,9,22,22,16,16,10,10,8,8,13,13,9,9,22,22,25,25,18,18,20,20,23,23,18,18,8,8,25,25,4,4,10,10,22,22,28,28,23,23,4,4,7,7,5,5,4,4,5,5,7,7,2,2,3,3,11,11,14,14,19,19,19,19,23,23,2,2,1,1,21,21,23,23,7,7,29,29,14,14,23,23,17,17,11,11,16,16,9,9,17,17,10,10,16,16,3,3,30,30,10,10,16,16,27,27,13,13,25,25,30,30,3,3,6,6,5,5,25,25,3,3,0,0,14,14,17,17,16,16,11,11,2,2,2,2,1,1,14,14,31,31,1,1,0,0,9,9,8,8,24,24,1,1,1,1,16,16,30,30,9,9,8,8,18,18,31,31,6,6,15,15,7,7,21,21,11,11,7,7,16,16,9,9,1,1,7,7,5,5,24,24,16,16,17,17,5,5,3,3,7,7,29,29,5,5,24,24,9,9,1,1,17,17,2,2,4,4,4,4,20,20,17,17,11,11,13,13,28,28,2,2,20,20,7,7,16,16,30,30,2,2,12,12,16,16,17,17,18,18,14,14,21,21,9,9,8,8,8,8,24,24,2,2,18,18,31,31,29,29,5,5,11,11,5,5,5,5,11,11,9,9,8,8,4,4,29,29,7,7,12,12,11,11,1,1,17,17,20,20,12,12,19,19,2,2,19,19,18,18,1,1,15,15,25,25,23,23,26,26,13,13,12,12,1,1,7,7,9,9,1,1,2,2,19,19,22,22,28,28,1,1,31,31,14,14,14,14,29,29,14,14,4,4,24,24,17,17,9,9,2,2,28,28,0,0,19,19,28,28,31,31,22,22,8,8,3,3,10,10,9,9,0,0,15,15,4,4,1,1,20,20,24,24,0,0,7,7,1,1,24,24,11,11,31,31,25,25,23,23,25,25,24,24,6,6,1,1,12,12,24,24,27,27,24,24,18,18,11,11,20,20,26,26,0,0,30,30,22,22,23,23,5,5,11,11,30,30,11,11,25,25,4,4,29,29,26,26,22,22,17,17,2,2,24,24,3,3,10,10,16,16,8,8,17,17,25,25,22,22,1,1,4,4,2,2,12,12,1,1,4,4,4,4,4,4,12,12,18,18,31,31,27,27,24,24,25,25,6,6,28,28,10,10,8,8,28,28,25,25,20,20,10,10,24,24,6,6,15,15,5,5,8,8,1,1,8,8,27,27,25,25,22,22,13,13,20,20,8,8,26,26,4,4,21,21,1,1,18,18,23,23,18,18,17,17,20,20,9,9,8,8,30,30,5,5,21,21,30,30,12,12,1,1,27,27,11,11,19,19,20,20,0,0,1,1,2,2,27,27,10,10,11,11,11,11,10,10,26,26,24,24,25,25,28,28,15,15,2,2,3,3,31,31,2,2,15,15,29,29,15,15,6,6,21,21,23,23,16,16,23,23,29,29,25,25,20,20,27,27,5,5,7,7,13,13,14,14,24,24,26,26,19,19,3,3,15,15,17,17,18,18,0,0,26,26,31,31,28,28,17,17,23,23,20,20,19,19,1,1,5,5,7,7,5,5,19,19,12,12,24,24,27,27,11,11,30,30,7,7,13,13,29,29,25,25,25,25,22,22,22,22,22,22,11,11,14,14,22,22,12,12,24,24,3,3,18,18,0,0,14,14,31,31,1,1,23,23,11,11,26,26,19,19,23,23,19,19,5,5,9,9,3,3,18,18,28,28,16,16,14,14,5,5,8,8,16,16,1,1,7,7,1,1,25,25,10,10,28,28,25,25,19,19,12,12,10,10,17,17,4,4,21,21,3,3,10,10,19,19,1,1,11,11,17,17,23,23,18,18,6,6,31,31,25,25,14,14,21,21,30,30,8,8,25,25,1,1,19,19,10,10,6,6,10,10,31,31,2,2,26,26,23,23,12,12,25,25,9,9,1,1,0,0,10,10,31,31,14,14,29,29,18,18,19,19,29,29,13,13,4,4,8,8,14,14,4,4,27,27,30,30,19,19,23,23,19,19,19,19,9,9,14,14,20,20,25,25,28,28,25,25,7,7,10,10,9,9,17,17,16,16,25,25,2,2,10,10,0,0,21,21,0,0,15,15,12,12,4,4,26,26,17,17,13,13,28,28,12,12,18,18,9,9,28,28,0,0,9,9,8,8,13,13,16,16,16,16,17,17,28,28,20,20,5,5,18,18,19,19,13,13,1,1,15,15,11,11,6,6,29,29,17,17,19,19,0,0,19,19,13,13,0,0,5,5,4,4,28,28,31,31,17,17,28,28,10,10,4,4,23,23,23,23,30,30,19,19,2,2,2,2,15,15,4,4,28,28,26,26,8,8,19,19,1,1,3,3,24,24,9,9,28,28,1,1,13,13,4,4,21,21,26,26,29,29,13,13,2,2,3,3,6,6,21,21,5,5,0,0,31,31,12,12,13,13,10,10,7,7,3,3,2,2,1,1,25,25,16,16,3,3,19,19,29,29,28,28,3,3,16,16,24,24,25,25,8,8,1,1,15,15,1,1,1,1,26,26,27,27,0,0,14,14,9,9,9,9,17,17,10,10,0,0,9,9,16,16,25,25,28,28,14,14,20,20,25,25,3,3,1,1,4,4,2,2,28,28,2,2,3,3,1,1,8,8,5,5,1,1,1,1,17,17,12,12,10,10,19,19,3,3,16,16,20,20,15,15,17,17,15,15,18,18,8,8,2,2,0,0,12,12,7,7,25,25,6,6,14,14,27,27,0,0,14,14,16,16,17,17,11,11,21,21,20,20,22,22,0,0,17,17,11,11,1,1,26,26,15,15,26,26,4,4,22,22,30,30,2,2,5,5,21,21,28,28,0,0,25,25,5,5,15,15,1,1,8,8,17,17,10,10,4,4,31,31,10,10,26,26,0,0,12,12,10,10,29,29,12,12,17,17,1,1,19,19,29,29,3,3,10,10,16,16,16,16,18,18,3,3,26,26,18,18,2,2,31,31,1,1,7,7,19,19,17,17,21,21,23,23,3,3,13,13,0,0,7,7,18,18,8,8,10,10,7,7,4,4,6,6,15,15,6,6,13,13,13,13,25,25,16,16,28,28,29,29,10,10,16,16,28,28,17,17,8,8,8,8,5,5,24,24,26,26,11,11,28,28,16,16,1,1,23,23,18,18,15,15,26,26,0,0,22,22,21,21,13,13,5,5,22,22,27,27,18,18,0,0,10,10,15,15,7,7,29,29,17,17,8,8,7,7,10,10,17,17,6,6,19,19,14,14,0,0,4,4,8,8,30,30,8,8,18,18,6,6,10,10,0,0,28,28,2,2,20,20,31,31,24,24,25,25,18,18,15,15,13,13,21,21,13,13,14,14,13,13,0,0,30,30,26,26,14,14,8,8,16,16,28,28,7,7,22,22,14,14,19,19,28,28,28,28,11,11,19,19,22,22,17,17,17,17,9,9,29,29,22,22,20,20,12,12,22,22,13,13,3,3,1,1,26,26,30,30,3,3,20,20,5,5,8,8,4,4,23,23,31,31,6,6,12,12,0,0,25,25,15,15,25,25,27,27,5,5,20,20,17,17,19,19,27,27,27,27,29,29,30,30,20,20,3,3,7,7,17,17,28,28,23,23,0,0,20,20,29,29,7,7,2,2,9,9,11,11,29,29,13,13,7,7,20,20,20,20,10,10,18,18,26,26,4,4,2,2,7,7,9,9,26,26,9,9,28,28,17,17,14,14,28,28,28,28,13,13,20,20,21,21,22,22,28,28,24,24,18,18,24,24,0,0,15,15,19,19,22,22,21,21,0,0,28,28,27,27,16,16,8,8,9,9,11,11,25,25,22,22,29,29,30,30,23,23,6,6,24,24,29,29,18,18,28,28,13,13,17,17,16,16,9,9,24,24,11,11,6,6,4,4,28,28,18,18,13,13,2,2,1,1,0,0,23,23,14,14,19,19,25,25,4,4,11,11,8,8,15,15,3,3,10,10,8,8,18,18,24,24,7,7,25,25,9,9,1,1,0,0,3,3,14,14,17,17,13,13,20,20,23,23,27,27,20,20,9,9,2,2,22,22,24,24,29,29,25,25,23,23,24,24,23,23,16,16,17,17,23,23,30,30,29,29,23,23,7,7,13,13,17,17,6,6,20,20,29,29,14,14,16,16,21,21,21,21,9,9,7,7,25,25,28,28,27,27,10,10,23,23,20,20,20,20,2,2,23,23,0,0,26,26,5,5,4,4,28,28,2,2,5,5,14,14,21,21,7,7,17,17,26,26,11,11,2,2,27,27,13,13,28,28,1,1,12,12,5,5,16,16,25,25,15,15,8,8,5,5,28,28,15,15,24,24,4,4,27,27,30,30,8,8,12,12,27,27,29,29,2,2,29,29,29,29,4,4,9,9,2,2,0,0,13,13,24,24,10,10,28,28,30,30,21,21,1,1,29,29,30,30,23,23,17,17,10,10,5,5,27,27,14,14,14,14,0,0,25,25,2,2,9,9,28,28,16,16,26,26,1,1,9,9,10,10,5,5,15,15,24,24,10,10,21,21,0,0,22,22,4,4,0,0,22,22,24,24,12,12,1,1,19,19,6,6,24,24,26,26,7,7,0,0,6,6,17,17,25,25,27,27,6,6,3,3,24,24,27,27,28,28,10,10,20,20,25,25,9,9,12,12,23,23,0,0,13,13,19,19,14,14,17,17,10,10,27,27,2,2,10,10,21,21,31,31,17,17,5,5,15,15,30,30,5,5,27,27,2,2,16,16,28,28,5,5,28,28,19,19,9,9,21,21,7,7,15,15,4,4,17,17,20,20,23,23,26,26,19,19,5,5,12,12,5,5,20,20,8,8,5,5,2,2,5,5,30,30,5,5,28,28,21,21,1,1,28,28,2,2,23,23,14,14,7,7,19,19,0,0,17,17,8,8,11,11,2,2,7,7,19,19,3,3,13,13,18,18,3,3,21,21,17,17,6,6,28,28,26,26,4,4,26,26,28,28,14,14,23,23,29,29,8,8,3,3,1,1,24,24,8,8,4,4,24,24,26,26,26,26,8,8,5,5,1,1,30,30,3,3,10,10,8,8,6,6,25,25,18,18,9,9,2,2,19,19,9,9,15,15,24,24,27,27,11,11,24,24,18,18,11,11,19,19,7,7,15,15,11,11,18,18,5,5,6,6,1,1,18,18,3,3,22,22,19,19,1,1,17,17,13,13,2,2,6,6,27,27,6,6,19,19,21,21,31,31,17,17,19,19,11,11,15,15,0,0,10,10,5,5,2,2,21,21,31,31,16,16,12,12,31,31,29,29,13,13,27,27,12,12,6,6,11,11,3,3,10,10,21,21,22,22,0,0,8,8,12,12,20,20,26,26,29,29,2,2,30,30,17,17,4,4,7,7,13,13,4,4,11,11,26,26,5,5,1,1,9,9,23,23,15,15,6,6,24,24,12,12,22,22,9,9,17,17,8,8,18,18,9,9,26,26,25,25,21,21,21,21,5,5,3,3,11,11,8,8,11,11,19,19,4,4,9,9,9,9,27,27,12,12,4,4,29,29,29,29,19,19,18,18,13,13,20,20,24,24,24,24,28,28,14,14,10,10,11,11,22,22,16,16,23,23,16,16,16,16,28,28,2,2,21,21,5,5,26,26,24,24,10,10,22,22,16,16,20,20,30,30,30,30,20,20,1,1,28,28,19,19,0,0,11,11,8,8,20,20,19,19,16,16,23,23,30,30,13,13,31,31,29,29,6,6,29,29,16,16,18,18,20,20,28,28,19,19,31,31,24,24,25,25,11,11,22,22,19,19,19,19,10,10,23,23,9,9,5,5,21,21,7,7,7,7,16,16,6,6,2,2,12,12,21,21,4,4,10,10,1,1,5,5,24,24,18,18,20,20,11,11,1,1,7,7,27,27,3,3,4,4,2,2,9,9,23,23,7,7,4,4,16,16,8,8,7,7,3,3,8,8,10,10,4,4,23,23,24,24,5,5,11,11,21,21,2,2,26,26,18,18,8,8,7,7,16,16,16,16,12,12,17,17,14,14,1,1,5,5,11,11,10,10,7,7,23,23,24,24,16,16,4,4,24,24,16,16,7,7,14,14,20,20,16,16,18,18,9,9,9,9,17,17,2,2,31,31,30,30,9,9,26,26,6,6,8,8,16,16,7,7,6,6,5,5,1,1,5,5,30,30,3,3,26,26,8,8,0,0,15,15,23,23,14,14,9,9,13,13,28,28,3,3,19,19,22,22,21,21,19,19,13,13,31,31,27,27,9,9,21,21,1,1,25,25,1,1,28,28,25,25,1,1,16,16,1,1,20,20,18,18,14,14,13,13,3,3,17,17,27,27,1,1,15,15,25,25,11,11,18,18,17,17,23,23,17,17,14,14,28,28,28,28,24,24,2,2,30,30,22,22,20,20,20,20,7,7,2,2,6,6,7,7,3,3,25,25,29,29,3,3,2,2,21,21,5,5,31,31,18,18,29,29,4,4,10,10,5,5,10,10,5,5,24,24,19,19,8,8,4,4,13,13,10,10,3,3,22,22,0,0,30,30,12,12,3,3,22,22,19,19,24,24,2,2,17,17,15,15,19,19,19,19,5,5,20,20,7,7,3,3,2,2,11,11,11,11,0,0,7,7,21,21,19,19,26,26,14,14,19,19,5,5,5,5,30,30,31,31,2,2,4,4,24,24,19,19,24,24,15,15,26,26,26,26,25,25,29,29,11,11,2,2,2,2,0,0,15,15,7,7,5,5,21,21,1,1,6,6,28,28,31,31,11,11,16,16,9,9,30,30,0,0,20,20,28,28,27,27,2,2,8,8,26,26,1,1,26,26,1,1,17,17,5,5,8,8,21,21,29,29,8,8,26,26,1,1,18,18,17,17,0,0,11,11,16,16,9,9,27,27,16,16,10,10,0,0,19,19,21,21,19,19,8,8,19,19,9,9,13,13,12,12,0,0,21,21,13,13,22,22,9,9,9,9,12,12,9,9,12,12,10,10,25,25,7,7,12,12,19,19,25,25,16,16,26,26,14,14,9,9,9,9,3,3,14,14,31,31,13,13,11,11,26,26,9,9,9,9,11,11,8,8,23,23,6,6,16,16,2,2,6,6,26,26,20,20,23,23,26,26,16,16,31,31,1,1,18,18,9,9,26,26,15,15,1,1,17,17,12,12,0,0,21,21,18,18,26,26,7,7,20,20,4,4,17,17,17,17,13,13,18,18,5,5,23,23,24,24,15,15,18,18,1,1,28,28,26,26,30,30,3,3,0,0,16,16,14,14,13,13,12,12,12,12,8,8,27,27,19,19,31,31,15,15,26,26,7,7,1,1,5,5,2,2,15,15,12,12,17,17,11,11,10,10,25,25,27,27,29,29,3,3,12,12,6,6,28,28,22,22,6,6,17,17,9,9,1,1,11,11,17,17,28,28,10,10,20,20,25,25,8,8,13,13,3,3,24,24,27,27,4,4,10,10,20,20,18,18,12,12,15,15,22,22,15,15,5,5,21,21,30,30,7,7,15,15,0,0,26,26,29,29,1,1,21,21,1,1,21,21,4,4,21,21,26,26,31,31,13,13,20,20,0,0,8,8,20,20,9,9,10,10,20,20,7,7,25,25,31,31,16,16,13,13,22,22,2,2,28,28,19,19,21,21,8,8,21,21,26,26,30,30,30,30,26,26,17,17,16,16,0,0,30,30,20,20,2,2,13,13,14,14,2,2,31,31,20,20,0,0,30,30,19,19,27,27,25,25,29,29,10,10,3,3,8,8,10,10,23,23,2,2,6,6,17,17,1,1,31,31,13,13,24,24,4,4,0,0,14,14,4,4,19,19,2,2,1,1,30,30,24,24,7,7,18,18,9,9,31,31,29,29,25,25,3,3,1,1,24,24,3,3,26,26,16,16,13,13,4,4,30,30,23,23,19,19,0,0,20,20,6,6,0,0,3,3,18,18,19,19,3,3,2,2,4,4,12,12,19,19,30,30,8,8,16,16,7,7,20,20,6,6,16,16,0,0,28,28,24,24,22,22,8,8,5,5,0,0,5,5,14,14,22,22,0,0,14,14,26,26,6,6,18,18,2,2,7,7,6,6,30,30,29,29,6,6,31,31,2,2,12,12,28,28,19,19,15,15,2,2,19,19,6,6,21,21,15,15,13,13,15,15,30,30,25,25,15,15,2,2,1,1,18,18,16,16,24,24,11,11,8,8,19,19,24,24,11,11,29,29,12,12,19,19,10,10,4,4,8,8,25,25,31,31,25,25,30,30,29,29,19,19,24,24,19,19,3,3,0,0,17,17,19,19,7,7,14,14,14,14,4,4,16,16,27,27,11,11,11,11,9,9,6,6,17,17,12,12,6,6,14,14,3,3,12,12,30,30,9,9,5,5,22,22,10,10,5,5,22,22,25,25,12,12,7,7,0,0,5,5,2,2,20,20,24,24,17,17,20,20,12,12,26,26,14,14,14,14,1,1,16,16,0,0,25,25,18,18,6,6,11,11,8,8,12,12,19,19,18,18,20,20,29,29,17,17,31,31,20,20,26,26,25,25,4,4,24,24,3,3,19,19,5,5,24,24,6,6,20,20,26,26,28,28,22,22,9,9,16,16,17,17,6,6,2,2,19,19,5,5,1,1,11,11,14,14,0,0,29,29,14,14,12,12,5,5,15,15,18,18,18,18,7,7,8,8,17,17,28,28,0,0,6,6,3,3,26,26,20,20,27,27,9,9,3,3,17,17,5,5,1,1,31,31,26,26,22,22,0,0,8,8,8,8,17,17,27,27,23,23,8,8,12,12,13,13,12,12,30,30,16,16,13,13,5,5,12,12,30,30,24,24,23,23,0,0,18,18,19,19,29,29,7,7,17,17,18,18,20,20,2,2,17,17,6,6,24,24,10,10,10,10,25,25,15,15,16,16,19,19,16,16,11,11,0,0,2,2,30,30,28,28,21,21,0,0,23,23,6,6,9,9,28,28,11,11,8,8,5,5,22,22,7,7,21,21,2,2,5,5,11,11,28,28,0,0,11,11,0,0,29,29,17,17,0,0,3,3,4,4,12,12,11,11,11,11,8,8,8,8,23,23,5,5,17,17,4,4,26,26,12,12,13,13,10,10,12,12,26,26,24,24,23,23,28,28,19,19,6,6,31,31,17,17,24,24,13,13,23,23,30,30,1,1,1,1,28,28,13,13,16,16,19,19,3,3,21,21,15,15,6,6,11,11,30,30,20,20,16,16,14,14,2,2,31,31,5,5,31,31,25,25,18,18,7,7,19,19,21,21,27,27,21,21,2,2,4,4,14,14,2,2,28,28,20,20,15,15,18,18,5,5,16,16,3,3,8,8,20,20,26,26,11,11,27,27,0,0,5,5,0,0,20,20,14,14,4,4,31,31,21,21,2,2,13,13,16,16,29,29,8,8,22,22,22,22,10,10,11,11,30,30,17,17,12,12,6,6,28,28,4,4,18,18,29,29,5,5,23,23,21,21,2,2,4,4,20,20,23,23,21,21,19,19,2,2,22,22,3,3,19,19,20,20,21,21,3,3,1,1,22,22,7,7,7,7,26,26,11,11,31,31,18,18,24,24,16,16,17,17,4,4,27,27,15,15,20,20,7,7,29,29,21,21,6,6,18,18,7,7,6,6,19,19,25,25,7,7,12,12,3,3,8,8,17,17,8,8,3,3,10,10,25,25,28,28,25,25,10,10,6,6,15,15,24,24,11,11,18,18,17,17,8,8,9,9,9,9,10,10,4,4,10,10,23,23,26,26,8,8,11,11,10,10,24,24,10,10,11,11,7,7,7,7,24,24,18,18,7,7,24,24,9,9,23,23,11,11,31,31,12,12,30,30,4,4,1,1,23,23,14,14,17,17,5,5,19,19,28,28,0,0,8,8,7,7,29,29,11,11,12,12,11,11,10,10,29,29,25,25,20,20,25,25,28,28,20,20,13,13,16,16,5,5,30,30,14,14,1,1,12,12,12,12,2,2,22,22,16,16,27,27,0,0,16,16,19,19,4,4,24,24,17,17,29,29,25,25,4,4,12,12,30,30,2,2,2,2,4,4,27,27,3,3,10,10,17,17,6,6,24,24,14,14,30,30,0,0,4,4,10,10,8,8,7,7,28,28,25,25,12,12,1,1,18,18,30,30,11,11,9,9,6,6,25,25,4,4,28,28,26,26,6,6,19,19,8,8,16,16,7,7,19,19,31,31,8,8,3,3,13,13,1,1,18,18,19,19,20,20,18,18,15,15,28,28,0,0,7,7,29,29,7,7,17,17,8,8,15,15,13,13,15,15,26,26,12,12,24,24,18,18,29,29,27,27,14,14,31,31,25,25,18,18,2,2,25,25,23,23,15,15,7,7,0,0,14,14,10,10,8,8,30,30,8,8,23,23,29,29,31,31,22,22,1,1,22,22,30,30,3,3,1,1,20,20,30,30,19,19,22,22,17,17,1,1,8,8,6,6,21,21,22,22,24,24,15,15,31,31,13,13,30,30,4,4,0,0,7,7,10,10,20,20,28,28,24,24,17,17,9,9,20,20,5,5,19,19,29,29,2,2,4,4,5,5,28,28,27,27,2,2,25,25,16,16,10,10,5,5,8,8,6,6,24,24,27,27,6,6,24,24,22,22,20,20,16,16,30,30,1,1,5,5,25,25,21,21,6,6,7,7,14,14,7,7,12,12,11,11,13,13,25,25,2,2,3,3,16,16,14,14,2,2,10,10,21,21,4,4,16,16,8,8,15,15,28,28,14,14,7,7,2,2,7,7,14,14,1,1,7,7,12,12,2,2,23,23,8,8,0,0,10,10,21,21,24,24,14,14,25,25,24,24,12,12,5,5,16,16,23,23,8,8,12,12,20,20,9,9,3,3,18,18,27,27,0,0,12,12,21,21,12,12,8,8,16,16,24,24,28,28,31,31,7,7,11,11,9,9,22,22,21,21,22,22,25,25,7,7,13,13,29,29,20,20,24,24,15,15,27,27,2,2,21,21,0,0,19,19,16,16,2,2,27,27,15,15,22,22,17,17,28,28,10,10,27,27,19,19,12,12,0,0,27,27,14,14,1,1,17,17,8,8,8,8,17,17,11,11,29,29,6,6,17,17,23,23,3,3,23,23,10,10,9,9,2,2,14,14,14,14,27,27,11,11,3,3,14,14,20,20,13,13,10,10,6,6,20,20,2,2,31,31,27,27,22,22,2,2,11,11,4,4,7,7,26,26,28,28,25,25,2,2,17,17,0,0,14,14,9,9,5,5,15,15,21,21,13,13,5,5,26,26,8,8,9,9,2,2,24,24,17,17,23,23,13,13,28,28,4,4,20,20,20,20,22,22,28,28,6,6,20,20,13,13,25,25,4,4,18,18,25,25,11,11,21,21,0,0,28,28,25,25,3,3,12,12,20,20,22,22,26,26,4,4,9,9,30,30,13,13,11,11,20,20,26,26,18,18,11,11,23,23,31,31,4,4,9,9,25,25,10,10,10,10,10,10,9,9,4,4,3,3,1,1,0,0,24,24,7,7,29,29,25,25,14,14,19,19,6,6,16,16,13,13,15,15,31,31,1,1,22,22,21,21,19,19,4,4,4,4,30,30,17,17,0,0,5,5,0,0,25,25,28,28,9,9,12,12,20,20,7,7,4,4,6,6,9,9,16,16,27,27,30,30,1,1,30,30,14,14,6,6,27,27,3,3,11,11,0,0,20,20,30,30,31,31,2,2,28,28,0,0,21,21,28,28,30,30,21,21,28,28,21,21,11,11,3,3,11,11,6,6,25,25,28,28,31,31,1,1,4,4,12,12,11,11,10,10,27,27,9,9,12,12,20,20,22,22,5,5,13,13,9,9,22,22,31,31,22,22,17,17,12,12,4,4,13,13,17,17,7,7,6,6,31,31,8,8,23,23,11,11,19,19,25,25,9,9,19,19,25,25,14,14,28,28,9,9,7,7,30,30,17,17,28,28,0,0,29,29,24,24,11,11,12,12,1,1,24,24,13,13,30,30,2,2,30,30,1,1,24,24,3,3,24,24,31,31,21,21,11,11,23,23,12,12,6,6,16,16,26,26,10,10,3,3,9,9,23,23,25,25,8,8,6,6,14,14,6,6,14,14,3,3,10,10,29,29,11,11,8,8,14,14,5,5,19,19,13,13,30,30,24,24,10,10,1,1,9,9,30,30,12,12,24,24,28,28,23,23,5,5,24,24,2,2,24,24,10,10,30,30,30,30,22,22,19,19,6,6,10,10,13,13,5,5,10,10,11,11,23,23,7,7,2,2,26,26,31,31,28,28,20,20,20,20,20,20,8,8,18,18,5,5,19,19,31,31,26,26,0,0,29,29,21,21,21,21,14,14,10,10,15,15,10,10,11,11,3,3,8,8,6,6,20,20,24,24,24,24,5,5,25,25,16,16,25,25,10,10,14,14,10,10,23,23,26,26,3,3,1,1,19,19,5,5,13,13,8,8,1,1,5,5,17,17,24,24,1,1,2,2,30,30,14,14,13,13,31,31,6,6,22,22,17,17,1,1,5,5,24,24,14,14,9,9,15,15,9,9,25,25,24,24,26,26,30,30,24,24,3,3,18,18,8,8,19,19,22,22,0,0,29,29,29,29,19,19,30,30,2,2,24,24,25,25,3,3,20,20,10,10,20,20,19,19,4,4,22,22,12,12,11,11,10,10,17,17,21,21,27,27,30,30,28,28,1,1,25,25,12,12,26,26,12,12,0,0,31,31,4,4,8,8,17,17,4,4,19,19,31,31,25,25,29,29,19,19,28,28,16,16,8,8,0,0,25,25,2,2,21,21,25,25,20,20,5,5,4,4,28,28,19,19,30,30,4,4,13,13,28,28,19,19,27,27,15,15,24,24,25,25,12,12,24,24,6,6,26,26,27,27,4,4,0,0,27,27,10,10,21,21,0,0,4,4,28,28,2,2,5,5,7,7,8,8,6,6,20,20,6,6,13,13,7,7,30,30,28,28,31,31,27,27,0,0,7,7,10,10,30,30,31,31,28,28,19,19,9,9,18,18,18,18,27,27,7,7,19,19,13,13,2,2,13,13,19,19,3,3,25,25,23,23,6,6,4,4,16,16,31,31,17,17,0,0,26,26,1,1,9,9,5,5,21,21,13,13,24,24,21,21,30,30,22,22,25,25,10,10,25,25,9,9,2,2,23,23,1,1,31,31,20,20,31,31,21,21,25,25,10,10,17,17,23,23,12,12,14,14,25,25,17,17,28,28,0,0,16,16,5,5,9,9,3,3,24,24,11,11,28,28,12,12,29,29,10,10,8,8,26,26,25,25,8,8,26,26,17,17,1,1,3,3,26,26,17,17,12,12,27,27,14,14,6,6,1,1,9,9,14,14,14,14,24,24,18,18,23,23,30,30,28,28,13,13,23,23,16,16,3,3,10,10,5,5,3,3,4,4,10,10,31,31,11,11,17,17,23,23,16,16,26,26,24,24,31,31,10,10,17,17,23,23,5,5,9,9,29,29,8,8,30,30,30,30,28,28,26,26,27,27,6,6,14,14,8,8,18,18,13,13,15,15,21,21,23,23,5,5,7,7,2,2,16,16,0,0,10,10,30,30,17,17,18,18,24,24,5,5,6,6,29,29,1,1,22,22,31,31,15,15,21,21,27,27,17,17,15,15,19,19,11,11,24,24,19,19,11,11,20,20,13,13,24,24,19,19,11,11,4,4,21,21,1,1,31,31,27,27,15,15,13,13,0,0,11,11,1,1,7,7,25,25,13,13,17,17,28,28,1,1,29,29,18,18,27,27,17,17,4,4,13,13,13,13,3,3,27,27,2,2,27,27,15,15,23,23,10,10,25,25,15,15,20,20,1,1,4,4,12,12,13,13,25,25,8,8,15,15,19,19,8,8,1,1,11,11,2,2,19,19,17,17,31,31,9,9,21,21,14,14,18,18,26,26,5,5,31,31,13,13,0,0,0,0,5,5,11,11,27,27,8,8,25,25,14,14,1,1,2,2,10,10,18,18,29,29,8,8,22,22,27,27,8,8,2,2,29,29,17,17,15,15,2,2,10,10,1,1,18,18,11,11,4,4,11,11,0,0,25,25,19,19,7,7,13,13,6,6,11,11,5,5,3,3,27,27,5,5,13,13,22,22,25,25,13,13,10,10,3,3,26,26,9,9,18,18,2,2,8,8,25,25,17,17,22,22,3,3,14,14,10,10,22,22,13,13,20,20,25,25,8,8,30,30,5,5,8,8,31,31,5,5,18,18,16,16,24,24,0,0,3,3,15,15,24,24,18,18,28,28,29,29,24,24,28,28,9,9,12,12,3,3,13,13,14,14,21,21,10,10,4,4,16,16,15,15,16,16,28,28,31,31,10,10,11,11,3,3,4,4,16,16,4,4,12,12,4,4,20,20,11,11,29,29,19,19,19,19,16,16,29,29,8,8,30,30,19,19,15,15,27,27,27,27,1,1,3,3,8,8,19,19,17,17,21,21,8,8,18,18,16,16,30,30,22,22,25,25,17,17,9,9,24,24,7,7,8,8,7,7,2,2,28,28,7,7,6,6,16,16,16,16,19,19,24,24,30,30,27,27,31,31,0,0,22,22,22,22,6,6,9,9,12,12,22,22,29,29,10,10,24,24,31,31,6,6,26,26,12,12,8,8,6,6,1,1,3,3,6,6,21,21,10,10,22,22,5,5,0,0,0,0,20,20,18,18,0,0,9,9,24,24,14,14,16,16,0,0,24,24,11,11,5,5,18,18,11,11,0,0,17,17,2,2,16,16,4,4,6,6,11,11,6,6,20,20,22,22,9,9,10,10,7,7,4,4,7,7,16,16,10,10,30,30,0,0,17,17,21,21,6,6,7,7,6,6,15,15,9,9,27,27,16,16,26,26,25,25,8,8,8,8,20,20,25,25,4,4,18,18,24,24,4,4,30,30,9,9,11,11,27,27,2,2,27,27,9,9,17,17,30,30,11,11,11,11,24,24,18,18,5,5,28,28,15,15,30,30,27,27,18,18,20,20,14,14,23,23,11,11,27,27,0,0,18,18,31,31,15,15,10,10,11,11,0,0,16,16,9,9,4,4,14,14,8,8,17,17,17,17,2,2,0,0,1,1,3,3,28,28,3,3,9,9,7,7,16,16,23,23,2,2,8,8,13,13,17,17,15,15,9,9,19,19,11,11,20,20,13,13,3,3,30,30,7,7,19,19,8,8,18,18,15,15,9,9,1,1,16,16,22,22,4,4,3,3,1,1,21,21,16,16,20,20,8,8,0,0,17,17,22,22,27,27,18,18,8,8,14,14,17,17,28,28,19,19,13,13,0,0,7,7,5,5,30,30,4,4,8,8,24,24,8,8,12,12,3,3,12,12,27,27,8,8,3,3,0,0,10,10,20,20,14,14,14,14,26,26,6,6,15,15,5,5,26,26,3,3,21,21,10,10,23,23,27,27,13,13,23,23,3,3,11,11,18,18,0,0,5,5,13,13,15,15,16,16,0,0,24,24,24,24,28,28,6,6,22,22,24,24,11,11,16,16,28,28,21,21,8,8,22,22,24,24,2,2,14,14,22,22,1,1,22,22,28,28,10,10,10,10,11,11,14,14,4,4,15,15,0,0,30,30,18,18,23,23,6,6,29,29,15,15,30,30,0,0,19,19,9,9,22,22,18,18,2,2,3,3,0,0,22,22,9,9,22,22,1,1,9,9,15,15,20,20,8,8,26,26,29,29,22,22,0,0,23,23,24,24,17,17,24,24,30,30,11,11,27,27,6,6,19,19,23,23,16,16,29,29,20,20,11,11,23,23,5,5,30,30,0,0,25,25,22,22,3,3,15,15,0,0,11,11,25,25,1,1,17,17,2,2,15,15,6,6,26,26,30,30,21,21,3,3,4,4,28,28,25,25,12,12,8,8,1,1,19,19,19,19,21,21,25,25,22,22,28,28,28,28,9,9,15,15,14,14,30,30,9,9,11,11,5,5,10,10,1,1,12,12,14,14,18,18,16,16,12,12,5,5,14,14,18,18,28,28,23,23,18,18,16,16,1,1,17,17,19,19,0,0,25,25,19,19,21,21,28,28,17,17,31,31,4,4,13,13,5,5,8,8,26,26,26,26,28,28,1,1,29,29,5,5,29,29,30,30,3,3,14,14,1,1,8,8,11,11,28,28,1,1,22,22,18,18,23,23,23,23,23,23,13,13,21,21,11,11,12,12,22,22,19,19,27,27,20,20,9,9,30,30,29,29,31,31,25,25,19,19,6,6,12,12,26,26,27,27,0,0,11,11,28,28,27,27,23,23,17,17,11,11,14,14,18,18,16,16,14,14,22,22,4,4,24,24,5,5,23,23,12,12,0,0,5,5,12,12,12,12,7,7,30,30,18,18,7,7,25,25,28,28,8,8,8,8,17,17,7,7,30,30,30,30,22,22,26,26,13,13,11,11,29,29,28,28,18,18,15,15,28,28,19,19,6,6,6,6,2,2,2,2,4,4,25,25,21,21,18,18,17,17,26,26,14,14,22,22,13,13,0,0,4,4,20,20,8,8,27,27,5,5,25,25,16,16,17,17,4,4,2,2,7,7,31,31,21,21,27,27,15,15,29,29,28,28,8,8,16,16,5,5,11,11,22,22,29,29,19,19,2,2,20,20,18,18,10,10,22,22,4,4,6,6,4,4,29,29,29,29,20,20,7,7,6,6,3,3,31,31,19,19,9,9,6,6,3,3,4,4,0,0,4,4,31,31,10,10,23,23,0,0,28,28,11,11,25,25,17,17,19,19,22,22,0,0,1,1,16,16,24,24,8,8,27,27,7,7,30,30,23,23,2,2,9,9,1,1,1,1,23,23,2,2,4,4,6,6,15,15,3,3,30,30,17,17,18,18,0,0,0,0,2,2,20,20,22,22,1,1,0,0,8,8,8,8,0,0,11,11,23,23,9,9,2,2,4,4,18,18,22,22,30,30,26,26,2,2,2,2,22,22,4,4,13,13,8,8,28,28,2,2,2,2,16,16,9,9,3,3,12,12,0,0,27,27,30,30,25,25,2,2,22,22,12,12,8,8,11,11,9,9,23,23,13,13,2,2,4,4,12,12,24,24,3,3,20,20,9,9,15,15,21,21,23,23,25,25,31,31,22,22,13,13,2,2,23,23,21,21,13,13,13,13,24,24,30,30,22,22,22,22,25,25,18,18,0,0,0,0,0,0,8,8,1,1,10,10,24,24,18,18,0,0,27,27,1,1,26,26,30,30,22,22,16,16,26,26,21,21,24,24,14,14,14,14,2,2,7,7,1,1,26,26,19,19,13,13,23,23,3,3,20,20,2,2,23,23,11,11,23,23,9,9,31,31,11,11,12,12,24,24,25,25,29,29,1,1,12,12,3,3,11,11,25,25,0,0,18,18,20,20,14,14,2,2,25,25,5,5,3,3,14,14,4,4,14,14,1,1,9,9,3,3,1,1,12,12,6,6,30,30,17,17,17,17,29,29,12,12,8,8,25,25,19,19,29,29,17,17,21,21,9,9,25,25,29,29,23,23,31,31,27,27,11,11,2,2,18,18,2,2,0,0,4,4,8,8,28,28,6,6,4,4,0,0,11,11,9,9,16,16,0,0,11,11,7,7,13,13,1,1,6,6,27,27,14,14,2,2,4,4,7,7,26,26,19,19,21,21,9,9,0,0,5,5,22,22,18,18,4,4,7,7,4,4,11,11,14,14,26,26,1,1,18,18,30,30,11,11,16,16,29,29,1,1,17,17,16,16,18,18,3,3,6,6,9,9,3,3,14,14,27,27,28,28,22,22,15,15,23,23,29,29,6,6,24,24,22,22,10,10,29,29,5,5,28,28,1,1,0,0,28,28,5,5,8,8,25,25,19,19,2,2,31,31,27,27,27,27,3,3,15,15,28,28,17,17,30,30,12,12,7,7,10,10,2,2,21,21,7,7,20,20,10,10,29,29,4,4,22,22,7,7,4,4,18,18,1,1,17,17,29,29,23,23,28,28,17,17,28,28,21,21,26,26,16,16,4,4,31,31,15,15,6,6,21,21,9,9,17,17,16,16,4,4,29,29,23,23,21,21,1,1,28,28,21,21,14,14,23,23,13,13,16,16,29,29,14,14,6,6,10,10,7,7,17,17,27,27,1,1,10,10,5,5,8,8,7,7,17,17,10,10,7,7,26,26,22,22,27,27,14,14,9,9,7,7,3,3,7,7,27,27,19,19,6,6,21,21,0,0,16,16,2,2,9,9,31,31,8,8,18,18,4,4,0,0,25,25,4,4,20,20,16,16,19,19,6,6,19,19,29,29,0,0,0,0,4,4,23,23,28,28,11,11,21,21,27,27,13,13,2,2,28,28,12,12,0,0,11,11,31,31,26,26,15,15,24,24,7,7,14,14,26,26,26,26,19,19,8,8,13,13,5,5,10,10,12,12,1,1,29,29,15,15,23,23,8,8,10,10,1,1,14,14,14,14,2,2,19,19,21,21,23,23,18,18,30,30,6,6,10,10,5,5,29,29,6,6,7,7,9,9,21,21,25,25,15,15,30,30,2,2,11,11,31,31,25,25,24,24,23,23,20,20,9,9,5,5,21,21,12,12,1,1,21,21,25,25,1,1,23,23,18,18,0,0,28,28,22,22,18,18,5,5,4,4,7,7,30,30,4,4,13,13,1,1,7,7,2,2,4,4,30,30,24,24,26,26,7,7,20,20,16,16,0,0,21,21,12,12,21,21,2,2,30,30,7,7,5,5,11,11,30,30,14,14,13,13,13,13,3,3,18,18,18,18,19,19,18,18,26,26,21,21,5,5,1,1,7,7,29,29,2,2,9,9,18,18,20,20,14,14,20,20,26,26,3,3,3,3,6,6,27,27,5,5,10,10,24,24,29,29,8,8,16,16,26,26,28,28,9,9,19,19,1,1,24,24,29,29,29,29,24,24,2,2,31,31,13,13,8,8,16,16,17,17,5,5,9,9,20,20,11,11,5,5,11,11,10,10,0,0,20,20,30,30,16,16,25,25,17,17,14,14,31,31,26,26,14,14,8,8,15,15,25,25,3,3,16,16,12,12,27,27,0,0,2,2,16,16,3,3,19,19,0,0,12,12,20,20,31,31,4,4,7,7,21,21,9,9,0,0,0,0,27,27,2,2,26,26,7,7,25,25,16,16,21,21,10,10,16,16,24,24,16,16,18,18,17,17,0,0,26,26,24,24,29,29,27,27,28,28,7,7,8,8,24,24,26,26,24,24,8,8,17,17,9,9,9,9,26,26,3,3,0,0,4,4,30,30,0,0,1,1,4,4,24,24,13,13,8,8,8,8,11,11,3,3,10,10,10,10,17,17,16,16,15,15,9,9,11,11,14,14,27,27,0,0,11,11,8,8,12,12,18,18,8,8,17,17,4,4,9,9,26,26,13,13,16,16,17,17,16,16,14,14,13,13,20,20,0,0,16,16,12,12,23,23,17,17,8,8,12,12,30,30,30,30,4,4,13,13,26,26,7,7,28,28,3,3,3,3,11,11,2,2,21,21,26,26,7,7,2,2,24,24,11,11,22,22,24,24,13,13,21,21,17,17,11,11,27,27,19,19,1,1,24,24,20,20,30,30,3,3,24,24,11,11,13,13,24,24,10,10,11,11,7,7,0,0,9,9,17,17,14,14,25,25,1,1,13,13,8,8,3,3,21,21,24,24,13,13,17,17,23,23,20,20,28,28,15,15,4,4,17,17,29,29,11,11,21,21,5,5,27,27,5,5,27,27,24,24,28,28,28,28,11,11,10,10,17,17,24,24,4,4,26,26,11,11,0,0,4,4,8,8,15,15,18,18,14,14,17,17,6,6,23,23,5,5,10,10,22,22,0,0,11,11,27,27,25,25,29,29,13,13,0,0,31,31,2,2,8,8,8,8,7,7,30,30,22,22,11,11,1,1,15,15,9,9,30,30,12,12,4,4,25,25,23,23,16,16,6,6,22,22,19,19,26,26,18,18,4,4,10,10,22,22,6,6,16,16,9,9,12,12,3,3,31,31,27,27,17,17,9,9,7,7,16,16,11,11,10,10,7,7,0,0,21,21,26,26,12,12,19,19,2,2,7,7,11,11,21,21,26,26,18,18,20,20,6,6,13,13,2,2,30,30,22,22,26,26,3,3,11,11,25,25,12,12,30,30,24,24,5,5,29,29,6,6,4,4,20,20,29,29,29,29,17,17,18,18,27,27,1,1,7,7,21,21,1,1,28,28,5,5,12,12,9,9,22,22,2,2,17,17,17,17,16,16,30,30,12,12,8,8,24,24,8,8,14,14,19,19,19,19,19,19,18,18,14,14,10,10,9,9,29,29,27,27,17,17,18,18,8,8,9,9,0,0,24,24,9,9,28,28,8,8,19,19,4,4,15,15,3,3,3,3,28,28,22,22,19,19,4,4,19,19,25,25,11,11,8,8,27,27,12,12,14,14,16,16,15,15,12,12,23,23,10,10,19,19,3,3,24,24,25,25,7,7,21,21,25,25,7,7,18,18,18,18,20,20,3,3,14,14,15,15,19,19,29,29,27,27,20,20,18,18,21,21,10,10,10,10,29,29,19,19,20,20,25,25,21,21,30,30,1,1,31,31,29,29,2,2,18,18,1,1,5,5,9,9,30,30,17,17,17,17,25,25,6,6,9,9,17,17,30,30,3,3,17,17,22,22,10,10,17,17,11,11,14,14,25,25,4,4,2,2,6,6,12,12,10,10,17,17,19,19,28,28,23,23,27,27,12,12,18,18,29,29,16,16,27,27,20,20,4,4,29,29,8,8,24,24,13,13,3,3,30,30,1,1,20,20,30,30,4,4,0,0,10,10,26,26,10,10,0,0,28,28,11,11,8,8,10,10,17,17,5,5,0,0,16,16,17,17,24,24,16,16,2,2,21,21,1,1,5,5,27,27,2,2,27,27,16,16,21,21,6,6,30,30,1,1,2,2,4,4,4,4,17,17,27,27,1,1,12,12,2,2,16,16,11,11,4,4,10,10,8,8,18,18,17,17,26,26,2,2,18,18,6,6,25,25,27,27,4,4,10,10,9,9,14,14,12,12,24,24,2,2,0,0,17,17,25,25,0,0,23,23,30,30,6,6,20,20,30,30,22,22,6,6,12,12,2,2,6,6,4,4,4,4,7,7,31,31,21,21,19,19,20,20,9,9,12,12,8,8,5,5,17,17,6,6,13,13,9,9,26,26,31,31,14,14,24,24,13,13,15,15,6,6,10,10,3,3,26,26,8,8,1,1,19,19,16,16,8,8,17,17,13,13,0,0,13,13,0,0,1,1,13,13,31,31,13,13,23,23,15,15,26,26,12,12,3,3,7,7,2,2,23,23,15,15,9,9,6,6,20,20,8,8,21,21,4,4,6,6,1,1,25,25,18,18,12,12,13,13,28,28,31,31,31,31,30,30,10,10,20,20,18,18,25,25,8,8,23,23,3,3,28,28,9,9,29,29,25,25,4,4,10,10,10,10,1,1,6,6,5,5,17,17,16,16,20,20,5,5,23,23,25,25,28,28,21,21,8,8,31,31,13,13,11,11,11,11,17,17,26,26,22,22,24,24,18,18,22,22,10,10,4,4,14,14,13,13,18,18,13,13,13,13,20,20,23,23,5,5,23,23,15,15,30,30,6,6,1,1,10,10,13,13,8,8,11,11,23,23,16,16,3,3,29,29,12,12,2,2,17,17,23,23,31,31,24,24,5,5,29,29,2,2,7,7,3,3,29,29,13,13,17,17,0,0,11,11,15,15,14,14,6,6,28,28,5,5,11,11,10,10,30,30,1,1,23,23,10,10,28,28,27,27,24,24,6,6,30,30,5,5,20,20,18,18,0,0,28,28,31,31,11,11,18,18,27,27,21,21,4,4,19,19,3,3,5,5,17,17,5,5,2,2,5,5,28,28,15,15,1,1,2,2,23,23,9,9,29,29,22,22,18,18,5,5,3,3,1,1,21,21,23,23,16,16,29,29,18,18,1,1,28,28,30,30,29,29,11,11,8,8,8,8,13,13,28,28,29,29,5,5,16,16,29,29,1,1,5,5,0,0,20,20,5,5,0,0,6,6,19,19,0,0,24,24,25,25,1,1,15,15,26,26,29,29,13,13,13,13,24,24,18,18,21,21,0,0,10,10,5,5,4,4,4,4,17,17,18,18,31,31,30,30,9,9,11,11,13,13,16,16,2,2,17,17,1,1,8,8,12,12,0,0,4,4,28,28,23,23,15,15,16,16,0,0,19,19,23,23,7,7,7,7,22,22,17,17,10,10,10,10,27,27,6,6,4,4,16,16,0,0,23,23,30,30,0,0,20,20,8,8,26,26,8,8,14,14,13,13,3,3,11,11,31,31,21,21,19,19,13,13,16,16,3,3,28,28,12,12,0,0,30,30,12,12,16,16,14,14,2,2,2,2,19,19,22,22,23,23,3,3,10,10,1,1,7,7,14,14,26,26,20,20,31,31,15,15,16,16,17,17,18,18,13,13,19,19,2,2,11,11,29,29,15,15,18,18,5,5,14,14,28,28,21,21,15,15,22,22,25,25,2,2,18,18,17,17,8,8,15,15,9,9,22,22,13,13,12,12,4,4,7,7,8,8,12,12,22,22,8,8,2,2,26,26,1,1,0,0,13,13,28,28,1,1,13,13,23,23,23,23,30,30,18,18,19,19,30,30,19,19,15,15,18,18,13,13,16,16,4,4,22,22,21,21,28,28,20,20,12,12,31,31,27,27,9,9,14,14,27,27,7,7,0,0,13,13,30,30,4,4,1,1,8,8,7,7,12,12,22,22,19,19,10,10,8,8,31,31,6,6,31,31,2,2,1,1,22,22,0,0,26,26,30,30,9,9,2,2,20,20,4,4,31,31,6,6,17,17,21,21,2,2,22,22,19,19,20,20,10,10,30,30,1,1,18,18,7,7,23,23,26,26,1,1,9,9,26,26,18,18,16,16,13,13,17,17,0,0,20,20,1,1,9,9,19,19,10,10,5,5,21,21,29,29,24,24,3,3,11,11,11,11,19,19,11,11,12,12,2,2,31,31,7,7,13,13,2,2,27,27,23,23,18,18,14,14,4,4,31,31,16,16,26,26,7,7,8,8,9,9,2,2,6,6,10,10,11,11,28,28,8,8,22,22,9,9,24,24,15,15,2,2,6,6,8,8,21,21,22,22,14,14,3,3,16,16,17,17,13,13,17,17,5,5,15,15,12,12,25,25,4,4,10,10,10,10,28,28,10,10,28,28,11,11,0,0,19,19,5,5,14,14,5,5,7,7,19,19,30,30,18,18,14,14,25,25,18,18,30,30,7,7,0,0,7,7,4,4,0,0,24,24,2,2,27,27,10,10,12,12,21,21,29,29,0,0,28,28,0,0,1,1,29,29,9,9,31,31,5,5,6,6,15,15,18,18,8,8,6,6,22,22,16,16,28,28,13,13,28,28,24,24,28,28,1,1,29,29,24,24,8,8,10,10,20,20,23,23,14,14,23,23,28,28,19,19,8,8,22,22,3,3,2,2,20,20,30,30,15,15,10,10,1,1,4,4,22,22,16,16,31,31,12,12,27,27,10,10,4,4,1,1,0,0,8,8,3,3,0,0,6,6,0,0,0,0,4,4,4,4,24,24,26,26,8,8,3,3,14,14,3,3,22,22,6,6,24,24,23,23,1,1,5,5,26,26,30,30,16,16,17,17,17,17,0,0,5,5,22,22,16,16,28,28,17,17,10,10,2,2,1,1,20,20,28,28,14,14,25,25,25,25,6,6,21,21,21,21,27,27,15,15,7,7,8,8,10,10,12,12,8,8,0,0,4,4,24,24,24,24,14,14,1,1,19,19,17,17,3,3,5,5,8,8,16,16,26,26,25,25,1,1,0,0,13,13,7,7,0,0,14,14,12,12,0,0,25,25,4,4,5,5,10,10,14,14,15,15,28,28,2,2,21,21,8,8,26,26,0,0,23,23,4,4,14,14,6,6,12,12,0,0,6,6,9,9,4,4,31,31,20,20,17,17,2,2,24,24,10,10,19,19,13,13,3,3,8,8,25,25,5,5,30,30,27,27,20,20,0,0,5,5,18,18,14,14,18,18,13,13,18,18,21,21,26,26,0,0,31,31,25,25,0,0,4,4,0,0,18,18,16,16,9,9,17,17,8,8,6,6,3,3,1,1,2,2,2,2,12,12,9,9,1,1,5,5,30,30,21,21,7,7,11,11,20,20,4,4,11,11,24,24,20,20,25,25,0,0,10,10,0,0,9,9,5,5,25,25,20,20,4,4,28,28,10,10,16,16,2,2,27,27,31,31,5,5,10,10,24,24,10,10,5,5,27,27,29,29,2,2,13,13,28,28,24,24,30,30,2,2,14,14,8,8,10,10,14,14,8,8,28,28,29,29,0,0,5,5,31,31,17,17,15,15,21,21,4,4,8,8,26,26,19,19,3,3,23,23,20,20,23,23,14,14,28,28,14,14,1,1,6,6,6,6,2,2,11,11,31,31,15,15,0,0,24,24,30,30,10,10,26,26,1,1,31,31,2,2,28,28,17,17,27,27,25,25,24,24,10,10,1,1,6,6,18,18,24,24,19,19,6,6,6,6,21,21,26,26,26,26,20,20,6,6,15,15,26,26,30,30,4,4,28,28,20,20,27,27,1,1,12,12,24,24,26,26,3,3,17,17,25,25,11,11,15,15,3,3,16,16,21,21,4,4,8,8,24,24,4,4,1,1,11,11,14,14,8,8,0,0,26,26,4,4,6,6,29,29,1,1,15,15,16,16,22,22,6,6,22,22,21,21,26,26,15,15,3,3,20,20,4,4,12,12,13,13,30,30,30,30,12,12,13,13,16,16,19,19,20,20,2,2,7,7,20,20,16,16,13,13,24,24,4,4,21,21,18,18,27,27,7,7,6,6,14,14,12,12,4,4,31,31,27,27,3,3,12,12,25,25,17,17,1,1,5,5,9,9,0,0,27,27,1,1,17,17,13,13,11,11,25,25,18,18,5,5,11,11,17,17,11,11,25,25,22,22,14,14,17,17,1,1,12,12,13,13,10,10,29,29,27,27,15,15,0,0,12,12,7,7,3,3,29,29,28,28,2,2,23,23,13,13,11,11,20,20,2,2,7,7,30,30,9,9,0,0,3,3,26,26,7,7,16,16,0,0,3,3,12,12,13,13,13,13,31,31,26,26,2,2,17,17,21,21,0,0,13,13,27,27,17,17,13,13,29,29,10,10,3,3,24,24,0,0,4,4,19,19,28,28,31,31,25,25,9,9,2,2,16,16,3,3,21,21,20,20,9,9,17,17,1,1,11,11,0,0,4,4,29,29,15,15,14,14,6,6,11,11,7,7,13,13,8,8,31,31,5,5,20,20,1,1,28,28,2,2,3,3,18,18,28,28,6,6,6,6,2,2,3,3,26,26,6,6,5,5,11,11,10,10,28,28,21,21,10,10,0,0,2,2,4,4,25,25,20,20,7,7,17,17,2,2,30,30,29,29,16,16,19,19,3,3,25,25,2,2,0,0,24,24,13,13,3,3,27,27,6,6,26,26,5,5,8,8,23,23,0,0,6,6,30,30,4,4,12,12,12,12,2,2,22,22,10,10,17,17,16,16,18,18,17,17,26,26,11,11,0,0,30,30,10,10,24,24,29,29,31,31,16,16,18,18,26,26,22,22,25,25,8,8,19,19,19,19,14,14,5,5,20,20,10,10,9,9,7,7,18,18,31,31,12,12,6,6,15,15,19,19,21,21,6,6,14,14,30,30,5,5,29,29,30,30,20,20,2,2,20,20,0,0,19,19,27,27,26,26,17,17,6,6,24,24,4,4,27,27,12,12,28,28,19,19,18,18,21,21,1,1,4,4,1,1,15,15,16,16,1,1,21,21,12,12,8,8,28,28,3,3,30,30,22,22,10,10,12,12,10,10,0,0,12,12,2,2,2,2,5,5,4,4,16,16,13,13,2,2,6,6,19,19,11,11,24,24,16,16,4,4,1,1,2,2,17,17,25,25,24,24,8,8,25,25,24,24,22,22,1,1,23,23,16,16,6,6,30,30,0,0,11,11,13,13,16,16,9,9,14,14,5,5,31,31,1,1,16,16,1,1,13,13,20,20,4,4,13,13,15,15,25,25,5,5,0,0,23,23,2,2,22,22,21,21,0,0,27,27,9,9,24,24,4,4,12,12,13,13,11,11,15,15,31,31,20,20,16,16,13,13,0,0,11,11,18,18,25,25,7,7,16,16,16,16,26,26,10,10,8,8,0,0,17,17,7,7,14,14,22,22,25,25,13,13,11,11,22,22,17,17,24,24,16,16,31,31,21,21,16,16,5,5,21,21,30,30,10,10,18,18,9,9,30,30,4,4,10,10,14,14,15,15,21,21,1,1,14,14,20,20,12,12,13,13,6,6,12,12,4,4,25,25,30,30,30,30,9,9,27,27,19,19,17,17,7,7,14,14,30,30,7,7,20,20,9,9,16,16,4,4,6,6,19,19,4,4,24,24,4,4,16,16,22,22,12,12,6,6,3,3,21,21,26,26,7,7,12,12,18,18,25,25,0,0,26,26,11,11,21,21,31,31,12,12,28,28,3,3,9,9,25,25,18,18,18,18,26,26,21,21,27,27,18,18,19,19,26,26,21,21,8,8,16,16,16,16,8,8,25,25,13,13,1,1,24,24,8,8,24,24,6,6,18,18,17,17,19,19,12,12,19,19,31,31,26,26,5,5,11,11,12,12,13,13,18,18,28,28,18,18,8,8,22,22,28,28,28,28,10,10,1,1,0,0,7,7,1,1,14,14,13,13,9,9,30,30,13,13,6,6,29,29,5,5,25,25,10,10,20,20,13,13,11,11,31,31,8,8,11,11,29,29,22,22,9,9,18,18,31,31,16,16,22,22,5,5,26,26,7,7,14,14,9,9,25,25,18,18,29,29,7,7,30,30,26,26,12,12,0,0,12,12,2,2,16,16,13,13,25,25,7,7,8,8,22,22,0,0,5,5,0,0,6,6,4,4,1,1,16,16,30,30,14,14,8,8,28,28,8,8,10,10,28,28,20,20,12,12,17,17,20,20,18,18,1,1,12,12,0,0,12,12,10,10,24,24,26,26,3,3,1,1,1,1,16,16,22,22,11,11,27,27,0,0,14,14,9,9,21,21,17,17,7,7,0,0,23,23,22,22,24,24,14,14,6,6,24,24,28,28,16,16,19,19,4,4,21,21,20,20,18,18,3,3,5,5,7,7,21,21,4,4,26,26,30,30,22,22,2,2,11,11,7,7,15,15,3,3,8,8,19,19,17,17,20,20,31,31,0,0,24,24,5,5,25,25,16,16,0,0,4,4,12,12,1,1,9,9,10,10,29,29,11,11,18,18,4,4,15,15,18,18,22,22,21,21,27,27,4,4,31,31,4,4,6,6,2,2,25,25,17,17,1,1,30,30,31,31,1,1,26,26,21,21,15,15,20,20,18,18,16,16,11,11,12,12,18,18,15,15,5,5,19,19,2,2,30,30,26,26,4,4,9,9,2,2,24,24,12,12,21,21,0,0,24,24,9,9,5,5,0,0,5,5,10,10,6,6,10,10,4,4,23,23,17,17,12,12,24,24,5,5,7,7,5,5,28,28,1,1,14,14,6,6,3,3,29,29,19,19,14,14,5,5,10,10,14,14,13,13,28,28,20,20,19,19,20,20,0,0,23,23,18,18,1,1,25,25,21,21,19,19,22,22,25,25,25,25,6,6,2,2,20,20,8,8,25,25,14,14,7,7,17,17,16,16,30,30,25,25,27,27,0,0,6,6,15,15,21,21,23,23,23,23,9,9,3,3,1,1,20,20,7,7,24,24,9,9,9,9,14,14,6,6,12,12,3,3,19,19,19,19,12,12,16,16,30,30,15,15,25,25,18,18,27,27,29,29,29,29,20,20,6,6,13,13,11,11,26,26,28,28,8,8,18,18,26,26,28,28,6,6,23,23,6,6,8,8,0,0,3,3,6,6,2,2,31,31,27,27,5,5,23,23,16,16,30,30,7,7,19,19,3,3,14,14,3,3,26,26,29,29,4,4,25,25,24,24,22,22,13,13,14,14,7,7,25,25,26,26,0,0,23,23,11,11,20,20,16,16,8,8,22,22,15,15,12,12,1,1,5,5,20,20,31,31,10,10,0,0,5,5,3,3,6,6,7,7,23,23,12,12,26,26,0,0,28,28,24,24,8,8,25,25,28,28,6,6,18,18,10,10,12,12,11,11,11,11,16,16,3,3,21,21,3,3,27,27,14,14,8,8,16,16,31,31,25,25,14,14,13,13,27,27,24,24,19,19,8,8,31,31,1,1,29,29,8,8,22,22,26,26,11,11,14,14,26,26,6,6,28,28,31,31,29,29,22,22,16,16,18,18,16,16,11,11,23,23,16,16,17,17,30,30,28,28,12,12,25,25,17,17,12,12,29,29,3,3,1,1,16,16,4,4,16,16,5,5,29,29,29,29,22,22,0,0,9,9,20,20,15,15,22,22,23,23,29,29,31,31,8,8,3,3,24,24,24,24,21,21,10,10,4,4,11,11,16,16,3,3,31,31,15,15,8,8,20,20,29,29,10,10,22,22,21,21,27,27,22,22,27,27,4,4,3,3,20,20,0,0,29,29,30,30,4,4,23,23,19,19,7,7,19,19,30,30,16,16,19,19,28,28,19,19,4,4,6,6,9,9,11,11,14,14,6,6,27,27,8,8,11,11,27,27,3,3,30,30,27,27,23,23,15,15,18,18,17,17,26,26,9,9,22,22,7,7,9,9,12,12,25,25,22,22,21,21,28,28,14,14,11,11,29,29,4,4,6,6,12,12,18,18,13,13,11,11,12,12,31,31,30,30,14,14,5,5,0,0,8,8,18,18,2,2,19,19,11,11,1,1,17,17,11,11,13,13,11,11,18,18,26,26,28,28,18,18,4,4,12,12,25,25,28,28,16,16,29,29,28,28,18,18,0,0,20,20,7,7,8,8,0,0,18,18,30,30,9,9,15,15,23,23,9,9,31,31,22,22,7,7,25,25,19,19,9,9,21,21,21,21,10,10,26,26,4,4,14,14,2,2,12,12,27,27,22,22,5,5,11,11,17,17,16,16,16,16,27,27,19,19,20,20,2,2,20,20,4,4,6,6,15,15,30,30,1,1,25,25,13,13,26,26,22,22,22,22,22,22,11,11,31,31,12,12,16,16,13,13,0,0,20,20,29,29,6,6,30,30,0,0,19,19,28,28,13,13,18,18,26,26,14,14,16,16,20,20,9,9,31,31,1,1,28,28,9,9,19,19,14,14,4,4,24,24,16,16,6,6,17,17,3,3,21,21,11,11,13,13,24,24,13,13,0,0,18,18,17,17,18,18,21,21,10,10,29,29,11,11,3,3,24,24,17,17,25,25,6,6,27,27,19,19,13,13,15,15,6,6,18,18,23,23,13,13,4,4,17,17,25,25,1,1,2,2,4,4,29,29,27,27,30,30,25,25,17,17,17,17,17,17,19,19,0,0,8,8,19,19,23,23,13,13,19,19,8,8,16,16,20,20,8,8,12,12,9,9,18,18,16,16,20,20,6,6,8,8,8,8,9,9,1,1,2,2,30,30,8,8,25,25,4,4,9,9,26,26,3,3,27,27,23,23,26,26,28,28,24,24,25,25,17,17,24,24,1,1,17,17,27,27,31,31,26,26,17,17,17,17,29,29,9,9,9,9,24,24,25,25,1,1,28,28,4,4,26,26,13,13,1,1,17,17,24,24,23,23,0,0,20,20,0,0,5,5,0,0,23,23,7,7,23,23,29,29,4,4,5,5,0,0,11,11,21,21,26,26,22,22,25,25,22,22,22,22,8,8,4,4,17,17,11,11,16,16,29,29,0,0,28,28,20,20,4,4,2,2,6,6,18,18,6,6,11,11,6,6,5,5,5,5,5,5,24,24,12,12,29,29,22,22,21,21,6,6,9,9,29,29,13,13,15,15,12,12,18,18,9,9,22,22,18,18,9,9,27,27,11,11,24,24,26,26,26,26,19,19,26,26,6,6,4,4,7,7,10,10,9,9,22,22,22,22,15,15,0,0,12,12,16,16,7,7,22,22,2,2,0,0,11,11,6,6,16,16,12,12,29,29,0,0,11,11,14,14,18,18,8,8,19,19,21,21,30,30,20,20,2,2,11,11,8,8,11,11,30,30,5,5,23,23,22,22,4,4,29,29,5,5,5,5,14,14,26,26,8,8,5,5,10,10,10,10,13,13,8,8,29,29,4,4,1,1,5,5,2,2,0,0,13,13,2,2,26,26,3,3,1,1,26,26,19,19,4,4,2,2,8,8,3,3,18,18,14,14,8,8,20,20,29,29,5,5,24,24,25,25,24,24,8,8,27,27,9,9,15,15,7,7,3,3,29,29,11,11,8,8,14,14,26,26,13,13,7,7,15,15,20,20,0,0,29,29,0,0,10,10,20,20,21,21,19,19,20,20,3,3,28,28,10,10,9,9,1,1,13,13,13,13,19,19,31,31,4,4,8,8,1,1,25,25,28,28,3,3,13,13,23,23,29,29,21,21,20,20,6,6,14,14,29,29,8,8,20,20,0,0,23,23,25,25,23,23,14,14,9,9,17,17,24,24,19,19,2,2,15,15,31,31,27,27,30,30,15,15,29,29,21,21,28,28,9,9,26,26,1,1,31,31,25,25,18,18,22,22,5,5,31,31,16,16,25,25,8,8,5,5,10,10,9,9,8,8,12,12,24,24,4,4,4,4,12,12,25,25,15,15,4,4,17,17,17,17,26,26,16,16,19,19,15,15,16,16,6,6,7,7,27,27,20,20,8,8,12,12,17,17,14,14,25,25,8,8,27,27,31,31,26,26,26,26,14,14,21,21,31,31,3,3,10,10,30,30,3,3,8,8,7,7,20,20,29,29,22,22,2,2,10,10,7,7,11,11,26,26,30,30,5,5,18,18,21,21,19,19,31,31,4,4,8,8,12,12,7,7,16,16,13,13,0,0,16,16,8,8,21,21,13,13,12,12,24,24,22,22,10,10,5,5,20,20,30,30,28,28,12,12,18,18,14,14,25,25,2,2,20,20,14,14,3,3,16,16,15,15,17,17,20,20,1,1,8,8,24,24,26,26,6,6,28,28,8,8,29,29,18,18,7,7,17,17,6,6,8,8,9,9,22,22,13,13,26,26,8,8,1,1,23,23,12,12,8,8,23,23,19,19,22,22,20,20,17,17,7,7,21,21,28,28,4,4,20,20,2,2,3,3,5,5,16,16,23,23,4,4,20,20,29,29,0,0,19,19,13,13,19,19,28,28,20,20,7,7,12,12,0,0,13,13,27,27,30,30,13,13,14,14,18,18,1,1,15,15,4,4,24,24,26,26,0,0,4,4,20,20,11,11,8,8,31,31,12,12,0,0,0,0,15,15,25,25,14,14,11,11,4,4,12,12,20,20,20,20,6,6,11,11,14,14,19,19,5,5,10,10,10,10,11,11,6,6,23,23,13,13,10,10,20,20,9,9,12,12,30,30,8,8,25,25,11,11,2,2,14,14,27,27,31,31,17,17,31,31,7,7,11,11,29,29,28,28,25,25,16,16,9,9,21,21,25,25,31,31,24,24,1,1,18,18,26,26,11,11,8,8,12,12,16,16,30,30,9,9,8,8,18,18,21,21,29,29,12,12,13,13,14,14,1,1,13,13,31,31,4,4,24,24,22,22,12,12,5,5,28,28,11,11,0,0,2,2,13,13,10,10,10,10,31,31,11,11,8,8,15,15,18,18,14,14,13,13,1,1,20,20,23,23,25,25,17,17,17,17,12,12,22,22,14,14,1,1,19,19,23,23,20,20,3,3,4,4,28,28,4,4,25,25,1,1,17,17,9,9,21,21,6,6,9,9,31,31,13,13,15,15,4,4,31,31,25,25,5,5,24,24,18,18,29,29,17,17,2,2,0,0,3,3,1,1,16,16,25,25,27,27,7,7,7,7,29,29,31,31,25,25,21,21,20,20,7,7,22,22,13,13,10,10,27,27,18,18,21,21,20,20,9,9,15,15,24,24,5,5,13,13,26,26,0,0,8,8,21,21,26,26,0,0,29,29,18,18,31,31,12,12,7,7,27,27,2,2,2,2,11,11,16,16,13,13,0,0,4,4,30,30,13,13,30,30,8,8,21,21,14,14,18,18,7,7,25,25,26,26,23,23,3,3,0,0,2,2,12,12,17,17,28,28,7,7,2,2,18,18,11,11,3,3,30,30,23,23,4,4,4,4,2,2,6,6,21,21,3,3,19,19,3,3,26,26,1,1,16,16,21,21,3,3,13,13,13,13,12,12,12,12,22,22,0,0,21,21,25,25,21,21,18,18,19,19,3,3,18,18,5,5,28,28,1,1,7,7,5,5,25,25,21,21,14,14,16,16,3,3,26,26,11,11,26,26,26,26,16,16,8,8,12,12,28,28,8,8,7,7,11,11,26,26,9,9,17,17,23,23,3,3,19,19,10,10,16,16,12,12,27,27,16,16,7,7,7,7,0,0,0,0,30,30,9,9,10,10,11,11,30,30,0,0,18,18,9,9,0,0,1,1,24,24,22,22,6,6,23,23,9,9,3,3,22,22,15,15,5,5,19,19,8,8,29,29,5,5,16,16,3,3,25,25,25,25,2,2,18,18,0,0,29,29,3,3,28,28,14,14,31,31,12,12,3,3,22,22,2,2,25,25,1,1,16,16,21,21,19,19,6,6,13,13,3,3,28,28,11,11,8,8,19,19,7,7,17,17,31,31,4,4,0,0,22,22,11,11,25,25,12,12,31,31,31,31,24,24,29,29,22,22,18,18,26,26,6,6,28,28,3,3,30,30,30,30,22,22,10,10,25,25,24,24,19,19,6,6,27,27,16,16,2,2,9,9,19,19,4,4,17,17,11,11,17,17,7,7,3,3,28,28,27,27,6,6,19,19,19,19,9,9,3,3,28,28,30,30,11,11,1,1,6,6,1,1,21,21,27,27,28,28,21,21,17,17,15,15,11,11,2,2,4,4,31,31,24,24,0,0,26,26,6,6,0,0,31,31,4,4,24,24,14,14,1,1,26,26,24,24,18,18,21,21,2,2,9,9,17,17,30,30,25,25,16,16,1,1,1,1,2,2,18,18,11,11,2,2,9,9,29,29,13,13,11,11,23,23,9,9,15,15,25,25,25,25,0,0,1,1,0,0,6,6,1,1,25,25,4,4,2,2,23,23,14,14,0,0,2,2,24,24,27,27,19,19,25,25,16,16,30,30,2,2,19,19,2,2,12,12,21,21,29,29,6,6,5,5,13,13,2,2,21,21,3,3,25,25,28,28,26,26,13,13,23,23,26,26,30,30,31,31,15,15,12,12,27,27,19,19,13,13,25,25,14,14,26,26,31,31,26,26,5,5,21,21,17,17,6,6,31,31,13,13,13,13,7,7,17,17,24,24,24,24,3,3,25,25,27,27,22,22,7,7,13,13,6,6,24,24,23,23,22,22,28,28,23,23,10,10,30,30,26,26,4,4,31,31,1,1,1,1,12,12,23,23,24,24,26,26,9,9,31,31,6,6,18,18,19,19,28,28,8,8,6,6,8,8,0,0,23,23,6,6,17,17,25,25,8,8,20,20,26,26,14,14,18,18,0,0,23,23,17,17,4,4,1,1,2,2,10,10,27,27,27,27,1,1,14,14,11,11,17,17,12,12,24,24,26,26,25,25,22,22,7,7,23,23,12,12,15,15,28,28,29,29,19,19,31,31,31,31,8,8,22,22,27,27,27,27,10,10,7,7,27,27,4,4,8,8,5,5,5,5,9,9,20,20,1,1,30,30,14,14,2,2,31,31,20,20,1,1,5,5,17,17,25,25,29,29,17,17,3,3,10,10,12,12,14,14,11,11,6,6,20,20,19,19,27,27,10,10,6,6,13,13,7,7,29,29,17,17,21,21,26,26,25,25,15,15,16,16,7,7,15,15,19,19,12,12,16,16,14,14,2,2,16,16,17,17,15,15,9,9,29,29,29,29,26,26,28,28,20,20,15,15,5,5,1,1,6,6,21,21,6,6,1,1,8,8,6,6,17,17,13,13,25,25,22,22,11,11,23,23,12,12,7,7,3,3,9,9,0,0,0,0,10,10,0,0,16,16,9,9,23,23,24,24,18,18,31,31,7,7,4,4,10,10,13,13,6,6,1,1,17,17,2,2,8,8,4,4,7,7,27,27,24,24,22,22,4,4,27,27,19,19,4,4,24,24,20,20,29,29,19,19,13,13,19,19,15,15,7,7,19,19,8,8,14,14,5,5,26,26,30,30,18,18,24,24,26,26,24,24,2,2,14,14,4,4,15,15,0,0,14,14,26,26,2,2,14,14,6,6,13,13,18,18,20,20,3,3,17,17,19,19,24,24,25,25,9,9,0,0,15,15,20,20,31,31,9,9,24,24,29,29,2,2,21,21,7,7,1,1,6,6,4,4,2,2,7,7,22,22,8,8,21,21,20,20,4,4,24,24,23,23,21,21,10,10,25,25,19,19,2,2,28,28,1,1,17,17,10,10,2,2,14,14,12,12,31,31,7,7,29,29,19,19,30,30,9,9,2,2,24,24,26,26,17,17,11,11,23,23,14,14,26,26,12,12,27,27,3,3,0,0,14,14,28,28,21,21,9,9,29,29,11,11,18,18,20,20,4,4,20,20,17,17,23,23,16,16,13,13,5,5,25,25,16,16,24,24,27,27,27,27,14,14,27,27,11,11,25,25,15,15,5,5,18,18,14,14,0,0,10,10,20,20,15,15,31,31,6,6,5,5,10,10,21,21,9,9,23,23,21,21,24,24,21,21,10,10,18,18,10,10,8,8,4,4,4,4,10,10,7,7,4,4,9,9,8,8,18,18,2,2,14,14,27,27,4,4,0,0,7,7,19,19,20,20,4,4,9,9,13,13,0,0,27,27,13,13,21,21,5,5,0,0,15,15,22,22,2,2,20,20,26,26,15,15,24,24,25,25,26,26,20,20,0,0,29,29,11,11,3,3,24,24,21,21,21,21,11,11,2,2,19,19,2,2,17,17,23,23,3,3,4,4,9,9,2,2,13,13,24,24,14,14,20,20,15,15,4,4,22,22,13,13,8,8,3,3,31,31,15,15,8,8,13,13,26,26,24,24,15,15,24,24,25,25,2,2,18,18,9,9,16,16,1,1,2,2,18,18,21,21,6,6,17,17,20,20,4,4,24,24,5,5,28,28,16,16,10,10,10,10,31,31,17,17,26,26,14,14,14,14,5,5,12,12,2,2,10,10,11,11,17,17,28,28,24,24,7,7,1,1,16,16,15,15,27,27,13,13,28,28,1,1,3,3,21,21,22,22,28,28,9,9,10,10,12,12,19,19,9,9,5,5,15,15,22,22,22,22,9,9,9,9,2,2,6,6,4,4,11,11,2,2,3,3,16,16,1,1,28,28,3,3,8,8,23,23,23,23,10,10,9,9,13,13,24,24,25,25,22,22,26,26,13,13,31,31,10,10,16,16,29,29,16,16,29,29,21,21,25,25,17,17,3,3,3,3,12,12,23,23,30,30,29,29,11,11,25,25,2,2,6,6,21,21,26,26,22,22,26,26,9,9,3,3,6,6,8,8,8,8,3,3,17,17,29,29,11,11,21,21,8,8,7,7,8,8,8,8,13,13,26,26,17,17,2,2,2,2,8,8,31,31,24,24,26,26,5,5,10,10,18,18,17,17,5,5,5,5,11,11,29,29,3,3,29,29,24,24,13,13,17,17,6,6,29,29,18,18,25,25,25,25,19,19,19,19,4,4,21,21,30,30,29,29,0,0,1,1,8,8,30,30,1,1,21,21,31,31,7,7,16,16,11,11,0,0,24,24,11,11,6,6,0,0,20,20,4,4,16,16,4,4,28,28,0,0,23,23,0,0,13,13,26,26,19,19,26,26,31,31,2,2,27,27,4,4,0,0,10,10,31,31,24,24,30,30,30,30,17,17,4,4,27,27,12,12,9,9,7,7,23,23,28,28,15,15,18,18,8,8,0,0,13,13,27,27,26,26,28,28,17,17,13,13,18,18,22,22,20,20,24,24,23,23,24,24,11,11,1,1,8,8,10,10,25,25,13,13,10,10,13,13,13,13,5,5,23,23,13,13,27,27,10,10,10,10,1,1,20,20,18,18,30,30,13,13,17,17,0,0,28,28,22,22,29,29,25,25,11,11,29,29,13,13,6,6,3,3,7,7,12,12,11,11,21,21,28,28,31,31,5,5,16,16,25,25,2,2,20,20,25,25,3,3,24,24,31,31,7,7,3,3,11,11,8,8,8,8,3,3,6,6,8,8,16,16,26,26,27,27,16,16,8,8,10,10,2,2,28,28,11,11,3,3,9,9,1,1,24,24,6,6,2,2,31,31,7,7,15,15,9,9,17,17,26,26,0,0,3,3,4,4,23,23,19,19,0,0,10,10,21,21,28,28,11,11,26,26,12,12,14,14,2,2,9,9,6,6,28,28,31,31,7,7,19,19,11,11,1,1,14,14,26,26,0,0,3,3,28,28,6,6,23,23,5,5,12,12,12,12,28,28,29,29,19,19,0,0,30,30,25,25,13,13,12,12,7,7,17,17,22,22,23,23,0,0,18,18,3,3,17,17,17,17,25,25,31,31,19,19,25,25,24,24,3,3,22,22,4,4,30,30,20,20,19,19,4,4,31,31,20,20,27,27,2,2,30,30,0,0,15,15,10,10,27,27,13,13,1,1,26,26,27,27,19,19,19,19,0,0,1,1,22,22,17,17,21,21,22,22,11,11,27,27,4,4,20,20,6,6,17,17,20,20,13,13,21,21,31,31,16,16,6,6,11,11,9,9,16,16,1,1,1,1,29,29,8,8,18,18,8,8,27,27,9,9,5,5,6,6,6,6,10,10,13,13,6,6,11,11,17,17,25,25,14,14,7,7,25,25,9,9,9,9,28,28,26,26,15,15,25,25,1,1,24,24,21,21,4,4,1,1,0,0,7,7,19,19,5,5,19,19,26,26,5,5,18,18,1,1,2,2,25,25,30,30,2,2,21,21,3,3,7,7,25,25,3,3,17,17,12,12,7,7,16,16,4,4,22,22,26,26,2,2,31,31,12,12,14,14,29,29,14,14,31,31,7,7,6,6,8,8,7,7,5,5,27,27,10,10,31,31,28,28,3,3,24,24,26,26,27,27,7,7,11,11,20,20,25,25,23,23,1,1,1,1,20,20,5,5,28,28,4,4,24,24,0,0,5,5,9,9,28,28,7,7,25,25,4,4,9,9,28,28,12,12,30,30,15,15,19,19,0,0,26,26,20,20,22,22,24,24,30,30,24,24,6,6,12,12,15,15,23,23,10,10,18,18,31,31,22,22,27,27,5,5,1,1,9,9,7,7,19,19,26,26,27,27,1,1,16,16,11,11,22,22,26,26,27,27,0,0,29,29,27,27,20,20,6,6,25,25,14,14,22,22,5,5,9,9,26,26,17,17,22,22,27,27,15,15,4,4,14,14,0,0,12,12,7,7,7,7,28,28,15,15,7,7,2,2,15,15,9,9,15,15,29,29,28,28,18,18,28,28,0,0,29,29,0,0,13,13,30,30,13,13,10,10,14,14,12,12,9,9,21,21,10,10,1,1,11,11,0,0,31,31,10,10,20,20,7,7,22,22,26,26,3,3,28,28,30,30,4,4,0,0,6,6,24,24,20,20,9,9,26,26,0,0,2,2,18,18,2,2,9,9,23,23,6,6,20,20,8,8,31,31,16,16,30,30,19,19,21,21,27,27,6,6,20,20,29,29,17,17,9,9,26,26,8,8,26,26,9,9,2,2,18,18,9,9,14,14,13,13,12,12,16,16,4,4,30,30,11,11,18,18,1,1,10,10,25,25,13,13,6,6,1,1,2,2,5,5,9,9,23,23,2,2,28,28,2,2,31,31,0,0,0,0,24,24,6,6,1,1,22,22,2,2,13,13,23,23,14,14,17,17,3,3,3,3,16,16,13,13,18,18,26,26,14,14,1,1,7,7,17,17,26,26,22,22,13,13,4,4,3,3,14,14,5,5,17,17,16,16,28,28,20,20,13,13,19,19,11,11,22,22,12,12,23,23,10,10,13,13,1,1,4,4,21,21,15,15,16,16,16,16,14,14,21,21,14,14,25,25,20,20,22,22,23,23,2,2,12,12,9,9,29,29,14,14,19,19,12,12,26,26,14,14,13,13,26,26,12,12,21,21,21,21,17,17,1,1,19,19,0,0,5,5,20,20,15,15,0,0,29,29,31,31,9,9,14,14,7,7,20,20,12,12,9,9,21,21,17,17,0,0,30,30,20,20,0,0,10,10,6,6,30,30,29,29,27,27,23,23,8,8,3,3,23,23,20,20,27,27,12,12,27,27,17,17,9,9,23,23,21,21,27,27,18,18,18,18,8,8,15,15,8,8,31,31,28,28,23,23,13,13,2,2,25,25,4,4,8,8,14,14,1,1,30,30,22,22,25,25,31,31,12,12,12,12,16,16,16,16,29,29,11,11,4,4,27,27,22,22,4,4,28,28,27,27,9,9,14,14,16,16,2,2,15,15,24,24,21,21,5,5,6,6,25,25,14,14,30,30,29,29,13,13,18,18,18,18,1,1,11,11,4,4,16,16,27,27,23,23,1,1,22,22,14,14,24,24,12,12,3,3,24,24,17,17,0,0,23,23,21,21,30,30,16,16,0,0,15,15,27,27,24,24,24,24,3,3,24,24,0,0,10,10,22,22,22,22,29,29,9,9,2,2,19,19,13,13,31,31,17,17,0,0,29,29,16,16,19,19,22,22,0,0,16,16,6,6,26,26,16,16,16,16,19,19,26,26,5,5,1,1,14,14,13,13,31,31,11,11,17,17,7,7,24,24,18,18,8,8,27,27,4,4,24,24,18,18,25,25,15,15,18,18,21,21,28,28,30,30,8,8,15,15,8,8,25,25,2,2,13,13,13,13,3,3,16,16,15,15,11,11,12,12,19,19,11,11,13,13,19,19,28,28,29,29,30,30,18,18,17,17,20,20,29,29,30,30,3,3,13,13,31,31,2,2,3,3,22,22,16,16,23,23,13,13,25,25,12,12,28,28,5,5,14,14,18,18,19,19,21,21,1,1,19,19,2,2,18,18,3,3,29,29,18,18,2,2,9,9,2,2,23,23,4,4,18,18,29,29,31,31,26,26,15,15,1,1,7,7,19,19,13,13,10,10,15,15,25,25,17,17,7,7,31,31,14,14,19,19,17,17,28,28,21,21,19,19,8,8,21,21,0,0,28,28,17,17,4,4,4,4,25,25,16,16,24,24,21,21,12,12,27,27,2,2,24,24,30,30,28,28,14,14,2,2,19,19,10,10,12,12,16,16,21,21,27,27,22,22,6,6,2,2,23,23,9,9,19,19,1,1,18,18,21,21,24,24,26,26,31,31,25,25,26,26,4,4,6,6,17,17,11,11,6,6,29,29,1,1,25,25,5,5,4,4,5,5,1,1,27,27,19,19,23,23,19,19,24,24,22,22,17,17,13,13,2,2,0,0,18,18,6,6,18,18,28,28,2,2,20,20,6,6,13,13,26,26,18,18,30,30,31,31,22,22,6,6,31,31,17,17,11,11,14,14,16,16,8,8,8,8,11,11,5,5,9,9,16,16,10,10,4,4,1,1,24,24,22,22,11,11,21,21,14,14,25,25,4,4,30,30,14,14,12,12,4,4,15,15,0,0,26,26,9,9,28,28,7,7,0,0,28,28,15,15,3,3,6,6,5,5,8,8,18,18,8,8,24,24,25,25,29,29,17,17,18,18,3,3,3,3,9,9,14,14,16,16,25,25,5,5,15,15,26,26,11,11,12,12,11,11,8,8,7,7,19,19,2,2,11,11,29,29,21,21,21,21,0,0,9,9,12,12,20,20,7,7,15,15,18,18,6,6,18,18,27,27,28,28,19,19,4,4,10,10,21,21,11,11,20,20,18,18,9,9,24,24,23,23,4,4,5,5,24,24,16,16,0,0,12,12,2,2,24,24,0,0,1,1,29,29,7,7,5,5,7,7,6,6,6,6,7,7,19,19,4,4,7,7,8,8,26,26,16,16,31,31,9,9,29,29,1,1,15,15,6,6,29,29,4,4,9,9,10,10,2,2,26,26,2,2,23,23,19,19,29,29,13,13,27,27,5,5,23,23,0,0,25,25,19,19,14,14,26,26,22,22,18,18,5,5,21,21,13,13,5,5,4,4,28,28,7,7,12,12,13,13,6,6,2,2,30,30,18,18,13,13,18,18,16,16,13,13,31,31,1,1,27,27,8,8,0,0,16,16,28,28,5,5,5,5,12,12,1,1,12,12,27,27,15,15,14,14,4,4,14,14,22,22,8,8,15,15,3,3,19,19,14,14,15,15,10,10,11,11,20,20,16,16,16,16,11,11,28,28,5,5,19,19,1,1,9,9,3,3,27,27,13,13,29,29,31,31,9,9,19,19,1,1,12,12,31,31,27,27,4,4,5,5,10,10,11,11,7,7,20,20,22,22,5,5,0,0,26,26,3,3,9,9,16,16,24,24,22,22,3,3,15,15,25,25,12,12,26,26,2,2,19,19,14,14,18,18,4,4,11,11,9,9,27,27,21,21,3,3,9,9,6,6,14,14,6,6,28,28,14,14,18,18,9,9,15,15,17,17,26,26,29,29,18,18,18,18,18,18,21,21,19,19,20,20,14,14,7,7,5,5,24,24,4,4,3,3,26,26,8,8,21,21,27,27,8,8,14,14,29,29,10,10,27,27,2,2,24,24,12,12,14,14,6,6,14,14,3,3,3,3,16,16,27,27,30,30,1,1,8,8,27,27,26,26,5,5,12,12,0,0,27,27,26,26,30,30,4,4,11,11,23,23,24,24,25,25,11,11,8,8,3,3,21,21,3,3,30,30,12,12,23,23,0,0,17,17,25,25,2,2,2,2,4,4,20,20,12,12,29,29,3,3,22,22,31,31,18,18,15,15,21,21,10,10,15,15,1,1,9,9,30,30,30,30,5,5,1,1,8,8,6,6,22,22,31,31,30,30,31,31,13,13,12,12,16,16,19,19,3,3,26,26,20,20,0,0,26,26,15,15,4,4,14,14,9,9,12,12,6,6,17,17,20,20,25,25,15,15,15,15,17,17,28,28,9,9,31,31,28,28,25,25,8,8,17,17,11,11,12,12,12,12,9,9,24,24,11,11,29,29,5,5,0,0,26,26,8,8,15,15,12,12,13,13,19,19,21,21,5,5,5,5,27,27,18,18,3,3,29,29,19,19,20,20,8,8,11,11,31,31,21,21,0,0,2,2,15,15,26,26,8,8,24,24,31,31,31,31,11,11,15,15,8,8,11,11,23,23,7,7,31,31,26,26,16,16,8,8,21,21,1,1,26,26,31,31,16,16,5,5,30,30,11,11,14,14,2,2,23,23,25,25,30,30,13,13,19,19,26,26,23,23,29,29,18,18,28,28,31,31,31,31,22,22,19,19,20,20,26,26,13,13,13,13,2,2,0,0,9,9,29,29,12,12,13,13,8,8,27,27,27,27,15,15,10,10,30,30,1,1,16,16,18,18,6,6,10,10,11,11,24,24,20,20,21,21,28,28,17,17,5,5,2,2,16,16,23,23,21,21,16,16,26,26,22,22,8,8,31,31,4,4,9,9,14,14,24,24,5,5,5,5,5,5,10,10,27,27,21,21,1,1,19,19,14,14,10,10,9,9,9,9,7,7,4,4,2,2,14,14,2,2,18,18,6,6,24,24,8,8,12,12,20,20,26,26,14,14,3,3,27,27,4,4,1,1,3,3,31,31,21,21,27,27,25,25,11,11,1,1,6,6,12,12,6,6,31,31,17,17,8,8,28,28,5,5,29,29,19,19,3,3,1,1,30,30,0,0,30,30,0,0,22,22,17,17,17,17,12,12,20,20,25,25,22,22,6,6,2,2,27,27,11,11,3,3,18,18,20,20,11,11,28,28,17,17,1,1,13,13,23,23,23,23,14,14,25,25,9,9,7,7,7,7,12,12,31,31,28,28,11,11,21,21,8,8,27,27,28,28,5,5,5,5,22,22,15,15,13,13,19,19,27,27,26,26,7,7,16,16,30,30,8,8,10,10,20,20,23,23,21,21,17,17,26,26,24,24,12,12,27,27,29,29,21,21,31,31,3,3,7,7,10,10,5,5,8,8,18,18,2,2,10,10,12,12,31,31,20,20,28,28,20,20,0,0,13,13,8,8,9,9,12,12,30,30,18,18,16,16,9,9,27,27,2,2,27,27,15,15,11,11,31,31,12,12,19,19,18,18,8,8,26,26,13,13,6,6,15,15,2,2,1,1,28,28,5,5,5,5,28,28,0,0,22,22,25,25,2,2,20,20,9,9,23,23,8,8,13,13,17,17,0,0,6,6,22,22,27,27,10,10,25,25,21,21,5,5,12,12,5,5,14,14,30,30,13,13,24,24,16,16,13,13,6,6,5,5,28,28,17,17,17,17,14,14,23,23,11,11,11,11,26,26,8,8,7,7,4,4,14,14,2,2,26,26,2,2,28,28,6,6,17,17,25,25,26,26,13,13,20,20,28,28,31,31,13,13,17,17,17,17,4,4,27,27,10,10,12,12,10,10,16,16,18,18,10,10,5,5,5,5,29,29,11,11,23,23,23,23,21,21,15,15,25,25,30,30,11,11,20,20,2,2,24,24,0,0,3,3,20,20,27,27,29,29,11,11,7,7,19,19,11,11,0,0,6,6,15,15,18,18,20,20,21,21,30,30,10,10,11,11,19,19,15,15,31,31,18,18,9,9,2,2,23,23,15,15,31,31,26,26,4,4,11,11,31,31,11,11,22,22,1,1,24,24,22,22,10,10,26,26,20,20,2,2,20,20,12,12,16,16,15,15,18,18,21,21,10,10,2,2,18,18,12,12,29,29,30,30,23,23,27,27,20,20,15,15,4,4,3,3,3,3,23,23,23,23,9,9,12,12,20,20,7,7,20,20,4,4,4,4,22,22,8,8,21,21,5,5,23,23,10,10,26,26,9,9,10,10,28,28,11,11,26,26,12,12,4,4,6,6,15,15,3,3,22,22,24,24,25,25,8,8,10,10,17,17,13,13,8,8,27,27,28,28,29,29,19,19,28,28,12,12,29,29,18,18,2,2,18,18,19,19,24,24,5,5,19,19,8,8,24,24,8,8,7,7,2,2,22,22,24,24,22,22,12,12,17,17,6,6,0,0,24,24,18,18,22,22,11,11,19,19,20,20,12,12,7,7,13,13,0,0,14,14,7,7,17,17,6,6,7,7,22,22,11,11,7,7,28,28,9,9,15,15,2,2,2,2,23,23,12,12,14,14,14,14,11,11,31,31,3,3,30,30,0,0,2,2,11,11,24,24,2,2,18,18,19,19,27,27,5,5,31,31,1,1,23,23,16,16,27,27,9,9,8,8,23,23,5,5,11,11,24,24,3,3,26,26,28,28,16,16,10,10,26,26,9,9,14,14,28,28,3,3,6,6,8,8,21,21,3,3,15,15,19,19,23,23,10,10,19,19,4,4,12,12,17,17,3,3,29,29,18,18,25,25,21,21,19,19,29,29,16,16,24,24,21,21,22,22,12,12,22,22,11,11,22,22,11,11,30,30,20,20,21,21,4,4,1,1,25,25,28,28,3,3,0,0,5,5,5,5,23,23,16,16,22,22,13,13,31,31,4,4,10,10,11,11,7,7,18,18,14,14,22,22,19,19,2,2,10,10,20,20,16,16,17,17,15,15,28,28,7,7,7,7,17,17,29,29,8,8,18,18,9,9,14,14,24,24,13,13,19,19,1,1,25,25,16,16,12,12,3,3,17,17,16,16,21,21,8,8,28,28,24,24,11,11,16,16,9,9,31,31,31,31,1,1,25,25,8,8,1,1,15,15,28,28,7,7,5,5,5,5,28,28,16,16,10,10,10,10,13,13,14,14,14,14,28,28,7,7,9,9,1,1,24,24,18,18,30,30,2,2,26,26,5,5,15,15,2,2,14,14,0,0,9,9,4,4,0,0,18,18,22,22,22,22,8,8,29,29,2,2,23,23,1,1,13,13,18,18,0,0,18,18,9,9,19,19,3,3,22,22,25,25,28,28,9,9,17,17,25,25,16,16,25,25,10,10,11,11,7,7,12,12,28,28,10,10,6,6,9,9,23,23,12,12,0,0,22,22,24,24,15,15,29,29,20,20,4,4,15,15,25,25,7,7,10,10,16,16,7,7,13,13,10,10,8,8,10,10,19,19,14,14,16,16,5,5,14,14,25,25,5,5,30,30,9,9,6,6,10,10,0,0,15,15,21,21,24,24,11,11,23,23,31,31,10,10,3,3,1,1,17,17,3,3,2,2,8,8,27,27,21,21,21,21,17,17,10,10,8,8,28,28,26,26,22,22,8,8,28,28,19,19,2,2,29,29,19,19,10,10,5,5,10,10,31,31,14,14,9,9,5,5,8,8,28,28,22,22,1,1,10,10,20,20,31,31,24,24,0,0,24,24,19,19,31,31,6,6,15,15,20,20,29,29,11,11,22,22,29,29,20,20,22,22,23,23,16,16,6,6,12,12,27,27,4,4,15,15,21,21,3,3,5,5,4,4,0,0,14,14,6,6,27,27,0,0,0,0,5,5,9,9,21,21,16,16,6,6,4,4,16,16,25,25,21,21,18,18,5,5,30,30,17,17,27,27,9,9,17,17,3,3,12,12,21,21,25,25,27,27,12,12,26,26,25,25,1,1,7,7,3,3,3,3,13,13,6,6,15,15,3,3,7,7,13,13,18,18,1,1,12,12,0,0,26,26,24,24,0,0,6,6,31,31,17,17,1,1,15,15,30,30,20,20,18,18,13,13,10,10,4,4,3,3,3,3,14,14,16,16,26,26,9,9,25,25,13,13,18,18,4,4,8,8,8,8,8,8,5,5,3,3,28,28,19,19,7,7,0,0,29,29,15,15,15,15,26,26,9,9,3,3,21,21,26,26,18,18,11,11,24,24,16,16,15,15,16,16,19,19,24,24,18,18,19,19,18,18,24,24,11,11,1,1,18,18,1,1,19,19,21,21,29,29,12,12,5,5,16,16,26,26,13,13,9,9,6,6,15,15,17,17,1,1,0,0,18,18,12,12,19,19,2,2,12,12,27,27,8,8,0,0,2,2,5,5,2,2,28,28,5,5,16,16,30,30,20,20,7,7,25,25,30,30,22,22,12,12,29,29,26,26,8,8,7,7,4,4,0,0,7,7,3,3,5,5,11,11,11,11,28,28,7,7,23,23,4,4,11,11,10,10,4,4,2,2,9,9,9,9,15,15,21,21,13,13,28,28,23,23,9,9,27,27,12,12,14,14,12,12,29,29,1,1,25,25,7,7,19,19,26,26,29,29,26,26,9,9,21,21,13,13,27,27,14,14,25,25,20,20,2,2,2,2,3,3,31,31,28,28,30,30,1,1,25,25,6,6,25,25,16,16,9,9,25,25,28,28,26,26,8,8,17,17,19,19,27,27,28,28,11,11,22,22,22,22,31,31,0,0,17,17,20,20,27,27,25,25,23,23,4,4,21,21,24,24,5,5,13,13,24,24,8,8,11,11,26,26,24,24,17,17,10,10,16,16,16,16,30,30,6,6,26,26,31,31,21,21,7,7,13,13,27,27,26,26,23,23,2,2,9,9,30,30,28,28,9,9,5,5,11,11,27,27,3,3,31,31,27,27,16,16,12,12,5,5,10,10,2,2,10,10,14,14,16,16,0,0,18,18,9,9,12,12,1,1,21,21,30,30,27,27,28,28,0,0,14,14,8,8,11,11,26,26,9,9,14,14,14,14,1,1,28,28,24,24,18,18,5,5,15,15,17,17,1,1,27,27,6,6,5,5,0,0,20,20,0,0,9,9,2,2,21,21,7,7,25,25,22,22,14,14,2,2,8,8,9,9,18,18,1,1,12,12,1,1,4,4,7,7,29,29,15,15,22,22,19,19,3,3,0,0,1,1,6,6,16,16,9,9,23,23,29,29,28,28,15,15,11,11,27,27,6,6,16,16,19,19,2,2,24,24,25,25,17,17,20,20,26,26,29,29,15,15,11,11,24,24,11,11,13,13,26,26,5,5,10,10,3,3,24,24,25,25,11,11,20,20,24,24,5,5,13,13,27,27,30,30,18,18,27,27,22,22,19,19,2,2,31,31,18,18,28,28,31,31,18,18,22,22,9,9,28,28,10,10,27,27,27,27,3,3,12,12,18,18,23,23,18,18,30,30,0,0,29,29,1,1,17,17,8,8,19,19,1,1,25,25,28,28,19,19,4,4,16,16,8,8,6,6,23,23,13,13,4,4,20,20,18,18,16,16,19,19,25,25,13,13,12,12,19,19,24,24,23,23,9,9,22,22,19,19,25,25,23,23,1,1,21,21,3,3,10,10,17,17,3,3,24,24,28,28,5,5,4,4,7,7,13,13,12,12,24,24,31,31,12,12,0,0,10,10,8,8,5,5,19,19,0,0,26,26,29,29,21,21,23,23,1,1,2,2,4,4,27,27,19,19,31,31,2,2,28,28,9,9,3,3,8,8,18,18,9,9,12,12,23,23,24,24,0,0,25,25,11,11,11,11,4,4,6,6,2,2,15,15,21,21,1,1,6,6,12,12,24,24,18,18,12,12,13,13,15,15,6,6,8,8,16,16,21,21,2,2,21,21,12,12,13,13,22,22,0,0,11,11,19,19,15,15,9,9,30,30,25,25,3,3,27,27,29,29,27,27,29,29,1,1,23,23,1,1,12,12,8,8,17,17,15,15,0,0,21,21,20,20,8,8,26,26,31,31,27,27,1,1,10,10,29,29,24,24,19,19,8,8,27,27,16,16,8,8,3,3,6,6,26,26,5,5,28,28,29,29,14,14,0,0,21,21,28,28,15,15,19,19,27,27,10,10,6,6,14,14,31,31,10,10,5,5,31,31,4,4,19,19,17,17,16,16,25,25,13,13,4,4,9,9,8,8,12,12,21,21,29,29,12,12,15,15,8,8,10,10,13,13,12,12,17,17,23,23,5,5,16,16,12,12,22,22,7,7,28,28,20,20,7,7,20,20,7,7,4,4,20,20,11,11,9,9,0,0,17,17,1,1,15,15,15,15,13,13,14,14,29,29,15,15,8,8,14,14,20,20,16,16,1,1,10,10,1,1,3,3,5,5,3,3,1,1,22,22,18,18,0,0,22,22,25,25,14,14,30,30,1,1,11,11,11,11,7,7,23,23,25,25,2,2,29,29,25,25,11,11,5,5,26,26,19,19,20,20,25,25,26,26,8,8,17,17,2,2,23,23,17,17,23,23,18,18,26,26,24,24,0,0,23,23,7,7,4,4,0,0,2,2,2,2,9,9,15,15,23,23,11,11,28,28,18,18,29,29,2,2,24,24,12,12,12,12,6,6,19,19,4,4,2,2,16,16,1,1,0,0,2,2,14,14,8,8,21,21,16,16,15,15,23,23,16,16,2,2,8,8,25,25,13,13,10,10,17,17,3,3,28,28,8,8,0,0,13,13,6,6,18,18,15,15,9,9,1,1,19,19,30,30,7,7,13,13,19,19,4,4,31,31,4,4,28,28,5,5,31,31,13,13,12,12,30,30,25,25,28,28,5,5,27,27,18,18,25,25,1,1,2,2,6,6,20,20,8,8,15,15,2,2,1,1,13,13,14,14,29,29,31,31,17,17,12,12,4,4,1,1,25,25,13,13,15,15,13,13,11,11,10,10,18,18,28,28,8,8,20,20,5,5,30,30,28,28,3,3,27,27,11,11,16,16,0,0,4,4,6,6,21,21,12,12,1,1,1,1,14,14,17,17,20,20,21,21,20,20,11,11,8,8,5,5,13,13,13,13,26,26,0,0,20,20,17,17,12,12,19,19,15,15,23,23,29,29,10,10,7,7,1,1,11,11,1,1,23,23,17,17,7,7,24,24,16,16,6,6,15,15,26,26,16,16,10,10,11,11,18,18,6,6,2,2,25,25,9,9,28,28,27,27,2,2,17,17,30,30,4,4,13,13,11,11,17,17,5,5,6,6,3,3,16,16,0,0,30,30,10,10,6,6,5,5,16,16,4,4,26,26,28,28,1,1,19,19,15,15,25,25,11,11,13,13,17,17,19,19,7,7,4,4,14,14,24,24,29,29,8,8,14,14,13,13,2,2,17,17,17,17,28,28,15,15,6,6,12,12,4,4,30,30,15,15,12,12,28,28,30,30,0,0,20,20,12,12,7,7,23,23,31,31,19,19,26,26,12,12,19,19,0,0,27,27,24,24,20,20,25,25,5,5,21,21,17,17,24,24,6,6,19,19,12,12,21,21,4,4,5,5,20,20,7,7,7,7,20,20,16,16,25,25,2,2,30,30,9,9,29,29,3,3,26,26,25,25,12,12,16,16,29,29,1,1,0,0,9,9,11,11,20,20,31,31,15,15,23,23,28,28,13,13,28,28,4,4,0,0,7,7,30,30,27,27,22,22,1,1,5,5,30,30,13,13,17,17,17,17,20,20,5,5,14,14,29,29,4,4,11,11,21,21,15,15,23,23,1,1,27,27,13,13,12,12,10,10,18,18,16,16,4,4,18,18,27,27,14,14,16,16,12,12,27,27,3,3,14,14,4,4,12,12,15,15,31,31,8,8,10,10,19,19,25,25,3,3,14,14,1,1,29,29,31,31,18,18,17,17,17,17,30,30,4,4,12,12,12,12,11,11,17,17,21,21,15,15,1,1,14,14,0,0,0,0,25,25,9,9,9,9,16,16,16,16,26,26,27,27,22,22,1,1,14,14,0,0,25,25,19,19,29,29,30,30,27,27,2,2,30,30,18,18,17,17,26,26,31,31,5,5,22,22,4,4,13,13,29,29,26,26,4,4,12,12,9,9,17,17,2,2,20,20,4,4,8,8,2,2,3,3,20,20,1,1,30,30,24,24,26,26,5,5,1,1,5,5,18,18,12,12,12,12,22,22,18,18,3,3,21,21,26,26,2,2,0,0,28,28,3,3,2,2,9,9,30,30,18,18,0,0,25,25,4,4,12,12,0,0,31,31,30,30,3,3,8,8,27,27,4,4,20,20,28,28,25,25,11,11,3,3,11,11,31,31,4,4,28,28,16,16,1,1,9,9,20,20,5,5,4,4,0,0,1,1,25,25,12,12,0,0,9,9,26,26,10,10,16,16,23,23,21,21,26,26,13,13,19,19,12,12,28,28,22,22,17,17,20,20,8,8,26,26,18,18,25,25,12,12,18,18,22,22,9,9,21,21,8,8,26,26,12,12,5,5,2,2,0,0,23,23,4,4,13,13,14,14,8,8,2,2,2,2,9,9,22,22,20,20,8,8,8,8,25,25,21,21,18,18,23,23,9,9,18,18,8,8,8,8,29,29,19,19,21,21,5,5,12,12,4,4,14,14,10,10,24,24,31,31,23,23,3,3,20,20,1,1,13,13,10,10,28,28,4,4,4,4,2,2,18,18,26,26,14,14,8,8,4,4,30,30,5,5,24,24,9,9,17,17,25,25,5,5,7,7,18,18,16,16,7,7,12,12,30,30,30,30,5,5,3,3,12,12,16,16,11,11,10,10,8,8,28,28,30,30,9,9,24,24,24,24,23,23,1,1,16,16,6,6,8,8,2,2,3,3,29,29,10,10,9,9,16,16,21,21,5,5,8,8,17,17,20,20,30,30,8,8,5,5,25,25,11,11,25,25,5,5,26,26,13,13,13,13,8,8,19,19,8,8,1,1,3,3,14,14,7,7,25,25,16,16,29,29,7,7,28,28,0,0,17,17,13,13,21,21,19,19,31,31,28,28,19,19,17,17,1,1,30,30,7,7,13,13,25,25,25,25,28,28,23,23,14,14,1,1,8,8,1,1,25,25,7,7,5,5,23,23,19,19,11,11,24,24,0,0,31,31,6,6,17,17,1,1,26,26,0,0,0,0,21,21,10,10,17,17,29,29,10,10,8,8,26,26,12,12,4,4,21,21,14,14,19,19,20,20,21,21,15,15,16,16,20,20,6,6,9,9,12,12,30,30,14,14,27,27,30,30,19,19,9,9,25,25,7,7,1,1,22,22,15,15,16,16,28,28,29,29,13,13,8,8,18,18,18,18,1,1,26,26,28,28,3,3,21,21,29,29,24,24,7,7,8,8,13,13,5,5,10,10,11,11,31,31,29,29,18,18,13,13,22,22,23,23,11,11,26,26,1,1,8,8,22,22,14,14,16,16,14,14,18,18,30,30,21,21,8,8,20,20,30,30,10,10,16,16,0,0,9,9,2,2,5,5,12,12,16,16,11,11,5,5,14,14,7,7,18,18,5,5,28,28,10,10,18,18,14,14,21,21,31,31,4,4,23,23,16,16,27,27,16,16,25,25,19,19,14,14,20,20,4,4,31,31,19,19,24,24,5,5,7,7,1,1,6,6,21,21,13,13,27,27,13,13,13,13,23,23,18,18,14,14,16,16,25,25,12,12,3,3,24,24,25,25,1,1,6,6,9,9,27,27,30,30,10,10,19,19,1,1,17,17,22,22,4,4,9,9,16,16,2,2,30,30,17,17,3,3,11,11,24,24,12,12,25,25,18,18,11,11,1,1,25,25,17,17,6,6,17,17,22,22,8,8,30,30,15,15,17,17,16,16,2,2,19,19,10,10,3,3,20,20,13,13,12,12,14,14,14,14,4,4,8,8,21,21,28,28,21,21,4,4,25,25,17,17,12,12,0,0,10,10,31,31,14,14,29,29,13,13,15,15,5,5,13,13,29,29,23,23,12,12,7,7,3,3,8,8,14,14,17,17,0,0,8,8,5,5,8,8,0,0,6,6,12,12,26,26,16,16,24,24,18,18,6,6,14,14,3,3,2,2,9,9,18,18,21,21,16,16,0,0,9,9,1,1,26,26,24,24,2,2,19,19,0,0,27,27,16,16,8,8,19,19,10,10,8,8,19,19,18,18,8,8,8,8,12,12,17,17,15,15,26,26,16,16,17,17,3,3,21,21,20,20,27,27,11,11,8,8,23,23,26,26,0,0,19,19,26,26,10,10,16,16,1,1,14,14,25,25,10,10,27,27,25,25,27,27,17,17,24,24,5,5,24,24,4,4,4,4,8,8,9,9,16,16,16,16,0,0,3,3,24,24,24,24,29,29,0,0,2,2,31,31,8,8,20,20,16,16,30,30,25,25,12,12,22,22,13,13,6,6,0,0,6,6,19,19,4,4,1,1,31,31,16,16,8,8,0,0,1,1,10,10,21,21,24,24,6,6,10,10,26,26,17,17,0,0,11,11,9,9,0,0,17,17,15,15,23,23,29,29,16,16,9,9,16,16,5,5,6,6,9,9,26,26,11,11,28,28,20,20,24,24,29,29,9,9,18,18,23,23,1,1,2,2,1,1,4,4,25,25,9,9,31,31,12,12,0,0,16,16,22,22,11,11,25,25,18,18,0,0,2,2,31,31,7,7,12,12,1,1,29,29,0,0,8,8,11,11,8,8,2,2,10,10,28,28,18,18,27,27,22,22,24,24,3,3,17,17,17,17,21,21,0,0,26,26,1,1,24,24,21,21,8,8,20,20,5,5,3,3,8,8,22,22,13,13,16,16,28,28,2,2,25,25,24,24,10,10,26,26,24,24,5,5,0,0,29,29,25,25,4,4,1,1,25,25,2,2,12,12,8,8,6,6,3,3,9,9,11,11,26,26,20,20,9,9,0,0,0,0,26,26,27,27,4,4,4,4,6,6,24,24,12,12,1,1,2,2,8,8,4,4,23,23,15,15,5,5,16,16,23,23,25,25,21,21,16,16,21,21,2,2,6,6,21,21,2,2,27,27,5,5,22,22,4,4,28,28,29,29,9,9,16,16,7,7,14,14,2,2,27,27,9,9,5,5,23,23,1,1,5,5,5,5,20,20,9,9,16,16,10,10,30,30,19,19,23,23,0,0,0,0,19,19,25,25,6,6,7,7,23,23,19,19,13,13,18,18,24,24,12,12,20,20,3,3,17,17,5,5,19,19,19,19,31,31,19,19,20,20,26,26,14,14,8,8,11,11,2,2,30,30,7,7,25,25,4,4,26,26,13,13,8,8,29,29,1,1,20,20,13,13,22,22,24,24,6,6,3,3,4,4,15,15,26,26,30,30,10,10,31,31,1,1,28,28,13,13,3,3,29,29,10,10,20,20,4,4,16,16,1,1,31,31,31,31,16,16,18,18,21,21,18,18,23,23,27,27,11,11,11,11,20,20,15,15,15,15,22,22,8,8,24,24,21,21,24,24,16,16,23,23,19,19,0,0,6,6,2,2,4,4,13,13,14,14,3,3,12,12,12,12,6,6,20,20,7,7,5,5,9,9,28,28,8,8,3,3,10,10,3,3,13,13,18,18,16,16,31,31,1,1,28,28,10,10,5,5,20,20,13,13,29,29,6,6,4,4,7,7,12,12,6,6,24,24,4,4,4,4,17,17,7,7,0,0,9,9,9,9,3,3,19,19,16,16,6,6,8,8,0,0,25,25,29,29,5,5,12,12,28,28,12,12,14,14,5,5,13,13,12,12,26,26,19,19,8,8,19,19,20,20,2,2,29,29,1,1,8,8,7,7,27,27,0,0,15,15,26,26,4,4,7,7,9,9,15,15,5,5,21,21,12,12,26,26,11,11,19,19,30,30,11,11,3,3,16,16,16,16,18,18,0,0,3,3,4,4,13,13,2,2,6,6,5,5,30,30,1,1,10,10,1,1,1,1,3,3,6,6,0,0,19,19,8,8,18,18,24,24,0,0,24,24,18,18,26,26,22,22,22,22,16,16,17,17,11,11,11,11,1,1,12,12,16,16,10,10,21,21,2,2,21,21,12,12,15,15,24,24,14,14,8,8,21,21,2,2,21,21,1,1,25,25,7,7,11,11,31,31,10,10,19,19,7,7,12,12,12,12,24,24,21,21,29,29,17,17,15,15,28,28,12,12,26,26,18,18,12,12,19,19,17,17,4,4,7,7,2,2,28,28,16,16,13,13,6,6,3,3,24,24,20,20,3,3,15,15,3,3,18,18,4,4,6,6,20,20,2,2,11,11,26,26,1,1,25,25,27,27,29,29,4,4,12,12,15,15,19,19,10,10,10,10,13,13,10,10,18,18,23,23,10,10,6,6,9,9,19,19,29,29,21,21,5,5,5,5,29,29,12,12,0,0,13,13,14,14,31,31,15,15,16,16,1,1,1,1,30,30,26,26,8,8,24,24,18,18,24,24,12,12,5,5,0,0,23,23,1,1,0,0,31,31,27,27,3,3,4,4,25,25,13,13,12,12,24,24,14,14,0,0,12,12,22,22,18,18,27,27,2,2,10,10,6,6,25,25,21,21,28,28,7,7,13,13,11,11,31,31,17,17,26,26,28,28,3,3,23,23,8,8,7,7,17,17,3,3,26,26,9,9,25,25,24,24,26,26,6,6,0,0,9,9,3,3,17,17,14,14,2,2,25,25,11,11,5,5,4,4,17,17,10,10,26,26,7,7,31,31,28,28,3,3,14,14,22,22,15,15,5,5,28,28,25,25,29,29,8,8,20,20,7,7,11,11,25,25,25,25,5,5,23,23,13,13,13,13,10,10,16,16,4,4,24,24,23,23,13,13,3,3,25,25,23,23,6,6,15,15,31,31,5,5,2,2,1,1,0,0,22,22,0,0,1,1,9,9,17,17,14,14,29,29,4,4,27,27,6,6,5,5,27,27,1,1,1,1,20,20,20,20,11,11,23,23,9,9,13,13,28,28,28,28,27,27,19,19,27,27,28,28,18,18,29,29,0,0,1,1,8,8,31,31,2,2,17,17,2,2,16,16,18,18,10,10,0,0,21,21,6,6,3,3,13,13,8,8,1,1,16,16,1,1,10,10,3,3,24,24,22,22,18,18,1,1,22,22,19,19,31,31,18,18,28,28,25,25,8,8,11,11,7,7,29,29,29,29,25,25,17,17,1,1,4,4,1,1,22,22,4,4,3,3,5,5,17,17,8,8,2,2,6,6,4,4,20,20,21,21,5,5,0,0,17,17,8,8,12,12,10,10,18,18,5,5,22,22,12,12,19,19,24,24,5,5,17,17,25,25,21,21,14,14,16,16,22,22,25,25,21,21,3,3,23,23,27,27,26,26,13,13,7,7,21,21,13,13,26,26,25,25,21,21,24,24,16,16,30,30,27,27,31,31,7,7,24,24,14,14,20,20,18,18,2,2,22,22,21,21,18,18,4,4,18,18,26,26,8,8,22,22,12,12,3,3,13,13,15,15,7,7,24,24,1,1,13,13,20,20,12,12,13,13,13,13,8,8,26,26,11,11,1,1,14,14,0,0,3,3,15,15,30,30,18,18,24,24,26,26,1,1,18,18,29,29,9,9,18,18,25,25,21,21,14,14,18,18,15,15,13,13,11,11,12,12,3,3,31,31,5,5,5,5,16,16,20,20,27,27,11,11,26,26,22,22,9,9,0,0,26,26,8,8,14,14,17,17,17,17,2,2,8,8,9,9,23,23,28,28,5,5,30,30,0,0,19,19,25,25,11,11,15,15,20,20,13,13,3,3,31,31,27,27,0,0,4,4,11,11,12,12,22,22,27,27,27,27,11,11,15,15,2,2,11,11,13,13,23,23,0,0,25,25,31,31,14,14,26,26,19,19,2,2,4,4,5,5,31,31,9,9,21,21,5,5,20,20,22,22,2,2,25,25,13,13,19,19,25,25,5,5,18,18,23,23,25,25,15,15,30,30,21,21,29,29,22,22,25,25,21,21,23,23,8,8,28,28,29,29,2,2,15,15,5,5,0,0,3,3,20,20,31,31,5,5,24,24,11,11,24,24,1,1,15,15,2,2,11,11,24,24,10,10,22,22,28,28,19,19,23,23,16,16,23,23,0,0,0,0,20,20,11,11,8,8,8,8,2,2,3,3,13,13,20,20,23,23,24,24,29,29,16,16,9,9,20,20,5,5,31,31,16,16,24,24,5,5,28,28,29,29,1,1,21,21,0,0,1,1,7,7,10,10,20,20,29,29,4,4,15,15,18,18,30,30,30,30,3,3,18,18,27,27,27,27,8,8,23,23,3,3,11,11,21,21,12,12,14,14,26,26,11,11,25,25,18,18,26,26,24,24,15,15,10,10,15,15,16,16,0,0,14,14,11,11,14,14,20,20,11,11,19,19,8,8,8,8,8,8,6,6,8,8,9,9,29,29,29,29,18,18,0,0,27,27,15,15,20,20,5,5,20,20,1,1,25,25,6,6,1,1,9,9,21,21,26,26,1,1,13,13,10,10,19,19,18,18,28,28,5,5,24,24,18,18,3,3,26,26,28,28,24,24,18,18,21,21,4,4,14,14,25,25,14,14,5,5,23,23,11,11,22,22,24,24,17,17,31,31,28,28,11,11,5,5,6,6,26,26,6,6,31,31,1,1,29,29,29,29,28,28,22,22,14,14,2,2,3,3,21,21,23,23,9,9,19,19,1,1,1,1,5,5,3,3,30,30,10,10,16,16,15,15,13,13,15,15,24,24,6,6,10,10,3,3,18,18,24,24,20,20,24,24,21,21,7,7,31,31,13,13,30,30,8,8,29,29,1,1,25,25,28,28,4,4,17,17,14,14,5,5,4,4,9,9,1,1,4,4,29,29,24,24,8,8,27,27,4,4,29,29,9,9,24,24,9,9,22,22,27,27,12,12,12,12,2,2,23,23,10,10,9,9,17,17,7,7,21,21,18,18,15,15,2,2,24,24,15,15,24,24,10,10,8,8,3,3,21,21,1,1,27,27,30,30,7,7,23,23,1,1,22,22,27,27,5,5,23,23,19,19,23,23,9,9,23,23,26,26,13,13,10,10,19,19,10,10,16,16,10,10,13,13,1,1,16,16,14,14,2,2,27,27,14,14,14,14,1,1,17,17,22,22,10,10,2,2,5,5,7,7,27,27,14,14,4,4,16,16,29,29,26,26,1,1,14,14,19,19,22,22,13,13,2,2,18,18,11,11,17,17,13,13,31,31,29,29,28,28,13,13,29,29,2,2,29,29,8,8,4,4,22,22,13,13,15,15,4,4,27,27,5,5,17,17,4,4,2,2,31,31,22,22,22,22,14,14,30,30,12,12,27,27,18,18,9,9,10,10,13,13,10,10,11,11,9,9,24,24,4,4,22,22,0,0,25,25,26,26,0,0,10,10,20,20,4,4,23,23,8,8,4,4,17,17,19,19,14,14,7,7,22,22,8,8,1,1,5,5,11,11,23,23,8,8,29,29,5,5,3,3,21,21,28,28,24,24,5,5,11,11,29,29,3,3,17,17,0,0,14,14,14,14,11,11,21,21,24,24,21,21,2,2,13,13,23,23,2,2,17,17,15,15,22,22,18,18,1,1,18,18,5,5,12,12,19,19,28,28,24,24,2,2,30,30,28,28,6,6,17,17,17,17,4,4,23,23,8,8,16,16,8,8,2,2,2,2,17,17,2,2,5,5,18,18,4,4,23,23,15,15,24,24,5,5,19,19,10,10,20,20,12,12,16,16,15,15,12,12,3,3,13,13,2,2,15,15,3,3,23,23,27,27,3,3,11,11,25,25,2,2,25,25,10,10,22,22,14,14,1,1,3,3,25,25,21,21,20,20,12,12,15,15,29,29,12,12,13,13,0,0,12,12,10,10,11,11,13,13,11,11,18,18,25,25,12,12,0,0,3,3,27,27,4,4,23,23,11,11,25,25,9,9,25,25,24,24,28,28,3,3,15,15,10,10,28,28,5,5,10,10,7,7,12,12,28,28,19,19,31,31,7,7,20,20,16,16,23,23,25,25,0,0,30,30,15,15,22,22,0,0,15,15,28,28,30,30,12,12,13,13,8,8,6,6,20,20,22,22,9,9,1,1,19,19,11,11,10,10,6,6,18,18,22,22,17,17,14,14,13,13,23,23,15,15,18,18,0,0,17,17,10,10,2,2,6,6,11,11,2,2,27,27,25,25,4,4,10,10,21,21,1,1,9,9,28,28,12,12,6,6,2,2,10,10,2,2,12,12,24,24,24,24,18,18,22,22,20,20,15,15,6,6,3,3,22,22,14,14,7,7,29,29,26,26,10,10,25,25,2,2,17,17,0,0,6,6,28,28,29,29,0,0,12,12,11,11,5,5,31,31,27,27,30,30,26,26,17,17,27,27,14,14,28,28,4,4,23,23,22,22,19,19,2,2,26,26,2,2,3,3,0,0,0,0,25,25,8,8,20,20,5,5,12,12,16,16,24,24,21,21,4,4,9,9,6,6,0,0,7,7,22,22,8,8,29,29,6,6,0,0,10,10,22,22,30,30,24,24,26,26,31,31,21,21,14,14,14,14,31,31,11,11,10,10,28,28,2,2,12,12,10,10,9,9,0,0,15,15,21,21,3,3,8,8,30,30,25,25,12,12,29,29,8,8,23,23,27,27,25,25,17,17,8,8,0,0,9,9,1,1,31,31,16,16,2,2,27,27,22,22,11,11,16,16,18,18,12,12,18,18,20,20,16,16,21,21,17,17,25,25,10,10,10,10,1,1,10,10,6,6,28,28,28,28,0,0,27,27,4,4,31,31,17,17,24,24,7,7,20,20,12,12,5,5,8,8,26,26,8,8,4,4,19,19,11,11,9,9,2,2,16,16,25,25,10,10,25,25,7,7,15,15,6,6,5,5,14,14,10,10,14,14,14,14,12,12,9,9,15,15,17,17,7,7,30,30,12,12,18,18,12,12,4,4,29,29,27,27,23,23,5,5,6,6,3,3,29,29,20,20,1,1,2,2,8,8,11,11,21,21,25,25,15,15,4,4,12,12,5,5,24,24,2,2,4,4,31,31,7,7,16,16,28,28,19,19,18,18,1,1,19,19,12,12,8,8,25,25,0,0,7,7,3,3,9,9,22,22,30,30,25,25,20,20,9,9,26,26,20,20,11,11,8,8,17,17,23,23,24,24,19,19,7,7,7,7,20,20,12,12,23,23,4,4,7,7,17,17,12,12,27,27,14,14,3,3,26,26,4,4,16,16,10,10,28,28,1,1,31,31,27,27,2,2,17,17,15,15,6,6,0,0,25,25,9,9,21,21,3,3,18,18,3,3,11,11,24,24,29,29,31,31,16,16,10,10,2,2,16,16,12,12,4,4,11,11,30,30,24,24,28,28,16,16,12,12,3,3,11,11,5,5,15,15,24,24,17,17,8,8,28,28,31,31,17,17,7,7,1,1,22,22,27,27,31,31,28,28,24,24,1,1,17,17,17,17,26,26,30,30,17,17,14,14,15,15,17,17,28,28,21,21,2,2,20,20,4,4,12,12,18,18,25,25,1,1,28,28,4,4,10,10,3,3,9,9,7,7,30,30,25,25,23,23,1,1,22,22,20,20,14,14,24,24,24,24,28,28,19,19,6,6,9,9,12,12,16,16,31,31,27,27,16,16,18,18,24,24,18,18,9,9,18,18,28,28,13,13,20,20,0,0,5,5,17,17,24,24,21,21,13,13,0,0,30,30,11,11,0,0,21,21,22,22,29,29,30,30,16,16,18,18,5,5,16,16,17,17,31,31,17,17,7,7,0,0,11,11,25,25,20,20,28,28,29,29,31,31,13,13,19,19,2,2,4,4,1,1,5,5,10,10,19,19,14,14,0,0,5,5,28,28,21,21,9,9,27,27,1,1,8,8,8,8,28,28,12,12,28,28,6,6,21,21,26,26,28,28,0,0,10,10,20,20,2,2,0,0,5,5,17,17,1,1,16,16,13,13,4,4,0,0,20,20,1,1,15,15,3,3,25,25,14,14,20,20,13,13,20,20,25,25,4,4,15,15,12,12,29,29,12,12,18,18,24,24,16,16,14,14,14,14,4,4,10,10,20,20,2,2,1,1,16,16,26,26,8,8,16,16,8,8,17,17,3,3,12,12,17,17,23,23,27,27,28,28,29,29,10,10,24,24,18,18,10,10,26,26,9,9,12,12,16,16,10,10,17,17,8,8,2,2,7,7,30,30,16,16,6,6,25,25,28,28,20,20,7,7,0,0,8,8,9,9,23,23,31,31,5,5,24,24,9,9,11,11,14,14,4,4,4,4,10,10,5,5,15,15,5,5,26,26,28,28,8,8,25,25,17,17,15,15,5,5,8,8,23,23,1,1,20,20,8,8,5,5,29,29,1,1,24,24,10,10,1,1,28,28,28,28,10,10,17,17,9,9,20,20,0,0,10,10,1,1,24,24,2,2,17,17,7,7,18,18,15,15,2,2,30,30,17,17,29,29,25,25,19,19,24,24,2,2,29,29,12,12,27,27,3,3,20,20,26,26,31,31,17,17,14,14,10,10,18,18,30,30,20,20,15,15,13,13,16,16,12,12,16,16,16,16,17,17,1,1,27,27,2,2,23,23,27,27,7,7,18,18,12,12,28,28,17,17,22,22,18,18,12,12,20,20,3,3,3,3,31,31,7,7,21,21,21,21,27,27,20,20,13,13,11,11,19,19,3,3,1,1,6,6,20,20,3,3,23,23,1,1,24,24,7,7,9,9,5,5,25,25,1,1,6,6,21,21,30,30,3,3,13,13,12,12,25,25,10,10,7,7,23,23,24,24,20,20,12,12,22,22,20,20,23,23,4,4,14,14,3,3,8,8,20,20,7,7,5,5,25,25,9,9,11,11,1,1,9,9,17,17,24,24,30,30,16,16,29,29,11,11,10,10,20,20,8,8,5,5,3,3,5,5,5,5,1,1,4,4,4,4,8,8,4,4,4,4,24,24,25,25,7,7,6,6,14,14,18,18,6,6,29,29,8,8,20,20,20,20,11,11,15,15,15,15,2,2,18,18,18,18,3,3,29,29,13,13,27,27,6,6,2,2,22,22,0,0,1,1,13,13,7,7,27,27,1,1,19,19,11,11,17,17,24,24,14,14,16,16,23,23,25,25,12,12,15,15,17,17,30,30,28,28,25,25,7,7,4,4,16,16,30,30,26,26,29,29,14,14,5,5,22,22,10,10,24,24,15,15,14,14,5,5,5,5,26,26,30,30,7,7,9,9,25,25,13,13,26,26,17,17,6,6,24,24,17,17,16,16,12,12,7,7,28,28,12,12,4,4,25,25,19,19,11,11,7,7,31,31,27,27,4,4,17,17,1,1,19,19,13,13,14,14,29,29,7,7,19,19,26,26,8,8,31,31,7,7,1,1,19,19,30,30,24,24,13,13,17,17,11,11,16,16,28,28,22,22,0,0,26,26,28,28,14,14,10,10,30,30,1,1,6,6,29,29,8,8,22,22,18,18,11,11,30,30,17,17,20,20,12,12,19,19,24,24,30,30,3,3,9,9,28,28,0,0,13,13,29,29,19,19,10,10,23,23,8,8,10,10,20,20,27,27,26,26,29,29,18,18,4,4,1,1,14,14,13,13,13,13,29,29,2,2,8,8,24,24,27,27,24,24,1,1,18,18,21,21,20,20,12,12,0,0,6,6,0,0,27,27,31,31,12,12,27,27,11,11,26,26,10,10,7,7,6,6,20,20,29,29,28,28,6,6,9,9,10,10,25,25,4,4,10,10,14,14,14,14,29,29,16,16,16,16,16,16,25,25,9,9,30,30,9,9,20,20,2,2,12,12,6,6,17,17,11,11,12,12,9,9,23,23,7,7,28,28,20,20,14,14,16,16,10,10,17,17,4,4,28,28,13,13,7,7,14,14,3,3,13,13,20,20,25,25,28,28,31,31,6,6,6,6,10,10,31,31,26,26,7,7,10,10,5,5,3,3,21,21,14,14,11,11,28,28,6,6,8,8,11,11,27,27,22,22,20,20,8,8,16,16,21,21,8,8,6,6,17,17,10,10,13,13,20,20,29,29,30,30,21,21,20,20,3,3,8,8,2,2,24,24,21,21,0,0,20,20,21,21,12,12,15,15,23,23,3,3,4,4,29,29,5,5,28,28,31,31,22,22,18,18,19,19,20,20,12,12,2,2,7,7,3,3,7,7,29,29,30,30,4,4,1,1,29,29,19,19,18,18,24,24,15,15,27,27,14,14,31,31,1,1,27,27,22,22,30,30,20,20,28,28,3,3,5,5,7,7,10,10,26,26,0,0,20,20,29,29,2,2,0,0,27,27,16,16,6,6,7,7,10,10,14,14,27,27,19,19,3,3,29,29,12,12,16,16,1,1,25,25,23,23,21,21,8,8,2,2,16,16,8,8,10,10,31,31,16,16,22,22,0,0,6,6,0,0,0,0,19,19,21,21,20,20,22,22,17,17,30,30,31,31,10,10,30,30,18,18,1,1,5,5,20,20,8,8,18,18,2,2,31,31,7,7,6,6,14,14,18,18,16,16,18,18,15,15,7,7,30,30,1,1,12,12,4,4,8,8,7,7,14,14,15,15,14,14,30,30,6,6,9,9,11,11,0,0,9,9,28,28,16,16,6,6,25,25,18,18,7,7,11,11,12,12,3,3,25,25,12,12,31,31,10,10,6,6,22,22,2,2,16,16,11,11,31,31,24,24,24,24,19,19,15,15,11,11,29,29,1,1,18,18,1,1,25,25,2,2,8,8,19,19,11,11,8,8,12,12,0,0,24,24,4,4,6,6,4,4,4,4,16,16,11,11,29,29,10,10,27,27,19,19,20,20,27,27,14,14,16,16,1,1,17,17,6,6,16,16,4,4,17,17,27,27,31,31,6,6,8,8,30,30,13,13,6,6,23,23,21,21,27,27,20,20,28,28,13,13,3,3,31,31,2,2,27,27,20,20,8,8,1,1,17,17,17,17,14,14,12,12,3,3,12,12,15,15,24,24,8,8,8,8,17,17,6,6,14,14,29,29,4,4,2,2,12,12,24,24,19,19,7,7,19,19,13,13,4,4,19,19,24,24,20,20,19,19,14,14,8,8,7,7,0,0,13,13,2,2,3,3,25,25,11,11,8,8,30,30,19,19,18,18,9,9,19,19,24,24,12,12,11,11,31,31,6,6,4,4,30,30,2,2,31,31,21,21,20,20,17,17,2,2,7,7,4,4,11,11,4,4,15,15,16,16,20,20,26,26,23,23,11,11,9,9,25,25,19,19,16,16,0,0,10,10,13,13,19,19,30,30,2,2,4,4,2,2,24,24,0,0,20,20,14,14,22,22,10,10,0,0,8,8,29,29,19,19,12,12,29,29,22,22,18,18,11,11,6,6,13,13,9,9,19,19,9,9,20,20,7,7,9,9,7,7,11,11,9,9,11,11,2,2,11,11,29,29,26,26,18,18,15,15,10,10,8,8,25,25,5,5,1,1,24,24,21,21,23,23,12,12,16,16,26,26,18,18,16,16,7,7,28,28,24,24,2,2,23,23,18,18,2,2,15,15,14,14,10,10,12,12,16,16,10,10,16,16,7,7,21,21,0,0,19,19,12,12,27,27,10,10,19,19,24,24,29,29,1,1,17,17,3,3,5,5,12,12,4,4,26,26,8,8,20,20,19,19,28,28,15,15,25,25,12,12,13,13,24,24,0,0,11,11,18,18,10,10,23,23,30,30,22,22,3,3,9,9,26,26,12,12,22,22,14,14,21,21,16,16,13,13,14,14,3,3,16,16,21,21,8,8,13,13,24,24,21,21,29,29,25,25,26,26,14,14,6,6,15,15,9,9,31,31,6,6,31,31,17,17,19,19,14,14,28,28,2,2,28,28,8,8,11,11,27,27,28,28,13,13,25,25,25,25,26,26,12,12,22,22,30,30,18,18,4,4,24,24,25,25,3,3,24,24,4,4,13,13,26,26,22,22,12,12,6,6,1,1,20,20,2,2,16,16,6,6,16,16,10,10,7,7,29,29,31,31,25,25,19,19,5,5,3,3,23,23,23,23,3,3,9,9,28,28,15,15,20,20,25,25,9,9,24,24,12,12,12,12,28,28,18,18,14,14,6,6,14,14,1,1,10,10,17,17,10,10,27,27,3,3,25,25,24,24,4,4,19,19,14,14,21,21,3,3,29,29,22,22,19,19,27,27,3,3,2,2,24,24,12,12,5,5,3,3,26,26,7,7,14,14,3,3,0,0,1,1,18,18,14,14,20,20,6,6,24,24,25,25,12,12,15,15,6,6,20,20,9,9,29,29,3,3,28,28,22,22,8,8,6,6,17,17,11,11,27,27,8,8,11,11,5,5,23,23,4,4,3,3,10,10,17,17,4,4,3,3,17,17,23,23,1,1,19,19,8,8,9,9,18,18,8,8,6,6,3,3,29,29,17,17,18,18,30,30,17,17,26,26,17,17,27,27,7,7,18,18,22,22,30,30,8,8,3,3,31,31,0,0,5,5,13,13,6,6,23,23,3,3,13,13,14,14,19,19,11,11,1,1,2,2,29,29,11,11,5,5,16,16,13,13,10,10,13,13,25,25,13,13,0,0,12,12,22,22,20,20,24,24,27,27,4,4,12,12,0,0,21,21,11,11,15,15,25,25,0,0,18,18,2,2,0,0,10,10,10,10,3,3,24,24,9,9,4,4,9,9,2,2,11,11,17,17,14,14,5,5,29,29,24,24,30,30,25,25,24,24,18,18,26,26,0,0,23,23,5,5,15,15,30,30,14,14,16,16,5,5,3,3,14,14,18,18,20,20,20,20,28,28,9,9,20,20,15,15,5,5,0,0,4,4,3,3,16,16,18,18,18,18,4,4,19,19,2,2,10,10,12,12,0,0,7,7,1,1,2,2,10,10,26,26,7,7,1,1,8,8,22,22,15,15,5,5,19,19,14,14,7,7,14,14,29,29,0,0,30,30,17,17,9,9,15,15,17,17,13,13,3,3,13,13,26,26,10,10,1,1,4,4,3,3,0,0,14,14,7,7,1,1,10,10,21,21,1,1,5,5,17,17,7,7,1,1,2,2,23,23,25,25,3,3,6,6,27,27,10,10,9,9,10,10,17,17,16,16,27,27,1,1,7,7,0,0,29,29,10,10,23,23,16,16,19,19,7,7,8,8,20,20,23,23,14,14,17,17,21,21,4,4,17,17,5,5,14,14,19,19,11,11,1,1,2,2,8,8,19,19,3,3,28,28,14,14,22,22,19,19,10,10,8,8,0,0,29,29,22,22,25,25,31,31,5,5,6,6,20,20,30,30,8,8,10,10,23,23,22,22,21,21,14,14,28,28,25,25,10,10,21,21,11,11,29,29,15,15,7,7,15,15,24,24,21,21,9,9,30,30,1,1,23,23,11,11,13,13,0,0,29,29,8,8,8,8,30,30,23,23,16,16,7,7,17,17,3,3,25,25,17,17,28,28,22,22,13,13,28,28,8,8,21,21,13,13,20,20,20,20,27,27,1,1,3,3,8,8,0,0,8,8,17,17,29,29,12,12,3,3,31,31,0,0,31,31,15,15,2,2,25,25,19,19,30,30,21,21,31,31,26,26,20,20,29,29,31,31,30,30,20,20,18,18,13,13,23,23,5,5,13,13,22,22,8,8,12,12,1,1,5,5,9,9,0,0,30,30,0,0,26,26,8,8,8,8,28,28,27,27,10,10,20,20,7,7,1,1,16,16,18,18,25,25,17,17,18,18,9,9,31,31,30,30,9,9,3,3,1,1,21,21,0,0,4,4,24,24,4,4,22,22,2,2,25,25,2,2,20,20,26,26,23,23,14,14,1,1,5,5,31,31,29,29,12,12,24,24,18,18,10,10,8,8,8,8,4,4,17,17,17,17,25,25,2,2,5,5,30,30,4,4,15,15,21,21,3,3,16,16,16,16,0,0,4,4,28,28,30,30,1,1,18,18,0,0,2,2,10,10,11,11,5,5,3,3,26,26,17,17,1,1,17,17,26,26,26,26,14,14,4,4,29,29,11,11,28,28,12,12,4,4,5,5,5,5,18,18,24,24,0,0,18,18,20,20,0,0,12,12,31,31,26,26,9,9,6,6,22,22,30,30,5,5,4,4,29,29,0,0,1,1,13,13,1,1,25,25,4,4,17,17,6,6,18,18,15,15,1,1,10,10,1,1,24,24,0,0,7,7,7,7,3,3,2,2,11,11,23,23,8,8,30,30,11,11,1,1,0,0,5,5,8,8,5,5,19,19,16,16,24,24,27,27,25,25,8,8,0,0,24,24,23,23,23,23,4,4,30,30,1,1,25,25,3,3,8,8,21,21,15,15,21,21,16,16,14,14,31,31,2,2,10,10,3,3,4,4,4,4,11,11,1,1,15,15,10,10,0,0,2,2,25,25,2,2,30,30,7,7,21,21,8,8,11,11,7,7,25,25,13,13,13,13,6,6,16,16,9,9,7,7,10,10,31,31,27,27,19,19,21,21,26,26,12,12,6,6,3,3,12,12,9,9,28,28,27,27,11,11,2,2,14,14,5,5,23,23,7,7,6,6,25,25,22,22,27,27,18,18,16,16,13,13,17,17,2,2,21,21,31,31,1,1,13,13,9,9,12,12,0,0,27,27,0,0,22,22,3,3,15,15,2,2,28,28,28,28,30,30,8,8,6,6,17,17,10,10,12,12,30,30,12,12,15,15,26,26,31,31,18,18,16,16,3,3,8,8,17,17,15,15,9,9,14,14,15,15,12,12,11,11,20,20,9,9,26,26,3,3,22,22,4,4,29,29,9,9,6,6,0,0,30,30,17,17,12,12,10,10,0,0,22,22,14,14,25,25,6,6,3,3,31,31,23,23,26,26,19,19,4,4,7,7,18,18,16,16,17,17,26,26,6,6,3,3,29,29,26,26,1,1,24,24,22,22,29,29,10,10,29,29,0,0,29,29,4,4,11,11,25,25,16,16,6,6,30,30,1,1,19,19,4,4,20,20,28,28,10,10,20,20,2,2,17,17,16,16,7,7,17,17,2,2,28,28,7,7,12,12,6,6,1,1,19,19,2,2,17,17,20,20,12,12,26,26,26,26,1,1,21,21,16,16,5,5,16,16,25,25,2,2,25,25,27,27,18,18,4,4,23,23,18,18,19,19,6,6,26,26,21,21,16,16,18,18,7,7,16,16,30,30,5,5,31,31,22,22,29,29,11,11,9,9,8,8,24,24,18,18,0,0,9,9,8,8,9,9,1,1,17,17,0,0,18,18,18,18,0,0,27,27,19,19,24,24,5,5,1,1,16,16,22,22,2,2,15,15,8,8,24,24,19,19,27,27,6,6,10,10,24,24,19,19,4,4,10,10,17,17,7,7,24,24,24,24,13,13,0,0,20,20,8,8,5,5,2,2,17,17,13,13,5,5,14,14,24,24,0,0,21,21,19,19,3,3,18,18,5,5,19,19,9,9,18,18,5,5,28,28,22,22,4,4,0,0,31,31,18,18,16,16,18,18,4,4,3,3,25,25,0,0,7,7,30,30,7,7,18,18,2,2,4,4,0,0,27,27,22,22,10,10,22,22,26,26,20,20,12,12,3,3,4,4,17,17,20,20,0,0,2,2,20,20,15,15,0,0,4,4,24,24,31,31,24,24,10,10,5,5,19,19,12,12,9,9,21,21,2,2,7,7,22,22,15,15,27,27,24,24,8,8,3,3,23,23,23,23,29,29,9,9,14,14,29,29,11,11,24,24,12,12,22,22,5,5,12,12,27,27,29,29,25,25,5,5,4,4,10,10,15,15,11,11,14,14,26,26,11,11,27,27,25,25,7,7,18,18,8,8,0,0,14,14,30,30,11,11,5,5,3,3,17,17,16,16,13,13,6,6,7,7,22,22,13,13,26,26,30,30,0,0,23,23,3,3,1,1,11,11,21,21,8,8,20,20,24,24,30,30,7,7,24,24,15,15,19,19,29,29,14,14,8,8,4,4,23,23,26,26,23,23,14,14,13,13,18,18,31,31,20,20,8,8,10,10,23,23,22,22,13,13,2,2,7,7,10,10,10,10,31,31,10,10,4,4,26,26,23,23,17,17,8,8,28,28,15,15,4,4,19,19,10,10,20,20,18,18,13,13,3,3,20,20,16,16,8,8,2,2,19,19,23,23,2,2,29,29,12,12,14,14,9,9,15,15,8,8,21,21,0,0,18,18,31,31,0,0,26,26,2,2,2,2,16,16,27,27,30,30,0,0,17,17,29,29,4,4,22,22,16,16,19,19,12,12,18,18,29,29,17,17,16,16,28,28,3,3,5,5,21,21,26,26,2,2,20,20,0,0,6,6,30,30,4,4,13,13,28,28,22,22,21,21,0,0,13,13,15,15,21,21,15,15,0,0,18,18,6,6,23,23,6,6,0,0,4,4,8,8,8,8,1,1,16,16,31,31,9,9,0,0,29,29,27,27,10,10,15,15,3,3,10,10,15,15,18,18,0,0,3,3,3,3,4,4,13,13,2,2,13,13,0,0,5,5,16,16,21,21,5,5,1,1,26,26,15,15,25,25,16,16,23,23,25,25,20,20,16,16,25,25,0,0,26,26,27,27,11,11,14,14,3,3,31,31,28,28,3,3,17,17,29,29,24,24,26,26,11,11,14,14,16,16,10,10,24,24,20,20,6,6,9,9,12,12,24,24,16,16,3,3,7,7,11,11,23,23,1,1,2,2,29,29,14,14,21,21,7,7,16,16,26,26,23,23,0,0,16,16,13,13,21,21,14,14,2,2,18,18,31,31,3,3,3,3,31,31,15,15,1,1,7,7,11,11,18,18,11,11,15,15,23,23,25,25,6,6,3,3,15,15,15,15,10,10,14,14,26,26,1,1,16,16,8,8,26,26,29,29,2,2,3,3,8,8,4,4,17,17,3,3,17,17,28,28,29,29,3,3,18,18,8,8,24,24,19,19,14,14,2,2,20,20,30,30,25,25,30,30,31,31,30,30,5,5,12,12,5,5,1,1,25,25,5,5,24,24,14,14,26,26,4,4,11,11,13,13,22,22,3,3,8,8,20,20,11,11,28,28,28,28,19,19,28,28,24,24,21,21,18,18,2,2,15,15,23,23,20,20,10,10,23,23,13,13,3,3,3,3,10,10,10,10,1,1,24,24,3,3,24,24,4,4,14,14,1,1,31,31,25,25,9,9,4,4,19,19,23,23,23,23,13,13,17,17,21,21,21,21,31,31,23,23,3,3,24,24,29,29,29,29,14,14,27,27,14,14,7,7,1,1,9,9,4,4,13,13,25,25,1,1,11,11,17,17,20,20,4,4,16,16,2,2,22,22,26,26,26,26,0,0,31,31,15,15,28,28,9,9,29,29,5,5,29,29,29,29,4,4,31,31,16,16,16,16,28,28,21,21,2,2,28,28,16,16,31,31,22,22,22,22,11,11,25,25,1,1,23,23,29,29,14,14,25,25,24,24,15,15,20,20,26,26,6,6,12,12,23,23,9,9,1,1,11,11,3,3,18,18,17,17,24,24,13,13,28,28,4,4,13,13,12,12,10,10,15,15,30,30,27,27,20,20,7,7,29,29,9,9,4,4,12,12,20,20,11,11,8,8,31,31,6,6,3,3,25,25,19,19,1,1,18,18,1,1,8,8,6,6,1,1,9,9,2,2,10,10,15,15,16,16,10,10,6,6,3,3,21,21,1,1,1,1,16,16,18,18,4,4,11,11,6,6,1,1,20,20,25,25,24,24,22,22,14,14,2,2,24,24,22,22,3,3,14,14,28,28,31,31,10,10,17,17,9,9,28,28,21,21,14,14,27,27,6,6,25,25,8,8,5,5,9,9,30,30,9,9,28,28,25,25,3,3,4,4,4,4,20,20,9,9,2,2,16,16,16,16,28,28,10,10,21,21,14,14,31,31,31,31,4,4,11,11,10,10,23,23,7,7,1,1,2,2,11,11,10,10,21,21,0,0,28,28,17,17,3,3,14,14,15,15,3,3,21,21,20,20,9,9,11,11,23,23,11,11,21,21,8,8,5,5,15,15,16,16,9,9,29,29,10,10,10,10,4,4,9,9,10,10,13,13,13,13,21,21,19,19,23,23,7,7,10,10,6,6,28,28,5,5,2,2,27,27,12,12,23,23,15,15,31,31,3,3,12,12,2,2,15,15,6,6,27,27,29,29,11,11,21,21,8,8,7,7,23,23,2,2,11,11,4,4,2,2,10,10,19,19,10,10,28,28,27,27,10,10,11,11,4,4,17,17,18,18,1,1,31,31,11,11,10,10,15,15,17,17,25,25,30,30,13,13,16,16,17,17,8,8,24,24,15,15,27,27,15,15,19,19,20,20,19,19,29,29,17,17,23,23,5,5,15,15,22,22,8,8,16,16,11,11,1,1,18,18,3,3,17,17,7,7,0,0,22,22,10,10,16,16,3,3,28,28,12,12,18,18,19,19,15,15,17,17,26,26,13,13,14,14,20,20,7,7,4,4,19,19,30,30,29,29,16,16,0,0,23,23,15,15,20,20,23,23,6,6,28,28,31,31,27,27,30,30,11,11,6,6,5,5,30,30,16,16,26,26,9,9,29,29,20,20,17,17,31,31,5,5,29,29,29,29,10,10,16,16,2,2,31,31,3,3,7,7,17,17,4,4,18,18,6,6,8,8,19,19,28,28,3,3,18,18,18,18,12,12,26,26,30,30,22,22,26,26,8,8,27,27,13,13,0,0,13,13,7,7,21,21,17,17,7,7,17,17,8,8,31,31,4,4,11,11,25,25,22,22,5,5,26,26,10,10,1,1,1,1,3,3,4,4,2,2,31,31,0,0,17,17,30,30,19,19,13,13,31,31,26,26,2,2,4,4,22,22,10,10,27,27,29,29,16,16,23,23,14,14,25,25,29,29,16,16,5,5,20,20,21,21,9,9,0,0,27,27,22,22,8,8,12,12,18,18,20,20,19,19,29,29,9,9,19,19,17,17,11,11,6,6,6,6,26,26,0,0,21,21,22,22,24,24,19,19,11,11,13,13,2,2,28,28,18,18,25,25,6,6,13,13,8,8,18,18,8,8,7,7,11,11,15,15,25,25,5,5,0,0,1,1,16,16,1,1,7,7,17,17,9,9,0,0,29,29,1,1,28,28,17,17,6,6,5,5,19,19,22,22,24,24,15,15,19,19,0,0,21,21,20,20,20,20,8,8,30,30,0,0,13,13,13,13,25,25,18,18,28,28,0,0,12,12,16,16,20,20,4,4,19,19,21,21,0,0,16,16,3,3,19,19,6,6,20,20,16,16,11,11,8,8,9,9,26,26,17,17,7,7,3,3,8,8,19,19,20,20,8,8,5,5,20,20,16,16,2,2,8,8,27,27,10,10,2,2,9,9,26,26,2,2,26,26,27,27,0,0,5,5,27,27,12,12,24,24,20,20,2,2,21,21,1,1,4,4,28,28,4,4,20,20,0,0,27,27,23,23,2,2,28,28,10,10,6,6,20,20,31,31,9,9,4,4,24,24,13,13,11,11,5,5,17,17,0,0,16,16,5,5,20,20,0,0,9,9,15,15,3,3,12,12,25,25,21,21,1,1,18,18,23,23,29,29,8,8,15,15,23,23,2,2,11,11,18,18,28,28,8,8,15,15,5,5,30,30,0,0,20,20,6,6,9,9,11,11,5,5,25,25,17,17,29,29,2,2,0,0,3,3,21,21,7,7,19,19,17,17,29,29,2,2,0,0,25,25,4,4,7,7,17,17,31,31,30,30,13,13,9,9,4,4,22,22,31,31,6,6,4,4,20,20,23,23,20,20,4,4,23,23,0,0,30,30,28,28,8,8,18,18,3,3,18,18,16,16,14,14,24,24,21,21,27,27,18,18,3,3,18,18,2,2,16,16,9,9,10,10,2,2,27,27,17,17,11,11,0,0,4,4,7,7,16,16,2,2,4,4,28,28,24,24,27,27,25,25,1,1,11,11,2,2,18,18,12,12,25,25,28,28,17,17,3,3,17,17,17,17,9,9,3,3,30,30,18,18,12,12,16,16,1,1,6,6,0,0,16,16,22,22,12,12,12,12,22,22,17,17,8,8,13,13,29,29,6,6,2,2,27,27,14,14,0,0,12,12,6,6,24,24,25,25,25,25,21,21,29,29,18,18,29,29,21,21,3,3,31,31,16,16,4,4,11,11,19,19,29,29,31,31,8,8,11,11,6,6,17,17,20,20,18,18,13,13,24,24,2,2,8,8,31,31,21,21,3,3,21,21,20,20,8,8,29,29,13,13,29,29,15,15,1,1,22,22,1,1,16,16,1,1,10,10,27,27,12,12,24,24,9,9,30,30,2,2,21,21,11,11,12,12,17,17,0,0,25,25,15,15,11,11,6,6,26,26,24,24,18,18,12,12,30,30,14,14,29,29,9,9,24,24,10,10,12,12,2,2,16,16,10,10,25,25,11,11,7,7,25,25,19,19,14,14,28,28,20,20,9,9,17,17,5,5,16,16,5,5,14,14,16,16,28,28,0,0,3,3,0,0,0,0,20,20,22,22,23,23,10,10,10,10,2,2,26,26,15,15,5,5,24,24,6,6,15,15,11,11,8,8,13,13,11,11,21,21,30,30,7,7,18,18,27,27,26,26,10,10,24,24,14,14,16,16,16,16,12,12,24,24,22,22,10,10,20,20,0,0,19,19,25,25,27,27,16,16,12,12,23,23,27,27,9,9,0,0,6,6,26,26,10,10,23,23,22,22,4,4,13,13,4,4,12,12,25,25,8,8,28,28,8,8,23,23,31,31,6,6,21,21,12,12,1,1,0,0,11,11,27,27,22,22,21,21,5,5,0,0,21,21,24,24,14,14,18,18,4,4,18,18,15,15,10,10,30,30,23,23,25,25,21,21,7,7,0,0,19,19,2,2,4,4,4,4,20,20,23,23,9,9,23,23,4,4,20,20,18,18,20,20,26,26,20,20,31,31,3,3,30,30,29,29,23,23,5,5,8,8,5,5,20,20,15,15,2,2,22,22,25,25,9,9,5,5,25,25,20,20,10,10,22,22,29,29,10,10,10,10,8,8,6,6,10,10,24,24,14,14,26,26,22,22,21,21,22,22,3,3,22,22,23,23,11,11,20,20,3,3,20,20,27,27,30,30,1,1,31,31,23,23,12,12,25,25,24,24,31,31,22,22,11,11,28,28,21,21,24,24,2,2,4,4,21,21,13,13,30,30,27,27,2,2,1,1,5,5,0,0,27,27,0,0,31,31,29,29,22,22,19,19,8,8,9,9,19,19,5,5,26,26,26,26,10,10,6,6,16,16,25,25,12,12,19,19,15,15,8,8,1,1,30,30,19,19,10,10,10,10,18,18,5,5,9,9,1,1,27,27,5,5,14,14,26,26,24,24,12,12,0,0,24,24,15,15,5,5,24,24,21,21,13,13,22,22,11,11,17,17,27,27,23,23,11,11,16,16,26,26,4,4,9,9,2,2,15,15,27,27,23,23,28,28,14,14,24,24,17,17,29,29,2,2,7,7,13,13,6,6,31,31,22,22,5,5,31,31,21,21,20,20,26,26,13,13,12,12,30,30,14,14,18,18,19,19,17,17,13,13,25,25,2,2,20,20,6,6,30,30,26,26,27,27,6,6,1,1,5,5,1,1,26,26,16,16,1,1,31,31,28,28,10,10,23,23,3,3,6,6,2,2,14,14,0,0,28,28,23,23,21,21,11,11,26,26,5,5,29,29,29,29,1,1,27,27,7,7,10,10,15,15,30,30,3,3,8,8,21,21,15,15,19,19,31,31,24,24,28,28,10,10,10,10,19,19,13,13,18,18,18,18,25,25,24,24,16,16,7,7,31,31,18,18,14,14,31,31,14,14,18,18,21,21,9,9,31,31,11,11,19,19,24,24,20,20,21,21,28,28,17,17,24,24,29,29,23,23,20,20,22,22,0,0,7,7,5,5,14,14,29,29,29,29,15,15,14,14,25,25,27,27,13,13,23,23,9,9,19,19,10,10,16,16,23,23,0,0,22,22,3,3,28,28,13,13,10,10,24,24,6,6,24,24,0,0,9,9,18,18,22,22,24,24,27,27,28,28,16,16,2,2,4,4,6,6,19,19,12,12,8,8,6,6,10,10,17,17,31,31,9,9,25,25,1,1,20,20,11,11,21,21,28,28,9,9,29,29,13,13,12,12,0,0,9,9,4,4,14,14,22,22,5,5,6,6,13,13,25,25,14,14,24,24,24,24,20,20,9,9,17,17,3,3,16,16,3,3,6,6,9,9,30,30,18,18,27,27,23,23,26,26,16,16,29,29,22,22,3,3,2,2,20,20,6,6,29,29,17,17,15,15,22,22,17,17,30,30,24,24,8,8,4,4,26,26,30,30,5,5,9,9,15,15,22,22,6,6,11,11,9,9,29,29,27,27,22,22,30,30,4,4,6,6,19,19,4,4,30,30,16,16,28,28,29,29,16,16,3,3,18,18,14,14,21,21,12,12,25,25,26,26,11,11,17,17,6,6,10,10,3,3,12,12,3,3,14,14,18,18,8,8,21,21,29,29,20,20,5,5,21,21,13,13,5,5,2,2,12,12,0,0,7,7,18,18,16,16,6,6,29,29,5,5,10,10,9,9,15,15,20,20,29,29,13,13,0,0,6,6,22,22,24,24,25,25,23,23,5,5,9,9,19,19,18,18,17,17,22,22,2,2,2,2,0,0,27,27,11,11,18,18,25,25,17,17,22,22,24,24,21,21,14,14,1,1,19,19,25,25,30,30,25,25,11,11,9,9,21,21,6,6,27,27,4,4,29,29,15,15,6,6,21,21,14,14,14,14,25,25,1,1,19,19,11,11,6,6,20,20,8,8,2,2,3,3,22,22,21,21,3,3,7,7,10,10,29,29,13,13,30,30,1,1,16,16,5,5,13,13,29,29,24,24,0,0,17,17,17,17,21,21,31,31,11,11,9,9,24,24,19,19,22,22,5,5,4,4,24,24,15,15,9,9,6,6,4,4,20,20,15,15,22,22,22,22,20,20,19,19,9,9,29,29,25,25,15,15,14,14,8,8,29,29,14,14,29,29,22,22,8,8,24,24,9,9,31,31,1,1,10,10,28,28,10,10,17,17,4,4,23,23,1,1,19,19,0,0,6,6,16,16,19,19,31,31,1,1,27,27,20,20,17,17,12,12,18,18,10,10,6,6,21,21,20,20,17,17,19,19,18,18,3,3,23,23,29,29,10,10,3,3,1,1,0,0,12,12,3,3,31,31,0,0,8,8,17,17,8,8,0,0,21,21,18,18,27,27,25,25,7,7,8,8,10,10,10,10,1,1,25,25,19,19,20,20,12,12,28,28,3,3,6,6,3,3,20,20,2,2,19,19,2,2,28,28,29,29,23,23,14,14,16,16,3,3,24,24,14,14,9,9,5,5,4,4,21,21,25,25,7,7,31,31,25,25,0,0,4,4,25,25,29,29,2,2,18,18,25,25,18,18,18,18,15,15,13,13,2,2,1,1,9,9,27,27,3,3,5,5,3,3,22,22,27,27,1,1,25,25,24,24,22,22,23,23,0,0,27,27,27,27,15,15,18,18,8,8,9,9,18,18,22,22,12,12,20,20,21,21,9,9,30,30,11,11,5,5,26,26,10,10,4,4,4,4,17,17,28,28,4,4,23,23,13,13,16,16,1,1,15,15,13,13,23,23,29,29,30,30,10,10,26,26,9,9,21,21,31,31,6,6,4,4,19,19,1,1,26,26,18,18,17,17,14,14,26,26,4,4,10,10,2,2,28,28,18,18,13,13,2,2,29,29,12,12,1,1,16,16,11,11,23,23,17,17,4,4,9,9,7,7,3,3,26,26,22,22,27,27,8,8,27,27,14,14,30,30,4,4,13,13,24,24,20,20,7,7,9,9,1,1,5,5,1,1,18,18,10,10,31,31,4,4,13,13,30,30,17,17,9,9,27,27,13,13,16,16,23,23,15,15,17,17,3,3,23,23,8,8,4,4,23,23,24,24,12,12,10,10,13,13,25,25,17,17,5,5,0,0,14,14,14,14,3,3,30,30,1,1,14,14,9,9,28,28,2,2,22,22,23,23,20,20,26,26,30,30,7,7,24,24,8,8,3,3,29,29,20,20,19,19,15,15,23,23,25,25,5,5,7,7,17,17,4,4,13,13,11,11,6,6,30,30,27,27,11,11,5,5,12,12,14,14,20,20,24,24,3,3,27,27,16,16,8,8,25,25,20,20,1,1,2,2,14,14,16,16,3,3,15,15,31,31,17,17,27,27,10,10,20,20,7,7,17,17,3,3,28,28,5,5,22,22,13,13,28,28,17,17,4,4,25,25,21,21,4,4,5,5,24,24,31,31,10,10,0,0,19,19,19,19,12,12,29,29,30,30,9,9,29,29,23,23,14,14,16,16,23,23,0,0,22,22,26,26,26,26,30,30,25,25,9,9,31,31,20,20,20,20,16,16,24,24,18,18,3,3,22,22,22,22,0,0,10,10,24,24,12,12,3,3,7,7,29,29,3,3,24,24,15,15,11,11,11,11,15,15,23,23,18,18,5,5,25,25,16,16,17,17,13,13,20,20,7,7,0,0,5,5,30,30,23,23,12,12,30,30,28,28,28,28,18,18,22,22,20,20,22,22,1,1,9,9,25,25,20,20,12,12,0,0,6,6,30,30,9,9,3,3,16,16,0,0,20,20,14,14,6,6,12,12,24,24,6,6,4,4,2,2,31,31,14,14,29,29,24,24,28,28,26,26,21,21,26,26,12,12,24,24,5,5,17,17,25,25,18,18,28,28,17,17,11,11,2,2,25,25,9,9,0,0,11,11,7,7,14,14,25,25,24,24,12,12,16,16,21,21,0,0,7,7,30,30,20,20,20,20,18,18,1,1,24,24,26,26,18,18,8,8,2,2,21,21,19,19,2,2,14,14,20,20,2,2,2,2,19,19,11,11,11,11,28,28,12,12,6,6,12,12,23,23,28,28,31,31,13,13,2,2,26,26,24,24,11,11,2,2,9,9,14,14,20,20,8,8,8,8,9,9,17,17,22,22,2,2,16,16,14,14,30,30,20,20,22,22,4,4,14,14,10,10,1,1,24,24,19,19,16,16,8,8,11,11,11,11,20,20,4,4,30,30,6,6,19,19,28,28,22,22,24,24,7,7,26,26,4,4,6,6,12,12,8,8,2,2,2,2,6,6,25,25,18,18,17,17,9,9,20,20,4,4,7,7,19,19,22,22,18,18,3,3,13,13,2,2,23,23,22,22,26,26,24,24,2,2,24,24,10,10,21,21,4,4,24,24,18,18,19,19,1,1,29,29,24,24,13,13,10,10,21,21,25,25,19,19,19,19,4,4,6,6,19,19,16,16,17,17,16,16,23,23,0,0,1,1,13,13,29,29,23,23,22,22,6,6,2,2,27,27,24,24,12,12,23,23,21,21,4,4,28,28,20,20,22,22,4,4,22,22,12,12,31,31,3,3,10,10,2,2,12,12,7,7,28,28,27,27,25,25,4,4,24,24,3,3,1,1,23,23,2,2,17,17,1,1,23,23,31,31,20,20,14,14,27,27,9,9,22,22,2,2,0,0,7,7,5,5,15,15,19,19,1,1,6,6,30,30,27,27,17,17,8,8,8,8,27,27,9,9,14,14,16,16,26,26,1,1,9,9,18,18,6,6,17,17,27,27,5,5,17,17,12,12,13,13,26,26,24,24,22,22,20,20,30,30,20,20,12,12,25,25,22,22,27,27,3,3,15,15,14,14,24,24,23,23,28,28,15,15,20,20,20,20,1,1,7,7,5,5,0,0,14,14,9,9,17,17,23,23,29,29,4,4,7,7,3,3,27,27,28,28,13,13,1,1,14,14,28,28,28,28,27,27,21,21,22,22,27,27,2,2,2,2,1,1,31,31,29,29,6,6,16,16,13,13,22,22,16,16,20,20,15,15,4,4,5,5,6,6,26,26,2,2,15,15,10,10,18,18,16,16,3,3,3,3,0,0,28,28,0,0,8,8,22,22,16,16,5,5,7,7,7,7,26,26,6,6,27,27,29,29,9,9,15,15,1,1,8,8,6,6,21,21,28,28,6,6,20,20,14,14,10,10,0,0,28,28,0,0,19,19,10,10,25,25,26,26,11,11,24,24,9,9,22,22,0,0,19,19,3,3,7,7,22,22,17,17,28,28,21,21,31,31,9,9,0,0,4,4,10,10,9,9,0,0,27,27,28,28,3,3,21,21,15,15,5,5,0,0,9,9,0,0,3,3,30,30,29,29,17,17,28,28,13,13,2,2,23,23,11,11,8,8,17,17,12,12,21,21,30,30,3,3,11,11,3,3,1,1,20,20,26,26,21,21,10,10,5,5,28,28,30,30,0,0,12,12,15,15,4,4,26,26,18,18,16,16,12,12,5,5,18,18,13,13,19,19,20,20,30,30,16,16,13,13,18,18,28,28,11,11,0,0,1,1,20,20,16,16,3,3,3,3,24,24,0,0,22,22,4,4,20,20,27,27,25,25,14,14,4,4,25,25,0,0,15,15,22,22,23,23,14,14,4,4,21,21,16,16,8,8,23,23,7,7,17,17,27,27,13,13,25,25,13,13,9,9,5,5,16,16,12,12,7,7,8,8,26,26,5,5,20,20,2,2,9,9,10,10,8,8,20,20,3,3,10,10,4,4,24,24,11,11,1,1,24,24,0,0,25,25,23,23,1,1,2,2,2,2,23,23,10,10,1,1,0,0,1,1,25,25,5,5,4,4,17,17,14,14,25,25,26,26,28,28,5,5,11,11,11,11,14,14,26,26,26,26,13,13,4,4,13,13,16,16,13,13,8,8,1,1,16,16,28,28,19,19,6,6,8,8,28,28,8,8,9,9,0,0,9,9,5,5,18,18,18,18,29,29,23,23,28,28,2,2,3,3,5,5,13,13,12,12,4,4,25,25,10,10,9,9,4,4,6,6,28,28,28,28,6,6,7,7,11,11,11,11,21,21,6,6,30,30,15,15,1,1,8,8,23,23,22,22,24,24,20,20,25,25,18,18,16,16,28,28,10,10,6,6,29,29,22,22,25,25,8,8,7,7,24,24,5,5,7,7,26,26,12,12,2,2,0,0,7,7,11,11,8,8,8,8,17,17,31,31,16,16,15,15,13,13,31,31,9,9,10,10,14,14,5,5,26,26,23,23,19,19,30,30,3,3,7,7,5,5,22,22,17,17,15,15,2,2,12,12,1,1,21,21,16,16,19,19,26,26,16,16,14,14,2,2,12,12,19,19,2,2,30,30,3,3,12,12,12,12,12,12,10,10,9,9,10,10,10,10,11,11,30,30,31,31,20,20,10,10,29,29,24,24,30,30,7,7,2,2,4,4,7,7,10,10,27,27,23,23,4,4,10,10,12,12,23,23,4,4,5,5,11,11,26,26,0,0,8,8,20,20,28,28,28,28,14,14,0,0,21,21,0,0,22,22,16,16,5,5,9,9,24,24,20,20,2,2,6,6,31,31,14,14,27,27,9,9,12,12,9,9,2,2,3,3,14,14,16,16,13,13,10,10,19,19,31,31,19,19,4,4,19,19,6,6,17,17,15,15,30,30,3,3,24,24,4,4,31,31,22,22,10,10,20,20,13,13,20,20,16,16,3,3,8,8,11,11,24,24,12,12,2,2,9,9,24,24,1,1,6,6,25,25,22,22,16,16,30,30,6,6,23,23,3,3,30,30,9,9,24,24,25,25,0,0,2,2,18,18,20,20,7,7,1,1,23,23,21,21,18,18,19,19,6,6,10,10,15,15,2,2,23,23,4,4,20,20,13,13,25,25,1,1,14,14,30,30,12,12,4,4,22,22,19,19,14,14,25,25,11,11,29,29,3,3,18,18,27,27,23,23,21,21,10,10,7,7,22,22,30,30,28,28,8,8,31,31,9,9,10,10,26,26,25,25,23,23,2,2,21,21,16,16,4,4,26,26,17,17,14,14,0,0,26,26,26,26,27,27,19,19,11,11,25,25,11,11,8,8,25,25,24,24,4,4,10,10,5,5,12,12,26,26,9,9,29,29,28,28,14,14,14,14,2,2,7,7,23,23,11,11,2,2,1,1,22,22,11,11,20,20,4,4,23,23,31,31,8,8,19,19,19,19,28,28,4,4,10,10,16,16,18,18,31,31,19,19,24,24,3,3,20,20,1,1,9,9,26,26,8,8,9,9,28,28,24,24,7,7,10,10,15,15,0,0,0,0,4,4,10,10,23,23,3,3,12,12,20,20,18,18,26,26,17,17,4,4,10,10,31,31,2,2,16,16,5,5,3,3,14,14,0,0,1,1,9,9,9,9,25,25,17,17,9,9,20,20,27,27,2,2,16,16,12,12,30,30,4,4,2,2,3,3,2,2,16,16,29,29,1,1,28,28,11,11,2,2,19,19,6,6,27,27,1,1,13,13,6,6,9,9,14,14,27,27,1,1,28,28,9,9,1,1,22,22,5,5,18,18,8,8,19,19,4,4,28,28,10,10,10,10,25,25,20,20,26,26,6,6,23,23,26,26,18,18,1,1,19,19,28,28,18,18,4,4,30,30,6,6,7,7,15,15,19,19,13,13,1,1,7,7,19,19,24,24,12,12,20,20,19,19,5,5,21,21,9,9,12,12,29,29,14,14,2,2,29,29,22,22,7,7,11,11,8,8,22,22,1,1,26,26,17,17,27,27,9,9,9,9,31,31,0,0,27,27,11,11,26,26,4,4,12,12,1,1,24,24,17,17,16,16,17,17,6,6,25,25,5,5,31,31,18,18,17,17,15,15,24,24,4,4,2,2,8,8,25,25,27,27,3,3,27,27,5,5,19,19,2,2,18,18,14,14,25,25,2,2,30,30,18,18,16,16,14,14,6,6,7,7,5,5,29,29,31,31,19,19,22,22,11,11,3,3,23,23,22,22,11,11,16,16,8,8,17,17,18,18,19,19,28,28,21,21,17,17,31,31,29,29,27,27,6,6,21,21,13,13,11,11,11,11,4,4,8,8,6,6,5,5,7,7,6,6,0,0,1,1,23,23,3,3,28,28,15,15,3,3,25,25,2,2,16,16,1,1,29,29,16,16,23,23,28,28,10,10,2,2,6,6,5,5,30,30,31,31,28,28,6,6,8,8,10,10,27,27,22,22,29,29,5,5,4,4,16,16,6,6,14,14,12,12,17,17,12,12,9,9,6,6,31,31,27,27,7,7,12,12,16,16,0,0,9,9,30,30,13,13,9,9,11,11,0,0,5,5,28,28,11,11,21,21,24,24,16,16,6,6,11,11,3,3,14,14,30,30,27,27,10,10,25,25,13,13,14,14,3,3,4,4,9,9,17,17,20,20,13,13,15,15,26,26,16,16,18,18,1,1,5,5,11,11,29,29,28,28,27,27,19,19,7,7,6,6,26,26,14,14,21,21,2,2,14,14,15,15,18,18,18,18,21,21,10,10,10,10,13,13,30,30,24,24,17,17,28,28,23,23,4,4,20,20,29,29,13,13,29,29,4,4,9,9,3,3,22,22,4,4,16,16,26,26,6,6,17,17,25,25,22,22,5,5,4,4,14,14,1,1,16,16,20,20,0,0,31,31,18,18,12,12,9,9,10,10,31,31,19,19,29,29,28,28,29,29,12,12,14,14,4,4,31,31,26,26,28,28,1,1,10,10,1,1,28,28,20,20,22,22,21,21,24,24,24,24,10,10,14,14,0,0,27,27,11,11,22,22,21,21,3,3,20,20,12,12,16,16,10,10,7,7,8,8,16,16,2,2,22,22,0,0,18,18,14,14,5,5,16,16,10,10,8,8,4,4,20,20,8,8,25,25,18,18,22,22,22,22,17,17,17,17,5,5,17,17,9,9,4,4,15,15,10,10,15,15,0,0,6,6,14,14,26,26,17,17,29,29,13,13,7,7,5,5,15,15,15,15,0,0,4,4,15,15,24,24,15,15,20,20,4,4,27,27,15,15,31,31,6,6,2,2,5,5,2,2,4,4,3,3,0,0,9,9,29,29,12,12,27,27,14,14,21,21,3,3,25,25,9,9,21,21,29,29,16,16,10,10,12,12,12,12,5,5,31,31,22,22,0,0,1,1,6,6,29,29,19,19,2,2,9,9,1,1,17,17,2,2,25,25,11,11,28,28,15,15,21,21,24,24,19,19,29,29,8,8,4,4,26,26,16,16,17,17,21,21,13,13,7,7,29,29,10,10,12,12,7,7,16,16,7,7,1,1,11,11,12,12,12,12,30,30,8,8,1,1,30,30,8,8,13,13,27,27,19,19,18,18,22,22,22,22,14,14,8,8,18,18,9,9,22,22,19,19,1,1,20,20,10,10,27,27,7,7,23,23,21,21,19,19,9,9,18,18,5,5,9,9,20,20,11,11,31,31,0,0,4,4,22,22,26,26,15,15,1,1,1,1,10,10,26,26,21,21,16,16,8,8,13,13,0,0,20,20,3,3,16,16,12,12,5,5,13,13,3,3,2,2,2,2,23,23,11,11,18,18,20,20,17,17,6,6,27,27,13,13,4,4,17,17,11,11,8,8,25,25,1,1,19,19,11,11,7,7,22,22,21,21,31,31,21,21,29,29,25,25,22,22,16,16,3,3,26,26,21,21,8,8,4,4,9,9,31,31,13,13,22,22,25,25,26,26,12,12,5,5,9,9,16,16,4,4,15,15,11,11,22,22,5,5,13,13,20,20,22,22,21,21,18,18,1,1,31,31,13,13,29,29,22,22,14,14,1,1,26,26,1,1,20,20,31,31,0,0,0,0,15,15,1,1,2,2,0,0,28,28,17,17,2,2,20,20,19,19,11,11,15,15,2,2,12,12,19,19,5,5,21,21,25,25,15,15,3,3,10,10,2,2,15,15,8,8,17,17,29,29,25,25,25,25,9,9,1,1,4,4,12,12,6,6,20,20,13,13,27,27,31,31,31,31,18,18,23,23,18,18,28,28,8,8,3,3,6,6,24,24,17,17,10,10,20,20,19,19,2,2,22,22,17,17,19,19,9,9,19,19,18,18,28,28,4,4,21,21,2,2,1,1,12,12,20,20,9,9,0,0,24,24,12,12,7,7,22,22,22,22,23,23,8,8,24,24,14,14,2,2,4,4,2,2,10,10,7,7,16,16,29,29,20,20,30,30,21,21,7,7,3,3,29,29,0,0,21,21,9,9,8,8,23,23,26,26,9,9,9,9,1,1,2,2,15,15,8,8,7,7,16,16,4,4,23,23,0,0,9,9,11,11,18,18,14,14,18,18,21,21,7,7,2,2,7,7,5,5,27,27,4,4,10,10,18,18,28,28,6,6,22,22,2,2,14,14,12,12,3,3,0,0,8,8,10,10,16,16,27,27,30,30,9,9,25,25,18,18,10,10,25,25,15,15,25,25,22,22,2,2,26,26,23,23,15,15,24,24,24,24,6,6,27,27,20,20,9,9,20,20,18,18,11,11,31,31,18,18,28,28,6,6,8,8,5,5,4,4,20,20,15,15,6,6,3,3,2,2,26,26,24,24,2,2,18,18,10,10,11,11,20,20,12,12,28,28,18,18,0,0,26,26,16,16,30,30,27,27,16,16,6,6,24,24,10,10,15,15,19,19,22,22,20,20,23,23,6,6,4,4,25,25,5,5,16,16,11,11,3,3,19,19,10,10,21,21,23,23,2,2,12,12,14,14,17,17,27,27,14,14,31,31,22,22,8,8,8,8,11,11,23,23,17,17,3,3,0,0,17,17,27,27,15,15,9,9,0,0,3,3,27,27,7,7,17,17,25,25,29,29,23,23,29,29,20,20,30,30,20,20,7,7,13,13,2,2,17,17,31,31,5,5,18,18,0,0,23,23,15,15,10,10,25,25,15,15,2,2,0,0,5,5,21,21,8,8,16,16,23,23,7,7,24,24,10,10,3,3,0,0,25,25,31,31,26,26,24,24,9,9,8,8,11,11,5,5,26,26,17,17,17,17,29,29,3,3,30,30,29,29,24,24,21,21,11,11,24,24,1,1,22,22,23,23,27,27,10,10,4,4,10,10,1,1,10,10,9,9,12,12,25,25,13,13,26,26,18,18,27,27,0,0,19,19,17,17,24,24,31,31,27,27,22,22,20,20,20,20,26,26,6,6,8,8,0,0,12,12,20,20,31,31,1,1,2,2,15,15,3,3,7,7,14,14,14,14,12,12,10,10,22,22,12,12,3,3,4,4,15,15,9,9,7,7,23,23,9,9,20,20,20,20,8,8,5,5,4,4,29,29,22,22,11,11,24,24,3,3,24,24,16,16,31,31,7,7,3,3,22,22,14,14,21,21,6,6,15,15,1,1,23,23,26,26,4,4,26,26,2,2,0,0,5,5,31,31,17,17,12,12,21,21,8,8,4,4,30,30,10,10,29,29,15,15,14,14,11,11,22,22,23,23,28,28,12,12,4,4,12,12,25,25,27,27,9,9,18,18,25,25,7,7,3,3,3,3,24,24,9,9,16,16,8,8,5,5,18,18,0,0,10,10,16,16,1,1,18,18,3,3,2,2,12,12,0,0,24,24,24,24,9,9,26,26,4,4,5,5,20,20,2,2,14,14,21,21,22,22,28,28,26,26,14,14,9,9,5,5,10,10,22,22,21,21,13,13,16,16,2,2,22,22,1,1,16,16,0,0,24,24,1,1,2,2,8,8,1,1,7,7,26,26,22,22,22,22,2,2,1,1,11,11,28,28,31,31,6,6,22,22,27,27,0,0,20,20,8,8,11,11,9,9,27,27,21,21,4,4,8,8,8,8,1,1,16,16,16,16,17,17,18,18,9,9,17,17,19,19,5,5,12,12,11,11,19,19,16,16,9,9,24,24,0,0,9,9,8,8,5,5,20,20,31,31,6,6,1,1,13,13,4,4,28,28,16,16,25,25,4,4,14,14,4,4,11,11,24,24,28,28,3,3,2,2,1,1,17,17,22,22,16,16,0,0,3,3,24,24,8,8,13,13,22,22,1,1,7,7,12,12,3,3,18,18,26,26,24,24,30,30,24,24,30,30,0,0,18,18,20,20,15,15,3,3,30,30,1,1,26,26,18,18,16,16,18,18,30,30,6,6,0,0,25,25,29,29,31,31,10,10,3,3,24,24,1,1,19,19,11,11,17,17,0,0,5,5,1,1,9,9,22,22,17,17,2,2,1,1,0,0,11,11,8,8,15,15,3,3,23,23,18,18,17,17,2,2,4,4,11,11,18,18,12,12,8,8,24,24,19,19,1,1,16,16,22,22,29,29,20,20,24,24,15,15,23,23,31,31,13,13,10,10,23,23,21,21,6,6,30,30,25,25,4,4,30,30,29,29,23,23,12,12,25,25,31,31,18,18,11,11,17,17,4,4,1,1,3,3,2,2,7,7,18,18,13,13,13,13,26,26,2,2,9,9,16,16,8,8,3,3,29,29,7,7,25,25,8,8,14,14,29,29,8,8,8,8,15,15,12,12,16,16,7,7,23,23,8,8,8,8,17,17,2,2,0,0,10,10,19,19,2,2,16,16,17,17,19,19,20,20,3,3,6,6,30,30,22,22,20,20,20,20,1,1,4,4,14,14,7,7,11,11,24,24,14,14,15,15,8,8,26,26,0,0,3,3,16,16,20,20,21,21,22,22,22,22,0,0,11,11,1,1,21,21,18,18,24,24,2,2,2,2,19,19,29,29,21,21,4,4,24,24,13,13,20,20,24,24,2,2,16,16,1,1,22,22,14,14,1,1,19,19,14,14,18,18,5,5,30,30,12,12,13,13,21,21,8,8,4,4,9,9,0,0,13,13,14,14,29,29,22,22,24,24,19,19,19,19,7,7,17,17,1,1,15,15,21,21,7,7,26,26,23,23,15,15,31,31,29,29,14,14,10,10,23,23,13,13,16,16,25,25,29,29,0,0,20,20,27,27,2,2,9,9,8,8,30,30,7,7,1,1,8,8,10,10,9,9,5,5,27,27,9,9,17,17,9,9,11,11,3,3,31,31,2,2,25,25,0,0,18,18,8,8,8,8,26,26,29,29,15,15,11,11,22,22,26,26,5,5,2,2,26,26,22,22,1,1,10,10,21,21,3,3,3,3,3,3,6,6,26,26,19,19,21,21,31,31,5,5,25,25,11,11,20,20,25,25,22,22,1,1,16,16,8,8,2,2,14,14,7,7,21,21,17,17,17,17,18,18,15,15,16,16,4,4,14,14,25,25,18,18,7,7,5,5,12,12,23,23,0,0,17,17,14,14,15,15,24,24,15,15,5,5,19,19,11,11,1,1,7,7,9,9,4,4,24,24,4,4,22,22,10,10,11,11,10,10,21,21,0,0,17,17,11,11,27,27,9,9,26,26,16,16,1,1,19,19,16,16,10,10,19,19,30,30,3,3,8,8,12,12,20,20,22,22,22,22,10,10,8,8,15,15,20,20,15,15,4,4,10,10,4,4,21,21,16,16,4,4,30,30,4,4,12,12,1,1,17,17,13,13,13,13,4,4,11,11,6,6,7,7,11,11,22,22,1,1,3,3,7,7,1,1,9,9,15,15,14,14,17,17,12,12,1,1,21,21,12,12,21,21,8,8,14,14,8,8,22,22,15,15,6,6,0,0,3,3,9,9,6,6,11,11,16,16,18,18,6,6,0,0,27,27,3,3,18,18,13,13,13,13,8,8,8,8,18,18,13,13,7,7,5,5,11,11,11,11,17,17,1,1,28,28,4,4,9,9,18,18,3,3,27,27,0,0,25,25,31,31,9,9,6,6,22,22,12,12,8,8,14,14,13,13,2,2,13,13,9,9,0,0,31,31,26,26,16,16,1,1,20,20,17,17,26,26,5,5,14,14,4,4,14,14,21,21,6,6,0,0,2,2,21,21,0,0,9,9,11,11,9,9,26,26,13,13,12,12,8,8,31,31,0,0,2,2,9,9,24,24,20,20,25,25,22,22,22,22,25,25,10,10,31,31,23,23,29,29,20,20,24,24,4,4,29,29,9,9,23,23,8,8,31,31,10,10,24,24,28,28,6,6,20,20,2,2,11,11,16,16,2,2,0,0,24,24,17,17,25,25,9,9,6,6,22,22,22,22,20,20,14,14,23,23,15,15,11,11,1,1,29,29,21,21,18,18,6,6,31,31,3,3,26,26,13,13,13,13,29,29,16,16,6,6,29,29,17,17,27,27,26,26,22,22,29,29,6,6,17,17,29,29,7,7,25,25,6,6,13,13,31,31,29,29,3,3,18,18,12,12,21,21,14,14,30,30,25,25,14,14,25,25,29,29,14,14,13,13,24,24,21,21,17,17,25,25,0,0,7,7,25,25,0,0,17,17,0,0,25,25,24,24,5,5,14,14,15,15,7,7,7,7,2,2,6,6,26,26,25,25,4,4,23,23,8,8,2,2,19,19,7,7,22,22,24,24,17,17,8,8,30,30,15,15,17,17,18,18,9,9,23,23,29,29,8,8,0,0,18,18,28,28,26,26,5,5,29,29,10,10,15,15,12,12,17,17,0,0,20,20,4,4,23,23,6,6,31,31,4,4,4,4,25,25,5,5,14,14,23,23,26,26,29,29,0,0,25,25,5,5,13,13,14,14,4,4,17,17,4,4,23,23,13,13,3,3,3,3,3,3,6,6,29,29,14,14,21,21,3,3,9,9,30,30,12,12,19,19,7,7,22,22,4,4,6,6,25,25,15,15,24,24,22,22,12,12,4,4,31,31,18,18,5,5,17,17,29,29,17,17,0,0,25,25,6,6,1,1,9,9,16,16,14,14,10,10,29,29,9,9,1,1,4,4,14,14,3,3,7,7,16,16,20,20,23,23,31,31,3,3,21,21,23,23,23,23,16,16,3,3,25,25,16,16,23,23,22,22,14,14,2,2,1,1,20,20,18,18,13,13,16,16,4,4,12,12,27,27,2,2,29,29,5,5,1,1,7,7,4,4,9,9,7,7,13,13,13,13,1,1,25,25,11,11,3,3,8,8,0,0,26,26,15,15,3,3,20,20,16,16,30,30,6,6,27,27,24,24,7,7,4,4,8,8,20,20,16,16,6,6,3,3,13,13,26,26,14,14,7,7,25,25,24,24,0,0,21,21,30,30,9,9,26,26,2,2,8,8,31,31,31,31,19,19,1,1,30,30,27,27,18,18,15,15,2,2,23,23,12,12,11,11,10,10,1,1,7,7,5,5,20,20,3,3,1,1,6,6,14,14,0,0,12,12,14,14,0,0,22,22,14,14,17,17,17,17,20,20,0,0,16,16,5,5,6,6,8,8,2,2,15,15,2,2,11,11,20,20,1,1,15,15,13,13,6,6,20,20,0,0,16,16,4,4,31,31,8,8,22,22,23,23,14,14,17,17,19,19,0,0,21,21,29,29,31,31,21,21,15,15,3,3,10,10,4,4,14,14,2,2,29,29,18,18,22,22,9,9,10,10,20,20,13,13,17,17,1,1,24,24,1,1,20,20,14,14,29,29,25,25,9,9,15,15,21,21,9,9,12,12,4,4,20,20,18,18,11,11,20,20,21,21,28,28,4,4,3,3,3,3,16,16,19,19,11,11,22,22,7,7,3,3,29,29,31,31,10,10,8,8,30,30,15,15,16,16,9,9,3,3,25,25,20,20,0,0,8,8,17,17,4,4,2,2,13,13,20,20,12,12,18,18,14,14,6,6,24,24,17,17,2,2,30,30,29,29,3,3,24,24,30,30,9,9,23,23,6,6,22,22,17,17,6,6,7,7,26,26,20,20,9,9,1,1,18,18,0,0,0,0,28,28,8,8,13,13,3,3,2,2,23,23,17,17,27,27,30,30,22,22,25,25,3,3,31,31,21,21,29,29,30,30,29,29,0,0,30,30,20,20,18,18,16,16,21,21,25,25,7,7,19,19,1,1,12,12,6,6,20,20,15,15,12,12,17,17,11,11,27,27,12,12,26,26,8,8,7,7,6,6,25,25,1,1,7,7,30,30,11,11,25,25,17,17,10,10,2,2,9,9,13,13,24,24,2,2,26,26,0,0,27,27,4,4,0,0,27,27,4,4,11,11,8,8,20,20,28,28,1,1,29,29,30,30,25,25,29,29,19,19,3,3,24,24,28,28,10,10,31,31,7,7,21,21,17,17,31,31,3,3,29,29,2,2,19,19,9,9,9,9,29,29,12,12,29,29,25,25,16,16,13,13,15,15,5,5,22,22,6,6,7,7,26,26,17,17,9,9,28,28,2,2,21,21,13,13,18,18,9,9,22,22,15,15,25,25,8,8,25,25,18,18,4,4,21,21,13,13,1,1,12,12,16,16,24,24,28,28,28,28,15,15,18,18,6,6,17,17,5,5,16,16,24,24,1,1,25,25,2,2,5,5,9,9,24,24,16,16,21,21,1,1,17,17,26,26,19,19,29,29,10,10,6,6,25,25,18,18,19,19,1,1,20,20,4,4,9,9,23,23,16,16,2,2,2,2,29,29,23,23,16,16,17,17,28,28,21,21,17,17,0,0,25,25,13,13,18,18,19,19,3,3,1,1,6,6,7,7,28,28,24,24,23,23,20,20,6,6,16,16,19,19,0,0,2,2,3,3,21,21,11,11,10,10,10,10,26,26,4,4,17,17,12,12,15,15,0,0,12,12,12,12,16,16,8,8,15,15,23,23,13,13,3,3,22,22,5,5,1,1,2,2,3,3,21,21,5,5,0,0,7,7,4,4,26,26,19,19,0,0,0,0,17,17,2,2,0,0,25,25,16,16,5,5,4,4,26,26,13,13,21,21,2,2,9,9,2,2,13,13,17,17,26,26,19,19,13,13,27,27,24,24,21,21,16,16,20,20,2,2,29,29,28,28,27,27,29,29,22,22,25,25,1,1,1,1,1,1,16,16,24,24,15,15,13,13,26,26,16,16,9,9,0,0,3,3,21,21,31,31,28,28,0,0,17,17,26,26,3,3,2,2,18,18,19,19,7,7,28,28,8,8,2,2,25,25,20,20,13,13,0,0,6,6,23,23,0,0,23,23,20,20,13,13,28,28,30,30,0,0,18,18,27,27,1,1,26,26,20,20,13,13,31,31,0,0,10,10,23,23,17,17,6,6,22,22,10,10,22,22,9,9,27,27,9,9,6,6,16,16,7,7,19,19,24,24,2,2,31,31,25,25,14,14,1,1,3,3,28,28,30,30,29,29,18,18,5,5,8,8,17,17,9,9,11,11,20,20,15,15,18,18,27,27,30,30,16,16,12,12,18,18,0,0,14,14,22,22,24,24,8,8,4,4,0,0,31,31,12,12,23,23,4,4,27,27,18,18,14,14,31,31,29,29,27,27,11,11,25,25,24,24,28,28,8,8,9,9,20,20,2,2,24,24,22,22,20,20,4,4,27,27,7,7,13,13,6,6,13,13,16,16,17,17,17,17,22,22,16,16,31,31,16,16,11,11,1,1,31,31,24,24,12,12,2,2,22,22,16,16,1,1,17,17,0,0,7,7,4,4,2,2,4,4,8,8,11,11,25,25,23,23,30,30,27,27,9,9,4,4,7,7,16,16,5,5,19,19,1,1,19,19,1,1,22,22,11,11,27,27,23,23,26,26,3,3,8,8,6,6,20,20,18,18,3,3,19,19,22,22,19,19,9,9,9,9,8,8,17,17,0,0,19,19,10,10,27,27,0,0,26,26,23,23,11,11,14,14,18,18,18,18,11,11,11,11,16,16,30,30,13,13,14,14,24,24,26,26,1,1,15,15,27,27,14,14,26,26,20,20,22,22,28,28,8,8,18,18,7,7,14,14,4,4,15,15,10,10,0,0,3,3,27,27,5,5,7,7,7,7,20,20,29,29,3,3,12,12,0,0,9,9,4,4,11,11,29,29,0,0,15,15,5,5,31,31,1,1,2,2,18,18,4,4,10,10,28,28,17,17,12,12,28,28,22,22,0,0,5,5,10,10,4,4,2,2,31,31,8,8,8,8,24,24,18,18,2,2,10,10,21,21,15,15,10,10,20,20,19,19,14,14,9,9,12,12,17,17,21,21,27,27,20,20,18,18,30,30,17,17,9,9,12,12,29,29,8,8,17,17,1,1,16,16,30,30,23,23,26,26,10,10,6,6,11,11,31,31,10,10,3,3,30,30,29,29,16,16,7,7,4,4,12,12,5,5,7,7,0,0,23,23,1,1,27,27,21,21,3,3,2,2,4,4,25,25,22,22,0,0,25,25,26,26,6,6,11,11,26,26,25,25,12,12,3,3,1,1,9,9,4,4,15,15,4,4,2,2,15,15,2,2,27,27,31,31,21,21,21,21,9,9,20,20,3,3,7,7,25,25,9,9,8,8,16,16,14,14,12,12,16,16,19,19,5,5,15,15,31,31,9,9,0,0,8,8,29,29,11,11,3,3,3,3,6,6,6,6,7,7,15,15,21,21,1,1,6,6,9,9,29,29,18,18,14,14,4,4,25,25,1,1,16,16,24,24,14,14,4,4,19,19,10,10,2,2,13,13,21,21,17,17,4,4,27,27,16,16,16,16,19,19,24,24,13,13,10,10,8,8,12,12,8,8,4,4,2,2,15,15,11,11,18,18,3,3,3,3,9,9,27,27,16,16,25,25,30,30,1,1,10,10,0,0,19,19,1,1,22,22,9,9,27,27,27,27,2,2,15,15,0,0,11,11,16,16,0,0,7,7,4,4,24,24,29,29,27,27,17,17,5,5,15,15,4,4,1,1,15,15,12,12,26,26,16,16,14,14,6,6,10,10,27,27,3,3,28,28,14,14,1,1,15,15,1,1,6,6,13,13,15,15,23,23,0,0,28,28,25,25,8,8,23,23,11,11,17,17,6,6,17,17,7,7,9,9,30,30,8,8,12,12,18,18,13,13,7,7,11,11,20,20,16,16,5,5,18,18,3,3,9,9,9,9,5,5,19,19,31,31,6,6,0,0,5,5,2,2,18,18,1,1,17,17,30,30,20,20,30,30,16,16,20,20,15,15,20,20,21,21,31,31,1,1,8,8,23,23,17,17,2,2,4,4,8,8,21,21,13,13,4,4,3,3,5,5,10,10,15,15,21,21,25,25,0,0,2,2,2,2,29,29,6,6,20,20,24,24,12,12,19,19,30,30,25,25,22,22,27,27,22,22,17,17,11,11,5,5,6,6,19,19,28,28,22,22,26,26,6,6,12,12,9,9,24,24,4,4,10,10,20,20,10,10,25,25,19,19,18,18,2,2,26,26,13,13,10,10,2,2,17,17,10,10,27,27,25,25,5,5,14,14,15,15,25,25,31,31,29,29,26,26,2,2,25,25,4,4,6,6,27,27,15,15,8,8,3,3,10,10,24,24,3,3,28,28,31,31,15,15,24,24,24,24,27,27,20,20,7,7,26,26,28,28,0,0,14,14,24,24,5,5,8,8,8,8,19,19,6,6,22,22,2,2,22,22,13,13,12,12,9,9,27,27,6,6,9,9,12,12,23,23,30,30,16,16,12,12,29,29,5,5,3,3,28,28,18,18,0,0,2,2,0,0,10,10,24,24,16,16,7,7,22,22,4,4,1,1,30,30,14,14,18,18,3,3,5,5,14,14,30,30,22,22,5,5,16,16,2,2,31,31,16,16,19,19,0,0,31,31,16,16,17,17,20,20,19,19,16,16,24,24,31,31,12,12,18,18,8,8,11,11,27,27,19,19,21,21,29,29,27,27,22,22,24,24,23,23,2,2,0,0,9,9,22,22,31,31,20,20,22,22,15,15,30,30,12,12,6,6,14,14,24,24,3,3,30,30,12,12,7,7,21,21,11,11,0,0,8,8,23,23,18,18,5,5,10,10,5,5,9,9,27,27,3,3,22,22,29,29,21,21,14,14,27,27,0,0,15,15,31,31,8,8,16,16,20,20,19,19,1,1,0,0,9,9,31,31,31,31,25,25,17,17,17,17,13,13,31,31,19,19,8,8,23,23,19,19,9,9,6,6,16,16,22,22,21,21,12,12,20,20,31,31,24,24,31,31,20,20,23,23,28,28,28,28,6,6,14,14,25,25,6,6,27,27,19,19,21,21,11,11,12,12,13,13,24,24,21,21,9,9,8,8,18,18,0,0,6,6,25,25,1,1,15,15,9,9,31,31,13,13,19,19,18,18,29,29,1,1,6,6,6,6,30,30,24,24,11,11,16,16,4,4,19,19,29,29,17,17,8,8,3,3,18,18,30,30,29,29,29,29,20,20,6,6,9,9,12,12,7,7,10,10,0,0,30,30,23,23,20,20,1,1,18,18,8,8,0,0,4,4,5,5,20,20,16,16,4,4,16,16,15,15,24,24,6,6,0,0,27,27,13,13,8,8,26,26,1,1,18,18,24,24,12,12,14,14,3,3,26,26,14,14,10,10,30,30,18,18,8,8,26,26,8,8,25,25,13,13,10,10,8,8,25,25,10,10,4,4,3,3,13,13,25,25,5,5,24,24,13,13,22,22,3,3,28,28,13,13,15,15,9,9,28,28,8,8,26,26,1,1,27,27,3,3,2,2,0,0,2,2,27,27,18,18,22,22,31,31,4,4,11,11,29,29,31,31,23,23,0,0,20,20,21,21,14,14,19,19,22,22,10,10,0,0,12,12,10,10,6,6,24,24,31,31,15,15,28,28,16,16,1,1,21,21,26,26,14,14,11,11,24,24,14,14,2,2,10,10,31,31,10,10,0,0,19,19,28,28,17,17,4,4,14,14,22,22,9,9,16,16,29,29,6,6,16,16,2,2,16,16,28,28,5,5,2,2,29,29,7,7,23,23,23,23,24,24,19,19,10,10,17,17,19,19,7,7,2,2,31,31,28,28,7,7,16,16,9,9,31,31,5,5,28,28,17,17,21,21,31,31,5,5,25,25,2,2,29,29,23,23,6,6,18,18,9,9,27,27,19,19,8,8,20,20,17,17,16,16,15,15,14,14,15,15,27,27,20,20,0,0,15,15,17,17,26,26,17,17,19,19,16,16,31,31,20,20,8,8,27,27,9,9,6,6,29,29,1,1,4,4,1,1,29,29,25,25,13,13,8,8,16,16,22,22,6,6,3,3,2,2,29,29,4,4,21,21,5,5,22,22,7,7,24,24,1,1,8,8,12,12,30,30,23,23,9,9,16,16,10,10,17,17,10,10,8,8,9,9,9,9,0,0,15,15,6,6,8,8,4,4,21,21,22,22,1,1,0,0,26,26,19,19,29,29,15,15,14,14,7,7,15,15,11,11,21,21,29,29,17,17,4,4,21,21,12,12,10,10,17,17,23,23,8,8,7,7,2,2,7,7,13,13,11,11,31,31,31,31,4,4,27,27,19,19,15,15,15,15,23,23,14,14,8,8,16,16,11,11,13,13,11,11,26,26,16,16,16,16,5,5,23,23,28,28,23,23,17,17,28,28,11,11,18,18,21,21,9,9,1,1,12,12,4,4,20,20,5,5,25,25,20,20,16,16,9,9,9,9,0,0,20,20,5,5,24,24,21,21,10,10,18,18,2,2,18,18,0,0,0,0,31,31,2,2,30,30,10,10,14,14,4,4,0,0,4,4,6,6,22,22,5,5,0,0,17,17,22,22,6,6,13,13,7,7,27,27,21,21,12,12,8,8,14,14,29,29,6,6,8,8,25,25,0,0,14,14,9,9,29,29,2,2,26,26,2,2,15,15,0,0,26,26,10,10,7,7,17,17,18,18,20,20,27,27,11,11,9,9,28,28,24,24,29,29,6,6,2,2,4,4,1,1,11,11,27,27,19,19,0,0,28,28,8,8,0,0,15,15,4,4,22,22,6,6,12,12,26,26,14,14,4,4,16,16,4,4,1,1,30,30,4,4,12,12,7,7,11,11,27,27,22,22,5,5,9,9,27,27,19,19,5,5,16,16,13,13,10,10,20,20,16,16,21,21,17,17,13,13,3,3,5,5,10,10,12,12,13,13,12,12,4,4,19,19,8,8,5,5,13,13,25,25,10,10,26,26,8,8,6,6,3,3,4,4,2,2,3,3,22,22,24,24,24,24,19,19,7,7,6,6,6,6,9,9,26,26,1,1,22,22,24,24,18,18,30,30,6,6,26,26,8,8,20,20,19,19,9,9,30,30,2,2,8,8,11,11,8,8,11,11,13,13,15,15,4,4,17,17,4,4,10,10,29,29,21,21,0,0,14,14,20,20,24,24,11,11,20,20,18,18,2,2,26,26,5,5,16,16,1,1,21,21,29,29,10,10,11,11,30,30,9,9,20,20,6,6,10,10,16,16,1,1,25,25,23,23,22,22,20,20,4,4,25,25,25,25,25,25,1,1,6,6,13,13,27,27,30,30,12,12,28,28,12,12,4,4,9,9,3,3,5,5,6,6,21,21,23,23,19,19,12,12,14,14,22,22,7,7,20,20,4,4,29,29,27,27,28,28,13,13,13,13,8,8,20,20,31,31,27,27,29,29,4,4,26,26,11,11,11,11,0,0,17,17,3,3,4,4,11,11,2,2,22,22,7,7,31,31,27,27,14,14,29,29,4,4,3,3,25,25,3,3,6,6,21,21,7,7,17,17,0,0,21,21,13,13,8,8,2,2,28,28,17,17,19,19,7,7,0,0,7,7,18,18,28,28,16,16,21,21,13,13,3,3,25,25,2,2,8,8,2,2,30,30,13,13,26,26,7,7,27,27,4,4,17,17,29,29,15,15,28,28,28,28,26,26,21,21,21,21,17,17,0,0,24,24,15,15,7,7,15,15,27,27,24,24,25,25,12,12,18,18,12,12,31,31,17,17,2,2,19,19,6,6,5,5,10,10,24,24,25,25,7,7,9,9,12,12,12,12,5,5,28,28,24,24,23,23,26,26,13,13,10,10,4,4,17,17,17,17,0,0,14,14,14,14,18,18,17,17,0,0,6,6,16,16,23,23,10,10,1,1,27,27,28,28,23,23,13,13,6,6,15,15,8,8,14,14,8,8,14,14,3,3,5,5,18,18,23,23,4,4,6,6,27,27,15,15,5,5,10,10,28,28,18,18,23,23,24,24,17,17,6,6,11,11,12,12,29,29,28,28,4,4,17,17,1,1,10,10,30,30,5,5,24,24,24,24,4,4,13,13,14,14,3,3,12,12,29,29,16,16,7,7,6,6,28,28,4,4,29,29,15,15,0,0,23,23,9,9,26,26,13,13,21,21,27,27,10,10,3,3,16,16,7,7,31,31,9,9,23,23,5,5,8,8,10,10,31,31,24,24,17,17,21,21,15,15,5,5,26,26,27,27,30,30,9,9,17,17,1,1,14,14,10,10,11,11,7,7,10,10,12,12,8,8,0,0,14,14,17,17,19,19,6,6,13,13,29,29,5,5,0,0,15,15,17,17,31,31,25,25,31,31,2,2,16,16,25,25,19,19,21,21,30,30,6,6,0,0,14,14,22,22,1,1,16,16,17,17,0,0,26,26,22,22,4,4,16,16,20,20,8,8,31,31,10,10,16,16,24,24,13,13,29,29,2,2,21,21,28,28,20,20,31,31,31,31,30,30,17,17,4,4,14,14,12,12,11,11,20,20,24,24,18,18,21,21,16,16,10,10,2,2,10,10,25,25,27,27,10,10,1,1,28,28,23,23,18,18,20,20,19,19,11,11,19,19,23,23,17,17,27,27,5,5,26,26,22,22,19,19,21,21,11,11,10,10,18,18,15,15,16,16,5,5,8,8,21,21,5,5,27,27,19,19,19,19,20,20,15,15,3,3,24,24,14,14,15,15,1,1,3,3,12,12,5,5,11,11,4,4,6,6,4,4,25,25,15,15,10,10,4,4,22,22,26,26,26,26,4,4,25,25,16,16,6,6,18,18,30,30,20,20,4,4,9,9,29,29,26,26,19,19,2,2,24,24,25,25,4,4,5,5,0,0,30,30,10,10,12,12,28,28,24,24,15,15,7,7,22,22,0,0,16,16,23,23,27,27,11,11,13,13,5,5,3,3,27,27,12,12,0,0,25,25,28,28,18,18,28,28,19,19,14,14,25,25,12,12,1,1,23,23,19,19,6,6,6,6,14,14,15,15,20,20,1,1,9,9,31,31,8,8,16,16,1,1,23,23,4,4,12,12,7,7,15,15,6,6,0,0,10,10,19,19,3,3,20,20,24,24,2,2,20,20,0,0,24,24,9,9,3,3,0,0,23,23,8,8,13,13,25,25,6,6,20,20,13,13,27,27,1,1,1,1,18,18,4,4,14,14,13,13,18,18,27,27,1,1,2,2,13,13,22,22,12,12,23,23,29,29,19,19,27,27,21,21,25,25,11,11,7,7,18,18,13,13,10,10,28,28,17,17,31,31,12,12,27,27,27,27,10,10,20,20,1,1,19,19,8,8,6,6,9,9,8,8,28,28,8,8,9,9,2,2,8,8,22,22,19,19,14,14,19,19,17,17,25,25,28,28,14,14,23,23,10,10,1,1,20,20,4,4,18,18,22,22,30,30,7,7,25,25,31,31,18,18,7,7,7,7,6,6,7,7,12,12,29,29,9,9,16,16,9,9,3,3,19,19,3,3,25,25,10,10,13,13,26,26,29,29,19,19,13,13,0,0,22,22,18,18,15,15,17,17,6,6,12,12,29,29,6,6,2,2,5,5,21,21,26,26,20,20,30,30,4,4,28,28,10,10,19,19,31,31,27,27,6,6,4,4,20,20,29,29,29,29,7,7,10,10,14,14,16,16,8,8,12,12,21,21,28,28,16,16,10,10,22,22,27,27,30,30,29,29,12,12,4,4,17,17,14,14,28,28,3,3,25,25,11,11,20,20,26,26,25,25,20,20,5,5,8,8,12,12,24,24,23,23,26,26,0,0,2,2,23,23,6,6,2,2,22,22,31,31,0,0,2,2,19,19,10,10,1,1,20,20,0,0,20,20,30,30,21,21,16,16,10,10,4,4,28,28,21,21,14,14,17,17,9,9,17,17,4,4,26,26,5,5,29,29,30,30,24,24,4,4,11,11,3,3,24,24,5,5,17,17,31,31,11,11,25,25,2,2,25,25,12,12,6,6,6,6,0,0,6,6,20,20,0,0,6,6,7,7,13,13,7,7,21,21,22,22,0,0,23,23,3,3,2,2,27,27,20,20,17,17,13,13,10,10,24,24,12,12,13,13,7,7,13,13,14,14,23,23,2,2,1,1,14,14,4,4,4,4,17,17,0,0,19,19,20,20,2,2,11,11,27,27,17,17,6,6,24,24,29,29,29,29,10,10,7,7,26,26,14,14,7,7,24,24,4,4,28,28,26,26,13,13,7,7,20,20,16,16,7,7,13,13,13,13,13,13,23,23,29,29,2,2,1,1,12,12,25,25,11,11,24,24,14,14,20,20,3,3,30,30,31,31,3,3,31,31,30,30,22,22,15,15,10,10,14,14,8,8,21,21,21,21,21,21,26,26,0,0,13,13,0,0,2,2,31,31,9,9,31,31,29,29,9,9,19,19,3,3,6,6,26,26,2,2,24,24,10,10,10,10,29,29,16,16,17,17,19,19,6,6,14,14,3,3,19,19,16,16,3,3,26,26,19,19,24,24,24,24,18,18,8,8,17,17,3,3,13,13,2,2,10,10,18,18,8,8,4,4,28,28,24,24,25,25,16,16,12,12,21,21,9,9,6,6,16,16,31,31,14,14,19,19,22,22,22,22,24,24,24,24,15,15,4,4,4,4,8,8,7,7,12,12,19,19,1,1,31,31,30,30,16,16,6,6,11,11,26,26,18,18,23,23,27,27,28,28,12,12,9,9,31,31,1,1,15,15,18,18,29,29,19,19,11,11,16,16,12,12,17,17,11,11,2,2,8,8,8,8,8,8,1,1,17,17,6,6,29,29,0,0,20,20,20,20,6,6,31,31,24,24,11,11,30,30,19,19,28,28,31,31,2,2,17,17,20,20,14,14,6,6,19,19,10,10,7,7,8,8,23,23,21,21,10,10,4,4,15,15,6,6,3,3,15,15,21,21,16,16,31,31,25,25,29,29,1,1,31,31,27,27,9,9,30,30,25,25,2,2,20,20,14,14,20,20,15,15,11,11,28,28,17,17,21,21,28,28,25,25,23,23,17,17,28,28,11,11,24,24,8,8,10,10,30,30,5,5,10,10,4,4,19,19,4,4,30,30,8,8,12,12,15,15,5,5,2,2,24,24,26,26,17,17,5,5,7,7,3,3,2,2,11,11,13,13,7,7,6,6,30,30,19,19,0,0,28,28,4,4,8,8,1,1,7,7,22,22,10,10,22,22,16,16,0,0,13,13,6,6,0,0,21,21,9,9,15,15,8,8,27,27,20,20,17,17,16,16,11,11,27,27,26,26,3,3,16,16,23,23,2,2,5,5,5,5,27,27,0,0,0,0,25,25,7,7,25,25,24,24,13,13,13,13,26,26,31,31,25,25,15,15,20,20,10,10,16,16,10,10,20,20,27,27,2,2,28,28,11,11,0,0,24,24,23,23,5,5,8,8,12,12,0,0,0,0,5,5,18,18,31,31,23,23,7,7,2,2,24,24,6,6,27,27,18,18,19,19,8,8,23,23,8,8,25,25,16,16,18,18,11,11,29,29,30,30,5,5,25,25,17,17,14,14,4,4,11,11,6,6,15,15,21,21,7,7,4,4,2,2,29,29,2,2,17,17,21,21,22,22,30,30,7,7,24,24,26,26,19,19,27,27,12,12,4,4,18,18,10,10,11,11,31,31,15,15,31,31,19,19,19,19,11,11,7,7,26,26,14,14,4,4,31,31,3,3,3,3,18,18,21,21,22,22,26,26,3,3,27,27,19,19,9,9,30,30,2,2,27,27,28,28,2,2,9,9,28,28,5,5,22,22,16,16,24,24,20,20,30,30,18,18,2,2,6,6,28,28,18,18,25,25,15,15,31,31,1,1,29,29,1,1,24,24,14,14,15,15,27,27,22,22,2,2,14,14,20,20,17,17,14,14,7,7,20,20,2,2,1,1,10,10,14,14,20,20,5,5,19,19,7,7,9,9,29,29,29,29,6,6,24,24,2,2,16,16,5,5,31,31,11,11,11,11,9,9,5,5,22,22,14,14,20,20,28,28,1,1,4,4,29,29,22,22,0,0,4,4,25,25,4,4,12,12,14,14,30,30,2,2,10,10,0,0,17,17,22,22,2,2,30,30,26,26,27,27,20,20,23,23,10,10,24,24,23,23,20,20,7,7,2,2,17,17,19,19,14,14,25,25,30,30,26,26,0,0,14,14,19,19,22,22,22,22,13,13,13,13,23,23,11,11,12,12,15,15,5,5,22,22,20,20,30,30,4,4,17,17,6,6,12,12,12,12,22,22,24,24,17,17,2,2,3,3,9,9,5,5,26,26,1,1,21,21,6,6,23,23,0,0,11,11,25,25,1,1,23,23,14,14,11,11,2,2,1,1,6,6,8,8,4,4,26,26,3,3,22,22,24,24,10,10,14,14,15,15,20,20,20,20,19,19,5,5,22,22,2,2,24,24,30,30,9,9,10,10,5,5,17,17,25,25,11,11,1,1,12,12,28,28,31,31,18,18,12,12,2,2,21,21,7,7,21,21,8,8,14,14,17,17,11,11,16,16,7,7,10,10,6,6,10,10,11,11,28,28,30,30,9,9,31,31,23,23,19,19,14,14,11,11,10,10,9,9,10,10,25,25,9,9,2,2,17,17,11,11,7,7,4,4,3,3,24,24,15,15,4,4,15,15,6,6,21,21,0,0,17,17,19,19,3,3,12,12,13,13,26,26,20,20,23,23,30,30,8,8,1,1,0,0,6,6,12,12,4,4,26,26,30,30,5,5,13,13,6,6,27,27,29,29,16,16,7,7,19,19,19,19,21,21,30,30,5,5,28,28,26,26,3,3,25,25,12,12,26,26,3,3,0,0,20,20,12,12,24,24,5,5,18,18,3,3,26,26,13,13,26,26,11,11,12,12,7,7,8,8,9,9,25,25,31,31,24,24,27,27,2,2,21,21,24,24,29,29,2,2,10,10,0,0,13,13,28,28,2,2,11,11,11,11,26,26,7,7,27,27,2,2,25,25,6,6,27,27,30,30,15,15,20,20,11,11,10,10,5,5,21,21,23,23,26,26,24,24,16,16,19,19,30,30,20,20,5,5,9,9,23,23,3,3,16,16,31,31,7,7,4,4,21,21,31,31,24,24,4,4,28,28,7,7,17,17,20,20,17,17,0,0,20,20,23,23,21,21,17,17,9,9,17,17,7,7,17,17,10,10,16,16,31,31,15,15,9,9,1,1,7,7,15,15,10,10,8,8,12,12,16,16,24,24,12,12,19,19,23,23,11,11,30,30,10,10,29,29,29,29,19,19,13,13,22,22,0,0,0,0,0,0,3,3,3,3,0,0,12,12,14,14,23,23,27,27,22,22,23,23,31,31,4,4,26,26,30,30,8,8,0,0,21,21,19,19,1,1,25,25,30,30,31,31,5,5,9,9,3,3,14,14,8,8,9,9,1,1,26,26,0,0,18,18,0,0,14,14,6,6,22,22,2,2,10,10,12,12,0,0,8,8,23,23,19,19,1,1,26,26,2,2,31,31,26,26,23,23,0,0,21,21,27,27,18,18,12,12,29,29,17,17,13,13,24,24,23,23,17,17,25,25,13,13,22,22,30,30,1,1,8,8,30,30,7,7,25,25,12,12,14,14,20,20,22,22,12,12,21,21,8,8,15,15,16,16,8,8,24,24,1,1,17,17,12,12,23,23,16,16,21,21,10,10,9,9,29,29,21,21,0,0,18,18,31,31,17,17,1,1,19,19,0,0,12,12,10,10,6,6,8,8,20,20,12,12,20,20,21,21,22,22,29,29,2,2,6,6,10,10,24,24,12,12,20,20,29,29,6,6,7,7,15,15,22,22,18,18,31,31,28,28,19,19,9,9,27,27,28,28,24,24,25,25,0,0,0,0,7,7,0,0,15,15,4,4,19,19,9,9,21,21,13,13,3,3,30,30,8,8,3,3,24,24,28,28,14,14,1,1,13,13,8,8,6,6,2,2,8,8,10,10,18,18,11,11,6,6,12,12,23,23,8,8,21,21,6,6,11,11,24,24,14,14,30,30,16,16,4,4,5,5,23,23,8,8,2,2,11,11,3,3,4,4,7,7,8,8,17,17,8,8,3,3,2,2,14,14,28,28,20,20,7,7,5,5,31,31,12,12,11,11,5,5,17,17,16,16,13,13,19,19,17,17,26,26,16,16,21,21,26,26,22,22,31,31,5,5,0,0,13,13,22,22,15,15,17,17,10,10,28,28,2,2,30,30,18,18,0,0,7,7,7,7,1,1,20,20,29,29,2,2,20,20,4,4,28,28,9,9,9,9,18,18,17,17,18,18,16,16,25,25,7,7,28,28,13,13,20,20,12,12,25,25,18,18,13,13,24,24,6,6,30,30,15,15,18,18,17,17,22,22,20,20,28,28,8,8,25,25,16,16,28,28,6,6,1,1,18,18,1,1,21,21,18,18,23,23,18,18,19,19,3,3,19,19,0,0,17,17,20,20,15,15,4,4,17,17,0,0,15,15,7,7,3,3,13,13,22,22,7,7,15,15,14,14,14,14,0,0,16,16,21,21,15,15,4,4,9,9,13,13,26,26,11,11,27,27,31,31,27,27,25,25,31,31,1,1,10,10,8,8,27,27,29,29,1,1,28,28,30,30,28,28,23,23,8,8,10,10,13,13,7,7,28,28,12,12,26,26,28,28,26,26,4,4,7,7,21,21,5,5,0,0,25,25,25,25,25,25,2,2,9,9,20,20,13,13,26,26,24,24,4,4,17,17,23,23,22,22,13,13,3,3,3,3,26,26,8,8,13,13,22,22,0,0,5,5,22,22,0,0,12,12,29,29,29,29,12,12,20,20,10,10,18,18,10,10,26,26,21,21,16,16,26,26,31,31,18,18,6,6,1,1,16,16,17,17,7,7,13,13,25,25,26,26,22,22,8,8,31,31,13,13,27,27,8,8,17,17,5,5,17,17,3,3,24,24,22,22,1,1,1,1,21,21,25,25,18,18,31,31,15,15,15,15,29,29,15,15,27,27,25,25,1,1,30,30,20,20,4,4,21,21,0,0,21,21,10,10,5,5,19,19,30,30,22,22,27,27,2,2,24,24,3,3,27,27,3,3,20,20,13,13,0,0,31,31,30,30,1,1,8,8,12,12,26,26,30,30,9,9,25,25,3,3,23,23,3,3,22,22,23,23,13,13,13,13,14,14,10,10,11,11,9,9,30,30,11,11,3,3,0,0,17,17,31,31,19,19,3,3,27,27,1,1,4,4,4,4,28,28,9,9,22,22,20,20,11,11,21,21,13,13,12,12,15,15,17,17,1,1,1,1,17,17,1,1,0,0,11,11,22,22,18,18,24,24,29,29,11,11,4,4,20,20,18,18,2,2,19,19,13,13,15,15,2,2,28,28,7,7,10,10,28,28,22,22,0,0,30,30,4,4,28,28,8,8,5,5,4,4,12,12,3,3,30,30,27,27,22,22,31,31,7,7,19,19,21,21,2,2,21,21,31,31,4,4,28,28,17,17,21,21,14,14,30,30,9,9,31,31,7,7,8,8,12,12,18,18,3,3,13,13,5,5,18,18,30,30,14,14,18,18,23,23,31,31,0,0,12,12,26,26,22,22,1,1,23,23,2,2,20,20,8,8,10,10,10,10,0,0,0,0,30,30,13,13,8,8,27,27,14,14,17,17,8,8,19,19,21,21,24,24,29,29,3,3,5,5,13,13,7,7,23,23,11,11,5,5,16,16,3,3,31,31,18,18,7,7,2,2,27,27,3,3,19,19,14,14,7,7,13,13,31,31,4,4,4,4,27,27,18,18,8,8,3,3,31,31,26,26,11,11,3,3,12,12,17,17,22,22,19,19,11,11,9,9,12,12,1,1,22,22,26,26,2,2,22,22,27,27,25,25,15,15,28,28,22,22,16,16,31,31,29,29,26,26,6,6,4,4,16,16,7,7,30,30,6,6,10,10,31,31,16,16,9,9,14,14,17,17,16,16,29,29,8,8,3,3,8,8,18,18,8,8,30,30,17,17,5,5,11,11,2,2,31,31,24,24,8,8,28,28,3,3,6,6,2,2,0,0,27,27,19,19,31,31,11,11,21,21,22,22,23,23,5,5,31,31,11,11,3,3,4,4,22,22,30,30,10,10,25,25,23,23,4,4,20,20,17,17,4,4,20,20,13,13,31,31,7,7,28,28,28,28,16,16,10,10,23,23,25,25,2,2,9,9,18,18,17,17,6,6,3,3,30,30,9,9,19,19,0,0,28,28,0,0,20,20,23,23,30,30,5,5,8,8,16,16,27,27,3,3,9,9,21,21,15,15,5,5,17,17,0,0,8,8,19,19,27,27,3,3,2,2,31,31,19,19,10,10,10,10,24,24,11,11,5,5,7,7,16,16,5,5,22,22,19,19,11,11,28,28,3,3,13,13,11,11,7,7,15,15,0,0,17,17,24,24,19,19,23,23,20,20,15,15,4,4,10,10,7,7,15,15,25,25,19,19,10,10,5,5,27,27,11,11,17,17,18,18,18,18,10,10,30,30,0,0,3,3,12,12,29,29,23,23,28,28,2,2,5,5,14,14,18,18,15,15,12,12,17,17,12,12,11,11,24,24,29,29,11,11,1,1,21,21,22,22,0,0,5,5,24,24,22,22,6,6,0,0,1,1,19,19,23,23,24,24,5,5,29,29,1,1,25,25,0,0,15,15,23,23,15,15,15,15,11,11,13,13,24,24,12,12,24,24,24,24,10,10,0,0,17,17,17,17,11,11,1,1,7,7,28,28,27,27,29,29,13,13,31,31,3,3,5,5,30,30,17,17,1,1,6,6,29,29,2,2,12,12,30,30,19,19,20,20,4,4,1,1,30,30,29,29,16,16,16,16,16,16,16,16,28,28,7,7,31,31,18,18,8,8,16,16,3,3,14,14,12,12,30,30,18,18,5,5,31,31,27,27,31,31,16,16,4,4,20,20,4,4,12,12,26,26,0,0,10,10,21,21,1,1,19,19,1,1,3,3,25,25,11,11,4,4,8,8,20,20,9,9,5,5,12,12,7,7,12,12,24,24,21,21,4,4,18,18,24,24,0,0,0,0,14,14,12,12,14,14,2,2,22,22,27,27,27,27,22,22,19,19,13,13,2,2,4,4,11,11,20,20,18,18,29,29,24,24,5,5,29,29,15,15,18,18,1,1,27,27,20,20,25,25,24,24,15,15,30,30,8,8,0,0,26,26,29,29,5,5,0,0,22,22,1,1,6,6,23,23,0,0,8,8,14,14,31,31,0,0,0,0,17,17,9,9,29,29,25,25,13,13,6,6,16,16,1,1,21,21,4,4,8,8,4,4,26,26,14,14,6,6,11,11,31,31,3,3,21,21,20,20,22,22,6,6,7,7,10,10,28,28,0,0,26,26,19,19,28,28,10,10,6,6,25,25,27,27,28,28,24,24,3,3,11,11,14,14,16,16,7,7,10,10,28,28,24,24,23,23,5,5,24,24,10,10,4,4,30,30,17,17,8,8,16,16,27,27,27,27,24,24,8,8,14,14,19,19,25,25,26,26,23,23,22,22,1,1,18,18,8,8,13,13,30,30,4,4,17,17,5,5,28,28,31,31,29,29,9,9,14,14,6,6,3,3,15,15,12,12,2,2,20,20,5,5,22,22,3,3,23,23,1,1,3,3,27,27,4,4,26,26,0,0,25,25,31,31,8,8,26,26,29,29,28,28,14,14,2,2,11,11,13,13,2,2,21,21,22,22,6,6,1,1,1,1,27,27,19,19,22,22,19,19,1,1,13,13,5,5,0,0,20,20,2,2,20,20,11,11,2,2,17,17,10,10,26,26,6,6,20,20,15,15,3,3,9,9,31,31,12,12,7,7,9,9,30,30,9,9,12,12,15,15,14,14,19,19,26,26,4,4,20,20,30,30,2,2,18,18,14,14,23,23,7,7,20,20,26,26,3,3,30,30,10,10,10,10,10,10,13,13,20,20,31,31,1,1,23,23,8,8,18,18,18,18,9,9,24,24,24,24,25,25,0,0,16,16,21,21,4,4,9,9,17,17,10,10,13,13,12,12,27,27,31,31,24,24,1,1,1,1,5,5,5,5,3,3,2,2,7,7,4,4,31,31,28,28,6,6,15,15,18,18,27,27,28,28,3,3,20,20,6,6,8,8,1,1,10,10,16,16,26,26,29,29,23,23,24,24,4,4,19,19,22,22,25,25,8,8,3,3,10,10,25,25,22,22,6,6,26,26,0,0,2,2,16,16,21,21,0,0,20,20,7,7,24,24,30,30,0,0,14,14,24,24,20,20,25,25,8,8,25,25,13,13,9,9,19,19,5,5,10,10,13,13,10,10,13,13,12,12,18,18,16,16,15,15,3,3,11,11,4,4,31,31,8,8,17,17,1,1,5,5,14,14,12,12,3,3,15,15,27,27,2,2,29,29,20,20,15,15,4,4,29,29,0,0,4,4,30,30,29,29,6,6,6,6,18,18,14,14,11,11,21,21,7,7,31,31,18,18,3,3,12,12,0,0,5,5,12,12,18,18,9,9,1,1,0,0,26,26,13,13,12,12,20,20,2,2,9,9,21,21,6,6,19,19,10,10,28,28,7,7,22,22,26,26,21,21,1,1,2,2,11,11,8,8,22,22,20,20,12,12,12,12,3,3,26,26,14,14,29,29,3,3,27,27,30,30,13,13,30,30,25,25,20,20,2,2,2,2,7,7,5,5,25,25,15,15,5,5,1,1,26,26,2,2,27,27,16,16,8,8,14,14,27,27,6,6,3,3,11,11,7,7,25,25,24,24,18,18,18,18,23,23,31,31,28,28,2,2,24,24,14,14,25,25,6,6,11,11,1,1,1,1,15,15,24,24,8,8,17,17,23,23,24,24,8,8,24,24,13,13,22,22,23,23,23,23,1,1,21,21,19,19,10,10,11,11,22,22,1,1,30,30,4,4,18,18,7,7,19,19,29,29,18,18,26,26,3,3,2,2,5,5,13,13,18,18,26,26,11,11,0,0,1,1,9,9,8,8,7,7,18,18,9,9,18,18,2,2,29,29,10,10,10,10,30,30,27,27,24,24,26,26,4,4,26,26,3,3,21,21,20,20,22,22,7,7,14,14,8,8,11,11,2,2,19,19,20,20,0,0,28,28,1,1,8,8,16,16,7,7,17,17,10,10,17,17,24,24,4,4,25,25,19,19,7,7,5,5,15,15,2,2,25,25,23,23,18,18,22,22,7,7,0,0,9,9,1,1,16,16,20,20,16,16,5,5,5,5,24,24,23,23,3,3,1,1,6,6,8,8,4,4,1,1,13,13,4,4,10,10,18,18,31,31,21,21,10,10,10,10,4,4,27,27,16,16,15,15,16,16,27,27,25,25,14,14,4,4,29,29,16,16,5,5,16,16,5,5,2,2,29,29,11,11,14,14,20,20,3,3,12,12,20,20,15,15,22,22,4,4,16,16,20,20,26,26,6,6,18,18,21,21,13,13,10,10,7,7,1,1,30,30,18,18,20,20,27,27,19,19,2,2,8,8,30,30,4,4,15,15,29,29,4,4,24,24,31,31,22,22,19,19,30,30,23,23,19,19,22,22,27,27,28,28,30,30,0,0,0,0,7,7,3,3,4,4,10,10,30,30,17,17,30,30,5,5,6,6,0,0,26,26,27,27,9,9,15,15,24,24,14,14,24,24,8,8,0,0,0,0,2,2,15,15,15,15,21,21,6,6,15,15,6,6,8,8,1,1,29,29,18,18,7,7,31,31,21,21,28,28,28,28,6,6,0,0,17,17,29,29,1,1,2,2,19,19,5,5,21,21,19,19,7,7,23,23,30,30,17,17,10,10,19,19,18,18,23,23,13,13,27,27,3,3,1,1,1,1,8,8,12,12,4,4,18,18,16,16,0,0,24,24,8,8,24,24,4,4,23,23,23,23,17,17,25,25,24,24,4,4,24,24,29,29,26,26,15,15,22,22,24,24,8,8,8,8,25,25,20,20,31,31,30,30,8,8,19,19,13,13,28,28,29,29,6,6,0,0,19,19,27,27,31,31,14,14,0,0,13,13,6,6,21,21,27,27,11,11,3,3,4,4,29,29,0,0,14,14,28,28,2,2,16,16,25,25,12,12,28,28,9,9,28,28,18,18,5,5,4,4,0,0,14,14,16,16,27,27,8,8,29,29,8,8,5,5,21,21,14,14,24,24,5,5,1,1,5,5,9,9,7,7,6,6,19,19,27,27,11,11,14,14,29,29,13,13,15,15,18,18,3,3,0,0,16,16,21,21,13,13,16,16,26,26,1,1,22,22,27,27,12,12,18,18,23,23,14,14,1,1,24,24,27,27,1,1,14,14,22,22,6,6,17,17,3,3,3,3,26,26,16,16,28,28,27,27,25,25,24,24,3,3,11,11,28,28,15,15,20,20,12,12,4,4,17,17,0,0,15,15,7,7,23,23,0,0,30,30,12,12,23,23,21,21,2,2,29,29,1,1,26,26,10,10,22,22,14,14,19,19,2,2,2,2,19,19,19,19,16,16,4,4,1,1,8,8,0,0,30,30,1,1,16,16,28,28,9,9,7,7,25,25,11,11,23,23,2,2,1,1,14,14,10,10,31,31,5,5,22,22,14,14,1,1,0,0,1,1,2,2,22,22,31,31,31,31,16,16,30,30,21,21,15,15,12,12,20,20,30,30,28,28,11,11,14,14,25,25,11,11,24,24,4,4,27,27,18,18,26,26,11,11,18,18,30,30,20,20,26,26,21,21,5,5,31,31,0,0,0,0,8,8,0,0,31,31,23,23,10,10,17,17,24,24,4,4,26,26,4,4,5,5,12,12,24,24,5,5,8,8,2,2,29,29,1,1,8,8,20,20,30,30,25,25,18,18,1,1,3,3,21,21,27,27,0,0,8,8,9,9,23,23,25,25,18,18,5,5,27,27,16,16,3,3,13,13,16,16,22,22,17,17,5,5,5,5,11,11,6,6,2,2,3,3,1,1,31,31,18,18,10,10,31,31,0,0,4,4,31,31,12,12,22,22,16,16,18,18,30,30,3,3,21,21,26,26,15,15,9,9,16,16,4,4,4,4,13,13,2,2,24,24,16,16,0,0,28,28,23,23,23,23,22,22,6,6,21,21,26,26,8,8,3,3,21,21,23,23,9,9,29,29,8,8,23,23,7,7,18,18,9,9,18,18,18,18,23,23,20,20,8,8,26,26,24,24,26,26,0,0,30,30,30,30,14,14,10,10,18,18,14,14,14,14,8,8,25,25,10,10,23,23,5,5,23,23,12,12,27,27,3,3,0,0,26,26,19,19,11,11,3,3,16,16,24,24,17,17,9,9,18,18,1,1,0,0,22,22,18,18,6,6,19,19,18,18,4,4,8,8,3,3,10,10,19,19,6,6,13,13,24,24,20,20,15,15,0,0,18,18,1,1,26,26,2,2,17,17,5,5,0,0,0,0,28,28,17,17,31,31,19,19,1,1,26,26,25,25,8,8,10,10,9,9,24,24,23,23,18,18,14,14,5,5,11,11,5,5,12,12,12,12,3,3,0,0,27,27,16,16,22,22,26,26,9,9,25,25,1,1,25,25,0,0,23,23,31,31,13,13,27,27,26,26,21,21,14,14,8,8,16,16,21,21,22,22,24,24,22,22,9,9,2,2,25,25,18,18,25,25,21,21,11,11,28,28,17,17,17,17,29,29,13,13,30,30,21,21,5,5,11,11,6,6,0,0,18,18,3,3,0,0,26,26,17,17,8,8,14,14,25,25,18,18,0,0,10,10,2,2,23,23,4,4,30,30,0,0,26,26,16,16,18,18,8,8,11,11,15,15,4,4,29,29,24,24,18,18,17,17,8,8,24,24,11,11,27,27,9,9,24,24,28,28,12,12,0,0,22,22,20,20,1,1,8,8,28,28,8,8,3,3,19,19,15,15,11,11,6,6,3,3,5,5,20,20,5,5,22,22,3,3,7,7,3,3,0,0,5,5,6,6,14,14,17,17,18,18,14,14,20,20,13,13,4,4,19,19,30,30,16,16,26,26,11,11,16,16,1,1,28,28,1,1,8,8,17,17,24,24,5,5,25,25,22,22,12,12,16,16,26,26,18,18,24,24,4,4,6,6,7,7,2,2,8,8,2,2,12,12,29,29,22,22,28,28,18,18,5,5,24,24,26,26,6,6,4,4,11,11,24,24,24,24,15,15,5,5,17,17,19,19,25,25,9,9,9,9,11,11,28,28,13,13,13,13,12,12,15,15,9,9,14,14,14,14,24,24,0,0,4,4,9,9,6,6,0,0,28,28,5,5,15,15,7,7,25,25,29,29,23,23,16,16,18,18,28,28,7,7,12,12,5,5,31,31,2,2,14,14,9,9,28,28,11,11,1,1,0,0,20,20,0,0,11,11,22,22,23,23,16,16,22,22,16,16,14,14,25,25,13,13,4,4,19,19,15,15,26,26,21,21,11,11,26,26,28,28,29,29,28,28,16,16,2,2,3,3,6,6,27,27,30,30,10,10,2,2,3,3,2,2,30,30,9,9,6,6,2,2,29,29,24,24,20,20,26,26,0,0,13,13,31,31,11,11,28,28,6,6,31,31,31,31,21,21,5,5,16,16,10,10,5,5,6,6,11,11,18,18,11,11,11,11,1,1,11,11,27,27,28,28,4,4,28,28,28,28,4,4,26,26,5,5,3,3,29,29,7,7,10,10,3,3,20,20,7,7,12,12,25,25,0,0,24,24,31,31,9,9,11,11,22,22,17,17,7,7,17,17,18,18,6,6,25,25,1,1,24,24,28,28,17,17,27,27,9,9,23,23,16,16,18,18,19,19,16,16,3,3,26,26,20,20,21,21,27,27,17,17,20,20,26,26,3,3,29,29,22,22,20,20,9,9,25,25,8,8,26,26,12,12,31,31,12,12,21,21,6,6,17,17,14,14,14,14,27,27,12,12,29,29,22,22,28,28,2,2,28,28,6,6,2,2,2,2,3,3,5,5,21,21,15,15,29,29,2,2,19,19,5,5,22,22,29,29,5,5,9,9,16,16,18,18,16,16,23,23,15,15,15,15,19,19,30,30,11,11,6,6,7,7,6,6,28,28,21,21,4,4,14,14,22,22,2,2,24,24,31,31,5,5,23,23,26,26,30,30,1,1,12,12,11,11,19,19,6,6,20,20,14,14,5,5,12,12,3,3,28,28,7,7,28,28,6,6,3,3,21,21,20,20,5,5,8,8,7,7,21,21,0,0,17,17,2,2,26,26,16,16,21,21,18,18,7,7,28,28,28,28,13,13,0,0,13,13,19,19,17,17,18,18,17,17,17,17,19,19,0,0,4,4,0,0,3,3,7,7,24,24,10,10,22,22,31,31,13,13,8,8,16,16,12,12,14,14,11,11,10,10,16,16,13,13,12,12,6,6,8,8,24,24,9,9,7,7,28,28,23,23,11,11,18,18,4,4,14,14,7,7,24,24,19,19,12,12,10,10,26,26,14,14,14,14,10,10,15,15,15,15,8,8,9,9,1,1,1,1,1,1,29,29,24,24,18,18,30,30,22,22,9,9,30,30,3,3,18,18,10,10,20,20,23,23,20,20,29,29,6,6,16,16,10,10,2,2,1,1,10,10,15,15,12,12,23,23,26,26,30,30,21,21,15,15,13,13,15,15,9,9,8,8,24,24,27,27,12,12,15,15,8,8,3,3,12,12,3,3,21,21,12,12,5,5,14,14,17,17,5,5,25,25,28,28,12,12,3,3,16,16,27,27,1,1,13,13,29,29,6,6,29,29,22,22,25,25,31,31,7,7,20,20,21,21,18,18,19,19,26,26,16,16,0,0,22,22,15,15,3,3,5,5,3,3,2,2,29,29,18,18,5,5,31,31,10,10,12,12,10,10,14,14,19,19,20,20,17,17,5,5,18,18,12,12,26,26,12,12,29,29,22,22,21,21,26,26,18,18,1,1,18,18,23,23,7,7,19,19,14,14,25,25,11,11,8,8,9,9,19,19,13,13,2,2,17,17,19,19,7,7,27,27,10,10,8,8,21,21,7,7,5,5,26,26,1,1,27,27,20,20,10,10,14,14,3,3,8,8,7,7,3,3,20,20,22,22,31,31,12,12,30,30,30,30,18,18,20,20,29,29,31,31,27,27,28,28,24,24,6,6,17,17,17,17,11,11,20,20,1,1,29,29,24,24,7,7,10,10,29,29,4,4,27,27,10,10,25,25,1,1,28,28,5,5,17,17,23,23,25,25,9,9,1,1,24,24,27,27,14,14,4,4,23,23,4,4,0,0,14,14,13,13,0,0,26,26,27,27,27,27,20,20,23,23,10,10,7,7,18,18,0,0,12,12,0,0,6,6,16,16,9,9,26,26,23,23,28,28,20,20,4,4,22,22,7,7,7,7,28,28,1,1,3,3,3,3,0,0,7,7,7,7,3,3,10,10,10,10,13,13,0,0,18,18,7,7,7,7,2,2,13,13,1,1,23,23,29,29,26,26,13,13,11,11,16,16,11,11,8,8,11,11,17,17,1,1,1,1,29,29,28,28,16,16,25,25,26,26,17,17,26,26,30,30,6,6,20,20,17,17,11,11,0,0,9,9,25,25,0,0,13,13,31,31,27,27,25,25,12,12,19,19,19,19,9,9,2,2,7,7,20,20,7,7,15,15,15,15,29,29,26,26,18,18,17,17,5,5,4,4,29,29,22,22,21,21,25,25,8,8,2,2,3,3,10,10,22,22,18,18,28,28,2,2,26,26,28,28,2,2,16,16,6,6,30,30,31,31,8,8,10,10,8,8,12,12,19,19,1,1,3,3,12,12,20,20,11,11,15,15,13,13,0,0,2,2,16,16,21,21,8,8,27,27,6,6,29,29,28,28,11,11,24,24,29,29,22,22,7,7,8,8,27,27,29,29,17,17,3,3,20,20,25,25,28,28,5,5,10,10,11,11,21,21,4,4,22,22,25,25,29,29,21,21,8,8,24,24,30,30,1,1,30,30,22,22,26,26,21,21,11,11,14,14,4,4,11,11,1,1,3,3,4,4,0,0,5,5,4,4,14,14,8,8,5,5,24,24,14,14,2,2,17,17,6,6,10,10,19,19,27,27,2,2,5,5,20,20,22,22,24,24,27,27,19,19,3,3,12,12,31,31,5,5,15,15,14,14,18,18,15,15,14,14,26,26,5,5,16,16,16,16,20,20,11,11,29,29,11,11,1,1,7,7,30,30,0,0,10,10,8,8,16,16,22,22,16,16,22,22,27,27,11,11,18,18,9,9,20,20,8,8,0,0,21,21,29,29,8,8,14,14,22,22,24,24,25,25,20,20,18,18,0,0,23,23,30,30,4,4,8,8,0,0,26,26,9,9,11,11,6,6,31,31,10,10,17,17,25,25,25,25,5,5,24,24,5,5,7,7,28,28,5,5,14,14,2,2,29,29,16,16,15,15,28,28,28,28,11,11,6,6,27,27,2,2,5,5,19,19,4,4,19,19,28,28,8,8,2,2,18,18,31,31,0,0,8,8,0,0,17,17,18,18,7,7,13,13,24,24,7,7,13,13,17,17,20,20,17,17,13,13,26,26,16,16,16,16,25,25,27,27,24,24,28,28,4,4,16,16,5,5,4,4,14,14,11,11,29,29,13,13,30,30,10,10,11,11,14,14,6,6,19,19,20,20,26,26,30,30,0,0,14,14,13,13,0,0,4,4,21,21,0,0,11,11,25,25,16,16,25,25,3,3,20,20,31,31,29,29,7,7,1,1,0,0,7,7,1,1,7,7,23,23,31,31,2,2,8,8,7,7,24,24,2,2,11,11,18,18,13,13,22,22,20,20,14,14,17,17,27,27,14,14,16,16,15,15,23,23,0,0,2,2,4,4,14,14,26,26,14,14,19,19,21,21,16,16,28,28,15,15,1,1,25,25,16,16,6,6,25,25,13,13,28,28,0,0,9,9,22,22,0,0,2,2,9,9,8,8,4,4,13,13,4,4,24,24,10,10,7,7,5,5,5,5,18,18,7,7,10,10,12,12,11,11,12,12,11,11,30,30,7,7,29,29,27,27,12,12,8,8,4,4,25,25,4,4,5,5,17,17,20,20,2,2,10,10,14,14,11,11,3,3,12,12,17,17,21,21,5,5,31,31,11,11,8,8,25,25,20,20,24,24,19,19,16,16,23,23,0,0,17,17,20,20,1,1,25,25,12,12,16,16,12,12,6,6,9,9,5,5,20,20,8,8,19,19,2,2,1,1,21,21,0,0,30,30,15,15,24,24,31,31,29,29,24,24,16,16,31,31,8,8,9,9,6,6,29,29,14,14,9,9,3,3,10,10,15,15,16,16,8,8,28,28,25,25,26,26,0,0,11,11,30,30,9,9,0,0,18,18,23,23,0,0,28,28,29,29,22,22,10,10,1,1,21,21,0,0,15,15,17,17,27,27,29,29,6,6,26,26,5,5,9,9,12,12,19,19,16,16,17,17,3,3,7,7,6,6,20,20,18,18,3,3,13,13,10,10,20,20,11,11,8,8,15,15,5,5,5,5,13,13,27,27,21,21,27,27,22,22,2,2,30,30,2,2,5,5,26,26,4,4,29,29,5,5,25,25,19,19,18,18,8,8,11,11,3,3,20,20,31,31,20,20,29,29,26,26,14,14,8,8,30,30,3,3,22,22,24,24,2,2,8,8,15,15,19,19,28,28,31,31,2,2,6,6,8,8,19,19,30,30,18,18,6,6,4,4,26,26,13,13,19,19,19,19,6,6,19,19,8,8,29,29,4,4,3,3,22,22,3,3,31,31,0,0,0,0,3,3,24,24,22,22,31,31,4,4,6,6,30,30,5,5,5,5,30,30,29,29,4,4,6,6,11,11,27,27,25,25,4,4,19,19,16,16,10,10,11,11,13,13,22,22,25,25,22,22,17,17,24,24,11,11,24,24,7,7,13,13,16,16,17,17,28,28,26,26,5,5,26,26,14,14,12,12,19,19,25,25,24,24,11,11,6,6,6,6,21,21,11,11,16,16,13,13,8,8,6,6,9,9,5,5,10,10,10,10,1,1,27,27,30,30,16,16,25,25,6,6,9,9,27,27,13,13,5,5,7,7,0,0,14,14,26,26,21,21,30,30,30,30,11,11,24,24,7,7,4,4,27,27,28,28,16,16,2,2,6,6,5,5,21,21,2,2,0,0,31,31,13,13,10,10,28,28,24,24,14,14,4,4,13,13,0,0,23,23,19,19,28,28,0,0,29,29,22,22,2,2,12,12,15,15,27,27,1,1,19,19,0,0,5,5,10,10,19,19,25,25,21,21,4,4,1,1,9,9,0,0,19,19,29,29,7,7,10,10,24,24,1,1,31,31,10,10,9,9,9,9,9,9,18,18,1,1,3,3,16,16,29,29,20,20,14,14,9,9,15,15,11,11,7,7,25,25,25,25,2,2,12,12,10,10,15,15,21,21,18,18,7,7,7,7,20,20,31,31,25,25,4,4,28,28,21,21,4,4,18,18,17,17,22,22,27,27,16,16,15,15,9,9,24,24,5,5,25,25,8,8,7,7,7,7,27,27,4,4,1,1,19,19,9,9,10,10,1,1,23,23,5,5,10,10,25,25,21,21,12,12,24,24,0,0,21,21,2,2,9,9,16,16,1,1,7,7,24,24,8,8,3,3,23,23,29,29,1,1,19,19,5,5,21,21,2,2,28,28,2,2,0,0,31,31,10,10,6,6,23,23,10,10,1,1,5,5,25,25,19,19,5,5,1,1,20,20,8,8,18,18,25,25,24,24,31,31,15,15,13,13,17,17,11,11,31,31,4,4,6,6,23,23,3,3,2,2,17,17,23,23,20,20,10,10,4,4,24,24,30,30,26,26,9,9,3,3,29,29,7,7,3,3,24,24,3,3,29,29,27,27,27,27,4,4,26,26,1,1,13,13,25,25,6,6,13,13,24,24,26,26,1,1,20,20,18,18,1,1,6,6,18,18,24,24,13,13,28,28,16,16,25,25,17,17,14,14,6,6,1,1,23,23,4,4,27,27,25,25,10,10,1,1,23,23,8,8,4,4,8,8,4,4,26,26,19,19,13,13,6,6,25,25,2,2,6,6,29,29,1,1,6,6,29,29,24,24,3,3,29,29,6,6,29,29,17,17,17,17,19,19,1,1,18,18,6,6,5,5,18,18,1,1,0,0,13,13,5,5,5,5,22,22,10,10,27,27,12,12,20,20,21,21,0,0,0,0,5,5,27,27,19,19,11,11,2,2,31,31,17,17,13,13,14,14,8,8,6,6,15,15,18,18,16,16,30,30,2,2,13,13,18,18,14,14,31,31,8,8,25,25,24,24,17,17,23,23,4,4,18,18,16,16,25,25,14,14,16,16,9,9,20,20,13,13,13,13,17,17,17,17,7,7,22,22,12,12,8,8,19,19,12,12,29,29,2,2,14,14,4,4,28,28,3,3,30,30,30,30,3,3,19,19,21,21,4,4,28,28,6,6,25,25,29,29,4,4,9,9,26,26,11,11,19,19,26,26,27,27,24,24,25,25,30,30,25,25,15,15,19,19,21,21,9,9,31,31,27,27,27,27,18,18,23,23,16,16,31,31,14,14,18,18,28,28,14,14,4,4,23,23,12,12,5,5,23,23,0,0,12,12,4,4,31,31,5,5,6,6,5,5,28,28,17,17,24,24,29,29,25,25,17,17,27,27,14,14,10,10,26,26,9,9,11,11,14,14,24,24,8,8,30,30,28,28,30,30,20,20,7,7,21,21,15,15,29,29,8,8,29,29,20,20,7,7,10,10,27,27,5,5,2,2,29,29,3,3,2,2,26,26,16,16,3,3,5,5,23,23,28,28,11,11,1,1,22,22,3,3,15,15,3,3,27,27,17,17,16,16,7,7,27,27,22,22,14,14,15,15,21,21,12,12,19,19,4,4,5,5,5,5,12,12,12,12,10,10,15,15,5,5,11,11,30,30,29,29,16,16,15,15,7,7,18,18,20,20,3,3,12,12,18,18,12,12,11,11,4,4,30,30,11,11,12,12,12,12,16,16,2,2,17,17,17,17,31,31,1,1,12,12,8,8,17,17,3,3,19,19,14,14,16,16,28,28,26,26,23,23,30,30,19,19,2,2,14,14,29,29,9,9,20,20,13,13,3,3,31,31,4,4,23,23,2,2,9,9,20,20,28,28,0,0,17,17,23,23,9,9,6,6,20,20,21,21,5,5,16,16,19,19,30,30,14,14,27,27,4,4,16,16,26,26,11,11,25,25,22,22,23,23,1,1,23,23,16,16,19,19,3,3,10,10,26,26,21,21,7,7,15,15,4,4,15,15,8,8,3,3,8,8,15,15,2,2,5,5,28,28,15,15,29,29,24,24,29,29,25,25,8,8,23,23,0,0,14,14,2,2,19,19,19,19,0,0,3,3,3,3,26,26,5,5,2,2,5,5,22,22,29,29,20,20,7,7,17,17,18,18,26,26,23,23,8,8,22,22,18,18,17,17,14,14,11,11,12,12,1,1,15,15,18,18,14,14,13,13,13,13,26,26,11,11,12,12,16,16,20,20,26,26,10,10,30,30,8,8,2,2,13,13,31,31,17,17,4,4,8,8,29,29,11,11,25,25,15,15,21,21,12,12,14,14,7,7,3,3,21,21,0,0,12,12,14,14,17,17,16,16,14,14,21,21,2,2,9,9,5,5,3,3,14,14,23,23,18,18,26,26,11,11,25,25,5,5,28,28,11,11,11,11,7,7,22,22,27,27,26,26,21,21,8,8,4,4,25,25,28,28,16,16,9,9,20,20,19,19,20,20,4,4,11,11,30,30,12,12,2,2,26,26,5,5,24,24,21,21,5,5,19,19,24,24,25,25,21,21,21,21,23,23,22,22,18,18,10,10,20,20,8,8,30,30,19,19,5,5,5,5,25,25,14,14,5,5,16,16,24,24,8,8,20,20,6,6,25,25,20,20,21,21,15,15,19,19,1,1,27,27,27,27,14,14,2,2,13,13,4,4,1,1,30,30,8,8,5,5,14,14,24,24,31,31,9,9,18,18,15,15,5,5,13,13,19,19,29,29,7,7,18,18,13,13,24,24,3,3,21,21,28,28,24,24,23,23,0,0,21,21,5,5,26,26,8,8,30,30,4,4,13,13,8,8,26,26,28,28,24,24,14,14,7,7,2,2,16,16,16,16,12,12,24,24,10,10,0,0,1,1,11,11,13,13,13,13,28,28,2,2,5,5,25,25,6,6,30,30,13,13,25,25,18,18,16,16,4,4,18,18,4,4,24,24,3,3,30,30,26,26,11,11,24,24,5,5,22,22,15,15,18,18,13,13,14,14,10,10,10,10,0,0,10,10,16,16,30,30,0,0,8,8,30,30,11,11,9,9,17,17,19,19,1,1,1,1,29,29,21,21,13,13,2,2,27,27,28,28,13,13,13,13,2,2,21,21,25,25,21,21,19,19,5,5,18,18,0,0,16,16,11,11,2,2,3,3,18,18,7,7,16,16,11,11,14,14,10,10,16,16,2,2,23,23,21,21,9,9,15,15,8,8,29,29,11,11,15,15,20,20,25,25,30,30,0,0,10,10,16,16,20,20,9,9,7,7,1,1,2,2,18,18,24,24,6,6,24,24,15,15,9,9,6,6,17,17,17,17,27,27,16,16,8,8,16,16,29,29,25,25,7,7,27,27,29,29,8,8,23,23,20,20,11,11,28,28,1,1,30,30,27,27,25,25,16,16,26,26,12,12,14,14,27,27,9,9,16,16,24,24,23,23,24,24,10,10,11,11,12,12,9,9,19,19,30,30,1,1,28,28,26,26,1,1,19,19,18,18,15,15,27,27,12,12,14,14,1,1,29,29,19,19,7,7,8,8,6,6,18,18,30,30,7,7,24,24,22,22,24,24,7,7,6,6,6,6,1,1,0,0,6,6,30,30,0,0,23,23,4,4,28,28,12,12,12,12,20,20,18,18,13,13,9,9,2,2,9,9,5,5,11,11,2,2,30,30,11,11,15,15,19,19,22,22,3,3,29,29,31,31,14,14,30,30,0,0,2,2,4,4,24,24,13,13,27,27,12,12,15,15,28,28,1,1,10,10,27,27,2,2,7,7,17,17,16,16,5,5,3,3,21,21,16,16,17,17,8,8,0,0,20,20,22,22,9,9,11,11,19,19,29,29,20,20,14,14,9,9,31,31,12,12,18,18,25,25,14,14,18,18,7,7,22,22,1,1,25,25,9,9,27,27,18,18,31,31,31,31,27,27,20,20,23,23,5,5,27,27,17,17,6,6,13,13,13,13,25,25,21,21,12,12,18,18,20,20,25,25,22,22,13,13,26,26,23,23,26,26,20,20,13,13,30,30,14,14,3,3,7,7,0,0,9,9,28,28,29,29,25,25,3,3,22,22,0,0,24,24,27,27,29,29,15,15,30,30,12,12,22,22,26,26,28,28,8,8,26,26,23,23,15,15,1,1,17,17,11,11,8,8,24,24,30,30,0,0,29,29,10,10,20,20,0,0,21,21,1,1,1,1,21,21,28,28,17,17,8,8,0,0,20,20,10,10,29,29,6,6,15,15,16,16,19,19,27,27,10,10,17,17,9,9,28,28,1,1,26,26,25,25,14,14,5,5,15,15,13,13,22,22,28,28,2,2,3,3,5,5,13,13,25,25,19,19,12,12,26,26,18,18,13,13,11,11,3,3,17,17,16,16,31,31,16,16,29,29,26,26,27,27,30,30,12,12,8,8,24,24,22,22,28,28,18,18,0,0,4,4,13,13,25,25,30,30,5,5,12,12,11,11,26,26,28,28,29,29,8,8,21,21,11,11,3,3,22,22,31,31,2,2,14,14,9,9,0,0,20,20,6,6,22,22,10,10,10,10,17,17,18,18,27,27,26,26,4,4,1,1,16,16,20,20,9,9,14,14,9,9,0,0,23,23,26,26,28,28,20,20,17,17,16,16,9,9,4,4,13,13,28,28,3,3,25,25,18,18,17,17,3,3,15,15,29,29,26,26,6,6,11,11,15,15,5,5,17,17,24,24,26,26,20,20,13,13,12,12,2,2,13,13,5,5,3,3,3,3,0,0,31,31,1,1,24,24,26,26,15,15,30,30,27,27,9,9,18,18,13,13,24,24,7,7,26,26,10,10,30,30,7,7,8,8,22,22,30,30,4,4,7,7,5,5,13,13,17,17,1,1,18,18,10,10,0,0,12,12,23,23,14,14,6,6,8,8,29,29,11,11,30,30,21,21,13,13,14,14,18,18,31,31,7,7,14,14,6,6,12,12,4,4,2,2,30,30,12,12,17,17,26,26,12,12,30,30,25,25,23,23,25,25,28,28,20,20,3,3,30,30,18,18,28,28,10,10,7,7,14,14,30,30,1,1,18,18,10,10,12,12,18,18,12,12,25,25,2,2,24,24,18,18,5,5,20,20,20,20,17,17,6,6,26,26,3,3,12,12,16,16,19,19,0,0,9,9,13,13,19,19,26,26,25,25,4,4,19,19,4,4,6,6,4,4,15,15,6,6,3,3,4,4,18,18,0,0,9,9,30,30,24,24,18,18,2,2,30,30,20,20,6,6,12,12,0,0,4,4,5,5,20,20,15,15,5,5,16,16,6,6,13,13,1,1,28,28,1,1,22,22,22,22,19,19,7,7,30,30,5,5,26,26,31,31,1,1,19,19,26,26,12,12,7,7,13,13,25,25,24,24,31,31,3,3,8,8,12,12,13,13,3,3,12,12,23,23,22,22,3,3,20,20,18,18,31,31,18,18,31,31,9,9,0,0,13,13,8,8,14,14,6,6,4,4,22,22,9,9,30,30,23,23,17,17,16,16,17,17,14,14,8,8,10,10,15,15,28,28,19,19,14,14,11,11,10,10,25,25,11,11,21,21,8,8,26,26,31,31,9,9,12,12,25,25,6,6,31,31,14,14,16,16,9,9,23,23,4,4,22,22,0,0,5,5,25,25,1,1,28,28,20,20,23,23,18,18,0,0,29,29,4,4,14,14,5,5,14,14,25,25,28,28,5,5,3,3,22,22,9,9,29,29,5,5,23,23,16,16,1,1,6,6,1,1,5,5,9,9,20,20,10,10,10,10,25,25,2,2,26,26,7,7,0,0,30,30,25,25,4,4,11,11,14,14,29,29,14,14,13,13,1,1,8,8,8,8,13,13,4,4,1,1,19,19,11,11,5,5,29,29,22,22,28,28,23,23,11,11,26,26,5,5,15,15,17,17,14,14,13,13,29,29,28,28,3,3,25,25,9,9,22,22,10,10,2,2,2,2,2,2,18,18,1,1,12,12,12,12,10,10,16,16,26,26,10,10,27,27,7,7,31,31,14,14,20,20,20,20,8,8,17,17,8,8,29,29,17,17,5,5,11,11,16,16,16,16,26,26,30,30,8,8,28,28,31,31,17,17,16,16,5,5,24,24,26,26,2,2,5,5,11,11,5,5,11,11,6,6,31,31,6,6,18,18,14,14,14,14,10,10,11,11,11,11,28,28,22,22,3,3,23,23,18,18,9,9,0,0,0,0,12,12,8,8,3,3,13,13,1,1,27,27,10,10,19,19,27,27,22,22,7,7,26,26,7,7,27,27,26,26,19,19,3,3,24,24,8,8,30,30,9,9,4,4,14,14,3,3,5,5,18,18,25,25,5,5,17,17,26,26,6,6,28,28,2,2,19,19,27,27,18,18,17,17,12,12,20,20,19,19,10,10,10,10,2,2,8,8,29,29,29,29,21,21,26,26,8,8,17,17,11,11,1,1,18,18,11,11,10,10,28,28,25,25,5,5,13,13,8,8,7,7,18,18,17,17,31,31,2,2,29,29,15,15,29,29,16,16,18,18,16,16,17,17,7,7,19,19,5,5,13,13,14,14,2,2,18,18,9,9,6,6,1,1,2,2,13,13,20,20,17,17,0,0,3,3,30,30,21,21,9,9,17,17,13,13,8,8,24,24,6,6,2,2,21,21,2,2,18,18,0,0,25,25,5,5,11,11,18,18,16,16,26,26,26,26,26,26,17,17,10,10,24,24,18,18,0,0,15,15,12,12,30,30,26,26,29,29,20,20,31,31,17,17,21,21,14,14,9,9,17,17,12,12,0,0,15,15,26,26,19,19,10,10,7,7,3,3,4,4,25,25,8,8,26,26,11,11,17,17,1,1,31,31,12,12,15,15,21,21,2,2,0,0,30,30,14,14,3,3,25,25,8,8,16,16,5,5,31,31,4,4,22,22,30,30,10,10,27,27,25,25,24,24,10,10,18,18,19,19,19,19,5,5,17,17,14,14,30,30,10,10,23,23,20,20,9,9,14,14,15,15,13,13,13,13,8,8,11,11,10,10,1,1,21,21,9,9,22,22,24,24,25,25,3,3,16,16,21,21,26,26,19,19,0,0,20,20,10,10,2,2,23,23,2,2,6,6,19,19,0,0,4,4,4,4,3,3,7,7,19,19,13,13,20,20,17,17,15,15,11,11,30,30,23,23,21,21,26,26,2,2,9,9,15,15,28,28,28,28,26,26,28,28,26,26,20,20,20,20,1,1,10,10,17,17,7,7,23,23,13,13,2,2,29,29,2,2,1,1,22,22,0,0,9,9,9,9,31,31,18,18,12,12,21,21,28,28,14,14,8,8,8,8,30,30,28,28,24,24,24,24,9,9,29,29,29,29,27,27,28,28,0,0,15,15,16,16,2,2,8,8,17,17,31,31,8,8,31,31,20,20,0,0,7,7,7,7,27,27,1,1,28,28,24,24,16,16,25,25,24,24,28,28,23,23,0,0,18,18,22,22,7,7,31,31,9,9,13,13,24,24,17,17,17,17,15,15,27,27,25,25,29,29,26,26,6,6,5,5,28,28,0,0,1,1,2,2,27,27,19,19,24,24,4,4,5,5,28,28,1,1,4,4,13,13,1,1,18,18,10,10,7,7,16,16,6,6,28,28,9,9,24,24,19,19,20,20,5,5,14,14,27,27,25,25,3,3,24,24,18,18,25,25,11,11,24,24,4,4,14,14,30,30,17,17,8,8,11,11,22,22,1,1,21,21,11,11,2,2,14,14,24,24,26,26,8,8,12,12,30,30,6,6,5,5,23,23,26,26,21,21,5,5,29,29,21,21,28,28,18,18,23,23,16,16,31,31,9,9,1,1,20,20,4,4,4,4,23,23,19,19,4,4,4,4,25,25,25,25,24,24,31,31,10,10,0,0,25,25,13,13,30,30,26,26,5,5,5,5,15,15,28,28,16,16,19,19,23,23,12,12,14,14,29,29,21,21,22,22,6,6,29,29,23,23,26,26,16,16,19,19,5,5,15,15,23,23,26,26,8,8,12,12,22,22,21,21,13,13,6,6,13,13,0,0,26,26,31,31,22,22,9,9,8,8,6,6,4,4,16,16,7,7,14,14,7,7,27,27,7,7,14,14,25,25,11,11,16,16,10,10,12,12,23,23,4,4,15,15,4,4,16,16,23,23,0,0,16,16,16,16,5,5,22,22,10,10,22,22,10,10,4,4,12,12,3,3,30,30,13,13,20,20,12,12,17,17,8,8,18,18,13,13,12,12,29,29,22,22,28,28,11,11,26,26,11,11,11,11,20,20,16,16,16,16,1,1,22,22,12,12,9,9,4,4,16,16,29,29,10,10,28,28,13,13,6,6,8,8,21,21,19,19,16,16,9,9,16,16,29,29,9,9,19,19,25,25,27,27,0,0,22,22,3,3,27,27,15,15,5,5,2,2,29,29,8,8,4,4,8,8,26,26,6,6,28,28,20,20,31,31,6,6,8,8,1,1,22,22,23,23,25,25,0,0,21,21,12,12,18,18,0,0,11,11,12,12,10,10,29,29,8,8,27,27,18,18,9,9,23,23,16,16,10,10,0,0,20,20,17,17,20,20,18,18,31,31,23,23,17,17,8,8,20,20,22,22,29,29,17,17,17,17,3,3,2,2,23,23,9,9,2,2,5,5,11,11,28,28,16,16,19,19,27,27,17,17,5,5,22,22,16,16,0,0,30,30,29,29,2,2,5,5,28,28,15,15,6,6,4,4,14,14,8,8,16,16,26,26,19,19,12,12,22,22,17,17,29,29,7,7,20,20,18,18,8,8,3,3,26,26,30,30,16,16,28,28,15,15,8,8,0,0,16,16,12,12,10,10,9,9,27,27,25,25,9,9,18,18,0,0,5,5,2,2,25,25,11,11,6,6,0,0,5,5,16,16,1,1,12,12,6,6,27,27,17,17,26,26,10,10,15,15,30,30,3,3,11,11,11,11,11,11,15,15,26,26,5,5,30,30,12,12,11,11,9,9,25,25,0,0,17,17,20,20,22,22,4,4,27,27,31,31,26,26,7,7,16,16,4,4,9,9,8,8,22,22,23,23,5,5,13,13,2,2,14,14,19,19,16,16,11,11,30,30,16,16,29,29,31,31,2,2,22,22,11,11,31,31,30,30,12,12,14,14,8,8,31,31,24,24,1,1,18,18,11,11,27,27,14,14,23,23,9,9,3,3,30,30,17,17,31,31,5,5,1,1,31,31,19,19,17,17,9,9,25,25,13,13,27,27,24,24,9,9,17,17,30,30,24,24,8,8,18,18,20,20,7,7,6,6,16,16,11,11,15,15,29,29,21,21,12,12,6,6,20,20,17,17,7,7,1,1,7,7,30,30,20,20,11,11,12,12,17,17,1,1,30,30,28,28,26,26,4,4,29,29,2,2,16,16,5,5,14,14,22,22,21,21,16,16,0,0,22,22,21,21,7,7,19,19,8,8,6,6,28,28,29,29,14,14,29,29,2,2,7,7,27,27,17,17,31,31,10,10,13,13,13,13,28,28,29,29,8,8,3,3,1,1,5,5,28,28,23,23,0,0,20,20,4,4,27,27,4,4,15,15,4,4,18,18,29,29,8,8,3,3,3,3,10,10,21,21,5,5,9,9,26,26,9,9,19,19,25,25,0,0,15,15,12,12,27,27,27,27,19,19,10,10,20,20,3,3,17,17,10,10,28,28,2,2,27,27,2,2,17,17,30,30,5,5,16,16,21,21,5,5,19,19,27,27,25,25,24,24,18,18,27,27,22,22,12,12,1,1,28,28,26,26,4,4,28,28,20,20,6,6,6,6,20,20,30,30,29,29,20,20,18,18,25,25,26,26,15,15,31,31,9,9,25,25,22,22,0,0,7,7,12,12,5,5,16,16,19,19,22,22,25,25,26,26,16,16,19,19,11,11,30,30,7,7,1,1,1,1,30,30,8,8,4,4,4,4,13,13,12,12,5,5,18,18,24,24,5,5,26,26,9,9,31,31,7,7,17,17,6,6,3,3,3,3,16,16,9,9,16,16,15,15,10,10,22,22,5,5,15,15,19,19,24,24,14,14,6,6,2,2,10,10,25,25,1,1,10,10,18,18,31,31,9,9,9,9,11,11,24,24,25,25,26,26,25,25,22,22,21,21,22,22,17,17,18,18,25,25,15,15,9,9,28,28,17,17,25,25,1,1,5,5,11,11,20,20,2,2,26,26,31,31,8,8,6,6,0,0,26,26,15,15,31,31,28,28,26,26,4,4,30,30,26,26,24,24,10,10,11,11,0,0,13,13,0,0,1,1,2,2,27,27,7,7,4,4,5,5,3,3,16,16,5,5,0,0,7,7,4,4,14,14,24,24,6,6,30,30,29,29,31,31,15,15,12,12,30,30,8,8,11,11,26,26,5,5,16,16,19,19,9,9,25,25,6,6,0,0,5,5,20,20,17,17,5,5,31,31,27,27,21,21,11,11,3,3,26,26,21,21,30,30,16,16,14,14,16,16,21,21,21,21,19,19,0,0,27,27,3,3,28,28,20,20,13,13,20,20,10,10,2,2,23,23,28,28,2,2,3,3,17,17,9,9,13,13,18,18,1,1,24,24,20,20,24,24,5,5,21,21,21,21,6,6,24,24,30,30,17,17,12,12,17,17,8,8,28,28,26,26,26,26,5,5,31,31,19,19,16,16,29,29,17,17,0,0,5,5,29,29,26,26,25,25,18,18,29,29,14,14,23,23,22,22,4,4,3,3,3,3,16,16,28,28,5,5,13,13,0,0,11,11,8,8,6,6,31,31,8,8,4,4,29,29,0,0,13,13,22,22,25,25,24,24,4,4,14,14,14,14,22,22,19,19,8,8,18,18,6,6,9,9,18,18,0,0,9,9,19,19,14,14,24,24,26,26,10,10,10,10,0,0,16,16,6,6,19,19,31,31,19,19,11,11,20,20,22,22,9,9,5,5,18,18,19,19,7,7,1,1,2,2,27,27,9,9,8,8,28,28,30,30,12,12,5,5,26,26,21,21,0,0,1,1,23,23,17,17,24,24,12,12,11,11,28,28,4,4,11,11,28,28,14,14,4,4,9,9,7,7,11,11,23,23,10,10,20,20,8,8,1,1,17,17,28,28,3,3,5,5,2,2,21,21,13,13,2,2,28,28,25,25,18,18,22,22,7,7,20,20,2,2,29,29,12,12,25,25,14,14,12,12,24,24,22,22,18,18,3,3,9,9,15,15,13,13,17,17,21,21,11,11,23,23,25,25,26,26,4,4,25,25,3,3,11,11,8,8,17,17,27,27,8,8,20,20,14,14,28,28,20,20,18,18,7,7,14,14,3,3,6,6,23,23,5,5,15,15,31,31,20,20,16,16,0,0,23,23,0,0,12,12,23,23,5,5,9,9,18,18,0,0,11,11,19,19,2,2,26,26,7,7,13,13,26,26,7,7,3,3,7,7,28,28,26,26,8,8,23,23,4,4,7,7,29,29,26,26,18,18,5,5,5,5,0,0,16,16,29,29,31,31,11,11,14,14,3,3,31,31,18,18,4,4,19,19,11,11,7,7,23,23,2,2,8,8,4,4,7,7,11,11,17,17,2,2,23,23,2,2,20,20,18,18,0,0,5,5,17,17,1,1,16,16,11,11,1,1,29,29,11,11,12,12,19,19,18,18,19,19,3,3,14,14,23,23,21,21,6,6,1,1,8,8,8,8,14,14,13,13,0,0,11,11,20,20,26,26,16,16,25,25,0,0,3,3,5,5,16,16,6,6,0,0,30,30,19,19,22,22,16,16,17,17,6,6,3,3,2,2,13,13,19,19,0,0,10,10,2,2,20,20,1,1,21,21,16,16,4,4,16,16,6,6,0,0,17,17,0,0,10,10,5,5,3,3,18,18,18,18,0,0,17,17,24,24,0,0,13,13,17,17,13,13,24,24,0,0,2,2,14,14,10,10,4,4,9,9,24,24,7,7,17,17,7,7,1,1,4,4,7,7,29,29,18,18,23,23,27,27,17,17,0,0,19,19,11,11,4,4,23,23,5,5,24,24,29,29,30,30,19,19,27,27,23,23,2,2,29,29,14,14,29,29,6,6,25,25,9,9,17,17,18,18,16,16,25,25,1,1,2,2,15,15,3,3,16,16,13,13,24,24,23,23,21,21,30,30,25,25,0,0,14,14,5,5,23,23,15,15,31,31,7,7,18,18,29,29,1,1,11,11,31,31,16,16,2,2,30,30,15,15,2,2,4,4,3,3,18,18,8,8,30,30,16,16,1,1,12,12,24,24,7,7,9,9,16,16,16,16,18,18,14,14,6,6,31,31,22,22,24,24,19,19,18,18,20,20,21,21,4,4,9,9,30,30,6,6,10,10,18,18,3,3,18,18,28,28,13,13,19,19,25,25,2,2,23,23,9,9,13,13,4,4,29,29,7,7,24,24,1,1,28,28,26,26,16,16,2,2,17,17,24,24,9,9,18,18,15,15,25,25,21,21,2,2,17,17,18,18,14,14,31,31,4,4,22,22,0,0,20,20,6,6,3,3,16,16,25,25,1,1,23,23,9,9,18,18,12,12,16,16,16,16,14,14,25,25,27,27,13,13,8,8,9,9,14,14,12,12,10,10,25,25,0,0,9,9,21,21,27,27,14,14,3,3,24,24,2,2,0,0,24,24,17,17,8,8,12,12,12,12,13,13,11,11,1,1,0,0,20,20,8,8,25,25,21,21,23,23,30,30,18,18,27,27,12,12,4,4,11,11,5,5,9,9,31,31,29,29,30,30,25,25,12,12,8,8,29,29,2,2,0,0,24,24,14,14,23,23,3,3,0,0,18,18,12,12,2,2,1,1,26,26,18,18,0,0,5,5,12,12,24,24,9,9,9,9,16,16,18,18,25,25,2,2,31,31,5,5,16,16,31,31,16,16,30,30,4,4,30,30,24,24,10,10,13,13,29,29,17,17,9,9,24,24,22,22,25,25,3,3,28,28,18,18,0,0,16,16,15,15,25,25,18,18,13,13,25,25,17,17,12,12,10,10,16,16,21,21,23,23,16,16,8,8,5,5,2,2,13,13,1,1,4,4,1,1,2,2,18,18,23,23,2,2,9,9,20,20,22,22,16,16,13,13,4,4,5,5,3,3,10,10,30,30,23,23,21,21,20,20,31,31,1,1,17,17,7,7,28,28,31,31,28,28,27,27,1,1,24,24,31,31,20,20,4,4,22,22,0,0,5,5,12,12,21,21,25,25,25,25,4,4,19,19,18,18,13,13,2,2,26,26,16,16,6,6,26,26,29,29,30,30,31,31,23,23,26,26,2,2,4,4,26,26,18,18,10,10,23,23,21,21,1,1,26,26,31,31,19,19,7,7,18,18,18,18,2,2,6,6,17,17,17,17,1,1,5,5,9,9,17,17,28,28,29,29,19,19,2,2,0,0,31,31,9,9,14,14,18,18,4,4,11,11,19,19,25,25,11,11,20,20,24,24,31,31,11,11,17,17,28,28,14,14,24,24,0,0,23,23,23,23,13,13,12,12,13,13,31,31,8,8,7,7,5,5,2,2,6,6,0,0,5,5,18,18,30,30,31,31,21,21,0,0,15,15,22,22,17,17,4,4,12,12,16,16,3,3,11,11,11,11,6,6,28,28,26,26,6,6,15,15,12,12,11,11,13,13,2,2,8,8,24,24,11,11,31,31,17,17,27,27,14,14,0,0,10,10,28,28,27,27,1,1,2,2,1,1,16,16,29,29,4,4,20,20,5,5,12,12,29,29,6,6,23,23,2,2,24,24,0,0,28,28,30,30,18,18,18,18,30,30,21,21,12,12,11,11,9,9,17,17,17,17,28,28,14,14,11,11,6,6,18,18,0,0,19,19,9,9,12,12,26,26,6,6,22,22,24,24,4,4,8,8,24,24,8,8,1,1,20,20,26,26,21,21,29,29,18,18,21,21,3,3,14,14,1,1,18,18,18,18,14,14,0,0,18,18,17,17,20,20,3,3,6,6,26,26,16,16,16,16,29,29,16,16,1,1,5,5,19,19,14,14,1,1,10,10,18,18,31,31,18,18,4,4,6,6,23,23,7,7,6,6,28,28,19,19,6,6,6,6,14,14,5,5,12,12,2,2,8,8,20,20,8,8,5,5,4,4,18,18,2,2,21,21,4,4,13,13,5,5,4,4,2,2,11,11,17,17,8,8,3,3,23,23,14,14,15,15,18,18,13,13,17,17,25,25,14,14,10,10,5,5,10,10,18,18,2,2,23,23,1,1,23,23,28,28,31,31,13,13,6,6,8,8,27,27,3,3,19,19,4,4,5,5,14,14,26,26,0,0,9,9,0,0,11,11,16,16,11,11,30,30,4,4,18,18,5,5,20,20,27,27,27,27,19,19,0,0,8,8,24,24,12,12,3,3,10,10,9,9,11,11,25,25,3,3,2,2,27,27,27,27,16,16,21,21,25,25,20,20,28,28,26,26,12,12,19,19,13,13,17,17,9,9,2,2,24,24,17,17,16,16,17,17,11,11,23,23,13,13,5,5,24,24,16,16,10,10,22,22,15,15,20,20,12,12,14,14,1,1,10,10,7,7,7,7,27,27,6,6,11,11,17,17,23,23,4,4,29,29,18,18,11,11,9,9,1,1,7,7,15,15,19,19,1,1,4,4,7,7,8,8,13,13,3,3,3,3,6,6,10,10,18,18,1,1,15,15,24,24,15,15,9,9,29,29,25,25,0,0,1,1,13,13,2,2,4,4,25,25,15,15,1,1,27,27,1,1,10,10,29,29,7,7,19,19,23,23,1,1,21,21,0,0,11,11,30,30,17,17,23,23,26,26,29,29,17,17,5,5,9,9,17,17,30,30,2,2,4,4,5,5,0,0,5,5,6,6,0,0,12,12,15,15,28,28,23,23,2,2,5,5,16,16,3,3,18,18,1,1,1,1,22,22,29,29,23,23,8,8,31,31,7,7,17,17,29,29,19,19,4,4,10,10,9,9,17,17,16,16,19,19,26,26,9,9,25,25,16,16,21,21,0,0,6,6,3,3,18,18,18,18,19,19,21,21,13,13,26,26,3,3,6,6,2,2,9,9,1,1,19,19,23,23,21,21,16,16,8,8,21,21,5,5,11,11,4,4,1,1,7,7,14,14,2,2,25,25,18,18,10,10,7,7,24,24,17,17,11,11,27,27,3,3,12,12,29,29,13,13,21,21,20,20,27,27,28,28,13,13,6,6,7,7,18,18,13,13,18,18,27,27,16,16,3,3,3,3,1,1,21,21,4,4,4,4,25,25,18,18,25,25,25,25,26,26,4,4,22,22,13,13,11,11,2,2,27,27,22,22,7,7,18,18,26,26,27,27,6,6,6,6,4,4,24,24,28,28,16,16,5,5,0,0,27,27,29,29,16,16,19,19,10,10,31,31,17,17,2,2,17,17,17,17,10,10,31,31,10,10,18,18,6,6,0,0,6,6,28,28,14,14,23,23,8,8,15,15,2,2,17,17,31,31,26,26,14,14,6,6,27,27,30,30,2,2,0,0,15,15,21,21,21,21,20,20,10,10,15,15,23,23,18,18,17,17,6,6,23,23,1,1,25,25,29,29,14,14,1,1,24,24,25,25,26,26,16,16,10,10,25,25,15,15,13,13,20,20,1,1,10,10,12,12,1,1,13,13,4,4,11,11,4,4,2,2,10,10,14,14,7,7,11,11,17,17,5,5,5,5,1,1,19,19,27,27,3,3,26,26,0,0,8,8,28,28,25,25,13,13,17,17,22,22,16,16,8,8,31,31,11,11,19,19,31,31,19,19,12,12,21,21,19,19,7,7,15,15,22,22,8,8,19,19,24,24,19,19,13,13,18,18,0,0,19,19,7,7,28,28,2,2,7,7,20,20,3,3,12,12,15,15,10,10,15,15,18,18,20,20,28,28,0,0,9,9,30,30,26,26,19,19,12,12,24,24,3,3,8,8,26,26,0,0,10,10,4,4,14,14,3,3,13,13,22,22,8,8,1,1,20,20,5,5,31,31,13,13,18,18,5,5,4,4,27,27,24,24,20,20,14,14,8,8,30,30,25,25,21,21,18,18,10,10,6,6,30,30,3,3,1,1,14,14,0,0,24,24,4,4,21,21,18,18,22,22,13,13,13,13,19,19,29,29,6,6,14,14,12,12,23,23,29,29,14,14,25,25,10,10,2,2,11,11,25,25,15,15,22,22,6,6,15,15,21,21,25,25,28,28,17,17,26,26,29,29,14,14,24,24,24,24,24,24,14,14,4,4,0,0,15,15,19,19,1,1,14,14,21,21,15,15,18,18,30,30,12,12,2,2,12,12,30,30,21,21,29,29,16,16,5,5,28,28,17,17,24,24,1,1,2,2,22,22,8,8,16,16,20,20,4,4,16,16,17,17,8,8,31,31,1,1,13,13,6,6,19,19,24,24,30,30,9,9,8,8,1,1,12,12,18,18,31,31,23,23,26,26,2,2,3,3,4,4,16,16,0,0,14,14,1,1,31,31,12,12,12,12,12,12,16,16,19,19,5,5,20,20,30,30,0,0,12,12,7,7,14,14,0,0,0,0,23,23,28,28,17,17,15,15,30,30,0,0,26,26,22,22,20,20,26,26,6,6,18,18,2,2,8,8,17,17,13,13,9,9,8,8,23,23,8,8,12,12,0,0,24,24,0,0,20,20,12,12,14,14,22,22,29,29,3,3,9,9,17,17,9,9,23,23,15,15,3,3,9,9,5,5,2,2,2,2,14,14,6,6,11,11,17,17,18,18,17,17,0,0,30,30,15,15,18,18,11,11,6,6,30,30,20,20,5,5,16,16,30,30,22,22,16,16,17,17,13,13,16,16,20,20,16,16,23,23,9,9,0,0,3,3,17,17,11,11,15,15,1,1,17,17,20,20,28,28,9,9,26,26,14,14,9,9,18,18,17,17,8,8,31,31,13,13,1,1,23,23,4,4,15,15,1,1,11,11,19,19,1,1,18,18,22,22,8,8,12,12,22,22,31,31,14,14,18,18,17,17,24,24,28,28,20,20,28,28,3,3,14,14,18,18,0,0,24,24,3,3,19,19,21,21,2,2,22,22,0,0,0,0,16,16,5,5,6,6,24,24,22,22,18,18,27,27,5,5,10,10,3,3,15,15,7,7,30,30,30,30,4,4,18,18,22,22,19,19,0,0,13,13,16,16,12,12,13,13,24,24,31,31,26,26,12,12,5,5,14,14,26,26,1,1,29,29,0,0,11,11,7,7,28,28,17,17,8,8,11,11,0,0,10,10,6,6,20,20,3,3,30,30,14,14,3,3,15,15,24,24,20,20,15,15,14,14,11,11,28,28,14,14,4,4,10,10,9,9,14,14,2,2,8,8,10,10,9,9,31,31,19,19,7,7,27,27,29,29,4,4,12,12,0,0,12,12,21,21,12,12,29,29,7,7,15,15,31,31,11,11,28,28,8,8,20,20,13,13,20,20,29,29,27,27,4,4,20,20,17,17,6,6,13,13,20,20,24,24,11,11,29,29,29,29,5,5,5,5,9,9,11,11,17,17,28,28,11,11,9,9,23,23,27,27,31,31,5,5,9,9,25,25,11,11,30,30,5,5,1,1,11,11,17,17,14,14,10,10,17,17,11,11,17,17,14,14,17,17,31,31,15,15,15,15,23,23,28,28,23,23,9,9,31,31,13,13,14,14,21,21,20,20,30,30,31,31,9,9,15,15,17,17,4,4,0,0,23,23,31,31,31,31,21,21,11,11,23,23,22,22,25,25,26,26,23,23,11,11,0,0,0,0,27,27,27,27,5,5,29,29,19,19,30,30,30,30,0,0,10,10,7,7,19,19,0,0,13,13,20,20,9,9,15,15,9,9,10,10,17,17,15,15,22,22,13,13,0,0,14,14,4,4,14,14,4,4,29,29,23,23,24,24,13,13,31,31,28,28,30,30,1,1,14,14,28,28,19,19,16,16,16,16,19,19,17,17,4,4,0,0,26,26,22,22,1,1,24,24,27,27,28,28,10,10,2,2,19,19,0,0,11,11,6,6,22,22,12,12,22,22,9,9,21,21,6,6,15,15,17,17,22,22,12,12,15,15,13,13,1,1,7,7,3,3,24,24,31,31,10,10,28,28,23,23,16,16,26,26,27,27,9,9,8,8,10,10,21,21,22,22,7,7,7,7,1,1,19,19,30,30,2,2,0,0,22,22,30,30,15,15,10,10,10,10,14,14,23,23,12,12,0,0,9,9,27,27,21,21,31,31,13,13,0,0,9,9,4,4,24,24,1,1,8,8,19,19,18,18,26,26,9,9,20,20,1,1,12,12,17,17,30,30,3,3,9,9,14,14,28,28,17,17,3,3,27,27,30,30,15,15,12,12,0,0,8,8,6,6,23,23,19,19,23,23,20,20,3,3,21,21,16,16,8,8,5,5,26,26,7,7,26,26,29,29,28,28,30,30,14,14,23,23,23,23,15,15,24,24,30,30,9,9,30,30,11,11,8,8,5,5,19,19,21,21,4,4,15,15,31,31,2,2,0,0,19,19,22,22,26,26,26,26,9,9,22,22,15,15,5,5,18,18,24,24,5,5,18,18,26,26,5,5,12,12,2,2,7,7,27,27,6,6,30,30,21,21,22,22,10,10,29,29,19,19,5,5,30,30,19,19,14,14,4,4,8,8,9,9,1,1,25,25,16,16,12,12,19,19,0,0,6,6,1,1,5,5,8,8,20,20,1,1,10,10,24,24,4,4,19,19,19,19,24,24,7,7,20,20,1,1,3,3,15,15,27,27,27,27,0,0,8,8,29,29,24,24,16,16,30,30,4,4,2,2,5,5,31,31,27,27,6,6,10,10,1,1,16,16,17,17,27,27,17,17,6,6,21,21,8,8,28,28,24,24,11,11,18,18,31,31,18,18,16,16,31,31,22,22,25,25,12,12,15,15,20,20,12,12,4,4,27,27,16,16,5,5,19,19,8,8,12,12,17,17,23,23,21,21,4,4,24,24,28,28,10,10,28,28,28,28,26,26,12,12,25,25,20,20,1,1,8,8,13,13,30,30,7,7,26,26,16,16,4,4,6,6,29,29,2,2,3,3,29,29,23,23,0,0,31,31,30,30,25,25,4,4,24,24,12,12,23,23,10,10,29,29,6,6,2,2,17,17,30,30,16,16,27,27,12,12,26,26,24,24,19,19,1,1,26,26,11,11,17,17,13,13,29,29,5,5,9,9,20,20,17,17,17,17,11,11,12,12,16,16,15,15,27,27,5,5,12,12,16,16,17,17,20,20,14,14,12,12,18,18,19,19,26,26,16,16,4,4,18,18,24,24,12,12,20,20,28,28,16,16,5,5,0,0,0,0,10,10,31,31,11,11,10,10,30,30,0,0,22,22,5,5,3,3,24,24,23,23,20,20,19,19,18,18,2,2,6,6,17,17,22,22,16,16,11,11,16,16,8,8,3,3,28,28,17,17,30,30,25,25,9,9,9,9,8,8,26,26,17,17,21,21,3,3,19,19,5,5,1,1,21,21,26,26,7,7,17,17,5,5,0,0,23,23,17,17,18,18,20,20,27,27,30,30,26,26,20,20,27,27,14,14,25,25,13,13,21,21,7,7,29,29,31,31,21,21,29,29,31,31,27,27,4,4,6,6,19,19,16,16,20,20,13,13,13,13,11,11,2,2,26,26,23,23,0,0,5,5,0,0,25,25,3,3,3,3,21,21,14,14,20,20,18,18,22,22,18,18,7,7,12,12,23,23,19,19,27,27,20,20,14,14,3,3,22,22,25,25,7,7,1,1,15,15,13,13,7,7,3,3,18,18,18,18,28,28,16,16,4,4,8,8,10,10,13,13,0,0,14,14,8,8,26,26,20,20,22,22,30,30,2,2,29,29,16,16,18,18,4,4,27,27,12,12,6,6,18,18,18,18,28,28,3,3,30,30,21,21,31,31,24,24,2,2,17,17,0,0,1,1,8,8,28,28,20,20,26,26,17,17,8,8,17,17,12,12,21,21,16,16,22,22,2,2,15,15,6,6,10,10,29,29,2,2,29,29,0,0,11,11,19,19,8,8,16,16,21,21,18,18,9,9,28,28,21,21,8,8,4,4,24,24,18,18,19,19,14,14,18,18,31,31,24,24,30,30,23,23,3,3,11,11,20,20,14,14,19,19,27,27,5,5,6,6,11,11,1,1,22,22,16,16,30,30,9,9,3,3,27,27,5,5,23,23,23,23,1,1,18,18,26,26,31,31,29,29,13,13,8,8,9,9,5,5,13,13,7,7,17,17,31,31,9,9,2,2,3,3,26,26,12,12,12,12,7,7,3,3,25,25,9,9,25,25,25,25,17,17,24,24,24,24,12,12,21,21,20,20,10,10,25,25,6,6,13,13,8,8,30,30,20,20,3,3,4,4,24,24,11,11,22,22,4,4,30,30,1,1,17,17,23,23,7,7,10,10,15,15,5,5,27,27,29,29,0,0,26,26,4,4,4,4,6,6,6,6,30,30,23,23,8,8,20,20,5,5,14,14,6,6,5,5,5,5,17,17,12,12,26,26,1,1,18,18,15,15,15,15,8,8,1,1,18,18,24,24,12,12,22,22,3,3,17,17,5,5,14,14,9,9,28,28,5,5,0,0,0,0,21,21,29,29,26,26,19,19,1,1,22,22,26,26,10,10,29,29,19,19,31,31,17,17,24,24,7,7,22,22,14,14,17,17,1,1,4,4,16,16,25,25,22,22,24,24,0,0,8,8,31,31,26,26,2,2,25,25,14,14,24,24,4,4,18,18,22,22,31,31,13,13,16,16,13,13,29,29,29,29,7,7,4,4,13,13,22,22,14,14,14,14,18,18,14,14,21,21,22,22,29,29,18,18,4,4,5,5,31,31,20,20,20,20,8,8,8,8,1,1,16,16,2,2,1,1,22,22,7,7,13,13,2,2,30,30,14,14,18,18,1,1,28,28,10,10,11,11,0,0,21,21,8,8,29,29,6,6,18,18,13,13,30,30,6,6,9,9,15,15,14,14,27,27,26,26,31,31,11,11,26,26,4,4,3,3,17,17,20,20,29,29,1,1,24,24,26,26,10,10,5,5,10,10,30,30,20,20,18,18,8,8,10,10,12,12,13,13,19,19,6,6,29,29,31,31,2,2,3,3,24,24,16,16,4,4,12,12,5,5,18,18,22,22,22,22,25,25,17,17,10,10,29,29,2,2,1,1,29,29,27,27,1,1,9,9,25,25,20,20,25,25,21,21,9,9,12,12,28,28,22,22,21,21,23,23,16,16,0,0,20,20,6,6,0,0,23,23,11,11,15,15,0,0,18,18,31,31,23,23,30,30,29,29,31,31,27,27,10,10,0,0,16,16,28,28,6,6,29,29,10,10,19,19,8,8,21,21,2,2,11,11,10,10,14,14,5,5,25,25,11,11,1,1,8,8,9,9,18,18,1,1,11,11,7,7,31,31,22,22,5,5,9,9,12,12,20,20,4,4,19,19,0,0,15,15,1,1,18,18,2,2,6,6,18,18,10,10,26,26,25,25,15,15,3,3,20,20,15,15,8,8,4,4,3,3,10,10,16,16,3,3,31,31,31,31,17,17,6,6,2,2,30,30,23,23,27,27,14,14,21,21,25,25,28,28,31,31,24,24,4,4,3,3,0,0,3,3,9,9,16,16,25,25,1,1,5,5,12,12,30,30,17,17,26,26,18,18,2,2,19,19,3,3,23,23,6,6,10,10,21,21,30,30,17,17,9,9,28,28,8,8,3,3,22,22,12,12,0,0,27,27,20,20,1,1,21,21,5,5,3,3,2,2,0,0,27,27,17,17,30,30,15,15,10,10,25,25,10,10,25,25,15,15,11,11,11,11,27,27,22,22,25,25,11,11,8,8,20,20,14,14,28,28,4,4,10,10,15,15,1,1,25,25,17,17,3,3,4,4,9,9,28,28,12,12,10,10,14,14,3,3,19,19,13,13,8,8,18,18,6,6,6,6,18,18,18,18,26,26,5,5,31,31,22,22,10,10,8,8,12,12,9,9,26,26,17,17,7,7,21,21,17,17,28,28,18,18,4,4,9,9,28,28,3,3,8,8,12,12,14,14,17,17,7,7,4,4,3,3,8,8,4,4,23,23,27,27,9,9,13,13,17,17,1,1,10,10,10,10,21,21,25,25,2,2,16,16,9,9,2,2,20,20,18,18,29,29,5,5,7,7,17,17,24,24,14,14,27,27,15,15,15,15,8,8,29,29,31,31,18,18,10,10,24,24,1,1,27,27,15,15,18,18,8,8,1,1,5,5,20,20,2,2,26,26,20,20,2,2,19,19,29,29,0,0,7,7,15,15,3,3,27,27,22,22,6,6,7,7,25,25,6,6,25,25,25,25,24,24,29,29,23,23,13,13,8,8,3,3,22,22,27,27,19,19,1,1,30,30,13,13,16,16,22,22,1,1,1,1,27,27,17,17,0,0,9,9,31,31,26,26,23,23,21,21,2,2,9,9,24,24,11,11,15,15,22,22,20,20,12,12,22,22,8,8,17,17,3,3,8,8,22,22,3,3,12,12,31,31,24,24,7,7,19,19,6,6,15,15,7,7,25,25,6,6,12,12,17,17,9,9,9,9,8,8,17,17,10,10,14,14,2,2,29,29,21,21,14,14,27,27,11,11,13,13,11,11,1,1,3,3,5,5,10,10,4,4,17,17,20,20,7,7,17,17,28,28,20,20,6,6,23,23,15,15,8,8,18,18,2,2,24,24,2,2,17,17,6,6,27,27,6,6,1,1,15,15,19,19,17,17,16,16,15,15,6,6,6,6,5,5,13,13,6,6,31,31,30,30,3,3,2,2,16,16,29,29,12,12,24,24,23,23,25,25,3,3,16,16,19,19,16,16,18,18,23,23,0,0,13,13,1,1,11,11,12,12,20,20,18,18,12,12,2,2,9,9,29,29,9,9,4,4,8,8,30,30,30,30,11,11,31,31,28,28,4,4,17,17,5,5,5,5,24,24,6,6,5,5,4,4,19,19,21,21,24,24,13,13,3,3,28,28,15,15,5,5,26,26,29,29,16,16,28,28,30,30,28,28,9,9,7,7,28,28,19,19,17,17,29,29,5,5,16,16,25,25,24,24,10,10,19,19,13,13,14,14,1,1,4,4,20,20,16,16,14,14,28,28,16,16,20,20,28,28,5,5,26,26,13,13,2,2,15,15,4,4,5,5,5,5,31,31,12,12,30,30,24,24,20,20,5,5,21,21,19,19,1,1,9,9,8,8,8,8,16,16,11,11,27,27,8,8,22,22,25,25,29,29,24,24,11,11,4,4,26,26,15,15,3,3,16,16,0,0,27,27,24,24,23,23,1,1,21,21,7,7,0,0,18,18,25,25,25,25,23,23,1,1,28,28,10,10,5,5,17,17,17,17,9,9,20,20,24,24,7,7,16,16,4,4,6,6,19,19,0,0,12,12,21,21,29,29,22,22,5,5,22,22,20,20,29,29,1,1,0,0,25,25,22,22,10,10,11,11,27,27,4,4,0,0,15,15,27,27,17,17,2,2,11,11,18,18,27,27,24,24,17,17,0,0,25,25,22,22,22,22,1,1,5,5,26,26,17,17,28,28,23,23,16,16,14,14,21,21,16,16,8,8,23,23,7,7,3,3,26,26,17,17,31,31,17,17,19,19,4,4,23,23,10,10,23,23,23,23,7,7,28,28,1,1,26,26,31,31,24,24,4,4,21,21,8,8,4,4,21,21,24,24,0,0,10,10,1,1,17,17,6,6,2,2,10,10,3,3,26,26,16,16,29,29,17,17,6,6,28,28,0,0,26,26,16,16,29,29,5,5,5,5,4,4,11,11,17,17,15,15,21,21,0,0,4,4,1,1,24,24,6,6,19,19,6,6,11,11,10,10,29,29,12,12,10,10,15,15,19,19,24,24,0,0,31,31,9,9,13,13,1,1,6,6,19,19,11,11,28,28,23,23,10,10,7,7,29,29,20,20,23,23,17,17,26,26,24,24,19,19,9,9,15,15,20,20,23,23,19,19,11,11,30,30,27,27,27,27,24,24,28,28,8,8,2,2,5,5,6,6,15,15,4,4,18,18,0,0,28,28,13,13,18,18,23,23,1,1,4,4,31,31,13,13,17,17,14,14,9,9,26,26,27,27,17,17,19,19,5,5,15,15,3,3,0,0,1,1,17,17,5,5,18,18,17,17,9,9,31,31,8,8,28,28,10,10,14,14,14,14,3,3,8,8,20,20,21,21,24,24,15,15,20,20,4,4,13,13,14,14,7,7,15,15,18,18,9,9,24,24,2,2,19,19,8,8,15,15,20,20,0,0,11,11,18,18,0,0,29,29,29,29,23,23,5,5,16,16,3,3,10,10,21,21,10,10,21,21,24,24,25,25,3,3,20,20,2,2,4,4,7,7,10,10,22,22,20,20,3,3,20,20,26,26,6,6,22,22,30,30,26,26,24,24,8,8,6,6,16,16,28,28,5,5,24,24,11,11,23,23,16,16,23,23,26,26,0,0,13,13,3,3,27,27,23,23,13,13,31,31,18,18,3,3,11,11,31,31,8,8,31,31,15,15,11,11,31,31,6,6,11,11,10,10,2,2,22,22,26,26,4,4,7,7,10,10,19,19,19,19,15,15,28,28,9,9,10,10,20,20,14,14,21,21,18,18,13,13,21,21,19,19,9,9,8,8,26,26,18,18,4,4,27,27,28,28,24,24,15,15,28,28,13,13,13,13,7,7,9,9,5,5,9,9,11,11,9,9,1,1,7,7,0,0,14,14,31,31,13,13,29,29,8,8,25,25,30,30,11,11,22,22,23,23,21,21,12,12,20,20,30,30,1,1,19,19,14,14,10,10,18,18,3,3,10,10,6,6,17,17,4,4,5,5,18,18,10,10,17,17,10,10,7,7,9,9,12,12,17,17,30,30,26,26,10,10,30,30,17,17,11,11,24,24,6,6,25,25,19,19,18,18,31,31,20,20,23,23,8,8,10,10,8,8,31,31,14,14,24,24,21,21,7,7,20,20,10,10,31,31,29,29,22,22,3,3,12,12,25,25,18,18,25,25,12,12,22,22,20,20,26,26,28,28,24,24,29,29,22,22,23,23,2,2,21,21,8,8,13,13,16,16,21,21,5,5,19,19,9,9,3,3,20,20,16,16,8,8,13,13,26,26,25,25,22,22,9,9,11,11,0,0,10,10,31,31,7,7,4,4,3,3,7,7,4,4,4,4,3,3,21,21,6,6,24,24,16,16,7,7,19,19,4,4,11,11,3,3,9,9,12,12,0,0,0,0,12,12,23,23,1,1,6,6,2,2,3,3,28,28,5,5,29,29,16,16,17,17,9,9,9,9,13,13,28,28,10,10,2,2,4,4,12,12,27,27,12,12,12,12,30,30,27,27,28,28,12,12,7,7,10,10,4,4,17,17,11,11,10,10,19,19,9,9,26,26,16,16,7,7,28,28,28,28,10,10,15,15,28,28,23,23,17,17,0,0,6,6,2,2,8,8,5,5,21,21,30,30,26,26,5,5,13,13,0,0,23,23,10,10,2,2,7,7,13,13,27,27,4,4,30,30,0,0,28,28,27,27,31,31,21,21,18,18,18,18,30,30,13,13,12,12,21,21,26,26,20,20,9,9,11,11,31,31,28,28,28,28,2,2,26,26,19,19,30,30,8,8,2,2,26,26,29,29,1,1,22,22,27,27,0,0,3,3,21,21,3,3,27,27,27,27,10,10,22,22,14,14,19,19,5,5,28,28,16,16,20,20,8,8,5,5,23,23,2,2,3,3,30,30,2,2,26,26,15,15,28,28,10,10,24,24,22,22,4,4,30,30,4,4,26,26,1,1,9,9,18,18,0,0,0,0,31,31,15,15,25,25,0,0,4,4,5,5,22,22,14,14,19,19,12,12,17,17,26,26,12,12,21,21,30,30,8,8,31,31,28,28,18,18,21,21,1,1,26,26,6,6,2,2,7,7,1,1,2,2,10,10,16,16,30,30,10,10,20,20,8,8,17,17,9,9,16,16,18,18,27,27,10,10,15,15,10,10,22,22,9,9,22,22,4,4,17,17,15,15,26,26,2,2,16,16,26,26,22,22,0,0,15,15,2,2,13,13,26,26,22,22,17,17,7,7,13,13,12,12,28,28,0,0,23,23,17,17,1,1,0,0,3,3,28,28,17,17,10,10,8,8,13,13,4,4,4,4,1,1,25,25,6,6,12,12,31,31,21,21,3,3,15,15,24,24,21,21,13,13,5,5,11,11,20,20,0,0,17,17,0,0,31,31,1,1,0,0,13,13,9,9,9,9,2,2,17,17,8,8,21,21,23,23,19,19,14,14,12,12,19,19,12,12,29,29,2,2,6,6,9,9,14,14,16,16,27,27,23,23,5,5,7,7,4,4,7,7,15,15,11,11,23,23,7,7,8,8,28,28,1,1,26,26,17,17,5,5,28,28,12,12,22,22,31,31,18,18,12,12,28,28,19,19,4,4,10,10,4,4,30,30,11,11,17,17,17,17,6,6,15,15,16,16,28,28,10,10,21,21,15,15,12,12,6,6,30,30,25,25,10,10,25,25,15,15,22,22,6,6,27,27,3,3,29,29,16,16,31,31,10,10,31,31,8,8,9,9,25,25,28,28,17,17,5,5,6,6,21,21,21,21,24,24,31,31,22,22,27,27,20,20,24,24,9,9,8,8,29,29,10,10,3,3,17,17,5,5,23,23,7,7,1,1,19,19,2,2,5,5,20,20,18,18,25,25,6,6,10,10,26,26,0,0,10,10,2,2,7,7,24,24,21,21,13,13,26,26,22,22,19,19,31,31,1,1,30,30,28,28,1,1,27,27,21,21,17,17,15,15,26,26,8,8,28,28,9,9,12,12,22,22,12,12,31,31,20,20,4,4,8,8,13,13,20,20,6,6,31,31,16,16,7,7,21,21,22,22,17,17,0,0,27,27,29,29,11,11,16,16,11,11,26,26,29,29,6,6,29,29,16,16,19,19,5,5,7,7,22,22,26,26,10,10,16,16,26,26,12,12,5,5,19,19,21,21,9,9,16,16,4,4,24,24,26,26,14,14,29,29,10,10,30,30,22,22,23,23,19,19,12,12,25,25,9,9,8,8,15,15,23,23,12,12,8,8,29,29,2,2,3,3,31,31,22,22,29,29,13,13,8,8,10,10,23,23,12,12,19,19,17,17,11,11,18,18,19,19,21,21,20,20,26,26,2,2,0,0,26,26,28,28,2,2,22,22,10,10,0,0,29,29,25,25,6,6,27,27,6,6,4,4,24,24,25,25,14,14,11,11,9,9,12,12,27,27,0,0,10,10,13,13,19,19,7,7,20,20,4,4,5,5,21,21,1,1,16,16,8,8,4,4,25,25,7,7,18,18,19,19,2,2,23,23,16,16,22,22,20,20,18,18,6,6,15,15,4,4,18,18,1,1,25,25,18,18,24,24,24,24,2,2,29,29,31,31,21,21,1,1,0,0,27,27,26,26,29,29,9,9,12,12,6,6,12,12,22,22,6,6,16,16,8,8,0,0,3,3,30,30,20,20,8,8,7,7,9,9,3,3,4,4,28,28,30,30,0,0,8,8,3,3,28,28,25,25,25,25,11,11,22,22,0,0,17,17,14,14,21,21,8,8,27,27,4,4,1,1,30,30,18,18,29,29,17,17,16,16,25,25,8,8,30,30,21,21,24,24,12,12,10,10,28,28,18,18,12,12,4,4,7,7,9,9,13,13,9,9,9,9,13,13,28,28,20,20,3,3,24,24,3,3,4,4,3,3,5,5,30,30,10,10,19,19,6,6,28,28,14,14,16,16,3,3,27,27,12,12,21,21,27,27,16,16,22,22,21,21,3,3,1,1,23,23,0,0,2,2,21,21,21,21,24,24,10,10,13,13,23,23,12,12,15,15,9,9,27,27,15,15,11,11,7,7,2,2,28,28,0,0,0,0,10,10,27,27,18,18,19,19,19,19,12,12,12,12,0,0,5,5,1,1,22,22,19,19,2,2,0,0,27,27,20,20,13,13,8,8,27,27,9,9,4,4,7,7,11,11,4,4,9,9,25,25,8,8,12,12,0,0,7,7,24,24,11,11,27,27,4,4,31,31,23,23,2,2,0,0,16,16,0,0,18,18,17,17,25,25,29,29,27,27,6,6,31,31,14,14,9,9,18,18,0,0,2,2,18,18,25,25,7,7,2,2,5,5,8,8,0,0,2,2,24,24,21,21,20,20,3,3,29,29,1,1,3,3,14,14,16,16,17,17,0,0,30,30,21,21,21,21,30,30,28,28,28,28,12,12,9,9,1,1,6,6,15,15,8,8,11,11,18,18,28,28,17,17,11,11,18,18,6,6,20,20,19,19,1,1,14,14,13,13,18,18,27,27,8,8,10,10,9,9,20,20,14,14,3,3,25,25,26,26,11,11,29,29,25,25,12,12,3,3,23,23,25,25,5,5,11,11,22,22,29,29,19,19,4,4,17,17,31,31,23,23,2,2,30,30,15,15,13,13,10,10,4,4,30,30,7,7,28,28,1,1,12,12,26,26,11,11,18,18,8,8,18,18,1,1,8,8,23,23,23,23,0,0,1,1,20,20,13,13,27,27,13,13,7,7,17,17,6,6,18,18,28,28,9,9,17,17,10,10,26,26,27,27,22,22,26,26,28,28,4,4,20,20,8,8,9,9,4,4,3,3,4,4,14,14,25,25,9,9,12,12,13,13,10,10,5,5,3,3,24,24,8,8,11,11,27,27,29,29,16,16,11,11,16,16,19,19,21,21,24,24,24,24,5,5,4,4,14,14,28,28,12,12,23,23,13,13,0,0,25,25,12,12,1,1,22,22,20,20,4,4,28,28,1,1,2,2,3,3,0,0,9,9,20,20,26,26,30,30,20,20,8,8,29,29,4,4,11,11,1,1,18,18,29,29,17,17,6,6,31,31,9,9,12,12,30,30,24,24,24,24,11,11,14,14,8,8,3,3,3,3,19,19,22,22,14,14,25,25,7,7,9,9,17,17,24,24,2,2,10,10,6,6,27,27,27,27,21,21,29,29,8,8,26,26,8,8,1,1,16,16,24,24,1,1,3,3,24,24,13,13,18,18,18,18,4,4,26,26,21,21,31,31,4,4,5,5,16,16,10,10,16,16,7,7,16,16,13,13,20,20,5,5,28,28,24,24,9,9,26,26,0,0,1,1,12,12,14,14,12,12,12,12,13,13,20,20,24,24,12,12,1,1,25,25,14,14,0,0,0,0,1,1,2,2,13,13,18,18,1,1,23,23,0,0,24,24,27,27,11,11,22,22,13,13,12,12,30,30,21,21,18,18,11,11,23,23,11,11,4,4,13,13,9,9,13,13,2,2,12,12,1,1,25,25,23,23,21,21,10,10,19,19,15,15,1,1,2,2,21,21,11,11,29,29,17,17,20,20,28,28,9,9,1,1,1,1,7,7,22,22,5,5,20,20,0,0,22,22,25,25,31,31,14,14,2,2,25,25,24,24,4,4,24,24,17,17,5,5,9,9,15,15,30,30,15,15,4,4,18,18,2,2,22,22,12,12,4,4,9,9,9,9,10,10,25,25,12,12,12,12,19,19,12,12,30,30,28,28,9,9,5,5,26,26,22,22,0,0,4,4,5,5,10,10,0,0,7,7,24,24,29,29,12,12,0,0,9,9,4,4,31,31,24,24,19,19,8,8,28,28,29,29,1,1,24,24,26,26,17,17,23,23,9,9,8,8,17,17,11,11,27,27,24,24,5,5,7,7,3,3,22,22,7,7,23,23,21,21,29,29,30,30,22,22,31,31,4,4,11,11,30,30,27,27,20,20,3,3,9,9,17,17,24,24,5,5,24,24,12,12,0,0,29,29,29,29,25,25,15,15,16,16,16,16,10,10,1,1,27,27,31,31,27,27,24,24,23,23,12,12,12,12,30,30,2,2,12,12,8,8,9,9,7,7,17,17,1,1,30,30,18,18,19,19,30,30,23,23,15,15,22,22,19,19,10,10,1,1,11,11,10,10,25,25,9,9,24,24,28,28,26,26,26,26,6,6,24,24,19,19,9,9,20,20,1,1,11,11,6,6,20,20,14,14,27,27,0,0,8,8,27,27,4,4,20,20,8,8,29,29,23,23,20,20,7,7,19,19,26,26,6,6,16,16,6,6,25,25,3,3,21,21,30,30,16,16,18,18,19,19,25,25,31,31,26,26,10,10,2,2,25,25,4,4,30,30,25,25,20,20,26,26,20,20,0,0,10,10,3,3,24,24,31,31,1,1,10,10,21,21,26,26,8,8,3,3,2,2,8,8,1,1,26,26,16,16,28,28,16,16,12,12,17,17,29,29,3,3,10,10,29,29,24,24,31,31,3,3,28,28,12,12,10,10,1,1,26,26,1,1,0,0,8,8,9,9,31,31,19,19,17,17,1,1,6,6,14,14,3,3,29,29,23,23,2,2,9,9,22,22,2,2,20,20,6,6,24,24,6,6,5,5,28,28,20,20,28,28,12,12,4,4,11,11,30,30,23,23,0,0,13,13,10,10,2,2,3,3,20,20,2,2,0,0,16,16,19,19,0,0,11,11,12,12,2,2,2,2,11,11,13,13,10,10,2,2,13,13,15,15,7,7,14,14,0,0,25,25,7,7,0,0,19,19,15,15,0,0,29,29,1,1,17,17,22,22,19,19,6,6,2,2,27,27,2,2,3,3,16,16,17,17,31,31,4,4,4,4,14,14,26,26,12,12,1,1,21,21,28,28,18,18,29,29,20,20,3,3,11,11,18,18,19,19,25,25,23,23,4,4,25,25,19,19,22,22,28,28,16,16,4,4,10,10,29,29,0,0,5,5,2,2,25,25,14,14,12,12,10,10,26,26,17,17,9,9,22,22,3,3,10,10,21,21,9,9,19,19,28,28,20,20,7,7,19,19,22,22,2,2,14,14,26,26,23,23,3,3,30,30,19,19,19,19,1,1,30,30,5,5,4,4,27,27,9,9,21,21,6,6,0,0,24,24,8,8,0,0,17,17,20,20,29,29,14,14,17,17,27,27,20,20,26,26,9,9,0,0,3,3,12,12,17,17,6,6,19,19,21,21,18,18,6,6,6,6,27,27,20,20,30,30,7,7,6,6,13,13,18,18,17,17,12,12,9,9,12,12,19,19,6,6,9,9,4,4,13,13,2,2,19,19,28,28,21,21,2,2,4,4,8,8,1,1,20,20,8,8,29,29,25,25,5,5,4,4,2,2,19,19,13,13,6,6,6,6,10,10,0,0,16,16,6,6,10,10,22,22,2,2,0,0,29,29,11,11,24,24,2,2,6,6,10,10,10,10,15,15,26,26,28,28,24,24,7,7,5,5,17,17,0,0,25,25,4,4,6,6,25,25,24,24,19,19,11,11,22,22,14,14,10,10,2,2,3,3,12,12,2,2,13,13,15,15,9,9,22,22,14,14,2,2,5,5,0,0,14,14,22,22,20,20,7,7,23,23,22,22,16,16,30,30,5,5,11,11,0,0,31,31,31,31,13,13,14,14,9,9,3,3,7,7,21,21,8,8,5,5,15,15,29,29,30,30,7,7,9,9,23,23,16,16,22,22,10,10,8,8,22,22,26,26,2,2,5,5,11,11,29,29,0,0,17,17,16,16,25,25,31,31,15,15,0,0,7,7,0,0,12,12,17,17,20,20,18,18,2,2,5,5,8,8,24,24,1,1,7,7,3,3,20,20,4,4,28,28,19,19,21,21,20,20,3,3,0,0,12,12,16,16,4,4,29,29,15,15,22,22,8,8,9,9,18,18,21,21,22,22,18,18,1,1,6,6,1,1,1,1,27,27,13,13,4,4,0,0,9,9,8,8,4,4,26,26,29,29,6,6,12,12,31,31,17,17,23,23,27,27,29,29,21,21,30,30,9,9,3,3,8,8,16,16,8,8,13,13,28,28,27,27,3,3,2,2,23,23,23,23,5,5,10,10,15,15,15,15,18,18,1,1,4,4,22,22,29,29,10,10,26,26,30,30,27,27,28,28,0,0,30,30,1,1,12,12,7,7,23,23,30,30,7,7,0,0,11,11,21,21,31,31,2,2,22,22,11,11,17,17,29,29,8,8,2,2,25,25,15,15,20,20,5,5,1,1,12,12,8,8,12,12,20,20,6,6,1,1,0,0,12,12,11,11,3,3,5,5,21,21,3,3,21,21,11,11,14,14,11,11,21,21,12,12,31,31,3,3,15,15,0,0,7,7,9,9,17,17,24,24,4,4,6,6,2,2,10,10,8,8,0,0,29,29,2,2,9,9,11,11,24,24,9,9,28,28,28,28,29,29,18,18,1,1,23,23,4,4,3,3,15,15,14,14,10,10,30,30,13,13,20,20,28,28,15,15,3,3,25,25,9,9,29,29,8,8,23,23,20,20,2,2,16,16,0,0,4,4,15,15,13,13,13,13,6,6,25,25,5,5,9,9,0,0,21,21,23,23,13,13,17,17,26,26,28,28,25,25,6,6,6,6,6,6,9,9,14,14,27,27,5,5,0,0,1,1,14,14,0,0,3,3,0,0,30,30,25,25,17,17,26,26,7,7,11,11,11,11,23,23,22,22,0,0,5,5,19,19,16,16,13,13,23,23,23,23,2,2,18,18,3,3,31,31,8,8,6,6,31,31,31,31,27,27,20,20,24,24,26,26,4,4,30,30,2,2,13,13,7,7,31,31,6,6,16,16,12,12,9,9,4,4,18,18,21,21,23,23,16,16,5,5,19,19,0,0,18,18,19,19,10,10,0,0,8,8,13,13,20,20,9,9,22,22,22,22,14,14,14,14,10,10,26,26,0,0,24,24,2,2,31,31,7,7,8,8,9,9,8,8,10,10,22,22,18,18,9,9,4,4,22,22,10,10,7,7,1,1,2,2,18,18,14,14,16,16,4,4,26,26,6,6,6,6,8,8,25,25,19,19,19,19,7,7,0,0,8,8,3,3,16,16,29,29,10,10,9,9,25,25,1,1,23,23,20,20,0,0,2,2,16,16,8,8,12,12,31,31,24,24,26,26,13,13,4,4,25,25,22,22,15,15,26,26,11,11,25,25,23,23,6,6,15,15,6,6,21,21,17,17,27,27,1,1,4,4,24,24,16,16,18,18,4,4,14,14,2,2,18,18,16,16,15,15,14,14,12,12,12,12,22,22,28,28,10,10,6,6,25,25,1,1,19,19,19,19,22,22,4,4,13,13,11,11,5,5,15,15,8,8,9,9,8,8,24,24,4,4,16,16,18,18,31,31,21,21,31,31,14,14,2,2,28,28,10,10,9,9,5,5,17,17,23,23,7,7,9,9,8,8,26,26,17,17,24,24,25,25,23,23,16,16,4,4,14,14,14,14,27,27,23,23,1,1,19,19,29,29,15,15,15,15,1,1,30,30,6,6,3,3,0,0,1,1,27,27,8,8,0,0,10,10,3,3,9,9,11,11,9,9,14,14,31,31,12,12,9,9,6,6,3,3,28,28,31,31,27,27,23,23,29,29,19,19,6,6,11,11,24,24,9,9,2,2,16,16,17,17,0,0,14,14,7,7,8,8,0,0,23,23,12,12,16,16,8,8,30,30,24,24,6,6,2,2,17,17,1,1,25,25,8,8,0,0,24,24,4,4,18,18,15,15,23,23,7,7,23,23,22,22,2,2,5,5,6,6,4,4,12,12,14,14,15,15,13,13,26,26,7,7,26,26,5,5,3,3,26,26,0,0,27,27,18,18,13,13,3,3,19,19,11,11,24,24,27,27,17,17,27,27,1,1,3,3,19,19,19,19,28,28,2,2,2,2,12,12,31,31,1,1,16,16,11,11,8,8,18,18,21,21,7,7,11,11,8,8,12,12,22,22,23,23,4,4,0,0,23,23,12,12,6,6,1,1,4,4,11,11,1,1,30,30,14,14,13,13,23,23,18,18,15,15,25,25,13,13,1,1,4,4,25,25,15,15,16,16,11,11,3,3,30,30,17,17,7,7,25,25,12,12,25,25,6,6,19,19,6,6,13,13,7,7,12,12,19,19,14,14,18,18,4,4,3,3,21,21,14,14,28,28,10,10,5,5,24,24,31,31,9,9,20,20,14,14,5,5,2,2,9,9,18,18,23,23,27,27,1,1,10,10,14,14,20,20,13,13,16,16,12,12,4,4,1,1,0,0,8,8,31,31,14,14,5,5,24,24,27,27,12,12,9,9,26,26,14,14,23,23,4,4,26,26,29,29,9,9,13,13,10,10,28,28,23,23,6,6,29,29,9,9,28,28,24,24,28,28,9,9,24,24,6,6,1,1,23,23,13,13,10,10,5,5,28,28,0,0,30,30,6,6,9,9,5,5,0,0,12,12,14,14,11,11,19,19,27,27,18,18,17,17,13,13,16,16,18,18,1,1,6,6,17,17,5,5,0,0,20,20,29,29,20,20,7,7,24,24,27,27,21,21,8,8,16,16,0,0,22,22,9,9,17,17,15,15,29,29,31,31,11,11,19,19,15,15,19,19,2,2,31,31,25,25,15,15,20,20,0,0,15,15,27,27,29,29,2,2,0,0,22,22,27,27,23,23,31,31,18,18,12,12,0,0,7,7,27,27,4,4,28,28,25,25,23,23,13,13,17,17,19,19,26,26,10,10,8,8,21,21,3,3,16,16,30,30,28,28,22,22,29,29,17,17,17,17,18,18,2,2,19,19,19,19,0,0,1,1,3,3,15,15,13,13,14,14,10,10,26,26,24,24,19,19,19,19,10,10,9,9,13,13,30,30,23,23,30,30,12,12,6,6,12,12,26,26,28,28,24,24,4,4,12,12,3,3,3,3,15,15,3,3,15,15,18,18,10,10,12,12,12,12,20,20,10,10,6,6,2,2,22,22,0,0,26,26,20,20,16,16,8,8,31,31,7,7,23,23,21,21,24,24,20,20,18,18,20,20,29,29,17,17,4,4,15,15,14,14,26,26,0,0,12,12,28,28,0,0,8,8,14,14,31,31,24,24,9,9,29,29,22,22,19,19,13,13,31,31,4,4,0,0,2,2,28,28,26,26,2,2,12,12,22,22,30,30,24,24,28,28,20,20,5,5,4,4,12,12,8,8,25,25,26,26,17,17,27,27,7,7,31,31,21,21,27,27,12,12,20,20,15,15,19,19,22,22,21,21,13,13,4,4,13,13,18,18,28,28,26,26,9,9,26,26,25,25,25,25,19,19,19,19,15,15,10,10,24,24,22,22,17,17,28,28,9,9,10,10,3,3,12,12,21,21,1,1,22,22,6,6,14,14,3,3,21,21,31,31,12,12,11,11,19,19,25,25,22,22,0,0,18,18,29,29,20,20,30,30,23,23,6,6,19,19,12,12,1,1,8,8,14,14,29,29,16,16,4,4,5,5,21,21,26,26,20,20,20,20,16,16,3,3,28,28,0,0,4,4,8,8,26,26,30,30,19,19,0,0,23,23,14,14,18,18,20,20,8,8,0,0,30,30,5,5,8,8,6,6,7,7,3,3,4,4,21,21,16,16,4,4,21,21,8,8,4,4,4,4,6,6,21,21,28,28,27,27,10,10,0,0,1,1,1,1,24,24,23,23,23,23,4,4,15,15,2,2,12,12,16,16,10,10,4,4,8,8,15,15,22,22,7,7,8,8,16,16,27,27,6,6,28,28,16,16,19,19,8,8,15,15,23,23,6,6,8,8,27,27,17,17,26,26,31,31,10,10,22,22,22,22,9,9,21,21,13,13,6,6,5,5,12,12,0,0,1,1,4,4,2,2,26,26,28,28,25,25,24,24,28,28,29,29,25,25,7,7,13,13,10,10,25,25,11,11,25,25,17,17,26,26,4,4,31,31,0,0,6,6,4,4,1,1,24,24,4,4,13,13,14,14,20,20,15,15,20,20,0,0,30,30,17,17,11,11,3,3,28,28,11,11,15,15,2,2,23,23,28,28,2,2,22,22,11,11,20,20,6,6,19,19,8,8,0,0,5,5,30,30,28,28,17,17,27,27,9,9,25,25,17,17,5,5,3,3,15,15,31,31,0,0,15,15,24,24,16,16,2,2,26,26,25,25,19,19,1,1,16,16,8,8,16,16,13,13,15,15,10,10,15,15,12,12,0,0,30,30,21,21,25,25,15,15,28,28,30,30,7,7,7,7,30,30,0,0,31,31,28,28,27,27,23,23,19,19,10,10,18,18,7,7,17,17,5,5,20,20,12,12,25,25,4,4,0,0,25,25,29,29,6,6,25,25,14,14,13,13,1,1,10,10,28,28,30,30,3,3,1,1,13,13,29,29,22,22,8,8,30,30,19,19,28,28,24,24,26,26,30,30,9,9,1,1,2,2,20,20,9,9,6,6,29,29,24,24,19,19,13,13,3,3,15,15,6,6,0,0,21,21,10,10,18,18,24,24,1,1,28,28,29,29,16,16,31,31,10,10,15,15,15,15,12,12,1,1,25,25,15,15,30,30,16,16,24,24,26,26,27,27,24,24,21,21,22,22,23,23,30,30,29,29,2,2,31,31,27,27,5,5,14,14,17,17,30,30,28,28,7,7,7,7,24,24,10,10,3,3,24,24,14,14,22,22,20,20,25,25,21,21,21,21,20,20,28,28,21,21,0,0,7,7,4,4,13,13,12,12,24,24,31,31,9,9,1,1,7,7,18,18,29,29,15,15,11,11,22,22,15,15,3,3,30,30,14,14,21,21,12,12,17,17,12,12,7,7,21,21,29,29,28,28,6,6,17,17,24,24,2,2,12,12,8,8,5,5,4,4,4,4,19,19,19,19,20,20,28,28,27,27,26,26,14,14,4,4,5,5,23,23,15,15,26,26,20,20,15,15,24,24,25,25,30,30,20,20,10,10,16,16,2,2,30,30,26,26,11,11,4,4,11,11,25,25,23,23,16,16,0,0,28,28,28,28,27,27,15,15,27,27,9,9,29,29,23,23,2,2,7,7,6,6,27,27,26,26,2,2,0,0,20,20,10,10,29,29,12,12,31,31,4,4,8,8,12,12,24,24,12,12,3,3,13,13,19,19,1,1,14,14,16,16,12,12,16,16,2,2,17,17,28,28,26,26,1,1,20,20,1,1,9,9,17,17,1,1,27,27,10,10,27,27,15,15,17,17,7,7,0,0,25,25,0,0,7,7,30,30,21,21,24,24,17,17,25,25,1,1,24,24,6,6,26,26,8,8,29,29,17,17,27,27,11,11,23,23,8,8,14,14,30,30,12,12,16,16,17,17,27,27,30,30,8,8,28,28,7,7,7,7,2,2,27,27,2,2,17,17,18,18,31,31,9,9,19,19,12,12,24,24,7,7,12,12,9,9,14,14,30,30,0,0,19,19,18,18,12,12,23,23,9,9,14,14,9,9,11,11,26,26,28,28,16,16,8,8,27,27,21,21,21,21,5,5,16,16,2,2,18,18,14,14,9,9,1,1,4,4,19,19,19,19,20,20,14,14,3,3,21,21,16,16,4,4,4,4,21,21,13,13,22,22,31,31,8,8,11,11,8,8,31,31,10,10,16,16,28,28,8,8,3,3,5,5,22,22,28,28,4,4,2,2,11,11,31,31,20,20,6,6,9,9,25,25,31,31,9,9,24,24,24,24,15,15,22,22,12,12,22,22,28,28,22,22,1,1,25,25,17,17,7,7,0,0,12,12,8,8,22,22,4,4,30,30,28,28,17,17,15,15,22,22,26,26,28,28,25,25,4,4,25,25,20,20,8,8,4,4,22,22,23,23,5,5,4,4,17,17,6,6,2,2,5,5,11,11,20,20,22,22,8,8,26,26,6,6,8,8,20,20,22,22,31,31,17,17,2,2,22,22,17,17,11,11,5,5,30,30,16,16,25,25,30,30,22,22,15,15,28,28,23,23,22,22,0,0,18,18,30,30,2,2,26,26,9,9,3,3,5,5,0,0,31,31,29,29,24,24,1,1,18,18,24,24,19,19,7,7,12,12,12,12,3,3,18,18,14,14,27,27,3,3,26,26,12,12,28,28,28,28,2,2,8,8,11,11,19,19,4,4,25,25,11,11,1,1,4,4,24,24,30,30,8,8,17,17,7,7,3,3,7,7,22,22,15,15,7,7,16,16,22,22,17,17,24,24,13,13,1,1,29,29,29,29,23,23,27,27,23,23,21,21,4,4,9,9,12,12,2,2,24,24,29,29,25,25,7,7,0,0,25,25,18,18,25,25,3,3,1,1,9,9,0,0,3,3,13,13,20,20,6,6,31,31,22,22,28,28,22,22,12,12,21,21,19,19,21,21,22,22,22,22,18,18,11,11,21,21,16,16,4,4,21,21,19,19,20,20,26,26,2,2,8,8,4,4,21,21,0,0,29,29,19,19,5,5,31,31,17,17,14,14,7,7,7,7,6,6,17,17,17,17,6,6,12,12,30,30,6,6,14,14,15,15,14,14,25,25,0,0,23,23,19,19,20,20,11,11,18,18,1,1,13,13,20,20,26,26,25,25,26,26,4,4,30,30,26,26,16,16,3,3,31,31,9,9,31,31,15,15,15,15,14,14,5,5,24,24,23,23,19,19,13,13,31,31,1,1,27,27,7,7,30,30,1,1,19,19,18,18,16,16,19,19,9,9,18,18,16,16,19,19,18,18,14,14,0,0,14,14,22,22,8,8,21,21,10,10,19,19,26,26,7,7,23,23,0,0,12,12,10,10,25,25,13,13,11,11,30,30,29,29,2,2,13,13,5,5,16,16,2,2,14,14,30,30,18,18,17,17,3,3,19,19,17,17,6,6,6,6,7,7,12,12,13,13,26,26,17,17,8,8,9,9,13,13,25,25,25,25,17,17,20,20,10,10,1,1,5,5,14,14,11,11,11,11,16,16,30,30,12,12,22,22,7,7,25,25,4,4,12,12,26,26,10,10,28,28,26,26,22,22,28,28,3,3,29,29,19,19,24,24,6,6,3,3,4,4,15,15,10,10,24,24,22,22,26,26,2,2,0,0,7,7,20,20,23,23,4,4,3,3,21,21,18,18,1,1,22,22,15,15,7,7,0,0,26,26,31,31,10,10,24,24,12,12,3,3,4,4,25,25,17,17,26,26,19,19,8,8,13,13,31,31,2,2,9,9,0,0,4,4,8,8,10,10,17,17,2,2,11,11,0,0,11,11,0,0,24,24,10,10,27,27,26,26,23,23,4,4,0,0,30,30,25,25,14,14,17,17,10,10,0,0,8,8,12,12,16,16,15,15,12,12,9,9,16,16,25,25,8,8,12,12,16,16,20,20,14,14,3,3,12,12,18,18,5,5,24,24,31,31,17,17,26,26,4,4,10,10,30,30,31,31,25,25,26,26,28,28,24,24,16,16,19,19,13,13,30,30,15,15,19,19,17,17,8,8,8,8,20,20,2,2,18,18,30,30,31,31,30,30,13,13,1,1,17,17,0,0,2,2,3,3,26,26,4,4,9,9,0,0,8,8,29,29,29,29,26,26,19,19,0,0,25,25,13,13,2,2,2,2,2,2,9,9,9,9,5,5,1,1,13,13,7,7,22,22,23,23,24,24,12,12,30,30,0,0,9,9,31,31,31,31,5,5,18,18,14,14,6,6,30,30,29,29,6,6,6,6,24,24,16,16,1,1,3,3,24,24,27,27,9,9,23,23,12,12,3,3,4,4,25,25,11,11,20,20,29,29,28,28,12,12,1,1,1,1,20,20,10,10,18,18,28,28,7,7,7,7,12,12,23,23,9,9,11,11,26,26,9,9,3,3,23,23,0,0,31,31,25,25,21,21,28,28,3,3,24,24,3,3,1,1,18,18,1,1,1,1,25,25,23,23,18,18,16,16,6,6,13,13,24,24,6,6,12,12,16,16,0,0,18,18,2,2,17,17,22,22,14,14,7,7,16,16,14,14,18,18,4,4,16,16,10,10,17,17,16,16,5,5,28,28,25,25,11,11,23,23,7,7,2,2,2,2,29,29,30,30,10,10,30,30,8,8,13,13,8,8,6,6,2,2,2,2,5,5,17,17,0,0,4,4,31,31,4,4,10,10,31,31,11,11,4,4,28,28,0,0,7,7,4,4,0,0,7,7,17,17,16,16,30,30,16,16,12,12,19,19,26,26,16,16,13,13,9,9,2,2,7,7,21,21,23,23,13,13,21,21,16,16,26,26,13,13,25,25,6,6,29,29,11,11,0,0,25,25,1,1,13,13,20,20,15,15,26,26,0,0,12,12,9,9,21,21,6,6,19,19,4,4,15,15,20,20,28,28,29,29,9,9,24,24,5,5,27,27,28,28,28,28,27,27,1,1,8,8,9,9,22,22,28,28,21,21,24,24,9,9,7,7,17,17,3,3,21,21,11,11,26,26,17,17,27,27,19,19,13,13,6,6,28,28,26,26,27,27,29,29,3,3,10,10,19,19,22,22,5,5,13,13,4,4,9,9,12,12,14,14,7,7,6,6,9,9,15,15,28,28,11,11,15,15,8,8,10,10,28,28,13,13,21,21,13,13,8,8,17,17,18,18,18,18,23,23,3,3,29,29,9,9,16,16,23,23,30,30,16,16,31,31,26,26,0,0,11,11,11,11,6,6,6,6,6,6,17,17,17,17,0,0,17,17,1,1,17,17,28,28,26,26,2,2,4,4,4,4,0,0,2,2,2,2,11,11,0,0,9,9,10,10,6,6,12,12,30,30,12,12,22,22,21,21,13,13,27,27,2,2,26,26,28,28,22,22,9,9,19,19,22,22,0,0,19,19,2,2,9,9,29,29,24,24,30,30,0,0,10,10,18,18,5,5,11,11,17,17,13,13,5,5,31,31,20,20,28,28,5,5,26,26,25,25,6,6,24,24,21,21,31,31,20,20,18,18,9,9,2,2,9,9,19,19,19,19,9,9,0,0,2,2,9,9,26,26,7,7,22,22,6,6,13,13,2,2,22,22,3,3,28,28,2,2,2,2,6,6,29,29,1,1,1,1,31,31,24,24,1,1,17,17,19,19,30,30,11,11,9,9,23,23,12,12,26,26,29,29,8,8,28,28,26,26,0,0,1,1,9,9,22,22,8,8,20,20,0,0,30,30,26,26,2,2,17,17,13,13,16,16,9,9,30,30,23,23,31,31,22,22,24,24,6,6,18,18,15,15,4,4,2,2,9,9,0,0,27,27,24,24,16,16,22,22,6,6,19,19,14,14,27,27,13,13,19,19,1,1,12,12,21,21,9,9,7,7,17,17,11,11,23,23,26,26,8,8,26,26,0,0,3,3,21,21,26,26,7,7,6,6,9,9,11,11,29,29,25,25,24,24,18,18,19,19,24,24,17,17,1,1,25,25,25,25,2,2,8,8,8,8,3,3,5,5,19,19,21,21,23,23,7,7,9,9,27,27,8,8,30,30,22,22,22,22,29,29,5,5,3,3,19,19,2,2,2,2,7,7,2,2,16,16,26,26,5,5,0,0,18,18,20,20,19,19,21,21,4,4,15,15,6,6,21,21,14,14,14,14,21,21,20,20,6,6,5,5,12,12,23,23,14,14,12,12,3,3,19,19,22,22,17,17,21,21,13,13,12,12,28,28,29,29,6,6,4,4,5,5,30,30,10,10,15,15,3,3,29,29,13,13,17,17,29,29,17,17,7,7,30,30,18,18,24,24,13,13,11,11,12,12,12,12,1,1,28,28,0,0,0,0,21,21,26,26,4,4,31,31,17,17,23,23,8,8,19,19,31,31,19,19,3,3,4,4,31,31,12,12,16,16,6,6,17,17,14,14,9,9,24,24,17,17,17,17,7,7,13,13,22,22,28,28,27,27,0,0,19,19,9,9,27,27,5,5,4,4,28,28,5,5,24,24,29,29,16,16,22,22,7,7,6,6,29,29,3,3,11,11,1,1,11,11,19,19,23,23,1,1,4,4,9,9,23,23,6,6,15,15,27,27,3,3,8,8,11,11,28,28,12,12,23,23,20,20,13,13,30,30,1,1,12,12,12,12,3,3,8,8,16,16,4,4,28,28,17,17,24,24,24,24,13,13,31,31,7,7,16,16,7,7,17,17,8,8,7,7,21,21,13,13,8,8,23,23,7,7,27,27,23,23,23,23,5,5,17,17,24,24,31,31,14,14,8,8,17,17,11,11,20,20,16,16,17,17,20,20,24,24,7,7,19,19,4,4,16,16,28,28,18,18,7,7,7,7,2,2,26,26,11,11,6,6,22,22,0,0,2,2,5,5,21,21,21,21,31,31,25,25,9,9,29,29,8,8,16,16,6,6,28,28,28,28,22,22,21,21,19,19,23,23,29,29,12,12,19,19,16,16,10,10,24,24,27,27,1,1,20,20,16,16,29,29,3,3,6,6,23,23,6,6,0,0,11,11,5,5,27,27,18,18,6,6,4,4,5,5,25,25,10,10,20,20,3,3,13,13,12,12,23,23,29,29,5,5,0,0,12,12,18,18,3,3,17,17,28,28,11,11,31,31,31,31,29,29,26,26,23,23,10,10,17,17,14,14,30,30,6,6,29,29,14,14,3,3,15,15,6,6,13,13,20,20,3,3,4,4,21,21,6,6,19,19,10,10,20,20,25,25,9,9,10,10,22,22,14,14,22,22,20,20,26,26,29,29,13,13,0,0,21,21,27,27,24,24,1,1,2,2,17,17,4,4,30,30,5,5,7,7,5,5,0,0,0,0,20,20,17,17,1,1,22,22,23,23,25,25,0,0,2,2,31,31,17,17,9,9,8,8,14,14,25,25,30,30,8,8,9,9,3,3,17,17,26,26,25,25,15,15,15,15,13,13,24,24,9,9,12,12,7,7,8,8,30,30,17,17,19,19,3,3,8,8,17,17,2,2,18,18,0,0,15,15,0,0,27,27,16,16,30,30,22,22,11,11,26,26,17,17,11,11,14,14,13,13,1,1,5,5,22,22,22,22,4,4,11,11,27,27,8,8,13,13,20,20,2,2,3,3,14,14,23,23,5,5,19,19,4,4,1,1,17,17,14,14,30,30,6,6,6,6,21,21,6,6,12,12,12,12,5,5,9,9,17,17,1,1,0,0,11,11,4,4,9,9,23,23,5,5,7,7,18,18,22,22,14,14,27,27,16,16,24,24,4,4,31,31,8,8,23,23,13,13,29,29,22,22,27,27,10,10,29,29,13,13,12,12,13,13,7,7,24,24,1,1,17,17,25,25,26,26,16,16,13,13,1,1,6,6,7,7,13,13,20,20,20,20,31,31,19,19,30,30,4,4,4,4,3,3,16,16,16,16,15,15,22,22,2,2,16,16,20,20,31,31,9,9,21,21,27,27,6,6,0,0,12,12,27,27,2,2,7,7,25,25,19,19,2,2,2,2,20,20,6,6,18,18,3,3,1,1,0,0,16,16,9,9,1,1,25,25,9,9,4,4,17,17,26,26,4,4,20,20,5,5,15,15,19,19,25,25,15,15,4,4,5,5,20,20,31,31,29,29,2,2,8,8,1,1,27,27,17,17,0,0,6,6,26,26,27,27,10,10,1,1,6,6,10,10,20,20,31,31,0,0,21,21,31,31,19,19,4,4,3,3,11,11,17,17,3,3,2,2,0,0,10,10,20,20,24,24,8,8,12,12,25,25,0,0,1,1,13,13,20,20,22,22,1,1,13,13,4,4,9,9,5,5,18,18,21,21,22,22,1,1,17,17,22,22,18,18,21,21,29,29,16,16,22,22,7,7,31,31,7,7,7,7,21,21,0,0,23,23,2,2,9,9,26,26,2,2,6,6,26,26,12,12,6,6,23,23,0,0,19,19,17,17,25,25,20,20,19,19,24,24,0,0,5,5,4,4,0,0,4,4,11,11,7,7,18,18,20,20,17,17,0,0,5,5,16,16,22,22,8,8,16,16,11,11,10,10,28,28,7,7,17,17,26,26,24,24,11,11,21,21,4,4,14,14,18,18,1,1,4,4,23,23,24,24,17,17,17,17,29,29,6,6,3,3,14,14,7,7,23,23,23,23,0,0,10,10,6,6,7,7,16,16,9,9,9,9,6,6,11,11,3,3,0,0,13,13,11,11,12,12,15,15,23,23,10,10,10,10,5,5,26,26,15,15,0,0,2,2,16,16,4,4,2,2,31,31,21,21,11,11,2,2,17,17,1,1,28,28,16,16,18,18,18,18,9,9,8,8,2,2,19,19,24,24,3,3,18,18,22,22,13,13,6,6,18,18,16,16,23,23,28,28,14,14,22,22,10,10,26,26,28,28,30,30,5,5,5,5,26,26,12,12,6,6,2,2,10,10,15,15,19,19,13,13,0,0,1,1,10,10,0,0,14,14,12,12,3,3,14,14,15,15,1,1,22,22,29,29,9,9,11,11,7,7,28,28,31,31,28,28,14,14,25,25,22,22,1,1,10,10,7,7,29,29,16,16,3,3,20,20,11,11,6,6,31,31,23,23,13,13,18,18,4,4,19,19,0,0,12,12,14,14,3,3,28,28,31,31,5,5,4,4,22,22,23,23,28,28,13,13,14,14,30,30,14,14,2,2,23,23,29,29,22,22,2,2,24,24,19,19,4,4,21,21,28,28,18,18,4,4,13,13,2,2,2,2,18,18,13,13,23,23,2,2,5,5,28,28,5,5,22,22,1,1,0,0,20,20,30,30,13,13,18,18,31,31,20,20,3,3,25,25,25,25,26,26,7,7,22,22,23,23,18,18,11,11,15,15,26,26,15,15,11,11,15,15,29,29,28,28,20,20,24,24,12,12,0,0,0,0,6,6,23,23,17,17,18,18,27,27,18,18,9,9,1,1,21,21,0,0,25,25,6,6,2,2,9,9,17,17,28,28,2,2,9,9,28,28,5,5,9,9,2,2,2,2,3,3,16,16,30,30,28,28,21,21,20,20,17,17,0,0,16,16,28,28,26,26,18,18,13,13,25,25,21,21,9,9,27,27,14,14,22,22,19,19,23,23,30,30,13,13,3,3,5,5,0,0,10,10,18,18,0,0,13,13,19,19,18,18,25,25,26,26,10,10,6,6,19,19,21,21,6,6,13,13,26,26,0,0,4,4,10,10,4,4,30,30,29,29,0,0,4,4,2,2,25,25,3,3,29,29,17,17,20,20,9,9,2,2,11,11,17,17,16,16,21,21,21,21,21,21,1,1,22,22,1,1,14,14,24,24,20,20,9,9,1,1,26,26,10,10,30,30,8,8,15,15,16,16,24,24,24,24,17,17,23,23,20,20,10,10,26,26,24,24,30,30,31,31,10,10,5,5,30,30,29,29,10,10,1,1,11,11,4,4,11,11,1,1,9,9,21,21,11,11,20,20,26,26,18,18,21,21,28,28,22,22,5,5,11,11,2,2,17,17,8,8,8,8,12,12,22,22,6,6,16,16,13,13,28,28,27,27,29,29,2,2,24,24,25,25,6,6,27,27,4,4,4,4,23,23,7,7,5,5,3,3,20,20,28,28,0,0,29,29,6,6,13,13,17,17,26,26,17,17,19,19,10,10,4,4,9,9,5,5,10,10,3,3,30,30,14,14,14,14,13,13,16,16,0,0,14,14,19,19,6,6,8,8,15,15,28,28,16,16,9,9,20,20,3,3,11,11,16,16,15,15,22,22,17,17,10,10,16,16,29,29,26,26,2,2,5,5,2,2,18,18,12,12,27,27,22,22,9,9,30,30,9,9,12,12,26,26,16,16,7,7,11,11,18,18,16,16,9,9,2,2,18,18,0,0,19,19,18,18,6,6,27,27,20,20,19,19,26,26,9,9,8,8,1,1,15,15,29,29,14,14,31,31,18,18,17,17,9,9,17,17,22,22,23,23,27,27,24,24,17,17,24,24,5,5,29,29,17,17,24,24,21,21,9,9,17,17,7,7,6,6,8,8,1,1,21,21,15,15,19,19,0,0,9,9,16,16,17,17,15,15,28,28,13,13,22,22,15,15,30,30,26,26,28,28,23,23,23,23,4,4,13,13,25,25,24,24,20,20,12,12,13,13,17,17,10,10,26,26,1,1,13,13,9,9,17,17,22,22,30,30,4,4,2,2,20,20,6,6,17,17,10,10,19,19,4,4,30,30,3,3,15,15,24,24,15,15,17,17,21,21,17,17,7,7,17,17,11,11,28,28,30,30,16,16,21,21,17,17,26,26,8,8,1,1,15,15,0,0,31,31,9,9,26,26,11,11,28,28,6,6,13,13,10,10,8,8,9,9,2,2,13,13,12,12,1,1,0,0,4,4,14,14,21,21,14,14,26,26,11,11,21,21,1,1,5,5,0,0,31,31,8,8,20,20,10,10,17,17,28,28,31,31,17,17,20,20,4,4,4,4,16,16,20,20,22,22,23,23,12,12,21,21,12,12,15,15,15,15,3,3,24,24,4,4,0,0,23,23,0,0,2,2,11,11,2,2,16,16,26,26,20,20,5,5,17,17,11,11,10,10,19,19,22,22,1,1,1,1,31,31,11,11,10,10,12,12,19,19,24,24,0,0,17,17,4,4,15,15,22,22,24,24,6,6,6,6,21,21,10,10,11,11,25,25,5,5,28,28,8,8,30,30,5,5,18,18,14,14,20,20,14,14,2,2,8,8,24,24,29,29,20,20,1,1,19,19,21,21,28,28,26,26,8,8,8,8,17,17,17,17,15,15,5,5,27,27,8,8,16,16,13,13,0,0,12,12,31,31,22,22,19,19,24,24,10,10,23,23,26,26,15,15,18,18,10,10,29,29,6,6,24,24,30,30,9,9,10,10,30,30,3,3,9,9,1,1,1,1,1,1,12,12,23,23,4,4,25,25,10,10,23,23,2,2,19,19,11,11,6,6,1,1,23,23,27,27,2,2,12,12,6,6,17,17,24,24,9,9,3,3,30,30,16,16,14,14,30,30,8,8,2,2,0,0,12,12,8,8,25,25,14,14,28,28,4,4,11,11,18,18,26,26,9,9,26,26,19,19,26,26,2,2,14,14,14,14,16,16,6,6,15,15,18,18,27,27,30,30,16,16,20,20,26,26,3,3,26,26,0,0,13,13,21,21,3,3,21,21,17,17,1,1,16,16,17,17,0,0,20,20,2,2,24,24,17,17,20,20,5,5,6,6,24,24,6,6,10,10,3,3,27,27,22,22,9,9,16,16,8,8,20,20,2,2,2,2,21,21,29,29,29,29,6,6,10,10,22,22,25,25,20,20,13,13,19,19,4,4,2,2,3,3,0,0,0,0,22,22,23,23,6,6,1,1,19,19,29,29,12,12,13,13,21,21,14,14,28,28,18,18,9,9,15,15,23,23,0,0,0,0,7,7,1,1,10,10,1,1,15,15,1,1,5,5,27,27,20,20,2,2,1,1,4,4,22,22,6,6,6,6,19,19,13,13,13,13,13,13,19,19,20,20,10,10,1,1,12,12,28,28,8,8,0,0,24,24,9,9,25,25,6,6,11,11,15,15,4,4,2,2,9,9,25,25,7,7,2,2,26,26,4,4,16,16,7,7,0,0,5,5,2,2,20,20,13,13,17,17,2,2,23,23,20,20,1,1,8,8,15,15,5,5,18,18,4,4,8,8,30,30,5,5,12,12,3,3,16,16,28,28,6,6,26,26,0,0,1,1,5,5,15,15,22,22,5,5,19,19,31,31,30,30,13,13,31,31,5,5,3,3,22,22,11,11,9,9,16,16,13,13,1,1,5,5,10,10,10,10,27,27,6,6,21,21,12,12,2,2,18,18,27,27,29,29,1,1,0,0,19,19,16,16,20,20,26,26,16,16,18,18,14,14,28,28,13,13,30,30,16,16,24,24,0,0,17,17,22,22,14,14,19,19,6,6,4,4,15,15,1,1,6,6,30,30,18,18,29,29,11,11,24,24,29,29,9,9,13,13,22,22,19,19,9,9,26,26,7,7,12,12,24,24,20,20,17,17,28,28,10,10,7,7,10,10,16,16,26,26,26,26,11,11,18,18,7,7,1,1,21,21,1,1,20,20,7,7,24,24,25,25,15,15,10,10,6,6,25,25,17,17,17,17,22,22,6,6,3,3,6,6,18,18,30,30,2,2,0,0,8,8,19,19,14,14,27,27,22,22,13,13,8,8,29,29,7,7,17,17,21,21,21,21,18,18,24,24,12,12,0,0,25,25,7,7,28,28,23,23,10,10,29,29,21,21,8,8,17,17,14,14,6,6,16,16,26,26,0,0,18,18,17,17,21,21,8,8,8,8,7,7,19,19,1,1,3,3,8,8,4,4,26,26,4,4,5,5,12,12,16,16,16,16,8,8,2,2,29,29,9,9,17,17,14,14,10,10,31,31,11,11,20,20,6,6,3,3,9,9,4,4,1,1,2,2,27,27,9,9,27,27,6,6,22,22,3,3,16,16,12,12,14,14,19,19,25,25,26,26,30,30,3,3,5,5,6,6,10,10,19,19,29,29,1,1,22,22,22,22,29,29,11,11,25,25,5,5,13,13,9,9,5,5,10,10,26,26,23,23,11,11,6,6,16,16,20,20,11,11,5,5,15,15,28,28,26,26,14,14,24,24,25,25,23,23,1,1,12,12,13,13,30,30,0,0,29,29,11,11,18,18,21,21,20,20,15,15,7,7,20,20,3,3,26,26,1,1,2,2,28,28,15,15,29,29,6,6,13,13,4,4,17,17,1,1,26,26,25,25,5,5,2,2,0,0,3,3,27,27,4,4,11,11,29,29,4,4,29,29,26,26,6,6,7,7,5,5,25,25,6,6,6,6,1,1,7,7,30,30,31,31,18,18,29,29,23,23,28,28,20,20,16,16,3,3,30,30,17,17,13,13,30,30,11,11,26,26,28,28,2,2,20,20,31,31,28,28,30,30,7,7,22,22,20,20,27,27,25,25,8,8,0,0,6,6,4,4,5,5,20,20,10,10,27,27,17,17,9,9,31,31,0,0,0,0,11,11,18,18,26,26,2,2,6,6,3,3,16,16,19,19,0,0,24,24,9,9,0,0,17,17,1,1,16,16,10,10,16,16,6,6,4,4,13,13,4,4,8,8,17,17,10,10,19,19,3,3,4,4,5,5,17,17,11,11,28,28,4,4,7,7,22,22,5,5,8,8,14,14,19,19,9,9,6,6,0,0,2,2,2,2,17,17,19,19,16,16,21,21,17,17,14,14,4,4,3,3,0,0,20,20,4,4,1,1,4,4,25,25,26,26,27,27,21,21,24,24,12,12,8,8,2,2,29,29,1,1,28,28,25,25,20,20,0,0,8,8,30,30,19,19,1,1,8,8,26,26,28,28,18,18,30,30,4,4,27,27,22,22,28,28,28,28,26,26,17,17,18,18,5,5,2,2,24,24,2,2,0,0,28,28,10,10,11,11,5,5,23,23,24,24,11,11,12,12,18,18,2,2,13,13,11,11,8,8,6,6,28,28,10,10,20,20,21,21,8,8,25,25,21,21,31,31,18,18,3,3,25,25,25,25,5,5,19,19,19,19,9,9,7,7,2,2,11,11,13,13,13,13,7,7,25,25,19,19,11,11,30,30,31,31,5,5,2,2,14,14,10,10,31,31,19,19,8,8,30,30,18,18,30,30,10,10,11,11,26,26,20,20,14,14,26,26,23,23,30,30,26,26,1,1,4,4,4,4,12,12,18,18,8,8,26,26,16,16,12,12,4,4,0,0,15,15,27,27,9,9,28,28,1,1,3,3,7,7,26,26,17,17,16,16,24,24,19,19,8,8,18,18,8,8,15,15,16,16,30,30,26,26,19,19,21,21,22,22,28,28,12,12,7,7,25,25,26,26,31,31,14,14,20,20,6,6,7,7,26,26,10,10,26,26,15,15,3,3,8,8,5,5,12,12,26,26,5,5,9,9,16,16,1,1,2,2,10,10,11,11,8,8,24,24,12,12,3,3,11,11,0,0,27,27,7,7,14,14,11,11,16,16,9,9,28,28,12,12,10,10,2,2,3,3,23,23,10,10,10,10,7,7,13,13,31,31,9,9,29,29,4,4,30,30,30,30,8,8,29,29,30,30,9,9,10,10,19,19,15,15,0,0,19,19,9,9,14,14,18,18,13,13,12,12,15,15,16,16,11,11,3,3,9,9,23,23,21,21,6,6,17,17,4,4,26,26,3,3,5,5,13,13,14,14,8,8,0,0,20,20,22,22,18,18,10,10,8,8,6,6,3,3,12,12,7,7,15,15,6,6,6,6,25,25,17,17,23,23,10,10,6,6,10,10,18,18,24,24,21,21,29,29,26,26,30,30,28,28,30,30,9,9,5,5,18,18,15,15,0,0,15,15,14,14,23,23,8,8,15,15,8,8,0,0,27,27,15,15,28,28,30,30,30,30,17,17,24,24,20,20,15,15,7,7,13,13,18,18,12,12,1,1,4,4,12,12,9,9,31,31,27,27,12,12,11,11,28,28,15,15,19,19,30,30,30,30,16,16,10,10,20,20,28,28,12,12,17,17,20,20,31,31,29,29,21,21,7,7,28,28,10,10,5,5,28,28,14,14,4,4,25,25,29,29,1,1,0,0,1,1,18,18,11,11,29,29,0,0,29,29,15,15,15,15,9,9,4,4,26,26,18,18,25,25,3,3,21,21,0,0,20,20,3,3,23,23,26,26,27,27,11,11,27,27,3,3,18,18,21,21,21,21,28,28,13,13,25,25,15,15,10,10,25,25,4,4,14,14,24,24,11,11,31,31,10,10,1,1,15,15,15,15,20,20,20,20,23,23,20,20,0,0,2,2,10,10,13,13,17,17,31,31,5,5,28,28,6,6,14,14,16,16,27,27,15,15,29,29,5,5,26,26,20,20,29,29,11,11,2,2,30,30,26,26,30,30,25,25,7,7,22,22,11,11,13,13,28,28,0,0,2,2,10,10,2,2,7,7,2,2,9,9,8,8,29,29,27,27,0,0,14,14,5,5,25,25,9,9,25,25,19,19,23,23,12,12,3,3,20,20,25,25,29,29,31,31,20,20,15,15,28,28,16,16,25,25,3,3,10,10,16,16,20,20,31,31,5,5,31,31,14,14,14,14,3,3,27,27,10,10,31,31,11,11,21,21,5,5,19,19,14,14,31,31,2,2,3,3,20,20,8,8,18,18,21,21,4,4,25,25,24,24,22,22,29,29,15,15,16,16,14,14,16,16,8,8,11,11,8,8,9,9,24,24,7,7,28,28,20,20,27,27,11,11,23,23,29,29,27,27,1,1,19,19,20,20,19,19,4,4,7,7,10,10,0,0,16,16,20,20,0,0,1,1,17,17,10,10,24,24,10,10,27,27,2,2,20,20,28,28,12,12,9,9,30,30,17,17,25,25,0,0,25,25,14,14,30,30,8,8,22,22,6,6,28,28,20,20,3,3,19,19,26,26,1,1,22,22,24,24,0,0,6,6,24,24,0,0,9,9,16,16,19,19,6,6,18,18,28,28,26,26,14,14,19,19,17,17,25,25,4,4,16,16,20,20,16,16,13,13,2,2,16,16,6,6,17,17,2,2,8,8,8,8,12,12,23,23,0,0,22,22,11,11,18,18,10,10,24,24,23,23,28,28,1,1,18,18,22,22,13,13,13,13,12,12,20,20,19,19,14,14,1,1,31,31,6,6,8,8,28,28,22,22,3,3,18,18,5,5,8,8,30,30,12,12,7,7,23,23,23,23,4,4,3,3,1,1,26,26,16,16,13,13,1,1,23,23,6,6,1,1,25,25,29,29,24,24,18,18,10,10,28,28,12,12,16,16,17,17,3,3,30,30,6,6,4,4,7,7,29,29,4,4,20,20,1,1,8,8,25,25,7,7,19,19,13,13,29,29,2,2,24,24,23,23,9,9,11,11,27,27,24,24,20,20,22,22,21,21,19,19,24,24,18,18,14,14,11,11,21,21,26,26,1,1,27,27,5,5,22,22,10,10,20,20,7,7,17,17,4,4,1,1,0,0,6,6,6,6,28,28,10,10,7,7,13,13,3,3,8,8,7,7,1,1,6,6,22,22,3,3,22,22,26,26,17,17,8,8,18,18,17,17,16,16,7,7,11,11,1,1,15,15,18,18,28,28,8,8,16,16,14,14,28,28,22,22,29,29,14,14,24,24,15,15,18,18,14,14,18,18,6,6,19,19,27,27,20,20,12,12,10,10,22,22,20,20,9,9,23,23,23,23,11,11,18,18,3,3,24,24,15,15,18,18,4,4,31,31,17,17,1,1,16,16,11,11,31,31,1,1,21,21,0,0,13,13,23,23,16,16,27,27,26,26,21,21,4,4,0,0,7,7,10,10,24,24,2,2,5,5,4,4,7,7,2,2,6,6,28,28,4,4,17,17,29,29,4,4,11,11,29,29,27,27,28,28,3,3,30,30,23,23,30,30,1,1,7,7,11,11,19,19,5,5,15,15,28,28,15,15,11,11,26,26,5,5,22,22,13,13,31,31,8,8,10,10,24,24,4,4,13,13,15,15,19,19,24,24,13,13,2,2,22,22,17,17,4,4,11,11,21,21,27,27,23,23,3,3,6,6,0,0,25,25,19,19,24,24,16,16,20,20,6,6,17,17,22,22,5,5,27,27,26,26,28,28,19,19,20,20,9,9,25,25,27,27,15,15,11,11,22,22,2,2,16,16,11,11,2,2,7,7,20,20,7,7,22,22,25,25,1,1,20,20,28,28,31,31,31,31,3,3,24,24,29,29,16,16,7,7,21,21,21,21,9,9,4,4,15,15,12,12,2,2,15,15,6,6,5,5,6,6,25,25,5,5,10,10,11,11,27,27,21,21,9,9,24,24,20,20,5,5,2,2,1,1,12,12,23,23,27,27,11,11,13,13,26,26,22,22,18,18,22,22,7,7,7,7,16,16,17,17,28,28,14,14,11,11,15,15,16,16,11,11,17,17,20,20,21,21,0,0,4,4,26,26,18,18,21,21,2,2,28,28,1,1,13,13,20,20,10,10,0,0,12,12,9,9,24,24,4,4,14,14,9,9,30,30,26,26,31,31,0,0,1,1,7,7,26,26,31,31,24,24,1,1,30,30,3,3,17,17,22,22,8,8,21,21,0,0,10,10,23,23,14,14,3,3,20,20,3,3,8,8,25,25,2,2,16,16,20,20,7,7,7,7,16,16,3,3,20,20,2,2,10,10,4,4,11,11,4,4,6,6,14,14,21,21,12,12,16,16,24,24,11,11,29,29,29,29,30,30,6,6,18,18,3,3,14,14,2,2,16,16,26,26,2,2,23,23,9,9,27,27,16,16,30,30,19,19,12,12,11,11,21,21,20,20,30,30,8,8,21,21,0,0,27,27,10,10,27,27,5,5,21,21,26,26,0,0,29,29,29,29,24,24,30,30,21,21,2,2,27,27,26,26,26,26,0,0,22,22,17,17,5,5,10,10,1,1,12,12,28,28,31,31,25,25,12,12,16,16,3,3,15,15,5,5,1,1,31,31,23,23,8,8,21,21,9,9,23,23,30,30,1,1,1,1,8,8,25,25,30,30,2,2,29,29,29,29,16,16,29,29,20,20,19,19,24,24,9,9,1,1,25,25,16,16,20,20,28,28,3,3,24,24,3,3,4,4,6,6,8,8,4,4,8,8,24,24,18,18,16,16,10,10,3,3,23,23,23,23,2,2,26,26,18,18,20,20,21,21,29,29,18,18,12,12,8,8,27,27,8,8,30,30,4,4,31,31,16,16,30,30,26,26,9,9,28,28,5,5,5,5,1,1,29,29,21,21,18,18,1,1,7,7,22,22,12,12,6,6,15,15,14,14,28,28,16,16,4,4,21,21,17,17,30,30,26,26,2,2,12,12,28,28,25,25,14,14,24,24,26,26,12,12,11,11,5,5,8,8,19,19,3,3,26,26,6,6,21,21,15,15,3,3,8,8,23,23,14,14,13,13,1,1,17,17,9,9,9,9,9,9,2,2,18,18,19,19,14,14,31,31,6,6,27,27,18,18,31,31,10,10,6,6,27,27,25,25,5,5,23,23,30,30,0,0,12,12,9,9,3,3,19,19,3,3,3,3,6,6,28,28,28,28,16,16,16,16,4,4,15,15,31,31,30,30,0,0,6,6,3,3,28,28,27,27,30,30,4,4,5,5,26,26,4,4,19,19,16,16,30,30,8,8,23,23,31,31,12,12,28,28,17,17,31,31,20,20,26,26,2,2,8,8,12,12,4,4,18,18,20,20,12,12,21,21,23,23,10,10,23,23,30,30,21,21,13,13,6,6,13,13,22,22,19,19,6,6,15,15,6,6,22,22,16,16,7,7,18,18,21,21,10,10,3,3,3,3,3,3,21,21,25,25,11,11,1,1,31,31,2,2,21,21,2,2,15,15,4,4,18,18,1,1,17,17,18,18,5,5,9,9,26,26,18,18,5,5,20,20,6,6,4,4,9,9,31,31,1,1,12,12,1,1,6,6,18,18,0,0,2,2,7,7,15,15,19,19,3,3,29,29,17,17,31,31,2,2,1,1,4,4,15,15,20,20,6,6,14,14,17,17,6,6,28,28,14,14,29,29,31,31,24,24,27,27,3,3,3,3,21,21,0,0,6,6,19,19,5,5,3,3,9,9,12,12,4,4,11,11,11,11,24,24,17,17,19,19,21,21,12,12,31,31,2,2,7,7,3,3,13,13,26,26,8,8,24,24,0,0,10,10,5,5,11,11,9,9,18,18,13,13,28,28,15,15,5,5,17,17,17,17,24,24,19,19,14,14,0,0,20,20,17,17,8,8,19,19,25,25,1,1,8,8,17,17,8,8,0,0,7,7,17,17,30,30,7,7,30,30,3,3,15,15,26,26,13,13,23,23,7,7,3,3,9,9,21,21,17,17,19,19,16,16,13,13,3,3,21,21,22,22,16,16,25,25,27,27,5,5,9,9,27,27,9,9,19,19,3,3,27,27,12,12,30,30,22,22,3,3,21,21,13,13,14,14,27,27,20,20,2,2,20,20,3,3,15,15,0,0,0,0,8,8,24,24,16,16,9,9,29,29,19,19,1,1,31,31,17,17,18,18,10,10,26,26,6,6,5,5,24,24,26,26,13,13,25,25,18,18,11,11,9,9,1,1,6,6,28,28,4,4,24,24,6,6,15,15,6,6,14,14,3,3,30,30,11,11,17,17,13,13,13,13,14,14,22,22,29,29,17,17,21,21,23,23,20,20,4,4,23,23,9,9,12,12,3,3,4,4,16,16,14,14,30,30,29,29,26,26,9,9,23,23,26,26,18,18,4,4,1,1,25,25,10,10,18,18,23,23,29,29,31,31,15,15,25,25,16,16,27,27,8,8,14,14,13,13,3,3,10,10,7,7,16,16,24,24,31,31,1,1,19,19,5,5,18,18,0,0,14,14,9,9,4,4,2,2,6,6,23,23,11,11,8,8,18,18,14,14,14,14,0,0,7,7,25,25,7,7,18,18,18,18,25,25,20,20,25,25,0,0,4,4,6,6,7,7,29,29,8,8,26,26,20,20,12,12,10,10,4,4,24,24,17,17,16,16,22,22,17,17,16,16,22,22,20,20,12,12,17,17,14,14,10,10,25,25,4,4,5,5,29,29,15,15,28,28,10,10,7,7,10,10,23,23,6,6,2,2,12,12,24,24,15,15,0,0,13,13,4,4,13,13,11,11,23,23,3,3,10,10,19,19,13,13,22,22,31,31,3,3,24,24,17,17,18,18,24,24,24,24,14,14,21,21,17,17,8,8,6,6,11,11,28,28,28,28,11,11,0,0,5,5,29,29,19,19,24,24,0,0,30,30,5,5,7,7,17,17,1,1,14,14,1,1,21,21,24,24,24,24,18,18,6,6,7,7,20,20,2,2,22,22,26,26,16,16,18,18,11,11,27,27,29,29,2,2,30,30,3,3,16,16,4,4,19,19,3,3,24,24,12,12,17,17,27,27,12,12,11,11,16,16,6,6,11,11,10,10,27,27,13,13,7,7,22,22,0,0,12,12,31,31,31,31,8,8,3,3,15,15,24,24,27,27,23,23,24,24,25,25,29,29,15,15,31,31,20,20,31,31,22,22,20,20,30,30,20,20,26,26,0,0,10,10,7,7,28,28,12,12,4,4,3,3,24,24,22,22,19,19,12,12,26,26,2,2,2,2,18,18,21,21,20,20,14,14,24,24,10,10,14,14,31,31,14,14,4,4,28,28,18,18,7,7,24,24,8,8,7,7,12,12,15,15,14,14,13,13,8,8,18,18,24,24,30,30,22,22,4,4,31,31,18,18,23,23,4,4,10,10,29,29,17,17,8,8,24,24,22,22,2,2,0,0,13,13,13,13,22,22,0,0,10,10,5,5,23,23,26,26,17,17,13,13,17,17,22,22,31,31,22,22,1,1,7,7,28,28,28,28,19,19,10,10,5,5,23,23,4,4,19,19,13,13,19,19,31,31,19,19,9,9,23,23,11,11,12,12,28,28,17,17,19,19,1,1,18,18,2,2,29,29,7,7,17,17,12,12,24,24,0,0,13,13,12,12,3,3,13,13,10,10,28,28,28,28,27,27,19,19,11,11,4,4,23,23,8,8,19,19,7,7,15,15,19,19,20,20,28,28,1,1,11,11,20,20,29,29,29,29,8,8,16,16,7,7,21,21,16,16,12,12,28,28,16,16,9,9,16,16,7,7,9,9,29,29,8,8,7,7,10,10,14,14,20,20,4,4,15,15,22,22,22,22,6,6,0,0,26,26,19,19,11,11,28,28,9,9,7,7,2,2,14,14,6,6,18,18,21,21,27,27,6,6,21,21,13,13,27,27,20,20,4,4,5,5,4,4,29,29,9,9,21,21,11,11,12,12,13,13,31,31,14,14,30,30,22,22,10,10,20,20,19,19,0,0,20,20,18,18,27,27,6,6,30,30,15,15,16,16,20,20,30,30,27,27,21,21,12,12,1,1,9,9,11,11,23,23,20,20,25,25,11,11,20,20,10,10,20,20,21,21,24,24,14,14,18,18,31,31,3,3,17,17,26,26,24,24,7,7,29,29,4,4,29,29,12,12,10,10,27,27,23,23,5,5,14,14,25,25,12,12,4,4,9,9,24,24,28,28,7,7,22,22,26,26,6,6,18,18,30,30,30,30,9,9,31,31,5,5,12,12,8,8,17,17,10,10,28,28,16,16,10,10,17,17,7,7,5,5,25,25,24,24,9,9,16,16,20,20,13,13,29,29,24,24,1,1,24,24,26,26,10,10,12,12,9,9,15,15,16,16,19,19,12,12,5,5,15,15,16,16,4,4,10,10,0,0,20,20,25,25,21,21,21,21,8,8,31,31,26,26,8,8,16,16,17,17,29,29,6,6,17,17,27,27,28,28,6,6,14,14,5,5,14,14,28,28,14,14,29,29,12,12,23,23,22,22,2,2,10,10,30,30,6,6,4,4,12,12,17,17,22,22,25,25,3,3,21,21,2,2,6,6,25,25,3,3,13,13,3,3,12,12,21,21,24,24,23,23,6,6,13,13,19,19,19,19,31,31,27,27,9,9,18,18,17,17,8,8,23,23,25,25,11,11,8,8,20,20,22,22,17,17,5,5,26,26,25,25,27,27,23,23,22,22,18,18,28,28,7,7,29,29,17,17,1,1,31,31,3,3,2,2,27,27,16,16,5,5,15,15,24,24,17,17,30,30,12,12,9,9,29,29,0,0,23,23,4,4,18,18,24,24,26,26,9,9,20,20,29,29,11,11,3,3,21,21,26,26,30,30,13,13,15,15,8,8,0,0,6,6,15,15,27,27,25,25,6,6,13,13,17,17,23,23,26,26,8,8,28,28,7,7,21,21,23,23,28,28,26,26,29,29,30,30,26,26,0,0,15,15,6,6,9,9,19,19,10,10,3,3,1,1,8,8,10,10,31,31,12,12,15,15,18,18,4,4,8,8,22,22,30,30,16,16,23,23,29,29,2,2,19,19,23,23,11,11,25,25,14,14,20,20,1,1,8,8,26,26,22,22,28,28,30,30,5,5,1,1,20,20,26,26,4,4,17,17,23,23,9,9,12,12,13,13,17,17,25,25,22,22,10,10,17,17,7,7,15,15,29,29,22,22,23,23,16,16,0,0,16,16,16,16,6,6,29,29,0,0,1,1,27,27,29,29,0,0,17,17,27,27,13,13,15,15,0,0,19,19,16,16,19,19,10,10,16,16,2,2,13,13,26,26,16,16,10,10,10,10,6,6,1,1,23,23,30,30,12,12,4,4,21,21,4,4,4,4,31,31,1,1,17,17,28,28,21,21,14,14,26,26,30,30,24,24,5,5,0,0,17,17,20,20,4,4,2,2,11,11,30,30,16,16,10,10,1,1,13,13,21,21,0,0,27,27,16,16,31,31,9,9,12,12,29,29,20,20,5,5,23,23,29,29,26,26,1,1,13,13,22,22,17,17,4,4,0,0,9,9,17,17,12,12,24,24,23,23,9,9,25,25,29,29,22,22,9,9,5,5,19,19,6,6,3,3,28,28,3,3,10,10,25,25,0,0,16,16,20,20,0,0,22,22,14,14,11,11,6,6,5,5,23,23,2,2,16,16,21,21,7,7,4,4,30,30,13,13,15,15,19,19,1,1,23,23,4,4,0,0,12,12,2,2,5,5,2,2,0,0,18,18,16,16,1,1,12,12,16,16,1,1,6,6,9,9,22,22,26,26,13,13,3,3,9,9,1,1,31,31,24,24,6,6,27,27,24,24,16,16,12,12,28,28,2,2,15,15,15,15,29,29,19,19,9,9,24,24,0,0,11,11,31,31,21,21,7,7,3,3,12,12,9,9,11,11,18,18,4,4,3,3,10,10,13,13,10,10,12,12,21,21,1,1,31,31,10,10,22,22,17,17,29,29,6,6,24,24,26,26,5,5,18,18,19,19,3,3,1,1,26,26,16,16,21,21,9,9,17,17,7,7,16,16,30,30,0,0,7,7,28,28,11,11,24,24,5,5,0,0,3,3,7,7,24,24,24,24,21,21,22,22,27,27,19,19,13,13,3,3,21,21,26,26,16,16,0,0,12,12,11,11,16,16,29,29,6,6,16,16,30,30,0,0,28,28,30,30,11,11,21,21,30,30,21,21,29,29,24,24,25,25,16,16,11,11,4,4,18,18,6,6,9,9,18,18,20,20,26,26,24,24,14,14,3,3,24,24,14,14,24,24,6,6,25,25,21,21,17,17,9,9,18,18,5,5,13,13,7,7,20,20,27,27,26,26,19,19,15,15,19,19,5,5,17,17,20,20,1,1,4,4,19,19,1,1,21,21,25,25,28,28,2,2,27,27,10,10,7,7,24,24,1,1,11,11,23,23,6,6,8,8,31,31,25,25,0,0,0,0,25,25,28,28,16,16,28,28,14,14,0,0,24,24,24,24,10,10,21,21,10,10,15,15,21,21,11,11,2,2,8,8,4,4,11,11,12,12,28,28,20,20,17,17,0,0,8,8,28,28,1,1,20,20,2,2,20,20,25,25,25,25,14,14,4,4,13,13,11,11,22,22,16,16,3,3,26,26,28,28,11,11,24,24,21,21,0,0,11,11,1,1,17,17,26,26,0,0,2,2,17,17,15,15,20,20,25,25,3,3,20,20,0,0,25,25,24,24,21,21,30,30,7,7,1,1,12,12,20,20,23,23,7,7,24,24,29,29,0,0,1,1,4,4,22,22,27,27,24,24,0,0,0,0,15,15,6,6,25,25,25,25,7,7,18,18,23,23,20,20,17,17,17,17,6,6,17,17,6,6,22,22,16,16,30,30,23,23,13,13,30,30,2,2,25,25,16,16,4,4,30,30,1,1,17,17,26,26,26,26,12,12,13,13,9,9,9,9,6,6,11,11,22,22,2,2,15,15,10,10,28,28,11,11,15,15,22,22,1,1,4,4,7,7,8,8,3,3,7,7,5,5,17,17,15,15,25,25,25,25,21,21,28,28,17,17,13,13,20,20,12,12,26,26,3,3,13,13,17,17,31,31,8,8,4,4,28,28,22,22,18,18,17,17,11,11,17,17,11,11,16,16,20,20,1,1,20,20,19,19,2,2,5,5,23,23,13,13,18,18,21,21,0,0,6,6,2,2,8,8,30,30,30,30,12,12,0,0,31,31,3,3,16,16,21,21,30,30,24,24,13,13,29,29,23,23,27,27,15,15,4,4,30,30,14,14,9,9,15,15,9,9,16,16,25,25,25,25,14,14,21,21,8,8,17,17,16,16,8,8,19,19,26,26,2,2,10,10,13,13,2,2,17,17,14,14,10,10,1,1,6,6,11,11,17,17,20,20,31,31,19,19,9,9,30,30,16,16,21,21,1,1,10,10,10,10,20,20,24,24,12,12,2,2,29,29,26,26,5,5,13,13,14,14,26,26,6,6,20,20,21,21,3,3,3,3,9,9,9,9,28,28,0,0,25,25,28,28,5,5,3,3,9,9,22,22,0,0,10,10,12,12,13,13,7,7,0,0,14,14,20,20,8,8,11,11,27,27,0,0,29,29,13,13,25,25,22,22,19,19,29,29,8,8,17,17,30,30,29,29,2,2,23,23,28,28,28,28,31,31,8,8,1,1,24,24,20,20,24,24,13,13,19,19,8,8,22,22,11,11,1,1,4,4,26,26,7,7,9,9,0,0,24,24,31,31,2,2,19,19,9,9,6,6,9,9,10,10,14,14,5,5,15,15,9,9,27,27,17,17,30,30,14,14,22,22,0,0,13,13,29,29,3,3,15,15,26,26,27,27,16,16,19,19,31,31,4,4,25,25,0,0,20,20,18,18,18,18,6,6,8,8,16,16,30,30,27,27,29,29,15,15,17,17,22,22,31,31,2,2,6,6,24,24,13,13,14,14,17,17,9,9,24,24,28,28,15,15,11,11,10,10,22,22,12,12,14,14,3,3,16,16,24,24,22,22,3,3,2,2,29,29,22,22,18,18,0,0,6,6,17,17,3,3,13,13,29,29,3,3,5,5,22,22,20,20,22,22,24,24,15,15,10,10,16,16,28,28,6,6,24,24,16,16,9,9,16,16,6,6,9,9,10,10,21,21,18,18,0,0,9,9,20,20,22,22,17,17,30,30,7,7,22,22,26,26,10,10,2,2,26,26,13,13,29,29,22,22,1,1,29,29,12,12,10,10,4,4,5,5,13,13,31,31,25,25,5,5,12,12,4,4,17,17,14,14,6,6,12,12,17,17,30,30,25,25,29,29,15,15,3,3,12,12,1,1,2,2,31,31,10,10,0,0,19,19,8,8,28,28,14,14,0,0,1,1,5,5,2,2,24,24,27,27,21,21,9,9,0,0,9,9,0,0,10,10,12,12,30,30,28,28,9,9,29,29,25,25,12,12,23,23,2,2,27,27,18,18,13,13,15,15,26,26,13,13,26,26,24,24,16,16,1,1,25,25,22,22,16,16,25,25,1,1,5,5,2,2,22,22,6,6,14,14,21,21,16,16,25,25,12,12,8,8,10,10,31,31,7,7,7,7,23,23,21,21,13,13,23,23,23,23,16,16,27,27,24,24,8,8,31,31,21,21,25,25,29,29,28,28,25,25,17,17,4,4,4,4,0,0,3,3,8,8,30,30,18,18,17,17,19,19,31,31,11,11,17,17,11,11,2,2,16,16,13,13,2,2,16,16,27,27,25,25,6,6,10,10,14,14,1,1,5,5,0,0,14,14,23,23,21,21,23,23,16,16,7,7,1,1,16,16,2,2,13,13,19,19,25,25,4,4,3,3,19,19,4,4,24,24,24,24,7,7,19,19,0,0,31,31,3,3,25,25,28,28,19,19,25,25,29,29,16,16,22,22,21,21,28,28,7,7,2,2,6,6,5,5,17,17,10,10,2,2,3,3,3,3,8,8,19,19,22,22,19,19,28,28,3,3,30,30,19,19,29,29,24,24,19,19,3,3,14,14,24,24,18,18,0,0,15,15,18,18,9,9,28,28,26,26,20,20,19,19,8,8,17,17,0,0,12,12,24,24,25,25,18,18,13,13,3,3,31,31,6,6,0,0,1,1,26,26,3,3,6,6,21,21,8,8,0,0,5,5,24,24,6,6,23,23,31,31,6,6,31,31,3,3,13,13,10,10,31,31,12,12,11,11,28,28,5,5,1,1,14,14,10,10,2,2,11,11,24,24,7,7,17,17,24,24,2,2,25,25,4,4,12,12,25,25,15,15,30,30,1,1,8,8,10,10,31,31,20,20,4,4,11,11,10,10,15,15,20,20,11,11,21,21,28,28,24,24,20,20,24,24,20,20,10,10,28,28,27,27,18,18,0,0,15,15,8,8,7,7,2,2,1,1,31,31,26,26,19,19,10,10,25,25,10,10,26,26,8,8,1,1,9,9,6,6,11,11,1,1,14,14,25,25,13,13,21,21,12,12,22,22,18,18,17,17,0,0,7,7,23,23,19,19,9,9,17,17,27,27,31,31,12,12,12,12,30,30,7,7,1,1,26,26,28,28,25,25,1,1,2,2,3,3,23,23,1,1,30,30,22,22,15,15,3,3,26,26,7,7,8,8,11,11,20,20,23,23,2,2,11,11,28,28,12,12,3,3,5,5,10,10,22,22,23,23,12,12,4,4,12,12,27,27,23,23,12,12,3,3,9,9,25,25,14,14,25,25,0,0,26,26,3,3,10,10,25,25,8,8,1,1,2,2,30,30,5,5,20,20,29,29,20,20,1,1,31,31,4,4,22,22,10,10,28,28,6,6,18,18,20,20,4,4,26,26,24,24,2,2,25,25,11,11,25,25,9,9,29,29,0,0,30,30,12,12,26,26,25,25,27,27,31,31,28,28,12,12,15,15,25,25,4,4,28,28,11,11,8,8,16,16,23,23,4,4,2,2,10,10,23,23,28,28,6,6,6,6,0,0,2,2,3,3,8,8,12,12,7,7,25,25,25,25,10,10,16,16,10,10,29,29,2,2,2,2,12,12,16,16,4,4,12,12,0,0,7,7,23,23,23,23,1,1,30,30,15,15,26,26,24,24,27,27,27,27,24,24,4,4,11,11,23,23,11,11,7,7,6,6,18,18,0,0,3,3,1,1,2,2,24,24,12,12,3,3,25,25,3,3,25,25,21,21,22,22,10,10,23,23,2,2,4,4,31,31,19,19,25,25,0,0,27,27,14,14,25,25,27,27,14,14,13,13,29,29,24,24,23,23,18,18,28,28,15,15,19,19,21,21,1,1,24,24,29,29,9,9,27,27,5,5,6,6,20,20,7,7,11,11,22,22,22,22,29,29,14,14,2,2,24,24,17,17,0,0,21,21,28,28,19,19,13,13,13,13,6,6,0,0,21,21,2,2,16,16,8,8,26,26,21,21,0,0,27,27,11,11,15,15,22,22,4,4,31,31,22,22,0,0,7,7,17,17,15,15,22,22,2,2,3,3,21,21,26,26,17,17,12,12,0,0,28,28,5,5,7,7,26,26,30,30,14,14,1,1,7,7,21,21,11,11,9,9,6,6,22,22,3,3,19,19,13,13,18,18,0,0,25,25,2,2,20,20,31,31,26,26,8,8,17,17,22,22,16,16,1,1,3,3,30,30,17,17,8,8,17,17,24,24,9,9,7,7,1,1,6,6,0,0,10,10,19,19,4,4,5,5,25,25,10,10,1,1,10,10,22,22,2,2,27,27,20,20,4,4,24,24,4,4,15,15,3,3,4,4,6,6,2,2,29,29,7,7,8,8,31,31,12,12,27,27,9,9,14,14,30,30,1,1,23,23,26,26,25,25,5,5,12,12,0,0,25,25,22,22,4,4,0,0,3,3,0,0,26,26,2,2,28,28,16,16,14,14,21,21,24,24,18,18,5,5,31,31,13,13,24,24,19,19,28,28,2,2,0,0,3,3,19,19,21,21,5,5,10,10,16,16,28,28,18,18,25,25,23,23,2,2,5,5,20,20,18,18,24,24,11,11,25,25,9,9,3,3,13,13,2,2,26,26,0,0,13,13,4,4,24,24,29,29,24,24,21,21,0,0,28,28,16,16,14,14,28,28,9,9,25,25,20,20,1,1,4,4,18,18,9,9,5,5,11,11,11,11,4,4,3,3,16,16,12,12,1,1,11,11,11,11,21,21,8,8,14,14,7,7,12,12,12,12,27,27,20,20,4,4,30,30,25,25,17,17,3,3,31,31,14,14,11,11,29,29,1,1,12,12,5,5,21,21,28,28,31,31,8,8,21,21,24,24,27,27,24,24,2,2,29,29,5,5,6,6,12,12,18,18,25,25,5,5,8,8,9,9,16,16,6,6,19,19,25,25,19,19,24,24,11,11,17,17,14,14,8,8,26,26,13,13,4,4,27,27,10,10,3,3,4,4,30,30,1,1,24,24,8,8,28,28,17,17,8,8,17,17,9,9,16,16,0,0,27,27,7,7,15,15,8,8,13,13,23,23,10,10,13,13,9,9,29,29,28,28,14,14,27,27,10,10,13,13,2,2,1,1,28,28,5,5,10,10,9,9,12,12,12,12,1,1,28,28,25,25,4,4,27,27,26,26,8,8,29,29,16,16,2,2,2,2,17,17,28,28,27,27,5,5,8,8,17,17,12,12,30,30,2,2,17,17,1,1,13,13,12,12,21,21,11,11,12,12,2,2,19,19,27,27,17,17,31,31,1,1,17,17,16,16,13,13,12,12,27,27,19,19,10,10,15,15,24,24,25,25,18,18,21,21,24,24,0,0,29,29,10,10,5,5,30,30,26,26,23,23,20,20,28,28,18,18,25,25,10,10,14,14,7,7,7,7,11,11,18,18,30,30,8,8,1,1,4,4,11,11,28,28,10,10,0,0,17,17,24,24,16,16,7,7,17,17,4,4,31,31,20,20,25,25,21,21,1,1,30,30,14,14,20,20,23,23,31,31,24,24,18,18,1,1,27,27,24,24,3,3,18,18,1,1,4,4,3,3,1,1,26,26,4,4,6,6,23,23,14,14,16,16,15,15,20,20,12,12,11,11,9,9,31,31,10,10,23,23,21,21,24,24,8,8,23,23,28,28,28,28,15,15,13,13,14,14,2,2,26,26,0,0,20,20,14,14,12,12,4,4,27,27,16,16,8,8,19,19,22,22,6,6,10,10,2,2,23,23,24,24,27,27,27,27,29,29,10,10,22,22,13,13,6,6,29,29,10,10,14,14,21,21,22,22,19,19,17,17,11,11,24,24,3,3,9,9,0,0,0,0,27,27,5,5,18,18,1,1,1,1,24,24,21,21,16,16,6,6,26,26,19,19,18,18,8,8,30,30,9,9,1,1,0,0,4,4,1,1,26,26,26,26,13,13,30,30,12,12,3,3,4,4,31,31,2,2,8,8,13,13,4,4,10,10,19,19,6,6,4,4,12,12,12,12,21,21,15,15,30,30,10,10,1,1,26,26,24,24,7,7,14,14,1,1,6,6,21,21,22,22,0,0,25,25,1,1,24,24,8,8,17,17,17,17,17,17,29,29,2,2,5,5,20,20,30,30,27,27,13,13,31,31,1,1,16,16,18,18,22,22,16,16,31,31,5,5,5,5,23,23,8,8,30,30,7,7,31,31,5,5,21,21,12,12,29,29,4,4,1,1,12,12,27,27,0,0,7,7,25,25,8,8,21,21,30,30,19,19,2,2,0,0,4,4,16,16,5,5,29,29,16,16,19,19,3,3,21,21,3,3,28,28,14,14,2,2,13,13,13,13,5,5,6,6,4,4,3,3,27,27,12,12,12,12,11,11,22,22,20,20,30,30,31,31,24,24,8,8,10,10,22,22,15,15,23,23,27,27,10,10,10,10,25,25,31,31,3,3,24,24,11,11,2,2,8,8,8,8,25,25,1,1,7,7,16,16,29,29,29,29,18,18,0,0,3,3,2,2,7,7,22,22,26,26,13,13,25,25,19,19,29,29,28,28,1,1,11,11,17,17,20,20,7,7,24,24,21,21,9,9,23,23,16,16,15,15,1,1,24,24,9,9,17,17,1,1,4,4,0,0,7,7,8,8,23,23,21,21,28,28,16,16,25,25,24,24,18,18,23,23,16,16,5,5,17,17,8,8,13,13,5,5,24,24,25,25,7,7,14,14,6,6,31,31,14,14,11,11,17,17,6,6,4,4,20,20,19,19,11,11,20,20,21,21,0,0,5,5,6,6,20,20,11,11,26,26,0,0,10,10,29,29,0,0,12,12,21,21,6,6,12,12,4,4,31,31,26,26,30,30,16,16,10,10,29,29,3,3,24,24,8,8,8,8,25,25,8,8,31,31,29,29,29,29,8,8,22,22,2,2,28,28,15,15,27,27,28,28,9,9,9,9,20,20,1,1,0,0,9,9,12,12,10,10,4,4,10,10,6,6,30,30,10,10,17,17,29,29,6,6,2,2,19,19,2,2,10,10,14,14,13,13,18,18,17,17,30,30,6,6,23,23,7,7,12,12,14,14,11,11,13,13,11,11,31,31,1,1,24,24,4,4,27,27,25,25,6,6,3,3,24,24,30,30,24,24,3,3,0,0,10,10,25,25,8,8,9,9,26,26,24,24,19,19,4,4,5,5,17,17,6,6,26,26,5,5,6,6,12,12,4,4,19,19,10,10,4,4,14,14,15,15,11,11,0,0,18,18,11,11,27,27,8,8,1,1,2,2,22,22,28,28,9,9,23,23,26,26,11,11,26,26,13,13,26,26,2,2,14,14,9,9,28,28,26,26,10,10,7,7,31,31,2,2,6,6,3,3,8,8,26,26,6,6,31,31,13,13,4,4,3,3,20,20,4,4,24,24,11,11,9,9,25,25,16,16,16,16,11,11,14,14,4,4,25,25,1,1,18,18,14,14,25,25,24,24,12,12,21,21,28,28,11,11,2,2,30,30,20,20,14,14,20,20,23,23,9,9,2,2,6,6,25,25,29,29,11,11,19,19,12,12,20,20,1,1,9,9,26,26,3,3,12,12,14,14,27,27,23,23,27,27,28,28,20,20,4,4,0,0,21,21,29,29,22,22,24,24,24,24,22,22,20,20,19,19,25,25,21,21,23,23,12,12,26,26,22,22,25,25,28,28,11,11,8,8,25,25,4,4,4,4,27,27,3,3,8,8,27,27,31,31,19,19,21,21,7,7,26,26,15,15,23,23,16,16,28,28,22,22,9,9,15,15,23,23,26,26,13,13,9,9,31,31,13,13,10,10,22,22,30,30,19,19,5,5,24,24,29,29,8,8,25,25,4,4,4,4,17,17,19,19,19,19,0,0,19,19,7,7,6,6,8,8,25,25,28,28,31,31,23,23,30,30,6,6,24,24,14,14,28,28,29,29,26,26,20,20,31,31,7,7,21,21,1,1,4,4,22,22,4,4,8,8,1,1,31,31,22,22,14,14,2,2,21,21,15,15,15,15,5,5,18,18,4,4,2,2,28,28,3,3,10,10,25,25,28,28,24,24,26,26,6,6,30,30,1,1,2,2,9,9,24,24,4,4,4,4,25,25,3,3,24,24,20,20,8,8,0,0,7,7,2,2,11,11,5,5,13,13,2,2,13,13,29,29,4,4,6,6,5,5,3,3,25,25,1,1,9,9,6,6,17,17,17,17,7,7,27,27,28,28,4,4,3,3,29,29,4,4,6,6,26,26,22,22,2,2,12,12,8,8,9,9,24,24,19,19,10,10,20,20,14,14,3,3,23,23,20,20,20,20,28,28,17,17,3,3,0,0,3,3,6,6,8,8,4,4,11,11,11,11,21,21,26,26,19,19,21,21,19,19,0,0,8,8,14,14,29,29,28,28,22,22,17,17,12,12,31,31,5,5,31,31,9,9,14,14,30,30,7,7,12,12,28,28,22,22,2,2,12,12,4,4,26,26,6,6,4,4,18,18,0,0,13,13,13,13,27,27,12,12,30,30,2,2,26,26,24,24,15,15,27,27,26,26,0,0,22,22,5,5,31,31,9,9,24,24,21,21,6,6,16,16,23,23,14,14,21,21,31,31,14,14,21,21,18,18,13,13,1,1,21,21,21,21,14,14,9,9,7,7,14,14,4,4,12,12,13,13,6,6,12,12,24,24,21,21,3,3,25,25,0,0,5,5,20,20,24,24,18,18,17,17,11,11,11,11,22,22,11,11,0,0,8,8,20,20,29,29,25,25,20,20,8,8,13,13,10,10,26,26,6,6,2,2,9,9,11,11,12,12,23,23,30,30,5,5,3,3,23,23,15,15,25,25,15,15,1,1,3,3,28,28,1,1,31,31,18,18,24,24,6,6,0,0,15,15,5,5,27,27,6,6,2,2,24,24,29,29,11,11,15,15,27,27,0,0,17,17,26,26,20,20,5,5,12,12,9,9,8,8,17,17,31,31,16,16,22,22,28,28,6,6,11,11,9,9,4,4,7,7,3,3,12,12,10,10,3,3,8,8,25,25,31,31,15,15,6,6,9,9,20,20,7,7,2,2,26,26,23,23,17,17,18,18,13,13,17,17,7,7,10,10,12,12,8,8,12,12,13,13,10,10,8,8,21,21,30,30,25,25,5,5,28,28,19,19,30,30,8,8,11,11,2,2,5,5,29,29,16,16,7,7,21,21,22,22,10,10,31,31,16,16,30,30,15,15,22,22,0,0,14,14,25,25,31,31,5,5,17,17,5,5,31,31,11,11,6,6,25,25,11,11,8,8,0,0,0,0,4,4,4,4,16,16,21,21,16,16,25,25,5,5,26,26,16,16,11,11,11,11,6,6,3,3,16,16,2,2,14,14,11,11,26,26,24,24,25,25,12,12,30,30,12,12,14,14,10,10,18,18,26,26,13,13,19,19,30,30,28,28,2,2,6,6,18,18,11,11,28,28,20,20,16,16,1,1,27,27,3,3,8,8,14,14,29,29,20,20,24,24,15,15,8,8,30,30,22,22,11,11,4,4,4,4,0,0,31,31,20,20,12,12,14,14,23,23,11,11,23,23,21,21,23,23,9,9,6,6,2,2,11,11,19,19,6,6,23,23,30,30,16,16,2,2,25,25,28,28,19,19,3,3,17,17,31,31,16,16,1,1,1,1,2,2,0,0,20,20,28,28,8,8,3,3,2,2,28,28,4,4,24,24,23,23,9,9,24,24,30,30,14,14,0,0,13,13,7,7,16,16,5,5,4,4,23,23,9,9,12,12,6,6,18,18,13,13,9,9,4,4,27,27,29,29,3,3,31,31,10,10,6,6,3,3,22,22,20,20,30,30,16,16,21,21,28,28,25,25,7,7,28,28,5,5,19,19,19,19,4,4,0,0,7,7,4,4,16,16,29,29,6,6,2,2,27,27,0,0,16,16,24,24,31,31,26,26,7,7,17,17,22,22,4,4,18,18,16,16,11,11,4,4,10,10,9,9,31,31,11,11,15,15,28,28,26,26,16,16,6,6,0,0,23,23,5,5,0,0,8,8,9,9,12,12,6,6,21,21,5,5,2,2,10,10,16,16,5,5,27,27,7,7,19,19,18,18,28,28,11,11,9,9,31,31,2,2,23,23,7,7,2,2,9,9,15,15,2,2,30,30,24,24,11,11,7,7,28,28,4,4,19,19,8,8,17,17,6,6,28,28,21,21,4,4,4,4,12,12,2,2,30,30,28,28,13,13,27,27,16,16,3,3,21,21,30,30,12,12,18,18,13,13,11,11,4,4,9,9,24,24,15,15,8,8,2,2,8,8,26,26,13,13,28,28,19,19,13,13,20,20,18,18,9,9,0,0,30,30,1,1,24,24,15,15,11,11,9,9,23,23,6,6,22,22,26,26,14,14,2,2,5,5,18,18,3,3,2,2,26,26,18,18,1,1,3,3,7,7,24,24,3,3,25,25,26,26,9,9,8,8,12,12,21,21,17,17,25,25,3,3,6,6,21,21,8,8,12,12,4,4,8,8,17,17,27,27,19,19,26,26,1,1,3,3,10,10,29,29,16,16,18,18,14,14,21,21,0,0,1,1,24,24,20,20,29,29,6,6,18,18,7,7,19,19,4,4,14,14,0,0,7,7,7,7,27,27,27,27,2,2,27,27,23,23,27,27,28,28,22,22,22,22,30,30,2,2,17,17,26,26,19,19,1,1,0,0,15,15,17,17,2,2,9,9,18,18,4,4,25,25,19,19,25,25,30,30,9,9,8,8,0,0,16,16,20,20,31,31,24,24,28,28,10,10,7,7,4,4,8,8,1,1,1,1,26,26,4,4,24,24,21,21,15,15,0,0,4,4,26,26,28,28,9,9,9,9,0,0,7,7,28,28,21,21,5,5,21,21,19,19,4,4,12,12,11,11,14,14,24,24,8,8,13,13,17,17,1,1,0,0,18,18,20,20,9,9,25,25,23,23,27,27,21,21,13,13,23,23,26,26,0,0,10,10,11,11,13,13,23,23,9,9,29,29,0,0,21,21,23,23,21,21,16,16,30,30,1,1,13,13,21,21,28,28,16,16,14,14,5,5,15,15,4,4,2,2,16,16,25,25,14,14,28,28,21,21,27,27,24,24,30,30,22,22,23,23,13,13,29,29,31,31,1,1,9,9,16,16,10,10,26,26,0,0,16,16,26,26,23,23,18,18,23,23,17,17,9,9,21,21,0,0,10,10,0,0,21,21,30,30,30,30,16,16,26,26,2,2,17,17,25,25,15,15,9,9,21,21,26,26,8,8,8,8,1,1,20,20,18,18,12,12,23,23,30,30,17,17,9,9,15,15,1,1,11,11,25,25,30,30,17,17,1,1,20,20,6,6,10,10,6,6,8,8,26,26,12,12,14,14,30,30,16,16,28,28,6,6,0,0,17,17,14,14,14,14,21,21,11,11,17,17,27,27,3,3,8,8,2,2,21,21,23,23,27,27,4,4,28,28,2,2,26,26,25,25,4,4,19,19,31,31,25,25,21,21,17,17,3,3,20,20,8,8,8,8,20,20,23,23,8,8,27,27,18,18,13,13,31,31,27,27,19,19,14,14,9,9,23,23,14,14,1,1,5,5,8,8,25,25,6,6,27,27,1,1,25,25,26,26,19,19,10,10,20,20,26,26,13,13,29,29,27,27,17,17,20,20,9,9,20,20,21,21,24,24,4,4,3,3,29,29,20,20,27,27,10,10,7,7,2,2,0,0,10,10,13,13,9,9,17,17,6,6,29,29,20,20,31,31,27,27,18,18,7,7,20,20,1,1,6,6,24,24,31,31,15,15,0,0,4,4,20,20,4,4,6,6,25,25,10,10,24,24,1,1,2,2,12,12,26,26,24,24,26,26,23,23,10,10,21,21,30,30,0,0,22,22,20,20,6,6,29,29,0,0,2,2,2,2,4,4,5,5,14,14,20,20,21,21,18,18,5,5,14,14,22,22,27,27,4,4,12,12,26,26,15,15,16,16,22,22,22,22,3,3,23,23,12,12,4,4,14,14,20,20,29,29,1,1,22,22,14,14,0,0,6,6,25,25,22,22,3,3,20,20,29,29,29,29,5,5,16,16,20,20,6,6,4,4,13,13,4,4,26,26,9,9,24,24,8,8,12,12,12,12,16,16,10,10,2,2,8,8,10,10,19,19,1,1,5,5,0,0,15,15,14,14,25,25,14,14,25,25,22,22,0,0,17,17,5,5,8,8,10,10,17,17,13,13,5,5,27,27,3,3,25,25,26,26,5,5,3,3,24,24,27,27,29,29,11,11,5,5,25,25,14,14,11,11,15,15,3,3,20,20,24,24,14,14,29,29,10,10,23,23,9,9,29,29,3,3,2,2,22,22,1,1,23,23,30,30,14,14,1,1,1,1,10,10,14,14,10,10,6,6,3,3,9,9,26,26,22,22,16,16,29,29,6,6,13,13,5,5,14,14,29,29,16,16,31,31,0,0,1,1,19,19,28,28,29,29,13,13,22,22,17,17,1,1,20,20,17,17,25,25,11,11,27,27,13,13,12,12,9,9,7,7,21,21,20,20,8,8,13,13,14,14,26,26,21,21,18,18,16,16,0,0,18,18,18,18,5,5,31,31,15,15,10,10,3,3,10,10,17,17,20,20,6,6,14,14,0,0,3,3,31,31,22,22,20,20,0,0,16,16,8,8,30,30,13,13,23,23,17,17,22,22,26,26,20,20,18,18,20,20,6,6,4,4,15,15,14,14,31,31,1,1,28,28,17,17,10,10,22,22,20,20,5,5,6,6,30,30,17,17,14,14,23,23,24,24,17,17,14,14,27,27,25,25,14,14,8,8,4,4,18,18,27,27,28,28,14,14,17,17,29,29,11,11,2,2,19,19,8,8,6,6,14,14,31,31,20,20,9,9,4,4,3,3,17,17,4,4,31,31,26,26,17,17,25,25,12,12,2,2,10,10,17,17,6,6,25,25,10,10,2,2,10,10,0,0,2,2,23,23,0,0,24,24,23,23,6,6,2,2,26,26,8,8,8,8,15,15,5,5,29,29,10,10,10,10,25,25,16,16,22,22,5,5,4,4,2,2,24,24,24,24,16,16,31,31,16,16,5,5,4,4,7,7,3,3,19,19,8,8,29,29,4,4,5,5,22,22,11,11,0,0,23,23,14,14,21,21,21,21,24,24,27,27,14,14,0,0,6,6,4,4,22,22,22,22,26,26,1,1,0,0,20,20,14,14,24,24,8,8,6,6,0,0,21,21,17,17,12,12,4,4,4,4,5,5,3,3,30,30,1,1,16,16,12,12,0,0,19,19,22,22,12,12,0,0,6,6,10,10,17,17,9,9,11,11,14,14,24,24,21,21,10,10,27,27,21,21,23,23,10,10,26,26,1,1,18,18,9,9,1,1,29,29,30,30,9,9,27,27,18,18,1,1,17,17,6,6,15,15,29,29,3,3,6,6,27,27,11,11,7,7,25,25,9,9,5,5,19,19,16,16,1,1,12,12,29,29,16,16,12,12,2,2,22,22,7,7,1,1,3,3,21,21,7,7,18,18,30,30,11,11,5,5,28,28,20,20,4,4,0,0,30,30,11,11,22,22,31,31,20,20,22,22,16,16,31,31,31,31,1,1,19,19,24,24,11,11,12,12,14,14,25,25,2,2,26,26,23,23,0,0,15,15,0,0,21,21,26,26,2,2,2,2,16,16,11,11,5,5,19,19,12,12,14,14,14,14,10,10,11,11,17,17,11,11,9,9,21,21,10,10,14,14,0,0,12,12,24,24,24,24,15,15,25,25,7,7,3,3,6,6,18,18,28,28,8,8,11,11,29,29,6,6,19,19,18,18,5,5,13,13,24,24,2,2,18,18,0,0,1,1,5,5,27,27,21,21,18,18,28,28,7,7,30,30,5,5,22,22,21,21,16,16,31,31,19,19,17,17,4,4,21,21,17,17,17,17,12,12,19,19,4,4,8,8,23,23,19,19,15,15,3,3,4,4,30,30,26,26,9,9,8,8,29,29,0,0,12,12,24,24,15,15,31,31,2,2,9,9,17,17,31,31,27,27,25,25,29,29,28,28,12,12,4,4,10,10,7,7,12,12,27,27,12,12,9,9,22,22,3,3,18,18,0,0,5,5,9,9,29,29,5,5,9,9,30,30,11,11,26,26,1,1,7,7,16,16,1,1,12,12,30,30,29,29,7,7,10,10,12,12,14,14,8,8,8,8,14,14,8,8,10,10,8,8,15,15,25,25,22,22,6,6,27,27,15,15,0,0,31,31,15,15,14,14,2,2,13,13,29,29,28,28,5,5,8,8,12,12,29,29,6,6,0,0,14,14,18,18,30,30,15,15,16,16,3,3,15,15,20,20,4,4,16,16,0,0,5,5,9,9,10,10,13,13,1,1,25,25,3,3,7,7,1,1,31,31,2,2,16,16,13,13,10,10,25,25,12,12,3,3,9,9,15,15,29,29,0,0,11,11,31,31,22,22,14,14,30,30,10,10,6,6,2,2,6,6,21,21,19,19,18,18,28,28,16,16,12,12,4,4,13,13,16,16,6,6,23,23,0,0,11,11,2,2,21,21,12,12,29,29,4,4,12,12,31,31,4,4,11,11,11,11,17,17,10,10,10,10,17,17,7,7,5,5,30,30,15,15,20,20,19,19,28,28,7,7,20,20,3,3,22,22,14,14,16,16,31,31,24,24,1,1,5,5,12,12,17,17,18,18,26,26,28,28,27,27,31,31,0,0,12,12,12,12,22,22,5,5,14,14,3,3,26,26,29,29,14,14,13,13,0,0,20,20,1,1,0,0,1,1,16,16,3,3,11,11,25,25,15,15,13,13,13,13,17,17,26,26,26,26,1,1,10,10,1,1,1,1,4,4,22,22,17,17,29,29,0,0,23,23,14,14,18,18,17,17,11,11,31,31,28,28,3,3,7,7,11,11,23,23,30,30,15,15,6,6,16,16,2,2,26,26,1,1,9,9,1,1,9,9,25,25,29,29,12,12,23,23,1,1,10,10,29,29,18,18,20,20,19,19,10,10,9,9,28,28,6,6,26,26,2,2,15,15,27,27,13,13,20,20,4,4,9,9,11,11,29,29,14,14,26,26,31,31,24,24,2,2,31,31,13,13,8,8,4,4,11,11,1,1,16,16,1,1,24,24,18,18,12,12,26,26,19,19,16,16,8,8,22,22,17,17,8,8,6,6,29,29,22,22,12,12,6,6,23,23,22,22,0,0,8,8,25,25,18,18,0,0,16,16,1,1,9,9,0,0,29,29,7,7,8,8,8,8,19,19,27,27,10,10,14,14,29,29,31,31,8,8,15,15,2,2,4,4,2,2,25,25,12,12,1,1,2,2,18,18,12,12,3,3,9,9,11,11,29,29,11,11,17,17,29,29,17,17,2,2,0,0,9,9,4,4,30,30,8,8,10,10,31,31,11,11,15,15,2,2,2,2,24,24,28,28,15,15,20,20,12,12,1,1,21,21,25,25,29,29,2,2,11,11,10,10,10,10,14,14,29,29,31,31,3,3,27,27,15,15,19,19,0,0,2,2,0,0,9,9,5,5,4,4,23,23,20,20,2,2,19,19,21,21,21,21,30,30,2,2,28,28,8,8,20,20,21,21,13,13,31,31,27,27,18,18,17,17,16,16,2,2,15,15,14,14,9,9,0,0,30,30,19,19,7,7,6,6,30,30,25,25,10,10,16,16,2,2,12,12,20,20,14,14,15,15,29,29,2,2,6,6,16,16,11,11,25,25,24,24,29,29,14,14,31,31,6,6,0,0,9,9,27,27,24,24,16,16,0,0,25,25,11,11,5,5,21,21,27,27,4,4,31,31,0,0,29,29,15,15,13,13,12,12,11,11,28,28,24,24,18,18,25,25,4,4,8,8,17,17,13,13,18,18,16,16,9,9,9,9,25,25,19,19,7,7,7,7,22,22,18,18,26,26,27,27,29,29,28,28,23,23,16,16,14,14,11,11,4,4,25,25,12,12,9,9,3,3,18,18,9,9,11,11,24,24,5,5,0,0,9,9,4,4,3,3,5,5,2,2,11,11,5,5,9,9,14,14,9,9,22,22,29,29,9,9,3,3,26,26,4,4,22,22,24,24,14,14,15,15,21,21,16,16,29,29,13,13,19,19,7,7,31,31,16,16,10,10,11,11,28,28,19,19,5,5,0,0,16,16,14,14,24,24,17,17,9,9,13,13,3,3,2,2,16,16,0,0,28,28,11,11,21,21,16,16,24,24,22,22,22,22,1,1,18,18,18,18,0,0,6,6,24,24,21,21,2,2,18,18,1,1,12,12,6,6,28,28,24,24,22,22,10,10,5,5,24,24,26,26,5,5,10,10,0,0,18,18,27,27,20,20,26,26,16,16,28,28,17,17,7,7,10,10,31,31,5,5,1,1,27,27,2,2,15,15,21,21,8,8,6,6,20,20,23,23,30,30,16,16,31,31,3,3,0,0,21,21,14,14,6,6,5,5,27,27,12,12,4,4,19,19,11,11,15,15,23,23,16,16,15,15,15,15,10,10,4,4,12,12,21,21,2,2,20,20,0,0,12,12,14,14,3,3,13,13,15,15,31,31,1,1,24,24,30,30,24,24,21,21,21,21,12,12,28,28,19,19,12,12,26,26,29,29,8,8,6,6,31,31,29,29,29,29,25,25,26,26,20,20,31,31,3,3,18,18,30,30,8,8,4,4,6,6,12,12,11,11,14,14,25,25,30,30,1,1,2,2,5,5,3,3,14,14,1,1,12,12,14,14,18,18,15,15,16,16,31,31,2,2,7,7,24,24,29,29,10,10,8,8,3,3,1,1,0,0,11,11,15,15,4,4,16,16,8,8,16,16,26,26,6,6,11,11,19,19,26,26,30,30,0,0,7,7,19,19,7,7,30,30,15,15,24,24,28,28,22,22,2,2,3,3,14,14,16,16,2,2,0,0,21,21,20,20,13,13,8,8,20,20,17,17,7,7,31,31,9,9,23,23,25,25,18,18,24,24,26,26,0,0,24,24,11,11,3,3,4,4,31,31,4,4,20,20,14,14,7,7,16,16,17,17,6,6,27,27,1,1,24,24,6,6,8,8,7,7,19,19,13,13,16,16,22,22,0,0,6,6,23,23,8,8,19,19,13,13,19,19,22,22,18,18,7,7,2,2,17,17,7,7,15,15,27,27,5,5,25,25,30,30,30,30,6,6,9,9,18,18,1,1,14,14,10,10,0,0,13,13,27,27,2,2,7,7,16,16,23,23,18,18,11,11,22,22,31,31,13,13,26,26,1,1,23,23,8,8,16,16,7,7,8,8,19,19,17,17,8,8,14,14,12,12,25,25,4,4,21,21,19,19,10,10,20,20,5,5,25,25,17,17,8,8,8,8,21,21,6,6,22,22,29,29,19,19,13,13,31,31,17,17,21,21,1,1,27,27,10,10,4,4,25,25,16,16,26,26,6,6,8,8,18,18,13,13,5,5,11,11,9,9,20,20,30,30,20,20,24,24,0,0,24,24,31,31,3,3,4,4,25,25,13,13,16,16,8,8,16,16,2,2,22,22,14,14,25,25,18,18,7,7,3,3,16,16,28,28,10,10,10,10,4,4,7,7,0,0,28,28,20,20,3,3,9,9,28,28,7,7,31,31,17,17,5,5,23,23,6,6,11,11,3,3,6,6,8,8,16,16,8,8,16,16,28,28,25,25,7,7,4,4,13,13,26,26,23,23,28,28,29,29,18,18,6,6,26,26,25,25,16,16,26,26,0,0,20,20,7,7,26,26,19,19,10,10,17,17,6,6,12,12,10,10,28,28,19,19,24,24,6,6,22,22,20,20,21,21,19,19,17,17,22,22,10,10,14,14,27,27,15,15,12,12,27,27,14,14,13,13,1,1,4,4,18,18,17,17,19,19,24,24,25,25,11,11,6,6,22,22,17,17,31,31,10,10,10,10,15,15,21,21,17,17,0,0,1,1,28,28,29,29,16,16,4,4,31,31,23,23,31,31,24,24,30,30,21,21,16,16,11,11,0,0,12,12,20,20,19,19,2,2,16,16,18,18,24,24,5,5,18,18,0,0,3,3,6,6,4,4,1,1,11,11,8,8,14,14,1,1,22,22,5,5,31,31,13,13,29,29,3,3,19,19,7,7,8,8,14,14,9,9,10,10,24,24,18,18,6,6,30,30,8,8,19,19,21,21,23,23,7,7,7,7,10,10,22,22,22,22,13,13,2,2,12,12,8,8,3,3,16,16,12,12,9,9,25,25,12,12,15,15,17,17,26,26,10,10,19,19,0,0,2,2,11,11,7,7,4,4,30,30,12,12,24,24,4,4,16,16,29,29,25,25,8,8,7,7,17,17,15,15,3,3,8,8,26,26,17,17,8,8,3,3,7,7,28,28,27,27,23,23,23,23,19,19,4,4,28,28,20,20,21,21,17,17,14,14,3,3,1,1,23,23,12,12,0,0,4,4,30,30,13,13,27,27,23,23,16,16,0,0,30,30,3,3,17,17,12,12,28,28,24,24,24,24,9,9,12,12,3,3,5,5,6,6,1,1,5,5,16,16,27,27,20,20,31,31,19,19,3,3,18,18,2,2,30,30,0,0,6,6,24,24,8,8,22,22,11,11,28,28,23,23,5,5,3,3,18,18,2,2,31,31,19,19,20,20,9,9,22,22,0,0,12,12,10,10,13,13,29,29,30,30,0,0,12,12,12,12,10,10,29,29,6,6,28,28,13,13,1,1,31,31,21,21,14,14,13,13,3,3,18,18,23,23,16,16,17,17,10,10,5,5,0,0,10,10,15,15,23,23,0,0,18,18,12,12,11,11,30,30,28,28,17,17,6,6,13,13,6,6,5,5,7,7,25,25,4,4,14,14,2,2,16,16,10,10,8,8,3,3,2,2,8,8,20,20,11,11,7,7,15,15,30,30,16,16,28,28,19,19,8,8,30,30,1,1,18,18,15,15,15,15,0,0,23,23,25,25,3,3,12,12,23,23,9,9,24,24,2,2,31,31,0,0,6,6,16,16,7,7,22,22,9,9,11,11,19,19,14,14,7,7,3,3,31,31,15,15,24,24,6,6,4,4,24,24,7,7,15,15,12,12,21,21,2,2,9,9,14,14,13,13,15,15,3,3,3,3,4,4,5,5,26,26,2,2,14,14,6,6,20,20,28,28,16,16,27,27,7,7,15,15,28,28,20,20,6,6,9,9,2,2,10,10,11,11,11,11,3,3,28,28,27,27,5,5,10,10,3,3,18,18,28,28,5,5,17,17,30,30,20,20,2,2,0,0,30,30,23,23,8,8,31,31,28,28,27,27,31,31,19,19,28,28,29,29,0,0,7,7,20,20,28,28,27,27,3,3,15,15,9,9,22,22,5,5,18,18,22,22,26,26,6,6,5,5,8,8,18,18,26,26,2,2,0,0,9,9,29,29,21,21,29,29,0,0,0,0,18,18,14,14,22,22,28,28,30,30,28,28,28,28,11,11,12,12,27,27,12,12,2,2,10,10,8,8,29,29,7,7,26,26,6,6,8,8,22,22,26,26,18,18,16,16,22,22,25,25,24,24,11,11,11,11,2,2,18,18,21,21,20,20,0,0,10,10,11,11,10,10,23,23,17,17,20,20,18,18,11,11,29,29,22,22,22,22,18,18,16,16,8,8,18,18,21,21,4,4,0,0,15,15,24,24,23,23,6,6,10,10,4,4,3,3,27,27,6,6,24,24,1,1,16,16,29,29,3,3,3,3,24,24,24,24,6,6,26,26,9,9,19,19,31,31,0,0,25,25,18,18,20,20,28,28,20,20,23,23,23,23,26,26,16,16,10,10,1,1,7,7,31,31,29,29,18,18,24,24,11,11,25,25,15,15,20,20,5,5,31,31,22,22,18,18,5,5,2,2,26,26,2,2,27,27,27,27,3,3,1,1,10,10,31,31,8,8,9,9,26,26,15,15,9,9,28,28,16,16,9,9,31,31,23,23,13,13,18,18,3,3,12,12,10,10,28,28,14,14,10,10,17,17,17,17,7,7,13,13,12,12,4,4,18,18,31,31,17,17,15,15,8,8,26,26,5,5,1,1,8,8,25,25,9,9,1,1,2,2,21,21,31,31,22,22,29,29,25,25,14,14,13,13,11,11,18,18,1,1,1,1,3,3,1,1,30,30,12,12,28,28,0,0,25,25,28,28,19,19,18,18,16,16,1,1,14,14,9,9,16,16,29,29,4,4,12,12,17,17,17,17,21,21,30,30,8,8,8,8,18,18,10,10,26,26,4,4,20,20,6,6,3,3,16,16,21,21,16,16,30,30,2,2,2,2,2,2,25,25,18,18,6,6,25,25,25,25,7,7,1,1,6,6,4,4,20,20,15,15,0,0,16,16,4,4,28,28,21,21,10,10,29,29,5,5,16,16,22,22,1,1,3,3,30,30,3,3,5,5,4,4,20,20,7,7,22,22,25,25,22,22,10,10,27,27,5,5,9,9,6,6,31,31,16,16,26,26,26,26,16,16,21,21,14,14,6,6,12,12,7,7,12,12,1,1,14,14,23,23,0,0,9,9,10,10,14,14,4,4,3,3,24,24,5,5,21,21,13,13,29,29,19,19,22,22,25,25,31,31,13,13,9,9,30,30,15,15,28,28,17,17,6,6,19,19,4,4,19,19,8,8,4,4,9,9,14,14,27,27,12,12,22,22,10,10,19,19,23,23,28,28,15,15,16,16,1,1,8,8,12,12,8,8,9,9,8,8,20,20,12,12,18,18,9,9,9,9,27,27,27,27,24,24,4,4,27,27,6,6,28,28,4,4,22,22,1,1,25,25,11,11,31,31,1,1,29,29,26,26,30,30,29,29,16,16,24,24,21,21,0,0,7,7,31,31,9,9,15,15,11,11,26,26,13,13,7,7,8,8,16,16,18,18,4,4,19,19,5,5,14,14,29,29,15,15,18,18,19,19,21,21,28,28,5,5,10,10,1,1,11,11,0,0,3,3,22,22,31,31,5,5,6,6,1,1,29,29,26,26,1,1,3,3,10,10,17,17,2,2,27,27,23,23,30,30,18,18,2,2,11,11,4,4,9,9,28,28,22,22,12,12,8,8,19,19,12,12,21,21,4,4,19,19,27,27,0,0,15,15,11,11,6,6,31,31,18,18,15,15,16,16,17,17,0,0,25,25,5,5,13,13,18,18,19,19,16,16,25,25,7,7,4,4,24,24,5,5,17,17,1,1,17,17,9,9,17,17,12,12,7,7,21,21,28,28,20,20,8,8,28,28,24,24,28,28,26,26,4,4,5,5,30,30,0,0,29,29,12,12,8,8,20,20,12,12,31,31,4,4,13,13,31,31,26,26,14,14,11,11,16,16,5,5,2,2,3,3,28,28,15,15,29,29,6,6,6,6,8,8,7,7,14,14,16,16,4,4,10,10,27,27,25,25,24,24,25,25,9,9,14,14,12,12,10,10,2,2,22,22,14,14,27,27,5,5,15,15,21,21,12,12,30,30,11,11,0,0,26,26,20,20,16,16,27,27,17,17,26,26,14,14,1,1,12,12,8,8,1,1,12,12,2,2,14,14,9,9,16,16,12,12,7,7,4,4,31,31,2,2,20,20,2,2,17,17,14,14,3,3,28,28,16,16,3,3,21,21,16,16,6,6,0,0,20,20,10,10,31,31,1,1,25,25,24,24,6,6,1,1,16,16,4,4,26,26,18,18,29,29,23,23,26,26,14,14,6,6,0,0,8,8,4,4,6,6,24,24,26,26,23,23,29,29,0,0,25,25,8,8,11,11,26,26,28,28,5,5,0,0,2,2,15,15,19,19,6,6,14,14,12,12,0,0,25,25,13,13,11,11,21,21,14,14,18,18,11,11,12,12,11,11,31,31,23,23,16,16,18,18,12,12,25,25,17,17,20,20,27,27,13,13,10,10,16,16,0,0,16,16,1,1,24,24,26,26,1,1,21,21,11,11,19,19,29,29,14,14,9,9,8,8,20,20,21,21,25,25,29,29,4,4,13,13,2,2,3,3,2,2,13,13,7,7,25,25,7,7,19,19,7,7,9,9,1,1,5,5,6,6,11,11,13,13,29,29,28,28,20,20,17,17,11,11,25,25,0,0,8,8,12,12,0,0,30,30,30,30,4,4,28,28,19,19,6,6,6,6,10,10,13,13,2,2,31,31,2,2,16,16,9,9,29,29,7,7,14,14,10,10,12,12,9,9,14,14,25,25,13,13,6,6,27,27,14,14,10,10,22,22,7,7,15,15,16,16,8,8,7,7,20,20,7,7,5,5,16,16,23,23,14,14,20,20,5,5,18,18,24,24,4,4,20,20,27,27,4,4,31,31,21,21,19,19,1,1,5,5,14,14,30,30,27,27,10,10,1,1,8,8,0,0,20,20,17,17,12,12,5,5,24,24,29,29,17,17,23,23,22,22,26,26,3,3,12,12,8,8,7,7,19,19,27,27,18,18,12,12,23,23,24,24,2,2,18,18,0,0,2,2,21,21,13,13,17,17,12,12,8,8,10,10,26,26,19,19,0,0,7,7,7,7,3,3,20,20,1,1,6,6,29,29,6,6,24,24,27,27,11,11,8,8,11,11,17,17,16,16,19,19,31,31,17,17,1,1,0,0,16,16,7,7,27,27,3,3,24,24,3,3,21,21,10,10,20,20,2,2,21,21,16,16,27,27,10,10,7,7,1,1,15,15,3,3,26,26,5,5,20,20,5,5,28,28,0,0,19,19,5,5,20,20,14,14,26,26,14,14,2,2,22,22,30,30,30,30,27,27,26,26,4,4,23,23,12,12,10,10,20,20,5,5,24,24,13,13,14,14,5,5,26,26,4,4,30,30,12,12,10,10,29,29,15,15,26,26,9,9,22,22,2,2,22,22,19,19,15,15,14,14,13,13,7,7,21,21,24,24,12,12,20,20,0,0,30,30,6,6,3,3,29,29,7,7,19,19,22,22,4,4,27,27,9,9,5,5,26,26,22,22,8,8,2,2,11,11,8,8,1,1,12,12,31,31,13,13,17,17,17,17,15,15,11,11,0,0,2,2,13,13,10,10,22,22,2,2,14,14,8,8,25,25,13,13,18,18,31,31,21,21,10,10,4,4,18,18,15,15,2,2,3,3,28,28,27,27,17,17,26,26,11,11,4,4,15,15,20,20,25,25,21,21,24,24,20,20,26,26,19,19,11,11,8,8,20,20,20,20,20,20,2,2,4,4,21,21,18,18,7,7,24,24,14,14,31,31,16,16,1,1,21,21,3,3,30,30,27,27,21,21,16,16,28,28,16,16,0,0,22,22,13,13,8,8,18,18,23,23,4,4,13,13,9,9,20,20,28,28,25,25,12,12,14,14,30,30,8,8,13,13,5,5,12,12,14,14,12,12,17,17,14,14,21,21,30,30,5,5,0,0,23,23,28,28,4,4,4,4,20,20,14,14,29,29,21,21,12,12,29,29,9,9,30,30,19,19,22,22,5,5,23,23,11,11,2,2,0,0,18,18,16,16,0,0,17,17,30,30,0,0,0,0,19,19,4,4,28,28,12,12,10,10,4,4,26,26,30,30,7,7,28,28,25,25,26,26,19,19,29,29,7,7,26,26,6,6,5,5,5,5,20,20,2,2,12,12,21,21,22,22,3,3,0,0,15,15,17,17,29,29,9,9,4,4,11,11,7,7,11,11,27,27,10,10,7,7,13,13,8,8,0,0,0,0,20,20,2,2,7,7,25,25,2,2,24,24,27,27,24,24,26,26,23,23,9,9,19,19,25,25,25,25,22,22,17,17,0,0,25,25,17,17,0,0,12,12,8,8,16,16,25,25,18,18,11,11,1,1,20,20,17,17,30,30,28,28,28,28,18,18,2,2,2,2,30,30,7,7,5,5,22,22,16,16,11,11,24,24,7,7,4,4,24,24,8,8,15,15,18,18,17,17,26,26,31,31,4,4,22,22,16,16,24,24,29,29,4,4,27,27,20,20,0,0,24,24,26,26,14,14,7,7,12,12,11,11,25,25,25,25,8,8,31,31,12,12,3,3,11,11,11,11,8,8,11,11,27,27,6,6,25,25,2,2,20,20,27,27,1,1,1,1,25,25,20,20,11,11,18,18,13,13,5,5,23,23,22,22,30,30,23,23,2,2,29,29,16,16,13,13,30,30,31,31,5,5,0,0,16,16,16,16,17,17,0,0,19,19,10,10,0,0,26,26,7,7,30,30,20,20,19,19,21,21,20,20,16,16,13,13,16,16,14,14,28,28,8,8,0,0,16,16,13,13,6,6,12,12,12,12,19,19,8,8,0,0,5,5,6,6,3,3,31,31,28,28,1,1,15,15,28,28,24,24,30,30,12,12,10,10,2,2,2,2,1,1,5,5,16,16,28,28,12,12,29,29,24,24,11,11,4,4,23,23,28,28,19,19,11,11,25,25,20,20,13,13,3,3,13,13,23,23,3,3,18,18,0,0,21,21,11,11,19,19,9,9,2,2,0,0,20,20,30,30,11,11,23,23,8,8,24,24,2,2,8,8,29,29,29,29,8,8,17,17,22,22,25,25,30,30,27,27,31,31,28,28,20,20,12,12,16,16,19,19,31,31,11,11,27,27,18,18,4,4,1,1,3,3,20,20,28,28,25,25,2,2,5,5,16,16,0,0,3,3,27,27,18,18,24,24,14,14,18,18,17,17,4,4,12,12,29,29,24,24,19,19,6,6,21,21,6,6,6,6,31,31,22,22,4,4,13,13,26,26,8,8,10,10,6,6,15,15,0,0,27,27,2,2,25,25,7,7,1,1,29,29,4,4,19,19,26,26,25,25,29,29,1,1,17,17,9,9,26,26,4,4,22,22,31,31,11,11,20,20,28,28,24,24,28,28,11,11,3,3,0,0,12,12,24,24,16,16,2,2,23,23,19,19,25,25,15,15,4,4,17,17,22,22,4,4,1,1,8,8,28,28,13,13,12,12,15,15,15,15,29,29,2,2,18,18,29,29,26,26,9,9,28,28,0,0,0,0,16,16,5,5,5,5,26,26,24,24,11,11,5,5,7,7,8,8,17,17,29,29,31,31,3,3,12,12,14,14,7,7,16,16,22,22,7,7,7,7,16,16,1,1,17,17,10,10,31,31,15,15,3,3,30,30,7,7,23,23,3,3,16,16,24,24,3,3,4,4,5,5,17,17,31,31,1,1,0,0,28,28,28,28,10,10,12,12,2,2,26,26,8,8,5,5,6,6,28,28,15,15,11,11,17,17,5,5,17,17,26,26,25,25,5,5,29,29,21,21,15,15,24,24,7,7,5,5,1,1,22,22,9,9,5,5,23,23,16,16,16,16,9,9,20,20,17,17,24,24,10,10,4,4,4,4,24,24,12,12,16,16,28,28,13,13,3,3,26,26,10,10,17,17,16,16,14,14,9,9,4,4,13,13,2,2,7,7,16,16,13,13,6,6,11,11,26,26,13,13,1,1,19,19,4,4,28,28,15,15,16,16,0,0,28,28,16,16,15,15,21,21,24,24,24,24,6,6,9,9,30,30,30,30,11,11,17,17,0,0,11,11,26,26,28,28,31,31,17,17,30,30,26,26,4,4,8,8,20,20,14,14,6,6,15,15,6,6,27,27,2,2,13,13,0,0,17,17,12,12,17,17,7,7,15,15,22,22,21,21,0,0,1,1,22,22,31,31,3,3,6,6,24,24,1,1,9,9,3,3,28,28,18,18,14,14,3,3,9,9,3,3,19,19,20,20,9,9,2,2,9,9,30,30,6,6,29,29,7,7,26,26,20,20,13,13,4,4,13,13,18,18,27,27,16,16,13,13,20,20,20,20,0,0,26,26,20,20,25,25,1,1,3,3,0,0,9,9,15,15,27,27,23,23,31,31,15,15,23,23,15,15,9,9,18,18,0,0,21,21,6,6,22,22,1,1,18,18,11,11,13,13,20,20,24,24,14,14,6,6,3,3,8,8,16,16,0,0,25,25,10,10,2,2,28,28,0,0,9,9,12,12,13,13,8,8,7,7,1,1,5,5,11,11,11,11,1,1,7,7,12,12,27,27,10,10,4,4,8,8,20,20,29,29,24,24,0,0,24,24,7,7,6,6,7,7,20,20,2,2,0,0,1,1,5,5,14,14,8,8,22,22,17,17,18,18,14,14,18,18,28,28,17,17,1,1,27,27,24,24,30,30,4,4,7,7,1,1,12,12,12,12,20,20,26,26,13,13,22,22,23,23,10,10,26,26,29,29,6,6,13,13,0,0,24,24,22,22,26,26,1,1,10,10,29,29,6,6,28,28,16,16,13,13,12,12,4,4,25,25,8,8,7,7,26,26,16,16,15,15,14,14,16,16,10,10,11,11,15,15,14,14,4,4,16,16,10,10,25,25,22,22,25,25,15,15,0,0,8,8,16,16,5,5,30,30,21,21,12,12,0,0,8,8,1,1,1,1,23,23,8,8,3,3,7,7,22,22,20,20,6,6,19,19,15,15,5,5,11,11,26,26,3,3,13,13,16,16,2,2,1,1,4,4,17,17,8,8,0,0,11,11,29,29,0,0,8,8,4,4,2,2,14,14,0,0,14,14,17,17,7,7,21,21,19,19,28,28,14,14,24,24,23,23,23,23,17,17,0,0,15,15,30,30,3,3,11,11,24,24,0,0,29,29,18,18,18,18,29,29,23,23,2,2,2,2,10