// This file is part of the FidelityFX SDK.
//
// Copyright (C) 2024 Advanced Micro Devices, Inc.
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files(the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and /or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions :
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// An Owen-scrambled Sobol sequence of 256 samples of 256 dimensions
static const int sobol_256spp_256d[256*256] = {32,226,72,70,57,171,246,75,112,81,109,239,120,101,230,103,103,41,249,86,253,99,132,184,214,147,128,248,17,149,163,17,60,40,169,196,77,79,102,23,250,77,75,151,95,123,234,198,25,26,184,114,230,188,105,18,231,233,175,151,19,174,202,71,84,229,247,148,182,127,92,14,41,112,162,253,35,101,137,30,111,134,95,122,28,2,41,254,181,91,101,188,145,31,166,38,53,193,1,122,99,86,178,36,198,169,113,255,97,221,227,231,29,100,30,141,250,254,16,157,2,220,187,95,181,125,207,187,105,119,156,41,16,194,93,216,227,124,138,90,227,1,88,153,233,69,120,36,19,189,120,4,185,220,185,109,184,96,247,173,210,227,54,3,18,9,139,213,156,57,61,101,37,247,21,201,10,143,11,38,146,18,118,129,95,191,75,207,12,252,238,104,47,39,190,229,31,56,20,127,42,178,100,141,93,222,192,247,186,7,224,161,72,100,87,69,218,44,25,195,185,118,179,123,231,170,96,225,204,52,117,60,3,86,25,143,230,18,11,165,72,188,158,3,66,105,50,200,226,145,227,45,183,62,82,176,191,36,248,191,189,122,96,185,146,166,203,78,144,189,67,174,154,182,86,169,90,236,101,40,71,107,81,93,159,82,75,230,157,191,34,35,235,139,150,193,10,142,217,77,154,249,74,13,196,248,56,154,27,6,242,226,105,94,66,67,145,112,31,145,133,68,21,0,44,212,254,153,183,238,98,102,145,199,100,213,196,52,131,141,216,209,236,122,58,249,188,108,8,206,62,199,207,103,160,247,207,255,101,185,1,113,223,126,182,0,50,93,250,174,194,18,65,111,206,104,156,3,48,195,122,212,10,101,235,200,13,183,173,7,192,3,101,228,84,168,121,241,205,122,115,132,155,242,215,22,236,242,69,35,48,245,3,175,68,57,4,15,226,155,222,140,54,48,80,200,194,149,213,68,225,14,182,122,147,195,69,166,191,17,176,58,222,58,190,70,66,153,196,215,121,123,176,190,161,145,203,121,255,27,207,28,113,22,44,232,46,84,181,131,245,220,27,202,161,38,94,208,39,143,52,5,154,85,121,139,226,223,159,246,170,56,94,209,188,71,205,76,16,233,168,172,200,37,19,123,120,202,28,175,232,88,120,107,157,198,111,253,18,24,36,35,43,169,199,197,137,194,12,238,138,232,17,17,58,115,39,234,4,164,225,215,14,185,232,76,215,171,142,206,206,132,90,31,130,24,0,165,34,91,126,113,64,202,144,114,132,125,58,184,234,211,246,238,168,7,1,172,169,218,67,29,185,66,73,49,222,167,243,189,36,116,23,223,219,200,84,67,94,53,79,26,202,204,91,180,221,166,106,18,207,17,128,137,246,235,162,13,129,130,49,76,104,189,138,55,174,71,152,49,116,204,207,103,198,147,225,142,79,8,172,59,234,225,192,168,181,144,185,6,233,243,61,123,46,55,44,16,228,79,156,235,190,115,61,162,115,182,122,230,138,204,140,86,173,80,99,207,211,181,23,141,152,17,180,35,121,168,67,205,107,74,55,229,234,210,6,94,48,186,210,189,2,200,190,181,227,128,211,225,215,228,74,7,188,195,36,82,10,131,96,99,138,63,1,210,39,134,153,112,72,163,196,55,126,37,125,107,234,166,129,80,61,97,121,20,123,222,3,155,219,62,49,207,87,182,26,214,167,142,89,38,36,112,87,100,56,245,240,152,23,7,237,11,185,206,233,203,131,42,53,35,60,40,211,114,9,13,189,130,196,210,173,39,208,56,110,34,240,65,75,234,76,73,34,39,2,118,174,237,52,194,197,28,155,161,135,180,200,3,89,210,26,154,145,45,57,54,85,26,118,207,212,58,101,69,202,184,36,234,219,155,41,29,80,22,193,175,145,100,50,29,149,166,168,162,213,130,36,25,234,78,84,97,191,139,95,156,9,12,41,97,110,222,8,16,250,161,130,45,111,195,83,213,16,141,154,48,124,175,89,25,27,9,172,242,51,167,76,109,69,107,23,80,23,166,12,16,180,156,182,238,148,249,59,130,75,122,59,134,240,69,220,21,230,47,1,124,66,180,77,247,147,103,66,98,211,96,105,213,127,178,144,102,213,33,247,141,232,67,62,86,230,222,146,68,122,27,147,7,85,69,31,22,67,67,78,13,149,221,57,121,176,133,161,84,201,146,119,196,217,19,132,52,76,135,247,107,29,131,248,220,156,248,29,41,36,202,174,136,253,191,226,91,179,96,69,213,172,0,206,75,192,54,69,120,138,218,171,185,232,211,139,8,31,11,50,119,28,197,83,158,170,229,244,195,190,23,213,87,70,17,102,197,39,59,88,152,234,95,106,29,195,236,114,136,6,159,105,101,2,119,184,47,212,218,188,165,163,138,174,114,71,54,127,64,183,39,51,42,209,202,106,96,215,154,56,33,102,25,62,111,9,49,4,98,142,198,128,138,13,74,95,229,42,164,19,175,179,111,138,19,157,125,94,34,221,103,246,144,141,176,129,201,55,100,23,12,139,33,227,91,223,224,69,120,83,245,50,57,190,21,54,86,245,95,250,34,71,249,100,201,144,16,221,0,40,74,133,38,145,48,217,119,132,34,138,67,161,62,221,126,108,207,140,42,156,13,224,198,142,19,55,85,254,155,140,168,250,58,118,137,42,78,8,48,89,195,167,91,243,246,88,23,22,206,17,190,56,125,171,116,245,129,121,57,144,228,159,197,243,217,239,86,188,152,88,239,112,120,245,119,147,189,25,128,240,72,208,29,162,23,152,24,143,226,136,174,171,58,178,10,5,250,209,239,88,62,34,251,156,163,231,247,102,112,46,48,61,233,24,71,54,73,12,81,195,243,115,138,145,194,164,135,148,51,201,104,74,24,78,107,65,246,118,159,165,130,206,34,157,177,180,10,126,163,167,129,75,0,149,115,172,21,242,139,162,170,92,238,35,46,24,108,101,62,26,147,180,210,227,166,103,149,188,192,92,115,141,161,120,90,231,250,181,130,208,232,151,157,141,208,27,81,82,42,162,244,186,62,163,6,254,94,107,138,123,144,14,216,138,235,104,135,98,77,82,57,47,77,171,213,192,134,69,226,93,197,9,63,181,197,169,22,248,190,55,178,250,167,76,157,101,170,138,94,156,44,12,155,102,133,133,149,43,224,51,130,44,138,3,195,25,161,29,216,1,188,160,73,4,196,125,240,92,88,50,192,176,234,39,109,96,39,60,165,226,80,248,179,232,244,141,102,81,131,110,19,206,225,222,115,198,63,195,251,19,155,77,51,194,251,124,13,77,69,106,112,114,187,126,67,222,81,227,163,80,172,25,70,205,111,48,160,111,165,112,243,47,236,107,81,15,83,95,132,80,133,178,116,87,10,195,139,151,122,44,82,111,24,234,156,187,202,250,20,233,186,204,184,154,149,117,78,205,119,71,166,192,239,88,148,154,229,200,139,163,129,12,155,167,252,50,198,46,106,221,91,235,75,2,14,240,122,62,178,218,42,223,213,6,17,212,242,32,190,96,163,121,63,228,65,111,229,63,70,140,232,221,248,216,80,5,145,12,27,33,195,86,111,42,125,70,44,232,82,209,40,234,168,224,215,215,133,247,128,76,248,178,34,253,61,204,193,105,44,227,66,45,238,159,16,241,67,99,178,235,181,68,204,234,144,58,40,132,125,203,25,204,148,151,253,195,198,81,8,54,248,148,248,58,54,235,82,71,67,181,212,241,43,111,111,202,69,166,200,66,87,245,207,70,112,64,26,240,149,82,86,28,104,17,59,72,154,106,1,173,59,21,204,184,231,15,224,161,253,174,78,249,25,217,35,144,180,57,102,174,57,138,227,125,141,246,16,35,201,173,170,31,107,205,169,59,19,52,209,226,49,136,168,13,238,63,53,78,203,68,18,146,228,165,245,244,84,215,78,230,167,83,239,15,210,34,99,90,184,143,187,50,98,95,182,121,47,53,112,15,53,239,130,105,66,142,11,185,224,203,20,44,156,28,197,195,65,118,36,206,88,55,37,18,112,9,20,231,73,6,11,225,79,180,145,124,204,29,245,148,198,53,210,171,103,53,215,106,111,154,237,107,2,249,79,145,126,255,255,53,222,196,57,237,131,6,63,45,70,68,190,191,12,210,247,162,41,135,184,234,206,153,176,115,255,114,178,110,24,25,66,114,55,29,79,253,67,124,245,37,236,13,88,232,186,18,143,178,59,5,237,10,249,253,37,88,46,134,71,53,74,172,186,69,137,11,154,60,68,120,125,100,91,182,239,177,38,28,125,208,165,38,150,207,244,41,88,127,241,251,168,84,195,111,37,211,165,113,3,212,184,180,207,48,52,204,171,213,128,154,138,218,69,214,154,99,201,203,109,93,71,190,5,99,1,72,173,15,149,49,253,51,82,171,179,114,131,68,114,133,15,104,227,141,109,39,68,225,130,50,51,133,154,148,48,28,230,9,43,157,50,133,203,239,37,160,233,120,54,20,116,57,174,116,158,45,8,196,14,200,80,203,212,233,1,0,88,172,214,196,22,192,224,142,138,146,230,105,100,153,155,112,241,124,26,71,253,143,4,191,50,49,88,226,25,142,141,13,12,50,159,122,211,42,168,23,217,253,218,151,135,3,152,114,102,191,76,186,42,124,70,19,56,25,85,234,58,57,225,230,253,56,194,107,134,142,201,213,43,14,33,242,16,141,205,196,99,143,100,115,5,99,128,100,221,174,110,191,83,165,164,78,60,124,209,199,63,185,120,175,43,3,24,40,153,1,83,147,223,112,72,242,148,166,115,36,138,42,13,63,1,45,173,225,83,121,19,23,208,171,146,240,108,150,3,213,83,210,238,72,120,80,197,2,4,159,197,138,216,19,178,24,173,212,237,169,129,129,102,51,63,203,142,11,134,180,207,105,98,133,253,20,224,6,126,194,167,33,132,90,101,179,113,216,222,132,30,88,23,229,210,85,6,154,226,252,17,39,174,208,255,8,11,252,159,110,195,86,250,59,161,218,31,140,167,41,33,201,143,250,68,82,205,44,4,77,43,214,212,60,82,214,41,44,125,236,152,34,64,133,184,58,145,227,65,70,73,166,49,21,158,242,114,42,75,209,36,72,188,192,146,223,138,76,27,235,115,153,105,169,96,209,231,4,33,105,226,175,187,91,218,12,73,168,214,254,98,208,113,214,116,177,49,34,94,22,127,175,12,155,193,56,187,115,187,240,136,234,206,189,250,115,219,154,17,52,62,198,63,225,81,77,90,127,246,219,192,106,223,78,102,88,142,46,208,156,230,196,67,182,18,112,210,126,198,59,15,234,166,243,77,61,149,24,223,70,245,142,178,199,101,195,190,109,78,244,224,12,84,52,158,184,88,212,155,159,128,187,54,48,209,190,202,157,70,122,109,33,221,124,227,1,196,124,121,163,138,238,25,129,134,83,111,124,60,142,46,143,48,85,63,5,77,46,251,193,209,81,108,149,108,1,47,137,175,85,106,148,27,204,145,104,3,152,84,228,215,113,141,6,117,115,151,206,248,61,43,182,198,76,88,12,222,132,75,73,8,205,190,32,12,159,70,205,4,158,0,107,220,104,90,223,181,80,7,111,166,130,16,168,145,218,242,101,35,165,172,12,217,239,157,76,37,238,176,63,124,243,45,101,181,191,200,64,186,170,42,104,154,191,224,67,145,240,72,82,103,93,108,220,251,36,178,110,145,98,136,83,2,171,177,220,23,98,221,2,160,216,219,237,90,105,255,48,157,136,55,102,122,181,7,225,55,229,254,215,169,94,22,44,65,136,50,190,151,198,54,132,81,245,106,71,91,141,176,162,15,210,33,14,140,108,81,17,135,249,17,44,15,121,28,16,114,178,210,7,129,250,11,239,18,86,203,161,124,2,185,178,83,110,168,3,81,125,80,149,8,67,30,212,0,129,8,77,255,114,243,68,8,119,210,232,104,244,127,165,159,26,176,206,160,228,34,116,10,3,91,65,149,163,43,43,44,171,113,113,223,206,17,63,64,215,216,94,118,5,139,66,201,213,30,120,149,18,236,99,41,81,175,245,1,7,171,209,151,134,28,32,122,201,13,18,46,236,215,113,188,192,221,39,69,117,121,255,119,26,59,142,121,126,238,179,163,183,245,98,199,32,46,39,137,236,232,52,138,4,60,86,83,12,100,44,195,49,107,228,105,56,183,18,177,222,50,189,188,97,197,148,94,99,1,198,221,121,206,54,31,212,145,62,73,77,213,189,38,66,13,139,69,173,57,26,11,176,245,141,166,141,203,10,48,45,201,17,131,241,115,13,165,235,28,129,88,72,36,124,169,128,6,145,10,109,219,198,187,90,149,67,215,68,116,33,56,204,217,236,231,0,205,84,97,113,175,30,185,95,187,166,164,123,103,0,218,18,150,180,103,151,153,146,97,15,161,171,246,252,131,198,186,58,55,210,93,58,157,3,142,220,98,50,202,151,2,115,205,200,3,236,146,210,233,71,222,129,198,18,131,29,157,152,63,201,45,197,253,170,121,124,232,64,197,112,22,208,106,99,54,41,247,146,135,234,142,177,3,38,157,234,222,46,189,233,76,41,150,255,135,82,99,244,246,187,81,215,16,76,188,188,104,156,21,239,255,206,97,35,217,194,13,70,106,106,238,171,232,93,223,145,190,50,39,144,48,13,113,146,151,178,156,18,131,231,168,108,178,224,7,44,122,98,87,166,65,220,174,138,98,95,93,188,127,246,195,136,215,160,201,137,35,217,167,126,219,175,109,180,111,127,222,93,69,133,2,58,198,186,238,108,57,157,101,174,249,26,46,210,254,251,76,43,197,209,161,52,197,28,246,173,229,35,43,13,81,122,34,245,212,223,50,135,69,70,192,171,78,9,135,189,54,168,232,131,250,208,59,227,252,247,231,40,235,203,254,51,25,198,223,165,81,140,141,67,194,180,31,194,172,47,195,56,153,118,221,30,217,17,85,154,184,122,15,130,179,86,8,37,33,200,95,144,73,175,68,185,197,128,182,154,171,147,182,86,172,23,236,20,92,194,110,253,124,133,82,127,206,92,34,108,69,170,47,61,41,87,108,218,3,244,7,124,51,153,83,186,164,116,154,85,123,43,135,177,107,28,189,81,241,214,189,235,233,142,6,109,183,130,75,79,107,99,67,31,164,248,227,114,159,230,115,116,115,252,33,75,4,171,191,217,88,245,156,203,48,239,140,253,211,46,184,136,34,21,248,161,128,156,16,88,64,71,34,174,125,70,164,125,92,205,214,79,157,199,223,143,214,138,213,150,169,17,16,181,95,200,208,91,91,55,125,7,1,39,91,6,103,252,246,22,71,110,149,236,73,1,247,51,2,168,88,124,234,86,100,6,94,1,17,215,157,34,238,126,194,222,109,67,175,96,45,252,99,58,3,34,192,251,95,240,36,188,243,191,229,74,164,55,171,108,239,73,208,140,114,46,244,36,30,33,56,14,209,94,86,28,9,153,30,23,102,165,252,98,77,72,233,22,126,152,98,40,246,35,93,137,114,191,114,200,54,214,8,238,145,43,119,180,186,55,74,170,232,166,247,56,233,9,162,16,241,95,47,5,109,72,125,67,35,130,55,138,75,157,246,85,244,3,230,60,226,159,12,234,155,160,180,119,243,253,179,202,194,53,218,65,208,230,212,71,228,29,49,220,31,146,244,249,84,46,237,203,93,171,73,33,115,46,109,10,163,137,73,18,133,213,236,174,230,216,119,127,80,199,18,100,180,236,191,127,152,158,226,45,72,70,181,106,90,21,229,46,41,109,55,237,81,0,158,169,63,40,22,85,246,181,235,161,180,28,175,136,87,132,184,54,121,185,69,89,58,20,54,81,101,87,37,251,152,4,162,108,113,248,178,219,151,240,144,158,242,185,138,4,34,148,255,250,66,75,144,141,25,248,244,89,180,203,97,141,149,179,129,213,186,64,101,242,119,130,121,108,230,198,74,228,155,96,237,140,201,158,44,127,161,120,219,94,11,95,27,145,80,184,107,215,88,252,32,89,59,97,159,249,183,75,131,180,65,184,179,85,80,88,74,128,53,126,191,54,169,0,133,100,248,196,158,91,121,110,12,248,130,87,248,186,85,136,101,181,0,90,45,34,227,84,17,40,96,221,187,167,131,112,48,70,62,240,138,78,245,248,226,203,255,32,242,246,141,200,17,167,32,151,12,72,159,221,190,56,115,237,233,226,113,71,228,167,60,113,127,28,174,27,176,227,160,77,221,157,64,14,166,82,60,78,7,91,16,214,169,78,222,97,33,229,210,4,255,104,234,42,181,7,177,190,23,40,135,53,67,63,28,151,60,167,81,21,190,110,214,160,222,51,228,87,83,113,220,46,182,163,193,79,214,249,120,197,244,197,169,252,20,33,253,246,46,198,16,208,35,110,5,37,236,172,149,234,155,32,36,8,249,70,224,226,40,16,146,131,224,173,250,111,102,227,160,196,255,167,81,196,62,24,6,39,4,245,139,98,158,201,247,5,6,2,61,92,5,65,70,24,206,135,30,246,146,155,22,29,247,25,112,186,5,208,134,240,95,137,29,48,148,222,92,36,165,248,10,244,222,158,131,46,156,217,243,219,101,123,98,209,124,89,178,16,48,173,142,241,134,127,160,217,64,134,35,244,28,253,59,26,10,212,162,143,252,94,0,198,0,16,156,116,145,64,255,206,234,251,104,250,213,247,171,89,86,125,48,237,216,196,160,45,90,227,12,33,58,31,88,200,117,101,36,105,135,49,134,64,181,233,40,63,100,189,192,13,48,58,159,183,105,34,162,170,166,132,83,141,116,29,39,216,84,29,224,211,54,145,251,248,148,150,203,26,51,179,47,134,175,80,66,223,24,221,52,170,59,241,37,95,232,183,15,162,203,144,221,60,248,8,211,255,78,249,55,59,23,131,11,165,152,182,82,168,71,89,48,249,78,107,182,117,73,21,79,42,128,232,89,103,207,13,224,32,236,175,138,201,54,26,98,122,91,253,144,222,108,171,101,120,208,168,40,29,46,64,23,171,248,115,40,80,28,107,143,65,188,142,205,155,234,86,121,157,124,23,44,177,188,201,222,229,244,169,241,155,62,102,187,15,28,49,168,157,29,135,202,9,160,102,125,112,184,31,209,162,114,13,130,215,93,15,255,110,50,54,19,144,98,47,46,170,252,210,5,161,176,69,185,97,187,253,94,124,215,85,69,73,136,150,68,137,217,52,113,151,241,70,44,102,126,10,143,167,133,81,239,233,109,73,171,141,93,133,112,185,133,103,206,49,208,130,79,127,234,48,173,231,82,200,74,68,194,188,185,26,56,199,134,122,3,153,227,174,245,23,34,49,20,68,184,202,1,232,252,31,171,45,85,7,114,187,66,203,169,98,117,144,15,165,104,143,111,174,100,197,60,7,53,248,238,100,12,162,96,40,189,247,101,64,57,57,14,195,114,229,155,228,32,111,37,141,8,8,163,2,223,6,96,54,144,175,85,141,51,77,41,60,192,113,15,103,101,44,30,102,189,100,251,227,71,37,62,123,4,63,119,25,116,47,205,191,156,1,106,136,248,37,151,162,72,226,41,208,133,69,146,114,137,43,245,90,115,117,90,122,134,180,218,136,10,36,210,53,138,90,139,213,130,56,173,119,174,71,72,213,138,87,171,101,156,110,0,164,38,191,156,215,148,220,106,138,50,237,54,37,49,215,127,45,81,226,61,181,195,147,154,208,170,94,34,8,228,121,71,182,239,63,56,65,244,0,70,162,73,198,63,16,134,216,58,187,203,234,115,44,209,105,127,183,130,74,82,203,219,128,128,162,13,47,106,252,31,56,155,184,119,56,139,70,241,3,104,153,43,183,28,68,241,224,25,154,52,51,131,108,142,150,13,106,43,251,166,76,47,218,150,11,125,109,109,179,145,213,217,241,16,32,208,48,33,217,59,171,245,248,174,34,191,77,111,183,221,49,141,59,221,76,224,103,190,107,171,215,232,44,84,133,236,88,227,175,24,57,144,252,229,182,140,36,219,42,92,101,187,212,188,34,205,167,99,168,91,224,154,187,112,52,190,62,212,191,250,250,68,229,248,142,143,161,185,243,117,222,69,61,162,247,179,140,133,135,164,217,144,222,8,114,20,240,161,44,27,187,82,122,237,53,167,43,2,215,122,219,61,163,54,181,154,176,222,239,12,13,63,88,213,167,98,162,94,254,89,113,112,242,88,158,65,229,215,16,126,234,96,129,34,233,231,85,152,90,16,97,32,90,134,18,131,114,130,148,249,76,135,186,171,103,192,83,45,100,96,36,88,217,197,165,86,194,168,112,149,125,108,133,112,117,199,26,221,35,245,88,233,9,113,47,138,31,61,114,47,51,32,197,55,17,175,164,93,204,223,215,203,221,224,147,103,78,214,230,214,71,214,220,169,117,39,0,147,198,108,242,153,155,144,235,250,162,35,53,61,45,156,227,244,108,123,32,227,129,77,252,146,213,168,197,237,147,123,38,228,75,144,165,144,102,113,198,22,145,14,101,195,177,43,62,151,113,96,81,189,204,180,207,197,24,72,76,135,127,181,246,81,18,167,113,85,184,62,190,140,86,209,148,134,111,32,60,108,33,233,115,99,216,239,112,146,92,217,236,252,213,215,98,122,215,64,175,155,179,121,195,7,207,252,163,51,58,143,187,255,188,122,6,199,73,36,149,218,141,142,43,108,99,2,232,187,65,216,24,169,125,102,148,113,59,233,176,194,207,77,204,245,20,43,145,104,88,88,212,187,237,152,64,18,141,254,53,255,111,53,61,62,49,143,145,197,10,207,36,198,166,88,7,199,42,201,145,219,135,53,239,108,162,82,202,181,4,255,82,23,38,141,213,120,0,218,105,2,141,120,255,138,20,27,255,97,202,151,0,166,227,16,196,48,139,91,164,4,170,177,243,27,154,220,212,167,205,179,84,245,205,50,51,155,45,39,99,124,70,27,48,182,173,3,26,38,214,1,26,23,216,248,214,89,78,142,7,44,2,118,103,73,72,202,187,222,242,74,37,84,166,251,191,67,11,231,116,61,33,17,96,93,116,165,173,88,153,105,123,125,159,243,89,143,66,211,213,23,47,204,192,2,231,229,224,32,30,45,9,31,149,216,137,119,152,34,22,131,206,47,216,201,89,197,58,66,204,67,92,0,150,199,161,213,185,96,252,164,78,46,247,41,134,48,118,14,77,30,250,176,12,138,96,58,51,142,9,249,103,99,29,247,189,31,126,29,86,211,201,108,216,195,90,32,119,124,219,207,128,192,119,91,217,60,215,24,182,244,100,241,153,24,3,99,115,167,33,25,239,186,42,198,202,179,57,117,112,11,208,212,50,26,170,22,148,206,252,232,159,56,64,37,184,40,232,109,62,164,199,64,198,112,56,71,12,215,108,220,20,211,118,70,182,19,212,219,182,104,5,188,255,61,162,241,25,176,78,25,176,239,21,205,246,214,246,86,45,101,158,9,252,149,38,59,72,225,119,121,209,20,85,6,84,253,24,182,126,20,150,105,176,238,54,59,96,46,28,214,21,80,112,19,118,125,115,134,244,30,35,230,238,255,199,220,32,200,9,142,2,182,14,101,191,176,143,96,217,200,124,194,43,105,61,93,143,135,53,12,228,233,30,150,173,228,73,179,184,84,21,117,63,245,231,49,129,29,249,46,23,172,195,94,36,76,227,246,71,159,188,8,88,119,49,177,156,203,88,101,195,170,151,183,106,100,9,246,64,254,1,90,4,9,163,154,231,88,68,182,99,67,75,171,107,142,196,79,237,114,70,178,128,33,83,168,67,129,82,214,135,38,206,41,152,140,168,52,239,28,171,28,29,180,246,185,183,243,85,129,112,168,63,139,133,0,162,86,166,48,132,244,159,151,235,175,64,110,168,85,97,233,11,62,25,177,16,57,124,63,250,59,218,136,209,136,192,23,168,160,206,65,84,30,73,213,235,181,104,66,27,98,126,183,219,93,200,115,84,141,57,55,20,131,91,14,228,85,181,19,4,110,176,90,101,40,91,107,155,7,70,21,114,154,141,146,125,246,64,1,216,213,232,23,143,224,115,244,247,144,186,71,134,69,183,141,25,186,91,29,145,163,250,202,181,57,216,172,131,228,242,181,187,52,94,218,252,4,118,44,52,124,160,37,176,17,218,121,140,191,107,102,91,222,49,91,229,106,179,221,170,200,88,38,138,167,10,48,157,47,99,57,137,88,76,206,141,214,208,48,80,226,18,227,6,175,180,63,107,247,251,197,59,51,247,13,109,209,162,206,192,125,112,94,235,247,26,88,14,126,241,225,249,81,162,7,157,238,150,138,24,69,121,155,219,17,169,180,218,93,230,99,92,139,53,179,145,30,14,205,171,75,247,49,194,3,14,177,24,222,122,30,75,174,121,243,104,233,244,81,4,47,70,43,206,113,229,119,231,49,72,144,78,214,29,193,41,75,14,97,19,84,148,246,3,250,243,7,246,233,153,48,135,226,204,199,93,210,3,97,11,106,117,170,122,92,97,150,179,177,220,46,59,17,151,242,160,233,237,81,78,255,87,243,237,113,135,216,131,97,197,224,41,142,85,234,243,135,58,152,220,191,227,149,78,77,30,82,167,63,217,43,227,106,173,223,128,161,49,70,29,184,169,178,179,124,224,2,243,210,229,112,103,15,29,78,229,91,9,68,198,94,135,241,207,69,183,229,46,78,63,189,93,163,10,91,172,13,205,180,217,216,102,237,239,3,217,247,218,0,147,130,158,175,242,39,94,23,238,221,229,211,72,140,103,207,7,73,10,200,247,155,254,35,165,152,2,137,237,154,128,235,215,210,1,132,104,143,128,91,191,225,241,171,220,16,165,209,59,10,1,128,151,229,116,17,20,188,108,57,196,105,197,5,64,216,75,255,49,10,35,243,39,238,142,201,1,32,8,28,116,21,216,226,89,90,231,210,128,81,149,93,249,111,150,128,11,228,231,236,178,74,34,174,187,230,84,78,197,136,17,197,25,242,154,123,24,78,245,178,254,76,70,182,72,15,115,54,62,10,89,172,129,113,97,148,204,240,100,172,169,122,13,95,182,26,184,25,191,255,250,250,137,18,19,72,145,135,112,125,227,63,65,26,54,228,181,30,158,27,191,9,236,168,115,248,144,187,132,253,45,84,154,196,103,30,149,123,53,42,206,172,146,175,44,203,69,239,45,147,0,121,103,125,132,136,192,38,62,79,29,241,17,151,110,28,38,221,234,230,228,182,64,241,144,165,124,145,120,49,50,129,18,33,242,212,143,68,167,109,134,179,113,176,85,93,87,105,133,15,66,249,8,43,9,147,72,30,6,2,85,185,204,160,20,76,70,119,163,67,200,121,228,185,204,22,48,31,122,177,123,93,159,108,114,65,90,91,67,95,139,6,187,3,78,142,38,96,61,68,23,146,93,32,245,153,131,61,126,1,194,201,158,51,161,172,0,176,76,143,229,81,201,36,157,210,139,109,215,12,9,41,152,243,188,240,144,194,27,114,193,162,39,43,9,203,46,137,76,217,93,125,215,74,43,75,0,153,246,95,88,44,134,248,43,87,166,46,133,1,77,197,205,206,31,50,102,178,248,22,226,192,156,203,195,155,193,32,35,158,173,76,75,79,240,112,7,161,130,162,85,225,67,223,15,127,53,24,49,231,201,248,16,114,146,228,17,178,247,166,162,2,32,180,41,188,9,197,103,77,246,35,30,71,112,6,222,168,64,60,248,242,61,201,130,219,58,182,38,143,103,45,104,219,7,121,119,138,183,148,149,107,216,169,2,89,111,185,120,49,74,173,174,35,38,194,214,86,32,216,229,123,41,64,108,178,152,13,174,71,86,192,147,84,112,246,98,151,238,63,210,134,112,5,28,254,154,125,236,82,78,22,114,230,212,88,97,54,211,70,203,48,159,59,21,36,55,56,141,194,247,133,160,138,224,66,180,74,137,37,94,5,120,135,170,119,209,147,221,28,19,215,139,29,199,87,234,102,225,111,74,180,27,169,131,129,29,44,138,81,235,206,181,229,133,192,201,163,110,48,203,245,95,200,183,29,29,31,255,74,216,148,92,109,191,130,29,236,248,204,126,228,208,76,200,13,128,197,198,255,211,23,197,132,124,133,71,155,21,132,233,191,189,212,255,108,47,94,109,53,232,234,95,174,83,223,18,188,255,239,215,139,141,51,127,243,199,103,111,117,45,101,67,184,104,196,20,34,25,184,251,144,47,226,217,214,217,125,47,52,41,242,113,104,13,56,74,44,166,36,63,154,133,145,18,80,160,124,59,47,48,219,63,43,134,67,115,238,189,252,67,6,164,83,181,123,230,213,252,7,222,130,221,30,79,68,34,162,2,61,134,162,207,49,146,161,216,82,98,181,190,57,57,164,128,97,121,148,131,128,152,66,106,247,15,154,148,82,42,174,142,17,249,123,23,138,78,106,245,159,202,19,26,160,50,138,153,136,182,101,89,247,195,169,69,220,50,155,45,140,251,248,183,139,84,17,44,98,83,13,102,234,106,135,22,255,212,246,163,28,11,251,123,18,5,150,221,6,2,137,17,176,56,215,12,166,187,52,149,11,97,119,140,245,13,201,20,98,80,27,26,125,126,58,232,231,83,52,195,75,116,248,147,230,123,171,77,81,168,163,120,39,158,18,54,60,212,117,67,148,122,151,78,51,30,88,27,152,83,92,191,105,162,106,233,12,27,116,4,53,100,189,242,253,169,182,10,105,196,84,229,122,141,80,15,0,38,26,50,176,229,18,32,169,241,202,190,190,225,100,193,44,196,209,193,83,89,43,228,8,127,48,9,221,186,199,251,97,138,218,190,131,202,206,62,148,128,44,48,107,164,177,57,149,171,214,244,57,198,194,87,179,232,10,17,65,243,255,109,19,208,42,55,68,178,164,84,21,57,206,5,27,252,203,144,108,90,231,137,198,221,204,164,204,56,73,223,129,127,246,244,144,140,13,229,195,199,39,42,93,103,202,8,45,68,203,17,186,154,9,154,228,59,255,134,120,125,170,90,18,141,31,17,116,10,189,48,63,147,112,188,11,184,92,95,253,180,92,80,106,57,112,187,229,228,69,3,1,47,47,72,146,48,135,37,111,82,27,20,77,157,222,115,123,120,119,159,196,99,7,116,57,222,119,79,79,212,213,215,145,225,154,187,25,22,126,89,170,169,123,159,94,29,177,63,137,207,167,192,97,134,193,17,236,199,8,35,214,220,156,72,183,180,8,63,200,171,93,216,103,110,145,159,209,158,236,233,50,228,220,144,113,159,214,222,157,156,27,133,183,240,127,191,28,41,222,148,155,247,32,97,96,128,237,98,236,159,107,157,192,176,19,81,248,145,219,183,179,73,178,81,38,137,81,108,189,148,180,164,63,244,107,140,13,253,2,84,88,16,121,200,120,77,203,104,24,207,202,194,62,253,155,102,96,168,116,28,237,163,138,91,149,34,82,230,211,109,230,176,130,28,82,186,233,159,99,238,249,81,38,106,243,246,4,63,80,43,104,47,1,253,236,84,79,158,5,81,26,18,242,70,42,11,229,216,154,236,16,203,159,227,7,207,120,26,197,81,87,177,4,32,197,147,111,255,229,91,211,194,195,230,35,169,151,31,196,33,181,120,192,254,71,84,152,228,208,209,129,98,55,39,210,144,146,192,231,249,121,170,81,218,202,197,150,149,234,93,90,178,167,209,244,86,25,140,141,156,206,14,247,240,217,14,39,99,82,121,16,119,157,210,169,220,50,58,255,48,130,189,120,154,59,60,85,94,135,23,15,171,6,31,212,224,89,73,100,179,91,61,170,128,28,33,227,9,149,128,12,110,120,44,9,52,192,4,24,65,221,114,24,77,109,0,237,94,4,42,232,84,150,134,32,50,33,84,234,130,136,89,117,253,79,60,135,69,29,50,128,196,38,41,43,37,78,168,73,163,249,45,207,177,76,38,115,76,143,118,145,106,166,6,142,230,193,147,145,87,195,222,73,219,219,89,33,68,237,118,120,146,164,74,130,237,16,47,79,228,9,153,184,5,127,80,182,81,105,196,51,244,192,237,160,118,200,191,94,235,152,191,202,161,231,171,19,116,102,94,206,253,175,4,193,18,70,53,214,98,123,181,137,167,190,84,96,169,2,204,232,54,221,169,175,186,172,137,170,75,32,249,57,119,86,19,52,123,234,142,11,108,19,58,84,98,250,242,114,170,31,205,195,117,12,243,41,93,222,0,101,219,102,129,196,192,91,8,186,233,243,37,194,183,162,121,59,93,71,52,178,114,96,72,252,185,254,109,31,107,112,168,64,226,160,216,43,49,74,50,139,112,148,135,148,88,184,35,26,29,171,245,47,96,61,39,146,159,194,252,57,202,244,245,218,216,18,29,71,237,39,25,197,164,184,67,97,53,45,16,218,207,244,97,249,96,167,93,62,103,162,164,67,186,159,2,26,136,32,184,9,167,169,183,210,72,43,253,167,72,211,171,205,117,92,82,32,5,197,107,8,68,106,237,8,142,148,101,227,90,210,67,13,252,233,3,242,79,95,172,175,195,246,251,254,247,71,7,224,252,37,255,4,158,178,131,23,77,77,22,178,114,155,151,162,207,53,98,63,132,143,232,73,194,185,91,243,57,47,83,36,154,42,31,150,56,15,33,40,14,111,70,137,225,158,138,108,119,114,255,48,176,231,182,51,219,163,86,122,80,104,197,169,107,181,97,55,228,63,47,73,106,27,23,65,207,177,34,218,221,147,192,237,165,74,89,152,255,181,169,250,226,99,10,232,6,181,45,3,222,174,26,248,155,12,199,237,65,205,85,22,125,164,146,124,17,73,140,71,36,57,173,173,157,157,161,35,164,157,190,71,67,29,142,133,206,231,64,185,95,111,65,166,220,233,245,73,242,25,16,29,223,124,142,199,177,13,24,198,245,218,190,115,38,32,45,236,12,96,101,63,17,230,151,217,117,234,153,112,111,91,162,196,247,185,166,60,2,8,145,56,160,48,175,226,250,67,51,132,106,42,213,138,119,167,9,240,25,8,56,22,165,218,9,62,218,121,29,43,177,130,210,166,150,15,220,225,225,152,34,255,104,115,223,108,131,55,250,255,49,92,130,20,179,218,73,38,116,122,102,17,118,237,183,109,65,232,122,235,4,68,3,245,160,150,224,73,183,115,6,100,124,166,210,201,82,249,142,15,23,20,60,118,137,170,181,229,205,108,201,240,169,87,195,99,76,138,15,228,158,47,216,146,8,248,175,110,207,39,94,180,173,250,47,24,2,201,150,241,233,238,16,120,75,140,84,49,212,106,98,213,162,86,181,76,170,35,124,116,48,164,197,74,131,117,229,28,19,139,154,0,123,202,110,178,10,79,113,166,22,172,117,191,54,48,27,183,59,223,105,57,148,54,241,188,72,118,58,255,33,235,238,206,33,254,197,162,45,154,226,221,57,145,225,19,36,11,164,245,79,188,132,50,190,248,255,75,183,214,242,69,109,232,147,130,166,70,86,58,124,161,96,88,92,166,32,184,117,117,232,148,14,163,81,163,242,0,239,41,82,240,105,189,74,68,200,164,195,85,62,74,56,226,196,41,2,105,154,95,205,207,232,106,98,226,99,112,210,188,162,203,188,28,65,78,18,252,134,93,120,74,188,64,154,12,133,146,228,14,25,9,13,157,22,83,145,169,201,189,221,137,49,232,138,179,182,165,146,2,109,172,21,172,40,157,230,199,70,170,17,231,133,250,192,45,75,214,33,111,3,120,209,54,12,206,159,226,150,136,96,94,25,66,56,178,106,7,73,214,104,156,236,28,249,93,15,229,9,0,132,16,69,155,125,179,207,94,14,13,244,207,241,54,32,52,63,98,162,154,191,75,209,229,33,193,255,57,31,229,86,153,43,207,166,165,245,54,40,212,29,222,70,136,130,40,74,185,218,104,130,108,129,245,188,86,215,76,131,33,190,168,234,99,175,11,251,216,73,187,108,44,255,201,238,119,247,44,86,81,235,45,3,57,216,75,34,73,180,36,35,240,164,214,36,117,135,41,119,211,38,76,81,196,8,21,97,136,235,119,71,123,36,176,199,227,228,108,128,149,137,5,164,77,148,159,81,47,176,108,234,54,46,235,56,167,178,84,254,105,129,190,49,65,57,236,213,149,152,10,85,206,195,221,92,221,54,74,114,134,198,83,208,132,62,75,99,76,23,147,221,170,238,47,2,231,238,159,31,157,21,230,120,116,37,205,171,183,193,105,172,143,117,1,93,76,23,54,218,89,41,8,34,70,14,172,247,13,165,93,149,104,106,13,209,88,202,31,127,1,56,213,196,57,128,219,160,128,36,102,11,50,241,144,120,109,249,181,6,101,158,193,159,198,121,72,53,117,201,226,238,36,19,89,190,170,97,242,166,133,255,187,116,117,149,110,240,34,46,115,10,173,23,253,193,26,88,218,204,250,37,212,109,250,201,191,194,118,95,136,247,161,207,241,204,135,2,78,149,74,112,131,147,47,174,61,6,17,165,170,245,205,230,27,4,219,42,253,132,224,5,105,216,149,164,189,139,111,218,70,124,62,36,131,167,58,160,166,166,15,182,6,55,43,51,18,46,56,174,90,10,0,14,29,74,85,33,208,147,69,176,90,198,106,36,37,30,25,35,124,178,130,4,84,25,198,20,229,53,83,27,191,7,155,221,115,87,5,220,83,80,84,102,251,48,221,102,199,149,98,72,199,4,97,43,61,78,97,140,141,115,8,36,76,209,170,73,151,35,27,50,135,70,240,173,0,121,54,23,163,78,109,212,129,93,171,216,134,28,83,113,141,233,192,101,187,144,201,55,84,241,226,162,50,111,152,243,114,9,111,93,4,89,234,55,65,28,241,78,143,188,189,252,70,80,238,69,204,212,181,122,171,109,189,186,144,136,240,116,95,234,155,53,70,170,203,113,36,46,45,134,195,163,140,104,104,25,181,136,167,116,55,237,25,77,120,91,44,239,159,52,190,41,227,220,175,171,101,213,127,105,222,163,58,68,40,210,118,247,1,76,42,20,189,248,76,43,113,25,81,37,26,154,234,25,226,251,39,69,143,3,138,235,220,47,9,31,25,63,195,193,72,173,92,80,43,152,143,80,74,126,49,33,238,113,228,171,168,241,82,49,174,116,73,94,130,72,230,253,161,187,183,237,195,41,153,143,130,252,152,169,147,185,106,2,207,13,134,90,175,141,157,242,255,161,154,42,107,178,145,195,16,211,119,181,175,211,84,142,39,77,187,239,159,12,177,186,243,150,95,140,58,167,52,103,146,158,98,247,173,141,219,214,180,87,55,184,155,216,203,67,81,243,45,171,219,220,110,144,106,5,138,225,212,232,110,202,220,68,84,250,115,120,118,200,167,154,108,73,90,190,72,34,47,249,229,114,4,80,142,144,22,68,254,128,128,196,171,194,100,131,176,168,30,203,107,42,65,59,156,176,21,156,53,86,125,203,58,216,87,127,233,238,153,162,195,175,35,133,212,69,25,61,96,246,99,19,132,120,219,58,140,93,223,248,9,43,246,147,166,10,33,40,237,26,6,87,228,81,182,159,34,234,48,74,27,30,186,36,136,63,92,110,3,131,130,27,239,155,0,156,219,146,232,148,189,133,204,227,35,102,6,13,242,251,69,127,251,171,127,248,242,116,126,174,84,115,6,193,135,29,128,225,230,162,23,222,79,106,4,26,156,61,251,88,57,81,76,237,7,19,107,37,95,147,230,99,193,76,98,87,252,124,217,105,200,201,204,245,189,226,154,95,54,19,34,64,85,66,163,243,6,203,46,201,0,174,183,154,181,226,46,152,199,255,75,54,243,29,83,133,231,240,6,21,38,68,184,253,109,54,23,224,31,102,11,112,103,43,17,38,125,238,71,104,161,159,219,136,215,196,141,170,10,56,156,93,207,152,188,114,22,157,0,165,25,138,205,58,248,67,193,58,28,147,32,38,229,221,175,114,14,42,161,2,223,231,204,164,6,92,49,52,64,37,164,223,252,197,118,55,243,108,10,158,239,219,175,244,102,22,194,134,212,9,249,244,43,86,97,41,53,9,224,110,61,250,140,202,187,95,171,204,21,221,58,141,24,176,120,96,194,232,84,28,125,246,218,142,73,131,254,249,22,179,71,110,208,97,247,139,162,171,64,251,79,190,180,190,186,29,110,165,88,119,225,30,58,64,49,68,45,83,93,122,136,199,146,158,106,5,211,222,64,64,160,74,72,185,138,112,186,135,133,95,31,236,77,86,54,59,235,32,245,245,133,152,27,233,115,154,253,233,222,36,218,216,218,211,137,127,103,199,95,165,151,234,33,228,72,167,103,13,43,119,38,71,23,218,227,177,230,222,214,149,81,102,246,94,251,84,233,90,116,77,26,118,194,122,55,75,208,137,52,159,238,73,8,33,157,218,178,213,108,45,131,207,210,31,144,133,204,239,144,183,230,251,195,57,195,154,39,61,36,39,117,126,121,69,224,198,15,198,98,59,82,181,202,28,149,49,219,53,48,163,19,164,57,251,219,61,159,235,12,121,100,151,160,191,93,194,90,22,119,28,191,219,210,170,234,145,2,111,53,86,140,171,46,232,231,111,18,43,83,2,142,131,38,36,99,174,3,26,169,105,31,214,250,212,191,8,1,141,69,73,158,180,248,93,117,146,242,10,188,63,7,61,149,69,118,161,141,117,25,193,18,187,220,194,82,13,30,5,225,194,158,252,56,159,129,5,240,0,213,85,67,54,209,242,151,41,141,172,187,12,215,255,6,5,126,185,11,225,35,202,5,182,98,154,26,217,237,193,140,136,38,71,118,166,44,17,223,179,101,97,16,153,33,21,204,15,219,189,120,219,24,117,23,4,153,22,143,40,174,238,185,27,159,69,251,1,227,108,218,69,111,198,184,236,14,216,136,208,115,154,211,47,149,116,98,114,40,90,83,116,92,109,38,134,140,104,157,197,116,57,122,111,5,224,4,175,201,244,62,210,203,188,216,230,131,214,184,164,54,48,242,179,251,201,77,16,77,13,77,23,34,66,146,24,12,187,238,151,92,139,64,114,217,125,244,175,10,155,138,118,58,245,52,121,17,241,62,231,105,214,169,120,184,4,155,16,20,12,215,206,40,237,161,186,68,63,141,166,178,6,127,126,151,70,195,245,163,96,91,23,138,173,211,99,103,164,14,51,246,20,75,76,135,150,74,215,220,71,15,76,77,215,250,38,227,176,76,17,15,179,232,18,19,165,54,194,146,187,110,158,216,55,66,145,232,119,152,61,63,121,155,194,202,244,22,81,66,36,140,38,108,209,21,139,25,159,255,185,60,117,9,245,95,46,99,220,27,61,151,235,253,38,161,64,188,88,189,117,249,42,176,56,54,107,62,80,240,135,153,86,180,137,121,111,177,208,196,3,194,236,106,173,82,40,195,1,146,180,204,141,11,192,120,252,52,4,116,199,14,254,104,216,4,219,7,221,233,33,47,34,247,94,0,104,240,54,18,128,85,240,255,179,195,197,161,240,178,242,197,103,68,166,60,95,131,245,148,198,163,124,209,39,120,42,206,15,106,91,118,113,89,19,66,66,241,200,64,65,37,82,169,139,136,203,234,192,172,175,27,160,244,10,91,4,183,109,177,183,93,233,92,26,227,67,87,232,184,97,234,202,240,80,213,42,133,15,68,206,0,206,110,170,227,223,113,90,208,60,11,93,245,151,50,51,86,152,199,229,35,248,13,119,64,238,165,152,108,70,48,149,157,110,249,189,25,187,246,251,124,64,0,176,165,128,174,39,200,94,100,193,34,233,19,192,83,39,177,228,74,234,195,128,251,203,238,192,16,66,200,223,179,30,106,195,189,26,217,157,142,161,132,38,20,179,217,79,34,97,189,231,106,19,144,223,172,39,206,91,192,115,254,111,141,170,103,121,61,72,101,60,110,173,73,193,25,89,206,122,137,151,213,60,169,7,42,226,224,249,190,43,17,190,187,240,163,77,26,192,162,70,170,154,216,20,183,212,229,81,56,157,247,123,219,168,91,21,53,107,174,135,98,32,176,146,78,98,190,30,232,190,171,107,188,254,223,5,25,58,134,150,36,28,218,134,107,40,253,245,199,11,1,191,26,173,238,5,142,204,170,161,157,127,172,254,27,185,235,87,15,3,74,170,36,195,132,163,3,126,33,178,173,141,106,23,111,96,111,124,164,68,230,2,210,18,190,148,45,70,148,194,38,160,67,130,166,172,81,5,91,142,239,190,58,3,102,81,212,68,68,73,134,6,117,116,100,47,57,100,207,232,224,125,32,30,193,162,117,36,57,8,27,203,56,199,110,251,56,35,162,240,157,224,0,42,206,199,201,33,95,5,127,132,29,178,152,101,166,1,242,99,155,248,47,71,180,75,84,99,65,91,32,31,136,206,52,48,74,184,208,83,85,179,51,105,125,87,66,145,207,127,71,239,255,157,126,120,139,232,35,64,70,128,118,191,41,217,7,185,86,117,216,187,163,194,206,174,218,56,214,58,160,248,111,154,70,17,108,212,91,199,245,32,108,125,43,198,192,38,68,101,100,147,129,87,52,240,50,91,92,218,108,127,101,155,228,123,77,147,41,86,207,159,139,140,93,22,169,163,63,89,236,154,98,131,93,39,55,237,122,107,6,174,184,202,126,27,199,141,16,52,167,250,44,52,64,134,244,66,235,39,127,190,88,127,61,105,107,157,35,59,146,10,14,155,241,227,170,104,180,47,95,20,235,236,196,100,29,66,255,252,236,249,128,214,5,234,40,241,34,234,45,47,166,217,121,36,243,35,251,23,126,3,133,136,164,113,22,69,236,180,239,139,48,255,146,161,48,135,129,150,245,193,181,210,85,120,4,249,147,174,66,17,136,154,208,148,214,82,198,29,171,4,223,212,84,104,93,95,153,151,59,52,212,150,113,85,179,189,60,151,118,28,93,220,49,114,124,228,164,99,165,40,1,5,200,121,138,132,77,15,5,21,162,216,252,37,141,224,202,125,209,225,242,62,177,195,93,254,238,77,226,148,168,119,167,195,151,180,25,60,215,48,166,94,44,45,114,159,78,24,155,132,119,38,31,231,227,51,37,35,33,239,40,171,12,250,68,190,248,231,228,59,213,61,15,65,53,179,92,176,23,172,176,32,72,135,37,241,24,107,242,184,186,57,99,239,241,14,0,114,211,202,79,176,88,52,130,56,18,75,55,22,208,79,100,1,57,105,53,174,100,13,234,232,158,118,211,9,144,128,160,76,177,166,10,90,95,110,144,254,243,190,208,135,184,198,226,200,27,9,38,241,0,208,210,237,180,2,22,149,157,19,155,249,21,3,55,195,149,105,206,24,110,148,19,249,58,78,186,176,25,100,216,4,198,194,104,71,150,103,193,54,223,28,146,80,51,157,194,14,178,180,189,161,192,44,225,168,111,47,225,151,43,100,26,191,125,146,222,221,199,216,186,126,173,89,90,229,77,60,34,228,75,219,182,85,232,170,22,24,130,197,101,20,253,116,141,176,241,34,223,208,190,53,49,201,93,144,151,241,108,236,120,86,232,128,234,238,83,111,80,172,96,67,34,128,6,29,10,136,122,7,204,83,50,186,1,23,79,169,21,92,114,15,132,236,51,188,123,139,240,236,199,67,208,132,52,13,194,187,174,29,120,140,151,198,252,88,147,102,219,35,162,73,126,98,77,213,8,169,217,193,210,100,239,19,153,49,43,252,194,75,228,65,143,184,39,77,42,202,171,40,113,137,164,157,33,120,131,63,197,218,5,250,238,192,175,128,92,206,161,173,254,238,133,100,158,136,16,101,127,238,52,208,92,82,3,217,66,93,246,228,193,254,74,72,78,122,33,105,54,8,66,93,246,194,222,27,194,33,125,31,125,186,243,13,92,218,44,36,132,226,180,89,124,205,104,135,159,122,252,15,162,223,62,10,250,171,0,131,127,85,178,231,79,207,40,253,46,196,118,242,128,72,35,191,117,82,21,59,50,253,123,77,220,143,104,20,203,224,176,13,252,32,28,67,43,91,75,244,94,186,135,19,180,199,223,127,142,98,37,239,28,103,87,65,235,18,238,103,120,238,30,86,59,98,172,2,220,161,99,43,3,209,122,161,55,146,255,1,36,249,99,184,3,3,168,72,232,46,73,223,106,79,159,210,38,156,147,51,126,50,165,108,52,49,96,42,238,80,99,70,146,206,224,54,97,97,16,213,14,248,251,126,49,66,87,134,179,227,232,143,91,185,125,0,158,183,5,242,48,7,152,160,171,198,163,34,181,199,170,68,125,93,97,109,136,230,150,33,113,56,104,7,226,175,49,100,51,84,213,22,135,7,237,200,148,72,116,142,163,153,122,86,4,164,15,210,118,24,67,210,223,220,137,144,48,144,180,185,234,2,241,154,213,43,109,156,143,172,26,128,135,231,119,24,217,131,61,148,77,141,150,92,115,120,2,154,217,75,86,241,208,171,108,103,82,89,209,129,238,172,132,255,207,27,146,164,74,184,68,92,141,13,124,214,138,185,244,149,236,189,182,103,67,87,10,32,216,220,143,80,210,206,245,104,149,139,20,55,5,113,172,207,125,29,89,249,19,112,108,14,88,182,201,165,18,10,245,121,6,178,148,34,12,59,196,61,173,239,178,241,33,155,25,242,134,32,227,233,188,135,113,163,52,64,251,178,224,118,246,79,167,5,63,212,177,112,180,80,242,169,49,210,21,134,141,17,157,190,91,64,227,91,38,133,159,225,105,247,226,195,200,172,31,220,215,170,68,107,20,234,183,178,143,56,158,107,86,223,172,215,193,84,10,65,89,99,158,61,203,224,96,108,213,54,164,149,13,125,118,120,95,189,114,57,41,211,241,237,209,190,6,62,79,184,242,245,149,195,91,85,198,131,178,227,71,202,112,154,51,82,29,130,223,121,113,6,199,251,129,30,201,68,187,181,197,35,52,79,104,12,235,40,127,72,62,197,101,25,50,235,135,22,61,18,204,9,17,58,139,193,112,118,161,34,157,65,113,190,135,176,140,117,20,216,176,111,50,116,217,162,214,180,80,45,31,21,53,93,2,228,123,100,207,17,230,207,97,240,183,85,31,41,46,45,3,43,72,155,187,165,203,128,67,28,120,236,54,20,65,238,109,110,179,222,136,198,17,77,149,130,251,103,177,204,150,184,189,37,5,55,241,217,14,130,255,116,126,175,235,144,116,140,66,14,51,205,67,99,220,51,208,79,206,154,127,22,85,71,77,215,145,255,44,243,64,209,227,67,73,110,151,218,87,197,55,237,118,245,39,169,244,170,245,203,108,245,142,50,189,176,80,21,202,93,146,1,53,148,177,158,56,213,31,235,149,163,76,7,160,96,185,175,209,247,27,135,158,217,147,16,10,240,197,137,20,206,239,82,56,27,22,220,198,2,89,79,127,31,142,1,6,55,182,200,142,137,107,201,174,111,181,210,207,62,30,104,243,208,79,121,233,86,23,51,192,246,38,237,63,185,68,166,75,123,229,116,251,234,207,59,122,231,68,113,211,62,70,25,143,151,209,232,208,160,147,131,216,54,242,90,239,63,40,144,174,63,16,36,202,26,114,183,89,217,89,136,230,91,48,252,125,202,164,150,89,145,56,123,247,12,54,155,187,186,61,40,196,208,28,136,119,101,36,210,226,52,175,235,200,109,39,72,109,208,243,138,191,212,112,241,255,140,84,135,41,149,18,74,71,117,169,225,47,36,251,47,104,143,61,234,88,50,148,255,119,218,157,33,205,193,198,233,229,11,62,162,92,119,220,137,255,123,184,226,35,157,8,174,39,63,216,248,137,225,131,8,2,82,204,80,214,39,91,209,189,161,6,81,144,36,198,76,197,109,194,10,4,72,54,53,184,115,91,225,10,11,168,200,46,218,124,246,135,15,89,53,166,8,241,71,83,123,154,209,50,174,37,55,123,83,140,20,54,44,56,182,163,26,6,6,190,38,53,147,232,222,149,68,107,255,157,252,151,137,92,252,145,148,33,103,9,72,231,13,116,195,38,2,23,236,159,143,19,6,218,213,124,179,244,182,30,110,173,19,168,90,131,57,252,205,106,250,34,115,21,156,227,2,178,233,51,164,166,165,72,112,14,41,93,38,111,111,37,191,106,207,33,185,185,90,72,233,134,236,98,171,160,112,169,40,190,94,93,171,234,98,137,93,127,65,248,80,186,131,116,191,197,63,31,50,255,195,58,34,142,54,220,246,198,63,55,183,44,126,0,217,209,232,158,8,7,110,86,107,240,61,28,52,138,97,149,20,247,180,192,143,33,83,155,177,22,187,216,48,139,83,169,139,99,123,154,74,125,236,38,59,46,27,30,157,211,15,232,203,47,94,136,56,194,51,139,205,174,21,161,217,7,160,227,59,236,156,91,143,154,27,42,117,22,168,18,246,201,35,37,107,157,58,5,158,76,100,112,62,84,117,50,22,6,96,111,120,207,116,151,161,13,67,239,116,206,98,64,136,103,8,201,197,9,81,239,18,226,93,190,46,81,229,232,167,200,193,215,90,182,212,93,78,67,26,105,97,197,49,164,150,52,143,248,121,13,95,217,227,206,14,80,200,179,171,10,146,200,142,90,137,125,253,146,71,131,33,45,48,69,241,119,153,254,188,241,25,222,97,30,63,46,136,159,57,134,89,0,129,234,189,184,64,200,208,245,48,167,116,134,99,230,3,164,217,19,159,106,99,97,202,22,164,70,66,13,97,32,58,239,114,37,9,60,59,67,157,37,172,251,50,177,13,116,63,7,119,74,90,248,108,175,187,95,134,112,101,157,132,160,143,70,245,232,144,69,184,106,150,9,184,122,224,32,162,162,167,166,203,10,237,99,78,75,217,159,250,237,184,75,97,163,68,55,215,93,14,236,225,12,141,49,8,40,126,117,77,135,80,77,205,97,75,21,26,145,221,123,172,2,182,77,86,93,204,86,114,144,92,13,141,25,97,222,15,100,182,160,159,142,35,220,49,107,187,208,137,105,153,135,0,174,222,172,239,170,133,207,178,208,164,230,211,2,139,92,32,192,133,89,232,32,239,245,110,166,136,37,21,196,131,79,242,98,209,25,180,252,102,119,100,85,102,115,189,106,122,226,157,178,221,143,154,92,187,57,68,241,18,33,225,250,134,114,116,72,134,250,27,40,97,219,30,86,74,184,102,193,26,66,181,24,165,153,255,190,75,185,18,121,114,85,220,59,224,145,174,176,36,67,144,74,196,161,88,9,48,79,220,4,67,25,232,105,176,32,242,28,201,66,116,178,36,164,218,208,31,240,68,239,166,138,242,198,226,27,136,232,255,174,210,152,60,200,61,15,238,2,218,231,198,130,236,180,235,65,221,66,82,162,92,235,251,20,38,65,92,156,106,85,0,144,25,182,28,226,88,153,34,253,19,27,116,90,101,248,35,202,216,184,19,35,2,94,8,209,254,66,212,135,68,219,185,32,107,225,25,227,136,211,138,181,174,112,128,190,66,165,251,135,185,108,40,159,222,177,26,58,26,148,218,89,13,15,27,236,24,118,78,33,185,174,168,219,230,119,230,179,169,161,57,118,97,227,203,9,125,55,136,197,112,94,138,136,230,112,204,245,136,116,59,13,75,68,121,43,122,9,22,252,149,172,182,118,113,61,53,171,44,42,118,178,166,69,222,44,157,34,128,126,179,24,154,159,106,149,17,227,58,143,176,241,222,56,42,62,181,26,208,33,24,30,33,112,83,127,84,65,41,251,206,115,178,2,222,106,153,209,238,98,208,200,210,177,133,86,65,23,104,110,177,161,96,79,57,142,162,15,207,173,153,56,254,250,73,76,74,43,36,200,57,145,60,95,227,21,147,221,41,171,192,107,234,251,74,126,3,247,128,122,243,153,128,202,238,189,17,198,179,70,97,245,190,200,231,176,186,98,217,254,45,230,228,185,78,204,155,64,247,183,255,152,161,26,12,21,183,209,199,194,177,1,221,95,77,76,253,203,104,7,192,167,209,180,50,138,227,189,182,231,239,238,168,59,221,119,154,107,247,102,200,51,40,120,192,133,47,249,238,189,123,233,117,188,210,82,68,72,178,111,103,77,144,205,181,97,1,172,166,152,242,0,187,181,174,188,39,82,5,75,21,213,113,66,102,62,173,169,132,21,120,138,226,211,39,44,143,160,126,74,108,191,13,117,58,148,234,239,194,161,161,156,231,240,170,77,120,106,63,168,175,231,243,60,192,181,236,20,52,239,78,141,78,130,59,219,80,208,24,37,165,109,209,49,251,9,62,80,50,249,181,232,42,228,47,166,191,144,176,206,148,242,148,153,182,121,24,128,65,137,42,161,119,66,94,240,11,55,102,122,7,205,142,144,144,180,47,60,218,192,149,85,15,213,83,8,79,215,104,8,209,172,222,200,242,28,255,51,185,167,33,226,26,65,147,100,114,222,54,27,170,212,207,83,56,170,37,126,121,14,18,40,231,4,14,164,248,6,110,118,48,51,83,228,76,3,131,87,77,86,163,48,72,194,109,53,105,118,111,198,140,133,34,20,119,56,35,236,7,170,176,164,95,86,183,232,105,108,7,25,169,127,50,26,86,83,94,101,58,219,72,205,46,231,78,158,94,221,190,147,92,96,224,0,30,65,191,21,237,118,106,224,247,161,116,33,41,10,92,81,248,232,191,41,72,116,171,89,110,208,62,230,196,11,67,172,81,188,8,212,62,255,199,22,201,68,20,120,21,90,72,70,211,251,61,232,5,238,147,16,91,225,65,103,178,238,63,246,157,100,192,170,206,249,101,28,25,120,125,225,94,105,146,218,75,10,178,103,244,73,77,174,18,113,205,198,233,5,88,129,66,64,72,137,118,81,217,130,206,156,174,224,223,115,249,164,10,160,47,237,255,135,146,236,13,99,71,63,62,20,134,132,135,155,27,21,239,159,60,195,224,248,123,205,45,147,225,233,72,95,151,236,249,144,43,148,51,197,175,100,140,185,170,200,234,37,87,113,85,41,197,41,164,33,181,64,228,58,125,41,220,43,111,47,37,139,69,75,126,166,210,12,7,175,6,63,122,236,237,156,149,142,254,174,11,37,215,82,200,54,62,74,43,2,249,172,218,115,203,91,14,165,110,103,178,200,5,226,141,45,42,68,130,198,173,253,230,217,122,113,39,163,182,160,231,100,179,40,207,8,27,212,22,174,85,58,27,55,118,83,118,244,201,68,167,205,50,31,36,17,250,228,187,200,203,159,109,44,83,197,240,214,82,128,207,62,237,127,108,238,226,36,190,44,152,27,248,90,79,254,43,191,182,206,138,179,239,133,27,56,192,25,166,40,83,172,241,62,178,172,53,58,205,73,6,139,66,50,24,22,193,232,205,173,161,67,139,236,13,114,239,156,46,253,12,218,238,6,255,169,98,117,8,215,156,102,178,212,208,18,175,147,108,96,73,71,115,87,75,254,77,61,212,49,252,42,72,23,95,49,206,208,189,203,240,139,4,56,101,109,139,204,117,23,213,104,47,1,254,115,179,25,96,58,221,157,53,112,19,110,172,118,168,11,21,171,109,123,100,79,124,202,172,155,236,144,86,224,44,183,119,167,51,180,139,191,76,201,173,212,215,120,148,255,149,110,69,229,152,112,197,133,178,122,15,23,55,103,67,13,152,239,59,168,53,175,130,232,143,236,0,96,95,206,91,141,167,127,199,149,82,51,222,51,43,148,225,183,56,32,68,76,97,35,154,233,207,47,2,29,114,143,36,159,81,168,169,22,163,74,208,233,149,204,129,138,138,13,48,180,42,41,155,141,156,228,19,71,135,137,63,119,146,67,61,236,133,52,209,164,39,67,110,28,5,36,100,159,52,79,220,118,89,126,230,63,180,117,243,165,179,147,209,255,162,97,177,43,45,86,56,48,223,195,122,39,130,118,8,183,36,55,42,221,83,72,74,95,130,91,23,121,226,221,206,241,204,44,105,177,188,105,190,84,106,225,244,183,44,76,188,169,150,98,155,208,244,161,94,75,232,173,64,126,153,184,124,75,229,87,31,209,154,93,125,64,53,167,155,250,167,122,169,184,231,14,34,61,208,47,179,182,194,37,87,240,10,125,2,26,125,232,189,207,199,3,153,204,157,148,33,93,160,134,67,238,203,126,198,203,210,112,25,199,23,136,192,135,207,227,224,213,125,17,93,230,177,178,164,152,162,80,107,50,52,221,42,20,128,143,202,168,22,91,223,159,118,214,249,29,184,124,24,124,1,183,54,43,61,91,155,116,241,94,157,187,60,100,244,97,97,177,9,57,90,72,245,38,31,86,172,41,102,15,35,39,4,233,141,9,165,41,137,229,44,122,16,181,99,178,84,124,207,34,140,41,145,250,172,186,100,100,156,162,5,126,187,160,57,183,240,17,46,181,44,120,144,141,151,142,129,195,192,11,203,241,78,134,142,214,106,198,94,141,84,62,51,127,110,9,65,150,68,221,157,131,236,130,114,10,128,197,13,157,252,8,165,223,138,108,179,156,231,156,82,132,196,202,13,64,69,92,110,180,238,15,125,240,30,231,134,56,66,31,193,191,100,72,106,233,11,113,8,121,238,178,117,107,157,215,58,43,212,236,53,215,214,1,16,192,173,175,231,62,113,26,94,248,47,30,36,232,160,227,75,161,127,33,5,192,210,69,155,249,190,217,224,42,17,77,54,231,20,45,5,116,154,154,80,74,148,126,85,137,13,59,123,226,167,20,148,24,19,123,17,78,46,126,232,255,147,20,83,85,103,16,86,141,246,211,162,58,245,162,77,31,51,40,174,164,117,38,201,18,8,240,124,226,180,213,190,92,223,249,184,227,8,168,86,142,19,66,247,142,54,135,218,13,197,216,225,152,61,155,156,171,88,150,158,129,132,144,138,13,21,166,17,156,62,40,147,131,134,66,228,77,177,184,53,207,92,208,3,16,2,45,215,154,73,196,92,47,104,0,94,23,103,132,206,81,105,63,84,231,7,205,95,148,128,250,142,158,42,49,223,26,22,72,27,211,39,245,201,245,4,127,48,221,21,121,201,223,108,209,6,93,31,85,112,207,74,123,201,78,249,139,38,60,134,47,225,21,74,31,177,146,41,144,16,100,28,219,207,21,104,154,200,135,169,238,147,227,243,217,211,187,109,182,74,223,148,201,132,46,26,159,121,196,145,148,161,153,126,127,103,44,44,215,135,248,8,157,23,184,220,82,173,81,229,136,173,243,230,69,68,158,137,156,73,166,209,116,155,166,231,141,186,187,84,175,227,63,227,13,18,245,222,185,2,9,97,179,58,174,246,67,94,255,153,44,100,138,172,19,5,67,221,82,20,224,61,104,222,44,53,106,82,147,130,225,31,218,140,64,109,45,5,216,165,119,100,159,228,18,213,150,192,59,85,135,249,36,228,230,57,28,67,206,105,230,148,212,28,106,92,97,2,31,152,107,208,11,10,205,238,102,126,66,83,190,233,77,232,77,96,85,249,251,119,192,179,5,0,198,67,127,22,157,78,146,64,204,6,39,200,12,229,227,234,242,193,195,141,125,107,248,143,210,251,18,220,67,240,110,48,114,110,15,160,241,14,133,152,132,225,44,134,92,88,11,167,164,225,12,234,164,92,9,175,74,190,164,193,157,232,4,137,216,80,165,124,20,254,221,2,198,63,217,156,135,119,4,178,58,153,215,139,67,52,172,206,47,40,75,33,86,67,63,41,10,20,37,237,37,156,4,13,25,23,201,228,9,237,67,16,22,116,17,184,162,203,188,227,13,110,65,231,79,200,61,118,207,68,161,90,71,47,113,31,224,165,90,23,21,239,63,80,176,54,103,99,60,125,72,207,90,110,231,121,225,205,35,28,16,137,252,136,94,179,14,97,157,227,66,82,219,137,26,78,157,181,147,28,161,251,43,196,201,53,245,149,152,194,86,91,70,203,91,114,199,241,212,180,125,44,131,135,116,26,132,69,27,84,222,132,88,96,163,119,62,129,249,230,33,147,28,124,23,172,231,132,144,182,235,125,193,70,233,206,77,27,210,203,223,213,95,105,230,117,205,214,164,126,23,240,10,34,237,211,43,162,138,230,118,192,86,247,125,167,215,62,26,113,209,175,19,231,246,167,150,22,44,69,31,236,205,198,210,214,123,93,60,9,175,131,96,145,71,92,190,209,201,225,103,43,204,242,98,253,129,95,56,223,107,29,87,165,180,44,49,28,37,42,83,215,122,91,126,77,38,243,71,213,191,223,14,76,247,97,110,190,120,147,167,234,237,10,98,148,45,218,3,23,117,15,148,142,173,118,236,90,31,27,85,54,188,202,253,43,102,109,130,17,8,239,241,89,212,14,29,172,179,90,8,104,5,203,117,188,43,184,167,54,8,100,136,17,55,201,102,193,221,245,173,86,65,162,176,40,92,214,101,18,82,59,131,63,156,187,219,65,190,115,172,242,52,181,80,109,165,136,98,148,149,152,234,86,143,132,100,239,159,119,163,250,30,130,119,190,45,58,208,104,161,144,10,202,200,31,177,215,242,236,78,3,151,34,8,16,172,231,112,71,159,168,32,208,230,50,84,234,214,40,92,65,60,148,117,76,216,111,91,121,177,66,86,123,55,54,126,46,118,241,103,105,245,89,242,0,0,166,87,7,145,164,227,90,30,10,4,88,64,114,70,127,14,161,218,198,16,35,230,115,54,65,108,190,175,186,252,79,33,24,82,118,130,249,181,253,61,28,154,77,227,209,111,63,61,68,223,162,41,90,176,37,114,169,199,77,160,219,199,22,79,240,212,158,243,217,226,74,158,215,193,166,204,82,135,0,106,12,155,150,113,241,197,33,205,6,16,19,118,164,194,115,243,112,162,251,134,203,122,124,61,242,68,140,200,131,168,172,123,48,70,132,227,199,3,196,130,48,55,231,64,216,195,86,36,160,233,137,145,108,224,93,218,61,107,191,138,171,13,215,212,65,223,117,85,120,109,207,141,12,23,221,175,68,130,129,185,138,67,225,85,127,85,215,75,146,79,69,133,10,129,210,51,71,147,116,11,104,76,194,87,78,137,12,108,185,53,10,210,35,135,33,203,224,96,175,47,98,138,83,60,163,16,100,51,21,186,245,7,153,128,164,73,27,189,195,13,61,255,96,12,174,169,37,39,235,177,224,137,71,128,240,63,137,238,255,68,185,212,135,190,156,240,184,158,113,210,241,119,224,63,177,236,63,172,135,117,74,27,187,227,253,246,222,134,197,251,197,243,107,188,160,85,252,111,4,141,195,243,91,73,226,144,131,109,136,10,172,209,186,95,172,96,107,43,22,44,176,226,122,100,50,28,65,163,62,235,88,16,254,97,48,250,64,155,101,21,83,64,255,189,98,142,60,20,184,3,54,87,20,50,178,254,138,105,53,169,141,5,88,57,244,207,138,191,208,185,54,87,134,70,182,197,77,248,201,118,133,148,231,106,241,215,91,61,184,61,250,9,140,91,66,203,141,93,171,166,65,183,29,234,196,85,230,194,177,148,240,126,71,14,92,212,2,120,179,141,11,42,166,15,45,196,187,30,249,247,104,244,5,25,126,208,252,253,157,224,36,138,145,222,221,213,15,204,112,217,50,193,215,194,2,248,214,48,43,229,7,204,79,218,223,82,137,114,228,41,220,68,157,35,245,242,213,255,141,189,192,243,63,72,119,222,107,252,230,192,211,47,186,209,144,213,221,185,22,152,208,54,130,76,100,242,54,210,211,40,29,189,40,7,183,252,209,130,240,76,107,14,110,35,151,57,0,187,180,78,210,153,198,18,212,33,205,72,211,89,150,175,136,7,138,13,18,93,226,93,52,171,126,188,165,113,29,15,231,234,11,67,54,164,115,158,58,48,20,202,65,198,247,224,202,190,45,10,153,146,148,150,218,67,157,27,190,197,15,182,135,56,130,43,203,209,174,134,100,81,179,58,182,229,1,155,224,135,148,214,99,38,92,212,220,49,17,170,248,161,123,88,92,5,119,19,210,149,12,254,121,21,140,38,10,247,25,4,22,186,68,1,211,221,109,182,103,137,4,242,129,66,67,138,61,50,131,83,208,81,53,132,36,86,63,33,62,142,250,210,195,68,246,210,84,77,150,182,48,140,129,1,24,195,122,107,160,22,129,227,250,27,102,21,127,52,229,47,19,58,21,47,132,85,233,11,183,119,3,54,223,94,30,168,153,3,202,62,170,29,46,235,105,186,122,192,71,128,73,149,47,98,46,122,34,64,101,76,177,160,154,47,174,96,118,108,73,203,121,15,19,101,72,99,177,70,118,219,124,182,128,41,154,76,22,204,166,120,224,174,35,27,29,63,8,248,217,183,247,192,11,141,178,28,4,184,73,111,64,221,65,220,21,145,34,163,79,94,28,225,40,146,182,182,2,244,18,250,136,64,65,3,121,52,149,19,150,105,221,244,244,247,77,249,155,100,216,128,178,170,122,153,140,221,2,88,211,227,255,108,191,91,6,185,100,148,31,75,245,179,229,46,107,30,214,20,93,198,142,86,108,83,131,235,38,107,38,203,229,248,160,22,216,41,215,22,55,59,211,156,38,76,79,202,176,49,88,161,162,206,46,81,83,200,99,138,117,40,110,2,84,142,165,212,63,185,183,35,165,96,218,110,177,40,36,21,19,181,76,171,145,175,144,249,115,42,97,99,152,49,128,122,54,8,136,236,196,46,137,181,211,218,83,112,177,64,193,136,89,220,176,221,204,172,174,154,77,96,166,191,132,59,141,90,169,6,46,45,84,193,160,209,49,6,199,255,3,129,73,146,92,31,226,30,164,12,7,148,241,217,3,113,226,199,81,146,95,141,45,176,205,253,233,128,78,74,123,244,138,154,234,99,11,241,18,251,174,123,196,122,254,82,210,2,90,216,87,97,38,253,160,197,255,134,152,168,162,17,72,133,41,122,235,85,154,133,172,162,240,103,107,149,216,192,182,55,27,163,94,52,129,61,154,61,11,135,223,222,154,217,53,135,124,181,120,2,41,107,239,28,32,232,45,27,51,86,176,14,7,40,249,170,100,67,101,131,23,151,200,74,151,82,184,146,40,7,64,240,146,253,80,218,150,108,16,186,224,225,98,8,166,177,252,0,35,95,107,137,80,130,116,129,161,149,37,52,149,240,167,11,50,129,134,80,126,16,233,201,206,97,186,68,205,245,254,241,139,20,5,89,162,39,98,188,107,186,119,233,101,250,245,150,241,120,191,39,29,12,121,31,198,242,252,230,85,160,112,172,171,128,29,103,65,246,39,126,74,92,140,142,56,181,82,101,195,59,71,4,8,9,42,98,180,136,41,26,56,252,4,230,102,239,251,161,183,106,22,54,238,250,59,61,243,9,189,77,195,254,119,234,124,186,211,5,26,88,176,159,87,101,242,100,179,102,218,39,85,82,118,109,146,144,225,73,28,78,77,189,135,29,192,12,95,153,113,248,50,171,113,241,189,121,194,155,247,109,70,124,72,61,27,79,56,185,218,51,155,130,98,183,1,100,60,85,55,160,158,110,41,58,63,216,176,49,228,195,87,118,254,105,223,41,138,84,41,78,214,111,49,206,175,91,190,57,25,68,120,22,127,85,81,202,226,197,123,156,169,249,12,182,148,31,115,211,146,41,208,248,249,197,188,103,47,138,8,117,43,130,28,28,102,44,149,38,221,176,211,11,76,148,186,176,252,87,62,69,3,88,80,123,168,196,245,128,224,186,224,99,220,46,237,181,88,159,161,175,204,237,160,154,13,131,12,99,88,171,231,111,242,238,194,193,15,3,254,152,148,114,131,215,216,106,245,73,197,176,147,149,25,185,200,252,52,225,236,86,240,34,22,76,102,243,132,148,11,204,125,58,185,37,184,188,4,169,89,249,104,232,254,3,96,102,68,177,242,8,251,188,177,100,48,1,248,177,185,181,108,161,130,117,35,229,28,94,131,105,31,242,158,200,167,63,124,21,55,142,139,10,202,5,82,209,8,37,48,22,47,237,174,182,254,11,32,46,255,142,78,113,207,192,187,172,174,16,156,90,26,138,142,57,129,2,59,148,175,197,194,242,205,81,57,214,199,206,60,204,225,254,113,28,148,222,242,209,101,104,98,108,237,223,49,114,212,129,78,146,78,208,40,162,230,188,127,198,195,47,15,146,82,173,159,186,217,133,148,237,194,5,33,102,245,90,65,8,165,35,12,231,205,62,97,232,36,7,127,30,119,233,149,99,221,178,173,102,226,168,250,196,60,181,5,125,126,243,158,64,110,37,30,195,162,229,136,241,198,229,105,88,85,49,14,96,84,216,55,253,53,92,172,24,38,54,35,37,50,118,149,84,244,199,203,56,87,218,44,100,7,25,135,147,55,101,115,200,99,37,8,239,72,221,30,76,8,86,146,55,44,91,241,31,111,230,90,185,168,144,245,50,43,46,238,33,229,223,34,244,14,118,219,103,141,110,249,21,49,255,202,251,214,126,66,144,34,95,94,195,240,131,109,100,123,73,158,69,82,217,206,59,169,190,31,185,211,83,88,73,74,185,229,228,147,57,21,198,39,234,143,84,167,170,144,247,206,56,43,55,104,193,157,220,89,125,173,151,17,4,10,18,124,244,41,133,194,59,11,202,98,174,212,26,19,95,71,26,82,242,133,85,125,4,131,36,108,37,250,255,99,63,15,53,173,129,255,175,83,105,132,142,35,4,243,133,67,237,220,88,25,169,219,83,229,33,83,46,251,0,111,226,87,41,226,98,245,208,93,251,94,207,210,41,146,56,119,137,32,0,61,212,6,161,219,144,112,202,88,124,132,83,197,240,185,196,152,34,202,136,59,198,165,5,136,11,246,158,60,3,176,105,203,207,70,162,187,45,160,39,60,82,115,113,239,37,166,188,235,215,222,227,65,73,188,70,178,98,215,247,7,12,10,4,216,139,202,178,125,231,103,79,61,127,58,10,202,75,42,107,139,214,172,4,14,3,23,73,247,52,158,78,61,218,235,79,191,182,70,127,157,34,208,242,177,248,153,110,42,50,168,186,212,159,202,174,245,161,60,197,47,221,200,111,195,231,35,136,145,196,62,119,52,247,41,50,41,64,94,231,136,149,213,174,127,157,61,143,47,166,152,59,245,186,16,70,32,201,49,239,157,90,225,122,138,88,158,93,59,121,246,69,151,25,182,189,199,100,74,131,123,99,103,185,138,240,169,255,83,8,240,13,159,156,5,223,181,247,243,244,179,90,207,159,36,69,34,174,29,39,12,198,108,220,130,2,10,203,188,206,67,116,209,27,67,170,198,93,113,250,14,198,254,196,37,146,198,0,245,162,19,196,105,30,136,94,211,48,61,213,53,160,236,102,140,240,236,1,246,124,73,73,184,88,243,157,125,154,77,39,104,111,1,205,78,22,233,44,37,253,92,198,51,8,211,150,43,192,106,122,208,21,123,140,14,148,222,144,217,194,15,242,120,80,45,66,71,74,147,132,37,185,45,165,41,76,166,143,130,134,3,4,15,104,214,102,179,162,238,195,200,235,20,223,172,249,110,37,43,216,136,128,232,235,48,215,2,250,173,82,109,146,30,125,217,231,73,206,65,2,40,45,35,163,248,230,102,19,67,102,0,76,64,7,130,23,167,105,28,152,26,73,234,15,36,35,231,146,205,50,217,164,199,154,192,15,19,80,26,30,181,14,197,12,131,88,61,140,86,85,233,182,210,78,143,77,63,177,30,176,10,224,14,137,130,162,84,191,108,227,75,85,115,237,159,119,222,168,131,18,13,22,92,110,176,134,71,180,31,116,154,111,4,116,74,59,2,191,75,114,181,184,238,106,236,202,251,63,247,48,35,155,172,61,122,174,26,38,3,176,42,15,71,195,153,55,66,191,33,169,177,220,36,95,177,66,86,173,31,180,219,166,178,139,120,139,67,88,25,238,233,169,169,111,163,217,54,29,44,34,138,236,199,35,50,82,214,30,125,91,25,222,65,137,125,96,232,78,167,209,68,71,70,1,22,163,34,202,200,71,113,235,157,41,14,32,110,171,235,197,174,10,51,158,251,44,98,199,201,196,168,50,201,99,205,245,153,75,169,17,143,154,52,222,138,28,173,86,92,134,115,136,220,131,85,171,122,218,117,190,117,143,79,26,121,10,50,45,80,241,33,4,253,140,1,159,201,105,123,35,133,81,59,236,16,238,109,215,10,124,211,64,112,180,147,203,106,142,69,97,205,162,177,217,151,174,189,239,69,50,30,166,238,219,120,79,225,197,121,127,91,215,89,102,17,39,158,213,94,164,254,49,125,216,191,222,90,38,224,214,242,60,2,38,241,139,218,34,185,186,30,206,33,43,38,242,81,191,12,1,200,96,167,125,197,194,127,129,244,184,30,74,74,196,174,229,224,226,124,52,137,122,146,108,187,169,127,72,111,131,243,79,149,236,134,103,137,212,161,44,61,183,188,103,150,96,95,88,187,167,31,213,185,63,128,70,10,58,47,69,155,112,231,242,129,19,78,116,74,152,85,44,128,199,241,148,56,48,27,194,180,191,35,170,227,179,166,110,172,88,208,185,53,153,120,109,155,216,205,172,159,59,191,94,49,209,213,90,125,246,132,153,163,89,50,28,91,141,185,11,4,229,210,18,79,36,117,191,90,231,97,92,89,193,98,201,7,9,252,3,100,157,87,134,164,29,218,54,7,117,232,97,226,74,185,43,135,78,199,151,206,137,157,244,201,49,137,164,23,115,134,121,92,128,224,192,100,154,252,124,146,17,129,44,130,237,65,159,194,35,88,56,132,29,163,200,91,112,118,35,100,76,112,87,180,233,171,69,124,62,161,232,54,66,129,248,193,47,232,197,143,236,112,36,132,61,97,179,231,60,124,4,220,161,114,16,84,196,143,200,58,98,2,255,8,3,222,42,146,204,234,68,199,78,202,173,32,215,30,242,64,32,250,49,111,31,174,191,209,40,51,55,101,12,137,212,116,140,72,132,52,104,204,245,218,122,29,236,175,188,112,137,112,129,225,22,84,118,55,75,104,13,207,51,243,102,148,120,49,86,192,53,173,30,143,161,0,187,160,141,185,32,104,37,221,242,44,29,27,162,135,12,4,205,239,98,8,217,237,81,207,29,240,169,209,6,80,56,120,99,193,90,244,235,14,45,162,130,224,62,152,96,147,9,238,188,49,82,151,207,8,240,126,39,228,192,121,199,227,52,238,238,69,130,134,174,90,34,126,176,133,63,234,79,219,126,186,224,106,183,242,244,90,180,161,17,110,155,66,109,222,205,83,121,103,49,85,234,220,198,98,67,0,50,194,21,182,193,118,19,220,4,173,96,221,203,40,186,232,98,162,37,12,169,225,26,229,12,71,121,194,162,100,159,139,30,0,151,86,14,131,219,129,154,212,170,79,126,26,171,90,92,239,0,106,79,97,213,183,128,12,238,216,30,67,114,73,64,191,22,179,225,12,252,220,234,87,55,51,145,66,34,63,168,252,148,87,47,176,54,228,85,152,226,61,198,41,76,94,182,131,134,142,127,97,14,232,78,147,107,91,23,55,184,220,0,132,128,230,214,41,253,146,45,59,69,244,78,228,127,47,234,235,212,197,152,203,251,16,167,93,153,46,245,207,238,82,246,96,131,4,123,250,67,9,15,63,198,214,205,18,51,223,238,190,104,69,185,188,1,61,168,132,22,21,224,86,237,119,49,15,228,241,216,161,180,19,252,22,109,144,133,49,21,97,145,73,250,32,160,0,103,179,235,69,26,206,44,140,184,97,110,167,21,84,228,112,18,154,24,41,60,232,190,168,43,72,248,82,221,13,138,79,89,140,122,61,117,232,17,75,243,217,88,218,235,50,96,182,174,230,168,249,99,90,3,240,143,171,128,49,247,62,32,242,216,73,239,88,172,30,77,172,78,40,138,46,152,178,103,92,139,57,224,167,208,14,63,245,78,69,235,225,103,133,134,96,22,32,104,77,117,153,192,206,38,183,221,117,253,207,240,211,16,89,105,251,119,74,144,222,156,150,154,58,135,38,58,165,24,125,4,181,205,243,117,226,156,243,80,70,66,176,146,37,197,55,215,99,87,148,92,191,170,198,29,60,48,57,132,232,226,100,191,28,143,184,235,205,69,47,243,18,71,89,96,148,5,68,98,120,4,46,222,166,248,156,123,31,13,147,244,29,153,133,248,130,207,112,2,139,131,49,115,58,120,121,244,170,19,97,201,192,75,161,137,127,83,157,78,253,58,222,224,220,83,182,11,236,101,153,140,34,113,36,254,143,112,151,78,23,46,155,32,170,178,239,64,77,243,128,127,240,27,82,213,68,205,87,27,42,124,75,156,9,234,4,161,210,181,7,140,130,78,31,105,100,208,169,223,62,105,229,132,50,56,128,226,5,184,254,213,116,54,2,93,233,67,132,34,39,179,133,27,209,227,163,127,21,38,10,175,140,28,114,70,190,173,123,166,31,176,23,83,27,2,64,147,250,217,95,1,100,211,238,42,151,65,188,182,234,61,134,64,31,245,14,173,167,214,244,223,242,182,230,208,180,241,228,142,135,251,1,188,189,100,175,18,181,117,35,14,102,136,20,208,168,235,41,228,102,112,204,114,197,137,63,144,1,174,122,8,52,194,119,247,169,229,16,103,124,105,126,128,30,165,102,132,107,24,55,253,220,212,101,202,129,150,144,2,88,195,9,152,160,243,97,168,80,228,18,168,79,186,193,151,206,197,164,32,6,58,126,128,178,154,122,20,188,81,123,96,6,46,214,149,107,24,177,129,255,208,247,29,66,228,212,126,81,168,1,76,131,174,108,141,122,248,24,107,113,170,68,235,117,129,83,56,163,148,130,79,104,185,22,138,198,242,77,180,102,47,117,225,233,90,16,225,8,163,241,112,173,15,227,176,197,136,139,114,202,96,151,63,60,96,154,107,17,147,224,206,248,93,53,106,235,229,60,87,165,173,67,60,192,40,25,38,154,183,128,195,41,187,21,254,166,61,76,158,20,29,63,194,131,191,180,111,32,193,245,193,122,94,224,84,142,94,172,150,192,219,151,49,107,61,164,252,204,72,119,227,21,253,120,84,60,176,113,224,172,24,196,92,64,19,6,114,3,127,121,48,40,3,60,52,74,110,225,56,14,140,23,179,58,129,206,230,166,25,190,123,31,5,201,50,253,204,94,174,116,91,166,97,216,90,145,201,152,88,164,18,19,17,202,204,251,146,159,61,233,43,209,63,240,241,168,94,78,86,211,0,62,97,12,204,199,62,218,65,64,9,170,91,210,0,191,56,249,81,51,140,84,246,229,192,59,27,87,104,195,108,174,216,168,188,98,234,57,57,162,193,13,190,155,45,124,40,58,32,99,14,179,68,39,112,92,159,159,36,201,2,226,129,171,120,102,185,148,114,152,162,196,181,56,69,182,37,197,98,228,38,41,142,10,57,84,197,160,183,210,236,9,42,214,224,63,62,31,118,26,251,177,236,185,210,104,244,19,251,195,113,141,34,50,255,204,42,56,117,66,203,139,249,119,14,28,203,175,32,42,245,180,104,11,154,25,127,248,60,200,28,180,91,39,244,161,108,240,140,189,72,32,119,76,235,30,100,46,74,250,110,234,232,192,243,51,124,39,251,186,123,64,23,149,105,161,56,180,49,163,245,34,42,187,145,64,13,82,135,95,186,146,44,214,135,104,194,94,110,93,178,242,130,21,226,63,156,184,127,204,241,167,193,180,9,237,106,90,105,165,19,198,246,140,189,35,66,77,27,170,145,237,170,99,161,189,234,238,51,219,82,212,214,32,43,128,193,45,163,2,216,44,192,84,104,92,99,93,116,94,163,255,90,174,176,184,147,127,46,68,22,63,23,62,151,173,125,237,52,101,54,144,205,184,145,103,197,86,53,11,127,158,118,175,217,13,86,251,47,11,230,181,185,174,212,134,254,17,229,174,154,246,87,107,230,55,252,104,84,104,251,201,66,110,183,24,71,54,10,178,175,12,182,18,163,73,203,244,85,216,175,129,81,60,17,112,71,155,136,34,122,134,137,245,172,152,64,127,55,97,0,148,116,138,88,45,172,16,250,169,10,55,168,155,249,246,117,74,112,183,220,144,84,127,245,255,79,75,162,219,9,150,235,53,199,122,194,58,198,192,83,66,183,114,7,36,198,143,179,218,40,178,248,218,185,108,140,103,50,91,31,235,191,230,109,62,140,189,224,31,241,31,255,48,167,106,18,242,164,95,24,208,232,159,107,188,95,66,187,61,92,245,43,201,191,135,1,41,19,255,103,156,115,9,219,112,48,74,62,113,152,120,196,200,133,105,206,67,75,26,102,159,159,237,244,74,119,46,70,217,24,102,5,82,212,11,224,67,44,241,148,125,122,140,30,141,56,185,122,202,228,228,152,203,143,221,92,116,168,69,113,89,106,187,215,201,255,151,132,143,105,97,52,138,102,179,146,194,72,5,11,142,16,31,119,218,54,11,45,117,143,78,191,169,116,115,101,231,67,196,81,203,175,126,36,74,3,153,52,15,176,118,87,2,10,235,166,166,25,217,24,97,56,174,121,208,62,83,81,159,25,1,81,67,213,89,71,34,140,83,221,7,159,118,96,172,176,235,249,185,28,97,166,17,64,245,165,23,63,251,128,105,12,76,148,92,91,188,236,238,25,184,58,203,60,22,171,192,183,224,144,158,173,39,61,188,92,76,155,181,102,5,187,207,150,94,58,3,250,36,236,210,151,254,24,164,165,111,28,108,229,47,22,146,124,12,137,148,24,184,174,127,13,247,114,83,177,100,178,209,116,247,77,184,99,249,116,52,90,208,48,242,239,23,251,172,248,54,133,62,24,240,90,110,209,64,19,65,231,127,36,40,74,61,89,232,108,40,133,183,241,255,164,20,180,249,37,233,11,144,123,198,10,134,56,30,115,232,181,188,113,167,11,26,133,132,207,13,144,114,236,85,141,70,151,42,10,176,211,160,243,33,210,57,247,197,33,32,215,207,152,153,82,222,95,87,217,232,251,9,157,52,92,92,186,221,244,36,132,244,171,126,222,212,178,213,118,239,52,68,215,228,157,37,229,77,151,40,95,205,177,209,250,59,223,193,65,135,147,161,220,60,30,20,221,12,251,251,237,115,218,76,211,222,227,113,244,133,150,144,25,141,230,202,17,219,118,142,8,254,249,111,8,74,66,92,214,206,5,252,176,47,65,208,174,127,25,182,208,254,125,215,136,104,95,122,148,47,160,24,171,217,115,108,36,46,111,121,54,209,200,78,201,242,47,82,146,153,116,84,30,151,175,199,2,189,89,106,30,113,219,11,101,233,191,165,1,168,238,15,156,187,76,114,205,125,10,232,251,59,152,234,16,241,125,111,195,40,170,83,198,62,219,137,128,20,195,25,33,235,77,95,39,151,116,175,239,44,250,171,84,173,154,211,23,212,157,160,162,208,164,16,244,147,14,14,17,6,104,150,53,108,250,78,227,27,137,22,252,98,238,175,243,37,70,13,183,79,164,152,113,101,78,244,30,197,103,210,103,214,38,156,171,0,17,21,28,178,30,168,20,31,200,208,51,52,113,15,151,103,235,237,40,10,81,34,216,193,173,182,231,138,223,70,74,110,140,135,128,67,193,157,182,109,142,223,157,163,206,148,192,228,100,183,148,130,219,246,217,18,184,83,27,227,178,40,188,85,136,45,33,244,69,87,159,128,40,97,108,157,0,46,148,60,23,222,235,38,205,188,53,18,244,187,182,168,183,237,144,27,24,195,130,65,220,216,15,20,137,249,27,41,218,232,246,197,92,106,119,80,113,188,192,30,233,34,219,39,146,187,114,27,18,165,104,236,249,38,44,105,166,205,230,49,128,243,36,251,113,40,38,25,215,224,120,27,235,159,12,92,34,87,109,158,74,60,6,136,178,187,38,91,137,86,88,121,201,214,195,151,83,64,228,135,143,158,147,97,176,188,111,251,247,113,197,192,23,113,9,177,188,15,65,193,111,153,189,107,45,251,63,75,15,75,144,12,21,147,41,0,174,131,76,50,32,230,156,172,12,21,217,99,174,122,176,90,142,255,218,205,218,102,252,254,211,225,2,68,190,66,50,226,64,173,14,103,174,112,42,47,226,144,59,125,110,69,123,255,9,156,24,136,238,168,115,76,198,25,170,142,181,178,27,82,125,25,38,98,50,248,232,139,82,51,79,162,74,26,73,204,26,40,13,40,2,73,96,105,177,92,99,35,99,110,56,185,105,177,205,31,100,153,114,150,60,150,252,43,129,210,116,71,159,252,129,54,152,242,65,180,226,15,50,224,127,124,175,143,91,38,46,62,8,22,59,186,178,38,77,246,103,48,216,212,109,56,156,174,127,24,51,123,161,249,178,142,219,27,68,158,78,254,94,242,73,34,240,204,200,93,216,7,25,228,165,205,3,19,2,181,77,104,175,11,217,230,194,135,111,69,253,161,56,50,214,192,155,137,146,17,189,167,202,57,121,74,241,142,45,201,161,154,57,125,92,44,130,241,88,74,115,124,14,144,36,13,187,40,11,139,4,59,158,157,206,13,92,151,135,1,219,94,61,152,173,99,202,240,172,225,103,253,248,69,184,171,34,33,169,218,245,125,15,58,199,178,40,202,80,134,75,170,110,92,65,6,58,200,15,51,116,102,229,188,24,164,185,80,221,62,235,227,1,238,159,158,44,47,211,248,136,211,153,57,241,104,231,90,19,39,187,253,118,187,69,91,208,213,90,157,249,110,157,246,186,4,46,212,11,235,27,55,22,236,16,139,224,123,76,76,174,18,156,21,2,25,59,83,147,157,186,202,18,243,139,77,192,205,43,11,67,231,130,169,53,171,6,241,244,138,2,96,125,93,209,194,120,187,162,104,129,237,118,242,149,94,212,207,222,141,202,202,204,103,231,34,132,92,157,95,239,176,202,195,185,87,154,63,219,10,215,8,146,73,190,222,17,110,27,90,35,66,27,93,191,17,12,120,158,138,224,58,68,152,169,243,48,157,252,163,132,148,157,222,184,145,161,202,141,123,93,61,82,14,213,82,53,66,165,100,215,10,77,207,216,139,35,208,176,63,63,80,219,7,147,222,36,12,252,16,92,225,56,96,70,218,129,99,205,25,99,208,253,109,43,104,153,0,224,39,192,163,67,138,85,157,8,128,148,197,89,194,87,99,206,81,141,47,214,217,156,211,187,184,220,33,32,20,31,143,48,136,147,54,141,147,129,53,91,215,115,208,74,187,36,225,92,30,238,23,79,195,80,124,161,28,40,129,212,156,128,13,94,16,64,122,47,166,181,116,236,218,16,106,162,20,12,250,106,59,75,168,173,41,229,75,239,230,135,79,240,61,106,144,243,222,80,207,8,155,238,226,204,246,25,2,83,116,227,42,121,189,61,88,237,200,221,66,111,84,209,44,204,5,74,21,249,236,194,187,52,103,164,109,114,191,27,0,240,99,60,253,103,92,69,90,87,109,109,138,61,171,55,129,98,152,62,65,82,93,47,130,95,171,12,145,48,243,4,220,47,118,144,188,144,153,224,242,141,144,94,218,128,144,77,106,98,182,215,118,91,73,238,22,122,110,3,109,89,91,34,0,57,72,86,228,158,153,209,235,58,200,213,223,68,254,49,210,128,11,87,0,207,25,93,183,141,193,9,142,11,15,213,209,90,220,249,117,222,163,188,42,116,162,111,235,175,70,29,243,205,184,46,214,112,219,68,27,190,37,228,13,196,98,127,58,220,90,248,241,41,128,82,170,102,78,72,99,103,47,49,238,210,203,217,40,130,83,98,143,81,119,52,173,166,24,234,61,253,11,147,118,189,128,69,161,207,122,161,251,67,139,246,0,44,109,95,241,166,224,177,225,201,10,38,201,24,44,192,55,22,191,109,159,167,39,67,213,33,100,6,197,183,223,105,223,51,37,21,232,53,7,12,64,243,13,77,22,76,175,156,127,201,50,147,144,135,179,71,59,88,161,195,29,23,213,184,66,77,202,54,134,198,21,205,74,59,68,197,2,150,28,192,219,164,192,158,231,193,240,26,176,33,136,97,129,95,91,76,114,79,86,97,220,135,80,233,39,150,150,27,223,206,160,84,151,120,226,45,231,200,167,121,200,46,1,132,39,112,88,96,85,173,249,29,67,46,208,224,131,84,81,64,218,16,15,12,243,215,86,157,212,204,147,221,26,11,10,114,75,9,240,8,16,58,152,196,219,149,51,8,94,225,203,7,157,156,249,220,220,207,80,128,47,103,189,58,38,83,183,122,51,230,254,146,160,37,235,226,233,55,164,177,33,246,224,67,54,25,126,27,216,100,83,102,46,231,99,215,206,57,243,30,174,54,153,209,116,17,156,121,215,104,69,33,59,37,187,95,75,158,233,68,148,64,236,174,32,201,143,189,99,126,50,216,65,155,184,98,84,102,243,47,178,99,59,227,198,213,53,206,39,35,180,9,162,212,58,190,48,80,234,176,124,165,130,234,100,117,5,245,122,210,159,134,31,165,144,196,154,81,131,130,236,180,4,23,225,45,144,92,99,117,71,130,142,141,103,81,168,211,2,123,203,171,59,133,24,46,169,116,160,216,233,44,215,66,201,119,51,58,75,50,68,116,127,170,113,129,55,193,109,155,237,246,191,189,150,135,24,5,204,65,201,86,15,202,87,40,122,227,52,245,82,182,54,65,104,165,101,190,208,117,246,203,163,168,171,35,67,186,170,221,100,63,0,206,157,229,28,237,147,132,88,91,215,64,64,22,48,88,246,232,140,146,211,199,110,230,207,238,78,66,78,104,253,244,227,114,94,210,30,6,33,43,1,110,176,2,156,178,126,202,213,183,124,213,218,56,96,100,54,192,53,69,60,180,73,48,142,15,85,251,191,216,147,246,47,251,203,203,138,14,174,9,73,186,102,220,0,200,22,56,137,234,117,155,105,229,151,192,129,193,93,234,222,103,57,195,107,240,92,18,180,41,23,23,255,255,135,26,222,109,47,129,205,129,52,192,82,153,195,24,72,58,156,127,159,210,114,67,196,173,239,17,84,216,115,57,151,70,218,133,179,61,149,175,160,128,222,103,91,202,239,92,198,173,251,58,186,236,105,215,23,167,254,58,4,21,22,17,213,211,230,47,195,183,154,245,187,224,165,236,107,184,195,149,49,79,138,158,97,201,64,138,145,249,37,253,56,175,148,83,197,74,69,186,47,38,63,14,241,224,30,52,152,74,163,144,190,253,92,176,164,109,217,165,118,19,56,214,162,10,193,213,18,95,72,55,150,22,199,50,196,111,155,204,32,122,25,68,234,156,43,178,92,160,204,83,138,2,184,248,7,132,201,144,69,176,216,12,49,175,55,89,163,91,23,159,27,226,183,111,153,13,35,140,237,237,170,126,119,171,55,105,81,53,55,142,131,46,39,136,83,145,158,216,192,73,71,22,117,124,243,85,81,130,52,28,216,143,226,153,141,3,162,141,249,125,8,119,27,65,133,135,123,117,71,161,45,130,255,194,160,178,21,123,106,105,199,3,146,205,115,157,18,61,181,226,101,151,234,244,10,17,216,104,186,3,215,32,157,200,151,190,41,62,181,74,5,160,213,185,70,97,253,164,115,81,108,228,207,4,144,210,54,224,36,93,21,210,109,58,54,121,127,235,182,110,122,161,24,48,114,193,83,31,221,109,136,70,83,212,203,195,232,231,69,5,55,157,106,77,101,19,58,55,127,91,240,85,64,11,229,155,10,93,177,2,144,20,75,121,186,81,171,50,1,196,62,217,231,16,206,250,186,173,24,60,218,230,99,216,36,3,103,61,237,73,61,170,38,35,224,158,166,103,119,128,4,5,152,194,141,234,113,149,54,196,25,235,18,81,227,137,137,138,115,20,204,38,189,115,69,224,31,135,6,32,171,72,87,42,144,71,72,255,171,79,132,159,83,151,209,62,152,25,79,133,19,172,154,90,84,80,101,131,150,37,245,195,199,210,235,98,122,229,215,7,164,79,63,62,80,142,144,161,189,235,24,212,200,109,145,185,104,122,29,112,81,147,15,4,108,147,244,184,155,249,18,80,201,174,227,93,226,109,63,7,17,14,209,141,194,160,30,170,18,60,144,32,224,177,0,106,248,126,107,84,185,179,106,146,13,238,80,251,18,50,96,122,216,217,112,187,148,102,111,47,244,158,22,39,76,59,150,43,22,117,202,253,88,26,166,126,243,142,239,81,69,185,255,93,56,20,32,232,185,22,217,19,198,221,159,42,176,105,127,180,90,189,136,213,241,120,92,0,77,136,165,142,142,126,142,164,219,231,41,237,134,253,191,235,254,252,57,52,25,89,120,215,145,142,87,152,149,107,177,79,86,176,4,105,59,150,254,14,74,110,116,206,16,0,218,98,156,66,18,10,16,202,136,15,80,236,236,233,75,132,186,168,174,233,16,240,124,0,189,243,98,252,33,121,215,44,173,199,127,71,233,97,165,227,102,12,62,59,225,180,119,55,117,95,159,229,177,99,143,111,247,182,37,180,23,219,51,67,250,113,124,122,213,160,93,82,156,170,252,0,1,76,22,11,250,91,147,112,1,233,251,21,112,60,137,25,215,114,231,83,28,55,129,94,198,200,247,80,156,163,198,211,214,235,239,111,210,160,137,128,181,114,163,61,8,94,83,46,49,30,181,239,140,222,109,66,167,226,89,159,32,73,145,21,222,213,65,62,66,94,137,206,128,169,236,73,167,141,150,232,238,36,44,136,68,28,4,21,153,225,253,254,31,210,190,138,17,5,228,142,90,163,91,64,60,208,230,70,88,201,198,140,171,37,112,143,83,251,39,36,63,189,48,135,196,100,189,76,124,37,117,179,153,183,236,97,94,72,5,144,76,23,71,22,137,91,101,17,51,31,37,37,248,167,248,202,225,125,28,24,192,51,67,242,20,243,183,110,138,211,210,110,39,221,189,226,241,100,225,217,111,128,6,152,234,156,179,79,2,139,150,103,51,47,252,21,104,71,84,83,243,17,144,151,52,96,128,26,163,179,77,162,97,109,136,128,106,219,50,111,229,203,148,252,102,19,181,220,239,169,7,60,6,173,111,160,55,24,162,69,223,39,186,222,104,184,206,203,0,68,178,244,108,51,107,230,205,176,248,207,12,225,122,184,184,1,99,226,173,135,71,136,45,243,127,168,160,134,31,180,45,53,1,213,36,43,83,51,59,61,115,223,67,123,54,86,38,128,71,198,210,179,241,150,253,253,1,26,104,127,234,182,86,121,188,19,134,211,19,249,75,96,210,137,255,175,48,38,23,82,107,180,73,87,97,17,31,217,160,77,243,143,164,224,77,154,152,148,205,66,240,48,168,156,21,103,19,214,154,17,173,156,16,31,18,63,134,224,211,145,46,114,33,113,105,125,72,78,202,25,183,28,255,45,63,169,16,225,2,237,156,45,254,223,125,195,250,99,49,156,250,188,216,169,104,171,157,188,114,72,110,29,153,187,99,254,51,237,255,23,98,131,248,193,121,59,142,7,176,78,52,182,134,170,136,125,40,234,245,225,74,212,208,176,105,253,8,32,143,69,180,249,246,10,31,176,129,144,255,199,193,59,12,181,231,207,169,241,243,19,253,220,49,45,195,42,147,102,239,117,186,240,63,156,184,43,225,119,87,44,38,11,106,231,241,208,145,167,222,147,22,240,37,62,139,30,249,0,209,78,164,84,131,254,178,126,91,170,226,29,73,170,154,101,221,202,18,92,146,134,178,38,195,106,88,228,86,86,172,34,113,89,4,85,139,78,39,3,161,49,94,245,107,21,206,162,64,240,35,201,126,89,226,156,229,141,165,29,4,22,197,202,125,44,200,64,176,137,55,95,167,234,104,86,244,217,45,234,206,4,6,171,85,146,235,237,168,81,103,77,204,104,16,110,90,132,100,240,72,96,188,201,254,56,43,229,76,8,144,250,190,182,102,89,64,104,238,222,184,173,138,130,235,233,91,226,30,237,38,236,194,116,180,36,198,97,37,242,32,60,224,15,13,203,190,121,127,41,1,108,205,117,79,104,173,232,164,128,0,31,193,82,164,115,1,175,199,50,22,0,215,136,87,212,105,174,240,47,27,51,93,165,183,61,96,31,150,125,70,38,192,85,215,191,65,159,42,123,59,211,210,39,96,64,53,80,103,134,214,75,89,23,40,114,4,148,61,56,175,176,119,180,61,162,119,184,21,110,204,103,52,202,109,151,202,204,240,215,165,116,96,52,113,64,112,42,171,54,172,169,69,253,44,153,24,232,19,141,73,3,80,141,143,57,23,209,218,79,5,176,20,117,197,223,97,0,0,216,103,205,251,42,189,173,104,182,224,240,187,184,90,150,165,151,54,237,248,21,195,252,26,86,186,43,130,85,173,165,88,77,47,61,60,251,197,177,40,114,201,153,72,161,39,61,136,217,22,39,227,180,112,20,184,0,22,255,248,87,132,120,113,8,6,226,212,166,57,112,185,75,15,83,79,196,106,136,205,5,59,250,63,35,80,140,176,236,196,248,3,221,98,250,104,32,99,152,165,109,139,192,40,49,68,14,50,89,102,202,12,64,120,114,49,227,205,144,18,43,180,65,47,167,89,67,145,180,44,241,173,23,232,86,141,103,210,72,240,225,180,133,221,238,4,125,161,121,44,204,5,162,64,34,84,167,152,247,154,190,162,116,71,83,180,181,174,3,151,227,180,162,28,198,133,1,195,199,54,251,220,4,182,126,209,15,24,207,187,240,50,11,120,250,158,87,125,246,74,64,175,190,21,150,255,202,170,125,38,228,16,24,166,186,7,113,0,133,182,112,138,188,2,24,120,236,10,76,154,89,48,23,228,159,219,144,219,209,76,59,25,100,202,46,203,178,117,252,97,240,97,42,143,205,52,199,220,7,0,109,217,139,126,170,178,227,213,192,16,171,133,173,237,240,186,6,14,155,94,157,194,99,123,174,181,74,164,126,56,178,0,172,77,163,74,172,53,5,161,130,161,162,149,232,150,69,170,172,59,70,142,112,87,58,16,192,67,8,250,29,140,221,17,117,167,133,43,180,141,157,214,18,131,114,105,147,206,25,138,207,188,30,41,9,97,113,247,123,251,56,165,182,239,95,79,152,45,113,160,213,230,249,227,167,149,52,172,156,182,242,134,61,19,90,144,248,100,252,168,76,213,246,126,123,175,8,114,218,41,247,90,229,94,238,86,73,43,35,42,116,168,217,75,167,166,122,230,82,130,255,164,51,9,86,79,111,49,152,198,132,96,62,12,131,23,66,96,51,213,29,13,144,20,26,228,66,41,228,68,254,126,173,192,51,62,41,184,136,182,93,102,144,250,65,236,200,19,121,182,87,125,72,97,132,164,29,130,211,26,115,217,177,199,35,54,132,98,87,138,188,229,34,130,240,81,186,231,130,41,17,74,64,27,41,169,251,229,192,38,247,81,85,224,10,181,80,164,164,112,73,150,53,119,166,144,157,52,98,187,48,28,64,77,33,237,100,1,46,123,40,27,232,128,105,190,126,27,132,205,16,107,184,30,187,240,29,128,81,177,9,175,37,159,188,53,109,59,15,33,102,39,182,31,73,163,176,14,150,178,216,231,41,152,253,100,240,46,106,181,137,111,240,101,204,74,57,134,179,49,230,134,124,152,70,64,166,43,65,203,80,53,157,166,39,138,142,243,74,145,217,9,194,93,128,67,93,129,161,161,254,211,189,239,205,32,171,253,118,141,204,240,183,222,146,198,220,187,58,201,238,218,179,206,89,183,40,198,33,53,38,40,144,216,247,161,189,216,173,9,22,72,148,174,45,3,127,35,125,111,140,15,207,119,246,38,244,195,69,85,106,121,28,241,125,124,103,116,108,152,84,133,165,68,92,5,189,160,223,125,159,69,84,91,214,24,52,36,207,180,152,8,156,70,209,194,220,165,138,212,192,246,132,124,186,64,218,179,23,131,210,117,7,15,197,250,249,187,104,74,19,195,232,168,66,171,125,133,252,89,123,236,67,152,150,187,82,161,241,29,160,206,15,254,101,201,34,79,182,6,88,237,204,67,3,24,199,64,58,22,71,118,31,80,235,148,111,111,74,248,229,15,0,160,215,0,121,227,15,243,58,122,251,203,236,223,102,217,235,105,113,239,209,206,227,198,166,116,250,85,48,71,14,78,216,2,167,129,129,240,167,56,89,118,161,125,49,228,56,221,13,219,207,36,68,253,27,45,219,117,151,229,111,247,206,97,173,132,8,74,182,16,125,54,238,31,46,244,50,250,3,216,182,42,120,67,61,39,106,101,23,248,21,80,151,115,41,105,95,47,32,90,53,3,164,31,12,113,105,26,135,101,186,43,191,173,143,177,4,75,109,96,7,121,5,231,218,250,45,96,254,193,146,225,251,238,21,240,27,207,43,187,7,61,254,195,234,210,152,46,241,186,188,216,234,82,179,109,61,190,139,211,58,36,74,149,107,249,150,196,71,226,167,232,40,42,19,152,17,194,16,94,5,11,57,37,43,99,98,248,81,211,60,69,192,80,94,225,241,197,53,76,100,1,166,253,132,17,3,72,232,72,214,60,18,151,159,15,167,78,27,76,142,22,21,129,121,10,185,35,246,49,165,218,73,182,236,65,1,175,236,230,71,209,189,163,164,179,194,209,86,6,180,219,147,94,15,212,246,83,21,183,250,40,230,78,222,159,74,94,13,20,247,51,90,218,253,125,50,81,72,93,1,200,50,199,223,192,197,223,38,208,98,122,118,7,82,178,154,193,50,199,199,7,184,231,120,39,2,232,41,182,32,75,56,236,176,5,0,113,190,13,109,1,175,212,249,89,21,130,204,162,228,119,244,190,87,252,151,13,40,209,103,93,95,199,103,141,133,122,94,189,161,222,26,229,214,114,137,110,97,84,81,251,213,80,122,215,144,113,154,105,12,130,191,24,0,226,159,46,86,119,142,104,231,72,118,224,91,195,94,179,212,168,32,243,2,25,219,4,197,34,167,252,198,18,155,87,88,62,165,118,253,176,96,152,186,128,214,140,226,59,11,113,104,102,96,136,126,9,13,140,165,46,116,134,52,249,105,131,168,226,83,93,216,194,247,236,251,159,42,118,243,93,85,175,120,106,134,75,146,217,187,183,49,138,190,5,189,3,203,106,166,110,104,108,70,111,165,41,203,34,212,254,32,10,2,238,30,243,126,47,119,175,63,107,73,75,131,105,17,54,253,158,128,179,196,198,64,151,178,55,47,159,191,106,78,234,208,198,108,42,131,2,33,44,121,43,48,137,107,252,205,15,84,242,200,169,148,239,199,117,248,6,151,51,83,45,149,57,75,160,202,27,122,235,14,50,90,135,90,94,140,171,241,123,236,90,200,243,190,6,111,165,246,139,34,141,151,172,38,34,66,201,218,83,110,52,12,146,6,26,248,102,120,174,193,25,147,171,152,87,174,79,55,208,166,73,111,90,214,25,117,239,102,226,213,182,128,93,49,129,174,3,2,180,9,250,166,8,32,141,187,26,55,157,229,144,64,195,91,154,133,56,176,6,198,60,119,115,232,70,213,143,59,250,97,136,50,75,125,198,19,151,141,168,48,163,47,67,211,114,119,103,69,9,119,244,236,196,164,248,228,69,215,205,245,16,57,177,244,43,224,109,172,45,14,5,161,195,63,81,38,117,19,125,248,179,103,199,168,84,151,192,55,216,72,96,43,117,199,103,51,202,42,177,40,169,84,157,153,173,244,141,108,142,38,188,53,35,151,221,147,12,148,111,151,129,212,37,253,142,191,152,21,241,153,150,30,71,95,49,124,83,150,47,109,169,199,96,70,141,167,74,79,11,152,159,93,215,159,185,141,249,140,114,217,75,87,133,177,114,114,27,32,86,10,246,20,157,127,160,164,227,79,194,177,107,49,142,179,84,144,135,178,81,30,7,228,120,116,11,103,210,83,15,94,77,40,116,144,27,125,81,192,231,217,112,4,184,78,6,144,65,184,221,84,114,52,150,241,217,130,114,219,252,15,34,244,209,76,178,193,231,229,38,137,147,0,147,242,150,26,33,32,28,132,60,63,134,221,9,214,135,97,120,217,109,78,130,199,253,153,215,234,19,186,201,199,169,20,132,151,74,179,54,65,25,171,126,126,88,23,247,222,39,52,65,85,45,245,229,214,38,98,14,0,10,216,42,17,230,34,91,84,144,209,31,186,211,140,175,188,80,202,99,174,124,88,40,32,214,235,133,253,145,179,186,102,42,135,61,67,235,163,133,41,35,25,168,87,141,24,186,210,233,150,19,220,120,81,123,169,245,18,197,27,207,176,15,197,115,139,69,152,82,211,148,77,184,232,173,29,253,46,123,173,245,217,54,231,135,218,236,101,196,45,109,136,189,206,68,215,214,77,251,43,39,224,144,62,135,50,114,247,67,110,247,38,143,220,5,1,173,142,88,7,149,152,225,194,10,114,152,121,105,239,242,249,117,29,172,2,39,98,218,33,31,69,93,11,210,222,132,40,251,162,173,144,13,165,165,242,181,202,215,89,196,228,253,39,70,73,153,144,63,184,211,2,204,107,51,166,197,173,14,15,96,66,141,11,12,244,148,50,16,214,9,8,52,6,165,105,91,184,10,10,62,135,250,200,159,69,227,229,86,98,229,73,27,200,217,108,233,211,81,90,93,45,50,50,149,19,35,23,116,202,113,21,211,33,217,140,128,86,228,185,130,140,104,87,180,174,131,213,254,48,90,67,239,159,204,139,229,42,236,142,82,151,187,165,11,12,150,53,56,10,76,97,213,117,217,51,242,133,135,229,78,117,95,26,31,69,32,138,147,70,226,136,42,0,8,199,224,233,35,206,48,207,61,99,52,101,204,118,143,245,236,120,33,226,57,223,53,32,255,6,236,127,223,89,137,99,84,204,80,106,20,237,64,149,193,65,7,41,202,120,56,115,112,137,35,254,243,28,47,4,229,33,115,177,48,219,231,48,63,139,95,214,209,6,170,197,116,222,104,88,254,141,16,48,222,226,9,47,121,65,188,142,38,129,229,60,122,25,131,229,78,249,211,139,93,199,181,248,231,247,38,161,131,223,146,216,88,123,189,77,186,220,2,185,53,173,226,101,153,213,103,171,140,207,44,51,120,168,36,182,213,176,87,166,170,61,250,49,139,249,215,135,168,170,59,95,118,142,249,166,177,121,94,175,159,219,228,219,117,28,222,43,180,225,108,140,7,25,5,94,45,171,5,65,137,255,40,123,190,89,181,94,76,172,91,161,197,240,85,79,172,28,47,57,205,233,102,137,143,28,155,20,20,157,41,148,175,43,167,5,82,171,148,109,247,237,236,176,176,124,1,158,189,93,168,51,115,231,208,228,55,164,123,212,27,25,190,38,1,120,25,153,91,236,95,116,67,210,173,224,156,220,91,207,120,91,114,212,191,71,198,205,146,136,65,91,33,204,192,154,155,243,71,11,55,239,100,89,204,247,199,59,120,22,68,109,137,194,203,81,61,247,11,226,242,210,155,195,209,1,193,108,163,178,20,22,170,30,148,214,80,229,153,91,103,246,237,10,245,110,211,150,205,98,239,92,94,71,206,91,253,204,90,157,216,152,35,148,167,8,201,167,24,239,191,158,102,23,131,159,64,99,81,159,58,193,185,68,1,28,24,38,198,132,80,191,19,122,235,99,129,100,49,253,29,52,194,32,108,106,166,243,179,53,189,96,59,73,241,61,32,223,84,218,118,59,32,64,9,98,239,207,219,101,38,106,54,148,148,25,5,50,107,106,152,242,117,192,102,56,184,19,232,133,157,243,182,52,144,217,94,101,153,221,88,157,52,224,159,93,159,71,2,115,200,230,116,202,177,236,75,20,176,16,39,147,24,150,195,21,251,77,57,185,113,216,168,48,127,164,56,104,92,23,85,141,159,93,53,192,103,163,130,24,85,85,160,61,246,23,185,196,18,158,228,129,148,126,206,52,198,191,182,12,98,112,31,56,160,62,208,196,234,1,56,249,23,61,115,25,164,254,151,45,11,124,107,53,151,131,221,52,249,185,90,5,4,129,177,134,168,239,37,50,111,225,178,53,251,9,5,87,32,111,75,239,38,160,33,50,128,211,5,250,31,61,177,31,115,182,221,118,33,225,75,165,5,43,89,152,62,217,185,246,122,194,98,47,193,42,74,46,144,111,16,231,76,88,151,7,93,68,144,237,82,117,206,167,239,6,137,55,125,14,88,92,201,143,148,62,216,55,224,150,178,38,77,42,167,163,233,124,131,220,55,50,219,117,225,244,220,233,124,27,133,246,213,86,54,152,29,92,98,226,98,54,110,144,186,41,161,225,72,199,30,105,121,160,56,141,23,100,40,88,208,169,32,196,122,95,231,57,244,199,120,13,232,165,250,170,24,34,231,23,205,33,18,214,128,56,165,14,48,104,223,133,183,73,58,100,111,112,115,239,70,81,81,38,94,88,232,164,212,242,0,59,114,36,133,89,252,41,204,37,193,144,244,255,242,124,20,131,112,126,131,187,205,71,229,86,90,197,199,245,45,120,190,56,223,164,63,177,75,188,238,180,176,137,182,95,221,29,158,104,4,224,38,183,94,172,67,44,62,168,237,218,85,159,58,25,168,173,108,204,228,81,18,145,207,176,19,10,212,78,133,108,169,178,117,11,19,155,152,200,117,243,99,143,126,93,75,167,4,103,249,245,27,30,184,78,162,35,174,200,4,59,119,138,195,58,130,59,179,147,48,207,134,201,207,31,90,145,168,212,195,79,220,16,253,80,24,42,159,61,178,241,81,140,246,198,225,166,94,74,63,254,3,218,93,2,74,194,239,192,68,55,75,132,51,79,200,162,72,133,34,87,86,7,157,235,37,94,78,191,150,81,213,162,147,20,232,243,173,36,1,244,91,3,192,10,224,194,229,74,147,19,192,165,168,153,5,127,230,113,185,206,127,146,80,114,246,179,16,31,90,0,242,254,82,189,36,246,211,7,118,168,33,154,220,184,107,101,40,150,196,194,242,253,216,72,132,210,147,230,224,198,34,75,25,74,233,205,159,168,6,197,50,217,127,251,94,27,0,89,55,171,138,10,197,251,46,127,84,139,97,212,131,44,89,5,181,154,11,223,2,106,249,29,222,72,44,89,57,56,8,138,102,140,86,159,219,77,239,32,203,126,142,214,192,72,16,119,161,71,155,250,58,115,189,112,51,213,249,25,85,78,170,171,102,164,103,133,109,37,229,130,167,116,64,21,234,76,246,89,206,141,235,89,223,141,56,47,168,166,97,190,26,197,70,97,133,200,148,53,45,183,39,129,38,122,174,116,58,75,115,221,204,101,52,24,94,177,14,237,2,172,234,210,8,208,25,77,235,113,24,108,216,242,184,180,255,173,101,240,51,246,200,240,13,156,209,93,60,66,170,252,82,230,13,215,146,117,255,210,7,34,122,10,106,156,176,21,68,222,248,33,83,152,206,191,60,18,158,149,114,74,41,60,203,244,210,249,189,212,25,25,75,131,95,76,207,254,188,23,124,249,162,255,170,137,0,81,97,181,221,127,2,120,240,234,80,28,115,105,158,136,89,77,135,103,255,251,8,186,242,63,176,164,122,8,11,128,19,58,243,8,212,252,204,84,170,108,158,179,247,0,254,32,87,139,213,136,45,180,92,145,67,92,246,247,205,97,103,87,101,163,137,0,61,23,230,147,218,153,102,235,104,17,24,246,70,190,79,179,238,178,41,56,128,115,241,148,114,229,173,144,63,54,151,123,191,45,145,222,89,230,29,59,34,163,123,120,56,34,137,149,161,32,221,255,87,39,50,57,112,84,159,209,51,170,143,167,190,117,145,202,12,127,248,132,142,52,118,154,247,22,242,179,161,240,146,155,7,176,79,18,1,228,242,227,81,34,121,92,236,105,176,207,233,51,86,159,119,70,173,14,42,103,31,241,149,157,98,49,61,96,106,94,142,12,146,88,63,16,173,84,14,216,170,188,7,119,188,94,156,24,78,218,117,39,252,216,201,136,241,118,24,231,164,15,9,211,193,68,14,9,140,214,99,95,235,172,219,136,83,12,95,75,88,48,152,236,153,95,137,236,38,125,35,176,220,87,52,101,106,40,172,224,140,105,118,201,227,143,43,59,162,152,247,197,72,70,232,183,21,160,2,64,169,41,69,166,102,52,189,217,130,19,196,230,34,133,35,31,17,193,45,252,112,79,79,223,99,168,154,14,19,74,179,41,246,27,199,128,101,54,80,252,173,165,241,80,26,204,142,255,57,94,25,56,246,22,133,229,144,110,212,118,251,36,49,81,254,183,116,222,99,70,181,22,74,96,199,161,124,176,7,199,9,56,128,64,200,185,222,37,225,144,156,152,22,99,76,208,43,99,207,169,146,220,182,136,30,96,166,118,49,125,40,132,106,49,212,158,91,55,84,208,213,75,63,190,113,71,83,98,109,21,176,11,204,253,157,79,106,111,232,239,253,187,98,141,32,52,39,209,183,100,176,183,32,232,137,209,189,13,67,230,44,99,233,235,31,211,62,149,120,185,114,79,123,8,153,151,112,255,65,154,228,16,226,177,21,18,10,146,172,134,181,123,4,253,122,188,229,98,89,112,147,19,145,108,246,176,210,201,128,231,96,230,39,140,7,175,246,144,253,114,34,223,14,48,134,160,78,112,135,138,197,142,208,213,221,156,197,198,131,42,169,203,191,140,36,205,131,59,11,239,147,205,235,193,132,59,199,198,42,204,244,120,24,172,221,253,85,141,118,110,76,153,91,146,222,142,200,251,52,172,145,250,47,123,86,49,253,220,27,77,170,51,36,179,148,26,32,251,162,197,246,163,248,65,123,233,68,194,166,153,206,118,238,22,134,49,13,218,176,11,183,124,197,148,169,251,224,80,11,209,166,233,229,19,220,114,244,144,246,17,131,119,108,78,6,26,238,121,82,13,57,179,139,149,164,255,235,181,20,240,76,155,71,61,89,192,100,16,244,93,71,199,139,70,203,107,44,233,154,66,40,255,1,15,20,206,89,244,23,68,123,164,177,175,187,170,150,195,150,44,96,99,142,169,220,220,197,235,124,72,198,60,112,180,196,35,190,154,107,29,177,10,243,111,210,61,157,156,223,255,101,5,210,27,224,15,23,138,119,65,201,139,134,84,70,122,22,204,153,5,193,108,54,149,173,173,37,200,81,229,93,72,7,45,14,51,177,85,166,96,189,55,43,70,88,172,251,17,221,163,81,62,196,216,14,31,82,46,38,65,125,42,32,4,9,145,100,31,102,106,231,86,31,167,246,39,11,28,118,34,92,179,80,65,191,115,43,247,211,118,115,124,156,122,145,222,177,73,161,7,117,51,20,29,178,100,26,127,202,208,177,209,121,101,140,194,20,229,139,123,55,186,209,31,33,39,115,64,97,128,152,60,147,70,35,97,4,156,87,181,58,244,132,109,115,229,91,215,10,28,25,21,57,163,234,21,101,81,18,220,78,130,105,85,41,164,78,228,156,201,182,234,93,221,241,194,212,66,84,4,11,81,116,94,234,37,200,8,214,228,253,58,205,250,62,168,189,1,46,223,0,158,154,29,127,247,188,25,193,165,228,117,234,121,149,167,254,11,3,15,12,91,42,46,11,240,230,134,120,108,46,58,63,23,230,140,113,173,206,94,55,63,20,187,32,255,142,32,192,135,161,231,95,115,204,50,125,129,245,15,153,89,124,35,87,200,91,78,68,126,100,158,103,224,232,192,132,174,34,19,19,48,139,182,247,255,70,88,227,139,253,31,10,222,62,188,140,85,169,143,143,14,29,108,159,46,98,211,30,129,63,149,77,230,246,61,181,103,153,124,242,214,63,70,78,193,78,208,159,94,20,59,30,81,88,112,124,123,183,101,239,217,86,232,137,59,250,5,110,107,71,27,31,15,33,62,200,161,218,153,82,134,5,7,141,180,7,152,169,23,182,33,150,252,223,90,209,54,177,15,50,19,8,253,37,226,84,143,33,164,230,38,215,102,42,156,198,36,35,149,175,75,79,102,252,69,215,7,165,103,252,189,221,18,204,32,86,110,22,47,74,38,247,11,126,5,145,242,247,20,9,190,177,121,79,16,110,73,41,45,141,3,247,35,3,252,191,45,7,156,127,115,198,74,194,5,25,124,110,61,109,115,151,84,72,182,140,170,23,217,123,133,98,143,18,53,128,55,78,61,89,152,214,253,63,133,196,183,215,107,107,158,245,129,15,153,169,246,158,65,172,8,47,226,30,126,10,64,163,175,108,218,130,19,89,235,34,206,150,176,199,6,140,234,201,165,130,107,208,64,112,36,44,115,250,199,236,204,60,127,43,124,225,163,49,76,103,210,254,126,180,82,44,230,68,93,12,246,201,186,72,190,172,76,128,42,173,0,221,120,14,150,19,197,121,163,71,111,214,183,143,24,187,70,13,255,228,250,134,173,209,183,166,208,21,225,94,109,145,98,70,255,76,151,190,150,183,152,248,238,224,187,111,4,2,111,236,73,135,133,67,34,193,94,52,159,42,187,59,38,75,152,72,134,112,236,191,233,150,43,156,14,167,70,226,7,114,200,31,140,164,33,84,232,169,15,96,172,175,192,57,229,71,227,101,139,17,90,45,154,32,255,204,159,141,200,159,147,45,152,135,128,51,11,78,181,154,83,92,144,157,134,244,234,140,201,95,218,104,165,146,35,28,223,139,111,128,149,30,162,119,191,217,136,196,219,138,212,22,168,182,19,118,34,168,68,234,104,231,59,166,128,52,254,212,215,218,117,66,31,249,88,61,78,33,130,242,94,66,17,169,102,100,130,251,1,125,169,71,110,165,239,246,162,251,220,185,184,20,76,133,171,122,57,219,218,181,169,220,38,166,27,206,53,166,180,135,172,64,7,187,131,182,110,67,34,191,25,145,197,184,217,30,140,72,15,212,194,123,34,239,194,64,110,117,35,199,82,17,157,252,230,226,228,44,151,158,81,101,191,59,18,175,143,139,235,12,185,50,15,106,29,143,82,247,211,52,208,35,153,64,11,50,37,13,38,232,128,45,104,62,240,201,122,137,83,140,250,178,64,142,202,168,54,119,221,215,71,166,35,108,71,223,239,99,153,12,8,134,64,200,182,235,107,96,111,231,153,200,254,189,247,49,93,127,4,200,77,43,160,120,224,252,243,224,46,190,166,143,82,46,207,86,235,116,203,190,88,18,55,121,70,227,215,107,69,58,245,221,133,33,73,230,34,36,254,49,127,129,180,253,175,209,180,54,94,124,96,104,97,243,225,38,248,166,230,189,233,78,38,61,122,43,51,76,9,219,127,1,239,79,151,48,213,26,208,118,80,108,178,180,167,38,224,5,87,106,12,73,252,109,195,190,244,1,237,106,212,236,116,74,192,255,121,219,152,67,18,77,38,21,51,27,121,200,196,0,84,219,179,46,124,54,85,12,179,49,241,46,197,14,33,28,79,227,246,94,112,66,187,209,230,116,161,40,15,78,57,156,110,138,178,73,41,255,178,62,43,236,180,171,248,21,243,240,13,110,71,67,79,176,57,76,207,194,20,219,223,36,60,83,50,200,87,245,137,235,132,89,144,67,4,174,55,221,14,212,138,175,187,209,186,54,80,178,238,243,36,9,199,108,128,111,120,61,208,105,53,44,233,236,78,63,226,71,197,238,242,101,100,227,70,160,209,41,198,56,65,115,138,237,132,126,95,23,46,122,98,177,164,159,251,98,212,145,111,203,95,36,21,53,163,88,57,51,139,255,60,181,38,187,107,75,128,165,215,232,130,56,103,173,192,192,119,72,104,142,246,79,232,200,17,207,225,61,55,106,74,61,126,180,229,233,187,223,190,82,11,232,15,84,52,13,98,154,199,134,191,227,132,219,235,17,230,249,92,249,34,165,54,132,101,234,209,220,66,6,69,181,50,132,160,155,246,171,5,167,56,49,27,175,90,222,36,13,217,116,128,9,151,3,203,43,43,40,205,132,14,248,28,88,180,107,146,95,19,175,0,109,41,170,148,148,54,179,0,71,101,59,99,221,143,205,42,59,156,112,136,31,59,18,231,136,191,41,46,122,77,101,152,172,123,108,116,111,53,229,4,163,218,156,39,171,198,100,223,236,90,205,126,143,72,67,138,159,241,118,154,239,154,219,34,182,123,33,163,113,46,15,249,238,36,50,215,132,241,226,207,196,181,96,162,212,88,224,190,81,179,12,136,146,122,238,83,129,26,72,105,125,20,146,253,67,112,232,12,188,96,52,161,160,121,241,50,77,49,218,20,78,169,246,196,95,213,12,11,243,170,71,1,244,78,233,115,143,34,201,250,23,100,9,97,17,4,211,193,128,42,106,170,138,9,75,28,208,247,157,32,4,210,106,87,15,97,167,209,22,160,123,52,183,148,194,21,14,53,212,119,43,76,147,154,56,43,175,79,109,103,68,93,115,95,230,242,89,230,162,136,47,37,79,109,220,24,217,83,40,241,45,113,250,138,133,115,120,72,115,222,65,36,226,44,1,172,128,192,152,113,44,162,139,24,194,114,139,90,162,31,228,198,129,96,97,224,87,232,183,43,193,104,251,129,67,148,240,227,100,4,27,202,89,241,226,221,189,142,102,74,1,234,197,88,247,95,217,142,161,58,118,124,174,252,162,242,248,126,19,199,138,191,202,209,59,204,127,100,65,187,50,108,197,107,107,205,55,228,48,246,168,68,28,74,186,102,54,116,29,188,57,221,206,122,202,240,151,15,23,162,146,91,12,88,51,69,3,110,205,52,5,186,49,46,171,126,221,23,30,236,45,162,17,198,211,238,177,147,106,5,203,206,78,143,1,167,153,96,15,225,28,219,223,209,68,221,218,102,32,19,138,90,130,254,63,73,240,165,99,150,83,198,65,210,22,92,216,204,186,182,213,249,35,2,80,190,138,101,47,225,210,232,29,85,90,174,228,82,244,173,189,193,47,20,238,93,189,172,27,25,87,244,243,224,87,201,186,153,42,69,160,195,77,180,136,128,231,197,161,163,94,0,191,87,57,125,254,155,170,223,110,165,95,181,188,82,153,240,68,118,58,137,253,184,248,35,170,207,20,197,246,93,21,36,48,195,147,75,92,94,166,34,77,198,225,189,122,91,111,136,32,138,146,132,33,113,35,32,184,97,10,255,132,98,61,203,100,65,30,160,150,30,85,22,8,32,101,187,142,240,176,3,67,219,207,113,202,242,213,177,61,155,141,225,69,7,10,3,184,65,132,69,241,149,214,97,91,168,150,187,136,18,190,15,66,134,232,239,202,169,247,10,160,246,157,238,77,41,185,221,165,157,108,94,145,231,229,169,101,1,167,15,161,20,158,211,139,204,107,228,206,211,185,65,246,158,167,12,107,190,45,182,28,192,44,106,148,62,159,222,82,10,227,237,251,3,151,152,139,76,162,183,169,202,107,181,200,129,195,124,71,208,135,234,26,203,154,53,208,137,99,150,100,142,114,50,153,183,126,133,1,253,9,202,235,65,46,106,126,8,5,105,93,53,17,35,209,62,117,114,152,57,29,66,71,127,2,130,103,158,7,17,86,195,64,229,219,75,195,212,33,209,50,154,59,27,177,135,24,163,107,219,137,197,220,7,153,96,131,0,65,187,83,25,18,15,100,245,27,6,174,119,25,182,124,115,158,7,84,182,105,34,75,231,222,190,48,233,221,49,119,79,153,174,200,28,223,87,37,72,254,237,189,199,23,239,255,69,27,152,251,104,233,142,231,80,48,149,197,234,170,200,149,73,120,9,20,212,128,69,99,144,23,22,83,89,207,47,19,17,198,156,214,226,55,130,85,146,54,5,58,224,214,6,27,36,31,164,126,182,225,53,4,52,100,11,28,220,125,41,101,102,215,188,97,6,55,113,252,140,78,81,115,58,203,129,115,132,109,206,21,68,78,20,128,95,62,34,72,211,75,41,78,234,223,115,175,57,229,107,227,179,9,162,15,86,211,207,126,44,120,162,65,99,15,187,57,91,18,41,138,119,15,37,90,138,187,40,13,121,164,30,26,160,7,116,143,9,149,10,228,215,85,75,134,113,241,72,248,12,116,160,177,187,166,188,208,252,178,182,169,220,121,139,203,135,116,198,224,193,215,214,189,110,168,68,129,130,192,8,226,15,122,181,16,37,227,17,156,38,246,249,4,89,193,12,237,32,109,66,52,139,50,235,10,231,210,19,204,191,161,192,238,27,142,203,62,146,194,119,135,132,70,245,214,127,209,179,254,19,43,72,110,124,118,71,34,142,134,163,182,130,140,131,160,56,194,13,10,6,8,136,131,171,206,237,108,163,127,8,17,208,116,17,165,125,236,166,45,180,115,123,110,117,255,84,33,201,176,66,60,220,2,92,128,59,50,147,27,232,7,251,48,118,128,215,225,182,113,163,1,165,184,212,132,246,28,57,13,84,140,97,222,230,172,120,254,160,216,70,239,215,0,111,160,68,51,0,31,109,79,49,38,221,94,95,37,226,200,239,75,160,227,1,122,27,49,244,122,133,67,125,60,12,216,60,89,219,92,146,252,169,205,31,71,112,119,174,142,76,205,10,173,28,31,26,119,222,159,151,151,214,150,124,197,51,174,17,3,58,240,120,130,175,51,87,155,106,76,197,143,86,226,95,45,72,196,34,230,99,248,121,236,163,207,67,132,152,165,42,252,107,111,171,10,114,221,71,94,190,87,197,251,236,116,86,60,82,253,64,166,236,178,150,126,252,230,179,186,45,52,123,29,16,175,237,157,13,213,215,69,153,217,233,51,38,227,186,80,200,188,65,110,196,78,3,202,66,175,161,253,111,249,120,23,44,176,170,211,138,243,128,128,115,108,85,27,23,107,91,1,212,31,154,136,228,166,30,96,59,92,34,162,61,242,225,232,47,195,154,45,144,74,125,246,69,128,166,229,187,39,196,152,5,66,133,189,18,245,235,31,214,153,14,205,11,130,1,238,167,83,107,14,41,235,8,139,62,37,74,87,110,189,142,226,150,1,219,52,58,115,150,62,55,66,239,30,11,157,138,57,159,200,148,184,237,250,169,248,88,159,137,188,98,30,50,189,59,15,225,149,129,184,102,146,114,254,181,178,143,54,171,186,63,219,29,83,52,76,222,208,189,242,11,81,188,87,249,54,213,162,246,147,7,72,54,22,48,119,146,108,131,16,194,137,175,45,132,109,33,243,243,40,190,135,54,116,177,29,228,193,151,91,207,114,183,37,198,58,44,53,196,42,118,27,144,95,155,137,80,255,233,76,228,204,81,135,24,99,82,230,130,134,134,90,185,64,21,78,113,200,124,44,66,8,202,250,219,158,245,90,117,100,130,99,79,193,113,76,66,140,147,91,76,194,35,42,183,235,58,162,251,48,190,103,86,96,173,72,202,179,222,118,203,182,225,42,46,211,245,250,204,238,192,46,2,210,178,141,212,84,160,233,228,60,100,58,151,244,252,138,108,189,119,187,104,222,9,36,11,182,33,204,41,164,233,176,152,233,86,233,50,206,99,64,128,110,66,233,201,123,179,225,189,88,55,210,152,178,238,149,204,213,200,212,190,228,170,205,255,165,46,209,51,91,74,229,36,181,120,52,6,82,169,229,225,218,231,110,222,218,6,179,193,106,30,34,243,244,157,149,112,198,254,119,89,250,217,97,62,28,209,188,203,80,211,129,242,222,66,129,254,133,112,29,113,174,62,6,239,237,224,23,116,214,189,215,75,239,171,17,204,68,178,19,31,37,201,108,153,71,126,166,217,28,201,87,186,193,62,200,110,44,41,74,172,66,60,174,120,134,18,85,137,113,240,138,170,198,225,97,115,26,202,243,51,96,31,18,185,179,52,52,98,63,170,11,216,247,18,9,35,203,107,220,12,6,21,178,236,232,102,112,57,211,73,9,28,24,100,146,157,25,199,182,169,71,71,6,60,175,82,210,8,190,110,18,136,70,15,43,13,60,52,12,43,123,111,248,2,36,45,160,215,73,52,54,36,80,105,210,238,113,115,116,84,251,91,72,109,192,195,188,108,51,89,2,189,86,142,28,210,69,246,138,253,85,224,49,223,6,47,125,40,72,173,56,214,70,132,134,51,244,168,101,112,151,126,77,102,143,239,4,13,116,106,10,103,119,126,65,6,31,18,107,68,76,241,127,130,133,186,61,250,68,253,189,150,134,117,83,51,83,25,187,118,78,134,35,123,184,148,245,53,68,14,88,131,0,68,159,141,48,76,196,130,198,34,56,19,203,64,75,87,26,133,28,73,19,242,167,183,2,251,172,114,9,7,155,151,79,86,68,141,54,101,212,74,210,65,219,237,175,83,252,71,245,207,108,46,196,105,180,46,85,217,5,128,221,226,157,62,176,224,25,140,26,228,142,51,187,96,116,42,92,18,197,211,133,4,0,207,161,141,187,60,8,215,220,174,187,41,153,27,83,242,133,205,30,135,7,207,178,168,111,3,85,173,149,137,68,187,204,184,237,209,59,41,154,36,35,7,212,199,183,241,25,178,86,195,41,137,201,81,164,246,218,251,180,218,161,189,193,147,17,147,15,78,69,23,170,86,93,28,58,170,81,208,143,20,240,63,182,158,203,197,94,135,254,11,135,124,183,89,193,71,88,184,98,208,164,134,197,140,75,234,159,83,20,177,109,123,195,118,229,245,116,207,220,6,11,187,253,37,198,220,195,29,176,38,46,67,200,232,90,245,23,105,165,133,57,29,208,185,232,69,180,3,5,19,111,91,226,98,197,90,102,20,243,203,137,88,156,217,18,24,141,253,17,194,150,75,120,212,232,5,187,191,80,176,71,27,94,71,149,230,108,103,17,129,248,166,186,196,171,152,249,136,146,130,38,204,223,106,175,46,105,241,113,125,212,159,243,233,110,229,177,187,141,186,157,99,212,232,218,25,58,4,212,122,110,11,236,187,184,12,168,127,135,212,37,81,184,79,102,171,143,151,189,158,113,56,80,94,110,58,223,118,37,73,53,158,134,151,251,250,216,143,88,233,8,206,211,238,115,195,53,186,238,140,128,150,50,225,14,236,49,195,224,75,85,229,24,20,244,72,136,144,15,96,152,6,156,158,133,144,200,229,50,186,234,205,77,101,31,5,147,136,55,31,158,100,141,179,213,225,15,161,176,225,156,40,169,60,57,227,45,170,44,97,107,83,178,31,102,192,84,212,43,159,32,188,252,47,248,53,6,68,8,126,187,27,46,133,214,4,199,153,29,177,123,35,170,100,66,253,178,46,37,206,97,62,17,208,98,178,195,223,64,76,251,94,132,241,102,36,130,182,53,98,94,253,122,211,197,204,144,195,101,203,40,158,215,192,102,44,87,233,61,81,147,158,79,117,222,27,26,219,168,15,59,142,65,113,172,49,253,190,191,188,12,59,244,226,238,7,59,116,34,120,56,20,118,83,59,78,142,79,43,150,41,207,228,35,234,182,14,86,50,120,254,31,74,82,5,29,39,173,104,87,10,249,237,158,29,211,250,239,50,64,90,200,107,209,100,26,135,182,38,139,177,27,64,6,87,21,235,204,230,235,222,248,48,156,212,204,138,22,36,123,3,40,93,25,200,55,162,51,116,3,140,58,246,81,78,59,89,103,138,23,220,89,171,48,48,203,181,80,163,171,109,173,17,34,188,238,42,205,32,106,18,122,80,8,247,127,26,32,148,141,138,226,57,27,129,234,74,40,235,202,6,106,127,1,11,117,117,236,240,123,227,139,185,241,205,42,57,186,237,83,21,90,3,25,88,42,109,224,140,238,11,177,108,46,111,28,229,139,95,217,72,101,173,235,131,28,2,85,51,19,52,105,218,235,176,84,57,140,165,80,238,93,92,6,47,138,188,132,100,36,219,223,236,201,112,201,190,0,20,146,68,95,16,147,1,52,108,54,185,188,154,104,247,173,127,160,214,230,207,56,112,98,105,62,42,66,97,101,47,220,193,114,23,202,61,21,118,64,16,191,112,119,123,20,117,173,202,70,39,239,112,202,66,142,163,211,106,89,2,97,150,55,78,226,111,190,170,144,53,195,72,96,89,229,178,153,130,164,161,86,154,154,21,95,120,12,31,122,50,142,245,189,124,17,218,35,201,75,20,203,234,97,11,70,151,3,185,169,71,243,91,56,248,117,103,8,162,90,14,193,33,124,194,169,48,150,40,80,127,37,151,74,195,221,99,145,74,172,228,150,120,147,204,160,67,110,187,30,236,197,101,7,127,128,115,7,243,235,20,66,101,40,114,136,254,206,220,67,96,231,89,65,202,234,82,8,131,187,238,220,213,142,223,77,25,167,69,68,87,110,101,200,142,51,26,234,143,164,214,134,215,222,141,23,42,75,147,88,211,199,154,201,24,72,202,13,136,234,25,52,120,254,136,185,193,163,187,133,84,93,81,133,177,73,126,136,46,251,136,144,180,33,34,18,230,128,47,79,79,106,150,8,58,160,248,106,132,183,215,17,146,173,177,243,32,65,1,175,14,45,235,55,127,69,29,175,177,184,199,168,231,173,143,212,218,44,28,243,157,87,243,247,193,142,155,49,191,221,140,235,246,53,125,204,139,60,232,18,220,63,106,61,252,172,154,140,47,208,189,55,163,20,44,108,250,50,252,255,204,45,52,2,76,66,64,241,107,21,163,134,187,242,247,136,203,1,7,118,226,244,67,198,15,238,194,74,9,230,186,185,49,162,49,71,168,31,130,160,103,223,244,225,108,133,142,123,181,164,114,112,172,100,229,165,150,250,57,212,15,63,204,70,163,4,98,111,152,45,37,45,245,228,45,244,111,124,250,163,197,120,243,232,117,56,154,191,145,196,141,125,8,55,90,132,216,85,224,174,60,253,201,63,198,114,202,235,236,103,174,176,192,65,93,161,74,226,65,222,241,126,119,113,174,16,71,68,19,253,160,250,79,117,231,129,159,61,132,104,164,251,78,110,48,246,12,36,172,100,111,152,87,36,40,95,115,60,227,74,123,204,149,244,119,65,162,114,102,121,19,155,249,117,248,51,151,33,42,115,199,237,144,43,180,51,121,129,23,83,127,226,56,9,32,222,44,201,44,21,7,249,122,183,224,239,85,204,10,181,91,19,103,103,133,205,12,229,38,97,31,108,141,82,255,186,32,185,59,95,66,45,15,41,179,36,56,178,53,39,230,128,252,12,104,165,98,132,4,223,238,44,36,222,188,218,52,250,146,212,148,237,85,68,175,72,79,155,38,36,230,62,122,67,208,138,241,5,49,158,119,106,100,178,247,61,154,161,134,111,198,28,192,44,150,189,7,205,154,142,45,190,172,69,107,176,36,105,64,30,153,120,233,138,210,10,19,201,37,119,182,152,85,43,37,56,68,199,14,82,214,220,245,249,231,141,77,20,190,252,61,102,166,209,230,24,109,225,229,78,195,145,93,109,32,127,163,49,126,248,87,165,80,47,35,155,3,51,50,146,244,105,171,122,226,62,82,242,157,209,37,222,157,224,156,21,73,10,238,198,123,110,60,209,122,158,82,5,221,166,227,119,183,251,80,175,245,112,156,150,175,183,247,162,53,159,213,33,71,40,168,227,104,244,244,210,154,12,114,234,6,153,36,147,203,170,108,85,64,250,110,225,137,2,143,243,163,40,173,220,191,63,210,108,131,154,142,83,175,46,56,41,236,83,221,81,161,144,135,172,99,88,139,115,229,148,143,162,9,203,12,44,238,102,165,234,230,179,179,242,16,227,158,20,196,203,126,102,121,194,246,105,131,73,192,81,122,192,229,32,52,68,139,60,16,102,94,4,190,236,77,238,222,73,240,221,6,252,179,240,56,85,108,237,167,95,168,223,161,49,28,186,57,93,43,203,125,223,42,221,67,47,174,96,56,99,204,115,41,252,252,106,153,180,228,242,100,155,42,105,108,181,215,47,150,176,81,36,192,211,244,135,162,127,189,201,80,62,117,91,125,58,245,215,9,16,165,134,52,42,43,225,155,28,21,189,76,85,226,216,155,133,105,120,60,145,152,6,52,150,149,2,255,255,126,255,45,36,58,37,21,112,25,5,210,187,69,74,195,46,226,170,12,90,154,7,142,228,89,148,22,211,1,150,132,252,99,19,215,135,242,15,150,0,17,251,192,38,133,71,164,62,161,144,240,178,62,63,254,50,137,26,207,233,156,52,145,94,86,239,132,26,146,181,46,165,248,100,14,76,252,16,214,130,195,166,67,120,113,30,255,126,197,11,57,108,130,66,163,177,70,30,223,117,244,53,44,13,86,39,70,58,213,212,230,152,164,76,152,10,227,3,6,230,216,73,88,108,91,245,126,137,58,224,132,168,129,199,254,247,134,142,56,81,168,160,119,44,222,123,230,189,204,92,245,18,227,172,58,240,174,149,68,71,210,183,169,241,146,73,86,210,216,156,250,239,161,219,212,210,69,48,33,137,81,185,192,218,197,2,122,26,76,13,121,61,31,44,239,37,158,126,254,241,131,26,167,224,67,133,125,52,204,195,141,119,131,208,214,151,86,54,137,139,144,178,173,220,170,156,70,125,66,38,125,127,135,146,246,160,95,230,1,248,184,55,65,56,225,139,169,106,17,246,153,98,119,248,67,85,148,28,157,200,233,186,149,138,180,147,37,42,212,190,28,189,109,117,242,168,56,133,17,29,241,89,218,5,242,81,50,61,166,175,124,106,47,237,20,201,235,69,95,202,35,243,79,223,34,85,47,100,252,168,29,171,20,189,109,65,14,156,71,195,246,94,104,211,21,29,195,84,33,131,207,221,120,139,57,78,126,88,195,191,172,133,96,242,110,140,236,227,76,154,55,32,134,193,20,204,21,192,232,157,224,147,175,193,96,9,127,18,107,239,96,240,98,139,149,104,92,151,196,170,198,104,185,117,179,26,20,72,48,36,47,32,86,42,189,173,80,71,219,151,79,181,88,45,26,191,38,133,45,54,131,31,109,115,161,163,34,38,89,40,49,173,198,48,17,40,39,121,77,90,70,42,251,130,168,125,184,76,60,95,94,136,227,248,145,210,226,191,137,247,72,210,17,141,52,5,102,220,23,111,146,114,218,208,22,105,9,130,97,83,57,25,228,137,6,99,12,24,29,89,25,101,217,133,196,253,246,158,114,75,8,90,142,28,147,19,22,164,240,205,1,21,145,19,225,61,98,21,22,215,32,158,9,44,97,148,104,201,219,76,43,45,162,73,151,252,188,155,192,134,113,103,109,255,54,42,206,24,76,87,154,98,187,78,193,50,86,191,222,86,162,165,38,191,118,117,72,31,6,174,147,231,105,158,70,133,79,138,223,55,73,210,90,194,194,112,167,14,253,133,160,197,234,193,24,75,239,106,47,115,70,102,75,122,123,87,158,185,162,180,84,210,222,141,172,125,211,117,181,155,250,182,51,247,178,100,123,8,8,173,224,246,222,40,35,31,171,203,195,36,34,6,53,171,105,219,106,216,77,18,130,182,37,225,3,235,196,203,114,168,7,2,10,14,230,118,6,134,118,20,184,145,213,218,127,110,182,193,145,91,202,110,11,96,118,1,8,96,103,167,236,180,15,141,151,253,100,7,112,25,70,89,121,233,178,158,234,47,68,162,185,146,146,7,74,2,17,238,108,171,91,64,92,173,85,82,121,240,175,136,132,26,123,225,64,169,132,53,192,187,113,8,165,133,192,249,61,166,108,170,2,175,11,243,183,162,93,109,51,151,40,206,39,150,0,84,130,215,29,211,96,200,244,193,206,63,137,9,225,205,195,93,147,70,125,177,146,164,76,247,0,61,118,12,73,75,151,145,218,82,180,207,112,233,175,169,104,180,29,149,4,129,248,70,10,159,34,67,208,4,235,146,205,128,223,104,17,16,189,72,150,29,148,21,85,152,237,97,200,84,57,234,9,165,16,73,40,118,10,18,222,171,43,231,169,211,149,179,250,145,227,129,66,53,2,35,228,99,7,1,101,161,122,247,98,103,47,32,194,21,66,228,215,171,211,95,93,47,71,164,197,154,72,46,73,190,186,131,152,104,252,1,237,94,154,240,6,67,188,57,183,3,28,30,181,14,142,247,193,242,88,231,188,86,198,130,125,97,9,115,137,196,6,38,94,170,51,157,253,197,152,195,181,150,253,125,49,6,217,29,102,120,252,248,217,191,232,176,151,7,118,12,126,164,219,67,123,72,16,146,223,203,183,0,196,87,186,185,173,67,246,204,171,20,21,86,98,182,253,7,186,6,120,189,118,3,229,237,60,53,90,120,139,87,229,79,153,85,139,16,81,100,189,150,202,125,164,42,132,10,163,190,85,177,69,169,181,85,186,64,77,182,99,209,185,183,19,5,1,24,167,247,211,71,7,154,124,136,40,199,61,196,217,202,170,170,93,64,20,178,234,247,41,59,124,192,158,211,128,28,144,37,95,61,108,113,150,27,161,102,97,250,86,162,10,193,27,201,55,193,56,84,164,176,59,172,180,2,117,209,83,226,255,156,104,115,80,9,171,177,196,38,252,19,138,252,29,242,231,74,93,205,161,41,158,79,204,211,0,30,248,42,125,237,167,151,3,163,35,219,102,225,38,80,160,246,91,202,15,81,5,104,108,210,239,193,131,146,27,150,17,171,71,221,84,112,204,146,94,186,237,255,206,118,141,107,20,169,226,15,43,75,224,52,120,186,0,134,235,166,30,237,98,31,139,146,29,104,64,56,3,249,66,92,147,217,211,9,31,96,178,69,148,227,230,101,236,243,45,246,172,39,229,59,69,106,63,147,212,148,179,217,10,220,19,61,36,147,54,173,248,250,238,79,181,163,211,105,11,79,136,249,56,91,202,219,147,180,212,42,140,52,110,222,216,92,215,61,213,55,188,33,239,190,201,255,96,1,215,85,244,86,49,152,17,180,172,68,196,115,71,107,182,243,219,136,48,23,116,210,242,8,233,123,235,101,169,61,55,63,1,51,205,161,189,96,59,52,218,197,250,26,88,73,52,217,104,199,216,234,189,209,12,232,29,210,128,20,244,127,219,15,204,123,222,84,167,249,54,43,174,28,118,186,210,116,176,58,78,38,166,130,144,219,92,43,91,180,1,195,20,39,139,0,25,240,204,75,61,178,95,199,10,3,136,139,50,249,155,86,95,70,214,41,166,76,132,6,166,146,35,118,145,100,203,149,154,211,215,94,104,5,44,83,183,45,251,89,212,57,197,144,82,87,170,120,45,105,80,129,100,131,159,10,127,221,163,246,63,192,154,53,205,6,127,117,223,24,147,216,93,28,239,163,214,221,158,12,149,255,83,88,41,136,165,138,1,254,6,44,25,143,22,104,150,94,24,196,25,238,193,216,170,71,103,76,33,52,211,45,205,235,134,41,248,86,65,9,32,255,32,95,30,250,243,251,43,119,170,184,85,107,38,21,98,231,54,218,226,16,72,174,6,221,38,211,120,221,119,117,120,67,209,251,33,84,155,163,163,47,53,96,15,51,76,204,87,153,85,170,54,66,113,12,174,34,104,136,90,62,76,103,210,150,82,37,200,148,44,89,113,229,33,173,240,114,61,21,131,193,157,216,181,193,207,219,29,42,99,21,186,158,11,145,155,4,216,22,244,162,245,120,63,128,57,117,241,213,60,251,251,149,87,153,99,63,22,75,81,103,103,239,199,225,110,110,88,38,125,240,116,161,226,53,38,183,2,223,68,221,87,205,73,201,187,129,82,39,35,166,109,116,96,250,15,15,242,104,227,86,21,140,48,172,188,54,214,185,33,4,199,217,220,218,185,44,244,170,133,64,135,231,135,80,159,130,65,112,36,250,209,241,226,74,174,130,199,202,217,218,87,161,162,130,254,242,150,34,63,117,178,224,76,211,80,201,111,72,69,137,93,62,24,23,249,115,80,83,95,17,166,84,223,132,120,6,53,34,199,208,205,80,109,133,213,92,49,18,214,230,123,245,73,80,228,94,106,241,165,216,84,255,96,177,178,90,92,5,219,185,153,238,208,136,79,150,15,232,139,179,52,146,235,158,62,239,136,154,45,92,190,176,19,91,40,214,152,149,209,222,247,97,175,74,250,98,231,204,211,233,2,168,136,18,202,254,144,196,95,80,187,220,123,31,164,176,207,23,248,81,3,174,138,206,65,83,36,29,70,32,71,21,227,157,254,228,2,4,215,71,27,252,9,219,49,49,23,248,163,43,170,192,126,75,198,97,91,38,182,93,204,141,250,187,145,128,158,103,88,73,178,191,233,253,231,3,169,38,117,163,181,44,217,91,138,15,239,82,140,19,78,13,168,212,227,46,202,225,130,28,150,211,105,239,25,243,208,76,174,52,37,170,87,125,141,221,90,95,41,51,53,205,112,75,54,129,102,51,87,222,28,117,188,154,174,103,66,55,95,247,97,127,31,107,22,117,195,115,97,108,19,52,70,179,212,190,15,8,213,49,139,119,170,201,169,8,199,203,166,183,90,134,185,169,133,135,9,251,66,104,187,220,182,164,82,21,125,132,197,116,14,169,241,211,104,107,169,17,246,140,46,235,236,23,84,93,180,72,214,10,39,185,197,170,73,30,43,35,75,114,202,126,143,2,127,114,206,107,25,116,183,11,43,3,146,183,121,214,79,26,240,70,203,45,88,74,11,137,245,21,38,44,66,143,61,168,69,76,204,92,186,121,203,15,46,213,237,131,23,220,68,52,188,111,185,48,81,35,208,159,218,44,76,71,236,152,61,103,92,247,136,123,88,196,109,213,91,97,190,88,164,237,171,59,217,231,230,51,149,191,114,162,41,91,249,249,25,109,183,231,25,48,30,35,44,156,199,26,146,144,26,85,40,82,54,83,253,102,88,29,52,114,160,176,0,95,4,217,205,123,143,97,62,149,15,178,195,166,156,183,183,170,183,54,232,197,211,241,7,215,241,86,159,151,161,98,116,91,139,14,111,22,41,155,5,43,72,245,246,20,196,27,62,112,149,21,253,42,111,173,148,25,42,199,41,53,84,169,17,246,92,25,211,161,41,159,252,62,243,4,19,121,43,66,199,74,28,208,193,205,33,126,84,173,30,16,26,179,244,95,188,90,6,16,178,251,191,203,121,130,161,12,52,170,24,14,141,2,163,190,6,52,205,187,57,245,252,9,53,65,132,246,126,90,3,26,54,238,222,74,237,35,163,214,83,43,254,139,112,244,74,15,241,20,255,217,117,129,81,233,181,187,160,29,30,245,145,199,163,29,171,87,228,222,50,229,60,139,23,152,179,33,23,124,180,100,223,209,21,191,93,240,166,209,66,67,28,158,237,190,62,80,188,131,151,72,22,159,212,121,139,49,254,184,106,134,122,77,103,165,81,70,69,174,0,7,179,26,152,234,23,37,155,212,120,59,223,226,216,189,170,9,42,206,10,123,140,130,214,229,149,218,74,215,152,151,235,170,53,33,209,190,193,105,61,182,108,226,176,32,213,78,117,106,23,56,121,61,82,213,107,121,107,114,185,20,99,151,57,44,105,153,238,174,24,192,241,254,251,80,193,143,221,0,58,227,109,190,129,185,22,131,37,221,129,34,101,144,152,33,250,198,183,73,236,69,174,215,68,64,181,94,33,132,40,149,248,252,133,191,99,245,130,21,43,49,211,224,204,33,169,240,230,120,107,228,46,140,168,241,32,17,95,48,147,101,16,176,251,83,160,253,105,171,56,79,198,139,36,48,144,120,99,236,171,235,56,117,196,171,178,244,170,61,79,183,32,202,66,50,130,211,99,78,199,73,255,242,30,138,199,156,129,107,187,182,255,144,201,230,138,199,111,154,10,126,232,144,99,117,187,160,97,221,177,191,5,239,139,181,240,32,249,247,61,216,207,154,217,224,246,49,118,3,194,107,197,233,3,242,99,182,58,45,151,176,238,101,118,57,44,123,195,112,61,129,140,199,98,25,86,104,2,141,220,161,128,109,32,8,89,147,249,11,246,14,255,195,81,233,46,89,37,122,225,211,69,132,120,138,169,254,0,72,208,116,247,244,60,55,28,135,15,11,28,174,65,40,253,148,181,6,57,220,134,224,205,255,225,22,228,49,200,228,182,179,141,237,217,9,47,114,203,57,24,173,236,15,100,174,120,178,73,84,236,141,45,188,142,252,66,85,56,248,161,247,21,240,209,145,198,24,158,227,106,158,18,248,204,21,1,99,35,91,187,157,228,98,106,35,231,158,103,53,119,135,62,168,207,48,5,118,236,117,255,204,65,60,49,102,180,55,82,149,17,205,214,182,198,223,77,55,234,99,156,29,161,90,22,138,7,126,240,213,226,110,63,214,97,71,161,203,216,10,31,25,62,71,223,163,238,97,14,115,144,121,112,103,4,186,16,66,51,105,110,65,111,32,206,82,213,231,74,107,199,255,85,48,249,19,123,45,142,3,104,77,86,181,99,8,158,50,3,108,43,23,113,246,189,180,107,134,24,9,137,36,178,9,176,197,63,33,63,164,220,217,243,175,16,197,210,28,16,109,192,143,193,240,252,44,124,8,108,179,168,171,135,107,32,216,49,136,123,109,133,33,176,167,185,189,30,120,210,5,211,14,127,118,199,147,121,246,58,33,239,172,251,87,223,152,144,13,169,216,65,87,59,132,210,118,116,30,68,72,68,155,103,230,81,33,26,21,82,14,73,251,183,147,86,222,194,97,44,169,244,82,155,95,253,205,116,91,165,44,64,31,163,242,253,93,23,26,209,14,33,97,62,148,115,63,247,111,137,13,9,163,215,243,223,218,10,114,82,195,219,233,24,117,167,173,231,13,156,77,46,231,130,200,122,169,91,49,229,215,250,140,73,229,240,44,212,41,117,112,31,126,218,196,58,241,101,147,26,195,148,98,153,198,104,87,90,149,128,60,239,177,50,49,11,242,239,230,196,182,89,101,80,215,168,143,70,48,53,53,215,22,99,194,129,245,128,163,40,102,25,14,99,189,152,35,135,13,16,105,137,188,32,226,246,176,38,30,36,65,146,145,240,83,103,2,107,133,21,172,41,239,28,250,134,170,228,80,43,122,211,87,111,228,168,29,171,79,69,62,152,18,69,203,96,169,144,83,50,37,65,208,1,113,46,2,67,73,221,2,181,73,185,209,20,163,237,141,222,221,69,220,155,12,177,239,150,84,234,58,111,225,3,31,187,110,139,78,139,234,186,202,73,72,34,125,59,43,206,220,68,6,49,123,14,147,144,206,60,95,31,173,236,244,239,64,11,119,89,226,7,117,175,218,115,104,165,195,209,202,140,132,15,6,115,213,209,69,238,7,89,37,249,156,158,67,124,208,100,194,232,148,52,214,125,166,99,224,152,46,109,187,234,230,51,60,189,191,120,28,13,67,152,105,230,40,147,153,215,16,149,231,51,170,159,88,97,228,216,161,34,87,65,129,153,213,186,140,150,104,113,164,25,120,246,58,78,221,124,33,179,135,7,220,233,68,9,15,123,101,187,131,139,95,177,234,29,215,24,57,107,53,194,252,161,247,70,224,245,22,104,10,41,39,213,190,186,249,159,32,28,196,55,153,225,205,18,72,227,70,120,101,199,237,132,225,10,124,88,154,151,215,153,67,177,100,244,99,169,37,127,97,122,188,216,217,79,187,227,87,69,243,42,139,151,228,79,141,154,88,240,7,29,255,165,129,150,70,173,212,207,194,245,243,54,210,111,168,77,71,140,61,28,64,106,8,196,60,68,154,18,110,22,252,63,172,163,34,138,138,105,145,101,244,110,11,75,95,244,220,224,140,191,243,85,79,137,128,246,173,146,28,1,68,146,131,190,104,107,105,10,183,141,149,204,59,176,190,91,3,180,254,33,47,24,58,4,53,177,211,193,103,6,161,57,156,191,177,108,76,83,185,133,20,167,103,26,75,148,54,239,124,182,71,95,160,157,60,112,22,149,136,53,82,150,241,250,192,35,199,124,207,79,66,84,131,7,63,140,114,16,166,158,30,0,73,131,202,144,116,46,50,92,60,23,147,147,14,236,195,64,128,205,63,248,146,1,49,182,30,96,166,149,196,243,131,88,93,119,167,118,22,137,56,179,169,223,194,48,235,4,196,19,7,210,55,75,235,92,247,15,83,174,53,132,172,34,214,91,205,147,70,34,195,103,132,175,68,245,7,227,205,122,160,7,72,137,123,51,243,8,7,82,113,179,53,171,249,151,156,75,82,204,101,194,53,247,2,201,39,125,151,8,4,189,190,40,95,41,72,181,116,99,58,100,136,118,164,13,191,107,164,69,39,229,204,2,248,254,87,112,64,247,106,105,66,193,73,104,67,75,181,248,105,39,227,153,139,164,41,215,76,244,118,95,99,56,13,94,20,67,33,205,238,108,249,81,105,60,177,18,155,229,73,173,205,78,164,144,180,161,191,210,203,150,190,16,55,228,110,203,212,118,15,103,25,67,152,199,2,36,17,117,201,129,88,197,112,153,188,44,58,196,160,131,198,150,19,223,209,224,90,127,231,71,1,40,82,195,12,242,223,233,211,68,210,32,176,1,106,119,179,211,33,221,107,210,194,227,213,88,3,122,19,130,145,199,16,66,179,41,215,40,18,133,40,191,25,49,31,101,27,16,11,60,119,20,186,217,168,204,250,28,173,159,38,166,106,2,35,49,133,30,16,174,41,134,5,154,247,72,247,171,23,225,89,228,141,14,221,122,56,188,54,252,90,121,252,169,8,168,27,59,138,8,245,70,122,230,65,165,140,117,136,206,11,169,209,146,240,8,234,87,27,21,119,136,227,84,138,65,172,42,227,109,202,167,67,219,148,125,32,179,242,176,224,42,235,163,145,195,63,145,122,135,21,164,85,133,249,38,87,145,90,3,151,203,189,99,172,189,248,86,207,193,226,138,44,42,179,190,99,83,127,92,185,32,159,58,246,239,241,246,235,227,205,219,169,42,77,149,0,212,210,172,47,174,68,122,133,7,78,152,86,30,65,58,84,65,40,113,125,213,150,112,146,1,46,218,175,242,206,243,3,22,233,246,135,129,96,57,130,15,151,104,91,220,169,42,107,34,44,14,229,23,97,55,219,134,96,213,252,133,227,120,195,1,46,17,86,212,120,130,91,248,166,233,51,66,254,106,183,117,42,44,36,169,196,204,173,91,96,109,228,171,28,189,45,250,183,121,167,12,164,164,245,225,177,164,170,138,139,161,93,90,83,85,26,198,104,106,203,108,131,144,196,153,22,188,229,99,101,228,68,84,115,35,112,19,129,18,184,189,228,220,191,206,106,106,126,188,176,42,150,208,166,249,215,76,49,78,167,49,137,16,206,210,203,31,206,130,158,233,143,12,168,123,152,246,181,110,5,9,143,33,8,20,72,188,117,52,80,18,200,90,101,236,228,207,56,241,5,217,53,40,86,180,67,214,216,113,227,232,42,4,123,161,29,225,131,69,60,164,193,158,200,54,177,14,32,137,153,25,110,144,200,246,156,194,61,16,88,79,24,113,181,5,133,88,82,165,176,38,251,156,45,231,111,141,37,120,107,195,254,51,23,243,143,18,30,92,222,216,31,27,168,49,204,158,75,50,29,108,173,189,227,162,147,5,233,159,187,189,71,11,14,221,15,68,223,60,234,186,227,182,193,229,131,242,98,115,34,126,30,59,20,56,101,249,9,38,148,110,79,181,179,181,29,240,61,110,204,161,242,160,184,30,38,49,180,136,78,22,156,1,249,192,217,132,67,3,250,243,132,141,231,10,84,231,97,122,73,28,88,116,105,213,193,202,47,183,216,19,80,71,55,14,123,32,194,193,121,208,234,113,73,234,146,93,189,196,164,129,140,201,122,187,60,67,10,121,125,17,246,192,134,16,58,220,3,66,88,63,127,197,206,164,85,151,11,143,43,109,35,215,25,113,90,99,90,205,22,209,122,41,112,244,206,253,59,161,241,168,251,89,190,186,151,193,3,142,219,1,102,68,147,87,145,74,157,223,203,18,248,51,21,219,92,9,251,196,149,82,153,103,27,151,252,54,21,4,47,205,56,172,183,3,29,202,225,83,16,70,15,21,227,219,225,178,248,157,53,135,57,185,163,37,123,167,126,80,187,41,181,17,191,207,228,71,37,158,205,118,62,248,250,194,59,71,214,167,103,233,25,73,205,178,231,128,78,53,113,28,73,140,86,87,88,87,238,196,137,77,234,138,39,195,39,117,89,71,3,123,115,108,182,175,148,180,142,193,159,155,141,71,168,172,98,136,187,112,36,25,146,98,217,160,17,34,77,55,98,189,208,173,74,117,181,200,124,182,123,12,56,62,149,214,75,112,112,107,126,242,224,85,234,235,172,131,250,233,229,99,14,92,194,36,21,156,167,172,215,243,141,214,57,79,177,104,94,207,160,8,3,102,237,50,84,126,223,147,92,211,221,196,52,130,24,176,159,132,65,156,131,71,126,4,33,143,91,104,28,50,153,209,95,181,28,75,113,70,67,27,109,192,39,174,135,252,172,218,211,94,160,62,199,154,79,251,16,22,195,15,22,140,253,36,242,85,72,147,22,121,33,25,195,83,123,67,179,160,66,85,146,45,114,228,93,116,57,55,217,212,216,31,50,167,229,242,19,107,240,57,124,255,142,191,249,148,74,39,163,43,156,151,201,207,220,46,185,27,203,141,137,15,92,5,101,198,159,181,2,84,128,42,9,10,185,221,175,55,128,247,131,98,98,146,152,8,240,110,121,15,67,233,2,21,145,83,105,182,127,239,100,153,185,165,225,124,59,119,26,175,192,81,4,98,42,93,184,200,34,68,13,134,123,5,43,164,167,218,32,67,79,70,4,196,254,131,50,201,157,133,80,79,208,242,155,224,237,252,110,27,249,238,45,235,77,229,182,93,205,123,32,5,3,78,154,69,213,117,216,130,198,46,105,47,78,76,255,250,230,254,99,106,218,110,21,186,185,71,173,236,91,67,119,59,38,141,202,223,39,183,153,239,2,113,168,121,123,54,217,55,237,94,11,1,190,38,16,170,216,147,239,88,254,229,245,220,108,102,247,55,229,237,173,167,179,231,185,82,226,109,53,81,87,15,55,217,69,204,109,3,164,126,143,193,42,141,227,90,36,226,83,128,215,12,177,216,190,140,85,129,225,224,25,74,141,225,41,192,131,60,180,130,169,191,124,58,1,135,224,63,27,9,138,244,124,167,199,35,2,120,62,25,218,238,78,254,29,125,60,19,72,168,31,194,52,28,70,137,193,242,203,2,91,43,138,248,5,135,204,165,116,67,10,198,121,98,100,238,143,43,94,209,39,162,232,129,176,41,254,158,40,195,167,51,206,48,151,123,55,64,65,233,220,176,238,73,3,129,139,129,242,194,88,95,199,147,187,75,237,229,171,30,89,115,154,239,165,169,235,59,98,63,177,91,115,84,142,203,97,103,79,66,2,91,157,207,14,45,246,75,211,46,69,228,42,158,158,132,228,178,36,163,98,194,69,11,37,186,217,155,206,244,54,125,9,122,128,237,37,159,232,91,68,159,92,116,153,244,199,136,214,88,171,186,117,98,60,171,163,232,45,147,151,123,170,237,130,250,83,244,253,125,237,248,178,237,111,15,63,154,122,147,51,15,60,204,111,139,245,231,228,185,51,36,176,237,79,48,4,150,130,163,59,120,29,126,54,40,104,116,142,238,121,237,189,107,191,35,8,119,113,131,109,108,173,24,9,142,108,8,49,51,202,146,192,173,17,1,241,218,187,124,164,246,139,220,70,143,192,138,152,227,175,189,77,209,86,106,63,119,2,159,194,2,163,89,30,119,83,127,152,98,60,123,145,96,155,67,36,124,94,20,93,243,98,219,253,143,238,124,45,39,226,10,242,116,227,184,129,242,21,192,51,94,97,231,64,148,237,211,59,177,198,10,216,238,62,4,109,230,168,9,132,240,215,0,86,29,251,174,78,233,243,27,50,92,197,253,214,2,123,146,246,222,140,146,148,108,237,15,4,222,247,156,154,132,10,40,151,8,10,70,114,132,181,145,136,176,233,7,169,57,111,204,90,220,67,215,132,40,150,216,152,69,54,80,43,171,67,46,100,140,33,185,115,58,154,35,242,247,6,43,31,174,39,80,101,216,73,40,132,227,201,14,85,37,194,50,3,146,118,78,76,36,211,88,24,220,98,14,33,120,148,222,160,20,160,118,195,167,167,92,128,37,5,53,38,72,206,146,123,57,213,135,200,109,71,35,239,160,169,225,222,136,217,153,92,67,165,51,105,189,47,203,155,237,217,9,216,232,29,225,177,49,205,230,232,177,124,66,19,114,207,198,114,64,45,161,124,66,110,85,157,81,102,32,22,83,53,111,196,27,133,196,169,162,223,120,126,235,105,163,132,221,206,150,110,214,226,227,26,172,30,160,193,251,235,130,209,125,165,77,58,39,115,187,196,165,24,148,33,237,15,73,76,51,191,88,212,165,137,89,220,47,35,108,174,114,48,214,113,39,163,180,185,63,88,233,112,0,120,241,137,168,24,63,138,54,82,207,177,179,66,101,46,177,222,3,52,49,103,68,5,246,78,182,234,55,35,29,9,19,192,144,78,132,224,162,148,96,89,62,61,109,6,178,98,241,196,88,167,22,196,56,11,139,35,94,112,213,134,206,158,24,179,145,144,24,250,44,149,253,67,210,8,0,244,166,243,0,180,234,155,46,191,122,41,93,142,70,154,56,201,66,159,207,162,193,63,26,46,204,221,206,29,100,232,161,225,87,106,130,47,154,66,253,50,33,4,103,71,134,239,65,137,220,222,90,200,221,145,253,16,73,125,66,213,113,239,82,209,96,85,98,196,87,143,30,250,24,217,92,120,23,123,71,64,51,243,204,192,239,147,75,30,170,32,161,187,95,176,78,235,9,173,103,112,9,93,39,55,89,66,223,135,55,158,58,28,249,4,53,46,175,138,48,65,135,70,136,1,162,20,77,236,103,41,150,88,60,162,162,221,75,62,108,114,118,100,40,120,101,241,122,160,0,109,225,54,161,239,188,6,149,136,139,198,177,179,32,43,126,52,149,57,217,226,136,215,201,55,32,213,229,87,28,109,36,223,42,151,98,71,107,140,255,230,206,183,84,127,109,108,57,226,37,11,140,188,250,216,82,32,241,186,122,68,173,128,81,29,57,2,23,81,10,233,198,238,113,91,11,7,17,184,180,159,230,116,147,143,120,21,24,1,220,118,49,16,80,204,12,78,41,111,117,193,98,56,148,193,219,160,156,230,56,126,1,172,183,95,204,229,202,75,218,108,245,33,254,8,58,127,98,209,197,176,100,60,110,139,133,80,43,42,133,200,12,216,121,186,89,171,171,252,220,132,121,46,180,75,79,8,157,91,112,112,34,247,193,147,132,119,236,30,223,101,129,132,197,45,134,84,202,92,249,70,208,211,158,206,209,216,202,106,106,96,1,80,249,182,103,247,124,85,169,42,212,67,245,112,214,156,147,143,216,186,202,197,119,5,230,23,226,199,79,150,253,252,85,1,193,145,96,212,15,165,73,246,244,50,249,165,95,254,252,112,62,100,237,167,234,181,238,164,135,224,175,19,225,82,153,135,122,209,81,59,123,165,21,127,99,54,56,18,153,226,205,161,95,202,7,79,126,124,92,208,244,46,5,176,227,206,200,16,140,97,250,131,187,54,34,117,52,52,206,150,201,200,182,45,201,225,80,46,100,113,199,193,12,116,224,253,59,85,244,248,161,239,199,164,208,63,114,103,163,167,185,246,203,19,33,102,53,236,108,3,205,170,155,230,73,204,142,178,233,7,187,171,191,137,254,60,149,218,98,40,42,87,10,3,146,207,162,67,113,25,173,141,27,217,143,225,97,164,2,208,116,57,181,180,112,233,183,114,62,110,197,29,79,155,213,7,115,94,60,229,43,83,79,119,171,196,20,78,239,233,51,87,6,32,5,59,166,121,176,193,0,2,145,150,183,130,7,36,179,159,57,212,66,179,111,151,174,27,202,58,35,12,121,174,29,17,69,244,46,87,1,173,238,194,40,107,180,147,157,209,184,241,104,251,123,242,164,42,31,93,118,82,79,189,47,105,102,158,30,210,164,16,47,140,226,212,235,70,176,78,30,247,193,162,137,19,102,181,9,248,156,29,149,41,73,2,34,88,183,198,106,254,34,124,19,150,32,99,71,253,14,190,121,107,200,168,38,114,205,153,112,139,204,16,149,101,168,127,70,40,156,157,78,179,113,220,4,46,194,124,96,187,139,83,36,28,169,50,209,88,176,134,217,219,55,18,186,165,170,11,175,60,216,24,132,95,218,101,75,194,66,64,184,1,56,29,86,92,86,243,122,204,124,185,21,219,37,111,68,82,178,41,69,127,186,121,223,219,84,41,169,105,54,165,5,128,102,12,67,130,217,46,97,233,254,216,57,121,145,39,46,34,136,82,175,114,153,215,16,119,138,116,45,137,136,230,59,132,221,97,0,150,250,153,211,18,141,254,212,157,9,45,217,191,16,24,133,130,194,151,189,230,92,187,55,12,247,187,8,115,13,29,222,207,59,92,230,24,146,39,165,2,54,188,107,162,190,178,185,22,188,187,172,42,164,239,225,92,55,26,237,230,59,0,75,13,33,47,250,12,161,72,4,185,159,244,163,208,129,102,176,239,178,99,211,97,92,241,234,19,85,70,42,189,55,130,151,119,38,50,126,239,231,40,153,124,51,220,63,234,208,163,211,170,63,37,231,40,152,183,204,90,227,246,208,8,196,85,209,243,92,102,174,199,27,110,145,27,1,158,35,176,107,152,163,227,75,21,184,120,238,57,155,201,3,194,165,57,117,211,136,236,17,128,98,177,93,111,46,94,137,155,5,70,101,212,42,190,79,218,62,143,123,151,171,59,185,175,9,185,245,254,235,130,177,69,252,61,157,29,229,105,128,229,192,180,37,158,214,254,13,129,64,53,209,247,56,140,241,97,250,119,174,250,204,68,97,184,208,29,20,117,25,12,105,234,224,76,223,115,197,177,7,235,247,19,42,20,85,78,15,81,181,192,153,4,160,176,82,106,67,212,194,132,240,190,45,126,79,192,122,42,28,239,165,14,139,14,152,62,129,78,48,66,45,207,97,240,165,178,129,234,169,234,59,12,218,46,249,54,76,20,225,254,11,128,237,242,61,101,16,36,207,202,13,244,205,77,104,204,51,50,1,5,95,211,151,110,251,255,185,191,151,167,102,140,98,163,129,27,38,60,101,197,176,252,212,232,136,208,157,118,51,83,111,209,188,223,78,130,47,24,91,236,170,159,121,55,3,202,0,155,212,180,173,74,37,161,201,91,108,166,174,27,239,60,20,65,158,225,185,85,89,127,76,244,27,86,150,160,201,13,106,79,143,68,200,236,55,107,243,76,149,215,188,118,183,198,159,26,140,136,153,211,173,159,16,57,139,31,93,149,70,6,141,53,112,164,6,184,239,106,159,222,67,158,26,121,136,223,39,46,140,67,170,202,95,88,179,214,186,212,140,8,12,94,34,77,226,17,17,162,210,225,20,151,177,74,9,100,126,170,73,142,33,144,154,131,151,205,235,28,118,190,6,137,98,50,237,7,94,230,246,133,250,179,160,199,89,103,9,203,111,37,216,185,171,40,117,6,107,87,133,165,172,22,140,220,186,41,97,187,57,196,102,220,15,169,194,254,170,33,237,69,78,127,4,30,119,51,251,153,50,179,106,153,232,131,96,100,243,32,78,78,223,191,150,158,39,30,201,43,12,220,233,103,223,247,156,210,213,52,75,203,102,114,46,35,81,55,175,89,207,53,66,198,247,164,132,51,64,124,120,125,108,35,3,184,185,202,162,122,93,58,198,11,176,146,221,62,6,92,250,135,230,38,135,125,76,89,22,140,243,110,14,212,252,94,85,234,86,142,168,158,28,94,124,183,180,213,174,80,170,142,88,83,48,201,169,249,109,156,83,4,161,186,46,235,85,83,86,244,7,52,58,188,19,124,117,35,105,13,185,191,47,252,142,77,194,147,27,235,193,126,138,65,32,134,118,24,227,33,219,142,48,59,235,147,8,183,94,74,184,233,4,78,44,55,20,167,190,216,145,187,105,253,135,93,68,15,204,76,81,176,255,140,229,106,248,29,154,109,79,247,240,181,62,181,2,28,187,26,136,254,180,92,158,140,81,194,11,245,237,48,28,57,112,87,48,233,185,13,251,113,29,199,152,222,226,254,232,119,199,120,251,113,224,226,89,162,215,74,115,227,118,145,197,176,156,161,226,233,79,170,203,163,113,106,144,108,25,85,163,91,129,143,75,216,56,51,156,13,106,116,79,121,79,152,139,128,156,169,174,94,228,172,49,115,235,134,42,145,67,107,214,122,8,49,156,210,218,178,151,67,247,169,0,56,164,44,222,132,125,193,90,153,10,15,29,69,159,229,98,193,181,138,65,215,14,65,89,116,209,247,174,22,72,27,141,214,94,36,169,203,34,123,25,192,248,196,238,148,225,225,253,59,44,43,96,2,26,21,96,123,202,184,253,55,162,172,81,29,95,172,11,133,235,129,224,183,94,71,85,29,23,65,246,242,222,224,109,136,62,63,145,107,248,167,160,195,242,204,135,237,253,107,53,91,77,34,207,186,102,102,84,28,14,44,194,39,232,156,245,132,232,76,102,63,206,240,49,132,118,211,1,70,75,30,42,3,149,207,174,223,160,227,64,221,207,62,64,74,186,97,163,201,85,231,33,84,76,132,47,66,189,73,137,21,77,184,234,168,231,171,247,76,32,229,1,138,186,116,5,60,65,8,57,133,57,165,125,190,51,105,242,89,1,141,234,53,168,34,89,88,55,63,52,10,226,116,30,115,175,214,74,234,133,248,48,242,17,47,155,75,131,130,124,207,192,199,156,142,142,119,122,3,15,49,119,155,82,80,171,180,19,29,133,31,247,222,9,245,206,244,22,69,12,85,112,250,23,97,212,191,32,152,5,115,206,31,197,19,250,138,219,130,3,84,216,78,11,80,213,13,161,199,128,136,64,7,53,223,221,247,108,10,139,128,47,36,225,149,145,94,106,22,86,14,62,13,43,181,226,188,243,228,218,231,144,137,51,46,13,237,21,72,193,233,132,28,220,20,8,4,122,72,237,253,246,222,239,176,0,105,79,66,248,100,211,232,18,217,109,127,11,57,83,34,123,20,60,137,153,193,152,195,96,127,130,205,193,250,201,146,44,174,91,40,108,105,104,231,248,136,114,61,136,124,241,31,128,186,165,230,218,248,76,54,35,51,13,80,241,46,59,34,214,111,253,168,149,252,124,4,81,171,131,110,58,165,172,223,166,5,45,240,154,11,195,26,117,137,238,192,41,98,219,74,113,235,25,234,46,9,144,57,228,196,138,122,230,73,229,42,31,24,18,166,217,131,24,95,177,251,18,240,249,10,235,122,112,16,73,162,6,70,8,231,108,54,87,216,194,174,60,128,244,234,190,212,213,146,128,244,187,133,74,29,128,195,60,234,120,57,168,116,97,234,156,164,173,42,225,70,177,38,184,43,121,148,186,19,207,224,19,253,214,102,184,227,77,205,223,63,242,184,142,75,134,48,96,96,243,151,83,50,87,123,186,147,177,176,62,113,237,99,50,108,201,126,185,218,219,219,241,171,55,44,28,194,49,254,72,63,140,63,178,112,216,15,3,183,189,172,230,154,116,254,246,200,73,82,76,41,15,168,132,147,25,115,46,90,151,15,180,193,60,237,178,105,74,47,191,86,59,221,105,248,98,26,140,49,149,76,146,83,229,173,71,134,78,113,171,186,136,69,240,102,228,167,251,86,198,107,167,79,180,215,210,44,58,98,143,79,188,44,133,107,54,248,165,231,104,149,127,120,62,61,159,252,239,41,101,177,140,108,77,90,49,230,151,125,115,153,80,213,191,17,98,59,202,149,108,239,233,23,177,26,245,216,97,198,111,31,75,248,67,177,55,207,157,212,233,20,69,111,167,232,80,21,144,9,32,199,43,200,181,141,195,9,143,237,154,121,175,158,247,124,39,117,184,48,30,51,103,4,19,16,28,84,98,72,251,204,19,32,194,90,236,170,52,202,181,96,92,120,59,184,47,169,66,177,66,217,150,2,50,182,17,7,131,32,76,227,116,70,174,42,90,163,89,35,33,148,41,240,228,253,31,107,201,210,198,152,13,86,70,112,248,225,121,155,252,134,99,239,2,8,98,108,44,76,227,160,213,104,141,16,130,205,118,253,123,220,48,200,187,80,35,114,62,45,188,107,29,79,220,169,244,147,158,70,102,122,231,232,149,243,55,230,115,28,185,83,39,179,237,221,41,170,240,44,143,39,216,163,87,213,39,157,118,225,99,80,190,57,171,200,20,2,7,166,112,211,127,0,69,167,84,159,62,190,37,46,1,194,192,152,94,188,50,203,38,220,128,2,108,156,32,255,174,254,89,135,44,97,26,237,37,203,70,32,238,3,218,163,213,145,32,244,50,67,233,217,30,131,135,205,0,46,29,143,192,99,180,144,34,96,7,74,212,164,44,215,190,88,252,138,84,97,50,251,203,44,252,175,247,178,155,79,180,28,8,80,184,205,211,9,119,150,32,91,150,4,102,212,89,217,117,71,241,163,146,90,113,142,34,228,139,182,236,101,97,47,152,88,91,161,47,37,246,4,92,89,174,210,15,82,44,118,249,82,198,192,155,172,220,91,168,190,233,35,204,84,24,113,139,102,112,42,108,124,19,27,148,60,159,78,38,239,90,234,5,193,172,28,58,20,182,11,43,162,123,82,184,178,167,19,172,101,106,3,69,146,204,136,46,70,35,133,166,103,74,245,222,246,76,109,232,173,160,36,50,39,140,112,227,59,10,18,127,30,232,161,113,146,233,102,248,171,205,245,154,98,101,53,109,65,36,82,31,241,200,111,216,27,255,10,48,237,213,82,221,17,250,248,215,19,150,56,175,233,19,230,30,233,199,3,100,121,176,189,175,63,20,231,105,113,121,51,88,188,231,109,177,58,34,9,199,121,226,157,183,76,219,41,224,204,61,144,124,88,115,7,214,74,179,178,42,119,144,76,98,58,171,185,134,98,123,177,87,100,213,183,165,147,22,29,151,19,74,146,102,107,158,201,189,0,79,185,36,105,84,104,73,152,103,132,228,196,39,102,113,158,255,56,212,198,37,172,139,31,238,98,184,182,42,69,108,194,245,23,205,45,21,76,115,162,181,174,59,213,233,59,240,184,32,212,226,199,126,11,205,232,217,187,51,197,98,94,117,94,105,152,41,48,22,181,8,146,134,207,30,237,255,240,248,183,191,187,67,210,16,185,191,54,193,2,218,22,99,176,191,233,78,247,165,4,231,131,62,37,109,244,76,194,155,129,212,66,0,101,223,162,211,13,80,169,217,16,68,4,155,216,61,35,76,162,144,217,34,209,73,249,250,253,186,140,124,41,237,124,22,168,97,40,95,47,38,188,204,216,150,184,229,185,174,113,3,154,126,238,50,165,170,12,27,209,53,157,76,118,81,252,10,140,31,103,160,43,171,6,65,205,225,154,85,121,76,216,228,29,241,184,200,160,225,86,4,199,137,80,222,199,30,9,163,177,222,131,91,24,3,147,148,250,20,157,246,166,73,41,246,240,159,85,53,172,227,255,239,211,188,78,85,210,198,63,175,149,47,251,126,139,167,245,143,5,212,41,111,52,133,173,37,114,122,63,214,212,6,98,213,169,140,241,226,233,95,47,169,91,89,117,116,228,30,78,123,163,137,11,19,142,70,121,166,215,141,20,57,100,202,75,131,150,222,136,204,79,199,205,220,46,9,129,92,116,55,148,224,138,82,32,255,250,251,59,239,99,130,13,77,106,233,191,37,70,164,141,160,195,95,192,54,39,178,189,46,17,135,160,255,198,62,249,69,57,5,74,22,165,134,209,143,179,8,28,219,212,141,148,242,233,231,171,234,72,186,111,252,84,120,130,253,206,225,145,123,88,19,194,150,24,168,247,191,92,162,203,56,94,55,72,199,142,76,50,37,253,13,142,159,201,100,153,149,243,217,240,192,204,254,66,239,13,23,161,166,210,210,120,35,7,141,179,109,83,57,146,163,16,195,195,129,214,39,34,155,158,29,244,128,143,18,233,121,150,87,80,227,145,22,207,133,15,10,172,79,48,176,209,68,66,116,22,167,251,162,90,108,98,148,98,84,46,164,185,106,48,68,247,163,112,24,15,78,105,58,173,251,63,10,252,91,83,158,57,178,63,21,40,113,231,82,251,191,134,27,71,131,203,150,222,121,48,211,181,0,62,91,119,123,77,252,183,63,204,142,239,211,87,244,129,213,2,81,221,210,104,182,252,35,116,91,198,172,132,76,148,89,3,74,8,96,232,19,70,18,232,128,18,145,133,229,23,13,93,175,174,68,105,55,192,81,168,1,142,132,193,37,99,188,243,51,14,26,6,195,29,149,159,115,77,169,235,22,66,101,37,224,43,146,152,141,191,222,67,12,74,51,124,129,141,11,37,97,10,50,79,112,123,54,180,89,156,10,237,145,90,99,35,116,84,163,249,196,70,103,144,16,14,13,233,42,5,213,163,203,205,92,6,212,210,195,46,141,24,15,1,215,71,30,31,0,4,24,15,93,217,35,228,173,104,78,117,69,140,243,168,119,62,223,200,171,123,57,184,88,64,53,21,153,201,0,115,146,22,119,84,228,16,189,124,213,148,92,15,178,58,83,69,87,213,137,150,254,92,197,211,157,193,255,150,115,3,222,48,64,41,28,208,245,211,29,135,30,54,205,250,93,94,57,155,196,37,151,90,109,165,11,249,203,106,37,64,103,100,206,108,40,181,36,238,104,208,241,13,26,75,32,133,101,47,132,226,199,174,3,139,186,102,206,19,21,6,166,44,184,63,7,255,61,155,90,233,60,161,86,176,23,97,194,237,176,234,251,116,25,226,11,145,130,13,179,158,222,252,26,235,132,202,117,229,195,232,158,52,183,96,47,219,235,210,51,146,103,15,241,22,194,84,73,169,183,142,81,87,203,6,251,105,254,2,56,164,156,137,219,71,205,59,144,217,70,38,73,57,73,70,131,114,20,249,181,50,184,200,127,251,28,30,92,166,20,252,156,141,128,223,214,176,136,154,210,238,245,131,123,1,114,106,160,197,74,57,4,101,162,185,66,93,219,192,225,68,181,231,74,140,180,121,162,114,142,129,187,73,66,192,218,128,28,39,134,251,0,243,48,55,112,205,204,80,144,149,109,100,247,179,224,228,198,89,225,7,131,170,203,32,130,21,23,249,122,134,208,160,239,23,10,91,107,175,27,56,59,104,18,71,209,245,4,165,227,203,178,69,1,114,130,119,193,171,64,18,182,174,155,16,84,193,55,150,153,90,251,6,94,161,253,223,200,143,16,162,175,93,211,88,243,61,118,144,204,158,163,68,183,243,85,64,42,52,155,32,39,213,93,165,239,188,8,152,93,228,136,71,213,103,158,57,252,54,203,34,230,180,127,56,46,22,5,220,190,103,131,16,64,135,114,68,112,125,205,54,108,113,157,5,31,108,20,138,80,149,170,6,114,65,223,21,159,246,115,158,118,220,203,106,20,66,204,213,59,225,109,136,122,206,137,104,126,66,24,195,83,223,112,36,241,154,219,254,255,248,77,142,202,95,86,171,11,42,188,7,245,217,138,49,224,34,61,121,28,57,25,3,70,9,40,108,107,108,211,160,206,154,77,59,153,161,172,200,23,84,154,131,94,122,115,145,19,13,234,127,86,154,80,149,41,50,98,186,251,36,10,53,159,223,103,104,248,67,154,136,228,46,83,243,36,33,221,157,116,83,109,54,89,171,46,252,120,86,50,220,23,252,185,68,192,125,37,223,233,232,110,16,135,71,175,199,37,75,162,17,48,41,32,39,131,59,145,161,20,26,149,216,99,1,188,240,87,189,8,24,224,227,175,207,156,151,37,76,105,62,202,86,172,9,208,0,186,72,213,78,103,254,132,192,92,113,242,42,224,245,111,181,206,107,130,182,212,63,185,27,28,41,112,220,209,148,172,7,140,225,168,124,67,203,73,76,139,41,226,87,30,125,197,216,76,36,160,168,194,202,181,254,134,0,148,187,242,94,239,72,9,21,148,168,92,66,161,144,73,37,106,39,176,127,116,44,183,89,77,47,138,171,10,169,117,147,107,92,29,184,69,82,220,13,130,34,214,197,214,6,152,46,180,228,77,211,162,47,149,169,145,56,196,174,84,97,93,246,216,30,34,211,137,93,8,161,64,73,106,220,60,107,201,86,86,124,51,9,66,244,168,8,22,125,147,200,68,23,23,247,75,139,87,52,54,5,53,175,14,218,127,126,196,104,220,88,75,122,52,99,226,111,88,137,95,199,196,6,2,87,182,200,67,133,205,210,73,174,53,64,12,134,84,182,73,199,7,65,88,7,24,83,187,31,81,35,236,229,37,177,78,42,143,233,94,241,133,195,255,185,7,218,41,43,231,129,3,23,175,147,37,26,188,70,161,146,126,24,12,38,104,96,209,143,227,254,9,198,24,192,4,227,59,174,32,240,251,5,34,127,186,184,83,193,62,41,187,33,39,239,28,16,118,164,36,171,230,136,212,122,52,86,39,165,85,61,117,145,179,83,209,229,95,227,85,170,136,187,59,115,217,179,60,48,21,67,116,58,14,145,89,89,35,229,5,152,217,138,26,10,189,186,35,83,210,174,165,179,87,168,247,177,43,213,204,247,37,109,164,15,182,108,253,170,140,83,214,151,0,211,81,132,64,43,30,248,18,149,11,44,248,98,107,216,117,38,96,167,82,124,152,140,191,51,40,145,207,31,45,189,144,120,151,236,172,94,196,233,80,172,227,217,187,197,174,24,108,153,189,212,51,44,156,203,149,74,222,95,240,202,168,235,255,91,215,29,201,254,8,156,120,134,162,218,172,153,51,254,189,4,238,93,65,227,158,247,6,74,254,126,91,58,204,84,167,188,223,91,180,79,147,62,150,135,231,158,186,185,126,91,13,115,56,108,78,17,205,175,102,47,20,157,73,175,89,225,242,141,119,215,191,236,127,186,252,109,87,164,233,22,213,98,137,134,97,78,12,13,150,30,160,164,149,154,108,167,156,104,67,228,187,152,143,135,114,154,47,7,21,89,131,179,34,253,135,40,109,220,0,127,213,82,85,64,161,1,113,242,240,66,56,78,225,32,59,26,177,12,19,79,6,212,120,217,177,7,187,76,85,122,133,9,219,81,118,109,201,21,119,47,122,30,190,208,241,78,63,16,91,45,44,253,13,228,18,228,187,96,222,132,166,77,100,226,124,234,61,59,174,40,117,26,163,5,65,107,1,95,18,170,126,100,95,216,113,98,15,186,246,133,3,205,221,228,159,206,212,201,240,175,113,198,72,187,233,28,104,253,239,168,246,139,120,149,143,34,146,39,220,145,216,114,243,109,219,151,117,75,33,162,197,181,62,19,128,118,215,96,101,54,68,109,7,171,133,54,145,1,15,56,224,58,123,172,196,221,3,133,158,85,120,21,246,153,166,1,17,66,48,223,247,230,95,15,223,253,250,109,197,6,190,76,117,7,245,185,143,129,188,191,215,198,20,90,194,172,250,78,233,102,182,120,92,116,208,65,80,84,235,77,57,207,221,127,16,225,96,218,22,104,216,138,195,220,101,236,3,109,87,42,198,95,96,164,202,48,107,45,17,107,246,2,243,229,149,152,83,101,228,91,80,183,254,119,138,201,64,197,135,212,15,171,151,44,69,249,208,188,57,253,250,157,63,153,226,131,155,3,224,56,103,144,28,200,229,192,71,131,21,129,219,235,31,205,144,191,146,253,77,67,78,216,241,242,228,244,174,123,254,65,212,26,35,218,100,1,28,145,247,37,254,116,206,212,40,200,241,209,30,238,181,165,198,211,144,87,158,142,226,70,232,172,134,42,41,121,222,108,17,68,45,47,16,56,26,77,188,99,188,115,118,252,245,11,51,25,44,27,128,31,32,221,54,158,109,102,53,155,4,245,73,26,234,174,198,111,64,52,171,213,56,173,114,145,152,204,191,140,179,22,93,211,35,243,221,136,103,201,155,0,41,110,183,62,30,176,252,190,108,47,23,203,166,160,173,17,124,11,189,244,44,4,13,133,74,224,19,240,200,254,27,57,180,193,89,67,10,147,117,127,169,109,96,98,8,10,21,26,37,181,81,247,202,60,172,58,139,237,116,143,140,46,52,176,49,71,231,243,80,161,14,219,152,25,62,178,232,150,162,47,124,122,155,221,61,212,160,224,158,136,39,24,24,159,93,108,6,145,49,245,189,95,22,153,45,100,83,225,12,97,201,53,242,6,2,23,210,62,108,106,189,178,189,42,64,247,93,171,233,157,196,159,103,239,240,111,60,164,43,151,83,198,183,204,37,185,207,113,120,130,103,10,4,90,144,149,54,51,128,82,233,108,119,172,85,82,79,203,25,184,22,113,202,100,46,34,121,95,234,102,43,243,242,211,223,171,133,152,188,18,134,67,47,2,94,11,17,249,254,0,115,150,132,37,136,76,84,42,91,153,219,138,4,233,91,164,1,243,162,12,134,75,244,55,138,40,252,182,74,245,239,39,45,157,106,56,118,130,15,190,210,138,155,237,239,57,182,77,69,190,113,237,27,178,173,214,149,95,133,12,106,208,89,63,129,174,51,58,43,142,103,103,138,109,123,39,101,45,171,1,233,54,34,208,63,121,151,241,39,0,207,133,172,100,150,134,5,196,133,184,171,253,201,139,186,75,242,123,53,174,38,249,95,72,254,64,108,209,147,37,177,166,69,3,178,95,255,47,41,195,232,6,73,119,89,203,225,150,80,125,183,56,28,82,112,89,167,237,204,73,139,208,233,7,168,90,35,244,133,50,216,254,240,80,227,187,102,135,27,213,192,201,21,175,236,199,100,103,36,247,192,4,133,40,125,16,111,25,177,101,37,180,170,49,230,106,169,123,73,58,231,60,106,230,145,116,211,215,134,199,90,18,243,210,29,225,79,224,248,108,204,147,215,73,244,75,154,145,95,137,151,193,154,146,43,242,175,5,62,42,113,9,57,70,59,133,75,165,250,154,186,143,167,22,47,252,137,102,87,181,104,147,207,195,205,88,18,48,209,126,182,35,179,10,30,175,25,163,6,202,85,185,99,52,208,20,19,242,169,14,253,227,198,85,129,68,11,99,112,59,79,142,105,188,254,123,148,88,153,70,89,84,106,236,34,181,241,51,194,138,62,14,134,245,151,117,235,135,10,139,140,204,146,196,96,242,114,217,131,102,142,129,65,132,108,64,29,42,233,238,33,19,249,17,222,195,125,158,124,202,110,18,183,150,111,199,70,127,8,180,135,203,33,143,230,228,90,44,43,118,241,57,168,162,89,150,106,102,32,60,250,93,143,196,239,12,214,171,73,180,196,199,210,115,112,192,13,9,123,222,213,148,91,19,101,236,101,30,146,43,164,10,156,101,112,151,65,89,151,245,154,56,37,194,99,153,35,80,3,93,62,246,6,68,42,34,155,207,230,215,121,37,213,153,36,165,136,123,181,144,31,215,138,161,118,151,196,108,131,138,93,13,158,182,138,197,184,0,44,139,70,0,204,15,179,245,235,111,229,61,119,1,248,135,70,169,50,116,69,16,223,77,223,248,176,81,63,205,104,150,100,178,216,215,7,243,251,58,16,117,59,213,117,122,156,183,0,72,126,132,100,86,92,240,106,174,220,88,51,75,166,111,176,139,229,215,30,173,166,246,249,201,187,24,250,69,150,214,224,9,17,218,53,173,213,254,11,60,19,32,202,124,40,131,51,99,223,226,217,190,252,29,14,39,73,199,37,180,254,114,46,169,46,109,205,172,86,62,198,113,209,186,149,211,122,42,239,238,71,133,33,39,217,86,131,68,199,243,26,0,143,97,215,140,217,34,11,55,192,118,66,69,203,200,128,171,40,250,94,127,204,76,168,232,153,226,37,150,4,8,22,177,75,64,204,39,19,45,127,173,174,14,222,159,184,66,88,61,250,133,231,114,166,164,33,157,77,203,31,222,189,111,131,178,107,117,10,165,203,18,211,117,188,134,254,238,158,123,143,231,245,189,89,21,88,66,169,241,24,26,210,108,105,249,56,37,196,36,26,110,237,31,34,198,114,72,218,133,14,40,38,0,26,218,130,56,146,228,86,253,43,36,112,162,58,232,178,162,105,114,186,74,187,229,215,195,101,241,14,24,95,246,248,101,255,68,164,79,41,18,245,65,11,228,167,132,169,52,170,196,91,52,224,204,230,105,193,231,254,49,143,85,42,221,140,233,18,131,116,86,127,103,136,113,15,23,95,39,90,226,59,168,56,73,43,227,171,60,251,5,66,24,207,129,225,168,127,243,190,108,173,215,76,110,107,75,120,242,147,252,217,57,234,116,1,133,221,90,162,174,126,61,236,200,53,105,71,155,217,56,85,6,214,13,60,119,234,225,200,186,152,215,237,225,105,85,252,240,252,38,75,220,200,6,243,144,34,127,161,14,197,107,63,75,235,195,72,44,27,244,129,243,201,59,241,45,173,62,200,145,232,76,142,208,183,15,77,119,157,26,157,170,159,104,206,13,248,132,68,229,234,196,252,168,229,154,203,44,177,54,200,235,132,93,52,10,196,60,152,226,220,27,98,85,215,82,144,161,12,76,202,47,71,231,225,223,105,35,201,195,174,188,10,168,199,141,255,108,74,166,226,33,4,203,54,202,178,27,127,250,86,181,225,246,70,219,65,173,49,214,202,71,22,67,184,54,90,182,251,202,40,14,235,63,201,190,75,65,15,33,62,81,56,157,55,187,67,3,223,5,188,105,211,72,202,95,229,207,20,1,219,121,116,56,5,116,227,97,48,200,192,252,86,238,56,125,89,89,89,100,76,5,180,81,31,33,111,202,211,182,51,25,81,28,239,153,125,85,67,149,136,118,157,65,84,65,43,74,86,81,238,45,7,227,222,145,234,95,152,157,225,22,53,47,59,189,252,16,40,26,171,155,247,98,73,206,206,218,9,241,152,213,3,15,107,123,100,86,78,2,200,194,8,78,101,235,150,113,69,232,13,102,131,200,41,240,126,186,238,184,20,62,218,235,221,116,53,44,20,219,104,254,112,139,81,119,100,253,105,53,62,247,159,166,75,128,64,51,7,193,108,154,115,34,146,127,75,102,17,112,81,35,33,255,104,228,11,97,24,252,219,214,122,235,2,28,34,128,252,220,126,248,87,48,200,149,102,191,135,59,48,111,142,210,22,87,41,25,209,90,114,67,98,234,128,53,45,198,155,116,161,66,14,216,226,63,200,18,7,20,213,60,221,77,128,48,20,142,208,197,61,210,161,90,77,80,146,220,80,168,29,93,171,234,195,182,134,136,225,120,206,94,147,141,52,199,5,155,74,143,12,252,50,79,254,135,78,145,222,143,150,128,28,137,206,79,88,83,195,0,213,182,223,225,201,191,235,235,39,175,202,211,139,11,109,8,255,251,237,232,33,37,250,169,184,42,115,205,55,220,211,160,190,225,201,208,87,227,181,15,92,123,111,172,104,71,23,236,206,214,177,119,77,128,149,238,102,224,147,48,143,82,158,83,179,110,112,12,75,86,190,48,208,14,156,92,140,55,64,14,23,106,204,140,48,97,72,62,247,14,217,121,31,224,171,233,69,177,129,185,71,17,87,96,138,78,19,178,198,229,37,235,51,51,208,149,100,111,39,54,197,126,215,245,125,0,18,64,157,246,4,183,62,21,82,209,182,193,74,163,255,99,143,38,119,30,171,116,62,129,241,64,167,205,128,48,19,141,208,126,96,231,17,94,11,123,106,132,252,127,95,4,217,84,100,231,9,56,144,178,55,92,107,154,194,164,113,19,93,117,152,188,49,241,135,95,131,177,63,10,247,179,86,47,153,63,125,70,239,205,3,48,196,135,152,123,146,5,229,21,112,255,72,4,180,42,148,238,234,211,163,111,223,49,176,36,101,182,121,145,65,242,151,27,181,100,235,212,127,238,78,165,2,36,188,117,89,217,137,39,32,249,156,72,106,48,65,177,35,119,166,109,125,93,15,74,133,194,177,8,208,79,4,23,216,37,3,20,67,12,40,52,11,160,213,96,177,234,40,240,251,19,126,81,186,153,249,204,11,91,78,70,238,38,31,243,13,156,49,165,95,148,218,155,179,139,30,216,15,153,27,164,59,189,173,159,141,146,16,21,167,183,161,203,82,140,66,150,182,16,73,40,176,102,55,118,132,173,249,137,117,137,145,90,53,86,164,24,152,171,14,64,192,181,253,238,22,204,59,115,228,173,155,232,15,108,250,14,135,190,177,25,54,114,152,83,38,132,125,185,243,134,112,168,170,99,100,155,125,107,46,165,146,10,12,243,170,39,155,195,220,140,129,9,27,178,166,144,112,200,134,3,146,228,27,60,217,251,147,93,72,56,196,158,217,177,53,113,146,111,93,172,7,71,165,196,105,120,164,255,79,158,235,183,45,61,139,128,87,87,24,202,89,236,50,129,135,90,217,225,115,211,102,32,22,124,87,167,76,209,47,193,179,5,176,1,172,115,53,235,4,198,69,17,146,1,156,60,169,171,3,154,137,1,8,160,180,39,33,145,194,221,167,74,225,147,22,226,175,161,190,155,99,104,36,234,28,206,255,153,106,146,140,248,208,160,159,129,189,81,79,151,34,57,191,19,60,238,132,173,126,112,102,40,167,236,248,169,15,165,62,167,248,117,241,242,52,190,179,82,62,174,253,135,166,242,116,101,164,25,44,212,205,199,182,51,26,85,54,11,16,243,103,183,145,84,222,115,193,84,191,14,243,49,214,76,187,20,39,29,243,173,156,181,219,109,64,24,75,52,179,28,160,231,99,85,33,44,165,96,91,1,116,151,203,247,43,74,128,179,172,198,31,77,89,11,160,120,13,159,140,72,217,110,79,78,206,233,178,98,50,152,74,216,73,133,249,217,70,75,56,129,241,107,234,100,37,103,60,16,188,2,190,11,70,104,226,153,93,247,153,143,161,19,20,220,168,207,59,231,145,117,83,136,104,18,107,25,84,26,105,116,169,98,24,122,32,236,228,193,206,223,235,29,238,49,143,225,2,196,58,61,127,140,102,14,140,100,86,158,130,245,106,213,21,195,130,77,170,38,87,189,28,239,43,9,141,221,172,71,101,23,117,196,97,176,152,245,228,11,197,252,84,206,70,36,202,196,205,27,80,137,39,25,75,180,73,162,224,150,97,44,115,24,151,153,239,190,250,64,81,124,193,49,199,158,225,239,216,251,150,194,11,43,136,66,171,93,122,163,101,50,248,76,30,251,201,114,80,75,69,109,212,155,11,141,217,118,95,15,127,174,149,147,216,251,178,89,253,92,51,157,16,128,60,144,26,219,47,131,125,182,76,241,164,209,6,26,7,92,85,220,173,245,230,208,98,209,124,70,173,192,190,132,55,211,201,186,183,60,108,73,202,134,11,25,98,22,219,173,173,140,39,222,243,91,17,177,81,168,144,244,94,105,34,211,227,16,134,9,254,20,51,4,182,243,203,82,63,238,89,246,230,147,185,200,52,129,113,141,167,177,99,18,247,119,52,84,13,203,187,89,98,35,178,30,13,149,205,77,136,197,164,183,202,225,132,158,34,253,166,180,170,81,56,53,16,116,34,149,120,212,66,17,226,5,193,175,148,81,251,230,23,177,141,43,79,103,153,84,172,51,44,242,34,237,188,74,225,118,144,129,40,56,96,157,254,134,231,14,209,110,23,26,41,253,29,33,247,80,149,196,100,34,23,183,198,124,246,191,174,56,254,31,119,127,229,154,236,190,38,98,101,91,126,182,201,156,27,210,62,101,17,18,95,17,62,112,173,218,95,8,203,29,169,3,23,137,111,219,234,54,156,50,148,31,227,60,56,205,74,105,149,45,57,162,39,83,232,38,150,169,204,161,15,212,82,220,124,196,127,1,123,135,186,208,13,210,224,127,223,143,131,107,123,201,10,21,58,99,135,64,212,81,242,174,16,20,198,65,72,42,58,79,59,206,26,52,133,57,223,232,6,119,87,13,47,214,82,42,153,242,77,203,163,205,22,188,0,129,78,179,114,86,63,119,183,248,180,74,200,49,174,239,118,170,130,129,69,61,251,182,192,219,239,214,192,255,58,247,26,49,105,232,74,79,103,145,214,114,231,134,233,230,182,242,244,118,246,117,136,107,207,19,107,184,247,251,123,157,189,96,101,189,162,223,179,99,10,86,165,128,163,231,16,244,57,68,233,20,250,104,28,166,38,49,110,177,66,17,127,187,199,42,122,137,238,193,107,95,247,227,189,113,10,75,176,213,70,136,141,144,164,87,37,42,23,127,141,164,183,78,139,218,128,235,216,244,18,237,172,200,24,113,21,112,117,16,59,41,136,9,155,210,169,170,75,221,91,65,24,147,102,178,110,106,220,193,124,222,37,240,191,119,132,54,85,182,115,221,35,234,48,168,174,45,235,227,126,189,190,94,228,240,101,211,112,91,127,57,151,48,255,55,129,17,139,254,252,80,114,75,182,22,51,188,91,109,69,192,230,36,179,138,232,162,3,131,1,137,52,56,241,139,77,224,236,177,175,210,192,80,187,135,105,224,116,81,229,132,151,223,232,67,207,191,76,55,255,26,58,42,239,48,161,0,251,40,166,214,231,173,40,122,99,165,8,170,84,14,152,38,0,60,172,198,70,127,95,75,16,127,6,6,164,64,141,172,238,59,222,131,224,43,38,141,127,96,100,62,2,30,34,180,54,230,3,150,5,231,193,31,96,61,201,7,121,144,136,49,68,114,1,180,193,165,67,117,98,92,230,45,153,167,120,227,39,220,201,40,218,176,242,79,255,176,197,84,44,219,188,24,123,109,252,180,10,54,56,205,152,158,23,34,226,122,114,118,86,190,135,145,210,139,53,111,80,254,12,33,99,114,50,69,174,102,63,40,134,203,163,241,201,210,132,197,30,194,21,41,67,111,169,59,137,176,140,87,223,35,219,148,41,17,47,87,132,177,195,184,155,62,44,57,51,61,166,176,0,78,17,239,248,132,24,90,111,0,114,11,243,116,156,217,62,172,237,169,184,102,49,203,132,170,173,228,19,92,247,110,129,213,51,246,166,189,117,14,122,133,32,168,49,250,110,109,130,233,47,207,247,73,245,53,4,163,18,37,68,143,96,159,144,46,41,170,94,167,114,150,192,69,209,251,219,13,111,213,186,98,240,94,100,151,249,137,215,40,31,202,233,102,233,87,154,45,180,231,125,239,156,180,218,112,223,97,62,42,141,65,252,126,67,80,247,250,233,208,232,35,192,160,163,194,226,126,10,45,236,6,185,108,216,204,37,163,11,79,111,48,215,146,155,158,134,141,203,55,89,61,222,33,78,82,125,74,58,124,11,39,39,25,125,19,251,109,165,69,192,6,62,4,243,172,60,180,97,171,114,245,37,98,216,173,83,172,42,223,203,123,98,129,233,163,55,50,102,117,207,223,131,8,155,151,246,17,163,194,153,249,69,72,100,93,139,51,97,70,143,174,24,21,44,73,67,97,203,26,232,224,113,226,185,74,242,203,51,164,179,209,188,168,1,102,93,74,120,214,135,191,193,209,7,112,218,199,145,10,92,23,239,226,242,205,187,159,126,171,125,35,158,53,118,74,19,183,224,31,116,118,13,32,211,205,92,131,123,48,181,32,124,7,233,247,254,24,251,109,189,0,184,187,80,73,194,94,100,239,81,170,145,20,235,132,230,56,141,90,22,151,198,88,153,66,134,20,94,237,62,58,110,218,255,50,111,198,109,211,202,21,39,7,30,238,147,85,35,154,58,236,112,221,70,102,211,120,115,74,109,188,70,229,214,191,122,134,120,195,231,217,122,35,113,9,110,154,50,82,32,35,111,159,191,205,52,223,124,250,77,32,228,68,131,215,255,245,107,10,80,105,104,31,4,173,207,219,31,219,171,182,182,254,211,181,183,202,185,238,165,167,38,248,72,193,90,249,154,165,80,64,209,68,160,49,226,93,135,143,48,97,211,47,187,29,120,160,203,115,39,87,245,227,220,244,5,60,57,251,126,42,117,244,81,69,98,77,242,210,249,188,19,130,253,198,56,95,174,249,187,185,215,132,16,226,25,29,180,25,54,143,69,121,134,79,117,180,218,210,211,236,58,207,231,69,104,95,149,166,212,59,105,131,68,83,21,233,177,143,135,83,237,99,3,20,58,123,234,249,128,199,117,238,163,124,52,215,100,124,76,146,61,253,192,135,196,87,201,115,149,98,141,214,85,252,207,188,13,34,208,166,93,132,22,39,44,115,121,203,93,78,137,69,196,253,197,120,148,36,21,208,5,95,43,5,122,145,41,160,12,117,201,143,36,62,133,73,185,73,185,155,194,182,166,248,96,33,9,112,7,42,39,42,203,253,23,196,161,187,66,234,58,217,44,48,7,139,47,158,58,153,179,83,189,27,100,164,156,234,199,98,117,100,38,11,24,163,169,221,244,159,173,191,177,229,194,60,25,229,142,239,38,104,95,145,238,47,214,188,90,21,66,126,66,111,210,228,101,36,242,172,130,97,234,90,20,62,166,38,11,198,159,44,245,249,131,27,135,234,87,83,2,62,185,253,129,60,125,165,26,164,138,148,193,87,246,201,45,72,3,33,31,191,29,45,33,15,238,109,8,39,100,38,195,128,83,7,133,205,161,144,113,161,194,75,111,13,7,188,92,227,251,80,96,18,64,26,145,25,40,183,204,243,127,122,119,214,146,16,231,175,187,101,92,23,25,172,45,195,139,252,212,135,73,86,24,33,203,30,64,143,202,39,238,180,143,39,141,32,30,65,76,186,57,211,14,143,45,98,183,16,106,103,221,249,6,53,137,24,139,142,183,198,247,95,139,222,54,254,33,32,110,206,70,243,213,3,192,199,172,149,164,83,182,93,148,177,50,21,141,173,13,238,107,195,127,67,110,37,112,43,142,183,230,190,209,160,162,156,23,27,134,24,34,52,140,72,249,61,178,169,148,8,130,66,147,91,31,208,121,252,240,86,4,49,94,172,145,170,231,175,155,91,81,34,65,35,19,119,54,89,16,204,192,75,121,73,147,188,144,117,13,228,38,41,170,216,212,138,219,190,30,66,160,168,25,44,46,139,91,239,138,252,75,214,254,70,38,167,102,27,83,199,3,87,193,132,173,198,46,20,126,199,149,77,169,28,80,101,104,137,62,96,184,186,195,156,232,54,165,152,181,234,109,221,187,146,210,235,81,120,213,202,4,54,76,73,143,91,58,186,245,234,169,42,230,22,18,250,90,107,166,223,111,105,64,154,164,4,224,90,136,137,59,115,161,111,33,203,195,109,85,228,153,230,42,60,71,72,5,2,62,18,247,95,210,226,191,18,86,215,250,188,187,220,235,252,237,222,248,38,43,49,68,167,200,78,234,221,147,5,179,21,224,63,87,13,134,86,163,63,36,111,99,183,191,107,252,17,109,125,244,237,227,124,248,96,249,123,151,124,55,89,15,60,83,228,51,167,78,178,149,160,185,115,84,80,74,205,223,140,130,90,11,7,178,123,40,235,140,10,228,159,27,22,21,27,35,97,198,101,3,45,152,101,159,133,198,240,50,167,96,88,76,87,206,44,39,249,11,105,101,233,91,94,0,117,182,228,62,63,40,7,175,93,108,94,109,10,13,105,155,235,242,84,115,42,225,207,146,64,214,155,15,160,204,116,101,205,129,106,90,130,161,1,205,66,106,134,110,197,2,121,251,255,76,57,17,131,177,22,249,53,191,239,3,209,175,23,202,194,236,120,82,27,150,175,201,140,218,92,66,6,242,27,242,72,21,153,249,76,147,161,201,108,133,37,82,63,157,26,16,157,157,53,227,144,45,33,251,159,166,102,14,146,8,130,61,71,232,239,55,149,154,94,62,201,196,46,66,64,182,197,173,177,174,129,184,239,93,144,26,35,78,229,198,0,35,11,0,24,58,31,116,17,14,148,173,217,199,57,30,154,70,63,65,205,96,139,15,161,221,167,15,248,53,144,210,247,198,28,89,183,77,185,161,137,46,60,33,250,124,201,6,162,14,149,173,139,246,183,196,97,174,62,140,41,85,124,32,241,157,180,188,116,43,88,101,206,143,162,87,136,175,53,8,137,29,26,223,233,139,150,187,232,66,160,175,236,60,249,74,124,88,0,169,71,249,158,190,158,10,136,161,14,192,129,205,123,206,139,139,194,116,10,232,178,229,135,29,133,175,175,159,206,251,200,116,49,111,179,231,204,59,114,82,198,44,18,188,92,104,214,214,0,99,131,131,20,13,139,95,163,166,89,240,125,147,162,92,27,236,208,194,108,76,213,90,135,100,0,183,53,71,191,95,49,61,227,177,149,62,19,73,102,79,254,208,162,75,217,114,173,130,116,114,179,103,102,51,151,84,216,208,210,52,137,180,99,72,124,128,249,247,136,183,36,28,249,242,125,70,239,231,22,75,183,222,194,216,180,98,166,182,159,27,186,214,74,253,234,220,112,80,103,58,215,113,70,28,68,149,92,181,110,119,67,179,179,9,96,140,249,194,72,173,244,144,58,9,141,246,68,237,118,179,124,164,96,125,30,196,126,104,19,176,107,25,7,162,89,236,206,184,139,167,166,16,55,67,7,93,251,90,252,86,252,171,140,238,114,28,106,253,2,64,26,18,192,199,145,70,224,41,158,81,211,254,47,235,74,231,215,176,97,187,165,209,79,109,189,21,14,209,97,193,29,254,42,24,157,72,5,143,9,214,54,90,86,243,143,140,12,163,2,158,213,69,48,232,80,165,123,73,197,247,8,241,232,198,127,142,153,236,153,145,20,27,64,72,56,14,13,147,102,116,211,20,44,176,108,13,229,36,230,81,206,9,197,5,42,177,137,125,239,52,138,145,92,76,16,223,134,138,221,234,177,91,177,210,67,1,151,117,176,201,125,211,227,144,217,180,31,53,97,31,147,33,222,114,225,63,236,245,62,68,54,30,147,134,96,110,84,124,209,201,141,3,62,115,79,24,228,194,3,74,218,184,3,66,224,170,40,123,37,121,61,129,54,53,103,197,43,89,135,6,26,104,193,193,136,152,56,142,183,224,128,35,138,123,231,218,184,64,116,133,134,79,71,93,163,18,65,127,217,137,72,42,147,44,193,117,255,58,201,221,139,83,224,169,171,21,200,243,196,43,229,12,27,96,110,87,50,136,174,144,220,236,35,210,9,136,71,10,14,95,205,206,230,46,210,240,140,197,31,1,18,188,0,238,15,228,67,49,220,86,132,126,70,124,204,88,118,84,251,214,36,171,200,70,160,93,190,20,193,149,122,208,201,60,231,13,227,143,217,98,120,101,241,47,166,37,0,246,166,53,179,69,210,170,111,102,237,39,29,58,140,90,17,30,66,50,240,135,134,156,130,216,158,96,227,238,43,173,150,62,156,252,12,213,121,200,99,178,38,253,248,51,29,232,51,139,88,26,160,174,235,4,96,47,68,39,65,224,118,4,246,129,110,151,23,33,196,101,107,18,57,33,181,138,239,175,105,157,49,247,51,175,4,49,223,166,210,239,121,16,164,212,230,198,33,63,150,165,9,54,147,43,215,241,224,55,27,106,204,89,39,184,161,80,49,4,115,240,147,14,244,80,211,157,188,47,240,27,232,175,82,215,194,147,55,86,12,143,240,196,252,206,171,147,238,96,167,220,204,222,124,57,43,217,33,94,205,196,224,116,99,78,12,233,159,227,1,76,43,79,235,217,146,66,161,211,175,94,65,74,199,243,183,6,81,84,203,242,106,233,76,173,158,214,45,43,108,174,250,106,136,126,230,63,14,251,213,18,71,87,50,64,255,236,85,183,102,109,45,1,174,202,9,149,185,253,197,58,210,45,138,136,51,85,221,138,73,184,106,127,134,253,72,58,18,180,62,151,29,82,139,220,202,116,64,248,20,81,96,109,47,138,242,186,193,36,58,228,83,194,172,38,0,252,218,244,10,112,115,142,57,210,57,11,64,200,229,159,61,193,101,132,118,218,80,148,208,24,56,50,42,216,65,221,198,222,42,94,40,195,189,60,175,28,71,25,114,164,42,45,8,67,46,142,204,238,25,167,37,150,221,46,11,216,39,161,104,150,116,113,1,94,67,6,9,155,180,85,217,5,244,160,99,51,203,177,93,136,13,60,29,150,143,141,45,240,202,86,52,252,208,169,251,4,6,159,54,129,123,18,109,207,1,191,79,38,187,105,43,96,244,160,246,58,53,1,126,98,82,106,12,250,65,44,103,65,155,146,190,0,201,249,32,20,57,171,220,149,156,114,51,66,148,220,137,156,113,120,32,169,126,124,13,130,177,138,31,55,46,148,240,128,29,71,141,116,145,112,8,66,189,190,216,123,114,164,94,213,103,242,213,46,100,240,150,169,179,251,110,47,164,50,174,245,163,245,59,14,243,8,35,82,74,151,19,130,70,32,129,139,54,14,190,35,131,230,71,44,133,253,187,52,219,118,239,235,58,76,31,196,252,32,242,187,197,157,187,55,29,121,51,214,250,24,234,46,96,133,232,102,63,43,191,186,226,113,189,64,205,186,249,119,43,113,194,61,250,58,221,69,191,75,14,152,187,167,243,108,156,124,46,5,218,175,243,118,7,240,85,167,144,192,213,61,210,252,162,165,162,46,86,124,240,63,149,35,88,159,198,71,207,56,140,25,144,133,248,190,191,241,252,13,124,234,108,165,9,106,44,119,178,102,193,221,168,140,143,125,102,211,106,41,163,241,103,12,131,227,10,78,64,224,131,209,128,108,224,131,81,196,188,208,57,0,65,7,171,245,92,68,97,155,26,19,0,220,173,153,62,182,16,55,19,229,89,135,80,157,145,162,168,60,3,54,77,8,252,62,78,45,97,13,187,5,95,233,221,143,244,218,237,9,191,191,111,230,19,235,185,24,229,133,236,211,127,22,70,243,186,237,63,6,52,140,155,111,172,124,143,130,20,198,240,17,48,164,10,74,221,17,240,102,82,73,186,66,214,132,28,226,189,253,197,216,71,13,102,76,54,192,250,157,250,97,33,169,125,119,76,18,127,148,89,55,79,41,27,171,173,241,40,25,242,210,152,51,104,129,66,79,162,178,205,127,78,159,148,90,244,237,62,200,220,157,71,215,30,45,95,17,166,151,2,107,156,25,214,202,113,205,64,70,182,24,9,62,176,176,190,16,176,188,96,117,242,77,22,88,50,108,118,138,246,209,82,199,143,160,77,201,121,197,140,194,143,8,181,195,45,95,221,40,139,214,14,153,166,70,195,180,165,102,177,227,237,193,79,231,55,66,91,102,116,212,200,47,182,152,106,44,255,140,122,66,158,160,250,117,112,5,28,227,9,101,161,115,43,75,216,160,129,201,85,4,155,212,168,94,163,160,204,9,102,25,233,102,160,184,227,106,238,100,129,31,84,122,126,254,145,223,210,150,80,172,229,177,248,245,3,169,238,5,16,2,78,51,54,207,82,72,227,99,136,26,105,129,53,22,17,45,214,181,195,68,36,56,169,195,242,5,8,191,67,154,4,98,246,26,112,153,140,77,237,240,2,154,115,169,245,170,100,202,110,18,149,98,123,104,24,71,192,232,157,222,215,83,47,36,18,129,246,103,237,227,185,218,144,30,199,136,151,160,138,100,74,32,166,208,86,67,75,237,132,120,166,153,52,64,10,225,171,2,81,131,86,59,191,48,93,62,184,125,186,164,181,232,91,66,146,242,21,173,53,43,188,74,248,215,108,185,224,167,76,81,71,206,93,12,235,166,22,241,224,190,133,235,131,111,103,60,230,112,49,52,171,86,194,94,59,123,115,191,87,69,241,194,32,229,82,37,247,66,83,202,39,30,54,213,89,3,78,249,44,22,248,167,57,0,84,189,32,168,147,103,6,140,148,202,187,193,37,38,180,46,29,166,57,72,223,230,106,44,108,111,251,141,251,89,7,111,191,116,203,52,57,144,49,241,196,170,155,145,94,130,81,6,8,48,239,173,230,55,130,69,187,163,225,66,214,151,106,237,182,124,152,252,164,152,71,188,138,18,156,234,158,96,75,48,112,107,71,163,19,180,198,24,225,112,151,114,89,6,217,49,26,232,78,138,51,90,69,91,193,126,130,54,20,217,158,121,249,61,85,203,2,97,83,109,237,170,254,0,91,197,122,244,126,45,233,234,109,127,179,19,219,93,31,65,76,94,19,176,192,62,20,225,161,144,181,212,117,211,254,177,20,119,165,4,191,21,105,172,116,103,36,198,101,166,240,111,212,21,87,239,249,26,153,242,52,76,142,34,251,237,81,66,187,57,122,29,236,37,110,21,148,230,218,247,104,63,1,234,5,69,199,73,134,157,172,42,231,147,224,75,141,129,211,82,4,89,195,246,70,171,181,93,183,55,108,159,166,33,84,4,185,111,204,210,203,121,247,47,11,38,196,128,175,73,224,158,13,7,251,219,162,20,164,80,64,199,241,117,6,96,69,101,173,208,37,165,211,107,165,193,43,31,159,138,214,247,2,33,12,191,208,158,105,240,17,229,141,41,237,45,38,45,115,88,232,28,191,188,150,228,13,47,17,235,94,149,41,105,96,203,124,26,222,106,9,189,50,92,15,120,136,57,57,255,99,51,112,155,217,186,209,181,137,48,198,43,39,230,86,230,26,217,240,223,93,238,195,80,220,79,238,160,255,161,52,146,25,191,179,0,106,203,39,179,207,46,133,153,151,239,88,57,122,189,135,89,178,115,230,216,10,114,143,251,93,168,61,169,202,150,202,196,237,75,49,182,183,125,110,19,34,1,136,14,89,81,155,227,118,201,69,250,152,109,216,132,250,88,147,48,2,191,100,195,211,13,126,162,119,72,133,229,123,207,22,23,212,210,63,155,150,227,57,166,222,129,67,70,42,85,154,245,247,41,193,230,95,156,113,40,103,226,86,19,6,181,49,124,103,224,189,223,33,119,236,24,20,229,68,141,154,5,89,177,163,212,125,152,33,38,48,226,24,141,151,158,51,86,207,22,139,80,172,113,125,82,37,229,71,24,29,22,151,195,95,177,29,49,74,158,121,217,68,52,92,168,158,88,196,251,22,3,155,79,122,252,156,221,200,181,70,100,216,71,156,175,156,86,2,231,130,108,43,211,119,75,181,114,163,95,222,24,246,255,186,183,186,101,37,137,223,53,194,47,117,58,55,235,209,179,14,167,242,26,134,221,36,193,38,118,184,207,96,67,32,145,250,154,128,94,25,66,185,48,57,213,130,222,58,197,173,252,78,101,199,141,206,155,94,81,157,155,216,239,200,168,141,203,59,210,55,17,55,170,5,110,70,51,20,19,17,219,187,198,121,220,48,135,101,52,185,215,244,4,37,229,220,138,211,126,144,244,210,14,194,134,9,176,26,52,128,5,94,173,63,199,171,196,37,142,16,185,13,98,224,38,105,153,24,182,124,179,35,177,69,226,224,127,75,236,2,98,7,44,185,3,14,107,156,129,152,51,36,29,203,211,203,108,162,74,162,216,89,12,128,9,112,14,157,147,3,227,248,177,51,228,239,231,213,231,254,82,42,244,137,106,99,170,156,192,66,71,139,213,5,156,125,195,124,229,130,190,205,89,225,241,254,176,95,30,219,40,248,129,218,116,222,75,183,241,249,60,88,178,52,92,157,156,113,232,162,36,107,47,55,17,155,162,70,224,125,82,84,211,203,26,49,246,193,94,207,161,122,216,126,138,16,206,87,28,38,45,30,196,186,30,68,206,95,156,208,218,236,93,107,125,217,121,46,223,4,69,183,46,238,206,71,72,167,159,167,48,118,25,0,159,147,140,99,166,172,4,113,21,161,52,102,54,219,194,90,106,50,6,156,202,21,86,112,33,45,53,6,124,162,83,226,178,246,1,165,167,177,190,237,128,219,79,114,30,187,31,146,10,157,251,80,124,108,191,233,91,104,68,35,156,13,54,123,191,37,77,245,82,222,206,8,246,133,27,217,87,116,7,145,65,128,81,142,250,19,137,207,10,217,88,150,119,183,30,231,123,9,189,145,113,150,247,204,148,101,142,228,144,127,101,122,157,153,221,45,112,44,139,13,223,94,18,221,245,14,185,252,132,117,15,173,122,121,1,251,109,2,107,25,97,29,180,199,11,124,161,138,37,92,119,254,245,118,34,128,28,100,200,80,5,114,99,208,232,126,215,247,226,193,129,111,229,166,12,107,30,67,118,84,156,100,158,204,44,28,118,134,227,10,22,153,126,77,13,134,137,18,167,115,62,98,60,182,179,66,109,93,146,39,135,247,137,193,45,175,156,83,87,217,63,250,57,154,128,151,152,45,35,43,126,198,229,219,126,200,145,4,236,251,153,196,162,89,73,134,96,119,107,128,190,147,228,64,73,220,100,124,73,203,91,213,77,92,68,50,107,69,237,110,138,228,193,175,162,213,78,39,118,105,39,11,196,157,25,195,35,53,250,121,123,219,197,179,143,206,30,210,251,106,231,243,37,84,55,23,7,30,84,11,121,92,53,9,191,28,49,57,237,112,78,183,12,215,243,99,159,238,14,246,197,136,207,69,0,120,99,89,37,184,54,94,128,204,224,174,118,50,226,59,151,162,115,167,144,223,213,199,4,87,55,193,10,212,169,238,242,254,70,213,252,87,32,245,18,157,79,122,232,143,103,31,93,140,93,243,91,156,91,223,136,12,68,98,200,179,170,185,195,112,27,104,3,205,165,28,186,174,118,57,189,119,144,158,95,158,164,143,139,58,87,217,43,22,68,43,126,240,70,94,163,225,233,248,227,168,70,198,16,51,205,239,192,4,124,244,190,80,130,188,253,65,63,201,98,243,142,139,238,115,52,164,188,234,11,203,33,66,111,40,174,113,78,139,135,102,209,122,166,53,10,2,10,140,215,139,223,100,11,23,208,126,65,214,52,37,98,93,37,250,159,75,209,155,248,86,107,5,114,199,254,105,179,240,132,18,228,65,136,188,180,168,141,149,43,234,13,114,25,92,32,8,212,172,186,194,234,241,77,20,142,76,140,225,110,176,248,93,52,69,8,47,143,25,99,166,56,37,228,218,183,234,205,236,237,168,228,136,179,145,123,254,230,182,37,220,223,96,199,45,24,147,73,86,254,47,90,124,89,129,192,199,167,216,217,62,148,163,46,107,74,67,155,206,30,163,44,42,238,69,77,5,86,126,151,131,136,59,134,63,72,23,50,35,228,75,48,172,147,4,200,35,217,142,56,51,159,145,237,51,218,27,192,43,193,90,63,194,218,149,77,69,58,68,24,177,235,144,245,52,41,241,21,63,202,204,123,60,245,245,147,59,230,53,58,179,177,6,108,72,142,101,202,171,147,1,238,27,183,145,157,7,29,13,111,137,129,183,185,196,139,126,204,48,220,237,170,227,65,153,226,170,245,241,69,250,74,235,39,129,115,94,113,165,212,140,219,239,255,30,2,150,71,167,222,250,123,230,253,102,110,67,175,23,73,166,0,144,47,148,163,151,221,23,81,24,247,230,191,244,11,1,206,112,51,40,182,33,40,163,61,107,169,167,6,202,202,72,255,23,102,172,225,38,148,226,88,109,43,255,21,145,157,184,0,241,95,26,253,89,42,53,13,149,184,8,74,173,119,80,63,39,122,131,186,46,224,96,135,125,146,230,186,215,105,91,230,163,169,125,167,150,59,214,137,125,94,22,30,51,110,143,175,201,170,44,185,136,253,28,105,89,77,41,65,135,12,60,237,170,191,75,127,88,149,34,205,123,6,139,121,217,249,166,254,165,197,104,144,84,48,58,172,21,122,128,85,199,148,36,114,91,239,123,1,206,8,169,49,206,39,142,97,137,189,224,169,198,119,13,171,201,140,49,157,103,118,88,94,210,27,126,242,245,68,55,25,204,114,244,247,64,29,145,137,154,56,172,22,62,19,227,79,143,90,5,12,201,194,154,224,71,103,79,31,119,20,146,114,219,19,44,92,21,211,69,49,20,95,47,183,25,195,60,209,50,238,182,244,59,9,94,112,27,36,210,214,7,152,57,84,87,219,76,117,252,173,214,2,188,162,120,141,43,194,108,127,121,25,148,205,129,10,46,39,41,144,243,52,218,147,187,37,188,247,50,228,177,63,51,214,17,10,240,24,244,129,34,87,146,124,5,230,163,171,120,234,22,101,103,156,68,245,144,114,132,132,244,163,47,127,235,219,88,243,187,140,196,153,78,126,139,116,152,107,147,27,119,0,2,213,231,59,70,73,214,67,31,130,51,71,155,189,211,225,165,140,83,24,36,56,202,105,50,33,140,155,216,216,209,252,54,156,254,20,81,120,206,235,241,53,194,44,177,128,30,239,26,95,124,88,90,21,132,123,188,158,141,127,241,223,95,178,108,21,221,145,222,26,192,180,84,129,78,175,117,146,57,215,116,10,13,53,12,252,227,64,32,115,213,68,143,238,155,225,101,184,132,28,92,127,89,232,1,139,160,185,99,115,92,29,188,211,254,180,85,121,47,205,53,199,122,73,153,119,188,74,163,229,129,90,48,50,178,91,189,168,116,38,32,114,55,89,132,116,208,124,128,113,113,16,206,199,26,163,212,71,1,250,155,96,53,100,44,246,31,136,208,243,220,60,176,23,103,88,245,48,51,59,225,235,226,76,182,53,49,135,126,117,23,4,0,51,62,11,237,65,252,21,246,193,84,14,85,217,111,240,108,226,134,59,194,210,198,214,9,245,99,101,81,3,89,134,225,173,80,61,204,115,250,25,191,22,137,42,177,155,159,237,248,200,39,189,1,66,189,88,8,198,57,47,194,59,150,74,50,244,192,145,124,139,137,9,88,183,226,179,162,219,55,201,222,186,109,36,242,146,104,134,170,9,120,67,123,240,251,118,184,113,206,203,242,204,29,95,103,160,139,24,229,246,174,44,232,1,92,51,119,121,192,74,200,193,169,150,115,168,56,37,31,105,175,166,10,183,252,135,115,233,34,0,229,124,183,246,177,143,42,237,125,2,142,154,240,49,228,213,15,77,123,202,79,84,0,147,189,200,161,106,243,41,87,86,158,216,240,246,100,112,9,91,213,220,206,108,190,57,220,218,99,189,47,194,120,28,127,254,169,178,91,243,109,75,134,210,210,244,242,159,54,217,20,133,68,233,153,234,101,91,233,30,96,171,224,92,91,176,236,182,188,20,131,21,122,84,104,171,14,236,252,249,75,212,235,191,95,11,62,141,94,241,165,26,219,173,197,153,214,168,223,240,94,213,113,148,95,22,212,203,134,117,232,60,147,51,11,201,54,4,81,122,170,58,150,209,147,128,196,78,68,78,148,160,114,198,127,162,120,180,68,133,22,76,101,119,11,93,246,9,232,183,127,140,173,92,221,236,51,178,45,217,246,70,118,91,129,102,24,199,252,7,6,116,81,43,240,49,115,77,164,134,23,10,184,92,26,223,238,174,254,108,5,221,29,205,3,38,30,51,143,196,202,21,102,228,51,105,45,191,54,175,140,175,135,132,56,183,9,116,20,68,132,18,220,233,176,239,82,87,160,87,75,33,255,121,193,156,78,230,23,79,64,52,198,99,148,130,106,107,8,203,26,34,248,194,178,123,242,238,250,69,219,168,219,185,118,64,221,220,7,62,58,172,34,161,85,252,155,52,152,60,87,103,183,167,226,234,225,170,247,90,38,143,81,89,210,156,20,60,194,148,113,179,171,5,77,184,78,26,208,131,200,86,18,46,116,74,134,61,119,29,194,3,117,40,80,168,90,103,191,42,184,95,218,91,28,155,54,146,65,95,188,105,77,14,205,75,249,117,46,221,98,224,169,93,190,83,43,182,146,208,7,135,154,99,250,12,2,189,246,105,220,172,175,69,1,167,218,186,57,136,247,112,149,221,32,11,202,229,160,52,60,200,208,193,198,75,246,250,53,55,150,176,139,93,85,222,206,205,111,9,73,162,186,211,69,140,188,136,164,203,223,18,225,119,181,234,138,60,23,112,75,105,15,203,7,125,177,246,31,45,74,151,48,22,139,175,136,183,250,161,111,94,119,158,113,175,140,79,29,122,65,55,233,80,125,200,31,209,18,35,82,3,116,190,125,208,46,253,125,100,73,160,238,5,244,38,184,200,7,167,119,122,165,28,250,26,52,110,188,151,63,208,63,248,94,165,164,111,163,146,32,37,5,60,85,192,27,61,24,60,161,222,0,4,254,155,189,84,196,0,157,35,12,162,103,138,192,135,38,45,40,41,69,63,30,177,222,41,253,200,54,63,230,237,20,103,172,23,99,192,215,2,181,198,52,12,1,157,162,169,147,206,27,237,188,158,40,214,164,233,240,100,201,245,24,178,38,205,66,140,166,43,132,117,143,233,22,167,190,202,18,188,127,240,184,49,182,87,84,214,121,140,169,20,29,122,133,69,18,168,61,132,146,108,35,131,109,86,101,183,150,34,77,90,194,24,46,232,28,48,183,206,47,100,61,163,165,74,17,92,27,210,106,16,222,186,117,41,103,197,144,3,27,9,248,132,189,88,83,122,219,49,116,2,50,30,40,205,76,130,35,126,83,228,228,138,171,171,135,39,196,227,87,106,235,241,239,86,179,253,11,23,99,7,66,41,158,178,157,76,234,6,5,214,254,184,155,181,84,197,165,122,251,119,249,236,166,219,144,14,253,20,200,71,185,128,249,58,15,196,101,206,51,124,190,50,159,255,10,172,123,168,253,230,89,10,236,71,194,62,129,71,92,165,85,0,198,135,157,141,191,50,13,140,37,124,110,249,46,46,25,251,68,145,8,18,120,51,137,142,119,244,148,246,141,26,132,163,135,241,35,159,49,77,209,163,230,111,6,242,146,195,49,170,2,124,194,17,165,42,155,254,34,50,37,48,67,234,117,90,102,69,129,61,195,172,78,87,34,46,79,146,168,210,166,122,231,226,222,204,251,20,75,223,196,242,130,34,225,110,75,207,175,78,24,239,45,171,104,198,59,0,19,49,11,243,112,43,250,158,62,80,155,237,46,52,188,185,245,171,68,197,202,251,110,93,211,94,67,191,87,157,87,233,13,61,47,52,206,80,194,167,66,67,198,170,244,247,174,171,50,79,255,184,161,14,254,202,162,162,254,221,148,221,251,90,102,154,71,98,61,150,1,32,250,227,57,240,168,21,174,152,107,235,75,2,198,35,117,161,148,210,231,214,184,87,241,102,16,184,144,221,165,158,108,17,177,46,228,156,159,149,123,171,239,250,40,10,62,189,159,144,124,7,64,76,122,161,214,158,46,206,191,99,142,189,68,40,168,172,65,88,130,102,169,121,107,188,201,117,35,139,212,14,176,77,110,172,197,14,238,254,189,108,234,224,228,68,226,121,230,183,185,224,25,14,142,86,3,2,21,133,116,109,24,125,214,126,192,236,107,42,30,208,247,43,102,62,205,11,213,177,80,163,92,245,82,101,244,192,151,191,169,102,204,190,167,232,66,226,12,115,238,131,188,181,235,30,55,68,17,186,125,64,121,44,39,147,240,53,20,40,101,224,109,239,226,32,115,253,200,113,202,118,207,81,168,138,146,224,129,38,168,181,120,87,225,170,24,6,223,254,59,48,103,66,191,112,18,100,232,149,121,191,132,39,231,12,223,111,202,150,238,150,76,143,41,37,183,222,8,16,24,33,99,101,144,218,10,68,70,133,97,95,109,42,67,13,102,0,93,189,206,41,149,160,206,101,195,209,76,22,231,109,76,142,113,78,222,63,202,227,65,140,154,29,47,96,41,58,77,137,107,249,152,7,126,53,105,31,221,134,107,150,14,18,108,110,152,91,57,88,146,199,220,12,79,116,220,134,180,176,224,71,97,52,154,76,94,230,58,14,196,154,89,27,162,219,96,227,91,143,175,92,36,179,222,30,59,163,32,250,146,96,163,83,134,33,18,27,99,127,113,171,35,52,143,96,219,71,71,254,216,30,244,75,88,241,242,50,213,1,83,56,154,152,153,219,130,166,175,82,10,125,111,96,137,38,46,205,11,85,195,29,184,117,250,218,58,49,10,40,30,139,211,81,157,249,51,33,100,201,34,96,197,189,206,48,180,50,2,111,154,109,10,90,116,189,224,85,45,153,10,96,210,142,179,131,174,213,131,9,90,194,235,113,201,152,223,253,134,198,136,215,196,121,114,145,127,197,63,226,22,10,124,149,177,37,12,217,218,113,9,235,142,49,103,237,98,82,140,8,127,97,56,61,78,76,142,106,216,56,78,153,139,60,223,243,28,34,38,199,137,132,50,118,151,58,141,192,20,249,138,53,114,177,45,146,78,147,234,123,244,61,157,119,7,88,41,82,17,102,213,59,93,79,45,40,157,139,219,81,12,134,18,77,1,101,45,228,155,66,227,243,242,202,71,136,205,94,102,239,237,253,62,207,30,222,178,58,135,219,74,150,232,27,209,251,37,198,33,83,209,39,249,183,21,38,213,39,143,198,149,91,161,250,193,43,45,233,70,234,118,173,231,180,151,157,138,7,167,198,81,194,51,164,200,83,56,176,121,167,225,108,50,245,125,137,148,215,111,59,19,64,109,5,114,176,218,137,186,235,94,254,156,96,194,168,34,159,84,171,68,70,215,155,148,244,240,11,54,128,75,56,161,201,231,65,137,194,113,32,89,201,13,141,169,131,94,198,168,132,135,101,50,165,181,8,159,184,15,19,74,16,105,43,25,168,214,106,76,164,64,91,12,74,22,16,124,27,121,145,188,125,255,96,131,33,245,145,180,29,62,194,137,30,62,243,129,77,13,158,163,117,162,206,61,236,135,244,220,166,174,217,73,139,0,254,201,26,125,241,33,68,187,155,235,119,25,72,196,151,8,255,8,84,250,43,102,204,134,121,186,123,144,48,2,235,7,229,41,190,150,181,169,203,226,194,118,180,182,162,220,222,14,52,114,197,229,86,207,201,148,241,246,69,68,231,8,57,6,21,171,44,83,134,151,83,25,48,142,91,248,21,21,213,9,104,208,21,12,133,100,100,144,124,237,193,56,180,34,39,246,232,53,212,121,61,127,221,103,74,114,150,223,11,229,210,6,76,40,95,192,199,167,100,100,64,117,44,73,13,187,42,241,47,212,35,164,55,64,85,88,41,102,68,165,110,72,100,66,38,33,14,166,233,157,80,35,137,1,69,63,111,169,42,19,65,190,106,104,216,90,154,147,190,183,207,177,145,142,190,213,148,10,228,251,99,58,72,148,192,227,20,1,79,110,181,47,89,218,133,7,75,111,229,49,60,97,179,158,28,51,110,139,80,56,147,33,182,227,153,92,32,1,241,44,181,143,24,16,252,26,129,134,63,65,186,1,160,90,254,21,88,43,220,101,222,156,214,211,98,172,42,254,193,103,147,61,229,181,85,228,223,127,163,201,157,106,97,82,251,201,89,32,245,234,92,103,151,70,111,44,210,74,166,88,95,204,82,185,9,218,72,146,27,181,139,97,122,22,228,206,84,237,87,140,101,100,110,216,186,226,110,186,109,140,162,59,52,3,26,96,176,41,84,66,47,216,100,110,106,2,55,106,165,232,43,156,42,193,122,42,74,224,96,101,41,240,141,4,88,29,113,31,121,80,196,152,15,234,154,70,129,228,97,137,99,89,108,64,143,32,111,199,220,209,192,20,24,80,192,202,191,169,156,133,210,36,179,17,149,67,213,52,180,176,134,253,181,179,174,87,217,236,254,162,137,201,192,88,23,89,195,231,73,182,226,224,149,99,172,221,135,5,241,132,86,236,118,69,50,108,27,103,65,17,127,75,11,160,71,85,227,148,153,62,103,83,250,192,254,215,123,252,157,8,112,132,210,193,21,244,168,131,44,69,226,190,243,10,225,163,84,190,118,32,19,193,234,220,32,188,74,90,197,143,70,191,99,113,186,143,49,131,109,253,62,234,221,183,103,238,89,65,67,11,230,9,222,24,95,129,14,228,125,126,166,49,29,239,36,39,124,130,203,200,105,29,231,182,43,1,179,193,103,230,251,205,22,182,65,191,137,110,165,113,180,60,209,87,212,7,69,241,130,157,125,59,225,89,244,120,134,142,170,92,19,65,251,87,163,83,32,185,163,202,187,191,34,192,183,186,236,30,222,225,180,237,142,162,77,93,190,100,248,70,134,164,253,105,255,142,189,83,50,161,225,223,241,240,252,170,90,122,221,22,108,187,81,31,252,76,218,238,217,175,90,110,37,190,8,65,147,181,160,202,39,24,230,218,92,233,102,123,98,72,215,163,152,111,198,25,215,60,213,1,254,4,168,45,13,40,238,142,158,60,70,241,144,183,215,236,146,149,13,234,215,133,3,112,135,7,8,40,195,214,105,244,172,246,200,198,238,153,112,100,59,137,18,122,9,204,17,41,181,111,41,61,21,160,16,170,194,218,178,62,88,92,199,233,200,24,70,246,142,224,164,200,210,237,216,75,100,45,115,160,117,92,38,226,170,215,156,203,215,210,248,231,199,216,248,161,125,167,132,103,180,186,9,249,4,154,16,237,107,80,28,27,235,150,39,210,201,153,66,17,97,165,29,15,167,130,23,77,17,106,160,90,248,47,219,164,20,127,81,248,1,36,254,22,50,208,65,145,45,220,160,93,16,45,62,229,177,187,144,167,142,26,248,232,6,191,77,59,136,49,2,33,116,66,65,146,218,44,111,73,2,222,99,111,24,180,41,67,103,39,216,168,240,207,142,34,241,86,17,173,37,58,64,186,213,98,181,151,159,141,26,22,31,45,92,64,9,10,26,76,181,236,145,18,8,30,219,158,183,71,138,134,56,65,70,34,140,141,13,54,245,29,155,227,200,183,113,40,113,203,86,214,2,162,90,237,5,247,2,186,149,205,73,75,106,255,178,8,39,126,21,96,43,117,216,10,81,98,244,208,25,252,177,189,21,50,204,13,115,42,29,115,2,10,234,207,168,29,131,228,241,82,183,158,85,177,161,142,249,81,208,74,7,73,61,160,142,153,121,63,78,230,152,77,38,100,58,119,15,102,23,145,201,189,165,77,147,230,208,2,84,68,22,86,13,32,68,58,88,73,8,48,139,117,27,222,40,32,182,33,168,89,188,113,162,162,146,225,102,118,158,53,22,82,149,184,240,92,212,243,40,50,170,149,147,223,104,185,45,162,20,59,162,173,157,5,224,233,8,159,219,28,215,102,178,59,121,254,199,162,199,99,2,69,53,6,16,218,9,6,241,44,220,188,45,208,250,244,235,250,209,70,110,222,198,183,219,47,135,143,170,11,226,178,201,194,8,0,115,63,105,158,9,227,172,16,176,218,211,18,70,236,5,109,35,119,143,218,145,213,190,153,247,240,232,191,61,9,58,130,175,235,45,122,195,207,43,194,102,133,91,46,230,18,78,212,122,114,168,4,94,120,96,72,18,12,142,191,141,105,202,78,241,114,85,34,238,84,11,10,254,50,188,122,76,216,117,121,110,3,95,91,62,253,60,174,139,195,120,183,220,61,229,75,22,220,190,134,216,68,90,111,184,152,40,130,43,39,76,144,94,215,83,252,62,127,27,6,175,158,50,87,41,85,95,32,24,14,193,22,92,54,156,254,77,61,50,7,243,25,48,156,89,56,17,33,107,135,110,160,52,80,216,55,217,98,40,102,1,34,70,233,200,205,172,234,156,17,180,123,113,143,67,81,224,51,149,12,213,251,3,2,63,30,249,181,254,120,160,155,133,96,137,181,35,5,182,121,214,39,128,129,237,203,19,137,24,93,101,255,228,209,34,58,241,253,187,131,60,8,241,178,36,11,26,109,21,150,214,31,242,19,60,118,147,158,111,23,164,168,73,67,92,231,211,6,86,222,242,248,107,142,231,119,143,1,168,27,187,91,70,38,230,162,216,232,152,83,71,41,183,182,189,94,221,128,7,217,182,42,49,232,20,23,3,87,95,213,181,137,117,14,161,52,243,122,183,193,90,134,182,58,222,179,72,150,241,129,197,216,227,156,20,75,90,202,71,128,15,137,242,183,117,188,168,252,39,243,76,167,222,12,190,250,197,206,164,145,191,47,206,24,20,40,253,36,4,220,72,143,199,19,105,30,48,219,215,196,37,15,182,38,220,134,239,35,187,29,230,68,215,139,220,215,90,25,184,246,196,149,239,249,142,248,63,141,205,161,28,87,142,170,237,214,67,142,251,97,163,163,242,208,139,28,201,5,249,160,111,232,64,231,207,201,197,196,206,92,127,71,17,57,48,200,25,226,176,113,210,162,108,233,45,224,15,40,196,161,187,228,55,88,74,235,30,68,12,209,70,87,243,159,85,208,70,192,75,111,14,15,239,6,234,134,248,30,113,51,255,128,43,104,82,6,158,241,74,19,174,199,229,132,238,6,70,145,96,242,208,185,17,12,251,210,13,113,233,186,188,29,9,195,244,71,62,26,195,82,44,209,10,230,93,188,92,234,241,145,115,67,77,67,44,210,249,228,5,84,43,160,77,103,214,59,87,195,200,20,129,254,173,229,229,37,115,254,49,72,119,145,188,255,12,95,191,110,239,124,12,213,234,217,4,211,133,39,184,242,103,223,13,5,50,56,74,214,135,66,130,62,223,167,91,175,30,40,134,82,42,167,175,169,33,40,205,88,123,104,96,189,142,226,130,73,0,60,121,128,225,203,146,1,170,4,93,235,72,243,97,77,129,92,246,173,53,161,138,204,83,70,234,80,223,20,176,62,149,150,127,141,182,196,163,80,117,13,31,248,64,166,35,112,96,44,221,70,128,124,229,74,60,65,83,15,20,135,165,184,82,153,163,153,145,137,168,21,68,140,120,76,239,1,57,32,133,38,158,157,114,92,79,139,129,100,233,109,73,206,6,164,101,18,250,41,214,14,185,87,241,153,142,116,3,55,77,138,149,123,112,38,59,191,132,156,136,205,108,175,236,117,66,107,36,241,192,147,149,227,116,253,26,209,34,134,94,214,68,212,25,142,117,207,151,32,13,101,187,154,38,54,165,162,58,254,142,54,86,89,13,232,46,36,31,67,169,250,183,168,205,55,163,165,77,37,211,28,12,51,80,99,47,117,190,69,215,83,246,24,48,152,252,50,167,183,242,94,21,63,211,171,23,199,4,160,172,57,57,92,128,50,52,174,87,77,255,17,221,149,165,195,162,43,38,226,27,221,101,124,188,82,226,222,49,132,246,31,27,81,255,205,69,176,163,195,253,83,47,80,99,157,132,223,160,92,39,120,73,149,51,171,255,67,218,107,160,220,58,236,28,119,180,1,82,24,146,160,44,200,70,141,109,254,12,126,229,95,99,96,3,216,221,136,205,113,142,122,186,243,183,255,22,253,97,176,39,222,179,209,180,233,133,72,37,54,158,28,65,95,13,1,59,153,193,87,230,128,104,160,201,205,2,196,6,125,232,155,188,65,83,240,126,145,178,63,143,0,240,193,78,184,2,226,82,240,49,22,50,167,206,196,168,121,68,212,156,249,154,95,24,93,83,113,168,33,14,246,208,135,139,78,122,101,123,8,177,97,182,122,128,106,140,8,192,100,143,88,196,50,29,207,215,143,65,120,133,133,118,94,128,12,106,130,195,165,203,112,192,173,166,222,59,23,34,6,82,131,16,84,214,205,87,208,140,201,182,166,221,131,122,181,85,150,65,139,133,103,23,179,159,231,7,175,204,95,130,131,126,45,155,135,76,69,145,54,197,251,173,9,206,46,189,122,101,178,24,17,52,231,121,151,60,255,66,47,5,0,134,235,185,232,129,137,35,158,3,110,230,211,73,61,209,224,71,153,55,248,61,100,233,170,140,66,27,177,253,40,208,209,143,4,27,108,105,166,136,60,8,218,119,168,182,107,8,119,5,118,31,219,43,94,70,182,91,68,254,135,245,212,250,26,105,156,109,180,133,177,249,140,89,130,79,55,31,123,18,154,42,191,139,9,240,237,151,107,173,188,134,243,132,118,79,249,197,52,29,174,60,127,48,203,213,101,118,178,117,92,200,49,217,119,172,213,150,231,103,134,168,200,159,174,105,85,8,72,53,243,196,179,102,171,173,207,190,134,186,250,180,231,155,193,203,81,248,175,8,196,145,73,186,178,63,177,60,238,12,42,169,79,173,245,76,171,131,19,102,237,156,201,116,42,209,167,158,198,227,114,197,227,182,212,229,151,110,140,149,239,82,124,137,145,167,26,54,159,102,237,132,139,121,181,115,78,145,179,231,40,243,114,107,190,126,230,152,86,21,43,130,126,87,172,107,120,215,174,119,95,238,138,107,162,109,30,0,156,48,191,59,137,171,39,151,249,219,16,202,29,186,7,225,198,202,213,119,26,30,46,66,61,154,127,212,160,121,30,139,137,77,16,197,1,225,23,181,190,52,124,88,224,250,45,111,131,115,99,26,188,227,244,207,13,101,230,130,96,187,90,109,141,203,246,150,213,238,2,180,162,199,113,129,255,97,7,65,101,37,145,166,70,193,39,68,86,45,6,162,80,189,182,147,237,204,108,173,114,12,139,6,79,110,178,50,39,17,113,41,178,217,61,88,132,240,93,181,152,170,7,71,170,146,115,177,209,87,215,16,157,38,76,45,46,220,16,103,58,125,32,153,241,187,154,232,13,56,84,165,56,94,8,6,118,36,14,96,65,93,68,50,208,97,85,185,103,1,161,83,67,194,38,128,76,181,204,102,151,40,72,219,119,58,243,206,0,99,50,157,241,110,31,75,39,89,181,28,80,34,47,54,40,145,0,60,100,212,148,16,35,19,189,130,103,237,1,19,109,241,72,134,148,103,72,23,209,106,186,211,41,196,18,76,23,75,122,68,251,50,11,252,232,52,72,57,5,52,226,217,252,184,71,71,112,106,214,93,60,250,235,235,115,148,64,183,222,82,158,135,135,145,153,54,138,126,116,216,66,235,51,100,7,1,111,11,231,57,153,174,195,76,173,195,2,137,227,217,61,109,233,31,68,5,179,235,72,80,16,191,118,37,76,119,131,246,39,251,58,127,172,229,32,135,167,216,216,39,54,7,180,45,236,44,47,186,218,5,45,145,201,222,24,126,214,198,237,218,245,74,159,119,201,233,27,224,213,175,46,43,252,104,209,254,53,126,25,166,190,157,66,64,23,226,4,74,69,28,42,238,195,233,33,1,64,116,16,110,32,81,97,57,242,250,108,13,200,31,184,115,30,190,65,111,225,197,90,215,174,221,193,216,165,11,16,3,153,141,181,161,223,213,141,64,243,41,33,65,208,245,48,203,171,242,234,120,183,57,60,85,83,188,148,249,94,62,178,164,119,223,137,180,49,184,166,120,134,127,76,230,216,208,161,5,42,237,196,235,114,222,23,134,110,242,244,163,1,42,228,3,251,93,156,48,46,154,200,19,163,205,213,250,142,212,14,156,210,48,20,148,235,204,232,128,21,3,100,38,184,230,249,138,117,207,253,60,79,102,174,115,184,21,102,194,116,47,69,98,110,200,73,248,186,30,220,75,239,155,228,138,141,255,84,179,127,17,124,167,107,102,248,93,59,11,170,167,110,129,228,140,41,111,215,131,169,31,210,192,131,220,50,29,241,34,235,141,60,96,178,83,126,109,14,186,209,248,63,130,108,186,180,105,95,192,234,29,87,8,197,153,103,55,13,10,116,247,40,153,54,84,199,120,69,98,185,228,4,234,107,80,168,240,218,9,114,58,196,150,245,120,244,210,164,160,201,55,20,40,135,138,179,149,228,199,157,192,174,190,79,35,154,208,104,215,44,229,241,125,186,156,42,60,224,60,98,79,40,64,126,207,165,212,10,115,54,25,33,126,58,236,50,194,209,149,85,111,178,89,79,15,60,227,54,174,229,243,135,42,102,50,171,254,95,21,247,31,125,0,215,95,9,254,115,158,204,23,106,103,28,139,202,110,125,119,242,110,213,56,152,116,42,49,235,231,28,252,0,141,119,191,200,51,122,183,74,56,200,99,174,153,239,174,227,16,247,241,53,17,43,147,201,28,236,24,172,158,183,250,239,232,109,178,138,191,154,85,92,101,93,173,175,120,149,115,204,109,250,109,193,172,203,85,254,72,122,109,173,97,223,35,161,59,23,39,177,164,124,186,70,76,36,143,143,79,179,160,167,125,30,112,233,209,141,126,247,37,119,77,159,6,86,22,186,250,64,148,109,116,69,157,161,219,213,126,74,234,55,4,74,150,191,164,59,229,208,73,147,153,74,155,93,93,177,111,177,180,36,107,46,26,222,118,125,41,31,110,95,84,199,96,81,223,99,229,230,111,208,187,44,207,189,197,162,155,118,66,246,102,5,157,180,61,121,27,171,235,38,194,219,47,109,32,238,247,114,130,158,184,151,243,155,87,210,50,16,172,39,124,229,145,237,44,49,206,229,30,118,171,255,129,65,10,175,28,62,65,30,217,20,113,253,179,149,240,28,118,112,140,20,237,39,7,159,242,230,64,144,209,53,33,213,116,176,141,135,111,225,244,248,107,202,235,131,88,130,60,113,17,151,144,193,21,155,78,5,33,221,177,64,101,141,166,1,217,83,16,24,8,33,203,8,73,180,252,201,36,37,193,112,158,81,36,62,12,87,125,150,121,19,39,92,191,173,210,244,36,77,195,88,140,26,156,4,231,27,111,89,251,35,188,185,246,75,176,127,162,75,144,137,255,124,36,161,108,144,154,177,88,19,197,21,51,61,242,175,177,115,118,58,158,40,174,196,158,97,198,184,209,36,126,232,71,189,204,186,7,102,36,124,234,204,89,172,220,192,86,101,51,175,40,9,191,17,115,155,117,200,237,22,138,77,48,250,240,160,224,117,133,170,182,144,213,211,213,2,243,145,65,254,0,2,248,48,33,249,80,119,29,108,76,228,213,3,143,250,23,23,131,183,155,60,55,214,27,114,225,198,150,10,35,148,123,109,118,26,2,65,205,51,165,231,113,146,183,118,99,110,128,192,107,84,128,130,68,16,88,195,165,35,170,219,153,195,92,132,226,34,20,77,81,240,139,150,107,214,77,155,204,106,79,19,168,44,71,198,240,87,142,60,44,60,246,5,116,90,243,72,82,123,206,123,164,157,159,113,100,46,227,97,151,247,172,49,26,253,214,112,110,75,191,20,199,178,121,153,73,146,167,80,165,179,249,104,118,42,76,8,126,200,69,25,1,35,35,219,85,218,235,253,164,63,211,195,178,60,208,120,222,151,167,79,238,35,131,109,53,18,149,50,40,14,206,218,230,111,82,234,124,19,223,6,18,94,196,199,189,219,79,203,3,86,63,184,11,70,220,145,70,39,204,13,70,25,105,99,18,2,0,24,161,197,244,35,162,11,157,34,54,196,92,138,255,30,83,77,170,69,196,207,11,28,60,155,7,88,6,248,72,159,21,242,123,4,244,230,249,74,32,130,186,174,143,2,140,24,130,73,170,186,195,129,0,221,95,213,21,27,147,128,194,103,91,111,210,249,82,200,180,140,107,187,79,132,95,135,105,220,39,219,47,101,130,232,19,153,84,96,21,214,227,184,212,26,88,77,22,173,250,215,51,120,214,55,206,86,220,178,39,170,15,114,12,97,98,239,4,124,47,250,230,133,149,196,82,209,165,151,0,207,30,106,133,62,251,241,196,196,47,179,145,179,2,155,15,5,165,22,67,52,207,39,246,123,134,219,252,174,231,168,82,8,7,192,229,168,45,215,86,100,235,111,169,107,12,249,89,109,86,160,142,181,238,237,223,92,168,130,150,236,224,116,222,45,18,13,13,164,73,38,27,208,24,138,45,80,4,148,58,149,54,128,230,244,22,230,218,179,87,51,104,223,178,9,209,228,14,206,192,249,41,82,34,115,235,125,150,192,196,1,165,252,62,83,243,157,37,218,134,192,149,232,139,145,253,205,51,17,97,192,121,157,60,181,170,126,156,5,44,196,235,223,123,170,2,118,228,255,243,8,132,196,221,30,242,92,159,112,180,131,51,25,126,253,184,7,4,110,34,217,37,185,91,186,44,77,80,104,181,58,171,9,210,180,17,119,8,141,229,247,64,62,232,121,118,112,133,52,173,5,202,94,170,37,212,28,222,193,97,51,164,107,197,181,220,102,52,58,47,147,194,179,174,14,89,19,221,145,39,174,86,249,64,89,192,101,143,207,156,186,210,1,137,143,225,13,38,98,59,92,137,53,31,64,212,100,157,144,100,131,3,65,115,94,185,87,13,25,176,45,184,207,19,250,197,231,86,217,51,191,125,60,11,95,125,105,236,148,166,54,6,42,0,150,180,138,38,30,235,72,106,14,217,69,184,242,46,197,173,38,89,234,41,197,213,165,79,86,118,231,142,207,69,207,108,20,53,179,160,231,84,99,156,253,80,13,15,65,18,73,160,149,31,76,124,141,4,48,207,86,81,87,66,32,121,213,115,116,230,240,201,247,195,159,66,154,244,180,174,14,101,84,3,66,175,40,177,65,194,101,162,234,26,55,222,21,72,164,219,243,129,30,172,104,212,50,6,152,90,233,235,35,221,207,165,225,44,109,74,127,123,173,56,87,209,84,211,48,214,123,5,105,101,78,188,169,175,36,172,214,19,232,125,217,130,252,99,237,244,61,173,193,82,209,216,57,13,12,202,82,193,78,70,69,206,74,240,191,91,25,179,254,242,177,68,23,139,165,101,32,52,246,25,212,240,38,237,147,60,156,190,36,3,56,163,125,228,107,228,6,235,44,250,90,92,77,158,36,217,168,161,77,26,49,125,99,103,191,115,41,120,16,231,243,69,108,169,115,81,127,195,48,164,132,75,173,147,62,148,220,3,189,186,165,200,86,60,18,172,193,207,129,196,167,69,181,134,232,130,109,48,76,133,202,38,184,207,153,39,149,26,4,242,77,59,193,254,102,222,99,68,91,147,245,252,14,111,57,224,121,244,233,148,97,66,37,162,181,44,60,144,184,181,187,204,143,33,120,225,243,226,97,190,168,25,134,240,146,145,251,166,104,183,243,126,93,104,93,84,55,148,49,84,30,71,204,203,236,226,179,113,247,64,213,92,207,126,35,130,231,86,232,149,34,79,127,8,155,120,228,29,247,142,10,151,52,57,180,40,56,93,99,171,253,160,143,201,101,183,204,59,240,23,208,83,198,151,231,231,147,28,110,4,156,102,57,157,18,249,18,50,20,130,56,53,156,41,45,170,41,117,136,179,222,121,239,18,168,166,237,2,237,98,107,148,236,81,60,2,33,181,218,46,71,254,197,234,84,204,80,27,160,118,123,153,37,55,238,240,199,98,227,116,197,126,232,21,255,98,226,206,152,34,211,121,85,69,183,195,225,202,232,188,79,208,206,156,187,96,21,189,252,76,203,227,241,70,211,61,52,217,12,33,243,41,50,152,77,47,82,19,140,197,235,100,59,65,70,115,52,246,95,80,145,224,57,224,221,213,78,145,49,47,117,102,248,205,92,84,18,215,150,191,135,145,62,36,193,200,52,133,187,34,96,149,139,1,97,248,25,51,64,247,58,93,111,15,225,212,223,114,61,92,11,95,154,153,245,208,78,148,39,150,34,40,110,50,154,11,54,4,145,21,134,166,233,0,193,39,105,2,102,29,28,168,238,231,117,248,142,40,50,56,142,240,142,165,151,16,85,30,155,98,225,239,177,187,143,215,228,29,118,98,85,69,167,21,45,116,143,40,42,152,1,87,158,139,169,81,137,18,54,65,178,145,44,82,225,241,84,208,111,202,139,17,95,107,130,255,148,105,65,106,172,230,171,55,197,239,133,168,4,152,247,235,19,138,175,168,216,216,171,23,160,83,71,40,126,234,228,1,76,145,9,132,135,166,202,190,232,233,218,105,184,138,161,252,19,33,132,61,159,183,129,62,37,37,194,79,104,59,218,204,215,82,166,4,190,36,224,43,97,59,71,51,188,214,175,54,18,10,15,153,110,203,218,59,225,113,185,123,75,111,206,104,24,163,254,170,85,40,105,9,229,41,218,37,240,211,103,89,253,97,34,77,188,114,220,132,215,129,26,109,149,186,128,119,108,19,20,122,172,175,10,20,169,9,104,195,150,51,8,159,140,86,232,226,177,7,196,200,167,207,106,126,27,140,222,219,198,149,46,0,13,93,255,121,205,23,206,245,185,247,15,231,173,156,59,156,16,48,118,254,93,148,203,237,189,158,180,101,52,62,155,57,8,175,171,215,67,69,104,60,72,232,226,185,20,206,65,59,42,125,90,124,100,202,134,141,239,191,110,203,164,223,50,232,219,4,222,205,22,70,62,180,75,143,174,228,44,62,245,202,39,117,215,33,145,80,106,131,177,244,66,46,89,167,198,251,80,38,72,190,90,118,85,34,158,83,17,61,132,124,53,24,63,24,90,249,68,131,245,198,183,117,13,157,137,70,189,73,23,75,77,13,25,88,126,217,87,108,92,8,133,154,15,158,112,113,94,186,162,177,9,232,181,162,55,24,38,161,79,176,4,233,11,158,170,242,240,168,77,25,3,223,158,186,182,26,129,84,106,135,108,205,79,254,175,227,1,238,248,79,5,72,169,217,128,158,1,139,110,157,12,39,55,95,3,2,113,179,81,229,38,144,253,35,77,155,97,157,9,47,133,35,238,97,246,176,156,164,3,236,181,42,140,173,1,46,164,218,168,228,127,219,160,224,59,249,247,7,155,98,77,199,215,146,55,151,221,185,163,241,26,122,137,164,190,205,207,4,237,134,165,74,238,223,226,15,248,242,139,107,210,187,234,4,145,23,231,180,229,53,254,166,201,220,10,14,58,33,230,72,92,230,207,170,109,188,229,137,28,147,22,41,192,213,40,215,216,127,14,228,9,13,85,247,106,247,1,155,206,136,4,23,190,148,170,106,194,155,170,96,227,85,168,247,195,20,113,172,17,34,38,123,79,167,110,206,207,53,66,173,162,178,166,84,120,160,160,218,186,227,34,87,100,212,219,28,84,255,59,138,26,28,227,102,205,94,75,152,55,216,163,46,225,96,152,57,32,57,159,27,251,178,201,231,5,139,31,163,136,69,71,125,19,213,46,252,84,88,215,163,249,153,181,25,227,174,4,105,93,98,251,60,164,4,222,26,165,85,83,87,45,206,132,134,6,108,89,96,76,139,144,143,144,116,59,72,48,184,248,230,195,135,167,29,166,42,207,49,87,221,159,42,168,96,157,181,125,152,96,130,72,48,100,105,145,96,98,200,116,7,131,166,69,99,117,55,141,40,125,106,249,33,118,191,121,159,138,79,27,90,132,13,52,0,61,44,246,212,77,127,107,26,124,234,104,26,14,238,68,79,124,247,99,81,60,135,27,62,83,231,104,214,53,69,104,188,95,120,30,105,222,150,218,223,80,221,209,86,113,125,226,123,36,1,136,94,206,253,124,34,218,2,77,208,172,39,238,148,151,111,237,3,135,99,41,22,142,129,39,56,105,255,31,62,12,171,5,206,94,114,13,174,185,89,199,225,131,239,187,92,132,102,86,138,156,36,55,112,65,191,209,70,60,75,110,59,216,180,148,36,118,238,139,97,222,17,236,209,68,163,76,177,206,58,196,113,2,166,47,131,113,199,180,134,23,174,24,119,20,124,144,29,221,9,90,224,188,131,232,13,244,94,200,129,51,27,11,124,24,154,5,91,171,150,238,212,117,175,71,155,110,168,3,236,162,196,193,74,101,6,238,157,132,151,181,88,122,26,84,194,170,253,198,124,142,133,185,66,4,105,5,152,87,209,178,134,243,242,197,214,209,103,53,218,128,193,9,83,231,55,111,29,235,133,45,107,115,71,203,15,1,69,200,105,216,1,163,183,18,222,54,6,56,48,104,228,237,119,166,90,242,184,97,160,218,194,255,151,131,120,180,104,202,167,157,179,147,77,161,34,65,201,171,236,177,175,0,92,134,255,40,217,133,61,187,44,165,109,184,127,37,189,61,62,60,232,182,210,78,123,118,207,185,156,158,77,117,67,26,37,222,174,87,192,241,152,180,170,218,35,86,86,91,87,98,97,192,129,140,194,233,36,79,152,203,136,73,223,63,26,117,190,88,188,60,42,9,45,54,223,198,207,196,237,26,244,60,233,67,132,223,113,147,253,16,126,10,119,41,159,99,237,109,167,23,248,146,7,166,214,75,0,234,202,90,254,26,71,82,240,116,216,96,236,109,46,104,255,134,115,253,155,36,36,129,188,183,140,151,14,153,244,139,244,252,214,160,8,249,226,35,58,185,116,255,126,128,120,235,190,225,169,185,175,255,64,176,56,247,249,7,18,39,92,249,142,98,47,116,247,126,6,66,208,245,253,217,123,160,123,49,99,18,90,47,9,80,207,212,123,18,61,155,193,44,242,205,146,4,96,210,222,194,220,47,172,241,165,29,155,45,163,105,121,174,115,233,211,216,182,136,24,90,234,77,214,70,94,160,35,59,16,39,71,24,186,43,251,99,53,11,47,60,159,24,144,250,41,114,90,26,97,209,154,96,63,178,67,28,211,107,179,90,253,127,165,163,26,175,163,165,60,47,25,151,210,245,25,91,122,31,176,184,179,128,161,75,71,166,119,40,19,58,101,115,237,145,211,239,250,235,224,4,46,64,94,118,213,191,21,42,27,169,75,217,193,182,121,215,57,216,234,245,160,135,78,21,125,113,51,250,39,177,32,227,61,57,182,118,16,212,181,130,153,240,62,148,127,188,127,160,37,3,231,33,68,181,179,95,116,179,14,247,145,214,104,222,71,140,17,161,171,218,105,81,195,25,20,202,235,110,70,90,42,47,194,109,74,85,60,77,65,92,205,106,16,171,147,0,227,16,251,48,224,101,8,46,29,94,50,36,213,78,254,13,7,254,227,219,219,18,45,213,145,136,25,210,42,32,47,62,61,139,31,140,17,210,249,37,178,80,160,59,139,26,250,178,179,208,129,81,82,239,54,209,224,20,156,174,251,26,130,136,28,68,243,28,42,28,17,51,90,6,39,125,11,249,223,165,193,243,148,129,17,210,146,186,89,202,253,59,205,5,52,237,17,181,104,92,54,142,214,177,178,59,214,195,73,72,186,175,17,1,0,220,146,69,144,120,89,133,146,152,239,230,141,237,0,78,250,117,54,179,45,38,167,90,149,136,233,115,8,227,210,205,255,208,177,5,45,173,12,189,122,109,122,136,191,40,176,51,234,201,4,208,42,147,44,56,120,17,43,69,93,97,143,103,130,166,129,101,7,40,85,92,157,218,212,230,114,139,2,233,64,93,127,49,140,232,168,194,0,74,215,40,158,61,12,247,57,151,103,148,42,210,155,139,211,87,19,0,208,70,224,199,34,241,199,70,169,161,135,61,105,233,172,62,114,0,96,15,45,231,45,55,172,39,55,41,225,133,190,138,162,53,142,120,95,183,32,192,36,208,155,102,233,86,61,53,30,206,83,199,125,72,101,207,29,247,104,10,148,18,184,234,165,202,151,116,193,119,185,112,23,192,20,152,65,174,8,254,94,56,95,112,30,175,131,75,160,36,26,226,61,55,97,225,40,77,212,181,0,239,155,198,208,128,240,202,248,190,135,42,46,22,94,11,61,30,199,55,16,98,142,1,63,173,36,147,172,74,152,45,239,201,204,46,115,27,81,227,120,112,155,184,99,79,214,130,147,122,64,139,9,147,208,82,76,15,123,98,5,74,218,198,40,175,162,34,226,243,95,227,126,94,45,242,141,118,9,49,66,13,62,135,201,56,200,96,255,212,204,11,3,243,18,242,108,74,227,62,173,115,180,224,226,248,249,141,136,245,6,158,110,65,8,248,189,225,236,226,84,45,8,72,133,12,176,12,140,172,135,245,88,80,88,0,185,175,79,207,75,134,219,100,194,29,255,125,135,114,8,126,63,172,235,145,65,229,120,37,197,36,66,254,60,122,61,197,192,6,79,197,152,198,219,179,231,14,155,211,69,154,175,209,49,59,91,6,25,138,1,144,199,28,148,67,149,19,37,147,101,173,173,206,196,37,179,47,184,185,251,43,182,74,221,246,66,82,220,131,113,87,197,241,66,226,95,156,93,186,196,250,229,244,248,189,22,207,27,43,104,3,210,183,207,145,95,190,74,251,145,107,71,36,138,225,83,79,207,145,78,210,137,175,90,23,239,94,181,98,41,136,109,211,114,150,87,255,49,149,169,69,132,65,211,140,205,214,29,22,127,210,12,110,19,72,139,152,200,229,246,220,110,222,227,189,5,36,90,254,53,6,237,122,57,142,108,23,90,140,146,218,237,207,124,148,18,43,1,231,98,177,83,35,133,156,57,105,201,222,84,80,168,12,176,33,62,83,81,72,91,127,176,136,94,105,255,254,90,145,155,68,132,45,203,4,81,16,2,218,66,189,227,170,31,12,196,122,121,143,12,99,122,129,195,234,210,79,14,55,209,162,72,6,182,66,57,203,144,165,124,104,28,239,250,145,78,30,73,201,115,103,29,184,58,64,70,85,21,63,220,48,82,120,182,147,193,160,57,159,29,228,110,185,119,116,208,106,226,116,121,81,43,222,244,81,208,45,54,252,92,150,203,97,118,228,145,19,251,135,68,118,217,134,205,225,179,191,233,152,12,91,197,183,100,112,245,155,90,49,164,31,226,11,161,97,101,12,52,104,87,67,185,88,236,186,244,207,7,33,67,86,181,69,233,84,8,132,228,204,119,32,165,140,91,72,140,72,59,85,160,243,119,182,101,202,174,103,225,103,157,66,245,6,239,65,118,228,82,220,95,37,111,101,138,161,191,68,163,207,254,132,5,33,34,56,45,15,145,79,100,40,250,236,235,36,175,245,20,209,154,13,198,149,155,0,80,11,84,80,172,105,217,187,232,7,132,48,231,150,103,105,189,165,83,77,153,247,75,244,46,186,175,219,208,150,199,180,28,58,132,148,105,13,207,113,32,133,101,252,13,167,207,239,200,38,246,25,126,101,156,150,20,134,155,28,193,203,237,91,8,31,34,172,248,160,57,105,219,239,42,133,226,116,81,43,132,235,167,30,68,43,231,221,164,52,182,249,179,61,153,161,159,137,151,189,73,236,246,163,36,98,19,85,248,126,173,105,179,75,212,179,6,192,100,128,153,211,199,108,66,203,86,207,169,95,199,34,119,154,244,10,13,220,112,98,175,183,40,113,55,27,57,116,86,1,170,179,54,173,252,94,178,69,116,19,143,251,130,194,112,136,117,223,38,229,127,85,195,14,156,30,223,71,155,223,129,124,152,171,136,110,120,95,180,53,100,168,25,3,216,42,54,85,46,69,119,107,155,145,251,64,53,185,193,15,13,139,6,167,11,60,47,89,97,48,152,126,89,204,146,71,95,57,111,150,78,240,251,102,115,113,11,147,15,192,253,231,25,248,245,109,134,153,56,58,101,46,144,2,253,31,2,83,198,61,64,121,63,76,80,67,29,12,66,28,147,254,92,69,68,35,212,156,221,161,237,249,146,56,121,137,145,156,246,183,247,139,124,62,163,212,103,229,186,93,174,69,23,160,26,196,181,43,175,176,60,110,211,55,131,146,61,179,46,79,154,194,63,7,77,202,244,150,202,18,92,217,129,241,239,222,111,51,135,13,231,255,23,171,205,2,165,228,225,46,247,213,245,181,190,140,154,241,182,186,251,24,83,159,137,53,64,138,170,164,60,147,27,90,82,193,36,201,173,182,188,108,188,229,45,193,211,18,253,200,185,25,95,180,93,30,219,69,195,239,222,97,161,110,214,36,114,96,168,76,77,164,53,131,226,197,100,0,42,106,159,84,214,55,249,124,216,170,102,155,118,134,77,181,65,115,14,167,123,89,46,212,228,181,29,222,148,86,228,253,74,236,231,197,148,188,137,167,27,127,12,253,186,84,67,146,211,91,131,122,218,230,239,254,175,168,1,213,249,121,7,221,136,146,201,36,166,47,73,221,190,128,205,126,206,89,121,78,233,57,64,136,20,67,198,178,249,191,17,131,33,149,197,130,104,170,130,142,237,246,170,147,192,156,248,187,123,25,225,139,220,171,61,24,24,114,110,77,3,160,244,82,56,94,113,16,27,118,228,217,56,29,253,10,75,145,97,193,150,89,210,52,60,146,17,127,187,216,5,195,108,15,251,39,157,158,86,49,193,199,155,106,6,73,80,247,203,61,88,81,56,93,158,179,40,245,81,68,136,69,32,237,101,122,112,165,100,55,9,127,59,26,9,41,16,102,92,246,179,125,108,231,225,63,120,88,135,69,195,239,197,51,245,72,72,59,15,231,42,3,184,123,64,176,64,2,15,246,220,67,193,252,8,159,56,20,44,137,45,172,109,183,204,159,101,6,17,221,228,44,160,69,242,153,202,128,203,12,4,126,92,35,50,234,50,118,36,235,41,31,25,142,113,24,62,9,95,20,19,50,125,158,204,53,186,86,53,189,102,153,228,219,22,2,99,14,143,147,221,199,23,113,107,196,224,225,104,121,99,34,19,112,121,28,191,160,245,10,17,84,184,88,225,151,167,54,240,195,72,254,120,18,22,155,131,146,29,227,234,30,101,250,135,69,125,243,191,220,108,252,27,73,15,229,136,53,207,18,173,204,19,205,199,182,167,225,33,249,143,99,91,17,55,149,227,252,128,238,114,212,169,242,145,36,176,68,219,87,139,157,11,63,61,59,211,206,153,189,127,223,109,58,97,39,141,146,29,253,92,94,80,25,18,106,154,118,230,19,134,225,160,83,60,150,40,14,114,137,33,215,197,110,48,190,240,56,91,138,248,129,37,247,39,83,175,2,103,194,229,110,102,216,12,120,6,3,226,163,55,78,249,252,111,226,91,6,137,148,130,47,48,247,229,23,243,182,71,150,137,124,20,124,66,139,32,193,148,161,185,236,79,174,99,200,112,53,55,117,29,34,237,204,153,30,100,212,1,178,63,101,108,21,60,226,164,189,178,191,164,14,130,253,211,82,162,209,199,23,248,243,208,248,249,158,141,215,199,86,0,246,74,146,131,115,160,41,65,31,203,224,248,194,77,33,67,47,171,200,140,46,76,21,188,172,177,183,243,246,224,185,32,56,122,180,233,201,25,233,15,85,45,133,25,16,136,35,136,145,142,15,86,80,133,48,119,224,178,65,40,193,213,90,108,89,160,56,151,217,217,57,103,175,63,242,81,89,154,80,29,72,39,62,162,124,64,207,184,236,170,24,70,121,44,61,235,14,3,108,68,201,57,178,69,188,58,91,211,235,251,154,69,34,123,86,213,66,253,253,216,176,67,99,197,91,185,250,198,244,215,134,106,130,27,155,101,61,23,181,173,83,247,184,185,24,221,87,94,129,150,24,83,250,180,99,14,23,157,95,133,189,98,219,252,120,118,181,213,41,131,138,220,245,32,75,155,209,55,31,197,21,188,175,14,108,96,144,219,70,87,169,105,80,215,39,54,253,164,135,220,113,179,11,26,86,90,17,173,82,168,51,234,219,159,197,190,211,12,96,163,96,156,21,216,237,81,71,8,238,177,222,65,238,18,207,224,198,6,78,77,58,229,128,113,49,80,53,64,60,188,235,183,243,253,19,186,159,48,179,25,11,199,176,100,249,48,94,85,170,164,215,111,157,248,47,235,115,199,148,241,90,5,156,158,194,36,48,2,128,54,251,107,121,73,162,149,9,148,65,58,167,164,203,170,52,197,196,44,120,167,22,204,41,135,101,200,149,248,38,73,57,71,205,69,158,255,72,185,219,30,199,49,162,53,242,190,45,142,206,11,94,30,40,120,221,10,171,209,31,64,30,69,102,138,222,180,169,4,28,97,34,15,174,50,15,217,31,255,141,56,24,233,173,156,216,252,142,255,94,59,43,223,147,253,34,44,189,10,93,55,252,67,27,40,123,12,243,5,33,140,234,16,240,115,171,26,131,179,201,114,216,135,196,14,204,11,226,91,159,139,238,182,65,152,10,212,173,146,189,31,16,197,251,214,140,176,101,41,217,127,19,65,118,112,116,119,159,28,52,102,175,254,92,132,73,106,70,124,121,229,34,136,208,230,102,14,165,73,4,170,233,83,76,138,148,54,152,21,227,68,40,188,180,162,79,72,48,228,26,205,64,66,33,171,221,163,170,114,114,184,172,219,201,168,200,24,77,52,12,80,226,95,105,205,101,189,221,3,5,202,38,226,148,208,76,126,116,245,120,125,186,56,187,96,82,46,133,211,10,66,86,187,156,137,23,160,98,171,226,232,11,114,200,18,250,211,87,122,21,93,163,90,104,194,160,53,194,74,207,94,195,91,24,76,184,136,174,136,22,245,12,54,167,76,106,249,48,251,40,188,97,95,223,30,22,142,194,231,189,143,57,151,51,105,150,197,223,211,167,34,90,118,91,128,229,236,240,185,96,234,208,26,179,111,122,244,232,80,12,38,10,75,30,38,189,236,165,19,26,106,197,252,71,235,185,204,73,177,213,143,142,148,0,198,150,67,125,250,112,233,80,164,49,60,6,157,40,93,68,163,97,177,11,138,69,11,80,35,151,37,226,112,83,104,68,199,208,112,120,18,122,5,174,225,120,249,246,187,239,139,207,193,43,156,214,226,0,98,218,49,189,224,164,249,146,98,223,125,50,17,156,249,81,199,227,5,93,233,167,93,238,114,241,192,104,44,145,2,60,79,168,0,112,62,78,120,31,150,105,225,33,243,194,10,247,239,80,186,67,248,147,112,190,206,149,49,185,35,4,129,193,254,128,152,100,164,105,79,44,168,54,203,1,129,230,43,92,174,4,56,200,148,20,82,211,212,136,193,83,214,240,81,138,39,11,132,114,55,99,194,4,143,40,233,177,238,255,46,166,183,5,115,190,182,171,253,136,6,248,32,219,26,252,55,109,189,224,176,219,6,131,136,170,148,101,102,58,242,121,97,120,125,146,126,232,251,70,200,193,191,199,169,112,172,43,218,147,205,17,215,99,9,141,194,206,149,104,71,115,45,250,190,121,28,115,88,81,131,250,172,238,160,98,146,119,165,113,166,10,172,34,174,43,44,119,114,32,110,169,188,210,22,181,71,3,8,218,196,202,103,105,234,72,209,168,202,3,206,120,58,52,91,169,202,207,73,67,52,223,246,40,85,129,186,17,147,193,231,46,110,139,178,74,210,186,252,20,42,212,66,107,31,239,184,60,105,247,138,212,29,59,35,147,239,109,123,57,144,11,149,66,71,134,57,20,223,47,197,51,83,184,140,102,217,213,245,43,232,173,139,129,135,141,23,147,64,170,6,101,154,52,47,242,34,140,3,101,199,41,95,122,146,104,251,210,114,60,120,85,93,235,23,132,185,200,46,225,58,185,30,23,139,234,67,231,176,36,70,216,129,111,57,23,74,254,117,89,199,41,209,178,61,214,211,184,105,167,86,249,49,90,42,123,168,58,104,222,200,67,41,108,0,17,167,116,177,110,201,116,233,182,36,97,100,6,194,14,109,98,123,229,192,135,60,139,212,178,229,24,178,75,57,129,64,124,38,73,23,182,0,233,69,40,62,242,69,133,151,96,88,46,115,166,144,227,171,12,67,150,150,224,205,128,11,68,98,7,65,199,98,217,18,163,103,246,75,237,111,191,192,188,237,204,240,118,109,98,193,54,170,132,185,37,96,110,213,152,18,190,35,50,82,137,93,149,215,225,221,42,90,5,238,158,171,51,61,216,167,102,11,175,66,32,95,200,136,58,38,185,31,31,7,154,137,77,199,135,129,68,11,138,218,56,51,63,138,232,178,118,35,168,128,222,75,254,4,133,240,20,138,225,42,242,179,147,238,252,236,171,207,216,158,161,187,121,28,211,191,97,168,90,83,211,109,149,65,124,180,9,172,11,247,233,144,178,35,236,201,59,110,14,121,70,14,224,61,254,78,212,28,174,65,117,240,197,140,63,81,231,180,236,142,119,35,45,55,146,227,92,243,89,103,227,113,113,7,241,196,218,216,222,133,210,176,201,227,29,129,190,164,242,224,9,230,82,122,179,114,75,246,39,15,229,149,39,223,54,20,209,236,251,52,201,186,78,73,37,151,126,3,228,78,186,96,42,131,8,164,251,31,66,192,181,12,97,55,186,77,32,219,199,151,33,3,42,85,29,142,29,6,107,115,68,114,214,114,140,199,143,20,245,129,9,78,83,246,169,65,41,122,99,69,204,115,173,8,254,95,66,163,162,48,175,244,113,209,100,147,112,188,220,233,113,5,212,201,138,91,38,191,72,7,99,178,116,234,92,48,244,0,211,154,27,247,206,232,89,85,99,233,132,72,85,200,139,238,153,179,24,123,99,134,246,142,188,239,9,157,112,162,234,185,118,245,59,130,224,204,31,163,171,38,159,221,225,99,216,177,58,35,104,109,10,125,89,23,53,56,37,68,165,189,60,83,249,63,161,240,70,141,1,210,143,125,157,56,227,11,24,55,38,168,16,119,213,155,223,143,131,175,37,234,125,238,16,194,101,201,158,4,110,18,210,221,84,87,14,13,169,250,241,240,1,12,205,98,246,198,75,250,239,249,104,97,127,57,19,15,104,126,28,59,196,119,32,32,82,17,212,81,175,226,118,175,241,105,177,135,71,82,187,16,240,159,71,37,41,230,115,64,156,184,169,24,234,219,0,246,117,253,167,73,143,69,3,130,245,116,43,177,166,154,119,212,153,47,46,26,192,155,252,200,241,110,201,195,252,231,181,147,45,221,62,85,89,150,72,79,230,174,245,52,49,209,202,184,143,160,9,190,63,249,33,193,163,53,123,237,31,46,225,42,225,49,158,14,120,71,133,247,37,52,27,195,168,0,173,254,175,48,203,127,136,142,20,140,58,102,224,52,13,72,195,143,146,84,91,160,228,92,126,63,39,81,150,207,232,13,28,22,22,113,169,45,140,23,5,46,155,127,197,116,25,54,226,104,89,169,95,100,83,211,41,119,115,107,60,190,170,12,213,173,189,220,228,10,211,105,116,245,166,208,229,181,165,201,68,170,57,36,97,78,110,76,75,65,230,77,138,17,146,196,148,196,16,237,121,105,24,158,75,121,236,185,205,129,31,100,68,181,179,248,183,65,29,74,96,126,223,176,27,19,62,148,147,12,48,70,173,22,7,123,162,216,137,16,123,171,81,196,100,84,138,92,119,3,209,28,49,46,184,35,78,201,26,213,233,176,139,204,161,161,100,134,151,46,27,220,236,243,154,104,171,179,29,24,244,219,213,4,109,217,17,167,110,219,11,225,255,47,80,164,122,91,85,104,133,179,78,39,122,132,12,176,53,220,175,184,93,42,5,93,129,217,176,225,1,179,77,53,121,239,203,231,143,218,94,107,129,31,11,195,254,148,78,105,60,149,153,223,20,120,153,7,211,141,71,154,236,170,254,85,202,104,196,108,18,145,215,252,129,244,163,252,137,151,112,146,157,1,59,187,240,13,15,2,216,118,65,35,126,38,27,221,174,235,245,160,106,120,196,95,105,214,48,54,136,226,74,65,88,37,3,224,245,60,140,2,150,249,134,212,251,59,123,169,14,76,79,118,67,227,62,202,182,40,50,114,7,24,44,54,254,33,251,230,193,198,191,167,178,228,71,214,100,187,93,9,99,58,230,102,178,170,160,39,178,130,14,57,7,70,171,249,174,14,35,35,120,237,233,152,182,162,97,118,134,142,150,24,7,159,154,144,20,178,175,155,125,114,58,253,140,118,189,3,236,201,17,137,170,158,6,138,214,209,52,137,203,102,157,11,99,113,92,97,55,117,153,111,20,219,251,13,105,77,46,143,89,53,195,147,116,53,124,195,182,95,154,49,226,94,206,124,56,128,210,109,131,196,167,229,110,5,138,241,184,84,170,48,209,20,77,49,194,144,208,224,23,8,82,52,152,83,235,136,168,48,59,7,125,42,229,139,89,170,227,83,9,67,233,174,188,101,17,74,229,208,35,149,23,105,183,73,116,1,80,193,46,164,25,242,129,1,17,88,87,87,94,55,96,126,151,60,35,202,219,9,3,222,161,131,34,149,198,202,198,131,167,91,75,106,85,22,230,193,8,201,156,81,226,164,111,44,147,161,162,209,240,123,26,148,30,161,104,16,29,236,170,204,149,74,126,34,109,24,139,125,1,32,228,137,89,30,201,147,146,189,177,123,185,72,228,107,91,49,121,163,27,243,72,155,29,183,58,67,212,196,210,201,58,31,102,67,158,141,70,175,80,213,3,99,198,124,34,110,94,209,77,20,85,45,162,82,18,61,189,203,199,56,131,228,230,7,53,226,247,217,35,66,115,37,68,130,210,200,156,186,44,33,11,229,31,84,159,92,194,52,14,158,187,179,106,80,194,179,80,226,202,110,147,204,167,44,63,158,49,55,80,115,164,46,156,244,58,137,134,55,253,220,75,9,103,136,249,242,3,215,220,53,123,17,75,112,40,131,105,76,0,16,17,245,242,195,47,165,106,200,206,26,130,189,65,203,2,99,181,5,143,191,100,128,52,249,154,169,127,159,85,163,175,105,201,79,170,124,33,172,15,229,166,146,194,104,108,129,91,132,33,195,224,4,116,61,113,89,52,79,251,121,2,32,71,98,121,115,214,245,87,160,16,97,250,177,149,55,39,223,212,203,76,231,248,127,176,129,187,75,9,209,101,237,148,65,111,200,193,164,44,66,237,159,220,85,84,91,89,208,128,237,151,180,31,151,237,151,16,114,221,155,43,42,4,83,34,238,79,149,66,231,157,222,132,11,145,104,170,56,236,84,248,183,36,85,4,10,143,170,141,177,87,7,163,114,225,72,248,238,122,146,203,203,157,4,155,198,245,193,60,218,180,175,34,89,80,195,35,71,85,234,238,86,77,49,244,128,157,230,211,30,114,38,88,35,242,190,254,27,132,194,18,236,121,228,133,95,97,44,236,154,28,64,235,14,62,141,6,104,2,239,196,0,239,190,200,189,55,225,88,118,166,28,3,155,39,73,135,166,250,86,28,103,243,78,21,135,177,206,135,183,141,13,148,181,253,155,176,98,53,113,191,110,156,23,111,210,0,12,145,6,255,146,80,247,0,74,171,33,213,96,90,118,193,89,208,79,47,247,61,246,11,199,235,65,231,27,63,41,110,254,129,80,132,0,167,84,59,171,175,164,131,185,207,179,36,207,187,236,180,205,188,150,112,119,170,82,180,155,78,6,33,163,196,74,97,85,204,95,48,248,81,22,74,219,228,3,163,28,111,155,134,69,37,9,187,242,25,75,186,8,17,151,196,130,59,118,14,82,207,194,129,82,65,199,147,72,96,117,243,22,125,145,219,206,184,153,41,144,219,98,96,155,34,94,181,44,163,237,168,33,89,151,218,192,247,57,198,126,236,197,141,63,109,159,157,29,83,185,46,181,8,73,42,95,252,161,116,224,219,172,169,119,219,52,46,170,69,178,172,93,174,0,45,81,139,114,181,102,240,100,159,66,137,156,200,175,244,173,51,117,206,244,24,77,6,23,82,12,37,118,160,225,85,183,69,79,100,126,129,93,155,18,95,145,39,32,118,241,90,236,152,14,20,126,31,234,84,34,120,172,90,243,50,162,34,238,83,91,24,255,99,225,240,27,114,166,100,243,207,98,170,111,107,224,19,79,177,203,231,135,126,205,13,231,108,153,215,16,143,6,18,244,71,18,188,143,224,169,189,54,129,185,202,121,10,142,246,219,251,81,92,184,115,207,55,223,23,9,172,6,80,2,236,96,4,51,62,54,135,46,10,0,229,235,188,235,218,127,115,177,136,157,40,2,71,146,32,245,200,137,190,179,220,117,208,242,197,14,183,79,124,35,171,203,89,139,208,30,50,32,249,148,242,236,98,48,88,255,143,25,1,235,159,210,127,229,219,6,20,19,41,23,220,116,32,214,217,7,197,244,101,247,93,18,117,151,140,84,68,104,42,232,36,226,57,55,57,181,128,52,6,203,130,54,199,103,197,158,184,138,127,61,223,65,111,57,25,181,72,139,155,65,139,48,15,128,95,194,241,163,12,246,39,191,53,212,114,194,90,65,109,13,121,48,171,160,68,35,192,251,149,193,182,207,178,158,107,32,192,59,214,166,145,205,76,194,17,236,248,105,195,184,201,91,214,106,71,163,206,253,189,15,166,160,158,55,182,108,213,82,244,47,221,194,227,48,139,93,104,165,186,46,214,47,63,142,36,158,192,116,253,133,77,50,45,85,208,33,203,120,156,6,55,217,53,210,131,30,194,170,65,32,80,32,81,218,104,125,77,236,131,42,23,51,41,208,230,40,175,127,201,126,254,209,89,221,187,181,101,185,235,139,217,248,49,187,232,192,124,28,52,88,70,236,155,38,60,43,157,178,180,45,203,113,4,9,67,86,60,136,52,5,61,152,126,254,205,152,68,61,64,58,226,75,218,19,204,177,16,138,148,243,180,234,110,6,134,194,139,167,50,151,95,62,160,137,209,208,255,81,199,177,240,114,1,163,160,235,235,172,203,57,245,240,94,121,56,11,132,16,23,152,180,38,90,26,107,103,77,223,70,133,160,220,55,161,159,238,135,127,195,39,208,86,53,94,195,241,255,207,90,238,9,252,64,51,154,107,238,114,42,193,58,242,19,108,172,209,86,71,42,197,80,100,152,114,254,57,174,37,64,50,36,160,251,173,106,84,18,16,170,209,101,166,151,240,142,96,134,97,50,207,93,244,231,22,49,72,181,188,188,85,53,41,160,158,84,157,23,30,169,226,115,33,73,115,107,143,0,226,138,147,191,74,190,144,231,29,158,45,154,232,182,228,53,105,112,118,75,176,179,123,111,233,14,139,90,157,138,223,14,191,88,106,91,191,149,119,119,125,12,238,211,244,188,43,214,146,153,165,147,172,221,81,131,160,19,124,234,236,188,144,176,73,96,127,208,169,247,17,186,160,163,61,186,59,233,72,217,58,90,43,43,23,250,105,188,236,66,19,98,125,250,90,130,162,167,174,46,218,37,184,26,92,237,34,0,26,104,74,167,221,23,105,113,9,187,125,231,185,93,92,121,93,23,185,54,19,90,235,249,3,121,58,43,88,53,140,51,45,206,210,228,223,67,147,216,82,11,167,178,164,218,132,152,116,134,84,112,15,165,106,15,116,46,222,118,186,76,133,157,255,99,27,35,96,230,14,223,36,164,244,30,234,71,169,225,124,239,103,239,185,44,71,223,241,177,16,211,173,64,220,127,244,65,244,249,195,214,90,121,43,248,177,241,128,96,74,224,104,16,53,79,225,14,219,175,78,129,103,35,184,131,156,66,49,75,196,237,145,109,124,157,74,188,157,84,32,153,170,210,235,165,6,155,60,118,114,50,169,40,37,1,220,122,220,107,20,39,19,238,244,128,227,140,103,0,179,250,11,140,38,165,57,63,111,193,84,165,175,223,21,24,232,153,190,211,114,99,96,103,146,32,24,107,66,117,93,27,243,49,114,246,219,30,34,20,17,69,183,243,131,101,22,123,146,89,58,14,130,29,141,36,211,54,162,164,189,208,207,2,157,64,29,178,133,166,206,71,226,123,104,195,207,127,14,140,247,187,212,124,199,222,83,46,134,206,111,75,190,63,73,82,47,139,200,197,11,130,44,168,239,104,124,162,31,115,106,15,77,72,8,188,215,102,185,145,177,146,105,215,243,128,236,120,202,35,200,18,3,56,41,51,228,233,136,75,253,209,15,226,133,173,67,184,30,89,158,18,91,156,153,18,111,152,178,1,79,85,158,151,216,76,58,134,155,146,49,89,17,51,188,208,128,156,11,43,131,131,106,12,149,63,166,121,16,63,219,137,51,65,222,5,172,189,253,110,113,53,167,226,44,245,31,50,38,174,100,68,22,13,112,212,36,155,239,195,60,53,18,123,223,198,86,22,195,153,183,238,240,84,186,32,5,221,42,82,204,140,146,40,142,221,64,66,150,70,55,47,30,39,14,91,230,39,190,250,204,44,92,192,48,150,46,192,2,42,75,126,145,237,31,191,38,153,131,36,227,179,79,231,201,9,204,104,33,64,247,81,36,153,134,244,72,253,218,167,247,131,248,178,75,238,207,226,79,244,209,92,176,76,70,26,233,159,72,80,240,245,86,236,211,60,129,147,52,202,224,10,121,136,140,72,97,73,10,133,96,120,170,207,50,34,150,192,32,223,232,196,218,17,88,13,218,31,177,119,20,156,206,58,133,152,213,248,174,186,249,107,70,175,113,37,10,115,145,51,107,100,20,219,82,204,77,140,219,219,169,215,58,48,94,235,31,79,145,66,12,48,214,3,229,197,44,184,188,88,27,187,162,100,106,211,186,207,12,7,55,129,174,102,0,79,203,232,178,166,41,96,67,20,205,236,10,17,185,214,114,166,94,180,205,186,114,55,253,184,106,217,46,50,15,196,129,214,56,81,178,117,165,228,136,107,226,194,252,239,232,52,189,121,119,33,227,225,214,234,74,40,173,225,105,36,9,32,65,235,127,209,218,119,230,246,90,85,92,208,117,25,145,241,125,158,150,196,130,194,200,251,49,170,85,124,87,213,239,96,184,96,197,63,244,187,217,215,49,3,224,114,164,10,22,251,65,108,238,13,29,254,18,139,129,219,58,169,151,73,96,64,221,26,16,12,14,12,78,9,203,11,80,73,221,118,103,173,1,169,193,215,109,126,166,137,12,12,135,17,81,209,32,12,131,60,0,153,66,201,121,182,155,39,109,173,1,186,45,253,219,88,63,179,91,22,106,108,66,107,17,105,97,59,6,133,136,82,129,125,190,184,234,131,23,198,146,94,243,204,25,190,50,160,81,176,220,38,215,41,120,112,38,74,163,171,24,106,116,214,231,194,77,99,71,195,47,141,134,111,103,119,122,241,34,5,170,123,150,232,85,63,156,112,76,202,78,176,136,79,161,164,245,223,119,235,27,8,99,121,57,0,225,90,143,129,173,209,102,133,158,64,233,181,113,212,237,35,132,15,88,36,85,226,152,217,11,16,251,213,25,7,85,125,48,155,221,141,133,205,66,237,6,5,241,72,247,133,199,177,78,236,71,27,110,205,207,241,40,22,141,156,101,179,172,227,30,248,161,147,84,177,176,26,32,103,36,110,30,67,137,223,121,255,110,247,94,76,30,149,83,111,96,72,165,93,200,58,207,176,213,13,29,75,187,45,112,179,43,234,213,242,216,43,249,33,207,40,167,96,46,219,167,44,111,57,183,96,243,201,5,215,73,106,130,134,7,142,153,17,97,126,88,35,57,154,246,15,16,48,120,187,131,106,242,11,250,99,54,230,135,88,172,62,208,30,127,145,236,44,247,246,202,229,174,206,139,144,172,167,141,73,106,163,33,202,57,80,76,67,219,18,99,153,119,22,223,8,132,90,173,119,88,241,34,158,228,149,129,248,73,110,153,176,170,26,33,117,151,227,204,107,181,26,21,245,164,236,219,77,199,199,35,205,68,49,148,238,100,242,214,99,155,100,23,181,56,99,13,119,225,107,153,143,182,246,225,208,95,196,75,114,87,98,134,84,115,210,91,16,159,38,83,255,6,141,147,176,178,28,7,98,154,157,117,22,186,222,203,229,195,97,78,111,21,1,209,7,216,220,49,206,103,113,12,92,248,125,213,205,208,125,25,23,255,131,122,18,244,102,110,19,246,57,97,29,160,122,12,249,191,178,249,218,202,196,118,95,227,2,202,72,253,166,224,126,142,247,255,235,17,182,40,239,72,49,69,198,190,146,45,197,143,72,232,60,106,114,24,207,64,199,21,148,63,154,255,94,65,161,221,130,35,137,115,115,180,84,241,144,61,126,156,106,22,242,150,187,185,206,193,114,109,233,188,162,195,80,84,37,148,76,38,233,82,107,55,196,65,244,142,66,169,247,79,119,3,176,143,31,254,163,250,36,254,95,244,199,37,243,80,12,199,218,35,41,133,113,33,14,19,65,68,109,255,12,46,255,36,190,184,245,158,28,243,54,230,255,252,10,28,140,185,137,52,36,177,174,246,253,228,33,46,4,171,48,142,104,247,44,43,68,29,108,218,170,183,172,241,193,73,207,219,37,138,1,150,130,219,251,45,165,77,163,56,41,211,48,28,136,245,232,57,137,129,92,21,128,45,154,238,208,32,231,214,120,74,179,72,201,37,186,206,84,50,7,123,49,12,239,253,65,164,149,178,102,109,53,34,240,96,200,137,6,135,145,49,172,151,73,182,67,200,127,30,211,36,85,185,165,56,97,54,221,209,90,70,22,143,152,129,15,204,59,5,143,171,180,132,244,145,20,44,11,142,181,72,223,151,147,26,241,164,157,222,7,97,79,43,35,103,66,163,25,155,118,174,109,181,98,111,56,136,55,63,81,51,89,250,61,148,153,110,132,172,218,99,18,104,242,83,175,53,197,209,126,182,44,53,73,229,104,21,252,214,227,27,176,170,31,200,156,251,40,253,90,104,145,10,1,175,235,135,77,56,137,11,51,99,233,59,250,122,62,196,2,245,142,86,59,143,192,123,130,214,245,182,157,134,228,82,199,243,29,167,83,105,75,4,236,116,174,50,18,89,242,200,87,109,23,221,184,42,3,82,80,103,135,218,190,7,129,98,180,64,149,196,181,217,136,28,58,56,53,14,16,248,30,82,197,85,149,53,2,112,81,243,53,131,126,174,187,3,237,209,3,20,9,246,22,3,194,201,118,169,89,116,66,199,66,16,175,193,47,238,65,137,126,87,148,144,167,191,216,137,23,120,162,24,80,68,168,161,148,167,6,137,56,1,160,59,75,181,56,92,175,90,233,7,212,173,52,242,167,91,64,194,196,220,18,71,186,221,224,84,47,76,156,55,190,180,102,18,21,27,55,125,249,219,154,48,54,210,58,72,73,154,78,48,73,105,233,200,178,230,208,130,172,18,160,79,130,20,166,83,203,232,203,108,136,211,228,152,192,103,222,8,46,245,50,29,25,234,254,228,47,202,93,242,41,33,139,115,212,186,141,90,222,177,4};

// The scrambling tile of 128x128 pixels.
// Each pixel contains an optimized 8d key used to scramble the sequence.
// The keys are optimized for 1spp in 8d.
static const int scramblingTile[128*128*8] = {162,160,11,3,246,114,78,175,104,235,117,130,244,162,170,193,165,9,222,138,235,0,113,1,239,134,243,231,86,45,38,198,104,99,105,55,192,249,84,186,209,7,255,177,168,233,66,6,102,80,255,13,8,199,27,244,169,68,205,221,244,132,179,15,53,79,64,225,73,17,143,245,240,80,25,106,162,29,79,229,20,105,38,140,0,146,100,86,153,8,64,150,17,215,153,201,182,66,150,255,206,190,92,132,63,150,249,226,102,230,157,94,242,209,101,202,139,220,46,165,212,23,54,196,176,131,197,145,0,100,190,119,72,126,175,23,109,209,100,122,26,142,254,66,19,60,53,45,249,129,51,76,43,225,12,156,89,241,93,26,188,137,247,77,168,175,105,182,230,32,214,201,20,244,221,140,54,206,130,152,90,73,90,208,174,58,196,25,244,95,160,229,155,254,251,107,149,16,43,191,103,241,72,94,113,254,154,70,79,109,250,42,138,210,35,241,131,253,56,14,112,176,227,89,130,101,149,179,94,91,7,57,61,50,191,215,153,5,183,40,66,92,43,76,15,108,121,104,47,129,123,248,152,141,95,39,241,211,248,2,105,32,18,9,157,78,207,171,110,92,197,153,210,170,11,244,103,175,43,144,19,112,20,36,208,239,172,64,150,101,91,182,250,209,87,236,40,21,214,4,125,108,36,85,48,179,228,155,120,247,173,146,218,150,7,46,173,7,45,230,112,230,233,41,159,182,26,106,121,51,163,169,161,69,234,183,111,156,25,111,133,50,182,46,74,235,221,197,218,218,63,177,60,187,249,233,63,42,141,6,140,223,228,176,158,249,57,84,95,229,35,109,6,129,190,247,125,42,45,147,67,237,39,233,45,106,84,58,42,121,35,88,166,182,227,94,6,131,180,206,221,76,78,138,87,110,14,16,58,204,208,206,48,105,223,159,168,189,24,93,230,204,82,114,168,50,145,23,214,21,94,166,43,191,190,254,153,134,119,233,150,42,200,211,112,214,223,155,26,107,115,77,218,254,125,160,64,8,106,223,30,151,232,212,145,169,129,119,155,242,57,142,63,2,66,96,104,97,237,136,96,174,85,141,196,101,76,17,205,179,121,0,71,42,203,227,141,116,157,29,12,37,95,166,56,8,67,252,36,155,245,222,17,157,191,76,211,20,204,96,243,178,15,187,103,118,196,213,24,76,49,4,139,133,89,229,149,218,82,82,102,208,167,228,56,26,254,44,215,139,227,7,73,230,83,60,160,202,81,52,133,69,4,56,124,49,155,100,43,216,204,144,168,2,26,203,133,106,149,223,9,104,207,102,50,21,237,39,154,85,61,132,127,159,3,79,188,41,48,104,178,8,203,216,198,39,250,79,4,183,61,0,9,233,97,197,103,23,79,36,216,17,185,41,117,79,117,93,56,118,45,154,231,114,110,159,120,42,13,89,132,7,231,61,128,223,199,251,251,212,151,218,125,124,252,9,165,37,140,127,173,128,135,9,219,134,200,206,41,109,232,150,128,248,80,140,155,7,126,26,147,186,238,214,131,175,26,98,58,123,223,179,20,89,155,210,79,96,81,240,175,239,156,109,137,26,39,61,199,185,91,229,55,224,186,170,71,92,117,141,244,67,59,181,118,36,73,63,22,147,25,24,255,131,6,247,111,15,158,231,161,107,83,69,125,137,98,158,34,254,173,21,233,51,142,166,188,134,56,126,231,213,29,226,213,85,138,246,23,18,203,31,128,1,136,84,151,116,193,72,91,91,44,251,189,42,218,204,207,220,131,180,81,229,1,38,32,40,170,50,101,61,253,213,125,71,217,207,172,180,23,148,38,250,166,103,34,155,95,56,235,102,3,28,175,20,46,168,126,178,233,169,150,175,37,100,101,86,25,202,46,44,73,37,95,193,124,1,158,33,242,167,203,75,149,75,249,155,185,79,12,23,214,34,3,85,99,216,79,141,91,105,12,225,198,45,33,40,109,175,249,165,102,110,174,9,245,172,87,52,160,47,213,200,156,65,156,81,112,229,151,168,188,249,127,107,171,140,184,220,106,110,62,209,49,34,61,29,191,125,255,212,148,15,249,92,27,88,104,152,82,26,25,180,30,134,42,119,155,126,160,253,108,204,88,55,109,131,68,3,41,23,63,59,176,181,22,157,60,183,86,233,223,45,88,42,132,217,156,188,79,58,230,176,205,73,20,36,27,127,199,87,10,183,12,132,243,173,100,72,146,1,174,35,238,84,42,245,51,68,84,168,3,150,79,187,122,174,138,143,162,97,2,101,139,24,151,16,221,176,39,138,185,36,136,66,211,80,13,44,25,198,12,20,181,227,175,230,254,2,222,114,253,1,39,120,104,251,117,172,71,96,6,146,192,155,42,2,187,117,85,75,192,110,144,101,21,4,116,5,130,67,29,213,53,66,253,119,210,223,254,99,13,173,236,53,108,8,55,201,165,251,49,109,37,70,92,132,151,93,144,129,226,45,100,53,24,194,222,227,197,183,245,134,218,90,109,73,211,97,92,230,113,8,147,33,29,234,105,168,47,160,119,3,212,48,229,37,69,71,243,84,158,232,122,33,149,201,14,47,61,94,176,239,113,148,135,12,36,138,205,104,105,192,9,66,112,61,179,24,151,244,224,39,131,244,232,241,196,174,58,55,226,222,23,130,254,115,251,110,139,217,51,7,68,40,255,243,128,127,217,150,46,95,167,53,234,19,3,119,164,50,130,174,42,79,179,118,111,216,177,201,84,54,35,26,209,224,56,240,131,118,199,147,71,148,194,94,153,153,7,155,36,251,48,22,243,42,183,14,102,105,225,174,121,252,8,213,203,205,82,228,46,9,236,189,75,206,42,243,252,212,210,31,229,131,239,251,41,184,169,126,236,48,8,130,228,90,46,13,64,101,163,47,73,211,183,205,178,84,39,21,222,23,186,27,158,164,182,203,133,148,64,226,42,73,34,13,241,251,219,90,19,146,128,154,141,199,80,133,156,16,23,179,144,2,75,21,100,104,245,104,79,33,134,75,197,72,44,125,240,13,39,105,63,139,67,202,113,209,156,207,70,232,17,106,9,54,53,31,190,95,109,153,251,80,215,42,43,44,94,47,48,54,111,56,75,124,142,21,116,247,127,138,132,206,203,46,27,160,13,219,42,227,187,86,246,8,241,59,198,38,28,193,107,152,147,240,166,160,223,13,251,230,137,79,163,47,177,157,121,67,35,63,14,142,144,223,180,32,181,231,213,101,28,155,49,209,199,116,198,136,52,93,253,205,169,144,66,68,183,112,79,77,226,198,36,169,161,217,12,60,118,214,249,40,215,123,200,90,199,204,153,181,74,117,121,205,129,65,50,17,18,61,115,121,193,35,173,218,129,58,129,190,79,95,215,186,121,191,5,216,63,137,250,232,30,117,201,30,7,241,199,104,230,134,116,68,199,138,158,181,181,9,26,45,131,249,214,199,83,160,93,18,211,43,102,233,34,211,18,185,13,242,244,228,250,108,98,100,68,189,199,168,54,143,45,50,235,76,99,157,3,84,165,23,66,86,177,162,232,100,23,154,12,115,166,6,114,163,251,131,185,163,4,79,202,2,96,159,201,201,48,183,245,192,206,219,13,233,86,20,255,188,4,121,214,131,240,249,42,53,177,138,131,190,12,162,98,164,221,50,116,217,158,80,151,216,17,8,189,83,224,186,69,154,111,9,169,235,189,194,82,12,233,181,95,96,48,221,19,167,65,204,46,25,92,11,138,83,140,22,185,243,7,15,82,253,45,165,15,105,13,238,230,147,14,33,5,54,134,186,233,101,119,209,48,173,202,111,4,128,238,220,156,48,172,107,232,194,99,180,122,8,114,197,100,231,48,53,87,220,157,245,122,36,226,33,214,109,216,121,186,6,9,103,137,223,116,156,46,148,248,164,83,42,51,34,62,23,238,124,52,32,84,202,184,243,176,195,218,144,11,83,134,80,134,187,181,17,177,89,223,149,11,196,55,157,223,234,15,19,235,125,119,76,110,74,77,26,66,243,103,163,216,185,5,162,199,29,130,251,114,138,189,227,225,232,114,127,178,200,112,45,68,126,217,101,137,177,230,141,37,58,4,160,15,212,241,58,50,252,231,192,183,102,140,138,97,23,247,92,236,145,64,253,83,189,90,119,50,58,85,22,220,46,18,234,164,248,216,157,41,95,160,50,154,121,25,166,172,138,238,229,107,253,171,100,97,181,30,212,48,8,156,254,131,30,169,95,25,159,231,0,206,248,78,148,245,5,227,167,75,23,207,28,210,251,33,176,139,198,122,129,68,58,128,118,162,29,22,241,39,181,72,237,45,173,43,25,232,88,206,102,38,6,134,31,1,140,103,173,139,188,101,33,17,102,130,45,222,35,126,220,241,187,37,68,155,253,255,114,223,207,198,223,89,97,237,169,113,81,45,61,183,251,114,216,254,224,219,55,168,109,212,88,127,18,118,83,211,172,103,153,135,117,183,155,90,130,71,21,29,145,181,58,99,8,97,162,133,221,251,36,198,254,249,46,121,58,227,187,56,62,42,58,210,40,215,112,238,44,226,225,240,137,64,234,29,119,121,102,87,199,182,9,253,139,211,222,211,204,207,211,179,78,16,148,43,53,175,66,172,138,184,178,82,188,108,197,89,104,120,84,114,194,213,98,9,245,201,230,170,131,162,190,28,10,65,243,64,252,22,191,104,155,110,20,43,231,151,197,203,185,236,223,244,58,100,195,35,148,174,10,200,120,99,168,178,221,244,238,114,37,99,2,52,193,23,164,133,173,229,80,13,11,200,55,223,238,88,205,126,1,35,47,165,111,203,44,132,175,77,64,45,108,57,99,67,113,152,170,232,169,120,164,142,25,170,129,212,27,137,135,250,230,56,56,243,73,55,36,132,167,233,168,225,137,225,240,214,38,93,109,33,77,85,139,28,63,25,68,118,42,159,67,14,188,228,141,143,202,176,205,224,121,186,193,83,170,38,135,58,245,72,1,38,57,78,158,82,1,250,210,199,189,113,20,83,155,79,131,13,121,209,240,246,191,219,36,161,146,89,113,191,213,111,93,160,24,102,180,19,30,81,173,255,67,185,193,6,186,217,238,244,136,176,5,131,38,241,87,11,132,236,216,174,68,160,250,146,4,14,90,193,179,19,124,26,37,237,78,134,222,120,228,181,172,76,0,156,0,105,190,60,113,192,40,130,139,198,34,220,233,157,85,82,108,57,99,89,62,103,235,42,24,83,117,132,224,50,233,184,2,102,93,201,120,192,66,3,203,146,177,172,238,6,81,216,251,55,245,86,145,238,162,71,176,209,124,200,230,239,59,165,92,116,178,174,202,40,177,163,141,232,69,91,7,157,238,65,80,90,129,206,169,213,182,223,242,179,112,142,2,74,77,208,54,208,221,85,243,9,20,186,79,131,11,218,96,28,168,168,63,233,104,236,131,78,40,26,60,249,160,107,76,219,133,152,5,14,97,112,47,171,114,70,34,69,72,208,153,106,214,145,157,137,132,25,33,201,172,93,140,248,28,165,220,105,17,22,115,114,117,123,30,82,251,133,7,5,242,44,206,255,167,175,178,84,18,156,3,31,0,212,23,201,14,14,244,42,161,59,222,36,83,10,13,172,12,176,32,104,144,68,170,165,189,1,123,175,187,45,134,220,249,244,100,250,237,61,64,115,192,74,11,181,20,37,45,162,113,181,138,160,146,38,151,240,48,54,248,102,71,70,21,54,104,240,179,129,5,6,104,211,229,161,202,165,107,222,91,184,22,159,6,111,4,167,35,240,223,234,87,230,153,113,14,14,17,242,190,58,181,140,112,237,253,99,149,220,186,63,40,114,225,43,7,78,139,74,11,42,56,115,55,250,17,200,200,92,83,192,69,113,53,29,0,35,238,32,200,151,37,190,127,103,228,231,181,94,34,122,215,76,22,86,249,51,75,141,29,13,91,150,109,253,69,121,14,244,114,147,172,245,171,232,57,214,171,39,225,232,5,204,156,164,16,196,223,0,127,199,77,140,227,245,29,149,172,230,3,53,201,68,109,24,172,65,139,222,3,170,128,145,123,226,132,8,238,199,203,215,89,87,74,102,93,134,75,95,77,16,161,108,15,45,248,93,239,188,247,190,125,176,119,210,168,3,88,204,29,150,246,100,179,61,242,33,166,65,86,60,4,145,102,129,221,173,198,3,143,98,72,245,120,32,217,95,151,183,23,200,37,85,25,116,203,228,49,125,136,191,66,143,146,222,179,174,44,140,210,173,233,47,55,22,187,255,141,168,164,53,112,127,46,133,59,221,73,133,247,233,206,174,179,238,129,254,109,47,230,7,122,33,56,107,34,41,118,124,217,115,204,194,243,226,16,31,169,76,21,40,96,185,21,218,138,130,74,215,5,90,134,107,93,114,158,88,252,99,63,246,127,61,44,227,45,48,102,142,254,204,208,248,74,252,54,132,116,127,182,90,97,33,61,106,231,131,134,219,213,69,34,199,70,31,130,48,161,43,95,248,232,104,10,149,51,116,150,21,1,142,241,67,82,42,204,25,160,142,108,174,249,85,20,222,91,49,67,104,150,36,127,151,189,177,234,167,68,245,46,3,63,194,72,26,12,127,124,245,12,130,180,142,198,41,150,66,206,75,192,89,107,3,31,115,192,139,97,181,230,223,136,235,134,156,42,230,19,126,43,138,95,38,232,1,156,250,103,50,169,163,125,202,114,110,237,232,114,97,19,200,159,135,174,33,195,52,183,119,229,133,36,88,23,239,3,198,99,8,224,13,110,157,214,180,239,56,127,213,16,170,160,101,67,8,36,117,241,207,220,47,41,133,252,18,154,113,73,82,135,100,9,196,110,182,13,150,197,44,81,68,152,21,204,82,94,224,148,82,49,78,44,7,151,48,223,60,117,82,232,142,153,109,99,45,173,155,80,59,94,80,138,219,113,40,201,128,58,158,32,166,218,196,81,204,160,33,219,247,225,135,5,233,99,208,210,139,46,63,158,139,143,126,118,58,103,84,201,64,15,41,210,248,89,181,115,38,157,201,5,110,199,202,112,1,68,139,216,133,146,66,98,162,55,48,166,163,121,190,196,76,181,14,198,214,241,161,16,52,45,245,142,99,253,217,119,111,208,156,100,194,89,62,245,129,249,67,40,6,57,100,118,25,255,196,69,94,228,148,52,16,29,183,23,62,14,16,177,90,190,127,233,132,103,37,243,170,12,118,55,96,116,217,5,10,235,221,139,193,128,166,95,181,193,18,81,186,66,101,145,103,110,109,52,7,105,108,197,56,233,193,125,187,156,233,56,254,26,51,25,9,197,45,181,155,70,120,144,195,105,161,239,193,145,212,97,145,41,138,5,44,53,107,60,53,93,23,211,82,38,250,156,209,237,7,123,219,46,221,111,171,249,174,102,181,57,29,57,95,15,23,0,44,102,102,182,75,255,73,65,29,170,150,184,35,78,204,180,106,63,59,193,205,218,174,45,159,38,240,154,13,238,57,160,36,248,153,26,243,170,253,101,254,7,216,177,119,52,73,207,110,238,71,20,74,133,93,56,196,58,173,42,253,112,207,239,79,10,100,195,86,68,168,135,133,189,129,246,132,51,0,33,100,199,11,208,90,135,141,20,142,109,69,51,124,31,195,224,50,16,181,98,40,139,21,75,172,149,209,119,100,205,104,241,116,192,13,201,96,165,35,151,32,247,170,158,77,16,94,204,166,208,244,121,210,163,100,83,170,106,136,53,220,14,61,230,127,179,180,237,64,96,102,16,244,57,26,21,19,148,72,161,252,82,55,228,235,97,201,154,74,239,147,0,156,111,10,190,207,223,133,86,208,130,152,164,129,186,214,211,116,254,21,47,85,157,125,230,93,49,227,146,223,84,135,14,124,86,0,176,166,144,210,142,36,188,66,34,21,94,21,113,160,128,212,110,188,9,98,226,107,231,115,243,198,192,59,221,165,54,114,17,76,22,239,121,58,157,138,130,168,96,129,178,178,99,194,47,115,226,49,238,134,253,160,227,186,151,186,231,105,110,59,221,22,218,91,85,93,237,41,95,231,252,105,204,21,24,128,170,69,40,105,168,169,143,228,10,28,134,214,110,0,79,113,246,229,227,77,221,130,215,82,13,49,82,175,19,106,80,227,165,133,189,161,232,219,130,16,211,245,231,164,166,106,15,180,255,65,148,248,36,154,29,38,148,199,254,155,127,237,119,171,189,236,85,206,153,93,44,134,228,188,166,71,223,32,154,30,12,92,151,5,203,80,99,104,149,39,100,58,63,157,226,54,197,2,63,124,69,142,71,80,216,98,160,213,217,3,53,207,41,144,162,81,48,90,151,74,46,189,69,25,114,180,82,160,222,158,52,150,195,19,8,17,253,58,193,203,187,90,162,247,144,214,2,190,130,111,9,86,156,106,226,43,209,243,104,34,136,92,121,142,107,3,189,248,0,233,58,231,130,151,10,151,246,250,179,46,79,99,147,130,51,110,16,178,138,190,104,217,205,9,209,125,3,68,156,199,41,130,137,78,116,40,252,118,127,64,157,131,232,25,6,37,176,158,11,55,85,117,97,173,95,76,20,237,100,61,116,23,55,113,227,213,136,37,253,1,221,168,42,161,78,215,246,158,0,125,109,117,236,76,66,211,164,145,109,159,200,249,106,175,153,98,158,8,103,144,19,134,232,92,85,41,190,78,148,205,7,162,209,183,69,166,204,20,241,120,30,197,224,36,28,74,2,135,155,236,82,24,146,235,126,96,183,116,132,205,225,48,34,8,207,248,243,74,28,231,1,52,78,204,171,78,155,214,172,238,225,141,48,106,51,37,155,124,192,232,82,240,32,87,7,47,117,168,195,54,236,196,135,53,41,136,135,115,96,98,45,253,31,124,215,169,248,169,93,141,237,176,6,79,80,213,161,34,230,142,166,192,194,125,119,225,147,69,119,0,237,230,228,96,200,186,43,208,81,18,126,37,207,81,136,111,50,71,31,252,70,135,243,5,61,170,221,65,233,125,114,225,243,223,218,149,228,159,77,116,147,131,140,91,122,116,191,174,18,105,228,230,184,190,104,203,212,136,121,193,210,202,137,145,167,67,127,71,169,133,123,173,67,44,238,146,12,75,252,72,2,239,100,38,126,59,217,220,180,185,211,217,165,180,97,171,224,35,121,161,74,125,173,144,113,233,139,41,11,229,96,106,154,223,5,185,17,146,135,236,128,54,82,98,236,41,104,89,200,165,65,108,87,213,168,146,96,141,211,57,196,247,90,61,247,122,141,125,21,16,55,216,1,99,85,175,46,129,133,149,251,201,39,246,111,181,92,1,246,38,126,22,230,71,239,112,9,126,20,234,175,120,124,195,74,23,90,95,192,157,113,43,189,100,241,230,57,191,181,88,1,80,176,27,130,93,102,37,254,154,123,166,16,112,233,192,220,28,8,227,104,245,224,184,163,211,199,101,101,49,253,231,105,81,252,146,54,252,160,153,212,228,116,221,233,104,93,73,153,80,9,71,108,155,34,196,15,163,175,34,4,222,0,69,63,221,220,19,166,109,167,101,154,61,86,155,119,237,215,112,203,243,124,170,128,46,231,250,231,191,190,77,80,157,199,194,31,10,88,85,214,148,97,140,240,191,70,9,149,69,175,88,38,242,215,193,123,47,198,75,244,137,137,254,246,92,78,182,83,118,12,94,171,29,141,17,214,225,196,83,98,69,122,243,4,47,196,217,160,67,34,51,53,195,24,157,76,246,12,80,159,166,140,59,34,103,252,214,120,152,246,69,162,36,4,62,104,45,33,43,73,26,189,152,174,248,201,110,116,14,65,187,86,163,131,176,214,228,61,46,111,200,22,27,177,65,190,178,180,17,140,174,117,62,36,41,215,81,79,14,87,95,120,253,227,175,197,240,229,251,89,12,42,188,114,61,89,113,154,193,36,36,178,118,174,54,70,254,180,158,178,118,113,252,254,6,77,196,61,255,208,42,164,132,125,168,87,101,67,195,194,23,246,16,61,255,178,45,95,68,95,191,129,69,39,26,43,125,170,210,14,61,126,71,161,159,225,135,80,42,240,195,112,238,177,143,203,110,115,94,126,46,212,99,228,174,18,142,135,132,55,2,121,202,14,54,162,15,242,172,55,109,67,118,50,238,69,201,239,140,211,156,248,176,221,69,184,45,24,78,92,41,120,226,83,76,63,8,44,240,194,178,239,255,218,249,116,118,5,84,117,12,215,226,215,76,73,36,212,240,26,179,106,252,172,22,116,163,135,166,202,106,19,208,218,95,186,120,89,61,204,33,48,214,126,127,150,13,88,190,85,29,87,213,69,177,34,245,152,143,18,230,174,207,145,114,191,32,166,150,42,253,201,220,236,148,76,125,98,41,159,7,108,147,153,34,221,139,40,167,211,15,89,222,160,199,119,4,34,124,215,39,75,198,201,184,64,117,144,193,52,79,230,11,45,218,92,77,2,1,140,207,87,172,209,36,109,126,178,115,156,93,116,126,180,133,208,198,156,26,176,41,45,29,64,54,216,18,5,215,28,239,218,253,7,236,238,156,136,229,67,173,106,180,38,248,45,31,181,200,194,135,131,75,201,206,8,121,53,103,120,141,188,111,216,246,128,198,217,38,157,187,221,45,50,62,117,153,75,90,43,200,250,112,3,15,62,237,180,18,139,121,158,19,167,110,226,122,29,140,239,132,59,216,236,15,38,167,119,12,30,51,193,230,176,55,190,111,255,70,18,137,111,239,114,182,201,230,211,11,199,92,167,77,108,188,160,105,74,158,230,93,236,84,87,172,160,57,252,240,232,215,33,34,67,217,100,30,39,212,156,151,3,121,114,183,14,186,19,255,248,34,144,139,160,113,150,197,157,204,231,65,200,180,220,82,138,146,182,16,97,189,92,234,74,106,160,158,1,102,45,140,209,62,159,153,159,216,62,3,125,226,46,196,92,131,189,59,177,177,173,254,191,63,2,28,56,47,53,134,99,187,133,75,175,42,166,121,209,47,105,232,185,197,248,153,184,230,161,61,153,5,110,50,199,139,82,181,248,236,44,167,45,255,17,219,117,231,119,81,127,14,220,19,68,190,176,152,116,201,35,73,174,4,5,177,166,56,90,190,163,168,109,104,209,177,160,228,38,57,166,227,222,114,40,63,250,157,181,28,139,8,100,178,141,80,30,216,64,242,132,97,134,7,171,87,253,97,129,37,190,215,65,239,241,166,86,14,41,50,126,216,8,151,133,249,51,76,166,3,33,18,92,30,178,118,101,144,82,164,182,255,147,146,180,9,146,132,122,13,200,236,61,25,13,94,228,151,71,191,23,194,58,226,71,112,65,19,81,21,193,5,144,119,20,212,24,144,206,85,79,60,134,111,194,0,101,143,42,219,55,252,238,1,133,84,234,12,3,222,73,144,184,192,22,31,129,163,160,209,86,45,90,224,49,81,47,234,152,5,241,92,146,197,133,191,223,147,20,25,12,104,150,97,144,13,13,20,185,208,1,225,46,219,63,131,217,218,236,66,46,72,7,82,9,148,101,93,65,102,182,26,206,182,158,85,231,10,79,156,101,121,174,181,21,125,243,248,231,38,92,167,210,61,49,171,156,88,142,9,184,212,37,16,234,176,223,211,134,216,169,153,208,205,112,13,255,3,32,156,109,19,33,244,209,172,139,89,37,139,85,47,7,250,203,204,162,65,77,196,22,58,70,51,132,134,188,241,33,168,18,69,139,113,16,29,89,8,189,200,50,80,231,104,14,104,78,34,42,190,153,208,24,232,232,195,189,20,206,152,246,26,104,110,38,133,95,25,152,238,187,181,227,244,191,16,36,24,214,146,113,213,233,148,96,189,204,60,215,35,104,127,71,130,112,182,9,96,151,202,162,74,233,138,230,231,229,176,125,115,67,123,4,216,18,136,140,32,15,103,210,168,55,39,66,82,174,212,121,98,126,129,8,241,170,33,142,185,71,203,195,153,12,135,46,113,58,156,137,175,174,220,70,235,14,38,108,127,47,176,213,134,129,211,164,142,177,152,81,11,230,167,89,184,124,8,182,214,253,110,107,69,28,117,4,165,24,154,255,227,194,146,150,192,171,214,102,67,238,154,46,241,132,106,241,4,59,6,37,238,73,27,99,188,250,4,192,56,237,142,140,171,47,247,158,24,12,247,103,118,107,45,61,233,34,107,130,144,225,200,163,193,152,198,198,54,113,123,200,10,225,158,173,189,73,190,44,178,11,75,202,188,235,114,60,201,246,145,59,201,112,96,169,131,80,186,126,103,250,222,192,49,7,108,57,243,239,224,211,90,173,129,136,152,44,115,206,30,62,154,221,7,26,105,159,169,195,104,123,117,126,213,217,222,242,14,140,191,199,39,6,146,151,226,219,27,83,71,44,111,178,91,197,234,29,232,43,245,56,237,57,75,10,210,70,99,213,10,112,114,177,125,196,176,4,203,122,32,135,60,24,248,158,123,165,181,11,178,145,144,96,161,195,199,144,214,171,206,191,27,134,29,16,89,7,113,148,167,143,81,154,156,62,250,66,44,14,202,93,157,107,119,37,90,165,116,160,26,169,255,159,84,29,220,237,75,177,51,245,244,46,249,3,115,75,189,201,114,63,48,185,157,205,86,201,164,23,76,80,249,43,26,118,55,230,181,90,93,6,63,55,131,69,35,49,83,74,79,161,185,140,110,174,206,158,149,198,184,116,56,1,252,39,144,122,38,236,170,181,158,233,40,25,98,49,127,90,7,175,196,174,245,152,225,96,250,223,178,107,208,80,79,99,136,58,52,24,89,219,213,141,116,81,143,17,135,200,29,193,237,215,6,233,103,16,173,152,65,193,88,75,32,250,143,37,61,55,120,48,164,64,56,63,243,66,139,89,36,26,233,145,60,145,110,241,205,77,58,108,90,123,145,39,86,189,139,150,96,232,222,183,182,250,212,202,191,60,69,49,237,30,68,79,80,158,139,68,53,66,181,7,254,51,240,167,234,253,10,108,123,237,59,25,134,126,164,151,166,164,28,221,100,162,203,62,172,7,162,193,198,83,24,100,29,2,51,83,62,210,21,232,207,64,56,59,239,61,112,222,178,122,5,94,158,90,83,195,17,246,167,233,40,147,55,69,123,143,147,94,206,212,50,161,110,42,219,54,95,96,225,77,71,210,147,206,32,255,56,51,36,231,1,114,237,218,10,170,92,55,197,79,120,174,158,243,103,131,44,42,110,16,52,143,153,96,13,220,14,248,80,203,181,62,224,251,49,51,149,82,220,98,33,69,234,218,6,225,101,112,135,204,183,245,199,119,129,63,67,196,81,19,50,197,178,135,191,8,81,132,127,45,75,27,124,249,212,201,121,166,36,226,192,227,20,248,83,114,76,69,74,206,57,4,173,247,241,118,225,145,104,230,187,80,13,214,118,251,113,72,83,250,127,115,171,56,45,45,223,14,253,249,195,111,74,82,43,247,42,15,126,79,218,139,160,28,192,11,100,220,39,8,108,61,129,208,166,157,122,81,29,164,231,123,167,35,10,176,121,3,113,228,225,234,57,12,61,252,23,56,150,105,199,229,184,206,147,160,217,134,159,219,253,203,216,48,41,30,230,160,49,105,34,117,21,215,65,56,101,18,65,190,95,191,77,88,205,180,192,237,211,137,130,143,57,196,188,90,244,119,211,16,246,239,139,170,103,125,90,199,10,228,68,201,38,145,5,94,199,128,87,19,103,237,146,199,136,200,210,100,215,46,23,157,244,103,168,247,125,100,105,117,144,159,158,88,180,174,201,140,57,229,241,231,87,32,134,86,197,91,111,112,23,183,7,160,118,50,194,172,24,34,107,13,162,136,59,56,253,43,24,159,127,99,234,49,102,214,193,214,199,208,46,178,243,131,49,198,133,71,233,26,206,156,215,109,175,176,246,184,95,83,151,28,75,115,31,138,156,30,41,82,202,28,153,63,16,157,132,163,106,56,42,194,132,219,153,248,157,85,153,179,217,137,99,35,126,241,6,82,34,196,48,128,37,17,157,250,245,214,177,202,185,250,91,46,59,135,117,160,122,39,108,170,40,89,178,157,43,254,171,106,74,128,162,113,202,26,54,194,156,206,36,122,159,244,30,100,109,196,250,181,101,82,7,7,238,8,105,246,246,234,200,192,71,16,141,195,0,184,126,75,26,196,9,61,77,105,202,150,183,129,86,238,132,185,12,104,28,185,27,7,162,233,142,207,40,93,128,204,216,11,25,35,154,246,105,222,30,53,126,156,224,179,139,93,93,105,102,227,20,139,81,239,239,57,125,174,174,21,153,220,9,14,39,61,195,213,53,254,68,74,19,118,97,9,222,211,213,153,211,208,210,94,4,160,140,230,72,221,222,42,171,33,27,177,67,121,24,43,150,169,148,219,120,231,98,131,74,10,235,45,122,133,58,24,204,244,65,16,89,94,91,202,78,95,83,184,187,241,247,240,32,239,252,78,149,125,104,167,254,148,27,140,82,7,187,223,114,52,195,144,107,118,45,17,137,124,50,220,220,144,88,106,53,251,63,175,63,127,73,251,210,180,60,25,176,158,196,156,48,24,10,200,231,79,188,224,136,12,147,148,69,26,193,215,117,135,218,96,50,134,140,69,200,58,83,146,174,1,139,24,148,120,222,90,193,121,94,210,125,35,93,51,29,222,17,82,191,132,242,238,186,119,189,74,104,81,39,193,184,252,208,154,41,43,174,135,17,168,15,6,83,183,81,84,104,127,43,153,149,144,122,39,148,6,116,234,25,47,36,62,48,234,23,40,219,26,129,242,60,117,103,82,91,126,230,127,85,203,194,31,238,234,150,219,146,165,221,157,163,94,4,225,3,10,43,111,198,13,65,83,157,233,9,233,219,134,173,21,253,72,68,71,63,17,43,23,179,12,199,201,18,173,146,145,57,137,103,155,182,154,95,195,22,237,161,178,87,216,186,220,187,214,241,106,193,245,175,62,124,156,45,246,131,246,244,93,1,252,233,236,133,51,33,246,7,98,78,195,176,237,86,62,145,29,248,46,114,191,239,214,91,182,97,80,225,62,17,25,117,51,87,197,48,159,102,130,27,246,57,255,106,73,166,203,145,116,250,159,190,183,223,120,168,27,216,119,236,66,69,188,102,138,158,238,107,164,77,115,144,50,199,189,130,253,189,233,134,253,221,42,191,17,158,9,74,164,0,92,113,210,64,244,254,7,0,230,237,58,248,111,128,217,45,49,98,73,16,58,253,115,176,41,232,179,117,33,52,66,197,204,126,148,48,141,214,163,68,228,188,50,147,212,69,40,36,92,20,80,158,72,109,138,76,107,209,189,84,189,197,234,209,133,127,104,135,60,32,185,86,52,109,33,220,77,127,216,172,24,15,167,248,131,200,220,112,154,212,142,8,5,4,11,234,144,174,197,231,48,137,187,11,212,255,22,92,32,138,24,40,188,65,175,147,41,146,108,101,34,100,240,196,159,54,16,209,30,165,76,242,42,197,90,170,251,53,58,84,105,71,235,187,6,235,140,2,28,121,124,73,207,181,110,251,115,240,196,195,127,136,35,172,211,12,199,108,218,8,154,249,132,233,84,130,101,217,90,123,124,87,252,41,31,42,73,36,182,214,253,53,84,129,15,130,240,173,123,171,249,3,121,222,86,123,223,125,8,152,149,211,240,225,198,153,82,225,126,10,100,182,53,198,124,196,141,40,164,14,53,70,97,144,144,235,128,205,123,22,62,244,10,142,95,160,173,88,132,182,45,121,184,237,102,140,250,77,188,189,136,99,249,207,29,115,245,84,65,165,96,39,215,149,61,237,34,91,27,67,98,170,154,213,167,193,207,15,138,239,114,191,46,91,77,3,61,122,202,69,60,61,133,29,149,160,2,69,189,169,156,74,113,56,95,17,28,127,46,129,197,189,152,164,53,240,26,165,93,39,139,171,140,93,247,40,10,19,60,62,11,59,77,7,252,138,72,112,59,203,133,177,251,57,156,190,113,36,97,218,32,237,47,54,146,248,254,174,31,110,13,32,34,14,109,44,68,252,102,96,85,31,255,147,212,21,6,214,223,4,39,206,221,108,223,67,95,56,205,251,73,174,57,216,168,193,29,254,131,62,198,189,116,150,123,88,71,219,104,40,246,116,231,237,183,178,147,243,162,106,120,21,106,134,184,56,6,141,248,141,18,24,106,34,158,59,6,31,51,88,109,180,99,86,67,201,206,90,226,95,242,104,208,158,176,70,43,149,239,210,68,104,19,253,83,43,148,21,98,83,216,33,188,226,179,124,55,202,87,157,16,60,238,195,6,133,24,72,70,218,16,74,108,112,129,204,152,186,67,179,199,181,86,233,78,171,189,143,11,255,26,7,104,63,202,196,126,254,145,40,201,157,104,169,209,203,82,215,41,75,188,200,29,4,170,88,191,35,12,179,51,183,45,229,67,237,100,89,177,59,249,64,3,153,54,28,168,212,92,23,163,222,155,156,17,159,112,138,26,40,206,32,236,11,41,239,82,252,58,205,16,201,253,27,128,13,64,133,78,70,254,211,139,135,39,205,171,52,197,42,243,34,134,72,21,197,77,127,24,156,239,125,123,65,155,234,53,69,252,248,147,1,95,140,112,219,234,177,54,176,230,76,247,23,230,149,113,77,192,41,108,172,64,33,220,139,166,66,79,24,116,195,37,94,95,246,77,106,112,126,0,128,99,52,144,197,84,209,68,188,179,10,13,218,168,251,219,173,46,181,230,57,221,34,186,64,83,210,16,126,40,251,12,232,88,169,36,111,253,103,132,109,44,52,99,191,34,42,244,243,117,253,59,244,14,193,52,185,190,99,70,94,117,133,244,135,32,2,243,188,181,18,241,199,31,218,116,232,45,44,1,123,251,191,234,120,99,75,181,116,89,81,82,105,223,88,76,129,175,63,133,211,241,108,231,80,0,134,255,25,163,145,205,61,185,36,213,122,248,20,92,213,207,252,22,155,70,223,196,111,227,201,136,90,163,76,111,32,193,170,218,172,59,32,151,205,93,245,74,236,84,240,163,215,48,86,98,228,128,196,158,67,114,209,202,62,190,97,48,243,17,51,84,119,68,240,49,133,132,76,198,51,142,27,223,182,57,93,52,107,5,205,112,65,13,32,231,198,44,70,84,230,193,122,10,223,178,7,141,145,200,108,232,120,236,7,242,141,124,145,229,40,132,211,179,29,25,182,76,217,72,176,71,220,101,202,16,96,2,18,47,141,205,61,122,4,225,208,117,74,27,102,120,216,176,49,14,196,86,36,186,50,94,234,66,120,14,35,8,162,249,77,243,164,156,225,93,198,3,124,64,46,165,13,121,24,188,253,185,190,221,114,200,161,145,43,142,217,226,142,177,120,12,188,129,64,157,138,14,50,204,58,35,102,3,57,61,141,74,217,122,147,108,209,212,126,31,38,222,65,255,10,69,252,60,153,177,20,195,75,232,18,244,72,85,183,59,204,165,204,65,48,232,107,189,44,102,19,112,77,29,244,70,19,142,184,139,12,160,174,151,103,36,36,188,109,124,87,102,129,67,172,121,77,218,31,191,50,204,253,131,181,151,219,15,198,240,39,54,51,213,172,163,86,193,231,10,136,33,22,136,27,176,76,117,229,134,135,94,139,249,54,132,239,14,154,149,140,46,112,112,30,149,55,14,130,100,115,154,92,8,70,212,103,117,186,100,242,70,246,207,8,249,55,228,129,230,84,6,63,82,164,148,1,173,221,73,9,55,14,51,243,161,185,10,207,100,79,73,118,145,64,224,181,134,98,191,200,225,213,149,249,111,176,15,110,7,124,102,202,219,129,55,237,52,43,182,37,65,181,162,163,220,134,44,183,185,57,100,51,50,23,218,111,112,45,159,87,42,244,160,193,164,133,209,38,169,90,170,184,149,228,21,20,2,222,153,63,183,10,69,9,139,197,194,198,55,130,10,150,33,124,181,186,37,56,247,220,130,185,41,119,182,194,47,25,177,37,141,124,8,118,204,14,111,235,55,66,111,64,125,144,12,195,188,123,166,189,193,36,206,176,114,195,127,47,117,170,40,202,249,76,124,208,103,97,52,150,68,50,122,38,32,210,212,86,182,212,214,114,212,56,66,227,9,111,2,0,12,66,140,48,96,240,240,224,71,76,208,161,231,114,112,191,243,146,52,14,66,6,171,144,17,243,234,144,184,227,68,184,79,29,255,120,249,118,254,91,140,244,179,82,34,218,50,226,33,231,124,137,167,182,27,207,84,22,170,234,68,172,175,79,187,73,39,75,244,191,34,69,87,143,93,105,81,247,136,208,67,69,111,253,128,112,253,145,238,135,157,0,176,171,140,128,188,91,44,127,198,62,154,105,222,197,104,142,13,190,120,90,162,69,97,77,177,178,173,11,206,129,154,149,18,99,103,146,230,56,147,206,118,243,151,45,17,167,91,28,218,191,95,211,12,220,152,135,213,166,51,168,58,121,186,79,29,133,98,29,202,231,83,145,70,186,185,244,5,85,58,94,252,227,229,69,34,175,161,59,109,41,210,1,111,43,40,142,107,78,21,114,70,156,104,178,236,210,193,240,12,88,162,118,191,172,178,19,126,99,243,97,115,3,48,89,160,218,107,158,145,251,46,249,255,99,93,85,90,0,228,43,77,14,231,114,57,213,177,141,252,53,21,205,149,151,39,240,36,11,66,82,28,186,12,181,217,142,142,207,51,108,95,103,45,159,174,11,102,239,253,49,249,105,225,230,246,52,104,1,113,95,74,81,241,225,139,204,65,146,65,58,122,120,197,83,50,187,129,225,217,207,56,83,159,68,175,160,98,168,248,159,124,48,9,88,75,153,15,240,239,95,241,247,39,9,80,189,145,133,181,38,19,185,182,196,73,251,8,167,182,83,101,122,116,155,244,20,208,21,139,174,46,7,255,253,9,128,154,34,20,144,215,30,186,15,204,208,4,168,21,180,15,205,149,154,143,203,246,60,140,171,145,245,161,35,71,224,231,139,57,94,253,90,163,15,100,226,248,7,112,29,41,38,182,105,134,201,8,141,164,61,192,103,113,93,102,169,151,135,161,121,192,160,168,95,238,5,142,20,171,61,71,30,11,208,193,158,133,4,193,157,166,255,235,204,202,158,86,135,89,10,63,94,7,153,36,73,100,250,74,147,175,159,251,204,145,81,46,27,57,21,75,238,238,46,133,245,7,42,236,192,19,169,123,127,28,200,17,141,119,40,192,178,163,50,100,33,106,232,103,76,75,188,173,87,130,2,15,64,63,16,40,72,27,171,172,20,177,193,248,241,117,244,127,44,121,12,128,246,5,81,173,243,174,151,3,86,45,176,141,85,221,46,124,163,189,172,74,121,239,187,35,133,255,225,172,248,180,175,213,82,107,107,221,45,174,13,90,250,179,20,193,253,26,254,227,37,88,116,183,77,150,49,223,127,190,190,65,253,66,19,13,254,29,77,237,128,60,113,120,157,129,46,191,15,97,248,38,60,126,178,253,127,198,204,139,65,160,87,104,158,212,188,121,131,178,230,128,232,161,78,179,184,61,39,161,181,59,241,58,72,219,200,16,13,241,153,119,194,210,165,32,73,111,2,41,91,146,112,196,202,145,127,43,5,19,45,67,175,222,99,229,141,91,255,112,150,98,184,76,200,47,41,38,77,103,252,40,69,167,209,95,207,238,7,171,234,234,183,154,69,198,236,170,126,119,251,195,11,140,67,142,70,207,30,86,74,3,0,70,58,41,153,154,44,205,116,129,218,165,85,118,139,83,222,186,193,90,198,220,188,212,65,196,93,145,142,56,197,244,124,15,194,160,56,150,144,238,251,208,109,57,249,0,150,51,101,243,225,90,128,224,124,63,94,80,244,196,43,33,182,183,127,179,40,22,179,7,93,74,188,253,218,121,102,17,137,101,81,50,22,69,224,0,63,41,216,184,122,235,116,209,135,169,199,57,181,140,39,155,0,222,27,215,241,202,114,103,174,153,214,139,43,154,242,119,84,9,95,105,23,33,219,245,243,179,232,97,219,46,108,140,161,22,217,215,129,91,173,162,222,251,111,237,9,76,48,200,110,102,78,24,144,189,196,65,0,40,236,243,9,165,13,140,85,161,0,217,45,75,192,63,82,218,89,170,213,147,138,133,255,112,173,16,190,107,74,83,174,192,52,34,149,246,185,49,38,9,174,94,249,135,11,51,176,52,222,246,217,8,174,118,174,80,92,17,143,171,64,68,129,155,93,230,105,76,22,14,29,250,217,165,60,29,253,243,87,83,35,44,136,149,52,55,135,214,221,86,170,214,21,67,61,63,47,199,159,230,162,245,74,243,197,185,120,145,241,32,45,149,108,219,230,218,76,126,240,233,7,251,21,159,127,49,186,247,230,143,245,72,155,188,250,16,94,155,1,160,254,216,49,219,169,121,198,12,108,236,156,170,29,140,112,12,217,190,94,39,44,82,254,140,210,215,232,37,66,236,50,40,129,102,10,105,212,134,165,82,202,0,170,217,12,163,21,145,248,200,201,154,64,104,10,28,171,30,40,93,76,203,173,134,48,215,126,61,241,174,212,0,217,189,244,7,164,138,59,239,22,36,53,28,27,55,162,210,63,227,199,201,241,246,211,29,209,124,1,86,206,118,143,168,0,6,237,62,116,1,126,230,112,237,44,5,242,65,19,22,127,126,77,255,253,214,80,209,54,207,218,52,101,21,194,203,183,138,116,249,121,65,68,15,115,156,43,116,69,190,179,201,234,96,31,202,95,6,60,112,6,181,86,195,133,252,52,234,170,141,26,182,104,171,197,151,212,248,226,80,237,130,228,235,18,134,138,137,176,19,175,62,237,208,124,239,152,172,197,202,59,31,32,105,186,198,146,13,112,213,208,109,98,221,35,115,166,109,107,246,108,26,131,136,208,6,57,124,189,14,23,186,95,149,77,37,26,128,189,78,48,39,191,85,67,112,193,143,149,216,178,128,129,16,232,234,157,69,96,195,1,203,82,126,13,226,47,174,215,176,46,158,156,189,67,43,162,231,214,105,162,5,189,156,121,188,45,19,81,88,148,54,220,58,29,129,217,170,98,80,116,123,154,227,125,136,33,53,176,190,243,122,101,30,73,162,46,238,13,222,240,153,158,114,107,237,171,125,184,201,14,224,46,112,15,146,77,57,142,211,46,48,46,126,204,143,193,227,65,177,134,109,61,119,59,1,180,164,2,44,245,240,212,17,225,192,117,191,10,105,191,1,35,173,90,73,97,203,35,75,66,193,164,164,206,120,106,188,57,77,106,159,80,36,106,82,160,21,242,138,255,42,55,32,48,186,13,135,124,227,151,113,162,209,30,25,38,102,243,185,252,8,239,88,185,33,212,215,11,174,8,66,113,108,167,87,225,196,253,157,84,209,99,227,153,215,88,170,45,67,59,74,228,147,40,107,114,177,131,12,90,243,93,61,20,3,38,136,216,107,23,74,174,178,138,197,87,190,65,216,154,210,107,217,246,58,139,176,18,91,202,155,32,46,21,19,120,158,245,117,144,45,241,146,208,249,100,229,145,101,152,2,176,47,227,217,213,31,49,214,79,49,209,126,103,193,130,236,129,238,99,107,68,84,117,208,2,79,18,224,186,164,0,125,217,138,168,97,75,237,110,230,82,39,234,25,40,33,225,120,118,148,114,3,186,165,53,139,37,69,67,92,165,125,74,17,134,126,132,194,103,180,153,205,40,9,206,166,151,54,185,71,208,243,47,64,234,104,79,255,233,18,191,139,153,149,170,35,32,70,194,150,64,212,108,17,195,150,141,113,43,85,249,79,112,132,33,252,49,195,242,232,168,104,93,137,144,224,39,174,108,254,136,89,36,116,102,102,247,204,208,51,92,231,202,19,140,176,159,165,108,162,92,50,5,243,165,228,198,224,140,218,204,194,6,138,126,98,23,230,104,181,25,98,23,232,103,101,136,164,94,182,53,123,70,29,115,14,120,36,116,208,200,164,196,245,89,81,189,229,168,72,8,163,146,162,147,36,252,25,115,60,237,21,50,39,159,104,243,14,235,226,197,114,16,183,6,167,157,25,117,63,27,61,21,120,189,181,193,221,134,188,94,246,41,40,9,242,43,123,120,36,2,90,165,91,218,25,47,78,104,167,82,51,4,248,99,148,200,101,0,97,6,100,69,198,254,195,169,12,176,69,241,206,25,11,14,214,132,204,111,165,232,32,194,80,79,128,232,165,82,55,16,65,19,12,19,47,228,89,35,37,236,40,160,133,10,69,115,34,118,124,166,121,13,180,42,153,21,196,196,59,203,23,117,206,162,64,142,189,138,211,72,189,80,183,122,86,91,140,153,114,83,240,36,25,56,248,33,238,56,203,243,202,114,151,251,78,213,14,14,59,155,193,116,250,84,74,178,155,55,114,175,109,111,193,252,5,4,242,73,64,68,155,111,29,206,46,237,223,81,31,237,85,61,201,211,113,107,161,203,215,88,159,80,136,23,133,7,118,242,246,25,230,161,154,46,144,113,33,157,178,139,62,249,0,240,18,175,3,153,238,110,197,47,121,165,235,54,193,177,141,208,226,109,80,244,81,88,156,155,171,226,215,123,92,71,16,251,103,56,190,208,53,118,55,208,219,132,29,41,60,102,251,160,89,251,16,138,105,54,15,119,10,130,109,75,212,205,222,10,135,170,61,180,61,147,21,209,158,77,103,236,245,196,79,91,73,191,154,145,152,15,39,29,134,129,216,64,228,181,6,206,96,137,169,118,101,89,1,79,241,236,121,0,214,19,204,137,169,69,28,193,88,175,247,75,77,151,97,137,165,42,85,47,35,158,218,68,197,96,171,151,224,199,233,26,71,67,127,97,230,9,124,238,240,165,205,159,92,65,152,225,143,53,94,119,164,159,35,43,54,93,155,75,109,79,24,19,168,181,6,180,207,105,157,61,119,251,160,255,224,18,115,95,95,185,220,145,82,38,223,219,186,203,69,228,142,179,53,225,54,37,139,176,15,157,165,20,64,78,214,53,188,64,234,23,212,11,22,140,245,249,51,216,30,165,36,228,35,181,226,106,84,196,195,196,141,45,92,138,128,0,24,94,116,158,35,16,31,99,78,19,53,122,10,117,130,151,8,158,12,76,248,53,107,73,193,119,126,78,15,60,238,46,86,245,226,9,192,128,106,253,139,76,142,200,110,18,53,222,220,169,98,193,169,199,215,21,158,240,164,46,195,249,15,228,145,237,240,159,208,95,207,115,74,25,152,222,233,1,165,240,61,16,8,62,151,170,15,80,165,230,62,161,94,108,203,21,7,139,67,106,239,155,44,244,40,31,117,67,79,101,84,115,179,208,103,203,123,199,193,33,52,26,158,49,134,122,52,158,46,226,230,155,222,236,12,176,140,90,203,40,107,114,67,219,194,8,123,121,90,210,243,33,95,216,54,166,5,191,37,119,149,129,129,190,214,210,75,130,89,1,34,224,10,31,252,136,193,228,86,49,68,124,5,80,246,96,221,118,212,245,166,131,69,160,128,142,4,209,45,10,140,142,7,71,123,5,70,159,55,21,146,228,108,198,112,202,192,232,34,193,140,81,227,14,166,98,45,97,36,248,26,167,120,194,121,159,78,190,67,167,145,161,213,62,249,26,233,64,194,51,159,179,136,212,200,223,155,0,1,158,123,74,79,226,19,167,192,71,51,173,19,201,164,160,0,72,169,49,242,161,12,119,59,92,2,140,107,207,251,159,234,28,25,241,237,142,20,230,85,23,247,237,60,21,205,24,98,194,227,11,155,224,55,64,112,110,6,37,232,74,56,45,151,163,139,115,69,177,161,182,206,84,150,202,198,223,58,28,97,13,87,101,182,99,103,42,219,250,189,138,191,199,21,167,145,92,46,60,10,34,166,138,32,215,36,224,71,112,48,95,184,157,90,223,204,153,52,210,146,142,235,31,55,22,124,55,24,252,28,127,104,235,47,66,178,218,66,197,31,56,140,192,111,71,2,30,238,145,132,111,45,87,225,252,78,65,102,14,202,78,76,56,178,169,185,28,141,24,170,219,209,18,216,153,45,232,220,114,123,65,46,35,32,146,28,50,211,211,61,177,150,63,163,164,129,60,95,127,116,240,89,103,54,54,33,232,228,110,8,247,135,13,61,63,11,200,9,141,127,6,91,64,252,198,168,46,92,129,108,13,14,218,89,95,251,74,230,77,84,29,90,0,128,190,107,205,120,239,60,217,131,71,107,44,196,192,161,154,146,162,53,226,136,183,15,117,88,119,250,223,16,41,18,11,201,247,67,150,207,254,49,38,70,74,14,36,33,67,91,143,249,146,46,25,103,172,190,111,115,57,159,77,250,217,54,167,178,190,75,8,165,25,44,143,3,220,20,124,17,109,71,248,233,244,158,241,118,173,164,68,192,178,50,94,245,236,0,82,153,38,200,186,120,103,146,241,98,208,171,60,144,230,172,191,246,149,65,14,78,152,195,84,1,31,125,138,140,230,193,17,244,137,241,17,237,46,146,133,114,76,115,77,182,179,208,59,168,36,80,210,207,221,30,212,149,36,246,79,192,188,67,179,255,73,147,151,10,175,246,146,27,110,42,85,78,61,8,157,163,39,121,28,6,179,57,198,96,185,104,232,145,179,161,14,6,57,163,122,92,36,107,75,44,75,32,148,57,191,199,156,67,134,116,203,123,5,164,253,222,29,110,216,159,96,58,138,41,73,225,81,126,212,149,129,235,182,36,136,164,23,42,204,33,198,161,162,91,146,164,105,45,124,182,221,17,49,84,233,102,157,227,4,109,170,32,62,79,62,122,48,171,105,103,105,195,154,176,67,143,246,76,47,96,32,235,184,192,13,52,171,33,42,90,177,125,119,160,212,172,252,95,14,209,77,137,109,237,142,8,22,138,177,94,15,127,229,251,21,108,162,239,251,214,32,175,176,213,25,72,147,54,230,82,161,187,61,143,60,243,220,158,14,94,130,184,22,41,109,78,75,193,23,19,165,177,119,163,139,117,247,43,32,129,237,53,191,60,161,20,227,34,32,129,28,92,104,101,206,213,38,105,36,206,0,194,75,25,72,139,202,248,227,236,140,254,236,153,67,14,123,174,132,63,29,232,12,155,10,211,215,145,13,24,201,97,255,114,41,183,54,25,164,47,90,10,91,65,143,106,217,176,193,53,104,3,240,147,46,150,129,74,132,47,243,49,64,37,5,139,206,123,83,98,217,22,213,58,245,250,31,241,2,182,170,140,190,100,124,39,31,226,19,168,27,154,129,42,29,46,129,126,46,248,243,154,198,64,23,102,136,129,241,20,122,64,199,83,168,47,199,90,136,187,2,238,245,222,255,171,110,53,190,99,182,120,26,83,49,31,166,178,78,247,74,136,254,107,127,73,221,45,178,226,146,230,11,184,78,114,60,196,193,59,227,101,194,191,130,179,11,184,194,185,146,88,126,139,233,114,222,55,106,109,229,105,50,208,108,158,188,238,75,34,122,95,19,90,165,46,17,106,5,136,248,28,17,109,169,60,143,10,138,90,164,99,33,234,218,117,102,188,103,63,244,124,90,73,241,100,232,183,182,137,142,128,23,96,194,85,213,138,30,252,210,217,78,236,70,7,204,191,113,20,23,177,59,15,251,209,61,39,190,119,7,234,113,30,188,253,172,221,200,78,171,113,14,228,96,255,78,192,138,172,235,174,41,151,220,123,163,48,226,34,95,7,116,59,41,140,84,184,57,69,49,184,182,112,15,137,234,205,115,93,10,121,83,48,168,138,4,46,94,171,233,243,152,46,55,201,134,243,163,113,74,229,143,160,103,69,31,29,60,168,89,24,16,63,112,130,141,161,191,143,212,143,183,196,189,56,233,80,83,29,4,52,30,82,249,128,232,186,100,178,31,208,205,111,81,254,237,235,73,11,3,16,169,160,67,102,228,147,212,59,20,118,124,147,90,184,154,69,186,142,12,122,17,167,85,134,233,76,199,93,235,245,61,120,198,166,166,238,249,125,175,140,89,188,234,122,1,49,77,34,7,79,85,65,30,204,98,131,210,250,179,184,90,130,102,85,80,148,76,50,215,64,211,151,250,187,148,64,165,93,240,75,219,40,31,144,151,81,117,197,109,95,249,104,69,251,134,118,109,132,187,223,21,109,97,178,199,136,127,123,221,109,10,229,179,87,73,146,78,66,188,97,4,40,141,161,67,138,233,230,25,72,11,44,181,25,78,150,220,90,176,230,25,210,43,63,67,63,34,164,240,100,179,62,44,253,81,32,166,208,210,210,145,241,2,194,83,84,99,195,25,98,248,240,18,39,135,40,180,25,150,226,175,128,217,116,220,43,153,108,1,74,117,38,88,67,40,12,243,99,165,131,207,65,60,51,185,249,157,35,79,55,255,175,222,10,77,139,58,161,183,196,106,228,182,195,212,124,120,157,182,19,163,163,90,48,10,197,25,205,64,68,241,3,161,63,202,242,60,189,108,176,41,153,71,78,42,8,15,232,154,236,185,102,142,255,165,43,70,54,45,8,58,165,136,13,132,21,190,63,237,26,105,73,77,147,165,236,1,118,67,61,117,179,232,89,206,62,48,163,190,91,100,132,220,191,173,68,29,229,197,115,48,113,200,195,154,97,180,14,251,223,90,102,69,249,16,198,102,80,220,24,241,134,25,66,113,218,7,251,66,134,154,65,195,136,225,129,143,5,12,185,130,3,226,213,16,1,110,8,73,111,149,214,62,254,150,53,238,26,213,191,206,113,20,91,217,248,87,194,79,102,197,222,13,201,183,7,82,216,209,63,129,31,207,22,159,146,47,110,233,114,63,118,125,108,171,13,181,231,98,17,85,156,197,174,209,212,60,184,164,177,98,39,212,83,248,157,62,86,89,151,170,200,74,145,242,105,37,43,7,154,38,134,30,143,27,146,29,218,151,110,42,37,216,246,196,103,91,40,222,115,187,223,161,236,133,93,132,254,62,132,14,189,57,165,33,203,64,206,221,135,125,29,229,21,50,17,36,62,135,51,143,15,27,111,96,249,23,235,95,206,95,182,243,244,184,203,28,236,62,231,218,12,58,46,134,227,191,34,67,4,250,234,248,165,247,226,149,18,188,79,19,6,194,91,98,237,198,253,86,243,227,177,138,238,48,6,154,35,109,96,60,195,239,118,234,26,130,20,42,162,187,233,83,35,99,180,166,173,65,1,28,18,171,142,25,113,238,129,127,159,65,45,179,26,201,98,55,55,11,149,123,120,152,17,232,239,201,128,159,235,29,46,238,91,190,252,114,210,206,56,122,10,181,118,176,140,7,167,75,147,15,12,64,41,249,155,90,193,28,67,255,138,83,140,234,182,181,155,153,41,252,217,200,113,108,220,215,117,19,18,152,236,15,34,121,3,134,84,18,123,17,137,188,105,73,138,107,199,69,54,157,227,136,30,149,128,243,86,59,171,30,193,145,29,7,245,114,130,57,125,157,180,178,208,2,111,229,44,109,54,105,132,87,194,28,35,233,108,165,191,230,246,180,166,141,211,65,20,222,90,14,125,80,93,68,211,89,241,253,197,184,26,218,50,37,51,143,62,215,162,14,85,81,100,160,155,84,135,135,235,231,221,96,198,199,250,159,118,88,35,245,1,65,57,101,98,9,217,158,66,38,156,148,254,156,207,19,234,159,204,47,74,208,20,78,229,211,58,186,42,37,130,72,175,89,218,96,202,246,73,127,220,41,127,124,19,87,26,24,106,153,237,181,206,157,51,249,128,136,69,221,11,56,43,80,210,115,44,123,131,180,167,230,57,52,131,60,193,158,111,102,30,165,249,215,123,0,50,38,37,1,18,254,244,26,185,187,243,94,59,32,182,111,3,110,171,174,151,187,73,64,210,7,30,72,229,98,101,18,203,152,198,165,31,20,30,179,85,110,41,28,183,225,203,232,179,110,160,253,241,242,97,247,8,57,216,73,106,7,86,135,131,164,244,174,34,210,39,99,158,204,108,167,109,251,164,179,92,52,63,75,6,172,151,216,234,217,236,173,247,94,211,205,52,160,216,115,17,103,45,154,149,124,144,204,73,34,161,149,121,130,4,169,189,88,48,52,180,54,58,12,141,209,157,86,82,117,130,67,238,175,72,216,45,249,118,251,162,23,8,36,150,69,133,102,87,118,167,112,82,62,115,190,1,198,200,81,136,136,23,86,250,131,155,93,3,51,211,238,126,216,76,53,252,151,64,16,204,42,112,81,189,244,249,197,16,25,91,148,237,187,6,99,5,197,48,16,213,93,193,236,182,116,3,91,108,38,242,22,53,80,212,224,238,39,28,142,157,89,66,254,99,142,23,148,194,160,31,203,34,0,153,156,122,238,162,181,24,176,36,194,29,104,64,78,186,22,43,127,139,17,213,33,31,166,72,22,27,132,210,61,240,149,143,195,169,208,18,132,230,241,7,71,227,32,93,16,82,71,210,53,194,171,50,163,146,42,167,218,96,110,242,64,126,196,222,56,90,233,142,192,100,102,230,254,252,25,154,231,179,135,192,75,109,154,165,140,90,162,159,163,43,40,47,122,68,155,65,211,185,195,226,82,185,199,165,168,95,100,129,225,75,122,184,109,159,199,60,202,164,132,121,102,46,140,251,76,242,143,182,253,26,113,27,33,137,109,206,187,188,150,63,150,74,99,161,132,204,23,142,109,98,238,227,75,68,7,77,215,152,174,206,58,249,173,126,101,16,68,113,83,45,95,219,227,231,132,172,175,93,7,64,19,246,30,97,225,128,229,100,141,17,194,228,109,104,233,23,192,211,0,71,35,52,111,168,35,76,240,169,164,161,206,76,101,41,48,234,69,93,46,195,158,143,165,135,193,102,181,171,91,148,101,151,65,0,199,129,189,122,239,68,51,222,14,8,173,247,149,237,235,130,99,234,14,198,179,189,130,234,232,213,90,253,52,202,24,111,32,94,175,190,164,203,196,125,203,214,108,17,56,68,77,114,86,33,173,238,72,107,129,219,203,140,39,117,12,140,223,202,129,210,4,249,34,106,189,247,50,209,183,162,120,43,142,75,134,97,11,73,237,70,65,172,106,182,70,244,51,172,14,43,161,34,159,161,136,254,171,8,150,189,31,37,119,232,58,108,87,194,121,163,223,187,91,197,108,184,14,104,164,80,5,235,43,185,218,173,47,222,132,35,198,86,82,33,247,113,230,213,141,74,235,249,204,219,137,240,13,208,168,46,122,205,109,11,79,28,94,126,162,184,229,147,129,157,239,147,144,248,172,9,12,81,119,92,9,214,137,170,199,159,147,62,81,133,1,64,169,12,220,14,155,149,166,191,194,235,84,80,22,66,205,193,183,106,141,73,199,254,243,78,207,184,26,53,92,54,130,106,38,91,89,173,227,89,219,15,72,107,233,132,97,207,176,235,79,9,201,70,165,49,21,248,65,162,96,93,151,189,178,149,164,113,175,43,9,153,56,84,44,29,87,24,214,198,249,243,152,197,215,31,33,83,187,117,149,71,70,218,149,200,126,82,95,230,32,226,53,250,223,181,210,95,77,165,98,227,143,39,82,26,139,33,133,165,114,229,13,186,33,197,148,220,2,208,254,122,239,2,49,0,209,220,255,26,155,65,120,219,41,88,0,233,17,24,254,119,73,33,196,98,119,233,65,1,73,175,139,209,184,249,12,131,125,71,129,94,3,188,253,145,218,40,71,225,62,231,57,220,166,65,168,171,200,68,234,170,16,145,243,168,245,38,69,118,58,74,226,25,84,19,190,199,31,45,158,125,177,161,241,88,253,255,219,240,200,235,233,156,53,145,1,77,170,114,179,26,23,116,62,212,23,185,196,87,233,235,130,7,200,100,120,48,75,235,234,143,195,175,124,171,25,34,87,116,177,81,103,120,70,77,230,19,98,151,60,39,234,35,50,55,168,154,100,187,100,253,43,237,129,89,161,208,84,123,127,3,13,183,233,129,14,4,196,130,1,55,108,31,249,137,167,177,130,129,66,84,188,124,5,102,9,107,243,37,128,146,211,235,38,190,180,75,53,33,173,78,242,228,24,231,247,226,38,114,96,93,164,28,3,249,249,97,23,153,199,173,84,98,84,24,109,228,168,148,242,162,5,82,253,39,219,220,195,45,156,118,208,95,48,81,164,121,179,160,255,222,208,235,99,117,51,38,35,96,176,3,11,34,222,210,235,15,192,102,194,173,87,186,230,218,112,69,90,14,171,94,92,141,253,70,155,249,37,187,124,12,162,130,238,104,90,13,217,222,2,197,175,182,117,183,89,82,96,84,107,233,66,254,224,172,102,56,0,207,24,28,146,53,168,154,194,211,224,127,66,154,195,88,41,107,216,23,192,101,99,11,108,139,115,98,76,10,202,139,177,202,176,215,147,206,170,64,90,86,62,33,60,13,234,208,233,88,81,138,187,97,118,221,130,232,140,240,246,218,219,17,42,150,255,47,31,208,140,194,31,88,4,45,151,174,186,144,132,42,34,205,172,58,109,121,45,10,71,110,170,98,224,45,216,157,236,209,62,22,1,131,71,132,180,233,117,80,52,87,199,222,132,103,247,163,203,19,73,237,10,147,145,28,145,228,37,64,220,135,26,171,188,88,214,43,53,119,202,75,237,232,36,255,140,226,19,143,119,43,228,133,155,48,144,169,230,92,9,220,41,90,20,126,228,55,234,199,199,148,185,105,50,39,70,82,102,12,210,189,126,235,141,29,126,155,71,30,15,26,203,35,228,231,225,4,132,122,0,124,180,130,206,166,97,105,177,139,107,7,204,192,232,235,43,253,255,247,155,192,67,102,204,13,38,244,13,1,45,134,83,199,221,40,42,254,13,39,13,208,170,158,246,138,152,27,147,255,119,9,6,219,108,230,83,123,140,59,112,1,103,100,209,35,241,183,142,2,33,246,20,200,51,238,137,137,135,218,61,242,174,101,56,0,28,81,184,92,115,193,216,214,26,46,23,166,224,163,15,182,111,107,216,126,247,32,6,238,216,10,177,242,209,180,227,84,28,205,237,43,116,101,57,24,2,188,47,99,121,16,94,154,159,251,141,183,138,166,153,176,175,1,153,44,32,132,69,223,237,98,245,95,200,197,234,121,101,213,206,223,28,47,221,132,160,72,42,231,172,139,143,105,197,219,244,251,44,80,61,239,4,35,180,20,65,99,77,57,239,61,169,192,93,90,195,101,119,20,20,174,204,27,235,143,93,223,131,12,173,64,40,64,245,39,205,229,80,128,16,222,205,92,25,137,203,40,233,94,129,191,205,186,24,225,99,178,70,235,201,66,34,11,15,23,192,109,45,169,103,97,91,248,163,101,86,30,200,1,237,247,79,177,38,199,77,232,217,115,229,197,233,183,1,16,166,98,74,67,229,100,235,238,42,136,13,97,192,210,98,124,233,143,172,22,234,166,231,80,65,40,179,40,216,121,90,28,181,21,213,51,237,63,136,233,241,218,8,27,56,41,197,199,48,23,137,253,56,167,139,3,128,64,35,70,171,71,65,236,77,147,138,14,102,217,64,121,233,204,8,29,4,187,232,8,0,218,196,199,115,94,135,227,242,111,101,96,134,201,92,138,71,141,222,32,198,127,49,154,227,216,247,74,49,170,226,81,145,185,17,13,61,116,103,89,35,242,113,131,86,228,58,173,184,217,143,35,30,173,242,53,174,116,169,166,114,162,176,216,194,198,26,203,84,9,19,49,53,186,50,95,172,127,158,122,208,0,74,110,194,72,201,237,85,144,254,8,103,144,14,253,204,129,26,32,31,157,194,158,37,127,77,255,112,247,50,146,172,213,92,169,243,116,13,51,152,102,130,89,29,246,123,166,202,99,16,16,49,103,142,129,250,165,74,105,148,90,111,68,66,88,254,107,129,141,237,252,115,128,106,66,166,20,71,244,220,181,195,157,181,66,121,99,224,221,183,41,215,142,125,15,11,81,55,119,171,56,254,52,246,118,199,10,28,228,47,66,73,113,135,63,176,163,144,126,54,2,110,221,123,33,42,27,224,156,20,124,213,246,105,114,107,226,238,244,181,206,107,218,60,207,27,136,104,159,8,154,139,67,175,151,79,60,6,0,211,19,27,110,164,98,136,69,16,193,104,230,147,151,138,224,171,244,170,204,99,22,123,37,244,126,167,73,252,77,42,115,142,236,220,12,201,219,184,198,23,212,253,155,141,25,13,172,43,86,131,117,179,185,209,150,55,25,222,195,168,10,79,187,202,218,14,63,240,104,197,12,90,86,195,124,109,180,97,161,181,108,35,139,156,213,154,32,88,208,172,15,38,157,7,8,250,127,241,174,66,74,150,133,205,13,94,146,185,21,127,246,94,141,142,245,92,183,24,32,179,77,54,89,201,88,149,176,39,230,105,235,168,58,31,233,215,139,187,97,90,201,71,188,68,25,26,132,105,164,145,9,171,249,91,212,40,244,98,201,115,245,134,28,219,138,204,50,129,188,58,145,236,20,146,175,22,157,134,153,100,253,52,192,110,76,4,133,203,87,237,10,180,129,68,59,39,229,213,169,246,73,237,48,30,121,138,240,60,160,188,107,93,52,119,116,199,10,65,165,50,145,198,122,30,36,192,45,240,77,58,146,224,70,52,202,155,115,190,230,97,50,9,116,22,188,5,208,188,243,11,187,209,11,232,155,53,137,179,220,25,112,194,197,124,209,52,248,99,48,243,93,49,224,140,187,210,200,13,141,74,225,22,115,61,19,57,243,13,173,63,160,236,42,150,97,252,100,180,81,198,225,86,159,24,105,112,131,154,229,72,29,196,170,193,135,176,91,160,252,79,213,116,241,96,33,130,38,132,62,149,26,12,158,6,56,42,156,20,7,172,106,156,0,232,118,234,188,129,194,108,239,42,49,46,165,114,117,190,177,107,228,84,3,22,165,133,72,4,17,244,32,49,101,50,165,156,216,42,143,98,214,182,101,6,206,37,77,94,2,81,224,199,228,95,167,69,148,131,16,104,81,174,5,133,224,169,146,15,155,149,202,229,78,75,200,161,43,65,159,21,184,195,87,45,46,241,173,208,214,6,137,125,243,59,100,159,98,176,127,184,65,18,217,166,181,151,27,103,206,246,116,139,254,18,82,12,191,184,186,161,91,134,84,173,232,110,76,193,222,61,142,36,0,220,32,201,122,167,169,154,27,56,85,23,148,125,193,51,46,241,250,32,120,60,108,165,226,186,53,145,175,73,126,74,81,196,113,160,56,215,111,121,247,145,130,36,96,43,85,232,6,98,240,222,56,188,86,164,123,146,117,113,123,42,202,155,222,233,188,29,15,13,60,103,115,36,67,107,155,191,237,158,39,135,77,162,219,211,79,152,109,117,41,74,139,101,201,42,97,62,194,11,35,71,88,161,220,130,157,72,120,171,242,46,39,15,133,29,167,176,124,112,187,55,18,143,241,201,98,6,79,155,199,20,92,128,20,155,222,39,100,28,34,219,254,96,3,102,171,135,137,85,167,247,52,59,40,226,70,54,175,113,172,151,120,73,127,131,242,141,124,1,190,223,25,112,43,233,50,8,34,113,155,96,179,161,24,181,100,66,22,176,152,50,209,123,15,13,217,145,55,254,119,42,223,231,209,192,212,176,117,159,133,178,26,171,131,20,37,18,116,43,94,57,96,89,48,108,216,172,223,89,123,229,206,189,144,79,23,192,77,108,81,201,158,85,251,11,213,209,35,47,59,10,92,41,125,133,73,154,132,104,181,187,148,43,210,109,200,94,244,105,84,108,134,77,104,175,10,83,180,102,91,107,154,177,141,39,53,168,137,123,215,5,119,151,150,246,8,226,178,199,27,221,132,119,39,47,133,210,205,46,169,191,185,178,88,35,25,169,125,30,120,112,174,34,229,208,51,21,153,67,199,242,249,8,205,177,114,48,228,155,7,165,222,75,31,187,23,150,252,172,2,59,11,130,131,108,107,157,186,108,242,119,65,215,37,98,212,100,106,138,110,40,61,223,161,16,227,91,152,98,204,112,240,144,230,200,50,212,231,58,135,101,26,234,137,27,29,206,36,147,11,17,160,185,63,106,70,169,157,65,72,120,121,131,22,80,93,210,78,51,202,89,38,111,157,153,55,160,52,155,219,208,231,229,204,151,163,146,59,34,154,4,180,144,6,6,193,29,77,93,219,0,56,51,69,179,52,133,226,244,175,89,40,193,20,8,231,27,162,149,65,105,30,247,49,101,206,81,166,163,120,27,135,113,146,49,184,86,244,252,185,25,4,203,244,223,151,81,228,108,5,78,158,37,57,106,91,240,54,151,190,160,152,180,43,80,150,222,47,108,77,203,92,60,219,237,229,171,210,67,138,199,111,183,2,30,126,101,6,127,115,162,158,201,174,224,14,183,236,252,168,65,148,184,69,41,69,202,13,111,85,41,240,212,21,188,132,82,62,205,162,6,160,219,252,50,152,95,238,94,121,104,206,28,15,51,150,129,242,98,7,168,169,31,107,12,159,231,169,78,205,189,39,53,203,161,90,162,197,83,132,35,110,166,230,196,187,76,78,153,252,233,112,35,11,45,1,100,98,66,80,42,253,251,194,25,207,175,253,229,178,48,78,161,80,44,216,169,203,211,12,209,136,248,120,224,132,28,40,60,216,95,8,1,41,243,123,161,212,115,148,232,15,210,193,240,19,152,53,145,193,42,197,27,62,237,238,12,103,227,76,112,137,75,112,144,91,118,72,35,78,17,53,203,56,181,171,247,69,189,229,105,67,161,154,60,21,177,84,183,20,142,69,160,203,123,6,234,53,123,110,53,70,102,190,86,217,53,38,71,172,175,119,45,63,133,218,133,30,13,56,158,61,231,162,195,201,29,249,116,195,39,99,115,101,230,20,165,150,42,141,222,130,186,125,117,247,156,37,151,202,237,201,218,248,160,114,73,120,108,80,230,19,153,233,151,129,229,23,108,107,252,56,251,255,87,94,51,62,91,86,43,228,23,233,246,80,192,7,203,158,115,4,191,179,89,232,99,144,147,4,114,86,181,109,144,126,222,188,175,28,204,192,32,255,167,37,122,42,75,35,108,188,28,187,218,194,32,16,22,50,253,179,45,49,244,13,240,130,199,126,48,69,109,52,142,145,25,123,236,238,73,184,66,75,110,163,118,234,149,203,224,57,207,162,79,107,155,72,129,129,63,85,175,242,10,57,255,73,78,70,178,65,76,234,194,146,255,104,232,163,163,174,131,29,251,27,68,108,178,101,233,99,84,187,146,20,227,140,133,177,24,136,74,215,176,220,188,95,240,166,188,225,201,239,7,17,47,252,48,58,92,123,197,165,173,84,34,101,209,94,124,209,4,84,254,171,151,46,77,115,250,187,80,89,113,143,52,218,31,198,18,148,211,34,180,203,244,104,207,107,80,46,29,42,77,179,248,18,129,60,59,181,135,239,88,105,209,135,72,90,76,83,189,89,112,203,109,136,218,180,72,151,148,170,242,131,234,105,230,166,8,55,198,13,103,11,107,207,78,158,103,71,159,43,247,43,46,166,126,222,168,255,163,179,83,103,202,253,92,16,6,102,208,242,121,149,195,245,239,143,63,129,28,234,85,161,90,53,186,38,236,184,224,99,163,184,77,156,65,198,108,129,21,155,250,193,215,94,186,56,2,211,215,8,210,251,191,159,93,15,102,115,189,123,39,27,21,129,79,140,198,153,246,62,173,71,224,91,236,34,6,124,173,232,88,3,156,9,21,168,83,233,211,161,108,235,182,254,235,21,136,54,241,164,44,98,56,182,93,93,117,110,157,103,40,33,239,203,97,183,0,39,173,253,213,171,53,215,197,185,70,91,114,80,115,195,144,14,52,158,175,35,157,85,244,112,150,146,214,196,200,53,42,152,73,44,37,187,123,82,182,232,253,218,130,8,113,60,62,53,1,179,203,130,157,166,232,120,170,220,233,100,87,136,85,16,237,191,61,237,190,105,209,185,2,252,187,10,16,163,86,168,185,128,242,21,152,4,135,24,87,128,88,187,152,49,147,204,1,121,143,93,129,77,223,131,144,176,47,235,206,219,149,46,239,117,194,203,53,94,27,248,23,177,174,175,82,199,69,102,98,60,188,70,250,133,138,197,38,238,220,20,70,9,16,36,64,66,64,57,67,168,124,218,192,47,146,47,180,168,56,28,157,202,45,99,65,94,155,181,192,80,242,22,100,230,106,32,116,195,215,173,20,113,217,152,244,31,82,254,13,243,115,194,192,155,201,3,178,4,101,28,42,69,40,161,255,149,166,85,162,168,113,7,91,74,116,157,52,125,252,205,146,207,238,30,72,227,12,123,54,181,165,166,185,66,191,192,53,236,35,51,16,218,105,55,205,177,231,179,219,204,238,227,177,98,160,202,211,96,26,229,0,101,20,216,148,233,12,38,239,249,180,149,101,29,21,84,78,113,202,119,20,206,215,179,90,137,141,225,131,250,124,102,233,15,245,41,98,156,226,70,69,2,192,217,157,17,170,160,174,237,43,10,204,216,36,7,77,84,254,130,127,171,92,12,243,37,149,15,174,205,153,69,181,115,25,95,93,44,11,36,157,255,106,247,128,33,9,175,5,89,44,174,105,130,243,154,170,5,84,127,237,24,53,232,53,26,61,125,19,178,136,5,39,156,236,107,180,88,40,44,230,30,84,243,215,213,78,242,157,178,34,190,185,182,154,167,128,236,96,93,218,50,135,209,37,37,114,135,144,63,16,79,210,144,172,35,99,156,99,53,138,60,219,28,232,21,246,243,114,191,171,219,102,99,220,71,185,69,231,39,28,165,64,231,206,26,0,64,130,71,51,135,77,173,109,29,248,31,227,149,241,130,25,215,127,11,122,254,135,54,43,37,244,204,174,169,212,2,227,179,38,89,153,230,70,200,222,25,105,21,110,60,155,161,165,186,31,162,23,185,44,104,102,206,97,69,82,99,92,140,212,208,164,144,101,177,49,89,58,187,76,158,125,12,184,172,118,61,211,43,253,154,140,85,193,80,249,179,145,208,170,222,151,146,96,60,48,9,49,215,24,171,125,183,95,7,175,171,37,106,63,124,211,220,120,110,246,106,10,9,65,245,8,226,156,244,198,253,115,172,254,198,4,73,34,82,81,92,188,246,235,153,101,179,19,220,7,183,83,92,66,106,219,101,249,27,164,169,247,1,242,248,23,119,51,44,6,77,117,99,114,190,147,92,150,204,4,239,94,253,105,221,19,254,207,146,203,16,178,183,237,189,46,53,67,1,37,79,66,148,167,134,169,93,139,153,251,50,116,24,253,121,65,134,53,105,37,46,3,32,169,214,206,167,218,135,59,81,21,117,233,20,171,226,118,33,32,35,237,140,16,233,233,127,142,230,177,200,138,118,51,99,103,33,79,18,132,150,94,228,43,248,174,183,59,147,166,29,162,46,12,10,108,89,36,43,166,129,255,9,209,208,82,217,205,39,209,189,1,149,29,60,53,195,38,3,234,111,90,168,68,24,84,147,53,70,25,109,146,233,212,197,198,112,65,205,25,47,58,87,7,30,237,229,209,215,40,170,43,231,36,100,53,63,214,24,189,64,152,39,247,122,138,79,13,42,212,46,14,106,199,132,60,66,46,227,203,29,109,218,30,226,173,11,183,162,133,119,127,53,139,168,124,111,161,57,166,121,236,81,33,22,229,228,162,232,65,106,152,248,132,166,11,77,133,27,105,51,15,21,21,175,246,236,0,178,111,245,30,23,106,53,235,1,213,198,176,204,166,222,53,49,200,244,231,99,12,48,12,226,112,91,69,94,69,202,106,141,62,163,247,59,209,187,227,221,239,81,25,123,7,247,58,223,13,44,151,18,247,200,178,139,7,175,187,254,80,23,99,105,40,223,210,52,152,119,92,41,197,123,28,28,171,217,205,25,198,205,74,89,76,76,41,118,201,83,31,238,53,30,236,170,255,148,244,167,15,166,42,208,222,36,188,54,139,61,221,188,215,169,40,89,67,212,124,204,119,122,238,33,135,164,157,208,125,223,154,141,105,1,143,67,226,156,45,246,249,86,78,58,175,34,208,127,62,231,123,218,74,123,88,58,187,209,149,88,190,76,100,237,12,42,67,21,60,226,154,212,242,218,181,216,92,229,58,205,165,169,13,250,29,29,91,195,24,127,108,122,113,130,188,131,247,185,248,167,9,76,149,83,118,227,126,142,207,138,123,101,39,181,161,69,216,4,106,237,246,95,17,195,93,80,163,216,91,115,146,244,19,120,173,81,211,139,73,151,143,104,203,192,131,135,33,225,42,79,20,138,30,33,90,42,238,244,100,102,247,167,123,254,181,42,176,203,35,237,22,51,39,60,52,68,48,56,5,135,48,249,132,29,249,87,251,133,162,7,155,217,116,140,98,24,63,85,63,59,25,174,238,52,236,152,182,149,154,96,177,91,177,247,1,113,239,109,214,228,33,178,211,145,134,236,122,144,85,218,153,156,134,9,135,93,10,136,123,245,238,113,144,247,164,245,178,112,212,165,43,92,97,39,61,95,189,199,189,117,236,229,147,204,89,44,145,202,156,10,21,41,35,141,252,81,7,160,222,80,142,129,32,126,173,47,223,176,207,23,130,151,249,145,59,225,243,94,125,38,44,18,152,82,127,106,144,83,46,161,232,19,186,250,18,101,17,93,111,142,251,34,232,33,235,176,189,212,90,250,217,241,101,219,143,168,31,180,44,21,160,76,184,13,236,72,11,101,252,40,253,8,112,200,115,6,89,108,178,151,221,244,178,128,28,47,61,145,60,208,48,207,170,188,187,207,231,89,117,85,2,114,104,87,21,35,21,201,239,76,216,232,63,155,184,122,245,146,176,229,167,181,134,206,59,122,200,105,34,239,126,11,148,65,147,96,156,95,251,156,194,146,122,223,198,182,137,195,106,198,230,47,147,214,102,15,221,108,180,97,36,75,8,241,70,6,192,181,6,211,92,92,10,62,120,64,111,46,179,168,244,4,227,118,120,88,229,111,99,236,0,183,73,152,0,231,58,72,255,27,184,125,22,95,93,121,73,180,24,223,168,103,191,113,83,100,246,232,115,154,131,235,215,191,24,98,33,255,222,221,32,65,200,208,142,120,83,62,102,12,19,36,249,244,117,247,155,120,132,27,92,101,162,137,219,61,160,188,217,215,75,249,85,106,14,7,178,45,188,20,215,70,229,194,23,111,207,50,83,254,131,29,137,83,93,214,180,81,228,106,26,7,156,112,226,189,62,62,157,68,31,233,155,224,215,192,155,142,206,94,177,56,81,19,165,208,54,153,216,103,200,45,50,123,108,99,12,131,228,187,212,198,144,53,217,15,163,119,163,133,204,244,124,244,50,150,241,6,166,67,82,115,131,195,119,109,217,169,215,180,220,9,68,206,241,16,227,112,86,214,217,88,157,153,144,226,37,61,60,196,187,15,171,17,126,65,189,139,58,40,124,227,132,234,207,209,251,149,157,139,16,237,33,230,82,183,236,95,159,70,31,119,84,195,94,207,138,24,202,137,252,115,164,27,14,234,106,9,57,66,102,167,144,186,134,241,190,36,219,78,83,222,221,118,101,33,18,138,71,160,38,166,136,129,144,211,218,229,196,219,81,125,84,112,136,242,244,76,113,243,53,115,248,163,143,189,66,173,208,124,138,11,201,12,216,72,190,170,221,48,82,176,58,150,83,121,30,182,148,119,155,26,64,247,218,75,204,205,88,166,212,69,221,141,54,128,134,218,172,151,167,178,99,35,236,71,90,61,88,99,234,136,17,213,209,151,209,217,126,212,82,6,4,203,157,234,66,134,169,34,159,223,161,30,23,118,146,132,186,254,10,212,12,239,99,247,133,12,163,134,85,55,96,122,167,184,38,158,148,38,157,163,201,8,165,209,164,239,109,137,108,172,20,78,107,45,140,211,230,198,106,51,219,217,105,31,208,179,227,48,101,233,61,27,172,37,16,136,195,33,71,163,37,230,180,225,130,80,189,73,196,25,122,162,106,126,55,214,74,228,205,117,223,70,58,162,64,96,31,7,74,221,189,169,143,29,140,67,252,201,255,95,25,238,143,244,128,136,211,19,10,160,151,117,195,18,180,61,214,150,36,14,110,85,96,118,69,58,217,102,219,73,241,241,46,200,17,71,96,63,188,110,159,167,53,141,193,149,126,78,250,94,226,71,35,201,74,235,106,161,198,63,161,103,148,194,130,225,165,175,84,246,87,105,152,11,154,250,25,38,95,160,62,55,140,102,175,83,176,17,122,179,248,202,182,132,52,106,130,253,6,118,64,109,157,56,39,9,139,74,67,27,52,221,85,194,1,234,60,229,27,68,86,110,151,252,217,149,202,14,66,179,75,89,98,118,3,239,19,157,192,46,234,230,147,181,8,119,107,112,105,130,26,107,234,91,179,75,199,85,128,106,252,150,48,155,0,44,190,209,242,106,47,199,183,183,201,102,60,124,167,126,164,11,148,122,150,213,55,107,222,69,5,55,233,137,21,22,82,203,184,207,5,57,222,60,199,15,102,240,52,91,31,195,1,82,53,217,158,173,165,16,138,43,157,193,9,199,84,80,25,75,30,172,23,31,254,66,219,84,119,59,228,67,206,33,147,146,86,8,208,178,132,148,77,159,54,84,114,14,141,12,129,233,78,237,147,136,194,134,192,95,155,200,164,119,24,21,53,175,36,35,105,204,114,55,113,192,123,255,37,171,182,192,228,155,141,17,248,70,72,197,63,71,60,110,106,138,2,84,203,115,147,86,52,45,154,181,21,243,228,199,194,56,42,49,87,185,115,76,101,15,50,158,234,55,243,157,139,158,127,102,59,212,232,86,92,133,231,76,18,114,91,232,190,31,177,249,90,236,30,3,121,129,30,221,255,156,111,25,171,144,62,114,1,229,219,60,187,14,90,61,158,255,96,243,117,193,6,128,216,141,178,231,140,128,36,11,41,211,68,40,56,70,125,244,123,148,152,38,216,35,91,82,162,10,28,113,172,70,194,43,69,114,37,137,55,46,38,195,81,249,246,188,29,128,158,177,138,86,63,110,171,103,81,82,98,132,4,237,108,11,192,203,149,29,154,97,226,56,105,178,230,243,64,198,248,101,142,84,182,154,18,63,11,225,133,203,208,111,34,167,45,169,84,110,23,156,53,200,245,202,221,234,250,4,119,119,35,26,230,121,74,135,168,225,145,226,87,137,144,42,43,229,14,81,205,29,99,130,159,174,115,135,181,244,207,62,215,241,85,34,251,145,211,172,85,168,26,227,200,109,120,5,101,109,243,207,114,170,249,41,176,242,118,40,237,205,26,130,217,142,187,80,47,72,241,234,58,56,152,47,65,136,244,118,7,185,35,211,196,22,71,55,4,33,3,162,87,36,199,173,133,14,130,99,162,169,104,210,198,83,132,206,188,95,57,107,199,170,66,188,53,235,155,0,238,217,9,83,54,79,162,179,209,86,99,209,84,35,34,142,3,119,62,155,64,129,128,228,139,160,250,221,9,252,5,213,175,62,44,125,205,145,142,164,212,153,195,1,145,8,37,92,199,40,20,19,13,182,74,102,117,30,48,249,122,235,194,16,179,120,64,83,63,241,28,252,115,216,66,219,35,109,166,60,48,33,224,227,21,48,22,81,148,152,39,72,242,61,136,231,95,198,183,179,16,126,21,1,118,129,22,223,191,184,254,211,98,102,175,56,94,119,133,22,92,230,8,178,206,86,110,152,207,2,34,78,227,186,5,12,23,253,190,192,67,61,69,204,236,200,27,9,210,192,209,16,181,64,54,179,233,11,164,104,44,24,216,218,237,163,230,110,174,154,35,20,21,77,2,252,214,226,109,72,229,60,65,159,30,105,91,59,151,115,131,43,15,129,217,192,84,20,21,42,55,202,10,204,108,64,89,91,166,113,232,56,178,119,30,224,30,101,70,139,36,144,107,16,155,197,99,222,2,123,22,207,106,110,38,215,59,192,135,37,24,255,145,57,147,244,44,63,14,121,226,252,103,56,173,242,175,81,39,33,40,120,150,23,89,49,5,21,144,27,229,72,218,196,167,52,228,121,224,241,51,130,56,188,33,153,73,72,159,116,105,107,124,120,202,50,234,155,220,39,211,30,155,150,22,231,121,135,102,151,227,4,235,112,155,94,149,66,148,248,20,20,44,53,57,32,128,132,197,237,102,205,254,128,39,162,86,64,179,13,106,179,151,171,199,12,189,225,158,98,170,108,156,189,64,82,177,133,80,11,63,253,58,107,17,120,55,112,5,73,165,176,70,237,251,162,117,228,251,93,48,16,46,235,101,105,118,59,216,147,88,136,151,21,239,167,16,145,146,121,55,95,57,12,240,20,165,60,125,26,236,233,59,138,37,134,113,138,106,61,216,218,137,193,114,203,239,92,92,190,118,213,60,240,120,235,156,43,161,118,78,253,248,35,138,214,33,113,238,50,91,25,154,149,166,242,165,255,63,6,57,63,232,206,63,148,127,44,35,185,252,33,137,86,124,229,2,10,16,170,207,36,192,65,232,113,230,6,127,40,183,78,108,185,151,202,225,233,67,203,68,97,61,106,68,7,162,105,71,134,155,42,26,188,208,77,222,117,192,124,196,36,49,166,131,20,55,42,80,46,216,249,208,235,166,107,128,241,76,74,125,182,199,29,96,142,205,51,59,156,2,71,241,47,237,159,126,50,94,37,222,142,112,45,143,156,42,252,104,145,16,160,178,52,239,211,219,47,64,107,121,35,188,35,16,165,70,174,215,136,48,108,24,224,27,207,172,136,51,207,155,152,201,124,68,221,109,60,72,7,3,176,112,21,147,217,224,187,139,234,89,129,2,191,181,66,167,16,172,187,215,168,76,220,107,236,34,215,134,220,59,1,241,197,168,238,3,218,136,141,187,131,89,132,37,60,13,165,237,6,77,71,242,20,251,42,51,153,13,244,91,82,186,168,27,215,225,50,102,116,82,103,196,39,201,83,252,214,253,234,83,24,80,107,91,7,12,105,247,55,212,185,164,136,70,9,114,51,54,129,61,216,35,218,150,228,250,227,101,56,94,60,168,2,169,79,144,20,197,191,6,95,155,216,107,124,31,18,36,187,194,22,243,130,89,190,216,77,6,97,254,199,1,204,229,40,53,177,79,17,176,135,25,96,145,58,71,109,211,238,92,72,127,80,138,11,141,75,231,2,188,148,13,46,158,186,43,110,255,212,79,143,111,77,204,244,173,192,92,22,132,109,113,150,87,220,191,116,51,20,123,106,168,118,26,225,9,207,149,27,238,182,142,220,137,214,143,230,108,53,254,118,64,130,94,185,156,119,39,131,224,10,194,77,46,125,210,177,181,59,208,195,14,240,172,244,107,184,134,152,113,236,251,114,212,238,56,13,161,30,79,162,236,29,250,168,219,175,49,100,185,225,2,8,1,223,28,28,95,109,161,7,166,197,111,160,178,11,3,73,85,235,186,227,103,189,111,128,2,126,32,189,109,26,186,54,80,26,247,210,59,65,181,187,0,188,184,150,150,20,8,25,101,115,10,122,27,12,202,8,71,210,122,179,153,223,175,78,4,119,140,231,198,81,184,132,159,43,34,61,220,163,52,21,55,63,151,180,250,26,253,170,195,147,57,101,247,68,10,151,159,81,106,232,175,237,194,103,86,10,56,33,94,229,164,242,22,149,229,18,128,185,16,8,139,217,130,201,32,125,22,228,231,241,202,87,74,115,243,1,41,185,127,49,152,122,10,220,239,19,100,213,112,166,222,242,145,204,197,110,202,241,161,101,199,241,161,120,29,210,152,159,162,88,96,85,97,6,36,183,71,14,228,52,236,65,119,201,142,157,219,234,124,254,148,4,198,108,61,249,212,232,75,191,192,130,29,104,91,184,196,160,229,79,132,81,245,42,122,10,99,146,244,188,252,94,56,173,146,45,124,167,5,92,135,72,191,135,203,79,213,4,179,241,160,90,179,116,241,223,76,112,86,141,100,165,187,210,40,25,230,248,50,78,142,108,211,239,10,31,136,94,230,167,246,48,49,130,155,105,78,31,235,173,137,8,156,183,40,80,179,80,86,178,162,54,45,169,90,46,53,22,52,150,40,204,236,97,35,142,221,227,79,92,157,159,169,231,172,13,118,182,71,230,42,203,159,218,202,31,215,164,182,240,12,143,176,181,161,12,22,155,200,27,72,44,159,85,238,205,184,196,219,197,50,169,50,232,165,135,238,173,182,98,129,232,19,137,248,127,136,243,220,178,238,108,145,141,197,56,122,90,142,216,24,206,12,76,241,234,80,102,240,182,24,178,199,5,72,57,220,12,145,172,106,164,96,143,27,163,107,146,37,212,22,251,171,162,245,92,141,240,33,50,201,114,248,141,28,42,163,56,125,180,87,88,218,167,150,220,30,86,152,176,49,91,37,168,9,59,53,42,73,230,164,67,177,8,197,142,213,208,99,186,104,176,134,246,150,27,104,121,180,211,12,92,93,11,210,27,131,12,228,99,224,121,69,162,23,177,42,192,2,210,134,54,200,88,9,181,78,100,119,110,85,197,213,55,160,49,89,205,156,195,106,27,241,105,145,149,236,35,114,137,144,122,236,26,146,133,144,212,124,210,126,63,84,45,219,46,92,105,105,251,95,171,152,90,148,38,29,143,139,255,163,204,184,162,114,83,231,55,103,124,192,71,2,8,144,75,65,238,22,201,238,87,155,178,240,174,221,224,243,228,17,3,6,81,99,114,128,22,199,102,215,107,227,151,28,148,123,172,252,131,110,64,125,63,43,48,151,121,125,215,241,143,246,151,248,217,162,99,70,70,11,238,219,235,45,226,221,248,185,188,69,132,175,59,72,16,240,17,118,70,215,141,119,162,116,254,226,168,102,205,165,240,215,94,119,145,182,151,50,179,181,251,247,8,43,244,200,171,201,170,33,104,23,28,138,193,182,115,172,57,208,109,103,197,239,100,69,159,37,115,244,174,44,97,57,52,235,48,191,103,125,63,78,71,1,62,92,160,65,76,235,217,195,86,244,25,241,189,73,51,62,190,167,111,161,40,198,44,5,64,221,231,95,31,64,112,210,98,92,180,233,221,170,255,94,161,195,139,233,23,111,7,189,77,191,56,36,98,225,107,242,141,76,128,201,131,238,253,4,85,13,23,192,61,189,126,144,124,177,86,250,88,49,66,72,28,237,158,174,216,169,60,230,242,72,138,151,116,67,67,111,57,236,232,46,121,94,151,190,14,38,157,62,223,236,250,77,149,86,215,104,146,1,84,134,214,24,60,254,4,100,180,22,194,231,113,244,171,147,218,148,114,135,236,63,137,63,112,49,12,218,13,180,22,198,114,138,44,228,217,151,130,88,233,6,141,161,245,207,2,252,51,74,15,53,189,246,24,191,138,204,247,109,18,180,103,1,57,81,212,124,139,60,227,42,229,199,160,212,79,223,27,206,170,226,21,121,162,70,108,135,218,37,29,230,187,122,148,24,226,41,162,195,76,246,27,160,218,209,77,29,171,32,218,85,20,117,160,61,91,253,245,247,121,12,91,246,221,43,178,154,167,209,27,221,54,136,165,27,159,10,201,100,58,176,116,19,12,187,223,93,168,125,83,96,222,117,147,239,22,56,210,89,126,246,62,96,67,118,35,16,27,223,132,76,44,215,69,118,142,220,93,54,59,226,159,78,71,55,249,229,54,202,101,169,215,48,126,94,69,15,152,73,151,230,27,208,198,122,221,192,70,148,72,237,80,236,94,252,43,46,167,164,45,253,249,222,186,236,155,2,2,143,192,144,68,137,217,205,76,219,123,223,21,133,71,189,0,98,139,143,246,153,143,61,195,200,155,63,165,235,92,107,93,207,55,254,143,209,229,135,68,178,117,4,210,29,179,71,221,0,255,254,114,198,11,154,17,89,41,235,37,98,226,249,185,36,253,45,116,185,234,150,89,254,203,108,45,103,185,170,164,83,64,98,90,240,65,11,180,229,0,207,230,1,3,79,74,44,246,175,239,102,99,144,133,233,42,49,101,164,117,64,233,5,41,228,181,145,168,5,93,183,229,117,181,72,111,182,20,123,85,122,21,98,150,245,219,186,97,234,1,90,220,254,74,68,169,216,152,225,5,69,223,139,58,17,84,72,63,189,145,151,191,148,214,35,92,117,23,18,113,95,108,7,221,217,116,153,225,115,255,107,5,167,255,77,109,160,112,235,238,41,44,20,138,142,200,153,102,71,66,249,251,195,30,31,180,53,240,101,159,27,159,69,39,2,100,3,24,233,56,29,227,238,118,32,223,81,4,175,5,178,220,102,178,32,250,133,240,177,226,14,119,244,76,221,236,64,61,149,38,82,50,11,66,10,203,145,252,238,195,117,228,132,196,239,2,97,190,141,68,28,36,237,134,99,111,174,49,85,175,187,120,38,146,90,102,40,19,247,60,246,86,243,80,192,68,93,211,50,4,144,34,119,194,171,65,12,131,25,90,241,181,128,239,75,230,174,184,151,72,85,188,12,14,57,28,3,87,59,24,237,141,203,88,81,59,44,233,40,113,191,16,218,182,181,76,23,233,164,214,118,236,237,206,84,34,38,35,54,72,66,39,132,70,3,159,200,159,17,113,134,40,92,81,198,242,135,28,107,74,191,74,136,178,79,70,237,22,158,54,74,146,118,200,71,225,237,34,194,116,137,236,17,241,80,61,113,195,235,35,148,28,78,176,3,17,79,15,8,98,233,97,192,189,247,155,174,47,2,0,98,232,210,84,73,107,152,146,202,100,96,24,92,137,33,150,11,49,28,213,252,142,160,55,53,100,17,13,152,120,209,168,204,36,150,104,188,192,107,238,52,211,191,128,234,237,55,180,255,238,14,134,190,15,84,20,11,57,199,184,60,197,167,151,58,143,142,67,44,81,239,195,225,229,210,253,68,172,68,158,242,159,48,58,120,216,4,87,235,47,18,111,51,182,61,205,223,252,54,191,230,10,102,41,139,47,92,87,63,103,66,67,24,248,217,206,151,196,13,178,231,136,155,4,123,200,204,105,116,164,27,237,19,138,44,251,158,70,102,115,184,35,248,5,124,195,144,33,53,151,100,43,45,27,77,32,103,5,217,207,83,128,189,95,38,99,222,188,35,244,32,0,36,184,17,71,148,156,120,64,255,6,25,198,63,93,202,132,55,12,219,23,221,53,255,57,91,46,131,93,72,52,88,230,104,85,243,198,25,103,24,8,239,184,116,254,141,62,208,194,19,153,122,102,42,164,80,186,95,55,218,135,117,65,45,197,247,28,148,114,194,110,178,139,128,190,182,190,54,71,231,207,120,146,113,229,179,249,41,13,35,67,127,6,6,15,141,90,101,253,163,207,112,101,1,118,58,177,236,199,151,112,13,153,139,52,59,42,97,42,151,84,5,81,169,16,5,233,88,144,23,146,28,245,243,78,242,216,42,199,150,201,174,227,85,107,65,40,248,53,59,133,4,148,228,187,27,189,87,207,88,50,36,161,187,88,74,8,96,72,125,195,14,9,204,131,127,230,155,198,161,199,149,110,194,172,137,110,18,6,201,60,164,13,161,136,131,169,56,254,0,61,6,98,214,216,89,119,240,69,199,227,82,165,36,69,248,45,27,143,214,29,97,136,108,176,134,160,191,130,177,81,119,93,15,193,236,39,140,152,40,134,98,5,125,150,254,77,140,133,206,231,214,91,64,197,96,12,87,81,143,99,168,78,37,102,103,229,66,119,55,242,59,158,251,116,75,244,52,80,189,121,125,58,179,81,122,44,238,153,65,162,113,250,161,204,82,33,215,86,145,33,231,224,62,98,57,163,112,127,178,91,83,144,176,253,217,171,111,201,142,79,88,88,34,225,5,110,8,1,215,251,187,245,92,73,221,221,239,91,239,78,15,212,61,172,217,172,61,104,229,209,79,8,149,209,36,158,117,214,136,219,190,157,118,29,158,147,71,226,32,224,13,12,12,220,0,192,238,20,82,45,148,164,111,77,196,252,248,246,5,236,144,174,61,109,137,235,21,35,253,195,88,214,131,175,95,196,21,22,42,180,52,4,74,104,35,151,47,59,161,2,133,185,76,220,121,243,5,248,66,196,174,186,62,66,242,37,47,73,210,60,82,45,53,35,229,240,84,72,151,22,37,253,243,11,91,220,19,125,121,198,253,180,129,148,80,8,89,99,4,164,57,4,214,148,240,235,79,118,115,104,64,98,40,119,31,51,142,168,166,154,25,193,121,129,53,103,230,178,213,175,166,4,14,195,179,19,152,47,221,129,217,142,92,252,220,50,35,15,75,165,194,85,107,245,10,145,146,193,90,111,57,27,85,156,255,167,70,219,26,220,246,231,109,230,244,82,251,51,137,139,253,7,52,44,137,96,29,174,55,184,120,154,14,80,6,25,220,35,85,14,243,179,47,152,115,197,66,145,91,157,188,63,87,73,209,92,190,247,80,153,135,106,132,157,210,200,227,202,51,222,223,33,128,53,111,59,197,115,21,121,74,217,138,155,135,189,65,148,14,91,202,248,94,41,32,32,131,222,224,14,158,68,134,142,205,57,170,190,39,174,240,84,88,11,100,30,236,39,85,168,228,8,203,223,232,76,149,235,49,109,62,190,202,203,88,252,123,59,210,45,5,194,42,136,178,101,1,112,66,151,36,67,249,35,214,149,45,0,134,143,206,172,76,156,83,197,195,24,1,7,237,49,115,254,170,36,128,185,62,220,235,156,116,221,117,236,160,116,37,98,250,199,72,164,6,68,55,62,232,4,70,4,123,50,97,117,81,118,238,125,40,192,153,19,200,107,180,235,231,201,85,66,71,217,28,237,157,27,110,61,235,121,35,90,40,130,35,170,193,146,51,155,160,145,4,92,175,250,110,7,128,53,187,132,184,101,133,253,59,218,117,243,239,130,206,136,184,66,237,133,34,14,74,244,101,92,149,213,42,169,242,177,193,58,109,45,104,49,8,64,0,183,132,75,233,216,163,125,110,86,190,131,197,97,114,223,208,226,108,232,92,128,116,29,163,25,221,204,235,77,241,162,79,152,43,145,54,180,143,89,95,43,245,43,6,216,69,210,238,160,214,158,195,42,35,46,128,227,253,237,26,20,161,67,188,188,104,171,97,127,155,7,238,152,80,10,177,160,229,51,175,53,44,86,244,125,123,92,231,71,32,17,198,158,60,255,123,175,73,205,78,230,10,194,120,112,248,121,105,4,223,83,5,8,14,139,231,125,198,172,182,187,187,37,73,133,143,138,56,233,92,230,24,220,242,61,129,149,172,236,207,142,179,55,20,114,122,37,85,21,112,134,89,35,69,191,253,88,175,19,33,58,186,229,163,226,20,118,209,205,194,159,223,223,161,230,120,64,204,119,185,117,92,173,245,5,199,230,222,188,62,125,96,152,29,178,102,224,105,241,213,127,86,228,177,31,195,120,118,89,228,167,8,216,121,125,70,139,147,118,202,250,52,52,224,194,119,57,151,146,22,187,136,124,53,87,162,111,35,94,187,160,130,146,69,241,93,57,93,140,67,65,208,219,138,151,5,0,46,254,168,95,11,245,248,59,156,46,51,171,78,242,119,165,143,66,185,218,75,70,73,3,38,167,197,92,250,2,9,170,71,233,164,56,39,31,220,79,36,223,141,158,20,144,78,244,174,140,223,251,53,214,146,15,136,43,18,35,180,179,16,150,40,24,253,168,49,74,156,151,145,160,181,128,156,136,135,215,126,47,219,81,54,26,171,6,185,44,248,32,200,127,215,54,236,168,31,53,105,222,2,94,40,210,206,215,206,167,161,67,178,136,30,113,100,137,19,236,242,235,228,74,228,127,99,134,198,87,46,60,242,152,86,15,113,7,17,145,97,116,180,163,159,244,71,253,200,69,254,189,72,200,100,34,2,227,12,26,224,246,86,73,83,223,153,94,116,203,247,68,75,70,62,246,221,101,128,254,14,4,64,33,75,28,61,125,130,0,34,55,58,196,247,98,53,44,250,243,233,168,177,223,9,163,249,18,162,195,249,141,128,209,157,110,94,131,48,125,233,131,247,213,9,103,175,252,131,31,83,155,135,61,66,127,16,80,145,63,35,33,2,206,4,251,54,141,184,148,237,243,197,195,242,151,133,57,110,9,77,129,146,25,75,13,44,46,54,82,149,121,112,228,90,228,89,201,251,233,227,108,174,49,105,132,54,7,187,237,57,205,55,22,140,40,55,1,252,96,206,9,188,118,168,2,13,67,131,220,58,87,186,159,169,18,117,191,222,58,51,132,175,228,147,110,121,137,150,32,85,31,36,171,159,96,62,8,181,170,4,104,136,8,77,150,131,229,121,111,221,123,190,117,150,127,239,122,13,127,53,214,84,98,173,242,205,182,117,92,150,148,183,200,12,175,143,97,197,245,37,80,71,69,7,215,16,145,198,165,196,107,179,230,72,162,172,14,165,200,3,11,200,28,126,150,98,114,248,202,68,148,132,90,94,12,74,179,63,238,36,149,136,243,178,50,125,185,180,41,36,223,111,40,205,80,67,78,200,110,100,158,144,59,160,11,28,250,163,26,18,135,49,234,136,238,151,163,38,57,67,33,241,37,3,120,177,161,196,246,192,187,141,69,63,131,177,65,121,23,51,34,217,3,222,148,202,69,86,108,141,254,113,243,41,206,214,218,177,49,177,23,71,35,167,243,168,90,30,196,176,249,207,78,211,35,174,48,221,171,24,139,54,230,137,16,104,238,167,40,21,57,189,107,235,101,71,229,126,139,26,183,41,174,27,177,126,57,119,64,99,128,156,56,24,165,155,167,199,7,45,213,139,5,237,136,0,150,165,15,92,89,235,91,88,47,255,203,88,43,117,137,184,226,102,90,241,206,235,172,209,41,188,254,120,120,34,156,75,119,64,52,189,118,163,245,104,94,245,148,34,24,121,162,92,135,219,191,135,35,73,216,151,4,143,37,167,111,20,148,78,192,240,65,124,193,153,0,89,45,189,144,61,28,219,215,228,252,115,84,238,224,220,100,201,144,240,102,161,139,7,238,181,174,195,228,38,64,175,119,186,225,152,160,91,183,236,139,212,60,102,224,6,33,82,219,26,182,38,155,131,138,104,112,190,156,179,49,38,136,97,185,71,203,157,141,98,123,175,129,245,78,197,9,17,54,252,44,102,83,69,128,117,160,187,82,229,212,153,125,42,246,144,33,204,13,192,208,176,215,227,4,46,114,141,78,89,234,56,33,92,2,78,183,207,207,115,16,74,223,209,115,183,32,2,243,145,210,51,229,62,126,235,224,150,111,1,116,30,181,170,245,129,88,216,190,133,225,6,196,3,116,58,68,95,196,105,143,240,85,205,12,111,75,189,0,65,221,120,235,152,237,34,81,111,60,73,97,137,63,213,212,97,217,215,94,18,175,151,142,100,151,161,53,97,255,29,147,50,15,196,194,241,206,71,39,101,117,241,138,121,59,229,166,9,228,57,220,9,249,21,125,218,213,170,214,92,73,185,239,182,32,109,91,203,214,140,120,241,173,146,191,163,36,204,204,4,87,231,93,132,226,92,85,66,190,63,118,147,93,45,153,82,20,231,202,101,204,41,22,222,157,21,252,132,4,218,135,190,208,139,94,91,173,83,217,206,1,1,85,39,70,233,197,56,172,223,53,27,42,30,194,190,121,189,182,186,129,135,3,235,195,95,95,49,115,211,139,17,249,234,90,232,90,8,149,186,194,164,244,156,232,152,60,137,0,248,24,209,18,155,175,193,176,75,115,108,140,162,243,99,149,9,173,93,12,200,104,14,232,164,21,36,174,141,180,107,51,57,146,41,216,151,63,217,66,233,20,246,122,230,67,236,128,11,124,113,4,183,56,108,245,227,186,141,206,79,32,202,254,76,50,28,22,217,230,128,83,59,39,22,200,18,237,178,176,137,218,86,162,164,135,194,208,107,66,170,74,228,79,35,113,202,181,228,66,90,80,121,167,121,238,100,2,120,202,247,244,127,71,226,43,242,25,32,8,36,135,157,20,86,253,120,91,193,104,27,18,214,129,11,168,246,23,114,164,102,167,173,98,60,75,189,238,22,108,185,244,228,204,143,121,158,39,157,50,194,15,143,146,116,67,144,190,79,149,76,130,74,239,57,73,253,45,222,166,31,178,252,247,28,229,69,82,31,96,118,105,30,180,204,104,180,49,234,80,102,65,165,20,91,24,95,164,61,126,103,146,229,191,198,230,168,14,44,222,187,101,123,181,202,243,166,19,104,226,202,181,182,201,42,168,190,192,164,132,135,65,246,145,173,187,51,175,93,220,1,32,253,205,26,125,22,9,69,102,221,114,166,163,254,98,36,182,16,28,6,26,63,215,230,30,117,173,97,225,10,168,200,179,225,20,214,141,224,93,16,93,144,229,160,77,109,194,157,24,83,114,23,11,41,147,196,3,221,106,131,209,209,56,163,137,212,50,41,179,160,20,70,77,154,98,125,151,74,187,115,29,254,130,219,146,215,133,5,167,167,46,106,64,16,75,200,216,0,238,40,250,124,154,115,218,195,226,133,230,213,37,222,152,243,94,95,30,116,8,98,227,161,142,236,231,131,77,31,72,145,17,37,116,194,157,159,84,227,239,78,180,6,57,1,149,57,52,62,168,49,97,215,49,86,182,22,25,224,144,64,33,67,253,130,226,93,19,99,168,144,82,145,86,166,36,130,5,69,168,90,25,21,165,93,75,30,33,89,189,212,85,63,9,244,228,47,62,212,183,143,226,32,123,153,71,166,90,176,65,185,216,16,239,201,246,137,35,199,162,217,61,248,5,7,55,104,61,22,82,35,141,185,203,198,251,170,104,194,62,58,17,73,190,148,142,84,113,213,33,223,68,8,93,242,113,191,94,129,129,90,117,255,220,239,205,13,145,47,240,16,224,160,29,188,50,121,218,27,165,126,239,113,39,177,33,217,116,30,55,65,27,105,102,75,157,198,190,76,189,214,16,108,51,95,174,164,76,168,159,33,14,172,221,187,243,155,94,225,145,117,76,39,236,16,84,60,195,231,167,74,99,11,7,168,147,128,59,99,255,149,60,29,107,90,105,211,22,128,198,103,197,224,76,62,30,70,106,83,102,222,143,70,156,10,228,79,138,159,201,0,211,233,114,42,34,9,185,22,118,106,132,234,151,49,108,161,100,33,141,98,255,114,147,97,77,151,149,184,106,196,241,28,50,230,240,37,113,143,188,236,91,107,193,83,83,197,81,176,204,61,13,7,216,178,172,73,107,232,97,196,235,191,228,135,145,5,194,109,14,178,85,67,221,103,86,144,53,90,8,53,23,39,39,58,162,59,139,108,65,191,115,70,139,166,120,94,241,87,16,22,112,206,35,211,21,74,140,149,209,142,228,13,155,61,8,210,76,60,26,135,94,204,148,61,199,173,62,214,216,97,156,53,119,100,157,115,44,159,239,255,60,248,209,14,40,68,1,233,161,111,87,134,177,86,177,201,91,204,59,57,194,94,237,81,196,6,15,3,90,242,132,52,167,208,66,220,131,19,243,27,54,67,112,206,122,222,255,152,187,149,175,100,167,7,29,118,131,106,241,52,12,95,138,160,117,68,15,245,75,27,192,241,34,16,80,67,108,240,161,86,37,194,163,237,32,142,252,152,218,233,5,179,247,33,198,176,125,52,26,142,178,220,28,174,176,144,94,213,11,148,105,117,13,73,33,47,199,176,38,21,146,214,65,58,68,196,183,79,200,61,20,158,232,254,40,226,90,181,93,198,87,161,179,151,124,157,56,109,134,224,24,99,173,250,176,148,21,51,130,228,58,15,175,45,50,80,242,8,215,52,90,82,182,208,58,206,223,121,59,107,194,168,83,28,136,166,164,149,99,32,160,104,26,23,23,225,105,188,230,181,182,35,183,72,114,29,137,60,33,142,193,60,190,103,42,237,136,191,223,155,67,124,246,126,14,144,111,168,168,238,117,101,155,203,56,231,81,44,77,165,49,176,209,94,42,70,5,48,58,2,168,237,47,187,98,116,248,254,208,159,91,126,211,127,25,9,3,53,236,45,2,183,238,5,76,255,50,169,62,61,32,154,67,123,29,192,12,212,230,203,23,39,15,41,156,66,131,250,228,228,224,87,238,163,253,29,74,99,233,172,58,8,231,186,172,30,105,60,66,129,57,194,234,177,81,127,94,237,36,160,20,101,188,37,196,208,95,201,37,142,102,239,103,3,128,112,118,174,48,115,19,180,23,75,195,93,168,92,69,227,126,35,9,222,139,198,0,63,195,80,154,172,10,72,105,188,217,61,242,5,41,244,70,77,200,106,207,115,124,169,172,231,42,144,255,5,215,204,214,41,179,120,80,66,84,52,116,80,59,85,120,229,226,223,139,201,131,22,221,28,146,104,177,0,87,140,8,218,198,14,54,126,44,11,0,69,59,193,115,143,157,87,45,165,241,153,7,167,67,233,47,205,4,56,170,211,249,154,233,107,238,119,254,200,35,53,4,172,247,67,77,182,166,203,128,127,75,249,13,111,144,179,157,61,160,60,75,137,173,142,211,227,219,181,31,30,234,93,2,4,211,228,71,220,16,186,139,122,116,179,43,21,171,16,255,0,91,136,236,159,162,205,6,159,39,81,49,116,245,243,205,56,142,23,189,230,226,84,49,108,90,204,5,72,118,89,148,65,63,132,187,225,141,3,12,252,186,7,211,187,11,111,169,58,167,107,116,124,82,11,250,37,18,76,236,144,170,142,102,148,242,183,136,57,99,229,233,13,155,160,49,28,38,75,138,116,142,69,195,23,244,185,244,190,73,205,62,87,51,41,97,105,181,235,132,255,176,159,177,109,105,167,181,31,111,228,91,74,54,82,121,89,241,60,178,35,99,27,73,4,145,111,34,29,242,234,37,143,224,238,210,163,197,180,177,65,66,58,199,107,219,251,119,170,138,139,180,213,59,117,194,253,44,18,90,2,115,162,93,99,150,19,11,120,117,174,149,52,26,165,253,126,195,192,247,241,227,239,76,183,32,99,211,96,245,226,175,203,74,4,157,67,4,81,212,13,251,206,168,60,50,123,70,124,245,137,218,110,216,226,241,185,120,132,89,44,67,251,97,43,246,231,202,172,252,127,115,142,232,81,29,247,70,83,168,87,3,69,218,222,171,252,176,17,8,20,190,201,220,10,16,245,192,116,45,73,230,109,209,86,81,193,22,122,109,145,148,5,110,172,199,144,185,23,72,229,103,243,111,172,88,187,133,48,240,10,72,142,253,21,85,254,23,117,225,46,208,104,240,147,174,155,161,187,9,244,76,19,124,29,188,90,4,224,253,224,238,209,119,240,120,49,104,249,100,234,249,218,72,156,121,22,200,110,216,62,148,73,195,206,150,194,97,175,90,88,139,146,18,178,27,184,243,29,221,101,87,249,214,242,18,115,28,214,26,11,61,37,176,238,30,195,222,166,170,241,95,166,35,121,187,148,40,11,54,247,126,68,62,100,10,230,222,126,201,189,47,59,208,12,174,182,50,225,142,227,90,178,198,16,207,112,117,140,205,236,16,75,103,10,252,2,106,79,235,54,199,247,106,187,154,131,180,223,182,144,211,202,36,2,222,210,1,246,212,73,239,61,45,102,150,185,48,1,191,184,11,143,59,160,144,247,101,98,40,34,158,25,120,207,194,255,28,125,93,220,166,117,228,34,233,143,79,66,139,88,86,64,213,213,220,60,125,227,11,41,179,99,35,198,122,54,37,127,2,221,112,97,194,24,255,31,246,145,166,136,104,223,96,183,201,161,8,197,208,62,54,16,14,136,144,72,145,95,107,129,35,31,131,128,128,230,40,81,83,30,113,84,67,13,110,197,18,150,42,168,48,93,67,255,209,238,112,92,214,213,20,67,115,252,132,31,177,34,99,136,150,145,122,161,34,71,87,99,145,46,198,41,3,136,63,218,140,82,7,41,135,10,153,18,5,77,150,68,21,93,154,104,136,242,161,117,32,244,244,227,55,63,197,95,160,39,121,59,16,223,225,240,3,163,243,169,238,65,183,147,17,6,171,47,190,129,227,24,247,144,197,116,38,32,153,85,89,117,39,142,167,166,117,190,159,176,101,35,89,170,202,242,18,109,4,88,12,122,226,5,121,16,175,180,83,184,20,250,155,157,171,249,161,235,102,144,201,241,155,125,78,225,230,174,188,226,50,218,5,127,125,26,55,164,17,72,151,196,31,236,25,162,147,141,44,47,5,114,29,128,162,99,209,218,128,55,136,188,30,131,91,10,234,69,96,112,179,50,143,124,30,3,229,249,180,67,54,103,66,126,240,28,64,250,145,60,234,60,103,194,66,38,98,247,189,234,167,0,204,208,188,164,35,11,59,208,253,246,115,124,40,71,148,188,143,97,54,182,178,223,0,225,67,38,109,114,240,37,253,235,197,147,90,170,11,46,42,106,138,30,68,68,228,178,178,129,101,91,15,31,215,227,204,185,213,208,142,127,136,92,53,154,61,69,184,160,132,220,24,101,159,147,143,56,204,0,90,56,89,111,194,228,161,121,0,144,222,93,3,219,11,140,232,26,194,229,153,151,111,30,170,197,180,144,81,231,157,145,160,43,241,13,31,68,30,183,50,229,16,144,254,205,7,221,90,98,251,110,234,131,189,139,228,30,15,40,22,38,147,173,118,158,69,189,172,214,243,44,27,78,14,164,8,187,161,138,173,36,237,51,164,117,82,184,97,93,210,222,2,63,229,66,88,175,97,110,54,95,107,199,182,59,19,175,27,78,163,140,12,203,73,68,238,22,251,12,149,54,150,114,13,111,80,233,45,181,185,233,65,210,19,28,2,178,235,255,59,17,108,184,149,24,190,121,20,240,95,195,82,151,212,64,81,202,253,86,152,29,199,153,32,57,72,210,143,213,94,1,77,164,110,58,219,193,172,188,106,181,175,182,160,91,121,0,15,47,126,178,193,44,84,186,222,249,76,238,84,80,161,204,2,164,187,0,60,67,7,83,152,158,204,204,6,213,203,40,196,73,58,133,47,220,0,198,134,42,63,213,176,1,46,120,198,42,86,72,69,238,143,182,216,241,35,60,61,50,152,205,74,224,101,130,216,84,15,137,218,171,126,11,109,26,219,175,96,26,46,252,197,1,18,62,216,242,54,69,171,199,125,160,196,106,91,221,6,35,207,48,34,174,215,253,173,214,205,132,0,222,177,188,121,167,3,91,196,131,16,61,75,73,125,32,175,95,242,197,175,153,180,131,64,253,81,194,87,219,53,117,56,213,226,144,150,40,173,234,188,0,159,237,152,16,41,56,89,110,192,47,159,143,56,247,3,151,37,145,244,213,87,139,248,44,177,109,113,86,78,113,110,51,31,251,51,29,30,146,184,167,184,21,101,26,177,240,195,121,145,252,113,65,96,105,4,188,75,24,60,214,215,10,221,87,61,204,156,227,52,35,106,201,70,198,47,237,127,117,163,146,215,98,158,199,248,176,1,24,179,134,222,148,128,51,90,78,111,75,145,41,145,194,213,209,91,189,228,19,18,5,34,232,150,28,62,236,198,129,37,139,24,70,84,143,111,30,75,95,21,136,218,120,66,22,171,76,200,113,117,76,13,235,192,55,128,10,174,32,246,77,189,179,180,151,135,186,139,114,63,238,214,155,52,100,115,246,239,154,146,63,75,126,55,207,39,32,70,11,183,38,113,120,146,208,53,148,233,161,97,62,216,164,119,70,233,216,86,38,99,249,173,98,3,96,210,173,139,176,156,247,243,193,232,82,78,51,129,140,207,241,176,203,229,120,0,49,244,173,92,226,105,241,238,24,65,218,69,122,45,46,94,166,164,66,67,215,151,95,134,36,43,177,28,133,94,223,219,167,118,196,197,240,207,149,17,30,177,96,181,60,101,123,115,41,97,124,47,72,28,18,208,59,138,231,91,188,146,99,20,137,29,100,62,99,65,208,164,153,105,111,190,232,162,174,32,168,200,153,147,133,243,77,165,241,94,36,133,105,111,40,196,13,210,227,215,166,73,134,236,101,134,229,74,178,175,15,178,251,184,22,137,255,9,36,65,44,245,183,17,65,91,86,205,247,2,137,134,3,185,51,41,139,117,44,165,221,211,243,103,131,32,68,6,147,250,230,144,9,32,182,213,178,87,39,201,240,226,217,159,98,53,15,98,213,126,7,223,34,156,32,146,137,112,173,196,34,73,191,203,228,128,243,118,26,41,143,195,94,192,5,14,240,115,4,185,207,204,175,162,47,68,210,220,216,88,201,126,103,196,122,91,5,26,127,90,195,178,247,26,178,128,233,18,171,101,92,205,78,11,162,129,26,203,86,102,113,157,171,21,70,65,252,51,208,235,9,114,203,12,17,45,84,55,250,137,105,219,194,117,104,176,99,197,174,37,44,29,87,11,200,248,206,248,236,10,84,231,248,91,85,166,135,178,107,66,52,127,230,27,35,219,59,239,87,160,253,238,104,146,238,229,105,109,111,63,77,27,123,95,42,233,184,23,69,135,131,255,209,130,33,246,25,230,35,218,57,127,166,239,81,82,250,166,216,192,61,9,173,167,157,223,165,121,102,109,141,101,166,123,215,2,245,43,234,206,250,245,53,142,168,95,86,250,188,44,79,51,54,49,204,80,105,56,82,101,7,162,118,184,102,79,83,198,65,76,233,36,149,31,7,67,161,146,222,154,172,155,97,220,236,192,62,54,90,74,61,58,14,187,111,65,160,121,217,99,137,136,237,61,170,210,117,25,26,132,232,74,0,137,18,197,183,52,46,124,71,115,243,180,13,127,71,72,53,240,254,65,61,66,130,203,232,167,92,244,196,242,74,25,28,46,135,149,43,127,23,141,231,56,175,28,244,45,65,81,177,80,2,152,28,180,165,162,38,13,18,41,114,76,14,121,50,217,92,36,253,169,17,217,249,182,184,145,150,112,251,108,73,130,243,163,89,93,91,14,246,115,70,173,10,236,142,81,46,212,157,241,208,196,13,130,131,220,171,75,97,127,244,108,250,56,250,173,66,187,142,203,5,211,29,115,22,111,73,250,76,136,148,239,227,34,230,116,230,93,233,135,18,143,0,10,52,57,116,40,131,217,168,209,131,213,186,89,101,213,119,168,120,96,202,104,22,119,42,249,124,56,18,14,217,183,182,45,201,194,117,102,190,243,81,150,36,29,176,97,20,53,115,98,145,78,56,5,242,254,158,213,125,207,4,211,77,128,81,245,167,99,165,247,42,251,20,219,100,152,239,69,241,170,224,209,66,234,252,131,110,57,95,21,62,101,132,52,157,66,225,52,164,232,62,154,141,209,220,85,128,73,137,114,244,106,137,159,53,250,29,208,98,169,11,235,183,54,229,51,224,52,97,1,175,100,199,225,53,163,219,162,242,23,80,186,77,91,119,235,87,215,104,101,220,17,191,34,187,151,195,195,50,179,79,163,113,7,130,68,199,71,149,227,98,232,71,166,110,12,2,144,4,21,188,202,154,180,77,108,132,173,52,24,204,196,54,102,69,1,104,183,5,119,65,28,21,165,8,127,196,233,73,160,143,47,107,5,174,46,61,204,43,206,233,101,80,88,224,1,220,2,64,234,14,217,120,117,9,70,74,154,51,239,147,118,80,229,166,196,166,193,197,249,173,51,32,218,113,154,174,237,50,51,226,186,138,96,212,3,139,177,123,193,80,240,47,240,140,24,37,29,38,186,238,231,122,74,49,135,145,13,35,38,44,224,64,84,175,210,104,224,138,42,29,241,5,25,50,90,180,91,38,57,131,157,243,3,18,216,64,175,141,30,199,172,250,132,161,72,21,146,15,220,124,64,203,139,83,97,180,219,188,48,106,209,213,164,9,184,251,179,232,61,85,234,63,60,62,206,34,84,169,248,251,134,206,5,168,192,113,115,208,122,87,236,190,42,163,51,105,63,139,90,95,121,32,235,177,113,37,43,244,168,31,125,12,246,250,137,80,240,209,171,207,131,153,113,148,122,16,71,30,132,245,85,132,238,85,34,84,34,129,133,16,64,254,214,37,36,32,77,172,44,127,236,112,83,10,250,40,26,145,22,194,61,178,109,85,97,69,150,151,114,81,182,3,181,174,155,108,186,149,214,8,121,45,73,244,16,234,205,174,205,82,181,165,204,86,130,34,230,29,38,17,149,123,33,116,152,22,129,47,0,203,243,148,45,185,102,175,170,157,73,229,139,210,157,175,206,234,187,55,202,229,61,218,86,60,28,137,198,126,141,44,53,121,196,103,119,249,83,106,229,18,191,215,46,91,171,231,219,218,253,113,45,199,123,18,127,71,54,83,130,253,230,191,13,184,17,205,188,0,47,140,113,94,81,78,203,87,243,13,219,11,123,121,71,230,137,238,238,131,136,211,254,131,82,182,110,34,28,119,206,87,212,92,165,110,224,239,66,53,142,73,46,191,190,113,136,77,161,232,15,35,255,44,91,159,198,70,185,41,123,159,165,56,61,197,199,157,225,135,35,169,160,4,9,72,160,100,97,159,32,213,88,54,75,220,225,39,245,21,103,165,163,29,166,185,136,70,107,153,122,57,48,220,209,190,244,251,250,67,219,163,40,114,50,80,227,47,233,39,73,46,189,200,118,105,46,202,128,9,69,0,63,215,132,182,150,97,130,225,37,80,120,245,199,244,135,19,116,154,40,207,167,84,234,243,64,41,42,248,99,98,5,170,14,134,138,32,55,222,144,217,142,72,80,188,231,125,81,16,153,232,231,9,1,186,244,194,9,157,93,24,173,196,93,126,26,2,0,168,71,141,56,89,166,170,152,216,164,237,191,207,237,238,82,13,119,182,96,203,94,76,35,202,87,93,216,40,70,34,248,232,179,209,11,197,44,118,113,103,150,49,40,71,186,191,207,152,143,201,163,23,13,111,234,105,207,8,9,45,255,199,238,17,111,188,122,104,175,234,41,189,62,32,243,183,211,148,170,17,234,34,71,22,197,90,86,16,25,87,22,137,60,132,49,86,212,207,93,237,133,169,179,169,55,119,137,69,203,233,48,35,20,248,140,111,170,252,233,25,195,119,62,208,103,46,156,225,97,213,147,136,61,98,62,59,58,1,147,133,150,127,129,152,20,135,31,173,68,46,161,43,153,103,212,178,209,122,40,185,245,244,132,42,255,155,92,85,147,18,39,82,111,241,204,5,60,150,214,167,143,165,152,226,235,101,153,188,18,175,240,203,117,209,206,113,13,251,89,51,59,160,156,12,122,62,34,165,204,57,199,163,239,51,169,208,88,243,212,104,89,204,0,228,169,70,201,234,152,4,118,152,124,74,19,68,6,235,7,160,230,193,136,118,60,1,219,57,224,49,94,205,247,167,13,161,177,208,245,16,121,111,223,103,66,166,20,249,142,193,199,222,178,243,159,64,190,44,160,169,58,191,77,224,104,110,255,25,247,235,219,47,139,155,63,248,98,1,214,79,216,199,203,105,138,141,128,152,182,35,132,63,236,247,102,255,2,184,54,201,6,203,165,29,189,224,219,250,27,30,130,63,125,120,26,226,82,108,65,216,51,18,120,105,103,225,158,112,81,122,183,198,205,59,221,79,180,17,224,51,159,34,177,221,245,224,166,116,0,1,124,29,211,110,52,192,115,194,232,123,247,171,192,73,12,96,148,251,141,87,82,149,118,162,47,21,119,38,92,28,12,12,70,123,182,152,109,108,255,59,51,7,226,182,247,231,141,212,255,160,29,173,8,79,40,76,115,55,67,59,119,209,216,219,121,209,137,194,8,117,161,26,33,80,102,14,154,9,57,101,174,66,247,237,144,249,97,196,56,229,14,192,209,171,223,15,195,145,212,3,243,101,159,250,213,237,237,141,197,127,25,98,60,59,3,105,142,147,131,138,233,104,110,243,166,159,71,33,36,209,214,168,19,17,191,118,151,164,116,241,153,55,126,105,36,208,189,66,123,87,73,185,11,170,90,231,2,225,201,224,76,52,141,203,127,56,19,163,211,252,137,92,233,118,64,145,128,214,112,253,143,229,20,241,25,82,128,171,175,195,153,211,128,163,179,130,57,72,126,84,45,61,106,149,197,196,8,189,139,200,22,116,104,124,143,126,107,80,21,247,35,67,204,56,224,150,155,58,235,172,229,236,51,146,101,80,42,210,106,152,68,98,132,83,173,206,40,215,213,3,106,197,206,148,66,160,37,209,139,218,80,112,139,6,92,228,93,104,203,204,97,123,179,72,164,244,30,134,173,46,2,200,28,0,92,156,110,221,111,185,212,35,176,68,218,115,96,35,238,217,36,167,52,151,56,68,22,115,139,251,119,79,154,57,159,148,189,243,189,212,242,208,134,192,154,18,29,100,206,193,43,118,179,204,145,157,207,74,119,82,244,192,35,53,13,247,107,124,8,88,199,90,120,32,57,204,134,190,4,214,233,144,77,142,186,253,219,17,110,92,96,2,50,248,11,219,88,252,29,214,153,1,96,135,234,99,249,85,212,74,163,135,24,36,218,65,127,58,37,7,130,213,203,215,232,20,116,244,200,210,104,44,38,122,56,129,140,143,148,231,57,174,1,82,110,20,81,63,219,28,194,234,119,177,114,89,233,206,172,26,144,110,115,164,70,254,28,220,190,133,147,16,69,2,151,23,17,211,218,40,136,60,85,169,133,156,63,151,94,59,51,195,37,195,155,255,17,174,231,6,65,184,72,59,150,21,109,171,254,206,112,232,203,10,28,52,3,185,202,173,42,210,101,97,17,115,83,163,231,9,228,69,86,207,191,31,30,128,76,66,61,151,29,84,154,43,120,30,136,67,46,50,234,98,180,132,59,239,63,142,30,90,99,35,203,40,194,229,156,71,232,226,177,120,129,176,43,213,116,123,135,10,144,248,173,116,190,228,88,85,75,157,75,105,20,215,167,96,19,104,172,65,254,162,99,223,174,144,167,24,25,42,15,125,107,33,253,169,73,238,120,96,159,90,248,97,249,182,25,15,137,220,22,85,127,38,235,147,237,73,156,249,128,72,187,34,39,4,203,44,69,21,52,213,61,89,15,87,203,227,210,52,100,118,171,221,110,60,147,83,252,222,125,223,216,12,76,13,126,157,213,53,13,13,33,148,41,125,215,90,159,247,118,24,233,100,7,251,219,129,141,140,161,232,59,126,193,3,78,51,198,176,185,150,122,64,203,116,96,9,18,208,62,187,25,165,242,140,4,192,149,131,1,81,74,106,147,81,139,73,129,181,14,49,39,132,113,251,224,203,187,87,29,227,145,96,35,246,97,215,189,230,69,164,135,23,161,43,246,56,190,66,33,54,119,104,96,8,73,249,196,241,16,85,237,242,11,53,165,111,87,127,72,75,223,66,29,220,130,142,116,63,144,85,253,13,67,148,54,154,183,243,212,226,210,229,204,84,241,53,42,58,58,252,22,106,40,209,90,110,227,217,230,175,114,33,184,139,181,67,213,204,98,104,7,231,124,30,125,90,12,209,71,86,194,220,84,190,117,52,74,32,171,59,206,17,219,3,145,70,5,108,127,87,181,106,72,222,233,183,62,197,147,71,58,89,190,172,202,89,17,234,143,161,35,227,152,48,39,28,114,40,130,68,243,82,209,4,208,172,65,22,47,59,215,144,185,122,177,218,119,71,16,35,223,161,126,128,142,208,105,107,154,114,217,34,90,90,243,5,210,82,75,204,19,31,39,68,167,149,132,86,125,148,85,50,103,149,19,4,81,233,230,192,9,23,92,236,181,90,24,127,166,251,247,104,89,184,3,160,71,136,0,178,241,56,66,52,149,12,127,177,142,1,189,122,26,151,251,204,22,93,37,227,73,246,150,174,113,190,163,181,211,34,35,210,227,246,53,155,88,171,129,186,92,91,171,76,128,148,8,60,15,169,13,78,60,105,54,119,154,185,168,165,202,251,90,218,115,38,232,26,24,70,105,61,167,252,150,163,115,145,51,216,223,139,206,206,72,64,249,160,143,191,173,183,160,162,247,242,9,47,207,75,111,200,64,114,85,243,76,118,139,33,28,3,237,161,10,106,213,200,221,255,139,142,211,13,20,222,117,72,49,51,109,231,195,7,136,113,227,188,45,166,87,161,55,122,79,71,236,68,218,129,101,222,35,255,131,143,188,5,222,144,80,111,84,208,71,217,66,92,87,201,197,168,66,36,155,204,14,208,120,64,158,153,225,26,80,74,230,197,58,85,174,6,160,148,46,221,189,44,202,36,7,88,42,55,118,36,107,221,234,153,146,83,175,160,250,14,119,37,225,126,75,65,4,173,81,182,41,12,142,190,197,109,54,232,130,51,220,19,103,252,53,69,128,98,14,95,44,60,210,114,198,175,66,175,230,24,50,132,240,24,142,22,36,221,68,24,80,130,202,246,24,45,128,244,193,132,98,71,179,191,12,179,95,106,225,42,237,185,214,119,126,102,74,54,121,55,56,21,183,185,178,240,90,133,36,92,62,18,6,29,178,43,210,229,209,89,242,140,22,185,155,216,149,250,187,78,119,60,61,87,43,159,25,213,160,71,147,241,52,222,229,97,232,193,250,89,84,185,196,11,110,133,91,52,48,103,160,143,181,66,78,240,240,50,37,213,55,132,24,100,143,221,117,171,78,50,229,105,118,110,122,137,35,7,41,180,13,24,166,49,214,181,87,221,80,150,31,128,144,206,93,140,253,225,164,80,213,233,244,14,108,31,153,170,55,132,10,14,224,116,219,89,175,23,222,99,31,74,177,176,171,246,48,62,182,79,103,21,129,93,34,176,135,186,215,51,125,9,25,29,231,4,95,143,112,113,197,148,40,46,219,15,182,163,14,169,171,168,77,145,209,176,155,220,236,46,174,44,203,186,218,52,54,234,8,227,197,88,56,186,57,5,61,202,158,153,129,4,2,148,245,73,147,2,21,89,5,178,90,43,126,218,88,137,148,247,62,194,84,177,233,191,1,53,167,15,147,146,171,90,47,161,222,50,33,109,43,96,153,227,71,111,171,90,134,166,24,21,132,7,236,52,15,139,129,209,154,34,123,145,0,234,51,203,29,114,159,211,141,252,177,72,225,224,37,112,215,93,53,233,132,8,1,237,74,217,246,52,120,87,152,210,131,250,51,72,142,117,97,25,42,167,115,196,206,207,112,82,219,24,102,128,109,45,108,55,154,48,199,46,21,151,52,234,228,128,252,139,232,238,197,87,126,241,22,104,243,136,189,56,10,214,200,222,44,44,240,254,66,238,142,78,212,119,210,76,63,18,101,149,185,198,12,131,159,59,196,2,122,103,25,17,101,156,196,134,46,245,174,228,215,6,142,192,95,69,144,156,53,79,169,186,112,190,64,33,83,175,7,6,167,137,201,129,240,146,180,145,106,169,163,99,78,112,248,138,152,243,216,47,218,180,142,100,161,94,12,178,89,64,124,0,243,210,1,191,229,62,207,247,40,202,246,235,109,177,153,42,128,103,59,250,204,115,64,136,250,212,112,52,220,14,35,14,176,62,153,247,132,151,196,62,79,250,48,165,149,74,80,210,222,139,52,143,246,53,36,149,79,90,119,101,194,231,205,25,171,6,69,166,186,83,37,217,20,174,17,203,21,182,208,35,204,180,217,47,43,114,251,164,64,87,181,249,153,231,150,32,7,9,63,21,187,129,209,199,102,187,32,135,183,172,69,1,121,54,226,124,255,105,21,100,161,120,116,104,73,55,121,125,70,182,43,36,35,171,228,174,142,3,127,171,69,33,194,230,53,145,8,50,190,213,186,150,58,132,219,143,125,250,194,82,166,40,73,37,15,191,131,87,221,217,165,224,185,68,211,151,4,232,24,65,218,153,3,194,127,76,230,254,143,16,92,88,129,214,78,51,25,161,254,159,67,49,117,68,113,110,153,24,162,124,236,26,138,56,76,206,107,210,32,132,215,137,153,127,76,8,46,174,88,185,46,143,210,93,235,64,145,228,247,243,122,193,38,90,231,136,10,117,106,22,208,191,212,18,160,240,12,238,215,140,156,202,115,108,251,81,38,232,91,252,171,65,45,78,148,166,207,216,16,90,124,117,90,163,18,160,175,17,14,222,33,216,109,99,210,232,49,89,254,29,152,173,43,118,246,168,80,44,207,200,151,254,217,146,20,82,207,0,201,133,188,36,138,51,157,25,1,25,55,250,100,194,108,207,106,207,7,3,207,179,212,83,217,145,116,199,194,246,53,36,52,225,227,169,180,190,142,125,74,159,163,20,46,59,89,73,155,26,222,216,9,95,18,217,58,25,129,108,90,78,214,27,88,227,243,100,35,35,182,19,149,170,205,226,208,223,65,13,13,164,88,158,190,96,182,124,187,208,45,18,168,133,160,18,36,13,129,84,228,167,147,229,161,167,189,202,78,251,46,104,111,171,59,171,144,166,126,29,141,55,196,232,209,47,187,209,18,126,159,93,119,74,173,221,75,24,126,141,189,48,4,41,136,188,40,129,8,139,182,246,186,29,168,230,174,116,245,232,219,108,91,166,58,237,94,56,59,161,46,204,106,133,148,196,158,177,99,9,157,180,205,155,126,229,216,249,99,61,188,96,43,20,54,93,220,171,150,120,155,155,98,11,171,116,129,47,46,207,74,205,115,193,230,188,103,88,174,246,208,13,116,39,132,218,215,158,97,141,189,220,122,25,29,168,37,74,241,111,190,111,71,66,230,150,107,154,181,223,202,117,108,195,243,194,232,152,135,239,59,19,116,31,57,76,12,129,142,227,190,254,17,58,164,91,51,126,98,175,174,219,226,200,41,242,126,84,85,233,100,145,246,19,143,186,120,32,254,41,233,169,232,51,47,89,30,43,29,248,34,13,143,61,136,141,3,26,165,178,151,139,84,239,68,138,134,8,211,247,131,110,13,102,193,63,160,68,17,81,129,0,122,51,122,85,221,0,119,192,73,235,59,233,147,237,176,158,225,97,202,177,89,65,104,18,209,92,182,124,35,194,212,189,173,158,197,152,248,3,102,116,118,45,178,138,92,246,157,52,88,153,2,227,20,80,12,173,159,137,159,253,45,2,45,179,224,216,95,36,56,180,86,180,70,198,198,205,165,215,143,38,154,73,114,80,237,196,18,217,179,254,125,197,51,160,135,242,76,83,4,70,62,72,100,13,163,111,175,180,237,169,75,59,121,54,88,53,117,146,38,204,64,67,204,82,216,27,250,242,245,160,190,166,168,243,8,20,162,240,76,126,159,74,47,138,78,109,242,80,49,242,134,83,24,242,213,16,253,109,254,110,207,209,20,97,98,187,115,54,127,234,145,175,186,191,198,206,223,60,236,109,212,229,184,126,242,64,87,176,105,237,88,144,105,4,165,96,171,36,202,30,145,186,104,50,207,131,199,106,78,11,96,157,10,188,74,90,48,162,142,131,82,242,185,3,137,14,208,99,59,106,55,155,198,40,164,154,246,234,228,185,127,176,190,109,83,173,139,113,56,115,202,88,14,78,141,253,2,178,69,54,209,215,76,16,124,124,247,159,34,104,50,92,236,102,83,91,68,180,57,240,14,146,38,38,201,73,77,10,220,8,182,198,240,236,212,223,251,138,160,117,139,90,237,61,16,139,7,21,44,112,77,97,247,33,14,172,152,7,0,208,114,175,236,83,206,135,7,90,186,213,58,141,207,219,132,128,109,122,84,110,54,58,55,231,13,7,48,229,200,199,66,251,183,233,125,189,31,53,183,39,5,141,24,41,74,89,228,22,107,153,66,183,40,6,94,30,223,116,164,188,77,238,209,81,115,63,114,209,113,62,18,199,47,124,238,3,42,171,190,1,102,248,110,81,110,11,223,139,39,175,136,155,176,51,204,212,124,10,178,176,210,116,143,111,103,41,73,96,78,54,254,0,90,61,195,101,229,185,175,156,132,244,34,203,184,42,39,148,192,102,11,103,19,72,230,88,85,214,76,130,247,157,201,195,62,67,163,123,158,147,88,0,5,15,121,143,141,240,182,57,165,141,43,147,117,22,144,213,115,236,146,200,241,130,159,167,190,65,74,94,27,241,5,252,145,218,119,39,47,59,251,186,206,12,252,89,70,253,240,88,22,104,67,206,181,35,32,146,231,46,137,253,192,84,157,101,106,12,2,39,233,156,75,178,85,255,254,146,177,24,54,207,231,22,203,60,26,197,132,164,141,161,101,109,209,156,7,194,79,225,53,207,254,144,163,149,4,7,229,178,19,22,126,195,176,156,74,56,140,230,157,35,246,29,26,175,224,214,78,106,76,1,128,67,65,33,184,158,77,3,100,198,227,86,115,111,12,184,202,29,247,8,29,10,126,90,93,244,182,234,117,41,234,47,207,130,116,150,234,116,170,67,151,193,194,200,175,154,117,125,114,187,182,76,26,112,235,51,56,130,235,119,148,61,36,131,234,168,96,16,211,158,56,85,71,13,169,19,69,250,135,166,93,33,119,217,144,81,87,234,235,69,200,144,205,179,31,216,177,3,189,78,66,41,242,141,96,6,10,61,154,101,78,131,225,60,65,153,13,249,246,164,29,132,22,119,240,148,80,118,233,238,45,212,144,17,196,132,86,94,74,11,180,234,141,92,34,89,41,21,48,6,49,176,38,254,21,192,5,235,220,155,132,59,245,28,68,146,94,229,0,217,188,145,239,28,61,68,205,240,25,127,0,65,213,57,204,62,29,28,47,60,89,167,82,91,106,121,201,156,253,212,197,239,248,42,178,122,21,134,188,159,97,21,127,78,225,176,204,223,159,91,217,205,140,90,199,230,51,248,26,3,98,145,117,105,50,3,0,81,80,83,90,7,245,101,76,216,165,120,167,245,107,93,218,104,13,29,105,60,234,195,137,26,200,229,65,111,198,133,63,226,27,134,182,218,172,138,90,224,165,52,109,179,237,147,146,109,246,172,250,114,219,70,152,237,119,239,54,27,70,95,60,125,24,107,89,132,153,1,162,242,14,148,41,109,227,192,129,78,83,249,67,202,99,11,73,31,220,114,242,124,39,154,133,101,22,33,109,51,120,10,203,177,112,74,189,201,69,155,56,68,238,226,68,144,44,233,132,208,20,60,231,5,47,7,43,255,192,7,39,54,79,131,70,24,30,70,188,192,11,241,17,93,42,138,243,161,154,189,217,255,169,142,68,253,48,147,164,26,77,121,20,1,205,214,47,104,7,246,16,11,74,45,52,135,202,0,65,194,0,211,252,201,182,173,112,50,145,154,203,70,62,183,177,80,176,170,115,177,147,46,230,38,110,22,162,104,43,11,85,202,29,231,113,254,21,198,213,111,132,152,123,40,161,215,68,53,214,36,251,69,170,22,220,83,4,216,64,203,83,95,79,139,230,203,44,61,139,93,235,12,137,114,171,228,206,160,18,51,93,134,56,78,191,216,146,242,211,27,90,109,79,205,105,90,170,58,235,142,174,42,159,6,113,247,143,233,0,137,249,149,68,101,175,167,122,158,116,200,183,6,11,45,232,57,138,55,248,159,96,17,127,249,193,197,213,146,147,162,222,24,223,115,68,124,21,122,102,113,67,225,124,35,174,205,249,192,190,239,146,133,0,175,154,18,113,128,127,3,84,182,43,107,8,42,17,98,206,149,139,147,108,221,247,51,146,204,42,195,27,51,91,200,58,50,217,120,50,241,125,142,123,154,232,148,195,5,59,22,141,242,170,120,139,131,211,95,185,34,80,204,121,173,182,164,59,160,229,215,69,67,111,26,35,244,90,72,39,45,153,1,156,13,169,236,16,94,162,79,105,158,222,217,155,229,60,195,31,25,245,28,112,86,149,72,48,251,144,26,166,223,82,130,93,79,184,189,140,17,165,30,42,150,211,83,203,161,249,186,170,5,65,153,67,56,93,29,132,153,121,75,98,143,114,63,27,85,147,99,48,82,98,160,201,173,47,202,174,193,166,242,13,109,68,204,64,16,109,127,168,208,168,33,206,236,92,1,253,49,161,56,172,32,129,203,16,76,77,64,51,62,6,43,85,121,243,255,135,218,112,146,254,254,107,126,6,84,229,159,46,212,18,205,166,193,176,165,84,88,167,108,45,48,56,28,184,12,31,229,52,144,177,94,69,82,94,62,176,229,197,202,57,186,239,242,236,111,181,204,107,27,59,100,5,194,83,219,132,44,196,24,219,59,240,142,84,83,5,158,174,228,235,226,232,187,117,102,136,26,37,187,86,97,215,201,154,145,14,65,124,137,54,167,151,106,182,229,100,37,162,212,30,1,209,219,246,82,213,201,250,234,5,138,148,218,227,172,176,181,61,37,1,183,49,115,232,63,14,181,123,159,82,222,198,7,227,172,234,31,207,6,207,172,242,54,90,105,18,161,180,124,172,162,167,94,92,0,21,80,245,154,104,20,255,242,112,25,19,191,35,143,100,229,146,149,73,172,228,240,24,217,78,26,85,124,48,57,111,238,32,170,58,111,112,117,18,110,56,227,251,114,141,79,195,152,184,95,114,30,77,48,166,81,23,150,187,238,9,10,95,211,150,183,198,5,141,124,176,75,177,7,200,186,53,89,17,106,127,221,31,116,0,208,76,217,204,11,187,181,237,240,249,225,189,90,212,118,146,5,177,83,223,41,91,230,190,208,172,42,255,138,246,141,122,222,21,131,225,62,161,60,61,20,118,255,4,16,74,27,159,115,12,200,162,37,199,167,123,83,123,246,74,177,196,251,90,218,215,122,217,7,88,190,252,174,191,141,35,27,242,105,36,34,30,113,168,248,108,192,105,15,216,160,217,80,101,125,186,157,199,116,34,129,155,89,46,68,220,114,92,246,43,245,159,244,16,1,153,15,238,5,86,50,140,207,251,110,36,79,233,172,165,36,88,78,230,131,94,94,90,230,204,203,142,229,38,205,2,213,174,25,31,129,247,71,156,3,237,111,156,64,14,137,228,125,107,5,17,80,149,57,104,220,254,171,145,162,108,159,30,201,69,102,86,226,57,217,203,172,254,125,202,226,191,38,178,120,160,140,144,123,88,250,117,21,92,221,89,236,111,138,184,9,43,53,190,204,231,127,150,99,151,11,35,165,126,249,23,16,112,191,129,117,32,154,246,131,234,57,112,66,160,5,205,197,114,147,40,132,159,133,44,186,194,217,234,74,47,126,145,241,45,152,234,238,233,168,75,123,232,144,91,87,185,203,96,232,62,74,12,35,13,1,59,76,101,128,3,218,204,99,122,121,33,40,129,5,0,177,114,110,146,176,205,112,79,25,212,232,138,152,122,115,247,151,237,72,215,175,38,67,0,92,188,243,218,55,157,180,119,34,92,112,22,86,181,121,36,216,137,169,121,199,161,199,177,9,160,255,242,117,253,211,101,164,3,147,205,130,153,109,125,32,154,82,217,182,82,34,141,65,215,130,38,179,244,194,188,177,64,217,111,188,15,83,192,143,190,35,155,116,228,54,156,37,229,106,225,1,96,20,72,27,142,223,148,82,178,115,204,221,59,189,195,244,205,168,244,143,126,88,191,183,147,47,253,54,137,104,62,163,75,240,117,113,199,210,132,133,59,60,62,154,84,67,4,79,229,149,224,58,67,254,5,183,60,96,53,195,183,231,173,220,165,151,181,141,113,94,27,15,89,157,34,254,241,189,248,68,186,180,246,108,62,255,59,114,204,100,239,146,21,43,11,199,90,15,250,226,148,123,183,101,50,78,22,159,95,158,250,145,30,147,176,22,225,10,205,31,10,116,3,56,54,157,195,13,134,103,194,161,242,34,69,131,236,202,126,115,48,73,134,131,11,105,255,214,175,122,116,181,19,223,218,174,27,178,23,38,6,65,202,198,52,221,2,183,198,92,90,53,51,5,172,158,141,188,210,241,126,161,218,50,47,228,126,41,204,231,88,253,45,177,158,103,20,125,231,101,238,113,90,107,163,12,178,152,36,6,37,11,51,147,153,240,191,90,13,108,115,197,93,229,33,214,214,180,28,205,220,3,159,20,124,183,127,193,170,26,84,144,249,214,53,113,13,207,141,110,46,160,136,145,217,47,10,254,105,78,2,192,249,208,76,106,139,41,41,142,85,231,224,113,6,207,109,106,126,28,192,174,182,175,16,208,59,151,177,27,252,44,179,130,234,108,103,235,249,79,43,48,99,217,129,99,174,133,153,32,35,127,214,226,127,107,57,203,142,242,17,160,235,126,198,248,44,249,143,190,104,204,47,178,133,170,63,172,188,169,210,127,230,59,237,49,240,49,245,123,116,167,204,60,90,24,25,245,148,115,232,170,232,235,95,149,40,201,59,150,103,187,164,128,86,94,166,58,230,55,102,5,163,243,158,238,248,114,46,163,49,127,72,20,62,155,211,132,255,81,134,183,179,145,91,34,233,155,29,148,210,14,242,146,78,103,200,67,237,201,176,157,16,74,81,118,155,105,216,79,227,126,2,45,11,192,159,207,9,66,36,105,123,172,129,168,8,168,150,213,26,238,165,31,120,103,106,34,189,209,38,140,102,249,215,66,40,237,234,73,13,40,95,175,130,21,15,33,89,231,65,148,115,68,133,124,223,226,149,106,33,196,149,87,102,112,124,32,215,73,9,150,53,75,154,106,88,99,155,246,98,225,255,227,232,76,235,41,75,243,96,68,54,53,125,16,160,186,21,25,22,246,209,167,32,205,66,103,205,54,171,211,218,238,207,46,188,221,81,87,177,47,177,77,12,89,187,114,202,152,145,196,101,232,211,182,42,117,10,5,149,2,245,76,155,109,249,200,209,234,178,33,148,217,104,246,193,128,78,115,70,1,196,73,179,127,124,225,1,134,48,102,47,213,197,177,60,10,69,184,158,152,113,62,28,105,50,117,208,190,164,172,154,254,141,73,96,32,65,199,99,47,4,37,214,105,137,253,252,184,165,160,64,189,61,231,69,205,77,144,59,167,166,187,127,90,28,109,152,183,83,90,42,101,252,53,75,158,244,19,123,160,5,177,52,226,136,186,205,239,154,213,239,1,170,31,78,194,103,0,122,127,37,252,152,85,48,88,159,139,203,34,21,215,42,247,221,137,84,79,23,215,174,7,157,214,137,222,28,163,50,86,84,71,113,33,228,53,207,199,26,142,133,165,164,255,89,169,226,56,35,78,196,155,249,217,107,161,100,43,20,173,167,199,220,212,184,183,211,113,80,77,33,125,224,122,187,54,189,56,134,6,182,63,39,196,122,230,90,108,6,245,102,130,151,152,29,160,191,66,249,137,121,255,246,169,70,149,63,93,195,93,219,111,237,9,207,189,24,33,91,143,70,234,161,91,165,47,159,114,108,157,6,249,55,83,47,145,2,76,48,2,19,173,154,15,246,148,63,68,198,97,246,130,113,219,36,114,86,0,175,18,84,201,234,167,28,214,61,240,107,56,182,255,187,205,139,18,1,114,63,217,84,57,80,80,211,149,180,3,136,248,27,230,206,75,57,14,85,79,139,44,140,233,159,75,181,185,121,174,224,27,136,42,21,114,18,229,88,187,17,193,230,210,174,190,30,211,176,245,193,209,105,233,162,159,69,0,37,187,193,101,42,18,4,204,168,246,170,204,187,185,148,53,40,108,209,51,144,206,29,143,67,228,54,145,88,54,246,171,253,84,147,183,236,92,197,94,113,99,77,255,95,26,139,183,5,26,13,250,166,32,12,29,29,222,223,77,120,216,164,180,190,131,129,132,249,15,86,63,243,32,83,3,69,182,203,247,141,165,86,145,30,236,199,71,93,224,234,178,203,70,75,137,204,138,121,206,102,221,19,246,76,2,149,167,55,11,127,57,196,191,86,88,250,203,242,120,57,109,97,10,47,198,98,118,108,87,183,150,19,62,54,198,142,35,67,230,254,171,227,58,66,233,128,114,133,23,145,24,147,5,55,91,202,172,11,171,118,86,78,74,10,37,24,231,194,27,150,170,73,109,128,251,3,38,6,21,232,220,180,46,21,64,93,181,220,150,102,226,241,228,50,0,66,47,196,157,179,215,97,13,166,127,83,87,255,135,242,223,62,160,89,219,93,188,81,161,37,69,27,180,199,40,145,237,150,229,59,50,211,236,51,118,168,133,185,115,114,80,112,127,149,6,58,69,173,43,183,138,111,231,136,217,91,196,88,136,241,77,60,30,166,223,162,124,44,30,9,72,16,21,234,103,142,50,205,121,45,72,1,219,129,144,169,76,161,81,191,141,206,157,49,125,89,190,21,156,56,16,2,24,253,241,129,208,200,142,225,187,104,93,143,187,79,76,147,123,53,160,166,130,165,118,80,145,135,238,8,31,250,190,22,92,225,146,114,114,77,80,209,131,16,33,75,59,175,243,16,106,195,217,173,218,171,39,55,159,252,179,218,82,221,87,159,53,84,200,77,104,117,173,55,182,126,167,224,131,109,73,234,21,17,63,80,77,201,4,195,236,211,167,26,217,91,164,119,249,115,107,1,54,106,241,157,75,9,94,233,215,242,111,150,39,183,40,99,49,220,0,1,66,239,118,24,130,63,205,231,107,195,133,238,237,183,172,32,234,3,44,32,5,149,235,122,183,102,220,40,205,238,75,154,26,74,96,20,74,191,34,3,106,209,242,128,78,22,194,250,76,80,107,189,148,226,113,103,66,49,80,92,82,109,115,232,235,41,220,31,25,179,51,96,6,222,68,3,144,159,24,18,197,99,225,92,54,115,78,81,49,160,135,3,142,55,252,148,247,132,242,232,112,123,60,239,245,60,0,168,185,13,221,79,10,138,126,242,54,41,40,162,253,112,98,55,118,246,241,238,202,38,44,72,25,152,13,49,127,173,107,154,35,144,188,9,64,245,235,21,77,123,16,138,166,182,7,144,228,77,254,245,58,147,45,76,190,133,201,3,148,127,116,230,34,72,117,32,112,54,197,12,226,194,91,186,32,162,85,129,186,156,159,252,20,90,34,187,208,28,106,201,149,153,218,69,92,216,255,122,60,30,216,208,161,98,78,118,108,61,225,26,51,92,145,77,163,17,69,233,129,37,254,196,218,29,236,160,28,131,62,222,204,250,4,122,9,58,58,110,68,130,154,86,218,59,147,247,54,178,79,36,111,134,25,37,20,103,39,213,152,25,217,222,66,172,80,94,134,250,25,157,193,94,181,95,16,13,112,81,237,245,13,38,66,240,3,219,172,123,120,131,88,104,146,125,163,60,246,32,236,153,104,36,200,203,59,6,25,243,114,180,191,207,197,192,95,99,241,62,6,77,8,245,15,57,244,190,148,181,106,60,33,195,0,145,228,22,146,188,250,10,222,239,18,58,111,6,94,203,77,240,66,139,73,221,238,29,24,225,61,184,176,41,114,102,197,238,146,218,54,126,80,239,254,108,7,157,152,27,57,102,81,251,182,82,119,130,71,47,191,82,77,250,76,193,250,110,26,99,119,97,14,47,181,6,159,36,212,12,65,166,115,250,143,149,58,13,98,34,107,12,85,4,235,121,147,175,14,120,217,74,186,13,27,11,149,223,125,215,67,201,117,52,213,136,189,155,62,77,140,167,177,6,203,208,242,11,11,38,7,164,23,181,35,167,53,143,240,128,48,15,202,203,181,136,55,1,125,102,224,116,160,200,90,217,221,43,15,234,19,204,214,250,47,238,223,174,217,32,54,49,254,180,182,147,45,94,189,5,187,73,222,37,90,7,57,216,66,91,7,149,46,207,181,160,97,224,242,222,131,94,83,105,136,83,79,214,12,245,220,75,235,204,17,53,127,198,22,73,43,65,161,10,85,103,199,137,25,23,226,53,4,104,76,36,235,110,2,237,146,255,11,174,198,231,101,104,56,199,206,79,100,234,67,160,94,129,37,246,213,17,216,120,141,10,109,144,22,132,80,70,60,77,193,93,51,79,237,248,42,242,128,131,54,165,15,106,41,12,168,24,151,198,207,51,213,8,160,113,122,78,31,190,45,158,99,47,182,160,247,1,72,194,83,184,164,104,3,238,151,5,36,30,68,31,207,200,95,135,199,141,240,131,108,16,233,12,10,209,121,128,212,1,107,40,154,90,3,62,3,171,136,174,119,87,143,100,36,221,32,216,34,69,156,184,155,2,218,198,176,190,25,212,200,166,91,41,111,137,156,148,182,254,191,154,249,163,246,60,201,119,204,36,70,96,64,141,25,178,71,238,250,90,246,67,147,229,149,43,63,202,32,116,229,96,211,105,63,38,103,214,100,196,137,137,218,65,14,103,70,149,245,55,15,138,218,232,32,150,161,120,96,68,217,101,79,28,235,191,192,153,122,40,67,92,52,149,102,5,185,212,58,137,117,103,165,194,47,250,143,39,36,58,77,106,255,159,95,104,164,223,239,244,110,232,70,176,49,87,47,155,31,1,252,97,218,189,23,22,184,27,202,202,34,47,248,203,5,240,118,230,182,255,5,138,215,64,111,34,18,83,51,225,147,241,164,243,103,146,155,175,149,28,192,15,162,31,81,110,100,128,183,92,253,227,190,89,17,80,219,224,29,136,114,235,69,37,220,108,156,230,13,121,45,252,136,130,130,122,95,221,179,76,23,165,42,92,43,167,12,198,230,87,116,57,5,42,207,18,108,72,13,208,200,115,242,142,198,50,108,185,185,251,122,168,61,169,74,199,147,11,132,164,84,22,83,109,132,218,126,72,136,171,51,173,162,35,207,214,251,63,6,7,52,238,186,182,94,44,69,242,196,247,58,86,104,181,240,60,3,37,226,0,45,229,174,141,229,60,61,173,150,167,31,186,121,139,85,92,41,28,129,72,93,19,143,60,204,36,251,163,228,150,224,80,80,124,10,210,2,77,74,191,43,85,249,232,80,100,26,130,212,136,143,68,72,54,86,11,95,141,176,151,155,138,62,240,237,250,7,96,49,95,172,23,157,156,109,254,157,64,92,213,248,1,187,47,110,211,213,60,56,243,73,41,255,103,180,110,146,164,5,137,132,28,72,169,51,127,145,245,103,53,211,223,86,16,67,163,217,235,160,191,139,211,0,199,144,136,97,135,2,84,132,72,172,255,252,57,28,48,167,222,23,168,90,38,228,161,250,57,230,88,190,213,39,73,25,247,128,192,71,130,36,149,202,252,91,50,221,32,108,56,140,63,243,16,136,170,171,116,28,16,76,241,140,57,6,18,181,222,206,202,79,139,246,192,173,189,101,215,166,128,71,220,250,129,254,44,176,86,237,165,36,42,120,82,61,137,225,35,119,11,209,149,99,69,168,58,207,198,178,79,37,35,109,227,115,104,96,95,207,181,230,173,171,141,170,23,45,219,90,207,1,201,211,166,166,186,164,130,111,78,67,238,27,99,27,221,135,53,116,76,73,12,9,67,139,145,150,67,22,183,179,100,216,52,97,197,137,29,240,71,199,118,191,134,170,83,237,235,156,237,56,119,250,154,155,55,250,158,45,195,93,59,22,224,205,50,148,72,250,107,119,136,138,190,103,64,151,218,37,102,212,104,204,61,71,143,45,230,25,186,115,62,211,240,168,81,207,155,153,243,4,102,122,193,107,91,55,86,59,18,107,152,235,108,205,95,76,76,233,40,221,139,250,181,214,13,51,143,188,98,124,190,117,46,168,68,50,144,42,127,147,14,123,18,227,169,232,99,181,176,232,91,126,85,103,219,47,84,19,33,168,189,29,7,149,218,147,152,0,219,209,46,231,168,44,19,227,204,85,209,43,34,240,190,188,79,43,187,216,141,20,169,243,190,157,228,110,130,185,43,61,69,194,35,227,4,238,248,250,47,29,180,5,130,118,15,158,81,247,24,216,234,89,188,227,137,130,124,151,16,244,245,111,91,41,98,69,70,26,235,207,205,174,249,224,2,243,164,109,24,27,92,80,21,126,121,199,68,216,46,160,99,12,57,139,126,137,221,108,236,147,219,247,3,86,46,187,226,20,102,109,128,0,99,115,121,87,76,158,101,178,103,88,150,179,62,150,188,190,241,201,122,32,56,218,79,194,166,162,141,180,66,242,130,163,89,144,39,48,180,102,155,44,137,228,129,102,20,238,100,185,15,121,117,207,216,176,204,118,235,116,144,48,144,130,180,50,11,189,229,241,187,212,13,140,101,129,38,84,198,44,146,169,204,126,88,154,115,245,63,168,110,161,158,35,30,0,38,131,240,143,199,107,204,157,158,128,50,109,51,13,177,159,63,6,3,144,15,181,34,97,191,8,210,95,153,166,183,135,108,91,200,15,50,118,221,166,142,1,107,229,118,58,83,159,54,27,252,26,237,146,197,169,249,245,241,127,121,160,122,203,68,142,64,217,54,39,53,43,124,213,11,3,245,242,114,188,235,187,221,222,98,72,234,37,132,114,183,224,153,14,7,78,100,172,230,168,46,215,148,217,69,231,183,85,54,19,83,180,177,251,52,120,162,15,150,27,102,98,20,146,81,141,33,229,123,51,244,101,89,111,238,14,246,206,146,3,251,175,20,117,82,58,25,138,241,9,111,235,185,136,172,53,183,215,168,94,31,188,53,213,51,110,21,76,191,159,129,169,170,30,10,119,12,79,251,191,51,238,145,175,249,248,24,77,117,235,42,47,198,169,100,210,144,120,219,115,55,209,233,75,250,228,132,200,132,187,10,237,203,36,113,58,137,7,129,196,124,46,206,255,82,255,125,2,176,221,212,101,225,181,165,240,97,44,138,42,217,240,51,201,217,4,105,142,79,178,33,93,91,238,224,195,25,63,46,48,9,26,87,95,214,234,93,120,178,231,170,165,220,85,207,199,237,16,99,4,26,210,12,130,69,63,134,148,86,48,65,249,23,117,243,47,61,64,56,214,133,189,50,222,95,218,125,236,55,10,96,127,164,85,105,68,93,64,245,38,32,236,51,202,161,226,243,207,78,243,213,132,13,115,219,189,212,80,13,37,222,171,4,231,253,117,135,218,73,68,206,197,2,6,4,86,16,28,103,26,250,247,157,185,108,252,80,218,157,45,97,22,156,7,225,144,45,195,95,94,11,129,131,135,97,139,188,254,233,241,27,66,12,167,77,102,136,70,84,18,200,50,215,83,51,165,221,196,115,166,241,202,210,9,254,204,217,168,141,162,217,151,102,83,34,138,222,113,125,133,254,60,153,127,249,155,113,1,167,234,114,253,13,248,213,111,50,90,49,187,246,161,147,24,213,30,168,140,37,247,70,203,75,244,110,48,201,137,163,42,161,28,194,222,22,97,12,85,106,178,74,13,74,129,229,77,242,192,146,243,205,44,111,229,92,112,64,40,222,213,160,6,129,236,206,75,244,234,80,221,255,26,123,111,182,17,50,84,216,131,197,35,9,158,106,179,142,175,170,193,4,6,102,112,244,55,1,13,152,58,39,181,97,205,114,195,187,157,168,133,226,79,121,23,34,127,75,74,228,158,107,171,187,126,199,140,49,249,185,252,106,221,78,153,167,196,75,62,45,114,6,245,83,80,248,190,41,242,88,6,183,88,97,8,149,51,208,36,16,163,81,15,1,102,225,159,86,148,36,176,162,224,31,10,231,27,229,58,193,197,232,32,56,250,188,50,102,158,58,193,111,38,20,154,179,13,12,86,91,98,160,187,235,52,83,238,34,116,7,15,101,241,242,158,64,250,131,230,98,0,138,21,162,23,43,143,12,175,27,177,46,77,172,214,219,235,133,135,183,89,4,187,196,110,211,48,210,53,241,123,0,111,82,176,225,51,107,206,32,121,166,11,57,24,241,240,189,146,45,110,79,83,56,92,45,255,244,70,225,131,102,19,218,16,127,222,9,42,43,197,165,7,245,135,225,152,61,50,184,208,39,96,172,104,138,148,86,178,3,211,16,102,40,89,63,255,146,63,101,141,132,67,252,21,229,219,151,47,47,117,74,166,229,188,109,59,64,194,228,226,74,171,209,176,33,112,63,196,172,193,233,6,21,180,36,64,115,81,254,106,233,253,202,216,33,191,31,251,81,146,115,19,146,2,70,162,236,10,232,105,1,239,105,84,195,124,16,213,97,255,222,32,157,215,164,242,210,163,114,191,241,125,159,103,51,29,205,117,5,164,87,95,67,107,144,57,234,240,186,176,106,216,168,172,48,84,210,248,160,187,119,70,243,85,49,101,37,242,111,17,158,109,223,136,209,107,218,44,102,152,0,35,134,169,87,232,167,208,246,164,180,191,154,155,254,106,153,211,56,78,100,5,180,46,203,253,131,45,153,32,7,241,90,36,145,231,251,85,120,105,248,215,80,55,199,232,158,221,34,248,251,213,28,41,229,104,71,254,57,85,187,161,19,106,170,115,217,152,207,140,220,202,63,26,47,204,134,4,26,172,227,79,191,109,203,166,154,167,133,172,110,73,87,80,24,147,81,39,204,179,227,43,205,125,179,203,152,224,72,146,71,207,205,73,51,15,91,191,157,123,17,36,193,216,145,80,45,34,34,254,124,241,15,222,145,65,107,73,90,156,148,58,119,245,213,242,187,125,116,192,100,11,111,210,216,142,106,254,140,236,147,116,127,24,253,25,218,213,234,153,174,237,124,239,214,254,88,236,45,209,233,112,126,184,56,224,134,107,184,18,167,126,189,90,172,102,43,248,166,33,251,145,173,252,167,90,41,67,94,184,72,36,181,24,237,26,119,28,106,139,38,251,145,99,30,72,170,175,67,216,39,231,127,221,16,90,197,104,236,91,90,222,234,217,109,170,212,24,199,45,64,167,137,173,100,194,247,197,45,39,22,109,138,79,87,160,206,129,94,174,221,129,116,99,52,126,211,38,51,14,132,129,15,159,38,130,130,165,226,73,98,60,220,12,112,90,92,91,147,240,26,212,210,81,143,226,114,245,84,70,238,242,201,22,141,31,162,27,103,36,147,58,15,67,35,226,91,97,212,132,26,156,74,88,65,134,154,151,75,114,148,194,46,49,77,104,32,199,6,30,118,228,164,2,98,142,164,230,225,120,61,177,57,101,210,141,11,27,234,231,128,157,75,186,203,20,167,75,158,158,158,155,136,207,142,139,52,176,10,23,159,129,243,204,128,50,210,118,31,181,146,116,104,130,49,242,126,30,48,116,47,83,41,158,165,123,187,56,149,64,237,89,125,59,252,91,213,252,198,157,53,189,111,191,171,54,13,224,42,244,182,98,148,147,120,87,207,10,22,60,117,254,57,226,207,28,228,183,143,56,204,20,146,22,104,83,49,72,132,107,255,135,146,7,116,57,22,98,115,60,252,172,204,135,242,142,222,186,112,127,255,230,15,207,96,168,229,141,243,65,180,132,139,114,121,32,18,18,40,254,109,168,29,138,110,215,196,23,152,26,213,47,222,57,105,252,181,126,45,179,10,238,147,143,52,222,178,156,146,80,111,77,250,247,76,222,71,79,136,117,186,11,18,2,206,200,152,201,94,138,91,202,170,27,22,144,139,1,201,23,227,228,26,47,127,59,0,206,122,133,75,96,170,249,109,110,82,173,213,150,8,24,141,17,32,71,73,152,252,79,240,100,248,12,11,131,34,162,114,231,112,254,42,202,209,172,216,19,183,9,121,95,175,122,58,112,60,247,149,60,253,226,0,34,238,131,10,131,30,251,77,163,254,37,255,228,171,118,71,64,24,176,78,110,115,129,68,174,50,225,96,248,112,225,254,13,182,174,208,63,152,123,62,223,149,202,201,40,49,180,68,255,76,143,67,155,190,45,223,39,222,43,48,135,227,197,231,157,47,126,83,16,227,180,102,54,178,242,238,175,4,59,250,25,142,18,193,79,206,121,155,74,30,231,9,214,57,245,145,40,55,65,104,59,168,75,227,131,171,188,154,144,130,226,106,48,109,246,233,85,209,66,28,66,47,77,21,44,75,119,219,151,149,67,138,223,119,244,11,246,127,17,131,119,222,154,121,69,170,31,8,45,245,60,207,108,24,132,13,194,218,53,9,199,19,35,21,236,92,69,130,126,59,227,245,173,12,47,165,240,87,5,229,209,247,62,90,52,63,230,0,174,72,90,154,177,152,9,89,163,176,104,147,221,7,206,219,209,8,195,249,73,28,173,109,66,170,188,157,41,61,143,189,191,211,168,252,215,176,241,121,252,253,114,21,217,69,7,12,38,66,72,171,171,137,190,101,255,25,201,153,12,63,184,53,1,207,152,162,72,167,176,133,189,54,32,187,60,145,118,117,38,183,150,108,44,124,118,194,242,208,91,132,120,161,79,166,139,232,203,38,5,200,52,116,180,109,45,255,228,222,237,107,2,191,15,37,6,109,97,164,213,251,107,101,133,44,202,238,1,107,243,186,102,167,8,159,158,123,128,85,42,231,122,208,62,103,184,167,160,28,13,127,182,53,11,1,155,178,196,195,100,151,51,182,10,179,241,65,22,116,104,91,218,40,39,79,170,191,250,241,6,121,32,55,238,46,54,163,31,189,187,213,158,218,149,169,105,237,211,61,200,104,113,55,31,127,54,42,62,199,147,98,195,100,252,206,224,114,70,170,104,150,204,125,123,36,115,25,76,69,180,172,91,254,117,127,178,18,84,219,207,238,255,204,49,39,160,76,1,127,57,74,65,25,147,225,87,193,142,86,63,163,37,64,53,180,69,4,86,69,110,55,69,81,153,98,218,203,250,127,76,223,44,49,208,113,58,97,118,110,212,138,156,167,188,175,31,155,51,200,104,197,155,24,245,142,128,55,235,207,0,194,155,214,20,72,169,73,65,55,74,125,120,196,100,191,44,130,203,42,213,113,209,128,169,86,10,165,151,24,102,215,195,137,223,53,89,212,38,93,58,33,109,136,242,45,10,251,67,188,169,73,171,112,162,77,135,228,69,25,74,15,43,116,95,50,85,237,187,171,73,214,8,123,75,90,63,49,181,3,136,135,239,61,157,149,63,100,207,119,163,114,144,22,246,205,54,73,102,164,248,206,39,208,162,26,209,97,235,147,105,29,30,195,27,64,60,190,41,240,244,207,128,25,221,192,191,233,135,161,49,2,56,61,25,0,57,153,32,166,165,212,216,168,76,127,31,202,30,71,78,13,196,45,236,143,197,76,200,221,101,168,74,19,190,200,189,189,235,240,182,110,25,93,48,120,132,136,247,212,207,61,194,227,4,131,41,215,63,106,173,111,167,204,146,79,62,253,115,2,139,160,198,43,196,75,9,202,29,113,7,187,21,61,138,138,193,104,197,163,87,63,121,186,176,178,91,175,232,92,205,197,121,24,132,19,85,230,175,162,189,64,157,139,85,100,59,160,167,53,17,170,135,2,61,59,145,194,63,8,244,140,202,78,57,95,143,172,28,112,80,49,1,133,216,68,65,68,174,79,199,78,249,170,149,18,142,161,83,137,3,219,58,137,129,7,131,116,48,103,245,97,162,235,250,227,213,54,207,253,217,16,119,74,39,167,239,35,96,72,206,91,183,143,145,255,184,111,220,161,55,139,103,186,47,31,88,11,15,76,170,198,229,132,178,180,150,149,163,70,148,45,116,66,200,14,244,28,14,189,238,120,98,78,201,240,210,210,199,161,7,18,237,35,237,165,4,204,254,187,11,151,199,119,178,108,22,71,218,30,72,191,56,183,43,192,71,165,170,203,149,41,80,33,210,206,223,187,102,7,198,217,36,91,232,17,214,73,14,120,137,251,91,68,92,195,194,125,69,190,192,26,37,154,61,93,97,83,68,251,243,8,249,39,45,156,224,26,76,90,17,23,211,102,149,180,114,244,126,102,70,114,81,24,77,252,192,29,203,196,179,24,246,163,199,230,84,176,233,131,62,147,89,86,23,86,57,182,70,134,199,173,192,162,55,63,197,255,95,3,48,27,185,245,161,163,10,11,241,148,90,67,166,91,251,104,27,134,182,18,100,191,135,216,148,184,250,27,122,50,33,2,45,111,11,112,53,69,189,87,162,172,87,135,214,190,89,172,219,159,255,236,24,167,87,205,59,200,42,50,55,40,188,195,154,190,76,54,106,52,255,137,126,201,149,9,1,132,137,85,218,82,78,188,180,184,219,31,22,125,31,31,195,50,77,13,79,6,135,244,43,181,96,163,233,160,130,124,175,57,222,134,217,63,228,202,202,132,11,67,145,200,176,54,63,59,23,200,91,57,1,110,80,246,254,86,149,85,125,188,220,5,95,6,78,157,182,72,57,78,205,237,209,244,107,238,135,30,88,245,107,68,217,146,73,41,181,1,86,181,136,55,237,148,25,64,175,39,161,92,184,232,171,151,198,89,31,189,191,160,108,59,131,228,174,251,222,119,42,121,129,124,53,116,78,115,13,247,207,150,66,187,88,221,160,230,185,16,50,132,245,178,56,48,112,238,233,209,62,167,148,204,57,25,140,74,175,43,131,66,62,101,18,167,114,222,78,112,229,58,181,21,51,58,76,244,224,130,87,124,25,134,201,165,84,113,110,135,215,169,52,193,6,104,28,101,149,252,204,69,139,7,231,84,43,241,178,153,27,173,151,197,195,68,92,2,227,9,233,7,236,60,173,65,55,34,80,15,44,250,76,227,133,250,252,141,130,194,191,157,254,155,149,95,165,132,88,31,173,162,94,204,58,232,144,33,216,18,175,166,140,35,104,158,46,103,157,79,83,86,59,49,100,171,79,38,133,128,197,112,241,4,53,1,170,42,8,129,186,133,4,83,33,34,243,93,125,243,22,63,134,209,125,220,219,102,144,232,92,250,166,87,180,158,57,70,152,134,51,93,16,28,172,61,50,137,39,40,249,38,135,89,207,143,135,140,104,233,62,219,158,104,49,166,34,74,169,223,23,139,57,111,249,11,204,35,101,48,198,50,242,240,123,16,31,27,161,240,180,89,57,226,235,6,148,92,239,99,122,148,28,177,242,52,94,159,247,114,222,174,148,49,74,246,146,198,147,11,198,122,46,200,44,111,13,203,210,218,227,217,192,153,12,185,229,177,102,106,171,43,224,12,176,115,109,40,31,23,250,247,229,42,144,187,88,64,22,14,95,146,199,59,181,139,197,235,4,79,1,168,60,26,243,56,74,214,224,188,61,89,93,154,186,64,182,109,47,238,131,245,135,214,53,147,172,96,104,111,127,101,100,235,135,252,184,8,20,59,102,2,54,46,227,209,201,226,99,178,51,178,252,86,41,181,52,178,159,221,42,184,183,57,58,73,117,164,253,57,3,0,217,121,5,31,24,204,114,159,191,251,124,210,91,123,29,51,115,104,67,79,147,253,143,192,97,222,204,153,197,134,85,102,77,52,131,125,82,131,115,133,171,133,140,60,106,65,44,250,140,51,48,75,37,52,218,168,98,139,127,143,185,61,246,118,159,151,143,3,86,255,174,50,227,29,142,129,64,28,54,95,15,179,1,219,53,215,239,25,19,230,214,66,72,252,54,180,183,50,111,240,247,122,60,95,205,196,142,63,20,82,156,205,190,167,185,180,74,23,158,163,142,52,192,139,105,244,128,8,117,121,137,215,144,229,131,222,194,185,9,84,36,39,95,14,69,128,115,55,37,141,219,212,201,209,213,7,231,244,32,236,96,35,82,73,165,134,103,104,35,196,139,53,62,252,235,175,150,98,103,3,81,98,178,12,21,10,168,175,194,177,48,226,118,205,56,3,123,210,23,98,203,221,128,216,230,36,86,32,90,223,9,160,127,110,171,225,69,9,84,230,46,250,128,123,96,235,195,78,157,180,76,254,84,120,232,190,20,179,43,43,3,29,102,223,99,48,125,90,98,68,143,225,61,252,172,205,187,58,200,221,107,147,71,0,36,156,77,55,194,208,247,136,241,67,17,72,191,50,112,49,188,165,121,230,8,233,88,181,107,186,164,102,167,157,186,195,45,92,67,127,28,64,54,233,170,48,202,231,203,230,207,37,146,133,115,20,122,101,160,167,39,221,38,85,139,120,121,110,137,76,101,221,182,177,86,238,95,173,122,12,7,187,137,155,249,99,8,181,164,74,194,133,182,57,144,238,46,36,142,32,26,236,33,142,148,142,31,242,253,174,121,99,116,28,167,252,127,160,153,68,40,161,78,174,160,57,121,131,237,252,76,205,57,190,17,36,48,87,27,250,237,57,81,240,137,39,242,23,174,71,185,80,115,102,90,226,217,94,234,8,13,240,40,160,160,52,74,225,77,214,135,100,31,230,208,252,60,37,160,188,165,74,37,19,199,15,206,36,209,241,92,185,184,60,30,230,113,28,133,81,151,131,168,156,190,233,212,165,180,25,206,230,115,44,22,69,243,43,29,75,40,113,237,3,121,67,162,0,92,106,170,130,142,143,8,189,130,18,7,114,213,125,92,248,15,60,204,142,79,108,13,98,28,191,201,92,8,28,247,197,84,218,114,253,87,149,58,247,169,90,101,75,161,94,123,104,48,37,215,147,108,49,130,194,54,183,82,149,175,170,238,231,71,187,236,127,185,86,159,114,215,176,54,253,99,35,191,148,43,19,250,211,160,184,29,176,179,206,32,127,213,137,139,80,7,89,33,199,17,68,246,131,203,135,67,101,32,244,90,63,108,175,42,233,175,119,115,92,251,200,253,231,90,11,51,166,28,106,12,83,59,65,127,251,124,2,14,232,29,176,228,60,239,222,182,111,135,58,125,35,182,144,14,114,91,150,194,85,151,205,104,12,165,67,1,13,68,91,169,208,248,232,237,205,246,75,3,237,205,90,155,177,13,247,232,14,70,36,1,57,57,41,233,140,245,203,148,40,212,240,217,222,111,86,89,103,108,234,175,118,158,96,77,173,8,5,200,233,109,164,222,34,182,197,71,33,21,62,16,246,193,204,142,174,131,142,157,203,72,50,215,199,172,87,1,56,125,221,178,22,111,43,214,220,51,188,34,36,249,116,37,111,174,2,111,185,121,8,202,69,171,100,226,234,179,101,241,177,77,224,34,108,64,195,121,220,82,88,199,167,26,161,215,210,248,252,149,243,246,78,146,242,55,124,202,229,75,136,118,116,225,39,167,1,107,74,14,63,130,24,65,252,156,13,219,211,15,71,219,254,245,231,79,239,65,152,15,52,152,93,196,179,222,221,141,160,16,127,143,16,140,115,74,121,177,241,245,254,126,108,158,3,91,72,138,83,17,216,34,177,253,129,43,203,137,160,145,241,222,252,133,181,55,146,61,83,183,17,94,18,117,177,138,191,122,83,9,136,16,6,115,54,102,243,36,89,214,184,162,145,134,219,142,161,5,116,78,204,135,87,17,55,241,13,175,64,150,189,172,228,73,184,120,232,69,111,53,93,201,235,235,171,120,144,100,47,168,1,245,9,125,76,183,216,177,196,23,156,191,178,169,27,77,78,120,54,53,123,140,185,243,224,162,192,119,53,239,4,73,4,123,2,32,175,52,141,92,143,73,153,207,123,41,66,254,185,154,30,2,133,135,152,137,196,111,62,176,245,118,40,153,73,95,117,85,70,196,92,167,233,254,118,98,255,181,135,236,190,206,129,182,107,232,121,75,137,242,46,207,241,90,61,28,238,241,183,74,41,140,67,17,18,185,217,12,159,203,150,220,47,62,18,131,115,251,216,183,195,71,244,125,36,200,47,43,242,255,178,179,211,140,195,203,77,200,240,128,80,166,71,138,234,94,56,243,12,104,124,52,122,60,41,222,239,144,161,160,82,191,86,25,178,16,245,153,210,95,186,154,69,114,239,113,0,40,7,3,96,155,22,88,139,203,154,176,59,104,35,251,152,93,115,205,232,53,241,46,57,118,43,49,148,236,170,167,103,195,74,223,56,38,9,128,250,76,134,145,100,244,116,3,110,144,127,85,108,57,55,41,230,188,244,241,99,180,80,150,185,197,253,29,70,7,25,28,159,87,227,106,47,245,119,223,14,31,133,223,106,94,62,238,196,132,100,120,186,157,72,62,186,100,220,130,215,177,128,237,1,222,231,27,99,222,29,41,88,26,87,137,143,35,186,185,69,45,32,178,223,187,111,216,78,86,3,76,101,228,174,12,73,195,54,207,244,135,240,157,172,148,25,147,66,211,110,168,169,22,133,241,61,235,181,122,250,99,31,178,241,188,127,222,88,168,67,185,86,20,133,243,236,19,166,246,109,74,99,24,19,205,44,28,163,27,51,10,245,240,126,124,54,253,105,112,91,13,14,158,92,151,131,220,183,173,150,245,6,148,104,110,194,152,44,8,154,71,9,229,254,40,245,181,231,10,165,111,46,186,12,236,146,252,79,197,118,237,218,5,80,161,16,80,75,189,231,6,36,87,127,21,112,31,221,159,217,4,183,254,10,46,108,228,204,159,69,137,162,164,9,230,83,244,142,98,8,241,151,187,216,96,195,250,42,206,126,236,105,195,103,191,234,224,201,184,16,238,176,133,128,174,223,120,214,11,79,19,7,95,4,200,37,147,52,73,214,130,251,254,72,160,78,155,192,118,89,66,28,55,196,48,222,215,184,225,249,228,237,103,98,243,76,1,180,75,33,216,83,6,254,159,45,21,95,120,253,245,221,80,83,122,212,132,84,3,24,125,225,96,111,29,216,30,221,70,237,195,8,238,61,177,32,159,83,43,194,230,221,26,168,119,155,85,117,242,84,55,203,135,21,157,235,174,235,109,253,52,255,166,88,86,189,137,57,221,153,93,23,234,86,189,152,109,60,169,163,149,251,146,23,246,33,145,117,136,30,69,51,48,66,232,112,105,253,54,28,175,250,131,157,143,103,11,207,246,66,76,164,115,42,178,134,38,181,2,10,19,157,81,116,128,201,50,223,3,229,169,18,33,46,219,62,151,115,125,60,69,121,43,26,156,6,148,173,233,43,169,242,118,224,214,83,198,92,5,134,56,117,181,203,96,248,224,29,21,5,8,37,192,213,202,175,202,4,205,166,152,182,162,69,76,255,74,60,243,231,77,245,42,108,134,212,104,104,81,123,47,208,210,25,43,14,248,167,236,37,236,136,185,13,28,169,9,141,28,191,51,227,111,210,218,138,2,95,12,113,199,74,125,98,73,205,91,167,159,235,94,11,142,26,213,24,208,10,233,79,25,164,55,19,250,172,184,139,186,161,68,194,115,210,190,86,101,214,247,41,145,99,217,93,242,222,2,67,35,12,56,150,122,75,185,213,243,179,78,144,32,221,18,191,178,3,205,53,23,163,199,246,82,154,108,105,24,76,10,126,115,1,252,242,211,112,216,33,151,247,49,19,10,246,233,159,3,18,199,103,246,32,55,18,161,18,180,19,97,204,196,2,57,189,62,254,89,158,7,205,39,75,242,109,233,77,248,179,64,205,82,165,100,7,60,147,217,131,40,255,13,141,199,61,104,174,138,186,229,120,98,55,130,121,90,198,74,197,8,204,213,4,22,141,217,23,172,178,6,5,93,11,114,149,120,158,186,12,157,200,42,211,143,62,88,139,209,71,237,83,57,112,135,201,8,10,64,210,82,140,245,81,130,1,244,1,25,211,180,6,138,243,192,236,226,214,191,247,252,36,10,67,54,138,94,232,131,167,214,51,82,22,140,30,84,66,11,154,34,96,186,69,239,111,241,221,32,217,32,178,28,224,110,3,206,250,141,250,29,90,194,27,178,239,72,236,40,141,55,238,249,22,3,62,239,114,26,116,55,150,225,153,54,27,76,247,203,72,79,52,23,108,251,165,90,206,45,18,239,10,216,13,225,151,250,219,36,209,138,129,177,234,190,113,214,94,45,41,54,66,235,148,34,78,190,233,118,223,57,233,82,115,25,135,240,170,107,108,210,21,198,207,59,62,35,33,68,52,121,68,185,179,44,168,154,52,32,115,55,114,175,255,20,78,12,137,110,168,151,35,146,71,157,68,185,114,48,159,94,156,19,204,60,39,3,123,1,115,212,107,211,2,90,39,162,29,97,118,18,174,34,178,126,120,186,115,254,189,2,59,150,167,151,156,99,159,107,240,13,180,127,123,36,70,222,117,156,123,247,47,165,203,54,28,61,41,93,88,140,183,243,169,192,37,225,222,200,111,9,75,114,208,184,57,85,181,209,233,54,149,146,69,1,39,208,10,79,62,240,133,189,80,123,67,116,192,33,130,69,191,24,137,210,18,46,49,189,204,81,140,110,63,255,38,197,173,203,61,192,78,8,174,153,199,141,164,133,50,35,87,107,150,143,57,36,23,189,100,234,131,63,172,182,221,137,189,86,29,142,247,110,138,195,26,65,252,4,255,182,65,83,181,185,86,111,116,182,231,185,239,120,253,39,203,175,143,39,160,133,12,253,223,224,244,180,0,29,184,115,220,39,218,52,251,17,93,13,110,76,91,159,166,84,132,80,100,24,164,77,186,7,206,119,45,237,24,231,27,11,108,84,156,131,122,57,102,196,179,35,56,28,92,224,184,52,10,221,44,65,129,225,41,141,230,201,233,156,146,176,235,14,73,134,10,133,8,212,166,221,249,78,242,183,72,31,228,67,43,31,97,176,129,111,162,80,141,242,148,51,27,217,83,43,26,112,245,112,149,192,188,84,63,211,230,135,45,88,129,196,17,65,202,117,251,120,85,10,156,74,134,55,54,246,173,251,6,253,2,131,247,212,81,208,168,171,204,52,164,223,50,21,101,46,115,120,147,80,220,58,252,87,154,185,152,10,25,2,251,77,79,7,152,97,152,145,169,159,41,102,68,199,178,23,123,64,10,253,123,218,82,171,146,131,156,13,236,209,33,54,182,142,10,10,115,116,160,95,232,118,180,170,98,26,196,132,169,203,49,155,157,145,42,38,81,121,247,135,15,123,45,216,77,209,115,102,38,173,248,159,145,221,128,163,139,28,85,61,140,118,2,45,47,241,169,241,25,8,179,140,149,209,229,16,28,213,193,98,112,79,120,203,230,61,245,27,229,8,26,185,206,183,189,75,33,186,99,27,108,252,120,48,59,194,95,160,37,213,156,195,162,69,103,105,207,151,33,43,148,1,40,127,175,1,156,252,148,24,138,249,107,189,249,77,109,248,180,216,175,7,57,144,164,138,83,1,229,60,114,200,80,156,205,193,44,144,89,147,229,43,74,124,96,185,194,244,7,25,145,135,109,228,119,132,131,231,190,114,238,76,83,97,105,49,76,67,217,117,129,70,18,104,146,124,172,232,97,196,65,236,212,2,7,38,53,174,214,69,230,18,177,171,14,158,134,38,6,154,196,14,13,164,157,255,22,35,244,202,34,102,149,159,163,188,25,213,248,169,39,30,29,215,93,29,68,203,123,88,163,199,181,127,159,109,12,157,20,68,180,120,113,74,204,218,71,143,60,211,249,150,241,7,61,197,239,33,43,175,139,180,240,175,231,76,106,59,214,14,21,121,243,7,132,156,193,40,122,101,13,131,17,26,188,76,70,123,180,29,60,109,37,228,119,241,138,130,148,9,195,206,183,241,100,179,215,231,191,99,253,218,254,85,93,188,95,45,19,77,16,145,140,164,234,189,138,89,240,243,64,75,56,78,222,16,218,75,196,155,144,47,207,182,174,1,150,99,203,167,229,101,226,236,10,146,219,95,100,191,32,108,105,9,84,182,120,160,85,105,47,115,137,219,59,255,194,231,160,92,110,56,191,140,109,207,48,69,23,242,145,66,34,215,90,209,206,211,42,51,72,14,221,154,73,185,94,115,168,51,141,52,1,219,166,219,113,62,82,221,6,178,62,217,201,156,253,36,245,2,74,97,4,10,133,112,32,162,179,236,28,189,152,127,224,124,118,31,247,85,94,129,98,36,140,217,83,23,167,124,120,162,58,126,50,20,115,4,245,87,138,132,191,73,145,140,93,169,95,232,106,244,213,39,117,50,146,176,158,79,47,64,198,59,21,247,249,249,25,18,28,250,111,211,123,46,15,136,92,182,137,98,104,132,17,203,88,71,183,9,213,199,89,74,248,143,69,185,80,80,176,126,130,252,220,225,140,124,109,218,163,147,120,144,50,208,104,20,236,46,72,188,97,188,132,182,209,46,169,122,110,98,94,159,108,77,117,42,238,57,197,124,78,101,250,249,105,216,33,169,14,60,89,206,252,35,13,197,188,151,103,66,13,106,144,55,235,149,173,207,115,254,51,14,141,71,167,129,12,209,186,215,236,166,29,245,227,127,11,228,159,51,198,202,86,214,95,37,173,90,61,175,151,25,238,155,238,132,233,81,40,246,168,218,132,87,186,216,205,189,114,144,111,246,192,43,125,178,156,99,193,216,220,159,222,195,223,96,7,48,110,36,200,47,107,218,19,20,166,209,124,162,212,200,199,207,241,84,61,139,81,2,233,151,182,54,27,189,19,242,176,220,108,255,217,153,153,187,23,3,154,57,142,20,161,177,231,93,215,141,158,41,39,131,103,218,49,139,3,175,137,220,169,252,108,40,105,171,61,57,167,123,100,8,183,213,177,130,170,162,179,120,29,10,112,121,213,94,10,33,228,92,108,70,73,192,42,246,46,215,135,119,250,5,30,50,48,219,33,153,103,248,243,195,83,46,109,165,23,55,75,40,132,242,50,198,121,67,34,165,168,150,48,15,59,27,13,228,112,115,163,18,189,138,25,108,1,109,77,225,26,90,75,203,133,23,253,226,144,100,234,158,18,152,165,215,210,142,93,207,110,179,38,35,40,12,102,147,135,3,237,255,151,37,232,191,12,228,201,179,230,172,132,15,139,34,79,58,210,83,115,104,223,117,251,155,163,15,194,177,171,75,181,45,89,76,142,180,29,217,175,212,194,100,65,39,202,106,92,9,142,161,12,153,160,222,37,196,79,34,33,208,76,29,36,174,244,75,24,139,197,154,32,193,57,169,102,179,74,189,115,34,169,222,199,35,250,33,111,197,178,7,58,145,150,205,135,171,139,159,7,61,24,0,49,201,42,106,176,72,20,160,190,74,48,105,119,76,235,63,215,229,218,130,204,87,113,235,28,148,63,59,253,215,30,206,168,3,198,155,121,150,220,10,194,230,209,68,93,168,95,242,1,133,13,13,215,206,134,68,194,77,42,242,165,151,12,234,228,212,237,155,72,70,64,24,53,78,13,206,238,19,240,16,109,47,84,50,105,158,207,100,124,209,178,110,163,121,29,23,158,128,246,211,38,106,210,188,71,47,151,65,37,205,42,98,161,237,32,173,107,27,32,183,154,200,229,223,104,175,190,226,76,86,12,97,142,80,112,108,109,216,114,135,247,63,137,110,187,188,168,243,181,129,183,82,63,19,166,39,149,204,44,36,10,235,113,208,17,22,81,122,242,25,238,217,246,171,206,86,67,107,11,31,101,50,37,66,49,48,85,234,35,94,109,249,58,3,223,97,2,129,250,123,63,160,1,59,229,62,11,57,141,43,104,70,240,191,219,192,178,105,223,203,192,229,167,122,221,164,76,103,37,123,85,140,30,199,237,229,36,194,25,46,155,11,222,201,149,166,14,225,188,129,66,184,14,128,255,85,119,36,189,26,137,146,67,235,230,95,52,233,158,62,78,106,153,2,239,79,97,102,208,83,62,226,38,217,49,240,1,2,221,172,235,186,67,46,185,138,232,197,220,97,205,9,93,233,116,72,108,172,142,2,199,60,241,145,60,37,236,251,67,156,12,35,126,249,169,28,51,157,147,154,109,238,231,113,88,211,98,18,3,223,98,163,109,124,139,221,12,70,145,238,166,233,232,7,111,196,236,239,84,48,75,253,146,206,32,122,30,236,5,160,192,189,33,46,217,22,225,32,43,47,103,189,168,101,50,74,110,155,106,56,78,37,180,204,111,215,128,151,152,34,15,49,182,233,21,135,23,170,48,0,34,189,64,79,70,235,158,242,39,46,174,8,0,136,152,80,189,254,137,40,178,52,252,215,34,19,125,213,235,216,124,205,174,24,58,16,115,124,129,179,237,157,52,15,60,33,110,42,150,102,83,182,139,101,24,129,32,166,128,242,211,175,62,17,185,86,9,185,114,217,137,189,236,41,109,74,44,241,39,197,132,87,245,56,51,97,18,164,39,255,240,77,94,218,95,229,106,231,52,207,162,253,199,71,178,3,35,78,246,73,49,206,23,224,161,244,224,235,158,25,189,192,195,65,38,119,116,202,237,29,1,32,91,202,206,65,48,82,43,8,220,156,70,243,143,137,248,144,72,217,182,92,177,73,107,39,157,41,241,220,250,34,221,94,182,176,236,57,213,115,63,181,197,204,178,145,179,16,90,37,167,233,202,122,27,229,150,237,35,42,64,189,84,4,235,84,45,173,61,122,108,187,169,66,180,136,239,153,185,222,212,23,223,74,160,13,0,141,82,226,127,13,15,27,184,181,8,138,249,172,219,158,200,223,61,72,116,36,164,75,194,227,170,136,47,237,121,120,178,4,43,35,101,140,232,113,83,83,204,72,147,189,87,174,135,252,221,116,2,18,106,41,11,228,125,20,150,49,198,113,169,146,184,152,61,205,237,148,31,113,100,19,74,55,88,174,166,205,149,195,138,98,214,81,32,42,70,1,194,75,116,36,86,7,236,190,30,130,78,154,59,69,14,130,104,250,4,129,151,95,137,123,122,57,216,81,194,181,53,196,235,161,184,173,120,2,214,7,138,73,144,120,142,94,37,155,6,42,211,13,149,155,238,1,214,80,125,64,83,13,25,127,125,183,76,249,71,18,90,236,84,133,218,97,187,178,175,85,63,102,16,7,63,89,176,209,212,38,82,121,107,151,62,96,204,167,4,90,11,106,215,176,67,150,232,249,221,205,225,216,122,162,99,225,33,238,154,117,118,41,130,244,224,91,128,78,133,109,199,32,152,173,29,153,25,161,114,115,81,4,138,127,8,204,178,57,195,235,215,218,209,68,54,249,137,187,84,164,233,195,121,82,40,29,229,41,4,17,23,22,103,244,167,169,246,194,238,105,254,136,227,119,35,241,87,179,62,125,48,51,150,89,49,102,137,46,63,41,78,180,155,174,123,185,113,255,124,74,130,116,12,90,241,222,217,180,70,143,59,128,57,94,99,125,40,119,120,212,6,230,67,43,216,192,9,133,141,253,209,227,122,172,193,62,106,51,124,131,218,38,192,201,244,135,54,127,168,79,65,230,201,90,125,63,248,9,83,168,169,30,137,70,82,149,167,61,2,253,172,29,180,79,154,212,139,1,36,224,57,108,20,70,32,247,213,154,236,14,163,194,226,90,132,151,12,204,241,176,232,214,95,90,41,35,153,202,140,71,213,205,89,181,123,137,82,74,171,183,223,215,154,188,181,230,144,83,103,39,31,42,101,32,10,46,167,225,153,63,205,116,152,166,192,166,252,187,199,41,247,71,135,108,133,1,105,113,11,53,71,198,155,68,211,207,207,213,7,28,201,132,233,25,4,237,179,239,36,78,78,161,54,83,207,82,196,181,177,221,161,171,139,9,169,245,124,117,181,40,62,189,125,125,230,189,118,188,7,152,160,57,167,248,157,47,122,74,160,150,50,239,69,34,201,39,206,96,76,85,217,154,199,182,87,60,55,224,23,181,2,52,102,141,23,13,206,24,75,243,28,93,208,191,23,196,63,112,121,177,239,136,94,75,161,163,75,74,174,162,179,239,100,196,53,156,226,233,210,237,178,208,197,182,101,225,90,141,224,92,194,33,170,119,164,216,97,139,113,172,165,163,30,211,236,220,163,138,47,7,211,74,18,99,28,190,92,242,42,27,234,239,92,192,118,42,140,203,139,73,202,161,140,133,136,205,108,41,62,69,98,42,242,34,111,223,183,127,48,83,10,157,206,106,82,204,106,236,170,75,131,218,7,134,101,247,102,55,92,248,198,162,210,215,152,172,173,53,93,62,173,189,128,154,19,105,58,121,142,120,50,148,64,174,171,198,84,160,210,176,208,3,193,100,21,150,136,42,30,98,82,205,36,93,230,193,45,226,181,100,71,156,63,47,235,165,33,124,235,116,186,240,153,72,227,170,60,194,106,79,218,68,169,151,11,61,252,143,124,185,51,153,166,134,194,47,185,154,223,118,155,181,61,78,37,192,40,92,30,121,248,224,144,114,15,170,136,141,91,4,89,197,192,104,58,68,238,235,50,111,249,99,168,205,1,132,123,148,3,123,91,48,208,59,57,245,131,246,202,221,189,201,60,12,211,83,39,203,121,92,19,120,10,84,137,180,249,12,99,39,183,142,112,87,96,216,229,135,79,4,158,101,249,63,53,96,60,218,82,34,185,60,162,87,120,36,231,200,25,132,139,159,140,65,150,123,240,173,95,238,21,36,50,228,167,101,51,96,39,216,176,184,224,125,247,78,169,114,43,143,192,99,182,1,216,244,96,77,189,35,215,32,37,195,219,11,151,72,108,240,199,185,81,111,100,139,241,12,34,73,28,248,122,205,122,245,157,200,71,72,191,113,202,95,155,181,153,198,63,1,196,38,135,127,180,139,240,89,10,183,36,255,32,85,247,140,245,16,91,181,20,126,82,7,74,131,105,235,177,179,99,205,12,70,74,169,196,240,155,95,116,100,174,127,252,249,67,55,49,193,171,137,21,44,109,43,243,37,108,125,31,104,149,243,135,223,61,95,82,104,87,47,124,88,53,111,234,198,232,168,22,209,238,6,21,38,185,102,208,180,82,148,167,16,12,195,179,48,88,21,135,151,174,98,4,159,40,103,109,3,139,29,66,25,7,226,114,26,207,151,186,242,197,50,218,220,134,149,24,182,91,78,78,13,87,20,128,130,195,3,19,167,160,133,52,222,99,116,250,76,7,110,173,30,0,157,61,53,229,210,2,75,150,159,108,69,183,190,142,64,203,199,10,158,64,177,60,206,236,184,48,31,191,98,162,139,220,148,164,233,145,7,245,36,217,237,76,107,204,142,218,60,94,218,60,161,182,180,89,187,35,15,88,169,89,253,245,20,55,255,114,205,212,82,54,208,112,235,180,80,165,224,200,141,169,97,236,190,229,200,180,38,35,152,47,193,251,69,143,251,206,195,130,53,208,253,105,138,61,30,13,154,189,20,221,234,149,33,215,183,16,246,216,125,238,221,66,217,251,60,193,51,86,180,223,106,169,98,151,81,140,247,14,247,235,235,96,24,169,71,94,171,43,1,218,210,37,210,121,141,190,149,245,176,135,187,180,55,68,29,74,196,200,120,13,112,219,48,142,81,250,58,185,190,74,254,143,162,191,192,122,47,149,117,205,203,46,75,134,232,83,162,9,13,88,251,37,67,187,39,167,225,206,219,89,145,212,97,96,211,93,176,238,228,228,219,0,123,204,212,170,17,40,45,120,141,175,13,22,163,220,146,138,46,182,61,139,181,235,254,241,194,99,178,91,9,15,125,106,187,141,87,24,91,131,19,121,107,149,18,176,30,250,45,146,178,2,167,210,213,149,164,3,249,191,85,49,67,241,239,244,74,29,19,67,28,88,250,118,25,240,2,170,243,252,80,34,237,43,190,202,132,79,82,154,147,142,226,104,99,120,47,116,23,121,26,99,155,25,130,65,143,26,64,244,242,128,235,156,130,130,19,192,29,222,52,144,81,231,99,9,139,1,21,27,112,88,33,40,122,83,153,131,108,212,65,145,93,47,183,126,161,126,140,252,239,97,123,8,14,64,59,181,155,199,181,132,146,83,244,27,248,64,167,107,12,48,0,248,87,199,162,197,140,184,165,19,83,191,120,243,104,155,219,159,213,12,185,125,66,84,3,236,129,102,78,76,243,155,224,229,59,121,168,212,96,10,10,72,78,197,120,39,211,16,130,158,75,13,216,63,122,121,75,220,104,163,108,137,107,1,50,246,40,28,209,253,117,186,10,187,244,241,31,247,230,140,61,122,101,28,81,233,159,243,86,123,92,181,183,149,142,119,133,65,225,239,171,98,79,166,221,192,37,134,28,43,138,161,126,194,113,119,130,20,106,145,95,74,11,203,38,250,136,5,111,245,165,141,89,181,75,187,43,125,12,126,31,74,30,67,79,7,192,91,189,11,50,196,242,251,169,159,124,68,181,179,125,184,6,19,95,169,74,52,8,230,142,119,0,33,153,182,207,26,0,79,248,33,89,147,247,196,104,238,65,217,160,224,173,189,17,49,167,88,27,190,105,210,161,200,236,194,226,150,26,13,5,80,239,96,69,176,215,11,126,144,33,163,220,33,34,214,234,127,48,200,170,96,252,134,173,74,247,177,39,28,191,16,210,46,72,85,203,235,12,188,54,89,77,179,202,44,157,102,211,188,166,227,30,168,84,25,30,213,91,11,253,171,47,150,142,254,25,76,185,97,109,119,89,228,154,211,119,28,112,221,95,113,213,97,42,239,157,71,111,168,140,245,169,121,211,217,230,97,180,80,15,161,234,20,128,242,190,40,238,62,38,255,118,102,87,253,97,77,162,44,169,106,204,132,91,190,124,224,110,144,250,66,243,230,57,39,137,45,78,155,67,82,219,152,90,214,118,94,130,157,52,105,12,21,243,16,140,195,197,194,242,26,156,251,233,16,191,188,134,160,158,73,14,197,74,31,145,35,181,15,194,253,215,142,61,23,252,245,118,190,165,33,126,121,28,17,100,238,228,208,254,118,47,151,170,67,189,106,60,229,54,100,234,84,33,230,252,4,153,93,180,135,64,72,157,79,185,214,222,154,30,175,41,111,129,47,177,82,95,241,128,221,12,119,68,252,133,205,35,167,72,128,188,58,243,20,154,19,140,187,55,8,114,244,48,230,241,83,196,172,49,56,15,16,184,227,73,234,195,94,233,170,72,211,153,17,103,104,128,63,182,108,18,145,45,134,56,17,97,176,255,60,52,125,203,212,106,249,9,48,68,97,118,50,193,246,229,114,200,180,225,168,124,24,188,210,211,90,157,19,131,188,32,238,129,195,52,47,50,206,126,219,56,229,248,59,217,102,8,68,210,120,162,93,17,153,248,138,82,53,176,227,254,9,53,248,194,94,242,31,156,100,206,149,137,199,94,198,233,243,135,136,101,130,204,87,95,194,215,24,181,132,147,21,30,29,49,107,227,132,116,223,199,211,147,102,146,125,245,118,232,173,125,70,223,162,228,217,115,107,61,237,71,0,148,198,4,25,202,48,41,253,94,65,22,185,18,76,2,39,183,194,74,196,88,20,25,191,203,97,110,102,28,98,204,44,12,56,210,195,246,117,99,51,75,101,89,22,129,30,206,177,174,221,23,113,228,243,72,221,61,204,166,35,169,181,182,106,118,254,35,79,22,204,200,244,191,123,185,10,79,31,198,68,156,45,11,58,75,242,193,32,20,131,130,111,77,168,65,122,107,79,210,254,48,196,167,100,93,158,6,182,181,67,118,151,28,4,155,246,218,63,218,53,165,247,129,66,89,126,126,92,40,194,56,127,105,28,43,153,3,12,199,225,151,168,135,207,133,77,124,113,76,49,86,197,6,153,58,45,28,117,43,203,230,2,220,53,159,9,254,234,208,180,169,77,36,37,175,31,131,42,86,31,137,46,32,102,81,235,83,153,181,225,217,196,225,56,54,110,139,147,52,171,88,65,235,173,9,162,64,82,3,21,58,199,79,53,31,151,144,187,113,175,38,88,107,194,168,117,128,22,83,136,59,86,52,166,13,253,195,237,250,137,127,84,200,10,98,51,97,171,246,135,175,184,65,238,34,10,212,13,65,62,53,12,56,230,190,76,181,139,236,156,215,109,108,30,153,77,93,182,120,142,30,216,52,118,210,239,231,47,225,23,53,197,10,97,6,207,75,46,185,215,160,80,103,107,95,161,179,28,81,199,221,188,15,243,219,176,198,90,119,249,30,125,36,233,27,198,135,42,55,166,226,23,11,11,39,70,202,223,120,239,73,186,208,181,35,21,117,95,202,167,253,50,87,153,1,128,188,7,183,96,211,204,246,156,145,230,202,104,165,165,0,13,32,179,67,52,55,10,69,219,193,24,42,8,8,137,9,241,59,227,248,118,242,166,72,10,170,223,124,7,51,81,51,170,1,23,87,207,39,233,29,235,195,251,229,86,121,44,253,169,158,35,172,200,169,134,236,100,3,123,61,196,235,42,2,237,19,211,132,10,194,122,221,148,128,215,36,120,12,144,172,71,139,109,164,66,142,58,77,116,210,200,159,223,124,87,244,119,55,11,25,233,34,225,100,112,118,193,175,54,183,46,223,218,57,71,56,188,59,118,5,134,180,13,43,21,205,62,187,225,41,239,209,156,94,240,63,93,26,0,146,33,253,49,188,101,222,122,239,230,81,24,62,21,69,93,213,12,213,246,205,206,233,254,3,153,37,163,155,160,237,113,34,34,110,248,251,240,1,84,14,77,244,110,185,121,215,90,237,176,187,207,125,223,10,215,150,79,199,149,150,183,246,27,204,215,172,72,166,249,111,0,127,75,218,215,15,183,139,82,103,146,59,136,33,44,4,109,216,255,187,97,102,206,165,28,64,88,251,242,4,77,101,224,145,223,24,216,159,146,193,141,78,214,181,161,206,9,23,152,28,98,111,27,101,227,148,77,245,208,45,132,178,99,23,196,37,209,240,122,13,195,28,50,186,179,106,28,229,25,50,109,218,86,182,114,123,148,198,118,139,211,255,10,206,36,153,235,52,60,56,74,197,160,28,109,14,7,196,179,65,97,79,188,21,181,15,21,105,162,184,234,198,64,46,188,58,46,43,110,81,112,101,216,157,209,143,156,242,225,201,152,9,252,23,30,19,94,0,3,113,42,13,96,150,154,49,169,18,53,210,33,151,93,248,94,221,161,75,250,253,242,101,142,92,237,102,124,108,106,43,243,33,183,230,109,126,235,252,253,129,7,48,123,128,93,236,82,56,226,174,179,44,11,86,37,52,87,66,30,106,212,216,229,176,145,215,179,200,117,114,132,246,111,11,105,96,170,0,94,174,45,142,233,214,10,83,201,240,132,49,69,149,165,209,143,17,243,172,27,54,104,90,14,239,40,96,146,165,140,252,132,205,167,51,194,25,48,123,58,191,46,182,166,197,159,92,81,106,92,14,176,66,87,107,144,91,207,255,69,171,194,78,27,32,163,159,221,194,160,206,121,233,203,44,243,4,40,6,224,118,14,241,156,88,154,172,176,14,199,66,223,180,79,35,225,211,40,148,225,137,141,141,220,20,100,9,104,219,194,123,102,181,95,113,142,179,32,145,230,186,232,167,121,64,173,165,164,113,100,196,36,242,156,81,198,237,236,113,162,187,192,195,220,169,244,176,21,118,140,19,148,49,39,67,113,153,247,3,112,5,230,181,253,66,204,244,200,182,41,48,176,165,103,104,11,51,189,118,158,1,183,39,189,158,64,161,240,15,101,245,251,228,6,236,45,82,226,188,130,39,234,4,137,211,113,6,107,180,124,168,219,213,195,205,16,84,34,244,187,189,153,35,3,234,238,41,128,67,222,135,129,210,68,129,71,19,89,52,195,3,5,157,130,250,132,74,191,199,162,117,211,160,87,215,60,134,27,239,214,241,51,34,118,36,170,22,185,167,134,250,1,135,163,241,62,121,147,211,163,105,212,156,230,42,19,117,119,167,136,123,69,28,187,59,1,118,153,140,73,148,252,248,12,190,203,192,39,87,201,236,147,34,3,19,74,155,202,199,71,82,203,189,162,250,157,139,30,170,19,36,153,74,43,36,134,240,173,220,222,180,178,161,87,89,141,57,210,14,35,255,46,195,40,185,72,123,130,114,223,233,175,65,251,18,104,125,119,31,191,250,98,137,68,65,228,118,21,104,215,110,170,50,184,205,169,108,143,92,77,91,108,27,231,115,87,17,43,52,102,211,17,212,158,179,155,242,152,171,224,41,4,4,1,16,160,26,2,85,119,185,31,154,48,161,87,67,225,225,227,209,98,246,231,213,141,253,22,95,133,91,114,160,24,162,244,102,216,181,196,140,87,221,60,232,18,81,135,4,104,109,84,61,220,51,9,203,8,160,16,189,40,187,56,74,123,134,248,139,179,243,26,61,227,69,3,88,133,11,220,141,38,227,183,141,39,108,181,126,175,172,70,201,185,178,156,64,92,202,214,59,97,0,75,154,177,152,253,152,141,162,87,41,37,189,125,206,119,127,54,254,166,209,252,132,255,3,187,122,152,208,6,86,237,55,96,231,101,172,134,135,102,178,230,91,38,93,41,179,116,195,123,53,35,226,255,52,153,96,57,31,151,121,4,173,21,179,41,255,70,12,255,112,72,187,236,165,158,155,199,194,17,213,75,192,161,217,235,178,96,98,174,71,77,113,181,237,38,255,42,210,118,135,135,109,120,130,77,227,15,195,192,248,201,180,57,48,174,0,119,148,89,110,214,77,190,91,184,202,178,42,127,157,227,100,18,61,224,90,169,222,121,120,134,39,15,99,103,41,97,197,186,66,126,3,189,231,17,218,204,160,150,144,224,62,232,112,114,223,168,93,166,73,116,31,198,223,114,10,117,152,58,250,159,255,135,234,92,223,117,31,84,129,19,96,208,236,161,86,21,80,37,55,34,100,104,254,122,76,72,251,198,154,115,151,186,235,169,203,145,120,254,59,86,50,225,114,246,34,174,201,129,181,62,96,57,225,1,147,92,75,89,48,155,170,196,37,227,45,29,29,5,74,98,146,57,255,251,182,50,120,224,10,1,52,210,79,34,90,84,85,252,20,186,97,76,61,128,39,152,147,134,170,30,182,165,147,222,144,3,85,122,151,234,154,5,71,130,170,200,83,119,152,172,2,45,212,145,248,170,161,76,231,8,179,44,41,70,17,172,57,64,96,7,235,39,231,14,93,246,30,128,162,204,153,144,217,205,113,107,134,131,97,133,180,40,232,158,89,5,229,28,119,232,103,57,181,245,29,113,232,39,153,80,202,25,73,241,185,143,51,137,74,148,247,147,41,133,28,58,38,58,243,122,87,213,93,41,164,34,103,129,159,22,162,119,194,70,188,254,70,157,9,131,161,12,27,200,209,217,127,92,206,145,211,188,43,87,247,237,230,196,139,105,177,137,59,105,145,32,13,138,248,0,158,175,1,254,27,199,1,73,222,51,240,191,90,176,150,153,184,113,189,27,122,60,192,218,46,64,24,220,164,7,57,119,54,46,196,211,146,209,160,102,222,48,26,50,205,166,4,41,129,187,246,40,215,44,73,163,146,238,126,111,168,180,175,3,127,7,34,242,100,86,128,143,31,49,90,61,158,213,22,38,84,149,210,6,199,142,206,47,68,49,119,220,13,17,31,165,40,74,238,221,159,30,216,69,102,130,118,93,26,254,127,224,194,78,196,0,121,119,195,29,43,222,251,150,49,8,156,40,234,248,84,136,251,151,222,158,6,73,91,40,144,84,172,231,253,186,151,38,111,63,38,4,59,5,71,132,162,156,130,240,155,141,59,14,223,231,188,0,163,222,208,190,231,106,237,90,126,87,127,25,122,212,127,181,34,175,233,72,0,139,184,66,254,40,142,16,58,42,196,6,85,243,110,41,96,44,26,241,2,255,149,141,26,87,52,91,55,127,195,193,61,161,167,193,183,60,176,132,116,110,194,175,110,82,250,92,199,35,179,23,133,135,106,14,129,176,62,7,62,113,143,78,23,22,243,179,178,224,101,205,22,58,166,40,124,205,38,22,229,89,40,89,86,119,77,47,150,217,13,151,111,151,238,204,8,183,16,41,4,93,164,53,126,64,89,173,174,163,162,148,196,140,65,239,81,243,212,116,151,3,82,106,164,17,169,230,62,209,138,68,144,243,18,59,93,255,182,44,85,196,67,115,51,100,145,145,250,81,231,92,77,7,30,169,193,249,10,64,34,208,208,84,0,213,58,4,116,120,149,224,198,65,134,141,230,194,101,211,94,117,2,177,141,116,197,127,36,193,203,177,123,116,171,204,88,81,97,12,201,173,12,221,160,165,255,226,219,80,43,79,252,116,183,27,7,63,172,133,53,244,125,168,143,19,205,252,87,27,230,106,209,244,120,103,8,4,169,240,240,92,130,129,64,196,4,127,245,252,1,174,175,64,193,202,167,8,209,93,118,218,8,7,215,173,181,56,244,101,141,220,255,198,69,85,11,103,228,80,214,131,226,247,138,191,44,230,102,225,73,193,140,82,167,143,6,131,199,114,89,213,243,199,241,69,20,243,192,206,153,60,72,191,75,254,7,151,225,118,0,239,46,64,138,232,180,166,90,109,251,238,224,117,99,103,237,118,110,0,89,193,178,253,74,218,196,41,125,73,247,188,21,231,113,154,215,244,18,176,192,183,1,127,18,185,142,194,17,104,161,31,117,60,203,108,143,20,201,86,138,229,118,23,42,10,61,188,193,109,32,149,171,199,12,45,111,27,223,28,75,153,131,21,245,213,6,237,56,97,84,105,84,148,169,2,71,28,83,220,193,242,188,252,55,41,61,2,113,6,48,141,72,72,135,44,204,52,207,53,43,151,2,57,42,37,237,206,160,20,170,243,130,178,15,205,105,179,208,190,76,193,248,62,39,46,142,195,53,99,146,215,236,84,106,208,198,167,67,19,139,184,82,159,131,6,116,248,93,108,8,54,93,51,13,130,214,91,162,158,233,139,136,119,188,10,65,8,24,40,130,238,239,176,74,130,162,180,31,64,236,27,128,55,123,96,160,59,145,110,125,119,221,213,129,123,162,154,106,199,76,203,103,1,55,7,249,252,221,52,177,224,74,100,86,227,219,8,71,99,183,129,139,106,39,218,239,70,219,91,0,107,231,215,144,161,69,183,122,136,134,47,74,54,229,201,85,200,157,163,10,170,191,12,46,36,153,84,162,152,125,152,23,161,64,150,43,29,200,214,186,151,101,107,147,242,68,207,212,66,8,230,65,71,9,248,35,110,94,76,173,191,102,55,236,149,239,9,117,60,190,180,246,2,132,5,211,147,81,122,144,179,211,75,5,26,227,252,102,53,39,253,229,32,255,1,219,46,120,160,207,240,178,244,183,62,230,159,153,122,73,62,105,99,27,197,37,52,114,10,42,100,252,108,225,5,195,119,226,89,101,133,45,218,85,42,190,210,28,227,80,204,233,205,215,185,230,16,185,44,19,112,123,139,126,228,116,87,27,41,168,24,34,42,36,203,230,78,210,71,171,142,2,46,85,60,23,63,30,6,217,180,199,139,133,161,221,52,179,154,183,1,32,23,137,250,2,183,192,1,206,117,179,182,143,47,38,180,246,243,43,126,146,144,9,73,148,131,252,233,108,198,250,198,28,199,189,229,158,213,69,30,179,65,69,204,80,105,204,120,65,56,197,43,30,190,188,48,9,56,176,178,2,52,92,41,145,74,178,101,94,222,216,25,252,241,62,236,133,132,179,209,31,234,127,86,86,90,48,64,81,60,130,198,42,139,219,13,159,39,193,198,165,172,17,173,87,25,207,167,131,49,37,41,180,131,220,88,125,210,67,25,1,228,93,27,168,224,125,148,201,223,8,254,197,152,174,124,52,157,250,233,143,81,102,61,179,75,200,87,135,190,29,218,143,9,132,211,30,37,239,70,174,211,218,170,144,75,67,132,118,117,180,114,28,233,11,75,187,137,137,219,129,96,214,239,24,110,13,191,238,243,152,95,182,232,73,18,95,17,125,184,60,115,197,39,16,92,123,204,80,163,108,210,115,237,38,99,244,93,142,8,50,121,0,171,149,18,235,95,107,86,213,30,30,164,40,142,168,250,15,94,22,115,197,2,92,78,139,208,161,230,193,185,164,150,84,97,41,61,32,196,25,237,180,135,178,60,163,55,200,219,63,87,99,177,21,117,90,192,252,179,155,28,117,182,35,88,144,104,108,22,240,79,94,44,24,36,114,41,78,149,33,223,245,37,67,85,229,187,18,159,207,241,92,179,224,66,239,247,88,70,213,126,39,252,119,84,232,13,118,238,196,114,217,207,59,130,90,78,184,184,201,65,231,158,199,10,4,208,150,145,86,7,67,30,232,143,38,225,49,34,133,206,140,47,223,17,112,218,162,85,242,2,44,35,132,86,137,13,68,126,20,202,20,112,196,151,10,241,149,209,130,192,116,238,142,87,241,31,173,162,23,103,110,177,40,247,21,166,160,17,41,75,201,181,166,34,8,227,75,37,67,250,215,151,102,54,180,46,204,120,237,94,46,30,224,139,187,123,153,171,87,183,76,186,133,16,88,143,50,133,227,194,59,64,178,18,103,110,206,101,186,189,199,214,173,175,21,128,96,171,122,157,18,154,153,126,236,148,50,120,160,126,48,67,126,67,27,189,71,56,185,225,51,19,40,17,101,152,215,126,94,47,72,12,202,54,145,176,92,129,21,162,51,14,57,247,230,54,201,46,241,228,60,109,39,129,75,229,156,139,200,252,169,40,101,23,40,217,186,203,193,166,63,123,64,140,86,63,195,20,129,104,151,31,36,127,108,53,168,233,26,7,217,96,22,129,204,203,71,120,109,178,13,68,246,55,201,227,70,30,11,193,46,77,54,192,62,72,220,8,171,178,167,105,175,165,108,94,4,55,9,168,13,193,49,240,133,199,178,94,200,111,182,135,144,150,178,242,58,45,143,82,214,64,246,246,115,42,78,48,84,204,27,224,118,92,109,113,49,133,88,34,217,148,105,162,1,188,69,159,21,29,150,153,101,58,116,64,158,47,252,252,238,132,236,200,32,248,228,119,118,235,37,130,43,124,26,144,156,112,236,100,70,54,147,90,106,224,192,168,212,73,103,19,191,168,16,235,155,135,24,228,34,218,90,7,16,74,161,70,253,108,211,125,248,16,165,242,85,64,22,243,56,158,149,102,189,140,56,88,234,97,44,131,195,56,161,33,2,48,123,100,90,221,201,128,75,158,232,148,162,231,52,131,219,22,38,79,124,133,240,106,45,114,66,61,6,37,229,132,157,235,165,144,73,193,6,243,160,31,17,243,200,243,50,190,16,220,249,130,81,65,91,2,215,75,59,171,17,157,217,43,149,171,175,140,130,197,119,165,119,43,5,33,203,130,106,82,41,100,217,182,252,19,13,248,130,76,20,148,122,51,223,208,138,244,167,215,165,99,93,38,93,10,39,118,94,226,42,86,33,49,218,231,200,132,230,35,190,218,121,221,202,101,134,75,236,165,209,64,185,216,97,5,198,12,135,49,159,84,131,204,130,219,253,132,141,217,115,204,243,233,33,84,100,98,22,128,5,182,198,208,166,8,84,216,73,61,12,217,107,216,154,108,214,160,127,185,232,86,93,166,191,211,38,110,114,199,122,88,57,111,92,205,51,129,212,99,221,126,113,106,32,58,24,234,123,192,216,170,228,82,218,132,37,168,120,35,193,187,107,184,36,118,159,148,43,234,93,71,113,91,223,83,82,143,98,44,168,182,93,159,177,255,164,227,157,100,253,194,127,168,116,86,239,254,115,187,61,218,41,161,228,107,251,6,130,56,237,235,105,174,172,90,95,94,91,93,6,154,18,70,3,149,72,219,101,95,226,219,112,42,17,255,218,1,102,205,177,41,189,8,138,46,216,198,79,226,28,124,217,79,38,132,195,129,245,76,35,163,214,27,146,110,61,182,135,144,89,243,235,231,194,49,149,107,88,50,91,159,2,160,17,112,38,247,8,75,154,134,111,201,208,30,204,166,202,30,250,45,99,80,199,59,98,152,108,149,253,227,76,245,190,86,43,46,11,12,158,50,230,179,19,145,187,71,205,242,28,184,47,114,214,106,21,100,204,96,64,139,19,80,235,76,185,90,122,214,161,9,152,247,10,0,119,79,55,98,102,124,229,98,181,49,27,217,221,207,30,124,18,191,169,201,37,176,238,172,86,82,5,191,187,227,43,147,40,29,216,103,204,208,39,49,220,233,41,117,237,178,175,114,100,1,115,142,177,27,205,247,248,229,113,50,64,192,131,31,164,118,94,200,214,36,4,203,102,163,1,132,181,193,189,111,167,242,213,220,243,212,41,236,43,206,194,29,66,113,76,252,153,169,247,200,164,125,193,155,38,10,242,91,24,246,94,115,109,91,59,156,43,29,237,25,102,213,140,167,58,173,205,177,109,11,60,221,140,29,83,201,208,153,31,120,71,224,234,225,144,104,243,105,234,226,233,37,185,6,119,150,24,253,49,129,122,195,196,22,178,21,248,233,89,121,255,148,75,153,136,31,133,21,94,193,164,78,40,193,15,1,139,145,114,165,87,53,134,214,238,26,159,208,247,211,141,111,65,210,80,57,57,158,45,12,26,100,183,22,176,189,189,7,27,3,249,25,236,125,123,229,85,164,226,182,75,195,185,73,103,141,178,241,240,163,63,183,67,38,239,39,56,112,175,243,146,50,0,140,120,216,253,218,65,73,108,50,25,163,64,59,51,119,104,65,228,195,234,31,132,137,218,39,238,87,39,131,126,23,28,44,244,246,165,216,85,83,6,225,189,143,142,86,0,147,75,78,245,51,75,225,183,206,215,12,163,103,142,12,54,238,117,27,201,244,19,13,240,219,252,132,133,157,135,253,88,116,236,26,174,84,81,215,105,48,74,94,232,0,238,128,33,197,175,90,30,3,107,165,228,35,47,243,132,134,100,55,137,244,163,22,13,221,239,210,196,84,160,140,143,20,98,78,97,78,56,64,74,25,158,242,213,101,117,209,106,219,188,120,73,98,137,23,201,102,18,192,89,240,176,183,22,106,44,178,57,53,175,29,218,55,235,24,119,128,78,206,52,133,147,128,168,245,207,181,138,156,249,147,200,191,111,119,109,48,138,26,94,22,35,24,229,90,223,23,233,249,237,150,134,184,37,253,50,96,44,135,107,219,150,59,86,190,163,88,237,32,230,154,169,4,98,165,57,96,102,153,222,77,45,21,116,63,42,129,47,21,233,209,231,188,250,38,2,194,111,151,62,82,14,67,217,208,138,193,157,16,69,144,83,236,133,110,246,46,238,202,63,94,65,68,252,180,133,158,94,178,224,19,104,216,103,76,4,59,160,187,156,206,202,207,96,199,253,202,3,121,235,25,222,143,216,146,190,176,13,193,188,185,215,72,73,81,248,156,118,115,119,0,240,157,108,232,225,8,83,222,84,130,155,43,32,66,235,224,97,127,239,248,95,21,19,158,158,165,86,100,90,167,153,107,250,4,114,143,119,38,32,23,52,37,63,107,212,5,200,217,112,100,128,255,145,235,15,94,138,92,56,228,70,161,236,147,120,45,205,106,219,148,206,75,50,65,48,187,22,15,179,251,204,82,123,44,200,57,20,215,146,159,104,132,182,210,55,41,152,23,18,43,183,28,228,71,240,70,248,139,140,32,89,20,247,151,30,153,5,214,0,242,55,32,151,62,92,124,206,173,150,182,250,175,7,19,196,58,250,83,26,253,226,48,77,64,160,222,254,14,155,98,147,168,209,136,19,64,94,48,10,193,190,188,25,171,49,247,91,23,24,27,125,4,104,92,238,182,209,11,28,12,99,184,41,4,131,161,67,215,181,239,222,248,1,70,113,144,175,94,212,19,208,83,168,108,129,152,44,164,24,201,3,5,253,35,216,40,151,198,82,232,177,0,135,187,48,11,163,11,244,146,18,67,87,151,89,0,97,17,168,8,141,37,183,150,100,216,226,234,18,193,182,39,137,246,184,50,220,58,250,229,125,140,123,96,43,14,186,10,17,25,229,27,237,241,25,24,50,240,52,70,230,123,33,222,75,0,213,145,16,210,87,210,236,139,117,7,176,247,16,69,185,241,148,93,146,126,113,16,17,188,186,166,146,41,188,101,83,230,226,208,186,137,36,206,86,81,24,105,128,94,204,210,1,24,40,254,11,164,29,236,91,52,211,82,213,197,131,225,117,116,159,151,86,149,73,89,141,71,8,106,237,135,229,202,9,81,24,233,144,33,7,51,229,69,242,158,98,255,174,232,203,190,163,6,29,17,25,148,89,103,229,237,90,20,90,100,100,199,9,127,40,205,212,174,237,85,130,183,239,43,202,73,28,134,95,108,48,20,185,234,147,167,137,255,189,192,198,113,40,229,101,220,27,196,250,242,65,132,61,185,150,255,172,61,201,34,129,47,144,161,16,13,224,221,253,164,128,45,157,144,1,31,61,9,117,143,104,50,122,73,147,80,105,48,226,5,231,205,101,39,199,95,37,140,73,6,252,19,250,196,112,147,230,188,80,118,146,130,3,125,241,9,117,145,65,33,123,95,38,210,207,94,8,160,59,151,193,85,244,147,249,151,104,56,227,140,47,145,127,94,203,75,179,74,25,20,255,204,208,20,160,168,198,244,109,24,71,129,71,155,148,132,124,153,168,34,56,196,80,129,237,213,222,240,190,0,246,170,120,218,56,178,213,108,144,100,45,162,253,107,64,89,123,22,37,98,34,51,245,44,51,214,224,66,137,242,81,22,251,81,6,77,176,145,122,233,69,101,187,139,14,197,16,119,217,50,215,75,184,233,76,185,153,236,120,237,34,131,7,20,16,211,246,185,211,209,80,67,98,122,180,230,82,129,43,75,215,189,166,77,246,132,14,209,193,65,89,46,18,159,129,179,30,243,223,154,202,236,185,76,79,172,43,40,72,104,208,175,22,84,4,124,28,39,155,248,79,61,20,151,69,238,249,102,28,49,249,34,129,7,162,216,53,191,115,104,15,78,243,184,179,220,247,105,184,173,116,212,213,253,79,226,151,5,200,45,135,106,48,55,243,156,16,173,119,189,3,199,77,11,168,161,162,237,185,89,150,148,204,194,156,17,237,188,10,39,112,38,209,186,16,68,113,207,220,88,44,230,117,254,188,184,92,255,194,65,179,54,100,65,143,90,102,245,112,44,205,58,247,125,136,185,71,137,7,58,79,252,131,237,210,210,190,26,251,189,117,115,45,132,23,93,38,103,102,200,20,90,31,128,131,143,229,225,70,245,33,29,12,192,192,199,75,187,128,41,155,231,246,156,41,138,110,162,84,29,121,84,95,82,242,244,31,219,47,151,75,193,70,126,185,104,47,20,212,163,146,30,251,158,132,142,116,73,26,204,34,178,203,76,137,223,57,141,65,124,96,232,106,163,26,80,190,111,171,204,2,231,206,137,119,210,93,18,128,47,96,234,170,85,196,34,105,113,141,83,248,84,203,119,168,128,37,4,151,224,216,159,204,225,179,1,49,131,89,126,240,74,132,202,89,208,190,24,113,174,171,181,150,176,222,34,226,12,169,122,130,30,116,126,152,248,44,251,85,125,150,232,37,13,223,120,204,56,55,213,225,66,71,45,184,87,55,110,116,186,203,130,65,157,29,45,163,69,109,184,183,5,126,65,16,36,157,115,238,226,124,158,178,36,83,157,54,94,234,18,232,19,105,31,69,209,187,56,42,221,13,188,207,105,143,143,227,208,153,84,94,144,229,12,152,123,46,194,210,231,117,39,26,182,151,186,236,125,82,81,197,84,198,209,13,228,143,237,111,236,134,45,253,160,7,190,252,60,124,74,180,5,162,40,109,160,234,181,149,79,251,11,155,241,208,205,100,123,194,223,193,219,31,69,159,217,45,171,175,165,180,248,37,127,103,59,13,121,233,3,64,140,186,41,4,254,120,81,118,249,83,160,42,4,207,49,235,145,133,212,185,8,80,252,154,202,152,126,141,37,190,104,198,30,155,142,34,176,53,104,247,177,22,125,107,104,164,230,121,246,158,208,184,157,111,254,112,98,128,121,43,193,111,38,0,71,11,124,172,107,225,85,89,245,26,171,26,157,98,137,240,29,232,43,67,95,194,213,235,114,232,84,90,48,200,86,17,110,65,189,65,147,75,83,72,24,149,207,193,253,165,62,30,245,34,87,15,169,187,172,149,243,66,141,68,124,246,24,98,95,184,230,226,142,4,170,35,219,5,135,251,83,124,159,162,97,71,126,139,185,0,67,212,65,20,157,96,27,56,214,134,38,92,229,167,243,131,57,53,72,134,253,158,79,75,167,137,225,231,116,38,134,210,242,133,118,76,11,120,31,211,118,245,27,150,49,181,164,65,154,21,66,208,34,192,214,207,57,159,126,42,153,9,123,155,237,47,10,104,231,49,46,196,156,218,57,213,5,213,178,101,189,234,99,248,185,105,112,51,87,149,237,132,46,233,18,246,158,196,123,60,202,127,63,56,152,75,183,102,50,3,64,157,31,6,227,192,188,107,6,55,16,242,207,251,10,54,47,208,246,113,164,36,1,66,88,70,133,185,218,82,22,218,127,205,125,56,112,115,209,134,238,145,60,170,52,152,120,66,47,16,221,202,142,202,93,163,188,100,206,76,195,71,161,229,127,110,9,253,21,176,13,107,7,30,250,73,37,25,23,193,198,76,86,106,220,135,98,35,94,75,184,146,138,8,244,82,198,254,127,161,123,59,102,31,38,115,10,205,230,17,159,213,133,213,244,158,10,79,197,171,57,58,210,82,157,146,153,85,227,207,70,77,229,38,104,100,175,116,47,63,72,15,207,109,76,217,169,160,163,133,202,33,244,107,239,249,242,35,56,160,90,251,34,120,114,4,92,204,109,20,19,9,251,106,63,118,57,69,114,19,24,131,68,222,185,255,145,8,96,112,247,242,106,5,71,255,159,236,117,63,108,53,205,102,60,45,88,165,104,255,39,226,192,76,81,172,132,6,31,132,140,140,50,68,87,143,7,36,44,102,186,108,63,51,129,226,237,35,119,154,129,62,76,24,162,162,57,24,210,251,53,133,157,239,154,87,8,166,110,204,242,35,125,45,94,146,176,147,40,111,41,71,121,250,111,3,231,249,119,24,55,50,34,223,118,212,247,195,205,60,73,154,167,168,119,43,102,122,6,152,84,23,2,91,134,107,198,171,0,96,10,86,87,229,74,42,214,137,245,131,13,150,172,236,23,132,95,159,155,166,21,50,111,216,218,204,215,244,144,29,13,144,194,172,74,216,14,5,186,79,88,252,237,33,211,191,126,195,104,182,176,86,156,80,6,117,5,79,123,108,106,139,238,103,235,228,188,12,49,209,152,35,70,175,45,54,168,43,17,90,32,93,29,243,12,224,79,36,16,125,185,174,9,179,16,97,145,53,218,217,226,63,116,161,53,134,118,224,108,21,173,85,25,176,239,72,62,52,60,194,225,41,123,24,162,186,0,20,33,135,220,147,77,29,101,122,134,101,115,158,168,69,18,133,62,149,66,227,41,110,189,228,64,238,163,126,211,218,250,78,145,220,121,212,133,96,2,106,27,87,103,213,8,9,106,180,23,157,251,84,194,230,154,232,127,150,4,171,215,246,39,80,129,237,197,194,89,8,122,80,114,120,233,87,225,131,5,33,207,15,37,84,70,234,255,244,11,183,95,237,62,253,48,22,152,210,56,74,20,8,40,189,74,163,17,207,83,215,135,95,180,25,61,15,178,129,182,167,135,251,83,245,46,62,12,110,230,55,176,149,242,231,158,122,73,95,253,43,77,110,130,158,250,85,20,234,250,78,80,15,210,4,218,64,7,26,82,163,66,94,67,150,249,246,65,243,153,22,224,186,37,24,134,64,35,68,138,46,101,254,177,19,163,68,31,72,140,44,188,129,142,61,193,185,83,184,206,79,135,195,38,2,32,230,84,161,10,103,149,117,219,18,141,240,155,211,254,44,127,80,47,8,97,19,163,209,194,12,178,31,206,126,115,194,100,235,213,50,180,170,213,173,229,118,57,51,82,48,23,19,64,113,109,81,141,251,252,80,47,52,10,148,178,77,4,195,70,113,189,116,235,170,129,3,180,8,94,139,98,219,226,208,0,78,147,111,31,93,21,30,51,52,169,91,158,52,236,151,144,109,228,89,109,130,12,157,30,143,15,186,107,96,44,42,249,137,104,206,114,244,193,65,48,213,231,121,105,0,161,155,230,96,88,156,147,231,143,8,187,48,138,42,109,204,23,206,134,69,32,105,219,181,187,34,30,51,231,197,70,11,49,211,29,178,147,9,167,198,111,57,146,9,51,62,59,163,48,135,116,210,89,203,174,3,93,221,248,233,196,248,84,254,224,119,186,160,107,130,237,89,140,32,120,237,178,0,243,132,24,144,18,61,161,177,15,174,215,243,191,182,179,116,209,50,226,147,140,193,1,66,15,104,107,103,41,14,142,212,128,130,28,40,215,200,134,190,96,186,237,138,79,124,134,12,5,16,56,128,207,233,216,86,211,177,20,204,28,147,31,225,56,124,147,237,245,15,224,142,87,36,85,149,70,120,54,0,0,188,0,58,6,21,182,125,168,179,161,141,225,192,128,202,201,229,134,65,82,81,171,160,190,179,104,112,62,55,134,126,197,78,32,219,183,23,255,68,178,25,229,101,81,235,215,28,125,118,189,28,53,77,131,55,57,238,0,230,90,27,84,73,116,66,33,107,28,81,163,143,71,37,152,129,210,53,203,99,142,68,132,158,67,57,81,77,110,255,192,51,51,134,28,182,223,155,137,215,31,132,151,43,102,239,121,129,187,65,41,101,190,154,202,124,107,47,9,152,70,202,187,252,78,211,46,163,162,190,63,201,185,124,69,126,180,105,191,33,87,151,182,61,240,34,74,250,207,50,167,152,210,28,151,113,145,16,33,22,207,168,106,237,133,165,102,210,31,102,234,162,101,42,121,167,168,172,168,170,152,221,213,77,196,165,33,82,220,184,63,210,40,186,110,29,192,13,102,84,93,47,176,105,153,47,173,155,218,107,70,40,68,240,105,169,29,139,78,190,179,12,253,119,254,19,105,35,11,209,92,235,238,235,100,180,62,178,58,36,188,108,34,238,107,153,65,149,74,217,205,20,236,0,13,165,171,163,54,151,63,167,44,87,180,46,30,201,134,229,162,161,5,10,149,50,168,234,10,137,229,183,130,138,210,119,228,246,187,63,203,156,118,141,43,96,202,182,197,144,145,5,74,176,197,244,145,202,85,14,210,52,194,27,218,102,154,93,47,228,150,223,32,177,236,67,209,99,199,182,198,195,12,6,146,164,160,241,16,94,16,255,182,58,134,16,164,74,186,53,6,71,252,243,196,47,14,177,201,22,168,86,156,164,46,159,152,149,168,221,4,134,120,100,41,122,74,1,167,130,159,109,177,97,239,118,102,195,27,152,225,238,45,254,96,130,178,116,6,131,155,243,203,221,51,217,154,203,136,15,206,19,55,103,123,161,43,79,0,107,158,113,253,19,229,11,190,111,17,174,157,28,119,120,50,14,241,123,231,195,153,185,246,80,79,247,57,156,89,62,168,102,212,204,250,203,59,116,50,239,247,96,37,143,179,33,77,207,107,63,105,169,21,220,25,103,201,162,102,248,236,50,155,223,225,68,136,135,165,197,197,67,52,54,250,32,247,64,212,42,88,187,191,114,80,226,10,50,180,184,82,164,128,254,249,130,233,152,217,52,124,11,174,38,99,85,142,245,98,199,67,252,235,214,197,184,45,40,230,169,54,184,208,96,71,186,208,53,13,21,193,192,143,88,180,90,154,179,66,200,32,148,59,184,87,234,24,172,187,60,17,127,119,95,130,28,119,222,144,22,162,189,33,48,220,27,40,83,64,95,163,43,178,170,173,14,10,212,212,253,227,52,111,89,174,21,252,179,25,178,56,197,209,97,40,22,251,223,113,163,182,185,183,161,191,42,187,129,207,2,144,103,100,170,235,101,147,3,225,239,135,51,97,188,144,156,3,235,104,118,157,132,13,18,220,3,31,254,156,84,43,55,111,225,207,151,25,24,208,174,54,153,20,24,25,111,162,196,169,58,176,156,212,92,221,210,25,202,30,253,160,235,97,129,129,95,183,199,3,14,42,39,243,103,210,6,109,248,173,240,255,198,76,192,152,125,196,118,15,188,34,180,195,250,202,112,233,40,229,9,68,43,169,202,106,208,11,138,170,185,40,98,3,102,43,80,29,215,173,230,175,152,222,131,78,115,77,170,235,201,247,114,195,187,156,217,45,71,214,251,177,59,141,133,92,158,54,14,234,234,29,51,192,20,241,198,153,103,137,86,211,187,120,92,56,231,151,218,157,241,203,19,242,88,227,195,45,21,64,46,19,73,1,187,166,52,202,94,88,187,237,228,187,150,153,143,172,98,0,67,46,192,102,19,99,50,132,255,78,132,231,158,92,79,99,110,164,228,43,82,183,219,92,76,105,247,189,176,1,210,177,113,22,76,202,179,88,168,116,193,83,237,229,122,42,60,80,161,161,21,172,56,80,240,94,227,40,45,197,87,241,105,199,56,92,161,237,71,116,114,184,160,196,120,20,221,147,134,73,139,70,64,194,121,138,27,32,30,167,167,50,97,219,221,35,172,21,109,133,240,71,51,222,87,163,194,1,33,114,176,70,46,3,67,75,199,154,59,131,130,95,199,241,32,14,13,242,211,193,194,39,233,125,44,20,52,38,149,189,243,244,194,17,235,64,8,55,15,195,106,184,87,85,45,244,177,51,182,254,53,3,238,127,203,46,37,112,147,117,51,41,43,170,48,201,87,197,178,227,250,204,55,191,113,113,215,169,196,19,161,138,203,208,50,104,92,145,228,27,153,119,181,36,24,197,171,176,148,59,26,53,217,49,41,55,17,71,39,137,57,101,202,69,207,106,56,87,128,212,12,165,74,117,132,89,224,86,102,29,203,90,179,209,161,233,251,235,93,5,241,57,155,120,53,173,43,160,198,168,240,144,1,9,170,90,57,217,106,33,180,25,242,47,170,166,50,23,200,246,176,221,223,40,152,18,81,146,197,248,139,88,23,192,16,82,25,187,229,243,14,184,135,250,240,158,77,210,67,22,116,60,22,151,33,211,53,255,28,199,205,216,129,202,39,51,104,6,127,215,206,15,224,198,71,221,111,22,97,44,255,83,196,17,186,243,140,72,252,61,3,77,188,44,196,160,237,235,74,128,210,156,80,112,83,70,19,47,183,128,18,241,40,203,197,197,107,30,236,151,252,76,173,28,85,244,177,194,251,146,204,70,233,53,81,163,208,19,236,48,72,164,222,130,103,223,161,219,161,39,198,82,226,167,184,119,49,21,98,123,0,235,125,223,21,140,235,13,150,249,93,178,164,189,10,66,59,110,59,34,218,175,208,203,209,160,159,166,104,205,75,1,67,202,21,78,8,65,59,1,91,173,138,121,211,158,20,242,200,50,199,10,117,180,55,60,177,94,30,232,191,216,83,100,78,46,203,196,171,71,210,35,222,65,46,135,253,165,31,190,6,65,70,106,168,194,120,28,8,128,123,207,215,1,146,5,253,77,9,236,158,113,33,72,226,169,250,163,90,75,236,33,31,243,79,239,255,34,113,96,183,115,213,75,163,39,129,126,205,142,43,210,101,219,218,86,33,223,119,229,30,103,159,27,69,46,6,106,246,84,244,228,134,198,222,229,179,49,43,164,175,191,7,242,37,145,181,43,73,53,103,232,172,152,123,58,59,189,61,118,162,202,75,125,225,176,111,70,0,36,35,21,163,88,199,141,135,167,83,249,67,234,168,105,221,87,189,153,196,93,163,216,185,81,214,22,7,116,207,144,61,83,125,164,229,21,21,33,167,200,76,63,231,198,210,21,0,208,197,236,126,202,19,98,224,110,83,163,92,160,150,253,158,47,103,31,158,67,114,91,86,246,136,62,27,17,168,159,2,58,173,98,91,133,203,119,194,205,223,10,55,64,111,29,114,185,84,201,83,105,37,136,197,6,199,161,112,37,205,171,2,227,89,145,134,173,149,99,43,140,140,134,115,110,48,181,201,58,96,62,212,201,92,49,107,49,234,7,124,242,177,226,207,97,118,188,99,21,9,61,153,215,146,4,0,154,166,165,3,81,123,138,170,32,61,199,8,208,239,65,228,81,245,40,120,6,151,253,24,149,193,139,40,110,114,32,90,31,45,51,161,75,58,88,204,217,206,13,82,238,238,24,136,133,73,100,217,35,84,217,188,52,175,94,174,158,51,60,114,117,50,142,96,57,38,14,228,172,226,24,179,210,77,205,179,217,2,114,126,112,177,10,208,221,176,214,211,229,14,142,15,77,235,156,70,195,50,225,181,160,146,110,111,104,22,75,63,219,81,68,10,197,108,31,133,71,47,224,52,94,158,214,11,141,53,150,94,0,228,113,131,205,134,87,70,129,239,249,32,249,148,131,173,67,61,54,137,120,83,95,46,91,125,118,234,48,82,6,172,188,134,77,119,200,203,222,20,213,213,191,154,226,225,95,156,11,94,105,57,74,50,250,182,97,176,77,142,43,143,63,2,6,35,23,78,74,108,3,183,172,217,111,154,97,35,3,10,103,121,14,235,14,27,252,236,237,36,55,70,184,151,34,180,33,78,225,165,118,239,59,44,109,0,29,157,251,41,248,9,192,146,201,192,30,157,178,243,22,9,138,172,60,249,74,241,240,28,38,116,233,119,209,33,60,61,138,239,223,254,205,183,228,102,141,59,195,137,131,59,106,41,199,199,23,15,5,209,183,244,81,178,217,166,201,7,197,48,8,13,157,75,27,180,47,160,113,146,17,85,156,235,251,81,101,134,240,216,198,247,113,204,170,52,238,44,121,91,127,244,124,241,13,254,144,221,241,132,149,40,56,159,41,42,221,12,68,144,171,144,154,238,73,4,207,218,57,124,104,122,83,187,189,114,57,226,152,201,148,22,28,147,233,101,46,98,207,229,136,112,128,130,232,111,71,121,91,84,100,241,59,86,237,133,5,136,176,31,83,85,139,141,207,38,100,216,94,45,241,76,68,208,150,24,128,209,243,141,241,97,83,198,195,81,57,119,187,0,2,208,102,56,142,25,71,66,194,94,89,247,44,42,219,43,111,142,23,179,162,240,233,245,235,1,209,42,227,68,53,106,124,142,111,92,30,113,88,236,64,220,236,226,244,136,27,106,231,192,47,39,17,148,132,242,183,81,235,83,228,216,128,97,198,171,237,120,33,70,202,102,124,29,92,138,172,96,96,124,130,186,4,198,233,165,112,36,78,139,136,232,152,48,4,193,199,49,240,97,98,91,228,70,67,88,22,8,63,8,30,218,169,216,96,74,96,24,243,173,196,240,225,244,2,160,19,14,84,41,237,172,241,59,140,142,137,216,202,183,92,99,117,205,14,66,185,39,230,142,12,92,231,168,132,157,8,105,94,95,125,149,109,187,96,136,173,144,180,5,132,16,112,95,236,59,147,84,46,194,41,35,121,69,229,249,76,31,186,150,37,123,50,158,51,180,228,24,85,201,34,97,69,8,215,215,18,8,191,205,169,119,94,4,19,25,102,90,115,201,156,42,215,82,135,42,169,144,194,145,122,240,211,81,255,158,155,69,222,50,196,246,253,87,250,193,189,182,14,2,235,255,195,173,143,229,39,128,88,75,83,3,34,93,121,105,6,42,189,107,232,34,155,185,199,88,192,162,216,146,100,231,224,155,36,252,12,116,25,71,221,79,121,219,169,241,217,248,176,40,219,43,89,72,17,71,18,59,44,81,147,111,133,169,66,203,102,185,76,230,248,42,26,4,169,195,241,186,168,192,181,123,75,197,105,74,212,222,48,50,28,82,167,61,12,186,67,228,201,34,139,185,55,124,37,34,236,114,247,96,148,152,134,95,185,157,229,103,121,170,63,50,117,79,53,179,206,198,143,206,179,23,49,135,70,63,24,4,25,106,128,33,98,90,150,240,194,17,15,0,230,136,22,80,237,79,204,214,77,141,80,64,117,52,90,53,54,228,98,198,43,126,182,173,229,179,227,14,206,130,74,203,3,46,240,245,191,230,10,146,45,249,45,77,19,45,168,63,25,56,53,125,66,67,64,225,144,33,178,8,185,126,30,0,210,191,120,217,177,129,202,123,154,130,191,76,114,182,6,171,84,158,38,237,29,29,205,169,209,39,249,158,166,227,108,102,110,110,176,22,92,38,119,134,196,217,35,214,183,8,225,172,233,1,129,170,58,91,79,237,76,46,25,249,81,10,183,222,174,245,51,62,97,239,238,181,227,171,60,84,94,135,46,231,123,104,118,200,189,44,46,165,31,21,235,141,88,159,89,189,253,213,250,29,123,50,183,41,86,225,80,131,149,133,224,220,17,34,88,72,255,7,74,145,142,194,36,34,217,8,26,218,243,122,50,245,36,233,251,5,90,200,75,137,140,125,103,68,228,148,152,224,251,76,204,134,16,104,0,206,10,153,126,253,150,147,1,239,170,95,178,116,93,22,170,78,27,114,76,96,235,249,159,119,188,157,221,32,57,3,126,196,228,162,12,196,217,168,32,229,79,117,160,237,115,34,194,195,181,137,220,13,244,114,87,160,27,252,187,190,126,61,172,144,70,87,12,123,147,220,85,20,27,229,104,205,66,154,62,248,92,150,165,246,42,189,139,157,194,134,85,110,223,255,34,246,109,61,234,69,67,174,34,88,228,225,184,48,126,29,93,156,28,91,87,85,32,221,50,144,182,123,183,140,128,64,200,240,75,170,139,18,18,135,178,70,80,211,252,48,134,9,136,252,238,10,254,199,20,36,41,34,148,255,198,107,23,104,187,97,73,86,166,213,158,12,68,12,240,170,145,25,46,254,140,241,145,51,138,82,145,154,164,246,9,174,227,37,124,145,73,12,62,255,184,53,179,165,213,144,98,137,98,239,66,66,103,65,46,196,167,23,51,188,109,179,193,146,0,25,136,18,103,179,81,73,194,114,44,174,20,108,108,169,72,229,162,7,52,249,157,188,231,160,242,82,44,132,98,83,38,124,65,163,95,152,18,126,74,104,33,34,158,137,216,235,171,178,141,247,232,163,118,164,57,204,147,170,168,48,6,29,246,122,20,60,54,112,212,235,206,96,165,145,15,26,150,57,72,251,84,160,212,126,30,143,196,146,234,39,211,85,91,59,222,88,18,50,107,173,173,41,161,183,103,58,173,0,61,238,35,162,212,126,209,171,225,149,24,14,174,10,22,46,181,65,133,15,205,198,122,178,14,152,57,193,108,177,243,133,222,118,165,139,61,129,85,73,31,203,107,61,178,88,223,212,144,43,153,218,94,193,146,131,41,203,22,78,142,93,9,16,178,224,164,115,233,142,241,138,216,148,117,133,6,33,45,217,157,80,16,153,234,83,157,55,20,101,148,133,95,250,198,2,114,250,7,251,44,36,151,164,85,136,159,8,161,72,59,113,161,158,67,179,215,139,22,178,178,122,254,54,133,190,170,188,112,101,46,46,117,39,11,142,41,30,87,244,216,227,28,73,212,39,172,49,43,44,131,46,47,3,242,204,57,81,13,224,80,129,249,170,213,234,175,96,204,31,171,169,141,238,55,184,28,13,74,245,8,95,84,208,134,152,212,63,224,11,177,39,196,226,190,194,73,135,41,175,65,111,74,92,37,65,119,54,119,52,31,127,233,166,72,107,24,129,144,165,89,27,17,79,173,101,241,145,6,223,8,239,159,234,242,121,170,197,211,203,233,166,5,156,208,152,251,63,160,236,36,44,2,233,180,148,203,175,251,250,99,191,232,32,10,70,133,22,90,110,155,93,95,44,155,249,233,56,24,247,169,161,91,188,49,56,190,93,137,118,186,247,49,112,217,35,157,218,76,59,15,22,57,99,55,173,133,167,76,51,79,31,107,32,49,136,159,141,101,208,61,130,17,96,85,125,159,17,51,21,233,98,155,242,62,225,125,161,116,146,160,200,103,187,17,192,136,200,89,8,129,169,97,37,87,26,195,95,154,230,198,117,195,179,142,190,65,121,25,187,17,63,65,8,34,226,131,70,22,149,148,100,153,211,23,168,153,19,192,209,254,76,132,156,62,41,16,224,3,178,20,27,197,186,21,107,239,139,107,141,254,223,15,19,60,118,183,111,93,173,133,85,120,101,111,179,255,207,211,11,121,207,120,167,118,48,80,222,0,116,62,25,121,138,190,14,129,254,8,192,166,216,55,83,64,130,174,177,253,103,177,106,54,147,67,236,13,242,183,255,34,39,184,57,245,65,72,209,177,188,24,165,67,230,232,2,59,224,138,212,231,136,59,128,203,145,237,148,153,77,98,48,177,36,55,49,207,31,148,137,25,237,63,166,207,10,96,129,137,123,160,212,132,126,173,93,98,243,193,160,1,190,97,235,113,158,144,14,234,148,61,23,15,43,23,33,0,130,173,121,198,131,36,238,162,75,129,139,72,125,187,101,86,254,105,245,22,180,219,171,211,130,190,97,47,164,73,208,186,60,44,50,11,3,235,229,249,150,28,251,152,96,121,196,50,116,211,142,211,144,212,190,149,28,134,141,181,76,250,1,123,105,67,9,70,99,5,208,95,61,42,239,11,67,177,70,112,124,156,142,163,92,120,60,244,217,154,23,15,254,229,47,20,23,42,67,246,39,43,82,134,133,100,161,11,180,0,172,62,58,187,237,151,31,133,21,222,112,57,57,150,101,0,183,239,239,27,165,59,234,68,230,52,21,185,18,198,121,249,192,168,11,96,99,164,111,123,58,16,101,188,231,100,9,218,38,231,31,245,141,228,159,121,238,230,129,25,101,13,33,109,61,177,172,142,78,227,64,36,90,123,55,128,219,196,20,111,34,222,70,0,235,173,37,201,211,109,79,181,83,49,89,182,8,70,48,1,113,248,7,145,229,142,67,33,48,119,191,182,86,233,160,128,2,150,69,181,29,3,95,97,22,50,183,84,72,154,233,153,82,113,118,5,244,41,108,160,156,181,97,131,2,25,208,220,135,254,194,164,210,42,200,78,10,220,63,237,164,110,97,155,242,65,12,146,64,199,144,38,151,8,201,7,57,116,149,74,251,228,70,130,13,23,122,40,110,101,211,143,252,88,112,136,207,116,93,76,87,197,172,192,208,58,240,193,209,45,161,169,159,53,138,66,71,87,212,77,5,34,98,162,112,238,117,220,224,115,118,102,33,88,206,254,54,216,148,220,239,197,174,32,93,164,8,180,85,111,241,143,237,179,235,182,62,203,255,57,113,235,25,17,229,149,64,85,198,217,11,161,15,95,13,25,122,172,70,252,50,52,254,0,216,128,75,62,226,14,113,163,46,52,113,134,219,239,242,224,143,51,33,170,12,172,58,119,80,123,251,2,24,10,129,115,206,7,184,203,73,36,33,243,97,64,213,155,132,183,238,209,6,247,33,111,119,37,78,62,237,114,152,169,66,191,7,229,172,180,63,185,37,122,38,89,176,83,253,30,143,65,82,132,212,235,254,221,77,14,202,144,94,7,112,152,206,154,109,91,246,21,179,106,32,86,79,57,83,184,202,92,121,206,52,115,16,120,132,145,163,100,75,234,33,242,41,146,85,123,105,50,125,148,31,33,187,163,169,218,174,39,185,186,93,215,27,41,162,122,200,21,18,204,160,73,72,227,112,96,13,7,231,169,224,144,29,236,164,133,63,232,115,31,172,97,243,199,18,43,146,237,240,221,25,97,110,36,222,83,238,126,94,225,134,139,62,93,9,56,59,181,186,18,99,152,219,211,236,218,203,236,20,241,23,155,213,6,129,127,122,71,233,186,169,51,153,160,253,176,7,133,50,197,90,63,171,88,232,31,245,27,255,124,180,200,83,99,214,90,33,168,3,60,5,107,6,39,112,253,176,110,122,227,213,51,12,54,145,134,134,219,185,71,96,126,52,200,120,59,71,173,107,143,221,166,244,253,108,42,155,29,161,1,205,87,179,218,255,219,159,240,231,180,247,66,17,3,230,148,82,65,1,190,244,137,79,99,46,81,93,55,26,84,58,245,105,86,26,76,87,52,9,23,238,65,56,171,193,59,119,97,88,58,107,39,236,189,57,69,158,191,225,239,168,213,31,220,155,86,34,36,117,183,213,11,7,120,151,253,30,244,224,201,202,31,82,35,178,120,162,97,138,116,209,203,212,170,210,165,108,206,94,115,99,33,194,235,128,56,17,151,122,172,144,49,42,200,127,67,199,103,18,114,123,173,17,14,17,44,194,134,143,212,75,154,189,202,140,249,58,79,234,56,102,25,34,109,208,142,242,163,243,34,136,0,36,195,126,147,235,230,199,204,123,137,129,207,251,102,132,219,162,229,195,200,19,142,205,30,19,107,200,91,205,137,107,100,158,214,38,147,232,1,57,165,41,237,115,6,122,118,157,109,232,239,159,101,117,228,168,250,229,3,84,220,137,89,238,243,58,85,211,251,116,2,65,145,157,177,213,95,158,27,184,233,91,232,37,238,54,231,148,87,7,189,242,214,101,63,241,141,16,236,111,172,174,215,51,255,71,125,21,75,240,111,178,94,254,152,155,182,105,48,61,106,102,215,89,111,13,171,79,233,3,75,245,18,9,72,230,239,89,32,115,251,112,219,163,72,230,121,31,103,245,174,1,4,20,97,75,234,148,82,204,222,175,120,204,87,189,247,68,142,34,211,46,54,204,235,236,163,80,41,144,248,36,38,122,13,128,225,94,189,190,55,214,249,24,250,254,85,51,255,79,171,245,101,34,33,34,124,27,197,38,144,24,145,206,200,164,143,24,20,95,12,101,239,201,65,237,136,167,71,111,95,174,6,107,143,73,248,198,158,35,203,157,22,132,120,87,14,237,67,40,85,37,251,140,237,206,232,228,136,86,170,144,37,109,54,50,204,143,208,229,222,162,44,253,27,166,174,190,114,126,67,135,179,146,11,113,189,214,193,108,169,87,10,64,46,129,148,255,117,221,108,76,118,31,233,157,236,56,183,156,232,55,24,195,168,244,99,144,66,107,110,124,97,113,211,203,132,198,218,36,49,242,150,178,9,74,64,157,157,190,64,244,220,18,19,163,6,176,245,194,116,181,225,179,174,86,201,102,2,24,229,126,197,57,104,180,87,242,69,230,184,152,80,133,46,102,185,157,19,250,255,4,123,46,11,136,215,103,54,251,141,237,79,219,78,57,52,250,23,183,149,123,81,180,106,222,231,214,37,219,204,251,43,51,185,181,13,35,232,220,160,26,49,229,168,30,89,177,212,179,246,100,223,139,213,118,238,128,6,188,89,45,120,16,87,123,61,53,27,153,37,172,226,52,168,235,158,104,36,101,132,115,66,89,240,133,241,223,208,246,161,60,125,69,12,176,47,67,198,100,232,20,244,1,190,246,240,206,157,229,97,136,132,180,0,119,255,177,31,147,44,22,85,75,207,82,250,45,184,49,157,167,80,32,73,214,97,244,220,71,247,71,9,207,223,168,118,128,141,212,166,163,61,84,249,181,36,19,224,81,132,31,117,9,80,138,18,28,161,79,141,139,33,195,93,177,208,51,220,99,100,78,135,201,3,221,233,31,140,213,206,125,157,171,98,156,125,50,71,161,175,38,157,78,68,215,79,98,221,203,78,236,26,112,116,180,81,163,39,219,177,216,195,151,134,72,102,66,220,136,147,214,76,104,177,67,144,27,34,102,149,211,99,157,236,64,147,143,117,63,12,231,154,240,57,191,17,194,147,87,23,78,200,60,59,163,137,115,229,193,113,135,236,217,108,31,15,96,228,83,223,54,44,184,194,143,115,186,148,135,112,14,146,191,59,137,127,32,228,155,210,196,239,36,52,254,199,137,124,50,67,229,175,137,96,228,162,113,220,148,242,153,168,183,11,211,249,23,223,239,214,225,192,139,120,254,31,123,65,40,65,119,231,206,254,236,153,44,188,46,125,165,38,249,32,229,69,227,108,38,87,32,66,2,110,97,45,24,254,207,7,223,40,237,18,217,180,85,176,29,200,164,206,50,61,74,122,149,160,110,98,184,1,205,90,246,252,238,48,127,5,18,244,164,60,62,201,190,135,114,18,217,113,161,44,99,167,188,250,16,32,214,83,26,12,119,93,79,133,179,166,129,181,6,233,138,250,1,251,70,3,236,232,78,45,216,253,70,151,125,125,111,184,94,3,166,140,194,82,98,209,154,140,30,252,147,201,44,86,68,66,239,137,64,183,249,90,159,52,212,126,236,152,174,209,160,171,23,213,54,121,4,138,114,96,220,225,166,130,107,93,108,240,26,114,25,135,57,169,190,242,220,206,218,222,109,55,223,27,183,41,189,217,230,71,161,153,63,28,2,182,131,39,110,253,62,246,12,242,232,35,65,137,148,96,171,118,69,170,52,232,38,77,56,219,245,157,119,6,76,200,199,115,116,13,155,250,221,182,113,20,147,145,12,254,16,116,94,204,59,99,165,205,185,29,142,201,129,47,214,127,253,144,226,0,63,236,246,196,219,23,46,17,237,11,165,110,215,139,95,111,40,183,249,158,188,235,245,153,83,51,114,58,156,84,149,97,33,236,21,224,95,2,49,115,239,215,206,88,239,106,15,135,166,181,169,65,91,76,72,81,47,4,244,42,17,51,105,203,57,131,53,86,46,189,127,3,13,89,230,66,68,210,229,87,187,163,186,39,229,44,181,241,52,62,14,50,97,144,53,128,177,203,163,162,135,182,142,206,12,253,244,109,216,48,230,135,236,94,53,209,1,28,15,162,67,223,95,85,108,190,94,158,73,22,135,67,78,89,223,255,115,185,187,52,39,28,6,94,202,21,106,53,104,46,38,165,184,139,126,186,173,38,23,58,10,182,9,55,34,168,243,197,172,28,244,202,226,208,67,206,170,245,196,25,14,10,213,60,79,27,55,220,234,148,242,120,172,186,80,130,98,40,129,248,98,49,221,245,235,24,123,51,192,121,88,248,198,170,87,136,57,86,155,25,126,127,161,100,151,57,171,183,181,89,39,67,107,148,247,91,196,233,196,69,12,13,24,108,155,204,254,205,146,117,67,3,93,235,74,125,201,205,217,236,141,250,112,39,9,88,107,174,140,30,18,187,69,163,216,53,36,204,153,223,122,237,176,122,12,110,29,30,117,28,175,206,235,147,163,77,45,151,197,124,93,27,110,187,113,89,203,229,191,21,226,83,30,209,167,11,123,205,46,8,182,132,5,158,117,67,5,79,96,249,123,243,116,237,237,138,45,39,120,38,244,183,194,40,97,36,133,55,205,200,88,238,118,105,60,80,79,234,45,198,255,88,172,100,85,113,154,177,102,129,2,200,60,100,62,30,244,174,154,27,82,158,106,244,73,142,223,226,30,23,13,22,167,100,60,140,78,114,249,137,207,180,252,205,193,54,62,222,84,194,0,15,143,171,193,132,186,47,168,80,138,55,97,132,106,95,98,230,42,161,103,218,50,144,54,60,177,249,197,111,187,197,111,171,108,160,38,88,10,30,139,9,43,245,122,32,94,152,48,87,52,105,169,1,121,75,233,140,118,62,197,125,53,238,187,4,121,107,49,87,24,8,109,205,254,102,112,255,231,220,224,107,33,181,217,136,146,38,92,152,79,54,191,22,30,169,222,113,196,139,22,195,221,112,55,67,237,68,208,46,133,46,136,175,58,39,49,250,30,226,87,107,14,217,187,85,150,79,60,43,202,93,211,165,19,3,100,185,98,96,237,107,73,185,140,45,57,233,79,42,243,137,175,165,181,25,115,105,58,65,223,84,66,24,250,144,112,0,170,148,229,171,45,137,220,152,53,153,10,4,88,127,73,31,134,64,140,76,249,121,222,122,76,244,12,214,66,52,96,174,35,44,154,23,124,162,246,203,144,154,107,23,39,101,29,118,129,60,215,128,162,135,61,153,191,226,136,33,90,245,162,215,56,0,87,105,54,198,178,125,72,201,124,59,150,182,31,70,173,28,249,228,137,43,209,45,58,241,54,12,85,228,21,27,165,40,196,239,68,21,191,91,253,199,89,61,75,207,42,169,84,108,207,172,18,102,70,73,52,46,127,109,135,221,52,237,75,71,209,128,91,169,229,13,61,181,5,243,66,42,165,118,58,54,232,63,165,147,40,48,77,196,6,118,204,152,69,72,67,71,11,144,74,94,74,255,155,38,214,93,5,193,169,241,65,15,73,162,214,112,44,53,101,180,31,9,10,156,96,10,255,178,37,111,188,0,168,140,84,10,67,184,16,166,108,54,95,195,251,149,122,245,188,165,194,255,150,77,169,121,142,68,51,219,78,50,216,252,69,226,164,62,206,94,77,244,120,113,122,241,242,53,48,108,4,9,244,151,35,245,255,60,140,240,12,123,247,95,106,160,67,20,88,225,66,95,199,8,184,134,41,6,196,136,28,63,200,0,127,93,179,1,171,14,137,28,158,156,47,77,155,178,226,245,147,86,199,207,83,250,127,90,38,0,144,124,57,2,162,33,87,219,10,5,181,106,58,147,222,66,104,214,215,46,220,36,16,97,149,229,254,90,45,3,49,217,60,80,80,229,95,232,63,27,214,184,94,24,180,39,159,73,251,20,197,116,200,105,82,1,78,211,55,209,123,254,43,179,247,128,108,120,219,228,141,48,115,7,233,124,130,190,144,220,149,191,174,133,58,193,176,15,99,131,241,253,172,48,202,81,229,216,101,117,140,231,31,141,176,41,143,167,15,14,204,177,226,99,240,47,60,244,10,53,63,227,71,140,251,65,86,71,80,232,70,87,5,186,37,150,126,166,17,231,138,132,64,26,182,103,89,156,145,74,26,157,88,199,145,32,120,3,183,240,12,231,57,146,192,19,248,61,24,190,213,41,82,89,71,191,158,199,163,188,237,84,8,99,17,224,180,43,53,63,97,47,188,144,211,177,133,110,120,198,135,13,247,39,246,145,199,194,236,67,174,50,196,87,86,56,186,232,35,198,78,232,102,180,107,74,103,176,252,27,222,135,151,21,75,48,26,107,3,154,212,106,176,94,117,167,73,12,91,51,25,219,144,125,205,235,176,205,36,101,193,186,175,183,225,48,205,114,62,66,40,59,128,180,176,99,143,47,207,131,136,80,146,147,21,47,228,161,226,140,34,107,108,103,146,63,44,126,201,70,131,221,200,77,26,230,85,143,214,51,79,218,228,10,55,72,94,170,186,127,66,162,33,217,219,91,189,208,150,111,91,156,30,231,252,140,144,61,159,63,244,48,11,24,162,145,58,252,184,136,28,78,14,229,207,122,13,187,196,67,78,133,45,152,60,233,75,100,218,119,74,33,233,74,58,48,23,237,98,250,155,145,208,132,41,116,135,191,230,5,145,58,107,100,191,230,95,234,168,133,43,179,221,104,215,176,130,32,52,90,150,64,155,50,150,201,17,248,251,147,214,235,7,230,162,200,205,53,16,110,35,101,222,0,54,181,223,168,166,86,220,212,247,201,136,138,106,39,225,77,188,223,71,126,180,214,51,178,161,177,27,163,153,159,207,17,18,145,217,92,246,95,228,225,147,211,225,186,205,210,57,85,63,13,193,23,48,171,161,97,221,103,23,177,160,221,151,128,119,114,166,231,219,42,175,52,172,44,122,195,174,32,63,62,142,29,9,37,88,169,246,42,68,171,216,23,101,75,35,161,85,67,126,36,129,119,129,242,114,242,119,98,24,197,203,73,175,60,14,79,201,62,14,242,156,241,239,129,241,151,11,122,39,13,90,23,86,137,79,61,167,117,205,116,151,68,48,77,150,179,45,232,156,197,156,44,0,145,159,104,245,124,77,103,137,204,160,138,161,232,174,154,100,187,137,19,118,157,241,195,128,21,219,239,244,62,17,138,137,169,105,177,215,245,132,140,6,21,109,69,21,21,132,42,242,85,96,255,9,188,193,104,152,216,98,15,119,242,151,177,70,159,207,241,172,41,102,122,244,96,4,84,203,185,138,220,27,98,255,190,141,85,39,157,96,190,145,227,227,240,90,22,104,243,242,13,58,254,161,189,56,6,100,102,254,174,202,20,200,246,7,52,16,155,115,140,87,132,191,253,115,39,133,94,30,221,42,184,140,246,29,192,235,6,248,75,6,81,205,13,159,182,16,246,70,58,242,138,152,207,158,224,206,191,104,72,194,29,40,196,81,82,59,165,82,219,176,125,20,146,221,194,223,194,137,54,164,217,48,75,243,99,189,146,238,51,83,164,125,117,95,29,169,67,58,234,214,41,0,237,248,140,35,28,136,66,112,235,15,149,185,161,26,58,202,181,156,90,22,158,193,177,94,52,164,192,100,90,7,89,196,230,53,161,178,249,234,11,190,34,88,30,195,67,13,189,135,153,223,187,245,192,81,52,246,167,162,164,210,3,110,86,121,20,195,39,65,186,226,1,90,157,147,129,182,0,17,214,233,254,91,21,95,54,39,123,157,158,192,184,128,214,6,187,189,106,36,240,71,84,184,215,99,40,138,211,157,27,141,143,229,96,54,50,243,240,42,12,87,227,210,64,190,71,250,67,237,232,185,79,93,35,167,131,12,254,73,128,159,192,15,27,171,2,125,126,24,53,128,240,73,154,250,131,193,225,108,108,102,59,36,111,107,149,36,129,208,244,162,108,158,152,151,164,234,96,221,17,17,48,141,240,17,252,151,172,71,196,181,119,145,83,83,134,215,56,54,231,224,142,155,19,214,97,238,133,51,69,148,206,43,235,230,105,29,161,101,173,104,45,184,64,24,121,25,121,228,146,149,32,255,123,240,214,48,7,200,134,2,237,17,186,27,180,10,250,211,140,101,5,143,87,83,7,108,13,191,112,84,3,61,249,82,190,178,247,120,170,18,116,245,232,179,131,177,120,241,15,13,87,221,151,86,102,125,190,192,144,67,159,60,171,166,73,60,98,197,171,226,73,203,167,6,138,84,204,22,219,121,3,195,30,19,111,143,119,141,55,46,101,223,248,75,98,48,121,198,64,97,80,55,52,98,228,86,81,90,142,11,177,233,120,209,245,228,43,84,108,37,72,107,53,100,160,151,231,35,177,196,216,246,61,243,122,201,205,91,40,132,168,12,54,111,120,233,249,107,236,197,80,228,165,6,17,148,68,243,226,253,81,226,171,40,1,54,3,97,247,118,162,75,69,210,212,94,60,83,244,211,197,13,22,170,125,185,137,150,186,53,148,36,232,9,169,189,28,82,58,16,25,126,128,228,99,63,126,188,156,189,21,32,177,141,170,116,67,139,228,191,181,5,209,242,162,67,126,115,225,47,34,140,72,180,131,89,96,227,164,200,47,123,21,248,54,231,239,159,177,217,216,69,212,14,67,134,3,90,15,116,94,60,133,109,59,127,226,235,57,41,4,162,219,198,53,21,151,165,117,31,152,25,162,162,214,3,245,228,38,248,93,58,75,187,227,227,189,155,180,178,228,67,209,189,72,6,104,110,108,104,67,145,50,28,235,61,244,179,223,234,163,102,92,45,44,23,13,230,244,156,198,30,123,1,129,155,93,35,99,83,11,116,97,120,119,70,211,30,237,255,85,78,17,36,28,135,115,230,208,207,244,131,85,47,188,246,172,145,134,225,223,234,240,216,61,252,211,52,50,116,175,81,50,12,172,154,221,58,246,134,154,54,109,80,24,186,244,134,105,173,49,64,77,62,75,180,49,62,150,146,103,97,219,104,199,110,101,23,195,101,89,153,178,119,157,225,88,94,26,86,99,22,40,49,153,182,131,10,133,94,214,170,99,241,39,229,188,126,69,168,51,118,139,121,8,27,246,225,217,6,203,43,218,171,23,186,27,113,78,176,219,200,91,77,19,54,28,74,227,106,44,62,65,173,70,16,145,175,100,89,252,134,209,44,19,108,161,18,109,126,33,117,206,253,146,250,194,98,239,1,190,32,128,132,96,201,179,215,253,151,85,72,77,45,184,233,72,207,220,172,151,155,204,98,60,134,41,34,253,140,60,166,0,43,163,213,61,115,37,68,177,236,79,93,172,126,134,250,236,89,95,18,194,51,100,150,93,12,189,163,159,223,239,51,229,137,11,230,53,124,58,51,18,38,222,70,37,16,122,209,164,103,6,250,189,53,217,136,81,203,206,78,9,87,30,106,221,172,90,8,130,168,163,92,170,70,203,212,3,49,128,179,69,36,238,116,194,100,67,71,21,248,240,222,106,185,130,204,35,22,141,183,173,152,251,32,226,65,55,22,192,253,83,6,36,19,2,167,105,90,161,164,98,188,67,221,37,49,219,75,134,145,132,81,132,22,3,131,30,236,36,91,202,30,159,158,246,116,55,180,27,206,12,129,78,70,120,131,147,174,146,92,231,5,183,119,51,236,72,30,42,137,24,233,29,24,247,155,143,5,91,103,115,128,17,36,190,208,204,83,200,149,153,173,32,20,11,207,61,110,197,65,175,123,136,229,166,134,216,141,237,113,95,58,72,193,27,232,108,35,145,210,225,206,245,121,239,147,238,75,231,16,203,180,26,115,13,219,74,100,49,159,254,208,166,107,177,39,177,230,7,117,150,221,236,227,210,1,67,32,73,132,109,106,89,65,247,78,34,232,82,183,140,171,100,54,191,70,190,221,137,35,120,126,234,51,105,4,76,118,190,255,73,25,235,130,70,29,57,250,144,118,12,20,160,135,91,37,237,1,45,138,199,27,38,193,196,189,74,115,94,88,96,120,0,33,103,5,247,238,163,116,129,94,223,22,138,229,76,224,96,229,61,137,74,221,218,73,13,23,4,66,184,149,186,237,149,58,180,221,20,1,199,127,127,192,214,20,100,62,158,187,251,8,85,172,250,125,246,208,202,188,20,54,241,212,50,64,46,52,127,50,46,52,177,255,19,254,115,141,29,211,13,238,177,169,222,251,127,80,126,193,118,115,179,28,39,164,201,4,60,99,75,91,213,10,72,181,13,40,188,15,27,217,155,232,110,198,202,45,204,147,17,116,246,139,45,95,64,170,171,8,73,89,145,222,169,66,151,86,136,78,202,34,140,143,196,109,7,225,58,175,239,50,174,44,165,82,229,166,92,185,52,114,211,171,189,243,18,82,110,14,83,157,55,164,203,242,159,158,225,72,212,16,254,208,27,10,160,199,14,238,40,243,202,251,210,165,141,255,215,39,47,233,172,148,120,170,10,87,210,163,250,90,63,18,64,155,248,123,38,99,147,5,228,118,230,130,215,158,206,108,48,56,113,32,253,118,101,157,117,78,170,99,130,30,38,47,6,162,49,201,34,230,235,229,153,131,131,81,48,104,191,0,211,20,112,110,190,21,140,138,255,227,21,230,225,196,31,34,24,19,57,9,51,126,135,183,158,57,154,176,35,31,94,197,255,14,84,2,218,188,40,162,2,178,191,254,79,120,107,251,112,32,240,152,255,114,233,241,212,78,105,39,110,56,196,15,171,245,191,226,237,6,106,74,202,254,91,44,51,163,101,183,80,182,21,198,29,209,60,40,221,17,95,99,116,97,56,174,223,245,243,251,201,38,89,115,144,93,149,29,173,190,211,220,19,198,129,213,25,34,62,181,90,86,115,57,27,63,174,2,27,30,143,147,221,179,1,224,105,193,11,19,0,94,136,55,80,105,176,35,173,31,60,203,173,58,63,91,102,183,79,56,177,224,179,201,233,23,241,227,154,94,14,68,171,200,125,30,249,70,159,115,85,230,244,213,53,227,29,105,217,91,195,56,168,19,203,178,235,204,232,94,89,234,203,48,231,219,112,236,133,232,182,65,240,116,13,234,22,239,90,101,95,231,137,84,173,139,158,80,59,38,128,199,107,35,202,20,156,196,28,151,50,34,170,253,178,125,186,104,129,78,28,96,139,173,45,247,202,20,45,2,62,225,162,80,19,162,4,10,121,193,3,140,191,107,96,176,80,19,108,203,15,183,217,187,17,178,187,111,159,196,153,240,125,17,227,100,13,102,231,212,236,242,252,128,114,234,222,126,196,5,148,252,0,52,31,180,189,204,44,204,222,132,91,246,247,113,144,22,148,234,197,243,123,88,8,202,148,76,199,168,28,235,28,141,228,58,117,225,177,90,205,49,44,137,239,225,50,28,55,239,212,156,122,8,48,109,148,223,109,85,101,105,136,224,241,81,219,142,78,132,180,129,200,8,159,228,37,178,240,166,124,229,26,139,154,14,83,183,171,240,216,11,80,231,201,77,179,61,7,137,107,113,43,35,53,131,97,95,123,16,242,152,28,199,4,182,162,77,150,214,138,10,39,60,135,57,25,16,7,161,234,35,20,88,37,101,236,213,99,212,46,166,159,197,88,121,244,103,71,192,197,169,62,147,23,241,170,240,177,37,108,129,205,106,175,24,115,126,246,12,206,147,231,202,9,47,165,191,48,110,45,67,178,154,206,225,171,212,239,58,117,238,65,89,121,34,8,121,58,98,143,150,64,232,16,62,212,142,99,65,241,223,251,205,47,45,4,213,71,4,102,95,116,46,135,132,56,110,144,237,109,189,223,42,106,186,199,194,179,16,88,123,19,117,162,119,175,115,228,121,109,222,91,252,199,0,181,242,26,214,240,37,213,93,1,185,216,7,63,182,12,85,69,238,104,7,83,228,134,33,158,77,5,21,242,165,152,205,197,41,176,251,250,204,116,54,17,62,19,231,29,116,219,165,176,213,248,38,90,247,174,83,248,106,178,234,202,163,118,10,79,201,32,113,15,16,249,159,28,72,113,166,102,142,91,126,161,39,161,96,50,237,231,121,30,127,181,210,191,39,12,21,47,34,22,20,35,151,19,165,230,183,105,82,102,25,244,98,126,220,124,5,172,188,82,15,124,66,130,101,194,70,216,248,29,192,20,229,177,253,147,20,60,29,230,232,13,162,21,169,142,7,23,134,211,218,197,80,24,228,1,0,255,72,74,108,253,126,164,236,246,246,161,242,105,150,219,72,59,45,28,169,253,230,75,167,160,249,121,233,216,51,63,22,147,154,206,120,184,190,21,161,199,179,125,184,236,228,220,216,195,216,163,30,132,205,81,82,229,141,197,154,19,22,48,17,147,162,74,84,68,156,154,56,105,60,204,69,234,83,90,117,3,193,111,199,149,194,220,244,118,27,184,133,80,169,37,180,132,79,86,104,163,232,86,88,89,51,214,249,167,157,222,26,115,107,129,93,235,104,213,146,128,35,88,10,125,230,231,150,4,33,255,254,61,115,131,19,161,190,251,64,20,147,79,209,127,89,65,158,4,250,254,94,254,11,186,116,140,235,118,147,69,198,201,5,63,14,72,25,227,81,42,250,65,157,47,56,120,253,208,161,209,102,50,98,74,58,2,189,116,227,73,11,223,195,203,33,30,85,133,52,35,157,79,219,231,193,108,75,212,189,137,161,91,79,10,160,7,222,7,39,108,220,177,13,131,4,31,2,63,52,158,192,174,249,90,86,139,21,52,182,241,26,56,83,70,113,218,27,82,68,80,17,252,152,144,243,53,214,233,250,35,238,7,234,140,89,126,176,69,87,141,189,126,179,195,234,181,37,136,223,203,112,87,74,229,166,82,108,13,139,137,162,142,189,201,27,134,39,237,110,7,85,63,235,153,191,95,164,214,134,72,83,233,153,3,79,56,222,144,163,80,155,132,151,88,106,114,129,163,197,101,219,186,2,196,76,35,165,182,16,251,0,153,225,192,41,50,145,160,104,33,28,17,119,158,249,123,170,185,134,8,185,53,143,26,181,11,8,252,41,168,211,214,255,91,97,26,128,40,43,151,57,157,106,187,183,183,85,12,209,102,63,215,85,237,208,185,12,6,128,106,234,66,171,89,231,236,71,82,89,50,2,210,60,120,232,42,123,227,254,254,66,204,161,63,72,98,117,77,241,206,189,64,151,148,28,8,59,162,72,223,118,46,227,210,173,210,11,28,81,226,145,153,135,27,177,39,239,78,147,8,69,125,133,215,153,231,199,131,234,247,237,75,8,220,10,116,11,16,213,232,179,15,70,249,184,112,55,111,253,100,159,92,121,188,121,12,23,134,7,49,187,202,135,108,202,113,116,139,62,8,100,139,22,45,79,196,130,82,116,54,191,163,173,174,228,224,83,93,142,0,104,61,1,223,136,213,60,20,163,91,140,177,241,13,210,100,191,254,222,177,181,233,159,194,57,65,40,80,84,171,59,232,46,250,122,194,27,77,228,12,136,39,101,36,14,155,116,153,81,128,187,91,246,62,219,128,115,127,194,149,18,56,101,37,220,95,156,242,39,74,53,62,116,242,38,147,96,112,215,0,175,244,242,64,30,137,152,219,80,57,69,226,91,190,21,83,10,84,32,7,164,198,59,11,226,177,124,162,235,130,84,162,40,231,75,125,188,79,190,254,167,247,236,9,98,196,44,82,25,64,175,50,116,128,212,144,220,120,83,225,137,147,91,101,73,125,190,99,201,154,212,38,188,137,249,72,116,1,46,193,5,225,107,222,72,173,85,0,106,4,32,122,177,204,134,106,223,11,241,115,194,50,46,30,95,252,19,128,92,234,211,67,175,219,99,205,20,212,142,190,39,161,176,76,124,89,188,99,230,0,180,138,140,149,201,5,97,41,27,102,70,228,9,98,211,174,157,82,185,196,52,197,6,141,53,91,125,48,77,231,175,114,139,159,137,25,106,217,96,101,69,65,102,81,185,1,193,5,199,3,183,15,252,242,29,86,121,238,5,130,135,5,68,214,215,112,134,16,221,166,199,197,32,68,87,125,164,38,147,184,28,22,140,171,69,178,39,209,233,223,146,8,119,214,235,155,124,125,99,53,62,198,95,14,30,203,132,248,5,84,238,40,253,207,88,87,67,243,94,48,143,112,243,175,222,107,207,133,99,247,228,39,47,143,208,86,35,107,102,148,128,88,237,230,199,207,181,103,23,255,34,202,107,211,62,185,122,71,35,110,155,207,80,111,49,181,247,78,176,107,181,40,144,252,27,250,180,42,94,152,61,124,159,121,41,126,87,82,85,153,255,253,235,218,9,251,160,50,16,199,3,62,60,234,202,164,232,119,244,123,42,88,93,24,41,164,66,36,157,210,187,134,175,75,228,49,249,1,199,68,110,140,102,224,241,135,124,160,246,168,154,184,134,82,243,250,70,229,12,67,216,207,59,38,159,202,226,125,164,8,86,161,80,100,132,207,51,240,202,91,22,140,64,122,96,40,95,235,166,6,145,144,200,85,5,31,226,255,3,104,158,21,34,245,137,85,76,50,211,45,183,46,32,161,45,236,234,142,99,230,68,49,206,180,122,245,76,175,165,124,85,193,137,16,58,157,107,9,8,119,120,79,109,223,225,97,28,219,168,246,28,77,238,179,147,235,212,22,11,233,161,214,53,65,183,6,157,1,22,21,76,193,64,182,146,190,255,28,19,172,215,233,154,56,20,225,41,34,100,60,112,10,167,201,200,136,123,177,167,161,55,46,68,63,135,90,228,46,113,101,49,98,205,221,168,114,194,114,243,7,88,192,92,175,35,238,157,191,45,23,232,10,202,138,61,100,228,179,234,158,22,75,177,63,51,207,47,100,254,177,108,161,10,22,186,18,105,111,180,247,251,231,255,164,34,131,119,132,56,186,243,69,170,186,26,227,170,99,166,12,71,86,227,208,157,231,177,224,107,135,7,119,237,79,232,128,103,114,39,239,189,180,29,203,108,218,102,105,41,197,188,114,219,184,94,112,21,83,184,34,241,125,170,171,79,39,135,150,101,28,187,40,24,60,121,142,211,221,154,196,213,117,184,227,160,132,37,85,56,157,56,232,58,26,205,202,74,107,226,121,66,169,160,194,61,40,67,185,90,100,210,150,130,176,164,109,207,48,205,30,120,194,21,3,173,99,96,230,219,85,233,117,29,87,100,39,131,230,230,167,236,13,59,144,170,37,62,209,2,50,64,253,105,24,116,71,38,190,65,10,202,33,27,184,127,117,154,96,166,16,176,50,237,221,90,219,123,152,225,42,130,54,233,25,132,76,114,87,16,177,24,195,194,172,218,59,132,92,7,42,135,208,132,118,86,133,206,246,31,110,116,219,246,123,67,57,162,129,41,73,14,49,122,246,107,209,152,49,193,29,178,35,170,43,237,130,98,177,236,82,40,146,24,93,155,24,81,108,41,197,195,254,133,134,107,63,34,88,187,172,219,12,218,77,247,244,34,236,216,166,69,88,222,177,194,55,105,123,135,123,244,101,182,3,114,54,100,230,16,104,48,66,4,181,17,104,24,175,53,238,133,235,94,189,110,213,204,57,103,112,146,2,179,159,24,16,83,150,202,160,3,157,144,210,145,36,176,13,165,36,114,112,247,239,223,106,202,34,229,251,37,184,60,176,144,161,179,104,54,73,207,165,135,25,203,39,243,110,126,52,201,140,98,224,0,31,78,100,65,226,218,233,218,208,11,63,198,87,125,13,42,179,186,62,225,145,190,3,114,114,83,142,53,38,254,71,135,145,146,38,151,51,182,140,57,60,165,163,125,41,27,106,215,230,35,109,240,64,169,209,29,166,80,151,69,180,35,135,220,207,91,15,223,250,169,132,39,30,78,170,185,244,179,88,125,88,103,41,227,109,88,13,164,20,141,172,30,25,222,174,197,220,179,60,103,75,177,215,99,121,245,92,15,218,196,85,209,64,11,255,230,12,1,159,65,128,147,152,42,169,144,50,171,21,3,131,55,111,51,158,214,189,7,74,248,192,139,101,17,146,76,27,71,43,59,100,105,248,48,227,170,120,118,156,162,75,190,185,232,211,223,137,179,207,82,76,17,140,70,177,14,31,180,241,58,67,240,38,240,144,167,21,236,172,169,219,192,67,155,200,252,8,2,118,75,15,211,191,154,211,230,138,163,124,11,30,132,65,116,132,24,70,34,167,18,185,167,29,180,204,231,217,16,250,159,208,54,48,120,28,220,87,84,71,252,206,83,223,199,60,205,95,96,173,200,131,5,211,53,171,203,245,58,129,228,191,114,239,29,221,60,57,45,98,77,71,216,162,66,129,103,181,173,158,171,12,195,233,189,235,98,16,71,98,133,77,34,236,230,69,246,120,34,198,37,80,166,25,130,223,166,96,22,189,97,154,182,93,215,11,202,11,141,152,142,184,96,90,205,130,156,126,159,119,175,131,53,90,28,18,24,31,219,109,80,40,87,3,66,147,171,37,45,5,239,255,205,34,14,42,156,230,154,211,193,188,64,149,115,43,108,37,156,30,204,83,221,39,131,121,93,151,107,74,216,150,201,42,198,240,163,237,241,93,93,9,192,47,196,155,161,228,228,58,81,177,84,46,141,170,33,28,132,234,72,166,209,29,155,247,76,98,239,234,160,40,57,146,193,201,188,179,108,248,244,49,110,194,206,167,69,43,24,70,186,15,102,158,36,148,108,214,36,115,119,31,60,124,240,62,206,34,248,234,106,22,146,18,58,167,171,63,105,166,93,110,232,170,53,77,13,85,33,236,191,197,12,164,153,184,165,58,15,88,220,200,145,246,136,153,188,180,84,238,80,107,219,85,45,217,198,8,55,118,106,26,146,205,110,175,84,31,192,152,20,78,123,119,222,74,107,81,249,61,171,38,1,54,222,102,92,166,209,8,148,160,151,59,7,30,89,157,118,17,209,233,104,255,200,138,100,244,73,176,200,16,158,36,36,206,200,42,138,131,84,23,140,164,118,211,189,72,229,195,58,80,37,117,172,242,188,146,175,2,132,112,74,88,12,136,195,19,156,194,50,128,165,138,29,214,6,204,222,63,80,244,155,170,98,25,141,167,87,38,117,156,209,252,153,194,25,73,238,68,62,49,70,159,10,234,131,47,143,84,200,19,219,167,71,93,145,224,47,57,78,113,186,211,63,152,225,34,111,25,221,113,98,249,121,32,212,40,85,16,0,92,237,242,157,144,196,52,52,248,16,212,50,9,114,160,118,153,228,81,152,28,202,231,230,127,15,191,202,219,98,250,38,30,164,45,146,169,246,6,180,175,106,163,48,31,229,51,50,43,82,50,246,118,225,233,210,117,166,49,63,163,149,6,152,13,2,184,206,90,71,181,29,113,223,65,67,65,193,218,220,45,125,56,178,95,163,88,111,59,177,27,14,220,110,144,128,252,10,3,86,115,99,67,121,254,135,162,97,159,133,26,219,247,85,60,147,96,195,21,166,215,68,249,248,196,82,179,87,246,247,214,242,157,61,76,222,2,141,235,245,55,56,164,160,215,179,222,159,162,25,98,1,14,210,98,43,79,98,218,175,73,89,234,212,226,132,150,248,233,62,74,248,82,46,6,37,205,21,42,120,111,88,252,75,176,165,134,156,87,47,50,229,174,94,215,129,200,149,118,187,114,59,71,85,150,53,143,211,252,175,237,227,135,54,76,15,178,105,245,31,142,128,189,36,254,45,22,55,232,249,109,80,204,242,81,206,188,130,206,163,22,77,254,132,247,4,161,245,19,88,17,120,177,120,63,3,118,10,170,61,97,138,14,139,91,48,212,248,6,56,233,241,191,204,81,156,174,145,134,130,212,214,63,166,52,75,103,81,220,59,9,205,109,148,126,177,73,255,190,8,230,30,53,242,142,215,120,111,78,118,68,169,136,47,96,92,166,248,236,135,13,98,105,45,86,73,38,1,137,205,22,162,110,21,80,63,78,147,236,81,254,106,168,82,106,138,30,6,115,206,10,127,162,120,170,235,45,176,76,122,89,93,111,175,195,16,255,26,183,57,37,50,154,120,126,218,165,219,96,238,96,106,133,122,217,206,62,56,208,218,230,147,52,191,107,213,62,230,170,242,220,37,79,234,199,230,11,107,78,191,24,24,253,24,19,229,86,142,197,231,36,190,9,134,56,0,231,221,206,88,193,102,175,243,122,11,163,234,176,38,226,62,150,72,110,36,243,129,29,167,175,164,245,255,55,16,204,57,35,237,172,184,178,232,205,119,33,56,91,77,113,18,109,154,147,218,169,170,252,89,52,97,68,172,222,11,98,159,161,48,56,162,66,7,206,232,229,218,22,233,130,167,166,191,41,46,85,227,61,35,111,197,108,251,215,26,113,100,210,122,13,60,239,208,165,59,21,47,158,131,243,194,49,151,151,103,65,75,85,171,144,184,5,12,139,91,235,0,72,86,173,31,43,28,215,0,213,107,25,228,221,241,181,196,33,60,120,4,25,131,148,66,136,201,220,45,144,73,135,163,77,185,20,91,188,97,83,248,224,89,24,212,219,172,192,31,164,234,250,14,104,22,1,100,95,79,145,131,45,239,92,241,201,247,79,29,24,107,20,152,114,137,221,27,241,123,75,10,159,77,103,202,21,40,184,189,219,42,41,20,140,148,36,122,91,64,234,43,111,99,150,253,97,35,25,241,166,31,92,89,215,161,65,208,221,37,34,54,97,245,38,0,16,46,149,88,227,127,223,2,233,166,230,34,28,160,213,199,220,95,81,100,137,69,182,163,170,153,211,228,229,134,37,63,83,63,236,151,124,228,153,96,130,147,95,139,14,197,69,211,161,137,129,177,253,3,134,37,118,3,40,2,133,74,199,90,165,94,95,247,1,127,23,0,242,137,1,9,248,48,24,77,121,42,125,1,137,25,212,112,171,162,90,141,6,136,64,217,122,170,160,30,112,16,188,89,199,45,243,61,92,113,103,179,104,219,240,184,84,168,160,77,159,13,200,79,209,59,204,237,160,150,190,40,135,178,204,95,93,151,98,136,117,227,186,249,253,43,76,30,193,230,195,13,55,106,39,242,188,139,88,199,223,197,97,161,19,16,38,53,88,75,236,229,83,111,148,13,186,219,30,28,11,21,130,208,212,79,12,246,143,143,166,138,216,222,104,189,180,187,127,61,96,130,159,57,46,56,223,101,51,1,228,131,255,67,181,165,144,131,210,146,106,213,143,49,46,186,83,15,23,34,103,80,73,78,94,103,179,152,212,25,24,47,248,68,127,253,122,191,16,134,14,37,252,97,68,11,136,55,178,159,62,196,61,227,247,60,4,96,58,141,254,206,163,193,34,204,92,202,144,45,149,207,188,211,204,58,113,209,118,15,199,59,27,106,82,188,228,145,74,221,82,165,223,154,0,22,115,163,170,205,253,104,46,131,96,246,43,112,200,90,150,90,234,49,47,158,133,250,3,171,162,225,145,80,148,113,24,190,76,34,180,44,142,149,214,161,52,242,165,167,17,74,182,1,122,84,38,254,136,200,58,150,17,91,140,68,45,79,108,172,237,3,175,45,23,83,36,226,234,81,201,139,145,143,208,45,127,152,50,78,107,100,203,205,107,110,185,32,146,222,144,219,140,199,229,245,178,21,128,19,95,65,43,92,73,87,112,134,101,72,192,150,218,140,161,139,187,37,131,120,42,72,245,16,204,241,97,205,106,117,100,248,251,63,15,154,62,32,176,155,229,232,228,169,130,236,109,230,88,32,104,44,167,61,92,0,171,154,21,232,128,112,183,121,84,76,181,19,25,8,110,200,188,1,26,31,194,37,230,38,72,6,212,179,175,240,252,50,25,133,86,235,217,80,152,91,252,113,223,213,49,205,169,114,17,75,13,194,66,52,125,234,30,139,132,23,137,128,24,228,243,33,233,176,129,185,236,98,40,209,188,232,24,38,27,176,38,5,79,79,223,5,231,250,163,54,219,122,103,117,6,155,24,248,3,235,210,207,102,91,102,9,0,26,31,175,89,205,175,179,101,87,153,140,147,167,198,159,29,89,12,56,32,8,107,36,181,26,103,140,196,172,5,93,20,229,144,65,203,173,213,177,145,57,120,60,190,246,61,232,243,100,156,111,25,19,63,8,61,24,48,98,237,81,90,38,213,225,56,215,252,109,166,132,123,224,31,15,187,167,32,42,62,139,160,246,114,43,222,147,252,200,147,43,213,170,145,233,158,120,231,188,247,114,32,27,161,157,200,113,60,226,175,206,35,56,236,236,191,23,33,64,30,162,240,252,242,36,158,184,140,119,11,176,210,215,242,105,170,136,188,145,78,238,4,219,96,19,51,252,211,143,136,65,246,151,227,179,248,214,149,83,80,233,100,84,81,8,211,155,236,187,72,45,214,96,47,12,87,75,221,125,191,235,183,227,185,57,174,203,161,69,136,1,28,153,140,144,236,62,103,8,129,34,91,13,219,132,184,182,98,217,205,14,116,132,36,244,21,235,10,208,150,22,74,47,65,191,119,124,28,50,210,142,85,49,101,93,177,165,80,48,169,108,232,189,79,6,179,117,14,202,210,162,133,245,9,112,144,190,96,253,21,221,249,94,56,237,129,114,197,117,232,39,255,242,26,128,81,164,97,203,241,24,153,28,161,161,171,111,34,143,83,68,111,116,13,80,214,224,186,67,202,148,176,20,176,224,49,133,67,243,10,30,56,73,30,197,211,155,22,124,232,43,93,178,147,85,175,77,75,18,45,67,101,160,232,140,54,220,154,118,199,105,9,249,186,160,130,240,92,125,55,87,229,73,96,128,54,208,100,137,20,229,7,129,189,29,194,250,104,50,172,76,57,210,177,17,129,26,99,89,240,114,53,193,32,183,137,200,184,10,153,139,12,100,38,248,69,83,252,68,215,217,24,146,135,212,34,70,14,198,131,171,39,180,252,252,61,182,103,52,51,8,1,101,191,129,51,248,241,65,225,164,25,133,240,65,51,248,234,197,208,42,244,76,90,190,15,156,45,65,19,242,5,74,213,233,132,173,169,116,49,244,154,75,87,2,123,161,197,231,111,250,35,154,119,8,195,102,19,35,165,201,255,159,17,24,88,185,132,94,9,227,101,234,202,58,237,207,204,51,194,75,193,25,15,183,166,242,245,229,102,233,190,152,23,166,98,129,193,15,93,231,172,129,146,78,133,92,96,158,114,199,84,249,169,187,208,72,231,87,204,78,197,227,158,218,241,28,113,131,63,220,158,104,31,254,163,216,84,46,236,205,39,32,2,66,15,243,24,168,4,212,199,240,29,246,139,223,83,41,234,175,52,30,81,90,123,73,3,123,244,177,175,116,228,4,155,229,58,241,1,14,0,77,244,5,217,118,180,199,136,246,168,136,187,128,190,88,228,251,111,103,106,55,198,178,112,66,121,158,252,67,157,138,43,66,246,39,179,52,99,17,11,39,131,249,152,145,67,217,178,170,110,87,30,138,28,239,204,88,165,184,57,113,245,253,82,210,223,237,243,199,251,169,38,147,100,50,206,49,97,23,144,131,186,183,171,92,202,88,48,90,153,248,202,243,116,137,186,237,123,6,102,201,202,9,143,88,118,215,226,68,161,97,29,54,15,53,220,180,65,107,218,87,215,217,107,37,224,177,230,91,123,123,196,124,185,112,140,35,103,127,28,85,114,155,120,226,141,156,136,61,223,106,19,60,175,246,151,192,214,193,41,7,78,205,198,181,34,35,97,211,187,50,90,73,181,53,159,10,231,0,191,139,226,146,111,206,226,121,211,190,33,10,119,217,88,37,220,97,139,85,230,17,48,97,182,72,247,34,69,242,251,128,70,240,252,186,209,52,74,122,132,134,32,140,99,13,169,74,218,126,86,57,107,188,71,122,101,222,0,177,0,197,11,19,33,43,67,7,9,7,69,18,133,114,221,81,240,124,40,83,228,228,15,142,77,243,205,132,198,232,173,220,55,223,111,251,158,86,25,158,145,93,137,74,74,95,174,43,183,168,89,69,156,197,54,19,33,213,155,123,124,186,212,124,253,93,63,35,204,108,90,118,104,150,165,211,131,138,84,178,107,76,120,216,18,88,246,76,20,200,79,154,237,125,105,132,236,185,137,149,119,140,198,211,91,170,87,84,166,89,43,120,150,8,200,233,162,89,179,89,49,203,110,9,118,28,75,175,44,81,37,132,154,186,248,72,118,18,225,18,130,4,146,10,121,173,50,189,85,178,108,237,234,202,82,11,100,167,25,56,188,253,254,99,191,125,84,182,54,170,43,42,198,244,201,11,243,69,170,237,76,116,166,213,23,86,50,31,170,152,192,169,237,8,119,69,1,101,70,28,209,212,170,224,152,146,183,191,14,11,156,120,169,157,121,220,201,7,19,135,68,14,228,179,249,199,213,107,140,10,84,96,99,162,128,185,204,193,116,169,17,58,0,53,136,144,217,65,174,183,85,203,246,74,214,110,30,121,21,97,201,23,144,134,64,124,242,133,64,239,44,99,175,88,93,31,147,118,1,221,55,87,172,38,126,239,233,171,111,237,36,66,213,128,76,84,125,209,86,195,64,4,239,244,100,91,232,202,60,251,202,112,201,52,40,5,94,176,48,219,209,198,104,65,209,101,47,80,68,9,236,128,34,225,168,193,169,51,123,140,88,32,17,65,58,196,194,136,211,153,5,236,226,88,233,96,162,125,216,3,42,152,126,39,39,180,50,204,104,100,60,229,48,70,83,85,106,63,110,130,107,252,159,116,158,170,96,94,246,178,197,109,230,79,230,235,29,98,53,103,99,208,90,209,157,154,234,106,191,254,43,141,242,116,124,86,11,29,95,253,53,218,127,241,164,237,139,104,230,174,188,230,0,54,42,26,102,153,236,108,197,238,45,38,235,222,54,69,168,14,65,81,112,136,73,32,39,77,157,28,162,67,182,92,15,29,22,182,215,35,13,243,239,142,37,31,114,226,169,119,82,133,154,41,245,149,82,172,53,35,229,99,75,42,156,59,164,55,127,51,58,201,67,119,130,250,240,199,131,200,255,239,214,228,124,254,74,77,187,136,88,83,169,172,59,46,61,115,208,231,149,31,36,121,81,52,51,39,51,231,208,16,208,254,145,178,93,71,174,41,67,81,249,49,121,177,4,79,40,234,100,129,238,92,74,176,244,134,48,20,179,128,153,126,97,22,129,186,120,237,210,43,196,149,185,109,36,122,119,198,144,39,112,222,221,74,210,226,238,23,162,169,169,234,64,5,124,114,16,139,70,177,61,56,234,64,163,6,184,193,176,108,101,251,129,8,253,118,210,59,8,62,84,252,128,38,101,101,166,221,55,47,162,173,121,212,254,26,140,224,91,13,228,164,175,242,136,210,157,123,175,80,14,103,87,112,114,210,175,20,69,99,146,112,38,47,174,218,188,228,89,68,252,106,10,213,57,105,205,240,53,196,231,126,223,25,85,125,112,168,170,172,49,254,238,12,48,22,253,206,224,101,181,56,151,185,48,141,80,26,11,231,234,10,56,39,18,181,152,133,211,245,217,106,165,241,36,154,85,28,174,90,63,238,174,1,202,56,77,113,159,3,135,163,193,92,170,70,229,71,164,247,72,76,20,213,39,247,247,8,108,73,251,67,59,166,106,153,186,97,77,230,244,196,34,153,83,209,136,39,21,162,131,25,44,107,220,65,66,212,100,239,211,191,237,247,247,212,231,88,44,27,42,186,33,71,197,25,55,169,45,79,196,16,76,217,169,188,79,218,194,71,140,65,229,59,23,49,164,190,221,19,42,173,10,119,97,122,200,236,89,22,168,170,54,112,90,55,138,77,10,250,48,202,32,73,40,206,113,225,178,183,89,148,208,17,145,122,94,235,200,6,37,106,30,60,122,39,122,255,182,173,166,222,13,201,176,133,200,132,106,173,252,132,11,251,105,141,140,105,79,54,73,168,134,32,88,135,1,73,204,125,151,224,36,246,105,223,229,132,215,45,132,140,237,203,187,184,119,126,60,19,155,182,112,207,108,36,37,82,15,73,169,82,193,218,1,35,163,199,86,152,125,152,41,183,102,54,48,36,211,235,237,207,5,210,138,97,117,193,135,126,56,230,199,150,171,74,108,37,38,34,43,76,207,242,36,209,121,248,176,170,3,49,5,61,72,53,132,220,182,183,164,5,227,85,178,161,239,215,32,181,132,124,196,56,203,140,178,135,245,176,248,128,53,176,192,30,34,221,255,235,188,246,112,232,117,202,25,33,121,67,29,18,103,102,151,101,52,162,119,207,254,17,68,58,46,107,221,120,120,208,222,144,45,183,192,19,249,76,14,37,224,232,18,137,102,151,86,248,4,32,99,215,186,44,239,31,47,106,30,56,198,221,43,160,3,53,172,253,58,203,171,175,228,43,116,2,83,246,32,211,208,43,251,207,116,67,83,53,17,197,221,49,158,164,3,172,37,244,73,224,18,242,169,109,26,149,43,245,129,63,55,189,164,71,6,195,51,250,251,171,89,167,238,31,52,174,99,131,133,111,111,127,163,17,220,107,127,110,240,229,65,233,110,38,131,211,126,126,255,95,33,137,114,81,200,208,81,141,159,21,59,237,209,185,41,77,86,246,207,113,248,51,36,135,93,249,36,151,76,248,117,227,161,227,118,207,21,26,136,34,65,75,152,51,44,252,224,66,177,156,66,26,213,203,27,126,227,148,43,214,142,167,125,158,64,84,20,32,122,124,153,195,148,249,110,212,91,139,1,151,249,190,201,112,2,70,6,198,216,152,186,26,1,252,196,2,4,200,25,242,43,80,97,50,106,185,3,201,213,141,57,107,34,45,25,197,125,46,214,54,173,73,73,133,158,3,42,96,134,17,142,104,110,230,143,249,150,24,114,62,251,125,109,140,3,101,37,189,165,44,154,71,160,252,13,167,80,199,26,177,25,161,184,31,42,166,152,235,31,6,0,47,175,31,177,33,123,71,48,253,213,146,119,176,203,248,179,90,90,212,171,4,245,222,120,173,247,6,156,142,29,43,150,166,15,169,242,190,247,219,54,28,206,115,181,135,111,230,254,167,155,171,87,246,174,184,49,90,61,217,96,254,231,52,173,162,118,44,244,182,206,96,252,23,17,157,96,18,33,153,213,148,37,120,175,133,217,38,132,97,109,135,12,56,254,217,77,185,230,15,201,57,69,70,61,163,33,9,2,231,166,45,158,127,153,140,170,236,118,234,216,254,107,61,184,179,203,200,186,103,214,213,118,21,209,90,67,86,42,70,230,65,134,123,254,210,62,137,16,115,44,223,62,132,130,79,99,192,112,106,178,173,10,142,172,177,233,118,62,7,170,117,11,126,114,69,42,49,85,46,217,166,26,59,201,54,142,147,123,110,180,183,27,128,71,169,212,27,79,7,139,168,153,211,35,248,207,201,212,20,81,152,167,182,33,5,192,121,56,129,121,23,28,223,120,214,33,52,29,0,210,27,78,39,48,200,217,111,66,250,49,176,69,18,95,72,195,58,200,217,180,168,85,132,106,2,94,77,11,122,202,102,237,74,204,61,148,227,123,62,66,202,22,107,9,186,142,173,114,7,96,6,34,221,62,26,49,128,47,128,86,87,142,11,179,2,68,98,175,235,70,167,17,188,219,199,153,41,202,120,198,50,17,169,205,225,56,252,88,180,132,71,26,230,165,49,55,185,46,182,84,66,211,146,24,13,161,87,233,182,79,140,231,243,94,220,27,24,106,40,188,6,238,39,49,180,172,53,47,154,188,187,89,32,103,60,134,73,147,42,112,197,82,212,82,238,12,228,12,114,252,149,194,66,7,64,70,127,85,89,109,25,129,135,118,172,132,58,231,179,183,166,171,171,250,53,71,221,7,87,209,220,166,9,105,108,98,152,127,44,7,149,32,104,168,215,129,190,77,213,130,158,250,198,109,4,234,14,68,213,28,31,159,25,151,7,181,60,227,206,45,243,72,31,235,191,14,1,11,176,193,66,90,152,231,242,117,214,31,225,186,9,232,133,83,5,56,215,127,212,76,194,245,152,139,51,40,92,68,99,252,29,35,39,133,211,55,27,211,209,91,80,114,30,114,171,164,177,139,217,3,235,143,108,76,42,21,159,250,4,214,247,50,21,221,108,188,3,88,138,174,188,67,99,19,193,216,108,196,7,229,250,143,123,191,210,70,108,11,245,108,196,86,159,36,164,155,66,73,16,192,12,252,48,146,129,215,36,173,240,137,228,183,44,53,205,211,75,147,14,167,137,174,139,86,170,119,66,17,216,111,88,43,16,13,178,72,11,30,17,6,251,107,8,38,139,236,170,164,201,163,189,187,18,49,145,245,76,141,216,172,160,170,127,107,108,86,31,94,98,17,12,170,17,113,14,250,176,45,156,238,209,85,229,102,8,190,245,106,108,230,78,125,154,115,55,241,42,187,179,216,12,213,137,95,136,17,165,26,121,71,8,159,9,214,227,96,236,223,1,97,182,66,98,151,248,60,128,123,122,201,217,185,237,124,101,189,134,99,70,17,99,88,91,213,3,124,15,183,57,143,35,188,182,132,180,107,161,210,151,19,14,129,64,225,80,60,136,249,53,104,55,90,204,125,226,90,193,180,153,93,182,253,155,156,33,252,4,31,252,216,110,85,131,157,125,173,42,93,206,224,187,34,127,51,73,229,21,186,167,68,132,179,166,145,0,16,247,216,202,162,5,8,249,162,123,208,95,116,123,224,37,137,175,119,13,194,237,39,254,127,52,103,196,233,38,179,150,157,73,169,181,137,47,93,55,157,44,223,42,206,111,215,193,206,198,189,181,59,111,188,40,50,235,38,219,161,54,13,240,62,12,165,142,238,150,241,247,169,214,138,29,125,48,93,55,79,70,79,116,150,129,45,153,142,136,4,36,249,37,169,39,235,165,232,229,170,206,207,101,46,12,198,127,241,71,55,43,11,159,183,74,60,39,240,86,120,113,9,42,46,129,27,252,143,237,10,83,167,29,37,121,211,37,150,15,135,197,2,18,175,134,9,208,170,89,214,246,151,152,145,91,227,51,65,39,245,13,134,23,43,21,251,219,216,215,158,205,67,174,157,61,142,89,252,102,246,165,45,237,146,118,176,19,66,141,163,159,33,136,29,144,218,222,95,129,141,228,251,133,41,149,215,150,22,12,186,112,177,100,103,179,249,154,198,200,78,54,23,230,145,110,5,84,232,168,249,0,189,243,39,134,175,199,70,111,76,109,246,97,70,31,184,221,80,193,28,193,229,41,208,32,180,39,15,45,250,13,87,131,49,213,101,25,40,105,180,24,113,45,154,189,176,230,199,69,233,115,122,199,92,34,241,84,161,249,227,40,168,77,10,21,198,183,65,52,43,36,221,157,138,10,156,136,41,225,76,74,127,70,90,166,130,53,41,38,51,71,167,98,14,211,191,196,57,239,135,254,222,114,72,96,24,5,238,5,121,161,39,95,235,215,110,89,70,109,4,145,166,236,181,82,194,231,215,170,78,3,61,233,110,103,233,89,216,133,103,101,120,122,108,48,221,93,177,189,92,197,182,235,98,178,77,70,95,239,221,166,137,213,133,203,194,186,75,0,122,6,33,20,153,238,151,139,123,119,222,26,244,74,59,221,161,239,38,177,89,11,133,27,90,46,46,157,247,193,101,209,44,206,243,114,141,139,190,157,247,204,206,81,3,101,45,108,114,142,120,206,235,196,22,179,131,74,224,113,114,18,157,147,192,219,225,50,246,69,124,80,11,36,182,192,96,218,230,107,227,58,111,69,142,175,240,212,181,118,226,239,91,242,36,77,183,11,241,163,177,36,60,147,217,180,11,38,10,151,227,184,98,148,152,180,40,251,172,40,145,241,39,109,51,239,212,66,150,136,131,186,231,82,89,218,175,30,247,136,205,245,125,139,125,234,23,63,80,252,215,224,253,55,53,80,70,43,74,122,52,16,77,25,4,67,179,188,72,204,37,101,134,158,164,221,32,30,216,143,225,26,212,248,238,240,137,36,58,59,123,51,102,77,71,235,139,101,33,194,192,100,188,17,223,181,115,170,20,148,43,119,63,82,81,38,8,192,223,131,128,223,45,183,88,101,218,8,116,115,140,90,253,112,150,195,212,143,102,22,71,182,229,245,61,99,221,153,3,84,4,141,122,180,142,10,51,239,45,6,159,81,53,220,150,106,177,150,164,209,46,61,62,30,104,86,145,4,53,251,11,183,222,235,163,72,236,104,116,166,187,246,153,40,7,247,137,78,17,162,85,227,50,240,118,130,21,56,122,6,32,41,87,97,179,45,209,186,83,97,160,53,207,154,82,1,157,254,236,43,159,99,216,152,142,165,6,48,94,88,60,246,23,105,195,183,193,135,201,165,85,164,206,237,11,96,123,255,178,146,6,89,250,215,180,39,197,107,136,160,237,130,232,205,249,128,118,21,39,99,143,222,84,160,224,60,94,224,13,116,132,63,206,214,239,187,204,166,62,169,103,164,253,236,100,63,217,83,40,60,17,248,226,127,167,32,81,114,72,241,32,151,93,78,23,44,198,43,48,99,116,242,177,180,237,207,139,181,43,56,245,114,165,86,223,10,145,164,0,97,96,20,227,127,65,2,149,0,197,137,109,239,19,49,107,140,230,150,29,41,142,211,25,251,47,167,244,76,229,129,214,48,190,123,154,56,87,69,26,32,204,232,208,168,146,113,229,150,9,46,204,11,2,121,97,202,220,68,172,93,136,205,0,194,126,215,198,50,110,64,248,115,208,170,65,175,100,231,205,229,245,32,159,10,250,100,60,42,95,182,45,76,24,128,153,93,246,105,200,179,189,200,90,102,191,129,202,234,76,80,74,145,238,251,39,32,200,199,151,161,43,174,46,134,26,3,149,220,90,213,104,255,176,8,6,58,42,42,169,82,255,81,169,140,65,82,159,195,134,46,211,168,218,251,227,251,1,240,59,15,29,24,133,13,174,101,244,213,159,166,14,160,74,154,73,90,46,118,202,239,255,74,197,101,176,61,22,3,151,100,94,16,56,159,84,103,98,237,44,150,236,114,79,41,215,112,221,228,223,124,13,176,40,14,93,208,108,80,247,236,115,255,24,93,71,86,149,168,157,97,141,118,220,40,77,102,114,22,196,85,12,130,138,86,154,68,10,168,60,62,31,202,141,187,245,46,225,195,131,28,1,199,110,82,191,105,0,80,133,87,85,38,95,229,44,119,100,214,141,65,219,170,173,164,244,14,188,212,237,215,8,202,117,214,208,152,255,122,71,238,198,106,195,51,100,241,174,232,165,32,91,111,209,138,36,185,233,198,113,241,198,32,215,20,146,74,219,174,220,145,118,136,29,161,78,69,86,112,174,66,0,11,71,211,101,48,118,1,50,130,22,109,20,172,146,94,144,73,40,26,70,243,136,118,87,197,21,36,128,213,25,3,62,40,206,72,57,117,113,227,47,5,61,171,65,208,193,21,183,220,47,225,220,15,16,77,62,183,79,2,195,181,39,204,249,165,48,177,244,58,166,107,212,233,185,70,64,232,71,106,114,164,251,147,176,135,23,172,148,228,222,199,255,91,138,220,159,8,209,15,48,163,120,148,64,180,118,178,203,155,7,99,5,188,220,120,208,78,61,62,27,105,86,79,153,226,204,202,185,140,11,69,13,225,150,42,119,28,100,167,199,68,231,102,47,233,144,143,156,107,99,85,129,129,119,210,68,210,56,180,101,91,168,111,21,63,216,85,214,126,94,54,152,189,153,23,199,225,225,165,8,245,33,121,157,46,104,57,68,205,193,168,170,129,202,106,201,39,139,174,102,195,18,246,202,216,20,37,52,121,53,147,59,181,188,156,26,106,168,33,14,12,197,32,73,91,23,67,147,46,22,21,224,140,209,213,125,187,216,202,21,16,220,70,110,220,14,171,11,163,24,234,167,58,91,47,54,174,136,123,137,254,129,248,61,5,253,204,125,194,58,61,132,142,78,127,163,4,123,168,74,13,30,26,217,138,80,86,238,230,124,240,100,24,53,145,159,252,138,78,55,73,211,158,114,58,155,184,110,131,53,57,188,168,108,231,157,150,197,50,73,68,202,189,41,59,183,113,134,233,92,111,201,196,19,52,169,17,141,41,125,208,251,28,100,205,132,201,213,62,242,81,208,37,35,62,76,226,188,216,9,232,0,188,1,56,140,0,151,99,214,115,38,171,27,176,186,60,194,150,72,202,131,94,27,177,179,198,228,70,248,194,149,248,48,21,163,222,110,8,231,126,145,178,162,145,96,166,57,86,170,134,108,78,39,73,100,153,5,150,255,134,16,224,179,105,21,14,42,255,92,61,237,34,146,159,234,167,234,169,243,183,40,9,146,216,134,96,130,227,203,81,84,144,25,157,180,237,171,244,169,53,237,126,19,33,218,47,132,107,151,53,163,207,219,12,102,17,16,255,216,117,171,175,46,54,215,121,162,176,236,55,55,171,56,220,111,253,92,208,70,123,42,61,177,108,192,102,213,50,173,145,134,1,239,17,44,144,17,225,109,191,34,132,91,22,37,177,52,92,178,58,160,72,217,240,167,14,220,255,64,222,232,175,231,196,225,121,207,87,104,97,225,82,27,225,214,255,181,85,106,47,23,170,40,11,68,247,210,75,187,209,176,70,236,113,205,36,205,143,96,227,65,104,166,197,231,100,37,58,248,1,13,53,123,25,103,151,60,68,209,227,174,144,122,19,55,155,31,9,54,216,39,248,115,0,116,251,63,85,152,194,214,135,248,96,102,129,85,55,46,103,205,78,140,47,149,113,103,114,123,223,21,186,18,162,48,175,178,166,203,140,160,162,143,109,236,15,37,239,112,112,210,197,239,65,128,120,226,150,198,48,181,245,114,112,40,235,26,212,204,231,43,197,109,118,79,104,228,231,145,248,231,204,124,170,55,146,93,113,2,23,174,252,77,90,141,131,148,39,83,240,213,242,158,145,87,212,157,25,232,19,81,186,229,158,55,69,100,237,46,95,21,111,82,196,37,111,163,250,182,202,42,241,230,151,153,76,75,109,26,219,130,59,62,29,234,27,209,30,170,162,120,148,133,241,60,156,132,33,116,60,55,133,142,24,29,247,219,230,218,205,101,218,211,37,61,103,95,37,113,90,214,111,156,84,43,27,9,15,187,173,131,254,130,104,150,29,117,147,115,70,160,174,210,157,73,201,218,196,194,227,173,115,116,91,75,94,236,180,22,193,55,69,50,226,14,201,93,101,44,163,182,93,172,128,113,174,208,40,77,45,226,48,116,7,54,207,29,173,45,150,55,24,90,5,1,71,81,175,243,140,117,242,255,199,82,159,185,186,252,114,185,83,213,58,179,229,208,79,29,121,188,255,100,90,7,229,165,105,21,27,98,49,159,69,255,31,142,220,36,2,201,123,110,175,125,186,87,134,195,222,82,103,151,0,186,149,110,129,217,2,41,196,14,38,59,108,75,193,103,139,201,154,217,10,169,201,156,103,223,161,121,143,6,243,40,81,107,210,15,87,220,155,25,151,102,217,148,23,98,214,80,58,160,86,153,166,134,16,189,187,252,162,77,151,106,158,77,225,117,109,62,148,220,209,186,115,31,94,72,20,159,18,99,30,156,44,54,121,7,50,217,223,53,241,164,152,136,66,187,154,173,184,93,93,139,134,195,103,31,195,1,27,55,27,204,229,237,234,253,4,147,237,42,120,36,161,120,35,89,122,174,117,237,84,245,214,167,186,31,54,138,234,219,109,157,36,103,167,134,182,72,124,116,144,160,24,202,14,20,22,196,217,110,220,141,156,33,54,152,58,114,123,12,197,211,27,123,133,224,238,218,60,32,94,11,50,193,41,72,188,19,57,12,107,2,94,248,111,59,73,159,84,177,195,151,200,126,214,162,162,93,10,176,241,163,240,220,193,135,125,252,79,135,45,49,15,69,72,103,177,94,198,222,220,177,202,17,145,132,153,95,227,117,73,90,143,42,25,129,125,46,39,152,32,167,154,228,15,100,145,209,233,126,246,45,254,234,167,247,210,63,157,23,128,252,53,54,208,155,22,243,65,0,162,43,210,80,238,85,146,154,116,161,237,46,18,166,76,245,124,22,65,235,184,236,24,122,142,242,232,253,150,16,163,165,14,86,109,28,215,149,117,87,198,164,165,158,144,82,51,219,155,113,88,191,75,158,167,55,115,54,80,88,56,191,8,156,83,149,159,165,211,88,101,49,237,108,31,166,185,207,136,82,6,181,123,84,58,28,62,154,66,234,169,223,193,142,101,52,93,131,229,241,29,141,77,69,45,190,0,98,28,42,207,179,132,154,253,50,183,27,133,253,210,62,123,198,124,93,32,115,75,81,24,1,215,19,105,156,44,10,237,133,36,19,124,69,109,195,85,116,247,223,189,178,123,112,166,85,15,59,209,107,81,1,200,219,127,96,108,59,126,176,86,34,158,92,32,178,214,116,188,198,128,242,69,231,108,73,210,130,11,86,254,208,27,242,39,10,71,13,84,183,191,148,60,212,206,112,84,126,187,48,158,59,31,229,224,85,53,156,214,116,31,64,139,32,61,251,30,125,214,89,71,136,71,100,231,198,40,42,94,23,134,162,143,79,229,181,213,78,58,148,75,141,148,91,205,8,88,142,32,83,99,178,193,165,127,81,232,206,52,70,79,209,134,94,128,117,91,48,167,98,155,213,19,119,235,79,77,59,199,69,183,3,152,154,240,123,189,159,43,26,184,74,56,178,238,230,152,44,32,109,213,251,214,49,83,117,223,60,13,244,163,212,184,100,153,184,172,251,239,122,219,219,66,87,182,2,111,167,105,198,202,237,52,249,145,238,45,153,8,103,170,230,85,9,28,66,136,24,124,101,141,147,125,162,177,231,153,155,231,49,246,24,210,21,24,80,28,182,202,109,122,236,222,96,128,220,62,164,232,62,62,212,205,21,11,76,113,66,125,160,46,100,211,216,249,76,247,243,66,90,215,100,116,207,61,174,134,128,165,232,75,31,218,168,114,202,144,84,211,119,29,251,34,111,232,184,18,132,115,60,170,110,76,46,225,152,147,158,71,233,55,54,53,99,0,84,213,17,200,95,135,177,246,20,35,215,153,43,1,236,107,50,31,85,229,125,211,196,36,0,150,120,69,17,73,114,218,160,39,195,12,88,11,175,63,90,125,132,239,2,89,15,69,193,48,115,184,255,67,254,5,171,193,225,74,29,109,125,185,56,108,3,231,185,82,38,24,76,134,184,200,145,50,152,34,253,174,93,59,8,22,41,236,207,53,17,142,26,193,140,29,120,167,225,246,185,250,126,67,175,49,181,186,9,107,47,130,232,147,223,84,33,181,37,223,20,83,205,196,121,212,163,99,13,24,55,157,45,19,179,49,189,206,227,52,74,9,250,253,106,111,124,52,178,201,25,4,252,72,168,171,127,97,19,160,112,159,204,133,201,59,117,26,123,210,181,113,62,186,47,48,204,104,41,11,254,13,193,107,28,97,253,190,50,235,17,208,185,81,85,64,172,109,150,0,83,89,210,239,184,250,66,139,3,37,238,63,74,230,238,167,245,149,201,224,33,40,159,244,90,238,121,95,159,157,187,186,168,108,189,237,157,34,46,25,146,109,110,127,200,208,84,220,255,238,18,229,76,175,219,8,110,148,245,91,167,42,7,128,21,50,61,20,11,157,77,163,134,158,170,222,61,132,226,43,105,29,207,4,76,55,190,232,200,65,79,147,183,194,145,200,183,166,248,72,1,100,248,75,100,130,126,125,129,49,4,148,209,177,61,127,60,133,144,63,152,35,76,150,183,187,111,22,126,203,239,66,5,36,203,45,200,16,114,16,221,234,87,94,224,131,3,10,104,92,241,192,194,48,229,177,187,47,32,4,250,186,181,112,130,199,166,92,3,250,246,135,49,155,99,254,88,126,89,55,89,229,244,136,119,86,245,118,180,99,16,247,169,225,87,137,202,209,83,125,79,35,221,50,240,74,148,176,252,162,166,104,178,145,240,251,87,190,108,29,18,64,11,222,174,81,60,162,159,238,121,88,210,240,47,119,218,152,189,168,207,151,128,62,96,248,240,46,147,9,103,245,135,196,45,106,144,75,219,24,156,240,68,142,87,108,136,140,74,108,177,237,76,84,60,243,202,174,56,174,216,196,42,122,254,231,91,246,20,18,151,198,196,122,67,65,123,42,8,181,216,27,167,63,210,223,209,48,216,116,204,117,31,105,54,242,8,134,142,178,60,17,215,48,240,96,128,16,38,229,181,78,100,102,20,35,135,135,127,176,158,9,222,174,129,188,21,21,105,4,5,131,114,160,115,231,237,185,242,35,206,220,110,65,108,250,138,189,202,141,183,174,224,22,43,122,66,1,104,19,20,139,50,209,131,154,127,15,77,30,94,217,61,15,236,2,186,21,234,29,141,168,52,227,107,56,49,144,213,66,186,201,35,73,210,209,233,154,3,157,60,140,149,141,164,162,247,101,213,228,211,185,73,35,209,217,213,121,112,229,51,76,72,255,81,99,176,0,9,145,174,97,250,229,49,111,8,18,26,94,55,67,123,209,123,184,31,236,105,168,227,238,241,223,173,16,229,216,13,8,16,128,197,84,188,85,243,203,41,60,232,235,74,91,186,116,9,22,159,188,22,209,226,29,151,213,225,73,234,113,130,239,58,135,145,156,205,68,75,25,18,241,69,209,115,166,166,115,133,135,213,171,180,161,201,17,219,55,33,15,163,133,11,229,132,191,73,113,83,100,190,122,95,248,8,236,73,245,143,2,5,73,154,67,241,52,190,170,250,33,5,110,97,84,121,67,36,254,255,177,67,153,219,96,136,82,163,14,164,192,254,14,8,242,95,81,42,112,42,253,202,211,202,10,243,161,40,0,244,102,168,161,129,188,250,192,132,242,107,48,54,195,109,92,240,51,13,170,9,112,192,6,119,22,247,29,248,148,131,123,31,121,185,123,48,143,221,202,59,61,69,0,187,8,153,66,156,76,249,28,228,10,48,109,69,123,67,97,71,134,16,131,221,32,45,152,162,84,60,36,116,106,253,62,242,61,150,157,84,103,111,70,128,154,108,242,147,202,210,57,80,147,199,91,123,43,125,16,202,8,62,229,199,207,9,159,2,27,181,8,102,20,208,64,9,163,135,249,170,101,148,53,30,105,113,30,129,48,1,113,58,60,163,76,46,95,63,156,185,187,119,169,229,216,217,167,22,222,171,86,11,13,19,106,62,185,195,13,57,181,199,147,156,18,143,167,69,254,186,205,25,138,144,68,205,23,134,91,248,174,47,213,110,200,49,46,223,105,174,55,100,93,221,225,58,116,87,164,117,123,31,181,0,219,198,250,158,224,72,45,155,73,244,106,8,25,182,250,130,180,87,154,250,142,219,91,168,141,19,10,142,196,163,225,228,61,119,185,95,176,8,24,205,234,146,180,46,222,158,152,66,18,52,56,130,29,55,212,149,154,48,190,197,238,43,119,141,40,201,102,135,173,112,61,114,249,171,45,2,61,198,33,57,141,31,213,119,188,196,115,77,223,87,204,177,116,147,160,208,178,224,116,55,207,198,97,58,68,18,208,125,187,158,118,128,59,193,73,63,98,145,138,94,73,88,66,122,170,46,205,204,80,156,217,171,234,180,95,232,247,80,189,86,9,112,97,99,154,207,189,216,5,166,0,223,94,84,51,25,64,25,147,153,252,129,205,249,171,121,69,116,157,15,126,208,224,23,193,108,222,233,130,186,7,207,219,146,145,244,201,35,235,82,249,219,47,136,255,86,46,70,239,38,254,136,20,147,236,142,192,100,136,216,171,25,97,126,107,122,19,34,126,247,210,106,215,225,83,73,33,99,117,93,46,158,157,218,60,61,97,14,184,15,88,231,205,49,213,178,86,47,189,126,127,115,51,88,219,26,224,150,65,60,135,124,192,217,40,130,167,92,12,234,163,133,121,203,202,50,81,164,173,81,162,36,242,148,68,3,235,178,70,129,63,254,222,225,68,203,22,23,234,88,244,84,195,215,15,220,89,195,20,120,236,95,75,20,181,30,39,240,48,3,231,121,71,55,251,221,199,245,83,142,134,93,205,70,131,69,207,206,169,139,82,209,212,63,133,40,241,163,97,20,135,120,70,161,179,118,251,102,153,210,80,115,110,40,104,68,194,215,135,234,227,22,105,218,227,120,148,53,139,174,54,53,212,157,58,83,162,38,159,51,123,29,6,148,133,252,185,158,68,208,171,36,8,137,104,185,33,55,252,187,91,235,252,8,234,82,143,8,66,0,6,38,186,238,17,179,7,101,210,77,211,39,78,68,30,236,163,239,63,234,46,18,111,110,44,123,77,100,189,44,226,56,118,49,254,161,71,64,7,87,158,248,181,116,90,253,135,57,226,75,77,148,3,8,224,165,253,137,27,19,236,56,9,232,52,229,74,85,240,180,77,134,176,180,57,187,13,254,142,50,180,121,106,39,169,225,19,157,130,245,198,102,131,25,208,15,245,120,123,85,184,121,86,171,93,172,102,203,73,43,172,74,61,114,60,106,229,66,72,208,208,228,108,169,154,60,212,143,111,181,1,50,199,141,87,89,48,82,37,136,30,87,86,160,30,246,135,6,4,165,247,22,109,0,65,184,228,120,0,144,63,171,27,239,99,127,111,206,204,219,181,125,144,146,195,89,250,25,141,155,252,170,87,1,83,140,135,16,77,11,234,121,211,152,109,192,250,222,52,77,59,139,205,141,230,96,79,38,237,164,15,106,52,67,170,15,10,184,162,106,107,50,35,43,220,51,194,182,122,149,136,147,232,236,154,232,167,0,184,136,131,55,45,1,246,132,205,50,171,200,190,14,96,211,0,167,81,113,244,182,40,65,117,41,230,65,117,27,216,162,138,149,106,176,166,241,101,13,71,46,164,56,48,147,27,72,233,82,200,106,58,59,149,222,172,242,84,162,168,146,32,202,89,1,142,21,41,32,80,47,207,228,50,159,105,197,227,121,224,114,108,217,245,205,56,157,139,13,247,154,46,19,119,225,166,238,184,231,172,18,50,109,200,101,49,186,202,166,229,36,171,41,230,172,161,228,186,215,33,229,65,94,28,176,228,155,203,223,225,122,141,141,29,23,203,12,164,20,194,22,110,140,64,68,28,42,181,151,149,103,172,165,43,117,220,245,171,184,188,117,207,27,124,66,36,123,97,2,125,52,124,36,13,182,113,91,235,232,196,164,99,125,224,237,235,59,70,84,236,12,144,174,226,138,169,153,114,85,19,111,107,55,141,59,175,23,222,238,158,21,198,233,231,156,149,132,159,199,251,4,14,171,208,6,242,101,120,213,198,253,158,176,191,47,52,11,72,151,97,141,185,137,225,252,16,115,45,205,22,26,189,131,121,153,83,43,165,68,102,120,226,209,112,168,131,197,213,242,66,72,202,42,119,75,227,169,196,100,142,207,201,70,160,196,128,211,158,120,90,242,59,244,21,63,231,123,167,159,203,65,242,87,48,134,4,253,80,140,92,36,228,200,94,81,60,208,58,38,169,45,116,189,157,118,227,222,62,114,152,78,192,188,8,65,191,225,163,0,19,72,205,111,126,215,233,224,101,7,56,35,208,221,73,123,106,157,72,49,78,143,213,211,248,103,133,56,57,53,71,91,17,118,27,223,208,113,243,149,100,219,35,162,49,235,96,29,167,95,168,159,233,134,78,103,16,12,122,209,101,172,75,233,30,136,229,122,20,97,14,145,175,173,15,158,227,116,88,144,199,59,193,107,235,176,239,181,8,53,48,93,191,95,82,201,141,4,221,245,221,131,236,31,36,240,88,237,111,102,156,70,176,108,112,100,110,232,57,162,74,162,246,229,11,201,6,72,206,237,37,23,145,79,138,22,82,125,237,54,162,170,210,137,42,90,120,181,146,10,52,4,219,179,218,221,43,252,195,83,178,201,22,3,8,68,135,83,22,158,148,29,121,247,160,138,139,112,72,198,75,130,68,229,233,41,119,171,94,79,247,70,97,134,114,194,237,31,49,40,37,38,155,71,60,112,164,211,166,144,51,56,70,141,167,81,81,78,194,123,110,64,255,234,19,148,31,87,177,227,243,63,130,157,118,23,46,20,25,161,152,22,32,187,241,254,184,0,190,132,132,177,181,104,167,156,81,235,151,98,97,172,49,189,31,64,58,99,61,226,97,192,149,171,132,50,238,145,236,195,66,98,89,158,250,9,163,145,7,186,7,91,129,165,177,23,6,81,229,105,1,209,255,81,123,61,196,136,121,121,89,65,239,7,85,95,45,29,94,190,174,44,236,35,146,225,9,28,103,177,141,88,93,68,250,142,253,148,168,166,76,188,114,177,178,210,181,210,0,241,65,18,35,164,107,74,192,222,12,157,5,98,43,32,61,86,133,125,70,237,0,159,135,60,120,140,219,169,35,68,101,191,158,203,37,119,201,24,24,126,214,19,117,192,55,135,166,240,84,43,64,13,104,98,50,134,208,167,185,34,84,190,5,32,58,98,26,95,210,112,134,95,97,242,133,216,55,228,217,183,69,74,158,177,81,83,218,195,247,192,110,114,18,217,169,0,171,44,92,19,118,56,77,132,1,163,178,99,179,134,143,201,214,161,62,64,228,55,245,128,131,91,100,189,107,162,144,103,8,233,244,25,60,222,79,140,191,29,127,48,226,157,209,112,75,75,54,207,189,183,94,33,6,46,214,80,158,125,213,192,226,31,211,244,41,22,155,129,193,200,164,249,236,246,113,81,29,69,135,119,113,99,238,161,121,18,49,166,48,132,49,17,60,179,85,182,197,203,206,227,206,46,147,172,50,74,142,209,164,59,132,213,179,162,32,9,10,3,165,89,51,195,235,215,239,125,204,202,188,151,221,96,135,193,97,70,247,2,94,238,198,134,191,196,223,234,18,104,82,171,113,9,82,63,206,15,179,56,34,48,54,151,147,170,69,232,51,163,201,45,48,159,86,77,73,124,7,52,76,217,27,67,217,218,254,68,98,167,177,254,151,246,189,184,222,134,49,49,138,86,20,142,25,235,127,82,5,183,13,206,251,231,82,3,26,25,216,173,51,134,132,109,198,28,212,121,55,66,26,127,69,74,64,81,104,230,40,57,219,232,26,59,233,165,214,138,66,178,7,184,53,205,125,249,211,215,143,93,200,85,39,65,197,6,145,44,75,132,29,44,77,107,10,142,253,235,244,165,248,46,151,102,34,229,40,24,5,73,183,177,157,58,184,89,29,148,200,84,185,75,27,42,242,19,111,19,15,237,255,237,99,185,249,255,69,209,93,126,96,72,206,170,39,85,125,1,195,246,88,124,99,174,17,72,83,144,130,76,60,23,75,131,56,49,6,46,219,181,215,32,128,115,4,226,56,92,165,250,106,201,245,81,47,186,103,201,224,205,165,128,242,158,111,145,5,101,32,240,142,121,246,187,100,222,251,46,87,132,181,197,138,23,76,88,22,16,1,224,115,168,74,15,174,195,188,140,252,57,218,180,69,191,117,71,141,235,153,32,39,23,91,165,34,118,20,214,251,109,223,174,208,38,167,179,156,27,8,207,86,34,61,250,6,142,131,66,133,79,189,206,93,120,41,184,67,152,179,87,172,13,23,112,174,197,1,202,92,53,215,167,94,105,146,7,23,79,6,168,148,88,146,229,227,7,254,85,0,153,232,72,7,154,35,226,137,35,254,173,211,89,234,191,221,88,76,48,92,80,139,45,84,211,51,104,75,179,35,138,128,99,82,219,32,195,196,214,5,113,219,140,184,183,226,56,246,241,82,137,83,75,28,126,133,63,141,224,216,150,239,237,77,127,251,25,100,253,206,113,27,0,191,24,216,20,56,83,5,250,74,183,2,209,3,173,161,245,97,201,146,188,10,14,209,208,199,176,125,124,1,249,129,156,169,159,13,105,86,133,26,245,174,6,124,176,45,148,249,27,206,72,114,72,178,245,70,117,74,104,217,52,112,182,176,150,159,209,156,35,205,90,139,55,236,168,98,98,50,84,37,72,113,65,101,235,236,58,72,220,191,227,52,55,251,239,167,11,251,155,9,47,76,58,80,77,83,18,153,63,0,157,143,191,138,56,93,32,1,54,108,6,31,249,45,153,240,133,142,128,37,173,219,57,122,46,253,99,227,29,116,164,213,85,193,10,169,160,182,223,178,170,178,173,94,194,89,218,121,241,214,252,134,241,254,215,70,158,215,111,35,225,98,163,35,238,43,205,116,98,214,35,219,196,73,73,163,166,95,13,179,18,153,245,50,216,230,157,189,222,209,159,193,11,132,27,209,147,169,71,9,88,19,158,55,176,60,131,120,129,221,158,119,32,107,194,151,168,132,55,176,188,253,107,68,30,0,194,3,129,25,23,67,159,119,125,58,23,86,214,222,207,118,189,71,222,203,43,163,19,55,232,150,233,78,95,105,216,146,60,212,130,217,209,223,210,77,69,177,178,63,29,248,95,171,211,192,45,231,122,13,210,35,14,71,43,184,57,250,192,72,137,205,115,32,193,159,186,106,94,41,212,129,199,84,6,111,209,24,83,217,139,109,190,228,40,244,216,120,233,62,196,123,171,60,154,44,113,173,15,114,40,71,199,102,7,27,189,239,244,227,17,17,221,238,152,123,12,163,68,73,109,31,236,229,124,170,146,145,22,216,58,187,180,93,228,124,27,153,149,182,104,155,13,246,202,179,99,73,55,55,211,31,254,69,222,14,130,163,106,188,150,139,190,232,77,163,193,245,70,107,39,135,12,2,189,106,144,228,204,68,89,158,100,49,120,157,244,196,209,188,193,60,148,11,8,196,29,152,27,33,211,68,234,49,11,237,105,129,126,211,131,60,201,32,121,28,164,213,36,129,136,141,239,223,139,244,94,123,71,132,159,71,226,216,133,184,172,110,119,251,138,171,219,32,13,171,162,56,41,20,0,18,204,236,135,113,113,204,118,184,246,73,153,22,131,93,24,165,51,38,204,135,201,47,228,26,45,185,239,220,171,88,90,80,90,97,190,146,0,12,174,181,125,141,108,98,114,88,212,54,200,109,251,32,218,228,92,18,110,138,93,155,47,136,42,158,121,173,145,22,29,148,137,130,182,83,192,228,78,3,11,177,125,245,180,2,214,216,19,5,172,0,241,58,6,83,72,113,21,114,114,144,245,106,215,41,234,171,92,103,233,182,97,168,22,249,44,235,164,83,232,233,185,10,141,208,206,44,71,121,43,231,105,141,68,158,202,22,19,32,38,223,15,189,76,234,229,238,207,13,138,102,230,28,82,4,217,19,29,46,63,170,13,252,126,116,87,231,250,143,224,157,13,109,251,107,102,212,27,70,214,236,234,225,42,45,121,203,189,177,242,168,21,203,84,81,174,96,198,151,234,119,37,8,238,27,144,35,155,254,28,155,119,158,27,171,36,36,15,19,174,9,44,134,217,139,84,98,157,161,66,198,196,183,232,240,16,55,172,26,205,47,27,245,227,151,44,65,119,95,104,91,107,105,51,218,54,172,186,56,180,179,185,122,204,6,68,66,229,125,221,150,178,253,163,142,99,44,111,56,69,83,178,49,211,149,75,236,54,204,37,215,23,148,134,36,54,198,175,186,131,246,123,155,61,195,74,206,171,111,19,177,157,55,212,63,206,227,216,210,237,131,231,173,53,46,103,110,113,225,26,15,94,204,39,254,14,132,91,36,161,84,21,103,47,4,59,201,68,251,173,38,89,119,221,94,66,61,82,203,145,55,198,77,10,184,42,18,218,236,136,141,34,202,123,193,16,237,12,205,98,66,198,49,234,4,211,55,189,161,87,248,95,173,41,58,10,111,170,126,143,110,151,67,144,166,59,211,229,49,238,84,57,30,129,239,16,170,232,190,220,17,100,18,120,250,181,194,54,211,158,138,43,13,214,120,236,17,55,19,37,207,89,96,1,188,188,203,162,160,212,161,183,194,198,115,0,197,185,176,36,45,114,57,91,159,31,15,90,77,138,92,231,162,252,79,165,28,58,28,254,83,235,64,0,167,158,216,151,24,7,176,160,7,144,25,166,240,206,123,98,35,49,153,111,134,238,235,107,101,174,106,30,83,32,33,2,225,104,16,236,28,53,136,15,248,159,53,89,95,127,174,180,235,58,229,137,44,191,116,226,234,91,20,8,244,66,224,186,135,25,145,127,98,39,142,42,67,61,81,76,187,126,192,134,59,88,15,144,230,209,215,45,168,61,52,117,99,20,21,56,234,179,226,167,141,243,139,95,205,224,4,54,16,114,136,145,123,34,11,150,4,156,56,226,81,149,155,18,245,211,161,42,52,162,71,44,191,58,189,131,196,10,45,31,59,164,88,218,234,208,228,204,127,77,56,206,96,181,111,199,243,194,216,74,157,211,175,181,114,174,135,205,86,226,74,69,49,92,68,158,38,48,128,211,216,100,240,242,19,190,97,0,114,124,112,208,118,120,235,82,5,71,42,96,245,202,51,66,60,157,176,79,108,136,78,29,23,41,151,46,90,29,209,169,178,74,147,173,246,185,213,68,137,208,45,114,199,92,83,226,204,116,111,37,0,4,173,16,42,193,15,215,95,207,156,43,129,173,124,103,168,55,115,49,204,78,140,124,20,102,238,224,161,119,158,247,120,162,150,30,92,249,199,38,182,29,82,219,249,48,194,129,212,148,39,56,202,153,78,92,166,92,216,87,213,68,227,79,114,174,104,179,220,22,9,46,16,215,42,22,10,197,109,149,166,83,189,154,206,183,131,34,252,162,215,181,172,89,5,61,59,130,53,130,79,177,78,239,24,26,124,30,180,17,13,107,65,139,250,73,3,124,64,168,142,106,53,96,209,242,148,147,70,122,145,240,192,95,102,238,177,244,112,55,12,169,237,38,213,238,80,148,167,115,18,91,165,64,198,124,150,188,191,203,134,220,26,50,45,3,198,199,192,21,180,94,159,238,36,77,104,149,45,20,66,253,219,123,162,167,113,219,94,117,12,90,223,102,208,76,248,37,209,235,112,107,201,128,186,236,123,56,69,56,55,96,80,254,42,56,234,237,154,107,247,161,252,89,37,191,200,67,141,242,11,211,158,245,33,160,62,63,172,86,147,9,132,14,55,172,24,80,69,52,144,94,169,159,212,135,34,77,64,36,192,103,75,189,231,53,58,119,250,45,187,8,47,8,97,150,83,42,112,202,22,229,63,248,206,231,7,30,238,105,162,73,189,46,155,57,145,244,255,254,93,149,63,149,175,7,119,231,241,74,223,95,162,182,149,4,57,237,166,174,66,97,240,222,113,154,196,51,60,112,190,242,204,158,72,82,64,170,197,52,2,179,44,145,11,237,64,110,182,196,220,102,56,5,191,133,240,218,4,3,239,159,35,44,119,246,192,240,69,11,130,103,61,223,6,71,236,210,13,152,47,77,85,77,4,176,159,200,243,35,157,61,218,144,200,165,147,250,74,179,77,27,22,178,77,110,133,227,136,107,131,106,158,154,63,28,42,96,52,35,30,199,140,128,74,241,228,174,177,212,103,67,182,170,229,2,159,66,218,9,110,30,42,142,231,33,180,180,148,59,253,158,124,194,104,8,241,31,147,13,208,67,171,81,159,185,76,82,36,207,195,199,20,195,144,190,59,145,44,202,74,115,96,40,183,175,0,120,194,13,26,89,156,239,244,56,247,86,80,231,75,177,237,192,144,178,225,9,185,116,69,60,43,89,53,109,11,138,222,32,135,230,111,3,151,48,147,179,106,240,64,164,94,187,167,89,7,114,131,146,230,5,154,159,59,199,123,54,104,195,92,163,90,173,57,244,183,41,204,41,216,92,218,150,105,247,87,129,223,193,172,120,38,56,209,99,204,129,81,229,125,24,86,93,231,154,21,180,138,210,31,99,28,18,99,46,109,10,67,227,24,225,202,98,0,235,147,36,159,190,116,175,189,47,20,16,66,77,9,110,104,122,226,248,185,166,189,229,216,246,164,109,185,3,55,173,82,55,153,12,8,128,202,52,185,126,250,229,141,111,186,126,179,182,175,175,74,147,3,131,239,69,23,122,251,242,74,42,22,104,24,174,15,199,84,156,79,247,91,244,204,177,134,238,190,105,172,76,63,222,24,17,205,132,198,33,222,90,72,11,91,5,117,239,123,218,84,85,151,65,59,102,219,213,21,204,209,19,209,236,151,251,81,134,32,0,124,86,154,121,219,103,68,245,181,104,63,255,160,137,253,249,147,29,22,65,78,127,22,54,231,247,74,17,238,6,104,15,237,141,236,250,30,166,59,144,19,149,182,54,250,244,37,101,246,121,217,215,176,94,149,203,214,193,108,91,236,103,232,229,2,40,166,116,144,33,178,97,21,235,221,233,3,66,18,68,168,113,107,76,156,243,223,18,139,251,126,45,200,108,133,170,106,172,176,224,90,41,160,102,89,68,83,174,118,181,236,154,220,56,126,120,234,33,34,93,67,9,59,189,50,172,63,255,106,188,151,83,238,228,134,141,173,238,26,38,80,32,8,156,162,58,86,181,144,195,179,255,20,222,118,64,51,193,226,90,254,200,207,61,237,246,163,179,26,69,221,118,186,84,65,115,207,176,160,78,198,0,189,65,101,19,238,236,50,165,205,186,63,138,121,39,253,91,123,4,195,145,123,114,115,136,113,137,27,90,137,103,163,113,183,2,89,10,193,132,29,28,5,243,115,198,246,29,198,108,220,250,228,63,50,82,47,44,61,196,42,33,167,212,227,142,115,231,250,123,107,221,1,147,255,130,72,19,147,4,75,139,143,30,245,205,221,61,135,123,190,62,60,52,168,70,28,54,89,126,82,253,174,50,234,56,19,172,94,125,2,248,53,117,223,173,243,61,223,197,210,151,63,72,241,184,127,171,33,138,232,218,31,19,230,139,225,118,98,201,117,200,209,37,85,145,5,0,78,5,240,223,58,88,168,138,63,119,20,200,221,54,40,76,96,227,72,18,20,136,66,33,90,181,202,4,148,131,1,168,240,222,172,189,146,45,107,125,57,244,151,201,85,80,123,217,88,18,30,112,116,242,224,25,180,194,87,147,4,105,122,25,3,160,82,62,168,211,216,199,228,210,226,70,148,8,84,10,184,5,157,182,113,234,163,237,222,132,224,221,223,248,52,160,49,12,41,91,164,64,134,209,82,59,84,158,201,39,77,33,216,162,52,33,148,176,30,70,54,209,51,187,91,31,246,33,110,142,121,195,132,29,44,195,228,66,225,87,243,205,161,72,1,244,192,155,168,170,184,36,135,161,226,50,157,0,10,219,177,35,10,162,23,175,133,151,254,121,169,127,77,1,56,78,68,178,50,63,7,226,152,105,237,130,132,40,188,135,53,17,91,115,141,90,120,247,24,179,242,238,25,207,24,72,228,102,3,19,114,96,157,177,124,89,67,221,241,173,3,195,109,62,149,162,2,135,243,195,49,81,55,145,162,255,153,165,69,177,155,136,95,87,128,50,173,120,207,94,249,187,72,14,10,252,54,116,132,59,115,125,161,78,212,242,9,72,28,178,104,34,122,85,76,236,134,129,209,142,144,162,44,197,11,92,142,98,48,57,253,71,167,186,44,97,136,96,111,206,52,26,234,26,253,166,157,139,84,35,131,11,174,23,204,55,212,133,99,55,144,243,251,70,24,185,57,134,116,138,166,207,21,66,214,65,192,17,96,232,188,255,129,21,32,207,130,7,138,55,171,219,240,113,115,82,95,23,83,171,190,219,176,31,63,86,140,126,41,32,219,51,238,44,215,145,15,180,30,149,88,120,23,72,221,202,161,40,79,191,231,100,84,122,59,255,95,194,38,158,166,251,251,242,187,99,76,207,111,212,25,78,115,31,134,175,145,35,65,174,200,65,3,154,43,235,206,148,99,162,210,186,181,202,203,81,8,229,66,20,186,106,253,230,178,50,157,92,16,0,135,9,199,92,103,115,130,168,36,161,9,175,229,201,186,50,71,243,27,57,6,122,109,74,199,253,202,157,93,205,88,141,64,21,167,167,140,155,50,90,129,120,243,117,244,138,78,226,35,236,24,83,31,76,101,14,244,96,180,214,193,128,59,245,233,152,196,114,45,163,13,82,154,253,85,129,148,75,145,27,165,118,120,109,176,246,19,186,85,90,137,46,202,117,159,196,179,195,43,38,240,217,40,50,75,4,241,169,0,119,169,207,30,144,152,243,238,104,69,58,199,75,123,84,57,175,1,109,230,36,44,239,211,235,159,139,205,241,238,114,110,151,255,82,121,224,251,46,15,1,189,190,36,165,25,14,60,168,12,150,61,194,159,184,171,143,120,0,160,219,155,11,0,252,96,238,204,145,131,132,150,42,255,0,45,26,236,88,162,213,157,180,249,102,63,53,84,104,38,44,114,100,137,107,177,184,193,194,187,250,189,174,61,36,173,14,74,13,202,220,234,216,157,138,136,179,133,14,21,76,228,127,232,115,137,165,153,175,7,11,78,75,96,25,179,119,118,161,99,148,224,195,154,249,234,166,54,13,55,25,92,83,41,240,158,209,39,254,167,43,22,70,115,226,65,200,114,169,118,223,236,9,196,60,247,22,198,21,11,168,22,212,170,91,14,241,58,92,188,10,214,180,113,139,252,166,179,179,3,247,137,56,73,205,62,58,68,62,214,85,226,45,205,209,102,240,78,25,231,189,113,166,39,133,58,185,240,86,159,72,210,214,255,191,23,166,225,254,114,41,13,124,58,108,118,93,94,251,49,237,32,230,69,210,174,147,228,203,254,129,206,78,219,62,177,119,111,234,4,116,160,95,53,37,158,245,172,184,40,28,137,159,23,221,151,90,191,27,65,248,181,7,216,5,93,51,153,15,91,214,99,191,70,132,243,80,157,155,154,237,164,12,64,139,16,201,13,100,43,204,133,202,172,42,165,138,96,223,140,68,149,186,6,210,224,239,150,20,24,142,245,24,22,114,120,180,182,210,41,231,67,217,238,173,30,82,212,160,171,157,12,109,68,16,185,146,122,1,147,135,224,171,160,2,233,7,170,229,3,134,71,195,20,173,86,123,21,8,14,79,55,9,7,220,67,69,151,56,235,64,161,186,50,163,128,140,208,141,214,5,108,193,100,218,132,155,240,136,40,24,38,184,127,39,52,190,249,134,188,120,46,26,239,225,234,117,182,233,175,46,173,148,180,1,95,66,48,229,34,123,1,97,133,176,13,177,222,180,74,54,66,39,86,7,232,3,172,176,25,226,226,124,191,173,206,84,207,185,99,165,96,32,174,205,80,22,167,120,242,59,54,221,144,124,148,211,75,121,107,96,3,60,192,219,210,120,80,207,246,200,17,94,47,121,217,97,218,97,45,141,132,126,144,253,126,163,137,128,220,61,251,26,65,88,14,16,18,32,60,157,143,172,241,150,88,108,123,120,191,234,20,222,144,73,63,214,18,41,223,118,163,206,167,33,1,153,68,87,97,133,223,171,69,45,64,210,224,97,152,2,7,87,205,211,77,38,127,78,31,153,48,129,208,23,18,252,75,188,132,34,83,61,152,248,67,245,221,140,76,174,124,30,23,73,39,189,14,28,80,88,194,224,137,112,15,168,40,193,93,80,230,173,125,230,151,244,131,196,56,52,140,18,239,180,1,30,132,46,183,249,86,71,244,232,209,238,19,99,99,30,76,76,176,43,185,23,83,146,92,37,139,52,180,144,198,231,194,52,212,178,54,227,199,10,48,142,178,194,211,41,8,61,102,116,21,218,118,58,209,88,21,3,86,246,47,255,151,10,212,116,154,234,132,112,89,56,159,149,236,61,184,201,4,26,197,222,99,185,9,216,24,243,3,47,48,117,144,76,59,177,216,68,5,145,23,245,211,31,108,19,156,203,80,16,27,131,222,242,242,215,20,174,153,63,102,159,18,48,96,124,179,105,134,69,90,135,122,196,6,179,0,36,89,78,34,86,84,49,247,58,45,5,224,69,229,188,82,122,218,152,171,169,21,97,197,126,40,36,87,20,135,138,124,167,253,244,126,152,74,132,22,47,5,237,243,222,1,18,168,133,221,83,206,15,156,185,239,238,87,237,130,107,110,66,4,12,71,188,68,57,96,48,218,94,181,49,43,223,52,10,237,231,152,125,254,111,253,39,56,206,46,122,85,41,25,223,137,198,172,202,113,104,195,207,27,79,86,9,222,103,177,109,81,207,206,15,1,140,99,114,223,45,96,144,233,21,116,134,38,18,186,201,123,150,184,163,190,156,13,222,219,154,100,124,225,242,72,255,171,227,186,119,169,118,198,154,60,182,246,33,73,47,117,111,198,190,31,16,129,6,251,107,106,197,26,172,98,147,108,41,233,74,163,165,17,250,54,16,224,193,80,100,76,102,217,85,207,153,62,11,122,161,21,45,176,51,112,247,246,196,147,222,86,100,249,38,153,228,76,13,55,64,5,40,96,81,40,134,248,142,86,243,195,15,100,69,235,62,195,208,129,123,122,130,139,118,157,51,189,25,177,191,216,160,64,242,215,198,156,25,84,148,146,107,141,138,66,64,11,251,78,48,81,52,101,57,72,245,173,58,79,79,251,105,48,80,113,10,147,254,161,200,210,175,215,95,109,200,85,66,122,135,114,83,56,242,245,223,153,149,111,50,14,122,111,41,12,12,176,12,242,211,117,147,127,103,1,141,83,112,18,169,207,72,246,51,160,211,231,16,102,46,222,251,115,202,155,101,132,193,60,123,36,91,76,174,45,246,16,48,68,207,25,209,226,6,164,43,9,147,152,35,13,65,115,12,245,65,64,23,219,152,135,181,61,171,7,173,65,101,80,220,178,53,230,102,247,36,189,93,233,81,34,212,121,48,194,173,109,138,12,87,137,168,148,149,165,42,195,255,38,54,126,23,118,116,55,242,80,95,147,14,208,189,62,38,190,96,14,237,23,156,206,21,250,191,214,92,124,110,135,122,46,78,160,244,139,144,234,178,225,209,203,25,107,216,159,73,81,196,121,234,31,52,4,127,241,3,174,15,34,235,59,216,176,44,217,51,161,151,209,124,170,167,78,125,143,25,25,12,11,86,179,194,63,222,90,39,215,158,115,84,243,218,151,203,57,130,214,25,12,141,67,147,187,173,61,108,39,1,117,90,116,122,232,145,179,215,244,224,3,60,143,55,121,117,2,1,53,181,16,170,40,206,177,138,124,209,48,107,93,228,232,33,32,12,71,83,154,218,41,73,218,207,6,197,244,187,44,139,103,232,230,11,92,90,187,108,94,103,107,214,254,240,237,28,200,83,58,172,83,10,107,90,52,243,23,24,25,95,237,184,178,47,233,59,33,176,9,122,10,20,185,85,164,68,146,195,131,111,148,140,200,251,172,145,201,242,228,244,35,250,43,202,12,76,47,193,78,113,93,236,106,203,187,189,245,241,14,91,69,100,39,76,75,137,238,211,171,31,69,151,125,213,156,82,99,147,91,3,202,47,126,240,172,207,216,177,3,242,241,50,145,38,35,196,43,105,121,93,97,108,245,87,245,207,160,236,91,238,5,253,147,82,252,142,39,165,119,55,120,126,36,139,237,116,28,189,36,213,37,54,40,31,244,123,131,158,254,248,100,188,28,139,38,251,108,245,147,196,241,194,178,137,196,146,70,218,51,183,144,25,209,64,218,232,86,6,108,37,66,60,81,136,174,117,202,56,189,114,247,180,244,201,34,108,133,74,97,240,216,7,210,92,81,142,38,191,89,62,75,101,114,27,236,204,108,249,250,174,226,245,140,23,193,110,46,4,148,188,49,72,118,51,219,28,214,91,184,228,176,175,134,194,108,105,176,102,89,214,16,53,108,168,2,64,225,20,67,24,53,18,213,175,179,60,61,255,255,12,244,53,217,242,140,233,21,110,177,120,252,79,114,223,103,230,114,91,92,225,243,102,252,86,4,132,35,8,44,190,100,132,61,49,14,150,228,62,40,240,216,111,161,161,165,108,7,69,107,168,237,109,219,167,64,13,253,213,132,213,50,16,53,249,144,48,162,115,148,2,217,90,112,119,74,184,116,156,217,130,165,214,157,159,233,128,74,0,136,7,47,200,8,190,209,188,112,124,55,175,116,247,15,26,204,103,156,87,40,106,228,12,122,23,222,227,64,148,111,224,104,157,53,86,156,36,194,67,208,162,154,221,127,191,129,187,229,125,237,160,56,201,94,48,169,237,98,104,129,9,175,170,224,52,50,218,14,84,217,83,158,211,225,26,160,205,194,248,155,154,122,85,137,164,120,130,60,162,203,220,94,218,112,116,124,83,151,74,35,225,128,179,207,172,32,194,233,133,188,117,11,230,155,231,168,70,78,117,19,62,202,9,75,209,104,202,96,177,192,228,59,244,233,219,75,225,227,95,172,242,32,47,241,92,163,147,20,144,115,43,232,178,89,175,3,77,98,247,37,120,99,0,251,60,214,190,226,206,170,125,84,138,232,81,170,29,214,172,196,176,0,28,83,178,96,53,41,218,237,214,6,90,52,230,149,233,38,111,230,210,206,120,166,119,169,137,86,0,199,71,42,235,233,64,12,212,227,249,242,17,119,147,63,60,33,206,125,130,202,20,189,103,122,255,109,75,51,122,247,2,140,141,51,14,132,227,163,27,201,71,240,199,3,154,114,129,228,206,237,189,165,168,123,87,110,230,232,28,146,24,35,188,189,59,58,127,127,175,139,163,68,19,253,87,44,209,197,227,198,150,127,197,253,5,99,236,46,176,54,161,156,176,96,9,206,36,173,130,178,48,127,207,134,69,4,59,51,216,108,34,158,149,52,127,18,56,36,192,123,6,87,251,199,26,220,5,233,172,24,213,236,155,189,89,59,52,107,128,19,138,78,79,200,99,200,175,207,186,248,5,255,205,155,110,147,114,109,88,85,179,31,94,52,39,25,207,144,171,218,153,79,149,236,68,240,31,68,145,14,110,234,193,122,217,124,214,184,88,15,235,159,163,211,176,158,53,64,167,72,75,42,185,24,16,131,116,22,177,201,91,106,222,7,186,140,1,251,145,171,130,73,70,83,235,7,50,207,227,177,167,18,154,182,97,220,79,11,218,244,229,193,144,180,166,69,246,155,115,6,118,190,194,134,19,195,236,177,238,40,30,6,134,6,42,192,241,218,183,164,231,14,95,4,9,114,208,189,75,253,99,145,148,141,41,221,143,94,254,60,108,193,112,137,254,155,223,135,13,34,88,59,189,16,9,68,195,148,136,116,220,53,158,237,84,37,176,109,82,83,124,111,234,48,6,95,141,38,242,189,75,163,209,73,34,116,113,135,13,243,18,45,142,159,128,231,186,156,250,192,126,12,192,78,111,152,104,127,204,144,23,83,141,227,132,116,20,143,190,120,49,109,180,226,94,60,41,209,134,54,94,224,247,18,128,85,28,233,169,234,28,69,169,99,248,26,227,216,188,143,107,251,67,141,220,86,146,80,85,206,172,85,111,233,218,7,41,245,28,35,177,202,117,100,249,155,85,136,136,108,66,242,140,107,48,212,109,91,94,223,92,205,49,170,166,61,156,232,131,28,53,181,237,99,16,13,111,144,61,11,61,201,204,149,21,91,234,100,144,31,86,156,244,214,30,72,55,91,209,72,174,67,164,187,82,215,102,99,25,245,237,235,208,41,186,211,127,90,45,141,88,179,1,116,146,18,9,99,160,226,69,1,100,203,9,239,113,70,51,164,111,17,103,131,197,250,67,197,132,172,94,63,151,107,224,135,229,161,193,182,165,222,100,57,121,167,48,3,54,42,6,162,60,118,106,192,113,169,118,242,217,201,31,153,185,231,170,91,175,181,167,157,45,78,47,150,27,252,5,42,25,70,152,224,137,94,131,154,72,208,203,82,71,191,206,152,60,21,218,23,55,226,5,121,92,149,158,254,229,38,122,25,30,98,89,168,80,198,186,131,19,175,40,23,21,117,79,127,161,33,53,27,223,62,238,230,200,73,95,96,251,242,148,35,150,107,157,107,66,126,198,206,182,158,14,16,181,27,179,119,237,108,59,138,241,255,217,13,10,195,81,153,114,154,19,165,35,168,106,255,251,220,150,10,128,117,205,20,5,65,233,122,220,219,190,203,252,171,71,196,171,51,163,128,195,221,138,163,115,156,216,118,124,214,4,191,233,70,239,106,142,157,85,45,228,26,65,128,14,165,42,168,15,184,180,203,190,19,227,213,199,249,251,119,78,132,162,15,4,225,148,212,193,35,69,183,129,247,47,163,89,65,246,181,105,39,229,62,55,46,229,240,180,64,3,225,246,136,228,187,234,242,120,31,108,83,197,70,185,51,42,16,140,201,205,2,127,7,130,107,123,165,95,210,39,245,247,251,58,116,63,168,95,99,22,97,164,30,88,70,255,104,180,196,34,129,206,112,106,125,229,145,241,187,69,172,131,148,175,186,24,142,173,96,28,158,3,85,121,133,107,177,40,47,130,99,222,14,10,10,6,66,142,7,10,194,25,97,108,125,91,110,145,99,216,174,193,204,97,208,85,227,250,132,0,2,33,200,167,47,133,10,140,88,113,11,195,44,18,201,33,197,34,141,230,206,212,253,114,94,233,107,142,153,26,39,76,11,74,193,182,20,127,20,174,231,61,68,103,230,245,174,203,88,111,158,116,237,123,181,165,189,36,26,186,179,163,3,66,0,69,111,231,205,25,206,104,142,185,233,51,163,23,253,146,22,59,157,69,167,131,35,141,223,31,146,236,115,216,52,78,18,203,98,231,232,126,167,254,5,96,46,79,175,66,73,212,210,233,150,141,78,34,77,171,227,115,78,251,113,112,138,93,105,226,152,193,197,156,37,36,174,136,103,163,96,62,237,229,248,148,88,36,49,69,99,45,224,46,55,2,160,158,36,201,69,68,160,211,214,190,53,184,233,253,123,94,126,224,214,29,36,175,67,155,169,94,150,105,142,141,162,97,114,12,64,253,254,22,39,248,189,60,249,241,90,148,236,85,115,153,18,122,98,126,239,217,149,183,233,223,253,76,142,112,154,23,118,13,141,141,2,75,109,30,15,15,177,59,138,245,231,196,163,64,18,134,118,161,12,157,99,195,146,200,53,114,254,226,246,196,31,97,35,247,101,101,85,11,233,221,183,248,250,44,25,124,16,8,124,143,135,82,139,227,60,173,232,242,58,10,75,123,251,106,149,111,38,176,54,230,188,249,41,210,192,60,202,241,145,7,75,120,112,1,230,112,43,42,202,130,216,69,238,160,160,60,223,68,122,140,32,237,175,176,53,55,164,6,232,251,225,3,100,213,126,19,220,99,8,101,162,109,242,3,35,76,248,176,236,230,61,222,249,49,98,26,124,64,74,147,88,3,213,81,220,40,241,58,33,168,239,188,47,24,30,197,70,93,127,16,74,196,144,241,88,241,145,114,59,87,122,237,136,114,192,245,119,153,63,67,228,193,136,61,183,198,129,16,81,77,39,140,208,192,169,174,142,167,230,97,72,67,208,78,1,218,113,18,31,154,53,166,251,138,226,92,232,19,125,14,94,195,197,245,184,76,232,59,229,56,250,23,87,162,219,131,124,14,123,225,174,43,45,75,54,247,216,144,64,221,207,209,127,147,71,22,219,74,54,215,3,168,233,198,200,139,178,218,87,28,19,105,90,161,247,68,62,239,179,137,205,67,49,131,238,16,127,68,236,215,102,95,35,205,32,243,96,116,156,17,209,85,100,143,166,143,191,131,135,132,70,61,107,25,208,223,217,209,68,224,230,228,34,228,195,64,93,33,184,167,134,134,71,222,145,4,229,36,61,7,167,35,142,229,173,114,173,1,55,5,176,186,76,131,109,225,26,163,216,0,176,224,27,164,115,21,68,245,126,147,28,123,142,102,132,42,229,74,159,250,225,239,72,191,56,218,114,29,56,185,229,4,56,83,246,79,125,212,114,110,232,159,35,106,136,47,156,168,176,52,131,7,27,244,103,235,86,232,127,136,59,121,17,135,247,30,182,230,199,203,128,161,68,192,57,164,137,82,33,86,3,157,231,119,65,60,157,219,243,13,211,170,232,83,111,45,31,219,51,206,89,117,154,67,93,44,116,187,94,136,29,194,61,136,153,240,27,66,49,133,54,124,93,40,55,193,214,75,110,117,63,179,110,252,142,7,236,124,110,211,218,113,175,217,182,205,217,241,217,180,70,39,71,238,78,112,7,152,208,48,61,96,91,226,213,45,43,231,71,158,175,37,78,8,250,31,224,130,29,45,40,214,242,147,162,32,86,181,110,105,13,205,129,176,140,39,36,107,249,69,52,194,163,69,158,44,134,254,181,242,163,255,218,194,122,139,19,64,42,38,78,35,68,234,35,234,2,103,243,115,58,29,71,123,4,165,126,105,80,64,177,71,42,222,36,118,240,79,90,190,112,99,215,33,29,48,234,94,43,176,5,53,172,62,231,160,157,145,56,67,146,156,56,106,100,129,157,179,61,202,93,50,45,59,122,207,221,90,229,212,220,88,93,124,13,14,4,250,92,30,2,185,25,217,147,195,210,152,148,201,82,71,88,59,68,4,104,11,226,200,32,168,228,74,88,202,75,144,72,66,118,1,145,86,85,226,120,229,99,189,57,196,187,185,128,188,124,118,157,27,129,86,142,91,188,141,131,158,253,138,26,75,253,7,111,195,93,214,121,52,40,250,46,100,213,76,208,107,180,28,255,222,33,78,75,65,205,227,17,197,137,112,71,173,54,154,38,150,16,56,241,130,32,71,196,150,166,204,155,14,161,219,96,228,201,40,199,11,253,167,222,102,51,227,183,232,81,98,59,233,105,17,76,55,103,136,209,180,106,190,242,157,220,127,55,110,247,235,140,109,161,71,139,254,111,26,185,40,100,26,59,237,131,47,82,38,84,173,41,32,147,111,222,75,32,33,212,222,107,199,255,45,103,227,138,80,240,244,11,39,188,10,115,251,218,100,184,48,2,95,5,151,89,174,99,116,109,48,189,50,49,192,194,133,44,30,99,104,163,37,217,185,220,252,17,201,160,230,24,48,119,129,198,11,79,110,40,146,42,109,102,186,149,135,230,98,40,132,153,41,132,33,238,55,188,190,238,162,23,52,24,218,246,27,120,6,247,14,183,1,8,248,180,7,57,129,38,252,100,139,6,155,58,46,136,1,155,39,108,93,160,164,193,190,219,93,215,187,107,243,87,192,84,51,21,64,13,113,216,246,220,59,225,250,162,197,219,22,188,157,59,55,5,47,245,163,62,133,65,78,204,199,14,56,204,142,155,200,67,200,90,191,170,205,222,86,55,24,10,7,35,48,173,244,153,43,183,135,195,149,94,232,35,203,77,242,18,71,67,170,80,148,10,33,230,112,208,132,222,247,130,3,79,223,158,233,134,142,109,61,175,84,7,166,180,8,0,85,72,162,185,100,76,202,246,107,213,26,70,150,75,142,90,20,100,42,190,45,212,251,1,100,140,199,234,83,134,150,193,186,233,103,140,184,34,130,184,238,73,232,58,76,84,182,204,7,191,57,148,38,69,116,250,212,238,204,94,35,63,128,31,168,32,114,152,250,219,248,157,192,176,188,89,126,103,6,30,10,169,86,154,179,251,121,212,99,2,226,13,138,87,241,111,144,218,161,148,8,191,81,176,141,251,74,120,136,24,78,195,177,104,77,23,33,189,194,230,70,157,161,228,224,127,126,151,225,159,21,197,19,37,66,228,190,66,50,156,131,170,179,241,196,219,133,63,203,104,63,73,216,87,117,59,130,91,150,219,148,25,221,234,30,74,171,41,203,119,225,109,12,56,236,187,190,219,193,46,170,25,101,121,60,110,68,234,77,81,51,243,137,153,169,160,63,140,181,234,43,23,201,9,203,47,55,202,108,180,36,197,89,57,218,177,188,184,235,87,84,188,100,221,192,127,245,255,249,21,249,209,20,115,92,24,69,221,165,109,7,219,212,180,200,225,11,18,242,151,224,155,116,14,175,238,167,103,195,171,255,148,161,179,84,196,65,101,120,140,65,227,38,54,163,79,204,39,73,40,232,13,20,28,111,247,66,34,18,74,207,206,38,5,163,155,64,191,57,28,48,56,94,34,166,124,169,143,127,141,105,116,117,247,193,193,171,57,253,49,56,136,73,180,71,97,106,106,11,172,142,70,215,138,174,227,55,193,102,151,141,33,91,211,176,216,141,62,106,138,228,68,230,40,202,220,110,229,120,1,2,191,210,223,40,39,109,128,50,110,250,2,1,126,167,77,83,137,168,248,177,246,28,35,46,139,66,182,228,195,106,163,173,229,220,74,19,24,104,214,196,173,24,191,133,158,91,52,100,79,242,6,171,91,252,118,24,90,14,160,22,43,131,246,177,43,85,235,243,234,130,27,74,231,232,162,252,189,13,157,92,240,68,165,93,207,228,174,175,110,73,253,156,24,57,118,213,36,17,182,221,118,201,206,213,195,119,16,99,39,74,143,249,98,108,89,136,145,172,202,248,60,171,140,228,206,232,132,122,232,81,189,107,14,153,181,137,171,237,156,146,177,177,89,2,173,118,228,242,109,242,19,106,225,101,99,194,192,210,249,112,201,174,161,255,66,11,112,60,26,67,17,37,42,102,193,0,160,138,193,66,151,134,95,250,250,52,46,190,219,179,154,33,108,234,167,135,1,166,198,177,211,60,106,131,152,255,49,54,244,72,153,38,24,111,245,17,144,59,63,252,219,5,89,99,117,255,164,240,15,172,204,217,162,106,80,236,68,80,31,158,20,115,179,66,154,34,160,129,217,218,254,169,40,115,146,74,186,138,84,147,76,222,21,44,249,49,148,64,141,11,154,171,119,133,232,16,136,185,211,127,31,37,22,226,48,60,5,47,188,184,140,150,186,37,191,247,52,73,236,118,4,112,240,40,192,101,159,50,211,54,49,24,9,199,231,162,19,199,63,138,140,211,105,110,59,71,151,221,197,171,29,180,151,49,239,157,78,194,194,115,247,166,23,225,73,179,122,2,83,72,225,176,134,47,189,197,19,162,48,13,126,0,210,95,220,233,38,196,212,16,44,105,61,64,4,133,126,157,237,212,224,213,194,161,164,74,24,182,181,112,142,62,56,30,92,21,213,164,40,254,70,209,243,13,136,177,119,80,174,153,20,6,41,153,52,25,112,238,171,99,103,245,112,173,243,147,246,128,245,162,115,114,162,215,151,211,49,125,188,176,237,125,112,184,175,220,193,243,243,140,238,68,53,133,73,128,19,146,48,195,96,27,131,141,232,212,103,28,67,69,203,55,30,191,108,132,217,210,48,84,255,183,201,158,224,44,18,120,188,119,154,199,85,170,140,39,226,49,209,204,193,118,68,89,73,24,46,8,118,35,151,34,233,146,174,77,52,246,97,12,213,47,235,30,76,167,140,189,103,30,38,253,173,89,44,33,133,94,117,204,147,237,104,93,131,162,185,146,252,177,157,158,10,127,248,64,209,43,138,64,250,200,172,198,103,57,26,97,44,248,65,23,213,132,183,56,28,2,90,130,236,121,74,1,233,113,197,50,144,40,252,41,175,3,140,182,56,238,46,81,30,113,111,5,178,83,170,226,165,90,20,150,230,150,37,58,155,54,50,80,133,199,249,163,42,157,188,21,28,95,208,109,178,189,80,96,247,147,171,41,164,219,181,102,117,28,141,178,63,50,44,13,140,79,224,204,213,176,117,83,43,81,70,176,117,199,169,131,217,38,154,205,40,139,65,42,182,123,194,24,113,66,215,150,97,245,202,226,73,139,74,50,9,53,76,133,23,1,218,208,217,40,26,82,235,190,5,194,152,227,125,241,117,92,98,132,255,137,182,87,49,227,78,73,243,74,97,123,97,219,47,170,19,205,78,240,196,240,250,41,73,67,190,137,153,223,146,47,48,90,39,225,35,19,72,51,119,175,110,54,232,220,221,131,211,252,154,34,107,53,210,21,55,132,100,13,106,155,102,22,97,166,83,131,47,96,185,102,243,5,222,14,206,16,25,227,101,247,121,5,54,42,22,82,205,143,35,205,11,164,180,89,48,252,30,92,211,9,150,202,197,59,129,5,163,193,219,148,244,160,52,112,80,20,115,75,24,88,161,56,180,145,100,61,212,54,30,96,101,217,100,147,95,252,106,239,158,2,16,110,73,148,93,95,51,58,167,185,255,73,54,233,141,82,146,221,129,35,126,33,39,187,71,203,108,150,137,137,204,99,199,125,17,46,186,81,114,16,103,254,173,39,95,219,128,178,190,185,78,235,177,215,117,181,33,166,1,51,217,120,53,28,13,124,216,55,70,59,149,211,245,129,78,178,127,184,247,148,109,171,191,215,201,65,143,10,119,30,101,125,208,182,110,122,188,176,202,169,71,32,219,118,59,150,92,185,108,246,26,106,249,241,113,25,133,55,156,144,156,216,206,201,250,191,16,44,4,96,227,84,45,250,90,18,255,5,118,36,86,67,44,84,191,204,216,112,172,127,4,177,6,129,51,198,193,55,155,30,79,21,22,7,191,165,212,252,77,227,255,170,13,240,119,92,144,148,76,55,59,187,46,35,103,74,83,111,234,226,249,238,174,41,242,226,231,65,61,117,3,199,130,188,71,11,7,233,247,9,160,21,58,156,19,15,118,171,93,104,190,208,132,153,38,92,218,0,81,131,140,49,46,49,65,183,242,44,71,29,85,202,16,117,62,236,38,145,19,158,128,111,77,137,152,131,114,14,93,186,178,123,253,57,106,177,3,254,80,1,13,132,113,21,156,112,9,178,130,183,230,79,177,53,5,85,150,198,70,116,60,47,109,51,8,217,22,207,134,110,44,222,201,239,222,29,164,81,235,61,34,239,56,175,37,18,17,160,55,121,152,109,127,171,72,206,91,36,222,115,133,100,208,144,162,11,82,144,211,58,170,81,11,230,247,132,17,76,27,124,210,80,59,237,73,44,28,140,240,157,19,64,225,62,99,40,87,123,192,7,134,119,145,155,191,255,253,150,119,198,119,216,161,171,7,14,169,174,173,201,41,3,239,94,246,239,43,53,196,103,182,206,110,97,166,121,243,175,88,5,176,241,44,1,93,201,169,35,203,171,90,125,90,66,43,228,185,125,202,149,39,17,203,228,99,97,121,99,182,216,56,47,149,232,65,148,78,87,253,133,203,33,168,25,234,6,108,79,28,214,221,140,234,248,0,42,154,129,225,82,190,51,66,138,76,30,73,9,31,143,46,12,203,252,86,232,153,100,212,93,94,115,149,122,125,53,205,194,73,209,100,98,41,40,63,52,34,234,130,92,206,82,176,187,172,30,175,215,79,107,84,170,166,138,98,23,126,196,91,23,243,36,190,82,219,132,161,6,116,34,31,87,168,144,112,140,151,12,69,16,21,253,99,88,20,157,175,68,193,228,177,199,182,1,247,243,83,73,113,221,70,217,111,16,239,209,35,173,212,51,191,173,44,127,163,144,179,124,11,232,41,200,94,48,20,41,239,225,216,1,108,92,77,148,196,14,17,16,125,34,213,59,31,48,72,68,22,0,95,4,5,241,187,152,234,159,129,144,185,72,134,94,184,13,18,170,88,42,80,217,251,127,142,160,150,218,208,19,29,7,15,123,124,145,61,244,69,24,96,30,170,148,145,199,99,225,44,182,55,219,91,68,3,188,251,0,17,178,65,248,86,62,220,194,96,236,112,242,140,187,40,108,47,89,58,72,1,20,199,104,145,126,166,254,198,236,100,207,77,199,160,102,79,155,124,75,221,40,7,33,41,46,36,254,111,240,244,31,191,19,109,135,245,212,125,139,167,131,168,17,121,171,133,145,202,67,130,182,28,192,108,127,43,238,125,56,223,155,6,163,179,8,66,146,125,19,218,47,112,214,220,155,138,116,106,149,185,175,45,117,47,156,214,220,45,34,31,163,91,64,0,46,214,187,207,6,50,220,66,75,20,215,79,210,12,130,90,140,225,42,37,141,65,122,211,31,122,160,103,242,31,216,180,108,217,231,113,76,179,93,38,105,28,238,246,218,20,140,129,21,223,47,60,103,226,159,194,234,152,73,142,19,225,78,176,62,37,152,79,32,173,41,173,67,160,0,100,157,199,49,125,236,105,22,146,33,124,27,128,34,195,45,105,23,237,152,141,158,195,225,176,208,195,37,76,122,166,121,149,9,39,75,137,21,12,23,131,153,51,155,46,246,140,229,153,207,129,250,180,227,102,95,235,53,223,9,169,98,86,166,116,17,17,92,63,165,5,88,168,115,192,235,210,246,36,249,198,77,144,147,187,41,131,168,235,207,19,211,172,161,201,246,171,83,187,43,133,93,108,196,16,94,57,190,169,157,88,179,151,104,145,76,0,107,69,31,109,152,139,173,141,123,15,23,165,14,106,56,205,163,189,233,151,250,222,236,59,69,43,203,190,122,245,93,212,92,180,9,55,223,32,190,110,174,225,200,7,52,160,233,86,21,91,231,196,225,166,18,245,247,208,146,78,222,86,136,252,153,6,40,143,182,124,85,167,17,71,167,207,16,205,183,43,248,142,70,90,169,62,210,98,40,149,19,133,105,28,95,140,15,55,29,192,220,51,128,183,76,254,104,44,151,32,47,45,237,61,215,235,97,152,193,109,242,220,19,29,27,100,244,56,88,169,224,140,3,238,222,177,168,38,110,87,230,191,224,218,34,224,100,192,49,23,119,50,138,99,114,104,175,209,217,188,64,52,192,84,80,131,76,203,159,110,177,52,144,204,4,249,31,61,234,133,134,133,164,144,198,202,148,70,140,113,41,97,205,179,75,140,9,216,240,151,68,99,164,171,119,55,69,140,137,140,13,142,197,93,53,49,172,247,57,81,193,174,107,242,110,102,251,186,94,10,105,114,208,77,161,12,25,9,138,75,96,179,80,107,166,240,144,194,129,110,204,7,33,148,101,185,173,113,101,192,192,13,90,241,66,212,199,53,251,217,4,114,152,32,161,73,88,83,22,33,30,247,89,135,224,137,251,205,8,166,2,250,75,19,31,125,35,25,96,72,22,204,146,232,155,231,40,98,64,197,115,68,88,3,235,221,101,184,90,104,225,192,252,75,139,39,34,158,97,77,219,17,162,149,192,59,75,250,177,141,214,49,157,95,9,61,68,202,110,96,118,145,32,149,193,158,44,171,64,150,164,30,17,97,103,249,44,2,141,184,166,183,227,159,224,194,205,74,15,181,48,109,149,8,56,129,94,51,250,166,152,95,7,98,235,92,208,250,195,60,163,177,219,242,140,248,100,39,79,81,16,8,89,43,113,109,59,105,91,47,143,146,89,220,251,134,188,211,110,31,189,94,65,62,207,63,16,79,198,160,252,44,186,154,132,232,64,89,9,118,146,183,6,96,176,20,224,10,126,27,55,7,229,155,28,225,126,31,241,188,47,34,175,83,80,214,115,226,227,194,194,104,224,100,25,135,75,136,188,173,117,62,157,34,231,57,227,34,144,203,165,1,100,113,20,199,56,126,78,121,146,82,255,235,232,38,188,215,225,135,132,165,241,130,215,169,157,123,95,19,234,29,16,50,7,213,37,86,141,221,39,205,212,111,148,249,249,1,79,81,248,28,79,121,62,131,199,29,154,254,145,82,69,207,119,248,215,28,190,2,33,119,197,155,176,122,84,196,129,3,185,111,153,135,113,111,203,140,138,209,209,134,37,250,72,40,249,45,13,1,25,7,37,247,102,74,182,44,166,194,250,5,40,131,112,137,122,35,77,66,154,225,50,222,172,193,120,160,201,7,82,168,99,0,247,224,16,162,28,116,143,231,23,250,129,255,75,222,236,60,167,11,224,226,176,26,249,171,200,238,107,1,92,51,50,57,244,85,254,215,3,197,165,18,75,153,91,206,173,162,49,151,188,56,3,63,202,14,123,44,154,211,154,163,77,85,188,156,90,143,148,93,221,100,42,247,146,144,248,218,86,138,171,182,102,82,113,197,19,50,33,20,64,93,200,179,245,154,19,246,220,64,7,59,243,22,171,122,127,28,140,231,212,204,232,218,95,154,78,212,183,64,233,33,81,85,13,190,204,54,237,143,23,137,188,121,31,208,164,71,178,169,123,20,130,190,122,107,53,238,251,157,122,73,239,48,125,55,190,12,75,249,217,234,174,75,206,156,130,184,196,9,109,32,40,96,149,39,221,252,36,250,54,177,48,250,184,113,97,136,234,108,246,17,120,199,75,126,123,227,197,130,98,227,232,144,108,22,122,142,238,127,212,161,11,158,102,115,18,2,178,131,172,241,142,34,252,145,50,215,120,234,5,249,192,209,100,142,155,105,102,142,183,18,98,188,227,126,195,64,252,130,190,21,179,158,234,45,40,124,223,133,208,10,140,164,182,94,111,226,98,111,107,207,25,89,168,186,177,158,187,56,159,254,64,114,164,131,121,247,67,206,177,2,127,5,160,31,6,56,27,57,251,132,239,22,186,65,197,25,70,167,21,194,101,230,164,219,136,7,51,139,174,204,73,4,141,83,103,112,122,20,155,15,194,14,170,101,227,206,115,160,247,186,104,228,85,185,221,140,135,69,221,173,233,249,178,35,7,145,121,80,66,81,91,74,210,203,87,25,235,234,27,182,31,101,137,95,52,129,28,117,169,98,88,141,244,253,253,159,226,222,33,2,254,232,121,46,48,19,238,56,217,115,138,90,211,85,167,90,178,145,113,98,164,84,75,148,15,236,180,208,104,132,32,250,247,55,157,132,19,118,210,2,4,96,74,238,185,196,15,239,4,63,6,45,103,220,232,80,131,250,28,65,13,237,92,55,125,115,31,55,246,57,24,112,236,188,53,208,223,146,55,158,216,43,109,55,179,113,241,197,231,224,128,108,76,170,187,5,114,106,234,169,30,110,8,159,133,168,202,117,233,145,123,201,56,123,125,119,98,132,147,185,105,7,149,197,236,94,94,215,139,160,88,61,209,149,3,155,121,95,219,181,109,210,102,109,222,14,215,0,155,22,203,133,247,137,155,252,103,119,168,179,58,212,53,162,252,112,80,21,250,182,124,132,5,33,223,78,145,82,70,102,202,160,228,231,165,123,20,251,171,90,154,56,32,3,43,60,71,243,112,3,96,232,246,19,193,151,214,209,2,178,41,99,66,56,19,96,8,15,94,217,10,55,205,252,216,70,37,14,150,138,248,190,136,103,100,54,228,148,38,177,221,24,138,251,100,17,35,226,23,236,171,117,149,95,149,1,108,47,33,152,141,214,214,7,219,200,6,239,33,167,156,219,212,186,185,103,8,46,240,147,251,133,207,179,187,149,120,0,171,111,141,49,105,121,74,134,75,204,150,94,212,170,213,63,41,131,109,181,76,65,219,161,35,91,128,191,225,244,183,6,21,183,112,239,47,119,146,195,4,177,204,118,27,251,121,232,228,143,28,95,199,56,95,126,181,14,241,68,35,134,218,214,72,218,89,40,171,154,187,73,112,66,213,235,164,33,124,175,250,246,212,28,53,33,224,23,119,11,245,88,132,18,65,174,185,173,58,201,207,62,49,236,31,161,102,107,155,76,8,163,245,206,165,106,26,239,146,227,183,0,169,195,201,100,148,13,253,153,202,87,73,86,113,242,75,202,127,156,76,175,130,15,152,237,54,119,141,219,143,53,220,107,92,49,250,223,33,232,12,161,113,196,39,154,167,171,82,211,201,71,143,138,210,237,151,108,39,145,177,218,110,108,231,131,180,32,208,30,34,138,93,0,32,187,67,193,184,96,216,188,131,69,254,97,22,128,43,112,32,121,158,151,179,174,120,35,109,148,66,61,10,41,11,101,178,106,234,179,119,216,78,130,88,241,70,13,59,97,171,132,218,110,107,4,179,130,252,24,107,173,131,178,147,166,17,193,10,237,155,229,37,71,136,18,144,114,35,47,78,133,13,180,71,38,136,102,193,245,220,188,233,83,22,56,113,56,207,109,179,153,233,132,36,87,210,30,225,166,73,23,224,88,153,95,115,174,246,190,233,172,29,89,138,111,3,108,203,184,175,147,168,242,247,52,214,91,220,247,36,150,85,208,153,11,66,137,13,33,162,72,28,125,197,209,253,229,232,34,164,156,202,46,115,13,144,84,241,74,3,156,80,102,49,43,24,157,64,129,134,122,191,182,61,150,245,236,192,62,67,209,205,102,106,110,127,254,196,78,242,169,154,118,194,70,162,123,6,5,201,233,34,63,180,242,172,217,80,115,6,137,51,6,104,161,97,49,228,120,170,241,229,203,58,146,146,39,51,238,146,131,224,176,206,158,169,88,99,208,89,90,235,134,116,161,75,145,39,29,173,30,68,65,159,4,109,115,220,238,195,24,248,220,13,189,184,170,248,26,95,101,84,251,221,43,87,209,23,157,62,121,72,201,2,129,184,48,221,23,240,23,167,51,116,202,84,206,255,201,96,198,224,61,74,107,124,186,75,167,113,224,27,54,170,144,192,45,193,101,25,172,53,124,92,105,88,83,72,13,251,186,175,212,81,34,162,88,141,31,16,232,184,68,231,77,43,115,244,112,55,233,80,174,118,202,192,176,224,201,187,99,75,25,157,66,152,81,211,62,57,28,162,55,35,23,183,75,140,119,53,173,203,80,94,172,203,145,93,50,105,195,117,176,90,0,3,110,38,120,145,27,50,247,58,227,16,38,69,225,206,102,194,43,44,79,0,19,3,57,134,83,240,242,225,115,243,217,213,54,79,83,103,12,134,174,57,55,49,180,152,134,88,227,246,103,228,255,197,188,50,77,154,67,21,86,35,107,156,20,13,133,125,53,80,111,5,132,173,110,255,223,250,230,252,252,75,232,241,155,51,127,195,170,8,186,158,38,244,46,47,98,120,36,1,245,6,149,105,193,146,5,185,43,9,107,236,51,177,112,54,200,150,16,194,179,181,226,192,132,9,61,115,109,46,152,147,70,74,88,141,203,71,77,40,224,231,44,74,151,56,145,39,201,118,46,162,185,107,182,249,81,38,218,57,41,100,13,52,49,225,39,108,64,63,218,174,160,251,157,57,86,155,60,74,8,251,162,240,79,243,76,172,205,183,29,168,240,44,110,121,125,38,166,101,156,98,45,159,175,79,187,135,67,107,151,233,195,61,27,197,2,56,83,114,93,66,114,166,237,77,152,124,72,136,209,124,225,226,212,202,30,219,6,238,168,105,204,64,252,91,145,191,212,82,89,214,102,171,215,209,100,55,33,137,120,108,33,25,132,35,53,32,185,255,221,165,254,144,101,16,52,252,200,18,26,44,221,135,179,135,199,214,187,54,151,152,24,114,158,75,177,173,75,9,207,121,34,117,50,23,166,52,17,55,14,241,207,250,110,231,99,75,228,232,16,89,20,124,215,21,120,142,193,7,62,167,176,48,202,36,176,211,66,111,20,140,74,49,194,103,13,157,78,228,46,245,27,52,229,158,176,66,238,189,162,135,104,132,8,249,174,253,239,78,232,92,220,86,243,82,193,255,75,193,62,145,151,206,86,34,216,136,182,84,218,55,200,19,225,27,146,221,125,242,54,153,91,47,39,181,7,91,71,255,38,169,13,95,138,19,96,172,125,230,103,33,55,114,197,166,227,83,146,11,4,219,200,17,113,179,89,101,223,196,48,255,225,19,178,230,105,219,202,206,211,213,205,148,42,15,37,80,3,122,14,173,132,180,189,148,17,223,30,193,104,78,57,248,187,248,153,6,134,229,11,113,65,182,175,153,97,191,204,247,46,196,20,9,197,146,198,22,102,205,40,150,184,18,97,194,117,172,236,63,82,86,136,64,122,18,138,115,154,229,195,118,151,12,59,243,18,127,39,95,73,186,87,94,233,32,242,41,198,9,9,130,30,58,119,240,182,15,203,100,71,237,143,0,138,219,44,31,247,137,144,240,49,229,254,195,110,240,120,200,230,5,160,22,64,23,127,7,127,67,208,142,156,252,194,222,3,219,65,167,6,197,85,217,123,22,44,30,164,227,35,94,83,235,179,236,46,152,230,9,105,84,219,105,247,223,119,64,115,167,30,44,203,123,249,218,245,26,10,126,131,224,235,51,105,212,3,142,230,82,178,191,250,81,252,240,73,212,119,50,252,193,196,187,95,15,228,21,92,105,121,201,230,113,228,175,211,35,148,34,177,162,2,214,195,66,1,110,119,121,128,18,75,8,202,147,66,47,101,242,119,10,48,2,132,247,139,89,164,127,124,48,249,197,248,168,194,157,245,174,67,231,64,150,167,248,85,109,215,15,223,148,92,99,200,6,145,127,10,82,227,103,224,128,242,145,195,43,196,189,32,115,200,19,107,216,4,98,220,222,114,56,53,105,178,31,195,68,79,24,214,150,204,89,144,248,22,203,79,18,31,41,132,11,114,176,135,112,168,247,26,108,178,192,84,106,136,45,191,189,115,49,144,47,76,102,194,4,222,94,185,246,112,149,19,167,5,57,247,13,131,144,233,96,74,255,71,10,149,110,58,77,160,158,161,125,218,27,217,201,176,235,219,61,103,163,9,136,14,125,30,226,155,36,8,3,236,15,68,38,96,46,41,139,25,53,252,64,104,143,13,88,154,110,186,31,22,24,181,182,218,134,98,224,128,50,26,60,221,117,222,36,200,100,125,247,60,11,4,197,104,34,89,138,189,21,157,54,218,134,166,234,10,206,84,145,186,74,12,106,112,253,207,161,36,48,132,248,232,3,6,60,64,6,100,162,172,116,123,104,51,182,116,216,130,191,228,29,83,48,214,170,221,104,33,169,245,43,90,152,105,53,231,157,44,156,203,80,180,155,183,61,129,132,138,208,191,20,110,129,154,46,100,40,139,161,192,75,205,127,45,59,26,91,45,55,116,211,186,121,251,191,93,39,210,142,17,71,105,211,194,52,208,68,227,12,243,62,49,70,218,188,71,60,111,14,66,217,106,139,5,14,208,161,214,206,157,163,135,38,98,241,74,65,185,17,143,255,204,155,48,29,49,178,125,178,136,123,250,96,249,245,121,35,211,59,117,43,185,53,196,47,139,45,207,38,86,121,32,204,145,157,169,153,48,147,105,153,45,97,142,63,163,243,132,81,58,250,123,216,197,59,124,247,175,128,82,82,45,125,102,167,21,110,32,75,226,64,16,14,29,226,218,221,25,206,135,180,247,17,3,216,245,203,93,114,151,61,226,86,86,114,162,214,53,182,77,95,211,142,138,182,237,239,217,243,241,100,61,73,186,113,153,157,32,121,17,191,166,207,57,188,36,152,10,12,180,152,117,242,11,0,190,243,125,17,220,138,193,102,96,97,16,233,107,107,248,132,145,66,238,95,227,196,55,47,198,37,66,34,14,198,183,25,38,78,235,199,183,94,141,245,83,28,118,101,100,72,149,109,60,168,44,5,237,248,210,197,131,14,95,228,149,57,99,195,144,183,251,75,74,196,115,190,19,6,125,221,166,7,62,105,167,108,95,0,61,105,83,248,242,254,78,67,152,172,243,172,31,233,188,115,26,175,51,62,152,199,8,83,92,250,184,200,59,23,140,233,35,146,248,93,246,44,66,150,89,180,6,188,133,97,85,13,122,245,105,130,103,90,42,170,248,204,209,7,126,154,239,168,68,105,156,91,254,162,150,54,10,240,220,176,250,210,168,140,233,137,237,221,29,182,68,150,1,135,255,19,178,139,62,103,138,122,178,71,132,72,244,64,67,244,210,19,232,194,125,218,159,39,115,16,157,238,114,74,158,234,157,13,52,4,159,125,32,101,96,103,209,251,13,37,151,138,166,173,105,141,122,189,124,250,48,121,14,31,62,106,8,43,172,231,118,206,53,56,179,222,31,100,160,232,76,153,202,225,134,72,252,186,219,91,36,12,166,38,147,74,35,141,145,85,86,109,198,233,250,240,64,119,141,134,190,167,221,125,69,31,4,45,28,241,154,144,149,149,235,174,212,74,84,74,108,147,104,49,55,112,251,59,177,5,245,69,135,53,120,25,109,93,245,50,140,186,3,60,198,189,74,22,180,90,255,114,186,83,226,226,21,102,36,45,72,163,1,95,103,207,132,106,180,98,177,37,204,234,77,136,45,30,224,109,166,222,124,13,18,109,244,213,101,53,69,177,148,231,232,174,223,246,219,213,22,173,248,65,84,232,122,158,147,140,61,146,254,221,215,111,108,45,118,229,189,109,80,100,40,164,235,67,77,192,154,87,180,96,89,232,99,165,5,97,39,40,36,34,120,70,27,135,223,9,188,229,95,219,253,108,174,124,131,28,152,41,238,176,57,132,144,79,195,62,76,3,247,114,208,151,97,116,124,69,237,243,164,129,29,138,98,139,108,183,190,121,242,181,22,124,88,2,51,242,191,57,99,10,40,49,157,255,255,126,219,165,165,228,43,222,11,66,172,125,10,188,93,174,186,159,33,159,223,243,159,232,102,24,174,38,77,70,122,216,155,80,92,255,60,1,49,175,62,176,12,231,249,100,240,203,225,12,182,171,14,128,155,154,96,224,97,75,125,117,27,254,246,113,25,29,171,244,9,98,164,196,125,2,129,40,209,56,54,39,45,107,61,21,109,252,120,167,144,213,180,191,100,51,190,72,58,134,238,130,210,21,39,233,21,24,139,26,225,236,75,99,149,73,181,101,72,99,5,200,6,186,130,213,153,168,29,177,157,229,24,113,98,233,133,170,237,68,218,200,160,75,226,77,58,140,37,10,211,255,59,207,17,25,99,222,54,49,94,241,100,132,224,160,221,125,28,54,249,191,141,102,83,207,225,148,205,112,50,254,220,231,104,154,98,79,176,183,56,77,79,15,16,181,103,145,164,242,131,57,145,49,225,181,202,149,238,136,238,160,3,67,242,64,82,249,71,6,212,233,230,16,178,32,96,198,0,185,19,186,77,16,13,136,95,177,135,249,231,190,84,70,13,37,207,55,75,68,189,252,83,55,147,189,231,120,66,195,239,133,254,38,40,166,82,166,10,128,79,136,75,49,254,44,70,196,154,234,206,108,15,115,71,32,8,245,182,39,152,39,155,169,138,66,65,72,33,41,114,166,160,234,47,193,118,244,223,240,58,16,148,231,85,67,77,176,34,70,140,11,15,33,46,117,93,216,51,251,121,13,225,204,87,125,193,236,245,5,1,246,21,184,127,155,41,146,177,110,191,0,239,209,161,218,175,254,68,42,167,239,207,107,156,160,141,222,83,178,153,147,56,228,102,117,59,238,28,175,179,156,214,211,234,188,40,64,249,74,225,85,138,71,165,117,80,234,69,24,47,255,35,140,17,158,7,77,170,119,162,214,134,98,49,205,136,168,38,76,90,254,252,116,47,69,60,208,44,215,123,187,133,7,246,224,59,52,203,1,9,104,202,86,210,250,170,95,227,129,84,126,252,117,243,189,164,202,231,9,93,225,89,173,93,17,184,206,235,32,129,32,249,126,103,69,175,218,76,92,205,216,129,159,167,137,201,160,5,142,36,136,0,8,164,86,113,213,112,83,93,235,48,38,76,165,45,28,47,106,184,191,133,112,132,179,230,10,84,250,209,208,29,241,121,97,184,5,122,150,131,76,21,28,199,242,214,170,238,137,141,192,123,149,136,9,96,223,174,14,128,93,154,164,146,179,227,121,78,2,17,142,37,255,62,1,20,232,75,253,83,167,214,209,4,39,227,118,159,193,114,223,0,150,239,207,243,184,62,112,187,147,88,210,33,183,61,212,235,68,26,230,91,111,129,177,248,131,201,144,234,222,253,152,160,214,48,160,206,144,9,245,115,53,96,55,32,165,18,20,231,0,129,12,90,204,129,7,109,165,205,74,222,132,236,96,17,3,108,250,211,35,165,124,230,160,198,175,224,83,210,0,247,205,122,62,45,75,127,4,28,65,149,131,122,199,47,118,216,56,138,58,20,40,220,65,123,13,98,30,214,14,79,54,118,130,161,82,101,99,246,31,37,95,191,198,167,104,73,92,68,52,3,100,175,216,163,137,143,176,39,209,44,40,62,23,33,219,234,171,157,147,80,39,164,238,124,93,47,179,67,132,194,221,171,29,227,192,156,25,146,80,153,165,110,231,72,75,9,175,244,16,102,16,3,166,47,209,177,0,224,26,152,48,125,20,198,224,232,168,80,98,17,184,80,115,152,20,89,9,200,135,229,52,197,137,178,133,230,244,107,238,156,184,214,97,221,17,58,2,112,15,190,199,18,23,191,89,18,41,3,179,95,151,233,226,129,63,87,64,182,30,2,148,45,248,76,227,40,230,71,55,183,171,251,94,174,129,74,227,38,151,184,205,51,117,90,2,195,205,88,190,23,144,58,239,86,133,112,15,154,66,250,234,254,240,194,120,55,40,241,70,49,126,101,64,197,152,16,167,181,52,184,173,74,119,112,89,219,135,147,48,152,245,167,143,23,195,68,43,90,204,53,110,182,67,247,80,24,32,137,17,103,42,126,178,162,202,23,193,30,135,178,64,84,104,37,81,184,181,159,195,16,179,150,161,180,62,210,139,153,157,214,1,171,225,112,147,15,104,27,255,209,154,118,227,125,153,243,124,113,43,183,218,229,182,40,153,46,81,167,0,78,38,76,7,66,236,108,156,203,201,120,32,220,239,25,10,21,97,233,44,208,6,134,172,59,40,57,92,110,59,212,96,68,15,204,240,4,187,109,214,29,74,83,191,199,39,199,48,179,56,246,51,113,130,30,46,31,125,41,147,8,105,121,160,60,129,193,99,251,190,2,158,234,83,163,254,63,102,165,233,165,29,7,63,255,58,169,32,92,150,87,79,74,167,211,247,254,67,234,238,160,28,44,57,10,49,12,72,188,155,209,10,78,191,160,167,90,140,1,226,231,100,141,89,229,177,1,142,249,151,127,24,3,221,88,253,178,110,80,229,240,47,118,123,122,172,133,22,129,242,34,228,46,205,253,240,198,160,167,43,144,61,77,234,197,12,22,203,37,160,24,2,201,216,241,11,206,30,100,89,125,109,126,253,117,5,142,221,92,195,186,169,15,182,73,2,239,23,204,69,162,189,235,246,148,1,116,53,98,98,144,5,78,112,51,77,166,47,96,74,151,210,91,240,224,177,57,229,35,29,213,189,90,24,197,66,212,102,15,5,2,228,87,150,50,212,173,10,82,96,12,75,65,79,177,251,40,218,249,78,80,184,153,38,191,56,206,8,195,64,109,107,17,124,43,251,226,215,228,108,104,209,244,205,152,160,142,199,88,64,84,213,46,5,95,104,181,27,232,60,198,90,62,123,114,17,32,46,123,109,188,10,59,227,208,153,122,39,182,253,34,91,54,97,191,166,198,55,238,195,8,154,78,134,51,232,56,3,223,243,207,212,184,36,70,180,131,119,247,43,62,11,138,172,17,78,37,188,90,79,251,200,102,205,225,225,254,55,207,248,1,125,203,87,197,143,175,82,145,163,37,196,27,104,55,61,186,37,182,139,133,30,97,84,240,108,106,47,247,110,157,48,63,96,26,213,9,86,42,208,187,110,41,29,223,140,188,99,201,38,135,123,117,9,100,228,70,219,228,236,94,181,203,24,38,30,113,17,132,75,62,134,206,219,10,19,236,251,122,173,180,201,214,99,245,13,6,23,212,113,98,164,119,106,167,167,80,214,65,24,246,174,13,86,76,141,180,51,169,176,139,232,64,120,30,187,55,108,14,254,236,24,201,175,19,161,96,78,31,208,56,42,15,24,55,251,210,47,75,158,103,157,10,42,18,151,211,184,161,62,190,220,168,61,132,26,109,166,38,216,59,84,210,125,219,11,81,149,204,102,225,150,171,127,155,43,115,97,128,223,224,191,3,47,167,201,215,69,20,250,47,69,96,32,43,56,224,214,155,219,94,84,132,32,162,73,221,23,240,252,42,119,7,201,90,84,20,119,179,3,91,188,153,199,43,50,18,78,210,125,16,191,142,34,116,113,53,128,171,153,111,64,228,12,72,47,117,80,238,130,31,81,238,17,212,113,117,150,153,6,175,150,76,29,50,73,216,26,202,75,21,19,172,48,116,51,70,40,38,250,108,87,38,54,76,153,3,113,201,107,149,213,201,4,180,101,174,237,251,6,225,239,224,218,37,78,130,88,100,69,93,119,142,178,105,139,204,213,144,101,107,58,130,31,47,40,76,27,14,80,58,216,147,246,20,215,12,188,201,176,2,202,182,207,208,77,138,123,158,114,109,199,17,252,128,128,173,229,167,169,207,55,60,155,22,181,128,40,51,55,60,193,174,169,30,196,202,135,216,186,229,226,254,231,115,205,14,189,20,199,84,170,174,118,161,4,8,157,12,109,194,8,211,246,228,173,97,230,32,154,82,47,16,228,225,191,81,41,182,104,216,167,76,54,137,215,59,196,56,63,250,213,47,82,157,133,198,64,225,126,147,135,175,80,255,217,189,28,3,185,24,187,115,200,31,225,35,16,119,90,240,110,111,67,16,240,13,9,21,154,124,214,187,57,72,43,13,33,184,176,142,198,163,71,102,250,240,51,65,24,78,243,250,85,168,69,4,24,240,125,51,0,60,10,91,163,61,127,212,163,84,90,238,31,188,90,58,154,90,183,0,81,161,12,7,198,212,139,193,134,96,222,223,18,126,25,184,217,22,75,10,132,150,163,211,26,172,24,105,197,78,247,147,61,59,204,151,193,28,138,76,151,30,183,209,187,163,109,26,47,231,14,52,218,112,232,215,118,73,18,124,244,227,46,113,147,88,242,143,223,141,187,194,182,252,159,55,12,54,6,174,226,38,8,208,86,240,235,70,10,132,237,58,125,202,48,226,237,27,213,130,9,172,45,2,36,143,110,121,46,223,97,180,195,94,173,192,123,106,42,31,124,177,112,20,86,196,221,221,191,186,58,150,141,197,21,142,249,25,150,145,228,4,180,186,179,172,89,254,86,137,110,170,105,118,174,47,199,94,154,84,253,36,234,11,124,138,170,20,19,231,136,129,126,238,1,125,207,48,76,134,210,13,183,178,98,76,61,246,140,139,91,69,221,140,194,189,41,129,169,57,120,205,213,201,87,72,32,120,137,188,90,136,180,63,223,154,184,84,46,31,72,209,144,249,58,42,219,27,167,137,37,11,160,235,7,149,181,39,13,12,252,85,62,89,159,187,211,81,204,211,83,193,111,59,157,204,192,112,37,234,216,192,63,129,135,189,120,151,59,28,107,229,57,79,67,24,22,151,156,53,4,171,20,212,219,219,72,224,169,70,242,72,136,78,194,117,104,10,86,57,45,20,83,239,25,65,112,233,107,142,26,217,140,48,186,3,135,82,219,104,211,215,152,170,2,246,104,100,183,22,79,92,118,6,215,141,80,36,235,46,213,231,78,139,173,89,184,237,6,42,143,178,205,230,248,124,100,26,42,118,42,118,22,243,68,134,120,248,170,143,168,57,109,240,192,64,110,234,198,119,176,47,99,50,153,120,218,158,103,135,189,159,216,171,229,77,215,220,221,117,153,120,124,0,6,25,139,53,120,34,226,247,10,237,122,139,80,177,25,199,181,223,139,106,168,120,254,39,209,40,212,97,103,244,157,250,231,7,172,158,190,10,146,195,112,107,71,152,113,219,253,37,1,238,188,76,159,75,69,189,106,182,59,116,50,47,227,22,115,67,33,174,191,154,81,178,164,35,223,62,55,25,104,234,172,134,81,239,141,117,43,55,180,124,31,84,142,75,226,182,235,123,250,208,103,117,130,169,34,193,10,189,82,19,124,92,171,190,172,27,15,181,62,18,45,16,248,25,158,135,66,57,221,93,188,224,164,191,215,70,182,48,64,126,41,212,14,130,59,223,155,150,121,181,136,60,148,91,153,5,152,80,214,22,193,148,40,172,176,104,190,21,89,146,236,23,76,197,40,70,52,163,77,5,229,106,223,17,221,226,152,165,5,252,173,57,16,117,211,56,247,176,110,142,74,253,47,239,201,94,252,152,30,87,3,30,178,12,8,75,38,122,193,131,177,111,196,230,128,234,214,33,100,197,52,183,117,140,96,185,139,155,120,151,194,250,249,68,64,18,56,203,146,89,222,157,128,70,209,58,104,218,89,80,254,2,64,245,208,30,114,220,141,87,58,22,38,254,253,171,102,94,108,77,151,24,167,44,203,190,195,43,4,66,207,231,3,130,247,252,154,21,244,108,184,246,117,253,41,99,42,51,43,109,177,118,46,248,181,111,227,203,223,15,80,36,208,139,127,166,136,116,234,240,5,81,61,87,209,225,140,92,224,189,184,233,229,83,217,209,234,23,55,143,251,141,76,128,21,154,23,10,60,90,234,231,175,239,222,143,171,3,25,191,41,168,151,141,64,215,201,75,144,65,107,25,173,52,141,208,31,102,202,96,11,95,208,198,190,95,174,29,39,154,111,102,235,190,115,189,175,34,128,166,128,31,155,70,28,87,138,204,147,134,202,1,146,99,191,15,152,174,55,33,118,185,38,209,97,219,198,222,233,133,188,6,107,63,123,165,6,121,69,48,137,187,196,166,195,156,39,168,124,91,237,244,64,102,59,127,93,38,186,27,104,47,184,23,161,138,233,120,217,250,125,228,100,250,29,247,4,255,160,174,25,83,187,65,69,218,21,210,64,133,196,45,227,183,58,199,56,1,10,219,40,97,184,49,99,104,188,50,64,159,107,28,35,207,79,147,60,171,237,13,73,50,252,192,252,168,77,141,175,107,62,20,98,33,172,76,209,133,29,75,237,101,8,218,202,77,95,170,215,150,242,147,114,146,182,255,59,0,203,106,137,195,124,125,157,251,62,45,84,41,167,154,214,246,205,66,53,176,136,222,227,190,64,23,243,228,47,3,190,85,221,129,167,165,89,118,134,70,26,230,208,46,206,211,228,226,133,179,115,157,234,27,38,163,127,12,103,8,2,253,179,158,237,133,126,19,178,109,18,43,90,234,197,105,222,185,152,130,45,44,90,53,127,221,76,18,51,239,233,84,18,173,137,78,57,0,118,212,172,43,88,199,95,216,114,165,39,150,48,67,102,43,154,185,96,128,87,189,14,68,78,50,59,162,226,213,253,146,12,237,120,227,124,61,170,91,197,42,173,78,83,76,142,35,74,102,75,236,41,98,214,64,131,223,69,123,224,230,162,206,180,4,131,35,52,35,250,181,124,227,216,100,74,232,6,169,218,177,64,134,168,3,169,232,77,9,106,93,40,121,73,121,17,1,135,213,148,149,23,132,128,211,88,2,109,65,130,166,54,216,177,113,120,222,236,102,210,143,107,164,39,83,17,22,16,165,152,86,167,42,177,60,231,33,41,255,32,166,117,107,4,230,169,170,9,46,36,152,39,212,241,22,207,160,219,216,45,129,124,124,149,119,19,36,91,70,49,185,206,144,245,97,51,49,221,86,121,255,36,172,176,207,68,244,136,33,119,54,250,71,23,4,151,84,4,80,74,60,117,23,7,67,171,99,219,140,26,125,156,10,78,185,36,35,192,214,237,133,120,77,31,9,186,140,176,110,186,117,228,71,45,55,29,141,144,208,34,220,83,255,220,208,54,165,142,86,181,101,198,226,231,5,128,182,45,180,170,115,0,133,228,167,116,159,49,192,182,214,157,175,130,191,123,51,127,27,91,43,199,119,251,132,224,183,210,11,120,176,154,202,212,215,220,17,139,200,90,152,137,69,141,193,57,28,234,163,81,54,125,84,87,88,135,26,215,220,174,249,209,150,83,244,242,120,161,9,209,75,30,206,24,183,1,210,47,2,231,33,134,84,236,153,187,222,27,249,216,205,76,113,59,215,163,91,71,105,9,203,141,7,29,50,98,163,57,180,232,158,61,67,202,72,137,21,246,36,74,226,32,128,6,142,14,51,242,88,0,219,90,97,224,172,53,71,103,161,225,198,216,158,112,103,198,6,55,114,94,109,249,219,173,136,119,247,124,210,122,11,186,60,137,160,221,214,174,174,24,129,52,232,14,104,211,220,121,79,80,106,0,184,19,79,106,184,229,174,8,193,129,100,27,242,0,58,175,102,69,14,164,49,167,246,40,138,52,214,50,5,75,137,233,209,176,153,152,13,199,172,50,70,127,164,225,153,213,199,87,37,188,150,76,28,24,69,233,143,134,118,67,250,23,123,83,44,111,225,201,140,173,208,145,207,73,215,20,60,107,81,106,66,10,207,187,82,73,166,47,183,248,185,160,113,32,189,129,56,54,212,68,228,23,105,104,2,89,114,233,74,251,214,179,169,142,71,135,179,78,122,40,118,32,244,193,198,248,161,71,230,16,81,168,167,187,117,237,106,75,214,71,211,21,246,81,138,157,51,138,47,92,186,213,229,88,227,21,24,171,63,241,164,233,120,89,190,125,247,205,245,51,9,226,137,162,45,3,182,244,149,93,247,19,157,13,14,139,190,245,67,80,24,168,82,132,211,66,207,27,147,147,211,171,186,6,174,183,86,125,44,224,163,168,153,4,176,219,100,123,33,147,197,103,133,89,27,203,114,173,183,201,215,35,77,244,197,213,17,21,150,138,218,92,134,20,47,73,230,252,9,242,80,127,186,1,212,66,77,25,50,52,37,32,14,204,176,109,245,199,107,142,114,171,55,228,117,99,10,194,229,68,192,132,29,87,208,76,38,128,251,87,106,245,234,207,205,138,124,244,149,51,0,202,51,49,190,33,112,66,75,73,149,60,64,133,91,59,245,19,204,40,199,97,211,85,26,95,45,46,198,63,77,246,203,42,140,89,253,151,226,63,133,28,68,166,110,142,209,177,172,237,72,31,200,90,13,9,252,141,134,228,22,62,121,223,88,167,141,100,9,181,248,195,45,216,93,118,90,118,81,135,193,19,226,32,183,252,169,59,136,144,25,100,139,6,42,94,70,9,86,21,53,133,131,84,126,225,45,236,204,220,121,127,135,161,20,65,127,253,132,252,121,189,163,127,21,16,57,76,149,110,217,239,234,182,119,42,181,235,163,227,14,173,143,22,34,156,94,103,241,116,83,211,114,234,230,188,62,47,105,104,197,91,78,194,143,146,223,6,170,135,230,192,213,105,128,73,36,16,92,158,86,47,81,118,132,54,29,81,28,181,124,61,252,234,97,44,63,83,6,150,218,179,254,122,209,6,148,17,125,20,63,9,103,113,132,229,252,10,232,146,168,57,75,156,18,149,154,212,72,1,51,82,84,216,205,51,61,246,123,48,192,59,76,91,190,106,244,126,218,177,133,215,117,229,189,134,120,206,166,179,11,140,253,230,143,31,137,67,194,207,161,128,180,210,227,202,68,130,78,204,127,194,121,212,125,42,58,141,185,180,3,90,201,160,235,151,154,102,82,154,34,158,0,89,115,44,138,224,11,37,27,240,211,150,28,118,128,30,187,108,13,150,72,237,36,170,153,33,162,133,253,222,236,191,244,235,240,57,61,57,95,1,135,101,24,46,142,177,250,127,46,58,84,84,150,3,180,248,91,171,12,247,62,205,28,44,216,169,74,155,198,255,215,21,86,255,61,244,191,195,106,242,37,65,229,39,26,243,234,123,133,97,81,117,99,67,186,139,149,37,199,150,52,163,38,4,70,251,164,220,212,34,194,66,120,94,222,70,9,92,183,131,254,218,220,179,163,57,27,141,103,189,102,243,120,17,71,76,219,142,148,254,92,250,234,128,29,202,1,1,19,115,0,105,154,11,166,38,244,253,157,225,92,157,203,66,186,237,150,177,201,174,66,197,218,187,140,65,115,239,129,221,151,195,216,254,195,12,156,95,78,176,65,98,105,56,56,42,5,71,38,250,246,243,242,215,182,107,96,26,11,249,30,177,188,241,9,53,68,77,165,95,3,66,144,97,87,208,207,254,29,62,40,162,45,162,79,104,18,224,226,82,189,64,191,124,229,45,50,31,102,171,33,62,7,53,3,253,217,15,74,9,207,16,239,53,114,33,39,175,66,29,103,42,64,170,251,16,251,121,39,8,64,28,91,64,11,224,222,47,134,231,170,254,117,10,13,89,16,38,135,71,180,149,229,118,152,75,201,204,238,91,219,188,141,130,96,196,190,58,158,43,100,90,254,140,57,71,103,71,95,51,240,42,87,21,73,158,21,247,22,171,144,247,90,2,195,101,231,241,236,120,109,178,107,43,114,107,127,51,239,84,129,185,147,175,52,82,216,198,13,158,223,53,149,254,5,51,130,207,80,0,58,63,63,123,26,63,84,163,28,136,173,174,150,41,247,249,247,194,174,63,228,249,2,90,13,221,13,218,16,86,100,200,51,188,120,167,5,200,226,169,182,88,215,72,155,107,97,174,0,253,17,60,125,201,58,28,225,251,59,190,216,200,69,52,111,47,250,23,50,34,166,30,180,75,3,249,162,91,239,133,116,142,207,127,200,252,196,111,54,209,39,51,114,29,172,141,249,237,188,49,239,155,93,197,61,131,63,225,95,242,125,127,143,33,226,144,76,125,7,219,32,32,11,213,35,171,150,147,207,106,145,97,81,146,202,197,50,164,246,196,42,44,43,181,142,91,71,184,177,92,170,244,234,15,137,122,203,144,198,97,37,67,7,207,15,83,13,154,128,222,184,206,43,204,146,15,70,12,250,172,4,6,76,242,239,221,47,220,91,246,144,209,218,183,7,162,103,175,1,24,117,113,86,45,134,132,92,6,209,103,105,81,60,18,13,219,122,216,118,166,182,157,58,184,238,198,192,35,30,189,43,237,19,122,164,109,46,247,190,127,98,224,27,79,109,158,11,109,206,147,106,36,254,207,54,157,123,18,230,250,136,43,232,56,183,175,167,117,180,236,73,177,31,205,74,96,201,88,42,142,67,101,191,176,9,144,90,42,36,184,119,68,180,186,207,189,29,20,241,151,220,93,140,135,187,208,82,178,38,180,46,111,121,77,98,12,248,150,40,174,135,253,216,203,251,44,229,252,12,29,12,116,94,169,113,9,150,79,132,16,238,151,170,104,124,136,212,133,42,13,141,165,104,116,51,98,17,193,20,221,112,198,102,218,236,212,153,220,249,131,26,70,27,23,9,11,234,0,144,54,3,148,104,140,36,19,100,80,94,100,109,80,38,154,69,195,33,248,39,28,3,213,169,170,215,157,238,42,182,143,248,53,38,66,134,74,224,183,105,212,213,45,79,210,9,36,190,145,143,137,190,212,188,58,219,96,86,249,206,214,214,126,79,7,96,151,44,5,188,243,163,70,44,224,240,43,203,252,141,167,196,109,45,245,80,232,111,102,169,182,66,49,95,84,144,238,60,201,229,250,31,232,95,2,191,125,221,8,8,35,174,1,234,236,171,18,254,40,248,146,166,148,97,98,62,158,85,81,44,70,234,174,232,112,202,58,232,180,78,28,17,41,44,224,109,254,2,167,193,247,130,102,239,156,232,124,180,38,167,243,93,179,5,230,135,181,32,239,109,71,24,81,104,124,218,186,33,205,182,52,30,171,84,226,223,126,223,81,98,227,216,127,124,213,85,11,99,59,149,224,245,22,154,215,35,152,40,1,118,245,207,91,200,89,236,226,104,66,74,157,18,104,98,123,227,77,121,122,119,190,43,32,208,25,60,142,31,241,184,112,1,87,92,161,236,22,82,98,210,245,192,32,94,175,243,213,75,19,242,237,236,209,221,122,132,201,106,251,88,210,78,200,124,89,180,28,219,3,149,172,241,178,237,106,80,4,115,49,9,30,1,2,100,164,25,79,122,64,44,201,150,102,214,214,166,63,137,111,101,42,79,240,209,159,227,137,75,77,46,182,4,98,240,51,77,134,114,26,226,36,23,127,183,51,58,109,116,26,168,173,231,16,164,217,243,174,35,88,41,125,42,48,183,214,118,237,241,202,69,185,35,21,210,118,88,59,82,216,102,150,98,159,108,235,34,155,157,115,235,49,224,123,134,2,47,230,80,40,144,225,101,220,199,73,179,80,29,255,240,101,6,112,55,240,192,104,74,150,167,78,108,175,75,167,176,34,57,223,228,151,123,210,206,90,149,96,36,197,248,21,2,211,25,129,239,126,27,49,141,34,121,76,50,191,148,86,123,253,170,204,115,131,120,217,233,112,44,187,98,121,192,5,190,207,156,140,152,169,4,233,206,69,248,94,213,125,221,189,231,183,35,38,114,46,245,215,159,201,235,20,32,6,108,184,61,69,25,65,98,190,215,157,201,235,139,168,218,14,23,87,136,187,167,199,232,228,22,170,151,90,132,38,104,130,251,196,83,103,23,234,53,84,225,156,127,164,68,119,138,166,176,189,185,57,254,33,18,238,51,117,213,163,13,191,110,10,210,239,125,219,82,144,10,43,81,190,151,230,100,16,153,213,1,123,33,148,60,204,61,6,10,189,42,2,165,180,124,94,248,104,97,231,216,84,94,128,196,215,213,214,149,195,138,103,8,172,201,82,132,117,14,26,90,102,83,219,31,185,208,67,192,239,167,161,186,12,38,148,68,164,118,107,214,72,113,200,225,4,206,129,51,248,35,250,73,2,255,15,189,120,188,66,134,164,64,212,83,169,205,27,126,19,115,65,206,2,11,135,222,115,67,19,82,246,53,119,222,180,157,207,95,40,186,119,67,255,236,229,149,215,223,231,207,21,77,122,115,89,52,70,21,83,163,127,153,45,149,249,176,157,53,35,183,170,217,48,55,23,171,245,6,249,71,116,192,253,129,200,103,154,123,187,125,127,188,188,61,35,136,14,244,31,253,78,8,175,9,149,102,148,52,20,87,172,176,31,238,92,132,5,67,15,235,51,166,181,114,142,147,34,76,159,169,109,52,143,229,128,159,116,248,141,159,63,225,234,121,7,70,41,54,81,29,138,36,105,3,252,221,15,177,25,51,213,173,226,181,169,168,197,71,53,86,172,71,131,230,43,12,89,43,1,78,117,142,96,18,53,13,149,174,8,76,7,36,159,180,106,44,110,204,166,237,54,46,168,179,165,96,115,168,148,126,15,196,108,255,56,19,81,111,140,16,13,216,254,222,3,168,87,100,23,165,19,142,227,205,13,76,220,2,35,65,244,153,106,236,100,93,253,139,204,57,20,151,178,71,122,89,121,222,120,33,155,19,16,30,192,101,215,156,218,153,151,193,66,250,216,240,18,35,32,157,128,16,90,105,52,188,81,251,206,148,41,148,60,17,251,242,70,79,237,30,111,134,194,124,59,196,249,200,208,71,57,182,48,170,102,20,53,112,185,75,93,147,153,96,75,176,16,143,37,31,243,117,178,9,172,167,154,130,44,35,44,212,228,96,143,160,132,235,121,82,103,60,73,228,225,173,159,90,179,114,191,234,79,5,165,167,65,181,68,104,6,34,207,201,146,193,246,83,235,253,33,168,217,216,186,185,200,95,190,184,91,141,71,199,100,212,9,139,253,99,212,69,64,37,86,90,5,227,168,245,11,44,243,122,146,120,7,43,237,153,88,8,236,42,188,158,84,22,21,229,223,37,15,94,151,101,174,97,55,237,71,60,163,5,226,138,30,131,253,241,156,218,128,153,175,107,103,39,11,69,222,93,75,187,198,108,214,230,115,239,25,31,68,245,37,43,253,207,175,127,142,131,162,180,77,62,153,83,38,209,76,83,164,62,20,220,192,66,29,70,214,203,129,123,171,45,95,25,53,93,0,151,58,149,201,148,187,177,170,1,199,115,19,16,115,49,191,157,85,3,174,226,175,225,92,96,108,244,42,235,83,48,93,191,130,6,208,20,20,221,178,221,202,215,69,172,11,175,6,73,186,169,52,18,76,134,176,244,181,62,74,21,168,184,114,45,36,216,190,248,49,16,147,5,137,66,115,98,75,250,185,174,136,249,151,92,144,49,11,148,105,138,198,236,2,98,176,212,208,179,27,177,191,60,224,194,74,225,138,70,221,166,39,240,115,186,195,40,182,89,154,81,107,185,71,30,13,3,162,10,198,50,153,131,210,227,71,17,67,235,89,111,66,30,137,208,51,210,166,226,52,216,58,32,190,39,248,190,96,162,249,68,86,80,92,122,142,1,193,186,162,221,61,59,45,112,151,33,157,226,251,130,87,150,223,75,54,46,166,120,233,95,82,191,105,20,46,210,136,68,164,208,224,104,126,205,95,63,224,84,59,138,171,60,251,174,66,164,86,190,110,149,119,101,103,32,189,101,140,242,221,192,100,164,25,154,59,170,77,150,245,84,85,1,99,237,186,250,29,168,157,179,160,76,122,30,3,48,6,180,124,6,1,164,146,141,198,51,180,157,165,189,8,100,73,170,216,143,106,85,195,62,26,165,89,95,221,223,170,65,38,129,35,211,221,97,22,118,255,111,114,44,123,136,35,184,143,51,185,166,4,240,250,117,116,189,205,72,238,170,102,128,2,136,168,4,182,215,80,208,142,249,217,45,88,30,146,24,77,79,118,119,196,77,61,46,248,49,213,127,164,146,227,68,250,210,100,213,193,242,153,176,17,68,113,51,195,95,142,252,144,184,248,94,245,110,29,126,123,88,25,214,47,200,105,188,177,155,26,3,32,48,32,155,97,58,1,208,240,228,133,107,55,101,251,73,202,150,254,191,193,91,14,31,147,36,72,204,0,155,42,72,109,158,181,212,227,191,112,52,221,129,43,75,170,51,247,98,107,209,216,38,128,216,201,195,32,79,232,185,115,153,255,242,77,169,9,176,166,94,193,179,159,46,69,223,55,35,246,31,51,115,218,197,241,36,23,196,18,97,25,145,57,167,27,151,232,40,224,79,223,23,232,4,118,247,248,191,246,141,116,29,235,54,93,143,5,47,204,92,54,251,177,207,4,135,204,135,255,107,105,175,132,240,93,24,182,64,54,113,36,74,194,212,16,42,144,142,192,83,178,210,177,150,154,128,138,124,78,43,76,32,76,41,228,32,15,26,146,251,19,12,12,164,184,179,37,183,149,78,202,158,56,98,245,8,147,234,171,10,130,226,142,239,113,27,229,240,184,12,109,110,51,184,110,137,69,97,110,246,173,194,148,144,222,146,96,136,91,124,90,80,32,70,245,220,107,49,215,48,29,201,214,141,1,224,68,69,50,12,66,56,124,202,139,19,134,254,8,29,235,3,92,4,209,207,176,124,33,251,151,61,74,6,29,242,57,4,205,213,252,203,213,56,64,185,41,26,134,76,47,141,178,49,153,70,81,40,251,29,179,233,43,214,233,215,67,64,114,133,229,193,101,126,59,253,235,138,151,106,196,116,138,62,120,46,79,186,131,229,34,248,64,91,191,174,67,135,50,134,198,172,6,139,199,83,236,50,171,200,208,220,191,247,128,103,209,95,55,168,144,91,146,145,181,236,64,43,145,213,213,187,64,160,166,188,210,10,13,244,0,30,36,113,136,194,38,207,141,140,100,156,254,85,89,84,131,243,168,61,138,31,11,115,231,108,197,157,121,30,176,102,127,226,12,107,138,168,159,205,253,81,114,225,142,43,254,19,57,221,42,171,92,196,107,253,62,90,173,45,153,142,239,94,111,226,112,237,13,223,117,65,244,57,236,64,195,36,138,236,217,82,224,43,68,243,243,44,66,194,37,204,114,122,213,93,84,28,23,90,205,83,104,207,42,237,240,42,124,158,55,32,245,223,20,70,189,230,243,136,13,70,235,48,135,150,126,21,84,107,28,80,84,169,230,100,249,128,3,208,186,28,61,220,42,200,215,139,37,128,51,15,46,149,238,7,138,239,159,151,156,149,55,0,122,78,2,148,94,36,95,171,197,200,114,27,86,185,0,197,141,213,138,159,7,236,148,240,217,158,52,115,169,86,132,113,32,252,45,222,222,47,174,228,83,2,88,44,168,101,197,4,117,133,28,31,63,254,114,66,167,214,220,120,233,147,129,137,114,95,51,15,49,26,7,36,123,168,211,152,223,177,66,99,233,7,77,248,33,203,148,250,235,128,58,6,246,29,100,90,138,233,230,122,185,236,97,182,220,186,125,240,19,52,231,239,191,85,249,202,250,171,189,167,75,187,193,109,9,58,137,13,144,113,40,139,195,68,243,34,31,109,160,183,139,198,127,70,154,253,243,28,205,27,63,205,196,91,42,37,74,238,226,138,117,146,145,232,201,164,100,9,211,136,26,25,235,105,93,241,26,196,161,83,19,27,223,100,135,32,215,208,254,20,127,98,40,58,103,136,152,238,185,61,63,145,195,13,155,97,213,232,93,207,89,228,169,145,143,47,113,166,139,220,149,42,151,250,150,201,6,155,5,169,62,4,195,91,174,71,243,147,180,119,0,239,152,44,15,88,37,25,94,21,202,175,98,154,226,175,183,31,174,52,136,203,202,189,42,177,50,192,98,87,149,87,144,206,186,245,19,33,87,45,79,221,111,70,226,215,29,162,195,0,12,43,31,2,17,239,76,192,20,183,146,8,180,224,215,30,177,217,124,245,21,186,148,151,144,46,170,223,207,122,61,76,95,255,14,110,13,214,137,189,223,61,77,243,225,220,86,14,230,173,176,39,58,62,211,147,21,11,166,210,143,205,134,153,228,80,206,77,255,4,58,199,211,214,241,5,214,230,217,209,32,152,132,43,180,85,103,78,8,58,92,153,94,252,183,22,254,144,253,143,61,32,24,108,167,55,123,25,74,95,226,197,158,209,35,228,247,200,206,246,42,55,254,202,32,174,23,117,91,57,43,99,175,63,16,188,175,191,25,48,199,126,38,246,235,129,174,150,45,96,234,95,39,125,165,164,248,156,138,2,102,62,98,69,86,19,105,43,134,136,36,138,218,141,20,190,69,19,180,39,194,16,253,110,6,206,249,245,75,153,141,166,240,62,211,7,130,212,88,47,153,84,78,132,42,253,160,137,17,105,134,199,205,179,91,250,86,221,67,53,176,45,234,114,142,82,51,102,82,201,97,205,116,12,248,242,36,67,254,253,240,29,118,148,169,244,55,159,151,197,73,224,113,39,108,29,61,48,148,123,0,156,112,136,51,156,137,124,176,202,188,84,185,94,126,26,197,75,85,152,95,150,45,66,99,149,194,30,173,244,132,250,174,72,134,50,108,122,127,60,37,240,147,242,128,187,110,15,67,69,193,152,29,75,169,70,190,3,97,136,176,143,4,208,173,103,161,189,108,69,237,127,87,78,108,4,2,215,76,91,243,51,99,193,232,181,213,39,184,242,238,168,15,75,127,128,68,151,21,73,220,207,98,81,113,251,213,242,92,7,219,182,203,123,34,163,178,73,240,152,21,83,116,87,60,5,22,116,136,232,105,216,126,185,193,222,79,118,17,75,246,196,28,16,13,181,230,213,213,83,174,129,202,29,224,37,179,46,226,86,228,99,175,78,9,143,200,188,150,246,237,227,179,106,134,5,28,198,195,22,243,242,195,8,173,101,95,165,40,247,136,188,219,147,245,143,67,171,137,233,89,201,67,86,206,89,207,105,224,126,26,115,150,246,127,184,173,177,26,255,199,99,241,243,112,21,51,153,9,117,57,99,68,145,217,46,190,216,56,100,131,93,98,39,72,49,239,184,97,39,75,214,135,179,172,219,126,143,231,12,43,154,9,57,230,210,109,79,179,47,95,64,101,48,89,118,67,190,74,187,227,97,193,28,224,121,44,226,170,29,18,164,96,208,79,8,249,77,108,187,157,151,228,9,85,246,220,102,208,45,167,114,189,243,189,90,57,83,28,43,251,169,82,154,134,61,147,140,215,214,42,175,126,173,50,189,81,23,19,219,212,195,126,2,238,71,33,109,10,28,210,194,175,245,109,194,43,135,102,181,233,21,57,53,173,32,99,43,37,8,101,81,35,213,150,242,156,96,172,160,174,96,116,118,97,124,220,166,93,149,155,149,127,226,168,118,32,158,59,19,186,172,36,38,175,162,241,178,40,45,220,1,201,26,75,89,115,172,99,189,88,239,169,45,195,150,43,73,28,158,66,157,62,217,241,105,242,193,235,173,144,4,108,33,74,44,43,41,127,65,59,172,165,126,133,11,157,60,0,180,91,9,190,66,118,227,252,39,167,75,237,97,142,180,184,160,235,217,233,21,243,45,35,117,255,166,160,93,63,71,52,73,211,40,191,235,213,51,80,76,99,157,152,86,126,187,163,47,132,64,111,154,32,94,23,182,38,95,216,41,37,149,45,85,149,222,91,54,221,206,193,44,122,135,158,220,178,40,134,41,145,110,177,223,51,152,44,213,148,106,72,75,134,1,221,213,113,165,116,187,168,214,60,132,154,245,106,3,230,94,0,63,127,51,80,230,222,243,91,247,114,127,238,110,147,56,204,98,125,165,88,29,84,3,89,15,175,8,178,251,54,198,21,44,73,71,209,184,100,153,22,207,224,249,66,100,89,48,136,46,49,66,42,152,49,93,203,237,85,249,21,107,42,155,224,149,217,141,94,113,186,167,186,21,57,99,37,237,53,21,25,197,101,233,109,219,157,57,186,97,197,72,130,184,205,89,107,221,235,154,15,73,126,217,6,11,187,19,5,35,220,37,146,64,108,88,195,167,15,166,50,208,204,106,95,15,97,209,214,49,230,40,105,232,101,180,171,46,87,133,190,223,243,183,61,137,193,216,251,26,231,137,248,89,115,167,47,60,4,128,105,239,73,137,253,155,83,47,48,107,43,99,49,132,35,213,137,9,238,190,130,112,230,19,245,134,192,0,119,179,241,180,102,145,129,185,46,222,174,134,166,92,86,251,250,193,78,42,108,107,45,153,126,81,250,32,195,194,18,74,58,161,146,3,144,17,16,120,208,21,125,113,119,90,153,198,186,65,202,248,40,81,9,120,31,133,75,3,230,250,11,232,36,36,153,72,24,21,52,112,68,169,118,246,61,92,247,40,143,46,93,89,154,4,161,87,4,213,227,53,126,164,112,125,154,167,183,6,187,147,54,17,160,213,13,192,82,30,21,128,189,44,253,175,191,110,56,108,119,164,48,248,11,129,139,162,123,88,2,5,157,57,13,252,191,186,68,65,80,46,224,31,229,70,135,203,39,188,121,64,81,235,81,129,70,107,136,220,219,7,195,136,38,139,120,28,19,226,5,24,167,244,2,229,190,4,175,188,53,206,169,91,196,47,93,196,44,58,1,113,48,68,203,113,154,213,116,228,91,55,247,37,40,16,94,64,231,8,65,77,217,166,170,63,24,88,156,211,36,183,51,134,153,227,14,107,141,128,76,166,218,19,136,37,124,14,220,189,19,172,79,208,186,90,18,232,233,36,62,67,105,177,93,169,154,94,232,166,161,81,245,227,23,214,254,10,43,62,114,86,167,4,87,126,140,100,103,222,244,245,55,236,8,214,226,8,131,170,76,105,36,125,135,85,240,125,159,208,22,124,35,211,60,239,115,31,66,205,202,20,58,206,222,9,220,115,74,240,102,12,22,196,109,228,44,62,164,252,51,242,159,78,97,182,143,222,250,23,221,89,141,14,11,230,112,246,4,123,57,216,245,34,114,11,153,119,141,102,212,61,213,75,54,47,16,81,26,94,135,56,180,171,228,249,211,46,174,217,143,111,103,183,46,51,91,11,229,21,136,68,108,226,211,251,254,86,73,197,194,150,182,24,62,169,147,45,100,86,204,201,13,148,23,174,110,213,117,120,87,17,218,22,4,235,170,251,22,208,2,240,54,146,98,45,121,125,6,83,34,107,5,178,123,125,233,0,11,131,58,182,170,171,141,204,8,193,4,243,52,25,143,62,175,205,227,1,179,223,115,26,27,73,73,190,251,102,100,115,125,123,164,143,190,2,80,207,197,21,29,241,105,223,148,187,85,220,233,107,187,189,124,234,155,204,186,55,243,177,218,21,81,123,23,153,12,108,225,176,46,89,232,245,175,192,11,73,97,150,192,38,46,201,226,111,246,215,11,189,39,102,7,245,185,99,248,206,200,43,32,86,134,19,53,152,142,202,63,56,36,221,41,218,103,72,11,119,142,180,10,51,81,29,185,103,79,255,14,22,222,176,99,190,174,92,121,85,250,253,131,223,230,194,62,107,67,34,229,76,213,91,164,210,182,65,36,155,55,118,97,56,218,238,66,140,217,220,238,169,184,11,6,67,152,37,95,98,195,245,237,165,0,93,46,131,129,55,93,132,232,56,182,221,71,1,222,44,24,157,204,125,20,195,57,107,207,23,203,239,42,105,113,117,46,118,70,118,66,159,141,205,157,46,240,145,178,234,24,113,141,151,163,14,167,223,133,33,30,139,84,220,120,50,173,31,216,219,154,121,249,244,126,64,112,114,77,213,27,120,3,146,158,228,35,114,170,198,207,254,165,229,141,124,219,69,56,228,24,232,90,212,91,14,122,79,84,224,238,112,6,241,43,14,20,63,26,180,73,100,65,172,118,185,237,216,11,10,187,205,44,39,106,121,255,214,90,77,238,155,95,153,109,126,3,108,25,174,184,165,228,176,166,131,93,5,68,0,181,162,252,50,65,9,166,122,214,218,105,230,250,235,82,81,97,117,116,157,41,123,208,210,160,0,45,37,204,132,193,99,86,118,100,93,249,32,3,19,171,76,139,102,27,144,120,38,20,9,148,147,190,89,116,114,159,177,147,120,117,184,42,234,209,61,58,198,174,80,34,103,206,135,230,252,50,205,48,128,229,222,9,33,20,117,210,233,178,63,136,70,118,246,149,142,41,201,59,205,160,24,131,82,104,143,66,13,183,57,67,37,117,81,157,184,233,175,240,65,34,253,132,74,152,128,101,194,83,29,68,45,213,92,210,134,212,75,158,112,70,209,72,230,224,126,29,145,232,236,3,67,247,244,21,178,120,238,198,227,175,111,220,196,102,114,154,11,45,18,42,108,253,88,62,77,145,138,84,79,117,197,196,156,66,140,157,245,87,121,177,27,109,171,12,125,182,190,78,216,53,158,176,5,88,70,211,54,183,168,197,234,122,132,186,89,192,227,246,83,124,12,111,205,87,70,78,30,160,192,243,108,26,242,63,201,172,214,126,133,52,70,189,64,195,99,51,108,231,77,214,19,72,147,55,199,103,246,148,165,171,203,22,171,43,174,76,11,5,37,229,146,70,187,245,191,248,205,180,148,253,158,96,77,66,237,115,253,111,136,167,4,155,100,134,126,165,204,141,246,183,30,1,32,86,111,79,179,68,171,54,151,176,177,105,128,255,202,43,183,88,193,159,192,103,91,119,152,2,18,67,250,60,100,201,236,253,232,246,106,59,35,5,65,101,237,75,158,22,78,251,42,219,136,125,79,229,211,177,18,77,15,155,148,217,11,195,220,175,219,33,157,5,222,244,150,244,131,28,46,148,142,184,68,139,63,40,249,77,68,9,55,248,196,208,175,106,49,151,210,243,52,184,9,254,134,140,88,47,188,39,235,9,18,46,226,180,8,211,232,127,155,24,46,74,147,195,1,138,146,190,141,116,73,191,128,139,142,197,144,206,145,120,246,17,118,22,70,127,93,233,204,201,183,166,9,98,20,45,13,177,82,2,129,145,197,245,98,32,122,223,149,125,139,40,247,69,246,153,11,228,39,151,44,133,114,31,52,5,191,192,25,63,201,74,145,44,236,177,111,67,153,0,216,78,237,25,2,212,134,251,14,79,172,227,10,59,60,170,176,158,24,19,184,34,80,52,23,139,244,126,110,55,184,205,174,92,3,240,167,212,8,225,136,167,100,210,59,112,156,144,141,40,66,175,234,243,179,73,59,160,23,255,193,2,10,205,77,68,160,213,96,118,167,16,64,253,215,111,177,56,95,44,205,171,127,71,34,184,240,239,157,213,253,146,155,88,173,52,8,66,19,150,10,32,208,10,223,79,171,119,179,143,250,146,189,250,193,50,52,186,42,53,233,85,26,32,218,75,72,71,190,39,242,163,109,180,15,18,31,130,49,117,133,2,178,194,155,177,103,248,27,204,27,173,83,10,240,207,216,142,33,48,220,182,11,119,40,133,223,208,10,195,204,134,168,220,72,149,71,232,200,65,30,201,37,232,34,52,81,123,117,158,242,181,175,3,93,235,172,125,4,125,115,123,237,168,221,146,153,16,55,229,66,149,21,215,244,209,223,214,155,223,174,13,242,68,0,71,88,57,45,139,99,211,99,239,10,55,147,192,207,5,254,234,130,179,74,185,189,237,140,89,76,117,31,197,255,160,125,131,36,220,200,222,23,7,247,51,191,73,253,90,53,159,61,152,128,146,26,30,182,73,132,119,136,199,174,202,125,122,5,253,223,183,186,44,247,213,122,187,7,66,11,236,210,155,87,53,250,10,251,169,107,204,200,239,134,32,236,86,186,226,46,11,68,130,88,114,39,111,168,55,40,78,5,51,158,182,1,133,150,213,39,143,147,41,253,193,96,179,109,14,227,104,204,110,94,213,214,216,5,147,73,113,186,243,22,219,160,116,166,202,135,19,235,120,52,57,182,118,227,144,174,91,196,76,86,147,79,177,213,239,141,144,53,225,44,102,160,141,91,214,250,232,232,213,45,227,255,18,147,126,109,75,186,187,83,144,89,42,22,42,195,0,58,118,87,121,96,197,166,216,114,202,61,120,174,43,69,51,0,179,143,148,27,248,135,57,83,195,152,118,226,148,39,251,25,26,166,130,67,224,183,161,172,189,157,44,161,47,149,127,131,123,246,143,121,173,7,208,82,25,41,176,198,212,195,143,219,164,74,129,88,46,63,115,109,137,204,202,245,145,94,70,19,206,41,24,93,234,236,246,130,223,230,153,43,117,18,253,109,210,250,90,123,77,250,154,245,135,25,123,80,209,181,143,177,18,161,153,108,145,74,4,104,4,237,106,217,20,208,139,204,97,72,210,250,137,130,88,208,153,254,116,150,57,194,241,93,247,222,147,124,74,239,56,134,134,153,226,198,47,52,201,205,125,153,27,116,40,168,136,235,154,74,162,254,132,84,52,103,188,122,20,182,90,225,231,179,237,29,230,108,217,7,85,227,18,73,68,119,170,5,254,204,175,205,115,34,126,191,138,18,0,97,135,26,141,114,8,125,225,218,131,119,206,192,67,219,208,30,254,193,41,224,223,47,8,105,67,148,80,211,52,110,165,69,140,167,168,27,254,143,159,158,89,64,78,155,50,15,23,50,98,115,143,58,191,238,170,86,23,228,178,173,25,183,203,193,109,184,209,146,250,18,104,51,214,242,88,21,7,156,134,114,144,30,233,40,252,109,111,226,191,218,35,195,31,133,48,120,65,28,19,102,249,114,139,211,242,105,130,220,197,116,58,157,209,51,218,19,30,147,138,16,190,77,12,179,4,68,87,77,139,166,103,245,89,26,234,108,66,181,224,28,177,245,253,102,61,36,10,148,10,76,20,115,165,1,244,38,170,0,94,232,177,94,251,222,200,184,126,54,32,240,200,185,101,210,244,169,140,36,220,115,160,149,231,73,47,40,5,15,227,99,74,199,204,154,51,214,60,148,137,227,124,69,144,4,48,117,167,58,131,71,61,58,198,226,172,88,43,226,7,72,196,182,104,8,245,79,225,253,221,253,129,240,3,78,186,2,141,143,113,162,240,132,235,243,113,3,22,79,215,43,76,56,7,50,75,236,125,230,188,117,155,129,26,34,152,119,229,94,247,206,199,20,22,248,72,6,59,52,124,187,59,160,163,154,221,246,207,80,84,56,94,40,87,70,210,18,60,83,207,69,156,151,86,70,235,132,72,27,123,101,21,1,154,114,129,221,253,111,130,89,13,240,223,50,48,18,197,79,162,65,122,80,178,180,88,193,224,251,182,180,75,224,223,25,148,88,132,4,115,219,110,130,212,46,87,235,170,230,233,106,35,131,179,94,148,154,33,187,128,221,1,96,237,105,186,195,61,16,121,206,210,172,224,30,142,124,89,153,124,17,136,96,198,29,215,182,243,122,203,128,154,125,53,204,78,119,100,85,28,171,185,242,182,201,233,247,194,145,9,46,192,216,89,55,222,39,127,215,142,208,197,77,247,191,13,119,172,93,124,232,111,234,148,125,21,21,153,99,60,28,95,104,243,48,94,208,241,213,227,246,217,64,130,18,1,139,160,77,134,252,156,153,68,9,232,178,226,1,146,125,197,160,51,242,190,92,82,231,62,56,93,9,109,81,195,108,172,212,236,237,71,148,66,45,43,93,166,189,243,172,131,183,97,236,112,6,12,29,152,218,157,155,201,153,154,137,9,63,120,50,57,151,160,32,216,132,62,182,14,114,73,121,80,98,159,121,78,189,241,194,110,253,78,143,191,90,111,180,32,142,238,73,195,139,76,3,91,193,72,61,175,202,175,149,66,122,227,222,232,225,236,67,194,213,233,32,75,47,87,37,144,73,200,150,16,140,163,190,138,242,89,44,203,232,41,97,37,73,29,255,89,75,231,38,246,222,177,173,135,188,151,176,55,114,44,184,59,33,27,77,112,221,37,242,13,200,113,140,12,71,33,117,122,127,15,18,192,127,63,118,206,52,135,76,81,93,94,244,231,99,87,143,231,186,136,43,170,250,235,64,149,152,62,235,12,46,144,41,95,111,120,95,140,186,144,8,188,230,128,112,117,217,7,220,6,164,66,187,136,8,8,206,71,171,233,21,21,80,92,22,151,228,99,133,93,2,171,232,218,188,173,214,191,222,43,75,83,248,122,233,16,186,137,15,57,94,62,126,44,91,250,74,205,34,122,139,75,239,0,165,151,17,225,92,133,60,32,4,222,207,45,179,73,172,185,245,31,32,187,62,40,2,139,110,172,132,48,117,212,228,7,40,9,78,51,170,113,2,102,154,231,193,72,33,231,23,12,35,81,27,2,126,149,136,127,225,139,87,255,117,26,246,228,29,32,203,133,163,169,116,108,142,204,86,180,76,123,220,112,186,9,153,63,110,187,74,198,242,78,44,245,21,3,31,155,192,237,113,90,164,85,209,36,2,87,40,32,86,17,43,73,92,240,92,212,27,136,71,181,165,42,252,127,33,104,237,211,210,33,166,218,159,252,185,10,106,70,105,87,194,124,53,59,203,252,178,62,167,199,178,189,195,43,102,186,21,202,254,43,75,9,45,198,227,193,17,130,140,22,200,52,171,62,46,26,107,158,157,217,184,156,71,200,202,253,48,148,23,221,120,150,190,219,10,21,79,10,2,39,108,51,75,146,119,255,21,131,248,77,18,219,37,217,172,213,11,164,199,8,165,187,59,62,45,218,58,121,4,123,216,104,160,66,177,70,77,168,60,151,41,29,245,18,22,206,224,77,92,91,16,11,68,93,72,189,201,77,156,242,209,181,228,57,65,196,50,162,115,11,212,143,144,4,253,56,220,197,46,122,180,191,8,52,91,7,181,3,77,116,141,115,100,186,11,130,54,154,138,50,20,239,14,63,169,221,44,136,46,31,82,182,42,213,118,59,211,3,59,33,44,72,232,217,37,238,226,183,154,99,155,190,150,18,169,88,31,197,106,245,2,145,223,151,76,250,252,251,56,116,100,100,248,23,237,116,222,135,232,177,33,166,70,96,52,170,133,64,44,26,190,147,144,87,164,183,237,243,5,7,102,118,10,109,196,82,151,102,190,188,177,206,169,30,52,89,164,207,36,251,22,176,152,145,14,236,144,156,230,86,232,231,254,1,145,227,180,194,61,244,141,3,225,176,83,174,143,57,132,230,69,148,143,1,23,93,219,117,223,51,28,155,220,108,36,68,33,55,51,15,73,115,160,214,225,112,113,193,1,22,211,69,30,45,50,152,24,235,254,176,66,148,83,198,187,150,88,117,143,178,196,222,108,1,148,233,69,82,193,81,199,132,150,163,152,111,100,133,162,134,65,24,153,240,106,11,60,139,217,26,127,71,173,61,242,81,239,228,167,59,28,154,125,132,161,124,15,193,172,153,112,40,65,55,249,188,120,21,71,113,43,165,131,78,117,140,210,6,40,119,127,168,124,86,164,255,56,239,216,28,177,26,241,185,192,114,173,205,103,174,155,102,188,227,214,128,0,108,208,122,190,182,98,218,223,136,237,218,139,16,94,33,238,2,120,92,1,24,57,241,193,172,148,53,151,227,76,8,21,89,60,49,215,75,144,250,117,181,85,75,161,192,152,56,42,237,75,168,144,87,50,202,79,105,233,112,249,221,217,12,24,76,3,88,57,53,163,45,194,18,85,48,123,220,122,96,56,200,218,135,97,165,188,171,74,3,59,54,146,45,191,26,167,38,205,52,45,168,39,99,202,127,137,53,183,64,180,200,166,186,36,103,76,35,178,153,99,30,202,158,192,216,243,55,75,181,86,101,131,169,84,103,170,16,107,165,97,127,87,86,49,38,13,81,98,206,251,71,166,255,142,63,166,10,49,42,45,201,50,152,68,52,184,110,247,80,69,180,52,10,251,21,22,127,45,122,251,116,75,77,180,241,171,146,106,246,186,162,239,40,202,224,120,126,113,217,57,234,34,78,15,125,120,86,13,47,82,223,141,244,52,197,67,244,71,155,0,143,160,3,225,64,218,22,136,108,127,193,218,149,77,117,232,154,155,69,91,224,52,219,38,143,24,27,134,228,7,5,166,209,213,90,117,163,44,175,204,105,47,51,237,151,73,72,134,42,115,92,21,41,139,210,56,58,129,10,141,35,57,59,237,6,200,85,192,95,94,163,153,225,12,129,196,58,250,47,31,176,164,101,7,186,54,110,170,8,119,41,38,117,176,194,45,12,208,56,227,160,59,138,38,131,105,81,92,157,64,75,42,111,171,233,230,244,52,12,52,161,228,94,218,72,156,148,160,135,130,220,6,150,201,138,12,54,136,10,59,11,124,5,61,108,118,146,166,174,224,197,143,94,251,69,145,113,11,223,58,34,86,55,43,196,59,4,233,195,77,252,77,238,228,46,102,172,99,172,130,152,18,186,37,212,154,229,102,231,21,105,201,60,152,189,43,210,147,205,111,217,106,195,246,81,37,248,56,103,168,57,238,176,123,92,10,153,98,70,51,13,224,184,230,151,155,188,243,194,71,137,190,53,113,132,119,80,184,53,3,137,248,208,140,176,38,26,79,103,126,8,78,33,230,177,250,58,187,210,191,76,11,88,220,171,148,114,50,178,100,171,71,50,253,216,3,219,134,207,225,29,24,114,187,118,51,184,14,222,190,22,87,100,236,53,207,116,0,242,42,167,15,47,215,204,23,21,215,218,211,92,178,78,230,166,64,157,17,136,148,214,8,33,191,243,203,234,205,151,244,228,15,233,169,105,197,198,71,121,202,1,200,45,213,80,156,59,61,163,107,250,186,179,170,246,237,102,19,10,145,14,1,130,166,147,141,174,2,243,123,210,101,190,237,103,97,153,220,172,166,81,2,237,165,108,75,50,58,97,176,64,60,177,24,86,198,156,72,248,73,25,171,231,205,22,186,0,248,103,246,131,104,69,75,174,54,79,254,62,47,201,215,202,132,188,17,241,160,186,78,71,188,102,148,100,204,42,159,210,248,196,185,48,27,22,16,134,86,96,67,88,168,231,89,40,221,103,30,215,99,40,69,253,169,53,88,199,225,41,227,145,174,245,248,175,16,128,84,139,171,13,173,61,225,164,203,243,225,236,168,227,212,49,108,218,27,45,79,88,16,195,71,77,222,110,119,216,218,232,66,189,166,154,197,146,56,90,142,250,146,41,138,247,183,104,34,11,246,115,139,64,123,32,228,184,205,233,231,149,231,115,223,119,107,169,248,229,36,173,187,223,130,80,163,156,65,46,86,90,108,56,59,225,139,198,59,175,239,52,77,173,222,159,157,51,171,80,134,53,229,68,32,14,113,37,180,250,90,63,105,188,27,70,33,88,178,251,78,42,240,225,66,73,135,104,50,147,206,21,246,151,64,163,228,166,122,235,249,49,38,215,127,233,238,90,88,88,220,61,220,103,168,155,73,146,14,4,184,27,75,64,33,114,208,149,130,118,56,184,89,12,202,213,194,132,221,185,102,94,29,50,0,248,69,59,87,242,174,163,179,206,169,46,176,41,90,0,226,219,20,176,153,202,237,51,81,161,110,247,242,34,183,22,129,90,8,57,214,238,224,3,136,210,208,43,36,100,76,88,38,126,157,89,231,58,172,9,243,221,4,224,58,31,6,214,125,80,121,114,44,201,3,188,98,57,10,81,185,129,115,67,240,174,46,129,219,140,203,10,40,48,156,130,54,131,134,211,248,43,223,61,245,50,75,210,231,145,125,124,150,253,178,104,104,190,151,196,126,34,225,144,50,48,249,140,46,222,5,211,7,232,103,30,176,74,148,167,4,101,65,157,127,26,51,19,61,177,28,126,231,117,168,238,166,148,199,105,233,195,74,77,27,205,53,217,179,110,135,222,133,186,42,159,203,152,81,235,219,74,191,16,70,204,193,11,126,156,106,14,226,100,151,22,191,193,12,249,10,26,180,177,197,159,92,5,144,225,32,148,41,193,166,129,151,137,167,39,130,48,188,65,119,16,139,130,186,77,212,225,27,202,30,5,67,163,237,126,236,93,239,144,139,117,73,93,99,91,27,153,20,40,253,146,116,136,131,103,8,134,98,255,55,45,243,225,189,33,40,133,166,8,51,79,214,80,207,88,34,223,253,146,16,252,22,63,239,147,111,202,143,179,242,30,65,208,84,88,67,205,4,144,4,185,204,176,240,94,137,8,107,36,152,53,232,151,176,188,213,183,32,45,180,20,146,241,32,213,220,157,109,210,163,102,20,8,95,144,72,95,68,195,213,34,119,96,237,60,221,171,229,245,131,35,23,186,199,75,139,32,236,104,112,27,202,230,50,73,162,160,251,172,181,36,216,220,216,201,69,205,111,186,100,146,165,15,233,225,28,21,17,165,122,29,197,218,54,65,83,186,13,215,147,19,245,223,136,206,225,34,126,32,50,14,59,194,187,242,254,173,130,190,94,147,2,186,252,109,15,228,120,226,116,111,64,118,241,141,12,53,100,241,12,231,57,110,170,210,184,9,151,140,121,46,39,187,82,88,150,6,238,236,243,255,212,204,213,92,184,74,24,218,144,75,242,219,198,148,243,128,11,28,78,234,126,35,124,106,150,186,215,108,195,200,127,250,97,204,40,202,161,9,149,144,131,29,232,80,94,237,40,244,213,253,118,137,163,56,193,222,120,45,164,177,181,241,96,113,198,142,130,105,8,244,200,143,174,198,118,205,132,40,1,110,171,95,74,118,246,73,134,50,4,106,118,45,170,246,32,63,157,255,183,91,63,184,208,106,176,18,147,143,220,103,154,240,92,254,216,222,72,208,63,241,57,136,165,30,117,6,205,84,190,71,15,61,240,112,46,113,104,63,224,201,157,153,135,90,236,219,167,116,217,1,47,207,208,35,13,228,73,133,218,32,36,135,191,231,13,10,97,248,89,3,255,4,132,139,174,49,213,192,82,56,180,70,117,219,79,244,129,85,216,250,207,75,186,135,112,115,60,8,51,142,207,123,158,185,127,254,163,150,71,8,101,27,76,146,224,109,27,12,135,60,50,81,231,27,135,28,85,226,33,208,99,166,209,164,106,16,108,140,234,184,73,106,156,191,85,91,46,5,147,222,25,71,18,51,251,64,39,224,31,136,201,55,112,94,4,27,65,29,62,101,137,107,149,45,240,151,94,62,154,28,108,38,4,49,241,172,35,213,170,243,255,48,6,110,79,177,27,217,192,165,175,155,239,81,172,171,121,94,72,139,84,71,254,84,22,45,119,59,106,3,253,213,148,75,217,242,243,218,92,13,167,176,19,42,63,102,169,123,44,53,51,145,176,243,204,166,146,24,89,53,199,37,35,73,97,188,9,253,177,117,76,176,241,87,239,46,41,69,128,148,60,196,35,100,121,20,163,91,72,12,33,156,128,164,173,219,31,92,140,61,43,135,95,158,159,18,108,191,184,147,129,72,62,49,114,227,29,21,172,48,193,3,56,64,77,112,98,177,75,198,33,38,2,246,58,44,94,98,21,169,80,90,99,128,189,146,101,50,108,31,123,68,42,91,43,92,108,141,178,162,123,134,240,243,219,17,40,226,201,156,2,42,48,110,113,83,132,99,165,240,104,15,162,248,112,57,90,176,112,200,210,36,199,228,141,255,219,86,53,243,158,84,51,63,169,11,105,73,130,228,168,255,19,222,130,231,205,23,35,236,244,230,87,49,90,66,1,97,3,23,43,86,103,35,87,174,99,141,174,183,154,192,43,58,254,252,67,32,49,104,206,204,202,10,102,240,87,199,109,58,192,156,170,109,81,157,202,81,161,189,1,99,9,25,10,45,52,206,68,255,50,155,213,155,166,108,255,90,169,108,135,78,62,134,210,145,255,144,118,58,163,31,98,144,19,51,218,224,25,209,21,53,75,194,46,161,88,172,156,179,213,79,61,116,212,223,222,49,22,184,248,209,64,177,150,232,187,251,219,172,221,3,133,87,95,127,142,39,75,31,212,32,212,210,52,195,175,198,113,192,153,126,62,14,186,81,202,226,179,152,255,91,24,0,232,75,19,89,86,158,59,158,29,168,169,5,50,82,211,114,46,119,223,86,39,245,112,154,136,6,130,34,235,46,94,226,121,37,202,207,86,103,19,93,202,224,148,10,246,141,121,165,151,107,104,5,124,199,255,4,126,131,169,73,229,3,45,22,29,53,169,199,221,164,21,165,139,85,201,62,35,42,17,74,137,139,27,50,84,178,118,68,97,55,183,22,128,212,64,142,47,49,9,105,255,58,78,217,21,121,248,250,57,132,42,69,71,154,11,185,76,113,218,113,129,74,174,218,10,232,116,82,110,228,29,103,157,247,33,226,246,0,70,149,71,197,136,155,47,54,229,239,25,7,227,229,93,44,81,70,214,41,134,86,33,201,176,185,81,103,249,223,33,167,250,206,205,224,120,234,147,5,57,49,89,188,96,65,98,148,163,0,189,155,200,245,243,217,204,188,89,249,178,29,129,66,11,31,17,68,170,208,64,47,20,131,253,217,234,34,115,235,230,23,20,63,66,192,47,88,129,162,21,168,185,43,173,97,163,201,205,32,97,189,133,152,4,39,99,23,242,145,204,165,223,144,79,144,86,111,43,16,131,92,39,111,174,192,10,178,30,107,36,211,201,11,93,15,172,106,252,89,104,35,33,3,8,226,132,5,191,15,139,163,107,74,115,226,200,247,234,127,174,156,41,152,245,159,86,78,28,159,206,144,0,97,29,243,34,67,187,1,230,132,65,41,157,254,131,68,168,22,182,95,107,37,111,249,252,219,141,226,192,42,208,86,202,67,100,58,42,64,171,150,163,95,172,182,5,173,78,151,224,156,9,255,17,209,168,198,185,18,244,46,236,186,28,51,4,151,58,128,34,68,215,116,93,70,137,105,39,172,50,72,51,57,39,221,165,222,116,171,213,3,8,77,181,17,198,76,67,63,220,119,43,66,212,176,161,176,109,132,94,19,68,156,50,5,87,68,161,221,123,74,184,224,192,24,213,255,39,12,193,50,89,56,44,234,162,19,134,106,192,185,253,150,71,40,78,136,113,21,253,4,121,68,78,35,255,38,95,219,193,185,31,152,36,62,40,143,161,217,65,23,33,94,200,83,39,94,131,211,245,151,108,228,41,222,79,77,0,134,119,64,123,196,233,226,120,119,74,188,28,33,152,134,181,201,220,1,185,193,27,129,52,82,95,4,175,9,37,51,157,4,41,58,84,84,160,108,153,155,241,140,40,183,185,195,208,126,89,250,148,219,120,119,219,236,50,10,135,179,192,131,170,74,235,246,114,19,73,232,236,177,181,240,15,32,85,72,39,233,57,121,193,30,39,217,51,86,238,151,142,9,124,41,47,57,39,170,226,51,182,198,144,81,145,77,87,205,176,72,113,186,140,213,105,189,103,167,41,73,197,104,227,137,206,135,77,43,66,239,239,91,88,202,212,10,45,80,170,143,231,227,37,139,223,195,198,29,122,114,8,88,59,131,112,22,158,136,90,215,38,4,163,67,221,255,238,214,234,30,184,51,50,221,9,7,127,152,2,153,178,185,54,177,237,43,120,67,184,3,79,253,125,103,219,8,219,98,7,87,219,232,174,201,4,17,230,63,207,97,197,156,82,188,31,133,38,116,98,255,245,233,169,19,132,217,128,93,192,105,118,120,249,175,131,156,23,178,66,209,212,104,215,119,102,90,50,127,126,181,51,25,223,105,116,42,247,204,148,64,232,15,9,119,231,188,17,226,162,254,27,233,22,180,241,145,242,220,64,82,127,93,116,108,52,108,246,155,25,224,178,244,211,123,159,43,193,238,144,120,174,236,232,253,176,31,145,190,0,206,195,38,29,1,167,35,145,121,184,24,144,194,62,244,110,72,123,140,4,124,53,66,198,167,13,33,90,184,182,16,141,99,82,189,174,243,229,126,4,67,19,120,8,206,125,107,167,155,133,162,90,18,218,187,228,85,9,43,41,11,202,96,70,36,251,46,74,235,140,126,72,173,202,139,203,202,97,20,4,225,163,13,62,194,189,25,224,100,214,21,231,185,255,147,31,60,162,236,73,119,44,250,162,199,219,92,202,15,96,244,62,76,242,247,165,14,97,9,207,217,160,198,172,133,222,49,142,8,36,38,32,64,62,238,86,224,99,84,194,13,37,11,76,97,137,251,47,252,182,17,224,128,197,87,252,177,71,199,122,14,110,36,182,124,140,244,162,79,61,133,37,210,185,104,25,124,16,125,245,21,82,137,113,225,140,130,58,107,226,0,102,184,252,173,177,33,142,91,49,78,104,164,21,162,138,182,252,228,184,7,4,22,206,238,133,146,249,232,126,234,168,103,69,198,37,52,204,187,182,161,93,14,82,117,20,51,166,206,237,197,142,221,188,192,203,82,141,52,69,187,87,163,29,212,234,134,42,76,56,108,139,245,38,200,60,156,204,158,18,184,98,159,119,13,97,246,49,82,185,165,183,179,48,170,145,240,128,0,208,198,125,108,109,64,208,225,67,84,147,144,234,134,231,45,39,169,232,19,185,97,212,180,141,218,161,188,7,110,131,72,237,30,125,198,128,46,24,142,98,34,243,65,182,163,152,198,207,169,212,228,113,45,74,158,42,75,106,7,203,24,239,191,132,223,35,172,66,172,218,27,93,161,157,216,149,207,65,51,180,28,234,26,201,186,72,222,21,108,118,43,165,16,206,80,244,196,65,25,10,124,174,132,76,109,181,232,117,34,54,31,201,49,208,96,174,97,233,44,58,105,97,99,175,192,91,102,202,131,100,250,233,98,63,238,151,168,166,211,131,57,125,77,249,20,29,80,151,91,203,202,131,236,31,35,103,158,186,150,67,119,52,152,254,2,45,64,207,207,204,121,13,207,88,27,76,60,173,3,155,203,23,242,174,59,44,134,147,125,187,135,15,75,89,241,127,246,53,170,169,229,211,43,81,40,228,189,125,151,85,187,166,178,22,229,143,75,41,57,219,28,64,64,59,163,230,21,103,32,184,92,191,54,228,145,33,80,216,2,44,28,70,50,89,208,124,148,246,147,213,77,161,225,42,100,232,46,36,153,25,35,130,115,61,237,129,248,195,199,29,193,211,110,160,19,63,48,55,2,57,24,92,243,94,70,25,131,45,95,83,127,141,159,182,223,70,24,110,211,85,20,30,4,133,219,142,17,42,184,223,184,104,111,100,110,88,215,47,166,142,155,121,147,235,153,239,203,103,180,195,226,31,233,101,152,148,237,111,228,120,27,135,61,51,139,215,125,15,11,22,160,135,127,149,175,248,0,162,104,178,182,33,78,197,153,64,53,52,235,219,67,126,190,116,198,204,77,87,169,9,210,213,192,236,221,90,98,249,224,59,164,29,138,48,76,30,6,198,56,93,107,187,130,205,24,142,107,97,173,87,24,49,190,115,175,140,28,152,219,184,122,22,60,199,100,192,189,238,177,238,4,230,189,55,231,145,69,72,158,75,228,128,247,85,161,164,6,40,193,226,84,229,138,201,151,106,182,28,188,34,198,246,206,117,81,169,116,151,53,113,20,14,32,206,43,132,72,224,42,114,186,7,140,35,138,53,68,121,201,249,113,234,93,91,0,132,193,46,159,237,228,188,221,235,15,181,119,183,170,201,210,76,213,198,79,32,183,217,33,140,158,12,252,23,118,81,145,112,227,2,52,179,135,63,227,152,52,221,149,190,1,25,118,213,218,41,246,48,7,184,6,123,135,121,13,22,174,25,9,154,186,141,97,126,104,56,149,138,206,77,183,115,237,132,66,243,78,81,222,27,253,160,22,15,190,166,145,221,128,106,41,190,14,184,27,42,38,63,124,45,203,232,176,254,203,139,245,131,36,57,230,87,242,112,180,150,242,190,60,171,163,52,215,7,214,36,186,53,97,232,175,146,171,147,141,167,64,15,124,65,55,68,24,245,254,152,20,234,88,2,209,24,195,66,125,237,163,6,23,201,236,66,236,47,234,171,118,88,89,154,77,140,44,80,250,217,188,152,253,22,185,16,20,209,36,11,217,209,128,87,49,74,253,58,81,161,139,141,78,180,14,143,34,192,56,250,153,127,136,255,3,242,85,140,213,235,29,188,182,10,208,159,88,91,211,98,76,125,123,19,163,56,19,136,3,91,170,138,18,208,84,181,169,227,232,8,195,139,250,138,236,61,76,252,137,241,160,234,43,142,127,229,88,110,50,119,153,249,193,33,67,37,145,218,236,176,108,18,176,9,33,110,241,29,151,220,34,98,193,43,137,208,111,132,168,89,150,203,121,71,191,169,109,248,223,149,204,251,235,233,75,188,244,148,20,121,231,115,255,41,159,191,82,98,95,233,59,74,108,23,96,48,163,86,181,129,81,6,216,125,53,34,231,238,8,155,100,109,159,245,82,162,172,241,89,55,236,222,181,83,145,99,72,33,176,113,132,84,111,187,179,169,105,161,223,164,251,39,9,4,224,101,65,202,64,201,123,190,40,179,10,255,187,52,204,11,161,83,182,63,70,141,234,255,120,203,194,35,242,148,91,66,206,249,153,202,34,252,182,132,38,88,216,77,176,160,88,72,106,201,143,156,226,249,107,114,39,228,84,12,195,115,106,44,90,149,251,121,21,45,170,83,212,145,105,89,211,202,54,176,144,164,45,1,166,8,124,193,145,54,148,79,49,134,187,160,29,89,101,13,126,37,57,85,212,145,82,205,228,219,92,177,61,80,235,142,91,177,198,230,199,254,22,144,53,83,86,212,112,100,5,161,11,252,84,87,228,232,83,61,56,84,215,131,33,239,196,203,201,42,146,47,229,99,130,97,241,132,165,179,96,60,235,45,244,37,46,126,246,111,90,225,24,22,226,201,65,135,3,114,151,169,6,168,141,51,76,232,90,252,42,226,58,12,233,45,84,48,52,32,226,145,106,228,131,124,199,182,129,205,74,113,101,186,69,91,85,45,203,225,73,58,216,198,237,28,67,3,252,56,86,174,175,192,209,92,39,20,132,120,253,49,134,138,140,86,68,147,95,103,68,91,83,150,208,149,137,98,216,226,223,29,165,14,239,54,161,66,26,203,179,186,19,204,9,60,178,4,101,1,120,163,79,62,234,242,115,23,197,81,190,249,146,47,31,62,158,209,241,30,97,189,215,154,28,145,119,141,213,6,204,119,195,160,183,82,86,202,187,162,79,52,27,184,178,196,47,52,237,145,229,254,202,21,49,108,224,239,2,193,245,161,95,156,4,23,89,9,70,209,66,233,224,231,176,211,211,164,220,95,106,85,62,47,236,49,50,113,229,154,78,192,79,6,172,228,223,36,106,19,182,118,2,78,149,79,229,234,9,148,198,215,94,73,168,121,9,93,196,116,6,126,103,195,173,232,63,112,173,25,208,161,99,127,116,215,129,170,177,27,129,211,241,182,35,235,122,148,47,206,57,90,172,203,241,244,200,111,227,226,162,188,191,186,106,250,81,193,84,236,221,175,56,122,164,94,241,157,156,27,115,158,92,181,37,232,104,234,16,173,247,9,8,12,62,75,41,175,117,242,73,237,154,202,221,194,178,202,63,28,237,189,108,209,74,114,217,32,50,120,235,234,161,128,39,71,255,204,205,38,214,127,7,164,24,54,249,100,81,107,151,214,229,178,70,128,25,196,10,2,225,108,252,88,223,128,178,215,2,101,40,143,181,186,117,198,174,115,173,52,74,222,194,36,24,223,228,69,240,174,241,3,236,54,25,211,148,24,38,145,53,198,206,9,253,29,240,45,67,17,65,87,216,253,110,12,208,111,31,60,85,228,205,108,4,113,227,172,111,221,165,246,192,227,41,94,225,171,24,167,51,24,22,11,157,27,254,15,31,246,235,10,253,52,109,177,37,45,122,128,187,71,75,240,187,57,199,206,58,144,150,12,39,170,118,10,172,119,149,165,159,50,72,22,63,26,110,74,62,94,231,15,157,184,220,251,37,232,100,145,113,107,22,182,186,125,21,253,16,196,124,106,83,112,79,244,214,161,148,174,41,85,235,152,76,146,104,226,171,185,45,72,135,19,125,251,208,14,31,133,167,117,217,70,102,171,188,211,4,242,250,200,115,51,75,82,215,203,29,112,83,194,45,108,226,64,39,167,218,118,168,136,89,57,75,40,101,170,116,214,28,121,167,193,94,2,3,191,104,238,0,185,194,87,46,64,35,186,100,120,61,24,165,199,70,30,126,183,93,49,223,117,223,245,226,71,237,157,16,32,210,29,47,107,155,62,7,162,52,213,55,223,216,49,179,204,173,90,84,40,233,91,197,36,9,131,240,162,230,149,215,125,146,234,86,238,106,16,57,82,32,208,36,22,223,75,3,141,158,20,88,100,151,145,193,40,227,104,194,61,126,107,119,79,174,242,19,79,180,46,189,164,48,203,190,111,213,40,75,37,182,200,119,242,233,190,151,223,152,165,101,200,3,5,138,26,19,107,199,66,154,109,125,110,172,236,189,81,4,38,217,38,48,81,120,239,32,140,91,52,172,134,149,185,130,207,138,85,27,67,237,128,124,169,58,133,216,42,192,80,33,235,37,63,7,163,39,120,118,41,92,192,179,81,118,41,179,16,222,113,111,132,80,156,152,113,193,43,35,16,123,89,20,225,82,70,136,11,166,44,92,137,153,221,160,168,92,146,101,184,59,182,191,232,220,5,54,120,211,81,21,80,125,141,197,0,72,141,253,47,77,110,124,103,44,15,249,137,192,109,221,242,8,128,75,73,239,231,91,15,150,205,244,10,16,27,129,135,188,99,110,236,208,232,195,45,42,194,4,86,98,36,68,117,20,47,88,191,223,115,61,173,229,179,149,60,141,4,159,3,203,101,162,59,74,99,74,219,99,28,89,193,222,56,142,58,118,214,6,177,231,106,49,233,250,139,165,38,177,41,199,238,41,106,20,239,7,222,101,31,106,198,222,127,240,175,138,133,47,137,86,199,71,2,1,236,147,121,251,28,199,232,239,228,15,9,220,234,114,30,153,89,8,67,100,217,143,137,194,188,172,144,78,117,97,40,215,78,211,35,82,27,171,231,189,250,217,215,246,246,153,145,198,9,149,28,84,101,73,48,99,250,87,232,122,68,189,171,90,100,56,23,221,197,116,207,208,131,80,197,26,248,175,86,62,2,61,90,136,64,116,246,160,191,192,152,190,173,123,170,38,81,226,53,167,113,161,160,140,42,184,199,247,72,45,98,205,34,57,112,2,23,26,209,186,146,129,170,202,214,42,100,14,41,112,159,18,251,100,157,130,80,244,204,233,44,130,115,236,234,117,233,76,125,121,233,129,242,138,143,25,50,18,252,11,92,147,62,111,204,178,65,181,25,208,248,110,121,76,47,112,196,191,3,4,74,210,162,239,29,14,166,173,10,166,236,156,142,108,165,51,222,67,8,14,133,157,106,184,74,139,242,9,84,0,202,56,58,126,120,145,192,227,172,83,255,175,20,78,38,152,103,120,9,135,67,208,205,113,81,202,48,100,97,182,2,36,110,151,210,181,154,67,119,78,204,255,221,119,9,214,49,176,37,122,1,57,70,24,165,26,147,84,182,187,160,227,43,114,147,148,252,31,96,184,163,224,220,205,3,82,247,37,100,139,53,231,147,7,8,208,244,209,237,91,224,180,167,89,54,121,62,86,191,237,218,225,34,143,102,160,109,200,210,49,236,43,111,48,91,68,100,84,77,26,142,177,242,50,156,210,188,170,37,148,10,206,63,44,54,250,167,115,160,252,2,101,46,121,27,79,202,193,43,140,219,180,147,185,194,9,180,102,117,138,39,84,25,227,49,106,105,105,81,52,237,194,155,243,67,141,96,200,68,203,82,89,186,156,41,155,153,169,137,121,33,150,28,5,127,71,131,192,37,203,161,211,116,184,81,115,99,47,244,39,141,242,46,128,3,109,145,207,170,85,21,52,86,125,175,109,160,223,67,63,180,209,42,38,69,214,136,209,253,105,191,90,20,106,56,199,9,213,254,233,19,238,79,67,137,76,165,54,78,246,214,110,85,235,101,154,102,70,155,157,158,225,190,7,162,17,153,127,57,151,234,174,173,158,207,214,227,110,39,173,77,91,134,173,26,139,221,31,35,9,114,134,142,125,84,50,136,102,62,111,171,183,86,171,249,163,66,188,126,44,209,155,151,192,71,64,139,251,96,86,221,215,232,18,176,233,92,222,170,124,44,83,118,175,135,58,118,27,192,198,82,16,245,111,194,248,92,184,146,239,66,246,242,92,42,114,10,216,136,213,203,202,223,96,240,163,114,52,81,142,101,238,32,136,38,69,66,69,169,22,158,148,63,194,221,135,24,234,254,233,212,247,85,32,8,97,68,206,63,50,195,84,13,162,226,116,37,215,85,136,105,149,60,242,193,174,163,209,203,53,91,0,55,89,201,232,7,197,113,215,160,135,137,164,184,168,103,125,230,222,112,214,68,115,231,184,103,231,100,102,93,153,233,90,59,108,206,133,252,39,192,197,190,52,105,240,47,105,113,198,128,218,0,174,235,75,196,124,252,95,188,35,255,136,172,164,129,238,204,186,131,24,196,94,27,140,170,114,51,117,113,124,198,44,116,14,206,171,242,139,87,198,95,236,95,94,86,145,242,134,180,0,224,57,223,107,128,28,79,176,246,236,225,166,222,136,190,253,164,31,10,33,13,79,57,244,206,124,255,220,196,253,91,67,101,27,183,10,92,149,188,153,54,204,131,195,148,136,58,217,22,111,196,247,105,246,38,1,88,77,206,111,204,89,187,232,50,142,200,57,175,87,119,242,178,201,25,101,144,184,52,20,47,42,124,151,197,101,1,64,198,236,249,94,224,51,211,40,158,222,92,30,163,112,231,147,121,228,125,191,121,216,45,161,205,126,140,92,189,69,155,221,98,54,195,160,135,249,41,210,204,131,7,107,251,50,145,176,121,133,51,44,104,231,47,35,176,47,39,139,57,51,154,36,251,178,208,234,92,64,178,177,14,190,34,60,60,137,39,203,57,34,192,247,212,26,240,96,242,49,168,116,99,41,157,147,166,163,84,229,124,171,236,39,29,37,105,28,76,41,46,169,84,241,233,219,137,167,216,88,209,5,163,126,64,254,97,245,140,95,242,154,93,25,13,28,139,195,91,90,251,252,14,171,224,126,69,49,40,138,220,36,134,60,219,166,81,232,214,141,67,132,168,89,188,77,151,19,224,211,35,224,28,196,89,86,31,67,162,138,72,133,24,15,6,166,180,72,84,32,234,230,184,89,96,156,253,125,32,173,195,198,134,1,27,5,110,115,245,122,28,247,205,168,170,149,185,4,94,175,19,130,66,51,35,83,225,90,149,183,53,115,89,181,94,86,85,30,178,89,18,236,95,160,28,242,218,192,168,7,36,9,81,117,160,217,187,175,222,183,95,38,0,119,113,240,171,228,192,133,231,204,44,8,70,6,107,61,36,208,240,192,212,142,110,250,52,145,50,230,169,25,145,57,4,91,224,39,146,70,105,112,223,8,47,26,231,205,204,117,132,168,91,83,103,24,2,150,23,191,176,246,177,115,182,153,91,205,134,29,131,160,70,192,192,87,251,93,120,110,236,184,131,226,42,19,39,203,59,233,83,233,164,118,136,204,169,202,162,193,213,46,138,78,175,76,217,222,181,45,178,18,124,227,229,9,83,5,171,212,193,30,139,249,41,246,241,26,247,254,184,116,91,79,119,54,43,254,197,192,80,43,10,186,233,188,184,251,236,139,231,90,175,231,107,84,173,115,145,32,58,60,216,45,206,38,66,220,227,167,173,154,221,140,129,132,140,12,67,83,8,17,118,23,87,175,234,193,56,173,36,202,109,23,58,133,227,149,142,212,75,239,66,25,192,83,238,178,125,112,36,125,45,159,128,45,231,24,1,168,100,75,155,75,89,101,200,251,139,155,35,195,155,130,95,0,182,8,131,167,162,41,219,42,5,137,131,221,213,67,231,95,81,4,15,88,128,253,195,179,3,163,86,149,87,26,31,32,10,57,208,9,70,184,188,64,106,144,127,37,178,52,253,3,152,25,1,198,243,249,116,170,218,69,207,192,116,31,89,73,14,218,160,80,87,182,170,115,110,182,152,193,208,0,223,166,213,13,241,9,154,171,44,127,62,136,156,7,116,73,151,214,82,34,42,92,232,124,116,35,70,169,227,131,79,151,218,127,199,2,211,80,46,0,36,197,152,227,128,147,20,181,80,120,23,83,226,60,211,129,55,140,163,184,20,168,114,229,213,84,144,65,65,234,200,108,26,36,74,205,144,207,19,122,241,134,128,242,204,123,188,174,133,42,43,168,128,19,41,3,200,174,98,50,30,239,252,70,110,63,183,132,207,154,231,235,205,61,114,228,52,30,178,70,61,150,75,95,148,226,170,217,10,33,230,111,22,69,5,180,175,236,103,200,205,12,250,37,67,196,192,248,68,156,33,0,33,35,47,198,88,94,246,240,45,147,151,228,229,113,130,118,72,160,83,249,24,132,16,231,195,81,97,20,198,27,127,146,219,42,36,225,245,214,34,17,138,179,118,42,63,106,217,187,2,175,171,65,112,252,87,97,162,31,162,234,220,125,163,200,53,40,43,11,66,30,215,67,46,182,221,15,16,95,80,34,250,60,86,210,181,107,227,102,190,18,243,255,149,197,163,87,235,187,43,111,216,149,252,47,136,114,24,249,253,65,30,134,109,123,130,240,90,191,245,75,216,100,84,60,8,220,7,55,174,31,245,24,146,231,82,63,216,185,229,139,57,83,222,203,47,35,43,204,126,158,89,149,241,23,219,229,220,140,24,58,214,79,16,248,6,14,141,155,120,30,116,75,29,255,47,17,85,235,112,37,214,215,178,114,201,201,71,195,47,52,121,41,42,153,111,190,180,5,151,238,247,161,176,9,25,73,41,148,17,30,29,137,160,150,69,107,235,236,45,11,137,40,121,211,199,88,98,67,94,233,28,14,10,47,182,226,101,76,101,168,154,223,15,159,98,183,209,5,115,130,220,161,51,53,5,68,133,20,240,125,53,110,252,210,73,38,183,45,87,173,103,109,210,204,172,162,116,17,182,244,244,90,144,93,216,182,63,249,51,172,9,116,117,197,117,37,150,206,109,153,26,154,86,203,96,50,56,101,55,207,17,82,211,75,178,179,229,226,195,27,74,226,128,41,207,27,18,195,240,10,63,3,77,7,110,19,112,64,134,111,227,204,235,176,146,59,162,227,147,171,90,55,62,102,200,110,122,11,250,73,78,139,12,97,205,105,255,251,9,238,213,194,33,161,125,131,26,121,136,93,186,190,199,185,20,137,166,237,41,127,43,198,88,79,80,96,228,63,189,255,13,206,208,248,145,65,202,154,176,86,13,30,7,26,0,158,232,143,119,169,95,167,131,86,138,232,2,221,105,216,205,126,159,118,130,188,146,148,75,42,144,176,45,101,58,141,74,129,75,205,224,147,155,196,141,25,197,84,70,80,105,12,191,151,122,50,4,226,65,150,58,42,30,130,152,217,200,43,219,202,146,162,224,9,66,34,40,103,152,59,91,39,235,236,77,145,149,74,58,150,59,194,139,232,107,149,102,251,181,54,144,52,225,49,158,142,42,81,122,39,135,108,219,220,107,37,126,233,60,217,230,114,193,151,174,105,80,141,123,49,149,214,211,116,30,22,202,14,142,26,55,23,100,202,247,148,33,229,142,251,6,156,116,122,199,69,64,223,136,26,174,111,52,170,14,67,64,226,118,183,5,72,223,217,197,106,228,86,85,48,171,177,188,51,111,26,186,190,146,77,123,252,116,135,27,248,12,203,153,79,202,32,201,57,142,163,156,57,59,184,67,210,48,62,31,193,105,122,227,146,111,126,251,143,94,136,78,13,5,28,105,180,187,47,202,12,89,131,128,113,20,187,187,135,104,38,106,30,23,50,39,162,205,48,204,71,221,191,225,68,23,190,116,198,147,117,101,140,31,77,232,177,86,180,77,223,189,98,7,116,198,211,66,76,8,71,80,8,50,135,190,5,123,54,48,255,115,26,200,172,231,5,133,201,75,148,20,47,28,173,89,197,55,210,74,74,209,101,168,11,170,55,255,170,166,104,21,61,166,247,232,83,41,214,64,168,254,115,89,143,255,59,182,203,185,252,227,42,101,222,150,81,55,113,52,81,239,200,155,159,90,61,70,173,9,78,38,192,195,245,218,195,93,165,103,49,44,255,6,19,13,5,159,60,215,96,144,42,199,226,31,103,57,120,199,96,55,142,17,224,142,49,224,158,224,155,189,129,133,179,189,196,44,252,220,222,205,84,131,87,225,82,120,0,177,200,142,250,194,135,107,231,163,169,245,79,105,188,247,221,231,243,85,167,48,230,236,136,243,179,68,41,211,160,83,198,173,34,18,175,133,111,20,160,15,22,3,18,111,245,135,64,202,143,141,190,140,26,111,143,239,65,173,52,236,226,220,175,23,210,109,104,2,250,166,120,180,1,35,191,163,83,249,140,220,135,172,18,228,105,122,233,114,225,183,172,23,100,253,10,227,25,126,82,16,10,68,176,24,130,37,5,137,18,225,152,76,16,250,167,105,193,137,117,213,233,98,172,192,47,116,54,6,54,62,103,70,117,36,101,237,88,226,47,51,242,211,16,37,97,176,68,113,47,87,176,144,42,173,38,239,148,212,67,49,250,240,180,12,54,241,210,191,17,65,247,200,161,26,173,167,233,66,34,87,151,113,102,104,89,236,152,165,79,238,76,83,59,11,59,108,164,137,10,28,187,182,159,254,30,149,248,157,20,142,66,73,41,105,205,162,221,23,21,238,199,164,43,195,6,70,147,65,76,117,12,254,172,143,97,178,41,75,102,146,204,204,195,9,132,252,243,63,170,18,227,154,23,47,75,212,238,199,169,68,183,176,130,70,86,141,23,10,70,126,250,139,188,19,180,163,224,0,14,130,66,119,135,29,160,73,24,154,48,63,204,167,189,46,55,212,140,58,4,87,8,157,253,171,71,198,60,249,241,11,242,50,7,161,87,62,189,72,198,8,189,194,239,147,181,252,200,113,87,186,29,76,160,182,226,146,111,51,248,255,25,67,36,170,143,112,103,113,248,159,175,219,49,238,7,62,179,213,243,20,171,153,249,216,132,226,5,209,86,135,115,79,221,16,108,133,222,125,229,2,221,135,78,116,98,48,121,225,59,156,33,247,79,63,148,10,34,28,234,162,240,162,111,210,87,65,90,226,138,56,7,182,175,40,172,119,186,32,133,143,68,160,23,221,215,176,230,146,238,64,235,172,58,141,11,132,95,27,112,60,89,241,14,112,58,213,252,88,242,215,219,43,129,15,190,235,236,12,140,187,46,10,66,215,55,63,20,248,31,170,33,122,223,253,194,154,102,71,156,132,179,160,99,25,149,123,112,221,107,82,69,250,193,178,165,162,119,114,224,33,192,209,213,230,235,5,12,153,187,52,42,83,100,90,138,209,122,249,168,78,243,190,196,38,122,114,208,3,198,28,174,99,153,53,229,59,179,252,100,74,167,97,46,83,88,124,224,42,212,238,234,100,195,7,8,177,165,224,64,85,129,219,45,113,17,148,143,176,0,98,93,146,127,154,39,26,29,149,203,27,159,225,180,33,181,0,131,175,61,49,113,151,121,169,157,56,30,91,159,253,31,65,255,145,141,127,6,205,132,220,27,11,207,123,221,79,9,35,110,3,92,34,21,47,131,176,56,197,40,95,87,144,221,237,9,250,148,29,203,103,255,3,79,146,194,162,202,24,205,245,195,4,220,229,234,112,18,172,144,233,54,146,98,230,186,75,78,184,170,91,152,52,103,1,186,47,251,196,14,186,250,158,98,243,30,114,207,241,200,8,117,154,182,60,113,69,121,159,236,9,197,216,175,124,116,243,179,213,73,126,230,42,186,187,14,11,80,164,254,190,195,50,219,146,19,253,185,2,126,2,80,109,191,217,123,65,152,195,16,246,161,237,250,55,147,224,218,38,203,215,73,243,122,38,20,252,56,163,178,211,178,155,18,172,104,30,122,191,250,112,148,182,23,154,228,37,67,244,13,53,45,45,255,147,135,136,193,231,248,123,52,156,112,54,120,105,20,114,103,159,43,52,150,92,83,223,204,9,206,91,67,196,89,32,114,210,226,156,212,207,219,181,15,224,53,4,135,138,55,84,83,2,197,228,51,212,102,198,199,140,243,3,65,51,113,236,148,79,64,133,24,224,102,17,172,61,231,57,21,201,212,180,196,130,36,239,166,94,15,214,33,24,25,12,24,178,214,0,136,220,116,237,232,206,71,147,200,144,207,34,150,123,156,84,155,162,5,76,5,149,116,218,70,202,89,223,32,116,240,38,188,122,173,79,169,59,100,4,117,119,90,190,207,122,89,150,224,4,229,3,113,241,239,236,74,223,48,201,139,149,186,127,57,34,60,149,100,164,90,228,62,138,53,43,4,123,60,92,244,117,156,33,137,47,132,210,118,133,210,211,123,194,114,183,93,4,104,182,166,14,254,213,162,230,178,109,70,110,77,70,220,109,253,84,131,89,217,255,223,168,241,71,0,198,11,103,169,114,25,38,53,30,90,57,93,238,240,39,158,89,238,15,134,65,111,31,103,36,2,60,182,62,82,202,139,214,38,28,123,98,206,97,97,15,102,179,199,172,78,83,234,93,62,49,83,113,74,254,134,115,112,132,16,186,153,165,121,42,133,203,229,99,198,89,56,240,140,73,0,141,220,227,22,28,70,254,45,32,65,132,239,74,23,9,201,37,175,56,222,130,163,25,78,101,122,3,203,198,18,188,161,139,112,53,104,247,232,55,50,21,36,163,237,169,184,131,219,129,138,154,17,167,112,110,78,49,103,215,25,46,147,176,223,101,133,25,153,223,162,3,138,135,3,198,225,114,179,189,178,238,160,140,246,143,134,169,85,22,138,52,166,170,252,123,217,229,201,4,8,58,96,187,43,1,102,125,83,189,55,205,115,229,131,214,197,0,236,90,250,54,179,202,68,131,205,129,165,236,37,135,196,77,24,98,37,246,78,189,115,157,185,55,138,208,165,78,49,55,212,36,195,60,65,84,181,55,68,96,79,247,232,148,28,240,130,215,167,69,68,216,226,110,219,36,208,18,0,36,50,144,103,155,69,174,0,90,5,36,235,13,225,237,110,148,22,226,175,137,20,100,120,235,78,121,101,118,50,23,230,4,5,241,42,212,99,72,50,205,141,69,17,157,213,125,173,85,107,221,185,50,246,1,80,151,31,61,63,43,69,75,250,252,244,114,241,54,160,235,108,14,67,21,123,219,60,141,160,102,202,146,0,161,67,220,42,62,160,247,79,28,17,127,149,54,32,47,244,104,162,114,18,9,101,124,36,55,90,176,63,92,183,151,127,36,193,31,110,159,60,159,207,107,76,82,252,82,79,163,62,181,134,250,232,8,178,10,76,65,130,123,230,219,160,236,111,195,219,134,176,182,214,209,210,89,62,61,206,41,220,177,109,220,14,127,197,184,201,54,231,153,135,231,124,245,133,78,1,128,89,66,4,207,24,238,140,195,132,18,62,0,14,33,175,192,54,147,116,98,240,78,105,209,74,194,206,9,206,205,185,164,96,45,173,149,129,98,209,155,158,117,115,124,76,154,215,2,1,9,237,182,116,83,190,33,56,68,100,87,137,57,13,211,133,161,47,62,10,212,191,221,98,122,8,238,155,161,14,31,131,14,151,217,119,143,45,64,31,23,22,150,180,18,132,180,9,9,189,186,73,78,91,98,123,244,88,47,193,137,226,101,152,247,200,152,6,152,142,171,100,65,102,67,79,152,22,180,251,198,41,27,243,20,77,2,187,42,29,227,164,203,58,224,121,0,248,103,43,41,120,89,24,231,5,132,250,235,226,126,248,210,136,59,193,181,95,19,52,73,222,163,11,252,120,148,9,94,143,203,250,105,160,151,146,47,31,87,102,215,224,50,223,103,75,237,150,67,119,187,9,86,244,7,239,133,213,243,220,156,67,121,119,63,228,103,158,18,61,190,138,17,23,140,119,159,168,24,236,24,144,37,174,202,245,70,204,31,42,71,126,235,20,134,125,90,67,61,53,91,137,78,255,199,81,155,230,145,94,233,194,66,40,78,63,3,48,164,158,139,101,130,177,246,119,98,135,53,40,178,28,226,184,227,3,105,106,107,16,41,14,126,68,84,190,215,13,116,202,59,139,252,250,57,66,138,154,236,225,52,176,64,119,157,94,154,88,180,208,136,202,140,50,124,168,123,123,102,144,30,110,6,153,182,54,160,18,99,194,165,214,25,184,88,3,57,34,241,191,225,173,22,214,204,12,62,225,9,225,193,176,106,48,127,97,17,132,131,6,27,144,26,57,67,188,158,130,203,171,228,69,209,96,248,156,79,27,190,169,46,136,91,173,57,96,234,208,110,229,111,33,148,143,45,14,161,184,41,151,105,55,135,111,62,145,159,142,46,69,103,234,103,254,14,57,222,114,163,189,227,171,175,106,168,160,61,228,29,151,48,123,90,206,236,196,114,214,68,240,224,200,99,28,164,123,111,82,102,33,174,120,50,115,217,91,27,174,145,252,27,196,114,204,28,104,93,204,225,232,39,37,164,188,180,69,49,16,169,7,243,231,128,225,190,178,219,229,122,9,84,42,83,49,127,241,248,108,158,99,212,46,234,164,224,166,86,199,60,38,195,46,101,20,6,167,109,99,4,148,121,170,148,206,157,124,30,80,218,136,253,244,217,43,238,165,104,80,142,249,92,199,86,81,173,107,96,5,170,79,147,234,184,158,107,235,237,4,3,151,130,104,5,249,249,129,241,80,72,112,194,52,72,59,232,17,57,141,186,85,162,154,79,30,157,114,142,162,112,129,168,3,13,240,121,9,233,167,154,212,230,12,243,180,176,94,220,95,19,159,191,8,125,207,139,20,97,49,11,226,160,110,216,199,242,21,215,43,238,39,69,174,26,251,44,73,186,250,47,59,206,61,140,224,114,27,6,86,56,105,35,252,67,215,158,240,114,180,46,120,223,206,28,22,179,109,228,182,135,105,101,187,152,236,196,31,110,155,244,214,83,223,182,231,100,202,79,204,236,252,222,94,90,36,183,71,237,37,86,177,41,209,109,34,112,92,44,236,245,177,50,235,224,207,99,214,77,15,217,127,213,79,74,107,94,215,101,3,50,249,153,92,4,62,79,59,5,77,47,20,147,73,222,226,79,24,110,10,92,13,246,144,87,158,115,233,223,73,120,117,204,84,57,222,115,150,200,246,82,40,113,161,153,66,145,98,128,31,62,115,19,87,3,212,24,48,29,158,43,98,177,57,89,149,104,229,212,74,131,45,119,20,225,34,166,195,38,99,89,198,79,96,152,83,12,158,17,133,146,197,106,47,128,192,188,140,219,190,245,8,125,214,54,216,224,104,150,231,232,33,177,250,12,170,197,87,133,159,5,157,138,160,0,41,7,180,41,23,184,226,179,243,67,53,138,203,90,209,240,168,217,167,204,99,216,34,55,158,146,107,20,63,190,77,182,110,79,158,237,209,9,239,151,249,190,249,35,156,65,249,151,34,143,113,111,28,147,150,247,148,13,149,49,243,96,119,96,207,7,96,182,197,220,184,95,152,253,26,122,58,241,61,23,77,230,129,194,91,201,123,155,225,150,122,133,150,180,150,37,159,36,252,61,138,74,192,204,75,153,60,254,101,250,53,123,110,9,42,70,107,113,48,131,222,212,147,62,70,178,70,140,17,146,203,201,37,100,1,78,248,121,80,190,83,242,15,105,53,202,184,184,33,127,147,19,178,44,33,155,180,124,52,242,251,99,140,122,103,174,68,2,91,121,94,41,157,143,181,76,199,175,190,183,183,216,123,237,21,14,158,111,36,67,127,169,239,80,32,137,110,111,194,124,27,236,63,81,155,166,204,196,121,106,220,36,31,185,178,74,85,6,167,214,75,29,206,101,229,166,100,47,175,146,253,32,71,16,34,213,45,32,130,124,114,134,10,177,134,105,43,180,242,48,181,172,37,148,208,152,106,132,244,214,31,35,107,80,184,232,102,150,173,129,200,42,50,226,253,94,37,244,144,182,75,6,97,102,130,158,245,199,219,221,26,134,146,187,28,177,228,81,93,168,215,85,234,86,89,51,132,141,171,202,87,142,138,142,210,126,96,244,240,101,236,17,83,41,192,67,104,47,52,233,47,214,81,96,189,183,184,39,146,133,145,196,76,3,73,75,4,251,41,64,55,137,28,49,77,17,129,145,198,230,76,33,168,175,140,188,78,3,112,236,103,207,30,99,160,179,87,27,32,3,113,116,47,162,141,245,54,154,12,155,65,219,246,153,147,114,89,208,150,74,252,61,95,56,214,199,14,232,147,113,255,176,27,16,11,109,219,112,9,206,250,93,22,248,236,238,68,20,227,220,83,92,213,34,129,73,179,68,118,181,53,113,79,71,209,44,191,72,224,208,225,209,42,46,47,73,42,143,51,247,21,173,37,230,62,20,180,69,61,96,180,248,145,4,41,208,178,143,215,46,35,170,100,5,189,80,42,207,50,70,203,222,198,106,84,245,103,34,86,148,27,204,86,27,11,246,252,110,162,60,111,171,194,31,155,141,251,195,42,142,77,236,75,147,8,203,130,212,32,98,117,229,253,189,218,73,62,102,226,77,69,107,186,163,218,54,85,94,206,174,8,240,164,171,125,195,22,131,53,225,36,174,216,74,141,54,253,90,17,208,20,161,77,239,246,156,234,222,72,148,34,192,120,183,124,206,176,209,146,2,203,70,48,64,15,14,236,158,219,235,3,38,197,82,106,77,77,57,18,158,237,11,68,106,158,198,234,237,253,149,140,14,146,200,24,191,121,183,105,227,47,224,137,192,146,76,248,108,91,188,49,147,163,28,84,110,177,107,130,69,124,121,245,228,133,215,202,197,4,246,11,14,206,158,110,81,199,63,147,243,216,12,245,177,83,141,225,167,179,188,154,79,5,35,215,74,124,187,254,234,248,175,212,251,70,42,219,150,21,243,123,30,208,113,131,21,209,143,167,104,70,193,253,95,179,49,26,185,16,3,31,231,46,19,156,226,250,127,137,27,53,123,46,19,102,154,209,124,108,210,57,232,185,56,200,185,179,241,239,73,230,45,125,22,43,187,185,231,20,219,111,236,150,33,113,140,21,81,4,106,85,111,176,163,211,241,229,149,186,197,156,35,7,102,34,93,20,145,242,145,140,247,191,227,152,28,166,119,28,38,248,121,40,235,250,202,219,185,135,189,147,155,189,221,188,198,74,54,180,160,95,217,86,8,36,176,108,247,107,155,140,145,37,223,131,205,171,170,95,4,188,200,91,228,52,98,100,54,19,159,19,52,21,108,232,245,194,62,143,169,168,79,26,31,38,16,17,25,195,241,239,153,88,111,144,68,201,8,65,184,254,132,119,64,48,203,121,49,126,20,178,21,43,194,181,193,144,239,193,143,195,144,39,247,22,129,27,92,219,253,225,226,233,25,69,206,26,131,178,27,148,31,146,158,12,253,9,116,206,64,52,15,205,150,97,192,248,173,145,150,160,206,137,148,26,248,60,39,67,182,20,73,204,17,89,155,150,161,238,218,244,193,179,205,227,14,64,119,72,86,250,55,201,235,138,93,117,230,107,156,45,142,119,195,239,178,176,146,79,38,249,66,198,96,13,209,207,13,109,44,159,183,19,93,60,118,88,31,8,73,251,129,93,122,198,68,141,117,77,215,175,242,22,129,38,55,11,229,39,89,83,21,210,139,56,67,181,74,170,226,19,26,116,121,124,54,46,166,151,194,211,191,246,183,215,44,229,115,229,116,156,159,213,66,55,7,20,156,154,243,7,94,167,227,242,195,51,162,4,121,104,79,8,189,65,16,152,35,53,161,177,148,98,157,75,215,223,55,233,222,233,67,213,90,19,67,78,80,168,122,25,136,183,222,180,40,69,187,218,153,35,104,216,151,35,56,106,68,248,221,12,199,144,42,207,102,24,85,177,121,217,119,159,40,194,63,86,14,187,58,8,68,144,203,34,117,12,88,147,40,82,125,148,93,153,9,46,145,146,151,109,205,253,95,82,225,6,178,214,56,98,35,143,161,156,97,46,214,20,43,81,195,74,251,26,234,250,178,211,74,90,230,206,169,207,49,193,114,146,3,211,92,77,255,151,157,158,28,85,138,166,60,145,55,101,146,229,253,42,230,94,102,183,199,124,162,241,88,32,190,255,157,177,234,131,121,105,230,53,143,222,72,218,214,59,130,145,107,132,55,87,146,19,211,73,122,69,235,239,12,116,122,208,0,219,36,201,255,2,31,29,37,126,190,96,192,159,219,223,66,221,30,70,56,186,193,55,149,174,51,52,102,102,105,198,20,252,249,111,32,53,104,30,125,193,11,212,35,84,170,135,249,146,214,80,129,163,19,207,161,106,161,28,11,33,222,147,6,37,123,190,33,163,66,23,88,168,146,206,213,45,79,132,161,68,126,83,82,237,247,214,121,218,33,244,1,7,161,237,166,216,104,50,240,42,5,222,236,58,254,78,51,163,146,188,87,50,241,203,42,58,83,255,182,167,120,150,249,251,45,83,63,224,72,43,6,112,235,188,83,94,238,36,32,148,160,29,95,218,184,144,93,247,203,52,209,192,87,63,145,207,56,152,178,34,150,238,196,230,102,28,249,155,41,162,105,227,102,115,157,16,29,75,253,178,33,164,195,56,229,4,189,49,245,117,82,219,72,123,120,197,252,187,182,164,4,138,219,138,3,12,123,130,111,77,81,127,141,186,56,9,54,238,247,84,60,235,140,128,42,83,17,58,84,92,19,230,109,10,223,62,127,194,164,189,150,238,182,151,50,105,35,41,93,73,4,193,212,186,103,24,5,11,118,236,87,119,190,49,254,92,73,44,99,99,74,222,27,107,47,161,143,226,130,26,101,255,16,91,63,82,203,35,104,187,74,219,187,102,24,161,39,64,81,98,64,91,50,237,131,216,12,4,57,215,69,237,19,51,252,81,107,113,125,112,54,174,123,165,42,0,102,246,73,251,93,50,218,38,138,50,53,51,139,86,59,202,167,163,128,113,204,129,154,252,102,175,177,198,202,39,95,160,251,77,207,96,215,65,155,125,10,22,17,235,180,238,16,180,125,166,226,238,37,113,91,34,133,23,240,115,118,51,17,81,20,65,207,241,29,249,122,229,17,156,74,54,143,25,225,29,184,247,168,174,46,78,8,152,137,40,169,48,74,241,231,214,142,180,191,95,124,67,26,25,22,96,206,111,205,26,237,15,61,214,31,18,94,201,23,89,181,160,119,232,122,171,183,114,217,85,71,211,180,149,159,143,1,18,199,30,30,58,117,247,25,247,237,218,72,151,48,151,238,249,69,162,141,120,158,159,160,43,63,83,131,220,132,1,105,150,226,118,54,91,188,207,235,69,91,218,16,58,131,147,58,239,162,44,140,78,96,209,126,226,174,95,111,225,38,47,61,9,44,215,28,138,165,130,110,254,182,20,216,82,239,13,51,246,84,107,84,189,96,149,162,82,44,112,63,22,69,37,53,109,5,58,17,147,253,244,87,123,153,202,103,0,4,171,103,249,54,199,22,44,161,148,193,197,115,247,6,228,175,209,69,16,90,27,77,146,236,114,8,225,119,93,223,160,159,4,166,239,138,51,38,49,74,216,196,108,121,181,102,159,101,131,236,227,68,74,181,55,246,73,137,188,202,161,133,137,105,111,34,108,66,161,68,49,190,155,104,244,158,67,78,156,36,221,155,159,112,183,13,210,29,76,31,42,130,154,143,114,239,137,157,115,79,83,150,60,40,52,35,123,49,171,20,132,175,184,57,193,143,41,108,14,121,43,69,184,69,96,43,207,136,99,82,7,31,179,233,69,12,171,57,37,93,84,173,187,190,55,251,223,235,98,60,21,33,28,76,20,220,56,70,168,23,99,38,20,120,126,218,30,198,111,216,230,112,167,154,152,182,113,218,85,209,110,206,234,193,169,40,165,50,118,83,144,189,167,238,225,182,209,48,11,110,94,130,104,108,31,171,113,223,195,16,217,9,207,26,235,8,12,176,224,195,139,238,184,30,182,73,86,134,89,24,89,206,127,134,199,142,30,125,167,15,158,37,92,57,85,104,117,216,25,61,161,70,36,49,105,224,216,211,95,119,172,132,136,188,72,40,202,28,108,180,204,160,255,64,248,187,238,6,105,202,94,174,194,105,219,152,172,78,183,192,55,175,76,157,94,96,144,96,7,83,39,95,141,103,75,159,77,176,134,252,184,250,146,217,238,67,118,237,101,211,8,173,5,241,56,187,39,153,245,170,157,233,129,220,225,184,33,110,7,140,105,167,176,221,96,232,41,1,224,194,43,175,250,51,252,171,33,161,251,27,17,26,125,116,160,93,61,6,178,74,182,186,89,18,184,197,216,147,86,127,237,228,32,34,49,198,150,33,98,148,109,248,87,150,17,240,6,29,35,236,218,121,189,63,222,128,217,231,95,102,2,255,82,2,76,18,35,240,85,91,101,246,172,68,150,65,124,47,223,28,162,202,231,35,200,242,27,154,71,2,146,182,164,120,125,143,189,157,36,239,206,239,208,61,254,23,66,128,117,95,179,169,10,16,205,47,206,108,218,108,61,14,98,158,27,199,141,237,106,250,141,37,88,154,200,213,49,123,116,170,213,63,129,220,245,47,140,76,134,126,76,121,64,246,87,38,107,106,214,80,55,27,96,151,128,238,40,160,221,188,126,219,242,130,125,46,10,199,17,131,178,169,183,132,24,25,98,204,36,135,29,220,191,207,83,8,118,202,172,142,50,120,8,123,140,53,119,49,79,118,80,218,248,60,198,146,131,223,40,21,107,183,113,235,100,229,46,73,180,210,152,203,196,19,216,161,100,46,144,206,114,70,92,211,166,215,93,170,177,8,235,223,108,119,159,55,109,82,151,7,160,241,55,249,69,212,177,19,123,171,95,41,241,151,90,71,173,81,34,21,78,216,27,219,108,233,238,159,110,169,128,233,156,10,60,10,227,5,144,20,192,210,237,163,123,121,215,216,72,184,133,124,136,78,126,176,46,133,220,61,225,184,26,83,87,245,9,185,75,91,221,219,19,7,240,76,178,176,157,36,145,194,88,129,20,235,253,245,207,24,131,237,209,17,218,129,123,236,141,104,172,32,15,37,112,178,156,115,85,137,25,211,147,50,202,193,105,250,160,183,128,196,92,237,217,40,189,239,219,171,7,159,243,182,10,111,31,149,156,246,168,123,248,233,111,22,199,109,241,221,157,225,251,243,71,172,217,139,126,180,108,237,206,0,242,156,220,53,137,192,17,68,120,121,135,238,117,7,107,250,7,237,66,118,94,83,186,37,182,59,94,211,35,227,188,10,125,89,73,117,212,60,17,105,226,29,97,132,173,253,34,61,207,46,225,202,14,45,36,163,154,191,204,82,199,99,143,218,13,211,98,248,199,86,114,167,184,185,109,107,140,38,241,220,84,12,11,103,109,41,124,203,220,180,93,52,249,226,195,129,143,114,171,12,56,8,181,96,59,221,115,229,126,96,222,194,209,95,186,123,128,250,204,20,254,92,227,67,98,90,76,156,40,180,26,154,26,57,201,173,77,15,115,142,170,162,66,228,194,139,53,179,110,188,48,71,0,108,39,72,86,113,106,201,0,209,33,202,20,172,251,172,149,84,196,221,186,68,8,88,60,5,5,252,195,55,223,241,237,184,94,74,220,205,34,96,184,194,10,165,75,148,165,223,133,205,137,246,236,241,36,91,10,4,174,252,126,87,240,202,28,187,229,8,95,195,85,237,192,227,67,145,206,143,39,69,92,40,75,12,215,127,133,157,216,86,193,252,216,217,35,227,9,246,6,252,12,73,116,232,242,112,60,166,181,155,134,186,52,198,168,250,111,238,242,229,60,42,250,197,165,189,143,49,67,68,85,82,73,18,248,188,28,215,101,226,30,196,67,168,73,54,15,80,192,58,8,18,229,216,248,163,57,242,52,107,109,188,16,64,94,5,54,245,40,115,162,177,91,39,127,205,93,183,40,55,251,197,234,33,94,76,230,86,185,60,197,217,199,170,117,142,216,11,13,178,168,243,13,194,170,183,228,2,89,44,235,170,75,222,134,111,142,200,75,176,194,239,83,230,168,61,111,202,65,102,131,154,113,205,165,165,128,95,56,56,141,165,185,22,217,137,253,195,50,150,207,135,100,33,155,193,69,234,72,59,176,242,178,45,199,66,175,125,141,27,49,96,37,26,238,156,59,96,240,198,42,175,5,1,14,170,159,11,52,32,235,164,169,163,97,133,51,14,189,75,118,24,152,189,134,235,157,50,183,76,82,226,205,226,88,80,238,181,56,117,47,163,181,249,146,58,211,227,107,159,251,146,79,108,111,72,219,190,18,105,185,242,187,30,247,18,89,208,26,20,208,229,178,124,241,189,228,205,237,220,68,51,136,215,193,142,58,55,58,82,38,187,96,41,59,74,146,55,76,112,49,229,39,239,245,38,236,201,75,32,169,31,223,140,31,183,179,205,22,178,13,246,251,43,144,112,147,133,37,102,216,137,57,57,44,36,75,183,118,15,98,213,92,45,248,23,44,65,232,178,226,96,53,22,248,25,228,62,237,144,83,120,149,16,69,100,80,43,59,37,102,152,245,139,240,217,109,231,139,222,176,9,221,128,40,106,226,218,81,241,109,86,72,187,2,165,227,232,180,141,241,162,185,74,117,121,46,165,253,113,255,20,57,218,151,124,11,73,60,131,154,69,0,104,191,39,199,51,26,38,153,203,137,191,168,53,238,82,183,168,3,191,3,24,178,70,54,136,201,41,12,235,30,198,165,101,241,99,255,204,80,127,231,211,225,87,41,217,162,135,67,51,62,224,135,7,129,138,150,45,69,227,227,90,66,150,61,156,228,64,58,114,168,113,146,0,236,236,17,205,193,70,73,108,189,170,254,254,65,211,57,82,251,139,51,41,182,71,233,164,56,17,54,233,58,220,179,242,110,159,240,68,6,53,215,195,170,76,216,44,218,76,55,200,90,53,226,14,83,10,131,112,136,68,94,140,3,122,106,29,137,161,207,34,188,179,34,214,222,44,105,178,93,160,236,190,112,214,227,239,12,196,49,63,248,87,164,150,200,66,172,71,9,49,136,52,167,57,95,128,225,228,113,192,51,125,1,36,58,157,255,113,61,150,173,109,87,181,129,172,146,35,40,1,209,36,26,78,86,96,125,134,252,148,252,21,221,216,245,112,116,72,87,188,254,184,160,80,150,16,233,106,61,253,109,162,183,23,78,12,114,0,151,213,20,241,232,136,20,56,71,204,230,248,53,65,18,225,119,16,126,140,203,49,155,116,221,220,176,43,173,91,148,67,171,176,204,208,109,147,72,84,96,64,27,119,10,126,206,75,244,13,91,231,35,83,100,56,30,203,15,179,54,103,191,130,29,99,17,144,129,49,56,91,37,255,134,107,213,9,134,212,249,4,250,236,79,103,193,144,196,191,23,165,254,4,75,55,129,117,31,143,159,169,9,240,21,41,49,197,8,234,171,211,160,173,78,17,99,76,3,187,103,204,12,129,236,42,46,188,199,141,12,57,183,246,223,26,155,206,186,116,54,87,50,75,68,21,35,89,237,56,156,145,2,142,240,244,137,187,29,99,14,132,26,150,7,74,245,110,152,240,176,221,174,145,32,80,104,172,1,26,57,70,82,128,240,43,73,255,48,32,217,19,100,55,137,85,181,153,231,226,191,86,126,56,114,242,100,136,246,122,217,233,251,48,45,204,93,1,4,56,231,191,64,88,49,225,41,143,145,65,214,179,141,41,161,53,114,171,245,183,102,255,185,67,52,62,146,197,201,41,83,196,137,226,193,105,167,176,212,3,210,69,219,255,148,40,13,193,65,54,24,66,235,143,165,253,193,60,174,46,236,62,237,100,227,88,253,237,250,233,75,166,70,240,114,42,175,25,191,105,139,112,41,193,131,187,42,198,252,4,90,96,68,11,239,56,225,181,239,15,140,198,81,6,103,216,43,9,24,167,36,160,199,81,154,117,69,13,87,118,24,153,182,16,129,162,242,110,120,22,180,137,138,32,232,238,208,111,31,91,61,83,240,90,30,203,134,201,187,175,24,196,141,105,188,1,113,105,182,67,109,45,17,122,160,2,75,24,227,85,112,237,74,105,205,128,45,144,196,26,55,113,28,97,75,53,62,75,38,152,138,191,171,102,137,129,20,28,174,9,223,174,168,217,132,253,242,174,213,30,148,110,7,116,223,109,32,59,52,104,133,161,172,58,243,249,220,139,158,0,33,150,163,113,52,237,66,200,229,220,126,228,121,185,35,138,160,110,16,40,83,133,208,79,255,235,209,9,192,133,98,74,60,119,184,192,36,125,75,251,84,27,36,111,240,31,203,194,197,142,208,122,34,240,15,72,100,91,9,198,222,177,215,155,232,116,184,46,153,21,40,2,44,195,56,91,194,168,136,87,5,40,196,188,53,35,67,126,234,14,32,140,147,186,52,237,160,91,32,7,84,197,243,43,125,212,12,90,193,137,44,175,102,11,116,151,84,41,184,246,172,138,124,50,61,227,238,38,144,162,4,96,34,210,127,192,75,76,207,170,17,70,160,101,136,32,124,212,8,248,239,65,103,64,86,16,29,104,136,205,128,11,242,58,250,237,206,160,14,155,148,54,57,156,222,205,198,10,165,97,223,51,131,25,23,241,34,123,110,242,85,236,39,210,133,69,32,118,74,115,200,125,160,37,174,121,229,134,15,154,71,240,151,226,131,251,112,236,167,8,142,21,121,74,113,140,96,36,121,80,26,18,185,94,55,104,241,239,238,36,41,59,114,83,28,120,114,167,226,220,214,253,186,191,161,48,166,172,171,193,198,69,27,92,12,75,94,193,146,8,18,240,49,255,203,158,99,237,56,62,147,235,89,234,17,224,137,212,148,85,7,94,198,97,110,155,184,17,79,43,203,43,141,194,4,139,114,208,237,139,41,17,224,192,238,122,143,229,92,29,93,62,42,56,121,92,162,202,113,221,26,151,83,100,210,52,226,80,123,65,236,207,2,245,126,162,235,190,11,138,137,55,205,72,77,145,226,185,68,37,11,202,156,213,148,67,144,236,80,187,114,96,212,39,50,95,2,182,201,64,9,34,176,212,42,212,9,178,9,73,114,114,145,113,190,145,234,41,96,229,254,166,74,118,26,228,66,191,102,43,229,129,173,122,48,41,110,184,142,89,41,13,164,135,116,200,166,37,36,46,29,25,160,31,211,182,48,172,72,42,25,92,59,124,239,155,144,53,128,197,138,233,90,44,125,119,58,1,21,152,196,192,222,130,86,133,83,72,201,117,200,52,124,195,156,18,54,65,85,50,50,66,105,225,242,107,144,104,177,228,145,77,9,171,25,24,2,26,21,223,72,104,33,231,164,251,194,13,11,191,229,3,177,124,181,176,206,215,223,189,24,103,85,25,91,155,76,251,192,128,47,249,20,180,60,96,194,241,64,42,45,255,135,237,144,21,137,163,22,62,104,201,195,66,161,209,55,41,201,37,27,138,141,56,162,92,254,128,200,91,3,164,94,74,123,44,195,172,115,140,223,243,166,110,72,56,58,183,188,190,55,107,222,150,75,194,194,240,244,117,19,20,83,241,29,62,18,25,198,247,236,231,243,207,13,229,175,97,154,167,162,168,181,108,254,6,234,234,107,226,204,28,238,181,211,130,246,112,76,188,138,200,133,166,109,106,131,19,85,116,143,76,88,178,115,122,212,69,46,239,115,45,13,190,164,59,58,147,149,76,13,104,79,25,180,113,170,105,240,37,155,128,167,55,16,29,119,157,178,8,35,180,242,122,142,24,120,170,4,27,141,98,21,208,229,199,216,43,67,141,168,73,138,231,14,170,171,226,62,180,197,52,71,204,200,50,192,176,74,70,104,117,25,201,254,64,195,101,196,228,247,240,119,90,101,85,2,201,66,42,167,59,162,91,144,54,159,160,120,255,63,236,162,174,187,241,20,134,211,23,252,20,29,185,232,23,61,226,13,75,40,25,165,228,252,158,133,247,157,134,52,94,163,214,59,21,187,42,20,55,12,114,64,234,209,220,139,216,76,234,91,62,71,30,233,123,109,148,240,183,8,10,78,113,254,120,152,27,114,150,19,148,112,36,16,255,144,90,50,36,177,86,112,49,76,225,119,233,17,10,134,28,197,14,90,131,58,177,168,210,226,219,17,208,234,92,27,180,129,13,36,59,2,210,145,32,135,152,95,209,163,21,70,128,21,93,234,109,85,72,78,224,164,133,149,105,16,252,67,108,0,178,223,75,148,119,131,29,60,214,125,81,222,231,102,35,102,86,130,254,182,147,46,209,206,52,219,148,88,84,140,167,46,255,110,8,31,40,217,194,3,46,16,208,191,123,162,173,142,70,195,188,108,153,101,62,69,146,4,59,230,57,79,88,208,24,238,186,145,189,250,38,175,161,195,41,1,201,30,6,120,188,85,233,105,185,157,161,13,26,168,39,52,44,126,62,68,64,251,132,5,240,138,118,125,153,69,34,99,153,40,154,13,232,209,195,122,87,152,20,184,112,206,80,215,36,63,2,234,51,164,74,29,80,125,187,246,97,110,185,21,164,197,93,15,22,253,122,81,57,185,170,25,80,172,143,63,150,86,187,160,223,245,70,174,194,154,101,95,117,27,19,209,163,100,231,145,241,129,177,24,111,224,240,115,62,85,133,160,49,22,135,50,194,217,167,77,90,69,33,15,87,22,217,248,251,139,111,89,175,70,46,176,72,194,29,201,119,136,80,76,82,96,240,217,134,121,187,198,147,131,253,13,121,67,66,255,179,251,209,175,189,114,50,70,202,217,24,240,2,28,120,112,21,38,128,220,90,244,47,197,152,218,206,69,50,23,169,42,197,45,131,131,180,113,28,57,193,197,86,137,26,204,45,171,21,24,167,14,201,102,142,74,130,76,18,102,95,32,132,222,204,236,171,191,178,110,175,153,167,144,156,91,80,146,23,173,85,21,239,254,147,227,56,108,7,51,211,111,171,7,136,176,180,222,15,80,211,67,99,224,217,17,251,196,172,130,164,52,58,131,160,122,142,127,195,91,134,197,231,241,90,198,235,210,10,9,59,93,128,47,168,162,241,95,159,34,17,134,131,74,34,173,229,103,195,195,181,142,231,23,69,126,128,64,108,235,3,79,164,163,22,163,114,27,86,200,9,154,29,61,27,215,124,142,124,73,193,127,61,115,190,211,181,31,165,179,68,249,203,35,126,13,45,112,224,133,60,98,255,23,89,245,112,22,19,213,32,157,40,46,187,191,144,134,243,215,69,97,59,26,211,185,116,37,50,69,161,197,14,186,2,149,244,240,77,80,243,43,119,78,28,16,171,146,5,219,28,29,209,119,45,244,253,208,134,119,133,223,195,153,36,128,130,141,166,27,14,36,16,59,124,107,190,162,174,17,232,66,210,4,215,218,74,205,198,177,53,234,94,43,67,10,53,23,173,118,235,190,193,174,207,84,152,211,166,105,119,55,82,146,52,145,131,247,249,51,45,78,32,69,196,4,113,86,245,69,252,8,30,147,234,251,80,155,168,167,235,68,23,199,63,146,14,186,152,56,151,178,239,255,7,224,250,142,230,32,103,176,186,158,234,248,203,136,150,1,28,72,37,6,115,122,38,235,3,253,157,189,178,55,185,99,148,164,245,22,189,86,242,51,248,123,34,206,106,249,15,2,4,165,184,28,86,21,218,130,199,238,44,130,177,144,54,205,104,150,170,224,148,65,184,236,229,176,118,242,15,166,225,31,107,33,194,72,192,18,193,136,197,87,174,32,66,71,53,82,245,232,197,35,237,85,206,110,68,249,166,242,153,236,90,175,6,41,24,49,240,254,62,198,117,239,101,177,14,170,210,183,23,6,113,77,195,20,191,137,92,120,19,157,101,93,83,78,37,79,235,150,249,14,194,60,126,145,109,49,156,237,62,56,18,23,151,127,216,89,52,148,83,223,3,216,152,88,125,80,239,181,239,172,51,167,98,226,50,247,206,120,247,25,206,54,150,206,6,185,55,119,91,159,12,51,198,134,107,147,217,175,208,202,92,84,159,58,67,0,118,87,174,146,250,59,10,238,105,61,231,240,91,19,199,115,234,8,61,29,115,241,112,205,150,15,190,57,225,100,187,104,78,158,155,251,80,15,6,138,219,106,98,224,11,136,134,164,166,83,26,84,234,47,220,242,119,186,158,190,178,215,61,174,150,192,104,208,25,39,226,119,126,0,236,132,133,94,45,72,208,100,62,242,198,166,167,56,213,236,74,201,217,16,13,138,174,24,174,64,131,76,100,35,118,240,120,194,38,232,131,203,9,118,98,64,171,12,62,223,211,20,153,224,165,130,22,29,94,159,227,25,53,234,68,217,105,40,47,57,1,247,199,163,55,211,128,172,232,136,145,65,112,168,0,219,198,83,128,195,144,32,226,150,2,53,244,14,104,125,90,189,124,140,39,77,191,85,131,199,27,87,187,146,200,195,123,151,132,4,2,164,68,5,161,216,73,253,157,89,106,238,222,98,136,198,229,176,205,79,98,122,228,37,187,60,7,164,229,240,162,144,218,225,188,197,49,8,70,89,48,55,133,80,162,245,154,63,127,237,102,210,213,243,65,32,100,44,99,138,185,103,245,51,233,165,94,110,30,148,127,12,200,52,153,115,230,220,52,125,75,92,242,232,140,150,157,56,249,183,220,213,54,84,246,6,20,134,144,65,209,173,100,110,205,118,158,133,204,15,123,166,26,250,100,215,1,216,219,240,191,93,55,231,148,227,95,133,66,25,212,164,52,35,202,222,167,237,32,26,18,76,43,180,205,221,234,70,160,31,222,245,60,159,249,158,199,254,163,77,205,58,236,46,162,226,42,173,153,131,78,131,221,112,255,21,8,15,215,253,81,218,8,14,108,192,35,77,128,95,230,243,128,27,19,161,40,160,130,95,26,121,228,199,70,229,64,20,253,236,88,136,115,158,8,134,143,89,207,75,239,97,98,239,101,208,87,184,150,165,246,23,116,59,218,142,41,218,173,5,243,242,139,69,140,205,28,53,166,30,124,32,104,240,149,168,32,180,83,166,138,174,220,10,30,126,156,40,23,193,120,154,221,95,63,117,211,212,192,240,104,236,111,177,133,128,239,40,71,65,51,235,239,26,140,191,128,103,85,100,143,211,160,224,57,139,229,169,176,249,250,31,213,122,65,30,14,66,108,145,111,178,225,249,25,9,6,90,105,83,157,56,231,142,106,18,51,107,2,242,210,23,182,121,234,222,85,160,45,37,181,241,47,243,38,61,122,141,159,78,76,100,183,159,127,118,14,54,122,2,77,221,42,129,224,164,110,233,91,114,55,12,94,214,173,75,198,50,132,160,107,109,161,181,115,160,245,23,34,218,107,205,30,208,48,119,208,17,253,104,165,243,87,48,25,18,179,104,89,247,109,252,218,101,6,215,43,14,189,143,57,76,220,180,233,253,157,22,172,221,227,59,152,198,89,51,241,40,60,246,89,160,72,231,178,75,252,162,246,163,64,74,44,42,81,89,207,76,224,34,239,58,148,35,180,150,137,248,78,158,76,146,91,78,225,173,113,80,98,12,199,250,151,24,194,248,226,254,221,104,188,226,4,176,35,1,140,53,5,147,216,33,79,140,85,132,91,40,150,116,94,25,150,207,240,185,108,234,104,124,126,168,2,110,131,67,172,174,50,198,188,215,61,178,22,163,227,190,41,144,243,192,20,125,74,143,254,25,99,142,132,243,114,68,23,241,228,66,108,155,24,14,76,138,2,38,124,50,118,246,185,47,114,251,215,235,250,240,119,123,145,179,188,213,84,149,173,182,48,104,187,15,99,21,121,48,192,124,148,178,60,107,92,175,114,226,197,62,130,89,41,225,0,116,50,59,38,26,165,29,220,66,143,237,131,54,192,103,64,192,125,49,53,193,54,174,147,130,96,141,97,205,92,95,70,84,18,251,107,72,76,215,255,108,128,169,246,193,217,180,73,146,252,19,64,57,15,74,18,109,34,36,187,65,226,42,59,57,164,178,16,103,131,123,238,98,12,101,234,237,103,190,103,254,112,7,99,179,27,102,58,210,83,234,226,10,174,119,50,149,45,134,101,101,56,158,115,13,197,17,194,129,244,84,159,158,127,202,210,72,247,45,46,85,163,12,185,58,155,119,111,253,36,114,237,176,65,216,206,245,24,222,30,196,247,106,51,159,176,236,196,255,7,84,7,125,173,187,180,213,54,164,222,178,253,111,207,56,160,157,76,251,134,6,123,106,43,112,56,22,56,121,232,78,77,217,185,204,235,159,51,160,119,104,198,83,36,170,71,255,175,246,37,200,225,224,247,110,248,49,225,255,230,72,173,52,122,35,160,111,116,68,116,142,201,97,10,155,138,34,210,218,165,125,81,195,186,198,203,159,90,180,44,81,61,30,21,206,222,68,222,191,219,40,100,99,7,23,138,195,183,71,243,152,172,215,111,148,100,2,111,215,210,19,206,92,247,54,40,211,178,195,157,144,119,253,242,25,7,108,65,242,78,122,4,165,192,59,138,33,201,184,66,235,51,71,10,249,83,242,119,69,148,43,72,121,141,66,250,119,91,191,216,133,118,135,50,253,196,8,157,217,191,4,145,157,32,193,49,23,227,129,2,12,161,43,240,36,32,240,235,186,130,80,164,62,166,40,133,113,154,254,122,47,9,74,204,125,28,111,86,108,21,229,132,254,64,121,67,44,228,130,85,151,59,35,189,169,84,37,193,1,159,29,147,73,228,238,14,170,33,97,217,137,16,3,232,101,178,162,117,172,83,161,151,186,51,249,246,64,25,233,238,219,1,50,26,242,62,89,30,12,5,160,45,58,56,175,215,141,136,111,209,229,91,96,78,124,89,4,177,120,212,37,152,139,45,66,16,136,190,152,207,94,253,62,141,189,3,248,231,179,116,188,155,225,71,3,2,51,236,86,28,153,117,253,18,167,122,45,214,229,129,15,96,233,74,154,68,128,85,111,239,12,106,109,2,51,112,9,107,123,171,52,193,22,91,206,72,155,33,21,67,10,212,214,212,110,64,115,154,77,69,79,177,136,196,193,21,42,18,182,92,23,74,139,248,28,240,21,96,155,182,205,88,106,147,104,113,109,99,89,25,197,102,228,183,78,108,143,132,154,25,159,11,234,55,121,187,208,169,98,55,192,240,185,94,38,220,247,237,2,78,28,178,178,173,168,106,216,46,11,169,60,55,164,188,40,236,55,255,98,158,188,31,9,168,30,213,142,65,187,37,208,20,28,118,43,214,119,152,217,1,250,46,24,49,156,140,46,208,233,89,226,247,88,28,155,223,71,185,92,109,186,43,3,44,23,225,237,246,99,184,241,170,196,74,37,85,128,106,67,131,30,0,169,167,34,84,193,19,165,115,195,40,29,183,112,27,122,4,90,22,216,46,36,86,30,190,106,150,8,172,58,62,129,56,30,175,228,229,115,194,135,103,104,20,50,6,196,127,157,114,54,181,183,194,89,166,82,248,180,176,18,96,0,119,167,225,10,114,246,215,28,13,116,60,208,194,2,93,80,166,135,54,136,152,116,136,225,234,219,241,34,216,226,33,245,84,217,83,121,52,121,240,104,207,36,166,239,205,151,202,175,164,18,21,116,243,49,170,144,89,225,88,178,126,64,150,67,79,72,148,104,223,229,108,127,199,137,148,52,170,60,207,152,156,144,104,241,188,244,212,20,50,60,115,189,98,1,43,236,202,44,224,232,183,150,236,105,43,88,161,137,78,36,116,61,135,209,120,124,53,26,143,84,203,133,42,191,18,191,53,27,24,159,135,40,171,19,239,227,166,26,151,249,82,226,93,195,3,20,0,197,173,219,120,132,114,130,232,10,36,139,230,24,179,84,104,226,228,122,187,184,48,141,176,84,102,72,90,40,216,6,234,148,196,191,220,135,118,116,11,117,87,226,206,87,150,97,149,206,225,147,121,201,32,205,231,146,163,50,36,98,163,237,36,81,206,193,166,70,126,86,117,27,132,21,213,235,246,228,14,242,123,212,0,223,30,4,174,7,188,123,213,20,193,115,205,248,146,9,133,186,44,88,57,236,41,158,72,14,26,206,225,124,101,250,131,43,225,215,99,33,113,75,60,151,77,125,39,141,44,221,222,195,210,17,195,196,115,254,249,157,14,72,140,16,160,105,89,66,10,33,0,178,190,186,221,149,102,2,94,143,217,127,98,190,136,141,254,215,167,33,183,112,241,199,13,202,107,111,44,45,14,144,133,156,156,126,252,165,202,121,218,39,66,242,228,104,64,171,156,112,183,39,150,149,47,63,155,219,180,152,21,218,84,117,191,182,210,225,171,63,25,200,44,26,81,77,99,18,228,175,249,210,159,182,189,188,109,4,198,131,189,50,200,194,174,159,14,10,158,192,153,126,222,230,187,122,30,104,71,153,3,243,254,34,136,71,237,218,237,187,154,22,237,220,72,60,39,14,40,62,198,78,251,51,112,165,191,123,114,23,128,65,68,229,71,50,216,218,89,36,216,13,157,38,134,76,137,60,101,59,197,15,72,199,24,137,139,60,153,168,197,250,135,22,236,216,122,8,177,223,43,8,38,152,40,232,185,21,82,19,143,125,160,153,84,88,211,174,62,38,6,91,90,204,136,246,253,191,124,193,32,157,73,81,0,168,196,149,73,183,170,80,21,242,204,71,29,111,103,13,110,119,194,204,230,131,166,236,195,191,145,116,22,238,250,41,15,199,56,234,26,132,88,38,32,176,57,83,161,217,199,197,102,128,195,131,41,92,145,99,151,86,81,43,245,255,70,91,3,241,33,123,138,16,188,168,162,16,249,80,147,198,41,121,246,202,206,235,112,37,159,244,115,32,140,156,45,58,227,210,238,129,211,120,206,101,81,26,187,103,4,164,210,237,155,30,27,170,173,71,126,77,140,65,108,28,119,185,238,95,155,200,104,236,25,79,89,185,3,54,235,41,221,146,214,41,108,67,7,177,72,165,166,29,38,254,199,203,198,205,106,128,87,61,116,200,164,41,198,108,185,194,233,174,5,247,9,198,250,240,66,90,81,48,218,44,120,4,134,50,177,55,173,103,62,46,199,243,41,11,178,22,183,88,171,72,162,26,179,205,121,252,151,184,119,109,244,173,254,127,216,72,106,151,162,23,40,177,4,148,33,125,147,248,226,29,171,131,232,31,4,143,179,7,199,164,180,253,216,190,202,214,15,23,24,77,51,32,125,82,142,237,217,86,135,223,151,44,94,126,91,38,208,248,33,103,217,212,128,95,48,202,143,173,46,176,190,183,152,104,34,250,128,191,135,36,25,45,171,53,234,32,2,230,2,108,237,56,27,238,186,155,177,140,10,242,132,134,86,192,52,252,179,43,150,96,160,33,21,33,221,142,45,220,82,243,168,222,130,37,222,22,245,160,125,10,23,122,35,233,186,114,200,103,52,168,133,48,61,115,168,49,189,2,69,217,96,240,35,65,78,102,192,33,90,76,94,122,155,245,110,138,88,234,223,39,239,101,89,85,30,32,54,85,87,26,197,174,58,148,186,19,179,170,144,194,68,73,228,192,82,67,163,64,191,210,176,150,88,199,67,213,229,176,12,59,169,107,122,187,20,130,133,176,254,178,185,101,98,58,19,228,18,238,208,179,35,89,248,56,195,62,99,102,230,68,20,139,214,150,124,144,134,27,183,202,21,182,208,93,74,234,203,183,36,84,65,184,208,48,69,135,11,228,113,43,235,175,160,32,79,186,131,120,18,150,43,192,224,48,165,144,44,215,196,95,124,157,245,34,118,84,159,229,53,245,183,36,27,35,224,132,163,108,104,242,207,53,125,35,215,184,155,72,105,175,105,140,196,76,117,30,42,24,191,51,14,52,245,110,154,34,141,150,168,32,135,182,42,148,27,179,35,127,13,192,234,28,68,10,113,206,12,21,113,38,63,193,122,249,190,185,234,132,63,63,241,223,33,232,10,245,11,99,25,95,153,109,55,126,102,135,167,125,148,222,148,102,248,36,249,176,99,114,57,136,72,229,80,103,232,171,4,58,69,153,152,254,14,145,109,223,210,83,24,129,25,49,145,168,139,218,91,8,203,79,17,122,138,99,49,184,190,173,151,87,14,76,118,121,10,202,237,176,214,93,134,246,205,106,142,8,229,30,19,102,181,198,40,92,98,189,157,88,95,22,21,215,170,123,30,155,211,227,86,26,147,42,56,27,49,44,127,155,81,221,229,27,104,185,213,8,219,3,245,141,205,159,59,227,48,224,57,169,228,116,130,129,158,78,92,47,82,24,202,56,43,60,160,255,15,181,78,52,148,211,156,16,68,69,82,109,62,167,60,142,147,194,237,177,193,138,158,58,86,226,9,83,92,219,241,91,208,141,158,200,146,100,46,21,28,176,202,20,210,50,170,84,88,35,119,187,11,55,99,52,134,134,77,22,208,137,163,199,185,150,148,136,177,3,104,250,254,33,72,65,14,75,254,9,115,152,207,24,60,165,192,90,253,118,109,2,200,214,170,249,25,62,172,4,41,65,61,226,18,22,6,78,151,215,116,157,159,20,232,168,7,176,108,122,179,3,71,229,30,93,32,17,173,207,25,224,199,82,197,128,129,130,124,10,51,150,76,207,128,218,154,242,193,62,62,125,222,4,188,70,47,229,254,87,65,151,83,117,84,159,36,241,100,44,35,236,230,118,156,252,185,108,116,190,98,18,28,113,63,24,123,201,183,239,36,147,154,45,48,180,73,118,176,91,80,16,66,104,110,198,55,26,218,245,155,173,59,69,127,173,178,125,196,61,111,100,244,178,244,145,69,92,98,174,39,80,57,197,8,59,77,84,103,236,76,76,231,220,18,8,169,224,223,128,123,223,128,104,228,239,10,76,248,149,63,41,190,126,185,177,118,84,115,189,37,107,213,120,77,144,195,133,31,157,96,0,169,20,155,30,205,33,77,249,41,6,214,249,184,184,237,5,139,144,27,40,114,235,23,32,34,166,246,83,22,106,177,48,21,57,139,57,37,182,247,242,255,26,254,208,203,80,161,102,174,20,165,5,158,154,40,111,29,136,198,67,81,147,192,155,241,203,0,148,216,138,76,239,166,46,111,149,56,214,58,165,52,162,129,147,141,8,145,186,41,60,201,95,3,218,149,113,153,10,100,255,75,185,59,60,90,212,88,134,53,110,189,255,31,101,12,118,16,225,235,249,81,63,72,250,78,246,248,123,207,12,44,52,232,232,155,128,81,240,252,134,112,156,12,83,23,198,44,146,182,147,65,46,112,223,129,212,253,5,218,89,236,70,121,74,193,176,157,230,32,25,172,157,14,95,113,107,226,181,47,99,139,12,247,98,179,109,75,37,43,232,99,40,64,94,192,181,75,145,156,244,16,186,15,112,142,52,9,64,136,237,201,118,121,85,105,39,180,196,66,117,132,203,236,145,254,166,126,208,13,206,48,245,21,227,26,88,198,220,181,125,124,86,131,61,79,27,103,196,49,53,120,122,65,138,32,212,146,33,225,94,53,142,159,102,61,186,65,188,177,138,2,157,236,18,122,77,75,39,187,34,124,232,240,52,34,22,32,40,53,215,110,133,184,85,191,92,254,195,226,250,233,252,90,134,193,103,229,12,39,14,182,212,79,163,152,86,86,101,13,70,85,65,141,200,137,103,124,189,167,148,206,115,40,203,236,46,136,27,74,115,73,241,87,41,26,69,253,255,157,255,204,155,53,219,6,250,86,45,3,107,239,17,229,40,49,18,76,72,147,100,155,194,244,177,13,49,65,183,105,25,55,227,158,135,172,30,144,106,24,247,106,194,212,31,172,249,224,164,35,98,135,173,74,73,221,34,60,233,163,99,6,194,46,130,141,180,117,138,18,153,202,4,89,17,30,99,134,63,118,218,212,1,190,22,222,199,118,98,33,41,130,96,40,79,160,35,65,142,137,153,66,5,8,122,217,48,254,148,229,167,255,125,74,211,190,234,90,113,149,216,236,234,94,164,254,18,89,35,68,89,21,55,37,71,146,157,235,42,143,252,246,96,50,42,41,56,145,46,235,203,171,103,108,126,242,213,18,97,160,214,58,250,182,233,174,80,130,159,210,250,102,161,63,215,70,212,18,50,106,26,91,177,51,195,199,161,165,64,14,45,178,206,43,228,216,171,167,203,108,255,115,188,113,236,99,10,111,13,0,81,180,89,130,230,42,161,248,252,189,186,168,166,229,24,160,33,34,74,198,142,183,219,200,120,139,253,142,130,56,15,125,12,228,86,90,80,99,178,97,249,192,178,243,211,51,200,208,87,99,63,45,16,94,33,45,195,244,122,204,152,42,147,178,193,70,80,47,162,161,7,159,94,194,21,6,126,43,73,102,19,224,248,66,179,51,60,239,253,235,123,214,231,163,202,47,88,108,56,77,98,154,122,188,6,59,154,4,199,49,208,228,143,173,50,243,217,56,163,48,225,166,135,107,255,44,61,173,130,104,191,216,228,96,69,253,45,250,201,32,18,177,148,69,204,98,84,17,190,81,10,67,80,15,171,13,93,180,6,0,43,160,106,66,96,216,42,162,221,29,34,225,175,19,240,186,178,237,125,93,98,200,99,207,153,148,156,218,94,91,116,123,221,54,153,29,58,86,167,179,169,206,84,241,41,60,79,155,4,137,116,17,102,0,192,142,86,44,172,126,19,55,179,48,107,250,139,246,195,160,228,133,244,0,104,174,127,16,249,59,193,170,113,161,214,75,106,138,84,250,69,53,198,169,185,23,245,221,141,234,124,28,7,194,237,56,1,188,224,15,254,64,101,181,183,83,30,75,200,219,220,53,136,210,81,203,78,143,131,52,33,91,157,141,245,95,226,178,200,94,59,167,33,54,242,210,77,140,245,107,232,26,90,252,132,123,206,236,19,2,130,75,88,229,148,185,94,150,112,221,37,163,187,205,178,88,127,13,186,11,43,125,142,29,176,117,21,161,6,76,91,42,88,231,10,120,203,125,210,192,23,208,138,14,131,142,34,154,160,52,29,222,79,199,111,36,181,225,79,33,33,112,19,200,126,68,231,236,54,133,146,4,41,228,231,249,132,13,93,93,149,13,227,176,10,134,115,107,123,200,131,229,198,115,26,214,113,97,167,58,231,216,155,7,140,185,106,196,56,76,105,82,136,42,76,80,181,33,59,175,27,45,149,210,218,76,168,13,202,216,102,41,232,6,195,154,197,234,50,100,76,156,73,176,73,111,139,191,38,112,37,241,223,131,92,177,137,218,253,40,76,240,216,3,204,223,7,151,248,149,197,172,194,139,254,65,161,48,14,50,3,66,251,12,95,167,190,71,144,187,0,213,61,87,159,7,233,119,14,181,155,98,72,136,122,143,56,154,60,93,198,177,205,44,103,95,116,113,152,26,13,143,68,194,101,26,68,62,235,45,185,74,34,255,187,99,137,104,115,115,70,110,64,150,30,166,114,21,234,198,46,142,211,228,162,205,78,214,242,176,66,164,131,35,120,175,236,71,0,54,40,114,205,253,190,185,190,4,67,196,175,156,104,26,163,50,11,35,251,35,80,229,251,76,44,160,113,224,224,9,23,52,82,47,162,80,104,125,202,254,209,144,39,102,142,205,224,55,225,123,151,6,39,158,13,69,31,67,131,254,194,189,204,164,147,43,29,122,153,51,181,50,64,110,185,204,169,163,245,50,158,16,251,173,71,114,40,142,151,235,197,48,6,224,41,90,55,168,33,109,238,40,163,3,97,5,126,196,96,219,105,169,182,196,109,98,145,178,233,47,14,174,13,240,241,108,211,146,220,70,168,104,14,230,144,231,117,218,101,198,173,18,226,47,51,175,131,41,40,35,57,247,229,35,100,186,132,211,135,99,234,210,19,62,65,131,184,193,171,145,246,21,6,33,139,122,70,147,100,237,178,123,198,80,144,41,7,159,118,220,191,219,190,198,65,220,198,34,19,98,199,161,141,23,249,111,204,244,193,23,17,252,113,128,48,238,2,172,81,86,184,51,148,248,184,127,200,135,224,59,2,114,69,175,162,249,247,184,168,171,221,61,178,13,48,107,136,96,151,245,240,205,248,111,238,35,69,138,76,130,194,9,134,149,11,134,15,26,82,194,147,89,202,235,238,253,213,51,30,249,77,211,75,3,254,143,37,191,58,98,245,99,0,151,159,214,188,122,86,255,109,74,254,240,206,32,153,149,160,123,125,237,87,144,246,213,194,140,121,107,144,135,117,33,229,109,163,190,145,20,80,13,99,206,124,97,17,38,206,83,39,47,174,219,237,13,28,91,73,163,227,241,74,178,49,216,120,120,56,40,120,206,185,137,7,132,182,217,172,69,240,46,113,225,89,66,106,230,102,207,80,112,126,19,217,182,166,125,243,41,9,24,84,144,127,55,86,217,147,219,5,20,94,201,140,147,17,5,0,83,251,160,33,197,160,125,182,228,48,2,85,46,139,247,207,252,73,228,197,253,118,148,176,90,3,46,227,192,14,128,102,122,250,92,118,39,87,106,74,206,255,165,127,121,132,200,229,61,84,54,210,232,35,72,16,152,249,2,126,30,234,155,144,28,168,180,204,225,115,221,71,220,193,74,201,79,206,179,235,179,152,206,246,129,180,254,28,149,20,105,151,130,26,105,204,110,202,145,100,249,213,130,153,142,181,24,162,164,95,230,198,40,145,58,52,123,10,106,129,173,242,135,229,38,32,238,90,243,58,33,113,159,65,67,32,94,82,244,222,12,45,191,3,127,19,49,21,76,2,244,133,137,123,194,17,89,129,116,227,28,38,99,204,226,163,137,31,162,169,190,212,93,89,27,222,179,2,138,190,248,112,65,173,208,50,113,13,18,214,9,112,45,92,217,156,120,3,128,105,62,206,49,64,49,103,244,199,251,35,121,63,126,234,248,171,161,103,246,232,30,181,4,9,60,61,56,61,254,230,142,250,223,208,134,148,86,37,216,209,3,197,90,7,114,227,120,72,188,58,153,78,101,187,89,233,223,74,37,246,33,81,223,43,128,11,154,228,226,113,223,6,90,5,34,187,207,31,62,242,148,177,44,211,30,59,155,84,44,81,197,41,66,181,169,208,180,33,154,233,154,134,193,29,28,169,134,85,87,204,110,101,209,50,41,191,19,10,245,112,142,82,137,44,217,129,216,186,193,132,25,27,34,105,28,76,165,53,125,131,146,6,117,148,210,200,172,60,104,5,168,128,27,56,35,45,11,205,25,12,108,211,82,143,249,249,130,221,249,45,151,149,239,178,161,127,234,156,167,216,55,79,158,191,132,0,30,79,208,145,69,39,126,13,43,146,188,160,125,189,173,93,190,251,77,81,215,236,143,194,201,5,8,177,97,223,49,79,109,86,129,172,6,254,129,160,106,56,66,167,186,194,45,128,225,93,218,71,198,230,231,211,61,252,45,36,202,25,66,214,100,57,235,168,223,73,21,51,196,46,14,184,242,191,211,105,148,229,137,81,24,98,50,174,36,127,223,92,249,48,211,225,33,50,191,194,175,141,19,24,206,230,1,188,109,143,26,146,108,200,227,161,112,86,198,191,12,6,82,47,172,4,254,85,104,107,87,108,91,35,113,225,174,126,206,157,35,216,252,23,117,198,22,126,156,221,63,61,201,204,186,183,26,208,95,40,11,23,127,38,47,155,245,191,231,135,199,170,88,206,24,106,166,66,129,2,131,224,23,209,176,195,254,108,216,21,123,179,82,30,92,115,232,243,192,243,120,252,1,52,233,113,64,202,97,178,241,125,111,106,190,174,22,53,41,181,6,60,77,9,95,107,251,225,139,52,147,40,150,38,249,16,54,188,45,8,37,156,13,70,156,7,237,27,175,230,156,84,245,161,135,242,170,30,180,54,14,218,107,4,0,146,245,148,178,29,63,60,188,245,142,73,104,190,196,39,133,16,0,94,252,90,186,20,74,195,108,178,152,45,215,179,184,0,227,117,26,21,208,98,81,33,207,20,123,214,71,70,235,231,9,246,113,129,171,137,14,192,151,216,188,202,136,81,67,111,17,15,239,75,25,184,191,136,173,140,114,176,94,132,124,20,48,113,156,120,250,206,12,244,242,3,28,235,41,81,194,42,96,4,24,71,97,247,62,105,167,99,84,187,219,230,83,153,186,21,154,26,71,89,226,13,96,96,238,72,238,163,148,204,251,83,9,25,124,216,103,126,100,21,37,220,38,174,37,246,90,105,159,4,208,236,110,235,86,3,238,213,116,213,78,45,130,132,190,133,188,101,33,104,104,122,65,77,31,131,158,62,255,13,53,100,132,237,48,16,157,143,203,209,255,100,183,114,85,86,47,138,148,199,43,150,219,34,142,97,211,95,69,115,140,82,33,204,118,151,194,69,195,218,104,113,26,208,61,221,166,48,237,216,115,97,190,149,112,157,3,188,6,170,91,10,220,208,100,15,188,24,201,61,76,139,198,237,149,218,97,216,156,239,92,134,93,187,76,151,99,60,68,14,229,35,23,204,202,6,246,138,102,0,91,31,94,170,219,205,251,157,145,205,146,225,79,201,101,131,53,133,29,72,198,31,132,171,241,5,2,14,115,152,251,43,148,164,151,78,249,35,25,151,9,153,120,173,88,148,62,77,211,243,99,253,166,38,6,178,106,150,166,26,127,43,113,23,8,45,85,251,252,82,244,15,76,222,173,109,100,175,114,232,243,87,115,210,159,59,254,241,1,177,62,108,195,146,163,63,83,217,238,85,129,109,129,187,157,117,100,252,3,59,61,27,101,176,94,134,49,73,185,179,34,3,24,116,227,219,179,79,187,200,183,68,81,233,37,186,114,157,219,242,235,168,141,18,226,195,165,12,145,35,236,184,38,146,47,177,237,21,107,118,205,10,213,31,85,245,82,10,114,64,47,109,47,17,34,122,29,140,121,79,122,30,15,162,173,51,167,66,221,248,193,123,63,115,28,247,102,172,7,126,156,240,226,42,24,23,159,124,77,88,47,221,66,76,119,204,194,191,155,186,213,171,8,163,143,78,166,192,44,51,40,37,3,253,253,151,70,179,218,221,190,111,116,115,220,34,115,224,65,151,150,11,28,123,197,118,14,73,203,85,196,166,19,115,79,47,113,250,146,220,235,135,243,93,165,219,197,117,88,149,101,210,151,15,140,233,91,23,196,48,227,235,221,186,91,245,89,145,196,144,76,29,202,67,7,142,179,6,58,237,119,114,72,109,168,191,166,108,120,189,180,216,56,38,89,141,133,158,221,2,186,100,229,6,106,87,96,233,222,80,19,146,153,232,190,196,65,74,187,169,213,161,58,40,238,174,18,55,21,179,236,50,26,171,162,41,36,50,125,29,224,252,0,74,245,192,101,209,186,77,29,190,94,181,12,112,33,144,111,34,7,203,215,64,153,10,240,177,94,112,151,170,53,254,205,252,42,210,221,116,179,93,87,137,123,79,180,251,31,172,18,56,84,162,129,95,184,148,245,223,17,244,17,157,196,205,88,122,215,86,197,106,172,69,241,47,101,149,222,149,104,187,205,253,242,162,62,81,213,6,112,63,65,90,179,102,146,75,222,33,6,163,34,204,70,148,37,77,68,243,96,125,184,25,57,231,38,203,210,6,18,232,188,242,180,236,132,233,130,65,226,67,201,156,32,122,195,230,172,16,113,59,77,153,4,20,196,44,134,79,134,147,98,74,67,95,162,43,135,14,128,81,187,137,46,15,62,113,172,143,108,180,159,109,218,225,173,22,246,7,202,166,6,50,23,64,191,42,41,88,126,177,81,222,13,248,153,226,129,40,45,13,251,250,173,92,189,170,162,116,79,125,102,222,6,177,253,55,255,13,182,157,238,82,17,21,44,186,185,106,145,238,127,228,212,215,59,237,87,149,199,63,191,184,110,0,233,142,45,176,58,114,221,226,61,205,197,241,230,0,106,180,243,99,245,47,107,95,223,84,121,26,2,208,255,90,59,131,154,166,8,73,181,157,225,63,50,58,110,220,2,21,130,113,162,6,138,249,13,245,138,153,47,232,36,142,68,24,180,104,244,102,222,191,188,57,226,25,155,196,23,200,23,141,54,209,184,122,152,55,85,171,67,90,93,146,77,210,137,70,218,249,9,57,160,85,80,208,105,125,251,99,215,190,150,210,184,141,57,33,79,230,16,50,77,192,143,185,29,157,59,148,206,163,220,126,39,252,97,5,135,127,41,127,127,12,46,7,148,149,249,18,68,147,28,250,123,92,78,149,198,212,193,184,51,234,29,75,54,63,228,247,84,42,47,241,93,112,162,100,151,58,248,86,11,107,42,104,45,9,151,37,78,161,232,58,127,197,36,171,232,150,23,252,231,10,154,106,188,2,63,35,211,138,236,219,234,211,241,132,23,3,30,92,107,180,95,9,179,197,149,249,215,146,250,171,73,108,134,25,182,169,46,126,62,248,28,233,192,242,85,200,152,41,191,101,53,212,46,147,116,136,32,154,136,210,175,156,91,124,173,139,191,69,164,195,132,26,207,4,173,224,210,109,103,238,224,66,7,142,28,4,128,42,147,190,6,238,9,149,200,188,254,214,206,154,254,160,57,77,57,134,20,188,9,239,178,43,193,163,143,204,183,17,114,157,141,73,105,244,12,11,67,96,173,233,15,116,73,164,12,115,86,206,97,164,130,39,152,10,250,191,17,43,170,157,173,150,135,30,208,26,35,19,201,198,47,144,190,189,151,220,91,229,199,125,54,253,56,109,57,221,115,163,12,95,50,51,66,95,39,88,195,68,24,91,206,176,212,157,30,171,184,15,1,102,124,111,47,210,192,12,71,200,208,67,9,111,56,152,49,19,229,138,135,11,159,89,241,27,143,5,240,135,138,191,76,76,139,226,80,156,109,70,186,245,172,123,242,253,60,240,214,79,39,44,215,68,129,247,252,230,205,43,68,122,206,45,171,72,98,69,52,162,211,138,6,221,185,207,247,222,176,172,233,176,144,12,223,87,233,194,50,99,248,252,132,221,85,46,174,116,109,34,112,93,141,158,44,196,225,203,236,254,74,74,94,122,45,255,80,72,192,38,187,219,181,77,235,12,72,190,196,63,82,238,236,175,44,246,136,220,227,174,34,225,187,97,29,196,25,237,119,54,34,96,77,239,211,77,152,200,6,136,119,40,89,39,11,93,99,90,216,114,168,233,178,97,250,241,16,230,149,173,97,128,22,187,148,205,16,31,206,67,233,97,228,134,251,163,229,246,164,220,58,193,35,215,48,2,130,15,179,33,252,74,242,103,201,97,207,241,149,33,167,100,167,157,158,177,225,36,252,28,141,42,211,72,95,137,29,221,47,131,67,50,190,237,93,81,10,102,217,163,89,114,166,229,174,63,158,237,239,139,48,204,142,79,36,131,149,8,20,106,73,235,94,60,40,247,17,44,106,96,152,88,212,243,215,220,35,248,59,185,3,201,54,105,181,92,217,220,131,98,138,74,9,220,131,130,175,250,119,187,28,100,38,147,228,83,110,74,189,167,64,200,158,114,204,55,43,54,208,19,25,36,245,143,63,92,95,1,39,130,37,164,175,228,17,238,216,186,76,188,236,205,19,27,223,70,156,34,233,67,97,252,88,164,6,16,104,127,80,99,176,8,185,188,252,135,165,72,26,76,73,32,91,200,215,121,251,183,112,236,143,233,91,8,107,146,89,98,49,194,251,120,133,41,251,244,169,51,143,231,26,53,59,50,78,62,15,159,74,71,250,40,185,124,76,47,104,212,166,226,57,104,135,216,177,188,99,116,130,164,97,22,230,202,236,65,191,90,182,150,96,52,74,208,10,246,122,99,8,207,38,13,1,102,172,26,212,217,111,90,72,164,58,50,83,222,45,199,250,136,234,61,23,189,143,245,14,153,153,102,240,247,11,143,43,15,49,74,27,13,17,48,227,20,187,3,216,171,163,183,24,116,4,164,16,224,170,17,30,179,250,4,178,64,240,108,64,228,157,227,221,239,98,195,59,134,116,135,21,48,132,235,30,94,80,92,191,162,33,167,238,254,158,155,224,119,128,223,66,231,95,249,96,143,196,116,249,228,129,5,108,79,65,38,37,70,102,12,244,138,127,227,61,221,83,182,148,87,248,178,7,22,231,32,6,107,27,211,161,57,30,121,81,7,59,127,37,210,223,110,239,176,159,74,17,69,184,252,40,230,121,130,12,24,245,39,203,105,138,136,102,188,3,194,58,106,14,31,250,240,79,112,18,185,171,88,124,129,171,240,103,237,181,192,232,175,130,205,45,85,221,25,199,47,116,200,221,196,226,142,160,10,115,21,9,164,143,33,90,180,84,234,171,146,110,116,132,147,63,121,53,107,149,190,48,45,155,223,51,245,84,85,0,94,236,128,7,109,67,150,158,194,109,146,230,59,31,41,194,8,24,188,167,148,128,141,5,135,203,27,87,97,60,131,81,84,53,254,99,37,127,29,219,45,74,107,209,241,160,133,192,80,3,87,86,227,156,165,163,241,91,186,174,72,216,139,147,123,18,217,168,151,99,199,122,56,65,249,90,17,87,51,65,66,233,192,236,187,66,231,194,16,11,103,193,54,133,58,140,194,8,176,148,172,196,242,72,122,196,244,71,121,240,77,196,165,176,244,219,210,85,35,180,121,8,126,142,188,7,163,72,138,14,207,69,37,1,81,192,85,157,105,76,163,174,79,170,54,33,173,178,90,119,232,19,193,211,208,235,152,15,79,177,107,101,213,118,133,136,38,252,220,244,114,110,95,67,50,203,36,27,7,245,185,113,187,108,86,138,227,69,59,14,89,100,204,27,69,11,105,206,214,49,187,91,13,176,220,222,57,84,16,34,252,0,199,182,88,234,50,143,73,106,111,128,245,134,83,69,138,191,109,16,63,103,33,194,36,193,204,72,141,122,181,58,46,31,218,222,213,220,50,132,189,43,102,31,7,17,79,27,185,220,5,142,151,238,152,210,131,84,156,93,207,115,223,62,110,33,17,48,120,157,109,76,27,138,89,122,221,121,253,215,70,164,237,139,68,247,189,141,150,24,196,225,61,175,99,249,10,251,23,146,221,45,167,25,198,152,30,76,22,174,255,246,88,186,237,208,140,111,192,35,184,5,230,159,208,47,72,197,240,141,176,82,53,20,51,119,216,17,124,239,77,174,201,244,103,101,72,16,201,232,107,31,62,234,211,57,159,0,45,66,188,86,201,112,5,182,86,118,11,60,139,145,151,114,217,174,245,239,158,238,8,58,85,212,220,169,186,8,45,96,107,177,59,7,142,35,159,59,252,26,129,155,139,148,49,50,127,164,173,17,117,16,206,180,119,213,26,108,106,93,28,10,246,224,145,200,157,175,232,155,245,31,147,146,236,7,45,133,46,31,24,224,10,26,221,111,33,237,141,99,113,183,217,237,243,128,94,25,74,91,152,215,31,33,20,179,135,242,82,190,145,187,22,44,177,121,195,4,208,231,156,137,25,223,129,176,78,251,27,76,103,183,224,23,238,188,92,253,206,114,10,66,107,2,25,185,0,76,171,59,13,218,57,126,50,16,145,84,151,94,139,87,243,70,240,216,235,14,32,74,187,219,198,99,214,89,65,37,31,59,152,196,21,128,45,181,92,156,211,187,93,7,201,121,200,234,78,242,172,116,73,115,167,38,14,116,60,52,12,60,211,130,218,200,218,136,16,162,175,159,87,167,153,93,190,176,5,149,130,62,111,157,245,50,111,66,48,223,197,38,28,87,185,90,98,107,49,224,121,91,48,88,230,55,148,66,58,25,100,86,59,234,85,50,103,187,168,43,175,235,39,142,244,139,216,77,204,92,47,86,160,246,140,152,228,54,183,145,29,63,72,130,14,67,200,201,133,139,8,145,171,15,46,221,99,9,14,2,206,135,27,136,58,105,57,216,225,27,182,131,171,174,187,44,119,205,113,188,230,113,100,249,127,118,234,26,144,179,198,246,21,167,119,237,183,62,112,16,120,102,0,53,119,193,245,251,108,210,115,243,58,244,55,227,223,5,119,178,111,84,179,16,142,52,171,232,176,81,12,159,186,59,234,61,8,44,194,224,21,124,33,144,103,17,75,54,38,57,171,235,54,135,20,224,242,239,223,55,175,174,169,255,112,201,106,210,255,140,90,85,198,190,58,167,227,222,21,171,77,245,73,123,97,161,229,140,142,156,203,225,130,177,85,244,48,81,201,212,27,81,251,160,249,237,158,153,182,125,56,209,73,68,10,179,87,153,116,33,202,139,208,55,228,147,248,126,141,147,248,110,104,232,27,242,1,255,75,215,110,52,170,102,37,243,32,212,251,4,73,192,70,1,205,21,188,129,125,83,67,223,108,115,100,44,130,156,248,120,14,243,218,34,5,4,178,111,236,59,134,179,112,211,104,44,179,200,17,155,215,80,62,230,79,31,195,52,238,95,129,226,165,254,139,238,22,198,196,72,48,127,178,157,40,77,33,157,113,160,124,7,34,149,229,202,131,251,162,243,213,13,85,188,36,53,123,136,162,120,206,91,29,197,141,164,17,220,116,139,61,37,58,188,255,42,158,34,91,80,97,118,87,161,158,82,236,89,168,104,253,98,59,107,106,215,152,212,31,106,240,205,115,244,40,120,9,166,17,186,67,10,228,219,251,92,241,219,159,91,119,168,21,37,4,141,21,119,35,236,187,227,252,253,168,133,127,76,21,223,48,96,32,154,255,130,223,58,229,235,212,10,3,176,47,250,216,183,188,245,90,40,166,68,71,149,104,3,152,73,77,251,33,80,173,225,195,35,244,35,59,125,224,30,21,219,56,167,69,226,154,205,104,13,200,251,56,232,58,189,2,131,207,48,143,189,36,233,86,162,97,194,122,125,129,245,189,85,93,135,180,81,206,187,74,44,227,47,29,160,176,78,128,119,237,115,100,30,211,253,126,77,196,16,226,127,104,138,203,216,80,176,218,13,33,81,87,10,0,219,23,210,212,168,147,167,61,250,198,118,170,214,93,78,200,121,13,146,218,244,157,253,13,15,190,100,137,125,117,26,58,217,71,87,118,67,167,109,31,85,249,227,179,230,196,213,63,238,186,163,87,35,155,45,174,142,29,6,133,209,98,155,100,62,64,158,55,243,184,113,178,88,164,35,93,128,203,153,43,35,3,75,128,124,115,120,130,164,118,156,137,117,60,1,8,227,46,246,55,139,13,122,209,33,190,193,111,106,78,92,135,241,123,169,251,84,43,144,188,129,12,214,235,225,6,161,32,151,227,65,26,125,2,13,66,233,46,47,119,250,102,249,32,209,129,50,234,20,150,187,166,67,44,65,82,147,173,86,55,236,240,198,117,3,103,193,78,35,96,74,212,80,54,100,246,77,117,129,197,68,226,63,148,66,248,193,222,128,142,51,12,178,126,80,176,158,44,103,195,47,32,227,143,85,23,233,97,67,232,98,123,17,151,38,241,107,66,10,240,236,145,221,172,183,192,230,242,56,251,14,38,143,48,98,191,224,39,174,253,212,205,78,7,126,84,237,114,0,234,18,145,127,154,24,86,160,174,150,35,53,9,90,34,226,242,70,210,218,117,64,70,74,67,153,58,99,115,218,89,199,151,94,168,159,219,59,211,65,155,33,52,46,91,210,5,134,120,60,152,7,207,38,174,32,96,225,6,171,111,8,24,204,191,18,74,213,85,67,41,163,33,134,185,96,54,88,191,208,83,101,108,90,165,181,37,20,22,40,61,237,204,50,3,6,190,72,39,165,141,187,111,229,142,197,97,50,189,208,40,132,15,195,168,111,254,62,212,42,83,128,194,20,221,94,150,144,139,221,214,153,161,142,66,209,15,177,179,178,16,8,37,153,68,86,13,35,81,189,138,161,4,164,76,133,192,214,218,72,143,21,173,0,142,83,34,59,12,76,114,47,21,2,152,113,86,8,18,130,153,212,54,137,48,89,160,201,19,26,79,209,213,157,254,77,203,214,106,116,96,226,116,243,215,16,8,172,16,117,238,108,92,169,200,46,239,218,171,199,228,185,135,73,179,155,49,140,2,192,109,219,48,91,101,190,178,245,154,34,5,167,129,95,66,186,38,232,205,88,154,206,174,48,218,237,46,136,209,139,81,46,166,91,109,231,144,34,197,137,18,27,28,189,27,60,108,103,157,31,108,14,253,108,114,249,42,118,45,26,76,23,176,152,216,254,96,129,177,124,214,255,235,122,158,40,209,62,92,10,247,95,29,167,199,243,245,135,242,15,202,222,166,22,7,180,84,254,163,202,92,208,13,73,245,122,189,97,162,92,228,127,29,88,78,148,130,163,166,1,253,184,119,100,200,161,216,148,218,98,245,138,57,210,112,227,192,97,50,131,67,82,232,186,124,172,137,205,25,209,142,81,152,57,187,119,76,26,227,195,14,175,19,78,210,67,196,76,175,174,114,133,158,152,84,107,51,211,216,41,227,86,233,29,228,77,1,36,44,27,146,79,5,34,124,94,83,120,57,174,165,198,178,183,181,0,183,20,88,28,103,3,241,79,210,228,122,164,42,179,113,17,13,121,191,156,179,33,214,223,40,4,124,74,35,58,2,84,134,105,210,211,210,220,152,45,217,133,31,4,129,81,4,26,99,228,131,156,20,244,177,180,101,135,49,109,200,58,40,125,252,130,138,42,89,162,152,236,164,198,202,149,43,133,193,22,53,47,60,170,154,203,17,190,81,76,174,37,218,173,242,161,46,195,215,215,12,122,136,93,66,129,152,15,137,34,24,54,10,79,79,244,154,170,161,187,39,152,210,54,249,113,226,125,84,113,98,234,30,215,85,76,136,87,47,184,120,20,17,109,151,28,122,233,193,163,94,158,20,232,126,117,32,212,149,214,28,229,133,113,167,54,201,52,102,35,48,207,206,205,189,128,22,177,85,44,112,248,229,71,87,44,14,226,213,30,201,52,168,50,186,142,60,102,252,200,97,196,67,237,99,71,4,236,172,71,223,6,149,32,107,55,122,158,88,86,178,23,163,130,61,20,140,131,28,38,79,155,173,251,142,15,68,203,129,180,56,219,97,249,104,104,63,134,138,127,3,97,250,247,201,137,27,246,164,85,179,120,98,96,196,39,101,233,246,34,28,57,254,137,154,4,90,37,165,173,174,246,125,173,201,237,92,14,154,4,184,109,65,155,255,89,61,117,47,77,182,206,57,148,196,30,125,49,212,205,65,63,87,241,150,230,50,133,35,43,246,126,104,205,154,172,248,86,12,208,43,99,43,139,100,217,186,219,148,148,133,222,146,45,237,111,252,32,217,68,48,109,23,108,67,154,152,234,64,2,129,59,181,77,137,55,6,250,25,185,219,42,52,32,247,9,193,83,227,181,157,255,43,140,91,58,73,37,210,89,214,78,211,130,53,241,120,130,171,102,130,205,128,116,254,220,11,46,11,85,194,126,42,197,235,227,77,240,73,145,143,178,103,36,171,196,136,199,182,20,195,89,240,96,26,106,215,79,104,248,180,245,132,90,23,52,130,232,243,228,91,72,115,108,197,130,70,122,112,5,172,174,24,30,202,196,247,109,85,42,179,184,176,121,19,8,243,254,106,234,223,73,229,16,152,168,182,65,192,128,236,180,110,155,59,172,73,40,96,183,24,199,136,39,176,188,18,5,241,30,217,199,15,16,36,239,177,104,121,120,153,230,178,106,34,40,70,16,3,45,72,232,157,140,105,89,90,192,207,116,133,171,46,160,191,174,158,223,165,214,51,31,94,97,29,9,27,219,173,106,251,187,30,66,173,171,22,168,48,48,187,194,153,38,98,147,66,84,2,45,41,248,222,154,133,166,85,177,148,162,168,206,151,103,166,162,16,201,23,158,109,133,58,201,116,214,188,45,160,183,203,26,181,242,96,222,133,221,168,84,224,236,228,103,157,165,53,16,5,6,84,103,34,96,137,198,211,165,180,254,35,175,64,94,137,96,2,144,234,222,197,242,32,105,254,59,160,175,119,64,178,36,235,190,14,248,242,55,120,249,94,67,255,57,215,151,93,224,150,108,73,141,141,178,195,189,51,205,64,114,192,25,126,106,208,30,102,210,155,93,103,6,22,162,214,7,88,7,253,153,112,193,247,171,53,88,83,5,73,217,114,142,138,146,213,26,229,69,234,231,127,26,38,23,42,37,145,125,12,40,199,214,52,194,167,4,91,138,178,169,151,166,110,225,165,196,112,135,124,66,251,122,127,19,255,194,130,162,94,147,150,170,140,230,32,122,181,134,13,34,134,41,66,102,30,90,129,197,96,89,42,146,184,247,232,114,196,145,21,33,206,29,244,215,254,49,37,90,59,102,25,173,33,87,176,35,139,19,21,245,138,203,90,120,230,63,150,111,215,203,206,36,61,67,105,97,101,149,104,191,1,161,111,227,111,26,40,83,194,227,13,100,193,85,77,213,209,185,255,219,184,130,121,154,249,75,13,188,216,36,30,77,58,19,246,102,236,224,229,130,70,108,106,161,92,133,95,74,181,140,135,176,246,66,34,214,214,127,79,132,70,51,37,78,37,92,62,85,184,84,65,168,108,247,6,51,94,39,52,47,156,0,108,189,233,51,245,115,74,168,147,110,30,172,26,17,48,161,76,210,189,222,60,186,87,35,15,93,53,38,82,54,173,191,133,206,45,148,136,37,109,87,194,141,242,77,161,182,55,247,163,103,220,143,32,101,66,66,116,138,180,178,253,55,3,186,139,52,155,9,110,210,3,49,107,18,201,130,121,78,52,245,65,110,64,119,188,219,70,71,156,199,25,9,27,141,216,147,23,107,251,252,103,131,96,234,225,131,99,195,57,5,83,23,139,57,20,3,83,199,134,107,110,186,233,5,157,153,215,227,220,18,147,125,197,161,66,3,139,148,108,170,95,227,161,65,117,143,215,82,145,182,213,146,189,12,39,184,125,241,248,39,206,93,151,19,148,247,115,240,105,222,235,1,124,42,77,116,85,116,48,144,112,175,11,210,178,154,217,75,111,81,170,2,93,3,48,114,205,195,226,193,110,131,192,179,99,184,250,74,16,179,37,236,13,26,146,5,132,46,14,107,96,223,157,222,158,172,72,227,214,251,192,210,92,140,212,41,184,240,83,52,155,102,112,60,206,181,34,187,151,0,239,77,41,215,202,2,233,238,74,162,215,15,248,143,204,163,21,0,195,158,133,42,169,92,191,252,96,112,57,184,190,244,35,169,47,100,225,138,238,22,182,109,28,133,239,28,50,86,99,228,94,68,56,157,150,48,194,249,220,23,245,202,235,171,42,174,241,179,237,31,223,253,129,190,101,189,77,93,111,109,172,103,248,124,209,126,168,176,104,139,34,50,75,24,35,133,236,47,13,183,201,100,249,74,40,17,147,96,119,176,198,234,16,242,125,215,155,55,51,0,175,167,141,144,203,129,110,137,142,77,108,186,102,92,129,145,95,85,231,208,15,149,204,208,160,42,5,44,25,237,211,240,22,217,153,147,17,95,142,122,35,125,82,213,168,191,18,137,200,71,187,218,63,33,194,20,171,204,222,3,177,46,111,174,145,32,159,244,18,186,238,178,39,14,72,248,216,42,251,93,193,133,12,85,208,192,101,156,14,131,185,63,101,163,145,149,74,4,24,170,255,0,103,240,224,152,133,231,187,191,102,203,23,248,81,29,87,98,171,110,33,47,31,171,31,243,194,25,96,11,95,199,148,159,68,231,239,131,235,65,101,20,19,134,41,106,165,160,144,61,147,44,249,3,5,162,59,48,222,161,209,31,170,199,2,174,63,61,78,55,77,48,155,14,186,204,228,162,189,27,26,70,80,133,162,138,126,116,187,104,211,167,222,11,114,194,226,2,57,201,90,99,137,168,105,88,190,77,140,233,44,20,83,154,68,61,27,9,55,51,193,252,203,78,213,95,245,226,134,63,170,194,141,143,101,169,15,207,132,113,170,188,150,36,81,121,87,255,39,51,19,235,244,233,52,43,181,106,244,250,102,174,8,144,19,249,183,212,38,49,189,10,195,63,121,176,218,155,66,253,87,69,4,231,200,222,231,152,220,71,239,219,96,62,105,251,15,230,109,20,30,137,152,11,136,9,196,20,175,210,36,180,84,49,51,6,42,38,40,31,111,141,118,14,114,39,224,115,212,104,90,109,223,254,60,42,65,5,227,166,9,87,150,85,44,122,61,37,97,18,118,159,130,164,63,174,78,9,175,213,28,73,18,199,112,107,52,50,129,135,0,119,174,53,117,94,245,219,57,126,92,160,191,27,46,246,219,218,253,130,54,6,224,182,195,0,38,80,141,147,136,113,182,217,29,156,64,199,241,204,17,55,236,235,14,54,160,49,138,136,217,10,23,71,25,250,32,191,99,133,160,229,93,168,144,85,128,203,67,195,206,81,253,106,68,41,167,13,99,24,159,42,54,84,114,122,239,252,183,168,62,203,165,189,47,163,38,135,117,25,241,222,214,198,141,0,106,191,120,104,119,22,78,233,9,91,208,234,18,124,250,38,220,213,127,240,227,31,17,231,226,202,236,88,28,174,28,36,248,76,59,177,203,56,233,225,115,146,208,129,93,122,181,51,104,97,97,111,81,125,105,175,125,126,185,38,25,138,216,141,151,123,220,7,185,174,67,131,88,118,76,85,153,40,5,192,54,236,34,20,44,243,138,132,213,82,219,199,160,27,175,242,156,144,151,179,10,14,12,53,139,21,121,49,75,9,244,186,114,56,202,8,187,60,146,107,158,180,67,155,75,178,225,249,190,199,250,63,37,106,250,228,251,80,182,211,48,13,116,12,14,209,43,45,153,143,238,185,69,172,58,193,164,107,148,14,135,3,221,104,61,183,182,219,171,89,166,144,131,132,5,177,237,209,131,205,11,92,225,143,113,73,217,33,200,231,188,202,153,199,47,136,208,6,44,15,245,33,170,10,178,70,60,104,17,248,88,146,125,22,146,206,222,16,241,106,91,210,225,76,175,26,20,213,129,23,211,251,14,166,86,149,32,227,99,117,154,12,135,30,22,218,163,246,234,201,225,208,89,105,218,76,168,215,59,140,232,227,242,26,101,17,51,84,134,159,35,156,165,135,87,101,50,60,142,60,252,92,53,244,207,76,239,162,146,187,170,4,206,225,24,116,13,150,203,251,58,128,158,36,159,186,82,5,37,125,0,102,41,207,253,173,5,252,42,135,9,245,79,91,215,197,233,60,153,181,18,50,223,31,95,120,52,81,83,253,44,162,205,173,135,18,188,150,142,73,139,192,50,189,203,63,141,56,253,37,243,37,242,230,28,253,155,133,248,230,58,112,243,58,82,91,44,121,114,233,82,193,157,253,124,99,172,109,121,62,221,252,14,235,2,73,242,105,196,15,46,87,224,26,186,49,73,113,17,26,32,195,124,183,210,127,222,121,219,41,39,105,248,63,172,198,219,252,173,132,160,38,68,179,77,20,142,198,109,77,14,76,117,163,250,103,182,20,142,110,83,192,191,17,108,213,181,249,46,8,91,197,248,150,9,151,37,117,0,161,136,23,71,241,73,206,68,11,177,75,163,86,122,202,200,4,37,159,77,107,246,26,15,73,131,193,43,250,14,138,205,39,213,34,139,136,202,44,94,240,255,199,235,202,204,214,63,85,77,19,249,166,93,42,171,183,23,214,102,183,150,195,174,239,253,45,139,92,93,26,115,54,72,36,73,140,55,202,98,101,166,134,78,206,178,121,15,134,26,28,219,44,217,20,230,198,208,188,198,195,107,39,62,157,90,139,148,18,29,101,176,8,146,104,236,161,130,200,227,180,220,105,7,197,74,188,109,214,5,162,205,142,189,137,23,106,219,2,119,58,131,52,52,16,29,102,199,123,17,101,139,180,217,164,114,241,212,211,214,200,50,82,164,50,14,6,93,87,244,192,98,112,203,120,168,196,220,139,63,218,36,18,238,72,15,103,4,250,169,65,104,29,187,72,131,55,197,153,213,21,253,63,227,10,159,167,22,138,61,248,217,81,14,203,158,86,11,36,102,196,27,122,177,22,59,82,181,180,160,192,42,181,198,12,58,99,90,125,7,255,246,175,93,230,124,203,65,196,10,92,32,36,32,143,122,93,133,139,60,220,58,63,5,46,156,114,88,165,147,160,54,207,63,120,55,176,114,215,212,133,70,190,224,230,226,144,45,146,240,81,212,25,8,152,195,3,84,133,192,161,62,201,125,52,218,242,65,176,108,59,83,125,121,89,226,16,193,71,13,8,170,123,28,108,58,130,120,165,69,172,163,132,140,219,192,246,203,7,250,74,19,174,201,3,251,52,36,121,239,28,120,54,247,124,187,15,228,168,55,187,147,157,67,55,221,63,183,48,205,71,147,227,90,112,40,164,235,221,143,127,198,73,237,79,80,128,215,252,178,236,203,115,130,204,104,128,98,193,87,166,60,179,215,177,139,134,242,195,136,252,140,4,57,159,48,231,64,83,177,167,69,166,185,154,161,249,249,105,24,63,197,207,22,27,212,129,92,182,76,51,169,184,245,239,132,69,121,28,220,34,49,227,15,139,59,89,190,244,25,36,195,240,171,106,106,241,191,79,77,68,21,60,2,1,159,14,141,109,102,66,23,61,90,110,34,208,84,161,96,221,178,199,175,95,86,89,150,103,202,38,152,247,179,200,67,14,36,139,13,173,215,71,107,218,8,224,209,54,5,232,211,234,183,41,36,70,174,210,8,17,188,220,23,211,91,215,82,174,236,74,54,190,145,65,94,114,45,202,221,36,119,74,251,106,164,153,227,67,194,38,121,137,138,81,173,170,115,156,223,64,118,40,117,10,138,237,180,168,59,43,239,28,81,75,106,182,163,41,179,240,82,175,148,177,193,252,72,102,128,230,114,128,214,2,63,136,157,245,146,217,169,198,119,179,218,4,193,96,235,179,195,240,72,73,231,30,105,216,180,247,225,54,128,103,22,160,250,191,95,97,223,98,169,26,242,35,194,175,31,54,94,176,22,162,208,236,92,212,114,3,190,232,145,139,191,10,7,252,218,147,61,194,116,147,8,69,241,198,255,79,112,55,87,191,28,91,100,228,152,44,145,31,194,67,163,169,44,234,101,59,24,189,22,48,243,179,252,240,146,23,199,237,34,236,55,52,86,210,127,124,16,53,116,172,12,0,145,248,238,116,59,213,223,88,81,5,100,252,218,115,87,94,133,243,87,72,180,137,39,30,78,226,145,224,25,59,92,40,16,176,239,246,230,119,159,204,227,97,94,83,199,112,87,67,169,175,8,247,81,153,16,56,84,69,12,183,255,172,162,24,230,42,8,114,53,220,29,161,65,114,52,190,84,65,42,98,170,249,44,61,134,120,248,159,173,95,69,102,105,172,239,237,122,178,133,198,213,89,162,56,145,23,81,184,100,236,114,149,1,197,173,248,10,12,41,201,121,249,240,91,184,82,12,76,119,250,72,207,70,79,149,108,248,123,183,32,74,116,130,239,192,180,142,176,178,26,59,217,65,75,51,206,96,99,53,88,25,203,33,123,89,80,153,181,234,112,217,0,165,44,21,73,69,134,76,98,213,146,129,224,183,249,39,152,94,107,21,22,215,111,53,123,157,203,241,85,69,234,194,48,104,10,223,200,187,90,178,89,21,175,154,85,189,151,59,135,163,151,77,244,210,131,138,22,184,116,46,145,10,243,30,207,16,253,193,182,176,205,252,146,61,107,85,89,75,100,19,165,152,81,182,252,5,169,126,183,112,162,38,111,11,94,96,250,252,169,130,182,35,199,198,219,89,214,211,35,253,128,0,52,22,29,231,189,97,70,193,73,122,71,22,110,208,96,74,198,39,35,156,164,248,195,44,32,36,216,212,58,116,144,124,241,14,200,8,78,69,38,98,27,121,83,34,20,195,249,14,136,238,73,189,156,73,2,17,106,90,18,107,95,60,68,215,253,219,226,35,173,182,52,182,169,186,15,253,9,20,44,212,168,22,66,144,102,172,83,14,99,185,224,101,189,247,142,205,253,147,9,64,164,127,19,231,221,221,178,49,75,133,132,181,6,96,229,187,135,71,95,67,45,182,84,64,157,135,226,129,239,81,10,175,101,126,1,207,190,166,136,8,39,96,84,7,69,72,146,198,207,128,180,66,19,210,226,112,125,235,138,193,217,154,119,253,252,92,88,191,58,70,102,110,36,184,109,111,226,230,24,199,89,93,229,150,0,2,94,184,198,133,169,37,26,164,135,103,107,80,48,64,146,104,57,18,245,115,167,225,157,227,94,91,75,162,174,73,107,45,188,238,62,142,84,218,129,12,65,244,169,116,246,112,30,155,209,215,6,94,236,173,197,18,16,68,239,166,69,74,126,70,157,222,52,130,134,123,176,161,90,161,119,119,13,43,219,236,103,213,67,165,142,233,79,151,34,102,1,198,155,36,228,28,74,129,11,118,86,206,129,167,142,79,100,244,93,122,47,146,144,210,19,37,230,147,199,123,28,147,55,186,17,177,110,163,168,155,174,68,180,44,63,11,49,119,90,225,212,91,252,154,104,246,21,103,219,205,166,33,247,75,147,202,197,168,239,94,30,128,70,126,13,114,82,104,239,171,112,10,88,32,80,197,89,85,139,157,175,109,99,21,251,43,183,180,29,94,54,233,170,203,156,225,88,175,88,97,6,117,68,99,205,118,9,56,40,168,226,156,54,164,126,154,43,78,36,167,132,156,27,70,134,36,61,2,8,46,52,248,58,166,205,129,89,171,169,83,161,17,115,56,211,63,200,126,101,234,168,248,24,108,14,233,230,206,212,107,82,142,238,32,154,154,38,36,147,238,213,160,165,195,193,227,208,106,20,121,50,185,100,221,172,75,171,61,133,10,202,125,135,49,83,236,145,233,180,116,135,162,152,21,254,201,88,197,28,58,245,68,181,118,52,57,58,243,236,248,53,41,107,201,157,129,76,179,36,106,126,101,59,47,184,81,167,194,36,198,23,180,48,149,66,198,206,136,191,19,153,102,162,142,229,9,113,30,20,121,108,73,75,89,150,142,217,198,82,155,24,200,12,50,216,16,35,108,76,16,131,58,14,95,252,97,233,81,30,151,104,246,107,94,27,48,33,194,207,0,250,229,229,184,186,98,53,113,159,116,107,249,10,57,119,18,199,62,205,207,31,133,199,93,67,25,32,46,50,83,16,131,216,175,143,234,52,182,123,75,52,139,201,9,179,4,231,52,61,114,2,96,136,50,157,37,36,197,127,60,165,161,37,236,168,117,72,252,103,68,189,254,80,127,203,2,221,26,178,97,214,132,108,87,153,254,145,238,118,23,118,136,65,243,66,172,101,93,106,22,250,57,197,57,161,162,18,247,25,63,119,218,110,237,41,123,227,120,82,23,40,73,198,152,78,162,172,189,183,97,143,193,62,91,25,37,148,227,118,83,177,65,100,113,93,201,88,200,118,177,132,142,129,149,175,9,92,104,207,111,6,155,106,238,167,47,52,223,47,30,250,79,8,157,183,8,178,190,122,171,227,203,163,191,78,225,239,144,10,10,10,65,217,39,66,75,224,89,12,148,138,210,86,11,125,150,50,24,246,232,133,139,143,161,222,131,53,253,194,22,172,206,5,219,89,64,235,201,41,172,214,220,54,162,116,67,172,91,149,44,179,80,36,41,83,158,92,247,22,101,177,26,2,40,38,56,226,144,90,229,255,1,222,159,93,94,87,74,81,115,123,207,130,239,171,181,181,45,191,66,246,32,51,186,10,206,148,240,40,223,231,135,96,85,187,14,177,38,98,107,236,213,23,218,48,110,90,125,239,97,180,255,194,240,117,163,154,182,223,197,225,203,32,131,56,96,178,26,149,1,1,56,194,156,226,168,57,78,212,93,33,8,159,221,180,107,27,109,170,169,114,113,109,238,22,17,99,22,170,128,203,19,188,104,180,73,206,212,54,221,53,111,123,115,34,34,174,215,215,124,125,128,173,86,14,89,50,161,119,202,99,152,181,164,115,50,116,71,59,67,182,114,137,248,216,4,208,174,39,122,10,247,4,164,178,41,67,205,137,130,233,143,16,34,55,156,68,187,183,228,100,167,6,104,211,108,97,241,131,212,130,3,141,15,155,155,136,152,174,156,233,215,23,211,45,136,76,78,225,34,190,63,153,153,119,149,162,8,237,232,67,49,30,246,172,179,208,177,114,152,49,70,252,98,4,135,31,33,247,134,152,230,157,165,254,30,64,60,110,141,178,221,87,214,132,131,126,245,226,65,248,68,86,9,142,152,27,105,124,13,148,117,216,81,181,189,85,205,250,140,134,9,112,61,180,10,68,31,51,125,181,89,47,156,36,252,250,196,76,198,77,66,142,29,215,57,48,25,214,146,139,246,51,236,152,8,16,34,94,57,64,5,213,49,241,17,254,241,248,122,127,145,217,223,75,102,82,132,140,135,21,176,12,16,146,206,101,24,212,72,204,178,67,13,195,70,168,183,232,75,161,151,42,149,113,224,201,217,224,249,158,93,75,69,89,143,187,29,54,20,11,244,161,144,40,166,112,163,211,253,215,126,232,38,29,58,39,18,148,244,8,17,197,140,195,116,157,26,243,172,33,123,89,115,250,74,29,244,167,166,219,168,140,148,191,160,22,158,138,245,41,230,158,25,201,121,106,241,149,10,191,238,79,233,158,31,246,244,168,45,207,224,22,126,146,102,251,208,111,103,50,58,211,183,216,50,211,86,144,89,216,210,173,36,177,159,71,15,19,226,139,138,51,237,243,243,68,57,160,166,9,243,39,64,244,100,196,11,219,115,161,102,122,1,24,167,65,207,83,41,200,215,238,182,131,170,215,4,192,184,233,28,104,54,37,207,127,16,22,195,201,243,96,155,211,43,46,104,167,54,253,182,11,22,227,54,225,4,231,55,203,103,38,226,245,150,204,146,178,171,204,159,118,204,174,226,104,134,41,14,140,237,153,58,231,239,209,94,242,5,235,73,94,49,94,78,156,53,170,30,238,6,130,13,13,106,168,169,122,246,137,190,217,102,235,198,48,125,14,223,244,216,110,154,248,82,31,116,92,3,14,104,202,146,190,8,181,123,145,111,47,153,5,152,5,10,93,28,20,95,236,176,36,240,60,150,39,49,79,21,113,88,227,125,192,99,131,161,87,192,141,236,58,225,47,77,60,235,125,116,189,135,62,131,127,169,177,162,9,25,244,249,142,3,125,18,104,175,184,8,122,65,184,213,225,248,150,130,174,11,35,28,139,108,202,0,102,57,197,206,242,122,120,63,249,243,154,217,4,186,136,150,45,105,101,231,188,123,31,74,113,138,173,36,103,33,44,173,221,145,143,162,251,182,147,210,199,56,58,221,147,25,205,146,169,86,175,2,11,162,148,234,144,169,247,240,84,32,71,169,198,102,60,163,183,173,213,48,104,157,84,233,123,97,124,72,37,15,214,251,103,152,129,9,157,47,57,216,147,251,93,123,205,196,78,100,145,30,23,208,73,87,163,239,170,107,28,33,13,17,61,34,133,241,158,177,52,114,72,142,242,122,121,157,240,115,227,87,9,87,150,119,85,46,208,129,55,234,57,155,114,148,42,40,217,28,219,229,204,224,76,37,87,135,141,133,92,75,23,157,36,114,185,223,183,122,191,74,190,233,206,49,39,188,190,232,216,102,69,86,154,229,249,43,97,62,118,149,110,113,157,35,189,148,226,44,124,223,204,158,16,139,38,80,203,164,48,170,127,93,227,104,35,11,87,40,238,107,117,144,233,252,183,127,97,229,245,236,1,219,18,139,166,198,190,78,195,97,16,109,223,112,204,28,93,148,246,247,4,206,129,207,136,25,151,123,105,3,48,145,56,180,95,4,159,184,237,88,197,46,81,129,17,99,0,181,155,109,129,110,146,56,86,212,104,227,34,79,17,39,7,97,38,95,72,156,233,184,216,106,147,129,245,115,225,53,178,158,211,37,252,159,83,215,190,222,250,170,88,84,185,3,103,164,28,250,160,37,30,153,222,166,93,220,41,20,172,29,45,4,63,15,142,156,129,167,91,194,52,224,19,160,122,93,140,46,161,5,217,247,204,84,24,2,23,128,255,102,166,177,231,69,88,169,0,152,30,141,159,160,121,116,62,22,213,117,169,148,230,248,112,194,80,226,208,231,125,135,220,73,253,144,138,72,167,43,51,240,112,160,115,248,91,233,222,232,31,10,230,232,229,126,236,124,141,71,202,60,197,247,42,130,193,181,112,207,32,110,172,215,67,4,52,18,205,164,94,11,19,224,189,70,132,109,243,202,94,130,76,221,184,177,216,27,182,230,28,154,204,236,97,204,30,194,194,64,139,63,121,78,243,59,34,119,18,99,196,218,208,104,155,242,118,33,26,236,219,179,58,17,59,128,158,113,101,242,106,97,207,123,98,63,203,102,37,99,241,69,126,204,247,142,84,99,96,175,188,83,61,27,54,237,2,194,226,204,133,44,222,2,127,73,170,101,235,44,46,135,146,88,237,174,169,212,105,26,104,121,79,133,5,157,244,221,42,229,124,127,236,70,37,32,85,224,35,255,153,202,83,36,130,121,133,201,72,215,148,212,105,158,212,2,211,57,49,163,235,49,51,19,37,183,64,200,119,97,220,112,190,224,82,57,126,182,66,171,57,114,28,145,59,136,138,219,228,51,185,221,55,109,178,111,62,254,175,75,173,152,89,158,166,95,71,247,31,96,49,122,85,162,142,51,205,136,163,204,166,11,22,85,230,5,73,20,23,246,232,129,49,196,129,15,66,30,98,220,240,221,87,60,149,0,219,67,100,222,221,54,10,51,72,249,151,189,253,184,134,207,100,109,82,22,151,88,26,96,182,188,25,91,110,191,104,166,94,234,234,211,39,145,105,207,184,59,77,156,77,206,8,221,214,37,218,77,28,46,183,31,36,125,193,222,65,16,59,5,118,90,154,40,56,111,124,243,147,154,114,171,166,228,64,63,98,168,163,126,201,173,162,53,46,39,239,155,0,250,10,22,73,145,10,151,152,200,106,31,186,237,248,60,48,137,206,9,207,183,16,99,10,7,74,85,115,119,161,96,138,11,137,174,87,60,169,230,178,132,63,140,239,248,9,97,65,84,202,14,0,62,50,46,0,184,17,71,145,68,153,120,238,250,35,172,135,135,43,75,116,95,115,86,217,73,110,239,143,5,188,224,79,199,6,169,51,120,74,251,100,86,195,36,129,79,109,1,191,16,64,104,12,224,47,101,71,177,32,251,189,167,200,14,9,137,28,39,62,217,128,177,246,252,105,177,208,227,98,85,122,252,8,193,179,252,223,159,113,81,167,119,74,127,166,205,81,191,14,135,216,51,9,224,208,195,228,175,44,196,57,29,234,116,34,201,182,138,114,111,122,214,240,37,129,194,180,4,232,94,123,184,248,177,158,182,95,108,240,161,76,91,69,73,1,196,141,254,6,253,220,58,69,45,219,27,74,32,50,12,252,11,195,107,61,56,208,80,192,106,67,202,229,39,173,40,65,185,245,216,41,231,133,241,54,75,194,161,185,12,60,250,89,235,97,112,3,169,178,186,29,132,130,90,253,94,19,79,241,209,153,176,54,48,179,238,118,239,77,40,215,122,11,10,252,112,237,5,125,27,139,135,173,117,111,177,97,159,57,34,98,109,117,4,225,81,251,196,47,18,64,212,81,47,168,232,175,42,235,239,77,82,0,14,46,191,107,117,148,205,39,128,137,170,177,239,165,21,245,83,105,165,67,212,250,138,21,195,223,74,130,238,84,45,18,65,235,103,5,246,134,121,252,149,186,25,10,162,207,238,14,152,10,226,226,140,69,114,146,36,221,217,8,205,120,223,97,144,13,28,48,184,128,49,223,162,105,167,144,94,115,102,140,95,166,51,128,52,225,51,124,49,0,117,118,26,236,178,241,98,151,82,215,243,28,10,41,255,54,172,34,80,51,162,0,33,238,252,6,248,230,93,245,208,231,146,167,114,42,4,90,185,93,48,232,194,125,201,129,28,49,249,243,106,146,84,208,61,198,221,185,162,86,134,238,182,113,85,132,47,145,218,47,119,33,25,1,30,206,187,149,88,49,209,145,182,77,82,249,155,10,120,22,192,16,215,143,98,145,124,59,67,61,171,229,205,68,203,196,232,206,19,57,49,206,132,98,194,248,138,195,66,130,224,112,100,33,231,186,149,169,42,207,253,133,240,151,97,112,30,41,33,116,74,109,59,14,245,66,4,38,170,86,104,80,37,197,225,19,220,6,220,195,137,30,82,180,139,217,181,36,105,150,86,2,137,62,10,127,59,134,199,193,35,67,252,184,117,109,191,132,126,224,240,218,15,146,253,3,79,49,61,49,153,63,81,34,46,162,232,209,208,120,18,73,53,2,114,53,245,159,195,194,181,141,111,252,14,178,70,99,69,159,231,16,66,193,206,144,224,8,21,164,31,65,13,190,134,49,195,12,189,196,75,65,115,124,118,138,149,17,193,6,57,206,212,162,60,160,228,82,205,33,137,114,152,120,155,160,110,226,201,139,207,197,18,131,180,160,42,161,47,128,223,27,9,204,154,254,243,73,102,75,172,232,67,197,3,35,46,53,223,132,217,192,219,106,246,179,23,136,117,26,94,227,87,46,182,37,129,156,95,68,176,240,101,116,202,65,102,149,8,86,229,102,93,210,220,251,208,11,91,209,202,101,210,106,96,231,133,8,61,82,44,238,189,218,64,75,237,210,187,69,27,106,182,179,202,6,34,246,27,121,5,120,87,139,215,133,252,30,238,118,191,95,73,66,162,202,100,18,45,106,122,63,30,186,6,151,1,232,119,132,33,17,139,216,151,199,51,207,135,198,185,31,98,111,203,245,193,33,85,136,168,97,111,234,175,67,140,22,1,230,87,222,93,231,182,125,64,190,141,144,142,74,110,170,112,200,141,244,124,96,229,151,147,59,39,161,203,9,104,239,72,239,55,3,10,49,193,3,56,221,199,77,218,129,153,196,150,37,24,173,73,166,93,168,218,29,146,124,229,150,167,68,220,57,246,172,184,46,236,235,44,214,15,64,129,32,22,121,184,33,116,191,28,172,233,214,145,73,120,69,75,1,180,56,77,28,0,51,214,55,61,199,16,140,110,157,60,67,31,226,233,201,232,229,161,254,250,37,252,77,89,234,23,235,106,149,78,7,167,183,223,65,138,179,211,192,151,91,117,164,85,107,127,89,152,26,211,217,215,176,182,61,241,26,92,123,161,219,90,142,38,171,244,157,96,5,164,196,177,71,4,211,28,71,79,239,59,201,116,173,49,231,115,44,193,18,46,90,191,133,147,107,18,83,53,246,72,104,228,231,46,13,185,201,130,205,211,45,69,212,26,12,132,227,185,1,195,121,195,23,214,115,107,217,68,32,128,221,168,19,219,117,141,252,229,157,0,106,55,161,41,76,189,40,63,232,202,127,172,158,248,190,205,125,140,36,21,125,20,34,163,95,59,255,173,187,146,175,169,181,44,130,176,130,64,70,45,26,176,18,164,220,191,15,88,156,64,171,239,169,13,133,241,32,230,139,103,58,86,198,83,200,205,21,63,225,211,108,37,11,20,196,5,222,147,61,23,92,199,53,96,75,50,2,228,186,102,158,81,172,235,224,191,139,169,48,24,197,77,95,37,253,245,12,231,66,215,179,91,159,48,83,69,163,203,46,108,78,60,16,35,250,82,90,42,249,135,93,242,35,93,30,136,113,54,197,129,190,38,232,41,109,142,168,131,68,88,144,96,235,157,188,199,34,131,65,128,1,181,34,255,169,182,225,151,95,89,114,71,243,31,242,119,35,205,198,130,24,128,166,149,62,112,160,87,67,137,108,77,158,49,245,64,53,1,221,155,69,244,52,113,132,196,113,134,152,12,146,56,0,87,172,231,231,228,106,28,184,194,82,73,61,229,117,197,236,107,147,151,200,117,237,187,57,254,32,202,152,103,17,139,188,19,202,170,92,189,172,166,253,27,78,181,198,47,204,138,56,179,37,63,108,210,81,54,154,111,194,125,100,92,38,125,220,150,27,149,199,216,166,238,226,84,190,128,139,166,123,106,170,178,13,55,105,198,42,183,0,77,2,174,120,85,121,183,206,37,28,73,205,207,248,89,149,234,159,134,54,33,77,103,28,84,13,162,219,236,231,195,201,204,78,240,26,175,205,72,135,171,135,76,36,46,163,195,109,147,47,90,123,189,19,43,159,120,201,197,205,146,67,207,79,205,137,241,152,95,65,16,205,51,111,159,69,98,29,185,137,157,109,70,182,207,177,195,80,183,237,30,38,60,221,48,124,42,139,229,1,66,184,175,218,87,17,38,90,149,227,2,77,136,210,108,107,38,128,159,96,74,104,33,35,215,196,186,166,96,84,253,144,137,124,236,73,42,195,46,34,84,132,61,168,233,174,10,68,140,120,92,109,2,168,231,138,200,57,23,181,205,87,93,14,191,66,111,135,161,86,12,235,9,233,170,140,53,223,24,165,229,227,127,194,177,79,255,94,141,65,165,182,123,173,96,141,170,244,95,121,183,66,42,183,50,117,107,126,195,219,87,142,114,131,234,174,145,89,25,192,83,255,126,192,39,49,247,87,201,9,167,12,83,64,193,53,75,188,235,217,174,185,157,19,174,133,174,64,206,254,171,214,56,18,78,173,180,138,79,105,214,77,165,212,10,82,155,130,191,77,92,115,196,137,6,93,115,84,252,135,177,251,43,226,72,198,100,144,1,46,25,155,200,191,193,31,160,117,128,43,173,98,57,231,254,242,5,239,112,39,106,122,87,122,170,141,225,201,100,238,186,122,80,24,64,52,225,115,45,241,47,116,107,191,147,138,26,219,77,77,37,6,116,115,240,77,74,3,145,34,192,240,250,240,157,88,91,73,14,179,38,206,95,252,246,184,177,91,121,169,158,128,135,87,48,254,167,200,143,54,10,86,234,87,200,50,28,11,185,137,53,218,37,145,52,60,36,141,136,37,234,167,241,100,62,136,203,164,221,40,33,232,72,250,87,130,102,249,62,163,148,103,253,40,144,200,129,11,226,146,44,12,2,14,69,210,85,124,222,238,37,175,208,70,212,220,228,182,85,130,148,91,76,63,172,116,184,113,192,56,129,165,199,118,9,184,91,236,27,125,29,61,93,135,23,187,100,210,195,76,22,9,52,238,160,80,69,53,53,41,135,79,222,57,15,0,249,166,192,87,155,183,250,219,249,148,83,172,52,70,151,90,96,188,140,35,150,8,203,239,186,200,242,173,20,109,116,43,225,78,55,99,110,244,98,246,231,9,60,40,12,146,208,56,9,197,215,255,229,67,32,98,67,84,223,31,64,136,101,224,241,99,67,169,110,164,253,15,15,207,150,48,61,190,11,35,174,215,78,127,136,247,170,238,6,117,104,190,105,10,182,212,68,184,203,82,1,208,3,8,136,108,44,196,170,58,110,82,48,32,94,38,19,31,20,129,89,157,209,223,42,83,248,63,180,252,152,255,163,125,95,220,44,10,30,25,101,246,199,160,76,29,200,148,249,8,150,116,212,65,156,234,250,4,53,193,176,119,94,58,233,133,195,231,210,122,9,169,198,116,90,154,79,232,245,29,181,234,186,137,172,118,113,188,74,121,193,184,23,89,196,26,52,234,111,73,93,164,213,200,19,162,98,223,171,209,63,31,126,171,212,157,42,123,96,243,234,4,95,114,231,125,227,112,149,4,231,176,69,217,39,175,69,253,241,50,209,78,31,221,168,24,139,223,8,197,88,13,13,129,58,118,73,14,61,245,37,178,76,126,251,189,105,139,170,14,19,135,210,192,236,154,51,218,219,67,202,28,13,162,142,157,33,190,141,102,134,90,41,21,207,122,0,140,109,251,0,135,171,153,79,156,149,51,169,194,170,239,26,3,81,61,107,88,255,37,10,238,19,113,54,128,134,192,238,38,140,163,91,169,60,97,99,196,108,54,169,145,199,205,167,75,249,154,241,197,20,107,229,210,229,13,217,55,167,25,54,1,77,226,104,195,89,216,221,153,131,0,110,102,146,88,148,196,72,103,6,17,26,156,103,29,165,201,213,187,121,44,126,73,89,165,98,234,61,107,120,113,2,233,176,147,254,212,64,117,150,211,121,63,205,166,59,218,10,211,198,24,48,50,219,99,193,2,196,186,200,126,235,88,0,229,3,95,118,209,141,130,49,104,57,221,239,44,59,40,189,170,72,11,36,75,78,213,196,207,159,211,10,188,188,76,106,40,205,146,69,113,61,253,9,65,77,15,238,6,85,8,101,90,46,232,10,50,35,114,144,168,167,168,186,119,254,81,112,148,33,214,194,88,24,248,218,40,146,15,15,24,2,56,82,123,5,225,64,254,52,151,31,228,118,246,162,146,116,215,28,50,128,80,44,73,218,243,246,76,27,175,172,166,29,189,30,178,92,139,20,120,133,215,73,120,248,26,231,65,123,44,221,240,31,40,54,53,16,161,186,53,87,253,188,12,194,111,194,177,54,77,126,216,177,179,18,109,24,133,27,226,119,26,109,199,231,220,211,1,4,70,210,53,254,187,152,164,204,221,144,215,108,1,1,27,66,186,171,120,134,84,64,137,232,116,97,115,100,17,107,21,239,0,145,206,14,172,236,237,158,61,88,194,248,31,175,222,62,148,75,179,47,68,49,33,137,166,190,30,183,124,128,236,201,87,63,198,97,211,96,200,191,38,73,214,237,9,200,154,118,220,247,146,127,176,130,104,147,24,214,137,154,246,50,215,109,105,234,33,14,33,137,75,70,192,170,32,208,10,41,24,195,12,2,22,68,207,242,53,105,230,255,218,73,5,130,249,238,237,41,119,57,30,26,252,125,38,31,32,191,134,42,91,13,240,167,170,245,103,76,116,235,134,195,253,12,90,173,61,253,158,30,149,62,173,0,139,91,12,2,143,151,160,78,224,206,218,52,104,4,212,152,19,22,59,68,189,81,124,30,48,141,118,62,233,232,250,248,92,133,22,168,43,156,98,182,35,106,1,240,206,44,37,94,50,229,200,109,197,189,181,73,113,32,229,177,162,12,99,161,215,16,34,117,62,4,198,245,182,19,178,198,241,148,156,31,211,75,200,251,54,238,10,91,66,204,117,45,120,160,229,86,176,251,53,164,195,112,146,163,57,80,174,252,173,172,76,86,4,176,119,202,171,62,123,169,2,107,43,54,30,108,205,132,232,234,97,27,191,106,60,218,195,54,191,43,237,7,62,68,165,79,112,158,188,227,222,44,9,172,122,29,162,121,12,40,221,73,240,167,246,164,55,168,90,245,85,126,95,151,123,25,42,126,70,148,86,100,27,152,61,219,59,192,177,143,254,133,180,153,95,175,150,217,3,54,31,211,65,99,94,17,232,13,221,147,61,111,253,136,75,106,72,105,221,0,129,211,52,85,191,58,161,129,36,203,148,150,248,142,189,218,181,235,58,196,117,203,226,251,3,240,73,176,179,239,108,219,232,66,207,19,0,19,133,25,92,23,53,223,245,74,44,229,11,121,225,84,122,208,208,30,228,154,150,179,251,63,121,80,53,49,13,42,61,83,2,228,242,65,85,223,30,185,151,62,44,169,234,5,184,206,50,161,103,28,237,225,17,208,244,108,169,140,18,184,141,84,130,232,172,54,224,74,227,44,179,16,20,173,31,194,138,158,46,244,241,200,2,89,97,139,184,161,34,227,185,74,110,31,235,60,166,237,125,145,191,138,199,171,78,185,139,151,24,24,39,58,135,13,228,196,18,254,183,107,120,129,242,88,154,164,29,137,5,238,65,180,68,50,130,113,109,219,68,29,28,156,194,44,129,96,215,98,243,143,94,35,199,30,64,205,254,122,140,187,123,4,166,118,120,19,32,232,35,45,200,72,77,134,198,95,230,154,111,146,133,203,43,44,156,47,39,151,42,241,166,185,83,26,77,56,25,7,57,67,64,247,203,227,169,141,225,65,148,253,86,22,27,28,92,45,85,216,231,161,205,103,138,241,218,115,159,117,69,119,33,76,15,214,235,14,215,173,238,136,85,12,21,95,145,45,175,157,177,31,164,160,112,56,54,154,76,95,110,111,57,135,233,62,42,195,201,37,56,22,94,234,230,137,38,100,6,91,32,253,46,9,112,35,112,138,75,117,190,71,248,119,226,241,242,217,165,182,101,140,42,176,85,166,197,56,0,43,22,59,67,17,160,243,159,61,145,156,251,228,21,55,111,89,126,174,170,42,219,41,53,184,159,115,85,168,65,15,238,139,247,250,56,42,48,72,64,172,27,249,132,72,201,197,38,2,245,210,170,45,71,174,181,45,101,110,52,38,156,124,91,88,223,168,94,3,133,239,218,238,187,233,126,203,42,59,42,71,198,231,179,221,125,207,161,130,29,195,213,168,22,160,81,24,4,188,46,193,96,25,77,162,151,148,167,101,130,159,209,13,26,96,60,78,78,127,149,107,129,21,130,130,50,186,61,255,88,184,196,121,120,228,121,190,147,135,31,99,80,117,79,73,11,252,106,255,42,167,14,219,143,50,45,1,145,197,242,203,214,133,252,90,235,249,29,62,69,167,146,147,196,81,89,124,153,128,136,12,42,117,44,210,211,110,88,44,230,146,166,18,186,207,5,184,220,27,168,108,32,208,194,139,28,122,120,205,102,170,101,236,147,247,193,60,121,46,116,196,249,225,46,83,220,170,50,141,12,71,85,235,195,234,6,60,179,189,25,37,53,113,218,185,126,22,20,128,191,219,97,73,10,193,174,36,246,66,233,47,202,65,173,154,141,211,52,149,100,136,57,193,88,94,215,110,40,220,143,167,170,248,248,182,153,168,38,158,68,253,60,221,15,88,236,3,33,131,238,60,101,62,48,199,206,9,81,50,166,167,71,213,109,22,143,106,170,236,138,49,179,35,208,199,2,142,28,25,81,51,244,135,59,29,216,197,160,138,1,251,252,89,180,124,63,94,45,63,112,239,58,37,169,54,78,99,191,190,249,193,30,49,74,178,24,26,7,107,43,78,57,131,79,66,188,38,201,42,148,78,196,36,156,202,18,139,137,46,252,131,21,238,175,42,43,81,163,30,167,221,81,246,123,131,139,234,159,26,150,167,160,92,228,186,228,178,121,81,51,130,40,6,84,229,249,48,64,236,208,52,131,186,228,165,225,108,7,223,2,241,179,3,17,87,48,17,210,162,193,22,81,161,235,153,59,21,82,122,179,74,18,98,125,188,166,42,50,234,210,24,33,228,120,188,208,237,42,220,149,99,211,64,175,201,73,23,142,94,130,141,206,69,113,154,168,143,142,53,6,25,26,206,211,2,65,78,171,127,167,226,246,165,182,169,82,6,94,85,126,41,105,245,230,41,10,231,161,212,102,12,51,197,190,66,143,104,12,176,184,141,175,36,112,172,54,229,31,117,45,113,114,2,232,156,201,129,228,209,215,86,172,112,116,109,117,32,62,176,105,59,255,3,50,207,230,31,25,220,201,240,193,132,234,224,252,116,17,161,78,178,232,64,37,171,251,82,53,221,88,161,3,1,247,220,138,150,88,106,163,135,211,110,185,48,31,242,93,23,44,145,44,76,185,53,138,52,248,16,145,46,92,174,228,251,99,215,37,32,240,247,162,14,156,69,229,22,181,81,80,65,215,107,26,191,109,130,84,210,81,233,162,95,142,255,240,234,198,231,194,60,176,99,136,85,55,200,87,155,245,58,115,254,113,7,137,97,250,175,234,113,9,171,72,120,180,56,3,178,253,64,98,210,252,109,121,69,124,70,237,220,21,126,134,30,204,171,148,164,175,84,67,162,112,25,195,2,218,177,178,24,169,0,131,102,171,25,144,158,245,175,102,194,107,230,113,127,254,204,191,191,164,115,242,22,244,68,122,251,75,6,85,26,71,185,205,11,27,117,250,156,96,5,24,250,200,169,101,155,39,42,252,71,12,17,82,197,113,178,126,0,133,171,44,126,148,18,33,112,210,112,177,101,0,85,163,30,95,255,248,217,67,145,86,93,34,240,196,142,151,71,3,23,159,17,199,8,41,150,221,78,172,208,161,40,216,231,128,210,6,78,46,83,70,130,216,119,137,45,140,205,92,91,54,106,108,225,36,48,181,241,36,243,179,151,14,82,242,249,157,166,148,12,60,202,32,97,28,90,42,162,179,228,154,3,126,158,173,56,46,232,110,153,175,94,213,245,51,87,130,50,5,81,185,185,249,254,178,70,169,181,194,14,230,103,122,156,228,60,29,83,94,135,225,156,53,65,119,209,133,109,45,140,183,188,245,83,25,177,69,189,123,18,2,156,27,207,131,111,178,217,163,233,167,242,34,217,93,183,204,106,90,147,113,16,106,140,238,217,139,125,190,70,184,129,50,252,241,138,160,254,217,99,230,253,165,86,231,165,152,115,104,178,141,185,231,112,85,146,164,143,21,197,77,58,96,200,29,227,203,83,61,131,2,249,175,31,79,27,197,36,88,90,86,103,189,41,124,32,79,228,24,192,29,65,41,253,238,107,197,68,97,26,234,91,177,187,255,225,142,36,120,111,27,134,24,85,49,87,142,43,227,255,181,126,65,2,123,130,162,13,194,216,178,94,208,51,50,122,171,206,229,17,87,162,194,170,109,232,5,238,125,95,241,204,224,158,198,85,212,222,79,147,18,245,76,27,143,60,225,79,196,70,151,52,58,22,221,137,3,187,151,116,139,236,23,63,202,204,89,192,70,179,175,16,106,103,203,152,190,47,204,73,42,77,67,126,6,189,215,134,255,134,159,76,163,125,3,92,148,24,233,8,148,199,146,135,158,99,52,126,214,186,248,106,170,241,118,6,104,46,69,232,30,115,177,115,250,209,161,41,221,104,18,200,168,172,110,153,25,146,228,199,63,200,33,226,168,199,106,126,225,245,141,224,196,93,216,187,139,79,14,233,135,168,39,84,109,77,180,121,26,32,156,152,147,238,56,202,54,185,222,56,100,18,115,35,159,252,242,91,3,93,76,174,198,99,126,82,248,3,239,58,179,99,95,181,107,144,78,227,213,42,214,128,172,49,173,198,135,246,113,228,233,239,229,185,246,18,53,154,7,123,130,115,88,220,201,95,87,187,245,17,209,127,31,58,134,117,165,18,116,110,133,27,74,120,77,114,180,79,223,140,102,159,229,215,249,239,180,88,29,26,18,60,194,104,94,178,8,185,254,103,234,128,196,222,64,206,84,215,5,250,14,106,70,115,210,174,35,103,237,22,224,8,111,80,205,35,92,245,251,243,56,207};

// The ranking tile of 128x128 pixels.
// Each pixel contains an optimized 8d key used to scramble the sequence.
// The keys are optimized for all the powers of two spp below 1in 8d.
static const int rankingTile[128*128*8] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

float samplerBlueNoiseErrorDistribution_128x128_OptimizedFor_2d2d2d2d_1spp(int pixel_i, int pixel_j, int sampleIndex, int sampleDimension)
{
	// wrap arguments
	pixel_i = pixel_i & 127;
	pixel_j = pixel_j & 127;
	sampleIndex = sampleIndex & 255;
	sampleDimension = sampleDimension & 255;

	// xor index based on optimized ranking
	int rankedSampleIndex = sampleIndex ^ rankingTile[sampleDimension + (pixel_i + pixel_j*128)*8];

	// fetch value in sequence
	int value = sobol_256spp_256d[sampleDimension + rankedSampleIndex*256];

	// If the dimension is optimized, xor sequence value based on optimized scrambling
	value = value ^ scramblingTile[(sampleDimension%8) + (pixel_i + pixel_j*128)*8];

	// convert to float and return
	float v = (0.5f+value)/256.0f;
	return v;
}
