// This file is part of the FidelityFX SDK.
//
// Copyright (C) 2024 Advanced Micro Devices, Inc.
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files(the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and /or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions :
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// An Owen-scrambled Sobol sequence of 256 samples of 256 dimensions
static const int sobol_256spp_256d[256*256] = {32,226,72,70,57,171,246,75,112,81,109,239,120,101,230,103,103,41,249,86,253,99,132,184,214,147,128,248,17,149,163,17,60,40,169,196,77,79,102,23,250,77,75,151,95,123,234,198,25,26,184,114,230,188,105,18,231,233,175,151,19,174,202,71,84,229,247,148,182,127,92,14,41,112,162,253,35,101,137,30,111,134,95,122,28,2,41,254,181,91,101,188,145,31,166,38,53,193,1,122,99,86,178,36,198,169,113,255,97,221,227,231,29,100,30,141,250,254,16,157,2,220,187,95,181,125,207,187,105,119,156,41,16,194,93,216,227,124,138,90,227,1,88,153,233,69,120,36,19,189,120,4,185,220,185,109,184,96,247,173,210,227,54,3,18,9,139,213,156,57,61,101,37,247,21,201,10,143,11,38,146,18,118,129,95,191,75,207,12,252,238,104,47,39,190,229,31,56,20,127,42,178,100,141,93,222,192,247,186,7,224,161,72,100,87,69,218,44,25,195,185,118,179,123,231,170,96,225,204,52,117,60,3,86,25,143,230,18,11,165,72,188,158,3,66,105,50,200,226,145,227,45,183,62,82,176,191,36,248,191,189,122,96,185,146,166,203,78,144,189,67,174,154,182,86,169,90,236,101,40,71,107,81,93,159,82,75,230,157,191,34,35,235,139,150,193,10,142,217,77,154,249,74,13,196,248,56,154,27,6,242,226,105,94,66,67,145,112,31,145,133,68,21,0,44,212,254,153,183,238,98,102,145,199,100,213,196,52,131,141,216,209,236,122,58,249,188,108,8,206,62,199,207,103,160,247,207,255,101,185,1,113,223,126,182,0,50,93,250,174,194,18,65,111,206,104,156,3,48,195,122,212,10,101,235,200,13,183,173,7,192,3,101,228,84,168,121,241,205,122,115,132,155,242,215,22,236,242,69,35,48,245,3,175,68,57,4,15,226,155,222,140,54,48,80,200,194,149,213,68,225,14,182,122,147,195,69,166,191,17,176,58,222,58,190,70,66,153,196,215,121,123,176,190,161,145,203,121,255,27,207,28,113,22,44,232,46,84,181,131,245,220,27,202,161,38,94,208,39,143,52,5,154,85,121,139,226,223,159,246,170,56,94,209,188,71,205,76,16,233,168,172,200,37,19,123,120,202,28,175,232,88,120,107,157,198,111,253,18,24,36,35,43,169,199,197,137,194,12,238,138,232,17,17,58,115,39,234,4,164,225,215,14,185,232,76,215,171,142,206,206,132,90,31,130,24,0,165,34,91,126,113,64,202,144,114,132,125,58,184,234,211,246,238,168,7,1,172,169,218,67,29,185,66,73,49,222,167,243,189,36,116,23,223,219,200,84,67,94,53,79,26,202,204,91,180,221,166,106,18,207,17,128,137,246,235,162,13,129,130,49,76,104,189,138,55,174,71,152,49,116,204,207,103,198,147,225,142,79,8,172,59,234,225,192,168,181,144,185,6,233,243,61,123,46,55,44,16,228,79,156,235,190,115,61,162,115,182,122,230,138,204,140,86,173,80,99,207,211,181,23,141,152,17,180,35,121,168,67,205,107,74,55,229,234,210,6,94,48,186,210,189,2,200,190,181,227,128,211,225,215,228,74,7,188,195,36,82,10,131,96,99,138,63,1,210,39,134,153,112,72,163,196,55,126,37,125,107,234,166,129,80,61,97,121,20,123,222,3,155,219,62,49,207,87,182,26,214,167,142,89,38,36,112,87,100,56,245,240,152,23,7,237,11,185,206,233,203,131,42,53,35,60,40,211,114,9,13,189,130,196,210,173,39,208,56,110,34,240,65,75,234,76,73,34,39,2,118,174,237,52,194,197,28,155,161,135,180,200,3,89,210,26,154,145,45,57,54,85,26,118,207,212,58,101,69,202,184,36,234,219,155,41,29,80,22,193,175,145,100,50,29,149,166,168,162,213,130,36,25,234,78,84,97,191,139,95,156,9,12,41,97,110,222,8,16,250,161,130,45,111,195,83,213,16,141,154,48,124,175,89,25,27,9,172,242,51,167,76,109,69,107,23,80,23,166,12,16,180,156,182,238,148,249,59,130,75,122,59,134,240,69,220,21,230,47,1,124,66,180,77,247,147,103,66,98,211,96,105,213,127,178,144,102,213,33,247,141,232,67,62,86,230,222,146,68,122,27,147,7,85,69,31,22,67,67,78,13,149,221,57,121,176,133,161,84,201,146,119,196,217,19,132,52,76,135,247,107,29,131,248,220,156,248,29,41,36,202,174,136,253,191,226,91,179,96,69,213,172,0,206,75,192,54,69,120,138,218,171,185,232,211,139,8,31,11,50,119,28,197,83,158,170,229,244,195,190,23,213,87,70,17,102,197,39,59,88,152,234,95,106,29,195,236,114,136,6,159,105,101,2,119,184,47,212,218,188,165,163,138,174,114,71,54,127,64,183,39,51,42,209,202,106,96,215,154,56,33,102,25,62,111,9,49,4,98,142,198,128,138,13,74,95,229,42,164,19,175,179,111,138,19,157,125,94,34,221,103,246,144,141,176,129,201,55,100,23,12,139,33,227,91,223,224,69,120,83,245,50,57,190,21,54,86,245,95,250,34,71,249,100,201,144,16,221,0,40,74,133,38,145,48,217,119,132,34,138,67,161,62,221,126,108,207,140,42,156,13,224,198,142,19,55,85,254,155,140,168,250,58,118,137,42,78,8,48,89,195,167,91,243,246,88,23,22,206,17,190,56,125,171,116,245,129,121,57,144,228,159,197,243,217,239,86,188,152,88,239,112,120,245,119,147,189,25,128,240,72,208,29,162,23,152,24,143,226,136,174,171,58,178,10,5,250,209,239,88,62,34,251,156,163,231,247,102,112,46,48,61,233,24,71,54,73,12,81,195,243,115,138,145,194,164,135,148,51,201,104,74,24,78,107,65,246,118,159,165,130,206,34,157,177,180,10,126,163,167,129,75,0,149,115,172,21,242,139,162,170,92,238,35,46,24,108,101,62,26,147,180,210,227,166,103,149,188,192,92,115,141,161,120,90,231,250,181,130,208,232,151,157,141,208,27,81,82,42,162,244,186,62,163,6,254,94,107,138,123,144,14,216,138,235,104,135,98,77,82,57,47,77,171,213,192,134,69,226,93,197,9,63,181,197,169,22,248,190,55,178,250,167,76,157,101,170,138,94,156,44,12,155,102,133,133,149,43,224,51,130,44,138,3,195,25,161,29,216,1,188,160,73,4,196,125,240,92,88,50,192,176,234,39,109,96,39,60,165,226,80,248,179,232,244,141,102,81,131,110,19,206,225,222,115,198,63,195,251,19,155,77,51,194,251,124,13,77,69,106,112,114,187,126,67,222,81,227,163,80,172,25,70,205,111,48,160,111,165,112,243,47,236,107,81,15,83,95,132,80,133,178,116,87,10,195,139,151,122,44,82,111,24,234,156,187,202,250,20,233,186,204,184,154,149,117,78,205,119,71,166,192,239,88,148,154,229,200,139,163,129,12,155,167,252,50,198,46,106,221,91,235,75,2,14,240,122,62,178,218,42,223,213,6,17,212,242,32,190,96,163,121,63,228,65,111,229,63,70,140,232,221,248,216,80,5,145,12,27,33,195,86,111,42,125,70,44,232,82,209,40,234,168,224,215,215,133,247,128,76,248,178,34,253,61,204,193,105,44,227,66,45,238,159,16,241,67,99,178,235,181,68,204,234,144,58,40,132,125,203,25,204,148,151,253,195,198,81,8,54,248,148,248,58,54,235,82,71,67,181,212,241,43,111,111,202,69,166,200,66,87,245,207,70,112,64,26,240,149,82,86,28,104,17,59,72,154,106,1,173,59,21,204,184,231,15,224,161,253,174,78,249,25,217,35,144,180,57,102,174,57,138,227,125,141,246,16,35,201,173,170,31,107,205,169,59,19,52,209,226,49,136,168,13,238,63,53,78,203,68,18,146,228,165,245,244,84,215,78,230,167,83,239,15,210,34,99,90,184,143,187,50,98,95,182,121,47,53,112,15,53,239,130,105,66,142,11,185,224,203,20,44,156,28,197,195,65,118,36,206,88,55,37,18,112,9,20,231,73,6,11,225,79,180,145,124,204,29,245,148,198,53,210,171,103,53,215,106,111,154,237,107,2,249,79,145,126,255,255,53,222,196,57,237,131,6,63,45,70,68,190,191,12,210,247,162,41,135,184,234,206,153,176,115,255,114,178,110,24,25,66,114,55,29,79,253,67,124,245,37,236,13,88,232,186,18,143,178,59,5,237,10,249,253,37,88,46,134,71,53,74,172,186,69,137,11,154,60,68,120,125,100,91,182,239,177,38,28,125,208,165,38,150,207,244,41,88,127,241,251,168,84,195,111,37,211,165,113,3,212,184,180,207,48,52,204,171,213,128,154,138,218,69,214,154,99,201,203,109,93,71,190,5,99,1,72,173,15,149,49,253,51,82,171,179,114,131,68,114,133,15,104,227,141,109,39,68,225,130,50,51,133,154,148,48,28,230,9,43,157,50,133,203,239,37,160,233,120,54,20,116,57,174,116,158,45,8,196,14,200,80,203,212,233,1,0,88,172,214,196,22,192,224,142,138,146,230,105,100,153,155,112,241,124,26,71,253,143,4,191,50,49,88,226,25,142,141,13,12,50,159,122,211,42,168,23,217,253,218,151,135,3,152,114,102,191,76,186,42,124,70,19,56,25,85,234,58,57,225,230,253,56,194,107,134,142,201,213,43,14,33,242,16,141,205,196,99,143,100,115,5,99,128,100,221,174,110,191,83,165,164,78,60,124,209,199,63,185,120,175,43,3,24,40,153,1,83,147,223,112,72,242,148,166,115,36,138,42,13,63,1,45,173,225,83,121,19,23,208,171,146,240,108,150,3,213,83,210,238,72,120,80,197,2,4,159,197,138,216,19,178,24,173,212,237,169,129,129,102,51,63,203,142,11,134,180,207,105,98,133,253,20,224,6,126,194,167,33,132,90,101,179,113,216,222,132,30,88,23,229,210,85,6,154,226,252,17,39,174,208,255,8,11,252,159,110,195,86,250,59,161,218,31,140,167,41,33,201,143,250,68,82,205,44,4,77,43,214,212,60,82,214,41,44,125,236,152,34,64,133,184,58,145,227,65,70,73,166,49,21,158,242,114,42,75,209,36,72,188,192,146,223,138,76,27,235,115,153,105,169,96,209,231,4,33,105,226,175,187,91,218,12,73,168,214,254,98,208,113,214,116,177,49,34,94,22,127,175,12,155,193,56,187,115,187,240,136,234,206,189,250,115,219,154,17,52,62,198,63,225,81,77,90,127,246,219,192,106,223,78,102,88,142,46,208,156,230,196,67,182,18,112,210,126,198,59,15,234,166,243,77,61,149,24,223,70,245,142,178,199,101,195,190,109,78,244,224,12,84,52,158,184,88,212,155,159,128,187,54,48,209,190,202,157,70,122,109,33,221,124,227,1,196,124,121,163,138,238,25,129,134,83,111,124,60,142,46,143,48,85,63,5,77,46,251,193,209,81,108,149,108,1,47,137,175,85,106,148,27,204,145,104,3,152,84,228,215,113,141,6,117,115,151,206,248,61,43,182,198,76,88,12,222,132,75,73,8,205,190,32,12,159,70,205,4,158,0,107,220,104,90,223,181,80,7,111,166,130,16,168,145,218,242,101,35,165,172,12,217,239,157,76,37,238,176,63,124,243,45,101,181,191,200,64,186,170,42,104,154,191,224,67,145,240,72,82,103,93,108,220,251,36,178,110,145,98,136,83,2,171,177,220,23,98,221,2,160,216,219,237,90,105,255,48,157,136,55,102,122,181,7,225,55,229,254,215,169,94,22,44,65,136,50,190,151,198,54,132,81,245,106,71,91,141,176,162,15,210,33,14,140,108,81,17,135,249,17,44,15,121,28,16,114,178,210,7,129,250,11,239,18,86,203,161,124,2,185,178,83,110,168,3,81,125,80,149,8,67,30,212,0,129,8,77,255,114,243,68,8,119,210,232,104,244,127,165,159,26,176,206,160,228,34,116,10,3,91,65,149,163,43,43,44,171,113,113,223,206,17,63,64,215,216,94,118,5,139,66,201,213,30,120,149,18,236,99,41,81,175,245,1,7,171,209,151,134,28,32,122,201,13,18,46,236,215,113,188,192,221,39,69,117,121,255,119,26,59,142,121,126,238,179,163,183,245,98,199,32,46,39,137,236,232,52,138,4,60,86,83,12,100,44,195,49,107,228,105,56,183,18,177,222,50,189,188,97,197,148,94,99,1,198,221,121,206,54,31,212,145,62,73,77,213,189,38,66,13,139,69,173,57,26,11,176,245,141,166,141,203,10,48,45,201,17,131,241,115,13,165,235,28,129,88,72,36,124,169,128,6,145,10,109,219,198,187,90,149,67,215,68,116,33,56,204,217,236,231,0,205,84,97,113,175,30,185,95,187,166,164,123,103,0,218,18,150,180,103,151,153,146,97,15,161,171,246,252,131,198,186,58,55,210,93,58,157,3,142,220,98,50,202,151,2,115,205,200,3,236,146,210,233,71,222,129,198,18,131,29,157,152,63,201,45,197,253,170,121,124,232,64,197,112,22,208,106,99,54,41,247,146,135,234,142,177,3,38,157,234,222,46,189,233,76,41,150,255,135,82,99,244,246,187,81,215,16,76,188,188,104,156,21,239,255,206,97,35,217,194,13,70,106,106,238,171,232,93,223,145,190,50,39,144,48,13,113,146,151,178,156,18,131,231,168,108,178,224,7,44,122,98,87,166,65,220,174,138,98,95,93,188,127,246,195,136,215,160,201,137,35,217,167,126,219,175,109,180,111,127,222,93,69,133,2,58,198,186,238,108,57,157,101,174,249,26,46,210,254,251,76,43,197,209,161,52,197,28,246,173,229,35,43,13,81,122,34,245,212,223,50,135,69,70,192,171,78,9,135,189,54,168,232,131,250,208,59,227,252,247,231,40,235,203,254,51,25,198,223,165,81,140,141,67,194,180,31,194,172,47,195,56,153,118,221,30,217,17,85,154,184,122,15,130,179,86,8,37,33,200,95,144,73,175,68,185,197,128,182,154,171,147,182,86,172,23,236,20,92,194,110,253,124,133,82,127,206,92,34,108,69,170,47,61,41,87,108,218,3,244,7,124,51,153,83,186,164,116,154,85,123,43,135,177,107,28,189,81,241,214,189,235,233,142,6,109,183,130,75,79,107,99,67,31,164,248,227,114,159,230,115,116,115,252,33,75,4,171,191,217,88,245,156,203,48,239,140,253,211,46,184,136,34,21,248,161,128,156,16,88,64,71,34,174,125,70,164,125,92,205,214,79,157,199,223,143,214,138,213,150,169,17,16,181,95,200,208,91,91,55,125,7,1,39,91,6,103,252,246,22,71,110,149,236,73,1,247,51,2,168,88,124,234,86,100,6,94,1,17,215,157,34,238,126,194,222,109,67,175,96,45,252,99,58,3,34,192,251,95,240,36,188,243,191,229,74,164,55,171,108,239,73,208,140,114,46,244,36,30,33,56,14,209,94,86,28,9,153,30,23,102,165,252,98,77,72,233,22,126,152,98,40,246,35,93,137,114,191,114,200,54,214,8,238,145,43,119,180,186,55,74,170,232,166,247,56,233,9,162,16,241,95,47,5,109,72,125,67,35,130,55,138,75,157,246,85,244,3,230,60,226,159,12,234,155,160,180,119,243,253,179,202,194,53,218,65,208,230,212,71,228,29,49,220,31,146,244,249,84,46,237,203,93,171,73,33,115,46,109,10,163,137,73,18,133,213,236,174,230,216,119,127,80,199,18,100,180,236,191,127,152,158,226,45,72,70,181,106,90,21,229,46,41,109,55,237,81,0,158,169,63,40,22,85,246,181,235,161,180,28,175,136,87,132,184,54,121,185,69,89,58,20,54,81,101,87,37,251,152,4,162,108,113,248,178,219,151,240,144,158,242,185,138,4,34,148,255,250,66,75,144,141,25,248,244,89,180,203,97,141,149,179,129,213,186,64,101,242,119,130,121,108,230,198,74,228,155,96,237,140,201,158,44,127,161,120,219,94,11,95,27,145,80,184,107,215,88,252,32,89,59,97,159,249,183,75,131,180,65,184,179,85,80,88,74,128,53,126,191,54,169,0,133,100,248,196,158,91,121,110,12,248,130,87,248,186,85,136,101,181,0,90,45,34,227,84,17,40,96,221,187,167,131,112,48,70,62,240,138,78,245,248,226,203,255,32,242,246,141,200,17,167,32,151,12,72,159,221,190,56,115,237,233,226,113,71,228,167,60,113,127,28,174,27,176,227,160,77,221,157,64,14,166,82,60,78,7,91,16,214,169,78,222,97,33,229,210,4,255,104,234,42,181,7,177,190,23,40,135,53,67,63,28,151,60,167,81,21,190,110,214,160,222,51,228,87,83,113,220,46,182,163,193,79,214,249,120,197,244,197,169,252,20,33,253,246,46,198,16,208,35,110,5,37,236,172,149,234,155,32,36,8,249,70,224,226,40,16,146,131,224,173,250,111,102,227,160,196,255,167,81,196,62,24,6,39,4,245,139,98,158,201,247,5,6,2,61,92,5,65,70,24,206,135,30,246,146,155,22,29,247,25,112,186,5,208,134,240,95,137,29,48,148,222,92,36,165,248,10,244,222,158,131,46,156,217,243,219,101,123,98,209,124,89,178,16,48,173,142,241,134,127,160,217,64,134,35,244,28,253,59,26,10,212,162,143,252,94,0,198,0,16,156,116,145,64,255,206,234,251,104,250,213,247,171,89,86,125,48,237,216,196,160,45,90,227,12,33,58,31,88,200,117,101,36,105,135,49,134,64,181,233,40,63,100,189,192,13,48,58,159,183,105,34,162,170,166,132,83,141,116,29,39,216,84,29,224,211,54,145,251,248,148,150,203,26,51,179,47,134,175,80,66,223,24,221,52,170,59,241,37,95,232,183,15,162,203,144,221,60,248,8,211,255,78,249,55,59,23,131,11,165,152,182,82,168,71,89,48,249,78,107,182,117,73,21,79,42,128,232,89,103,207,13,224,32,236,175,138,201,54,26,98,122,91,253,144,222,108,171,101,120,208,168,40,29,46,64,23,171,248,115,40,80,28,107,143,65,188,142,205,155,234,86,121,157,124,23,44,177,188,201,222,229,244,169,241,155,62,102,187,15,28,49,168,157,29,135,202,9,160,102,125,112,184,31,209,162,114,13,130,215,93,15,255,110,50,54,19,144,98,47,46,170,252,210,5,161,176,69,185,97,187,253,94,124,215,85,69,73,136,150,68,137,217,52,113,151,241,70,44,102,126,10,143,167,133,81,239,233,109,73,171,141,93,133,112,185,133,103,206,49,208,130,79,127,234,48,173,231,82,200,74,68,194,188,185,26,56,199,134,122,3,153,227,174,245,23,34,49,20,68,184,202,1,232,252,31,171,45,85,7,114,187,66,203,169,98,117,144,15,165,104,143,111,174,100,197,60,7,53,248,238,100,12,162,96,40,189,247,101,64,57,57,14,195,114,229,155,228,32,111,37,141,8,8,163,2,223,6,96,54,144,175,85,141,51,77,41,60,192,113,15,103,101,44,30,102,189,100,251,227,71,37,62,123,4,63,119,25,116,47,205,191,156,1,106,136,248,37,151,162,72,226,41,208,133,69,146,114,137,43,245,90,115,117,90,122,134,180,218,136,10,36,210,53,138,90,139,213,130,56,173,119,174,71,72,213,138,87,171,101,156,110,0,164,38,191,156,215,148,220,106,138,50,237,54,37,49,215,127,45,81,226,61,181,195,147,154,208,170,94,34,8,228,121,71,182,239,63,56,65,244,0,70,162,73,198,63,16,134,216,58,187,203,234,115,44,209,105,127,183,130,74,82,203,219,128,128,162,13,47,106,252,31,56,155,184,119,56,139,70,241,3,104,153,43,183,28,68,241,224,25,154,52,51,131,108,142,150,13,106,43,251,166,76,47,218,150,11,125,109,109,179,145,213,217,241,16,32,208,48,33,217,59,171,245,248,174,34,191,77,111,183,221,49,141,59,221,76,224,103,190,107,171,215,232,44,84,133,236,88,227,175,24,57,144,252,229,182,140,36,219,42,92,101,187,212,188,34,205,167,99,168,91,224,154,187,112,52,190,62,212,191,250,250,68,229,248,142,143,161,185,243,117,222,69,61,162,247,179,140,133,135,164,217,144,222,8,114,20,240,161,44,27,187,82,122,237,53,167,43,2,215,122,219,61,163,54,181,154,176,222,239,12,13,63,88,213,167,98,162,94,254,89,113,112,242,88,158,65,229,215,16,126,234,96,129,34,233,231,85,152,90,16,97,32,90,134,18,131,114,130,148,249,76,135,186,171,103,192,83,45,100,96,36,88,217,197,165,86,194,168,112,149,125,108,133,112,117,199,26,221,35,245,88,233,9,113,47,138,31,61,114,47,51,32,197,55,17,175,164,93,204,223,215,203,221,224,147,103,78,214,230,214,71,214,220,169,117,39,0,147,198,108,242,153,155,144,235,250,162,35,53,61,45,156,227,244,108,123,32,227,129,77,252,146,213,168,197,237,147,123,38,228,75,144,165,144,102,113,198,22,145,14,101,195,177,43,62,151,113,96,81,189,204,180,207,197,24,72,76,135,127,181,246,81,18,167,113,85,184,62,190,140,86,209,148,134,111,32,60,108,33,233,115,99,216,239,112,146,92,217,236,252,213,215,98,122,215,64,175,155,179,121,195,7,207,252,163,51,58,143,187,255,188,122,6,199,73,36,149,218,141,142,43,108,99,2,232,187,65,216,24,169,125,102,148,113,59,233,176,194,207,77,204,245,20,43,145,104,88,88,212,187,237,152,64,18,141,254,53,255,111,53,61,62,49,143,145,197,10,207,36,198,166,88,7,199,42,201,145,219,135,53,239,108,162,82,202,181,4,255,82,23,38,141,213,120,0,218,105,2,141,120,255,138,20,27,255,97,202,151,0,166,227,16,196,48,139,91,164,4,170,177,243,27,154,220,212,167,205,179,84,245,205,50,51,155,45,39,99,124,70,27,48,182,173,3,26,38,214,1,26,23,216,248,214,89,78,142,7,44,2,118,103,73,72,202,187,222,242,74,37,84,166,251,191,67,11,231,116,61,33,17,96,93,116,165,173,88,153,105,123,125,159,243,89,143,66,211,213,23,47,204,192,2,231,229,224,32,30,45,9,31,149,216,137,119,152,34,22,131,206,47,216,201,89,197,58,66,204,67,92,0,150,199,161,213,185,96,252,164,78,46,247,41,134,48,118,14,77,30,250,176,12,138,96,58,51,142,9,249,103,99,29,247,189,31,126,29,86,211,201,108,216,195,90,32,119,124,219,207,128,192,119,91,217,60,215,24,182,244,100,241,153,24,3,99,115,167,33,25,239,186,42,198,202,179,57,117,112,11,208,212,50,26,170,22,148,206,252,232,159,56,64,37,184,40,232,109,62,164,199,64,198,112,56,71,12,215,108,220,20,211,118,70,182,19,212,219,182,104,5,188,255,61,162,241,25,176,78,25,176,239,21,205,246,214,246,86,45,101,158,9,252,149,38,59,72,225,119,121,209,20,85,6,84,253,24,182,126,20,150,105,176,238,54,59,96,46,28,214,21,80,112,19,118,125,115,134,244,30,35,230,238,255,199,220,32,200,9,142,2,182,14,101,191,176,143,96,217,200,124,194,43,105,61,93,143,135,53,12,228,233,30,150,173,228,73,179,184,84,21,117,63,245,231,49,129,29,249,46,23,172,195,94,36,76,227,246,71,159,188,8,88,119,49,177,156,203,88,101,195,170,151,183,106,100,9,246,64,254,1,90,4,9,163,154,231,88,68,182,99,67,75,171,107,142,196,79,237,114,70,178,128,33,83,168,67,129,82,214,135,38,206,41,152,140,168,52,239,28,171,28,29,180,246,185,183,243,85,129,112,168,63,139,133,0,162,86,166,48,132,244,159,151,235,175,64,110,168,85,97,233,11,62,25,177,16,57,124,63,250,59,218,136,209,136,192,23,168,160,206,65,84,30,73,213,235,181,104,66,27,98,126,183,219,93,200,115,84,141,57,55,20,131,91,14,228,85,181,19,4,110,176,90,101,40,91,107,155,7,70,21,114,154,141,146,125,246,64,1,216,213,232,23,143,224,115,244,247,144,186,71,134,69,183,141,25,186,91,29,145,163,250,202,181,57,216,172,131,228,242,181,187,52,94,218,252,4,118,44,52,124,160,37,176,17,218,121,140,191,107,102,91,222,49,91,229,106,179,221,170,200,88,38,138,167,10,48,157,47,99,57,137,88,76,206,141,214,208,48,80,226,18,227,6,175,180,63,107,247,251,197,59,51,247,13,109,209,162,206,192,125,112,94,235,247,26,88,14,126,241,225,249,81,162,7,157,238,150,138,24,69,121,155,219,17,169,180,218,93,230,99,92,139,53,179,145,30,14,205,171,75,247,49,194,3,14,177,24,222,122,30,75,174,121,243,104,233,244,81,4,47,70,43,206,113,229,119,231,49,72,144,78,214,29,193,41,75,14,97,19,84,148,246,3,250,243,7,246,233,153,48,135,226,204,199,93,210,3,97,11,106,117,170,122,92,97,150,179,177,220,46,59,17,151,242,160,233,237,81,78,255,87,243,237,113,135,216,131,97,197,224,41,142,85,234,243,135,58,152,220,191,227,149,78,77,30,82,167,63,217,43,227,106,173,223,128,161,49,70,29,184,169,178,179,124,224,2,243,210,229,112,103,15,29,78,229,91,9,68,198,94,135,241,207,69,183,229,46,78,63,189,93,163,10,91,172,13,205,180,217,216,102,237,239,3,217,247,218,0,147,130,158,175,242,39,94,23,238,221,229,211,72,140,103,207,7,73,10,200,247,155,254,35,165,152,2,137,237,154,128,235,215,210,1,132,104,143,128,91,191,225,241,171,220,16,165,209,59,10,1,128,151,229,116,17,20,188,108,57,196,105,197,5,64,216,75,255,49,10,35,243,39,238,142,201,1,32,8,28,116,21,216,226,89,90,231,210,128,81,149,93,249,111,150,128,11,228,231,236,178,74,34,174,187,230,84,78,197,136,17,197,25,242,154,123,24,78,245,178,254,76,70,182,72,15,115,54,62,10,89,172,129,113,97,148,204,240,100,172,169,122,13,95,182,26,184,25,191,255,250,250,137,18,19,72,145,135,112,125,227,63,65,26,54,228,181,30,158,27,191,9,236,168,115,248,144,187,132,253,45,84,154,196,103,30,149,123,53,42,206,172,146,175,44,203,69,239,45,147,0,121,103,125,132,136,192,38,62,79,29,241,17,151,110,28,38,221,234,230,228,182,64,241,144,165,124,145,120,49,50,129,18,33,242,212,143,68,167,109,134,179,113,176,85,93,87,105,133,15,66,249,8,43,9,147,72,30,6,2,85,185,204,160,20,76,70,119,163,67,200,121,228,185,204,22,48,31,122,177,123,93,159,108,114,65,90,91,67,95,139,6,187,3,78,142,38,96,61,68,23,146,93,32,245,153,131,61,126,1,194,201,158,51,161,172,0,176,76,143,229,81,201,36,157,210,139,109,215,12,9,41,152,243,188,240,144,194,27,114,193,162,39,43,9,203,46,137,76,217,93,125,215,74,43,75,0,153,246,95,88,44,134,248,43,87,166,46,133,1,77,197,205,206,31,50,102,178,248,22,226,192,156,203,195,155,193,32,35,158,173,76,75,79,240,112,7,161,130,162,85,225,67,223,15,127,53,24,49,231,201,248,16,114,146,228,17,178,247,166,162,2,32,180,41,188,9,197,103,77,246,35,30,71,112,6,222,168,64,60,248,242,61,201,130,219,58,182,38,143,103,45,104,219,7,121,119,138,183,148,149,107,216,169,2,89,111,185,120,49,74,173,174,35,38,194,214,86,32,216,229,123,41,64,108,178,152,13,174,71,86,192,147,84,112,246,98,151,238,63,210,134,112,5,28,254,154,125,236,82,78,22,114,230,212,88,97,54,211,70,203,48,159,59,21,36,55,56,141,194,247,133,160,138,224,66,180,74,137,37,94,5,120,135,170,119,209,147,221,28,19,215,139,29,199,87,234,102,225,111,74,180,27,169,131,129,29,44,138,81,235,206,181,229,133,192,201,163,110,48,203,245,95,200,183,29,29,31,255,74,216,148,92,109,191,130,29,236,248,204,126,228,208,76,200,13,128,197,198,255,211,23,197,132,124,133,71,155,21,132,233,191,189,212,255,108,47,94,109,53,232,234,95,174,83,223,18,188,255,239,215,139,141,51,127,243,199,103,111,117,45,101,67,184,104,196,20,34,25,184,251,144,47,226,217,214,217,125,47,52,41,242,113,104,13,56,74,44,166,36,63,154,133,145,18,80,160,124,59,47,48,219,63,43,134,67,115,238,189,252,67,6,164,83,181,123,230,213,252,7,222,130,221,30,79,68,34,162,2,61,134,162,207,49,146,161,216,82,98,181,190,57,57,164,128,97,121,148,131,128,152,66,106,247,15,154,148,82,42,174,142,17,249,123,23,138,78,106,245,159,202,19,26,160,50,138,153,136,182,101,89,247,195,169,69,220,50,155,45,140,251,248,183,139,84,17,44,98,83,13,102,234,106,135,22,255,212,246,163,28,11,251,123,18,5,150,221,6,2,137,17,176,56,215,12,166,187,52,149,11,97,119,140,245,13,201,20,98,80,27,26,125,126,58,232,231,83,52,195,75,116,248,147,230,123,171,77,81,168,163,120,39,158,18,54,60,212,117,67,148,122,151,78,51,30,88,27,152,83,92,191,105,162,106,233,12,27,116,4,53,100,189,242,253,169,182,10,105,196,84,229,122,141,80,15,0,38,26,50,176,229,18,32,169,241,202,190,190,225,100,193,44,196,209,193,83,89,43,228,8,127,48,9,221,186,199,251,97,138,218,190,131,202,206,62,148,128,44,48,107,164,177,57,149,171,214,244,57,198,194,87,179,232,10,17,65,243,255,109,19,208,42,55,68,178,164,84,21,57,206,5,27,252,203,144,108,90,231,137,198,221,204,164,204,56,73,223,129,127,246,244,144,140,13,229,195,199,39,42,93,103,202,8,45,68,203,17,186,154,9,154,228,59,255,134,120,125,170,90,18,141,31,17,116,10,189,48,63,147,112,188,11,184,92,95,253,180,92,80,106,57,112,187,229,228,69,3,1,47,47,72,146,48,135,37,111,82,27,20,77,157,222,115,123,120,119,159,196,99,7,116,57,222,119,79,79,212,213,215,145,225,154,187,25,22,126,89,170,169,123,159,94,29,177,63,137,207,167,192,97,134,193,17,236,199,8,35,214,220,156,72,183,180,8,63,200,171,93,216,103,110,145,159,209,158,236,233,50,228,220,144,113,159,214,222,157,156,27,133,183,240,127,191,28,41,222,148,155,247,32,97,96,128,237,98,236,159,107,157,192,176,19,81,248,145,219,183,179,73,178,81,38,137,81,108,189,148,180,164,63,244,107,140,13,253,2,84,88,16,121,200,120,77,203,104,24,207,202,194,62,253,155,102,96,168,116,28,237,163,138,91,149,34,82,230,211,109,230,176,130,28,82,186,233,159,99,238,249,81,38,106,243,246,4,63,80,43,104,47,1,253,236,84,79,158,5,81,26,18,242,70,42,11,229,216,154,236,16,203,159,227,7,207,120,26,197,81,87,177,4,32,197,147,111,255,229,91,211,194,195,230,35,169,151,31,196,33,181,120,192,254,71,84,152,228,208,209,129,98,55,39,210,144,146,192,231,249,121,170,81,218,202,197,150,149,234,93,90,178,167,209,244,86,25,140,141,156,206,14,247,240,217,14,39,99,82,121,16,119,157,210,169,220,50,58,255,48,130,189,120,154,59,60,85,94,135,23,15,171,6,31,212,224,89,73,100,179,91,61,170,128,28,33,227,9,149,128,12,110,120,44,9,52,192,4,24,65,221,114,24,77,109,0,237,94,4,42,232,84,150,134,32,50,33,84,234,130,136,89,117,253,79,60,135,69,29,50,128,196,38,41,43,37,78,168,73,163,249,45,207,177,76,38,115,76,143,118,145,106,166,6,142,230,193,147,145,87,195,222,73,219,219,89,33,68,237,118,120,146,164,74,130,237,16,47,79,228,9,153,184,5,127,80,182,81,105,196,51,244,192,237,160,118,200,191,94,235,152,191,202,161,231,171,19,116,102,94,206,253,175,4,193,18,70,53,214,98,123,181,137,167,190,84,96,169,2,204,232,54,221,169,175,186,172,137,170,75,32,249,57,119,86,19,52,123,234,142,11,108,19,58,84,98,250,242,114,170,31,205,195,117,12,243,41,93,222,0,101,219,102,129,196,192,91,8,186,233,243,37,194,183,162,121,59,93,71,52,178,114,96,72,252,185,254,109,31,107,112,168,64,226,160,216,43,49,74,50,139,112,148,135,148,88,184,35,26,29,171,245,47,96,61,39,146,159,194,252,57,202,244,245,218,216,18,29,71,237,39,25,197,164,184,67,97,53,45,16,218,207,244,97,249,96,167,93,62,103,162,164,67,186,159,2,26,136,32,184,9,167,169,183,210,72,43,253,167,72,211,171,205,117,92,82,32,5,197,107,8,68,106,237,8,142,148,101,227,90,210,67,13,252,233,3,242,79,95,172,175,195,246,251,254,247,71,7,224,252,37,255,4,158,178,131,23,77,77,22,178,114,155,151,162,207,53,98,63,132,143,232,73,194,185,91,243,57,47,83,36,154,42,31,150,56,15,33,40,14,111,70,137,225,158,138,108,119,114,255,48,176,231,182,51,219,163,86,122,80,104,197,169,107,181,97,55,228,63,47,73,106,27,23,65,207,177,34,218,221,147,192,237,165,74,89,152,255,181,169,250,226,99,10,232,6,181,45,3,222,174,26,248,155,12,199,237,65,205,85,22,125,164,146,124,17,73,140,71,36,57,173,173,157,157,161,35,164,157,190,71,67,29,142,133,206,231,64,185,95,111,65,166,220,233,245,73,242,25,16,29,223,124,142,199,177,13,24,198,245,218,190,115,38,32,45,236,12,96,101,63,17,230,151,217,117,234,153,112,111,91,162,196,247,185,166,60,2,8,145,56,160,48,175,226,250,67,51,132,106,42,213,138,119,167,9,240,25,8,56,22,165,218,9,62,218,121,29,43,177,130,210,166,150,15,220,225,225,152,34,255,104,115,223,108,131,55,250,255,49,92,130,20,179,218,73,38,116,122,102,17,118,237,183,109,65,232,122,235,4,68,3,245,160,150,224,73,183,115,6,100,124,166,210,201,82,249,142,15,23,20,60,118,137,170,181,229,205,108,201,240,169,87,195,99,76,138,15,228,158,47,216,146,8,248,175,110,207,39,94,180,173,250,47,24,2,201,150,241,233,238,16,120,75,140,84,49,212,106,98,213,162,86,181,76,170,35,124,116,48,164,197,74,131,117,229,28,19,139,154,0,123,202,110,178,10,79,113,166,22,172,117,191,54,48,27,183,59,223,105,57,148,54,241,188,72,118,58,255,33,235,238,206,33,254,197,162,45,154,226,221,57,145,225,19,36,11,164,245,79,188,132,50,190,248,255,75,183,214,242,69,109,232,147,130,166,70,86,58,124,161,96,88,92,166,32,184,117,117,232,148,14,163,81,163,242,0,239,41,82,240,105,189,74,68,200,164,195,85,62,74,56,226,196,41,2,105,154,95,205,207,232,106,98,226,99,112,210,188,162,203,188,28,65,78,18,252,134,93,120,74,188,64,154,12,133,146,228,14,25,9,13,157,22,83,145,169,201,189,221,137,49,232,138,179,182,165,146,2,109,172,21,172,40,157,230,199,70,170,17,231,133,250,192,45,75,214,33,111,3,120,209,54,12,206,159,226,150,136,96,94,25,66,56,178,106,7,73,214,104,156,236,28,249,93,15,229,9,0,132,16,69,155,125,179,207,94,14,13,244,207,241,54,32,52,63,98,162,154,191,75,209,229,33,193,255,57,31,229,86,153,43,207,166,165,245,54,40,212,29,222,70,136,130,40,74,185,218,104,130,108,129,245,188,86,215,76,131,33,190,168,234,99,175,11,251,216,73,187,108,44,255,201,238,119,247,44,86,81,235,45,3,57,216,75,34,73,180,36,35,240,164,214,36,117,135,41,119,211,38,76,81,196,8,21,97,136,235,119,71,123,36,176,199,227,228,108,128,149,137,5,164,77,148,159,81,47,176,108,234,54,46,235,56,167,178,84,254,105,129,190,49,65,57,236,213,149,152,10,85,206,195,221,92,221,54,74,114,134,198,83,208,132,62,75,99,76,23,147,221,170,238,47,2,231,238,159,31,157,21,230,120,116,37,205,171,183,193,105,172,143,117,1,93,76,23,54,218,89,41,8,34,70,14,172,247,13,165,93,149,104,106,13,209,88,202,31,127,1,56,213,196,57,128,219,160,128,36,102,11,50,241,144,120,109,249,181,6,101,158,193,159,198,121,72,53,117,201,226,238,36,19,89,190,170,97,242,166,133,255,187,116,117,149,110,240,34,46,115,10,173,23,253,193,26,88,218,204,250,37,212,109,250,201,191,194,118,95,136,247,161,207,241,204,135,2,78,149,74,112,131,147,47,174,61,6,17,165,170,245,205,230,27,4,219,42,253,132,224,5,105,216,149,164,189,139,111,218,70,124,62,36,131,167,58,160,166,166,15,182,6,55,43,51,18,46,56,174,90,10,0,14,29,74,85,33,208,147,69,176,90,198,106,36,37,30,25,35,124,178,130,4,84,25,198,20,229,53,83,27,191,7,155,221,115,87,5,220,83,80,84,102,251,48,221,102,199,149,98,72,199,4,97,43,61,78,97,140,141,115,8,36,76,209,170,73,151,35,27,50,135,70,240,173,0,121,54,23,163,78,109,212,129,93,171,216,134,28,83,113,141,233,192,101,187,144,201,55,84,241,226,162,50,111,152,243,114,9,111,93,4,89,234,55,65,28,241,78,143,188,189,252,70,80,238,69,204,212,181,122,171,109,189,186,144,136,240,116,95,234,155,53,70,170,203,113,36,46,45,134,195,163,140,104,104,25,181,136,167,116,55,237,25,77,120,91,44,239,159,52,190,41,227,220,175,171,101,213,127,105,222,163,58,68,40,210,118,247,1,76,42,20,189,248,76,43,113,25,81,37,26,154,234,25,226,251,39,69,143,3,138,235,220,47,9,31,25,63,195,193,72,173,92,80,43,152,143,80,74,126,49,33,238,113,228,171,168,241,82,49,174,116,73,94,130,72,230,253,161,187,183,237,195,41,153,143,130,252,152,169,147,185,106,2,207,13,134,90,175,141,157,242,255,161,154,42,107,178,145,195,16,211,119,181,175,211,84,142,39,77,187,239,159,12,177,186,243,150,95,140,58,167,52,103,146,158,98,247,173,141,219,214,180,87,55,184,155,216,203,67,81,243,45,171,219,220,110,144,106,5,138,225,212,232,110,202,220,68,84,250,115,120,118,200,167,154,108,73,90,190,72,34,47,249,229,114,4,80,142,144,22,68,254,128,128,196,171,194,100,131,176,168,30,203,107,42,65,59,156,176,21,156,53,86,125,203,58,216,87,127,233,238,153,162,195,175,35,133,212,69,25,61,96,246,99,19,132,120,219,58,140,93,223,248,9,43,246,147,166,10,33,40,237,26,6,87,228,81,182,159,34,234,48,74,27,30,186,36,136,63,92,110,3,131,130,27,239,155,0,156,219,146,232,148,189,133,204,227,35,102,6,13,242,251,69,127,251,171,127,248,242,116,126,174,84,115,6,193,135,29,128,225,230,162,23,222,79,106,4,26,156,61,251,88,57,81,76,237,7,19,107,37,95,147,230,99,193,76,98,87,252,124,217,105,200,201,204,245,189,226,154,95,54,19,34,64,85,66,163,243,6,203,46,201,0,174,183,154,181,226,46,152,199,255,75,54,243,29,83,133,231,240,6,21,38,68,184,253,109,54,23,224,31,102,11,112,103,43,17,38,125,238,71,104,161,159,219,136,215,196,141,170,10,56,156,93,207,152,188,114,22,157,0,165,25,138,205,58,248,67,193,58,28,147,32,38,229,221,175,114,14,42,161,2,223,231,204,164,6,92,49,52,64,37,164,223,252,197,118,55,243,108,10,158,239,219,175,244,102,22,194,134,212,9,249,244,43,86,97,41,53,9,224,110,61,250,140,202,187,95,171,204,21,221,58,141,24,176,120,96,194,232,84,28,125,246,218,142,73,131,254,249,22,179,71,110,208,97,247,139,162,171,64,251,79,190,180,190,186,29,110,165,88,119,225,30,58,64,49,68,45,83,93,122,136,199,146,158,106,5,211,222,64,64,160,74,72,185,138,112,186,135,133,95,31,236,77,86,54,59,235,32,245,245,133,152,27,233,115,154,253,233,222,36,218,216,218,211,137,127,103,199,95,165,151,234,33,228,72,167,103,13,43,119,38,71,23,218,227,177,230,222,214,149,81,102,246,94,251,84,233,90,116,77,26,118,194,122,55,75,208,137,52,159,238,73,8,33,157,218,178,213,108,45,131,207,210,31,144,133,204,239,144,183,230,251,195,57,195,154,39,61,36,39,117,126,121,69,224,198,15,198,98,59,82,181,202,28,149,49,219,53,48,163,19,164,57,251,219,61,159,235,12,121,100,151,160,191,93,194,90,22,119,28,191,219,210,170,234,145,2,111,53,86,140,171,46,232,231,111,18,43,83,2,142,131,38,36,99,174,3,26,169,105,31,214,250,212,191,8,1,141,69,73,158,180,248,93,117,146,242,10,188,63,7,61,149,69,118,161,141,117,25,193,18,187,220,194,82,13,30,5,225,194,158,252,56,159,129,5,240,0,213,85,67,54,209,242,151,41,141,172,187,12,215,255,6,5,126,185,11,225,35,202,5,182,98,154,26,217,237,193,140,136,38,71,118,166,44,17,223,179,101,97,16,153,33,21,204,15,219,189,120,219,24,117,23,4,153,22,143,40,174,238,185,27,159,69,251,1,227,108,218,69,111,198,184,236,14,216,136,208,115,154,211,47,149,116,98,114,40,90,83,116,92,109,38,134,140,104,157,197,116,57,122,111,5,224,4,175,201,244,62,210,203,188,216,230,131,214,184,164,54,48,242,179,251,201,77,16,77,13,77,23,34,66,146,24,12,187,238,151,92,139,64,114,217,125,244,175,10,155,138,118,58,245,52,121,17,241,62,231,105,214,169,120,184,4,155,16,20,12,215,206,40,237,161,186,68,63,141,166,178,6,127,126,151,70,195,245,163,96,91,23,138,173,211,99,103,164,14,51,246,20,75,76,135,150,74,215,220,71,15,76,77,215,250,38,227,176,76,17,15,179,232,18,19,165,54,194,146,187,110,158,216,55,66,145,232,119,152,61,63,121,155,194,202,244,22,81,66,36,140,38,108,209,21,139,25,159,255,185,60,117,9,245,95,46,99,220,27,61,151,235,253,38,161,64,188,88,189,117,249,42,176,56,54,107,62,80,240,135,153,86,180,137,121,111,177,208,196,3,194,236,106,173,82,40,195,1,146,180,204,141,11,192,120,252,52,4,116,199,14,254,104,216,4,219,7,221,233,33,47,34,247,94,0,104,240,54,18,128,85,240,255,179,195,197,161,240,178,242,197,103,68,166,60,95,131,245,148,198,163,124,209,39,120,42,206,15,106,91,118,113,89,19,66,66,241,200,64,65,37,82,169,139,136,203,234,192,172,175,27,160,244,10,91,4,183,109,177,183,93,233,92,26,227,67,87,232,184,97,234,202,240,80,213,42,133,15,68,206,0,206,110,170,227,223,113,90,208,60,11,93,245,151,50,51,86,152,199,229,35,248,13,119,64,238,165,152,108,70,48,149,157,110,249,189,25,187,246,251,124,64,0,176,165,128,174,39,200,94,100,193,34,233,19,192,83,39,177,228,74,234,195,128,251,203,238,192,16,66,200,223,179,30,106,195,189,26,217,157,142,161,132,38,20,179,217,79,34,97,189,231,106,19,144,223,172,39,206,91,192,115,254,111,141,170,103,121,61,72,101,60,110,173,73,193,25,89,206,122,137,151,213,60,169,7,42,226,224,249,190,43,17,190,187,240,163,77,26,192,162,70,170,154,216,20,183,212,229,81,56,157,247,123,219,168,91,21,53,107,174,135,98,32,176,146,78,98,190,30,232,190,171,107,188,254,223,5,25,58,134,150,36,28,218,134,107,40,253,245,199,11,1,191,26,173,238,5,142,204,170,161,157,127,172,254,27,185,235,87,15,3,74,170,36,195,132,163,3,126,33,178,173,141,106,23,111,96,111,124,164,68,230,2,210,18,190,148,45,70,148,194,38,160,67,130,166,172,81,5,91,142,239,190,58,3,102,81,212,68,68,73,134,6,117,116,100,47,57,100,207,232,224,125,32,30,193,162,117,36,57,8,27,203,56,199,110,251,56,35,162,240,157,224,0,42,206,199,201,33,95,5,127,132,29,178,152,101,166,1,242,99,155,248,47,71,180,75,84,99,65,91,32,31,136,206,52,48,74,184,208,83,85,179,51,105,125,87,66,145,207,127,71,239,255,157,126,120,139,232,35,64,70,128,118,191,41,217,7,185,86,117,216,187,163,194,206,174,218,56,214,58,160,248,111,154,70,17,108,212,91,199,245,32,108,125,43,198,192,38,68,101,100,147,129,87,52,240,50,91,92,218,108,127,101,155,228,123,77,147,41,86,207,159,139,140,93,22,169,163,63,89,236,154,98,131,93,39,55,237,122,107,6,174,184,202,126,27,199,141,16,52,167,250,44,52,64,134,244,66,235,39,127,190,88,127,61,105,107,157,35,59,146,10,14,155,241,227,170,104,180,47,95,20,235,236,196,100,29,66,255,252,236,249,128,214,5,234,40,241,34,234,45,47,166,217,121,36,243,35,251,23,126,3,133,136,164,113,22,69,236,180,239,139,48,255,146,161,48,135,129,150,245,193,181,210,85,120,4,249,147,174,66,17,136,154,208,148,214,82,198,29,171,4,223,212,84,104,93,95,153,151,59,52,212,150,113,85,179,189,60,151,118,28,93,220,49,114,124,228,164,99,165,40,1,5,200,121,138,132,77,15,5,21,162,216,252,37,141,224,202,125,209,225,242,62,177,195,93,254,238,77,226,148,168,119,167,195,151,180,25,60,215,48,166,94,44,45,114,159,78,24,155,132,119,38,31,231,227,51,37,35,33,239,40,171,12,250,68,190,248,231,228,59,213,61,15,65,53,179,92,176,23,172,176,32,72,135,37,241,24,107,242,184,186,57,99,239,241,14,0,114,211,202,79,176,88,52,130,56,18,75,55,22,208,79,100,1,57,105,53,174,100,13,234,232,158,118,211,9,144,128,160,76,177,166,10,90,95,110,144,254,243,190,208,135,184,198,226,200,27,9,38,241,0,208,210,237,180,2,22,149,157,19,155,249,21,3,55,195,149,105,206,24,110,148,19,249,58,78,186,176,25,100,216,4,198,194,104,71,150,103,193,54,223,28,146,80,51,157,194,14,178,180,189,161,192,44,225,168,111,47,225,151,43,100,26,191,125,146,222,221,199,216,186,126,173,89,90,229,77,60,34,228,75,219,182,85,232,170,22,24,130,197,101,20,253,116,141,176,241,34,223,208,190,53,49,201,93,144,151,241,108,236,120,86,232,128,234,238,83,111,80,172,96,67,34,128,6,29,10,136,122,7,204,83,50,186,1,23,79,169,21,92,114,15,132,236,51,188,123,139,240,236,199,67,208,132,52,13,194,187,174,29,120,140,151,198,252,88,147,102,219,35,162,73,126,98,77,213,8,169,217,193,210,100,239,19,153,49,43,252,194,75,228,65,143,184,39,77,42,202,171,40,113,137,164,157,33,120,131,63,197,218,5,250,238,192,175,128,92,206,161,173,254,238,133,100,158,136,16,101,127,238,52,208,92,82,3,217,66,93,246,228,193,254,74,72,78,122,33,105,54,8,66,93,246,194,222,27,194,33,125,31,125,186,243,13,92,218,44,36,132,226,180,89,124,205,104,135,159,122,252,15,162,223,62,10,250,171,0,131,127,85,178,231,79,207,40,253,46,196,118,242,128,72,35,191,117,82,21,59,50,253,123,77,220,143,104,20,203,224,176,13,252,32,28,67,43,91,75,244,94,186,135,19,180,199,223,127,142,98,37,239,28,103,87,65,235,18,238,103,120,238,30,86,59,98,172,2,220,161,99,43,3,209,122,161,55,146,255,1,36,249,99,184,3,3,168,72,232,46,73,223,106,79,159,210,38,156,147,51,126,50,165,108,52,49,96,42,238,80,99,70,146,206,224,54,97,97,16,213,14,248,251,126,49,66,87,134,179,227,232,143,91,185,125,0,158,183,5,242,48,7,152,160,171,198,163,34,181,199,170,68,125,93,97,109,136,230,150,33,113,56,104,7,226,175,49,100,51,84,213,22,135,7,237,200,148,72,116,142,163,153,122,86,4,164,15,210,118,24,67,210,223,220,137,144,48,144,180,185,234,2,241,154,213,43,109,156,143,172,26,128,135,231,119,24,217,131,61,148,77,141,150,92,115,120,2,154,217,75,86,241,208,171,108,103,82,89,209,129,238,172,132,255,207,27,146,164,74,184,68,92,141,13,124,214,138,185,244,149,236,189,182,103,67,87,10,32,216,220,143,80,210,206,245,104,149,139,20,55,5,113,172,207,125,29,89,249,19,112,108,14,88,182,201,165,18,10,245,121,6,178,148,34,12,59,196,61,173,239,178,241,33,155,25,242,134,32,227,233,188,135,113,163,52,64,251,178,224,118,246,79,167,5,63,212,177,112,180,80,242,169,49,210,21,134,141,17,157,190,91,64,227,91,38,133,159,225,105,247,226,195,200,172,31,220,215,170,68,107,20,234,183,178,143,56,158,107,86,223,172,215,193,84,10,65,89,99,158,61,203,224,96,108,213,54,164,149,13,125,118,120,95,189,114,57,41,211,241,237,209,190,6,62,79,184,242,245,149,195,91,85,198,131,178,227,71,202,112,154,51,82,29,130,223,121,113,6,199,251,129,30,201,68,187,181,197,35,52,79,104,12,235,40,127,72,62,197,101,25,50,235,135,22,61,18,204,9,17,58,139,193,112,118,161,34,157,65,113,190,135,176,140,117,20,216,176,111,50,116,217,162,214,180,80,45,31,21,53,93,2,228,123,100,207,17,230,207,97,240,183,85,31,41,46,45,3,43,72,155,187,165,203,128,67,28,120,236,54,20,65,238,109,110,179,222,136,198,17,77,149,130,251,103,177,204,150,184,189,37,5,55,241,217,14,130,255,116,126,175,235,144,116,140,66,14,51,205,67,99,220,51,208,79,206,154,127,22,85,71,77,215,145,255,44,243,64,209,227,67,73,110,151,218,87,197,55,237,118,245,39,169,244,170,245,203,108,245,142,50,189,176,80,21,202,93,146,1,53,148,177,158,56,213,31,235,149,163,76,7,160,96,185,175,209,247,27,135,158,217,147,16,10,240,197,137,20,206,239,82,56,27,22,220,198,2,89,79,127,31,142,1,6,55,182,200,142,137,107,201,174,111,181,210,207,62,30,104,243,208,79,121,233,86,23,51,192,246,38,237,63,185,68,166,75,123,229,116,251,234,207,59,122,231,68,113,211,62,70,25,143,151,209,232,208,160,147,131,216,54,242,90,239,63,40,144,174,63,16,36,202,26,114,183,89,217,89,136,230,91,48,252,125,202,164,150,89,145,56,123,247,12,54,155,187,186,61,40,196,208,28,136,119,101,36,210,226,52,175,235,200,109,39,72,109,208,243,138,191,212,112,241,255,140,84,135,41,149,18,74,71,117,169,225,47,36,251,47,104,143,61,234,88,50,148,255,119,218,157,33,205,193,198,233,229,11,62,162,92,119,220,137,255,123,184,226,35,157,8,174,39,63,216,248,137,225,131,8,2,82,204,80,214,39,91,209,189,161,6,81,144,36,198,76,197,109,194,10,4,72,54,53,184,115,91,225,10,11,168,200,46,218,124,246,135,15,89,53,166,8,241,71,83,123,154,209,50,174,37,55,123,83,140,20,54,44,56,182,163,26,6,6,190,38,53,147,232,222,149,68,107,255,157,252,151,137,92,252,145,148,33,103,9,72,231,13,116,195,38,2,23,236,159,143,19,6,218,213,124,179,244,182,30,110,173,19,168,90,131,57,252,205,106,250,34,115,21,156,227,2,178,233,51,164,166,165,72,112,14,41,93,38,111,111,37,191,106,207,33,185,185,90,72,233,134,236,98,171,160,112,169,40,190,94,93,171,234,98,137,93,127,65,248,80,186,131,116,191,197,63,31,50,255,195,58,34,142,54,220,246,198,63,55,183,44,126,0,217,209,232,158,8,7,110,86,107,240,61,28,52,138,97,149,20,247,180,192,143,33,83,155,177,22,187,216,48,139,83,169,139,99,123,154,74,125,236,38,59,46,27,30,157,211,15,232,203,47,94,136,56,194,51,139,205,174,21,161,217,7,160,227,59,236,156,91,143,154,27,42,117,22,168,18,246,201,35,37,107,157,58,5,158,76,100,112,62,84,117,50,22,6,96,111,120,207,116,151,161,13,67,239,116,206,98,64,136,103,8,201,197,9,81,239,18,226,93,190,46,81,229,232,167,200,193,215,90,182,212,93,78,67,26,105,97,197,49,164,150,52,143,248,121,13,95,217,227,206,14,80,200,179,171,10,146,200,142,90,137,125,253,146,71,131,33,45,48,69,241,119,153,254,188,241,25,222,97,30,63,46,136,159,57,134,89,0,129,234,189,184,64,200,208,245,48,167,116,134,99,230,3,164,217,19,159,106,99,97,202,22,164,70,66,13,97,32,58,239,114,37,9,60,59,67,157,37,172,251,50,177,13,116,63,7,119,74,90,248,108,175,187,95,134,112,101,157,132,160,143,70,245,232,144,69,184,106,150,9,184,122,224,32,162,162,167,166,203,10,237,99,78,75,217,159,250,237,184,75,97,163,68,55,215,93,14,236,225,12,141,49,8,40,126,117,77,135,80,77,205,97,75,21,26,145,221,123,172,2,182,77,86,93,204,86,114,144,92,13,141,25,97,222,15,100,182,160,159,142,35,220,49,107,187,208,137,105,153,135,0,174,222,172,239,170,133,207,178,208,164,230,211,2,139,92,32,192,133,89,232,32,239,245,110,166,136,37,21,196,131,79,242,98,209,25,180,252,102,119,100,85,102,115,189,106,122,226,157,178,221,143,154,92,187,57,68,241,18,33,225,250,134,114,116,72,134,250,27,40,97,219,30,86,74,184,102,193,26,66,181,24,165,153,255,190,75,185,18,121,114,85,220,59,224,145,174,176,36,67,144,74,196,161,88,9,48,79,220,4,67,25,232,105,176,32,242,28,201,66,116,178,36,164,218,208,31,240,68,239,166,138,242,198,226,27,136,232,255,174,210,152,60,200,61,15,238,2,218,231,198,130,236,180,235,65,221,66,82,162,92,235,251,20,38,65,92,156,106,85,0,144,25,182,28,226,88,153,34,253,19,27,116,90,101,248,35,202,216,184,19,35,2,94,8,209,254,66,212,135,68,219,185,32,107,225,25,227,136,211,138,181,174,112,128,190,66,165,251,135,185,108,40,159,222,177,26,58,26,148,218,89,13,15,27,236,24,118,78,33,185,174,168,219,230,119,230,179,169,161,57,118,97,227,203,9,125,55,136,197,112,94,138,136,230,112,204,245,136,116,59,13,75,68,121,43,122,9,22,252,149,172,182,118,113,61,53,171,44,42,118,178,166,69,222,44,157,34,128,126,179,24,154,159,106,149,17,227,58,143,176,241,222,56,42,62,181,26,208,33,24,30,33,112,83,127,84,65,41,251,206,115,178,2,222,106,153,209,238,98,208,200,210,177,133,86,65,23,104,110,177,161,96,79,57,142,162,15,207,173,153,56,254,250,73,76,74,43,36,200,57,145,60,95,227,21,147,221,41,171,192,107,234,251,74,126,3,247,128,122,243,153,128,202,238,189,17,198,179,70,97,245,190,200,231,176,186,98,217,254,45,230,228,185,78,204,155,64,247,183,255,152,161,26,12,21,183,209,199,194,177,1,221,95,77,76,253,203,104,7,192,167,209,180,50,138,227,189,182,231,239,238,168,59,221,119,154,107,247,102,200,51,40,120,192,133,47,249,238,189,123,233,117,188,210,82,68,72,178,111,103,77,144,205,181,97,1,172,166,152,242,0,187,181,174,188,39,82,5,75,21,213,113,66,102,62,173,169,132,21,120,138,226,211,39,44,143,160,126,74,108,191,13,117,58,148,234,239,194,161,161,156,231,240,170,77,120,106,63,168,175,231,243,60,192,181,236,20,52,239,78,141,78,130,59,219,80,208,24,37,165,109,209,49,251,9,62,80,50,249,181,232,42,228,47,166,191,144,176,206,148,242,148,153,182,121,24,128,65,137,42,161,119,66,94,240,11,55,102,122,7,205,142,144,144,180,47,60,218,192,149,85,15,213,83,8,79,215,104,8,209,172,222,200,242,28,255,51,185,167,33,226,26,65,147,100,114,222,54,27,170,212,207,83,56,170,37,126,121,14,18,40,231,4,14,164,248,6,110,118,48,51,83,228,76,3,131,87,77,86,163,48,72,194,109,53,105,118,111,198,140,133,34,20,119,56,35,236,7,170,176,164,95,86,183,232,105,108,7,25,169,127,50,26,86,83,94,101,58,219,72,205,46,231,78,158,94,221,190,147,92,96,224,0,30,65,191,21,237,118,106,224,247,161,116,33,41,10,92,81,248,232,191,41,72,116,171,89,110,208,62,230,196,11,67,172,81,188,8,212,62,255,199,22,201,68,20,120,21,90,72,70,211,251,61,232,5,238,147,16,91,225,65,103,178,238,63,246,157,100,192,170,206,249,101,28,25,120,125,225,94,105,146,218,75,10,178,103,244,73,77,174,18,113,205,198,233,5,88,129,66,64,72,137,118,81,217,130,206,156,174,224,223,115,249,164,10,160,47,237,255,135,146,236,13,99,71,63,62,20,134,132,135,155,27,21,239,159,60,195,224,248,123,205,45,147,225,233,72,95,151,236,249,144,43,148,51,197,175,100,140,185,170,200,234,37,87,113,85,41,197,41,164,33,181,64,228,58,125,41,220,43,111,47,37,139,69,75,126,166,210,12,7,175,6,63,122,236,237,156,149,142,254,174,11,37,215,82,200,54,62,74,43,2,249,172,218,115,203,91,14,165,110,103,178,200,5,226,141,45,42,68,130,198,173,253,230,217,122,113,39,163,182,160,231,100,179,40,207,8,27,212,22,174,85,58,27,55,118,83,118,244,201,68,167,205,50,31,36,17,250,228,187,200,203,159,109,44,83,197,240,214,82,128,207,62,237,127,108,238,226,36,190,44,152,27,248,90,79,254,43,191,182,206,138,179,239,133,27,56,192,25,166,40,83,172,241,62,178,172,53,58,205,73,6,139,66,50,24,22,193,232,205,173,161,67,139,236,13,114,239,156,46,253,12,218,238,6,255,169,98,117,8,215,156,102,178,212,208,18,175,147,108,96,73,71,115,87,75,254,77,61,212,49,252,42,72,23,95,49,206,208,189,203,240,139,4,56,101,109,139,204,117,23,213,104,47,1,254,115,179,25,96,58,221,157,53,112,19,110,172,118,168,11,21,171,109,123,100,79,124,202,172,155,236,144,86,224,44,183,119,167,51,180,139,191,76,201,173,212,215,120,148,255,149,110,69,229,152,112,197,133,178,122,15,23,55,103,67,13,152,239,59,168,53,175,130,232,143,236,0,96,95,206,91,141,167,127,199,149,82,51,222,51,43,148,225,183,56,32,68,76,97,35,154,233,207,47,2,29,114,143,36,159,81,168,169,22,163,74,208,233,149,204,129,138,138,13,48,180,42,41,155,141,156,228,19,71,135,137,63,119,146,67,61,236,133,52,209,164,39,67,110,28,5,36,100,159,52,79,220,118,89,126,230,63,180,117,243,165,179,147,209,255,162,97,177,43,45,86,56,48,223,195,122,39,130,118,8,183,36,55,42,221,83,72,74,95,130,91,23,121,226,221,206,241,204,44,105,177,188,105,190,84,106,225,244,183,44,76,188,169,150,98,155,208,244,161,94,75,232,173,64,126,153,184,124,75,229,87,31,209,154,93,125,64,53,167,155,250,167,122,169,184,231,14,34,61,208,47,179,182,194,37,87,240,10,125,2,26,125,232,189,207,199,3,153,204,157,148,33,93,160,134,67,238,203,126,198,203,210,112,25,199,23,136,192,135,207,227,224,213,125,17,93,230,177,178,164,152,162,80,107,50,52,221,42,20,128,143,202,168,22,91,223,159,118,214,249,29,184,124,24,124,1,183,54,43,61,91,155,116,241,94,157,187,60,100,244,97,97,177,9,57,90,72,245,38,31,86,172,41,102,15,35,39,4,233,141,9,165,41,137,229,44,122,16,181,99,178,84,124,207,34,140,41,145,250,172,186,100,100,156,162,5,126,187,160,57,183,240,17,46,181,44,120,144,141,151,142,129,195,192,11,203,241,78,134,142,214,106,198,94,141,84,62,51,127,110,9,65,150,68,221,157,131,236,130,114,10,128,197,13,157,252,8,165,223,138,108,179,156,231,156,82,132,196,202,13,64,69,92,110,180,238,15,125,240,30,231,134,56,66,31,193,191,100,72,106,233,11,113,8,121,238,178,117,107,157,215,58,43,212,236,53,215,214,1,16,192,173,175,231,62,113,26,94,248,47,30,36,232,160,227,75,161,127,33,5,192,210,69,155,249,190,217,224,42,17,77,54,231,20,45,5,116,154,154,80,74,148,126,85,137,13,59,123,226,167,20,148,24,19,123,17,78,46,126,232,255,147,20,83,85,103,16,86,141,246,211,162,58,245,162,77,31,51,40,174,164,117,38,201,18,8,240,124,226,180,213,190,92,223,249,184,227,8,168,86,142,19,66,247,142,54,135,218,13,197,216,225,152,61,155,156,171,88,150,158,129,132,144,138,13,21,166,17,156,62,40,147,131,134,66,228,77,177,184,53,207,92,208,3,16,2,45,215,154,73,196,92,47,104,0,94,23,103,132,206,81,105,63,84,231,7,205,95,148,128,250,142,158,42,49,223,26,22,72,27,211,39,245,201,245,4,127,48,221,21,121,201,223,108,209,6,93,31,85,112,207,74,123,201,78,249,139,38,60,134,47,225,21,74,31,177,146,41,144,16,100,28,219,207,21,104,154,200,135,169,238,147,227,243,217,211,187,109,182,74,223,148,201,132,46,26,159,121,196,145,148,161,153,126,127,103,44,44,215,135,248,8,157,23,184,220,82,173,81,229,136,173,243,230,69,68,158,137,156,73,166,209,116,155,166,231,141,186,187,84,175,227,63,227,13,18,245,222,185,2,9,97,179,58,174,246,67,94,255,153,44,100,138,172,19,5,67,221,82,20,224,61,104,222,44,53,106,82,147,130,225,31,218,140,64,109,45,5,216,165,119,100,159,228,18,213,150,192,59,85,135,249,36,228,230,57,28,67,206,105,230,148,212,28,106,92,97,2,31,152,107,208,11,10,205,238,102,126,66,83,190,233,77,232,77,96,85,249,251,119,192,179,5,0,198,67,127,22,157,78,146,64,204,6,39,200,12,229,227,234,242,193,195,141,125,107,248,143,210,251,18,220,67,240,110,48,114,110,15,160,241,14,133,152,132,225,44,134,92,88,11,167,164,225,12,234,164,92,9,175,74,190,164,193,157,232,4,137,216,80,165,124,20,254,221,2,198,63,217,156,135,119,4,178,58,153,215,139,67,52,172,206,47,40,75,33,86,67,63,41,10,20,37,237,37,156,4,13,25,23,201,228,9,237,67,16,22,116,17,184,162,203,188,227,13,110,65,231,79,200,61,118,207,68,161,90,71,47,113,31,224,165,90,23,21,239,63,80,176,54,103,99,60,125,72,207,90,110,231,121,225,205,35,28,16,137,252,136,94,179,14,97,157,227,66,82,219,137,26,78,157,181,147,28,161,251,43,196,201,53,245,149,152,194,86,91,70,203,91,114,199,241,212,180,125,44,131,135,116,26,132,69,27,84,222,132,88,96,163,119,62,129,249,230,33,147,28,124,23,172,231,132,144,182,235,125,193,70,233,206,77,27,210,203,223,213,95,105,230,117,205,214,164,126,23,240,10,34,237,211,43,162,138,230,118,192,86,247,125,167,215,62,26,113,209,175,19,231,246,167,150,22,44,69,31,236,205,198,210,214,123,93,60,9,175,131,96,145,71,92,190,209,201,225,103,43,204,242,98,253,129,95,56,223,107,29,87,165,180,44,49,28,37,42,83,215,122,91,126,77,38,243,71,213,191,223,14,76,247,97,110,190,120,147,167,234,237,10,98,148,45,218,3,23,117,15,148,142,173,118,236,90,31,27,85,54,188,202,253,43,102,109,130,17,8,239,241,89,212,14,29,172,179,90,8,104,5,203,117,188,43,184,167,54,8,100,136,17,55,201,102,193,221,245,173,86,65,162,176,40,92,214,101,18,82,59,131,63,156,187,219,65,190,115,172,242,52,181,80,109,165,136,98,148,149,152,234,86,143,132,100,239,159,119,163,250,30,130,119,190,45,58,208,104,161,144,10,202,200,31,177,215,242,236,78,3,151,34,8,16,172,231,112,71,159,168,32,208,230,50,84,234,214,40,92,65,60,148,117,76,216,111,91,121,177,66,86,123,55,54,126,46,118,241,103,105,245,89,242,0,0,166,87,7,145,164,227,90,30,10,4,88,64,114,70,127,14,161,218,198,16,35,230,115,54,65,108,190,175,186,252,79,33,24,82,118,130,249,181,253,61,28,154,77,227,209,111,63,61,68,223,162,41,90,176,37,114,169,199,77,160,219,199,22,79,240,212,158,243,217,226,74,158,215,193,166,204,82,135,0,106,12,155,150,113,241,197,33,205,6,16,19,118,164,194,115,243,112,162,251,134,203,122,124,61,242,68,140,200,131,168,172,123,48,70,132,227,199,3,196,130,48,55,231,64,216,195,86,36,160,233,137,145,108,224,93,218,61,107,191,138,171,13,215,212,65,223,117,85,120,109,207,141,12,23,221,175,68,130,129,185,138,67,225,85,127,85,215,75,146,79,69,133,10,129,210,51,71,147,116,11,104,76,194,87,78,137,12,108,185,53,10,210,35,135,33,203,224,96,175,47,98,138,83,60,163,16,100,51,21,186,245,7,153,128,164,73,27,189,195,13,61,255,96,12,174,169,37,39,235,177,224,137,71,128,240,63,137,238,255,68,185,212,135,190,156,240,184,158,113,210,241,119,224,63,177,236,63,172,135,117,74,27,187,227,253,246,222,134,197,251,197,243,107,188,160,85,252,111,4,141,195,243,91,73,226,144,131,109,136,10,172,209,186,95,172,96,107,43,22,44,176,226,122,100,50,28,65,163,62,235,88,16,254,97,48,250,64,155,101,21,83,64,255,189,98,142,60,20,184,3,54,87,20,50,178,254,138,105,53,169,141,5,88,57,244,207,138,191,208,185,54,87,134,70,182,197,77,248,201,118,133,148,231,106,241,215,91,61,184,61,250,9,140,91,66,203,141,93,171,166,65,183,29,234,196,85,230,194,177,148,240,126,71,14,92,212,2,120,179,141,11,42,166,15,45,196,187,30,249,247,104,244,5,25,126,208,252,253,157,224,36,138,145,222,221,213,15,204,112,217,50,193,215,194,2,248,214,48,43,229,7,204,79,218,223,82,137,114,228,41,220,68,157,35,245,242,213,255,141,189,192,243,63,72,119,222,107,252,230,192,211,47,186,209,144,213,221,185,22,152,208,54,130,76,100,242,54,210,211,40,29,189,40,7,183,252,209,130,240,76,107,14,110,35,151,57,0,187,180,78,210,153,198,18,212,33,205,72,211,89,150,175,136,7,138,13,18,93,226,93,52,171,126,188,165,113,29,15,231,234,11,67,54,164,115,158,58,48,20,202,65,198,247,224,202,190,45,10,153,146,148,150,218,67,157,27,190,197,15,182,135,56,130,43,203,209,174,134,100,81,179,58,182,229,1,155,224,135,148,214,99,38,92,212,220,49,17,170,248,161,123,88,92,5,119,19,210,149,12,254,121,21,140,38,10,247,25,4,22,186,68,1,211,221,109,182,103,137,4,242,129,66,67,138,61,50,131,83,208,81,53,132,36,86,63,33,62,142,250,210,195,68,246,210,84,77,150,182,48,140,129,1,24,195,122,107,160,22,129,227,250,27,102,21,127,52,229,47,19,58,21,47,132,85,233,11,183,119,3,54,223,94,30,168,153,3,202,62,170,29,46,235,105,186,122,192,71,128,73,149,47,98,46,122,34,64,101,76,177,160,154,47,174,96,118,108,73,203,121,15,19,101,72,99,177,70,118,219,124,182,128,41,154,76,22,204,166,120,224,174,35,27,29,63,8,248,217,183,247,192,11,141,178,28,4,184,73,111,64,221,65,220,21,145,34,163,79,94,28,225,40,146,182,182,2,244,18,250,136,64,65,3,121,52,149,19,150,105,221,244,244,247,77,249,155,100,216,128,178,170,122,153,140,221,2,88,211,227,255,108,191,91,6,185,100,148,31,75,245,179,229,46,107,30,214,20,93,198,142,86,108,83,131,235,38,107,38,203,229,248,160,22,216,41,215,22,55,59,211,156,38,76,79,202,176,49,88,161,162,206,46,81,83,200,99,138,117,40,110,2,84,142,165,212,63,185,183,35,165,96,218,110,177,40,36,21,19,181,76,171,145,175,144,249,115,42,97,99,152,49,128,122,54,8,136,236,196,46,137,181,211,218,83,112,177,64,193,136,89,220,176,221,204,172,174,154,77,96,166,191,132,59,141,90,169,6,46,45,84,193,160,209,49,6,199,255,3,129,73,146,92,31,226,30,164,12,7,148,241,217,3,113,226,199,81,146,95,141,45,176,205,253,233,128,78,74,123,244,138,154,234,99,11,241,18,251,174,123,196,122,254,82,210,2,90,216,87,97,38,253,160,197,255,134,152,168,162,17,72,133,41,122,235,85,154,133,172,162,240,103,107,149,216,192,182,55,27,163,94,52,129,61,154,61,11,135,223,222,154,217,53,135,124,181,120,2,41,107,239,28,32,232,45,27,51,86,176,14,7,40,249,170,100,67,101,131,23,151,200,74,151,82,184,146,40,7,64,240,146,253,80,218,150,108,16,186,224,225,98,8,166,177,252,0,35,95,107,137,80,130,116,129,161,149,37,52,149,240,167,11,50,129,134,80,126,16,233,201,206,97,186,68,205,245,254,241,139,20,5,89,162,39,98,188,107,186,119,233,101,250,245,150,241,120,191,39,29,12,121,31,198,242,252,230,85,160,112,172,171,128,29,103,65,246,39,126,74,92,140,142,56,181,82,101,195,59,71,4,8,9,42,98,180,136,41,26,56,252,4,230,102,239,251,161,183,106,22,54,238,250,59,61,243,9,189,77,195,254,119,234,124,186,211,5,26,88,176,159,87,101,242,100,179,102,218,39,85,82,118,109,146,144,225,73,28,78,77,189,135,29,192,12,95,153,113,248,50,171,113,241,189,121,194,155,247,109,70,124,72,61,27,79,56,185,218,51,155,130,98,183,1,100,60,85,55,160,158,110,41,58,63,216,176,49,228,195,87,118,254,105,223,41,138,84,41,78,214,111,49,206,175,91,190,57,25,68,120,22,127,85,81,202,226,197,123,156,169,249,12,182,148,31,115,211,146,41,208,248,249,197,188,103,47,138,8,117,43,130,28,28,102,44,149,38,221,176,211,11,76,148,186,176,252,87,62,69,3,88,80,123,168,196,245,128,224,186,224,99,220,46,237,181,88,159,161,175,204,237,160,154,13,131,12,99,88,171,231,111,242,238,194,193,15,3,254,152,148,114,131,215,216,106,245,73,197,176,147,149,25,185,200,252,52,225,236,86,240,34,22,76,102,243,132,148,11,204,125,58,185,37,184,188,4,169,89,249,104,232,254,3,96,102,68,177,242,8,251,188,177,100,48,1,248,177,185,181,108,161,130,117,35,229,28,94,131,105,31,242,158,200,167,63,124,21,55,142,139,10,202,5,82,209,8,37,48,22,47,237,174,182,254,11,32,46,255,142,78,113,207,192,187,172,174,16,156,90,26,138,142,57,129,2,59,148,175,197,194,242,205,81,57,214,199,206,60,204,225,254,113,28,148,222,242,209,101,104,98,108,237,223,49,114,212,129,78,146,78,208,40,162,230,188,127,198,195,47,15,146,82,173,159,186,217,133,148,237,194,5,33,102,245,90,65,8,165,35,12,231,205,62,97,232,36,7,127,30,119,233,149,99,221,178,173,102,226,168,250,196,60,181,5,125,126,243,158,64,110,37,30,195,162,229,136,241,198,229,105,88,85,49,14,96,84,216,55,253,53,92,172,24,38,54,35,37,50,118,149,84,244,199,203,56,87,218,44,100,7,25,135,147,55,101,115,200,99,37,8,239,72,221,30,76,8,86,146,55,44,91,241,31,111,230,90,185,168,144,245,50,43,46,238,33,229,223,34,244,14,118,219,103,141,110,249,21,49,255,202,251,214,126,66,144,34,95,94,195,240,131,109,100,123,73,158,69,82,217,206,59,169,190,31,185,211,83,88,73,74,185,229,228,147,57,21,198,39,234,143,84,167,170,144,247,206,56,43,55,104,193,157,220,89,125,173,151,17,4,10,18,124,244,41,133,194,59,11,202,98,174,212,26,19,95,71,26,82,242,133,85,125,4,131,36,108,37,250,255,99,63,15,53,173,129,255,175,83,105,132,142,35,4,243,133,67,237,220,88,25,169,219,83,229,33,83,46,251,0,111,226,87,41,226,98,245,208,93,251,94,207,210,41,146,56,119,137,32,0,61,212,6,161,219,144,112,202,88,124,132,83,197,240,185,196,152,34,202,136,59,198,165,5,136,11,246,158,60,3,176,105,203,207,70,162,187,45,160,39,60,82,115,113,239,37,166,188,235,215,222,227,65,73,188,70,178,98,215,247,7,12,10,4,216,139,202,178,125,231,103,79,61,127,58,10,202,75,42,107,139,214,172,4,14,3,23,73,247,52,158,78,61,218,235,79,191,182,70,127,157,34,208,242,177,248,153,110,42,50,168,186,212,159,202,174,245,161,60,197,47,221,200,111,195,231,35,136,145,196,62,119,52,247,41,50,41,64,94,231,136,149,213,174,127,157,61,143,47,166,152,59,245,186,16,70,32,201,49,239,157,90,225,122,138,88,158,93,59,121,246,69,151,25,182,189,199,100,74,131,123,99,103,185,138,240,169,255,83,8,240,13,159,156,5,223,181,247,243,244,179,90,207,159,36,69,34,174,29,39,12,198,108,220,130,2,10,203,188,206,67,116,209,27,67,170,198,93,113,250,14,198,254,196,37,146,198,0,245,162,19,196,105,30,136,94,211,48,61,213,53,160,236,102,140,240,236,1,246,124,73,73,184,88,243,157,125,154,77,39,104,111,1,205,78,22,233,44,37,253,92,198,51,8,211,150,43,192,106,122,208,21,123,140,14,148,222,144,217,194,15,242,120,80,45,66,71,74,147,132,37,185,45,165,41,76,166,143,130,134,3,4,15,104,214,102,179,162,238,195,200,235,20,223,172,249,110,37,43,216,136,128,232,235,48,215,2,250,173,82,109,146,30,125,217,231,73,206,65,2,40,45,35,163,248,230,102,19,67,102,0,76,64,7,130,23,167,105,28,152,26,73,234,15,36,35,231,146,205,50,217,164,199,154,192,15,19,80,26,30,181,14,197,12,131,88,61,140,86,85,233,182,210,78,143,77,63,177,30,176,10,224,14,137,130,162,84,191,108,227,75,85,115,237,159,119,222,168,131,18,13,22,92,110,176,134,71,180,31,116,154,111,4,116,74,59,2,191,75,114,181,184,238,106,236,202,251,63,247,48,35,155,172,61,122,174,26,38,3,176,42,15,71,195,153,55,66,191,33,169,177,220,36,95,177,66,86,173,31,180,219,166,178,139,120,139,67,88,25,238,233,169,169,111,163,217,54,29,44,34,138,236,199,35,50,82,214,30,125,91,25,222,65,137,125,96,232,78,167,209,68,71,70,1,22,163,34,202,200,71,113,235,157,41,14,32,110,171,235,197,174,10,51,158,251,44,98,199,201,196,168,50,201,99,205,245,153,75,169,17,143,154,52,222,138,28,173,86,92,134,115,136,220,131,85,171,122,218,117,190,117,143,79,26,121,10,50,45,80,241,33,4,253,140,1,159,201,105,123,35,133,81,59,236,16,238,109,215,10,124,211,64,112,180,147,203,106,142,69,97,205,162,177,217,151,174,189,239,69,50,30,166,238,219,120,79,225,197,121,127,91,215,89,102,17,39,158,213,94,164,254,49,125,216,191,222,90,38,224,214,242,60,2,38,241,139,218,34,185,186,30,206,33,43,38,242,81,191,12,1,200,96,167,125,197,194,127,129,244,184,30,74,74,196,174,229,224,226,124,52,137,122,146,108,187,169,127,72,111,131,243,79,149,236,134,103,137,212,161,44,61,183,188,103,150,96,95,88,187,167,31,213,185,63,128,70,10,58,47,69,155,112,231,242,129,19,78,116,74,152,85,44,128,199,241,148,56,48,27,194,180,191,35,170,227,179,166,110,172,88,208,185,53,153,120,109,155,216,205,172,159,59,191,94,49,209,213,90,125,246,132,153,163,89,50,28,91,141,185,11,4,229,210,18,79,36,117,191,90,231,97,92,89,193,98,201,7,9,252,3,100,157,87,134,164,29,218,54,7,117,232,97,226,74,185,43,135,78,199,151,206,137,157,244,201,49,137,164,23,115,134,121,92,128,224,192,100,154,252,124,146,17,129,44,130,237,65,159,194,35,88,56,132,29,163,200,91,112,118,35,100,76,112,87,180,233,171,69,124,62,161,232,54,66,129,248,193,47,232,197,143,236,112,36,132,61,97,179,231,60,124,4,220,161,114,16,84,196,143,200,58,98,2,255,8,3,222,42,146,204,234,68,199,78,202,173,32,215,30,242,64,32,250,49,111,31,174,191,209,40,51,55,101,12,137,212,116,140,72,132,52,104,204,245,218,122,29,236,175,188,112,137,112,129,225,22,84,118,55,75,104,13,207,51,243,102,148,120,49,86,192,53,173,30,143,161,0,187,160,141,185,32,104,37,221,242,44,29,27,162,135,12,4,205,239,98,8,217,237,81,207,29,240,169,209,6,80,56,120,99,193,90,244,235,14,45,162,130,224,62,152,96,147,9,238,188,49,82,151,207,8,240,126,39,228,192,121,199,227,52,238,238,69,130,134,174,90,34,126,176,133,63,234,79,219,126,186,224,106,183,242,244,90,180,161,17,110,155,66,109,222,205,83,121,103,49,85,234,220,198,98,67,0,50,194,21,182,193,118,19,220,4,173,96,221,203,40,186,232,98,162,37,12,169,225,26,229,12,71,121,194,162,100,159,139,30,0,151,86,14,131,219,129,154,212,170,79,126,26,171,90,92,239,0,106,79,97,213,183,128,12,238,216,30,67,114,73,64,191,22,179,225,12,252,220,234,87,55,51,145,66,34,63,168,252,148,87,47,176,54,228,85,152,226,61,198,41,76,94,182,131,134,142,127,97,14,232,78,147,107,91,23,55,184,220,0,132,128,230,214,41,253,146,45,59,69,244,78,228,127,47,234,235,212,197,152,203,251,16,167,93,153,46,245,207,238,82,246,96,131,4,123,250,67,9,15,63,198,214,205,18,51,223,238,190,104,69,185,188,1,61,168,132,22,21,224,86,237,119,49,15,228,241,216,161,180,19,252,22,109,144,133,49,21,97,145,73,250,32,160,0,103,179,235,69,26,206,44,140,184,97,110,167,21,84,228,112,18,154,24,41,60,232,190,168,43,72,248,82,221,13,138,79,89,140,122,61,117,232,17,75,243,217,88,218,235,50,96,182,174,230,168,249,99,90,3,240,143,171,128,49,247,62,32,242,216,73,239,88,172,30,77,172,78,40,138,46,152,178,103,92,139,57,224,167,208,14,63,245,78,69,235,225,103,133,134,96,22,32,104,77,117,153,192,206,38,183,221,117,253,207,240,211,16,89,105,251,119,74,144,222,156,150,154,58,135,38,58,165,24,125,4,181,205,243,117,226,156,243,80,70,66,176,146,37,197,55,215,99,87,148,92,191,170,198,29,60,48,57,132,232,226,100,191,28,143,184,235,205,69,47,243,18,71,89,96,148,5,68,98,120,4,46,222,166,248,156,123,31,13,147,244,29,153,133,248,130,207,112,2,139,131,49,115,58,120,121,244,170,19,97,201,192,75,161,137,127,83,157,78,253,58,222,224,220,83,182,11,236,101,153,140,34,113,36,254,143,112,151,78,23,46,155,32,170,178,239,64,77,243,128,127,240,27,82,213,68,205,87,27,42,124,75,156,9,234,4,161,210,181,7,140,130,78,31,105,100,208,169,223,62,105,229,132,50,56,128,226,5,184,254,213,116,54,2,93,233,67,132,34,39,179,133,27,209,227,163,127,21,38,10,175,140,28,114,70,190,173,123,166,31,176,23,83,27,2,64,147,250,217,95,1,100,211,238,42,151,65,188,182,234,61,134,64,31,245,14,173,167,214,244,223,242,182,230,208,180,241,228,142,135,251,1,188,189,100,175,18,181,117,35,14,102,136,20,208,168,235,41,228,102,112,204,114,197,137,63,144,1,174,122,8,52,194,119,247,169,229,16,103,124,105,126,128,30,165,102,132,107,24,55,253,220,212,101,202,129,150,144,2,88,195,9,152,160,243,97,168,80,228,18,168,79,186,193,151,206,197,164,32,6,58,126,128,178,154,122,20,188,81,123,96,6,46,214,149,107,24,177,129,255,208,247,29,66,228,212,126,81,168,1,76,131,174,108,141,122,248,24,107,113,170,68,235,117,129,83,56,163,148,130,79,104,185,22,138,198,242,77,180,102,47,117,225,233,90,16,225,8,163,241,112,173,15,227,176,197,136,139,114,202,96,151,63,60,96,154,107,17,147,224,206,248,93,53,106,235,229,60,87,165,173,67,60,192,40,25,38,154,183,128,195,41,187,21,254,166,61,76,158,20,29,63,194,131,191,180,111,32,193,245,193,122,94,224,84,142,94,172,150,192,219,151,49,107,61,164,252,204,72,119,227,21,253,120,84,60,176,113,224,172,24,196,92,64,19,6,114,3,127,121,48,40,3,60,52,74,110,225,56,14,140,23,179,58,129,206,230,166,25,190,123,31,5,201,50,253,204,94,174,116,91,166,97,216,90,145,201,152,88,164,18,19,17,202,204,251,146,159,61,233,43,209,63,240,241,168,94,78,86,211,0,62,97,12,204,199,62,218,65,64,9,170,91,210,0,191,56,249,81,51,140,84,246,229,192,59,27,87,104,195,108,174,216,168,188,98,234,57,57,162,193,13,190,155,45,124,40,58,32,99,14,179,68,39,112,92,159,159,36,201,2,226,129,171,120,102,185,148,114,152,162,196,181,56,69,182,37,197,98,228,38,41,142,10,57,84,197,160,183,210,236,9,42,214,224,63,62,31,118,26,251,177,236,185,210,104,244,19,251,195,113,141,34,50,255,204,42,56,117,66,203,139,249,119,14,28,203,175,32,42,245,180,104,11,154,25,127,248,60,200,28,180,91,39,244,161,108,240,140,189,72,32,119,76,235,30,100,46,74,250,110,234,232,192,243,51,124,39,251,186,123,64,23,149,105,161,56,180,49,163,245,34,42,187,145,64,13,82,135,95,186,146,44,214,135,104,194,94,110,93,178,242,130,21,226,63,156,184,127,204,241,167,193,180,9,237,106,90,105,165,19,198,246,140,189,35,66,77,27,170,145,237,170,99,161,189,234,238,51,219,82,212,214,32,43,128,193,45,163,2,216,44,192,84,104,92,99,93,116,94,163,255,90,174,176,184,147,127,46,68,22,63,23,62,151,173,125,237,52,101,54,144,205,184,145,103,197,86,53,11,127,158,118,175,217,13,86,251,47,11,230,181,185,174,212,134,254,17,229,174,154,246,87,107,230,55,252,104,84,104,251,201,66,110,183,24,71,54,10,178,175,12,182,18,163,73,203,244,85,216,175,129,81,60,17,112,71,155,136,34,122,134,137,245,172,152,64,127,55,97,0,148,116,138,88,45,172,16,250,169,10,55,168,155,249,246,117,74,112,183,220,144,84,127,245,255,79,75,162,219,9,150,235,53,199,122,194,58,198,192,83,66,183,114,7,36,198,143,179,218,40,178,248,218,185,108,140,103,50,91,31,235,191,230,109,62,140,189,224,31,241,31,255,48,167,106,18,242,164,95,24,208,232,159,107,188,95,66,187,61,92,245,43,201,191,135,1,41,19,255,103,156,115,9,219,112,48,74,62,113,152,120,196,200,133,105,206,67,75,26,102,159,159,237,244,74,119,46,70,217,24,102,5,82,212,11,224,67,44,241,148,125,122,140,30,141,56,185,122,202,228,228,152,203,143,221,92,116,168,69,113,89,106,187,215,201,255,151,132,143,105,97,52,138,102,179,146,194,72,5,11,142,16,31,119,218,54,11,45,117,143,78,191,169,116,115,101,231,67,196,81,203,175,126,36,74,3,153,52,15,176,118,87,2,10,235,166,166,25,217,24,97,56,174,121,208,62,83,81,159,25,1,81,67,213,89,71,34,140,83,221,7,159,118,96,172,176,235,249,185,28,97,166,17,64,245,165,23,63,251,128,105,12,76,148,92,91,188,236,238,25,184,58,203,60,22,171,192,183,224,144,158,173,39,61,188,92,76,155,181,102,5,187,207,150,94,58,3,250,36,236,210,151,254,24,164,165,111,28,108,229,47,22,146,124,12,137,148,24,184,174,127,13,247,114,83,177,100,178,209,116,247,77,184,99,249,116,52,90,208,48,242,239,23,251,172,248,54,133,62,24,240,90,110,209,64,19,65,231,127,36,40,74,61,89,232,108,40,133,183,241,255,164,20,180,249,37,233,11,144,123,198,10,134,56,30,115,232,181,188,113,167,11,26,133,132,207,13,144,114,236,85,141,70,151,42,10,176,211,160,243,33,210,57,247,197,33,32,215,207,152,153,82,222,95,87,217,232,251,9,157,52,92,92,186,221,244,36,132,244,171,126,222,212,178,213,118,239,52,68,215,228,157,37,229,77,151,40,95,205,177,209,250,59,223,193,65,135,147,161,220,60,30,20,221,12,251,251,237,115,218,76,211,222,227,113,244,133,150,144,25,141,230,202,17,219,118,142,8,254,249,111,8,74,66,92,214,206,5,252,176,47,65,208,174,127,25,182,208,254,125,215,136,104,95,122,148,47,160,24,171,217,115,108,36,46,111,121,54,209,200,78,201,242,47,82,146,153,116,84,30,151,175,199,2,189,89,106,30,113,219,11,101,233,191,165,1,168,238,15,156,187,76,114,205,125,10,232,251,59,152,234,16,241,125,111,195,40,170,83,198,62,219,137,128,20,195,25,33,235,77,95,39,151,116,175,239,44,250,171,84,173,154,211,23,212,157,160,162,208,164,16,244,147,14,14,17,6,104,150,53,108,250,78,227,27,137,22,252,98,238,175,243,37,70,13,183,79,164,152,113,101,78,244,30,197,103,210,103,214,38,156,171,0,17,21,28,178,30,168,20,31,200,208,51,52,113,15,151,103,235,237,40,10,81,34,216,193,173,182,231,138,223,70,74,110,140,135,128,67,193,157,182,109,142,223,157,163,206,148,192,228,100,183,148,130,219,246,217,18,184,83,27,227,178,40,188,85,136,45,33,244,69,87,159,128,40,97,108,157,0,46,148,60,23,222,235,38,205,188,53,18,244,187,182,168,183,237,144,27,24,195,130,65,220,216,15,20,137,249,27,41,218,232,246,197,92,106,119,80,113,188,192,30,233,34,219,39,146,187,114,27,18,165,104,236,249,38,44,105,166,205,230,49,128,243,36,251,113,40,38,25,215,224,120,27,235,159,12,92,34,87,109,158,74,60,6,136,178,187,38,91,137,86,88,121,201,214,195,151,83,64,228,135,143,158,147,97,176,188,111,251,247,113,197,192,23,113,9,177,188,15,65,193,111,153,189,107,45,251,63,75,15,75,144,12,21,147,41,0,174,131,76,50,32,230,156,172,12,21,217,99,174,122,176,90,142,255,218,205,218,102,252,254,211,225,2,68,190,66,50,226,64,173,14,103,174,112,42,47,226,144,59,125,110,69,123,255,9,156,24,136,238,168,115,76,198,25,170,142,181,178,27,82,125,25,38,98,50,248,232,139,82,51,79,162,74,26,73,204,26,40,13,40,2,73,96,105,177,92,99,35,99,110,56,185,105,177,205,31,100,153,114,150,60,150,252,43,129,210,116,71,159,252,129,54,152,242,65,180,226,15,50,224,127,124,175,143,91,38,46,62,8,22,59,186,178,38,77,246,103,48,216,212,109,56,156,174,127,24,51,123,161,249,178,142,219,27,68,158,78,254,94,242,73,34,240,204,200,93,216,7,25,228,165,205,3,19,2,181,77,104,175,11,217,230,194,135,111,69,253,161,56,50,214,192,155,137,146,17,189,167,202,57,121,74,241,142,45,201,161,154,57,125,92,44,130,241,88,74,115,124,14,144,36,13,187,40,11,139,4,59,158,157,206,13,92,151,135,1,219,94,61,152,173,99,202,240,172,225,103,253,248,69,184,171,34,33,169,218,245,125,15,58,199,178,40,202,80,134,75,170,110,92,65,6,58,200,15,51,116,102,229,188,24,164,185,80,221,62,235,227,1,238,159,158,44,47,211,248,136,211,153,57,241,104,231,90,19,39,187,253,118,187,69,91,208,213,90,157,249,110,157,246,186,4,46,212,11,235,27,55,22,236,16,139,224,123,76,76,174,18,156,21,2,25,59,83,147,157,186,202,18,243,139,77,192,205,43,11,67,231,130,169,53,171,6,241,244,138,2,96,125,93,209,194,120,187,162,104,129,237,118,242,149,94,212,207,222,141,202,202,204,103,231,34,132,92,157,95,239,176,202,195,185,87,154,63,219,10,215,8,146,73,190,222,17,110,27,90,35,66,27,93,191,17,12,120,158,138,224,58,68,152,169,243,48,157,252,163,132,148,157,222,184,145,161,202,141,123,93,61,82,14,213,82,53,66,165,100,215,10,77,207,216,139,35,208,176,63,63,80,219,7,147,222,36,12,252,16,92,225,56,96,70,218,129,99,205,25,99,208,253,109,43,104,153,0,224,39,192,163,67,138,85,157,8,128,148,197,89,194,87,99,206,81,141,47,214,217,156,211,187,184,220,33,32,20,31,143,48,136,147,54,141,147,129,53,91,215,115,208,74,187,36,225,92,30,238,23,79,195,80,124,161,28,40,129,212,156,128,13,94,16,64,122,47,166,181,116,236,218,16,106,162,20,12,250,106,59,75,168,173,41,229,75,239,230,135,79,240,61,106,144,243,222,80,207,8,155,238,226,204,246,25,2,83,116,227,42,121,189,61,88,237,200,221,66,111,84,209,44,204,5,74,21,249,236,194,187,52,103,164,109,114,191,27,0,240,99,60,253,103,92,69,90,87,109,109,138,61,171,55,129,98,152,62,65,82,93,47,130,95,171,12,145,48,243,4,220,47,118,144,188,144,153,224,242,141,144,94,218,128,144,77,106,98,182,215,118,91,73,238,22,122,110,3,109,89,91,34,0,57,72,86,228,158,153,209,235,58,200,213,223,68,254,49,210,128,11,87,0,207,25,93,183,141,193,9,142,11,15,213,209,90,220,249,117,222,163,188,42,116,162,111,235,175,70,29,243,205,184,46,214,112,219,68,27,190,37,228,13,196,98,127,58,220,90,248,241,41,128,82,170,102,78,72,99,103,47,49,238,210,203,217,40,130,83,98,143,81,119,52,173,166,24,234,61,253,11,147,118,189,128,69,161,207,122,161,251,67,139,246,0,44,109,95,241,166,224,177,225,201,10,38,201,24,44,192,55,22,191,109,159,167,39,67,213,33,100,6,197,183,223,105,223,51,37,21,232,53,7,12,64,243,13,77,22,76,175,156,127,201,50,147,144,135,179,71,59,88,161,195,29,23,213,184,66,77,202,54,134,198,21,205,74,59,68,197,2,150,28,192,219,164,192,158,231,193,240,26,176,33,136,97,129,95,91,76,114,79,86,97,220,135,80,233,39,150,150,27,223,206,160,84,151,120,226,45,231,200,167,121,200,46,1,132,39,112,88,96,85,173,249,29,67,46,208,224,131,84,81,64,218,16,15,12,243,215,86,157,212,204,147,221,26,11,10,114,75,9,240,8,16,58,152,196,219,149,51,8,94,225,203,7,157,156,249,220,220,207,80,128,47,103,189,58,38,83,183,122,51,230,254,146,160,37,235,226,233,55,164,177,33,246,224,67,54,25,126,27,216,100,83,102,46,231,99,215,206,57,243,30,174,54,153,209,116,17,156,121,215,104,69,33,59,37,187,95,75,158,233,68,148,64,236,174,32,201,143,189,99,126,50,216,65,155,184,98,84,102,243,47,178,99,59,227,198,213,53,206,39,35,180,9,162,212,58,190,48,80,234,176,124,165,130,234,100,117,5,245,122,210,159,134,31,165,144,196,154,81,131,130,236,180,4,23,225,45,144,92,99,117,71,130,142,141,103,81,168,211,2,123,203,171,59,133,24,46,169,116,160,216,233,44,215,66,201,119,51,58,75,50,68,116,127,170,113,129,55,193,109,155,237,246,191,189,150,135,24,5,204,65,201,86,15,202,87,40,122,227,52,245,82,182,54,65,104,165,101,190,208,117,246,203,163,168,171,35,67,186,170,221,100,63,0,206,157,229,28,237,147,132,88,91,215,64,64,22,48,88,246,232,140,146,211,199,110,230,207,238,78,66,78,104,253,244,227,114,94,210,30,6,33,43,1,110,176,2,156,178,126,202,213,183,124,213,218,56,96,100,54,192,53,69,60,180,73,48,142,15,85,251,191,216,147,246,47,251,203,203,138,14,174,9,73,186,102,220,0,200,22,56,137,234,117,155,105,229,151,192,129,193,93,234,222,103,57,195,107,240,92,18,180,41,23,23,255,255,135,26,222,109,47,129,205,129,52,192,82,153,195,24,72,58,156,127,159,210,114,67,196,173,239,17,84,216,115,57,151,70,218,133,179,61,149,175,160,128,222,103,91,202,239,92,198,173,251,58,186,236,105,215,23,167,254,58,4,21,22,17,213,211,230,47,195,183,154,245,187,224,165,236,107,184,195,149,49,79,138,158,97,201,64,138,145,249,37,253,56,175,148,83,197,74,69,186,47,38,63,14,241,224,30,52,152,74,163,144,190,253,92,176,164,109,217,165,118,19,56,214,162,10,193,213,18,95,72,55,150,22,199,50,196,111,155,204,32,122,25,68,234,156,43,178,92,160,204,83,138,2,184,248,7,132,201,144,69,176,216,12,49,175,55,89,163,91,23,159,27,226,183,111,153,13,35,140,237,237,170,126,119,171,55,105,81,53,55,142,131,46,39,136,83,145,158,216,192,73,71,22,117,124,243,85,81,130,52,28,216,143,226,153,141,3,162,141,249,125,8,119,27,65,133,135,123,117,71,161,45,130,255,194,160,178,21,123,106,105,199,3,146,205,115,157,18,61,181,226,101,151,234,244,10,17,216,104,186,3,215,32,157,200,151,190,41,62,181,74,5,160,213,185,70,97,253,164,115,81,108,228,207,4,144,210,54,224,36,93,21,210,109,58,54,121,127,235,182,110,122,161,24,48,114,193,83,31,221,109,136,70,83,212,203,195,232,231,69,5,55,157,106,77,101,19,58,55,127,91,240,85,64,11,229,155,10,93,177,2,144,20,75,121,186,81,171,50,1,196,62,217,231,16,206,250,186,173,24,60,218,230,99,216,36,3,103,61,237,73,61,170,38,35,224,158,166,103,119,128,4,5,152,194,141,234,113,149,54,196,25,235,18,81,227,137,137,138,115,20,204,38,189,115,69,224,31,135,6,32,171,72,87,42,144,71,72,255,171,79,132,159,83,151,209,62,152,25,79,133,19,172,154,90,84,80,101,131,150,37,245,195,199,210,235,98,122,229,215,7,164,79,63,62,80,142,144,161,189,235,24,212,200,109,145,185,104,122,29,112,81,147,15,4,108,147,244,184,155,249,18,80,201,174,227,93,226,109,63,7,17,14,209,141,194,160,30,170,18,60,144,32,224,177,0,106,248,126,107,84,185,179,106,146,13,238,80,251,18,50,96,122,216,217,112,187,148,102,111,47,244,158,22,39,76,59,150,43,22,117,202,253,88,26,166,126,243,142,239,81,69,185,255,93,56,20,32,232,185,22,217,19,198,221,159,42,176,105,127,180,90,189,136,213,241,120,92,0,77,136,165,142,142,126,142,164,219,231,41,237,134,253,191,235,254,252,57,52,25,89,120,215,145,142,87,152,149,107,177,79,86,176,4,105,59,150,254,14,74,110,116,206,16,0,218,98,156,66,18,10,16,202,136,15,80,236,236,233,75,132,186,168,174,233,16,240,124,0,189,243,98,252,33,121,215,44,173,199,127,71,233,97,165,227,102,12,62,59,225,180,119,55,117,95,159,229,177,99,143,111,247,182,37,180,23,219,51,67,250,113,124,122,213,160,93,82,156,170,252,0,1,76,22,11,250,91,147,112,1,233,251,21,112,60,137,25,215,114,231,83,28,55,129,94,198,200,247,80,156,163,198,211,214,235,239,111,210,160,137,128,181,114,163,61,8,94,83,46,49,30,181,239,140,222,109,66,167,226,89,159,32,73,145,21,222,213,65,62,66,94,137,206,128,169,236,73,167,141,150,232,238,36,44,136,68,28,4,21,153,225,253,254,31,210,190,138,17,5,228,142,90,163,91,64,60,208,230,70,88,201,198,140,171,37,112,143,83,251,39,36,63,189,48,135,196,100,189,76,124,37,117,179,153,183,236,97,94,72,5,144,76,23,71,22,137,91,101,17,51,31,37,37,248,167,248,202,225,125,28,24,192,51,67,242,20,243,183,110,138,211,210,110,39,221,189,226,241,100,225,217,111,128,6,152,234,156,179,79,2,139,150,103,51,47,252,21,104,71,84,83,243,17,144,151,52,96,128,26,163,179,77,162,97,109,136,128,106,219,50,111,229,203,148,252,102,19,181,220,239,169,7,60,6,173,111,160,55,24,162,69,223,39,186,222,104,184,206,203,0,68,178,244,108,51,107,230,205,176,248,207,12,225,122,184,184,1,99,226,173,135,71,136,45,243,127,168,160,134,31,180,45,53,1,213,36,43,83,51,59,61,115,223,67,123,54,86,38,128,71,198,210,179,241,150,253,253,1,26,104,127,234,182,86,121,188,19,134,211,19,249,75,96,210,137,255,175,48,38,23,82,107,180,73,87,97,17,31,217,160,77,243,143,164,224,77,154,152,148,205,66,240,48,168,156,21,103,19,214,154,17,173,156,16,31,18,63,134,224,211,145,46,114,33,113,105,125,72,78,202,25,183,28,255,45,63,169,16,225,2,237,156,45,254,223,125,195,250,99,49,156,250,188,216,169,104,171,157,188,114,72,110,29,153,187,99,254,51,237,255,23,98,131,248,193,121,59,142,7,176,78,52,182,134,170,136,125,40,234,245,225,74,212,208,176,105,253,8,32,143,69,180,249,246,10,31,176,129,144,255,199,193,59,12,181,231,207,169,241,243,19,253,220,49,45,195,42,147,102,239,117,186,240,63,156,184,43,225,119,87,44,38,11,106,231,241,208,145,167,222,147,22,240,37,62,139,30,249,0,209,78,164,84,131,254,178,126,91,170,226,29,73,170,154,101,221,202,18,92,146,134,178,38,195,106,88,228,86,86,172,34,113,89,4,85,139,78,39,3,161,49,94,245,107,21,206,162,64,240,35,201,126,89,226,156,229,141,165,29,4,22,197,202,125,44,200,64,176,137,55,95,167,234,104,86,244,217,45,234,206,4,6,171,85,146,235,237,168,81,103,77,204,104,16,110,90,132,100,240,72,96,188,201,254,56,43,229,76,8,144,250,190,182,102,89,64,104,238,222,184,173,138,130,235,233,91,226,30,237,38,236,194,116,180,36,198,97,37,242,32,60,224,15,13,203,190,121,127,41,1,108,205,117,79,104,173,232,164,128,0,31,193,82,164,115,1,175,199,50,22,0,215,136,87,212,105,174,240,47,27,51,93,165,183,61,96,31,150,125,70,38,192,85,215,191,65,159,42,123,59,211,210,39,96,64,53,80,103,134,214,75,89,23,40,114,4,148,61,56,175,176,119,180,61,162,119,184,21,110,204,103,52,202,109,151,202,204,240,215,165,116,96,52,113,64,112,42,171,54,172,169,69,253,44,153,24,232,19,141,73,3,80,141,143,57,23,209,218,79,5,176,20,117,197,223,97,0,0,216,103,205,251,42,189,173,104,182,224,240,187,184,90,150,165,151,54,237,248,21,195,252,26,86,186,43,130,85,173,165,88,77,47,61,60,251,197,177,40,114,201,153,72,161,39,61,136,217,22,39,227,180,112,20,184,0,22,255,248,87,132,120,113,8,6,226,212,166,57,112,185,75,15,83,79,196,106,136,205,5,59,250,63,35,80,140,176,236,196,248,3,221,98,250,104,32,99,152,165,109,139,192,40,49,68,14,50,89,102,202,12,64,120,114,49,227,205,144,18,43,180,65,47,167,89,67,145,180,44,241,173,23,232,86,141,103,210,72,240,225,180,133,221,238,4,125,161,121,44,204,5,162,64,34,84,167,152,247,154,190,162,116,71,83,180,181,174,3,151,227,180,162,28,198,133,1,195,199,54,251,220,4,182,126,209,15,24,207,187,240,50,11,120,250,158,87,125,246,74,64,175,190,21,150,255,202,170,125,38,228,16,24,166,186,7,113,0,133,182,112,138,188,2,24,120,236,10,76,154,89,48,23,228,159,219,144,219,209,76,59,25,100,202,46,203,178,117,252,97,240,97,42,143,205,52,199,220,7,0,109,217,139,126,170,178,227,213,192,16,171,133,173,237,240,186,6,14,155,94,157,194,99,123,174,181,74,164,126,56,178,0,172,77,163,74,172,53,5,161,130,161,162,149,232,150,69,170,172,59,70,142,112,87,58,16,192,67,8,250,29,140,221,17,117,167,133,43,180,141,157,214,18,131,114,105,147,206,25,138,207,188,30,41,9,97,113,247,123,251,56,165,182,239,95,79,152,45,113,160,213,230,249,227,167,149,52,172,156,182,242,134,61,19,90,144,248,100,252,168,76,213,246,126,123,175,8,114,218,41,247,90,229,94,238,86,73,43,35,42,116,168,217,75,167,166,122,230,82,130,255,164,51,9,86,79,111,49,152,198,132,96,62,12,131,23,66,96,51,213,29,13,144,20,26,228,66,41,228,68,254,126,173,192,51,62,41,184,136,182,93,102,144,250,65,236,200,19,121,182,87,125,72,97,132,164,29,130,211,26,115,217,177,199,35,54,132,98,87,138,188,229,34,130,240,81,186,231,130,41,17,74,64,27,41,169,251,229,192,38,247,81,85,224,10,181,80,164,164,112,73,150,53,119,166,144,157,52,98,187,48,28,64,77,33,237,100,1,46,123,40,27,232,128,105,190,126,27,132,205,16,107,184,30,187,240,29,128,81,177,9,175,37,159,188,53,109,59,15,33,102,39,182,31,73,163,176,14,150,178,216,231,41,152,253,100,240,46,106,181,137,111,240,101,204,74,57,134,179,49,230,134,124,152,70,64,166,43,65,203,80,53,157,166,39,138,142,243,74,145,217,9,194,93,128,67,93,129,161,161,254,211,189,239,205,32,171,253,118,141,204,240,183,222,146,198,220,187,58,201,238,218,179,206,89,183,40,198,33,53,38,40,144,216,247,161,189,216,173,9,22,72,148,174,45,3,127,35,125,111,140,15,207,119,246,38,244,195,69,85,106,121,28,241,125,124,103,116,108,152,84,133,165,68,92,5,189,160,223,125,159,69,84,91,214,24,52,36,207,180,152,8,156,70,209,194,220,165,138,212,192,246,132,124,186,64,218,179,23,131,210,117,7,15,197,250,249,187,104,74,19,195,232,168,66,171,125,133,252,89,123,236,67,152,150,187,82,161,241,29,160,206,15,254,101,201,34,79,182,6,88,237,204,67,3,24,199,64,58,22,71,118,31,80,235,148,111,111,74,248,229,15,0,160,215,0,121,227,15,243,58,122,251,203,236,223,102,217,235,105,113,239,209,206,227,198,166,116,250,85,48,71,14,78,216,2,167,129,129,240,167,56,89,118,161,125,49,228,56,221,13,219,207,36,68,253,27,45,219,117,151,229,111,247,206,97,173,132,8,74,182,16,125,54,238,31,46,244,50,250,3,216,182,42,120,67,61,39,106,101,23,248,21,80,151,115,41,105,95,47,32,90,53,3,164,31,12,113,105,26,135,101,186,43,191,173,143,177,4,75,109,96,7,121,5,231,218,250,45,96,254,193,146,225,251,238,21,240,27,207,43,187,7,61,254,195,234,210,152,46,241,186,188,216,234,82,179,109,61,190,139,211,58,36,74,149,107,249,150,196,71,226,167,232,40,42,19,152,17,194,16,94,5,11,57,37,43,99,98,248,81,211,60,69,192,80,94,225,241,197,53,76,100,1,166,253,132,17,3,72,232,72,214,60,18,151,159,15,167,78,27,76,142,22,21,129,121,10,185,35,246,49,165,218,73,182,236,65,1,175,236,230,71,209,189,163,164,179,194,209,86,6,180,219,147,94,15,212,246,83,21,183,250,40,230,78,222,159,74,94,13,20,247,51,90,218,253,125,50,81,72,93,1,200,50,199,223,192,197,223,38,208,98,122,118,7,82,178,154,193,50,199,199,7,184,231,120,39,2,232,41,182,32,75,56,236,176,5,0,113,190,13,109,1,175,212,249,89,21,130,204,162,228,119,244,190,87,252,151,13,40,209,103,93,95,199,103,141,133,122,94,189,161,222,26,229,214,114,137,110,97,84,81,251,213,80,122,215,144,113,154,105,12,130,191,24,0,226,159,46,86,119,142,104,231,72,118,224,91,195,94,179,212,168,32,243,2,25,219,4,197,34,167,252,198,18,155,87,88,62,165,118,253,176,96,152,186,128,214,140,226,59,11,113,104,102,96,136,126,9,13,140,165,46,116,134,52,249,105,131,168,226,83,93,216,194,247,236,251,159,42,118,243,93,85,175,120,106,134,75,146,217,187,183,49,138,190,5,189,3,203,106,166,110,104,108,70,111,165,41,203,34,212,254,32,10,2,238,30,243,126,47,119,175,63,107,73,75,131,105,17,54,253,158,128,179,196,198,64,151,178,55,47,159,191,106,78,234,208,198,108,42,131,2,33,44,121,43,48,137,107,252,205,15,84,242,200,169,148,239,199,117,248,6,151,51,83,45,149,57,75,160,202,27,122,235,14,50,90,135,90,94,140,171,241,123,236,90,200,243,190,6,111,165,246,139,34,141,151,172,38,34,66,201,218,83,110,52,12,146,6,26,248,102,120,174,193,25,147,171,152,87,174,79,55,208,166,73,111,90,214,25,117,239,102,226,213,182,128,93,49,129,174,3,2,180,9,250,166,8,32,141,187,26,55,157,229,144,64,195,91,154,133,56,176,6,198,60,119,115,232,70,213,143,59,250,97,136,50,75,125,198,19,151,141,168,48,163,47,67,211,114,119,103,69,9,119,244,236,196,164,248,228,69,215,205,245,16,57,177,244,43,224,109,172,45,14,5,161,195,63,81,38,117,19,125,248,179,103,199,168,84,151,192,55,216,72,96,43,117,199,103,51,202,42,177,40,169,84,157,153,173,244,141,108,142,38,188,53,35,151,221,147,12,148,111,151,129,212,37,253,142,191,152,21,241,153,150,30,71,95,49,124,83,150,47,109,169,199,96,70,141,167,74,79,11,152,159,93,215,159,185,141,249,140,114,217,75,87,133,177,114,114,27,32,86,10,246,20,157,127,160,164,227,79,194,177,107,49,142,179,84,144,135,178,81,30,7,228,120,116,11,103,210,83,15,94,77,40,116,144,27,125,81,192,231,217,112,4,184,78,6,144,65,184,221,84,114,52,150,241,217,130,114,219,252,15,34,244,209,76,178,193,231,229,38,137,147,0,147,242,150,26,33,32,28,132,60,63,134,221,9,214,135,97,120,217,109,78,130,199,253,153,215,234,19,186,201,199,169,20,132,151,74,179,54,65,25,171,126,126,88,23,247,222,39,52,65,85,45,245,229,214,38,98,14,0,10,216,42,17,230,34,91,84,144,209,31,186,211,140,175,188,80,202,99,174,124,88,40,32,214,235,133,253,145,179,186,102,42,135,61,67,235,163,133,41,35,25,168,87,141,24,186,210,233,150,19,220,120,81,123,169,245,18,197,27,207,176,15,197,115,139,69,152,82,211,148,77,184,232,173,29,253,46,123,173,245,217,54,231,135,218,236,101,196,45,109,136,189,206,68,215,214,77,251,43,39,224,144,62,135,50,114,247,67,110,247,38,143,220,5,1,173,142,88,7,149,152,225,194,10,114,152,121,105,239,242,249,117,29,172,2,39,98,218,33,31,69,93,11,210,222,132,40,251,162,173,144,13,165,165,242,181,202,215,89,196,228,253,39,70,73,153,144,63,184,211,2,204,107,51,166,197,173,14,15,96,66,141,11,12,244,148,50,16,214,9,8,52,6,165,105,91,184,10,10,62,135,250,200,159,69,227,229,86,98,229,73,27,200,217,108,233,211,81,90,93,45,50,50,149,19,35,23,116,202,113,21,211,33,217,140,128,86,228,185,130,140,104,87,180,174,131,213,254,48,90,67,239,159,204,139,229,42,236,142,82,151,187,165,11,12,150,53,56,10,76,97,213,117,217,51,242,133,135,229,78,117,95,26,31,69,32,138,147,70,226,136,42,0,8,199,224,233,35,206,48,207,61,99,52,101,204,118,143,245,236,120,33,226,57,223,53,32,255,6,236,127,223,89,137,99,84,204,80,106,20,237,64,149,193,65,7,41,202,120,56,115,112,137,35,254,243,28,47,4,229,33,115,177,48,219,231,48,63,139,95,214,209,6,170,197,116,222,104,88,254,141,16,48,222,226,9,47,121,65,188,142,38,129,229,60,122,25,131,229,78,249,211,139,93,199,181,248,231,247,38,161,131,223,146,216,88,123,189,77,186,220,2,185,53,173,226,101,153,213,103,171,140,207,44,51,120,168,36,182,213,176,87,166,170,61,250,49,139,249,215,135,168,170,59,95,118,142,249,166,177,121,94,175,159,219,228,219,117,28,222,43,180,225,108,140,7,25,5,94,45,171,5,65,137,255,40,123,190,89,181,94,76,172,91,161,197,240,85,79,172,28,47,57,205,233,102,137,143,28,155,20,20,157,41,148,175,43,167,5,82,171,148,109,247,237,236,176,176,124,1,158,189,93,168,51,115,231,208,228,55,164,123,212,27,25,190,38,1,120,25,153,91,236,95,116,67,210,173,224,156,220,91,207,120,91,114,212,191,71,198,205,146,136,65,91,33,204,192,154,155,243,71,11,55,239,100,89,204,247,199,59,120,22,68,109,137,194,203,81,61,247,11,226,242,210,155,195,209,1,193,108,163,178,20,22,170,30,148,214,80,229,153,91,103,246,237,10,245,110,211,150,205,98,239,92,94,71,206,91,253,204,90,157,216,152,35,148,167,8,201,167,24,239,191,158,102,23,131,159,64,99,81,159,58,193,185,68,1,28,24,38,198,132,80,191,19,122,235,99,129,100,49,253,29,52,194,32,108,106,166,243,179,53,189,96,59,73,241,61,32,223,84,218,118,59,32,64,9,98,239,207,219,101,38,106,54,148,148,25,5,50,107,106,152,242,117,192,102,56,184,19,232,133,157,243,182,52,144,217,94,101,153,221,88,157,52,224,159,93,159,71,2,115,200,230,116,202,177,236,75,20,176,16,39,147,24,150,195,21,251,77,57,185,113,216,168,48,127,164,56,104,92,23,85,141,159,93,53,192,103,163,130,24,85,85,160,61,246,23,185,196,18,158,228,129,148,126,206,52,198,191,182,12,98,112,31,56,160,62,208,196,234,1,56,249,23,61,115,25,164,254,151,45,11,124,107,53,151,131,221,52,249,185,90,5,4,129,177,134,168,239,37,50,111,225,178,53,251,9,5,87,32,111,75,239,38,160,33,50,128,211,5,250,31,61,177,31,115,182,221,118,33,225,75,165,5,43,89,152,62,217,185,246,122,194,98,47,193,42,74,46,144,111,16,231,76,88,151,7,93,68,144,237,82,117,206,167,239,6,137,55,125,14,88,92,201,143,148,62,216,55,224,150,178,38,77,42,167,163,233,124,131,220,55,50,219,117,225,244,220,233,124,27,133,246,213,86,54,152,29,92,98,226,98,54,110,144,186,41,161,225,72,199,30,105,121,160,56,141,23,100,40,88,208,169,32,196,122,95,231,57,244,199,120,13,232,165,250,170,24,34,231,23,205,33,18,214,128,56,165,14,48,104,223,133,183,73,58,100,111,112,115,239,70,81,81,38,94,88,232,164,212,242,0,59,114,36,133,89,252,41,204,37,193,144,244,255,242,124,20,131,112,126,131,187,205,71,229,86,90,197,199,245,45,120,190,56,223,164,63,177,75,188,238,180,176,137,182,95,221,29,158,104,4,224,38,183,94,172,67,44,62,168,237,218,85,159,58,25,168,173,108,204,228,81,18,145,207,176,19,10,212,78,133,108,169,178,117,11,19,155,152,200,117,243,99,143,126,93,75,167,4,103,249,245,27,30,184,78,162,35,174,200,4,59,119,138,195,58,130,59,179,147,48,207,134,201,207,31,90,145,168,212,195,79,220,16,253,80,24,42,159,61,178,241,81,140,246,198,225,166,94,74,63,254,3,218,93,2,74,194,239,192,68,55,75,132,51,79,200,162,72,133,34,87,86,7,157,235,37,94,78,191,150,81,213,162,147,20,232,243,173,36,1,244,91,3,192,10,224,194,229,74,147,19,192,165,168,153,5,127,230,113,185,206,127,146,80,114,246,179,16,31,90,0,242,254,82,189,36,246,211,7,118,168,33,154,220,184,107,101,40,150,196,194,242,253,216,72,132,210,147,230,224,198,34,75,25,74,233,205,159,168,6,197,50,217,127,251,94,27,0,89,55,171,138,10,197,251,46,127,84,139,97,212,131,44,89,5,181,154,11,223,2,106,249,29,222,72,44,89,57,56,8,138,102,140,86,159,219,77,239,32,203,126,142,214,192,72,16,119,161,71,155,250,58,115,189,112,51,213,249,25,85,78,170,171,102,164,103,133,109,37,229,130,167,116,64,21,234,76,246,89,206,141,235,89,223,141,56,47,168,166,97,190,26,197,70,97,133,200,148,53,45,183,39,129,38,122,174,116,58,75,115,221,204,101,52,24,94,177,14,237,2,172,234,210,8,208,25,77,235,113,24,108,216,242,184,180,255,173,101,240,51,246,200,240,13,156,209,93,60,66,170,252,82,230,13,215,146,117,255,210,7,34,122,10,106,156,176,21,68,222,248,33,83,152,206,191,60,18,158,149,114,74,41,60,203,244,210,249,189,212,25,25,75,131,95,76,207,254,188,23,124,249,162,255,170,137,0,81,97,181,221,127,2,120,240,234,80,28,115,105,158,136,89,77,135,103,255,251,8,186,242,63,176,164,122,8,11,128,19,58,243,8,212,252,204,84,170,108,158,179,247,0,254,32,87,139,213,136,45,180,92,145,67,92,246,247,205,97,103,87,101,163,137,0,61,23,230,147,218,153,102,235,104,17,24,246,70,190,79,179,238,178,41,56,128,115,241,148,114,229,173,144,63,54,151,123,191,45,145,222,89,230,29,59,34,163,123,120,56,34,137,149,161,32,221,255,87,39,50,57,112,84,159,209,51,170,143,167,190,117,145,202,12,127,248,132,142,52,118,154,247,22,242,179,161,240,146,155,7,176,79,18,1,228,242,227,81,34,121,92,236,105,176,207,233,51,86,159,119,70,173,14,42,103,31,241,149,157,98,49,61,96,106,94,142,12,146,88,63,16,173,84,14,216,170,188,7,119,188,94,156,24,78,218,117,39,252,216,201,136,241,118,24,231,164,15,9,211,193,68,14,9,140,214,99,95,235,172,219,136,83,12,95,75,88,48,152,236,153,95,137,236,38,125,35,176,220,87,52,101,106,40,172,224,140,105,118,201,227,143,43,59,162,152,247,197,72,70,232,183,21,160,2,64,169,41,69,166,102,52,189,217,130,19,196,230,34,133,35,31,17,193,45,252,112,79,79,223,99,168,154,14,19,74,179,41,246,27,199,128,101,54,80,252,173,165,241,80,26,204,142,255,57,94,25,56,246,22,133,229,144,110,212,118,251,36,49,81,254,183,116,222,99,70,181,22,74,96,199,161,124,176,7,199,9,56,128,64,200,185,222,37,225,144,156,152,22,99,76,208,43,99,207,169,146,220,182,136,30,96,166,118,49,125,40,132,106,49,212,158,91,55,84,208,213,75,63,190,113,71,83,98,109,21,176,11,204,253,157,79,106,111,232,239,253,187,98,141,32,52,39,209,183,100,176,183,32,232,137,209,189,13,67,230,44,99,233,235,31,211,62,149,120,185,114,79,123,8,153,151,112,255,65,154,228,16,226,177,21,18,10,146,172,134,181,123,4,253,122,188,229,98,89,112,147,19,145,108,246,176,210,201,128,231,96,230,39,140,7,175,246,144,253,114,34,223,14,48,134,160,78,112,135,138,197,142,208,213,221,156,197,198,131,42,169,203,191,140,36,205,131,59,11,239,147,205,235,193,132,59,199,198,42,204,244,120,24,172,221,253,85,141,118,110,76,153,91,146,222,142,200,251,52,172,145,250,47,123,86,49,253,220,27,77,170,51,36,179,148,26,32,251,162,197,246,163,248,65,123,233,68,194,166,153,206,118,238,22,134,49,13,218,176,11,183,124,197,148,169,251,224,80,11,209,166,233,229,19,220,114,244,144,246,17,131,119,108,78,6,26,238,121,82,13,57,179,139,149,164,255,235,181,20,240,76,155,71,61,89,192,100,16,244,93,71,199,139,70,203,107,44,233,154,66,40,255,1,15,20,206,89,244,23,68,123,164,177,175,187,170,150,195,150,44,96,99,142,169,220,220,197,235,124,72,198,60,112,180,196,35,190,154,107,29,177,10,243,111,210,61,157,156,223,255,101,5,210,27,224,15,23,138,119,65,201,139,134,84,70,122,22,204,153,5,193,108,54,149,173,173,37,200,81,229,93,72,7,45,14,51,177,85,166,96,189,55,43,70,88,172,251,17,221,163,81,62,196,216,14,31,82,46,38,65,125,42,32,4,9,145,100,31,102,106,231,86,31,167,246,39,11,28,118,34,92,179,80,65,191,115,43,247,211,118,115,124,156,122,145,222,177,73,161,7,117,51,20,29,178,100,26,127,202,208,177,209,121,101,140,194,20,229,139,123,55,186,209,31,33,39,115,64,97,128,152,60,147,70,35,97,4,156,87,181,58,244,132,109,115,229,91,215,10,28,25,21,57,163,234,21,101,81,18,220,78,130,105,85,41,164,78,228,156,201,182,234,93,221,241,194,212,66,84,4,11,81,116,94,234,37,200,8,214,228,253,58,205,250,62,168,189,1,46,223,0,158,154,29,127,247,188,25,193,165,228,117,234,121,149,167,254,11,3,15,12,91,42,46,11,240,230,134,120,108,46,58,63,23,230,140,113,173,206,94,55,63,20,187,32,255,142,32,192,135,161,231,95,115,204,50,125,129,245,15,153,89,124,35,87,200,91,78,68,126,100,158,103,224,232,192,132,174,34,19,19,48,139,182,247,255,70,88,227,139,253,31,10,222,62,188,140,85,169,143,143,14,29,108,159,46,98,211,30,129,63,149,77,230,246,61,181,103,153,124,242,214,63,70,78,193,78,208,159,94,20,59,30,81,88,112,124,123,183,101,239,217,86,232,137,59,250,5,110,107,71,27,31,15,33,62,200,161,218,153,82,134,5,7,141,180,7,152,169,23,182,33,150,252,223,90,209,54,177,15,50,19,8,253,37,226,84,143,33,164,230,38,215,102,42,156,198,36,35,149,175,75,79,102,252,69,215,7,165,103,252,189,221,18,204,32,86,110,22,47,74,38,247,11,126,5,145,242,247,20,9,190,177,121,79,16,110,73,41,45,141,3,247,35,3,252,191,45,7,156,127,115,198,74,194,5,25,124,110,61,109,115,151,84,72,182,140,170,23,217,123,133,98,143,18,53,128,55,78,61,89,152,214,253,63,133,196,183,215,107,107,158,245,129,15,153,169,246,158,65,172,8,47,226,30,126,10,64,163,175,108,218,130,19,89,235,34,206,150,176,199,6,140,234,201,165,130,107,208,64,112,36,44,115,250,199,236,204,60,127,43,124,225,163,49,76,103,210,254,126,180,82,44,230,68,93,12,246,201,186,72,190,172,76,128,42,173,0,221,120,14,150,19,197,121,163,71,111,214,183,143,24,187,70,13,255,228,250,134,173,209,183,166,208,21,225,94,109,145,98,70,255,76,151,190,150,183,152,248,238,224,187,111,4,2,111,236,73,135,133,67,34,193,94,52,159,42,187,59,38,75,152,72,134,112,236,191,233,150,43,156,14,167,70,226,7,114,200,31,140,164,33,84,232,169,15,96,172,175,192,57,229,71,227,101,139,17,90,45,154,32,255,204,159,141,200,159,147,45,152,135,128,51,11,78,181,154,83,92,144,157,134,244,234,140,201,95,218,104,165,146,35,28,223,139,111,128,149,30,162,119,191,217,136,196,219,138,212,22,168,182,19,118,34,168,68,234,104,231,59,166,128,52,254,212,215,218,117,66,31,249,88,61,78,33,130,242,94,66,17,169,102,100,130,251,1,125,169,71,110,165,239,246,162,251,220,185,184,20,76,133,171,122,57,219,218,181,169,220,38,166,27,206,53,166,180,135,172,64,7,187,131,182,110,67,34,191,25,145,197,184,217,30,140,72,15,212,194,123,34,239,194,64,110,117,35,199,82,17,157,252,230,226,228,44,151,158,81,101,191,59,18,175,143,139,235,12,185,50,15,106,29,143,82,247,211,52,208,35,153,64,11,50,37,13,38,232,128,45,104,62,240,201,122,137,83,140,250,178,64,142,202,168,54,119,221,215,71,166,35,108,71,223,239,99,153,12,8,134,64,200,182,235,107,96,111,231,153,200,254,189,247,49,93,127,4,200,77,43,160,120,224,252,243,224,46,190,166,143,82,46,207,86,235,116,203,190,88,18,55,121,70,227,215,107,69,58,245,221,133,33,73,230,34,36,254,49,127,129,180,253,175,209,180,54,94,124,96,104,97,243,225,38,248,166,230,189,233,78,38,61,122,43,51,76,9,219,127,1,239,79,151,48,213,26,208,118,80,108,178,180,167,38,224,5,87,106,12,73,252,109,195,190,244,1,237,106,212,236,116,74,192,255,121,219,152,67,18,77,38,21,51,27,121,200,196,0,84,219,179,46,124,54,85,12,179,49,241,46,197,14,33,28,79,227,246,94,112,66,187,209,230,116,161,40,15,78,57,156,110,138,178,73,41,255,178,62,43,236,180,171,248,21,243,240,13,110,71,67,79,176,57,76,207,194,20,219,223,36,60,83,50,200,87,245,137,235,132,89,144,67,4,174,55,221,14,212,138,175,187,209,186,54,80,178,238,243,36,9,199,108,128,111,120,61,208,105,53,44,233,236,78,63,226,71,197,238,242,101,100,227,70,160,209,41,198,56,65,115,138,237,132,126,95,23,46,122,98,177,164,159,251,98,212,145,111,203,95,36,21,53,163,88,57,51,139,255,60,181,38,187,107,75,128,165,215,232,130,56,103,173,192,192,119,72,104,142,246,79,232,200,17,207,225,61,55,106,74,61,126,180,229,233,187,223,190,82,11,232,15,84,52,13,98,154,199,134,191,227,132,219,235,17,230,249,92,249,34,165,54,132,101,234,209,220,66,6,69,181,50,132,160,155,246,171,5,167,56,49,27,175,90,222,36,13,217,116,128,9,151,3,203,43,43,40,205,132,14,248,28,88,180,107,146,95,19,175,0,109,41,170,148,148,54,179,0,71,101,59,99,221,143,205,42,59,156,112,136,31,59,18,231,136,191,41,46,122,77,101,152,172,123,108,116,111,53,229,4,163,218,156,39,171,198,100,223,236,90,205,126,143,72,67,138,159,241,118,154,239,154,219,34,182,123,33,163,113,46,15,249,238,36,50,215,132,241,226,207,196,181,96,162,212,88,224,190,81,179,12,136,146,122,238,83,129,26,72,105,125,20,146,253,67,112,232,12,188,96,52,161,160,121,241,50,77,49,218,20,78,169,246,196,95,213,12,11,243,170,71,1,244,78,233,115,143,34,201,250,23,100,9,97,17,4,211,193,128,42,106,170,138,9,75,28,208,247,157,32,4,210,106,87,15,97,167,209,22,160,123,52,183,148,194,21,14,53,212,119,43,76,147,154,56,43,175,79,109,103,68,93,115,95,230,242,89,230,162,136,47,37,79,109,220,24,217,83,40,241,45,113,250,138,133,115,120,72,115,222,65,36,226,44,1,172,128,192,152,113,44,162,139,24,194,114,139,90,162,31,228,198,129,96,97,224,87,232,183,43,193,104,251,129,67,148,240,227,100,4,27,202,89,241,226,221,189,142,102,74,1,234,197,88,247,95,217,142,161,58,118,124,174,252,162,242,248,126,19,199,138,191,202,209,59,204,127,100,65,187,50,108,197,107,107,205,55,228,48,246,168,68,28,74,186,102,54,116,29,188,57,221,206,122,202,240,151,15,23,162,146,91,12,88,51,69,3,110,205,52,5,186,49,46,171,126,221,23,30,236,45,162,17,198,211,238,177,147,106,5,203,206,78,143,1,167,153,96,15,225,28,219,223,209,68,221,218,102,32,19,138,90,130,254,63,73,240,165,99,150,83,198,65,210,22,92,216,204,186,182,213,249,35,2,80,190,138,101,47,225,210,232,29,85,90,174,228,82,244,173,189,193,47,20,238,93,189,172,27,25,87,244,243,224,87,201,186,153,42,69,160,195,77,180,136,128,231,197,161,163,94,0,191,87,57,125,254,155,170,223,110,165,95,181,188,82,153,240,68,118,58,137,253,184,248,35,170,207,20,197,246,93,21,36,48,195,147,75,92,94,166,34,77,198,225,189,122,91,111,136,32,138,146,132,33,113,35,32,184,97,10,255,132,98,61,203,100,65,30,160,150,30,85,22,8,32,101,187,142,240,176,3,67,219,207,113,202,242,213,177,61,155,141,225,69,7,10,3,184,65,132,69,241,149,214,97,91,168,150,187,136,18,190,15,66,134,232,239,202,169,247,10,160,246,157,238,77,41,185,221,165,157,108,94,145,231,229,169,101,1,167,15,161,20,158,211,139,204,107,228,206,211,185,65,246,158,167,12,107,190,45,182,28,192,44,106,148,62,159,222,82,10,227,237,251,3,151,152,139,76,162,183,169,202,107,181,200,129,195,124,71,208,135,234,26,203,154,53,208,137,99,150,100,142,114,50,153,183,126,133,1,253,9,202,235,65,46,106,126,8,5,105,93,53,17,35,209,62,117,114,152,57,29,66,71,127,2,130,103,158,7,17,86,195,64,229,219,75,195,212,33,209,50,154,59,27,177,135,24,163,107,219,137,197,220,7,153,96,131,0,65,187,83,25,18,15,100,245,27,6,174,119,25,182,124,115,158,7,84,182,105,34,75,231,222,190,48,233,221,49,119,79,153,174,200,28,223,87,37,72,254,237,189,199,23,239,255,69,27,152,251,104,233,142,231,80,48,149,197,234,170,200,149,73,120,9,20,212,128,69,99,144,23,22,83,89,207,47,19,17,198,156,214,226,55,130,85,146,54,5,58,224,214,6,27,36,31,164,126,182,225,53,4,52,100,11,28,220,125,41,101,102,215,188,97,6,55,113,252,140,78,81,115,58,203,129,115,132,109,206,21,68,78,20,128,95,62,34,72,211,75,41,78,234,223,115,175,57,229,107,227,179,9,162,15,86,211,207,126,44,120,162,65,99,15,187,57,91,18,41,138,119,15,37,90,138,187,40,13,121,164,30,26,160,7,116,143,9,149,10,228,215,85,75,134,113,241,72,248,12,116,160,177,187,166,188,208,252,178,182,169,220,121,139,203,135,116,198,224,193,215,214,189,110,168,68,129,130,192,8,226,15,122,181,16,37,227,17,156,38,246,249,4,89,193,12,237,32,109,66,52,139,50,235,10,231,210,19,204,191,161,192,238,27,142,203,62,146,194,119,135,132,70,245,214,127,209,179,254,19,43,72,110,124,118,71,34,142,134,163,182,130,140,131,160,56,194,13,10,6,8,136,131,171,206,237,108,163,127,8,17,208,116,17,165,125,236,166,45,180,115,123,110,117,255,84,33,201,176,66,60,220,2,92,128,59,50,147,27,232,7,251,48,118,128,215,225,182,113,163,1,165,184,212,132,246,28,57,13,84,140,97,222,230,172,120,254,160,216,70,239,215,0,111,160,68,51,0,31,109,79,49,38,221,94,95,37,226,200,239,75,160,227,1,122,27,49,244,122,133,67,125,60,12,216,60,89,219,92,146,252,169,205,31,71,112,119,174,142,76,205,10,173,28,31,26,119,222,159,151,151,214,150,124,197,51,174,17,3,58,240,120,130,175,51,87,155,106,76,197,143,86,226,95,45,72,196,34,230,99,248,121,236,163,207,67,132,152,165,42,252,107,111,171,10,114,221,71,94,190,87,197,251,236,116,86,60,82,253,64,166,236,178,150,126,252,230,179,186,45,52,123,29,16,175,237,157,13,213,215,69,153,217,233,51,38,227,186,80,200,188,65,110,196,78,3,202,66,175,161,253,111,249,120,23,44,176,170,211,138,243,128,128,115,108,85,27,23,107,91,1,212,31,154,136,228,166,30,96,59,92,34,162,61,242,225,232,47,195,154,45,144,74,125,246,69,128,166,229,187,39,196,152,5,66,133,189,18,245,235,31,214,153,14,205,11,130,1,238,167,83,107,14,41,235,8,139,62,37,74,87,110,189,142,226,150,1,219,52,58,115,150,62,55,66,239,30,11,157,138,57,159,200,148,184,237,250,169,248,88,159,137,188,98,30,50,189,59,15,225,149,129,184,102,146,114,254,181,178,143,54,171,186,63,219,29,83,52,76,222,208,189,242,11,81,188,87,249,54,213,162,246,147,7,72,54,22,48,119,146,108,131,16,194,137,175,45,132,109,33,243,243,40,190,135,54,116,177,29,228,193,151,91,207,114,183,37,198,58,44,53,196,42,118,27,144,95,155,137,80,255,233,76,228,204,81,135,24,99,82,230,130,134,134,90,185,64,21,78,113,200,124,44,66,8,202,250,219,158,245,90,117,100,130,99,79,193,113,76,66,140,147,91,76,194,35,42,183,235,58,162,251,48,190,103,86,96,173,72,202,179,222,118,203,182,225,42,46,211,245,250,204,238,192,46,2,210,178,141,212,84,160,233,228,60,100,58,151,244,252,138,108,189,119,187,104,222,9,36,11,182,33,204,41,164,233,176,152,233,86,233,50,206,99,64,128,110,66,233,201,123,179,225,189,88,55,210,152,178,238,149,204,213,200,212,190,228,170,205,255,165,46,209,51,91,74,229,36,181,120,52,6,82,169,229,225,218,231,110,222,218,6,179,193,106,30,34,243,244,157,149,112,198,254,119,89,250,217,97,62,28,209,188,203,80,211,129,242,222,66,129,254,133,112,29,113,174,62,6,239,237,224,23,116,214,189,215,75,239,171,17,204,68,178,19,31,37,201,108,153,71,126,166,217,28,201,87,186,193,62,200,110,44,41,74,172,66,60,174,120,134,18,85,137,113,240,138,170,198,225,97,115,26,202,243,51,96,31,18,185,179,52,52,98,63,170,11,216,247,18,9,35,203,107,220,12,6,21,178,236,232,102,112,57,211,73,9,28,24,100,146,157,25,199,182,169,71,71,6,60,175,82,210,8,190,110,18,136,70,15,43,13,60,52,12,43,123,111,248,2,36,45,160,215,73,52,54,36,80,105,210,238,113,115,116,84,251,91,72,109,192,195,188,108,51,89,2,189,86,142,28,210,69,246,138,253,85,224,49,223,6,47,125,40,72,173,56,214,70,132,134,51,244,168,101,112,151,126,77,102,143,239,4,13,116,106,10,103,119,126,65,6,31,18,107,68,76,241,127,130,133,186,61,250,68,253,189,150,134,117,83,51,83,25,187,118,78,134,35,123,184,148,245,53,68,14,88,131,0,68,159,141,48,76,196,130,198,34,56,19,203,64,75,87,26,133,28,73,19,242,167,183,2,251,172,114,9,7,155,151,79,86,68,141,54,101,212,74,210,65,219,237,175,83,252,71,245,207,108,46,196,105,180,46,85,217,5,128,221,226,157,62,176,224,25,140,26,228,142,51,187,96,116,42,92,18,197,211,133,4,0,207,161,141,187,60,8,215,220,174,187,41,153,27,83,242,133,205,30,135,7,207,178,168,111,3,85,173,149,137,68,187,204,184,237,209,59,41,154,36,35,7,212,199,183,241,25,178,86,195,41,137,201,81,164,246,218,251,180,218,161,189,193,147,17,147,15,78,69,23,170,86,93,28,58,170,81,208,143,20,240,63,182,158,203,197,94,135,254,11,135,124,183,89,193,71,88,184,98,208,164,134,197,140,75,234,159,83,20,177,109,123,195,118,229,245,116,207,220,6,11,187,253,37,198,220,195,29,176,38,46,67,200,232,90,245,23,105,165,133,57,29,208,185,232,69,180,3,5,19,111,91,226,98,197,90,102,20,243,203,137,88,156,217,18,24,141,253,17,194,150,75,120,212,232,5,187,191,80,176,71,27,94,71,149,230,108,103,17,129,248,166,186,196,171,152,249,136,146,130,38,204,223,106,175,46,105,241,113,125,212,159,243,233,110,229,177,187,141,186,157,99,212,232,218,25,58,4,212,122,110,11,236,187,184,12,168,127,135,212,37,81,184,79,102,171,143,151,189,158,113,56,80,94,110,58,223,118,37,73,53,158,134,151,251,250,216,143,88,233,8,206,211,238,115,195,53,186,238,140,128,150,50,225,14,236,49,195,224,75,85,229,24,20,244,72,136,144,15,96,152,6,156,158,133,144,200,229,50,186,234,205,77,101,31,5,147,136,55,31,158,100,141,179,213,225,15,161,176,225,156,40,169,60,57,227,45,170,44,97,107,83,178,31,102,192,84,212,43,159,32,188,252,47,248,53,6,68,8,126,187,27,46,133,214,4,199,153,29,177,123,35,170,100,66,253,178,46,37,206,97,62,17,208,98,178,195,223,64,76,251,94,132,241,102,36,130,182,53,98,94,253,122,211,197,204,144,195,101,203,40,158,215,192,102,44,87,233,61,81,147,158,79,117,222,27,26,219,168,15,59,142,65,113,172,49,253,190,191,188,12,59,244,226,238,7,59,116,34,120,56,20,118,83,59,78,142,79,43,150,41,207,228,35,234,182,14,86,50,120,254,31,74,82,5,29,39,173,104,87,10,249,237,158,29,211,250,239,50,64,90,200,107,209,100,26,135,182,38,139,177,27,64,6,87,21,235,204,230,235,222,248,48,156,212,204,138,22,36,123,3,40,93,25,200,55,162,51,116,3,140,58,246,81,78,59,89,103,138,23,220,89,171,48,48,203,181,80,163,171,109,173,17,34,188,238,42,205,32,106,18,122,80,8,247,127,26,32,148,141,138,226,57,27,129,234,74,40,235,202,6,106,127,1,11,117,117,236,240,123,227,139,185,241,205,42,57,186,237,83,21,90,3,25,88,42,109,224,140,238,11,177,108,46,111,28,229,139,95,217,72,101,173,235,131,28,2,85,51,19,52,105,218,235,176,84,57,140,165,80,238,93,92,6,47,138,188,132,100,36,219,223,236,201,112,201,190,0,20,146,68,95,16,147,1,52,108,54,185,188,154,104,247,173,127,160,214,230,207,56,112,98,105,62,42,66,97,101,47,220,193,114,23,202,61,21,118,64,16,191,112,119,123,20,117,173,202,70,39,239,112,202,66,142,163,211,106,89,2,97,150,55,78,226,111,190,170,144,53,195,72,96,89,229,178,153,130,164,161,86,154,154,21,95,120,12,31,122,50,142,245,189,124,17,218,35,201,75,20,203,234,97,11,70,151,3,185,169,71,243,91,56,248,117,103,8,162,90,14,193,33,124,194,169,48,150,40,80,127,37,151,74,195,221,99,145,74,172,228,150,120,147,204,160,67,110,187,30,236,197,101,7,127,128,115,7,243,235,20,66,101,40,114,136,254,206,220,67,96,231,89,65,202,234,82,8,131,187,238,220,213,142,223,77,25,167,69,68,87,110,101,200,142,51,26,234,143,164,214,134,215,222,141,23,42,75,147,88,211,199,154,201,24,72,202,13,136,234,25,52,120,254,136,185,193,163,187,133,84,93,81,133,177,73,126,136,46,251,136,144,180,33,34,18,230,128,47,79,79,106,150,8,58,160,248,106,132,183,215,17,146,173,177,243,32,65,1,175,14,45,235,55,127,69,29,175,177,184,199,168,231,173,143,212,218,44,28,243,157,87,243,247,193,142,155,49,191,221,140,235,246,53,125,204,139,60,232,18,220,63,106,61,252,172,154,140,47,208,189,55,163,20,44,108,250,50,252,255,204,45,52,2,76,66,64,241,107,21,163,134,187,242,247,136,203,1,7,118,226,244,67,198,15,238,194,74,9,230,186,185,49,162,49,71,168,31,130,160,103,223,244,225,108,133,142,123,181,164,114,112,172,100,229,165,150,250,57,212,15,63,204,70,163,4,98,111,152,45,37,45,245,228,45,244,111,124,250,163,197,120,243,232,117,56,154,191,145,196,141,125,8,55,90,132,216,85,224,174,60,253,201,63,198,114,202,235,236,103,174,176,192,65,93,161,74,226,65,222,241,126,119,113,174,16,71,68,19,253,160,250,79,117,231,129,159,61,132,104,164,251,78,110,48,246,12,36,172,100,111,152,87,36,40,95,115,60,227,74,123,204,149,244,119,65,162,114,102,121,19,155,249,117,248,51,151,33,42,115,199,237,144,43,180,51,121,129,23,83,127,226,56,9,32,222,44,201,44,21,7,249,122,183,224,239,85,204,10,181,91,19,103,103,133,205,12,229,38,97,31,108,141,82,255,186,32,185,59,95,66,45,15,41,179,36,56,178,53,39,230,128,252,12,104,165,98,132,4,223,238,44,36,222,188,218,52,250,146,212,148,237,85,68,175,72,79,155,38,36,230,62,122,67,208,138,241,5,49,158,119,106,100,178,247,61,154,161,134,111,198,28,192,44,150,189,7,205,154,142,45,190,172,69,107,176,36,105,64,30,153,120,233,138,210,10,19,201,37,119,182,152,85,43,37,56,68,199,14,82,214,220,245,249,231,141,77,20,190,252,61,102,166,209,230,24,109,225,229,78,195,145,93,109,32,127,163,49,126,248,87,165,80,47,35,155,3,51,50,146,244,105,171,122,226,62,82,242,157,209,37,222,157,224,156,21,73,10,238,198,123,110,60,209,122,158,82,5,221,166,227,119,183,251,80,175,245,112,156,150,175,183,247,162,53,159,213,33,71,40,168,227,104,244,244,210,154,12,114,234,6,153,36,147,203,170,108,85,64,250,110,225,137,2,143,243,163,40,173,220,191,63,210,108,131,154,142,83,175,46,56,41,236,83,221,81,161,144,135,172,99,88,139,115,229,148,143,162,9,203,12,44,238,102,165,234,230,179,179,242,16,227,158,20,196,203,126,102,121,194,246,105,131,73,192,81,122,192,229,32,52,68,139,60,16,102,94,4,190,236,77,238,222,73,240,221,6,252,179,240,56,85,108,237,167,95,168,223,161,49,28,186,57,93,43,203,125,223,42,221,67,47,174,96,56,99,204,115,41,252,252,106,153,180,228,242,100,155,42,105,108,181,215,47,150,176,81,36,192,211,244,135,162,127,189,201,80,62,117,91,125,58,245,215,9,16,165,134,52,42,43,225,155,28,21,189,76,85,226,216,155,133,105,120,60,145,152,6,52,150,149,2,255,255,126,255,45,36,58,37,21,112,25,5,210,187,69,74,195,46,226,170,12,90,154,7,142,228,89,148,22,211,1,150,132,252,99,19,215,135,242,15,150,0,17,251,192,38,133,71,164,62,161,144,240,178,62,63,254,50,137,26,207,233,156,52,145,94,86,239,132,26,146,181,46,165,248,100,14,76,252,16,214,130,195,166,67,120,113,30,255,126,197,11,57,108,130,66,163,177,70,30,223,117,244,53,44,13,86,39,70,58,213,212,230,152,164,76,152,10,227,3,6,230,216,73,88,108,91,245,126,137,58,224,132,168,129,199,254,247,134,142,56,81,168,160,119,44,222,123,230,189,204,92,245,18,227,172,58,240,174,149,68,71,210,183,169,241,146,73,86,210,216,156,250,239,161,219,212,210,69,48,33,137,81,185,192,218,197,2,122,26,76,13,121,61,31,44,239,37,158,126,254,241,131,26,167,224,67,133,125,52,204,195,141,119,131,208,214,151,86,54,137,139,144,178,173,220,170,156,70,125,66,38,125,127,135,146,246,160,95,230,1,248,184,55,65,56,225,139,169,106,17,246,153,98,119,248,67,85,148,28,157,200,233,186,149,138,180,147,37,42,212,190,28,189,109,117,242,168,56,133,17,29,241,89,218,5,242,81,50,61,166,175,124,106,47,237,20,201,235,69,95,202,35,243,79,223,34,85,47,100,252,168,29,171,20,189,109,65,14,156,71,195,246,94,104,211,21,29,195,84,33,131,207,221,120,139,57,78,126,88,195,191,172,133,96,242,110,140,236,227,76,154,55,32,134,193,20,204,21,192,232,157,224,147,175,193,96,9,127,18,107,239,96,240,98,139,149,104,92,151,196,170,198,104,185,117,179,26,20,72,48,36,47,32,86,42,189,173,80,71,219,151,79,181,88,45,26,191,38,133,45,54,131,31,109,115,161,163,34,38,89,40,49,173,198,48,17,40,39,121,77,90,70,42,251,130,168,125,184,76,60,95,94,136,227,248,145,210,226,191,137,247,72,210,17,141,52,5,102,220,23,111,146,114,218,208,22,105,9,130,97,83,57,25,228,137,6,99,12,24,29,89,25,101,217,133,196,253,246,158,114,75,8,90,142,28,147,19,22,164,240,205,1,21,145,19,225,61,98,21,22,215,32,158,9,44,97,148,104,201,219,76,43,45,162,73,151,252,188,155,192,134,113,103,109,255,54,42,206,24,76,87,154,98,187,78,193,50,86,191,222,86,162,165,38,191,118,117,72,31,6,174,147,231,105,158,70,133,79,138,223,55,73,210,90,194,194,112,167,14,253,133,160,197,234,193,24,75,239,106,47,115,70,102,75,122,123,87,158,185,162,180,84,210,222,141,172,125,211,117,181,155,250,182,51,247,178,100,123,8,8,173,224,246,222,40,35,31,171,203,195,36,34,6,53,171,105,219,106,216,77,18,130,182,37,225,3,235,196,203,114,168,7,2,10,14,230,118,6,134,118,20,184,145,213,218,127,110,182,193,145,91,202,110,11,96,118,1,8,96,103,167,236,180,15,141,151,253,100,7,112,25,70,89,121,233,178,158,234,47,68,162,185,146,146,7,74,2,17,238,108,171,91,64,92,173,85,82,121,240,175,136,132,26,123,225,64,169,132,53,192,187,113,8,165,133,192,249,61,166,108,170,2,175,11,243,183,162,93,109,51,151,40,206,39,150,0,84,130,215,29,211,96,200,244,193,206,63,137,9,225,205,195,93,147,70,125,177,146,164,76,247,0,61,118,12,73,75,151,145,218,82,180,207,112,233,175,169,104,180,29,149,4,129,248,70,10,159,34,67,208,4,235,146,205,128,223,104,17,16,189,72,150,29,148,21,85,152,237,97,200,84,57,234,9,165,16,73,40,118,10,18,222,171,43,231,169,211,149,179,250,145,227,129,66,53,2,35,228,99,7,1,101,161,122,247,98,103,47,32,194,21,66,228,215,171,211,95,93,47,71,164,197,154,72,46,73,190,186,131,152,104,252,1,237,94,154,240,6,67,188,57,183,3,28,30,181,14,142,247,193,242,88,231,188,86,198,130,125,97,9,115,137,196,6,38,94,170,51,157,253,197,152,195,181,150,253,125,49,6,217,29,102,120,252,248,217,191,232,176,151,7,118,12,126,164,219,67,123,72,16,146,223,203,183,0,196,87,186,185,173,67,246,204,171,20,21,86,98,182,253,7,186,6,120,189,118,3,229,237,60,53,90,120,139,87,229,79,153,85,139,16,81,100,189,150,202,125,164,42,132,10,163,190,85,177,69,169,181,85,186,64,77,182,99,209,185,183,19,5,1,24,167,247,211,71,7,154,124,136,40,199,61,196,217,202,170,170,93,64,20,178,234,247,41,59,124,192,158,211,128,28,144,37,95,61,108,113,150,27,161,102,97,250,86,162,10,193,27,201,55,193,56,84,164,176,59,172,180,2,117,209,83,226,255,156,104,115,80,9,171,177,196,38,252,19,138,252,29,242,231,74,93,205,161,41,158,79,204,211,0,30,248,42,125,237,167,151,3,163,35,219,102,225,38,80,160,246,91,202,15,81,5,104,108,210,239,193,131,146,27,150,17,171,71,221,84,112,204,146,94,186,237,255,206,118,141,107,20,169,226,15,43,75,224,52,120,186,0,134,235,166,30,237,98,31,139,146,29,104,64,56,3,249,66,92,147,217,211,9,31,96,178,69,148,227,230,101,236,243,45,246,172,39,229,59,69,106,63,147,212,148,179,217,10,220,19,61,36,147,54,173,248,250,238,79,181,163,211,105,11,79,136,249,56,91,202,219,147,180,212,42,140,52,110,222,216,92,215,61,213,55,188,33,239,190,201,255,96,1,215,85,244,86,49,152,17,180,172,68,196,115,71,107,182,243,219,136,48,23,116,210,242,8,233,123,235,101,169,61,55,63,1,51,205,161,189,96,59,52,218,197,250,26,88,73,52,217,104,199,216,234,189,209,12,232,29,210,128,20,244,127,219,15,204,123,222,84,167,249,54,43,174,28,118,186,210,116,176,58,78,38,166,130,144,219,92,43,91,180,1,195,20,39,139,0,25,240,204,75,61,178,95,199,10,3,136,139,50,249,155,86,95,70,214,41,166,76,132,6,166,146,35,118,145,100,203,149,154,211,215,94,104,5,44,83,183,45,251,89,212,57,197,144,82,87,170,120,45,105,80,129,100,131,159,10,127,221,163,246,63,192,154,53,205,6,127,117,223,24,147,216,93,28,239,163,214,221,158,12,149,255,83,88,41,136,165,138,1,254,6,44,25,143,22,104,150,94,24,196,25,238,193,216,170,71,103,76,33,52,211,45,205,235,134,41,248,86,65,9,32,255,32,95,30,250,243,251,43,119,170,184,85,107,38,21,98,231,54,218,226,16,72,174,6,221,38,211,120,221,119,117,120,67,209,251,33,84,155,163,163,47,53,96,15,51,76,204,87,153,85,170,54,66,113,12,174,34,104,136,90,62,76,103,210,150,82,37,200,148,44,89,113,229,33,173,240,114,61,21,131,193,157,216,181,193,207,219,29,42,99,21,186,158,11,145,155,4,216,22,244,162,245,120,63,128,57,117,241,213,60,251,251,149,87,153,99,63,22,75,81,103,103,239,199,225,110,110,88,38,125,240,116,161,226,53,38,183,2,223,68,221,87,205,73,201,187,129,82,39,35,166,109,116,96,250,15,15,242,104,227,86,21,140,48,172,188,54,214,185,33,4,199,217,220,218,185,44,244,170,133,64,135,231,135,80,159,130,65,112,36,250,209,241,226,74,174,130,199,202,217,218,87,161,162,130,254,242,150,34,63,117,178,224,76,211,80,201,111,72,69,137,93,62,24,23,249,115,80,83,95,17,166,84,223,132,120,6,53,34,199,208,205,80,109,133,213,92,49,18,214,230,123,245,73,80,228,94,106,241,165,216,84,255,96,177,178,90,92,5,219,185,153,238,208,136,79,150,15,232,139,179,52,146,235,158,62,239,136,154,45,92,190,176,19,91,40,214,152,149,209,222,247,97,175,74,250,98,231,204,211,233,2,168,136,18,202,254,144,196,95,80,187,220,123,31,164,176,207,23,248,81,3,174,138,206,65,83,36,29,70,32,71,21,227,157,254,228,2,4,215,71,27,252,9,219,49,49,23,248,163,43,170,192,126,75,198,97,91,38,182,93,204,141,250,187,145,128,158,103,88,73,178,191,233,253,231,3,169,38,117,163,181,44,217,91,138,15,239,82,140,19,78,13,168,212,227,46,202,225,130,28,150,211,105,239,25,243,208,76,174,52,37,170,87,125,141,221,90,95,41,51,53,205,112,75,54,129,102,51,87,222,28,117,188,154,174,103,66,55,95,247,97,127,31,107,22,117,195,115,97,108,19,52,70,179,212,190,15,8,213,49,139,119,170,201,169,8,199,203,166,183,90,134,185,169,133,135,9,251,66,104,187,220,182,164,82,21,125,132,197,116,14,169,241,211,104,107,169,17,246,140,46,235,236,23,84,93,180,72,214,10,39,185,197,170,73,30,43,35,75,114,202,126,143,2,127,114,206,107,25,116,183,11,43,3,146,183,121,214,79,26,240,70,203,45,88,74,11,137,245,21,38,44,66,143,61,168,69,76,204,92,186,121,203,15,46,213,237,131,23,220,68,52,188,111,185,48,81,35,208,159,218,44,76,71,236,152,61,103,92,247,136,123,88,196,109,213,91,97,190,88,164,237,171,59,217,231,230,51,149,191,114,162,41,91,249,249,25,109,183,231,25,48,30,35,44,156,199,26,146,144,26,85,40,82,54,83,253,102,88,29,52,114,160,176,0,95,4,217,205,123,143,97,62,149,15,178,195,166,156,183,183,170,183,54,232,197,211,241,7,215,241,86,159,151,161,98,116,91,139,14,111,22,41,155,5,43,72,245,246,20,196,27,62,112,149,21,253,42,111,173,148,25,42,199,41,53,84,169,17,246,92,25,211,161,41,159,252,62,243,4,19,121,43,66,199,74,28,208,193,205,33,126,84,173,30,16,26,179,244,95,188,90,6,16,178,251,191,203,121,130,161,12,52,170,24,14,141,2,163,190,6,52,205,187,57,245,252,9,53,65,132,246,126,90,3,26,54,238,222,74,237,35,163,214,83,43,254,139,112,244,74,15,241,20,255,217,117,129,81,233,181,187,160,29,30,245,145,199,163,29,171,87,228,222,50,229,60,139,23,152,179,33,23,124,180,100,223,209,21,191,93,240,166,209,66,67,28,158,237,190,62,80,188,131,151,72,22,159,212,121,139,49,254,184,106,134,122,77,103,165,81,70,69,174,0,7,179,26,152,234,23,37,155,212,120,59,223,226,216,189,170,9,42,206,10,123,140,130,214,229,149,218,74,215,152,151,235,170,53,33,209,190,193,105,61,182,108,226,176,32,213,78,117,106,23,56,121,61,82,213,107,121,107,114,185,20,99,151,57,44,105,153,238,174,24,192,241,254,251,80,193,143,221,0,58,227,109,190,129,185,22,131,37,221,129,34,101,144,152,33,250,198,183,73,236,69,174,215,68,64,181,94,33,132,40,149,248,252,133,191,99,245,130,21,43,49,211,224,204,33,169,240,230,120,107,228,46,140,168,241,32,17,95,48,147,101,16,176,251,83,160,253,105,171,56,79,198,139,36,48,144,120,99,236,171,235,56,117,196,171,178,244,170,61,79,183,32,202,66,50,130,211,99,78,199,73,255,242,30,138,199,156,129,107,187,182,255,144,201,230,138,199,111,154,10,126,232,144,99,117,187,160,97,221,177,191,5,239,139,181,240,32,249,247,61,216,207,154,217,224,246,49,118,3,194,107,197,233,3,242,99,182,58,45,151,176,238,101,118,57,44,123,195,112,61,129,140,199,98,25,86,104,2,141,220,161,128,109,32,8,89,147,249,11,246,14,255,195,81,233,46,89,37,122,225,211,69,132,120,138,169,254,0,72,208,116,247,244,60,55,28,135,15,11,28,174,65,40,253,148,181,6,57,220,134,224,205,255,225,22,228,49,200,228,182,179,141,237,217,9,47,114,203,57,24,173,236,15,100,174,120,178,73,84,236,141,45,188,142,252,66,85,56,248,161,247,21,240,209,145,198,24,158,227,106,158,18,248,204,21,1,99,35,91,187,157,228,98,106,35,231,158,103,53,119,135,62,168,207,48,5,118,236,117,255,204,65,60,49,102,180,55,82,149,17,205,214,182,198,223,77,55,234,99,156,29,161,90,22,138,7,126,240,213,226,110,63,214,97,71,161,203,216,10,31,25,62,71,223,163,238,97,14,115,144,121,112,103,4,186,16,66,51,105,110,65,111,32,206,82,213,231,74,107,199,255,85,48,249,19,123,45,142,3,104,77,86,181,99,8,158,50,3,108,43,23,113,246,189,180,107,134,24,9,137,36,178,9,176,197,63,33,63,164,220,217,243,175,16,197,210,28,16,109,192,143,193,240,252,44,124,8,108,179,168,171,135,107,32,216,49,136,123,109,133,33,176,167,185,189,30,120,210,5,211,14,127,118,199,147,121,246,58,33,239,172,251,87,223,152,144,13,169,216,65,87,59,132,210,118,116,30,68,72,68,155,103,230,81,33,26,21,82,14,73,251,183,147,86,222,194,97,44,169,244,82,155,95,253,205,116,91,165,44,64,31,163,242,253,93,23,26,209,14,33,97,62,148,115,63,247,111,137,13,9,163,215,243,223,218,10,114,82,195,219,233,24,117,167,173,231,13,156,77,46,231,130,200,122,169,91,49,229,215,250,140,73,229,240,44,212,41,117,112,31,126,218,196,58,241,101,147,26,195,148,98,153,198,104,87,90,149,128,60,239,177,50,49,11,242,239,230,196,182,89,101,80,215,168,143,70,48,53,53,215,22,99,194,129,245,128,163,40,102,25,14,99,189,152,35,135,13,16,105,137,188,32,226,246,176,38,30,36,65,146,145,240,83,103,2,107,133,21,172,41,239,28,250,134,170,228,80,43,122,211,87,111,228,168,29,171,79,69,62,152,18,69,203,96,169,144,83,50,37,65,208,1,113,46,2,67,73,221,2,181,73,185,209,20,163,237,141,222,221,69,220,155,12,177,239,150,84,234,58,111,225,3,31,187,110,139,78,139,234,186,202,73,72,34,125,59,43,206,220,68,6,49,123,14,147,144,206,60,95,31,173,236,244,239,64,11,119,89,226,7,117,175,218,115,104,165,195,209,202,140,132,15,6,115,213,209,69,238,7,89,37,249,156,158,67,124,208,100,194,232,148,52,214,125,166,99,224,152,46,109,187,234,230,51,60,189,191,120,28,13,67,152,105,230,40,147,153,215,16,149,231,51,170,159,88,97,228,216,161,34,87,65,129,153,213,186,140,150,104,113,164,25,120,246,58,78,221,124,33,179,135,7,220,233,68,9,15,123,101,187,131,139,95,177,234,29,215,24,57,107,53,194,252,161,247,70,224,245,22,104,10,41,39,213,190,186,249,159,32,28,196,55,153,225,205,18,72,227,70,120,101,199,237,132,225,10,124,88,154,151,215,153,67,177,100,244,99,169,37,127,97,122,188,216,217,79,187,227,87,69,243,42,139,151,228,79,141,154,88,240,7,29,255,165,129,150,70,173,212,207,194,245,243,54,210,111,168,77,71,140,61,28,64,106,8,196,60,68,154,18,110,22,252,63,172,163,34,138,138,105,145,101,244,110,11,75,95,244,220,224,140,191,243,85,79,137,128,246,173,146,28,1,68,146,131,190,104,107,105,10,183,141,149,204,59,176,190,91,3,180,254,33,47,24,58,4,53,177,211,193,103,6,161,57,156,191,177,108,76,83,185,133,20,167,103,26,75,148,54,239,124,182,71,95,160,157,60,112,22,149,136,53,82,150,241,250,192,35,199,124,207,79,66,84,131,7,63,140,114,16,166,158,30,0,73,131,202,144,116,46,50,92,60,23,147,147,14,236,195,64,128,205,63,248,146,1,49,182,30,96,166,149,196,243,131,88,93,119,167,118,22,137,56,179,169,223,194,48,235,4,196,19,7,210,55,75,235,92,247,15,83,174,53,132,172,34,214,91,205,147,70,34,195,103,132,175,68,245,7,227,205,122,160,7,72,137,123,51,243,8,7,82,113,179,53,171,249,151,156,75,82,204,101,194,53,247,2,201,39,125,151,8,4,189,190,40,95,41,72,181,116,99,58,100,136,118,164,13,191,107,164,69,39,229,204,2,248,254,87,112,64,247,106,105,66,193,73,104,67,75,181,248,105,39,227,153,139,164,41,215,76,244,118,95,99,56,13,94,20,67,33,205,238,108,249,81,105,60,177,18,155,229,73,173,205,78,164,144,180,161,191,210,203,150,190,16,55,228,110,203,212,118,15,103,25,67,152,199,2,36,17,117,201,129,88,197,112,153,188,44,58,196,160,131,198,150,19,223,209,224,90,127,231,71,1,40,82,195,12,242,223,233,211,68,210,32,176,1,106,119,179,211,33,221,107,210,194,227,213,88,3,122,19,130,145,199,16,66,179,41,215,40,18,133,40,191,25,49,31,101,27,16,11,60,119,20,186,217,168,204,250,28,173,159,38,166,106,2,35,49,133,30,16,174,41,134,5,154,247,72,247,171,23,225,89,228,141,14,221,122,56,188,54,252,90,121,252,169,8,168,27,59,138,8,245,70,122,230,65,165,140,117,136,206,11,169,209,146,240,8,234,87,27,21,119,136,227,84,138,65,172,42,227,109,202,167,67,219,148,125,32,179,242,176,224,42,235,163,145,195,63,145,122,135,21,164,85,133,249,38,87,145,90,3,151,203,189,99,172,189,248,86,207,193,226,138,44,42,179,190,99,83,127,92,185,32,159,58,246,239,241,246,235,227,205,219,169,42,77,149,0,212,210,172,47,174,68,122,133,7,78,152,86,30,65,58,84,65,40,113,125,213,150,112,146,1,46,218,175,242,206,243,3,22,233,246,135,129,96,57,130,15,151,104,91,220,169,42,107,34,44,14,229,23,97,55,219,134,96,213,252,133,227,120,195,1,46,17,86,212,120,130,91,248,166,233,51,66,254,106,183,117,42,44,36,169,196,204,173,91,96,109,228,171,28,189,45,250,183,121,167,12,164,164,245,225,177,164,170,138,139,161,93,90,83,85,26,198,104,106,203,108,131,144,196,153,22,188,229,99,101,228,68,84,115,35,112,19,129,18,184,189,228,220,191,206,106,106,126,188,176,42,150,208,166,249,215,76,49,78,167,49,137,16,206,210,203,31,206,130,158,233,143,12,168,123,152,246,181,110,5,9,143,33,8,20,72,188,117,52,80,18,200,90,101,236,228,207,56,241,5,217,53,40,86,180,67,214,216,113,227,232,42,4,123,161,29,225,131,69,60,164,193,158,200,54,177,14,32,137,153,25,110,144,200,246,156,194,61,16,88,79,24,113,181,5,133,88,82,165,176,38,251,156,45,231,111,141,37,120,107,195,254,51,23,243,143,18,30,92,222,216,31,27,168,49,204,158,75,50,29,108,173,189,227,162,147,5,233,159,187,189,71,11,14,221,15,68,223,60,234,186,227,182,193,229,131,242,98,115,34,126,30,59,20,56,101,249,9,38,148,110,79,181,179,181,29,240,61,110,204,161,242,160,184,30,38,49,180,136,78,22,156,1,249,192,217,132,67,3,250,243,132,141,231,10,84,231,97,122,73,28,88,116,105,213,193,202,47,183,216,19,80,71,55,14,123,32,194,193,121,208,234,113,73,234,146,93,189,196,164,129,140,201,122,187,60,67,10,121,125,17,246,192,134,16,58,220,3,66,88,63,127,197,206,164,85,151,11,143,43,109,35,215,25,113,90,99,90,205,22,209,122,41,112,244,206,253,59,161,241,168,251,89,190,186,151,193,3,142,219,1,102,68,147,87,145,74,157,223,203,18,248,51,21,219,92,9,251,196,149,82,153,103,27,151,252,54,21,4,47,205,56,172,183,3,29,202,225,83,16,70,15,21,227,219,225,178,248,157,53,135,57,185,163,37,123,167,126,80,187,41,181,17,191,207,228,71,37,158,205,118,62,248,250,194,59,71,214,167,103,233,25,73,205,178,231,128,78,53,113,28,73,140,86,87,88,87,238,196,137,77,234,138,39,195,39,117,89,71,3,123,115,108,182,175,148,180,142,193,159,155,141,71,168,172,98,136,187,112,36,25,146,98,217,160,17,34,77,55,98,189,208,173,74,117,181,200,124,182,123,12,56,62,149,214,75,112,112,107,126,242,224,85,234,235,172,131,250,233,229,99,14,92,194,36,21,156,167,172,215,243,141,214,57,79,177,104,94,207,160,8,3,102,237,50,84,126,223,147,92,211,221,196,52,130,24,176,159,132,65,156,131,71,126,4,33,143,91,104,28,50,153,209,95,181,28,75,113,70,67,27,109,192,39,174,135,252,172,218,211,94,160,62,199,154,79,251,16,22,195,15,22,140,253,36,242,85,72,147,22,121,33,25,195,83,123,67,179,160,66,85,146,45,114,228,93,116,57,55,217,212,216,31,50,167,229,242,19,107,240,57,124,255,142,191,249,148,74,39,163,43,156,151,201,207,220,46,185,27,203,141,137,15,92,5,101,198,159,181,2,84,128,42,9,10,185,221,175,55,128,247,131,98,98,146,152,8,240,110,121,15,67,233,2,21,145,83,105,182,127,239,100,153,185,165,225,124,59,119,26,175,192,81,4,98,42,93,184,200,34,68,13,134,123,5,43,164,167,218,32,67,79,70,4,196,254,131,50,201,157,133,80,79,208,242,155,224,237,252,110,27,249,238,45,235,77,229,182,93,205,123,32,5,3,78,154,69,213,117,216,130,198,46,105,47,78,76,255,250,230,254,99,106,218,110,21,186,185,71,173,236,91,67,119,59,38,141,202,223,39,183,153,239,2,113,168,121,123,54,217,55,237,94,11,1,190,38,16,170,216,147,239,88,254,229,245,220,108,102,247,55,229,237,173,167,179,231,185,82,226,109,53,81,87,15,55,217,69,204,109,3,164,126,143,193,42,141,227,90,36,226,83,128,215,12,177,216,190,140,85,129,225,224,25,74,141,225,41,192,131,60,180,130,169,191,124,58,1,135,224,63,27,9,138,244,124,167,199,35,2,120,62,25,218,238,78,254,29,125,60,19,72,168,31,194,52,28,70,137,193,242,203,2,91,43,138,248,5,135,204,165,116,67,10,198,121,98,100,238,143,43,94,209,39,162,232,129,176,41,254,158,40,195,167,51,206,48,151,123,55,64,65,233,220,176,238,73,3,129,139,129,242,194,88,95,199,147,187,75,237,229,171,30,89,115,154,239,165,169,235,59,98,63,177,91,115,84,142,203,97,103,79,66,2,91,157,207,14,45,246,75,211,46,69,228,42,158,158,132,228,178,36,163,98,194,69,11,37,186,217,155,206,244,54,125,9,122,128,237,37,159,232,91,68,159,92,116,153,244,199,136,214,88,171,186,117,98,60,171,163,232,45,147,151,123,170,237,130,250,83,244,253,125,237,248,178,237,111,15,63,154,122,147,51,15,60,204,111,139,245,231,228,185,51,36,176,237,79,48,4,150,130,163,59,120,29,126,54,40,104,116,142,238,121,237,189,107,191,35,8,119,113,131,109,108,173,24,9,142,108,8,49,51,202,146,192,173,17,1,241,218,187,124,164,246,139,220,70,143,192,138,152,227,175,189,77,209,86,106,63,119,2,159,194,2,163,89,30,119,83,127,152,98,60,123,145,96,155,67,36,124,94,20,93,243,98,219,253,143,238,124,45,39,226,10,242,116,227,184,129,242,21,192,51,94,97,231,64,148,237,211,59,177,198,10,216,238,62,4,109,230,168,9,132,240,215,0,86,29,251,174,78,233,243,27,50,92,197,253,214,2,123,146,246,222,140,146,148,108,237,15,4,222,247,156,154,132,10,40,151,8,10,70,114,132,181,145,136,176,233,7,169,57,111,204,90,220,67,215,132,40,150,216,152,69,54,80,43,171,67,46,100,140,33,185,115,58,154,35,242,247,6,43,31,174,39,80,101,216,73,40,132,227,201,14,85,37,194,50,3,146,118,78,76,36,211,88,24,220,98,14,33,120,148,222,160,20,160,118,195,167,167,92,128,37,5,53,38,72,206,146,123,57,213,135,200,109,71,35,239,160,169,225,222,136,217,153,92,67,165,51,105,189,47,203,155,237,217,9,216,232,29,225,177,49,205,230,232,177,124,66,19,114,207,198,114,64,45,161,124,66,110,85,157,81,102,32,22,83,53,111,196,27,133,196,169,162,223,120,126,235,105,163,132,221,206,150,110,214,226,227,26,172,30,160,193,251,235,130,209,125,165,77,58,39,115,187,196,165,24,148,33,237,15,73,76,51,191,88,212,165,137,89,220,47,35,108,174,114,48,214,113,39,163,180,185,63,88,233,112,0,120,241,137,168,24,63,138,54,82,207,177,179,66,101,46,177,222,3,52,49,103,68,5,246,78,182,234,55,35,29,9,19,192,144,78,132,224,162,148,96,89,62,61,109,6,178,98,241,196,88,167,22,196,56,11,139,35,94,112,213,134,206,158,24,179,145,144,24,250,44,149,253,67,210,8,0,244,166,243,0,180,234,155,46,191,122,41,93,142,70,154,56,201,66,159,207,162,193,63,26,46,204,221,206,29,100,232,161,225,87,106,130,47,154,66,253,50,33,4,103,71,134,239,65,137,220,222,90,200,221,145,253,16,73,125,66,213,113,239,82,209,96,85,98,196,87,143,30,250,24,217,92,120,23,123,71,64,51,243,204,192,239,147,75,30,170,32,161,187,95,176,78,235,9,173,103,112,9,93,39,55,89,66,223,135,55,158,58,28,249,4,53,46,175,138,48,65,135,70,136,1,162,20,77,236,103,41,150,88,60,162,162,221,75,62,108,114,118,100,40,120,101,241,122,160,0,109,225,54,161,239,188,6,149,136,139,198,177,179,32,43,126,52,149,57,217,226,136,215,201,55,32,213,229,87,28,109,36,223,42,151,98,71,107,140,255,230,206,183,84,127,109,108,57,226,37,11,140,188,250,216,82,32,241,186,122,68,173,128,81,29,57,2,23,81,10,233,198,238,113,91,11,7,17,184,180,159,230,116,147,143,120,21,24,1,220,118,49,16,80,204,12,78,41,111,117,193,98,56,148,193,219,160,156,230,56,126,1,172,183,95,204,229,202,75,218,108,245,33,254,8,58,127,98,209,197,176,100,60,110,139,133,80,43,42,133,200,12,216,121,186,89,171,171,252,220,132,121,46,180,75,79,8,157,91,112,112,34,247,193,147,132,119,236,30,223,101,129,132,197,45,134,84,202,92,249,70,208,211,158,206,209,216,202,106,106,96,1,80,249,182,103,247,124,85,169,42,212,67,245,112,214,156,147,143,216,186,202,197,119,5,230,23,226,199,79,150,253,252,85,1,193,145,96,212,15,165,73,246,244,50,249,165,95,254,252,112,62,100,237,167,234,181,238,164,135,224,175,19,225,82,153,135,122,209,81,59,123,165,21,127,99,54,56,18,153,226,205,161,95,202,7,79,126,124,92,208,244,46,5,176,227,206,200,16,140,97,250,131,187,54,34,117,52,52,206,150,201,200,182,45,201,225,80,46,100,113,199,193,12,116,224,253,59,85,244,248,161,239,199,164,208,63,114,103,163,167,185,246,203,19,33,102,53,236,108,3,205,170,155,230,73,204,142,178,233,7,187,171,191,137,254,60,149,218,98,40,42,87,10,3,146,207,162,67,113,25,173,141,27,217,143,225,97,164,2,208,116,57,181,180,112,233,183,114,62,110,197,29,79,155,213,7,115,94,60,229,43,83,79,119,171,196,20,78,239,233,51,87,6,32,5,59,166,121,176,193,0,2,145,150,183,130,7,36,179,159,57,212,66,179,111,151,174,27,202,58,35,12,121,174,29,17,69,244,46,87,1,173,238,194,40,107,180,147,157,209,184,241,104,251,123,242,164,42,31,93,118,82,79,189,47,105,102,158,30,210,164,16,47,140,226,212,235,70,176,78,30,247,193,162,137,19,102,181,9,248,156,29,149,41,73,2,34,88,183,198,106,254,34,124,19,150,32,99,71,253,14,190,121,107,200,168,38,114,205,153,112,139,204,16,149,101,168,127,70,40,156,157,78,179,113,220,4,46,194,124,96,187,139,83,36,28,169,50,209,88,176,134,217,219,55,18,186,165,170,11,175,60,216,24,132,95,218,101,75,194,66,64,184,1,56,29,86,92,86,243,122,204,124,185,21,219,37,111,68,82,178,41,69,127,186,121,223,219,84,41,169,105,54,165,5,128,102,12,67,130,217,46,97,233,254,216,57,121,145,39,46,34,136,82,175,114,153,215,16,119,138,116,45,137,136,230,59,132,221,97,0,150,250,153,211,18,141,254,212,157,9,45,217,191,16,24,133,130,194,151,189,230,92,187,55,12,247,187,8,115,13,29,222,207,59,92,230,24,146,39,165,2,54,188,107,162,190,178,185,22,188,187,172,42,164,239,225,92,55,26,237,230,59,0,75,13,33,47,250,12,161,72,4,185,159,244,163,208,129,102,176,239,178,99,211,97,92,241,234,19,85,70,42,189,55,130,151,119,38,50,126,239,231,40,153,124,51,220,63,234,208,163,211,170,63,37,231,40,152,183,204,90,227,246,208,8,196,85,209,243,92,102,174,199,27,110,145,27,1,158,35,176,107,152,163,227,75,21,184,120,238,57,155,201,3,194,165,57,117,211,136,236,17,128,98,177,93,111,46,94,137,155,5,70,101,212,42,190,79,218,62,143,123,151,171,59,185,175,9,185,245,254,235,130,177,69,252,61,157,29,229,105,128,229,192,180,37,158,214,254,13,129,64,53,209,247,56,140,241,97,250,119,174,250,204,68,97,184,208,29,20,117,25,12,105,234,224,76,223,115,197,177,7,235,247,19,42,20,85,78,15,81,181,192,153,4,160,176,82,106,67,212,194,132,240,190,45,126,79,192,122,42,28,239,165,14,139,14,152,62,129,78,48,66,45,207,97,240,165,178,129,234,169,234,59,12,218,46,249,54,76,20,225,254,11,128,237,242,61,101,16,36,207,202,13,244,205,77,104,204,51,50,1,5,95,211,151,110,251,255,185,191,151,167,102,140,98,163,129,27,38,60,101,197,176,252,212,232,136,208,157,118,51,83,111,209,188,223,78,130,47,24,91,236,170,159,121,55,3,202,0,155,212,180,173,74,37,161,201,91,108,166,174,27,239,60,20,65,158,225,185,85,89,127,76,244,27,86,150,160,201,13,106,79,143,68,200,236,55,107,243,76,149,215,188,118,183,198,159,26,140,136,153,211,173,159,16,57,139,31,93,149,70,6,141,53,112,164,6,184,239,106,159,222,67,158,26,121,136,223,39,46,140,67,170,202,95,88,179,214,186,212,140,8,12,94,34,77,226,17,17,162,210,225,20,151,177,74,9,100,126,170,73,142,33,144,154,131,151,205,235,28,118,190,6,137,98,50,237,7,94,230,246,133,250,179,160,199,89,103,9,203,111,37,216,185,171,40,117,6,107,87,133,165,172,22,140,220,186,41,97,187,57,196,102,220,15,169,194,254,170,33,237,69,78,127,4,30,119,51,251,153,50,179,106,153,232,131,96,100,243,32,78,78,223,191,150,158,39,30,201,43,12,220,233,103,223,247,156,210,213,52,75,203,102,114,46,35,81,55,175,89,207,53,66,198,247,164,132,51,64,124,120,125,108,35,3,184,185,202,162,122,93,58,198,11,176,146,221,62,6,92,250,135,230,38,135,125,76,89,22,140,243,110,14,212,252,94,85,234,86,142,168,158,28,94,124,183,180,213,174,80,170,142,88,83,48,201,169,249,109,156,83,4,161,186,46,235,85,83,86,244,7,52,58,188,19,124,117,35,105,13,185,191,47,252,142,77,194,147,27,235,193,126,138,65,32,134,118,24,227,33,219,142,48,59,235,147,8,183,94,74,184,233,4,78,44,55,20,167,190,216,145,187,105,253,135,93,68,15,204,76,81,176,255,140,229,106,248,29,154,109,79,247,240,181,62,181,2,28,187,26,136,254,180,92,158,140,81,194,11,245,237,48,28,57,112,87,48,233,185,13,251,113,29,199,152,222,226,254,232,119,199,120,251,113,224,226,89,162,215,74,115,227,118,145,197,176,156,161,226,233,79,170,203,163,113,106,144,108,25,85,163,91,129,143,75,216,56,51,156,13,106,116,79,121,79,152,139,128,156,169,174,94,228,172,49,115,235,134,42,145,67,107,214,122,8,49,156,210,218,178,151,67,247,169,0,56,164,44,222,132,125,193,90,153,10,15,29,69,159,229,98,193,181,138,65,215,14,65,89,116,209,247,174,22,72,27,141,214,94,36,169,203,34,123,25,192,248,196,238,148,225,225,253,59,44,43,96,2,26,21,96,123,202,184,253,55,162,172,81,29,95,172,11,133,235,129,224,183,94,71,85,29,23,65,246,242,222,224,109,136,62,63,145,107,248,167,160,195,242,204,135,237,253,107,53,91,77,34,207,186,102,102,84,28,14,44,194,39,232,156,245,132,232,76,102,63,206,240,49,132,118,211,1,70,75,30,42,3,149,207,174,223,160,227,64,221,207,62,64,74,186,97,163,201,85,231,33,84,76,132,47,66,189,73,137,21,77,184,234,168,231,171,247,76,32,229,1,138,186,116,5,60,65,8,57,133,57,165,125,190,51,105,242,89,1,141,234,53,168,34,89,88,55,63,52,10,226,116,30,115,175,214,74,234,133,248,48,242,17,47,155,75,131,130,124,207,192,199,156,142,142,119,122,3,15,49,119,155,82,80,171,180,19,29,133,31,247,222,9,245,206,244,22,69,12,85,112,250,23,97,212,191,32,152,5,115,206,31,197,19,250,138,219,130,3,84,216,78,11,80,213,13,161,199,128,136,64,7,53,223,221,247,108,10,139,128,47,36,225,149,145,94,106,22,86,14,62,13,43,181,226,188,243,228,218,231,144,137,51,46,13,237,21,72,193,233,132,28,220,20,8,4,122,72,237,253,246,222,239,176,0,105,79,66,248,100,211,232,18,217,109,127,11,57,83,34,123,20,60,137,153,193,152,195,96,127,130,205,193,250,201,146,44,174,91,40,108,105,104,231,248,136,114,61,136,124,241,31,128,186,165,230,218,248,76,54,35,51,13,80,241,46,59,34,214,111,253,168,149,252,124,4,81,171,131,110,58,165,172,223,166,5,45,240,154,11,195,26,117,137,238,192,41,98,219,74,113,235,25,234,46,9,144,57,228,196,138,122,230,73,229,42,31,24,18,166,217,131,24,95,177,251,18,240,249,10,235,122,112,16,73,162,6,70,8,231,108,54,87,216,194,174,60,128,244,234,190,212,213,146,128,244,187,133,74,29,128,195,60,234,120,57,168,116,97,234,156,164,173,42,225,70,177,38,184,43,121,148,186,19,207,224,19,253,214,102,184,227,77,205,223,63,242,184,142,75,134,48,96,96,243,151,83,50,87,123,186,147,177,176,62,113,237,99,50,108,201,126,185,218,219,219,241,171,55,44,28,194,49,254,72,63,140,63,178,112,216,15,3,183,189,172,230,154,116,254,246,200,73,82,76,41,15,168,132,147,25,115,46,90,151,15,180,193,60,237,178,105,74,47,191,86,59,221,105,248,98,26,140,49,149,76,146,83,229,173,71,134,78,113,171,186,136,69,240,102,228,167,251,86,198,107,167,79,180,215,210,44,58,98,143,79,188,44,133,107,54,248,165,231,104,149,127,120,62,61,159,252,239,41,101,177,140,108,77,90,49,230,151,125,115,153,80,213,191,17,98,59,202,149,108,239,233,23,177,26,245,216,97,198,111,31,75,248,67,177,55,207,157,212,233,20,69,111,167,232,80,21,144,9,32,199,43,200,181,141,195,9,143,237,154,121,175,158,247,124,39,117,184,48,30,51,103,4,19,16,28,84,98,72,251,204,19,32,194,90,236,170,52,202,181,96,92,120,59,184,47,169,66,177,66,217,150,2,50,182,17,7,131,32,76,227,116,70,174,42,90,163,89,35,33,148,41,240,228,253,31,107,201,210,198,152,13,86,70,112,248,225,121,155,252,134,99,239,2,8,98,108,44,76,227,160,213,104,141,16,130,205,118,253,123,220,48,200,187,80,35,114,62,45,188,107,29,79,220,169,244,147,158,70,102,122,231,232,149,243,55,230,115,28,185,83,39,179,237,221,41,170,240,44,143,39,216,163,87,213,39,157,118,225,99,80,190,57,171,200,20,2,7,166,112,211,127,0,69,167,84,159,62,190,37,46,1,194,192,152,94,188,50,203,38,220,128,2,108,156,32,255,174,254,89,135,44,97,26,237,37,203,70,32,238,3,218,163,213,145,32,244,50,67,233,217,30,131,135,205,0,46,29,143,192,99,180,144,34,96,7,74,212,164,44,215,190,88,252,138,84,97,50,251,203,44,252,175,247,178,155,79,180,28,8,80,184,205,211,9,119,150,32,91,150,4,102,212,89,217,117,71,241,163,146,90,113,142,34,228,139,182,236,101,97,47,152,88,91,161,47,37,246,4,92,89,174,210,15,82,44,118,249,82,198,192,155,172,220,91,168,190,233,35,204,84,24,113,139,102,112,42,108,124,19,27,148,60,159,78,38,239,90,234,5,193,172,28,58,20,182,11,43,162,123,82,184,178,167,19,172,101,106,3,69,146,204,136,46,70,35,133,166,103,74,245,222,246,76,109,232,173,160,36,50,39,140,112,227,59,10,18,127,30,232,161,113,146,233,102,248,171,205,245,154,98,101,53,109,65,36,82,31,241,200,111,216,27,255,10,48,237,213,82,221,17,250,248,215,19,150,56,175,233,19,230,30,233,199,3,100,121,176,189,175,63,20,231,105,113,121,51,88,188,231,109,177,58,34,9,199,121,226,157,183,76,219,41,224,204,61,144,124,88,115,7,214,74,179,178,42,119,144,76,98,58,171,185,134,98,123,177,87,100,213,183,165,147,22,29,151,19,74,146,102,107,158,201,189,0,79,185,36,105,84,104,73,152,103,132,228,196,39,102,113,158,255,56,212,198,37,172,139,31,238,98,184,182,42,69,108,194,245,23,205,45,21,76,115,162,181,174,59,213,233,59,240,184,32,212,226,199,126,11,205,232,217,187,51,197,98,94,117,94,105,152,41,48,22,181,8,146,134,207,30,237,255,240,248,183,191,187,67,210,16,185,191,54,193,2,218,22,99,176,191,233,78,247,165,4,231,131,62,37,109,244,76,194,155,129,212,66,0,101,223,162,211,13,80,169,217,16,68,4,155,216,61,35,76,162,144,217,34,209,73,249,250,253,186,140,124,41,237,124,22,168,97,40,95,47,38,188,204,216,150,184,229,185,174,113,3,154,126,238,50,165,170,12,27,209,53,157,76,118,81,252,10,140,31,103,160,43,171,6,65,205,225,154,85,121,76,216,228,29,241,184,200,160,225,86,4,199,137,80,222,199,30,9,163,177,222,131,91,24,3,147,148,250,20,157,246,166,73,41,246,240,159,85,53,172,227,255,239,211,188,78,85,210,198,63,175,149,47,251,126,139,167,245,143,5,212,41,111,52,133,173,37,114,122,63,214,212,6,98,213,169,140,241,226,233,95,47,169,91,89,117,116,228,30,78,123,163,137,11,19,142,70,121,166,215,141,20,57,100,202,75,131,150,222,136,204,79,199,205,220,46,9,129,92,116,55,148,224,138,82,32,255,250,251,59,239,99,130,13,77,106,233,191,37,70,164,141,160,195,95,192,54,39,178,189,46,17,135,160,255,198,62,249,69,57,5,74,22,165,134,209,143,179,8,28,219,212,141,148,242,233,231,171,234,72,186,111,252,84,120,130,253,206,225,145,123,88,19,194,150,24,168,247,191,92,162,203,56,94,55,72,199,142,76,50,37,253,13,142,159,201,100,153,149,243,217,240,192,204,254,66,239,13,23,161,166,210,210,120,35,7,141,179,109,83,57,146,163,16,195,195,129,214,39,34,155,158,29,244,128,143,18,233,121,150,87,80,227,145,22,207,133,15,10,172,79,48,176,209,68,66,116,22,167,251,162,90,108,98,148,98,84,46,164,185,106,48,68,247,163,112,24,15,78,105,58,173,251,63,10,252,91,83,158,57,178,63,21,40,113,231,82,251,191,134,27,71,131,203,150,222,121,48,211,181,0,62,91,119,123,77,252,183,63,204,142,239,211,87,244,129,213,2,81,221,210,104,182,252,35,116,91,198,172,132,76,148,89,3,74,8,96,232,19,70,18,232,128,18,145,133,229,23,13,93,175,174,68,105,55,192,81,168,1,142,132,193,37,99,188,243,51,14,26,6,195,29,149,159,115,77,169,235,22,66,101,37,224,43,146,152,141,191,222,67,12,74,51,124,129,141,11,37,97,10,50,79,112,123,54,180,89,156,10,237,145,90,99,35,116,84,163,249,196,70,103,144,16,14,13,233,42,5,213,163,203,205,92,6,212,210,195,46,141,24,15,1,215,71,30,31,0,4,24,15,93,217,35,228,173,104,78,117,69,140,243,168,119,62,223,200,171,123,57,184,88,64,53,21,153,201,0,115,146,22,119,84,228,16,189,124,213,148,92,15,178,58,83,69,87,213,137,150,254,92,197,211,157,193,255,150,115,3,222,48,64,41,28,208,245,211,29,135,30,54,205,250,93,94,57,155,196,37,151,90,109,165,11,249,203,106,37,64,103,100,206,108,40,181,36,238,104,208,241,13,26,75,32,133,101,47,132,226,199,174,3,139,186,102,206,19,21,6,166,44,184,63,7,255,61,155,90,233,60,161,86,176,23,97,194,237,176,234,251,116,25,226,11,145,130,13,179,158,222,252,26,235,132,202,117,229,195,232,158,52,183,96,47,219,235,210,51,146,103,15,241,22,194,84,73,169,183,142,81,87,203,6,251,105,254,2,56,164,156,137,219,71,205,59,144,217,70,38,73,57,73,70,131,114,20,249,181,50,184,200,127,251,28,30,92,166,20,252,156,141,128,223,214,176,136,154,210,238,245,131,123,1,114,106,160,197,74,57,4,101,162,185,66,93,219,192,225,68,181,231,74,140,180,121,162,114,142,129,187,73,66,192,218,128,28,39,134,251,0,243,48,55,112,205,204,80,144,149,109,100,247,179,224,228,198,89,225,7,131,170,203,32,130,21,23,249,122,134,208,160,239,23,10,91,107,175,27,56,59,104,18,71,209,245,4,165,227,203,178,69,1,114,130,119,193,171,64,18,182,174,155,16,84,193,55,150,153,90,251,6,94,161,253,223,200,143,16,162,175,93,211,88,243,61,118,144,204,158,163,68,183,243,85,64,42,52,155,32,39,213,93,165,239,188,8,152,93,228,136,71,213,103,158,57,252,54,203,34,230,180,127,56,46,22,5,220,190,103,131,16,64,135,114,68,112,125,205,54,108,113,157,5,31,108,20,138,80,149,170,6,114,65,223,21,159,246,115,158,118,220,203,106,20,66,204,213,59,225,109,136,122,206,137,104,126,66,24,195,83,223,112,36,241,154,219,254,255,248,77,142,202,95,86,171,11,42,188,7,245,217,138,49,224,34,61,121,28,57,25,3,70,9,40,108,107,108,211,160,206,154,77,59,153,161,172,200,23,84,154,131,94,122,115,145,19,13,234,127,86,154,80,149,41,50,98,186,251,36,10,53,159,223,103,104,248,67,154,136,228,46,83,243,36,33,221,157,116,83,109,54,89,171,46,252,120,86,50,220,23,252,185,68,192,125,37,223,233,232,110,16,135,71,175,199,37,75,162,17,48,41,32,39,131,59,145,161,20,26,149,216,99,1,188,240,87,189,8,24,224,227,175,207,156,151,37,76,105,62,202,86,172,9,208,0,186,72,213,78,103,254,132,192,92,113,242,42,224,245,111,181,206,107,130,182,212,63,185,27,28,41,112,220,209,148,172,7,140,225,168,124,67,203,73,76,139,41,226,87,30,125,197,216,76,36,160,168,194,202,181,254,134,0,148,187,242,94,239,72,9,21,148,168,92,66,161,144,73,37,106,39,176,127,116,44,183,89,77,47,138,171,10,169,117,147,107,92,29,184,69,82,220,13,130,34,214,197,214,6,152,46,180,228,77,211,162,47,149,169,145,56,196,174,84,97,93,246,216,30,34,211,137,93,8,161,64,73,106,220,60,107,201,86,86,124,51,9,66,244,168,8,22,125,147,200,68,23,23,247,75,139,87,52,54,5,53,175,14,218,127,126,196,104,220,88,75,122,52,99,226,111,88,137,95,199,196,6,2,87,182,200,67,133,205,210,73,174,53,64,12,134,84,182,73,199,7,65,88,7,24,83,187,31,81,35,236,229,37,177,78,42,143,233,94,241,133,195,255,185,7,218,41,43,231,129,3,23,175,147,37,26,188,70,161,146,126,24,12,38,104,96,209,143,227,254,9,198,24,192,4,227,59,174,32,240,251,5,34,127,186,184,83,193,62,41,187,33,39,239,28,16,118,164,36,171,230,136,212,122,52,86,39,165,85,61,117,145,179,83,209,229,95,227,85,170,136,187,59,115,217,179,60,48,21,67,116,58,14,145,89,89,35,229,5,152,217,138,26,10,189,186,35,83,210,174,165,179,87,168,247,177,43,213,204,247,37,109,164,15,182,108,253,170,140,83,214,151,0,211,81,132,64,43,30,248,18,149,11,44,248,98,107,216,117,38,96,167,82,124,152,140,191,51,40,145,207,31,45,189,144,120,151,236,172,94,196,233,80,172,227,217,187,197,174,24,108,153,189,212,51,44,156,203,149,74,222,95,240,202,168,235,255,91,215,29,201,254,8,156,120,134,162,218,172,153,51,254,189,4,238,93,65,227,158,247,6,74,254,126,91,58,204,84,167,188,223,91,180,79,147,62,150,135,231,158,186,185,126,91,13,115,56,108,78,17,205,175,102,47,20,157,73,175,89,225,242,141,119,215,191,236,127,186,252,109,87,164,233,22,213,98,137,134,97,78,12,13,150,30,160,164,149,154,108,167,156,104,67,228,187,152,143,135,114,154,47,7,21,89,131,179,34,253,135,40,109,220,0,127,213,82,85,64,161,1,113,242,240,66,56,78,225,32,59,26,177,12,19,79,6,212,120,217,177,7,187,76,85,122,133,9,219,81,118,109,201,21,119,47,122,30,190,208,241,78,63,16,91,45,44,253,13,228,18,228,187,96,222,132,166,77,100,226,124,234,61,59,174,40,117,26,163,5,65,107,1,95,18,170,126,100,95,216,113,98,15,186,246,133,3,205,221,228,159,206,212,201,240,175,113,198,72,187,233,28,104,253,239,168,246,139,120,149,143,34,146,39,220,145,216,114,243,109,219,151,117,75,33,162,197,181,62,19,128,118,215,96,101,54,68,109,7,171,133,54,145,1,15,56,224,58,123,172,196,221,3,133,158,85,120,21,246,153,166,1,17,66,48,223,247,230,95,15,223,253,250,109,197,6,190,76,117,7,245,185,143,129,188,191,215,198,20,90,194,172,250,78,233,102,182,120,92,116,208,65,80,84,235,77,57,207,221,127,16,225,96,218,22,104,216,138,195,220,101,236,3,109,87,42,198,95,96,164,202,48,107,45,17,107,246,2,243,229,149,152,83,101,228,91,80,183,254,119,138,201,64,197,135,212,15,171,151,44,69,249,208,188,57,253,250,157,63,153,226,131,155,3,224,56,103,144,28,200,229,192,71,131,21,129,219,235,31,205,144,191,146,253,77,67,78,216,241,242,228,244,174,123,254,65,212,26,35,218,100,1,28,145,247,37,254,116,206,212,40,200,241,209,30,238,181,165,198,211,144,87,158,142,226,70,232,172,134,42,41,121,222,108,17,68,45,47,16,56,26,77,188,99,188,115,118,252,245,11,51,25,44,27,128,31,32,221,54,158,109,102,53,155,4,245,73,26,234,174,198,111,64,52,171,213,56,173,114,145,152,204,191,140,179,22,93,211,35,243,221,136,103,201,155,0,41,110,183,62,30,176,252,190,108,47,23,203,166,160,173,17,124,11,189,244,44,4,13,133,74,224,19,240,200,254,27,57,180,193,89,67,10,147,117,127,169,109,96,98,8,10,21,26,37,181,81,247,202,60,172,58,139,237,116,143,140,46,52,176,49,71,231,243,80,161,14,219,152,25,62,178,232,150,162,47,124,122,155,221,61,212,160,224,158,136,39,24,24,159,93,108,6,145,49,245,189,95,22,153,45,100,83,225,12,97,201,53,242,6,2,23,210,62,108,106,189,178,189,42,64,247,93,171,233,157,196,159,103,239,240,111,60,164,43,151,83,198,183,204,37,185,207,113,120,130,103,10,4,90,144,149,54,51,128,82,233,108,119,172,85,82,79,203,25,184,22,113,202,100,46,34,121,95,234,102,43,243,242,211,223,171,133,152,188,18,134,67,47,2,94,11,17,249,254,0,115,150,132,37,136,76,84,42,91,153,219,138,4,233,91,164,1,243,162,12,134,75,244,55,138,40,252,182,74,245,239,39,45,157,106,56,118,130,15,190,210,138,155,237,239,57,182,77,69,190,113,237,27,178,173,214,149,95,133,12,106,208,89,63,129,174,51,58,43,142,103,103,138,109,123,39,101,45,171,1,233,54,34,208,63,121,151,241,39,0,207,133,172,100,150,134,5,196,133,184,171,253,201,139,186,75,242,123,53,174,38,249,95,72,254,64,108,209,147,37,177,166,69,3,178,95,255,47,41,195,232,6,73,119,89,203,225,150,80,125,183,56,28,82,112,89,167,237,204,73,139,208,233,7,168,90,35,244,133,50,216,254,240,80,227,187,102,135,27,213,192,201,21,175,236,199,100,103,36,247,192,4,133,40,125,16,111,25,177,101,37,180,170,49,230,106,169,123,73,58,231,60,106,230,145,116,211,215,134,199,90,18,243,210,29,225,79,224,248,108,204,147,215,73,244,75,154,145,95,137,151,193,154,146,43,242,175,5,62,42,113,9,57,70,59,133,75,165,250,154,186,143,167,22,47,252,137,102,87,181,104,147,207,195,205,88,18,48,209,126,182,35,179,10,30,175,25,163,6,202,85,185,99,52,208,20,19,242,169,14,253,227,198,85,129,68,11,99,112,59,79,142,105,188,254,123,148,88,153,70,89,84,106,236,34,181,241,51,194,138,62,14,134,245,151,117,235,135,10,139,140,204,146,196,96,242,114,217,131,102,142,129,65,132,108,64,29,42,233,238,33,19,249,17,222,195,125,158,124,202,110,18,183,150,111,199,70,127,8,180,135,203,33,143,230,228,90,44,43,118,241,57,168,162,89,150,106,102,32,60,250,93,143,196,239,12,214,171,73,180,196,199,210,115,112,192,13,9,123,222,213,148,91,19,101,236,101,30,146,43,164,10,156,101,112,151,65,89,151,245,154,56,37,194,99,153,35,80,3,93,62,246,6,68,42,34,155,207,230,215,121,37,213,153,36,165,136,123,181,144,31,215,138,161,118,151,196,108,131,138,93,13,158,182,138,197,184,0,44,139,70,0,204,15,179,245,235,111,229,61,119,1,248,135,70,169,50,116,69,16,223,77,223,248,176,81,63,205,104,150,100,178,216,215,7,243,251,58,16,117,59,213,117,122,156,183,0,72,126,132,100,86,92,240,106,174,220,88,51,75,166,111,176,139,229,215,30,173,166,246,249,201,187,24,250,69,150,214,224,9,17,218,53,173,213,254,11,60,19,32,202,124,40,131,51,99,223,226,217,190,252,29,14,39,73,199,37,180,254,114,46,169,46,109,205,172,86,62,198,113,209,186,149,211,122,42,239,238,71,133,33,39,217,86,131,68,199,243,26,0,143,97,215,140,217,34,11,55,192,118,66,69,203,200,128,171,40,250,94,127,204,76,168,232,153,226,37,150,4,8,22,177,75,64,204,39,19,45,127,173,174,14,222,159,184,66,88,61,250,133,231,114,166,164,33,157,77,203,31,222,189,111,131,178,107,117,10,165,203,18,211,117,188,134,254,238,158,123,143,231,245,189,89,21,88,66,169,241,24,26,210,108,105,249,56,37,196,36,26,110,237,31,34,198,114,72,218,133,14,40,38,0,26,218,130,56,146,228,86,253,43,36,112,162,58,232,178,162,105,114,186,74,187,229,215,195,101,241,14,24,95,246,248,101,255,68,164,79,41,18,245,65,11,228,167,132,169,52,170,196,91,52,224,204,230,105,193,231,254,49,143,85,42,221,140,233,18,131,116,86,127,103,136,113,15,23,95,39,90,226,59,168,56,73,43,227,171,60,251,5,66,24,207,129,225,168,127,243,190,108,173,215,76,110,107,75,120,242,147,252,217,57,234,116,1,133,221,90,162,174,126,61,236,200,53,105,71,155,217,56,85,6,214,13,60,119,234,225,200,186,152,215,237,225,105,85,252,240,252,38,75,220,200,6,243,144,34,127,161,14,197,107,63,75,235,195,72,44,27,244,129,243,201,59,241,45,173,62,200,145,232,76,142,208,183,15,77,119,157,26,157,170,159,104,206,13,248,132,68,229,234,196,252,168,229,154,203,44,177,54,200,235,132,93,52,10,196,60,152,226,220,27,98,85,215,82,144,161,12,76,202,47,71,231,225,223,105,35,201,195,174,188,10,168,199,141,255,108,74,166,226,33,4,203,54,202,178,27,127,250,86,181,225,246,70,219,65,173,49,214,202,71,22,67,184,54,90,182,251,202,40,14,235,63,201,190,75,65,15,33,62,81,56,157,55,187,67,3,223,5,188,105,211,72,202,95,229,207,20,1,219,121,116,56,5,116,227,97,48,200,192,252,86,238,56,125,89,89,89,100,76,5,180,81,31,33,111,202,211,182,51,25,81,28,239,153,125,85,67,149,136,118,157,65,84,65,43,74,86,81,238,45,7,227,222,145,234,95,152,157,225,22,53,47,59,189,252,16,40,26,171,155,247,98,73,206,206,218,9,241,152,213,3,15,107,123,100,86,78,2,200,194,8,78,101,235,150,113,69,232,13,102,131,200,41,240,126,186,238,184,20,62,218,235,221,116,53,44,20,219,104,254,112,139,81,119,100,253,105,53,62,247,159,166,75,128,64,51,7,193,108,154,115,34,146,127,75,102,17,112,81,35,33,255,104,228,11,97,24,252,219,214,122,235,2,28,34,128,252,220,126,248,87,48,200,149,102,191,135,59,48,111,142,210,22,87,41,25,209,90,114,67,98,234,128,53,45,198,155,116,161,66,14,216,226,63,200,18,7,20,213,60,221,77,128,48,20,142,208,197,61,210,161,90,77,80,146,220,80,168,29,93,171,234,195,182,134,136,225,120,206,94,147,141,52,199,5,155,74,143,12,252,50,79,254,135,78,145,222,143,150,128,28,137,206,79,88,83,195,0,213,182,223,225,201,191,235,235,39,175,202,211,139,11,109,8,255,251,237,232,33,37,250,169,184,42,115,205,55,220,211,160,190,225,201,208,87,227,181,15,92,123,111,172,104,71,23,236,206,214,177,119,77,128,149,238,102,224,147,48,143,82,158,83,179,110,112,12,75,86,190,48,208,14,156,92,140,55,64,14,23,106,204,140,48,97,72,62,247,14,217,121,31,224,171,233,69,177,129,185,71,17,87,96,138,78,19,178,198,229,37,235,51,51,208,149,100,111,39,54,197,126,215,245,125,0,18,64,157,246,4,183,62,21,82,209,182,193,74,163,255,99,143,38,119,30,171,116,62,129,241,64,167,205,128,48,19,141,208,126,96,231,17,94,11,123,106,132,252,127,95,4,217,84,100,231,9,56,144,178,55,92,107,154,194,164,113,19,93,117,152,188,49,241,135,95,131,177,63,10,247,179,86,47,153,63,125,70,239,205,3,48,196,135,152,123,146,5,229,21,112,255,72,4,180,42,148,238,234,211,163,111,223,49,176,36,101,182,121,145,65,242,151,27,181,100,235,212,127,238,78,165,2,36,188,117,89,217,137,39,32,249,156,72,106,48,65,177,35,119,166,109,125,93,15,74,133,194,177,8,208,79,4,23,216,37,3,20,67,12,40,52,11,160,213,96,177,234,40,240,251,19,126,81,186,153,249,204,11,91,78,70,238,38,31,243,13,156,49,165,95,148,218,155,179,139,30,216,15,153,27,164,59,189,173,159,141,146,16,21,167,183,161,203,82,140,66,150,182,16,73,40,176,102,55,118,132,173,249,137,117,137,145,90,53,86,164,24,152,171,14,64,192,181,253,238,22,204,59,115,228,173,155,232,15,108,250,14,135,190,177,25,54,114,152,83,38,132,125,185,243,134,112,168,170,99,100,155,125,107,46,165,146,10,12,243,170,39,155,195,220,140,129,9,27,178,166,144,112,200,134,3,146,228,27,60,217,251,147,93,72,56,196,158,217,177,53,113,146,111,93,172,7,71,165,196,105,120,164,255,79,158,235,183,45,61,139,128,87,87,24,202,89,236,50,129,135,90,217,225,115,211,102,32,22,124,87,167,76,209,47,193,179,5,176,1,172,115,53,235,4,198,69,17,146,1,156,60,169,171,3,154,137,1,8,160,180,39,33,145,194,221,167,74,225,147,22,226,175,161,190,155,99,104,36,234,28,206,255,153,106,146,140,248,208,160,159,129,189,81,79,151,34,57,191,19,60,238,132,173,126,112,102,40,167,236,248,169,15,165,62,167,248,117,241,242,52,190,179,82,62,174,253,135,166,242,116,101,164,25,44,212,205,199,182,51,26,85,54,11,16,243,103,183,145,84,222,115,193,84,191,14,243,49,214,76,187,20,39,29,243,173,156,181,219,109,64,24,75,52,179,28,160,231,99,85,33,44,165,96,91,1,116,151,203,247,43,74,128,179,172,198,31,77,89,11,160,120,13,159,140,72,217,110,79,78,206,233,178,98,50,152,74,216,73,133,249,217,70,75,56,129,241,107,234,100,37,103,60,16,188,2,190,11,70,104,226,153,93,247,153,143,161,19,20,220,168,207,59,231,145,117,83,136,104,18,107,25,84,26,105,116,169,98,24,122,32,236,228,193,206,223,235,29,238,49,143,225,2,196,58,61,127,140,102,14,140,100,86,158,130,245,106,213,21,195,130,77,170,38,87,189,28,239,43,9,141,221,172,71,101,23,117,196,97,176,152,245,228,11,197,252,84,206,70,36,202,196,205,27,80,137,39,25,75,180,73,162,224,150,97,44,115,24,151,153,239,190,250,64,81,124,193,49,199,158,225,239,216,251,150,194,11,43,136,66,171,93,122,163,101,50,248,76,30,251,201,114,80,75,69,109,212,155,11,141,217,118,95,15,127,174,149,147,216,251,178,89,253,92,51,157,16,128,60,144,26,219,47,131,125,182,76,241,164,209,6,26,7,92,85,220,173,245,230,208,98,209,124,70,173,192,190,132,55,211,201,186,183,60,108,73,202,134,11,25,98,22,219,173,173,140,39,222,243,91,17,177,81,168,144,244,94,105,34,211,227,16,134,9,254,20,51,4,182,243,203,82,63,238,89,246,230,147,185,200,52,129,113,141,167,177,99,18,247,119,52,84,13,203,187,89,98,35,178,30,13,149,205,77,136,197,164,183,202,225,132,158,34,253,166,180,170,81,56,53,16,116,34,149,120,212,66,17,226,5,193,175,148,81,251,230,23,177,141,43,79,103,153,84,172,51,44,242,34,237,188,74,225,118,144,129,40,56,96,157,254,134,231,14,209,110,23,26,41,253,29,33,247,80,149,196,100,34,23,183,198,124,246,191,174,56,254,31,119,127,229,154,236,190,38,98,101,91,126,182,201,156,27,210,62,101,17,18,95,17,62,112,173,218,95,8,203,29,169,3,23,137,111,219,234,54,156,50,148,31,227,60,56,205,74,105,149,45,57,162,39,83,232,38,150,169,204,161,15,212,82,220,124,196,127,1,123,135,186,208,13,210,224,127,223,143,131,107,123,201,10,21,58,99,135,64,212,81,242,174,16,20,198,65,72,42,58,79,59,206,26,52,133,57,223,232,6,119,87,13,47,214,82,42,153,242,77,203,163,205,22,188,0,129,78,179,114,86,63,119,183,248,180,74,200,49,174,239,118,170,130,129,69,61,251,182,192,219,239,214,192,255,58,247,26,49,105,232,74,79,103,145,214,114,231,134,233,230,182,242,244,118,246,117,136,107,207,19,107,184,247,251,123,157,189,96,101,189,162,223,179,99,10,86,165,128,163,231,16,244,57,68,233,20,250,104,28,166,38,49,110,177,66,17,127,187,199,42,122,137,238,193,107,95,247,227,189,113,10,75,176,213,70,136,141,144,164,87,37,42,23,127,141,164,183,78,139,218,128,235,216,244,18,237,172,200,24,113,21,112,117,16,59,41,136,9,155,210,169,170,75,221,91,65,24,147,102,178,110,106,220,193,124,222,37,240,191,119,132,54,85,182,115,221,35,234,48,168,174,45,235,227,126,189,190,94,228,240,101,211,112,91,127,57,151,48,255,55,129,17,139,254,252,80,114,75,182,22,51,188,91,109,69,192,230,36,179,138,232,162,3,131,1,137,52,56,241,139,77,224,236,177,175,210,192,80,187,135,105,224,116,81,229,132,151,223,232,67,207,191,76,55,255,26,58,42,239,48,161,0,251,40,166,214,231,173,40,122,99,165,8,170,84,14,152,38,0,60,172,198,70,127,95,75,16,127,6,6,164,64,141,172,238,59,222,131,224,43,38,141,127,96,100,62,2,30,34,180,54,230,3,150,5,231,193,31,96,61,201,7,121,144,136,49,68,114,1,180,193,165,67,117,98,92,230,45,153,167,120,227,39,220,201,40,218,176,242,79,255,176,197,84,44,219,188,24,123,109,252,180,10,54,56,205,152,158,23,34,226,122,114,118,86,190,135,145,210,139,53,111,80,254,12,33,99,114,50,69,174,102,63,40,134,203,163,241,201,210,132,197,30,194,21,41,67,111,169,59,137,176,140,87,223,35,219,148,41,17,47,87,132,177,195,184,155,62,44,57,51,61,166,176,0,78,17,239,248,132,24,90,111,0,114,11,243,116,156,217,62,172,237,169,184,102,49,203,132,170,173,228,19,92,247,110,129,213,51,246,166,189,117,14,122,133,32,168,49,250,110,109,130,233,47,207,247,73,245,53,4,163,18,37,68,143,96,159,144,46,41,170,94,167,114,150,192,69,209,251,219,13,111,213,186,98,240,94,100,151,249,137,215,40,31,202,233,102,233,87,154,45,180,231,125,239,156,180,218,112,223,97,62,42,141,65,252,126,67,80,247,250,233,208,232,35,192,160,163,194,226,126,10,45,236,6,185,108,216,204,37,163,11,79,111,48,215,146,155,158,134,141,203,55,89,61,222,33,78,82,125,74,58,124,11,39,39,25,125,19,251,109,165,69,192,6,62,4,243,172,60,180,97,171,114,245,37,98,216,173,83,172,42,223,203,123,98,129,233,163,55,50,102,117,207,223,131,8,155,151,246,17,163,194,153,249,69,72,100,93,139,51,97,70,143,174,24,21,44,73,67,97,203,26,232,224,113,226,185,74,242,203,51,164,179,209,188,168,1,102,93,74,120,214,135,191,193,209,7,112,218,199,145,10,92,23,239,226,242,205,187,159,126,171,125,35,158,53,118,74,19,183,224,31,116,118,13,32,211,205,92,131,123,48,181,32,124,7,233,247,254,24,251,109,189,0,184,187,80,73,194,94,100,239,81,170,145,20,235,132,230,56,141,90,22,151,198,88,153,66,134,20,94,237,62,58,110,218,255,50,111,198,109,211,202,21,39,7,30,238,147,85,35,154,58,236,112,221,70,102,211,120,115,74,109,188,70,229,214,191,122,134,120,195,231,217,122,35,113,9,110,154,50,82,32,35,111,159,191,205,52,223,124,250,77,32,228,68,131,215,255,245,107,10,80,105,104,31,4,173,207,219,31,219,171,182,182,254,211,181,183,202,185,238,165,167,38,248,72,193,90,249,154,165,80,64,209,68,160,49,226,93,135,143,48,97,211,47,187,29,120,160,203,115,39,87,245,227,220,244,5,60,57,251,126,42,117,244,81,69,98,77,242,210,249,188,19,130,253,198,56,95,174,249,187,185,215,132,16,226,25,29,180,25,54,143,69,121,134,79,117,180,218,210,211,236,58,207,231,69,104,95,149,166,212,59,105,131,68,83,21,233,177,143,135,83,237,99,3,20,58,123,234,249,128,199,117,238,163,124,52,215,100,124,76,146,61,253,192,135,196,87,201,115,149,98,141,214,85,252,207,188,13,34,208,166,93,132,22,39,44,115,121,203,93,78,137,69,196,253,197,120,148,36,21,208,5,95,43,5,122,145,41,160,12,117,201,143,36,62,133,73,185,73,185,155,194,182,166,248,96,33,9,112,7,42,39,42,203,253,23,196,161,187,66,234,58,217,44,48,7,139,47,158,58,153,179,83,189,27,100,164,156,234,199,98,117,100,38,11,24,163,169,221,244,159,173,191,177,229,194,60,25,229,142,239,38,104,95,145,238,47,214,188,90,21,66,126,66,111,210,228,101,36,242,172,130,97,234,90,20,62,166,38,11,198,159,44,245,249,131,27,135,234,87,83,2,62,185,253,129,60,125,165,26,164,138,148,193,87,246,201,45,72,3,33,31,191,29,45,33,15,238,109,8,39,100,38,195,128,83,7,133,205,161,144,113,161,194,75,111,13,7,188,92,227,251,80,96,18,64,26,145,25,40,183,204,243,127,122,119,214,146,16,231,175,187,101,92,23,25,172,45,195,139,252,212,135,73,86,24,33,203,30,64,143,202,39,238,180,143,39,141,32,30,65,76,186,57,211,14,143,45,98,183,16,106,103,221,249,6,53,137,24,139,142,183,198,247,95,139,222,54,254,33,32,110,206,70,243,213,3,192,199,172,149,164,83,182,93,148,177,50,21,141,173,13,238,107,195,127,67,110,37,112,43,142,183,230,190,209,160,162,156,23,27,134,24,34,52,140,72,249,61,178,169,148,8,130,66,147,91,31,208,121,252,240,86,4,49,94,172,145,170,231,175,155,91,81,34,65,35,19,119,54,89,16,204,192,75,121,73,147,188,144,117,13,228,38,41,170,216,212,138,219,190,30,66,160,168,25,44,46,139,91,239,138,252,75,214,254,70,38,167,102,27,83,199,3,87,193,132,173,198,46,20,126,199,149,77,169,28,80,101,104,137,62,96,184,186,195,156,232,54,165,152,181,234,109,221,187,146,210,235,81,120,213,202,4,54,76,73,143,91,58,186,245,234,169,42,230,22,18,250,90,107,166,223,111,105,64,154,164,4,224,90,136,137,59,115,161,111,33,203,195,109,85,228,153,230,42,60,71,72,5,2,62,18,247,95,210,226,191,18,86,215,250,188,187,220,235,252,237,222,248,38,43,49,68,167,200,78,234,221,147,5,179,21,224,63,87,13,134,86,163,63,36,111,99,183,191,107,252,17,109,125,244,237,227,124,248,96,249,123,151,124,55,89,15,60,83,228,51,167,78,178,149,160,185,115,84,80,74,205,223,140,130,90,11,7,178,123,40,235,140,10,228,159,27,22,21,27,35,97,198,101,3,45,152,101,159,133,198,240,50,167,96,88,76,87,206,44,39,249,11,105,101,233,91,94,0,117,182,228,62,63,40,7,175,93,108,94,109,10,13,105,155,235,242,84,115,42,225,207,146,64,214,155,15,160,204,116,101,205,129,106,90,130,161,1,205,66,106,134,110,197,2,121,251,255,76,57,17,131,177,22,249,53,191,239,3,209,175,23,202,194,236,120,82,27,150,175,201,140,218,92,66,6,242,27,242,72,21,153,249,76,147,161,201,108,133,37,82,63,157,26,16,157,157,53,227,144,45,33,251,159,166,102,14,146,8,130,61,71,232,239,55,149,154,94,62,201,196,46,66,64,182,197,173,177,174,129,184,239,93,144,26,35,78,229,198,0,35,11,0,24,58,31,116,17,14,148,173,217,199,57,30,154,70,63,65,205,96,139,15,161,221,167,15,248,53,144,210,247,198,28,89,183,77,185,161,137,46,60,33,250,124,201,6,162,14,149,173,139,246,183,196,97,174,62,140,41,85,124,32,241,157,180,188,116,43,88,101,206,143,162,87,136,175,53,8,137,29,26,223,233,139,150,187,232,66,160,175,236,60,249,74,124,88,0,169,71,249,158,190,158,10,136,161,14,192,129,205,123,206,139,139,194,116,10,232,178,229,135,29,133,175,175,159,206,251,200,116,49,111,179,231,204,59,114,82,198,44,18,188,92,104,214,214,0,99,131,131,20,13,139,95,163,166,89,240,125,147,162,92,27,236,208,194,108,76,213,90,135,100,0,183,53,71,191,95,49,61,227,177,149,62,19,73,102,79,254,208,162,75,217,114,173,130,116,114,179,103,102,51,151,84,216,208,210,52,137,180,99,72,124,128,249,247,136,183,36,28,249,242,125,70,239,231,22,75,183,222,194,216,180,98,166,182,159,27,186,214,74,253,234,220,112,80,103,58,215,113,70,28,68,149,92,181,110,119,67,179,179,9,96,140,249,194,72,173,244,144,58,9,141,246,68,237,118,179,124,164,96,125,30,196,126,104,19,176,107,25,7,162,89,236,206,184,139,167,166,16,55,67,7,93,251,90,252,86,252,171,140,238,114,28,106,253,2,64,26,18,192,199,145,70,224,41,158,81,211,254,47,235,74,231,215,176,97,187,165,209,79,109,189,21,14,209,97,193,29,254,42,24,157,72,5,143,9,214,54,90,86,243,143,140,12,163,2,158,213,69,48,232,80,165,123,73,197,247,8,241,232,198,127,142,153,236,153,145,20,27,64,72,56,14,13,147,102,116,211,20,44,176,108,13,229,36,230,81,206,9,197,5,42,177,137,125,239,52,138,145,92,76,16,223,134,138,221,234,177,91,177,210,67,1,151,117,176,201,125,211,227,144,217,180,31,53,97,31,147,33,222,114,225,63,236,245,62,68,54,30,147,134,96,110,84,124,209,201,141,3,62,115,79,24,228,194,3,74,218,184,3,66,224,170,40,123,37,121,61,129,54,53,103,197,43,89,135,6,26,104,193,193,136,152,56,142,183,224,128,35,138,123,231,218,184,64,116,133,134,79,71,93,163,18,65,127,217,137,72,42,147,44,193,117,255,58,201,221,139,83,224,169,171,21,200,243,196,43,229,12,27,96,110,87,50,136,174,144,220,236,35,210,9,136,71,10,14,95,205,206,230,46,210,240,140,197,31,1,18,188,0,238,15,228,67,49,220,86,132,126,70,124,204,88,118,84,251,214,36,171,200,70,160,93,190,20,193,149,122,208,201,60,231,13,227,143,217,98,120,101,241,47,166,37,0,246,166,53,179,69,210,170,111,102,237,39,29,58,140,90,17,30,66,50,240,135,134,156,130,216,158,96,227,238,43,173,150,62,156,252,12,213,121,200,99,178,38,253,248,51,29,232,51,139,88,26,160,174,235,4,96,47,68,39,65,224,118,4,246,129,110,151,23,33,196,101,107,18,57,33,181,138,239,175,105,157,49,247,51,175,4,49,223,166,210,239,121,16,164,212,230,198,33,63,150,165,9,54,147,43,215,241,224,55,27,106,204,89,39,184,161,80,49,4,115,240,147,14,244,80,211,157,188,47,240,27,232,175,82,215,194,147,55,86,12,143,240,196,252,206,171,147,238,96,167,220,204,222,124,57,43,217,33,94,205,196,224,116,99,78,12,233,159,227,1,76,43,79,235,217,146,66,161,211,175,94,65,74,199,243,183,6,81,84,203,242,106,233,76,173,158,214,45,43,108,174,250,106,136,126,230,63,14,251,213,18,71,87,50,64,255,236,85,183,102,109,45,1,174,202,9,149,185,253,197,58,210,45,138,136,51,85,221,138,73,184,106,127,134,253,72,58,18,180,62,151,29,82,139,220,202,116,64,248,20,81,96,109,47,138,242,186,193,36,58,228,83,194,172,38,0,252,218,244,10,112,115,142,57,210,57,11,64,200,229,159,61,193,101,132,118,218,80,148,208,24,56,50,42,216,65,221,198,222,42,94,40,195,189,60,175,28,71,25,114,164,42,45,8,67,46,142,204,238,25,167,37,150,221,46,11,216,39,161,104,150,116,113,1,94,67,6,9,155,180,85,217,5,244,160,99,51,203,177,93,136,13,60,29,150,143,141,45,240,202,86,52,252,208,169,251,4,6,159,54,129,123,18,109,207,1,191,79,38,187,105,43,96,244,160,246,58,53,1,126,98,82,106,12,250,65,44,103,65,155,146,190,0,201,249,32,20,57,171,220,149,156,114,51,66,148,220,137,156,113,120,32,169,126,124,13,130,177,138,31,55,46,148,240,128,29,71,141,116,145,112,8,66,189,190,216,123,114,164,94,213,103,242,213,46,100,240,150,169,179,251,110,47,164,50,174,245,163,245,59,14,243,8,35,82,74,151,19,130,70,32,129,139,54,14,190,35,131,230,71,44,133,253,187,52,219,118,239,235,58,76,31,196,252,32,242,187,197,157,187,55,29,121,51,214,250,24,234,46,96,133,232,102,63,43,191,186,226,113,189,64,205,186,249,119,43,113,194,61,250,58,221,69,191,75,14,152,187,167,243,108,156,124,46,5,218,175,243,118,7,240,85,167,144,192,213,61,210,252,162,165,162,46,86,124,240,63,149,35,88,159,198,71,207,56,140,25,144,133,248,190,191,241,252,13,124,234,108,165,9,106,44,119,178,102,193,221,168,140,143,125,102,211,106,41,163,241,103,12,131,227,10,78,64,224,131,209,128,108,224,131,81,196,188,208,57,0,65,7,171,245,92,68,97,155,26,19,0,220,173,153,62,182,16,55,19,229,89,135,80,157,145,162,168,60,3,54,77,8,252,62,78,45,97,13,187,5,95,233,221,143,244,218,237,9,191,191,111,230,19,235,185,24,229,133,236,211,127,22,70,243,186,237,63,6,52,140,155,111,172,124,143,130,20,198,240,17,48,164,10,74,221,17,240,102,82,73,186,66,214,132,28,226,189,253,197,216,71,13,102,76,54,192,250,157,250,97,33,169,125,119,76,18,127,148,89,55,79,41,27,171,173,241,40,25,242,210,152,51,104,129,66,79,162,178,205,127,78,159,148,90,244,237,62,200,220,157,71,215,30,45,95,17,166,151,2,107,156,25,214,202,113,205,64,70,182,24,9,62,176,176,190,16,176,188,96,117,242,77,22,88,50,108,118,138,246,209,82,199,143,160,77,201,121,197,140,194,143,8,181,195,45,95,221,40,139,214,14,153,166,70,195,180,165,102,177,227,237,193,79,231,55,66,91,102,116,212,200,47,182,152,106,44,255,140,122,66,158,160,250,117,112,5,28,227,9,101,161,115,43,75,216,160,129,201,85,4,155,212,168,94,163,160,204,9,102,25,233,102,160,184,227,106,238,100,129,31,84,122,126,254,145,223,210,150,80,172,229,177,248,245,3,169,238,5,16,2,78,51,54,207,82,72,227,99,136,26,105,129,53,22,17,45,214,181,195,68,36,56,169,195,242,5,8,191,67,154,4,98,246,26,112,153,140,77,237,240,2,154,115,169,245,170,100,202,110,18,149,98,123,104,24,71,192,232,157,222,215,83,47,36,18,129,246,103,237,227,185,218,144,30,199,136,151,160,138,100,74,32,166,208,86,67,75,237,132,120,166,153,52,64,10,225,171,2,81,131,86,59,191,48,93,62,184,125,186,164,181,232,91,66,146,242,21,173,53,43,188,74,248,215,108,185,224,167,76,81,71,206,93,12,235,166,22,241,224,190,133,235,131,111,103,60,230,112,49,52,171,86,194,94,59,123,115,191,87,69,241,194,32,229,82,37,247,66,83,202,39,30,54,213,89,3,78,249,44,22,248,167,57,0,84,189,32,168,147,103,6,140,148,202,187,193,37,38,180,46,29,166,57,72,223,230,106,44,108,111,251,141,251,89,7,111,191,116,203,52,57,144,49,241,196,170,155,145,94,130,81,6,8,48,239,173,230,55,130,69,187,163,225,66,214,151,106,237,182,124,152,252,164,152,71,188,138,18,156,234,158,96,75,48,112,107,71,163,19,180,198,24,225,112,151,114,89,6,217,49,26,232,78,138,51,90,69,91,193,126,130,54,20,217,158,121,249,61,85,203,2,97,83,109,237,170,254,0,91,197,122,244,126,45,233,234,109,127,179,19,219,93,31,65,76,94,19,176,192,62,20,225,161,144,181,212,117,211,254,177,20,119,165,4,191,21,105,172,116,103,36,198,101,166,240,111,212,21,87,239,249,26,153,242,52,76,142,34,251,237,81,66,187,57,122,29,236,37,110,21,148,230,218,247,104,63,1,234,5,69,199,73,134,157,172,42,231,147,224,75,141,129,211,82,4,89,195,246,70,171,181,93,183,55,108,159,166,33,84,4,185,111,204,210,203,121,247,47,11,38,196,128,175,73,224,158,13,7,251,219,162,20,164,80,64,199,241,117,6,96,69,101,173,208,37,165,211,107,165,193,43,31,159,138,214,247,2,33,12,191,208,158,105,240,17,229,141,41,237,45,38,45,115,88,232,28,191,188,150,228,13,47,17,235,94,149,41,105,96,203,124,26,222,106,9,189,50,92,15,120,136,57,57,255,99,51,112,155,217,186,209,181,137,48,198,43,39,230,86,230,26,217,240,223,93,238,195,80,220,79,238,160,255,161,52,146,25,191,179,0,106,203,39,179,207,46,133,153,151,239,88,57,122,189,135,89,178,115,230,216,10,114,143,251,93,168,61,169,202,150,202,196,237,75,49,182,183,125,110,19,34,1,136,14,89,81,155,227,118,201,69,250,152,109,216,132,250,88,147,48,2,191,100,195,211,13,126,162,119,72,133,229,123,207,22,23,212,210,63,155,150,227,57,166,222,129,67,70,42,85,154,245,247,41,193,230,95,156,113,40,103,226,86,19,6,181,49,124,103,224,189,223,33,119,236,24,20,229,68,141,154,5,89,177,163,212,125,152,33,38,48,226,24,141,151,158,51,86,207,22,139,80,172,113,125,82,37,229,71,24,29,22,151,195,95,177,29,49,74,158,121,217,68,52,92,168,158,88,196,251,22,3,155,79,122,252,156,221,200,181,70,100,216,71,156,175,156,86,2,231,130,108,43,211,119,75,181,114,163,95,222,24,246,255,186,183,186,101,37,137,223,53,194,47,117,58,55,235,209,179,14,167,242,26,134,221,36,193,38,118,184,207,96,67,32,145,250,154,128,94,25,66,185,48,57,213,130,222,58,197,173,252,78,101,199,141,206,155,94,81,157,155,216,239,200,168,141,203,59,210,55,17,55,170,5,110,70,51,20,19,17,219,187,198,121,220,48,135,101,52,185,215,244,4,37,229,220,138,211,126,144,244,210,14,194,134,9,176,26,52,128,5,94,173,63,199,171,196,37,142,16,185,13,98,224,38,105,153,24,182,124,179,35,177,69,226,224,127,75,236,2,98,7,44,185,3,14,107,156,129,152,51,36,29,203,211,203,108,162,74,162,216,89,12,128,9,112,14,157,147,3,227,248,177,51,228,239,231,213,231,254,82,42,244,137,106,99,170,156,192,66,71,139,213,5,156,125,195,124,229,130,190,205,89,225,241,254,176,95,30,219,40,248,129,218,116,222,75,183,241,249,60,88,178,52,92,157,156,113,232,162,36,107,47,55,17,155,162,70,224,125,82,84,211,203,26,49,246,193,94,207,161,122,216,126,138,16,206,87,28,38,45,30,196,186,30,68,206,95,156,208,218,236,93,107,125,217,121,46,223,4,69,183,46,238,206,71,72,167,159,167,48,118,25,0,159,147,140,99,166,172,4,113,21,161,52,102,54,219,194,90,106,50,6,156,202,21,86,112,33,45,53,6,124,162,83,226,178,246,1,165,167,177,190,237,128,219,79,114,30,187,31,146,10,157,251,80,124,108,191,233,91,104,68,35,156,13,54,123,191,37,77,245,82,222,206,8,246,133,27,217,87,116,7,145,65,128,81,142,250,19,137,207,10,217,88,150,119,183,30,231,123,9,189,145,113,150,247,204,148,101,142,228,144,127,101,122,157,153,221,45,112,44,139,13,223,94,18,221,245,14,185,252,132,117,15,173,122,121,1,251,109,2,107,25,97,29,180,199,11,124,161,138,37,92,119,254,245,118,34,128,28,100,200,80,5,114,99,208,232,126,215,247,226,193,129,111,229,166,12,107,30,67,118,84,156,100,158,204,44,28,118,134,227,10,22,153,126,77,13,134,137,18,167,115,62,98,60,182,179,66,109,93,146,39,135,247,137,193,45,175,156,83,87,217,63,250,57,154,128,151,152,45,35,43,126,198,229,219,126,200,145,4,236,251,153,196,162,89,73,134,96,119,107,128,190,147,228,64,73,220,100,124,73,203,91,213,77,92,68,50,107,69,237,110,138,228,193,175,162,213,78,39,118,105,39,11,196,157,25,195,35,53,250,121,123,219,197,179,143,206,30,210,251,106,231,243,37,84,55,23,7,30,84,11,121,92,53,9,191,28,49,57,237,112,78,183,12,215,243,99,159,238,14,246,197,136,207,69,0,120,99,89,37,184,54,94,128,204,224,174,118,50,226,59,151,162,115,167,144,223,213,199,4,87,55,193,10,212,169,238,242,254,70,213,252,87,32,245,18,157,79,122,232,143,103,31,93,140,93,243,91,156,91,223,136,12,68,98,200,179,170,185,195,112,27,104,3,205,165,28,186,174,118,57,189,119,144,158,95,158,164,143,139,58,87,217,43,22,68,43,126,240,70,94,163,225,233,248,227,168,70,198,16,51,205,239,192,4,124,244,190,80,130,188,253,65,63,201,98,243,142,139,238,115,52,164,188,234,11,203,33,66,111,40,174,113,78,139,135,102,209,122,166,53,10,2,10,140,215,139,223,100,11,23,208,126,65,214,52,37,98,93,37,250,159,75,209,155,248,86,107,5,114,199,254,105,179,240,132,18,228,65,136,188,180,168,141,149,43,234,13,114,25,92,32,8,212,172,186,194,234,241,77,20,142,76,140,225,110,176,248,93,52,69,8,47,143,25,99,166,56,37,228,218,183,234,205,236,237,168,228,136,179,145,123,254,230,182,37,220,223,96,199,45,24,147,73,86,254,47,90,124,89,129,192,199,167,216,217,62,148,163,46,107,74,67,155,206,30,163,44,42,238,69,77,5,86,126,151,131,136,59,134,63,72,23,50,35,228,75,48,172,147,4,200,35,217,142,56,51,159,145,237,51,218,27,192,43,193,90,63,194,218,149,77,69,58,68,24,177,235,144,245,52,41,241,21,63,202,204,123,60,245,245,147,59,230,53,58,179,177,6,108,72,142,101,202,171,147,1,238,27,183,145,157,7,29,13,111,137,129,183,185,196,139,126,204,48,220,237,170,227,65,153,226,170,245,241,69,250,74,235,39,129,115,94,113,165,212,140,219,239,255,30,2,150,71,167,222,250,123,230,253,102,110,67,175,23,73,166,0,144,47,148,163,151,221,23,81,24,247,230,191,244,11,1,206,112,51,40,182,33,40,163,61,107,169,167,6,202,202,72,255,23,102,172,225,38,148,226,88,109,43,255,21,145,157,184,0,241,95,26,253,89,42,53,13,149,184,8,74,173,119,80,63,39,122,131,186,46,224,96,135,125,146,230,186,215,105,91,230,163,169,125,167,150,59,214,137,125,94,22,30,51,110,143,175,201,170,44,185,136,253,28,105,89,77,41,65,135,12,60,237,170,191,75,127,88,149,34,205,123,6,139,121,217,249,166,254,165,197,104,144,84,48,58,172,21,122,128,85,199,148,36,114,91,239,123,1,206,8,169,49,206,39,142,97,137,189,224,169,198,119,13,171,201,140,49,157,103,118,88,94,210,27,126,242,245,68,55,25,204,114,244,247,64,29,145,137,154,56,172,22,62,19,227,79,143,90,5,12,201,194,154,224,71,103,79,31,119,20,146,114,219,19,44,92,21,211,69,49,20,95,47,183,25,195,60,209,50,238,182,244,59,9,94,112,27,36,210,214,7,152,57,84,87,219,76,117,252,173,214,2,188,162,120,141,43,194,108,127,121,25,148,205,129,10,46,39,41,144,243,52,218,147,187,37,188,247,50,228,177,63,51,214,17,10,240,24,244,129,34,87,146,124,5,230,163,171,120,234,22,101,103,156,68,245,144,114,132,132,244,163,47,127,235,219,88,243,187,140,196,153,78,126,139,116,152,107,147,27,119,0,2,213,231,59,70,73,214,67,31,130,51,71,155,189,211,225,165,140,83,24,36,56,202,105,50,33,140,155,216,216,209,252,54,156,254,20,81,120,206,235,241,53,194,44,177,128,30,239,26,95,124,88,90,21,132,123,188,158,141,127,241,223,95,178,108,21,221,145,222,26,192,180,84,129,78,175,117,146,57,215,116,10,13,53,12,252,227,64,32,115,213,68,143,238,155,225,101,184,132,28,92,127,89,232,1,139,160,185,99,115,92,29,188,211,254,180,85,121,47,205,53,199,122,73,153,119,188,74,163,229,129,90,48,50,178,91,189,168,116,38,32,114,55,89,132,116,208,124,128,113,113,16,206,199,26,163,212,71,1,250,155,96,53,100,44,246,31,136,208,243,220,60,176,23,103,88,245,48,51,59,225,235,226,76,182,53,49,135,126,117,23,4,0,51,62,11,237,65,252,21,246,193,84,14,85,217,111,240,108,226,134,59,194,210,198,214,9,245,99,101,81,3,89,134,225,173,80,61,204,115,250,25,191,22,137,42,177,155,159,237,248,200,39,189,1,66,189,88,8,198,57,47,194,59,150,74,50,244,192,145,124,139,137,9,88,183,226,179,162,219,55,201,222,186,109,36,242,146,104,134,170,9,120,67,123,240,251,118,184,113,206,203,242,204,29,95,103,160,139,24,229,246,174,44,232,1,92,51,119,121,192,74,200,193,169,150,115,168,56,37,31,105,175,166,10,183,252,135,115,233,34,0,229,124,183,246,177,143,42,237,125,2,142,154,240,49,228,213,15,77,123,202,79,84,0,147,189,200,161,106,243,41,87,86,158,216,240,246,100,112,9,91,213,220,206,108,190,57,220,218,99,189,47,194,120,28,127,254,169,178,91,243,109,75,134,210,210,244,242,159,54,217,20,133,68,233,153,234,101,91,233,30,96,171,224,92,91,176,236,182,188,20,131,21,122,84,104,171,14,236,252,249,75,212,235,191,95,11,62,141,94,241,165,26,219,173,197,153,214,168,223,240,94,213,113,148,95,22,212,203,134,117,232,60,147,51,11,201,54,4,81,122,170,58,150,209,147,128,196,78,68,78,148,160,114,198,127,162,120,180,68,133,22,76,101,119,11,93,246,9,232,183,127,140,173,92,221,236,51,178,45,217,246,70,118,91,129,102,24,199,252,7,6,116,81,43,240,49,115,77,164,134,23,10,184,92,26,223,238,174,254,108,5,221,29,205,3,38,30,51,143,196,202,21,102,228,51,105,45,191,54,175,140,175,135,132,56,183,9,116,20,68,132,18,220,233,176,239,82,87,160,87,75,33,255,121,193,156,78,230,23,79,64,52,198,99,148,130,106,107,8,203,26,34,248,194,178,123,242,238,250,69,219,168,219,185,118,64,221,220,7,62,58,172,34,161,85,252,155,52,152,60,87,103,183,167,226,234,225,170,247,90,38,143,81,89,210,156,20,60,194,148,113,179,171,5,77,184,78,26,208,131,200,86,18,46,116,74,134,61,119,29,194,3,117,40,80,168,90,103,191,42,184,95,218,91,28,155,54,146,65,95,188,105,77,14,205,75,249,117,46,221,98,224,169,93,190,83,43,182,146,208,7,135,154,99,250,12,2,189,246,105,220,172,175,69,1,167,218,186,57,136,247,112,149,221,32,11,202,229,160,52,60,200,208,193,198,75,246,250,53,55,150,176,139,93,85,222,206,205,111,9,73,162,186,211,69,140,188,136,164,203,223,18,225,119,181,234,138,60,23,112,75,105,15,203,7,125,177,246,31,45,74,151,48,22,139,175,136,183,250,161,111,94,119,158,113,175,140,79,29,122,65,55,233,80,125,200,31,209,18,35,82,3,116,190,125,208,46,253,125,100,73,160,238,5,244,38,184,200,7,167,119,122,165,28,250,26,52,110,188,151,63,208,63,248,94,165,164,111,163,146,32,37,5,60,85,192,27,61,24,60,161,222,0,4,254,155,189,84,196,0,157,35,12,162,103,138,192,135,38,45,40,41,69,63,30,177,222,41,253,200,54,63,230,237,20,103,172,23,99,192,215,2,181,198,52,12,1,157,162,169,147,206,27,237,188,158,40,214,164,233,240,100,201,245,24,178,38,205,66,140,166,43,132,117,143,233,22,167,190,202,18,188,127,240,184,49,182,87,84,214,121,140,169,20,29,122,133,69,18,168,61,132,146,108,35,131,109,86,101,183,150,34,77,90,194,24,46,232,28,48,183,206,47,100,61,163,165,74,17,92,27,210,106,16,222,186,117,41,103,197,144,3,27,9,248,132,189,88,83,122,219,49,116,2,50,30,40,205,76,130,35,126,83,228,228,138,171,171,135,39,196,227,87,106,235,241,239,86,179,253,11,23,99,7,66,41,158,178,157,76,234,6,5,214,254,184,155,181,84,197,165,122,251,119,249,236,166,219,144,14,253,20,200,71,185,128,249,58,15,196,101,206,51,124,190,50,159,255,10,172,123,168,253,230,89,10,236,71,194,62,129,71,92,165,85,0,198,135,157,141,191,50,13,140,37,124,110,249,46,46,25,251,68,145,8,18,120,51,137,142,119,244,148,246,141,26,132,163,135,241,35,159,49,77,209,163,230,111,6,242,146,195,49,170,2,124,194,17,165,42,155,254,34,50,37,48,67,234,117,90,102,69,129,61,195,172,78,87,34,46,79,146,168,210,166,122,231,226,222,204,251,20,75,223,196,242,130,34,225,110,75,207,175,78,24,239,45,171,104,198,59,0,19,49,11,243,112,43,250,158,62,80,155,237,46,52,188,185,245,171,68,197,202,251,110,93,211,94,67,191,87,157,87,233,13,61,47,52,206,80,194,167,66,67,198,170,244,247,174,171,50,79,255,184,161,14,254,202,162,162,254,221,148,221,251,90,102,154,71,98,61,150,1,32,250,227,57,240,168,21,174,152,107,235,75,2,198,35,117,161,148,210,231,214,184,87,241,102,16,184,144,221,165,158,108,17,177,46,228,156,159,149,123,171,239,250,40,10,62,189,159,144,124,7,64,76,122,161,214,158,46,206,191,99,142,189,68,40,168,172,65,88,130,102,169,121,107,188,201,117,35,139,212,14,176,77,110,172,197,14,238,254,189,108,234,224,228,68,226,121,230,183,185,224,25,14,142,86,3,2,21,133,116,109,24,125,214,126,192,236,107,42,30,208,247,43,102,62,205,11,213,177,80,163,92,245,82,101,244,192,151,191,169,102,204,190,167,232,66,226,12,115,238,131,188,181,235,30,55,68,17,186,125,64,121,44,39,147,240,53,20,40,101,224,109,239,226,32,115,253,200,113,202,118,207,81,168,138,146,224,129,38,168,181,120,87,225,170,24,6,223,254,59,48,103,66,191,112,18,100,232,149,121,191,132,39,231,12,223,111,202,150,238,150,76,143,41,37,183,222,8,16,24,33,99,101,144,218,10,68,70,133,97,95,109,42,67,13,102,0,93,189,206,41,149,160,206,101,195,209,76,22,231,109,76,142,113,78,222,63,202,227,65,140,154,29,47,96,41,58,77,137,107,249,152,7,126,53,105,31,221,134,107,150,14,18,108,110,152,91,57,88,146,199,220,12,79,116,220,134,180,176,224,71,97,52,154,76,94,230,58,14,196,154,89,27,162,219,96,227,91,143,175,92,36,179,222,30,59,163,32,250,146,96,163,83,134,33,18,27,99,127,113,171,35,52,143,96,219,71,71,254,216,30,244,75,88,241,242,50,213,1,83,56,154,152,153,219,130,166,175,82,10,125,111,96,137,38,46,205,11,85,195,29,184,117,250,218,58,49,10,40,30,139,211,81,157,249,51,33,100,201,34,96,197,189,206,48,180,50,2,111,154,109,10,90,116,189,224,85,45,153,10,96,210,142,179,131,174,213,131,9,90,194,235,113,201,152,223,253,134,198,136,215,196,121,114,145,127,197,63,226,22,10,124,149,177,37,12,217,218,113,9,235,142,49,103,237,98,82,140,8,127,97,56,61,78,76,142,106,216,56,78,153,139,60,223,243,28,34,38,199,137,132,50,118,151,58,141,192,20,249,138,53,114,177,45,146,78,147,234,123,244,61,157,119,7,88,41,82,17,102,213,59,93,79,45,40,157,139,219,81,12,134,18,77,1,101,45,228,155,66,227,243,242,202,71,136,205,94,102,239,237,253,62,207,30,222,178,58,135,219,74,150,232,27,209,251,37,198,33,83,209,39,249,183,21,38,213,39,143,198,149,91,161,250,193,43,45,233,70,234,118,173,231,180,151,157,138,7,167,198,81,194,51,164,200,83,56,176,121,167,225,108,50,245,125,137,148,215,111,59,19,64,109,5,114,176,218,137,186,235,94,254,156,96,194,168,34,159,84,171,68,70,215,155,148,244,240,11,54,128,75,56,161,201,231,65,137,194,113,32,89,201,13,141,169,131,94,198,168,132,135,101,50,165,181,8,159,184,15,19,74,16,105,43,25,168,214,106,76,164,64,91,12,74,22,16,124,27,121,145,188,125,255,96,131,33,245,145,180,29,62,194,137,30,62,243,129,77,13,158,163,117,162,206,61,236,135,244,220,166,174,217,73,139,0,254,201,26,125,241,33,68,187,155,235,119,25,72,196,151,8,255,8,84,250,43,102,204,134,121,186,123,144,48,2,235,7,229,41,190,150,181,169,203,226,194,118,180,182,162,220,222,14,52,114,197,229,86,207,201,148,241,246,69,68,231,8,57,6,21,171,44,83,134,151,83,25,48,142,91,248,21,21,213,9,104,208,21,12,133,100,100,144,124,237,193,56,180,34,39,246,232,53,212,121,61,127,221,103,74,114,150,223,11,229,210,6,76,40,95,192,199,167,100,100,64,117,44,73,13,187,42,241,47,212,35,164,55,64,85,88,41,102,68,165,110,72,100,66,38,33,14,166,233,157,80,35,137,1,69,63,111,169,42,19,65,190,106,104,216,90,154,147,190,183,207,177,145,142,190,213,148,10,228,251,99,58,72,148,192,227,20,1,79,110,181,47,89,218,133,7,75,111,229,49,60,97,179,158,28,51,110,139,80,56,147,33,182,227,153,92,32,1,241,44,181,143,24,16,252,26,129,134,63,65,186,1,160,90,254,21,88,43,220,101,222,156,214,211,98,172,42,254,193,103,147,61,229,181,85,228,223,127,163,201,157,106,97,82,251,201,89,32,245,234,92,103,151,70,111,44,210,74,166,88,95,204,82,185,9,218,72,146,27,181,139,97,122,22,228,206,84,237,87,140,101,100,110,216,186,226,110,186,109,140,162,59,52,3,26,96,176,41,84,66,47,216,100,110,106,2,55,106,165,232,43,156,42,193,122,42,74,224,96,101,41,240,141,4,88,29,113,31,121,80,196,152,15,234,154,70,129,228,97,137,99,89,108,64,143,32,111,199,220,209,192,20,24,80,192,202,191,169,156,133,210,36,179,17,149,67,213,52,180,176,134,253,181,179,174,87,217,236,254,162,137,201,192,88,23,89,195,231,73,182,226,224,149,99,172,221,135,5,241,132,86,236,118,69,50,108,27,103,65,17,127,75,11,160,71,85,227,148,153,62,103,83,250,192,254,215,123,252,157,8,112,132,210,193,21,244,168,131,44,69,226,190,243,10,225,163,84,190,118,32,19,193,234,220,32,188,74,90,197,143,70,191,99,113,186,143,49,131,109,253,62,234,221,183,103,238,89,65,67,11,230,9,222,24,95,129,14,228,125,126,166,49,29,239,36,39,124,130,203,200,105,29,231,182,43,1,179,193,103,230,251,205,22,182,65,191,137,110,165,113,180,60,209,87,212,7,69,241,130,157,125,59,225,89,244,120,134,142,170,92,19,65,251,87,163,83,32,185,163,202,187,191,34,192,183,186,236,30,222,225,180,237,142,162,77,93,190,100,248,70,134,164,253,105,255,142,189,83,50,161,225,223,241,240,252,170,90,122,221,22,108,187,81,31,252,76,218,238,217,175,90,110,37,190,8,65,147,181,160,202,39,24,230,218,92,233,102,123,98,72,215,163,152,111,198,25,215,60,213,1,254,4,168,45,13,40,238,142,158,60,70,241,144,183,215,236,146,149,13,234,215,133,3,112,135,7,8,40,195,214,105,244,172,246,200,198,238,153,112,100,59,137,18,122,9,204,17,41,181,111,41,61,21,160,16,170,194,218,178,62,88,92,199,233,200,24,70,246,142,224,164,200,210,237,216,75,100,45,115,160,117,92,38,226,170,215,156,203,215,210,248,231,199,216,248,161,125,167,132,103,180,186,9,249,4,154,16,237,107,80,28,27,235,150,39,210,201,153,66,17,97,165,29,15,167,130,23,77,17,106,160,90,248,47,219,164,20,127,81,248,1,36,254,22,50,208,65,145,45,220,160,93,16,45,62,229,177,187,144,167,142,26,248,232,6,191,77,59,136,49,2,33,116,66,65,146,218,44,111,73,2,222,99,111,24,180,41,67,103,39,216,168,240,207,142,34,241,86,17,173,37,58,64,186,213,98,181,151,159,141,26,22,31,45,92,64,9,10,26,76,181,236,145,18,8,30,219,158,183,71,138,134,56,65,70,34,140,141,13,54,245,29,155,227,200,183,113,40,113,203,86,214,2,162,90,237,5,247,2,186,149,205,73,75,106,255,178,8,39,126,21,96,43,117,216,10,81,98,244,208,25,252,177,189,21,50,204,13,115,42,29,115,2,10,234,207,168,29,131,228,241,82,183,158,85,177,161,142,249,81,208,74,7,73,61,160,142,153,121,63,78,230,152,77,38,100,58,119,15,102,23,145,201,189,165,77,147,230,208,2,84,68,22,86,13,32,68,58,88,73,8,48,139,117,27,222,40,32,182,33,168,89,188,113,162,162,146,225,102,118,158,53,22,82,149,184,240,92,212,243,40,50,170,149,147,223,104,185,45,162,20,59,162,173,157,5,224,233,8,159,219,28,215,102,178,59,121,254,199,162,199,99,2,69,53,6,16,218,9,6,241,44,220,188,45,208,250,244,235,250,209,70,110,222,198,183,219,47,135,143,170,11,226,178,201,194,8,0,115,63,105,158,9,227,172,16,176,218,211,18,70,236,5,109,35,119,143,218,145,213,190,153,247,240,232,191,61,9,58,130,175,235,45,122,195,207,43,194,102,133,91,46,230,18,78,212,122,114,168,4,94,120,96,72,18,12,142,191,141,105,202,78,241,114,85,34,238,84,11,10,254,50,188,122,76,216,117,121,110,3,95,91,62,253,60,174,139,195,120,183,220,61,229,75,22,220,190,134,216,68,90,111,184,152,40,130,43,39,76,144,94,215,83,252,62,127,27,6,175,158,50,87,41,85,95,32,24,14,193,22,92,54,156,254,77,61,50,7,243,25,48,156,89,56,17,33,107,135,110,160,52,80,216,55,217,98,40,102,1,34,70,233,200,205,172,234,156,17,180,123,113,143,67,81,224,51,149,12,213,251,3,2,63,30,249,181,254,120,160,155,133,96,137,181,35,5,182,121,214,39,128,129,237,203,19,137,24,93,101,255,228,209,34,58,241,253,187,131,60,8,241,178,36,11,26,109,21,150,214,31,242,19,60,118,147,158,111,23,164,168,73,67,92,231,211,6,86,222,242,248,107,142,231,119,143,1,168,27,187,91,70,38,230,162,216,232,152,83,71,41,183,182,189,94,221,128,7,217,182,42,49,232,20,23,3,87,95,213,181,137,117,14,161,52,243,122,183,193,90,134,182,58,222,179,72,150,241,129,197,216,227,156,20,75,90,202,71,128,15,137,242,183,117,188,168,252,39,243,76,167,222,12,190,250,197,206,164,145,191,47,206,24,20,40,253,36,4,220,72,143,199,19,105,30,48,219,215,196,37,15,182,38,220,134,239,35,187,29,230,68,215,139,220,215,90,25,184,246,196,149,239,249,142,248,63,141,205,161,28,87,142,170,237,214,67,142,251,97,163,163,242,208,139,28,201,5,249,160,111,232,64,231,207,201,197,196,206,92,127,71,17,57,48,200,25,226,176,113,210,162,108,233,45,224,15,40,196,161,187,228,55,88,74,235,30,68,12,209,70,87,243,159,85,208,70,192,75,111,14,15,239,6,234,134,248,30,113,51,255,128,43,104,82,6,158,241,74,19,174,199,229,132,238,6,70,145,96,242,208,185,17,12,251,210,13,113,233,186,188,29,9,195,244,71,62,26,195,82,44,209,10,230,93,188,92,234,241,145,115,67,77,67,44,210,249,228,5,84,43,160,77,103,214,59,87,195,200,20,129,254,173,229,229,37,115,254,49,72,119,145,188,255,12,95,191,110,239,124,12,213,234,217,4,211,133,39,184,242,103,223,13,5,50,56,74,214,135,66,130,62,223,167,91,175,30,40,134,82,42,167,175,169,33,40,205,88,123,104,96,189,142,226,130,73,0,60,121,128,225,203,146,1,170,4,93,235,72,243,97,77,129,92,246,173,53,161,138,204,83,70,234,80,223,20,176,62,149,150,127,141,182,196,163,80,117,13,31,248,64,166,35,112,96,44,221,70,128,124,229,74,60,65,83,15,20,135,165,184,82,153,163,153,145,137,168,21,68,140,120,76,239,1,57,32,133,38,158,157,114,92,79,139,129,100,233,109,73,206,6,164,101,18,250,41,214,14,185,87,241,153,142,116,3,55,77,138,149,123,112,38,59,191,132,156,136,205,108,175,236,117,66,107,36,241,192,147,149,227,116,253,26,209,34,134,94,214,68,212,25,142,117,207,151,32,13,101,187,154,38,54,165,162,58,254,142,54,86,89,13,232,46,36,31,67,169,250,183,168,205,55,163,165,77,37,211,28,12,51,80,99,47,117,190,69,215,83,246,24,48,152,252,50,167,183,242,94,21,63,211,171,23,199,4,160,172,57,57,92,128,50,52,174,87,77,255,17,221,149,165,195,162,43,38,226,27,221,101,124,188,82,226,222,49,132,246,31,27,81,255,205,69,176,163,195,253,83,47,80,99,157,132,223,160,92,39,120,73,149,51,171,255,67,218,107,160,220,58,236,28,119,180,1,82,24,146,160,44,200,70,141,109,254,12,126,229,95,99,96,3,216,221,136,205,113,142,122,186,243,183,255,22,253,97,176,39,222,179,209,180,233,133,72,37,54,158,28,65,95,13,1,59,153,193,87,230,128,104,160,201,205,2,196,6,125,232,155,188,65,83,240,126,145,178,63,143,0,240,193,78,184,2,226,82,240,49,22,50,167,206,196,168,121,68,212,156,249,154,95,24,93,83,113,168,33,14,246,208,135,139,78,122,101,123,8,177,97,182,122,128,106,140,8,192,100,143,88,196,50,29,207,215,143,65,120,133,133,118,94,128,12,106,130,195,165,203,112,192,173,166,222,59,23,34,6,82,131,16,84,214,205,87,208,140,201,182,166,221,131,122,181,85,150,65,139,133,103,23,179,159,231,7,175,204,95,130,131,126,45,155,135,76,69,145,54,197,251,173,9,206,46,189,122,101,178,24,17,52,231,121,151,60,255,66,47,5,0,134,235,185,232,129,137,35,158,3,110,230,211,73,61,209,224,71,153,55,248,61,100,233,170,140,66,27,177,253,40,208,209,143,4,27,108,105,166,136,60,8,218,119,168,182,107,8,119,5,118,31,219,43,94,70,182,91,68,254,135,245,212,250,26,105,156,109,180,133,177,249,140,89,130,79,55,31,123,18,154,42,191,139,9,240,237,151,107,173,188,134,243,132,118,79,249,197,52,29,174,60,127,48,203,213,101,118,178,117,92,200,49,217,119,172,213,150,231,103,134,168,200,159,174,105,85,8,72,53,243,196,179,102,171,173,207,190,134,186,250,180,231,155,193,203,81,248,175,8,196,145,73,186,178,63,177,60,238,12,42,169,79,173,245,76,171,131,19,102,237,156,201,116,42,209,167,158,198,227,114,197,227,182,212,229,151,110,140,149,239,82,124,137,145,167,26,54,159,102,237,132,139,121,181,115,78,145,179,231,40,243,114,107,190,126,230,152,86,21,43,130,126,87,172,107,120,215,174,119,95,238,138,107,162,109,30,0,156,48,191,59,137,171,39,151,249,219,16,202,29,186,7,225,198,202,213,119,26,30,46,66,61,154,127,212,160,121,30,139,137,77,16,197,1,225,23,181,190,52,124,88,224,250,45,111,131,115,99,26,188,227,244,207,13,101,230,130,96,187,90,109,141,203,246,150,213,238,2,180,162,199,113,129,255,97,7,65,101,37,145,166,70,193,39,68,86,45,6,162,80,189,182,147,237,204,108,173,114,12,139,6,79,110,178,50,39,17,113,41,178,217,61,88,132,240,93,181,152,170,7,71,170,146,115,177,209,87,215,16,157,38,76,45,46,220,16,103,58,125,32,153,241,187,154,232,13,56,84,165,56,94,8,6,118,36,14,96,65,93,68,50,208,97,85,185,103,1,161,83,67,194,38,128,76,181,204,102,151,40,72,219,119,58,243,206,0,99,50,157,241,110,31,75,39,89,181,28,80,34,47,54,40,145,0,60,100,212,148,16,35,19,189,130,103,237,1,19,109,241,72,134,148,103,72,23,209,106,186,211,41,196,18,76,23,75,122,68,251,50,11,252,232,52,72,57,5,52,226,217,252,184,71,71,112,106,214,93,60,250,235,235,115,148,64,183,222,82,158,135,135,145,153,54,138,126,116,216,66,235,51,100,7,1,111,11,231,57,153,174,195,76,173,195,2,137,227,217,61,109,233,31,68,5,179,235,72,80,16,191,118,37,76,119,131,246,39,251,58,127,172,229,32,135,167,216,216,39,54,7,180,45,236,44,47,186,218,5,45,145,201,222,24,126,214,198,237,218,245,74,159,119,201,233,27,224,213,175,46,43,252,104,209,254,53,126,25,166,190,157,66,64,23,226,4,74,69,28,42,238,195,233,33,1,64,116,16,110,32,81,97,57,242,250,108,13,200,31,184,115,30,190,65,111,225,197,90,215,174,221,193,216,165,11,16,3,153,141,181,161,223,213,141,64,243,41,33,65,208,245,48,203,171,242,234,120,183,57,60,85,83,188,148,249,94,62,178,164,119,223,137,180,49,184,166,120,134,127,76,230,216,208,161,5,42,237,196,235,114,222,23,134,110,242,244,163,1,42,228,3,251,93,156,48,46,154,200,19,163,205,213,250,142,212,14,156,210,48,20,148,235,204,232,128,21,3,100,38,184,230,249,138,117,207,253,60,79,102,174,115,184,21,102,194,116,47,69,98,110,200,73,248,186,30,220,75,239,155,228,138,141,255,84,179,127,17,124,167,107,102,248,93,59,11,170,167,110,129,228,140,41,111,215,131,169,31,210,192,131,220,50,29,241,34,235,141,60,96,178,83,126,109,14,186,209,248,63,130,108,186,180,105,95,192,234,29,87,8,197,153,103,55,13,10,116,247,40,153,54,84,199,120,69,98,185,228,4,234,107,80,168,240,218,9,114,58,196,150,245,120,244,210,164,160,201,55,20,40,135,138,179,149,228,199,157,192,174,190,79,35,154,208,104,215,44,229,241,125,186,156,42,60,224,60,98,79,40,64,126,207,165,212,10,115,54,25,33,126,58,236,50,194,209,149,85,111,178,89,79,15,60,227,54,174,229,243,135,42,102,50,171,254,95,21,247,31,125,0,215,95,9,254,115,158,204,23,106,103,28,139,202,110,125,119,242,110,213,56,152,116,42,49,235,231,28,252,0,141,119,191,200,51,122,183,74,56,200,99,174,153,239,174,227,16,247,241,53,17,43,147,201,28,236,24,172,158,183,250,239,232,109,178,138,191,154,85,92,101,93,173,175,120,149,115,204,109,250,109,193,172,203,85,254,72,122,109,173,97,223,35,161,59,23,39,177,164,124,186,70,76,36,143,143,79,179,160,167,125,30,112,233,209,141,126,247,37,119,77,159,6,86,22,186,250,64,148,109,116,69,157,161,219,213,126,74,234,55,4,74,150,191,164,59,229,208,73,147,153,74,155,93,93,177,111,177,180,36,107,46,26,222,118,125,41,31,110,95,84,199,96,81,223,99,229,230,111,208,187,44,207,189,197,162,155,118,66,246,102,5,157,180,61,121,27,171,235,38,194,219,47,109,32,238,247,114,130,158,184,151,243,155,87,210,50,16,172,39,124,229,145,237,44,49,206,229,30,118,171,255,129,65,10,175,28,62,65,30,217,20,113,253,179,149,240,28,118,112,140,20,237,39,7,159,242,230,64,144,209,53,33,213,116,176,141,135,111,225,244,248,107,202,235,131,88,130,60,113,17,151,144,193,21,155,78,5,33,221,177,64,101,141,166,1,217,83,16,24,8,33,203,8,73,180,252,201,36,37,193,112,158,81,36,62,12,87,125,150,121,19,39,92,191,173,210,244,36,77,195,88,140,26,156,4,231,27,111,89,251,35,188,185,246,75,176,127,162,75,144,137,255,124,36,161,108,144,154,177,88,19,197,21,51,61,242,175,177,115,118,58,158,40,174,196,158,97,198,184,209,36,126,232,71,189,204,186,7,102,36,124,234,204,89,172,220,192,86,101,51,175,40,9,191,17,115,155,117,200,237,22,138,77,48,250,240,160,224,117,133,170,182,144,213,211,213,2,243,145,65,254,0,2,248,48,33,249,80,119,29,108,76,228,213,3,143,250,23,23,131,183,155,60,55,214,27,114,225,198,150,10,35,148,123,109,118,26,2,65,205,51,165,231,113,146,183,118,99,110,128,192,107,84,128,130,68,16,88,195,165,35,170,219,153,195,92,132,226,34,20,77,81,240,139,150,107,214,77,155,204,106,79,19,168,44,71,198,240,87,142,60,44,60,246,5,116,90,243,72,82,123,206,123,164,157,159,113,100,46,227,97,151,247,172,49,26,253,214,112,110,75,191,20,199,178,121,153,73,146,167,80,165,179,249,104,118,42,76,8,126,200,69,25,1,35,35,219,85,218,235,253,164,63,211,195,178,60,208,120,222,151,167,79,238,35,131,109,53,18,149,50,40,14,206,218,230,111,82,234,124,19,223,6,18,94,196,199,189,219,79,203,3,86,63,184,11,70,220,145,70,39,204,13,70,25,105,99,18,2,0,24,161,197,244,35,162,11,157,34,54,196,92,138,255,30,83,77,170,69,196,207,11,28,60,155,7,88,6,248,72,159,21,242,123,4,244,230,249,74,32,130,186,174,143,2,140,24,130,73,170,186,195,129,0,221,95,213,21,27,147,128,194,103,91,111,210,249,82,200,180,140,107,187,79,132,95,135,105,220,39,219,47,101,130,232,19,153,84,96,21,214,227,184,212,26,88,77,22,173,250,215,51,120,214,55,206,86,220,178,39,170,15,114,12,97,98,239,4,124,47,250,230,133,149,196,82,209,165,151,0,207,30,106,133,62,251,241,196,196,47,179,145,179,2,155,15,5,165,22,67,52,207,39,246,123,134,219,252,174,231,168,82,8,7,192,229,168,45,215,86,100,235,111,169,107,12,249,89,109,86,160,142,181,238,237,223,92,168,130,150,236,224,116,222,45,18,13,13,164,73,38,27,208,24,138,45,80,4,148,58,149,54,128,230,244,22,230,218,179,87,51,104,223,178,9,209,228,14,206,192,249,41,82,34,115,235,125,150,192,196,1,165,252,62,83,243,157,37,218,134,192,149,232,139,145,253,205,51,17,97,192,121,157,60,181,170,126,156,5,44,196,235,223,123,170,2,118,228,255,243,8,132,196,221,30,242,92,159,112,180,131,51,25,126,253,184,7,4,110,34,217,37,185,91,186,44,77,80,104,181,58,171,9,210,180,17,119,8,141,229,247,64,62,232,121,118,112,133,52,173,5,202,94,170,37,212,28,222,193,97,51,164,107,197,181,220,102,52,58,47,147,194,179,174,14,89,19,221,145,39,174,86,249,64,89,192,101,143,207,156,186,210,1,137,143,225,13,38,98,59,92,137,53,31,64,212,100,157,144,100,131,3,65,115,94,185,87,13,25,176,45,184,207,19,250,197,231,86,217,51,191,125,60,11,95,125,105,236,148,166,54,6,42,0,150,180,138,38,30,235,72,106,14,217,69,184,242,46,197,173,38,89,234,41,197,213,165,79,86,118,231,142,207,69,207,108,20,53,179,160,231,84,99,156,253,80,13,15,65,18,73,160,149,31,76,124,141,4,48,207,86,81,87,66,32,121,213,115,116,230,240,201,247,195,159,66,154,244,180,174,14,101,84,3,66,175,40,177,65,194,101,162,234,26,55,222,21,72,164,219,243,129,30,172,104,212,50,6,152,90,233,235,35,221,207,165,225,44,109,74,127,123,173,56,87,209,84,211,48,214,123,5,105,101,78,188,169,175,36,172,214,19,232,125,217,130,252,99,237,244,61,173,193,82,209,216,57,13,12,202,82,193,78,70,69,206,74,240,191,91,25,179,254,242,177,68,23,139,165,101,32,52,246,25,212,240,38,237,147,60,156,190,36,3,56,163,125,228,107,228,6,235,44,250,90,92,77,158,36,217,168,161,77,26,49,125,99,103,191,115,41,120,16,231,243,69,108,169,115,81,127,195,48,164,132,75,173,147,62,148,220,3,189,186,165,200,86,60,18,172,193,207,129,196,167,69,181,134,232,130,109,48,76,133,202,38,184,207,153,39,149,26,4,242,77,59,193,254,102,222,99,68,91,147,245,252,14,111,57,224,121,244,233,148,97,66,37,162,181,44,60,144,184,181,187,204,143,33,120,225,243,226,97,190,168,25,134,240,146,145,251,166,104,183,243,126,93,104,93,84,55,148,49,84,30,71,204,203,236,226,179,113,247,64,213,92,207,126,35,130,231,86,232,149,34,79,127,8,155,120,228,29,247,142,10,151,52,57,180,40,56,93,99,171,253,160,143,201,101,183,204,59,240,23,208,83,198,151,231,231,147,28,110,4,156,102,57,157,18,249,18,50,20,130,56,53,156,41,45,170,41,117,136,179,222,121,239,18,168,166,237,2,237,98,107,148,236,81,60,2,33,181,218,46,71,254,197,234,84,204,80,27,160,118,123,153,37,55,238,240,199,98,227,116,197,126,232,21,255,98,226,206,152,34,211,121,85,69,183,195,225,202,232,188,79,208,206,156,187,96,21,189,252,76,203,227,241,70,211,61,52,217,12,33,243,41,50,152,77,47,82,19,140,197,235,100,59,65,70,115,52,246,95,80,145,224,57,224,221,213,78,145,49,47,117,102,248,205,92,84,18,215,150,191,135,145,62,36,193,200,52,133,187,34,96,149,139,1,97,248,25,51,64,247,58,93,111,15,225,212,223,114,61,92,11,95,154,153,245,208,78,148,39,150,34,40,110,50,154,11,54,4,145,21,134,166,233,0,193,39,105,2,102,29,28,168,238,231,117,248,142,40,50,56,142,240,142,165,151,16,85,30,155,98,225,239,177,187,143,215,228,29,118,98,85,69,167,21,45,116,143,40,42,152,1,87,158,139,169,81,137,18,54,65,178,145,44,82,225,241,84,208,111,202,139,17,95,107,130,255,148,105,65,106,172,230,171,55,197,239,133,168,4,152,247,235,19,138,175,168,216,216,171,23,160,83,71,40,126,234,228,1,76,145,9,132,135,166,202,190,232,233,218,105,184,138,161,252,19,33,132,61,159,183,129,62,37,37,194,79,104,59,218,204,215,82,166,4,190,36,224,43,97,59,71,51,188,214,175,54,18,10,15,153,110,203,218,59,225,113,185,123,75,111,206,104,24,163,254,170,85,40,105,9,229,41,218,37,240,211,103,89,253,97,34,77,188,114,220,132,215,129,26,109,149,186,128,119,108,19,20,122,172,175,10,20,169,9,104,195,150,51,8,159,140,86,232,226,177,7,196,200,167,207,106,126,27,140,222,219,198,149,46,0,13,93,255,121,205,23,206,245,185,247,15,231,173,156,59,156,16,48,118,254,93,148,203,237,189,158,180,101,52,62,155,57,8,175,171,215,67,69,104,60,72,232,226,185,20,206,65,59,42,125,90,124,100,202,134,141,239,191,110,203,164,223,50,232,219,4,222,205,22,70,62,180,75,143,174,228,44,62,245,202,39,117,215,33,145,80,106,131,177,244,66,46,89,167,198,251,80,38,72,190,90,118,85,34,158,83,17,61,132,124,53,24,63,24,90,249,68,131,245,198,183,117,13,157,137,70,189,73,23,75,77,13,25,88,126,217,87,108,92,8,133,154,15,158,112,113,94,186,162,177,9,232,181,162,55,24,38,161,79,176,4,233,11,158,170,242,240,168,77,25,3,223,158,186,182,26,129,84,106,135,108,205,79,254,175,227,1,238,248,79,5,72,169,217,128,158,1,139,110,157,12,39,55,95,3,2,113,179,81,229,38,144,253,35,77,155,97,157,9,47,133,35,238,97,246,176,156,164,3,236,181,42,140,173,1,46,164,218,168,228,127,219,160,224,59,249,247,7,155,98,77,199,215,146,55,151,221,185,163,241,26,122,137,164,190,205,207,4,237,134,165,74,238,223,226,15,248,242,139,107,210,187,234,4,145,23,231,180,229,53,254,166,201,220,10,14,58,33,230,72,92,230,207,170,109,188,229,137,28,147,22,41,192,213,40,215,216,127,14,228,9,13,85,247,106,247,1,155,206,136,4,23,190,148,170,106,194,155,170,96,227,85,168,247,195,20,113,172,17,34,38,123,79,167,110,206,207,53,66,173,162,178,166,84,120,160,160,218,186,227,34,87,100,212,219,28,84,255,59,138,26,28,227,102,205,94,75,152,55,216,163,46,225,96,152,57,32,57,159,27,251,178,201,231,5,139,31,163,136,69,71,125,19,213,46,252,84,88,215,163,249,153,181,25,227,174,4,105,93,98,251,60,164,4,222,26,165,85,83,87,45,206,132,134,6,108,89,96,76,139,144,143,144,116,59,72,48,184,248,230,195,135,167,29,166,42,207,49,87,221,159,42,168,96,157,181,125,152,96,130,72,48,100,105,145,96,98,200,116,7,131,166,69,99,117,55,141,40,125,106,249,33,118,191,121,159,138,79,27,90,132,13,52,0,61,44,246,212,77,127,107,26,124,234,104,26,14,238,68,79,124,247,99,81,60,135,27,62,83,231,104,214,53,69,104,188,95,120,30,105,222,150,218,223,80,221,209,86,113,125,226,123,36,1,136,94,206,253,124,34,218,2,77,208,172,39,238,148,151,111,237,3,135,99,41,22,142,129,39,56,105,255,31,62,12,171,5,206,94,114,13,174,185,89,199,225,131,239,187,92,132,102,86,138,156,36,55,112,65,191,209,70,60,75,110,59,216,180,148,36,118,238,139,97,222,17,236,209,68,163,76,177,206,58,196,113,2,166,47,131,113,199,180,134,23,174,24,119,20,124,144,29,221,9,90,224,188,131,232,13,244,94,200,129,51,27,11,124,24,154,5,91,171,150,238,212,117,175,71,155,110,168,3,236,162,196,193,74,101,6,238,157,132,151,181,88,122,26,84,194,170,253,198,124,142,133,185,66,4,105,5,152,87,209,178,134,243,242,197,214,209,103,53,218,128,193,9,83,231,55,111,29,235,133,45,107,115,71,203,15,1,69,200,105,216,1,163,183,18,222,54,6,56,48,104,228,237,119,166,90,242,184,97,160,218,194,255,151,131,120,180,104,202,167,157,179,147,77,161,34,65,201,171,236,177,175,0,92,134,255,40,217,133,61,187,44,165,109,184,127,37,189,61,62,60,232,182,210,78,123,118,207,185,156,158,77,117,67,26,37,222,174,87,192,241,152,180,170,218,35,86,86,91,87,98,97,192,129,140,194,233,36,79,152,203,136,73,223,63,26,117,190,88,188,60,42,9,45,54,223,198,207,196,237,26,244,60,233,67,132,223,113,147,253,16,126,10,119,41,159,99,237,109,167,23,248,146,7,166,214,75,0,234,202,90,254,26,71,82,240,116,216,96,236,109,46,104,255,134,115,253,155,36,36,129,188,183,140,151,14,153,244,139,244,252,214,160,8,249,226,35,58,185,116,255,126,128,120,235,190,225,169,185,175,255,64,176,56,247,249,7,18,39,92,249,142,98,47,116,247,126,6,66,208,245,253,217,123,160,123,49,99,18,90,47,9,80,207,212,123,18,61,155,193,44,242,205,146,4,96,210,222,194,220,47,172,241,165,29,155,45,163,105,121,174,115,233,211,216,182,136,24,90,234,77,214,70,94,160,35,59,16,39,71,24,186,43,251,99,53,11,47,60,159,24,144,250,41,114,90,26,97,209,154,96,63,178,67,28,211,107,179,90,253,127,165,163,26,175,163,165,60,47,25,151,210,245,25,91,122,31,176,184,179,128,161,75,71,166,119,40,19,58,101,115,237,145,211,239,250,235,224,4,46,64,94,118,213,191,21,42,27,169,75,217,193,182,121,215,57,216,234,245,160,135,78,21,125,113,51,250,39,177,32,227,61,57,182,118,16,212,181,130,153,240,62,148,127,188,127,160,37,3,231,33,68,181,179,95,116,179,14,247,145,214,104,222,71,140,17,161,171,218,105,81,195,25,20,202,235,110,70,90,42,47,194,109,74,85,60,77,65,92,205,106,16,171,147,0,227,16,251,48,224,101,8,46,29,94,50,36,213,78,254,13,7,254,227,219,219,18,45,213,145,136,25,210,42,32,47,62,61,139,31,140,17,210,249,37,178,80,160,59,139,26,250,178,179,208,129,81,82,239,54,209,224,20,156,174,251,26,130,136,28,68,243,28,42,28,17,51,90,6,39,125,11,249,223,165,193,243,148,129,17,210,146,186,89,202,253,59,205,5,52,237,17,181,104,92,54,142,214,177,178,59,214,195,73,72,186,175,17,1,0,220,146,69,144,120,89,133,146,152,239,230,141,237,0,78,250,117,54,179,45,38,167,90,149,136,233,115,8,227,210,205,255,208,177,5,45,173,12,189,122,109,122,136,191,40,176,51,234,201,4,208,42,147,44,56,120,17,43,69,93,97,143,103,130,166,129,101,7,40,85,92,157,218,212,230,114,139,2,233,64,93,127,49,140,232,168,194,0,74,215,40,158,61,12,247,57,151,103,148,42,210,155,139,211,87,19,0,208,70,224,199,34,241,199,70,169,161,135,61,105,233,172,62,114,0,96,15,45,231,45,55,172,39,55,41,225,133,190,138,162,53,142,120,95,183,32,192,36,208,155,102,233,86,61,53,30,206,83,199,125,72,101,207,29,247,104,10,148,18,184,234,165,202,151,116,193,119,185,112,23,192,20,152,65,174,8,254,94,56,95,112,30,175,131,75,160,36,26,226,61,55,97,225,40,77,212,181,0,239,155,198,208,128,240,202,248,190,135,42,46,22,94,11,61,30,199,55,16,98,142,1,63,173,36,147,172,74,152,45,239,201,204,46,115,27,81,227,120,112,155,184,99,79,214,130,147,122,64,139,9,147,208,82,76,15,123,98,5,74,218,198,40,175,162,34,226,243,95,227,126,94,45,242,141,118,9,49,66,13,62,135,201,56,200,96,255,212,204,11,3,243,18,242,108,74,227,62,173,115,180,224,226,248,249,141,136,245,6,158,110,65,8,248,189,225,236,226,84,45,8,72,133,12,176,12,140,172,135,245,88,80,88,0,185,175,79,207,75,134,219,100,194,29,255,125,135,114,8,126,63,172,235,145,65,229,120,37,197,36,66,254,60,122,61,197,192,6,79,197,152,198,219,179,231,14,155,211,69,154,175,209,49,59,91,6,25,138,1,144,199,28,148,67,149,19,37,147,101,173,173,206,196,37,179,47,184,185,251,43,182,74,221,246,66,82,220,131,113,87,197,241,66,226,95,156,93,186,196,250,229,244,248,189,22,207,27,43,104,3,210,183,207,145,95,190,74,251,145,107,71,36,138,225,83,79,207,145,78,210,137,175,90,23,239,94,181,98,41,136,109,211,114,150,87,255,49,149,169,69,132,65,211,140,205,214,29,22,127,210,12,110,19,72,139,152,200,229,246,220,110,222,227,189,5,36,90,254,53,6,237,122,57,142,108,23,90,140,146,218,237,207,124,148,18,43,1,231,98,177,83,35,133,156,57,105,201,222,84,80,168,12,176,33,62,83,81,72,91,127,176,136,94,105,255,254,90,145,155,68,132,45,203,4,81,16,2,218,66,189,227,170,31,12,196,122,121,143,12,99,122,129,195,234,210,79,14,55,209,162,72,6,182,66,57,203,144,165,124,104,28,239,250,145,78,30,73,201,115,103,29,184,58,64,70,85,21,63,220,48,82,120,182,147,193,160,57,159,29,228,110,185,119,116,208,106,226,116,121,81,43,222,244,81,208,45,54,252,92,150,203,97,118,228,145,19,251,135,68,118,217,134,205,225,179,191,233,152,12,91,197,183,100,112,245,155,90,49,164,31,226,11,161,97,101,12,52,104,87,67,185,88,236,186,244,207,7,33,67,86,181,69,233,84,8,132,228,204,119,32,165,140,91,72,140,72,59,85,160,243,119,182,101,202,174,103,225,103,157,66,245,6,239,65,118,228,82,220,95,37,111,101,138,161,191,68,163,207,254,132,5,33,34,56,45,15,145,79,100,40,250,236,235,36,175,245,20,209,154,13,198,149,155,0,80,11,84,80,172,105,217,187,232,7,132,48,231,150,103,105,189,165,83,77,153,247,75,244,46,186,175,219,208,150,199,180,28,58,132,148,105,13,207,113,32,133,101,252,13,167,207,239,200,38,246,25,126,101,156,150,20,134,155,28,193,203,237,91,8,31,34,172,248,160,57,105,219,239,42,133,226,116,81,43,132,235,167,30,68,43,231,221,164,52,182,249,179,61,153,161,159,137,151,189,73,236,246,163,36,98,19,85,248,126,173,105,179,75,212,179,6,192,100,128,153,211,199,108,66,203,86,207,169,95,199,34,119,154,244,10,13,220,112,98,175,183,40,113,55,27,57,116,86,1,170,179,54,173,252,94,178,69,116,19,143,251,130,194,112,136,117,223,38,229,127,85,195,14,156,30,223,71,155,223,129,124,152,171,136,110,120,95,180,53,100,168,25,3,216,42,54,85,46,69,119,107,155,145,251,64,53,185,193,15,13,139,6,167,11,60,47,89,97,48,152,126,89,204,146,71,95,57,111,150,78,240,251,102,115,113,11,147,15,192,253,231,25,248,245,109,134,153,56,58,101,46,144,2,253,31,2,83,198,61,64,121,63,76,80,67,29,12,66,28,147,254,92,69,68,35,212,156,221,161,237,249,146,56,121,137,145,156,246,183,247,139,124,62,163,212,103,229,186,93,174,69,23,160,26,196,181,43,175,176,60,110,211,55,131,146,61,179,46,79,154,194,63,7,77,202,244,150,202,18,92,217,129,241,239,222,111,51,135,13,231,255,23,171,205,2,165,228,225,46,247,213,245,181,190,140,154,241,182,186,251,24,83,159,137,53,64,138,170,164,60,147,27,90,82,193,36,201,173,182,188,108,188,229,45,193,211,18,253,200,185,25,95,180,93,30,219,69,195,239,222,97,161,110,214,36,114,96,168,76,77,164,53,131,226,197,100,0,42,106,159,84,214,55,249,124,216,170,102,155,118,134,77,181,65,115,14,167,123,89,46,212,228,181,29,222,148,86,228,253,74,236,231,197,148,188,137,167,27,127,12,253,186,84,67,146,211,91,131,122,218,230,239,254,175,168,1,213,249,121,7,221,136,146,201,36,166,47,73,221,190,128,205,126,206,89,121,78,233,57,64,136,20,67,198,178,249,191,17,131,33,149,197,130,104,170,130,142,237,246,170,147,192,156,248,187,123,25,225,139,220,171,61,24,24,114,110,77,3,160,244,82,56,94,113,16,27,118,228,217,56,29,253,10,75,145,97,193,150,89,210,52,60,146,17,127,187,216,5,195,108,15,251,39,157,158,86,49,193,199,155,106,6,73,80,247,203,61,88,81,56,93,158,179,40,245,81,68,136,69,32,237,101,122,112,165,100,55,9,127,59,26,9,41,16,102,92,246,179,125,108,231,225,63,120,88,135,69,195,239,197,51,245,72,72,59,15,231,42,3,184,123,64,176,64,2,15,246,220,67,193,252,8,159,56,20,44,137,45,172,109,183,204,159,101,6,17,221,228,44,160,69,242,153,202,128,203,12,4,126,92,35,50,234,50,118,36,235,41,31,25,142,113,24,62,9,95,20,19,50,125,158,204,53,186,86,53,189,102,153,228,219,22,2,99,14,143,147,221,199,23,113,107,196,224,225,104,121,99,34,19,112,121,28,191,160,245,10,17,84,184,88,225,151,167,54,240,195,72,254,120,18,22,155,131,146,29,227,234,30,101,250,135,69,125,243,191,220,108,252,27,73,15,229,136,53,207,18,173,204,19,205,199,182,167,225,33,249,143,99,91,17,55,149,227,252,128,238,114,212,169,242,145,36,176,68,219,87,139,157,11,63,61,59,211,206,153,189,127,223,109,58,97,39,141,146,29,253,92,94,80,25,18,106,154,118,230,19,134,225,160,83,60,150,40,14,114,137,33,215,197,110,48,190,240,56,91,138,248,129,37,247,39,83,175,2,103,194,229,110,102,216,12,120,6,3,226,163,55,78,249,252,111,226,91,6,137,148,130,47,48,247,229,23,243,182,71,150,137,124,20,124,66,139,32,193,148,161,185,236,79,174,99,200,112,53,55,117,29,34,237,204,153,30,100,212,1,178,63,101,108,21,60,226,164,189,178,191,164,14,130,253,211,82,162,209,199,23,248,243,208,248,249,158,141,215,199,86,0,246,74,146,131,115,160,41,65,31,203,224,248,194,77,33,67,47,171,200,140,46,76,21,188,172,177,183,243,246,224,185,32,56,122,180,233,201,25,233,15,85,45,133,25,16,136,35,136,145,142,15,86,80,133,48,119,224,178,65,40,193,213,90,108,89,160,56,151,217,217,57,103,175,63,242,81,89,154,80,29,72,39,62,162,124,64,207,184,236,170,24,70,121,44,61,235,14,3,108,68,201,57,178,69,188,58,91,211,235,251,154,69,34,123,86,213,66,253,253,216,176,67,99,197,91,185,250,198,244,215,134,106,130,27,155,101,61,23,181,173,83,247,184,185,24,221,87,94,129,150,24,83,250,180,99,14,23,157,95,133,189,98,219,252,120,118,181,213,41,131,138,220,245,32,75,155,209,55,31,197,21,188,175,14,108,96,144,219,70,87,169,105,80,215,39,54,253,164,135,220,113,179,11,26,86,90,17,173,82,168,51,234,219,159,197,190,211,12,96,163,96,156,21,216,237,81,71,8,238,177,222,65,238,18,207,224,198,6,78,77,58,229,128,113,49,80,53,64,60,188,235,183,243,253,19,186,159,48,179,25,11,199,176,100,249,48,94,85,170,164,215,111,157,248,47,235,115,199,148,241,90,5,156,158,194,36,48,2,128,54,251,107,121,73,162,149,9,148,65,58,167,164,203,170,52,197,196,44,120,167,22,204,41,135,101,200,149,248,38,73,57,71,205,69,158,255,72,185,219,30,199,49,162,53,242,190,45,142,206,11,94,30,40,120,221,10,171,209,31,64,30,69,102,138,222,180,169,4,28,97,34,15,174,50,15,217,31,255,141,56,24,233,173,156,216,252,142,255,94,59,43,223,147,253,34,44,189,10,93,55,252,67,27,40,123,12,243,5,33,140,234,16,240,115,171,26,131,179,201,114,216,135,196,14,204,11,226,91,159,139,238,182,65,152,10,212,173,146,189,31,16,197,251,214,140,176,101,41,217,127,19,65,118,112,116,119,159,28,52,102,175,254,92,132,73,106,70,124,121,229,34,136,208,230,102,14,165,73,4,170,233,83,76,138,148,54,152,21,227,68,40,188,180,162,79,72,48,228,26,205,64,66,33,171,221,163,170,114,114,184,172,219,201,168,200,24,77,52,12,80,226,95,105,205,101,189,221,3,5,202,38,226,148,208,76,126,116,245,120,125,186,56,187,96,82,46,133,211,10,66,86,187,156,137,23,160,98,171,226,232,11,114,200,18,250,211,87,122,21,93,163,90,104,194,160,53,194,74,207,94,195,91,24,76,184,136,174,136,22,245,12,54,167,76,106,249,48,251,40,188,97,95,223,30,22,142,194,231,189,143,57,151,51,105,150,197,223,211,167,34,90,118,91,128,229,236,240,185,96,234,208,26,179,111,122,244,232,80,12,38,10,75,30,38,189,236,165,19,26,106,197,252,71,235,185,204,73,177,213,143,142,148,0,198,150,67,125,250,112,233,80,164,49,60,6,157,40,93,68,163,97,177,11,138,69,11,80,35,151,37,226,112,83,104,68,199,208,112,120,18,122,5,174,225,120,249,246,187,239,139,207,193,43,156,214,226,0,98,218,49,189,224,164,249,146,98,223,125,50,17,156,249,81,199,227,5,93,233,167,93,238,114,241,192,104,44,145,2,60,79,168,0,112,62,78,120,31,150,105,225,33,243,194,10,247,239,80,186,67,248,147,112,190,206,149,49,185,35,4,129,193,254,128,152,100,164,105,79,44,168,54,203,1,129,230,43,92,174,4,56,200,148,20,82,211,212,136,193,83,214,240,81,138,39,11,132,114,55,99,194,4,143,40,233,177,238,255,46,166,183,5,115,190,182,171,253,136,6,248,32,219,26,252,55,109,189,224,176,219,6,131,136,170,148,101,102,58,242,121,97,120,125,146,126,232,251,70,200,193,191,199,169,112,172,43,218,147,205,17,215,99,9,141,194,206,149,104,71,115,45,250,190,121,28,115,88,81,131,250,172,238,160,98,146,119,165,113,166,10,172,34,174,43,44,119,114,32,110,169,188,210,22,181,71,3,8,218,196,202,103,105,234,72,209,168,202,3,206,120,58,52,91,169,202,207,73,67,52,223,246,40,85,129,186,17,147,193,231,46,110,139,178,74,210,186,252,20,42,212,66,107,31,239,184,60,105,247,138,212,29,59,35,147,239,109,123,57,144,11,149,66,71,134,57,20,223,47,197,51,83,184,140,102,217,213,245,43,232,173,139,129,135,141,23,147,64,170,6,101,154,52,47,242,34,140,3,101,199,41,95,122,146,104,251,210,114,60,120,85,93,235,23,132,185,200,46,225,58,185,30,23,139,234,67,231,176,36,70,216,129,111,57,23,74,254,117,89,199,41,209,178,61,214,211,184,105,167,86,249,49,90,42,123,168,58,104,222,200,67,41,108,0,17,167,116,177,110,201,116,233,182,36,97,100,6,194,14,109,98,123,229,192,135,60,139,212,178,229,24,178,75,57,129,64,124,38,73,23,182,0,233,69,40,62,242,69,133,151,96,88,46,115,166,144,227,171,12,67,150,150,224,205,128,11,68,98,7,65,199,98,217,18,163,103,246,75,237,111,191,192,188,237,204,240,118,109,98,193,54,170,132,185,37,96,110,213,152,18,190,35,50,82,137,93,149,215,225,221,42,90,5,238,158,171,51,61,216,167,102,11,175,66,32,95,200,136,58,38,185,31,31,7,154,137,77,199,135,129,68,11,138,218,56,51,63,138,232,178,118,35,168,128,222,75,254,4,133,240,20,138,225,42,242,179,147,238,252,236,171,207,216,158,161,187,121,28,211,191,97,168,90,83,211,109,149,65,124,180,9,172,11,247,233,144,178,35,236,201,59,110,14,121,70,14,224,61,254,78,212,28,174,65,117,240,197,140,63,81,231,180,236,142,119,35,45,55,146,227,92,243,89,103,227,113,113,7,241,196,218,216,222,133,210,176,201,227,29,129,190,164,242,224,9,230,82,122,179,114,75,246,39,15,229,149,39,223,54,20,209,236,251,52,201,186,78,73,37,151,126,3,228,78,186,96,42,131,8,164,251,31,66,192,181,12,97,55,186,77,32,219,199,151,33,3,42,85,29,142,29,6,107,115,68,114,214,114,140,199,143,20,245,129,9,78,83,246,169,65,41,122,99,69,204,115,173,8,254,95,66,163,162,48,175,244,113,209,100,147,112,188,220,233,113,5,212,201,138,91,38,191,72,7,99,178,116,234,92,48,244,0,211,154,27,247,206,232,89,85,99,233,132,72,85,200,139,238,153,179,24,123,99,134,246,142,188,239,9,157,112,162,234,185,118,245,59,130,224,204,31,163,171,38,159,221,225,99,216,177,58,35,104,109,10,125,89,23,53,56,37,68,165,189,60,83,249,63,161,240,70,141,1,210,143,125,157,56,227,11,24,55,38,168,16,119,213,155,223,143,131,175,37,234,125,238,16,194,101,201,158,4,110,18,210,221,84,87,14,13,169,250,241,240,1,12,205,98,246,198,75,250,239,249,104,97,127,57,19,15,104,126,28,59,196,119,32,32,82,17,212,81,175,226,118,175,241,105,177,135,71,82,187,16,240,159,71,37,41,230,115,64,156,184,169,24,234,219,0,246,117,253,167,73,143,69,3,130,245,116,43,177,166,154,119,212,153,47,46,26,192,155,252,200,241,110,201,195,252,231,181,147,45,221,62,85,89,150,72,79,230,174,245,52,49,209,202,184,143,160,9,190,63,249,33,193,163,53,123,237,31,46,225,42,225,49,158,14,120,71,133,247,37,52,27,195,168,0,173,254,175,48,203,127,136,142,20,140,58,102,224,52,13,72,195,143,146,84,91,160,228,92,126,63,39,81,150,207,232,13,28,22,22,113,169,45,140,23,5,46,155,127,197,116,25,54,226,104,89,169,95,100,83,211,41,119,115,107,60,190,170,12,213,173,189,220,228,10,211,105,116,245,166,208,229,181,165,201,68,170,57,36,97,78,110,76,75,65,230,77,138,17,146,196,148,196,16,237,121,105,24,158,75,121,236,185,205,129,31,100,68,181,179,248,183,65,29,74,96,126,223,176,27,19,62,148,147,12,48,70,173,22,7,123,162,216,137,16,123,171,81,196,100,84,138,92,119,3,209,28,49,46,184,35,78,201,26,213,233,176,139,204,161,161,100,134,151,46,27,220,236,243,154,104,171,179,29,24,244,219,213,4,109,217,17,167,110,219,11,225,255,47,80,164,122,91,85,104,133,179,78,39,122,132,12,176,53,220,175,184,93,42,5,93,129,217,176,225,1,179,77,53,121,239,203,231,143,218,94,107,129,31,11,195,254,148,78,105,60,149,153,223,20,120,153,7,211,141,71,154,236,170,254,85,202,104,196,108,18,145,215,252,129,244,163,252,137,151,112,146,157,1,59,187,240,13,15,2,216,118,65,35,126,38,27,221,174,235,245,160,106,120,196,95,105,214,48,54,136,226,74,65,88,37,3,224,245,60,140,2,150,249,134,212,251,59,123,169,14,76,79,118,67,227,62,202,182,40,50,114,7,24,44,54,254,33,251,230,193,198,191,167,178,228,71,214,100,187,93,9,99,58,230,102,178,170,160,39,178,130,14,57,7,70,171,249,174,14,35,35,120,237,233,152,182,162,97,118,134,142,150,24,7,159,154,144,20,178,175,155,125,114,58,253,140,118,189,3,236,201,17,137,170,158,6,138,214,209,52,137,203,102,157,11,99,113,92,97,55,117,153,111,20,219,251,13,105,77,46,143,89,53,195,147,116,53,124,195,182,95,154,49,226,94,206,124,56,128,210,109,131,196,167,229,110,5,138,241,184,84,170,48,209,20,77,49,194,144,208,224,23,8,82,52,152,83,235,136,168,48,59,7,125,42,229,139,89,170,227,83,9,67,233,174,188,101,17,74,229,208,35,149,23,105,183,73,116,1,80,193,46,164,25,242,129,1,17,88,87,87,94,55,96,126,151,60,35,202,219,9,3,222,161,131,34,149,198,202,198,131,167,91,75,106,85,22,230,193,8,201,156,81,226,164,111,44,147,161,162,209,240,123,26,148,30,161,104,16,29,236,170,204,149,74,126,34,109,24,139,125,1,32,228,137,89,30,201,147,146,189,177,123,185,72,228,107,91,49,121,163,27,243,72,155,29,183,58,67,212,196,210,201,58,31,102,67,158,141,70,175,80,213,3,99,198,124,34,110,94,209,77,20,85,45,162,82,18,61,189,203,199,56,131,228,230,7,53,226,247,217,35,66,115,37,68,130,210,200,156,186,44,33,11,229,31,84,159,92,194,52,14,158,187,179,106,80,194,179,80,226,202,110,147,204,167,44,63,158,49,55,80,115,164,46,156,244,58,137,134,55,253,220,75,9,103,136,249,242,3,215,220,53,123,17,75,112,40,131,105,76,0,16,17,245,242,195,47,165,106,200,206,26,130,189,65,203,2,99,181,5,143,191,100,128,52,249,154,169,127,159,85,163,175,105,201,79,170,124,33,172,15,229,166,146,194,104,108,129,91,132,33,195,224,4,116,61,113,89,52,79,251,121,2,32,71,98,121,115,214,245,87,160,16,97,250,177,149,55,39,223,212,203,76,231,248,127,176,129,187,75,9,209,101,237,148,65,111,200,193,164,44,66,237,159,220,85,84,91,89,208,128,237,151,180,31,151,237,151,16,114,221,155,43,42,4,83,34,238,79,149,66,231,157,222,132,11,145,104,170,56,236,84,248,183,36,85,4,10,143,170,141,177,87,7,163,114,225,72,248,238,122,146,203,203,157,4,155,198,245,193,60,218,180,175,34,89,80,195,35,71,85,234,238,86,77,49,244,128,157,230,211,30,114,38,88,35,242,190,254,27,132,194,18,236,121,228,133,95,97,44,236,154,28,64,235,14,62,141,6,104,2,239,196,0,239,190,200,189,55,225,88,118,166,28,3,155,39,73,135,166,250,86,28,103,243,78,21,135,177,206,135,183,141,13,148,181,253,155,176,98,53,113,191,110,156,23,111,210,0,12,145,6,255,146,80,247,0,74,171,33,213,96,90,118,193,89,208,79,47,247,61,246,11,199,235,65,231,27,63,41,110,254,129,80,132,0,167,84,59,171,175,164,131,185,207,179,36,207,187,236,180,205,188,150,112,119,170,82,180,155,78,6,33,163,196,74,97,85,204,95,48,248,81,22,74,219,228,3,163,28,111,155,134,69,37,9,187,242,25,75,186,8,17,151,196,130,59,118,14,82,207,194,129,82,65,199,147,72,96,117,243,22,125,145,219,206,184,153,41,144,219,98,96,155,34,94,181,44,163,237,168,33,89,151,218,192,247,57,198,126,236,197,141,63,109,159,157,29,83,185,46,181,8,73,42,95,252,161,116,224,219,172,169,119,219,52,46,170,69,178,172,93,174,0,45,81,139,114,181,102,240,100,159,66,137,156,200,175,244,173,51,117,206,244,24,77,6,23,82,12,37,118,160,225,85,183,69,79,100,126,129,93,155,18,95,145,39,32,118,241,90,236,152,14,20,126,31,234,84,34,120,172,90,243,50,162,34,238,83,91,24,255,99,225,240,27,114,166,100,243,207,98,170,111,107,224,19,79,177,203,231,135,126,205,13,231,108,153,215,16,143,6,18,244,71,18,188,143,224,169,189,54,129,185,202,121,10,142,246,219,251,81,92,184,115,207,55,223,23,9,172,6,80,2,236,96,4,51,62,54,135,46,10,0,229,235,188,235,218,127,115,177,136,157,40,2,71,146,32,245,200,137,190,179,220,117,208,242,197,14,183,79,124,35,171,203,89,139,208,30,50,32,249,148,242,236,98,48,88,255,143,25,1,235,159,210,127,229,219,6,20,19,41,23,220,116,32,214,217,7,197,244,101,247,93,18,117,151,140,84,68,104,42,232,36,226,57,55,57,181,128,52,6,203,130,54,199,103,197,158,184,138,127,61,223,65,111,57,25,181,72,139,155,65,139,48,15,128,95,194,241,163,12,246,39,191,53,212,114,194,90,65,109,13,121,48,171,160,68,35,192,251,149,193,182,207,178,158,107,32,192,59,214,166,145,205,76,194,17,236,248,105,195,184,201,91,214,106,71,163,206,253,189,15,166,160,158,55,182,108,213,82,244,47,221,194,227,48,139,93,104,165,186,46,214,47,63,142,36,158,192,116,253,133,77,50,45,85,208,33,203,120,156,6,55,217,53,210,131,30,194,170,65,32,80,32,81,218,104,125,77,236,131,42,23,51,41,208,230,40,175,127,201,126,254,209,89,221,187,181,101,185,235,139,217,248,49,187,232,192,124,28,52,88,70,236,155,38,60,43,157,178,180,45,203,113,4,9,67,86,60,136,52,5,61,152,126,254,205,152,68,61,64,58,226,75,218,19,204,177,16,138,148,243,180,234,110,6,134,194,139,167,50,151,95,62,160,137,209,208,255,81,199,177,240,114,1,163,160,235,235,172,203,57,245,240,94,121,56,11,132,16,23,152,180,38,90,26,107,103,77,223,70,133,160,220,55,161,159,238,135,127,195,39,208,86,53,94,195,241,255,207,90,238,9,252,64,51,154,107,238,114,42,193,58,242,19,108,172,209,86,71,42,197,80,100,152,114,254,57,174,37,64,50,36,160,251,173,106,84,18,16,170,209,101,166,151,240,142,96,134,97,50,207,93,244,231,22,49,72,181,188,188,85,53,41,160,158,84,157,23,30,169,226,115,33,73,115,107,143,0,226,138,147,191,74,190,144,231,29,158,45,154,232,182,228,53,105,112,118,75,176,179,123,111,233,14,139,90,157,138,223,14,191,88,106,91,191,149,119,119,125,12,238,211,244,188,43,214,146,153,165,147,172,221,81,131,160,19,124,234,236,188,144,176,73,96,127,208,169,247,17,186,160,163,61,186,59,233,72,217,58,90,43,43,23,250,105,188,236,66,19,98,125,250,90,130,162,167,174,46,218,37,184,26,92,237,34,0,26,104,74,167,221,23,105,113,9,187,125,231,185,93,92,121,93,23,185,54,19,90,235,249,3,121,58,43,88,53,140,51,45,206,210,228,223,67,147,216,82,11,167,178,164,218,132,152,116,134,84,112,15,165,106,15,116,46,222,118,186,76,133,157,255,99,27,35,96,230,14,223,36,164,244,30,234,71,169,225,124,239,103,239,185,44,71,223,241,177,16,211,173,64,220,127,244,65,244,249,195,214,90,121,43,248,177,241,128,96,74,224,104,16,53,79,225,14,219,175,78,129,103,35,184,131,156,66,49,75,196,237,145,109,124,157,74,188,157,84,32,153,170,210,235,165,6,155,60,118,114,50,169,40,37,1,220,122,220,107,20,39,19,238,244,128,227,140,103,0,179,250,11,140,38,165,57,63,111,193,84,165,175,223,21,24,232,153,190,211,114,99,96,103,146,32,24,107,66,117,93,27,243,49,114,246,219,30,34,20,17,69,183,243,131,101,22,123,146,89,58,14,130,29,141,36,211,54,162,164,189,208,207,2,157,64,29,178,133,166,206,71,226,123,104,195,207,127,14,140,247,187,212,124,199,222,83,46,134,206,111,75,190,63,73,82,47,139,200,197,11,130,44,168,239,104,124,162,31,115,106,15,77,72,8,188,215,102,185,145,177,146,105,215,243,128,236,120,202,35,200,18,3,56,41,51,228,233,136,75,253,209,15,226,133,173,67,184,30,89,158,18,91,156,153,18,111,152,178,1,79,85,158,151,216,76,58,134,155,146,49,89,17,51,188,208,128,156,11,43,131,131,106,12,149,63,166,121,16,63,219,137,51,65,222,5,172,189,253,110,113,53,167,226,44,245,31,50,38,174,100,68,22,13,112,212,36,155,239,195,60,53,18,123,223,198,86,22,195,153,183,238,240,84,186,32,5,221,42,82,204,140,146,40,142,221,64,66,150,70,55,47,30,39,14,91,230,39,190,250,204,44,92,192,48,150,46,192,2,42,75,126,145,237,31,191,38,153,131,36,227,179,79,231,201,9,204,104,33,64,247,81,36,153,134,244,72,253,218,167,247,131,248,178,75,238,207,226,79,244,209,92,176,76,70,26,233,159,72,80,240,245,86,236,211,60,129,147,52,202,224,10,121,136,140,72,97,73,10,133,96,120,170,207,50,34,150,192,32,223,232,196,218,17,88,13,218,31,177,119,20,156,206,58,133,152,213,248,174,186,249,107,70,175,113,37,10,115,145,51,107,100,20,219,82,204,77,140,219,219,169,215,58,48,94,235,31,79,145,66,12,48,214,3,229,197,44,184,188,88,27,187,162,100,106,211,186,207,12,7,55,129,174,102,0,79,203,232,178,166,41,96,67,20,205,236,10,17,185,214,114,166,94,180,205,186,114,55,253,184,106,217,46,50,15,196,129,214,56,81,178,117,165,228,136,107,226,194,252,239,232,52,189,121,119,33,227,225,214,234,74,40,173,225,105,36,9,32,65,235,127,209,218,119,230,246,90,85,92,208,117,25,145,241,125,158,150,196,130,194,200,251,49,170,85,124,87,213,239,96,184,96,197,63,244,187,217,215,49,3,224,114,164,10,22,251,65,108,238,13,29,254,18,139,129,219,58,169,151,73,96,64,221,26,16,12,14,12,78,9,203,11,80,73,221,118,103,173,1,169,193,215,109,126,166,137,12,12,135,17,81,209,32,12,131,60,0,153,66,201,121,182,155,39,109,173,1,186,45,253,219,88,63,179,91,22,106,108,66,107,17,105,97,59,6,133,136,82,129,125,190,184,234,131,23,198,146,94,243,204,25,190,50,160,81,176,220,38,215,41,120,112,38,74,163,171,24,106,116,214,231,194,77,99,71,195,47,141,134,111,103,119,122,241,34,5,170,123,150,232,85,63,156,112,76,202,78,176,136,79,161,164,245,223,119,235,27,8,99,121,57,0,225,90,143,129,173,209,102,133,158,64,233,181,113,212,237,35,132,15,88,36,85,226,152,217,11,16,251,213,25,7,85,125,48,155,221,141,133,205,66,237,6,5,241,72,247,133,199,177,78,236,71,27,110,205,207,241,40,22,141,156,101,179,172,227,30,248,161,147,84,177,176,26,32,103,36,110,30,67,137,223,121,255,110,247,94,76,30,149,83,111,96,72,165,93,200,58,207,176,213,13,29,75,187,45,112,179,43,234,213,242,216,43,249,33,207,40,167,96,46,219,167,44,111,57,183,96,243,201,5,215,73,106,130,134,7,142,153,17,97,126,88,35,57,154,246,15,16,48,120,187,131,106,242,11,250,99,54,230,135,88,172,62,208,30,127,145,236,44,247,246,202,229,174,206,139,144,172,167,141,73,106,163,33,202,57,80,76,67,219,18,99,153,119,22,223,8,132,90,173,119,88,241,34,158,228,149,129,248,73,110,153,176,170,26,33,117,151,227,204,107,181,26,21,245,164,236,219,77,199,199,35,205,68,49,148,238,100,242,214,99,155,100,23,181,56,99,13,119,225,107,153,143,182,246,225,208,95,196,75,114,87,98,134,84,115,210,91,16,159,38,83,255,6,141,147,176,178,28,7,98,154,157,117,22,186,222,203,229,195,97,78,111,21,1,209,7,216,220,49,206,103,113,12,92,248,125,213,205,208,125,25,23,255,131,122,18,244,102,110,19,246,57,97,29,160,122,12,249,191,178,249,218,202,196,118,95,227,2,202,72,253,166,224,126,142,247,255,235,17,182,40,239,72,49,69,198,190,146,45,197,143,72,232,60,106,114,24,207,64,199,21,148,63,154,255,94,65,161,221,130,35,137,115,115,180,84,241,144,61,126,156,106,22,242,150,187,185,206,193,114,109,233,188,162,195,80,84,37,148,76,38,233,82,107,55,196,65,244,142,66,169,247,79,119,3,176,143,31,254,163,250,36,254,95,244,199,37,243,80,12,199,218,35,41,133,113,33,14,19,65,68,109,255,12,46,255,36,190,184,245,158,28,243,54,230,255,252,10,28,140,185,137,52,36,177,174,246,253,228,33,46,4,171,48,142,104,247,44,43,68,29,108,218,170,183,172,241,193,73,207,219,37,138,1,150,130,219,251,45,165,77,163,56,41,211,48,28,136,245,232,57,137,129,92,21,128,45,154,238,208,32,231,214,120,74,179,72,201,37,186,206,84,50,7,123,49,12,239,253,65,164,149,178,102,109,53,34,240,96,200,137,6,135,145,49,172,151,73,182,67,200,127,30,211,36,85,185,165,56,97,54,221,209,90,70,22,143,152,129,15,204,59,5,143,171,180,132,244,145,20,44,11,142,181,72,223,151,147,26,241,164,157,222,7,97,79,43,35,103,66,163,25,155,118,174,109,181,98,111,56,136,55,63,81,51,89,250,61,148,153,110,132,172,218,99,18,104,242,83,175,53,197,209,126,182,44,53,73,229,104,21,252,214,227,27,176,170,31,200,156,251,40,253,90,104,145,10,1,175,235,135,77,56,137,11,51,99,233,59,250,122,62,196,2,245,142,86,59,143,192,123,130,214,245,182,157,134,228,82,199,243,29,167,83,105,75,4,236,116,174,50,18,89,242,200,87,109,23,221,184,42,3,82,80,103,135,218,190,7,129,98,180,64,149,196,181,217,136,28,58,56,53,14,16,248,30,82,197,85,149,53,2,112,81,243,53,131,126,174,187,3,237,209,3,20,9,246,22,3,194,201,118,169,89,116,66,199,66,16,175,193,47,238,65,137,126,87,148,144,167,191,216,137,23,120,162,24,80,68,168,161,148,167,6,137,56,1,160,59,75,181,56,92,175,90,233,7,212,173,52,242,167,91,64,194,196,220,18,71,186,221,224,84,47,76,156,55,190,180,102,18,21,27,55,125,249,219,154,48,54,210,58,72,73,154,78,48,73,105,233,200,178,230,208,130,172,18,160,79,130,20,166,83,203,232,203,108,136,211,228,152,192,103,222,8,46,245,50,29,25,234,254,228,47,202,93,242,41,33,139,115,212,186,141,90,222,177,4};

// The scrambling tile of 128x128 pixels.
// Each pixel contains an optimized 8d key used to scramble the sequence.
// The keys are optimized for 16spp in 8d.
static const int scramblingTile[128*128*8] = {255,26,81,46,210,80,216,150,235,14,47,190,223,149,182,159,160,255,54,85,161,102,135,123,216,106,9,110,130,174,139,166,199,170,247,229,45,66,82,16,197,6,168,233,202,164,88,141,36,133,21,166,7,149,79,47,248,26,76,207,201,197,14,230,173,242,86,228,214,211,67,213,243,68,75,144,244,220,158,218,42,219,82,73,81,52,250,231,108,189,229,27,79,24,126,208,168,255,120,14,240,101,202,64,88,169,33,157,251,44,246,232,43,31,126,197,5,71,249,197,175,161,162,192,78,95,154,154,7,107,157,51,145,119,34,229,26,38,38,182,122,61,173,247,19,16,213,49,160,211,143,26,60,10,128,52,36,129,74,205,203,229,91,233,209,135,132,46,118,227,111,67,28,81,109,80,163,237,193,84,172,163,3,127,227,252,8,225,48,126,95,154,136,96,4,27,172,123,207,83,219,209,105,254,159,38,81,33,216,112,23,221,209,226,244,5,28,112,199,49,22,40,67,41,15,83,125,63,100,80,156,63,162,8,105,21,168,227,253,53,211,2,14,217,195,226,194,207,115,175,10,145,166,119,12,245,10,141,178,11,13,151,128,53,49,186,156,132,98,5,190,182,217,157,61,82,48,56,45,108,175,94,45,1,199,93,56,175,129,65,154,121,201,205,193,22,189,106,194,198,61,125,28,199,200,255,30,175,101,84,245,132,84,43,185,104,235,0,118,146,229,245,183,137,178,163,232,202,239,212,1,129,162,133,18,110,88,50,8,170,205,134,84,34,18,226,229,52,116,242,186,220,168,224,1,95,158,249,139,228,54,141,117,228,164,182,101,62,50,23,185,49,111,77,45,141,144,78,14,232,81,82,5,248,238,162,0,15,194,194,17,71,169,125,2,170,42,235,111,206,160,250,63,55,40,161,96,137,233,25,221,40,237,74,199,149,221,48,212,238,56,101,108,8,200,1,34,70,34,74,59,233,6,46,145,157,112,45,138,148,71,191,234,230,105,217,191,35,254,222,66,25,208,190,42,81,205,44,38,85,11,35,185,234,92,50,27,223,105,36,171,144,27,46,36,240,2,225,19,158,66,117,33,3,75,148,233,165,71,210,204,165,22,138,251,247,170,90,185,58,10,151,245,159,189,153,24,225,59,192,196,108,128,0,229,0,124,215,53,17,147,167,13,173,240,6,76,117,172,171,75,106,161,154,254,14,192,100,74,215,233,226,125,109,52,43,66,131,167,184,21,39,202,181,108,236,230,145,139,254,114,52,235,15,199,166,155,175,74,229,251,196,169,89,37,11,110,241,156,205,181,98,182,46,204,134,208,194,251,36,99,40,220,149,123,29,64,252,208,0,136,215,208,10,8,224,56,1,83,19,226,156,156,243,119,58,233,223,97,162,84,42,38,32,185,165,117,148,24,162,68,74,87,130,219,157,228,145,202,236,106,247,192,195,232,90,240,54,26,136,164,7,176,161,160,42,164,203,158,46,134,41,222,231,203,252,179,43,203,75,6,106,214,227,209,37,218,97,193,135,207,27,165,255,188,70,196,114,6,78,121,189,3,78,81,123,224,223,96,143,204,40,18,67,172,143,18,157,212,1,193,78,164,115,152,57,205,120,97,64,147,240,185,36,53,171,184,113,46,247,200,230,47,158,198,53,222,199,157,141,26,164,12,42,207,31,152,22,222,198,197,198,57,134,112,37,144,241,89,143,17,162,117,92,58,161,68,22,136,10,43,181,155,98,190,113,211,222,118,182,91,61,200,9,128,142,182,73,147,175,230,193,83,223,209,209,19,18,60,244,122,39,19,246,59,243,208,191,148,122,120,0,80,231,175,36,100,25,146,59,131,25,245,5,120,8,3,242,57,124,252,132,226,188,34,230,127,124,246,172,23,66,59,222,225,119,237,11,104,63,132,150,109,7,105,210,17,139,153,213,13,20,250,175,192,12,240,86,212,140,66,220,91,57,207,207,112,1,69,249,240,54,242,125,229,162,89,218,24,76,103,193,214,41,60,216,84,78,25,54,251,74,80,184,113,190,236,212,52,144,179,185,129,230,15,89,158,64,185,214,170,204,219,194,244,76,66,22,119,119,72,44,58,97,188,21,107,66,37,182,80,148,158,225,30,125,122,249,115,125,54,249,220,75,186,194,109,48,11,34,173,109,12,89,51,184,23,247,175,154,11,242,254,156,147,54,27,11,246,0,130,99,243,191,23,144,186,12,209,76,193,29,186,83,56,9,120,55,14,80,170,96,188,224,43,40,216,226,89,157,128,117,231,125,211,21,69,31,253,39,251,196,62,249,242,251,138,248,229,240,127,164,91,21,137,31,136,23,116,194,28,67,163,147,156,232,204,65,216,141,102,0,160,71,204,222,108,203,58,239,135,12,22,207,239,166,106,96,88,47,247,17,189,14,12,114,127,110,204,71,47,151,172,171,142,203,65,60,247,1,240,61,29,247,252,36,217,124,90,183,232,228,246,168,201,179,65,94,226,241,209,188,237,99,224,164,161,103,87,97,229,246,232,103,239,121,198,97,77,145,236,65,179,54,37,238,204,194,235,207,106,209,83,167,141,20,190,253,87,204,129,16,95,141,173,169,109,72,225,79,146,63,123,30,160,5,40,223,6,181,251,46,11,45,161,102,121,13,72,191,105,48,52,77,180,82,72,223,245,143,182,230,27,79,75,31,161,153,247,225,31,164,103,24,179,88,199,220,196,121,85,134,51,49,200,57,209,66,37,137,213,55,190,21,48,9,238,188,112,39,183,31,44,52,67,98,168,95,237,9,165,228,107,221,219,46,250,35,19,22,237,122,239,66,104,50,72,221,29,195,48,99,209,194,182,31,19,238,31,232,20,92,182,57,82,143,40,111,94,17,178,145,182,48,246,11,117,191,104,38,102,7,15,97,137,8,111,11,28,66,174,57,250,229,98,120,217,139,16,12,235,156,176,158,40,96,0,16,83,222,179,66,60,59,2,62,9,181,117,242,255,235,26,67,106,177,41,148,165,85,82,254,115,44,197,124,250,81,184,235,213,156,43,90,236,36,121,142,66,75,110,186,54,23,106,195,176,233,52,206,129,126,215,108,81,98,108,156,156,89,59,136,63,107,180,166,113,88,81,218,146,135,9,165,122,29,110,101,182,160,119,20,70,244,47,198,67,163,210,14,211,39,0,16,94,155,6,138,207,2,222,231,230,243,223,184,226,154,98,224,14,122,92,202,190,243,132,169,114,157,105,246,80,120,66,79,17,68,125,224,225,50,6,216,190,207,103,223,170,37,21,198,205,198,185,195,96,72,217,22,236,111,18,247,78,214,169,106,186,67,38,203,7,22,150,42,172,52,65,218,97,250,187,80,219,172,65,16,239,12,171,17,212,73,127,94,73,205,183,32,208,189,255,114,238,152,40,203,236,5,134,253,241,194,55,129,48,104,55,12,136,141,247,235,107,43,183,150,127,173,245,174,64,253,144,52,44,51,178,189,44,32,143,159,78,186,161,232,180,238,137,246,84,155,26,85,81,63,65,152,75,170,191,85,49,223,149,127,221,135,149,83,9,149,245,159,214,235,97,105,117,111,184,8,161,68,238,60,255,63,65,43,230,160,166,35,232,66,152,142,204,4,91,184,138,79,22,59,191,16,215,191,202,50,230,196,215,243,107,47,106,80,177,206,127,236,151,12,125,24,135,249,38,92,101,149,102,206,199,226,88,3,163,166,9,64,68,158,78,33,242,187,29,178,43,10,132,13,223,182,77,71,212,116,166,193,3,198,104,253,153,131,17,184,45,35,189,216,154,59,255,38,24,167,186,4,33,141,77,32,229,200,171,142,147,136,149,104,169,98,11,213,182,76,27,134,179,58,188,71,250,141,69,11,181,128,180,160,89,207,229,234,20,0,148,88,171,83,182,162,233,159,238,40,35,121,20,206,51,211,49,21,177,145,146,171,232,217,0,199,9,112,239,106,214,229,253,201,55,198,164,13,217,136,101,242,218,7,204,17,21,175,80,102,203,40,206,94,231,133,82,182,111,203,219,51,129,16,49,107,63,137,126,195,91,218,14,7,169,154,160,130,168,233,112,79,185,251,164,8,174,64,58,45,51,192,68,78,160,222,122,221,181,95,43,74,161,151,226,208,200,21,162,44,88,44,42,88,143,89,103,31,193,155,176,99,133,120,204,215,39,64,41,46,69,86,133,217,91,188,7,122,147,242,222,33,191,74,57,131,215,54,179,93,162,232,3,60,84,145,87,128,187,41,239,69,86,11,64,221,42,157,120,25,21,249,115,130,241,169,180,196,87,238,59,67,29,28,196,18,192,189,233,21,113,33,251,235,102,115,216,185,156,148,173,229,151,138,217,91,73,159,242,177,122,171,129,209,222,177,46,125,237,220,206,222,233,129,117,21,224,16,104,162,29,138,83,26,51,177,36,80,236,153,126,228,159,74,230,193,133,222,156,122,143,168,52,112,204,219,28,25,247,192,194,130,142,200,201,5,58,173,254,38,86,195,183,76,10,88,28,12,209,110,52,149,124,92,11,109,187,161,228,128,53,86,24,161,76,120,182,121,197,104,219,54,113,154,35,14,111,15,66,90,174,78,167,126,164,56,132,46,52,195,36,171,68,1,47,250,234,6,238,145,164,87,120,36,65,72,46,207,49,217,59,1,252,242,178,99,136,117,89,20,164,188,85,162,50,123,55,205,108,11,74,253,10,234,86,217,102,86,196,159,141,141,141,159,179,236,222,47,227,46,125,210,155,224,57,21,157,200,167,151,245,251,192,252,245,131,68,203,255,204,48,54,152,116,143,107,176,94,178,186,17,221,94,10,120,197,42,173,14,145,98,151,197,66,114,246,9,195,122,215,74,227,13,186,59,250,146,78,168,108,145,140,175,117,68,48,178,240,20,60,245,27,13,174,135,174,189,87,27,146,44,186,152,141,124,199,9,141,131,69,128,31,155,201,4,95,142,34,186,136,205,141,72,168,171,46,42,219,174,141,177,226,73,102,202,238,102,161,239,237,98,139,157,216,241,204,199,48,14,155,181,34,18,244,215,232,93,91,127,116,128,225,54,31,41,13,84,3,98,40,254,52,10,57,195,24,127,155,25,177,149,243,72,162,207,133,12,67,47,89,255,110,168,211,160,85,83,212,33,67,102,217,84,60,74,230,171,254,226,24,47,43,149,180,85,120,234,97,254,208,16,188,36,113,247,221,74,52,152,172,139,125,127,198,236,58,210,191,74,25,36,14,46,69,36,91,73,184,183,211,41,3,211,110,18,39,131,30,198,33,58,28,222,174,102,218,123,154,171,245,160,191,70,211,251,58,163,173,48,180,221,125,46,178,117,93,121,212,107,246,55,67,239,143,83,88,210,68,116,161,141,144,36,81,196,246,27,184,238,254,76,75,163,11,20,148,134,30,177,215,35,150,114,129,175,215,106,244,232,121,233,23,162,28,2,57,233,249,226,237,212,110,76,124,215,129,228,105,21,244,162,234,40,162,7,63,64,66,77,82,159,50,86,34,189,51,69,255,180,57,19,57,106,208,11,225,201,66,115,204,124,227,24,253,99,45,171,227,195,175,44,121,167,136,37,173,245,55,243,34,153,41,47,87,224,33,114,152,125,167,30,212,183,102,170,173,198,11,229,251,183,182,166,98,83,34,116,164,74,157,74,139,214,35,12,26,31,216,74,201,74,139,52,238,247,244,233,128,60,8,18,78,227,216,45,160,17,243,56,145,233,59,177,250,146,145,209,64,32,83,244,68,51,204,184,6,231,106,127,200,167,109,151,128,152,39,88,67,168,170,61,227,96,171,125,185,135,162,146,169,71,229,37,68,146,36,45,184,30,96,93,94,30,121,179,216,177,107,129,115,4,170,6,94,172,4,95,113,107,85,99,211,228,10,56,232,48,6,88,202,212,30,62,168,159,48,50,67,85,107,63,179,143,110,202,210,28,250,247,148,51,62,193,174,101,159,141,56,177,23,109,166,210,40,108,22,55,22,119,128,41,30,161,47,78,112,213,62,116,184,44,51,205,122,44,229,174,37,121,201,223,118,40,79,182,18,213,27,37,254,194,49,170,188,182,198,148,214,252,191,148,136,199,61,163,102,234,172,49,133,180,175,46,24,90,175,205,252,194,179,64,63,187,154,205,183,92,81,140,231,111,104,6,104,141,174,28,238,30,160,211,91,99,127,143,168,66,181,112,86,166,237,103,113,100,44,100,156,250,228,122,50,75,62,248,132,134,134,219,138,77,123,148,117,114,171,129,159,15,146,237,189,3,185,62,7,79,131,16,112,89,140,242,252,193,4,147,4,201,156,188,18,198,255,157,27,102,131,183,252,40,166,73,38,18,151,130,111,35,146,104,45,217,169,171,113,158,125,137,21,215,93,101,147,11,74,171,223,150,238,21,76,43,235,174,154,122,187,184,125,188,58,243,202,108,127,38,9,87,4,68,177,121,80,9,213,132,218,57,245,237,215,140,228,254,199,109,91,21,253,206,245,179,54,52,130,101,53,134,175,33,2,4,19,194,182,21,235,83,161,22,65,6,92,188,74,33,190,43,127,132,72,157,55,28,25,12,213,157,105,107,146,8,7,111,240,39,139,3,240,72,16,103,177,252,132,157,100,114,85,179,85,246,202,236,128,72,173,196,242,227,238,231,228,42,177,30,10,240,157,252,58,3,25,248,98,173,242,76,139,255,60,231,117,116,152,29,249,139,32,202,231,131,232,49,85,133,100,22,146,78,133,157,53,57,104,62,182,50,37,48,159,32,71,70,203,53,215,169,142,232,61,28,218,14,218,129,211,196,5,101,197,109,151,178,193,149,1,31,84,171,240,150,17,167,169,23,145,23,245,115,192,216,46,91,147,38,174,3,5,198,11,105,176,143,189,11,73,113,220,180,150,234,171,104,6,137,228,16,71,216,159,50,31,31,229,38,216,178,98,226,5,179,51,47,53,197,173,221,117,155,5,166,173,15,206,29,221,180,28,150,218,159,39,191,106,71,187,147,14,215,46,207,127,8,203,143,37,163,193,18,150,195,156,43,74,24,114,224,144,14,232,41,33,191,246,206,44,167,225,132,54,179,101,75,41,181,132,188,254,168,2,126,36,79,206,28,58,37,207,51,202,95,129,181,89,89,216,209,107,228,243,70,32,82,252,145,198,43,198,127,6,183,78,42,184,252,103,219,57,168,28,88,89,53,133,137,189,183,41,162,144,44,173,136,62,60,117,193,128,66,125,107,122,133,149,127,168,234,174,176,17,99,176,148,120,64,89,155,31,96,196,87,242,175,165,197,114,212,214,21,35,178,147,63,148,217,205,181,13,59,12,165,99,141,254,178,190,156,14,222,42,5,59,150,232,138,28,45,36,1,133,31,174,255,148,22,29,154,48,144,154,118,57,63,39,198,222,32,239,50,102,152,184,88,129,93,172,124,8,163,51,191,22,222,149,24,171,74,189,150,138,167,107,174,205,26,171,43,248,226,71,107,93,26,110,63,222,128,25,179,187,180,177,135,54,104,190,40,50,189,64,83,141,81,68,203,8,197,241,0,107,7,136,23,133,36,145,29,30,67,170,239,103,63,121,122,205,42,236,187,148,127,109,244,137,142,95,211,158,109,14,186,171,76,3,185,48,23,163,192,181,31,242,229,69,208,153,162,240,46,155,165,250,89,150,105,240,119,222,25,124,82,236,169,134,53,97,73,32,150,217,74,123,5,0,223,129,124,254,161,217,164,53,254,40,74,121,37,97,166,167,225,196,87,176,162,93,217,169,51,207,179,159,214,72,32,99,152,195,151,149,91,101,17,8,205,129,180,0,158,213,21,168,51,182,10,133,199,84,46,87,245,69,56,27,16,190,44,243,128,246,192,85,253,70,169,192,254,118,189,41,134,80,56,184,120,120,46,254,90,27,137,174,104,64,228,64,81,82,222,135,61,13,161,66,120,164,227,144,107,157,25,97,242,222,165,117,97,247,248,213,21,85,64,20,130,115,238,186,143,192,223,181,136,13,238,236,85,67,189,193,112,91,153,144,253,167,59,138,65,45,249,119,92,228,2,38,181,183,216,240,133,192,36,182,96,9,232,78,2,197,99,103,60,117,60,106,113,87,119,45,184,119,80,111,157,251,130,232,185,188,206,177,96,126,81,182,25,118,100,219,69,72,37,108,59,212,90,250,72,180,84,150,51,7,74,14,241,14,214,249,139,68,108,122,225,215,123,201,50,17,193,102,218,153,10,79,128,197,66,91,1,190,58,34,158,214,254,131,35,70,85,25,63,115,235,177,31,124,100,232,241,32,28,7,189,114,3,180,48,82,89,24,21,108,40,230,103,145,110,147,215,169,234,205,137,165,198,231,190,166,106,231,247,154,174,249,190,47,179,109,24,88,63,94,188,241,128,8,71,77,56,43,209,233,201,33,188,109,130,141,30,233,130,159,41,97,121,39,176,239,178,4,114,58,14,135,122,20,30,33,116,184,16,165,202,15,121,30,189,22,106,27,125,191,108,162,193,55,77,138,179,215,128,255,98,12,114,160,202,29,4,219,197,227,102,80,252,61,94,130,240,196,68,176,177,20,191,120,156,0,35,104,88,43,252,28,152,162,220,14,37,130,167,36,150,242,188,146,129,140,235,37,228,252,65,76,237,218,198,189,45,241,222,74,54,133,87,193,114,83,160,116,200,165,124,69,154,227,146,79,172,176,206,178,55,132,111,66,113,90,73,145,239,78,129,186,245,241,182,190,234,111,108,38,178,226,108,90,143,234,35,174,12,45,176,69,192,134,94,152,131,133,174,17,245,44,52,78,109,70,211,198,125,117,4,55,250,102,73,142,173,75,10,104,172,99,226,33,215,32,147,9,96,211,41,161,86,249,86,81,90,45,47,248,89,179,150,112,202,132,80,92,15,193,147,92,187,17,132,188,169,201,188,188,101,37,201,112,126,0,205,164,238,136,187,89,100,109,62,159,145,145,172,138,132,168,86,20,151,195,241,43,57,51,56,95,235,14,2,57,238,95,41,179,18,40,190,99,229,240,38,147,124,48,187,245,238,221,29,26,99,40,7,251,184,206,211,64,249,131,90,140,125,243,155,238,118,102,128,70,164,48,109,149,208,236,188,95,89,103,161,106,212,144,243,64,24,116,92,3,181,155,107,52,58,73,99,51,200,28,158,4,51,213,64,163,128,172,190,1,147,152,185,225,81,235,56,63,218,138,197,128,114,85,183,41,119,94,188,217,28,169,35,191,25,212,41,11,234,156,176,235,25,70,40,162,131,158,12,68,137,45,227,183,1,149,240,32,180,135,69,39,107,136,185,40,69,54,159,235,204,9,219,112,215,8,191,168,238,242,127,16,195,87,233,221,179,79,13,208,87,138,240,250,127,46,222,35,231,146,164,43,70,36,185,207,38,57,165,164,57,131,105,212,232,124,48,23,171,146,197,158,96,202,92,30,67,206,231,14,72,19,116,132,119,200,101,18,35,213,218,202,92,219,175,182,204,8,207,254,91,37,47,151,73,14,170,33,159,177,136,200,238,4,141,160,152,95,103,104,225,112,97,225,138,118,141,176,161,97,174,63,120,218,181,95,151,156,253,227,236,232,105,31,76,160,81,147,161,46,53,214,88,2,182,167,214,80,0,33,114,241,169,51,222,120,188,144,191,48,231,185,249,111,27,250,240,171,110,63,106,210,130,148,110,19,9,233,183,155,135,240,230,132,209,189,196,92,248,229,217,15,34,103,106,49,223,228,186,181,61,177,80,163,128,147,134,63,195,94,137,17,46,190,116,96,183,1,5,94,98,255,140,54,170,149,14,72,227,4,132,131,189,131,237,218,240,247,31,7,141,237,218,254,188,53,178,97,216,175,182,20,122,195,210,237,64,124,204,192,114,208,186,212,94,27,243,185,224,101,165,233,41,4,191,12,43,59,19,116,64,119,157,156,216,23,241,89,139,84,177,196,90,129,180,186,233,126,166,47,176,56,91,0,216,220,222,119,150,217,227,208,194,250,71,217,240,217,253,235,209,20,58,117,150,60,223,206,152,126,189,64,55,109,247,10,35,96,137,122,142,235,164,113,151,8,70,62,74,11,200,22,17,219,200,97,42,2,56,206,218,232,219,55,197,183,95,60,254,85,133,254,13,90,196,0,3,211,186,237,199,93,159,84,147,180,19,115,26,250,157,199,107,149,156,37,160,212,135,180,241,31,48,78,200,205,229,176,141,235,25,98,197,19,48,222,26,230,36,31,240,105,100,171,19,47,126,94,221,37,119,184,250,240,167,16,172,61,195,237,202,87,166,228,183,79,107,51,22,129,162,59,129,152,7,223,215,127,95,175,13,242,39,31,200,16,136,217,152,182,10,184,215,94,200,110,14,31,118,167,19,125,7,89,129,187,111,134,196,172,17,45,248,64,192,210,76,158,218,64,38,232,201,181,27,131,112,40,45,154,114,73,6,150,11,244,124,35,144,12,247,14,158,79,50,223,150,233,107,28,22,221,253,213,118,15,240,207,116,136,171,228,159,43,217,222,248,157,218,135,223,53,7,87,225,129,188,20,138,30,184,173,174,55,23,240,146,52,116,164,111,140,215,31,66,223,88,184,1,77,186,238,177,54,172,184,56,88,199,26,134,42,159,19,33,114,50,220,29,199,134,246,249,128,74,0,23,178,252,243,173,226,175,230,151,81,85,77,214,93,46,85,213,129,204,146,220,134,88,139,49,95,230,11,167,134,138,30,135,236,108,13,97,1,119,59,104,30,77,177,221,117,157,166,160,60,6,233,164,219,130,159,146,138,33,137,245,118,232,168,116,101,227,87,11,212,137,154,126,52,100,133,21,51,203,49,197,202,30,13,87,49,32,183,52,186,177,8,143,62,129,134,162,102,190,96,36,102,222,155,82,144,125,230,41,78,96,173,117,253,211,238,236,246,118,13,127,181,225,152,88,174,10,108,67,244,114,77,138,153,120,27,249,246,41,75,99,69,227,89,238,199,216,16,206,69,40,164,237,172,222,75,231,169,168,159,205,179,166,16,71,64,228,231,173,39,47,51,153,159,103,71,160,227,122,60,99,60,123,229,233,251,20,88,135,200,134,207,63,24,153,82,125,12,153,153,247,166,109,44,146,4,171,8,231,149,121,119,254,90,232,100,32,217,103,206,36,123,147,95,45,148,141,82,7,184,239,23,22,170,79,112,239,76,190,214,3,4,79,8,247,189,40,73,230,153,218,71,117,193,109,138,84,232,228,176,208,202,255,145,89,32,213,232,237,106,208,86,236,37,70,254,73,232,121,9,13,155,150,163,94,198,39,225,196,225,252,187,228,134,126,161,98,232,135,64,77,14,178,78,17,213,221,214,15,61,223,11,216,254,216,42,60,0,166,10,76,7,114,217,116,132,113,229,39,143,150,165,203,142,84,126,80,240,203,229,207,208,255,28,255,169,254,216,226,43,175,10,74,90,119,96,150,195,35,109,228,94,202,166,139,210,75,37,247,113,36,231,169,225,16,110,248,82,243,17,226,83,107,135,49,78,245,221,228,142,58,74,176,13,24,34,12,14,186,12,15,235,32,69,98,5,218,208,214,116,239,254,113,219,144,126,31,252,157,29,206,212,26,102,69,26,113,138,210,56,102,153,201,62,237,129,202,67,171,189,160,164,205,242,152,189,252,181,177,224,49,34,119,0,216,80,130,168,60,240,51,55,53,238,121,251,96,13,122,88,248,252,133,50,184,241,97,127,157,133,5,79,14,170,193,99,135,49,12,6,50,146,79,229,143,124,55,180,54,191,88,133,154,236,149,18,236,85,39,58,118,84,162,91,253,107,227,73,82,238,201,210,17,43,225,225,26,13,46,235,247,3,163,227,88,38,233,190,105,30,185,246,115,100,77,70,22,136,151,148,42,30,218,94,170,145,230,105,92,231,164,217,233,43,223,246,185,97,40,189,122,51,144,210,129,125,60,159,113,110,146,101,84,186,127,216,18,148,126,0,143,97,36,184,12,194,131,1,253,26,9,160,63,117,191,161,165,35,62,132,208,76,90,8,108,252,148,108,230,195,118,83,238,126,97,14,44,156,77,74,175,3,13,9,22,132,39,237,83,95,226,50,200,85,149,66,135,115,101,78,178,251,166,110,52,62,164,123,97,204,26,161,250,139,14,98,140,60,128,59,91,157,141,239,240,126,101,48,254,227,158,110,78,210,48,134,36,202,33,230,205,112,122,156,39,234,47,106,46,169,112,54,35,140,114,223,71,160,194,58,27,135,120,10,206,75,234,53,27,90,244,230,174,194,254,204,91,73,111,212,5,34,28,77,121,211,187,15,250,111,102,230,41,159,249,69,222,95,174,120,66,169,126,64,139,53,20,19,222,197,79,73,32,226,253,208,168,58,118,202,10,236,161,216,169,181,47,130,133,240,19,138,34,178,216,76,165,64,106,87,232,168,177,86,199,170,158,202,202,209,234,149,160,20,161,201,22,104,9,226,143,161,57,105,40,194,76,244,35,46,229,57,185,6,27,154,106,110,13,182,252,120,123,150,101,155,23,71,193,102,110,219,76,168,188,6,65,122,59,56,106,187,175,73,246,125,215,210,92,230,171,33,140,178,7,97,183,128,178,120,116,164,192,219,51,155,80,84,131,222,200,78,192,51,87,136,249,224,120,3,213,58,194,205,204,169,219,11,32,194,40,250,91,0,96,149,243,172,26,134,108,91,67,177,84,163,213,194,248,246,2,50,91,224,189,82,51,99,111,103,36,135,118,108,187,197,117,57,152,196,143,125,128,144,125,202,65,25,148,149,240,137,212,226,182,195,103,196,95,142,188,168,112,56,108,160,197,220,114,235,252,166,103,110,89,22,128,45,220,174,73,72,32,34,206,76,96,112,179,27,67,44,158,78,143,31,100,72,24,229,250,90,154,149,73,53,8,64,136,231,202,0,55,125,200,105,35,82,57,252,245,68,62,82,18,32,123,85,18,104,22,168,98,157,203,78,103,30,149,1,108,11,209,171,114,240,44,177,136,71,65,18,203,165,24,53,199,29,5,119,46,30,97,23,97,190,216,121,115,172,34,60,226,138,83,117,200,111,5,145,190,255,19,161,10,57,212,178,157,89,53,103,7,30,205,95,111,124,154,5,191,123,218,204,61,105,16,227,207,131,63,248,31,138,75,141,32,57,176,230,154,221,148,164,42,222,252,45,118,223,120,18,39,176,68,31,188,81,188,57,246,135,155,210,94,3,239,90,100,139,94,161,254,29,27,182,102,43,203,35,11,161,141,71,204,134,7,152,175,218,193,72,206,250,148,38,110,74,57,24,64,236,62,72,219,140,230,7,57,158,52,160,162,160,37,113,103,195,120,170,155,192,86,185,52,37,96,26,207,206,137,188,57,141,172,138,156,188,225,56,244,7,87,137,208,48,214,97,250,210,77,12,11,30,185,44,41,104,53,33,220,5,158,114,81,132,50,217,17,51,149,55,174,92,35,80,176,208,25,121,23,192,216,236,21,215,213,148,97,164,224,238,30,37,161,127,152,219,64,96,165,121,131,91,230,67,77,11,170,148,81,206,156,17,109,178,13,124,141,243,224,195,63,210,227,123,91,220,213,126,40,220,13,242,172,235,255,164,119,196,253,171,186,135,65,147,144,6,61,198,147,163,0,142,151,186,251,227,125,141,98,152,30,128,71,155,168,46,160,215,87,190,216,170,201,174,179,241,216,18,16,234,218,204,234,0,133,74,2,44,213,97,9,56,162,219,121,211,169,221,113,240,27,55,155,225,225,24,56,118,95,2,173,117,239,40,24,178,180,17,69,167,205,52,7,138,227,232,88,139,36,161,42,187,6,247,71,199,229,136,120,70,204,107,164,248,53,191,171,114,30,77,159,239,90,42,44,125,90,162,187,229,49,99,230,0,149,43,86,115,50,132,207,238,95,14,86,59,66,98,49,198,104,138,145,172,86,47,197,171,253,249,210,245,251,100,91,44,166,170,43,179,172,153,248,94,154,96,63,124,182,72,72,81,89,145,233,139,249,220,162,130,181,66,53,49,13,226,232,37,248,106,210,12,47,229,119,186,183,149,130,70,97,26,200,184,177,40,142,229,19,163,227,142,9,37,134,206,44,179,79,133,193,232,93,98,246,32,13,228,94,166,226,225,249,243,228,120,164,45,4,220,1,219,249,90,59,81,182,169,140,158,20,140,231,81,62,11,38,117,22,186,254,140,255,212,23,211,40,37,14,241,211,199,109,70,123,46,4,89,203,183,197,46,209,208,122,116,208,142,255,18,106,82,253,245,199,207,144,127,176,47,90,10,62,45,192,190,226,141,1,196,8,178,145,28,179,62,138,140,119,84,160,219,34,71,33,41,3,254,24,15,38,18,10,165,73,237,179,223,72,225,10,55,251,33,247,204,64,118,88,117,150,107,98,131,214,112,213,8,231,102,68,203,228,46,121,252,141,116,84,6,218,136,59,168,91,215,167,248,17,44,87,210,15,202,50,82,161,208,50,186,101,36,44,135,69,233,11,38,148,252,24,23,237,135,100,230,118,249,132,10,239,172,190,233,43,4,105,111,109,36,82,143,75,227,97,54,208,109,156,7,204,124,129,5,42,130,14,54,75,69,215,117,5,11,22,71,94,92,218,188,166,9,238,41,232,86,39,137,107,78,43,202,12,59,100,134,146,117,28,122,95,38,249,134,12,92,0,12,41,60,59,249,147,151,196,115,45,170,40,230,207,211,46,120,235,57,218,211,23,22,53,180,191,138,231,100,153,102,214,80,22,185,100,222,17,84,184,139,70,92,182,35,164,173,156,118,235,32,129,176,210,100,57,141,255,13,73,231,176,189,216,184,182,87,117,67,6,65,48,76,244,76,58,86,177,51,82,132,151,228,204,104,125,127,224,234,10,70,106,246,206,35,91,74,148,220,115,217,253,92,119,64,249,99,198,87,119,159,23,148,134,194,40,9,63,222,241,61,155,236,11,2,106,195,20,19,36,2,239,147,225,239,170,181,157,180,88,79,76,239,134,45,235,12,118,140,133,210,181,132,151,160,87,147,255,4,135,14,42,171,97,142,69,122,166,110,224,242,97,55,149,68,82,6,213,73,202,48,155,132,157,165,147,142,84,49,252,91,63,72,145,88,220,233,70,134,156,198,0,92,220,36,250,227,52,127,122,27,182,48,52,153,17,113,135,89,53,110,137,67,7,221,86,233,176,140,205,247,63,24,241,155,11,232,217,218,14,146,231,248,218,39,125,201,160,11,7,255,199,40,25,166,9,80,168,171,85,46,171,39,29,93,132,33,69,119,12,141,97,116,43,40,124,239,100,190,57,80,193,90,151,196,128,45,53,207,9,254,215,167,125,108,223,168,5,172,5,209,208,166,186,164,89,212,241,100,113,119,9,131,95,118,9,143,218,127,85,152,13,121,9,220,9,116,96,195,117,46,148,237,129,110,185,48,18,241,149,9,69,50,205,207,79,251,26,21,31,130,40,119,69,97,4,24,35,246,180,216,167,55,24,219,77,159,170,9,60,52,249,77,50,196,170,48,68,24,80,74,200,25,100,23,0,100,174,205,84,29,192,103,198,67,104,65,67,201,181,241,160,52,116,0,63,197,214,142,53,184,76,20,42,242,233,69,31,74,89,5,71,237,150,48,180,70,12,178,124,156,162,180,100,249,178,182,35,198,25,235,143,223,26,229,112,219,252,60,208,170,181,116,138,137,192,130,30,0,67,237,66,180,133,170,160,196,180,73,189,126,240,125,189,250,196,124,98,40,1,198,201,230,64,157,170,213,178,209,120,236,233,131,203,167,79,80,119,172,186,67,252,11,239,19,40,16,111,245,106,90,131,136,1,31,94,225,231,224,16,13,160,113,118,210,209,251,162,99,243,55,132,109,143,5,157,180,239,0,152,70,0,2,111,170,228,150,235,236,205,137,113,13,233,249,218,86,73,250,99,164,0,119,36,16,247,151,35,215,230,50,215,233,153,149,82,47,230,150,71,16,30,44,205,50,15,24,118,22,9,15,156,203,65,190,133,186,51,240,132,0,149,141,61,95,240,108,170,90,155,188,138,238,69,58,137,16,100,193,208,31,128,11,163,144,238,104,118,35,186,54,211,83,243,66,233,251,19,159,189,74,70,129,227,104,16,25,142,163,251,144,22,133,39,51,173,71,142,199,125,127,155,102,173,37,244,118,194,213,243,123,225,85,222,213,190,132,139,199,194,60,239,248,221,26,189,250,118,210,24,250,74,17,116,160,239,247,110,230,214,92,7,23,81,129,217,12,110,180,90,189,120,112,146,113,96,118,241,191,162,138,91,238,58,126,153,126,5,247,65,129,217,204,147,211,189,114,43,73,221,26,43,14,66,234,219,142,67,4,40,177,2,63,255,147,61,133,68,194,204,36,171,250,240,137,132,136,211,209,56,10,193,176,121,13,255,222,239,36,21,184,254,101,61,116,71,44,63,15,1,125,239,129,174,149,18,55,191,223,153,114,33,58,244,81,163,226,177,139,67,171,66,204,7,140,32,47,214,71,255,254,61,8,81,19,44,235,84,241,218,86,154,249,102,193,122,73,234,253,215,65,219,17,157,177,23,163,87,224,115,206,42,8,124,87,113,178,4,127,153,0,89,234,251,250,160,192,228,82,46,189,138,24,174,224,142,68,158,89,115,226,231,2,184,24,12,252,206,112,235,245,172,58,102,243,6,155,235,26,163,80,124,35,85,66,5,213,165,180,133,196,237,125,58,160,103,237,44,196,7,57,134,72,238,163,42,136,56,247,118,127,139,232,94,11,223,117,98,1,7,61,66,47,48,229,94,78,202,20,173,21,123,92,144,215,145,70,194,85,20,113,42,46,93,247,224,72,145,30,68,57,195,44,3,96,0,184,114,114,108,255,70,107,167,80,6,93,102,3,251,97,86,84,223,109,141,124,167,210,233,229,125,230,100,201,191,112,195,50,237,57,247,213,242,114,47,175,207,6,121,252,137,110,158,61,203,79,214,51,24,27,165,53,111,60,45,17,196,100,57,65,86,181,199,238,4,58,181,1,80,247,87,104,193,236,192,124,41,151,200,218,232,209,60,11,246,95,50,253,26,207,183,40,228,66,123,140,221,191,123,253,201,30,212,239,204,121,137,242,109,65,203,10,168,166,132,103,129,71,156,152,200,186,203,130,141,48,192,47,50,109,187,86,130,201,102,170,113,95,189,178,131,247,148,41,40,145,104,191,158,92,148,65,168,62,109,175,61,64,123,187,181,92,143,171,54,41,149,231,130,22,43,207,129,116,239,65,138,56,238,220,220,107,221,140,119,231,202,85,112,129,113,127,151,197,184,88,30,246,193,152,142,91,82,129,200,85,73,180,184,243,18,127,36,217,40,70,81,112,226,127,114,79,174,183,189,64,44,209,75,237,26,196,145,230,207,191,85,195,229,126,108,219,177,93,230,31,86,197,176,134,59,204,223,83,203,192,2,209,29,166,116,6,53,32,151,102,31,7,150,207,175,240,83,70,33,155,89,68,139,184,82,99,51,93,8,177,63,87,132,79,37,37,73,148,75,40,151,168,109,24,191,181,17,221,116,67,20,45,236,167,188,219,142,143,7,187,37,148,132,193,72,16,34,189,63,105,100,175,114,152,81,132,116,129,63,40,251,67,131,221,156,112,56,233,95,161,207,49,94,12,229,76,28,18,150,16,160,49,194,94,129,90,215,192,201,32,140,211,164,114,61,118,154,111,93,41,147,74,70,168,156,230,53,1,52,40,89,150,32,96,163,22,190,81,58,230,111,146,201,246,21,63,228,223,59,158,78,31,154,189,201,61,157,117,234,17,77,182,248,53,135,57,107,16,53,42,116,47,115,189,162,40,35,100,128,58,239,55,135,189,253,64,215,21,189,28,232,211,79,0,14,188,198,8,246,23,67,43,36,164,113,250,97,29,121,97,144,33,81,140,253,252,223,119,1,168,190,96,129,156,141,197,116,129,184,168,166,59,104,167,59,181,150,53,157,227,2,133,21,165,229,51,66,178,56,180,10,22,159,7,74,123,9,168,67,10,58,92,121,14,200,50,14,241,51,125,91,101,17,142,94,48,231,127,28,165,182,27,228,108,221,253,76,29,41,58,236,155,123,10,200,139,145,94,149,197,173,25,221,255,86,35,190,15,165,219,22,251,110,102,250,59,162,16,55,201,6,153,232,114,85,230,162,209,251,145,153,126,180,228,237,46,250,234,240,130,227,161,147,95,231,176,196,81,105,190,95,117,36,155,30,196,12,164,6,219,12,140,75,68,213,136,14,10,6,46,193,245,147,237,237,71,138,14,145,60,122,135,178,62,103,238,89,226,99,93,75,153,172,215,139,216,146,27,118,161,61,95,88,159,172,216,119,97,120,80,125,12,145,121,70,232,218,89,94,81,39,109,116,117,221,221,193,103,139,132,206,199,204,234,195,223,104,205,119,202,47,235,209,27,96,146,64,226,235,60,181,7,160,194,94,198,134,240,145,36,41,230,71,173,174,215,202,222,66,148,153,16,17,209,142,25,48,255,73,193,189,212,202,36,163,89,96,79,116,73,79,10,138,22,6,181,165,14,151,29,188,2,91,191,83,121,174,232,67,194,85,106,245,19,174,120,254,133,157,229,233,103,57,37,100,83,237,163,132,179,228,133,128,18,17,147,8,137,71,26,62,167,71,148,197,215,101,107,86,37,22,131,113,166,73,100,14,45,213,130,2,4,197,114,59,89,82,122,240,169,63,90,10,126,7,114,69,114,172,127,45,22,160,166,52,125,129,200,233,84,77,40,40,139,188,115,177,140,70,24,248,240,8,207,232,117,232,182,67,254,163,179,228,229,243,153,69,94,193,140,218,165,67,137,0,81,127,246,142,241,104,150,99,67,44,203,58,17,115,196,10,78,74,170,132,126,190,176,27,56,121,121,171,100,21,162,103,65,108,132,237,32,200,120,46,11,134,125,137,193,163,109,138,117,247,136,8,127,117,161,41,139,230,226,18,82,129,37,133,67,144,163,202,225,33,219,198,92,43,203,111,90,167,40,101,133,35,150,131,16,94,254,49,171,92,248,74,29,241,230,78,230,147,184,9,0,60,157,34,235,239,218,181,112,194,62,156,40,228,98,222,200,239,133,130,89,202,204,180,8,195,241,151,68,212,2,11,249,48,3,237,231,170,215,86,89,98,123,126,121,135,179,55,68,121,58,185,203,181,104,243,30,118,251,186,43,224,121,113,189,36,246,174,136,107,169,172,86,251,26,161,94,234,114,35,59,2,87,24,238,32,157,198,130,119,57,114,45,41,29,223,226,239,38,213,37,194,197,175,72,60,208,204,125,9,242,150,145,208,142,68,88,185,102,73,174,217,160,29,224,173,5,31,42,91,159,198,165,121,162,243,124,181,21,67,185,94,245,125,123,122,109,91,150,245,185,114,27,118,165,165,203,106,242,157,124,4,83,123,254,133,37,143,11,36,101,154,0,76,175,126,123,215,16,225,230,197,52,203,23,32,166,191,17,1,246,157,205,138,116,119,114,5,157,198,156,130,3,128,124,200,188,55,24,9,228,111,128,236,0,43,60,237,109,4,95,94,33,159,104,246,172,202,52,195,70,27,96,208,173,121,48,163,139,198,100,207,123,100,250,187,30,54,185,125,153,94,11,173,172,127,215,167,153,202,137,109,62,38,180,178,225,128,53,17,16,54,149,225,184,127,191,1,162,135,105,242,145,126,196,211,58,200,164,47,73,26,205,14,8,98,82,159,84,232,104,236,39,218,21,115,208,249,78,225,217,145,7,35,28,203,110,81,200,156,67,212,165,34,14,223,183,88,164,166,181,94,166,40,30,141,29,119,186,153,111,50,210,143,156,186,117,220,73,239,68,44,109,66,15,53,250,183,173,149,99,37,209,134,69,90,204,107,43,142,63,90,66,120,121,221,241,112,230,18,154,118,166,122,250,181,123,153,131,9,169,29,207,119,10,142,206,2,142,165,124,107,34,131,146,141,167,166,192,131,77,223,157,210,175,14,176,177,115,20,171,108,73,248,117,105,166,45,9,209,233,231,69,63,205,61,204,210,186,131,99,18,113,68,198,144,207,252,117,115,131,173,34,38,150,80,11,207,135,80,131,77,173,191,137,140,231,238,250,200,117,69,45,216,88,148,43,248,28,240,216,238,68,0,122,245,174,122,152,140,211,244,95,225,90,201,96,16,13,243,158,149,173,55,245,184,90,53,109,237,75,209,16,0,210,137,11,125,150,109,18,63,114,114,113,62,199,41,117,136,1,4,204,215,120,156,174,186,107,165,152,189,21,19,166,177,215,19,146,163,165,38,100,179,62,239,4,56,228,131,47,102,226,38,153,137,155,97,17,27,12,216,27,68,142,248,92,32,18,54,162,251,23,148,245,35,248,130,103,130,67,92,250,108,6,44,92,226,207,10,3,131,157,209,143,36,197,74,254,213,207,206,170,247,237,4,146,146,220,129,133,24,35,10,232,236,117,112,131,213,141,144,108,242,210,250,73,172,155,169,184,173,71,9,89,208,10,124,41,96,99,126,38,201,225,216,28,29,18,209,240,213,54,56,178,202,130,64,36,39,48,34,142,254,9,27,7,22,225,43,42,8,211,53,88,106,8,234,22,226,119,171,118,99,255,147,246,166,100,230,96,15,228,163,95,10,25,48,132,78,22,36,192,122,85,70,219,87,194,55,142,23,181,79,242,58,26,226,69,74,199,174,47,157,26,121,246,160,170,198,55,203,196,204,250,51,222,241,20,62,81,103,254,101,34,124,144,216,76,67,7,221,8,210,17,185,69,107,30,68,9,5,58,196,125,94,245,75,125,222,177,175,16,77,187,82,78,191,41,220,27,133,162,149,28,74,3,164,217,237,21,109,199,165,202,10,86,175,20,253,185,194,167,66,230,107,63,24,139,63,59,31,155,29,171,4,249,8,191,33,104,62,12,208,51,136,141,66,139,125,173,108,51,21,162,227,42,37,60,190,65,104,190,222,51,97,75,168,148,72,248,215,246,17,110,1,140,56,158,241,141,63,227,7,229,136,16,216,229,227,61,111,130,71,239,236,34,20,83,150,15,29,75,145,193,19,130,149,45,185,130,140,30,15,115,166,93,112,72,136,242,29,72,154,210,31,99,55,137,27,42,161,199,218,63,72,2,48,232,126,168,96,216,39,139,198,43,62,219,159,221,83,114,92,8,238,173,90,102,184,136,248,8,249,228,150,97,80,150,114,67,34,21,86,73,130,190,86,234,234,171,38,37,6,34,168,17,122,34,38,165,16,121,153,236,73,177,170,20,143,114,7,64,143,157,221,89,212,112,29,132,227,242,170,55,78,243,134,53,186,81,30,110,29,241,70,248,233,41,131,212,95,60,190,55,26,12,64,28,95,146,89,180,118,98,111,168,22,194,186,250,224,179,143,106,58,118,208,137,212,50,61,27,83,75,129,86,185,161,225,35,9,136,7,186,64,235,56,204,188,18,157,177,44,111,23,193,6,106,218,182,1,207,179,246,97,76,248,62,210,210,202,153,20,100,79,96,70,84,213,233,183,15,216,200,239,2,110,107,204,6,210,106,217,170,250,196,192,47,37,201,201,154,206,231,254,208,126,20,177,152,126,159,0,14,139,203,85,151,161,233,139,169,132,247,145,39,153,109,40,206,16,122,79,172,93,84,161,94,228,175,124,59,49,79,112,49,96,209,15,98,205,42,159,91,218,15,114,242,215,21,246,76,11,151,95,198,4,210,49,89,168,75,237,30,240,244,56,202,99,78,90,29,36,186,42,148,208,54,178,227,90,226,173,10,192,40,205,44,227,20,207,80,134,231,54,125,159,94,62,150,106,195,227,169,222,9,192,95,99,55,181,177,38,147,179,202,229,18,175,231,48,81,60,242,246,87,110,230,138,43,2,231,16,142,110,165,244,135,90,46,166,229,38,157,6,129,78,178,241,3,35,93,219,168,133,181,57,216,50,191,33,116,60,233,248,59,45,155,26,222,94,233,48,108,119,82,242,120,124,139,196,14,215,184,94,109,41,130,50,254,85,224,241,26,12,249,138,243,89,173,102,25,3,102,139,114,177,161,90,28,244,116,133,44,6,41,215,60,172,54,240,82,238,174,107,144,20,161,232,97,164,94,31,117,177,128,58,137,33,230,67,101,247,143,159,143,157,221,70,160,69,1,161,12,29,113,74,120,2,196,112,5,110,36,72,237,244,126,114,164,111,194,214,233,17,252,123,42,1,24,183,228,78,227,255,125,70,6,91,59,58,235,189,222,82,53,45,198,198,109,32,126,3,62,32,150,189,116,4,45,148,153,8,183,194,87,15,15,128,224,77,4,114,212,89,66,244,34,178,111,81,146,185,16,241,69,4,233,115,247,230,20,172,213,9,221,206,157,88,218,232,138,19,34,212,225,91,109,186,74,165,228,123,125,41,98,183,138,234,87,142,209,14,120,61,138,72,147,32,178,137,162,255,178,248,250,250,140,198,44,123,22,251,194,248,49,86,100,93,15,64,112,178,97,241,183,77,112,254,14,53,220,177,223,83,152,242,254,175,174,68,238,175,42,180,75,99,229,207,75,152,193,185,173,207,154,245,106,217,196,252,54,170,119,12,48,209,56,52,236,199,75,16,10,37,236,41,184,13,67,248,0,227,44,3,100,102,40,25,35,225,252,70,203,169,10,139,218,43,34,202,219,32,215,227,65,39,14,9,236,16,7,214,109,166,145,41,216,196,75,44,10,140,135,83,169,131,180,83,140,99,185,121,29,0,188,213,141,161,87,24,126,219,30,254,165,200,78,150,165,102,69,54,171,189,106,70,64,66,34,226,44,97,223,1,180,103,152,74,173,75,83,9,60,92,46,220,124,82,28,211,212,199,57,239,3,201,83,219,132,66,236,71,25,118,128,124,216,200,86,202,10,57,107,42,100,122,160,150,98,8,245,239,222,205,186,4,211,253,47,34,162,135,253,125,210,138,210,130,104,119,30,250,98,111,162,217,43,33,238,250,160,31,211,65,183,36,118,142,177,121,37,86,156,69,168,10,20,217,185,38,57,12,158,14,72,48,58,91,131,191,157,37,150,57,85,155,180,128,22,65,216,137,82,148,53,161,225,44,221,203,80,172,120,45,163,236,170,76,134,50,103,57,134,236,139,77,86,78,115,73,169,168,143,223,8,30,193,180,25,165,107,99,40,179,211,138,93,164,225,217,222,175,181,216,84,163,206,19,230,227,222,121,3,101,229,221,110,91,213,189,49,200,222,224,186,234,33,78,179,102,202,18,67,152,145,181,105,96,235,72,155,99,114,229,132,166,117,251,223,208,127,146,189,33,53,212,230,32,228,206,111,234,184,16,161,21,234,228,171,31,99,178,24,134,146,191,154,161,153,172,42,164,187,174,72,49,75,223,55,95,108,67,237,158,77,11,96,199,87,133,51,87,64,44,86,8,6,112,147,162,48,196,10,15,204,43,88,215,45,121,231,225,96,199,119,90,254,154,26,180,113,103,33,240,244,63,110,173,67,6,186,213,71,36,95,36,211,5,241,3,248,181,251,255,124,94,253,212,37,93,149,63,243,11,239,29,115,24,36,176,35,208,103,37,224,229,36,193,123,147,59,55,186,251,51,51,129,75,89,50,202,171,189,111,120,35,12,59,139,4,91,89,240,242,23,24,248,203,34,226,77,83,42,64,145,212,126,172,73,85,119,1,226,254,99,54,173,249,210,66,34,147,138,82,166,93,172,133,146,251,149,215,179,114,87,6,59,92,151,227,247,225,73,220,47,68,207,236,149,216,68,142,186,48,45,21,41,51,167,182,53,232,86,30,226,76,207,227,117,110,211,0,38,202,220,85,105,103,233,226,213,238,178,120,198,64,244,208,124,186,203,113,111,211,19,122,40,60,251,185,104,211,240,27,135,124,159,218,144,243,106,17,93,250,56,126,34,82,209,202,89,116,130,249,74,133,202,209,98,110,115,117,251,75,249,94,162,63,115,52,246,201,250,209,212,251,163,194,41,180,129,110,168,52,12,191,148,18,197,120,124,115,21,166,216,50,75,222,7,213,31,16,84,230,98,111,76,66,172,155,254,198,244,83,191,230,5,209,5,223,203,66,194,89,229,30,189,224,68,140,186,106,95,119,165,140,50,131,142,208,229,122,239,214,42,253,112,101,210,52,32,238,1,61,182,47,185,19,107,224,238,69,200,87,209,224,51,177,136,73,115,245,75,164,95,67,78,22,66,135,116,211,23,115,197,36,19,146,33,222,177,207,18,202,188,21,136,208,251,47,119,88,127,108,245,134,132,66,249,85,153,239,176,113,25,101,105,132,171,245,46,165,5,47,50,114,18,1,4,69,204,32,208,24,231,137,44,44,123,243,13,54,27,173,118,144,22,126,45,203,29,1,8,184,175,126,78,82,22,135,137,50,65,113,115,38,110,190,66,177,3,206,223,44,203,72,111,94,55,172,48,175,76,97,165,150,220,167,14,240,180,148,164,35,209,149,18,49,134,129,81,22,241,5,68,251,46,91,11,60,71,141,75,108,31,7,34,149,243,69,116,16,8,47,107,31,141,229,227,159,29,204,73,79,154,13,127,20,63,239,46,152,164,181,92,118,42,242,208,101,19,225,78,151,37,72,90,82,244,196,233,61,124,121,72,141,228,244,96,134,246,158,218,53,31,156,112,46,21,41,152,232,213,168,153,242,248,221,112,39,83,188,198,41,108,139,13,225,143,176,224,94,181,143,156,23,177,219,242,101,27,109,10,193,88,131,237,236,164,61,115,203,241,24,205,226,138,224,104,3,131,201,232,159,20,167,92,46,214,15,138,81,70,13,195,49,156,109,2,174,13,104,175,206,201,74,182,48,6,2,153,145,85,104,36,202,178,112,235,27,73,1,204,42,4,225,95,219,90,47,201,247,204,229,191,70,84,21,209,14,36,166,101,117,11,229,105,126,159,161,184,232,15,212,83,70,189,36,0,12,62,155,192,218,150,12,112,56,38,149,174,15,169,113,9,33,30,134,83,181,110,43,81,153,124,181,182,11,103,53,205,16,208,41,184,80,246,117,179,108,31,59,87,102,222,63,163,173,162,174,136,164,184,248,26,1,163,52,145,12,75,103,185,220,33,105,81,108,72,173,189,69,51,74,196,215,8,221,146,140,31,88,156,12,208,217,216,183,102,87,181,236,46,44,27,170,67,192,61,2,197,75,109,13,180,55,251,144,222,54,170,169,202,65,76,117,200,191,182,75,142,90,96,133,244,67,210,242,145,27,82,188,75,78,176,12,240,230,114,184,248,129,137,124,120,88,62,100,206,104,61,58,191,222,227,173,175,255,64,5,208,236,45,79,112,21,202,12,129,120,161,231,124,108,217,174,136,64,51,192,5,179,215,72,85,177,239,86,12,54,236,158,211,76,91,172,184,35,107,13,79,76,22,163,30,7,242,133,41,70,210,112,83,225,34,187,85,104,113,56,207,171,204,150,123,34,34,81,212,161,18,158,166,181,132,1,216,174,49,35,101,74,59,76,175,88,135,201,60,206,45,91,119,169,12,40,227,158,230,51,159,102,45,4,104,154,161,119,43,14,89,81,117,187,160,146,79,58,52,231,224,30,172,25,178,119,57,75,183,4,87,42,167,46,100,39,152,219,115,65,252,24,199,204,148,238,127,43,150,57,151,229,37,167,119,149,251,182,206,8,208,251,138,123,70,71,184,162,179,175,136,211,75,194,43,229,93,143,143,108,30,120,67,183,158,157,163,193,118,46,170,106,82,214,90,209,90,182,14,156,53,203,159,43,110,196,31,80,153,55,175,116,64,70,80,181,225,221,233,189,109,19,182,222,235,236,246,130,12,234,117,176,46,143,66,5,80,71,54,251,62,116,158,121,255,83,123,215,20,24,240,121,24,92,19,221,231,162,145,75,77,43,109,253,123,81,251,85,95,141,83,231,79,93,53,164,196,41,1,156,253,176,135,252,109,108,109,156,183,98,169,234,5,186,155,24,200,78,102,108,1,217,107,5,37,179,155,240,192,246,236,149,121,181,37,12,139,184,163,195,27,181,235,91,133,254,254,233,51,191,56,232,0,126,68,245,19,97,223,212,170,79,21,227,40,113,226,2,7,205,113,157,208,110,3,197,211,228,162,131,128,193,11,43,29,68,214,144,76,127,23,119,136,66,10,224,97,46,230,51,43,239,52,113,142,103,98,25,229,25,174,144,243,78,246,244,125,88,99,221,255,30,92,188,10,37,61,232,13,44,201,84,216,19,172,10,120,76,54,226,167,242,122,0,128,93,119,80,99,140,148,42,8,10,140,141,80,216,166,217,61,197,21,199,254,128,127,166,173,206,122,206,43,169,205,88,88,26,237,57,164,166,15,218,231,193,222,89,107,65,117,44,146,167,134,85,227,55,136,32,238,130,164,189,229,142,241,57,23,174,187,2,228,0,91,41,62,183,219,15,37,248,156,38,210,167,145,50,216,81,50,182,110,160,255,182,230,33,2,225,168,224,48,208,189,191,46,104,121,109,210,67,80,137,85,245,87,78,205,24,98,183,51,238,61,36,221,115,100,248,89,189,41,234,35,45,153,168,116,132,24,10,254,174,41,210,163,50,11,18,167,134,75,113,17,246,165,172,206,187,238,49,17,3,112,98,250,224,145,199,47,253,180,178,194,104,177,246,156,108,108,37,45,178,137,160,33,139,62,144,39,236,24,165,241,212,5,26,139,224,150,102,188,95,142,134,253,175,100,104,134,94,233,167,210,83,103,151,88,175,231,137,174,67,202,68,126,249,251,223,168,253,26,155,129,225,203,24,8,116,156,221,96,40,105,73,205,110,190,72,114,47,51,249,220,227,183,5,164,186,200,87,102,107,144,219,181,169,237,102,205,35,30,5,249,21,56,232,24,136,5,83,213,158,55,157,16,73,222,213,105,158,248,199,21,180,166,175,102,204,241,21,153,64,115,88,227,254,252,105,20,44,196,116,254,31,63,87,50,157,13,151,149,83,72,80,246,65,156,27,159,100,252,122,254,44,130,53,99,39,61,102,225,215,28,196,101,96,63,243,244,183,79,130,76,117,88,124,39,223,40,85,67,190,86,1,99,130,49,237,84,196,51,114,198,90,105,51,98,235,64,209,208,109,212,185,116,191,37,130,137,178,230,194,185,194,154,236,55,184,20,35,25,169,207,70,193,199,136,207,167,70,240,55,50,5,229,130,112,57,13,105,204,217,201,237,79,103,209,125,128,25,9,170,63,4,123,52,70,16,41,46,49,165,254,156,74,65,148,108,76,19,105,129,142,61,250,180,80,31,19,134,188,161,43,241,129,29,41,225,189,176,205,6,220,146,133,203,202,38,88,95,160,171,50,161,177,28,79,117,28,95,208,217,51,182,250,122,116,52,121,29,152,67,237,130,106,132,47,173,112,35,3,243,99,79,18,27,165,176,3,219,183,208,160,116,37,39,233,136,199,57,157,84,230,151,39,125,124,241,146,25,227,250,200,66,195,195,56,166,186,25,221,234,198,233,132,88,143,139,197,88,90,5,233,108,67,201,239,0,168,89,238,252,144,1,149,135,100,160,138,76,242,104,243,215,97,149,79,48,77,97,103,194,134,156,168,226,65,3,174,49,109,107,24,199,245,235,17,117,20,221,76,105,248,171,25,91,229,109,79,3,42,248,49,15,171,192,39,141,118,188,119,155,120,50,28,24,225,212,1,161,218,124,255,50,7,112,122,61,154,46,39,21,158,20,138,177,80,66,40,37,10,223,210,158,177,231,39,226,46,67,202,162,88,164,220,185,194,122,136,18,118,30,25,245,56,118,15,22,63,161,11,162,55,245,24,109,199,34,72,141,187,47,176,128,86,11,218,144,209,109,24,48,56,109,43,200,195,153,55,5,238,32,124,129,177,38,134,48,159,13,183,1,205,46,35,106,151,114,152,76,204,92,205,10,206,179,43,171,111,139,195,216,20,243,49,1,114,25,72,212,148,65,79,154,97,111,80,203,62,94,148,27,13,94,214,86,30,96,2,217,138,232,14,97,179,217,17,133,75,164,23,29,192,38,69,136,6,193,72,131,189,1,140,222,166,53,80,24,8,187,96,42,73,15,178,26,45,161,72,196,142,110,187,173,137,218,119,210,212,7,225,105,111,190,122,249,254,53,120,21,24,212,205,223,139,87,113,152,165,89,123,234,23,69,111,118,171,44,154,185,76,37,23,52,30,178,135,5,147,58,63,174,77,172,152,229,132,194,208,187,39,163,183,75,134,198,153,59,64,214,184,141,170,170,159,72,164,91,15,16,218,23,209,45,243,7,108,169,13,8,227,182,139,229,12,203,130,198,111,233,131,79,199,194,74,250,234,132,198,131,234,224,180,107,187,9,87,106,53,128,178,73,160,45,76,78,226,107,142,213,45,197,189,71,110,246,127,76,16,170,115,44,201,233,58,236,233,56,30,190,208,246,27,167,241,75,83,59,144,211,216,34,217,124,24,54,97,54,246,94,207,224,114,57,253,125,83,134,60,205,58,102,12,249,128,150,28,121,105,174,14,220,61,251,201,5,86,247,232,90,22,247,106,131,157,246,205,36,16,229,21,50,128,230,128,84,158,234,56,183,60,178,133,45,84,81,239,63,102,98,245,151,233,3,77,2,114,186,193,84,204,212,114,205,211,6,100,166,60,166,50,127,147,136,155,79,5,249,253,180,5,182,13,67,202,104,216,221,235,248,28,84,241,209,186,121,239,234,211,174,24,48,148,204,123,113,218,224,134,155,25,206,165,77,215,126,235,184,215,48,14,72,189,66,215,30,23,19,64,7,241,81,240,136,30,235,45,167,33,103,248,168,174,231,100,125,21,108,51,145,14,206,13,116,189,99,214,240,68,235,125,215,102,242,5,160,251,127,71,214,238,253,213,128,215,219,236,18,84,26,185,248,180,252,184,47,96,107,23,108,45,205,30,46,239,131,250,60,197,99,37,31,198,235,178,243,245,142,123,161,123,199,59,253,42,148,176,158,66,159,192,228,48,66,88,8,235,205,166,56,111,113,28,168,24,168,246,206,111,12,71,67,44,133,81,62,210,100,152,162,164,118,120,47,198,214,59,78,147,85,230,33,228,130,54,245,241,125,214,106,225,202,246,178,228,207,107,237,56,131,148,34,123,130,157,23,157,165,127,210,70,239,255,10,228,98,132,65,193,229,208,201,19,133,110,83,55,99,52,103,227,37,252,184,31,12,188,44,175,25,53,12,248,8,215,241,33,203,227,186,137,73,24,10,3,50,204,121,186,162,193,73,40,76,178,113,159,141,207,1,135,181,123,34,255,159,223,2,45,106,110,45,139,114,165,98,240,194,245,36,125,117,5,203,53,158,148,85,153,245,75,3,21,190,45,225,89,37,107,9,184,90,185,118,79,215,94,174,218,56,222,200,248,221,145,196,56,228,154,62,64,219,60,195,85,127,161,6,115,119,55,172,251,69,241,56,92,252,31,32,240,3,177,207,106,35,19,229,4,242,23,57,215,102,144,52,35,92,183,80,206,95,181,168,195,250,41,128,114,37,38,111,163,213,251,226,25,48,199,155,150,16,95,27,254,231,65,117,118,59,57,19,128,95,153,41,133,115,231,174,201,201,246,165,29,6,154,100,165,244,214,47,113,49,91,73,4,77,62,89,42,98,143,162,104,104,63,113,136,246,23,126,108,237,165,143,190,43,151,128,134,68,42,61,242,115,220,70,83,116,113,89,240,106,222,252,61,81,115,156,139,27,29,81,59,103,75,190,176,228,251,250,81,242,50,194,234,98,206,124,236,39,74,218,221,176,208,16,205,146,46,215,251,206,144,157,213,63,81,76,72,50,12,88,27,234,175,171,253,179,41,107,163,229,216,77,221,206,186,48,93,19,123,85,80,200,246,67,46,117,156,197,249,81,152,112,70,209,45,251,111,28,234,216,20,150,53,144,5,183,65,77,151,236,13,42,22,220,180,106,34,139,254,135,87,181,237,63,85,167,243,216,173,112,203,116,82,24,18,253,7,65,183,9,58,84,25,77,9,130,0,66,84,67,244,81,150,225,142,79,132,43,111,47,255,14,4,118,61,237,221,85,247,145,168,142,141,85,112,5,90,162,29,212,18,75,134,170,87,3,249,154,84,91,200,250,247,122,207,203,71,153,140,167,27,252,97,137,86,205,27,61,201,238,197,99,105,180,22,150,102,93,201,82,232,155,121,168,66,208,100,103,164,83,146,32,217,12,141,11,143,223,6,147,217,139,74,96,152,199,99,97,230,56,22,94,33,118,130,71,253,124,37,100,188,238,198,126,107,72,57,27,55,82,22,23,146,86,166,182,191,130,206,248,232,54,136,134,153,235,15,46,185,184,166,136,94,217,190,123,79,235,224,128,20,217,123,129,189,140,21,95,130,130,146,151,234,19,3,207,94,156,120,57,4,132,109,92,244,114,31,79,230,182,254,172,76,176,230,101,217,120,99,232,148,232,179,112,192,135,153,25,233,229,250,203,184,221,128,13,205,43,75,42,4,251,51,186,183,144,253,106,138,237,88,226,250,181,233,251,60,117,90,79,53,184,57,241,47,115,11,190,141,213,252,75,193,21,47,19,72,84,45,79,123,42,195,186,248,198,45,54,209,187,82,92,30,85,214,241,166,86,249,198,122,235,210,230,178,246,232,157,8,136,64,16,36,2,203,239,137,61,244,227,25,36,41,0,241,93,20,207,68,83,217,243,193,192,188,146,162,67,168,163,31,82,35,143,195,90,100,147,202,171,244,43,112,221,6,166,107,223,131,9,64,219,99,195,212,221,165,201,31,176,32,120,61,112,60,106,65,87,1,12,3,160,40,104,98,173,242,2,64,200,119,163,0,226,91,201,125,234,193,143,210,76,95,94,215,74,83,250,4,6,50,74,241,51,19,17,165,38,60,48,234,240,43,124,171,42,217,169,232,216,33,57,27,91,208,230,188,10,33,85,22,80,24,16,69,92,225,116,28,162,175,77,154,117,238,199,161,180,225,245,255,0,248,15,133,35,206,226,0,82,199,193,176,6,177,161,4,83,37,51,81,58,76,251,214,248,60,245,122,192,159,136,35,230,78,47,59,50,128,164,231,56,182,19,179,10,11,146,6,214,141,72,50,136,0,123,48,36,243,148,131,106,14,254,44,164,129,239,97,95,206,160,82,101,75,170,205,75,196,1,79,121,183,250,23,214,106,126,255,24,80,193,43,249,39,103,120,199,8,59,134,162,97,204,33,134,115,50,189,226,82,94,203,86,173,199,141,76,66,113,114,47,17,61,24,126,0,111,0,74,212,39,120,237,43,86,78,199,100,73,111,77,114,220,236,59,93,22,23,160,188,125,160,72,220,194,91,27,134,176,243,197,106,232,19,166,222,169,6,170,166,116,249,251,230,87,63,55,69,251,242,151,54,94,169,156,226,48,23,61,104,179,104,248,60,11,190,142,254,45,209,246,205,135,182,137,137,187,4,241,13,175,11,149,132,180,89,233,44,151,224,158,101,62,33,207,55,174,221,157,163,52,204,80,40,147,93,98,100,190,42,37,208,1,108,36,138,88,104,166,83,39,67,131,156,77,182,80,118,73,138,69,189,76,105,2,248,247,49,238,66,233,28,211,252,14,10,221,141,201,39,184,220,62,18,25,73,226,144,178,3,204,142,94,38,241,69,10,4,163,64,17,44,89,91,211,158,169,94,83,227,13,68,14,106,85,228,50,14,33,162,112,217,158,207,55,180,67,9,18,56,27,238,167,55,89,37,118,73,97,135,218,128,147,148,234,76,169,166,171,78,175,253,51,109,87,117,240,137,160,107,226,208,252,22,85,48,79,28,117,209,51,206,146,205,108,143,234,8,84,213,243,180,142,233,36,135,149,224,89,53,5,222,88,199,180,36,47,30,65,155,239,193,191,92,40,48,225,33,86,37,52,99,198,201,236,26,93,80,213,69,61,71,95,74,90,24,12,174,117,83,122,189,79,97,30,132,133,241,160,54,233,99,1,209,187,42,28,75,21,107,53,225,175,64,10,165,166,29,27,196,78,112,181,67,66,95,84,100,50,111,47,84,113,108,235,106,19,33,195,12,4,117,69,86,93,40,198,167,76,209,90,102,76,205,142,160,220,11,228,61,190,197,79,62,24,243,232,83,228,50,139,57,250,240,145,122,60,103,130,132,207,123,244,15,31,106,134,172,70,190,219,212,36,151,61,50,85,160,122,142,227,122,226,131,189,153,163,188,181,135,146,156,144,162,147,134,54,121,97,164,23,162,188,173,54,32,38,136,68,250,240,62,115,127,28,252,150,206,98,16,23,158,19,228,60,135,221,31,133,148,24,28,151,128,67,160,93,178,3,223,152,218,253,160,251,216,255,56,89,160,3,96,145,73,80,178,144,94,200,90,53,23,246,31,164,245,71,92,150,126,49,42,252,132,44,71,132,235,197,31,209,33,38,30,72,69,159,4,226,208,236,37,18,198,220,126,36,98,146,206,12,102,236,232,190,219,162,240,25,230,110,138,14,153,88,34,3,221,164,3,232,21,51,131,175,219,121,135,134,173,155,144,206,33,112,212,33,52,15,159,79,79,69,125,170,169,182,149,105,199,194,8,111,150,193,219,111,216,39,96,143,50,161,69,6,225,58,35,214,36,238,195,136,202,122,35,16,255,244,216,131,31,157,172,126,182,93,219,145,99,175,209,57,120,82,115,240,36,150,245,163,133,60,235,202,59,53,240,121,81,69,135,89,104,120,168,115,223,45,237,187,80,101,159,127,49,180,227,83,43,54,194,151,21,117,237,162,243,108,198,149,75,193,59,81,35,61,133,178,107,3,149,209,229,75,139,76,81,140,49,213,101,178,233,81,149,112,37,126,65,235,153,201,154,203,100,123,196,179,74,153,147,198,227,241,254,124,222,221,125,219,74,141,220,43,37,223,81,122,173,170,222,125,63,240,233,220,121,2,64,88,199,67,4,213,181,191,225,142,120,38,148,220,1,57,215,8,124,78,105,225,124,229,60,154,90,114,171,27,121,43,146,239,14,61,146,46,166,195,122,133,153,159,120,194,72,162,19,101,117,87,200,209,119,116,60,12,118,85,141,209,44,213,11,207,41,165,204,19,242,43,192,183,28,120,28,104,224,67,79,243,218,84,210,171,31,107,1,161,44,197,77,248,182,201,235,231,169,113,30,190,254,211,57,75,33,166,85,103,190,133,47,127,4,215,56,200,126,181,107,86,55,146,38,173,130,50,50,249,41,93,46,15,140,2,194,199,107,205,74,226,23,138,232,8,129,37,100,203,212,124,120,112,180,140,53,16,240,73,158,127,159,203,202,95,133,53,93,151,115,221,42,24,106,209,242,71,88,17,172,87,61,85,69,15,38,56,59,196,195,7,26,229,156,72,173,151,58,124,107,249,185,1,179,254,114,182,229,17,186,88,166,137,101,103,41,184,177,223,193,181,61,122,172,165,247,239,76,213,92,70,73,21,179,18,46,225,245,71,6,65,187,8,122,6,178,234,182,97,48,47,103,68,59,188,235,135,61,11,0,100,2,175,176,141,88,58,37,180,94,242,92,219,204,50,105,189,40,138,190,153,60,91,153,226,230,86,177,189,247,194,225,42,54,89,143,45,78,80,232,195,124,17,147,103,157,122,103,204,240,174,9,73,100,112,247,168,175,216,88,244,98,155,159,115,18,74,233,191,29,3,251,31,92,179,57,229,167,178,249,189,8,28,53,32,245,117,212,194,145,125,73,244,112,21,239,154,134,184,0,232,66,192,185,181,241,78,35,16,28,153,184,205,227,129,232,91,94,212,231,211,72,5,237,219,246,83,197,63,83,77,132,72,27,95,137,14,207,3,77,159,48,94,95,88,212,130,121,245,5,157,253,215,167,156,176,80,16,201,176,24,72,225,41,81,143,28,197,175,20,210,218,142,60,61,219,61,178,254,64,69,74,16,211,83,220,3,154,196,75,206,248,36,67,177,144,59,100,175,237,208,78,244,251,206,210,79,139,155,55,87,243,97,80,74,80,27,107,18,185,205,87,227,197,155,178,131,169,239,233,237,152,149,175,78,94,109,172,125,151,226,184,92,135,101,103,241,23,223,219,139,188,190,85,24,138,197,255,228,131,74,146,248,251,184,158,240,101,147,173,97,2,245,142,217,1,45,236,33,62,137,138,116,46,23,199,61,122,74,125,187,32,81,166,197,70,166,120,39,127,250,4,244,133,152,118,68,84,86,211,243,73,76,207,180,62,187,17,191,86,107,81,137,208,43,117,178,177,115,110,144,77,249,242,186,229,52,102,7,77,81,4,179,3,141,180,220,77,96,177,99,51,133,97,41,185,220,93,254,234,145,77,87,150,208,114,12,192,152,23,73,77,183,180,10,166,237,187,191,18,160,136,136,185,163,118,45,168,223,173,18,45,216,11,237,230,110,7,10,229,66,84,195,169,45,111,170,252,219,96,202,221,12,87,194,50,182,8,93,166,184,170,75,115,187,175,44,195,142,38,154,231,145,53,52,87,186,144,150,142,154,160,19,138,144,19,229,146,170,154,135,12,177,175,36,60,6,107,112,15,229,190,59,21,112,45,193,38,251,171,255,178,156,100,56,53,96,144,149,8,50,103,53,136,233,48,62,18,202,8,243,137,67,209,160,20,46,91,167,148,124,27,157,147,8,154,255,34,145,237,36,35,175,70,193,181,40,249,183,203,193,251,166,154,39,27,247,66,55,222,49,179,127,3,239,159,19,99,91,197,46,217,122,200,28,13,115,1,29,30,221,197,72,17,246,202,4,34,20,195,165,138,251,105,93,61,37,51,78,229,122,209,61,22,76,115,100,187,18,42,158,169,124,158,190,130,200,221,114,246,135,49,175,170,217,130,217,63,146,191,9,106,212,102,121,102,255,59,194,94,29,179,203,129,165,161,110,122,103,237,69,107,213,192,243,246,48,16,68,6,133,219,27,224,61,228,96,210,39,58,230,134,3,5,53,198,131,36,188,250,94,95,140,167,38,79,74,10,39,156,29,90,255,236,160,224,115,195,220,214,161,40,15,158,142,247,150,197,28,39,145,30,213,8,43,187,174,1,183,46,225,162,244,30,9,7,8,52,189,19,183,24,154,167,208,122,159,184,23,74,159,118,107,7,165,26,1,104,233,132,145,39,227,90,229,134,55,247,136,243,24,70,64,139,188,150,7,50,178,13,114,252,190,221,89,168,184,183,23,22,237,157,112,158,156,47,3,218,12,105,45,61,24,188,231,161,57,75,31,131,56,185,170,108,47,99,96,125,52,150,150,97,246,185,189,126,54,126,166,138,116,234,22,191,4,193,154,40,61,119,159,109,140,207,189,0,114,16,202,139,63,204,215,157,120,253,207,108,228,21,127,90,174,59,19,178,115,34,243,22,250,213,10,135,4,8,18,234,246,55,172,130,125,242,172,104,114,234,230,135,42,211,171,162,23,26,145,59,104,211,115,154,152,120,94,98,22,53,165,12,136,88,197,240,13,126,22,226,144,100,64,164,211,228,227,52,202,123,150,255,76,227,226,94,215,31,15,31,182,50,10,95,193,55,29,113,84,194,231,105,241,242,97,0,164,118,38,200,201,106,26,146,207,70,124,13,243,87,27,184,222,227,148,91,184,206,165,182,62,114,25,93,175,242,57,34,231,127,131,86,70,91,78,111,49,105,77,210,84,188,162,184,83,34,78,13,77,240,75,20,171,150,241,234,64,198,89,70,64,70,43,54,236,219,123,83,220,22,101,205,231,47,67,241,129,72,76,199,63,236,106,241,176,230,220,112,56,188,63,200,37,253,155,13,112,132,180,190,194,46,78,44,232,33,28,168,119,12,33,91,42,19,233,44,200,180,190,74,54,79,221,80,108,79,232,71,35,49,51,150,132,218,117,79,113,243,222,185,4,182,64,58,49,24,154,132,169,163,102,184,98,122,242,211,1,244,200,75,89,222,107,39,247,243,14,242,225,242,154,228,136,167,222,210,87,73,17,120,188,175,44,145,183,52,153,213,23,19,165,200,20,11,160,227,33,156,251,212,1,55,156,206,232,72,218,71,115,240,50,192,0,33,160,3,126,44,197,127,107,127,126,186,5,214,46,250,131,98,38,10,14,56,129,250,94,48,46,35,167,50,1,124,68,156,226,27,176,117,143,188,247,128,178,253,249,23,159,168,211,214,99,16,241,138,23,19,113,100,112,205,117,97,157,85,232,97,94,122,31,162,50,208,247,137,67,144,129,66,115,205,209,100,229,114,132,213,18,218,36,211,91,96,125,241,107,13,233,128,212,138,83,204,225,101,255,246,42,52,195,67,174,0,40,1,214,31,123,22,247,211,83,159,164,118,78,124,55,230,95,252,153,91,41,38,63,123,202,126,253,157,99,117,107,150,27,253,90,129,73,248,167,204,68,62,255,0,37,15,227,208,79,153,115,160,42,46,235,102,184,13,151,56,15,190,6,233,248,0,179,205,23,252,88,93,221,114,246,162,255,220,49,157,162,121,132,28,219,74,232,10,125,157,204,14,222,174,150,184,54,90,174,32,57,217,38,78,1,156,59,50,158,199,99,74,132,34,59,206,254,17,110,153,133,135,94,247,144,1,76,136,154,87,94,159,79,54,6,221,143,51,120,149,85,11,201,128,172,89,66,134,204,97,52,21,56,126,203,133,73,114,39,64,89,117,128,50,123,232,8,103,97,194,73,146,237,54,175,228,111,91,161,181,72,39,180,207,239,58,191,151,0,201,10,69,17,25,168,87,167,46,252,150,19,204,5,40,241,20,57,216,89,0,82,159,151,201,179,215,161,1,255,238,173,111,220,34,140,240,237,49,182,129,130,151,165,175,57,183,161,180,11,156,125,34,194,247,22,28,79,151,53,235,36,97,182,169,42,141,185,48,16,64,1,4,146,11,226,112,166,164,219,42,116,109,180,69,104,213,172,189,55,228,236,81,69,111,145,22,166,87,53,203,226,204,234,171,116,135,176,110,23,112,158,213,232,62,7,18,247,35,242,214,154,233,209,186,0,39,175,54,62,242,32,216,35,44,230,63,46,11,156,237,208,23,35,81,135,23,68,206,33,175,72,60,189,192,237,133,121,162,238,230,44,205,83,51,253,41,150,67,105,216,74,195,110,216,219,169,5,77,41,233,70,230,83,22,31,117,222,33,108,73,167,33,26,87,150,38,206,167,220,181,145,66,16,136,15,180,167,118,136,94,235,128,72,164,144,248,54,192,164,117,243,24,144,61,227,229,220,27,47,184,41,253,252,206,164,85,231,14,32,35,198,191,14,79,95,251,62,111,22,243,28,8,111,3,132,147,62,198,39,23,228,147,233,209,248,243,233,184,43,19,145,173,76,37,194,42,213,39,197,182,143,6,237,223,13,33,227,9,254,189,85,175,80,72,249,97,179,109,139,181,192,78,160,122,191,34,159,110,154,159,230,206,233,56,82,50,248,138,209,206,150,153,33,125,71,122,254,214,107,37,37,17,48,29,180,129,115,70,3,253,87,220,174,241,107,129,104,158,9,56,205,149,210,223,19,85,3,154,137,241,33,236,119,78,157,36,147,44,163,77,128,217,138,74,47,54,239,209,26,2,13,222,153,126,135,191,232,220,90,184,89,145,197,174,200,18,163,75,137,57,146,197,7,183,211,208,53,163,196,121,199,30,15,71,217,248,110,122,10,197,232,3,164,125,130,235,237,76,179,10,226,255,231,123,116,139,246,5,97,223,213,68,18,133,83,248,92,87,62,104,80,99,44,133,183,104,44,46,168,105,169,40,71,164,19,27,251,116,249,239,77,108,254,163,94,108,238,208,165,67,247,49,33,150,31,107,31,206,37,230,176,204,178,45,158,130,186,77,65,24,96,204,178,133,223,60,49,193,248,34,131,64,230,153,213,63,151,193,196,79,34,175,169,35,168,217,135,93,78,71,27,213,25,180,136,209,166,159,20,144,143,178,192,21,166,12,122,217,206,88,201,71,44,31,29,236,87,252,71,153,5,91,64,23,100,238,47,57,16,74,222,130,206,10,239,2,83,236,42,24,116,254,251,20,177,26,202,42,108,62,176,40,8,233,142,86,217,215,50,64,42,243,205,8,68,252,36,140,79,187,75,3,14,50,96,74,198,21,229,176,30,4,28,38,25,152,96,184,59,252,61,9,135,77,227,210,161,16,213,145,165,89,70,249,24,202,202,78,66,87,9,224,230,250,170,85,124,30,46,121,74,164,150,86,225,138,73,175,217,119,73,234,177,157,70,84,21,210,131,29,118,113,209,253,64,149,158,240,94,84,93,49,158,133,111,202,157,16,158,175,238,151,48,33,198,13,54,162,231,5,87,125,75,187,133,160,134,141,100,220,4,229,72,120,254,230,102,17,29,46,137,153,44,215,2,75,187,111,70,190,42,183,163,160,15,21,237,10,51,194,119,126,195,37,84,98,204,242,27,136,104,5,128,212,236,125,191,17,240,167,193,249,60,218,222,130,186,13,214,138,149,46,138,52,5,81,24,65,51,42,48,107,108,95,35,185,242,140,190,117,60,163,111,253,147,111,157,60,159,209,39,167,190,155,147,183,91,36,122,171,240,100,139,248,229,67,115,251,118,68,94,144,52,51,71,9,121,193,100,73,216,201,237,179,228,122,215,5,150,61,89,184,198,190,110,216,157,0,153,105,69,148,184,45,3,142,174,163,88,228,111,16,170,128,211,59,100,143,19,166,202,220,205,10,226,32,109,51,93,137,218,89,58,204,66,187,99,233,44,168,26,138,24,26,158,212,98,100,145,30,0,218,4,128,24,126,172,7,50,127,245,174,63,172,225,209,38,151,38,135,210,36,38,32,241,173,76,90,57,132,63,82,18,36,244,76,148,219,62,232,35,25,124,219,182,38,135,58,243,131,225,251,188,81,29,138,181,103,10,250,43,92,217,152,174,46,50,165,40,33,22,237,192,166,203,58,120,157,229,72,56,157,39,235,142,102,54,197,229,182,144,177,144,229,235,218,154,122,239,167,2,36,251,158,204,36,123,53,106,56,183,105,213,235,179,134,183,150,90,42,181,230,116,135,149,19,36,37,172,200,232,106,206,204,110,38,232,220,250,47,203,88,88,55,48,109,199,8,101,236,87,163,167,242,56,224,130,88,133,190,45,178,208,89,166,207,45,195,191,219,67,96,182,163,152,169,65,19,59,193,217,199,246,106,228,205,2,231,211,43,9,81,128,40,45,220,36,188,40,194,31,194,13,206,82,89,225,115,209,29,126,144,222,37,41,90,67,184,7,91,239,214,189,50,90,84,22,157,18,43,123,104,231,188,104,97,81,245,232,122,249,251,162,111,94,233,93,25,34,3,227,118,34,155,213,155,125,157,77,255,105,151,68,38,50,58,84,198,74,74,195,39,10,140,85,168,227,192,199,85,64,129,80,237,186,38,146,59,153,168,49,238,117,130,152,141,201,197,22,38,180,220,28,131,73,38,62,70,170,91,217,150,73,73,132,134,105,182,92,171,149,186,221,61,199,74,89,124,76,131,138,174,255,42,7,111,67,69,177,89,172,60,245,89,59,52,74,130,99,150,19,55,50,17,6,238,96,20,97,103,185,53,195,22,145,15,248,254,78,225,70,67,219,179,12,197,64,168,6,81,31,128,154,82,111,34,135,234,125,215,167,44,55,52,158,222,231,224,155,175,89,2,211,26,190,195,64,33,59,234,171,72,7,105,60,140,229,126,152,217,134,13,174,135,94,27,35,223,131,53,85,35,94,204,227,140,4,138,85,226,162,189,216,55,19,13,159,65,234,144,13,91,122,2,69,195,26,172,222,131,9,148,163,224,193,189,208,153,144,225,252,173,197,232,46,188,169,170,175,239,17,35,232,82,238,162,245,247,192,63,79,79,91,67,217,43,55,126,155,51,254,215,155,231,78,114,240,47,90,205,211,54,230,242,32,33,114,145,226,75,3,138,238,112,27,189,81,80,59,11,252,86,80,100,100,72,221,61,211,105,105,248,199,181,126,59,200,67,103,28,193,27,146,4,171,59,87,233,160,1,129,26,74,127,230,30,237,234,71,55,194,36,37,34,210,127,182,6,69,45,94,62,240,222,11,168,153,234,200,19,139,215,37,72,166,164,229,123,104,231,146,203,216,77,170,152,76,111,72,169,215,213,26,204,7,245,249,140,107,60,184,181,19,222,237,79,208,180,252,72,30,168,23,211,252,131,26,191,251,208,158,176,32,14,57,18,11,136,88,144,47,88,184,36,198,52,221,88,72,43,149,242,142,42,46,147,224,121,167,178,222,36,50,237,86,255,144,83,193,253,207,26,79,210,99,164,216,58,196,59,106,68,12,169,5,219,121,68,142,102,5,226,215,68,51,132,1,99,113,144,32,46,172,9,31,72,254,66,46,22,147,55,97,224,79,27,54,183,33,170,82,145,158,163,37,141,28,18,123,200,138,149,34,161,218,119,212,199,194,211,8,73,223,33,190,125,228,6,177,64,161,220,34,78,59,237,51,77,163,26,173,167,172,223,9,218,252,165,208,242,7,149,25,161,124,214,200,206,142,249,10,132,40,33,159,86,26,52,25,235,252,12,147,118,39,218,41,239,188,244,133,14,10,155,234,234,91,248,62,11,142,39,181,227,190,38,147,233,129,63,206,146,93,53,29,182,87,132,48,204,56,233,19,142,185,120,196,253,37,32,165,90,201,6,36,251,15,106,106,196,74,20,206,46,151,51,16,8,220,14,110,55,55,49,146,190,196,46,11,66,116,144,27,185,114,176,94,37,203,201,207,185,142,74,186,169,67,204,70,45,67,141,160,247,52,45,19,157,239,135,239,170,180,49,59,62,219,15,129,172,147,200,144,238,29,193,164,178,91,228,90,165,217,90,107,149,68,243,181,235,247,43,147,252,162,197,153,202,74,74,244,90,145,113,109,59,13,87,196,70,205,106,193,132,160,22,28,154,35,111,90,125,114,27,66,211,40,209,32,15,175,237,106,39,193,10,62,150,186,53,173,187,66,5,23,139,169,77,101,98,58,42,38,244,62,112,227,121,0,1,85,108,146,71,6,171,246,42,181,231,109,20,4,245,208,34,186,137,138,195,186,44,63,255,238,87,230,68,110,42,236,250,169,36,84,126,3,137,214,128,214,198,193,43,175,139,101,137,139,229,198,90,143,47,107,76,218,215,153,252,129,9,148,122,185,46,120,239,232,185,9,138,208,50,87,155,232,43,158,93,50,204,107,93,25,17,150,20,14,90,156,95,228,63,139,33,172,133,4,104,119,10,46,248,102,180,146,1,95,151,205,13,111,25,134,236,250,254,232,13,14,204,9,70,90,86,1,190,99,165,4,187,205,253,163,6,22,224,216,26,61,63,196,195,115,245,209,85,30,56,40,55,50,164,115,237,180,241,187,184,174,50,99,114,30,237,47,35,139,60,1,150,145,143,235,156,25,219,218,69,179,154,75,120,28,108,112,137,68,35,146,20,197,108,188,188,172,137,204,125,77,203,76,103,3,129,45,250,169,207,79,247,246,183,37,126,87,53,162,232,165,208,218,174,188,210,25,18,156,84,133,189,81,222,246,145,21,201,218,89,69,234,181,136,67,213,210,60,123,92,40,145,137,79,112,237,116,71,236,170,75,125,30,149,57,72,222,21,82,138,87,12,81,4,235,64,19,157,230,5,176,246,229,175,65,132,16,170,182,82,140,233,252,120,183,88,174,142,71,238,48,37,221,149,63,219,212,222,54,227,202,243,213,120,42,127,177,142,206,57,103,200,230,143,223,14,75,1,12,2,60,208,22,181,9,255,129,12,103,248,114,91,93,108,171,43,57,150,180,13,30,25,208,71,10,0,60,43,211,191,172,94,161,55,14,20,166,113,150,127,22,141,192,156,38,105,136,111,153,143,103,242,198,87,253,34,8,14,165,60,4,39,191,207,73,106,135,135,68,53,144,246,74,167,78,103,112,61,110,211,122,127,24,50,117,30,145,6,68,118,141,158,225,191,196,39,240,226,61,237,203,215,250,1,42,79,194,135,209,20,35,69,105,162,220,144,229,188,142,173,235,30,106,109,21,243,129,20,146,38,104,210,237,247,199,161,236,180,50,78,210,115,197,234,85,196,125,179,154,28,177,241,94,76,239,147,106,39,100,195,130,232,89,149,50,158,86,21,250,118,71,165,72,39,64,48,12,109,225,178,29,105,174,84,73,61,148,54,80,32,124,5,228,182,147,198,76,247,155,217,175,249,71,35,3,54,115,32,25,27,224,219,17,172,190,192,132,122,160,166,220,16,175,212,185,16,181,171,101,89,23,42,111,220,128,225,132,244,144,33,99,191,169,70,124,32,135,13,51,245,93,159,96,118,237,98,151,63,62,179,200,135,117,106,181,136,228,136,17,104,58,107,150,236,196,81,24,253,218,183,253,163,35,21,140,149,45,1,109,54,86,22,118,188,226,251,80,182,203,58,242,100,163,109,79,96,166,226,253,9,77,244,112,21,6,237,89,24,104,181,54,28,70,96,33,15,28,124,109,219,15,2,124,16,50,60,170,113,39,221,37,227,154,164,205,248,221,12,234,202,88,118,193,171,132,98,193,198,30,70,46,12,49,97,40,193,9,104,157,178,18,28,24,246,38,131,230,146,66,80,0,50,66,154,143,189,216,248,8,180,158,67,166,93,203,123,166,38,182,166,153,38,101,120,204,217,59,225,224,240,128,73,137,16,76,252,133,203,56,66,74,230,173,7,99,110,216,165,82,19,193,3,233,197,0,15,252,125,118,139,68,158,115,248,39,76,185,236,115,35,215,142,76,44,122,170,129,8,128,75,77,80,149,143,14,91,207,161,240,217,127,8,193,221,170,115,55,211,135,109,30,92,9,197,155,222,107,216,36,74,218,213,167,199,74,67,248,86,57,210,32,190,160,205,83,223,198,230,74,239,234,91,94,187,82,53,12,56,157,187,180,179,126,145,192,183,81,115,95,105,157,191,37,232,116,228,72,137,139,168,237,22,8,44,37,255,205,101,17,36,255,182,26,176,235,39,215,169,60,150,237,176,35,96,193,132,196,244,120,113,248,61,199,230,160,22,58,103,184,208,32,55,250,144,36,89,79,6,77,237,20,11,181,235,154,229,149,185,62,238,18,168,255,226,26,95,147,100,101,241,231,201,17,147,221,255,253,242,177,195,219,239,20,208,168,58,109,116,166,147,208,237,250,79,51,44,98,165,109,227,133,103,113,86,161,97,118,1,11,223,122,246,53,183,150,160,107,177,83,236,178,204,41,161,6,102,90,179,215,95,180,145,133,71,20,118,184,65,186,126,248,167,72,196,226,90,192,111,215,76,96,207,6,44,107,162,253,132,107,68,94,189,120,118,164,41,24,228,9,207,193,245,234,19,177,233,199,71,45,63,242,128,6,49,107,66,242,255,184,124,237,91,162,237,145,178,94,237,121,16,96,212,238,228,169,46,151,50,105,1,115,28,40,244,54,116,179,7,231,130,7,151,48,173,88,42,27,181,235,156,34,178,164,66,157,161,192,20,37,145,142,112,83,140,210,122,206,246,81,78,184,186,161,6,41,9,140,69,228,22,217,181,63,102,58,68,148,199,10,174,63,37,93,188,129,160,189,47,97,47,109,165,93,63,52,39,147,104,110,42,56,95,65,80,220,219,72,160,62,237,223,120,32,45,114,103,237,47,77,37,251,19,107,55,161,22,244,55,136,175,41,66,176,1,117,82,16,38,16,160,5,1,228,60,72,227,108,249,249,76,187,56,255,159,216,18,208,66,214,220,138,141,207,91,132,226,79,180,25,149,8,230,245,81,208,204,157,144,193,222,150,64,148,36,49,135,168,4,25,211,121,62,220,200,179,60,33,40,253,243,61,27,254,140,14,234,253,133,88,170,113,52,92,252,98,175,239,222,145,206,189,24,231,115,72,192,34,118,176,213,57,165,68,229,45,185,26,89,3,187,215,24,122,173,249,217,160,135,101,89,52,180,128,105,127,159,121,48,176,186,238,130,187,88,79,162,77,255,58,131,235,148,157,22,58,80,3,66,89,160,12,109,161,13,159,149,211,110,240,140,101,33,3,48,3,113,56,63,205,221,242,9,77,219,154,209,68,14,173,130,33,246,89,98,157,92,218,135,190,71,87,42,158,191,89,225,95,89,88,85,177,159,160,210,133,134,64,8,0,118,22,199,250,81,176,124,83,223,138,51,126,158,171,169,84,33,197,111,190,149,190,242,71,16,201,45,22,188,179,87,47,92,242,31,177,249,120,64,255,112,180,237,117,186,167,99,48,13,87,213,191,95,33,200,54,73,250,187,99,147,50,196,191,19,49,0,151,1,140,128,168,74,184,49,114,14,149,155,53,66,188,190,235,95,153,94,89,158,136,135,60,28,28,126,241,203,7,19,77,77,91,7,154,217,179,180,4,161,148,133,93,27,156,194,206,248,194,16,139,34,9,184,152,123,127,29,118,129,192,40,164,148,29,2,146,125,153,100,38,54,19,211,52,162,50,7,236,136,234,37,228,151,200,91,122,246,8,210,193,169,232,194,133,28,29,249,37,52,96,235,61,69,179,156,73,186,110,191,98,145,232,89,86,211,208,219,4,176,6,90,78,158,62,212,180,39,200,131,233,143,185,206,1,128,206,80,179,73,176,133,89,170,205,112,35,220,45,3,138,157,193,146,219,205,78,29,158,97,204,28,245,108,13,121,189,108,81,138,65,74,162,21,14,197,166,40,234,90,38,203,249,94,221,6,169,157,89,20,12,163,69,176,70,117,54,180,158,154,50,111,67,222,101,27,251,183,91,90,120,64,194,8,217,119,169,88,68,249,74,81,100,246,254,43,200,215,130,118,44,236,41,118,103,196,103,223,24,54,137,196,89,214,12,188,97,201,121,139,141,254,210,220,99,75,95,108,189,121,155,99,217,231,12,40,113,41,27,15,111,203,202,206,66,0,38,69,198,122,59,164,236,16,171,226,35,99,35,159,77,196,112,203,98,93,41,184,82,179,182,147,129,136,53,153,181,57,77,183,111,186,175,184,129,195,218,233,66,213,160,219,198,196,148,131,5,235,226,38,52,158,255,148,80,226,132,193,57,166,188,255,47,14,182,97,65,202,245,240,46,87,245,101,227,55,179,91,15,199,98,68,238,249,200,25,2,249,107,213,237,140,152,182,185,225,204,19,26,140,101,244,190,106,210,50,88,129,143,67,10,146,252,39,10,151,13,192,27,163,108,141,199,237,122,10,215,33,27,40,204,222,83,41,119,159,122,14,143,199,223,21,206,234,44,160,147,168,213,47,69,210,253,2,21,165,160,114,202,241,30,178,232,159,102,171,253,107,114,2,162,82,222,195,45,75,79,255,91,152,248,1,184,74,244,244,169,185,106,16,200,69,27,192,59,24,55,173,184,57,122,221,22,189,195,205,198,225,0,236,127,78,139,137,243,94,189,131,164,133,49,103,104,50,234,55,130,159,57,220,250,58,83,180,81,51,246,228,41,22,38,14,39,146,91,245,239,53,159,165,199,102,214,251,168,48,151,212,164,160,248,239,234,9,214,60,22,171,36,206,165,241,114,102,247,240,45,101,224,152,76,128,178,165,195,254,114,229,70,80,133,73,187,128,55,58,88,106,56,164,172,162,19,98,38,92,143,42,135,14,179,75,230,62,86,212,51,97,216,121,67,188,222,90,40,160,239,100,15,168,218,163,95,249,191,91,66,48,95,94,231,167,11,103,50,152,244,27,251,172,141,240,162,23,154,13,212,66,13,177,122,127,155,142,251,108,61,115,52,136,86,123,97,219,205,228,46,156,145,132,55,119,160,250,56,208,164,144,140,183,140,95,211,185,184,110,23,23,245,9,166,170,50,46,228,58,219,228,143,100,246,188,238,133,75,225,116,240,216,45,128,154,208,58,246,75,231,175,247,220,19,42,217,238,24,218,185,195,145,127,210,31,136,219,255,194,203,145,147,186,44,111,35,155,114,56,21,19,203,43,46,8,123,174,14,41,218,140,241,217,57,233,119,150,39,174,204,80,235,231,184,34,198,124,191,89,213,119,29,227,105,180,26,46,72,215,230,84,192,55,243,255,178,94,48,148,249,25,206,212,129,242,157,121,183,25,241,70,240,180,101,210,151,163,129,94,154,143,102,38,55,213,125,35,206,62,143,25,215,186,176,36,246,112,164,146,155,159,2,70,112,77,224,21,251,50,99,53,39,233,38,47,115,229,65,228,186,132,213,104,194,248,9,232,206,172,132,103,223,179,29,250,192,121,83,173,80,176,88,210,116,123,211,48,89,197,32,187,87,220,210,95,160,129,51,124,102,167,180,152,148,63,146,221,248,240,84,120,111,82,90,244,155,24,4,53,171,249,117,76,129,92,57,167,166,34,202,147,29,151,132,42,107,25,99,120,176,204,247,110,171,65,255,167,65,172,77,117,22,78,239,238,172,64,243,99,185,94,223,250,213,61,93,168,222,73,203,39,10,182,71,147,194,161,37,237,250,189,182,221,184,249,245,220,174,72,248,142,249,128,234,131,85,235,103,109,246,174,125,18,104,4,205,81,213,49,125,173,226,33,64,84,53,137,165,179,119,255,156,202,170,213,89,30,117,31,221,115,87,186,207,45,89,83,229,46,55,219,196,114,152,145,131,172,197,225,183,175,105,43,215,64,20,195,216,168,131,168,245,72,135,171,109,227,111,201,77,52,67,34,178,125,33,38,230,53,1,14,189,227,208,2,152,18,54,48,174,197,141,12,163,175,128,89,21,204,220,176,252,67,72,15,192,152,201,197,5,227,14,189,199,164,162,236,116,245,81,195,235,98,76,17,206,235,42,159,65,46,124,176,56,8,236,189,5,57,136,125,17,46,208,224,96,32,105,205,182,79,243,225,59,245,101,120,92,55,211,35,141,39,120,243,75,19,10,208,54,73,103,32,48,32,147,69,17,255,166,195,60,137,136,107,182,45,118,100,165,158,40,164,80,141,19,234,57,46,97,99,167,116,70,214,65,124,82,117,56,74,126,150,194,47,79,27,56,240,171,141,197,20,112,221,141,37,189,88,107,118,74,85,230,238,203,41,24,247,96,108,29,80,146,138,142,96,43,210,30,171,191,120,234,80,78,204,85,21,198,224,110,29,51,60,56,159,165,220,30,90,14,171,136,35,11,226,195,37,44,130,22,45,91,24,141,66,242,53,25,129,252,78,223,131,82,48,53,113,29,180,220,28,172,75,203,39,99,165,252,8,33,148,123,84,160,21,142,185,246,67,15,144,181,30,108,184,236,103,106,215,103,151,87,142,115,6,179,237,78,158,86,15,11,75,250,102,108,59,33,164,188,106,197,134,105,36,165,40,213,191,187,22,95,84,187,246,67,196,169,48,102,16,171,81,224,153,133,226,97,181,243,242,57,67,77,165,161,91,41,212,44,11,85,128,241,83,97,192,178,236,220,43,76,5,200,45,25,164,195,61,84,64,70,207,17,106,43,79,98,221,63,116,73,155,99,162,197,125,162,43,18,252,48,104,148,23,43,137,236,192,136,168,53,249,174,192,172,182,49,51,153,77,80,44,74,251,188,52,124,149,78,57,9,239,222,107,255,170,25,37,228,223,234,119,42,39,222,10,28,65,238,177,11,180,140,124,124,133,117,181,32,57,227,235,159,116,36,38,228,174,215,202,55,203,125,35,7,173,205,35,32,247,100,161,201,82,12,199,0,140,120,216,197,16,47,74,20,215,121,21,173,52,125,80,74,220,52,157,235,96,101,56,160,217,224,253,214,129,64,234,109,28,91,73,180,121,164,136,246,193,173,107,90,57,7,229,38,186,209,119,39,30,2,164,103,182,141,190,228,252,10,247,172,237,43,228,190,65,127,49,51,163,182,226,131,244,249,46,188,254,110,85,244,154,123,69,51,116,219,89,169,186,206,93,232,163,167,189,205,194,24,195,117,167,191,154,201,88,160,77,135,230,188,58,157,147,241,231,126,193,133,176,83,48,165,242,99,175,245,235,59,121,217,33,149,109,149,252,16,227,233,21,191,247,17,141,172,237,15,93,138,83,140,209,4,121,2,233,59,130,239,207,219,132,115,243,188,20,36,174,84,156,62,186,186,162,111,112,246,148,213,231,152,162,85,106,105,211,99,103,239,238,108,66,249,123,172,236,165,75,168,144,214,47,97,217,108,188,64,233,140,245,177,84,72,48,188,140,203,223,124,58,95,31,169,184,25,198,201,212,85,252,19,192,12,91,115,218,79,59,134,50,140,161,138,128,181,227,62,77,210,192,165,28,213,198,216,114,183,131,123,60,192,168,33,121,53,87,156,179,60,129,49,101,190,159,203,115,0,14,76,118,101,52,162,58,168,144,83,59,127,79,76,230,52,231,47,131,71,86,156,160,255,216,50,162,172,186,212,180,77,60,141,188,117,141,124,232,225,228,149,156,237,25,236,54,200,243,204,244,113,154,152,220,27,223,134,160,198,236,171,31,13,149,14,198,213,208,109,32,169,123,126,92,207,24,16,56,74,245,26,203,40,168,91,227,42,75,179,135,95,115,173,154,57,135,102,130,99,23,20,78,70,220,98,64,12,149,58,96,118,70,139,240,76,117,145,63,151,148,251,46,18,76,219,148,84,85,100,231,226,210,252,247,121,107,95,111,54,110,76,35,148,132,94,122,83,184,193,121,70,179,83,86,105,113,198,222,167,168,208,122,238,44,37,243,244,178,228,92,117,228,204,199,232,253,229,204,193,186,221,213,111,245,224,96,39,94,38,232,63,100,184,227,120,110,146,188,97,127,134,106,107,51,32,177,203,22,200,241,151,144,135,161,248,2,196,31,157,31,36,161,149,165,67,144,243,115,168,78,158,99,113,143,175,19,191,115,13,28,153,156,158,96,52,148,82,82,167,53,247,9,224,166,164,98,163,135,178,230,251,102,138,218,108,114,46,212,238,8,244,167,50,152,189,212,82,82,136,102,178,201,211,243,219,179,143,17,13,254,221,148,33,137,220,178,125,2,165,108,83,42,247,205,9,181,233,105,22,193,77,199,181,210,237,11,166,140,155,43,74,194,73,55,242,151,220,150,10,202,121,196,174,91,200,99,219,131,156,9,13,70,112,227,77,156,118,218,73,92,183,56,72,12,71,76,208,221,179,235,167,111,62,103,12,81,153,231,251,116,197,106,105,112,92,229,22,81,57,221,248,231,103,51,237,48,106,144,51,236,223,68,238,209,208,153,150,253,239,39,48,221,113,227,137,142,52,202,111,2,15,175,240,255,113,182,55,248,139,250,209,92,104,216,4,116,178,18,50,115,160,76,10,105,3,190,138,72,125,21,128,143,140,63,135,23,67,53,131,245,172,221,241,174,157,79,76,106,251,99,75,27,11,154,244,135,236,229,194,160,28,85,74,54,215,145,206,113,208,6,167,89,237,101,83,134,20,146,22,128,18,75,239,10,245,26,22,3,207,204,136,183,3,59,91,23,45,84,140,96,213,20,117,255,5,88,2,83,200,50,57,12,125,159,245,143,115,60,193,94,147,17,104,144,180,10,31,203,33,161,139,101,132,0,16,131,10,187,156,154,213,84,11,164,187,157,54,106,166,6,219,70,22,162,136,185,177,65,254,224,60,208,155,169,236,39,32,10,84,156,171,194,206,156,132,142,180,235,76,36,178,136,101,104,41,107,1,74,153,58,139,79,39,213,131,122,66,4,38,68,173,11,254,10,161,63,56,17,217,54,149,190,167,135,215,0,225,88,14,54,169,218,54,179,190,76,59,202,132,213,43,145,122,101,208,28,83,249,238,160,163,134,100,151,212,64,240,71,159,6,5,61,106,201,53,164,78,143,184,54,116,235,27,32,121,247,66,23,147,129,39,21,58,247,133,181,158,64,32,71,236,42,211,160,29,3,90,11,73,120,161,186,238,42,86,181,87,209,166,241,23,244,7,187,106,112,154,217,190,50,235,244,93,230,229,26,117,3,38,152,237,150,87,30,26,103,125,108,132,184,88,200,27,249,186,172,137,235,97,78,238,6,51,25,152,44,107,111,222,36,22,85,7,29,81,249,89,3,168,136,205,248,244,224,122,45,225,46,16,82,158,13,216,177,82,98,174,17,216,218,178,11,125,131,41,55,168,163,12,5,179,142,1,111,24,222,47,234,168,248,153,54,114,171,12,252,37,78,74,49,94,144,27,144,210,237,234,202,204,41,157,109,175,151,222,148,141,62,27,91,101,249,195,66,93,172,9,42,69,189,215,152,85,128,194,24,130,130,37,246,153,182,85,64,218,69,172,58,116,248,124,82,243,94,90,39,145,60,119,69,116,73,163,222,188,10,96,142,47,162,30,176,128,47,229,243,111,34,160,31,16,201,69,40,59,147,48,185,40,229,57,80,240,163,157,147,120,35,76,245,68,87,131,87,22,60,235,10,154,85,204,154,2,250,157,76,182,124,147,88,130,165,232,90,145,150,156,0,206,35,60,123,149,26,102,47,245,61,55,61,220,108,239,159,48,227,3,245,188,191,215,134,117,18,0,139,80,214,238,65,6,212,70,212,138,156,66,0,152,81,104,125,20,175,166,21,10,28,218,127,18,224,186,47,95,18,38,255,155,121,82,191,173,98,64,126,112,118,93,68,177,119,84,19,214,102,182,104,245,55,168,124,144,124,21,52,171,150,13,138,8,238,253,13,115,200,11,244,118,40,24,162,163,33,79,253,142,211,42,198,26,194,90,42,76,234,22,174,255,225,19,136,114,18,76,86,214,27,200,167,112,147,160,212,35,32,166,5,8,154,33,118,113,55,231,252,237,243,204,78,15,27,26,125,179,2,25,23,161,179,239,126,17,225,151,147,10,64,86,108,201,129,9,46,175,76,214,254,168,128,140,156,210,68,200,217,38,242,239,92,147,86,172,11,35,20,47,253,64,175,176,41,10,0,100,206,14,184,232,56,176,210,110,187,20,208,202,43,186,121,249,182,226,233,172,226,154,212,2,59,64,0,39,181,127,104,131,30,58,41,56,77,53,42,157,84,156,39,46,81,216,232,136,22,11,107,192,100,34,163,109,148,249,77,111,41,25,129,40,61,17,107,250,157,237,43,221,78,60,66,205,61,144,59,30,6,46,47,28,24,170,102,2,85,120,86,61,114,2,129,186,31,186,12,145,241,252,143,61,148,64,54,155,119,118,62,61,196,188,252,165,243,3,87,58,45,95,116,175,34,10,126,39,224,213,87,92,34,49,109,63,136,65,101,123,183,251,208,249,58,158,88,244,100,212,13,47,139,40,247,47,88,41,96,62,103,225,39,43,21,34,206,216,126,221,188,255,32,231,251,229,61,230,231,246,138,20,221,212,165,115,48,128,50,181,37,236,92,114,208,119,100,125,103,92,2,251,183,39,52,136,89,240,112,126,119,137,57,176,6,0,84,52,52,220,35,41,7,110,10,147,192,121,195,6,21,149,82,153,5,242,44,222,101,131,109,24,106,152,66,139,173,24,214,229,209,206,87,231,182,23,116,118,190,223,8,250,244,223,107,152,230,45,252,190,3,24,165,34,242,21,252,73,40,98,193,232,205,162,129,252,216,208,81,150,75,94,135,227,203,222,0,157,47,181,45,244,241,41,40,223,84,247,128,241,250,129,20,141,144,3,91,167,87,56,77,176,183,76,101,127,84,231,135,145,57,208,177,8,17,54,168,87,60,119,78,11,184,216,9,67,200,131,154,129,123,211,105,87,20,75,154,123,101,227,137,21,103,185,46,122,58,76,164,109,124,176,224,70,12,143,5,116,48,246,163,62,49,197,211,92,78,148,195,12,23,14,221,67,82,163,202,18,61,186,170,148,114,135,229,232,80,173,146,195,106,124,209,109,95,71,22,213,127,68,88,103,75,162,209,155,105,252,200,211,253,165,6,115,139,0,19,62,209,22,115,174,1,105,219,132,13,79,204,172,139,123,183,130,70,126,104,136,73,140,128,221,143,193,66,74,160,186,41,211,229,152,125,225,198,181,64,252,152,209,202,158,36,114,10,218,57,198,83,199,148,185,244,86,149,70,110,134,128,187,192,234,101,139,86,132,117,151,244,178,172,235,44,219,36,177,94,47,57,119,159,27,34,203,35,244,145,246,235,131,11,105,55,219,171,16,152,6,168,40,229,144,183,161,230,109,180,105,119,8,62,165,126,53,93,6,248,55,3,190,211,186,89,224,130,237,232,131,114,242,195,2,214,247,240,62,14,60,204,169,208,88,58,163,124,253,227,65,236,249,209,25,30,243,61,92,62,66,145,144,104,168,115,43,210,210,3,42,37,27,209,161,96,212,170,230,154,66,231,28,187,161,10,156,64,11,124,90,190,12,97,111,237,66,184,216,146,171,36,11,119,231,139,212,82,11,151,7,51,51,0,95,55,76,57,83,109,233,224,164,220,60,147,23,15,17,190,130,251,211,67,78,8,144,156,118,255,200,50,65,115,79,177,158,133,155,61,148,209,89,17,75,57,152,199,46,112,211,10,60,151,209,103,173,174,173,22,193,171,123,165,133,235,230,240,4,102,79,15,159,69,26,13,249,176,247,102,103,230,3,79,69,103,74,94,124,129,14,231,60,89,185,43,95,6,102,212,124,107,249,151,169,157,52,201,68,210,18,60,16,57,242,1,17,32,182,213,125,243,3,119,26,203,4,60,25,24,247,44,148,46,41,123,246,164,118,2,115,76,129,119,17,37,242,240,113,103,155,18,33,103,187,141,252,77,169,60,222,117,29,123,218,5,149,183,255,151,35,246,168,104,113,131,73,217,175,106,164,163,195,68,216,39,16,31,21,183,101,117,27,35,18,251,64,9,21,103,30,105,28,61,182,54,77,183,217,209,247,248,43,33,88,242,2,1,236,212,42,143,232,177,89,172,249,71,40,188,222,217,130,93,243,111,204,142,15,234,3,28,76,50,225,186,214,186,177,133,89,73,1,100,143,79,62,76,247,235,137,107,73,17,2,209,16,35,65,138,143,113,12,13,135,157,184,251,6,138,44,73,229,148,148,254,130,50,247,22,195,124,60,236,239,27,24,187,35,71,176,91,161,222,30,250,89,63,0,192,56,218,138,131,188,16,234,20,33,34,220,152,180,214,6,79,138,50,126,40,239,99,123,248,9,213,254,233,32,185,56,180,210,127,74,201,254,140,221,176,180,104,55,29,72,105,206,15,14,135,33,231,232,180,182,111,153,12,56,186,183,17,169,55,136,31,171,228,188,95,165,103,78,92,121,21,199,216,138,193,248,32,199,250,19,87,133,94,254,0,69,144,246,28,60,142,87,240,255,32,116,40,43,151,89,85,90,168,74,140,130,69,95,116,40,36,172,180,95,109,75,69,72,43,43,81,119,122,0,79,216,149,34,111,107,96,125,225,239,45,80,125,226,116,33,231,38,152,157,219,249,183,243,218,252,206,79,210,187,118,14,32,15,1,47,199,51,129,146,7,234,28,191,95,137,137,255,24,54,129,84,15,153,225,223,32,175,236,45,125,177,204,92,123,213,250,174,45,247,210,98,73,43,125,99,143,48,58,169,174,204,86,104,235,232,16,85,129,216,171,194,129,81,201,214,220,55,114,117,130,84,88,109,209,134,10,154,117,102,105,77,117,113,39,121,71,161,148,119,216,235,25,59,58,251,107,188,0,57,28,176,102,77,113,5,219,2,230,243,113,11,41,50,95,127,11,238,139,112,60,87,169,216,127,209,10,213,236,215,198,89,252,151,94,198,150,203,187,38,6,105,51,218,253,92,89,13,89,125,119,218,50,151,110,141,164,66,129,205,33,52,111,201,205,208,106,2,111,199,103,148,102,66,192,23,122,243,52,38,253,91,221,70,180,144,44,192,144,196,79,118,9,116,211,2,149,126,33,153,60,118,117,212,157,177,25,146,12,40,202,192,71,149,186,189,140,108,98,38,174,94,47,31,103,72,175,52,144,171,212,23,144,237,235,160,224,158,170,236,177,114,16,161,145,236,96,218,144,16,93,220,90,161,183,158,164,71,161,196,247,185,249,106,175,109,76,131,29,112,147,165,205,173,15,43,94,172,2,197,59,152,198,53,26,10,190,217,215,38,31,143,96,26,169,138,66,42,7,42,37,168,166,251,195,51,117,58,46,81,252,137,137,182,197,151,57,177,117,177,249,110,152,231,124,86,123,10,246,71,232,211,139,186,177,151,93,248,95,27,197,251,83,19,64,118,183,109,24,88,58,116,245,225,12,45,11,66,5,174,157,54,89,53,219,169,67,72,67,200,183,94,246,20,227,134,220,248,36,85,146,83,149,157,48,101,51,140,55,8,147,179,4,210,180,24,121,219,186,124,192,239,16,189,135,201,116,60,217,150,173,180,91,115,56,137,221,113,130,108,188,216,142,111,107,45,31,178,153,244,25,117,7,6,166,79,67,152,55,166,239,85,187,216,52,96,58,150,79,238,92,52,237,150,154,126,0,53,126,160,33,16,173,232,13,222,211,6,91,25,63,23,191,32,32,238,184,76,114,190,233,139,236,250,129,219,23,149,198,65,165,91,195,173,92,162,152,254,43,218,89,215,124,136,55,141,220,123,5,228,116,71,30,124,227,172,59,148,217,57,254,12,252,209,245,68,52,163,135,197,101,27,115,0,72,80,88,20,142,255,175,25,184,41,161,74,148,83,62,2,214,56,223,6,36,89,1,29,21,124,176,142,58,104,122,92,163,203,90,247,174,113,254,28,201,93,255,213,149,10,126,103,197,148,160,236,168,115,154,215,180,81,23,255,217,53,70,212,158,79,80,83,10,25,218,82,57,3,92,141,152,195,196,75,42,5,137,2,19,229,205,124,5,229,37,162,146,26,57,127,71,189,182,195,203,254,88,197,178,119,250,121,112,1,209,237,46,70,75,27,106,210,136,239,122,132,181,181,97,86,133,103,19,177,39,15,181,199,182,251,162,44,54,10,12,175,46,167,166,19,186,21,40,236,118,36,203,24,233,206,219,63,183,168,247,91,214,251,134,197,12,112,215,187,233,35,173,27,141,12,90,181,66,188,15,166,121,18,132,33,35,0,145,194,29,80,211,142,127,203,243,200,109,7,23,169,248,120,146,38,144,161,242,62,28,121,59,105,57,22,116,128,252,187,23,63,202,11,7,179,194,215,139,68,93,5,93,61,234,81,92,229,3,24,25,227,190,155,199,15,124,69,4,141,84,231,226,144,122,4,151,52,194,18,217,35,252,169,123,80,192,106,164,109,34,36,189,13,215,3,84,254,74,203,77,32,121,4,25,154,72,49,128,206,133,116,241,193,128,73,240,177,114,65,138,191,254,74,117,27,114,139,216,64,20,129,2,124,129,110,0,220,110,79,229,101,109,50,48,249,135,173,205,30,34,213,24,182,114,176,129,200,240,123,96,12,60,231,213,45,105,59,100,234,47,123,98,38,254,27,149,74,64,15,172,25,63,249,175,39,193,46,100,159,190,119,59,232,75,94,34,174,168,160,126,23,173,21,117,171,22,51,194,180,150,144,159,190,82,36,4,51,222,168,108,152,254,55,64,222,63,203,239,88,192,194,101,228,40,198,111,220,209,64,248,126,102,57,188,35,87,132,206,45,120,12,132,32,168,114,211,140,88,203,46,156,144,199,172,219,45,111,34,56,156,153,160,93,27,244,221,202,161,114,80,141,180,98,70,242,140,237,123,175,4,64,86,25,233,145,134,40,133,3,81,234,207,91,8,242,18,133,255,227,132,164,66,122,81,198,155,228,247,190,63,29,60,35,7,155,84,0,183,71,237,120,117,139,12,116,187,55,63,15,102,135,204,210,166,105,227,170,154,64,116,124,116,132,5,88,195,254,57,126,84,183,193,209,149,165,128,131,115,29,235,149,96,7,83,216,87,60,162,91,50,124,73,0,107,95,140,79,31,34,77,207,36,164,76,253,27,93,115,196,222,254,240,130,230,151,93,201,163,150,42,14,132,232,127,176,178,3,18,153,149,80,49,41,28,185,10,84,131,116,248,56,51,33,87,183,250,206,214,91,220,97,83,13,0,217,178,17,41,214,237,72,1,26,13,184,98,149,43,103,175,225,211,65,128,70,174,232,64,211,127,235,249,242,185,248,110,187,97,204,202,139,228,86,224,104,49,211,16,164,158,98,112,7,164,91,14,227,124,223,126,163,241,205,13,112,200,183,214,82,2,216,1,213,203,63,63,173,180,28,48,131,180,109,29,16,38,192,98,40,76,158,234,181,233,242,81,167,198,116,220,166,38,232,161,67,102,86,246,186,68,176,27,141,71,112,98,47,72,207,96,115,67,102,37,240,161,253,219,107,2,210,100,158,116,116,187,104,230,131,167,228,113,220,86,111,112,159,121,145,35,119,93,79,133,126,164,142,216,186,6,139,145,148,31,131,30,86,237,155,100,21,24,223,155,151,153,152,39,192,73,169,44,121,135,209,215,230,106,40,144,142,181,144,150,175,75,30,49,190,115,122,248,138,16,201,65,243,179,10,144,22,125,236,228,41,97,172,192,47,118,26,97,61,152,83,250,232,69,47,77,139,41,196,194,6,68,127,83,6,81,76,27,0,3,66,113,132,237,49,126,4,192,26,208,235,188,62,147,9,53,149,118,21,62,80,153,129,121,155,178,191,210,21,215,252,56,222,33,207,16,178,101,177,53,170,214,84,22,44,21,47,177,253,108,99,161,230,218,8,45,54,180,41,150,134,229,2,141,100,202,69,253,225,237,223,229,86,109,89,226,67,0,89,187,233,224,182,197,46,81,235,197,78,2,18,177,73,237,241,13,245,253,45,153,9,164,138,80,208,225,208,24,214,65,181,20,136,225,147,135,250,202,51,82,224,137,5,142,78,255,200,49,231,78,112,44,49,214,239,234,21,229,83,251,158,182,104,238,123,252,109,221,88,164,169,179,106,176,198,41,188,121,6,238,241,93,152,236,43,46,21,61,6,97,34,152,221,37,213,42,147,181,84,134,96,101,234,178,248,171,9,51,38,53,132,249,252,103,107,23,149,78,223,248,150,218,87,63,94,164,47,109,33,166,163,36,36,155,195,218,101,132,225,140,220,40,200,133,182,170,220,13,4,25,194,172,202,109,133,7,212,134,70,29,191,128,168,30,220,58,149,9,168,157,122,67,216,128,139,39,154,46,54,233,167,117,176,160,234,94,236,86,206,9,60,229,168,8,144,224,19,157,226,13,69,98,155,80,240,36,101,126,198,102,108,126,69,59,106,147,133,62,109,253,174,169,133,171,7,41,51,247,32,148,153,154,166,186,137,39,115,107,110,198,241,183,85,109,2,237,145,235,53,53,176,105,14,16,73,67,148,88,168,90,8,130,38,214,42,253,120,32,21,48,92,236,249,109,116,2,130,138,143,122,239,135,87,25,233,145,155,92,26,87,123,65,31,49,145,118,123,23,209,11,91,140,168,106,65,254,217,90,7,96,81,24,71,169,23,87,210,251,12,101,145,155,20,214,222,134,232,99,90,161,31,107,34,39,18,176,254,233,25,134,141,181,22,48,83,4,9,175,232,212,195,137,202,20,47,31,144,2,171,63,229,161,30,55,240,13,64,81,169,171,158,32,141,101,213,113,72,215,138,11,91,231,191,34,75,244,193,135,144,27,246,128,33,137,204,96,96,233,172,27,57,146,61,193,74,241,222,99,207,36,229,44,113,37,61,216,50,42,85,168,45,51,144,17,126,246,35,167,73,107,195,230,212,6,138,227,227,117,190,200,254,28,67,203,122,1,174,244,101,190,46,168,213,26,86,125,72,174,38,128,116,208,37,80,4,179,111,3,210,254,152,58,24,153,186,38,38,241,47,233,235,192,161,102,204,81,135,246,113,83,234,248,56,199,216,55,104,127,172,242,171,99,105,45,72,94,51,164,87,23,246,184,141,111,248,48,120,116,229,142,54,221,92,54,175,170,191,194,213,101,35,89,146,236,205,171,67,194,217,48,237,119,250,175,143,79,217,188,203,243,236,148,155,97,11,153,61,254,145,230,221,73,205,80,0,104,75,50,61,76,174,32,177,204,182,232,112,81,223,82,113,43,236,93,128,57,199,102,177,4,124,204,33,214,61,23,147,8,4,199,13,220,76,13,152,41,39,39,151,74,16,16,186,83,80,6,150,4,254,22,19,168,195,239,2,151,34,122,146,145,92,69,23,180,130,212,52,143,217,40,94,229,42,221,18,106,178,241,67,163,113,192,189,229,131,186,71,8,195,18,52,118,102,49,246,6,143,148,147,140,125,24,186,120,144,190,18,78,32,246,154,118,241,199,135,118,36,69,37,122,63,238,38,20,84,252,139,160,33,184,144,12,245,233,124,27,103,177,210,98,5,149,23,218,138,233,177,191,51,181,5,227,176,220,191,102,146,83,80,46,29,200,215,176,159,117,13,43,138,198,147,130,116,67,125,100,157,238,46,227,178,239,88,24,23,51,167,88,174,10,49,38,23,201,25,22,32,10,28,17,131,16,252,113,12,11,125,142,226,16,140,65,219,254,72,59,251,192,222,186,42,6,237,24,13,25,0,9,140,218,187,9,129,146,33,163,129,7,21,94,194,234,193,169,241,176,125,82,175,67,134,141,24,136,150,81,93,216,208,125,227,179,238,68,114,57,181,224,217,207,57,167,208,223,225,250,137,48,2,186,163,48,46,194,24,2,201,201,202,253,19,174,81,107,140,57,208,141,71,126,235,113,130,141,157,179,47,105,241,42,53,176,194,103,230,200,194,216,0,45,179,161,5,12,18,1,23,24,159,217,45,121,130,220,107,231,132,22,41,245,79,143,4,67,154,3,32,208,73,183,42,241,217,186,145,252,223,87,80,57,240,115,0,56,43,173,229,142,95,21,129,242,77,179,47,131,153,219,42,207,90,204,11,177,195,198,92,21,101,134,160,190,246,230,200,16,98,164,208,113,234,223,138,26,178,70,214,218,102,105,79,239,190,111,205,103,145,212,113,123,250,42,77,40,250,193,65,106,3,31,123,187,145,142,157,144,103,8,59,122,232,235,40,6,69,254,207,223,194,73,77,110,181,129,120,79,168,209,0,33,80,216,115,152,195,195,139,120,148,178,4,195,159,219,135,255,193,58,195,19,122,95,31,94,53,3,210,42,137,159,233,169,55,242,89,241,1,70,55,51,192,124,164,86,51,130,124,101,84,99,20,116,120,194,230,248,200,57,5,172,3,177,203,16,177,147,126,88,150,182,47,57,198,142,223,231,208,19,221,168,191,238,39,80,18,41,198,65,56,30,65,148,46,4,146,56,9,246,6,197,183,40,247,6,17,218,49,101,50,147,69,98,76,213,96,233,40,206,227,197,137,170,110,8,87,151,162,0,106,103,202,128,177,31,91,23,68,144,114,96,206,121,209,204,40,141,95,241,202,16,245,22,222,121,254,91,197,92,217,242,198,86,238,117,61,2,85,243,250,193,161,225,115,255,29,140,195,131,241,29,223,223,124,236,22,163,255,120,87,210,183,32,85,83,78,139,164,74,114,162,56,124,237,118,99,216,140,220,235,145,69,14,148,231,160,138,124,156,153,41,11,235,37,5,242,134,147,86,79,108,1,13,118,24,221,23,243,99,54,113,63,249,151,12,8,189,85,93,140,245,242,250,4,138,13,64,67,250,180,44,146,41,17,227,29,160,249,238,205,53,86,125,199,17,205,118,126,180,62,63,38,157,76,60,98,80,51,129,108,3,149,122,188,154,250,9,196,123,150,141,11,66,222,83,17,127,154,246,246,233,67,111,7,33,157,56,213,92,137,82,115,87,125,0,207,97,124,232,232,92,56,5,167,137,201,176,183,205,163,87,179,221,229,42,142,99,51,90,163,204,242,88,213,108,197,168,143,20,21,55,82,115,163,77,123,34,18,216,27,52,5,172,225,195,239,244,178,158,74,147,230,147,176,212,126,42,2,149,23,179,80,24,163,218,210,189,255,27,28,34,78,248,212,100,134,121,212,143,49,239,183,112,60,66,163,159,56,26,87,201,149,175,115,55,228,21,144,101,116,233,194,114,176,15,15,207,247,74,65,77,89,205,191,131,190,174,46,161,31,33,0,249,41,14,246,168,177,196,40,165,195,109,60,36,22,63,71,196,74,12,33,28,16,198,139,58,240,223,170,118,208,225,154,23,66,189,248,75,109,191,146,162,156,254,178,156,87,7,36,190,72,198,129,216,136,238,86,69,40,205,101,176,34,67,208,153,56,219,173,40,142,73,93,3,35,21,143,47,19,161,41,182,143,10,208,20,126,176,172,248,147,52,229,168,71,203,153,52,231,145,73,135,90,236,141,68,103,47,109,142,198,245,120,119,226,32,143,52,215,89,67,64,117,10,46,135,155,150,119,11,175,186,126,240,28,224,54,25,247,59,35,49,63,72,93,161,172,26,15,155,193,108,184,42,54,174,217,20,3,29,241,69,240,199,40,28,57,127,165,93,229,52,74,187,127,150,225,145,142,91,58,103,11,186,137,199,72,151,86,158,227,158,188,47,230,217,223,159,245,185,161,92,61,63,152,60,253,165,59,86,239,238,172,228,37,52,191,23,119,40,186,106,60,24,176,190,190,205,136,0,41,123,208,68,28,199,41,88,252,162,45,168,149,211,72,140,48,62,153,114,141,160,13,134,136,66,104,93,162,44,7,247,77,159,236,61,13,171,67,215,20,111,31,39,112,92,35,42,109,219,184,178,160,144,118,51,243,234,79,61,247,8,177,143,109,102,111,170,9,250,172,123,85,240,98,60,111,142,37,196,78,39,93,216,26,129,250,158,8,38,10,193,83,201,221,30,28,42,17,224,3,42,110,46,133,244,4,41,12,142,66,198,133,86,1,77,194,181,66,122,41,176,75,70,28,205,38,95,162,29,32,251,99,21,39,40,125,182,86,233,139,148,209,64,135,12,157,17,30,148,189,77,35,1,85,77,90,7,158,39,156,31,95,123,117,12,82,219,69,18,158,214,123,139,159,201,36,167,6,55,219,78,167,181,122,71,90,173,10,156,222,122,178,108,219,60,244,167,151,135,72,222,140,53,45,45,48,201,25,210,236,35,68,56,219,213,228,57,176,45,67,213,35,13,235,253,236,213,24,2,2,115,60,122,249,240,36,186,185,73,128,136,208,202,213,252,240,144,50,134,205,166,163,169,38,82,81,57,176,47,239,118,26,217,18,35,151,3,56,142,105,156,182,54,220,191,127,175,73,185,191,90,156,84,226,1,107,40,221,87,73,100,125,95,161,199,220,197,166,108,143,195,184,149,168,83,142,97,132,172,36,11,181,245,64,101,171,131,243,239,210,18,229,241,204,202,94,111,78,192,163,22,45,94,33,104,22,47,156,40,33,98,211,98,96,143,246,144,218,157,216,180,69,184,243,16,219,212,38,152,126,156,133,12,54,237,236,39,236,153,146,33,94,245,193,242,80,234,170,157,133,71,212,31,240,136,47,77,157,138,252,172,196,177,51,62,24,131,82,166,134,86,254,145,208,220,108,219,24,218,96,50,158,96,144,124,251,239,208,186,84,9,91,102,40,82,43,3,120,117,252,29,106,64,111,3,238,120,7,170,115,106,245,226,210,78,11,140,41,4,118,213,109,157,196,15,148,234,125,159,200,251,145,179,203,189,125,53,237,231,4,9,1,201,114,208,143,230,193,163,94,11,125,246,197,159,251,107,89,45,178,65,182,140,44,224,13,250,201,234,92,225,86,145,33,5,130,171,32,255,146,41,109,85,9,149,225,108,21,42,16,36,51,229,232,32,77,134,90,123,255,146,45,95,203,185,202,204,159,244,255,3,64,23,65,96,223,136,66,239,75,116,220,138,52,237,156,208,116,47,237,164,87,125,146,18,242,145,49,131,239,154,53,167,172,186,196,25,43,73,102,167,40,166,19,255,36,105,91,48,236,34,146,21,44,164,56,35,92,74,120,208,185,239,50,172,187,115,190,222,129,197,248,217,238,7,20,58,7,195,186,195,137,154,184,82,42,255,166,137,42,193,39,240,80,15,218,151,166,72,126,233,5,135,21,113,133,44,167,103,210,132,44,222,173,68,214,250,86,3,56,199,79,230,128,141,141,211,3,136,170,230,40,135,195,208,177,150,33,137,219,98,102,11,205,212,185,36,238,196,158,182,249,126,34,218,21,173,163,162,197,56,27,102,111,160,106,127,210,19,242,215,94,89,164,189,49,43,44,203,98,20,138,170,244,162,68,231,46,103,80,89,238,224,62,238,108,101,42,90,109,91,226,60,137,137,111,148,145,82,163,125,158,255,68,178,75,152,172,4,2,150,171,244,135,218,75,231,61,161,94,94,142,69,127,93,62,211,225,27,60,147,217,32,72,50,36,197,89,4,128,236,232,203,50,110,96,155,139,80,255,17,99,236,12,62,234,29,53,100,98,60,54,102,47,227,147,140,18,204,63,172,46,195,33,84,179,1,232,146,186,190,147,34,27,12,118,36,46,166,176,94,97,117,215,123,174,63,48,2,111,175,32,154,25,35,100,10,4,176,144,206,40,160,14,197,192,136,202,245,88,60,106,253,222,70,147,238,133,239,246,39,23,128,72,219,213,193,180,54,224,89,149,20,129,190,186,231,122,78,171,145,199,194,116,157,78,214,153,165,185,41,120,180,236,71,2,28,143,215,153,243,7,74,151,62,36,138,205,207,86,16,95,82,200,41,67,232,179,199,50,10,145,195,238,251,83,103,235,37,236,70,244,193,168,25,110,54,125,79,85,184,168,157,201,239,60,241,250,79,18,90,20,80,233,230,169,9,177,71,244,240,240,132,255,247,78,251,80,115,88,17,2,21,194,227,251,155,152,236,59,44,253,243,10,69,72,230,214,19,180,83,77,108,106,51,55,102,37,176,82,6,117,178,217,73,229,209,9,146,58,250,6,126,47,155,60,222,2,126,79,110,194,215,32,169,157,90,108,76,14,4,183,112,163,245,227,223,232,241,177,202,245,254,149,107,158,152,29,137,37,200,76,255,228,167,21,66,129,101,217,36,104,143,222,114,93,149,193,118,46,174,58,55,234,148,57,195,211,45,162,134,93,204,140,18,205,166,234,137,242,110,199,15,197,115,252,183,43,210,188,249,28,35,222,239,175,213,213,45,38,19,199,203,128,87,67,202,47,207,184,192,17,51,152,160,107,229,147,173,24,208,38,35,44,69,235,68,78,200,113,45,11,228,128,94,98,78,220,208,141,42,61,28,132,35,199,248,182,59,81,136,38,72,22,25,129,247,57,201,67,144,119,97,217,24,45,149,172,131,249,125,67,179,39,13,65,15,242,20,73,128,107,130,215,210,188,30,80,208,32,94,114,53,228,15,219,159,157,79,33,25,144,106,43,153,94,240,151,5,172,213,76,250,247,219,188,98,252,201,64,157,65,181,196,61,146,127,236,13,222,0,107,124,42,146,115,12,221,54,189,138,39,187,45,197,37,77,31,178,4,62,146,201,128,54,105,255,67,115,139,63,239,205,61,58,90,80,105,29,87,158,250,2,79,99,205,249,15,248,198,175,243,166,212,19,52,70,144,87,104,73,121,80,123,240,62,62,7,230,215,80,179,160,152,49,57,248,187,93,160,218,106,201,52,88,165,251,22,115,36,58,41,39,4,92,221,111,145,113,176,36,195,136,53,69,92,54,165,51,84,151,187,133,236,121,12,76,1,41,197,224,32,195,175,153,157,211,33,219,122,132,127,16,91,3,75,188,216,186,185,135,123,183,12,39,250,229,164,197,126,72,118,153,46,101,64,225,8,249,9,111,84,55,129,202,253,71,239,203,107,158,33,255,149,189,242,238,180,197,5,228,137,229,124,39,120,3,148,254,115,16,184,89,24,107,47,52,110,232,248,69,179,208,32,104,63,118,218,101,235,199,197,96,173,162,198,39,161,192,96,124,83,124,151,31,233,169,78,191,194,243,155,251,120,218,86,215,67,196,219,224,7,74,98,64,32,125,68,180,125,64,204,187,205,39,208,84,213,20,34,80,138,245,30,238,234,238,106,28,219,59,34,67,112,253,255,3,65,139,230,198,167,35,224,252,37,136,153,32,12,186,236,133,103,158,129,58,104,226,98,62,154,149,102,7,172,9,53,51,202,93,153,184,81,32,96,32,1,118,147,117,125,212,138,84,217,4,185,255,19,60,124,125,36,62,41,144,133,10,116,231,77,134,11,92,140,90,38,158,18,254,63,227,2,42,14,186,158,187,19,163,64,139,192,103,26,188,244,31,188,253,179,118,24,105,139,160,236,219,41,209,178,107,199,173,13,218,77,126,197,192,212,215,212,109,233,165,107,158,47,252,34,84,179,116,74,43,244,72,67,217,4,101,48,243,220,251,177,199,8,15,246,27,178,223,157,40,18,203,244,209,12,21,246,231,152,109,5,142,188,198,165,86,138,66,52,178,30,213,249,80,183,114,129,238,116,202,237,62,75,77,157,47,3,20,7,49,105,139,240,96,61,184,2,89,186,125,106,128,143,162,234,88,47,252,23,7,32,66,39,141,119,63,238,167,69,162,239,84,111,126,40,122,112,255,147,21,56,119,68,25,7,177,111,171,79,221,55,11,224,148,146,208,0,66,69,151,124,65,83,34,30,48,68,5,226,70,93,235,58,10,164,111,0,161,75,15,248,208,41,142,148,57,163,224,37,252,133,24,240,48,158,47,3,231,99,116,124,172,113,144,242,70,194,226,101,122,230,206,214,97,136,26,32,250,157,85,197,54,15,18,244,200,157,225,223,243,45,114,116,156,4,206,72,199,190,9,125,119,204,37,138,105,156,17,133,145,82,54,202,119,115,226,252,205,31,96,143,146,182,223,75,117,144,160,146,183,177,138,4,195,20,53,120,54,216,199,92,90,148,104,254,62,59,51,36,187,218,183,249,153,230,0,42,40,70,233,240,247,233,194,27,22,155,219,68,189,216,209,188,151,255,21,185,99,101,67,30,87,101,51,211,247,16,2,36,78,191,16,216,103,89,93,197,244,211,249,246,239,229,177,118,45,79,60,137,112,195,132,165,5,130,191,157,54,140,39,77,250,114,54,105,167,230,208,221,155,186,198,90,142,5,73,195,117,48,218,138,78,162,142,242,3,40,64,254,55,24,58,46,104,97,9,167,233,232,194,65,159,124,68,129,98,161,74,53,119,26,220,2,35,175,114,74,41,155,222,195,176,22,62,18,176,60,109,187,164,190,36,92,184,64,14,62,76,201,244,51,120,55,234,249,44,134,218,221,139,216,51,183,202,45,201,188,230,187,200,152,75,73,234,31,37,96,198,237,225,203,136,102,208,111,70,44,196,30,155,28,10,163,169,54,5,34,36,173,233,32,0,228,155,174,175,100,40,176,115,87,197,96,122,101,6,55,67,221,202,212,147,22,184,78,200,54,228,249,161,22,212,188,28,148,94,42,136,127,136,77,33,111,123,21,22,123,89,113,155,150,45,206,237,207,7,140,187,197,90,48,141,16,14,154,106,245,22,115,254,88,11,90,34,129,212,24,167,148,177,97,231,176,221,187,9,214,148,97,47,95,104,223,243,92,45,104,89,23,118,176,238,35,183,160,111,66,30,92,229,215,157,231,137,7,85,144,81,5,193,30,247,40,161,249,40,108,44,251,34,239,59,43,179,3,66,125,107,167,77,200,191,187,207,176,163,120,63,193,145,253,178,191,66,141,248,236,146,58,145,238,176,212,54,8,244,7,219,237,85,36,86,253,219,61,131,116,142,90,36,226,234,69,140,240,182,77,75,124,154,125,197,56,190,169,151,79,15,24,166,191,58,177,173,45,19,21,59,188,117,92,45,254,26,52,131,40,75,250,40,79,186,224,116,169,75,15,116,125,26,184,141,174,48,240,85,157,71,46,63,165,229,115,92,195,56,137,69,95,39,78,169,56,121,210,200,43,29,48,31,162,49,168,134,1,207,2,58,217,165,195,137,167,184,9,103,237,76,137,46,76,254,73,90,105,158,157,35,100,65,139,213,236,218,146,135,106,223,84,4,250,27,129,187,110,177,202,19,40,226,36,17,125,140,191,60,65,108,40,130,61,172,138,234,52,167,226,248,85,120,106,165,16,145,160,102,120,107,165,149,43,153,130,153,232,16,73,239,4,176,231,142,181,95,77,112,93,3,130,253,5,194,178,95,163,209,211,61,131,195,59,8,43,182,230,2,170,5,189,117,33,56,141,97,19,219,162,141,110,254,161,66,39,15,46,169,206,62,80,73,211,230,139,195,21,205,231,185,42,159,208,139,31,233,188,130,69,148,71,87,195,78,200,115,117,47,176,236,135,42,166,168,123,97,43,231,183,162,27,90,191,211,29,35,252,173,250,3,19,180,224,18,6,207,135,9,254,198,220,183,24,38,61,138,211,80,46,225,28,136,64,121,173,233,86,156,52,249,234,1,114,224,61,44,16,90,47,112,15,15,157,64,43,218,196,179,69,219,113,136,99,40,107,50,238,241,140,184,133,173,151,228,13,37,217,235,155,245,65,25,225,165,197,208,227,252,202,99,185,125,1,107,142,233,45,217,57,111,154,215,238,146,158,135,85,62,230,118,230,86,222,134,191,192,163,177,191,173,126,203,32,215,191,226,159,77,18,217,178,101,249,135,183,239,134,86,71,188,20,120,49,187,48,223,225,220,5,130,146,8,210,222,135,173,168,192,219,213,213,137,79,171,121,44,155,204,223,15,224,10,155,154,66,152,83,36,138,52,198,89,185,115,201,39,30,173,110,86,111,25,10,131,53,172,242,147,147,205,64,46,52,131,96,115,254,45,39,99,127,117,118,105,141,237,252,251,15,76,132,229,3,237,59,118,91,7,209,43,89,41,140,39,117,33,9,192,85,231,40,95,117,241,77,89,168,69,234,61,239,158,26,181,172,163,242,85,216,147,217,45,11,144,237,154,235,97,79,43,155,219,139,158,253,146,152,20,131,138,181,171,215,209,155,238,167,43,80,83,121,205,20,250,219,13,8,29,253,178,241,206,149,18,44,130,243,18,112,119,42,5,194,101,142,157,17,99,155,200,175,222,218,95,132,137,169,126,59,51,188,90,113,228,54,173,26,56,177,114,243,63,161,43,41,22,36,68,38,244,139,61,81,245,59,216,2,27,105,4,55,236,183,11,159,26,28,107,112,76,19,108,225,239,163,57,127,162,139,170,53,65,137,117,46,2,182,233,203,171,185,216,23,50,227,174,102,71,131,234,144,45,151,247,17,167,176,108,95,7,9,163,174,93,112,48,174,80,56,90,4,253,11,39,30,250,242,152,232,201,192,211,6,163,112,130,232,183,17,68,221,212,31,98,230,198,64,88,224,169,115,92,31,130,73,153,84,217,205,57,12,157,243,138,212,220,192,194,159,130,80,183,28,64,173,187,98,18,60,117,172,37,180,206,209,157,24,85,53,38,185,234,125,52,175,62,94,112,27,87,243,16,161,12,189,75,122,1,34,225,40,5,12,54,193,23,63,128,36,253,16,253,226,191,13,200,108,246,69,121,254,86,61,241,20,215,122,227,170,177,188,216,57,138,141,207,15,147,108,240,199,189,37,52,107,119,199,159,197,247,103,117,145,74,133,105,107,218,69,229,26,213,151,124,216,159,105,21,49,11,25,217,121,142,131,42,190,105,35,232,125,82,73,24,192,240,27,179,254,137,117,82,118,92,197,62,187,227,156,210,55,29,158,59,221,186,210,131,56,178,122,102,223,20,20,118,38,76,138,61,35,161,59,84,215,135,250,17,212,170,103,121,74,54,183,6,84,193,16,160,132,211,192,161,132,236,109,200,245,145,4,217,101,190,196,175,183,192,3,125,173,242,59,67,47,27,31,38,164,221,57,244,61,19,146,250,224,238,211,34,249,49,186,42,195,228,185,8,60,61,144,167,125,166,124,130,135,196,105,165,143,102,5,114,223,42,213,248,225,4,150,213,211,126,63,180,13,7,193,198,2,59,113,253,41,197,142,211,43,58,38,247,220,160,41,231,46,224,241,120,127,230,245,192,35,174,45,117,17,224,176,210,5,119,201,154,107,238,220,222,81,173,150,141,201,204,208,150,189,199,89,101,173,32,118,74,152,146,242,57,33,201,11,175,41,179,161,234,179,24,176,65,186,236,238,243,213,149,12,57,187,156,134,120,187,146,0,253,242,154,107,124,200,91,184,245,161,91,155,142,148,45,147,115,130,179,36,63,149,228,175,37,56,196,241,202,60,235,116,219,159,183,23,0,253,144,90,14,86,9,29,44,14,104,225,51,66,144,161,98,240,151,153,69,188,155,23,11,155,113,222,186,98,4,39,40,4,208,58,83,107,28,165,82,46,103,250,221,144,18,130,170,191,237,243,37,36,114,63,94,111,85,243,205,125,219,184,91,173,55,108,91,53,22,163,18,107,140,110,21,2,243,90,167,129,7,42,229,167,201,11,12,111,33,37,124,171,88,50,46,242,78,140,149,32,83,218,80,42,69,64,81,229,187,85,181,11,114,155,120,29,137,51,148,27,173,205,6,241,17,225,31,29,100,120,114,175,100,113,134,212,81,182,112,82,251,154,246,144,91,61,231,21,234,224,185,19,112,247,201,47,4,238,7,37,92,42,246,83,222,210,27,150,50,229,49,63,75,173,67,137,251,190,167,23,199,3,48,164,195,178,139,43,254,233,82,222,177,14,7,67,238,87,94,48,181,94,91,108,185,50,146,88,167,33,181,94,121,245,148,136,83,176,185,221,234,116,59,43,180,75,154,162,6,207,228,77,43,186,21,252,40,41,211,1,38,149,201,139,174,226,198,36,206,27,215,125,207,235,82,31,17,114,52,173,198,37,92,223,53,224,227,89,114,80,156,0,24,23,210,220,19,202,60,176,204,65,81,226,152,236,181,161,136,91,123,40,65,69,223,146,5,9,209,119,98,181,146,108,180,213,233,138,95,241,62,130,101,207,241,6,112,137,130,17,13,220,86,25,209,197,87,224,229,160,150,203,136,158,91,57,24,175,19,159,146,127,107,139,191,239,61,240,77,133,167,151,249,103,157,201,175,175,87,57,236,8,163,134,177,162,108,107,253,144,3,27,244,195,101,210,19,122,250,22,149,112,149,127,25,252,73,120,131,201,14,217,142,32,46,51,219,165,166,218,236,255,124,97,191,149,209,194,149,2,226,183,126,40,217,195,62,0,159,19,102,27,17,21,8,8,14,214,239,45,156,20,206,243,174,125,160,36,221,56,182,95,174,107,239,122,214,151,152,8,178,75,30,1,52,126,180,151,168,169,241,70,73,183,23,57,163,218,195,248,5,66,24,155,249,228,91,169,176,126,195,116,98,159,63,196,149,32,216,179,248,235,29,60,112,59,21,150,112,43,7,15,216,224,132,171,61,174,46,147,46,119,119,205,237,113,145,102,146,50,104,113,20,212,93,203,140,179,52,90,61,208,104,58,85,221,79,73,29,101,82,194,97,153,176,19,89,127,12,217,180,68,230,82,255,228,69,126,89,254,203,10,7,156,124,35,144,227,47,86,205,46,240,134,254,34,241,245,92,193,146,178,122,128,86,86,91,34,99,88,248,3,122,123,191,30,173,110,229,118,104,186,18,231,183,136,203,71,252,41,20,145,238,140,4,169,85,224,137,17,39,231,17,48,8,97,141,168,22,119,142,230,226,56,6,250,111,133,213,3,185,193,142,6,90,79,188,51,86,161,28,197,165,121,130,79,200,168,87,67,104,166,130,118,87,234,248,63,80,23,252,181,125,97,98,92,144,33,119,230,3,119,169,238,128,114,227,130,197,178,224,84,46,202,69,73,98,168,172,154,250,239,111,206,120,209,233,220,93,253,104,169,105,176,156,204,195,243,172,66,206,159,223,234,30,86,111,28,220,55,23,134,238,92,73,207,214,189,30,190,145,245,222,8,190,8,126,188,44,94,200,4,224,135,192,209,112,184,224,226,82,0,154,165,130,120,84,254,31,41,23,58,245,185,81,240,51,180,97,12,8,46,78,120,63,241,197,54,121,200,113,81,10,184,217,129,7,157,19,22,158,115,104,210,125,130,13,118,6,141,89,206,9,201,126,238,24,104,81,1,140,207,141,4,79,1,39,160,201,15,179,139,145,2,101,30,170,9,55,187,189,200,65,93,102,166,108,165,95,165,118,131,76,147,61,50,179,4,124,185,152,75,121,70,65,223,248,18,227,176,186,216,89,202,201,179,119,74,129,111,77,166,183,229,201,20,244,137,23,108,223,10,249,52,211,9,217,105,141,75,246,197,115,220,225,38,132,197,221,88,114,96,200,230,220,41,127,48,4,2,187,51,185,226,72,124,100,74,113,23,165,98,126,130,251,223,229,75,85,246,235,15,149,19,146,55,68,36,106,210,6,29,77,99,86,154,51,22,104,128,6,201,154,182,41,168,191,51,245,173,96,48,56,175,119,7,181,132,81,127,164,235,101,223,84,101,52,136,138,16,97,154,171,178,94,112,149,249,191,104,121,90,253,252,137,178,185,177,230,208,84,178,99,202,217,246,173,242,217,197,112,21,243,101,29,91,197,246,158,58,210,111,194,134,99,105,139,155,207,113,227,85,221,42,179,45,181,23,22,69,26,71,81,67,165,254,224,245,114,16,8,213,94,254,65,59,179,175,165,171,119,144,184,232,179,25,207,102,27,181,25,208,227,235,83,23,12,121,105,221,7,29,132,188,123,118,200,76,179,40,99,8,205,205,200,145,130,173,10,222,247,55,110,46,74,138,232,214,193,89,160,161,216,13,188,130,63,228,104,125,227,71,197,230,222,204,64,130,4,65,151,224,127,144,170,210,16,85,156,119,116,7,154,97,73,221,171,146,65,22,176,57,196,84,184,225,61,211,147,58,127,210,1,14,8,98,126,115,255,177,112,7,52,143,19,50,142,36,203,165,205,108,197,123,54,29,61,70,252,144,174,6,33,221,248,251,0,79,244,14,90,78,149,115,169,45,219,64,57,89,200,196,197,45,159,93,28,192,223,155,100,9,25,225,144,13,99,126,133,174,241,158,114,181,55,211,79,45,255,78,52,114,177,115,31,32,26,129,15,6,179,196,233,134,26,70,169,215,158,254,244,235,31,40,189,84,20,76,227,1,95,190,183,46,245,204,103,75,229,243,56,144,213,156,42,244,190,71,155,22,75,14,106,124,102,74,33,85,12,61,230,164,57,63,229,54,169,131,253,141,35,112,38,201,60,109,46,224,177,91,93,241,100,103,176,95,2,99,2,174,45,143,78,66,68,126,173,104,163,94,147,105,237,123,75,41,164,235,201,100,15,50,58,36,128,135,5,24,108,63,11,121,90,242,190,145,109,54,154,222,86,237,144,250,119,20,151,228,66,115,156,173,46,11,229,228,44,54,131,171,125,111,28,216,186,217,116,250,191,244,182,115,179,128,28,74,3,43,11,225,50,246,96,118,155,145,105,185,21,90,136,14,21,235,108,197,56,213,3,86,7,165,247,209,77,244,242,140,119,228,184,51,134,182,9,115,179,130,212,199,153,48,169,75,4,69,64,102,154,64,111,199,136,79,166,204,139,5,22,233,8,37,187,14,31,206,24,108,160,131,162,62,234,137,140,122,148,180,25,225,26,219,78,243,112,171,57,223,242,43,216,245,151,73,43,62,57,126,30,27,28,94,67,196,223,223,95,10,42,218,209,143,138,72,52,21,97,134,47,160,56,245,117,27,74,215,155,71,50,227,129,207,61,114,132,106,39,44,182,38,238,58,70,57,244,101,191,131,131,227,76,26,123,41,88,36,30,188,85,125,156,183,92,142,192,220,103,48,104,233,168,174,118,3,73,159,151,31,51,164,48,249,196,232,232,141,172,33,0,159,177,131,210,99,197,13,74,36,184,142,232,124,244,3,31,90,134,48,103,36,7,64,213,106,160,102,59,232,231,125,121,197,156,122,201,105,244,33,207,121,192,47,224,245,236,175,31,214,190,210,200,178,235,60,182,120,108,131,102,90,28,176,86,166,190,87,89,165,54,113,9,133,144,108,39,116,12,115,54,243,203,37,184,96,96,32,217,201,97,148,90,163,106,85,182,182,45,131,195,176,107,240,102,11,174,163,141,24,104,87,82,31,117,123,74,173,168,109,123,219,87,160,165,172,97,181,139,162,241,235,172,141,253,3,134,153,27,243,216,221,101,86,34,190,185,3,61,58,179,163,135,23,185,174,118,140,101,91,114,232,19,195,179,33,109,53,105,214,77,56,27,46,83,58,63,220,182,107,221,182,109,189,62,28,54,204,217,62,198,110,30,103,36,50,72,193,30,179,255,89,9,134,101,37,136,56,253,252,4,219,186,237,52,10,198,39,209,81,135,102,59,106,56,115,152,45,226,170,58,139,7,233,37,35,215,214,85,196,170,71,60,239,4,13,144,196,52,181,59,225,26,24,113,132,86,25,29,174,179,240,14,59,88,154,255,85,65,210,33,38,87,102,186,91,175,201,237,5,94,90,205,205,106,217,182,74,29,51,31,207,179,213,164,166,52,167,28,184,173,51,250,101,16,239,214,205,197,151,180,151,225,70,149,61,246,208,20,195,36,144,96,187,225,107,11,166,241,174,95,118,23,96,121,64,72,95,21,70,116,84,66,192,63,59,11,161,67,79,106,136,10,166,161,5,97,160,229,164,147,212,69,13,244,205,249,37,130,234,11,40,12,10,176,72,66,43,14,131,67,81,227,120,235,231,91,221,50,194,110,184,207,123,110,45,173,86,177,232,101,143,9,243,169,232,175,170,161,236,82,25,18,172,160,114,138,189,202,42,169,55,11,238,154,242,225,160,166,237,252,239,253,174,237,147,1,106,120,84,217,156,67,99,28,161,239,90,243,135,53,160,52,37,159,89,41,255,197,192,99,71,3,113,58,14,66,188,172,217,185,224,55,150,167,114,159,27,98,165,15,201,136,89,99,60,108,69,74,254,145,244,110,35,113,248,229,155,94,205,237,195,83,149,38,131,106,38,151,147,135,208,36,0,3,40,247,183,217,174,178,220,193,74,244,141,214,95,108,229,127,107,152,57,187,152,211,56,70,202,87,82,213,37,174,129,35,148,8,7,185,12,176,246,151,7,110,110,77,196,8,8,161,18,130,69,82,218,76,184,13,213,148,82,107,74,1,23,233,91,207,97,189,234,148,151,176,180,253,122,158,78,78,239,184,79,24,147,23,82,39,13,240,51,87,154,190,158,250,123,151,146,238,241,11,105,31,119,232,64,196,235,62,149,201,35,167,19,246,197,166,37,171,156,242,231,160,206,101,205,79,242,249,38,183,114,46,139,67,17,38,239,73,191,134,105,219,236,10,250,132,150,85,235,206,229,222,121,32,125,145,75,221,249,31,28,47,214,197,69,16,36,65,242,61,232,5,64,210,242,5,31,15,170,221,111,77,237,100,122,8,149,125,230,204,52,238,144,34,190,174,103,163,245,90,123,189,238,87,107,89,159,84,194,69,148,239,196,34,212,38,193,34,250,123,95,207,76,0,205,125,240,79,251,151,40,194,93,18,85,175,241,223,45,8,251,90,146,158,32,45,196,206,144,137,88,190,250,137,147,219,23,152,197,151,31,170,33,30,251,112,163,193,125,105,249,116,193,36,142,238,80,65,168,97,161,78,235,120,245,146,51,104,137,25,135,115,155,144,3,89,215,72,49,247,128,188,112,57,236,61,100,129,167,166,165,176,71,55,119,106,92,120,49,104,30,128,111,68,94,135,60,163,136,27,31,85,243,137,48,55,234,222,168,77,126,139,237,241,52,34,228,159,144,63,250,174,3,79,135,124,215,184,24,142,75,226,227,104,204,236,196,72,126,22,135,67,127,145,229,216,44,75,8,157,95,9,205,227,18,68,215,42,76,55,30,4,7,171,68,231,163,100,50,73,71,229,102,216,20,180,1,84,65,97,51,138,5,243,120,31,255,147,215,186,46,54,155,199,207,78,113,167,216,25,151,10,173,139,237,43,67,98,152,200,101,176,88,108,44,126,6,208,161,20,5,163,13,111,169,86,214,37,67,65,87,153,44,125,230,27,134,220,180,15,183,245,101,40,52,74,164,201,37,236,94,52,16,66,92,11,199,67,147,248,226,142,55,214,168,21,10,227,3,210,159,43,65,40,104,224,65,215,72,16,241,248,0,146,0,11,31,37,124,229,98,72,40,52,21,106,115,218,164,240,51,27,5,135,180,139,21,195,34,228,47,41,229,35,237,235,12,217,162,244,8,185,147,244,197,255,204,120,163,193,20,241,50,209,242,237,184,252,150,177,184,112,199,10,125,130,132,217,149,51,189,155,83,177,187,198,80,181,109,236,93,73,6,78,237,102,233,89,125,125,241,39,226,36,131,144,243,58,139,46,9,111,33,72,8,98,6,129,128,83,36,62,22,180,190,251,189,120,41,31,191,163,123,109,176,130,84,218,175,191,46,115,5,102,43,53,179,227,22,54,216,246,10,49,176,52,131,147,141,186,181,76,230,51,161,87,111,190,19,254,174,32,254,177,49,126,124,196,209,50,45,159,134,162,44,222,245,51,204,65,5,152,115,55,104,238,101,81,120,140,80,186,32,176,178,215,37,106,16,125,144,72,139,22,110,155,79,7,58,252,213,68,60,154,66,106,212,91,117,60,168,159,119,249,237,6,191,136,229,79,142,87,29,128,90,61,252,112,202,249,57,77,120,39,49,163,15,129,205,253,68,73,84,103,0,87,85,20,195,64,23,99,0,230,117,254,208,235,225,26,119,92,223,71,98,204,156,234,51,207,212,181,23,167,221,53,175,90,239,76,177,138,116,178,70,112,51,162,219,96,170,117,83,60,89,188,130,223,59,64,103,191,163,170,213,117,107,151,138,57,212,2,42,184,14,153,6,85,77,139,175,130,3,37,80,173,237,245,66,253,242,9,59,13,52,73,172,145,169,65,89,35,47,126,162,252,167,11,141,43,204,187,226,234,72,201,188,150,139,220,75,130,90,79,10,102,27,55,169,93,117,116,20,83,36,201,148,37,156,59,57,193,190,57,139,33,244,16,48,25,154,67,126,135,143,15,162,31,100,225,191,101,112,35,209,7,64,63,192,47,157,27,214,226,238,253,53,236,91,46,141,254,64,247,184,226,209,150,80,140,106,219,228,51,66,146,120,188,246,45,162,142,88,220,168,8,61,206,107,109,129,240,79,223,242,233,21,140,65,99,86,34,194,127,73,211,157,41,16,181,206,163,0,181,29,129,209,205,135,117,70,221,140,17,14,95,62,222,45,94,205,143,46,196,18,120,242,122,214,115,3,47,188,120,73,127,187,79,190,92,73,114,136,168,211,66,103,99,65,190,131,12,206,102,159,244,77,16,178,92,151,137,225,139,214,146,68,87,144,101,216,40,190,229,230,225,141,34,210,101,111,198,117,32,250,48,134,154,40,217,23,96,250,231,249,228,114,185,111,31,22,3,119,59,75,138,26,20,179,174,83,98,53,70,226,144,51,13,190,24,228,38,154,152,171,0,196,103,64,206,84,43,86,3,138,151,44,138,53,253,212,12,161,191,208,226,185,75,242,32,23,21,203,130,233,88,38,235,245,102,177,224,0,105,180,200,191,113,78,142,7,162,187,123,167,11,102,148,170,145,148,189,102,115,11,0,8,221,161,156,24,102,233,62,85,202,248,122,15,21,68,111,226,171,246,83,185,0,249,190,74,239,20,50,40,24,233,192,84,166,221,143,166,18,235,41,4,252,44,49,95,191,77,88,125,4,86,146,141,155,180,66,14,214,222,232,178,93,241,58,73,63,199,63,211,63,90,41,143,57,191,38,59,15,199,2,84,54,4,160,78,194,55,61,139,45,69,65,85,129,125,116,124,243,47,162,75,98,142,238,111,87,95,43,229,237,137,114,236,80,82,101,59,181,165,189,181,11,48,252,162,231,57,78,31,103,56,121,95,12,227,77,158,86,82,13,180,9,126,69,240,65,149,37,250,241,236,216,195,131,200,136,195,127,82,137,177,141,237,24,28,112,233,133,115,96,60,57,113,103,246,72,155,229,210,89,81,107,252,230,22,44,218,63,140,74,165,108,25,224,172,41,119,76,254,199,165,8,179,18,62,71,0,242,219,231,250,110,93,95,29,24,85,156,165,110,55,140,191,31,45,17,65,137,181,152,224,66,129,96,143,200,102,2,126,234,133,21,126,253,224,121,185,80,106,140,68,127,164,235,32,175,153,102,73,214,14,142,43,111,28,82,250,166,214,253,199,243,159,92,223,70,156,230,95,114,129,129,39,74,132,147,144,248,251,158,106,72,151,103,101,204,148,114,243,86,151,174,182,114,85,174,52,220,135,181,78,112,235,175,253,241,59,11,155,173,100,167,238,18,104,31,210,160,154,32,26,215,131,69,159,85,30,231,21,247,36,152,156,154,3,43,146,238,137,111,59,184,215,173,68,175,244,181,9,153,11,185,36,16,96,2,51,197,102,208,43,167,164,50,123,97,47,159,94,189,80,16,162,212,159,225,138,228,27,177,107,48,149,160,58,241,182,33,94,37,219,132,22,248,101,174,96,190,104,212,190,78,177,231,152,234,159,252,108,170,25,220,42,20,253,218,99,216,243,152,129,8,164,97,44,187,233,230,251,228,15,214,201,90,52,125,255,73,141,12,227,190,166,62,117,41,164,207,237,29,226,29,205,132,252,100,232,150,250,60,41,167,12,116,143,12,105,196,212,242,142,79,197,250,54,221,99,159,146,230,33,167,26,99,46,236,108,79,146,56,112,149,125,117,236,154,115,225,242,73,9,233,228,12,244,48,40,22,186,245,4,21,194,164,98,233,99,185,50,90,112,124,92,210,171,219,231,205,192,14,184,100,13,22,150,180,151,24,26,245,62,55,173,120,102,116,249,187,87,172,111,116,123,106,0,29,240,94,35,79,17,109,111,13,126,83,196,208,145,2,15,80,30,155,46,31,87,51,32,240,182,154,21,16,177,5,93,148,219,220,3,124,184,150,89,232,113,60,26,1,106,122,30,234,2,254,124,64,93,253,132,233,231,121,199,204,6,34,109,147,47,5,97,183,52,229,35,245,192,103,245,161,97,225,228,165,232,220,24,223,244,11,160,190,139,190,209,238,189,70,199,161,31,179,143,37,16,183,14,224,186,120,111,78,239,144,7,46,90,141,234,132,39,17,132,239,242,128,13,155,4,188,162,156,202,22,241,98,235,76,47,69,149,140,158,72,108,105,113,179,82,24,227,169,42,108,196,36,219,162,172,247,196,65,255,218,4,101,161,63,80,212,37,234,90,5,39,75,113,227,133,189,224,128,108,140,127,202,101,214,64,158,58,148,64,109,34,214,32,244,117,77,120,59,59,160,114,180,193,3,170,15,140,173,45,46,246,191,135,102,221,182,80,254,19,21,172,157,170,248,124,239,62,153,151,90,123,106,228,251,25,150,2,208,165,79,121,53,248,131,251,152,195,215,143,8,158,200,182,213,91,182,238,231,240,243,13,152,184,255,130,131,250,166,65,157,188,45,216,175,79,187,51,75,64,163,55,40,170,30,158,56,41,109,136,47,70,105,255,204,50,16,7,69,1,7,202,92,38,99,163,23,14,10,185,158,174,43,240,3,232,126,83,24,255,176,191,95,4,183,205,58,169,72,83,249,183,189,19,10,31,241,16,160,38,19,165,212,67,126,194,175,91,217,250,146,112,248,162,179,161,200,92,132,166,8,41,16,148,156,79,152,240,115,113,32,235,113,29,151,100,249,20,90,237,136,230,243,42,192,135,243,75,115,82,246,141,44,232,12,194,67,93,137,171,43,84,229,83,146,105,25,226,140,252,218,22,62,226,31,150,122,90,212,12,66,58,193,213,162,14,220,180,11,206,49,181,203,7,250,105,143,185,76,26,197,94,185,129,207,159,240,226,5,12,137,228,200,112,200,204,97,246,234,156,252,217,131,88,106,237,27,58,131,137,102,197,133,37,145,109,179,4,11,1,40,213,155,10,159,210,56,198,83,118,223,23,161,53,6,120,139,238,162,104,241,184,140,211,109,118,17,67,29,219,28,12,83,108,216,68,140,8,230,244,90,134,243,147,145,244,216,36,92,41,236,181,142,234,128,199,250,79,55,49,195,154,165,73,230,148,8,186,243,252,81,249,20,208,22,65,23,50,223,44,230,28,111,218,168,143,125,27,124,18,217,99,33,206,15,70,218,46,124,224,26,116,17,36,204,54,174,151,76,90,234,166,47,74,182,131,188,190,219,16,179,111,95,118,105,130,238,119,153,151,56,220,239,168,131,83,102,236,66,195,64,228,215,107,120,73,73,247,132,146,38,114,69,66,150,63,106,198,99,112,166,161,186,59,138,47,6,215,72,27,205,244,48,204,36,121,99,165,48,155,160,181,140,53,159,103,16,34,141,26,150,170,139,76,130,7,239,164,245,174,208,97,193,70,82,14,142,89,232,164,88,234,24,76,195,198,237,53,139,127,28,30,112,243,78,188,141,103,180,121,101,173,43,205,149,237,151,19,143,14,83,242,22,197,153,231,183,247,80,39,42,141,211,112,63,87,26,172,233,111,184,194,191,160,75,178,195,23,159,152,255,77,186,155,88,108,86,5,96,99,142,132,72,4,123,184,252,160,186,91,13,13,110,10,34,238,176,143,141,36,171,30,126,32,218,27,17,224,85,11,57,67,65,151,189,138,90,224,71,146,0,192,50,25,104,91,157,75,9,240,68,177,242,77,10,17,21,140,161,104,166,41,158,33,31,10,160,117,97,238,173,245,252,17,139,144,186,25,98,170,243,184,232,196,94,8,91,190,204,161,249,161,11,115,148,192,188,74,207,80,12,43,196,190,149,179,23,119,28,224,188,215,253,189,184,87,205,45,167,133,119,180,75,3,203,199,129,237,102,130,129,68,245,158,237,216,235,240,122,238,215,124,176,204,208,100,113,29,75,114,166,183,17,48,160,177,125,112,7,65,207,38,157,33,194,247,69,188,254,187,25,41,167,128,48,98,34,137,223,194,43,233,0,122,216,215,196,180,89,231,35,253,82,235,219,152,251,208,61,92,170,99,143,193,132,29,13,55,233,62,205,11,100,14,97,36,240,85,217,148,72,138,55,118,186,162,239,113,236,211,52,140,237,30,3,127,101,20,190,1,50,96,27,5,164,178,203,181,8,36,19,199,75,0,206,174,79,208,145,18,92,207,98,133,126,120,153,30,21,204,233,18,23,110,144,78,117,175,28,206,29,118,189,41,92,153,129,207,94,36,181,235,173,145,171,177,239,19,249,182,84,0,13,55,138,25,49,213,176,151,78,32,115,52,68,169,137,64,206,63,74,32,195,46,9,166,251,40,146,252,60,141,25,162,97,23,81,11,140,45,85,51,188,169,9,94,193,113,38,77,165,142,168,242,161,170,245,3,193,86,232,144,234,46,113,124,69,228,179,58,17,193,10,234,66,65,55,106,0,82,216,217,243,89,86,49,213,90,61,168,80,163,89,207,143,255,58,195,145,97,139,112,99,148,233,156,6,214,51,244,108,35,237,59,27,15,210,86,162,178,180,101,70,10,240,79,42,47,119,88,246,52,251,144,203,167,68,146,163,71,226,219,247,254,28,39,173,182,19,78,27,206,115,134,228,6,102,175,38,21,27,119,162,250,146,81,83,168,80,255,126,83,144,174,119,117,137,223,118,99,173,59,240,5,182,195,143,117,38,48,29,236,41,135,136,178,21,114,86,138,11,212,93,56,22,64,202,165,213,93,140,48,220,213,196,172,144,237,211,34,233,99,35,6,105,60,232,60,189,119,3,186,82,110,133,101,37,236,145,91,146,126,178,241,52,169,160,43,76,99,60,32,73,133,86,206,34,199,219,248,100,158,97,212,217,141,211,50,61,236,100,240,194,22,238,176,108,131,204,158,52,171,71,250,57,136,66,245,40,92,191,240,221,24,235,83,195,87,19,185,245,202,250,150,226,29,221,10,242,175,239,95,15,204,55,35,134,54,238,170,40,177,253,22,16,63,60,191,247,36,9,239,7,195,194,133,93,135,15,218,72,63,241,143,112,115,194,40,245,205,7,214,57,96,230,206,37,76,7,65,0,179,199,239,181,17,235,82,75,101,180,60,134,196,225,133,0,155,136,109,119,1,97,69,39,139,170,205,127,201,56,103,195,46,0,14,217,118,157,48,200,42,71,144,96,97,49,236,15,224,13,180,66,3,118,220,178,18,97,127,252,71,13,116,202,234,74,167,125,116,132,28,50,244,53,166,144,27,218,184,17,162,252,71,33,90,207,236,13,37,196,131,45,188,135,225,42,163,187,221,132,231,5,84,87,201,156,62,240,99,33,120,248,114,108,43,203,222,144,236,191,94,69,64,68,99,115,205,213,130,163,218,232,27,42,167,254,200,83,128,68,28,163,71,14,141,71,60,41,145,169,141,183,129,119,237,208,141,240,165,118,56,142,248,45,64,195,208,104,195,139,122,116,183,201,77,245,130,157,48,9,135,102,148,210,242,34,172,6,60,108,171,20,183,172,137,162,68,30,150,148,244,168,67,61,6,167,254,105,8,215,101,166,7,55,40,231,195,245,103,235,8,66,200,125,252,154,72,75,214,113,218,79,182,223,114,130,137,168,142,91,57,79,9,1,105,134,229,56,237,108,192,42,116,86,143,7,66,25,46,119,194,40,19,63,201,12,163,38,27,123,79,149,149,158,32,223,186,231,50,72,137,190,243,49,33,104,198,228,84,134,83,181,173,128,89,162,49,70,255,13,40,44,148,152,34,34,236,97,55,196,155,136,117,74,178,23,254,226,214,90,255,215,82,94,117,150,181,139,241,123,64,35,56,30,30,169,35,109,246,207,87,81,146,96,215,135,143,37,205,169,64,212,56,236,135,119,91,167,86,130,230,9,49,34,156,112,102,29,86,203,118,151,230,111,151,251,28,14,76,8,147,0,123,82,162,235,40,83,80,210,221,44,251,12,19,22,166,117,44,186,18,101,61,9,202,100,213,49,221,62,61,27,251,27,132,116,215,12,43,63,177,49,109,64,25,15,160,10,95,93,118,40,142,16,38,140,181,211,129,28,231,61,225,48,28,100,154,133,155,50,126,33,36,203,132,91,70,182,73,169,143,188,9,70,103,186,110,30,160,110,90,235,231,27,185,85,128,42,117,138,20,132,164,96,123,180,133,7,202,162,184,126,168,154,96,189,199,47,170,141,72,102,123,71,200,245,241,74,112,89,161,255,77,42,62,146,208,186,167,222,56,175,195,179,222,158,82,203,106,70,40,202,197,165,202,12,227,79,94,210,114,239,221,188,202,56,201,204,237,146,142,145,105,188,53,114,21,250,191,102,27,167,0,108,96,85,166,238,17,53,21,83,69,191,248,202,22,69,124,224,230,179,109,97,10,14,55,172,207,55,16,31,163,162,169,223,243,243,106,75,11,80,251,1,159,17,191,198,50,98,215,11,37,173,132,5,101,125,132,254,155,247,233,216,167,221,146,4,49,131,137,219,193,204,92,15,228,46,128,123,150,42,82,81,56,151,48,134,111,26,90,178,236,189,148,233,139,70,143,71,143,231,238,8,181,109,15,182,4,239,153,92,138,91,128,99,30,216,118,162,86,103,209,127,236,12,214,193,1,160,245,223,7,227,147,168,83,84,20,124,71,233,180,204,102,127,10,5,85,23,54,94,135,183,82,189,65,38,85,120,144,192,19,166,75,194,135,66,61,212,250,232,17,151,109,58,155,0,244,136,117,79,4,2,135,24,242,68,190,243,200,90,39,206,174,176,112,198,193,129,187,10,98,196,200,101,237,100,17,21,222,244,230,83,96,222,133,27,171,53,249,76,25,191,61,7,40,212,33,218,156,226,250,235,136,33,52,197,69,93,18,51,37,36,39,248,162,44,84,32,1,30,201,34,44,102,3,62,108,42,97,110,138,44,85,142,107,25,219,121,194,18,225,94,247,250,231,62,59,251,105,109,124,247,84,34,205,32,122,83,201,92,63,86,81,128,154,184,151,182,59,54,110,140,80,209,137,153,95,226,13,200,162,46,75,154,176,125,225,248,137,54,135,236,73,51,57,27,189,173,54,88,228,55,110,127,55,34,82,219,110,60,97,77,1,56,100,204,103,207,80,176,159,204,168,233,160,236,198,212,231,80,183,6,128,118,34,93,134,241,100,98,175,79,108,92,73,72,227,103,47,162,2,80,240,166,179,185,189,105,143,67,213,178,253,22,117,45,189,41,5,26,127,60,224,164,25,186,129,37,248,44,119,175,81,255,1,244,25,191,56,217,40,240,243,143,170,251,220,24,31,83,83,136,64,13,114,87,235,181,40,26,77,218,160,29,78,227,246,27,217,180,207,207,94,136,63,171,60,152,38,251,143,146,76,21,135,28,91,86,63,152,203,233,153,223,127,157,30,79,31,20,81,233,252,14,14,49,25,38,204,186,24,205,114,26,239,70,100,148,99,215,175,64,215,123,142,26,79,237,185,199,147,129,166,36,200,84,237,236,188,114,87,243,214,89,224,25,201,65,209,46,121,44,7,226,209,96,202,241,63,24,202,236,171,75,9,118,55,200,39,253,206,90,124,12,47,32,215,126,42,106,147,247,38,157,82,128,57,193,84,3,171,126,112,81,132,61,115,167,107,74,0,197,4,73,5,92,102,54,173,247,170,146,114,244,19,122,22,114,36,178,4,237,115,97,179,218,129,210,55,202,78,140,167,190,236,100,15,6,133,179,237,177,110,152,4,135,70,77,3,219,5,19,43,44,110,119,241,191,137,84,47,75,10,121,231,209,85,125,216,111,134,118,93,61,181,34,86,250,200,126,228,102,240,110,156,110,152,227,155,22,85,221,48,96,199,6,21,110,152,227,96,96,14,236,158,81,214,63,179,78,107,53,90,201,191,248,187,17,164,27,210,2,184,114,103,110,157,139,140,230,64,177,65,77,173,182,84,74,234,91,186,119,182,96,29,164,198,152,168,231,192,152,193,135,254,22,238,35,1,80,160,200,192,182,239,233,224,91,47,153,235,59,248,180,139,84,213,163,106,59,234,214,86,180,142,84,17,188,255,38,132,157,222,158,19,49,218,82,176,194,178,109,197,138,220,170,65,111,139,135,122,121,201,243,157,15,230,159,83,111,221,215,240,106,8,100,176,104,209,244,145,111,154,29,33,50,167,233,33,188,36,234,203,73,158,194,187,245,159,213,189,5,14,57,119,218,227,219,160,31,91,47,152,255,158,55,226,81,118,177,33,100,171,245,78,22,30,75,216,13,102,19,66,136,140,28,9,66,93,120,177,170,60,112,48,107,219,188,4,6,231,52,12,56,58,65,213,161,46,108,63,165,213,116,113,195,145,57,229,90,243,12,115,19,80,77,232,245,127,39,228,29,79,135,53,214,48,7,90,148,175,8,3,169,96,85,150,33,245,17,252,242,47,61,216,50,128,93,243,205,30,183,27,61,89,192,81,37,136,104,236,142,125,243,238,36,89,211,243,222,232,118,104,163,182,108,152,56,164,76,71,56,115,195,106,226,230,52,237,174,89,39,164,81,245,18,42,53,156,109,76,49,255,55,235,6,14,47,87,8,13,238,125,173,198,122,114,173,242,222,230,178,220,245,113,73,151,124,108,232,152,35,111,112,92,245,161,12,34,109,204,22,11,157,222,144,206,113,7,123,4,180,203,230,142,12,123,243,234,151,106,237,25,53,12,160,67,155,171,29,113,207,210,218,68,10,159,161,161,76,233,110,217,74,27,144,55,86,118,102,233,143,242,21,70,77,184,226,49,8,63,118,180,170,182,201,132,89,211,178,240,19,144,194,97,133,199,132,213,160,252,140,252,8,197,21,152,210,215,189,147,5,57,254,40,70,241,64,24,248,238,244,84,20,30,100,148,38,68,89,107,222,137,104,107,8,47,64,249,147,147,73,249,48,202,21,90,13,243,161,100,213,243,159,70,185,80,176,232,6,121,147,183,112,133,128,184,11,11,224,62,113,68,113,224,164,245,207,231,136,249,16,214,158,122,9,141,228,82,15,71,154,103,34,132,136,137,168,198,64,120,111,194,239,118,158,157,128,33,244,83,70,172,44,152,247,92,231,38,111,163,14,151,44,154,167,125,40,128,248,172,23,122,71,221,128,189,13,192,217,128,211,146,127,54,93,43,232,249,45,253,114,249,127,51,213,134,52,18,191,125,132,37,57,106,241,113,54,253,137,27,68,116,129,19,95,44,112,28,229,72,68,133,94,144,212,183,166,63,65,200,58,253,255,1,168,78,51,44,191,84,113,11,112,128,88,122,93,111,89,252,42,142,177,46,85,164,189,28,29,130,203,60,145,8,207,51,138,142,254,149,214,160,145,155,178,74,32,5,230,36,58,22,96,154,211,86,139,173,134,67,181,135,225,2,114,101,250,22,177,157,159,134,108,146,69,208,34,34,106,102,118,146,194,236,19,238,33,194,125,203,21,230,128,55,150,227,116,8,159,78,133,161,40,56,42,12,73,222,62,160,132,124,49,113,192,131,170,185,252,141,213,193,136,184,15,75,96,78,113,74,10,235,104,113,65,98,191,5,191,132,119,98,123,21,57,174,227,190,208,48,119,251,228,37,74,96,78,9,72,217,173,33,142,163,243,108,65,219,225,23,33,108,197,210,229,13,89,245,219,192,122,57,199,232,154,16,13,175,148,206,95,17,145,147,185,91,173,128,127,138,244,156,17,152,20,96,172,84,110,145,116,230,129,227,252,145,190,242,97,184,57,252,127,75,235,112,208,87,26,19,125,161,16,11,174,209,234,174,23,204,231,240,105,176,141,44,2,10,125,73,42,214,25,231,119,246,212,150,175,220,221,40,50,224,66,247,92,4,37,226,247,193,198,121,215,172,252,242,152,222,245,112,144,5,25,166,149,128,128,152,170,231,173,18,138,22,42,172,179,195,213,104,242,75,193,229,30,151,214,61,178,108,26,145,169,10,13,62,194,41,248,0,157,77,64,23,63,221,158,195,43,2,74,213,25,250,227,143,193,124,215,93,149,41,18,45,199,40,10,104,133,29,75,188,112,4,98,35,68,139,217,170,65,97,145,170,224,218,1,11,242,156,16,174,175,211,113,25,209,236,172,48,245,67,126,5,47,108,169,100,110,60,55,186,131,25,212,4,254,68,194,24,141,65,123,104,230,219,253,216,190,20,37,70,235,240,153,174,166,165,49,6,210,92,118,188,137,121,167,217,251,126,3,32,103,123,84,204,171,27,45,238,182,126,199,25,96,142,138,249,130,197,45,107,146,115,107,239,33,183,59,186,84,35,67,241,6,219,245,61,88,171,249,104,178,219,19,3,216,176,154,196,102,74,9,116,188,180,248,30,81,161,218,236,170,0,31,75,92,247,68,75,172,240,100,70,52,115,77,53,96,85,20,14,32,209,203,44,83,90,101,3,17,235,231,247,26,153,202,60,98,221,186,249,129,120,160,44,207,9,43,77,108,110,6,166,70,11,102,109,223,62,125,178,91,3,188,87,246,9,70,253,7,69,167,26,144,147,60,6,216,29,50,7,233,225,37,66,78,22,127,175,228,39,44,27,248,50,178,58,252,98,226,55,56,42,93,246,46,229,96,75,31,248,18,226,0,233,64,111,46,87,227,128,22,106,31,160,191,212,183,48,159,140,47,69,58,175,162,86,250,252,86,249,43,180,103,71,130,106,30,60,145,138,43,46,150,116,108,239,88,157,16,176,204,0,75,235,126,150,111,74,127,35,37,20,171,248,118,40,145,35,224,181,206,232,46,177,137,208,9,90,48,152,109,115,216,236,100,20,41,168,225,254,136,174,41,185,127,53,252,37,243,1,62,220,233,33,59,237,103,32,230,231,192,127,230,33,41,145,49,122,139,124,90,195,4,240,163,85,139,129,108,1,34,241,5,57,213,180,217,212,27,173,192,59,171,76,236,174,226,113,98,42,239,34,170,29,23,191,109,85,30,173,162,215,168,132,180,139,53,216,13,215,4,231,215,118,1,79,210,63,203,196,216,140,195,222,147,241,185,98,239,248,119,158,237,32,243,30,32,180,107,81,199,142,7,216,203,217,101,255,175,252,186,254,2,160,249,223,51,17,139,42,220,251,6,99,22,44,177,145,74,139,26,239,249,60,190,214,120,125,235,72,14,33,173,27,252,100,244,71,96,2,68,205,146,132,201,105,88,89,65,155,196,136,5,235,224,226,189,110,173,70,162,202,132,34,49,174,43,249,241,165,140,109,150,177,160,225,201,163,108,171,184,177,81,204,106,79,233,142,156,114,64,46,213,255,159,251,37,155,196,103,53,241,196,154,184,187,111,116,34,211,127,180,131,45,227,206,213,112,173,146,93,60,208,49,245,121,85,71,185,65,150,11,86,59,65,171,100,112,2,45,27,85,168,123,135,196,67,91,209,7,82,102,208,248,82,122,44,104,34,199,201,24,120,232,8,221,135,40,46,36,96,56,152,100,210,27,9,125,223,95,155,56,83,64,195,135,242,106,172,52,125,169,199,132,21,255,70,102,251,55,243,213,75,168,72,12,51,99,194,236,94,115,104,190,126,62,58,253,240,68,91,11,230,81,118,63,20,148,226,188,36,60,184,58,108,152,25,220,34,70,149,184,87,210,162,59,94,4,148,205,135,21,140,40,177,128,21,128,188,193,149,10,179,81,169,117,26,226,63,120,161,169,18,10,69,123,131,38,26,214,75,211,218,66,204,15,233,103,19,152,193,20,125,166,160,253,21,155,7,140,237,94,110,187,139,108,105,215,34,118,55,167,161,140,85,156,197,98,72,185,90,46,250,111,238,100,137,127,28,202,21,203,38,196,86,215,148,236,225,37,1,94,41,104,87,211,40,47,66,223,27,56,188,57,175,208,246,172,187,144,82,54,82,216,114,139,69,52,87,241,74,24,80,42,208,101,142,107,5,71,181,71,108,45,203,5,51,25,179,161,100,192,248,181,49,20,236,33,14,116,95,107,100,85,27,96,44,7,197,132,130,116,143,238,162,203,192,111,46,80,90,235,74,149,97,87,136,233,81,154,39,235,54,14,228,35,157,199,142,177,113,17,28,115,131,202,214,216,8,131,220,2,158,229,28,196,63,52,221,52,10,185,220,148,170,232,81,156,11,132,248,89,154,20,81,145,232,115,209,58,66,61,223,112,93,19,240,73,58,24,60,133,148,221,55,12,159,224,232,86,0,246,153,208,245,98,34,237,187,193,176,235,238,180,204,40,173,92,75,38,206,250,45,247,225,27,88,253,146,96,57,249,66,85,16,126,204,191,213,110,194,80,88,122,40,151,131,169,90,122,68,33,46,5,139,204,117,61,66,118,184,254,248,73,12,44,113,59,1,63,52,52,80,19,229,160,73,102,93,63,197,178,191,210,92,219,28,167,59,70,176,153,68,98,58,239,47,89,173,169,215,243,135,180,222,164,128,196,194,117,52,224,211,90,53,90,73,56,234,238,26,121,171,68,124,130,247,139,107,166,120,228,228,112,62,13,116,136,150,81,161,238,9,199,173,132,233,247,205,139,108,229,120,25,0,195,88,130,233,205,62,54,159,168,160,126,128,119,132,42,161,122,237,62,212,126,167,124,30,65,203,117,122,131,240,207,204,187,103,95,13,43,79,224,251,89,90,65,197,26,7,127,171,85,75,214,145,112,30,160,244,132,98,84,229,68,119,84,216,122,92,193,185,91,77,212,132,118,117,183,188,238,39,131,43,198,240,245,232,188,67,126,30,68,228,234,121,164,109,80,220,146,215,126,60,246,9,203,206,107,74,157,150,133,36,140,223,98,206,83,104,235,232,109,132,101,238,192,203,28,56,58,16,218,169,44,14,160,50,53,109,187,243,16,241,93,104,244,228,6,15,241,200,33,192,250,130,172,176,208,134,12,253,144,238,88,233,245,157,99,205,24,224,230,225,250,219,191,234,3,35,233,100,202,73,32,218,140,112,250,44,168,138,37,190,166,90,46,17,167,168,208,228,68,87,0,1,128,210,122,252,149,249,68,148,113,60,249,157,244,1,136,12,161,32,185,107,204,170,144,66,101,218,182,75,102,210,228,161,94,42,203,223,140,44,41,91,16,139,166,118,37,232,131,111,249,87,254,107,21,231,236,200,157,139,41,95,8,182,81,98,214,34,61,125,192,1,1,236,126,149,181,179,154,183,125,58,121,13,51,25,72,221,122,13,10,153,228,145,110,238,216,249,142,29,216,134,100,71,175,114,161,172,52,141,83,207,161,213,130,122,212,124,113,88,119,232,87,154,143,148,164,110,106,169,175,23,153,121,176,86,114,200,168,198,231,95,17,178,37,213,111,111,142,85,121,122,132,122,9,47,221,157,130,204,143,167,34,198,155,119,192,149,217,172,23,61,39,105,19,193,181,182,135,230,79,240,215,69,133,188,183,64,84,210,80,40,236,105,236,48,115,112,234,113,55,157,109,12,61,142,185,17,131,246,172,149,104,152,42,126,31,94,103,28,246,53,211,213,212,3,63,93,155,148,92,224,95,174,26,70,33,22,242,19,39,233,142,75,44,80,227,108,107,250,6,57,211,96,190,163,18,145,124,168,137,0,49,77,194,121,175,171,52,252,9,166,56,71,90,102,15,59,161,121,59,237,199,119,145,151,254,127,89,158,230,121,73,186,46,93,188,79,229,202,238,118,84,72,117,60,40,74,240,24,24,91,182,9,2,237,22,38,139,91,184,220,228,147,223,40,200,95,152,249,65,63,161,34,26,115,250,252,239,166,164,99,82,88,143,226,232,119,187,23,63,30,54,10,204,220,84,46,123,221,80,8,2,195,114,146,202,218,74,228,36,182,122,233,245,21,210,207,57,76,117,163,35,247,29,20,140,13,89,159,64,248,42,86,179,75,217,147,68,19,36,123,117,167,119,206,93,44,100,9,49,234,192,77,91,64,233,59,18,98,17,251,50,163,188,58,71,186,192,9,90,173,223,174,50,250,24,30,15,39,152,61,77,129,130,188,16,221,108,75,47,101,1,193,190,131,191,34,107,90,24,220,2,167,5,253,184,178,87,107,146,190,120,137,242,238,202,98,65,148,149,144,100,132,15,249,50,61,168,183,16,74,58,23,13,138,213,85,114,142,51,32,25,228,210,21,244,144,32,207,83,198,58,63,222,27,80,92,65,252,52,202,135,3,238,229,180,242,117,171,61,114,61,86,187,127,237,250,255,137,80,75,126,114,37,61,207,144,46,25,99,67,255,10,171,65,213,175,198,81,99,230,29,90,174,57,232,88,12,132,35,56,64,7,240,115,16,242,189,107,53,254,40,170,57,121,154,181,164,45,156,185,25,226,130,54,110,253,53,119,54,209,248,28,46,57,202,174,179,215,153,78,36,249,159,116,118,142,119,209,62,212,210,155,10,112,54,181,137,218,77,7,50,99,127,102,66,140,177,66,105,87,251,255,69,88,117,130,119,104,75,244,203,85,129,89,39,101,23,204,41,153,121,52,117,139,215,33,87,207,113,206,241,15,192,161,23,221,167,68,106,182,205,211,8,61,246,51,129,9,203,87,18,39,243,194,31,190,122,251,246,21,187,127,49,129,5,217,62,223,253,5,241,206,14,51,9,76,116,1,59,65,34,253,45,92,37,80,235,42,167,179,177,91,105,9,123,28,242,147,157,50,72,28,159,63,172,251,35,250,211,20,147,254,198,217,43,185,51,200,82,10,162,136,44,15,123,138,162,47,52,57,109,209,46,158,104,6,32,123,57,43,196,221,93,38,147,250,37,24,83,158,98,205,53,75,171,177,2,206,237,115,164,161,29,83,170,135,232,91,132,204,200,106,149,216,249,155,114,117,54,238,13,52,128,60,227,22,99,228,16,217,6,170,151,98,226,183,174,116,96,54,31,181,217,241,126,65,25,235,207,116,157,149,20,20,145,244,216,120,212,9,219,164,125,70,174,8,178,27,249,168,167,116,107,20,129,88,92,41,151,121,149,197,225,145,208,151,120,253,233,203,48,1,215,65,63,120,6,21,217,93,148,64,56,204,49,119,132,10,222,2,27,207,58,109,126,219,72,151,149,153,190,104,174,23,212,139,115,49,89,115,181,3,245,203,125,14,74,130,56,33,210,35,120,186,118,134,205,244,242,25,199,228,22,197,141,225,11,80,149,237,39,88,231,202,238,213,230,177,100,132,59,225,1,2,138,170,0,169,14,219,131,219,52,166,242,2,71,47,197,238,171,137,21,121,221,34,92,230,143,182,58,199,2,127,190,71,4,12,37,180,78,122,82,6,21,52,228,93,161,39,75,102,249,105,146,38,183,218,240,229,229,86,125,21,206,249,156,59,253,150,87,225,133,97,104,227,219,17,73,154,79,232,101,21,48,170,219,33,127,204,121,33,236,97,219,91,244,95,232,218,51,52,124,86,233,112,50,35,80,47,25,160,85,156,251,149,223,214,7,157,113,20,118,64,43,181,67,105,177,114,150,122,147,238,153,227,225,117,180,119,73,46,25,64,238,30,38,250,116,186,108,185,204,173,121,5,189,139,149,203,248,178,18,185,166,185,13,98,146,106,162,240,160,19,16,194,143,22,140,109,190,126,37,132,8,116,200,100,191,95,201,55,131,103,98,102,184,250,202,153,185,241,137,163,4,109,47,60,127,194,62,207,158,109,187,188,57,45,91,51,245,9,135,68,44,1,189,194,224,45,140,22,209,216,38,126,181,134,2,109,52,15,76,105,170,30,93,205,136,208,192,95,216,13,73,77,130,74,114,39,116,50,148,211,111,59,201,233,241,140,84,2,9,223,234,83,111,27,89,86,120,205,86,11,111,181,11,136,151,27,62,84,155,42,148,131,249,160,65,13,49,44,213,175,159,52,14,234,254,118,21,78,123,12,3,113,185,140,59,164,166,39,23,199,209,86,250,14,68,85,51,20,61,131,1,186,242,82,26,121,86,134,62,244,231,71,0,77,143,121,15,69,34,42,127,18,106,83,234,152,225,3,158,145,103,6,55,100,7,207,92,85,129,227,42,25,212,88,84,21,230,30,149,172,20,106,225,76,241,7,104,34,70,173,17,177,142,81,105,123,32,179,175,240,142,177,220,58,137,160,220,159,134,121,246,239,88,172,227,55,78,34,146,129,125,112,245,210,32,239,38,51,129,205,72,86,25,200,169,142,247,213,58,172,37,248,33,226,3,185,95,106,229,132,44,130,119,19,70,91,108,63,141,255,118,71,190,119,65,55,148,92,218,25,179,175,190,188,75,237,112,10,95,245,87,255,206,230,227,17,40,232,32,70,193,245,234,34,26,254,112,174,20,222,179,206,205,222,249,153,77,25,59,77,35,250,246,220,93,220,91,196,73,51,151,31,62,38,47,99,199,60,12,242,171,56,141,150,75,39,249,121,50,64,211,73,109,45,182,138,221,126,105,86,183,23,80,16,74,47,52,225,91,158,123,151,165,84,87,229,174,163,114,204,162,215,126,63,195,43,204,23,46,129,177,110,114,207,231,2,155,223,116,87,95,218,61,34,43,77,213,90,90,86,176,62,191,211,107,174,218,110,42,73,17,201,105,79,139,208,42,245,53,13,160,115,201,220,34,211,59,144,95,64,185,217,185,114,29,226,119,6,158,245,0,194,20,46,210,118,130,192,144,68,58,173,47,65,130,152,191,227,29,212,196,107,42,213,121,211,25,7,240,72,28,194,40,65,176,74,30,71,99,157,190,101,67,95,186,92,3,151,83,105,151,170,93,182,138,126,250,213,171,237,154,146,64,225,168,55,38,53,178,33,240,203,237,61,29,229,240,168,43,44,4,41,175,250,172,55,24,77,136,42,124,89,48,138,169,195,97,150,97,110,140,138,255,209,71,42,109,160,83,74,67,162,153,220,241,237,34,234,210,197,54,42,57,199,79,88,9,251,82,56,101,225,30,78,10,22,152,131,9,157,122,58,119,218,165,58,232,242,41,125,17,193,254,240,189,148,45,50,255,178,220,32,188,246,142,7,93,35,255,188,165,249,18,134,152,23,249,233,120,124,48,123,59,243,186,244,67,113,9,216,87,210,238,224,116,138,30,224,187,168,231,32,58,141,176,150,205,67,37,35,189,50,143,246,62,148,48,24,118,24,136,213,164,198,226,171,35,88,64,203,189,59,94,7,226,181,114,177,183,223,14,47,253,139,125,252,176,181,162,226,171,151,155,48,244,123,188,215,91,123,148,6,163,199,96,5,209,35,158,81,253,146,109,167,233,195,71,213,83,64,41,168,231,220,1,166,222,56,190,39,153,10,150,29,212,113,41,3,255,2,1,1,189,129,115,96,66,64,9,172,187,29,78,211,58,167,81,29,249,20,83,199,175,9,217,8,158,27,73,107,206,21,8,5,133,42,41,118,87,135,226,6,245,148,242,49,244,142,73,123,135,210,211,220,35,173,193,29,28,101,45,132,47,149,23,255,35,74,14,31,62,106,208,30,16,123,121,124,150,48,6,25,185,196,133,12,104,15,80,14,94,154,18,50,148,227,16,239,237,240,137,46,46,64,99,37,104,250,125,132,211,185,142,119,97,236,183,7,218,194,159,182,242,91,252,129,201,35,9,46,192,112,57,2,60,238,86,149,89,62,4,40,156,112,69,226,246,55,154,97,193,139,114,77,14,59,247,113,244,100,74,73,177,52,250,153,3,203,227,29,234,50,208,90,49,134,225,147,173,47,41,231,36,243,137,74,176,158,64,82,168,147,68,133,21,7,56,243,122,162,172,174,142,128,63,129,180,7,149,169,31,125,251,93,6,119,17,165,1,18,81,19,237,136,254,33,196,167,133,158,190,112,239,113,45,13,187,233,75,10,86,167,245,54,1,123,72,164,108,34,6,225,168,147,226,175,62,111,131,235,106,33,138,238,209,99,31,31,67,181,45,169,67,150,216,45,244,249,199,225,168,199,22,112,124,244,136,84,222,255,68,218,34,124,0,79,124,153,36,197,23,245,46,227,159,108,87,137,92,195,48,177,163,227,179,96,168,170,84,67,6,249,201,116,135,150,247,232,133,125,241,241,13,44,136,211,205,48,115,226,204,250,10,6,134,16,25,91,123,134,201,139,255,134,252,115,181,9,197,44,2,133,160,208,59,189,102,130,53,195,61,0,80,152,62,154,116,198,236,223,13,169,80,117,159,151,226,12,19,134,254,34,77,173,207,63,204,99,113,137,67,32,4,188,82,40,59,230,247,58,166,207,252,199,129,21,10,170,50,218,19,156,137,193,75,37,74,163,179,87,189,106,178,8,173,52,38,140,39,49,65,127,208,120,108,37,144,120,75,212,20,140,78,158,102,22,80,183,79,53,138,245,101,178,91,244,134,82,229,39,82,69,73,97,65,124,35,32,220,103,6,149,183,166,135,209,95,195,46,117,176,135,94,241,167,242,78,144,158,154,223,243,103,95,95,73,246,252,117,228,167,26,2,96,94,60,221,226,189,65,87,164,95,186,231,187,149,132,74,98,159,71,28,188,44,127,31,116,147,195,196,108,16,233,49,105,187,246,162,11,37,1,46,70,48,120,44,25,62,112,69,23,160,214,151,140,223,133,141,52,231,204,7,108,232,90,104,7,111,172,255,46,250,47,230,187,2,234,102,130,217,102,123,212,212,202,151,56,89,103,94,81,222,0,0,168,235,100,82,44,83,87,155,110,213,192,204,219,192,90,136,187,69,13,215,236,143,176,64,183,120,81,40,47,226,74,167,186,191,133,231,83,235,187,108,186,250,133,211,110,170,80,206,215,231,105,34,78,81,113,184,8,177,34,123,19,152,95,52,5,137,76,109,68,128,158,117,10,76,230,52,60,119,80,184,203,150,18,139,157,230,79,153,22,163,81,78,126,218,192,192,83,20,118,4,141,111,177,127,233,100,86,184,3,204,177,35,83,2,127,66,111,93,37,215,139,105,153,20,92,225,49,45,230,83,217,78,200,83,166,4,105,126,85,217,122,28,4,19,37,191,148,87,73,116,160,99,222,197,74,220,205,127,194,43,209,34,212,214,83,182,249,95,219,144,224,43,125,203,220,7,116,139,126,189,255,41,151,187,196,24,196,135,190,78,211,27,50,57,110,248,54,181,68,92,37,121,173,190,41,46,205,145,32,190,188,164,25,181,43,121,7,61,174,242,220,142,205,112,167,141,164,22,159,33,52,9,83,41,75,174,127,46,240,158,92,93,115,44,249,213,6,100,183,220,24,142,252,147,248,65,192,35,52,109,0,149,191,198,216,254,128,85,44,235,58,12,76,104,78,93,14,70,212,210,142,253,205,242,88,66,51,41,147,180,177,89,94,34,221,34,24,80,127,60,80,56,183,34,221,182,83,117,200,122,203,118,242,246,61,212,186,211,21,19,167,79,177,120,173,92,91,93,52,75,85,71,225,101,23,57,119,10,23,85,244,158,39,68,229,91,5,192,187,249,39,95,194,132,217,200,17,195,177,73,88,251,78,118,12,207,76,67,43,123,21,223,251,30,179,113,20,79,255,174,27,255,67,177,59,41,241,208,83,64,31,155,26,96,159,168,252,203,87,131,16,65,154,164,104,47,243,108,31,177,188,3,116,171,101,84,219,198,76,179,110,228,222,74,25,37,155,253,125,175,210,231,195,68,97,111,149,154,176,8,199,128,252,241,204,153,199,109,223,146,102,103,23,146,236,46,182,249,152,74,85,160,98,33,20,90,209,221,81,218,171,107,128,89,188,236,204,33,199,113,154,58,225,104,233,216,56,113,20,65,136,149,223,148,101,32,231,74,160,126,11,14,134,43,111,248,176,60,120,68,238,98,60,90,163,184,231,67,241,218,139,98,49,57,243,46,144,225,63,123,166,213,203,32,226,33,176,253,169,211,114,68,205,148,240,253,108,191,70,221,218,88,97,178,200,179,193,221,55,101,95,34,111,20,255,253,155,129,131,145,244,153,126,111,151,144,180,96,26,94,115,83,28,173,1,133,158,55,168,146,45,84,51,174,195,117,135,136,25,254,208,44,13,30,34,71,173,16,210,99,88,78,203,16,202,232,128,149,119,236,209,89,214,132,255,190,22,238,165,129,109,120,42,195,89,62,23,198,68,199,161,80,104,229,74,148,93,255,100,46,165,227,196,20,53,14,224,142,178,82,9,50,83,164,6,251,163,194,2,42,104,248,12,188,249,48,85,60,4,54,39,181,138,73,212,168,96,201,185,182,16,92,194,78,195,31,249,215,187,146,75,237,191,230,252,165,253,190,230,133,113,233,172,172,217,29,16,124,59,157,244,140,92,128,162,142,210,52,210,154,229,98,214,228,199,76,159,59,26,127,227,63,137,231,143,61,205,141,80,183,1,207,106,118,220,57,160,200,68,67,245,226,215,83,142,117,163,55,12,165,18,193,143,240,133,177,237,47,198,67,157,252,216,108,56,105,174,70,217,113,13,193,140,176,195,29,222,183,135,24,167,200,172,78,48,187,73,241,156,214,214,190,107,164,123,133,100,205,218,232,38,98,123,211,165,207,61,155,181,175,178,219,46,132,237,2,8,76,24,234,237,162,172,137,76,177,18,100,129,141,111,44,168,147,135,9,68,82,243,198,21,222,91,106,182,12,231,14,11,4,90,83,206,3,56,227,34,0,119,184,203,153,153,71,143,79,213,62,92,225,186,164,132,134,185,233,124,103,57,177,82,103,236,156,136,152,39,86,99,96,170,6,184,16,136,187,98,195,111,208,142,173,99,91,132,83,115,172,133,86,214,162,110,150,224,149,27,107,140,123,237,106,182,1,133,80,42,110,197,146,128,164,243,204,70,232,206,181,108,32,65,122,220,33,88,148,105,44,134,115,49,99,47,233,114,174,146,248,139,52,46,42,188,91,186,215,59,202,75,104,111,27,78,164,112,128,161,99,234,236,109,230,124,159,95,111,63,235,246,81,74,159,226,149,3,135,29,204,206,229,32,184,23,100,60,43,244,186,127,198,237,172,175,179,184,78,239,2,175,242,183,237,68,82,126,145,252,14,176,166,139,38,13,52,26,147,152,0,178,218,200,233,20,220,252,75,244,47,251,41,227,3,163,20,128,230,209,248,200,230,144,177,138,153,238,119,100,215,202,191,28,196,155,121,166,184,144,167,226,204,27,158,133,192,214,12,170,116,104,33,194,80,84,101,189,7,7,96,251,247,98,89,218,55,20,255,23,171,92,86,73,188,132,157,213,138,208,109,180,123,231,22,59,243,179,142,84,8,122,155,126,191,131,88,241,85,9,47,31,7,78,250,137,182,247,55,57,183,45,111,27,153,210,251,173,181,187,114,217,150,23,61,214,190,83,233,243,126,55,250,255,17,71,51,222,11,251,68,15,3,81,72,11,177,165,61,120,172,90,243,35,150,133,104,111,67,123,159,73,129,154,4,170,253,111,251,131,157,93,40,134,253,59,15,78,173,123,31,184,14,188,221,86,184,201,49,83,134,142,112,22,95,8,156,56,105,55,18,159,179,112,245,193,8,208,233,127,90,25,229,9,77,125,6,160,231,101,159,112,53,4,25,146,242,59,170,226,207,79,243,7,186,233,174,44,1,179,14,9,65,48,252,116,106,82,172,190,124,72,68,97,216,10,93,44,5,56,48,58,183,23,190,197,185,221,223,207,15,232,28,68,112,238,246,219,11,13,138,90,152,46,42,41,251,43,24,88,125,109,226,0,4,147,157,30,209,102,86,153,128,204,126,247,110,211,236,208,62,161,172,89,35,221,230,19,134,117,235,138,63,206,234,51,103,229,152,160,167,137,134,81,249,36,31,144,161,90,5,194,189,129,186,201,211,214,194,110,159,43,177,61,11,236,248,199,80,32,246,32,87,16,198,9,232,231,252,9,173,42,55,179,7,123,141,80,185,10,87,180,38,100,135,201,189,187,200,219,218,187,224,36,231,158,191,185,185,207,239,9,135,168,15,182,6,118,22,160,170,10,138,216,52,252,35,11,8,17,52,51,249,118,158,112,182,20,61,242,182,107,151,252,93,103,190,95,119,174,129,28,208,254,229,150,169,73,154,164,121,243,98,158,125,178,160,63,194,4,77,137,133,150,136,136,252,92,9,103,136,130,157,153,17,129,226,5,13,39,124,1,209,177,167,39,127,96,32,255,50,61,114,197,118,70,220,36,82,221,223,72,95,196,131,57,22,204,231,202,152,49,39,72,17,25,38,1,226,62,40,146,161,6,33,77,108,34,20,215,85,254,94,131,37,109,45,171,174,35,192,24,152,18,198,153,24,58,202,139,37,167,31,64,156,81,158,149,71,211,161,41,190,245,227,242,25,19,133,137,39,73,50,197,157,128,139,232,91,213,195,146,71,136,116,247,218,225,51,96,230,248,186,124,207,220,69,24,55,46,45,58,11,130,27,233,227,149,190,185,167,215,132,186,96,172,72,145,30,26,48,8,221,161,14,170,74,216,98,255,30,137,209,180,98,24,35,76,32,56,42,95,127,12,210,64,110,182,163,113,12,136,228,119,75,139,96,165,253,221,128,64,130,225,184,158,212,74,13,86,198,175,219,23,87,116,123,255,132,162,125,88,154,65,196,124,32,129,138,210,28,81,245,207,54,242,130,184,161,75,181,205,169,109,184,162,172,199,5,160,63,224,234,225,140,223,26,99,51,99,144,238,40,133,213,17,88,149,124,205,242,39,166,57,245,247,233,219,135,146,83,49,108,161,78,197,131,49,133,141,24,249,122,39,155,75,43,86,181,21,217,165,133,91,191,14,127,233,180,82,61,36,127,168,129,155,49,2,16,226,33,167,104,185,97,197,180,255,229,118,91,163,97,36,135,145,200,117,134,152,53,244,248,94,225,6,24,83,9,53,254,152,137,167,160,92,0,237,41,32,149,110,232,180,108,234,210,137,136,85,251,209,175,69,212,212,166,102,7,126,12,43,47,32,97,152,69,170,176,125,188,221,129,120,2,199,214,112,236,198,144,158,20,136,227,7,106,95,97,99,236,88,110,8,206,236,93,124,33,155,16,115,29,97,16,99,148,10,243,116,250,154,25,206,172,50,205,29,21,232,16,9,231,120,187,34,191,129,21,173,62,176,77,153,219,190,200,244,239,141,251,162,135,205,187,163,65,8,180,27,33,205,211,111,155,198,37,129,40,49,227,50,192,82,55,55,202,104,6,60,50,202,211,225,77,218,107,42,84,216,90,86,195,183,151,93,44,221,44,215,11,205,146,198,69,132,89,240,255,248,155,49,223,216,223,40,129,63,162,57,47,146,11,59,219,61,228,247,19,42,136,26,71,57,244,46,233,170,191,233,96,90,142,170,134,166,132,51,146,215,204,87,158,237,170,236,154,167,240,195,127,178,222,188,19,224,83,198,21,185,145,233,198,196,94,128,226,56,47,199,140,203,209,192,174,211,211,101,146,221,33,48,194,52,127,45,57,162,52,105,218,8,48,119,153,179,139,198,190,76,72,77,112,240,182,208,75,101,0,45,47,55,135,182,122,21,75,147,188,49,48,181,19,74,107,45,58,141,83,235,217,198,180,248,52,66,202,184,191,223,128,88,108,53,113,241,60,220,185,215,113,17,49,224,159,167,180,86,34,84,245,50,252,167,176,198,182,10,8,26,87,79,15,115,57,96,238,225,72,231,158,165,106,26,184,111,169,168,22,21,230,175,145,76,22,171,249,45,157,185,106,191,247,193,230,209,103,179,73,9,178,43,50,134,67,207,34,164,113,234,236,160,136,99,24,156,197,156,229,58,87,230,74,235,16,235,93,119,240,26,37,119,163,137,223,120,71,69,212,68,27,99,201,94,24,27,245,42,97,198,120,110,93,200,36,223,82,253,171,162,76,185,56,152,105,67,57,159,252,126,29,168,91,14,144,210,164,155,227,46,103,5,185,0,23,86,96,202,102,230,113,248,222,22,20,36,75,207,73,33,171,239,75,73,54,42,104,118,158,181,138,103,9,104,110,59,65,159,200,91,82,251,183,196,7,152,104,81,45,182,154,81,167,199,146,116,236,141,137,35,134,50,57,102,36,56,39,52,219,42,248,243,58,193,231,56,91,190,218,142,185,218,77,173,44,238,73,194,97,190,149,31,173,126,255,26,111,107,21,129,66,90,255,138,143,194,198,182,194,14,97,112,145,240,65,217,177,28,176,69,45,149,180,99,191,215,88,154,247,41,234,167,182,253,91,214,25,24,29,215,0,176,203,56,65,45,33,183,30,171,102,203,90,48,220,126,17,82,17,213,5,157,34,201,163,45,159,252,193,206,248,53,158,103,175,228,242,211,78,76,221,31,202,11,232,41,124,217,201,58,58,234,114,51,41,191,84,18,243,76,37,163,12,23,66,73,99,68,52,149,39,133,148,66,65,226,155,156,69,28,98,218,167,119,151,177,200,90,129,101,236,238,96,44,139,52,143,171,96,232,165,76,25,12,200,247,170,17,107,164,92,23,120,82,180,88,19,60,226,250,55,76,87,244,253,45,26,82,30,245,154,102,167,143,218,253,6,38,187,211,41,157,51,53,13,56,135,222,71,73,65,244,108,155,221,192,227,87,98,158,11,43,232,130,252,97,46,182,29,235,118,26,126,235,53,145,162,54,232,175,149,17,53,241,205,104,7,175,251,224,29,140,14,210,249,48,177,48,166,240,102,93,140,135,104,240,196,156,159,39,105,40,154,45,217,92,65,71,13,143,165,165,83,252,0,204,155,132,232,171,222,174,118,101,58,118,242,142,175,154,104,127,54,153,160,128,66,185,100,185,248,99,90,138,228,86,184,142,138,219,34,236,154,110,57,244,183,238,208,219,213,148,232,120,19,72,175,66,51,25,146,213,17,14,188,109,51,142,177,89,11,127,171,89,220,5,253,244,90,199,20,28,179,77,48,201,198,216,42,192,113,101,30,193,13,87,176,94,143,25,121,107,122,255,233,210,202,221,59,121,210,244,116,98,159,208,160,252,158,3,93,24,102,251,227,59,180,23,207,56,24,195,253,30,12,83,98,108,65,42,249,158,88,89,201,67,103,146,195,187,34,21,127,63,195,153,105,106,165,89,209,98,6,94,179,137,177,37,229,233,195,25,251,139,233,42,139,5,212,104,244,126,73,109,85,48,142,8,148,225,224,206,78,68,176,114,111,81,224,64,178,97,26,58,205,21,253,31,220,5,18,103,75,150,38,104,99,111,228,224,197,165,172,70,199,144,52,100,93,186,45,153,218,172,187,28,29,101,153,79,195,50,67,253,160,22,148,96,14,167,45,10,74,223,160,87,77,189,161,30,115,119,181,89,32,7,101,220,105,170,133,65,238,224,216,123,205,72,29,240,159,252,171,13,126,86,6,238,164,119,246,224,27,86,228,152,193,57,174,76,138,166,173,189,220,17,209,45,183,161,205,51,30,169,58,68,189,98,156,146,22,7,169,230,228,119,123,152,183,198,213,55,199,92,56,150,191,66,130,31,79,10,36,84,61,117,160,163,249,23,144,4,0,101,235,92,60,148,253,50,75,193,205,237,103,232,139,20,197,231,41,23,110,111,201,91,210,151,39,151,244,182,194,172,174,116,57,53,40,31,198,192,111,159,246,42,210,87,89,84,96,55,35,186,105,58,31,168,153,182,220,2,140,231,202,139,49,243,3,253,11,193,212,164,223,208,55,34,104,3,88,42,207,241,178,74,4,164,110,170,24,16,169,248,206,2,97,68,3,12,173,20,113,246,131,180,100,14,182,192,156,45,135,208,119,123,65,112,220,121,182,104,51,123,27,160,142,216,158,248,59,185,62,86,125,56,73,44,199,20,28,174,193,62,31,189,220,127,15,253,247,169,209,229,206,153,61,247,215,246,143,179,132,99,140,185,214,105,116,8,53,110,54,250,81,201,98,40,49,46,44,211,28,28,236,199,47,82,160,90,170,110,174,186,32,146,153,201,207,175,166,81,159,155,226,175,250,191,90,99,159,208,31,223,78,180,89,62,158,20,211,75,198,96,86,226,69,175,112,184,82,219,109,242,45,59,236,100,236,218,233,18,186,215,148,136,34,236,74,56,230,87,2,145,68,248,14,254,106,78,158,75,111,245,42,50,179,237,129,187,41,232,58,24,109,26,35,90,57,53,192,39,223,168,103,69,149,116,43,236,6,77,230,79,239,66,48,15,111,190,55,197,253,90,70,97,30,166,183,57,168,186,65,174,254,8,23,7,186,133,237,216,119,53,245,222,185,74,4,2,234,206,232,24,124,250,227,18,44,18,156,213,147,31,127,198,130,194,102,100,4,225,117,181,8,176,145,207,18,209,195,1,230,10,241,105,86,145,221,75,6,21,15,125,37,88,238,105,53,54,181,49,125,77,203,216,203,27,169,79,186,227,42,85,84,45,128,34,77,95,28,213,3,112,218,55,80,123,76,107,174,5,183,222,173,145,103,68,33,41,203,75,81,145,207,171,165,147,73,23,193,172,180,178,191,129,216,102,64,172,81,114,247,194,74,108,70,39,223,208,222,82,171,157,185,125,151,44,80,11,134,75,246,99,132,62,13,55,188,173,170,164,213,243,201,69,105,157,171,69,219,143,190,157,203,123,187,2,253,27,145,194,94,48,54,60,247,147,46,144,145,176,25,9,157,245,141,244,118,60,206,227,237,56,45,28,17,117,136,15,9,27,27,41,239,132,63,15,26,38,219,167,104,191,127,146,160,198,146,100,120,226,232,127,202,111,134,126,84,104,144,189,118,50,41,56,156,136,196,214,26,166,186,47,195,103,141,136,150,167,149,60,55,198,24,142,24,129,24,165,22,50,169,144,124,85,97,5,31,202,2,239,170,128,67,143,173,38,233,101,251,143,104,187,217,207,81,32,210,33,206,254,216,107,151,60,252,79,47,59,194,181,134,41,191,58,243,1,210,39,124,16,244,199,36,109,169,224,98,7,229,36,217,35,197,208,108,39,54,28,62,74,102,213,239,169,80,59,17,237,86,55,127,25,46,133,155,241,91,197,103,11,58,162,200,179,86,17,70,36,185,148,55,166,59,192,159,73,56,87,140,211,200,19,192,11,134,10,163,50,163,77,71,66,74,132,89,51,13,251,227,173,247,47,249,110,60,94,158,47,68,71,111,114,103,6,151,246,131,235,246,81,90,74,176,216,53,238,74,212,2,28,214,205,178,117,75,252,246,128,239,225,175,68,162,221,203,139,219,240,181,137,202,203,78,148,156,137,0,151,244,246,244,213,127,241,233,205,200,52,95,194,100,55,218,173,240,26,184,19,64,195,20,3,209,11,140,126,15,201,28,49,255,131,187,209,98,118,234,235,242,106,181,36,174,88,42,229,120,150,28,126,247,36,169,243,19,100,87,152,136,172,225,233,197,84,236,192,10,203,226,172,239,209,107,5,241,229,69,39,166,148,134,2,239,148,50,219,147,229,171,225,23,167,33,245,65,216,109,55,233,109,25,227,184,64,31,223,152,113,20,195,16,99,57,49,209,38,79,145,99,152,212,243,139,95,158,208,58,33,246,64,5,121,182,106,95,179,145,9,13,14,169,170,240,164,72,208,180,110,60,171,99,198,69,96,31,194,101,39,23,98,228,83,118,224,178,9,169,98,92,108,148,86,245,205,97,255,191,232,14,223,48,69,132,226,7,142,157,110,176,242,10,231,132,167,254,99,125,148,86,62,20,6,60,207,158,61,15,89,206,168,197,45,61,53,183,92,166,66,61,114,180,38,77,244,104,0,102,60,114,217,213,200,221,161,51,38,196,61,41,210,117,34,123,37,127,93,226,191,169,189,194,64,47,8,187,14,168,103,130,213,15,23,15,220,146,242,66,105,121,238,82,249,172,24,211,104,98,199,183,102,91,10,27,202,104,176,250,108,165,51,177,167,39,204,188,71,13,178,207,42,108,197,117,160,3,32,163,220,61,177,51,185,29,66,177,205,252,148,68,218,252,235,145,200,192,118,231,205,120,228,76,2,121,99,82,55,186,168,81,113,196,136,26,157,250,230,191,207,112,130,154,146,212,23,91,3,236,29,225,130,160,64,223,96,248,207,109,138,94,231,159,9,65,150,232,151,80,125,202,67,64,242,190,178,44,20,121,79,168,180,192,91,218,40,255,81,95,178,2,90,210,5,51,57,71,239,5,173,90,157,145,58,104,199,46,30,67,175,13,194,95,144,162,169,172,180,196,126,225,64,59,160,168,156,250,96,154,182,58,72,172,5,150,120,253,164,55,128,166,197,235,107,142,198,52,90,123,31,251,89,122,245,18,193,35,163,136,150,24,90,19,105,52,124,146,115,70,202,107,4,250,167,158,247,16,225,144,196,104,159,219,123,29,38,68,234,61,215,4,17,12,103,172,142,10,19,202,148,42,162,89,198,86,81,185,109,17,136,189,118,40,68,42,189,151,128,31,155,156,82,46,122,13,248,55,121,99,146,235,213,222,49,36,85,201,216,86,46,33,103,30,113,251,127,187,73,248,61,177,179,160,135,249,213,196,174,175,219,213,248,179,49,23,238,158,27,142,50,93,11,97,245,208,83,93,151,175,5,227,126,52,116,29,234,195,226,148,134,36,73,109,18,28,92,76,27,45,128,98,245,56,233,230,189,41,57,234,183,36,195,249,193,13,55,249,251,154,17,232,243,65,84,47,114,88,116,197,97,12,72,141,242,81,219,160,228,187,3,239,249,159,221,72,151,163,48,44,76,100,230,35,41,66,50,12,254,94,167,4,133,188,92,244,240,37,155,108,136,197,141,86,238,23,30,135,161,165,204,94,31,65,13,217,101,218,254,209,124,200,191,166,128,50,249,97,153,157,75,8,142,124,40,217,165,90,61,121,3,32,224,229,22,63,16,166,152,160,95,132,106,168,194,221,19,127,197,92,105,212,247,30,170,100,248,230,151,210,0,32,175,69,0,155,161,158,233,23,225,133,98,69,190,189,75,143,3,122,187,61,143,73,98,13,219,198,224,178,55,103,231,65,46,45,132,228,119,198,234,188,19,95,94,209,187,59,221,39,112,188,101,141,235,81,26,172,112,228,175,185,104,2,171,253,230,96,68,76,189,33,147,242,172,66,29,243,243,11,99,155,106,99,168,9,252,186,225,184,243,91,40,162,167,162,41,3,1,111,36,95,214,61,128,180,121,114,112,47,220,142,21,143,68,109,48,183,173,108,226,175,90,202,54,83,200,165,177,64,130,125,117,117,27,98,101,159,163,19,10,38,195,159,252,175,190,215,110,15,11,128,220,151,59,20,82,141,11,240,133,154,215,36,106,107,198,43,29,59,196,211,88,209,176,206,67,112,187,172,70,211,201,217,159,161,189,38,51,198,122,249,183,144,32,42,223,49,130,163,118,157,193,51,56,193,103,201,153,164,238,68,4,3,40,130,224,177,61,137,248,29,74,237,77,85,157,103,212,235,38,40,57,203,36,134,79,79,163,128,192,255,159,176,249,5,134,169,153,154,229,213,36,243,13,42,144,115,216,208,174,223,68,71,22,216,4,250,103,32,77,18,20,226,145,177,125,173,121,148,161,246,185,57,25,50,39,155,30,198,136,206,19,192,29,151,205,21,120,38,222,230,173,208,0,219,92,200,251,151,178,145,91,101,250,134,153,36,233,234,72,120,233,142,245,121,166,81,87,77,110,40,233,129,95,39,62,54,46,217,77,228,12,143,112,104,214,223,255,186,19,1,229,151,177,232,81,222,29,13,51,238,2,173,81,44,154,85,119,5,200,203,80,40,120,90,231,7,144,107,184,51,69,22,17,172,149,94,234,70,126,186,106,190,220,210,250,57,169,132,63,64,234,175,1,235,28,244,35,110,101,12,21,78,175,183,239,126,74,231,189,53,182,8,185,159,2,200,152,96,19,125,193,171,127,174,153,177,85,7,242,8,225,116,153,94,195,31,211,222,198,96,184,84,43,253,69,113,193,207,123,23,33,182,91,143,105,41,45,179,38,213,245,122,70,58,199,201,233,70,139,48,163,83,232,190,196,34,174,179,120,110,16,255,59,41,67,100,234,189,217,28,234,244,146,207,152,235,250,77,144,97,83,50,234,33,76,99,233,141,38,104,19,48,149,100,136,192,212,114,57,203,145,72,109,196,39,223,162,52,22,226,142,131,55,6,136,138,197,196,36,66,190,196,187,89,232,80,236,78,213,149,74,38,8,254,8,163,145,215,151,196,41,70,89,199,104,31,193,28,118,9,25,172,230,219,26,75,230,104,124,108,231,40,254,92,250,49,189,52,94,145,132,136,38,254,130,178,89,165,158,242,52,191,241,183,62,172,127,14,171,27,248,87,250,202,32,242,177,75,123,88,227,24,29,174,191,223,47,120,111,237,150,240,220,134,222,101,47,219,45,145,208,199,250,237,119,87,197,77,11,241,150,105,111,129,202,75,250,231,76,30,190,147,149,210,109,93,51,176,190,135,91,169,183,117,108,140,110,80,207,57,59,80,107,154,71,63,86,144,33,56,142,224,193,244,124,98,30,229,103,18,89,249,44,174,153,209,186,52,243,53,84,189,253,190,203,98,239,142,13,179,141,160,49,157,171,227,104,139,70,81,233,132,207,58,97,177,223,246,33,163,133,225,77,237,5,58,140,65,74,230,12,75,253,65,78,91,102,6,57,156,144,170,210,231,217,81,235,66,188,79,32,97,220,42,79,84,233,104,110,53,251,185,41,194,125,31,29,213,192,84,85,11,230,214,139,82,215,17,208,30,195,237,209,89,121,13,23,26,109,110,226,135,193,42,53,165,144,10,124,54,219,170,98,97,20,230,244,31,233,5,8,35,184,192,69,78,1,14,32,148,75,45,153,155,157,59,16,112,10,127,195,191,47,237,53,47,0,79,26,96,174,237,75,116,196,200,14,47,218,75,165,145,229,178,74,15,194,66,77,91,40,146,45,250,104,85,34,60,78,230,90,44,126,23,49,1,127,160,80,36,235,247,163,102,12,195,57,55,212,223,139,96,81,213,193,90,67,242,26,61,63,210,70,250,85,19,57,157,113,100,188,28,233,35,151,56,108,115,204,26,0,1,28,166,121,193,45,124,139,239,81,121,254,191,8,118,171,210,94,31,53,36,15,34,130,149,74,205,216,64,247,164,6,178,173,96,25,234,199,217,65,7,77,97,110,235,152,146,9,106,82,201,5,213,7,209,208,74,197,131,13,88,132,52,183,102,172,68,252,143,204,177,198,165,151,78,62,223,202,104,206,88,191,171,140,12,252,84,140,231,84,224,39,30,108,138,224,129,197,39,12,42,125,214,231,179,209,131,92,254,195,34,55,43,24,151,131,180,20,50,9,181,160,252,159,233,202,252,14,223,171,211,134,142,177,62,176,226,58,104,33,35,92,130,76,97,70,14,85,249,146,174,13,5,98,219,40,229,102,188,100,25,23,6,96,90,138,126,141,5,243,139,3,130,78,254,130,55,111,129,248,27,150,230,166,154,115,23,123,4,5,166,85,145,39,107,154,97,41,212,237,18,0,4,131,45,3,3,87,50,183,8,101,0,197,235,118,188,150,118,211,107,238,238,186,111,31,43,95,130,216,117,23,138,25,13,193,241,203,39,255,101,86,0,46,74,96,234,124,180,142,67,187,173,244,110,33,232,143,241,66,227,28,52,192,229,12,248,4,143,16,52,176,70,21,70,174,61,242,219,248,78,237,100,187,236,50,117,85,215,241,97,155,221,140,204,0,153,182,8,123,255,253,252,134,0,94,153,109,111,6,226,219,169,34,114,205,174,39,67,159,199,86,217,241,247,78,15,238,44,42,205,196,162,111,166,242,120,142,82,218,13,222,251,39,1,120,237,41,139,253,26,165,122,42,246,48,42,255,180,177,113,100,59,244,86,26,189,194,65,244,205,77,62,4,140,251,116,54,196,218,233,243,217,35,182,164,227,71,145,116,224,132,155,188,110,79,62,65,15,137,58,237,50,155,200,131,62,123,102,167,197,18,35,12,11,116,109,128,214,60,147,114,1,219,121,147,59,97,144,161,128,132,159,250,144,187,86,141,101,222,86,13,74,129,20,225,171,121,252,19,98,55,17,60,18,159,247,155,205,49,54,46,27,104,184,93,128,212,87,237,204,64,182,54,110,250,56,239,244,238,210,36,99,11,224,237,60,75,203,242,187,34,136,147,83,205,170,74,108,234,184,246,75,242,155,245,3,144,221,141,96,237,141,124,44,136,44,72,159,207,37,127,25,166,245,37,95,152,73,205,63,232,214,138,105,251,236,201,131,171,0,199,243,228,84,195,53,123,15,88,125,207,2,63,134,196,249,169,45,128,239,117,49,31,41,146,52,169,253,10,223,84,105,198,18,189,127,7,237,124,157,94,176,211,177,247,2,126,129,7,227,202,122,208,165,144,184,201,136,178,209,55,247,213,224,3,21,7,222,212,36,101,70,54,202,187,230,32,131,138,36,43,207,209,241,91,8,119,237,126,21,109,222,231,239,84,178,52,31,77,199,214,241,61,229,194,105,160,52,224,215,28,57,32,158,113,169,17,14,78,233,34,132,210,81,120,182,216,85,111,251,206,30,126,194,25,61,56,205,109,57,159,151,120,162,99,21,238,251,26,242,159,176,187,175,131,247,201,250,25,13,38,222,158,238,226,48,80,252,142,108,136,100,89,43,32,250,233,157,247,110,241,34,31,200,104,26,69,198,253,168,151,249,191,0,90,129,188,147,194,51,76,240,214,195,56,232,93,77,12,103,153,12,2,148,53,236,112,89,208,233,72,28,53,189,146,155,186,8,207,245,60,240,90,20,22,238,26,111,71,77,26,19,149,208,182,32,105,123,220,245,205,154,40,16,255,153,175,127,250,142,79,26,158,14,129,113,132,218,81,200,79,175,192,142,86,197,87,162,190,26,203,90,113,253,110,34,176,122,235,180,242,121,131,129,191,51,173,124,114,60,145,203,133,115,229,85,212,65,155,52,4,181,92,34,205,255,22,237,62,119,240,245,103,238,55,155,119,37,27,101,92,15,194,82,73,127,99,57,74,3,157,16,253,1,97,138,222,220,154,174,47,151,12,189,145,70,145,222,207,185,95,246,206,67,95,67,40,79,77,187,214,58,196,13,36,119,222,93,56,100,200,190,55,197,40,155,55,93,235,11,203,126,87,110,16,156,91,182,157,2,53,111,159,184,23,96,229,15,88,125,66,172,254,217,88,170,203,210,37,6,179,34,108,227,3,192,20,40,146,228,74,229,124,158,122,55,89,248,3,155,52,43,148,223,10,168,61,31,233,37,10,150,206,112,57,204,13,179,16,143,231,218,94,194,72,232,31,123,6,196,122,224,165,84,92,5,113,135,220,140,67,195,112,100,228,227,210,131,96,38,66,51,242,204,93,179,198,193,7,169,230,192,30,228,236,55,86,130,153,193,230,111,79,219,109,156,112,126,143,176,69,225,90,23,28,157,37,149,251,38,132,172,238,155,30,46,162,17,168,199,253,253,118,60,219,107,80,28,221,31,143,108,209,238,52,28,156,162,36,85,216,133,16,4,161,223,62,174,215,48,145,22,119,38,30,211,101,63,27,32,193,140,243,138,33,232,119,35,223,255,89,120,9,224,44,122,148,60,233,157,178,141,234,247,39,133,226,245,83,62,157,182,103,121,138,93,111,5,54,174,67,118,11,151,211,31,64,31,87,65,56,121,36,105,216,44,246,30,10,141,3,186,56,112,3,193,59,85,235,35,94,3,88,10,231,209,85,144,80,34,10,163,166,152,61,255,48,174,107,246,116,233,32,230,210,152,217,32,40,110,72,227,90,184,27,201,140,26,59,65,221,8,61,233,43,145,240,64,233,124,36,60,65,255,220,83,255,250,26,84,60,49,74,25,131,245,69,46,36,109,184,157,152,105,218,127,53,175,5,151,249,186,232,108,37,89,132,47,62,104,149,231,112,184,184,42,152,164,29,143,93,116,140,130,195,209,141,152,120,198,195,56,64,210,181,109,49,69,156,143,26,184,205,201,244,209,229,43,92,155,218,118,254,13,9,150,89,237,218,154,200,227,41,101,131,203,187,175,231,100,137,163,25,222,159,127,173,45,88,248,6,24,10,98,227,218,134,249,137,99,167,222,227,29,86,242,226,201,35,245,202,41,162,136,129,206,114,226,215,48,195,85,77,64,24,180,201,54,100,249,72,22,230,254,78,118,21,89,38,208,188,158,92,7,88,33,25,120,30,150,6,137,25,196,67,83,131,140,35,187,237,31,177,64,228,107,147,45,248,52,24,95,33,197,218,36,170,125,249,102,224,170,205,22,19,19,62,178,175,196,6,179,44,55,157,220,222,5,83,94,79,89,147,203,22,144,211,57,68,163,200,225,85,193,216,35,143,250,37,56,64,155,6,107,93,169,148,85,136,103,68,230,16,60,103,1,141,216,17,52,4,42,38,197,18,193,233,157,16,38,122,174,224,131,7,29,15,42,227,128,214,93,40,255,141,176,71,253,26,244,55,252,8,107,136,23,197,177,166,71,45,126,175,170,114,49,172,69,188,80,9,42,49,86,226,105,177,155,144,115,84,148,220,197,12,213,150,203,69,42,180,180,71,24,57,215,13,109,75,185,221,218,219,17,159,35,94,110,237,156,70,16,82,205,115,125,207,171,6,28,250,154,19,21,48,110,208,143,233,3,159,129,40,50,165,178,40,236,216,72,10,70,151,3,253,125,213,44,227,112,210,19,20,139,123,241,116,131,36,57,24,239,146,74,99,38,44,164,156,102,30,69,59,123,193,203,142,70,107,145,157,119,109,191,233,188,192,146,207,88,225,100,128,77,249,36,138,24,230,114,72,67,65,60,125,210,187,159,38,107,165,45,22,120,175,147,123,29,196,44,123,13,130,224,221,41,246,23,118,55,79,51,34,252,39,171,61,25,146,192,243,149,218,136,69,48,118,20,65,35,120,107,165,59,233,49,87,232,18,194,17,60,32,90,67,182,163,0,67,37,122,65,37,125,247,177,218,116,203,192,171,164,251,208,67,251,108,229,161,45,59,216,157,119,75,241,134,73,3,195,20,28,36,116,89,49,121,31,177,222,79,188,231,190,58,13,200,209,188,211,151,76,112,87,149,37,29,4,148,228,174,108,64,56,83,196,174,90,178,249,155,90,223,53,16,69,154,30,99,208,134,210,31,233,78,226,255,175,19,12,215,14,190,183,50,64,205,237,92,196,57,18,45,85,150,230,24,75,109,190,169,141,76,84,84,74,44,250,172,139,207,58,39,107,138,214,95,125,15,200,155,151,90,131,94,160,105,78,183,215,93,111,254,107,61,13,173,69,85,104,181,81,51,215,173,105,125,224,248,15,105,48,240,160,232,170,245,235,132,103,66,48,230,97,246,155,7,110,12,232,39,103,158,51,69,47,14,110,41,27,17,204,97,48,84,219,230,7,142,204,255,60,55,66,178,131,32,142,29,66,204,190,173,128,71,128,113,171,63,170,177,23,253,160,163,196,34,71,15,203,187,65,38,193,65,55,127,86,21,109,237,28,123,153,5,116,67,131,3,110,135,16,68,197,2,59,175,27,222,146,24,68,130,34,180,12,158,90,198,65,16,9,30,3,251,35,204,211,172,44,57,43,203,117,113,241,163,135,101,54,233,109,73,119,130,253,48,184,14,137,204,132,55,48,52,11,237,0,219,228,194,200,166,29,154,222,115,190,142,92,92,36,1,224,8,76,217,137,187,140,12,90,18,153,236,214,171,61,150,215,152,227,131,99,199,225,234,102,150,152,174,93,117,175,28,98,40,25,193,190,67,46,191,49,46,113,1,10,195,144,15,61,150,43,252,43,104,61,9,156,152,186,73,157,107,235,153,48,2,199,251,197,174,105,185,252,51,11,245,189,180,46,6,41,253,115,150,187,35,249,146,104,236,51,58,71,99,245,232,17,78,168,15,28,106,108,242,14,125,54,156,109,144,39,208,80,29,223,18,17,130,188,35,10,30,116,0,181,81,5,73,114,208,10,219,249,216,151,253,1,167,2,89,85,111,26,132,90,63,228,201,72,82,92,157,76,122,108,168,32,76,248,121,26,189,49,117,132,75,135,6,83,186,165,98,165,46,78,38,180,149,171,181,93,193,155,26,66,42,215,204,20,185,99,195,169,140,122,71,91,9,75,250,161,71,71,179,20,146,98,231,10,160,139,90,129,180,122,56,199,254,250,31,199,82,231,115,171,233,185,83,51,119,125,135,75,46,155,25,96,199,106,219,40,32,81,14,36,170,188,64,67,92,222,56,102,83,137,248,101,231,87,30,13,113,201,220,139,106,134,32,224,77,52,33,40,196,182,151,94,133,197,235,181,45,89,126,146,177,194,133,141,31,3,90,86,193,209,88,95,235,160,14,6,215,215,218,130,215,248,196,146,13,76,48,143,60,5,55,63,228,158,116,85,205,77,250,188,151,10,246,12,2,114,141,87,186,63,85,193,199,229,74,242,64,59,47,250,232,9,109,6,159,136,81,0,165,158,98,88,141,77,161,161,197,118,176,2,100,102,99,163,17,74,255,153,180,149,234,8,9,102,16,154,28,84,202,254,33,176,166,187,110,43,235,3,145,106,249,12,12,169,229,173,133,214,78,1,28,162,77,175,27,179,118,2,139,235,61,9,214,154,242,76,241,34,108,113,43,255,212,168,50,233,253,108,218,105,132,147,54,68,251,165,135,103,104,39,65,168,11,104,111,159,68,173,106,193,78,39,100,187,170,49,209,198,248,62,82,180,71,86,134,141,245,78,243,15,166,189,176,217,155,213,168,154,144,99,66,8,173,156,36,159,240,215,79,39,215,223,33,20,148,95,182,84,90,66,161,1,222,191,81,93,155,56,13,82,1,103,219,135,108,67,255,91,40,195,162,0,119,29,205,167,228,197,59,232,184,211,25,221,165,142,41,170,16,123,15,153,108,212,144,9,135,67,34,118,76,197,213,83,222,3,93,47,33,100,90,109,228,170,110,36,116,246,143,184,116,182,82,108,204,58,48,82,81,233,174,201,246,140,170,248,192,96,40,118,88,211,202,184,205,142,183,121,219,122,73,212,204,227,121,235,91,106,32,128,223,124,93,200,229,209,236,54,178,51,135,151,33,204,213,140,22,209,71,127,80,173,33,51,83,14,184,136,108,58,185,31,78,113,107,174,97,21,182,66,209,202,170,125,170,8,213,116,195,58,205,158,121,167,122,110,239,216,218,115,133,242,101,87,68,63,44,12,244,4,84,123,58,208,164,228,133,123,112,176,13,252,102,71,0,251,114,176,116,222,232,20,221,112,116,89,115,2,237,135,94,109,186,28,123,18,9,107,237,254,77,66,118,111,132,175,216,91,188,74,222,81,48,162,90,252,187,176,41,36,39,66,6,219,40,147,143,81,97,187,166,213,115,95,4,69,68,43,23,144,161,157,4,82,89,96,10,167,134,74,162,252,90,195,82,109,40,85,200,220,112,59,105,105,23,74,27,146,177,139,234,236,147,222,251,120,65,246,167,115,210,189,172,92,83,53,49,225,122,120,117,81,126,31,101,96,113,100,122,68,24,159,81,9,190,35,11,9,123,19,116,129,179,88,193,142,86,210,143,21,47,202,203,133,252,70,28,129,30,34,188,26,99,16,199,196,219,143,190,52,93,163,216,132,38,153,247,236,125,173,50,78,125,56,233,231,165,4,184,74,179,48,39,238,204,143,23,47,187,54,3,80,168,242,213,52,197,149,186,2,174,166,201,114,35,5,211,73,147,107,148,246,50,152,44,252,132,92,3,202,175,227,95,206,26,191,199,1,221,162,216,209,126,106,26,134,209,53,116,61,74,54,120,173,10,235,81,54,104,50,144,97,187,252,5,100,161,181,44,220,225,242,191,79,191,81,52,38,144,136,144,95,97,89,193,191,4,28,228,125,84,154,234,217,10,232,64,130,247,21,110,228,24,245,19,13,20,11,10,122,164,172,148,72,31,110,95,250,60,21,135,242,65,147,150,79,65,167,22,79,192,59,239,194,120,199,241,78,127,139,198,220,70,45,216,1,202,14,186,248,195,12,22,187,185,36,9,67,77,158,164,76,141,23,17,217,88,211,217,110,154,162,142,8,10,212,10,83,39,98,135,198,64,189,2,133,29,105,103,212,163,23,183,114,53,250,100,61,119,162,109,83,72,55,127,81,221,178,139,84,241,190,1,92,124,44,67,17,110,247,197,168,55,244,106,86,98,31,247,2,146,199,119,91,212,79,179,114,117,160,252,73,53,203,44,92,106,162,12,52,45,0,28,74,154,113,32,122,181,95,1,103,76,116,146,56,204,250,38,94,59,119,80,234,146,253,245,123,100,110,115,103,252,102,92,224,247,120,146,125,197,63,22,224,69,137,192,59,160,205,132,163,131,73,106,13,28,209,168,7,133,123,130,13,129,101,243,175,250,231,116,194,88,246,193,69,212,113,205,213,158,62,93,161,92,158,52,74,178,34,204,30,215,15,52,213,61,86,178,229,162,205,93,23,58,29,173,129,12,35,121,147,40,77,179,32,8,98,96,91,124,188,165,104,241,105,177,177,193,94,117,155,161,96,153,148,86,76,136,105,193,208,20,0,243,247,3,247,88,246,23,3,90,161,113,219,211,128,65,175,2,219,251,152,83,209,212,208,235,222,115,248,198,200,151,101,216,191,86,153,35,73,251,152,145,133,146,188,63,237,115,66,235,116,17,175,40,130,17,196,85,179,8,108,6,187,227,11,36,136,152,69,162,70,60,71,87,99,75,198,0,107,39,50,145,18,192,230,110,146,184,125,252,160,232,253,62,7,172,201,59,25,241,46,181,73,207,89,173,212,37,134,219,164,242,81,41,86,72,5,236,184,229,94,204,124,67,124,106,59,181,217,201,241,246,100,179,9,243,180,87,113,101,124,134,116,209,115,202,31,74,54,127,6,206,253,254,251,152,44,24,10,9,16,218,141,141,130,30,40,7,123,136,203,121,21,33,86,166,216,151,129,139,236,107,237,3,107,195,41,11,108,217,245,214,87,255,80,150,108,66,202,201,207,244,204,129,109,54,241,238,254,234,10,92,182,143,77,221,240,18,73,28,41,11,217,85,234,152,25,238,108,147,116,203,214,162,63,225,64,140,8,77,24,114,92,195,147,96,99,48,55,87,66,104,144,136,121,14,72,187,126,215,173,173,173,118,209,93,87,102,159,62,44,126,112,83,255,229,219,53,58,150,57,230,237,31,31,151,85,132,57,67,63,40,228,201,29,145,188,88,179,80,181,126,235,186,54,231,134,95,139,59,42,237,136,228,96,163,134,150,191,224,51,104,34,253,8,12,145,241,134,15,55,55,207,217,214,93,60,171,164,135,175,198,192,146,113,7,188,40,98,151,82,34,127,152,114,19,90,181,91,64,51,19,115,210,133,22,172,45,79,223,123,182,165,9,21,206,12,115,204,12,84,127,9,154,143,93,100,102,218,113,38,121,146,61,31,45,30,238,34,222,149,148,56,127,3,198,60,131,144,184,91,82,183,58,215,141,32,91,21,168,57,107,8,181,28,104,24,77,228,99,118,89,51,71,245,217,178,29,168,92,54,199,232,112,164,42,59,109,232,60,95,242,250,246,37,191,54,231,168,15,12,31,252,221,112,206,64,133,3,110,110,13,100,26,3,199,82,96,104,115,132,48,220,50,187,191,5,250,204,114,245,172,67,119,217,115,139,133,225,223,241,98,34,91,140,95,27,13,150,101,66,231,243,154,37,214,222,244,20,57,18,173,254,132,239,114,163,165,167,53,248,242,110,250,235,238,117,115,3,92,28,95,166,98,147,17,102,46,8,119,51,117,235,240,89,168,72,113,66,235,209,207,180,14,66,175,16,29,111,50,177,50,103,131,219,42,133,22,138,246,115,144,22,151,192,60,189,184,193,232,227,179,15,74,236,18,19,93,17,80,2,237,40,130,66,154,203,107,216,51,54,226,33,144,142,109,48,166,75,181,165,152,142,8,80,49,176,171,147,17,57,104,204,44,170,8,12,185,128,239,234,158,251,0,63,141,151,214,131,69,74,255,133,72,179,49,63,9,25,235,180,93,212,193,86,16,159,146,228,80,210,76,243,71,11,67,48,113,246,112,216,78,195,170,97,55,38,98,199,100,195,105,171,139,237,243,105,113,131,221,164,34,186,9,15,178,196,18,82,3,224,144,51,14,216,133,173,64,102,246,230,255,158,64,184,122,73,73,219,93,90,169,202,200,48,99,145,44,245,195,212,184,57,154,32,114,22,185,128,78,151,130,237,197,246,111,207,84,219,208,70,41,180,84,239,81,102,43,7,52,6,182,180,42,61,185,142,37,83,248,231,247,134,248,171,197,64,234,172,13,12,174,101,255,205,128,7,86,104,197,209,146,27,140,245,199,186,194,128,242,238,161,65,76,249,179,93,193,226,90,96,169,184,191,233,40,69,238,32,243,189,81,57,227,0,175,252,42,155,65,198,64,60,255,159,139,89,190,25,224,57,114,73,31,221,78,108,77,131,102,141,192,21,67,148,245,191,190,28,250,101,213,64,74,43,156,49,107,246,123,101,131,14,42,163,70,66,162,235,42,119,97,173,201,139,24,81,40,104,78,138,174,114,189,86,110,12,6,4,197,59,18,26,32,130,65,202,106,219,159,149,32,138,151,98,39,217,111,211,139,40,184,114,8,199,70,5,54,242,105,184,87,7,118,180,237,6,29,68,29,108,107,99,63,219,184,96,37,114,17,152,134,181,102,174,123,34,91,100,151,154,166,73,41,255,205,219,226,11,117,149,57,166,216,31,153,178,12,236,156,174,50,222,166,126,26,148,24,185,245,76,76,27,70,152,50,167,183,163,220,219,196,125,215,119,149,223,194,217,175,54,105,92,6,248,252,19,124,116,138,132,168,50,210,98,137,248,229,252,177,104,87,250,163,19,199,68,211,95,66,85,93,96,95,216,187,178,239,198,46,130,101,88,12,216,5,47,199,153,159,79,104,102,2,204,116,37,18,192,235,91,91,38,101,234,61,64,173,160,122,239,254,121,20,104,146,63,165,28,146,91,144,170,171,34,139,98,160,24,83,56,188,53,232,230,235,34,136,222,199,104,49,224,158,57,159,55,26,146,17,182,231,116,226,99,211,84,138,54,46,161,42,143,192,99,130,155,116,126,78,144,185,26,108,176,182,186,31,59,25,209,83,151,10,208,162,130,237,242,111,177,226,153,7,205,253,46,19,72,1,219,86,99,31,140,15,39,203,189,42,59,187,71,116,212,237,4,81,237,36,66,246,94,49,29,62,254,115,54,42,115,86,87,104,223,234,101,213,229,215,220,36,198,230,209,217,184,97,21,112,217,3,251,93,79,169,174,101,214,200,215,35,65,152,190,18,181,15,197,97,84,215,255,156,26,116,200,143,249,232,3,104,120,178,16,236,99,160,11,222,104,67,153,142,254,127,112,68,104,209,35,106,147,174,124,199,56,191,157,217,43,32,183,139,71,233,49,115,195,205,232,233,14,239,236,184,186,237,92,59,223,171,36,103,80,252,224,109,160,228,27,40,64,249,77,38,250,74,35,177,132,26,25,189,49,178,122,62,120,233,134,188,241,229,84,117,56,92,19,37,218,230,66,179,224,209,140,156,10,235,109,60,102,7,241,34,61,93,48,11,76,186,26,21,205,167,26,144,107,231,85,235,154,27,66,29,7,223,14,6,193,225,91,234,3,62,36,26,112,82,107,104,225,236,153,119,139,166,129,214,0,231,168,227,181,6,118,199,237,205,197,76,141,134,31,136,205,198,234,224,42,169,33,223,241,50,153,122,135,108,95,52,84,170,246,195,241,142,35,233,228,90,6,234,223,166,217,220,201,8,9,83,172,110,234,26,237,85,31,72,142,107,186,142,90,100,72,21,198,231,218,135,5,134,247,210,248,127,142,238,96,143,196,112,88,163,220,71,43,206,224,102,194,116,115,13,79,144,188,24,81,136,88,90,89,44,93,70,137,220,49,87,4,208,171,44,198,141,239,130,159,166,115,0,118,43,168,148,237,205,66,142,78,48,157,20,28,48,242,132,162,17,191,192,28,153,166,218,58,176,135,72,235,130,172,21,82,33,238,91,39,206,137,226,102,186,25,103,107,239,50,229,95,151,247,98,62,40,101,0,21,233,106,131,142,119,0,62,236,150,148,176,74,217,149,181,113,218,145,44,219,175,109,71,118,233,146,234,194,250,246,127,210,4,126,57,223,115,251,100,143,202,139,185,184,76,247,157,247,207,178,132,188,180,239,177,238,231,154,167,133,64,10,159,106,62,69,118,6,5,175,195,196,222,240,190,107,9,98,145,117,210,55,85,154,206,34,92,211,42,229,88,43,247,141,108,3,62,92,77,132,90,255,25,100,222,65,88,38,199,42,58,252,82,31,110,142,218,178,247,14,208,215,109,121,200,174,171,62,68,212,172,151,210,171,219,156,196,91,183,156,40,157,129,22,203,135,129,194,238,126,197,123,204,152,94,178,149,62,120,61,64,114,197,98,125,251,21,25,91,85,226,5,71,151,168,60,37,150,30,166,187,203,173,209,23,142,34,242,190,73,11,133,215,42,249,152,134,13,107,21,121,113,106,223,40,132,215,125,118,5,184,113,80,107,236,101,3,141,220,93,9,137,81,220,157,238,207,219,97,185,211,214,24,146,184,78,242,191,3,176,17,8,248,248,231,31,175,26,196,185,146,89,201,229,83,43,67,179,104,240,216,216,197,252,134,138,58,158,224,191,93,243,76,153,248,199,70,110,189,30,186,65,72,18,185,197,146,34,114,48,144,163,209,150,254,32,235,159,97,252,159,137,159,142,227,82,63,192,146,46,114,69,124,127,125,62,114,131,109,173,114,89,192,209,154,157,96,42,88,10,126,104,175,74,17,89,141,57,99,138,182,76,55,57,72,135,30,0,131,138,18,29,47,207,30,31,76,74,23,33,14,32,56,78,186,167,34,218,32,155,223,106,18,173,159,204,249,188,192,186,156,147,210,24,98,125,81,75,70,200,194,91,116,16,44,227,194,57,16,145,77,191,160,93,143,166,18,228,247,18,166,236,187,35,126,157,85,8,217,75,188,117,102,233,47,1,250,66,236,145,146,161,140,11,96,37,54,82,157,176,203,152,125,207,253,65,165,108,232,153,134,28,236,170,98,86,121,250,176,99,55,12,104,44,103,14,151,4,119,124,103,216,4,117,153,30,58,187,29,177,253,212,16,121,187,121,109,157,210,204,57,199,231,154,3,249,0,139,180,158,88,109,88,202,30,127,231,32,200,216,84,136,246,40,25,165,64,148,136,141,163,64,120,237,34,36,142,207,39,26,29,135,214,132,159,8,146,215,164,109,238,145,205,114,210,45,11,46,9,202,192,153,210,179,87,233,17,254,189,200,221,171,7,8,187,127,129,61,126,153,168,191,20,12,34,51,82,189,164,37,111,83,240,236,105,221,54,25,34,1,254,177,242,234,79,45,42,94,170,38,98,196,65,241,34,155,198,73,124,33,78,149,70,55,220,52,42,225,119,78,156,16,112,191,54,141,158,16,94,140,59,7,171,92,178,52,81,173,53,240,76,84,85,118,116,142,129,223,197,8,181,10,31,234,130,22,122,58,22,204,52,56,112,195,38,107,184,103,106,17,185,161,203,138,152,126,222,8,68,28,47,229,105,162,69,27,84,123,149,165,128,187,172,136,177,123,120,190,147,109,113,136,122,110,130,218,132,48,186,197,152,238,195,72,49,97,97,103,142,244,31,62,85,77,13,89,7,6,32,32,50,194,4,170,241,67,36,153,3,235,174,99,116,104,12,5,80,205,247,28,53,110,74,160,37,227,179,0,94,0,153,42,128,70,189,170,23,100,7,77,21,22,124,3,148,19,123,242,75,142,79,169,235,33,94,56,127,239,171,230,121,212,128,226,177,242,52,53,245,47,117,60,144,185,202,111,168,76,22,32,55,100,61,198,186,26,114,30,166,80,55,238,130,67,127,6,224,215,176,63,119,76,155,19,210,8,34,190,77,102,141,250,127,131,178,44,70,36,153,120,126,5,110,200,108,170,138,10,220,218,101,203,221,9,134,245,227,44,202,51,50,188,177,46,200,62,239,172,185,16,108,110,202,241,5,202,125,58,243,81,190,50,150,142,142,11,124,200,17,84,105,233,102,106,238,245,46,25,79,243,118,44,233,204,158,111,5,220,79,46,36,42,19,247,36,250,87,83,233,120,89,44,172,82,40,92,47,101,42,26,79,89,152,37,79,96,119,237,34,74,102,234,197,86,136,185,230,85,179,201,97,146,104,145,140,128,55,137,136,102,41,88,91,249,102,52,54,212,121,156,237,26,75,2,21,139,127,195,32,26,221,185,105,112,244,124,194,68,217,47,54,4,226,100,1,67,152,109,62,130,240,101,198,51,19,135,13,9,67,161,52,254,8,218,179,72,123,101,140,197,101,217,83,69,193,132,92,73,34,116,190,207,110,206,69,61,92,26,47,47,69,0,244,133,250,166,208,23,134,171,190,190,121,162,97,155,137,177,158,226,98,56,113,201,62,15,29,17,102,218,92,176,59,3,237,81,118,29,107,39,183,126,241,53,125,141,17,158,12,131,157,222,88,213,23,158,66,236,139,60,15,166,229,251,147,147,222,132,235,151,83,6,131,180,203,91,250,77,192,170,96,59,3,108,59,27,99,81,106,230,211,218,88,151,191,101,213,204,134,58,116,226,176,56,201,74,54,246,73,64,39,199,154,191,130,208,198,68,192,140,187,104,187,150,11,132,16,157,145,114,114,51,92,53,193,191,139,26,163,54,27,210,102,30,113,200,104,164,164,98,40,129,221,248,165,77,162,231,42,79,229,82,165,199,59,138,158,203,122,212,199,129,126,84,125,52,35,13,11,186,244,137,173,16,164,31,42,212,143,192,238,197,142,34,225,237,201,106,137,53,238,205,93,181,39,237,133,102,20,44,250,89,185,74,139,65,128,219,160,63,2,87,105,212,97,188,74,60,162,71,94,182,12,171,53,194,241,53,41,124,187,182,166,193,85,43,102,157,23,200,45,82,59,28,155,93,98,255,185,40,171,230,69,129,67,211,235,212,135,18,101,41,162,245,126,81,85,29,243,18,135,122,198,71,113,215,109,167,131,185,73,110,97,168,175,4,159,203,84,67,71,49,113,3,93,103,205,101,148,41,4,170,101,82,45,174,24,224,161,18,174,198,172,204,131,240,155,158,56,15,100,107,57,30,23,43,193,223,133,218,194,199,92,172,215,148,104,156,165,42,211,19,220,202,113,20,77,234,80,149,103,106,144,148,80,193,104,155,54,45,205,149,4,218,87,143,25,194,89,72,138,163,253,2,101,161,100,219,146,249,14,110,53,224,10,193,141,172,224,18,58,9,63,49,125,240,240,23,83,33,195,140,37,175,174,147,245,150,190,200,55,38,175,148,208,133,241,68,141,79,92,48,141,72,212,160,21,222,93,199,227,246,252,241,1,24,243,9,88,161,9,54,137,103,210,178,90,190,138,130,80,198,205,163,125,18,109,46,158,185,71,45,49,232,121,100,49,78,28,50,225,67,205,124,36,56,229,251,102,176,206,49,214,156,33,107,218,13,193,141,200,195,188,56,32,147,77,121,160,114,80,61,7,142,10,194,222,121,186,190,15,192,178,177,178,28,176,164,31,39,85,176,97,188,110,210,237,157,109,209,152,208,6,200,195,9,23,207,131,222,239,224,9,206,219,97,126,157,195,119,164,36,252,180,250,86,99,118,59,58,193,70,152,66,187,111,75,152,95,13,127,86,132,205,159,63,241,28,84,116,58,198,185,112,134,93,225,238,151,198,255,209,115,29,152,231,241,225,227,194,170,166,148,151,168,201,223,227,107,47,143,178,123,182,97,168,109,145,202,150,104,35,251,0,247,200,163,62,117,249,192,15,14,246,153,168,247,129,19,113,130,253,111,64,141,132,177,173,41,225,176,83,39,253,124,170,232,78,148,24,137,43,87,131,224,5,242,228,49,212,222,150,8,189,8,231,254,193,238,157,165,182,210,16,29,162,16,176,204,188,188,71,16,182,55,198,167,35,26,120,54,76,47,189,218,18,103,36,165,20,177,131,175,46,113,221,66,138,224,161,212,68,215,150,77,10,69,195,215,14,220,203,29,71,33,245,213,223,117,210,215,90,50,213,125,178,220,82,134,74,15,48,6,112,177,181,21,229,98,248,164,42,194,83,217,61,90,223,162,134,31,219,80,65,90,30,42,88,18,187,169,4,105,164,151,105,130,123,135,14,173,36,206,30,89,18,145,85,126,228,197,74,135,127,104,42,121,118,175,93,123,3,11,1,102,148,47,64,83,163,184,84,234,90,2,150,198,253,3,209,252,107,189,5,200,3,218,68,64,88,23,73,154,182,120,103,118,82,49,163,12,18,160,245,192,104,101,126,201,3,150,113,30,112,140,93,48,106,11,131,130,88,141,186,62,96,149,217,176,83,235,85,16,101,101,169,186,127,0,80,161,44,111,2,228,128,51,118,139,241,218,23,223,61,36,64,178,113,21,152,207,232,218,54,50,247,67,90,76,30,233,121,221,54,188,248,123,217,215,118,245,247,157,109,242,21,95,0,89,74,226,174,215,151,3,234,116,32,110,122,42,60,139,59,245,52,90,62,133,69,163,72,163,194,9,204,168,74,146,221,248,95,0,211,229,50,252,127,15,53,100,133,94,14,129,166,126,212,24,252,177,53,71,168,19,57,66,215,118,231,40,192,179,37,24,76,91,212,156,138,180,139,98,168,108,207,84,43,254,159,89,2,110,20,174,21,187,54,183,89,52,229,138,242,53,16,14,26,60,16,38,235,70,196,165,245,24,62,231,240,108,252,8,216,68,235,215,203,127,217,246,15,159,133,27,207,53,168,3,204,104,57,146,154,34,222,71,5,210,234,16,242,84,75,181,209,214,121,220,31,129,72,105,187,137,223,218,98,76,221,202,251,103,117,197,224,79,11,30,188,97,234,228,199,69,1,50,154,218,63,248,240,107,228,62,211,128,85,129,33,248,146,240,210,210,146,103,39,139,156,57,183,27,130,10,88,25,167,17,24,213,111,225,33,33,205,130,20,131,92,189,183,249,242,167,148,137,61,153,160,221,35,218,183,107,35,76,79,140,168,160,34,225,88,81,246,251,201,170,92,231,112,252,151,82,227,107,4,123,247,239,195,174,94,56,168,99,8,65,61,78,220,50,179,87,2,185,129,177,239,54,88,59,63,123,118,93,20,29,132,119,199,82,223,209,148,167,142,237,189,196,117,180,64,149,180,33,91,90,42,112,106,225,9,222,168,118,32,63,123,61,39,17,195,226,127,249,13,215,4,165,196,124,140,212,96,3,126,198,215,37,164,20,17,72,245,153,249,167,2,2,21,183,112,233,126,105,171,231,128,39,222,102,181,118,235,7,31,208,77,247,138,229,210,25,44,68,140,196,13,155,197,118,247,114,52,102,236,114,61,83,238,189,175,246,217,156,101,75,223,45,202,157,66,138,127,103,197,6,1,159,152,103,81,196,231,237,206,172,110,247,19,207,1,97,2,221,112,126,234,249,128,76,203,141,102,194,254,218,118,121,157,64,99,121,155,98,245,125,209,91,65,196,1,109,175,81,122,81,104,117,134,109,80,10,118,102,225,196,39,99,208,26,106,72,207,180,68,122,45,246,77,206,12,140,154,121,210,80,152,41,173,21,222,113,45,108,147,11,249,104,96,35,193,190,212,17,222,223,112,60,26,137,125,3,66,187,116,20,125,20,159,184,118,50,41,174,99,247,105,136,238,160,110,220,31,154,118,181,10,165,117,233,60,50,248,233,111,210,46,58,234,237,82,45,174,253,91,171,63,222,32,212,224,128,207,72,117,27,80,111,188,79,150,164,185,52,103,228,225,53,209,180,161,10,98,45,174,221,159,148,60,170,116,247,148,80,133,160,110,172,98,147,153,6,23,164,75,4,106,48,106,164,42,100,20,106,59,207,34,207,189,47,72,139,176,5,65,242,196,11,32,70,222,171,93,23,19,5,49,7,88,18,230,93,172,193,186,9,183,17,17,71,137,200,64,206,152,47,1,123,1,26,92,47,32,153,1,253,167,22,241,195,203,79,6,141,178,114,228,208,172,151,16,251,132,15,209,86,75,68,166,181,135,215,139,85,29,137,236,196,32,208,71,93,67,24,220,58,81,254,110,97,138,53,36,177,244,14,226,73,213,177,13,228,207,9,200,147,177,161,187,117,250,148,241,47,244,10,239,139,48,179,181,43,74,23,161,162,109,228,73,30,150,169,188,121,107,18,191,85,250,184,111,5,169,42,224,93,137,248,117,206,69,100,161,120,90,59,93,177,151,68,199,104,119,171,186,102,171,106,17,160,144,161,216,175,209,68,211,137,58,239,103,56,230,218,114,52,54,121,110,102,156,98,98,123,68,145,234,31,60,176,206,154,4,185,133,46,94,26,157,129,250,222,209,8,250,173,100,58,141,216,80,61,94,190,48,161,50,152,165,187,55,8,234,203,15,199,210,195,169,128,205,111,51,234,128,135,207,128,31,100,235,6,52,155,242,153,200,35,23,230,128,236,241,90,49,151,135,13,133,156,229,100,206,180,147,204,176,47,172,58,172,209,53,166,63,148,90,219,151,198,79,255,64,212,85,189,188,243,254,35,54,230,78,214,27,237,205,16,72,227,78,91,146,236,161,219,101,133,16,41,25,95,213,60,78,8,97,108,80,148,159,182,154,62,3,92,104,32,52,103,45,114,181,248,128,99,242,87,58,219,93,67,85,166,27,189,161,251,124,83,235,21,248,59,68,79,27,196,29,229,110,162,188,131,147,229,63,123,102,224,104,35,244,0,229,125,218,94,157,234,233,215,221,80,194,117,206,246,108,211,234,237,21,52,191,190,102,236,97,84,218,175,217,248,193,57,115,64,178,179,197,160,209,36,3,219,210,100,160,95,78,14,158,11,22,223,222,48,44,21,34,86,217,163,63,236,69,79,37,174,121,191,5,0,181,11,13,116,19,163,53,104,163,37,78,7,96,102,234,92,151,171,102,50,211,161,118,32,157,157,124,249,210,49,10,117,170,104,148,178,217,247,230,174,141,178,162,168,199,151,228,122,44,210,91,7,218,222,201,219,116,108,40,193,191,34,110,240,35,57,246,236,151,198,140,229,110,64,128,185,32,91,245,81,98,212,141,90,46,231,171,62,167,66,244,160,155,28,97,36,152,190,214,33,246,229,92,93,59,83,147,108,30,107,141,189,134,184,236,124,136,250,132,234,19,99,6,167,53,188,108,254,28,191,144,171,137,21,114,32,142,19,206,173,250,29,183,172,45,30,58,134,206,16,174,201,159,196,159,30,180,132,194,227,106,138,57,171,118,221,95,81,42,96,153,63,8,18,241,212,179,212,103,205,141,150,3,18,233,216,159,163,248,217,144,103,37,246,107,117,118,106,14,246,51,219,198,109,232,150,114,191,155,194,80,114,177,157,82,178,48,196,244,124,126,15,209,131,3,216,115,53,121,45,35,177,35,38,173,38,188,247,83,103,60,190,212,139,80,204,100,249,33,170,140,233,242,42,43,78,110,233,113,134,133,77,98,163,157,194,191,193,14,65,237,152,198,177,107,194,209,113,25,198,50,121,86,145,205,34,59,145,72,115,209,144,174,56,136,174,70,226,33,194,77,192,168,202,9,137,243,143,146,126,165,141,139,165,203,33,36,183,155,7,222,77,215,225,169,219,252,149,191,104,236,85,55,201,150,155,26,113,236,148,52,74,168,233,95,96,185,94,187,208,27,88,32,240,29,141,85,103,121,119,181,234,185,136,158,133,253,244,154,196,146,182,253,150,13,136,70,48,104,150,144,207,12,87,238,62,100,99,240,217,124,11,85,55,249,233,87,123,181,222,145,149,38,90,172,60,186,69,168,222,87,194,28,51,156,253,72,224,52,82,9,36,169,130,101,236,18,113,181,62,228,232,254,229,131,225,52,120,40,62,42,77,188,103,4,218,11,226,106,3,13,106,252,254,43,228,99,110,252,88,199,220,110,232,3,123,24,178,134,143,190,183,15,80,252,57,163,182,51,51,236,135,194,15,79,28,143,106,26,107,244,193,200,166,206,129,67,121,233,7,9,207,34,158,169,95,71,158,136,152,105,130,140,65,200,67,226,134,46,135,138,99,35,155,142,78,132,179,148,52,93,214,29,134,24,138,240,161,170,124,155,4,219,56,64,170,46,232,189,137,55,5,182,235,176,46,127,220,35,236,205,160,68,228,94,27,97,232,226,48,203,55,3,171,4,59,214,241,167,187,244,16,34,123,219,34,130,176,214,102,73,31,100,241,34,87,178,49,45,255,138,134,124,33,100,89,95,141,98,182,252,171,175,56,132,155,137,216,4,207,39,170,17,55,172,69,248,131,231,55,58,134,235,3,73,131,54,215,108,235,11,201,180,81,222,181,32,53,125,10,249,38,196,109,83,80,146,244,196,14,180,184,105,21,251,56,65,219,88,3,178,187,212,32,132,95,158,2,237,76,16,148,109,131,187,47,5,81,0,208,142,129,33,252,57,189,214,249,112,168,218,128,167,224,179,60,87,24,253,31,192,46,21,38,47,8,222,180,37,182,231,124,160,175,181,164,230,188,255,103,38,59,228,52,215,36,148,203,93,195,92,137,78,155,242,76,73,37,46,30,113,250,205,115,26,53,142,106,92,183,222,135,71,191,123,179,234,181,183,39,127,25,91,173,141,243,98,220,226,132,166,202,164,98,203,190,164,63,198,195,88,210,187,235,176,219,34,228,53,184,58,131,159,161,77,252,182,39,218,65,104,121,14,81,249,69,27,23,77,103,20,46,245,192,93,81,59,1,174,67,100,103,102,50,198,98,46,206,45,12,1,54,19,33,186,102,42,111,204,214,82,96,42,109,148,194,199,115,115,130,36,181,23,154,18,201,19,146,226,243,132,250,51,169,233,23,175,140,38,217,248,167,65,235,216,120,69,252,242,107,190,76,126,181,125,186,159,61,220,158,42,12,81,195,68,206,180,174,145,148,108,14,210,170,55,60,244,145,106,139,94,134,27,54,199,176,136,176,159,126,41,29,63,131,103,42,70,196,204,186,151,196,206,114,50,173,53,40,244,187,131,57,37,131,121,0,188,223,219,12,88,20,202,1,20,142,255,114,181,59,137,202,53,28,176,34,227,240,221,118,24,159,126,240,12,206,39,70,185,106,65,128,128,56,74,81,8,128,35,15,83,61,114,100,222,133,142,125,231,45,98,95,228,167,135,87,166,48,93,215,91,168,25,237,7,253,106,19,123,110,56,129,167,247,193,243,28,123,122,102,128,215,7,185,223,154,209,43,155,244,15,95,103,113,216,82,229,139,235,13,116,75,111,8,189,84,134,134,9,171,141,132,55,190,87,124,212,163,13,88,58,25,60,142,32,40,54,200,241,59,254,178,100,75,75,237,166,51,166,38,133,36,64,10,237,35,132,230,169,0,160,229,238,230,159,185,188,53,59,222,173,47,227,120,243,3,143,134,221,185,157,45,177,171,138,200,56,56,250,41,65,162,45,2,81,173,72,164,215,179,161,43,131,155,48,4,2,141,223,148,252,148,134,218,238,12,126,29,108,90,185,102,31,47,189,186,28,148,107,228,171,111,117,232,226,175,96,46,195,124,83,114,82,163,79,226,13,161,171,146,211,204,43,231,74,188,164,62,100,7,22,218,180,184,120,130,61,195,176,144,236,92,216,202,36,23,24,25,219,101,145,46,147,160,238,37,104,46,213,4,236,86,172,88,16,90,115,200,240,29,44,197,229,33,49,61,115,198,86,136,58,46,53,183,255,14,255,60,20,248,69,87,124,162,138,133,28,155,138,123,82,109,147,206,200,108,86,62,57,18,239,219,49,250,7,69,83,186,56,76,230,160,63,83,139,47,34,108,168,95,219,240,174,132,45,134,116,122,247,107,184,36,147,212,19,33,49,68,8,71,160,234,244,108,113,120,124,227,230,228,144,25,27,50,38,170,28,98,70,87,128,76,25,157,217,78,54,13,74,134,88,142,236,221,28,184,102,41,14,245,80,144,113,74,30,168,180,75,223,73,193,125,233,112,155,86,212,112,12,37,85,234,193,202,79,10,251,22,135,20,214,141,76,142,169,141,184,206,8,65,83,233,73,13,183,251,211,41,232,145,192,102,78,127,84,168,38,179,207,93,249,51,47,208,143,84,166,82,190,40,124,167,0,65,239,78,3,32,129,152,250,32,197,213,165,147,111,71,101,30,180,118,205,225,167,234,107,100,200,239,128,128,194,104,242,136,95,127,199,27,176,155,225,19,8,130,200,209,177,23,73,12,113,150,76,78,80,41,8,225,44,14,37,150,120,142,198,208,209,134,105,216,164,53,43,86,245,76,77,176,228,49,27,105,120,216,99,204,95,107,194,156,55,118,7,14,122,129,188,247,136,220,86,104,153,15,161,161,242,181,217,180,67,63,31,166,89,219,162,252,47,132,19,120,102,95,10,100,153,66,48,200,230,21,157,92,29,241,99,212,229,122,191,176,221,82,14,68,74,34,59,131,165,65,16,29,189,174,156,239,202,63,69,184,107,102,10,210,11,49,233,161,88,205,49,223,1,142,202,101,71,137,98,151,163,112,82,183,164,110,68,54,134,187,212,63,204,36,198,131,28,11,134,199,219,61,1,56,83,17,86,67,86,180,75,236,223,9,248,74,8,245,115,16,226,248,48,216,26,227,55,221,117,219,253,234,167,29,248,93,225,64,231,61,252,23,68,89,100,39,216,221,251,254,150,202,163,87,193,55,224,14,131,207,244,187,56,0,67,14,166,46,129,174,202,141,115,74,220,177,49,11,232,177,142,127,37,32,250,35,155,199,67,243,199,128,6,26,101,7,247,249,16,28,21,75,35,202,107,246,65,57,93,20,104,63,249,22,57,197,82,132,62,55,228,217,234,134,73,95,126,166,194,56,173,187,143,104,231,168,244,132,167,104,98,74,53,163,253,197,230,0,110,8,5,183,160,31,178,75,39,140,199,19,201,86,218,22,108,192,181,27,243,123,158,252,54,59,4,205,113,224,176,19,179,56,89,107,221,233,122,130,77,29,55,111,69,97,180,62,142,130,133,110,116,63,118,226,140,12,32,107,44,82,146,60,249,15,15,88,139,60,175,119,157,13,13,22,233,86,127,163,27,111,31,101,85,187,228,131,132,5,71,11,41,192,93,52,31,94,185,179,57,146,217,86,59,127,225,164,65,1,60,117,98,124,159,208,231,9,59,139,90,98,96,72,177,134,70,64,80,133,231,172,93,24,79,5,166,185,197,237,224,76,100,92,89,5,224,204,237,141,208,10,99,161,36,235,209,189,53,35,89,217,246,60,58,10,231,184,237,206,152,212,125,151,132,72,107,211,250,7,244,82,41,127,88,192,35,106,177,46,197,156,222,169,166,96,138,18,36,32,177,254,41,95,46,15,142,108,176,180,237,206,189,128,99,104,227,171,243,226,81,133,242,42,162,166,155,200,231,43,251,184,132,187,123,94,221,191,59,49,113,141,201,95,194,177,165,134,156,118,8,26,30,136,210,21,27,229,116,212,116,142,221,90,48,194,173,5,1,159,23,139,99,43,240,97,16,215,189,123,54,49,29,58,200,175,251,53,69,156,183,188,30,142,215,69,109,223,58,44,1,228,23,241,135,245,104,190,30,151,122,6,196,22,114,235,158,173,222,229,150,20,127,184,233,80,158,232,24,133,81,154,72,95,196,161,19,205,54,84,246,46,108,3,25,182,151,11,146,45,213,59,2,212,90,159,191,17,174,68,25,237,152,222,72,20,49,244,103,79,15,100,248,180,163,91,74,152,94,246,238,147,21,75,34,148,54,76,205,162,55,66,10,182,222,98,20,144,109,180,117,144,2,25,231,188,193,180,87,74,233,113,223,159,119,43,25,65,108,99,142,29,8,1,245,191,171,11,244,94,89,190,229,106,191,51,155,76,244,136,215,242,47,174,71,64,209,19,111,93,125,182,98,122,153,185,100,157,129,123,62,111,125,182,150,211,237,253,135,180,216,151,67,69,77,128,129,60,171,119,141,169,159,221,68,206,236,155,228,43,0,202,180,40,243,78,144,225,119,163,65,245,200,215,199,70,96,130,36,225,61,127,148,20,46,111,192,213,69,170,9,18,9,119,27,57,120,85,161,148,238,73,17,129,111,102,236,237,34,18,47,223,94,57,255,151,212,197,151,114,114,170,175,83,101,33,74,62,43,205,209,119,77,136,88,43,135,111,21,95,69,56,73,112,241,94,165,93,232,156,86,30,171,141,235,1,222,183,90,67,115,94,29,213,57,226,95,167,228,37,164,169,163,40,97,99,43,238,193,80,150,183,127,166,56,58,238,218,98,114,53,119,184,233,26,132,214,21,32,32,249,132,187,221,107,74,149,61,246,8,189,139,77,205,226,204,196,247,184,84,127,5,170,36,233,116,112,94,174,102,20,90,103,30,215,132,39,117,41,4,235,48,175,143,99,90,215,218,106,15,46,236,50,11,144,212,112,168,20,105,63,144,237,123,173,65,192,192,131,67,245,84,217,137,101,194,1,13,112,253,82,144,181,220,71,197,105,222,53,205,171,127,153,94,59,35,40,62,36,119,80,238,250,90,59,5,208,197,188,176,234,15,180,152,63,138,245,27,68,132,251,145,144,126,235,49,98,67,108,13,53,248,212,183,206,38,202,34,220,166,237,243,35,8,117,138,253,58,242,163,74,235,163,114,174,2,1,146,83,116,215,143,46,5,39,34,255,6,183,248,68,197,211,16,222,32,149,24,10,178,253,13,247,62,133,224,175,175,21,44,16,167,88,11,250,187,103,129,17,217,80,112,189,55,47,138,200,105,197,39,60,1,148,137,223,48,243,213,82,71,108,134,144,252,100,223,8,175,102,124,167,160,42,231,240,193,106,63,168,33,194,126,152,132,208,171,218,197,187,111,9,86,190,213,118,43,46,115,205,196,57,255,96,62,66,76,95,52,49,54,219,93,216,89,20,114,11,28,67,145,167,64,30,59,88,59,208,165,6,68,249,163,239,115,98,21,212,144,34,86,33,69,221,189,207,27,169,11,235,39,254,30,59,150,248,226,136,209,91,229,42,92,129,235,204,200,3,88,185,75,115,150,117,77,126,86,191,154,70,70,92,197,20,78,151,52,25,10,82,142,193,52,119,141,13,93,100,241,18,236,76,245,157,186,121,46,108,49,53,173,221,192,117,192,116,238,108,5,92,157,95,159,133,192,221,122,67,219,69,182,230,176,55,178,222,203,112,173,56,191,43,206,204,13,217,58,9,24,17,218,113,248,194,37,249,34,210,68,152,48,84,187,100,162,180,77,210,195,19,161,11,187,189,11,190,196,224,26,218,180,127,254,172,35,13,119,39,157,226,245,229,60,177,120,178,9,249,46,169,116,31,125,13,219,219,130,95,7,52,109,53,251,32,171,74,54,252,88,87,144,55,96,41,242,253,186,56,140,112,79,156,62,158,50,246,119,6,107,60,235,218,90,68,138,74,60,150,179,150,17,76,127,22,226,31,55,208,38,183,16,43,124,85,69,115,116,184,53,6,37,185,132,136,20,123,130,78,52,102,24,143,56,103,69,42,167,175,50,56,182,126,178,105,105,169,172,233,110,193,108,199,5,247,177,242,18,254,205,173,135,42,206,169,121,94,35,233,99,232,145,109,230,148,4,40,182,165,37,240,51,191,189,188,123,199,137,155,69,166,130,72,236,49,250,241,132,163,17,108,181,67,102,229,176,229,137,163,99,237,105,130,183,236,125,52,86,211,229,125,60,111,100,246,172,89,174,106,30,23,232,109,11,125,7,201,129,106,241,208,86,84,29,173,248,198,0,99,77,136,36,111,50,77,150,173,152,13,5,108,203,85,166,251,80,222,57,171,228,21,162,172,12,71,31,154,212,235,140,205,116,176,69,213,174,36,7,205,224,8,40,131,35,102,20,56,62,48,115,222,236,232,100,189,233,29,174,113,148,137,138,188,170,0,242,1,199,67,171,219,33,9,167,13,225,210,152,200,110,36,41,215,152,176,158,212,210,1,138,114,139,7,205,78,225,52,71,106,220,76,215,184,209,131,203,168,119,240,155,37,253,184,236,38,99,32,253,24,162,69,218,9,248,142,128,167,238,15,46,20,208,76,142,169,249,28,39,189,147,246,237,213,214,238,65,250,159,106,231,65,177,66,86,112,54,19,24,78,83,99,184,167,212,240,174,99,8,216,74,99,131,26,243,251,196,103,54,173,81,53,84,57,222,96,29,216,45,118,72,252,79,152,104,171,221,61,188,113,40,107,230,118,246,156,112,27,197,173,148,168,249,80,229,38,10,137,139,83,223,45,43,148,136,130,7,162,193,62,6,19,90,142,164,87,51,157,254,132,17,176,72,5,85,106,214,94,252,183,227,88,168,213,191,205,105,11,157,250,179,242,17,139,82,81,224,52,60,233,5,84,135,141,6,199,228,198,114,234,26,68,3,96,183,254,249,22,69,178,208,123,100,174,226,227,194,179,151,128,189,193,164,13,193,143,181,110,145,27,129,149,128,42,69,106,250,62,167,224,142,225,226,87,123,108,140,7,37,55,2,48,100,2,149,122,66,165,88,55,63,75,137,92,5,11,36,132,86,237,78,188,137,37,4,84,211,153,83,79,12,64,142,201,74,246,27,248,33,83,217,28,134,201,37,216,208,252,196,120,126,255,224,211,30,117,228,254,167,209,124,4,193,204,228,236,118,199,10,117,172,137,18,17,93,21,51,120,142,64,56,47,78,10,33,238,182,127,190,194,223,184,66,0,213,171,112,236,234,35,81,133,147,206,79,207,75,0,248,12,195,113,170,245,199,246,114,7,52,223,165,214,91,120,50,18,154,239,200,236,75,198,201,98,247,24,253,146,153,242,162,3,154,25,42,132,183,220,45,245,128,2,121,151,86,185,12,28,2,109,152,136,114,175,57,134,120,36,147,149,186,213,46,121,64,118,235,233,140,13,144,22,101,194,116,229,188,58,137,230,59,147,179,142,78,147,135,253,2,32,94,194,62,0,151,178,211,153,151,245,43,105,153,144,87,165,240,134,8,208,210,24,76,182,179,198,117,233,239,100,147,110,63,25,223,207,238,191,13,38,54,69,75,129,246,227,41,50,211,160,7,165,125,47,159,165,222,142,26,140,187,28,43,226,133,53,119,65,152,4,85,193,166,145,117,176,203,90,80,141,206,139,89,79,214,207,21,247,236,85,167,122,80,152,29,76,171,37,15,87,253,238,82,204,191,62,27,105,235,79,7,26,44,149,11,168,181,49,81,245,13,183,229,99,89,178,171,169,212,246,24,61,138,48,155,183,240,151,218,4,155,119,33,57,109,147,153,112,242,239,17,234,255,17,100,200,47,8,4,141,197,206,10,110,192,198,218,148,170,99,0,109,33,248,103,165,19,116,198,113,254,135,132,92,101,119,37,213,26,43,203,199,238,232,43,223,45,241,9,137,134,145,22,248,179,12,41,231,136,108,24,212,104,113,236,196,135,130,64,173,207,32,232,62,175,38,82,33,113,200,114,69,9,144,61,86,161,129,210,31,29,252,162,99,35,53,197,107,5,237,178,60,168,160,144,49,40,181,115,111,7,81,142,199,25,50,143,39,15,245,55,200,134,175,27,206,224,106,131,71,10,246,7,51,117,41,184,80,34,182,0,212,210,198,108,148,40,158,111,180,199,120,129,119,28,154,181,244,205,233,142,205,235,20,212,132,191,245,63,154,240,135,213,126,139,13,10,173,70,221,60,92,145,25,148,112,126,30,1,209,154,88,178,111,78,19,204,58,28,76,151,223,162,36,120,122,84,7,154,94,193,137,218,97,160,40,92,8,94,187,43,85,34,255,17,186,162,45,147,190,120,32,15,162,143,40,203,104,136,8,230,246,65,248,159,3,64,37,29,183,84,228,78,99,20,255,190,83,86,99,65,53,51,39,158,188,118,240,92,194,25,164,182,160,143,191,64,220,56,200,53,53,181,174,202,13,240,78,185,33,172,198,220,167,192,98,84,217,210,251,200,57,22,62,18,180,208,42,151,199,112,246,234,163,250,124,145,179,163,141,167,246,161,78,138,217,236,144,113,27,123,232,63,153,153,90,234,251,112,158,246,0,37,53,44,244,173,82,38,213,26,26,213,173,191,148,25,93,187,133,80,205,2,117,228,240,177,146,18,106,188,112,41,9,189,87,3,65,51,47,200,125,29,135,41,49,67,140,74,165,33,124,223,44,7,128,102,150,22,58,210,120,177,50,127,237,253,157,72,131,116,196,111,19,165,208,161,25,152,144,230,233,185,224,104,118,35,156,134,237,37,132,24,230,65,102,82,190,199,61,106,23,211,121,31,156,248,86,96,146,231,193,186,210,112,10,170,227,227,117,12,46,79,250,53,102,224,105,84,225,139,93,98,35,63,190,117,193,146,190,14,12,17,245,38,17,87,172,162,209,241,112,247,130,48,42,219,168,1,20,241,8,253,38,89,32,213,108,0,254,195,157,226,187,108,112,229,85,176,105,245,68,161,156,91,20,171,87,173,12,212,10,72,14,145,33,94,188,202,224,19,3,236,23,200,74,96,88,252,45,139,47,99,192,237,218,230,115,153,72,128,27,3,180,1,30,130,61,147,20,27,195,70,130,36,246,150,109,130,242,119,67,30,7,0,246,243,144,254,144,93,201,236,188,129,79,205,159,21,41,97,142,207,220,55,67,202,182,20,153,33,148,40,26,46,133,209,101,247,114,76,250,52,126,26,80,39,99,31,18,90,212,174,180,5,105,138,236,211,7,112,139,151,117,243,120,223,37,4,215,235,101,202,164,74,111,14,130,24,118,191,94,182,236,91,69,130,39,161,103,255,33,183,21,52,63,139,114,159,120,167,219,55,102,136,22,141,175,153,163,50,58,40,230,15,156,90,1,246,230,167,164,64,173,198,83,230,95,160,123,131,50,217,26,144,116,42,193,72,183,150,102,124,4,125,117,150,207,138,239,211,20,45,112,124,221,196,218,30,129,249,60,115,3,84,94,25,70,188,253,78,108,56,164,59,43,234,55,114,17,94,189,103,132,224,233,144,74,47,37,116,201,23,153,58,41,32,73,69,158,186,218,221,69,24,215,67,3,24,222,252,9,83,212,102,92,23,134,111,90,46,72,191,167,167,56,245,132,16,165,144,18,176,12,148,244,228,52,29,57,187,69,42,125,233,136,8,0,242,102,110,114,40,160,171,17,191,5,126,109,223,70,148,132,40,200,89,150,246,79,209,143,225,201,3,205,171,90,229,135,161,237,58,83,47,219,184,152,142,154,226,76,21,170,60,147,62,195,116,94,86,65,68,52,31,122,101,170,95,175,16,184,48,47,156,172,11,161,212,117,197,154,69,33,80,244,201,213,95,49,69,142,239,0,33,77,116,158,113,75,147,216,23,110,78,13,100,144,125,148,198,76,200,148,205,11,35,95,238,208,95,92,250,175,56,254,155,21,105,192,222,160,88,52,218,139,56,113,119,194,85,80,158,64,252,232,83,172,74,32,132,39,60,189,206,135,50,82,226,129,42,239,241,54,146,207,250,174,28,51,150,179,207,92,118,141,250,205,171,36,149,89,240,10,243,37,154,206,177,153,37,7,214,236,64,245,65,7,19,11,51,163,54,74,29,3,60,10,67,86,210,189,25,84,38,55,121,16,207,126,158,244,210,128,115,213,137,217,148,142,94,81,122,173,16,5,151,18,126,8,118,46,21,15,178,203,202,54,15,45,159,164,214,255,173,143,117,199,23,14,242,151,215,102,65,172,12,60,167,33,220,94,96,128,123,253,33,73,232,8,106,232,195,151,91,8,8,249,44,224,166,237,42,208,18,203,134,187,6,120,6,89,9,21,97,70,185,51,12,210,233,122,134,121,59,185,100,11,16,22,158,131,129,142,91,177,120,86,204,40,132,219,165,179,160,251,206,89,126,143,165,198,189,154,34,51,195,203,137,178,2,145,159,124,189,125,229,195,18,193,123,90,2,121,20,146,19,190,40,239,248,45,29,72,24,147,14,191,228,118,94,10,84,208,206,230,97,243,39,77,78,202,4,240,92,201,163,162,114,82,197,36,149,218,170,126,120,117,217,24,93,54,132,254,30,232,206,70,10,90,154,39,121,86,98,215,181,1,201,3,69,121,128,115,188,84,149,163,83,60,231,26,106,220,207,14,189,180,135,191,50,107,219,174,114,51,37,246,77,83,155,174,188,135,111,92,175,64,150,195,243,78,240,153,45,37,253,229,88,133,221,50,161,48,240,104,91,156,33,114,228,180,109,185,190,187,132,128,242,202,58,242,51,156,221,74,122,133,158,129,147,146,151,188,99,75,64,35,201,231,64,26,21,193,185,118,183,78,188,194,206,180,252,160,173,184,184,31,52,143,68,247,91,117,140,210,226,10,247,210,145,145,160,228,204,115,243,59,177,161,43,249,252,246,127,251,150,167,16,1,137,34,88,3,162,178,200,247,132,152,4,105,26,0,87,42,185,21,78,210,181,14,198,17,231,5,64,193,50,152,124,85,243,107,136,132,252,190,125,192,239,148,114,228,127,213,143,22,14,150,183,155,213,80,114,104,188,216,199,51,36,212,20,113,229,93,234,238,160,183,15,128,223,89,136,31,241,13,13,65,240,122,47,6,224,12,75,44,8,247,114,109,214,96,62,231,198,61,49,71,255,27,153,100,157,72,28,163,27,154,223,89,240,138,173,222,136,25,26,26,236,119,186,176,244,55,240,116,2,217,230,55,176,234,209,148,83,13,87,60,252,199,197,189,184,133,63,70,61,236,46,4,214,134,85,40,191,97,98,30,193,137,39,51,200,194,157,71,225,140,67,68,187,207,106,61,244,187,243,74,246,174,25,111,255,30,247,200,103,187,248,221,112,48,190,207,254,237,92,194,83,234,174,15,79,173,73,209,5,9,32,178,14,60,196,236,82,245,211,95,4,155,59,125,139,45,146,195,199,144,124,225,23,185,3,111,25,117,172,201,158,192,252,167,69,124,250,150,249,153,0,56,238,116,142,192,95,130,102,172,194,130,121,179,40,148,253,83,119,170,95,66,75,155,184,176,76,125,221,115,21,161,62,210,220,73,90,0,71,56,103,158,33,111,227,176,158,37,152,218,107,138,55,225,249,129,173,94,100,71,163,106,168,247,142,185,46,107,34,136,9,194,146,239,35,18,154,168,114,51,79,34,99,192,155,64,237,109,104,91,252,156,244,226,237,129,200,109,205,156,122,191,94,85,12,97,159,151,156,207,211,230,82,136,38,82,43,91,85,95,175,148,119,175,236,73,129,147,128,201,9,98,37,84,161,42,237,59,52,17,234,198,124,82,154,171,144,160,133,24,179,208,43,140,45,162,97,119,168,172,28,244,7,191,165,113,4,55,46,120,28,232,42,202,202,44,250,123,75,26,118,62,196,73,251,77,103,173,203,134,139,157,236,120,122,252,193,134,198,195,2,63,5,228,37,154,246,139,13,132,123,103,13,39,72,52,20,218,32,140,171,106,214,149,160,115,69,211,188,37,210,51,159,34,36,84,80,198,236,224,117,44,230,74,13,125,136,76,83,76,8,132,109,238,129,27,42,191,112,171,30,127,181,132,139,97,70,126,230,186,151,71,134,165,96,122,56,229,87,101,95,176,38,206,173,17,103,94,2,27,28,208,144,172,233,42,129,216,192,193,66,215,252,146,30,102,137,192,208,159,250,169,139,188,7,206,148,132,213,126,168,232,10,207,27,78,128,130,86,53,161,250,145,126,165,64,7,32,159,168,146,197,36,205,112,177,148,160,99,187,130,223,62,113,162,97,249,161,230,69,234,208,193,33,246,128,45,8,57,197,222,182,61,242,245,145,14,194,22,138,14,228,187,100,144,180,61,154,121,61,122,37,212,37,57,3,19,246,168,251,90,233,53,14,158,152,11,47,197,202,50,176,175,183,198,98,201,161,126,170,125,236,152,161,137,254,121,63,160,143,35,182,116,64,3,85,188,235,41,209,181,191,51,210,251,175,153,67,238,240,77,73,28,53,130,134,222,186,75,219,110,163,137,29,185,227,102,103,155,66,49,174,216,232,243,87,162,234,32,176,151,120,196,78,131,60,37,56,202,4,87,145,217,237,21,142,161,20,69,244,101,163,24,236,207,16,114,110,113,189,254,235,153,20,188,59,252,1,147,126,67,205,39,26,212,234,219,196,88,40,80,8,55,242,246,121,35,218,180,5,240,229,197,135,36,194,108,12,156,166,218,119,51,110,177,49,55,205,171,180,9,101,224,162,137,151,86,30,141,15,12,121,163,53,190,226,76,229,3,85,214,128,64,145,168,226,231,114,76,213,79,227,239,223,204,208,243,152,116,37,220,72,143,81,235,90,14,226,35,135,179,102,214,118,50,124,151,186,243,91,29,236,209,166,35,255,139,85,71,94,23,81,12,241,118,81,4,32,249,103,194,234,68,72,28,152,13,30,232,16,155,176,245,233,117,232,209,86,33,69,223,85,32,27,79,112,12,117,80,134,228,194,248,160,87,209,115,99,14,77,179,51,144,227,210,127,44,47,199,186,39,141,30,75,198,68,150,158,25,183,19,8,108,105,47,196,28,24,128,131,21,66,175,205,70,205,253,185,55,98,164,42,127,197,103,107,141,89,213,30,149,157,227,38,154,44,26,47,174,37,70,189,205,244,93,184,139,237,39,99,227,99,249,250,10,173,142,64,33,1,223,120,226,220,87,89,17,92,12,116,170,127,67,106,144,75,132,26,188,8,30,78,100,77,172,154,67,30,87,241,100,107,50,189,162,13,154,47,44,249,170,162,185,33,168,108,143,84,147,55,232,168,70,127,233,120,117,158,225,107,76,127,93,90,15,163,137,239,184,2,67,114,70,210,21,230,147,160,132,157,45,76,181,207,51,148,59,188,227,80,244,18,104,107,6,205,139,95,230,233,152,45,174,103,234,106,91,92,133,36,131,241,40,74,46,99,146,48,234,113,91,217,7,53,47,47,23,46,25,138,149,160,74,34,176,248,251,230,131,159,254,25,31,240,180,48,120,131,217,69,173,140,157,91,200,169,196,220,161,188,238,226,192,102,193,240,191,113,91,218,132,110,45,36,238,106,179,230,244,56,210,160,221,130,107,153,215,183,210,151,127,26,98,69,116,142,112,122,140,45,158,119,228,220,6,185,179,137,128,250,237,176,52,106,208,246,95,172,250,106,223,126,13,26,80,25,101,170,9,208,96,171,62,29,76,175,99,205,78,223,25,148,38,81,142,83,194,108,253,181,53,220,119,51,220,13,13,64,117,150,186,158,141,209,11,130,88,138,193,75,54,139,245,160,230,193,197,217,215,119,109,172,30,108,127,218,117,160,235,202,242,97,58,105,222,43,148,182,43,120,19,184,165,174,253,137,23,197,233,15,195,67,224,130,59,41,179,207,241,131,28,185,101,144,124,44,23,144,224,252,109,22,168,117,150,235,249,176,249,150,149,197,118,169,242,76,208,69,180,11,250,139,227,228,189,41,172,13,70,155,18,133,118,125,164,17,133,221,15,206,149,237,53,196,241,234,30,6,190,86,201,191,13,236,163,228,238,234,242,67,159,33,184,173,238,190,254,232,228,188,121,18,145,253,237,228,86,254,103,253,188,44,126,230,196,142,120,75,181,76,229,0,235,92,247,118,145,84,137,122,32,109,87,182,23,28,15,45,237,159,114,117,0,222,171,246,42,79,206,36,209,104,228,92,175,116,143,117,183,128,194,248,177,46,167,194,235,215,109,70,184,161,209,77,81,97,37,50,118,185,21,139,226,150,242,104,85,32,204,212,152,111,192,2,52,50,58,117,37,72,118,133,40,199,16,126,142,90,55,181,13,233,175,103,119,72,72,231,8,6,31,97,194,111,31,39,189,213,212,164,70,158,181,236,156,122,242,131,249,115,70,54,163,90,191,170,214,26,49,157,245,166,6,12,39,18,111,129,217,156,130,224,100,131,224,71,33,153,9,219,73,102,151,76,76,154,203,189,208,46,174,182,126,165,169,99,180,85,26,222,98,146,179,105,48,66,69,225,156,139,45,68,172,185,113,218,22,151,37,203,235,163,39,247,141,73,49,208,172,189,28,44,253,116,7,16,236,243,225,60,163,226,21,60,243,37,220,90,245,61,245,171,125,130,38,208,233,187,191,29,125,158,21,83,178,195,42,175,31,35,170,140,213,212,202,71,55,29,87,70,237,113,146,49,21,3,178,68,113,119,121,226,242,28,113,186,37,75,158,253,13,103,37,119,20,83,164,54,82,13,182,172,49,115,233,61,30,215,133,18,62,51,44,52,57,61,163,38,181,199,177,151,112,97,17,121,228,160,128,147,235,68,209,129,202,8,179,166,104,196,166,250,232,70,90,202,94,10,10,83,41,254,201,96,65,250,132,176,50,133,252,186,94,78,107,79,67,111,103,156,211,229,175,88,88,171,215,27,211,137,103,21,242,48,121,87,160,134,72,147,96,228,54,246,217,159,128,142,41,250,10,13,233,238,222,203,97,23,28,11,51,60,95,241,25,8,16,78,47,74,191,153,15,49,117,99,10,27,175,50,23,102,212,110,142,55,6,154,177,235,183,232,59,237,26,253,94,0,217,35,226,45,95,105,203,52,50,27,109,31,127,240,125,15,150,193,227,94,126,69,159,110,155,147,4,96,243,251,157,250,4,228,161,76,92,243,244,32,130,234,84,93,59,101,227,172,10,243,178,66,34,241,13,157,207,185,185,68,86,127,154,168,155,191,16,87,32,240,38,166,177,39,106,91,202,73,193,86,126,152,192,188,242,77,58,65,48,210,206,149,118,158,30,56,116,64,150,129,51,219,81,3,137,68,15,147,250,28,54,190,96,21,1,1,92,241,15,200,0,205,137,117,247,196,60,198,143,187,91,121,20,3,60,119,125,179,251,45,21,186,87,71,50,54,72,14,187,49,94,165,59,167,200,27,254,12,144,196,179,145,181,147,41,110,138,156,64,100,132,118,170,114,148,87,227,83,167,80,129,248,43,231,113,150,208,120,14,149,45,205,175,134,19,110,61,143,57,34,143,36,21,226,50,31,148,142,250,122,52,116,47,82,106,145,153,206,179,21,125,224,183,88,57,37,134,50,229,230,232,202,28,145,32,100,248,26,146,69,177,154,9,109,28,16,55,178,203,237,150,11,22,79,141,219,62,3,173,109,137,157,218,249,35,43,67,228,94,55,147,72,63,202,31,231,221,173,42,29,206,49,77,173,114,197,116,226,215,45,58,185,188,74,110,196,110,126,75,65,77,201,218,2,84,119,220,32,135,201,37,132,154,53,209,174,117,91,126,27,38,140,60,228,190,213,41,237,229,116,110,134,76,166,73,240,79,108,115,192,188,81,220,197,2,57,111,34,236,12,157,236,177,75,250,63,55,104,243,68,221,167,143,160,152,167,184,76,153,75,81,7,215,166,72,58,166,65,210,43,245,97,246,96,223,119,110,54,33,133,123,117,110,108,94,164,244,180,106,123,12,103,253,172,32,76,78,2,51,0,125,167,67,19,245,68,156,57,48,156,130,121,243,76,220,21,42,52,25,196,235,133,83,122,96,137,110,142,201,137,28,142,251,220,231,213,246,137,169,178,197,79,204,75,201,26,242,208,218,118,80,45,234,240,94,34,169,214,2,87,241,172,13,243,72,147,234,130,34,229,166,9,169,166,109,176,9,53,41,20,128,174,183,50,211,5,138,2,156,136,164,41,140,161,240,181,155,70,9,141,78,85,209,206,224,204,129,130,173,163,71,99,253,233,172,28,22,190,5,93,179,117,27,9,211,162,101,46,26,35,23,102,128,127,147,35,115,146,88,7,140,193,179,208,81,253,39,111,34,146,114,155,69,157,255,96,8,135,254,219,196,46,72,188,243,206,45,199,251,241,164,213,255,196,146,72,194,102,178,169,5,175,119,125,187,71,187,93,29,179,227,73,70,26,75,114,147,103,71,207,64,145,23,152,36,162,226,62,20,77,117,1,121,145,46,108,25,58,82,17,191,238,233,28,117,78,251,185,182,240,176,85,114,219,5,252,240,206,9,195,206,57,174,191,255,68,52,140,32,166,29,205,8,235,97,45,75,192,227,186,139,79,33,189,167,246,16,191,57,191,73,144,83,126,6,157,19,157,178,45,142,111,89,139,78,38,198,221,206,215,189,239,92,108,56,127,207,147,120,51,193,88,94,224,213,230,199,248,138,241,87,159,218,31,171,1,25,115,60,27,217,67,204,132,121,170,193,47,229,112,218,156,149,207,37,149,15,28,1,135,181,163,30,143,67,113,7,221,161,176,91,129,96,118,240,207,153,183,54,156,140,187,180,240,184,253,106,123,187,45,245,220,182,155,190,203,65,60,41,141,33,4,255,250,210,205,125,122,9,157,209,35,207,242,0,122,236,247,223,209,46,43,54,196,45,76,146,87,41,134,64,191,178,192,206,2,39,149,95,172,242,60,183,232,236,73,107,164,56,204,96,31,207,119,78,128,3,94,85,65,241,1,54,253,126,92,17,75,162,161,40,147,61,215,90,57,223,228,145,88,0,3,188,6,178,156,7,70,36,21,227,7,41,53,1,115,168,77,254,241,145,91,248,57,146,227,220,210,231,69,187,84,232,156,30,145,86,180,110,245,178,39,15,67,94,169,71,193,131,129,149,98,209,214,188,232,205,204,84,201,204,139,236,211,67,16,68,62,1,39,133,135,5,246,196,144,103,168,95,132,153,237,232,42,202,47,196,202,223,80,23,223,28,39,188,189,167,165,31,188,154,197,236,112,100,234,182,115,181,2,123,108,1,168,108,42,169,63,227,231,232,197,153,54,153,193,179,218,131,18,144,103,63,236,136,221,166,190,104,62,242,241,95,101,13,61,27,188,230,132,11,174,237,211,69,156,28,161,7,155,85,64,244,49,219,149,120,83,182,195,107,68,211,233,204,29,26,43,159,216,220,10,187,59,69,135,40,226,148,63,224,14,233,212,46,65,94,85,113,24,48,95,0,70,251,12,88,24,149,1,20,224,241,219,123,201,198,121,104,182,132,225,192,7,138,55,157,252,238,186,99,69,222,99,144,17,224,115,251,219,26,230,94,14,64,5,238,0,43,48,222,28,89,41,240,179,88,221,1,186,81,34,28,206,72,13,202,169,126,208,237,202,143,147,251,59,69,199,184,148,29,179,78,59,102,236,27,188,219,86,192,174,223,49,39,88,231,2,50,64,223,204,129,77,27,154,147,237,215,173,152,68,243,74,15,85,2,66,87,216,252,84,194,223,6,224,179,7,79,31,191,18,191,225,236,99,189,110,83,93,247,234,145,29,45,251,43,169,14,229,212,226,53,74,196,158,100,95,56,135,242,10,211,133,8,135,247,130,61,103,146,249,132,200,88,10,149,230,178,22,160,104,62,148,28,110,6,42,156,105,118,56,214,138,191,140,82,131,68,187,86,213,244,65,102,171,204,81,155,180,107,165,68,79,23,159,163,68,6,146,88,75,185,246,196,103,166,163,212,235,30,147,141,113,152,50,55,30,180,143,211,234,178,119,32,44,59,136,24,129,85,36,35,133,35,161,221,245,129,144,253,126,251,241,121,159,96,153,45,63,253,134,48,35,238,96,27,9,105,140,150,211,241,64,226,249,83,238,129,24,64,111,67,143,166,64,252,153,63,114,127,248,31,38,185,45,165,254,233,235,217,156,69,180,114,98,109,107,207,252,176,68,95,202,117,156,167,95,184,203,61,61,147,129,132,203,236,181,237,54,75,0,174,243,195,146,241,49,44,5,10,61,237,16,245,51,232,214,214,16,109,20,150,12,20,21,64,54,199,250,182,72,158,114,177,63,82,101,99,253,115,111,82,146,67,163,91,243,236,139,94,89,241,224,115,100,202,175,247,85,31,56,77,115,193,83,235,5,54,159,98,76,86,34,36,116,246,121,0,97,161,91,117,56,173,234,23,130,120,195,107,201,24,174,237,72,78,216,21,255,135,177,184,222,80,188,153,165,49,224,133,244,207,7,20,228,81,83,39,154,77,73,193,38,176,85,117,55,46,35,11,223,56,198,27,104,101,240,131,51,81,86,122,1,223,14,170,169,83,43,56,26,231,46,49,184,74,20,168,197,48,17,3,166,105,154,97,130,124,247,79,172,231,55,228,186,77,42,101,197,235,175,128,101,64,65,173,93,71,91,235,70,126,17,118,7,251,16,40,66,246,99,25,221,149,162,12,93,131,248,175,181,230,208,221,189,134,225,97,171,43,56,93,94,103,252,10,167,101,63,152,142,194,95,171,179,26,200,6,204,222,163,94,48,125,182,240,205,95,243,240,46,64,172,205,48,151,240,144,32,176,26,139,111,223,23,185,224,207,60,112,249,81,82,181,193,224,75,237,0,185,81,240,1,86,15,237,134,131,7,58,142,14,219,8,254,186,2,90,52,12,63,6,9,253,121,84,243,252,90,7,203,165,45,64,47,48,144,249,134,176,170,220,48,102,84,70,135,112,213,242,116,221,84,234,73,209,52,221,189,238,188,50,246,209,39,28,30,153,128,73,202,87,30,151,224,34,51,166,140,40,116,87,182,186,36,43,226,92,60,26,90,120,199,62,151,72,74,227,139,61,150,83,33,83,49,184,211,131,246,32,167,89,109,137,68,100,196,107,64,197,255,208,37,40,77,19,206,193,137,249,135,228,224,42,65,66,159,60,208,30,39,249,155,219,78,28,63,17,66,103,23,52,90,215,13,127,231,10,9,200,192,80,150,207,48,186,45,106,47,24,26,182,165,176,48,88,94,83,94,158,158,190,209,35,106,126,75,168,219,135,51,238,210,204,18,35,94,192,29,255,170,115,21,188,23,198,94,66,174,145,92,179,8,156,221,25,38,98,222,188,87,183,42,44,148,132,31,131,30,183,116,152,171,41,107,204,218,30,230,76,109,253,1,214,56,48,249,49,52,57,24,185,139,16,103,189,60,148,158,12,209,220,73,242,72,206,156,45,104,107,2,246,61,195,137,198,218,89,255,47,129,32,114,223,162,170,118,5,172,24,97,159,206,134,184,33,59,140,201,124,249,76,113,76,67,202,85,161,14,42,53,77,40,61,213,171,49,23,27,48,56,14,24,213,83,234,5,14,107,189,219,11,108,218,67,15,97,224,29,81,234,83,91,40,5,30,115,85,166,4,204,205,103,87,196,151,73,125,218,0,64,83,222,174,55,172,209,238,232,131,180,249,89,125,222,110,169,223,202,82,96,255,96,7,75,177,1,36,126,177,78,244,31,96,243,189,250,189,43,242,119,242,208,19,127,212,189,33,119,146,118,254,244,73,103,45,164,21,245,224,171,80,237,192,209,156,91,23,76,113,250,223,187,72,82,155,205,24,138,124,148,101,60,196,5,215,170,79,90,75,249,162,20,132,149,82,95,149,247,28,18,6,102,112,104,4,78,71,33,14,35,163,191,3,0,181,185,137,55,123,217,137,80,37,247,89,215,86,11,177,40,113,214,180,209,121,241,36,50,4,168,73,225,206,59,123,199,114,28,238,35,196,187,97,34,252,200,111,183,40,66,49,198,196,163,237,214,131,72,191,254,115,182,221,224,249,46,77,10,7,100,43,165,74,254,253,241,58,191,215,248,236,34,168,157,51,218,152,133,69,142,12,138,76,20,64,199,147,79,40,26,227,207,198,215,168,6,36,43,116,70,152,12,178,103,188,196,87,192,7,75,200,99,150,37,224,161,11,9,132,215,193,185,244,0,60,130,9,41,136,205,148,90,243,101,139,84,245,52,255,221,131,38,88,228,191,234,209,25,76,139,76,161,177,154,59,83,236,187,158,24,32,20,131,83,189,39,18,199,123,141,158,97,229,139,232,232,76,131,211,105,189,131,211,101,130,137,6,250,177,57,69,97,164,2,84,202,117,182,45,117,247,90,206,38,158,26,233,110,7,15,46,238,107,175,65,131,6,55,231,58,216,127,160,242,251,25,208,16,1,139,145,87,102,242,21,145,129,48,229,24,159,246,78,230,127,177,234,153,66,228,85,56,207,202,219,225,41,154,255,53,177,215,11,42,8,193,111,115,124,82,209,217,54,92,37,75,158,66,234,7,130,125,236,239,58,76,16,31,108,33,232,36,158,202,250,160,29,192,104,147,146,75,127,151,52,159,33,148,244,69,240,146,98,122,226,173,16,153,147,128,241,128,63,237,176,222,100,124,223,16,28,106,150,9,78,115,2,122,20,200,17,149,204,71,43,20,227,90,76,137,244,14,237,108,15,118,31,82,88,165,112,215,121,92,129,131,184,154,228,196,69,234,27,99,141,164,248,217,39,242,139,229,232,192,32,2,119,1,129,68,63,222,61,238,121,55,69,101,33,240,69,212,219,95,169,11,199,249,151,55,229,40,119,181,174,58,2,253,87,14,120,87,86,108,248,71,200,227,7,224,52,38,232,127,63,136,237,161,100,77,117,131,199,176,110,84,74,23,212,122,86,0,236,48,87,37,95,69,121,23,4,85,223,136,45,126,224,172,165,117,113,167,32,116,219,91,211,185,71,151,16,20,150,117,32,76,174,213,13,8,110,143,245,40,103,240,147,233,85,4,250,160,116,173,139,153,186,130,191,134,76,197,211,96,195,196,170,45,218,59,158,83,182,172,164,169,240,91,68,27,241,26,235,228,133,182,41,40,106,171,255,238,96,18,242,5,201,199,211,178,47,89,190,141,151,166,218,20,139,252,95,33,21,159,63,122,114,154,211,53,208,28,63,73,230,100,191,45,158,11,184,139,82,41,203,80,217,74,213,134,232,44,1,217,6,112,22,136,206,168,154,30,221,181,196,174,110,220,206,31,243,202,34,0,99,73,147,192,165,195,31,185,18,14,66,220,120,65,124,13,23,52,83,119,10,25,208,231,195,51,252,28,73,170,245,160,201,120,229,229,36,45,232,128,85,114,191,225,151,219,148,7,89,111,215,77,192,27,162,135,201,52,70,105,67,236,2,194,79,51,160,240,240,25,4,101,154,229,115,68,30,163,115,250,243,25,85,145,100,166,231,247,136,224,231,79,241,177,60,22,229,228,39,230,144,141,34,219,92,90,253,23,157,40,134,196,98,14,244,42,129,172,121,158,244,185,81,168,24,1,18,168,113,216,185,129,141,125,106,14,198,197,132,150,182,81,215,130,207,100,98,233,36,120,184,162,52,219,146,3,189,60,250,159,162,198,231,151,164,206,38,24,169,24,48,185,177,143,127,129,185,52,169,123,210,220,46,35,194,14,0,66,72,182,2,200,189,186,24,19,11,138,132,195,118,202,224,144,226,199,111,122,183,242,70,41,74,131,6,144,217,236,39,173,3,28,162,43,175,236,226,98,14,79,216,199,37,88,252,227,188,67,231,138,186,21,29,1,30,129,74,169,68,159,76,120,126,214,51,204,162,86,21,210,19,49,195,63,149,37,41,225,62,132,96,102,150,76,109,244,103,233,12,223,18,58,250,108,103,181,165,7,233,40,211,51,41,250,242,188,227,99,158,2,144,107,147,141,119,17,83,171,33,136,61,216,2,31,160,139,57,6,117,111,249,115,20,92,95,216,251,92,146,70,108,168,241,210,177,214,37,225,251,116,216,115,75,89,12,217,102,79,70,171,129,71,43,38,252,245,65,163,237,143,189,204,166,8,103,232,18,247,57,201,247,45,137,205,233,176,74,239,217,3,152,151,196,120,112,8,88,133,218,45,244,207,142,239,206,110,163,187,108,52,234,242,236,41,82,136,17,132,21,159,36,86,130,107,9,48,143,221,43,0,153,228,81,217,208,130,152,179,106,99,252,3,225,146,229,189,31,115,6,61,255,134,195,91,156,8,105,231,46,187,15,120,17,192,132,17,18,208,193,147,221,105,222,95,99,92,73,124,69,49,240,219,223,67,101,225,90,221,213,142,208,210,106,61,12,241,58,193,171,103,180,113,7,76,13,228,141,106,63,65,102,73,64,141,189,127,123,4,22,139,168,193,199,117,211,173,150,208,234,161,245,241,223,177,70,193,69,117,43,80,34,195,62,53,217,149,246,128,0,168,58,42,49,112,207,172,18,20,40,96,116,74,67,206,254,33,53,199,208,62,68,6,109,232,74,30,143,226,136,211,176,136,81,18,237,219,161,57,70,5,200,4,122,122,29,54,49,224,198,205,193,192,154,133,80,91,108,156,216,187,241,29,231,152,88,17,120,32,121,233,50,155,242,114,223,23,77,248,184,194,29,243,10,50,204,150,68,163,211,118,191,61,97,45,23,253,109,138,121,93,126,150,232,205,51,235,9,3,12,28,180,151,19,206,219,192,126,186,75,222,229,72,197,239,77,32,173,39,110,68,49,117,211,192,35,26,33,189,229,229,223,183,211,178,112,61,108,93,33,232,165,152,123,82,232,43,191,80,126,20,156,5,53,222,157,130,121,175,138,175,75,89,245,173,219,84,105,100,253,183,170,128,21,51,76,39,181,35,15,199,59,154,23,99,13,151,127,250,211,56,251,10,30,98,230,251,250,130,29,254,214,34,30,230,19,56,30,37,58,0,233,227,214,102,167,19,150,196,242,180,88,196,8,244,21,253,222,106,215,158,250,151,90,233,56,35,141,222,233,99,147,38,70,159,32,101,188,3,123,43,246,53,200,71,48,81,140,91,232,240,167,24,70,92,62,143,82,226,190,19,234,79,77,160,146,19,149,228,204,2,235,90,198,45,41,161,193,78,148,74,48,144,142,179,249,46,238,89,43,9,207,59,193,15,228,229,204,193,104,108,19,29,35,72,219,122,212,33,243,58,180,148,77,104,166,25,198,181,62,179,224,78,170,109,153,79,155,238,85,239,180,29,61,230,157,229,111,222,180,99,248,146,188,31,163,224,164,138,83,147,110,87,194,183,181,81,134,70,133,46,92,89,108,42,219,105,28,173,95,189,144,33,119,28,50,71,209,113,83,98,249,203,223,136,147,222,91,145,198,207,23,209,155,222,176,47,228,63,177,183,106,82,89,144,111,4,79,237,116,61,221,8,153,177,65,70,18,153,154,126,148,204,28,165,236,113,79,231,170,90,118,185,216,52,31,236,178,176,246,186,21,167,100,167,243,51,255,226,244,62,242,130,252,19,158,151,237,91,186,23,93,79,105,115,162,108,31,199,110,124,140,143,81,65,91,110,36,94,129,207,187,61,226,198,83,68,49,208,84,102,240,93,80,255,2,16,0,9,238,182,150,209,253,229,40,187,232,106,44,221,76,200,50,54,229,130,28,99,100,41,12,94,168,76,128,241,59,129,91,128,180,95,253,227,204,145,65,238,170,225,158,250,155,245,78,39,194,129,153,194,21,175,42,62,209,141,113,35,46,16,117,191,184,238,45,105,241,73,118,53,234,54,161,13,13,34,184,232,169,27,2,200,77,234,105,238,225,33,176,100,205,28,5,27,130,105,32,61,175,163,168,107,226,124,28,165,242,209,215,92,254,146,147,187,122,153,17,38,57,81,42,219,148,131,43,164,8,30,178,48,11,26,57,97,44,178,235,146,70,73,44,68,176,254,79,134,25,93,221,135,117,231,0,74,19,130,113,112,163,194,61,51,105,193,250,196,76,122,83,253,255,199,60,48,113,30,219,218,186,216,223,235,164,4,9,72,160,126,211,50,172,41,11,179,15,182,113,32,148,155,176,66,12,216,109,9,55,221,147,74,19,127,124,212,67,171,72,91,76,116,54,146,54,97,17,5,61,233,44,165,42,54,15,156,250,45,72,137,29,219,134,126,31,142,230,241,189,185,1,243,122,145,207,31,228,48,163,94,213,53,142,106,85,238,20,24,241,111,115,180,0,114,3,66,156,58,60,219,194,235,135,209,247,117,93,106,212,38,241,215,75,12,226,222,60,42,91,129,66,254,166,202,114,29,29,120,134,37,162,100,244,144,179,31,10,233,130,14,72,27,176,192,216,161,118,195,66,38,73,31,220,159,243,104,69,181,197,18,167,54,28,131,178,82,23,151,129,201,34,22,14,178,32,13,253,30,3,32,230,38,170,192,101,220,222,103,100,121,94,26,242,60,173,178,29,91,186,239,112,198,233,222,3,80,96,71,121,55,89,208,231,172,36,71,174,221,129,200,132,65,184,108,196,156,132,180,213,101,140,28,147,123,0,188,144,44,145,166,103,18,197,135,177,151,22,36,10,237,60,234,250,184,27,16,77,243,28,125,230,217,15,215,150,29,208,226,114,21,102,26,32,200,217,113,96,132,189,114,174,88,86,187,226,236,28,232,136,235,89,245,98,61,42,183,215,192,240,91,79,231,156,11,241,101,61,208,107,12,224,202,20,103,31,195,37,182,232,6,186,30,146,196,15,122,89,77,22,180,149,137,159,187,110,111,249,200,161,219,23,71,58,146,147,215,158,232,58,111,86,149,207,12,123,38,102,164,130,103,125,142,220,181,40,134,160,15,23,236,40,227,99,232,105,213,133,0,6,22,141,245,28,25,90,38,25,15,187,99,46,112,117,2,114,215,29,6,113,50,149,33,233,151,197,225,42,128,21,113,139,219,89,203,195,91,252,64,28,205,25,132,29,29,180,228,10,197,84,238,114,221,116,213,57,17,140,139,52,52,252,124,148,31,68,8,25,159,231,75,187,23,6,212,92,35,244,24,164,81,248,27,109,212,142,13,141,145,223,55,113,13,191,36,44,32,129,7,206,40,183,3,243,69,71,169,209,116,85,253,129,231,198,88,233,9,197,72,136,221,2,190,201,185,219,179,62,208,100,170,213,125,244,171,131,7,190,135,76,10,220,157,5,21,129,242,17,30,239,26,100,203,65,219,151,1,7,90,248,161,12,70,115,172,53,15,34,114,32,254,172,96,119,199,95,36,252,168,105,93,235,209,45,79,27,231,244,33,222,29,7,113,129,106,255,110,5,219,159,130,89,127,214,13,251,247,214,172,176,106,155,22,74,226,254,181,216,6,148,86,160,95,163,200,32,141,225,166,85,82,38,0,134,206,200,193,222,151,150,191,41,127,197,71,167,56,170,14,12,42,164,50,161,66,98,209,133,179,162,13,187,28,47,35,97,131,175,165,182,192,238,219,36,155,157,147,172,182,32,137,232,22,138,23,41,100,235,1,190,193,247,237,186,227,246,219,47,212,136,87,58,234,216,154,164,202,145,140,150,124,97,201,253,160,157,167,98,21,159,179,110,75,191,253,146,110,130,228,100,186,114,154,19,10,53,116,211,20,22,207,57,208,226,121,20,127,237,223,162,46,81,178,226,170,3,104,171,219,117,160,18,204,109,211,171,90,23,230,5,247,37,208,132,154,134,108,50,201,156,216,102,14,128,66,162,50,252,30,246,15,5,97,5,235,121,159,125,165,14,232,58,23,255,251,34,162,247,240,213,154,237,27,136,19,18,80,85,222,242,156,131,221,96,90,4,65,200,121,184,98,139,175,96,249,116,86,194,40,250,32,12,237,76,86,10,254,255,10,43,229,96,76,248,175,97,135,248,62,136,168,32,99,91,97,39,89,158,81,243,4,109,230,27,220,141,81,7,200,80,4,33,128,34,230,16,55,167,194,177,9,56,96,170,180,56,125,152,16,127,230,161,40,136,124,210,144,223,90,135,246,109,75,206,153,69,114,41,128,106,29,218,94,151,136,51,36,100,116,54,254,96,37,140,218,69,116,71,149,203,130,21,7,130,6,215,243,221,39,162,185,97,241,130,249,255,139,150,50,140,226,84,246,132,7,238,19,168,73,139,98,57,48,117,2,252,102,61,184,34,120,126,144,197,213,227,172,22,186,203,58,42,189,36,161,188,174,147,23,242,216,92,105,204,79,38,29,118,156,73,57,101,59,57,69,232,132,36,157,20,19,55,105,83,116,250,167,105,142,23,142,155,6,107,27,70,110,162,215,212,212,10,148,205,49,84,205,154,13,153,213,209,148,204,42,0,16,12,15,150,118,194,184,167,161,236,111,148,223,119,14,250,54,57,129,136,108,65,171,225,178,50,121,5,55,1,114,221,111,231,215,185,52,103,123,25,210,130,25,238,95,59,80,37,177,0,166,40,232,33,181,101,52,10,39,201,20,236,4,115,232,219,254,250,30,208,249,180,39,111,221,32,234,248,177,92,223,151,43,168,150,188,116,212,17,24,241,35,104,229,243,74,43,20,128,153,173,58,42,158,21,171,150,31,43,85,29,143,214,131,154,60,207,159,17,253,99,151,240,167,31,142,104,177,137,251,11,228,242,63,152,218,0,138,246,114,75,167,37,127,43,65,78,111,144,17,39,229,153,213,10,195,113,202,204,227,15,218,104,208,155,216,52,172,210,218,177,162,74,234,150,76,33,123,124,115,2,150,240,199,243,14,185,232,157,158,32,180,233,58,20,121,73,216,228,196,52,48,205,211,81,40,4,132,116,59,100,18,197,146,181,115,75,32,124,40,176,8,168,164,244,183,66,39,49,5,175,206,243,212,241,203,180,200,11,207,63,217,187,182,248,37,195,251,201,69,174,111,224,201,17,241,32,159,213,168,236,72,240,189,255,176,23,141,19,126,15,135,180,32,41,193,9,146,10,41,11,76,247,115,29,168,227,11,90,123,47,26,4,26,82,1,143,113,128,255,160,28,68,43,134,16,45,246,249,106,223,151,45,213,246,76,13,91,205,185,209,213,94,65,65,32,8,152,217,143,137,120,207,224,75,119,14,121,187,99,171,219,188,224,171,100,241,118,192,19,136,127,135,165,187,216,238,231,183,68,139,112,139,101,245,223,188,140,180,108,184,121,197,88,204,42,8,97,147,8,52,193,45,204,106,114,171,145,159,244,221,73,230,222,57,95,161,80,216,144,23,137,44,19,71,176,126,45,39,37,184,176,62,207,99,5,254,119,118,137,144,53,24,48,252,234,13,221,243,194,166,186,133,164,52,67,127,198,49,133,115,232,98,17,70,200,7,198,227,94,217,29,48,61,67,138,168,147,80,22,202,26,122,208,255,148,121,217,83,153,49,212,54,201,147,82,2,76,156,34,228,129,37,13,249,243,66,17,70,128,193,214,75,88,203,35,118,24,204,146,155,200,54,150,59,31,212,201,48,67,201,201,55,47,84,20,61,107,195,233,29,117,188,10,105,1,212,208,35,106,239,2,58,73,247,14,218,204,178,147,223,83,224,107,8,231,177,201,241,239,200,192,26,116,73,195,94,163,172,208,43,78,119,232,157,235,182,144,0,85,43,251,164,177,81,1,145,193,248,179,221,239,147,117,164,249,131,186,112,127,114,29,195,178,13,180,82,229,250,196,146,193,65,151,255,26,77,1,0,98,138,203,77,115,70,161,161,10,113,154,242,8,110,172,246,187,72,136,58,6,114,233,34,129,122,52,6,153,48,60,156,44,150,189,49,235,88,76,104,157,152,56,45,151,6,81,163,203,116,150,71,148,218,215,142,184,203,121,237,6,77,5,191,171,27,69,29,235,136,43,120,45,80,165,151,227,167,244,230,199,113,146,88,179,207,116,82,185,120,217,89,250,179,218,65,90,59,100,97,185,148,128,83,100,208,239,204,230,191,251,203,12,17,160,229,178,47,196,172,53,40,134,98,150,252,78,47,59,67,140,67,221,225,125,176,18,66,42,187,126,3,67,16,249,207,209,207,88,100,27,29,170,253,160,197,50,16,5,27,79,148,165,201,204,31,250,68,50,142,198,84,183,1,198,27,229,54,44,85,94,194,66,75,24,18,143,36,195,42,62,3,22,137,43,186,100,159,118,207,167,148,2,96,111,37,108,134,149,166,91,188,244,228,206,245,43,194,147,176,41,249,211,108,218,22,163,252,78,191,203,118,26,130,183,254,241,179,4,217,174,46,53,238,189,189,233,26,211,102,61,16,177,224,23,189,33,48,66,253,112,167,25,99,179,77,234,203,24,176,10,143,55,54,152,159,78,207,97,240,75,128,203,43,102,71,103,79,149,170,243,167,226,171,77,38,197,158,165,210,165,77,24,129,184,251,84,76,203,3,23,199,71,120,87,126,98,125,140,236,107,113,225,28,183,18,238,157,204,117,6,115,185,154,73,136,27,101,28,100,56,163,233,123,224,170,217,128,153,195,195,139,52,22,223,44,251,246,61,68,93,142,228,255,199,221,199,223,250,133,107,56,106,82,113,43,48,167,76,129,141,152,111,108,175,15,22,67,61,126,77,99,145,195,112,234,181,194,35,89,1,8,35,158,168,40,163,44,46,203,241,135,78,96,118,228,247,115,68,123,77,71,144,188,10,67,132,10,79,61,8,2,15,144,221,35,142,81,21,59,227,247,137,43,216,127,228,28,44,81,157,243,40,160,108,156,30,236,146,131,39,10,97,198,233,140,128,90,130,227,73,201,164,197,239,43,173,74,2,48,39,6,185,254,115,35,188,47,238,209,241,153,155,15,138,215,85,67,254,252,244,248,204,135,25,239,223,127,115,187,46,188,161,87,221,140,224,142,108,176,125,40,201,29,161,84,246,91,167,57,34,37,113,99,130,71,255,209,42,218,187,78,136,198,224,77,255,17,226,184,25,55,16,14,123,101,188,122,21,150,27,20,19,149,206,192,17,0,116,127,24,32,154,66,96,123,112,215,122,15,94,251,133,245,124,122,149,30,17,26,119,78,222,148,98,245,254,47,88,140,176,48,105,221,166,228,183,254,114,236,252,133,240,184,94,33,95,166,181,11,59,243,168,245,31,133,145,24,86,183,184,232,211,104,77,156,146,162,93,59,136,121,153,97,56,236,190,248,60,135,24,187,47,47,18,51,237,180,97,147,73,40,221,83,170,4,108,38,250,209,129,96,151,131,123,48,166,30,93,251,54,58,164,229,13,171,88,204,2,63,129,238,177,84,204,111,190,33,166,174,151,100,137,120,85,108,184,1,107,59,152,223,92,81,4,244,101,246,187,24,81,119,164,104,246,168,22,236,104,191,219,86,78,78,247,129,202,195,220,110,174,99,85,153,135,112,55,94,117,133,195,45,88,61,62,22,75,177,63,162,202,6,18,148,40,47,17,20,184,204,99,160,158,173,176,137,255,165,168,245,85,184,205,160,78,1,194,58,167,232,152,223,58,54,110,10,175,123,175,221,113,15,245,198,47,217,205,94,105,114,225,249,142,38,169,19,25,86,170,111,209,1,18,129,31,162,135,85,235,107,45,177,153,163,216,94,141,22,7,244,183,21,132,248,234,222,178,73,86,117,92,82,113,60,4,228,175,186,20,50,173,54,215,188,188,128,49,122,112,248,234,110,82,50,138,230,113,0,155,32,167,224,76,62,190,3,75,76,27,63,101,229,38,225,118,179,203,93,9,4,224,164,62,143,196,182,3,234,93,225,231,23,148,237,90,51,170,78,135,33,8,181,227,182,223,207,28,187,96,117,156,155,56,118,123,126,194,219,28,123,33,114,135,199,31,179,19,118,2,128,169,62,203,219,140,28,233,188,244,246,66,9,136,171,176,221,245,114,68,163,239,127,92,94,112,158,27,193,132,61,106,118,205,75,193,253,193,251,231,78,79,149,238,35,67,83,117,21,21,249,146,253,155,94,150,109,51,165,86,167,117,29,120,95,185,160,113,161,31,60,21,131,178,6,195,96,165,210,24,171,33,26,42,66,172,178,90,97,156,74,100,28,35,89,129,18,95,34,22,4,203,86,67,146,50,137,103,179,23,102,213,21,154,89,176,92,91,228,8,219,242,69,141,50,65,11,138,178,58,158,238,27,174,163,176,138,191,14,253,240,174,119,52,78,222,160,1,174,236,35,110,99,122,193,215,189,39,231,154,244,165,210,253,115,29,63,174,105,18,56,90,181,232,201,30,118,179,127,87,41,81,74,192,87,175,249,27,213,136,75,33,100,221,146,24,122,184,213,239,92,255,138,47,96,148,235,78,243,11,21,146,139,120,237,47,16,89,24,53,222,251,241,130,67,0,183,41,224,197,23,249,4,25,55,238,48,93,57,33,136,89,113,8,241,125,74,85,236,251,130,234,26,206,89,208,225,87,67,80,117,30,117,147,103,198,234,140,111,45,180,119,97,40,248,236,102,134,229,51,157,166,168,46,253,168,20,78,46,204,138,191,104,17,115,38,50,240,165,131,250,16,194,80,250,23,38,20,206,56,64,70,160,29,91,184,148,131,34,88,64,198,240,5,90,191,252,197,61,153,157,102,105,195,189,46,148,147,237,34,72,70,249,14,236,176,150,74,84,130,76,174,249,244,22,207,25,123,62,212,207,184,10,136,203,161,33,168,0,153,42,179,194,232,219,96,22,73,254,229,165,253,131,66,78,235,221,39,8,251,240,73,242,138,241,57,2,94,124,48,16,33,224,205,122,35,2,110,208,140,231,128,78,46,134,209,91,140,221,71,138,26,223,160,255,137,153,107,23,17,145,245,38,248,58,39,106,109,238,179,216,18,71,236,238,0,16,212,180,36,216,176,189,146,254,104,138,178,72,32,5,61,134,99,230,228,16,48,226,214,39,76,154,177,111,188,14,140,56,226,12,231,71,126,8,65,143,98,209,122,92,150,250,199,38,6,221,54,203,25,210,47,101,191,59,208,157,6,59,131,194,31,111,201,95,236,41,176,182,215,132,145,17,248,204,158,4,91,50,117,161,228,216,133,151,31,235,168,122,61,183,22,114,166,225,232,97,204,14,73,137,18,179,181,3,157,153,167,242,15,177,35,192,26,25,165,116,190,79,109,174,124,212,116,26,45,26,163,92,134,74,197,123,59,212,110,129,176,198,65,222,145,138,130,218,177,131,57,183,232,118,67,138,64,122,48,168,218,180,163,69,219,112,165,200,10,191,56,231,69,215,75,41,36,69,68,125,78,27,184,170,77,63,93,22,180,213,226,119,246,166,252,115,43,220,88,109,1,50,221,212,107,20,7,100,65,222,225,229,68,47,63,138,121,158,35,77,107,102,75,47,117,160,110,51,182,29,184,116,223,166,182,118,120,44,196,123,33,77,106,227,109,230,23,177,24,10,72,151,22,203,46,214,223,174,68,218,248,135,209,189,202,29,87,96,32,188,122,136,198,200,197,104,136,126,32,109,254,222,236,40,24,96,139,125,6,204,247,220,175,41,150,128,146,145,0,104,167,253,100,69,171,151,224,91,190,222,120,133,52,127,185,254,161,113,17,110,7,138,255,204,35,232,239,163,239,189,241,190,233,211,187,127,119,250,229,76,76,93,154,64,13,152,251,34,231,63,134,125,71,98,14,106,226,237,30,216,198,91,34,88,122,135,234,111,201,13,236,252,116,173,213,212,27,213,217,128,105,82,216,126,1,212,40,144,79,23,218,8,129,45,176,14,195,244,88,232,185,196,144,31,9,245,193,110,194,1,168,159,101,189,204,152,60,177,231,239,186,42,86,18,99,200,250,46,182,122,29,133,207,211,249,51,132,134,84,255,190,211,43,28,164,24,106,174,220,58,125,216,214,94,99,131,92,124,19,219,152,90,66,0,70,12,53,60,156,236,186,40,29,4,31,51,65,68,164,239,57,63,146,214,5,181,125,34,3,11,45,215,73,91,226,141,68,95,255,232,86,61,252,236,10,207,19,191,90,219,113,10,223,216,56,116,128,19,81,12,165,5,135,187,37,78,32,225,97,10,215,230,201,84,87,48,110,25,151,131,141,158,185,135,152,3,235,174,31,15,135,200,132,62,101,80,88,196,240,8,37,206,57,158,231,147,19,6,40,206,132,219,90,133,56,19,103,214,127,198,127,21,246,201,35,108,127,234,91,26,84,62,10,81,250,228,23,191,132,148,218,159,251,79,234,226,157,186,190,249,218,89,49,45,13,245,142,22,147,127,48,226,219,90,176,219,173,213,51,97,83,237,239,224,216,133,212,120,57,85,102,228,52,49,4,21,128,130,88,80,130,87,49,155,39,110,7,114,133,248,103,68,18,101,93,201,209,62,105,120,45,78,134,141,220,77,41,62,82,0,169,6,134,244,40,27,246,217,137,131,149,30,130,212,113,6,33,129,5,216,164,199,68,78,60,39,161,195,246,232,145,76,106,201,37,16,215,10,138,132,239,10,147,153,19,230,224,155,66,125,38,90,40,137,114,10,231,208,53,219,46,55,157,18,184,42,15,200,194,246,247,35,29,107,243,17,124,236,31,232,150,21,168,6,42,232,176,38,92,46,61,15,77,31,205,186,52,22,115,109,84,223,24,62,21,190,189,5,163,83,29,176,109,120,92,151,19,244,224,147,148,9,106,93,44,143,39,220,83,83,124,102,245,225,56,30,153,145,67,135,162,254,25,120,3,210,64,135,46,70,148,66,150,231,123,73,13,77,108,168,63,149,93,155,197,158,190,34,166,26,127,181,242,196,249,149,217,112,96,116,14,68,202,127,168,26,227,64,21,28,192,78,66,62,42,59,86,20,9,52,184,211,16,205,115,194,13,126,246,244,196,32,247,169,1,35,3,216,104,78,75,98,54,82,154,195,95,88,136,240,170,144,145,251,119,190,71,36,67,236,206,231,157,199,56,68,167,66,71,75,244,166,174,12,38,104,174,20,176,178,214,242,211,202,138,129,93,37,144,246,247,90,226,80,189,168,137,81,228,38,250,228,178,227,21,189,225,65,198,170,40,132,156,27,136,118,84,54,160,25,78,98,195,242,13,68,224,220,12,162,26,18,185,11,24,2,17,144,39,190,91,5,214,20,112,201,172,69,193,202,131,119,216,89,13,122,25,206,32,214,4,7,245,74,128,174,249,212,231,7,157,199,203,105,132,169,30,236,22,115,85,189,148,142,151,232,186,35,44,156,87,30,101,182,45,90,208,137,114,128,216,18,116,158,107,249,214,83,174,25,171,160,188,245,115,238,2,92,160,199,211,216,111,71,0,192,7,252,218,214,137,193,1,234,127,161,19,154,152,135,89,192,189,156,119,51,130,251,43,66,33,69,60,231,135,65,133,160,254,100,123,42,221,54,207,69,82,17,122,240,221,222,194,193,101,99,22,109,149,39,10,184,175,207,132,117,186,142,85,110,124,114,40,140,3,211,249,206,107,174,129,55,101,59,171,26,20,240,89,159,173,198,150,9,61,240,225,97,106,208,95,213,178,132,125,189,229,145,32,110,211,56,94,250,248,39,47,217,140,93,50,185,246,87,74,18,109,105,110,161,209,28,140,213,51,94,23,53,114,37,35,10,16,84,84,148,63,198,38,211,252,59,92,150,176,22,43,4,49,113,117,196,211,86,52,78,55,115,138,122,85,97,71,66,172,252,245,91,82,122,187,228,161,232,158,182,35,116,35,233,76,70,212,217,230,81,53,162,49,227,110,129,233,175,2,85,237,29,242,9,139,69,52,193,136,60,253,197,129,31,133,89,21,116,254,201,42,68,7,202,158,35,43,209,210,80,141,230,174,45,97,64,5,123,177,255,222,115,65,5,8,6,121,132,118,56,41,116,133,58,165,209,92,100,57,175,6,205,224,12,126,73,212,220,242,66,47,83,168,53,143,167,133,89,111,15,62,82,1,29,137,94,37,117,128,171,211,150,63,27,66,36,68,250,191,68,21,249,155,43,111,166,86,126,97,17,108,152,141,251,104,163,231,14,87,145,229,189,21,32,210,138,191,34,185,170,212,123,198,84,147,104,116,2,48,113,27,5,230,248,108,24,233,198,78,153,2,176,73,36,118,167,222,195,148,115,61,94,136,197,216,215,139,253,91,218,225,49,164,22,187,8,119,207,212,229,58,235,147,7,88,169,143,40,110,215,11,157,247,42,178,80,98,55,62,81,198,181,52,51,150,29,32,246,185,49,228,205,76,161,56,25,11,195,91,50,52,133,23,99,177,71,123,5,186,58,122,41,247,87,253,163,170,232,174,41,43,73,96,28,168,246,155,247,81,106,163,246,173,255,90,185,86,168,37,132,196,15,101,114,163,98,15,73,145,48,255,74,105,23,63,142,138,5,75,77,157,158,53,230,109,225,1,182,76,137,85,241,41,22,59,44,245,6,69,193,93,212,22,136,249,26,253,204,111,36,248,10,96,122,174,121,99,121,230,201,187,15,191,191,25,9,127,151,71,148,43,252,228,147,222,52,168,114,18,89,215,202,181,214,170,197,245,143,237,66,221,249,55,117,173,152,28,87,3,143,84,41,220,11,68,142,62,54,89,193,53,79,40,126,235,125,114,2,208,249,165,207,78,9,199,189,86,74,204,24,60,122,150,18,115,204,138,157,153,67,138,189,136,73,6,2,79,35,225,113,101,143,190,221,101,46,11,243,194,177,139,209,56,36,161,226,0,172,132,101,45,239,255,46,46,130,68,184,176,248,141,129,219,16,180,206,94,113,134,169,163,179,131,70,211,20,127,153,43,241,70,25,20,240,21,62,30,226,181,165,33,93,74,73,130,76,167,233,90,59,221,112,103,91,44,95,74,124,209,222,55,255,36,99,199,39,138,9,136,74,198,113,186,6,183,100,178,175,120,167,154,193,134,159,60,206,191,196,140,152,44,46,124,108,122,211,166,144,144,150,109,181,6,10,206,247,124,20,239,183,46,115,44,141,128,167,131,72,110,32,218,92,247,237,192,95,77,120,194,60,229,34,79,220,88,161,53,170,64,160,55,142,77,233,80,69,240,106,153,10,82,241,169,225,240,104,255,241,37,184,217,164,244,149,10,6,250,117,81,28,141,152,73,130,138,194,161,49,40,149,129,220,152,236,227,143,39,78,45,118,113,53,62,153,5,78,119,145,123,51,214,188,25,238,229,52,150,31,64,253,158,104,56,59,189,170,75,13,201,12,253,23,64,96,107,23,139,196,96,90,55,109,51,21,25,249,247,70,117,40,93,58,2,179,165,251,127,125,136,205,106,61,252,192,68,112,64,112,100,171,224,192,131,249,94,32,97,145,79,202,42,152,187,198,240,28,42,142,172,188,168,123,157,182,102,211,102,136,14,180,0,16,211,214,163,77,156,235,42,193,112,30,226,112,1,212,143,54,221,10,253,11,95,107,45,112,150,232,36,39,73,131,10,3,221,234,180,202,210,191,43,63,127,239,133,181,36,138,115,254,51,120,94,206,69,116,74,9,61,105,104,215,139,99,102,95,51,236,240,111,157,211,43,41,234,5,124,17,11,175,78,114,190,246,151,89,99,231,234,78,117,69,102,178,69,211,204,249,99,91,127,171,56,144,146,130,178,156,104,28,76,157,24,28,245,99,149,176,248,202,224,153,237,131,197,122,168,65,233,248,112,159,217,19,125,185,137,25,103,9,114,84,220,88,127,192,75,38,80,72,198,71,230,14,130,97,73,64,131,3,242,197,101,119,53,57,204,22,187,165,163,204,69,72,106,53,218,9,220,35,65,202,231,179,195,224,37,11,180,221,142,175,252,147,52,19,249,59,102,66,28,36,100,30,234,137,236,219,3,48,204,49,249,60,74,209,212,89,166,86,12,247,70,77,26,73,153,98,162,65,13,111,238,235,28,117,99,203,252,60,204,110,177,27,161,208,0,16,11,176,235,240,250,231,141,237,60,124,10,98,3,28,185,31,35,236,51,100,100,70,122,217,129,39,211,229,218,243,173,243,179,98,172,29,48,253,245,237,107,189,87,92,64,222,179,191,198,87,36,212,79,191,12,240,1,113,209,103,42,172,107,63,59,162,95,106,132,66,39,66,52,67,36,199,225,74,225,69,67,176,83,0,214,132,113,95,107,92,86,14,241,251,16,210,255,142,70,96,171,102,137,170,235,78,232,201,240,170,25,230,114,204,69,75,94,16,157,223,16,135,9,24,197,97,51,130,154,69,143,187,196,152,245,155,171,97,197,47,140,164,9,217,3,66,74,93,242,151,156,68,172,195,45,188,193,43,76,16,36,159,238,121,188,147,90,216,245,199,160,123,50,23,177,190,14,2,152,130,26,155,222,157,67,107,236,174,146,255,57,38,236,62,225,139,51,87,212,207,219,93,32,186,194,50,220,124,116,178,168,88,47,219,236,51,50,79,47,55,134,203,190,63,16,206,26,135,45,255,135,91,137,61,234,184,66,200,233,163,19,222,86,38,79,187,137,84,45,124,210,83,34,193,206,251,63,77,105,8,96,103,82,17,134,21,24,117,223,49,196,109,146,235,232,25,126,156,195,143,41,45,69,9,225,36,1,164,242,168,212,101,166,125,184,178,218,69,25,248,203,140,100,244,157,239,40,129,236,241,221,222,174,209,60,248,115,234,43,83,132,3,159,82,103,62,216,64,245,49,39,66,196,171,178,202,161,206,144,230,154,1,100,4,41,195,225,239,203,189,138,204,84,47,153,65,107,7,116,210,108,56,64,188,72,144,196,64,98,162,9,226,100,59,34,246,86,201,226,228,187,31,58,94,182,229,14,59,2,216,246,204,235,221,106,174,54,13,17,177,160,236,26,112,101,71,21,236,63,180,89,213,17,2,252,211,164,249,32,173,140,101,26,119,64,127,179,235,151,87,245,26,47,164,237,178,245,151,227,35,139,227,13,223,65,254,238,62,154,207,107,195,45,98,53,131,247,155,200,86,45,81,24,153,233,97,96,113,103,146,57,42,143,198,81,245,250,143,87,0,210,9,241,83,178,189,100,243,212,110,105,17,79,115,235,185,200,187,82,150,163,47,31,248,201,107,245,157,82,30,36,31,153,148,87,18,139,71,141,224,53,18,65,181,73,8,205,26,90,161,72,184,28,1,110,226,178,92,132,164,90,64,101,5,167,228,242,132,151,52,90,106,168,152,28,5,33,230,166,222,80,144,201,87,52,213,30,198,63,36,116,205,123,190,212,53,123,3,125,147,29,244,25,237,130,189,115,10,78,105,210,62,49,89,145,89,93,144,169,82,110,61,226,203,139,3,239,252,140,69,191,56,86,85,106,226,127,214,14,22,82,184,7,83,72,57,136,200,187,35,123,89,138,123,109,207,109,94,33,239,42,37,80,56,94,85,234,16,166,83,192,112,182,133,228,21,3,2,41,127,82,22,152,114,12,207,186,120,253,179,32,177,238,200,103,44,98,140,134,138,84,160,174,81,115,194,159,118,205,42,15,118,83,231,53,230,167,102,205,27,129,13,165,153,215,163,134,200,219,36,145,25,195,135,53,166,26,3,154,218,161,183,143,119,197,165,142,24,55,116,13,209,185,212,81,20,159,207,53,216,86,244,147,78,113,232,213,186,112,243,220,7,200,132,27,48,27,174,154,25,4,169,66,39,95,180,223,46,36,204,105,155,248,56,15,176,253,179,182,41,69,41,199,31,8,45,174,44,243,95,219,26,195,195,199,190,233,122,86,242,220,202,96,213,67,124,229,186,6,246,132,41,179,228,153,150,171,80,26,116,68,135,27,182,98,162,214,207,176,210,8,68,74,114,111,186,0,29,218,206,119,117,147,210,200,191,0,143,107,79,222,17,81,140,30,191,57,68,57,201,88,88,228,118,116,70,93,122,79,171,18,123,154,79,233,45,89,112,139,98,50,52,139,153,240,155,176,31,64,179,28,76,69,197,116,66,188,120,248,47,210,153,112,44,229,110,13,234,78,248,181,2,251,104,236,145,27,85,171,0,81,150,253,80,97,220,95,90,197,253,156,89,40,170,81,239,32,243,179,5,51,18,134,80,32,2,33,221,104,15,152,13,134,235,238,104,35,140,147,206,212,5,57,27,198,75,153,8,154,236,181,240,19,173,232,38,250,200,208,148,248,242,232,32,2,230,32,199,103,140,253,179,18,99,63,194,178,129,52,99,59,87,205,133,230,85,60,44,234,134,93,107,201,75,210,38,145,197,175,215,167,37,222,84,142,8,29,121,69,10,205,96,128,191,157,20,44,218,40,242,5,179,73,236,184,74,60,54,230,224,114,91,177,254,52,60,89,143,63,17,76,97,241,44,53,45,127,245,64,110,57,248,140,12,42,220,98,111,178,164,16,145,58,99,166,236,200,203,23,38,49,63,224,87,43,95,37,98,214,36,212,137,86,64,203,85,89,107,16,191,215,201,212,102,130,218,250,203,129,44,255,52,170,120,231,101,101,96,84,81,226,151,234,111,33,86,120,44,139,22,70,28,125,125,98,200,8,154,96,115,104,205,51,151,5,238,238,186,238,38,220,31,180,157,228,215,100,58,165,95,185,252,177,226,235,141,195,134,148,218,121,173,150,70,54,233,250,138,86,145,21,199,92,16,69,196,89,155,182,194,17,216,198,136,63,122,143,241,191,231,48,22,129,15,212,73,122,42,43,171,237,102,200,87,60,186,64,14,150,207,223,16,145,55,12,5,42,202,4,176,31,179,47,122,141,84,108,45,214,90,212,40,201,193,22,60,252,65,123,18,14,158,80,167,131,37,145,71,9,148,15,84,162,97,141,173,84,92,213,76,138,109,104,237,94,155,223,18,43,171,146,90,13,7,219,31,152,248,209,168,49,64,192,249,32,25,202,233,198,147,129,198,174,131,160,244,137,196,222,133,51,190,111,113,197,54,13,30,147,135,54,20,241,230,244,104,225,117,129,194,70,232,107,35,156,168,189,219,134,130,39,26,251,111,110,247,191,208,252,213,133,217,39,17,158,238,76,11,223,60,51,175,53,251,165,247,126,44,73,161,151,167,114,18,248,149,73,182,198,68,89,26,182,175,244,26,71,133,44,117,104,254,49,41,214,187,227,125,93,134,36,56,149,234,121,148,91,65,103,96,10,117,162,130,44,247,50,11,61,81,249,136,53,174,34,220,155,10,1,205,138,213,213,119,72,200,251,180,43,113,120,52,85,165,36,226,168,10,245,181,90,220,233,208,19,118,107,43,123,216,146,141,197,106,10,146,44,230,198,252,5,252,44,189,219,134,26,41,40,141,111,74,235,145,98,242,238,16,88,105,254,177,212,1,113,169,200,188,90,241,45,137,124,194,22,208,175,45,244,226,230,211,184,113,169,8,18,162,214,161,35,128,111,153,169,18,187,251,107,245,171,169,182,96,35,180,46,115,39,29,1,180,171,122,212,162,123,84,7,174,245,14,222,157,250,146,107,116,175,135,188,97,212,90,172,144,206,111,148,124,181,202,32,206,112,226,232,183,94,195,236,153,230,206,230,62,31,55,192,231,16,34,202,137,111,200,174,151,123,86,133,198,118,109,26,30,39,43,126,173,14,63,126,241,25,177,98,135,149,184,143,164,203,50,232,19,24,75,54,188,140,194,134,153,73,126,19,205,66,4,87,250,29,21,209,18,76,234,117,129,10,170,203,1,113,253,217,53,68,157,192,189,181,24,31,235,103,81,118,168,117,148,64,15,60,176,223,210,239,53,110,0,148,222,72,53,128,183,216,58,31,106,244,188,41,23,246,52,178,34,233,188,250,198,173,249,97,27,199,70,179,30,51,29,179,13,49,101,168,71,40,180,236,98,190,71,121,52,161,71,222,81,47,114,223,185,239,242,203,244,99,43,44,68,249,124,75,120,162,185,117,148,28,122,229,11,85,80,148,92,140,16,120,99,74,90,61,194,38,130,236,18,5,15,37,131,135,39,251,175,31,253,240,154,22,173,229,161,146,101,253,94,80,204,145,176,78,39,131,7,91,184,64,107,96,116,204,131,197,63,127,75,205,143,33,198,154,196,93,77,109,166,51,123,207,132,221,106,139,213,168,68,220,80,47,121,201,184,69,195,200,200,143,101,179,91,165,96,52,113,0,73,134,4,39,154,19,233,104,229,131,136,133,16,109,120,200,114,205,79,177,10,33,247,125,195,153,158,64,65,204,38,126,223,155,71,29,135,224,32,157,178,134,216,152,194,240,172,235,160,187,101,151,188,227,123,206,204,176,56,203,61,94,26,236,240,120,124,93,206,182,167,189,79,158,15,77,157,27,170,2,96,181,67,90,118,22,28,109,214,184,65,56,18,109,177,109,131,225,24,159,230,250,121,97,9,192,11,164,174,187,77,84,195,134,252,170,7,245,94,111,130,74,23,175,202,63,241,148,17,223,226,175,25,29,218,171,230,246,188,40,11,44,122,241,195,219,216,177,201,186,112,185,207,253,152,176,60,193,131,205,20,221,112,42,60,17,202,13,211,218,124,30,63,70,92,241,133,95,64,148,0,238,92,185,148,149,55,122,2,32,44,131,61,240,72,162,160,29,177,61,41,32,57,61,73,220,255,195,27,141,128,94,30,111,173,19,243,122,134,78,90,63,93,42,255,184,245,21,12,99,80,95,245,5,230,85,18,175,244,160,111,208,216,190,137,7,59,168,172,16,94,0,156,205,10,145,80,231,12,48,194,43,40,59,185,124,3,230,131,19,178,214,142,153,108,235,122,237,27,36,32,114,210,182,36,45,211,4,208,192,72,107,226,177,39,117,97,205,219,103,246,6,182,153,255,125,247,131,99,48,213,31,82,125,150,121,137,116,178,22,238,45,161,54,167,155,72,57,205,25,122,214,132,227,183,72,202,87,208,87,88,31,190,99,176,166,203,162,205,145,135,11,154,33,84,249,2,63,210,112,226,211,250,49,72,108,158,44,3,128,158,173,110,252,42,50,23,156,91,68,27,231,235,182,204,35,135,13,102,182,144,250,21,218,207,16,45,230,115,4,197,105,189,143,63,27,132,204,217,127,244,13,224,66,66,240,125,122,250,138,151,144,74,202,118,97,56,78,156,251,84,218,132,47,64,3,74,214,72,29,69,162,120,49,184,112,183,36,90,66,226,12,101,154,61,209,146,107,214,95,218,96,195,181,73,12,207,111,164,39,71,100,240,115,157,213,34,28,48,174,44,212,189,25,179,37,131,34,170,213,2,130,250,74,62,75,46,39,27,179,247,177,36,139,169,141,157,209,184,122,56,180,53,94,67,101,9,57,72,77,254,106,94,60,198,202,90,5,255,203,29,89,197,137,162,208,210,138,133,98,206,92,91,165,7,252,32,115,107,235,65,188,121,69,107,67,123,95,192,248,151,107,175,3,84,4,222,44,119,229,17,13,139,161,149,232,116,110,204,87,183,97,53,23,143,83,154,107,95,14,222,221,232,77,3,48,159,236,158,3,23,227,173,115,195,86,60,29,127,241,200,58,243,8,188,126,131,58,166,222,200,101,151,15,137,10,89,250,194,124,11,168,237,160,166,135,201,65,176,16,131,82,129,93,9,124,146,206,83,163,119,97,110,64,124,171,209,175,239,251,52,141,170,129,230,10,75,234,192,132,206,154,193,146,73,139,190,237,122,108,47,209,20,103,141,88,163,100,240,249,29,22,21,29,166,73,207,172,203,46,228,63,97,25,102,109,88,180,63,170,130,232,13,33,23,241,222,96,154,52,61,132,220,175,122,90,86,137,23,2,208,103,168,162,133,227,180,210,192,70,246,131,100,118,211,223,169,159,89,141,224,74,195,129,186,215,16,99,219,102,196,76,148,78,27,215,191,193,201,102,98,245,54,26,207,183,162,168,172,37,165,62,20,153,56,172,139,230,52,10,40,143,119,39,131,96,178,178,228,203,253,44,34,155,36,62,187,8,181,59,239,201,69,59,148,164,143,191,160,128,24,7,138,155,165,19,73,89,245,214,33,116,40,223,243,91,246,168,246,121,57,196,93,93,6,196,226,86,205,113,110,7,234,104,41,6,204,144,91,140,196,230,131,199,217,172,7,130,160,78,236,23,212,26,1,167,32,133,222,147,201,255,14,61,0,14,6,172,126,141,180,73,6,228,63,160,90,154,8,209,24,22,11,93,17,82,221,0,146,110,234,143,217,162,171,71,127,115,184,196,243,168,243,122,68,54,44,43,147,94,74,211,88,181,149,201,117,25,164,227,144,45,207,20,51,15,114,164,101,13,142,133,217,222,211,92,127,139,247,158,115,14,118,59,116,3,217,177,226,227,102,33,46,190,118,236,174,183,42,63,191,166,159,174,252,215,121,3,80,57,199,51,99,216,80,4,208,108,48,141,24,206,29,57,228,118,199,163,59,199,81,129,13,214,206,12,197,19,8,28,66,193,92,188,27,38,39,8,213,194,19,186,103,181,53,127,183,200,103,245,55,184,87,112,152,104,48,55,21,172,82,140,75,102,21,5,38,145,86,50,144,122,150,153,217,120,13,81,200,19,204,47,167,113,211,110,79,56,239,56,107,132,48,228,230,88,87,38,196,156,35,219,109,241,115,50,136,170,180,60,211,240,18,214,144,104,216,58,225,124,247,24,11,179,169,86,216,34,87,151,25,142,82,104,234,96,197,143,18,238,65,161,150,219,240,219,136,129,36,254,4,211,227,165,48,94,139,160,231,208,141,183,57,234,25,129,167,120,54,249,153,166,87,21,91,128,215,23,166,30,35,203,188,132,60,47,194,13,237,183,225,200,56,91,220,236,208,204,46,78,112,2,239,230,21,176,102,172,63,205,212,153,136,168,186,85,226,238,214,80,120,181,138,89,63,172,14,229,48,171,17,23,248,168,125,150,224,86,231,181,189,83,177,179,207,74,250,198,177,33,195,168,219,85,123,171,13,88,165,117,144,89,43,194,165,185,142,253,181,93,193,28,76,119,91,194,193,228,54,119,73,9,161,75,214,125,123,124,170,52,42,156,213,13,22,140,56,7,14,35,5,137,164,223,235,188,128,192,219,54,121,125,77,98,44,53,185,86,137,201,84,88,0,47,89,81,25,162,175,162,20,193,119,190,65,94,223,51,231,27,26,84,7,43,172,62,197,173,189,77,79,147,214,175,85,92,70,84,254,140,222,132,35,88,125,20,238,176,58,81,51,164,20,115,3,190,132,52,123,251,8,101,13,52,144,111,229,76,73,239,1,209,110,98,92,141,98,216,59,34,216,53,15,254,201,144,189,81,165,186,254,160,119,129,246,141,226,19,198,177,154,48,120,236,133,58,5,157,210,47,58,137,183,127,14,95,130,153,11,245,158,222,192,36,82,183,13,207,81,231,145,234,196,45,59,154,240,130,9,149,68,139,92,30,228,77,112,138,180,56,196,149,174,58,83,144,24,49,18,123,64,112,186,97,221,112,89,97,124,50,46,130,77,98,239,40,145,177,123,16,48,210,0,194,66,179,110,56,17,214,33,148,76,146,239,144,160,120,198,13,8,182,163,57,211,125,214,47,71,78,31,146,243,184,138,84,59,214,200,246,251,63,132,154,183,5,137,25,159,251,219,113,81,49,202,226,165,164,26,123,99,134,242,36,129,138,137,122,81,146,21,181,75,9,64,129,174,236,212,208,247,200,217,182,255,170,33,234,134,46,147,237,222,180,71,84,44,81,219,92,219,154,116,61,55,32,20,174,151,216,27,207,81,229,210,92,141,15,220,232,28,92,226,56,34,5,195,192,16,27,9,103,168,57,91,197,126,75,6,138,132,19,27,197,87,83,220,198,150,119,150,241,198,213,76,99,59,112,135,207,155,29,20,133,246,231,136,165,230,69,43,239,172,241,158,145,206,120,100,55,209,213,90,38,37,152,124,244,199,41,43,89,107,144,216,119,215,98,73,241,116,219,226,104,50,246,10,246,229,131,239,59,141,242,10,66,92,243,239,244,62,231,2,214,244,40,214,61,199,125,140,3,49,169,2,210,83,105,54,160,82,50,35,100,118,124,138,166,31,38,167,115,203,152,114,149,79,154,46,167,111,22,30,201,152,122,255,108,147,217,132,142,244,96,27,129,104,187,93,136,119,235,213,142,18,220,31,189,121,181,99,224,154,202,51,47,107,152,233,254,152,106,37,19,208,77,29,119,76,249,246,81,220,108,169,45,24,19,99,53,143,167,177,115,106,141,225,53,91,195,11,66,19,243,175,29,242,166,208,138,214,209,215,176,190,162,11,52,211,85,97,26,86,193,35,89,142,64,230,0,59,138,145,32,56,150,28,106,113,66,170,113,157,158,27,77,90,152,155,246,38,91,100,124,159,165,9,118,160,135,233,156,243,218,102,95,158,0,144,150,249,143,18,51,63,193,169,18,152,142,128,141,199,141,222,153,58,77,115,241,164,175,16,193,176,227,125,124,190,167,58,113,4,242,195,8,172,146,84,170,11,74,20,72,253,166,53,86,134,255,195,147,42,27,253,195,145,29,0,13,163,56,200,244,22,71,238,4,131,255,49,207,152,154,103,45,38,110,127,121,158,67,109,249,118,27,119,195,225,52,77,147,176,132,49,194,206,151,145,134,44,224,77,57,41,199,212,50,49,192,155,30,147,143,216,171,62,235,13,185,24,130,109,85,41,186,6,22,149,41,140,102,185,155,187,190,99,125,210,155,180,191,231,160,200,109,253,136,26,50,51,41,206,147,90,137,233,16,151,151,205,47,225,100,230,254,212,106,43,26,141,140,15,68,151,134,210,52,216,212,38,226,29,178,207,150,241,134,106,41,4,148,8,206,192,113,207,205,56,163,237,235,190,62,213,234,208,142,136,12,234,29,21,229,10,162,78,100,11,196,126,230,253,45,71,55,74,37,170,140,83,164,86,21,157,247,104,208,115,140,106,91,22,187,75,75,31,120,167,48,224,144,193,83,27,254,190,114,90,14,198,30,208,203,8,200,155,232,140,226,225,176,178,41,222,48,253,185,189,180,51,58,70,37,233,158,0,219,60,175,126,209,198,34,36,195,49,219,170,186,59,114,204,231,239,253,164,56,120,152,35,73,164,206,99,17,53,128,203,148,196,193,70,160,121,81,41,210,180,189,148,8,166,52,138,129,54,58,246,24,199,7,185,182,188,48,225,36,191,171,96,249,127,24,128,223,53,231,60,107,229,253,131,85,207,50,229,17,193,115,136,162,133,55,132,223,59,40,30,33,96,30,254,108,249,67,34,229,187,166,118,218,153,223,5,148,130,38,198,161,224,201,140,232,183,83,184,106,184,149,202,69,2,189,122,254,6,65,215,242,164,183,126,120,129,130,143,66,252,205,175,166,205,25,54,16,182,88,137,35,212,76,112,247,220,84,93,44,8,73,209,139,214,183,96,175,194,106,215,126,153,187,206,32,59,68,115,228,138,197,18,167,121,58,117,90,224,41,196,139,74,147,130,87,128,190,88,150,199,78,187,163,158,21,231,154,57,74,130,191,146,94,67,75,69,217,32,178,193,116,62,69,131,189,250,57,185,129,58,108,120,154,45,153,99,128,37,139,82,135,167,151,31,52,167,71,101,153,165,92,107,255,19,192,91,2,153,211,222,47,230,244,46,159,103,201,238,108,7,186,108,192,197,97,138,247,150,49,100,164,61,186,95,216,202,226,4,164,232,97,19,124,169,157,205,209,184,139,16,177,147,175,7,232,66,149,70,174,73,214,125,116,234,250,77,224,58,105,69,204,151,206,228,224,230,222,51,120,96,249,138,230,69,37,16,251,220,250,44,137,61,59,102,56,209,64,82,176,164,131,104,126,155,115,167,203,184,3,201,107,132,32,135,90,149,248,106,35,189,86,167,100,158,55,134,209,206,90,132,66,194,95,102,216,224,164,144,131,217,189,233,96,198,87,119,216,195,153,150,178,243,170,8,89,186,83,207,2,159,118,116,45,103,115,40,33,11,220,98,126,199,167,44,29,193,54,74,214,102,233,237,235,207,24,156,90,123,214,66,46,83,64,40,224,90,193,26,235,141,225,231,180,208,17,2,118,92,96,63,237,217,209,27,110,35,238,238,43,199,136,197,52,162,252,62,253,112,213,253,77,74,219,153,43,111,153,53,28,225,58,24,139,248,156,120,167,195,27,161,70,207,9,170,74,49,101,215,90,92,121,179,152,86,45,28,238,120,21,176,189,247,167,6,193,115,67,78,37,123,44,74,185,200,100,30,136,251,145,74,221,61,83,89,40,109,246,153,233,192,115,240,252,70,6,6,104,196,239,221,17,8,24,174,180,13,25,78,21,10,241,49,184,189,188,204,29,116,51,74,171,39,75,226,209,251,138,203,121,134,77,215,112,156,239,149,130,87,177,127,222,35,242,193,22,96,176,186,237,138,174,118,239,152,212,102,171,224,241,113,81,9,138,162,221,205,115,201,182,61,2,208,51,20,200,195,33,54,196,204,116,194,66,167,21,109,218,145,199,18,122,228,235,68,58,27,70,208,70,216,251,142,3,52,223,190,218,109,163,47,145,59,175,252,131,144,133,122,50,184,28,122,10,28,228,114,103,225,174,60,193,10,209,243,30,205,90,187,135,49,72,13,90,225,65,163,30,237,10,239,97,186,0,92,249,149,176,121,158,66,36,80,47,122,89,158,59,73,114,253,5,220,177,9,196,208,241,204,177,170,17,19,158,39,108,184,206,154,140,24,71,241,27,92,53,76,153,21,4,189,80,37,217,152,2,96,151,26,142,59,2,169,181,114,176,21,43,173,100,255,100,83,38,9,237,70,229,20,91,234,226,125,36,174,7,205,230,30,137,185,157,82,63,0,203,69,100,179,13,206,167,121,190,232,253,253,8,247,43,37,85,226,104,190,128,79,121,225,236,120,155,240,232,14,236,31,142,58,137,200,107,169,73,98,32,98,144,85,181,220,125,87,152,36,169,156,212,201,83,90,75,51,128,173,86,131,63,170,196,19,33,214,4,169,222,186,25,194,194,229,92,200,208,185,214,45,24,86,229,56,67,251,202,4,56,67,33,150,9,179,230,216,136,175,250,236,184,158,70,189,153,232,155,159,204,23,174,51,139,244,232,33,113,150,186,192,174,35,211,71,0,253,55,227,152,241,16,252,89,231,24,100,51,71,255,119,135,245,208,1,124,232,0,138,19,42,65,204,160,169,15,166,95,201,148,1,18,55,228,159,39,4,39,159,166,112,57,44,104,53,54,254,4,32,36,131,148,166,195,1,190,56,105,79,103,144,50,245,212,235,173,218,198,165,163,62,134,67,92,94,91,105,223,153,126,250,94,72,139,236,82,195,234,238,151,179,3,184,234,82,224,53,116,152,119,39,87,6,91,165,104,3,63,90,69,138,79,253,147,171,12,2,94,164,220,205,142,72,194,93,28,132,91,196,101,210,214,128,198,157,159,123,207,165,80,129,15,74,225,0,183,252,186,117,14,52,230,132,150,52,249,214,16,58,128,184,236,58,40,128,253,164,244,208,15,220,184,159,229,190,22,35,103,216,254,162,199,16,195,94,65,10,232,160,141,149,179,188,77,233,75,65,18,151,83,17,68,148,152,185,51,123,205,204,102,229,226,44,35,69,86,173,167,191,133,233,254,31,57,79,27,223,14,247,226,199,11,132,59,171,60,106,232,241,170,17,55,149,109,218,27,28,38,236,89,69,233,209,235,155,152,227,124,82,86,154,232,107,103,43,50,17,170,119,41,237,158,50,33,183,179,60,168,154,62,167,167,247,106,255,4,29,232,49,8,219,176,39,217,193,157,90,228,94,152,199,160,152,53,166,130,189,155,65,246,231,93,30,117,170,250,23,233,102,237,235,122,101,87,130,57,101,152,83,18,255,73,32,37,28,58,200,129,187,101,198,252,22,125,211,119,136,39,0,44,216,72,20,179,73,230,28,8,205,12,124,169,29,251,34,28,192,100,98,227,22,155,176,218,71,181,8,249,143,148,71,243,137,148,27,221,224,121,78,2,160,191,220,139,190,33,78,70,237,203,132,134,108,107,201,67,7,234,59,217,90,135,90,17,67,151,69,183,247,163,88,134,205,204,74,3,140,187,69,153,51,239,29,103,10,3,106,153,166,236,20,54,180,41,125,98,129,148,11,88,145,209,154,173,33,130,86,90,54,65,130,151,253,218,121,229,98,98,129,208,183,78,194,83,203,222,170,4,204,175,207,254,9,75,121,15,30,148,204,171,22,116,48,224,197,253,35,225,75,145,23,18,49,208,52,202,30,177,184,26,168,182,228,35,241,162,148,12,86,114,217,49,94,16,34,240,65,247,100,162,145,8,96,227,136,29,218,165,121,184,162,202,80,133,89,101,32,161,130,226,175,27,194,203,16,80,49,12,27,53,23,17,215,219,234,99,179,251,104,168,210,104,38,204,95,79,169,105,115,17,146,0,71,28,198,166,65,104,106,159,181,42,134,195,124,136,8,187,228,199,185,103,90,130,92,180,114,186,133,225,218,66,89,210,232,165,129,15,189,169,170,235,223,148,155,28,31,176,110,129,125,107,165,134,184,59,250,92,64,82,179,152,225,68,245,194,121,177,247,136,54,254,11,166,115,114,112,25,104,226,254,111,18,99,105,104,54,10,178,103,211,174,16,115,0,101,103,97,197,79,178,110,95,219,197,110,247,77,220,165,54,75,113,104,93,63,31,24,168,60,53,35,86,113,24,210,164,227,147,40,20,192,128,252,3,247,69,46,239,114,208,103,193,248,143,34,228,244,155,120,176,195,105,76,80,30,233,114,190,105,146,119,219,204,19,148,129,47,131,41,164,180,159,133,163,72,60,126,65,159,34,252,35,78,15,57,9,112,158,177,176,214,24,32,10,178,239,97,188,233,94,237,111,165,176,78,70,9,27,240,127,240,189,152,86,156,75,6,20,157,212,77,19,79,59,183,105,130,235,236,228,126,135,171,252,195,86,12,244,231,36,206,86,201,106,61,220,10,37,15,79,29,152,21,63,215,215,154,214,201,165,6,202,252,180,121,216,48,48,231,117,229,24,111,122,233,27,7,56,158,232,173,209,217,22,200,207,89,183,236,31,235,99,48,190,69,83,190,121,80,197,199,59,9,25,238,30,192,76,168,59,45,154,234,65,41,103,176,152,6,196,47,95,87,240,144,66,134,118,45,243,157,251,35,226,233,229,184,70,151,50,98,34,20,129,38,238,132,199,228,60,90,194,52,79,135,168,159,239,246,4,143,63,215,223,202,44,110,225,11,179,10,4,133,37,86,255,82,166,83,2,218,32,120,243,7,34,131,138,154,188,224,238,217,130,121,93,2,43,77,14,89,10,7,138,216,37,183,12,150,190,121,226,84,17,23,64,200,232,124,156,137,33,91,246,131,176,108,165,42,51,218,62,53,23,144,65,167,1,122,45,8,226,234,39,47,79,99,137,254,241,164,41,234,227,232,222,0,245,150,98,228,168,167,61,184,151,251,173,196,108,137,108,253,9,73,104,236,224,57,35,165,200,159,87,153,178,60,185,218,161,24,88,77,5,186,204,120,135,187,39,75,125,135,74,158,134,74,218,249,207,12,174,235,13,22,25,163,162,87,194,208,47,160,240,62,4,90,73,88,64,47,233,18,141,29,188,179,31,157,229,92,130,20,68,192,155,36,86,238,211,120,179,31,115,77,121,46,143,156,242,14,150,105,169,133,99,172,38,178,58,56,76,88,165,23,169,209,163,120,196,4,221,51,99,49,112,232,131,119,105,175,186,150,165,29,233,147,172,48,54,119,133,159,91,72,112,217,127,193,111,216,7,84,126,195,95,85,118,148,123,95,94,214,93,62,5,253,20,89,108,200,10,109,10,221,34,78,231,100,189,159,93,107,82,178,199,131,117,51,29,246,67,217,171,12,43,129,184,247,139,234,193,50,117,225,110,159,17,13,162,31,136,92,122,181,206,250,234,122,164,157,123,120,93,66,166,178,77,190,19,231,27,159,11,20,78,225,144,75,120,144,96,53,175,197,29,148,53,13,29,39,63,238,37,112,62,77,126,234,125,1,22,203,26,7,196,150,119,76,155,255,58,155,1,146,217,129,54,72,233,47,202,139,36,83,242,165,22,224,162,233,54,209,204,39,84,253,186,10,16,8,252,19,119,182,83,32,97,45,65,196,57,156,69,242,24,167,107,106,140,147,190,53,61,55,225,87,206,61,16,11,157,33,215,236,33,168,116,9,184,178,187,17,22,53,47,20,190,8,55,41,25,180,131,167,241,31,86,238,32,74,169,27,83,22,199,88,211,20,148,86,37,218,236,84,159,200,182,93,246,240,46,126,20,51,23,119,82,238,151,109,163,97,227,246,103,141,39,221,201,13,235,153,221,39,183,93,100,135,239,122,110,52,222,138,202,135,253,240,21,126,76,88,192,9,154,35,59,194,130,7,238,166,221,48,25,205,183,129,74,104,240,225,0,41,105,179,155,24,166,192,83,92,139,105,124,32,31,69,236,245,2,211,215,41,20,155,215,201,142,221,210,193,86,93,80,70,169,151,211,9,151,141,159,29,79,105,47,175,112,136,110,255,126,250,224,147,83,252,129,32,78,89,130,116,82,174,38,2,75,50,61,57,161,130,176,213,27,163,227,25,71,39,233,221,211,142,204,131,41,73,229,198,234,5,8,195,23,195,237,85,23,243,195,68,202,86,198,90,10,28,119,92,123,88,211,152,80,112,248,218,0,32,10,91,101,220,115,102,91,83,216,217,238,50,109,83,110,214,7,142,179,76,76,76,17,252,72,250,171,140,78,230,223,174,244,179,250,240,227,243,242,69,171,38,3,219,249,171,205,73,170,173,224,221,226,149,61,116,110,163,26,173,216,54,73,18,152,253,159,142,42,184,25,173,114,202,157,255,235,239,59,29,138,240,9,72,230,124,70,106,200,24,208,105,188,49,194,218,28,120,231,136,25,55,140,230,221,45,39,197,17,244,40,132,213,122,0,179,5,136,180,237,24,227,60,113,100,5,193,110,112,121,99,221,217,239,98,206,182,1,204,77,41,240,114,55,109,12,48,64,245,22,16,246,50,217,92,185,89,25,218,39,74,248,144,53,144,37,214,56,100,104,96,134,231,157,184,194,159,30,198,156,93,203,108,67,161,41,8,46,80,104,198,165,29,104,202,140,74,42,219,40,37,66,102,231,80,235,168,168,52,127,66,207,31,147,103,0,179,222,29,84,106,66,59,194,54,205,193,111,114,44,146,101,121,216,168,55,207,214,221,164,200,47,247,43,228,83,202,235,118,193,61,161,88,42,120,235,5,0,120,134,46,148,21,6,111,237,182,206,103,146,199,241,212,228,205,149,45,140,41,69,237,74,73,126,136,144,219,140,9,251,185,128,69,205,74,71,242,182,196,255,115,0,135,164,22,216,103,174,126,145,3,189,50,105,53,214,128,43,48,72,126,152,176,31,74,145,8,61,33,114,190,96,227,222,151,35,144,25,222,142,126,239,106,53,97,101,196,158,137,135,160,150,32,15,151,186,179,10,244,200,210,39,42,149,160,113,28,227,163,0,53,229,27,255,84,189,161,65,25,1,189,2,207,205,71,21,36,52,137,89,214,149,0,5,200,180,237,151,103,115,215,179,241,132,39,233,90,49,34,155,137,218,138,246,207,237,235,170,220,111,88,187,209,177,86,237,211,204,42,88,3,0,172,227,52,63,100,237,63,151,105,197,168,146,89,95,124,147,247,80,232,88,152,149,49,238,68,164,225,141,66,127,104,155,76,221,96,196,67,247,93,41,112,202,18,56,237,248,250,86,173,36,199,207,112,194,194,52,55,154,179,209,121,133,28,10,137,109,32,175,175,66,127,159,235,195,22,84,27,49,249,185,189,204,113,186,161,177,207,96,214,253,208,39,183,132,50,108,58,187,255,42,159,77,87,185,210,239,114,253,244,132,29,167,0,178,202,164,153,26,186,145,105,248,34,91,66,139,195,74,0,120,91,213,34,231,102,87,104,117,35,20,180,108,8,156,182,175,158,106,226,42,168,197,236,217,178,84,139,30,113,13,71,221,173,52,186,185,11,37,32,75,13,201,38,64,221,245,91,202,215,151,226,180,143,78,28,177,52,106,18,0,140,194,234,93,243,189,10,65,50,212,235,157,15,152,186,89,69,63,124,22,94,252,24,188,56,33,124,185,152,248,183,183,133,218,45,64,105,212,185,105,170,72,102,149,61,196,6,98,135,229,28,205,108,81,196,69,17,158,158,177,248,202,246,78,184,51,174,210,231,239,148,54,66,40,47,166,63,223,150,179,247,146,190,11,226,67,24,234,52,192,16,3,84,97,198,44,113,6,89,235,67,132,50,48,3,109,196,84,75,78,17,161,77,59,145,68,136,213,250,99,108,191,79,84,253,43,91,83,234,50,39,243,107,184,223,79,215,244,174,191,23,119,86,149,73,211,107,12,143,104,250,209,76,95,240,158,133,48,239,253,176,70,38,22,138,243,67,63,112,148,183,140,89,121,15,19,236,152,209,71,35,102,73,179,44,111,140,149,254,246,139,63,131,94,234,5,0,195,152,93,206,183,98,8,219,229,146,47,137,170,61,244,57,99,137,13,216,126,192,217,214,76,231,149,106,233,107,199,9,98,6,109,21,33,219,129,220,152,110,36,176,68,171,56,60,195,244,46,162,183,165,191,120,98,35,16,245,208,66,11,195,101,53,207,42,59,50,129,59,164,240,147,237,220,181,197,111,103,176,219,249,170,88,48,49,120,225,118,211,236,33,198,119,149,247,80,16,204,226,83,223,208,48,9,39,49,151,194,209,35,105,167,192,214,58,196,62,11,157,1,45,173,75,100,142,2,207,21,183,129,56,117,63,62,33,28,13,217,206,54,56,230,31,6,228,79,125,238,159,115,240,222,63,150,223,161,11,234,72,74,5,243,1,16,42,34,120,120,242,65,55,90,6,142,40,105,175,94,200,141,51,19,51,91,53,150,192,245,37,87,142,82,110,187,200,199,135,78,196,39,58,114,215,254,187,242,199,103,222,232,242,232,198,190,213,77,239,245,231,205,98,177,74,205,132,106,177,203,117,195,86,29,53,104,188,165,232,19,42,21,136,123,27,252,229,149,61,255,172,165,164,143,253,231,24,25,40,139,220,102,214,252,51,220,169,229,127,116,169,123,81,52,23,221,139,163,178,176,221,99,218,16,203,179,88,64,3,162,73,147,110,164,94,254,223,245,9,88,215,76,212,148,50,74,221,224,178,52,32,6,206,219,86,100,66,248,188,19,22,90,198,206,1,251,57,37,191,57,53,107,195,133,212,8,98,104,59,227,197,17,217,100,54,48,62,114,81,54,62,176,237,213,254,109,128,217,154,186,178,56,13,138,141,130,92,104,166,19,46,225,244,249,88,148,13,14,112,61,216,228,235,130,67,131,147,190,157,61,237,176,191,133,158,67,227,77,202,75,5,84,213,227,82,151,40,188,186,21,51,63,147,204,239,2,47,10,13,208,191,237,171,24,17,49,21,55,162,249,204,166,31,243,29,68,98,201,16,25,17,215,167,185,59,33,209,159,200,37,69,144,138,49,192,102,202,187,91,174,19,30,134,120,1,14,187,14,64,30,220,14,69,133,28,61,247,101,212,204,111,169,20,124,13,99,196,10,145,128,222,117,56,89,195,54,60,108,234,211,66,167,84,236,120,119,54,248,119,31,202,229,190,72,148,21,56,254,166,121,50,37,25,137,50,90,98,67,60,234,140,191,3,204,99,210,107,158,33,45,111,246,123,128,222,144,36,255,176,162,12,11,61,84,86,149,100,67,43,178,135,82,2,178,153,96,252,179,107,70,155,135,97,222,151,58,140,105,45,200,207,197,133,70,70,210,117,32,14,228,221,233,1,205,217,110,113,109,120,162,162,219,119,255,202,154,213,186,178,242,177,244,137,83,113,15,189,72,105,81,27,142,114,202,199,95,0,97,240,224,225,207,135,51,135,116,149,251,123,45,93,246,232,143,123,200,95,183,53,229,122,174,118,246,111,185,33,255,76,193,146,165,135,49,70,168,86,250,157,143,217,167,75,95,98,85,45,97,143,238,40,166,155,139,206,58,152,198,17,149,164,12,240,52,188,79,117,119,71,51,180,205,37,77,144,61,168,3,217,96,183,22,16,97,112,32,6,60,211,176,196,86,106,33,53,26,188,179,100,210,93,94,202,142,101,187,122,141,200,85,116,234,140,96,238,163,95,234,237,66,219,237,165,162,42,153,111,56,169,185,37,134,127,97,83,234,157,20,157,130,22,144,102,68,182,137,236,234,19,124,233,26,177,25,179,74,74,88,186,27,178,210,248,10,44,240,158,203,227,83,42,108,14,64,168,105,188,66,238,31,213,251,84,238,203,82,26,37,231,151,11,230,202,175,196,93,62,105,255,34,83,62,156,66,68,249,168,133,108,87,213,33,244,144,6,156,201,75,75,49,5,171,55,42,63,26,172,78,33,74,34,217,200,235,178,141,100,69,101,201,197,186,154,129,214,216,122,179,78,196,75,89,229,113,221,171,62,66,92,133,250,28,91,146,78,242,164,166,244,14,20,157,97,80,45,169,102,202,72,141,163,91,243,102,217,96,10,228,196,245,46,25,158,120,36,153,133,132,249,215,85,161,109,96,12,137,101,50,209,32,209,15,144,150,213,85,18,60,102,138,221,17,54,178,76,20,64,119,198,205,134,202,10,170,93,75,215,253,24,197,102,129,239,181,181,231,161,33,165,216,192,123,131,76,97,188,51,122,161,120,129,173,217,83,145,33,217,99,69,174,178,70,94,7,66,236,47,207,55,72,57,83,118,168,195,57,50,43,193,105,99,172,152,38,207,29,203,119,83,130,108,236,158,18,61,221,121,53,249,67,129,70,65,225,14,111,50,63,13,42,180,72,171,189,77,147,205,104,216,176,23,130,93,220,162,5,188,39,186,156,116,192,236,120,96,240,62,168,91,108,95,4,109,75,37,187,32,0,201,227,198,29,187,171,99,9,53,123,78,149,247,54,235,68,106,149,40,78,197,188,129,89,188,67,60,4,62,131,105,197,61,23,254,166,74,8,39,149,74,162,46,122,187,48,186,207,230,173,9,242,50,15,18,29,78,74,158,99,8,131,59,130,208,45,84,179,6,56,52,82,208,178,153,93,161,37,230,109,190,84,137,153,128,218,66,23,104,80,203,94,225,56,99,137,117,100,94,12,54,128,96,72,211,138,29,202,77,19,9,160,231,162,189,139,218,175,125,225,173,93,177,191,138,236,148,169,183,102,191,16,57,20,21,251,189,143,176,43,98,57,24,24,104,179,153,194,82,47,6,37,28,6,108,235,64,25,118,235,229,181,200,127,164,150,96,0,101,13,61,69,72,107,87,192,164,64,12,165,168,103,94,241,42,167,148,33,243,116,109,67,66,7,177,52,175,232,34,24,254,68,20,88,236,246,180,101,175,93,157,255,164,127,154,69,193,35,100,80,211,108,204,64,86,181,191,107,35,219,74,136,14,83,43,251,223,174,169,37,165,42,12,112,122,177,238,8,179,3,251,109,208,223,67,209,25,123,104,211,67,225,27,127,196,49,219,138,86,56,89,126,189,154,97,62,126,134,72,99,250,192,44,42,122,23,167,8,131,180,92,32,20,55,13,31,90,150,168,21,105,142,52,145,62,29,216,97,39,151,6,39,142,23,189,175,237,130,87,61,79,29,149,213,42,102,49,155,220,150,103,76,49,39,95,250,214,110,80,141,46,136,141,23,0,145,111,217,57,132,252,12,42,175,116,13,209,205,217,148,214,179,21,232,174,214,17,89,20,94,217,180,202,198,150,37,156,244,172,65,127,59,211,80,116,200,90,41,24,225,204,128,158,92,161,47,194,197,202,33,199,246,206,7,162,10,229,141,13,202,174,50,167,159,226,45,166,27,73,44,120,206,248,5,62,248,247,169,67,113,189,95,48,137,194,36,36,105,79,18,128,229,6,97,112,43,2,107,93,158,49,53,253,249,98,117,59,74,182,132,153,175,25,24,208,199,30,177,121,165,95,87,28,254,127,73,132,173,63,180,227,129,7,107,226,163,118,68,81,47,44,217,34,167,61,89,43,54,25,79,46,148,100,18,145,32,19,209,108,48,157,113,81,233,28,18,52,116,43,164,195,119,66,247,79,243,39,84,119,114,125,55,225,229,74,184,175,35,195,222,28,214,25,212,169,136,216,11,85,147,116,111,162,85,203,74,200,77,110,38,6,37,73,152,61,139,30,62,170,42,133,24,213,99,66,197,143,131,110,224,213,169,125,231,98,90,64,60,88,136,24,175,144,129,243,156,35,9,30,112,58,221,206,243,116,115,178,110,105,39,152,195,99,241,6,104,248,170,184,92,193,144,252,90,194,44,9,14,123,148,49,97,85,0,65,98,238,17,74,30,181,175,93,235,86,245,175,52,8,165,61,115,93,0,180,220,234,131,228,224,92,143,245,163,49,221,7,109,229,212,132,76,131,14,156,125,123,125,167,38,156,232,216,100,43,17,145,42,38,26,162,53,26,157,37,111,46,206,216,64,252,28,142,36,171,144,161,99,119,9,80,93,34,68,215,43,62,19,88,191,221,153,87,225,26,30,48,123,91,39,181,36,111,137,190,247,230,57,25,44,72,249,234,176,151,88,161,219,178,189,204,143,216,64,82,109,184,117,185,10,207,121,5,180,143,90,61,6,129,206,19,36,119,54,79,198,32,193,125,56,122,146,198,170,161,200,51,68,116,217,147,231,178,62,52,55,131,72,137,186,251,46,53,104,119,141,46,63,161,163,49,64,115,212,124,86,82,205,127,75,51,86,167,95,9,105,130,80,21,63,176,106,12,170,189,252,141,175,176,47,208,164,2,255,76,44,90,245,222,143,162,242,255,104,65,30,48,135,54,233,240,186,189,169,138,110,208,113,156,95,71,53,54,47,145,29,211,46,19,67,237,159,193,174,103,101,241,106,206,102,115,121,129,68,151,10,39,202,189,223,47,221,207,17,29,230,121,65,41,155,187,84,26,43,173,159,251,69,163,13,21,121,90,41,22,37,127,126,85,20,37,36,63,50,200,229,25,94,140,30,210,250,99,148,74,77,16,145,15,246,62,26,197,81,175,62,178,41,141,29,28,63,120,130,18,45,184,50,6,19,50,158,119,16,102,57,2,137,198,83,98,224,143,61,21,84,146,24,51,186,22,156,214,81,198,119,158,136,106,133,232,19,169,122,128,170,42,153,111,156,189,197,163,150,64,15,129,194,2,210,91,32,231,14,55,175,253,193,27,117,35,205,169,246,131,17,122,33,83,83,141,116,226,23,59,200,160,66,214,137,65,60,206,245,162,245,142,17,67,147,78,158,185,17,25,47,35,94,114,17,120,50,132,163,60,61,247,102,85,4,221,249,65,82,228,164,73,241,51,84,186,37,115,42,52,177,155,189,36,50,27,234,86,206,174,9,173,45,94,22,255,19,241,65,25,101,179,243,120,170,133,154,178,244,189,215,215,94,233,129,183,171,212,251,236,152,246,109,249,86,43,25,135,135,91,134,235,108,224,156,178,18,72,245,191,74,45,47,147,21,228,165,63,155,218,82,240,115,210,250,146,225,209,187,197,93,199,223,249,51,38,135,26,83,196,141,126,104,30,201,175,7,137,164,51,193,128,104,167,129,137,107,23,42,224,110,123,171,81,87,47,96,7,51,232,184,83,28,128,46,7,189,42,227,92,56,188,67,78,161,115,232,54,148,193,30,22,173,222,84,251,213,26,146,19,7,159,59,174,169,22,50,201,184,17,50,205,52,62,101,152,223,21,197,133,48,229,138,92,233,255,43,31,245,14,152,76,22,34,69,239,208,242,134,251,233,7,54,243,151,141,250,156,73,175,46,140,199,27,51,104,122,135,16,135,38,186,29,143,70,102,83,148,220,41,123,236,128,224,184,46,117,129,194,45,134,215,46,35,215,3,249,108,234,30,125,76,161,76,47,78,114,182,123,35,9,105,6,182,157,153,245,206,181,167,148,5,158,129,221,184,196,107,109,196,183,116,227,81,60,187,245,194,253,136,50,203,3,101,235,245,75,130,89,236,55,105,214,31,16,125,20,226,238,185,206,84,136,74,11,127,72,195,40,77,168,5,110,180,255,90,23,233,193,137,105,195,226,138,150,234,86,131,131,208,179,127,253,18,245,155,72,77,239,216,246,91,52,46,161,203,92,208,103,254,143,53,115,96,97,211,252,197,206,132,120,170,78,220,84,149,43,69,214,81,204,166,124,245,166,180,26,51,227,154,104,58,79,122,18,3,107,216,162,97,12,73,0,128,95,72,1,184,59,152,169,57,92,45,28,196,169,132,100,165,159,233,97,84,173,113,181,62,36,157,104,9,2,156,189,151,106,238,68,120,150,28,100,38,235,198,219,150,30,164,78,62,198,13,57,25,68,167,169,220,249,30,53,243,155,97,144,21,44,185,45,239,188,168,67,231,65,23,93,197,26,232,179,106,26,92,80,38,147,26,53,141,18,167,105,185,130,223,187,126,83,104,251,2,202,229,0,0,152,3,126,146,125,75,13,174,118,113,48,218,44,53,45,226,241,205,177,253,146,57,230,155,93,94,201,153,71,76,189,106,194,6,19,203,135,88,199,83,112,189,124,208,190,133,201,246,143,129,55,23,230,178,244,251,14,29,51,162,158,143,106,250,206,30,125,195,6,36,0,120,43,129,126,187,135,109,7,139,144,69,177,65,213,179,239,19,12,177,202,64,36,137,37,136,210,238,137,254,243,76,29,72,11,146,19,14,42,129,27,146,204,74,129,7,197,25,195,136,153,64,94,164,17,96,116,86,172,61,68,31,242,254,129,74,181,39,203,243,217,223,83,100,171,66,170,170,8,54,165,246,51,156,230,174,213,174,175,4,177,240,254,126,234,191,196,247,68,50,219,9,23,171,153,35,152,32,75,166,30,235,154,104,154,170,200,10,122,152,21,145,238,238,187,47,77,239,12,201,233,199,56,90,225,34,82,43,163,235,158,169,60,148,176,13,152,51,198,42,2,176,172,18,77,177,236,39,77,143,60,172,44,35,148,205,221,134,211,155,11,97,97,139,188,104,54,199,87,216,96,79,195,128,113,146,130,207,107,7,201,19,51,203,159,146,146,120,0,36,159,143,168,145,117,131,192,191,121,208,53,210,223,180,233,156,203,138,137,172,151,216,27,28,161,65,51,10,142,115,125,215,147,101,189,132,139,207,120,238,32,58,107,111,142,35,153,157,49,186,129,227,22,60,187,152,124,133,223,23,98,82,165,88,175,245,39,253,190,35,51,204,178,152,207,0,110,236,162,161,67,141,224,111,38,86,68,212,27,1,50,78,73,185,41,212,197,105,48,145,191,142,219,70,139,70,209,206,101,180,247,215,31,106,188,206,5,34,211,224,49,17,252,165,93,128,131,166,0,0,222,44,224,222,25,121,4,182,212,6,167,118,201,90,12,252,241,119,253,158,188,86,78,250,83,120,211,41,204,131,121,55,210,159,28,176,79,71,83,186,168,130,190,18,151,221,221,84,173,96,159,183,124,152,102,156,222,156,65,9,48,95,149,178,16,118,153,149,32,4,76,78,42,76,46,137,28,45,67,85,20,55,9,124,142,132,196,211,170,194,188,220,141,118,131,186,37,96,58,175,9,205,220,245,215,44,5,148,35,36,251,50,16,214,29,40,244,70,59,138,241,58,106,194,60,29,151,195,245,7,132,196,172,72,149,44,30,47,241,169,32,170,104,65,28,212,42,58,231,44,102,4,9,124,14,117,237,159,165,43,204,221,244,61,72,245,74,155,7,145,17,166,74,224,109,131,205,225,225,55,33,180,153,252,153,158,54,209,127,152,47,249,92,130,182,231,114,209,97,16,34,201,158,131,66,250,251,58,175,32,161,235,238,166,92,235,102,11,33,44,119,45,17,83,101,4,181,244,253,86,182,28,28,155,140,123,87,34,177,135,58,27,32,103,98,116,254,194,132,7,26,89,126,125,109,83,137,201,213,49,153,79,227,236,250,206,14,214,161,224,113,227,189,192,194,119,175,224,246,186,153,214,63,75,25,191,82,100,195,178,48,80,13,237,194,129,124,18,9,15,1,212,157,29,221,25,39,92,110,6,254,163,113,213,223,16,254,4,9,35,188,99,225,166,63,118,234,63,160,167,161,241,92,101,213,81,24,9,236,130,95,122,40,190,60,85,13,214,15,64,182,185,114,28,17,97,20,197,91,241,253,180,168,89,131,234,53,193,107,148,206,250,137,195,46,6,187,158,51,178,64,195,100,229,68,206,238,230,144,56,190,26,204,133,147,1,82,133,26,202,155,39,209,27,190,142,79,83,235,131,80,31,120,83,114,137,169,126,44,16,152,60,10,53,220,248,111,198,18,53,87,246,246,92,49,102,28,36,25,105,50,250,65,88,56,62,222,111,234,181,2,78,36,3,134,228,235,199,125,51,136,26,96,58,150,3,189,106,128,208,85,189,60,22,208,7,74,92,105,103,66,69,226,2,194,114,204,49,66,177,25,97,105,139,68,59,193,230,71,15,127,77,57,172,87,113,221,117,191,137,60,86,227,212,133,38,125,118,62,21,83,151,188,127,51,208,62,22,41,102,163,120,119,253,1,108,231,243,233,5,205,167,141,33,98,131,156,54,138,135,131,156,138,95,107,167,13,169,19,111,176,203,16,76,41,167,225,190,224,157,73,98,176,159,7,211,239,46,109,233,167,72,154,24,106,3,201,37,43,183,179,31,195,190,207,251,156,251,208,66,172,253,214,121,158,218,241,225,242,84,195,246,252,34,4,237,66,229,226,140,191,100,21,154,85,86,171,73,179,53,137,126,121,197,109,43,23,166,54,62,194,21,116,77,131,147,153,166,17,250,201,21,193,198,82,157,56,59,211,149,197,70,7,135,117,179,189,15,215,253,99,57,216,151,178,183,61,161,228,42,197,173,95,161,19,182,203,147,199,1,3,90,161,127,75,118,194,226,179,198,144,99,18,150,165,91,41,76,27,9,76,120,103,111,102,95,51,135,106,4,124,223,53,83,242,52,214,66,251,117,47,169,174,204,0,229,134,243,16,82,94,88,208,202,47,111,9,153,205,120,167,178,138,188,253,236,3,181,134,51,182,47,72,173,120,42,251,61,29,49,190,70,95,210,216,108,4,121,114,180,0,215,18,149,44,116,230,191,125,21,253,61,252,126,50,83,225,99,156,13,210,85,194,126,67,195,150,152,246,29,141,205,193,135,131,170,164,25,100,213,189,244,124,48,142,110,153,138,193,39,225,21,180,219,117,132,1,43,196,250,138,109,54,64,122,235,171,51,193,40,205,46,104,13,206,145,172,198,60,109,177,51,214,192,170,110,115,235,163,61,32,43,141,253,194,120,91,152,49,37,67,86,115,73,126,141,35,113,147,234,228,245,145,217,97,116,63,100,124,182,135,68,24,222,65,43,114,164,206,163,77,243,122,49,92,130,18,80,107,162,158,237,245,216,0,102,240,204,244,198,254,42,121,169,153,131,177,116,160,150,142,110,197,7,211,122,95,46,248,113,62,99,193,34,131,33,139,219,219,137,241,157,225,39,162,156,216,133,50,145,120,21,28,194,65,130,105,117,6,182,123,241,210,56,183,46,5,6,146,99,178,55,24,83,207,151,134,90,170,198,223,104,11,100,30,217,134,239,191,166,29,153,38,198,220,102,230,51,195,196,239,250,23,108,37,182,151,193,200,243,189,222,221,121,188,212,172,217,23,59,221,26,154,59,227,138,241,184,81,161,238,131,97,148,143,225,142,192,220,245,33,93,19,255,183,200,14,87,242,149,32,97,247,251,179,31,41,35,125,101,63,228,27,157,163,23,141,113,43,186,165,0,181,28,113,57,12,81,91,240,138,139,163,10,130,242,30,199,116,148,252,194,135,94,228,6,15,89,73,172,57,46,212,15,101,107,71,65,1,252,233,78,5,251,235,17,250,219,90,95,40,206,166,76,200,124,20,7,211,55,7,247,90,93,164,216,83,112,9,250,204,249,255,55,145,175,173,251,110,128,19,215,190,170,130,29,119,166,205,117,169,86,137,32,64,114,124,28,145,229,7,65,85,20,59,224,194,182,95,11,185,22,126,17,26,33,137,3,97,215,67,162,98,241,80,52,3,187,180,103,241,190,101,209,173,8,189,176,122,185,3,16,134,198,166,33,228,18,5,93,60,181,206,145,96,25,159,144,171,3,235,159,230,195,200,202,32,166,249,129,129,31,191,219,220,238,236,188,160,104,171,64,96,80,214,195,168,35,119,253,145,213,167,13,28,6,91,115,31,142,211,193,194,60,120,164,255,204,156,43,248,178,133,98,63,206,122,101,162,11,195,80,26,4,151,235,164,65,2,78,71,171,189,23,122,241,163,80,92,112,223,232,6,8,163,248,233,95,104,207,16,186,226,253,83,115,55,154,11,52,168,140,72,19,226,148,175,114,63,58,0,168,250,97,128,25,37,215,42,191,162,32,68,63,28,127,224,83,207,140,209,88,142,248,70,47,179,253,202,31,9,230,235,184,190,84,71,103,33,110,174,98,177,96,200,209,18,31,67,154,221,113,56,35,234,229,239,149,99,202,54,83,195,246,163,136,82,99,247,157,60,251,238,26,53,153,213,140,127,150,187,54,210,239,91,117,80,225,6,205,12,173,28,118,190,95,120,175,52,204,56,85,90,150,9,75,90,92,166,188,105,139,50,84,0,241,173,64,130,230,41,228,187,143,45,240,235,134,28,113,150,49,220,69,70,74,82,24,89,83,78,110,234,122,106,125,17,33,251,31,51,179,74,118,244,21,84,53,148,12,11,206,136,145,10,225,180,79,163,224,108,14,164,65,182,197,243,242,37,54,85,111,19,109,190,10,186,215,120,21,182,137,35,103,115,189,89,13,131,145,50,0,83,84,190,48,137,149,214,244,66,157,138,162,58,59,60,0,49,51,113,149,168,212,12,35,255,123,119,169,47,163,254,205,229,93,235,188,48,237,246,79,233,102,94,211,133,92,241,59,130,231,91,203,205,37,72,15,33,203,227,177,194,4,180,221,139,52,108,220,212,245,23,56,51,154,123,155,221,40,206,218,167,241,184,112,107,224,39,191,34,208,165,112,49,226,167,163,119,168,141,78,145,116,49,222,139,187,216,125,162,38,147,83,171,215,176,67,84,217,114,54,79,138,199,71,232,31,202,97,144,211,210,84,31,95,193,61,229,146,77,255,14,14,104,165,124,108,17,75,106,53,62,238,155,93,53,120,198,14,79,231,23,49,161,242,113,245,106,139,241,173,252,247,19,23,183,73,22,24,53,183,201,173,24,186,232,65,238,158,67,255,19,123,4,93,210,146,0,238,19,103,126,77,148,122,84,200,134,81,154,16,203,58,40,161,187,219,57,29,165,230,218,10,234,185,193,43,110,57,143,135,242,188,50,222,69,51,235,179,142,253,227,20,30,165,111,89,245,104,177,200,29,37,210,26,230,172,29,172,188,46,21,183,85,31,51,255,237,160,19,47,230,160,112,223,48,196,232,226,191,124,74,102,194,252,216,149,185,9,101,241,153,155,202,41,190,192,222,26,171,19,217,199,148,205,43,121,51,125,215,140,138,45,3,79,174,126,13,123,18,229,48,56,35,112,228,104,211,37,156,216,167,178,206,119,35,241,125,88,167,223,43,156,74,161,171,36,55,179,25,222,230,187,151,166,86,168,61,20,119,98,94,49,16,160,47,200,37,246,123,40,87,169,118,90,46,120,113,34,119,198,131,58,46,145,227,107,116,212,85,234,225,188,1,17,216,111,40,154,133,199,68,7,141,159,162,62,217,66,26,101,22,99,5,196,136,210,77,246,40,218,86,71,220,69,92,227,23,139,88,156,45,164,138,10,240,57,136,132,160,28,58,16,206,8,70,94,163,157,58,31,133,62,91,149,254,200,22,143,93,82,73,212,228,78,155,212,149,197,239,216,35,81,235,48,202,83,14,51,251,122,142,32,236,43,144,56,68,190,179,52,144,213,160,28,237,118,12,23,208,15,134,167,143,92,83,79,51,134,188,52,91,129,163,54,175,44,33,228,112,28,19,57,102,166,173,57,71,53,133,92,120,239,75,166,77,102,191,240,21,235,170,108,26,47,170,144,134,121,7,60,178,0,241,191,82,186,148,67,22,39,54,5,74,72,45,208,221,219,246,2,196,117,163,186,213,44,251,78,113,89,17,70,176,243,64,226,186,69,101,222,44,161,87,142,8,153,32,234,188,16,110,80,204,231,145,224,126,134,42,37,102,221,188,75,146,151,133,206,223,141,158,25,95,174,184,220,158,55,25,133,206,216,94,79,187,210,145,90,3,200,87,168,136,130,129,228,12,66,255,3,187,7,48,246,33,11,79,172,221,142,106,161,182,164,116,136,205,137,239,60,44,14,4,163,195,42,97,252,13,201,185,245,111,237,51,10,43,218,73,247,22,250,107,68,31,48,125,140,26,236,173,23,1,8,107,11,101,246,73,168,96,114,226,252,219,17,102,132,153,127,37,133,199,156,103,240,111,52,238,126,189,99,195,109,125,217,131,15,161,229,251,239,91,130,139,240,57,204,192,139,83,161,124,228,38,75,98,134,176,235,7,47,173,110,163,168,77,30,199,239,69,32,86,5,17,160,106,241,117,184,200,82,132,78,68,132,182,77,200,204,110,95,167,202,48,172,165,195,157,98,162,184,0,53,55,203,214,194,173,82,7,195,130,194,0,110,176,76,58,235,174,166,202,96,136,64,92,101,16,85,188,16,186,57,81,137,245,74,154,148,64,53,107,207,251,184,213,220,171,203,208,36,193,74,243,152,12,80,214,121,206,1,214,103,254,61,167,218,82,15,106,231,164,53,212,162,167,247,194,36,103,61,249,223,204,252,56,53,254,220,22,211,37,227,250,16,13,119,131,85,177,153,228,136,117,4,98,173,107,37,175,8,5,24,162,45,167,158,84,159,119,152,53,130,92,137,123,127,251,159,152,198,84,5,157,186,179,91,159,48,121,190,156,43,243,198,133,221,135,46,69,232,83,252,36,82,110,70,50,37,203,107,7,88,36,178,19,93,26,45,227,110,54,125,207,166,209,36,114,170,136,199,181,5,165,68,183,90,109,48,136,108,61,237,127,60,100,170,158,79,139,73,207,65,40,247,51,96,33,70,106,29,203,159,234,139,61,146,100,55,2,152,126,145,65,9,220,94,14,134,184,170,61,4,90,71,123,45,198,254,203,56,228,76,133,249,173,130,186,4,248,129,175,183,5,35,53,169,93,148,152,246,12,238,182,148,231,23,42,70,225,23,102,198,164,232,15,122,217,168,232,211,148,57,39,156,13,112,203,153,152,36,88,28,84,237,214,146,233,178,70,224,1,247,216,66,229,107,66,237,250,125,221,171,200,2,39,52,127,44,121,238,129,24,2,78,31,108,145,17,140,77,9,110,221,170,99,203,144,190,63,178,26,192,105,117,121,114,107,201,25,45,217,62,189,255,240,113,16,6,155,95,195,39,157,126,201,212,34,224,163,223,102,51,214,203,150,10,220,210,210,2,182,10,125,188,235,229,86,221,140,116,96,14,19,178,28,8,204,139,24,10,226,124,42,115,219,255,50,77,33,37,141,98,169,208,40,68,71,244,177,185,150,130,198,169,118,242,92,80,154,98,39,166,160,239,7,14,114,71,79,206,157,50,209,89,101,60,168,181,87,238,90,197,88,77,227,78,157,1,100,188,64,127,136,221,165,224,171,198,232,87,27,41,34,223,108,120,233,65,205,58,98,135,9,211,208,238,69,237,169,208,196,134,212,164,17,85,100,61,172,158,216,142,188,96,179,34,144,141,158,190,212,63,185,121,146,218,52,106,56,26,63,149,213,199,3,148,38,25,12,236,64,36,182,76,123,113,131,89,66,17,6,168,200,102,46,127,40,162,227,121,46,13,172,173,41,51,80,73,146,249,21,243,53,220,85,68,126,84,24,105,130,179,183,197,195,177,31,142,180,99,239,27,62,173,56,86,71,114,232,233,90,83,30,162,154,76,102,21,169,124,190,123,217,150,19,180,51,53,111,153,67,50,207,198,42,115,25,133,95,43,231,57,229,62,8,58,72,196,67,170,128,8,180,176,181,201,118,53,141,19,66,248,77,15,162,203,19,14,109,181,86,36,184,36,10,90,11,124,143,233,188,123,192,30,103,81,149,87,216,153,16,120,114,4,222,157,96,6,142,16,170,107,149,80,250,127,7,225,67,9,8,170,204,28,57,207,150,196,160,200,203,234,229,228,7,125,129,118,42,35,205,235,95,131,80,16,63,160,132,42,244,183,217,6,253,243,213,200,214,212,92,215,73,237,178,35,138,59,8,255,144,36,251,82,76,29,0,32,180,62,160,29,157,12,54,218,185,160,236,159,18,44,28,74,177,173,166,68,136,225,222,55,241,45,132,2,52,219,232,144,229,218,160,77,47,160,176,107,155,2,75,168,29,150,146,174,159,38,128,205,30,109,98,183,93,249,90,79,166,162,53,225,173,170,50,70,239,161,147,19,153,77,223,129,35,157,163,13,132,6,7,36,237,17,156,39,145,82,108,212,26,35,70,90,253,78,13,251,177,72,1,181,100,5,94,8,36,225,137,49,107,131,93,74,208,30,36,206,117,134,9,241,212,146,89,110,113,207,241,220,194,153,181,58,121,171,21,182,244,159,151,54,84,31,159,211,93,84,16,245,203,72,100,113,225,216,207,141,168,5,172,111,193,201,149,235,217,115,163,100,69,2,95,29,165,77,69,255,73,234,107,20,140,52,141,146,71,239,157,247,232,59,5,24,85,13,183,212,99,58,42,239,100,242,138,253,45,69,31,58,216,238,217,230,127,200,65,123,54,72,138,156,165,76,141,158,191,179,80,88,153,242,132,137,167,186,166,9,54,168,155,217,91,89,42,244,207,157,201,190,152,191,130,234,143,26,141,194,85,82,229,0,228,81,123,161,67,67,82,228,89,70,209,190,164,26,168,217,192,225,239,238,82,101,110,76,22,173,164,103,67,107,33,41,210,123,75,95,29,71,161,234,111,31,70,206,188,30,86,34,79,209,176,30,68,171,95,227,125,131,225,132,35,153,68,246,44,108,149,4,129,164,254,116,207,56,190,237,15,111,240,237,240,176,108,122,185,196,58,39,127,54,91,125,42,147,153,186,52,1,9,114,21,103,107,237,36,163,154,176,18,163,146,77,58,0,219,31,30,99,21,87,214,6,73,210,156,157,122,223,69,101,115,217,213,125,48,180,81,70,173,162,172,94,171,132,217,132,234,150,8,196,58,177,64,86,11,170,35,206,207,93,190,19,121,28,173,122,217,80,33,122,153,100,41,19,120,93,234,13,48,143,225,115,121,223,137,81,240,111,45,156,26,86,147,10,216,102,171,12,10,110,13,28,215,3,42,162,179,141,143,253,12,211,116,76,20,182,177,148,1,162,241,170,99,115,158,84,178,192,106,26,37,230,112,121,188,179,210,216,119,192,198,93,198,136,124,15,23,88,84,159,41,105,168,44,127,246,4,166,203,194,166,169,13,159,200,199,197,201,70,182,30,146,230,74,28,133,202,183,112,168,70,70,82,180,50,250,111,19,171,80,203,59,156,157,200,253,119,196,209,104,149,15,67,32,204,41,60,17,132,141,73,55,248,168,18,84,201,78,247,152,2,70,156,239,214,249,145,118,246,169,131,243,180,10,206,243,124,242,158,0,186,32,193,10,21,118,101,238,117,155,36,101,229,64,192,18,76,80,125,96,198,247,226,106,89,68,93,144,127,80,244,216,137,244,196,176,205,141,252,159,96,46,83,9,20,190,234,167,0,38,188,75,181,157,89,170,167,207,224,27,242,189,85,28,242,191,246,215,78,243,82,232,208,82,188,60,197,238,248,235,45,78,149,145,52,30,29,229,4,199,139,33,36,36,220,123,254,81,189,170,143,132,131,77,204,236,147,181,160,91,115,251,164,37,160,184,133,165,121,62,201,123,32,123,221,208,48,90,119,130,102,191,1,153,44,64,91,6,58,214,171,240,60,138,111,199,150,157,114,137,17,193,52,129,207,144,91,131,76,205,11,230,208,110,237,253,199,13,169,30,129,166,93,153,212,190,185,9,84,128,242,157,57,252,89,196,194,252,253,240,18,100,86,2,201,108,250,236,194,122,8,231,158,92,165,61,8,6,37,209,164,83,10,235,12,139,220,76,172,93,195,87,236,62,56,67,21,171,95,7,207,78,236,235,249,198,113,55,110,39,9,203,24,30,181,6,11,220,247,72,18,25,114,72,7,95,219,112,154,218,47,132,185,61,58,185,233,100,203,56,84,209,7,189,69,95,84,24,146,148,211,171,210,131,49,140,78,218,177,142,29,69,119,130,159,42,83,250,174,93,75,145,238,58,246,107,76,215,2,135,19,40,199,197,165,62,38,131,231,213,48,227,45,208,150,175,24,29,166,24,142,50,153,133,71,212,23,192,237,157,79,178,194,201,4,125,189,74,141,41,39,32,40,86,11,50,234,255,187,10,153,183,188,193,94,73,195,162,152,144,176,164,85,29,136,135,27,183,89,45,151,222,117,94,15,217,69,46,193,180,251,39,184,133,203,94,62,201,123,83,211,239,212,198,108,115,220,245,177,78,13,222,154,132,91,221,17,112,140,195,191,113,243,13,149,105,73,153,169,34,226,231,191,2,4,244,114,104,172,178,183,118,97,57,64,244,138,242,120,202,192,100,218,10,153,73,204,182,226,43,140,163,178,113,28,117,145,203,132,23,255,151,202,254,136,210,136,28,53,130,245,246,207,126,118,65,202,133,157,151,220,187,59,89,56,140,177,203,209,125,230,146,96,201,95,236,238,211,163,200,118,117,28,148,66,87,76,128,41,104,10,0,192,42,77,144,39,45,19,224,31,67,50,192,5,144,70,175,109,207,25,56,52,216,78,77,83,247,68,89,175,237,229,131,230,50,153,46,111,135,80,159,34,44,127,217,26,194,170,185,41,181,119,222,240,143,48,91,122,166,215,242,81,65,251,167,166,155,193,108,103,8,241,253,168,23,193,188,79,102,238,235,35,207,119,241,172,212,82,246,111,89,196,212,13,131,93,237,85,246,200,254,2,1,77,118,51,32,24,194,213,13,96,102,12,207,146,246,24,223,92,250,198,118,230,236,187,94,56,52,124,147,218,153,119,4,155,62,167,192,66,94,143,155,42,70,237,234,238,76,223,38,103,187,65,245,74,163,182,249,13,216,95,148,18,116,1,182,98,117,203,204,191,132,55,216,25,100,244,35,139,125,56,170,48,126,25,66,219,106,158,109,93,69,49,67,35,54,79,218,77,12,63,232,212,59,190,196,19,28,23,144,195,137,240,111,12,32,39,155,29,210,225,90,134,155,24,234,3,55,232,124,30,51,245,83,226,94,244,245,47,89,109,61,171,195,123,112,151,210,109,67,188,180,67,238,29,197,18,247,55,233,176,244,39,28,154,181,34,97,2,178,176,185,79,149,227,79,99,121,18,148,233,75,167,243,198,184,148,175,64,226,168,89,46,75,219,236,33,244,200,159,31,95,196,85,49,212,88,39,108,6,137,213,37,104,33,27,177,77,246,80,140,12,58,117,116,248,224,5,130,182,176,108,232,160,57,124,182,17,241,118,29,172,118,20,35,97,130,162,38,55,98,97,134,254,139,19,69,57,185,157,182,111,43,107,156,231,179,255,122,110,171,135,145,116,124,57,182,136,164,82,55,197,12,88,208,158,155,62,113,205,67,93,55,72,126,240,218,190,178,114,148,219,229,94,224,40,115,208,153,194,217,56,178,82,153,12,68,40,89,97,216,78,178,95,179,125,124,48,17,248,36,128,148,39,79,135,178,172,249,208,111,177,99,66,60,121,25,177,161,108,176,87,137,190,142,185,80,212,251,96,75,252,50,167,35,64,11,45,122,106,215,173,98,242,11,96,144,74,35,76,199,228,74,132,29,73,181,193,29,108,92,35,138,210,168,242,247,97,154,143,252,116,175,62,216,169,118,209,233,224,49,149,192,113,174,167,199,202,6,148,66,142,249,82,69,181,157,92,13,217,104,220,79,249,104,92,77,145,226,113,54,144,247,86,45,49,166,79,73,88,83,13,61,138,249,82,219,147,196,60,140,189,168,3,106,46,125,64,212,7,167,149,215,50,84,246,218,237,22,198,225,32,160,211,82,157,209,234,148,192,242,120,133,3,139,188,127,166,248,221,207,151,152,151,117,217,179,160,138,238,34,239,11,11,211,103,109,231,156,20,19,60,238,18,104,209,18,196,230,39,218,127,65,44,30,204,132,77,56,25,33,247,102,125,186,109,82,127,143,40,159,230,102,223,31,79,61,101,46,147,150,27,134,236,63,93,110,241,170,211,98,145,134,23,89,48,142,190,33,151,86,128,190,96,200,192,162,130,3,113,213,180,217,223,139,31,151,28,161,144,49,148,212,91,128,85,208,190,194,47,10,115,140,94,126,212,149,4,3,227,4,130,240,227,236,245,138,125,188,190,97,131,199,82,201,142,155,159,88,159,70,207,61,199,201,87,103,240,42,93,154,168,167,182,97,90,119,82,253,28,85,91,68,221,236,213,183,136,80,237,84,139,40,19,12,96,103,58,13,99,160,218,150,38,89,82,122,205,50,30,182,133,205,154,12,5,41,97,166,179,99,249,43,144,45,221,118,45,23,227,174,251,192,121,157,246,24,136,171,249,61,39,131,139,208,199,185,43,222,114,64,41,147,144,247,67,25,66,42,196,189,55,18,215,163,115,89,72,190,61,74,38,158,141,25,139,55,23,103,117,251,39,239,224,70,173,49,225,150,42,162,48,183,206,171,237,54,47,9,11,135,39,67,10,250,45,153,235,204,34,11,242,148,139,89,42,161,15,175,189,120,13,135,250,159,18,191,238,100,1,59,24,195,232,176,121,207,198,55,151,179,135,178,113,175,174,157,145,126,160,202,183,56,30,203,53,36,252,211,178,156,115,239,228,125,188,82,184,227,69,114,39,230,81,110,106,55,138,41,204,224,94,151,120,160,15,158,185,180,26,55,35,141,59,133,194,198,72,134,229,147,142,107,1,1,131,120,130,109,108,87,248,46,172,37,41,6,175,98,202,131,9,254,215,136,122,194,124,143,162,195,123,224,147,248,135,124,172,29,194,84,155,80,232,128,82,159,21,22,134,32,77,148,1,153,181,77,55,64,208,149,45,36,138,83,95,229,107,214,202,166,218,57,243,13,36,50,151,146,71,156,16,233,25,157,57,112,72,62,41,240,116,104,159,133,190,151,145,238,198,97,237,204,202,28,103,1,235,215,227,101,213,199,114,214,233,252,79,57,57,100,108,206,37,69,208,77,221,104,49,189,181,157,252,51,10,197,147,90,223,207,119,155,136,119,194,72,85,42,170,119,151,8,110,151,80,165,106,207,196,22,252,64,105,207,22,168,183,2,110,72,58,184,148,227,110,151,203,185,139,211,138,190,39,128,39,183,252,141,230,116,233,183,94,125,219,179,123,230,197,185,238,48,122,75,86,37,80,149,246,118,103,3,30,21,222,49,180,14,51,13,190,74,209,105,131,147,235,143,101,152,177,27,153,177,73,96,24,226,86,167,39,28,39,160,83,24,230,172,116,73,186,161,248,21,129,148,15,37,86,115,121,249,70,215,229,9,162,131,227,245,217,142,227,229,244,118,56,206,154,241,176,8,140,99,36,248,153,36,9,27,46,156,202,38,151,48,224,244,3,188,170,42,217,72,26,94,30,86,41,179,205,4,75,83,231,179,29,173,77,146,210,83,233,94,63,87,81,157,118,58,5,246,41,125,6,104,102,15,253,50,203,75,167,247,80,155,132,35,162,94,226,222,138,36,59,253,238,40,155,22,161,184,158,58,214,190,144,148,25,40,246,115,113,59,196,231,42,56,245,87,126,70,66,47,254,18,111,234,112,236,45,90,208,58,21,221,54,198,60,61,231,13,246,62,193,247,69,56,30,82,182,201,103,136,208,146,45,13,134,37,235,150,253,205,220,61,203,59,178,85,244,157,172,129,96,236,237,206,113,2,90,217,76,10,53,254,167,32,240,194,125,8,212,252,3,54,205,132,152,133,229,96,114,74,147,48,138,86,60,61,164,17,184,228,168,71,79,64,118,32,9,248,4,75,162,74,29,227,97,245,242,213,63,6,239,96,104,129,220,179,128,1,73,253,206,158,36,208,28,190,237,130,120,234,244,41,87,85,43,144,164,67,75,34,125,76,252,212,159,185,239,204,218,50,240,3,37,71,211,90,253,66,171,163,44,91,197,69,97,201,119,37,251,8,213,12,213,197,27,234,78,83,193,218,204,165,99,5,252,75,146,12,46,246,130,159,36,240,209,95,62,55,228,186,243,249,193,184,80,197,212,54,148,105,193,0,237,54,168,218,39,174,4,1,243,12,213,153,84,106,59,163,197,35,49,209,150,167,15,155,154,254,103,250,86,223,20,112,2,36,95,232,64,147,237,250,90,42,105,247,20,142,60,240,11,31,34,35,213,81,93,235,11,150,1,203,201,128,160,23,36,26,203,12,181,216,77,161,206,47,128,200,29,193,72,122,134,16,147,255,251,64,227,164,239,26,105,12,84,117,48,147,192,54,161,12,156,101,220,171,178,151,100,253,2,108,210,142,174,215,227,204,161,125,7,9,88,252,29,194,0,175,29,60,216,103,189,228,129,60,194,232,55,190,16,237,14,141,68,211,231,219,69,34,107,107,145,123,145,74,118,236,175,254,172,91,228,28,35,173,170,229,110,116,218,57,179,211,185,239,253,249,241,27,65,119,224,191,50,126,148,27,253,105,95,63,142,197,79,86,217,171,225,36,14,186,1,22,154,86,152,172,145,176,30,125,50,11,225,148,185,190,87,199,61,39,17,43,179,95,133,25,44,224,38,48,234,222,49,108,24,132,247,132,124,64,175,162,109,77,251,71,112,19,21,3,229,21,36,175,19,143,36,24,205,202,248,206,165,24,192,15,52,52,58,235,83,174,218,52,146,188,197,73,81,240,111,194,238,6,204,61,72,137,15,59,145,212,189,27,204,216,181,230,181,169,91,27,73,81,54,216,52,166,150,55,224,172,171,209,205,108,179,143,50,247,111,236,182,124,89,182,174,129,132,24,247,57,3,19,191,188,223,225,251,6,48,176,63,234,113,178,12,135,70,236,110,153,249,10,102,164,33,20,25,23,207,51,209,157,44,244,24,171,201,205,215,75,31,86,40,25,18,22,253,235,160,202,204,106,165,31,166,164,229,125,74,115,23,76,50,197,182,19,52,218,172,74,250,11,13,19,1,102,208,178,141,23,5,180,123,114,160,33,253,105,60,18,225,201,40,143,84,226,221,26,83,98,70,154,176,221,42,115,107,95,16,34,211,22,214,53,4,165,166,234,220,9,220,163,232,62,207,162,232,246,2,0,195,74,41,135,208,205,196,137,247,196,87,53,44,223,92,160,254,122,93,17,188,138,53,63,161,254,52,26,245,133,16,61,119,141,7,53,70,4,8,43,26,31,73,47,23,232,209,147,29,214,240,157,69,81,71,247,176,224,95,104,101,136,52,215,151,246,35,44,132,26,86,200,241,187,83,197,224,200,1,196,223,238,203,56,33,17,31,219,0,6,43,199,20,95,103,85,177,81,225,254,2,211,42,133,44,19,40,48,17,153,130,218,118,17,209,142,38,20,218,221,85,116,105,4,25,8,140,205,166,144,84,156,18,185,153,245,202,25,72,131,167,4,34,49,159,27,160,85,23,72,50,154,190,172,235,89,187,86,155,200,156,148,44,190,194,89,80,148,69,183,178,217,38,175,20,8,252,82,169,169,47,193,147,190,166,67,105,244,203,212,73,62,232,102,5,147,105,207,55,80,100,104,72,237,22,79,137,20,81,83,118,151,36,139,104,89,159,232,17,136,62,254,49,182,89,49,115,19,31,157,17,54,79,36,189,33,93,51,106,178,241,34,122,223,239,109,218,163,174,223,215,86,67,223,184,173,227,160,221,215,5,149,181,231,14,139,102,19,232,167,220,191,123,68,225,4,28,184,85,21,228,251,180,214,239,112,142,52,252,141,52,152,108,41,84,182,207,2,117,130,115,87,204,208,238,182,75,35,42,249,65,130,199,35,40,101,240,49,122,2,7,96,234,163,173,213,99,35,28,72,51,158,32,237,98,226,154,187,190,122,44,53,27,246,241,170,220,59,42,117,10,197,179,220,61,224,32,217,224,46,142,91,11,108,6,122,145,55,139,204,55,36,145,205,187,173,205,13,237,191,111,151,167,144,107,123,105,7,55,126,166,163,198,99,102,159,83,150,224,42,236,3,178,193,46,8,71,235,224,150,105,117,25,198,115,237,114,194,38,215,220,27,20,162,225,217,123,210,36,136,62,54,110,213,32,250,221,111,52,232,80,240,124,136,112,239,248,150,222,234,132,180,117,205,231,113,24,84,22,45,76,59,152,217,208,155,149,113,109,152,238,140,12,191,157,44,23,113,11,118,232,17,89,241,245,79,19,80,221,41,179,100,0,124,30,45,177,15,251,41,131,11,84,229,177,200,35,21,255,98,106,76,199,111,151,64,45,245,216,169,146,253,190,232,225,24,163,189,216,230,49,225,239,94,242,165,66,106,50,133,221,35,46,203,10,119,164,119,25,160,40,108,1,128,162,245,14,215,142,174,231,46,183,14,93,146,88,250,84,149,232,229,90,18,50,96,179,119,104,93,68,156,199,185,219,169,179,125,186,113,115,254,251,63,171,103,251,115,243,122,19,183,172,72,15,250,188,157,31,95,178,147,64,27,8,154,140,176,50,59,189,247,190,145,128,106,45,195,63,148,222,154,115,190,40,161,174,63,207,83,13,14,135,112,140,176,19,118,181,201,128,6,174,182,147,81,161,139,137,233,119,55,159,199,139,190,81,48,110,177,69,121,149,207,152,84,90,193,191,173,48,38,83,100,62,74,11,63,203,164,163,127,43,134,154,15,197,4,95,116,229,88,26,225,39,13,76,165,182,161,217,187,178,231,247,2,133,58,1,46,56,113,202,84,80,229,78,183,230,70,27,99,166,123,189,201,176,140,172,58,93,246,128,139,146,184,131,216,83,121,100,76,234,211,57,153,242,65,240,249,85,32,38,186,140,135,18,195,109,143,165,152,151,186,24,172,196,50,104,230,154,17,26,115,228,169,185,96,96,25,4,67,185,34,45,121,180,4,208,25,221,194,199,71,84,231,182,188,97,94,175,89,7,58,105,114,113,109,220,47,80,93,187,129,92,244,41,59,15,32,125,188,206,126,38,105,250,217,168,110,153,176,88,139,170,15,225,171,126,145,147,205,60,201,109,60,189,178,204,118,131,218,20,72,58,156,205,95,46,146,34,61,196,34,128,113,217,61,214,50,18,91,55,114,122,158,200,229,33,223,47,96,187,221,210,189,135,161,124,242,41,255,51,107,110,228,48,225,137,124,216,81,229,59,194,116,241,16,218,59,192,38,28,2,78,67,164,76,16,103,137,121,27,197,155,242,140,133,35,155,41,181,63,241,100,220,140,144,86,253,85,49,219,249,128,47,124,15,162,4,170,144,184,160,126,185,116,150,146,53,5,76,11,206,38,36,229,44,99,75,89,195,115,12,230,233,31,238,198,148,202,81,160,211,229,139,4,186,206,71,10,194,246,240,103,157,154,182,44,18,49,26,223,159,242,188,170,200,29,141,171,14,151,59,207,22,213,182,180,149,255,181,62,236,39,172,254,61,45,55,217,183,44,250,16,58,136,61,60,113,59,195,248,177,251,27,229,89,244,25,185,175,53,156,233,236,159,25,251,75,138,136,198,207,82,193,79,23,188,38,222,242,168,7,188,181,59,14,249,226,198,29,20,78,3,85,34,73,141,55,156,35,248,3,35,8,94,60,24,182,108,150,194,8,70,219,232,173,121,104,45,49,253,9,21,3,100,174,37,225,100,229,135,7,73,65,87,159,160,37,113,235,222,66,169,73,237,30,44,82,123,181,157,165,198,142,255,249,197,180,155,47,43,85,31,60,123,81,218,53,74,183,0,237,119,254,92,225,114,130,82,137,32,129,240,10,151,25,96,125,6,116,104,26,219,133,207,73,252,95,52,182,201,173,134,147,214,172,5,185,102,116,27,215,134,175,245,191,163,201,166,71,143,137,141,198,60,65,179,66,131,217,217,218,152,216,171,200,64,168,145,182,239,25,18,53,132,49,134,212,60,163,152,29,239,191,221,192,70,24,13,87,81,60,33,89,118,151,73,63,196,186,173,232,135,161,246,58,192,159,254,109,255,251,134,252,146,219,98,131,243,65,114,159,104,124,49,37,65,246,27,83,89,233,178,162,112,238,227,132,224,160,54,207,11,136,100,253,6,124,225,147,63,50,170,112,186,100,163,47,151,224,208,43,188,182,184,9,37,65,158,219,150,1,85,100,51,127,64,125,167,255,180,194,43,88,198,207,117,214,186,158,36,173,49,12,58,87,172,176,161,87,235,158,71,233,95,100,205,90,8,129,7,120,177,109,242,110,42,48,0,36,224,0,87,45,84,70,35,132,220,192,12,14,92,39,154,129,108,176,183,177,127,106,174,46,201,173,105,63,73,229,151,4,96,43,161,8,136,4,26,15,222,178,10,96,251,87,191,212,222,28,191,230,16,153,160,174,136,173,63,14,24,80,108,245,146,110,48,155,76,163,75,194,169,38,54,209,123,67,13,82,94,159,155,128,191,197,148,72,13,157,24,234,73,41,251,94,13,206,5,160,129,165,242,207,16,229,186,12,3,203,69,128,224,223,69,34,142,4,5,70,236,229,37,124,10,51,11,1,173,253,63,101,185,121,66,198,25,23,154,108,133,252,180,130,47,20,15,108,199,169,234,247,211,43,54,32,224,100,4,206,109,4,142,43,223,155,30,134,174,50,43,213,17,58,168,220,48,215,123,122,232,167,247,202,91,23,96,78,234,208,14,167,34,139,205,22,201,160,72,217,254,122,171,118,169,121,7,145,192,101,80,66,11,121,123,123,129,57,19,115,116,250,68,243,222,146,43,81,235,123,237,158,53,154,216,145,183,114,76,202,151,84,36,33,23,195,62,164,143,51,45,1,3,240,144,75,231,122,119,20,238,55,202,160,34,166,138,172,86,7,215,101,34,33,179,34,161,4,193,255,246,223,249,107,15,137,209,8,185,166,187,207,179,1,185,160,156,147,43,85,54,25,208,168,9,202,133,11,36,201,139,238,79,58,206,108,171,229,227,115,240,42,179,189,101,46,212,0,81,173,236,124,168,140,30,12,133,14,194,163,220,225,151,182,84,58,75,13,211,35,12,171,38,155,228,84,132,202,43,35,137,147,14,121,139,40,139,64,74,206,162,120,2,3,115,187,54,128,254,195,251,198,238,51,235,69,207,100,245,17,125,151,177,26,112,183,203,245,216,226,116,228,171,23,44,251,44,216,158,174,37,36,218,75,197,241,69,128,211,2,240,20,213,220,101,181,37,186,99,174,130,20,237,68,31,33,88,190,54,19,117,32,19,167,237,180,172,166,51,172,42,186,89,49,15,124,83,216,97,207,232,27,132,224,190,11,148,96,53,75,181,76,83,53,104,246,176,220,86,168,76,14,38,136,191,199,234,122,61,240,175,60,195,255,84,37,82,102,160,183,54,81,179,172,14,119,9,193,101,76,102,250,220,122,112,219,151,34,31,111,89,36,62,78,50,145,16,63,9,173,245,175,230,164,125,146,210,3,239,221,12,127,78,61,19,81,164,202,222,90,86,178,157,73,148,97,44,146,141,133,144,176,214,214,59,99,253,83,198,76,202,2,98,78,57,15,240,206,121,209,22,1,170,190,118,230,232,112,217,86,93,89,125,168,88,124,199,233,82,182,213,60,165,132,250,45,33,195,210,121,160,20,202,207,194,29,16,17,46,211,108,53,213,118,150,192,60,194,51,242,163,125,138,26,147,192,242,13,210,45,174,15,63,61,109,177,12,146,60,32,28,40,34,187,212,68,178,241,39,1,213,75,206,123,163,179,9,130,59,181,76,207,211,95,50,226,244,64,187,152,203,119,20,219,104,14,243,130,196,82,156,254,28,44,115,81,112,90,3,252,117,5,215,46,89,214,252,180,179,135,168,21,220,176,138,171,194,209,156,225,223,7,207,220,46,47,205,224,59,52,8,56,106,154,21,66,203,154,39,53,189,170,203,96,240,167,112,253,104,191,22,251,55,95,0,248,113,193,242,26,174,227,189,42,209,214,114,141,147,80,241,55,98,105,38,114,215,82,122,10,167,77,70,136,182,150,53,115,215,32,80,186,233,209,118,46,12,49,55,23,204,121,93,166,237,32,212,65,156,179,114,170,65,219,139,147,182,137,84,34,255,34,127,85,107,209,221,4,142,66,218,75,200,145,211,177,80,123,119,198,248,142,27,122,196,63,72,171,88,199,163,69,192,120,205,202,245,216,117,99,186,27,6,204,157,42,253,57,43,116,67,59,134,119,179,16,70,238,219,48,104,140,150,164,182,196,238,207,215,225,170,58,188,255,61,77,106,165,44,102,254,144,214,128,234,253,204,192,175,155,119,242,81,141,136,59,241,150,243,43,21,153,250,150,53,136,102,190,42,8,221,178,198,11,130,176,74,128,191,77,126,35,255,191,161,146,84,35,235,157,200,19,139,129,67,205,239,63,213,206,93,220,231,52,38,40,130,215,116,209,89,50,251,208,42,89,27,112,84,190,136,218,5,250,142,93,38,99,55,119,56,5,73,36,25,230,5,121,20,16,75,228,21,6,27,244,81,202,239,115,65,101,226,245,9,28,216,190,137,253,71,210,45,83,223,45,63,53,158,9,192,133,141,69,218,59,199,97,3,166,99,103,210,243,88,3,87,204,11,254,230,35,201,156,183,2,241,32,184,60,35,141,97,42,182,101,181,17,120,254,170,198,211,96,99,59,183,10,219,217,79,204,116,24,125,53,61,188,135,65,201,5,172,1,187,179,55,54,85,129,189,108,247,179,166,73,102,175,214,187,238,174,194,18,183,160,67,20,8,238,0,187,4,104,205,151,199,3,201,77,132,26,14,16,176,41,239,100,64,140,19,148,31,60,210,118,130,113,255,12,6,203,255,177,204,225,142,111,105,20,160,28,66,188,233,15,254,144,224,52,54,66,2,191,100,97,199,10,56,242,86,243,121,73,118,229,147,116,241,234,33,55,192,249,70,74,254,44,91,71,250,72,77,37,240,123,155,113,110,144,192,155,90,220,155,19,133,63,25,61,77,168,168,47,62,210,170,129,141,161,67,21,178,147,183,105,132,36,169,210,69,170,35,250,163,43,229,254,230,36,62,110,78,24,158,200,92,234,113,72,30,118,156,76,33,178,226,237,126,190,106,190,94,11,205,66,106,239,242,176,116,60,138,68,64,59,187,185,65,58,156,191,89,138,197,40,195,84,182,174,87,181,1,173,90,61,181,109,153,80,130,14,102,175,115,236,24,98,20,174,138,232,32,23,44,105,241,97,229,6,78,87,57,142,69,198,142,161,207,206,132,5,16,86,112,47,125,112,225,128,67,19,174,18,151,19,101,172,121,124,217,169,147,201,145,8,32,189,73,97,41,24,109,136,26,130,103,169,13,149,34,150,104,68,170,157,181,19,137,1,149,113,88,154,179,157,69,204,190,252,4,26,113,112,240,146,139,45,252,41,162,128,11,174,174,36,75,93,205,252,134,27,49,136,1,67,67,163,11,187,192,47,65,122,234,183,35,48,57,25,54,124,154,206,47,165,111,171,144,122,237,25,205,169,58,181,94,154,83,178,158,114,61,106,121,162,148,181,240,47,222,43,210,63,187,172,116,171,190,199,217,142,94,84,70,84,216,253,149,51,103,35,206,231,23,168,58,85,23,73,76,61,221,20,219,15,106,180,65,209,162,2,115,26,23,214,65,79,56,36,225,26,116,143,72,151,181,17,28,191,13,116,33,163,186,33,232,232,147,66,179,195,205,146,49,215,125,119,210,32,56,200,212,247,148,127,100,139,155,163,204,42,154,56,145,69,254,211,88,64,114,151,254,107,53,82,111,215,237,139,108,59,122,64,156,206,182,201,57,34,239,159,154,234,139,91,176,90,53,40,128,2,112,27,245,29,47,21,4,17,64,37,170,13,37,51,174,201,241,138,108,139,185,137,8,65,71,70,187,1,23,234,72,71,178,223,188,195,177,59,244,201,237,13,179,255,226,200,232,228,39,75,13,182,85,161,126,226,47,7,136,187,246,105,123,52,80,245,43,183,105,54,68,40,65,229,158,233,121,238,6,37,124,127,194,133,163,139,24,105,167,227,227,137,175,183,8,73,40,201,13,126,255,78,62,221,216,231,14,192,118,135,204,145,240,71,25,64,44,151,239,70,238,120,147,25,90,125,11,207,49,193,236,199,219,105,201,65,172,189,53,234,254,108,248,24,70,61,93,124,36,91,56,106,147,253,176,188,122,94,35,56,168,213,228,193,129,124,18,46,194,139,32,236,138,211,214,196,186,159,247,200,109,232,3,237,200,58,100,153,137,25,239,227,241,129,175,129,173,5,201,206,144,248,205,107,59,71,182,210,78,34,120,87,83,80,194,89,79,140,173,12,78,66,102,215,0,92,171,89,3,160,185,33,77,82,159,66,230,143,120,249,98,155,212,133,91,65,92,231,93,137,114,227,73,120,250,170,19,220,28,138,191,147,30,243,216,157,224,71,90,111,141,17,162,29,127,86,198,112,151,227,12,30,50,25,127,37,1,123,12,123,203,213,165,199,214,116,145,240,142,121,217,68,214,52,243,250,227,146,211,29,126,225,178,111,122,11,175,176,202,253,25,46,83,184,26,244,3,219,240,211,201,134,170,252,118,101,118,206,95,29,110,141,8,136,10,176,84,148,200,105,96,7,247,40,13,243,138,122,104,150,199,134,141,199,96,141,240,234,172,106,167,100,7,20,153,174,79,226,128,207,45,41,224,218,109,30,107,199,216,160,36,208,93,153,121,68,202,100,90,97,160,102,6,211,109,242,72,126,65,107,220,236,211,35,235,171,92,73,150,252,251,221,28,138,81,134,145,50,92,174,44,26,79,162,155,230,238,204,113,102,118,221,111,41,211,166,127,171,214,167,168,95,172,207,169,251,10,204,58,108,229,44,12,24,168,133,35,13,238,195,101,241,193,194,151,142,216,162,132,160,30,244,255,89,143,203,162,179,176,247,156,218,176,135,38,177,13,255,117,212,39,129,44,90,240,185,108,58,60,224,160,230,117,160,11,6,95,252,100,158,93,223,57,111,128,25,123,184,216,222,88,242,224,214,133,152,237,116,144,211,7,45,188,9,217,91,35,110,189,190,78,191,153,63,96,7,218,57,57,66,64,234,133,150,251,44,225,75,92,181,133,59,111,48,228,121,158,1,75,255,116,81,29,138,10,13,46,52,169,97,140,164,242,119,206,137,102,34,236,168,13,203,81,16,77,92,254,231,70,139,214,132,248,176,225,109,64,193,57,53,0,145,217,226,45,40,30,187,213,28,233,125,231,91,220,23,103,64,162,100,176,67,175,46,142,51,71,75,182,209,56,130,165,138,219,154,74,228,21,45,230,28,62,242,205,77,188,148,21,221,104,150,137,96,47,144,40,192,172,58,209,86,222,9,27,204,242,150,233,120,165,232,104,96,179,218,228,172,76,117,167,178,239,221,23,31,222,94,114,40,184,238,55,12,174,8,178,126,150,204,45,116,160,153,65,185,75,234,97,132,18,29,88,161,174,197,141,171,121,92,156,25,170,12,19,51,36,42,253,76,251,81,222,4,169,180,212,254,60,206,71,223,14,43,160,27,160,223,245,18,48,94,65,41,213,195,152,135,28,175,98,51,231,119,75,244,62,66,46,48,239,176,80,172,162,93,96,181,83,38,83,250,28,122,148,59,20,139,31,229,172,202,217,233,195,21,9,199,253,131,54,37,184,97,216,141,246,115,126,98,217,49,241,109,15,26,114,123,214,97,115,92,36,127,76,30,188,166,122,50,0,116,11,5,85,144,208,129,192,178,187,117,59,134,171,71,107,37,10,128,224,179,140,245,224,29,56,203,249,158,18,186,110,101,202,254,222,221,29,255,38,143,253,179,49,229,129,238,36,107,39,199,3,120,28,103,148,117,210,150,14,189,167,0,79,177,63,183,16,92,12,172,185,48,227,84,104,90,175,201,82,216,38,113,53,217,177,215,70,5,32,17,93,23,221,168,80,94,200,27,247,249,105,107,108,93,7,164,84,171,255,83,212,31,21,252,157,254,3,103,240,235,134,116,23,203,140,89,172,139,49,242,191,223,115,204,167,216,155,44,90,241,45,80,251,182,11,18,111,31,233,100,210,62,214,41,150,45,250,181,77,71,21,35,142,225,129,183,50,81,26,177,129,215,78,108,88,32,69,60,2,242,121,145,115,173,88,0,204,203,175,157,225,20,47,155,38,95,154,19,105,3,223,217,236,44,44,84,155,24,1,49,100,200,75,136,101,227,250,241,99,52,35,135,216,14,120,36,52,194,43,38,33,242,115,231,119,13,206,187,94,173,109,200,55,227,202,248,0,108,113,18,241,22,143,114,202,39,0,213,6,254,131,88,6,171,74,191,112,42,240,233,108,167,144,139,123,198,45,136,184,79,105,218,227,137,231,190,99,182,108,80,140,141,151,4,182,171,195,81,6,120,53,66,73,138,39,21,8,231,216,69,115,43,158,147,234,194,231,243,203,82,49,100,79,39,127,125,26,68,152,22,73,204,220,150,171,98,145,152,221,32,122,110,43,4,249,100,14,20,88,191,32,122,43,142,71,238,130,232,28,247,2,89,13,140,61,171,74,251,56,28,51,26,227,149,59,151,194,54,251,219,245,237,41,83,114,191,77,210,125,13,27,11,85,167,122,172,73,113,41,241,26,182,35,89,135,132,67,142,156,151,164,86,40,150,18,56,248,147,254,231,241,36,244,122,210,175,226,152,213,28,9,175,201,146,231,215,239,59,149,214,165,79,113,61,20,83,78,45,123,137,125,197,10,189,144,139,71,125,229,74,1,132,86,119,88,30,110,31,45,144,32,163,104,66,177,27,252,160,28,111,225,5,234,127,223,113,249,178,237,178,60,80,66,111,30,13,95,95,68,240,211,242,80,248,39,84,20,232,53,223,80,215,44,105,102,149,241,143,250,131,112,154,96,85,198,39,83,56,121,183,125,112,124,54,71,223,28,50,125,180,253,154,149,224,230,140,120,198,82,219,1,234,205,151,0,223,196,3,177,105,188,146,193,246,220,25,108,230,87,108,67,52,116,5,140,82,83,155,212,46,24,253,16,126,31,255,109,251,120,235,164,251,71,177,103,120,97,252,36,115,45,2,8,188,206,166,10,112,28,0,252,135,140,227,106,88,112,66,13,240,1,110,160,190,20,134,57,93,187,213,50,34,104,157,229,171,186,179,191,27,163,68,202,149,87,40,26,183,101,112,116,157,6,163,97,69,186,187,39,213,89,15,123,196,212,191,45,73,222,22,196,129,195,151,193,110,37,137,80,33,24,174,186,199,215,110,239,113,74,123,135,100,140,137,35,204,71,188,56,19,228,86,178,217,248,233,42,70,233,129,94,69,145,255,166,70,67,138,111,9,157,68,60,239,76,101,177,55,223,183,43,145,138,210,141,122,173,50,33,206,147,135,5,32,223,148,53,132,53,117,174,38,145,4,216,186,114,157,99,152,45,232,90,176,175,183,48,180,241,211,206,167,123,115,74,210,64,63,58,88,229,201,4,58,38,166,23,224,179,91,251,141,26,80,67,115,75,48,214,229,15,90,82,7,164,18,22,203,210,125,88,48,47,100,218,113,130,107,69,27,61,126,29,136,151,38,170,120,119,74,242,61,48,146,102,235,189,65,236,84,152,139,211,177,247,45,121,78,24,78,107,5,34,118,146,254,166,204,35,5,10,121,126,44,84,159,209,224,147,117,200,47,187,71,253,230,229,39,144,89,31,186,202,193,47,35,35,84,26,121,255,114,91,106,139,3,201,93,254,180,243,96,28,51,54,15,103,233,47,174,203,250,22,15,30,211,25,148,81,90,114,71,156,205,226,49,13,145,213,20,87,149,16,80,236,243,4,203,10,250,76,74,37,101,15,112,164,119,62,252,4,59,34,69,32,23,64,231,58,245,7,155,181,3,54,181,102,186,31,172,135,28,142,221,245,160,40,164,106,22,177,231,115,133,221,123,237,133,77,214,78,9,51,157,170,76,216,122,44,74,251,106,185,40,186,110,121,93,218,115,145,45,162,119,114,142,163,239,21,89,120,129,52,29,118,36,126,147,140,11,16,126,134,9,251,129,117,183,236,170,214,6,47,78,199,90,10,22,54,71,210,118,30,124,44,188,19,112,193,20,218,34,118,146,30,67,255,171,148,143,125,160,49,240,183,3,184,100,163,56,182,187,8,1,247,148,105,223,74,15,74,74,26,183,60,95,246,17,252,51,216,205,190,105,108,220,22,229,75,68,50,51,136,7,81,253,50,155,239,38,17,135,130,238,96,222,6,39,106,9,45,147,237,120,157,117,122,77,205,227,160,112,205,128,5,194,46,79,250,209,36,235,182,66,226,68,153,75,0,119,150,231,71,183,34,60,230,243,56,58,90,147,230,169,170,191,108,212,214,199,56,82,97,20,104,147,89,24,43,102,38,223,72,229,85,235,150,136,95,2,253,138,158,177,237,32,14,220,121,132,157,69,131,45,229,166,232,147,219,130,183,183,238,46,55,164,93,50,24,113,164,253,20,213,97,6,251,120,94,18,91,59,116,126,70,201,77,136,251,77,0,239,68,226,66,116,230,176,43,251,134,184,231,241,151,238,238,214,152,82,156,43,103,220,150,102,113,88,246,203,172,222,50,106,107,127,234,26,244,109,133,28,187,39,42,251,66,55,227,219,16,192,18,191,114,23,134,116,72,218,164,52,165,0,184,42,38,6,22,206,179,255,197,123,43,237,226,116,37,94,34,69,119,94,79,196,49,158,190,14,94,88,180,57,195,93,204,202,24,168,109,171,246,62,22,171,101,95,253,150,108,183,129,163,8,172,233,162,107,155,64,41,112,69,9,14,221,239,76,147,132,70,34,158,236,17,134,186,84,107,119,147,244,56,169,21,173,62,53,173,136,33,188,51,53,58,106,92,253,21,119,233,217,212,252,116,94,0,57,169,178,50,107,238,149,172,0,61,157,207,212,235,123,116,151,62,252,217,216,1,129,182,194,211,209,151,221,137,232,155,144,194,39,245,5,222,128,227,0,0,0,250,196,29,55,254,208,67,11,71,40,117,250,142,46,153,17,106,25,197,239,178,41,121,29,168,141,242,127,7,192,87,51,171,179,136,179,168,230,16,45,75,154,233,39,177,236,230,158,142,144,205,45,33,39,28,42,114,66,220,37,232,58,217,170,105,127,29,44,193,108,77,161,78,37,179,111,181,99,30,235,230,128,203,141,1,153,43,140,128,195,30,79,54,150,192,83,254,254,180,251,194,147,238,60,30,202,20,126,155,234,161,82,136,246,212,167,47,106,251,226,142,10,203,180,68,226,226,253,191,34,30,114,196,104,146,50,141,31,11,40,138,226,159,2,188,241,164,185,152,23,127,245,110,84,46,108,133,81,116,223,136,142,26,138,11,254,102,68,195,209,217,34,74,98,237,141,91,12,54,162,222,7,15,75,111,97,18,58,223,121,71,78,197,29,246,24,0,138,96,48,221,20,146,144,218,122,193,161,139,138,160,35,103,99,222,120,189,106,47,67,107,201,42,120,0,243,87,76,188,31,103,7,207,87,201,212,171,66,53,54,191,24,40,221,137,141,217,224,101,213,177,159,195,32,47,248,68,219,0,69,237,193,101,245,117,78,9,68,77,101,24,197,11,2,10,0,69,32,3,22,43,191,237,198,174,36,38,234,208,25,124,212,157,183,129,165,221,36,41,123,248,99,140,29,17,45,113,74,210,186,205,206,46,248,232,0,147,74,241,105,219,8,110,187,54,40,120,102,93,148,49,69,17,184,100,160,124,2,126,168,219,211,110,250,240,189,204,24,20,222,220,248,45,169,159,23,56,190,58,239,83,35,135,253,97,73,225,2,233,29,60,219,229,68,208,205,87,145,175,123,31,115,7,72,116,12,48,209,101,58,86,64,110,77,114,207,38,182,15,63,248,204,232,54,231,171,211,112,128,155,210,30,137,155,83,28,139,131,38,173,78,50,205,190,244,143,47,76,142,150,154,153,255,207,116,10,138,135,189,148,61,138,80,63,150,144,120,119,172,197,91,44,84,51,79,148,142,77,16,97,154,69,168,174,206,198,12,58,143,66,198,37,141,112,116,128,27,89,247,0,10,111,224,57,165,37,229,250,216,143,151,239,156,233,100,118,116,133,47,154,171,164,43,246,113,85,12,221,178,44,45,3,88,255,163,183,149,44,253,9,121,49,105,229,153,141,205,75,99,16,163,169,121,103,59,97,204,246,20,39,230,71,130,47,222,120,96,158,99,104,67,210,246,119,149,237,80,121,114,52,47,186,125,171,37,155,115,12,189,242,1,117,4,232,57,209,158,116,13,94,212,7,63,40,63,43,253,212,219,137,68,107,154,112,64,224,183,180,79,65,248,29,16,234,199,196,58,124,96,246,253,104,92,199,189,176,63,201,57,29,202,175,106,124,160,139,32,43,85,47,150,163,60,74,125,72,87,61,218,100,175,88,191,146,144,11,238,107,74,134,73,164,234,220,44,194,226,18,48,199,151,58,67,131,117,182,207,148,240,95,180,78,246,159,124,131,134,176,150,43,147,53,194,54,94,184,76,193,177,210,205,174,79,60,73,94,143,127,226,79,117,56,19,242,85,138,210,107,105,147,72,89,46,35,33,45,100,65,82,92,212,206,255,77,201,20,33,248,11,41,222,86,159,115,44,143,10,23,13,121,223,244,126,87,52,177,243,223,140,182,203,78,60,226,124,169,2,219,205,32,73,83,228,20,64,42,109,145,166,233,74,7,163,232,75,27,134,202,67,23,100,160,140,6,171,101,28,34,230,133,46,54,151,119,229,218,227,177,57,152,113,189,24,137,188,3,34,162,106,23,166,160,24,23,223,127,94,150,103,23,96,202,104,240,70,99,214,242,103,121,218,69,159,177,227,201,123,20,102,90,180,56,61,65,104,118,113,42,83,160,237,253,194,97,22,181,198,49,87,182,131,60,13,210,57,28,55,200,159,142,189,156,238,231,20,144,240,177,10,142,21,238,202,242,247,102,47,225,177,240,241,73,37,81,132,237,218,112,116,214,149,26,130,134,134,123,223,173,131,0,150,67,112,92,53,231,23,195,27,42,29,189,92,8,93,61,173,20,179,192,18,80,151,228,162,182,110,16,56,165,171,79,120,58,50,155,50,97,22,220,40,219,88,69,114,57,221,29,187,235,20,141,224,150,223,20,242,15,139,38,156,134,142,59,229,118,23,27,104,86,255,73,18,214,110,9,252,170,85,76,70,95,56,174,245,206,171,155,120,243,43,162,97,69,40,175,156,188,228,135,250,107,99,126,64,127,149,82,199,48,171,234,85,185,47,177,85,55,189,112,91,235,197,37,253,62,145,107,148,7,33,111,29,218,207,228,206,104,50,229,118,199,247,194,129,38,134,166,93,211,143,234,174,99,16,159,41,60,179,184,15,135,183,71,0,250,135,200,99,29,177,89,228,234,155,14,67,249,151,124,113,98,53,222,79,166,25,83,157,98,159,172,69,8,27,169,62,68,147,162,182,138,79,65,157,23,142,198,168,6,77,7,166,47,152,141,178,198,50,46,189,166,152,14,164,123,92,22,21,0,43,242,142,169,22,226,51,210,183,226,182,163,188,65,4,6,150,176,205,127,71,77,80,179,37,168,169,104,107,1,57,35,40,94,232,112,115,232,83,158,69,204,125,135,23,117,198,28,19,246,231,165,222,231,123,51,30,179,26,14,80,207,48,185,193,125,19,55,121,150,57,23,196,115,160,94,43,60,54,240,49,20,178,59,62,236,43,189,125,143,171,153,187,204,73,90,73,180,6,9,3,30,221,37,32,39,122,139,174,49,215,77,137,10,72,64,75,101,57,41,41,91,243,140,112,214,216,93,165,100,13,187,223,45,52,37,204,69,3,160,242,154,77,104,15,177,60,60,26,55,196,176,152,250,249,179,197,50,100,210,131,46,208,206,78,30,216,156,216,0,92,241,202,218,36,165,26,39,155,69,210,10,128,173,219,24,116,219,198,33,252,249,221,195,81,215,125,123,148,207,162,100,106,108,114,143,28,98,251,148,85,48,208,155,225,75,225,139,125,59,121,156,75,9,109,70,210,243,140,243,192,12,45,151,34,250,66,24,247,184,63,229,51,130,66,182,214,222,144,213,4,45,173,159,141,228,173,26,92,119,90,48,141,112,40,91,148,88,165,35,241,51,94,232,101,54,161,241,14,62,98,36,98,178,241,103,25,37,38,154,36,68,201,251,59,164,11,132,106,63,183,105,242,205,84,56,59,3,243,100,35,90,242,163,163,213,176,208,4,184,198,106,221,157,77,177,38,198,178,82,71,135,44,132,40,57,101,173,144,169,159,234,87,50,40,162,248,201,133,137,97,6,16,161,57,196,160,201,213,55,246,223,53,157,0,24,236,112,243,218,248,140,109,222,106,230,232,119,187,20,124,225,29,241,181,127,142,30,105,193,5,18,141,129,15,36,153,187,193,230,253,53,71,89,126,239,152,227,108,98,236,245,109,166,206,213,59,247,247,41,138,246,208,72,80,138,50,141,236,3,168,205,98,191,8,85,221,29,93,100,58,103,146,77,242,77,84,195,201,179,69,184,91,142,240,166,8,242,112,133,208,21,119,125,201,85,218,73,47,201,226,227,167,28,192,226,25,111,252,143,33,245,231,87,199,80,15,27,148,213,253,255,48,210,6,92,213,181,6,199,204,164,230,253,16,177,48,251,252,58,70,106,78,62,96,52,10,168,116,208,203,234,164,228,204,99,195,250,181,241,227,100,102,212,48,82,203,25,207,218,218,163,55,156,109,123,48,70,86,177,31,12,211,255,167,12,231,145,160,208,109,143,1,13,33,32,7,137,223,195,26,182,170,8,254,34,11,198,198,37,46,36,75,127,237,116,127,228,66,83,45,221,227,39,55,215,107,175,80,29,230,71,214,176,64,96,234,101,187,118,238,228,211,22,126,20,202,246,186,82,219,192,181,192,95,174,117,171,4,158,98,234,240,14,242,164,28,83,103,110,94,209,128,172,178,115,31,172,244,174,155,94,44,211,29,194,214,190,221,152,159,198,251,220,14,22,63,133,128,83,153,219,136,242,159,243,212,152,5,192,209,97,46,153,223,45,34,32,182,162,145,203,202,229,25,98,195,56,149,239,105,222,95,89,96,237,83,157,199,41,125,135,235,94,105,199,141,55,205,247,70,226,105,157,16,229,199,5,12,99,148,55,96,174,34,67,27,48,93,206,8,115,31,242,157,204,98,193,127,16,193,28,70,165,226,236,8,1,11,191,15,7,224,130,215,113,97,108,45,42,142,8,0,78,211,230,97,161,40,152,186,5,141,171,21,57,188,37,230,18,41,201,174,148,126,218,117,139,187,237,141,245,135,252,43,34,3,226,213,143,69,90,199,76,50,1,191,43,237,173,174,115,189,68,245,65,38,119,93,215,25,226,125,21,109,224,215,91,202,101,168,214,83,180,38,208,6,56,84,69,191,216,53,246,97,155,88,86,244,134,138,231,146,156,242,203,73,70,96,153,225,233,135,106,198,45,122,89,64,127,81,132,38,208,51,233,16,241,67,161,116,223,251,28,174,133,92,83,93,96,234,50,193,117,32,83,240,35,145,255,91,125,229,194,31,57,165,204,158,34,186,81,147,229,40,76,193,215,111,250,143,35,28,184,172,201,176,155,70,68,8,161,17,197,157,202,25,44,5,139,226,240,191,242,85,150,244,133,31,232,91,3,24,4,131,113,21,243,174,167,17,93,139,137,29,156,3,102,55,214,196,29,68,94,178,99,114,218,225,188,235,223,27,189,140,48,20,94,253,225,62,236,58,140,26,31,36,222,54,43,29,137,204,241,141,120,56,196,235,145,242,83,215,14,131,223,140,13,30,136,8,104,33,96,232,114,117,170,116,73,156,105,94,118,238,37,115,2,33,48,75,248,241,18,104,193,2,34,166,57,96,236,171,37,238,106,224,38,89,123,17,159,40,21,19,202,14,233,185,250,54,109,61,162,91,250,194,254,200,66,151,130,188,223,61,24,144,70,22,87,132,74,19,68,203,114,43,66,214,247,243,239,44,64,210,58,177,183,171,48,6,20,17,37,199,75,140,236,189,202,117,94,132,37,11,178,72,137,98,177,198,232,31,192,19,65,174,215,174,148,229,163,156,98,190,46,229,130,190,255,251,10,22,87,94,239,60,62,246,121,239,153,224,242,117,243,136,30,5,39,33,34,156,77,229,28,189,250,235,77,161,185,44,1,157,202,207,167,46,138,205,140,72,107,79,206,212,23,222,12,12,162,215,95,228,107,224,228,71,79,107,237,184,114,216,55,148,134,129,131,68,100,95,171,64,39,254,179,247,22,85,55,90,94,131,97,68,24,192,161,231,195,15,230,58,87,216,217,146,137,63,166,142,138,93,12,172,42,56,49,240,243,78,230,170,27,146,9,253,158,155,179,189,3,176,53,30,88,162,25,145,231,250,228,51,163,243,115,128,72,252,43,254,107,49,122,223,59,38,63,2,79,32,85,127,238,6,166,204,226,119,219,213,181,167,42,203,91,121,60,244,85,253,170,107,64,26,101,58,102,106,166,239,132,243,216,177,125,198,71,222,30,159,120,232,253,81,42,24,167,155,204,153,146,84,180,49,54,115,25,232,52,149,154,179,138,116,55,109,240,185,24,111,80,127,56,179,148,89,130,219,168,245,218,85,26,229,95,21,147,154,97,123,79,215,191,210,13,191,182,57,228,88,209,136,23,152,132,33,28,38,102,25,201,11,167,157,67,111,31,147,186,142,142,167,231,3,166,238,186,6,76,69,234,170,232,35,92,2,229,150,149,214,113,81,145,124,178,103,215,96,200,113,160,59,132,164,6,187,103,43,133,176,181,176,2,95,179,55,43,160,255,28,144,194,228,15,93,39,195,219,157,230,209,163,13,208,81,125,137,253,34,5,242,159,68,52,199,115,119,206,50,34,33,215,94,139,50,142,58,67,251,242,81,254,117,43,38,188,173,238,232,15,122,74,71,244,227,249,86,23,95,137,248,87,237,39,168,144,40,252,33,226,84,113,233,225,136,114,23,121,99,78,66,239,113,107,74,60,123,140,194,122,224,119,28,33,4,138,220,83,120,12,139,12,172,132,4,24,70,237,43,225,65,186,84,60,127,123,63,163,252,96,41,246,95,190,115,75,125,184,189,247,170,55,27,67,47,207,159,92,154,63,87,48,9,85,112,6,211,123,30,46,50,235,12,83,87,185,116,94,92,182,251,178,41,159,245,227,177,141,203,19,132,175,22,219,189,74,230,12,44,245,41,65,236,210,171,146,228,12,72,49,238,142,162,113,213,155,51,132,134,48,71,113,90,161,150,201,224,201,155,72,54,95,132,154,49,51,200,242,167,80,115,250,255,198,214,233,134,14,107,222,213,125,51,214,171,164,69,72,219,197,116,97,57,234,196,61,244,177,107,123,194,204,201,242,251,4,135,35,71,135,35,171,112,238,140,2,99,20,154,61,27,0,122,172,73,230,80,19,33,55,214,30,239,210,29,111,149,104,184,22,249,25,245,8,139,85,142,0,179,102,236,121,5,28,209,202,33,30,254,74,140,1,53,215,174,48,117,247,188,99,14,93,1,156,239,25,188,197,211,188,180,204,31,97,179,84,193,104,217,183,201,207,81,139,253,192,213,159,5,241,187,250,214,80,254,60,239,247,82,103,63,137,76,122,114,121,203,152,188,157,31,140,172,202,42,254,224,184,218,229,194,99,47,55,136,167,150,72,91,194,208,181,86,87,50,206,26,88,39,152,28,97,80,213,93,84,33,211,27,72,152,115,126,212,191,58,210,19,118,58,11,255,18,63,150,3,110,142,117,127,211,138,242,224,232,45,248,33,137,141,115,136,10,45,133,188,187,11,61,204,83,157,63,71,91,68,224,253,14,141,219,152,244,158,49,4,200,75,84,10,248,65,188,226,65,62,225,8,157,158,219,133,181,37,38,191,219,108,160,155,129,167,169,12,157,13,81,170,218,13,153,68,123,85,184,141,134,201,70,40,176,194,161,107,79,239,211,172,180,88,80,74,70,18,108,164,129,72,120,144,249,241,250,25,178,253,246,40,18,194,27,59,180,167,39,70,100,239,131,136,65,243,143,146,63,184,9,20,144,245,69,46,213,97,252,47,242,235,236,248,191,123,212,46,75,111,114,144,71,178,30,115,84,93,30,97,16,222,197,194,44,24,67,167,14,139,173,182,174,31,247,103,28,12,235,203,234,226,41,200,123,96,244,235,35,20,100,94,137,217,220,51,159,4,25,71,0,207,131,78,69,221,105,55,92,133,181,188,76,63,183,130,182,53,241,178,251,73,25,152,185,56,225,120,72,7,55,18,37,112,170,171,254,124,129,178,69,1,106,238,186,119,215,69,26,106,224,14,205,178,88,25,5,144,71,13,187,199,113,66,232,170,73,153,186,158,207,142,69,92,52,38,47,151,7,104,89,8,241,125,174,216,200,89,18,229,140,246,241,47,24,115,229,78,14,86,43,8,231,194,18,107,51,163,152,2,107,143,7,144,134,94,53,186,85,70,57,236,170,102,77,127,176,244,246,73,14,31,157,90,201,42,214,33,205,53,36,241,223,21,50,186,231,236,98,156,69,178,86,246,43,204,45,0,228,55,3,207,142,211,246,33,18,61,73,190,204,78,124,31,134,37,98,12,89,65,102,70,6,54,71,160,196,205,37,139,237,209,142,98,221,3,197,204,145,35,165,209,182,165,250,195,93,12,203,201,247,188,105,205,225,126,204,37,242,47,249,163,222,242,143,5,185,243,90,191,245,82,77,10,1,87,206,176,190,251,172,211,202,112,68,169,206,96,60,98,103,6,37,52,95,219,163,123,126,41,113,36,105,168,229,60,105,195,24,46,241,174,51,169,136,30,157,61,235,190,89,85,127,46,48,64,153,106,225,79,85,209,169,182,41,124,198,205,178,226,116,235,135,123,161,217,247,135,240,239,76,90,94,70,188,53,65,66,167,233,176,119,32,149,250,51,95,226,246,120,153,12,33,211,50,122,111,194,83,5,255,9,31,236,136,187,196,200,56,42,157,75,9,232,183,206,243,217,51,72,136,47,53,17,50,180,13,87,120,154,247,79,157,88,254,72,146,129,88,144,188,34,37,97,42,26,97,184,65,148,8,159,94,59,188,44,103,150,40,178,180,246,92,205,31,41,103,90,246,220,23,34,74,179,230,128,180,124,1,84,23,161,93,114,126,82,124,195,21,108,35,110,78,76,53,167,126,174,205,74,83,144,153,202,103,214,194,237,3,66,60,151,87,203,90,214,22,192,221,95,242,111,82,183,135,97,238,126,194,160,175,208,155,254,30,249,143,173,206,255,171,139,156,146,174,24,42,204,151,232,221,234,202,21,134,194,137,8,174,71,202,210,114,89,139,217,132,70,117,13,46,217,152,255,46,191,235,67,60,198,4,144,1,132,32,17,20,224,226,13,38,148,22,9,16,79,102,135,105,140,88,2,68,80,149,66,125,159,36,193,86,189,194,17,3,54,71,82,132,0,28,228,131,91,181,31,162,66,146,231,106,84,122,30,203,133,153,84,24,199,70,133,30,254,66,15,62,89,198,102,170,255,158,232,157,135,215,173,32,254,186,18,190,22,30,42,165,228,249,3,121,76,50,18,12,185,122,10,248,84,49,82,67,178,207,4,73,176,111,206,71,23,217,66,159,51,3,10,143,62,17,157,92,135,235,112,151,28,77,116,222,222,114,13,118,57,254,9,181,165,29,65,5,61,189,14,149,102,239,225,66,33,2,5,166,230,154,79,38,46,175,59,33,86,181,193,251,6,11,22,109,57,176,235,192,253,41,12,59,162,87,138,151,216,222,34,97,197,208,197,85,250,246,140,125,221,135,90,154,196,98,161,16,91,153,79,0,230,243,26,15,123,240,85,253,88,1,45,205,238,116,134,202,121,36,158,210,212,62,122,117,154,41,49,41,146,74,182,135,63,153,131,19,216,92,240,164,177,62,103,207,240,39,172,161,7,229,133,101,233,6,156,179,217,106,177,190,0,60,227,77,121,29,42,176,44,19,186,179,116,249,225,32,43,58,133,206,222,181,54,18,26,80,209,44,81,232,82,249,79,100,234,44,215,198,168,85,72,154,232,30,121,67,127,185,43,163,49,255,60,53,65,144,154,218,73,144,42,20,130,143,182,28,234,194,55,99,117,60,94,98,74,74,117,176,145,76,83,147,108,59,110,175,230,118,161,182,115,148,120,148,87,224,135,178,175,126,234,101,175,183,80,130,56,182,84,107,53,221,146,141,222,5,231,157,94,139,113,64,104,196,47,186,195,58,146,100,19,219,17,71,98,215,223,30,82,161,169,210,177,44,174,135,61,232,56,230,90,233,137,213,253,249,115,220,130,251,169,231,241,224,25,47,132,135,2,126,127,78,163,34,74,253,132,82,67,83,10,13,210,74,104,98,98,233,112,120,169,66,254,89,116,92,32,64,210,91,206,67,32,89,113,218,198,214,206,83,203,93,153,156,136,108,129,7,10,61,134,216,33,96,232,26,41,214,42,14,36,145,95,61,54,72,142,140,155,190,100,54,24,195,51,31,180,197,160,65,255,30,197,63,72,21,123,234,56,31,43,229,126,240,22,133,57,160,158,11,201,0,64,30,120,120,174,81,48,16,92,92,99,181,56,176,33,65,73,102,90,109,59,162,197,201,144,39,121,75,249,82,86,233,140,231,95,159,145,202,65,188,104,161,146,150,98,188,176,157,214,88,253,107,144,133,160,121,43,39,46,87,220,114,91,208,248,130,221,16,230,114,143,202,212,208,198,230,141,150,188,11,113,54,253,56,93,251,65,182,120,151,163,8,249,239,59,214,119,81,50,199,2,62,251,221,151,29,53,77,1,76,174,192,75,174,11,139,38,227,255,167,91,85,46,109,132,18,56,72,47,47,222,154,217,52,125,32,131,117,46,248,157,50,70,17,72,48,24,239,81,130,239,102,206,6,188,193,253,107,94,106,97,79,201,253,81,171,140,101,28,0,255,153,141,151,37,251,225,199,47,162,99,36,170,176,51,182,216,132,194,71,167,84,196,83,248,197,219,77,88,79,173,79,223,70,235,187,168,162,135,225,82,19,227,219,166,67,57,13,33,85,231,3,229,131,153,217,116,176,225,245,95,243,149,55,35,159,34,41,229,152,137,91,164,70,81,172,227,255,92,229,20,237,171,34,164,199,203,223,15,182,118,169,60,41,237,29,226,175,66,125,247,240,113,182,158,102,120,60,211,73,3,248,215,48,89,92,255,202,150,2,238,108,211,72,121,225,173,150,200,29,74,161,30,144,42,252,94,191,231,225,80,234,141,192,155,214,233,236,70,158,213,39,224,247,223,235,50,238,121,41,73,59,4,219,215,108,225,53,113,173,229,39,189,184,92,226,64,214,243,158,43,167,121,155,4,223,86,236,25,188,174,211,31,101,226,17,124,19,213,51,18,133,201,21,101,11,11,207,241,77,150,157,235,34,173,155,143,77,71,219,62,7,219,248,81,190,195,168,244,241,151,40,210,62,126,90,237,32,215,11,223,57,197,46,15,189,69,9,178,145,106,139,84,45,114,214,76,149,235,22,68,143,126,208,109,130,45,84,189,110,242,173,154,53,165,92,85,208,112,166,207,75,195,127,47,39,5,164,3,253,182,238,16,123,173,226,241,121,243,148,64,209,94,163,254,35,225,29,211,133,236,227,186,238,32,208,17,153,8,210,84,123,61,141,244,34,134,237,232,175,84,132,27,190,130,147,86,94,126,1,218,224,138,80,100,207,7,30,132,155,36,73,42,196,93,62,10,117,9,19,238,84,96,9,232,27,92,111,63,136,93,93,247,242,95,241,206,37,63,191,243,167,78,134,123,145,246,56,152,215,112,54,154,173,92,232,113,128,109,202,214,77,217,82,98,241,232,227,232,30,94,39,31,89,151,48,184,144,236,109,69,79,95,149,180,140,213,250,245,199,81,206,84,101,59,51,44,192,45,30,196,29,37,108,196,51,142,31,131,125,75,123,137,233,246,169,58,100,42,206,15,170,179,129,38,138,144,206,235,4,171,120,132,11,57,125,148,138,161,207,138,126,41,55,228,203,196,84,104,222,2,213,138,52,155,129,102,119,225,155,67,111,224,189,201,236,56,76,244,204,50,144,112,119,202,69,115,211,91,193,222,21,193,98,3,113,85,240,153,228,99,202,14,43,48,235,122,246,207,245,223,14,63,49,157,52,248,131,213,148,156,68,40,236,53,43,253,177,177,97,9,0,94,233,232,119,154,102,122,216,162,208,67,252,11,29,110,180,87,139,136,151,172,114,247,69,96,226,223,232,33,98,17,73,251,221,2,114,33,63,163,167,73,67,91,31,197,222,226,103,218,184,129,19,111,51,40,153,161,149,100,46,195,42,166,34,197,208,102,30,223,142,166,210,146,129,77,154,21,200,126,189,39,88,215,105,74,207,181,82,27,117,87,48,24,74,107,30,102,36,46,23,189,124,89,187,103,115,122,240,75,88,70,182,220,229,187,183,50,96,93,120,29,163,145,254,174,123,2,14,84,222,134,165,130,114,231,207,13,40,73,22,95,119,93,230,62,255,220,237,197,117,39,106,161,187,135,217,66,133,252,152,41,242,244,103,57,217,48,230,138,111,253,60,134,40,196,244,209,37,70,110,185,149,65,187,219,238,243,107,55,191,76,43,68,252,113,38,222,121,234,112,37,241,198,134,198,42,244,108,120,90,115,237,6,94,226,79,108,27,203,184,254,80,8,37,117,93,183,161,204,72,231,70,120,248,223,44,252,69,51,145,78,75,158,226,150,178,18,38,27,207,192,191,229,40,9,20,150,204,150,47,230,4,5,168,59,139,246,155,107,202,248,63,3,252,203,139,182,120,231,52,44,211,3,230,54,207,50,85,48,97,176,225,181,43,229,25,62,31,194,212,130,230,184,201,97,237,12,150,111,129,119,215,49,8,178,119,42,138,172,18,132,198,3,47,188,16,116,208,80,107,28,249,155,251,42,13,130,220,120,145,179,11,133,128,47,202,219,119,240,178,89,108,231,175,184,73,211,43,205,197,141,10,193,47,110,58,59,155,134,124,69,152,114,57,163,151,18,180,91,219,198,187,169,196,179,188,120,42,250,107,142,148,253,248,5,224,251,59,39,66,171,43,246,227,221,35,24,123,147,3,252,132,56,212,248,65,34,47,52,230,32,141,4,115,26,59,196,33,60,96,74,19,6,14,220,105,84,43,89,145,224,179,112,20,195,37,58,207,102,36,29,113,53,240,31,228,143,145,51,247,13,189,231,67,234,69,49,180,22,208,27,237,107,24,127,246,196,172,134,121,67,132,233,253,174,110,115,73,119,36,144,127,38,115,82,13,253,41,100,61,49,19,89,158,158,56,167,211,141,18,23,71,210,190,224,3,175,195,97,110,68,156,184,234,236,65,122,153,3,225,232,95,242,51,187,135,113,147,175,206,124,190,145,34,146,65,234,134,38,141,18,33,97,189,233,70,158,106,11,28,16,253,151,194,58,31,133,190,86,50,169,162,35,132,75,119,167,113,157,212,177,69,237,58,187,7,8,234,10,110,231,227,118,17,65,102,16,132,149,86,125,171,2,93,90,95,54,166,254,4,156,26,175,69,12,12,233,20,147,88,253,47,20,88,210,212,185,169,100,72,195,162,73,67,212,81,3,220,123,19,167,132,254,209,130,143,20,245,83,2,179,50,190,169,29,201,8,162,33,1,165,170,178,64,85,150,54,52,158,43,37,185,13,90,61,44,202,126,248,18,219,137,96,180,33,245,146,69,102,29,255,9,228,109,196,177,73,183,149,80,64,48,199,255,243,45,154,203,88,100,65,18,193,14,199,244,70,123,110,94,24,221,140,166,96,17,157,169,160,70,242,120,178,62,143,84,253,79,36,201,87,151,146,153,199,95,166,125,29,205,136,197,203,16,120,169,146,108,254,217,154,181,226,93,112,70,82,13,244,53,221,99,41,52,100,147,100,237,237,97,215,230,199,102,2,19,145,161,154,162,115,164,233,45,72,29,216,8,193,60,49,169,147,22,195,34,250,250,126,143,251,189,61,42,167,198,186,161,138,135,123,131,234,30,88,33,229,135,49,118,124,213,98,177,54,253,44,13,183,130,228,238,8,23,43,182,205,216,78,174,165,244,228,118,64,44,239,107,125,193,138,88,75,53,201,30,129,67,227,103,109,247,1,243,42,253,208,55,118,175,250,224,83,74,58,102,136,166,166,236,147,236,51,64,9,226,169,186,139,227,96,198,28,9,214,112,59,177,137,8,252,151,121,218,195,152,134,24,43,76,48,5,225,128,159,166,255,0,40,32,115,34,128,94,9,11,141,68,49,102,158,246,153,81,4,24,122,194,220,1,118,23,176,93,1,213,239,56,186,122,64,114,165,123,56,244,204,154,115,89,10,147,92,95,192,240,125,150,203,233,170,24,255,120,48,98,107,228,71,178,99,207,244,31,81,182,176,91,8,206,82,118,33,67,127,102,148,47,136,52,218,124,64,186,100,188,184,72,165,83,128,62,106,68,75,115,122,131,161,170,131,124,172,28,95,189,236,87,105,203,194,99,113,50,161,120,213,193,16,113,90,37,176,167,47,46,236,175,255,5,5,125,103,45,112,147,236,201,202,33,204,198,83,61,204,176,127,142,52,199,15,69,244,129,200,96,60,90,206,75,6,118,90,49,76,182,203,244,169,143,3,91,171,188,131,60,80,214,72,80,21,47,21,115,13,181,143,75,78,181,161,24,137,40,54,122,0,58,211,122,212,44,165,59,74,3,121,23,43,178,170,192,12,240,83,96,11,112,9,203,81,143,73,214,160,61,21,17,173,128,80,28,53,171,206,140,130,237,149,85,91,150,86,144,169,77,150,191,204,146,200,26,231,160,138,117,126,99,137,162,106,211,55,242,105,22,29,176,141,203,23,25,143,195,62,97,178,187,114,145,167,199,237,50,174,4,165,169,16,25,207,76,102,222,159,59,42,75,192,113,81,3,195,78,202,85,133,88,75,246,43,254,205,16,150,159,55,147,40,74,229,173,224,45,184,40,147,91,111,197,8,197,72,90,124,34,227,222,35,22,69,121,245,65,24,171,233,16,128,177,168,34,117,186,198,146,132,9,52,27,250,140,254,78,118,134,142,16,114,62,190,251,119,172,168,148,64,33,113,216,114,214,65,153,202,235,114,136,179,118,55,8,245,55,108,227,120,15,243,140,160,127,138,220,180,119,225,3,139,37,120,145,99,218,253,245,119,136,121,242,19,201,119,27,252,214,28,69,150,117,253,13,247,140,142,151,192,71,209,255,114,102,5,238,84,157,25,91,31,111,178,249,102,127,133,253,227,133,111,105,102,155,34,229,69,213,11,118,42,175,169,156,181,21,207,62,102,160,184,135,103,137,132,86,167,79,136,32,46,97,242,47,93,139,1,137,112,84,176,169,95,161,171,93,233,61,181,75,124,121,170,62,105,123,223,146,69,154,23,30,182,146,227,193,81,236,139,188,90,107,193,62,46,164,64,10,84,182,65,32,17,235,79,19,111,222,214,13,150,95,66,248,88,158,22,71,143,228,195,33,203,41,14,226,19,154,221,244,100,9,144,236,131,135,163,143,42,188,171,88,94,136,246,110,34,209,63,151,221,146,160,237,133,145,37,126,147,135,67,182,255,88,22,157,255,248,209,215,141,28,162,19,211,70,73,144,243,47,129,237,234,107,58,61,225,228,169,220,254,95,125,124,74,96,123,196,220,193,111,118,174,13,102,96,76,127,3,163,101,161,207,143,113,187,97,187,156,89,243,141,141,71,195,127,164,81,193,6,84,84,162,141,11,78,27,230,57,180,230,24,100,92,13,13,24,218,243,159,121,165,116,135,25,223,144,253,225,40,21,76,239,226,131,146,197,21,137,15,50,226,204,175,62,4,234,170,114,27,170,58,1,98,26,18,200,62,147,79,49,67,50,24,12,138,92,225,105,229,54,168,128,108,218,37,64,181,48,66,177,50,39,208,234,35,176,153,157,52,12,8,21,42,94,97,50,53,89,125,131,57,139,15,57,57,20,159,36,28,196,7,180,134,3,201,213,10,39,13,121,180,43,68,152,211,147,124,187,95,22,74,15,70,5,82,219,116,221,193,41,79,74,123,130,28,4,225,82,66,130,56,171,133,59,49,189,139,201,124,157,133,13,13,210,44,179,19,31,142,164,117,31,113,47,165,118,32,202,57,196,55,158,245,135,38,9,3,145,227,154,23,253,141,251,179,182,39,252,48,64,6,222,233,97,60,215,118,94,104,33,167,135,151,46,62,246,115,192,247,232,79,196,100,60,4,59,35,215,8,150,250,194,144,50,166,237,202,25,218,119,13,121,162,108,222,32,146,180,125,190,158,245,193,115,249,157,213,161,144,97,186,87,73,235,103,202,130,95,230,10,124,235,8,3,18,200,244,28,71,116,6,42,154,236,234,205,52,182,153,6,206,21,247,254,223,251,129,21,185,126,19,155,205,189,220,179,86,121,74,115,182,166,19,0,36,58,124,89,65,175,235,226,193,159,70,51,235,176,37,146,28,194,243,93,129,45,225,115,44,97,86,190,54,49,4,117,8,220,171,92,54,104,196,187,21,27,181,185,134,118,109,200,24,237,129,40,7,160,122,208,172,219,191,204,33,124,201,143,73,89,183,27,74,77,27,79,96,223,131,159,36,147,230,102,181,244,174,105,19,190,254,92,230,248,20,36,234,208,211,196,173,51,11,105,57,233,37,255,208,109,250,31,169,54,184,224,142,32,136,145,61,199,131,116,123,247,87,85,235,239,246,192,154,237,247,47,3,97,136,54,125,42,134,110,190,64,14,17,109,128,212,121,156,223,178,123,73,144,136,180,83,233,139,13,57,216,194,122,172,96,231,145,20,97,252,53,191,76,42,161,241,251,146,15,150,197,191,16,239,214,180,172,183,45,90,31,56,47,105,159,121,12,52,219,155,43,124,246,12,198,191,229,100,151,181,169,172,146,115,114,109,159,109,37,139,52,54,97,77,69,35,151,45,63,124,220,117,255,248,145,133,201,119,157,14,38,127,168,108,224,15,195,230,154,49,237,193,145,27,143,131,243,22,137,39,175,94,39,157,115,109,254,78,81,53,40,14,73,17,195,218,134,64,110,114,251,152,167,141,90,80,112,173,67,235,47,81,131,43,1,212,21,154,179,105,51,224,39,106,19,19,178,64,115,110,73,64,104,53,105,46,240,10,60,114,169,213,85,50,223,122,83,153,12,57,218,61,40,99,70,208,80,16,94,145,102,139,112,76,35,225,224,128,21,63,121,146,176,203,90,59,157,109,225,220,191,187,67,203,34,145,218,69,144,233,160,132,5,206,174,106,234,5,144,105,67,192,241,242,77,91,152,233,65,174,208,64,77,244,140,87,73,96,235,37,18,162,254,25,106,29,46,131,74,210,225,105,192,199,15,60,125,53,91,190,127,94,206,242,131,121,185,165,45,234,48,146,221,47,73,65,102,98,250,236,226,116,53,195,104,240,119,84,68,193,197,71,87,175,131,223,8,41,37,227,216,51,255,205,49,113,199,119,14,205,177,72,51,183,128,134,44,54,109,222,60,104,236,156,16,146,182,250,66,216,188,59,128,186,178,65,255,128,223,246,8,135,204,96,74,56,196,199,178,102,251,90,162,106,134,155,126,105,112,101,93,149,74,20,126,100,42,110,151,111,182,30,252,152,90,230,157,79,128,154,253,183,88,45,39,160,133,179,113,194,77,32,248,95,221,134,105,149,131,105,212,143,59,213,117,154,192,34,51,145,114,211,19,45,25,5,216,91,107,120,30,237,44,11,58,96,67,50,225,228,91,28,162,119,98,174,21,133,186,216,39,234,166,183,232,124,102,221,236,166,92,243,218,150,157,255,88,6,72,11,83,209,2,235,29,157,115,36,208,95,96,110,231,166,82,245,141,129,135,14,189,86,171,3,82,81,161,203,15,219,167,59,244,12,95,33,170,84,50,60,101,211,123,52,162,76,77,209,128,244,114,43,32,99,255,38,93,35,172,198,209,225,84,215,12,61,140,118,206,132,112,121,94,193,166,132,222,119,209,225,233,11,208,76,26,92,36,106,201,174,156,177,147,42,139,90,221,178,173,69,37,29,188,97,69,62,66,35,203,134,98,251,231,146,159,148,219,252,224,155,64,126,156,26,91,109,9,120,72,224,23,138,250,106,228,138,110,169,109,155,141,132,232,183,22,150,228,112,117,100,213,94,55,219,220,148,164,245,92,92,121,243,197,178,41,236,114,242,216,90,170,97,109,83,174,112,22,70,159,68,205,209,243,124,66,239,82,211,139,143,56,53,142,37,117,94,241,254,177,231,179,206,170,19,30,106,20,128,58,26,155,54,238,25,7,131,103,225,151,33,81,185,223,11,212,186,131,133,208,161,128,230,137,200,78,47,132,189,64,62,158,40,69,145,197,149,237,205,105,207,122,243,190,17,244,81,117,180,152,139,160,106,126,140,76,195,83,183,154,234,30,54,250,1,239,54,33,193,164,22,192,129,127,122,13,158,144,207,189,247,118,191,46,107,168,199,205,221,247,222,91,47,243,107,72,251,162,42,58,92,129,112,114,196,25,154,34,126,23,58,185,64,118,222,23,181,151,60,124,58,46,141,41,214,59,245,73,70,130,120,217,125,126,166,128,242,89,154,113,48,90,99,213,104,14,87,215,67,13,229,228,192,101,142,207,175,220,92,161,211,35,167,61,154,46,62,98,234,30,233,108,122,235,161,178,1,147,7,87,54,253,182,112,100,191,228,127,252,106,18,192,9,110,168,132,13,85,99,168,219,216,129,110,237,122,231,88,92,254,10,116,58,129,72,167,17,238,157,217,5,166,130,231,45,67,118,155,12,54,234,100,190,242,143,39,97,19,152,44,195,38,235,208,110,119,14,103,161,239,226,7,88,230,151,116,13,186,188,250,108,248,97,115,116,87,168,57,199,138,85,121,102,124,153,169,209,244,43,113,56,247,167,194,144,190,201,70,188,83,208,235,216,172,22,217,7,139,154,198,255,95,245,148,121,77,101,21,22,26,80,1,255,126,242,62,21,145,66,73,53,179,161,34,136,58,129,126,130,5,214,214,50,184,1,64,169,154,36,75,63,38,247,189,83,187,0,191,127,115,140,29,152,25,41,95,176,215,157,231,63,170,190,247,135,35,244,58,65,119,21,202,26,27,156,3,84,61,251,16,17,246,186,1,214,20,52,195,195,20,167,82,79,0,129,85,14,53,185,168,48,249,137,250,162,197,162,210,95,242,189,152,53,226,45,193,185,53,41,230,169,242,55,1,97,27,233,235,112,235,232,14,109,209,176,84,145,228,204,55,161,154,4,96,202,167,162,202,22,251,254,169,209,13,70,228,31,215,163,189,3,179,196,121,186,18,191,123,10,245,125,123,174,32,117,41,20,167,16,69,163,94,96,162,133,142,24,131,87,93,124,86,226,56,111,240,40,230,174,20,151,146,226,114,236,221,218,96,138,143,230,139,112,114,33,111,108,175,90,63,2,25,8,189,49,98,111,53,169,116,226,148,65,23,166,128,126,19,44,81,251,200,52,11,162,214,65,42,13,158,114,199,133,247,73,189,25,121,76,242,184,16,22,108,85,97,212,99,224,209,159,78,149,71,46,79,243,58,248,38,61,41,28,119,183,51,30,225,180,158,190,137,94,82,41,127,25,240,91,119,148,34,88,22,241,209,134,228,171,82,150,149,101,111,13,59,230,47,250,188,178,195,206,238,78,194,199,125,33,106,180,191,225,255,186,185,165,102,171,103,250,204,132,219,175,217,2,186,76,175,190,106,160,32,67,4,132,248,109,166,231,36,210,21,35,38,137,60,224,105,42,240,152,62,50,180,75,56,173,158,153,102,30,230,254,66,113,148,9,186,195,74,117,71,16,140,36,127,243,234,145,29,47,34,38,184,135,140,148,192,25,48,41,109,65,83,120,170,132,128,77,104,32,136,67,38,30,12,213,160,86,228,196,191,185,71,90,134,60,190,143,4,166,26,142,119,124,13,67,169,159,35,70,229,203,42,21,196,172,141,111,120,84,177,123,156,170,100,226,121,204,205,116,76,58,15,240,84,121,75,123,166,85,25,66,4,30,209,244,202,77,100,150,79,238,84,176,66,23,13,22,111,233,45,70,214,42,231,232,49,141,6,72,133,30,53,197,51,160,121,86,93,69,52,17,3,43,189,201,121,74,94,104,223,244,102,79,121,90,24,91,25,13,12,83,184,51,208,18,175,169,20,140,9,150,232,49,74,51,100,243,80,137,139,45,95,114,72,107,86,14,82,171,118,10,39,161,69,151,186,8,2,152,105,65,160,113,138,70,157,159,49,134,242,88,71,214,141,106,4,190,89,118,237,14,116,119,170,171,137,10,162,129,145,154,199,188,77,206,221,158,190,125,218,48,110,255,75,135,216,114,192,66,242,170,244,142,137,211,183,123,216,30,22,6,129,131,29,151,227,19,106,92,84,95,44,148,45,225,145,230,93,202,230,114,179,251,70,15,238,37,188,18,91,175,82,117,181,100,186,17,196,231,166,249,113,215,119,174,145,112,200,43,11,175,93,131,228,69,126,72,14,2,61,131,140,22,129,198,158,247,134,151,250,38,180,89,156,26,128,223,74,128,93,1,96,177,139,98,59,62,64,254,85,203,196,161,9,103,197,226,118,4,211,103,163,58,193,147,153,1,228,174,113,158,114,112,176,32,88,190,30,245,112,60,20,14,10,163,120,55,225,243,196,152,138,87,226,60,160,12,155,228,107,178,139,93,15,205,114,172,30,185,186,3,230,169,108,45,248,32,7,191,124,64,171,161,144,119,231,26,234,159,102,0,122,233,114,75,220,36,205,38,131,146,25,141,226,160,167,71,2,92,27,65,232,13,177,77,33,218,19,182,164,91,191,48,125,205,7,115,254,5,21,206,118,99,72,153,155,124,70,243,179,221,174,204,89,36,134,192,109,133,2,30,114,28,67,88,245,93,34,86,102,45,99,84,35,221,67,145,134,159,210,73,93,227,54,114,123,114,238,188,70,112,15,10,47,233,176,1,218,77,134,189,195,11,66,41,215,30,22,144,84,143,221,149,75,91,138,255,59,19,83,20,20,250,131,122,37,149,194,149,88,58,46,129,21,102,199,81,251,188,35,146,209,252,237,169,110,153,63,238,72,3,8,98,214,58,110,82,135,114,219,53,63,131,143,167,120,173,182,211,131,219,96,109,78,149,233,128,98,196,33,170,148,101,215,124,209,2,6,0,145,111,90,197,163,199,204,6,207,208,76,82,217,200,225,161,210,227,145,249,42,55,111,250,82,144,103,159,43,126,8,229,178,140,8,173,77,76,97,125,121,49,253,180,164,230,172,231,144,71,120,69,185,67,163,205,36,251,11,76,98,59,119,71,173,2,157,251,215,26,213,156,87,14,63,199,39,238,143,5,241,202,30,207,238,149,195,167,35,102,182,17,25,65,46,219,27,191,138,162,122,143,145,246,177,103,100,11,61,182,231,3,83,185,69,142,157,89,35,7,160,178,88,162,75,128,17,16,191,45,229,146,10,214,215,63,35,7,226,104,132,63,250,120,160,217,223,33,44,164,85,176,4,215,86,86,103,247,76,78,78,92,68,124,224,52,102,189,229,165,53,112,0,151,12,242,254,130,70,114,171,16,145,2,12,116,223,102,102,186,19,162,141,206,124,123,165,113,48,142,20,183,127,90,90,23,8,205,221,104,124,146,131,188,185,220,191,5,47,57,13,141,164,207,251,84,43,123,63,93,145,238,214,125,195,45,4,139,97,106,216,97,144,222,94,48,230,209,216,18,1,39,179,214,216,130,177,29,203,2,93,29,236,39,100,55,10,172,203,85,58,69,124,73,200,45,18,64,114,116,97,197,126,241,160,199,229,191,243,75,38,180,70,161,95,84,209,108,177,20,47,126,223,27,239,93,47,211,221,93,95,200,214,211,57,35,32,196,109,154,205,183,27,220,197,191,59,150,182,29,1,204,105,40,19,180,28,4,208,223,178,177,228,149,137,33,206,104,57,195,74,179,92,100,60,155,180,48,116,145,226,192,254,9,239,21,218,60,137,137,143,236,212,58,75,125,193,63,83,123,175,177,201,26,76,156,170,154,51,13,46,183,248,83,142,94,215,252,98,123,250,163,250,135,216,48,80,74,155,126,202,121,110,55,1,42,153,186,126,70,150,47,29,102,117,229,220,233,11,131,22,57,104,25,244,230,213,211,179,27,200,137,165,244,64,166,4,179,38,145,186,148,188,43,131,39,233,5,152,169,53,79,184,188,231,228,99,171,224,25,187,15,104,101,211,52,170,106,176,7,151,79,118,231,162,54,193,171,172,162,230,26,96,155,204,175,236,63,13,119,185,151,49,11,122,217,109,205,34,143,226,84,201,141,116,16,145,122,202,46,7,105,122,75,78,234,49,33,40,1,10,89,174,109,121,199,56,241,3,145,246,165,180,162,215,186,254,132,5,112,152,148,194,205,132,181,162,230,6,125,148,230,254,10,252,22,207,43,53,142,58,198,63,177,56,127,57,108,228,230,115,18,59,52,55,39,51,162,13,12,95,16,50,14,154,218,1,210,62,255,13,22,253,76,203,22,81,236,48,8,134,234,167,213,6,152,245,185,139,129,142,1,216,237,229,181,187,196,136,167,115,88,96,124,110,199,203,238,152,121,91,55,112,13,227,195,89,25,74,54,138,225,214,243,255,168,80,236,55,203,102,61,111,57,80,61,220,39,11,110,116,160,206,132,59,137,129,107,205,109,159,154,202,63,53,173,81,102,252,18,116,148,187,185,13,33,123,40,56,115,101,25,4,51,87,67,199,105,9,220,0,30,217,201,138,147,170,123,162,136,119,99,130,25,96,186,206,82,73,204,12,28,169,140,217,7,39,233,132,202,81,109,74,148,173,12,113,33,211,12,245,30,68,21,83,214,99,168,248,86,82,235,82,228,209,30,156,58,92,250,142,54,216,82,65,48,6,82,181,134,195,92,41,198,222,104,149,90,39,37,99,244,229,245,39,108,54,14,119,34,218,195,29,157,34,98,189,203,152,9,55,124,56,149,139,202,127,2,148,36,37,184,89,192,236,13,189,98,55,210,81,231,205,208,76,162,26,127,126,88,230,221,107,98,171,135,79,253,169,9,104,230,168,80,120,157,180,149,222,115,163,162,191,125,223,56,80,150,105,250,125,82,226,129,5,56,24,60,221,69,198,148,75,124,104,131,209,37,251,61,73,225,188,44,29,246,192,215,70,93,57,93,228,139,91,211,12,147,164,79,165,16,138,97,249,62,47,122,40,57,190,142,178,226,195,98,45,143,249,254,105,181,183,95,177,105,188,230,204,71,174,248,53,75,134,51,14,98,232,151,37,255,160,253,222,2,102,193,229,198,50,60,39,184,59,121,129,51,59,238,198,75,207,125,84,244,4,176,237,14,33,149,162,225,20,171,52,241,174,151,102,10,105,238,45,109,105,133,77,114,174,35,88,68,41,32,93,31,32,15,193,21,48,207,87,148,40,184,161,235,243,121,46,215,169,166,154,204,178,202,169,56,41,73,244,191,125,161,14,164,169,59,232,39,51,211,8,111,93,95,238,237,168,103,111,122,136,229,2,42,38,89,75,138,160,172,192,207,228,179,249,250,212,141,88,194,47,216,195,29,29,23,221,171,12,117,205,110,144,107,62,50,57,48,57,143,159,135,60,146,28,66,123,114,180,151,46,79,66,131,242,172,142,135,3,131,179,225,54,49,76,126,115,4,225,128,164,184,201,252,198,230,67,46,226,252,220,59,237,36,127,112,172,31,158,203,234,84,80,152,78,53,142,133,248,157,144,221,217,119,37,193,196,56,134,1,110,203,252,135,218,70,255,197,68,244,193,203,9,209,241,81,89,194,170,19,53,103,137,201,232,102,120,88,35,8,211,81,110,140,65,39,73,179,135,14,175,222,67,157,177,179,81,131,61,231,243,99,21,67,108,142,30,4,145,168,48,68,195,2,102,221,16,16,53,232,251,25,73,160,213,162,113,140,22,135,1,192,56,207,22,146,45,32,99,200,200,28,219,242,43,81,108,231,229,19,51,238,160,67,88,79,197,17,145,226,34,232,228,36,121,190,51,229,177,242,3,100,103,62,54,26,206,84,243,244,119,133,93,110,199,116,3,213,233,163,101,108,90,69,181,153,236,253,45,214,189,91,115,199,71,105,149,135,163,57,76,234,114,161,195,8,211,252,70,232,41,26,59,252,178,83,99,45,169,171,65,2,45,170,29,76,54,201,91,45,107,10,103,15,86,93,102,144,82,179,101,163,66,53,4,192,67,141,161,167,33,237,57,225,92,105,134,149,127,138,211,29,231,84,148,193,54,118,93,101,209,235,109,88,87,64,83,93,51,51,231,162,195,134,236,14,234,7,77,43,26,241,88,106,60,13,214,177,162,77,84,223,20,222,91,186,67,106,178,86,47,152,76,127,2,214,79,73,212,193,87,144,75,163,88,206,223,207,153,51,246,204,188,197,84,252,25,17,95,14,202,235,175,30,145,18,238,149,202,52,78,100,2,242,217,72,132,233,194,9,170,0,243,255,136,113,161,85,170,218,70,255,112,88,65,180,116,166,42,122,209,224,239,223,195,27,177,165,152,73,221,156,20,8,157,235,100,219,74,199,193,91,15,119,18,225,206,154,252,32,102,227,12,192,207,252,252,230,248,29,18,238,160,40,22,18,203,220,42,98,209,92,227,254,7,66,167,231,10,218,130,79,104,67,255,191,19,236,31,110,121,76,151,193,204,217,149,231,112,151,248,154,134,84,215,114,202,196,2,2,184,252,168,190,75,139,211,135,108,142,63,127,169,123,158,24,182,107,249,176,55,119,201,231,90,42,212,106,70,244,220,152,216,120,203,232,84,11,91,251,240,70,130,199,254,150,161,211,89,247,148,2,40,178,53,130,240,23,245,168,238,124,13,253,9,248,56,73,93,202,237,34,47,59,19,49,159,171,36,214,197,151,3,190,141,70,43,29,234,133,30,246,156,130,100,244,224,232,211,187,0,157,10,180,155,150,130,186,159,98,224,134,56,51,63,131,185,40,93,202,253,4,20,250,236,195,1,33,112,9,134,208,126,178,108,14,241,109,135,193,32,126,154,35,44,70,140,157,62,87,149,68,3,227,135,79,38,69,180,2,233,248,175,120,48,243,205,231,33,30,204,141,242,241,87,135,60,35,182,185,212,88,214,86,206,166,60,43,120,138,140,175,125,125,216,160,233,180,28,42,76,113,106,121,195,133,157,118,189,26,77,218,96,253,62,54,180,236,254,3,100,238,227,81,127,27,173,208,249,42,17,110,227,86,189,56,200,13,30,185,216,77,120,171,54,23,119,145,157,71,132,206,191,1,32,98,69,201,151,202,93,3,12,4,57,145,141,228,146,192,42,107,255,70,104,149,209,105,113,125,223,102,205,110,146,113,77,179,1,109,107,210,212,128,140,202,206,174,49,0,136,133,200,107,240,255,69,79,176,254,221,120,202,159,160,59,189,109,210,138,214,72,135,71,126,15,220,55,53,175,128,88,38,122,223,131,169,58,154,196,44,139,232,205,169,136,157,46,169,211,161,187,223,167,37,17,15,146,199,130,53,154,23,121,157,171,204,84,32,108,169,82,167,191,1,204,125,54,163,37,95,164,47,34,229,108,239,193,108,138,166,225,192,199,38,109,80,54,164,183,203,112,38,230,107,227,112,43,204,177,0,175,118,127,197,67,147,187,210,177,188,206,200,255,25,0,211,173,143,49,104,25,109,85,217,160,196,205,92,247,4,235,209,240,104,126,43,178,49,170,160,199,77,179,104,17,8,95,173,124,7,172,81,69,222,183,71,64,157,130,157,238,211,161,103,243,199,229,177,212,53,124,86,153,220,36,159,17,214,105,17,206,172,6,189,83,50,60,246,202,108,221,138,133,224,74,108,162,217,216,229,170,168,99,147,160,16,137,27,75,161,195,249,218,77,183,8,162,119,97,52,90,173,27,49,252,89,209,178,201,122,222,3,57,77,107,161,236,115,22,126,71,9,37,79,235,212,224,211,58,210,144,129,246,53,121,248,203,87,117,141,82,62,183,112,141,73,233,186,43,183,210,6,169,253,147,181,225,58,27,57,45,50,241,87,209,186,78,28,206,137,137,195,99,209,159,45,58,157,13,247,206,118,155,149,31,97,136,236,139,143,66,13,137,40,76,125,221,248,88,14,190,64,7,119,108,246,161,141,184,172,142,242,105,24,189,44,108,158,123,204,242,169,171,237,233,98,25,45,54,20,189,79,192,197,33,0,61,126,22,184,198,47,158,114,138,206,27,18,185,212,1,112,105,245,27,128,203,220,213,101,1,188,198,253,105,182,236,79,132,42,206,72,129,94,24,60,142,255,241,56,69,136,67,252,140,105,64,253,127,54,11,55,19,203,94,218,90,41,98,207,105,59,68,113,97,182,123,143,88,191,167,239,66,20,212,214,250,88,139,66,86,227,40,107,177,101,9,206,101,49,63,158,177,173,72,191,170,30,76,72,86,243,80,156,28,39,68,49,93,18,83,73,226,57,100,199,83,90,141,20,103,44,103,89,222,90,144,59,208,185,197,220,146,81,122,26,0,211,93,5,189,122,129,248,86,32,106,47,217,111,198,233,198,44,25,154,23,153,202,86,83,178,59,218,107,232,28,166,201,59,235,20,31,42,252,154,185,194,13,110,160,117,253,4,104,110,102,90,26,171,177,94,215,64,229,86,54,164,227,89,100,37,208,79,41,73,63,103,62,236,144,222,31,110,228,67,50,207,105,226,133,243,245,37,229,34,72,245,44,246,101,174,157,222,199,182,254,196,115,98,181,14,131,84,123,218,239,68,1,253,5,247,96,245,228,188,31,114,186,237,44,124,240,154,165,230,116,206,34,43,226,219,125,2,170,123,247,86,99,116,254,40,217,5,97,135,108,214,72,255,186,239,73,229,165,30,119,68,144,220,17,55,230,188,157,229,230,87,82,38,74,219,201,214,150,64,139,88,185,68,173,28,234,228,90,172,78,99,68,21,94,137,131,253,129,162,204,73,25,75,226,159,140,46,69,195,35,107,170,106,239,61,242,128,140,232,135,244,212,72,132,247,194,255,24,190,211,16,141,190,117,158,126,123,61,222,76,75,67,215,5,211,243,231,166,58,253,118,13,11,159,134,206,36,211,129,16,250,112,136,254,202,181,137,236,16,123,58,17,99,228,85,40,218,215,223,69,73,245,162,251,242,105,36,38,190,147,84,202,101,180,1,130,130,32,12,110,114,233,216,39,111,136,119,167,54,244,253,6,14,113,78,242,8,186,120,204,247,242,41,216,141,119,165,137,54,78,170,210,72,226,168,215,108,248,91,111,84,93,21,212,14,56,168,134,211,232,18,65,36,32,151,171,249,209,118,166,2,124,2,221,42,190,31,157,166,255,112,229,153,67,85,6,17,144,98,142,108,191,193,166,154,31,230,243,215,90,73,233,219,156,126,107,216,241,17,162,213,117,60,243,122,46,108,188,160,35,53,159,195,218,10,130,223,36,223,254,84,159,67,43,126,6,112,66,251,143,59,103,114,204,236,49,205,229,39,96,2,156,239,79,107,21,57,27,103,27,9,255,246,227,175,141,74,65,20,251,160,185,108,202,78,147,79,197,147,180,219,155,65,220,65,197,2,201,102,176,145,252,131,242,225,171,116,59,141,127,238,243,117,76,80,116,140,74,79,215,220,68,238,207,48,190,64,203,17,244,16,191,23,126,112,221,7,218,55,221,131,233,107,191,143,48,170,163,64,231,58,36,148,128,178,156,80,67,221,93,80,55,87,182,43,174,179,194,157,134,75,97,96,139,253,71,243,73,41,99,53,129,207,58,231,87,24,187,151,158,134,59,148,250,206,36,218,189,56,190,153,185,213,72,229,252,145,249,232,34,52,8,134,242,201,34,156,42,169,156,27,18,153,99,138,211,36,142,212,113,161,161,175,87,63,195,12,115,98,153,120,157,121,231,220,129,149,85,66,194,123,166,240,120,224,249,163,119,145,63,140,184,110,20,138,188,199,238,209,86,67,185,237,247,105,140,246,253,143,142,250,14,84,100,110,13,177,46,19,12,131,231,111,167,81,227,16,35,238,115,49,162,148,205,22,237,141,89,126,201,40,247,1,189,76,20,63,117,197,254,44,80,101,153,147,20,2,192,199,94,113,52,200,120,228,116,38,96,248,73,18,34,192,121,253,64,101,231,239,72,161,41,61,72,142,64,195,226,88,43,125,195,6,16,224,237,38,240,65,26,84,236,143,230,162,123,164,28,159,26,55,47,244,215,64,9,98,99,0,115,6,231,29,130,202,50,82,247,144,255,242,20,8,99,185,181,25,80,220,174,8,92,90,246,228,99,30,14,94,71,203,200,169,75,28,185,89,219,177,143,68,76,50,4,5,228,106,88,28,241,62,87,41,128,177,146,175,28,139,159,219,39,39,45,190,195,136,68,228,134,15,56,234,175,141,12,76,166,129,134,106,98,180,21,234,101,174,237,248,105,93,152,231,123,18,222,188,25,255,203,230,13,238,201,68,132,140,231,165,166,191,34,24,37,88,40,153,12,128,220,116,192,143,183,91,206,150,134,97,233,51,171,127,173,154,216,225,28,155,8,160,107,110,25,66,52,20,234,8,110,50,93,214,139,160,201,152,155,167,10,32,205,231,216,163,98,115,130,45,174,99,77,188,27,64,194,205,32,49,29,113,165,240,49,22,237,2,75,209,59,156,178,79,35,127,54,70,70,159,244,81,114,251,213,125,153,168,253,199,202,99,114,50,122,195,58,91,226,170,8,55,41,153,133,134,93,215,48,76,147,20,177,6,24,48,188,72,118,212,188,199,0,21,106,52,20,81,80,67,240,37,160,216,153,228,6,246,73,113,77,66,142,99,195,68,113,192,120,237,35,236,221,40,56,3,146,218,89,166,199,4,135,98,243,164,21,184,178,128,108,86,165,89,43,169,88,113,140,215,11,49,198,47,0,117,215,28,117,135,220,140,24,114,5,130,121,203,211,211,19,218,210,143,250,156,142,167,151,93,21,187,145,57,178,70,170,210,31,48,32,202,145,238,123,62,2,17,187,97,21,163,68,178,146,11,61,120,226,14,1,81,105,61,226,89,188,210,63,215,249,35,93,230,14,40,178,83,22,75,172,221,232,200,46,36,254,5,43,243,170,32,21,10,57,4,87,14,204,178,225,140,18,128,120,52,147,247,60,131,45,32,238,30,152,172,63,194,64,52,115,233,21,42,1,102,79,8,150,167,78,2,229,23,126,182,133,95,115,208,23,44,139,158,80,115,160,51,102,180,68,45,224,191,38,56,245,50,111,144,134,217,148,109,11,111,198,199,198,37,209,136,49,69,143,101,160,90,75,177,53,139,137,164,184,101,175,178,148,206,158,143,132,14,8,149,152,84,97,12,223,114,117,208,41,92,96,48,220,39,168,10,170,135,36,55,83,175,128,209,64,64,193,41,39,181,8,226,28,210,196,14,109,222,201,217,17,101,211,61,13,219,182,165,0,234,191,119,177,33,198,64,154,102,51,122,215,70,180,80,28,219,97,239,121,67,222,191,110,85,174,198,125,38,210,98,20,230,1,219,77,94,114,151,171,156,100,5,244,31,81,112,254,221,194,175,133,211,174,126,183,49,16,127,168,22,167,243,71,0,41,210,187,57,55,193,72,54,216,7,201,240,243,216,204,5,112,214,16,204,63,254,57,71,120,155,211,225,213,80,212,107,207,56,205,165,82,44,220,8,96,50,74,19,118,67,139,9,211,215,143,29,150,97,14,163,74,117,150,51,134,27,41,100,83,144,17,131,143,94,253,87,217,242,187,131,247,69,18,120,89,171,166,145,86,108,226,113,38,3,133,46,78,133,58,135,38,242,25,44,129,187,29,69,242,46,126,181,107,92,236,111,206,36,123,227,165,168,201,2,221,104,184,119,189,47,101,8,19,81,85,75,30,134,50,252,45,218,53,151,97,127,1,188,208,95,32,205,65,145,92,96,217,246,124,214,242,221,141,85,169,102,160,2,213,126,240,80,126,82,123,51,216,63,6,82,61,237,110,76,133,253,88,132,61,89,92,78,146,148,70,192,88,156,52,248,188,108,190,241,197,87,223,87,8,1,157,233,250,154,73,68,163,33,105,28,41,37,93,121,161,119,126,56,19,146,198,198,238,91,75,137,165,69,181,56,172,228,246,43,223,40,136,209,168,140,81,135,85,197,53,9,181,125,190,211,178,104,76,72,180,131,140,93,165,101,190,96,51,155,180,102,31,111,141,101,178,178,121,74,97,203,248,35,113,100,184,147,106,126,138,233,168,34,109,99,69,30,16,109,103,254,56,61,144,169,131,12,210,200,72,108,249,1,246,160,24,75,166,7,161,5,97,22,223,23,193,230,121,17,241,239,219,212,215,2,107,4,37,205,151,62,221,160,251,223,137,95,208,61,89,129,176,223,1,224,69,2,101,173,10,62,108,89,61,116,229,226,159,174,38,226,165,16,106,197,99,42,163,237,187,218,174,66,199,90,153,240,214,235,194,141,191,21,232,59,189,203,169,37,130,246,240,252,32,122,100,35,228,225,104,146,139,6,41,183,17,69,50,169,89,78,168,52,127,200,93,177,87,11,64,253,132,231,247,169,79,229,65,180,226,10,159,222,90,7,146,121,25,135,97,171,82,111,202,0,167,52,209,86,171,188,7,175,69,230,96,0,81,13,20,216,225,227,47,156,160,168,222,103,145,122,165,39,33,150,117,107,140,46,21,105,157,206,61,100,78,125,102,0,97,75,67,238,177,233,136,238,4,135,212,60,167,21,53,255,80,159,55,120,249,150,247,121,249,100,74,110,14,52,79,103,255,58,89,237,153,146,223,234,27,211,23,111,84,59,168,2,21,128,244,62,59,177,182,44,84,185,234,24,205,197,7,96,105,222,48,59,5,40,0,146,164,233,64,35,106,240,131,132,245,237,4,157,165,220,212,66,70,127,213,53,6,167,90,184,21,125,240,16,81,93,244,193,137,13,179,6,93,15,104,46,122,127,196,116,73,111,162,205,186,114,40,77,133,109,140,109,127,136,52,122,225,126,34,46,128,30,243,205,217,153,95,55,95,133,220,228,102,243,226,252,33,137,111,234,30,208,82,7,245,154,228,210,152,193,223,208,96,37,56,225,182,72,179,206,38,66,193,207,133,224,217,154,254,182,71,65,120,7,153,95,42,92,193,24,126,131,70,102,84,131,97,111,83,97,121,117,67,78,23,134,132,173,135,70,144,130,72,103,77,10,46,60,140,244,149,218,130,158,188,54,245,40,101,242,215,213,204,59,159,251,195,51,53,41,171,102,13,89,135,202,25,78,47,105,189,7,246,174,233,111,30,113,154,98,73,39,149,121,85,62,178,26,118,23,45,195,78,181,199,216,202,17,3,245,135,214,19,112,230,43,1,96,3,194,245,12,134,250,245,192,36,91,65,249,50,21,28,22,157,180,130,96,90,211,169,73,87,121,114,17,204,75,152,122,203,128,221,185,77,15,62,125,106,27,43,170,0,239,141,116,9,69,53,250,250,73,192,228,78,212,177,212,226,106,107,151,137,44,128,185,206,168,89,12,73,81,39,8,186,189,113,168,142,63,64,55,63,7,42,96,141,115,69,232,168,138,233,97,255,192,14,173,57,41,226,162,33,61,140,24,217,154,160,35,183,60,232,229,215,220,90,20,150,43,15,5,243,213,25,111,65,239,52,143,68,220,45,161,104,240,60,178,161,189,17,51,128,201,141,224,249,186,203,76,89,242,21,64,165,23,9,97,116,25,230,137,169,182,227,20,110,9,80,100,129,66,217,222,28,241,88,46,228,220,83,100,115,232,43,76,243,224,135,75,182,14,91,105,81,52,87,192,41,61,131,118,93,19,112,196,225,9,71,199,104,180,26,95,46,174,242,141,115,94,235,51,6,146,209,254,83,28,65,214,211,208,226,70,0,127,76,134,173,36,133,157,152,246,97,174,182,50,111,21,133,13,218,194,24,62,221,50,226,206,45,46,145,106,207,145,13,138,108,106,73,108,199,14,10,76,102,188,71,137,184,134,6,0,85,90,51,153,232,246,144,162,4,102,8,220,195,16,43,192,62,164,77,103,217,79,210,243,51,229,106,91,246,196,233,79,154,226,196,141,242,138,62,34,188,235,205,0,253,203,1,170,152,80,213,235,73,179,39,6,171,194,178,157,152,250,97,250,31,219,195,138,165,235,23,90,239,214,227,68,174,193,45,4,43,93,249,249,149,8,23,156,55,40,120,125,42,64,158,10,182,52,3,238,199,214,104,94,142,2,1,202,36,81,77,238,66,76,187,119,38,235,27,140,223,149,150,96,178,64,170,73,246,151,88,237,110,235,11,149,179,77,99,214,110,204,148,26,201,6,245,120,62,14,27,242,135,249,13,95,116,107,136,69,38,200,246,243,36,107,44,38,229,27,251,121,250,158,203,29,167,119,180,81,156,104,180,79,170,60,238,210,61,75,95,21,227,168,245,226,148,115,227,21,217,16,129,12,174,8,111,145,57,116,143,67,217,107,237,155,145,110,49,122,106,84,186,69,132,26,37,98,97,178,55,146,116,34,119,65,214,29,241,156,45,26,115,102,185,92,224,99,122,157,220,20,217,102,70,204,218,49,241,206,230,148,27,152,140,189,142,43,117,91,31,8,102,210,141,138,159,234,196,53,41,91,30,191,149,107,249,188,116,237,250,144,254,66,69,170,142,204,169,103,237,106,230,206,205,193,52,219,155,249,245,213,190,14,157,85,228,178,198,74,83,48,51,249,153,215,175,172,90,204,237,148,171,25,205,174,77,34,144,50,49,67,214,219,30,185,145,241,68,62,125,196,57,244,171,98,10,56,133,185,243,202,175,3,3,0,190,44,189,248,130,190,111,66,237,243,225,104,175,151,29,92,238,107,25,177,117,181,34,134,123,67,26,99,140,233,211,97,247,247,133,27,183,194,155,70,218,244,248,160,27,223,62,254,193,176,221,211,119,35,112,160,25,245,177,83,78,145,95,6,115,62,18,4,204,57,108,232,134,138,82,22,49,19,163,11,17,157,97,202,85,28,73,245,144,73,111,144,31,94,95,82,32,65,13,199,30,202,225,192,135,71,227,231,208,186,195,137,81,79,91,175,145,166,130,178,2,14,52,109,91,152,82,155,6,103,75,212,50,137,103,214,247,32,207,4,58,38,93,111,227,217,49,56,65,72,185,204,57,129,64,82,124,49,0,119,247,170,180,142,19,160,95,15,225,92,169,127,159,72,160,221,169,30,121,189,14,69,185,146,155,63,44,5,201,187,101,134,139,3,38,99,1,196,179,222,244,21,179,249,13,241,55,92,237,238,101,108,129,79,119,233,241,39,96,69,122,45,199,29,71,91,205,225,2,206,199,66,25,47,121,60,185,11,41,215,98,132,108,193,211,28,131,220,15,16,109,22,59,201,239,78,227,140,82,62,110,223,65,202,250,185,56,109,34,34,55,139,203,158,67,32,139,80,10,133,233,54,35,120,110,86,44,194,125,154,78,95,84,121,224,218,122,91,53,245,99,107,10,228,119,210,176,31,161,82,170,14,237,71,172,61,168,118,252,108,179,162,157,35,193,144,167,69,228,91,57,220,0,189,222,132,194,153,2,98,192,65,255,5,118,146,50,246,255,82,129,200,126,208,20,200,89,149,112,214,120,66,59,215,72,210,156,12,72,130,127,223,39,221,151,77,66,36,128,14,133,165,4,52,95,241,214,66,68,69,156,228,84,94,59,40,197,125,61,207,234,186,128,33,137,24,246,21,98,168,212,215,5,7,50,33,136,91,170,109,198,104,128,146,53,72,132,255,11,187,193,201,225,150,250,127,66,29,59,237,251,15,60,226,242,156,72,109,187,104,175,7,66,126,16,65,120,89,152,52,253,129,200,183,16,147,50,51,33,244,241,73,61,91,167,163,156,66,1,64,147,42,239,146,94,47,102,159,133,222,106,160,58,119,235,14,235,226,31,16,102,205,178,162,179,166,80,36,121,170,31,218,143,0,209,30,206,190,238,104,117,177,221,108,91,173,249,227,67,52,39,248,80,54,206,113,77,232,214,133,88,159,132,173,12,239,180,28,233,125,30,38,171,13,186,209,243,69,183,196,208,145,181,239,103,33,35,110,90,154,143,100,2,182,233,139,0,231,172,62,249,58,136,201,50,171,127,73,17,142,119,210,207,165,157,47,203,206,245,79,108,119,11,73,102,205,249,18,194,158,9,201,60,221,85,167,170,223,207,248,63,41,118,110,15,94,5,31,247,149,42,169,55,112,107,221,218,116,176,192,33,81,107,49,62,22,124,111,222,143,216,61,67,196,159,116,33,169,115,202,254,116,29,7,124,209,170,187,222,233,29,200,9,84,177,255,65,249,205,11,1,21,213,238,30,252,88,202,230,40,244,228,129,129,51,53,124,78,100,139,57,52,54,247,89,189,106,239,145,163,213,213,236,175,105,205,217,169,172,14,109,26,253,139,59,23,57,78,198,121,29,248,173,74,85,60,236,223,67,79,117,243,217,35,126,111,146,74,12,131,155,203,255,192,236,92,242,162,7,236,100,115,234,155,44,248,155,215,254,21,248,84,101,177,87,46,104,155,186,115,185,143,99,149,68,150,34,167,183,97,57,194,197,132,193,184,141,40,0,144,0,183,116,6,230,36,215,111,252,0,128,121,15,205,237,211,137,198,128,195,2,243,183,171,197,82,88,132,224,91,77,149,127,26,80,68,92,128,69,202,14,28,182,21,116,13,53,35,103,41,68,170,50,174,227,164,144,20,12,50,60,139,2,44,208,132,91,148,134,173,209,36,133,114,251,121,87,110,210,174,221,109,86,228,91,31,5,137,5,28,105,224,109,52,25,36,192,181,43,225,205,62,238,125,4,178,178,22,203,133,121,67,243,18,25,12,56,157,138,78,168,250,153,254,211,95,190,247,252,33,33,176,254,71,126,242,76,216,117,56,20,102,227,47,204,152,34,156,113,59,43,228,55,224,169,60,49,148,122,25,73,202,160,214,120,145,27,204,153,93,22,183,242,219,34,144,15,171,135,201,209,94,61,93,118,213,84,250,250,187,47,127,35,13,71,224,160,76,168,89,198,56,38,169,210,152,247,84,234,43,64,172,58,8,241,177,11,217,36,48,94,116,87,236,226,169,200,71,67,67,237,232,19,60,16,224,216,72,253,121,152,30,240,64,72,156,222,115,244,84,236,136,187,134,89,121,199,215,26,87,104,89,9,33,37,65,204,44,217,241,44,195,248,196,141,96,143,231,205,89,99,99,142,67,101,20,67,52,85,41,209,74,54,143,21,117,121,167,219,190,17,14,20,40,60,89,25,98,24,25,88,223,104,183,119,168,85,63,234,250,116,147,39,169,22,47,209,97,46,91,211,255,210,23,243,110,172,125,6,214,155,2,48,155,176,101,246,80,220,161,180,70,235,53,213,218,26,132,75,100,223,187,48,221,1,174,81,43,91,38,60,2,120,219,32,120,178,120,74,119,149,4,246,244,21,131,69,169,187,163,56,7,191,160,69,32,179,65,102,110,137,46,146,104,160,89,230,242,119,219,193,11,127,198,253,202,186,139,48,34,214,170,132,13,107,1,27,63,75,176,126,50,59,21,233,230,58,83,110,64,183,117,231,0,63,60,81,82,252,22,99,19,81,190,67,1,98,170,211,40,80,97,5,89,177,26,97,118,159,22,113,124,2,77,47,206,236,128,30,135,9,104,11,81,211,176,72,55,25,95,43,73,214,73,187,234,82,146,12,215,159,77,16,91,84,52,240,87,147,126,174,209,139,20,139,249,91,46,143,185,131,53,51,178,77,95,244,119,200,220,149,171,3,11,97,29,233,226,221,34,178,128,22,82,132,81,193,10,161,195,104,202,17,160,2,51,191,181,58,147,24,108,21,75,26,168,201,140,157,236,95,158,215,152,44,40,101,42,161,76,190,70,147,195,153,10,174,184,21,57,106,54,116,26,180,101,200,3,103,100,204,159,133,87,58,1,249,27,19,74,148,76,233,81,254,241,171,181,140,102,52,173,11,123,171,244,240,223,50,28,165,125,150,67,103,189,191,23,115,143,253,236,90,47,180,124,34,194,182,254,89,175,36,70,67,19,203,102,131,58,204,147,6,1,94,248,38,231,254,173,147,151,210,77,29,210,153,127,68,120,100,146,100,143,69,61,213,110,75,71,3,153,145,228,107,38,237,1,66,151,146,147,241,145,5,68,100,131,166,26,188,89,50,215,202,185,216,69,63,203,38,225,229,158,170,255,93,140,68,234,71,244,199,30,130,115,28,187,176,232,238,44,250,169,13,74,124,118,116,50,0,72,139,103,37,176,83,7,67,10,165,226,193,176,252,80,82,114,218,238,49,56,114,94,65,86,198,200,54,247,110,104,93,10,254,96,76,20,52,133,29,176,31,152,31,221,254,143,172,239,249,38,66,96,216,6,74,99,151,190,2,114,208,179,62,190,195,24,13,141,170,196,41,135,170,54,21,155,98,25,98,75,254,196,42,219,128,50,54,142,90,130,184,85,94,103,186,250,17,16,59,204,51,180,121,247,167,65,213,138,87,194,188,101,19,68,198,217,120,230,144,213,105,81,96,155,83,127,55,207,4,174,215,199,237,110,19,8,198,221,40,192,5,203,169,140,17,104,169,51,182,206,181,115,13,65,111,29,127,150,152,27,162,64,228,199,116,59,255,39,121,155,88,37,167,17,10,156,95,164,102,110,38,4,56,6,250,117,125,183,13,67,186,139,152,197,162,159,75,254,183,50,46,170,224,186,113,210,184,2,32,152,130,179,16,56,255,82,222,122,112,100,221,189,51,141,251,189,226,112,75,195,10,200,166,207,242,187,55,223,93,236,87,241,87,135,44,166,195,120,7,129,159,89,1,102,105,123,71,109,26,36,226,195,174,158,28,182,251,10,4,160,112,112,105,53,96,93,27,167,202,146,114,60,186,98,246,236,138,160,94,126,236,153,251,67,26,175,142,74,106,61,110,248,126,82,253,35,178,87,92,169,246,232,17,223,202,170,80,59,37,242,209,73,235,76,68,3,156,100,212,96,6,133,121,35,167,175,51,100,88,50,10,169,202,93,124,128,201,114,221,104,168,117,209,159,225,239,126,211,198,50,198,22,244,57,212,74,176,22,185,23,170,54,176,229,98,0,225,59,236,105,102,159,223,0,247,66,21,80,191,195,211,12,102,246,152,8,182,88,31,147,129,58,112,201,133,75,17,219,119,232,67,83,27,159,189,73,118,157,30,80,42,199,237,178,99,243,39,203,128,118,225,5,25,91,108,17,28,113,121,198,16,211,60,212,131,161,55,24,200,138,28,199,127,51,85,103,59,62,64,170,232,243,119,54,77,66,14,166,81,254,58,4,190,52,3,151,88,37,248,146,185,157,18,102,106,7,91,254,167,190,120,150,196,109,246,118,220,19,10,168,120,57,19,64,33,253,176,12,129,167,78,15,212,200,30,221,99,67,39,236,224,137,29,37,69,198,251,51,94,90,27,22,145,245,117,63,210,120,61,10,35,67,77,196,81,222,91,76,117,199,210,178,119,194,183,122,254,173,110,82,96,238,247,221,130,205,10,140,41,181,30,136,45,134,169,25,212,233,178,91,18,175,21,21,123,218,33,87,106,163,192,155,96,255,69,184,28,114,98,210,53,37,35,69,44,88,30,194,104,203,212,166,57,120,38,249,127,182,252,152,5,31,78,37,249,11,9,167,220,116,149,193,31,119,109,192,103,120,178,224,22,148,97,173,24,152,218,168,175,84,10,105,96,252,153,113,108,20,50,209,119,133,70,245,165,135,44,239,93,201,46,11,126,130,130,15,85,106,153,168,114,15,44,61,166,247,85,249,168,169,233,20,1,154,107,194,183,228,34,208,175,191,218,208,246,140,114,92,116,55,161,197,179,149,0,223,242,54,114,29,72,247,226,70,185,101,79,140,25,243,235,168,165,43,20,115,82,32,241,151,159,83,133,30,73,128,132,65,36,221,240,104,22,126,114,154,148,43,71,247,15,157,81,88,32,253,125,83,223,62,143,208,53,17,55,249,144,47,91,35,57,186,1,113,150,108,41,208,21,36,109,125,33,48,216,234,154,188,90,150,63,28,227,14,28,136,208,185,196,163,206,183,140,11,25,153,140,198,177,89,138,182,47,47,171,242,47,93,55,25,148,208,238,252,95,82,228,62,4,84,81,191,83,51,160,156,199,175,18,170,93,116,168,81,32,135,89,177,76,68,246,88,2,88,52,1,106,106,147,147,148,22,225,34,72,201,127,118,43,191,233,162,163,88,49,234,87,155,194,91,42,215,76,82,236,27,233,142,107,212,68,166,149,62,202,4,78,202,220,135,157,203,99,30,220,163,18,18,206,36,29,185,101,155,105,73,244,174,232,241,48,45,245,11,31,88,179,237,202,131,37,102,128,95,114,229,186,19,35,162,166,87,122,191,15,187,237,138,136,189,171,133,226,99,53,254,164,232,16,59,177,251,237,38,31,126,76,235,165,223,225,93,141,225,45,44,119,254,206,134,127,6,41,120,45,49,197,58,0,90,117,149,33,228,245,6,188,7,53,12,172,189,66,121,15,4,14,154,85,111,52,27,144,54,50,179,89,48,63,112,166,178,62,97,64,94,246,243,39,161,86,112,12,130,213,88,177,203,200,252,177,57,157,94,113,198,191,246,177,41,13,49,119,90,129,157,92,82,230,186,120,208,227,9,1,156,208,195,90,151,85,7,66,148,235,121,206,169,126,245,235,82,162,105,14,125,92,16,106,129,153,232,199,105,53,170,100,215,135,221,178,70,157,78,154,111,254,119,150,27,41,72,14,218,94,19,176,236,14,75,90,93,140,113,106,111,255,117,140,205,37,6,86,62,239,13,32,157,95,9,113,215,47,95,47,35,54,79,32,196,174,202,82,33,238,240,221,83,169,239,132,32,24,220,194,235,38,236,87,10,211,145,162,231,214,138,246,138,19,15,188,124,62,134,90,123,252,142,35,108,144,248,77,91,33,160,4,251,41,70,104,147,9,147,205,114,230,75,78,62,23,161,155,101,40,255,3,241,71,89,213,45,121,244,143,224,52,163,42,191,16,231,143,97,68,171,146,198,41,128,164,100,190,251,13,66,70,74,56,9,153,160,4,225,91,150,58,114,212,238,46,49,171,187,112,63,70,216,216,250,25,215,221,119,186,250,220,29,252,233,91,159,122,204,39,131,184,180,19,148,105,188,220,99,63,49,60,174,158,44,134,47,86,155,185,162,166,14,96,53,249,18,218,86,222,160,93,166,130,182,129,104,163,191,179,159,23,78,251,37,169,52,22,36,200,110,255,1,119,137,208,141,146,150,205,196,50,17,199,96,143,103,155,154,196,44,163,127,50,159,24,76,66,58,48,226,159,107,6,131,221,189,172,198,147,11,251,250,129,85,164,59,90,63,178,112,18,52,211,118,140,181,31,190,235,77,0,252,40,168,97,205,183,76,60,111,223,240,133,229,17,16,107,155,220,56,101,44,40,89,20,176,44,159,95,186,38,20,232,67,70,14,71,156,254,40,149,249,35,253,54,6,54,183,81,191,87,129,73,186,58,119,88,106,23,155,199,12,251,83,86,201,48,166,176,206,95,141,143,241,83,36,243,202,39,187,246,157,180,26,230,11,60,153,60,114,233,72,167,15,226,90,154,71,246,117,231,207,127,115,132,72,204,177,179,195,243,117,242,163,220,135,185,72,49,247,113,89,248,120,228,204,124,118,239,61,148,142,234,8,31,10,43,43,41,145,180,196,248,141,204,210,219,234,129,242,77,145,14,91,43,223,82,26,34,254,199,118,186,218,161,245,186,144,108,106,79,230,241,138,191,234,139,177,85,203,226,253,244,110,30,97,26,219,8,183,188,107,46,149,6,194,7,84,196,217,69,209,1,224,125,224,247,58,104,70,195,126,227,108,7,229,43,165,156,48,247,161,101,236,244,13,58,4,9,59,183,179,119,209,112,230,5,100,106,124,217,113,129,123,196,25,17,53,109,238,99,155,90,84,100,34,254,148,76,13,53,90,9,98,133,253,183,146,106,144,52,248,243,162,130,174,177,148,239,154,253,179,243,186,154,33,208,93,86,63,180,180,172,231,196,17,255,86,138,184,95,232,56,112,235,191,93,47,138,94,180,195,78,141,162,147,248,238,77,134,225,153,175,243,31,23,13,206,223,32,185,213,142,26,56,248,82,70,153,103,191,179,49,115,74,16,87,182,238,234,246,161,197,41,170,248,232,115,237,189,11,183,32,101,236,95,252,138,189,223,70,17,241,135,139,24,117,97,51,80,82,145,152,248,152,127,73,116,253,202,180,102,29,34,138,34,183,210,201,34,66,34,208,117,208,35,208,13,33,208,215,245,243,231,152,17,237,210,66,161,14,84,129,141,221,52,85,251,143,65,34,117,86,68,84,108,186,252,32,232,199,131,132,238,190,4,77,231,176,190,88,53,133,55,201,130,71,46,22,41,65,78,240,25,57,35,46,144,87,24,60,39,239,168,187,102,79,136,154,60,247,75,62,79,2,135,229,45,190,164,23,108,160,228,103,160,120,129,218,50,12,2,152,136,102,79,140,46,85,245,59,139,25,112,242,170,253,99,67,102,174,68,215,57,252,70,157,156,92,53,60,85,141,254,219,198,35,78,248,148,29,149,232,72,72,59,33,78,208,106,254,57,181,241,35,238,199,75,118,156,35,45,40,24,142,53,251,146,131,129,69,135,38,61,186,148,151,63,76,193,228,150,230,53,196,213,28,159,108,45,63,25,2,238,49,14,202,65,154,73,105,56,75,133,194,27,39,22,8,31,95,174,61,192,203,44,155,145,65,183,37,165,21,101,112,40,128,245,166,140,111,213,42,112,117,194,197,115,240,59,18,169,159,186,103,228,120,219,197,89,198,212,94,115,73,168,140,65,102,128,75,158,81,226,174,18,161,211,246,32,253,184,71,172,134,75,186,104,128,218,93,219,181,192,128,50,23,3,41,237,134,6,38,48,108,16,55,156,82,207,76,213,9,92,133,177,99,80,223,104,101,177,65,166,194,147,21,215,202,113,172,18,21,15,170,83,55,138,140,167,140,23,56,87,42,168,246,20,28,103,9,244,69,51,34,131,70,26,172,250,34,122,155,237,223,239,82,158,159,124,70,204,72,75,4,45,233,9,162,249,224,130,174,205,229,60,212,236,79,252,165,32,200,246,16,220,187,60,123,13,67,49,235,46,41,202,79,70,214,220,105,16,208,76,218,14,107,118,159,54,97,134,79,138,238,145,134,227,55,124,113,67,125,12,108,61,172,111,181,24,245,152,167,176,135,167,145,13,235,143,167,123,62,220,21,222,139,117,158,242,215,224,210,40,111,64,146,47,21,70,95,95,100,180,89,234,62,209,169,238,160,137,178,125,78,139,133,5,121,129,42,170,211,254,105,103,114,29,248,27,106,182,232,92,150,245,149,0,76,156,11,252,13,88,99,174,83,11,3,84,120,64,145,101,98,95,192,153,113,132,23,92,8,66,120,158,129,12,154,214,231,1,71,4,96,198,132,159,145,144,56,97,114,44,114,72,89,10,216,186,147,144,181,164,143,249,144,161,236,35,101,24,80,237,252,108,25,37,39,101,102,105,25,247,26,249,172,53,53,21,9,43,52,190,196,73,7,98,201,131,243,84,73,202,233,76,240,182,76,27,125,90,140,51,235,213,6,23,142,68,78,35,103,71,218,245,219,31,53,79,202,197,28,193,77,11,27,102,79,80,148,199,37,43,17,48,220,135,59,15,234,166,175,62,205,241,69,27,85,237,155,38,110,10,14,79,128,179,241,9,231,55,240,118,184,18,38,58,183,71,29,62,235,210,162,85,149,194,68,171,232,239,10,134,200,208,71,213,60,21,56,0,59,181,34,158,109,11,22,247,154,180,242,183,107,53,165,33,119,130,220,58,48,212,90,30,103,104,159,67,193,109,124,218,56,140,107,219,56,78,173,61,75,118,115,247,136,204,179,24,181,153,157,251,19,3,98,114,87,176,160,72,26,35,7,176,77,150,160,17,226,205,130,180,113,113,123,106,197,132,46,182,118,33,65,55,249,137,241,60,246,73,18,139,182,110,141,105,11,124,63,147,222,233,12,192,160,18,213,243,184,206,64,53,174,140,69,233,73,191,19,43,156,189,130,98,212,231,221,68,82,255,58,99,219,91,95,207,146,220,69,221,60,155,63,202,75,65,156,241,7,30,49,49,169,208,22,243,250,127,109,246,182,187,191,95,146,117,207,231,188,225,178,205,186,58,117,172,80,0,3,121,181,90,203,146,93,211,173,158,184,122,72,59,88,148,203,171,202,60,172,115,236,145,231,211,229,67,37,168,3,236,232,1,46,147,145,174,21,53,219,104,31,92,228,35,79,169,219,193,227,151,112,32,143,196,9,249,208,240,204,166,128,3,247,67,185,135,167,212,76,114,243,215,237,217,243,36,68,189,248,122,32,9,91,240,113,228,51,143,166,198,41,126,244,191,120,158,180,6,183,195,75,103,32,65,115,83,59,94,191,42,159,186,166,230,99,28,196,65,65,99,231,9,135,46,212,99,6,25,74,107,95,86,30,94,8,36,53,93,22,138,216,149,214,126,251,81,207,219,245,37,196,103,116,57,139,138,125,48,103,106,199,14,41,156,17,30,222,172,220,85,169,156,234,142,123,38,70,54,161,161,236,26,246,66,34,57,75,44,9,149,181,240,106,55,124,33,187,56,127,107,1,201,32,35,81,163,131,82,202,68,191,69,105,21,6,94,188,95,189,36,123,6,15,60,226,144,245,120,56,3,78,228,41,112,164,39,194,1,42,243,23,189,47,121,51,60,233,153,161,2,111,37,82,25,103,22,194,212,172,16,228,89,200,45,66,30,251,252,245,161,182,254,1,4,96,88,162,255,114,194,144,42,14,76,169,203,38,28,35,52,113,50,159,198,245,107,89,4,220,186,180,239,238,234,10,212,217,38,179,35,163,245,220,233,62,254,158,58,122,216,229,177,34,190,64,194,241,200,169,226,248,24,168,141,141,82,252,77,173,8,107,199,33,85,123,244,17,23,7,216,161,71,182,228,14,254,48,110,244,49,102,99,171,94,133,247,170,43,25,227,209,33,109,191,153,226,211,221,231,92,86,126,123,245,208,84,2,221,173,123,208,168,33,229,223,5,98,160,86,233,207,155,35,88,174,151,78,242,58,111,168,197,17,111,50,190,201,122,21,151,27,180,243,103,128,93,62,67,216,150,255,135,78,100,57,155,29,45,184,35,7,52,187,252,99,69,207,230,43,180,67,182,51,91,197,222,15,242,118,136,154,66,1,229,33,153,18,182,22,158,30,164,166,5,153,185,111,236,151,113,66,30,198,12,171,137,105,17,33,50,95,186,183,179,4,109,193,151,82,63,157,56,97,117,71,227,168,27,197,140,164,80,204,155,173,112,200,211,53,99,100,1,141,74,53,27,236,147,96,228,83,228,181,7,155,224,252,74,13,228,113,125,98,159,248,166,1,51,225,172,191,14,237,114,241,126,30,196,68,130,244,175,193,225,125,20,177,56,249,48,253,160,123,96,174,6,164,109,171,142,250,66,34,177,157,38,66,67,163,61,123,85,53,236,126,198,149,218,128,254,250,23,213,25,24,19,9,80,124,76,81,82,88,35,164,35,118,180,3,143,155,95,119,204,184,233,56,172,145,200,132,168,0,103,1,252,39,61,251,210,145,83,218,100,4,165,154,207,203,165,246,199,56,89,150,173,92,190,184,203,156,95,166,182,45,228,125,174,35,242,33,138,199,144,180,47,30,105,232,194,18,188,32,154,138,179,185,196,218,105,79,87,13,73,108,61,170,19,90,163,37,102,207,216,234,216,83,198,98,158,181,106,82,79,106,209,98,221,192,11,94,228,48,34,242,172,184,33,210,177,217,203,148,167,246,145,81,9,147,67,113,154,251,177,117,219,55,202,189,152,76,91,53,66,235,207,40,7,45,153,81,177,2,177,212,232,52,91,94,184,4,59,137,9,196,252,193,165,192,128,15,94,255,217,55,16,232,239,187,6,101,25,157,75,178,39,152,139,157,22,50,206,255,59,247,110,176,131,75,27,136,41,128,117,142,49,92,147,50,48,135,32,199,8,61,252,99,234,67,252,207,207,57,86,224,186,77,31,119,136,67,79,203,52,133,199,200,6,95,221,234,134,49,73,175,23,206,8,255,178,181,53,47,143,160,235,1,115,231,150,145,135,184,72,71,121,91,67,66,115,150,59,194,114,79,30,254,148,208,54,104,61,223,97,236,95,22,201,133,139,67,200,167,193,219,211,116,90,89,233,101,101,151,189,183,183,114,168,38,126,206,15,99,191,147,172,205,163,169,231,94,226,156,207,136,13,210,85,189,92,43,116,228,221,129,143,102,168,216,72,46,244,164,143,70,6,134,101,205,64,158,62,243,230,95,67,198,158,98,79,169,62,86,9,106,199,194,100,20,222,193,19,147,33,255,149,113,223,56,49,45,79,48,126,143,212,169,237,35,101,196,191,139,14,242,22,74,107,124,31,140,152,98,159,187,254,100,210,119,87,198,134,68,186,194,45,152,225,240,40,110,160,54,17,247,180,37,207,220,90,191,184,249,109,192,139,213,79,103,42,232,129,74,251,147,66,215,94,2,183,71,32,109,4,219,22,131,5,103,49,38,56,242,126,128,195,134,129,226,80,132,72,146,171,167,1,139,37,183,164,163,62,26,107,122,245,28,224,181,202,139,206,6,243,67,252,59,108,81,241,225,168,14,233,99,97,109,252,25,136,216,218,2,200,3,119,199,235,83,240,34,17,243,32,142,244,40,183,45,246,214,188,66,90,116,55,192,220,144,178,191,206,136,131,52,135,208,88,46,18,230,239,237,183,38,107,126,157,27,66,30,15,245,243,254,241,135,39,18,41,14,114,250,4,197,43,187,64,64,15,208,46,127,90,87,120,35,216,57,49,30,104,180,138,225,249,168,211,210,144,227,127,35,164,96,74,146,195,68,10,166,121,162,159,57,60,163,6,224,187,205,84,184,136,62,142,147,114,217,143,66,243,158,159,73,28,21,121,252,246,169,98,31,18,151,35,149,105,153,65,196,108,80,232,38,4,78,105,2,222,182,233,79,218,34,90,74,210,217,20,13,10,192,214,1,116,232,4,66,213,236,195,233,77,148,196,109,91,241,4,226,140,62,206,82,220,34,248,36,125,36,54,242,130,223,106,51,178,147,120,117,95,94,225,38,167,219,118,161,202,146,225,118,27,170,216,124,245,35,215,94,141,31,165,194,191,83,169,227,84,130,49,151,87,80,239,141,245,17,48,2,123,76,250,42,119,202,9,222,238,219,46,232,242,219,77,62,206,70,114,218,72,72,98,80,34,10,188,10,251,197,104,72,169,52,162,236,127,161,101,235,2,62,112,11,164,137,194,121,56,45,86,10,121,200,120,195,121,237,18,22,147,83,100,6,118,104,150,184,202,173,50,145,204,229,195,197,191,87,187,1,247,227,4,201,140,236,79,104,230,248,89,240,17,181,170,239,195,149,65,55,41,223,195,50,94,71,32,210,144,212,201,53,56,245,180,207,181,1,133,202,127,253,230,202,144,174,133,17,112,128,81,211,86,221,103,78,174,149,110,149,63,177,221,175,114,130,145,143,18,223,13,164,3,99,249,219,126,245,115,49,176,1,195,221,204,253,209,9,203,162,204,49,175,122,99,76,191,139,1,147,206,84,112,245,51,6,3,88,99,181,61,222,246,164,211,236,9,138,14,108,105,125,70,9,44,166,33,243,93,184,145,212,149,159,201,217,52,222,13,235,24,183,88,96,47,110,20,104,58,163,63,251,87,206,45,3,61,235,73,102,142,90,169,84,83,176,209,35,109,162,73,219,85,85,200,239,215,137,248,184,194,80,124,146,253,36,231,86,232,168,89,130,215,48,207,10,33,39,56,33,166,57,246,66,99,138,93,14,110,46,147,195,207,9,220,27,250,249,51,237,106,235,190,199,89,196,36,43,153,194,228,229,184,36,30,156,184,128,154,157,179,44,66,168,32,223,187,11,105,193,169,68,108,142,193,254,252,65,243,7,186,150,220,119,251,22,51,117,115,209,206,94,175,178,153,144,232,219,232,202,56,60,182,254,245,82,106,160,213,237,4,110,16,8,231,196,87,172,72,168,169,231,240,184,119,65,244,113,170,142,30,171,212,73,125,158,245,36,213,237,212,99,222,32,235,78,116,134,1,145,210,32,146,55,228,250,72,94,222,246,147,213,220,32,166,216,132,165,36,139,93,38,126,240,252,174,73,114,112,9,238,129,94,47,156,27,98,107,233,197,192,11,3,6,0,89,249,134,154,137,172,169,157,97,129,235,51,172,154,134,164,13,109,188,213,185,180,237,125,30,153,162,60,20,160,89,199,158,176,121,213,65,189,94,146,225,166,49,191,34,80,103,161,95,135,231,49,56,120,201,70,96,28,53,237,84,65,126,76,244,2,120,5,157,155,2,8,248,163,202,248,178,31,2,103,189,217,46,222,201,3,15,162,199,69,121,23,101,148,229,244,105,52,12,25,153,20,34,96,49,153,69,251,95,44,150,238,6,247,203,246,93,197,105,204,55,88,120,145,50,183,168,169,142,102,167,156,38,190,108,73,235,185,169,4,43,222,3,213,229,79,145,199,169,86,15,16,248,180,49,211,199,124,215,175,228,243,4,185,6,196,208,98,135,144,185,79,209,164,107,74,113,45,53,59,237,21,171,113,219,63,215,1,151,253,40,202,230,252,21,81,151,116,135,3,57,83,66,186,188,9,140,49,39,167,219,5,116,195,96,171,41,3,6,4,194,221,212,163,195,112,87,198,5,128,31,27,85,122,234,222,196,21,135,21,162,118,97,50,102,85,84,223,36,28,39,53,3,79,187,85,249,159,74,40,23,163,197,57,62,65,17,249,131,125,210,1,217,207,37,164,117,164,25,14,77,122,217,94,146,157,131,162,118,168,106,245,79,161,0,171,141,189,74,4,219,166,140,205,1,166,105,0,8,128,154,249,80,136,90,19,56,236,58,147,92,214,160,222,133,162,169,158,74,186,172,49,40,254,7,87,214,41,167,181,35,93,169,82,159,58,141,147,200,162,90,203,180,209,95,199,11,98,192,197,234,175,80,100,176,54,250,168,149,203,135,158,217,213,227,202,239,91,102,172,33,131,132,11,118,87,125,168,138,138,209,136,249,221,30,181,149,215,62,129,55,49,64,61,28,95,98,44,132,42,120,147,252,220,111,228,85,11,36,128,213,117,52,74,96,208,244,104,253,242,59,117,94,35,233,74,246,118,97,127,77,115,69,139,111,143,136,73,75,148,69,37,188,53,101,37,64,108,74,167,164,127,57,229,30,6,179,12,32,221,186,208,213,8,85,86,89,214,38,81,84,114,109,251,80,129,167,201,8,137,238,73,52,105,225,50,81,84,79,77,47,13,65,200,12,24,176,21,161,96,29,87,150,116,14,206,60,107,163,39,53,117,63,216,246,239,157,234,215,15,92,199,81,250,65,180,200,64,151,116,229,252,139,240,76,174,144,187,181,172,195,61,163,95,60,165,224,156,139,188,182,132,11,224,166,106,31,234,186,15,236,12,91,184,3,241,109,136,215,198,245,38,201,128,147,176,109,110,6,21,98,227,122,213,85,91,17,113,48,121,231,89,75,189,102,114,78,194,219,190,92,208,4,235,137,110,168,153,210,133,243,20,115,105,72,104,211,60,135,127,17,108,195,160,203,108,7,114,125,202,222,233,133,216,189,126,111,19,108,106,239,125,197,248,97,205,127,175,29,58,213,164,124,247,113,7,139,120,98,191,197,245,4,250,74,252,205,212,121,78,60,73,244,42,218,203,244,93,94,223,104,185,216,255,138,71,22,253,200,171,192,54,254,141,207,227,0,150,31,1,147,21,7,125,68,108,180,13,26,208,40,13,197,245,209,128,239,94,53,123,184,56,68,103,131,24,161,114,22,215,77,55,136,176,152,252,26,25,141,21,53,117,176,38,15,49,17,67,169,121,53,128,141,102,193,187,128,191,227,101,24,86,184,72,57,96,94,251,131,222,128,106,22,195,120,88,113,22,143,5,248,40,90,63,235,159,71,4,187,14,72,238,20,13,89,62,105,246,186,79,177,112,116,156,166,163,250,163,164,101,121,74,44,53,181,217,86,25,135,252,139,67,235,237,194,185,215,44,155,127,22,207,100,13,80,60,64,112,45,199,244,214,16,248,221,245,121,9,45,223,7,51,99,191,253,65,144,40,85,54,208,212,186,149,219,252,104,132,254,107,186,67,232,63,113,255,221,37,242,232,33,223,51,169,247,122,149,245,252,250,57,52,145,132,117,103,149,215,230,103,255,57,237,209,113,255,127,180,172,161,148,36,180,96,108,140,87,251,146,79,245,134,99,84,163,57,169,54,167,112,99,116,111,227,230,202,235,147,202,14,158,90,116,113,62,154,234,179,192,109,104,79,26,238,106,96,228,134,4,73,54,63,189,74,28,178,153,88,107,74,45,171,217,108,131,34,213,197,42,76,163,204,249,241,241,115,166,143,154,108,190,26,148,100,255,85,126,50,29,5,167,111,143,237,120,247,83,244,75,239,56,162,7,240,211,246,51,248,211,251,207,141,229,245,213,253,89,241,166,211,220,131,250,216,148,164,47,204,86,152,179,106,152,210,82,12,223,196,123,160,72,236,30,114,217,85,187,52,124,94,81,50,246,170,161,232,213,7,82,104,58,160,68,99,143,160,12,70,100,112,117,39,122,108,195,139,25,163,254,7,121,76,8,48,198,63,104,8,176,251,182,107,148,41,95,30,20,51,159,18,233,181,96,86,78,50,50,24,41,110,182,209,133,193,237,160,131,210,8,63,104,231,24,201,129,242,29,27,43,154,214,28,207,176,109,138,213,55,126,19,77,214,173,210,120,42,50,69,50,144,180,219,13,114,109,206,76,73,208,89,0,74,73,176,143,192,194,103,210,15,199,123,238,205,96,57,231,147,93,118,56,19,82,171,19,148,228,155,117,204,178,141,139,173,52,104,117,182,178,85,248,236,117,69,50,168,192,67,203,117,151,21,152,20,53,147,150,21,160,2,36,28,241,201,117,144,75,103,214,190,39,118,130,223,252,187,12,122,109,113,244,182,238,152,109,70,224,158,205,48,146,6,72,208,123,6,189,73,152,248,235,158,52,4,190,249,48,1,227,185,96,228,211,113,79,9,166,135,33,111,242,64,52,115,22,57,151,34,122,69,60,17,253,131,99,22,248,176,134,16,238,107,182,154,46,137,97,219,233,134,40,29,43,69,230,192,71,6,183,224,32,189,133,170,99,114,96,4,52,167,206,176,214,222,55,211,54,157,243,202,234,35,134,64,89,56,202,91,185,250,250,204,113,161,83,73,4,187,38,213,18,139,48,87,120,252,59,239,37,169,128,214,89,252,105,162,191,1,57,12,96,57,214,106,111,119,128,142,193,176,65,236,20,137,136,216,201,195,48,65,109,34,75,129,241,39,21,49,18,120,64,46,14,63,56,114,118,180,32,109,26,69,217,236,26,40,8,216,37,136,133,241,204,71,39,66,246,151,168,189,182,29,123,179,223,70,168,85,237,136,96,222,20,140,68,105,216,43,253,49,123,124,218,236,63,29,175,239,233,52,226,194,178,94,4,209,161,111,5,65,163,178,93,66,72,211,133,64,85,147,238,227,156,7,99,203,101,159,143,255,11,171,78,217,250,156,153,231,167,245,61,16,184,167,222,152,154,88,82,26,173,133,92,30,222,29,242,245,108,232,55,19,40,142,158,192,124,253,20,244,168,22,11,213,162,205,54,94,77,43,208,104,187,147,61,29,94,228,248,170,169,224,254,171,100,74,178,20,114,63,227,209,33,43,238,226,70,159,214,150,21,127,206,232,123,172,255,187,30,194,66,75,87,100,175,165,219,212,111,167,69,27,84,234,45,248,78,25,131,28,192,243,234,64,118,149,101,73,10,76,29,36,168,135,161,158,133,89,255,235,53,217,179,237,79,180,74,150,130,126,134,251,167,157,131,197,228,108,99,175,122,254,153,84,139,159,129,202,230,123,143,201,87,119,115,245,23,186,236,20,182,197,32,247,122,160,148,65,78,69,36,188,20,169,225,126,154,109,199,132,205,74,222,183,150,7,61,161,196,22,189,115,22,141,194,173,212,34,242,22,127,93,196,10,75,77,90,153,89,70,223,197,65,238,209,142,46,126,182,203,204,82,255,130,58,54,29,192,82,219,235,21,6,71,133,216,22,106,46,26,40,113,44,97,120,61,14,240,205,16,196,22,46,94,69,203,247,147,61,108,246,161,201,165,68,80,15,97,117,220,165,91,178,178,166,116,108,172,57,55,161,158,255,223,131,236,86,182,141,43,151,218,126,196,142,50,186,50,132,166,213,28,42,119,171,19,234,64,209,208,109,134,211,135,67,119,220,190,109,125,73,60,211,244,39,18,26,107,211,154,149,229,192,236,196,48,140,73,252,57,35,98,97,167,181,62,104,46,217,84,141,170,176,188,60,141,185,178,246,164,158,14,164,102,63,12,45,226,247,2,187,120,161,136,96,174,64,231,134,199,15,98,18,204,103,167,236,148,63,67,98,132,93,239,91,171,231,10,246,216,1,23,3,16,28,176,79,209,242,126,123,208,111,26,114,239,53,9,107,232,212,124,82,30,17,15,255,90,178,101,189,165,76,91,26,12,58,200,240,31,229,181,23,40,91,102,232,77,50,5,213,116,128,154,213,16,119,250,71,107,189,50,131,221,111,227,76,166,117,27,205,117,36,156,167,156,71,52,76,222,118,115,184,230,236,60,208,67,222,2,144,147,6,60,19,224,15,183,53,84,150,58,110,40,7,42,123,91,20,30,173,117,178,76,18,53,164,24,133,238,64,121,13,245,77,250,85,81,149,229,198,31,186,247,98,241,3,98,69,31,86,102,65,27,146,108,136,132,43,125,205,26,141,155,64,6,167,108,192,11,197,199,60,75,152,243,213,127,47,240,127,11,79,72,171,143,208,195,25,69,64,200,140,240,83,69,91,87,224,27,53,18,187,114,251,77,238,172,188,184,246,18,134,182,21,17,78,55,56,3,190,49,130,8,5,63,2,91,125,129,109,160,36,85,244,132,68,16,90,98,214,218,175,240,125,41,163,75,196,171,138,172,49,73,8,54,182,90,135,227,102,81,208,76,214,241,251,219,86,101,101,65,171,217,0,8,149,216,114,134,64,200,236,203,140,252,204,155,243,37,204,180,93,221,13,162,158,38,209,74,36,44,179,252,198,202,86,90,24,173,87,96,159,193,101,145,150,153,122,118,106,94,36,111,203,174,42,124,221,168,194,228,77,165,45,236,119,160,211,164,7,162,28,88,49,230,63,46,111,177,62,158,0,171,214,75,34,154,245,1,142,162,49,103,199,198,244,121,88,5,242,215,40,89,85,78,154,228,3,10,249,0,238,85,51,137,87,26,53,38,76,248,229,100,101,14,212,91,65,175,121,43,249,193,127,255,1,73,226,52,75,175,61,139,138,150,130,3,125,35,236,94,235,246,243,62,3,237,50,105,70,245,215,226,172,165,121,224,74,204,70,132,186,37,95,236,115,224,106,30,159,208,189,189,218,103,118,133,149,153,46,176,35,255,203,105,118,214,48,205,43,9,13,217,161,214,215,48,158,31,129,193,216,139,243,175,155,65,253,144,190,63,242,88,90,20,21,47,53,175,85,212,122,36,12,116,126,101,129,47,25,55,187,208,232,157,151,244,164,38,252,173,242,238,130,26,129,29,213,11,208,26,31,254,36,213,33,158,44,140,231,189,41,88,247,25,17,71,71,167,5,253,194,78,244,67,149,40,89,61,217,144,240,227,248,93,255,219,226,45,187,160,76,63,101,239,39,108,138,249,81,84,202,172,59,24,160,78,69,17,208,248,108,189,3,229,203,66,87,88,74,18,225,153,96,53,52,89,119,116,57,190,108,190,80,20,105,164,98,174,61,45,67,61,175,170,122,245,181,0,1,251,233,29,92,152,174,255,54,182,196,150,27,223,160,217,85,194,155,214,103,201,171,100,55,209,112,37,236,226,177,32,61,111,142,9,26,200,147,11,131,31,41,120,177,168,14,7,154,212,143,244,77,64,184,5,185,242,167,69,128,53,254,145,113,23,197,209,173,0,5,101,156,43,218,95,236,68,43,178,117,143,123,57,75,177,64,52,31,66,49,198,75,156,113,61,193,109,106,51,105,102,127,167,148,82,80,100,97,131,205,180,200,216,14,146,206,115,197,159,192,168,121,114,222,21,48,75,25,151,46,111,245,83,223,231,8,159,96,194,234,136,33,88,103,235,132,19,227,152,220,101,82,223,92,237,191,73,6,77,24,214,10,194,135,83,3,212,248,101,135,3,43,181,60,234,179,220,173,247,156,248,188,202,32,22,244,222,159,129,118,234,253,57,251,84,188,143,196,153,42,161,206,186,247,200,209,252,99,35,110,240,98,107,229,61,225,152,80,45,32,235,106,142,37,118,168,255,124,111,211,13,225,176,89,141,99,87,29,57,72,234,235,249,152,228,221,73,61,145,122,199,183,118,62,54,97,19,139,81,160,88,90,125,120,247,192,83,225,175,232,17,178,162,53,215,159,17,172,131,142,135,123,217,94,234,50,246,65,80,78,49,166,14,113,10,63,152,10,13,186,119,135,94,33,83,105,91,253,101,170,55,217,122,231,253,231,117,93,88,204,152,21,57,206,180,142,174,211,60,74,113,45,250,248,185,179,252,31,195,184,120,62,49,201,98,204,204,144,48,255,131,35,244,151,61,232,41,199,168,246,192,53,27,54,241,5,41,34,46,197,192,212,166,169,160,252,76,0,38,180,40,10,16,248,0,134,187,234,243,231,210,8,220,131,20,10,47,183,159,16,248,26,104,18,70,141,175,131,30,111,139,245,41,81,112,24,17,158,243,126,19,76,35,154,19,118,14,77,243,105,186,63,11,9,54,14,67,18,143,109,77,159,46,200,115,135,40,82,198,39,167,123,110,240,114,206,193,203,130,220,42,52,35,118,66,199,173,6,160,74,218,122,161,100,47,92,216,202,9,227,118,6,238,122,144,90,180,97,44,143,136,195,31,205,252,189,255,18,19,246,139,172,236,219,49,235,24,248,31,181,198,237,35,56,90,63,106,253,122,103,124,254,187,2,227,91,78,38,4,88,234,44,77,99,253,108,197,46,20,129,43,35,236,35,229,142,8,85,63,215,69,95,32,44,131,48,199,22,106,176,15,158,49,119,176,168,55,102,53,219,210,30,104,227,161,236,36,31,233,110,108,96,34,154,67,62,76,75,0,207,55,62,23,152,30,113,75,210,120,126,61,69,28,191,12,86,154,240,157,13,15,88,81,24,254,15,187,86,199,83,117,176,214,32,14,240,206,235,176,169,130,31,18,24,21,2,241,77,189,99,209,43,26,43,210,20,166,196,92,18,114,105,221,73,218,172,48,85,107,191,26,221,108,187,69,226,47,220,130,129,35,14,209,10,60,62,108,153,3,52,168,134,88,242,45,44,218,215,149,24,2,7,30,115,93,205,232,36,202,127,172,107,22,232,110,185,178,62,86,49,153,128,109,214,226,8,233,137,214,237,206,154,70,235,215,44,206,183,69,132,139,204,201,61,185,180,25,98,255,105,200,181,151,71,140,84,181,211,216,87,50,98,164,46,10,239,244,233,41,100,120,175,109,61,170,248,110,87,215,43,124,19,162,205,141,14,83,81,77,145,38,154,221,130,125,12,119,16,6,39,106,60,227,52,33,144,184,41,228,155,243,113,20,160,168,241,16,151,98,103,24,79,151,63,214,125,89,63,48,139,7,40,174,238,136,30,236,31,220,255,244,32,187,81,212,155,250,210,225,154,78,121,201,13,37,47,84,219,67,124,89,47,31,113,9,68,17,250,240,153,101,45,134,124,153,189,145,59,0,62,231,82,228,25,247,109,23,204,196,245,6,32,165,240,47,173,61,152,219,60,157,54,7,141,165,134,29,167,35,97,77,18,33,227,29,54,106,92,230,215,142,90,165,179,80,175,140,52,235,127,19,142,197,223,170,26,176,60,26,51,216,231,214,60,195,174,252,210,242,205,216,74,143,230,245,207,112,90,92,135,50,65,33,199,255,192,247,144,84,45,220,233,82,166,238,17,92,94,194,12,134,254,86,45,203,217,132,21,218,81,22,166,24,199,137,79,34,232,178,182,207,131,11,5,72,22,4,222,14,238,163,151,115,102,72,5,60,207,220,72,189,114,110,175,43,216,16,177,120,118,180,53,158,193,44,7,17,127,149,13,12,24,204,145,100,185,163,252,126,81,127,62,237,132,84,181,20,156,144,149,224,136,243,91,85,123,18,154,250,184,61,218,12,199,10,231,16,242,253,183,20,87,22,197,185,20,160,112,156,195,149,200,175,190,119,186,179,151,59,4,118,127,246,0,171,9,175,200,90,95,82,76,176,68,10,33,49,55,179,39,245,21,186,135,145,215,146,188,22,109,164,36,107,222,114,229,169,212,249,90,250,58,148,169,62,156,126,146,154,250,129,219,72,23,235,160,214,207,172,51,100,73,2,111,17,107,180,43,11,242,178,2,221,76,139,214,133,122,193,103,59,164,129,235,49,86,114,17,71,121,127,45,197,120,214,87,60,248,173,238,153,85,139,74,224,81,163,104,130,229,66,242,25,135,223,185,29,38,116,32,154,147,123,137,215,26,58,190,170,29,244,214,79,55,176,203,228,168,229,201,49,120,50,80,90,179,201,203,31,174,192,142,114,119,187,14,150,46,198,246,62,33,28,102,83,75,202,120,124,147,102,175,132,245,189,253,176,88,78,162,4,65,101,23,33,75,89,35,46,4,226,63,255,185,102,214,10,237,109,162,212,175,61,170,43,169,209,240,223,34,117,48,54,228,26,248,16,96,172,97,46,210,71,212,176,210,177,117,239,11,186,194,248,195,224,184,125,134,94,6,110,99,236,158,102,102,202,111,50,220,250,201,217,243,147,165,214,126,242,58,6,166,134,243,4,166,174,208,11,191,203,2,41,172,90,66,88,14,95,88,8,162,116,176,129,85,143,208,6,137,53,245,178,77,217,233,3,33,56,127,67,77,68,227,204,196,158,155,158,209,160,199,10,45,162,36,48,83,183,141,10,45,36,153,178,61,244,66,49,3,181,148,140,99,175,81,83,176,185,1,183,102,12,0,143,96,93,25,113,161,223,105,110,80,62,42,176,0,2,40,215,214,94,150,210,31,62,137,152,85,207,219,209,64,212,20,62,196,56,70,135,89,228,2,10,56,231,81,101,169,218,167,118,203,2,139,100,163,114,33,75,99,186,223,216,51,93,189,134,43,87,202,149,109,120,107,186,125,95,239,19,203,123,49,166,114,10,162,5,7,12,176,15,120,26,35,21,31,247,127,153,57,137,196,236,75,232,134,87,117,155,150,255,81,212,122,39,75,131,60,79,45,162,203,123,236,231,156,185,213,217,192,219,123,17,229,201,151,184,105,226,181,31,14,77,254,217,12,16,119,38,20,130,167,75,67,4,141,91,15,163,105,99,163,148,4,76,63,138,107,204,84,9,101,140,9,57,165,20,33,229,14,253,79,49,68,15,172,242,229,16,83,223,131,121,55,107,101,5,75,145,252,96,157,56,106,240,77,238,87,3,109,69,18,3,86,181,170,160,147,36,75,13,97,171,56,42,141,3,132,89,217,206,147,251,31,186,148,10,183,96,104,11,66,206,233,253,42,45,6,204,119,187,177,251,126,206,133,220,15,183,6,12,249,219,190,170,152,47,136,152,97,213,150,42,139,117,92,22,112,55,40,42,43,105,107,186,113,211,67,95,45,244,65,248,126,14,70,177,136,239,57,130,254,28,136,140,29,64,179,1,44,53,52,26,26,32,84,57,32,127,67,198,134,253,228,249,33,142,102,115,199,222,144,45,152,143,216,19,188,48,164,160,2,194,216,177,124,118,5,177,68,6,14,122,36,188,127,171,67,212,206,163,148,242,5,138,155,155,67,63,144,19,231,57,206,30,11,233,238,104,230,165,30,143,20,121,56,214,234,41,171,227,134,238,160,28,82,194,184,1,149,79,175,137,142,152,224,229,175,119,53,94,127,163,197,117,71,77,222,233,202,231,68,253,65,115,40,5,147,146,216,100,170,202,39,245,12,254,67,25,194,4,115,74,196,141,157,51,87,48,210,95,15,190,206,40,210,157,105,54,194,210,230,112,107,217,101,206,253,151,75,9,65,29,165,195,84,224,179,241,161,35,38,110,46,200,157,66,141,230,216,169,58,243,190,145,167,186,168,95,19,230,202,213,101,251,87,159,2,144,229,24,154,197,250,7,161,130,211,150,164,68,218,168,56,226,251,58,159,194,166,227,208,231,120,20,39,49,40,246,190,220,165,171,205,14,92,221,219,192,156,10,123,215,254,176,13,163,110,255,98,255,11,110,49,181,150,35,7,160,215,230,25,159,184,48,25,184,160,203,129,144,244,11,225,148,54,253,22,203,46,168,81,211,96,179,56,147,177,67,99,168,208,150,155,130,67,127,16,220,112,106,188,21,86,8,188,220,26,70,169,59,234,7,199,149,51,248,249,249,27,41,186,138,10,81,165,194,8,95,59,147,62,151,225,204,116,120,134,56,47,174,246,218,151,21,203,72,26,227,69,12,99,88,248,122,175,246,233,196,173,97,29,176,37,188,191,168,105,180,197,206,148,172,23,186,60,133,50,47,5,238,84,162,47,193,124,167,202,175,104,215,147,156,207,115,124,21,41,206,47,46,254,21,113,154,132,7,226,129,146,229,60,25,174,102,135,138,148,198,251,191,224,165,116,183,3,197,237,221,73,234,90,0,38,108,146,20,11,163,148,130,58,88,237,121,179,93,244,127,57,125,146,237,82,250,143,149,114,244,48,16,10,238,75,51,88,44,58,233,113,187,252,238,164,0,46,188,54,172,22,157,130,76,71,129,100,62,166,59,175,224,35,205,123,4,18,216,190,55,47,16,233,18,182,85,0,36,148,133,103,75,134,69,142,190,72,100,111,156,248,23,39,50,122,189,211,197,212,32,42,173,136,176,160,224,186,57,130,113,59,71,188,207,93,121,75,174,206,227,207,253,65,66,172,72,74,218,47,255,112,129,163,255,208,15,63,219,22,185,187,152,253,241,220,169,14,142,135,253,106,92,170,217,141,185,14,144,177,219,214,194,44,167,176,48,147,212,134,119,76,88,113,2,237,160,203,33,137,40,68,207,200,43,7,11,212,49,95,232,98,139,75,21,161,65,68,21,22,200,50,3,56,218,168,150,235,236,154,115,149,223,189,183,192,100,223,218,188,229,58,157,16,32,106,203,180,106,119,62,72,120,129,243,60,142,238,214,22,16,58,37,95,83,147,8,40,232,190,133,16,76,157,62,148,226,178,191,96,71,35,192,80,21,226,42,145,121,64,107,46,101,54,16,240,57,236,191,28,16,104,5,4,158,211,160,156,70,216,30,210,157,73,163,103,232,105,137,166,109,3,199,120,197,23,55,137,20,147,136,166,65,234,16,239,101,142,166,217,188,152,144,48,7,225,81,50,107,36,245,88,169,90,78,28,46,218,13,52,114,160,252,106,36,117,239,221,98,108,251,85,65,167,237,219,91,26,24,125,29,60,196,96,10,121,8,23,79,221,11,219,173,51,172,86,184,77,140,177,91,68,115,3,65,139,126,132,240,50,23,236,182,10,26,187,117,44,125,169,0,127,60,33,109,114,25,220,66,81,174,194,3,27,26,83,219,188,86,204,145,74,110,191,24,111,100,58,110,175,190,78,17,197,171,152,147,143,172,101,76,218,125,192,80,193,11,114,184,140,121,58,173,5,162,185,255,1,24,66,173,160,253,8,102,112,174,80,103,135,177,28,174,213,76,149,173,158,104,112,222,134,54,211,75,78,40,140,245,85,198,64,81,176,10,149,99,139,209,233,67,128,41,214,43,148,184,2,176,126,154,20,173,52,190,38,128,18,244,176,252,245,157,150,207,123,50,20,98,75,144,182,42,152,10,222,178,191,216,140,239,22,228,192,79,237,63,160,89,172,132,214,135,34,22,125,31,172,15,242,36,152,189,111,234,28,177,140,195,198,168,203,1,61,20,24,170,36,226,206,213,183,61,219,239,1,249,46,95,223,74,12,198,103,235,189,235,185,179,87,28,104,13,132,122,109,252,77,103,149,85,181,189,198,190,143,99,112,37,148,9,223,96,178,192,80,242,82,217,126,103,220,31,138,5,176,38,176,188,63,125,51,244,33,206,133,239,237,63,192,37,208,222,47,42,223,218,179,68,153,128,124,17,162,4,197,3,46,55,7,107,123,220,187,202,186,151,193,227,46,47,93,151,43,16,159,216,172,242,239,22,203,229,236,54,200,90,181,160,47,49,50,135,9,210,166,151,37,238,75,158,220,100,181,239,125,102,125,1,233,223,193,32,25,7,106,30,29,118,68,169,82,58,56,173,229,100,173,247,79,125,46,193,180,200,34,19,178,221,89,65,234,159,181,213,51,198,9,93,40,12,208,253,68,203,51,188,54,152,203,177,62,173,74,69,81,182,30,11,178,198,141,206,90,149,90,105,7,129,164,109,241,181,218,157,123,116,198,79,195,201,39,165,14,108,59,75,196,17,151,16,50,73,50,199,51,145,153,235,53,13,190,104,172,59,181,118,222,250,233,113,185,175,45,61,234,18,247,72,237,242,144,182,51,240,61,136,253,253,58,29,117,5,32,153,134,211,253,152,207,5,47,121,33,110,214,150,180,241,41,218,179,53,183,162,27,32,219,236,155,100,219,84,186,170,15,167,228,32,102,135,31,246,46,165,44,122,196,130,10,183,151,85,32,191,254,163,51,46,164,118,166,181,251,52,91,170,129,155,99,90,60,38,229,249,76,82,213,78,163,39,234,117,158,125,154,149,176,43,30,9,188,212,138,60,233,244,124,108,22,222,188,109,66,173,221,12,161,184,99,194,90,192,184,148,217,234,192,114,123,92,154,26,21,146,48,187,253,213,183,143,160,140,221,249,180,98,216,9,116,186,153,225,96,85,235,47,207,200,55,242,54,250,204,147,116,200,198,217,71,135,210,25,102,234,77,137,71,200,155,248,185,35,170,166,9,142,221,157,170,218,217,69,92,222,69,43,210,112,171,183,174,124,117,160,65,104,164,46,107,113,191,28,106,229,77,244,50,109,132,193,185,61,145,86,32,122,227,203,89,181,6,77,142,116,130,37,204,232,60,177,93,76,0,255,50,75,53,241,112,88,31,189,111,59,155,177,84,23,119,188,109,99,31,170,21,224,109,111,128,81,59,6,7,55,134,140,42,238,127,3,107,207,209,72,146,111,115,104,205,210,131,33,255,22,16,58,128,187,76,181,69,241,242,249,100,227,83,160,200,42,239,72,147,131,149,21,222,68,82,12,81,168,100,199,24,147,229,3,42,150,175,140,116,66,216,168,145,209,50,152,172,107,90,17,149,149,179,56,105,234,160,102,62,153,65,134,143,179,25,6,192,151,186,182,76,55,18,98,157,130,63,227,136,58,137,112,172,255,39,184,83,5,150,163,241,237,69,74,167,52,138,46,149,23,1,68,97,182,183,170,201,118,7,63,173,135,206,232,125,137,9,107,243,8,143,191,192,96,143,119,186,112,135,13,33,27,9,11,26,101,78,242,87,185,13,44,4,203,175,126,252,19,123,34,73,210,1,127,97,133,230,246,31,208,79,102,104,175,128,101,204,108,188,78,133,106,42,10,73,87,139,144,58,248,102,91,132,215,157,216,145,9,10,178,248,64,35,195,214,5,77,242,141,37,150,201,116,192,130,90,209,63,74,50,197,34,98,121,121,239,97,77,137,251,0,176,100,196,34,102,243,163,100,189,10,51,210,174,241,143,194,182,7,5,97,172,136,210,13,85,176,218,33,178,224,80,215,128,229,39,85,251,185,183,159,224,173,131,123,104,159,82,57,231,114,191,6,141,190,21,229,225,61,177,24,26,0,122,15,121,112,214,48,75,122,227,30,82,61,92,180,89,187,254,206,71,49,181,34,215,130,65,139,130,165,67,140,232,158,178,162,133,161,97,130,194,100,255,189,64,163,22,138,190,30,123,237,87,128,55,122,214,12,143,60,110,56,49,74,124,244,123,18,241,125,185,46,48,220,172,234,219,17,188,218,157,79,17,130,71,145,148,220,95,75,231,117,206,252,128,152,95,178,35,73,162,52,82,144,151,191,159,115,156,164,45,134,192,56,198,12,109,143,172,200,28,137,16,41,197,134,238,217,109,127,72,182,241,133,6,193,188,67,109,252,229,167,51,48,129,170,246,166,114,228,116,248,29,69,209,243,31,158,133,244,90,33,225,129,199,82,164,29,189,121,249,121,174,130,148,169,42,140,135,69,4,128,24,198,113,198,108,98,194,134,241,33,99,16,228,143,222,180,10,208,130,131,111,189,89,144,198,11,121,118,46,204,7,129,25,106,249,236,65,255,1,76,115,137,131,45,69,63,215,0,106,247,212,190,186,146,180,67,208,70,79,27,90,254,171,78,23,208,214,80,42,128,220,187,119,182,66,51,175,211,56,238,238,58,55,58,229,251,151,178,36,227,192,128,250,42,233,75,101,93,218,175,228,76,81,13,221,91,10,161,240,110,66,84,49,72,65,110,175,88,105,227,217,234,187,206,202,197,194,239,69,38,99,198,134,246,107,6,10,107,21,196,228,59,176,18,102,148,60,208,200,5,47,214,21,155,173,87,141,44,155,233,156,91,42,247,244,158,68,103,200,68,109,2,40,205,76,111,65,168,151,94,156,242,157,73,116,74,119,161,176,25,71,230,244,92,2,107,166,49,184,74,171,96,197,0,71,180,132,37,58,227,186,5,110,168,170,215,173,198,160,105,253,172,229,218,112,3,60,117,208,44,142,173,49,216,124,211,193,7,236,54,189,165,40,68,66,4,175,221,111,242,65,200,227,51,195,176,178,34,15,1,137,226,193,252,185,252,81,24,190,158,250,248,95,83,69,229,170,141,209,176,66,169,198,244,188,204,80,228,166,202,158,141,11,4,245,61,119,43,85,52,164,135,22,137,169,158,77,141,94,67,152,18,71,183,236,231,227,19,206,28,134,170,232,168,45,167,160,179,80,83,145,46,14,178,34,44,81,189,107,71,169,100,38,198,134,71,132,228,113,177,244,132,4,28,90,254,85,89,202,209,169,109,2,183,14,241,51,196,176,116,242,106,234,158,54,0,159,24,19,230,66,203,42,85,145,140,12,230,221,176,76,157,227,0,167,79,218,243,181,173,118,162,247,180,65,239,137,188,156,69,231,132,109,218,149,84,45,192,129,185,72,111,144,253,48,134,214,154,32,40,17,190,134,161,142,131,28,222,248,167,179,217,226,13,42,218,60,180,195,95,116,164,239,226,165,191,234,60,239,223,105,107,144,152,68,172,116,240,163,242,156,219,128,140,126,252,159,247,8,168,215,154,211,86,81,149,6,114,14,75,69,17,74,249,169,61,169,238,177,50,73,173,58,163,79,198,12,251,250,222,34,117,104,108,145,246,84,216,138,113,11,174,203,35,76,223,98,100,84,55,212,82,51,146,111,175,250,111,57,221,59,253,238,176,236,33,123,120,233,142,77,220,247,116,147,156,56,36,173,43,105,23,246,212,240,141,59,130,104,109,178,55,54,180,142,98,49,49,79,116,62,167,162,83,160,162,38,142,197,4,92,60,124,39,12,157,241,181,193,82,106,173,174,2,106,13,47,48,108,22,27,123,210,176,114,101,86,127,77,156,244,72,227,113,99,199,162,134,216,252,150,135,31,54,153,145,227,165,232,224,231,84,111,110,207,231,212,72,24,88,147,253,216,28,84,41,11,91,114,102,102,228,43,6,57,50,132,59,150,232,108,187,150,3,32,141,99,161,57,133,12,241,151,15,227,3,135,12,106,113,16,99,178,121,201,135,127,91,19,106,145,110,230,183,185,207,89,251,50,151,75,106,217,255,15,101,50,136,43,233,92,64,93,155,25,221,43,194,192,1,24,51,225,149,24,166,192,164,60,39,196,146,80,248,216,43,150,140,240,254,87,150,4,223,112,28,64,188,181,106,213,49,82,97,248,225,41,183,40,254,194,5,116,64,194,14,248,191,192,135,213,230,194,139,249,80,24,90,84,16,201,251,82,181,225,250,67,223,155,25,98,121,84,252,5,214,126,70,161,212,3,21,89,90,214,40,193,253,78,146,2,222,195,174,44,240,117,7,220,33,57,23,156,36,193,4,239,136,227,28,187,119,148,189,97,135,0,175,230,121,19,102,249,166,16,155,177,87,207,70,195,17,138,51,102,77,7,50,234,67,33,184,116,51,75,104,119,196,37,127,76,145,78,180,194,253,131,91,75,159,35,254,88,228,202,189,111,118,101,21,165,238,185,100,167,70,34,106,114,241,157,154,48,75,13,133,83,26,7,206,185,18,83,212,194,70,3,144,65,10,201,241,240,95,69,133,93,165,54,77,176,244,216,133,136,149,119,12,203,66,141,77,16,21,248,107,36,157,181,80,70,92,81,204,83,147,241,145,217,253,213,67,3,157,139,203,78,27,243,207,5,32,226,187,251,103,144,143,204,244,213,108,184,205,249,54,206,226,14,240,93,16,204,42,164,151,231,120,109,75,179,153,208,135,155,83,201,166,165,110,107,96,12,184,168,107,110,198,199,180,240,31,241,186,229,166,129,194,22,139,155,185,106,72,255,52,124,35,19,38,35,195,193,244,45,205,23,181,15,87,208,76,11,198,231,168,238,175,150,45,5,164,135,11,177,182,243,77,139,234,218,112,83,153,40,51,34,132,62,96,156,65,15,73,164,224,123,94,119,230,19,218,27,214,208,191,191,209,91,81,196,231,200,28,62,39,209,38,6,31,226,113,6,135,93,186,104,55,32,86,100,176,193,30,144,138,203,245,51,119,120,123,116,36,16,45,149,201,235,235,110,153,184,71,18,215,164,198,129,24,110,158,35,169,204,140,194,8,34,65,247,19,193,34,196,101,210,68,128,231,239,51,183,110,140,123,36,161,62,41,127,99,103,79,225,168,161,3,188,149,74,82,51,65,134,242,215,22,178,58,8,76,236,63,124,57,205,207,188,96,151,55,251,210,117,35,141,174,158,168,109,105,50,64,190,199,73,160,76,156,148,62,106,25,123,190,133,215,107,35,172,9,74,85,123,191,24,210,21,2,191,145,244,58,232,25,74,42,21,60,33,32,128,248,149,128,255,150,32,70,195,163,67,124,61,237,158,3,79,196,28,100,16,152,45,88,221,104,112,28,78,179,228,171,84,42,169,18,147,217,116,84,98,28,181,42,13,129,249,151,24,122,177,162,129,58,87,2,1,86,82,59,6,104,145,231,201,113,248,60,210,157,168,239,43,214,174,249,223,144,33,240,15,29,244,212,51,235,55,61,109,39,252,173,103,23,177,95,4,182,67,82,188,18,65,226,10,212,91,161,217,29,205,94,74,173,71,164,73,99,128,108,111,133,16,43,241,127,179,57,142,122,39,37,182,18,149,111,199,148,204,104,71,65,26,83,223,103,112,40,75,54,12,180,90,145,160,124,213,198,142,3,33,77,79,207,194,19,53,84,63,51,163,38,192,75,128,202,56,60,153,110,30,39,222,114,63,129,132,58,104,201,120,7,203,114,27,252,214,67,114,28,42,225,10,6,227,0,4,216,33,158,123,143,111,49,167,229,167,102,240,79,118,18,54,96,224,205,186,239,134,248,222,91,123,135,227,222,125,56,214,100,44,9,153,123,169,211,150,215,55,98,174,242,109,177,208,5,14,216,210,136,64,200,206,139,86,243,184,155,94,217,235,90,18,18,184,243,211,132,59,206,226,9,122,28,22,238,198,212,160,163,211,206,36,209,124,112,183,144,159,43,154,176,224,81,61,99,47,119,50,23,55,236,51,109,71,153,88,67,83,179,206,229,254,96,116,131,155,232,28,64,205,35,47,176,239,218,215,41,145,157,227,171,180,20,186,249,140,149,29,162,32,25,100,44,86,92,149,254,67,179,99,17,75,18,64,229,120,249,111,138,210,18,253,246,104,103,173,183,223,139,153,56,66,126,140,105,219,22,182,182,160,91,79,167,99,65,162,139,154,128,240,173,229,248,64,227,145,73,151,149,33,19,172,15,15,66,61,5,26,103,132,146,218,88,13,94,236,236,45,175,100,139,81,0,12,198,242,204,119,188,0,121,149,77,252,189,125,182,39,188,49,167,43,187,223,168,231,72,85,19,236,73,251,122,202,156,240,167,3,242,36,140,91,163,126,60,193,3,5,8,195,89,181,52,99,224,2,247,79,63,236,38,0,16,75,132,50,166,136,155,211,22,214,62,79,172,234,66,92,197,248,243,123,232,158,255,203,162,236,14,65,162,142,102,106,175,44,52,117,182,17,182,101,172,204,134,207,6,104,81,232,216,234,16,115,31,169,139,109,107,204,108,108,190,252,229,97,32,200,229,80,184,26,170,158,81,42,96,221,43,222,205,140,246,202,71,20,113,21,107,218,109,111,61,142,228,128,122,196,115,45,229,251,25,72,101,208,111,59,2,168,252,71,8,101,74,54,230,92,70,80,8,33,215,111,25,135,0,235,223,196,78,100,111,156,66,147,205,182,83,94,244,84,148,201,175,39,189,167,167,45,44,169,209,124,203,208,20,80,119,229,217,175,255,198,14,187,35,45,46,139,11,28,189,218,217,28,208,51,234,248,102,74,45,5,213,132,26,186,181,119,228,60,132,140,76,126,72,112,164,214,198,211,15,75,161,77,198,43,42,33,242,156,74,89,123,4,171,175,69,222,91,101,57,29,77,196,132,203,185,71,125,243,20,100,129,167,239,211,153,122,61,202,178,151,177,37,126,211,254,65,35,33,199,229,238,90,154,127,186,168,175,45,71,221,213,14,155,170,144,94,34,187,149,167,246,74,167,145,44,102,21,204,55,14,155,190,101,50,87,219,135,106,233,101,178,3,201,100,28,100,133,112,168,159,21,98,34,65,87,8,166,88,100,21,71,140,142,250,153,13,130,32,91,232,98,255,235,121,73,184,86,214,200,150,13,105,170,208,50,198,196,199,111,196,140,107,183,198,171,206,70,147,2,245,66,107,44,53,250,207,191,225,76,159,160,50,168,51,22,225,129,229,45,152,202,57,85,193,100,90,19,157,183,175,143,215,50,52,0,184,173,78,53,203,19,178,235,198,28,21,53,96,161,39,238,106,109,254,144,14,107,96,165,21,63,8,213,211,247,189,46,166,121,191,170,46,179,115,5,79,172,48,255,39,177,187,247,107,253,244,187,223,131,226,124,242,28,206,188,238,159,175,10,142,150,234,149,60,232,234,28,151,253,223,213,225,49,166,95,1,233,180,12,234,171,199,94,136,12,4,35,203,31,198,228,132,208,52,226,156,88,206,64,251,22,118,219,111,245,202,158,204,190,104,251,121,249,245,55,199,221,103,76,222,56,96,207,70,190,73,207,239,133,185,183,95,172,106,49,50,131,12,184,157,206,84,212,242,101,219,124,63,121,26,137,225,4,46,197,197,170,143,207,198,229,65,52,63,88,97,230,98,212,227,84,81,99,253,104,41,133,146,93,236,91,235,211,252,206,129,92,36,143,30,54,53,182,147,177,0,98,240,191,182,51,130,87,150,184,110,78,100,156,252,63,9,128,225,208,86,15,46,128,221,177,94,192,105,162,60,55,135,221,52,187,121,183,201,70,127,80,227,24,22,122,65,123,49,214,211,172,83,154,99,23,32,85,79,236,72,100,86,156,121,82,190,229,128,69,16,165,89,47,122,242,91,15,94,166,179,22,115,96,182,6,23,172,142,35,156,107,251,122,12,8,190,240,173,201,7,29,25,86,160,215,111,113,83,30,177,10,48,62,104,70,118,131,171,84,132,114,129,49,19,61,253,78,176,174,1,204,89,87,118,86,101,167,199,166,208,110,76,170,32,99,142,22,151,43,153,240,151,218,115,181,253,22,24,134,219,94,238,84,64,12,110,184,132,140,120,36,77,113,200,242,158,15,88,99,153,91,205,56,98,247,2,206,68,255,45,11,86,202,181,13,219,207,94,104,123,208,246,90,173,234,197,219,105,254,23,120,6,183,154,3,131,238,98,95,17,214,157,46,29,78,100,181,199,34,48,86,244,151,65,218,127,54,2,27,102,133,41,212,198,219,148,188,134,215,110,116,122,220,238,83,191,123,208,80,102,179,170,76,198,53,240,69,93,55,75,212,38,37,31,122,46,19,102,212,133,242,162,100,207,9,172,125,80,161,214,145,35,54,177,112,171,86,31,185,38,201,121,233,178,1,177,101,196,36,52,40,76,174,6,250,198,142,211,202,98,84,10,52,113,237,183,240,74,86,206,213,147,138,23,139,158,234,123,239,155,161,129,182,205,57,84,247,114,42,147,116,191,110,56,224,128,11,166,120,36,144,174,125,91,16,104,245,34,140,91,205,188,155,231,71,45,16,221,81,194,21,41,183,103,237,28,225,1,51,56,235,98,239,248,0,61,235,180,87,183,111,209,64,228,184,177,70,80,156,111,244,174,131,123,38,89,113,86,68,201,127,71,24,216,83,199,8,236,63,92,150,214,118,23,38,154,56,254,1,57,168,182,167,147,252,100,205,111,121,63,245,129,70,9,65,59,61,199,191,116,156,62,85,14,16,189,251,2,165,15,63,206,161,229,224,24,7,206,35,26,111,80,95,160,52,197,41,87,57,63,232,94,5,119,131,78,80,209,245,124,154,119,106,251,92,199,19,137,239,26,109,52,251,221,97,240,113,16,242,26,34,81,47,165,253,7,154,141,139,72,112,236,45,125,95,7,151,202,69,246,91,13,59,1,159,104,61,2,59,135,86,45,82,237,169,214,176,130,233,206,184,236,96,60,188,97,179,75,57,134,251,46,176,1,205,183,237,7,244,151,227,186,42,15,147,41,222,58,250,165,180,29,22,165,222,191,245,240,3,113,214,91,85,13,24,93,21,139,212,145,35,3,182,86,217,180,109,31,218,232,11,243,181,241,63,175,207,242,172,176,105,191,167,252,135,37,79,191,228,181,216,182,223,39,52,171,15,88,162,169,40,222,23,166,117,236,250,87,69,142,255,222,3,47,190,113,26,206,243,154,115,66,172,188,100,216,73,62,132,126,122,119,132,95,101,46,52,36,195,45,75,87,120,13,62,155,91,48,61,223,66,154,90,132,253,186,137,221,77,27,156,63,24,116,4,231,41,116,18,208,72,48,150,241,81,100,18,81,70,141,225,82,108,91,223,176,69,86,157,222,5,73,223,111,215,116,155,125,89,82,43,241,151,97,18,164,76,46,124,193,134,188,245,152,132,219,211,254,81,103,88,255,84,75,192,23,201,194,246,6,253,129,22,43,4,77,217,121,86,170,57,95,92,166,190,108,211,35,57,112,125,107,84,80,79,235,90,111,14,191,115,100,71,107,227,161,16,36,164,253,11,132,13,248,107,108,163,127,62,223,75,163,212,9,58,166,12,247,243,166,13,244,137,51,245,43,4,31,20,173,134,20,29,201,188,114,171,185,121,195,75,8,218,29,59,162,174,246,186,211,215,180,42,121,17,44,170,249,228,47,35,7,66,217,158,209,133,128,55,93,209,41,4,53,196,215,101,234,180,84,233,168,156,202,160,167,194,203,197,152,80,229,57,237,216,245,197,80,80,43,125,35,181,123,28,119,160,3,64,78,153,98,107,123,95,23,223,65,29,194,214,126,143,208,121,87,227,15,108,255,217,80,58,249,245,36,60,231,38,201,177,162,61,35,127,43,63,133,250,172,199,26,136,159,251,83,166,204,75,206,178,50,39,123,175,243,170,254,53,159,6,95,235,155,107,216,219,22,94,115,190,196,166,17,21,61,20,65,158,206,183,192,19,29,242,106,105,53,49,47,237,151,137,215,85,149,193,235,190,209,41,225,165,16,36,12,6,169,249,217,163,179,202,44,22,231,180,102,190,77,51,227,170,254,13,169,145,239,45,213,141,78,47,4,195,144,242,209,189,228,192,209,144,59,85,164,20,5,29,95,14,67,19,180,66,111,83,40,159,235,227,111,79,88,112,87,84,42,34,223,147,131,189,144,160,0,103,20,187,43,211,88,207,102,235,251,21,242,15,91,94,232,51,88,76,3,118,50,42,150,137,26,208,20,106,47,111,195,238,185,133,79,201,102,67,112,25,129,58,162,176,215,164,20,118,80,93,174,179,99,132,140,201,172,255,144,11,120,171,47,77,61,207,169,147,227,94,62,40,252,217,155,96,204,220,166,78,80,8,75,88,109,48,53,67,100,13,1,138,55,91,51,51,127,11,195,63,42,218,135,115,244,240,192,118,56,214,26,86,212,101,41,113,189,198,127,187,146,163,169,103,149,219,8,43,229,109,230,56,85,140,61,245,97,53,30,163,115,153,116,100,123,12,162,58,250,199,83,76,100,155,14,178,96,2,227,189,78,26,25,221,71,252,27,113,217,19,204,40,77,150,213,208,3,46,165,80,46,218,138,40,219,165,150,76,235,251,70,238,40,194,146,246,61,8,85,58,198,229,144,23,72,214,220,155,57,85,243,41,50,173,61,18,53,4,43,110,185,194,115,227,210,30,3,226,150,209,137,165,172,221,147,7,63,7,101,173,196,167,229,46,16,151,203,27,5,170,171,204,215,204,141,149,135,168,2,87,162,175,119,89,119,235,14,241,238,237,144,12,115,28,209,224,57,134,214,152,198,149,111,141,100,119,68,215,145,147,17,247,242,25,120,181,45,144,53,249,121,208,244,192,49,182,36,41,73,56,1,50,167,234,70,63,41,130,180,81,171,144,23,71,147,107,91,187,40,34,33,185,4,159,202,23,212,111,62,131,192,60,77,185,15,254,118,44,145,101,50,112,123,175,251,73,133,206,104,142,151,30,29,149,125,192,184,43,140,135,104,44,112,217,99,171,87,122,181,137,121,255,109,119,64,246,98,90,140,142,87,120,31,1,85,51,66,48,187,138,43,207,241,222,236,107,112,12,189,197,196,18,224,70,37,84,1,53,112,26,49,158,123,14,209,247,70,41,40,162,240,35,244,190,78,202,44,199,162,146,33,234,68,16,20,81,222,102,2,49,56,171,7,89,254,106,170,205,115,60,234,243,179,113,113,165,227,65,24,252,253,231,170,38,192,89,188,47,116,97,162,246,149,180,101,128,40,92,87,187,198,211,99,76,251,218,38,242,96,129,6,209,131,228,130,103,249,126,96,213,45,243,184,31,155,188,50,219,240,147,254,157,118,5,229,237,228,100,160,74,31,29,222,160,191,159,140,94,72,114,144,234,128,106,184,179,245,94,171,216,33,34,198,15,190,25,178,215,142,128,103,73,87,179,179,127,43,202,137,237,134,124,78,246,117,197,231,208,59,222,37,36,207,239,255,38,196,248,16,243,94,187,208,62,59,184,27,115,42,247,222,104,241,189,143,17,224,65,208,31,133,195,127,205,116,12,175,13,17,68,231,50,185,3,73,38,14,149,209,143,224,190,177,1,153,120,0,109,59,162,79,6,118,237,252,167,143,121,218,237,5,182,183,28,235,105,228,87,228,86,181,217,16,142,55,87,207,163,184,19,6,255,91,19,119,20,187,224,224,220,180,131,112,109,23,174,20,87,82,252,183,5,192,244,209,103,210,17,220,122,91,255,187,91,100,138,220,179,104,188,117,166,95,37,98,27,164,176,178,26,32,220,245,254,191,178,221,235,9,103,125,81,76,115,44,102,160,114,203,1,221,11,23,208,111,114,37,226,251,5,132,93,6,228,155,142,107,241,26,36,181,148,237,101,66,65,69,139,176,106,40,188,0,141,241,106,220,59,255,99,178,169,45,188,210,78,86,46,176,189,249,67,132,65,145,62,145,136,29,215,80,237,124,150,198,242,218,70,62,162,235,225,156,189,116,240,44,190,202,26,241,159,243,83,123,168,42,130,80,180,32,108,197,185,20,37,81,90,43,10,115,76,220,253,147,140,182,254,207,70,240,128,47,44,191,93,207,146,133,141,48,25,101,55,201,19,94,34,239,4,93,128,167,173,29,150,148,190,192,236,161,233,252,142,140,71,221,56,140,50,218,194,49,247,214,193,222,162,14,236,53,233,132,252,84,223,108,25,13,141,64,147,223,203,83,2,122,15,137,60,201,39,132,88,65,58,119,173,233,62,185,36,61,63,252,97,98,235,200,236,172,219,234,68,155,81,208,133,161,66,119,140,68,101,221,241,105,243,93,223,61,121,247,167,89,181,18,206,1,173,218,62,211,220,68,28,247,211,75,149,18,86,9,7,8,74,205,192,33,102,155,254,122,229,39,172,178,137,155,136,101,89,56,191,32,147,214,140,163,44,33,174,10,230,190,196,247,215,128,104,104,152,109,225,6,64,224,123,190,219,41,70,229,253,148,22,115,8,45,159,87,214,172,223,120,109,86,206,135,98,23,2,160,37,168,22,103,255,9,134,40,34,62,207,62,169,7,44,109,225,255,71,178,156,137,103,4,214,237,224,221,119,189,186,53,242,13,76,132,69,128,197,201,28,33,120,38,232,190,40,215,11,109,15,236,123,0,77,69,167,43,142,255,218,196,115,165,52,170,2,206,12,231,254,162,179,238,32,18,88,32,120,145,194,248,40,130,9,175,140,237,189,54,114,158,129,181,187,74,96,5,46,13,173,201,228,124,239,25,227,2,134,85,127,245,249,74,120,33,91,121,126,82,232,10,56,205,153,171,84,71,205,22,146,208,193,182,63,110,182,104,56,54,61,96,82,154,225,203,136,234,147,189,144,225,159,53,62,245,42,90,243,231,61,160,80,69,31,225,79,83,37,79,63,60,115,74,148,41,45,14,156,123,224,80,165,141,201,60,134,84,156,46,19,2,196,92,206,145,143,75,80,146,66,67,78,204,145,143,46,219,12,122,30,167,34,8,114,195,169,212,184,5,33,224,80,94,161,126,202,110,137,157,43,66,151,181,116,118,220,17,91,232,189,72,191,126,140,3,205,126,3,23,198,208,214,240,122,8,83,49,235,220,61,137,115,97,245,51,0,34,191,138,125,71,109,10,57,99,138,61,17,179,22,0,143,37,254,98,12,131,130,77,106,22,206,120,129,102,66,84,97,219,67,54,251,3,38,32,208,167,159,108,140,89,213,58,5,254,233,34,128,240,67,46,118,49,213,51,27,108,204,178,205,126,58,16,0,71,51,125,110,120,219,254,231,196,103,193,54,38,98,148,82,38,70,78,180,19,152,253,90,165,29,87,232,234,26,11,166,242,121,198,57,73,61,76,233,238,107,154,125,165,121,8,237,188,84,228,234,191,236,74,161,129,74,108,187,204,235,133,146,45,168,207,249,107,243,112,105,174,148,249,79,21,187,210,144,82,78,11,74,148,158,234,39,11,2,1,195,0,89,109,9,185,22,1,70,184,187,189,19,142,41,66,66,61,61,237,88,49,75,23,2,46,246,202,28,46,84,147,4,169,157,115,22,170,24,128,225,29,174,216,192,17,139,254,113,245,166,174,34,245,131,158,130,51,178,201,157,227,86,81,87,97,155,230,149,73,5,71,145,93,49,18,81,207,225,77,191,103,185,31,212,236,193,120,148,68,50,240,64,245,214,215,77,109,200,221,74,191,84,157,45,103,75,157,242,251,174,188,125,49,113,58,89,148,42,242,209,183,32,128,207,0,161,120,53,223,57,224,183,113,67,246,72,22,207,29,78,158,102,151,104,36,120,206,49,106,12,159,243,128,73,239,144,185,250,48,224,155,227,38,139,117,14,206,31,216,215,129,47,149,154,199,240,164,60,85,240,12,169,58,138,216,248,46,245,175,16,121,148,3,248,217,49,160,15,182,166,196,184,163,237,70,33,14,170,185,164,25,89,41,175,94,150,219,172,79,153,26,180,46,211,241,60,202,179,131,32,25,104,243,225,246,12,246,213,113,151,104,31,197,29,141,35,77,133,174,41,215,112,18,195,64,227,185,66,97,247,21,123,95,91,182,156,53,101,96,172,136,75,106,188,40,221,144,39,229,28,98,126,79,105,50,115,77,227,146,77,103,108,214,131,70,250,179,180,251,57,221,169,244,143,167,2,228,67,31,250,203,121,241,195,54,58,2,8,68,71,156,104,244,204,104,166,171,80,184,164,204,178,156,166,20,4,112,161,101,221,15,105,178,33,202,136,193,122,30,187,35,141,57,131,236,16,3,79,228,239,192,106,157,101,252,0,137,2,152,179,230,108,87,225,96,97,136,130,104,155,72,238,113,8,243,164,248,236,84,34,42,135,68,105,198,10,156,95,127,1,135,254,125,94,3,66,34,124,55,175,190,213,12,32,13,73,151,245,208,101,15,0,242,154,132,182,87,244,18,188,102,70,170,53,143,205,1,10,194,80,128,189,237,199,165,178,128,127,224,193,170,151,174,209,6,52,130,216,128,77,2,87,84,203,27,237,180,57,91,243,80,42,214,223,50,224,12,152,88,22,107,128,138,10,57,26,76,26,250,11,54,15,152,154,68,218,169,9,209,253,172,134,168,27,159,147,222,197,231,139,75,3,169,201,131,96,24,132,4,50,59,219,191,143,60,24,69,246,48,193,172,15,23,159,158,207,119,190,18,37,171,56,141,200,52,223,9,110,0,9,245,42,200,73,216,178,198,70,243,55,223,122,87,178,60,166,103,162,210,52,24,107,227,95,160,153,207,8,174,100,195,80,254,29,146,21,130,57,85,66,33,172,100,60,146,190,30,128,45,92,138,1,121,131,229,171,130,105,56,113,32,233,47,203,67,42,119,245,93,21,179,221,172,148,17,140,250,132,9,17,146,37,46,72,170,71,195,239,228,219,202,214,22,8,226,141,159,206,214,209,115,135,169,160,230,101,219,162,7,113,24,62,115,44,63,50,120,81,98,176,5,111,204,134,126,203,252,187,136,187,58,12,103,211,227,68,130,116,31,91,196,92,162,230,112,175,187,121,116,225,164,151,53,90,186,27,217,220,191,142,66,39,43,179,7,122,179,9,206,163,21,158,197,134,173,135,122,83,67,232,162,187,251,135,242,62,90,6,81,26,50,194,9,165,214,22,111,249,137,77,171,23,200,34,201,227,167,150,79,54,237,26,76,234,250,53,133,127,137,8,53,152,27,237,67,92,115,65,139,74,118,139,52,173,89,75,223,249,141,39,130,135,127,227,34,136,159,118,43,143,134,64,199,54,204,171,71,144,164,125,114,151,102,40,196,7,208,76,220,254,107,124,109,233,218,220,213,43,176,5,34,55,235,29,74,81,34,177,187,160,80,72,12,114,225,99,75,238,74,224,3,48,22,142,184,70,218,110,54,56,69,218,224,200,72,156,4,108,172,94,89,130,130,183,8,114,242,129,133,109,195,78,150,113,80,127,90,102,183,38,109,80,176,201,0,243,5,57,69,175,43,220,255,15,205,171,162,243,175,8,244,0,158,145,141,15,47,247,22,37,113,201,46,193,102,211,140,143,115,217,205,170,63,59,23,88,197,137,70,31,87,198,240,23,89,55,231,249,237,123,20,161,47,121,117,105,207,185,57,132,165,217,238,33,217,130,232,44,188,213,5,15,26,173,45,220,110,115,84,126,2,206,86,189,111,86,64,179,244,131,58,238,21,234,88,223,110,152,172,237,88,216,201,26,74,157,85,46,135,136,202,110,55,37,212,203,194,47,68,185,194,131,220,149,88,250,171,172,231,35,218,205,165,245,70,57,44,47,186,152,0,102,225,183,147,237,229,26,19,90,32,9,25,247,185,224,72,109,133,123,166,173,21,240,102,160,43,201,97,3,254,234,230,183,228,43,48,38,13,134,164,59,58,97,116,164,121,24,134,17,3,88,120,205,180,95,138,133,158,191,250,132,219,137,107,196,164,16,129,173,51,176,48,234,96,76,7,51,189,8,121,56,61,61,96,57,69,83,49,85,118,228,222,187,236,66,28,117,116,176,99,56,108,50,71,33,197,244,205,40,96,134,28,4,193,13,157,27,248,169,34,74,22,40,132,37,246,213,34,38,77,151,102,203,103,176,157,125,74,206,96,123,29,92,219,201,160,33,77,5,230,9,198,12,214,237,46,8,83,74,196,14,26,126,163,60,62,112,233,246,241,239,114,79,24,15,212,80,0,228,225,50,3,170,152,226,30,93,228,138,42,234,193,181,124,206,252,14,67,137,253,76,20,76,247,99,180,150,185,18,74,180,20,50,122,46,44,250,27,128,40,218,189,232,35,143,32,211,31,118,5,136,149,225,34,98,226,225,203,71,166,20,252,169,87,21,1,31,185,131,240,82,232,224,57,85,249,133,20,219,235,238,107,143,245,178,155,100,240,7,66,230,72,171,191,102,24,151,249,4,118,145,156,138,171,22,243,26,65,127,75,204,15,76,76,70,58,115,63,114,137,204,106,24,255,24,194,182,25,55,191,228,217,132,42,175,125,29,181,25,96,183,1,242,148,23,15,176,99,247,243,32,162,228,121,223,252,242,158,233,75,224,139,160,199,50,152,64,253,235,134,185,53,18,49,161,100,170,140,64,254,36,150,149,16,195,155,123,225,57,121,240,95,133,151,241,95,36,62,34,107,158,176,56,177,54,13,73,20,172,71,63,41,55,77,78,234,9,214,191,190,239,155,217,205,40,188,189,19,242,181,38,146,163,197,227,71,227,170,207,65,178,77,218,9,47,238,90,153,225,93,253,207,208,154,65,142,7,57,75,169,34,101,35,75,163,121,46,161,131,47,96,148,28,237,114,183,252,156,159,182,180,166,105,198,65,184,195,30,60,23,150,189,4,165,82,34,52,226,136,233,1,2,171,14,238,124,228,192,12,102,7,30,227,48,1,130,194,66,210,193,166,11,15,23,115,168,250,247,117,19,141,122,162,79,113,163,115,167,115,44,5,0,249,62,242,148,94,211,0,94,215,202,222,104,246,221,153,4,126,26,83,64,210,227,40,80,190,210,209,124,206,23,253,128,252,211,199,141,16,175,233,159,27,212,96,59,169,230,190,135,182,139,125,191,244,154,97,142,22,196,106,246,20,199,208,206,109,121,84,123,63,80,66,191,251,25,73,133,255,234,22,219,144,38,163,207,156,220,76,198,124,8,230,5,194,10,44,72,109,249,103,74,34,105,17,79,67,164,48,181,197,234,146,15,191,60,121,111,112,179,126,92,12,221,142,71,112,58,85,101,0,122,237,114,192,70,62,158,31,0,144,33,111,82,141,24,93,65,112,9,7,167,2,1,18,127,156,25,105,225,190,138,239,196,254,215,150,19,129,165,35,250,50,80,169,39,172,74,47,177,51,9,105,46,255,95,164,213,5,211,12,220,229,103,3,31,142,87,28,140,126,23,37,64,144,188,59,106,27,171,47,133,233,7,26,82,28,17,141,19,223,132,127,68,246,29,231,99,216,62,194,149,62,163,133,241,45,255,9,162,85,178,1,240,209,237,154,78,4,250,144,194,150,249,43,135,16,213,180,232,187,133,129,238,238,219,63,108,235,176,4,137,228,58,59,131,19,47,10,9,122,74,174,185,98,235,171,192,46,223,133,127,59,193,217,127,28,235,140,194,149,239,216,198,38,119,160,0,64,68,142,163,234,86,19,240,92,170,117,65,219,106,71,93,110,64,34,140,87,184,134,194,185,204,201,98,145,185,206,91,119,237,39,51,21,92,234,216,93,22,97,253,214,150,145,116,106,184,179,99,169,107,187,10,253,105,214,49,97,230,110,92,255,134,5,88,196,233,163,103,187,100,81,136,199,10,179,33,96,180,210,139,152,160,17,48,29,158,193,111,24,1,11,68,22,254,64,167,163,126,161,78,239,58,211,191,129,78,104,7,8,46,32,73,65,233,183,62,254,130,206,127,101,95,244,32,197,197,174,80,255,75,95,40,44,178,210,75,251,172,222,147,4,127,185,69,162,160,119,158,166,49,139,251,150,147,73,179,124,193,167,211,147,7,147,13,251,142,121,137,142,236,132,112,71,61,56,122,61,136,134,89,108,210,192,153,75,200,177,200,119,221,89,15,27,189,35,48,151,163,103,154,54,40,38,136,98,183,10,59,60,202,80,138,153,149,32,187,225,144,61,56,145,87,101,106,52,171,32,86,59,55,18,8,126,47,66,88,173,139,18,114,51,159,75,187,23,177,132,179,252,40,167,218,117,236,252,210,104,178,176,157,73,1,251,244,25,139,108,230,223,173,171,25,43,14,231,186,149,19,90,117,202,115,166,203,185,121,114,185,229,104,128,211,223,225,68,94,24,14,52,38,215,162,87,29,157,202,137,45,104,176,52,18,116,170,41,86,123,8,102,80,247,30,19,105,107,220,173,215,204,244,122,103,211,77,75,38,87,197,248,104,253,146,112,65,182,195,161,46,30,58,151,159,174,231,67,17,46,152,108,161,234,188,109,153,8,117,154,223,168,173,198,211,150,172,152,248,151,189,212,255,155,75,83,192,65,130,116,93,145,97,10,22,76,202,101,115,30,226,80,105,220,20,142,195,93,168,205,25,141,170,45,37,46,176,17,215,22,36,51,58,43,117,42,252,213,171,47,240,75,70,15,224,22,124,45,92,81,38,124,44,4,40,225,107,235,173,60,61,154,32,37,67,93,11,223,230,152,59,111,87,235,44,94,204,137,127,137,53,220,237,205,90,95,67,244,42,160,250,118,89,167,115,36,200,2,80,253,193,116,136,32,16,164,96,225,254,116,184,123,161,3,124,130,82,58,117,184,53,24,250,4,48,140,117,157,189,19,64,76,63,137,177,69,138,240,207,189,243,238,165,238,248,204,44,255,182,216,177,187,104,95,151,5,107,46,189,223,128,88,1,198,77,216,155,202,162,205,167,197,248,40,172,185,86,116,40,206,110,60,207,66,34,91,38,201,239,146,23,49,227,132,230,248,201,175,130,81,38,197,15,231,235,24,223,33,246,254,1,8,99,243,239,232,111,254,134,131,105,40,204,213,147,248,173,205,118,150,93,200,188,172,173,240,242,26,82,139,179,251,190,228,231,214,211,36,232,122,235,114,96,77,14,143,246,45,92,36,72,202,34,9,116,147,125,107,143,65,46,1,131,250,69,84,187,104,164,172,152,47,161,190,156,198,85,233,146,80,96,225,234,132,80,236,253,146,255,115,54,236,73,252,137,104,228,211,58,246,170,128,247,132,123,115,142,111,74,90,48,49,103,214,153,19,52,5,183,186,66,214,93,35,9,179,84,42,25,40,1,216,164,27,9,95,39,109,14,89,61,178,180,240,12,37,210,242,228,114,222,87,174,149,183,237,218,215,30,170,160,116,136,43,15,171,90,200,157,25,103,96,198,175,206,182,244,12,225,164,104,212,142,248,202,221,90,22,58,188,175,105,22,185,244,93,133,208,221,242,50,240,51,122,221,112,221,214,191,39,195,249,112,174,49,79,149,44,94,224,31,199,171,174,156,133,132,203,190,170,125,248,72,36,198,202,14,182,143,158,73,243,199,248,158,123,102,135,30,216,48,168,14,89,115,16,13,221,132,162,41,17,54,129,129,110,51,189,27,178,115,108,225,104,172,176,183,50,230,233,232,151,149,193,210,73,162,19,13,164,141,32,116,146,135,137,19,199,241,197,77,88,238,184,156,238,240,133,125,218,54,101,72,57,251,91,168,39,9,140,249,195,189,62,22,10,127,145,41,128,228,154,30,127,136,192,247,157,255,204,156,36,23,15,1,61,174,78,206,199,213,140,184,141,127,78,246,70,129,27,229,229,102,51,79,61,249,129,247,250,75,52,126,86,181,47,236,177,81,118,204,185,193,4,104,227,177,229,206,240,53,54,48,233,46,93,208,79,141,86,42,175,109,214,64,140,50,147,158,40,196,224,241,150,16,213,246,152,200,10,205,31,233,33,159,197,185,46,86,157,238,157,178,227,215,132,206,237,165,229,51,190,163,101,67,183,115,24,179,119,153,194,172,8,123,172,64,217,71,121,40,73,33,143,181,153,157,216,218,176,136,249,249,182,166,151,84,46,128,34,126,18,109,29,94,191,99,126,178,254,129,157,52,180,172,244,138,139,245,149,110,14,104,102,208,163,245,82,149,248,240,51,25,205,168,212,59,60,17,2,0,111,4,98,104,130,253,116,29,92,177,12,111,39,28,149,171,93,249,146,98,4,35,58,58,108,178,142,56,13,97,220,53,14,85,217,50,115,123,227,193,96,39,145,246,179,15,97,191,81,31,214,239,138,72,10,183,176,239,201,3,245,191,38,8,141,113,31,125,146,70,209,123,128,76,194,39,169,132,112,245,218,188,131,54,62,7,140,210,107,101,236,215,234,66,38,157,254,241,227,29,251,105,139,8,214,228,120,4,45,20,42,187,101,182,99,219,215,19,94,170,235,97,8,37,185,3,143,172,10,172,78,63,111,47,141,120,8,35,17,48,226,5,214,242,196,95,244,70,84,139,156,212,222,166,149,66,47,193,185,63,253,72,64,150,55,128,174,135,254,185,236,67,49,250,23,21,203,244,242,11,175,130,43,76,130,1,30,122,253,170,151,230,162,229,153,115,229,197,71,115,241,239,136,188,12,29,76,188,89,154,32,190,87,22,113,42,23,21,59,165,71,72,123,254,95,121,192,59,48,66,237,163,72,252,45,98,173,109,29,14,124,241,220,201,114,88,40,107,81,229,190,180,236,103,51,146,103,33,32,58,242,27,140,16,202,237,114,86,42,38,15,48,135,224,179,105,97,4,6,197,18,232,105,150,133,240,222,110,242,197,138,241,249,238,135,57,79,9,30,126,124,144,132,148,192,98,187,237,69,50,83,35,244,2,147,118,63,78,4,124,9,245,107,84,41,111,202,148,20,181,106,42,136,188,196,76,24,55,123,115,178,93,146,164,249,129,190,127,11,77,150,255,125,131,160,24,254,127,1,209,197,236,174,251,253,56,170,246,0,97,104,72,128,222,162,119,255,160,100,102,42,210,212,16,131,190,106,168,50,233,158,44,138,24,113,229,216,77,3,53,193,65,102,223,196,113,74,199,88,60,110,117,130,143,15,166,137,56,170,95,166,20,49,70,229,237,166,239,56,32,29,228,240,135,107,194,144,94,57,141,230,184,21,146,8,229,118,107,223,152,176,197,162,43,244,126,41,44,105,240,109,10,214,38,84,122,211,112,163,69,187,223,171,42,228,239,107,236,217,171,135,239,251,11,158,225,236,165,13,60,215,3,249,49,105,24,78,58,99,178,108,57,111,141,6,182,93,122,70,0,227,15,121,41,135,71,31,191,225,243,208,56,161,237,182,178,78,151,9,188,155,109,153,165,130,194,237,136,65,68,98,237,25,171,16,119,202,14,148,222,187,193,180,124,73,116,104,116,134,9,34,124,234,175,83,4,147,171,104,43,246,203,241,173,188,101,117,25,34,88,73,2,93,71,102,227,124,27,52,21,143,89,236,9,80,52,50,184,46,42,9,51,81,246,152,237,33,236,19,122,141,218,43,170,153,249,43,237,104,181,233,145,254,143,101,152,4,164,251,243,35,99,104,99,162,189,131,224,2,243,45,120,227,143,120,92,73,25,148,49,237,176,200,83,135,60,63,59,36,34,174,243,191,135,99,193,24,145,42,64,65,55,96,68,146,125,194,150,9,192,29,180,157,68,96,130,211,17,58,123,64,87,14,174,94,117,199,126,201,66,15,27,217,83,93,196,10,66,105,86,119,11,20,86,141,8,167,176,148,52,86,77,249,193,190,110,147,23,88,223,39,240,165,72,160,243,31,155,70,235,124,162,94,251,183,136,231,190,132,29,192,35,28,134,214,13,109,203,87,5,16,178,129,144,192,218,98,123,3,135,185,66,95,235,191,253,75,112,190,107,62,30,79,99,240,128,144,81,36,50,108,106,233,195,51,62,201,254,246,115,55,45,148,59,245,231,117,160,46,192,56,237,232,34,226,201,248,140,23,213,246,2,188,245,122,133,173,145,4,54,54,73,101,176,250,42,18,6,247,161,32,66,202,31,108,28,100,62,151,71,238,0,124,214,131,222,42,233,129,74,111,133,143,63,45,16,23,237,255,102,196,31,144,105,153,125,97,247,228,237,102,215,49,138,241,223,192,227,239,92,98,218,43,246,129,47,91,88,253,213,224,200,104,195,147,36,68,255,138,92,244,103,47,40,114,83,29,176,149,168,57,241,129,27,7,201,241,148,203,214,239,197,239,121,70,30,227,67,81,26,67,118,66,160,13,166,87,199,38,122,231,157,58,254,226,192,41,218,33,29,133,78,72,200,228,66,116,68,219,3,71,226,84,6,80,79,46,3,78,162,192,45,250,181,81,164,52,74,124,147,166,86,172,151,144,65,151,111,21,77,206,136,119,0,177,234,229,185,9,25,21,100,241,99,178,119,115,37,72,118,85,28,47,232,125,105,35,109,153,226,230,53,232,177,255,76,254,42,37,176,203,15,230,82,220,12,16,181,26,186,195,119,231,188,237,179,51,198,205,65,214,31,92,173,211,235,61,239,146,164,119,237,252,242,178,253,237,88,49,249,211,123,3,149,250,67,172,187,243,105,247,60,245,7,253,206,181,104,12,255,138,219,84,65,43,75,196,75,22,196,203,158,17,193,170,84,118,62,131,255,152,86,129,250,78,17,157,223,223,17,194,16,195,46,97,108,119,253,55,190,233,137,240,29,96,1,167,182,96,240,47,235,222,192,226,169,235,169,197,145,21,235,26,95,254,122,58,72,51,242,81,65,239,65,81,84,205,157,118,125,25,158,132,154,212,223,236,151,234,188,240,239,78,92,40,64,227,251,255,123,110,41,218,37,236,145,126,59,228,1,29,190,251,141,142,189,37,215,163,88,70,49,164,117,101,215,148,242,163,47,108,210,5,82,104,194,73,180,203,68,134,197,78,253,63,96,102,185,65,10,85,179,194,103,100,98,193,35,122,217,47,90,90,5,127,104,1,199,119,126,34,158,134,210,11,161,83,103,105,181,195,76,187,120,42,142,251,47,49,154,165,38,88,43,52,193,158,156,77,91,214,1,125,46,193,1,130,124,194,224,97,241,72,166,68,215,11,160,136,193,17,243,35,200,179,169,67,33,53,189,199,242,176,80,36,220,37,229,203,171,183,255,111,162,254,51,101,194,194,82,148,75,81,77,198,213,1,180,34,239,85,237,97,12,56,88,195,14,41,42,197,9,176,245,237,243,128,189,180,23,167,204,238,22,4,183,103,163,144,255,195,173,174,169,15,199,92,72,40,214,82,121,27,19,148,34,75,131,148,150,4,106,15,205,93,105,69,32,223,61,158,84,34,175,255,217,38,215,125,27,69,72,245,58,53,243,170,45,222,102,214,38,141,241,13,162,211,174,59,39,113,130,34,13,21,35,129,151,172,26,183,46,74,133,150,41,127,48,180,236,218,35,167,177,102,231,145,2,110,9,23,190,16,34,31,162,251,182,91,246,124,181,192,249,94,232,119,188,16,87,225,66,203,246,164,192,48,249,102,30,51,107,124,47,161,5,183,36,16,246,193,60,236,205,16,252,202,69,18,184,216,195,147,225,47,77,171,183,180,211,79,181,112,87,36,49,21,224,103,206,189,0,176,241,135,120,241,187,124,52,54,216,7,116,155,71,118,227,36,254,228,35,119,214,11,162,242,115,159,69,36,122,61,86,221,220,38,246,234,91,199,230,152,27,224,10,245,104,50,14,126,220,62,8,232,126,92,240,161,237,92,19,32,81,45,12,162,66,119,254,248,108,96,244,162,216,6,86,241,228,62,11,209,206,206,169,54,154,44,198,47,207,92,167,175,3,95,3,179,81,14,35,240,187,17,197,193,113,1,105,236,132,40,49,130,118,114,46,149,200,157,158,248,252,118,87,192,59,188,65,252,182,111,106,181,58,40,251,2,71,173,247,198,95,163,70,178,164,1,57,62,115,180,155,229,65,99,248,168,106,0,42,192,184,234,82,16,233,22,170,247,122,140,90,101,238,104,61,113,164,194,148,5,189,192,110,157,103,248,11,28,168,93,237,42,208,184,5,223,106,192,210,29,55,7,229,115,135,85,75,61,156,191,173,40,28,79,240,115,137,90,7,195,42,36,249,11,155,250,136,196,19,65,0,109,158,1,189,248,238,24,16,94,70,74,174,116,213,4,164,235,139,44,90,190,136,199,26,86,133,211,38,243,207,147,176,209,233,109,194,11,8,240,200,26,125,139,255,78,240,118,204,22,92,78,192,246,79,20,254,180,144,63,202,254,236,62,101,133,208,238,244,138,32,99,10,128,22,133,94,35,40,4,26,170,202,45,67,223,197,225,34,184,233,124,238,114,41,1,181,196,42,149,110,141,123,57,52,40,85,202,63,229,174,203,241,53,119,146,55,219,226,62,103,163,81,61,213,91,237,218,92,101,84,96,24,59,238,240,179,32,38,34,238,225,42,6,128,203,83,7,245,226,136,143,15,145,113,245,9,39,79,238,95,84,85,35,196,202,144,26,60,69,190,162,200,245,8,226,71,234,161,180,61,92,12,119,79,149,144,202,92,133,215,130,234,53,45,162,77,36,171,179,161,82,20,90,190,173,68,235,230,181,211,187,147,45,29,162,239,2,56,176,77,125,53,211,121,94,44,208,1,197,99,220,88,112,157,5,55,18,225,254,234,167,125,48,147,235,75,1,66,164,31,233,158,201,70,98,167,190,7,10,63,255,254,23,230,192,42,20,127,71,44,30,70,98,89,6,102,212,241,214,91,45,255,178,71,201,38,87,127,8,149,64,68,244,245,0,194,97,139,216,168,107,238,205,12,109,4,25,247,127,155,193,246,140,115,86,11,20,243,57,247,19,174,16,222,106,28,86,141,33,134,225,4,25,102,61,132,87,172,237,94,48,128,72,219,163,77,106,74,17,40,114,54,156,193,167,158,127,127,125,196,202,36,74,187,234,25,143,181,167,56,118,174,76,12,61,178,179,124,240,177,160,37,189,114,61,251,189,93,23,55,56,54,94,181,255,81,91,169,172,125,192,191,98,88,98,224,151,97,75,233,63,195,176,0,71,131,120,254,235,59,87,163,73,146,156,207,193,4,189,156,253,173,185,21,161,91,106,245,130,129,163,181,204,194,54,179,160,99,154,27,157,69,67,105,250,137,155,138,94,178,57,120,125,220,103,123,182,103,188,24,49,170,20,97,244,96,148,15,57,196,144,245,103,54,92,158,13,110,207,139,225,56,189,118,5,132,94,48,74,115,13,164,10,252,162,214,24,247,246,122,192,22,103,86,17,151,145,82,75,184,107,130,182,253,201,174,125,108,102,228,141,230,198,112,45,50,106,14,124,223,175,170,38,146,234,28,185,108,204,217,13,124,84,154,127,71,0,85,107,66,93,109,53,105,75,31,213,61,74,65,13,93,80,92,171,225,87,126,24,76,204,152,147,100,31,208,96,40,104,209,232,3,220,211,117,4,165,141,155,253,88,111,106,67,103,175,148,112,7,29,109,200,148,214,149,204,136,241,220,108,185,21,42,184,92,83,33,181,133,52,196,27,207,105,183,177,153,25,87,47,223,73,191,105,65,16,8,59,43,98,86,6,88,216,142,129,7,67,247,95,50,90,146,239,248,112,166,157,247,39,243,59,188,196,255,4,198,253,78,97,61,69,212,149,163,174,174,94,100,81,64,57,16,249,43,73,13,186,113,14,170,11,190,34,186,175,206,9,47,133,80,76,17,137,215,68,227,216,142,222,31,108,55,236,136,135,39,122,140,87,239,223,136,254,243,104,204,92,126,227,98,213,79,52,166,29,197,194,94,175,139,251,234,18,112,80,95,50,214,78,100,53,10,225,95,134,234,251,18,47,61,194,145,127,29,147,83,90,161,53,165,95,14,13,233,188,68,31,229,165,22,162,41,234,129,169,251,89,120,136,82,196,46,121,29,70,76,80,136,3,210,226,170,38,85,89,219,67,35,77,111,254,200,252,140,79,22,220,8,97,154,229,199,194,247,52,227,187,219,180,111,215,255,251,40,129,53,215,33,197,34,96,55,79,210,217,58,237,113,172,84,18,61,205,176,246,56,105,42,140,103,213,230,88,98,148,82,131,115,10,202,156,225,145,66,95,227,9,147,98,244,171,131,196,0,63,86,71,254,209,41,201,205,206,81,199,61,83,44,165,234,77,171,27,114,6,168,68,114,233,16,124,240,255,210,46,22,53,162,154,248,123,106,73,71,136,116,166,160,196,39,14,171,41,237,113,240,26,251,43,7,25,139,118,186,222,194,129,47,124};

// The ranking tile of 128x128 pixels.
// Each pixel contains an optimized 8d key used to scramble the sequence.
// The keys are optimized for all the powers of two spp below 16in 8d.
static const int rankingTile[128*128*8] = {9,9,8,8,9,9,12,12,6,6,0,0,7,7,10,10,0,0,0,0,9,9,12,12,5,5,2,2,7,7,1,1,8,8,5,5,8,8,0,0,6,6,9,9,10,10,4,4,15,15,4,4,13,13,12,12,14,14,1,1,11,11,3,3,11,11,7,7,14,14,0,0,6,6,13,13,1,1,6,6,3,3,10,10,8,8,5,5,14,14,9,9,0,0,3,3,2,2,12,12,14,14,1,1,7,7,12,12,7,7,12,12,14,14,6,6,1,1,1,1,13,13,14,14,9,9,5,5,5,5,12,12,5,5,15,15,12,12,0,0,0,0,0,0,7,7,4,4,1,1,8,8,9,9,8,8,0,0,1,1,8,8,0,0,5,5,10,10,0,0,11,11,0,0,0,0,4,4,14,14,13,13,3,3,7,7,5,5,13,13,14,14,10,10,8,8,11,11,7,7,6,6,11,11,12,12,2,2,3,3,3,3,15,15,12,12,6,6,12,12,7,7,7,7,3,3,11,11,6,6,7,7,4,4,5,5,0,0,9,9,11,11,3,3,5,5,4,4,13,13,7,7,6,6,2,2,9,9,2,2,13,13,5,5,15,15,14,14,8,8,8,8,8,8,1,1,3,3,1,1,0,0,15,15,6,6,8,8,11,11,2,2,14,14,8,8,4,4,3,3,7,7,2,2,0,0,4,4,7,7,7,7,9,9,8,8,1,1,11,11,9,9,14,14,2,2,15,15,6,6,4,4,0,0,14,14,0,0,14,14,9,9,8,8,3,3,2,2,11,11,4,4,0,0,3,3,2,2,5,5,2,2,12,12,9,9,3,3,4,4,11,11,9,9,14,14,10,10,5,5,0,0,5,5,9,9,13,13,9,9,2,2,0,0,9,9,4,4,3,3,13,13,2,2,12,12,13,13,1,1,4,4,14,14,14,14,15,15,0,0,15,15,5,5,8,8,0,0,12,12,11,11,5,5,7,7,7,7,4,4,2,2,13,13,9,9,13,13,5,5,14,14,0,0,8,8,7,7,3,3,4,4,13,13,1,1,6,6,11,11,5,5,6,6,12,12,15,15,11,11,15,15,14,14,1,1,8,8,10,10,9,9,0,0,0,0,1,1,12,12,10,10,11,11,2,2,1,1,1,1,7,7,0,0,1,1,4,4,7,7,0,0,14,14,13,13,7,7,6,6,12,12,1,1,6,6,3,3,9,9,6,6,15,15,9,9,3,3,14,14,0,0,10,10,8,8,6,6,13,13,0,0,4,4,5,5,2,2,11,11,1,1,13,13,5,5,13,13,8,8,9,9,9,9,10,10,5,5,1,1,10,10,1,1,13,13,7,7,10,10,5,5,13,13,4,4,1,1,5,5,6,6,13,13,6,6,10,10,6,6,1,1,1,1,10,10,3,3,6,6,11,11,0,0,15,15,3,3,4,4,1,1,0,0,4,4,5,5,12,12,12,12,3,3,1,1,6,6,2,2,12,12,4,4,6,6,7,7,3,3,11,11,8,8,5,5,8,8,6,6,12,12,0,0,0,0,14,14,10,10,9,9,3,3,9,9,5,5,10,10,11,11,10,10,1,1,4,4,1,1,15,15,12,12,13,13,13,13,2,2,1,1,11,11,4,4,3,3,2,2,9,9,12,12,7,7,3,3,3,3,14,14,6,6,1,1,6,6,12,12,8,8,11,11,1,1,13,13,12,12,8,8,15,15,10,10,13,13,0,0,8,8,3,3,3,3,6,6,5,5,10,10,13,13,5,5,8,8,11,11,4,4,13,13,8,8,0,0,2,2,12,12,8,8,7,7,13,13,0,0,7,7,14,14,8,8,8,8,5,5,11,11,15,15,5,5,12,12,11,11,13,13,12,12,7,7,3,3,0,0,8,8,10,10,8,8,1,1,6,6,6,6,13,13,8,8,1,1,3,3,14,14,12,12,5,5,11,11,1,1,5,5,11,11,0,0,0,0,9,9,9,9,4,4,8,8,10,10,8,8,8,8,13,13,2,2,13,13,7,7,5,5,10,10,2,2,14,14,7,7,5,5,7,7,4,4,9,9,2,2,8,8,8,8,4,4,8,8,9,9,15,15,15,15,6,6,13,13,10,10,2,2,10,10,0,0,4,4,1,1,9,9,13,13,13,13,0,0,4,4,3,3,5,5,12,12,6,6,15,15,10,10,15,15,4,4,9,9,0,0,11,11,12,12,13,13,4,4,1,1,15,15,7,7,1,1,8,8,1,1,12,12,10,10,12,12,8,8,14,14,1,1,10,10,5,5,1,1,14,14,11,11,12,12,6,6,2,2,9,9,1,1,4,4,14,14,3,3,12,12,6,6,11,11,1,1,14,14,10,10,11,11,3,3,6,6,12,12,7,7,15,15,13,13,13,13,0,0,12,12,5,5,1,1,1,1,1,1,6,6,4,4,6,6,10,10,3,3,0,0,8,8,14,14,6,6,1,1,5,5,2,2,4,4,14,14,5,5,11,11,7,7,7,7,14,14,1,1,11,11,0,0,2,2,11,11,13,13,1,1,12,12,2,2,1,1,6,6,3,3,9,9,5,5,2,2,11,11,15,15,2,2,8,8,12,12,8,8,5,5,11,11,5,5,9,9,5,5,0,0,6,6,12,12,13,13,7,7,15,15,5,5,14,14,15,15,11,11,9,9,2,2,13,13,0,0,4,4,0,0,2,2,10,10,3,3,1,1,7,7,11,11,1,1,12,12,11,11,7,7,3,3,1,1,5,5,5,5,5,5,12,12,11,11,1,1,1,1,11,11,3,3,6,6,4,4,5,5,13,13,14,14,4,4,4,4,6,6,5,5,11,11,2,2,2,2,9,9,0,0,13,13,15,15,12,12,1,1,12,12,1,1,10,10,2,2,1,1,2,2,14,14,2,2,8,8,8,8,4,4,3,3,13,13,6,6,5,5,0,0,9,9,10,10,4,4,7,7,0,0,1,1,5,5,15,15,4,4,1,1,10,10,6,6,8,8,12,12,2,2,3,3,6,6,12,12,9,9,1,1,14,14,13,13,4,4,6,6,7,7,0,0,12,12,9,9,14,14,0,0,9,9,3,3,4,4,13,13,2,2,15,15,9,9,1,1,15,15,6,6,6,6,3,3,11,11,3,3,15,15,3,3,8,8,14,14,3,3,3,3,12,12,8,8,0,0,2,2,3,3,1,1,8,8,2,2,8,8,5,5,2,2,5,5,7,7,0,0,9,9,7,7,9,9,4,4,4,4,12,12,5,5,13,13,7,7,7,7,13,13,10,10,8,8,3,3,4,4,5,5,3,3,2,2,12,12,2,2,9,9,1,1,9,9,0,0,11,11,2,2,11,11,13,13,11,11,3,3,12,12,1,1,2,2,8,8,7,7,14,14,5,5,3,3,3,3,12,12,7,7,2,2,2,2,7,7,1,1,6,6,4,4,7,7,13,13,9,9,12,12,7,7,15,15,7,7,4,4,13,13,10,10,3,3,0,0,14,14,2,2,13,13,13,13,12,12,4,4,4,4,7,7,14,14,1,1,10,10,14,14,2,2,4,4,11,11,1,1,11,11,4,4,14,14,9,9,2,2,5,5,4,4,8,8,10,10,11,11,5,5,8,8,0,0,5,5,13,13,0,0,3,3,8,8,0,0,15,15,1,1,5,5,15,15,2,2,3,3,11,11,13,13,1,1,9,9,9,9,1,1,5,5,13,13,2,2,6,6,3,3,11,11,1,1,12,12,7,7,7,7,4,4,9,9,10,10,6,6,13,13,15,15,13,13,3,3,13,13,10,10,11,11,3,3,13,13,12,12,9,9,6,6,3,3,1,1,15,15,1,1,13,13,8,8,2,2,12,12,7,7,14,14,10,10,15,15,9,9,5,5,4,4,0,0,1,1,10,10,14,14,9,9,9,9,7,7,4,4,15,15,12,12,0,0,0,0,9,9,6,6,12,12,3,3,11,11,15,15,3,3,9,9,3,3,6,6,5,5,0,0,8,8,2,2,1,1,2,2,11,11,7,7,6,6,15,15,8,8,12,12,14,14,7,7,10,10,6,6,12,12,13,13,3,3,7,7,1,1,14,14,7,7,7,7,1,1,13,13,7,7,2,2,2,2,11,11,14,14,14,14,11,11,6,6,10,10,14,14,5,5,0,0,7,7,14,14,11,11,9,9,7,7,2,2,6,6,7,7,2,2,10,10,6,6,0,0,8,8,8,8,1,1,0,0,0,0,2,2,1,1,3,3,3,3,9,9,6,6,7,7,8,8,11,11,6,6,12,12,13,13,9,9,1,1,15,15,6,6,7,7,10,10,5,5,7,7,5,5,5,5,15,15,5,5,1,1,12,12,13,13,7,7,9,9,6,6,5,5,3,3,5,5,0,0,13,13,5,5,3,3,15,15,15,15,12,12,5,5,10,10,13,13,9,9,4,4,12,12,2,2,9,9,4,4,0,0,14,14,12,12,2,2,11,11,13,13,1,1,6,6,4,4,14,14,5,5,7,7,13,13,7,7,11,11,0,0,5,5,9,9,1,1,14,14,6,6,10,10,1,1,2,2,7,7,15,15,0,0,14,14,9,9,12,12,13,13,14,14,7,7,6,6,15,15,13,13,15,15,5,5,6,6,7,7,14,14,4,4,8,8,2,2,12,12,6,6,2,2,7,7,13,13,15,15,12,12,7,7,1,1,10,10,4,4,0,0,7,7,4,4,10,10,1,1,3,3,13,13,5,5,5,5,7,7,12,12,11,11,5,5,6,6,12,12,7,7,6,6,12,12,10,10,9,9,12,12,9,9,13,13,14,14,9,9,4,4,9,9,4,4,12,12,0,0,1,1,9,9,8,8,14,14,14,14,3,3,10,10,0,0,10,10,0,0,3,3,10,10,8,8,2,2,4,4,14,14,14,14,5,5,11,11,7,7,13,13,10,10,6,6,12,12,0,0,14,14,9,9,6,6,3,3,12,12,8,8,13,13,9,9,5,5,4,4,12,12,8,8,0,0,13,13,5,5,14,14,3,3,12,12,14,14,5,5,2,2,9,9,12,12,6,6,12,12,6,6,14,14,9,9,0,0,10,10,6,6,10,10,10,10,9,9,8,8,5,5,6,6,2,2,14,14,1,1,8,8,6,6,12,12,3,3,5,5,15,15,8,8,6,6,14,14,2,2,11,11,4,4,4,4,12,12,14,14,6,6,12,12,5,5,7,7,3,3,9,9,12,12,4,4,11,11,12,12,15,15,2,2,9,9,7,7,13,13,6,6,0,0,5,5,6,6,14,14,6,6,10,10,1,1,14,14,2,2,4,4,9,9,5,5,15,15,7,7,12,12,1,1,4,4,1,1,0,0,0,0,0,0,7,7,5,5,8,8,6,6,15,15,2,2,1,1,11,11,12,12,7,7,9,9,8,8,4,4,3,3,0,0,0,0,5,5,15,15,10,10,5,5,13,13,0,0,12,12,8,8,2,2,12,12,1,1,2,2,2,2,6,6,13,13,2,2,11,11,3,3,9,9,12,12,3,3,14,14,4,4,6,6,7,7,10,10,2,2,10,10,2,2,11,11,14,14,13,13,8,8,1,1,0,0,1,1,14,14,1,1,13,13,9,9,4,4,11,11,11,11,4,4,5,5,3,3,9,9,3,3,14,14,2,2,3,3,2,2,5,5,15,15,6,6,13,13,3,3,7,7,15,15,14,14,5,5,6,6,0,0,8,8,2,2,4,4,3,3,5,5,2,2,8,8,14,14,12,12,6,6,13,13,6,6,2,2,8,8,4,4,7,7,10,10,9,9,6,6,13,13,5,5,11,11,1,1,9,9,8,8,12,12,9,9,9,9,0,0,4,4,3,3,7,7,1,1,15,15,14,14,5,5,0,0,12,12,3,3,14,14,13,13,14,14,11,11,13,13,7,7,4,4,1,1,6,6,6,6,14,14,9,9,8,8,12,12,3,3,6,6,1,1,13,13,6,6,15,15,7,7,7,7,3,3,6,6,9,9,5,5,8,8,9,9,12,12,3,3,3,3,1,1,2,2,14,14,4,4,7,7,13,13,6,6,15,15,1,1,6,6,4,4,13,13,4,4,15,15,14,14,8,8,14,14,1,1,12,12,8,8,0,0,13,13,14,14,4,4,8,8,9,9,0,0,13,13,15,15,5,5,15,15,13,13,2,2,14,14,15,15,1,1,2,2,0,0,8,8,12,12,0,0,6,6,10,10,2,2,7,7,14,14,14,14,1,1,6,6,9,9,12,12,0,0,2,2,1,1,8,8,10,10,7,7,6,6,4,4,6,6,11,11,14,14,9,9,1,1,11,11,4,4,7,7,0,0,6,6,3,3,6,6,12,12,9,9,7,7,4,4,14,14,15,15,1,1,7,7,13,13,6,6,2,2,5,5,5,5,9,9,4,4,3,3,3,3,9,9,8,8,4,4,5,5,2,2,0,0,10,10,11,11,9,9,6,6,1,1,13,13,15,15,2,2,3,3,5,5,2,2,13,13,4,4,1,1,13,13,0,0,4,4,12,12,9,9,7,7,4,4,8,8,4,4,1,1,6,6,12,12,5,5,11,11,4,4,5,5,10,10,5,5,13,13,5,5,10,10,0,0,8,8,15,15,15,15,2,2,11,11,8,8,10,10,13,13,14,14,4,4,14,14,4,4,6,6,10,10,0,0,8,8,5,5,2,2,3,3,10,10,13,13,15,15,6,6,8,8,10,10,12,12,14,14,2,2,8,8,12,12,1,1,4,4,2,2,2,2,3,3,11,11,9,9,10,10,6,6,4,4,4,4,0,0,8,8,7,7,2,2,12,12,14,14,3,3,1,1,14,14,10,10,0,0,5,5,1,1,11,11,1,1,3,3,11,11,7,7,15,15,11,11,8,8,9,9,5,5,2,2,2,2,2,2,13,13,5,5,1,1,1,1,13,13,2,2,11,11,7,7,5,5,4,4,15,15,0,0,6,6,7,7,8,8,0,0,3,3,13,13,7,7,8,8,9,9,9,9,11,11,14,14,13,13,7,7,7,7,14,14,7,7,4,4,9,9,5,5,9,9,12,12,3,3,11,11,3,3,0,0,9,9,11,11,2,2,2,2,0,0,3,3,15,15,8,8,13,13,9,9,7,7,14,14,14,14,15,15,6,6,11,11,4,4,0,0,6,6,0,0,11,11,6,6,6,6,5,5,7,7,13,13,2,2,7,7,2,2,13,13,4,4,4,4,1,1,5,5,4,4,3,3,13,13,8,8,4,4,1,1,15,15,10,10,14,14,5,5,0,0,4,4,11,11,12,12,5,5,9,9,2,2,0,0,15,15,4,4,10,10,12,12,1,1,7,7,9,9,0,0,5,5,0,0,7,7,7,7,5,5,15,15,2,2,1,1,15,15,5,5,1,1,8,8,15,15,12,12,0,0,9,9,8,8,8,8,4,4,12,12,2,2,0,0,5,5,3,3,0,0,8,8,1,1,9,9,6,6,1,1,1,1,15,15,10,10,15,15,15,15,7,7,10,10,10,10,12,12,5,5,6,6,14,14,12,12,4,4,3,3,11,11,13,13,0,0,10,10,3,3,11,11,12,12,9,9,10,10,10,10,3,3,14,14,2,2,8,8,14,14,3,3,12,12,2,2,8,8,0,0,14,14,7,7,8,8,13,13,12,12,3,3,5,5,9,9,11,11,11,11,15,15,4,4,1,1,4,4,12,12,0,0,0,0,13,13,8,8,12,12,11,11,14,14,13,13,6,6,15,15,5,5,5,5,2,2,1,1,1,1,3,3,0,0,8,8,10,10,15,15,4,4,4,4,1,1,5,5,2,2,9,9,2,2,12,12,11,11,3,3,2,2,13,13,4,4,4,4,10,10,8,8,13,13,13,13,5,5,4,4,14,14,4,4,1,1,9,9,12,12,8,8,15,15,5,5,7,7,2,2,7,7,8,8,6,6,0,0,13,13,14,14,4,4,13,13,7,7,1,1,4,4,9,9,11,11,10,10,10,10,11,11,0,0,2,2,3,3,1,1,8,8,7,7,11,11,11,11,3,3,4,4,6,6,0,0,11,11,6,6,3,3,9,9,14,14,10,10,8,8,2,2,3,3,13,13,8,8,4,4,5,5,12,12,12,12,4,4,14,14,15,15,7,7,7,7,3,3,8,8,8,8,0,0,3,3,1,1,6,6,14,14,4,4,0,0,10,10,1,1,13,13,10,10,13,13,11,11,12,12,11,11,15,15,1,1,8,8,8,8,2,2,10,10,5,5,12,12,13,13,2,2,0,0,11,11,14,14,9,9,15,15,3,3,3,3,13,13,5,5,9,9,3,3,4,4,12,12,1,1,15,15,13,13,10,10,1,1,7,7,1,1,8,8,0,0,1,1,2,2,7,7,9,9,4,4,6,6,11,11,13,13,13,13,10,10,8,8,1,1,11,11,11,11,5,5,11,11,4,4,11,11,0,0,9,9,6,6,5,5,6,6,15,15,5,5,7,7,8,8,10,10,11,11,12,12,5,5,15,15,9,9,2,2,9,9,4,4,1,1,10,10,10,10,6,6,15,15,8,8,9,9,5,5,10,10,1,1,2,2,6,6,12,12,6,6,1,1,6,6,9,9,13,13,2,2,13,13,11,11,3,3,11,11,4,4,1,1,2,2,0,0,2,2,7,7,6,6,11,11,10,10,11,11,11,11,2,2,3,3,7,7,9,9,15,15,14,14,13,13,3,3,11,11,14,14,6,6,7,7,12,12,6,6,3,3,3,3,0,0,3,3,5,5,13,13,11,11,8,8,2,2,10,10,4,4,15,15,15,15,3,3,1,1,6,6,10,10,13,13,5,5,14,14,15,15,7,7,11,11,0,0,5,5,3,3,5,5,15,15,0,0,7,7,14,14,13,13,0,0,5,5,6,6,1,1,12,12,2,2,6,6,7,7,13,13,1,1,3,3,10,10,3,3,10,10,0,0,7,7,15,15,10,10,14,14,3,3,9,9,4,4,14,14,12,12,1,1,7,7,3,3,10,10,14,14,13,13,12,12,0,0,2,2,3,3,9,9,4,4,14,14,2,2,14,14,1,1,10,10,6,6,0,0,0,0,14,14,5,5,5,5,8,8,5,5,3,3,5,5,5,5,14,14,1,1,5,5,4,4,5,5,5,5,10,10,6,6,4,4,1,1,13,13,6,6,1,1,9,9,12,12,9,9,2,2,7,7,1,1,12,12,13,13,1,1,8,8,12,12,9,9,3,3,2,2,9,9,12,12,2,2,1,1,7,7,1,1,5,5,0,0,1,1,3,3,5,5,13,13,9,9,6,6,5,5,13,13,4,4,9,9,3,3,1,1,15,15,9,9,0,0,6,6,3,3,4,4,11,11,10,10,8,8,13,13,13,13,0,0,13,13,0,0,5,5,14,14,1,1,4,4,15,15,5,5,10,10,11,11,9,9,0,0,4,4,9,9,1,1,3,3,5,5,6,6,12,12,8,8,2,2,14,14,1,1,8,8,8,8,10,10,1,1,14,14,5,5,7,7,12,12,6,6,0,0,15,15,12,12,2,2,15,15,2,2,5,5,13,13,12,12,12,12,2,2,11,11,10,10,10,10,5,5,3,3,8,8,13,13,2,2,2,2,0,0,7,7,7,7,13,13,2,2,8,8,1,1,8,8,9,9,7,7,4,4,12,12,0,0,4,4,11,11,5,5,3,3,1,1,3,3,1,1,2,2,5,5,6,6,6,6,12,12,15,15,13,13,6,6,15,15,15,15,12,12,10,10,14,14,0,0,4,4,14,14,1,1,4,4,6,6,15,15,5,5,12,12,10,10,10,10,13,13,8,8,14,14,8,8,5,5,5,5,7,7,2,2,0,0,9,9,2,2,8,8,4,4,14,14,14,14,7,7,11,11,2,2,3,3,0,0,2,2,7,7,7,7,14,14,15,15,1,1,3,3,12,12,1,1,9,9,3,3,4,4,9,9,12,12,5,5,15,15,8,8,4,4,13,13,7,7,2,2,7,7,3,3,14,14,3,3,2,2,3,3,13,13,8,8,13,13,12,12,7,7,10,10,1,1,6,6,9,9,9,9,2,2,12,12,7,7,13,13,11,11,10,10,11,11,5,5,3,3,0,0,8,8,4,4,3,3,10,10,10,10,9,9,15,15,13,13,10,10,15,15,15,15,7,7,15,15,15,15,9,9,0,0,7,7,5,5,13,13,4,4,11,11,4,4,3,3,8,8,0,0,6,6,15,15,0,0,14,14,11,11,10,10,2,2,8,8,7,7,12,12,0,0,6,6,10,10,11,11,3,3,2,2,3,3,5,5,3,3,3,3,9,9,9,9,2,2,0,0,11,11,6,6,0,0,13,13,7,7,7,7,8,8,15,15,14,14,0,0,4,4,3,3,1,1,7,7,11,11,13,13,8,8,4,4,11,11,12,12,9,9,2,2,6,6,14,14,12,12,8,8,9,9,5,5,5,5,3,3,7,7,12,12,2,2,9,9,8,8,1,1,10,10,8,8,9,9,5,5,15,15,6,6,11,11,1,1,6,6,1,1,1,1,6,6,5,5,15,15,13,13,14,14,11,11,9,9,14,14,0,0,6,6,1,1,10,10,2,2,7,7,13,13,2,2,5,5,12,12,0,0,3,3,12,12,15,15,12,12,1,1,2,2,13,13,2,2,4,4,9,9,0,0,12,12,3,3,1,1,4,4,3,3,14,14,2,2,5,5,13,13,9,9,7,7,0,0,11,11,0,0,7,7,0,0,4,4,12,12,10,10,5,5,3,3,0,0,8,8,13,13,6,6,0,0,1,1,3,3,14,14,12,12,4,4,14,14,10,10,2,2,3,3,14,14,6,6,9,9,2,2,3,3,7,7,7,7,12,12,8,8,12,12,6,6,12,12,12,12,3,3,6,6,7,7,1,1,10,10,6,6,9,9,10,10,7,7,7,7,8,8,14,14,0,0,5,5,7,7,0,0,2,2,1,1,2,2,4,4,7,7,11,11,13,13,12,12,0,0,10,10,6,6,12,12,14,14,9,9,11,11,14,14,8,8,5,5,7,7,9,9,9,9,2,2,8,8,6,6,11,11,8,8,4,4,11,11,0,0,12,12,10,10,10,10,2,2,6,6,9,9,6,6,11,11,4,4,7,7,9,9,9,9,0,0,14,14,6,6,8,8,5,5,8,8,0,0,5,5,15,15,8,8,9,9,0,0,10,10,6,6,7,7,7,7,13,13,0,0,6,6,2,2,13,13,0,0,15,15,12,12,15,15,14,14,15,15,14,14,12,12,0,0,8,8,13,13,7,7,4,4,6,6,6,6,9,9,10,10,4,4,9,9,4,4,13,13,7,7,7,7,11,11,11,11,12,12,3,3,5,5,13,13,5,5,4,4,6,6,13,13,5,5,6,6,12,12,0,0,15,15,13,13,15,15,12,12,14,14,13,13,15,15,6,6,11,11,2,2,0,0,12,12,5,5,15,15,0,0,11,11,15,15,2,2,14,14,12,12,12,12,2,2,6,6,13,13,4,4,9,9,13,13,0,0,7,7,3,3,15,15,12,12,12,12,13,13,13,13,13,13,4,4,13,13,12,12,8,8,1,1,11,11,1,1,2,2,6,6,12,12,3,3,12,12,2,2,7,7,7,7,7,7,1,1,1,1,10,10,12,12,0,0,1,1,1,1,4,4,5,5,12,12,6,6,2,2,11,11,2,2,15,15,14,14,12,12,1,1,5,5,12,12,12,12,6,6,2,2,1,1,3,3,11,11,9,9,6,6,8,8,8,8,10,10,5,5,9,9,11,11,1,1,0,0,15,15,10,10,6,6,4,4,12,12,10,10,3,3,2,2,5,5,1,1,8,8,14,14,13,13,13,13,3,3,9,9,14,14,3,3,11,11,14,14,13,13,4,4,11,11,2,2,5,5,13,13,14,14,12,12,4,4,1,1,9,9,2,2,0,0,11,11,10,10,12,12,1,1,12,12,6,6,12,12,12,12,9,9,1,1,8,8,0,0,7,7,9,9,11,11,5,5,1,1,0,0,13,13,9,9,13,13,13,13,12,12,3,3,1,1,12,12,1,1,14,14,3,3,12,12,10,10,1,1,9,9,14,14,8,8,0,0,11,11,11,11,6,6,13,13,0,0,6,6,0,0,0,0,6,6,0,0,4,4,1,1,5,5,11,11,7,7,15,15,7,7,5,5,12,12,1,1,3,3,12,12,9,9,10,10,7,7,0,0,2,2,3,3,5,5,13,13,1,1,11,11,13,13,0,0,7,7,0,0,10,10,4,4,12,12,10,10,0,0,4,4,14,14,10,10,4,4,6,6,0,0,0,0,0,0,7,7,11,11,12,12,7,7,14,14,3,3,5,5,8,8,4,4,8,8,1,1,13,13,6,6,5,5,7,7,7,7,14,14,8,8,2,2,4,4,5,5,1,1,3,3,0,0,12,12,7,7,3,3,5,5,8,8,9,9,7,7,8,8,3,3,11,11,13,13,13,13,14,14,10,10,0,0,1,1,4,4,3,3,11,11,0,0,6,6,9,9,3,3,2,2,6,6,4,4,1,1,15,15,1,1,10,10,10,10,0,0,0,0,15,15,9,9,10,10,3,3,11,11,4,4,7,7,13,13,13,13,5,5,1,1,12,12,1,1,13,13,9,9,13,13,9,9,2,2,6,6,14,14,13,13,2,2,4,4,13,13,10,10,3,3,1,1,7,7,3,3,2,2,3,3,4,4,8,8,10,10,10,10,3,3,12,12,12,12,11,11,8,8,13,13,7,7,15,15,9,9,1,1,4,4,0,0,7,7,10,10,8,8,3,3,9,9,2,2,4,4,11,11,15,15,0,0,13,13,12,12,4,4,14,14,7,7,3,3,8,8,3,3,1,1,3,3,3,3,1,1,14,14,12,12,7,7,0,0,14,14,5,5,14,14,3,3,0,0,7,7,4,4,4,4,6,6,12,12,14,14,1,1,5,5,8,8,10,10,2,2,9,9,2,2,10,10,9,9,6,6,1,1,10,10,8,8,12,12,14,14,2,2,0,0,13,13,12,12,9,9,12,12,15,15,3,3,9,9,9,9,0,0,5,5,2,2,8,8,2,2,6,6,6,6,10,10,3,3,1,1,7,7,9,9,8,8,0,0,7,7,6,6,4,4,4,4,6,6,0,0,2,2,4,4,12,12,8,8,8,8,11,11,14,14,13,13,6,6,0,0,6,6,10,10,10,10,11,11,3,3,1,1,2,2,13,13,6,6,3,3,9,9,13,13,8,8,3,3,1,1,14,14,11,11,2,2,6,6,14,14,6,6,10,10,0,0,15,15,10,10,14,14,2,2,7,7,9,9,4,4,10,10,0,0,1,1,9,9,13,13,8,8,4,4,7,7,5,5,5,5,9,9,10,10,7,7,15,15,15,15,11,11,15,15,2,2,2,2,15,15,2,2,5,5,10,10,13,13,9,9,12,12,15,15,14,14,6,6,0,0,14,14,3,3,10,10,1,1,7,7,5,5,8,8,1,1,14,14,10,10,10,10,4,4,5,5,1,1,13,13,3,3,12,12,9,9,13,13,11,11,6,6,8,8,8,8,7,7,1,1,2,2,8,8,3,3,7,7,13,13,0,0,0,0,5,5,12,12,9,9,1,1,14,14,0,0,0,0,11,11,15,15,15,15,7,7,15,15,14,14,1,1,0,0,1,1,3,3,12,12,4,4,8,8,14,14,4,4,8,8,8,8,0,0,3,3,3,3,0,0,3,3,3,3,6,6,0,0,1,1,2,2,1,1,13,13,10,10,14,14,7,7,13,13,11,11,11,11,13,13,10,10,13,13,12,12,13,13,10,10,9,9,14,14,11,11,12,12,3,3,10,10,0,0,5,5,14,14,2,2,0,0,7,7,2,2,13,13,11,11,6,6,3,3,9,9,14,14,3,3,4,4,9,9,11,11,0,0,3,3,5,5,4,4,9,9,9,9,15,15,4,4,7,7,10,10,12,12,8,8,1,1,3,3,2,2,6,6,10,10,0,0,3,3,1,1,8,8,8,8,9,9,12,12,6,6,3,3,0,0,8,8,11,11,15,15,6,6,0,0,5,5,3,3,3,3,7,7,5,5,1,1,10,10,10,10,1,1,13,13,0,0,1,1,8,8,6,6,6,6,15,15,15,15,15,15,9,9,11,11,4,4,11,11,11,11,5,5,12,12,3,3,13,13,6,6,2,2,9,9,14,14,5,5,14,14,1,1,11,11,6,6,8,8,2,2,6,6,5,5,6,6,12,12,2,2,14,14,5,5,5,5,13,13,8,8,11,11,0,0,0,0,11,11,13,13,10,10,0,0,2,2,8,8,2,2,9,9,1,1,4,4,12,12,12,12,14,14,4,4,1,1,3,3,0,0,2,2,5,5,8,8,5,5,6,6,5,5,5,5,4,4,12,12,9,9,2,2,14,14,10,10,7,7,14,14,9,9,4,4,2,2,9,9,6,6,7,7,1,1,0,0,1,1,2,2,5,5,10,10,0,0,1,1,0,0,13,13,10,10,10,10,3,3,6,6,9,9,4,4,8,8,15,15,10,10,13,13,4,4,12,12,0,0,2,2,5,5,2,2,14,14,3,3,7,7,10,10,12,12,12,12,13,13,8,8,12,12,13,13,11,11,2,2,10,10,14,14,1,1,4,4,11,11,1,1,12,12,9,9,2,2,6,6,8,8,8,8,12,12,14,14,3,3,9,9,6,6,14,14,3,3,0,0,2,2,7,7,1,1,12,12,14,14,11,11,0,0,5,5,4,4,1,1,3,3,5,5,1,1,3,3,11,11,6,6,4,4,2,2,10,10,6,6,7,7,9,9,5,5,1,1,2,2,8,8,11,11,11,11,5,5,2,2,11,11,3,3,9,9,2,2,9,9,7,7,10,10,5,5,0,0,14,14,0,0,8,8,8,8,3,3,4,4,9,9,14,14,13,13,10,10,12,12,14,14,9,9,4,4,3,3,4,4,12,12,15,15,3,3,7,7,10,10,11,11,2,2,6,6,1,1,7,7,10,10,4,4,1,1,12,12,11,11,13,13,5,5,12,12,9,9,0,0,11,11,2,2,3,3,10,10,8,8,4,4,8,8,3,3,11,11,12,12,10,10,4,4,13,13,1,1,3,3,7,7,0,0,3,3,1,1,4,4,10,10,0,0,5,5,15,15,2,2,4,4,1,1,14,14,14,14,4,4,9,9,0,0,12,12,10,10,13,13,2,2,8,8,6,6,12,12,8,8,15,15,4,4,12,12,5,5,14,14,15,15,6,6,14,14,5,5,14,14,12,12,12,12,13,13,8,8,12,12,13,13,13,13,1,1,15,15,6,6,8,8,8,8,2,2,1,1,8,8,8,8,8,8,4,4,5,5,9,9,11,11,3,3,6,6,5,5,15,15,14,14,13,13,5,5,4,4,13,13,13,13,12,12,12,12,6,6,14,14,15,15,8,8,10,10,1,1,1,1,1,1,13,13,10,10,6,6,1,1,15,15,9,9,15,15,4,4,2,2,9,9,6,6,9,9,8,8,9,9,8,8,0,0,0,0,3,3,7,7,11,11,11,11,10,10,8,8,3,3,5,5,10,10,4,4,6,6,10,10,4,4,10,10,9,9,10,10,2,2,1,1,8,8,13,13,2,2,7,7,5,5,4,4,0,0,10,10,13,13,3,3,4,4,10,10,0,0,9,9,6,6,7,7,6,6,2,2,15,15,0,0,11,11,3,3,8,8,9,9,14,14,14,14,13,13,3,3,7,7,7,7,0,0,14,14,6,6,13,13,14,14,10,10,3,3,10,10,11,11,5,5,0,0,10,10,2,2,3,3,3,3,14,14,6,6,11,11,4,4,5,5,11,11,0,0,15,15,2,2,12,12,2,2,8,8,1,1,10,10,2,2,1,1,10,10,4,4,6,6,6,6,13,13,12,12,5,5,4,4,13,13,1,1,5,5,15,15,0,0,14,14,9,9,13,13,4,4,0,0,12,12,8,8,14,14,13,13,9,9,10,10,7,7,11,11,9,9,6,6,10,10,8,8,2,2,13,13,1,1,9,9,2,2,6,6,9,9,9,9,5,5,5,5,1,1,7,7,12,12,9,9,5,5,15,15,2,2,11,11,4,4,5,5,2,2,12,12,10,10,4,4,14,14,2,2,6,6,7,7,13,13,1,1,7,7,6,6,12,12,7,7,0,0,11,11,11,11,8,8,2,2,8,8,1,1,7,7,4,4,1,1,6,6,7,7,7,7,14,14,10,10,15,15,11,11,1,1,12,12,9,9,7,7,0,0,14,14,4,4,0,0,9,9,5,5,0,0,12,12,8,8,6,6,10,10,7,7,15,15,3,3,10,10,5,5,8,8,1,1,11,11,11,11,0,0,7,7,0,0,6,6,7,7,14,14,13,13,0,0,0,0,11,11,13,13,3,3,7,7,8,8,14,14,6,6,13,13,0,0,1,1,9,9,12,12,1,1,10,10,14,14,12,12,14,14,0,0,10,10,0,0,14,14,7,7,15,15,15,15,15,15,2,2,14,14,11,11,3,3,4,4,4,4,5,5,10,10,11,11,8,8,0,0,13,13,12,12,1,1,12,12,14,14,6,6,14,14,8,8,7,7,14,14,10,10,14,14,1,1,3,3,2,2,5,5,12,12,1,1,1,1,12,12,5,5,10,10,2,2,10,10,8,8,12,12,6,6,6,6,4,4,14,14,4,4,0,0,12,12,8,8,5,5,14,14,6,6,1,1,11,11,5,5,1,1,9,9,1,1,11,11,13,13,7,7,13,13,10,10,4,4,15,15,7,7,5,5,14,14,6,6,4,4,10,10,2,2,15,15,8,8,2,2,13,13,12,12,0,0,1,1,9,9,8,8,5,5,5,5,4,4,3,3,1,1,9,9,2,2,6,6,2,2,2,2,12,12,4,4,11,11,10,10,8,8,3,3,7,7,8,8,14,14,6,6,13,13,0,0,10,10,0,0,5,5,14,14,14,14,7,7,11,11,12,12,0,0,4,4,14,14,11,11,8,8,4,4,3,3,3,3,3,3,6,6,10,10,5,5,3,3,14,14,0,0,13,13,12,12,8,8,15,15,14,14,14,14,11,11,2,2,1,1,3,3,10,10,12,12,9,9,7,7,13,13,0,0,13,13,1,1,1,1,15,15,12,12,15,15,13,13,9,9,10,10,7,7,10,10,7,7,12,12,14,14,1,1,9,9,15,15,13,13,0,0,4,4,4,4,9,9,14,14,14,14,15,15,2,2,3,3,5,5,8,8,0,0,14,14,4,4,0,0,7,7,14,14,15,15,3,3,9,9,6,6,13,13,8,8,3,3,2,2,11,11,4,4,5,5,12,12,5,5,11,11,2,2,0,0,5,5,4,4,5,5,12,12,15,15,1,1,8,8,1,1,15,15,7,7,11,11,8,8,15,15,1,1,7,7,15,15,6,6,14,14,13,13,15,15,8,8,4,4,14,14,15,15,12,12,12,12,14,14,6,6,8,8,6,6,4,4,1,1,11,11,7,7,11,11,3,3,12,12,6,6,13,13,12,12,8,8,10,10,7,7,0,0,13,13,4,4,14,14,12,12,4,4,5,5,14,14,13,13,12,12,13,13,1,1,2,2,8,8,15,15,2,2,9,9,5,5,1,1,2,2,15,15,6,6,8,8,1,1,5,5,10,10,1,1,9,9,8,8,6,6,8,8,5,5,11,11,7,7,8,8,14,14,0,0,7,7,14,14,13,13,3,3,15,15,9,9,15,15,2,2,1,1,4,4,0,0,4,4,6,6,15,15,5,5,15,15,14,14,4,4,8,8,10,10,14,14,10,10,0,0,12,12,14,14,2,2,6,6,9,9,5,5,2,2,12,12,14,14,6,6,9,9,4,4,3,3,5,5,14,14,7,7,14,14,7,7,11,11,8,8,5,5,0,0,7,7,3,3,8,8,11,11,9,9,2,2,10,10,10,10,9,9,6,6,2,2,7,7,6,6,2,2,7,7,2,2,5,5,3,3,15,15,3,3,7,7,8,8,5,5,7,7,14,14,5,5,10,10,4,4,6,6,10,10,6,6,2,2,1,1,15,15,6,6,4,4,11,11,5,5,4,4,8,8,12,12,1,1,14,14,1,1,1,1,5,5,13,13,0,0,8,8,13,13,0,0,2,2,4,4,1,1,9,9,11,11,3,3,13,13,0,0,2,2,2,2,4,4,14,14,0,0,5,5,0,0,12,12,15,15,10,10,5,5,15,15,2,2,6,6,6,6,5,5,9,9,6,6,8,8,10,10,3,3,13,13,4,4,4,4,14,14,14,14,11,11,5,5,10,10,4,4,8,8,3,3,5,5,14,14,3,3,1,1,15,15,11,11,1,1,2,2,8,8,9,9,4,4,1,1,2,2,7,7,1,1,4,4,5,5,2,2,11,11,15,15,4,4,5,5,9,9,10,10,4,4,11,11,15,15,2,2,15,15,12,12,1,1,13,13,13,13,0,0,15,15,13,13,8,8,3,3,5,5,0,0,2,2,1,1,5,5,9,9,9,9,3,3,4,4,1,1,8,8,6,6,11,11,3,3,0,0,2,2,8,8,12,12,0,0,10,10,5,5,1,1,3,3,6,6,13,13,0,0,4,4,2,2,11,11,4,4,13,13,2,2,13,13,11,11,4,4,10,10,4,4,5,5,9,9,4,4,8,8,0,0,10,10,6,6,4,4,15,15,0,0,4,4,8,8,15,15,13,13,7,7,13,13,6,6,5,5,0,0,3,3,3,3,1,1,4,4,5,5,2,2,2,2,2,2,10,10,11,11,9,9,13,13,11,11,11,11,11,11,5,5,14,14,8,8,11,11,0,0,2,2,9,9,14,14,7,7,15,15,0,0,6,6,11,11,6,6,6,6,1,1,12,12,7,7,8,8,4,4,1,1,8,8,1,1,4,4,0,0,9,9,8,8,4,4,4,4,0,0,0,0,9,9,3,3,7,7,10,10,10,10,6,6,11,11,15,15,3,3,9,9,3,3,12,12,13,13,1,1,3,3,6,6,9,9,0,0,14,14,12,12,2,2,5,5,12,12,5,5,10,10,7,7,8,8,1,1,2,2,2,2,8,8,7,7,8,8,5,5,5,5,12,12,14,14,7,7,5,5,8,8,12,12,8,8,14,14,0,0,15,15,0,0,12,12,0,0,7,7,14,14,1,1,5,5,3,3,1,1,14,14,1,1,1,1,3,3,4,4,13,13,13,13,0,0,13,13,2,2,5,5,10,10,7,7,1,1,13,13,1,1,3,3,0,0,0,0,8,8,3,3,12,12,9,9,1,1,5,5,8,8,5,5,13,13,13,13,0,0,1,1,1,1,9,9,1,1,1,1,11,11,6,6,7,7,3,3,10,10,1,1,3,3,3,3,3,3,10,10,5,5,9,9,7,7,10,10,12,12,14,14,0,0,11,11,0,0,10,10,0,0,15,15,7,7,9,9,11,11,7,7,2,2,0,0,11,11,3,3,0,0,14,14,7,7,13,13,9,9,0,0,11,11,2,2,2,2,11,11,15,15,8,8,10,10,3,3,9,9,9,9,13,13,2,2,8,8,13,13,2,2,10,10,12,12,11,11,6,6,8,8,0,0,11,11,0,0,8,8,10,10,8,8,2,2,9,9,11,11,13,13,1,1,10,10,12,12,4,4,15,15,8,8,14,14,13,13,12,12,7,7,10,10,0,0,3,3,12,12,9,9,0,0,11,11,0,0,8,8,10,10,2,2,13,13,4,4,4,4,13,13,9,9,11,11,5,5,10,10,10,10,3,3,11,11,10,10,3,3,10,10,11,11,6,6,12,12,13,13,2,2,3,3,12,12,14,14,1,1,8,8,2,2,13,13,4,4,5,5,3,3,8,8,6,6,13,13,9,9,10,10,5,5,8,8,7,7,0,0,2,2,14,14,9,9,1,1,6,6,6,6,0,0,1,1,4,4,9,9,11,11,1,1,13,13,0,0,5,5,14,14,5,5,2,2,6,6,13,13,6,6,12,12,1,1,3,3,9,9,14,14,5,5,12,12,11,11,2,2,9,9,4,4,11,11,6,6,8,8,4,4,11,11,4,4,12,12,14,14,1,1,4,4,14,14,0,0,11,11,8,8,12,12,5,5,9,9,11,11,4,4,10,10,11,11,1,1,6,6,8,8,6,6,3,3,9,9,10,10,9,9,3,3,4,4,8,8,7,7,12,12,13,13,10,10,7,7,8,8,6,6,3,3,0,0,10,10,2,2,10,10,0,0,5,5,13,13,12,12,4,4,4,4,15,15,6,6,6,6,11,11,12,12,6,6,10,10,13,13,13,13,7,7,10,10,2,2,11,11,1,1,9,9,4,4,14,14,2,2,10,10,9,9,10,10,10,10,10,10,15,15,14,14,6,6,11,11,0,0,7,7,0,0,3,3,4,4,12,12,15,15,15,15,5,5,14,14,0,0,9,9,9,9,0,0,8,8,10,10,5,5,7,7,6,6,2,2,1,1,2,2,6,6,5,5,9,9,6,6,10,10,8,8,14,14,3,3,0,0,12,12,8,8,0,0,4,4,6,6,0,0,0,0,1,1,9,9,10,10,0,0,13,13,1,1,12,12,2,2,13,13,7,7,2,2,6,6,8,8,3,3,0,0,14,14,12,12,14,14,11,11,12,12,5,5,12,12,5,5,3,3,4,4,5,5,5,5,15,15,15,15,10,10,2,2,1,1,8,8,7,7,14,14,1,1,10,10,10,10,3,3,5,5,5,5,13,13,9,9,2,2,1,1,9,9,15,15,9,9,11,11,7,7,4,4,0,0,2,2,0,0,2,2,5,5,6,6,4,4,0,0,11,11,10,10,10,10,12,12,8,8,1,1,6,6,15,15,9,9,12,12,5,5,0,0,7,7,7,7,8,8,11,11,6,6,2,2,1,1,14,14,8,8,15,15,8,8,13,13,0,0,2,2,15,15,12,12,13,13,15,15,3,3,4,4,8,8,1,1,0,0,9,9,10,10,6,6,12,12,11,11,12,12,10,10,7,7,1,1,1,1,7,7,6,6,4,4,3,3,12,12,13,13,9,9,10,10,6,6,5,5,13,13,0,0,3,3,1,1,2,2,5,5,7,7,7,7,15,15,11,11,8,8,7,7,12,12,0,0,6,6,9,9,9,9,15,15,1,1,11,11,3,3,7,7,3,3,13,13,1,1,7,7,1,1,2,2,0,0,6,6,14,14,9,9,11,11,15,15,3,3,3,3,10,10,12,12,10,10,3,3,0,0,9,9,8,8,11,11,0,0,0,0,8,8,2,2,1,1,7,7,14,14,10,10,0,0,10,10,12,12,4,4,0,0,13,13,8,8,7,7,4,4,0,0,5,5,10,10,5,5,14,14,3,3,13,13,9,9,15,15,12,12,7,7,6,6,2,2,14,14,4,4,2,2,7,7,2,2,5,5,10,10,11,11,9,9,0,0,6,6,2,2,0,0,12,12,7,7,15,15,10,10,0,0,15,15,4,4,8,8,11,11,9,9,11,11,3,3,9,9,4,4,14,14,0,0,4,4,11,11,6,6,1,1,9,9,8,8,2,2,2,2,7,7,14,14,2,2,2,2,7,7,8,8,13,13,11,11,15,15,9,9,2,2,8,8,1,1,12,12,6,6,8,8,11,11,7,7,3,3,14,14,4,4,8,8,8,8,8,8,4,4,5,5,12,12,2,2,11,11,3,3,8,8,4,4,12,12,5,5,3,3,5,5,5,5,0,0,7,7,7,7,11,11,14,14,8,8,1,1,12,12,7,7,14,14,12,12,9,9,2,2,7,7,11,11,6,6,12,12,2,2,8,8,7,7,5,5,3,3,2,2,7,7,2,2,11,11,9,9,9,9,4,4,8,8,11,11,0,0,6,6,3,3,7,7,2,2,6,6,14,14,2,2,4,4,7,7,6,6,6,6,9,9,11,11,3,3,3,3,0,0,14,14,15,15,6,6,14,14,3,3,8,8,14,14,0,0,4,4,6,6,2,2,0,0,3,3,1,1,1,1,6,6,2,2,4,4,6,6,11,11,9,9,2,2,13,13,5,5,7,7,0,0,5,5,12,12,8,8,1,1,7,7,3,3,15,15,3,3,1,1,6,6,5,5,8,8,6,6,1,1,9,9,5,5,5,5,15,15,14,14,8,8,13,13,2,2,12,12,0,0,11,11,9,9,11,11,10,10,10,10,5,5,1,1,6,6,14,14,3,3,2,2,9,9,7,7,14,14,12,12,6,6,9,9,3,3,4,4,0,0,8,8,14,14,7,7,10,10,13,13,1,1,3,3,8,8,1,1,2,2,12,12,11,11,11,11,13,13,3,3,3,3,7,7,14,14,11,11,7,7,4,4,7,7,5,5,3,3,3,3,10,10,10,10,10,10,11,11,12,12,6,6,0,0,9,9,1,1,14,14,1,1,0,0,0,0,3,3,2,2,15,15,8,8,9,9,3,3,11,11,0,0,15,15,5,5,2,2,8,8,15,15,10,10,9,9,11,11,1,1,9,9,4,4,12,12,0,0,8,8,14,14,4,4,15,15,7,7,12,12,15,15,9,9,12,12,1,1,8,8,6,6,6,6,6,6,2,2,1,1,15,15,0,0,9,9,7,7,3,3,8,8,4,4,13,13,9,9,4,4,8,8,9,9,11,11,8,8,2,2,11,11,6,6,12,12,6,6,5,5,7,7,9,9,14,14,2,2,13,13,10,10,1,1,3,3,3,3,8,8,15,15,8,8,13,13,11,11,1,1,5,5,7,7,1,1,9,9,8,8,4,4,1,1,10,10,9,9,0,0,8,8,0,0,1,1,0,0,4,4,1,1,4,4,5,5,1,1,14,14,15,15,2,2,0,0,6,6,2,2,2,2,8,8,0,0,5,5,4,4,12,12,12,12,8,8,13,13,13,13,2,2,10,10,3,3,4,4,10,10,3,3,3,3,1,1,10,10,15,15,12,12,8,8,4,4,0,0,13,13,5,5,6,6,12,12,3,3,10,10,4,4,15,15,1,1,13,13,4,4,0,0,13,13,4,4,2,2,1,1,6,6,13,13,0,0,5,5,6,6,14,14,7,7,5,5,6,6,10,10,4,4,5,5,15,15,9,9,12,12,6,6,5,5,5,5,1,1,10,10,12,12,10,10,6,6,8,8,10,10,10,10,15,15,11,11,5,5,8,8,14,14,4,4,9,9,6,6,4,4,3,3,5,5,14,14,7,7,1,1,10,10,9,9,14,14,0,0,8,8,0,0,2,2,14,14,6,6,9,9,6,6,3,3,2,2,7,7,5,5,12,12,8,8,15,15,12,12,4,4,15,15,3,3,0,0,3,3,8,8,15,15,12,12,13,13,2,2,0,0,0,0,1,1,12,12,1,1,8,8,0,0,3,3,8,8,11,11,13,13,11,11,15,15,9,9,0,0,15,15,10,10,1,1,14,14,6,6,2,2,10,10,7,7,6,6,9,9,4,4,0,0,2,2,9,9,8,8,14,14,12,12,13,13,8,8,2,2,2,2,2,2,9,9,4,4,2,2,15,15,1,1,8,8,13,13,2,2,15,15,1,1,0,0,5,5,1,1,15,15,5,5,13,13,7,7,14,14,2,2,6,6,13,13,0,0,9,9,4,4,15,15,2,2,0,0,9,9,13,13,8,8,4,4,1,1,14,14,14,14,15,15,6,6,1,1,3,3,5,5,1,1,12,12,10,10,5,5,5,5,4,4,0,0,2,2,12,12,11,11,9,9,10,10,5,5,13,13,0,0,5,5,13,13,2,2,10,10,5,5,14,14,14,14,5,5,3,3,7,7,1,1,14,14,14,14,8,8,4,4,9,9,0,0,8,8,9,9,6,6,9,9,15,15,2,2,5,5,3,3,10,10,9,9,6,6,9,9,11,11,3,3,5,5,6,6,10,10,0,0,11,11,2,2,13,13,15,15,2,2,13,13,13,13,8,8,11,11,15,15,13,13,3,3,14,14,3,3,9,9,5,5,5,5,6,6,11,11,9,9,7,7,8,8,13,13,4,4,6,6,7,7,14,14,7,7,8,8,14,14,9,9,10,10,0,0,12,12,11,11,14,14,0,0,13,13,9,9,7,7,5,5,8,8,6,6,6,6,1,1,3,3,7,7,5,5,8,8,9,9,2,2,12,12,6,6,0,0,7,7,7,7,0,0,8,8,9,9,13,13,12,12,12,12,4,4,12,12,12,12,10,10,2,2,0,0,0,0,5,5,10,10,6,6,10,10,13,13,5,5,14,14,15,15,9,9,15,15,8,8,13,13,4,4,11,11,7,7,8,8,7,7,7,7,12,12,10,10,13,13,7,7,11,11,8,8,12,12,9,9,12,12,14,14,6,6,2,2,3,3,4,4,11,11,11,11,5,5,8,8,8,8,13,13,6,6,13,13,11,11,5,5,2,2,5,5,9,9,5,5,10,10,2,2,10,10,9,9,3,3,2,2,13,13,10,10,7,7,9,9,2,2,6,6,1,1,12,12,3,3,3,3,12,12,15,15,1,1,7,7,9,9,6,6,14,14,3,3,9,9,2,2,4,4,14,14,14,14,1,1,5,5,0,0,8,8,5,5,5,5,7,7,7,7,11,11,9,9,1,1,6,6,7,7,7,7,13,13,11,11,5,5,7,7,10,10,8,8,15,15,5,5,0,0,13,13,4,4,11,11,5,5,11,11,9,9,13,13,4,4,4,4,14,14,1,1,7,7,15,15,12,12,2,2,8,8,9,9,5,5,5,5,14,14,8,8,1,1,7,7,13,13,14,14,8,8,13,13,10,10,10,10,5,5,5,5,10,10,0,0,6,6,1,1,1,1,10,10,6,6,5,5,5,5,8,8,9,9,5,5,15,15,11,11,2,2,13,13,2,2,1,1,0,0,9,9,4,4,6,6,0,0,6,6,15,15,11,11,12,12,5,5,13,13,12,12,10,10,5,5,6,6,7,7,12,12,11,11,12,12,3,3,1,1,7,7,8,8,5,5,2,2,7,7,2,2,15,15,5,5,4,4,9,9,13,13,6,6,0,0,7,7,5,5,6,6,5,5,15,15,1,1,10,10,9,9,12,12,14,14,4,4,11,11,11,11,6,6,7,7,15,15,13,13,7,7,2,2,3,3,12,12,5,5,8,8,9,9,0,0,11,11,11,11,8,8,8,8,4,4,11,11,8,8,15,15,12,12,13,13,0,0,0,0,3,3,5,5,10,10,0,0,1,1,4,4,8,8,8,8,8,8,2,2,5,5,3,3,11,11,13,13,8,8,12,12,2,2,13,13,1,1,9,9,1,1,6,6,13,13,14,14,1,1,9,9,9,9,5,5,10,10,4,4,1,1,8,8,3,3,0,0,0,0,5,5,5,5,1,1,14,14,3,3,0,0,2,2,14,14,12,12,15,15,9,9,13,13,14,14,4,4,1,1,5,5,9,9,8,8,12,12,1,1,3,3,9,9,13,13,8,8,13,13,2,2,3,3,8,8,15,15,6,6,7,7,7,7,15,15,0,0,13,13,11,11,0,0,5,5,8,8,11,11,15,15,3,3,14,14,2,2,4,4,3,3,5,5,4,4,6,6,11,11,10,10,0,0,5,5,10,10,5,5,10,10,7,7,1,1,8,8,1,1,8,8,15,15,12,12,5,5,1,1,6,6,0,0,0,0,12,12,0,0,10,10,14,14,0,0,12,12,8,8,8,8,9,9,6,6,8,8,9,9,5,5,3,3,13,13,6,6,14,14,4,4,10,10,2,2,7,7,3,3,2,2,12,12,5,5,2,2,3,3,12,12,8,8,7,7,13,13,5,5,11,11,7,7,6,6,3,3,5,5,1,1,1,1,5,5,10,10,8,8,7,7,9,9,0,0,14,14,5,5,4,4,3,3,15,15,15,15,9,9,10,10,8,8,6,6,12,12,5,5,15,15,12,12,2,2,7,7,7,7,3,3,1,1,0,0,15,15,9,9,8,8,3,3,12,12,5,5,9,9,2,2,10,10,6,6,0,0,13,13,2,2,15,15,7,7,14,14,4,4,3,3,0,0,9,9,9,9,11,11,4,4,0,0,11,11,15,15,2,2,0,0,6,6,5,5,10,10,7,7,12,12,8,8,4,4,0,0,14,14,0,0,6,6,3,3,2,2,10,10,14,14,9,9,13,13,14,14,2,2,4,4,6,6,9,9,8,8,13,13,13,13,4,4,6,6,3,3,13,13,11,11,6,6,2,2,12,12,4,4,5,5,14,14,9,9,13,13,4,4,1,1,15,15,12,12,12,12,0,0,8,8,8,8,2,2,5,5,1,1,9,9,9,9,2,2,10,10,3,3,4,4,11,11,15,15,10,10,1,1,9,9,1,1,8,8,3,3,12,12,2,2,13,13,5,5,14,14,13,13,0,0,3,3,0,0,0,0,4,4,0,0,1,1,1,1,7,7,8,8,8,8,4,4,0,0,14,14,4,4,7,7,13,13,8,8,1,1,9,9,4,4,15,15,13,13,1,1,11,11,12,12,7,7,3,3,2,2,13,13,10,10,3,3,7,7,7,7,9,9,11,11,15,15,11,11,11,11,7,7,7,7,3,3,4,4,9,9,0,0,4,4,10,10,5,5,7,7,14,14,3,3,5,5,4,4,13,13,5,5,9,9,0,0,6,6,4,4,3,3,1,1,15,15,3,3,12,12,6,6,0,0,2,2,11,11,2,2,4,4,13,13,14,14,9,9,10,10,7,7,6,6,11,11,7,7,4,4,8,8,5,5,8,8,3,3,6,6,11,11,12,12,11,11,1,1,2,2,13,13,1,1,5,5,6,6,13,13,9,9,6,6,2,2,11,11,6,6,9,9,1,1,15,15,12,12,1,1,12,12,6,6,1,1,0,0,5,5,3,3,2,2,7,7,4,4,5,5,13,13,7,7,12,12,1,1,8,8,5,5,2,2,13,13,6,6,15,15,14,14,8,8,8,8,10,10,5,5,13,13,7,7,12,12,10,10,5,5,11,11,9,9,7,7,6,6,12,12,13,13,15,15,7,7,9,9,1,1,15,15,9,9,2,2,8,8,4,4,9,9,11,11,8,8,1,1,10,10,12,12,14,14,14,14,0,0,2,2,1,1,15,15,0,0,2,2,9,9,1,1,1,1,3,3,6,6,1,1,11,11,9,9,9,9,3,3,14,14,10,10,13,13,9,9,0,0,7,7,12,12,4,4,5,5,11,11,9,9,12,12,9,9,11,11,12,12,0,0,15,15,15,15,8,8,13,13,4,4,5,5,1,1,6,6,3,3,14,14,11,11,3,3,5,5,0,0,11,11,1,1,6,6,7,7,3,3,2,2,10,10,15,15,5,5,0,0,4,4,8,8,8,8,6,6,0,0,9,9,13,13,3,3,12,12,5,5,0,0,4,4,7,7,7,7,4,4,13,13,0,0,6,6,12,12,0,0,10,10,0,0,0,0,2,2,0,0,13,13,0,0,1,1,8,8,11,11,8,8,10,10,10,10,1,1,11,11,8,8,4,4,15,15,14,14,1,1,6,6,14,14,7,7,15,15,11,11,2,2,2,2,12,12,8,8,13,13,4,4,0,0,10,10,13,13,4,4,0,0,4,4,12,12,8,8,9,9,10,10,7,7,8,8,7,7,8,8,9,9,8,8,15,15,0,0,3,3,4,4,0,0,7,7,8,8,12,12,4,4,9,9,13,13,0,0,12,12,0,0,4,4,1,1,8,8,8,8,5,5,6,6,11,11,4,4,4,4,5,5,0,0,2,2,6,6,11,11,0,0,0,0,6,6,4,4,0,0,0,0,2,2,2,2,15,15,1,1,1,1,15,15,11,11,13,13,8,8,9,9,11,11,10,10,13,13,6,6,6,6,11,11,2,2,7,7,0,0,15,15,0,0,5,5,7,7,7,7,0,0,8,8,3,3,0,0,4,4,12,12,13,13,14,14,4,4,1,1,12,12,9,9,4,4,2,2,10,10,2,2,10,10,6,6,8,8,12,12,2,2,0,0,0,0,15,15,2,2,6,6,7,7,6,6,8,8,14,14,5,5,7,7,11,11,6,6,4,4,10,10,4,4,11,11,8,8,15,15,5,5,0,0,3,3,12,12,9,9,1,1,2,2,14,14,10,10,15,15,9,9,3,3,14,14,4,4,6,6,14,14,10,10,8,8,9,9,0,0,10,10,0,0,1,1,15,15,14,14,5,5,13,13,11,11,15,15,12,12,3,3,8,8,11,11,3,3,15,15,0,0,7,7,13,13,14,14,13,13,5,5,9,9,8,8,12,12,15,15,11,11,6,6,8,8,7,7,4,4,0,0,0,0,11,11,4,4,8,8,12,12,4,4,8,8,15,15,14,14,14,14,5,5,9,9,12,12,14,14,1,1,12,12,13,13,0,0,4,4,7,7,15,15,6,6,8,8,7,7,1,1,5,5,3,3,12,12,2,2,4,4,15,15,6,6,1,1,7,7,3,3,3,3,2,2,8,8,4,4,7,7,6,6,14,14,5,5,15,15,14,14,11,11,2,2,1,1,13,13,14,14,0,0,12,12,7,7,11,11,2,2,15,15,9,9,7,7,15,15,3,3,6,6,9,9,4,4,15,15,1,1,14,14,4,4,14,14,12,12,5,5,14,14,5,5,15,15,10,10,8,8,1,1,10,10,9,9,3,3,13,13,2,2,10,10,4,4,8,8,2,2,13,13,12,12,10,10,15,15,13,13,10,10,10,10,1,1,4,4,0,0,12,12,9,9,12,12,12,12,5,5,9,9,1,1,10,10,15,15,12,12,7,7,3,3,9,9,15,15,10,10,6,6,13,13,7,7,5,5,13,13,5,5,11,11,6,6,7,7,12,12,7,7,9,9,4,4,1,1,15,15,13,13,13,13,12,12,15,15,12,12,9,9,10,10,7,7,10,10,7,7,14,14,13,13,2,2,8,8,13,13,13,13,0,0,10,10,7,7,12,12,2,2,15,15,15,15,6,6,0,0,14,14,6,6,4,4,8,8,7,7,13,13,6,6,2,2,13,13,12,12,15,15,12,12,11,11,1,1,7,7,14,14,9,9,14,14,9,9,14,14,7,7,9,9,11,11,13,13,8,8,4,4,6,6,4,4,15,15,11,11,5,5,6,6,13,13,2,2,7,7,0,0,7,7,0,0,4,4,7,7,3,3,6,6,7,7,14,14,12,12,14,14,5,5,0,0,9,9,2,2,15,15,7,7,9,9,4,4,6,6,9,9,3,3,14,14,12,12,11,11,9,9,0,0,15,15,4,4,2,2,4,4,11,11,11,11,3,3,4,4,8,8,8,8,5,5,14,14,1,1,10,10,1,1,10,10,6,6,2,2,13,13,11,11,0,0,6,6,13,13,8,8,14,14,5,5,2,2,12,12,11,11,6,6,4,4,0,0,9,9,0,0,15,15,5,5,11,11,8,8,15,15,6,6,6,6,12,12,0,0,15,15,12,12,5,5,0,0,9,9,3,3,13,13,1,1,2,2,4,4,13,13,2,2,3,3,12,12,3,3,6,6,3,3,12,12,10,10,8,8,1,1,15,15,0,0,6,6,3,3,7,7,6,6,7,7,5,5,6,6,8,8,4,4,12,12,1,1,14,14,12,12,8,8,12,12,12,12,0,0,6,6,11,11,15,15,9,9,15,15,0,0,7,7,3,3,9,9,11,11,1,1,2,2,1,1,12,12,9,9,14,14,6,6,9,9,2,2,15,15,5,5,10,10,0,0,8,8,8,8,8,8,5,5,11,11,0,0,6,6,14,14,5,5,2,2,2,2,10,10,3,3,5,5,15,15,6,6,3,3,4,4,7,7,0,0,12,12,6,6,3,3,5,5,0,0,0,0,5,5,8,8,3,3,2,2,14,14,9,9,6,6,12,12,1,1,7,7,8,8,10,10,14,14,2,2,2,2,12,12,14,14,3,3,4,4,12,12,3,3,0,0,10,10,8,8,10,10,13,13,6,6,6,6,3,3,2,2,4,4,11,11,3,3,6,6,1,1,8,8,9,9,5,5,9,9,7,7,12,12,7,7,7,7,7,7,4,4,5,5,15,15,1,1,9,9,2,2,4,4,7,7,4,4,1,1,10,10,15,15,6,6,4,4,9,9,9,9,9,9,3,3,13,13,15,15,11,11,10,10,12,12,0,0,14,14,7,7,13,13,3,3,13,13,5,5,1,1,11,11,8,8,4,4,15,15,6,6,14,14,12,12,10,10,5,5,10,10,3,3,1,1,14,14,1,1,10,10,11,11,14,14,1,1,11,11,8,8,6,6,0,0,8,8,3,3,6,6,14,14,11,11,14,14,15,15,5,5,0,0,2,2,8,8,11,11,10,10,15,15,3,3,15,15,14,14,10,10,9,9,8,8,8,8,6,6,0,0,3,3,0,0,12,12,3,3,1,1,0,0,7,7,10,10,9,9,8,8,1,1,1,1,2,2,8,8,15,15,12,12,5,5,0,0,5,5,2,2,8,8,0,0,14,14,0,0,12,12,14,14,11,11,11,11,5,5,5,5,3,3,2,2,2,2,10,10,11,11,8,8,15,15,2,2,4,4,15,15,6,6,7,7,7,7,9,9,2,2,4,4,8,8,9,9,14,14,4,4,1,1,12,12,12,12,0,0,3,3,12,12,7,7,14,14,12,12,3,3,6,6,2,2,0,0,11,11,3,3,4,4,3,3,12,12,15,15,7,7,8,8,6,6,2,2,15,15,8,8,8,8,14,14,9,9,6,6,6,6,6,6,10,10,13,13,15,15,13,13,6,6,8,8,2,2,14,14,5,5,11,11,7,7,5,5,4,4,7,7,15,15,0,0,8,8,12,12,12,12,9,9,0,0,7,7,0,0,5,5,7,7,9,9,8,8,7,7,5,5,9,9,9,9,10,10,3,3,12,12,1,1,5,5,3,3,11,11,8,8,10,10,6,6,11,11,5,5,1,1,0,0,9,9,15,15,6,6,0,0,8,8,12,12,1,1,1,1,7,7,11,11,9,9,13,13,1,1,8,8,14,14,6,6,5,5,8,8,13,13,13,13,0,0,11,11,8,8,7,7,12,12,4,4,5,5,8,8,10,10,13,13,5,5,1,1,10,10,5,5,11,11,1,1,8,8,13,13,13,13,4,4,1,1,9,9,0,0,3,3,7,7,12,12,8,8,2,2,5,5,13,13,4,4,15,15,7,7,4,4,6,6,4,4,8,8,13,13,6,6,11,11,5,5,14,14,5,5,8,8,3,3,2,2,6,6,9,9,12,12,10,10,13,13,9,9,8,8,11,11,14,14,13,13,9,9,13,13,11,11,8,8,6,6,2,2,8,8,2,2,13,13,12,12,9,9,3,3,15,15,2,2,13,13,4,4,2,2,11,11,14,14,1,1,14,14,1,1,15,15,3,3,11,11,14,14,13,13,7,7,3,3,9,9,9,9,3,3,1,1,8,8,13,13,9,9,2,2,4,4,0,0,13,13,1,1,7,7,7,7,1,1,5,5,5,5,8,8,9,9,6,6,7,7,5,5,9,9,13,13,4,4,6,6,10,10,13,13,8,8,5,5,1,1,3,3,2,2,13,13,1,1,3,3,1,1,12,12,2,2,9,9,14,14,12,12,13,13,11,11,14,14,8,8,10,10,7,7,9,9,0,0,1,1,11,11,2,2,14,14,4,4,2,2,4,4,3,3,11,11,4,4,4,4,15,15,13,13,6,6,1,1,12,12,8,8,10,10,12,12,13,13,12,12,4,4,14,14,15,15,9,9,6,6,0,0,0,0,5,5,1,1,2,2,10,10,9,9,1,1,9,9,5,5,11,11,13,13,4,4,10,10,10,10,2,2,13,13,7,7,4,4,3,3,9,9,12,12,1,1,6,6,8,8,2,2,0,0,9,9,7,7,3,3,3,3,15,15,10,10,7,7,13,13,3,3,15,15,2,2,12,12,14,14,8,8,9,9,6,6,3,3,15,15,11,11,8,8,13,13,2,2,12,12,5,5,11,11,5,5,8,8,6,6,8,8,13,13,15,15,12,12,5,5,0,0,11,11,11,11,9,9,2,2,15,15,14,14,8,8,10,10,13,13,2,2,6,6,12,12,8,8,14,14,5,5,5,5,9,9,15,15,6,6,10,10,3,3,9,9,7,7,3,3,0,0,6,6,15,15,13,13,5,5,12,12,2,2,3,3,12,12,3,3,2,2,8,8,13,13,10,10,11,11,2,2,1,1,12,12,6,6,12,12,15,15,0,0,9,9,13,13,4,4,1,1,8,8,2,2,14,14,13,13,5,5,14,14,9,9,12,12,2,2,1,1,6,6,1,1,1,1,5,5,15,15,13,13,5,5,4,4,0,0,9,9,13,13,6,6,9,9,15,15,7,7,1,1,9,9,3,3,9,9,0,0,13,13,5,5,14,14,15,15,5,5,1,1,13,13,0,0,1,1,2,2,13,13,5,5,4,4,4,4,7,7,4,4,6,6,6,6,0,0,15,15,1,1,7,7,10,10,0,0,12,12,8,8,11,11,0,0,4,4,3,3,3,3,11,11,13,13,8,8,7,7,8,8,6,6,9,9,10,10,0,0,0,0,15,15,5,5,1,1,12,12,8,8,4,4,8,8,1,1,1,1,6,6,2,2,3,3,9,9,0,0,2,2,14,14,2,2,1,1,5,5,11,11,4,4,6,6,6,6,8,8,6,6,1,1,2,2,4,4,5,5,1,1,11,11,15,15,2,2,4,4,6,6,11,11,15,15,1,1,3,3,8,8,8,8,4,4,15,15,7,7,2,2,12,12,5,5,15,15,10,10,3,3,8,8,11,11,3,3,11,11,9,9,2,2,3,3,9,9,14,14,7,7,9,9,15,15,8,8,7,7,13,13,8,8,13,13,5,5,13,13,2,2,3,3,13,13,10,10,2,2,15,15,0,0,6,6,13,13,5,5,11,11,8,8,8,8,12,12,14,14,14,14,15,15,1,1,0,0,2,2,4,4,0,0,14,14,10,10,8,8,7,7,2,2,7,7,3,3,5,5,13,13,15,15,9,9,9,9,9,9,10,10,4,4,2,2,0,0,4,4,4,4,4,4,15,15,8,8,12,12,5,5,15,15,4,4,11,11,7,7,6,6,7,7,15,15,3,3,9,9,0,0,8,8,7,7,9,9,5,5,8,8,0,0,7,7,10,10,3,3,3,3,14,14,7,7,2,2,15,15,1,1,4,4,12,12,4,4,8,8,12,12,2,2,5,5,10,10,0,0,3,3,7,7,3,3,1,1,7,7,6,6,3,3,15,15,10,10,8,8,3,3,12,12,12,12,13,13,3,3,6,6,8,8,7,7,4,4,11,11,3,3,9,9,2,2,8,8,2,2,12,12,8,8,15,15,3,3,9,9,2,2,11,11,12,12,6,6,5,5,7,7,14,14,10,10,4,4,5,5,4,4,7,7,4,4,12,12,7,7,9,9,13,13,4,4,8,8,8,8,11,11,0,0,14,14,10,10,2,2,8,8,4,4,5,5,4,4,5,5,5,5,6,6,3,3,10,10,10,10,8,8,8,8,13,13,2,2,2,2,3,3,7,7,5,5,12,12,8,8,13,13,2,2,12,12,14,14,11,11,7,7,4,4,1,1,2,2,7,7,10,10,13,13,14,14,13,13,7,7,14,14,0,0,9,9,13,13,7,7,12,12,2,2,7,7,4,4,9,9,0,0,5,5,12,12,7,7,2,2,13,13,3,3,8,8,3,3,3,3,5,5,9,9,5,5,10,10,11,11,12,12,10,10,0,0,2,2,9,9,9,9,11,11,5,5,5,5,7,7,12,12,5,5,4,4,3,3,5,5,7,7,9,9,4,4,10,10,5,5,14,14,2,2,2,2,1,1,2,2,5,5,5,5,10,10,6,6,0,0,15,15,10,10,8,8,15,15,0,0,3,3,0,0,14,14,2,2,5,5,0,0,13,13,11,11,5,5,10,10,14,14,15,15,8,8,13,13,14,14,9,9,1,1,15,15,5,5,3,3,3,3,1,1,1,1,5,5,5,5,4,4,6,6,14,14,7,7,15,15,5,5,2,2,7,7,3,3,15,15,14,14,14,14,12,12,11,11,2,2,15,15,8,8,4,4,6,6,15,15,2,2,4,4,12,12,5,5,1,1,8,8,4,4,10,10,3,3,12,12,1,1,0,0,7,7,4,4,6,6,9,9,8,8,2,2,0,0,9,9,4,4,13,13,10,10,4,4,0,0,6,6,15,15,1,1,8,8,3,3,10,10,4,4,10,10,3,3,4,4,8,8,10,10,2,2,8,8,14,14,8,8,5,5,15,15,5,5,6,6,7,7,10,10,3,3,15,15,2,2,14,14,10,10,0,0,1,1,7,7,11,11,4,4,8,8,13,13,15,15,15,15,10,10,8,8,14,14,1,1,15,15,11,11,12,12,1,1,13,13,4,4,5,5,14,14,0,0,2,2,11,11,3,3,9,9,8,8,0,0,0,0,7,7,15,15,9,9,6,6,1,1,0,0,5,5,11,11,6,6,14,14,9,9,10,10,4,4,7,7,10,10,1,1,7,7,3,3,3,3,12,12,4,4,8,8,5,5,4,4,2,2,11,11,14,14,12,12,0,0,9,9,5,5,2,2,12,12,10,10,1,1,14,14,3,3,5,5,4,4,2,2,15,15,6,6,14,14,1,1,15,15,7,7,2,2,5,5,15,15,1,1,0,0,8,8,10,10,13,13,6,6,7,7,10,10,4,4,4,4,10,10,13,13,11,11,14,14,7,7,11,11,8,8,7,7,3,3,7,7,1,1,10,10,8,8,5,5,13,13,2,2,14,14,0,0,10,10,10,10,12,12,2,2,4,4,7,7,2,2,2,2,0,0,10,10,10,10,2,2,0,0,8,8,4,4,4,4,0,0,7,7,6,6,3,3,1,1,0,0,9,9,4,4,1,1,4,4,14,14,7,7,12,12,10,10,1,1,8,8,2,2,10,10,8,8,2,2,0,0,11,11,6,6,2,2,7,7,11,11,4,4,8,8,8,8,3,3,6,6,9,9,5,5,12,12,12,12,7,7,6,6,13,13,4,4,11,11,5,5,7,7,3,3,0,0,5,5,3,3,7,7,1,1,3,3,2,2,14,14,8,8,6,6,12,12,14,14,7,7,8,8,0,0,11,11,10,10,9,9,14,14,8,8,0,0,6,6,1,1,3,3,8,8,0,0,2,2,9,9,12,12,7,7,0,0,5,5,2,2,7,7,9,9,12,12,1,1,2,2,4,4,1,1,0,0,11,11,7,7,4,4,0,0,4,4,7,7,2,2,11,11,6,6,11,11,3,3,11,11,3,3,3,3,9,9,4,4,15,15,5,5,7,7,2,2,11,11,14,14,4,4,5,5,4,4,12,12,15,15,7,7,1,1,7,7,13,13,14,14,0,0,10,10,1,1,14,14,1,1,1,1,13,13,2,2,11,11,8,8,0,0,9,9,14,14,10,10,12,12,9,9,7,7,3,3,5,5,12,12,1,1,15,15,0,0,9,9,0,0,4,4,2,2,8,8,1,1,8,8,2,2,12,12,1,1,1,1,14,14,14,14,9,9,15,15,11,11,11,11,14,14,10,10,14,14,8,8,6,6,2,2,14,14,14,14,1,1,6,6,0,0,11,11,13,13,11,11,15,15,13,13,6,6,14,14,11,11,3,3,13,13,9,9,9,9,1,1,11,11,4,4,3,3,11,11,8,8,10,10,13,13,3,3,15,15,13,13,8,8,13,13,6,6,5,5,1,1,6,6,5,5,15,15,9,9,12,12,5,5,13,13,8,8,8,8,11,11,10,10,15,15,12,12,5,5,2,2,3,3,3,3,6,6,6,6,7,7,0,0,4,4,9,9,6,6,6,6,15,15,13,13,13,13,1,1,7,7,11,11,8,8,13,13,12,12,1,1,4,4,7,7,7,7,10,10,8,8,14,14,4,4,7,7,0,0,7,7,11,11,15,15,1,1,2,2,4,4,4,4,7,7,7,7,12,12,0,0,1,1,5,5,7,7,11,11,11,11,9,9,13,13,11,11,5,5,11,11,9,9,15,15,12,12,14,14,2,2,1,1,7,7,9,9,10,10,2,2,6,6,5,5,3,3,7,7,3,3,3,3,14,14,6,6,5,5,1,1,1,1,6,6,5,5,5,5,6,6,13,13,12,12,10,10,10,10,0,0,15,15,5,5,15,15,3,3,7,7,7,7,3,3,9,9,12,12,3,3,10,10,2,2,9,9,10,10,3,3,11,11,5,5,3,3,10,10,5,5,11,11,12,12,9,9,0,0,4,4,6,6,3,3,7,7,6,6,6,6,5,5,15,15,4,4,0,0,5,5,11,11,6,6,2,2,1,1,6,6,4,4,3,3,13,13,9,9,15,15,12,12,4,4,4,4,7,7,0,0,8,8,9,9,13,13,12,12,4,4,1,1,9,9,14,14,7,7,12,12,12,12,4,4,11,11,2,2,15,15,6,6,5,5,6,6,2,2,6,6,3,3,8,8,10,10,10,10,6,6,8,8,1,1,2,2,1,1,6,6,0,0,11,11,14,14,7,7,5,5,10,10,0,0,6,6,0,0,12,12,14,14,13,13,15,15,9,9,7,7,0,0,13,13,7,7,5,5,14,14,9,9,11,11,13,13,5,5,6,6,14,14,4,4,7,7,11,11,10,10,8,8,5,5,15,15,12,12,4,4,10,10,9,9,5,5,12,12,13,13,8,8,7,7,11,11,11,11,7,7,7,7,10,10,12,12,0,0,1,1,14,14,9,9,7,7,11,11,10,10,15,15,8,8,13,13,11,11,1,1,0,0,8,8,3,3,3,3,12,12,8,8,10,10,15,15,11,11,0,0,7,7,3,3,1,1,2,2,0,0,2,2,11,11,2,2,1,1,5,5,12,12,9,9,3,3,1,1,12,12,14,14,9,9,11,11,1,1,5,5,4,4,1,1,11,11,10,10,8,8,12,12,2,2,13,13,15,15,13,13,9,9,1,1,8,8,11,11,13,13,2,2,15,15,14,14,6,6,8,8,12,12,3,3,14,14,3,3,9,9,7,7,4,4,6,6,9,9,5,5,8,8,3,3,7,7,11,11,3,3,9,9,0,0,5,5,14,14,4,4,9,9,8,8,12,12,0,0,13,13,8,8,4,4,4,4,4,4,6,6,8,8,9,9,4,4,12,12,14,14,5,5,7,7,13,13,1,1,0,0,13,13,15,15,1,1,0,0,0,0,9,9,15,15,5,5,7,7,11,11,0,0,11,11,12,12,2,2,5,5,4,4,15,15,8,8,8,8,2,2,13,13,4,4,15,15,12,12,11,11,3,3,9,9,0,0,9,9,3,3,4,4,9,9,8,8,0,0,6,6,9,9,4,4,5,5,11,11,8,8,14,14,11,11,6,6,9,9,11,11,12,12,1,1,1,1,6,6,13,13,14,14,14,14,9,9,7,7,5,5,1,1,14,14,4,4,10,10,15,15,9,9,6,6,13,13,6,6,6,6,7,7,14,14,6,6,0,0,3,3,10,10,15,15,7,7,15,15,2,2,13,13,6,6,11,11,10,10,15,15,12,12,8,8,5,5,1,1,2,2,8,8,8,8,13,13,10,10,4,4,1,1,8,8,10,10,0,0,9,9,8,8,10,10,15,15,0,0,0,0,6,6,0,0,4,4,11,11,7,7,13,13,6,6,0,0,5,5,12,12,6,6,0,0,13,13,5,5,0,0,15,15,6,6,11,11,0,0,13,13,11,11,6,6,1,1,3,3,12,12,9,9,1,1,10,10,4,4,2,2,1,1,9,9,3,3,6,6,7,7,13,13,6,6,14,14,0,0,14,14,4,4,12,12,13,13,0,0,7,7,8,8,10,10,0,0,3,3,11,11,1,1,4,4,12,12,2,2,1,1,8,8,5,5,8,8,2,2,3,3,14,14,12,12,12,12,6,6,1,1,12,12,0,0,2,2,14,14,0,0,8,8,4,4,14,14,4,4,14,14,13,13,3,3,7,7,0,0,12,12,13,13,12,12,9,9,14,14,3,3,9,9,1,1,8,8,12,12,0,0,13,13,1,1,5,5,13,13,10,10,9,9,11,11,5,5,13,13,1,1,0,0,10,10,2,2,7,7,12,12,6,6,11,11,1,1,1,1,13,13,9,9,7,7,15,15,1,1,7,7,3,3,6,6,4,4,11,11,4,4,8,8,11,11,2,2,7,7,14,14,3,3,12,12,4,4,1,1,14,14,11,11,4,4,1,1,15,15,14,14,6,6,10,10,6,6,8,8,9,9,0,0,10,10,8,8,15,15,8,8,6,6,2,2,4,4,9,9,3,3,4,4,0,0,14,14,9,9,9,9,13,13,8,8,1,1,0,0,0,0,3,3,4,4,9,9,12,12,2,2,9,9,9,9,6,6,0,0,2,2,9,9,14,14,0,0,4,4,13,13,0,0,0,0,1,1,5,5,14,14,13,13,0,0,5,5,12,12,5,5,1,1,14,14,0,0,2,2,4,4,4,4,3,3,9,9,0,0,3,3,10,10,12,12,1,1,0,0,11,11,8,8,8,8,13,13,1,1,2,2,5,5,11,11,5,5,5,5,3,3,6,6,7,7,10,10,3,3,8,8,4,4,5,5,7,7,3,3,13,13,3,3,3,3,2,2,12,12,10,10,0,0,12,12,11,11,15,15,4,4,0,0,8,8,4,4,4,4,3,3,7,7,9,9,5,5,6,6,10,10,14,14,2,2,2,2,6,6,15,15,1,1,5,5,4,4,7,7,13,13,5,5,4,4,9,9,10,10,1,1,3,3,10,10,0,0,12,12,1,1,2,2,4,4,14,14,14,14,0,0,10,10,8,8,10,10,11,11,6,6,8,8,5,5,3,3,14,14,0,0,5,5,6,6,1,1,0,0,4,4,13,13,6,6,15,15,14,14,9,9,1,1,5,5,8,8,1,1,12,12,10,10,6,6,8,8,9,9,12,12,2,2,0,0,2,2,1,1,10,10,6,6,14,14,14,14,1,1,2,2,3,3,9,9,1,1,13,13,7,7,4,4,12,12,15,15,15,15,1,1,6,6,5,5,4,4,0,0,9,9,14,14,4,4,0,0,3,3,11,11,2,2,14,14,5,5,11,11,11,11,10,10,9,9,4,4,10,10,2,2,9,9,8,8,15,15,7,7,2,2,14,14,1,1,2,2,1,1,6,6,7,7,14,14,12,12,1,1,15,15,10,10,10,10,10,10,2,2,15,15,5,5,15,15,10,10,9,9,13,13,13,13,13,13,6,6,7,7,8,8,1,1,2,2,4,4,4,4,6,6,1,1,0,0,14,14,11,11,12,12,1,1,3,3,0,0,6,6,8,8,2,2,8,8,13,13,5,5,9,9,6,6,12,12,2,2,14,14,5,5,2,2,5,5,3,3,10,10,2,2,13,13,10,10,0,0,1,1,5,5,12,12,13,13,8,8,8,8,0,0,14,14,12,12,4,4,3,3,3,3,4,4,12,12,10,10,14,14,2,2,6,6,0,0,4,4,1,1,4,4,14,14,13,13,4,4,4,4,15,15,0,0,3,3,1,1,3,3,3,3,4,4,6,6,5,5,13,13,3,3,10,10,0,0,15,15,3,3,0,0,7,7,2,2,6,6,7,7,11,11,7,7,15,15,12,12,4,4,1,1,13,13,15,15,4,4,8,8,4,4,4,4,0,0,10,10,7,7,1,1,2,2,14,14,15,15,9,9,2,2,0,0,13,13,15,15,11,11,0,0,12,12,8,8,0,0,5,5,5,5,0,0,13,13,1,1,1,1,0,0,12,12,5,5,10,10,1,1,15,15,6,6,0,0,4,4,2,2,6,6,15,15,11,11,2,2,2,2,10,10,8,8,4,4,11,11,9,9,12,12,1,1,4,4,7,7,8,8,4,4,1,1,14,14,2,2,15,15,3,3,9,9,8,8,10,10,3,3,12,12,5,5,15,15,11,11,8,8,9,9,13,13,13,13,12,12,9,9,4,4,12,12,15,15,15,15,6,6,11,11,8,8,14,14,15,15,13,13,0,0,15,15,0,0,6,6,11,11,3,3,0,0,3,3,4,4,4,4,6,6,3,3,1,1,1,1,0,0,13,13,15,15,5,5,14,14,13,13,10,10,10,10,1,1,4,4,4,4,0,0,8,8,12,12,14,14,2,2,1,1,4,4,11,11,15,15,4,4,6,6,15,15,0,0,12,12,7,7,3,3,11,11,4,4,12,12,0,0,11,11,11,11,14,14,6,6,6,6,5,5,5,5,8,8,8,8,0,0,5,5,7,7,1,1,9,9,4,4,1,1,10,10,5,5,9,9,6,6,3,3,4,4,12,12,0,0,1,1,11,11,3,3,3,3,0,0,7,7,4,4,10,10,3,3,0,0,7,7,9,9,12,12,3,3,14,14,1,1,8,8,8,8,4,4,7,7,12,12,2,2,1,1,4,4,2,2,9,9,5,5,11,11,7,7,5,5,13,13,5,5,4,4,9,9,10,10,15,15,8,8,3,3,4,4,1,1,10,10,8,8,5,5,5,5,4,4,14,14,14,14,1,1,8,8,2,2,8,8,11,11,12,12,11,11,0,0,15,15,2,2,1,1,10,10,4,4,14,14,7,7,11,11,2,2,6,6,1,1,7,7,6,6,6,6,7,7,7,7,5,5,12,12,12,12,1,1,11,11,13,13,3,3,7,7,11,11,1,1,5,5,6,6,11,11,12,12,13,13,1,1,13,13,11,11,10,10,7,7,8,8,15,15,0,0,7,7,5,5,15,15,12,12,2,2,3,3,13,13,9,9,9,9,15,15,9,9,4,4,2,2,14,14,8,8,10,10,3,3,11,11,4,4,2,2,7,7,8,8,8,8,12,12,8,8,14,14,6,6,3,3,12,12,0,0,9,9,11,11,10,10,8,8,11,11,10,10,8,8,10,10,6,6,1,1,9,9,12,12,7,7,14,14,10,10,10,10,10,10,11,11,6,6,4,4,5,5,5,5,6,6,1,1,7,7,8,8,4,4,15,15,0,0,12,12,12,12,2,2,5,5,8,8,15,15,11,11,14,14,4,4,0,0,12,12,3,3,15,15,15,15,3,3,9,9,1,1,8,8,7,7,15,15,0,0,13,13,11,11,0,0,3,3,12,12,6,6,8,8,9,9,8,8,6,6,4,4,7,7,4,4,14,14,13,13,10,10,10,10,3,3,7,7,0,0,7,7,8,8,14,14,7,7,5,5,6,6,3,3,3,3,0,0,6,6,8,8,12,12,2,2,12,12,1,1,11,11,3,3,8,8,3,3,1,1,2,2,0,0,8,8,9,9,1,1,4,4,4,4,2,2,2,2,2,2,15,15,7,7,2,2,4,4,8,8,10,10,0,0,7,7,7,7,14,14,9,9,4,4,6,6,11,11,5,5,12,12,0,0,0,0,0,0,2,2,10,10,5,5,4,4,10,10,8,8,12,12,1,1,5,5,0,0,1,1,6,6,1,1,5,5,7,7,13,13,4,4,7,7,5,5,11,11,9,9,14,14,6,6,8,8,8,8,0,0,12,12,1,1,5,5,11,11,11,11,4,4,6,6,0,0,6,6,14,14,8,8,1,1,13,13,7,7,5,5,10,10,15,15,7,7,5,5,5,5,15,15,8,8,14,14,13,13,14,14,10,10,7,7,15,15,6,6,3,3,1,1,0,0,6,6,0,0,13,13,3,3,4,4,0,0,15,15,3,3,15,15,6,6,15,15,5,5,4,4,11,11,1,1,14,14,4,4,11,11,15,15,3,3,8,8,14,14,10,10,0,0,0,0,10,10,7,7,3,3,6,6,1,1,6,6,11,11,12,12,4,4,5,5,0,0,14,14,6,6,6,6,12,12,13,13,14,14,3,3,2,2,9,9,15,15,11,11,4,4,4,4,3,3,2,2,13,13,5,5,1,1,2,2,6,6,0,0,13,13,15,15,13,13,6,6,3,3,4,4,7,7,10,10,3,3,12,12,15,15,13,13,8,8,3,3,12,12,10,10,9,9,12,12,15,15,5,5,0,0,6,6,0,0,9,9,11,11,11,11,8,8,4,4,11,11,5,5,8,8,5,5,11,11,10,10,9,9,8,8,13,13,14,14,1,1,10,10,1,1,14,14,15,15,7,7,2,2,12,12,13,13,8,8,4,4,8,8,2,2,7,7,3,3,12,12,7,7,13,13,2,2,1,1,10,10,7,7,11,11,14,14,4,4,9,9,10,10,5,5,4,4,3,3,9,9,3,3,12,12,12,12,4,4,2,2,9,9,8,8,12,12,6,6,7,7,7,7,1,1,15,15,14,14,15,15,9,9,12,12,3,3,3,3,10,10,6,6,6,6,13,13,13,13,1,1,1,1,5,5,3,3,3,3,13,13,6,6,11,11,0,0,0,0,14,14,11,11,12,12,4,4,0,0,3,3,1,1,10,10,2,2,4,4,1,1,10,10,12,12,2,2,11,11,2,2,15,15,8,8,8,8,2,2,15,15,1,1,0,0,8,8,2,2,0,0,9,9,6,6,12,12,2,2,14,14,10,10,2,2,15,15,1,1,7,7,8,8,12,12,4,4,11,11,14,14,8,8,6,6,1,1,11,11,10,10,14,14,4,4,15,15,11,11,6,6,11,11,2,2,3,3,12,12,0,0,10,10,13,13,9,9,6,6,11,11,5,5,13,13,0,0,2,2,5,5,8,8,8,8,5,5,2,2,10,10,1,1,9,9,8,8,15,15,5,5,14,14,2,2,14,14,9,9,6,6,4,4,13,13,15,15,4,4,7,7,8,8,8,8,12,12,0,0,2,2,6,6,14,14,0,0,7,7,11,11,7,7,14,14,15,15,15,15,2,2,8,8,1,1,10,10,7,7,10,10,10,10,0,0,7,7,5,5,12,12,8,8,8,8,2,2,11,11,8,8,0,0,7,7,2,2,8,8,7,7,3,3,3,3,7,7,12,12,3,3,5,5,12,12,10,10,10,10,11,11,8,8,8,8,12,12,2,2,3,3,13,13,10,10,1,1,6,6,2,2,0,0,1,1,4,4,1,1,12,12,10,10,10,10,12,12,14,14,14,14,5,5,13,13,2,2,9,9,4,4,8,8,12,12,7,7,12,12,9,9,12,12,6,6,13,13,9,9,10,10,6,6,3,3,12,12,15,15,3,3,11,11,0,0,2,2,11,11,14,14,2,2,8,8,14,14,7,7,1,1,0,0,9,9,1,1,15,15,8,8,0,0,0,0,4,4,9,9,8,8,1,1,9,9,6,6,7,7,5,5,3,3,12,12,9,9,12,12,9,9,14,14,3,3,11,11,1,1,2,2,13,13,11,11,8,8,6,6,5,5,4,4,9,9,2,2,2,2,13,13,2,2,2,2,10,10,6,6,12,12,10,10,9,9,7,7,7,7,8,8,15,15,11,11,10,10,11,11,6,6,13,13,15,15,0,0,0,0,0,0,10,10,14,14,4,4,0,0,9,9,5,5,0,0,7,7,8,8,5,5,11,11,9,9,9,9,12,12,3,3,14,14,1,1,14,14,2,2,14,14,9,9,2,2,7,7,9,9,8,8,5,5,10,10,2,2,14,14,11,11,6,6,7,7,5,5,15,15,3,3,9,9,8,8,9,9,6,6,6,6,13,13,10,10,15,15,0,0,11,11,15,15,2,2,5,5,10,10,3,3,0,0,12,12,2,2,13,13,8,8,10,10,6,6,11,11,14,14,4,4,1,1,2,2,5,5,5,5,4,4,10,10,7,7,0,0,15,15,7,7,13,13,1,1,15,15,11,11,11,11,4,4,13,13,3,3,6,6,4,4,12,12,9,9,7,7,12,12,5,5,4,4,4,4,8,8,2,2,4,4,0,0,5,5,14,14,2,2,6,6,11,11,3,3,14,14,14,14,6,6,3,3,2,2,11,11,6,6,3,3,0,0,11,11,3,3,6,6,4,4,1,1,5,5,0,0,12,12,3,3,15,15,4,4,0,0,6,6,12,12,11,11,1,1,1,1,7,7,6,6,14,14,14,14,15,15,12,12,12,12,0,0,1,1,5,5,7,7,11,11,5,5,12,12,4,4,15,15,11,11,1,1,6,6,4,4,1,1,2,2,1,1,4,4,1,1,13,13,4,4,2,2,14,14,4,4,7,7,3,3,1,1,11,11,15,15,1,1,10,10,7,7,0,0,7,7,0,0,3,3,9,9,9,9,5,5,14,14,15,15,5,5,10,10,10,10,0,0,9,9,0,0,0,0,12,12,2,2,0,0,0,0,2,2,9,9,13,13,2,2,11,11,10,10,11,11,14,14,0,0,4,4,5,5,4,4,14,14,5,5,12,12,14,14,11,11,6,6,3,3,0,0,4,4,9,9,7,7,1,1,0,0,4,4,8,8,10,10,11,11,0,0,6,6,5,5,6,6,6,6,8,8,3,3,10,10,10,10,11,11,0,0,3,3,10,10,10,10,1,1,15,15,13,13,4,4,12,12,1,1,2,2,3,3,4,4,4,4,5,5,6,6,11,11,7,7,0,0,4,4,14,14,9,9,6,6,1,1,15,15,10,10,10,10,8,8,13,13,1,1,4,4,1,1,11,11,2,2,6,6,2,2,10,10,4,4,11,11,9,9,2,2,8,8,1,1,9,9,15,15,5,5,9,9,13,13,5,5,15,15,1,1,1,1,9,9,15,15,4,4,14,14,13,13,14,14,3,3,8,8,10,10,3,3,6,6,4,4,13,13,13,13,0,0,8,8,11,11,13,13,11,11,0,0,13,13,1,1,15,15,11,11,10,10,1,1,15,15,1,1,7,7,8,8,4,4,7,7,6,6,3,3,6,6,8,8,1,1,12,12,2,2,11,11,4,4,6,6,3,3,9,9,15,15,1,1,2,2,12,12,4,4,0,0,5,5,3,3,3,3,4,4,15,15,6,6,13,13,10,10,10,10,9,9,1,1,15,15,8,8,8,8,4,4,6,6,6,6,1,1,9,9,5,5,1,1,10,10,8,8,1,1,0,0,0,0,0,0,1,1,13,13,0,0,9,9,15,15,0,0,4,4,1,1,10,10,1,1,5,5,10,10,7,7,14,14,15,15,2,2,0,0,4,4,6,6,0,0,2,2,9,9,1,1,9,9,10,10,2,2,0,0,3,3,14,14,1,1,4,4,11,11,11,11,6,6,11,11,9,9,3,3,5,5,10,10,6,6,13,13,13,13,12,12,5,5,14,14,1,1,7,7,6,6,2,2,14,14,4,4,4,4,0,0,11,11,11,11,5,5,11,11,4,4,8,8,11,11,11,11,5,5,15,15,10,10,14,14,13,13,8,8,12,12,5,5,9,9,9,9,12,12,13,13,8,8,6,6,0,0,15,15,7,7,15,15,8,8,0,0,8,8,3,3,0,0,7,7,12,12,10,10,5,5,12,12,9,9,15,15,14,14,0,0,2,2,0,0,14,14,3,3,9,9,15,15,0,0,8,8,4,4,10,10,5,5,13,13,5,5,15,15,13,13,11,11,9,9,6,6,12,12,4,4,4,4,12,12,5,5,3,3,3,3,0,0,8,8,10,10,15,15,10,10,2,2,15,15,5,5,10,10,7,7,12,12,5,5,6,6,4,4,0,0,8,8,4,4,4,4,11,11,1,1,9,9,4,4,9,9,11,11,4,4,10,10,5,5,11,11,2,2,7,7,1,1,7,7,7,7,9,9,0,0,2,2,7,7,0,0,2,2,11,11,15,15,15,15,5,5,5,5,7,7,1,1,7,7,0,0,5,5,3,3,10,10,5,5,7,7,3,3,8,8,1,1,3,3,0,0,10,10,14,14,2,2,12,12,15,15,5,5,9,9,4,4,11,11,14,14,15,15,0,0,14,14,12,12,6,6,14,14,12,12,2,2,12,12,11,11,14,14,7,7,11,11,13,13,5,5,2,2,14,14,9,9,0,0,6,6,10,10,12,12,14,14,5,5,9,9,0,0,6,6,12,12,1,1,9,9,0,0,13,13,10,10,1,1,3,3,10,10,3,3,3,3,1,1,6,6,10,10,9,9,10,10,15,15,11,11,1,1,3,3,7,7,13,13,1,1,6,6,6,6,10,10,7,7,4,4,15,15,8,8,12,12,14,14,6,6,10,10,0,0,4,4,7,7,13,13,7,7,1,1,14,14,0,0,12,12,0,0,6,6,8,8,6,6,5,5,4,4,8,8,8,8,0,0,0,0,6,6,9,9,0,0,15,15,0,0,12,12,0,0,10,10,11,11,2,2,2,2,4,4,11,11,1,1,10,10,10,10,12,12,7,7,8,8,4,4,11,11,1,1,15,15,13,13,11,11,7,7,15,15,5,5,15,15,9,9,6,6,11,11,2,2,15,15,10,10,1,1,4,4,10,10,2,2,4,4,2,2,9,9,6,6,3,3,0,0,0,0,5,5,7,7,6,6,5,5,13,13,2,2,12,12,4,4,11,11,15,15,9,9,13,13,12,12,5,5,12,12,5,5,15,15,15,15,0,0,1,1,7,7,15,15,6,6,1,1,10,10,9,9,7,7,1,1,3,3,9,9,14,14,0,0,2,2,6,6,11,11,5,5,2,2,15,15,2,2,15,15,0,0,5,5,3,3,14,14,5,5,11,11,13,13,2,2,1,1,10,10,1,1,7,7,1,1,6,6,10,10,8,8,6,6,9,9,12,12,8,8,3,3,10,10,8,8,1,1,9,9,3,3,11,11,14,14,3,3,8,8,0,0,15,15,5,5,3,3,8,8,8,8,13,13,0,0,9,9,13,13,4,4,1,1,6,6,2,2,14,14,1,1,3,3,10,10,5,5,1,1,10,10,8,8,12,12,5,5,3,3,9,9,0,0,4,4,0,0,14,14,0,0,2,2,10,10,8,8,15,15,6,6,5,5,8,8,1,1,12,12,2,2,4,4,2,2,15,15,11,11,13,13,2,2,14,14,13,13,13,13,6,6,10,10,5,5,13,13,8,8,15,15,6,6,15,15,9,9,3,3,11,11,2,2,8,8,7,7,1,1,9,9,5,5,15,15,6,6,13,13,15,15,4,4,9,9,13,13,7,7,12,12,3,3,6,6,9,9,5,5,10,10,6,6,1,1,8,8,7,7,14,14,10,10,14,14,14,14,10,10,3,3,3,3,13,13,9,9,13,13,8,8,1,1,10,10,12,12,12,12,8,8,13,13,1,1,6,6,14,14,12,12,14,14,2,2,11,11,7,7,6,6,3,3,7,7,10,10,10,10,3,3,3,3,14,14,7,7,13,13,5,5,14,14,4,4,1,1,5,5,15,15,6,6,3,3,7,7,8,8,10,10,4,4,2,2,14,14,3,3,8,8,3,3,13,13,12,12,4,4,11,11,4,4,8,8,1,1,12,12,1,1,9,9,13,13,4,4,5,5,10,10,2,2,13,13,2,2,3,3,5,5,5,5,7,7,2,2,13,13,6,6,1,1,14,14,13,13,10,10,10,10,6,6,1,1,12,12,9,9,14,14,9,9,10,10,8,8,4,4,8,8,4,4,15,15,0,0,6,6,15,15,4,4,14,14,11,11,0,0,3,3,4,4,14,14,7,7,11,11,4,4,7,7,11,11,4,4,8,8,9,9,8,8,2,2,2,2,6,6,3,3,1,1,2,2,8,8,1,1,0,0,9,9,5,5,13,13,11,11,9,9,14,14,2,2,2,2,9,9,14,14,11,11,12,12,15,15,12,12,0,0,1,1,0,0,6,6,13,13,8,8,2,2,15,15,12,12,10,10,4,4,4,4,11,11,10,10,11,11,2,2,15,15,7,7,0,0,15,15,4,4,3,3,4,4,11,11,8,8,4,4,12,12,15,15,1,1,2,2,4,4,12,12,7,7,3,3,11,11,8,8,13,13,0,0,6,6,5,5,5,5,1,1,10,10,8,8,0,0,0,0,0,0,11,11,9,9,3,3,1,1,9,9,2,2,5,5,4,4,0,0,8,8,1,1,12,12,13,13,0,0,9,9,3,3,6,6,3,3,9,9,0,0,10,10,1,1,3,3,14,14,7,7,12,12,11,11,8,8,3,3,0,0,8,8,5,5,15,15,4,4,3,3,2,2,9,9,7,7,3,3,0,0,0,0,2,2,3,3,9,9,4,4,12,12,14,14,2,2,0,0,14,14,13,13,15,15,6,6,8,8,2,2,7,7,12,12,3,3,5,5,6,6,12,12,10,10,6,6,14,14,0,0,6,6,3,3,13,13,12,12,0,0,0,0,10,10,4,4,1,1,1,1,2,2,14,14,8,8,1,1,0,0,14,14,9,9,6,6,7,7,4,4,15,15,1,1,2,2,0,0,0,0,11,11,0,0,10,10,2,2,4,4,13,13,7,7,14,14,13,13,6,6,4,4,8,8,5,5,5,5,9,9,13,13,12,12,3,3,11,11,4,4,12,12,2,2,6,6,8,8,9,9,8,8,10,10,15,15,7,7,12,12,13,13,9,9,3,3,5,5,11,11,3,3,8,8,0,0,14,14,0,0,0,0,8,8,14,14,13,13,3,3,1,1,2,2,14,14,5,5,0,0,3,3,4,4,4,4,10,10,3,3,7,7,14,14,4,4,4,4,0,0,4,4,14,14,5,5,5,5,5,5,8,8,7,7,8,8,11,11,15,15,14,14,12,12,8,8,0,0,4,4,11,11,8,8,12,12,12,12,4,4,4,4,12,12,4,4,10,10,0,0,2,2,3,3,4,4,7,7,15,15,1,1,15,15,6,6,0,0,6,6,7,7,14,14,13,13,9,9,11,11,11,11,9,9,6,6,10,10,9,9,14,14,15,15,2,2,5,5,7,7,3,3,10,10,0,0,15,15,14,14,2,2,4,4,10,10,15,15,4,4,0,0,3,3,5,5,12,12,2,2,5,5,9,9,7,7,2,2,1,1,2,2,12,12,6,6,0,0,2,2,6,6,7,7,4,4,9,9,1,1,2,2,8,8,7,7,9,9,0,0,4,4,11,11,13,13,7,7,15,15,7,7,12,12,15,15,11,11,13,13,2,2,13,13,12,12,3,3,8,8,6,6,11,11,5,5,12,12,10,10,2,2,6,6,1,1,2,2,7,7,1,1,4,4,14,14,5,5,7,7,0,0,1,1,10,10,3,3,7,7,5,5,6,6,3,3,14,14,1,1,8,8,1,1,14,14,2,2,15,15,8,8,3,3,7,7,9,9,6,6,7,7,5,5,8,8,6,6,11,11,15,15,10,10,13,13,1,1,2,2,8,8,15,15,3,3,10,10,3,3,6,6,2,2,1,1,8,8,8,8,13,13,14,14,0,0,13,13,1,1,14,14,10,10,10,10,15,15,14,14,8,8,5,5,9,9,2,2,10,10,7,7,3,3,9,9,2,2,0,0,1,1,10,10,8,8,6,6,5,5,4,4,5,5,11,11,2,2,4,4,15,15,13,13,6,6,5,5,5,5,13,13,15,15,11,11,5,5,11,11,3,3,7,7,6,6,14,14,13,13,0,0,0,0,10,10,4,4,5,5,7,7,3,3,11,11,2,2,6,6,1,1,6,6,8,8,0,0,2,2,4,4,11,11,10,10,15,15,12,12,6,6,5,5,1,1,3,3,6,6,1,1,1,1,13,13,6,6,13,13,14,14,9,9,15,15,11,11,5,5,14,14,11,11,10,10,5,5,9,9,5,5,12,12,5,5,4,4,15,15,0,0,9,9,0,0,15,15,5,5,10,10,10,10,5,5,4,4,11,11,13,13,13,13,15,15,2,2,14,14,3,3,7,7,4,4,9,9,9,9,10,10,13,13,1,1,10,10,6,6,10,10,7,7,15,15,14,14,2,2,0,0,6,6,10,10,6,6,10,10,13,13,8,8,9,9,15,15,0,0,9,9,8,8,8,8,2,2,10,10,11,11,9,9,7,7,6,6,1,1,13,13,1,1,8,8,13,13,14,14,9,9,11,11,9,9,7,7,10,10,3,3,6,6,14,14,14,14,14,14,6,6,13,13,10,10,14,14,3,3,1,1,5,5,11,11,7,7,6,6,3,3,14,14,8,8,12,12,1,1,7,7,10,10,9,9,12,12,10,10,4,4,1,1,14,14,4,4,7,7,4,4,5,5,7,7,4,4,15,15,8,8,12,12,0,0,8,8,11,11,6,6,9,9,6,6,0,0,2,2,4,4,10,10,2,2,2,2,8,8,7,7,6,6,0,0,2,2,3,3,1,1,12,12,8,8,11,11,12,12,6,6,10,10,0,0,8,8,2,2,4,4,14,14,0,0,3,3,2,2,2,2,14,14,11,11,0,0,5,5,10,10,13,13,7,7,6,6,14,14,12,12,10,10,10,10,14,14,6,6,6,6,0,0,2,2,2,2,12,12,12,12,4,4,12,12,5,5,11,11,3,3,0,0,14,14,4,4,6,6,14,14,8,8,0,0,4,4,13,13,9,9,8,8,6,6,12,12,14,14,3,3,6,6,5,5,13,13,9,9,2,2,6,6,2,2,4,4,12,12,0,0,5,5,8,8,7,7,5,5,5,5,9,9,10,10,9,9,12,12,8,8,5,5,2,2,2,2,12,12,0,0,9,9,14,14,0,0,8,8,6,6,15,15,12,12,5,5,12,12,9,9,6,6,7,7,1,1,6,6,13,13,6,6,0,0,1,1,8,8,4,4,4,4,8,8,8,8,0,0,14,14,14,14,2,2,1,1,12,12,0,0,4,4,2,2,14,14,3,3,13,13,7,7,8,8,2,2,2,2,0,0,10,10,7,7,7,7,0,0,12,12,1,1,3,3,8,8,12,12,14,14,11,11,15,15,2,2,7,7,14,14,0,0,6,6,2,2,6,6,11,11,4,4,5,5,0,0,0,0,8,8,10,10,14,14,1,1,8,8,11,11,15,15,10,10,9,9,1,1,11,11,6,6,4,4,12,12,8,8,12,12,12,12,4,4,1,1,4,4,10,10,7,7,11,11,4,4,8,8,4,4,8,8,7,7,1,1,12,12,3,3,8,8,11,11,2,2,14,14,3,3,0,0,3,3,12,12,1,1,12,12,13,13,14,14,15,15,7,7,8,8,7,7,12,12,12,12,2,2,6,6,1,1,4,4,8,8,14,14,14,14,13,13,6,6,3,3,4,4,2,2,8,8,15,15,12,12,7,7,5,5,3,3,5,5,13,13,1,1,1,1,15,15,5,5,1,1,6,6,10,10,3,3,2,2,5,5,15,15,6,6,0,0,6,6,2,2,5,5,9,9,2,2,0,0,6,6,1,1,2,2,12,12,13,13,11,11,0,0,7,7,6,6,4,4,13,13,10,10,9,9,12,12,10,10,1,1,8,8,13,13,10,10,10,10,3,3,3,3,5,5,1,1,7,7,0,0,14,14,5,5,0,0,15,15,3,3,2,2,8,8,15,15,0,0,6,6,13,13,10,10,12,12,13,13,10,10,14,14,3,3,15,15,3,3,9,9,6,6,13,13,15,15,15,15,2,2,10,10,8,8,11,11,11,11,5,5,10,10,8,8,4,4,15,15,3,3,0,0,2,2,7,7,0,0,15,15,10,10,0,0,4,4,1,1,1,1,0,0,13,13,0,0,12,12,14,14,4,4,14,14,11,11,12,12,4,4,13,13,13,13,6,6,0,0,10,10,8,8,7,7,9,9,10,10,2,2,2,2,5,5,3,3,5,5,1,1,11,11,2,2,4,4,1,1,6,6,2,2,5,5,13,13,13,13,5,5,13,13,8,8,14,14,13,13,14,14,9,9,12,12,10,10,4,4,6,6,2,2,15,15,10,10,12,12,7,7,2,2,5,5,0,0,5,5,11,11,9,9,0,0,0,0,2,2,11,11,10,10,0,0,13,13,7,7,15,15,7,7,7,7,5,5,12,12,2,2,0,0,14,14,6,6,2,2,0,0,8,8,10,10,13,13,0,0,8,8,0,0,13,13,5,5,5,5,9,9,7,7,10,10,7,7,7,7,11,11,5,5,15,15,1,1,5,5,0,0,4,4,11,11,14,14,9,9,4,4,2,2,10,10,7,7,13,13,8,8,1,1,8,8,0,0,9,9,1,1,11,11,1,1,6,6,13,13,10,10,13,13,5,5,6,6,13,13,15,15,5,5,11,11,1,1,1,1,13,13,8,8,5,5,3,3,3,3,7,7,11,11,3,3,11,11,9,9,1,1,3,3,8,8,5,5,0,0,15,15,0,0,0,0,4,4,1,1,8,8,5,5,2,2,3,3,11,11,0,0,13,13,11,11,5,5,9,9,4,4,2,2,10,10,8,8,8,8,14,14,5,5,10,10,9,9,15,15,13,13,15,15,5,5,0,0,8,8,7,7,3,3,11,11,2,2,12,12,8,8,14,14,14,14,0,0,1,1,4,4,0,0,3,3,4,4,13,13,6,6,6,6,3,3,2,2,3,3,11,11,7,7,2,2,1,1,8,8,2,2,9,9,7,7,8,8,0,0,14,14,7,7,6,6,14,14,10,10,2,2,4,4,15,15,2,2,13,13,0,0,13,13,12,12,5,5,0,0,0,0,8,8,13,13,6,6,5,5,4,4,13,13,9,9,3,3,6,6,1,1,5,5,12,12,1,1,11,11,5,5,1,1,2,2,9,9,10,10,14,14,9,9,11,11,0,0,14,14,2,2,1,1,14,14,0,0,9,9,1,1,2,2,11,11,7,7,8,8,1,1,14,14,0,0,10,10,12,12,2,2,14,14,9,9,12,12,1,1,15,15,3,3,13,13,12,12,12,12,7,7,3,3,6,6,0,0,11,11,15,15,1,1,12,12,10,10,3,3,4,4,7,7,1,1,3,3,11,11,1,1,11,11,8,8,4,4,0,0,2,2,15,15,12,12,12,12,5,5,8,8,13,13,8,8,0,0,10,10,4,4,2,2,6,6,8,8,2,2,3,3,0,0,0,0,14,14,6,6,13,13,15,15,2,2,0,0,0,0,6,6,3,3,12,12,6,6,1,1,2,2,14,14,0,0,5,5,0,0,3,3,6,6,2,2,12,12,0,0,4,4,2,2,7,7,8,8,14,14,1,1,10,10,5,5,4,4,3,3,4,4,10,10,8,8,14,14,3,3,6,6,3,3,2,2,1,1,15,15,4,4,1,1,14,14,13,13,13,13,7,7,1,1,8,8,0,0,0,0,9,9,13,13,6,6,3,3,9,9,8,8,9,9,2,2,2,2,1,1,14,14,5,5,0,0,12,12,4,4,10,10,0,0,4,4,15,15,5,5,13,13,9,9,0,0,3,3,2,2,13,13,5,5,4,4,5,5,4,4,1,1,5,5,0,0,6,6,13,13,13,13,0,0,2,2,0,0,8,8,11,11,3,3,14,14,7,7,2,2,2,2,1,1,3,3,8,8,4,4,15,15,2,2,0,0,2,2,12,12,11,11,14,14,1,1,15,15,13,13,8,8,3,3,12,12,2,2,12,12,8,8,14,14,11,11,9,9,8,8,2,2,12,12,5,5,1,1,11,11,5,5,11,11,4,4,2,2,1,1,9,9,11,11,12,12,0,0,4,4,7,7,9,9,6,6,15,15,4,4,2,2,2,2,15,15,6,6,4,4,8,8,2,2,9,9,5,5,5,5,1,1,4,4,1,1,5,5,7,7,15,15,4,4,12,12,2,2,11,11,14,14,1,1,6,6,6,6,6,6,9,9,5,5,13,13,4,4,1,1,8,8,2,2,9,9,15,15,2,2,6,6,10,10,4,4,8,8,8,8,3,3,4,4,7,7,15,15,12,12,10,10,3,3,4,4,1,1,4,4,1,1,7,7,5,5,15,15,9,9,5,5,13,13,13,13,9,9,7,7,12,12,13,13,7,7,8,8,2,2,9,9,14,14,5,5,2,2,8,8,15,15,2,2,0,0,4,4,8,8,0,0,9,9,9,9,0,0,12,12,12,12,8,8,15,15,10,10,9,9,13,13,9,9,15,15,2,2,7,7,9,9,0,0,14,14,14,14,10,10,13,13,2,2,9,9,8,8,5,5,10,10,6,6,10,10,2,2,5,5,0,0,2,2,4,4,10,10,12,12,3,3,5,5,2,2,8,8,1,1,11,11,10,10,11,11,15,15,4,4,8,8,4,4,3,3,4,4,7,7,3,3,5,5,15,15,15,15,7,7,2,2,14,14,13,13,2,2,14,14,6,6,7,7,10,10,13,13,14,14,3,3,2,2,4,4,5,5,1,1,12,12,5,5,12,12,3,3,7,7,8,8,4,4,15,15,15,15,15,15,5,5,11,11,2,2,1,1,2,2,8,8,8,8,2,2,2,2,7,7,1,1,1,1,1,1,3,3,6,6,2,2,13,13,15,15,15,15,5,5,9,9,9,9,13,13,9,9,12,12,14,14,0,0,3,3,0,0,8,8,0,0,3,3,8,8,1,1,3,3,10,10,5,5,7,7,0,0,13,13,6,6,5,5,7,7,6,6,12,12,7,7,6,6,10,10,0,0,5,5,12,12,5,5,1,1,9,9,15,15,3,3,2,2,1,1,4,4,13,13,2,2,14,14,13,13,9,9,11,11,7,7,5,5,10,10,9,9,2,2,15,15,0,0,1,1,3,3,3,3,0,0,11,11,8,8,8,8,1,1,2,2,1,1,13,13,14,14,13,13,12,12,3,3,2,2,9,9,4,4,9,9,6,6,5,5,12,12,4,4,13,13,0,0,3,3,4,4,13,13,2,2,5,5,0,0,5,5,4,4,3,3,8,8,13,13,8,8,3,3,13,13,8,8,0,0,15,15,12,12,10,10,1,1,0,0,8,8,10,10,0,0,13,13,7,7,5,5,8,8,6,6,9,9,8,8,3,3,12,12,9,9,14,14,6,6,9,9,6,6,9,9,9,9,10,10,0,0,9,9,4,4,0,0,5,5,7,7,14,14,8,8,0,0,2,2,7,7,3,3,2,2,2,2,0,0,14,14,1,1,1,1,4,4,1,1,2,2,15,15,3,3,0,0,13,13,10,10,11,11,3,3,8,8,9,9,5,5,10,10,15,15,2,2,15,15,10,10,5,5,1,1,7,7,8,8,1,1,15,15,2,2,3,3,0,0,8,8,5,5,11,11,11,11,15,15,4,4,2,2,0,0,11,11,11,11,3,3,3,3,4,4,4,4,6,6,12,12,9,9,9,9,7,7,7,7,10,10,11,11,4,4,0,0,6,6,6,6,4,4,5,5,14,14,2,2,12,12,1,1,2,2,12,12,9,9,12,12,15,15,12,12,2,2,10,10,3,3,15,15,15,15,1,1,3,3,2,2,10,10,14,14,0,0,10,10,1,1,5,5,11,11,1,1,11,11,10,10,12,12,3,3,9,9,1,1,5,5,1,1,2,2,10,10,8,8,5,5,13,13,15,15,0,0,3,3,12,12,3,3,0,0,0,0,10,10,9,9,14,14,2,2,8,8,10,10,6,6,9,9,11,11,3,3,12,12,12,12,10,10,0,0,3,3,8,8,5,5,10,10,6,6,4,4,14,14,1,1,12,12,7,7,7,7,10,10,8,8,6,6,9,9,5,5,15,15,11,11,0,0,5,5,6,6,0,0,15,15,5,5,2,2,8,8,9,9,1,1,9,9,6,6,12,12,9,9,4,4,7,7,3,3,6,6,3,3,1,1,0,0,2,2,14,14,2,2,12,12,9,9,15,15,0,0,6,6,10,10,1,1,2,2,5,5,2,2,8,8,4,4,5,5,15,15,8,8,9,9,7,7,2,2,4,4,14,14,5,5,15,15,2,2,7,7,8,8,3,3,9,9,10,10,9,9,2,2,7,7,9,9,2,2,11,11,1,1,1,1,15,15,2,2,3,3,9,9,10,10,2,2,5,5,6,6,6,6,8,8,0,0,11,11,11,11,14,14,6,6,15,15,15,15,11,11,11,11,8,8,0,0,12,12,1,1,9,9,13,13,11,11,5,5,3,3,8,8,11,11,4,4,14,14,12,12,15,15,9,9,6,6,1,1,8,8,3,3,9,9,5,5,14,14,14,14,11,11,4,4,4,4,11,11,14,14,0,0,4,4,13,13,9,9,0,0,1,1,12,12,13,13,8,8,3,3,3,3,13,13,4,4,0,0,7,7,3,3,13,13,1,1,0,0,13,13,9,9,9,9,0,0,2,2,8,8,3,3,4,4,5,5,8,8,4,4,6,6,14,14,6,6,12,12,6,6,11,11,14,14,15,15,12,12,3,3,15,15,4,4,0,0,3,3,11,11,8,8,8,8,15,15,9,9,12,12,2,2,15,15,10,10,11,11,1,1,3,3,8,8,4,4,12,12,4,4,8,8,7,7,11,11,3,3,9,9,10,10,12,12,6,6,13,13,3,3,2,2,2,2,3,3,13,13,0,0,8,8,4,4,2,2,1,1,10,10,12,12,13,13,1,1,8,8,4,4,1,1,14,14,12,12,6,6,7,7,2,2,10,10,13,13,0,0,3,3,3,3,14,14,7,7,12,12,9,9,14,14,0,0,0,0,8,8,6,6,14,14,10,10,0,0,10,10,10,10,13,13,7,7,8,8,3,3,13,13,13,13,5,5,10,10,7,7,11,11,10,10,6,6,9,9,5,5,13,13,2,2,6,6,10,10,0,0,0,0,8,8,0,0,7,7,14,14,2,2,1,1,0,0,3,3,4,4,1,1,1,1,14,14,10,10,10,10,0,0,14,14,10,10,2,2,7,7,6,6,2,2,12,12,7,7,8,8,0,0,13,13,6,6,6,6,10,10,0,0,13,13,5,5,11,11,5,5,13,13,12,12,0,0,13,13,14,14,10,10,3,3,5,5,2,2,9,9,7,7,11,11,8,8,11,11,12,12,5,5,12,12,14,14,13,13,11,11,3,3,8,8,5,5,15,15,13,13,13,13,12,12,1,1,10,10,6,6,12,12,0,0,11,11,3,3,15,15,4,4,8,8,3,3,14,14,0,0,13,13,1,1,2,2,1,1,1,1,4,4,3,3,12,12,0,0,5,5,10,10,3,3,4,4,10,10,2,2,14,14,7,7,6,6,4,4,8,8,14,14,4,4,3,3,14,14,2,2,9,9,1,1,12,12,13,13,11,11,12,12,5,5,11,11,14,14,14,14,5,5,1,1,0,0,11,11,11,11,4,4,15,15,14,14,2,2,12,12,15,15,6,6,15,15,11,11,6,6,13,13,4,4,8,8,13,13,6,6,14,14,15,15,6,6,10,10,0,0,8,8,11,11,5,5,5,5,13,13,13,13,0,0,14,14,13,13,8,8,2,2,15,15,2,2,0,0,10,10,3,3,9,9,7,7,15,15,10,10,0,0,2,2,2,2,7,7,11,11,7,7,12,12,1,1,5,5,0,0,12,12,4,4,2,2,14,14,13,13,12,12,5,5,8,8,13,13,11,11,13,13,3,3,14,14,15,15,12,12,15,15,12,12,12,12,7,7,1,1,2,2,10,10,15,15,15,15,3,3,15,15,1,1,1,1,14,14,7,7,0,0,3,3,4,4,4,4,10,10,0,0,8,8,12,12,3,3,0,0,4,4,10,10,1,1,7,7,1,1,7,7,10,10,5,5,9,9,13,13,6,6,1,1,6,6,10,10,5,5,13,13,14,14,14,14,9,9,9,9,8,8,0,0,9,9,3,3,13,13,2,2,12,12,0,0,15,15,3,3,4,4,5,5,15,15,11,11,11,11,8,8,13,13,5,5,12,12,7,7,1,1,9,9,14,14,9,9,9,9,0,0,15,15,6,6,9,9,7,7,7,7,5,5,12,12,8,8,12,12,14,14,8,8,2,2,15,15,5,5,14,14,5,5,11,11,12,12,10,10,6,6,6,6,0,0,3,3,7,7,10,10,3,3,13,13,13,13,8,8,13,13,5,5,7,7,13,13,3,3,12,12,9,9,6,6,13,13,7,7,3,3,11,11,3,3,6,6,14,14,3,3,4,4,5,5,14,14,13,13,14,14,1,1,14,14,15,15,5,5,3,3,9,9,8,8,13,13,8,8,1,1,2,2,5,5,3,3,5,5,12,12,4,4,4,4,12,12,1,1,9,9,3,3,0,0,12,12,12,12,1,1,6,6,1,1,10,10,1,1,10,10,5,5,1,1,11,11,15,15,1,1,15,15,8,8,8,8,7,7,8,8,7,7,15,15,7,7,2,2,9,9,9,9,3,3,1,1,4,4,7,7,4,4,0,0,2,2,1,1,5,5,5,5,3,3,6,6,2,2,5,5,12,12,3,3,10,10,1,1,1,1,1,1,14,14,12,12,14,14,2,2,4,4,4,4,13,13,14,14,7,7,0,0,6,6,15,15,8,8,2,2,4,4,15,15,0,0,1,1,9,9,15,15,10,10,9,9,3,3,6,6,4,4,15,15,13,13,3,3,13,13,14,14,5,5,10,10,0,0,5,5,2,2,11,11,7,7,8,8,2,2,14,14,8,8,10,10,6,6,11,11,0,0,4,4,1,1,8,8,7,7,13,13,8,8,14,14,3,3,13,13,1,1,12,12,8,8,15,15,3,3,2,2,10,10,14,14,7,7,15,15,8,8,10,10,11,11,0,0,12,12,0,0,6,6,9,9,10,10,0,0,2,2,11,11,12,12,14,14,15,15,8,8,5,5,3,3,13,13,10,10,0,0,15,15,3,3,3,3,4,4,9,9,6,6,14,14,10,10,13,13,14,14,10,10,13,13,12,12,8,8,9,9,4,4,5,5,6,6,13,13,4,4,3,3,10,10,2,2,3,3,5,5,2,2,6,6,0,0,7,7,3,3,5,5,0,0,5,5,13,13,12,12,11,11,1,1,15,15,2,2,1,1,6,6,11,11,1,1,2,2,11,11,12,12,12,12,4,4,4,4,5,5,0,0,0,0,13,13,6,6,1,1,8,8,10,10,10,10,6,6,0,0,12,12,7,7,7,7,1,1,12,12,6,6,8,8,13,13,5,5,2,2,2,2,13,13,15,15,8,8,1,1,4,4,11,11,0,0,12,12,0,0,8,8,13,13,1,1,6,6,7,7,8,8,10,10,14,14,2,2,9,9,10,10,8,8,7,7,0,0,3,3,10,10,6,6,6,6,2,2,5,5,0,0,1,1,9,9,5,5,10,10,14,14,9,9,2,2,8,8,5,5,4,4,11,11,13,13,14,14,2,2,0,0,14,14,13,13,9,9,9,9,12,12,6,6,5,5,13,13,13,13,1,1,14,14,10,10,6,6,0,0,9,9,9,9,12,12,13,13,4,4,7,7,9,9,1,1,4,4,1,1,3,3,0,0,0,0,1,1,14,14,8,8,10,10,9,9,15,15,6,6,9,9,10,10,3,3,0,0,8,8,5,5,0,0,3,3,13,13,9,9,0,0,4,4,2,2,9,9,9,9,13,13,9,9,11,11,10,10,12,12,2,2,13,13,10,10,2,2,15,15,1,1,0,0,4,4,14,14,8,8,3,3,7,7,10,10,1,1,15,15,0,0,15,15,4,4,6,6,4,4,2,2,2,2,6,6,1,1,4,4,7,7,13,13,0,0,0,0,14,14,6,6,4,4,6,6,1,1,3,3,6,6,1,1,15,15,7,7,10,10,2,2,6,6,3,3,5,5,4,4,1,1,11,11,9,9,0,0,11,11,3,3,11,11,7,7,5,5,1,1,6,6,4,4,10,10,13,13,12,12,12,12,9,9,12,12,13,13,5,5,10,10,1,1,10,10,13,13,8,8,3,3,15,15,12,12,3,3,2,2,2,2,12,12,6,6,5,5,14,14,6,6,5,5,15,15,5,5,3,3,8,8,3,3,10,10,10,10,2,2,5,5,15,15,0,0,15,15,7,7,1,1,1,1,3,3,8,8,1,1,8,8,15,15,10,10,11,11,11,11,0,0,11,11,3,3,4,4,4,4,15,15,4,4,15,15,14,14,15,15,7,7,8,8,0,0,10,10,0,0,2,2,12,12,9,9,9,9,3,3,9,9,4,4,14,14,10,10,3,3,10,10,1,1,3,3,7,7,15,15,3,3,8,8,14,14,8,8,14,14,6,6,8,8,7,7,15,15,0,0,7,7,5,5,15,15,4,4,2,2,1,1,0,0,1,1,0,0,3,3,0,0,5,5,1,1,8,8,10,10,6,6,11,11,8,8,2,2,3,3,11,11,1,1,4,4,0,0,9,9,11,11,3,3,4,4,12,12,11,11,11,11,2,2,15,15,7,7,13,13,15,15,6,6,11,11,10,10,6,6,4,4,13,13,9,9,7,7,6,6,4,4,6,6,14,14,13,13,8,8,1,1,9,9,13,13,6,6,6,6,6,6,1,1,7,7,4,4,14,14,12,12,9,9,1,1,0,0,5,5,2,2,1,1,15,15,5,5,13,13,1,1,7,7,3,3,5,5,12,12,2,2,8,8,14,14,6,6,5,5,1,1,2,2,5,5,9,9,10,10,6,6,13,13,14,14,6,6,1,1,11,11,13,13,13,13,7,7,5,5,12,12,9,9,9,9,10,10,0,0,13,13,0,0,5,5,0,0,6,6,8,8,10,10,2,2,8,8,0,0,8,8,1,1,2,2,12,12,13,13,2,2,14,14,6,6,1,1,6,6,6,6,2,2,6,6,6,6,1,1,15,15,12,12,2,2,5,5,3,3,7,7,14,14,8,8,1,1,14,14,10,10,9,9,14,14,9,9,15,15,3,3,0,0,14,14,2,2,11,11,14,14,0,0,12,12,13,13,14,14,10,10,8,8,7,7,13,13,5,5,13,13,4,4,0,0,1,1,1,1,0,0,2,2,4,4,9,9,8,8,4,4,0,0,2,2,7,7,1,1,8,8,13,13,4,4,15,15,10,10,12,12,3,3,2,2,4,4,9,9,5,5,13,13,2,2,5,5,1,1,0,0,11,11,6,6,15,15,11,11,3,3,6,6,4,4,0,0,8,8,2,2,6,6,11,11,4,4,14,14,13,13,10,10,9,9,6,6,4,4,12,12,13,13,9,9,1,1,1,1,0,0,0,0,4,4,12,12,0,0,13,13,14,14,5,5,8,8,5,5,9,9,2,2,6,6,12,12,1,1,13,13,6,6,4,4,1,1,6,6,7,7,6,6,10,10,1,1,5,5,13,13,6,6,11,11,11,11,11,11,4,4,10,10,15,15,6,6,0,0,10,10,12,12,8,8,8,8,4,4,7,7,7,7,15,15,9,9,4,4,5,5,7,7,0,0,12,12,11,11,15,15,13,13,0,0,7,7,15,15,1,1,0,0,12,12,0,0,10,10,9,9,11,11,12,12,15,15,10,10,14,14,14,14,4,4,13,13,0,0,14,14,12,12,7,7,2,2,5,5,14,14,0,0,9,9,13,13,12,12,14,14,0,0,7,7,4,4,13,13,13,13,0,0,6,6,12,12,12,12,5,5,2,2,3,3,7,7,3,3,8,8,14,14,14,14,14,14,11,11,13,13,7,7,0,0,15,15,2,2,10,10,4,4,4,4,0,0,3,3,6,6,12,12,11,11,11,11,0,0,5,5,14,14,6,6,2,2,5,5,0,0,12,12,8,8,0,0,14,14,0,0,5,5,3,3,5,5,5,5,2,2,0,0,4,4,1,1,7,7,15,15,15,15,3,3,4,4,12,12,6,6,12,12,7,7,13,13,6,6,11,11,10,10,8,8,11,11,6,6,3,3,8,8,8,8,5,5,7,7,14,14,2,2,12,12,7,7,3,3,14,14,13,13,13,13,10,10,1,1,8,8,10,10,2,2,6,6,11,11,9,9,15,15,10,10,12,12,3,3,4,4,7,7,1,1,8,8,13,13,8,8,11,11,0,0,8,8,3,3,10,10,9,9,11,11,7,7,14,14,3,3,11,11,3,3,13,13,1,1,0,0,4,4,12,12,11,11,4,4,9,9,5,5,12,12,0,0,10,10,0,0,3,3,13,13,15,15,4,4,12,12,9,9,6,6,8,8,11,11,0,0,10,10,11,11,3,3,9,9,14,14,3,3,2,2,7,7,14,14,13,13,0,0,12,12,6,6,3,3,13,13,6,6,9,9,4,4,2,2,15,15,8,8,8,8,10,10,14,14,13,13,5,5,12,12,3,3,2,2,14,14,9,9,5,5,6,6,3,3,0,0,6,6,3,3,3,3,1,1,8,8,14,14,0,0,15,15,11,11,3,3,2,2,14,14,11,11,1,1,15,15,8,8,10,10,7,7,8,8,13,13,7,7,2,2,0,0,11,11,10,10,9,9,1,1,9,9,9,9,8,8,9,9,14,14,14,14,14,14,9,9,5,5,15,15,8,8,11,11,1,1,14,14,6,6,8,8,0,0,7,7,1,1,9,9,12,12,11,11,3,3,15,15,9,9,10,10,0,0,13,13,1,1,2,2,3,3,7,7,14,14,0,0,8,8,6,6,4,4,9,9,5,5,7,7,2,2,14,14,1,1,0,0,10,10,1,1,12,12,2,2,15,15,7,7,8,8,10,10,9,9,15,15,13,13,2,2,1,1,13,13,13,13,1,1,0,0,2,2,11,11,2,2,3,3,14,14,13,13,3,3,13,13,5,5,13,13,7,7,7,7,9,9,8,8,6,6,0,0,10,10,6,6,6,6,11,11,1,1,7,7,7,7,0,0,11,11,15,15,6,6,2,2,15,15,8,8,3,3,0,0,10,10,10,10,13,13,8,8,15,15,10,10,0,0,3,3,1,1,12,12,4,4,15,15,12,12,12,12,2,2,2,2,12,12,14,14,9,9,9,9,9,9,8,8,7,7,4,4,3,3,0,0,14,14,8,8,11,11,8,8,5,5,6,6,10,10,5,5,12,12,1,1,8,8,2,2,10,10,11,11,5,5,10,10,7,7,8,8,0,0,1,1,1,1,14,14,0,0,11,11,13,13,5,5,14,14,15,15,7,7,10,10,1,1,5,5,0,0,9,9,2,2,12,12,1,1,9,9,4,4,12,12,10,10,10,10,12,12,9,9,15,15,2,2,3,3,4,4,6,6,10,10,0,0,4,4,0,0,4,4,6,6,1,1,9,9,1,1,14,14,13,13,2,2,10,10,2,2,3,3,11,11,9,9,13,13,6,6,9,9,15,15,9,9,0,0,3,3,14,14,2,2,2,2,15,15,11,11,12,12,15,15,12,12,5,5,6,6,3,3,4,4,15,15,11,11,11,11,3,3,5,5,3,3,9,9,2,2,1,1,5,5,4,4,13,13,9,9,13,13,10,10,0,0,14,14,4,4,12,12,7,7,11,11,15,15,5,5,1,1,0,0,6,6,5,5,10,10,7,7,11,11,8,8,7,7,2,2,8,8,9,9,4,4,2,2,4,4,14,14,9,9,15,15,5,5,9,9,13,13,13,13,8,8,5,5,4,4,0,0,15,15,2,2,8,8,7,7,0,0,13,13,4,4,5,5,3,3,8,8,14,14,8,8,1,1,7,7,3,3,9,9,14,14,9,9,5,5,1,1,15,15,6,6,6,6,0,0,9,9,2,2,8,8,12,12,9,9,1,1,13,13,4,4,12,12,7,7,6,6,0,0,15,15,13,13,4,4,7,7,0,0,3,3,7,7,13,13,7,7,13,13,7,7,7,7,11,11,8,8,1,1,11,11,3,3,13,13,6,6,4,4,4,4,12,12,9,9,5,5,13,13,6,6,10,10,4,4,8,8,12,12,15,15,3,3,2,2,0,0,4,4,2,2,15,15,10,10,4,4,7,7,4,4,12,12,8,8,13,13,1,1,11,11,15,15,13,13,5,5,3,3,7,7,9,9,13,13,5,5,4,4,3,3,8,8,3,3,12,12,9,9,10,10,7,7,13,13,10,10,1,1,10,10,7,7,15,15,10,10,2,2,14,14,0,0,14,14,7,7,10,10,6,6,0,0,1,1,12,12,0,0,3,3,5,5,10,10,1,1,5,5,4,4,4,4,3,3,13,13,2,2,10,10,14,14,1,1,0,0,8,8,2,2,8,8,7,7,7,7,8,8,12,12,13,13,4,4,14,14,15,15,1,1,12,12,2,2,14,14,5,5,13,13,0,0,5,5,4,4,8,8,5,5,6,6,12,12,13,13,6,6,0,0,1,1,13,13,4,4,4,4,15,15,10,10,5,5,13,13,7,7,14,14,8,8,8,8,2,2,15,15,12,12,4,4,4,4,13,13,13,13,14,14,14,14,0,0,2,2,2,2,1,1,3,3,1,1,6,6,1,1,3,3,3,3,7,7,0,0,8,8,15,15,0,0,10,10,9,9,10,10,5,5,5,5,2,2,6,6,12,12,12,12,5,5,1,1,8,8,9,9,7,7,8,8,0,0,4,4,12,12,10,10,9,9,1,1,9,9,9,9,5,5,1,1,3,3,11,11,3,3,11,11,11,11,1,1,7,7,8,8,0,0,2,2,9,9,3,3,15,15,9,9,12,12,11,11,0,0,11,11,5,5,10,10,10,10,7,7,0,0,7,7,15,15,6,6,6,6,7,7,4,4,5,5,6,6,11,11,5,5,15,15,11,11,2,2,2,2,11,11,10,10,0,0,7,7,6,6,14,14,0,0,11,11,11,11,6,6,12,12,7,7,12,12,13,13,10,10,14,14,4,4,7,7,10,10,0,0,15,15,2,2,2,2,0,0,11,11,7,7,8,8,11,11,14,14,2,2,9,9,3,3,6,6,10,10,15,15,1,1,3,3,2,2,7,7,13,13,11,11,14,14,3,3,1,1,1,1,6,6,10,10,9,9,10,10,0,0,5,5,7,7,12,12,15,15,10,10,14,14,8,8,5,5,0,0,0,0,14,14,3,3,12,12,0,0,14,14,8,8,7,7,7,7,8,8,3,3,6,6,2,2,2,2,11,11,11,11,14,14,4,4,8,8,14,14,8,8,8,8,3,3,13,13,13,13,0,0,1,1,11,11,0,0,6,6,8,8,14,14,8,8,3,3,6,6,10,10,0,0,6,6,4,4,0,0,6,6,2,2,13,13,2,2,1,1,5,5,14,14,2,2,11,11,4,4,1,1,10,10,1,1,2,2,10,10,1,1,1,1,14,14,13,13,0,0,1,1,8,8,0,0,4,4,10,10,2,2,3,3,4,4,12,12,14,14,11,11,13,13,5,5,10,10,10,10,1,1,5,5,8,8,12,12,8,8,14,14,4,4,1,1,3,3,3,3,0,0,2,2,0,0,10,10,13,13,0,0,13,13,10,10,9,9,0,0,0,0,7,7,12,12,15,15,13,13,6,6,5,5,3,3,0,0,13,13,1,1,6,6,15,15,4,4,12,12,2,2,4,4,13,13,14,14,3,3,12,12,7,7,5,5,9,9,14,14,13,13,3,3,7,7,6,6,7,7,2,2,12,12,2,2,14,14,14,14,8,8,6,6,13,13,8,8,1,1,14,14,6,6,1,1,11,11,14,14,15,15,4,4,9,9,7,7,4,4,14,14,11,11,6,6,11,11,2,2,3,3,3,3,7,7,0,0,8,8,8,8,9,9,13,13,15,15,4,4,10,10,2,2,4,4,14,14,7,7,6,6,1,1,11,11,14,14,8,8,15,15,2,2,8,8,0,0,9,9,5,5,14,14,9,9,7,7,8,8,4,4,14,14,3,3,4,4,14,14,6,6,0,0,4,4,0,0,11,11,9,9,9,9,13,13,1,1,4,4,4,4,11,11,12,12,10,10,7,7,10,10,9,9,0,0,0,0,13,13,11,11,14,14,15,15,10,10,11,11,9,9,6,6,0,0,14,14,12,12,8,8,0,0,6,6,5,5,14,14,0,0,6,6,3,3,12,12,9,9,4,4,10,10,3,3,3,3,2,2,14,14,5,5,5,5,3,3,10,10,4,4,7,7,10,10,0,0,3,3,4,4,13,13,5,5,5,5,0,0,2,2,1,1,15,15,13,13,8,8,15,15,2,2,0,0,13,13,4,4,5,5,9,9,4,4,13,13,0,0,8,8,1,1,2,2,9,9,13,13,14,14,13,13,13,13,15,15,6,6,10,10,0,0,5,5,9,9,6,6,8,8,9,9,13,13,0,0,13,13,1,1,12,12,0,0,5,5,14,14,8,8,15,15,14,14,2,2,12,12,13,13,15,15,2,2,1,1,15,15,8,8,13,13,0,0,7,7,6,6,11,11,1,1,2,2,6,6,6,6,12,12,2,2,2,2,11,11,0,0,10,10,14,14,4,4,12,12,9,9,1,1,11,11,5,5,10,10,5,5,11,11,8,8,7,7,6,6,3,3,12,12,12,12,6,6,5,5,13,13,3,3,5,5,4,4,3,3,11,11,11,11,1,1,6,6,11,11,4,4,2,2,5,5,14,14,8,8,2,2,3,3,0,0,12,12,8,8,10,10,13,13,6,6,11,11,5,5,15,15,0,0,13,13,13,13,1,1,15,15,12,12,9,9,13,13,9,9,11,11,11,11,7,7,6,6,3,3,2,2,4,4,6,6,5,5,1,1,8,8,11,11,8,8,12,12,2,2,15,15,7,7,2,2,4,4,14,14,12,12,10,10,1,1,12,12,3,3,12,12,9,9,14,14,8,8,6,6,6,6,5,5,10,10,15,15,12,12,11,11,9,9,7,7,12,12,4,4,12,12,5,5,4,4,12,12,12,12,10,10,2,2,0,0,5,5,14,14,1,1,8,8,4,4,3,3,9,9,1,1,0,0,7,7,0,0,8,8,0,0,6,6,15,15,15,15,6,6,13,13,4,4,3,3,0,0,11,11,12,12,7,7,12,12,13,13,5,5,2,2,12,12,10,10,10,10,5,5,8,8,10,10,15,15,12,12,13,13,2,2,1,1,2,2,13,13,9,9,2,2,2,2,12,12,3,3,12,12,6,6,6,6,1,1,7,7,1,1,4,4,11,11,8,8,3,3,12,12,1,1,7,7,9,9,14,14,7,7,8,8,2,2,9,9,13,13,6,6,6,6,3,3,9,9,3,3,0,0,9,9,2,2,13,13,11,11,1,1,10,10,4,4,7,7,14,14,4,4,7,7,3,3,8,8,2,2,4,4,14,14,0,0,9,9,8,8,6,6,10,10,13,13,2,2,6,6,9,9,11,11,5,5,14,14,1,1,6,6,4,4,3,3,5,5,13,13,1,1,1,1,15,15,10,10,15,15,9,9,3,3,12,12,3,3,15,15,5,5,9,9,5,5,9,9,4,4,4,4,12,12,12,12,9,9,5,5,15,15,14,14,8,8,2,2,14,14,9,9,4,4,11,11,9,9,5,5,15,15,9,9,13,13,12,12,15,15,13,13,2,2,11,11,13,13,4,4,9,9,7,7,2,2,11,11,14,14,5,5,15,15,8,8,7,7,4,4,5,5,12,12,8,8,8,8,15,15,12,12,15,15,8,8,15,15,11,11,9,9,6,6,10,10,0,0,8,8,14,14,2,2,0,0,11,11,0,0,8,8,4,4,15,15,14,14,3,3,8,8,7,7,14,14,3,3,10,10,13,13,10,10,9,9,0,0,9,9,6,6,8,8,8,8,5,5,11,11,6,6,6,6,7,7,1,1,14,14,3,3,2,2,14,14,13,13,11,11,3,3,10,10,0,0,4,4,6,6,8,8,1,1,15,15,12,12,5,5,10,10,6,6,6,6,2,2,6,6,2,2,4,4,12,12,6,6,9,9,9,9,1,1,0,0,1,1,14,14,13,13,3,3,0,0,6,6,0,0,0,0,5,5,11,11,6,6,9,9,10,10,8,8,4,4,9,9,3,3,15,15,5,5,5,5,3,3,8,8,9,9,8,8,12,12,6,6,2,2,13,13,13,13,5,5,8,8,3,3,7,7,3,3,3,3,9,9,7,7,9,9,2,2,3,3,10,10,2,2,8,8,6,6,1,1,12,12,8,8,13,13,8,8,5,5,10,10,13,13,9,9,8,8,4,4,3,3,0,0,5,5,0,0,9,9,12,12,12,12,13,13,7,7,6,6,11,11,0,0,14,14,12,12,10,10,14,14,12,12,11,11,9,9,12,12,6,6,14,14,6,6,7,7,15,15,0,0,3,3,3,3,1,1,14,14,15,15,2,2,9,9,5,5,1,1,0,0,12,12,3,3,1,1,5,5,6,6,7,7,6,6,3,3,14,14,10,10,3,3,1,1,13,13,3,3,9,9,1,1,12,12,1,1,2,2,9,9,0,0,1,1,10,10,5,5,0,0,14,14,4,4,10,10,6,6,4,4,4,4,13,13,8,8,7,7,3,3,11,11,10,10,12,12,7,7,0,0,0,0,13,13,4,4,15,15,14,14,7,7,0,0,15,15,7,7,4,4,5,5,1,1,8,8,5,5,4,4,1,1,5,5,13,13,7,7,5,5,7,7,5,5,13,13,1,1,10,10,15,15,7,7,12,12,7,7,10,10,12,12,5,5,11,11,12,12,2,2,10,10,0,0,11,11,8,8,4,4,12,12,10,10,8,8,2,2,10,10,14,14,4,4,3,3,6,6,3,3,1,1,0,0,6,6,14,14,0,0,0,0,5,5,14,14,4,4,7,7,1,1,5,5,0,0,6,6,6,6,4,4,1,1,4,4,12,12,10,10,2,2,14,14,0,0,6,6,5,5,12,12,15,15,15,15,8,8,12,12,4,4,12,12,11,11,10,10,8,8,7,7,12,12,8,8,1,1,4,4,13,13,8,8,0,0,0,0,11,11,2,2,2,2,6,6,1,1,0,0,9,9,13,13,11,11,3,3,1,1,8,8,2,2,5,5,0,0,12,12,3,3,12,12,9,9,1,1,10,10,10,10,14,14,5,5,13,13,6,6,13,13,6,6,10,10,6,6,2,2,1,1,0,0,0,0,5,5,1,1,3,3,15,15,6,6,11,11,14,14,9,9,10,10,8,8,3,3,0,0,6,6,6,6,12,12,14,14,7,7,6,6,15,15,12,12,13,13,8,8,4,4,8,8,6,6,14,14,15,15,5,5,4,4,0,0,15,15,12,12,8,8,6,6,11,11,3,3,2,2,6,6,3,3,4,4,0,0,11,11,4,4,0,0,0,0,2,2,0,0,8,8,2,2,12,12,7,7,0,0,7,7,4,4,10,10,10,10,5,5,10,10,7,7,0,0,15,15,2,2,13,13,13,13,8,8,10,10,13,13,2,2,2,2,5,5,10,10,10,10,0,0,2,2,10,10,13,13,1,1,13,13,9,9,12,12,10,10,14,14,10,10,0,0,14,14,10,10,10,10,4,4,13,13,6,6,2,2,7,7,2,2,14,14,3,3,2,2,14,14,9,9,2,2,11,11,7,7,11,11,8,8,3,3,14,14,15,15,8,8,11,11,12,12,3,3,7,7,10,10,6,6,12,12,14,14,6,6,8,8,5,5,6,6,7,7,14,14,8,8,15,15,1,1,6,6,11,11,10,10,9,9,3,3,14,14,14,14,8,8,8,8,14,14,10,10,8,8,8,8,3,3,0,0,1,1,0,0,13,13,6,6,1,1,13,13,9,9,13,13,2,2,1,1,14,14,8,8,1,1,10,10,10,10,6,6,14,14,2,2,1,1,1,1,7,7,8,8,7,7,7,7,13,13,1,1,5,5,7,7,8,8,2,2,11,11,9,9,5,5,8,8,5,5,12,12,2,2,9,9,14,14,1,1,14,14,5,5,12,12,0,0,1,1,4,4,1,1,5,5,6,6,14,14,10,10,4,4,15,15,12,12,13,13,13,13,10,10,1,1,11,11,5,5,1,1,3,3,2,2,15,15,4,4,11,11,3,3,7,7,12,12,15,15,0,0,13,13,14,14,0,0,11,11,4,4,6,6,4,4,1,1,5,5,0,0,0,0,10,10,14,14,2,2,5,5,4,4,12,12,0,0,10,10,5,5,3,3,2,2,3,3,2,2,8,8,5,5,6,6,5,5,11,11,3,3,1,1,7,7,2,2,1,1,2,2,13,13,14,14,8,8,10,10,8,8,4,4,5,5,10,10,11,11,2,2,14,14,8,8,13,13,10,10,13,13,12,12,2,2,15,15,1,1,8,8,4,4,11,11,1,1,11,11,1,1,11,11,7,7,8,8,12,12,0,0,2,2,15,15,1,1,2,2,6,6,8,8,8,8,11,11,3,3,8,8,7,7,11,11,1,1,14,14,7,7,0,0,10,10,5,5,7,7,5,5,8,8,11,11,15,15,8,8,1,1,11,11,6,6,12,12,3,3,0,0,13,13,12,12,13,13,13,13,5,5,12,12,4,4,8,8,1,1,10,10,4,4,4,4,0,0,8,8,3,3,7,7,3,3,14,14,15,15,3,3,6,6,2,2,2,2,13,13,9,9,3,3,0,0,0,0,9,9,5,5,10,10,2,2,7,7,2,2,3,3,10,10,7,7,2,2,3,3,10,10,5,5,6,6,6,6,6,6,1,1,15,15,3,3,1,1,10,10,4,4,14,14,14,14,10,10,2,2,2,2,13,13,1,1,11,11,10,10,11,11,8,8,8,8,6,6,6,6,7,7,1,1,1,1,4,4,3,3,14,14,6,6,6,6,6,6,0,0,12,12,2,2,11,11,7,7,13,13,14,14,11,11,15,15,0,0,12,12,9,9,10,10,11,11,13,13,3,3,8,8,9,9,11,11,11,11,3,3,9,9,12,12,11,11,8,8,3,3,11,11,13,13,15,15,0,0,4,4,7,7,0,0,5,5,8,8,10,10,6,6,3,3,9,9,6,6,7,7,15,15,12,12,1,1,0,0,3,3,12,12,4,4,8,8,0,0,10,10,4,4,8,8,1,1,9,9,4,4,13,13,1,1,14,14,1,1,12,12,10,10,8,8,8,8,10,10,3,3,1,1,12,12,11,11,9,9,14,14,9,9,2,2,15,15,10,10,6,6,9,9,4,4,1,1,10,10,4,4,6,6,5,5,1,1,8,8,10,10,4,4,9,9,5,5,14,14,12,12,5,5,11,11,8,8,5,5,3,3,4,4,10,10,3,3,8,8,10,10,2,2,1,1,0,0,0,0,5,5,0,0,4,4,8,8,9,9,3,3,2,2,9,9,15,15,6,6,14,14,15,15,12,12,3,3,4,4,0,0,0,0,0,0,5,5,15,15,3,3,2,2,2,2,7,7,11,11,8,8,8,8,6,6,14,14,2,2,7,7,10,10,13,13,8,8,1,1,1,1,3,3,5,5,6,6,10,10,15,15,5,5,11,11,3,3,9,9,1,1,1,1,11,11,12,12,14,14,15,15,9,9,5,5,10,10,7,7,7,7,12,12,3,3,11,11,0,0,10,10,11,11,13,13,4,4,3,3,4,4,13,13,10,10,13,13,3,3,4,4,2,2,4,4,10,10,13,13,0,0,11,11,1,1,13,13,8,8,8,8,10,10,6,6,9,9,2,2,6,6,0,0,13,13,0,0,4,4,12,12,11,11,11,11,14,14,4,4,15,15,15,15,4,4,1,1,14,14,9,9,8,8,11,11,10,10,2,2,8,8,8,8,5,5,11,11,4,4,9,9,10,10,0,0,3,3,14,14,12,12,8,8,13,13,5,5,2,2,4,4,1,1,1,1,0,0,13,13,10,10,10,10,0,0,2,2,7,7,12,12,13,13,1,1,8,8,8,8,6,6,1,1,4,4,10,10,14,14,3,3,13,13,9,9,13,13,4,4,0,0,13,13,8,8,3,3,7,7,13,13,13,13,5,5,0,0,7,7,13,13,2,2,11,11,9,9,0,0,5,5,7,7,8,8,9,9,14,14,2,2,3,3,9,9,12,12,5,5,13,13,5,5,4,4,0,0,12,12,9,9,10,10,13,13,5,5,10,10,11,11,12,12,6,6,0,0,14,14,6,6,6,6,4,4,8,8,2,2,0,0,8,8,9,9,15,15,0,0,12,12,11,11,15,15,13,13,9,9,4,4,1,1,4,4,5,5,13,13,0,0,9,9,7,7,1,1,10,10,3,3,5,5,0,0,7,7,2,2,3,3,4,4,14,14,7,7,0,0,11,11,11,11,11,11,9,9,3,3,8,8,4,4,15,15,1,1,7,7,4,4,2,2,11,11,15,15,12,12,12,12,4,4,5,5,8,8,1,1,13,13,14,14,9,9,7,7,14,14,1,1,14,14,3,3,14,14,12,12,10,10,4,4,4,4,4,4,12,12,6,6,3,3,1,1,13,13,9,9,0,0,5,5,1,1,8,8,4,4,4,4,11,11,10,10,4,4,9,9,8,8,7,7,11,11,4,4,11,11,10,10,5,5,5,5,15,15,11,11,14,14,2,2,2,2,0,0,6,6,7,7,10,10,8,8,12,12,0,0,3,3,10,10,12,12,12,12,0,0,14,14,0,0,3,3,3,3,0,0,0,0,5,5,15,15,6,6,6,6,11,11,3,3,15,15,1,1,14,14,12,12,12,12,11,11,6,6,10,10,4,4,1,1,15,15,1,1,6,6,1,1,6,6,0,0,12,12,10,10,14,14,6,6,12,12,4,4,12,12,13,13,12,12,3,3,3,3,15,15,11,11,8,8,11,11,6,6,8,8,7,7,9,9,4,4,8,8,9,9,5,5,14,14,2,2,7,7,0,0,3,3,10,10,15,15,0,0,0,0,0,0,1,1,15,15,1,1,1,1,4,4,13,13,8,8,4,4,1,1,0,0,11,11,14,14,6,6,8,8,8,8,8,8,10,10,8,8,13,13,14,14,4,4,0,0,13,13,1,1,2,2,4,4,4,4,8,8,7,7,10,10,9,9,5,5,13,13,15,15,10,10,1,1,9,9,9,9,11,11,6,6,8,8,14,14,10,10,2,2,8,8,13,13,11,11,2,2,7,7,0,0,5,5,1,1,11,11,10,10,10,10,8,8,12,12,4,4,7,7,3,3,1,1,8,8,9,9,1,1,5,5,13,13,11,11,15,15,14,14,0,0,8,8,11,11,15,15,1,1,12,12,7,7,7,7,6,6,12,12,6,6,12,12,14,14,8,8,10,10,3,3,4,4,5,5,3,3,11,11,6,6,1,1,12,12,12,12,8,8,7,7,4,4,7,7,5,5,9,9,0,0,10,10,8,8,5,5,4,4,4,4,2,2,6,6,7,7,11,11,12,12,5,5,2,2,5,5,0,0,4,4,6,6,0,0,0,0,11,11,6,6,6,6,9,9,8,8,2,2,1,1,3,3,5,5,9,9,6,6,13,13,4,4,6,6,0,0,5,5,8,8,3,3,0,0,9,9,0,0,14,14,9,9,15,15,13,13,9,9,0,0,12,12,11,11,4,4,12,12,11,11,0,0,10,10,7,7,13,13,6,6,5,5,10,10,12,12,15,15,5,5,2,2,13,13,6,6,3,3,8,8,7,7,11,11,9,9,11,11,7,7,15,15,5,5,12,12,3,3,0,0,12,12,15,15,14,14,14,14,0,0,0,0,0,0,10,10,8,8,15,15,7,7,2,2,9,9,5,5,6,6,4,4,3,3,4,4,9,9,9,9,6,6,6,6,2,2,3,3,10,10,8,8,3,3,3,3,7,7,5,5,11,11,6,6,5,5,7,7,0,0,12,12,13,13,2,2,12,12,7,7,5,5,6,6,1,1,12,12,8,8,3,3,14,14,3,3,8,8,14,14,11,11,12,12,2,2,15,15,8,8,10,10,0,0,5,5,12,12,6,6,3,3,12,12,2,2,4,4,14,14,11,11,13,13,12,12,6,6,14,14,0,0,4,4,0,0,5,5,11,11,1,1,5,5,1,1,13,13,8,8,9,9,1,1,15,15,12,12,5,5,5,5,11,11,13,13,8,8,12,12,1,1,0,0,11,11,6,6,11,11,12,12,5,5,8,8,2,2,14,14,0,0,6,6,7,7,6,6,3,3,15,15,1,1,13,13,0,0,11,11,9,9,10,10,5,5,3,3,15,15,0,0,12,12,3,3,7,7,7,7,15,15,11,11,2,2,10,10,11,11,0,0,1,1,8,8,8,8,14,14,12,12,1,1,3,3,8,8,8,8,4,4,5,5,0,0,2,2,10,10,2,2,13,13,13,13,7,7,8,8,1,1,7,7,5,5,6,6,3,3,4,4,1,1,10,10,3,3,12,12,4,4,0,0,2,2,8,8,15,15,15,15,12,12,2,2,6,6,10,10,7,7,9,9,8,8,0,0,9,9,2,2,4,4,13,13,6,6,1,1,9,9,5,5,5,5,9,9,3,3,15,15,12,12,10,10,0,0,2,2,9,9,12,12,12,12,1,1,15,15,10,10,13,13,7,7,3,3,9,9,2,2,3,3,6,6,10,10,4,4,13,13,8,8,14,14,1,1,5,5,14,14,6,6,0,0,14,14,2,2,12,12,7,7,4,4,4,4,10,10,15,15,11,11,0,0,6,6,4,4,11,11,10,10,3,3,7,7,8,8,8,8,13,13,1,1,10,10,12,12,3,3,0,0,13,13,12,12,12,12,9,9,7,7,11,11,2,2,3,3,8,8,3,3,10,10,5,5,7,7,4,4,11,11,15,15,12,12,5,5,4,4,5,5,11,11,6,6,10,10,10,10,12,12,3,3,2,2,0,0,5,5,8,8,14,14,3,3,12,12,15,15,3,3,10,10,8,8,1,1,2,2,8,8,0,0,2,2,3,3,8,8,10,10,1,1,6,6,4,4,2,2,10,10,1,1,2,2,15,15,7,7,4,4,12,12,12,12,0,0,10,10,10,10,2,2,4,4,7,7,15,15,5,5,1,1,15,15,3,3,2,2,1,1,13,13,15,15,13,13,12,12,9,9,10,10,12,12,1,1,2,2,2,2,15,15,8,8,0,0,13,13,2,2,10,10,2,2,12,12,6,6,8,8,0,0,10,10,10,10,1,1,12,12,1,1,12,12,7,7,10,10,11,11,12,12,13,13,12,12,5,5,8,8,13,13,6,6,13,13,6,6,10,10,8,8,6,6,5,5,0,0,3,3,11,11,3,3,4,4,8,8,6,6,1,1,15,15,14,14,9,9,7,7,12,12,12,12,13,13,2,2,1,1,6,6,3,3,13,13,13,13,10,10,0,0,13,13,4,4,9,9,15,15,8,8,2,2,2,2,4,4,2,2,3,3,8,8,8,8,13,13,11,11,11,11,5,5,10,10,1,1,8,8,0,0,8,8,12,12,10,10,8,8,13,13,6,6,11,11,15,15,6,6,13,13,1,1,5,5,12,12,2,2,10,10,11,11,5,5,2,2,8,8,8,8,0,0,1,1,12,12,1,1,12,12,12,12,13,13,5,5,6,6,3,3,0,0,3,3,13,13,4,4,5,5,4,4,6,6,7,7,9,9,12,12,6,6,0,0,12,12,8,8,10,10,13,13,0,0,13,13,10,10,0,0,0,0,0,0,9,9,15,15,14,14,3,3,15,15,9,9,1,1,0,0,4,4,7,7,7,7,4,4,15,15,0,0,15,15,10,10,0,0,4,4,8,8,2,2,11,11,5,5,9,9,3,3,4,4,10,10,7,7,8,8,0,0,12,12,7,7,1,1,11,11,5,5,11,11,3,3,2,2,10,10,0,0,0,0,13,13,11,11,4,4,4,4,6,6,8,8,11,11,9,9,8,8,4,4,5,5,9,9,11,11,11,11,12,12,15,15,5,5,10,10,8,8,0,0,8,8,10,10,3,3,5,5,15,15,0,0,11,11,8,8,10,10,6,6,11,11,5,5,5,5,2,2,0,0,8,8,3,3,9,9,13,13,5,5,5,5,4,4,15,15,1,1,5,5,6,6,7,7,1,1,8,8,5,5,8,8,11,11,12,12,8,8,15,15,0,0,8,8,1,1,4,4,3,3,4,4,11,11,13,13,1,1,12,12,8,8,10,10,12,12,1,1,4,4,1,1,7,7,0,0,8,8,4,4,13,13,4,4,5,5,7,7,3,3,5,5,10,10,8,8,13,13,8,8,11,11,4,4,15,15,3,3,14,14,11,11,9,9,10,10,4,4,14,14,1,1,13,13,10,10,4,4,3,3,4,4,3,3,4,4,3,3,6,6,4,4,2,2,1,1,1,1,10,10,6,6,9,9,2,2,3,3,9,9,15,15,9,9,3,3,12,12,5,5,7,7,11,11,2,2,11,11,12,12,14,14,3,3,15,15,12,12,3,3,6,6,0,0,9,9,13,13,12,12,1,1,0,0,12,12,15,15,8,8,4,4,5,5,9,9,5,5,3,3,2,2,0,0,12,12,1,1,14,14,2,2,3,3,4,4,8,8,15,15,9,9,14,14,9,9,9,9,5,5,11,11,1,1,0,0,15,15,13,13,12,12,14,14,1,1,0,0,5,5,4,4,4,4,6,6,6,6,9,9,2,2,10,10,12,12,5,5,3,3,9,9,4,4,4,4,0,0,6,6,10,10,14,14,10,10,13,13,13,13,13,13,14,14,5,5,3,3,0,0,11,11,12,12,11,11,9,9,1,1,0,0,0,0,0,0,2,2,11,11,14,14,9,9,1,1,4,4,14,14,6,6,4,4,1,1,2,2,6,6,4,4,12,12,13,13,0,0,1,1,9,9,3,3,13,13,4,4,6,6,1,1,1,1,15,15,4,4,8,8,0,0,15,15,12,12,4,4,8,8,4,4,9,9,7,7,5,5,7,7,8,8,3,3,9,9,6,6,8,8,5,5,1,1,6,6,12,12,8,8,12,12,14,14,3,3,12,12,3,3,0,0,15,15,13,13,4,4,9,9,2,2,2,2,0,0,11,11,12,12,4,4,3,3,6,6,13,13,2,2,14,14,1,1,8,8,13,13,12,12,5,5,2,2,8,8,5,5,7,7,3,3,3,3,7,7,15,15,10,10,10,10,12,12,5,5,3,3,0,0,3,3,3,3,3,3,6,6,10,10,13,13,9,9,1,1,1,1,10,10,10,10,12,12,4,4,7,7,14,14,12,12,15,15,5,5,9,9,3,3,6,6,0,0,13,13,14,14,12,12,11,11,8,8,14,14,8,8,10,10,4,4,7,7,7,7,8,8,11,11,10,10,9,9,6,6,15,15,5,5,1,1,3,3,12,12,4,4,6,6,6,6,2,2,6,6,1,1,12,12,9,9,15,15,11,11,8,8,15,15,14,14,0,0,15,15,6,6,4,4,11,11,11,11,1,1,6,6,3,3,11,11,3,3,12,12,4,4,0,0,2,2,1,1,7,7,2,2,2,2,9,9,5,5,14,14,2,2,3,3,13,13,6,6,6,6,12,12,15,15,15,15,4,4,9,9,13,13,3,3,10,10,6,6,12,12,12,12,15,15,9,9,4,4,2,2,9,9,4,4,13,13,14,14,3,3,6,6,11,11,14,14,5,5,13,13,7,7,8,8,11,11,0,0,13,13,12,12,13,13,10,10,4,4,14,14,14,14,0,0,12,12,14,14,15,15,9,9,14,14,10,10,11,11,6,6,0,0,4,4,4,4,11,11,6,6,4,4,0,0,10,10,6,6,12,12,0,0,10,10,11,11,8,8,14,14,8,8,9,9,15,15,1,1,9,9,6,6,4,4,15,15,0,0,2,2,14,14,4,4,13,13,5,5,5,5,11,11,12,12,4,4,13,13,3,3,11,11,5,5,7,7,1,1,1,1,10,10,3,3,6,6,0,0,1,1,10,10,10,10,6,6,5,5,9,9,9,9,8,8,3,3,7,7,12,12,1,1,10,10,6,6,10,10,6,6,8,8,12,12,8,8,12,12,5,5,1,1,8,8,8,8,10,10,3,3,5,5,2,2,14,14,2,2,15,15,12,12,14,14,12,12,3,3,8,8,11,11,3,3,3,3,4,4,15,15,15,15,10,10,6,6,11,11,7,7,14,14,0,0,1,1,10,10,2,2,2,2,14,14,8,8,9,9,12,12,13,13,7,7,0,0,9,9,10,10,8,8,10,10,13,13,10,10,1,1,2,2,13,13,10,10,6,6,1,1,4,4,9,9,7,7,1,1,2,2,9,9,5,5,8,8,8,8,15,15,8,8,2,2,8,8,12,12,10,10,3,3,2,2,9,9,13,13,4,4,13,13,6,6,14,14,13,13,0,0,10,10,14,14,15,15,5,5,3,3,4,4,4,4,6,6,0,0,6,6,0,0,12,12,0,0,4,4,7,7,9,9,3,3,14,14,2,2,9,9,8,8,8,8,13,13,1,1,2,2,12,12,7,7,8,8,9,9,0,0,3,3,11,11,2,2,2,2,0,0,2,2,5,5,7,7,10,10,13,13,13,13,4,4,1,1,15,15,5,5,10,10,7,7,10,10,9,9,11,11,6,6,12,12,10,10,1,1,6,6,1,1,14,14,11,11,6,6,6,6,2,2,4,4,11,11,7,7,11,11,4,4,3,3,5,5,6,6,10,10,7,7,15,15,6,6,0,0,3,3,13,13,11,11,6,6,12,12,2,2,7,7,2,2,14,14,11,11,13,13,12,12,3,3,15,15,9,9,8,8,15,15,7,7,0,0,8,8,13,13,5,5,7,7,5,5,2,2,6,6,6,6,11,11,7,7,2,2,8,8,10,10,7,7,0,0,14,14,5,5,14,14,4,4,13,13,13,13,9,9,14,14,4,4,4,4,1,1,9,9,12,12,14,14,1,1,11,11,12,12,8,8,6,6,11,11,10,10,14,14,13,13,2,2,15,15,2,2,13,13,1,1,3,3,1,1,1,1,6,6,15,15,10,10,2,2,10,10,2,2,2,2,7,7,4,4,15,15,1,1,2,2,15,15,12,12,9,9,13,13,12,12,7,7,0,0,3,3,13,13,15,15,11,11,4,4,5,5,8,8,10,10,7,7,0,0,13,13,0,0,3,3,14,14,2,2,4,4,15,15,15,15,1,1,0,0,13,13,4,4,15,15,14,14,11,11,14,14,13,13,9,9,12,12,2,2,10,10,2,2,14,14,1,1,10,10,0,0,0,0,12,12,1,1,7,7,2,2,12,12,7,7,9,9,6,6,4,4,14,14,14,14,11,11,9,9,9,9,7,7,12,12,12,12,3,3,10,10,7,7,7,7,13,13,8,8,7,7,11,11,6,6,5,5,13,13,6,6,7,7,10,10,0,0,7,7,8,8,9,9,14,14,1,1,2,2,12,12,2,2,10,10,8,8,8,8,1,1,4,4,1,1,1,1,7,7,9,9,2,2,12,12,0,0,0,0,13,13,7,7,14,14,5,5,8,8,14,14,8,8,11,11,3,3,7,7,12,12,14,14,6,6,12,12,6,6,1,1,7,7,3,3,12,12,9,9,7,7,0,0,0,0,8,8,2,2,15,15,14,14,5,5,1,1,0,0,11,11,13,13,12,12,0,0,5,5,14,14,7,7,15,15,0,0,15,15,3,3,2,2,8,8,3,3,4,4,8,8,2,2,4,4,13,13,1,1,11,11,14,14,7,7,6,6,8,8,2,2,4,4,3,3,7,7,5,5,15,15,0,0,10,10,8,8,10,10,7,7,4,4,2,2,7,7,2,2,6,6,2,2,8,8,5,5,11,11,11,11,6,6,14,14,3,3,1,1,15,15,0,0,12,12,6,6,4,4,4,4,13,13,4,4,9,9,6,6,1,1,10,10,6,6,2,2,4,4,13,13,12,12,14,14,11,11,14,14,14,14,5,5,9,9,15,15,8,8,15,15,14,14,10,10,14,14,6,6,11,11,15,15,5,5,12,12,9,9,0,0,8,8,9,9,7,7,14,14,4,4,3,3,8,8,4,4,7,7,8,8,5,5,15,15,0,0,7,7,6,6,6,6,10,10,10,10,8,8,1,1,3,3,15,15,2,2,7,7,15,15,10,10,8,8,3,3,14,14,2,2,10,10,0,0,3,3,4,4,0,0,5,5,9,9,2,2,4,4,6,6,3,3,8,8,9,9,2,2,2,2,14,14,2,2,10,10,14,14,4,4,5,5,6,6,15,15,3,3,6,6,2,2,3,3,7,7,2,2,0,0,6,6,11,11,15,15,1,1,9,9,6,6,2,2,13,13,1,1,9,9,14,14,0,0,7,7,1,1,6,6,12,12,3,3,11,11,8,8,3,3,0,0,14,14,12,12,11,11,0,0,8,8,13,13,9,9,13,13,7,7,6,6,3,3,10,10,6,6,4,4,10,10,0,0,5,5,0,0,5,5,14,14,0,0,4,4,14,14,5,5,7,7,8,8,6,6,8,8,1,1,10,10,1,1,3,3,9,9,0,0,14,14,4,4,4,4,14,14,7,7,3,3,11,11,2,2,6,6,12,12,15,15,11,11,14,14,5,5,15,15,3,3,4,4,9,9,7,7,10,10,7,7,14,14,10,10,11,11,6,6,0,0,14,14,8,8,0,0,7,7,14,14,7,7,13,13,9,9,8,8,7,7,5,5,1,1,4,4,1,1,3,3,9,9,0,0,13,13,6,6,12,12,6,6,10,10,5,5,2,2,10,10,15,15,4,4,3,3,4,4,13,13,9,9,9,9,9,9,6,6,0,0,3,3,12,12,9,9,0,0,7,7,8,8,12,12,3,3,1,1,1,1,2,2,0,0,0,0,4,4,6,6,0,0,0,0,12,12,1,1,2,2,8,8,14,14,2,2,0,0,11,11,6,6,4,4,13,13,9,9,5,5,0,0,15,15,12,12,4,4,5,5,15,15,15,15,9,9,9,9,1,1,2,2,2,2,10,10,8,8,8,8,6,6,1,1,1,1,8,8,0,0,11,11,8,8,13,13,5,5,7,7,7,7,8,8,7,7,8,8,9,9,14,14,1,1,13,13,11,11,2,2,3,3,14,14,1,1,5,5,13,13,7,7,1,1,13,13,3,3,3,3,1,1,5,5,8,8,5,5,4,4,1,1,0,0,1,1,15,15,3,3,8,8,11,11,12,12,8,8,5,5,3,3,3,3,3,3,9,9,8,8,9,9,9,9,15,15,15,15,3,3,7,7,10,10,7,7,8,8,10,10,5,5,6,6,6,6,0,0,9,9,9,9,2,2,6,6,11,11,15,15,5,5,11,11,4,4,12,12,9,9,3,3,9,9,13,13,0,0,2,2,13,13,15,15,14,14,6,6,4,4,4,4,3,3,4,4,1,1,15,15,9,9,11,11,8,8,4,4,7,7,9,9,5,5,1,1,10,10,5,5,3,3,3,3,15,15,6,6,9,9,7,7,12,12,0,0,2,2,12,12,11,11,1,1,12,12,1,1,13,13,12,12,6,6,3,3,1,1,12,12,1,1,11,11,12,12,2,2,10,10,4,4,3,3,5,5,3,3,5,5,6,6,15,15,2,2,11,11,12,12,6,6,4,4,12,12,0,0,1,1,7,7,13,13,9,9,5,5,10,10,15,15,6,6,3,3,5,5,14,14,7,7,1,1,0,0,3,3,11,11,7,7,1,1,6,6,13,13,13,13,14,14,4,4,14,14,2,2,1,1,13,13,8,8,0,0,14,14,0,0,0,0,15,15,7,7,4,4,4,4,13,13,9,9,2,2,5,5,1,1,8,8,9,9,5,5,15,15,7,7,4,4,10,10,4,4,13,13,10,10,9,9,2,2,2,2,0,0,9,9,14,14,10,10,15,15,12,12,13,13,7,7,7,7,7,7,10,10,9,9,6,6,1,1,14,14,12,12,13,13,15,15,6,6,7,7,4,4,1,1,9,9,15,15,11,11,7,7,9,9,6,6,0,0,12,12,2,2,6,6,12,12,9,9,15,15,9,9,8,8,13,13,9,9,4,4,0,0,1,1,3,3,9,9,11,11,11,11,6,6,6,6,6,6,10,10,4,4,14,14,11,11,9,9,10,10,1,1,4,4,9,9,2,2,8,8,3,3,11,11,2,2,13,13,13,13,0,0,0,0,5,5,8,8,1,1,12,12,15,15,15,15,11,11,2,2,13,13,14,14,5,5,11,11,5,5,8,8,12,12,6,6,7,7,6,6,3,3,9,9,0,0,14,14,15,15,12,12,8,8,2,2,4,4,5,5,2,2,8,8,14,14,5,5,14,14,8,8,4,4,10,10,10,10,1,1,11,11,0,0,7,7,11,11,3,3,2,2,13,13,6,6,10,10,8,8,11,11,8,8,2,2,8,8,9,9,14,14,15,15,4,4,13,13,12,12,4,4,2,2,3,3,2,2,13,13,8,8,10,10,15,15,7,7,14,14,7,7,7,7,0,0,5,5,2,2,4,4,15,15,11,11,12,12,4,4,3,3,6,6,8,8,11,11,9,9,1,1,1,1,4,4,13,13,0,0,10,10,15,15,14,14,12,12,1,1,2,2,11,11,10,10,12,12,1,1,9,9,11,11,13,13,14,14,8,8,10,10,9,9,11,11,15,15,8,8,9,9,9,9,2,2,11,11,10,10,7,7,15,15,8,8,9,9,11,11,1,1,9,9,11,11,15,15,10,10,1,1,14,14,14,14,11,11,15,15,1,1,15,15,12,12,2,2,3,3,4,4,4,4,9,9,4,4,5,5,0,0,7,7,4,4,2,2,5,5,12,12,8,8,1,1,1,1,10,10,15,15,2,2,5,5,6,6,5,5,8,8,12,12,1,1,1,1,5,5,8,8,5,5,2,2,12,12,10,10,7,7,4,4,11,11,10,10,9,9,11,11,6,6,2,2,9,9,6,6,14,14,12,12,8,8,2,2,4,4,11,11,2,2,1,1,12,12,12,12,1,1,12,12,10,10,7,7,0,0,3,3,9,9,8,8,10,10,14,14,6,6,10,10,4,4,12,12,0,0,6,6,12,12,5,5,3,3,15,15,15,15,1,1,7,7,15,15,10,10,13,13,10,10,13,13,14,14,8,8,4,4,0,0,2,2,9,9,14,14,0,0,4,4,4,4,15,15,13,13,10,10,2,2,0,0,12,12,13,13,10,10,5,5,2,2,6,6,4,4,4,4,10,10,0,0,0,0,11,11,3,3,6,6,13,13,4,4,8,8,4,4,1,1,10,10,14,14,15,15,0,0,9,9,12,12,4,4,1,1,8,8,14,14,13,13,5,5,9,9,14,14,2,2,8,8,0,0,10,10,8,8,6,6,0,0,8,8,10,10,6,6,4,4,15,15,4,4,5,5,15,15,13,13,15,15,13,13,2,2,10,10,10,10,4,4,10,10,12,12,13,13,2,2,10,10,1,1,5,5,5,5,3,3,15,15,2,2,7,7,15,15,2,2,3,3,0,0,15,15,12,12,0,0,14,14,13,13,11,11,6,6,1,1,1,1,11,11,3,3,1,1,8,8,9,9,6,6,14,14,11,11,12,12,7,7,2,2,4,4,0,0,3,3,2,2,5,5,1,1,4,4,0,0,8,8,7,7,3,3,4,4,4,4,1,1,14,14,6,6,4,4,1,1,0,0,7,7,3,3,12,12,2,2,5,5,5,5,11,11,7,7,0,0,13,13,11,11,0,0,15,15,5,5,5,5,2,2,10,10,8,8,14,14,9,9,8,8,9,9,13,13,15,15,14,14,15,15,4,4,6,6,4,4,12,12,7,7,10,10,9,9,6,6,7,7,12,12,4,4,6,6,0,0,4,4,6,6,6,6,3,3,4,4,13,13,12,12,9,9,2,2,13,13,2,2,15,15,6,6,13,13,9,9,4,4,0,0,10,10,12,12,15,15,10,10,5,5,0,0,0,0,7,7,3,3,3,3,9,9,11,11,9,9,14,14,9,9,10,10,1,1,9,9,11,11,6,6,2,2,14,14,9,9,7,7,6,6,0,0,7,7,13,13,0,0,9,9,13,13,9,9,13,13,0,0,9,9,14,14,11,11,14,14,0,0,1,1,11,11,10,10,3,3,10,10,0,0,15,15,10,10,6,6,9,9,10,10,7,7,9,9,3,3,2,2,4,4,3,3,12,12,6,6,7,7,4,4,13,13,13,13,13,13,14,14,7,7,3,3,10,10,9,9,12,12,11,11,2,2,7,7,4,4,9,9,2,2,6,6,9,9,3,3,5,5,7,7,3,3,9,9,4,4,5,5,12,12,0,0,12,12,1,1,4,4,12,12,4,4,0,0,13,13,8,8,6,6,5,5,7,7,2,2,5,5,0,0,2,2,3,3,6,6,2,2,13,13,15,15,9,9,13,13,3,3,8,8,11,11,14,14,3,3,0,0,3,3,1,1,0,0,5,5,10,10,13,13,9,9,11,11,8,8,4,4,10,10,11,11,10,10,5,5,14,14,0,0,0,0,5,5,0,0,10,10,12,12,0,0,15,15,12,12,8,8,0,0,7,7,7,7,7,7,4,4,11,11,15,15,8,8,13,13,0,0,9,9,8,8,7,7,14,14,11,11,4,4,4,4,6,6,9,9,8,8,3,3,2,2,1,1,12,12,2,2,6,6,5,5,1,1,4,4,5,5,4,4,13,13,12,12,14,14,1,1,12,12,13,13,3,3,12,12,9,9,12,12,15,15,5,5,6,6,10,10,1,1,3,3,5,5,6,6,5,5,1,1,12,12,3,3,6,6,5,5,6,6,12,12,14,14,14,14,10,10,9,9,0,0,12,12,6,6,12,12,13,13,12,12,6,6,15,15,10,10,15,15,14,14,4,4,13,13,5,5,7,7,13,13,13,13,7,7,8,8,15,15,2,2,11,11,6,6,6,6,1,1,12,12,2,2,4,4,4,4,2,2,9,9,2,2,8,8,2,2,15,15,8,8,4,4,14,14,11,11,11,11,13,13,14,14,15,15,13,13,10,10,14,14,1,1,3,3,15,15,3,3,12,12,10,10,14,14,9,9,9,9,0,0,5,5,15,15,3,3,1,1,5,5,2,2,12,12,4,4,13,13,10,10,7,7,4,4,0,0,2,2,3,3,9,9,8,8,6,6,9,9,9,9,5,5,9,9,15,15,14,14,1,1,9,9,9,9,7,7,12,12,3,3,6,6,0,0,2,2,3,3,0,0,12,12,12,12,9,9,14,14,9,9,14,14,6,6,14,14,7,7,15,15,15,15,3,3,1,1,9,9,10,10,3,3,12,12,13,13,1,1,5,5,6,6,15,15,6,6,15,15,5,5,3,3,7,7,9,9,6,6,6,6,1,1,13,13,12,12,13,13,1,1,2,2,1,1,5,5,2,2,0,0,9,9,7,7,0,0,0,0,6,6,4,4,5,5,13,13,9,9,2,2,12,12,9,9,15,15,14,14,0,0,15,15,10,10,5,5,4,4,7,7,9,9,14,14,12,12,11,11,12,12,7,7,9,9,13,13,6,6,13,13,9,9,14,14,10,10,5,5,5,5,1,1,6,6,5,5,13,13,2,2,6,6,13,13,9,9,12,12,4,4,9,9,1,1,7,7,11,11,2,2,3,3,2,2,14,14,0,0,9,9,7,7,13,13,12,12,10,10,2,2,6,6,8,8,12,12,0,0,14,14,8,8,2,2,8,8,4,4,9,9,6,6,10,10,0,0,1,1,4,4,12,12,13,13,9,9,10,10,1,1,1,1,4,4,1,1,12,12,2,2,11,11,7,7,0,0,0,0,12,12,0,0,12,12,15,15,9,9,0,0,6,6,12,12,11,11,10,10,10,10,14,14,3,3,13,13,9,9,9,9,15,15,4,4,11,11,0,0,12,12,9,9,5,5,4,4,5,5,0,0,14,14,11,11,9,9,1,1,5,5,2,2,10,10,5,5,15,15,10,10,9,9,0,0,9,9,8,8,10,10,8,8,14,14,10,10,10,10,9,9,14,14,13,13,14,14,9,9,1,1,8,8,10,10,1,1,1,1,6,6,3,3,7,7,14,14,3,3,6,6,8,8,4,4,4,4,3,3,8,8,8,8,3,3,12,12,11,11,11,11,3,3,3,3,9,9,10,10,15,15,7,7,13,13,0,0,14,14,1,1,10,10,3,3,2,2,1,1,10,10,10,10,15,15,11,11,3,3,4,4,3,3,0,0,2,2,2,2,6,6,6,6,1,1,9,9,7,7,0,0,10,10,3,3,5,5,15,15,2,2,4,4,4,4,13,13,12,12,4,4,1,1,11,11,6,6,9,9,2,2,5,5,4,4,2,2,5,5,2,2,6,6,2,2,0,0,15,15,10,10,0,0,2,2,0,0,10,10,5,5,14,14,10,10,1,1,4,4,5,5,13,13,7,7,12,12,3,3,8,8,2,2,4,4,8,8,4,4,6,6,2,2,8,8,8,8,12,12,2,2,0,0,14,14,6,6,2,2,7,7,6,6,5,5,0,0,2,2,13,13,3,3,4,4,13,13,0,0,5,5,9,9,15,15,12,12,11,11,2,2,10,10,10,10,3,3,9,9,9,9,4,4,0,0,13,13,7,7,3,3,7,7,11,11,3,3,8,8,3,3,2,2,12,12,3,3,10,10,9,9,10,10,11,11,0,0,10,10,2,2,5,5,3,3,4,4,4,4,2,2,7,7,13,13,8,8,0,0,4,4,13,13,15,15,14,14,10,10,15,15,0,0,4,4,1,1,8,8,14,14,3,3,8,8,7,7,1,1,0,0,14,14,1,1,1,1,1,1,13,13,9,9,9,9,3,3,8,8,10,10,4,4,0,0,1,1,8,8,13,13,10,10,12,12,7,7,10,10,9,9,11,11,0,0,3,3,5,5,12,12,6,6,8,8,13,13,13,13,1,1,0,0,4,4,12,12,7,7,13,13,4,4,2,2,4,4,5,5,1,1,1,1,5,5,4,4,3,3,6,6,12,12,10,10,9,9,11,11,8,8,6,6,11,11,15,15,15,15,15,15,0,0,14,14,10,10,3,3,0,0,4,4,8,8,5,5,13,13,1,1,7,7,13,13,2,2,8,8,11,11,10,10,9,9,8,8,5,5,0,0,13,13,9,9,15,15,11,11,9,9,4,4,6,6,10,10,5,5,0,0,13,13,4,4,7,7,0,0,4,4,5,5,14,14,1,1,3,3,0,0,12,12,13,13,11,11,14,14,4,4,3,3,6,6,2,2,4,4,14,14,1,1,8,8,15,15,13,13,2,2,7,7,15,15,10,10,8,8,11,11,2,2,10,10,14,14,12,12,11,11,15,15,2,2,15,15,6,6,8,8,15,15,14,14,5,5,11,11,14,14,13,13,7,7,12,12,9,9,6,6,11,11,9,9,2,2,5,5,8,8,6,6,12,12,12,12,9,9,14,14,8,8,15,15,15,15,11,11,13,13,12,12,7,7,1,1,6,6,10,10,9,9,5,5,2,2,4,4,9,9,0,0,9,9,10,10,15,15,5,5,10,10,1,1,4,4,8,8,3,3,4,4,14,14,13,13,1,1,13,13,15,15,1,1,12,12,1,1,7,7,4,4,14,14,3,3,5,5,4,4,13,13,8,8,2,2,3,3,10,10,13,13,15,15,10,10,0,0,12,12,4,4,0,0,4,4,3,3,12,12,2,2,1,1,13,13,5,5,13,13,14,14,12,12,3,3,3,3,4,4,7,7,10,10,11,11,4,4,10,10,3,3,9,9,3,3,10,10,3,3,8,8,14,14,14,14,2,2,2,2,7,7,3,3,0,0,10,10,0,0,2,2,7,7,4,4,0,0,1,1,1,1,11,11,11,11,4,4,4,4,4,4,6,6,10,10,4,4,7,7,4,4,0,0,4,4,5,5,3,3,1,1,12,12,12,12,7,7,6,6,8,8,6,6,6,6,1,1,4,4,15,15,1,1,4,4,1,1,6,6,5,5,1,1,8,8,3,3,6,6,7,7,10,10,1,1,0,0,3,3,8,8,2,2,4,4,0,0,14,14,7,7,4,4,0,0,14,14,8,8,7,7,0,0,2,2,8,8,15,15,2,2,13,13,14,14,8,8,3,3,1,1,9,9,11,11,8,8,8,8,3,3,13,13,5,5,10,10,0,0,10,10,14,14,8,8,3,3,8,8,10,10,12,12,0,0,4,4,8,8,11,11,7,7,7,7,10,10,5,5,6,6,8,8,7,7,12,12,15,15,9,9,10,10,9,9,6,6,0,0,5,5,12,12,12,12,2,2,7,7,7,7,10,10,10,10,12,12,0,0,3,3,0,0,12,12,2,2,14,14,12,12,3,3,2,2,5,5,5,5,15,15,3,3,3,3,0,0,6,6,6,6,8,8,10,10,12,12,9,9,13,13,8,8,4,4,5,5,4,4,6,6,2,2,4,4,5,5,5,5,4,4,0,0,10,10,11,11,2,2,4,4,2,2,3,3,5,5,0,0,6,6,7,7,5,5,6,6,5,5,6,6,6,6,0,0,0,0,10,10,1,1,9,9,15,15,3,3,11,11,10,10,4,4,13,13,2,2,2,2,8,8,5,5,1,1,0,0,8,8,12,12,12,12,2,2,10,10,12,12,6,6,8,8,10,10,7,7,12,12,4,4,3,3,6,6,4,4,15,15,3,3,0,0,7,7,5,5,3,3,1,1,5,5,14,14,8,8,9,9,0,0,12,12,13,13,2,2,5,5,3,3,4,4,7,7,1,1,10,10,10,10,2,2,4,4,10,10,9,9,4,4,3,3,11,11,15,15,12,12,7,7,0,0,6,6,15,15,7,7,9,9,4,4,3,3,12,12,2,2,0,0,5,5,15,15,6,6,5,5,10,10,11,11,0,0,7,7,0,0,0,0,7,7,10,10,10,10,8,8,11,11,13,13,2,2,1,1,4,4,14,14,3,3,13,13,4,4,15,15,10,10,0,0,2,2,11,11,2,2,10,10,14,14,3,3,12,12,11,11,0,0,12,12,2,2,4,4,3,3,5,5,7,7,15,15,5,5,7,7,13,13,8,8,14,14,11,11,1,1,1,1,12,12,2,2,14,14,6,6,1,1,8,8,0,0,9,9,1,1,6,6,7,7,4,4,8,8,13,13,12,12,8,8,13,13,4,4,2,2,3,3,11,11,13,13,3,3,10,10,4,4,15,15,15,15,5,5,14,14,7,7,0,0,6,6,11,11,8,8,4,4,6,6,14,14,12,12,14,14,1,1,12,12,1,1,9,9,5,5,8,8,2,2,0,0,0,0,6,6,7,7,8,8,7,7,9,9,15,15,4,4,4,4,13,13,2,2,1,1,2,2,5,5,15,15,13,13,3,3,8,8,4,4,4,4,4,4,6,6,4,4,11,11,13,13,7,7,5,5,10,10,8,8,1,1,10,10,8,8,9,9,9,9,12,12,6,6,12,12,12,12,4,4,8,8,3,3,2,2,2,2,8,8,12,12,14,14,11,11,2,2,8,8,5,5,6,6,11,11,12,12,13,13,1,1,11,11,0,0,10,10,8,8,14,14,10,10,2,2,9,9,0,0,7,7,0,0,0,0,3,3,15,15,2,2,2,2,14,14,4,4,5,5,2,2,7,7,10,10,9,9,4,4,9,9,2,2,12,12,3,3,9,9,13,13,5,5,11,11,7,7,12,12,8,8,2,2,5,5,3,3,7,7,4,4,14,14,3,3,12,12,1,1,6,6,2,2,12,12,8,8,6,6,11,11,7,7,12,12,1,1,12,12,14,14,11,11,12,12,0,0,2,2,0,0,11,11,6,6,11,11,2,2,0,0,0,0,10,10,3,3,4,4,9,9,7,7,11,11,11,11,12,12,0,0,8,8,6,6,4,4,9,9,6,6,10,10,10,10,15,15,11,11,15,15,8,8,1,1,10,10,12,12,15,15,7,7,9,9,11,11,9,9,12,12,5,5,12,12,15,15,9,9,14,14,9,9,10,10,0,0,8,8,14,14,4,4,12,12,5,5,2,2,9,9,15,15,11,11,13,13,6,6,5,5,13,13,13,13,7,7,9,9,3,3,4,4,5,5,12,12,12,12,6,6,9,9,8,8,12,12,2,2,8,8,0,0,7,7,12,12,6,6,3,3,15,15,11,11,1,1,11,11,2,2,9,9,8,8,2,2,13,13,5,5,2,2,11,11,12,12,0,0,12,12,0,0,5,5,11,11,5,5,15,15,6,6,8,8,15,15,4,4,13,13,8,8,8,8,8,8,1,1,2,2,4,4,9,9,0,0,7,7,9,9,1,1,14,14,2,2,1,1,1,1,2,2,3,3,13,13,5,5,14,14,10,10,7,7,8,8,6,6,4,4,12,12,9,9,11,11,12,12,0,0,8,8,5,5,3,3,9,9,6,6,1,1,11,11,13,13,0,0,15,15,0,0,2,2,1,1,12,12,3,3,0,0,4,4,13,13,7,7,8,8,11,11,6,6,4,4,15,15,5,5,2,2,0,0,8,8,6,6,12,12,13,13,3,3,14,14,13,13,12,12,5,5,9,9,12,12,13,13,9,9,14,14,0,0,10,10,14,14,5,5,10,10,1,1,0,0,13,13,12,12,0,0,3,3,4,4,9,9,14,14,13,13,0,0,5,5,6,6,1,1,13,13,13,13,11,11,13,13,4,4,0,0,8,8,2,2,14,14,3,3,9,9,8,8,8,8,14,14,5,5,9,9,15,15,11,11,13,13,5,5,14,14,1,1,12,12,5,5,6,6,0,0,13,13,4,4,0,0,4,4,10,10,4,4,12,12,14,14,8,8,7,7,2,2,12,12,7,7,12,12,5,5,2,2,4,4,3,3,0,0,4,4,6,6,14,14,1,1,5,5,5,5,1,1,7,7,14,14,12,12,1,1,8,8,12,12,12,12,15,15,1,1,14,14,4,4,15,15,2,2,3,3,8,8,7,7,3,3,12,12,6,6,14,14,8,8,6,6,8,8,7,7,4,4,3,3,7,7,3,3,4,4,3,3,6,6,12,12,12,12,6,6,15,15,15,15,12,12,13,13,9,9,15,15,6,6,8,8,7,7,1,1,0,0,4,4,2,2,0,0,7,7,8,8,6,6,0,0,7,7,2,2,4,4,4,4,6,6,10,10,0,0,0,0,0,0,14,14,2,2,9,9,12,12,7,7,8,8,1,1,15,15,4,4,0,0,3,3,7,7,5,5,5,5,13,13,11,11,5,5,9,9,7,7,3,3,13,13,7,7,13,13,10,10,4,4,6,6,7,7,6,6,1,1,10,10,3,3,3,3,4,4,14,14,4,4,4,4,10,10,7,7,2,2,10,10,6,6,1,1,12,12,8,8,5,5,9,9,4,4,13,13,4,4,11,11,2,2,1,1,6,6,6,6,8,8,2,2,14,14,3,3,11,11,13,13,8,8,2,2,7,7,12,12,14,14,9,9,14,14,5,5,11,11,2,2,7,7,7,7,9,9,6,6,1,1,8,8,10,10,11,11,9,9,11,11,9,9,6,6,0,0,7,7,15,15,1,1,6,6,0,0,9,9,7,7,1,1,0,0,12,12,12,12,0,0,11,11,6,6,7,7,3,3,1,1,8,8,0,0,15,15,10,10,6,6,7,7,11,11,4,4,6,6,1,1,7,7,0,0,13,13,0,0,10,10,11,11,1,1,7,7,0,0,11,11,1,1,8,8,9,9,4,4,0,0,11,11,12,12,0,0,10,10,5,5,1,1,10,10,0,0,5,5,3,3,14,14,7,7,14,14,15,15,5,5,4,4,2,2,14,14,3,3,8,8,0,0,8,8,1,1,7,7,0,0,1,1,5,5,0,0,8,8,15,15,8,8,8,8,13,13,12,12,8,8,6,6,3,3,2,2,11,11,11,11,9,9,8,8,14,14,2,2,11,11,2,2,2,2,0,0,9,9,1,1,3,3,15,15,14,14,15,15,3,3,10,10,2,2,5,5,11,11,10,10,6,6,14,14,5,5,11,11,13,13,10,10,8,8,12,12,15,15,8,8,5,5,13,13,9,9,8,8,8,8,13,13,7,7,1,1,10,10,6,6,4,4,15,15,10,10,7,7,14,14,3,3,8,8,10,10,2,2,7,7,12,12,9,9,2,2,11,11,3,3,0,0,14,14,10,10,13,13,12,12,2,2,13,13,11,11,5,5,15,15,1,1,10,10,9,9,1,1,15,15,3,3,2,2,10,10,11,11,2,2,7,7,2,2,14,14,0,0,1,1,12,12,0,0,8,8,15,15,12,12,7,7,12,12,13,13,13,13,6,6,11,11,15,15,15,15,11,11,15,15,6,6,11,11,9,9,9,9,0,0,9,9,7,7,4,4,3,3,14,14,3,3,15,15,7,7,4,4,5,5,5,5,13,13,3,3,2,2,9,9,14,14,11,11,2,2,6,6,3,3,6,6,1,1,13,13,5,5,11,11,7,7,9,9,4,4,5,5,9,9,14,14,5,5,15,15,6,6,10,10,3,3,3,3,3,3,0,0,6,6,1,1,15,15,0,0,14,14,6,6,15,15,12,12,0,0,7,7,8,8,8,8,8,8,3,3,10,10,0,0,4,4,8,8,5,5,4,4,0,0,0,0,8,8,14,14,3,3,7,7,11,11,7,7,3,3,7,7,13,13,6,6,2,2,5,5,3,3,9,9,9,9,12,12,6,6,12,12,7,7,8,8,4,4,9,9,11,11,15,15,10,10,4,4,2,2,10,10,10,10,1,1,9,9,1,1,11,11,10,10,4,4,8,8,2,2,1,1,8,8,7,7,7,7,9,9,6,6,8,8,7,7,10,10,10,10,6,6,6,6,12,12,5,5,6,6,3,3,11,11,0,0,9,9,5,5,0,0,15,15,10,10,2,2,3,3,5,5,3,3,4,4,7,7,1,1,1,1,11,11,13,13,9,9,0,0,0,0,8,8,2,2,8,8,4,4,12,12,12,12,12,12,7,7,15,15,13,13,0,0,15,15,2,2,0,0,11,11,5,5,9,9,12,12,13,13,3,3,6,6,9,9,4,4,5,5,11,11,15,15,1,1,1,1,7,7,4,4,10,10,7,7,6,6,0,0,0,0,6,6,4,4,8,8,3,3,11,11,2,2,12,12,2,2,7,7,12,12,15,15,5,5,10,10,8,8,1,1,2,2,9,9,5,5,10,10,2,2,14,14,13,13,6,6,8,8,15,15,12,12,3,3,4,4,1,1,12,12,4,4,8,8,14,14,12,12,12,12,4,4,8,8,4,4,5,5,8,8,0,0,12,12,5,5,5,5,4,4,2,2,0,0,0,0,6,6,2,2,0,0,5,5,0,0,9,9,14,14,2,2,6,6,14,14,6,6,9,9,2,2,4,4,0,0,6,6,9,9,9,9,11,11,6,6,13,13,7,7,8,8,8,8,1,1,12,12,2,2,6,6,11,11,8,8,11,11,0,0,13,13,10,10,8,8,14,14,10,10,10,10,13,13,10,10,5,5,6,6,6,6,14,14,8,8,13,13,10,10,10,10,7,7,10,10,0,0,5,5,15,15,13,13,11,11,0,0,14,14,5,5,5,5,6,6,13,13,9,9,3,3,7,7,2,2,10,10,8,8,12,12,7,7,7,7,14,14,10,10,12,12,3,3,8,8,10,10,4,4,4,4,3,3,8,8,8,8,15,15,5,5,10,10,0,0,9,9,2,2,3,3,5,5,0,0,6,6,2,2,1,1,10,10,3,3,1,1,3,3,0,0,1,1,10,10,0,0,10,10,6,6,14,14,9,9,14,14,10,10,0,0,7,7,7,7,6,6,9,9,0,0,12,12,0,0,1,1,7,7,10,10,12,12,2,2,12,12,3,3,14,14,1,1,4,4,15,15,2,2,1,1,0,0,9,9,7,7,11,11,12,12,7,7,7,7,3,3,1,1,13,13,2,2,4,4,1,1,13,13,1,1,1,1,4,4,11,11,5,5,13,13,2,2,15,15,14,14,14,14,12,12,4,4,0,0,8,8,14,14,1,1,3,3,13,13,9,9,1,1,2,2,14,14,5,5,5,5,8,8,11,11,6,6,8,8,2,2,2,2,3,3,12,12,15,15,1,1,15,15,5,5,12,12,2,2,12,12,12,12,3,3,4,4,9,9,13,13,8,8,4,4,2,2,12,12,9,9,4,4,1,1,5,5,8,8,3,3,8,8,7,7,12,12,13,13,0,0,14,14,10,10,1,1,7,7,15,15,11,11,10,10,10,10,5,5,0,0,9,9,11,11,10,10,6,6,14,14,13,13,15,15,9,9,8,8,12,12,2,2,14,14,10,10,0,0,12,12,5,5,14,14,11,11,1,1,13,13,0,0,4,4,3,3,11,11,2,2,3,3,15,15,2,2,5,5,1,1,13,13,4,4,9,9,3,3,0,0,7,7,3,3,15,15,0,0,1,1,11,11,3,3,12,12,11,11,0,0,1,1,2,2,1,1,12,12,4,4,6,6,7,7,14,14,15,15,3,3,14,14,9,9,6,6,8,8,9,9,2,2,1,1,13,13,9,9,9,9,14,14,12,12,1,1,2,2,12,12,13,13,4,4,2,2,10,10,12,12,8,8,2,2,13,13,15,15,14,14,6,6,0,0,11,11,1,1,3,3,8,8,3,3,15,15,7,7,4,4,0,0,1,1,0,0,11,11,13,13,6,6,0,0,10,10,14,14,9,9,2,2,7,7,0,0,6,6,6,6,14,14,6,6,13,13,15,15,3,3,2,2,1,1,4,4,7,7,12,12,6,6,4,4,5,5,3,3,10,10,5,5,8,8,4,4,3,3,5,5,3,3,2,2,13,13,8,8,4,4,3,3,11,11,15,15,11,11,5,5,7,7,6,6,9,9,4,4,13,13,0,0,5,5,1,1,5,5,4,4,12,12,13,13,5,5,5,5,12,12,5,5,3,3,4,4,3,3,1,1,10,10,4,4,3,3,4,4,4,4,7,7,4,4,7,7,12,12,3,3,1,1,15,15,4,4,1,1,13,13,13,13,0,0,1,1,7,7,5,5,5,5,9,9,8,8,8,8,5,5,14,14,13,13,3,3,7,7,8,8,2,2,9,9,11,11,14,14,11,11,6,6,14,14,6,6,7,7,0,0,15,15,2,2,4,4,3,3,8,8,14,14,15,15,0,0,14,14,0,0,9,9,11,11,14,14,4,4,12,12,10,10,13,13,2,2,13,13,13,13,14,14,5,5,2,2,3,3,9,9,3,3,5,5,1,1,10,10,4,4,0,0,0,0,1,1,2,2,14,14,13,13,7,7,15,15,7,7,13,13,7,7,11,11,6,6,3,3,11,11,3,3,7,7,15,15,9,9,6,6,9,9,1,1,4,4,13,13,5,5,5,5,6,6,11,11,7,7,0,0,15,15,5,5,2,2,11,11,4,4,8,8,0,0,5,5,10,10,2,2,1,1,5,5,0,0,3,3,0,0,2,2,4,4,0,0,15,15,5,5,8,8,7,7,13,13,13,13,6,6,1,1,2,2,15,15,14,14,5,5,11,11,1,1,3,3,1,1,1,1,7,7,12,12,13,13,15,15,5,5,1,1,11,11,0,0,8,8,13,13,15,15,8,8,10,10,2,2,4,4,12,12,7,7,14,14,6,6,12,12,14,14,11,11,2,2,5,5,1,1,0,0,11,11,12,12,3,3,4,4,15,15,0,0,2,2,1,1,8,8,9,9,5,5,6,6,13,13,4,4,6,6,9,9,10,10,9,9,14,14,7,7,8,8,4,4,8,8,4,4,4,4,2,2,10,10,5,5,11,11,10,10,11,11,10,10,11,11,15,15,12,12,6,6,13,13,9,9,7,7,7,7,0,0,4,4,3,3,5,5,1,1,3,3,9,9,6,6,7,7,10,10,10,10,9,9,2,2,2,2,6,6,6,6,3,3,8,8,5,5,11,11,10,10,11,11,1,1,8,8,2,2,11,11,8,8,8,8,0,0,15,15,14,14,1,1,1,1,8,8,1,1,3,3,6,6,1,1,5,5,13,13,0,0,3,3,13,13,8,8,1,1,12,12,8,8,5,5,15,15,4,4,10,10,10,10,2,2,4,4,11,11,1,1,4,4,11,11,15,15,11,11,13,13,10,10,4,4,13,13,11,11,13,13,7,7,13,13,9,9,3,3,7,7,5,5,3,3,11,11,12,12,12,12,10,10,7,7,4,4,9,9,4,4,8,8,1,1,13,13,1,1,15,15,6,6,8,8,9,9,13,13,0,0,4,4,11,11,0,0,8,8,15,15,13,13,0,0,1,1,0,0,1,1,7,7,5,5,1,1,3,3,11,11,12,12,10,10,2,2,4,4,9,9,2,2,13,13,8,8,4,4,7,7,2,2,9,9,2,2,9,9,9,9,8,8,0,0,8,8,2,2,3,3,11,11,0,0,1,1,6,6,1,1,2,2,1,1,3,3,13,13,2,2,10,10,7,7,1,1,0,0,3,3,9,9,2,2,11,11,1,1,3,3,0,0,8,8,2,2,14,14,7,7,11,11,13,13,12,12,10,10,11,11,7,7,2,2,12,12,14,14,0,0,9,9,4,4,3,3,2,2,8,8,2,2,11,11,1,1,3,3,6,6,12,12,14,14,15,15,1,1,8,8,3,3,12,12,10,10,7,7,1,1,13,13,1,1,1,1,1,1,8,8,0,0,5,5,3,3,6,6,15,15,0,0,14,14,0,0,2,2,7,7,8,8,7,7,10,10,1,1,10,10,14,14,4,4,3,3,4,4,11,11,5,5,8,8,3,3,7,7,5,5,1,1,0,0,2,2,15,15,13,13,2,2,5,5,12,12,15,15,9,9,10,10,9,9,1,1,7,7,10,10,0,0,9,9,15,15,13,13,14,14,15,15,6,6,10,10,8,8,12,12,12,12,2,2,7,7,10,10,15,15,10,10,0,0,9,9,15,15,1,1,6,6,14,14,0,0,6,6,9,9,1,1,6,6,14,14,1,1,3,3,7,7,1,1,11,11,9,9,13,13,14,14,8,8,6,6,9,9,1,1,6,6,11,11,4,4,15,15,6,6,12,12,4,4,11,11,15,15,2,2,6,6,5,5,10,10,3,3,7,7,3,3,2,2,7,7,10,10,1,1,9,9,6,6,13,13,4,4,8,8,14,14,15,15,1,1,4,4,0,0,0,0,3,3,12,12,1,1,13,13,15,15,5,5,2,2,15,15,5,5,4,4,9,9,2,2,0,0,13,13,4,4,7,7,5,5,1,1,15,15,15,15,8,8,6,6,13,13,9,9,1,1,11,11,0,0,15,15,6,6,1,1,4,4,11,11,3,3,7,7,4,4,1,1,8,8,10,10,10,10,13,13,11,11,3,3,5,5,15,15,2,2,0,0,11,11,14,14,2,2,6,6,0,0,1,1,9,9,5,5,7,7,13,13,7,7,15,15,6,6,0,0,8,8,2,2,15,15,2,2,5,5,2,2,1,1,1,1,3,3,12,12,14,14,5,5,12,12,7,7,5,5,9,9,2,2,13,13,9,9,1,1,15,15,10,10,4,4,10,10,7,7,12,12,8,8,11,11,11,11,3,3,9,9,12,12,4,4,8,8,12,12,11,11,11,11,4,4,9,9,7,7,1,1,4,4,10,10,14,14,10,10,8,8,10,10,1,1,14,14,14,14,10,10,0,0,12,12,0,0,8,8,8,8,2,2,7,7,8,8,9,9,1,1,8,8,13,13,3,3,8,8,1,1,11,11,13,13,8,8,8,8,5,5,3,3,0,0,15,15,8,8,10,10,0,0,13,13,12,12,14,14,0,0,1,1,8,8,12,12,0,0,3,3,15,15,15,15,3,3,12,12,6,6,9,9,5,5,13,13,5,5,5,5,2,2,9,9,15,15,7,7,9,9,10,10,0,0,3,3,12,12,15,15,7,7,15,15,2,2,14,14,10,10,8,8,9,9,3,3,3,3,0,0,8,8,11,11,4,4,6,6,9,9,8,8,9,9,8,8,7,7,9,9,4,4,10,10,1,1,1,1,11,11,8,8,9,9,6,6,15,15,15,15,1,1,8,8,14,14,3,3,4,4,14,14,9,9,10,10,0,0,6,6,8,8,9,9,9,9,9,9,11,11,11,11,9,9,9,9,1,1,4,4,6,6,12,12,8,8,1,1,8,8,1,1,5,5,6,6,2,2,6,6,11,11,4,4,14,14,4,4,4,4,7,7,13,13,8,8,6,6,11,11,8,8,1,1,2,2,9,9,15,15,2,2,0,0,8,8,2,2,15,15,4,4,10,10,5,5,4,4,2,2,7,7,11,11,8,8,11,11,2,2,12,12,8,8,10,10,4,4,11,11,1,1,7,7,8,8,6,6,6,6,1,1,14,14,1,1,14,14,9,9,10,10,7,7,7,7,1,1,8,8,4,4,10,10,9,9,3,3,7,7,7,7,1,1,0,0,11,11,4,4,2,2,11,11,1,1,4,4,9,9,6,6,12,12,5,5,1,1,11,11,0,0,13,13,10,10,10,10,5,5,4,4,8,8,5,5,9,9,3,3,4,4,10,10,3,3,3,3,6,6,6,6,9,9,8,8,0,0,4,4,2,2,0,0,3,3,5,5,1,1,1,1,11,11,13,13,3,3,10,10,13,13,2,2,6,6,5,5,6,6,0,0,13,13,4,4,7,7,12,12,5,5,7,7,6,6,11,11,11,11,10,10,1,1,1,1,7,7,15,15,9,9,5,5,15,15,2,2,3,3,9,9,11,11,11,11,13,13,1,1,11,11,2,2,10,10,12,12,5,5,0,0,4,4,9,9,13,13,14,14,12,12,11,11,15,15,12,12,0,0,6,6,13,13,10,10,10,10,10,10,9,9,12,12,7,7,1,1,10,10,2,2,7,7,6,6,1,1,6,6,13,13,7,7,11,11,14,14,7,7,0,0,0,0,1,1,14,14,4,4,1,1,0,0,9,9,9,9,8,8,7,7,13,13,1,1,10,10,7,7,15,15,12,12,11,11,3,3,12,12,8,8,1,1,15,15,1,1,14,14,0,0,12,12,9,9,5,5,8,8,8,8,0,0,15,15,9,9,2,2,12,12,2,2,7,7,1,1,12,12,11,11,9,9,7,7,9,9,5,5,9,9,0,0,2,2,13,13,0,0,2,2,11,11,6,6,10,10,5,5,4,4,10,10,9,9,2,2,1,1,15,15,2,2,1,1,9,9,15,15,3,3,7,7,12,12,7,7,15,15,8,8,5,5,12,12,3,3,9,9,14,14,15,15,1,1,12,12,13,13,3,3,5,5,3,3,11,11,0,0,9,9,0,0,7,7,9,9,5,5,0,0,4,4,4,4,12,12,2,2,10,10,0,0,13,13,6,6,0,0,5,5,13,13,12,12,12,12,11,11,2,2,1,1,10,10,1,1,12,12,10,10,12,12,9,9,7,7,3,3,5,5,3,3,5,5,3,3,6,6,2,2,6,6,15,15,10,10,9,9,1,1,5,5,3,3,7,7,6,6,3,3,8,8,0,0,8,8,7,7,2,2,13,13,6,6,10,10,9,9,14,14,3,3,15,15,8,8,6,6,0,0,4,4,9,9,6,6,10,10,14,14,13,13,12,12,14,14,8,8,5,5,6,6,6,6,8,8,9,9,4,4,6,6,9,9,7,7,2,2,13,13,12,12,5,5,4,4,7,7,15,15,3,3,2,2,3,3,1,1,12,12,5,5,5,5,10,10,9,9,13,13,13,13,12,12,11,11,4,4,2,2,7,7,8,8,5,5,9,9,10,10,0,0,11,11,10,10,12,12,6,6,7,7,1,1,15,15,8,8,9,9,4,4,5,5,1,1,7,7,1,1,1,1,6,6,9,9,1,1,14,14,12,12,11,11,15,15,5,5,8,8,6,6,4,4,7,7,12,12,12,12,2,2,15,15,14,14,3,3,15,15,7,7,6,6,7,7,11,11,2,2,12,12,14,14,3,3,6,6,1,1,0,0,7,7,11,11,15,15,14,14,5,5,8,8,8,8,12,12,4,4,4,4,6,6,6,6,6,6,8,8,12,12,15,15,3,3,3,3,3,3,3,3,11,11,3,3,14,14,15,15,12,12,12,12,5,5,4,4,0,0,11,11,15,15,1,1,0,0,11,11,7,7,12,12,10,10,5,5,12,12,7,7,12,12,8,8,6,6,8,8,5,5,15,15,0,0,10,10,7,7,9,9,8,8,10,10,1,1,6,6,15,15,5,5,12,12,6,6,1,1,2,2,14,14,2,2,2,2,14,14,13,13,2,2,12,12,9,9,0,0,15,15,2,2,3,3,4,4,15,15,8,8,3,3,13,13,13,13,1,1,9,9,10,10,10,10,8,8,4,4,15,15,7,7,1,1,11,11,9,9,10,10,4,4,4,4,12,12,7,7,8,8,5,5,4,4,1,1,4,4,5,5,6,6,1,1,4,4,3,3,14,14,9,9,1,1,10,10,3,3,10,10,13,13,9,9,15,15,2,2,9,9,9,9,10,10,8,8,9,9,6,6,10,10,7,7,6,6,4,4,5,5,11,11,6,6,13,13,11,11,6,6,9,9,8,8,1,1,12,12,2,2,3,3,10,10,10,10,9,9,15,15,7,7,13,13,8,8,4,4,5,5,7,7,8,8,13,13,11,11,6,6,2,2,15,15,9,9,7,7,7,7,5,5,5,5,0,0,6,6,1,1,14,14,4,4,7,7,2,2,1,1,7,7,1,1,3,3,4,4,2,2,10,10,7,7,4,4,10,10,4,4,4,4,0,0,2,2,0,0,9,9,0,0,9,9,9,9,4,4,6,6,15,15,9,9,8,8,11,11,0,0,1,1,4,4,8,8,1,1,9,9,6,6,4,4,12,12,9,9,9,9,1,1,4,4,9,9,8,8,9,9,14,14,14,14,7,7,0,0,7,7,10,10,4,4,10,10,13,13,14,14,12,12,1,1,6,6,8,8,1,1,4,4,0,0,5,5,5,5,5,5,8,8,6,6,8,8,5,5,8,8,8,8,15,15,4,4,10,10,4,4,9,9,10,10,12,12,0,0,13,13,0,0,3,3,10,10,2,2,3,3,8,8,12,12,1,1,8,8,2,2,3,3,1,1,2,2,14,14,1,1,10,10,8,8,15,15,5,5,4,4,9,9,3,3,5,5,6,6,3,3,13,13,3,3,14,14,0,0,7,7,11,11,8,8,8,8,9,9,3,3,11,11,11,11,0,0,8,8,6,6,6,6,1,1,14,14,2,2,9,9,11,11,14,14,11,11,15,15,0,0,8,8,5,5,1,1,12,12,0,0,15,15,2,2,14,14,6,6,14,14,12,12,11,11,14,14,13,13,12,12,10,10,12,12,10,10,8,8,4,4,4,4,12,12,11,11,8,8,5,5,15,15,10,10,12,12,7,7,8,8,5,5,2,2,0,0,11,11,2,2,13,13,0,0,7,7,0,0,11,11,15,15,1,1,10,10,11,11,7,7,14,14,6,6,13,13,10,10,3,3,14,14,15,15,12,12,9,9,2,2,3,3,10,10,12,12,8,8,4,4,10,10,5,5,8,8,4,4,9,9,6,6,11,11,3,3,8,8,4,4,9,9,1,1,2,2,12,12,5,5,15,15,12,12,10,10,13,13,9,9,14,14,11,11,5,5,0,0,14,14,15,15,14,14,14,14,5,5,5,5,7,7,13,13,15,15,15,15,1,1,13,13,6,6,11,11,14,14,6,6,15,15,3,3,1,1,8,8,3,3,9,9,11,11,14,14,9,9,13,13,9,9,2,2,13,13,3,3,13,13,9,9,7,7,1,1,2,2,11,11,7,7,3,3,4,4,9,9,10,10,6,6,13,13,12,12,3,3,1,1,5,5,0,0,9,9,12,12,6,6,5,5,14,14,4,4,2,2,9,9,14,14,13,13,0,0,15,15,4,4,9,9,8,8,1,1,8,8,10,10,5,5,11,11,2,2,7,7,6,6,13,13,4,4,2,2,3,3,13,13,10,10,15,15,0,0,7,7,13,13,3,3,13,13,14,14,1,1,2,2,2,2,5,5,15,15,6,6,8,8,15,15,12,12,1,1,9,9,6,6,7,7,1,1,13,13,0,0,3,3,15,15,15,15,4,4,8,8,1,1,6,6,11,11,0,0,3,3,13,13,3,3,15,15,6,6,8,8,7,7,2,2,13,13,7,7,13,13,4,4,3,3,4,4,12,12,15,15,11,11,12,12,8,8,9,9,4,4,15,15,7,7,7,7,0,0,10,10,4,4,15,15,2,2,6,6,2,2,4,4,14,14,11,11,7,7,10,10,3,3,8,8,0,0,8,8,1,1,1,1,12,12,14,14,6,6,4,4,7,7,4,4,5,5,2,2,7,7,12,12,11,11,14,14,11,11,3,3,4,4,11,11,8,8,0,0,1,1,10,10,14,14,5,5,2,2,5,5,7,7,6,6,15,15,5,5,12,12,13,13,10,10,15,15,0,0,5,5,6,6,8,8,2,2,9,9,14,14,14,14,13,13,13,13,5,5,10,10,7,7,7,7,12,12,15,15,6,6,1,1,14,14,10,10,8,8,8,8,2,2,5,5,15,15,4,4,0,0,3,3,5,5,10,10,1,1,13,13,10,10,5,5,2,2,0,0,11,11,14,14,9,9,5,5,11,11,10,10,9,9,14,14,12,12,6,6,9,9,10,10,11,11,1,1,2,2,15,15,10,10,2,2,11,11,4,4,13,13,8,8,0,0,1,1,6,6,9,9,7,7,9,9,3,3,5,5,8,8,10,10,0,0,6,6,1,1,13,13,2,2,3,3,9,9,10,10,0,0,0,0,3,3,6,6,2,2,8,8,11,11,13,13,2,2,5,5,7,7,3,3,11,11,0,0,6,6,9,9,13,13,5,5,13,13,13,13,5,5,14,14,3,3,0,0,4,4,13,13,12,12,12,12,0,0,3,3,1,1,7,7,10,10,9,9,0,0,12,12,12,12,7,7,0,0,9,9,1,1,3,3,8,8,9,9,0,0,1,1,10,10,10,10,0,0,14,14,6,6,1,1,1,1,8,8,1,1,4,4,8,8,1,1,8,8,3,3,8,8,12,12,9,9,8,8,13,13,10,10,12,12,5,5,12,12,14,14,3,3,4,4,6,6,11,11,13,13,10,10,4,4,4,4,15,15,7,7,0,0,11,11,11,11,10,10,13,13,6,6,8,8,4,4,0,0,8,8,7,7,6,6,7,7,12,12,2,2,3,3,6,6,3,3,11,11,10,10,11,11,7,7,3,3,13,13,11,11,6,6,2,2,3,3,10,10,14,14,10,10,9,9,1,1,9,9,5,5,12,12,3,3,14,14,9,9,3,3,10,10,12,12,10,10,4,4,13,13,0,0,0,0,4,4,8,8,11,11,2,2,13,13,4,4,8,8,6,6,3,3,4,4,0,0,1,1,2,2,7,7,11,11,7,7,9,9,13,13,6,6,1,1,11,11,5,5,1,1,2,2,6,6,11,11,3,3,4,4,10,10,1,1,7,7,9,9,11,11,7,7,10,10,12,12,3,3,11,11,15,15,10,10,10,10,5,5,4,4,14,14,10,10,3,3,3,3,4,4,10,10,1,1,1,1,10,10,4,4,0,0,11,11,5,5,0,0,3,3,3,3,15,15,5,5,8,8,6,6,14,14,6,6,2,2,12,12,9,9,3,3,1,1,12,12,0,0,10,10,13,13,10,10,7,7,0,0,0,0,0,0,2,2,0,0,5,5,2,2,1,1,8,8,4,4,8,8,10,10,12,12,0,0,14,14,8,8,6,6,14,14,12,12,2,2,4,4,7,7,1,1,10,10,15,15,13,13,7,7,5,5,0,0,9,9,1,1,2,2,10,10,5,5,2,2,4,4,12,12,0,0,11,11,4,4,4,4,9,9,14,14,7,7,13,13,5,5,12,12,3,3,15,15,15,15,3,3,1,1,10,10,3,3,2,2,6,6,14,14,5,5,4,4,13,13,3,3,3,3,7,7,9,9,6,6,6,6,0,0,5,5,12,12,12,12,14,14,12,12,7,7,7,7,3,3,12,12,2,2,0,0,11,11,1,1,14,14,6,6,3,3,11,11,7,7,3,3,13,13,12,12,14,14,12,12,12,12,13,13,9,9,3,3,3,3,8,8,12,12,2,2,4,4,2,2,2,2,8,8,3,3,8,8,5,5,10,10,0,0,3,3,0,0,0,0,7,7,6,6,8,8,8,8,4,4,0,0,12,12,0,0,8,8,1,1,14,14,5,5,3,3,5,5,8,8,14,14,3,3,7,7,10,10,0,0,13,13,15,15,11,11,9,9,1,1,10,10,9,9,10,10,10,10,8,8,5,5,7,7,5,5,0,0,6,6,5,5,14,14,0,0,7,7,11,11,6,6,9,9,8,8,11,11,14,14,12,12,4,4,1,1,15,15,4,4,4,4,6,6,12,12,1,1,13,13,10,10,13,13,13,13,2,2,9,9,3,3,13,13,1,1,11,11,6,6,11,11,14,14,10,10,1,1,10,10,8,8,10,10,0,0,3,3,10,10,7,7,11,11,13,13,13,13,12,12,8,8,0,0,13,13,8,8,13,13,4,4,7,7,8,8,4,4,0,0,7,7,2,2,10,10,4,4,3,3,3,3,10,10,2,2,10,10,3,3,11,11,13,13,15,15,0,0,4,4,14,14,14,14,5,5,5,5,10,10,0,0,3,3,0,0,9,9,11,11,11,11,9,9,8,8,1,1,5,5,3,3,5,5,0,0,8,8,13,13,6,6,8,8,5,5,9,9,11,11,2,2,15,15,6,6,11,11,5,5,4,4,1,1,15,15,3,3,13,13,13,13,5,5,4,4,5,5,6,6,0,0,2,2,11,11,11,11,1,1,4,4,1,1,14,14,0,0,15,15,4,4,6,6,6,6,2,2,7,7,1,1,7,7,0,0,6,6,15,15,10,10,8,8,3,3,2,2,13,13,11,11,11,11,5,5,3,3,15,15,9,9,12,12,4,4,7,7,6,6,14,14,6,6,1,1,5,5,1,1,14,14,11,11,15,15,11,11,9,9,0,0,10,10,13,13,5,5,4,4,15,15,5,5,12,12,8,8,4,4,11,11,12,12,7,7,2,2,8,8,13,13,9,9,1,1,6,6,9,9,15,15,12,12,13,13,8,8,12,12,10,10,13,13,10,10,6,6,8,8,7,7,15,15,10,10,6,6,11,11,9,9,3,3,10,10,2,2,7,7,5,5,12,12,9,9,15,15,2,2,8,8,8,8,15,15,14,14,5,5,5,5,3,3,8,8,3,3,8,8,5,5,11,11,8,8,1,1,15,15,7,7,1,1,9,9,4,4,2,2,0,0,3,3,6,6,11,11,8,8,4,4,3,3,7,7,4,4,11,11,1,1,12,12,3,3,5,5,7,7,2,2,7,7,5,5,1,1,7,7,0,0,13,13,10,10,5,5,14,14,15,15,9,9,11,11,5,5,3,3,2,2,10,10,14,14,15,15,9,9,0,0,3,3,8,8,0,0,3,3,7,7,10,10,13,13,12,12,15,15,13,13,1,1,2,2,12,12,12,12,10,10,15,15,1,1,3,3,2,2,13,13,1,1,0,0,2,2,5,5,6,6,12,12,13,13,10,10,4,4,6,6,1,1,9,9,5,5,3,3,8,8,1,1,14,14,11,11,8,8,7,7,4,4,12,12,8,8,3,3,13,13,0,0,0,0,9,9,8,8,4,4,0,0,10,10,7,7,12,12,2,2,11,11,15,15,10,10,12,12,14,14,6,6,13,13,2,2,15,15,0,0,6,6,4,4,12,12,0,0,14,14,2,2,2,2,7,7,7,7,0,0,1,1,12,12,5,5,8,8,5,5,11,11,2,2,2,2,14,14,6,6,9,9,12,12,10,10,14,14,2,2,3,3,2,2,13,13,13,13,0,0,8,8,4,4,4,4,15,15,12,12,3,3,4,4,4,4,1,1,12,12,6,6,4,4,3,3,8,8,3,3,10,10,5,5,15,15,11,11,6,6,8,8,9,9,4,4,3,3,8,8,11,11,12,12,4,4,12,12,10,10,14,14,10,10,0,0,4,4,8,8,14,14,11,11,8,8,12,12,1,1,11,11,0,0,7,7,8,8,8,8,8,8,3,3,8,8,2,2,14,14,2,2,10,10,1,1,8,8,5,5,0,0,10,10,12,12,13,13,13,13,11,11,5,5,15,15,0,0,10,10,15,15,6,6,4,4,0,0,7,7,4,4,7,7,12,12,8,8,15,15,9,9,6,6,8,8,5,5,8,8,8,8,14,14,14,14,7,7,4,4,7,7,3,3,1,1,12,12,13,13,14,14,12,12,14,14,8,8,5,5,8,8,7,7,10,10,8,8,2,2,7,7,6,6,2,2,0,0,9,9,5,5,13,13,12,12,11,11,12,12,10,10,11,11,14,14,11,11,10,10,4,4,0,0,0,0,2,2,15,15,13,13,11,11,13,13,8,8,4,4,3,3,7,7,13,13,12,12,11,11,14,14,9,9,6,6,5,5,12,12,3,3,11,11,3,3,13,13,8,8,3,3,5,5,10,10,8,8,6,6,12,12,12,12,10,10,2,2,0,0,3,3,5,5,6,6,6,6,0,0,8,8,8,8,14,14,8,8,3,3,2,2,15,15,9,9,3,3,6,6,12,12,10,10,3,3,5,5,0,0,2,2,5,5,13,13,12,12,2,2,0,0,0,0,4,4,4,4,12,12,14,14,14,14,1,1,14,14,0,0,7,7,7,7,15,15,8,8,12,12,4,4,5,5,7,7,10,10,9,9,7,7,10,10,5,5,10,10,1,1,15,15,13,13,2,2,4,4,15,15,0,0,15,15,0,0,7,7,8,8,8,8,0,0,9,9,3,3,4,4,3,3,9,9,6,6,2,2,13,13,6,6,9,9,2,2,2,2,15,15,0,0,2,2,0,0,0,0,10,10,13,13,7,7,6,6,12,12,3,3,13,13,10,10,0,0,5,5,15,15,0,0,1,1,0,0,2,2,0,0,1,1,7,7,5,5,4,4,3,3,0,0,9,9,8,8,9,9,10,10,4,4,3,3,14,14,6,6,12,12,4,4,6,6,6,6,4,4,12,12,10,10,2,2,15,15,15,15,7,7,12,12,11,11,1,1,9,9,1,1,14,14,8,8,3,3,10,10,2,2,0,0,8,8,4,4,7,7,2,2,6,6,13,13,13,13,5,5,11,11,12,12,0,0,12,12,15,15,9,9,8,8,1,1,0,0,14,14,8,8,2,2,10,10,2,2,12,12,4,4,8,8,8,8,9,9,3,3,2,2,4,4,6,6,5,5,3,3,14,14,4,4,3,3,4,4,2,2,5,5,0,0,11,11,2,2,0,0,0,0,5,5,0,0,2,2,6,6,2,2,15,15,2,2,2,2,9,9,13,13,0,0,5,5,7,7,6,6,5,5,3,3,0,0,6,6,6,6,11,11,12,12,0,0,11,11,4,4,14,14,5,5,0,0,3,3,9,9,2,2,14,14,1,1,7,7,2,2,0,0,5,5,0,0,2,2,11,11,2,2,10,10,3,3,14,14,1,1,8,8,4,4,5,5,9,9,15,15,1,1,0,0,3,3,14,14,7,7,6,6,12,12,7,7,8,8,12,12,9,9,8,8,7,7,8,8,1,1,5,5,11,11,7,7,9,9,5,5,13,13,14,14,8,8,11,11,10,10,3,3,10,10,5,5,10,10,6,6,0,0,7,7,3,3,7,7,13,13,2,2,1,1,3,3,1,1,5,5,4,4,3,3,5,5,13,13,9,9,3,3,5,5,8,8,6,6,15,15,15,15,15,15,4,4,0,0,9,9,1,1,2,2,15,15,12,12,2,2,2,2,11,11,10,10,13,13,6,6,8,8,12,12,9,9,4,4,1,1,2,2,1,1,4,4,7,7,11,11,10,10,8,8,11,11,0,0,4,4,11,11,9,9,7,7,6,6,0,0,7,7,1,1,10,10,0,0,12,12,8,8,1,1,4,4,2,2,13,13,9,9,6,6,14,14,5,5,2,2,4,4,0,0,14,14,3,3,10,10,10,10,4,4,0,0,6,6,12,12,10,10,0,0,11,11,5,5,3,3,0,0,0,0,6,6,9,9,15,15,13,13,8,8,5,5,14,14,14,14,5,5,0,0,14,14,3,3,6,6,3,3,11,11,8,8,4,4,5,5,7,7,14,14,6,6,9,9,13,13,13,13,2,2,11,11,5,5,2,2,10,10,3,3,5,5,0,0,2,2,2,2,8,8,0,0,6,6,14,14,15,15,2,2,10,10,7,7,10,10,14,14,12,12,11,11,3,3,14,14,0,0,11,11,7,7,5,5,11,11,0,0,1,1,14,14,2,2,1,1,8,8,15,15,11,11,3,3,5,5,2,2,11,11,4,4,7,7,14,14,12,12,6,6,3,3,6,6,15,15,15,15,8,8,14,14,13,13,9,9,14,14,15,15,3,3,14,14,4,4,7,7,9,9,1,1,0,0,2,2,7,7,1,1,3,3,3,3,12,12,13,13,5,5,12,12,10,10,14,14,10,10,0,0,10,10,13,13,8,8,4,4,4,4,4,4,11,11,4,4,7,7,12,12,8,8,2,2,6,6,0,0,3,3,5,5,4,4,5,5,12,12,12,12,10,10,5,5,3,3,8,8,8,8,14,14,2,2,11,11,7,7,13,13,0,0,11,11,11,11,8,8,1,1,8,8,0,0,7,7,9,9,12,12,3,3,8,8,15,15,7,7,3,3,7,7,0,0,11,11,8,8,2,2,2,2,3,3,15,15,6,6,8,8,1,1,5,5,1,1,6,6,5,5,0,0,4,4,4,4,6,6,15,15,1,1,7,7,6,6,1,1,13,13,8,8,1,1,11,11,3,3,3,3,5,5,1,1,9,9,14,14,1,1,6,6,11,11,14,14,10,10,5,5,13,13,14,14,3,3,3,3,2,2,2,2,3,3,9,9,11,11,1,1,9,9,13,13,14,14,2,2,11,11,12,12,13,13,7,7,10,10,11,11,10,10,15,15,6,6,2,2,15,15,9,9,1,1,0,0,14,14,5,5,11,11,7,7,1,1,0,0,10,10,13,13,11,11,7,7,10,10,12,12,6,6,5,5,9,9,0,0,14,14,8,8,10,10,3,3,1,1,0,0,4,4,14,14,1,1,3,3,14,14,6,6,11,11,15,15,14,14,11,11,7,7,7,7,9,9,8,8,6,6,8,8,7,7,7,7,8,8,11,11,6,6,12,12,9,9,3,3,1,1,13,13,8,8,6,6,11,11,15,15,1,1,11,11,3,3,1,1,7,7,6,6,10,10,1,1,3,3,1,1,4,4,14,14,2,2,9,9,10,10,8,8,6,6,9,9,12,12,11,11,0,0,2,2,8,8,8,8,4,4,11,11,5,5,8,8,0,0,9,9,15,15,3,3,5,5,8,8,14,14,8,8,7,7,9,9,10,10,4,4,14,14,12,12,9,9,3,3,8,8,10,10,13,13,15,15,6,6,10,10,14,14,9,9,11,11,10,10,1,1,14,14,12,12,4,4,2,2,8,8,13,13,2,2,13,13,9,9,1,1,0,0,6,6,6,6,13,13,15,15,3,3,3,3,7,7,7,7,0,0,1,1,4,4,6,6,2,2,0,0,6,6,10,10,5,5,12,12,12,12,8,8,8,8,0,0,12,12,8,8,9,9,0,0,15,15,8,8,2,2,2,2,0,0,13,13,9,9,14,14,10,10,0,0,13,13,1,1,11,11,7,7,14,14,4,4,9,9,3,3,8,8,2,2,12,12,7,7,4,4,0,0,14,14,4,4,4,4,2,2,10,10,4,4,5,5,0,0,15,15,3,3,7,7,4,4,5,5,5,5,10,10,13,13,14,14,8,8,6,6,11,11,5,5,4,4,10,10,9,9,5,5,2,2,6,6,4,4,2,2,12,12,0,0,11,11,9,9,0,0,7,7,12,12,4,4,15,15,14,14,1,1,12,12,5,5,9,9,13,13,6,6,13,13,13,13,4,4,5,5,8,8,6,6,11,11,13,13,10,10,10,10,1,1,11,11,12,12,8,8,8,8,3,3,14,14,3,3,1,1,6,6,8,8,2,2,4,4,14,14,1,1,7,7,3,3,7,7,15,15,15,15,13,13,11,11,12,12,15,15,1,1,2,2,3,3,15,15,12,12,5,5,10,10,2,2,2,2,11,11,7,7,9,9,14,14,6,6,1,1,9,9,1,1,6,6,1,1,1,1,9,9,0,0,12,12,6,6,7,7,7,7,2,2,5,5,0,0,0,0,14,14,12,12,8,8,9,9,10,10,0,0,10,10,5,5,12,12,7,7,14,14,6,6,10,10,1,1,11,11,11,11,6,6,9,9,3,3,11,11,10,10,6,6,15,15,9,9,1,1,6,6,1,1,14,14,10,10,8,8,10,10,14,14,0,0,6,6,14,14,10,10,8,8,10,10,11,11,1,1,5,5,0,0,1,1,8,8,0,0,14,14,10,10,7,7,4,4,0,0,8,8,9,9,7,7,2,2,14,14,4,4,0,0,11,11,1,1,0,0,7,7,14,14,10,10,13,13,12,12,15,15,0,0,12,12,4,4,14,14,13,13,3,3,1,1,8,8,2,2,0,0,15,15,15,15,10,10,1,1,10,10,6,6,8,8,10,10,10,10,6,6,12,12,6,6,10,10,9,9,6,6,3,3,3,3,15,15,3,3,12,12,5,5,2,2,7,7,8,8,14,14,1,1,6,6,7,7,7,7,1,1,13,13,12,12,12,12,15,15,9,9,2,2,6,6,1,1,1,1,9,9,8,8,1,1,15,15,12,12,12,12,2,2,0,0,5,5,14,14,10,10,10,10,5,5,4,4,8,8,7,7,5,5,12,12,0,0,0,0,11,11,9,9,5,5,6,6,14,14,12,12,1,1,8,8,4,4,11,11,7,7,0,0,4,4,5,5,12,12,9,9,2,2,7,7,2,2,8,8,5,5,6,6,13,13,14,14,11,11,3,3,3,3,0,0,4,4,6,6,5,5,12,12,1,1,5,5,4,4,15,15,13,13,10,10,1,1,6,6,6,6,3,3,10,10,15,15,10,10,6,6,13,13,3,3,10,10,8,8,3,3,1,1,7,7,0,0,12,12,6,6,15,15,5,5,5,5,3,3,12,12,12,12,11,11,4,4,10,10,15,15,10,10,6,6,11,11,2,2,2,2,12,12,15,15,5,5,0,0,13,13,1,1,9,9,15,15,4,4,6,6,3,3,2,2,0,0,4,4,0,0,11,11,0,0,0,0,15,15,12,12,0,0,2,2,7,7,7,7,8,8,9,9,9,9,15,15,7,7,2,2,1,1,3,3,15,15,13,13,13,13,12,12,8,8,13,13,6,6,4,4,15,15,7,7,8,8,13,13,7,7,13,13,5,5,0,0,5,5,12,12,1,1,6,6,15,15,14,14,6,6,4,4,3,3,9,9,12,12,2,2,4,4,4,4,14,14,8,8,14,14,12,12,13,13,1,1,7,7,6,6,6,6,9,9,7,7,7,7,2,2,15,15,6,6,7,7,8,8,5,5,6,6,2,2,10,10,3,3,11,11,2,2,11,11,6,6,4,4,0,0,3,3,15,15,2,2,0,0,6,6,14,14,8,8,7,7,11,11,9,9,6,6,5,5,0,0,15,15,7,7,5,5,13,13,0,0,13,13,11,11,14,14,1,1,5,5,11,11,8,8,2,2,10,10,4,4,15,15,0,0,5,5,13,13,8,8,13,13,11,11,3,3,2,2,12,12,2,2,10,10,6,6,1,1,5,5,3,3,4,4,15,15,8,8,6,6,12,12,0,0,14,14,0,0,15,15,2,2,1,1,12,12,8,8,0,0,11,11,6,6,10,10,2,2,14,14,6,6,6,6,6,6,15,15,13,13,2,2,10,10,7,7,13,13,9,9,14,14,7,7,15,15,14,14,5,5,8,8,5,5,13,13,13,13,8,8,12,12,7,7,4,4,13,13,4,4,11,11,15,15,3,3,12,12,5,5,10,10,8,8,6,6,7,7,6,6,6,6,0,0,1,1,10,10,15,15,12,12,0,0,4,4,0,0,4,4,14,14,5,5,2,2,6,6,6,6,10,10,6,6,2,2,9,9,5,5,11,11,8,8,1,1,8,8,0,0,10,10,2,2,2,2,3,3,12,12,13,13,3,3,5,5,12,12,15,15,6,6,2,2,4,4,2,2,12,12,2,2,4,4,8,8,4,4,0,0,7,7,12,12,6,6,7,7,15,15,0,0,8,8,15,15,2,2,13,13,1,1,0,0,15,15,12,12,9,9,13,13,12,12,6,6,4,4,15,15,3,3,6,6,10,10,12,12,10,10,10,10,12,12,7,7,1,1,15,15,4,4,1,1,3,3,4,4,3,3,13,13,4,4,2,2,6,6,11,11,8,8,14,14,15,15,0,0,6,6,15,15,8,8,10,10,13,13,1,1,13,13,7,7,14,14,12,12,12,12,2,2,5,5,9,9,3,3,7,7,2,2,14,14,13,13,9,9,11,11,10,10,6,6,8,8,1,1,8,8,0,0,7,7,7,7,10,10,6,6,8,8,13,13,10,10,12,12,13,13,6,6,3,3,0,0,14,14,8,8,9,9,2,2,2,2,4,4,4,4,1,1,7,7,1,1,13,13,5,5,1,1,7,7,13,13,15,15,4,4,10,10,5,5,5,5,10,10,11,11,11,11,0,0,14,14,8,8,5,5,2,2,14,14,15,15,12,12,5,5,9,9,15,15,6,6,13,13,10,10,2,2,14,14,7,7,9,9,13,13,3,3,7,7,6,6,4,4,10,10,3,3,0,0,5,5,7,7,8,8,4,4,8,8,6,6,14,14,5,5,1,1,0,0,2,2,1,1,10,10,3,3,1,1,0,0,4,4,14,14,1,1,3,3,14,14,4,4,3,3,11,11,5,5,3,3,10,10,7,7,1,1,4,4,15,15,6,6,1,1,0,0,11,11,4,4,4,4,11,11,1,1,9,9,0,0,4,4,14,14,3,3,15,15,11,11,3,3,1,1,8,8,6,6,13,13,15,15,12,12,5,5,5,5,15,15,8,8,10,10,9,9,12,12,11,11,11,11,1,1,11,11,1,1,14,14,4,4,0,0,6,6,0,0,1,1,0,0,14,14,15,15,2,2,4,4,2,2,8,8,0,0,12,12,0,0,11,11,1,1,2,2,2,2,14,14,4,4,1,1,14,14,12,12,2,2,3,3,2,2,0,0,2,2,15,15,5,5,8,8,2,2,10,10,11,11,1,1,13,13,0,0,2,2,11,11,7,7,6,6,10,10,1,1,6,6,6,6,14,14,1,1,3,3,3,3,12,12,0,0,9,9,11,11,5,5,4,4,8,8,7,7,10,10,1,1,8,8,4,4,7,7,4,4,5,5,7,7,15,15,3,3,0,0,3,3,2,2,2,2,15,15,14,14,6,6,7,7,8,8,7,7,9,9,15,15,14,14,0,0,5,5,4,4,13,13,1,1,14,14,0,0,13,13,5,5,15,15,2,2,8,8,15,15,6,6,9,9,6,6,14,14,1,1,11,11,4,4,11,11,1,1,10,10,7,7,4,4,11,11,12,12,3,3,15,15,13,13,8,8,7,7,14,14,7,7,4,4,15,15,5,5,10,10,15,15,12,12,4,4,4,4,7,7,15,15,1,1,15,15,15,15,7,7,2,2,8,8,13,13,3,3,9,9,10,10,1,1,15,15,0,0,0,0,2,2,12,12,3,3,0,0,5,5,13,13,13,13,8,8,8,8,1,1,8,8,9,9,1,1,1,1,3,3,13,13,1,1,10,10,14,14,11,11,10,10,10,10,13,13,0,0,8,8,11,11,10,10,14,14,5,5,14,14,5,5,8,8,11,11,6,6,0,0,3,3,6,6,2,2,7,7,1,1,1,1,9,9,9,9,8,8,11,11,2,2,2,2,13,13,15,15,12,12,2,2,15,15,11,11,15,15,5,5,3,3,4,4,7,7,4,4,8,8,2,2,2,2,12,12,14,14,8,8,3,3,6,6,3,3,7,7,5,5,0,0,4,4,7,7,10,10,11,11,13,13,1,1,5,5,8,8,0,0,15,15,10,10,10,10,12,12,12,12,9,9,1,1,10,10,11,11,5,5,8,8,1,1,12,12,14,14,14,14,12,12,6,6,5,5,5,5,12,12,5,5,12,12,3,3,12,12,3,3,4,4,1,1,4,4,9,9,11,11,8,8,12,12,11,11,5,5,0,0,12,12,1,1,2,2,4,4,9,9,4,4,1,1,7,7,5,5,5,5,10,10,9,9,13,13,13,13,12,12,9,9,15,15,7,7,3,3,7,7,12,12,14,14,10,10,5,5,3,3,9,9,12,12,8,8,0,0,2,2,0,0,13,13,9,9,5,5,2,2,8,8,9,9,7,7,2,2,0,0,2,2,0,0,12,12,6,6,2,2,10,10,6,6,0,0,0,0,7,7,1,1,15,15,6,6,13,13,2,2,4,4,0,0,13,13,2,2,6,6,3,3,12,12,10,10,1,1,11,11,4,4,2,2,2,2,14,14,12,12,1,1,1,1,4,4,4,4,10,10,5,5,0,0,9,9,1,1,1,1,0,0,12,12,12,12,5,5,9,9,14,14,14,14,4,4,7,7,14,14,15,15,6,6,2,2,13,13,8,8,15,15,0,0,3,3,1,1,13,13,10,10,15,15,4,4,6,6,4,4,8,8,9,9,2,2,14,14,5,5,3,3,7,7,9,9,14,14,9,9,5,5,6,6,12,12,4,4,15,15,2,2,9,9,0,0,0,0,2,2,13,13,7,7,10,10,0,0,0,0,7,7,9,9,0,0,13,13,2,2,10,10,8,8,0,0,1,1,6,6,9,9,5,5,4,4,9,9,14,14,1,1,4,4,4,4,7,7,2,2,10,10,3,3,3,3,12,12,11,11,5,5,0,0,15,15,12,12,1,1,9,9,4,4,13,13,3,3,10,10,1,1,8,8,13,13,3,3,2,2,13,13,0,0,11,11,4,4,3,3,11,11,0,0,0,0,3,3,7,7,5,5,4,4,7,7,12,12,3,3,1,1,0,0,4,4,9,9,0,0,11,11,11,11,0,0,12,12,3,3,12,12,11,11,15,15,1,1,7,7,11,11,7,7,8,8,9,9,13,13,8,8,0,0,4,4,0,0,1,1,8,8,7,7,14,14,15,15,10,10,3,3,4,4,5,5,8,8,14,14,4,4,0,0,8,8,15,15,11,11,1,1,0,0,1,1,12,12,10,10,4,4,2,2,12,12,4,4,11,11,14,14,7,7,14,14,10,10,3,3,4,4,8,8,12,12,2,2,0,0,4,4,5,5,5,5,13,13,8,8,14,14,14,14,6,6,6,6,8,8,5,5,13,13,0,0,6,6,4,4,1,1,13,13,0,0,7,7,7,7,15,15,14,14,6,6,8,8,9,9,5,5,5,5,14,14,5,5,7,7,5,5,2,2,14,14,3,3,10,10,4,4,0,0,0,0,12,12,7,7,4,4,4,4,13,13,2,2,10,10,15,15,10,10,11,11,3,3,15,15,2,2,8,8,4,4,3,3,2,2,10,10,1,1,2,2,13,13,10,10,9,9,11,11,11,11,0,0,7,7,5,5,11,11,4,4,11,11,2,2,14,14,4,4,4,4,4,4,7,7,0,0,9,9,15,15,2,2,1,1,0,0,1,1,0,0,7,7,10,10,12,12,8,8,1,1,6,6,8,8,14,14,14,14,2,2,4,4,6,6,7,7,0,0,10,10,13,13,13,13,2,2,7,7,15,15,11,11,2,2,10,10,8,8,0,0,0,0,0,0,8,8,14,14,14,14,3,3,0,0,2,2,14,14,10,10,9,9,15,15,14,14,2,2,14,14,0,0,4,4,14,14,3,3,3,3,13,13,13,13,15,15,4,4,5,5,3,3,9,9,3,3,14,14,14,14,15,15,14,14,9,9,0,0,12,12,0,0,1,1,10,10,11,11,0,0,8,8,3,3,11,11,5,5,8,8,13,13,10,10,12,12,12,12,14,14,9,9,15,15,10,10,0,0,0,0,0,0,8,8,5,5,13,13,13,13,10,10,5,5,13,13,14,14,0,0,10,10,12,12,7,7,15,15,9,9,1,1,7,7,1,1,0,0,15,15,0,0,6,6,9,9,10,10,12,12,0,0,10,10,3,3,0,0,9,9,13,13,15,15,3,3,4,4,2,2,5,5,1,1,9,9,0,0,13,13,12,12,8,8,1,1,8,8,4,4,4,4,10,10,4,4,1,1,0,0,4,4,0,0,6,6,7,7,12,12,3,3,5,5,0,0,13,13,7,7,8,8,4,4,4,4,10,10,6,6,9,9,0,0,9,9,10,10,12,12,0,0,11,11,5,5,3,3,5,5,15,15,8,8,15,15,8,8,5,5,3,3,0,0,15,15,8,8,2,2,1,1,8,8,4,4,15,15,10,10,3,3,4,4,8,8,1,1,3,3,7,7,14,14,6,6,14,14,6,6,11,11,11,11,14,14,8,8,4,4,6,6,8,8,6,6,8,8,13,13,8,8,1,1,7,7,1,1,0,0,6,6,6,6,6,6,9,9,6,6,9,9,4,4,5,5,1,1,15,15,4,4,7,7,12,12,9,9,8,8,4,4,1,1,12,12,1,1,4,4,10,10,7,7,11,11,1,1,5,5,4,4,1,1,2,2,0,0,4,4,12,12,8,8,11,11,13,13,0,0,6,6,14,14,5,5,9,9,14,14,15,15,4,4,7,7,9,9,4,4,6,6,1,1,9,9,0,0,1,1,14,14,15,15,12,12,13,13,9,9,7,7,7,7,8,8,7,7,11,11,7,7,10,10,10,10,15,15,2,2,3,3,8,8,0,0,3,3,3,3,11,11,9,9,11,11,1,1,10,10,5,5,4,4,15,15,10,10,7,7,15,15,4,4,10,10,0,0,0,0,3,3,3,3,11,11,7,7,15,15,12,12,13,13,6,6,11,11,12,12,0,0,0,0,2,2,12,12,10,10,5,5,8,8,3,3,6,6,1,1,14,14,2,2,13,13,0,0,1,1,0,0,6,6,12,12,9,9,5,5,2,2,13,13,14,14,2,2,7,7,4,4,0,0,7,7,9,9,7,7,13,13,6,6,14,14,8,8,8,8,14,14,0,0,15,15,9,9,12,12,7,7,12,12,12,12,4,4,12,12,0,0,6,6,9,9,9,9,14,14,4,4,8,8,7,7,13,13,7,7,8,8,3,3,13,13,8,8,3,3,7,7,5,5,0,0,8,8,3,3,15,15,12,12,5,5,10,10,3,3,0,0,13,13,0,0,6,6,3,3,2,2,1,1,7,7,4,4,7,7,4,4,5,5,9,9,11,11,14,14,15,15,3,3,9,9,2,2,10,10,9,9,0,0,2,2,5,5,12,12,7,7,10,10,11,11,12,12,15,15,8,8,3,3,8,8,4,4,7,7,11,11,4,4,0,0,12,12,13,13,1,1,11,11,15,15,2,2,13,13,15,15,11,11,0,0,14,14,15,15,6,6,8,8,14,14,11,11,2,2,3,3,12,12,11,11,8,8,12,12,5,5,6,6,15,15,1,1,8,8,2,2,8,8,14,14,8,8,8,8,3,3,4,4,10,10,4,4,2,2,12,12,6,6,7,7,12,12,5,5,10,10,15,15,13,13,3,3,15,15,14,14,5,5,1,1,14,14,10,10,9,9,4,4,15,15,6,6,1,1,8,8,6,6,0,0,1,1,14,14,2,2,8,8,3,3,6,6,14,14,15,15,0,0,12,12,3,3,4,4,8,8,4,4,12,12,0,0,9,9,8,8,5,5,9,9,4,4,6,6,4,4,1,1,6,6,10,10,6,6,9,9,13,13,3,3,11,11,4,4,5,5,0,0,2,2,9,9,13,13,2,2,12,12,14,14,2,2,15,15,0,0,13,13,0,0,7,7,2,2,10,10,6,6,3,3,4,4,11,11,1,1,4,4,8,8,1,1,5,5,15,15,9,9,8,8,7,7,2,2,8,8,12,12,13,13,0,0,14,14,15,15,9,9,3,3,1,1,11,11,14,14,7,7,0,0,5,5,1,1,13,13,9,9,13,13,9,9,1,1,8,8,15,15,13,13,15,15,14,14,7,7,9,9,15,15,3,3,9,9,2,2,1,1,11,11,14,14,8,8,11,11,13,13,9,9,4,4,13,13,8,8,10,10,13,13,7,7,13,13,4,4,13,13,6,6,2,2,1,1,10,10,2,2,1,1,4,4,1,1,3,3,0,0,10,10,3,3,14,14,15,15,6,6,2,2,11,11,9,9,0,0,7,7,1,1,10,10,0,0,2,2,6,6,11,11,3,3,15,15,7,7,14,14,2,2,1,1,5,5,6,6,14,14,6,6,13,13,7,7,7,7,7,7,5,5,1,1,7,7,12,12,2,2,7,7,2,2,14,14,6,6,6,6,5,5,5,5,13,13,8,8,6,6,3,3,4,4,2,2,5,5,12,12,2,2,4,4,9,9,14,14,15,15,11,11,2,2,2,2,12,12,9,9,15,15,14,14,4,4,15,15,8,8,0,0,12,12,10,10,3,3,13,13,1,1,14,14,0,0,12,12,1,1,6,6,12,12,15,15,8,8,12,12,14,14,13,13,15,15,3,3,11,11,6,6,6,6,10,10,14,14,1,1,6,6,0,0,2,2,4,4,15,15,5,5,3,3,6,6,8,8,9,9,11,11,15,15,6,6,8,8,15,15,13,13,11,11,4,4,0,0,4,4,4,4,3,3,1,1,6,6,12,12,6,6,10,10,8,8,12,12,3,3,5,5,4,4,9,9,1,1,10,10,3,3,4,4,3,3,13,13,6,6,1,1,9,9,10,10,6,6,2,2,12,12,5,5,15,15,6,6,11,11,14,14,10,10,8,8,15,15,2,2,15,15,11,11,8,8,1,1,14,14,5,5,0,0,8,8,15,15,14,14,14,14,2,2,10,10,2,2,14,14,6,6,1,1,11,11,2,2,4,4,12,12,11,11,11,11,10,10,4,4,0,0,7,7,3,3,11,11,0,0,5,5,13,13,14,14,2,2,0,0,1,1,6,6,6,6,2,2,7,7,0,0,4,4,0,0,5,5,6,6,4,4,1,1,7,7,5,5,2,2,2,2,0,0,7,7,11,11,11,11,9,9,2,2,2,2,0,0,10,10,0,0,11,11,12,12,5,5,14,14,3,3,14,14,6,6,12,12,8,8,4,4,6,6,11,11,1,1,8,8,14,14,1,1,4,4,14,14,1,1,1,1,11,11,15,15,2,2,2,2,12,12,4,4,9,9,2,2,14,14,12,12,5,5,12,12,15,15,10,10,1,1,13,13,11,11,6,6,14,14,5,5,11,11,5,5,11,11,0,0,0,0,7,7,5,5,0,0,0,0,6,6,8,8,2,2,13,13,10,10,12,12,10,10,2,2,4,4,10,10,12,12,13,13,4,4,4,4,8,8,6,6,12,12,7,7,13,13,6,6,15,15,0,0,2,2,9,9,2,2,2,2,5,5,8,8,7,7,13,13,13,13,14,14,8,8,11,11,6,6,0,0,9,9,0,0,8,8,4,4,13,13,14,14,7,7,0,0,0,0,6,6,9,9,15,15,9,9,1,1,15,15,6,6,10,10,8,8,14,14,1,1,12,12,14,14,8,8,1,1,9,9,5,5,14,14,8,8,2,2,3,3,12,12,9,9,4,4,2,2,4,4,4,4,0,0,4,4,0,0,10,10,9,9,12,12,9,9,11,11,6,6,15,15,14,14,7,7,7,7,8,8,13,13,9,9,1,1,8,8,11,11,5,5,2,2,2,2,15,15,4,4,10,10,10,10,2,2,14,14,5,5,7,7,7,7,7,7,0,0,1,1,5,5,5,5,5,5,10,10,11,11,10,10,6,6,0,0,1,1,10,10,14,14,0,0,5,5,7,7,1,1,7,7,13,13,12,12,15,15,4,4,7,7,8,8,11,11,9,9,13,13,3,3,6,6,14,14,15,15,9,9,10,10,1,1,10,10,3,3,2,2,13,13,5,5,6,6,7,7,12,12,10,10,11,11,11,11,4,4,1,1,12,12,14,14,0,0,1,1,14,14,12,12,0,0,0,0,11,11,2,2,11,11,14,14,11,11,6,6,2,2,14,14,3,3,11,11,1,1,12,12,6,6,4,4,2,2,8,8,4,4,8,8,11,11,12,12,3,3,10,10,8,8,12,12,10,10,6,6,13,13,0,0,14,14,8,8,9,9,10,10,9,9,6,6,0,0,6,6,0,0,1,1,8,8,13,13,3,3,3,3,3,3,8,8,12,12,9,9,10,10,14,14,6,6,1,1,3,3,7,7,1,1,3,3,4,4,6,6,10,10,6,6,10,10,10,10,8,8,4,4,1,1,9,9,6,6,5,5,8,8,0,0,13,13,5,5,1,1,3,3,8,8,4,4,6,6,4,4,7,7,1,1,12,12,4,4,8,8,3,3,0,0,10,10,14,14,3,3,6,6,0,0,6,6,0,0,5,5,10,10,6,6,13,13,12,12,2,2,9,9,2,2,11,11,6,6,9,9,1,1,1,1,8,8,11,11,4,4,2,2,12,12,6,6,3,3,14,14,15,15,11,11,1,1,7,7,1,1,12,12,9,9,3,3,7,7,8,8,1,1,3,3,7,7,8,8,6,6,9,9,10,10,9,9,14,14,3,3,1,1,1,1,0,0,12,12,5,5,14,14,7,7,1,1,6,6,13,13,11,11,11,11,15,15,6,6,12,12,7,7,3,3,4,4,7,7,7,7,0,0,4,4,3,3,0,0,6,6,1,1,12,12,13,13,4,4,10,10,9,9,1,1,13,13,7,7,13,13,4,4,12,12,14,14,5,5,10,10,5,5,10,10,8,8,3,3,10,10,2,2,4,4,13,13,8,8,0,0,4,4,12,12,10,10,1,1,12,12,2,2,5,5,14,14,1,1,4,4,11,11,9,9,14,14,4,4,1,1,3,3,12,12,7,7,10,10,14,14,15,15,10,10,11,11,6,6,6,6,9,9,6,6,11,11,9,9,9,9,5,5,9,9,14,14,3,3,0,0,4,4,4,4,5,5,12,12,1,1,14,14,3,3,14,14,2,2,15,15,14,14,8,8,2,2,8,8,11,11,8,8,5,5,11,11,14,14,14,14,10,10,2,2,5,5,6,6,6,6,13,13,12,12,10,10,8,8,1,1,2,2,13,13,2,2,3,3,14,14,3,3,8,8,14,14,12,12,1,1,10,10,15,15,10,10,9,9,0,0,3,3,2,2,8,8,8,8,5,5,8,8,0,0,7,7,4,4,14,14,10,10,2,2,7,7,11,11,4,4,2,2,6,6,3,3,10,10,4,4,0,0,4,4,3,3,2,2,0,0,8,8,5,5,1,1,5,5,12,12,11,11,13,13,7,7,6,6,0,0,9,9,15,15,10,10,8,8,0,0,11,11,9,9,3,3,0,0,8,8,2,2,4,4,3,3,10,10,2,2,2,2,1,1,15,15,1,1,12,12,5,5,3,3,13,13,12,12,10,10,12,12,0,0,6,6,8,8,3,3,5,5,14,14,15,15,10,10,0,0,4,4,15,15,11,11,4,4,4,4,5,5,3,3,4,4,10,10,14,14,10,10,11,11,11,11,15,15,6,6,10,10,2,2,2,2,14,14,0,0,10,10,15,15,5,5,1,1,1,1,5,5,3,3,1,1,8,8,15,15,6,6,15,15,11,11,12,12,0,0,14,14,0,0,2,2,2,2,15,15,3,3,9,9,2,2,13,13,8,8,3,3,4,4,2,2,2,2,7,7,3,3,15,15,3,3,9,9,8,8,14,14,6,6,9,9,10,10,10,10,7,7,5,5,14,14,13,13,4,4,1,1,3,3,12,12,15,15,4,4,1,1,5,5,3,3,2,2,4,4,14,14,3,3,10,10,4,4,0,0,14,14,13,13,8,8,4,4,15,15,12,12,13,13,6,6,0,0,8,8,1,1,7,7,8,8,9,9,8,8,7,7,6,6,2,2,11,11,4,4,2,2,15,15,0,0,15,15,6,6,12,12,2,2,1,1,2,2,13,13,7,7,6,6,14,14,3,3,7,7,8,8,1,1,7,7,14,14,5,5,13,13,5,5,14,14,6,6,4,4,3,3,4,4,13,13,10,10,0,0,1,1,3,3,4,4,10,10,4,4,14,14,0,0,0,0,10,10,6,6,1,1,5,5,9,9,1,1,2,2,8,8,10,10,4,4,9,9,4,4,9,9,14,14,14,14,3,3,4,4,9,9,8,8,6,6,15,15,9,9,1,1,7,7,12,12,3,3,11,11,11,11,15,15,1,1,9,9,7,7,6,6,14,14,6,6,6,6,7,7,3,3,2,2,14,14,8,8,4,4,9,9,8,8,8,8,5,5,7,7,11,11,13,13,6,6,6,6,7,7,14,14,7,7,1,1,8,8,4,4,10,10,5,5,1,1,12,12,4,4,2,2,2,2,7,7,15,15,4,4,3,3,4,4,7,7,6,6,9,9,7,7,12,12,13,13,10,10,7,7,5,5,4,4,5,5,5,5,6,6,6,6,1,1,0,0,7,7,7,7,8,8,10,10,5,5,3,3,8,8,8,8,4,4,9,9,12,12,1,1,12,12,6,6,5,5,4,4,3,3,13,13,4,4,11,11,9,9,8,8,15,15,8,8,4,4,8,8,1,1,1,1,15,15,4,4,5,5,1,1,5,5,7,7,2,2,14,14,15,15,11,11,3,3,15,15,1,1,10,10,11,11,4,4,4,4,2,2,14,14,7,7,3,3,12,12,0,0,6,6,10,10,13,13,14,14,5,5,8,8,15,15,7,7,3,3,10,10,15,15,5,5,9,9,8,8,3,3,6,6,1,1,14,14,6,6,13,13,7,7,9,9,5,5,5,5,1,1,8,8,0,0,10,10,0,0,8,8,14,14,9,9,6,6,3,3,0,0,8,8,5,5,7,7,14,14,12,12,9,9,8,8,5,5,6,6,2,2,8,8,10,10,15,15,13,13,14,14,4,4,9,9,1,1,3,3,3,3,6,6,4,4,1,1,4,4,10,10,13,13,3,3,9,9,0,0,7,7,3,3,10,10,13,13,8,8,0,0,12,12,3,3,12,12,9,9,14,14,13,13,0,0,1,1,9,9,4,4,15,15,13,13,10,10,2,2,4,4,1,1,13,13,4,4,9,9,2,2,5,5,15,15,13,13,2,2,13,13,10,10,15,15,0,0,12,12,12,12,6,6,12,12,7,7,3,3,1,1,2,2,14,14,0,0,2,2,7,7,0,0,9,9,11,11,0,0,8,8,4,4,9,9,6,6,13,13,8,8,14,14,10,10,6,6,1,1,2,2,6,6,10,10,15,15,14,14,6,6,3,3,2,2,4,4,8,8,3,3,5,5,4,4,5,5,8,8,3,3,2,2,1,1,14,14,12,12,10,10,7,7,10,10,12,12,11,11,6,6,6,6,4,4,0,0,10,10,0,0,14,14,12,12,12,12,10,10,14,14,8,8,3,3,6,6,3,3,9,9,0,0,15,15,2,2,8,8,10,10,14,14,6,6,10,10,2,2,3,3,13,13,0,0,6,6,5,5,0,0,10,10,15,15,12,12,10,10,1,1,4,4,11,11,14,14,8,8,15,15,15,15,10,10,13,13,4,4,11,11,6,6,2,2,0,0,2,2,15,15,0,0,13,13,10,10,0,0,5,5,13,13,5,5,12,12,5,5,12,12,8,8,8,8,15,15,4,4,0,0,7,7,0,0,8,8,1,1,10,10,1,1,11,11,13,13,12,12,0,0,9,9,6,6,7,7,0,0,9,9,12,12,3,3,8,8,9,9,13,13,2,2,15,15,0,0,8,8,9,9,12,12,11,11,8,8,9,9,14,14,11,11,8,8,14,14,15,15,9,9,6,6,9,9,14,14,2,2,2,2,4,4,2,2,14,14,10,10,3,3,4,4,11,11,7,7,5,5,1,1,5,5,11,11,9,9,2,2,12,12,15,15,1,1,8,8,5,5,13,13,14,14,15,15,2,2,7,7,7,7,11,11,6,6,14,14,12,12,13,13,12,12,4,4,11,11,5,5,7,7,7,7,5,5,7,7,1,1,11,11,11,11,3,3,6,6,11,11,2,2,14,14,4,4,11,11,9,9,2,2,12,12,10,10,2,2,13,13,9,9,11,11,15,15,13,13,8,8,8,8,10,10,11,11,1,1,12,12,8,8,14,14,9,9,9,9,4,4,10,10,1,1,5,5,11,11,0,0,13,13,7,7,8,8,12,12,1,1,3,3,4,4,14,14,1,1,12,12,8,8,6,6,0,0,2,2,2,2,3,3,14,14,0,0,7,7,8,8,6,6,6,6,7,7,9,9,0,0,1,1,1,1,13,13,0,0,3,3,10,10,7,7,13,13,9,9,11,11,4,4,0,0,1,1,13,13,13,13,6,6,14,14,5,5,11,11,11,11,11,11,1,1,13,13,4,4,8,8,12,12,12,12,15,15,12,12,1,1,0,0,10,10,8,8,3,3,5,5,7,7,14,14,13,13,8,8,15,15,5,5,1,1,12,12,2,2,13,13,7,7,12,12,3,3,10,10,12,12,1,1,1,1,14,14,12,12,2,2,12,12,1,1,12,12,8,8,8,8,1,1,12,12,5,5,12,12,10,10,8,8,9,9,0,0,4,4,0,0,0,0,8,8,3,3,1,1,7,7,4,4,10,10,8,8,6,6,15,15,8,8,6,6,13,13,9,9,4,4,5,5,14,14,8,8,10,10,11,11,6,6,15,15,3,3,11,11,3,3,8,8,8,8,7,7,10,10,0,0,10,10,5,5,0,0,12,12,0,0,7,7,6,6,13,13,12,12,5,5,14,14,5,5,6,6,3,3,14,14,12,12,8,8,1,1,12,12,13,13,13,13,11,11,3,3,3,3,2,2,14,14,14,14,12,12,13,13,4,4,11,11,8,8,10,10,0,0,1,1,7,7,12,12,14,14,0,0,7,7,12,12,4,4,15,15,0,0,0,0,10,10,5,5,10,10,2,2,6,6,12,12,7,7,11,11,9,9,12,12,1,1,7,7,1,1,4,4,15,15,2,2,2,2,12,12,12,12,8,8,3,3,14,14,12,12,13,13,3,3,4,4,7,7,6,6,14,14,10,10,10,10,0,0,0,0,1,1,14,14,13,13,8,8,6,6,7,7,6,6,5,5,9,9,5,5,1,1,4,4,15,15,2,2,2,2,4,4,2,2,8,8,15,15,4,4,15,15,15,15,15,15,9,9,3,3,2,2,3,3,2,2,8,8,7,7,14,14,4,4,12,12,3,3,6,6,13,13,9,9,14,14,9,9,2,2,2,2,2,2,2,2,0,0,12,12,12,12,2,2,4,4,0,0,1,1,13,13,12,12,15,15,6,6,9,9,4,4,14,14,13,13,11,11,3,3,7,7,8,8,1,1,7,7,10,10,12,12,13,13,8,8,2,2,9,9,2,2,9,9,9,9,9,9,4,4,7,7,11,11,5,5,8,8,3,3,12,12,7,7,8,8,4,4,4,4,3,3,13,13,7,7,15,15,4,4,0,0,8,8,1,1,1,1,11,11,2,2,2,2,6,6,0,0,6,6,7,7,0,0,13,13,1,1,2,2,3,3,13,13,9,9,10,10,13,13,12,12,2,2,4,4,4,4,12,12,14,14,8,8,4,4,14,14,8,8,15,15,4,4,4,4,14,14,5,5,6,6,12,12,13,13,0,0,9,9,8,8,11,11,5,5,10,10,9,9,13,13,1,1,9,9,2,2,1,1,9,9,2,2,3,3,14,14,14,14,13,13,7,7,0,0,6,6,1,1,1,1,14,14,8,8,2,2,9,9,8,8,13,13,4,4,11,11,8,8,13,13,15,15,13,13,10,10,14,14,4,4,1,1,11,11,4,4,15,15,6,6,13,13,10,10,6,6,4,4,2,2,8,8,12,12,5,5,7,7,0,0,11,11,1,1,14,14,5,5,3,3,13,13,10,10,6,6,11,11,1,1,0,0,14,14,13,13,0,0,10,10,1,1,5,5,8,8,14,14,9,9,11,11,1,1,14,14,7,7,3,3,3,3,12,12,2,2,9,9,10,10,10,10,14,14,4,4,6,6,5,5,10,10,15,15,7,7,10,10,13,13,15,15,9,9,9,9,4,4,10,10,2,2,2,2,4,4,4,4,13,13,11,11,6,6,14,14,10,10,3,3,1,1,8,8,3,3,1,1,2,2,12,12,14,14,11,11,0,0,5,5,5,5,2,2,3,3,0,0,2,2,0,0,6,6,9,9,14,14,2,2,9,9,10,10,4,4,4,4,10,10,6,6,7,7,14,14,2,2,1,1,10,10,12,12,5,5,10,10,5,5,10,10,8,8,10,10,8,8,2,2,8,8,4,4,7,7,8,8,15,15,4,4,2,2,2,2,15,15,7,7,0,0,6,6,10,10,12,12,1,1,7,7,12,12,5,5,3,3,10,10,13,13,4,4,15,15,4,4,15,15,7,7,12,12,10,10,5,5,15,15,15,15,13,13,1,1,13,13,5,5,12,12,9,9,10,10,8,8,12,12,3,3,9,9,0,0,1,1,0,0,9,9,11,11,12,12,11,11,8,8,10,10,1,1,6,6,10,10,7,7,15,15,4,4,11,11,2,2,6,6,0,0,5,5,8,8,5,5,7,7,13,13,11,11,7,7,15,15,1,1,4,4,4,4,7,7,1,1,15,15,13,13,13,13,5,5,11,11,2,2,3,3,1,1,11,11,13,13,8,8,9,9,5,5,14,14,0,0,2,2,15,15,7,7,10,10,9,9,3,3,0,0,14,14,8,8,14,14,8,8,11,11,10,10,2,2,7,7,14,14,8,8,10,10,3,3,12,12,10,10,3,3,12,12,6,6,0,0,6,6,5,5,0,0,12,12,2,2,13,13,7,7,12,12,1,1,7,7,12,12,13,13,11,11,12,12,5,5,0,0,11,11,9,9,1,1,7,7,5,5,8,8,12,12,5,5,14,14,6,6,10,10,4,4,15,15,7,7,4,4,3,3,0,0,5,5,2,2,3,3,12,12,10,10,2,2,2,2,14,14,14,14,7,7,2,2,4,4,11,11,15,15,15,15,14,14,0,0,0,0,11,11,11,11,12,12,2,2,14,14,1,1,7,7,7,7,6,6,13,13,5,5,14,14,10,10,11,11,9,9,2,2,9,9,14,14,2,2,2,2,4,4,13,13,15,15,1,1,5,5,0,0,10,10,3,3,9,9,6,6,10,10,0,0,7,7,0,0,2,2,7,7,4,4,2,2,8,8,2,2,9,9,9,9,8,8,6,6,15,15,8,8,15,15,9,9,5,5,4,4,0,0,12,12,11,11,12,12,6,6,3,3,1,1,7,7,1,1,5,5,5,5,13,13,2,2,11,11,3,3,12,12,15,15,9,9,3,3,5,5,4,4,1,1,5,5,13,13,13,13,7,7,7,7,9,9,13,13,10,10,15,15,5,5,0,0,9,9,12,12,4,4,5,5,15,15,6,6,14,14,15,15,8,8,5,5,2,2,11,11,4,4,12,12,15,15,3,3,4,4,2,2,4,4,11,11,10,10,6,6,14,14,1,1,4,4,11,11,8,8,10,10,4,4,5,5,0,0,11,11,12,12,13,13,11,11,9,9,3,3,1,1,12,12,10,10,13,13,9,9,14,14,12,12,10,10,3,3,6,6,9,9,12,12,5,5,12,12,14,14,1,1,4,4,15,15,5,5,9,9,0,0,15,15,4,4,10,10,6,6,14,14,2,2,14,14,3,3,8,8,3,3,9,9,13,13,10,10,13,13,5,5,10,10,12,12,5,5,3,3,6,6,14,14,13,13,9,9,5,5,0,0,6,6,11,11,14,14,12,12,11,11,10,10,4,4,9,9,15,15,4,4,10,10,12,12,11,11,0,0,12,12,7,7,2,2,2,2,10,10,5,5,7,7,11,11,10,10,11,11,2,2,3,3,9,9,0,0,11,11,1,1,10,10,4,4,5,5,14,14,8,8,1,1,7,7,6,6,1,1,9,9,9,9,0,0,8,8,3,3,2,2,6,6,4,4,7,7,11,11,10,10,4,4,10,10,5,5,8,8,11,11,12,12,13,13,5,5,3,3,6,6,14,14,12,12,9,9,3,3,0,0,11,11,14,14,8,8,9,9,0,0,7,7,9,9,7,7,15,15,14,14,15,15,9,9,6,6,1,1,4,4,10,10,12,12,2,2,4,4,8,8,1,1,9,9,5,5,11,11,0,0,8,8,15,15,6,6,1,1,7,7,0,0,14,14,9,9,11,11,15,15,6,6,11,11,6,6,13,13,6,6,7,7,9,9,12,12,12,12,15,15,10,10,14,14,6,6,1,1,2,2,8,8,2,2,14,14,6,6,15,15,6,6,7,7,14,14,7,7,14,14,8,8,10,10,1,1,1,1,8,8,15,15,12,12,10,10,14,14,2,2,12,12,2,2,5,5,4,4,1,1,15,15,13,13,15,15,14,14,10,10,8,8,15,15,11,11,8,8,8,8,0,0,6,6,4,4,15,15,14,14,4,4,4,4,4,4,5,5,8,8,5,5,10,10,7,7,8,8,1,1,5,5,4,4,13,13,0,0,13,13,11,11,13,13,9,9,8,8,3,3,14,14,12,12,0,0,0,0,1,1,1,1,13,13,9,9,12,12,8,8,1,1,2,2,2,2,9,9,8,8,3,3,3,3,2,2,5,5,1,1,11,11,4,4,11,11,1,1,13,13,10,10,13,13,4,4,6,6,0,0,15,15,4,4,9,9,11,11,10,10,12,12,7,7,4,4,13,13,1,1,8,8,7,7,14,14,10,10,4,4,14,14,2,2,4,4,14,14,13,13,13,13,12,12,8,8,5,5,4,4,0,0,0,0,12,12,13,13,2,2,7,7,13,13,9,9,3,3,14,14,3,3,10,10,1,1,1,1,13,13,15,15,6,6,2,2,12,12,14,14,15,15,15,15,11,11,0,0,5,5,0,0,10,10,2,2,1,1,4,4,8,8,11,11,3,3,10,10,2,2,2,2,10,10,0,0,10,10,2,2,13,13,2,2,0,0,2,2,11,11,7,7,1,1,11,11,1,1,10,10,0,0,7,7,8,8,15,15,6,6,1,1,2,2,13,13,0,0,15,15,1,1,10,10,9,9,15,15,1,1,12,12,14,14,10,10,0,0,13,13,5,5,2,2,1,1,10,10,2,2,2,2,0,0,9,9,13,13,13,13,1,1,13,13,10,10,2,2,10,10,14,14,5,5,1,1,0,0,9,9,15,15,4,4,7,7,5,5,14,14,7,7,12,12,5,5,15,15,0,0,11,11,12,12,13,13,6,6,7,7,1,1,9,9,0,0,11,11,4,4,12,12,3,3,9,9,10,10,5,5,13,13,8,8,10,10,4,4,10,10,14,14,0,0,15,15,10,10,3,3,5,5,13,13,6,6,7,7,12,12,2,2,13,13,5,5,1,1,3,3,11,11,2,2,11,11,9,9,11,11,2,2,2,2,0,0,1,1,11,11,15,15,14,14,15,15,14,14,4,4,15,15,0,0,9,9,13,13,5,5,4,4,12,12,6,6,7,7,9,9,4,4,5,5,1,1,0,0,11,11,8,8,1,1,9,9,3,3,5,5,13,13,15,15,7,7,2,2,1,1,14,14,1,1,13,13,12,12,1,1,14,14,0,0,6,6,13,13,4,4,2,2,13,13,9,9,6,6,6,6,3,3,0,0,11,11,0,0,8,8,15,15,8,8,10,10,11,11,6,6,15,15,9,9,9,9,7,7,0,0,8,8,10,10,15,15,11,11,2,2,5,5,0,0,6,6,8,8,6,6,8,8,1,1,14,14,2,2,9,9,6,6,12,12,9,9,8,8,8,8,6,6,9,9,14,14,15,15,6,6,2,2,0,0,9,9,12,12,14,14,1,1,11,11,7,7,5,5,12,12,10,10,2,2,14,14,1,1,12,12,6,6,8,8,7,7,2,2,13,13,13,13,12,12,4,4,4,4,15,15,0,0,11,11,13,13,11,11,11,11,15,15,8,8,2,2,0,0,1,1,13,13,8,8,5,5,1,1,4,4,6,6,6,6,11,11,6,6,2,2,1,1,1,1,3,3,0,0,4,4,2,2,2,2,9,9,3,3,14,14,2,2,15,15,7,7,3,3,14,14,12,12,5,5,2,2,12,12,2,2,0,0,7,7,6,6,15,15,9,9,7,7,5,5,1,1,13,13,7,7,1,1,1,1,11,11,5,5,5,5,14,14,1,1,4,4,10,10,10,10,9,9,3,3,1,1,1,1,0,0,10,10,5,5,7,7,14,14,10,10,3,3,7,7,11,11,3,3,12,12,3,3,0,0,13,13,0,0,5,5,15,15,14,14,13,13,4,4,3,3,10,10,4,4,7,7,1,1,8,8,8,8,3,3,8,8,10,10,12,12,4,4,14,14,8,8,7,7,14,14,12,12,5,5,4,4,6,6,12,12,12,12,2,2,6,6,7,7,0,0,2,2,15,15,4,4,2,2,4,4,12,12,1,1,13,13,0,0,14,14,14,14,1,1,4,4,11,11,3,3,3,3,7,7,3,3,7,7,4,4,6,6,0,0,0,0,3,3,0,0,5,5,8,8,0,0,14,14,12,12,4,4,1,1,9,9,7,7,12,12,4,4,8,8,0,0,2,2,10,10,9,9,10,10,12,12,4,4,4,4,2,2,1,1,7,7,11,11,9,9,5,5,4,4,3,3,13,13,3,3,8,8,12,12,5,5,1,1,15,15,14,14,1,1,3,3,8,8,3,3,1,1,1,1,8,8,0,0,0,0,6,6,2,2,10,10,3,3,1,1,12,12,2,2,0,0,2,2,7,7,1,1,8,8,7,7,13,13,13,13,14,14,8,8,7,7,0,0,12,12,3,3,11,11,5,5,11,11,14,14,2,2,1,1,0,0,12,12,15,15,13,13,2,2,5,5,1,1,6,6,3,3,5,5,6,6,2,2,8,8,12,12,9,9,0,0,14,14,14,14,8,8,12,12,14,14,4,4,10,10,3,3,5,5,2,2,14,14,4,4,8,8,0,0,4,4,10,10,13,13,4,4,7,7,0,0,7,7,1,1,12,12,6,6,7,7,12,12,10,10,2,2,6,6,9,9,12,12,9,9,4,4,2,2,15,15,14,14,2,2,12,12,7,7,8,8,12,12,9,9,0,0,8,8,8,8,6,6,7,7,9,9,10,10,10,10,9,9,8,8,0,0,5,5,5,5,9,9,9,9,0,0,2,2,14,14,14,14,8,8,12,12,11,11,3,3,8,8,6,6,13,13,6,6,15,15,6,6,7,7,11,11,15,15,10,10,7,7,5,5,0,0,6,6,14,14,12,12,9,9,1,1,1,1,15,15,8,8,10,10,3,3,9,9,7,7,7,7,0,0,9,9,9,9,10,10,8,8,8,8,12,12,10,10,15,15,15,15,9,9,5,5,3,3,14,14,3,3,13,13,15,15,2,2,0,0,12,12,8,8,15,15,7,7,0,0,2,2,15,15,7,7,11,11,2,2,0,0,4,4,10,10,10,10,1,1,7,7,6,6,13,13,9,9,5,5,10,10,11,11,0,0,14,14,9,9,8,8,3,3,7,7,10,10,11,11,4,4,3,3,10,10,0,0,0,0,1,1,5,5,6,6,9,9,13,13,10,10,9,9,9,9,7,7,11,11,8,8,8,8,10,10,6,6,11,11,8,8,6,6,3,3,3,3,6,6,4,4,7,7,10,10,4,4,8,8,4,4,13,13,5,5,8,8,5,5,4,4,8,8,7,7,1,1,2,2,7,7,2,2,6,6,7,7,5,5,1,1,13,13,14,14,2,2,9,9,8,8,1,1,0,0,2,2,6,6,5,5,8,8,0,0,1,1,14,14,12,12,15,15,9,9,4,4,10,10,15,15,9,9,0,0,12,12,4,4,12,12,14,14,7,7,8,8,4,4,14,14,14,14,11,11,3,3,8,8,9,9,9,9,10,10,3,3,4,4,11,11,3,3,10,10,1,1,6,6,14,14,0,0,8,8,10,10,5,5,4,4,15,15,0,0,15,15,0,0,6,6,6,6,2,2,15,15,1,1,15,15,0,0,13,13,15,15,10,10,2,2,9,9,13,13,7,7,10,10,13,13,3,3,0,0,6,6,5,5,5,5,4,4,8,8,12,12,14,14,8,8,14,14,11,11,12,12,8,8,10,10,6,6,14,14,12,12,5,5,2,2,1,1,5,5,7,7,7,7,6,6,5,5,1,1,14,14,9,9,10,10,1,1,4,4,14,14,15,15,7,7,8,8,12,12,6,6,14,14,11,11,7,7,2,2,2,2,7,7,10,10,0,0,4,4,10,10,13,13,6,6,14,14,5,5,1,1,3,3,10,10,5,5,4,4,15,15,8,8,0,0,5,5,5,5,2,2,2,2,14,14,8,8,2,2,9,9,5,5,11,11,3,3,9,9,15,15,6,6,11,11,6,6,0,0,0,0,0,0,6,6,12,12,8,8,1,1,11,11,0,0,6,6,12,12,5,5,8,8,6,6,12,12,8,8,1,1,1,1,8,8,6,6,13,13,7,7,0,0,3,3,0,0,2,2,7,7,0,0,5,5,14,14,11,11,7,7,1,1,11,11,14,14,12,12,2,2,7,7,4,4,6,6,13,13,12,12,13,13,0,0,14,14,5,5,3,3,8,8,1,1,3,3,10,10,15,15,0,0,10,10,8,8,9,9,0,0,2,2,1,1,15,15,0,0,2,2,10,10,8,8,8,8,15,15,10,10,3,3,8,8,15,15,9,9,1,1,3,3,15,15,6,6,10,10,10,10,9,9,10,10,9,9,9,9,2,2,2,2,7,7,4,4,13,13,12,12,11,11,14,14,14,14,2,2,10,10,13,13,0,0,1,1,4,4,10,10,11,11,14,14,2,2,1,1,14,14,4,4,10,10,12,12,4,4,8,8,9,9,14,14,1,1,8,8,6,6,15,15,1,1,10,10,1,1,6,6,15,15,7,7,1,1,12,12,1,1,11,11,2,2,2,2,10,10,8,8,6,6,5,5,15,15,1,1,3,3,13,13,1,1,3,3,12,12,4,4,3,3,11,11,2,2,9,9,12,12,8,8,2,2,11,11,1,1,7,7,4,4,14,14,15,15,9,9,10,10,14,14,1,1,10,10,4,4,11,11,8,8,5,5,13,13,6,6,8,8,6,6,2,2,0,0,6,6,10,10,14,14,7,7,6,6,13,13,3,3,6,6,14,14,2,2,0,0,3,3,12,12,0,0,5,5,7,7,11,11,3,3,6,6,2,2,9,9,3,3,11,11,7,7,6,6,1,1,8,8,12,12,9,9,5,5,10,10,14,14,0,0,7,7,11,11,10,10,5,5,5,5,5,5,1,1,11,11,8,8,4,4,10,10,2,2,8,8,1,1,7,7,8,8,3,3,11,11,4,4,1,1,12,12,10,10,0,0,12,12,1,1,7,7,2,2,9,9,5,5,7,7,2,2,7,7,11,11,0,0,1,1,1,1,6,6,4,4,6,6,12,12,9,9,2,2,15,15,0,0,3,3,11,11,2,2,8,8,13,13,9,9,3,3,8,8,5,5,9,9,13,13,7,7,10,10,2,2,9,9,11,11,7,7,4,4,3,3,3,3,15,15,10,10,13,13,9,9,5,5,15,15,7,7,10,10,8,8,15,15,5,5,10,10,14,14,4,4,6,6,14,14,6,6,9,9,3,3,13,13,13,13,11,11,8,8,0,0,8,8,0,0,0,0,10,10,0,0,2,2,12,12,8,8,0,0,15,15,4,4,13,13,4,4,0,0,5,5,3,3,13,13,2,2,1,1,2,2,4,4,5,5,4,4,10,10,11,11,9,9,0,0,12,12,2,2,10,10,10,10,1,1,1,1,6,6,11,11,7,7,13,13,0,0,2,2,12,12,4,4,0,0,4,4,3,3,1,1,13,13,1,1,0,0,15,15,12,12,0,0,11,11,9,9,9,9,3,3,0,0,4,4,12,12,10,10,14,14,3,3,14,14,3,3,13,13,7,7,6,6,3,3,11,11,5,5,7,7,2,2,4,4,13,13,3,3,2,2,12,12,4,4,11,11,0,0,9,9,12,12,6,6,15,15,8,8,9,9,6,6,9,9,1,1,12,12,9,9,4,4,14,14,12,12,1,1,10,10,3,3,4,4,11,11,8,8,5,5,8,8,11,11,3,3,13,13,6,6,2,2,0,0,1,1,12,12,6,6,14,14,4,4,5,5,1,1,6,6,14,14,9,9,2,2,5,5,13,13,14,14,1,1,3,3,1,1,7,7,12,12,7,7,15,15,15,15,10,10,8,8,14,14,6,6,12,12,0,0,14,14,9,9,8,8,13,13,13,13,15,15,4,4,12,12,5,5,3,3,14,14,1,1,9,9,5,5,7,7,9,9,13,13,0,0,8,8,13,13,7,7,9,9,14,14,13,13,11,11,7,7,15,15,3,3,1,1,5,5,6,6,1,1,2,2,10,10,10,10,11,11,0,0,5,5,3,3,10,10,10,10,10,10,7,7,10,10,5,5,12,12,15,15,1,1,8,8,1,1,9,9,10,10,3,3,8,8,5,5,0,0,0,0,9,9,14,14,14,14,12,12,2,2,5,5,0,0,0,0,8,8,6,6,2,2,13,13,4,4,12,12,5,5,4,4,7,7,7,7,0,0,5,5,14,14,1,1,12,12,12,12,8,8,12,12,7,7,10,10,8,8,5,5,9,9,0,0,15,15,15,15,13,13,15,15,15,15,6,6,15,15,12,12,3,3,5,5,3,3,11,11,0,0,13,13,5,5,8,8,14,14,2,2,12,12,7,7,0,0,14,14,11,11,1,1,13,13,12,12,13,13,0,0,12,12,1,1,14,14,15,15,6,6,7,7,3,3,11,11,8,8,6,6,4,4,2,2,6,6,4,4,10,10,11,11,2,2,12,12,12,12,12,12,6,6,1,1,11,11,12,12,3,3,9,9,7,7,9,9,8,8,5,5,12,12,5,5,2,2,11,11,8,8,9,9,2,2,4,4,12,12,7,7,10,10,5,5,2,2,4,4,6,6,5,5,1,1,2,2,3,3,0,0,10,10,8,8,9,9,14,14,0,0,0,0,12,12,4,4,6,6,11,11,9,9,12,12,15,15,0,0,12,12,6,6,8,8,6,6,9,9,0,0,8,8,9,9,12,12,8,8,4,4,0,0,3,3,4,4,2,2,10,10,8,8,15,15,15,15,8,8,14,14,8,8,4,4,6,6,3,3,0,0,2,2,4,4,10,10,14,14,5,5,0,0,3,3,6,6,8,8,4,4,2,2,13,13,6,6,5,5,8,8,3,3,6,6,0,0,10,10,15,15,8,8,1,1,5,5,12,12,14,14,14,14,11,11,10,10,8,8,14,14,1,1,1,1,1,1,14,14,0,0,3,3,8,8,13,13,10,10,13,13,8,8,0,0,5,5,14,14,6,6,5,5,5,5,4,4,7,7,1,1,10,10,10,10,6,6,11,11,9,9,5,5,3,3,4,4,15,15,1,1,4,4,10,10,0,0,6,6,12,12,7,7,4,4,15,15,11,11,8,8,9,9,7,7,3,3,2,2,10,10,13,13,0,0,1,1,3,3,14,14,3,3,2,2,15,15,6,6,7,7,7,7,7,7,6,6,12,12,12,12,15,15,12,12,1,1,7,7,6,6,3,3,2,2,13,13,0,0,2,2,10,10,0,0,8,8,1,1,0,0,13,13,9,9,2,2,15,15,5,5,8,8,12,12,10,10,10,10,9,9,13,13,4,4,5,5,15,15,8,8,6,6,1,1,0,0,5,5,3,3,6,6,4,4,12,12,4,4,15,15,8,8,1,1,11,11,10,10,12,12,0,0,3,3,15,15,0,0,0,0,5,5,9,9,15,15,6,6,1,1,10,10,1,1,9,9,4,4,7,7,9,9,7,7,4,4,0,0,10,10,5,5,12,12,12,12,6,6,14,14,7,7,5,5,15,15,7,7,11,11,7,7,7,7,13,13,3,3,13,13,0,0,15,15,13,13,9,9,7,7,8,8,1,1,9,9,1,1,4,4,1,1,4,4,13,13,2,2,12,12,8,8,3,3,3,3,8,8,9,9,8,8,14,14,1,1,9,9,10,10,4,4,15,15,1,1,5,5,12,12,15,15,8,8,0,0,14,14,9,9,6,6,13,13,12,12,1,1,9,9,0,0,6,6,14,14,0,0,14,14,11,11,10,10,5,5,14,14,0,0,3,3,0,0,6,6,6,6,8,8,4,4,1,1,11,11,2,2,15,15,14,14,12,12,11,11,0,0,15,15,4,4,7,7,13,13,5,5,7,7,0,0,14,14,10,10,7,7,14,14,9,9,6,6,7,7,1,1,0,0,10,10,9,9,12,12,13,13,2,2,2,2,14,14,8,8,4,4,6,6,10,10,9,9,1,1,2,2,7,7,7,7,3,3,6,6,12,12,11,11,11,11,14,14,14,14,12,12,8,8,10,10,15,15,14,14,6,6,13,13,15,15,0,0,6,6,5,5,12,12,1,1,5,5,11,11,3,3,9,9,8,8,12,12,10,10,5,5,1,1,11,11,2,2,3,3,6,6,2,2,2,2,8,8,13,13,5,5,3,3,9,9,4,4,11,11,11,11,12,12,3,3,1,1,10,10,15,15,14,14,0,0,4,4,5,5,1,1,4,4,5,5,7,7,9,9,4,4,5,5,3,3,2,2,12,12,0,0,10,10,14,14,11,11,13,13,12,12,10,10,4,4,12,12,8,8,11,11,4,4,9,9,4,4,1,1,14,14,10,10,4,4,15,15,2,2,11,11,3,3,13,13,13,13,15,15,13,13,15,15,8,8,4,4,5,5,8,8,4,4,2,2,7,7,11,11,6,6,1,1,12,12,1,1,3,3,11,11,15,15,13,13,0,0,7,7,8,8,8,8,1,1,14,14,15,15,10,10,15,15,5,5,3,3,1,1,10,10,14,14,6,6,1,1,6,6,0,0,1,1,9,9,1,1,9,9,7,7,9,9,1,1,14,14,10,10,8,8,14,14,6,6,9,9,2,2,1,1,9,9,0,0,13,13,8,8,14,14,10,10,14,14,6,6,2,2,3,3,9,9,12,12,9,9,3,3,11,11,7,7,1,1,11,11,7,7,6,6,10,10,9,9,1,1,2,2,7,7,0,0,8,8,15,15,5,5,10,10,12,12,10,10,4,4,6,6,11,11,15,15,0,0,5,5,6,6,6,6,9,9,11,11,6,6,12,12,11,11,1,1,10,10,13,13,10,10,6,6,0,0,4,4,15,15,7,7,3,3,11,11,15,15,15,15,15,15,14,14,2,2,0,0,10,10,0,0,5,5,15,15,3,3,0,0,2,2,2,2,5,5,0,0,9,9,10,10,11,11,5,5,10,10,2,2,0,0,10,10,10,10,14,14,7,7,1,1,11,11,5,5,2,2,0,0,12,12,9,9,15,15,4,4,1,1,9,9,10,10,14,14,10,10,15,15,11,11,10,10,7,7,13,13,7,7,12,12,13,13,13,13,12,12,12,12,1,1,12,12,11,11,13,13,9,9,7,7,8,8,4,4,4,4,2,2,0,0,3,3,9,9,2,2,6,6,2,2,7,7,10,10,11,11,10,10,15,15,11,11,1,1,9,9,1,1,10,10,13,13,15,15,2,2,1,1,10,10,5,5,12,12,6,6,5,5,10,10,8,8,6,6,9,9,11,11,6,6,5,5,7,7,4,4,12,12,0,0,0,0,6,6,15,15,6,6,1,1,14,14,1,1,3,3,4,4,15,15,14,14,6,6,13,13,6,6,3,3,14,14,14,14,0,0,4,4,1,1,5,5,0,0,7,7,0,0,4,4,1,1,6,6,10,10,13,13,2,2,2,2,4,4,0,0,13,13,8,8,11,11,8,8,7,7,11,11,8,8,5,5,12,12,5,5,11,11,8,8,3,3,4,4,11,11,7,7,5,5,1,1,3,3,10,10,3,3,12,12,12,12,9,9,6,6,5,5,12,12,1,1,1,1,13,13,0,0,2,2,7,7,1,1,3,3,2,2,15,15,5,5,9,9,3,3,8,8,15,15,6,6,6,6,3,3,4,4,3,3,15,15,6,6,5,5,0,0,11,11,8,8,5,5,2,2,5,5,2,2,6,6,3,3,9,9,9,9,1,1,8,8,11,11,0,0,6,6,11,11,15,15,1,1,1,1,0,0,14,14,10,10,6,6,13,13,0,0,4,4,15,15,0,0,9,9,0,0,10,10,13,13,1,1,7,7,0,0,3,3,4,4,13,13,2,2,4,4,15,15,2,2,10,10,13,13,1,1,2,2,10,10,12,12,6,6,7,7,11,11,7,7,0,0,2,2,11,11,11,11,8,8,11,11,8,8,6,6,1,1,14,14,14,14,4,4,10,10,5,5,0,0,4,4,15,15,15,15,6,6,15,15,0,0,2,2,1,1,7,7,4,4,0,0,4,4,14,14,8,8,1,1,7,7,6,6,14,14,6,6,0,0,7,7,11,11,0,0,9,9,8,8,15,15,8,8,9,9,12,12,6,6,5,5,4,4,0,0,3,3,15,15,14,14,1,1,6,6,11,11,11,11,14,14,5,5,2,2,6,6,2,2,15,15,4,4,14,14,4,4,11,11,0,0,8,8,11,11,6,6,11,11,15,15,13,13,15,15,9,9,3,3,13,13,11,11,3,3,5,5,1,1,0,0,12,12,6,6,15,15,15,15,0,0,7,7,12,12,8,8,2,2,10,10,4,4,12,12,11,11,14,14,1,1,11,11,13,13,15,15,15,15,1,1,0,0,14,14,2,2,4,4,6,6,6,6,6,6,15,15,2,2,5,5,10,10,8,8,3,3,3,3,10,10,3,3,5,5,12,12,11,11,11,11,0,0,6,6,11,11,15,15,0,0,0,0,6,6,8,8,9,9,6,6,0,0,7,7,10,10,0,0,14,14,2,2,8,8,10,10,2,2,15,15,3,3,11,11,0,0,6,6,15,15,10,10,9,9,4,4,4,4,15,15,9,9,8,8,7,7,2,2,12,12,9,9,0,0,8,8,15,15,11,11,7,7,11,11,14,14,1,1,3,3,9,9,3,3,6,6,11,11,2,2,3,3,13,13,11,11,8,8,0,0,14,14,8,8,11,11,10,10,5,5,9,9,11,11,2,2,12,12,11,11,5,5,9,9,12,12,7,7,5,5,11,11,8,8,9,9,8,8,9,9,3,3,0,0,9,9,3,3,6,6,7,7,10,10,5,5,3,3,3,3,15,15,14,14,2,2,15,15,11,11,12,12,11,11,14,14,2,2,2,2,15,15,15,15,13,13,7,7,7,7,5,5,12,12,5,5,1,1,6,6,1,1,7,7,9,9,12,12,4,4,1,1,5,5,9,9,6,6,14,14,4,4,10,10,0,0,12,12,0,0,15,15,3,3,7,7,8,8,10,10,3,3,11,11,1,1,6,6,3,3,0,0,14,14,9,9,2,2,14,14,14,14,5,5,1,1,2,2,7,7,6,6,14,14,13,13,5,5,0,0,11,11,1,1,10,10,1,1,10,10,4,4,1,1,11,11,4,4,3,3,12,12,5,5,14,14,4,4,12,12,4,4,11,11,14,14,3,3,4,4,14,14,6,6,11,11,0,0,2,2,0,0,7,7,8,8,9,9,1,1,5,5,2,2,2,2,11,11,3,3,11,11,5,5,7,7,5,5,4,4,9,9,10,10,14,14,12,12,13,13,3,3,5,5,1,1,3,3,7,7,2,2,8,8,2,2,1,1,9,9,1,1,4,4,6,6,14,14,4,4,9,9,2,2,9,9,6,6,8,8,12,12,8,8,15,15,4,4,4,4,8,8,8,8,3,3,0,0,5,5,0,0,13,13,10,10,3,3,13,13,9,9,0,0,4,4,14,14,6,6,1,1,4,4,4,4,2,2,0,0,2,2,10,10,3,3,11,11,1,1,5,5,8,8,0,0,10,10,10,10,10,10,14,14,12,12,9,9,8,8,8,8,10,10,1,1,6,6,10,10,2,2,4,4,0,0,12,12,8,8,15,15,10,10,2,2,11,11,5,5,11,11,5,5,14,14,7,7,10,10,11,11,0,0,11,11,13,13,8,8,15,15,7,7,7,7,14,14,9,9,7,7,10,10,10,10,3,3,8,8,3,3,12,12,5,5,9,9,10,10,8,8,10,10,10,10,1,1,0,0,9,9,9,9,9,9,5,5,1,1,9,9,8,8,13,13,10,10,5,5,12,12,10,10,14,14,6,6,3,3,2,2,5,5,13,13,15,15,0,0,15,15,0,0,2,2,15,15,9,9,2,2,0,0,12,12,9,9,4,4,5,5,12,12,2,2,9,9,12,12,0,0,4,4,15,15,1,1,15,15,3,3,6,6,4,4,9,9,11,11,13,13,5,5,9,9,4,4,1,1,8,8,11,11,0,0,10,10,9,9,7,7,14,14,12,12,2,2,12,12,1,1,1,1,4,4,7,7,8,8,14,14,6,6,1,1,5,5,12,12,11,11,13,13,0,0,3,3,13,13,11,11,9,9,15,15,8,8,7,7,4,4,6,6,6,6,2,2,7,7,11,11,12,12,0,0,8,8,5,5,13,13,1,1,3,3,6,6,15,15,13,13,11,11,12,12,7,7,12,12,6,6,4,4,1,1,10,10,6,6,11,11,14,14,1,1,5,5,12,12,9,9,14,14,8,8,2,2,3,3,11,11,1,1,14,14,11,11,5,5,9,9,3,3,0,0,6,6,12,12,1,1,4,4,4,4,10,10,14,14,14,14,12,12,8,8,8,8,3,3,3,3,6,6,10,10,5,5,1,1,3,3,8,8,8,8,11,11,2,2,12,12,10,10,13,13,1,1,7,7,10,10,5,5,9,9,13,13,12,12,9,9,12,12,7,7,2,2,7,7,9,9,6,6,0,0,4,4,0,0,8,8,7,7,11,11,5,5,5,5,12,12,9,9,13,13,5,5,8,8,12,12,9,9,14,14,1,1,13,13,10,10,6,6,14,14,10,10,13,13,6,6,11,11,9,9,3,3,3,3,0,0,5,5,15,15,12,12,0,0,14,14,14,14,3,3,13,13,7,7,10,10,0,0,10,10,7,7,0,0,9,9,9,9,7,7,11,11,7,7,3,3,6,6,2,2,6,6,7,7,6,6,1,1,3,3,2,2,8,8,9,9,8,8,0,0,10,10,9,9,15,15,9,9,2,2,13,13,3,3,10,10,14,14,6,6,9,9,11,11,5,5,3,3,8,8,3,3,1,1,0,0,1,1,9,9,15,15,8,8,10,10,6,6,8,8,13,13,6,6,12,12,3,3,14,14,9,9,5,5,7,7,2,2,9,9,13,13,10,10,1,1,5,5,14,14,8,8,3,3,1,1,7,7,4,4,1,1,12,12,4,4,2,2,7,7,2,2,0,0,15,15,8,8,8,8,9,9,0,0,13,13,3,3,5,5,1,1,8,8,0,0,9,9,9,9,2,2,1,1,8,8,5,5,1,1,8,8,9,9,2,2,12,12,14,14,4,4,9,9,10,10,4,4,6,6,5,5,0,0,10,10,9,9,4,4,10,10,12,12,2,2,12,12,0,0,1,1,0,0,13,13,0,0,5,5,9,9,3,3,15,15,2,2,1,1,1,1,7,7,5,5,0,0,8,8,12,12,0,0,5,5,6,6,11,11,12,12,11,11,0,0,7,7,0,0,0,0,10,10,2,2,13,13,8,8,0,0,2,2,13,13,1,1,8,8,12,12,2,2,13,13,1,1,12,12,2,2,1,1,5,5,2,2,3,3,0,0,0,0,6,6,9,9,7,7,5,5,9,9,3,3,13,13,4,4,4,4,11,11,13,13,4,4,9,9,15,15,9,9,10,10,5,5,4,4,9,9,4,4,11,11,5,5,3,3,14,14,0,0,10,10,4,4,8,8,11,11,6,6,5,5,12,12,5,5,9,9,4,4,7,7,6,6,11,11,6,6,6,6,12,12,11,11,7,7,15,15,0,0,0,0,12,12,10,10,5,5,1,1,4,4,8,8,8,8,10,10,8,8,9,9,1,1,4,4,14,14,3,3,13,13,13,13,11,11,11,11,13,13,11,11,12,12,6,6,3,3,7,7,1,1,10,10,13,13,8,8,4,4,7,7,3,3,2,2,5,5,8,8,11,11,5,5,2,2,2,2,12,12,14,14,4,4,11,11,0,0,10,10,2,2,1,1,3,3,13,13,0,0,9,9,4,4,10,10,6,6,4,4,5,5,2,2,2,2,11,11,9,9,7,7,11,11,14,14,4,4,9,9,15,15,1,1,8,8,15,15,9,9,4,4,11,11,9,9,11,11,15,15,9,9,13,13,6,6,5,5,3,3,11,11,13,13,14,14,13,13,6,6,12,12,13,13,4,4,9,9,1,1,8,8,2,2,9,9,2,2,9,9,8,8,11,11,6,6,2,2,3,3,0,0,10,10,13,13,12,12,0,0,1,1,11,11,0,0,8,8,14,14,1,1,11,11,11,11,1,1,0,0,10,10,7,7,9,9,3,3,14,14,13,13,6,6,0,0,12,12,4,4,15,15,8,8,4,4,14,14,8,8,4,4,13,13,12,12,8,8,15,15,15,15,3,3,7,7,1,1,2,2,0,0,2,2,9,9,13,13,6,6,4,4,1,1,12,12,3,3,14,14,6,6,7,7,4,4,1,1,14,14,10,10,9,9,3,3,8,8,9,9,0,0,1,1,7,7,12,12,9,9,1,1,7,7,1,1,14,14,3,3,0,0,3,3,1,1,9,9,13,13,9,9,1,1,2,2,3,3,9,9,0,0,12,12,12,12,14,14,2,2,0,0,11,11,4,4,10,10,0,0,8,8,2,2,7,7,8,8,9,9,2,2,6,6,7,7,12,12,7,7,10,10,0,0,3,3,0,0,11,11,15,15,14,14,8,8,4,4,0,0,8,8,10,10,9,9,2,2,10,10,5,5,15,15,15,15,5,5,3,3,14,14,2,2,5,5,12,12,12,12,9,9,3,3,7,7,8,8,2,2,12,12,12,12,10,10,7,7,6,6,1,1,4,4,12,12,7,7,3,3,11,11,10,10,13,13,8,8,11,11,10,10,1,1,6,6,8,8,15,15,7,7,4,4,4,4,0,0,1,1,8,8,6,6,8,8,0,0,14,14,11,11,6,6,7,7,11,11,4,4,9,9,2,2,10,10,15,15,13,13,6,6,2,2,3,3,9,9,3,3,5,5,1,1,1,1,14,14,13,13,5,5,11,11,14,14,2,2,15,15,6,6,0,0,6,6,1,1,5,5,10,10,9,9,7,7,7,7,2,2,11,11,9,9,2,2,0,0,12,12,7,7,9,9,9,9,2,2,4,4,5,5,0,0,8,8,10,10,15,15,14,14,3,3,7,7,15,15,1,1,0,0,11,11,1,1,8,8,5,5,2,2,9,9,15,15,8,8,2,2,11,11,3,3,1,1,12,12,12,12,8,8,1,1,3,3,13,13,9,9,1,1,9,9,1,1,1,1,10,10,8,8,2,2,0,0,2,2,10,10,6,6,0,0,12,12,11,11,7,7,14,14,3,3,11,11,15,15,13,13,14,14,3,3,15,15,1,1,7,7,8,8,5,5,8,8,8,8,1,1,5,5,14,14,6,6,8,8,6,6,3,3,12,12,10,10,6,6,12,12,9,9,9,9,3,3,10,10,2,2,9,9,5,5,6,6,14,14,8,8,5,5,8,8,6,6,13,13,15,15,9,9,2,2,15,15,9,9,4,4,8,8,9,9,4,4,12,12,7,7,8,8,11,11,6,6,6,6,3,3,3,3,14,14,12,12,7,7,14,14,14,14,2,2,13,13,9,9,2,2,13,13,4,4,12,12,14,14,9,9,10,10,5,5,5,5,12,12,11,11,1,1,12,12,14,14,5,5,6,6,3,3,5,5,9,9,14,14,1,1,14,14,1,1,11,11,15,15,1,1,6,6,4,4,15,15,4,4,14,14,11,11,3,3,3,3,14,14,9,9,6,6,4,4,0,0,3,3,4,4,10,10,4,4,13,13,1,1,8,8,4,4,1,1,14,14,3,3,7,7,6,6,8,8,1,1,12,12,10,10,9,9,3,3,7,7,14,14,1,1,4,4,10,10,9,9,0,0,9,9,8,8,5,5,10,10,9,9,6,6,9,9,0,0,10,10,1,1,2,2,13,13,3,3,0,0,2,2,6,6,13,13,13,13,13,13,5,5,9,9,12,12,6,6,6,6,1,1,11,11,15,15,4,4,11,11,2,2,7,7,15,15,0,0,15,15,6,6,4,4,4,4,8,8,0,0,2,2,15,15,7,7,5,5,2,2,13,13,6,6,1,1,4,4,1,1,9,9,4,4,3,3,7,7,10,10,10,10,11,11,6,6,8,8,3,3,10,10,6,6,4,4,12,12,7,7,1,1,11,11,10,10,14,14,8,8,3,3,0,0,12,12,2,2,4,4,7,7,12,12,0,0,11,11,6,6,10,10,0,0,13,13,6,6,12,12,0,0,0,0,12,12,14,14,0,0,2,2,5,5,11,11,6,6,4,4,1,1,11,11,3,3,7,7,12,12,5,5,14,14,13,13,5,5,4,4,3,3,12,12,14,14,8,8,14,14,3,3,11,11,9,9,14,14,3,3,12,12,15,15,14,14,5,5,9,9,10,10,15,15,8,8,9,9,2,2,6,6,4,4,4,4,7,7,1,1,1,1,3,3,3,3,4,4,5,5,9,9,1,1,11,11,7,7,9,9,3,3,8,8,4,4,14,14,5,5,12,12,9,9,4,4,15,15,12,12,0,0,10,10,9,9,6,6,8,8,2,2,11,11,5,5,14,14,11,11,5,5,1,1,8,8,9,9,8,8,4,4,3,3,11,11,10,10,2,2,2,2,8,8,6,6,9,9,1,1,14,14,8,8,9,9,5,5,3,3,14,14,1,1,2,2,2,2,5,5,9,9,3,3,9,9,1,1,15,15,9,9,3,3,5,5,4,4,12,12,1,1,8,8,0,0,3,3,11,11,11,11,4,4,13,13,4,4,9,9,5,5,15,15,1,1,5,5,10,10,1,1,15,15,9,9,11,11,8,8,11,11,4,4,6,6,14,14,0,0,13,13,13,13,2,2,10,10,5,5,15,15,12,12,2,2,2,2,2,2,3,3,1,1,0,0,1,1,0,0,15,15,5,5,13,13,8,8,5,5,13,13,1,1,1,1,2,2,1,1,12,12,13,13,12,12,13,13,3,3,6,6,14,14,15,15,9,9,15,15,6,6,10,10,0,0,1,1,4,4,12,12,5,5,13,13,7,7,4,4,3,3,0,0,13,13,14,14,0,0,10,10,11,11,2,2,1,1,2,2,10,10,5,5,9,9,15,15,6,6,5,5,9,9,9,9,3,3,10,10,14,14,14,14,7,7,12,12,2,2,1,1,0,0,13,13,6,6,9,9,9,9,14,14,5,5,12,12,0,0,3,3,11,11,11,11,15,15,13,13,1,1,0,0,3,3,12,12,9,9,10,10,0,0,2,2,13,13,6,6,13,13,12,12,12,12,3,3,12,12,4,4,12,12,12,12,13,13,3,3,12,12,0,0,13,13,3,3,7,7,14,14,5,5,6,6,0,0,4,4,5,5,3,3,3,3,13,13,12,12,15,15,11,11,9,9,1,1,5,5,11,11,6,6,2,2,12,12,6,6,6,6,1,1,12,12,4,4,10,10,15,15,10,10,14,14,9,9,0,0,0,0,6,6,2,2,3,3,4,4,12,12,0,0,12,12,14,14,0,0,5,5,1,1,15,15,2,2,5,5,8,8,8,8,3,3,9,9,8,8,13,13,4,4,2,2,9,9,5,5,3,3,9,9,5,5,3,3,8,8,4,4,1,1,5,5,7,7,11,11,12,12,14,14,0,0,0,0,2,2,10,10,1,1,9,9,8,8,15,15,2,2,3,3,7,7,4,4,8,8,6,6,5,5,13,13,10,10,3,3,7,7,6,6,12,12,12,12,9,9,12,12,10,10,5,5,2,2,9,9,10,10,7,7,15,15,2,2,13,13,15,15,1,1,14,14,8,8,3,3,9,9,5,5,1,1,10,10,5,5,2,2,15,15,13,13,5,5,0,0,6,6,10,10,3,3,13,13,8,8,8,8,10,10,1,1,6,6,9,9,4,4,11,11,13,13,15,15,6,6,7,7,5,5,1,1,7,7,6,6,4,4,8,8,7,7,4,4,3,3,0,0,12,12,1,1,14,14,5,5,1,1,15,15,7,7,10,10,14,14,11,11,13,13,5,5,11,11,15,15,10,10,9,9,12,12,0,0,10,10,11,11,7,7,13,13,8,8,3,3,8,8,3,3,14,14,11,11,7,7,9,9,1,1,4,4,10,10,9,9,8,8,4,4,8,8,2,2,2,2,3,3,11,11,2,2,11,11,5,5,0,0,2,2,1,1,15,15,4,4,10,10,8,8,15,15,4,4,4,4,8,8,3,3,7,7,7,7,4,4,14,14,15,15,3,3,2,2,8,8,8,8,7,7,1,1,3,3,15,15,14,14,9,9,13,13,11,11,2,2,8,8,7,7,5,5,3,3,8,8,15,15,12,12,6,6,1,1,12,12,13,13,4,4,4,4,11,11,10,10,0,0,1,1,10,10,2,2,10,10,11,11,0,0,8,8,13,13,10,10,0,0,0,0,7,7,8,8,6,6,8,8,1,1,15,15,14,14,14,14,9,9,10,10,7,7,5,5,5,5,14,14,12,12,1,1,7,7,4,4,14,14,4,4,9,9,10,10,2,2,15,15,3,3,10,10,10,10,10,10,0,0,7,7,6,6,7,7,5,5,5,5,10,10,2,2,7,7,13,13,8,8,7,7,11,11,6,6,0,0,10,10,14,14,7,7,8,8,7,7,2,2,15,15,10,10,14,14,1,1,6,6,12,12,15,15,9,9,13,13,5,5,7,7,15,15,3,3,4,4,4,4,5,5,0,0,10,10,4,4,9,9,13,13,8,8,2,2,8,8,0,0,13,13,15,15,11,11,10,10,11,11,10,10,11,11,1,1,1,1,2,2,11,11,3,3,11,11,7,7,0,0,0,0,4,4,3,3,9,9,2,2,6,6,4,4,13,13,15,15,3,3,6,6,14,14,12,12,5,5,9,9,4,4,9,9,12,12,15,15,4,4,3,3,12,12,7,7,6,6,9,9,4,4,8,8,6,6,10,10,7,7,14,14,2,2,4,4,7,7,12,12,11,11,10,10,7,7,4,4,9,9,4,4,15,15,10,10,7,7,1,1,7,7,12,12,12,12,13,13,12,12,15,15,13,13,6,6,6,6,13,13,11,11,5,5,1,1,2,2,7,7,2,2,9,9,3,3,3,3,6,6,7,7,5,5,14,14,2,2,14,14,3,3,11,11,13,13,11,11,7,7,14,14,6,6,6,6,1,1,5,5,7,7,8,8,5,5,2,2,12,12,14,14,5,5,9,9,5,5,8,8,10,10,9,9,2,2,0,0,5,5,8,8,14,14,2,2,6,6,15,15,1,1,11,11,5,5,2,2,0,0,11,11,8,8,11,11,10,10,1,1,4,4,1,1,9,9,1,1,1,1,12,12,9,9,0,0,12,12,8,8,14,14,7,7,3,3,14,14,11,11,6,6,12,12,1,1,10,10,8,8,6,6,3,3,15,15,4,4,1,1,15,15,3,3,0,0,11,11,9,9,6,6,6,6,2,2,7,7,13,13,14,14,12,12,11,11,7,7,14,14,8,8,9,9,4,4,12,12,13,13,3,3,1,1,6,6,2,2,15,15,2,2,10,10,6,6,5,5,10,10,11,11,6,6,9,9,2,2,4,4,4,4,6,6,6,6,13,13,14,14,15,15,8,8,7,7,10,10,2,2,10,10,15,15,5,5,12,12,9,9,4,4,12,12,10,10,12,12,6,6,14,14,1,1,9,9,9,9,5,5,8,8,11,11,9,9,2,2,12,12,5,5,4,4,5,5,8,8,15,15,0,0,11,11,2,2,9,9,7,7,13,13,11,11,5,5,12,12,11,11,10,10,0,0,11,11,12,12,15,15,11,11,10,10,7,7,2,2,1,1,0,0,13,13,3,3,13,13,9,9,9,9,8,8,11,11,4,4,5,5,10,10,8,8,6,6,4,4,15,15,13,13,1,1,8,8,8,8,5,5,10,10,4,4,11,11,3,3,0,0,15,15,1,1,4,4,12,12,2,2,11,11,2,2,7,7,3,3,2,2,12,12,3,3,6,6,10,10,6,6,13,13,10,10,5,5,12,12,14,14,5,5,10,10,6,6,15,15,7,7,9,9,12,12,0,0,3,3,10,10,3,3,13,13,9,9,15,15,10,10,9,9,9,9,10,10,11,11,10,10,5,5,2,2,3,3,10,10,2,2,3,3,15,15,1,1,12,12,6,6,9,9,15,15,5,5,6,6,2,2,10,10,1,1,4,4,10,10,4,4,1,1,5,5,12,12,6,6,15,15,0,0,0,0,4,4,10,10,10,10,12,12,5,5,4,4,1,1,15,15,7,7,14,14,10,10,8,8,8,8,4,4,11,11,12,12,1,1,8,8,3,3,5,5,7,7,3,3,1,1,15,15,1,1,10,10,3,3,2,2,14,14,2,2,11,11,7,7,10,10,0,0,10,10,1,1,14,14,9,9,1,1,8,8,12,12,1,1,7,7,15,15,4,4,10,10,5,5,1,1,9,9,10,10,4,4,5,5,7,7,15,15,2,2,11,11,5,5,5,5,2,2,3,3,8,8,4,4,3,3,0,0,4,4,15,15,3,3,3,3,13,13,15,15,5,5,2,2,3,3,11,11,14,14,11,11,13,13,3,3,8,8,0,0,0,0,11,11,0,0,9,9,10,10,12,12,5,5,8,8,2,2,4,4,8,8,10,10,12,12,3,3,10,10,4,4,4,4,6,6,1,1,8,8,8,8,15,15,12,12,9,9,12,12,9,9,14,14,4,4,8,8,9,9,12,12,6,6,8,8,8,8,12,12,1,1,4,4,3,3,3,3,15,15,5,5,3,3,15,15,13,13,9,9,3,3,4,4,4,4,0,0,14,14,1,1,7,7,8,8,4,4,13,13,3,3,1,1,14,14,15,15,3,3,13,13,14,14,4,4,14,14,10,10,12,12,7,7,11,11,2,2,13,13,6,6,14,14,6,6,9,9,4,4,4,4,11,11,2,2,8,8,1,1,0,0,12,12,13,13,14,14,4,4,9,9,15,15,4,4,4,4,0,0,5,5,3,3,6,6,3,3,4,4,14,14,15,15,12,12,14,14,7,7,2,2,2,2,14,14,5,5,9,9,1,1,9,9,1,1,13,13,12,12,10,10,13,13,3,3,15,15,15,15,2,2,1,1,12,12,11,11,7,7,0,0,8,8,3,3,11,11,1,1,15,15,10,10,8,8,7,7,6,6,0,0,12,12,11,11,9,9,14,14,11,11,4,4,13,13,12,12,11,11,3,3,2,2,4,4,11,11,12,12,3,3,14,14,10,10,14,14,4,4,0,0,1,1,11,11,3,3,12,12,1,1,5,5,3,3,10,10,3,3,12,12,12,12,7,7,6,6,3,3,14,14,3,3,0,0,2,2,11,11,2,2,8,8,2,2,1,1,6,6,8,8,9,9,8,8,14,14,5,5,14,14,15,15,6,6,6,6,1,1,5,5,3,3,2,2,11,11,12,12,11,11,8,8,13,13,9,9,2,2,0,0,6,6,12,12,11,11,8,8,10,10,0,0,2,2,9,9,8,8,11,11,14,14,2,2,8,8,8,8,0,0,4,4,8,8,6,6,2,2,0,0,9,9,3,3,9,9,13,13,14,14,10,10,12,12,11,11,5,5,6,6,12,12,8,8,5,5,0,0,12,12,7,7,3,3,7,7,6,6,8,8,2,2,6,6,13,13,0,0,8,8,7,7,13,13,14,14,2,2,2,2,2,2,14,14,8,8,13,13,1,1,7,7,4,4,5,5,8,8,5,5,8,8,12,12,2,2,13,13,4,4,1,1,7,7,4,4,2,2,2,2,8,8,13,13,2,2,1,1,8,8,0,0,7,7,3,3,7,7,14,14,2,2,6,6,7,7,11,11,8,8,0,0,1,1,2,2,13,13,1,1,1,1,15,15,2,2,5,5,6,6,3,3,12,12,12,12,11,11,4,4,14,14,13,13,13,13,12,12,2,2,6,6,13,13,0,0,14,14,4,4,1,1,0,0,15,15,5,5,11,11,3,3,7,7,11,11,8,8,3,3,12,12,0,0,8,8,6,6,9,9,3,3,7,7,13,13,4,4,1,1,2,2,5,5,1,1,8,8,2,2,12,12,7,7,1,1,14,14,5,5,1,1,11,11,7,7,1,1,0,0,3,3,1,1,12,12,11,11,15,15,1,1,2,2,5,5,3,3,8,8,9,9,8,8,6,6,15,15,3,3,10,10,7,7,7,7,12,12,9,9,5,5,6,6,10,10,6,6,4,4,0,0,14,14,0,0,4,4,14,14,4,4,2,2,4,4,8,8,10,10,15,15,0,0,4,4,10,10,8,8,7,7,13,13,14,14,8,8,4,4,3,3,12,12,9,9,8,8,6,6,7,7,1,1,9,9,9,9,4,4,14,14,11,11,8,8,6,6,12,12,5,5,7,7,10,10,4,4,15,15,12,12,9,9,2,2,10,10,11,11,6,6,7,7,0,0,0,0,3,3,3,3,12,12,5,5,9,9,7,7,10,10,3,3,10,10,14,14,2,2,8,8,8,8,5,5,0,0,15,15,0,0,12,12,13,13,4,4,1,1,4,4,12,12,10,10,1,1,9,9,15,15,2,2,2,2,3,3,3,3,2,2,10,10,6,6,2,2,3,3,11,11,3,3,14,14,2,2,13,13,13,13,7,7,14,14,3,3,5,5,0,0,4,4,3,3,7,7,8,8,3,3,12,12,14,14,5,5,10,10,2,2,15,15,15,15,7,7,13,13,2,2,11,11,12,12,0,0,11,11,1,1,9,9,14,14,6,6,9,9,11,11,13,13,1,1,0,0,2,2,15,15,3,3,8,8,11,11,5,5,2,2,8,8,3,3,10,10,3,3,8,8,10,10,11,11,12,12,10,10,1,1,9,9,2,2,8,8,3,3,12,12,0,0,14,14,3,3,14,14,4,4,6,6,6,6,11,11,11,11,13,13,6,6,5,5,8,8,3,3,12,12,0,0,4,4,0,0,2,2,0,0,13,13,10,10,3,3,15,15,6,6,1,1,3,3,13,13,5,5,7,7,12,12,4,4,4,4,12,12,6,6,15,15,13,13,5,5,12,12,6,6,7,7,1,1,0,0,13,13,2,2,9,9,8,8,0,0,5,5,15,15,9,9,11,11,5,5,1,1,6,6,1,1,3,3,4,4,3,3,5,5,0,0,6,6,13,13,12,12,1,1,1,1,4,4,4,4,3,3,1,1,9,9,3,3,12,12,0,0,7,7,0,0,12,12,4,4,7,7,11,11,11,11,11,11,9,9,15,15,9,9,9,9,0,0,0,0,3,3,7,7,14,14,12,12,13,13,3,3,12,12,9,9,2,2,5,5,4,4,12,12,3,3,11,11,3,3,15,15,11,11,1,1,12,12,14,14,8,8,3,3,13,13,0,0,15,15,13,13,14,14,15,15,14,14,3,3,13,13,8,8,12,12,1,1,9,9,7,7,10,10,13,13,4,4,0,0,11,11,2,2,6,6,15,15,11,11,10,10,4,4,12,12,1,1,5,5,15,15,8,8,9,9,9,9,8,8,1,1,10,10,15,15,7,7,5,5,1,1,8,8,2,2,12,12,12,12,5,5,6,6,12,12,4,4,15,15,7,7,14,14,1,1,15,15,1,1,9,9,8,8,13,13,2,2,13,13,0,0,12,12,10,10,13,13,10,10,11,11,5,5,1,1,0,0,6,6,7,7,14,14,10,10,0,0,3,3,10,10,1,1,4,4,0,0,11,11,14,14,15,15,1,1,2,2,13,13,15,15,1,1,4,4,2,2,9,9,8,8,15,15,14,14,14,14,0,0,9,9,4,4,8,8,12,12,3,3,8,8,1,1,13,13,10,10,1,1,5,5,8,8,1,1,0,0,8,8,13,13,12,12,0,0,8,8,0,0,7,7,9,9,13,13,11,11,2,2,0,0,4,4,14,14,1,1,3,3,0,0,8,8,11,11,11,11,9,9,9,9,4,4,12,12,1,1,3,3,15,15,10,10,2,2,8,8,10,10,10,10,4,4,11,11,8,8,1,1,12,12,11,11,6,6,5,5,15,15,9,9,1,1,5,5,7,7,2,2,7,7,1,1,14,14,10,10,2,2,3,3,10,10,10,10,14,14,8,8,0,0,2,2,4,4,2,2,8,8,15,15,4,4,2,2,5,5,8,8,0,0,10,10,9,9,0,0,1,1,1,1,2,2,10,10,12,12,4,4,14,14,1,1,8,8,7,7,9,9,3,3,14,14,8,8,12,12,15,15,11,11,4,4,6,6,9,9,8,8,8,8,7,7,10,10,12,12,9,9,8,8,9,9,10,10,9,9,1,1,4,4,4,4,10,10,11,11,5,5,7,7,6,6,15,15,3,3,14,14,0,0,2,2,11,11,0,0,5,5,4,4,8,8,4,4,4,4,12,12,10,10,4,4,14,14,6,6,5,5,2,2,7,7,12,12,1,1,8,8,9,9,1,1,11,11,5,5,6,6,1,1,10,10,7,7,13,13,11,11,1,1,6,6,9,9,7,7,1,1,0,0,12,12,11,11,10,10,10,10,15,15,4,4,0,0,9,9,9,9,0,0,14,14,5,5,10,10,2,2,7,7,9,9,11,11,15,15,13,13,5,5,3,3,0,0,4,4,9,9,10,10,4,4,13,13,6,6,5,5,4,4,6,6,10,10,10,10,14,14,6,6,12,12,11,11,15,15,0,0,0,0,2,2,3,3,1,1,1,1,15,15,13,13,14,14,5,5,1,1,3,3,0,0,1,1,5,5,12,12,0,0,13,13,6,6,8,8,9,9,11,11,5,5,10,10,13,13,11,11,3,3,0,0,10,10,3,3,8,8,14,14,9,9,13,13,14,14,8,8,14,14,14,14,8,8,1,1,2,2,8,8,7,7,15,15,10,10,8,8,5,5,1,1,3,3,0,0,2,2,0,0,2,2,8,8,11,11,14,14,15,15,9,9,6,6,15,15,6,6,12,12,5,5,8,8,7,7,11,11,9,9,2,2,5,5,8,8,14,14,5,5,2,2,14,14,3,3,15,15,13,13,14,14,8,8,5,5,3,3,7,7,7,7,6,6,4,4,3,3,11,11,0,0,9,9,5,5,1,1,2,2,6,6,0,0,5,5,14,14,14,14,4,4,6,6,9,9,1,1,6,6,6,6,8,8,5,5,14,14,9,9,7,7,14,14,11,11,10,10,5,5,1,1,0,0,7,7,0,0,3,3,8,8,8,8,12,12,13,13,12,12,9,9,1,1,15,15,5,5,9,9,3,3,12,12,12,12,12,12,5,5,2,2,13,13,4,4,0,0,2,2,8,8,0,0,8,8,14,14,7,7,0,0,9,9,7,7,1,1,12,12,15,15,6,6,14,14,12,12,7,7,5,5,4,4,10,10,2,2,3,3,6,6,12,12,5,5,4,4,6,6,1,1,2,2,7,7,0,0,1,1,10,10,7,7,9,9,13,13,8,8,0,0,0,0,11,11,3,3,8,8,7,7,13,13,11,11,0,0,7,7,3,3,14,14,0,0,10,10,12,12,6,6,9,9,5,5,1,1,7,7,9,9,7,7,15,15,6,6,14,14,4,4,13,13,15,15,7,7,5,5,12,12,7,7,8,8,1,1,11,11,2,2,5,5,15,15,5,5,15,15,1,1,6,6,7,7,2,2,10,10,8,8,14,14,3,3,4,4,0,0,10,10,2,2,1,1,15,15,14,14,8,8,2,2,14,14,5,5,14,14,8,8,6,6,9,9,0,0,10,10,9,9,5,5,15,15,5,5,11,11,12,12,1,1,7,7,13,13,9,9,15,15,1,1,8,8,1,1,5,5,14,14,6,6,0,0,0,0,2,2,10,10,3,3,1,1,3,3,11,11,14,14,12,12,10,10,4,4,8,8,8,8,9,9,2,2,10,10,4,4,4,4,15,15,15,15,8,8,2,2,0,0,10,10,0,0,1,1,13,13,3,3,1,1,3,3,13,13,10,10,12,12,1,1,9,9,10,10,4,4,10,10,3,3,15,15,4,4,2,2,14,14,5,5,7,7,7,7,1,1,4,4,13,13,9,9,5,5,14,14,4,4,12,12,5,5,4,4,11,11,7,7,9,9,0,0,12,12,9,9,2,2,9,9,13,13,3,3,5,5,12,12,10,10,15,15,0,0,5,5,6,6,6,6,0,0,8,8,4,4,6,6,12,12,10,10,8,8,11,11,3,3,5,5,1,1,7,7,5,5,2,2,0,0,2,2,10,10,9,9,13,13,12,12,10,10,12,12,0,0,6,6,6,6,12,12,12,12,15,15,9,9,3,3,9,9,12,12,3,3,13,13,11,11,4,4,4,4,11,11,6,6,15,15,6,6,11,11,5,5,11,11,0,0,3,3,6,6,11,11,15,15,12,12,8,8,3,3,11,11,5,5,0,0,3,3,15,15,3,3,9,9,4,4,11,11,6,6,1,1,9,9,4,4,0,0,1,1,12,12,7,7,7,7,9,9,10,10,6,6,4,4,2,2,12,12,6,6,4,4,1,1,14,14,9,9,6,6,9,9,3,3,1,1,4,4,2,2,10,10,1,1,6,6,14,14,0,0,4,4,14,14,10,10,14,14,10,10,0,0,6,6,1,1,15,15,8,8,8,8,6,6,12,12,3,3,0,0,11,11,2,2,0,0,2,2,9,9,2,2,2,2,5,5,1,1,6,6,9,9,11,11,11,11,5,5,13,13,14,14,9,9,7,7,1,1,4,4,11,11,0,0,6,6,14,14,8,8,6,6,9,9,0,0,0,0,4,4,1,1,7,7,8,8,6,6,14,14,2,2,3,3,8,8,12,12,13,13,11,11,4,4,9,9,5,5,15,15,6,6,8,8,5,5,4,4,10,10,10,10,15,15,9,9,12,12,2,2,11,11,15,15,9,9,0,0,0,0,1,1,9,9,10,10,7,7,4,4,3,3,6,6,1,1,11,11,2,2,15,15,10,10,14,14,11,11,4,4,5,5,15,15,4,4,2,2,11,11,10,10,5,5,14,14,4,4,6,6,11,11,11,11,7,7,11,11,2,2,5,5,12,12,14,14,1,1,14,14,15,15,12,12,1,1,7,7,9,9,12,12,15,15,15,15,1,1,8,8,11,11,10,10,0,0,7,7,15,15,14,14,13,13,14,14,1,1,2,2,5,5,0,0,3,3,2,2,1,1,1,1,0,0,9,9,3,3,2,2,7,7,10,10,2,2,0,0,8,8,15,15,6,6,7,7,11,11,4,4,3,3,4,4,13,13,13,13,11,11,0,0,6,6,5,5,6,6,14,14,3,3,7,7,6,6,9,9,5,5,1,1,3,3,0,0,0,0,1,1,1,1,4,4,1,1,14,14,6,6,2,2,8,8,15,15,6,6,9,9,11,11,9,9,11,11,7,7,6,6,12,12,6,6,1,1,10,10,8,8,0,0,3,3,2,2,0,0,8,8,12,12,10,10,2,2,14,14,9,9,14,14,0,0,3,3,3,3,11,11,0,0,0,0,8,8,6,6,9,9,7,7,12,12,13,13,0,0,0,0,13,13,10,10,4,4,4,4,13,13,14,14,12,12,14,14,15,15,15,15,2,2,3,3,5,5,12,12,3,3,15,15,15,15,11,11,15,15,10,10,9,9,13,13,15,15,10,10,14,14,5,5,5,5,6,6,9,9,3,3,9,9,7,7,1,1,1,1,2,2,11,11,6,6,9,9,12,12,3,3,1,1,6,6,4,4,8,8,5,5,6,6,8,8,11,11,0,0,4,4,15,15,5,5,4,4,11,11,6,6,4,4,10,10,14,14,6,6,10,10,3,3,6,6,14,14,4,4,3,3,13,13,14,14,0,0,3,3,7,7,4,4,14,14,6,6,6,6,8,8,9,9,3,3,7,7,9,9,10,10,8,8,10,10,14,14,4,4,9,9,7,7,13,13,0,0,11,11,5,5,3,3,8,8,9,9,4,4,5,5,5,5,7,7,4,4,13,13,15,15,5,5,1,1,12,12,13,13,9,9,13,13,14,14,3,3,4,4,13,13,4,4,14,14,11,11,9,9,7,7,14,14,14,14,1,1,9,9,10,10,14,14,12,12,3,3,1,1,13,13,10,10,9,9,8,8,1,1,12,12,5,5,2,2,6,6,1,1,11,11,9,9,9,9,6,6,2,2,9,9,15,15,11,11,14,14,1,1,3,3,13,13,15,15,2,2,7,7,1,1,11,11,3,3,5,5,13,13,8,8,8,8,13,13,0,0,13,13,3,3,7,7,14,14,8,8,1,1,10,10,11,11,4,4,5,5,2,2,7,7,6,6,14,14,5,5,13,13,3,3,12,12,10,10,13,13,0,0,3,3,9,9,12,12,14,14,12,12,15,15,10,10,4,4,9,9,14,14,14,14,8,8,15,15,11,11,13,13,0,0,10,10,12,12,6,6,11,11,2,2,3,3,12,12,2,2,1,1,5,5,1,1,14,14,9,9,14,14,4,4,7,7,14,14,12,12,15,15,10,10,5,5,9,9,11,11,3,3,9,9,9,9,1,1,13,13,2,2,13,13,13,13,8,8,5,5,11,11,8,8,6,6,5,5,3,3,6,6,8,8,7,7,1,1,6,6,3,3,0,0,5,5,9,9,7,7,3,3,15,15,7,7,8,8,1,1,5,5,14,14,2,2,0,0,10,10,0,0,8,8,4,4,10,10,10,10,15,15,4,4,4,4,0,0,2,2,5,5,14,14,4,4,14,14,5,5,0,0,3,3,8,8,10,10,7,7,15,15,7,7,9,9,11,11,1,1,7,7,9,9,4,4,2,2,6,6,14,14,4,4,0,0,9,9,14,14,14,14,2,2,12,12,14,14,11,11,0,0,14,14,11,11,0,0,10,10,4,4,4,4,0,0,9,9,7,7,10,10,2,2,6,6,10,10,8,8,7,7,8,8,5,5,15,15,4,4,2,2,5,5,4,4,14,14,9,9,2,2,4,4,13,13,11,11,3,3,1,1,0,0,14,14,6,6,0,0,0,0,3,3,9,9,11,11,13,13,11,11,12,12,14,14,1,1,1,1,2,2,2,2,14,14,6,6,3,3,13,13,15,15,12,12,13,13,1,1,0,0,13,13,6,6,8,8,3,3,6,6,7,7,3,3,8,8,0,0,3,3,5,5,14,14,15,15,10,10,7,7,6,6,15,15,6,6,6,6,1,1,14,14,14,14,1,1,4,4,6,6,8,8,12,12,6,6,13,13,8,8,11,11,5,5,15,15,2,2,7,7,8,8,2,2,1,1,14,14,13,13,6,6,6,6,7,7,14,14,9,9,0,0,15,15,10,10,1,1,4,4,1,1,11,11,2,2,15,15,7,7,12,12,3,3,5,5,1,1,13,13,4,4,6,6,5,5,11,11,6,6,4,4,3,3,6,6,1,1,13,13,6,6,2,2,11,11,6,6,8,8,7,7,5,5,1,1,14,14,2,2,13,13,12,12,0,0,5,5,8,8,8,8,7,7,10,10,12,12,7,7,9,9,4,4,13,13,5,5,12,12,8,8,7,7,10,10,11,11,5,5,0,0,2,2,7,7,9,9,13,13,9,9,14,14,4,4,9,9,13,13,12,12,12,12,1,1,7,7,10,10,11,11,14,14,14,14,5,5,2,2,6,6,5,5,14,14,12,12,2,2,3,3,0,0,7,7,6,6,4,4,3,3,5,5,8,8,4,4,13,13,5,5,12,12,7,7,10,10,1,1,15,15,2,2,3,3,6,6,1,1,10,10,1,1,10,10,8,8,10,10,1,1,3,3,11,11,15,15,6,6,10,10,8,8,4,4,11,11,1,1,7,7,6,6,14,14,5,5,0,0,15,15,14,14,6,6,7,7,14,14,4,4,0,0,13,13,0,0,0,0,5,5,5,5,6,6,4,4,2,2,4,4,11,11,7,7,12,12,5,5,8,8,8,8,6,6,4,4,12,12,8,8,3,3,14,14,9,9,8,8,14,14,10,10,3,3,1,1,6,6,8,8,2,2,5,5,5,5,14,14,15,15,3,3,11,11,6,6,4,4,5,5,14,14,0,0,3,3,2,2,3,3,11,11,5,5,9,9,5,5,8,8,12,12,4,4,4,4,13,13,7,7,2,2,4,4,13,13,7,7,2,2,15,15,7,7,5,5,3,3,6,6,2,2,3,3,8,8,8,8,0,0,7,7,4,4,8,8,0,0,4,4,0,0,13,13,3,3,6,6,3,3,2,2,11,11,2,2,3,3,10,10,9,9,1,1,6,6,6,6,6,6,9,9,7,7,8,8,9,9,3,3,0,0,8,8,15,15,12,12,6,6,6,6,10,10,0,0,8,8,1,1,10,10,1,1,9,9,3,3,8,8,6,6,14,14,15,15,10,10,0,0,9,9,12,12,9,9,2,2,9,9,12,12,0,0,9,9,5,5,10,10,10,10,6,6,6,6,0,0,9,9,11,11,6,6,15,15,6,6,9,9,5,5,2,2,12,12,14,14,1,1,8,8,0,0,6,6,1,1,12,12,8,8,11,11,9,9,6,6,14,14,3,3,3,3,15,15,9,9,8,8,2,2,3,3,0,0,7,7,2,2,5,5,1,1,12,12,11,11,6,6,1,1,15,15,15,15,6,6,11,11,3,3,10,10,12,12,14,14,5,5,6,6,9,9,2,2,9,9,7,7,15,15,13,13,7,7,12,12,11,11,13,13,13,13,6,6,0,0,4,4,2,2,2,2,1,1,14,14,6,6,7,7,13,13,0,0,7,7,15,15,0,0,9,9,7,7,2,2,1,1,6,6,1,1,15,15,0,0,9,9,4,4,14,14,1,1,4,4,4,4,6,6,11,11,14,14,12,12,6,6,9,9,15,15,9,9,0,0,9,9,2,2,5,5,14,14,9,9,14,14,13,13,5,5,5,5,3,3,0,0,11,11,12,12,4,4,8,8,9,9,3,3,0,0,1,1,2,2,1,1,6,6,11,11,15,15,12,12,12,12,4,4,0,0,1,1,7,7,6,6,12,12,2,2,2,2,6,6,1,1,5,5,0,0,13,13,12,12,5,5,9,9,12,12,7,7,0,0,15,15,12,12,4,4,10,10,6,6,8,8,4,4,1,1,11,11,12,12,11,11,11,11,7,7,7,7,0,0,6,6,2,2,9,9,12,12,8,8,4,4,10,10,4,4,7,7,6,6,15,15,14,14,14,14,0,0,0,0,3,3,8,8,0,0,0,0,5,5,15,15,1,1,10,10,2,2,13,13,12,12,6,6,3,3,1,1,3,3,9,9,6,6,6,6,6,6,11,11,7,7,11,11,0,0,6,6,3,3,1,1,8,8,15,15,11,11,12,12,8,8,2,2,12,12,1,1,3,3,1,1,13,13,0,0,8,8,13,13,14,14,0,0,7,7,2,2,12,12,15,15,9,9,0,0,15,15,9,9,10,10,3,3,7,7,14,14,15,15,9,9,5,5,3,3,12,12,5,5,0,0,12,12,8,8,4,4,1,1,2,2,10,10,3,3,10,10,7,7,15,15,6,6,15,15,2,2,2,2,0,0,9,9,15,15,6,6,3,3,14,14,8,8,14,14,6,6,7,7,13,13,3,3,10,10,10,10,11,11,9,9,2,2,5,5,11,11,8,8,8,8,8,8,15,15,6,6,11,11,15,15,0,0,9,9,5,5,12,12,15,15,4,4,7,7,3,3,11,11,10,10,6,6,15,15,14,14,5,5,7,7,11,11,1,1,3,3,4,4,14,14,13,13,4,4,8,8,10,10,4,4,4,4,15,15,6,6,0,0,15,15,11,11,2,2,6,6,2,2,6,6,6,6,14,14,1,1,10,10,1,1,7,7,10,10,2,2,7,7,9,9,12,12,1,1,14,14,5,5,10,10,6,6,2,2,3,3,3,3,2,2,7,7,13,13,12,12,9,9,2,2,11,11,0,0,3,3,0,0,14,14,0,0,12,12,0,0,6,6,9,9,10,10,5,5,11,11,0,0,15,15,3,3,1,1,13,13,12,12,7,7,11,11,15,15,5,5,7,7,9,9,12,12,11,11,5,5,8,8,1,1,12,12,2,2,2,2,0,0,9,9,12,12,6,6,7,7,13,13,9,9,11,11,14,14,10,10,6,6,13,13,9,9,12,12,1,1,1,1,0,0,11,11,12,12,5,5,0,0,0,0,13,13,10,10,15,15,15,15,2,2,9,9,15,15,10,10,14,14,7,7,4,4,2,2,8,8,11,11,10,10,0,0,10,10,4,4,1,1,8,8,2,2,1,1,0,0,8,8,5,5,3,3,7,7,0,0,3,3,7,7,5,5,1,1,3,3,3,3,8,8,15,15,12,12,6,6,8,8,5,5,8,8,10,10,6,6,4,4,14,14,11,11,4,4,3,3,15,15,6,6,8,8,7,7,2,2,10,10,14,14,8,8,12,12,9,9,4,4,6,6,5,5,11,11,13,13,10,10,15,15,8,8,7,7,12,12,14,14,11,11,15,15,1,1,5,5,0,0,3,3,1,1,3,3,8,8,2,2,15,15,14,14,10,10,7,7,8,8,11,11,1,1,7,7,11,11,13,13,6,6,15,15,8,8,7,7,6,6,1,1,12,12,6,6,8,8,12,12,1,1,4,4,5,5,15,15,9,9,7,7,5,5,3,3,13,13,14,14,8,8,8,8,14,14,13,13,10,10,8,8,8,8,6,6,7,7,6,6,10,10,1,1,10,10,7,7,3,3,14,14,12,12,2,2,14,14,11,11,7,7,3,3,3,3,1,1,12,12,10,10,3,3,8,8,0,0,10,10,14,14,8,8,14,14,8,8,13,13,2,2,5,5,7,7,14,14,9,9,10,10,8,8,7,7,9,9,2,2,4,4,14,14,2,2,0,0,15,15,11,11,0,0,13,13,2,2,13,13,0,0,8,8,11,11,13,13,6,6,12,12,14,14,11,11,4,4,4,4,12,12,10,10,4,4,8,8,11,11,0,0,14,14,12,12,1,1,4,4,1,1,8,8,2,2,6,6,12,12,3,3,0,0,11,11,9,9,12,12,6,6,13,13,3,3,7,7,6,6,12,12,8,8,10,10,14,14,8,8,10,10,8,8,12,12,9,9,6,6,8,8,12,12,4,4,2,2,9,9,5,5,14,14,2,2,12,12,15,15,12,12,11,11,5,5,7,7,1,1,15,15,8,8,12,12,6,6,14,14,0,0,7,7,13,13,7,7,6,6,6,6,13,13,2,2,2,2,11,11,2,2,0,0,9,9,15,15,2,2,11,11,10,10,5,5,1,1,2,2,2,2,2,2,1,1,12,12,3,3,0,0,11,11,1,1,0,0,15,15,6,6,5,5,15,15,14,14,0,0,7,7,0,0,2,2,2,2,4,4,6,6,5,5,6,6,14,14,4,4,6,6,3,3,12,12,8,8,1,1,12,12,8,8,14,14,10,10,5,5,12,12,7,7,11,11,6,6,5,5,3,3,4,4,9,9,1,1,4,4,9,9,5,5,9,9,0,0,0,0,6,6,15,15,4,4,10,10,6,6,6,6,6,6,0,0,10,10,1,1,3,3,0,0,4,4,1,1,1,1,14,14,6,6,7,7,7,7,0,0,6,6,13,13,0,0,15,15,7,7,1,1,7,7,0,0,12,12,15,15,0,0,9,9,10,10,1,1,5,5,11,11,2,2,8,8,4,4,5,5,8,8,7,7,14,14,13,13,8,8,14,14,15,15,9,9,13,13,6,6,4,4,4,4,7,7,13,13,6,6,6,6,14,14,8,8,14,14,1,1,10,10,14,14,11,11,9,9,12,12,9,9,15,15,2,2,13,13,2,2,10,10,7,7,3,3,14,14,15,15,3,3,4,4,15,15,6,6,3,3,13,13,0,0,3,3,2,2,6,6,3,3,8,8,10,10,8,8,7,7,0,0,9,9,14,14,1,1,12,12,13,13,5,5,7,7,14,14,13,13,7,7,10,10,9,9,8,8,9,9,8,8,7,7,0,0,10,10,1,1,15,15,2,2,12,12,8,8,8,8,15,15,9,9,1,1,11,11,14,14,12,12,11,11,8,8,1,1,15,15,1,1,4,4,1,1,8,8,8,8,0,0,8,8,14,14,4,4,3,3,0,0,3,3,5,5,14,14,1,1,0,0,5,5,11,11,5,5,12,12,15,15,14,14,0,0,5,5,14,14,0,0,8,8,4,4,10,10,0,0,10,10,2,2,5,5,13,13,3,3,3,3,1,1,1,1,3,3,10,10,3,3,11,11,0,0,13,13,11,11,1,1,3,3,0,0,14,14,4,4,5,5,9,9,3,3,1,1,6,6,6,6,8,8,12,12,15,15,5,5,12,12,6,6,13,13,11,11,4,4,12,12,8,8,9,9,13,13,15,15,13,13,13,13,12,12,4,4,4,4,14,14,13,13,14,14,2,2,7,7,4,4,8,8,8,8,12,12,10,10,10,10,5,5,3,3,9,9,3,3,0,0,5,5,0,0,2,2,2,2,10,10,2,2,7,7,9,9,12,12,2,2,13,13,14,14,4,4,4,4,4,4,12,12,2,2,14,14,9,9,5,5,11,11,8,8,15,15,2,2,9,9,0,0,1,1,8,8,8,8,8,8,13,13,2,2,7,7,7,7,13,13,2,2,10,10,14,14,14,14,6,6,13,13,9,9,6,6,3,3,12,12,9,9,10,10,15,15,0,0,15,15,2,2,12,12,15,15,10,10,11,11,4,4,5,5,5,5,4,4,11,11,10,10,8,8,4,4,7,7,2,2,1,1,1,1,0,0,4,4,10,10,6,6,11,11,9,9,0,0,13,13,5,5,3,3,3,3,15,15,3,3,5,5,7,7,12,12,4,4,5,5,10,10,12,12,13,13,4,4,5,5,10,10,4,4,10,10,10,10,2,2,5,5,0,0,14,14,6,6,12,12,12,12,3,3,13,13,12,12,12,12,9,9,15,15,2,2,3,3,10,10,11,11,9,9,9,9,0,0,15,15,15,15,10,10,8,8,2,2,2,2,13,13,5,5,14,14,13,13,7,7,8,8,9,9,11,11,14,14,3,3,5,5,9,9,10,10,7,7,4,4,1,1,9,9,0,0,5,5,6,6,4,4,8,8,3,3,4,4,5,5,9,9,10,10,4,4,3,3,8,8,5,5,15,15,7,7,12,12,5,5,3,3,7,7,7,7,14,14,15,15,1,1,3,3,8,8,0,0,8,8,2,2,8,8,0,0,1,1,9,9,2,2,15,15,7,7,10,10,4,4,6,6,8,8,13,13,4,4,9,9,3,3,8,8,13,13,13,13,6,6,8,8,15,15,6,6,2,2,6,6,9,9,2,2,6,6,15,15,13,13,1,1,15,15,1,1,6,6,12,12,13,13,15,15,4,4,11,11,5,5,11,11,12,12,10,10,9,9,14,14,0,0,10,10,7,7,5,5,3,3,3,3,7,7,11,11,9,9,6,6,0,0,0,0,3,3,15,15,9,9,10,10,4,4,14,14,3,3,2,2,9,9,14,14,0,0,4,4,2,2,5,5,6,6,1,1,7,7,1,1,1,1,6,6,7,7,0,0,1,1,2,2,15,15,15,15,14,14,11,11,1,1,15,15,3,3,9,9,8,8,9,9,8,8,13,13,12,12,5,5,5,5,3,3,13,13,15,15,8,8,9,9,7,7,9,9,2,2,10,10,13,13,6,6,9,9,4,4,3,3,10,10,8,8,2,2,11,11,2,2,0,0,4,4,2,2,7,7,14,14,7,7,2,2,6,6,0,0,3,3,15,15,4,4,2,2,3,3,4,4,3,3,5,5,12,12,11,11,2,2,8,8,5,5,4,4,3,3,13,13,7,7,6,6,2,2,14,14,12,12,1,1,4,4,6,6,13,13,6,6,15,15,6,6,6,6,13,13,8,8,10,10,13,13,1,1,13,13,15,15,6,6,13,13,11,11,13,13,9,9,12,12,8,8,2,2,12,12,5,5,10,10,13,13,2,2,7,7,0,0,6,6,0,0,14,14,5,5,0,0,9,9,2,2,8,8,1,1,9,9,6,6,14,14,11,11,13,13,6,6,15,15,15,15,15,15,7,7,7,7,11,11,0,0,3,3,0,0,10,10,1,1,1,1,9,9,10,10,5,5,15,15,8,8,9,9,7,7,4,4,13,13,14,14,0,0,0,0,6,6,1,1,14,14,15,15,3,3,11,11,6,6,11,11,14,14,5,5,1,1,8,8,7,7,9,9,1,1,11,11,5,5,8,8,13,13,12,12,15,15,10,10,0,0,4,4,12,12,8,8,0,0,6,6,12,12,8,8,5,5,7,7,9,9,1,1,1,1,4,4,7,7,2,2,5,5,13,13,11,11,14,14,13,13,12,12,10,10,14,14,11,11,2,2,10,10,10,10,1,1,11,11,2,2,15,15,2,2,0,0,15,15,11,11,0,0,2,2,5,5,5,5,2,2,9,9,15,15,0,0,3,3,11,11,6,6,0,0,12,12,0,0,12,12,4,4,11,11,2,2,9,9,2,2,5,5,11,11,6,6,15,15,7,7,0,0,11,11,15,15,0,0,0,0,6,6,2,2,2,2,1,1,5,5,2,2,4,4,2,2,7,7,7,7,0,0,3,3,10,10,4,4,3,3,0,0,7,7,2,2,5,5,14,14,0,0,7,7,14,14,0,0,10,10,2,2,4,4,8,8,14,14,15,15,13,13,5,5,4,4,0,0,11,11,4,4,1,1,10,10,0,0,7,7,3,3,5,5,3,3,2,2,13,13,13,13,8,8,1,1,9,9,0,0,12,12,2,2,9,9,0,0,10,10,8,8,12,12,1,1,13,13,3,3,13,13,5,5,4,4,12,12,4,4,0,0,2,2,2,2,2,2,8,8,7,7,15,15,9,9,1,1,0,0,1,1,8,8,15,15,11,11,8,8,14,14,14,14,1,1,0,0,4,4,9,9,15,15,13,13,3,3,8,8,7,7,9,9,0,0,9,9,12,12,11,11,11,11,8,8,2,2,5,5,15,15,10,10,11,11,9,9,7,7,14,14,2,2,10,10,12,12,15,15,1,1,3,3,8,8,4,4,1,1,6,6,14,14,6,6,6,6,3,3,11,11,5,5,4,4,8,8,15,15,9,9,5,5,12,12,11,11,8,8,2,2,5,5,5,5,6,6,2,2,9,9,14,14,2,2,7,7,5,5,1,1,13,13,5,5,5,5,4,4,5,5,4,4,9,9,11,11,2,2,13,13,2,2,8,8,3,3,11,11,8,8,15,15,9,9,9,9,5,5,3,3,4,4,15,15,0,0,3,3,4,4,0,0,12,12,2,2,1,1,0,0,1,1,6,6,2,2,8,8,13,13,7,7,14,14,6,6,9,9,13,13,1,1,3,3,8,8,15,15,1,1,6,6,5,5,9,9,14,14,12,12,14,14,14,14,5,5,8,8,3,3,1,1,2,2,3,3,9,9,4,4,2,2,1,1,12,12,11,11,14,14,1,1,11,11,12,12,12,12,5,5,10,10,6,6,10,10,0,0,9,9,4,4,4,4,7,7,12,12,9,9,8,8,10,10,9,9,8,8,3,3,8,8,8,8,15,15,0,0,4,4,6,6,12,12,3,3,4,4,2,2,10,10,3,3,3,3,2,2,11,11,12,12,7,7,5,5,10,10,6,6,2,2,11,11,11,11,13,13,15,15,11,11,3,3,4,4,3,3,3,3,6,6,5,5,1,1,11,11,7,7,3,3,3,3,8,8,7,7,8,8,7,7,11,11,5,5,3,3,13,13,3,3,6,6,3,3,1,1,14,14,4,4,3,3,10,10,13,13,13,13,15,15,2,2,12,12,5,5,15,15,8,8,10,10,2,2,9,9,0,0,0,0,9,9,12,12,3,3,9,9,11,11,7,7,7,7,7,7,3,3,7,7,4,4,2,2,10,10,12,12,4,4,8,8,14,14,2,2,13,13,7,7,14,14,4,4,0,0,12,12,5,5,12,12,15,15,3,3,9,9,8,8,9,9,1,1,13,13,3,3,10,10,14,14,13,13,8,8,6,6,5,5,9,9,0,0,15,15,1,1,13,13,4,4,5,5,12,12,15,15,4,4,15,15,11,11,13,13,13,13,7,7,3,3,0,0,2,2,2,2,11,11,9,9,15,15,13,13,11,11,1,1,6,6,8,8,4,4,14,14,10,10,1,1,10,10,13,13,7,7,7,7,1,1,8,8,6,6,10,10,12,12,0,0,6,6,5,5,1,1,0,0,11,11,15,15,15,15,5,5,5,5,12,12,12,12,0,0,12,12,2,2,10,10,9,9,6,6,2,2,9,9,8,8,6,6,15,15,4,4,6,6,3,3,3,3,0,0,9,9,7,7,13,13,3,3,7,7,11,11,12,12,9,9,11,11,10,10,2,2,15,15,4,4,14,14,9,9,1,1,1,1,6,6,12,12,13,13,13,13,4,4,6,6,3,3,0,0,1,1,14,14,4,4,1,1,0,0,1,1,0,0,9,9,0,0,13,13,8,8,0,0,0,0,7,7,2,2,4,4,11,11,3,3,8,8,14,14,2,2,11,11,5,5,5,5,0,0,11,11,9,9,1,1,11,11,10,10,14,14,8,8,13,13,14,14,1,1,11,11,6,6,1,1,14,14,4,4,13,13,0,0,4,4,1,1,8,8,5,5,1,1,3,3,0,0,6,6,12,12,11,11,5,5,2,2,7,7,7,7,5,5,8,8,10,10,10,10,5,5,13,13,2,2,2,2,10,10,14,14,2,2,5,5,14,14,5,5,3,3,14,14,14,14,2,2,15,15,1,1,11,11,11,11,12,12,0,0,0,0,2,2,5,5,1,1,3,3,4,4,8,8,3,3,2,2,2,2,13,13,10,10,14,14,13,13,5,5,14,14,14,14,2,2,6,6,10,10,5,5,9,9,6,6,7,7,5,5,5,5,6,6,3,3,1,1,7,7,8,8,7,7,15,15,1,1,8,8,8,8,6,6,4,4,1,1,1,1,5,5,3,3,10,10,5,5,9,9,11,11,5,5,6,6,15,15,0,0,10,10,14,14,14,14,5,5,10,10,2,2,10,10,13,13,9,9,13,13,12,12,15,15,15,15,4,4,10,10,8,8,0,0,1,1,8,8,13,13,10,10,10,10,10,10,0,0,4,4,10,10,11,11,11,11,10,10,10,10,9,9,0,0,6,6,13,13,11,11,6,6,13,13,1,1,2,2,14,14,9,9,8,8,4,4,7,7,11,11,1,1,0,0,1,1,2,2,12,12,5,5,5,5,13,13,12,12,4,4,4,4,14,14,13,13,7,7,7,7,13,13,10,10,12,12,7,7,1,1,11,11,11,11,9,9,9,9,7,7,12,12,10,10,14,14,15,15,3,3,0,0,7,7,3,3,4,4,1,1,3,3,3,3,10,10,5,5,8,8,4,4,9,9,2,2,12,12,4,4,8,8,5,5,13,13,0,0,9,9,0,0,0,0,14,14,3,3,3,3,4,4,11,11,3,3,8,8,9,9,12,12,0,0,8,8,9,9,8,8,13,13,2,2,5,5,3,3,6,6,0,0,0,0,11,11,13,13,10,10,14,14,7,7,15,15,14,14,3,3,10,10,9,9,4,4,2,2,9,9,5,5,5,5,14,14,0,0,12,12,13,13,12,12,1,1,14,14,5,5,5,5,11,11,12,12,10,10,11,11,3,3,14,14,8,8,10,10,14,14,10,10,0,0,4,4,8,8,10,10,7,7,0,0,0,0,14,14,13,13,9,9,7,7,11,11,10,10,10,10,4,4,9,9,10,10,9,9,10,10,15,15,0,0,0,0,1,1,3,3,12,12,1,1,5,5,12,12,12,12,1,1,13,13,7,7,7,7,10,10,13,13,12,12,1,1,0,0,3,3,10,10,9,9,6,6,0,0,0,0,11,11,7,7,9,9,1,1,10,10,10,10,0,0,14,14,4,4,9,9,13,13,1,1,7,7,5,5,6,6,0,0,4,4,6,6,4,4,10,10,15,15,8,8,7,7,15,15,11,11,7,7,6,6,13,13,8,8,8,8,9,9,8,8,15,15,2,2,3,3,1,1,9,9,2,2,7,7,3,3,2,2,9,9,6,6,4,4,8,8,2,2,2,2,8,8,2,2,1,1,3,3,6,6,3,3,6,6,5,5,5,5,2,2,2,2,15,15,1,1,0,0,15,15,1,1,0,0,8,8,13,13,9,9,11,11,15,15,4,4,1,1,12,12,12,12,10,10,9,9,10,10,6,6,9,9,1,1,5,5,12,12,7,7,10,10,0,0,6,6,8,8,13,13,3,3,0,0,12,12,2,2,6,6,12,12,14,14,4,4,4,4,4,4,6,6,8,8,8,8,3,3,5,5,14,14,8,8,7,7,6,6,3,3,11,11,14,14,13,13,1,1,3,3,3,3,9,9,4,4,0,0,13,13,2,2,4,4,13,13,8,8,11,11,11,11,2,2,2,2,14,14,3,3,14,14,1,1,1,1,2,2,8,8,15,15,9,9,1,1,8,8,6,6,4,4,6,6,3,3,15,15,14,14,12,12,8,8,9,9,10,10,2,2,10,10,15,15,8,8,0,0,1,1,3,3,15,15,10,10,7,7,13,13,11,11,8,8,7,7,0,0,3,3,14,14,13,13,3,3,3,3,8,8,13,13,9,9,12,12,12,12,11,11,5,5,9,9,12,12,8,8,10,10,1,1,0,0,12,12,12,12,4,4,4,4,5,5,4,4,2,2,10,10,13,13,1,1,5,5,8,8,10,10,4,4,5,5,9,9,1,1,0,0,2,2,0,0,3,3,13,13,1,1,3,3,0,0,12,12,4,4,10,10,5,5,10,10,15,15,15,15,5,5,6,6,4,4,12,12,1,1,5,5,14,14,2,2,10,10,13,13,10,10,3,3,7,7,0,0,6,6,2,2,12,12,0,0,4,4,4,4,8,8,5,5,13,13,12,12,3,3,9,9,4,4,8,8,11,11,3,3,14,14,8,8,14,14,10,10,14,14,0,0,12,12,14,14,15,15,1,1,15,15,7,7,1,1,8,8,12,12,1,1,1,1,6,6,1,1,5,5,3,3,7,7,13,13,5,5,3,3,9,9,4,4,14,14,3,3,3,3,9,9,1,1,1,1,9,9,9,9,0,0,12,12,4,4,3,3,11,11,1,1,4,4,3,3,3,3,12,12,0,0,11,11,12,12,1,1,11,11,15,15,8,8,1,1,10,10,10,10,0,0,11,11,2,2,0,0,2,2,12,12,6,6,14,14,5,5,11,11,2,2,10,10,8,8,12,12,11,11,9,9,9,9,0,0,8,8,11,11,2,2,4,4,8,8,8,8,15,15,5,5,3,3,1,1,6,6,2,2,1,1,12,12,11,11,5,5,0,0,0,0,3,3,14,14,2,2,1,1,1,1,11,11,5,5,3,3,14,14,6,6,0,0,1,1,10,10,5,5,9,9,14,14,4,4,13,13,15,15,0,0,3,3,1,1,5,5,2,2,0,0,2,2,6,6,7,7,5,5,14,14,9,9,0,0,6,6,10,10,12,12,11,11,11,11,5,5,14,14,12,12,14,14,6,6,8,8,5,5,10,10,14,14,5,5,14,14,3,3,6,6,5,5,4,4,4,4,5,5,8,8,11,11,4,4,7,7,12,12,9,9,9,9,12,12,13,13,11,11,13,13,4,4,10,10,7,7,8,8,13,13,15,15,14,14,8,8,0,0,5,5,6,6,15,15,15,15,11,11,6,6,15,15,10,10,1,1,7,7,6,6,13,13,0,0,4,4,12,12,14,14,13,13,13,13,7,7,4,4,3,3,11,11,12,12,4,4,12,12,4,4,2,2,13,13,13,13,10,10,8,8,6,6,0,0,9,9,14,14,6,6,3,3,15,15,10,10,2,2,2,2,14,14,2,2,9,9,4,4,14,14,11,11,4,4,2,2,2,2,5,5,3,3,3,3,12,12,0,0,9,9,11,11,14,14,6,6,15,15,9,9,2,2,7,7,9,9,8,8,3,3,8,8,12,12,3,3,14,14,6,6,6,6,10,10,6,6,3,3,12,12,6,6,2,2,9,9,1,1,5,5,0,0,8,8,5,5,5,5,9,9,0,0,4,4,8,8,9,9,9,9,7,7,0,0,0,0,0,0,6,6,5,5,13,13,4,4,12,12,10,10,11,11,1,1,7,7,15,15,4,4,12,12,12,12,12,12,0,0,4,4,1,1,7,7,0,0,6,6,12,12,2,2,7,7,2,2,12,12,11,11,12,12,1,1,0,0,12,12,1,1,2,2,6,6,11,11,10,10,7,7,7,7,11,11,0,0,14,14,0,0,10,10,10,10,14,14,12,12,0,0,15,15,11,11,9,9,0,0,13,13,11,11,5,5,6,6,8,8,0,0,8,8,5,5,4,4,11,11,1,1,6,6,15,15,8,8,5,5,10,10,12,12,1,1,3,3,9,9,2,2,7,7,9,9,2,2,0,0,11,11,0,0,1,1,13,13,0,0,2,2,10,10,12,12,0,0,1,1,7,7,8,8,15,15,15,15,3,3,8,8,11,11,6,6,10,10,12,12,10,10,7,7,10,10,4,4,9,9,4,4,12,12,5,5,15,15,8,8,15,15,15,15,13,13,9,9,12,12,8,8,5,5,12,12,4,4,11,11,10,10,15,15,15,15,4,4,0,0,14,14,2,2,5,5,10,10,14,14,1,1,8,8,13,13,0,0,4,4,10,10,3,3,4,4,5,5,15,15,14,14,11,11,8,8,0,0,0,0,8,8,6,6,6,6,12,12,5,5,11,11,0,0,2,2,1,1,8,8,9,9,5,5,13,13,2,2,11,11,4,4,8,8,2,2,1,1,2,2,13,13,6,6,12,12,5,5,0,0,15,15,7,7,1,1,15,15,1,1,9,9,11,11,6,6,0,0,15,15,12,12,7,7,10,10,2,2,14,14,3,3,0,0,1,1,12,12,9,9,10,10,4,4,1,1,9,9,11,11,3,3,0,0,0,0,3,3,8,8,11,11,12,12,2,2,8,8,14,14,0,0,8,8,6,6,6,6,1,1,6,6,10,10,13,13,14,14,3,3,13,13,13,13,12,12,10,10,14,14,6,6,8,8,13,13,11,11,8,8,3,3,1,1,14,14,11,11,15,15,13,13,0,0,1,1,0,0,7,7,9,9,6,6,2,2,1,1,15,15,7,7,10,10,8,8,15,15,12,12,6,6,6,6,4,4,6,6,6,6,7,7,2,2,4,4,13,13,14,14,10,10,11,11,6,6,4,4,10,10,0,0,13,13,9,9,8,8,10,10,4,4,10,10,7,7,10,10,11,11,9,9,6,6,9,9,1,1,3,3,5,5,1,1,4,4,9,9,3,3,5,5,3,3,2,2,10,10,9,9,8,8,9,9,12,12,3,3,9,9,9,9,4,4,4,4,9,9,4,4,4,4,12,12,2,2,15,15,9,9,8,8,11,11,12,12,11,11,7,7,13,13,12,12,8,8,12,12,13,13,10,10,2,2,11,11,9,9,9,9,1,1,9,9,7,7,10,10,8,8,1,1,0,0,14,14,7,7,1,1,6,6,1,1,12,12,11,11,6,6,8,8,4,4,15,15,4,4,8,8,11,11,14,14,8,8,14,14,15,15,7,7,6,6,12,12,14,14,2,2,4,4,8,8,6,6,3,3,0,0,3,3,6,6,2,2,1,1,7,7,11,11,2,2,5,5,12,12,6,6,1,1,2,2,14,14,6,6,6,6,2,2,2,2,5,5,4,4,11,11,9,9,7,7,15,15,2,2,13,13,4,4,13,13,1,1,10,10,3,3,14,14,9,9,10,10,12,12,13,13,2,2,1,1,2,2,14,14,2,2,1,1,8,8,2,2,14,14,2,2,4,4,13,13,5,5,8,8,12,12,13,13,8,8,9,9,3,3,15,15,1,1,8,8,10,10,14,14,5,5,8,8,0,0,2,2,10,10,5,5,2,2,3,3,10,10,9,9,1,1,4,4,5,5,11,11,8,8,6,6,5,5,9,9,1,1,9,9,9,9,11,11,0,0,12,12,13,13,3,3,13,13,11,11,15,15,12,12,13,13,1,1,1,1,0,0,2,2,11,11,5,5,15,15,4,4,11,11,0,0,10,10,0,0,1,1,11,11,1,1,15,15,3,3,10,10,8,8,9,9,4,4,8,8,3,3,14,14,4,4,7,7,12,12,15,15,1,1,12,12,8,8,11,11,6,6,5,5,2,2,7,7,2,2,12,12,12,12,6,6,9,9,2,2,4,4,1,1,4,4,7,7,9,9,11,11,1,1,3,3,15,15,3,3,6,6,4,4,7,7,14,14,5,5,3,3,9,9,7,7,9,9,12,12,1,1,5,5,8,8,13,13,4,4,7,7,3,3,15,15,15,15,15,15,1,1,8,8,0,0,13,13,2,2,0,0,3,3,4,4,4,4,4,4,0,0,0,0,12,12,7,7,2,2,10,10,2,2,2,2,6,6,14,14,5,5,13,13,13,13,8,8,9,9,12,12,6,6,4,4,12,12,9,9,0,0,9,9,5,5,6,6,7,7,9,9,12,12,4,4,11,11,12,12,5,5,6,6,5,5,13,13,11,11,0,0,6,6,0,0,3,3,0,0,1,1,4,4,8,8,2,2,4,4,4,4,9,9,1,1,8,8,3,3,3,3,6,6,11,11,3,3,0,0,4,4,12,12,7,7,2,2,6,6,9,9,11,11,3,3,10,10,5,5,6,6,1,1,2,2,3,3,7,7,8,8,13,13,15,15,6,6,2,2,12,12,0,0,13,13,9,9,14,14,0,0,10,10,8,8,15,15,15,15,11,11,7,7,10,10,7,7,5,5,12,12,12,12,5,5,3,3,9,9,4,4,7,7,5,5,2,2,10,10,6,6,5,5,11,11,1,1,11,11,14,14,6,6,11,11,5,5,15,15,13,13,13,13,0,0,12,12,6,6,2,2,14,14,12,12,13,13,6,6,15,15,15,15,0,0,0,0,15,15,7,7,1,1,15,15,0,0,0,0,0,0,10,10,12,12,8,8,3,3,4,4,15,15,6,6,14,14,8,8,0,0,5,5,1,1,0,0,6,6,13,13,13,13,4,4,9,9,4,4,6,6,8,8,4,4,14,14,7,7,8,8,3,3,5,5,2,2,3,3,11,11,6,6,5,5,4,4,7,7,2,2,4,4,0,0,6,6,8,8,0,0,6,6,8,8,12,12,8,8,9,9,11,11,8,8,8,8,1,1,10,10,1,1,15,15,6,6,1,1,2,2,6,6,11,11,1,1,10,10,0,0,12,12,6,6,10,10,6,6,11,11,0,0,6,6,6,6,6,6,4,4,7,7,3,3,6,6,2,2,5,5,3,3,1,1,1,1,1,1,13,13,6,6,9,9,9,9,2,2,4,4,3,3,4,4,5,5,6,6,5,5,9,9,3,3,15,15,9,9,15,15,8,8,9,9,11,11,1,1,7,7,9,9,14,14,9,9,14,14,11,11,11,11,0,0,4,4,5,5,3,3,13,13,12,12,9,9,7,7,11,11,7,7,14,14,4,4,12,12,3,3,3,3,0,0,15,15,6,6,13,13,4,4,3,3,15,15,5,5,12,12,5,5,6,6,12,12,9,9,6,6,2,2,5,5,3,3,7,7,1,1,1,1,6,6,2,2,13,13,5,5,1,1,14,14,5,5,1,1,0,0,13,13,1,1,5,5,4,4,0,0,4,4,1,1,4,4,2,2,10,10,1,1,13,13,13,13,4,4,1,1,4,4,3,3,12,12,13,13,11,11,6,6,14,14,8,8,6,6,11,11,3,3,11,11,14,14,9,9,0,0,13,13,14,14,2,2,0,0,10,10,8,8,1,1,2,2,13,13,0,0,1,1,11,11,14,14,4,4,9,9,0,0,14,14,10,10,0,0,14,14,7,7,7,7,7,7,3,3,12,12,5,5,5,5,1,1,3,3,11,11,7,7,1,1,12,12,4,4,6,6,13,13,8,8,8,8,7,7,3,3,10,10,6,6,13,13,5,5,8,8,15,15,4,4,4,4,10,10,2,2,10,10,14,14,1,1,15,15,6,6,1,1,12,12,0,0,0,0,8,8,12,12,0,0,9,9,10,10,3,3,12,12,8,8,12,12,6,6,15,15,12,12,6,6,5,5,14,14,11,11,6,6,0,0,1,1,13,13,1,1,10,10,13,13,8,8,3,3,3,3,11,11,14,14,2,2,12,12,3,3,4,4,3,3,7,7,6,6,10,10,0,0,6,6,5,5,0,0,2,2,10,10,9,9,13,13,3,3,8,8,14,14,7,7,3,3,1,1,12,12,8,8,1,1,6,6,4,4,5,5,8,8,4,4,12,12,7,7,6,6,6,6,9,9,2,2,7,7,9,9,8,8,14,14,7,7,6,6,7,7,7,7,7,7,14,14,0,0,11,11,9,9,4,4,6,6,4,4,2,2,12,12,9,9,6,6,8,8,8,8,7,7,8,8,14,14,12,12,15,15,12,12,12,12,3,3,12,12,1,1,2,2,4,4,13,13,15,15,3,3,13,13,15,15,1,1,6,6,10,10,5,5,6,6,10,10,7,7,0,0,12,12,2,2,10,10,0,0,11,11,2,2,9,9,1,1,0,0,0,0,12,12,0,0,8,8,0,0,2,2,11,11,7,7,8,8,10,10,7,7,4,4,7,7,1,1,6,6,9,9,7,7,5,5,13,13,6,6,11,11,0,0,2,2,13,13,9,9,8,8,0,0,1,1,4,4,2,2,12,12,11,11,13,13,1,1,4,4,0,0,2,2,0,0,15,15,5,5,13,13,0,0,2,2,14,14,1,1,8,8,0,0,14,14,12,12,12,12,4,4,15,15,7,7,5,5,15,15,1,1,13,13,11,11,1,1,1,1,12,12,9,9,6,6,11,11,12,12,5,5,0,0,3,3,0,0,1,1,8,8,10,10,11,11,12,12,7,7,14,14,12,12,10,10,8,8,10,10,1,1,11,11,8,8,0,0,9,9,0,0,15,15,11,11,4,4,4,4,7,7,8,8,9,9,1,1,10,10,11,11,3,3,11,11,7,7,10,10,7,7,10,10,9,9,7,7,2,2,6,6,0,0,3,3,0,0,7,7,14,14,2,2,12,12,9,9,0,0,1,1,8,8,1,1,6,6,6,6,0,0,7,7,9,9,12,12,6,6,0,0,4,4,1,1,14,14,9,9,2,2,13,13,1,1,14,14,12,12,9,9,0,0,0,0,3,3,3,3,1,1,4,4,2,2,14,14,15,15,14,14,4,4,2,2,10,10,12,12,14,14,9,9,0,0,0,0,6,6,13,13,10,10,15,15,4,4,10,10,7,7,13,13,10,10,3,3,0,0,2,2,15,15,12,12,5,5,12,12,8,8,0,0,7,7,8,8,7,7,9,9,2,2,9,9,9,9,12,12,6,6,7,7,2,2,9,9,4,4,1,1,7,7,6,6,15,15,14,14,4,4,12,12,0,0,7,7,2,2,0,0,14,14,2,2,3,3,13,13,3,3,15,15,11,11,10,10,15,15,4,4,1,1,15,15,14,14,12,12,13,13,14,14,7,7,9,9,10,10,4,4,3,3,14,14,14,14,5,5,2,2,5,5,12,12,14,14,9,9,15,15,6,6,2,2,10,10,10,10,1,1,9,9,11,11,14,14,1,1,11,11,5,5,6,6,11,11,14,14,13,13,5,5,1,1,2,2,3,3,15,15,1,1,4,4,11,11,14,14,8,8,5,5,3,3,11,11,12,12,13,13,15,15,9,9,9,9,3,3,10,10,14,14,5,5,15,15,10,10,2,2,6,6,11,11,1,1,11,11,1,1,12,12,3,3,15,15,4,4,6,6,6,6,11,11,14,14,9,9,2,2,8,8,8,8,8,8,13,13,10,10,2,2,2,2,0,0,8,8,8,8,15,15,5,5,4,4,2,2,6,6,10,10,2,2,2,2,8,8,0,0,1,1,2,2,8,8,13,13,7,7,8,8,1,1,0,0,13,13,4,4,1,1,12,12,8,8,10,10,9,9,12,12,7,7,14,14,4,4,7,7,6,6,11,11,2,2,12,12,15,15,3,3,4,4,9,9,4,4,12,12,4,4,0,0,1,1,3,3,11,11,2,2,0,0,14,14,0,0,12,12,3,3,3,3,3,3,0,0,13,13,4,4,0,0,5,5,0,0,2,2,9,9,5,5,7,7,8,8,3,3,4,4,15,15,4,4,9,9,9,9,6,6,7,7,6,6,3,3,14,14,0,0,6,6,13,13,4,4,13,13,8,8,0,0,0,0,15,15,15,15,9,9,8,8,9,9,6,6,3,3,10,10,9,9,2,2,12,12,13,13,11,11,4,4,2,2,4,4,1,1,8,8,3,3,2,2,6,6,10,10,1,1,13,13,0,0,8,8,2,2,5,5,1,1,3,3,10,10,7,7,10,10,10,10,15,15,13,13,11,11,4,4,12,12,5,5,2,2,2,2,9,9,9,9,0,0,1,1,15,15,9,9,4,4,11,11,12,12,10,10,11,11,0,0,2,2,2,2,15,15,6,6,4,4,7,7,15,15,8,8,2,2,9,9,0,0,8,8,13,13,1,1,6,6,8,8,11,11,12,12,5,5,2,2,14,14,14,14,0,0,10,10,10,10,5,5,11,11,11,11,0,0,5,5,12,12,6,6,4,4,4,4,6,6,8,8,2,2,15,15,3,3,8,8,11,11,3,3,15,15,14,14,3,3,9,9,12,12,9,9,8,8,14,14,5,5,13,13,13,13,4,4,4,4,6,6,8,8,12,12,1,1,2,2,3,3,5,5,0,0,7,7,4,4,2,2,13,13,5,5,5,5,4,4,5,5,10,10,5,5,7,7,9,9,4,4,3,3,2,2,0,0,15,15,3,3,12,12,0,0,7,7,5,5,0,0,3,3,5,5,11,11,12,12,10,10,10,10,4,4,14,14,3,3,10,10,12,12,4,4,6,6,14,14,0,0,6,6,9,9,1,1,3,3,5,5,11,11,14,14,3,3,5,5,7,7,6,6,12,12,3,3,2,2,4,4,7,7,15,15,6,6,2,2,11,11,5,5,14,14,1,1,12,12,0,0,5,5,12,12,2,2,5,5,2,2,12,12,5,5,14,14,0,0,3,3,0,0,14,14,11,11,15,15,3,3,11,11,5,5,4,4,14,14,14,14,2,2,1,1,0,0,0,0,15,15,2,2,4,4,0,0,10,10,2,2,14,14,8,8,8,8,8,8,14,14,13,13,4,4,3,3,13,13,13,13,9,9,3,3,1,1,8,8,10,10,4,4,9,9,8,8,10,10,0,0,2,2,10,10,13,13,10,10,10,10,14,14,13,13,13,13,8,8,6,6,13,13,0,0,4,4,4,4,2,2,8,8,7,7,6,6,13,13,9,9,11,11,5,5,0,0,9,9,1,1,7,7,9,9,4,4,3,3,8,8,2,2,3,3,5,5,5,5,5,5,13,13,0,0,8,8,14,14,1,1,13,13,7,7,0,0,5,5,11,11,10,10,8,8,0,0,14,14,12,12,14,14,9,9,13,13,12,12,13,13,13,13,9,9,6,6,4,4,1,1,1,1,15,15,7,7,8,8,8,8,12,12,5,5,15,15,7,7,9,9,6,6,11,11,10,10,6,6,9,9,7,7,1,1,9,9,5,5,12,12,2,2,4,4,13,13,1,1,1,1,9,9,7,7,9,9,6,6,5,5,0,0,1,1,1,1,14,14,8,8,4,4,7,7,15,15,3,3,5,5,1,1,2,2,6,6,8,8,7,7,6,6,12,12,11,11,0,0,11,11,7,7,12,12,0,0,15,15,3,3,12,12,1,1,12,12,8,8,12,12,0,0,0,0,1,1,8,8,1,1,3,3,1,1,4,4,13,13,2,2,15,15,7,7,1,1,4,4,14,14,6,6,5,5,3,3,6,6,10,10,13,13,7,7,11,11,1,1,14,14,2,2,0,0,9,9,1,1,10,10,12,12,6,6,8,8,13,13,9,9,1,1,8,8,3,3,10,10,10,10,12,12,2,2,11,11,1,1,5,5,4,4,6,6,2,2,8,8,2,2,14,14,11,11,1,1,12,12,1,1,1,1,6,6,8,8,4,4,10,10,3,3,2,2,15,15,1,1,11,11,8,8,9,9,2,2,6,6,14,14,12,12,1,1,3,3,1,1,2,2,8,8,14,14,4,4,1,1,14,14,7,7,0,0,1,1,13,13,7,7,7,7,1,1,3,3,1,1,3,3,5,5,14,14,5,5,2,2,4,4,10,10,4,4,13,13,11,11,8,8,4,4,3,3,7,7,11,11,15,15,9,9,5,5,14,14,11,11,9,9,14,14,4,4,11,11,0,0,1,1,5,5,3,3,11,11,3,3,15,15,13,13,3,3,4,4,2,2,13,13,1,1,4,4,9,9,5,5,5,5,12,12,7,7,4,4,1,1,10,10,13,13,11,11,8,8,3,3,7,7,0,0,11,11,12,12,6,6,7,7,15,15,4,4,11,11,7,7,5,5,3,3,4,4,15,15,15,15,6,6,6,6,7,7,8,8,1,1,6,6,12,12,12,12,1,1,15,15,10,10,14,14,3,3,8,8,7,7,13,13,15,15,2,2,4,4,8,8,6,6,8,8,6,6,12,12,12,12,15,15,9,9,5,5,7,7,9,9,8,8,14,14,13,13,14,14,13,13,14,14,5,5,6,6,2,2,9,9,7,7,1,1,0,0,13,13,15,15,9,9,1,1,11,11,1,1,4,4,13,13,12,12,14,14,4,4,4,4,4,4,3,3,3,3,7,7,4,4,12,12,13,13,1,1,15,15,6,6,4,4,7,7,15,15,11,11,2,2,11,11,11,11,6,6,8,8,3,3,15,15,4,4,3,3,11,11,8,8,0,0,4,4,0,0,8,8,4,4,13,13,10,10,7,7,9,9,9,9,2,2,1,1,4,4,5,5,8,8,13,13,9,9,13,13,3,3,5,5,10,10,12,12,8,8,2,2,14,14,3,3,6,6,9,9,8,8,1,1,14,14,5,5,5,5,0,0,12,12,13,13,13,13,2,2,10,10,6,6,4,4,6,6,3,3,0,0,12,12,13,13,10,10,9,9,0,0,10,10,15,15,13,13,4,4,5,5,14,14,5,5,13,13,5,5,4,4,1,1,9,9,5,5,8,8,10,10,14,14,0,0,12,12,6,6,9,9,15,15,12,12,2,2,13,13,8,8,12,12,3,3,6,6,12,12,9,9,0,0,7,7,12,12,11,11,2,2,2,2,2,2,1,1,6,6,1,1,7,7,8,8,9,9,4,4,1,1,13,13,13,13,11,11,4,4,8,8,1,1,11,11,13,13,14,14,1,1,9,9,0,0,1,1,8,8,2,2,14,14,14,14,15,15,6,6,3,3,15,15,3,3,11,11,8,8,12,12,0,0,15,15,9,9,11,11,0,0,6,6,7,7,5,5,12,12,8,8,2,2,0,0,3,3,13,13,1,1,7,7,13,13,1,1,10,10,8,8,6,6,1,1,14,14,4,4,0,0,11,11,5,5,9,9,7,7,6,6,0,0,1,1,12,12,12,12,8,8,10,10,0,0,4,4,9,9,3,3,8,8,1,1,9,9,5,5,12,12,3,3,7,7,4,4,4,4,9,9,15,15,10,10,7,7,9,9,13,13,9,9,3,3,0,0,9,9,14,14,1,1,15,15,0,0,2,2,4,4,7,7,7,7,13,13,5,5,11,11,3,3,15,15,8,8,5,5,2,2,9,9,12,12,5,5,4,4,11,11,7,7,4,4,5,5,15,15,5,5,2,2,11,11,3,3,12,12,13,13,13,13,8,8,0,0,11,11,4,4,13,13,13,13,11,11,5,5,6,6,0,0,7,7,0,0,10,10,4,4,10,10,10,10,3,3,9,9,8,8,11,11,2,2,12,12,6,6,10,10,5,5,5,5,10,10,12,12,12,12,6,6,0,0,8,8,4,4,6,6,7,7,4,4,0,0,14,14,6,6,14,14,6,6,12,12,4,4,0,0,13,13,2,2,0,0,15,15,0,0,14,14,8,8,1,1,2,2,0,0,9,9,15,15,6,6,6,6,15,15,7,7,8,8,8,8,12,12,13,13,7,7,2,2,8,8,5,5,1,1,5,5,0,0,15,15,5,5,1,1,6,6,9,9,13,13,6,6,8,8,8,8,6,6,0,0,1,1,8,8,10,10,15,15,1,1,0,0,1,1,12,12,7,7,12,12,4,4,11,11,8,8,3,3,15,15,12,12,13,13,15,15,13,13,10,10,12,12,2,2,4,4,6,6,12,12,8,8,9,9,8,8,2,2,15,15,5,5,7,7,5,5,9,9,6,6,13,13,3,3,7,7,6,6,10,10,5,5,13,13,12,12,0,0,12,12,7,7,1,1,12,12,14,14,7,7,14,14,13,13,1,1,14,14,15,15,9,9,6,6,14,14,10,10,9,9,0,0,5,5,0,0,0,0,14,14,1,1,12,12,1,1,0,0,0,0,0,0,10,10,11,11,3,3,14,14,12,12,9,9,13,13,3,3,8,8,4,4,12,12,0,0,6,6,2,2,10,10,1,1,7,7,1,1,3,3,10,10,13,13,0,0,12,12,6,6,5,5,2,2,11,11,2,2,7,7,7,7,3,3,12,12,0,0,5,5,13,13,10,10,10,10,14,14,12,12,4,4,1,1,10,10,15,15,13,13,1,1,3,3,13,13,9,9,9,9,14,14,14,14,8,8,9,9,14,14,11,11,4,4,0,0,15,15,5,5,12,12,6,6,10,10,10,10,8,8,11,11,3,3,1,1,0,0,4,4,12,12,12,12,11,11,4,4,8,8,1,1,15,15,8,8,10,10,13,13,15,15,2,2,15,15,3,3,13,13,7,7,10,10,10,10,2,2,14,14,6,6,11,11,15,15,8,8,12,12,8,8,6,6,12,12,0,0,2,2,0,0,13,13,9,9,8,8,14,14,5,5,5,5,4,4,0,0,3,3,0,0,8,8,6,6,15,15,13,13,10,10,0,0,3,3,9,9,5,5,3,3,3,3,14,14,11,11,13,13,5,5,13,13,8,8,6,6,8,8,11,11,11,11,0,0,14,14,1,1,10,10,10,10,0,0,6,6,15,15,4,4,9,9,14,14,8,8,15,15,8,8,5,5,15,15,1,1,6,6,2,2,2,2,8,8,5,5,8,8,5,5,9,9,4,4,13,13,8,8,6,6,13,13,13,13,6,6,4,4,5,5,2,2,10,10,7,7,1,1,4,4,15,15,1,1,15,15,1,1,11,11,11,11,2,2,10,10,3,3,5,5,12,12,1,1,13,13,2,2,0,0,7,7,9,9,1,1,7,7,9,9,8,8,3,3,5,5,10,10,5,5,2,2,6,6,9,9,10,10,8,8,6,6,14,14,15,15,15,15,0,0,9,9,7,7,5,5,7,7,7,7,13,13,5,5,10,10,2,2,7,7,6,6,11,11,8,8,2,2,2,2,10,10,0,0,11,11,1,1,12,12,7,7,1,1,13,13,2,2,14,14,13,13,8,8,11,11,8,8,13,13,1,1,7,7,4,4,14,14,0,0,10,10,14,14,9,9,11,11,3,3,6,6,4,4,5,5,0,0,5,5,3,3,0,0,2,2,9,9,0,0,12,12,3,3,11,11,13,13,8,8,6,6,8,8,14,14,3,3,9,9,5,5,0,0,10,10,1,1,10,10,5,5,11,11,5,5,5,5,9,9,14,14,11,11,12,12,7,7,12,12,7,7,8,8,6,6,0,0,3,3,9,9,15,15,12,12,14,14,6,6,12,12,2,2,13,13,4,4,1,1,5,5,3,3,4,4,0,0,8,8,10,10,2,2,10,10,15,15,14,14,13,13,8,8,10,10,9,9,14,14,1,1,5,5,4,4,10,10,2,2,1,1,11,11,1,1,6,6,6,6,0,0,3,3,0,0,4,4,15,15,10,10,11,11,0,0,4,4,0,0,12,12,7,7,6,6,3,3,4,4,11,11,1,1,5,5,8,8,11,11,12,12,6,6,0,0,0,0,9,9,2,2,0,0,14,14,9,9,2,2,5,5,8,8,5,5,1,1,13,13,11,11,13,13,9,9,2,2,5,5,6,6,5,5,0,0,4,4,3,3,9,9,4,4,13,13,12,12,15,15,7,7,6,6,6,6,12,12,14,14,12,12,1,1,4,4,2,2,5,5,5,5,10,10,9,9,2,2,11,11,7,7,4,4,15,15,10,10,8,8,10,10,9,9,6,6,7,7,1,1,2,2,10,10,7,7,12,12,14,14,12,12,15,15,1,1,14,14,8,8,0,0,3,3,11,11,4,4,3,3,13,13,13,13,15,15,8,8,12,12,6,6,1,1,6,6,10,10,5,5,12,12,3,3,7,7,4,4,3,3,8,8,4,4,4,4,12,12,7,7,1,1,3,3,13,13,3,3,7,7,5,5,3,3,12,12,10,10,13,13,12,12,15,15,4,4,7,7,8,8,2,2,4,4,11,11,15,15,8,8,14,14,1,1,8,8,0,0,2,2,1,1,8,8,10,10,10,10,4,4,1,1,9,9,6,6,7,7,12,12,0,0,12,12,12,12,2,2,12,12,6,6,13,13,13,13,11,11,0,0,3,3,14,14,15,15,13,13,1,1,12,12,9,9,14,14,9,9,7,7,4,4,12,12,2,2,12,12,8,8,5,5,5,5,0,0,8,8,13,13,7,7,5,5,9,9,11,11,1,1,3,3,11,11,12,12,13,13,2,2,3,3,3,3,13,13,2,2,13,13,7,7,4,4,5,5,4,4,1,1,9,9,11,11,8,8,5,5,3,3,3,3,8,8,15,15,12,12,3,3,1,1,11,11,5,5,2,2,5,5,11,11,5,5,12,12,11,11,11,11,10,10,0,0,8,8,14,14,8,8,1,1,8,8,15,15,12,12,9,9,2,2,1,1,0,0,11,11,14,14,11,11,0,0,9,9,2,2,11,11,14,14,4,4,6,6,13,13,2,2,15,15,4,4,4,4,3,3,2,2,5,5,8,8,1,1,13,13,0,0,7,7,1,1,12,12,13,13,4,4,2,2,15,15,14,14,5,5,9,9,5,5,14,14,1,1,9,9,13,13,1,1,0,0,4,4,5,5,10,10,13,13,5,5,14,14,3,3,7,7,10,10,9,9,13,13,3,3,5,5,1,1,13,13,0,0,10,10,4,4,7,7,12,12,14,14,9,9,6,6,11,11,5,5,2,2,12,12,15,15,9,9,8,8,13,13,1,1,7,7,11,11,11,11,9,9,0,0,12,12,4,4,10,10,8,8,14,14,1,1,11,11,7,7,4,4,4,4,5,5,11,11,13,13,13,13,10,10,2,2,3,3,4,4,1,1,11,11,0,0,14,14,2,2,6,6,2,2,14,14,6,6,6,6,12,12,0,0,4,4,15,15,5,5,13,13,12,12,3,3,4,4,2,2,7,7,11,11,0,0,0,0,6,6,4,4,10,10,14,14,0,0,10,10,3,3,5,5,0,0,10,10,15,15,9,9,8,8,15,15,8,8,11,11,9,9,12,12,10,10,0,0,13,13,1,1,14,14,5,5,5,5,1,1,15,15,11,11,1,1,14,14,9,9,0,0,1,1,10,10,3,3,4,4,12,12,9,9,7,7,1,1,15,15,7,7,10,10,15,15,0,0,0,0,13,13,11,11,10,10,15,15,4,4,3,3,9,9,3,3,6,6,7,7,4,4,2,2,0,0,0,0,12,12,14,14,5,5,0,0,14,14,12,12,6,6,0,0,10,10,11,11,7,7,13,13,0,0,7,7,3,3,8,8,5,5,4,4,9,9,1,1,14,14,0,0,1,1,11,11,1,1,6,6,6,6,0,0,9,9,7,7,11,11,3,3,14,14,10,10,12,12,5,5,8,8,14,14,5,5,6,6,2,2,3,3,0,0,10,10,5,5,13,13,12,12,0,0,13,13,0,0,7,7,1,1,5,5,2,2,10,10,5,5,6,6,13,13,8,8,0,0,2,2,2,2,8,8,1,1,3,3,6,6,0,0,15,15,10,10,2,2,15,15,13,13,8,8,7,7,0,0,15,15,4,4,15,15,6,6,4,4,1,1,6,6,0,0,9,9,12,12,0,0,0,0,5,5,14,14,2,2,15,15,15,15,11,11,8,8,15,15,4,4,7,7,0,0,10,10,3,3,1,1,8,8,7,7,10,10,9,9,13,13,7,7,11,11,9,9,6,6,1,1,2,2,14,14,3,3,14,14,15,15,11,11,8,8,5,5,1,1,13,13,3,3,4,4,0,0,10,10,10,10,1,1,15,15,13,13,8,8,13,13,9,9,0,0,9,9,1,1,8,8,4,4,2,2,8,8,2,2,12,12,14,14,3,3,9,9,1,1,7,7,8,8,1,1,5,5,7,7,3,3,8,8,11,11,5,5,8,8,10,10,0,0,4,4,8,8,13,13,10,10,11,11,8,8,6,6,8,8,4,4,10,10,3,3,15,15,4,4,7,7,15,15,5,5,7,7,1,1,1,1,11,11,9,9,0,0,4,4,13,13,5,5,15,15,6,6,7,7,3,3,1,1,14,14,6,6,2,2,3,3,14,14,4,4,3,3,0,0,9,9,15,15,9,9,11,11,13,13,14,14,11,11,5,5,13,13,8,8,2,2,2,2,2,2,1,1,6,6,0,0,12,12,0,0,3,3,4,4,11,11,1,1,10,10,11,11,5,5,2,2,11,11,5,5,13,13,1,1,2,2,0,0,3,3,11,11,13,13,11,11,15,15,5,5,0,0,12,12,11,11,0,0,1,1,7,7,10,10,6,6,9,9,12,12,13,13,13,13,11,11,5,5,8,8,4,4,10,10,0,0,7,7,3,3,13,13,2,2,8,8,2,2,9,9,1,1,13,13,3,3,4,4,14,14,6,6,13,13,13,13,6,6,10,10,1,1,1,1,11,11,6,6,0,0,0,0,9,9,4,4,12,12,14,14,11,11,5,5,13,13,10,10,15,15,11,11,14,14,10,10,11,11,13,13,8,8,6,6,14,14,6,6,10,10,8,8,1,1,6,6,10,10,10,10,11,11,10,10,9,9,4,4,2,2,10,10,10,10,2,2,13,13,3,3,8,8,5,5,8,8,15,15,10,10,15,15,4,4,11,11,3,3,4,4,7,7,10,10,2,2,5,5,12,12,15,15,5,5,5,5,5,5,15,15,2,2,5,5,11,11,11,11,1,1,4,4,15,15,14,14,6,6,4,4,8,8,2,2,1,1,13,13,0,0,14,14,4,4,7,7,9,9,9,9,10,10,15,15,8,8,10,10,13,13,0,0,4,4,7,7,11,11,3,3,10,10,4,4,10,10,7,7,5,5,7,7,13,13,2,2,9,9,6,6,1,1,8,8,0,0,7,7,1,1,4,4,3,3,15,15,14,14,6,6,3,3,15,15,13,13,1,1,0,0,3,3,4,4,12,12,2,2,1,1,2,2,11,11,5,5,11,11,10,10,5,5,8,8,1,1,13,13,6,6,9,9,7,7,2,2,3,3,8,8,12,12,9,9,0,0,10,10,3,3,14,14,12,12,3,3,0,0,1,1,9,9,3,3,14,14,0,0,12,12,7,7,6,6,5,5,0,0,13,13,2,2,1,1,6,6,10,10,1,1,3,3,5,5,7,7,12,12,9,9,2,2,9,9,10,10,0,0,12,12,1,1,6,6,5,5,7,7,7,7,13,13,8,8,3,3,6,6,14,14,11,11,14,14,10,10,2,2,6,6,6,6,12,12,1,1,6,6,14,14,0,0,1,1,1,1,2,2,2,2,9,9,13,13,14,14,5,5,2,2,6,6,1,1,13,13,2,2,4,4,15,15,9,9,0,0,12,12,7,7,7,7,4,4,5,5,15,15,8,8,8,8,4,4,7,7,10,10,13,13,5,5,11,11,10,10,11,11,0,0,1,1,11,11,12,12,1,1,5,5,6,6,6,6,12,12,15,15,9,9,1,1,0,0,0,0,8,8,4,4,8,8,6,6,8,8,6,6,0,0,4,4,14,14,13,13,1,1,10,10,0,0,13,13,1,1,8,8,2,2,1,1,11,11,5,5,9,9,15,15,13,13,9,9,11,11,5,5,1,1,6,6,3,3,2,2,6,6,10,10,13,13,0,0,0,0,2,2,8,8,3,3,7,7,3,3,3,3,0,0,12,12,7,7,8,8,5,5,11,11,5,5,6,6,2,2,3,3,15,15,7,7,4,4,1,1,11,11,14,14,12,12,5,5,5,5,12,12,10,10,9,9,0,0,10,10,2,2,5,5,0,0,12,12,9,9,13,13,2,2,6,6,8,8,14,14,11,11,6,6,13,13,11,11,2,2,13,13,5,5,11,11,13,13,15,15,7,7,2,2,4,4,6,6,7,7,3,3,2,2,5,5,12,12,0,0,10,10,1,1,1,1,13,13,11,11,5,5,1,1,15,15,0,0,6,6,2,2,9,9,9,9,5,5,10,10,9,9,2,2,1,1,5,5,12,12,11,11,11,11,6,6,0,0,5,5,10,10,4,4,8,8,2,2,9,9,3,3,10,10,10,10,5,5,1,1,14,14,1,1,7,7,6,6,11,11,0,0,2,2,14,14,10,10,14,14,2,2,6,6,6,6,10,10,12,12,1,1,15,15,6,6,13,13,9,9,3,3,4,4,4,4,0,0,11,11,12,12,15,15,5,5,12,12,10,10,2,2,14,14,12,12,11,11,12,12,7,7,7,7,3,3,5,5,0,0,0,0,12,12,14,14,3,3,11,11,9,9,9,9,3,3,1,1,7,7,9,9,9,9,5,5,13,13,6,6,14,14,6,6,13,13,1,1,0,0,15,15,11,11,2,2,6,6,10,10,10,10,1,1,5,5,9,9,1,1,6,6,4,4,7,7,14,14,7,7,0,0,4,4,12,12,9,9,1,1,6,6,12,12,4,4,8,8,0,0,15,15,1,1,9,9,3,3,13,13,2,2,9,9,13,13,15,15,4,4,12,12,7,7,3,3,2,2,0,0,1,1,15,15,7,7,12,12,11,11,13,13,4,4,1,1,10,10,2,2,0,0,2,2,11,11,7,7,15,15,5,5,13,13,6,6,14,14,10,10,10,10,6,6,12,12,10,10,2,2,2,2,11,11,0,0,1,1,10,10,9,9,13,13,6,6,8,8,8,8,9,9,1,1,3,3,0,0,3,3,1,1,8,8,6,6,3,3,7,7,5,5,4,4,1,1,5,5,12,12,0,0,15,15,9,9,4,4,3,3,3,3,2,2,0,0,3,3,13,13,8,8,7,7,2,2,14,14,4,4,12,12,1,1,8,8,7,7,10,10,1,1,0,0,0,0,13,13,7,7,13,13,9,9,6,6,12,12,4,4,12,12,7,7,7,7,15,15,10,10,0,0,4,4,4,4,2,2,5,5,8,8,0,0,11,11,2,2,0,0,8,8,7,7,9,9,7,7,5,5,13,13,4,4,0,0,8,8,10,10,11,11,0,0,9,9,4,4,2,2,10,10,14,14,11,11,3,3,0,0,6,6,2,2,7,7,10,10,7,7,14,14,10,10,6,6,2,2,4,4,7,7,10,10,0,0,6,6,0,0,0,0,6,6,13,13,2,2,5,5,3,3,14,14,11,11,0,0,6,6,4,4,13,13,14,14,1,1,12,12,12,12,3,3,2,2,8,8,5,5,6,6,0,0,3,3,5,5,3,3,14,14,5,5,12,12,9,9,12,12,9,9,1,1,14,14,8,8,6,6,7,7,11,11,8,8,9,9,12,12,9,9,2,2,9,9,15,15,2,2,11,11,11,11,9,9,8,8,2,2,11,11,6,6,0,0,13,13,5,5,0,0,13,13,4,4,6,6,5,5,9,9,9,9,15,15,15,15,9,9,5,5,7,7,6,6,13,13,5,5,2,2,15,15,3,3,5,5,9,9,11,11,8,8,12,12,12,12,12,12,7,7,0,0,10,10,1,1,14,14,0,0,10,10,6,6,7,7,0,0,12,12,8,8,8,8,3,3,7,7,13,13,7,7,14,14,13,13,9,9,8,8,3,3,3,3,2,2,7,7,10,10,10,10,4,4,2,2,5,5,11,11,0,0,8,8,11,11,4,4,10,10,11,11,1,1,14,14,10,10,2,2,10,10,4,4,15,15,9,9,10,10,1,1,1,1,1,1,12,12,0,0,8,8,2,2,9,9,4,4,9,9,3,3,10,10,5,5,9,9,12,12,14,14,2,2,10,10,8,8,15,15,11,11,2,2,6,6,6,6,9,9,9,9,12,12,12,12,13,13,3,3,0,0,9,9,5,5,9,9,4,4,15,15,15,15,2,2,4,4,15,15,11,11,10,10,4,4,1,1,2,2,1,1,14,14,12,12,13,13,13,13,1,1,13,13,14,14,3,3,3,3,2,2,10,10,13,13,15,15,8,8,14,14,9,9,1,1,7,7,3,3,5,5,10,10,4,4,13,13,14,14,10,10,8,8,7,7,9,9,12,12,3,3,2,2,0,0,3,3,0,0,14,14,8,8,2,2,5,5,9,9,6,6,10,10,15,15,8,8,4,4,12,12,11,11,5,5,3,3,0,0,13,13,5,5,1,1,1,1,8,8,13,13,9,9,3,3,8,8,10,10,3,3,8,8,9,9,0,0,11,11,8,8,2,2,14,14,3,3,2,2,7,7,4,4,15,15,11,11,1,1,0,0,5,5,3,3,6,6,1,1,5,5,2,2,9,9,9,9,3,3,12,12,5,5,5,5,3,3,10,10,7,7,8,8,5,5,13,13,6,6,5,5,6,6,4,4,12,12,3,3,3,3,3,3,10,10,11,11,8,8,11,11,15,15,0,0,1,1,11,11,15,15,5,5,10,10,11,11,12,12,9,9,6,6,0,0,13,13,9,9,5,5,3,3,2,2,13,13,13,13,10,10,15,15,3,3,0,0,11,11,4,4,3,3,11,11,8,8,11,11,6,6,4,4,13,13,4,4,9,9,9,9,10,10,4,4,0,0,15,15,4,4,12,12,14,14,15,15,9,9,12,12,14,14,12,12,7,7,14,14,10,10,9,9,4,4,5,5,1,1,12,12,10,10,1,1,14,14,5,5,0,0,7,7,13,13,3,3,13,13,10,10,7,7,13,13,10,10,11,11,14,14,1,1,7,7,7,7,1,1,8,8,12,12,12,12,6,6,13,13,2,2,9,9,12,12,8,8,0,0,8,8,6,6,14,14,6,6,3,3,11,11,8,8,3,3,13,13,3,3,11,11,6,6,15,15,13,13,12,12,6,6,5,5,9,9,12,12,0,0,14,14,2,2,11,11,14,14,14,14,0,0,11,11,13,13,6,6,4,4,14,14,15,15,4,4,9,9,14,14,2,2,1,1,9,9,13,13,14,14,8,8,2,2,5,5,12,12,11,11,0,0,9,9,6,6,10,10,0,0,5,5,3,3,10,10,10,10,10,10,3,3,5,5,13,13,14,14,5,5,5,5,9,9,6,6,12,12,12,12,13,13,1,1,7,7,3,3,2,2,7,7,1,1,0,0,10,10,3,3,4,4,11,11,4,4,0,0,0,0,4,4,6,6,13,13,4,4,11,11,5,5,0,0,5,5,4,4,0,0,13,13,9,9,10,10,2,2,12,12,13,13,7,7,5,5,4,4,7,7,5,5,6,6,13,13,10,10,8,8,6,6,6,6,11,11,10,10,12,12,14,14,3,3,11,11,1,1,0,0,4,4,13,13,3,3,0,0,6,6,1,1,12,12,11,11,2,2,1,1,15,15,10,10,4,4,8,8,4,4,12,12,4,4,8,8,14,14,15,15,1,1,5,5,13,13,13,13,8,8,2,2,10,10,4,4,12,12,15,15,12,12,0,0,2,2,3,3,12,12,4,4,2,2,10,10,10,10,2,2,3,3,12,12,3,3,0,0,0,0,3,3,8,8,3,3,14,14,7,7,15,15,12,12,5,5,0,0,11,11,9,9,13,13,6,6,11,11,3,3,10,10,6,6,11,11,2,2,5,5,12,12,3,3,11,11,6,6,5,5,4,4,1,1,0,0,3,3,3,3,1,1,1,1,2,2,4,4,5,5,8,8,11,11,10,10,1,1,2,2,15,15,9,9,13,13,11,11,1,1,4,4,0,0,15,15,4,4,4,4,8,8,11,11,15,15,1,1,3,3,15,15,12,12,8,8,6,6,13,13,4,4,14,14,4,4,7,7,14,14,12,12,7,7,2,2,6,6,15,15,12,12,5,5,13,13,9,9,13,13,8,8,12,12,14,14,7,7,7,7,12,12,4,4,15,15,8,8,4,4,8,8,5,5,1,1,8,8,0,0,4,4,1,1,1,1,13,13,6,6,10,10,13,13,8,8,6,6,11,11,15,15,4,4,0,0,12,12,12,12,8,8,9,9,13,13,0,0,7,7,2,2,3,3,9,9,9,9,11,11,1,1,10,10,6,6,14,14,10,10,7,7,14,14,2,2,3,3,5,5,1,1,6,6,11,11,5,5,13,13,3,3,1,1,9,9,12,12,10,10,2,2,11,11,1,1,15,15,10,10,4,4,9,9,11,11,15,15,7,7,3,3,5,5,8,8,5,5,3,3,3,3,13,13,0,0,1,1,3,3,8,8,13,13,14,14,15,15,9,9,9,9,14,14,1,1,3,3,2,2,4,4,12,12,6,6,3,3,2,2,6,6,13,13,8,8,12,12,8,8,10,10,15,15,3,3,4,4,2,2,11,11,14,14,12,12,7,7,6,6,6,6,10,10,1,1,3,3,12,12,11,11,9,9,12,12,5,5,12,12,7,7,10,10,9,9,12,12,0,0,7,7,8,8,2,2,14,14,15,15,0,0,0,0,5,5,15,15,12,12,1,1,12,12,3,3,2,2,8,8,11,11,2,2,12,12,2,2,13,13,3,3,5,5,6,6,12,12,14,14,13,13,15,15,3,3,9,9,4,4,8,8,6,6,11,11,2,2,9,9,12,12,13,13,4,4,6,6,15,15,8,8,1,1,0,0,7,7,2,2,13,13,3,3,14,14,1,1,9,9,2,2,11,11,14,14,2,2,5,5,13,13,0,0,12,12,10,10,15,15,0,0,11,11,2,2,12,12,15,15,5,5,8,8,3,3,4,4,9,9,10,10,6,6,11,11,2,2,8,8,4,4,15,15,4,4,8,8,14,14,12,12,7,7,8,8,0,0,6,6,13,13,14,14,10,10,12,12,7,7,14,14,7,7,8,8,4,4,11,11,14,14,1,1,4,4,1,1,8,8,8,8,7,7,4,4,4,4,0,0,12,12,13,13,12,12,2,2,3,3,15,15,8,8,0,0,1,1,12,12,10,10,6,6,3,3,9,9,1,1,11,11,0,0,2,2,5,5,6,6,15,15,9,9,6,6,7,7,12,12,13,13,0,0,10,10,7,7,13,13,12,12,2,2,0,0,9,9,9,9,15,15,9,9,9,9,2,2,11,11,6,6,5,5,2,2,13,13,1,1,0,0,12,12,9,9,13,13,15,15,15,15,9,9,8,8,7,7,9,9,5,5,5,5,2,2,9,9,7,7,10,10,8,8,4,4,12,12,3,3,15,15,3,3,5,5,8,8,0,0,7,7,12,12,4,4,2,2,12,12,14,14,6,6,10,10,9,9,10,10,3,3,1,1,4,4,1,1,0,0,10,10,10,10,4,4,3,3,3,3,12,12,4,4,9,9,13,13,14,14,9,9,2,2,1,1,14,14,12,12,1,1,1,1,11,11,1,1,6,6,0,0,4,4,15,15,11,11,9,9,6,6,4,4,5,5,2,2,4,4,0,0,1,1,3,3,15,15,13,13,3,3,3,3,6,6,14,14,1,1,5,5,12,12,1,1,14,14,13,13,13,13,10,10,6,6,5,5,13,13,3,3,3,3,8,8,3,3,8,8,0,0,2,2,14,14,14,14,4,4,13,13,7,7,4,4,7,7,13,13,6,6,0,0,0,0,4,4,0,0,2,2,3,3,2,2,14,14,5,5,0,0,12,12,4,4,3,3,0,0,1,1,1,1,3,3,15,15,10,10,0,0,8,8,14,14,1,1,6,6,4,4,6,6,15,15,0,0,3,3,7,7,14,14,15,15,15,15,9,9,9,9,12,12,9,9,14,14,8,8,7,7,3,3,12,12,12,12,0,0,11,11,4,4,5,5,7,7,7,7,4,4,4,4,7,7,2,2,6,6,4,4,1,1,13,13,11,11,12,12,14,14,2,2,9,9,4,4,0,0,15,15,10,10,2,2,0,0,5,5,13,13,10,10,9,9,2,2,1,1,0,0,10,10,0,0,3,3,0,0,9,9,11,11,1,1,7,7,6,6,6,6,4,4,4,4,13,13,6,6,7,7,6,6,0,0,12,12,9,9,13,13,6,6,5,5,0,0,13,13,6,6,5,5,7,7,0,0,5,5,3,3,15,15,8,8,9,9,7,7,7,7,6,6,1,1,9,9,12,12,15,15,0,0,3,3,13,13,14,14,11,11,7,7,8,8,13,13,1,1,8,8,5,5,1,1,9,9,1,1,7,7,4,4,1,1,12,12,0,0,11,11,11,11,7,7,5,5,0,0,14,14,15,15,6,6,8,8,4,4,1,1,3,3,2,2,12,12,9,9,2,2,2,2,8,8,3,3,7,7,11,11,11,11,11,11,7,7,14,14,5,5,12,12,12,12,15,15,0,0,8,8,6,6,4,4,8,8,12,12,15,15,5,5,3,3,6,6,12,12,8,8,8,8,3,3,0,0,8,8,10,10,6,6,2,2,15,15,1,1,7,7,11,11,0,0,13,13,0,0,9,9,11,11,15,15,8,8,15,15,15,15,7,7,1,1,0,0,12,12,9,9,6,6,5,5,9,9,13,13,13,13,12,12,4,4,4,4,9,9,3,3,15,15,5,5,2,2,6,6,2,2,6,6,7,7,13,13,11,11,7,7,0,0,1,1,7,7,4,4,4,4,11,11,10,10,10,10,12,12,12,12,9,9,10,10,6,6,2,2,11,11,6,6,0,0,12,12,6,6,14,14,8,8,13,13,9,9,4,4,2,2,15,15,4,4,14,14,4,4,0,0,15,15,7,7,12,12,12,12,1,1,9,9,11,11,13,13,1,1,6,6,0,0,4,4,15,15,13,13,4,4,8,8,7,7,15,15,8,8,9,9,6,6,0,0,2,2,6,6,5,5,13,13,13,13,15,15,6,6,8,8,5,5,14,14,1,1,7,7,15,15,5,5,6,6,10,10,15,15,2,2,0,0,5,5,12,12,12,12,4,4,2,2,9,9,12,12,0,0,12,12,5,5,8,8,10,10,2,2,7,7,12,12,6,6,0,0,1,1,3,3,1,1,9,9,3,3,6,6,1,1,0,0,1,1,6,6,0,0,12,12,9,9,4,4,14,14,6,6,4,4,5,5,14,14,0,0,15,15,9,9,12,12,12,12,3,3,0,0,2,2,14,14,6,6,9,9,5,5,13,13,10,10,0,0,10,10,10,10,14,14,15,15,7,7,2,2,3,3,5,5,4,4,15,15,0,0,12,12,3,3,10,10,14,14,13,13,10,10,5,5,0,0,9,9,12,12,10,10,6,6,2,2,10,10,1,1,1,1,4,4,5,5,1,1,0,0,11,11,7,7,1,1,14,14,2,2,14,14,4,4,14,14,3,3,15,15,8,8,13,13,9,9,15,15,3,3,8,8,13,13,1,1,5,5,2,2,3,3,5,5,12,12,2,2,4,4,14,14,11,11,15,15,14,14,9,9,13,13,14,14,12,12,14,14,0,0,7,7,13,13,6,6,7,7,1,1,2,2,14,14,10,10,2,2,5,5,5,5,0,0,14,14,14,14,3,3,13,13,7,7,9,9,0,0,12,12,11,11,1,1,10,10,15,15,14,14,10,10,3,3,9,9,1,1,0,0,12,12,9,9,14,14,1,1,10,10,14,14,7,7,10,10,8,8,2,2,10,10,4,4,11,11,13,13,1,1,4,4,13,13,12,12,8,8,8,8,2,2,3,3,12,12,9,9,8,8,14,14,10,10,9,9,10,10,2,2,4,4,11,11,15,15,6,6,0,0,9,9,10,10,4,4,10,10,2,2,10,10,6,6,10,10,10,10,12,12,2,2,15,15,4,4,1,1,12,12,8,8,4,4,1,1,2,2,15,15,3,3,10,10,2,2,15,15,12,12,14,14,14,14,13,13,10,10,4,4,14,14,14,14,14,14,7,7,4,4,4,4,11,11,7,7,2,2,10,10,11,11,8,8,5,5,8,8,1,1,8,8,7,7,15,15,10,10,3,3,2,2,9,9,15,15,10,10,1,1,10,10,2,2,10,10,1,1,6,6,7,7,4,4,2,2,1,1,5,5,11,11,14,14,1,1,3,3,5,5,13,13,9,9,7,7,2,2,1,1,9,9,4,4,3,3,3,3,1,1,6,6,1,1,12,12,3,3,3,3,9,9,7,7,0,0,8,8,0,0,2,2,15,15,3,3,14,14,0,0,0,0,3,3,3,3,14,14,13,13,6,6,2,2,4,4,0,0,7,7,6,6,10,10,13,13,15,15,14,14,3,3,8,8,9,9,5,5,0,0,4,4,5,5,11,11,8,8,6,6,7,7,5,5,9,9,12,12,8,8,9,9,5,5,1,1,5,5,1,1,11,11,10,10,12,12,4,4,15,15,7,7,11,11,3,3,13,13,2,2,13,13,0,0,13,13,7,7,8,8,1,1,6,6,0,0,12,12,6,6,7,7,0,0,8,8,14,14,12,12,8,8,0,0,4,4,12,12,0,0,13,13,0,0,2,2,15,15,6,6,5,5,1,1,6,6,0,0,12,12,13,13,13,13,15,15,11,11,4,4,10,10,5,5,0,0,1,1,4,4,11,11,7,7,6,6,11,11,10,10,5,5,14,14,4,4,1,1,2,2,5,5,2,2,13,13,13,13,12,12,10,10,4,4,8,8,15,15,2,2,5,5,3,3,15,15,6,6,1,1,12,12,6,6,1,1,5,5,13,13,7,7,12,12,8,8,10,10,10,10,9,9,6,6,3,3,0,0,6,6,5,5,13,13,3,3,15,15,10,10,9,9,9,9,7,7,14,14,3,3,6,6,13,13,1,1,9,9,4,4,8,8,4,4,11,11,13,13,0,0,14,14,5,5,5,5,7,7,1,1,2,2,13,13,10,10,9,9,10,10,3,3,9,9,7,7,8,8,9,9,15,15,6,6,9,9,11,11,12,12,12,12,11,11,6,6,9,9,15,15,7,7,5,5,0,0,14,14,2,2,6,6,10,10,0,0,0,0,2,2,13,13,12,12,3,3,9,9,6,6,10,10,4,4,9,9,13,13,15,15,1,1,3,3,15,15,4,4,4,4,3,3,0,0,11,11,6,6,14,14,8,8,14,14,15,15,10,10,13,13,6,6,6,6,3,3,15,15,5,5,15,15,14,14,13,13,10,10,14,14,12,12,0,0,9,9,14,14,2,2,9,9,1,1,1,1,5,5,2,2,0,0,10,10,7,7,13,13,2,2,7,7,15,15,2,2,6,6,1,1,9,9,6,6,10,10,5,5,14,14,12,12,1,1,0,0,1,1,4,4,11,11,11,11,2,2,1,1,2,2,4,4,6,6,3,3,13,13,0,0,6,6,8,8,0,0,9,9,8,8,15,15,2,2,10,10,7,7,6,6,12,12,13,13,13,13,3,3,5,5,8,8,4,4,1,1,9,9,0,0,3,3,7,7,12,12,11,11,8,8,12,12,3,3,2,2,1,1,10,10,5,5,5,5,3,3,0,0,11,11,10,10,4,4,15,15,10,10,1,1,3,3,2,2,13,13,8,8,0,0,10,10,2,2,4,4,12,12,2,2,12,12,8,8,6,6,0,0,4,4,5,5,4,4,1,1,10,10,13,13,13,13,4,4,13,13,15,15,14,14,5,5,10,10,0,0,0,0,6,6,9,9,1,1,8,8,11,11,12,12,2,2,4,4,3,3,3,3,8,8,8,8,10,10,13,13,13,13,1,1,1,1,5,5,1,1,8,8,7,7,11,11,7,7,6,6,7,7,13,13,4,4,15,15,4,4,10,10,1,1,3,3,15,15,15,15,3,3,0,0,10,10,12,12,1,1,14,14,14,14,2,2,8,8,6,6,9,9,4,4,12,12,7,7,10,10,8,8,4,4,15,15,1,1,11,11,15,15,0,0,0,0,11,11,2,2,11,11,2,2,4,4,3,3,9,9,12,12,2,2,11,11,10,10,1,1,9,9,6,6,3,3,5,5,4,4,9,9,8,8,8,8,8,8,9,9,14,14,0,0,11,11,5,5,14,14,4,4,4,4,10,10,10,10,15,15,0,0,9,9,4,4,10,10,11,11,6,6,15,15,2,2,11,11,10,10,2,2,6,6,7,7,14,14,7,7,9,9,15,15,0,0,5,5,1,1,13,13,0,0,2,2,2,2,7,7,0,0,15,15,8,8,6,6,7,7,10,10,12,12,9,9,2,2,10,10,1,1,2,2,13,13,4,4,2,2,6,6,8,8,6,6,7,7,2,2,11,11,11,11,3,3,5,5,1,1,14,14,12,12,7,7,9,9,6,6,5,5,11,11,4,4,3,3,0,0,6,6,1,1,4,4,7,7,1,1,3,3,4,4,7,7,5,5,7,7,10,10,11,11,8,8,14,14,14,14,8,8,5,5,1,1,1,1,12,12,15,15,1,1,3,3,1,1,13,13,3,3,0,0,8,8,2,2,4,4,6,6,1,1,9,9,4,4,1,1,9,9,7,7,14,14,13,13,7,7,13,13,5,5,0,0,7,7,4,4,5,5,9,9,0,0,3,3,13,13,0,0,5,5,15,15,2,2,10,10,15,15,12,12,7,7,2,2,3,3,5,5,15,15,1,1,1,1,15,15,14,14,9,9,9,9,8,8,10,10,10,10,11,11,0,0,0,0,10,10,12,12,12,12,12,12,15,15,2,2,14,14,15,15,7,7,2,2,2,2,15,15,11,11,8,8,15,15,8,8,14,14,8,8,9,9,6,6,9,9,14,14,3,3,6,6,13,13,4,4,12,12,0,0,12,12,13,13,4,4,12,12,1,1,14,14,7,7,1,1,6,6,5,5,3,3,0,0,6,6,8,8,6,6,11,11,4,4,9,9,4,4,10,10,0,0,2,2,11,11,3,3,12,12,13,13,0,0,1,1,2,2,7,7,10,10,10,10,8,8,6,6,14,14,10,10,5,5,11,11,11,11,7,7,14,14,14,14,3,3,13,13,5,5,10,10,3,3,12,12,14,14,10,10,9,9,15,15,14,14,9,9,4,4,2,2,8,8,12,12,15,15,13,13,7,7,0,0,13,13,13,13,1,1,2,2,2,2,0,0,13,13,4,4,7,7,11,11,13,13,8,8,1,1,0,0,14,14,11,11,7,7,6,6,0,0,5,5,6,6,10,10,12,12,10,10,8,8,10,10,6,6,15,15,4,4,10,10,4,4,9,9,4,4,11,11,4,4,2,2,3,3,14,14,11,11,13,13,2,2,2,2,7,7,15,15,1,1,11,11,7,7,10,10,5,5,7,7,3,3,0,0,13,13,11,11,7,7,8,8,8,8,0,0,5,5,10,10,0,0,14,14,4,4,5,5,15,15,15,15,2,2,11,11,10,10,13,13,8,8,4,4,7,7,9,9,4,4,12,12,4,4,0,0,8,8,12,12,5,5,7,7,9,9,4,4,6,6,14,14,5,5,9,9,4,4,8,8,10,10,2,2,13,13,13,13,9,9,6,6,9,9,10,10,12,12,10,10,1,1,6,6,4,4,3,3,3,3,14,14,11,11,1,1,11,11,1,1,2,2,7,7,11,11,15,15,3,3,13,13,2,2,9,9,0,0,12,12,4,4,7,7,9,9,13,13,0,0,2,2,3,3,10,10,12,12,14,14,6,6,7,7,9,9,8,8,8,8,0,0,6,6,8,8,10,10,12,12,1,1,7,7,4,4,11,11,10,10,10,10,12,12,0,0,10,10,6,6,0,0,1,1,13,13,13,13,7,7,2,2,3,3,2,2,13,13,9,9,9,9,7,7,6,6,5,5,10,10,15,15,7,7,10,10,8,8,6,6,2,2,2,2,5,5,7,7,12,12,14,14,3,3,10,10,4,4,9,9,3,3,0,0,11,11,3,3,8,8,6,6,13,13,5,5,2,2,15,15,13,13,1,1,1,1,15,15,15,15,3,3,5,5,8,8,7,7,2,2,7,7,1,1,14,14,15,15,2,2,7,7,6,6,2,2,9,9,13,13,1,1,12,12,4,4,1,1,12,12,1,1,2,2,6,6,9,9,15,15,7,7,2,2,8,8,0,0,10,10,5,5,15,15,11,11,1,1,8,8,1,1,12,12,1,1,1,1,3,3,7,7,1,1,6,6,4,4,3,3,15,15,7,7,13,13,5,5,10,10,8,8,2,2,15,15,10,10,15,15,5,5,15,15,10,10,1,1,1,1,6,6,9,9,10,10,3,3,8,8,5,5,8,8,1,1,15,15,5,5,6,6,2,2,14,14,8,8,5,5,6,6,7,7,11,11,14,14,1,1,14,14,6,6,7,7,7,7,0,0,3,3,4,4,0,0,14,14,8,8,0,0,9,9,3,3,4,4,7,7,3,3,9,9,15,15,14,14,8,8,11,11,13,13,13,13,9,9,11,11,8,8,2,2,7,7,4,4,12,12,0,0,10,10,7,7,11,11,12,12,8,8,13,13,13,13,4,4,14,14,10,10,7,7,1,1,14,14,13,13,9,9,14,14,0,0,9,9,6,6,4,4,14,14,1,1,8,8,1,1,5,5,9,9,0,0,4,4,5,5,13,13,0,0,15,15,11,11,1,1,3,3,1,1,3,3,5,5,6,6,8,8,1,1,0,0,3,3,1,1,14,14,14,14,11,11,2,2,10,10,4,4,1,1,10,10,12,12,11,11,12,12,7,7,8,8,6,6,4,4,5,5,4,4,0,0,9,9,8,8,1,1,1,1,12,12,7,7,9,9,1,1,11,11,6,6,15,15,6,6,0,0,6,6,11,11,12,12,10,10,14,14,5,5,13,13,13,13,6,6,0,0,2,2,8,8,8,8,14,14,3,3,9,9,15,15,4,4,11,11,3,3,1,1,13,13,0,0,12,12,10,10,4,4,2,2,11,11,12,12,11,11,11,11,11,11,14,14,1,1,5,5,2,2,0,0,4,4,6,6,1,1,3,3,2,2,3,3,11,11,9,9,1,1,1,1,8,8,3,3,0,0,12,12,9,9,15,15,11,11,2,2,2,2,10,10,13,13,2,2,3,3,6,6,2,2,15,15,11,11,3,3,15,15,0,0,15,15,6,6,2,2,0,0,6,6,1,1,9,9,0,0,14,14,0,0,10,10,8,8,8,8,2,2,7,7,4,4,5,5,11,11,14,14,3,3,7,7,0,0,12,12,2,2,1,1,1,1,10,10,7,7,7,7,10,10,3,3,6,6,3,3,12,12,10,10,1,1,12,12,11,11,0,0,6,6,9,9,9,9,6,6,4,4,9,9,1,1,8,8,5,5,1,1,8,8,4,4,9,9,15,15,7,7,6,6,9,9,11,11,4,4,5,5,2,2,1,1,11,11,13,13,11,11,8,8,0,0,15,15,6,6,12,12,1,1,4,4,1,1,15,15,0,0,13,13,6,6,1,1,5,5,13,13,10,10,5,5,8,8,5,5,2,2,4,4,11,11,9,9,2,2,13,13,1,1,11,11,13,13,5,5,10,10,15,15,11,11,1,1,1,1,15,15,11,11,9,9,8,8,5,5,9,9,8,8,4,4,2,2,11,11,3,3,0,0,3,3,10,10,9,9,4,4,6,6,2,2,2,2,7,7,12,12,9,9,1,1,6,6,2,2,10,10,0,0,14,14,7,7,7,7,5,5,6,6,4,4,11,11,12,12,7,7,2,2,3,3,15,15,10,10,13,13,0,0,3,3,12,12,5,5,12,12,6,6,11,11,3,3,11,11,14,14,15,15,5,5,7,7,8,8,14,14,7,7,5,5,10,10,13,13,5,5,3,3,5,5,4,4,9,9,7,7,3,3,3,3,10,10,9,9,8,8,11,11,9,9,3,3,1,1,0,0,10,10,6,6,11,11,14,14,8,8,0,0,6,6,0,0,3,3,1,1,8,8,13,13,8,8,13,13,14,14,1,1,8,8,10,10,4,4,1,1,15,15,4,4,11,11,14,14,0,0,10,10,13,13,1,1,14,14,4,4,14,14,12,12,11,11,11,11,2,2,7,7,7,7,7,7,6,6,12,12,12,12,11,11,0,0,14,14,13,13,3,3,0,0,11,11,0,0,4,4,4,4,12,12,4,4,4,4,15,15,4,4,15,15,9,9,15,15,11,11,15,15,12,12,11,11,4,4,2,2,10,10,10,10,8,8,13,13,1,1,13,13,11,11,4,4,4,4,10,10,5,5,11,11,11,11,7,7,6,6,8,8,1,1,8,8,4,4,12,12,15,15,5,5,14,14,14,14,13,13,8,8,5,5,7,7,7,7,3,3,5,5,15,15,1,1,0,0,8,8,13,13,7,7,7,7,6,6,4,4,9,9,8,8,5,5,7,7,6,6,12,12,9,9,9,9,3,3,3,3,2,2,7,7,7,7,8,8,6,6,3,3,10,10,12,12,11,11,0,0,3,3,3,3,4,4,6,6,8,8,1,1,9,9,14,14,3,3,3,3,15,15,11,11,5,5,6,6,3,3,9,9,9,9,5,5,0,0,11,11,13,13,11,11,13,13,7,7,10,10,3,3,10,10,15,15,5,5,14,14,5,5,7,7,12,12,6,6,7,7,1,1,5,5,7,7,2,2,3,3,2,2,6,6,13,13,1,1,2,2,2,2,5,5,2,2,5,5,1,1,9,9,1,1,8,8,2,2,2,2,15,15,13,13,4,4,13,13,7,7,14,14,3,3,3,3,11,11,9,9,4,4,7,7,6,6,2,2,2,2,12,12,0,0,0,0,3,3,13,13,8,8,12,12,13,13,14,14,12,12,9,9,3,3,0,0,10,10,6,6,15,15,10,10,8,8,6,6,7,7,10,10,2,2,8,8,6,6,8,8,10,10,12,12,15,15,15,15,4,4,1,1,10,10,4,4,8,8,14,14,7,7,3,3,6,6,2,2,13,13,2,2,13,13,10,10,4,4,3,3,12,12,0,0,2,2,13,13,1,1,4,4,14,14,1,1,7,7,9,9,12,12,0,0,0,0,7,7,5,5,7,7,10,10,15,15,13,13,1,1,11,11,12,12,9,9,2,2,5,5,12,12,14,14,14,14,2,2,13,13,15,15,3,3,13,13,8,8,7,7,6,6,8,8,14,14,2,2,4,4,11,11,4,4,10,10,2,2,6,6,1,1,1,1,11,11,5,5,9,9,0,0,7,7,5,5,14,14,3,3,10,10,6,6,12,12,6,6,12,12,8,8,0,0,5,5,3,3,3,3,9,9,13,13,4,4,3,3,9,9,15,15,6,6,1,1,11,11,6,6,4,4,14,14,5,5,8,8,4,4,0,0,10,10,13,13,15,15,13,13,15,15,7,7,0,0,5,5,6,6,0,0,8,8,8,8,8,8,7,7,3,3,10,10,14,14,1,1,6,6,14,14,11,11,2,2,5,5,2,2,4,4,4,4,1,1,2,2,13,13,10,10,7,7,10,10,12,12,8,8,11,11,1,1,9,9,6,6,2,2,1,1,2,2,12,12,8,8,5,5,5,5,9,9,6,6,2,2,14,14,5,5,3,3,0,0,4,4,4,4,4,4,1,1,12,12,9,9,7,7,8,8,3,3,9,9,2,2,6,6,1,1,12,12,15,15,0,0,15,15,13,13,1,1,7,7,14,14,0,0,9,9,2,2,11,11,3,3,10,10,2,2,11,11,10,10,12,12,8,8,0,0,2,2,15,15,13,13,6,6,12,12,15,15,5,5,4,4,8,8,9,9,12,12,0,0,9,9,6,6,9,9,4,4,9,9,0,0,6,6,9,9,4,4,14,14,2,2,15,15,12,12,8,8,2,2,4,4,3,3,1,1,10,10,7,7,9,9,15,15,8,8,0,0,2,2,9,9,6,6,15,15,11,11,11,11,3,3,8,8,12,12,1,1,4,4,5,5,7,7,0,0,9,9,10,10,6,6,3,3,12,12,9,9,4,4,5,5,9,9,2,2,2,2,0,0,6,6,4,4,12,12,1,1,6,6,6,6,4,4,8,8,4,4,14,14,8,8,0,0,14,14,6,6,3,3,10,10,4,4,1,1,1,1,12,12,15,15,9,9,10,10,5,5,5,5,10,10,14,14,8,8,10,10,8,8,8,8,14,14,6,6,13,13,11,11,2,2,7,7,12,12,0,0,8,8,6,6,9,9,9,9,6,6,8,8,14,14,6,6,12,12,13,13,12,12,0,0,0,0,8,8,11,11,12,12,7,7,3,3,10,10,14,14,2,2,10,10,8,8,6,6,4,4,6,6,13,13,7,7,4,4,0,0,4,4,1,1,0,0,5,5,1,1,3,3,2,2,5,5,14,14,10,10,3,3,7,7,9,9,3,3,10,10,12,12,1,1,8,8,6,6,4,4,14,14,9,9,10,10,4,4,0,0,7,7,4,4,6,6,4,4,13,13,9,9,0,0,0,0,11,11,13,13,7,7,10,10,0,0,8,8,15,15,10,10,2,2,2,2,12,12,6,6,7,7,5,5,13,13,0,0,6,6,6,6,14,14,1,1,6,6,10,10,6,6,2,2,7,7,5,5,1,1,10,10,11,11,7,7,3,3,0,0,6,6,5,5,3,3,0,0,4,4,13,13,4,4,13,13,1,1,1,1,4,4,15,15,15,15,14,14,2,2,14,14,13,13,2,2,1,1,9,9,6,6,3,3,11,11,7,7,4,4,1,1,12,12,5,5,7,7,13,13,11,11,12,12,12,12,1,1,11,11,14,14,0,0,13,13,15,15,11,11,4,4,2,2,7,7,14,14,11,11,3,3,9,9,6,6,4,4,5,5,7,7,4,4,13,13,1,1,13,13,3,3,0,0,7,7,12,12,5,5,10,10,5,5,2,2,9,9,14,14,0,0,6,6,12,12,2,2,7,7,14,14,5,5,15,15,12,12,9,9,3,3,12,12,0,0,14,14,5,5,6,6,13,13,6,6,13,13,6,6,13,13,4,4,10,10,5,5,14,14,0,0,2,2,2,2,7,7,14,14,10,10,9,9,13,13,3,3,8,8,7,7,5,5,11,11,2,2,10,10,1,1,3,3,12,12,14,14,2,2,4,4,14,14,6,6,0,0,7,7,9,9,2,2,0,0,12,12,4,4,15,15,13,13,3,3,11,11,14,14,3,3,13,13,6,6,10,10,1,1,8,8,5,5,10,10,15,15,9,9,15,15,3,3,12,12,9,9,11,11,12,12,12,12,13,13,0,0,2,2,3,3,0,0,8,8,0,0,1,1,4,4,3,3,6,6,7,7,15,15,4,4,10,10,3,3,7,7,6,6,14,14,14,14,1,1,5,5,6,6,3,3,2,2,11,11,0,0,9,9,6,6,13,13,3,3,11,11,1,1,11,11,10,10,7,7,13,13,2,2,13,13,2,2,9,9,15,15,5,5,13,13,0,0,7,7,14,14,2,2,0,0,4,4,0,0,3,3,14,14,6,6,1,1,3,3,0,0,13,13,2,2,0,0,4,4,12,12,9,9,7,7,3,3,3,3,11,11,11,11,7,7,0,0,8,8,13,13,8,8,4,4,1,1,15,15,8,8,12,12,6,6,6,6,6,6,4,4,1,1,14,14,11,11,7,7,9,9,6,6,0,0,4,4,6,6,12,12,8,8,8,8,8,8,8,8,5,5,10,10,6,6,12,12,12,12,9,9,11,11,10,10,6,6,12,12,5,5,0,0,6,6,12,12,7,7,5,5,7,7,6,6,4,4,6,6,0,0,8,8,9,9,14,14,0,0,13,13,11,11,10,10,0,0,5,5,0,0,0,0,13,13,8,8,12,12,2,2,1,1,6,6,8,8,5,5,10,10,6,6,13,13,0,0,11,11,4,4,6,6,1,1,9,9,5,5,6,6,5,5,13,13,1,1,15,15,3,3,1,1,13,13,6,6,1,1,4,4,0,0,15,15,1,1,15,15,2,2,15,15,0,0,9,9,8,8,11,11,8,8,1,1,12,12,11,11,1,1,13,13,8,8,12,12,5,5,5,5,7,7,11,11,2,2,12,12,9,9,3,3,1,1,3,3,11,11,2,2,1,1,13,13,2,2,7,7,3,3,13,13,5,5,1,1,3,3,15,15,12,12,11,11,8,8,10,10,15,15,2,2,0,0,15,15,5,5,13,13,2,2,6,6,2,2,13,13,14,14,10,10,6,6,6,6,0,0,7,7,11,11,14,14,14,14,10,10,6,6,7,7,9,9,1,1,7,7,8,8,3,3,0,0,13,13,9,9,4,4,4,4,4,4,7,7,6,6,9,9,9,9,2,2,4,4,1,1,13,13,15,15,1,1,14,14,3,3,2,2,0,0,4,4,11,11,7,7,5,5,11,11,8,8,7,7,13,13,8,8,15,15,4,4,11,11,5,5,11,11,11,11,12,12,15,15,10,10,7,7,0,0,3,3,11,11,8,8,2,2,1,1,4,4,2,2,1,1,9,9,9,9,5,5,5,5,11,11,8,8,14,14,3,3,0,0,10,10,3,3,15,15,9,9,13,13,1,1,15,15,1,1,14,14,6,6,7,7,2,2,1,1,6,6,9,9,15,15,12,12,15,15,1,1,5,5,8,8,10,10,13,13,8,8,10,10,15,15,6,6,3,3,0,0,5,5,4,4,9,9,14,14,0,0,2,2,10,10,3,3,14,14,11,11,8,8,0,0,2,2,0,0,5,5,9,9,4,4,10,10,12,12,9,9,14,14,4,4,14,14,2,2,12,12,11,11,15,15,1,1,13,13,6,6,8,8,7,7,5,5,10,10,13,13,8,8,1,1,14,14,9,9,7,7,9,9,14,14,10,10,5,5,13,13,10,10,4,4,5,5,7,7,1,1,14,14,5,5,15,15,8,8,9,9,5,5,1,1,8,8,8,8,14,14,11,11,14,14,14,14,10,10,5,5,0,0,4,4,3,3,8,8,12,12,14,14,9,9,10,10,11,11,5,5,12,12,4,4,11,11,2,2,7,7,4,4,15,15,6,6,13,13,4,4,6,6,15,15,4,4,2,2,11,11,5,5,2,2,12,12,9,9,9,9,13,13,10,10,13,13,8,8,5,5,8,8,0,0,5,5,1,1,13,13,11,11,7,7,1,1,2,2,9,9,12,12,3,3,13,13,0,0,7,7,5,5,5,5,12,12,1,1,14,14,2,2,10,10,12,12,15,15,8,8,13,13,15,15,1,1,8,8,13,13,8,8,14,14,10,10,14,14,5,5,2,2,2,2,5,5,10,10,6,6,10,10,14,14,13,13,0,0,4,4,8,8,1,1,6,6,3,3,2,2,3,3,15,15,12,12,0,0,4,4,14,14,6,6,14,14,13,13,14,14,2,2,10,10,0,0,4,4,0,0,6,6,6,6,12,12,2,2,4,4,13,13,2,2,0,0,11,11,8,8,6,6,12,12,9,9,14,14,10,10,7,7,8,8,8,8,15,15,12,12,8,8,4,4,11,11,7,7,3,3,3,3,6,6,11,11,1,1,2,2,13,13,9,9,4,4,15,15,7,7,9,9,10,10,8,8,13,13,9,9,14,14,14,14,6,6,6,6,10,10,3,3,6,6,6,6,3,3,9,9,10,10,8,8,12,12,4,4,15,15,0,0,4,4,9,9,7,7,9,9,10,10,0,0,11,11,9,9,4,4,1,1,7,7,8,8,9,9,8,8,2,2,13,13,12,12,5,5,9,9,14,14,10,10,3,3,13,13,15,15,0,0,15,15,3,3,15,15,7,7,12,12,6,6,8,8,0,0,4,4,14,14,10,10,13,13,15,15,1,1,9,9,2,2,6,6,11,11,12,12,5,5,12,12,4,4,12,12,5,5,10,10,3,3,11,11,11,11,2,2,6,6,11,11,2,2,2,2,9,9,15,15,11,11,7,7,7,7,2,2,14,14,4,4,5,5,6,6,14,14,2,2,3,3,5,5,10,10,5,5,0,0,4,4,5,5,7,7,1,1,14,14,7,7,8,8,7,7,6,6,14,14,9,9,4,4,3,3,6,6,6,6,6,6,14,14,12,12,10,10,4,4,3,3,11,11,13,13,8,8,6,6,15,15,2,2,3,3,6,6,2,2,10,10,13,13,3,3,7,7,2,2,0,0,15,15,0,0,13,13,13,13,6,6,0,0,12,12,14,14,14,14,6,6,12,12,10,10,12,12,6,6,12,12,14,14,4,4,13,13,1,1,7,7,0,0,1,1,7,7,0,0,13,13,1,1,6,6,4,4,6,6,3,3,5,5,0,0,15,15,11,11,5,5,14,14,8,8,0,0,9,9,6,6,15,15,10,10,2,2,0,0,1,1,13,13,11,11,7,7,15,15,5,5,6,6,14,14,4,4,1,1,0,0,8,8,5,5,1,1,9,9,12,12,7,7,15,15,2,2,15,15,1,1,5,5,7,7,4,4,8,8,8,8,7,7,0,0,9,9,15,15,0,0,15,15,10,10,15,15,13,13,10,10,14,14,10,10,1,1,5,5,15,15,10,10,5,5,4,4,13,13,10,10,13,13,5,5,0,0,6,6,8,8,14,14,2,2,9,9,7,7,12,12,6,6,8,8,9,9,8,8,3,3,4,4,12,12,5,5,4,4,2,2,13,13,3,3,6,6,1,1,14,14,13,13,10,10,14,14,13,13,0,0,9,9,1,1,9,9,2,2,2,2,0,0,4,4,4,4,11,11,3,3,6,6,10,10,3,3,12,12,0,0,0,0,1,1,8,8,3,3,5,5,10,10,1,1,12,12,7,7,11,11,8,8,15,15,10,10,2,2,0,0,2,2,6,6,3,3,3,3,7,7,12,12,12,12,1,1,12,12,12,12,6,6,8,8,11,11,3,3,15,15,1,1,4,4,14,14,7,7,3,3,6,6,6,6,10,10,6,6,9,9,7,7,12,12,0,0,11,11,5,5,15,15,0,0,0,0,8,8,5,5,7,7,14,14,0,0,3,3,2,2,0,0,3,3,2,2,5,5,1,1,0,0,1,1,2,2,0,0,4,4,11,11,8,8,5,5,13,13,0,0,1,1,13,13,4,4,9,9,14,14,7,7,2,2,7,7,13,13,7,7,1,1,0,0,3,3,8,8,5,5,13,13,14,14,4,4,14,14,15,15,4,4,12,12,9,9,10,10,15,15,0,0,6,6,15,15,9,9,4,4,15,15,7,7,0,0,13,13,11,11,7,7,14,14,8,8,10,10,3,3,6,6,4,4,5,5,1,1,7,7,8,8,2,2,13,13,11,11,0,0,7,7,4,4,2,2,1,1,9,9,8,8,8,8,5,5,4,4,11,11,2,2,7,7,3,3,14,14,15,15,11,11,12,12,10,10,7,7,9,9,0,0,3,3,14,14,13,13,6,6,9,9,1,1,8,8,5,5,14,14,8,8,11,11,3,3,1,1,14,14,13,13,15,15,14,14,5,5,8,8,5,5,1,1,12,12,11,11,1,1,12,12,3,3,14,14,5,5,0,0,15,15,12,12,15,15,9,9,10,10,11,11,10,10,15,15,15,15,0,0,0,0,6,6,3,3,12,12,6,6,15,15,8,8,10,10,1,1,13,13,8,8,6,6,12,12,9,9,2,2,5,5,8,8,9,9,11,11,0,0,3,3,0,0,10,10,2,2,11,11,9,9,0,0,14,14,15,15,0,0,7,7,12,12,13,13,12,12,15,15,4,4,15,15,14,14,6,6,10,10,9,9,4,4,2,2,13,13,11,11,3,3,11,11,7,7,13,13,5,5,14,14,8,8,1,1,15,15,14,14,6,6,7,7,9,9,15,15,1,1,10,10,6,6,5,5,1,1,10,10,11,11,0,0,12,12,4,4,5,5,13,13,0,0,0,0,10,10,5,5,15,15,1,1,11,11,11,11,2,2,4,4,7,7,2,2,2,2,3,3,11,11,14,14,8,8,12,12,8,8,3,3,6,6,4,4,0,0,5,5,12,12,14,14,0,0,8,8,9,9,3,3,0,0,2,2,11,11,11,11,1,1,12,12,7,7,8,8,13,13,14,14,15,15,4,4,1,1,14,14,14,14,13,13,8,8,12,12,13,13,7,7,12,12,14,14,15,15,1,1,15,15,1,1,9,9,9,9,7,7,15,15,6,6,5,5,9,9,3,3,4,4,13,13,0,0,0,0,14,14,14,14,7,7,11,11,7,7,2,2,15,15,14,14,3,3,15,15,0,0,10,10,15,15,3,3,4,4,6,6,12,12,7,7,13,13,10,10,4,4,9,9,7,7,1,1,4,4,2,2,11,11,6,6,5,5,14,14,9,9,11,11,4,4,14,14,13,13,4,4,3,3,11,11,8,8,3,3,9,9,12,12,8,8,15,15,1,1,13,13,2,2,14,14,7,7,0,0,10,10,4,4,10,10,13,13,4,4,13,13,5,5,5,5,5,5,5,5,10,10,8,8,10,10,1,1,13,13,7,7,6,6,6,6,13,13,14,14,8,8,15,15,2,2,14,14,2,2,5,5,7,7,9,9,9,9,11,11,2,2,6,6,3,3,3,3,13,13,14,14,2,2,10,10,9,9,8,8,13,13,1,1,2,2,3,3,13,13,4,4,4,4,2,2,6,6,9,9,7,7,3,3,1,1,13,13,11,11,0,0,10,10,12,12,4,4,0,0,7,7,1,1,9,9,11,11,4,4,6,6,10,10,3,3,4,4,13,13,6,6,10,10,1,1,10,10,5,5,0,0,7,7,11,11,15,15,8,8,3,3,10,10,9,9,11,11,8,8,8,8,12,12,7,7,0,0,2,2,10,10,14,14,12,12,8,8,12,12,13,13,0,0,15,15,12,12,11,11,9,9,8,8,4,4,4,4,5,5,2,2,12,12,1,1,7,7,8,8,13,13,10,10,15,15,13,13,12,12,15,15,5,5,2,2,11,11,5,5,13,13,1,1,4,4,15,15,10,10,10,10,7,7,3,3,13,13,14,14,9,9,3,3,14,14,6,6,13,13,7,7,15,15,8,8,0,0,14,14,15,15,2,2,4,4,3,3,1,1,4,4,0,0,2,2,2,2,0,0,14,14,11,11,2,2,2,2,6,6,4,4,1,1,2,2,4,4,7,7,5,5,12,12,8,8,3,3,0,0,3,3,13,13,13,13,2,2,7,7,9,9,5,5,15,15,6,6,1,1,6,6,10,10,12,12,8,8,13,13,13,13,13,13,9,9,14,14,13,13,7,7,0,0,9,9,5,5,6,6,0,0,2,2,9,9,0,0,9,9,10,10,9,9,12,12,9,9,12,12,10,10,10,10,5,5,10,10,2,2,7,7,5,5,7,7,6,6,12,12,12,12,12,12,12,12,7,7,14,14,9,9,7,7,9,9,2,2,1,1,5,5,13,13,0,0,12,12,0,0,0,0,3,3,5,5,4,4,2,2,6,6,1,1,14,14,5,5,8,8,15,15,10,10,10,10,9,9,8,8,12,12,8,8,0,0,3,3,10,10,13,13,7,7,2,2,8,8,1,1,3,3,9,9,9,9,7,7,2,2,3,3,12,12,6,6,12,12,2,2,13,13,9,9,12,12,0,0,13,13,1,1,6,6,15,15,2,2,8,8,6,6,15,15,15,15,4,4,1,1,10,10,13,13,15,15,4,4,5,5,0,0,0,0,12,12,4,4,1,1,9,9,2,2,5,5,1,1,1,1,6,6,2,2,1,1,0,0,3,3,14,14,3,3,3,3,10,10,1,1,1,1,8,8,6,6,15,15,2,2,9,9,11,11,0,0,2,2,13,13,13,13,12,12,13,13,12,12,0,0,13,13,2,2,5,5,6,6,9,9,10,10,8,8,11,11,8,8,8,8,1,1,1,1,13,13,0,0,11,11,5,5,0,0,6,6,14,14,2,2,4,4,14,14,0,0,1,1,6,6,7,7,4,4,2,2,7,7,9,9,12,12,15,15,0,0,2,2,3,3,7,7,3,3,8,8,9,9,6,6,9,9,12,12,4,4,2,2,1,1,10,10,4,4,1,1,5,5,13,13,3,3,11,11,8,8,13,13,10,10,9,9,5,5,0,0,10,10,15,15,14,14,14,14,0,0,10,10,8,8,2,2,0,0,11,11,13,13,3,3,5,5,1,1,4,4,3,3,15,15,1,1,10,10,15,15,9,9,4,4,2,2,4,4,12,12,11,11,9,9,15,15,8,8,10,10,2,2,8,8,6,6,8,8,9,9,10,10,11,11,12,12,0,0,12,12,6,6,13,13,9,9,3,3,2,2,0,0,10,10,4,4,8,8,14,14,7,7,15,15,5,5,0,0,8,8,11,11,6,6,15,15,11,11,6,6,0,0,5,5,4,4,14,14,2,2,2,2,10,10,3,3,12,12,9,9,11,11,10,10,10,10,1,1,9,9,10,10,14,14,10,10,12,12,10,10,10,10,10,10,10,10,9,9,3,3,12,12,8,8,9,9,3,3,15,15,8,8,4,4,12,12,0,0,10,10,1,1,7,7,15,15,3,3,1,1,0,0,15,15,4,4,5,5,15,15,9,9,11,11,11,11,0,0,6,6,10,10,13,13,2,2,7,7,3,3,14,14,7,7,3,3,7,7,9,9,8,8,13,13,15,15,13,13,3,3,0,0,2,2,4,4,5,5,14,14,7,7,10,10,7,7,0,0,13,13,9,9,5,5,7,7,5,5,0,0,8,8,4,4,11,11,8,8,14,14,4,4,15,15,8,8,10,10,11,11,2,2,6,6,12,12,9,9,1,1,6,6,5,5,13,13,5,5,0,0,2,2,11,11,7,7,8,8,10,10,4,4,1,1,8,8,7,7,9,9,7,7,2,2,2,2,7,7,9,9,0,0,0,0,3,3,2,2,13,13,1,1,4,4,9,9,2,2,4,4,15,15,8,8,3,3,5,5,3,3,7,7,7,7,4,4,6,6,13,13,14,14,8,8,10,10,3,3,3,3,4,4,15,15,15,15,0,0,4,4,12,12,1,1,2,2,3,3,10,10,6,6,10,10,13,13,7,7,3,3,2,2,15,15,11,11,10,10,8,8,13,13,3,3,1,1,10,10,10,10,2,2,4,4,13,13,11,11,8,8,15,15,11,11,11,11,2,2,7,7,8,8,3,3,14,14,0,0,9,9,10,10,3,3,4,4,2,2,1,1,5,5,1,1,13,13,13,13,10,10,5,5,15,15,6,6,10,10,9,9,3,3,4,4,4,4,14,14,4,4,7,7,1,1,14,14,13,13,7,7,8,8,13,13,9,9,15,15,12,12,11,11,0,0,15,15,3,3,7,7,9,9,11,11,8,8,12,12,5,5,4,4,11,11,3,3,11,11,4,4,12,12,9,9,4,4,7,7,4,4,9,9,4,4,14,14,9,9,7,7,0,0,1,1,6,6,6,6,4,4,15,15,3,3,1,1,7,7,4,4,5,5,11,11,10,10,2,2,3,3,15,15,5,5,2,2,9,9,8,8,15,15,2,2,8,8,1,1,7,7,15,15,12,12,1,1,7,7,0,0,6,6,0,0,7,7,4,4,6,6,1,1,7,7,7,7,12,12,9,9,14,14,0,0,14,14,11,11,11,11,7,7,7,7,6,6,0,0,10,10,6,6,1,1,4,4,3,3,8,8,12,12,2,2,10,10,7,7,0,0,15,15,4,4,10,10,12,12,8,8,15,15,14,14,11,11,1,1,8,8,2,2,0,0,0,0,12,12,3,3,1,1,11,11,11,11,6,6,12,12,11,11,9,9,14,14,11,11,4,4,11,11,4,4,9,9,12,12,6,6,13,13,11,11,11,11,2,2,1,1,5,5,10,10,1,1,2,2,12,12,15,15,10,10,14,14,10,10,7,7,15,15,3,3,8,8,1,1,6,6,5,5,10,10,0,0,2,2,11,11,2,2,4,4,3,3,13,13,12,12,13,13,7,7,3,3,6,6,10,10,9,9,6,6,10,10,12,12,0,0,4,4,4,4,12,12,9,9,6,6,13,13,1,1,9,9,12,12,9,9,14,14,0,0,8,8,12,12,12,12,5,5,8,8,9,9,3,3,11,11,2,2,6,6,9,9,12,12,2,2,13,13,2,2,9,9,12,12,9,9,9,9,7,7,2,2,13,13,9,9,3,3,7,7,3,3,2,2,8,8,4,4,4,4,15,15,9,9,5,5,4,4,14,14,5,5,2,2,11,11,11,11,13,13,2,2,4,4,11,11,13,13,5,5,2,2,0,0,11,11,6,6,10,10,2,2,7,7,11,11,0,0,14,14,13,13,0,0,5,5,13,13,3,3,15,15,8,8,5,5,9,9,13,13,10,10,14,14,8,8,4,4,11,11,2,2,12,12,7,7,10,10,14,14,2,2,12,12,4,4,13,13,13,13,1,1,14,14,10,10,10,10,10,10,5,5,1,1,13,13,4,4,8,8,2,2,0,0,7,7,7,7,0,0,7,7,6,6,5,5,7,7,15,15,2,2,0,0,12,12,0,0,8,8,15,15,0,0,11,11,2,2,14,14,4,4,2,2,7,7,1,1,7,7,0,0,3,3,12,12,9,9,15,15,14,14,0,0,9,9,10,10,10,10,9,9,1,1,14,14,9,9,2,2,0,0,11,11,2,2,8,8,3,3,8,8,5,5,10,10,9,9,2,2,6,6,14,14,9,9,7,7,7,7,15,15,4,4,3,3,11,11,14,14,0,0,7,7,4,4,14,14,11,11,7,7,15,15,13,13,12,12,7,7,15,15,13,13,11,11,3,3,12,12,3,3,12,12,4,4,2,2,1,1,10,10,0,0,12,12,12,12,7,7,2,2,4,4,15,15,5,5,9,9,13,13,15,15,4,4,8,8,9,9,3,3,13,13,1,1,14,14,4,4,15,15,5,5,8,8,7,7,12,12,7,7,5,5,14,14,9,9,4,4,10,10,5,5,5,5,0,0,3,3,3,3,12,12,2,2,3,3,9,9,2,2,2,2,1,1,1,1,14,14,11,11,10,10,5,5,2,2,7,7,2,2,15,15,9,9,0,0,5,5,12,12,3,3,14,14,4,4,0,0,2,2,2,2,3,3,13,13,6,6,1,1,15,15,6,6,7,7,5,5,15,15,8,8,1,1,12,12,0,0,4,4,5,5,3,3,6,6,5,5,3,3,10,10,5,5,15,15,6,6,1,1,15,15,1,1,8,8,15,15,10,10,0,0,1,1,6,6,4,4,8,8,0,0,9,9,14,14,14,14,1,1,12,12,1,1,6,6,1,1,14,14,4,4,1,1,0,0,12,12,12,12,0,0,1,1,9,9,0,0,1,1,8,8,14,14,5,5,2,2,15,15,3,3,9,9,15,15,6,6,7,7,12,12,4,4,0,0,7,7,12,12,8,8,7,7,2,2,5,5,8,8,8,8,0,0,4,4,15,15,2,2,0,0,7,7,3,3,2,2,9,9,6,6,2,2,4,4,14,14,12,12,1,1,15,15,2,2,1,1,10,10,8,8,13,13,10,10,1,1,12,12,2,2,7,7,9,9,0,0,6,6,10,10,9,9,5,5,0,0,8,8,6,6,9,9,5,5,4,4,11,11,10,10,8,8,10,10,11,11,13,13,9,9,3,3,2,2,0,0,11,11,15,15,2,2,12,12,3,3,5,5,7,7,14,14,3,3,14,14,0,0,4,4,8,8,4,4,12,12,10,10,5,5,13,13,9,9,0,0,11,11,5,5,0,0,10,10,7,7,8,8,3,3,10,10,12,12,0,0,11,11,15,15,3,3,9,9,15,15,3,3,8,8,8,8,3,3,13,13,13,13,12,12,8,8,12,12,6,6,0,0,6,6,10,10,4,4,4,4,12,12,10,10,3,3,12,12,9,9,8,8,14,14,1,1,1,1,12,12,15,15,10,10,5,5,10,10,9,9,3,3,12,12,6,6,2,2,15,15,9,9,2,2,6,6,3,3,0,0,4,4,10,10,7,7,12,12,14,14,1,1,8,8,0,0,5,5,8,8,7,7,2,2,1,1,0,0,13,13,4,4,10,10,11,11,5,5,9,9,3,3,10,10,11,11,6,6,15,15,0,0,14,14,7,7,3,3,7,7,8,8,13,13,2,2,10,10,14,14,6,6,12,12,3,3,4,4,9,9,1,1,12,12,14,14,0,0,1,1,14,14,15,15,13,13,13,13,11,11,3,3,8,8,9,9,5,5,8,8,4,4,13,13,13,13,8,8,6,6,10,10,5,5,1,1,7,7,8,8,0,0,3,3,14,14,13,13,14,14,3,3,5,5,9,9,11,11,2,2,13,13,6,6,10,10,15,15,0,0,0,0,5,5,2,2,12,12,11,11,12,12,4,4,15,15,13,13,5,5,4,4,9,9,5,5,4,4,2,2,1,1,8,8,0,0,0,0,2,2,15,15,3,3,12,12,8,8,8,8,14,14,1,1,11,11,15,15,1,1,2,2,5,5,5,5,7,7,7,7,12,12,8,8,5,5,5,5,13,13,1,1,9,9,13,13,9,9,5,5,8,8,0,0,13,13,2,2,0,0,5,5,10,10,8,8,7,7,12,12,14,14,2,2,10,10,5,5,2,2,3,3,10,10,2,2,8,8,5,5,3,3,12,12,8,8,3,3,4,4,14,14,2,2,3,3,3,3,8,8,13,13,10,10,9,9,4,4,12,12,0,0,13,13,5,5,4,4,13,13,5,5,3,3,15,15,10,10,14,14,15,15,3,3,10,10,4,4,11,11,3,3,5,5,10,10,9,9,2,2,4,4,12,12,2,2,4,4,0,0,13,13,9,9,14,14,8,8,12,12,15,15,12,12,0,0,0,0,0,0,3,3,10,10,6,6,13,13,0,0,6,6,15,15,9,9,1,1,15,15,13,13,5,5,11,11,8,8,6,6,5,5,6,6,7,7,12,12,5,5,15,15,7,7,1,1,13,13,11,11,4,4,14,14,1,1,2,2,6,6,7,7,2,2,1,1,8,8,2,2,1,1,9,9,13,13,5,5,3,3,8,8,3,3,1,1,4,4,15,15,4,4,10,10,13,13,1,1,5,5,7,7,11,11,5,5,15,15,7,7,14,14,13,13,1,1,13,13,9,9,2,2,0,0,4,4,3,3,9,9,13,13,14,14,6,6,0,0,4,4,11,11,10,10,13,13,9,9,1,1,11,11,1,1,7,7,10,10,12,12,15,15,10,10,7,7,15,15,13,13,3,3,13,13,4,4,9,9,5,5,12,12,0,0,8,8,8,8,13,13,3,3,9,9,7,7,15,15,6,6,3,3,13,13,12,12,8,8,15,15,2,2,2,2,1,1,7,7,8,8,14,14,8,8,2,2,9,9,1,1,4,4,10,10,10,10,4,4,6,6,15,15,8,8,9,9,3,3,7,7,1,1,9,9,6,6,9,9,12,12,15,15,6,6,2,2,5,5,2,2,8,8,14,14,14,14,10,10,8,8,12,12,2,2,8,8,3,3,4,4,6,6,8,8,2,2,8,8,12,12,5,5,15,15,10,10,13,13,5,5,15,15,3,3,13,13,11,11,8,8,0,0,11,11,9,9,10,10,10,10,7,7,2,2,11,11,13,13,12,12,4,4,8,8,10,10,2,2,1,1,5,5,11,11,10,10,4,4,15,15,0,0,10,10,7,7,8,8,5,5,11,11,11,11,12,12,12,12,4,4,15,15,10,10,8,8,8,8,11,11,0,0,7,7,1,1,0,0,5,5,12,12,14,14,7,7,12,12,11,11,0,0,2,2,11,11,8,8,3,3,12,12,14,14,14,14,1,1,11,11,5,5,9,9,1,1,7,7,6,6,11,11,7,7,3,3,9,9,12,12,12,12,9,9,5,5,10,10,14,14,1,1,7,7,9,9,2,2,3,3,13,13,11,11,6,6,12,12,0,0,9,9,15,15,4,4,3,3,0,0,10,10,8,8,6,6,9,9,0,0,2,2,8,8,4,4,10,10,10,10,15,15,5,5,14,14,12,12,2,2,2,2,8,8,12,12,5,5,0,0,9,9,13,13,4,4,10,10,12,12,1,1,3,3,0,0,1,1,2,2,0,0,4,4,4,4,8,8,3,3,13,13,1,1,4,4,13,13,12,12,5,5,6,6,3,3,7,7,7,7,0,0,0,0,1,1,11,11,13,13,9,9,0,0,10,10,9,9,12,12,11,11,2,2,6,6,7,7,0,0,12,12,7,7,6,6,15,15,4,4,11,11,10,10,5,5,1,1,11,11,5,5,7,7,13,13,5,5,0,0,9,9,15,15,10,10,4,4,0,0,5,5,1,1,0,0,4,4,3,3,15,15,9,9,8,8,6,6,9,9,9,9,0,0,14,14,3,3,7,7,10,10,15,15,8,8,12,12,3,3,9,9,1,1,5,5,10,10,3,3,8,8,3,3,0,0,10,10,9,9,15,15,12,12,4,4,1,1,9,9,3,3,7,7,8,8,9,9,10,10,14,14,2,2,12,12,15,15,13,13,9,9,7,7,8,8,15,15,5,5,13,13,7,7,0,0,1,1,12,12,13,13,13,13,1,1,11,11,8,8,11,11,6,6,10,10,6,6,8,8,10,10,13,13,7,7,1,1,0,0,11,11,12,12,9,9,2,2,2,2,0,0,9,9,6,6,6,6,15,15,11,11,3,3,12,12,1,1,13,13,11,11,2,2,0,0,9,9,11,11,0,0,5,5,15,15,5,5,14,14,12,12,12,12,12,12,13,13,8,8,9,9,14,14,13,13,2,2,10,10,12,12,2,2,9,9,5,5,12,12,3,3,10,10,1,1,6,6,2,2,13,13,13,13,4,4,11,11,5,5,3,3,12,12,3,3,7,7,8,8,7,7,10,10,13,13,6,6,9,9,13,13,11,11,14,14,15,15,1,1,0,0,0,0,0,0,13,13,10,10,0,0,11,11,3,3,10,10,10,10,7,7,9,9,8,8,8,8,2,2,14,14,12,12,7,7,9,9,14,14,10,10,12,12,1,1,15,15,4,4,2,2,8,8,10,10,10,10,13,13,5,5,14,14,9,9,2,2,1,1,15,15,14,14,3,3,12,12,15,15,4,4,6,6,6,6,6,6,0,0,2,2,10,10,7,7,11,11,5,5,1,1,0,0,1,1,0,0,8,8,4,4,0,0,0,0,2,2,6,6,13,13,4,4,13,13,6,6,8,8,4,4,8,8,15,15,10,10,10,10,14,14,11,11,1,1,12,12,10,10,6,6,2,2,9,9,12,12,2,2,1,1,5,5,7,7,11,11,14,14,1,1,15,15,5,5,3,3,3,3,10,10,4,4,0,0,2,2,4,4,12,12,2,2,6,6,0,0,6,6,7,7,4,4,3,3,12,12,11,11,6,6,13,13,3,3,6,6,4,4,8,8,3,3,6,6,14,14,3,3,2,2,12,12,15,15,8,8,7,7,7,7,3,3,12,12,1,1,3,3,4,4,13,13,5,5,7,7,13,13,5,5,11,11,3,3,4,4,14,14,10,10,6,6,4,4,3,3,9,9,8,8,15,15,4,4,15,15,1,1,8,8,7,7,8,8,2,2,15,15,7,7,3,3,0,0,12,12,9,9,15,15,11,11,12,12,8,8,12,12,12,12,4,4,1,1,8,8,4,4,3,3,5,5,8,8,1,1,2,2,4,4,6,6,13,13,9,9,3,3,3,3,4,4,14,14,14,14,10,10,3,3,12,12,8,8,9,9,7,7,9,9,14,14,14,14,0,0,5,5,0,0,15,15,12,12,15,15,5,5,7,7,2,2,11,11,2,2,3,3,13,13,15,15,14,14,9,9,2,2,3,3,13,13,7,7,3,3,8,8,3,3,8,8,14,14,15,15,7,7,3,3,9,9,6,6,12,12,2,2,10,10,8,8,0,0,3,3,9,9,9,9,13,13,11,11,12,12,1,1,0,0,13,13,7,7,1,1,2,2,13,13,7,7,8,8,12,12,8,8,8,8,14,14,13,13,0,0,13,13,6,6,6,6,7,7,14,14,15,15,3,3,7,7,9,9,0,0,8,8,14,14,12,12,4,4,2,2,4,4,13,13,5,5,8,8,6,6,13,13,0,0,14,14,8,8,2,2,3,3,11,11,5,5,3,3,14,14,5,5,7,7,14,14,2,2,7,7,9,9,4,4,2,2,0,0,13,13,2,2,14,14,11,11,2,2,3,3,13,13,10,10,6,6,4,4,2,2,6,6,13,13,3,3,11,11,13,13,12,12,8,8,10,10,1,1,6,6,1,1,1,1,10,10,14,14,4,4,12,12,13,13,13,13,10,10,4,4,11,11,8,8,5,5,10,10,6,6,3,3,0,0,10,10,4,4,14,14,1,1,7,7,9,9,2,2,4,4,15,15,6,6,8,8,0,0,2,2,4,4,5,5,12,12,15,15,3,3,6,6,13,13,3,3,10,10,1,1,14,14,7,7,7,7,11,11,10,10,10,10,10,10,4,4,7,7,12,12,3,3,1,1,14,14,12,12,1,1,12,12,15,15,6,6,2,2,2,2,0,0,13,13,1,1,10,10,3,3,6,6,5,5,5,5,13,13,10,10,2,2,0,0,11,11,0,0,11,11,12,12,13,13,3,3,12,12,15,15,5,5,2,2,15,15,6,6,7,7,7,7,3,3,15,15,1,1,15,15,9,9,3,3,14,14,10,10,10,10,8,8,5,5,13,13,12,12,9,9,14,14,0,0,6,6,15,15,12,12,11,11,5,5,1,1,0,0,14,14,12,12,4,4,14,14,2,2,3,3,15,15,9,9,0,0,14,14,1,1,7,7,9,9,14,14,1,1,12,12,2,2,1,1,8,8,11,11,6,6,15,15,2,2,10,10,12,12,9,9,15,15,15,15,14,14,1,1,9,9,9,9,10,10,0,0,8,8,15,15,7,7,10,10,1,1,12,12,15,15,4,4,1,1,5,5,8,8,15,15,9,9,4,4,8,8,10,10,0,0,12,12,10,10,11,11,6,6,0,0,2,2,4,4,12,12,1,1,9,9,9,9,2,2,3,3,0,0,6,6,2,2,14,14,10,10,8,8,8,8,15,15,12,12,1,1,7,7,5,5,15,15,1,1,0,0,15,15,8,8,3,3,6,6,12,12,12,12,8,8,14,14,12,12,9,9,7,7,2,2,11,11,9,9,12,12,4,4,5,5,1,1,0,0,15,15,2,2,3,3,1,1,5,5,9,9,3,3,1,1,10,10,10,10,12,12,8,8,0,0,0,0,12,12,6,6,14,14,6,6,12,12,7,7,10,10,0,0,9,9,15,15,10,10,5,5,6,6,15,15,4,4,15,15,0,0,14,14,10,10,0,0,4,4,3,3,9,9,5,5,11,11,12,12,9,9,6,6,1,1,5,5,10,10,4,4,0,0,14,14,13,13,4,4,15,15,7,7,4,4,4,4,15,15,13,13,1,1,3,3,3,3,5,5,8,8,0,0,5,5,13,13,8,8,5,5,6,6,10,10,0,0,5,5,4,4,5,5,6,6,11,11,12,12,6,6,4,4,8,8,7,7,13,13,12,12,4,4,11,11,2,2,14,14,9,9,15,15,0,0,7,7,10,10,2,2,3,3,2,2,0,0,1,1,10,10,8,8,10,10,1,1,4,4,15,15,9,9,7,7,5,5,8,8,7,7,6,6,8,8,0,0,14,14,7,7,15,15,2,2,7,7,1,1,13,13,2,2,6,6,7,7,2,2,12,12,0,0,13,13,5,5,9,9,9,9,8,8,13,13,13,13,11,11,12,12,7,7,5,5,14,14,12,12,2,2,0,0,6,6,13,13,1,1,4,4,1,1,10,10,13,13,11,11,2,2,8,8,14,14,4,4,3,3,5,5,14,14,7,7,13,13,15,15,4,4,12,12,5,5,1,1,11,11,12,12,14,14,1,1,12,12,0,0,9,9,4,4,2,2,8,8,4,4,14,14,3,3,3,3,3,3,15,15,11,11,5,5,7,7,13,13,9,9,3,3,8,8,5,5,14,14,1,1,8,8,9,9,5,5,12,12,9,9,2,2,12,12,8,8,13,13,8,8,7,7,8,8,7,7,11,11,11,11,4,4,14,14,4,4,8,8,2,2,8,8,14,14,10,10,7,7,10,10,11,11,13,13,3,3,12,12,6,6,2,2,10,10,13,13,2,2,12,12,4,4,15,15,13,13,3,3,1,1,3,3,11,11,15,15,14,14,12,12,5,5,14,14,6,6,5,5,0,0,2,2,13,13,8,8,4,4,13,13,14,14,0,0,11,11,2,2,2,2,4,4,6,6,0,0,14,14,2,2,11,11,4,4,10,10,15,15,2,2,10,10,7,7,14,14,8,8,13,13,8,8,14,14,8,8,0,0,10,10,11,11,9,9,2,2,0,0,0,0,1,1,13,13,0,0,8,8,9,9,0,0,0,0,3,3,8,8,1,1,2,2,4,4,7,7,4,4,15,15,8,8,3,3,1,1,7,7,12,12,13,13,8,8,4,4,8,8,6,6,0,0,12,12,5,5,9,9,5,5,10,10,8,8,6,6,13,13,9,9,8,8,11,11,6,6,15,15,11,11,8,8,8,8,0,0,11,11,14,14,12,12,4,4,0,0,2,2,10,10,12,12,15,15,13,13,4,4,10,10,15,15,0,0,0,0,1,1,14,14,11,11,11,11,5,5,11,11,5,5,6,6,2,2,6,6,13,13,7,7,4,4,11,11,5,5,12,12,9,9,9,9,2,2,8,8,11,11,10,10,10,10,6,6,5,5,7,7,3,3,3,3,8,8,9,9,11,11,4,4,14,14,15,15,11,11,3,3,0,0,13,13,11,11,11,11,3,3,13,13,4,4,1,1,10,10,8,8,3,3,15,15,15,15,12,12,15,15,0,0,14,14,11,11,15,15,7,7,10,10,3,3,8,8,9,9,15,15,0,0,12,12,9,9,4,4,9,9,10,10,9,9,8,8,9,9,6,6,5,5,9,9,2,2,14,14,1,1,11,11,12,12,11,11,14,14,6,6,6,6,2,2,0,0,13,13,3,3,9,9,8,8,4,4,1,1,0,0,1,1,6,6,1,1,8,8,5,5,3,3,15,15,12,12,6,6,11,11,10,10,8,8,9,9,12,12,1,1,15,15,5,5,14,14,8,8,10,10,0,0,14,14,2,2,0,0,5,5,1,1,5,5,7,7,9,9,14,14,9,9,14,14,1,1,9,9,1,1,15,15,8,8,3,3,5,5,12,12,2,2,7,7,15,15,15,15,0,0,11,11,5,5,0,0,8,8,7,7,11,11,8,8,10,10,10,10,4,4,6,6,0,0,8,8,14,14,13,13,0,0,7,7,4,4,13,13,4,4,0,0,6,6,1,1,0,0,0,0,15,15,10,10,0,0,5,5,10,10,9,9,14,14,15,15,9,9,0,0,14,14,1,1,11,11,11,11,12,12,9,9,8,8,3,3,10,10,8,8,1,1,11,11,4,4,4,4,5,5,2,2,5,5,13,13,9,9,3,3,2,2,14,14,8,8,8,8,15,15,9,9,7,7,8,8,10,10,12,12,7,7,11,11,1,1,15,15,4,4,3,3,15,15,5,5,11,11,8,8,5,5,15,15,5,5,6,6,10,10,2,2,6,6,10,10,3,3,15,15,11,11,11,11,7,7,15,15,10,10,1,1,6,6,10,10,8,8,4,4,4,4,13,13,7,7,12,12,1,1,4,4,8,8,9,9,10,10,7,7,13,13,11,11,11,11,0,0,5,5,9,9,7,7,7,7,14,14,10,10,2,2,11,11,0,0,13,13,2,2,0,0,4,4,3,3,1,1,7,7,9,9,13,13,13,13,0,0,9,9,11,11,9,9,7,7,1,1,7,7,0,0,11,11,10,10,10,10,13,13,7,7,7,7,15,15,0,0,7,7,11,11,10,10,0,0,14,14,9,9,9,9,5,5,5,5,10,10,13,13,15,15,7,7,4,4,2,2,6,6,11,11,12,12,15,15,4,4,1,1,4,4,11,11,7,7,6,6,12,12,9,9,3,3,11,11,9,9,11,11,9,9,6,6,8,8,6,6,6,6,8,8,5,5,2,2,10,10,0,0,4,4,10,10,12,12,6,6,1,1,15,15,11,11,3,3,10,10,4,4,9,9,6,6,10,10,6,6,12,12,8,8,9,9,7,7,6,6,9,9,12,12,8,8,11,11,14,14,10,10,4,4,2,2,12,12,10,10,13,13,0,0,0,0,3,3,14,14,10,10,7,7,1,1,10,10,2,2,0,0,8,8,8,8,8,8,9,9,5,5,0,0,3,3,3,3,7,7,9,9,0,0,2,2,1,1,4,4,8,8,5,5,13,13,10,10,10,10,12,12,11,11,8,8,2,2,15,15,7,7,11,11,10,10,9,9,0,0,5,5,7,7,0,0,12,12,1,1,0,0,9,9,1,1,13,13,13,13,3,3,10,10,2,2,1,1,5,5,2,2,4,4,11,11,5,5,12,12,15,15,8,8,4,4,4,4,3,3,12,12,6,6,1,1,9,9,9,9,9,9,12,12,5,5,0,0,11,11,11,11,13,13,3,3,1,1,12,12,0,0,8,8,10,10,3,3,11,11,5,5,9,9,3,3,9,9,1,1,5,5,7,7,8,8,6,6,5,5,11,11,0,0,3,3,3,3,2,2,7,7,10,10,7,7,3,3,1,1,13,13,9,9,10,10,7,7,6,6,7,7,1,1,6,6,15,15,0,0,5,5,10,10,9,9,1,1,9,9,4,4,15,15,1,1,14,14,9,9,4,4,1,1,13,13,9,9,0,0,1,1,14,14,10,10,10,10,13,13,15,15,4,4,12,12,3,3,1,1,6,6,5,5,11,11,10,10,7,7,6,6,12,12,9,9,11,11,10,10,14,14,8,8,4,4,6,6,1,1,15,15,8,8,6,6,1,1,7,7,14,14,12,12,12,12,1,1,14,14,6,6,15,15,11,11,1,1,2,2,11,11,12,12,5,5,5,5,14,14,2,2,15,15,3,3,6,6,1,1,10,10,14,14,8,8,0,0,4,4,5,5,11,11,0,0,6,6,10,10,9,9,10,10,3,3,13,13,0,0,3,3,8,8,0,0,9,9,15,15,12,12,15,15,15,15,2,2,0,0,10,10,8,8,6,6,4,4,15,15,2,2,0,0,4,4,14,14,10,10,11,11,12,12,3,3,2,2,5,5,15,15,10,10,4,4,14,14,13,13,10,10,0,0,2,2,2,2,13,13,8,8,11,11,3,3,3,3,10,10,3,3,14,14,15,15,11,11,15,15,5,5,8,8,8,8,2,2,1,1,3,3,11,11,1,1,14,14,6,6,9,9,1,1,5,5,5,5,5,5,14,14,10,10,9,9,12,12,2,2,8,8,7,7,3,3,8,8,0,0,9,9,4,4,3,3,10,10,15,15,6,6,14,14,1,1,11,11,9,9,14,14,7,7,1,1,12,12,2,2,13,13,13,13,14,14,11,11,6,6,4,4,1,1,6,6,9,9,4,4,11,11,1,1,13,13,11,11,12,12,8,8,11,11,5,5,6,6,6,6,2,2,9,9,7,7,2,2,9,9,8,8,14,14,11,11,0,0,8,8,3,3,6,6,4,4,13,13,1,1,7,7,14,14,3,3,12,12,12,12,6,6,2,2,12,12,8,8,9,9,2,2,11,11,4,4,2,2,0,0,12,12,14,14,7,7,4,4,13,13,14,14,7,7,0,0,10,10,10,10,10,10,8,8,5,5,10,10,3,3,9,9,1,1,7,7,7,7,5,5,8,8,6,6,4,4,4,4,7,7,4,4,8,8,2,2,11,11,5,5,10,10,4,4,1,1,6,6,14,14,3,3,1,1,15,15,10,10,9,9,12,12,4,4,2,2,2,2,2,2,2,2,14,14,7,7,7,7,4,4,15,15,10,10,1,1,8,8,10,10,14,14,2,2,1,1,6,6,15,15,3,3,11,11,4,4,2,2,14,14,0,0,4,4,11,11,11,11,4,4,0,0,4,4,3,3,4,4,6,6,0,0,3,3,6,6,6,6,12,12,0,0,2,2,6,6,1,1,8,8,13,13,12,12,3,3,10,10,0,0,5,5,6,6,7,7,9,9,2,2,0,0,4,4,7,7,12,12,6,6,4,4,10,10,15,15,2,2,2,2,11,11,13,13,0,0,9,9,15,15,1,1,4,4,0,0,6,6,3,3,5,5,8,8,0,0,9,9,6,6,3,3,12,12,3,3,1,1,9,9,9,9,3,3,11,11,8,8,6,6,3,3,5,5,3,3,7,7,12,12,12,12,5,5,14,14,8,8,13,13,4,4,8,8,8,8,14,14,0,0,2,2,9,9,15,15,3,3,14,14,2,2,12,12,11,11,0,0,2,2,2,2,3,3,5,5,14,14,8,8,11,11,10,10,8,8,2,2,10,10,1,1,12,12,1,1,12,12,6,6,6,6,4,4,9,9,5,5,12,12,11,11,15,15,7,7,14,14,6,6,12,12,5,5,5,5,9,9,12,12,4,4,0,0,13,13,10,10,12,12,14,14,3,3,15,15,13,13,0,0,15,15,0,0,14,14,0,0,6,6,7,7,9,9,15,15,5,5,12,12,8,8,4,4,1,1,11,11,12,12,15,15,11,11,1,1,15,15,0,0,10,10,4,4,11,11,3,3,13,13,14,14,13,13,5,5,0,0,2,2,1,1,12,12,5,5,0,0,7,7,11,11,15,15,9,9,2,2,5,5,4,4,7,7,12,12,12,12,3,3,8,8,4,4,1,1,14,14,6,6,10,10,4,4,12,12,6,6,15,15,1,1,1,1,7,7,5,5,5,5,11,11,13,13,7,7,4,4,9,9,1,1,7,7,3,3,8,8,12,12,14,14,10,10,8,8,8,8,4,4,10,10,3,3,9,9,5,5,0,0,1,1,0,0,7,7,1,1,13,13,7,7,14,14,0,0,14,14,12,12,13,13,5,5,4,4,13,13,1,1,2,2,1,1,14,14,12,12,3,3,3,3,2,2,11,11,6,6,6,6,14,14,4,4,12,12,6,6,0,0,0,0,8,8,1,1,13,13,15,15,1,1,0,0,4,4,10,10,10,10,6,6,0,0,1,1,9,9,15,15,8,8,8,8,11,11,12,12,15,15,9,9,4,4,4,4,4,4,12,12,5,5,7,7,4,4,4,4,2,2,4,4,2,2,9,9,0,0,10,10,2,2,10,10,14,14,3,3,0,0,10,10,4,4,11,11,14,14,0,0,8,8,5,5,11,11,5,5,7,7,0,0,6,6,4,4,7,7,2,2,1,1,13,13,2,2,15,15,9,9,7,7,4,4,10,10,10,10,14,14,14,14,13,13,3,3,14,14,12,12,12,12,0,0,4,4,0,0,12,12,7,7,9,9,0,0,1,1,9,9,3,3,15,15,10,10,1,1,2,2,14,14,12,12,7,7,3,3,4,4,11,11,5,5,4,4,2,2,11,11,11,11,10,10,4,4,11,11,1,1,14,14,4,4,1,1,2,2,11,11,12,12,10,10,7,7,6,6,12,12,3,3,9,9,10,10,10,10,3,3,5,5,7,7,7,7,11,11,2,2,7,7,4,4,12,12,13,13,15,15,2,2,14,14,7,7,3,3,13,13,1,1,10,10,8,8,8,8,10,10,2,2,10,10,3,3,14,14,2,2,8,8,7,7,2,2,6,6,13,13,3,3,10,10,14,14,2,2,6,6,2,2,2,2,9,9,15,15,7,7,8,8,13,13,9,9,12,12,10,10,4,4,11,11,8,8,7,7,13,13,8,8,11,11,9,9,15,15,11,11,1,1,14,14,15,15,5,5,15,15,6,6,5,5,9,9,5,5,11,11,7,7,15,15,1,1,4,4,8,8,13,13,8,8,0,0,4,4,8,8,5,5,11,11,8,8,1,1,8,8,11,11,0,0,12,12,1,1,9,9,9,9,9,9,3,3,7,7,12,12,9,9,7,7,0,0,11,11,6,6,5,5,3,3,6,6,9,9,11,11,15,15,12,12,3,3,5,5,0,0,3,3,5,5,13,13,15,15,1,1,5,5,8,8,2,2,0,0,8,8,15,15,13,13,15,15,8,8,4,4,4,4,8,8,7,7,10,10,13,13,13,13,5,5,9,9,4,4,5,5,2,2,15,15,10,10,2,2,6,6,0,0,15,15,9,9,15,15,0,0,11,11,1,1,14,14,9,9,5,5,11,11,4,4,2,2,14,14,10,10,5,5,4,4,8,8,15,15,3,3,6,6,1,1,0,0,2,2,4,4,1,1,4,4,3,3,4,4,6,6,8,8,8,8,6,6,4,4,4,4,13,13,4,4,12,12,7,7,2,2,14,14,10,10,0,0,12,12,9,9,6,6,9,9,9,9,14,14,10,10,6,6,2,2,11,11,1,1,2,2,11,11,0,0,9,9,6,6,0,0,11,11,9,9,0,0,8,8,13,13,0,0,9,9,12,12,7,7,11,11,8,8,2,2,15,15,9,9,6,6,4,4,4,4,4,4,9,9,14,14,9,9,4,4,6,6,1,1,2,2,8,8,11,11,12,12,13,13,1,1,2,2,3,3,11,11,6,6,2,2,13,13,7,7,2,2,12,12,15,15,13,13,10,10,14,14,2,2,1,1,2,2,3,3,3,3,2,2,2,2,6,6,5,5,0,0,6,6,3,3,11,11,5,5,1,1,8,8,1,1,5,5,1,1,4,4,12,12,3,3,6,6,5,5,15,15,7,7,15,15,11,11,13,13,5,5,14,14,0,0,0,0,5,5,6,6,6,6,10,10,2,2,5,5,10,10,1,1,14,14,1,1,0,0,11,11,15,15,15,15,15,15,4,4,1,1,13,13,10,10,2,2,3,3,5,5,13,13,5,5,1,1,15,15,4,4,6,6,10,10,13,13,0,0,10,10,1,1,14,14,9,9,4,4,0,0,8,8,15,15,11,11,14,14,10,10,4,4,14,14,0,0,6,6,8,8,8,8,12,12,3,3,12,12,6,6,8,8,1,1,10,10,13,13,15,15,2,2,10,10,11,11,1,1,8,8,8,8,4,4,1,1,15,15,1,1,6,6,2,2,3,3,10,10,6,6,1,1,9,9,1,1,2,2,3,3,3,3,14,14,7,7,2,2,4,4,8,8,7,7,1,1,3,3,14,14,12,12,14,14,0,0,13,13,6,6,8,8,5,5,3,3,14,14,13,13,11,11,3,3,9,9,11,11,2,2,9,9,8,8,4,4,13,13,5,5,7,7,6,6,14,14,14,14,7,7,5,5,15,15,3,3,12,12,6,6,9,9,15,15,9,9,2,2,11,11,8,8,10,10,3,3,0,0,4,4,15,15,6,6,0,0,12,12,9,9,4,4,1,1,5,5,8,8,7,7,6,6,8,8,8,8,6,6,5,5,12,12,5,5,9,9,14,14,2,2,9,9,3,3,11,11,10,10,3,3,5,5,2,2,0,0,10,10,4,4,12,12,3,3,12,12,4,4,0,0,2,2,9,9,2,2,2,2,1,1,7,7,5,5,3,3,9,9,6,6,8,8,0,0,1,1,6,6,2,2,12,12,12,12,10,10,5,5,2,2,15,15,0,0,1,1,0,0,8,8,6,6,0,0,12,12,8,8,6,6,4,4,12,12,6,6,8,8,7,7,0,0,11,11,4,4,3,3,13,13,12,12,15,15,6,6,15,15,4,4,11,11,8,8,12,12,9,9,9,9,3,3,10,10,1,1,8,8,7,7,5,5,7,7,11,11,9,9,8,8,7,7,5,5,2,2,4,4,7,7,3,3,7,7,0,0,14,14,0,0,5,5,15,15,3,3,2,2,6,6,0,0,1,1,1,1,6,6,9,9,3,3,14,14,9,9,5,5,3,3,5,5,7,7,7,7,2,2,3,3,6,6,14,14,13,13,1,1,4,4,15,15,14,14,6,6,7,7,12,12,12,12,7,7,6,6,13,13,8,8,14,14,3,3,6,6,6,6,0,0,11,11,5,5,1,1,1,1,15,15,5,5,7,7,11,11,8,8,5,5,7,7,6,6,0,0,6,6,2,2,4,4,1,1,14,14,2,2,15,15,13,13,13,13,2,2,15,15,15,15,9,9,14,14,6,6,14,14,2,2,7,7,1,1,14,14,7,7,11,11,9,9,3,3,2,2,1,1,7,7,9,9,14,14,15,15,14,14,13,13,15,15,4,4,10,10,5,5,6,6,8,8,5,5,15,15,13,13,3,3,14,14,0,0,4,4,8,8,8,8,4,4,11,11,15,15,2,2,14,14,6,6,11,11,7,7,15,15,14,14,1,1,14,14,2,2,12,12,7,7,2,2,11,11,10,10,0,0,2,2,7,7,15,15,3,3,5,5,8,8,10,10,0,0,1,1,10,10,3,3,2,2,4,4,5,5,6,6,1,1,15,15,7,7,0,0,6,6,2,2,4,4,7,7,13,13,1,1,0,0,15,15,6,6,8,8,13,13,7,7,3,3,0,0,10,10,11,11,13,13,10,10,1,1,4,4,15,15,8,8,12,12,4,4,12,12,4,4,13,13,15,15,2,2,9,9,2,2,3,3,12,12,15,15,4,4,14,14,15,15,2,2,2,2,6,6,15,15,11,11,9,9,6,6,10,10,0,0,14,14,7,7,10,10,8,8,15,15,10,10,12,12,5,5,6,6,0,0,14,14,4,4,4,4,3,3,9,9,0,0,3,3,2,2,4,4,12,12,1,1,12,12,15,15,6,6,9,9,1,1,5,5,10,10,8,8,1,1,12,12,2,2,2,2,7,7,6,6,12,12,4,4,14,14,14,14,1,1,10,10,8,8,8,8,6,6,0,0,2,2,8,8,12,12,10,10,3,3,3,3,12,12,8,8,3,3,1,1,12,12,12,12,1,1,6,6,2,2,6,6,14,14,0,0,12,12,0,0,8,8,0,0,6,6,14,14,8,8,4,4,9,9,13,13,4,4,1,1,2,2,0,0,9,9,13,13,6,6,11,11,15,15,5,5,9,9,9,9,4,4,12,12,12,12,6,6,0,0,15,15,8,8,11,11,11,11,15,15,6,6,4,4,10,10,2,2,1,1,4,4,5,5,10,10,10,10,9,9,5,5,1,1,7,7,1,1,12,12,2,2,0,0,1,1,2,2,4,4,8,8,10,10,12,12,14,14,0,0,8,8,8,8,5,5,5,5,14,14,15,15,9,9,0,0,4,4,12,12,2,2,5,5,2,2,9,9,7,7,5,5,14,14,0,0,5,5,7,7,0,0,14,14,7,7,9,9,0,0,0,0,8,8,8,8,2,2,13,13,2,2,12,12,5,5,3,3,11,11,3,3,8,8,9,9,4,4,14,14,2,2,8,8,10,10,1,1,13,13,6,6,10,10,13,13,11,11,10,10,1,1,7,7,4,4,9,9,9,9,13,13,3,3,15,15,2,2,7,7,4,4,13,13,11,11,14,14,3,3,0,0,8,8,3,3,6,6,13,13,8,8,12,12,10,10,2,2,3,3,0,0,14,14,1,1,1,1,6,6,2,2,5,5,11,11,6,6,7,7,0,0,11,11,1,1,1,1,9,9,8,8,7,7,11,11,8,8,12,12,9,9,3,3,15,15,11,11,8,8,0,0,2,2,5,5,8,8,3,3,11,11,9,9,8,8,3,3,15,15,0,0,0,0,3,3,1,1,2,2,2,2,0,0,1,1,3,3,1,1,10,10,12,12,5,5,4,4,2,2,7,7,8,8,1,1,4,4,10,10,2,2,1,1,3,3,9,9,2,2,7,7,7,7,6,6,6,6,15,15,5,5,4,4,15,15,15,15,8,8,8,8,6,6,4,4,0,0,8,8,14,14,6,6,2,2,14,14,2,2,12,12,7,7,10,10,2,2,3,3,10,10,3,3,0,0,13,13,0,0,6,6,12,12,1,1,7,7,0,0,5,5,11,11,8,8,9,9,5,5,2,2,12,12,1,1,11,11,7,7,0,0,12,12,3,3,1,1,2,2,8,8,7,7,12,12,6,6,13,13,6,6,4,4,5,5,14,14,12,12,3,3,13,13,6,6,2,2,9,9,8,8,12,12,5,5,3,3,13,13,9,9,13,13,11,11,15,15,14,14,6,6,9,9,4,4,13,13,5,5,14,14,1,1,2,2,0,0,3,3,14,14,14,14,10,10,3,3,12,12,1,1,14,14,14,14,1,1,14,14,5,5,14,14,14,14,12,12,10,10,6,6,11,11,4,4,12,12,15,15,4,4,2,2,5,5,8,8,15,15,14,14,7,7,5,5,5,5,5,5,13,13,13,13,2,2,14,14,10,10,15,15,3,3,10,10,11,11,10,10,3,3,14,14,9,9,10,10,10,10,4,4,3,3,10,10,11,11,11,11,1,1,3,3,3,3,2,2,1,1,1,1,10,10,6,6,0,0,14,14,6,6,4,4,1,1,2,2,1,1,9,9,10,10,7,7,14,14,11,11,3,3,0,0,7,7,9,9,3,3,5,5,6,6,5,5,14,14,15,15,8,8,9,9,15,15,1,1,3,3,4,4,8,8,9,9,12,12,1,1,5,5,4,4,2,2,5,5,9,9,7,7,11,11,11,11,6,6,13,13,9,9,0,0,0,0,4,4,8,8,2,2,12,12,7,7,14,14,10,10,4,4,13,13,2,2,4,4,2,2,11,11,4,4,7,7,7,7,14,14,13,13,8,8,0,0,1,1,4,4,4,4,0,0,7,7,8,8,2,2,5,5,9,9,12,12,4,4,15,15,11,11,2,2,15,15,2,2,10,10,11,11,11,11,0,0,4,4,6,6,3,3,3,3,10,10,15,15,8,8,11,11,1,1,13,13,15,15,14,14,15,15,9,9,0,0,14,14,2,2,4,4,9,9,5,5,4,4,15,15,5,5,6,6,10,10,2,2,0,0,6,6,11,11,4,4,10,10,10,10,2,2,2,2,5,5,0,0,11,11,2,2,13,13,4,4,9,9,8,8,10,10,14,14,2,2,11,11,14,14,0,0,3,3,10,10,13,13,4,4,8,8,2,2,15,15,3,3,8,8,5,5,12,12,13,13,15,15,15,15,6,6,0,0,10,10,0,0,14,14,8,8,7,7,3,3,2,2,0,0,6,6,10,10,11,11,4,4,14,14,2,2,5,5,0,0,9,9,9,9,0,0,0,0,6,6,15,15,5,5,11,11,10,10,4,4,12,12,5,5,0,0,8,8,0,0,11,11,2,2,5,5,3,3,13,13,13,13,15,15,14,14,2,2,1,1,6,6,15,15,0,0,14,14,1,1,5,5,2,2,1,1,9,9,9,9,2,2,7,7,14,14,11,11,0,0,6,6,13,13,3,3,6,6,2,2,6,6,1,1,0,0,6,6,9,9,7,7,15,15,4,4,12,12,5,5,0,0,2,2,3,3,2,2,9,9,9,9,0,0,8,8,13,13,3,3,13,13,9,9,11,11,5,5,2,2,14,14,1,1,6,6,11,11,6,6,10,10,10,10,14,14,13,13,11,11,3,3,9,9,7,7,9,9,8,8,13,13,6,6,14,14,15,15,14,14,4,4,6,6,6,6,4,4,8,8,5,5,15,15,14,14,2,2,1,1,2,2,3,3,8,8,9,9,0,0,14,14,9,9,13,13,4,4,8,8,2,2,6,6,15,15,1,1,1,1,11,11,0,0,8,8,14,14,3,3,5,5,15,15,8,8,14,14,13,13,3,3,15,15,15,15,2,2,1,1,8,8,9,9,13,13,11,11,12,12,12,12,15,15,13,13,14,14,12,12,4,4,6,6,9,9,12,12,6,6,5,5,4,4,1,1,11,11,14,14,0,0,6,6,0,0,12,12,4,4,2,2,2,2,6,6,13,13,3,3,11,11,3,3,5,5,11,11,2,2,8,8,13,13,1,1,13,13,6,6,10,10,6,6,7,7,4,4,15,15,9,9,2,2,1,1,6,6,1,1,3,3,8,8,2,2,2,2,7,7,14,14,6,6,4,4,5,5,12,12,8,8,8,8,11,11,6,6,11,11,0,0,1,1,7,7,0,0,15,15,15,15,1,1,15,15,13,13,12,12,3,3,2,2,15,15,12,12,10,10,2,2,10,10,10,10,12,12,7,7,13,13,10,10,11,11,2,2,8,8,8,8,8,8,8,8,5,5,12,12,0,0,10,10,5,5,9,9,0,0,0,0,7,7,9,9,0,0,15,15,9,9,2,2,11,11,2,2,8,8,4,4,14,14,13,13,2,2,13,13,1,1,9,9,13,13,9,9,4,4,8,8,10,10,3,3,1,1,1,1,12,12,7,7,0,0,5,5,13,13,2,2,4,4,12,12,12,12,0,0,15,15,10,10,8,8,15,15,10,10,11,11,4,4,11,11,4,4,11,11,15,15,3,3,1,1,4,4,0,0,7,7,12,12,6,6,8,8,9,9,8,8,2,2,6,6,13,13,5,5,3,3,10,10,0,0,2,2,4,4,3,3,3,3,0,0,4,4,11,11,2,2,2,2,0,0,4,4,2,2,10,10,5,5,11,11,4,4,7,7,0,0,13,13,11,11,7,7,6,6,4,4,9,9,0,0,2,2,11,11,12,12,2,2,15,15,10,10,3,3,11,11,5,5,15,15,0,0,10,10,8,8,11,11,6,6,9,9,8,8,0,0,15,15,6,6,8,8,12,12,8,8,9,9,14,14,8,8,7,7,7,7,13,13,8,8,15,15,8,8,0,0,10,10,12,12,4,4,3,3,9,9,4,4,9,9,12,12,2,2,9,9,11,11,8,8,15,15,7,7,11,11,3,3,10,10,7,7,14,14,15,15,15,15,6,6,6,6,8,8,4,4,0,0,3,3,8,8,11,11,14,14,4,4,15,15,12,12,3,3,5,5,10,10,0,0,7,7,13,13,12,12,14,14,8,8,11,11,0,0,2,2,7,7,7,7,8,8,14,14,5,5,3,3,1,1,5,5,7,7,3,3,0,0,15,15,10,10,15,15,4,4,9,9,8,8,10,10,1,1,4,4,3,3,11,11,9,9,12,12,4,4,8,8,11,11,2,2,13,13,6,6,15,15,9,9,5,5,12,12,14,14,8,8,1,1,11,11,0,0,2,2,5,5,0,0,15,15,4,4,6,6,5,5,15,15,6,6,11,11,12,12,5,5,14,14,11,11,12,12,4,4,9,9,0,0,8,8,0,0,5,5,9,9,12,12,1,1,1,1,1,1,14,14,10,10,11,11,9,9,8,8,9,9,1,1,9,9,2,2,3,3,11,11,3,3,2,2,2,2,7,7,0,0,1,1,5,5,2,2,12,12,10,10,2,2,4,4,2,2,1,1,0,0,8,8,9,9,14,14,4,4,1,1,2,2,13,13,12,12,7,7,12,12,8,8,1,1,5,5,9,9,6,6,0,0,12,12,2,2,9,9,12,12,11,11,10,10,0,0,1,1,1,1,13,13,1,1,5,5,10,10,2,2,12,12,8,8,3,3,2,2,13,13,8,8,9,9,6,6,9,9,3,3,6,6,5,5,10,10,11,11,14,14,6,6,6,6,4,4,4,4,11,11,5,5,9,9,6,6,11,11,10,10,5,5,8,8,12,12,6,6,1,1,6,6,12,12,7,7,6,6,9,9,15,15,3,3,7,7,5,5,15,15,0,0,8,8,14,14,4,4,0,0,13,13,9,9,6,6,15,15,2,2,5,5,8,8,11,11,6,6,8,8,2,2,8,8,3,3,6,6,0,0,2,2,10,10,4,4,9,9,4,4,12,12,8,8,7,7,0,0,11,11,13,13,4,4,14,14,7,7,8,8,7,7,10,10,8,8,3,3,9,9,13,13,8,8,10,10,11,11,9,9,10,10,0,0,10,10,5,5,15,15,1,1,4,4,15,15,11,11,4,4,6,6,4,4,0,0,14,14,1,1,1,1,0,0,9,9,4,4,8,8,8,8,13,13,9,9,5,5,14,14,8,8,7,7,4,4,0,0,14,14,1,1,13,13,2,2,9,9,4,4,1,1,7,7,7,7,8,8,15,15,1,1,5,5,12,12,2,2,0,0,12,12,9,9,9,9,8,8,2,2,8,8,0,0,4,4,5,5,7,7,8,8,3,3,15,15,14,14,0,0,2,2,6,6,10,10,7,7,2,2,10,10,5,5,15,15,5,5,2,2,12,12,8,8,11,11,11,11,3,3,15,15,12,12,8,8,3,3,4,4,7,7,7,7,11,11,9,9,12,12,1,1,2,2,14,14,10,10,14,14,8,8,15,15,12,12,10,10,7,7,2,2,0,0,13,13,14,14,10,10,12,12,14,14,7,7,3,3,6,6,8,8,2,2,1,1,9,9,0,0,2,2,9,9,15,15,8,8,13,13,12,12,9,9,10,10,13,13,4,4,12,12,13,13,3,3,9,9,13,13,12,12,9,9,2,2,0,0,1,1,12,12,10,10,2,2,11,11,6,6,12,12,13,13,0,0,6,6,4,4,3,3,0,0,8,8,4,4,15,15,12,12,1,1,2,2,6,6,4,4,1,1,5,5,4,4,0,0,9,9,14,14,1,1,8,8,8,8,13,13,11,11,9,9,0,0,6,6,2,2,15,15,15,15,5,5,11,11,4,4,1,1,0,0,3,3,11,11,14,14,6,6,0,0,3,3,0,0,7,7,14,14,14,14,0,0,6,6,2,2,9,9,2,2,13,13,15,15,9,9,8,8,0,0,0,0,15,15,8,8,5,5,13,13,10,10,10,10,3,3,15,15,11,11,5,5,0,0,13,13,14,14,1,1,0,0,6,6,11,11,6,6,15,15,15,15,1,1,3,3,2,2,3,3,13,13,10,10,0,0,10,10,1,1,12,12,5,5,8,8,6,6,10,10,11,11,13,13,14,14,8,8,14,14,2,2,11,11,0,0,8,8,13,13,6,6,0,0,7,7,4,4,12,12,11,11,8,8,8,8,0,0,6,6,4,4,0,0,7,7,0,0,6,6,9,9,10,10,2,2,11,11,5,5,9,9,0,0,15,15,1,1,1,1,9,9,12,12,10,10,11,11,15,15,10,10,7,7,1,1,15,15,12,12,5,5,4,4,1,1,7,7,3,3,6,6,8,8,5,5,14,14,0,0,11,11,14,14,12,12,9,9,2,2,2,2,5,5,8,8,0,0,3,3,4,4,11,11,7,7,6,6,1,1,7,7,2,2,14,14,8,8,8,8,11,11,7,7,0,0,9,9,15,15,2,2,0,0,11,11,1,1,2,2,4,4,3,3,6,6,1,1,4,4,7,7,10,10,6,6,10,10,7,7,0,0,15,15,3,3,12,12,10,10,4,4,5,5,0,0,3,3,9,9,13,13,6,6,7,7,4,4,5,5,14,14,11,11,0,0,13,13,9,9,1,1,13,13,9,9,9,9,14,14,9,9,8,8,5,5,15,15,4,4,5,5,12,12,4,4,9,9,13,13,0,0,14,14,2,2,15,15,1,1,4,4,2,2,9,9,14,14,1,1,13,13,14,14,7,7,0,0,6,6,13,13,13,13,10,10,1,1,12,12,14,14,7,7,3,3,6,6,3,3,1,1,10,10,3,3,2,2,9,9,9,9,6,6,0,0,4,4,8,8,2,2,5,5,15,15,10,10,15,15,9,9,0,0,10,10,2,2,2,2,14,14,0,0,4,4,5,5,14,14,5,5,2,2,10,10,2,2,5,5,8,8,9,9,5,5,2,2,3,3,4,4,4,4,11,11,1,1,5,5,6,6,12,12,10,10,4,4,1,1,9,9,10,10,14,14,12,12,3,3,5,5,14,14,2,2,11,11,5,5,12,12,6,6,6,6,6,6,4,4,11,11,11,11,7,7,4,4,11,11,8,8,4,4,8,8,3,3,8,8,0,0,6,6,2,2,1,1,11,11,14,14,12,12,5,5,12,12,11,11,5,5,9,9,15,15,15,15,12,12,14,14,7,7,11,11,14,14,4,4,14,14,1,1,8,8,8,8,13,13,1,1,3,3,7,7,12,12,2,2,0,0,3,3,0,0,14,14,14,14,13,13,4,4,4,4,8,8,9,9,0,0,15,15,5,5,14,14,4,4,12,12,14,14,13,13,5,5,10,10,2,2,14,14,7,7,14,14,1,1,14,14,5,5,2,2,8,8,15,15,0,0,2,2,12,12,8,8,0,0,3,3,1,1,11,11,6,6,11,11,10,10,2,2,2,2,5,5,9,9,7,7,1,1,1,1,10,10,11,11,4,4,15,15,4,4,10,10,3,3,7,7,4,4,12,12,11,11,6,6,7,7,13,13,2,2,1,1,0,0,5,5,5,5,8,8,3,3,9,9,2,2,11,11,13,13,2,2,5,5,2,2,9,9,8,8,5,5,4,4,7,7,3,3,5,5,6,6,15,15,15,15,1,1,3,3,14,14,8,8,7,7,13,13,15,15,11,11,6,6,1,1,1,1,5,5,14,14,1,1,13,13,0,0,8,8,1,1,5,5,10,10,4,4,4,4,8,8,6,6,2,2,13,13,1,1,13,13,12,12,8,8,10,10,10,10,0,0,15,15,12,12,7,7,6,6,5,5,4,4,1,1,14,14,1,1,9,9,12,12,7,7,1,1,3,3,10,10,13,13,6,6,9,9,14,14,4,4,8,8,11,11,4,4,14,14,2,2,15,15,7,7,11,11,10,10,0,0,12,12,11,11,1,1,7,7,11,11,8,8,14,14,9,9,10,10,2,2,11,11,10,10,2,2,13,13,15,15,13,13,14,14,14,14,4,4,5,5,2,2,3,3,1,1,9,9,3,3,3,3,0,0,8,8,6,6,6,6,5,5,10,10,3,3,5,5,4,4,5,5,7,7,7,7,15,15,10,10,15,15,2,2,8,8,0,0,8,8,6,6,5,5,15,15,0,0,9,9,7,7,11,11,13,13,9,9,9,9,5,5,11,11,10,10,10,10,11,11,0,0,1,1,13,13,9,9,1,1,5,5,2,2,7,7,13,13,4,4,8,8,2,2,11,11,15,15,14,14,11,11,13,13,14,14,5,5,7,7,5,5,13,13,0,0,1,1,5,5,5,5,12,12,10,10,1,1,2,2,8,8,4,4,2,2,7,7,8,8,7,7,6,6,4,4,15,15,7,7,8,8,4,4,3,3,9,9,0,0,6,6,9,9,11,11,14,14,1,1,0,0,6,6,1,1,4,4,9,9,12,12,8,8,3,3,14,14,9,9,1,1,5,5,7,7,1,1,3,3,4,4,7,7,9,9,4,4,6,6,1,1,6,6,0,0,2,2,0,0,3,3,4,4,3,3,13,13,1,1,6,6,13,13,13,13,14,14,2,2,10,10,15,15,11,11,11,11,14,14,3,3,2,2,0,0,13,13,4,4,2,2,6,6,0,0,1,1,0,0,9,9,7,7,2,2,11,11,7,7,4,4,9,9,8,8,5,5,6,6,12,12,6,6,7,7,12,12,7,7,14,14,4,4,14,14,8,8,9,9,0,0,10,10,12,12,3,3,6,6,12,12,9,9,12,12,4,4,11,11,0,0,9,9,8,8,10,10,1,1,5,5,14,14,1,1,4,4,13,13,15,15,6,6,14,14,7,7,5,5,11,11,12,12,6,6,13,13,9,9,10,10,15,15,11,11,0,0,12,12,10,10,2,2,14,14,6,6,5,5,1,1,14,14,11,11,9,9,6,6,8,8,12,12,7,7,5,5,12,12,4,4,10,10,14,14,3,3,6,6,12,12,5,5,5,5,13,13,6,6,6,6,12,12,4,4,8,8,14,14,1,1,12,12,8,8,8,8,13,13,11,11,5,5,4,4,12,12,3,3,0,0,11,11,1,1,11,11,0,0,9,9,5,5,15,15,2,2,14,14,5,5,5,5,8,8,7,7,0,0,5,5,14,14,3,3,3,3,11,11,14,14,14,14,10,10,10,10,0,0,5,5,2,2,4,4,8,8,2,2,1,1,4,4,3,3,11,11,8,8,4,4,10,10,0,0,4,4,1,1,10,10,3,3,2,2,10,10,8,8,6,6,10,10,2,2,11,11,11,11,14,14,5,5,0,0,5,5,6,6,4,4,14,14,13,13,6,6,13,13,0,0,15,15,3,3,15,15,8,8,2,2,7,7,9,9,2,2,13,13,13,13,5,5,6,6,13,13,8,8,2,2,10,10,0,0,2,2,6,6,3,3,1,1,1,1,9,9,1,1,1,1,0,0,11,11,4,4,2,2,12,12,4,4,2,2,15,15,3,3,4,4,2,2,15,15,11,11,13,13,5,5,10,10,15,15,4,4,3,3,9,9,8,8,1,1,12,12,0,0,10,10,15,15,6,6,11,11,0,0,12,12,2,2,3,3,12,12,7,7,6,6,14,14,14,14,1,1,1,1,1,1,7,7,3,3,5,5,5,5,5,5,2,2,15,15,4,4,11,11,11,11,8,8,5,5,10,10,8,8,0,0,5,5,13,13,0,0,3,3,13,13,15,15,9,9,5,5,3,3,1,1,10,10,8,8,13,13,7,7,0,0,3,3,11,11,4,4,5,5,6,6,0,0,3,3,7,7,11,11,4,4,9,9,1,1,6,6,4,4,7,7,9,9,10,10,4,4,8,8,2,2,6,6,3,3,11,11,14,14,11,11,4,4,0,0,0,0,7,7,6,6,2,2,7,7,13,13,0,0,12,12,14,14,0,0,10,10,12,12,9,9,12,12,11,11,9,9,12,12,6,6,14,14,3,3,3,3,12,12,7,7,4,4,8,8,8,8,4,4,13,13,5,5,7,7,4,4,7,7,9,9,15,15,9,9,11,11,9,9,6,6,7,7,5,5,14,14,4,4,11,11,5,5,8,8,4,4,5,5,11,11,0,0,1,1,15,15,15,15,3,3,5,5,12,12,10,10,3,3,7,7,5,5,6,6,6,6,15,15,2,2,7,7,13,13,14,14,15,15,10,10,15,15,8,8,8,8,13,13,2,2,4,4,6,6,12,12,6,6,13,13,12,12,1,1,7,7,8,8,12,12,9,9,2,2,3,3,13,13,3,3,11,11,6,6,0,0,2,2,12,12,6,6,2,2,1,1,0,0,3,3,14,14,5,5,15,15,9,9,6,6,4,4,0,0,11,11,11,11,1,1,13,13,13,13,15,15,12,12,3,3,4,4,13,13,9,9,12,12,6,6,9,9,10,10,6,6,14,14,10,10,3,3,6,6,1,1,9,9,0,0,10,10,14,14,9,9,7,7,0,0,7,7,3,3,3,3,3,3,11,11,5,5,2,2,0,0,13,13,8,8,12,12,10,10,1,1,10,10,1,1,15,15,6,6,11,11,1,1,8,8,6,6,2,2,1,1,3,3,1,1,5,5,0,0,0,0,12,12,2,2,5,5,15,15,7,7,3,3,13,13,14,14,12,12,3,3,11,11,9,9,12,12,4,4,6,6,4,4,5,5,9,9,11,11,9,9,15,15,7,7,13,13,0,0,8,8,9,9,3,3,6,6,9,9,1,1,3,3,15,15,5,5,13,13,3,3,5,5,11,11,15,15,1,1,5,5,3,3,1,1,8,8,6,6,13,13,7,7,14,14,13,13,10,10,0,0,11,11,4,4,11,11,3,3,3,3,4,4,6,6,4,4,13,13,3,3,0,0,12,12,11,11,7,7,8,8,14,14,14,14,11,11,5,5,14,14,1,1,14,14,9,9,3,3,11,11,5,5,6,6,2,2,7,7,6,6,14,14,2,2,9,9,13,13,5,5,10,10,13,13,10,10,1,1,8,8,9,9,7,7,12,12,1,1,5,5,7,7,0,0,11,11,0,0,14,14,2,2,1,1,9,9,6,6,13,13,2,2,14,14,15,15,12,12,2,2,4,4,3,3,6,6,9,9,13,13,12,12,8,8,0,0,15,15,3,3,6,6,9,9,12,12,4,4,1,1,12,12,6,6,4,4,0,0,2,2,12,12,2,2,8,8,10,10,6,6,3,3,15,15,14,14,1,1,5,5,13,13,14,14,3,3,2,2,14,14,1,1,12,12,3,3,7,7,11,11,9,9,8,8,8,8,2,2,9,9,3,3,8,8,12,12,12,12,7,7,0,0,10,10,8,8,10,10,9,9,4,4,8,8,7,7,12,12,1,1,7,7,7,7,1,1,8,8,3,3,5,5,11,11,6,6,10,10,8,8,8,8,9,9,14,14,8,8,4,4,6,6,5,5,12,12,13,13,4,4,11,11,9,9,12,12,14,14,12,12,11,11,7,7,3,3,4,4,15,15,1,1,9,9,0,0,4,4,11,11,4,4,0,0,15,15,2,2,4,4,12,12,6,6,15,15,11,11,3,3,6,6,11,11,7,7,0,0,3,3,2,2,6,6,2,2,0,0,3,3,7,7,5,5,9,9,9,9,15,15,11,11,8,8,12,12,5,5,13,13,12,12,6,6,10,10,14,14,11,11,7,7,3,3,4,4,1,1,8,8,2,2,0,0,6,6,11,11,11,11,4,4,9,9,14,14,4,4,0,0,10,10,9,9,14,14,12,12,14,14,2,2,3,3,6,6,15,15,9,9,0,0,7,7,14,14,2,2,9,9,5,5,3,3,3,3,2,2,15,15,7,7,10,10,6,6,5,5,0,0,7,7,0,0,7,7,13,13,6,6,15,15,11,11,13,13,15,15,11,11,4,4,3,3,1,1,1,1,5,5,3,3,5,5,14,14,2,2,0,0,7,7,12,12,11,11,12,12,2,2,4,4,5,5,3,3,9,9,10,10,14,14,12,12,11,11,5,5,9,9,1,1,0,0,14,14,13,13,7,7,14,14,0,0,8,8,0,0,13,13,1,1,14,14,12,12,13,13,1,1,10,10,4,4,4,4,8,8,8,8,11,11,10,10,4,4,9,9,13,13,4,4,14,14,15,15,10,10,1,1,3,3,10,10,9,9,7,7,6,6,11,11,5,5,3,3,1,1,13,13,11,11,6,6,4,4,5,5,0,0,12,12,13,13,0,0,3,3,8,8,13,13,10,10,5,5,8,8,10,10,8,8,2,2,5,5,5,5,1,1,6,6,12,12,8,8,3,3,13,13,9,9,7,7,6,6,13,13,3,3,14,14,0,0,5,5,7,7,3,3,12,12,7,7,3,3,6,6,3,3,8,8,10,10,5,5,1,1,0,0,13,13,1,1,7,7,9,9,15,15,8,8,8,8,14,14,14,14,6,6,0,0,9,9,11,11,12,12,1,1,7,7,12,12,8,8,1,1,6,6,7,7,7,7,9,9,4,4,15,15,0,0,13,13,15,15,9,9,5,5,14,14,8,8,2,2,5,5,5,5,5,5,14,14,1,1,0,0,10,10,0,0,12,12,2,2,14,14,12,12,8,8,3,3,10,10,2,2,0,0,7,7,0,0,8,8,8,8,7,7,2,2,0,0,4,4,13,13,7,7,12,12,0,0,11,11,14,14,3,3,6,6,7,7,4,4,11,11,13,13,15,15,2,2,0,0,3,3,14,14,2,2,1,1,4,4,0,0,7,7,0,0,1,1,8,8,12,12,3,3,4,4,10,10,12,12,0,0,13,13,4,4,8,8,6,6,10,10,9,9,13,13,6,6,15,15,7,7,6,6,6,6,1,1,0,0,8,8,11,11,0,0,5,5,5,5,6,6,1,1,8,8,15,15,12,12,11,11,8,8,2,2,9,9,12,12,1,1,14,14,2,2,9,9,10,10,3,3,10,10,8,8,2,2,12,12,1,1,5,5,0,0,12,12,7,7,2,2,14,14,12,12,9,9,3,3,5,5,2,2,9,9,3,3,13,13,13,13,15,15,2,2,11,11,7,7,14,14,10,10,9,9,2,2,3,3,8,8,2,2,1,1,9,9,5,5,13,13,1,1,1,1,2,2,1,1,12,12,10,10,7,7,9,9,1,1,14,14,6,6,15,15,6,6,1,1,9,9,11,11,3,3,9,9,13,13,13,13,6,6,10,10,6,6,15,15,10,10,5,5,5,5,3,3,1,1,13,13,7,7,2,2,4,4,2,2,12,12,1,1,14,14,6,6,7,7,3,3,2,2,3,3,2,2,0,0,3,3,15,15,1,1,2,2,10,10,4,4,7,7,5,5,1,1,0,0,6,6,8,8,10,10,9,9,9,9,3,3,5,5,7,7,15,15,1,1,15,15,13,13,8,8,5,5,4,4,12,12,4,4,10,10,7,7,11,11,0,0,13,13,12,12,5,5,0,0,12,12,4,4,10,10,7,7,11,11,4,4,0,0,0,0,15,15,7,7,9,9,10,10,12,12,15,15,3,3,13,13,11,11,15,15,13,13,7,7,5,5,2,2,2,2,7,7,2,2,11,11,7,7,6,6,2,2,0,0,7,7,3,3,3,3,8,8,12,12,13,13,10,10,6,6,2,2,8,8,10,10,2,2,3,3,2,2,14,14,0,0,1,1,8,8,9,9,6,6,1,1,6,6,8,8,1,1,11,11,3,3,12,12,8,8,11,11,11,11,8,8,2,2,7,7,13,13,14,14,2,2,0,0,0,0,8,8,3,3,12,12,3,3,0,0,12,12,8,8,4,4,6,6,1,1,12,12,2,2,5,5,9,9,9,9,0,0,4,4,2,2,1,1,7,7,1,1,15,15,10,10,12,12,5,5,8,8,5,5,7,7,6,6,14,14,2,2,6,6,5,5,12,12,1,1,13,13,14,14,9,9,10,10,3,3,10,10,4,4,13,13,11,11,6,6,14,14,2,2,2,2,3,3,8,8,5,5,7,7,14,14,14,14,5,5,9,9,7,7,11,11,2,2,7,7,10,10,2,2,7,7,3,3,9,9,14,14,8,8,15,15,15,15,0,0,10,10,5,5,6,6,4,4,0,0,2,2,1,1,4,4,15,15,10,10,14,14,0,0,6,6,11,11,12,12,7,7,6,6,11,11,1,1,3,3,8,8,15,15,14,14,3,3,4,4,4,4,14,14,10,10,4,4,5,5,2,2,12,12,8,8,10,10,13,13,14,14,14,14,3,3,10,10,8,8,8,8,0,0,9,9,3,3,9,9,10,10,0,0,14,14,10,10,0,0,6,6,7,7,13,13,9,9,3,3,2,2,9,9,5,5,6,6,5,5,14,14,15,15,10,10,3,3,5,5,7,7,1,1,2,2,10,10,10,10,12,12,2,2,10,10,12,12,12,12,7,7,13,13,4,4,7,7,5,5,4,4,1,1,13,13,10,10,5,5,4,4,4,4,12,12,9,9,12,12,12,12,3,3,7,7,3,3,1,1,0,0,9,9,4,4,8,8,2,2,10,10,4,4,8,8,5,5,3,3,9,9,2,2,13,13,13,13,9,9,15,15,1,1,3,3,0,0,9,9,2,2,11,11,6,6,14,14,15,15,0,0,3,3,0,0,14,14,6,6,0,0,5,5,9,9,3,3,8,8,9,9,12,12,11,11,1,1,8,8,13,13,9,9,10,10,13,13,10,10,15,15,3,3,0,0,15,15,0,0,11,11,8,8,15,15,8,8,8,8,6,6,0,0,4,4,8,8,7,7,7,7,8,8,8,8,14,14,15,15,7,7,4,4,0,0,5,5,15,15,9,9,4,4,7,7,8,8,2,2,7,7,8,8,4,4,3,3,10,10,12,12,1,1,13,13,14,14,4,4,10,10,2,2,2,2,1,1,1,1,10,10,11,11,3,3,11,11,1,1,2,2,3,3,10,10,13,13,7,7,2,2,4,4,12,12,0,0,11,11,0,0,5,5,1,1,11,11,12,12,10,10,13,13,7,7,6,6,11,11,12,12,6,6,0,0,0,0,14,14,1,1,5,5,6,6,9,9,12,12,10,10,8,8,9,9,9,9,11,11,3,3,12,12,0,0,11,11,5,5,1,1,13,13,5,5,0,0,0,0,4,4,2,2,0,0,2,2,14,14,4,4,0,0,4,4,10,10,0,0,0,0,2,2,0,0,2,2,2,2,11,11,13,13,4,4,6,6,4,4,14,14,9,9,14,14,12,12,8,8,8,8,11,11,11,11,11,11,12,12,4,4,14,14,13,13,1,1,10,10,11,11,2,2,8,8,10,10,2,2,6,6,3,3,11,11,9,9,7,7,9,9,9,9,10,10,5,5,4,4,7,7,1,1,0,0,14,14,0,0,4,4,0,0,10,10,2,2,0,0,8,8,4,4,1,1,0,0,12,12,7,7,13,13,1,1,15,15,4,4,10,10,5,5,8,8,15,15,2,2,9,9,4,4,12,12,3,3,2,2,6,6,9,9,12,12,3,3,7,7,9,9,11,11,3,3,5,5,2,2,0,0,1,1,6,6,10,10,14,14,7,7,0,0,0,0,11,11,13,13,11,11,2,2,9,9,1,1,4,4,14,14,1,1,10,10,5,5,0,0,2,2,9,9,9,9,12,12,14,14,0,0,15,15,6,6,10,10,5,5,15,15,12,12,3,3,0,0,8,8,3,3,12,12,5,5,7,7,2,2,5,5,14,14,12,12,0,0,4,4,11,11,10,10,2,2,2,2,11,11,8,8,4,4,12,12,3,3,10,10,0,0,2,2,1,1,2,2,14,14,6,6,0,0,4,4,5,5,12,12,15,15,12,12,9,9,2,2,1,1,3,3,10,10,3,3,4,4,0,0,7,7,4,4,7,7,4,4,1,1,11,11,5,5,7,7,3,3,5,5,7,7,4,4,14,14,13,13,5,5,13,13,2,2,11,11,13,13,10,10,13,13,7,7,1,1,9,9,2,2,4,4,12,12,15,15,14,14,10,10,6,6,11,11,12,12,13,13,10,10,15,15,8,8,2,2,8,8,10,10,15,15,4,4,10,10,14,14,0,0,10,10,14,14,15,15,4,4,15,15,7,7,5,5,4,4,4,4,1,1,4,4,6,6,12,12,4,4,2,2,13,13,5,5,12,12,15,15,2,2,1,1,0,0,0,0,5,5,4,4,5,5,12,12,11,11,9,9,2,2,1,1,14,14,2,2,6,6,13,13,3,3,9,9,0,0,3,3,5,5,0,0,3,3,6,6,14,14,10,10,14,14,10,10,0,0,11,11,5,5,8,8,2,2,12,12,3,3,3,3,1,1,6,6,15,15,11,11,11,11,0,0,3,3,10,10,14,14,2,2,10,10,13,13,15,15,6,6,8,8,14,14,2,2,15,15,15,15,0,0,7,7,5,5,4,4,12,12,14,14,3,3,12,12,0,0,10,10,0,0,7,7,8,8,14,14,13,13,0,0,10,10,12,12,0,0,3,3,5,5,5,5,9,9,0,0,4,4,3,3,6,6,0,0,6,6,12,12,9,9,6,6,9,9,12,12,1,1,5,5,10,10,9,9,0,0,5,5,0,0,5,5,14,14,4,4,5,5,4,4,11,11,3,3,13,13,5,5,7,7,11,11,13,13,15,15,14,14,15,15,14,14,6,6,8,8,1,1,11,11,4,4,9,9,5,5,4,4,6,6,13,13,14,14,7,7,1,1,8,8,1,1,0,0,2,2,4,4,5,5,12,12,3,3,6,6,9,9,12,12,2,2,5,5,8,8,7,7,11,11,4,4,5,5,7,7,12,12,9,9,13,13,0,0,0,0,6,6,13,13,14,14,12,12,14,14,11,11,12,12,6,6,4,4,3,3,4,4,11,11,1,1,6,6,9,9,0,0,14,14,15,15,5,5,5,5,4,4,12,12,9,9,2,2,15,15,9,9,12,12,11,11,2,2,1,1,9,9,14,14,13,13,12,12,7,7,10,10,1,1,2,2,12,12,11,11,11,11,12,12,11,11,6,6,15,15,10,10,8,8,12,12,3,3,1,1,4,4,5,5,12,12,7,7,0,0,3,3,5,5,6,6,4,4,7,7,13,13,9,9,2,2,10,10,5,5,4,4,2,2,10,10,2,2,3,3,8,8,5,5,1,1,15,15,3,3,5,5,13,13,7,7,12,12,6,6,8,8,15,15,6,6,15,15,13,13,9,9,1,1,13,13,11,11,13,13,8,8,10,10,15,15,10,10,12,12,2,2,15,15,3,3,9,9,12,12,0,0,9,9,5,5,3,3,4,4,11,11,4,4,0,0,1,1,4,4,6,6,7,7,0,0,14,14,1,1,5,5,4,4,4,4,10,10,5,5,15,15,0,0,9,9,1,1,1,1,14,14,13,13,8,8,14,14,5,5,12,12,4,4,9,9,10,10,8,8,9,9,4,4,1,1,1,1,12,12,12,12,7,7,8,8,3,3,0,0,13,13,2,2,12,12,0,0,15,15,15,15,8,8,14,14,6,6,5,5,10,10,1,1,12,12,1,1,0,0,10,10,4,4,7,7,2,2,15,15,3,3,12,12,10,10,14,14,11,11,11,11,7,7,3,3,0,0,9,9,2,2,6,6,2,2,0,0,6,6,8,8,0,0,0,0,13,13,8,8,6,6,12,12,10,10,11,11,14,14,1,1,10,10,6,6,1,1,3,3,15,15,1,1,1,1,2,2,7,7,15,15,0,0,7,7,11,11,1,1,7,7,4,4,7,7,7,7,15,15,0,0,13,13,5,5,4,4,0,0,7,7,13,13,3,3,9,9,4,4,10,10,9,9,5,5,7,7,15,15,12,12,12,12,2,2,5,5,4,4,10,10,8,8,2,2,11,11,0,0,11,11,12,12,1,1,5,5,8,8,6,6,13,13,4,4,11,11,12,12,6,6,4,4,3,3,6,6,13,13,5,5,2,2,9,9,0,0,2,2,2,2,11,11,9,9,8,8,11,11,8,8,12,12,11,11,3,3,11,11,1,1,3,3,10,10,2,2,3,3,6,6,1,1,3,3,8,8,6,6,3,3,14,14,10,10,7,7,2,2,4,4,13,13,13,13,15,15,5,5,2,2,10,10,2,2,14,14,12,12,8,8,4,4,1,1,5,5,14,14,5,5,6,6,9,9,9,9,13,13,1,1,0,0,7,7,7,7,14,14,1,1,3,3,4,4,6,6,0,0,1,1,13,13,14,14,0,0,0,0,9,9,1,1,8,8,4,4,10,10,2,2,0,0,13,13,0,0,0,0,6,6,6,6,6,6,5,5,9,9,8,8,14,14,3,3,3,3,2,2,0,0,8,8,13,13,5,5,4,4,3,3,13,13,1,1,6,6,5,5,14,14,12,12,4,4,7,7,5,5,3,3,2,2,14,14,8,8,6,6,4,4,14,14,11,11,10,10,2,2,14,14,9,9,9,9,1,1,1,1,2,2,7,7,8,8,3,3,14,14,13,13,8,8,11,11,13,13,8,8,13,13,10,10,4,4,13,13,14,14,9,9,1,1,5,5,13,13,15,15,14,14,12,12,10,10,7,7,8,8,7,7,0,0,8,8,15,15,3,3,0,0,10,10,6,6,5,5,15,15,1,1,14,14,5,5,13,13,5,5,2,2,9,9,10,10,6,6,9,9,12,12,7,7,7,7,2,2,11,11,12,12,5,5,3,3,12,12,2,2,4,4,2,2,8,8,9,9,1,1,4,4,11,11,13,13,0,0,0,0,6,6,1,1,1,1,6,6,7,7,13,13,10,10,3,3,11,11,8,8,7,7,3,3,3,3,3,3,10,10,8,8,7,7,1,1,4,4,13,13,4,4,6,6,9,9,4,4,0,0,12,12,10,10,10,10,3,3,7,7,12,12,0,0,9,9,10,10,7,7,12,12,4,4,11,11,12,12,9,9,10,10,8,8,11,11,4,4,15,15,0,0,5,5,1,1,15,15,3,3,8,8,9,9,2,2,2,2,8,8,10,10,10,10,10,10,8,8,11,11,11,11,14,14,2,2,7,7,10,10,14,14,0,0,13,13,3,3,7,7,10,10,14,14,3,3,15,15,8,8,8,8,4,4,2,2,4,4,1,1,13,13,7,7,5,5,12,12,9,9,0,0,5,5,13,13,12,12,15,15,8,8,14,14,7,7,13,13,0,0,12,12,11,11,13,13,9,9,3,3,9,9,8,8,0,0,1,1,0,0,2,2,15,15,10,10,2,2,6,6,7,7,3,3,5,5,7,7,0,0,1,1,9,9,3,3,8,8,5,5,5,5,2,2,10,10,2,2,11,11,11,11,15,15,3,3,1,1,3,3,10,10,12,12,7,7,4,4,5,5,0,0,3,3,11,11,0,0,4,4,5,5,2,2,1,1,6,6,9,9,3,3,0,0,11,11,8,8,3,3,2,2,8,8,8,8,6,6,7,7,10,10,11,11,8,8,7,7,2,2,4,4,1,1,11,11,8,8,3,3,8,8,15,15,7,7,11,11,1,1,2,2,11,11,9,9,7,7,6,6,4,4,3,3,13,13,13,13,5,5,15,15,12,12,4,4,7,7,11,11,12,12,0,0,13,13,0,0,3,3,0,0,10,10,1,1,7,7,12,12,14,14,8,8,4,4,6,6,4,4,6,6,10,10,2,2,4,4,8,8,8,8,1,1,4,4,3,3,12,12,2,2,9,9,14,14,12,12,10,10,15,15,0,0,9,9,8,8,1,1,7,7,15,15,13,13,10,10,1,1,0,0,10,10,10,10,3,3,13,13,0,0,13,13,1,1,11,11,2,2,2,2,7,7,11,11,11,11,4,4,1,1,7,7,4,4,14,14,6,6,13,13,11,11,14,14,5,5,7,7,2,2,12,12,12,12,5,5,1,1,13,13,8,8,13,13,8,8,13,13,3,3,0,0,8,8,1,1,0,0,6,6,7,7,5,5,4,4,2,2,10,10,2,2,10,10,4,4,7,7,7,7,10,10,2,2,10,10,9,9,2,2,10,10,9,9,1,1,7,7,14,14,5,5,2,2,2,2,1,1,2,2,11,11,7,7,10,10,1,1,6,6,3,3,0,0,2,2,3,3,6,6,6,6,2,2,8,8,5,5,4,4,0,0,10,10,6,6,5,5,2,2,10,10,6,6,14,14,1,1,14,14,0,0,0,0,9,9,2,2,11,11,8,8,5,5,9,9,4,4,11,11,4,4,12,12,8,8,0,0,3,3,0,0,11,11,4,4,11,11,11,11,6,6,2,2,14,14,1,1,4,4,11,11,4,4,3,3,15,15,0,0,14,14,5,5,8,8,14,14,8,8,2,2,13,13,6,6,11,11,10,10,2,2,9,9,9,9,8,8,13,13,15,15,2,2,12,12,6,6,6,6,7,7,9,9,15,15,12,12,0,0,5,5,5,5,3,3,14,14,10,10,14,14,1,1,5,5,14,14,0,0,0,0,8,8,11,11,11,11,0,0,9,9,6,6,9,9,3,3,4,4,5,5,5,5,4,4,14,14,1,1,4,4,5,5,15,15,13,13,6,6,12,12,9,9,2,2,12,12,8,8,9,9,14,14,1,1,15,15,9,9,2,2,6,6,12,12,14,14,1,1,5,5,4,4,9,9,14,14,9,9,0,0,2,2,4,4,12,12,5,5,13,13,5,5,8,8,2,2,9,9,8,8,1,1,13,13,5,5,1,1,10,10,8,8,12,12,5,5,12,12,7,7,15,15,6,6,3,3,6,6,8,8,2,2,15,15,6,6,15,15,6,6,8,8,14,14,11,11,7,7,5,5,4,4,7,7,6,6,3,3,3,3,2,2,1,1,10,10,9,9,12,12,5,5,5,5,13,13,14,14,13,13,0,0,9,9,1,1,11,11,10,10,8,8,7,7,10,10,2,2,12,12,11,11,15,15,2,2,12,12,8,8,1,1,12,12,6,6,4,4,1,1,10,10,12,12,9,9,8,8,3,3,3,3,2,2,10,10,13,13,0,0,0,0,4,4,5,5,4,4,3,3,8,8,10,10,15,15,13,13,5,5,15,15,0,0,2,2,3,3,11,11,14,14,9,9,4,4,10,10,1,1,9,9,14,14,13,13,2,2,14,14,12,12,2,2,0,0,11,11,5,5,4,4,4,4,14,14,3,3,8,8,14,14,9,9,9,9,9,9,13,13,13,13,12,12,13,13,2,2,4,4,3,3,0,0,14,14,5,5,9,9,6,6,9,9,5,5,0,0,2,2,13,13,5,5,6,6,10,10,10,10,12,12,7,7,13,13,2,2,1,1,8,8,10,10,2,2,12,12,3,3,11,11,6,6,2,2,10,10,4,4,14,14,0,0,0,0,14,14,5,5,1,1,3,3,5,5,3,3,6,6,14,14,15,15,4,4,7,7,0,0,3,3,2,2,12,12,13,13,8,8,10,10,2,2,3,3,1,1,12,12,0,0,6,6,4,4,9,9,4,4,12,12,10,10,8,8,5,5,15,15,10,10,10,10,14,14,3,3,10,10,1,1,12,12,11,11,14,14,13,13,3,3,7,7,1,1,2,2,12,12,5,5,13,13,14,14,3,3,11,11,14,14,6,6,13,13,15,15,0,0,3,3,1,1,4,4,11,11,10,10,9,9,7,7,2,2,1,1,0,0,7,7,14,14,14,14,15,15,15,15,7,7,9,9,7,7,8,8,13,13,0,0,13,13,1,1,10,10,10,10,15,15,2,2,7,7,11,11,9,9,0,0,8,8,5,5,10,10,3,3,3,3,4,4,1,1,4,4,8,8,14,14,10,10,5,5,10,10,11,11,13,13,0,0,3,3,0,0,10,10,1,1,13,13,9,9,4,4,5,5,15,15,12,12,0,0,5,5,9,9,8,8,9,9,7,7,3,3,2,2,11,11,10,10,8,8,12,12,14,14,6,6,7,7,14,14,14,14,4,4,15,15,2,2,1,1,14,14,2,2,12,12,13,13,8,8,8,8,11,11,4,4,6,6,1,1,1,1,5,5,6,6,12,12,8,8,9,9,2,2,15,15,15,15,5,5,6,6,4,4,4,4,15,15,3,3,5,5,3,3,11,11,4,4,7,7,10,10,8,8,8,8,3,3,7,7,6,6,11,11,4,4,3,3,1,1,1,1,7,7,1,1,2,2,9,9,9,9,12,12,5,5,11,11,13,13,3,3,15,15,6,6,7,7,3,3,12,12,1,1,15,15,5,5,13,13,13,13,4,4,1,1,10,10,9,9,14,14,10,10,4,4,9,9,5,5,10,10,1,1,5,5,2,2,3,3,5,5,14,14,8,8,12,12,0,0,9,9,7,7,6,6,0,0,1,1,3,3,1,1,10,10,11,11,11,11,12,12,8,8,14,14,9,9,7,7,7,7,9,9,1,1,6,6,8,8,5,5,11,11,13,13,5,5,1,1,14,14,4,4,4,4,1,1,10,10,15,15,1,1,3,3,6,6,9,9,4,4,1,1,2,2,9,9,11,11,14,14,0,0,2,2,11,11,8,8,7,7,4,4,9,9,2,2,1,1,6,6,0,0,7,7,3,3,0,0,11,11,5,5,0,0,4,4,5,5,8,8,2,2,14,14,0,0,14,14,5,5,7,7,14,14,3,3,10,10,0,0,11,11,1,1,14,14,2,2,11,11,0,0,10,10,7,7,15,15,5,5,1,1,4,4,8,8,12,12,1,1,8,8,6,6,3,3,13,13,6,6,11,11,5,5,0,0,1,1,3,3,3,3,10,10,0,0,12,12,3,3,6,6,4,4,10,10,4,4,8,8,15,15,3,3,0,0,11,11,12,12,11,11,0,0,8,8,6,6,6,6,6,6,7,7,8,8,0,0,15,15,2,2,7,7,1,1,5,5,15,15,7,7,5,5,6,6,1,1,6,6,14,14,14,14,11,11,14,14,1,1,11,11,8,8,5,5,7,7,3,3,14,14,11,11,5,5,12,12,7,7,1,1,12,12,9,9,5,5,13,13,2,2,12,12,6,6,14,14,0,0,1,1,8,8,1,1,12,12,8,8,1,1,5,5,5,5,8,8,4,4,5,5,6,6,2,2,1,1,12,12,8,8,2,2,2,2,15,15,15,15,1,1,4,4,0,0,4,4,2,2,14,14,14,14,10,10,13,13,3,3,10,10,4,4,4,4,6,6,6,6,9,9,2,2,0,0,9,9,15,15,9,9,7,7,0,0,2,2,9,9,3,3,6,6,14,14,10,10,10,10,9,9,4,4,2,2,15,15,13,13,3,3,7,7,6,6,11,11,11,11,2,2,6,6,2,2,11,11,0,0,2,2,11,11,13,13,8,8,2,2,15,15,8,8,9,9,3,3,0,0,11,11,3,3,12,12,10,10,8,8,1,1,13,13,8,8,0,0,6,6,1,1,8,8,12,12,1,1,14,14,0,0,0,0,5,5,13,13,7,7,7,7,15,15,0,0,3,3,10,10,1,1,2,2,9,9,5,5,4,4,14,14,9,9,6,6,15,15,11,11,5,5,7,7,8,8,1,1,9,9,8,8,1,1,10,10,3,3,3,3,5,5,4,4,0,0,14,14,4,4,14,14,8,8,8,8,2,2,2,2,7,7,4,4,11,11,14,14,1,1,12,12,3,3,3,3,10,10,8,8,12,12,9,9,1,1,0,0,15,15,15,15,9,9,10,10,2,2,11,11,4,4,5,5,5,5,7,7,5,5,0,0,11,11,4,4,12,12,7,7,9,9,9,9,3,3,12,12,12,12,1,1,8,8,9,9,12,12,0,0,13,13,8,8,1,1,1,1,7,7,11,11,10,10,9,9,13,13,12,12,13,13,11,11,15,15,7,7,13,13,9,9,0,0,14,14,5,5,4,4,5,5,2,2,8,8,13,13,6,6,1,1,11,11,4,4,14,14,13,13,9,9,1,1,8,8,10,10,5,5,8,8,14,14,15,15,11,11,10,10,10,10,4,4,15,15,9,9,6,6,5,5,4,4,15,15,10,10,5,5,7,7,8,8,11,11,5,5,10,10,13,13,14,14,15,15,12,12,1,1,1,1,8,8,8,8,9,9,15,15,1,1,6,6,1,1,10,10,7,7,0,0,3,3,6,6,7,7,8,8,12,12,6,6,8,8,8,8,7,7,9,9,13,13,13,13,12,12,4,4,4,4,10,10,6,6,4,4,9,9,12,12,12,12,1,1,9,9,8,8,7,7,7,7,2,2,9,9,4,4,5,5,3,3,4,4,1,1,8,8,10,10,5,5,7,7,5,5,4,4,5,5,12,12,10,10,6,6,15,15,14,14,5,5,10,10,11,11,4,4,11,11,4,4,5,5,9,9,10,10,3,3,7,7,4,4,1,1,0,0,10,10,9,9,0,0,15,15,14,14,15,15,14,14,4,4,2,2,12,12,4,4,4,4,5,5,1,1,7,7,3,3,1,1,9,9,10,10,9,9,5,5,4,4,0,0,0,0,13,13,5,5,3,3,5,5,2,2,8,8,9,9,5,5,6,6,12,12,13,13,2,2,10,10,3,3,8,8,10,10,5,5,3,3,15,15,2,2,7,7,9,9,5,5,12,12,14,14,11,11,12,12,5,5,6,6,2,2,7,7,0,0,8,8,4,4,15,15,10,10,0,0,6,6,15,15,8,8,1,1,15,15,10,10,5,5,1,1,11,11,0,0,8,8,5,5,7,7,1,1,12,12,1,1,11,11,11,11,9,9,3,3,10,10,1,1,9,9,0,0,14,14,8,8,7,7,7,7,14,14,4,4,7,7,10,10,14,14,14,14,9,9,0,0,14,14,13,13,3,3,10,10,10,10,2,2,14,14,5,5,6,6,12,12,3,3,13,13,10,10,12,12,12,12,9,9,15,15,11,11,1,1,5,5,15,15,11,11,1,1,2,2,10,10,4,4,8,8,3,3,1,1,3,3,7,7,5,5,9,9,10,10,14,14,13,13,0,0,1,1,6,6,13,13,1,1,2,2,5,5,0,0,10,10,3,3,2,2,10,10,15,15,0,0,5,5,5,5,7,7,7,7,15,15,13,13,9,9,12,12,11,11,5,5,9,9,13,13,6,6,8,8,14,14,15,15,15,15,6,6,3,3,14,14,5,5,5,5,8,8,12,12,6,6,8,8,5,5,0,0,8,8,15,15,5,5,5,5,2,2,11,11,2,2,2,2,2,2,11,11,8,8,5,5,7,7,14,14,14,14,3,3,1,1,14,14,12,12,15,15,2,2,10,10,0,0,13,13,12,12,2,2,15,15,3,3,14,14,4,4,0,0,7,7,6,6,14,14,13,13,3,3,12,12,13,13,0,0,7,7,10,10,8,8,1,1,2,2,1,1,3,3,6,6,12,12,6,6,13,13,5,5,13,13,11,11,14,14,13,13,5,5,9,9,0,0,4,4,9,9,4,4,14,14,1,1,13,13,5,5,10,10,7,7,12,12,7,7,11,11,4,4,11,11,14,14,3,3,8,8,1,1,10,10,8,8,5,5,1,1,1,1,14,14,15,15,0,0,12,12,9,9,5,5,13,13,6,6,8,8,2,2,0,0,2,2,0,0,2,2,5,5,14,14,5,5,2,2,12,12,11,11,5,5,8,8,11,11,13,13,4,4,13,13,0,0,3,3,7,7,12,12,14,14,8,8,7,7,3,3,5,5,1,1,13,13,9,9,10,10,8,8,1,1,9,9,14,14,2,2,10,10,6,6,7,7,0,0,8,8,1,1,14,14,1,1,5,5,14,14,9,9,8,8,5,5,6,6,0,0,9,9,2,2,3,3,13,13,9,9,1,1,6,6,12,12,11,11,1,1,3,3,11,11,1,1,9,9,13,13,7,7,1,1,0,0,8,8,9,9,14,14,4,4,0,0,0,0,13,13,6,6,3,3,2,2,2,2,4,4,8,8,6,6,5,5,15,15,4,4,11,11,1,1,10,10,8,8,15,15,1,1,11,11,11,11,10,10,6,6,13,13,13,13,1,1,1,1,9,9,15,15,10,10,0,0,13,13,10,10,3,3,5,5,15,15,4,4,15,15,6,6,3,3,11,11,15,15,1,1,9,9,2,2,15,15,4,4,0,0,0,0,9,9,9,9,4,4,15,15,6,6,9,9,2,2,0,0,2,2,1,1,6,6,2,2,8,8,1,1,1,1,13,13,8,8,7,7,10,10,0,0,10,10,2,2,6,6,15,15,12,12,4,4,5,5,5,5,12,12,6,6,8,8,15,15,12,12,1,1,8,8,9,9,4,4,9,9,5,5,0,0,4,4,9,9,2,2,12,12,5,5,14,14,9,9,9,9,1,1,8,8,6,6,0,0,4,4,3,3,11,11,14,14,3,3,8,8,14,14,2,2,14,14,2,2,13,13,9,9,13,13,6,6,3,3,2,2,10,10,8,8,3,3,9,9,4,4,13,13,7,7,11,11,5,5,11,11,8,8,6,6,10,10,3,3,11,11,4,4,3,3,9,9,15,15,12,12,6,6,0,0,14,14,2,2,13,13,15,15,2,2,2,2,7,7,7,7,1,1,0,0,2,2,12,12,1,1,10,10,7,7,6,6,6,6,3,3,15,15,12,12,0,0,7,7,12,12,4,4,5,5,10,10,11,11,6,6,9,9,3,3,4,4,6,6,2,2,2,2,4,4,7,7,15,15,3,3,4,4,5,5,2,2,10,10,6,6,2,2,13,13,1,1,6,6,0,0,8,8,4,4,3,3,10,10,0,0,10,10,12,12,1,1,8,8,7,7,2,2,6,6,12,12,13,13,5,5,8,8,1,1,0,0,5,5,3,3,4,4,11,11,4,4,5,5,4,4,5,5,12,12,13,13,10,10,10,10,7,7,2,2,14,14,4,4,3,3,1,1,1,1,13,13,4,4,0,0,2,2,5,5,2,2,10,10,6,6,12,12,14,14,3,3,8,8,10,10,1,1,10,10,5,5,2,2,4,4,1,1,13,13,9,9,15,15,12,12,10,10,12,12,4,4,12,12,1,1,7,7,14,14,14,14,14,14,13,13,12,12,0,0,3,3,9,9,4,4,5,5,2,2,7,7,9,9,11,11,7,7,2,2,4,4,9,9,15,15,15,15,2,2,13,13,3,3,2,2,12,12,3,3,14,14,13,13,7,7,9,9,1,1,13,13,2,2,15,15,13,13,4,4,10,10,13,13,3,3,0,0,8,8,4,4,7,7,0,0,1,1,7,7,9,9,6,6,15,15,14,14,12,12,15,15,1,1,14,14,0,0,15,15,3,3,3,3,5,5,14,14,15,15,13,13,12,12,8,8,8,8,6,6,8,8,14,14,6,6,15,15,9,9,3,3,2,2,2,2,11,11,2,2,2,2,0,0,11,11,3,3,1,1,8,8,4,4,7,7,6,6,7,7,2,2,3,3,4,4,9,9,11,11,14,14,15,15,6,6,11,11,7,7,2,2,1,1,2,2,12,12,13,13,15,15,2,2,15,15,0,0,2,2,15,15,9,9,0,0,8,8,4,4,5,5,4,4,0,0,13,13,1,1,5,5,12,12,0,0,3,3,10,10,15,15,2,2,13,13,10,10,13,13,14,14,13,13,1,1,8,8,1,1,14,14,2,2,1,1,2,2,7,7,3,3,6,6,10,10,15,15,13,13,1,1,11,11,4,4,9,9,14,14,11,11,12,12,5,5,11,11,1,1,9,9,15,15,3,3,4,4,8,8,8,8,0,0,11,11,0,0,0,0,14,14,1,1,4,4,12,12,1,1,14,14,0,0,7,7,13,13,7,7,13,13,9,9,1,1,14,14,14,14,14,14,2,2,15,15,2,2,7,7,8,8,11,11,8,8,10,10,11,11,6,6,1,1,3,3,11,11,13,13,1,1,0,0,1,1,15,15,8,8,2,2,5,5,7,7,10,10,4,4,6,6,0,0,3,3,8,8,14,14,6,6,6,6,11,11,4,4,7,7,2,2,5,5,10,10,15,15,9,9,15,15,3,3,3,3,10,10,1,1,3,3,12,12,13,13,9,9,13,13,1,1,4,4,9,9,1,1,12,12,5,5,14,14,9,9,8,8,5,5,7,7,5,5,1,1,5,5,2,2,2,2,13,13,8,8,8,8,10,10,7,7,5,5,6,6,7,7,6,6,10,10,4,4,14,14,10,10,1,1,4,4,2,2,11,11,1,1,10,10,4,4,10,10,14,14,11,11,6,6,14,14,13,13,5,5,9,9,15,15,0,0,12,12,1,1,5,5,0,0,0,0,3,3,8,8,6,6,14,14,0,0,1,1,7,7,2,2,1,1,4,4,1,1,4,4,4,4,8,8,9,9,1,1,14,14,14,14,8,8,6,6,7,7,8,8,8,8,5,5,12,12,9,9,3,3,2,2,3,3,10,10,4,4,8,8,11,11,5,5,0,0,6,6,13,13,1,1,7,7,14,14,13,13,0,0,15,15,5,5,7,7,1,1,3,3,3,3,11,11,10,10,8,8,11,11,10,10,5,5,6,6,5,5,4,4,12,12,14,14,3,3,13,13,8,8,13,13,7,7,10,10,0,0,7,7,7,7,2,2,8,8,2,2,1,1,1,1,0,0,11,11,12,12,13,13,1,1,10,10,10,10,3,3,9,9,0,0,14,14,7,7,1,1,11,11,1,1,1,1,8,8,5,5,11,11,10,10,14,14,11,11,10,10,13,13,3,3,1,1,11,11,8,8,11,11,5,5,7,7,3,3,10,10,10,10,13,13,12,12,6,6,3,3,2,2,14,14,0,0,3,3,9,9,3,3,11,11,3,3,10,10,8,8,1,1,7,7,15,15,1,1,12,12,12,12,0,0,4,4,6,6,13,13,10,10,4,4,1,1,7,7,12,12,13,13,7,7,4,4,4,4,4,4,4,4,10,10,1,1,0,0,3,3,4,4,6,6,4,4,7,7,14,14,13,13,9,9,4,4,6,6,4,4,6,6,1,1,12,12,14,14,12,12,5,5,7,7,12,12,14,14,14,14,10,10,1,1,10,10,12,12,7,7,9,9,9,9,11,11,7,7,12,12,15,15,10,10,3,3,0,0,2,2,2,2,0,0,10,10,4,4,15,15,3,3,9,9,2,2,4,4,3,3,4,4,14,14,6,6,7,7,7,7,9,9,13,13,4,4,10,10,6,6,1,1,14,14,3,3,15,15,1,1,2,2,2,2,4,4,5,5,2,2,5,5,11,11,5,5,1,1,8,8,1,1,1,1,8,8,3,3,6,6,10,10,11,11,13,13,1,1,13,13,10,10,1,1,11,11,13,13,2,2,1,1,10,10,3,3,2,2,14,14,8,8,5,5,7,7,14,14,1,1,5,5,7,7,11,11,0,0,14,14,12,12,1,1,15,15,3,3,13,13,1,1,8,8,15,15,14,14,1,1,2,2,8,8,6,6,14,14,13,13,6,6,4,4,7,7,15,15,13,13,1,1,10,10,9,9,10,10,14,14,6,6,15,15,4,4,0,0,1,1,7,7,15,15,6,6,1,1,15,15,13,13,11,11,4,4,11,11,14,14,5,5,8,8,12,12,8,8,15,15,11,11,2,2,9,9,5,5,2,2,13,13,13,13,11,11,8,8,2,2,2,2,1,1,13,13,5,5,2,2,8,8,15,15,0,0,0,0,6,6,5,5,5,5,2,2,3,3,3,3,11,11,11,11,0,0,7,7,10,10,6,6,6,6,2,2,10,10,9,9,13,13,8,8,11,11,9,9,6,6,14,14,13,13,2,2,9,9,15,15,13,13,9,9,8,8,0,0,5,5,3,3,9,9,15,15,3,3,11,11,15,15,13,13,15,15,9,9,13,13,3,3,6,6,8,8,8,8,8,8,14,14,7,7,1,1,10,10,5,5,0,0,11,11,8,8,6,6,7,7,7,7,8,8,12,12,3,3,5,5,6,6,7,7,7,7,12,12,9,9,15,15,3,3,14,14,6,6,15,15,14,14,0,0,1,1,1,1,13,13,12,12,0,0,0,0,10,10,13,13,14,14,5,5,9,9,13,13,7,7,0,0,14,14,3,3,15,15,0,0,14,14,1,1,5,5,12,12,2,2,5,5,5,5,14,14,1,1,4,4,4,4,0,0,1,1,10,10,0,0,1,1,9,9,10,10,5,5,5,5,12,12,7,7,5,5,0,0,9,9,1,1,13,13,9,9,13,13,13,13,3,3,9,9,2,2,5,5,7,7,11,11,11,11,10,10,7,7,15,15,10,10,3,3,0,0,15,15,4,4,3,3,13,13,12,12,12,12,15,15,0,0,13,13,3,3,5,5,14,14,0,0,5,5,10,10,10,10,9,9,9,9,4,4,7,7,14,14,2,2,7,7,4,4,5,5,9,9,2,2,5,5,10,10,6,6,3,3,12,12,13,13,2,2,1,1,14,14,5,5,5,5,3,3,2,2,11,11,10,10,9,9,10,10,14,14,12,12,0,0,10,10,8,8,10,10,6,6,9,9,1,1,10,10,6,6,1,1,4,4,7,7,0,0,11,11,14,14,4,4,4,4,5,5,6,6,4,4,5,5,13,13,3,3,0,0,7,7,4,4,9,9,12,12,4,4,11,11,9,9,2,2,2,2,0,0,5,5,0,0,13,13,14,14,15,15,11,11,4,4,1,1,2,2,15,15,15,15,15,15,1,1,2,2,13,13,1,1,1,1,4,4,7,7,6,6,3,3,0,0,12,12,14,14,12,12,13,13,2,2,8,8,13,13,2,2,5,5,7,7,1,1,11,11,13,13,2,2,0,0,7,7,4,4,3,3,10,10,3,3,12,12,5,5,13,13,0,0,10,10,2,2,10,10,0,0,13,13,8,8,2,2,4,4,15,15,9,9,3,3,2,2,3,3,2,2,14,14,0,0,2,2,1,1,3,3,13,13,3,3,1,1,6,6,2,2,4,4,14,14,7,7,7,7,12,12,0,0,5,5,11,11,1,1,11,11,9,9,0,0,2,2,5,5,7,7,13,13,1,1,3,3,2,2,12,12,8,8,15,15,5,5,9,9,6,6,1,1,6,6,9,9,0,0,0,0,15,15,10,10,13,13,10,10,8,8,6,6,8,8,5,5,4,4,8,8,10,10,5,5,11,11,7,7,12,12,4,4,4,4,11,11,12,12,5,5,5,5,0,0,3,3,14,14,9,9,6,6,11,11,6,6,9,9,7,7,11,11,1,1,15,15,6,6,4,4,2,2,3,3,12,12,8,8,10,10,6,6,9,9,0,0,12,12,10,10,10,10,0,0,0,0,6,6,6,6,8,8,8,8,9,9,5,5,8,8,6,6,9,9,6,6,10,10,11,11,15,15,4,4,1,1,1,1,10,10,11,11,2,2,13,13,1,1,15,15,11,11,12,12,14,14,13,13,2,2,11,11,8,8,2,2,14,14,3,3,13,13,5,5,10,10,6,6,13,13,4,4,0,0,5,5,1,1,14,14,14,14,4,4,8,8,6,6,3,3,12,12,13,13,15,15,13,13,14,14,5,5,11,11,2,2,9,9,1,1,8,8,0,0,8,8,11,11,5,5,9,9,13,13,7,7,3,3,3,3,11,11,4,4,14,14,13,13,8,8,0,0,4,4,7,7,7,7,13,13,14,14,12,12,3,3,12,12,4,4,9,9,6,6,8,8,8,8,10,10,0,0,8,8,13,13,2,2,4,4,8,8,9,9,15,15,11,11,13,13,12,12,11,11,2,2,13,13,15,15,14,14,7,7,0,0,14,14,10,10,2,2,14,14,11,11,8,8,0,0,12,12,13,13,3,3,0,0,2,2,0,0,4,4,14,14,9,9,0,0,8,8,1,1,5,5,5,5,0,0,11,11,7,7,14,14,14,14,2,2,1,1,3,3,8,8,7,7,2,2,14,14,11,11,2,2,12,12,8,8,7,7,13,13,9,9,15,15,10,10,5,5,6,6,14,14,2,2,14,14,12,12,7,7,14,14,5,5,4,4,9,9,4,4,10,10,8,8,10,10,8,8,7,7,1,1,1,1,9,9,0,0,3,3,4,4,0,0,1,1,1,1,10,10,2,2,8,8,0,0,5,5,8,8,6,6,6,6,5,5,1,1,9,9,11,11,3,3,7,7,12,12,11,11,2,2,0,0,4,4,3,3,6,6,0,0,6,6,6,6,4,4,10,10,15,15,6,6,9,9,4,4,8,8,8,8,8,8,0,0,3,3,0,0,5,5,8,8,4,4,1,1,4,4,0,0,0,0,10,10,1,1,10,10,9,9,12,12,10,10,0,0,15,15,0,0,1,1,13,13,0,0,3,3,1,1,13,13,5,5,15,15,0,0,8,8,9,9,1,1,10,10,8,8,15,15,8,8,0,0,2,2,11,11,5,5,11,11,4,4,0,0,0,0,12,12,2,2,11,11,0,0,2,2,6,6,10,10,3,3,2,2,5,5,5,5,0,0,8,8,3,3,10,10,5,5,2,2,1,1,2,2,8,8,11,11,1,1,13,13,7,7,4,4,4,4,10,10,15,15,10,10,1,1,7,7,0,0,13,13,0,0,12,12,4,4,14,14,10,10,11,11,12,12,12,12,14,14,11,11,1,1,0,0,14,14,1,1,12,12,0,0,12,12,10,10,5,5,14,14,3,3,1,1,15,15,7,7,1,1,14,14,13,13,9,9,15,15,9,9,15,15,8,8,9,9,8,8,15,15,6,6,0,0,7,7,3,3,3,3,10,10,0,0,2,2,7,7,12,12,10,10,13,13,9,9,5,5,2,2,1,1,13,13,1,1,5,5,15,15,3,3,1,1,9,9,0,0,0,0,13,13,0,0,5,5,1,1,14,14,10,10,13,13,6,6,5,5,6,6,9,9,10,10,0,0,6,6,3,3,9,9,13,13,0,0,9,9,15,15,14,14,6,6,12,12,7,7,9,9,3,3,0,0,1,1,1,1,2,2,13,13,6,6,15,15,2,2,3,3,2,2,8,8,11,11,3,3,4,4,7,7,13,13,4,4,2,2,4,4,7,7,5,5,11,11,8,8,5,5,1,1,8,8,10,10,8,8,1,1,0,0,13,13,1,1,8,8,13,13,12,12,10,10,9,9,1,1,8,8,5,5,1,1,9,9,0,0,1,1,13,13,9,9,6,6,1,1,11,11,7,7,9,9,6,6,13,13,2,2,11,11,2,2,13,13,4,4,12,12,14,14,0,0,0,0,14,14,3,3,8,8,6,6,3,3,0,0,7,7,13,13,2,2,7,7,1,1,14,14,7,7,12,12,4,4,1,1,1,1,2,2,10,10,12,12,3,3,2,2,2,2,4,4,14,14,6,6,11,11,0,0,14,14,15,15,7,7,1,1,0,0,3,3,14,14,4,4,9,9,10,10,5,5,9,9,14,14,5,5,13,13,14,14,10,10,4,4,10,10,2,2,3,3,1,1,9,9,2,2,7,7,8,8,5,5,11,11,13,13,8,8,6,6,7,7,10,10,2,2,0,0,5,5,4,4,3,3,9,9,3,3,0,0,0,0,3,3,5,5,15,15,1,1,2,2,9,9,1,1,0,0,5,5,13,13,3,3,0,0,2,2,6,6,6,6,12,12,8,8,10,10,3,3,11,11,5,5,10,10,10,10,0,0,0,0,13,13,15,15,10,10,12,12,7,7,5,5,8,8,7,7,0,0,0,0,1,1,4,4,11,11,2,2,9,9,2,2,4,4,4,4,5,5,14,14,9,9,14,14,5,5,9,9,15,15,9,9,4,4,6,6,15,15,10,10,6,6,6,6,14,14,8,8,9,9,9,9,2,2,1,1,13,13,6,6,13,13,15,15,7,7,12,12,7,7,9,9,8,8,4,4,14,14,3,3,6,6,0,0,4,4,13,13,13,13,13,13,4,4,14,14,10,10,8,8,8,8,12,12,0,0,6,6,6,6,10,10,10,10,11,11,10,10,3,3,13,13,12,12,2,2,4,4,1,1,4,4,14,14,3,3,3,3,0,0,12,12,6,6,10,10,3,3,12,12,1,1,13,13,10,10,5,5,2,2,0,0,13,13,3,3,5,5,3,3,11,11,15,15,12,12,15,15,0,0,10,10,13,13,5,5,4,4,2,2,11,11,14,14,9,9,15,15,3,3,7,7,12,12,6,6,8,8,3,3,3,3,7,7,13,13,12,12,4,4,1,1,4,4,4,4,9,9,8,8,6,6,3,3,14,14,15,15,4,4,1,1,12,12,11,11,2,2,8,8,7,7,3,3,1,1,6,6,4,4,15,15,14,14,5,5,2,2,5,5,6,6,8,8,8,8,7,7,1,1,9,9,12,12,6,6,9,9,13,13,10,10,6,6,9,9,15,15,0,0,2,2,14,14,7,7,8,8,12,12,7,7,0,0,9,9,8,8,0,0,10,10,8,8,12,12,0,0,2,2,11,11,3,3,14,14,6,6,6,6,2,2,13,13,10,10,13,13,15,15,3,3,13,13,1,1,8,8,7,7,13,13,1,1,10,10,6,6,12,12,10,10,1,1,7,7,9,9,2,2,4,4,10,10,2,2,4,4,9,9,0,0,3,3,12,12,4,4,4,4,8,8,1,1,6,6,7,7,10,10,3,3,11,11,4,4,2,2,13,13,8,8,10,10,6,6,0,0,1,1,6,6,9,9,12,12,0,0,8,8,5,5,9,9,9,9,8,8,14,14,7,7,15,15,3,3,2,2,2,2,6,6,8,8,0,0,4,4,9,9,2,2,2,2,0,0,3,3,12,12,8,8,2,2,11,11,14,14,4,4,5,5,0,0,14,14,15,15,7,7,10,10,2,2,14,14,10,10,12,12,8,8,1,1,7,7,6,6,8,8,11,11,15,15,2,2,13,13,8,8,13,13,0,0,10,10,1,1,6,6,11,11,2,2,6,6,11,11,2,2,9,9,5,5,11,11,12,12,14,14,3,3,10,10,1,1,9,9,14,14,1,1,11,11,1,1,10,10,11,11,9,9,11,11,4,4,14,14,11,11,10,10,4,4,13,13,11,11,8,8,15,15,13,13,14,14,5,5,0,0,4,4,11,11,4,4,12,12,11,11,8,8,15,15,13,13,8,8,15,15,9,9,2,2,4,4,6,6,0,0,13,13,6,6,0,0,4,4,4,4,4,4,2,2,8,8,13,13,15,15,3,3,2,2,0,0,10,10,13,13,3,3,3,3,1,1,4,4,6,6,14,14,13,13,13,13,7,7,5,5,9,9,1,1,11,11,11,11,0,0,10,10,5,5,4,4,10,10,1,1,3,3,9,9,2,2,0,0,8,8,5,5,2,2,4,4,8,8,1,1,15,15,8,8,11,11,12,12,3,3,3,3,9,9,6,6,4,4,1,1,14,14,1,1,2,2,1,1,4,4,7,7,13,13,7,7,1,1,8,8,5,5,4,4,7,7,10,10,10,10,1,1,0,0,1,1,0,0,11,11,8,8,11,11,2,2,3,3,5,5,15,15,15,15,5,5,7,7,13,13,8,8,2,2,3,3,7,7,10,10,9,9,8,8,14,14,9,9,12,12,10,10,15,15,10,10,3,3,1,1,1,1,0,0,1,1,0,0,4,4,2,2,12,12,14,14,9,9,14,14,15,15,2,2,1,1,1,1,4,4,3,3,6,6,5,5,12,12,4,4,7,7,4,4,10,10,1,1,15,15,10,10,2,2,8,8,11,11,3,3,15,15,8,8,8,8,9,9,4,4,6,6,1,1,12,12,1,1,13,13,4,4,7,7,6,6,12,12,1,1,11,11,2,2,1,1,4,4,2,2,0,0,5,5,15,15,3,3,5,5,10,10,4,4,10,10,6,6,9,9,4,4,9,9,1,1,11,11,13,13,15,15,7,7,4,4,10,10,9,9,4,4,11,11,3,3,3,3,3,3,8,8,15,15,11,11,7,7,14,14,5,5,0,0,4,4,1,1,9,9,7,7,8,8,7,7,3,3,11,11,14,14,11,11,6,6,15,15,10,10,1,1,3,3,7,7,11,11,5,5,5,5,10,10,4,4,2,2,14,14,0,0,1,1,8,8,2,2,2,2,12,12,10,10,10,10,5,5,15,15,6,6,6,6,1,1,8,8,13,13,0,0,8,8,1,1,8,8,10,10,14,14,7,7,5,5,3,3,4,4,0,0,4,4,8,8,10,10,14,14,3,3,0,0,11,11,11,11,11,11,4,4,4,4,5,5,15,15,6,6,2,2,14,14,15,15,7,7,12,12,14,14,0,0,4,4,10,10,9,9,9,9,1,1,8,8,12,12,7,7,0,0,4,4,4,4,8,8,8,8,0,0,3,3,8,8,11,11,2,2,11,11,11,11,3,3,2,2,8,8,3,3,13,13,4,4,4,4,8,8,1,1,1,1,15,15,4,4,3,3,4,4,5,5,9,9,4,4,10,10,11,11,14,14,6,6,12,12,5,5,5,5,4,4,3,3,5,5,2,2,15,15,0,0,4,4,3,3,10,10,9,9,0,0,2,2,13,13,2,2,10,10,0,0,11,11,2,2,8,8,13,13,4,4,10,10,5,5,15,15,14,14,9,9,8,8,2,2,13,13,6,6,6,6,12,12,10,10,12,12,13,13,8,8,1,1,11,11,6,6,12,12,14,14,13,13,14,14,11,11,2,2,7,7,11,11,15,15,2,2,4,4,0,0,3,3,6,6,11,11,12,12,8,8,7,7,10,10,14,14,12,12,11,11,14,14,2,2,11,11,6,6,5,5,10,10,6,6,3,3,0,0,2,2,8,8,14,14,10,10,14,14,15,15,0,0,1,1,6,6,9,9,6,6,6,6,12,12,9,9,4,4,2,2,8,8,3,3,1,1,14,14,3,3,15,15,3,3,13,13,0,0,14,14,13,13,2,2,8,8,12,12,14,14,5,5,11,11,4,4,0,0,8,8,1,1,8,8,9,9,8,8,3,3,0,0,0,0,5,5,1,1,0,0,10,10,14,14,4,4,11,11,7,7,15,15,2,2,10,10,3,3,13,13,7,7,4,4,10,10,1,1,9,9,5,5,9,9,0,0,9,9,5,5,7,7,1,1,5,5,1,1,10,10,15,15,4,4,2,2,8,8,6,6,15,15,10,10,12,12,9,9,15,15,6,6,8,8,7,7,14,14,9,9,12,12,1,1,0,0,13,13,15,15,10,10,3,3,11,11,4,4,1,1,15,15,15,15,15,15,4,4,6,6,0,0,7,7,9,9,9,9,2,2,13,13,12,12,13,13,13,13,9,9,13,13,2,2,0,0,1,1,8,8,12,12,7,7,13,13,0,0,11,11,12,12,4,4,3,3,8,8,1,1,3,3,5,5,3,3,3,3,3,3,12,12,10,10,8,8,3,3,0,0,10,10,13,13,0,0,2,2,10,10,2,2,11,11,12,12,5,5,2,2,6,6,14,14,0,0,8,8,6,6,11,11,15,15,13,13,14,14,7,7,2,2,4,4,9,9,2,2,15,15,12,12,7,7,6,6,3,3,12,12,5,5,1,1,14,14,2,2,7,7,6,6,11,11,9,9,8,8,7,7,12,12,1,1,2,2,1,1,10,10,10,10,13,13,13,13,14,14,1,1,0,0,12,12,14,14,0,0,9,9,5,5,4,4,9,9,0,0,14,14,2,2,7,7,12,12,2,2,12,12,15,15,3,3,5,5,0,0,14,14,0,0,5,5,4,4,8,8,4,4,2,2,4,4,14,14,0,0,10,10,4,4,7,7,3,3,11,11,7,7,5,5,9,9,12,12,10,10,11,11,1,1,5,5,2,2,3,3,1,1,14,14,3,3,6,6,4,4,0,0,4,4,11,11,11,11,11,11,1,1,12,12,5,5,13,13,2,2,5,5,13,13,7,7,3,3,10,10,9,9,7,7,12,12,2,2,13,13,3,3,11,11,3,3,12,12,7,7,15,15,3,3,4,4,12,12,10,10,4,4,0,0,2,2,0,0,10,10,5,5,10,10,11,11,14,14,9,9,6,6,12,12,3,3,15,15,2,2,4,4,10,10,5,5,10,10,14,14,0,0,15,15,9,9,7,7,2,2,4,4,11,11,8,8,9,9,4,4,2,2,11,11,0,0,15,15,12,12,14,14,11,11,5,5,4,4,0,0,11,11,5,5,0,0,0,0,3,3,12,12,0,0,12,12,15,15,10,10,11,11,0,0,12,12,13,13,9,9,9,9,5,5,7,7,8,8,5,5,2,2,1,1,15,15,3,3,10,10,7,7,13,13,2,2,10,10,6,6,14,14,8,8,13,13,8,8,2,2,9,9,5,5,1,1,7,7,2,2,5,5,4,4,9,9,2,2,9,9,0,0,1,1,1,1,1,1,15,15,5,5,6,6,4,4,8,8,0,0,8,8,14,14,10,10,8,8,10,10,2,2,6,6,7,7,8,8,7,7,0,0,8,8,10,10,12,12,11,11,12,12,0,0,13,13,5,5,5,5,9,9,12,12,1,1,2,2,12,12,14,14,6,6,2,2,7,7,6,6,7,7,7,7,0,0,5,5,7,7,13,13,0,0,14,14,3,3,13,13,8,8,4,4,9,9,12,12,1,1,6,6,9,9,1,1,1,1,12,12,11,11,0,0,6,6,10,10,3,3,2,2,15,15,5,5,4,4,10,10,15,15,14,14,0,0,1,1,4,4,1,1,7,7,1,1,8,8,2,2,7,7,3,3,2,2,5,5,6,6,2,2,12,12,12,12,9,9,5,5,12,12,10,10,4,4,12,12,1,1,5,5,3,3,10,10,14,14,7,7,0,0,7,7,14,14,7,7,10,10,3,3,8,8,6,6,1,1,2,2,11,11,7,7,2,2,2,2,10,10,3,3,7,7,8,8,15,15,4,4,1,1,9,9,8,8,2,2,4,4,4,4,14,14,5,5,15,15,5,5,13,13,1,1,13,13,1,1,10,10,9,9,9,9,12,12,5,5,13,13,4,4,1,1,13,13,12,12,4,4,4,4,8,8,11,11,0,0,5,5,4,4,5,5,1,1,5,5,6,6,8,8,1,1,14,14,1,1,12,12,4,4,4,4,2,2,5,5,14,14,1,1,10,10,9,9,2,2,4,4,7,7,14,14,12,12,7,7,11,11,9,9,6,6,4,4,9,9,9,9,3,3,11,11,4,4,7,7,8,8,1,1,8,8,8,8,4,4,2,2,1,1,4,4,7,7,1,1,12,12,8,8,3,3,9,9,7,7,3,3,6,6,2,2,10,10,0,0,9,9,10,10,10,10,0,0,6,6,11,11,2,2,4,4,4,4,6,6,2,2,4,4,6,6,8,8,8,8,0,0,8,8,9,9,12,12,4,4,12,12,15,15,10,10,6,6,7,7,11,11,15,15,1,1,13,13,2,2,13,13,5,5,1,1,6,6,8,8,2,2,4,4,7,7,4,4,2,2,3,3,7,7,2,2,4,4,12,12,11,11,7,7,0,0,13,13,3,3,14,14,14,14,6,6,2,2,0,0,11,11,9,9,1,1,9,9,10,10,7,7,1,1,3,3,11,11,11,11,5,5,10,10,14,14,13,13,2,2,11,11,6,6,4,4,13,13,11,11,11,11,12,12,14,14,0,0,15,15,14,14,8,8,3,3,10,10,10,10,8,8,15,15,10,10,9,9,6,6,11,11,4,4,10,10,15,15,10,10,6,6,1,1,10,10,12,12,1,1,12,12,3,3,4,4,13,13,5,5,14,14,8,8,8,8,11,11,15,15,8,8,5,5,4,4,2,2,8,8,0,0,15,15,11,11,1,1,12,12,15,15,2,2,8,8,14,14,13,13,10,10,7,7,11,11,12,12,12,12,9,9,4,4,13,13,6,6,1,1,4,4,7,7,7,7,6,6,2,2,5,5,4,4,8,8,12,12,12,12,2,2,1,1,4,4,14,14,15,15,4,4,15,15,0,0,4,4,8,8,12,12,0,0,8,8,0,0,10,10,6,6,13,13,6,6,14,14,14,14,1,1,15,15,12,12,4,4,4,4,9,9,12,12,3,3,6,6,7,7,5,5,14,14,3,3,9,9,10,10,1,1,6,6,0,0,12,12,5,5,7,7,7,7,13,13,1,1,5,5,13,13,6,6,4,4,8,8,14,14,8,8,1,1,12,12,7,7,15,15,1,1,0,0,9,9,2,2,15,15,13,13,2,2,0,0,11,11,9,9,1,1,11,11,3,3,4,4,0,0,8,8,4,4,4,4,11,11,1,1,13,13,2,2,8,8,6,6,14,14,7,7,10,10,7,7,4,4,4,4,14,14,0,0,8,8,4,4,5,5,15,15,7,7,6,6,0,0,7,7,9,9,2,2,0,0,6,6,2,2,12,12,2,2,6,6,0,0,5,5,9,9,1,1,11,11,0,0,8,8,3,3,14,14,12,12,4,4,3,3,6,6,12,12,15,15,0,0,1,1,7,7,11,11,0,0,4,4,3,3,12,12,5,5,7,7,9,9,0,0,6,6,1,1,15,15,10,10,5,5,15,15,5,5,4,4,13,13,9,9,7,7,15,15,9,9,4,4,12,12,5,5,14,14,3,3,2,2,14,14,14,14,4,4,6,6,14,14,1,1,7,7,12,12,3,3,14,14,9,9,8,8,5,5,5,5,15,15,13,13,6,6,10,10,15,15,15,15,1,1,3,3,13,13,11,11,7,7,4,4,15,15,6,6,5,5,0,0,4,4,15,15,11,11,11,11,6,6,0,0,5,5,9,9,7,7,8,8,2,2,4,4,3,3,0,0,15,15,3,3,2,2,14,14,15,15,13,13,2,2,7,7,7,7,12,12,2,2,10,10,5,5,9,9,12,12,9,9,7,7,11,11,10,10,8,8,5,5,1,1,10,10,2,2,4,4,4,4,5,5,9,9,11,11,12,12,0,0,10,10,3,3,15,15,0,0,14,14,5,5,0,0,1,1,15,15,11,11,10,10,7,7,10,10,11,11,10,10,4,4,3,3,12,12,1,1,14,14,9,9,2,2,1,1,1,1,6,6,5,5,5,5,8,8,12,12,5,5,11,11,9,9,2,2,8,8,0,0,14,14,0,0,4,4,1,1,10,10,15,15,9,9,11,11,11,11,9,9,7,7,12,12,1,1,9,9,8,8,4,4,1,1,6,6,4,4,6,6,1,1,3,3,0,0,11,11,0,0,13,13,3,3,14,14,7,7,14,14,11,11,2,2,4,4,0,0,1,1,1,1,3,3,2,2,9,9,8,8,4,4,0,0,8,8,4,4,14,14,11,11,1,1,3,3,14,14,1,1,1,1,7,7,9,9,10,10,6,6,6,6,4,4,6,6,1,1,14,14,10,10,2,2,3,3,6,6,6,6,9,9,6,6,2,2,14,14,4,4,3,3,7,7,12,12,9,9,0,0,4,4,5,5,15,15,0,0,6,6,0,0,12,12,6,6,0,0,3,3,1,1,2,2,14,14,7,7,15,15,4,4,2,2,12,12,13,13,8,8,12,12,5,5,9,9,5,5,7,7,0,0,1,1,5,5,4,4,2,2,12,12,9,9,8,8,2,2,5,5,13,13,12,12,2,2,11,11,3,3,6,6,13,13,0,0,8,8,7,7,10,10,5,5,5,5,6,6,2,2,7,7,9,9,9,9,0,0,13,13,11,11,4,4,14,14,14,14,12,12,4,4,9,9,6,6,13,13,14,14,13,13,1,1,7,7,6,6,14,14,7,7,6,6,12,12,9,9,7,7,4,4,3,3,11,11,14,14,5,5,1,1,7,7,0,0,6,6,3,3,11,11,9,9,15,15,12,12,7,7,14,14,6,6,11,11,1,1,5,5,10,10,7,7,10,10,3,3,15,15,10,10,10,10,11,11,2,2,12,12,6,6,9,9,9,9,7,7,6,6,13,13,4,4,2,2,9,9,3,3,10,10,5,5,14,14,6,6,15,15,7,7,7,7,0,0,0,0,13,13,13,13,5,5,10,10,14,14,14,14,3,3,9,9,5,5,2,2,9,9,15,15,8,8,10,10,5,5,5,5,11,11,12,12,10,10,14,14,8,8,7,7,0,0,11,11,15,15,12,12,7,7,9,9,4,4,0,0,1,1,8,8,13,13,15,15,9,9,5,5,7,7,2,2,7,7,3,3,9,9,2,2,11,11,14,14,0,0,2,2,5,5,13,13,14,14,5,5,4,4,6,6,8,8,10,10,2,2,10,10,9,9,6,6,7,7,10,10,1,1,3,3,12,12,12,12,3,3,7,7,15,15,9,9,6,6,0,0,10,10,0,0,8,8,12,12,0,0,4,4,13,13,8,8,14,14,8,8,6,6,5,5,6,6,4,4,9,9,12,12,11,11,10,10,10,10,7,7,10,10,5,5,2,2,11,11,15,15,0,0,9,9,4,4,15,15,13,13,3,3,3,3,2,2,12,12,0,0,0,0,2,2,9,9,14,14,7,7,4,4,9,9,8,8,14,14,6,6,15,15,12,12,15,15,0,0,9,9,10,10,8,8,6,6,5,5,13,13,12,12,6,6,3,3,1,1,1,1,4,4,8,8,14,14,6,6,9,9,11,11,15,15,8,8,4,4,11,11,2,2,11,11,8,8,8,8,7,7,4,4,7,7,2,2,12,12,1,1,11,11,3,3,4,4,4,4,5,5,2,2,13,13,4,4,10,10,2,2,5,5,11,11,7,7,13,13,8,8,13,13,14,14,14,14,2,2,1,1,12,12,9,9,0,0,14,14,1,1,8,8,6,6,9,9,2,2,2,2,5,5,0,0,4,4,15,15,10,10,14,14,6,6,12,12,8,8,14,14,0,0,6,6,1,1,12,12,4,4,12,12,7,7,13,13,15,15,0,0,6,6,0,0,2,2,8,8,10,10,8,8,1,1,13,13,5,5,14,14,11,11,5,5,15,15,4,4,12,12,6,6,12,12,8,8,4,4,4,4,2,2,11,11,3,3,11,11,10,10,8,8,6,6,10,10,13,13,13,13,1,1,7,7,10,10,13,13,2,2,10,10,10,10,0,0,5,5,14,14,14,14,0,0,1,1,1,1,3,3,11,11,13,13,11,11,9,9,1,1,6,6,7,7,0,0,6,6,14,14,11,11,10,10,9,9,4,4,14,14,2,2,4,4,2,2,0,0,5,5,9,9,10,10,4,4,8,8,5,5,12,12,5,5,9,9,6,6,11,11,6,6,10,10,0,0,4,4,5,5,0,0,9,9,15,15,7,7,12,12,7,7,14,14,6,6,2,2,9,9,10,10,0,0,4,4,5,5,3,3,12,12,12,12,9,9,0,0,3,3,2,2,2,2,0,0,5,5,5,5,6,6,0,0,2,2,4,4,7,7,5,5,3,3,7,7,12,12,7,7,9,9,6,6,0,0,3,3,0,0,0,0,9,9,3,3,3,3,12,12,14,14,13,13,1,1,8,8,7,7,0,0,9,9,8,8,14,14,12,12,8,8,12,12,12,12,6,6,8,8,12,12,1,1,6,6,3,3,9,9,9,9,0,0,3,3,5,5,15,15,2,2,13,13,3,3,3,3,3,3,6,6,7,7,7,7,3,3,12,12,9,9,1,1,5,5,15,15,12,12,7,7,3,3,4,4,15,15,7,7,15,15,9,9,3,3,7,7,9,9,9,9,14,14,5,5,7,7,2,2,9,9,12,12,4,4,4,4,10,10,0,0,1,1,15,15,12,12,2,2,10,10,15,15,9,9,5,5,8,8,0,0,14,14,9,9,12,12,10,10,9,9,1,1,15,15,13,13,12,12,10,10,10,10,9,9,8,8,4,4,3,3,6,6,1,1,6,6,8,8,8,8,6,6,9,9,9,9,0,0,8,8,2,2,2,2,1,1,13,13,7,7,4,4,6,6,15,15,11,11,12,12,9,9,2,2,12,12,5,5,12,12,3,3,9,9,7,7,3,3,10,10,1,1,3,3,2,2,13,13,7,7,9,9,2,2,9,9,6,6,6,6,4,4,5,5,9,9,10,10,8,8,4,4,0,0,4,4,6,6,5,5,3,3,0,0,0,0,12,12,13,13,5,5,11,11,9,9,7,7,6,6,5,5,5,5,12,12,1,1,11,11,2,2,0,0,0,0,12,12,12,12,5,5,5,5,5,5,13,13,11,11,10,10,1,1,0,0,9,9,2,2,15,15,10,10,11,11,12,12,14,14,14,14,14,14,3,3,9,9,6,6,14,14,13,13,14,14,7,7,0,0,2,2,2,2,5,5,9,9,4,4,15,15,9,9,10,10,10,10,9,9,14,14,1,1,2,2,14,14,14,14,2,2,14,14,6,6,12,12,12,12,14,14,1,1,3,3,13,13,2,2,7,7,4,4,0,0,4,4,0,0,4,4,7,7,13,13,11,11,4,4,3,3,12,12,1,1,0,0,1,1,10,10,13,13,0,0,10,10,7,7,7,7,2,2,14,14,15,15,9,9,14,14,0,0,13,13,4,4,2,2,4,4,3,3,8,8,12,12,5,5,4,4,9,9,3,3,1,1,9,9,0,0,4,4,4,4,10,10,1,1,5,5,10,10,5,5,4,4,11,11,8,8,13,13,14,14,13,13,3,3,4,4,4,4,1,1,2,2,5,5,0,0,7,7,2,2,11,11,6,6,2,2,3,3,11,11,5,5,15,15,5,5,2,2,8,8,14,14,12,12,10,10,11,11,4,4,10,10,5,5,15,15,13,13,10,10,9,9,3,3,10,10,9,9,6,6,0,0,8,8,3,3,3,3,14,14,13,13,0,0,2,2,12,12,3,3,8,8,0,0,4,4,2,2,4,4,9,9,2,2,0,0,5,5,2,2,5,5,10,10,3,3,6,6,2,2,2,2,4,4,8,8,8,8,1,1,2,2,1,1,2,2,7,7,10,10,10,10,4,4,3,3,9,9,2,2,1,1,7,7,11,11,13,13,3,3,5,5,8,8,1,1,14,14,3,3,2,2,11,11,9,9,11,11,3,3,14,14,14,14,1,1,5,5,9,9,10,10,3,3,9,9,3,3,11,11,5,5,5,5,4,4,3,3,13,13,4,4,3,3,5,5,3,3,6,6,8,8,5,5,1,1,5,5,11,11,15,15,11,11,11,11,12,12,1,1,2,2,14,14,1,1,5,5,2,2,11,11,1,1,0,0,12,12,15,15,14,14,13,13,1,1,8,8,2,2,12,12,0,0,12,12,13,13,9,9,10,10,7,7,0,0,2,2,1,1,1,1,0,0,4,4,4,4,7,7,6,6,11,11,5,5,7,7,3,3,12,12,10,10,12,12,13,13,13,13,10,10,9,9,0,0,14,14,0,0,6,6,7,7,5,5,7,7,13,13,4,4,9,9,9,9,7,7,9,9,10,10,4,4,5,5,1,1,0,0,7,7,14,14,2,2,1,1,9,9,6,6,6,6,2,2,6,6,5,5,1,1,5,5,9,9,5,5,0,0,4,4,1,1,14,14,6,6,10,10,1,1,8,8,8,8,8,8,11,11,10,10,4,4,7,7,15,15,1,1,1,1,6,6,2,2,8,8,15,15,6,6,3,3,12,12,1,1,2,2,1,1,3,3,5,5,4,4,4,4,3,3,13,13,8,8,5,5,15,15,12,12,3,3,8,8,9,9,0,0,0,0,0,0,9,9,7,7,5,5,6,6,1,1,8,8,5,5,4,4,14,14,5,5,12,12,1,1,0,0,10,10,2,2,2,2,8,8,4,4,8,8,2,2,9,9,3,3,4,4,11,11,2,2,15,15,8,8,5,5,9,9,9,9,12,12,6,6,7,7,3,3,9,9,12,12,1,1,1,1,2,2,9,9,14,14,10,10,0,0,14,14,10,10,4,4,2,2,2,2,10,10,4,4,0,0,3,3,3,3,8,8,9,9,5,5,0,0,5,5,14,14,12,12,11,11,4,4,3,3,14,14,10,10,3,3,9,9,2,2,11,11,7,7,3,3,14,14,0,0,4,4,11,11,9,9,8,8,15,15,4,4,0,0,14,14,13,13,10,10,0,0,2,2,13,13,13,13,8,8,9,9,6,6,10,10,13,13,4,4,7,7,2,2,4,4,3,3,3,3,6,6,6,6,4,4,13,13,9,9,8,8,0,0,11,11,0,0,0,0,14,14,10,10,10,10,6,6,10,10,4,4,5,5,4,4,4,4,9,9,9,9,7,7,8,8,2,2,3,3,0,0,2,2,14,14,13,13,0,0,1,1,15,15,10,10,7,7,7,7,6,6,5,5,4,4,5,5,6,6,3,3,4,4,2,2,8,8,7,7,11,11,9,9,4,4,7,7,10,10,15,15,13,13,5,5,15,15,1,1,7,7,2,2,8,8,12,12,14,14,15,15,10,10,9,9,8,8,6,6,12,12,1,1,7,7,15,15,9,9,13,13,2,2,2,2,15,15,13,13,2,2,5,5,5,5,14,14,12,12,13,13,9,9,3,3,6,6,4,4,6,6,7,7,3,3,13,13,9,9,10,10,3,3,12,12,12,12,6,6,8,8,3,3,10,10,6,6,6,6,14,14,0,0,12,12,14,14,13,13,2,2,12,12,9,9,12,12,8,8,13,13,12,12,4,4,3,3,10,10,10,10,8,8,2,2,5,5,13,13,9,9,12,12,4,4,9,9,11,11,2,2,2,2,4,4,0,0,7,7,1,1,13,13,3,3,9,9,15,15,3,3,4,4,11,11,3,3,2,2,0,0,3,3,12,12,8,8,15,15,2,2,1,1,0,0,15,15,15,15,4,4,9,9,2,2,4,4,0,0,4,4,9,9,0,0,4,4,8,8,1,1,2,2,10,10,7,7,1,1,2,2,13,13,1,1,13,13,6,6,15,15,12,12,1,1,12,12,2,2,10,10,11,11,15,15,3,3,3,3,11,11,10,10,15,15,7,7,5,5,5,5,0,0,15,15,14,14,7,7,15,15,10,10,9,9,13,13,1,1,6,6,7,7,7,7,5,5,8,8,14,14,6,6,0,0,2,2,6,6,14,14,2,2,12,12,8,8,7,7,0,0,9,9,11,11,4,4,12,12,7,7,4,4,1,1,0,0,3,3,1,1,9,9,5,5,8,8,5,5,6,6,8,8,3,3,2,2,14,14,6,6,7,7,11,11,3,3,1,1,0,0,1,1,1,1,1,1,1,1,4,4,5,5,15,15,4,4,9,9,4,4,6,6,1,1,0,0,6,6,8,8,9,9,4,4,12,12,11,11,3,3,7,7,10,10,6,6,3,3,15,15,1,1,14,14,6,6,7,7,7,7,3,3,4,4,3,3,4,4,1,1,9,9,0,0,10,10,9,9,8,8,12,12,6,6,3,3,11,11,12,12,0,0,12,12,1,1,0,0,0,0,13,13,13,13,9,9,10,10,13,13,7,7,3,3,8,8,7,7,7,7,3,3,9,9,6,6,0,0,3,3,11,11,4,4,2,2,0,0,10,10,13,13,14,14,1,1,1,1,9,9,7,7,9,9,15,15,5,5,6,6,4,4,1,1,14,14,9,9,9,9,12,12,14,14,0,0,1,1,4,4,14,14,4,4,7,7,6,6,2,2,2,2,3,3,0,0,12,12,7,7,10,10,2,2,10,10,15,15,10,10,4,4,0,0,5,5,15,15,8,8,7,7,3,3,15,15,12,12,8,8,0,0,11,11,4,4,3,3,8,8,4,4,13,13,14,14,11,11,0,0,0,0,11,11,1,1,1,1,1,1,6,6,0,0,14,14,10,10,12,12,7,7,9,9,4,4,14,14,11,11,4,4,5,5,6,6,11,11,13,13,8,8,3,3,1,1,9,9,13,13,3,3,12,12,5,5,13,13,12,12,4,4,4,4,9,9,7,7,2,2,6,6,10,10,5,5,11,11,0,0,6,6,11,11,15,15,6,6,12,12,7,7,4,4,4,4,4,4,3,3,5,5,13,13,8,8,5,5,2,2,7,7,0,0,15,15,1,1,0,0,1,1,10,10,4,4,8,8,13,13,1,1,4,4,2,2,1,1,4,4,8,8,9,9,8,8,3,3,11,11,10,10,1,1,4,4,5,5,6,6,9,9,8,8,3,3,11,11,2,2,5,5,3,3,6,6,1,1,6,6,6,6,9,9,9,9,6,6,3,3,15,15,12,12,11,11,8,8,13,13,12,12,12,12,3,3,14,14,1,1,5,5,13,13,1,1,10,10,4,4,10,10,11,11,15,15,0,0,9,9,6,6,9,9,8,8,0,0,4,4,5,5,12,12,3,3,0,0,15,15,10,10,15,15,1,1,5,5,11,11,15,15,1,1,5,5,7,7,12,12,7,7,7,7,1,1,11,11,8,8,14,14,15,15,2,2,10,10,0,0,9,9,2,2,15,15,12,12,9,9,12,12,7,7,14,14,8,8,10,10,12,12,2,2,1,1,7,7,12,12,6,6,10,10,11,11,1,1,12,12,9,9,12,12,4,4,8,8,11,11,0,0,0,0,9,9,10,10,10,10,3,3,10,10,11,11,8,8,1,1,5,5,14,14,1,1,5,5,10,10,4,4,8,8,8,8,4,4,3,3,6,6,4,4,8,8,0,0,1,1,7,7,14,14,10,10,4,4,14,14,11,11,0,0,3,3,13,13,12,12,7,7,5,5,13,13,3,3,9,9,4,4,5,5,6,6,11,11,5,5,3,3,5,5,1,1,4,4,11,11,12,12,8,8,11,11,5,5,15,15,12,12,6,6,9,9,0,0,5,5,8,8,12,12,15,15,0,0,1,1,9,9,3,3,9,9,7,7,4,4,8,8,11,11,14,14,6,6,0,0,13,13,3,3,13,13,15,15,0,0,8,8,13,13,13,13,8,8,1,1,6,6,6,6,0,0,9,9,5,5,2,2,11,11,11,11,3,3,9,9,8,8,0,0,9,9,11,11,2,2,5,5,0,0,2,2,3,3,9,9,6,6,10,10,13,13,0,0,5,5,4,4,3,3,2,2,10,10,7,7,8,8,0,0,8,8,10,10,15,15,11,11,9,9,8,8,2,2,13,13,14,14,5,5,7,7,7,7,15,15,7,7,1,1,5,5,4,4,4,4,6,6,7,7,14,14,6,6,1,1,12,12,6,6,12,12,2,2,14,14,5,5,5,5,0,0,14,14,1,1,5,5,0,0,3,3,0,0,3,3,15,15,12,12,9,9,12,12,3,3,12,12,9,9,7,7,10,10,4,4,4,4,13,13,10,10,5,5,3,3,0,0,11,11,14,14,2,2,12,12,13,13,8,8,2,2,1,1,1,1,5,5,15,15,15,15,13,13,2,2,4,4,10,10,1,1,4,4,15,15,1,1,5,5,0,0,9,9,10,10,3,3,13,13,12,12,2,2,6,6,7,7,5,5,1,1,3,3,15,15,0,0,8,8,11,11,7,7,4,4,9,9,8,8,5,5,0,0,4,4,15,15,6,6,12,12,11,11,15,15,2,2,10,10,6,6,14,14,4,4,7,7,15,15,11,11,11,11,6,6,12,12,12,12,0,0,2,2,9,9,5,5,13,13,2,2,7,7,5,5,0,0,13,13,5,5,9,9,0,0,8,8,1,1,15,15,1,1,2,2,1,1,4,4,11,11,15,15,5,5,7,7,5,5,0,0,5,5,0,0,7,7,0,0,9,9,2,2,9,9,1,1,5,5,3,3,4,4,6,6,5,5,8,8,10,10,6,6,2,2,14,14,3,3,0,0,7,7,13,13,3,3,1,1,14,14,8,8,6,6,0,0,7,7,1,1,0,0,5,5,6,6,3,3,0,0,7,7,3,3,9,9,12,12,12,12,8,8,9,9,11,11,13,13,4,4,6,6,3,3,0,0,3,3,2,2,2,2,6,6,12,12,0,0,14,14,15,15,1,1,5,5,11,11,15,15,11,11,3,3,2,2,12,12,15,15,10,10,1,1,10,10,5,5,11,11,15,15,9,9,8,8,3,3,10,10,12,12,11,11,14,14,7,7,12,12,0,0,13,13,10,10,1,1,0,0,6,6,7,7,11,11,12,12,0,0,9,9,7,7,13,13,4,4,3,3,4,4,14,14,8,8,1,1,7,7,11,11,3,3,12,12,8,8,5,5,13,13,4,4,2,2,8,8,14,14,13,13,4,4,2,2,8,8,9,9,12,12,1,1,8,8,15,15,14,14,13,13,9,9,13,13,13,13,14,14,14,14,13,13,15,15,12,12,2,2,0,0,11,11,1,1,8,8,1,1,3,3,1,1,3,3,8,8,14,14,5,5,7,7,4,4,12,12,1,1,11,11,0,0,3,3,6,6,10,10,2,2,15,15,8,8,10,10,11,11,10,10,0,0,13,13,8,8,0,0,4,4,6,6,15,15,0,0,13,13,13,13,3,3,0,0,10,10,12,12,9,9,6,6,14,14,9,9,5,5,13,13,9,9,4,4,2,2,13,13,10,10,12,12,13,13,8,8,7,7,2,2,6,6,8,8,14,14,12,12,4,4,0,0,15,15,0,0,2,2,7,7,9,9,6,6,6,6,14,14,2,2,3,3,11,11,9,9,5,5,13,13,13,13,1,1,10,10,15,15,10,10,15,15,5,5,5,5,0,0,4,4,8,8,9,9,11,11,6,6,3,3,3,3,8,8,15,15,6,6,4,4,4,4,14,14,13,13,2,2,11,11,5,5,1,1,7,7,3,3,1,1,4,4,9,9,9,9,13,13,12,12,4,4,9,9,6,6,9,9,11,11,0,0,7,7,3,3,14,14,11,11,6,6,15,15,8,8,4,4,3,3,1,1,6,6,11,11,3,3,11,11,2,2,12,12,6,6,2,2,8,8,10,10,3,3,8,8,3,3,11,11,10,10,3,3,10,10,14,14,1,1,1,1,4,4,7,7,6,6,2,2,11,11,15,15,1,1,4,4,7,7,8,8,6,6,13,13,14,14,13,13,10,10,14,14,7,7,5,5,14,14,5,5,15,15,7,7,4,4,8,8,6,6,0,0,14,14,9,9,4,4,12,12,7,7,12,12,14,14,13,13,4,4,0,0,9,9,14,14,10,10,14,14,13,13,12,12,13,13,2,2,2,2,4,4,11,11,8,8,9,9,7,7,14,14,2,2,12,12,12,12,8,8,10,10,9,9,15,15,2,2,2,2,2,2,6,6,13,13,9,9,2,2,1,1,14,14,12,12,0,0,5,5,6,6,3,3,10,10,0,0,7,7,7,7,13,13,8,8,13,13,0,0,13,13,12,12,0,0,2,2,5,5,3,3,5,5,14,14,15,15,14,14,6,6,6,6,15,15,0,0,13,13,11,11,8,8,12,12,0,0,11,11,5,5,7,7,4,4,4,4,8,8,4,4,10,10,10,10,1,1,1,1,14,14,2,2,6,6,12,12,0,0,5,5,1,1,3,3,10,10,4,4,6,6,13,13,0,0,14,14,2,2,8,8,5,5,1,1,4,4,9,9,7,7,5,5,3,3,3,3,5,5,14,14,12,12,14,14,15,15,2,2,7,7,9,9,12,12,6,6,4,4,8,8,0,0,13,13,3,3,14,14,9,9,6,6,2,2,3,3,14,14,9,9,9,9,0,0,14,14,13,13,12,12,3,3,12,12,4,4,4,4,5,5,9,9,15,15,3,3,0,0,1,1,2,2,13,13,6,6,9,9,10,10,3,3,6,6,4,4,9,9,4,4,13,13,0,0,12,12,8,8,6,6,13,13,14,14,4,4,7,7,0,0,1,1,5,5,6,6,5,5,3,3,15,15,14,14,1,1,6,6,10,10,4,4,14,14,4,4,5,5,10,10,15,15,7,7,10,10,9,9,1,1,2,2,2,2,8,8,9,9,8,8,9,9,15,15,1,1,15,15,2,2,5,5,7,7,7,7,8,8,4,4,4,4,6,6,6,6,6,6,3,3,4,4,15,15,4,4,2,2,7,7,1,1,5,5,7,7,7,7,7,7,0,0,3,3,8,8,12,12,8,8,8,8,14,14,0,0,15,15,8,8,9,9,10,10,4,4,13,13,12,12,2,2,9,9,4,4,15,15,8,8,8,8,6,6,9,9,5,5,7,7,2,2,10,10,2,2,6,6,13,13,10,10,9,9,12,12,14,14,10,10,11,11,2,2,7,7,0,0,3,3,5,5,7,7,1,1,4,4,14,14,2,2,0,0,7,7,3,3,4,4,3,3,3,3,12,12,6,6,10,10,9,9,5,5,0,0,2,2,13,13,10,10,3,3,2,2,0,0,14,14,0,0,4,4,8,8,4,4,15,15,0,0,7,7,4,4,9,9,5,5,2,2,9,9,5,5,14,14,1,1,1,1,4,4,11,11,2,2,9,9,15,15,3,3,9,9,9,9,3,3,6,6,5,5,9,9,1,1,15,15,8,8,15,15,2,2,0,0,5,5,4,4,10,10,0,0,10,10,2,2,2,2,4,4,1,1,12,12,5,5,15,15,6,6,1,1,1,1,13,13,13,13,15,15,11,11,6,6,5,5,4,4,4,4,1,1,10,10,2,2,8,8,1,1,7,7,11,11,8,8,6,6,5,5,9,9,13,13,1,1,4,4,1,1,4,4,11,11,2,2,10,10,4,4,14,14,12,12,9,9,8,8,1,1,3,3,1,1,3,3,6,6,7,7,6,6,15,15,13,13,0,0,15,15,6,6,11,11,15,15,11,11,7,7,12,12,4,4,11,11,2,2,15,15,2,2,2,2,0,0,10,10,6,6,9,9,2,2,5,5,9,9,1,1,4,4,5,5,13,13,15,15,12,12,8,8,4,4,5,5,1,1,14,14,7,7,7,7,6,6,2,2,0,0,13,13,8,8,11,11,6,6,14,14,15,15,9,9,12,12,3,3,11,11,3,3,3,3,13,13,8,8,10,10,14,14,0,0,12,12,0,0,8,8,8,8,15,15,10,10,12,12,3,3,11,11,1,1,4,4,2,2,3,3,6,6,4,4,11,11,8,8,9,9,10,10,0,0,9,9,0,0,15,15,10,10,4,4,2,2,6,6,11,11,6,6,1,1,9,9,4,4,3,3,14,14,5,5,1,1,13,13,3,3,7,7,9,9,13,13,8,8,8,8,5,5,12,12,6,6,2,2,12,12,0,0,9,9,9,9,2,2,2,2,14,14,12,12,1,1,4,4,1,1,9,9,5,5,15,15,0,0,6,6,1,1,9,9,13,13,11,11,11,11,0,0,15,15,12,12,1,1,6,6,1,1,12,12,14,14,10,10,4,4,1,1,13,13,14,14,15,15,4,4,9,9,7,7,13,13,4,4,3,3,1,1,2,2,1,1,14,14,9,9,4,4,10,10,12,12,4,4,5,5,6,6,10,10,6,6,13,13,10,10,6,6,15,15,10,10,6,6,1,1,5,5,3,3,9,9,8,8,6,6,10,10,14,14,8,8,10,10,4,4,13,13,12,12,10,10,6,6,0,0,6,6,0,0,6,6,0,0,4,4,1,1,5,5,10,10,14,14,13,13,12,12,3,3,13,13,0,0,15,15,14,14,1,1,7,7,12,12,15,15,12,12,12,12,12,12,9,9,15,15,13,13,2,2,4,4,10,10,12,12,11,11,4,4,15,15,2,2,7,7,3,3,11,11,12,12,3,3,8,8,14,14,12,12,4,4,14,14,2,2,14,14,12,12,9,9,6,6,2,2,10,10,5,5,4,4,10,10,7,7,4,4,10,10,0,0,7,7,1,1,12,12,3,3,0,0,14,14,14,14,15,15,3,3,14,14,6,6,11,11,13,13,14,14,10,10,12,12,7,7,4,4,8,8,3,