// This file is part of the FidelityFX SDK.
//
// Copyright (C) 2024 Advanced Micro Devices, Inc.
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files(the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and /or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions :
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// An Owen-scrambled Sobol sequence of 256 samples of 256 dimensions
static const int sobol_256spp_256d[256*256] = {32,226,72,70,57,171,246,75,112,81,109,239,120,101,230,103,103,41,249,86,253,99,132,184,214,147,128,248,17,149,163,17,60,40,169,196,77,79,102,23,250,77,75,151,95,123,234,198,25,26,184,114,230,188,105,18,231,233,175,151,19,174,202,71,84,229,247,148,182,127,92,14,41,112,162,253,35,101,137,30,111,134,95,122,28,2,41,254,181,91,101,188,145,31,166,38,53,193,1,122,99,86,178,36,198,169,113,255,97,221,227,231,29,100,30,141,250,254,16,157,2,220,187,95,181,125,207,187,105,119,156,41,16,194,93,216,227,124,138,90,227,1,88,153,233,69,120,36,19,189,120,4,185,220,185,109,184,96,247,173,210,227,54,3,18,9,139,213,156,57,61,101,37,247,21,201,10,143,11,38,146,18,118,129,95,191,75,207,12,252,238,104,47,39,190,229,31,56,20,127,42,178,100,141,93,222,192,247,186,7,224,161,72,100,87,69,218,44,25,195,185,118,179,123,231,170,96,225,204,52,117,60,3,86,25,143,230,18,11,165,72,188,158,3,66,105,50,200,226,145,227,45,183,62,82,176,191,36,248,191,189,122,96,185,146,166,203,78,144,189,67,174,154,182,86,169,90,236,101,40,71,107,81,93,159,82,75,230,157,191,34,35,235,139,150,193,10,142,217,77,154,249,74,13,196,248,56,154,27,6,242,226,105,94,66,67,145,112,31,145,133,68,21,0,44,212,254,153,183,238,98,102,145,199,100,213,196,52,131,141,216,209,236,122,58,249,188,108,8,206,62,199,207,103,160,247,207,255,101,185,1,113,223,126,182,0,50,93,250,174,194,18,65,111,206,104,156,3,48,195,122,212,10,101,235,200,13,183,173,7,192,3,101,228,84,168,121,241,205,122,115,132,155,242,215,22,236,242,69,35,48,245,3,175,68,57,4,15,226,155,222,140,54,48,80,200,194,149,213,68,225,14,182,122,147,195,69,166,191,17,176,58,222,58,190,70,66,153,196,215,121,123,176,190,161,145,203,121,255,27,207,28,113,22,44,232,46,84,181,131,245,220,27,202,161,38,94,208,39,143,52,5,154,85,121,139,226,223,159,246,170,56,94,209,188,71,205,76,16,233,168,172,200,37,19,123,120,202,28,175,232,88,120,107,157,198,111,253,18,24,36,35,43,169,199,197,137,194,12,238,138,232,17,17,58,115,39,234,4,164,225,215,14,185,232,76,215,171,142,206,206,132,90,31,130,24,0,165,34,91,126,113,64,202,144,114,132,125,58,184,234,211,246,238,168,7,1,172,169,218,67,29,185,66,73,49,222,167,243,189,36,116,23,223,219,200,84,67,94,53,79,26,202,204,91,180,221,166,106,18,207,17,128,137,246,235,162,13,129,130,49,76,104,189,138,55,174,71,152,49,116,204,207,103,198,147,225,142,79,8,172,59,234,225,192,168,181,144,185,6,233,243,61,123,46,55,44,16,228,79,156,235,190,115,61,162,115,182,122,230,138,204,140,86,173,80,99,207,211,181,23,141,152,17,180,35,121,168,67,205,107,74,55,229,234,210,6,94,48,186,210,189,2,200,190,181,227,128,211,225,215,228,74,7,188,195,36,82,10,131,96,99,138,63,1,210,39,134,153,112,72,163,196,55,126,37,125,107,234,166,129,80,61,97,121,20,123,222,3,155,219,62,49,207,87,182,26,214,167,142,89,38,36,112,87,100,56,245,240,152,23,7,237,11,185,206,233,203,131,42,53,35,60,40,211,114,9,13,189,130,196,210,173,39,208,56,110,34,240,65,75,234,76,73,34,39,2,118,174,237,52,194,197,28,155,161,135,180,200,3,89,210,26,154,145,45,57,54,85,26,118,207,212,58,101,69,202,184,36,234,219,155,41,29,80,22,193,175,145,100,50,29,149,166,168,162,213,130,36,25,234,78,84,97,191,139,95,156,9,12,41,97,110,222,8,16,250,161,130,45,111,195,83,213,16,141,154,48,124,175,89,25,27,9,172,242,51,167,76,109,69,107,23,80,23,166,12,16,180,156,182,238,148,249,59,130,75,122,59,134,240,69,220,21,230,47,1,124,66,180,77,247,147,103,66,98,211,96,105,213,127,178,144,102,213,33,247,141,232,67,62,86,230,222,146,68,122,27,147,7,85,69,31,22,67,67,78,13,149,221,57,121,176,133,161,84,201,146,119,196,217,19,132,52,76,135,247,107,29,131,248,220,156,248,29,41,36,202,174,136,253,191,226,91,179,96,69,213,172,0,206,75,192,54,69,120,138,218,171,185,232,211,139,8,31,11,50,119,28,197,83,158,170,229,244,195,190,23,213,87,70,17,102,197,39,59,88,152,234,95,106,29,195,236,114,136,6,159,105,101,2,119,184,47,212,218,188,165,163,138,174,114,71,54,127,64,183,39,51,42,209,202,106,96,215,154,56,33,102,25,62,111,9,49,4,98,142,198,128,138,13,74,95,229,42,164,19,175,179,111,138,19,157,125,94,34,221,103,246,144,141,176,129,201,55,100,23,12,139,33,227,91,223,224,69,120,83,245,50,57,190,21,54,86,245,95,250,34,71,249,100,201,144,16,221,0,40,74,133,38,145,48,217,119,132,34,138,67,161,62,221,126,108,207,140,42,156,13,224,198,142,19,55,85,254,155,140,168,250,58,118,137,42,78,8,48,89,195,167,91,243,246,88,23,22,206,17,190,56,125,171,116,245,129,121,57,144,228,159,197,243,217,239,86,188,152,88,239,112,120,245,119,147,189,25,128,240,72,208,29,162,23,152,24,143,226,136,174,171,58,178,10,5,250,209,239,88,62,34,251,156,163,231,247,102,112,46,48,61,233,24,71,54,73,12,81,195,243,115,138,145,194,164,135,148,51,201,104,74,24,78,107,65,246,118,159,165,130,206,34,157,177,180,10,126,163,167,129,75,0,149,115,172,21,242,139,162,170,92,238,35,46,24,108,101,62,26,147,180,210,227,166,103,149,188,192,92,115,141,161,120,90,231,250,181,130,208,232,151,157,141,208,27,81,82,42,162,244,186,62,163,6,254,94,107,138,123,144,14,216,138,235,104,135,98,77,82,57,47,77,171,213,192,134,69,226,93,197,9,63,181,197,169,22,248,190,55,178,250,167,76,157,101,170,138,94,156,44,12,155,102,133,133,149,43,224,51,130,44,138,3,195,25,161,29,216,1,188,160,73,4,196,125,240,92,88,50,192,176,234,39,109,96,39,60,165,226,80,248,179,232,244,141,102,81,131,110,19,206,225,222,115,198,63,195,251,19,155,77,51,194,251,124,13,77,69,106,112,114,187,126,67,222,81,227,163,80,172,25,70,205,111,48,160,111,165,112,243,47,236,107,81,15,83,95,132,80,133,178,116,87,10,195,139,151,122,44,82,111,24,234,156,187,202,250,20,233,186,204,184,154,149,117,78,205,119,71,166,192,239,88,148,154,229,200,139,163,129,12,155,167,252,50,198,46,106,221,91,235,75,2,14,240,122,62,178,218,42,223,213,6,17,212,242,32,190,96,163,121,63,228,65,111,229,63,70,140,232,221,248,216,80,5,145,12,27,33,195,86,111,42,125,70,44,232,82,209,40,234,168,224,215,215,133,247,128,76,248,178,34,253,61,204,193,105,44,227,66,45,238,159,16,241,67,99,178,235,181,68,204,234,144,58,40,132,125,203,25,204,148,151,253,195,198,81,8,54,248,148,248,58,54,235,82,71,67,181,212,241,43,111,111,202,69,166,200,66,87,245,207,70,112,64,26,240,149,82,86,28,104,17,59,72,154,106,1,173,59,21,204,184,231,15,224,161,253,174,78,249,25,217,35,144,180,57,102,174,57,138,227,125,141,246,16,35,201,173,170,31,107,205,169,59,19,52,209,226,49,136,168,13,238,63,53,78,203,68,18,146,228,165,245,244,84,215,78,230,167,83,239,15,210,34,99,90,184,143,187,50,98,95,182,121,47,53,112,15,53,239,130,105,66,142,11,185,224,203,20,44,156,28,197,195,65,118,36,206,88,55,37,18,112,9,20,231,73,6,11,225,79,180,145,124,204,29,245,148,198,53,210,171,103,53,215,106,111,154,237,107,2,249,79,145,126,255,255,53,222,196,57,237,131,6,63,45,70,68,190,191,12,210,247,162,41,135,184,234,206,153,176,115,255,114,178,110,24,25,66,114,55,29,79,253,67,124,245,37,236,13,88,232,186,18,143,178,59,5,237,10,249,253,37,88,46,134,71,53,74,172,186,69,137,11,154,60,68,120,125,100,91,182,239,177,38,28,125,208,165,38,150,207,244,41,88,127,241,251,168,84,195,111,37,211,165,113,3,212,184,180,207,48,52,204,171,213,128,154,138,218,69,214,154,99,201,203,109,93,71,190,5,99,1,72,173,15,149,49,253,51,82,171,179,114,131,68,114,133,15,104,227,141,109,39,68,225,130,50,51,133,154,148,48,28,230,9,43,157,50,133,203,239,37,160,233,120,54,20,116,57,174,116,158,45,8,196,14,200,80,203,212,233,1,0,88,172,214,196,22,192,224,142,138,146,230,105,100,153,155,112,241,124,26,71,253,143,4,191,50,49,88,226,25,142,141,13,12,50,159,122,211,42,168,23,217,253,218,151,135,3,152,114,102,191,76,186,42,124,70,19,56,25,85,234,58,57,225,230,253,56,194,107,134,142,201,213,43,14,33,242,16,141,205,196,99,143,100,115,5,99,128,100,221,174,110,191,83,165,164,78,60,124,209,199,63,185,120,175,43,3,24,40,153,1,83,147,223,112,72,242,148,166,115,36,138,42,13,63,1,45,173,225,83,121,19,23,208,171,146,240,108,150,3,213,83,210,238,72,120,80,197,2,4,159,197,138,216,19,178,24,173,212,237,169,129,129,102,51,63,203,142,11,134,180,207,105,98,133,253,20,224,6,126,194,167,33,132,90,101,179,113,216,222,132,30,88,23,229,210,85,6,154,226,252,17,39,174,208,255,8,11,252,159,110,195,86,250,59,161,218,31,140,167,41,33,201,143,250,68,82,205,44,4,77,43,214,212,60,82,214,41,44,125,236,152,34,64,133,184,58,145,227,65,70,73,166,49,21,158,242,114,42,75,209,36,72,188,192,146,223,138,76,27,235,115,153,105,169,96,209,231,4,33,105,226,175,187,91,218,12,73,168,214,254,98,208,113,214,116,177,49,34,94,22,127,175,12,155,193,56,187,115,187,240,136,234,206,189,250,115,219,154,17,52,62,198,63,225,81,77,90,127,246,219,192,106,223,78,102,88,142,46,208,156,230,196,67,182,18,112,210,126,198,59,15,234,166,243,77,61,149,24,223,70,245,142,178,199,101,195,190,109,78,244,224,12,84,52,158,184,88,212,155,159,128,187,54,48,209,190,202,157,70,122,109,33,221,124,227,1,196,124,121,163,138,238,25,129,134,83,111,124,60,142,46,143,48,85,63,5,77,46,251,193,209,81,108,149,108,1,47,137,175,85,106,148,27,204,145,104,3,152,84,228,215,113,141,6,117,115,151,206,248,61,43,182,198,76,88,12,222,132,75,73,8,205,190,32,12,159,70,205,4,158,0,107,220,104,90,223,181,80,7,111,166,130,16,168,145,218,242,101,35,165,172,12,217,239,157,76,37,238,176,63,124,243,45,101,181,191,200,64,186,170,42,104,154,191,224,67,145,240,72,82,103,93,108,220,251,36,178,110,145,98,136,83,2,171,177,220,23,98,221,2,160,216,219,237,90,105,255,48,157,136,55,102,122,181,7,225,55,229,254,215,169,94,22,44,65,136,50,190,151,198,54,132,81,245,106,71,91,141,176,162,15,210,33,14,140,108,81,17,135,249,17,44,15,121,28,16,114,178,210,7,129,250,11,239,18,86,203,161,124,2,185,178,83,110,168,3,81,125,80,149,8,67,30,212,0,129,8,77,255,114,243,68,8,119,210,232,104,244,127,165,159,26,176,206,160,228,34,116,10,3,91,65,149,163,43,43,44,171,113,113,223,206,17,63,64,215,216,94,118,5,139,66,201,213,30,120,149,18,236,99,41,81,175,245,1,7,171,209,151,134,28,32,122,201,13,18,46,236,215,113,188,192,221,39,69,117,121,255,119,26,59,142,121,126,238,179,163,183,245,98,199,32,46,39,137,236,232,52,138,4,60,86,83,12,100,44,195,49,107,228,105,56,183,18,177,222,50,189,188,97,197,148,94,99,1,198,221,121,206,54,31,212,145,62,73,77,213,189,38,66,13,139,69,173,57,26,11,176,245,141,166,141,203,10,48,45,201,17,131,241,115,13,165,235,28,129,88,72,36,124,169,128,6,145,10,109,219,198,187,90,149,67,215,68,116,33,56,204,217,236,231,0,205,84,97,113,175,30,185,95,187,166,164,123,103,0,218,18,150,180,103,151,153,146,97,15,161,171,246,252,131,198,186,58,55,210,93,58,157,3,142,220,98,50,202,151,2,115,205,200,3,236,146,210,233,71,222,129,198,18,131,29,157,152,63,201,45,197,253,170,121,124,232,64,197,112,22,208,106,99,54,41,247,146,135,234,142,177,3,38,157,234,222,46,189,233,76,41,150,255,135,82,99,244,246,187,81,215,16,76,188,188,104,156,21,239,255,206,97,35,217,194,13,70,106,106,238,171,232,93,223,145,190,50,39,144,48,13,113,146,151,178,156,18,131,231,168,108,178,224,7,44,122,98,87,166,65,220,174,138,98,95,93,188,127,246,195,136,215,160,201,137,35,217,167,126,219,175,109,180,111,127,222,93,69,133,2,58,198,186,238,108,57,157,101,174,249,26,46,210,254,251,76,43,197,209,161,52,197,28,246,173,229,35,43,13,81,122,34,245,212,223,50,135,69,70,192,171,78,9,135,189,54,168,232,131,250,208,59,227,252,247,231,40,235,203,254,51,25,198,223,165,81,140,141,67,194,180,31,194,172,47,195,56,153,118,221,30,217,17,85,154,184,122,15,130,179,86,8,37,33,200,95,144,73,175,68,185,197,128,182,154,171,147,182,86,172,23,236,20,92,194,110,253,124,133,82,127,206,92,34,108,69,170,47,61,41,87,108,218,3,244,7,124,51,153,83,186,164,116,154,85,123,43,135,177,107,28,189,81,241,214,189,235,233,142,6,109,183,130,75,79,107,99,67,31,164,248,227,114,159,230,115,116,115,252,33,75,4,171,191,217,88,245,156,203,48,239,140,253,211,46,184,136,34,21,248,161,128,156,16,88,64,71,34,174,125,70,164,125,92,205,214,79,157,199,223,143,214,138,213,150,169,17,16,181,95,200,208,91,91,55,125,7,1,39,91,6,103,252,246,22,71,110,149,236,73,1,247,51,2,168,88,124,234,86,100,6,94,1,17,215,157,34,238,126,194,222,109,67,175,96,45,252,99,58,3,34,192,251,95,240,36,188,243,191,229,74,164,55,171,108,239,73,208,140,114,46,244,36,30,33,56,14,209,94,86,28,9,153,30,23,102,165,252,98,77,72,233,22,126,152,98,40,246,35,93,137,114,191,114,200,54,214,8,238,145,43,119,180,186,55,74,170,232,166,247,56,233,9,162,16,241,95,47,5,109,72,125,67,35,130,55,138,75,157,246,85,244,3,230,60,226,159,12,234,155,160,180,119,243,253,179,202,194,53,218,65,208,230,212,71,228,29,49,220,31,146,244,249,84,46,237,203,93,171,73,33,115,46,109,10,163,137,73,18,133,213,236,174,230,216,119,127,80,199,18,100,180,236,191,127,152,158,226,45,72,70,181,106,90,21,229,46,41,109,55,237,81,0,158,169,63,40,22,85,246,181,235,161,180,28,175,136,87,132,184,54,121,185,69,89,58,20,54,81,101,87,37,251,152,4,162,108,113,248,178,219,151,240,144,158,242,185,138,4,34,148,255,250,66,75,144,141,25,248,244,89,180,203,97,141,149,179,129,213,186,64,101,242,119,130,121,108,230,198,74,228,155,96,237,140,201,158,44,127,161,120,219,94,11,95,27,145,80,184,107,215,88,252,32,89,59,97,159,249,183,75,131,180,65,184,179,85,80,88,74,128,53,126,191,54,169,0,133,100,248,196,158,91,121,110,12,248,130,87,248,186,85,136,101,181,0,90,45,34,227,84,17,40,96,221,187,167,131,112,48,70,62,240,138,78,245,248,226,203,255,32,242,246,141,200,17,167,32,151,12,72,159,221,190,56,115,237,233,226,113,71,228,167,60,113,127,28,174,27,176,227,160,77,221,157,64,14,166,82,60,78,7,91,16,214,169,78,222,97,33,229,210,4,255,104,234,42,181,7,177,190,23,40,135,53,67,63,28,151,60,167,81,21,190,110,214,160,222,51,228,87,83,113,220,46,182,163,193,79,214,249,120,197,244,197,169,252,20,33,253,246,46,198,16,208,35,110,5,37,236,172,149,234,155,32,36,8,249,70,224,226,40,16,146,131,224,173,250,111,102,227,160,196,255,167,81,196,62,24,6,39,4,245,139,98,158,201,247,5,6,2,61,92,5,65,70,24,206,135,30,246,146,155,22,29,247,25,112,186,5,208,134,240,95,137,29,48,148,222,92,36,165,248,10,244,222,158,131,46,156,217,243,219,101,123,98,209,124,89,178,16,48,173,142,241,134,127,160,217,64,134,35,244,28,253,59,26,10,212,162,143,252,94,0,198,0,16,156,116,145,64,255,206,234,251,104,250,213,247,171,89,86,125,48,237,216,196,160,45,90,227,12,33,58,31,88,200,117,101,36,105,135,49,134,64,181,233,40,63,100,189,192,13,48,58,159,183,105,34,162,170,166,132,83,141,116,29,39,216,84,29,224,211,54,145,251,248,148,150,203,26,51,179,47,134,175,80,66,223,24,221,52,170,59,241,37,95,232,183,15,162,203,144,221,60,248,8,211,255,78,249,55,59,23,131,11,165,152,182,82,168,71,89,48,249,78,107,182,117,73,21,79,42,128,232,89,103,207,13,224,32,236,175,138,201,54,26,98,122,91,253,144,222,108,171,101,120,208,168,40,29,46,64,23,171,248,115,40,80,28,107,143,65,188,142,205,155,234,86,121,157,124,23,44,177,188,201,222,229,244,169,241,155,62,102,187,15,28,49,168,157,29,135,202,9,160,102,125,112,184,31,209,162,114,13,130,215,93,15,255,110,50,54,19,144,98,47,46,170,252,210,5,161,176,69,185,97,187,253,94,124,215,85,69,73,136,150,68,137,217,52,113,151,241,70,44,102,126,10,143,167,133,81,239,233,109,73,171,141,93,133,112,185,133,103,206,49,208,130,79,127,234,48,173,231,82,200,74,68,194,188,185,26,56,199,134,122,3,153,227,174,245,23,34,49,20,68,184,202,1,232,252,31,171,45,85,7,114,187,66,203,169,98,117,144,15,165,104,143,111,174,100,197,60,7,53,248,238,100,12,162,96,40,189,247,101,64,57,57,14,195,114,229,155,228,32,111,37,141,8,8,163,2,223,6,96,54,144,175,85,141,51,77,41,60,192,113,15,103,101,44,30,102,189,100,251,227,71,37,62,123,4,63,119,25,116,47,205,191,156,1,106,136,248,37,151,162,72,226,41,208,133,69,146,114,137,43,245,90,115,117,90,122,134,180,218,136,10,36,210,53,138,90,139,213,130,56,173,119,174,71,72,213,138,87,171,101,156,110,0,164,38,191,156,215,148,220,106,138,50,237,54,37,49,215,127,45,81,226,61,181,195,147,154,208,170,94,34,8,228,121,71,182,239,63,56,65,244,0,70,162,73,198,63,16,134,216,58,187,203,234,115,44,209,105,127,183,130,74,82,203,219,128,128,162,13,47,106,252,31,56,155,184,119,56,139,70,241,3,104,153,43,183,28,68,241,224,25,154,52,51,131,108,142,150,13,106,43,251,166,76,47,218,150,11,125,109,109,179,145,213,217,241,16,32,208,48,33,217,59,171,245,248,174,34,191,77,111,183,221,49,141,59,221,76,224,103,190,107,171,215,232,44,84,133,236,88,227,175,24,57,144,252,229,182,140,36,219,42,92,101,187,212,188,34,205,167,99,168,91,224,154,187,112,52,190,62,212,191,250,250,68,229,248,142,143,161,185,243,117,222,69,61,162,247,179,140,133,135,164,217,144,222,8,114,20,240,161,44,27,187,82,122,237,53,167,43,2,215,122,219,61,163,54,181,154,176,222,239,12,13,63,88,213,167,98,162,94,254,89,113,112,242,88,158,65,229,215,16,126,234,96,129,34,233,231,85,152,90,16,97,32,90,134,18,131,114,130,148,249,76,135,186,171,103,192,83,45,100,96,36,88,217,197,165,86,194,168,112,149,125,108,133,112,117,199,26,221,35,245,88,233,9,113,47,138,31,61,114,47,51,32,197,55,17,175,164,93,204,223,215,203,221,224,147,103,78,214,230,214,71,214,220,169,117,39,0,147,198,108,242,153,155,144,235,250,162,35,53,61,45,156,227,244,108,123,32,227,129,77,252,146,213,168,197,237,147,123,38,228,75,144,165,144,102,113,198,22,145,14,101,195,177,43,62,151,113,96,81,189,204,180,207,197,24,72,76,135,127,181,246,81,18,167,113,85,184,62,190,140,86,209,148,134,111,32,60,108,33,233,115,99,216,239,112,146,92,217,236,252,213,215,98,122,215,64,175,155,179,121,195,7,207,252,163,51,58,143,187,255,188,122,6,199,73,36,149,218,141,142,43,108,99,2,232,187,65,216,24,169,125,102,148,113,59,233,176,194,207,77,204,245,20,43,145,104,88,88,212,187,237,152,64,18,141,254,53,255,111,53,61,62,49,143,145,197,10,207,36,198,166,88,7,199,42,201,145,219,135,53,239,108,162,82,202,181,4,255,82,23,38,141,213,120,0,218,105,2,141,120,255,138,20,27,255,97,202,151,0,166,227,16,196,48,139,91,164,4,170,177,243,27,154,220,212,167,205,179,84,245,205,50,51,155,45,39,99,124,70,27,48,182,173,3,26,38,214,1,26,23,216,248,214,89,78,142,7,44,2,118,103,73,72,202,187,222,242,74,37,84,166,251,191,67,11,231,116,61,33,17,96,93,116,165,173,88,153,105,123,125,159,243,89,143,66,211,213,23,47,204,192,2,231,229,224,32,30,45,9,31,149,216,137,119,152,34,22,131,206,47,216,201,89,197,58,66,204,67,92,0,150,199,161,213,185,96,252,164,78,46,247,41,134,48,118,14,77,30,250,176,12,138,96,58,51,142,9,249,103,99,29,247,189,31,126,29,86,211,201,108,216,195,90,32,119,124,219,207,128,192,119,91,217,60,215,24,182,244,100,241,153,24,3,99,115,167,33,25,239,186,42,198,202,179,57,117,112,11,208,212,50,26,170,22,148,206,252,232,159,56,64,37,184,40,232,109,62,164,199,64,198,112,56,71,12,215,108,220,20,211,118,70,182,19,212,219,182,104,5,188,255,61,162,241,25,176,78,25,176,239,21,205,246,214,246,86,45,101,158,9,252,149,38,59,72,225,119,121,209,20,85,6,84,253,24,182,126,20,150,105,176,238,54,59,96,46,28,214,21,80,112,19,118,125,115,134,244,30,35,230,238,255,199,220,32,200,9,142,2,182,14,101,191,176,143,96,217,200,124,194,43,105,61,93,143,135,53,12,228,233,30,150,173,228,73,179,184,84,21,117,63,245,231,49,129,29,249,46,23,172,195,94,36,76,227,246,71,159,188,8,88,119,49,177,156,203,88,101,195,170,151,183,106,100,9,246,64,254,1,90,4,9,163,154,231,88,68,182,99,67,75,171,107,142,196,79,237,114,70,178,128,33,83,168,67,129,82,214,135,38,206,41,152,140,168,52,239,28,171,28,29,180,246,185,183,243,85,129,112,168,63,139,133,0,162,86,166,48,132,244,159,151,235,175,64,110,168,85,97,233,11,62,25,177,16,57,124,63,250,59,218,136,209,136,192,23,168,160,206,65,84,30,73,213,235,181,104,66,27,98,126,183,219,93,200,115,84,141,57,55,20,131,91,14,228,85,181,19,4,110,176,90,101,40,91,107,155,7,70,21,114,154,141,146,125,246,64,1,216,213,232,23,143,224,115,244,247,144,186,71,134,69,183,141,25,186,91,29,145,163,250,202,181,57,216,172,131,228,242,181,187,52,94,218,252,4,118,44,52,124,160,37,176,17,218,121,140,191,107,102,91,222,49,91,229,106,179,221,170,200,88,38,138,167,10,48,157,47,99,57,137,88,76,206,141,214,208,48,80,226,18,227,6,175,180,63,107,247,251,197,59,51,247,13,109,209,162,206,192,125,112,94,235,247,26,88,14,126,241,225,249,81,162,7,157,238,150,138,24,69,121,155,219,17,169,180,218,93,230,99,92,139,53,179,145,30,14,205,171,75,247,49,194,3,14,177,24,222,122,30,75,174,121,243,104,233,244,81,4,47,70,43,206,113,229,119,231,49,72,144,78,214,29,193,41,75,14,97,19,84,148,246,3,250,243,7,246,233,153,48,135,226,204,199,93,210,3,97,11,106,117,170,122,92,97,150,179,177,220,46,59,17,151,242,160,233,237,81,78,255,87,243,237,113,135,216,131,97,197,224,41,142,85,234,243,135,58,152,220,191,227,149,78,77,30,82,167,63,217,43,227,106,173,223,128,161,49,70,29,184,169,178,179,124,224,2,243,210,229,112,103,15,29,78,229,91,9,68,198,94,135,241,207,69,183,229,46,78,63,189,93,163,10,91,172,13,205,180,217,216,102,237,239,3,217,247,218,0,147,130,158,175,242,39,94,23,238,221,229,211,72,140,103,207,7,73,10,200,247,155,254,35,165,152,2,137,237,154,128,235,215,210,1,132,104,143,128,91,191,225,241,171,220,16,165,209,59,10,1,128,151,229,116,17,20,188,108,57,196,105,197,5,64,216,75,255,49,10,35,243,39,238,142,201,1,32,8,28,116,21,216,226,89,90,231,210,128,81,149,93,249,111,150,128,11,228,231,236,178,74,34,174,187,230,84,78,197,136,17,197,25,242,154,123,24,78,245,178,254,76,70,182,72,15,115,54,62,10,89,172,129,113,97,148,204,240,100,172,169,122,13,95,182,26,184,25,191,255,250,250,137,18,19,72,145,135,112,125,227,63,65,26,54,228,181,30,158,27,191,9,236,168,115,248,144,187,132,253,45,84,154,196,103,30,149,123,53,42,206,172,146,175,44,203,69,239,45,147,0,121,103,125,132,136,192,38,62,79,29,241,17,151,110,28,38,221,234,230,228,182,64,241,144,165,124,145,120,49,50,129,18,33,242,212,143,68,167,109,134,179,113,176,85,93,87,105,133,15,66,249,8,43,9,147,72,30,6,2,85,185,204,160,20,76,70,119,163,67,200,121,228,185,204,22,48,31,122,177,123,93,159,108,114,65,90,91,67,95,139,6,187,3,78,142,38,96,61,68,23,146,93,32,245,153,131,61,126,1,194,201,158,51,161,172,0,176,76,143,229,81,201,36,157,210,139,109,215,12,9,41,152,243,188,240,144,194,27,114,193,162,39,43,9,203,46,137,76,217,93,125,215,74,43,75,0,153,246,95,88,44,134,248,43,87,166,46,133,1,77,197,205,206,31,50,102,178,248,22,226,192,156,203,195,155,193,32,35,158,173,76,75,79,240,112,7,161,130,162,85,225,67,223,15,127,53,24,49,231,201,248,16,114,146,228,17,178,247,166,162,2,32,180,41,188,9,197,103,77,246,35,30,71,112,6,222,168,64,60,248,242,61,201,130,219,58,182,38,143,103,45,104,219,7,121,119,138,183,148,149,107,216,169,2,89,111,185,120,49,74,173,174,35,38,194,214,86,32,216,229,123,41,64,108,178,152,13,174,71,86,192,147,84,112,246,98,151,238,63,210,134,112,5,28,254,154,125,236,82,78,22,114,230,212,88,97,54,211,70,203,48,159,59,21,36,55,56,141,194,247,133,160,138,224,66,180,74,137,37,94,5,120,135,170,119,209,147,221,28,19,215,139,29,199,87,234,102,225,111,74,180,27,169,131,129,29,44,138,81,235,206,181,229,133,192,201,163,110,48,203,245,95,200,183,29,29,31,255,74,216,148,92,109,191,130,29,236,248,204,126,228,208,76,200,13,128,197,198,255,211,23,197,132,124,133,71,155,21,132,233,191,189,212,255,108,47,94,109,53,232,234,95,174,83,223,18,188,255,239,215,139,141,51,127,243,199,103,111,117,45,101,67,184,104,196,20,34,25,184,251,144,47,226,217,214,217,125,47,52,41,242,113,104,13,56,74,44,166,36,63,154,133,145,18,80,160,124,59,47,48,219,63,43,134,67,115,238,189,252,67,6,164,83,181,123,230,213,252,7,222,130,221,30,79,68,34,162,2,61,134,162,207,49,146,161,216,82,98,181,190,57,57,164,128,97,121,148,131,128,152,66,106,247,15,154,148,82,42,174,142,17,249,123,23,138,78,106,245,159,202,19,26,160,50,138,153,136,182,101,89,247,195,169,69,220,50,155,45,140,251,248,183,139,84,17,44,98,83,13,102,234,106,135,22,255,212,246,163,28,11,251,123,18,5,150,221,6,2,137,17,176,56,215,12,166,187,52,149,11,97,119,140,245,13,201,20,98,80,27,26,125,126,58,232,231,83,52,195,75,116,248,147,230,123,171,77,81,168,163,120,39,158,18,54,60,212,117,67,148,122,151,78,51,30,88,27,152,83,92,191,105,162,106,233,12,27,116,4,53,100,189,242,253,169,182,10,105,196,84,229,122,141,80,15,0,38,26,50,176,229,18,32,169,241,202,190,190,225,100,193,44,196,209,193,83,89,43,228,8,127,48,9,221,186,199,251,97,138,218,190,131,202,206,62,148,128,44,48,107,164,177,57,149,171,214,244,57,198,194,87,179,232,10,17,65,243,255,109,19,208,42,55,68,178,164,84,21,57,206,5,27,252,203,144,108,90,231,137,198,221,204,164,204,56,73,223,129,127,246,244,144,140,13,229,195,199,39,42,93,103,202,8,45,68,203,17,186,154,9,154,228,59,255,134,120,125,170,90,18,141,31,17,116,10,189,48,63,147,112,188,11,184,92,95,253,180,92,80,106,57,112,187,229,228,69,3,1,47,47,72,146,48,135,37,111,82,27,20,77,157,222,115,123,120,119,159,196,99,7,116,57,222,119,79,79,212,213,215,145,225,154,187,25,22,126,89,170,169,123,159,94,29,177,63,137,207,167,192,97,134,193,17,236,199,8,35,214,220,156,72,183,180,8,63,200,171,93,216,103,110,145,159,209,158,236,233,50,228,220,144,113,159,214,222,157,156,27,133,183,240,127,191,28,41,222,148,155,247,32,97,96,128,237,98,236,159,107,157,192,176,19,81,248,145,219,183,179,73,178,81,38,137,81,108,189,148,180,164,63,244,107,140,13,253,2,84,88,16,121,200,120,77,203,104,24,207,202,194,62,253,155,102,96,168,116,28,237,163,138,91,149,34,82,230,211,109,230,176,130,28,82,186,233,159,99,238,249,81,38,106,243,246,4,63,80,43,104,47,1,253,236,84,79,158,5,81,26,18,242,70,42,11,229,216,154,236,16,203,159,227,7,207,120,26,197,81,87,177,4,32,197,147,111,255,229,91,211,194,195,230,35,169,151,31,196,33,181,120,192,254,71,84,152,228,208,209,129,98,55,39,210,144,146,192,231,249,121,170,81,218,202,197,150,149,234,93,90,178,167,209,244,86,25,140,141,156,206,14,247,240,217,14,39,99,82,121,16,119,157,210,169,220,50,58,255,48,130,189,120,154,59,60,85,94,135,23,15,171,6,31,212,224,89,73,100,179,91,61,170,128,28,33,227,9,149,128,12,110,120,44,9,52,192,4,24,65,221,114,24,77,109,0,237,94,4,42,232,84,150,134,32,50,33,84,234,130,136,89,117,253,79,60,135,69,29,50,128,196,38,41,43,37,78,168,73,163,249,45,207,177,76,38,115,76,143,118,145,106,166,6,142,230,193,147,145,87,195,222,73,219,219,89,33,68,237,118,120,146,164,74,130,237,16,47,79,228,9,153,184,5,127,80,182,81,105,196,51,244,192,237,160,118,200,191,94,235,152,191,202,161,231,171,19,116,102,94,206,253,175,4,193,18,70,53,214,98,123,181,137,167,190,84,96,169,2,204,232,54,221,169,175,186,172,137,170,75,32,249,57,119,86,19,52,123,234,142,11,108,19,58,84,98,250,242,114,170,31,205,195,117,12,243,41,93,222,0,101,219,102,129,196,192,91,8,186,233,243,37,194,183,162,121,59,93,71,52,178,114,96,72,252,185,254,109,31,107,112,168,64,226,160,216,43,49,74,50,139,112,148,135,148,88,184,35,26,29,171,245,47,96,61,39,146,159,194,252,57,202,244,245,218,216,18,29,71,237,39,25,197,164,184,67,97,53,45,16,218,207,244,97,249,96,167,93,62,103,162,164,67,186,159,2,26,136,32,184,9,167,169,183,210,72,43,253,167,72,211,171,205,117,92,82,32,5,197,107,8,68,106,237,8,142,148,101,227,90,210,67,13,252,233,3,242,79,95,172,175,195,246,251,254,247,71,7,224,252,37,255,4,158,178,131,23,77,77,22,178,114,155,151,162,207,53,98,63,132,143,232,73,194,185,91,243,57,47,83,36,154,42,31,150,56,15,33,40,14,111,70,137,225,158,138,108,119,114,255,48,176,231,182,51,219,163,86,122,80,104,197,169,107,181,97,55,228,63,47,73,106,27,23,65,207,177,34,218,221,147,192,237,165,74,89,152,255,181,169,250,226,99,10,232,6,181,45,3,222,174,26,248,155,12,199,237,65,205,85,22,125,164,146,124,17,73,140,71,36,57,173,173,157,157,161,35,164,157,190,71,67,29,142,133,206,231,64,185,95,111,65,166,220,233,245,73,242,25,16,29,223,124,142,199,177,13,24,198,245,218,190,115,38,32,45,236,12,96,101,63,17,230,151,217,117,234,153,112,111,91,162,196,247,185,166,60,2,8,145,56,160,48,175,226,250,67,51,132,106,42,213,138,119,167,9,240,25,8,56,22,165,218,9,62,218,121,29,43,177,130,210,166,150,15,220,225,225,152,34,255,104,115,223,108,131,55,250,255,49,92,130,20,179,218,73,38,116,122,102,17,118,237,183,109,65,232,122,235,4,68,3,245,160,150,224,73,183,115,6,100,124,166,210,201,82,249,142,15,23,20,60,118,137,170,181,229,205,108,201,240,169,87,195,99,76,138,15,228,158,47,216,146,8,248,175,110,207,39,94,180,173,250,47,24,2,201,150,241,233,238,16,120,75,140,84,49,212,106,98,213,162,86,181,76,170,35,124,116,48,164,197,74,131,117,229,28,19,139,154,0,123,202,110,178,10,79,113,166,22,172,117,191,54,48,27,183,59,223,105,57,148,54,241,188,72,118,58,255,33,235,238,206,33,254,197,162,45,154,226,221,57,145,225,19,36,11,164,245,79,188,132,50,190,248,255,75,183,214,242,69,109,232,147,130,166,70,86,58,124,161,96,88,92,166,32,184,117,117,232,148,14,163,81,163,242,0,239,41,82,240,105,189,74,68,200,164,195,85,62,74,56,226,196,41,2,105,154,95,205,207,232,106,98,226,99,112,210,188,162,203,188,28,65,78,18,252,134,93,120,74,188,64,154,12,133,146,228,14,25,9,13,157,22,83,145,169,201,189,221,137,49,232,138,179,182,165,146,2,109,172,21,172,40,157,230,199,70,170,17,231,133,250,192,45,75,214,33,111,3,120,209,54,12,206,159,226,150,136,96,94,25,66,56,178,106,7,73,214,104,156,236,28,249,93,15,229,9,0,132,16,69,155,125,179,207,94,14,13,244,207,241,54,32,52,63,98,162,154,191,75,209,229,33,193,255,57,31,229,86,153,43,207,166,165,245,54,40,212,29,222,70,136,130,40,74,185,218,104,130,108,129,245,188,86,215,76,131,33,190,168,234,99,175,11,251,216,73,187,108,44,255,201,238,119,247,44,86,81,235,45,3,57,216,75,34,73,180,36,35,240,164,214,36,117,135,41,119,211,38,76,81,196,8,21,97,136,235,119,71,123,36,176,199,227,228,108,128,149,137,5,164,77,148,159,81,47,176,108,234,54,46,235,56,167,178,84,254,105,129,190,49,65,57,236,213,149,152,10,85,206,195,221,92,221,54,74,114,134,198,83,208,132,62,75,99,76,23,147,221,170,238,47,2,231,238,159,31,157,21,230,120,116,37,205,171,183,193,105,172,143,117,1,93,76,23,54,218,89,41,8,34,70,14,172,247,13,165,93,149,104,106,13,209,88,202,31,127,1,56,213,196,57,128,219,160,128,36,102,11,50,241,144,120,109,249,181,6,101,158,193,159,198,121,72,53,117,201,226,238,36,19,89,190,170,97,242,166,133,255,187,116,117,149,110,240,34,46,115,10,173,23,253,193,26,88,218,204,250,37,212,109,250,201,191,194,118,95,136,247,161,207,241,204,135,2,78,149,74,112,131,147,47,174,61,6,17,165,170,245,205,230,27,4,219,42,253,132,224,5,105,216,149,164,189,139,111,218,70,124,62,36,131,167,58,160,166,166,15,182,6,55,43,51,18,46,56,174,90,10,0,14,29,74,85,33,208,147,69,176,90,198,106,36,37,30,25,35,124,178,130,4,84,25,198,20,229,53,83,27,191,7,155,221,115,87,5,220,83,80,84,102,251,48,221,102,199,149,98,72,199,4,97,43,61,78,97,140,141,115,8,36,76,209,170,73,151,35,27,50,135,70,240,173,0,121,54,23,163,78,109,212,129,93,171,216,134,28,83,113,141,233,192,101,187,144,201,55,84,241,226,162,50,111,152,243,114,9,111,93,4,89,234,55,65,28,241,78,143,188,189,252,70,80,238,69,204,212,181,122,171,109,189,186,144,136,240,116,95,234,155,53,70,170,203,113,36,46,45,134,195,163,140,104,104,25,181,136,167,116,55,237,25,77,120,91,44,239,159,52,190,41,227,220,175,171,101,213,127,105,222,163,58,68,40,210,118,247,1,76,42,20,189,248,76,43,113,25,81,37,26,154,234,25,226,251,39,69,143,3,138,235,220,47,9,31,25,63,195,193,72,173,92,80,43,152,143,80,74,126,49,33,238,113,228,171,168,241,82,49,174,116,73,94,130,72,230,253,161,187,183,237,195,41,153,143,130,252,152,169,147,185,106,2,207,13,134,90,175,141,157,242,255,161,154,42,107,178,145,195,16,211,119,181,175,211,84,142,39,77,187,239,159,12,177,186,243,150,95,140,58,167,52,103,146,158,98,247,173,141,219,214,180,87,55,184,155,216,203,67,81,243,45,171,219,220,110,144,106,5,138,225,212,232,110,202,220,68,84,250,115,120,118,200,167,154,108,73,90,190,72,34,47,249,229,114,4,80,142,144,22,68,254,128,128,196,171,194,100,131,176,168,30,203,107,42,65,59,156,176,21,156,53,86,125,203,58,216,87,127,233,238,153,162,195,175,35,133,212,69,25,61,96,246,99,19,132,120,219,58,140,93,223,248,9,43,246,147,166,10,33,40,237,26,6,87,228,81,182,159,34,234,48,74,27,30,186,36,136,63,92,110,3,131,130,27,239,155,0,156,219,146,232,148,189,133,204,227,35,102,6,13,242,251,69,127,251,171,127,248,242,116,126,174,84,115,6,193,135,29,128,225,230,162,23,222,79,106,4,26,156,61,251,88,57,81,76,237,7,19,107,37,95,147,230,99,193,76,98,87,252,124,217,105,200,201,204,245,189,226,154,95,54,19,34,64,85,66,163,243,6,203,46,201,0,174,183,154,181,226,46,152,199,255,75,54,243,29,83,133,231,240,6,21,38,68,184,253,109,54,23,224,31,102,11,112,103,43,17,38,125,238,71,104,161,159,219,136,215,196,141,170,10,56,156,93,207,152,188,114,22,157,0,165,25,138,205,58,248,67,193,58,28,147,32,38,229,221,175,114,14,42,161,2,223,231,204,164,6,92,49,52,64,37,164,223,252,197,118,55,243,108,10,158,239,219,175,244,102,22,194,134,212,9,249,244,43,86,97,41,53,9,224,110,61,250,140,202,187,95,171,204,21,221,58,141,24,176,120,96,194,232,84,28,125,246,218,142,73,131,254,249,22,179,71,110,208,97,247,139,162,171,64,251,79,190,180,190,186,29,110,165,88,119,225,30,58,64,49,68,45,83,93,122,136,199,146,158,106,5,211,222,64,64,160,74,72,185,138,112,186,135,133,95,31,236,77,86,54,59,235,32,245,245,133,152,27,233,115,154,253,233,222,36,218,216,218,211,137,127,103,199,95,165,151,234,33,228,72,167,103,13,43,119,38,71,23,218,227,177,230,222,214,149,81,102,246,94,251,84,233,90,116,77,26,118,194,122,55,75,208,137,52,159,238,73,8,33,157,218,178,213,108,45,131,207,210,31,144,133,204,239,144,183,230,251,195,57,195,154,39,61,36,39,117,126,121,69,224,198,15,198,98,59,82,181,202,28,149,49,219,53,48,163,19,164,57,251,219,61,159,235,12,121,100,151,160,191,93,194,90,22,119,28,191,219,210,170,234,145,2,111,53,86,140,171,46,232,231,111,18,43,83,2,142,131,38,36,99,174,3,26,169,105,31,214,250,212,191,8,1,141,69,73,158,180,248,93,117,146,242,10,188,63,7,61,149,69,118,161,141,117,25,193,18,187,220,194,82,13,30,5,225,194,158,252,56,159,129,5,240,0,213,85,67,54,209,242,151,41,141,172,187,12,215,255,6,5,126,185,11,225,35,202,5,182,98,154,26,217,237,193,140,136,38,71,118,166,44,17,223,179,101,97,16,153,33,21,204,15,219,189,120,219,24,117,23,4,153,22,143,40,174,238,185,27,159,69,251,1,227,108,218,69,111,198,184,236,14,216,136,208,115,154,211,47,149,116,98,114,40,90,83,116,92,109,38,134,140,104,157,197,116,57,122,111,5,224,4,175,201,244,62,210,203,188,216,230,131,214,184,164,54,48,242,179,251,201,77,16,77,13,77,23,34,66,146,24,12,187,238,151,92,139,64,114,217,125,244,175,10,155,138,118,58,245,52,121,17,241,62,231,105,214,169,120,184,4,155,16,20,12,215,206,40,237,161,186,68,63,141,166,178,6,127,126,151,70,195,245,163,96,91,23,138,173,211,99,103,164,14,51,246,20,75,76,135,150,74,215,220,71,15,76,77,215,250,38,227,176,76,17,15,179,232,18,19,165,54,194,146,187,110,158,216,55,66,145,232,119,152,61,63,121,155,194,202,244,22,81,66,36,140,38,108,209,21,139,25,159,255,185,60,117,9,245,95,46,99,220,27,61,151,235,253,38,161,64,188,88,189,117,249,42,176,56,54,107,62,80,240,135,153,86,180,137,121,111,177,208,196,3,194,236,106,173,82,40,195,1,146,180,204,141,11,192,120,252,52,4,116,199,14,254,104,216,4,219,7,221,233,33,47,34,247,94,0,104,240,54,18,128,85,240,255,179,195,197,161,240,178,242,197,103,68,166,60,95,131,245,148,198,163,124,209,39,120,42,206,15,106,91,118,113,89,19,66,66,241,200,64,65,37,82,169,139,136,203,234,192,172,175,27,160,244,10,91,4,183,109,177,183,93,233,92,26,227,67,87,232,184,97,234,202,240,80,213,42,133,15,68,206,0,206,110,170,227,223,113,90,208,60,11,93,245,151,50,51,86,152,199,229,35,248,13,119,64,238,165,152,108,70,48,149,157,110,249,189,25,187,246,251,124,64,0,176,165,128,174,39,200,94,100,193,34,233,19,192,83,39,177,228,74,234,195,128,251,203,238,192,16,66,200,223,179,30,106,195,189,26,217,157,142,161,132,38,20,179,217,79,34,97,189,231,106,19,144,223,172,39,206,91,192,115,254,111,141,170,103,121,61,72,101,60,110,173,73,193,25,89,206,122,137,151,213,60,169,7,42,226,224,249,190,43,17,190,187,240,163,77,26,192,162,70,170,154,216,20,183,212,229,81,56,157,247,123,219,168,91,21,53,107,174,135,98,32,176,146,78,98,190,30,232,190,171,107,188,254,223,5,25,58,134,150,36,28,218,134,107,40,253,245,199,11,1,191,26,173,238,5,142,204,170,161,157,127,172,254,27,185,235,87,15,3,74,170,36,195,132,163,3,126,33,178,173,141,106,23,111,96,111,124,164,68,230,2,210,18,190,148,45,70,148,194,38,160,67,130,166,172,81,5,91,142,239,190,58,3,102,81,212,68,68,73,134,6,117,116,100,47,57,100,207,232,224,125,32,30,193,162,117,36,57,8,27,203,56,199,110,251,56,35,162,240,157,224,0,42,206,199,201,33,95,5,127,132,29,178,152,101,166,1,242,99,155,248,47,71,180,75,84,99,65,91,32,31,136,206,52,48,74,184,208,83,85,179,51,105,125,87,66,145,207,127,71,239,255,157,126,120,139,232,35,64,70,128,118,191,41,217,7,185,86,117,216,187,163,194,206,174,218,56,214,58,160,248,111,154,70,17,108,212,91,199,245,32,108,125,43,198,192,38,68,101,100,147,129,87,52,240,50,91,92,218,108,127,101,155,228,123,77,147,41,86,207,159,139,140,93,22,169,163,63,89,236,154,98,131,93,39,55,237,122,107,6,174,184,202,126,27,199,141,16,52,167,250,44,52,64,134,244,66,235,39,127,190,88,127,61,105,107,157,35,59,146,10,14,155,241,227,170,104,180,47,95,20,235,236,196,100,29,66,255,252,236,249,128,214,5,234,40,241,34,234,45,47,166,217,121,36,243,35,251,23,126,3,133,136,164,113,22,69,236,180,239,139,48,255,146,161,48,135,129,150,245,193,181,210,85,120,4,249,147,174,66,17,136,154,208,148,214,82,198,29,171,4,223,212,84,104,93,95,153,151,59,52,212,150,113,85,179,189,60,151,118,28,93,220,49,114,124,228,164,99,165,40,1,5,200,121,138,132,77,15,5,21,162,216,252,37,141,224,202,125,209,225,242,62,177,195,93,254,238,77,226,148,168,119,167,195,151,180,25,60,215,48,166,94,44,45,114,159,78,24,155,132,119,38,31,231,227,51,37,35,33,239,40,171,12,250,68,190,248,231,228,59,213,61,15,65,53,179,92,176,23,172,176,32,72,135,37,241,24,107,242,184,186,57,99,239,241,14,0,114,211,202,79,176,88,52,130,56,18,75,55,22,208,79,100,1,57,105,53,174,100,13,234,232,158,118,211,9,144,128,160,76,177,166,10,90,95,110,144,254,243,190,208,135,184,198,226,200,27,9,38,241,0,208,210,237,180,2,22,149,157,19,155,249,21,3,55,195,149,105,206,24,110,148,19,249,58,78,186,176,25,100,216,4,198,194,104,71,150,103,193,54,223,28,146,80,51,157,194,14,178,180,189,161,192,44,225,168,111,47,225,151,43,100,26,191,125,146,222,221,199,216,186,126,173,89,90,229,77,60,34,228,75,219,182,85,232,170,22,24,130,197,101,20,253,116,141,176,241,34,223,208,190,53,49,201,93,144,151,241,108,236,120,86,232,128,234,238,83,111,80,172,96,67,34,128,6,29,10,136,122,7,204,83,50,186,1,23,79,169,21,92,114,15,132,236,51,188,123,139,240,236,199,67,208,132,52,13,194,187,174,29,120,140,151,198,252,88,147,102,219,35,162,73,126,98,77,213,8,169,217,193,210,100,239,19,153,49,43,252,194,75,228,65,143,184,39,77,42,202,171,40,113,137,164,157,33,120,131,63,197,218,5,250,238,192,175,128,92,206,161,173,254,238,133,100,158,136,16,101,127,238,52,208,92,82,3,217,66,93,246,228,193,254,74,72,78,122,33,105,54,8,66,93,246,194,222,27,194,33,125,31,125,186,243,13,92,218,44,36,132,226,180,89,124,205,104,135,159,122,252,15,162,223,62,10,250,171,0,131,127,85,178,231,79,207,40,253,46,196,118,242,128,72,35,191,117,82,21,59,50,253,123,77,220,143,104,20,203,224,176,13,252,32,28,67,43,91,75,244,94,186,135,19,180,199,223,127,142,98,37,239,28,103,87,65,235,18,238,103,120,238,30,86,59,98,172,2,220,161,99,43,3,209,122,161,55,146,255,1,36,249,99,184,3,3,168,72,232,46,73,223,106,79,159,210,38,156,147,51,126,50,165,108,52,49,96,42,238,80,99,70,146,206,224,54,97,97,16,213,14,248,251,126,49,66,87,134,179,227,232,143,91,185,125,0,158,183,5,242,48,7,152,160,171,198,163,34,181,199,170,68,125,93,97,109,136,230,150,33,113,56,104,7,226,175,49,100,51,84,213,22,135,7,237,200,148,72,116,142,163,153,122,86,4,164,15,210,118,24,67,210,223,220,137,144,48,144,180,185,234,2,241,154,213,43,109,156,143,172,26,128,135,231,119,24,217,131,61,148,77,141,150,92,115,120,2,154,217,75,86,241,208,171,108,103,82,89,209,129,238,172,132,255,207,27,146,164,74,184,68,92,141,13,124,214,138,185,244,149,236,189,182,103,67,87,10,32,216,220,143,80,210,206,245,104,149,139,20,55,5,113,172,207,125,29,89,249,19,112,108,14,88,182,201,165,18,10,245,121,6,178,148,34,12,59,196,61,173,239,178,241,33,155,25,242,134,32,227,233,188,135,113,163,52,64,251,178,224,118,246,79,167,5,63,212,177,112,180,80,242,169,49,210,21,134,141,17,157,190,91,64,227,91,38,133,159,225,105,247,226,195,200,172,31,220,215,170,68,107,20,234,183,178,143,56,158,107,86,223,172,215,193,84,10,65,89,99,158,61,203,224,96,108,213,54,164,149,13,125,118,120,95,189,114,57,41,211,241,237,209,190,6,62,79,184,242,245,149,195,91,85,198,131,178,227,71,202,112,154,51,82,29,130,223,121,113,6,199,251,129,30,201,68,187,181,197,35,52,79,104,12,235,40,127,72,62,197,101,25,50,235,135,22,61,18,204,9,17,58,139,193,112,118,161,34,157,65,113,190,135,176,140,117,20,216,176,111,50,116,217,162,214,180,80,45,31,21,53,93,2,228,123,100,207,17,230,207,97,240,183,85,31,41,46,45,3,43,72,155,187,165,203,128,67,28,120,236,54,20,65,238,109,110,179,222,136,198,17,77,149,130,251,103,177,204,150,184,189,37,5,55,241,217,14,130,255,116,126,175,235,144,116,140,66,14,51,205,67,99,220,51,208,79,206,154,127,22,85,71,77,215,145,255,44,243,64,209,227,67,73,110,151,218,87,197,55,237,118,245,39,169,244,170,245,203,108,245,142,50,189,176,80,21,202,93,146,1,53,148,177,158,56,213,31,235,149,163,76,7,160,96,185,175,209,247,27,135,158,217,147,16,10,240,197,137,20,206,239,82,56,27,22,220,198,2,89,79,127,31,142,1,6,55,182,200,142,137,107,201,174,111,181,210,207,62,30,104,243,208,79,121,233,86,23,51,192,246,38,237,63,185,68,166,75,123,229,116,251,234,207,59,122,231,68,113,211,62,70,25,143,151,209,232,208,160,147,131,216,54,242,90,239,63,40,144,174,63,16,36,202,26,114,183,89,217,89,136,230,91,48,252,125,202,164,150,89,145,56,123,247,12,54,155,187,186,61,40,196,208,28,136,119,101,36,210,226,52,175,235,200,109,39,72,109,208,243,138,191,212,112,241,255,140,84,135,41,149,18,74,71,117,169,225,47,36,251,47,104,143,61,234,88,50,148,255,119,218,157,33,205,193,198,233,229,11,62,162,92,119,220,137,255,123,184,226,35,157,8,174,39,63,216,248,137,225,131,8,2,82,204,80,214,39,91,209,189,161,6,81,144,36,198,76,197,109,194,10,4,72,54,53,184,115,91,225,10,11,168,200,46,218,124,246,135,15,89,53,166,8,241,71,83,123,154,209,50,174,37,55,123,83,140,20,54,44,56,182,163,26,6,6,190,38,53,147,232,222,149,68,107,255,157,252,151,137,92,252,145,148,33,103,9,72,231,13,116,195,38,2,23,236,159,143,19,6,218,213,124,179,244,182,30,110,173,19,168,90,131,57,252,205,106,250,34,115,21,156,227,2,178,233,51,164,166,165,72,112,14,41,93,38,111,111,37,191,106,207,33,185,185,90,72,233,134,236,98,171,160,112,169,40,190,94,93,171,234,98,137,93,127,65,248,80,186,131,116,191,197,63,31,50,255,195,58,34,142,54,220,246,198,63,55,183,44,126,0,217,209,232,158,8,7,110,86,107,240,61,28,52,138,97,149,20,247,180,192,143,33,83,155,177,22,187,216,48,139,83,169,139,99,123,154,74,125,236,38,59,46,27,30,157,211,15,232,203,47,94,136,56,194,51,139,205,174,21,161,217,7,160,227,59,236,156,91,143,154,27,42,117,22,168,18,246,201,35,37,107,157,58,5,158,76,100,112,62,84,117,50,22,6,96,111,120,207,116,151,161,13,67,239,116,206,98,64,136,103,8,201,197,9,81,239,18,226,93,190,46,81,229,232,167,200,193,215,90,182,212,93,78,67,26,105,97,197,49,164,150,52,143,248,121,13,95,217,227,206,14,80,200,179,171,10,146,200,142,90,137,125,253,146,71,131,33,45,48,69,241,119,153,254,188,241,25,222,97,30,63,46,136,159,57,134,89,0,129,234,189,184,64,200,208,245,48,167,116,134,99,230,3,164,217,19,159,106,99,97,202,22,164,70,66,13,97,32,58,239,114,37,9,60,59,67,157,37,172,251,50,177,13,116,63,7,119,74,90,248,108,175,187,95,134,112,101,157,132,160,143,70,245,232,144,69,184,106,150,9,184,122,224,32,162,162,167,166,203,10,237,99,78,75,217,159,250,237,184,75,97,163,68,55,215,93,14,236,225,12,141,49,8,40,126,117,77,135,80,77,205,97,75,21,26,145,221,123,172,2,182,77,86,93,204,86,114,144,92,13,141,25,97,222,15,100,182,160,159,142,35,220,49,107,187,208,137,105,153,135,0,174,222,172,239,170,133,207,178,208,164,230,211,2,139,92,32,192,133,89,232,32,239,245,110,166,136,37,21,196,131,79,242,98,209,25,180,252,102,119,100,85,102,115,189,106,122,226,157,178,221,143,154,92,187,57,68,241,18,33,225,250,134,114,116,72,134,250,27,40,97,219,30,86,74,184,102,193,26,66,181,24,165,153,255,190,75,185,18,121,114,85,220,59,224,145,174,176,36,67,144,74,196,161,88,9,48,79,220,4,67,25,232,105,176,32,242,28,201,66,116,178,36,164,218,208,31,240,68,239,166,138,242,198,226,27,136,232,255,174,210,152,60,200,61,15,238,2,218,231,198,130,236,180,235,65,221,66,82,162,92,235,251,20,38,65,92,156,106,85,0,144,25,182,28,226,88,153,34,253,19,27,116,90,101,248,35,202,216,184,19,35,2,94,8,209,254,66,212,135,68,219,185,32,107,225,25,227,136,211,138,181,174,112,128,190,66,165,251,135,185,108,40,159,222,177,26,58,26,148,218,89,13,15,27,236,24,118,78,33,185,174,168,219,230,119,230,179,169,161,57,118,97,227,203,9,125,55,136,197,112,94,138,136,230,112,204,245,136,116,59,13,75,68,121,43,122,9,22,252,149,172,182,118,113,61,53,171,44,42,118,178,166,69,222,44,157,34,128,126,179,24,154,159,106,149,17,227,58,143,176,241,222,56,42,62,181,26,208,33,24,30,33,112,83,127,84,65,41,251,206,115,178,2,222,106,153,209,238,98,208,200,210,177,133,86,65,23,104,110,177,161,96,79,57,142,162,15,207,173,153,56,254,250,73,76,74,43,36,200,57,145,60,95,227,21,147,221,41,171,192,107,234,251,74,126,3,247,128,122,243,153,128,202,238,189,17,198,179,70,97,245,190,200,231,176,186,98,217,254,45,230,228,185,78,204,155,64,247,183,255,152,161,26,12,21,183,209,199,194,177,1,221,95,77,76,253,203,104,7,192,167,209,180,50,138,227,189,182,231,239,238,168,59,221,119,154,107,247,102,200,51,40,120,192,133,47,249,238,189,123,233,117,188,210,82,68,72,178,111,103,77,144,205,181,97,1,172,166,152,242,0,187,181,174,188,39,82,5,75,21,213,113,66,102,62,173,169,132,21,120,138,226,211,39,44,143,160,126,74,108,191,13,117,58,148,234,239,194,161,161,156,231,240,170,77,120,106,63,168,175,231,243,60,192,181,236,20,52,239,78,141,78,130,59,219,80,208,24,37,165,109,209,49,251,9,62,80,50,249,181,232,42,228,47,166,191,144,176,206,148,242,148,153,182,121,24,128,65,137,42,161,119,66,94,240,11,55,102,122,7,205,142,144,144,180,47,60,218,192,149,85,15,213,83,8,79,215,104,8,209,172,222,200,242,28,255,51,185,167,33,226,26,65,147,100,114,222,54,27,170,212,207,83,56,170,37,126,121,14,18,40,231,4,14,164,248,6,110,118,48,51,83,228,76,3,131,87,77,86,163,48,72,194,109,53,105,118,111,198,140,133,34,20,119,56,35,236,7,170,176,164,95,86,183,232,105,108,7,25,169,127,50,26,86,83,94,101,58,219,72,205,46,231,78,158,94,221,190,147,92,96,224,0,30,65,191,21,237,118,106,224,247,161,116,33,41,10,92,81,248,232,191,41,72,116,171,89,110,208,62,230,196,11,67,172,81,188,8,212,62,255,199,22,201,68,20,120,21,90,72,70,211,251,61,232,5,238,147,16,91,225,65,103,178,238,63,246,157,100,192,170,206,249,101,28,25,120,125,225,94,105,146,218,75,10,178,103,244,73,77,174,18,113,205,198,233,5,88,129,66,64,72,137,118,81,217,130,206,156,174,224,223,115,249,164,10,160,47,237,255,135,146,236,13,99,71,63,62,20,134,132,135,155,27,21,239,159,60,195,224,248,123,205,45,147,225,233,72,95,151,236,249,144,43,148,51,197,175,100,140,185,170,200,234,37,87,113,85,41,197,41,164,33,181,64,228,58,125,41,220,43,111,47,37,139,69,75,126,166,210,12,7,175,6,63,122,236,237,156,149,142,254,174,11,37,215,82,200,54,62,74,43,2,249,172,218,115,203,91,14,165,110,103,178,200,5,226,141,45,42,68,130,198,173,253,230,217,122,113,39,163,182,160,231,100,179,40,207,8,27,212,22,174,85,58,27,55,118,83,118,244,201,68,167,205,50,31,36,17,250,228,187,200,203,159,109,44,83,197,240,214,82,128,207,62,237,127,108,238,226,36,190,44,152,27,248,90,79,254,43,191,182,206,138,179,239,133,27,56,192,25,166,40,83,172,241,62,178,172,53,58,205,73,6,139,66,50,24,22,193,232,205,173,161,67,139,236,13,114,239,156,46,253,12,218,238,6,255,169,98,117,8,215,156,102,178,212,208,18,175,147,108,96,73,71,115,87,75,254,77,61,212,49,252,42,72,23,95,49,206,208,189,203,240,139,4,56,101,109,139,204,117,23,213,104,47,1,254,115,179,25,96,58,221,157,53,112,19,110,172,118,168,11,21,171,109,123,100,79,124,202,172,155,236,144,86,224,44,183,119,167,51,180,139,191,76,201,173,212,215,120,148,255,149,110,69,229,152,112,197,133,178,122,15,23,55,103,67,13,152,239,59,168,53,175,130,232,143,236,0,96,95,206,91,141,167,127,199,149,82,51,222,51,43,148,225,183,56,32,68,76,97,35,154,233,207,47,2,29,114,143,36,159,81,168,169,22,163,74,208,233,149,204,129,138,138,13,48,180,42,41,155,141,156,228,19,71,135,137,63,119,146,67,61,236,133,52,209,164,39,67,110,28,5,36,100,159,52,79,220,118,89,126,230,63,180,117,243,165,179,147,209,255,162,97,177,43,45,86,56,48,223,195,122,39,130,118,8,183,36,55,42,221,83,72,74,95,130,91,23,121,226,221,206,241,204,44,105,177,188,105,190,84,106,225,244,183,44,76,188,169,150,98,155,208,244,161,94,75,232,173,64,126,153,184,124,75,229,87,31,209,154,93,125,64,53,167,155,250,167,122,169,184,231,14,34,61,208,47,179,182,194,37,87,240,10,125,2,26,125,232,189,207,199,3,153,204,157,148,33,93,160,134,67,238,203,126,198,203,210,112,25,199,23,136,192,135,207,227,224,213,125,17,93,230,177,178,164,152,162,80,107,50,52,221,42,20,128,143,202,168,22,91,223,159,118,214,249,29,184,124,24,124,1,183,54,43,61,91,155,116,241,94,157,187,60,100,244,97,97,177,9,57,90,72,245,38,31,86,172,41,102,15,35,39,4,233,141,9,165,41,137,229,44,122,16,181,99,178,84,124,207,34,140,41,145,250,172,186,100,100,156,162,5,126,187,160,57,183,240,17,46,181,44,120,144,141,151,142,129,195,192,11,203,241,78,134,142,214,106,198,94,141,84,62,51,127,110,9,65,150,68,221,157,131,236,130,114,10,128,197,13,157,252,8,165,223,138,108,179,156,231,156,82,132,196,202,13,64,69,92,110,180,238,15,125,240,30,231,134,56,66,31,193,191,100,72,106,233,11,113,8,121,238,178,117,107,157,215,58,43,212,236,53,215,214,1,16,192,173,175,231,62,113,26,94,248,47,30,36,232,160,227,75,161,127,33,5,192,210,69,155,249,190,217,224,42,17,77,54,231,20,45,5,116,154,154,80,74,148,126,85,137,13,59,123,226,167,20,148,24,19,123,17,78,46,126,232,255,147,20,83,85,103,16,86,141,246,211,162,58,245,162,77,31,51,40,174,164,117,38,201,18,8,240,124,226,180,213,190,92,223,249,184,227,8,168,86,142,19,66,247,142,54,135,218,13,197,216,225,152,61,155,156,171,88,150,158,129,132,144,138,13,21,166,17,156,62,40,147,131,134,66,228,77,177,184,53,207,92,208,3,16,2,45,215,154,73,196,92,47,104,0,94,23,103,132,206,81,105,63,84,231,7,205,95,148,128,250,142,158,42,49,223,26,22,72,27,211,39,245,201,245,4,127,48,221,21,121,201,223,108,209,6,93,31,85,112,207,74,123,201,78,249,139,38,60,134,47,225,21,74,31,177,146,41,144,16,100,28,219,207,21,104,154,200,135,169,238,147,227,243,217,211,187,109,182,74,223,148,201,132,46,26,159,121,196,145,148,161,153,126,127,103,44,44,215,135,248,8,157,23,184,220,82,173,81,229,136,173,243,230,69,68,158,137,156,73,166,209,116,155,166,231,141,186,187,84,175,227,63,227,13,18,245,222,185,2,9,97,179,58,174,246,67,94,255,153,44,100,138,172,19,5,67,221,82,20,224,61,104,222,44,53,106,82,147,130,225,31,218,140,64,109,45,5,216,165,119,100,159,228,18,213,150,192,59,85,135,249,36,228,230,57,28,67,206,105,230,148,212,28,106,92,97,2,31,152,107,208,11,10,205,238,102,126,66,83,190,233,77,232,77,96,85,249,251,119,192,179,5,0,198,67,127,22,157,78,146,64,204,6,39,200,12,229,227,234,242,193,195,141,125,107,248,143,210,251,18,220,67,240,110,48,114,110,15,160,241,14,133,152,132,225,44,134,92,88,11,167,164,225,12,234,164,92,9,175,74,190,164,193,157,232,4,137,216,80,165,124,20,254,221,2,198,63,217,156,135,119,4,178,58,153,215,139,67,52,172,206,47,40,75,33,86,67,63,41,10,20,37,237,37,156,4,13,25,23,201,228,9,237,67,16,22,116,17,184,162,203,188,227,13,110,65,231,79,200,61,118,207,68,161,90,71,47,113,31,224,165,90,23,21,239,63,80,176,54,103,99,60,125,72,207,90,110,231,121,225,205,35,28,16,137,252,136,94,179,14,97,157,227,66,82,219,137,26,78,157,181,147,28,161,251,43,196,201,53,245,149,152,194,86,91,70,203,91,114,199,241,212,180,125,44,131,135,116,26,132,69,27,84,222,132,88,96,163,119,62,129,249,230,33,147,28,124,23,172,231,132,144,182,235,125,193,70,233,206,77,27,210,203,223,213,95,105,230,117,205,214,164,126,23,240,10,34,237,211,43,162,138,230,118,192,86,247,125,167,215,62,26,113,209,175,19,231,246,167,150,22,44,69,31,236,205,198,210,214,123,93,60,9,175,131,96,145,71,92,190,209,201,225,103,43,204,242,98,253,129,95,56,223,107,29,87,165,180,44,49,28,37,42,83,215,122,91,126,77,38,243,71,213,191,223,14,76,247,97,110,190,120,147,167,234,237,10,98,148,45,218,3,23,117,15,148,142,173,118,236,90,31,27,85,54,188,202,253,43,102,109,130,17,8,239,241,89,212,14,29,172,179,90,8,104,5,203,117,188,43,184,167,54,8,100,136,17,55,201,102,193,221,245,173,86,65,162,176,40,92,214,101,18,82,59,131,63,156,187,219,65,190,115,172,242,52,181,80,109,165,136,98,148,149,152,234,86,143,132,100,239,159,119,163,250,30,130,119,190,45,58,208,104,161,144,10,202,200,31,177,215,242,236,78,3,151,34,8,16,172,231,112,71,159,168,32,208,230,50,84,234,214,40,92,65,60,148,117,76,216,111,91,121,177,66,86,123,55,54,126,46,118,241,103,105,245,89,242,0,0,166,87,7,145,164,227,90,30,10,4,88,64,114,70,127,14,161,218,198,16,35,230,115,54,65,108,190,175,186,252,79,33,24,82,118,130,249,181,253,61,28,154,77,227,209,111,63,61,68,223,162,41,90,176,37,114,169,199,77,160,219,199,22,79,240,212,158,243,217,226,74,158,215,193,166,204,82,135,0,106,12,155,150,113,241,197,33,205,6,16,19,118,164,194,115,243,112,162,251,134,203,122,124,61,242,68,140,200,131,168,172,123,48,70,132,227,199,3,196,130,48,55,231,64,216,195,86,36,160,233,137,145,108,224,93,218,61,107,191,138,171,13,215,212,65,223,117,85,120,109,207,141,12,23,221,175,68,130,129,185,138,67,225,85,127,85,215,75,146,79,69,133,10,129,210,51,71,147,116,11,104,76,194,87,78,137,12,108,185,53,10,210,35,135,33,203,224,96,175,47,98,138,83,60,163,16,100,51,21,186,245,7,153,128,164,73,27,189,195,13,61,255,96,12,174,169,37,39,235,177,224,137,71,128,240,63,137,238,255,68,185,212,135,190,156,240,184,158,113,210,241,119,224,63,177,236,63,172,135,117,74,27,187,227,253,246,222,134,197,251,197,243,107,188,160,85,252,111,4,141,195,243,91,73,226,144,131,109,136,10,172,209,186,95,172,96,107,43,22,44,176,226,122,100,50,28,65,163,62,235,88,16,254,97,48,250,64,155,101,21,83,64,255,189,98,142,60,20,184,3,54,87,20,50,178,254,138,105,53,169,141,5,88,57,244,207,138,191,208,185,54,87,134,70,182,197,77,248,201,118,133,148,231,106,241,215,91,61,184,61,250,9,140,91,66,203,141,93,171,166,65,183,29,234,196,85,230,194,177,148,240,126,71,14,92,212,2,120,179,141,11,42,166,15,45,196,187,30,249,247,104,244,5,25,126,208,252,253,157,224,36,138,145,222,221,213,15,204,112,217,50,193,215,194,2,248,214,48,43,229,7,204,79,218,223,82,137,114,228,41,220,68,157,35,245,242,213,255,141,189,192,243,63,72,119,222,107,252,230,192,211,47,186,209,144,213,221,185,22,152,208,54,130,76,100,242,54,210,211,40,29,189,40,7,183,252,209,130,240,76,107,14,110,35,151,57,0,187,180,78,210,153,198,18,212,33,205,72,211,89,150,175,136,7,138,13,18,93,226,93,52,171,126,188,165,113,29,15,231,234,11,67,54,164,115,158,58,48,20,202,65,198,247,224,202,190,45,10,153,146,148,150,218,67,157,27,190,197,15,182,135,56,130,43,203,209,174,134,100,81,179,58,182,229,1,155,224,135,148,214,99,38,92,212,220,49,17,170,248,161,123,88,92,5,119,19,210,149,12,254,121,21,140,38,10,247,25,4,22,186,68,1,211,221,109,182,103,137,4,242,129,66,67,138,61,50,131,83,208,81,53,132,36,86,63,33,62,142,250,210,195,68,246,210,84,77,150,182,48,140,129,1,24,195,122,107,160,22,129,227,250,27,102,21,127,52,229,47,19,58,21,47,132,85,233,11,183,119,3,54,223,94,30,168,153,3,202,62,170,29,46,235,105,186,122,192,71,128,73,149,47,98,46,122,34,64,101,76,177,160,154,47,174,96,118,108,73,203,121,15,19,101,72,99,177,70,118,219,124,182,128,41,154,76,22,204,166,120,224,174,35,27,29,63,8,248,217,183,247,192,11,141,178,28,4,184,73,111,64,221,65,220,21,145,34,163,79,94,28,225,40,146,182,182,2,244,18,250,136,64,65,3,121,52,149,19,150,105,221,244,244,247,77,249,155,100,216,128,178,170,122,153,140,221,2,88,211,227,255,108,191,91,6,185,100,148,31,75,245,179,229,46,107,30,214,20,93,198,142,86,108,83,131,235,38,107,38,203,229,248,160,22,216,41,215,22,55,59,211,156,38,76,79,202,176,49,88,161,162,206,46,81,83,200,99,138,117,40,110,2,84,142,165,212,63,185,183,35,165,96,218,110,177,40,36,21,19,181,76,171,145,175,144,249,115,42,97,99,152,49,128,122,54,8,136,236,196,46,137,181,211,218,83,112,177,64,193,136,89,220,176,221,204,172,174,154,77,96,166,191,132,59,141,90,169,6,46,45,84,193,160,209,49,6,199,255,3,129,73,146,92,31,226,30,164,12,7,148,241,217,3,113,226,199,81,146,95,141,45,176,205,253,233,128,78,74,123,244,138,154,234,99,11,241,18,251,174,123,196,122,254,82,210,2,90,216,87,97,38,253,160,197,255,134,152,168,162,17,72,133,41,122,235,85,154,133,172,162,240,103,107,149,216,192,182,55,27,163,94,52,129,61,154,61,11,135,223,222,154,217,53,135,124,181,120,2,41,107,239,28,32,232,45,27,51,86,176,14,7,40,249,170,100,67,101,131,23,151,200,74,151,82,184,146,40,7,64,240,146,253,80,218,150,108,16,186,224,225,98,8,166,177,252,0,35,95,107,137,80,130,116,129,161,149,37,52,149,240,167,11,50,129,134,80,126,16,233,201,206,97,186,68,205,245,254,241,139,20,5,89,162,39,98,188,107,186,119,233,101,250,245,150,241,120,191,39,29,12,121,31,198,242,252,230,85,160,112,172,171,128,29,103,65,246,39,126,74,92,140,142,56,181,82,101,195,59,71,4,8,9,42,98,180,136,41,26,56,252,4,230,102,239,251,161,183,106,22,54,238,250,59,61,243,9,189,77,195,254,119,234,124,186,211,5,26,88,176,159,87,101,242,100,179,102,218,39,85,82,118,109,146,144,225,73,28,78,77,189,135,29,192,12,95,153,113,248,50,171,113,241,189,121,194,155,247,109,70,124,72,61,27,79,56,185,218,51,155,130,98,183,1,100,60,85,55,160,158,110,41,58,63,216,176,49,228,195,87,118,254,105,223,41,138,84,41,78,214,111,49,206,175,91,190,57,25,68,120,22,127,85,81,202,226,197,123,156,169,249,12,182,148,31,115,211,146,41,208,248,249,197,188,103,47,138,8,117,43,130,28,28,102,44,149,38,221,176,211,11,76,148,186,176,252,87,62,69,3,88,80,123,168,196,245,128,224,186,224,99,220,46,237,181,88,159,161,175,204,237,160,154,13,131,12,99,88,171,231,111,242,238,194,193,15,3,254,152,148,114,131,215,216,106,245,73,197,176,147,149,25,185,200,252,52,225,236,86,240,34,22,76,102,243,132,148,11,204,125,58,185,37,184,188,4,169,89,249,104,232,254,3,96,102,68,177,242,8,251,188,177,100,48,1,248,177,185,181,108,161,130,117,35,229,28,94,131,105,31,242,158,200,167,63,124,21,55,142,139,10,202,5,82,209,8,37,48,22,47,237,174,182,254,11,32,46,255,142,78,113,207,192,187,172,174,16,156,90,26,138,142,57,129,2,59,148,175,197,194,242,205,81,57,214,199,206,60,204,225,254,113,28,148,222,242,209,101,104,98,108,237,223,49,114,212,129,78,146,78,208,40,162,230,188,127,198,195,47,15,146,82,173,159,186,217,133,148,237,194,5,33,102,245,90,65,8,165,35,12,231,205,62,97,232,36,7,127,30,119,233,149,99,221,178,173,102,226,168,250,196,60,181,5,125,126,243,158,64,110,37,30,195,162,229,136,241,198,229,105,88,85,49,14,96,84,216,55,253,53,92,172,24,38,54,35,37,50,118,149,84,244,199,203,56,87,218,44,100,7,25,135,147,55,101,115,200,99,37,8,239,72,221,30,76,8,86,146,55,44,91,241,31,111,230,90,185,168,144,245,50,43,46,238,33,229,223,34,244,14,118,219,103,141,110,249,21,49,255,202,251,214,126,66,144,34,95,94,195,240,131,109,100,123,73,158,69,82,217,206,59,169,190,31,185,211,83,88,73,74,185,229,228,147,57,21,198,39,234,143,84,167,170,144,247,206,56,43,55,104,193,157,220,89,125,173,151,17,4,10,18,124,244,41,133,194,59,11,202,98,174,212,26,19,95,71,26,82,242,133,85,125,4,131,36,108,37,250,255,99,63,15,53,173,129,255,175,83,105,132,142,35,4,243,133,67,237,220,88,25,169,219,83,229,33,83,46,251,0,111,226,87,41,226,98,245,208,93,251,94,207,210,41,146,56,119,137,32,0,61,212,6,161,219,144,112,202,88,124,132,83,197,240,185,196,152,34,202,136,59,198,165,5,136,11,246,158,60,3,176,105,203,207,70,162,187,45,160,39,60,82,115,113,239,37,166,188,235,215,222,227,65,73,188,70,178,98,215,247,7,12,10,4,216,139,202,178,125,231,103,79,61,127,58,10,202,75,42,107,139,214,172,4,14,3,23,73,247,52,158,78,61,218,235,79,191,182,70,127,157,34,208,242,177,248,153,110,42,50,168,186,212,159,202,174,245,161,60,197,47,221,200,111,195,231,35,136,145,196,62,119,52,247,41,50,41,64,94,231,136,149,213,174,127,157,61,143,47,166,152,59,245,186,16,70,32,201,49,239,157,90,225,122,138,88,158,93,59,121,246,69,151,25,182,189,199,100,74,131,123,99,103,185,138,240,169,255,83,8,240,13,159,156,5,223,181,247,243,244,179,90,207,159,36,69,34,174,29,39,12,198,108,220,130,2,10,203,188,206,67,116,209,27,67,170,198,93,113,250,14,198,254,196,37,146,198,0,245,162,19,196,105,30,136,94,211,48,61,213,53,160,236,102,140,240,236,1,246,124,73,73,184,88,243,157,125,154,77,39,104,111,1,205,78,22,233,44,37,253,92,198,51,8,211,150,43,192,106,122,208,21,123,140,14,148,222,144,217,194,15,242,120,80,45,66,71,74,147,132,37,185,45,165,41,76,166,143,130,134,3,4,15,104,214,102,179,162,238,195,200,235,20,223,172,249,110,37,43,216,136,128,232,235,48,215,2,250,173,82,109,146,30,125,217,231,73,206,65,2,40,45,35,163,248,230,102,19,67,102,0,76,64,7,130,23,167,105,28,152,26,73,234,15,36,35,231,146,205,50,217,164,199,154,192,15,19,80,26,30,181,14,197,12,131,88,61,140,86,85,233,182,210,78,143,77,63,177,30,176,10,224,14,137,130,162,84,191,108,227,75,85,115,237,159,119,222,168,131,18,13,22,92,110,176,134,71,180,31,116,154,111,4,116,74,59,2,191,75,114,181,184,238,106,236,202,251,63,247,48,35,155,172,61,122,174,26,38,3,176,42,15,71,195,153,55,66,191,33,169,177,220,36,95,177,66,86,173,31,180,219,166,178,139,120,139,67,88,25,238,233,169,169,111,163,217,54,29,44,34,138,236,199,35,50,82,214,30,125,91,25,222,65,137,125,96,232,78,167,209,68,71,70,1,22,163,34,202,200,71,113,235,157,41,14,32,110,171,235,197,174,10,51,158,251,44,98,199,201,196,168,50,201,99,205,245,153,75,169,17,143,154,52,222,138,28,173,86,92,134,115,136,220,131,85,171,122,218,117,190,117,143,79,26,121,10,50,45,80,241,33,4,253,140,1,159,201,105,123,35,133,81,59,236,16,238,109,215,10,124,211,64,112,180,147,203,106,142,69,97,205,162,177,217,151,174,189,239,69,50,30,166,238,219,120,79,225,197,121,127,91,215,89,102,17,39,158,213,94,164,254,49,125,216,191,222,90,38,224,214,242,60,2,38,241,139,218,34,185,186,30,206,33,43,38,242,81,191,12,1,200,96,167,125,197,194,127,129,244,184,30,74,74,196,174,229,224,226,124,52,137,122,146,108,187,169,127,72,111,131,243,79,149,236,134,103,137,212,161,44,61,183,188,103,150,96,95,88,187,167,31,213,185,63,128,70,10,58,47,69,155,112,231,242,129,19,78,116,74,152,85,44,128,199,241,148,56,48,27,194,180,191,35,170,227,179,166,110,172,88,208,185,53,153,120,109,155,216,205,172,159,59,191,94,49,209,213,90,125,246,132,153,163,89,50,28,91,141,185,11,4,229,210,18,79,36,117,191,90,231,97,92,89,193,98,201,7,9,252,3,100,157,87,134,164,29,218,54,7,117,232,97,226,74,185,43,135,78,199,151,206,137,157,244,201,49,137,164,23,115,134,121,92,128,224,192,100,154,252,124,146,17,129,44,130,237,65,159,194,35,88,56,132,29,163,200,91,112,118,35,100,76,112,87,180,233,171,69,124,62,161,232,54,66,129,248,193,47,232,197,143,236,112,36,132,61,97,179,231,60,124,4,220,161,114,16,84,196,143,200,58,98,2,255,8,3,222,42,146,204,234,68,199,78,202,173,32,215,30,242,64,32,250,49,111,31,174,191,209,40,51,55,101,12,137,212,116,140,72,132,52,104,204,245,218,122,29,236,175,188,112,137,112,129,225,22,84,118,55,75,104,13,207,51,243,102,148,120,49,86,192,53,173,30,143,161,0,187,160,141,185,32,104,37,221,242,44,29,27,162,135,12,4,205,239,98,8,217,237,81,207,29,240,169,209,6,80,56,120,99,193,90,244,235,14,45,162,130,224,62,152,96,147,9,238,188,49,82,151,207,8,240,126,39,228,192,121,199,227,52,238,238,69,130,134,174,90,34,126,176,133,63,234,79,219,126,186,224,106,183,242,244,90,180,161,17,110,155,66,109,222,205,83,121,103,49,85,234,220,198,98,67,0,50,194,21,182,193,118,19,220,4,173,96,221,203,40,186,232,98,162,37,12,169,225,26,229,12,71,121,194,162,100,159,139,30,0,151,86,14,131,219,129,154,212,170,79,126,26,171,90,92,239,0,106,79,97,213,183,128,12,238,216,30,67,114,73,64,191,22,179,225,12,252,220,234,87,55,51,145,66,34,63,168,252,148,87,47,176,54,228,85,152,226,61,198,41,76,94,182,131,134,142,127,97,14,232,78,147,107,91,23,55,184,220,0,132,128,230,214,41,253,146,45,59,69,244,78,228,127,47,234,235,212,197,152,203,251,16,167,93,153,46,245,207,238,82,246,96,131,4,123,250,67,9,15,63,198,214,205,18,51,223,238,190,104,69,185,188,1,61,168,132,22,21,224,86,237,119,49,15,228,241,216,161,180,19,252,22,109,144,133,49,21,97,145,73,250,32,160,0,103,179,235,69,26,206,44,140,184,97,110,167,21,84,228,112,18,154,24,41,60,232,190,168,43,72,248,82,221,13,138,79,89,140,122,61,117,232,17,75,243,217,88,218,235,50,96,182,174,230,168,249,99,90,3,240,143,171,128,49,247,62,32,242,216,73,239,88,172,30,77,172,78,40,138,46,152,178,103,92,139,57,224,167,208,14,63,245,78,69,235,225,103,133,134,96,22,32,104,77,117,153,192,206,38,183,221,117,253,207,240,211,16,89,105,251,119,74,144,222,156,150,154,58,135,38,58,165,24,125,4,181,205,243,117,226,156,243,80,70,66,176,146,37,197,55,215,99,87,148,92,191,170,198,29,60,48,57,132,232,226,100,191,28,143,184,235,205,69,47,243,18,71,89,96,148,5,68,98,120,4,46,222,166,248,156,123,31,13,147,244,29,153,133,248,130,207,112,2,139,131,49,115,58,120,121,244,170,19,97,201,192,75,161,137,127,83,157,78,253,58,222,224,220,83,182,11,236,101,153,140,34,113,36,254,143,112,151,78,23,46,155,32,170,178,239,64,77,243,128,127,240,27,82,213,68,205,87,27,42,124,75,156,9,234,4,161,210,181,7,140,130,78,31,105,100,208,169,223,62,105,229,132,50,56,128,226,5,184,254,213,116,54,2,93,233,67,132,34,39,179,133,27,209,227,163,127,21,38,10,175,140,28,114,70,190,173,123,166,31,176,23,83,27,2,64,147,250,217,95,1,100,211,238,42,151,65,188,182,234,61,134,64,31,245,14,173,167,214,244,223,242,182,230,208,180,241,228,142,135,251,1,188,189,100,175,18,181,117,35,14,102,136,20,208,168,235,41,228,102,112,204,114,197,137,63,144,1,174,122,8,52,194,119,247,169,229,16,103,124,105,126,128,30,165,102,132,107,24,55,253,220,212,101,202,129,150,144,2,88,195,9,152,160,243,97,168,80,228,18,168,79,186,193,151,206,197,164,32,6,58,126,128,178,154,122,20,188,81,123,96,6,46,214,149,107,24,177,129,255,208,247,29,66,228,212,126,81,168,1,76,131,174,108,141,122,248,24,107,113,170,68,235,117,129,83,56,163,148,130,79,104,185,22,138,198,242,77,180,102,47,117,225,233,90,16,225,8,163,241,112,173,15,227,176,197,136,139,114,202,96,151,63,60,96,154,107,17,147,224,206,248,93,53,106,235,229,60,87,165,173,67,60,192,40,25,38,154,183,128,195,41,187,21,254,166,61,76,158,20,29,63,194,131,191,180,111,32,193,245,193,122,94,224,84,142,94,172,150,192,219,151,49,107,61,164,252,204,72,119,227,21,253,120,84,60,176,113,224,172,24,196,92,64,19,6,114,3,127,121,48,40,3,60,52,74,110,225,56,14,140,23,179,58,129,206,230,166,25,190,123,31,5,201,50,253,204,94,174,116,91,166,97,216,90,145,201,152,88,164,18,19,17,202,204,251,146,159,61,233,43,209,63,240,241,168,94,78,86,211,0,62,97,12,204,199,62,218,65,64,9,170,91,210,0,191,56,249,81,51,140,84,246,229,192,59,27,87,104,195,108,174,216,168,188,98,234,57,57,162,193,13,190,155,45,124,40,58,32,99,14,179,68,39,112,92,159,159,36,201,2,226,129,171,120,102,185,148,114,152,162,196,181,56,69,182,37,197,98,228,38,41,142,10,57,84,197,160,183,210,236,9,42,214,224,63,62,31,118,26,251,177,236,185,210,104,244,19,251,195,113,141,34,50,255,204,42,56,117,66,203,139,249,119,14,28,203,175,32,42,245,180,104,11,154,25,127,248,60,200,28,180,91,39,244,161,108,240,140,189,72,32,119,76,235,30,100,46,74,250,110,234,232,192,243,51,124,39,251,186,123,64,23,149,105,161,56,180,49,163,245,34,42,187,145,64,13,82,135,95,186,146,44,214,135,104,194,94,110,93,178,242,130,21,226,63,156,184,127,204,241,167,193,180,9,237,106,90,105,165,19,198,246,140,189,35,66,77,27,170,145,237,170,99,161,189,234,238,51,219,82,212,214,32,43,128,193,45,163,2,216,44,192,84,104,92,99,93,116,94,163,255,90,174,176,184,147,127,46,68,22,63,23,62,151,173,125,237,52,101,54,144,205,184,145,103,197,86,53,11,127,158,118,175,217,13,86,251,47,11,230,181,185,174,212,134,254,17,229,174,154,246,87,107,230,55,252,104,84,104,251,201,66,110,183,24,71,54,10,178,175,12,182,18,163,73,203,244,85,216,175,129,81,60,17,112,71,155,136,34,122,134,137,245,172,152,64,127,55,97,0,148,116,138,88,45,172,16,250,169,10,55,168,155,249,246,117,74,112,183,220,144,84,127,245,255,79,75,162,219,9,150,235,53,199,122,194,58,198,192,83,66,183,114,7,36,198,143,179,218,40,178,248,218,185,108,140,103,50,91,31,235,191,230,109,62,140,189,224,31,241,31,255,48,167,106,18,242,164,95,24,208,232,159,107,188,95,66,187,61,92,245,43,201,191,135,1,41,19,255,103,156,115,9,219,112,48,74,62,113,152,120,196,200,133,105,206,67,75,26,102,159,159,237,244,74,119,46,70,217,24,102,5,82,212,11,224,67,44,241,148,125,122,140,30,141,56,185,122,202,228,228,152,203,143,221,92,116,168,69,113,89,106,187,215,201,255,151,132,143,105,97,52,138,102,179,146,194,72,5,11,142,16,31,119,218,54,11,45,117,143,78,191,169,116,115,101,231,67,196,81,203,175,126,36,74,3,153,52,15,176,118,87,2,10,235,166,166,25,217,24,97,56,174,121,208,62,83,81,159,25,1,81,67,213,89,71,34,140,83,221,7,159,118,96,172,176,235,249,185,28,97,166,17,64,245,165,23,63,251,128,105,12,76,148,92,91,188,236,238,25,184,58,203,60,22,171,192,183,224,144,158,173,39,61,188,92,76,155,181,102,5,187,207,150,94,58,3,250,36,236,210,151,254,24,164,165,111,28,108,229,47,22,146,124,12,137,148,24,184,174,127,13,247,114,83,177,100,178,209,116,247,77,184,99,249,116,52,90,208,48,242,239,23,251,172,248,54,133,62,24,240,90,110,209,64,19,65,231,127,36,40,74,61,89,232,108,40,133,183,241,255,164,20,180,249,37,233,11,144,123,198,10,134,56,30,115,232,181,188,113,167,11,26,133,132,207,13,144,114,236,85,141,70,151,42,10,176,211,160,243,33,210,57,247,197,33,32,215,207,152,153,82,222,95,87,217,232,251,9,157,52,92,92,186,221,244,36,132,244,171,126,222,212,178,213,118,239,52,68,215,228,157,37,229,77,151,40,95,205,177,209,250,59,223,193,65,135,147,161,220,60,30,20,221,12,251,251,237,115,218,76,211,222,227,113,244,133,150,144,25,141,230,202,17,219,118,142,8,254,249,111,8,74,66,92,214,206,5,252,176,47,65,208,174,127,25,182,208,254,125,215,136,104,95,122,148,47,160,24,171,217,115,108,36,46,111,121,54,209,200,78,201,242,47,82,146,153,116,84,30,151,175,199,2,189,89,106,30,113,219,11,101,233,191,165,1,168,238,15,156,187,76,114,205,125,10,232,251,59,152,234,16,241,125,111,195,40,170,83,198,62,219,137,128,20,195,25,33,235,77,95,39,151,116,175,239,44,250,171,84,173,154,211,23,212,157,160,162,208,164,16,244,147,14,14,17,6,104,150,53,108,250,78,227,27,137,22,252,98,238,175,243,37,70,13,183,79,164,152,113,101,78,244,30,197,103,210,103,214,38,156,171,0,17,21,28,178,30,168,20,31,200,208,51,52,113,15,151,103,235,237,40,10,81,34,216,193,173,182,231,138,223,70,74,110,140,135,128,67,193,157,182,109,142,223,157,163,206,148,192,228,100,183,148,130,219,246,217,18,184,83,27,227,178,40,188,85,136,45,33,244,69,87,159,128,40,97,108,157,0,46,148,60,23,222,235,38,205,188,53,18,244,187,182,168,183,237,144,27,24,195,130,65,220,216,15,20,137,249,27,41,218,232,246,197,92,106,119,80,113,188,192,30,233,34,219,39,146,187,114,27,18,165,104,236,249,38,44,105,166,205,230,49,128,243,36,251,113,40,38,25,215,224,120,27,235,159,12,92,34,87,109,158,74,60,6,136,178,187,38,91,137,86,88,121,201,214,195,151,83,64,228,135,143,158,147,97,176,188,111,251,247,113,197,192,23,113,9,177,188,15,65,193,111,153,189,107,45,251,63,75,15,75,144,12,21,147,41,0,174,131,76,50,32,230,156,172,12,21,217,99,174,122,176,90,142,255,218,205,218,102,252,254,211,225,2,68,190,66,50,226,64,173,14,103,174,112,42,47,226,144,59,125,110,69,123,255,9,156,24,136,238,168,115,76,198,25,170,142,181,178,27,82,125,25,38,98,50,248,232,139,82,51,79,162,74,26,73,204,26,40,13,40,2,73,96,105,177,92,99,35,99,110,56,185,105,177,205,31,100,153,114,150,60,150,252,43,129,210,116,71,159,252,129,54,152,242,65,180,226,15,50,224,127,124,175,143,91,38,46,62,8,22,59,186,178,38,77,246,103,48,216,212,109,56,156,174,127,24,51,123,161,249,178,142,219,27,68,158,78,254,94,242,73,34,240,204,200,93,216,7,25,228,165,205,3,19,2,181,77,104,175,11,217,230,194,135,111,69,253,161,56,50,214,192,155,137,146,17,189,167,202,57,121,74,241,142,45,201,161,154,57,125,92,44,130,241,88,74,115,124,14,144,36,13,187,40,11,139,4,59,158,157,206,13,92,151,135,1,219,94,61,152,173,99,202,240,172,225,103,253,248,69,184,171,34,33,169,218,245,125,15,58,199,178,40,202,80,134,75,170,110,92,65,6,58,200,15,51,116,102,229,188,24,164,185,80,221,62,235,227,1,238,159,158,44,47,211,248,136,211,153,57,241,104,231,90,19,39,187,253,118,187,69,91,208,213,90,157,249,110,157,246,186,4,46,212,11,235,27,55,22,236,16,139,224,123,76,76,174,18,156,21,2,25,59,83,147,157,186,202,18,243,139,77,192,205,43,11,67,231,130,169,53,171,6,241,244,138,2,96,125,93,209,194,120,187,162,104,129,237,118,242,149,94,212,207,222,141,202,202,204,103,231,34,132,92,157,95,239,176,202,195,185,87,154,63,219,10,215,8,146,73,190,222,17,110,27,90,35,66,27,93,191,17,12,120,158,138,224,58,68,152,169,243,48,157,252,163,132,148,157,222,184,145,161,202,141,123,93,61,82,14,213,82,53,66,165,100,215,10,77,207,216,139,35,208,176,63,63,80,219,7,147,222,36,12,252,16,92,225,56,96,70,218,129,99,205,25,99,208,253,109,43,104,153,0,224,39,192,163,67,138,85,157,8,128,148,197,89,194,87,99,206,81,141,47,214,217,156,211,187,184,220,33,32,20,31,143,48,136,147,54,141,147,129,53,91,215,115,208,74,187,36,225,92,30,238,23,79,195,80,124,161,28,40,129,212,156,128,13,94,16,64,122,47,166,181,116,236,218,16,106,162,20,12,250,106,59,75,168,173,41,229,75,239,230,135,79,240,61,106,144,243,222,80,207,8,155,238,226,204,246,25,2,83,116,227,42,121,189,61,88,237,200,221,66,111,84,209,44,204,5,74,21,249,236,194,187,52,103,164,109,114,191,27,0,240,99,60,253,103,92,69,90,87,109,109,138,61,171,55,129,98,152,62,65,82,93,47,130,95,171,12,145,48,243,4,220,47,118,144,188,144,153,224,242,141,144,94,218,128,144,77,106,98,182,215,118,91,73,238,22,122,110,3,109,89,91,34,0,57,72,86,228,158,153,209,235,58,200,213,223,68,254,49,210,128,11,87,0,207,25,93,183,141,193,9,142,11,15,213,209,90,220,249,117,222,163,188,42,116,162,111,235,175,70,29,243,205,184,46,214,112,219,68,27,190,37,228,13,196,98,127,58,220,90,248,241,41,128,82,170,102,78,72,99,103,47,49,238,210,203,217,40,130,83,98,143,81,119,52,173,166,24,234,61,253,11,147,118,189,128,69,161,207,122,161,251,67,139,246,0,44,109,95,241,166,224,177,225,201,10,38,201,24,44,192,55,22,191,109,159,167,39,67,213,33,100,6,197,183,223,105,223,51,37,21,232,53,7,12,64,243,13,77,22,76,175,156,127,201,50,147,144,135,179,71,59,88,161,195,29,23,213,184,66,77,202,54,134,198,21,205,74,59,68,197,2,150,28,192,219,164,192,158,231,193,240,26,176,33,136,97,129,95,91,76,114,79,86,97,220,135,80,233,39,150,150,27,223,206,160,84,151,120,226,45,231,200,167,121,200,46,1,132,39,112,88,96,85,173,249,29,67,46,208,224,131,84,81,64,218,16,15,12,243,215,86,157,212,204,147,221,26,11,10,114,75,9,240,8,16,58,152,196,219,149,51,8,94,225,203,7,157,156,249,220,220,207,80,128,47,103,189,58,38,83,183,122,51,230,254,146,160,37,235,226,233,55,164,177,33,246,224,67,54,25,126,27,216,100,83,102,46,231,99,215,206,57,243,30,174,54,153,209,116,17,156,121,215,104,69,33,59,37,187,95,75,158,233,68,148,64,236,174,32,201,143,189,99,126,50,216,65,155,184,98,84,102,243,47,178,99,59,227,198,213,53,206,39,35,180,9,162,212,58,190,48,80,234,176,124,165,130,234,100,117,5,245,122,210,159,134,31,165,144,196,154,81,131,130,236,180,4,23,225,45,144,92,99,117,71,130,142,141,103,81,168,211,2,123,203,171,59,133,24,46,169,116,160,216,233,44,215,66,201,119,51,58,75,50,68,116,127,170,113,129,55,193,109,155,237,246,191,189,150,135,24,5,204,65,201,86,15,202,87,40,122,227,52,245,82,182,54,65,104,165,101,190,208,117,246,203,163,168,171,35,67,186,170,221,100,63,0,206,157,229,28,237,147,132,88,91,215,64,64,22,48,88,246,232,140,146,211,199,110,230,207,238,78,66,78,104,253,244,227,114,94,210,30,6,33,43,1,110,176,2,156,178,126,202,213,183,124,213,218,56,96,100,54,192,53,69,60,180,73,48,142,15,85,251,191,216,147,246,47,251,203,203,138,14,174,9,73,186,102,220,0,200,22,56,137,234,117,155,105,229,151,192,129,193,93,234,222,103,57,195,107,240,92,18,180,41,23,23,255,255,135,26,222,109,47,129,205,129,52,192,82,153,195,24,72,58,156,127,159,210,114,67,196,173,239,17,84,216,115,57,151,70,218,133,179,61,149,175,160,128,222,103,91,202,239,92,198,173,251,58,186,236,105,215,23,167,254,58,4,21,22,17,213,211,230,47,195,183,154,245,187,224,165,236,107,184,195,149,49,79,138,158,97,201,64,138,145,249,37,253,56,175,148,83,197,74,69,186,47,38,63,14,241,224,30,52,152,74,163,144,190,253,92,176,164,109,217,165,118,19,56,214,162,10,193,213,18,95,72,55,150,22,199,50,196,111,155,204,32,122,25,68,234,156,43,178,92,160,204,83,138,2,184,248,7,132,201,144,69,176,216,12,49,175,55,89,163,91,23,159,27,226,183,111,153,13,35,140,237,237,170,126,119,171,55,105,81,53,55,142,131,46,39,136,83,145,158,216,192,73,71,22,117,124,243,85,81,130,52,28,216,143,226,153,141,3,162,141,249,125,8,119,27,65,133,135,123,117,71,161,45,130,255,194,160,178,21,123,106,105,199,3,146,205,115,157,18,61,181,226,101,151,234,244,10,17,216,104,186,3,215,32,157,200,151,190,41,62,181,74,5,160,213,185,70,97,253,164,115,81,108,228,207,4,144,210,54,224,36,93,21,210,109,58,54,121,127,235,182,110,122,161,24,48,114,193,83,31,221,109,136,70,83,212,203,195,232,231,69,5,55,157,106,77,101,19,58,55,127,91,240,85,64,11,229,155,10,93,177,2,144,20,75,121,186,81,171,50,1,196,62,217,231,16,206,250,186,173,24,60,218,230,99,216,36,3,103,61,237,73,61,170,38,35,224,158,166,103,119,128,4,5,152,194,141,234,113,149,54,196,25,235,18,81,227,137,137,138,115,20,204,38,189,115,69,224,31,135,6,32,171,72,87,42,144,71,72,255,171,79,132,159,83,151,209,62,152,25,79,133,19,172,154,90,84,80,101,131,150,37,245,195,199,210,235,98,122,229,215,7,164,79,63,62,80,142,144,161,189,235,24,212,200,109,145,185,104,122,29,112,81,147,15,4,108,147,244,184,155,249,18,80,201,174,227,93,226,109,63,7,17,14,209,141,194,160,30,170,18,60,144,32,224,177,0,106,248,126,107,84,185,179,106,146,13,238,80,251,18,50,96,122,216,217,112,187,148,102,111,47,244,158,22,39,76,59,150,43,22,117,202,253,88,26,166,126,243,142,239,81,69,185,255,93,56,20,32,232,185,22,217,19,198,221,159,42,176,105,127,180,90,189,136,213,241,120,92,0,77,136,165,142,142,126,142,164,219,231,41,237,134,253,191,235,254,252,57,52,25,89,120,215,145,142,87,152,149,107,177,79,86,176,4,105,59,150,254,14,74,110,116,206,16,0,218,98,156,66,18,10,16,202,136,15,80,236,236,233,75,132,186,168,174,233,16,240,124,0,189,243,98,252,33,121,215,44,173,199,127,71,233,97,165,227,102,12,62,59,225,180,119,55,117,95,159,229,177,99,143,111,247,182,37,180,23,219,51,67,250,113,124,122,213,160,93,82,156,170,252,0,1,76,22,11,250,91,147,112,1,233,251,21,112,60,137,25,215,114,231,83,28,55,129,94,198,200,247,80,156,163,198,211,214,235,239,111,210,160,137,128,181,114,163,61,8,94,83,46,49,30,181,239,140,222,109,66,167,226,89,159,32,73,145,21,222,213,65,62,66,94,137,206,128,169,236,73,167,141,150,232,238,36,44,136,68,28,4,21,153,225,253,254,31,210,190,138,17,5,228,142,90,163,91,64,60,208,230,70,88,201,198,140,171,37,112,143,83,251,39,36,63,189,48,135,196,100,189,76,124,37,117,179,153,183,236,97,94,72,5,144,76,23,71,22,137,91,101,17,51,31,37,37,248,167,248,202,225,125,28,24,192,51,67,242,20,243,183,110,138,211,210,110,39,221,189,226,241,100,225,217,111,128,6,152,234,156,179,79,2,139,150,103,51,47,252,21,104,71,84,83,243,17,144,151,52,96,128,26,163,179,77,162,97,109,136,128,106,219,50,111,229,203,148,252,102,19,181,220,239,169,7,60,6,173,111,160,55,24,162,69,223,39,186,222,104,184,206,203,0,68,178,244,108,51,107,230,205,176,248,207,12,225,122,184,184,1,99,226,173,135,71,136,45,243,127,168,160,134,31,180,45,53,1,213,36,43,83,51,59,61,115,223,67,123,54,86,38,128,71,198,210,179,241,150,253,253,1,26,104,127,234,182,86,121,188,19,134,211,19,249,75,96,210,137,255,175,48,38,23,82,107,180,73,87,97,17,31,217,160,77,243,143,164,224,77,154,152,148,205,66,240,48,168,156,21,103,19,214,154,17,173,156,16,31,18,63,134,224,211,145,46,114,33,113,105,125,72,78,202,25,183,28,255,45,63,169,16,225,2,237,156,45,254,223,125,195,250,99,49,156,250,188,216,169,104,171,157,188,114,72,110,29,153,187,99,254,51,237,255,23,98,131,248,193,121,59,142,7,176,78,52,182,134,170,136,125,40,234,245,225,74,212,208,176,105,253,8,32,143,69,180,249,246,10,31,176,129,144,255,199,193,59,12,181,231,207,169,241,243,19,253,220,49,45,195,42,147,102,239,117,186,240,63,156,184,43,225,119,87,44,38,11,106,231,241,208,145,167,222,147,22,240,37,62,139,30,249,0,209,78,164,84,131,254,178,126,91,170,226,29,73,170,154,101,221,202,18,92,146,134,178,38,195,106,88,228,86,86,172,34,113,89,4,85,139,78,39,3,161,49,94,245,107,21,206,162,64,240,35,201,126,89,226,156,229,141,165,29,4,22,197,202,125,44,200,64,176,137,55,95,167,234,104,86,244,217,45,234,206,4,6,171,85,146,235,237,168,81,103,77,204,104,16,110,90,132,100,240,72,96,188,201,254,56,43,229,76,8,144,250,190,182,102,89,64,104,238,222,184,173,138,130,235,233,91,226,30,237,38,236,194,116,180,36,198,97,37,242,32,60,224,15,13,203,190,121,127,41,1,108,205,117,79,104,173,232,164,128,0,31,193,82,164,115,1,175,199,50,22,0,215,136,87,212,105,174,240,47,27,51,93,165,183,61,96,31,150,125,70,38,192,85,215,191,65,159,42,123,59,211,210,39,96,64,53,80,103,134,214,75,89,23,40,114,4,148,61,56,175,176,119,180,61,162,119,184,21,110,204,103,52,202,109,151,202,204,240,215,165,116,96,52,113,64,112,42,171,54,172,169,69,253,44,153,24,232,19,141,73,3,80,141,143,57,23,209,218,79,5,176,20,117,197,223,97,0,0,216,103,205,251,42,189,173,104,182,224,240,187,184,90,150,165,151,54,237,248,21,195,252,26,86,186,43,130,85,173,165,88,77,47,61,60,251,197,177,40,114,201,153,72,161,39,61,136,217,22,39,227,180,112,20,184,0,22,255,248,87,132,120,113,8,6,226,212,166,57,112,185,75,15,83,79,196,106,136,205,5,59,250,63,35,80,140,176,236,196,248,3,221,98,250,104,32,99,152,165,109,139,192,40,49,68,14,50,89,102,202,12,64,120,114,49,227,205,144,18,43,180,65,47,167,89,67,145,180,44,241,173,23,232,86,141,103,210,72,240,225,180,133,221,238,4,125,161,121,44,204,5,162,64,34,84,167,152,247,154,190,162,116,71,83,180,181,174,3,151,227,180,162,28,198,133,1,195,199,54,251,220,4,182,126,209,15,24,207,187,240,50,11,120,250,158,87,125,246,74,64,175,190,21,150,255,202,170,125,38,228,16,24,166,186,7,113,0,133,182,112,138,188,2,24,120,236,10,76,154,89,48,23,228,159,219,144,219,209,76,59,25,100,202,46,203,178,117,252,97,240,97,42,143,205,52,199,220,7,0,109,217,139,126,170,178,227,213,192,16,171,133,173,237,240,186,6,14,155,94,157,194,99,123,174,181,74,164,126,56,178,0,172,77,163,74,172,53,5,161,130,161,162,149,232,150,69,170,172,59,70,142,112,87,58,16,192,67,8,250,29,140,221,17,117,167,133,43,180,141,157,214,18,131,114,105,147,206,25,138,207,188,30,41,9,97,113,247,123,251,56,165,182,239,95,79,152,45,113,160,213,230,249,227,167,149,52,172,156,182,242,134,61,19,90,144,248,100,252,168,76,213,246,126,123,175,8,114,218,41,247,90,229,94,238,86,73,43,35,42,116,168,217,75,167,166,122,230,82,130,255,164,51,9,86,79,111,49,152,198,132,96,62,12,131,23,66,96,51,213,29,13,144,20,26,228,66,41,228,68,254,126,173,192,51,62,41,184,136,182,93,102,144,250,65,236,200,19,121,182,87,125,72,97,132,164,29,130,211,26,115,217,177,199,35,54,132,98,87,138,188,229,34,130,240,81,186,231,130,41,17,74,64,27,41,169,251,229,192,38,247,81,85,224,10,181,80,164,164,112,73,150,53,119,166,144,157,52,98,187,48,28,64,77,33,237,100,1,46,123,40,27,232,128,105,190,126,27,132,205,16,107,184,30,187,240,29,128,81,177,9,175,37,159,188,53,109,59,15,33,102,39,182,31,73,163,176,14,150,178,216,231,41,152,253,100,240,46,106,181,137,111,240,101,204,74,57,134,179,49,230,134,124,152,70,64,166,43,65,203,80,53,157,166,39,138,142,243,74,145,217,9,194,93,128,67,93,129,161,161,254,211,189,239,205,32,171,253,118,141,204,240,183,222,146,198,220,187,58,201,238,218,179,206,89,183,40,198,33,53,38,40,144,216,247,161,189,216,173,9,22,72,148,174,45,3,127,35,125,111,140,15,207,119,246,38,244,195,69,85,106,121,28,241,125,124,103,116,108,152,84,133,165,68,92,5,189,160,223,125,159,69,84,91,214,24,52,36,207,180,152,8,156,70,209,194,220,165,138,212,192,246,132,124,186,64,218,179,23,131,210,117,7,15,197,250,249,187,104,74,19,195,232,168,66,171,125,133,252,89,123,236,67,152,150,187,82,161,241,29,160,206,15,254,101,201,34,79,182,6,88,237,204,67,3,24,199,64,58,22,71,118,31,80,235,148,111,111,74,248,229,15,0,160,215,0,121,227,15,243,58,122,251,203,236,223,102,217,235,105,113,239,209,206,227,198,166,116,250,85,48,71,14,78,216,2,167,129,129,240,167,56,89,118,161,125,49,228,56,221,13,219,207,36,68,253,27,45,219,117,151,229,111,247,206,97,173,132,8,74,182,16,125,54,238,31,46,244,50,250,3,216,182,42,120,67,61,39,106,101,23,248,21,80,151,115,41,105,95,47,32,90,53,3,164,31,12,113,105,26,135,101,186,43,191,173,143,177,4,75,109,96,7,121,5,231,218,250,45,96,254,193,146,225,251,238,21,240,27,207,43,187,7,61,254,195,234,210,152,46,241,186,188,216,234,82,179,109,61,190,139,211,58,36,74,149,107,249,150,196,71,226,167,232,40,42,19,152,17,194,16,94,5,11,57,37,43,99,98,248,81,211,60,69,192,80,94,225,241,197,53,76,100,1,166,253,132,17,3,72,232,72,214,60,18,151,159,15,167,78,27,76,142,22,21,129,121,10,185,35,246,49,165,218,73,182,236,65,1,175,236,230,71,209,189,163,164,179,194,209,86,6,180,219,147,94,15,212,246,83,21,183,250,40,230,78,222,159,74,94,13,20,247,51,90,218,253,125,50,81,72,93,1,200,50,199,223,192,197,223,38,208,98,122,118,7,82,178,154,193,50,199,199,7,184,231,120,39,2,232,41,182,32,75,56,236,176,5,0,113,190,13,109,1,175,212,249,89,21,130,204,162,228,119,244,190,87,252,151,13,40,209,103,93,95,199,103,141,133,122,94,189,161,222,26,229,214,114,137,110,97,84,81,251,213,80,122,215,144,113,154,105,12,130,191,24,0,226,159,46,86,119,142,104,231,72,118,224,91,195,94,179,212,168,32,243,2,25,219,4,197,34,167,252,198,18,155,87,88,62,165,118,253,176,96,152,186,128,214,140,226,59,11,113,104,102,96,136,126,9,13,140,165,46,116,134,52,249,105,131,168,226,83,93,216,194,247,236,251,159,42,118,243,93,85,175,120,106,134,75,146,217,187,183,49,138,190,5,189,3,203,106,166,110,104,108,70,111,165,41,203,34,212,254,32,10,2,238,30,243,126,47,119,175,63,107,73,75,131,105,17,54,253,158,128,179,196,198,64,151,178,55,47,159,191,106,78,234,208,198,108,42,131,2,33,44,121,43,48,137,107,252,205,15,84,242,200,169,148,239,199,117,248,6,151,51,83,45,149,57,75,160,202,27,122,235,14,50,90,135,90,94,140,171,241,123,236,90,200,243,190,6,111,165,246,139,34,141,151,172,38,34,66,201,218,83,110,52,12,146,6,26,248,102,120,174,193,25,147,171,152,87,174,79,55,208,166,73,111,90,214,25,117,239,102,226,213,182,128,93,49,129,174,3,2,180,9,250,166,8,32,141,187,26,55,157,229,144,64,195,91,154,133,56,176,6,198,60,119,115,232,70,213,143,59,250,97,136,50,75,125,198,19,151,141,168,48,163,47,67,211,114,119,103,69,9,119,244,236,196,164,248,228,69,215,205,245,16,57,177,244,43,224,109,172,45,14,5,161,195,63,81,38,117,19,125,248,179,103,199,168,84,151,192,55,216,72,96,43,117,199,103,51,202,42,177,40,169,84,157,153,173,244,141,108,142,38,188,53,35,151,221,147,12,148,111,151,129,212,37,253,142,191,152,21,241,153,150,30,71,95,49,124,83,150,47,109,169,199,96,70,141,167,74,79,11,152,159,93,215,159,185,141,249,140,114,217,75,87,133,177,114,114,27,32,86,10,246,20,157,127,160,164,227,79,194,177,107,49,142,179,84,144,135,178,81,30,7,228,120,116,11,103,210,83,15,94,77,40,116,144,27,125,81,192,231,217,112,4,184,78,6,144,65,184,221,84,114,52,150,241,217,130,114,219,252,15,34,244,209,76,178,193,231,229,38,137,147,0,147,242,150,26,33,32,28,132,60,63,134,221,9,214,135,97,120,217,109,78,130,199,253,153,215,234,19,186,201,199,169,20,132,151,74,179,54,65,25,171,126,126,88,23,247,222,39,52,65,85,45,245,229,214,38,98,14,0,10,216,42,17,230,34,91,84,144,209,31,186,211,140,175,188,80,202,99,174,124,88,40,32,214,235,133,253,145,179,186,102,42,135,61,67,235,163,133,41,35,25,168,87,141,24,186,210,233,150,19,220,120,81,123,169,245,18,197,27,207,176,15,197,115,139,69,152,82,211,148,77,184,232,173,29,253,46,123,173,245,217,54,231,135,218,236,101,196,45,109,136,189,206,68,215,214,77,251,43,39,224,144,62,135,50,114,247,67,110,247,38,143,220,5,1,173,142,88,7,149,152,225,194,10,114,152,121,105,239,242,249,117,29,172,2,39,98,218,33,31,69,93,11,210,222,132,40,251,162,173,144,13,165,165,242,181,202,215,89,196,228,253,39,70,73,153,144,63,184,211,2,204,107,51,166,197,173,14,15,96,66,141,11,12,244,148,50,16,214,9,8,52,6,165,105,91,184,10,10,62,135,250,200,159,69,227,229,86,98,229,73,27,200,217,108,233,211,81,90,93,45,50,50,149,19,35,23,116,202,113,21,211,33,217,140,128,86,228,185,130,140,104,87,180,174,131,213,254,48,90,67,239,159,204,139,229,42,236,142,82,151,187,165,11,12,150,53,56,10,76,97,213,117,217,51,242,133,135,229,78,117,95,26,31,69,32,138,147,70,226,136,42,0,8,199,224,233,35,206,48,207,61,99,52,101,204,118,143,245,236,120,33,226,57,223,53,32,255,6,236,127,223,89,137,99,84,204,80,106,20,237,64,149,193,65,7,41,202,120,56,115,112,137,35,254,243,28,47,4,229,33,115,177,48,219,231,48,63,139,95,214,209,6,170,197,116,222,104,88,254,141,16,48,222,226,9,47,121,65,188,142,38,129,229,60,122,25,131,229,78,249,211,139,93,199,181,248,231,247,38,161,131,223,146,216,88,123,189,77,186,220,2,185,53,173,226,101,153,213,103,171,140,207,44,51,120,168,36,182,213,176,87,166,170,61,250,49,139,249,215,135,168,170,59,95,118,142,249,166,177,121,94,175,159,219,228,219,117,28,222,43,180,225,108,140,7,25,5,94,45,171,5,65,137,255,40,123,190,89,181,94,76,172,91,161,197,240,85,79,172,28,47,57,205,233,102,137,143,28,155,20,20,157,41,148,175,43,167,5,82,171,148,109,247,237,236,176,176,124,1,158,189,93,168,51,115,231,208,228,55,164,123,212,27,25,190,38,1,120,25,153,91,236,95,116,67,210,173,224,156,220,91,207,120,91,114,212,191,71,198,205,146,136,65,91,33,204,192,154,155,243,71,11,55,239,100,89,204,247,199,59,120,22,68,109,137,194,203,81,61,247,11,226,242,210,155,195,209,1,193,108,163,178,20,22,170,30,148,214,80,229,153,91,103,246,237,10,245,110,211,150,205,98,239,92,94,71,206,91,253,204,90,157,216,152,35,148,167,8,201,167,24,239,191,158,102,23,131,159,64,99,81,159,58,193,185,68,1,28,24,38,198,132,80,191,19,122,235,99,129,100,49,253,29,52,194,32,108,106,166,243,179,53,189,96,59,73,241,61,32,223,84,218,118,59,32,64,9,98,239,207,219,101,38,106,54,148,148,25,5,50,107,106,152,242,117,192,102,56,184,19,232,133,157,243,182,52,144,217,94,101,153,221,88,157,52,224,159,93,159,71,2,115,200,230,116,202,177,236,75,20,176,16,39,147,24,150,195,21,251,77,57,185,113,216,168,48,127,164,56,104,92,23,85,141,159,93,53,192,103,163,130,24,85,85,160,61,246,23,185,196,18,158,228,129,148,126,206,52,198,191,182,12,98,112,31,56,160,62,208,196,234,1,56,249,23,61,115,25,164,254,151,45,11,124,107,53,151,131,221,52,249,185,90,5,4,129,177,134,168,239,37,50,111,225,178,53,251,9,5,87,32,111,75,239,38,160,33,50,128,211,5,250,31,61,177,31,115,182,221,118,33,225,75,165,5,43,89,152,62,217,185,246,122,194,98,47,193,42,74,46,144,111,16,231,76,88,151,7,93,68,144,237,82,117,206,167,239,6,137,55,125,14,88,92,201,143,148,62,216,55,224,150,178,38,77,42,167,163,233,124,131,220,55,50,219,117,225,244,220,233,124,27,133,246,213,86,54,152,29,92,98,226,98,54,110,144,186,41,161,225,72,199,30,105,121,160,56,141,23,100,40,88,208,169,32,196,122,95,231,57,244,199,120,13,232,165,250,170,24,34,231,23,205,33,18,214,128,56,165,14,48,104,223,133,183,73,58,100,111,112,115,239,70,81,81,38,94,88,232,164,212,242,0,59,114,36,133,89,252,41,204,37,193,144,244,255,242,124,20,131,112,126,131,187,205,71,229,86,90,197,199,245,45,120,190,56,223,164,63,177,75,188,238,180,176,137,182,95,221,29,158,104,4,224,38,183,94,172,67,44,62,168,237,218,85,159,58,25,168,173,108,204,228,81,18,145,207,176,19,10,212,78,133,108,169,178,117,11,19,155,152,200,117,243,99,143,126,93,75,167,4,103,249,245,27,30,184,78,162,35,174,200,4,59,119,138,195,58,130,59,179,147,48,207,134,201,207,31,90,145,168,212,195,79,220,16,253,80,24,42,159,61,178,241,81,140,246,198,225,166,94,74,63,254,3,218,93,2,74,194,239,192,68,55,75,132,51,79,200,162,72,133,34,87,86,7,157,235,37,94,78,191,150,81,213,162,147,20,232,243,173,36,1,244,91,3,192,10,224,194,229,74,147,19,192,165,168,153,5,127,230,113,185,206,127,146,80,114,246,179,16,31,90,0,242,254,82,189,36,246,211,7,118,168,33,154,220,184,107,101,40,150,196,194,242,253,216,72,132,210,147,230,224,198,34,75,25,74,233,205,159,168,6,197,50,217,127,251,94,27,0,89,55,171,138,10,197,251,46,127,84,139,97,212,131,44,89,5,181,154,11,223,2,106,249,29,222,72,44,89,57,56,8,138,102,140,86,159,219,77,239,32,203,126,142,214,192,72,16,119,161,71,155,250,58,115,189,112,51,213,249,25,85,78,170,171,102,164,103,133,109,37,229,130,167,116,64,21,234,76,246,89,206,141,235,89,223,141,56,47,168,166,97,190,26,197,70,97,133,200,148,53,45,183,39,129,38,122,174,116,58,75,115,221,204,101,52,24,94,177,14,237,2,172,234,210,8,208,25,77,235,113,24,108,216,242,184,180,255,173,101,240,51,246,200,240,13,156,209,93,60,66,170,252,82,230,13,215,146,117,255,210,7,34,122,10,106,156,176,21,68,222,248,33,83,152,206,191,60,18,158,149,114,74,41,60,203,244,210,249,189,212,25,25,75,131,95,76,207,254,188,23,124,249,162,255,170,137,0,81,97,181,221,127,2,120,240,234,80,28,115,105,158,136,89,77,135,103,255,251,8,186,242,63,176,164,122,8,11,128,19,58,243,8,212,252,204,84,170,108,158,179,247,0,254,32,87,139,213,136,45,180,92,145,67,92,246,247,205,97,103,87,101,163,137,0,61,23,230,147,218,153,102,235,104,17,24,246,70,190,79,179,238,178,41,56,128,115,241,148,114,229,173,144,63,54,151,123,191,45,145,222,89,230,29,59,34,163,123,120,56,34,137,149,161,32,221,255,87,39,50,57,112,84,159,209,51,170,143,167,190,117,145,202,12,127,248,132,142,52,118,154,247,22,242,179,161,240,146,155,7,176,79,18,1,228,242,227,81,34,121,92,236,105,176,207,233,51,86,159,119,70,173,14,42,103,31,241,149,157,98,49,61,96,106,94,142,12,146,88,63,16,173,84,14,216,170,188,7,119,188,94,156,24,78,218,117,39,252,216,201,136,241,118,24,231,164,15,9,211,193,68,14,9,140,214,99,95,235,172,219,136,83,12,95,75,88,48,152,236,153,95,137,236,38,125,35,176,220,87,52,101,106,40,172,224,140,105,118,201,227,143,43,59,162,152,247,197,72,70,232,183,21,160,2,64,169,41,69,166,102,52,189,217,130,19,196,230,34,133,35,31,17,193,45,252,112,79,79,223,99,168,154,14,19,74,179,41,246,27,199,128,101,54,80,252,173,165,241,80,26,204,142,255,57,94,25,56,246,22,133,229,144,110,212,118,251,36,49,81,254,183,116,222,99,70,181,22,74,96,199,161,124,176,7,199,9,56,128,64,200,185,222,37,225,144,156,152,22,99,76,208,43,99,207,169,146,220,182,136,30,96,166,118,49,125,40,132,106,49,212,158,91,55,84,208,213,75,63,190,113,71,83,98,109,21,176,11,204,253,157,79,106,111,232,239,253,187,98,141,32,52,39,209,183,100,176,183,32,232,137,209,189,13,67,230,44,99,233,235,31,211,62,149,120,185,114,79,123,8,153,151,112,255,65,154,228,16,226,177,21,18,10,146,172,134,181,123,4,253,122,188,229,98,89,112,147,19,145,108,246,176,210,201,128,231,96,230,39,140,7,175,246,144,253,114,34,223,14,48,134,160,78,112,135,138,197,142,208,213,221,156,197,198,131,42,169,203,191,140,36,205,131,59,11,239,147,205,235,193,132,59,199,198,42,204,244,120,24,172,221,253,85,141,118,110,76,153,91,146,222,142,200,251,52,172,145,250,47,123,86,49,253,220,27,77,170,51,36,179,148,26,32,251,162,197,246,163,248,65,123,233,68,194,166,153,206,118,238,22,134,49,13,218,176,11,183,124,197,148,169,251,224,80,11,209,166,233,229,19,220,114,244,144,246,17,131,119,108,78,6,26,238,121,82,13,57,179,139,149,164,255,235,181,20,240,76,155,71,61,89,192,100,16,244,93,71,199,139,70,203,107,44,233,154,66,40,255,1,15,20,206,89,244,23,68,123,164,177,175,187,170,150,195,150,44,96,99,142,169,220,220,197,235,124,72,198,60,112,180,196,35,190,154,107,29,177,10,243,111,210,61,157,156,223,255,101,5,210,27,224,15,23,138,119,65,201,139,134,84,70,122,22,204,153,5,193,108,54,149,173,173,37,200,81,229,93,72,7,45,14,51,177,85,166,96,189,55,43,70,88,172,251,17,221,163,81,62,196,216,14,31,82,46,38,65,125,42,32,4,9,145,100,31,102,106,231,86,31,167,246,39,11,28,118,34,92,179,80,65,191,115,43,247,211,118,115,124,156,122,145,222,177,73,161,7,117,51,20,29,178,100,26,127,202,208,177,209,121,101,140,194,20,229,139,123,55,186,209,31,33,39,115,64,97,128,152,60,147,70,35,97,4,156,87,181,58,244,132,109,115,229,91,215,10,28,25,21,57,163,234,21,101,81,18,220,78,130,105,85,41,164,78,228,156,201,182,234,93,221,241,194,212,66,84,4,11,81,116,94,234,37,200,8,214,228,253,58,205,250,62,168,189,1,46,223,0,158,154,29,127,247,188,25,193,165,228,117,234,121,149,167,254,11,3,15,12,91,42,46,11,240,230,134,120,108,46,58,63,23,230,140,113,173,206,94,55,63,20,187,32,255,142,32,192,135,161,231,95,115,204,50,125,129,245,15,153,89,124,35,87,200,91,78,68,126,100,158,103,224,232,192,132,174,34,19,19,48,139,182,247,255,70,88,227,139,253,31,10,222,62,188,140,85,169,143,143,14,29,108,159,46,98,211,30,129,63,149,77,230,246,61,181,103,153,124,242,214,63,70,78,193,78,208,159,94,20,59,30,81,88,112,124,123,183,101,239,217,86,232,137,59,250,5,110,107,71,27,31,15,33,62,200,161,218,153,82,134,5,7,141,180,7,152,169,23,182,33,150,252,223,90,209,54,177,15,50,19,8,253,37,226,84,143,33,164,230,38,215,102,42,156,198,36,35,149,175,75,79,102,252,69,215,7,165,103,252,189,221,18,204,32,86,110,22,47,74,38,247,11,126,5,145,242,247,20,9,190,177,121,79,16,110,73,41,45,141,3,247,35,3,252,191,45,7,156,127,115,198,74,194,5,25,124,110,61,109,115,151,84,72,182,140,170,23,217,123,133,98,143,18,53,128,55,78,61,89,152,214,253,63,133,196,183,215,107,107,158,245,129,15,153,169,246,158,65,172,8,47,226,30,126,10,64,163,175,108,218,130,19,89,235,34,206,150,176,199,6,140,234,201,165,130,107,208,64,112,36,44,115,250,199,236,204,60,127,43,124,225,163,49,76,103,210,254,126,180,82,44,230,68,93,12,246,201,186,72,190,172,76,128,42,173,0,221,120,14,150,19,197,121,163,71,111,214,183,143,24,187,70,13,255,228,250,134,173,209,183,166,208,21,225,94,109,145,98,70,255,76,151,190,150,183,152,248,238,224,187,111,4,2,111,236,73,135,133,67,34,193,94,52,159,42,187,59,38,75,152,72,134,112,236,191,233,150,43,156,14,167,70,226,7,114,200,31,140,164,33,84,232,169,15,96,172,175,192,57,229,71,227,101,139,17,90,45,154,32,255,204,159,141,200,159,147,45,152,135,128,51,11,78,181,154,83,92,144,157,134,244,234,140,201,95,218,104,165,146,35,28,223,139,111,128,149,30,162,119,191,217,136,196,219,138,212,22,168,182,19,118,34,168,68,234,104,231,59,166,128,52,254,212,215,218,117,66,31,249,88,61,78,33,130,242,94,66,17,169,102,100,130,251,1,125,169,71,110,165,239,246,162,251,220,185,184,20,76,133,171,122,57,219,218,181,169,220,38,166,27,206,53,166,180,135,172,64,7,187,131,182,110,67,34,191,25,145,197,184,217,30,140,72,15,212,194,123,34,239,194,64,110,117,35,199,82,17,157,252,230,226,228,44,151,158,81,101,191,59,18,175,143,139,235,12,185,50,15,106,29,143,82,247,211,52,208,35,153,64,11,50,37,13,38,232,128,45,104,62,240,201,122,137,83,140,250,178,64,142,202,168,54,119,221,215,71,166,35,108,71,223,239,99,153,12,8,134,64,200,182,235,107,96,111,231,153,200,254,189,247,49,93,127,4,200,77,43,160,120,224,252,243,224,46,190,166,143,82,46,207,86,235,116,203,190,88,18,55,121,70,227,215,107,69,58,245,221,133,33,73,230,34,36,254,49,127,129,180,253,175,209,180,54,94,124,96,104,97,243,225,38,248,166,230,189,233,78,38,61,122,43,51,76,9,219,127,1,239,79,151,48,213,26,208,118,80,108,178,180,167,38,224,5,87,106,12,73,252,109,195,190,244,1,237,106,212,236,116,74,192,255,121,219,152,67,18,77,38,21,51,27,121,200,196,0,84,219,179,46,124,54,85,12,179,49,241,46,197,14,33,28,79,227,246,94,112,66,187,209,230,116,161,40,15,78,57,156,110,138,178,73,41,255,178,62,43,236,180,171,248,21,243,240,13,110,71,67,79,176,57,76,207,194,20,219,223,36,60,83,50,200,87,245,137,235,132,89,144,67,4,174,55,221,14,212,138,175,187,209,186,54,80,178,238,243,36,9,199,108,128,111,120,61,208,105,53,44,233,236,78,63,226,71,197,238,242,101,100,227,70,160,209,41,198,56,65,115,138,237,132,126,95,23,46,122,98,177,164,159,251,98,212,145,111,203,95,36,21,53,163,88,57,51,139,255,60,181,38,187,107,75,128,165,215,232,130,56,103,173,192,192,119,72,104,142,246,79,232,200,17,207,225,61,55,106,74,61,126,180,229,233,187,223,190,82,11,232,15,84,52,13,98,154,199,134,191,227,132,219,235,17,230,249,92,249,34,165,54,132,101,234,209,220,66,6,69,181,50,132,160,155,246,171,5,167,56,49,27,175,90,222,36,13,217,116,128,9,151,3,203,43,43,40,205,132,14,248,28,88,180,107,146,95,19,175,0,109,41,170,148,148,54,179,0,71,101,59,99,221,143,205,42,59,156,112,136,31,59,18,231,136,191,41,46,122,77,101,152,172,123,108,116,111,53,229,4,163,218,156,39,171,198,100,223,236,90,205,126,143,72,67,138,159,241,118,154,239,154,219,34,182,123,33,163,113,46,15,249,238,36,50,215,132,241,226,207,196,181,96,162,212,88,224,190,81,179,12,136,146,122,238,83,129,26,72,105,125,20,146,253,67,112,232,12,188,96,52,161,160,121,241,50,77,49,218,20,78,169,246,196,95,213,12,11,243,170,71,1,244,78,233,115,143,34,201,250,23,100,9,97,17,4,211,193,128,42,106,170,138,9,75,28,208,247,157,32,4,210,106,87,15,97,167,209,22,160,123,52,183,148,194,21,14,53,212,119,43,76,147,154,56,43,175,79,109,103,68,93,115,95,230,242,89,230,162,136,47,37,79,109,220,24,217,83,40,241,45,113,250,138,133,115,120,72,115,222,65,36,226,44,1,172,128,192,152,113,44,162,139,24,194,114,139,90,162,31,228,198,129,96,97,224,87,232,183,43,193,104,251,129,67,148,240,227,100,4,27,202,89,241,226,221,189,142,102,74,1,234,197,88,247,95,217,142,161,58,118,124,174,252,162,242,248,126,19,199,138,191,202,209,59,204,127,100,65,187,50,108,197,107,107,205,55,228,48,246,168,68,28,74,186,102,54,116,29,188,57,221,206,122,202,240,151,15,23,162,146,91,12,88,51,69,3,110,205,52,5,186,49,46,171,126,221,23,30,236,45,162,17,198,211,238,177,147,106,5,203,206,78,143,1,167,153,96,15,225,28,219,223,209,68,221,218,102,32,19,138,90,130,254,63,73,240,165,99,150,83,198,65,210,22,92,216,204,186,182,213,249,35,2,80,190,138,101,47,225,210,232,29,85,90,174,228,82,244,173,189,193,47,20,238,93,189,172,27,25,87,244,243,224,87,201,186,153,42,69,160,195,77,180,136,128,231,197,161,163,94,0,191,87,57,125,254,155,170,223,110,165,95,181,188,82,153,240,68,118,58,137,253,184,248,35,170,207,20,197,246,93,21,36,48,195,147,75,92,94,166,34,77,198,225,189,122,91,111,136,32,138,146,132,33,113,35,32,184,97,10,255,132,98,61,203,100,65,30,160,150,30,85,22,8,32,101,187,142,240,176,3,67,219,207,113,202,242,213,177,61,155,141,225,69,7,10,3,184,65,132,69,241,149,214,97,91,168,150,187,136,18,190,15,66,134,232,239,202,169,247,10,160,246,157,238,77,41,185,221,165,157,108,94,145,231,229,169,101,1,167,15,161,20,158,211,139,204,107,228,206,211,185,65,246,158,167,12,107,190,45,182,28,192,44,106,148,62,159,222,82,10,227,237,251,3,151,152,139,76,162,183,169,202,107,181,200,129,195,124,71,208,135,234,26,203,154,53,208,137,99,150,100,142,114,50,153,183,126,133,1,253,9,202,235,65,46,106,126,8,5,105,93,53,17,35,209,62,117,114,152,57,29,66,71,127,2,130,103,158,7,17,86,195,64,229,219,75,195,212,33,209,50,154,59,27,177,135,24,163,107,219,137,197,220,7,153,96,131,0,65,187,83,25,18,15,100,245,27,6,174,119,25,182,124,115,158,7,84,182,105,34,75,231,222,190,48,233,221,49,119,79,153,174,200,28,223,87,37,72,254,237,189,199,23,239,255,69,27,152,251,104,233,142,231,80,48,149,197,234,170,200,149,73,120,9,20,212,128,69,99,144,23,22,83,89,207,47,19,17,198,156,214,226,55,130,85,146,54,5,58,224,214,6,27,36,31,164,126,182,225,53,4,52,100,11,28,220,125,41,101,102,215,188,97,6,55,113,252,140,78,81,115,58,203,129,115,132,109,206,21,68,78,20,128,95,62,34,72,211,75,41,78,234,223,115,175,57,229,107,227,179,9,162,15,86,211,207,126,44,120,162,65,99,15,187,57,91,18,41,138,119,15,37,90,138,187,40,13,121,164,30,26,160,7,116,143,9,149,10,228,215,85,75,134,113,241,72,248,12,116,160,177,187,166,188,208,252,178,182,169,220,121,139,203,135,116,198,224,193,215,214,189,110,168,68,129,130,192,8,226,15,122,181,16,37,227,17,156,38,246,249,4,89,193,12,237,32,109,66,52,139,50,235,10,231,210,19,204,191,161,192,238,27,142,203,62,146,194,119,135,132,70,245,214,127,209,179,254,19,43,72,110,124,118,71,34,142,134,163,182,130,140,131,160,56,194,13,10,6,8,136,131,171,206,237,108,163,127,8,17,208,116,17,165,125,236,166,45,180,115,123,110,117,255,84,33,201,176,66,60,220,2,92,128,59,50,147,27,232,7,251,48,118,128,215,225,182,113,163,1,165,184,212,132,246,28,57,13,84,140,97,222,230,172,120,254,160,216,70,239,215,0,111,160,68,51,0,31,109,79,49,38,221,94,95,37,226,200,239,75,160,227,1,122,27,49,244,122,133,67,125,60,12,216,60,89,219,92,146,252,169,205,31,71,112,119,174,142,76,205,10,173,28,31,26,119,222,159,151,151,214,150,124,197,51,174,17,3,58,240,120,130,175,51,87,155,106,76,197,143,86,226,95,45,72,196,34,230,99,248,121,236,163,207,67,132,152,165,42,252,107,111,171,10,114,221,71,94,190,87,197,251,236,116,86,60,82,253,64,166,236,178,150,126,252,230,179,186,45,52,123,29,16,175,237,157,13,213,215,69,153,217,233,51,38,227,186,80,200,188,65,110,196,78,3,202,66,175,161,253,111,249,120,23,44,176,170,211,138,243,128,128,115,108,85,27,23,107,91,1,212,31,154,136,228,166,30,96,59,92,34,162,61,242,225,232,47,195,154,45,144,74,125,246,69,128,166,229,187,39,196,152,5,66,133,189,18,245,235,31,214,153,14,205,11,130,1,238,167,83,107,14,41,235,8,139,62,37,74,87,110,189,142,226,150,1,219,52,58,115,150,62,55,66,239,30,11,157,138,57,159,200,148,184,237,250,169,248,88,159,137,188,98,30,50,189,59,15,225,149,129,184,102,146,114,254,181,178,143,54,171,186,63,219,29,83,52,76,222,208,189,242,11,81,188,87,249,54,213,162,246,147,7,72,54,22,48,119,146,108,131,16,194,137,175,45,132,109,33,243,243,40,190,135,54,116,177,29,228,193,151,91,207,114,183,37,198,58,44,53,196,42,118,27,144,95,155,137,80,255,233,76,228,204,81,135,24,99,82,230,130,134,134,90,185,64,21,78,113,200,124,44,66,8,202,250,219,158,245,90,117,100,130,99,79,193,113,76,66,140,147,91,76,194,35,42,183,235,58,162,251,48,190,103,86,96,173,72,202,179,222,118,203,182,225,42,46,211,245,250,204,238,192,46,2,210,178,141,212,84,160,233,228,60,100,58,151,244,252,138,108,189,119,187,104,222,9,36,11,182,33,204,41,164,233,176,152,233,86,233,50,206,99,64,128,110,66,233,201,123,179,225,189,88,55,210,152,178,238,149,204,213,200,212,190,228,170,205,255,165,46,209,51,91,74,229,36,181,120,52,6,82,169,229,225,218,231,110,222,218,6,179,193,106,30,34,243,244,157,149,112,198,254,119,89,250,217,97,62,28,209,188,203,80,211,129,242,222,66,129,254,133,112,29,113,174,62,6,239,237,224,23,116,214,189,215,75,239,171,17,204,68,178,19,31,37,201,108,153,71,126,166,217,28,201,87,186,193,62,200,110,44,41,74,172,66,60,174,120,134,18,85,137,113,240,138,170,198,225,97,115,26,202,243,51,96,31,18,185,179,52,52,98,63,170,11,216,247,18,9,35,203,107,220,12,6,21,178,236,232,102,112,57,211,73,9,28,24,100,146,157,25,199,182,169,71,71,6,60,175,82,210,8,190,110,18,136,70,15,43,13,60,52,12,43,123,111,248,2,36,45,160,215,73,52,54,36,80,105,210,238,113,115,116,84,251,91,72,109,192,195,188,108,51,89,2,189,86,142,28,210,69,246,138,253,85,224,49,223,6,47,125,40,72,173,56,214,70,132,134,51,244,168,101,112,151,126,77,102,143,239,4,13,116,106,10,103,119,126,65,6,31,18,107,68,76,241,127,130,133,186,61,250,68,253,189,150,134,117,83,51,83,25,187,118,78,134,35,123,184,148,245,53,68,14,88,131,0,68,159,141,48,76,196,130,198,34,56,19,203,64,75,87,26,133,28,73,19,242,167,183,2,251,172,114,9,7,155,151,79,86,68,141,54,101,212,74,210,65,219,237,175,83,252,71,245,207,108,46,196,105,180,46,85,217,5,128,221,226,157,62,176,224,25,140,26,228,142,51,187,96,116,42,92,18,197,211,133,4,0,207,161,141,187,60,8,215,220,174,187,41,153,27,83,242,133,205,30,135,7,207,178,168,111,3,85,173,149,137,68,187,204,184,237,209,59,41,154,36,35,7,212,199,183,241,25,178,86,195,41,137,201,81,164,246,218,251,180,218,161,189,193,147,17,147,15,78,69,23,170,86,93,28,58,170,81,208,143,20,240,63,182,158,203,197,94,135,254,11,135,124,183,89,193,71,88,184,98,208,164,134,197,140,75,234,159,83,20,177,109,123,195,118,229,245,116,207,220,6,11,187,253,37,198,220,195,29,176,38,46,67,200,232,90,245,23,105,165,133,57,29,208,185,232,69,180,3,5,19,111,91,226,98,197,90,102,20,243,203,137,88,156,217,18,24,141,253,17,194,150,75,120,212,232,5,187,191,80,176,71,27,94,71,149,230,108,103,17,129,248,166,186,196,171,152,249,136,146,130,38,204,223,106,175,46,105,241,113,125,212,159,243,233,110,229,177,187,141,186,157,99,212,232,218,25,58,4,212,122,110,11,236,187,184,12,168,127,135,212,37,81,184,79,102,171,143,151,189,158,113,56,80,94,110,58,223,118,37,73,53,158,134,151,251,250,216,143,88,233,8,206,211,238,115,195,53,186,238,140,128,150,50,225,14,236,49,195,224,75,85,229,24,20,244,72,136,144,15,96,152,6,156,158,133,144,200,229,50,186,234,205,77,101,31,5,147,136,55,31,158,100,141,179,213,225,15,161,176,225,156,40,169,60,57,227,45,170,44,97,107,83,178,31,102,192,84,212,43,159,32,188,252,47,248,53,6,68,8,126,187,27,46,133,214,4,199,153,29,177,123,35,170,100,66,253,178,46,37,206,97,62,17,208,98,178,195,223,64,76,251,94,132,241,102,36,130,182,53,98,94,253,122,211,197,204,144,195,101,203,40,158,215,192,102,44,87,233,61,81,147,158,79,117,222,27,26,219,168,15,59,142,65,113,172,49,253,190,191,188,12,59,244,226,238,7,59,116,34,120,56,20,118,83,59,78,142,79,43,150,41,207,228,35,234,182,14,86,50,120,254,31,74,82,5,29,39,173,104,87,10,249,237,158,29,211,250,239,50,64,90,200,107,209,100,26,135,182,38,139,177,27,64,6,87,21,235,204,230,235,222,248,48,156,212,204,138,22,36,123,3,40,93,25,200,55,162,51,116,3,140,58,246,81,78,59,89,103,138,23,220,89,171,48,48,203,181,80,163,171,109,173,17,34,188,238,42,205,32,106,18,122,80,8,247,127,26,32,148,141,138,226,57,27,129,234,74,40,235,202,6,106,127,1,11,117,117,236,240,123,227,139,185,241,205,42,57,186,237,83,21,90,3,25,88,42,109,224,140,238,11,177,108,46,111,28,229,139,95,217,72,101,173,235,131,28,2,85,51,19,52,105,218,235,176,84,57,140,165,80,238,93,92,6,47,138,188,132,100,36,219,223,236,201,112,201,190,0,20,146,68,95,16,147,1,52,108,54,185,188,154,104,247,173,127,160,214,230,207,56,112,98,105,62,42,66,97,101,47,220,193,114,23,202,61,21,118,64,16,191,112,119,123,20,117,173,202,70,39,239,112,202,66,142,163,211,106,89,2,97,150,55,78,226,111,190,170,144,53,195,72,96,89,229,178,153,130,164,161,86,154,154,21,95,120,12,31,122,50,142,245,189,124,17,218,35,201,75,20,203,234,97,11,70,151,3,185,169,71,243,91,56,248,117,103,8,162,90,14,193,33,124,194,169,48,150,40,80,127,37,151,74,195,221,99,145,74,172,228,150,120,147,204,160,67,110,187,30,236,197,101,7,127,128,115,7,243,235,20,66,101,40,114,136,254,206,220,67,96,231,89,65,202,234,82,8,131,187,238,220,213,142,223,77,25,167,69,68,87,110,101,200,142,51,26,234,143,164,214,134,215,222,141,23,42,75,147,88,211,199,154,201,24,72,202,13,136,234,25,52,120,254,136,185,193,163,187,133,84,93,81,133,177,73,126,136,46,251,136,144,180,33,34,18,230,128,47,79,79,106,150,8,58,160,248,106,132,183,215,17,146,173,177,243,32,65,1,175,14,45,235,55,127,69,29,175,177,184,199,168,231,173,143,212,218,44,28,243,157,87,243,247,193,142,155,49,191,221,140,235,246,53,125,204,139,60,232,18,220,63,106,61,252,172,154,140,47,208,189,55,163,20,44,108,250,50,252,255,204,45,52,2,76,66,64,241,107,21,163,134,187,242,247,136,203,1,7,118,226,244,67,198,15,238,194,74,9,230,186,185,49,162,49,71,168,31,130,160,103,223,244,225,108,133,142,123,181,164,114,112,172,100,229,165,150,250,57,212,15,63,204,70,163,4,98,111,152,45,37,45,245,228,45,244,111,124,250,163,197,120,243,232,117,56,154,191,145,196,141,125,8,55,90,132,216,85,224,174,60,253,201,63,198,114,202,235,236,103,174,176,192,65,93,161,74,226,65,222,241,126,119,113,174,16,71,68,19,253,160,250,79,117,231,129,159,61,132,104,164,251,78,110,48,246,12,36,172,100,111,152,87,36,40,95,115,60,227,74,123,204,149,244,119,65,162,114,102,121,19,155,249,117,248,51,151,33,42,115,199,237,144,43,180,51,121,129,23,83,127,226,56,9,32,222,44,201,44,21,7,249,122,183,224,239,85,204,10,181,91,19,103,103,133,205,12,229,38,97,31,108,141,82,255,186,32,185,59,95,66,45,15,41,179,36,56,178,53,39,230,128,252,12,104,165,98,132,4,223,238,44,36,222,188,218,52,250,146,212,148,237,85,68,175,72,79,155,38,36,230,62,122,67,208,138,241,5,49,158,119,106,100,178,247,61,154,161,134,111,198,28,192,44,150,189,7,205,154,142,45,190,172,69,107,176,36,105,64,30,153,120,233,138,210,10,19,201,37,119,182,152,85,43,37,56,68,199,14,82,214,220,245,249,231,141,77,20,190,252,61,102,166,209,230,24,109,225,229,78,195,145,93,109,32,127,163,49,126,248,87,165,80,47,35,155,3,51,50,146,244,105,171,122,226,62,82,242,157,209,37,222,157,224,156,21,73,10,238,198,123,110,60,209,122,158,82,5,221,166,227,119,183,251,80,175,245,112,156,150,175,183,247,162,53,159,213,33,71,40,168,227,104,244,244,210,154,12,114,234,6,153,36,147,203,170,108,85,64,250,110,225,137,2,143,243,163,40,173,220,191,63,210,108,131,154,142,83,175,46,56,41,236,83,221,81,161,144,135,172,99,88,139,115,229,148,143,162,9,203,12,44,238,102,165,234,230,179,179,242,16,227,158,20,196,203,126,102,121,194,246,105,131,73,192,81,122,192,229,32,52,68,139,60,16,102,94,4,190,236,77,238,222,73,240,221,6,252,179,240,56,85,108,237,167,95,168,223,161,49,28,186,57,93,43,203,125,223,42,221,67,47,174,96,56,99,204,115,41,252,252,106,153,180,228,242,100,155,42,105,108,181,215,47,150,176,81,36,192,211,244,135,162,127,189,201,80,62,117,91,125,58,245,215,9,16,165,134,52,42,43,225,155,28,21,189,76,85,226,216,155,133,105,120,60,145,152,6,52,150,149,2,255,255,126,255,45,36,58,37,21,112,25,5,210,187,69,74,195,46,226,170,12,90,154,7,142,228,89,148,22,211,1,150,132,252,99,19,215,135,242,15,150,0,17,251,192,38,133,71,164,62,161,144,240,178,62,63,254,50,137,26,207,233,156,52,145,94,86,239,132,26,146,181,46,165,248,100,14,76,252,16,214,130,195,166,67,120,113,30,255,126,197,11,57,108,130,66,163,177,70,30,223,117,244,53,44,13,86,39,70,58,213,212,230,152,164,76,152,10,227,3,6,230,216,73,88,108,91,245,126,137,58,224,132,168,129,199,254,247,134,142,56,81,168,160,119,44,222,123,230,189,204,92,245,18,227,172,58,240,174,149,68,71,210,183,169,241,146,73,86,210,216,156,250,239,161,219,212,210,69,48,33,137,81,185,192,218,197,2,122,26,76,13,121,61,31,44,239,37,158,126,254,241,131,26,167,224,67,133,125,52,204,195,141,119,131,208,214,151,86,54,137,139,144,178,173,220,170,156,70,125,66,38,125,127,135,146,246,160,95,230,1,248,184,55,65,56,225,139,169,106,17,246,153,98,119,248,67,85,148,28,157,200,233,186,149,138,180,147,37,42,212,190,28,189,109,117,242,168,56,133,17,29,241,89,218,5,242,81,50,61,166,175,124,106,47,237,20,201,235,69,95,202,35,243,79,223,34,85,47,100,252,168,29,171,20,189,109,65,14,156,71,195,246,94,104,211,21,29,195,84,33,131,207,221,120,139,57,78,126,88,195,191,172,133,96,242,110,140,236,227,76,154,55,32,134,193,20,204,21,192,232,157,224,147,175,193,96,9,127,18,107,239,96,240,98,139,149,104,92,151,196,170,198,104,185,117,179,26,20,72,48,36,47,32,86,42,189,173,80,71,219,151,79,181,88,45,26,191,38,133,45,54,131,31,109,115,161,163,34,38,89,40,49,173,198,48,17,40,39,121,77,90,70,42,251,130,168,125,184,76,60,95,94,136,227,248,145,210,226,191,137,247,72,210,17,141,52,5,102,220,23,111,146,114,218,208,22,105,9,130,97,83,57,25,228,137,6,99,12,24,29,89,25,101,217,133,196,253,246,158,114,75,8,90,142,28,147,19,22,164,240,205,1,21,145,19,225,61,98,21,22,215,32,158,9,44,97,148,104,201,219,76,43,45,162,73,151,252,188,155,192,134,113,103,109,255,54,42,206,24,76,87,154,98,187,78,193,50,86,191,222,86,162,165,38,191,118,117,72,31,6,174,147,231,105,158,70,133,79,138,223,55,73,210,90,194,194,112,167,14,253,133,160,197,234,193,24,75,239,106,47,115,70,102,75,122,123,87,158,185,162,180,84,210,222,141,172,125,211,117,181,155,250,182,51,247,178,100,123,8,8,173,224,246,222,40,35,31,171,203,195,36,34,6,53,171,105,219,106,216,77,18,130,182,37,225,3,235,196,203,114,168,7,2,10,14,230,118,6,134,118,20,184,145,213,218,127,110,182,193,145,91,202,110,11,96,118,1,8,96,103,167,236,180,15,141,151,253,100,7,112,25,70,89,121,233,178,158,234,47,68,162,185,146,146,7,74,2,17,238,108,171,91,64,92,173,85,82,121,240,175,136,132,26,123,225,64,169,132,53,192,187,113,8,165,133,192,249,61,166,108,170,2,175,11,243,183,162,93,109,51,151,40,206,39,150,0,84,130,215,29,211,96,200,244,193,206,63,137,9,225,205,195,93,147,70,125,177,146,164,76,247,0,61,118,12,73,75,151,145,218,82,180,207,112,233,175,169,104,180,29,149,4,129,248,70,10,159,34,67,208,4,235,146,205,128,223,104,17,16,189,72,150,29,148,21,85,152,237,97,200,84,57,234,9,165,16,73,40,118,10,18,222,171,43,231,169,211,149,179,250,145,227,129,66,53,2,35,228,99,7,1,101,161,122,247,98,103,47,32,194,21,66,228,215,171,211,95,93,47,71,164,197,154,72,46,73,190,186,131,152,104,252,1,237,94,154,240,6,67,188,57,183,3,28,30,181,14,142,247,193,242,88,231,188,86,198,130,125,97,9,115,137,196,6,38,94,170,51,157,253,197,152,195,181,150,253,125,49,6,217,29,102,120,252,248,217,191,232,176,151,7,118,12,126,164,219,67,123,72,16,146,223,203,183,0,196,87,186,185,173,67,246,204,171,20,21,86,98,182,253,7,186,6,120,189,118,3,229,237,60,53,90,120,139,87,229,79,153,85,139,16,81,100,189,150,202,125,164,42,132,10,163,190,85,177,69,169,181,85,186,64,77,182,99,209,185,183,19,5,1,24,167,247,211,71,7,154,124,136,40,199,61,196,217,202,170,170,93,64,20,178,234,247,41,59,124,192,158,211,128,28,144,37,95,61,108,113,150,27,161,102,97,250,86,162,10,193,27,201,55,193,56,84,164,176,59,172,180,2,117,209,83,226,255,156,104,115,80,9,171,177,196,38,252,19,138,252,29,242,231,74,93,205,161,41,158,79,204,211,0,30,248,42,125,237,167,151,3,163,35,219,102,225,38,80,160,246,91,202,15,81,5,104,108,210,239,193,131,146,27,150,17,171,71,221,84,112,204,146,94,186,237,255,206,118,141,107,20,169,226,15,43,75,224,52,120,186,0,134,235,166,30,237,98,31,139,146,29,104,64,56,3,249,66,92,147,217,211,9,31,96,178,69,148,227,230,101,236,243,45,246,172,39,229,59,69,106,63,147,212,148,179,217,10,220,19,61,36,147,54,173,248,250,238,79,181,163,211,105,11,79,136,249,56,91,202,219,147,180,212,42,140,52,110,222,216,92,215,61,213,55,188,33,239,190,201,255,96,1,215,85,244,86,49,152,17,180,172,68,196,115,71,107,182,243,219,136,48,23,116,210,242,8,233,123,235,101,169,61,55,63,1,51,205,161,189,96,59,52,218,197,250,26,88,73,52,217,104,199,216,234,189,209,12,232,29,210,128,20,244,127,219,15,204,123,222,84,167,249,54,43,174,28,118,186,210,116,176,58,78,38,166,130,144,219,92,43,91,180,1,195,20,39,139,0,25,240,204,75,61,178,95,199,10,3,136,139,50,249,155,86,95,70,214,41,166,76,132,6,166,146,35,118,145,100,203,149,154,211,215,94,104,5,44,83,183,45,251,89,212,57,197,144,82,87,170,120,45,105,80,129,100,131,159,10,127,221,163,246,63,192,154,53,205,6,127,117,223,24,147,216,93,28,239,163,214,221,158,12,149,255,83,88,41,136,165,138,1,254,6,44,25,143,22,104,150,94,24,196,25,238,193,216,170,71,103,76,33,52,211,45,205,235,134,41,248,86,65,9,32,255,32,95,30,250,243,251,43,119,170,184,85,107,38,21,98,231,54,218,226,16,72,174,6,221,38,211,120,221,119,117,120,67,209,251,33,84,155,163,163,47,53,96,15,51,76,204,87,153,85,170,54,66,113,12,174,34,104,136,90,62,76,103,210,150,82,37,200,148,44,89,113,229,33,173,240,114,61,21,131,193,157,216,181,193,207,219,29,42,99,21,186,158,11,145,155,4,216,22,244,162,245,120,63,128,57,117,241,213,60,251,251,149,87,153,99,63,22,75,81,103,103,239,199,225,110,110,88,38,125,240,116,161,226,53,38,183,2,223,68,221,87,205,73,201,187,129,82,39,35,166,109,116,96,250,15,15,242,104,227,86,21,140,48,172,188,54,214,185,33,4,199,217,220,218,185,44,244,170,133,64,135,231,135,80,159,130,65,112,36,250,209,241,226,74,174,130,199,202,217,218,87,161,162,130,254,242,150,34,63,117,178,224,76,211,80,201,111,72,69,137,93,62,24,23,249,115,80,83,95,17,166,84,223,132,120,6,53,34,199,208,205,80,109,133,213,92,49,18,214,230,123,245,73,80,228,94,106,241,165,216,84,255,96,177,178,90,92,5,219,185,153,238,208,136,79,150,15,232,139,179,52,146,235,158,62,239,136,154,45,92,190,176,19,91,40,214,152,149,209,222,247,97,175,74,250,98,231,204,211,233,2,168,136,18,202,254,144,196,95,80,187,220,123,31,164,176,207,23,248,81,3,174,138,206,65,83,36,29,70,32,71,21,227,157,254,228,2,4,215,71,27,252,9,219,49,49,23,248,163,43,170,192,126,75,198,97,91,38,182,93,204,141,250,187,145,128,158,103,88,73,178,191,233,253,231,3,169,38,117,163,181,44,217,91,138,15,239,82,140,19,78,13,168,212,227,46,202,225,130,28,150,211,105,239,25,243,208,76,174,52,37,170,87,125,141,221,90,95,41,51,53,205,112,75,54,129,102,51,87,222,28,117,188,154,174,103,66,55,95,247,97,127,31,107,22,117,195,115,97,108,19,52,70,179,212,190,15,8,213,49,139,119,170,201,169,8,199,203,166,183,90,134,185,169,133,135,9,251,66,104,187,220,182,164,82,21,125,132,197,116,14,169,241,211,104,107,169,17,246,140,46,235,236,23,84,93,180,72,214,10,39,185,197,170,73,30,43,35,75,114,202,126,143,2,127,114,206,107,25,116,183,11,43,3,146,183,121,214,79,26,240,70,203,45,88,74,11,137,245,21,38,44,66,143,61,168,69,76,204,92,186,121,203,15,46,213,237,131,23,220,68,52,188,111,185,48,81,35,208,159,218,44,76,71,236,152,61,103,92,247,136,123,88,196,109,213,91,97,190,88,164,237,171,59,217,231,230,51,149,191,114,162,41,91,249,249,25,109,183,231,25,48,30,35,44,156,199,26,146,144,26,85,40,82,54,83,253,102,88,29,52,114,160,176,0,95,4,217,205,123,143,97,62,149,15,178,195,166,156,183,183,170,183,54,232,197,211,241,7,215,241,86,159,151,161,98,116,91,139,14,111,22,41,155,5,43,72,245,246,20,196,27,62,112,149,21,253,42,111,173,148,25,42,199,41,53,84,169,17,246,92,25,211,161,41,159,252,62,243,4,19,121,43,66,199,74,28,208,193,205,33,126,84,173,30,16,26,179,244,95,188,90,6,16,178,251,191,203,121,130,161,12,52,170,24,14,141,2,163,190,6,52,205,187,57,245,252,9,53,65,132,246,126,90,3,26,54,238,222,74,237,35,163,214,83,43,254,139,112,244,74,15,241,20,255,217,117,129,81,233,181,187,160,29,30,245,145,199,163,29,171,87,228,222,50,229,60,139,23,152,179,33,23,124,180,100,223,209,21,191,93,240,166,209,66,67,28,158,237,190,62,80,188,131,151,72,22,159,212,121,139,49,254,184,106,134,122,77,103,165,81,70,69,174,0,7,179,26,152,234,23,37,155,212,120,59,223,226,216,189,170,9,42,206,10,123,140,130,214,229,149,218,74,215,152,151,235,170,53,33,209,190,193,105,61,182,108,226,176,32,213,78,117,106,23,56,121,61,82,213,107,121,107,114,185,20,99,151,57,44,105,153,238,174,24,192,241,254,251,80,193,143,221,0,58,227,109,190,129,185,22,131,37,221,129,34,101,144,152,33,250,198,183,73,236,69,174,215,68,64,181,94,33,132,40,149,248,252,133,191,99,245,130,21,43,49,211,224,204,33,169,240,230,120,107,228,46,140,168,241,32,17,95,48,147,101,16,176,251,83,160,253,105,171,56,79,198,139,36,48,144,120,99,236,171,235,56,117,196,171,178,244,170,61,79,183,32,202,66,50,130,211,99,78,199,73,255,242,30,138,199,156,129,107,187,182,255,144,201,230,138,199,111,154,10,126,232,144,99,117,187,160,97,221,177,191,5,239,139,181,240,32,249,247,61,216,207,154,217,224,246,49,118,3,194,107,197,233,3,242,99,182,58,45,151,176,238,101,118,57,44,123,195,112,61,129,140,199,98,25,86,104,2,141,220,161,128,109,32,8,89,147,249,11,246,14,255,195,81,233,46,89,37,122,225,211,69,132,120,138,169,254,0,72,208,116,247,244,60,55,28,135,15,11,28,174,65,40,253,148,181,6,57,220,134,224,205,255,225,22,228,49,200,228,182,179,141,237,217,9,47,114,203,57,24,173,236,15,100,174,120,178,73,84,236,141,45,188,142,252,66,85,56,248,161,247,21,240,209,145,198,24,158,227,106,158,18,248,204,21,1,99,35,91,187,157,228,98,106,35,231,158,103,53,119,135,62,168,207,48,5,118,236,117,255,204,65,60,49,102,180,55,82,149,17,205,214,182,198,223,77,55,234,99,156,29,161,90,22,138,7,126,240,213,226,110,63,214,97,71,161,203,216,10,31,25,62,71,223,163,238,97,14,115,144,121,112,103,4,186,16,66,51,105,110,65,111,32,206,82,213,231,74,107,199,255,85,48,249,19,123,45,142,3,104,77,86,181,99,8,158,50,3,108,43,23,113,246,189,180,107,134,24,9,137,36,178,9,176,197,63,33,63,164,220,217,243,175,16,197,210,28,16,109,192,143,193,240,252,44,124,8,108,179,168,171,135,107,32,216,49,136,123,109,133,33,176,167,185,189,30,120,210,5,211,14,127,118,199,147,121,246,58,33,239,172,251,87,223,152,144,13,169,216,65,87,59,132,210,118,116,30,68,72,68,155,103,230,81,33,26,21,82,14,73,251,183,147,86,222,194,97,44,169,244,82,155,95,253,205,116,91,165,44,64,31,163,242,253,93,23,26,209,14,33,97,62,148,115,63,247,111,137,13,9,163,215,243,223,218,10,114,82,195,219,233,24,117,167,173,231,13,156,77,46,231,130,200,122,169,91,49,229,215,250,140,73,229,240,44,212,41,117,112,31,126,218,196,58,241,101,147,26,195,148,98,153,198,104,87,90,149,128,60,239,177,50,49,11,242,239,230,196,182,89,101,80,215,168,143,70,48,53,53,215,22,99,194,129,245,128,163,40,102,25,14,99,189,152,35,135,13,16,105,137,188,32,226,246,176,38,30,36,65,146,145,240,83,103,2,107,133,21,172,41,239,28,250,134,170,228,80,43,122,211,87,111,228,168,29,171,79,69,62,152,18,69,203,96,169,144,83,50,37,65,208,1,113,46,2,67,73,221,2,181,73,185,209,20,163,237,141,222,221,69,220,155,12,177,239,150,84,234,58,111,225,3,31,187,110,139,78,139,234,186,202,73,72,34,125,59,43,206,220,68,6,49,123,14,147,144,206,60,95,31,173,236,244,239,64,11,119,89,226,7,117,175,218,115,104,165,195,209,202,140,132,15,6,115,213,209,69,238,7,89,37,249,156,158,67,124,208,100,194,232,148,52,214,125,166,99,224,152,46,109,187,234,230,51,60,189,191,120,28,13,67,152,105,230,40,147,153,215,16,149,231,51,170,159,88,97,228,216,161,34,87,65,129,153,213,186,140,150,104,113,164,25,120,246,58,78,221,124,33,179,135,7,220,233,68,9,15,123,101,187,131,139,95,177,234,29,215,24,57,107,53,194,252,161,247,70,224,245,22,104,10,41,39,213,190,186,249,159,32,28,196,55,153,225,205,18,72,227,70,120,101,199,237,132,225,10,124,88,154,151,215,153,67,177,100,244,99,169,37,127,97,122,188,216,217,79,187,227,87,69,243,42,139,151,228,79,141,154,88,240,7,29,255,165,129,150,70,173,212,207,194,245,243,54,210,111,168,77,71,140,61,28,64,106,8,196,60,68,154,18,110,22,252,63,172,163,34,138,138,105,145,101,244,110,11,75,95,244,220,224,140,191,243,85,79,137,128,246,173,146,28,1,68,146,131,190,104,107,105,10,183,141,149,204,59,176,190,91,3,180,254,33,47,24,58,4,53,177,211,193,103,6,161,57,156,191,177,108,76,83,185,133,20,167,103,26,75,148,54,239,124,182,71,95,160,157,60,112,22,149,136,53,82,150,241,250,192,35,199,124,207,79,66,84,131,7,63,140,114,16,166,158,30,0,73,131,202,144,116,46,50,92,60,23,147,147,14,236,195,64,128,205,63,248,146,1,49,182,30,96,166,149,196,243,131,88,93,119,167,118,22,137,56,179,169,223,194,48,235,4,196,19,7,210,55,75,235,92,247,15,83,174,53,132,172,34,214,91,205,147,70,34,195,103,132,175,68,245,7,227,205,122,160,7,72,137,123,51,243,8,7,82,113,179,53,171,249,151,156,75,82,204,101,194,53,247,2,201,39,125,151,8,4,189,190,40,95,41,72,181,116,99,58,100,136,118,164,13,191,107,164,69,39,229,204,2,248,254,87,112,64,247,106,105,66,193,73,104,67,75,181,248,105,39,227,153,139,164,41,215,76,244,118,95,99,56,13,94,20,67,33,205,238,108,249,81,105,60,177,18,155,229,73,173,205,78,164,144,180,161,191,210,203,150,190,16,55,228,110,203,212,118,15,103,25,67,152,199,2,36,17,117,201,129,88,197,112,153,188,44,58,196,160,131,198,150,19,223,209,224,90,127,231,71,1,40,82,195,12,242,223,233,211,68,210,32,176,1,106,119,179,211,33,221,107,210,194,227,213,88,3,122,19,130,145,199,16,66,179,41,215,40,18,133,40,191,25,49,31,101,27,16,11,60,119,20,186,217,168,204,250,28,173,159,38,166,106,2,35,49,133,30,16,174,41,134,5,154,247,72,247,171,23,225,89,228,141,14,221,122,56,188,54,252,90,121,252,169,8,168,27,59,138,8,245,70,122,230,65,165,140,117,136,206,11,169,209,146,240,8,234,87,27,21,119,136,227,84,138,65,172,42,227,109,202,167,67,219,148,125,32,179,242,176,224,42,235,163,145,195,63,145,122,135,21,164,85,133,249,38,87,145,90,3,151,203,189,99,172,189,248,86,207,193,226,138,44,42,179,190,99,83,127,92,185,32,159,58,246,239,241,246,235,227,205,219,169,42,77,149,0,212,210,172,47,174,68,122,133,7,78,152,86,30,65,58,84,65,40,113,125,213,150,112,146,1,46,218,175,242,206,243,3,22,233,246,135,129,96,57,130,15,151,104,91,220,169,42,107,34,44,14,229,23,97,55,219,134,96,213,252,133,227,120,195,1,46,17,86,212,120,130,91,248,166,233,51,66,254,106,183,117,42,44,36,169,196,204,173,91,96,109,228,171,28,189,45,250,183,121,167,12,164,164,245,225,177,164,170,138,139,161,93,90,83,85,26,198,104,106,203,108,131,144,196,153,22,188,229,99,101,228,68,84,115,35,112,19,129,18,184,189,228,220,191,206,106,106,126,188,176,42,150,208,166,249,215,76,49,78,167,49,137,16,206,210,203,31,206,130,158,233,143,12,168,123,152,246,181,110,5,9,143,33,8,20,72,188,117,52,80,18,200,90,101,236,228,207,56,241,5,217,53,40,86,180,67,214,216,113,227,232,42,4,123,161,29,225,131,69,60,164,193,158,200,54,177,14,32,137,153,25,110,144,200,246,156,194,61,16,88,79,24,113,181,5,133,88,82,165,176,38,251,156,45,231,111,141,37,120,107,195,254,51,23,243,143,18,30,92,222,216,31,27,168,49,204,158,75,50,29,108,173,189,227,162,147,5,233,159,187,189,71,11,14,221,15,68,223,60,234,186,227,182,193,229,131,242,98,115,34,126,30,59,20,56,101,249,9,38,148,110,79,181,179,181,29,240,61,110,204,161,242,160,184,30,38,49,180,136,78,22,156,1,249,192,217,132,67,3,250,243,132,141,231,10,84,231,97,122,73,28,88,116,105,213,193,202,47,183,216,19,80,71,55,14,123,32,194,193,121,208,234,113,73,234,146,93,189,196,164,129,140,201,122,187,60,67,10,121,125,17,246,192,134,16,58,220,3,66,88,63,127,197,206,164,85,151,11,143,43,109,35,215,25,113,90,99,90,205,22,209,122,41,112,244,206,253,59,161,241,168,251,89,190,186,151,193,3,142,219,1,102,68,147,87,145,74,157,223,203,18,248,51,21,219,92,9,251,196,149,82,153,103,27,151,252,54,21,4,47,205,56,172,183,3,29,202,225,83,16,70,15,21,227,219,225,178,248,157,53,135,57,185,163,37,123,167,126,80,187,41,181,17,191,207,228,71,37,158,205,118,62,248,250,194,59,71,214,167,103,233,25,73,205,178,231,128,78,53,113,28,73,140,86,87,88,87,238,196,137,77,234,138,39,195,39,117,89,71,3,123,115,108,182,175,148,180,142,193,159,155,141,71,168,172,98,136,187,112,36,25,146,98,217,160,17,34,77,55,98,189,208,173,74,117,181,200,124,182,123,12,56,62,149,214,75,112,112,107,126,242,224,85,234,235,172,131,250,233,229,99,14,92,194,36,21,156,167,172,215,243,141,214,57,79,177,104,94,207,160,8,3,102,237,50,84,126,223,147,92,211,221,196,52,130,24,176,159,132,65,156,131,71,126,4,33,143,91,104,28,50,153,209,95,181,28,75,113,70,67,27,109,192,39,174,135,252,172,218,211,94,160,62,199,154,79,251,16,22,195,15,22,140,253,36,242,85,72,147,22,121,33,25,195,83,123,67,179,160,66,85,146,45,114,228,93,116,57,55,217,212,216,31,50,167,229,242,19,107,240,57,124,255,142,191,249,148,74,39,163,43,156,151,201,207,220,46,185,27,203,141,137,15,92,5,101,198,159,181,2,84,128,42,9,10,185,221,175,55,128,247,131,98,98,146,152,8,240,110,121,15,67,233,2,21,145,83,105,182,127,239,100,153,185,165,225,124,59,119,26,175,192,81,4,98,42,93,184,200,34,68,13,134,123,5,43,164,167,218,32,67,79,70,4,196,254,131,50,201,157,133,80,79,208,242,155,224,237,252,110,27,249,238,45,235,77,229,182,93,205,123,32,5,3,78,154,69,213,117,216,130,198,46,105,47,78,76,255,250,230,254,99,106,218,110,21,186,185,71,173,236,91,67,119,59,38,141,202,223,39,183,153,239,2,113,168,121,123,54,217,55,237,94,11,1,190,38,16,170,216,147,239,88,254,229,245,220,108,102,247,55,229,237,173,167,179,231,185,82,226,109,53,81,87,15,55,217,69,204,109,3,164,126,143,193,42,141,227,90,36,226,83,128,215,12,177,216,190,140,85,129,225,224,25,74,141,225,41,192,131,60,180,130,169,191,124,58,1,135,224,63,27,9,138,244,124,167,199,35,2,120,62,25,218,238,78,254,29,125,60,19,72,168,31,194,52,28,70,137,193,242,203,2,91,43,138,248,5,135,204,165,116,67,10,198,121,98,100,238,143,43,94,209,39,162,232,129,176,41,254,158,40,195,167,51,206,48,151,123,55,64,65,233,220,176,238,73,3,129,139,129,242,194,88,95,199,147,187,75,237,229,171,30,89,115,154,239,165,169,235,59,98,63,177,91,115,84,142,203,97,103,79,66,2,91,157,207,14,45,246,75,211,46,69,228,42,158,158,132,228,178,36,163,98,194,69,11,37,186,217,155,206,244,54,125,9,122,128,237,37,159,232,91,68,159,92,116,153,244,199,136,214,88,171,186,117,98,60,171,163,232,45,147,151,123,170,237,130,250,83,244,253,125,237,248,178,237,111,15,63,154,122,147,51,15,60,204,111,139,245,231,228,185,51,36,176,237,79,48,4,150,130,163,59,120,29,126,54,40,104,116,142,238,121,237,189,107,191,35,8,119,113,131,109,108,173,24,9,142,108,8,49,51,202,146,192,173,17,1,241,218,187,124,164,246,139,220,70,143,192,138,152,227,175,189,77,209,86,106,63,119,2,159,194,2,163,89,30,119,83,127,152,98,60,123,145,96,155,67,36,124,94,20,93,243,98,219,253,143,238,124,45,39,226,10,242,116,227,184,129,242,21,192,51,94,97,231,64,148,237,211,59,177,198,10,216,238,62,4,109,230,168,9,132,240,215,0,86,29,251,174,78,233,243,27,50,92,197,253,214,2,123,146,246,222,140,146,148,108,237,15,4,222,247,156,154,132,10,40,151,8,10,70,114,132,181,145,136,176,233,7,169,57,111,204,90,220,67,215,132,40,150,216,152,69,54,80,43,171,67,46,100,140,33,185,115,58,154,35,242,247,6,43,31,174,39,80,101,216,73,40,132,227,201,14,85,37,194,50,3,146,118,78,76,36,211,88,24,220,98,14,33,120,148,222,160,20,160,118,195,167,167,92,128,37,5,53,38,72,206,146,123,57,213,135,200,109,71,35,239,160,169,225,222,136,217,153,92,67,165,51,105,189,47,203,155,237,217,9,216,232,29,225,177,49,205,230,232,177,124,66,19,114,207,198,114,64,45,161,124,66,110,85,157,81,102,32,22,83,53,111,196,27,133,196,169,162,223,120,126,235,105,163,132,221,206,150,110,214,226,227,26,172,30,160,193,251,235,130,209,125,165,77,58,39,115,187,196,165,24,148,33,237,15,73,76,51,191,88,212,165,137,89,220,47,35,108,174,114,48,214,113,39,163,180,185,63,88,233,112,0,120,241,137,168,24,63,138,54,82,207,177,179,66,101,46,177,222,3,52,49,103,68,5,246,78,182,234,55,35,29,9,19,192,144,78,132,224,162,148,96,89,62,61,109,6,178,98,241,196,88,167,22,196,56,11,139,35,94,112,213,134,206,158,24,179,145,144,24,250,44,149,253,67,210,8,0,244,166,243,0,180,234,155,46,191,122,41,93,142,70,154,56,201,66,159,207,162,193,63,26,46,204,221,206,29,100,232,161,225,87,106,130,47,154,66,253,50,33,4,103,71,134,239,65,137,220,222,90,200,221,145,253,16,73,125,66,213,113,239,82,209,96,85,98,196,87,143,30,250,24,217,92,120,23,123,71,64,51,243,204,192,239,147,75,30,170,32,161,187,95,176,78,235,9,173,103,112,9,93,39,55,89,66,223,135,55,158,58,28,249,4,53,46,175,138,48,65,135,70,136,1,162,20,77,236,103,41,150,88,60,162,162,221,75,62,108,114,118,100,40,120,101,241,122,160,0,109,225,54,161,239,188,6,149,136,139,198,177,179,32,43,126,52,149,57,217,226,136,215,201,55,32,213,229,87,28,109,36,223,42,151,98,71,107,140,255,230,206,183,84,127,109,108,57,226,37,11,140,188,250,216,82,32,241,186,122,68,173,128,81,29,57,2,23,81,10,233,198,238,113,91,11,7,17,184,180,159,230,116,147,143,120,21,24,1,220,118,49,16,80,204,12,78,41,111,117,193,98,56,148,193,219,160,156,230,56,126,1,172,183,95,204,229,202,75,218,108,245,33,254,8,58,127,98,209,197,176,100,60,110,139,133,80,43,42,133,200,12,216,121,186,89,171,171,252,220,132,121,46,180,75,79,8,157,91,112,112,34,247,193,147,132,119,236,30,223,101,129,132,197,45,134,84,202,92,249,70,208,211,158,206,209,216,202,106,106,96,1,80,249,182,103,247,124,85,169,42,212,67,245,112,214,156,147,143,216,186,202,197,119,5,230,23,226,199,79,150,253,252,85,1,193,145,96,212,15,165,73,246,244,50,249,165,95,254,252,112,62,100,237,167,234,181,238,164,135,224,175,19,225,82,153,135,122,209,81,59,123,165,21,127,99,54,56,18,153,226,205,161,95,202,7,79,126,124,92,208,244,46,5,176,227,206,200,16,140,97,250,131,187,54,34,117,52,52,206,150,201,200,182,45,201,225,80,46,100,113,199,193,12,116,224,253,59,85,244,248,161,239,199,164,208,63,114,103,163,167,185,246,203,19,33,102,53,236,108,3,205,170,155,230,73,204,142,178,233,7,187,171,191,137,254,60,149,218,98,40,42,87,10,3,146,207,162,67,113,25,173,141,27,217,143,225,97,164,2,208,116,57,181,180,112,233,183,114,62,110,197,29,79,155,213,7,115,94,60,229,43,83,79,119,171,196,20,78,239,233,51,87,6,32,5,59,166,121,176,193,0,2,145,150,183,130,7,36,179,159,57,212,66,179,111,151,174,27,202,58,35,12,121,174,29,17,69,244,46,87,1,173,238,194,40,107,180,147,157,209,184,241,104,251,123,242,164,42,31,93,118,82,79,189,47,105,102,158,30,210,164,16,47,140,226,212,235,70,176,78,30,247,193,162,137,19,102,181,9,248,156,29,149,41,73,2,34,88,183,198,106,254,34,124,19,150,32,99,71,253,14,190,121,107,200,168,38,114,205,153,112,139,204,16,149,101,168,127,70,40,156,157,78,179,113,220,4,46,194,124,96,187,139,83,36,28,169,50,209,88,176,134,217,219,55,18,186,165,170,11,175,60,216,24,132,95,218,101,75,194,66,64,184,1,56,29,86,92,86,243,122,204,124,185,21,219,37,111,68,82,178,41,69,127,186,121,223,219,84,41,169,105,54,165,5,128,102,12,67,130,217,46,97,233,254,216,57,121,145,39,46,34,136,82,175,114,153,215,16,119,138,116,45,137,136,230,59,132,221,97,0,150,250,153,211,18,141,254,212,157,9,45,217,191,16,24,133,130,194,151,189,230,92,187,55,12,247,187,8,115,13,29,222,207,59,92,230,24,146,39,165,2,54,188,107,162,190,178,185,22,188,187,172,42,164,239,225,92,55,26,237,230,59,0,75,13,33,47,250,12,161,72,4,185,159,244,163,208,129,102,176,239,178,99,211,97,92,241,234,19,85,70,42,189,55,130,151,119,38,50,126,239,231,40,153,124,51,220,63,234,208,163,211,170,63,37,231,40,152,183,204,90,227,246,208,8,196,85,209,243,92,102,174,199,27,110,145,27,1,158,35,176,107,152,163,227,75,21,184,120,238,57,155,201,3,194,165,57,117,211,136,236,17,128,98,177,93,111,46,94,137,155,5,70,101,212,42,190,79,218,62,143,123,151,171,59,185,175,9,185,245,254,235,130,177,69,252,61,157,29,229,105,128,229,192,180,37,158,214,254,13,129,64,53,209,247,56,140,241,97,250,119,174,250,204,68,97,184,208,29,20,117,25,12,105,234,224,76,223,115,197,177,7,235,247,19,42,20,85,78,15,81,181,192,153,4,160,176,82,106,67,212,194,132,240,190,45,126,79,192,122,42,28,239,165,14,139,14,152,62,129,78,48,66,45,207,97,240,165,178,129,234,169,234,59,12,218,46,249,54,76,20,225,254,11,128,237,242,61,101,16,36,207,202,13,244,205,77,104,204,51,50,1,5,95,211,151,110,251,255,185,191,151,167,102,140,98,163,129,27,38,60,101,197,176,252,212,232,136,208,157,118,51,83,111,209,188,223,78,130,47,24,91,236,170,159,121,55,3,202,0,155,212,180,173,74,37,161,201,91,108,166,174,27,239,60,20,65,158,225,185,85,89,127,76,244,27,86,150,160,201,13,106,79,143,68,200,236,55,107,243,76,149,215,188,118,183,198,159,26,140,136,153,211,173,159,16,57,139,31,93,149,70,6,141,53,112,164,6,184,239,106,159,222,67,158,26,121,136,223,39,46,140,67,170,202,95,88,179,214,186,212,140,8,12,94,34,77,226,17,17,162,210,225,20,151,177,74,9,100,126,170,73,142,33,144,154,131,151,205,235,28,118,190,6,137,98,50,237,7,94,230,246,133,250,179,160,199,89,103,9,203,111,37,216,185,171,40,117,6,107,87,133,165,172,22,140,220,186,41,97,187,57,196,102,220,15,169,194,254,170,33,237,69,78,127,4,30,119,51,251,153,50,179,106,153,232,131,96,100,243,32,78,78,223,191,150,158,39,30,201,43,12,220,233,103,223,247,156,210,213,52,75,203,102,114,46,35,81,55,175,89,207,53,66,198,247,164,132,51,64,124,120,125,108,35,3,184,185,202,162,122,93,58,198,11,176,146,221,62,6,92,250,135,230,38,135,125,76,89,22,140,243,110,14,212,252,94,85,234,86,142,168,158,28,94,124,183,180,213,174,80,170,142,88,83,48,201,169,249,109,156,83,4,161,186,46,235,85,83,86,244,7,52,58,188,19,124,117,35,105,13,185,191,47,252,142,77,194,147,27,235,193,126,138,65,32,134,118,24,227,33,219,142,48,59,235,147,8,183,94,74,184,233,4,78,44,55,20,167,190,216,145,187,105,253,135,93,68,15,204,76,81,176,255,140,229,106,248,29,154,109,79,247,240,181,62,181,2,28,187,26,136,254,180,92,158,140,81,194,11,245,237,48,28,57,112,87,48,233,185,13,251,113,29,199,152,222,226,254,232,119,199,120,251,113,224,226,89,162,215,74,115,227,118,145,197,176,156,161,226,233,79,170,203,163,113,106,144,108,25,85,163,91,129,143,75,216,56,51,156,13,106,116,79,121,79,152,139,128,156,169,174,94,228,172,49,115,235,134,42,145,67,107,214,122,8,49,156,210,218,178,151,67,247,169,0,56,164,44,222,132,125,193,90,153,10,15,29,69,159,229,98,193,181,138,65,215,14,65,89,116,209,247,174,22,72,27,141,214,94,36,169,203,34,123,25,192,248,196,238,148,225,225,253,59,44,43,96,2,26,21,96,123,202,184,253,55,162,172,81,29,95,172,11,133,235,129,224,183,94,71,85,29,23,65,246,242,222,224,109,136,62,63,145,107,248,167,160,195,242,204,135,237,253,107,53,91,77,34,207,186,102,102,84,28,14,44,194,39,232,156,245,132,232,76,102,63,206,240,49,132,118,211,1,70,75,30,42,3,149,207,174,223,160,227,64,221,207,62,64,74,186,97,163,201,85,231,33,84,76,132,47,66,189,73,137,21,77,184,234,168,231,171,247,76,32,229,1,138,186,116,5,60,65,8,57,133,57,165,125,190,51,105,242,89,1,141,234,53,168,34,89,88,55,63,52,10,226,116,30,115,175,214,74,234,133,248,48,242,17,47,155,75,131,130,124,207,192,199,156,142,142,119,122,3,15,49,119,155,82,80,171,180,19,29,133,31,247,222,9,245,206,244,22,69,12,85,112,250,23,97,212,191,32,152,5,115,206,31,197,19,250,138,219,130,3,84,216,78,11,80,213,13,161,199,128,136,64,7,53,223,221,247,108,10,139,128,47,36,225,149,145,94,106,22,86,14,62,13,43,181,226,188,243,228,218,231,144,137,51,46,13,237,21,72,193,233,132,28,220,20,8,4,122,72,237,253,246,222,239,176,0,105,79,66,248,100,211,232,18,217,109,127,11,57,83,34,123,20,60,137,153,193,152,195,96,127,130,205,193,250,201,146,44,174,91,40,108,105,104,231,248,136,114,61,136,124,241,31,128,186,165,230,218,248,76,54,35,51,13,80,241,46,59,34,214,111,253,168,149,252,124,4,81,171,131,110,58,165,172,223,166,5,45,240,154,11,195,26,117,137,238,192,41,98,219,74,113,235,25,234,46,9,144,57,228,196,138,122,230,73,229,42,31,24,18,166,217,131,24,95,177,251,18,240,249,10,235,122,112,16,73,162,6,70,8,231,108,54,87,216,194,174,60,128,244,234,190,212,213,146,128,244,187,133,74,29,128,195,60,234,120,57,168,116,97,234,156,164,173,42,225,70,177,38,184,43,121,148,186,19,207,224,19,253,214,102,184,227,77,205,223,63,242,184,142,75,134,48,96,96,243,151,83,50,87,123,186,147,177,176,62,113,237,99,50,108,201,126,185,218,219,219,241,171,55,44,28,194,49,254,72,63,140,63,178,112,216,15,3,183,189,172,230,154,116,254,246,200,73,82,76,41,15,168,132,147,25,115,46,90,151,15,180,193,60,237,178,105,74,47,191,86,59,221,105,248,98,26,140,49,149,76,146,83,229,173,71,134,78,113,171,186,136,69,240,102,228,167,251,86,198,107,167,79,180,215,210,44,58,98,143,79,188,44,133,107,54,248,165,231,104,149,127,120,62,61,159,252,239,41,101,177,140,108,77,90,49,230,151,125,115,153,80,213,191,17,98,59,202,149,108,239,233,23,177,26,245,216,97,198,111,31,75,248,67,177,55,207,157,212,233,20,69,111,167,232,80,21,144,9,32,199,43,200,181,141,195,9,143,237,154,121,175,158,247,124,39,117,184,48,30,51,103,4,19,16,28,84,98,72,251,204,19,32,194,90,236,170,52,202,181,96,92,120,59,184,47,169,66,177,66,217,150,2,50,182,17,7,131,32,76,227,116,70,174,42,90,163,89,35,33,148,41,240,228,253,31,107,201,210,198,152,13,86,70,112,248,225,121,155,252,134,99,239,2,8,98,108,44,76,227,160,213,104,141,16,130,205,118,253,123,220,48,200,187,80,35,114,62,45,188,107,29,79,220,169,244,147,158,70,102,122,231,232,149,243,55,230,115,28,185,83,39,179,237,221,41,170,240,44,143,39,216,163,87,213,39,157,118,225,99,80,190,57,171,200,20,2,7,166,112,211,127,0,69,167,84,159,62,190,37,46,1,194,192,152,94,188,50,203,38,220,128,2,108,156,32,255,174,254,89,135,44,97,26,237,37,203,70,32,238,3,218,163,213,145,32,244,50,67,233,217,30,131,135,205,0,46,29,143,192,99,180,144,34,96,7,74,212,164,44,215,190,88,252,138,84,97,50,251,203,44,252,175,247,178,155,79,180,28,8,80,184,205,211,9,119,150,32,91,150,4,102,212,89,217,117,71,241,163,146,90,113,142,34,228,139,182,236,101,97,47,152,88,91,161,47,37,246,4,92,89,174,210,15,82,44,118,249,82,198,192,155,172,220,91,168,190,233,35,204,84,24,113,139,102,112,42,108,124,19,27,148,60,159,78,38,239,90,234,5,193,172,28,58,20,182,11,43,162,123,82,184,178,167,19,172,101,106,3,69,146,204,136,46,70,35,133,166,103,74,245,222,246,76,109,232,173,160,36,50,39,140,112,227,59,10,18,127,30,232,161,113,146,233,102,248,171,205,245,154,98,101,53,109,65,36,82,31,241,200,111,216,27,255,10,48,237,213,82,221,17,250,248,215,19,150,56,175,233,19,230,30,233,199,3,100,121,176,189,175,63,20,231,105,113,121,51,88,188,231,109,177,58,34,9,199,121,226,157,183,76,219,41,224,204,61,144,124,88,115,7,214,74,179,178,42,119,144,76,98,58,171,185,134,98,123,177,87,100,213,183,165,147,22,29,151,19,74,146,102,107,158,201,189,0,79,185,36,105,84,104,73,152,103,132,228,196,39,102,113,158,255,56,212,198,37,172,139,31,238,98,184,182,42,69,108,194,245,23,205,45,21,76,115,162,181,174,59,213,233,59,240,184,32,212,226,199,126,11,205,232,217,187,51,197,98,94,117,94,105,152,41,48,22,181,8,146,134,207,30,237,255,240,248,183,191,187,67,210,16,185,191,54,193,2,218,22,99,176,191,233,78,247,165,4,231,131,62,37,109,244,76,194,155,129,212,66,0,101,223,162,211,13,80,169,217,16,68,4,155,216,61,35,76,162,144,217,34,209,73,249,250,253,186,140,124,41,237,124,22,168,97,40,95,47,38,188,204,216,150,184,229,185,174,113,3,154,126,238,50,165,170,12,27,209,53,157,76,118,81,252,10,140,31,103,160,43,171,6,65,205,225,154,85,121,76,216,228,29,241,184,200,160,225,86,4,199,137,80,222,199,30,9,163,177,222,131,91,24,3,147,148,250,20,157,246,166,73,41,246,240,159,85,53,172,227,255,239,211,188,78,85,210,198,63,175,149,47,251,126,139,167,245,143,5,212,41,111,52,133,173,37,114,122,63,214,212,6,98,213,169,140,241,226,233,95,47,169,91,89,117,116,228,30,78,123,163,137,11,19,142,70,121,166,215,141,20,57,100,202,75,131,150,222,136,204,79,199,205,220,46,9,129,92,116,55,148,224,138,82,32,255,250,251,59,239,99,130,13,77,106,233,191,37,70,164,141,160,195,95,192,54,39,178,189,46,17,135,160,255,198,62,249,69,57,5,74,22,165,134,209,143,179,8,28,219,212,141,148,242,233,231,171,234,72,186,111,252,84,120,130,253,206,225,145,123,88,19,194,150,24,168,247,191,92,162,203,56,94,55,72,199,142,76,50,37,253,13,142,159,201,100,153,149,243,217,240,192,204,254,66,239,13,23,161,166,210,210,120,35,7,141,179,109,83,57,146,163,16,195,195,129,214,39,34,155,158,29,244,128,143,18,233,121,150,87,80,227,145,22,207,133,15,10,172,79,48,176,209,68,66,116,22,167,251,162,90,108,98,148,98,84,46,164,185,106,48,68,247,163,112,24,15,78,105,58,173,251,63,10,252,91,83,158,57,178,63,21,40,113,231,82,251,191,134,27,71,131,203,150,222,121,48,211,181,0,62,91,119,123,77,252,183,63,204,142,239,211,87,244,129,213,2,81,221,210,104,182,252,35,116,91,198,172,132,76,148,89,3,74,8,96,232,19,70,18,232,128,18,145,133,229,23,13,93,175,174,68,105,55,192,81,168,1,142,132,193,37,99,188,243,51,14,26,6,195,29,149,159,115,77,169,235,22,66,101,37,224,43,146,152,141,191,222,67,12,74,51,124,129,141,11,37,97,10,50,79,112,123,54,180,89,156,10,237,145,90,99,35,116,84,163,249,196,70,103,144,16,14,13,233,42,5,213,163,203,205,92,6,212,210,195,46,141,24,15,1,215,71,30,31,0,4,24,15,93,217,35,228,173,104,78,117,69,140,243,168,119,62,223,200,171,123,57,184,88,64,53,21,153,201,0,115,146,22,119,84,228,16,189,124,213,148,92,15,178,58,83,69,87,213,137,150,254,92,197,211,157,193,255,150,115,3,222,48,64,41,28,208,245,211,29,135,30,54,205,250,93,94,57,155,196,37,151,90,109,165,11,249,203,106,37,64,103,100,206,108,40,181,36,238,104,208,241,13,26,75,32,133,101,47,132,226,199,174,3,139,186,102,206,19,21,6,166,44,184,63,7,255,61,155,90,233,60,161,86,176,23,97,194,237,176,234,251,116,25,226,11,145,130,13,179,158,222,252,26,235,132,202,117,229,195,232,158,52,183,96,47,219,235,210,51,146,103,15,241,22,194,84,73,169,183,142,81,87,203,6,251,105,254,2,56,164,156,137,219,71,205,59,144,217,70,38,73,57,73,70,131,114,20,249,181,50,184,200,127,251,28,30,92,166,20,252,156,141,128,223,214,176,136,154,210,238,245,131,123,1,114,106,160,197,74,57,4,101,162,185,66,93,219,192,225,68,181,231,74,140,180,121,162,114,142,129,187,73,66,192,218,128,28,39,134,251,0,243,48,55,112,205,204,80,144,149,109,100,247,179,224,228,198,89,225,7,131,170,203,32,130,21,23,249,122,134,208,160,239,23,10,91,107,175,27,56,59,104,18,71,209,245,4,165,227,203,178,69,1,114,130,119,193,171,64,18,182,174,155,16,84,193,55,150,153,90,251,6,94,161,253,223,200,143,16,162,175,93,211,88,243,61,118,144,204,158,163,68,183,243,85,64,42,52,155,32,39,213,93,165,239,188,8,152,93,228,136,71,213,103,158,57,252,54,203,34,230,180,127,56,46,22,5,220,190,103,131,16,64,135,114,68,112,125,205,54,108,113,157,5,31,108,20,138,80,149,170,6,114,65,223,21,159,246,115,158,118,220,203,106,20,66,204,213,59,225,109,136,122,206,137,104,126,66,24,195,83,223,112,36,241,154,219,254,255,248,77,142,202,95,86,171,11,42,188,7,245,217,138,49,224,34,61,121,28,57,25,3,70,9,40,108,107,108,211,160,206,154,77,59,153,161,172,200,23,84,154,131,94,122,115,145,19,13,234,127,86,154,80,149,41,50,98,186,251,36,10,53,159,223,103,104,248,67,154,136,228,46,83,243,36,33,221,157,116,83,109,54,89,171,46,252,120,86,50,220,23,252,185,68,192,125,37,223,233,232,110,16,135,71,175,199,37,75,162,17,48,41,32,39,131,59,145,161,20,26,149,216,99,1,188,240,87,189,8,24,224,227,175,207,156,151,37,76,105,62,202,86,172,9,208,0,186,72,213,78,103,254,132,192,92,113,242,42,224,245,111,181,206,107,130,182,212,63,185,27,28,41,112,220,209,148,172,7,140,225,168,124,67,203,73,76,139,41,226,87,30,125,197,216,76,36,160,168,194,202,181,254,134,0,148,187,242,94,239,72,9,21,148,168,92,66,161,144,73,37,106,39,176,127,116,44,183,89,77,47,138,171,10,169,117,147,107,92,29,184,69,82,220,13,130,34,214,197,214,6,152,46,180,228,77,211,162,47,149,169,145,56,196,174,84,97,93,246,216,30,34,211,137,93,8,161,64,73,106,220,60,107,201,86,86,124,51,9,66,244,168,8,22,125,147,200,68,23,23,247,75,139,87,52,54,5,53,175,14,218,127,126,196,104,220,88,75,122,52,99,226,111,88,137,95,199,196,6,2,87,182,200,67,133,205,210,73,174,53,64,12,134,84,182,73,199,7,65,88,7,24,83,187,31,81,35,236,229,37,177,78,42,143,233,94,241,133,195,255,185,7,218,41,43,231,129,3,23,175,147,37,26,188,70,161,146,126,24,12,38,104,96,209,143,227,254,9,198,24,192,4,227,59,174,32,240,251,5,34,127,186,184,83,193,62,41,187,33,39,239,28,16,118,164,36,171,230,136,212,122,52,86,39,165,85,61,117,145,179,83,209,229,95,227,85,170,136,187,59,115,217,179,60,48,21,67,116,58,14,145,89,89,35,229,5,152,217,138,26,10,189,186,35,83,210,174,165,179,87,168,247,177,43,213,204,247,37,109,164,15,182,108,253,170,140,83,214,151,0,211,81,132,64,43,30,248,18,149,11,44,248,98,107,216,117,38,96,167,82,124,152,140,191,51,40,145,207,31,45,189,144,120,151,236,172,94,196,233,80,172,227,217,187,197,174,24,108,153,189,212,51,44,156,203,149,74,222,95,240,202,168,235,255,91,215,29,201,254,8,156,120,134,162,218,172,153,51,254,189,4,238,93,65,227,158,247,6,74,254,126,91,58,204,84,167,188,223,91,180,79,147,62,150,135,231,158,186,185,126,91,13,115,56,108,78,17,205,175,102,47,20,157,73,175,89,225,242,141,119,215,191,236,127,186,252,109,87,164,233,22,213,98,137,134,97,78,12,13,150,30,160,164,149,154,108,167,156,104,67,228,187,152,143,135,114,154,47,7,21,89,131,179,34,253,135,40,109,220,0,127,213,82,85,64,161,1,113,242,240,66,56,78,225,32,59,26,177,12,19,79,6,212,120,217,177,7,187,76,85,122,133,9,219,81,118,109,201,21,119,47,122,30,190,208,241,78,63,16,91,45,44,253,13,228,18,228,187,96,222,132,166,77,100,226,124,234,61,59,174,40,117,26,163,5,65,107,1,95,18,170,126,100,95,216,113,98,15,186,246,133,3,205,221,228,159,206,212,201,240,175,113,198,72,187,233,28,104,253,239,168,246,139,120,149,143,34,146,39,220,145,216,114,243,109,219,151,117,75,33,162,197,181,62,19,128,118,215,96,101,54,68,109,7,171,133,54,145,1,15,56,224,58,123,172,196,221,3,133,158,85,120,21,246,153,166,1,17,66,48,223,247,230,95,15,223,253,250,109,197,6,190,76,117,7,245,185,143,129,188,191,215,198,20,90,194,172,250,78,233,102,182,120,92,116,208,65,80,84,235,77,57,207,221,127,16,225,96,218,22,104,216,138,195,220,101,236,3,109,87,42,198,95,96,164,202,48,107,45,17,107,246,2,243,229,149,152,83,101,228,91,80,183,254,119,138,201,64,197,135,212,15,171,151,44,69,249,208,188,57,253,250,157,63,153,226,131,155,3,224,56,103,144,28,200,229,192,71,131,21,129,219,235,31,205,144,191,146,253,77,67,78,216,241,242,228,244,174,123,254,65,212,26,35,218,100,1,28,145,247,37,254,116,206,212,40,200,241,209,30,238,181,165,198,211,144,87,158,142,226,70,232,172,134,42,41,121,222,108,17,68,45,47,16,56,26,77,188,99,188,115,118,252,245,11,51,25,44,27,128,31,32,221,54,158,109,102,53,155,4,245,73,26,234,174,198,111,64,52,171,213,56,173,114,145,152,204,191,140,179,22,93,211,35,243,221,136,103,201,155,0,41,110,183,62,30,176,252,190,108,47,23,203,166,160,173,17,124,11,189,244,44,4,13,133,74,224,19,240,200,254,27,57,180,193,89,67,10,147,117,127,169,109,96,98,8,10,21,26,37,181,81,247,202,60,172,58,139,237,116,143,140,46,52,176,49,71,231,243,80,161,14,219,152,25,62,178,232,150,162,47,124,122,155,221,61,212,160,224,158,136,39,24,24,159,93,108,6,145,49,245,189,95,22,153,45,100,83,225,12,97,201,53,242,6,2,23,210,62,108,106,189,178,189,42,64,247,93,171,233,157,196,159,103,239,240,111,60,164,43,151,83,198,183,204,37,185,207,113,120,130,103,10,4,90,144,149,54,51,128,82,233,108,119,172,85,82,79,203,25,184,22,113,202,100,46,34,121,95,234,102,43,243,242,211,223,171,133,152,188,18,134,67,47,2,94,11,17,249,254,0,115,150,132,37,136,76,84,42,91,153,219,138,4,233,91,164,1,243,162,12,134,75,244,55,138,40,252,182,74,245,239,39,45,157,106,56,118,130,15,190,210,138,155,237,239,57,182,77,69,190,113,237,27,178,173,214,149,95,133,12,106,208,89,63,129,174,51,58,43,142,103,103,138,109,123,39,101,45,171,1,233,54,34,208,63,121,151,241,39,0,207,133,172,100,150,134,5,196,133,184,171,253,201,139,186,75,242,123,53,174,38,249,95,72,254,64,108,209,147,37,177,166,69,3,178,95,255,47,41,195,232,6,73,119,89,203,225,150,80,125,183,56,28,82,112,89,167,237,204,73,139,208,233,7,168,90,35,244,133,50,216,254,240,80,227,187,102,135,27,213,192,201,21,175,236,199,100,103,36,247,192,4,133,40,125,16,111,25,177,101,37,180,170,49,230,106,169,123,73,58,231,60,106,230,145,116,211,215,134,199,90,18,243,210,29,225,79,224,248,108,204,147,215,73,244,75,154,145,95,137,151,193,154,146,43,242,175,5,62,42,113,9,57,70,59,133,75,165,250,154,186,143,167,22,47,252,137,102,87,181,104,147,207,195,205,88,18,48,209,126,182,35,179,10,30,175,25,163,6,202,85,185,99,52,208,20,19,242,169,14,253,227,198,85,129,68,11,99,112,59,79,142,105,188,254,123,148,88,153,70,89,84,106,236,34,181,241,51,194,138,62,14,134,245,151,117,235,135,10,139,140,204,146,196,96,242,114,217,131,102,142,129,65,132,108,64,29,42,233,238,33,19,249,17,222,195,125,158,124,202,110,18,183,150,111,199,70,127,8,180,135,203,33,143,230,228,90,44,43,118,241,57,168,162,89,150,106,102,32,60,250,93,143,196,239,12,214,171,73,180,196,199,210,115,112,192,13,9,123,222,213,148,91,19,101,236,101,30,146,43,164,10,156,101,112,151,65,89,151,245,154,56,37,194,99,153,35,80,3,93,62,246,6,68,42,34,155,207,230,215,121,37,213,153,36,165,136,123,181,144,31,215,138,161,118,151,196,108,131,138,93,13,158,182,138,197,184,0,44,139,70,0,204,15,179,245,235,111,229,61,119,1,248,135,70,169,50,116,69,16,223,77,223,248,176,81,63,205,104,150,100,178,216,215,7,243,251,58,16,117,59,213,117,122,156,183,0,72,126,132,100,86,92,240,106,174,220,88,51,75,166,111,176,139,229,215,30,173,166,246,249,201,187,24,250,69,150,214,224,9,17,218,53,173,213,254,11,60,19,32,202,124,40,131,51,99,223,226,217,190,252,29,14,39,73,199,37,180,254,114,46,169,46,109,205,172,86,62,198,113,209,186,149,211,122,42,239,238,71,133,33,39,217,86,131,68,199,243,26,0,143,97,215,140,217,34,11,55,192,118,66,69,203,200,128,171,40,250,94,127,204,76,168,232,153,226,37,150,4,8,22,177,75,64,204,39,19,45,127,173,174,14,222,159,184,66,88,61,250,133,231,114,166,164,33,157,77,203,31,222,189,111,131,178,107,117,10,165,203,18,211,117,188,134,254,238,158,123,143,231,245,189,89,21,88,66,169,241,24,26,210,108,105,249,56,37,196,36,26,110,237,31,34,198,114,72,218,133,14,40,38,0,26,218,130,56,146,228,86,253,43,36,112,162,58,232,178,162,105,114,186,74,187,229,215,195,101,241,14,24,95,246,248,101,255,68,164,79,41,18,245,65,11,228,167,132,169,52,170,196,91,52,224,204,230,105,193,231,254,49,143,85,42,221,140,233,18,131,116,86,127,103,136,113,15,23,95,39,90,226,59,168,56,73,43,227,171,60,251,5,66,24,207,129,225,168,127,243,190,108,173,215,76,110,107,75,120,242,147,252,217,57,234,116,1,133,221,90,162,174,126,61,236,200,53,105,71,155,217,56,85,6,214,13,60,119,234,225,200,186,152,215,237,225,105,85,252,240,252,38,75,220,200,6,243,144,34,127,161,14,197,107,63,75,235,195,72,44,27,244,129,243,201,59,241,45,173,62,200,145,232,76,142,208,183,15,77,119,157,26,157,170,159,104,206,13,248,132,68,229,234,196,252,168,229,154,203,44,177,54,200,235,132,93,52,10,196,60,152,226,220,27,98,85,215,82,144,161,12,76,202,47,71,231,225,223,105,35,201,195,174,188,10,168,199,141,255,108,74,166,226,33,4,203,54,202,178,27,127,250,86,181,225,246,70,219,65,173,49,214,202,71,22,67,184,54,90,182,251,202,40,14,235,63,201,190,75,65,15,33,62,81,56,157,55,187,67,3,223,5,188,105,211,72,202,95,229,207,20,1,219,121,116,56,5,116,227,97,48,200,192,252,86,238,56,125,89,89,89,100,76,5,180,81,31,33,111,202,211,182,51,25,81,28,239,153,125,85,67,149,136,118,157,65,84,65,43,74,86,81,238,45,7,227,222,145,234,95,152,157,225,22,53,47,59,189,252,16,40,26,171,155,247,98,73,206,206,218,9,241,152,213,3,15,107,123,100,86,78,2,200,194,8,78,101,235,150,113,69,232,13,102,131,200,41,240,126,186,238,184,20,62,218,235,221,116,53,44,20,219,104,254,112,139,81,119,100,253,105,53,62,247,159,166,75,128,64,51,7,193,108,154,115,34,146,127,75,102,17,112,81,35,33,255,104,228,11,97,24,252,219,214,122,235,2,28,34,128,252,220,126,248,87,48,200,149,102,191,135,59,48,111,142,210,22,87,41,25,209,90,114,67,98,234,128,53,45,198,155,116,161,66,14,216,226,63,200,18,7,20,213,60,221,77,128,48,20,142,208,197,61,210,161,90,77,80,146,220,80,168,29,93,171,234,195,182,134,136,225,120,206,94,147,141,52,199,5,155,74,143,12,252,50,79,254,135,78,145,222,143,150,128,28,137,206,79,88,83,195,0,213,182,223,225,201,191,235,235,39,175,202,211,139,11,109,8,255,251,237,232,33,37,250,169,184,42,115,205,55,220,211,160,190,225,201,208,87,227,181,15,92,123,111,172,104,71,23,236,206,214,177,119,77,128,149,238,102,224,147,48,143,82,158,83,179,110,112,12,75,86,190,48,208,14,156,92,140,55,64,14,23,106,204,140,48,97,72,62,247,14,217,121,31,224,171,233,69,177,129,185,71,17,87,96,138,78,19,178,198,229,37,235,51,51,208,149,100,111,39,54,197,126,215,245,125,0,18,64,157,246,4,183,62,21,82,209,182,193,74,163,255,99,143,38,119,30,171,116,62,129,241,64,167,205,128,48,19,141,208,126,96,231,17,94,11,123,106,132,252,127,95,4,217,84,100,231,9,56,144,178,55,92,107,154,194,164,113,19,93,117,152,188,49,241,135,95,131,177,63,10,247,179,86,47,153,63,125,70,239,205,3,48,196,135,152,123,146,5,229,21,112,255,72,4,180,42,148,238,234,211,163,111,223,49,176,36,101,182,121,145,65,242,151,27,181,100,235,212,127,238,78,165,2,36,188,117,89,217,137,39,32,249,156,72,106,48,65,177,35,119,166,109,125,93,15,74,133,194,177,8,208,79,4,23,216,37,3,20,67,12,40,52,11,160,213,96,177,234,40,240,251,19,126,81,186,153,249,204,11,91,78,70,238,38,31,243,13,156,49,165,95,148,218,155,179,139,30,216,15,153,27,164,59,189,173,159,141,146,16,21,167,183,161,203,82,140,66,150,182,16,73,40,176,102,55,118,132,173,249,137,117,137,145,90,53,86,164,24,152,171,14,64,192,181,253,238,22,204,59,115,228,173,155,232,15,108,250,14,135,190,177,25,54,114,152,83,38,132,125,185,243,134,112,168,170,99,100,155,125,107,46,165,146,10,12,243,170,39,155,195,220,140,129,9,27,178,166,144,112,200,134,3,146,228,27,60,217,251,147,93,72,56,196,158,217,177,53,113,146,111,93,172,7,71,165,196,105,120,164,255,79,158,235,183,45,61,139,128,87,87,24,202,89,236,50,129,135,90,217,225,115,211,102,32,22,124,87,167,76,209,47,193,179,5,176,1,172,115,53,235,4,198,69,17,146,1,156,60,169,171,3,154,137,1,8,160,180,39,33,145,194,221,167,74,225,147,22,226,175,161,190,155,99,104,36,234,28,206,255,153,106,146,140,248,208,160,159,129,189,81,79,151,34,57,191,19,60,238,132,173,126,112,102,40,167,236,248,169,15,165,62,167,248,117,241,242,52,190,179,82,62,174,253,135,166,242,116,101,164,25,44,212,205,199,182,51,26,85,54,11,16,243,103,183,145,84,222,115,193,84,191,14,243,49,214,76,187,20,39,29,243,173,156,181,219,109,64,24,75,52,179,28,160,231,99,85,33,44,165,96,91,1,116,151,203,247,43,74,128,179,172,198,31,77,89,11,160,120,13,159,140,72,217,110,79,78,206,233,178,98,50,152,74,216,73,133,249,217,70,75,56,129,241,107,234,100,37,103,60,16,188,2,190,11,70,104,226,153,93,247,153,143,161,19,20,220,168,207,59,231,145,117,83,136,104,18,107,25,84,26,105,116,169,98,24,122,32,236,228,193,206,223,235,29,238,49,143,225,2,196,58,61,127,140,102,14,140,100,86,158,130,245,106,213,21,195,130,77,170,38,87,189,28,239,43,9,141,221,172,71,101,23,117,196,97,176,152,245,228,11,197,252,84,206,70,36,202,196,205,27,80,137,39,25,75,180,73,162,224,150,97,44,115,24,151,153,239,190,250,64,81,124,193,49,199,158,225,239,216,251,150,194,11,43,136,66,171,93,122,163,101,50,248,76,30,251,201,114,80,75,69,109,212,155,11,141,217,118,95,15,127,174,149,147,216,251,178,89,253,92,51,157,16,128,60,144,26,219,47,131,125,182,76,241,164,209,6,26,7,92,85,220,173,245,230,208,98,209,124,70,173,192,190,132,55,211,201,186,183,60,108,73,202,134,11,25,98,22,219,173,173,140,39,222,243,91,17,177,81,168,144,244,94,105,34,211,227,16,134,9,254,20,51,4,182,243,203,82,63,238,89,246,230,147,185,200,52,129,113,141,167,177,99,18,247,119,52,84,13,203,187,89,98,35,178,30,13,149,205,77,136,197,164,183,202,225,132,158,34,253,166,180,170,81,56,53,16,116,34,149,120,212,66,17,226,5,193,175,148,81,251,230,23,177,141,43,79,103,153,84,172,51,44,242,34,237,188,74,225,118,144,129,40,56,96,157,254,134,231,14,209,110,23,26,41,253,29,33,247,80,149,196,100,34,23,183,198,124,246,191,174,56,254,31,119,127,229,154,236,190,38,98,101,91,126,182,201,156,27,210,62,101,17,18,95,17,62,112,173,218,95,8,203,29,169,3,23,137,111,219,234,54,156,50,148,31,227,60,56,205,74,105,149,45,57,162,39,83,232,38,150,169,204,161,15,212,82,220,124,196,127,1,123,135,186,208,13,210,224,127,223,143,131,107,123,201,10,21,58,99,135,64,212,81,242,174,16,20,198,65,72,42,58,79,59,206,26,52,133,57,223,232,6,119,87,13,47,214,82,42,153,242,77,203,163,205,22,188,0,129,78,179,114,86,63,119,183,248,180,74,200,49,174,239,118,170,130,129,69,61,251,182,192,219,239,214,192,255,58,247,26,49,105,232,74,79,103,145,214,114,231,134,233,230,182,242,244,118,246,117,136,107,207,19,107,184,247,251,123,157,189,96,101,189,162,223,179,99,10,86,165,128,163,231,16,244,57,68,233,20,250,104,28,166,38,49,110,177,66,17,127,187,199,42,122,137,238,193,107,95,247,227,189,113,10,75,176,213,70,136,141,144,164,87,37,42,23,127,141,164,183,78,139,218,128,235,216,244,18,237,172,200,24,113,21,112,117,16,59,41,136,9,155,210,169,170,75,221,91,65,24,147,102,178,110,106,220,193,124,222,37,240,191,119,132,54,85,182,115,221,35,234,48,168,174,45,235,227,126,189,190,94,228,240,101,211,112,91,127,57,151,48,255,55,129,17,139,254,252,80,114,75,182,22,51,188,91,109,69,192,230,36,179,138,232,162,3,131,1,137,52,56,241,139,77,224,236,177,175,210,192,80,187,135,105,224,116,81,229,132,151,223,232,67,207,191,76,55,255,26,58,42,239,48,161,0,251,40,166,214,231,173,40,122,99,165,8,170,84,14,152,38,0,60,172,198,70,127,95,75,16,127,6,6,164,64,141,172,238,59,222,131,224,43,38,141,127,96,100,62,2,30,34,180,54,230,3,150,5,231,193,31,96,61,201,7,121,144,136,49,68,114,1,180,193,165,67,117,98,92,230,45,153,167,120,227,39,220,201,40,218,176,242,79,255,176,197,84,44,219,188,24,123,109,252,180,10,54,56,205,152,158,23,34,226,122,114,118,86,190,135,145,210,139,53,111,80,254,12,33,99,114,50,69,174,102,63,40,134,203,163,241,201,210,132,197,30,194,21,41,67,111,169,59,137,176,140,87,223,35,219,148,41,17,47,87,132,177,195,184,155,62,44,57,51,61,166,176,0,78,17,239,248,132,24,90,111,0,114,11,243,116,156,217,62,172,237,169,184,102,49,203,132,170,173,228,19,92,247,110,129,213,51,246,166,189,117,14,122,133,32,168,49,250,110,109,130,233,47,207,247,73,245,53,4,163,18,37,68,143,96,159,144,46,41,170,94,167,114,150,192,69,209,251,219,13,111,213,186,98,240,94,100,151,249,137,215,40,31,202,233,102,233,87,154,45,180,231,125,239,156,180,218,112,223,97,62,42,141,65,252,126,67,80,247,250,233,208,232,35,192,160,163,194,226,126,10,45,236,6,185,108,216,204,37,163,11,79,111,48,215,146,155,158,134,141,203,55,89,61,222,33,78,82,125,74,58,124,11,39,39,25,125,19,251,109,165,69,192,6,62,4,243,172,60,180,97,171,114,245,37,98,216,173,83,172,42,223,203,123,98,129,233,163,55,50,102,117,207,223,131,8,155,151,246,17,163,194,153,249,69,72,100,93,139,51,97,70,143,174,24,21,44,73,67,97,203,26,232,224,113,226,185,74,242,203,51,164,179,209,188,168,1,102,93,74,120,214,135,191,193,209,7,112,218,199,145,10,92,23,239,226,242,205,187,159,126,171,125,35,158,53,118,74,19,183,224,31,116,118,13,32,211,205,92,131,123,48,181,32,124,7,233,247,254,24,251,109,189,0,184,187,80,73,194,94,100,239,81,170,145,20,235,132,230,56,141,90,22,151,198,88,153,66,134,20,94,237,62,58,110,218,255,50,111,198,109,211,202,21,39,7,30,238,147,85,35,154,58,236,112,221,70,102,211,120,115,74,109,188,70,229,214,191,122,134,120,195,231,217,122,35,113,9,110,154,50,82,32,35,111,159,191,205,52,223,124,250,77,32,228,68,131,215,255,245,107,10,80,105,104,31,4,173,207,219,31,219,171,182,182,254,211,181,183,202,185,238,165,167,38,248,72,193,90,249,154,165,80,64,209,68,160,49,226,93,135,143,48,97,211,47,187,29,120,160,203,115,39,87,245,227,220,244,5,60,57,251,126,42,117,244,81,69,98,77,242,210,249,188,19,130,253,198,56,95,174,249,187,185,215,132,16,226,25,29,180,25,54,143,69,121,134,79,117,180,218,210,211,236,58,207,231,69,104,95,149,166,212,59,105,131,68,83,21,233,177,143,135,83,237,99,3,20,58,123,234,249,128,199,117,238,163,124,52,215,100,124,76,146,61,253,192,135,196,87,201,115,149,98,141,214,85,252,207,188,13,34,208,166,93,132,22,39,44,115,121,203,93,78,137,69,196,253,197,120,148,36,21,208,5,95,43,5,122,145,41,160,12,117,201,143,36,62,133,73,185,73,185,155,194,182,166,248,96,33,9,112,7,42,39,42,203,253,23,196,161,187,66,234,58,217,44,48,7,139,47,158,58,153,179,83,189,27,100,164,156,234,199,98,117,100,38,11,24,163,169,221,244,159,173,191,177,229,194,60,25,229,142,239,38,104,95,145,238,47,214,188,90,21,66,126,66,111,210,228,101,36,242,172,130,97,234,90,20,62,166,38,11,198,159,44,245,249,131,27,135,234,87,83,2,62,185,253,129,60,125,165,26,164,138,148,193,87,246,201,45,72,3,33,31,191,29,45,33,15,238,109,8,39,100,38,195,128,83,7,133,205,161,144,113,161,194,75,111,13,7,188,92,227,251,80,96,18,64,26,145,25,40,183,204,243,127,122,119,214,146,16,231,175,187,101,92,23,25,172,45,195,139,252,212,135,73,86,24,33,203,30,64,143,202,39,238,180,143,39,141,32,30,65,76,186,57,211,14,143,45,98,183,16,106,103,221,249,6,53,137,24,139,142,183,198,247,95,139,222,54,254,33,32,110,206,70,243,213,3,192,199,172,149,164,83,182,93,148,177,50,21,141,173,13,238,107,195,127,67,110,37,112,43,142,183,230,190,209,160,162,156,23,27,134,24,34,52,140,72,249,61,178,169,148,8,130,66,147,91,31,208,121,252,240,86,4,49,94,172,145,170,231,175,155,91,81,34,65,35,19,119,54,89,16,204,192,75,121,73,147,188,144,117,13,228,38,41,170,216,212,138,219,190,30,66,160,168,25,44,46,139,91,239,138,252,75,214,254,70,38,167,102,27,83,199,3,87,193,132,173,198,46,20,126,199,149,77,169,28,80,101,104,137,62,96,184,186,195,156,232,54,165,152,181,234,109,221,187,146,210,235,81,120,213,202,4,54,76,73,143,91,58,186,245,234,169,42,230,22,18,250,90,107,166,223,111,105,64,154,164,4,224,90,136,137,59,115,161,111,33,203,195,109,85,228,153,230,42,60,71,72,5,2,62,18,247,95,210,226,191,18,86,215,250,188,187,220,235,252,237,222,248,38,43,49,68,167,200,78,234,221,147,5,179,21,224,63,87,13,134,86,163,63,36,111,99,183,191,107,252,17,109,125,244,237,227,124,248,96,249,123,151,124,55,89,15,60,83,228,51,167,78,178,149,160,185,115,84,80,74,205,223,140,130,90,11,7,178,123,40,235,140,10,228,159,27,22,21,27,35,97,198,101,3,45,152,101,159,133,198,240,50,167,96,88,76,87,206,44,39,249,11,105,101,233,91,94,0,117,182,228,62,63,40,7,175,93,108,94,109,10,13,105,155,235,242,84,115,42,225,207,146,64,214,155,15,160,204,116,101,205,129,106,90,130,161,1,205,66,106,134,110,197,2,121,251,255,76,57,17,131,177,22,249,53,191,239,3,209,175,23,202,194,236,120,82,27,150,175,201,140,218,92,66,6,242,27,242,72,21,153,249,76,147,161,201,108,133,37,82,63,157,26,16,157,157,53,227,144,45,33,251,159,166,102,14,146,8,130,61,71,232,239,55,149,154,94,62,201,196,46,66,64,182,197,173,177,174,129,184,239,93,144,26,35,78,229,198,0,35,11,0,24,58,31,116,17,14,148,173,217,199,57,30,154,70,63,65,205,96,139,15,161,221,167,15,248,53,144,210,247,198,28,89,183,77,185,161,137,46,60,33,250,124,201,6,162,14,149,173,139,246,183,196,97,174,62,140,41,85,124,32,241,157,180,188,116,43,88,101,206,143,162,87,136,175,53,8,137,29,26,223,233,139,150,187,232,66,160,175,236,60,249,74,124,88,0,169,71,249,158,190,158,10,136,161,14,192,129,205,123,206,139,139,194,116,10,232,178,229,135,29,133,175,175,159,206,251,200,116,49,111,179,231,204,59,114,82,198,44,18,188,92,104,214,214,0,99,131,131,20,13,139,95,163,166,89,240,125,147,162,92,27,236,208,194,108,76,213,90,135,100,0,183,53,71,191,95,49,61,227,177,149,62,19,73,102,79,254,208,162,75,217,114,173,130,116,114,179,103,102,51,151,84,216,208,210,52,137,180,99,72,124,128,249,247,136,183,36,28,249,242,125,70,239,231,22,75,183,222,194,216,180,98,166,182,159,27,186,214,74,253,234,220,112,80,103,58,215,113,70,28,68,149,92,181,110,119,67,179,179,9,96,140,249,194,72,173,244,144,58,9,141,246,68,237,118,179,124,164,96,125,30,196,126,104,19,176,107,25,7,162,89,236,206,184,139,167,166,16,55,67,7,93,251,90,252,86,252,171,140,238,114,28,106,253,2,64,26,18,192,199,145,70,224,41,158,81,211,254,47,235,74,231,215,176,97,187,165,209,79,109,189,21,14,209,97,193,29,254,42,24,157,72,5,143,9,214,54,90,86,243,143,140,12,163,2,158,213,69,48,232,80,165,123,73,197,247,8,241,232,198,127,142,153,236,153,145,20,27,64,72,56,14,13,147,102,116,211,20,44,176,108,13,229,36,230,81,206,9,197,5,42,177,137,125,239,52,138,145,92,76,16,223,134,138,221,234,177,91,177,210,67,1,151,117,176,201,125,211,227,144,217,180,31,53,97,31,147,33,222,114,225,63,236,245,62,68,54,30,147,134,96,110,84,124,209,201,141,3,62,115,79,24,228,194,3,74,218,184,3,66,224,170,40,123,37,121,61,129,54,53,103,197,43,89,135,6,26,104,193,193,136,152,56,142,183,224,128,35,138,123,231,218,184,64,116,133,134,79,71,93,163,18,65,127,217,137,72,42,147,44,193,117,255,58,201,221,139,83,224,169,171,21,200,243,196,43,229,12,27,96,110,87,50,136,174,144,220,236,35,210,9,136,71,10,14,95,205,206,230,46,210,240,140,197,31,1,18,188,0,238,15,228,67,49,220,86,132,126,70,124,204,88,118,84,251,214,36,171,200,70,160,93,190,20,193,149,122,208,201,60,231,13,227,143,217,98,120,101,241,47,166,37,0,246,166,53,179,69,210,170,111,102,237,39,29,58,140,90,17,30,66,50,240,135,134,156,130,216,158,96,227,238,43,173,150,62,156,252,12,213,121,200,99,178,38,253,248,51,29,232,51,139,88,26,160,174,235,4,96,47,68,39,65,224,118,4,246,129,110,151,23,33,196,101,107,18,57,33,181,138,239,175,105,157,49,247,51,175,4,49,223,166,210,239,121,16,164,212,230,198,33,63,150,165,9,54,147,43,215,241,224,55,27,106,204,89,39,184,161,80,49,4,115,240,147,14,244,80,211,157,188,47,240,27,232,175,82,215,194,147,55,86,12,143,240,196,252,206,171,147,238,96,167,220,204,222,124,57,43,217,33,94,205,196,224,116,99,78,12,233,159,227,1,76,43,79,235,217,146,66,161,211,175,94,65,74,199,243,183,6,81,84,203,242,106,233,76,173,158,214,45,43,108,174,250,106,136,126,230,63,14,251,213,18,71,87,50,64,255,236,85,183,102,109,45,1,174,202,9,149,185,253,197,58,210,45,138,136,51,85,221,138,73,184,106,127,134,253,72,58,18,180,62,151,29,82,139,220,202,116,64,248,20,81,96,109,47,138,242,186,193,36,58,228,83,194,172,38,0,252,218,244,10,112,115,142,57,210,57,11,64,200,229,159,61,193,101,132,118,218,80,148,208,24,56,50,42,216,65,221,198,222,42,94,40,195,189,60,175,28,71,25,114,164,42,45,8,67,46,142,204,238,25,167,37,150,221,46,11,216,39,161,104,150,116,113,1,94,67,6,9,155,180,85,217,5,244,160,99,51,203,177,93,136,13,60,29,150,143,141,45,240,202,86,52,252,208,169,251,4,6,159,54,129,123,18,109,207,1,191,79,38,187,105,43,96,244,160,246,58,53,1,126,98,82,106,12,250,65,44,103,65,155,146,190,0,201,249,32,20,57,171,220,149,156,114,51,66,148,220,137,156,113,120,32,169,126,124,13,130,177,138,31,55,46,148,240,128,29,71,141,116,145,112,8,66,189,190,216,123,114,164,94,213,103,242,213,46,100,240,150,169,179,251,110,47,164,50,174,245,163,245,59,14,243,8,35,82,74,151,19,130,70,32,129,139,54,14,190,35,131,230,71,44,133,253,187,52,219,118,239,235,58,76,31,196,252,32,242,187,197,157,187,55,29,121,51,214,250,24,234,46,96,133,232,102,63,43,191,186,226,113,189,64,205,186,249,119,43,113,194,61,250,58,221,69,191,75,14,152,187,167,243,108,156,124,46,5,218,175,243,118,7,240,85,167,144,192,213,61,210,252,162,165,162,46,86,124,240,63,149,35,88,159,198,71,207,56,140,25,144,133,248,190,191,241,252,13,124,234,108,165,9,106,44,119,178,102,193,221,168,140,143,125,102,211,106,41,163,241,103,12,131,227,10,78,64,224,131,209,128,108,224,131,81,196,188,208,57,0,65,7,171,245,92,68,97,155,26,19,0,220,173,153,62,182,16,55,19,229,89,135,80,157,145,162,168,60,3,54,77,8,252,62,78,45,97,13,187,5,95,233,221,143,244,218,237,9,191,191,111,230,19,235,185,24,229,133,236,211,127,22,70,243,186,237,63,6,52,140,155,111,172,124,143,130,20,198,240,17,48,164,10,74,221,17,240,102,82,73,186,66,214,132,28,226,189,253,197,216,71,13,102,76,54,192,250,157,250,97,33,169,125,119,76,18,127,148,89,55,79,41,27,171,173,241,40,25,242,210,152,51,104,129,66,79,162,178,205,127,78,159,148,90,244,237,62,200,220,157,71,215,30,45,95,17,166,151,2,107,156,25,214,202,113,205,64,70,182,24,9,62,176,176,190,16,176,188,96,117,242,77,22,88,50,108,118,138,246,209,82,199,143,160,77,201,121,197,140,194,143,8,181,195,45,95,221,40,139,214,14,153,166,70,195,180,165,102,177,227,237,193,79,231,55,66,91,102,116,212,200,47,182,152,106,44,255,140,122,66,158,160,250,117,112,5,28,227,9,101,161,115,43,75,216,160,129,201,85,4,155,212,168,94,163,160,204,9,102,25,233,102,160,184,227,106,238,100,129,31,84,122,126,254,145,223,210,150,80,172,229,177,248,245,3,169,238,5,16,2,78,51,54,207,82,72,227,99,136,26,105,129,53,22,17,45,214,181,195,68,36,56,169,195,242,5,8,191,67,154,4,98,246,26,112,153,140,77,237,240,2,154,115,169,245,170,100,202,110,18,149,98,123,104,24,71,192,232,157,222,215,83,47,36,18,129,246,103,237,227,185,218,144,30,199,136,151,160,138,100,74,32,166,208,86,67,75,237,132,120,166,153,52,64,10,225,171,2,81,131,86,59,191,48,93,62,184,125,186,164,181,232,91,66,146,242,21,173,53,43,188,74,248,215,108,185,224,167,76,81,71,206,93,12,235,166,22,241,224,190,133,235,131,111,103,60,230,112,49,52,171,86,194,94,59,123,115,191,87,69,241,194,32,229,82,37,247,66,83,202,39,30,54,213,89,3,78,249,44,22,248,167,57,0,84,189,32,168,147,103,6,140,148,202,187,193,37,38,180,46,29,166,57,72,223,230,106,44,108,111,251,141,251,89,7,111,191,116,203,52,57,144,49,241,196,170,155,145,94,130,81,6,8,48,239,173,230,55,130,69,187,163,225,66,214,151,106,237,182,124,152,252,164,152,71,188,138,18,156,234,158,96,75,48,112,107,71,163,19,180,198,24,225,112,151,114,89,6,217,49,26,232,78,138,51,90,69,91,193,126,130,54,20,217,158,121,249,61,85,203,2,97,83,109,237,170,254,0,91,197,122,244,126,45,233,234,109,127,179,19,219,93,31,65,76,94,19,176,192,62,20,225,161,144,181,212,117,211,254,177,20,119,165,4,191,21,105,172,116,103,36,198,101,166,240,111,212,21,87,239,249,26,153,242,52,76,142,34,251,237,81,66,187,57,122,29,236,37,110,21,148,230,218,247,104,63,1,234,5,69,199,73,134,157,172,42,231,147,224,75,141,129,211,82,4,89,195,246,70,171,181,93,183,55,108,159,166,33,84,4,185,111,204,210,203,121,247,47,11,38,196,128,175,73,224,158,13,7,251,219,162,20,164,80,64,199,241,117,6,96,69,101,173,208,37,165,211,107,165,193,43,31,159,138,214,247,2,33,12,191,208,158,105,240,17,229,141,41,237,45,38,45,115,88,232,28,191,188,150,228,13,47,17,235,94,149,41,105,96,203,124,26,222,106,9,189,50,92,15,120,136,57,57,255,99,51,112,155,217,186,209,181,137,48,198,43,39,230,86,230,26,217,240,223,93,238,195,80,220,79,238,160,255,161,52,146,25,191,179,0,106,203,39,179,207,46,133,153,151,239,88,57,122,189,135,89,178,115,230,216,10,114,143,251,93,168,61,169,202,150,202,196,237,75,49,182,183,125,110,19,34,1,136,14,89,81,155,227,118,201,69,250,152,109,216,132,250,88,147,48,2,191,100,195,211,13,126,162,119,72,133,229,123,207,22,23,212,210,63,155,150,227,57,166,222,129,67,70,42,85,154,245,247,41,193,230,95,156,113,40,103,226,86,19,6,181,49,124,103,224,189,223,33,119,236,24,20,229,68,141,154,5,89,177,163,212,125,152,33,38,48,226,24,141,151,158,51,86,207,22,139,80,172,113,125,82,37,229,71,24,29,22,151,195,95,177,29,49,74,158,121,217,68,52,92,168,158,88,196,251,22,3,155,79,122,252,156,221,200,181,70,100,216,71,156,175,156,86,2,231,130,108,43,211,119,75,181,114,163,95,222,24,246,255,186,183,186,101,37,137,223,53,194,47,117,58,55,235,209,179,14,167,242,26,134,221,36,193,38,118,184,207,96,67,32,145,250,154,128,94,25,66,185,48,57,213,130,222,58,197,173,252,78,101,199,141,206,155,94,81,157,155,216,239,200,168,141,203,59,210,55,17,55,170,5,110,70,51,20,19,17,219,187,198,121,220,48,135,101,52,185,215,244,4,37,229,220,138,211,126,144,244,210,14,194,134,9,176,26,52,128,5,94,173,63,199,171,196,37,142,16,185,13,98,224,38,105,153,24,182,124,179,35,177,69,226,224,127,75,236,2,98,7,44,185,3,14,107,156,129,152,51,36,29,203,211,203,108,162,74,162,216,89,12,128,9,112,14,157,147,3,227,248,177,51,228,239,231,213,231,254,82,42,244,137,106,99,170,156,192,66,71,139,213,5,156,125,195,124,229,130,190,205,89,225,241,254,176,95,30,219,40,248,129,218,116,222,75,183,241,249,60,88,178,52,92,157,156,113,232,162,36,107,47,55,17,155,162,70,224,125,82,84,211,203,26,49,246,193,94,207,161,122,216,126,138,16,206,87,28,38,45,30,196,186,30,68,206,95,156,208,218,236,93,107,125,217,121,46,223,4,69,183,46,238,206,71,72,167,159,167,48,118,25,0,159,147,140,99,166,172,4,113,21,161,52,102,54,219,194,90,106,50,6,156,202,21,86,112,33,45,53,6,124,162,83,226,178,246,1,165,167,177,190,237,128,219,79,114,30,187,31,146,10,157,251,80,124,108,191,233,91,104,68,35,156,13,54,123,191,37,77,245,82,222,206,8,246,133,27,217,87,116,7,145,65,128,81,142,250,19,137,207,10,217,88,150,119,183,30,231,123,9,189,145,113,150,247,204,148,101,142,228,144,127,101,122,157,153,221,45,112,44,139,13,223,94,18,221,245,14,185,252,132,117,15,173,122,121,1,251,109,2,107,25,97,29,180,199,11,124,161,138,37,92,119,254,245,118,34,128,28,100,200,80,5,114,99,208,232,126,215,247,226,193,129,111,229,166,12,107,30,67,118,84,156,100,158,204,44,28,118,134,227,10,22,153,126,77,13,134,137,18,167,115,62,98,60,182,179,66,109,93,146,39,135,247,137,193,45,175,156,83,87,217,63,250,57,154,128,151,152,45,35,43,126,198,229,219,126,200,145,4,236,251,153,196,162,89,73,134,96,119,107,128,190,147,228,64,73,220,100,124,73,203,91,213,77,92,68,50,107,69,237,110,138,228,193,175,162,213,78,39,118,105,39,11,196,157,25,195,35,53,250,121,123,219,197,179,143,206,30,210,251,106,231,243,37,84,55,23,7,30,84,11,121,92,53,9,191,28,49,57,237,112,78,183,12,215,243,99,159,238,14,246,197,136,207,69,0,120,99,89,37,184,54,94,128,204,224,174,118,50,226,59,151,162,115,167,144,223,213,199,4,87,55,193,10,212,169,238,242,254,70,213,252,87,32,245,18,157,79,122,232,143,103,31,93,140,93,243,91,156,91,223,136,12,68,98,200,179,170,185,195,112,27,104,3,205,165,28,186,174,118,57,189,119,144,158,95,158,164,143,139,58,87,217,43,22,68,43,126,240,70,94,163,225,233,248,227,168,70,198,16,51,205,239,192,4,124,244,190,80,130,188,253,65,63,201,98,243,142,139,238,115,52,164,188,234,11,203,33,66,111,40,174,113,78,139,135,102,209,122,166,53,10,2,10,140,215,139,223,100,11,23,208,126,65,214,52,37,98,93,37,250,159,75,209,155,248,86,107,5,114,199,254,105,179,240,132,18,228,65,136,188,180,168,141,149,43,234,13,114,25,92,32,8,212,172,186,194,234,241,77,20,142,76,140,225,110,176,248,93,52,69,8,47,143,25,99,166,56,37,228,218,183,234,205,236,237,168,228,136,179,145,123,254,230,182,37,220,223,96,199,45,24,147,73,86,254,47,90,124,89,129,192,199,167,216,217,62,148,163,46,107,74,67,155,206,30,163,44,42,238,69,77,5,86,126,151,131,136,59,134,63,72,23,50,35,228,75,48,172,147,4,200,35,217,142,56,51,159,145,237,51,218,27,192,43,193,90,63,194,218,149,77,69,58,68,24,177,235,144,245,52,41,241,21,63,202,204,123,60,245,245,147,59,230,53,58,179,177,6,108,72,142,101,202,171,147,1,238,27,183,145,157,7,29,13,111,137,129,183,185,196,139,126,204,48,220,237,170,227,65,153,226,170,245,241,69,250,74,235,39,129,115,94,113,165,212,140,219,239,255,30,2,150,71,167,222,250,123,230,253,102,110,67,175,23,73,166,0,144,47,148,163,151,221,23,81,24,247,230,191,244,11,1,206,112,51,40,182,33,40,163,61,107,169,167,6,202,202,72,255,23,102,172,225,38,148,226,88,109,43,255,21,145,157,184,0,241,95,26,253,89,42,53,13,149,184,8,74,173,119,80,63,39,122,131,186,46,224,96,135,125,146,230,186,215,105,91,230,163,169,125,167,150,59,214,137,125,94,22,30,51,110,143,175,201,170,44,185,136,253,28,105,89,77,41,65,135,12,60,237,170,191,75,127,88,149,34,205,123,6,139,121,217,249,166,254,165,197,104,144,84,48,58,172,21,122,128,85,199,148,36,114,91,239,123,1,206,8,169,49,206,39,142,97,137,189,224,169,198,119,13,171,201,140,49,157,103,118,88,94,210,27,126,242,245,68,55,25,204,114,244,247,64,29,145,137,154,56,172,22,62,19,227,79,143,90,5,12,201,194,154,224,71,103,79,31,119,20,146,114,219,19,44,92,21,211,69,49,20,95,47,183,25,195,60,209,50,238,182,244,59,9,94,112,27,36,210,214,7,152,57,84,87,219,76,117,252,173,214,2,188,162,120,141,43,194,108,127,121,25,148,205,129,10,46,39,41,144,243,52,218,147,187,37,188,247,50,228,177,63,51,214,17,10,240,24,244,129,34,87,146,124,5,230,163,171,120,234,22,101,103,156,68,245,144,114,132,132,244,163,47,127,235,219,88,243,187,140,196,153,78,126,139,116,152,107,147,27,119,0,2,213,231,59,70,73,214,67,31,130,51,71,155,189,211,225,165,140,83,24,36,56,202,105,50,33,140,155,216,216,209,252,54,156,254,20,81,120,206,235,241,53,194,44,177,128,30,239,26,95,124,88,90,21,132,123,188,158,141,127,241,223,95,178,108,21,221,145,222,26,192,180,84,129,78,175,117,146,57,215,116,10,13,53,12,252,227,64,32,115,213,68,143,238,155,225,101,184,132,28,92,127,89,232,1,139,160,185,99,115,92,29,188,211,254,180,85,121,47,205,53,199,122,73,153,119,188,74,163,229,129,90,48,50,178,91,189,168,116,38,32,114,55,89,132,116,208,124,128,113,113,16,206,199,26,163,212,71,1,250,155,96,53,100,44,246,31,136,208,243,220,60,176,23,103,88,245,48,51,59,225,235,226,76,182,53,49,135,126,117,23,4,0,51,62,11,237,65,252,21,246,193,84,14,85,217,111,240,108,226,134,59,194,210,198,214,9,245,99,101,81,3,89,134,225,173,80,61,204,115,250,25,191,22,137,42,177,155,159,237,248,200,39,189,1,66,189,88,8,198,57,47,194,59,150,74,50,244,192,145,124,139,137,9,88,183,226,179,162,219,55,201,222,186,109,36,242,146,104,134,170,9,120,67,123,240,251,118,184,113,206,203,242,204,29,95,103,160,139,24,229,246,174,44,232,1,92,51,119,121,192,74,200,193,169,150,115,168,56,37,31,105,175,166,10,183,252,135,115,233,34,0,229,124,183,246,177,143,42,237,125,2,142,154,240,49,228,213,15,77,123,202,79,84,0,147,189,200,161,106,243,41,87,86,158,216,240,246,100,112,9,91,213,220,206,108,190,57,220,218,99,189,47,194,120,28,127,254,169,178,91,243,109,75,134,210,210,244,242,159,54,217,20,133,68,233,153,234,101,91,233,30,96,171,224,92,91,176,236,182,188,20,131,21,122,84,104,171,14,236,252,249,75,212,235,191,95,11,62,141,94,241,165,26,219,173,197,153,214,168,223,240,94,213,113,148,95,22,212,203,134,117,232,60,147,51,11,201,54,4,81,122,170,58,150,209,147,128,196,78,68,78,148,160,114,198,127,162,120,180,68,133,22,76,101,119,11,93,246,9,232,183,127,140,173,92,221,236,51,178,45,217,246,70,118,91,129,102,24,199,252,7,6,116,81,43,240,49,115,77,164,134,23,10,184,92,26,223,238,174,254,108,5,221,29,205,3,38,30,51,143,196,202,21,102,228,51,105,45,191,54,175,140,175,135,132,56,183,9,116,20,68,132,18,220,233,176,239,82,87,160,87,75,33,255,121,193,156,78,230,23,79,64,52,198,99,148,130,106,107,8,203,26,34,248,194,178,123,242,238,250,69,219,168,219,185,118,64,221,220,7,62,58,172,34,161,85,252,155,52,152,60,87,103,183,167,226,234,225,170,247,90,38,143,81,89,210,156,20,60,194,148,113,179,171,5,77,184,78,26,208,131,200,86,18,46,116,74,134,61,119,29,194,3,117,40,80,168,90,103,191,42,184,95,218,91,28,155,54,146,65,95,188,105,77,14,205,75,249,117,46,221,98,224,169,93,190,83,43,182,146,208,7,135,154,99,250,12,2,189,246,105,220,172,175,69,1,167,218,186,57,136,247,112,149,221,32,11,202,229,160,52,60,200,208,193,198,75,246,250,53,55,150,176,139,93,85,222,206,205,111,9,73,162,186,211,69,140,188,136,164,203,223,18,225,119,181,234,138,60,23,112,75,105,15,203,7,125,177,246,31,45,74,151,48,22,139,175,136,183,250,161,111,94,119,158,113,175,140,79,29,122,65,55,233,80,125,200,31,209,18,35,82,3,116,190,125,208,46,253,125,100,73,160,238,5,244,38,184,200,7,167,119,122,165,28,250,26,52,110,188,151,63,208,63,248,94,165,164,111,163,146,32,37,5,60,85,192,27,61,24,60,161,222,0,4,254,155,189,84,196,0,157,35,12,162,103,138,192,135,38,45,40,41,69,63,30,177,222,41,253,200,54,63,230,237,20,103,172,23,99,192,215,2,181,198,52,12,1,157,162,169,147,206,27,237,188,158,40,214,164,233,240,100,201,245,24,178,38,205,66,140,166,43,132,117,143,233,22,167,190,202,18,188,127,240,184,49,182,87,84,214,121,140,169,20,29,122,133,69,18,168,61,132,146,108,35,131,109,86,101,183,150,34,77,90,194,24,46,232,28,48,183,206,47,100,61,163,165,74,17,92,27,210,106,16,222,186,117,41,103,197,144,3,27,9,248,132,189,88,83,122,219,49,116,2,50,30,40,205,76,130,35,126,83,228,228,138,171,171,135,39,196,227,87,106,235,241,239,86,179,253,11,23,99,7,66,41,158,178,157,76,234,6,5,214,254,184,155,181,84,197,165,122,251,119,249,236,166,219,144,14,253,20,200,71,185,128,249,58,15,196,101,206,51,124,190,50,159,255,10,172,123,168,253,230,89,10,236,71,194,62,129,71,92,165,85,0,198,135,157,141,191,50,13,140,37,124,110,249,46,46,25,251,68,145,8,18,120,51,137,142,119,244,148,246,141,26,132,163,135,241,35,159,49,77,209,163,230,111,6,242,146,195,49,170,2,124,194,17,165,42,155,254,34,50,37,48,67,234,117,90,102,69,129,61,195,172,78,87,34,46,79,146,168,210,166,122,231,226,222,204,251,20,75,223,196,242,130,34,225,110,75,207,175,78,24,239,45,171,104,198,59,0,19,49,11,243,112,43,250,158,62,80,155,237,46,52,188,185,245,171,68,197,202,251,110,93,211,94,67,191,87,157,87,233,13,61,47,52,206,80,194,167,66,67,198,170,244,247,174,171,50,79,255,184,161,14,254,202,162,162,254,221,148,221,251,90,102,154,71,98,61,150,1,32,250,227,57,240,168,21,174,152,107,235,75,2,198,35,117,161,148,210,231,214,184,87,241,102,16,184,144,221,165,158,108,17,177,46,228,156,159,149,123,171,239,250,40,10,62,189,159,144,124,7,64,76,122,161,214,158,46,206,191,99,142,189,68,40,168,172,65,88,130,102,169,121,107,188,201,117,35,139,212,14,176,77,110,172,197,14,238,254,189,108,234,224,228,68,226,121,230,183,185,224,25,14,142,86,3,2,21,133,116,109,24,125,214,126,192,236,107,42,30,208,247,43,102,62,205,11,213,177,80,163,92,245,82,101,244,192,151,191,169,102,204,190,167,232,66,226,12,115,238,131,188,181,235,30,55,68,17,186,125,64,121,44,39,147,240,53,20,40,101,224,109,239,226,32,115,253,200,113,202,118,207,81,168,138,146,224,129,38,168,181,120,87,225,170,24,6,223,254,59,48,103,66,191,112,18,100,232,149,121,191,132,39,231,12,223,111,202,150,238,150,76,143,41,37,183,222,8,16,24,33,99,101,144,218,10,68,70,133,97,95,109,42,67,13,102,0,93,189,206,41,149,160,206,101,195,209,76,22,231,109,76,142,113,78,222,63,202,227,65,140,154,29,47,96,41,58,77,137,107,249,152,7,126,53,105,31,221,134,107,150,14,18,108,110,152,91,57,88,146,199,220,12,79,116,220,134,180,176,224,71,97,52,154,76,94,230,58,14,196,154,89,27,162,219,96,227,91,143,175,92,36,179,222,30,59,163,32,250,146,96,163,83,134,33,18,27,99,127,113,171,35,52,143,96,219,71,71,254,216,30,244,75,88,241,242,50,213,1,83,56,154,152,153,219,130,166,175,82,10,125,111,96,137,38,46,205,11,85,195,29,184,117,250,218,58,49,10,40,30,139,211,81,157,249,51,33,100,201,34,96,197,189,206,48,180,50,2,111,154,109,10,90,116,189,224,85,45,153,10,96,210,142,179,131,174,213,131,9,90,194,235,113,201,152,223,253,134,198,136,215,196,121,114,145,127,197,63,226,22,10,124,149,177,37,12,217,218,113,9,235,142,49,103,237,98,82,140,8,127,97,56,61,78,76,142,106,216,56,78,153,139,60,223,243,28,34,38,199,137,132,50,118,151,58,141,192,20,249,138,53,114,177,45,146,78,147,234,123,244,61,157,119,7,88,41,82,17,102,213,59,93,79,45,40,157,139,219,81,12,134,18,77,1,101,45,228,155,66,227,243,242,202,71,136,205,94,102,239,237,253,62,207,30,222,178,58,135,219,74,150,232,27,209,251,37,198,33,83,209,39,249,183,21,38,213,39,143,198,149,91,161,250,193,43,45,233,70,234,118,173,231,180,151,157,138,7,167,198,81,194,51,164,200,83,56,176,121,167,225,108,50,245,125,137,148,215,111,59,19,64,109,5,114,176,218,137,186,235,94,254,156,96,194,168,34,159,84,171,68,70,215,155,148,244,240,11,54,128,75,56,161,201,231,65,137,194,113,32,89,201,13,141,169,131,94,198,168,132,135,101,50,165,181,8,159,184,15,19,74,16,105,43,25,168,214,106,76,164,64,91,12,74,22,16,124,27,121,145,188,125,255,96,131,33,245,145,180,29,62,194,137,30,62,243,129,77,13,158,163,117,162,206,61,236,135,244,220,166,174,217,73,139,0,254,201,26,125,241,33,68,187,155,235,119,25,72,196,151,8,255,8,84,250,43,102,204,134,121,186,123,144,48,2,235,7,229,41,190,150,181,169,203,226,194,118,180,182,162,220,222,14,52,114,197,229,86,207,201,148,241,246,69,68,231,8,57,6,21,171,44,83,134,151,83,25,48,142,91,248,21,21,213,9,104,208,21,12,133,100,100,144,124,237,193,56,180,34,39,246,232,53,212,121,61,127,221,103,74,114,150,223,11,229,210,6,76,40,95,192,199,167,100,100,64,117,44,73,13,187,42,241,47,212,35,164,55,64,85,88,41,102,68,165,110,72,100,66,38,33,14,166,233,157,80,35,137,1,69,63,111,169,42,19,65,190,106,104,216,90,154,147,190,183,207,177,145,142,190,213,148,10,228,251,99,58,72,148,192,227,20,1,79,110,181,47,89,218,133,7,75,111,229,49,60,97,179,158,28,51,110,139,80,56,147,33,182,227,153,92,32,1,241,44,181,143,24,16,252,26,129,134,63,65,186,1,160,90,254,21,88,43,220,101,222,156,214,211,98,172,42,254,193,103,147,61,229,181,85,228,223,127,163,201,157,106,97,82,251,201,89,32,245,234,92,103,151,70,111,44,210,74,166,88,95,204,82,185,9,218,72,146,27,181,139,97,122,22,228,206,84,237,87,140,101,100,110,216,186,226,110,186,109,140,162,59,52,3,26,96,176,41,84,66,47,216,100,110,106,2,55,106,165,232,43,156,42,193,122,42,74,224,96,101,41,240,141,4,88,29,113,31,121,80,196,152,15,234,154,70,129,228,97,137,99,89,108,64,143,32,111,199,220,209,192,20,24,80,192,202,191,169,156,133,210,36,179,17,149,67,213,52,180,176,134,253,181,179,174,87,217,236,254,162,137,201,192,88,23,89,195,231,73,182,226,224,149,99,172,221,135,5,241,132,86,236,118,69,50,108,27,103,65,17,127,75,11,160,71,85,227,148,153,62,103,83,250,192,254,215,123,252,157,8,112,132,210,193,21,244,168,131,44,69,226,190,243,10,225,163,84,190,118,32,19,193,234,220,32,188,74,90,197,143,70,191,99,113,186,143,49,131,109,253,62,234,221,183,103,238,89,65,67,11,230,9,222,24,95,129,14,228,125,126,166,49,29,239,36,39,124,130,203,200,105,29,231,182,43,1,179,193,103,230,251,205,22,182,65,191,137,110,165,113,180,60,209,87,212,7,69,241,130,157,125,59,225,89,244,120,134,142,170,92,19,65,251,87,163,83,32,185,163,202,187,191,34,192,183,186,236,30,222,225,180,237,142,162,77,93,190,100,248,70,134,164,253,105,255,142,189,83,50,161,225,223,241,240,252,170,90,122,221,22,108,187,81,31,252,76,218,238,217,175,90,110,37,190,8,65,147,181,160,202,39,24,230,218,92,233,102,123,98,72,215,163,152,111,198,25,215,60,213,1,254,4,168,45,13,40,238,142,158,60,70,241,144,183,215,236,146,149,13,234,215,133,3,112,135,7,8,40,195,214,105,244,172,246,200,198,238,153,112,100,59,137,18,122,9,204,17,41,181,111,41,61,21,160,16,170,194,218,178,62,88,92,199,233,200,24,70,246,142,224,164,200,210,237,216,75,100,45,115,160,117,92,38,226,170,215,156,203,215,210,248,231,199,216,248,161,125,167,132,103,180,186,9,249,4,154,16,237,107,80,28,27,235,150,39,210,201,153,66,17,97,165,29,15,167,130,23,77,17,106,160,90,248,47,219,164,20,127,81,248,1,36,254,22,50,208,65,145,45,220,160,93,16,45,62,229,177,187,144,167,142,26,248,232,6,191,77,59,136,49,2,33,116,66,65,146,218,44,111,73,2,222,99,111,24,180,41,67,103,39,216,168,240,207,142,34,241,86,17,173,37,58,64,186,213,98,181,151,159,141,26,22,31,45,92,64,9,10,26,76,181,236,145,18,8,30,219,158,183,71,138,134,56,65,70,34,140,141,13,54,245,29,155,227,200,183,113,40,113,203,86,214,2,162,90,237,5,247,2,186,149,205,73,75,106,255,178,8,39,126,21,96,43,117,216,10,81,98,244,208,25,252,177,189,21,50,204,13,115,42,29,115,2,10,234,207,168,29,131,228,241,82,183,158,85,177,161,142,249,81,208,74,7,73,61,160,142,153,121,63,78,230,152,77,38,100,58,119,15,102,23,145,201,189,165,77,147,230,208,2,84,68,22,86,13,32,68,58,88,73,8,48,139,117,27,222,40,32,182,33,168,89,188,113,162,162,146,225,102,118,158,53,22,82,149,184,240,92,212,243,40,50,170,149,147,223,104,185,45,162,20,59,162,173,157,5,224,233,8,159,219,28,215,102,178,59,121,254,199,162,199,99,2,69,53,6,16,218,9,6,241,44,220,188,45,208,250,244,235,250,209,70,110,222,198,183,219,47,135,143,170,11,226,178,201,194,8,0,115,63,105,158,9,227,172,16,176,218,211,18,70,236,5,109,35,119,143,218,145,213,190,153,247,240,232,191,61,9,58,130,175,235,45,122,195,207,43,194,102,133,91,46,230,18,78,212,122,114,168,4,94,120,96,72,18,12,142,191,141,105,202,78,241,114,85,34,238,84,11,10,254,50,188,122,76,216,117,121,110,3,95,91,62,253,60,174,139,195,120,183,220,61,229,75,22,220,190,134,216,68,90,111,184,152,40,130,43,39,76,144,94,215,83,252,62,127,27,6,175,158,50,87,41,85,95,32,24,14,193,22,92,54,156,254,77,61,50,7,243,25,48,156,89,56,17,33,107,135,110,160,52,80,216,55,217,98,40,102,1,34,70,233,200,205,172,234,156,17,180,123,113,143,67,81,224,51,149,12,213,251,3,2,63,30,249,181,254,120,160,155,133,96,137,181,35,5,182,121,214,39,128,129,237,203,19,137,24,93,101,255,228,209,34,58,241,253,187,131,60,8,241,178,36,11,26,109,21,150,214,31,242,19,60,118,147,158,111,23,164,168,73,67,92,231,211,6,86,222,242,248,107,142,231,119,143,1,168,27,187,91,70,38,230,162,216,232,152,83,71,41,183,182,189,94,221,128,7,217,182,42,49,232,20,23,3,87,95,213,181,137,117,14,161,52,243,122,183,193,90,134,182,58,222,179,72,150,241,129,197,216,227,156,20,75,90,202,71,128,15,137,242,183,117,188,168,252,39,243,76,167,222,12,190,250,197,206,164,145,191,47,206,24,20,40,253,36,4,220,72,143,199,19,105,30,48,219,215,196,37,15,182,38,220,134,239,35,187,29,230,68,215,139,220,215,90,25,184,246,196,149,239,249,142,248,63,141,205,161,28,87,142,170,237,214,67,142,251,97,163,163,242,208,139,28,201,5,249,160,111,232,64,231,207,201,197,196,206,92,127,71,17,57,48,200,25,226,176,113,210,162,108,233,45,224,15,40,196,161,187,228,55,88,74,235,30,68,12,209,70,87,243,159,85,208,70,192,75,111,14,15,239,6,234,134,248,30,113,51,255,128,43,104,82,6,158,241,74,19,174,199,229,132,238,6,70,145,96,242,208,185,17,12,251,210,13,113,233,186,188,29,9,195,244,71,62,26,195,82,44,209,10,230,93,188,92,234,241,145,115,67,77,67,44,210,249,228,5,84,43,160,77,103,214,59,87,195,200,20,129,254,173,229,229,37,115,254,49,72,119,145,188,255,12,95,191,110,239,124,12,213,234,217,4,211,133,39,184,242,103,223,13,5,50,56,74,214,135,66,130,62,223,167,91,175,30,40,134,82,42,167,175,169,33,40,205,88,123,104,96,189,142,226,130,73,0,60,121,128,225,203,146,1,170,4,93,235,72,243,97,77,129,92,246,173,53,161,138,204,83,70,234,80,223,20,176,62,149,150,127,141,182,196,163,80,117,13,31,248,64,166,35,112,96,44,221,70,128,124,229,74,60,65,83,15,20,135,165,184,82,153,163,153,145,137,168,21,68,140,120,76,239,1,57,32,133,38,158,157,114,92,79,139,129,100,233,109,73,206,6,164,101,18,250,41,214,14,185,87,241,153,142,116,3,55,77,138,149,123,112,38,59,191,132,156,136,205,108,175,236,117,66,107,36,241,192,147,149,227,116,253,26,209,34,134,94,214,68,212,25,142,117,207,151,32,13,101,187,154,38,54,165,162,58,254,142,54,86,89,13,232,46,36,31,67,169,250,183,168,205,55,163,165,77,37,211,28,12,51,80,99,47,117,190,69,215,83,246,24,48,152,252,50,167,183,242,94,21,63,211,171,23,199,4,160,172,57,57,92,128,50,52,174,87,77,255,17,221,149,165,195,162,43,38,226,27,221,101,124,188,82,226,222,49,132,246,31,27,81,255,205,69,176,163,195,253,83,47,80,99,157,132,223,160,92,39,120,73,149,51,171,255,67,218,107,160,220,58,236,28,119,180,1,82,24,146,160,44,200,70,141,109,254,12,126,229,95,99,96,3,216,221,136,205,113,142,122,186,243,183,255,22,253,97,176,39,222,179,209,180,233,133,72,37,54,158,28,65,95,13,1,59,153,193,87,230,128,104,160,201,205,2,196,6,125,232,155,188,65,83,240,126,145,178,63,143,0,240,193,78,184,2,226,82,240,49,22,50,167,206,196,168,121,68,212,156,249,154,95,24,93,83,113,168,33,14,246,208,135,139,78,122,101,123,8,177,97,182,122,128,106,140,8,192,100,143,88,196,50,29,207,215,143,65,120,133,133,118,94,128,12,106,130,195,165,203,112,192,173,166,222,59,23,34,6,82,131,16,84,214,205,87,208,140,201,182,166,221,131,122,181,85,150,65,139,133,103,23,179,159,231,7,175,204,95,130,131,126,45,155,135,76,69,145,54,197,251,173,9,206,46,189,122,101,178,24,17,52,231,121,151,60,255,66,47,5,0,134,235,185,232,129,137,35,158,3,110,230,211,73,61,209,224,71,153,55,248,61,100,233,170,140,66,27,177,253,40,208,209,143,4,27,108,105,166,136,60,8,218,119,168,182,107,8,119,5,118,31,219,43,94,70,182,91,68,254,135,245,212,250,26,105,156,109,180,133,177,249,140,89,130,79,55,31,123,18,154,42,191,139,9,240,237,151,107,173,188,134,243,132,118,79,249,197,52,29,174,60,127,48,203,213,101,118,178,117,92,200,49,217,119,172,213,150,231,103,134,168,200,159,174,105,85,8,72,53,243,196,179,102,171,173,207,190,134,186,250,180,231,155,193,203,81,248,175,8,196,145,73,186,178,63,177,60,238,12,42,169,79,173,245,76,171,131,19,102,237,156,201,116,42,209,167,158,198,227,114,197,227,182,212,229,151,110,140,149,239,82,124,137,145,167,26,54,159,102,237,132,139,121,181,115,78,145,179,231,40,243,114,107,190,126,230,152,86,21,43,130,126,87,172,107,120,215,174,119,95,238,138,107,162,109,30,0,156,48,191,59,137,171,39,151,249,219,16,202,29,186,7,225,198,202,213,119,26,30,46,66,61,154,127,212,160,121,30,139,137,77,16,197,1,225,23,181,190,52,124,88,224,250,45,111,131,115,99,26,188,227,244,207,13,101,230,130,96,187,90,109,141,203,246,150,213,238,2,180,162,199,113,129,255,97,7,65,101,37,145,166,70,193,39,68,86,45,6,162,80,189,182,147,237,204,108,173,114,12,139,6,79,110,178,50,39,17,113,41,178,217,61,88,132,240,93,181,152,170,7,71,170,146,115,177,209,87,215,16,157,38,76,45,46,220,16,103,58,125,32,153,241,187,154,232,13,56,84,165,56,94,8,6,118,36,14,96,65,93,68,50,208,97,85,185,103,1,161,83,67,194,38,128,76,181,204,102,151,40,72,219,119,58,243,206,0,99,50,157,241,110,31,75,39,89,181,28,80,34,47,54,40,145,0,60,100,212,148,16,35,19,189,130,103,237,1,19,109,241,72,134,148,103,72,23,209,106,186,211,41,196,18,76,23,75,122,68,251,50,11,252,232,52,72,57,5,52,226,217,252,184,71,71,112,106,214,93,60,250,235,235,115,148,64,183,222,82,158,135,135,145,153,54,138,126,116,216,66,235,51,100,7,1,111,11,231,57,153,174,195,76,173,195,2,137,227,217,61,109,233,31,68,5,179,235,72,80,16,191,118,37,76,119,131,246,39,251,58,127,172,229,32,135,167,216,216,39,54,7,180,45,236,44,47,186,218,5,45,145,201,222,24,126,214,198,237,218,245,74,159,119,201,233,27,224,213,175,46,43,252,104,209,254,53,126,25,166,190,157,66,64,23,226,4,74,69,28,42,238,195,233,33,1,64,116,16,110,32,81,97,57,242,250,108,13,200,31,184,115,30,190,65,111,225,197,90,215,174,221,193,216,165,11,16,3,153,141,181,161,223,213,141,64,243,41,33,65,208,245,48,203,171,242,234,120,183,57,60,85,83,188,148,249,94,62,178,164,119,223,137,180,49,184,166,120,134,127,76,230,216,208,161,5,42,237,196,235,114,222,23,134,110,242,244,163,1,42,228,3,251,93,156,48,46,154,200,19,163,205,213,250,142,212,14,156,210,48,20,148,235,204,232,128,21,3,100,38,184,230,249,138,117,207,253,60,79,102,174,115,184,21,102,194,116,47,69,98,110,200,73,248,186,30,220,75,239,155,228,138,141,255,84,179,127,17,124,167,107,102,248,93,59,11,170,167,110,129,228,140,41,111,215,131,169,31,210,192,131,220,50,29,241,34,235,141,60,96,178,83,126,109,14,186,209,248,63,130,108,186,180,105,95,192,234,29,87,8,197,153,103,55,13,10,116,247,40,153,54,84,199,120,69,98,185,228,4,234,107,80,168,240,218,9,114,58,196,150,245,120,244,210,164,160,201,55,20,40,135,138,179,149,228,199,157,192,174,190,79,35,154,208,104,215,44,229,241,125,186,156,42,60,224,60,98,79,40,64,126,207,165,212,10,115,54,25,33,126,58,236,50,194,209,149,85,111,178,89,79,15,60,227,54,174,229,243,135,42,102,50,171,254,95,21,247,31,125,0,215,95,9,254,115,158,204,23,106,103,28,139,202,110,125,119,242,110,213,56,152,116,42,49,235,231,28,252,0,141,119,191,200,51,122,183,74,56,200,99,174,153,239,174,227,16,247,241,53,17,43,147,201,28,236,24,172,158,183,250,239,232,109,178,138,191,154,85,92,101,93,173,175,120,149,115,204,109,250,109,193,172,203,85,254,72,122,109,173,97,223,35,161,59,23,39,177,164,124,186,70,76,36,143,143,79,179,160,167,125,30,112,233,209,141,126,247,37,119,77,159,6,86,22,186,250,64,148,109,116,69,157,161,219,213,126,74,234,55,4,74,150,191,164,59,229,208,73,147,153,74,155,93,93,177,111,177,180,36,107,46,26,222,118,125,41,31,110,95,84,199,96,81,223,99,229,230,111,208,187,44,207,189,197,162,155,118,66,246,102,5,157,180,61,121,27,171,235,38,194,219,47,109,32,238,247,114,130,158,184,151,243,155,87,210,50,16,172,39,124,229,145,237,44,49,206,229,30,118,171,255,129,65,10,175,28,62,65,30,217,20,113,253,179,149,240,28,118,112,140,20,237,39,7,159,242,230,64,144,209,53,33,213,116,176,141,135,111,225,244,248,107,202,235,131,88,130,60,113,17,151,144,193,21,155,78,5,33,221,177,64,101,141,166,1,217,83,16,24,8,33,203,8,73,180,252,201,36,37,193,112,158,81,36,62,12,87,125,150,121,19,39,92,191,173,210,244,36,77,195,88,140,26,156,4,231,27,111,89,251,35,188,185,246,75,176,127,162,75,144,137,255,124,36,161,108,144,154,177,88,19,197,21,51,61,242,175,177,115,118,58,158,40,174,196,158,97,198,184,209,36,126,232,71,189,204,186,7,102,36,124,234,204,89,172,220,192,86,101,51,175,40,9,191,17,115,155,117,200,237,22,138,77,48,250,240,160,224,117,133,170,182,144,213,211,213,2,243,145,65,254,0,2,248,48,33,249,80,119,29,108,76,228,213,3,143,250,23,23,131,183,155,60,55,214,27,114,225,198,150,10,35,148,123,109,118,26,2,65,205,51,165,231,113,146,183,118,99,110,128,192,107,84,128,130,68,16,88,195,165,35,170,219,153,195,92,132,226,34,20,77,81,240,139,150,107,214,77,155,204,106,79,19,168,44,71,198,240,87,142,60,44,60,246,5,116,90,243,72,82,123,206,123,164,157,159,113,100,46,227,97,151,247,172,49,26,253,214,112,110,75,191,20,199,178,121,153,73,146,167,80,165,179,249,104,118,42,76,8,126,200,69,25,1,35,35,219,85,218,235,253,164,63,211,195,178,60,208,120,222,151,167,79,238,35,131,109,53,18,149,50,40,14,206,218,230,111,82,234,124,19,223,6,18,94,196,199,189,219,79,203,3,86,63,184,11,70,220,145,70,39,204,13,70,25,105,99,18,2,0,24,161,197,244,35,162,11,157,34,54,196,92,138,255,30,83,77,170,69,196,207,11,28,60,155,7,88,6,248,72,159,21,242,123,4,244,230,249,74,32,130,186,174,143,2,140,24,130,73,170,186,195,129,0,221,95,213,21,27,147,128,194,103,91,111,210,249,82,200,180,140,107,187,79,132,95,135,105,220,39,219,47,101,130,232,19,153,84,96,21,214,227,184,212,26,88,77,22,173,250,215,51,120,214,55,206,86,220,178,39,170,15,114,12,97,98,239,4,124,47,250,230,133,149,196,82,209,165,151,0,207,30,106,133,62,251,241,196,196,47,179,145,179,2,155,15,5,165,22,67,52,207,39,246,123,134,219,252,174,231,168,82,8,7,192,229,168,45,215,86,100,235,111,169,107,12,249,89,109,86,160,142,181,238,237,223,92,168,130,150,236,224,116,222,45,18,13,13,164,73,38,27,208,24,138,45,80,4,148,58,149,54,128,230,244,22,230,218,179,87,51,104,223,178,9,209,228,14,206,192,249,41,82,34,115,235,125,150,192,196,1,165,252,62,83,243,157,37,218,134,192,149,232,139,145,253,205,51,17,97,192,121,157,60,181,170,126,156,5,44,196,235,223,123,170,2,118,228,255,243,8,132,196,221,30,242,92,159,112,180,131,51,25,126,253,184,7,4,110,34,217,37,185,91,186,44,77,80,104,181,58,171,9,210,180,17,119,8,141,229,247,64,62,232,121,118,112,133,52,173,5,202,94,170,37,212,28,222,193,97,51,164,107,197,181,220,102,52,58,47,147,194,179,174,14,89,19,221,145,39,174,86,249,64,89,192,101,143,207,156,186,210,1,137,143,225,13,38,98,59,92,137,53,31,64,212,100,157,144,100,131,3,65,115,94,185,87,13,25,176,45,184,207,19,250,197,231,86,217,51,191,125,60,11,95,125,105,236,148,166,54,6,42,0,150,180,138,38,30,235,72,106,14,217,69,184,242,46,197,173,38,89,234,41,197,213,165,79,86,118,231,142,207,69,207,108,20,53,179,160,231,84,99,156,253,80,13,15,65,18,73,160,149,31,76,124,141,4,48,207,86,81,87,66,32,121,213,115,116,230,240,201,247,195,159,66,154,244,180,174,14,101,84,3,66,175,40,177,65,194,101,162,234,26,55,222,21,72,164,219,243,129,30,172,104,212,50,6,152,90,233,235,35,221,207,165,225,44,109,74,127,123,173,56,87,209,84,211,48,214,123,5,105,101,78,188,169,175,36,172,214,19,232,125,217,130,252,99,237,244,61,173,193,82,209,216,57,13,12,202,82,193,78,70,69,206,74,240,191,91,25,179,254,242,177,68,23,139,165,101,32,52,246,25,212,240,38,237,147,60,156,190,36,3,56,163,125,228,107,228,6,235,44,250,90,92,77,158,36,217,168,161,77,26,49,125,99,103,191,115,41,120,16,231,243,69,108,169,115,81,127,195,48,164,132,75,173,147,62,148,220,3,189,186,165,200,86,60,18,172,193,207,129,196,167,69,181,134,232,130,109,48,76,133,202,38,184,207,153,39,149,26,4,242,77,59,193,254,102,222,99,68,91,147,245,252,14,111,57,224,121,244,233,148,97,66,37,162,181,44,60,144,184,181,187,204,143,33,120,225,243,226,97,190,168,25,134,240,146,145,251,166,104,183,243,126,93,104,93,84,55,148,49,84,30,71,204,203,236,226,179,113,247,64,213,92,207,126,35,130,231,86,232,149,34,79,127,8,155,120,228,29,247,142,10,151,52,57,180,40,56,93,99,171,253,160,143,201,101,183,204,59,240,23,208,83,198,151,231,231,147,28,110,4,156,102,57,157,18,249,18,50,20,130,56,53,156,41,45,170,41,117,136,179,222,121,239,18,168,166,237,2,237,98,107,148,236,81,60,2,33,181,218,46,71,254,197,234,84,204,80,27,160,118,123,153,37,55,238,240,199,98,227,116,197,126,232,21,255,98,226,206,152,34,211,121,85,69,183,195,225,202,232,188,79,208,206,156,187,96,21,189,252,76,203,227,241,70,211,61,52,217,12,33,243,41,50,152,77,47,82,19,140,197,235,100,59,65,70,115,52,246,95,80,145,224,57,224,221,213,78,145,49,47,117,102,248,205,92,84,18,215,150,191,135,145,62,36,193,200,52,133,187,34,96,149,139,1,97,248,25,51,64,247,58,93,111,15,225,212,223,114,61,92,11,95,154,153,245,208,78,148,39,150,34,40,110,50,154,11,54,4,145,21,134,166,233,0,193,39,105,2,102,29,28,168,238,231,117,248,142,40,50,56,142,240,142,165,151,16,85,30,155,98,225,239,177,187,143,215,228,29,118,98,85,69,167,21,45,116,143,40,42,152,1,87,158,139,169,81,137,18,54,65,178,145,44,82,225,241,84,208,111,202,139,17,95,107,130,255,148,105,65,106,172,230,171,55,197,239,133,168,4,152,247,235,19,138,175,168,216,216,171,23,160,83,71,40,126,234,228,1,76,145,9,132,135,166,202,190,232,233,218,105,184,138,161,252,19,33,132,61,159,183,129,62,37,37,194,79,104,59,218,204,215,82,166,4,190,36,224,43,97,59,71,51,188,214,175,54,18,10,15,153,110,203,218,59,225,113,185,123,75,111,206,104,24,163,254,170,85,40,105,9,229,41,218,37,240,211,103,89,253,97,34,77,188,114,220,132,215,129,26,109,149,186,128,119,108,19,20,122,172,175,10,20,169,9,104,195,150,51,8,159,140,86,232,226,177,7,196,200,167,207,106,126,27,140,222,219,198,149,46,0,13,93,255,121,205,23,206,245,185,247,15,231,173,156,59,156,16,48,118,254,93,148,203,237,189,158,180,101,52,62,155,57,8,175,171,215,67,69,104,60,72,232,226,185,20,206,65,59,42,125,90,124,100,202,134,141,239,191,110,203,164,223,50,232,219,4,222,205,22,70,62,180,75,143,174,228,44,62,245,202,39,117,215,33,145,80,106,131,177,244,66,46,89,167,198,251,80,38,72,190,90,118,85,34,158,83,17,61,132,124,53,24,63,24,90,249,68,131,245,198,183,117,13,157,137,70,189,73,23,75,77,13,25,88,126,217,87,108,92,8,133,154,15,158,112,113,94,186,162,177,9,232,181,162,55,24,38,161,79,176,4,233,11,158,170,242,240,168,77,25,3,223,158,186,182,26,129,84,106,135,108,205,79,254,175,227,1,238,248,79,5,72,169,217,128,158,1,139,110,157,12,39,55,95,3,2,113,179,81,229,38,144,253,35,77,155,97,157,9,47,133,35,238,97,246,176,156,164,3,236,181,42,140,173,1,46,164,218,168,228,127,219,160,224,59,249,247,7,155,98,77,199,215,146,55,151,221,185,163,241,26,122,137,164,190,205,207,4,237,134,165,74,238,223,226,15,248,242,139,107,210,187,234,4,145,23,231,180,229,53,254,166,201,220,10,14,58,33,230,72,92,230,207,170,109,188,229,137,28,147,22,41,192,213,40,215,216,127,14,228,9,13,85,247,106,247,1,155,206,136,4,23,190,148,170,106,194,155,170,96,227,85,168,247,195,20,113,172,17,34,38,123,79,167,110,206,207,53,66,173,162,178,166,84,120,160,160,218,186,227,34,87,100,212,219,28,84,255,59,138,26,28,227,102,205,94,75,152,55,216,163,46,225,96,152,57,32,57,159,27,251,178,201,231,5,139,31,163,136,69,71,125,19,213,46,252,84,88,215,163,249,153,181,25,227,174,4,105,93,98,251,60,164,4,222,26,165,85,83,87,45,206,132,134,6,108,89,96,76,139,144,143,144,116,59,72,48,184,248,230,195,135,167,29,166,42,207,49,87,221,159,42,168,96,157,181,125,152,96,130,72,48,100,105,145,96,98,200,116,7,131,166,69,99,117,55,141,40,125,106,249,33,118,191,121,159,138,79,27,90,132,13,52,0,61,44,246,212,77,127,107,26,124,234,104,26,14,238,68,79,124,247,99,81,60,135,27,62,83,231,104,214,53,69,104,188,95,120,30,105,222,150,218,223,80,221,209,86,113,125,226,123,36,1,136,94,206,253,124,34,218,2,77,208,172,39,238,148,151,111,237,3,135,99,41,22,142,129,39,56,105,255,31,62,12,171,5,206,94,114,13,174,185,89,199,225,131,239,187,92,132,102,86,138,156,36,55,112,65,191,209,70,60,75,110,59,216,180,148,36,118,238,139,97,222,17,236,209,68,163,76,177,206,58,196,113,2,166,47,131,113,199,180,134,23,174,24,119,20,124,144,29,221,9,90,224,188,131,232,13,244,94,200,129,51,27,11,124,24,154,5,91,171,150,238,212,117,175,71,155,110,168,3,236,162,196,193,74,101,6,238,157,132,151,181,88,122,26,84,194,170,253,198,124,142,133,185,66,4,105,5,152,87,209,178,134,243,242,197,214,209,103,53,218,128,193,9,83,231,55,111,29,235,133,45,107,115,71,203,15,1,69,200,105,216,1,163,183,18,222,54,6,56,48,104,228,237,119,166,90,242,184,97,160,218,194,255,151,131,120,180,104,202,167,157,179,147,77,161,34,65,201,171,236,177,175,0,92,134,255,40,217,133,61,187,44,165,109,184,127,37,189,61,62,60,232,182,210,78,123,118,207,185,156,158,77,117,67,26,37,222,174,87,192,241,152,180,170,218,35,86,86,91,87,98,97,192,129,140,194,233,36,79,152,203,136,73,223,63,26,117,190,88,188,60,42,9,45,54,223,198,207,196,237,26,244,60,233,67,132,223,113,147,253,16,126,10,119,41,159,99,237,109,167,23,248,146,7,166,214,75,0,234,202,90,254,26,71,82,240,116,216,96,236,109,46,104,255,134,115,253,155,36,36,129,188,183,140,151,14,153,244,139,244,252,214,160,8,249,226,35,58,185,116,255,126,128,120,235,190,225,169,185,175,255,64,176,56,247,249,7,18,39,92,249,142,98,47,116,247,126,6,66,208,245,253,217,123,160,123,49,99,18,90,47,9,80,207,212,123,18,61,155,193,44,242,205,146,4,96,210,222,194,220,47,172,241,165,29,155,45,163,105,121,174,115,233,211,216,182,136,24,90,234,77,214,70,94,160,35,59,16,39,71,24,186,43,251,99,53,11,47,60,159,24,144,250,41,114,90,26,97,209,154,96,63,178,67,28,211,107,179,90,253,127,165,163,26,175,163,165,60,47,25,151,210,245,25,91,122,31,176,184,179,128,161,75,71,166,119,40,19,58,101,115,237,145,211,239,250,235,224,4,46,64,94,118,213,191,21,42,27,169,75,217,193,182,121,215,57,216,234,245,160,135,78,21,125,113,51,250,39,177,32,227,61,57,182,118,16,212,181,130,153,240,62,148,127,188,127,160,37,3,231,33,68,181,179,95,116,179,14,247,145,214,104,222,71,140,17,161,171,218,105,81,195,25,20,202,235,110,70,90,42,47,194,109,74,85,60,77,65,92,205,106,16,171,147,0,227,16,251,48,224,101,8,46,29,94,50,36,213,78,254,13,7,254,227,219,219,18,45,213,145,136,25,210,42,32,47,62,61,139,31,140,17,210,249,37,178,80,160,59,139,26,250,178,179,208,129,81,82,239,54,209,224,20,156,174,251,26,130,136,28,68,243,28,42,28,17,51,90,6,39,125,11,249,223,165,193,243,148,129,17,210,146,186,89,202,253,59,205,5,52,237,17,181,104,92,54,142,214,177,178,59,214,195,73,72,186,175,17,1,0,220,146,69,144,120,89,133,146,152,239,230,141,237,0,78,250,117,54,179,45,38,167,90,149,136,233,115,8,227,210,205,255,208,177,5,45,173,12,189,122,109,122,136,191,40,176,51,234,201,4,208,42,147,44,56,120,17,43,69,93,97,143,103,130,166,129,101,7,40,85,92,157,218,212,230,114,139,2,233,64,93,127,49,140,232,168,194,0,74,215,40,158,61,12,247,57,151,103,148,42,210,155,139,211,87,19,0,208,70,224,199,34,241,199,70,169,161,135,61,105,233,172,62,114,0,96,15,45,231,45,55,172,39,55,41,225,133,190,138,162,53,142,120,95,183,32,192,36,208,155,102,233,86,61,53,30,206,83,199,125,72,101,207,29,247,104,10,148,18,184,234,165,202,151,116,193,119,185,112,23,192,20,152,65,174,8,254,94,56,95,112,30,175,131,75,160,36,26,226,61,55,97,225,40,77,212,181,0,239,155,198,208,128,240,202,248,190,135,42,46,22,94,11,61,30,199,55,16,98,142,1,63,173,36,147,172,74,152,45,239,201,204,46,115,27,81,227,120,112,155,184,99,79,214,130,147,122,64,139,9,147,208,82,76,15,123,98,5,74,218,198,40,175,162,34,226,243,95,227,126,94,45,242,141,118,9,49,66,13,62,135,201,56,200,96,255,212,204,11,3,243,18,242,108,74,227,62,173,115,180,224,226,248,249,141,136,245,6,158,110,65,8,248,189,225,236,226,84,45,8,72,133,12,176,12,140,172,135,245,88,80,88,0,185,175,79,207,75,134,219,100,194,29,255,125,135,114,8,126,63,172,235,145,65,229,120,37,197,36,66,254,60,122,61,197,192,6,79,197,152,198,219,179,231,14,155,211,69,154,175,209,49,59,91,6,25,138,1,144,199,28,148,67,149,19,37,147,101,173,173,206,196,37,179,47,184,185,251,43,182,74,221,246,66,82,220,131,113,87,197,241,66,226,95,156,93,186,196,250,229,244,248,189,22,207,27,43,104,3,210,183,207,145,95,190,74,251,145,107,71,36,138,225,83,79,207,145,78,210,137,175,90,23,239,94,181,98,41,136,109,211,114,150,87,255,49,149,169,69,132,65,211,140,205,214,29,22,127,210,12,110,19,72,139,152,200,229,246,220,110,222,227,189,5,36,90,254,53,6,237,122,57,142,108,23,90,140,146,218,237,207,124,148,18,43,1,231,98,177,83,35,133,156,57,105,201,222,84,80,168,12,176,33,62,83,81,72,91,127,176,136,94,105,255,254,90,145,155,68,132,45,203,4,81,16,2,218,66,189,227,170,31,12,196,122,121,143,12,99,122,129,195,234,210,79,14,55,209,162,72,6,182,66,57,203,144,165,124,104,28,239,250,145,78,30,73,201,115,103,29,184,58,64,70,85,21,63,220,48,82,120,182,147,193,160,57,159,29,228,110,185,119,116,208,106,226,116,121,81,43,222,244,81,208,45,54,252,92,150,203,97,118,228,145,19,251,135,68,118,217,134,205,225,179,191,233,152,12,91,197,183,100,112,245,155,90,49,164,31,226,11,161,97,101,12,52,104,87,67,185,88,236,186,244,207,7,33,67,86,181,69,233,84,8,132,228,204,119,32,165,140,91,72,140,72,59,85,160,243,119,182,101,202,174,103,225,103,157,66,245,6,239,65,118,228,82,220,95,37,111,101,138,161,191,68,163,207,254,132,5,33,34,56,45,15,145,79,100,40,250,236,235,36,175,245,20,209,154,13,198,149,155,0,80,11,84,80,172,105,217,187,232,7,132,48,231,150,103,105,189,165,83,77,153,247,75,244,46,186,175,219,208,150,199,180,28,58,132,148,105,13,207,113,32,133,101,252,13,167,207,239,200,38,246,25,126,101,156,150,20,134,155,28,193,203,237,91,8,31,34,172,248,160,57,105,219,239,42,133,226,116,81,43,132,235,167,30,68,43,231,221,164,52,182,249,179,61,153,161,159,137,151,189,73,236,246,163,36,98,19,85,248,126,173,105,179,75,212,179,6,192,100,128,153,211,199,108,66,203,86,207,169,95,199,34,119,154,244,10,13,220,112,98,175,183,40,113,55,27,57,116,86,1,170,179,54,173,252,94,178,69,116,19,143,251,130,194,112,136,117,223,38,229,127,85,195,14,156,30,223,71,155,223,129,124,152,171,136,110,120,95,180,53,100,168,25,3,216,42,54,85,46,69,119,107,155,145,251,64,53,185,193,15,13,139,6,167,11,60,47,89,97,48,152,126,89,204,146,71,95,57,111,150,78,240,251,102,115,113,11,147,15,192,253,231,25,248,245,109,134,153,56,58,101,46,144,2,253,31,2,83,198,61,64,121,63,76,80,67,29,12,66,28,147,254,92,69,68,35,212,156,221,161,237,249,146,56,121,137,145,156,246,183,247,139,124,62,163,212,103,229,186,93,174,69,23,160,26,196,181,43,175,176,60,110,211,55,131,146,61,179,46,79,154,194,63,7,77,202,244,150,202,18,92,217,129,241,239,222,111,51,135,13,231,255,23,171,205,2,165,228,225,46,247,213,245,181,190,140,154,241,182,186,251,24,83,159,137,53,64,138,170,164,60,147,27,90,82,193,36,201,173,182,188,108,188,229,45,193,211,18,253,200,185,25,95,180,93,30,219,69,195,239,222,97,161,110,214,36,114,96,168,76,77,164,53,131,226,197,100,0,42,106,159,84,214,55,249,124,216,170,102,155,118,134,77,181,65,115,14,167,123,89,46,212,228,181,29,222,148,86,228,253,74,236,231,197,148,188,137,167,27,127,12,253,186,84,67,146,211,91,131,122,218,230,239,254,175,168,1,213,249,121,7,221,136,146,201,36,166,47,73,221,190,128,205,126,206,89,121,78,233,57,64,136,20,67,198,178,249,191,17,131,33,149,197,130,104,170,130,142,237,246,170,147,192,156,248,187,123,25,225,139,220,171,61,24,24,114,110,77,3,160,244,82,56,94,113,16,27,118,228,217,56,29,253,10,75,145,97,193,150,89,210,52,60,146,17,127,187,216,5,195,108,15,251,39,157,158,86,49,193,199,155,106,6,73,80,247,203,61,88,81,56,93,158,179,40,245,81,68,136,69,32,237,101,122,112,165,100,55,9,127,59,26,9,41,16,102,92,246,179,125,108,231,225,63,120,88,135,69,195,239,197,51,245,72,72,59,15,231,42,3,184,123,64,176,64,2,15,246,220,67,193,252,8,159,56,20,44,137,45,172,109,183,204,159,101,6,17,221,228,44,160,69,242,153,202,128,203,12,4,126,92,35,50,234,50,118,36,235,41,31,25,142,113,24,62,9,95,20,19,50,125,158,204,53,186,86,53,189,102,153,228,219,22,2,99,14,143,147,221,199,23,113,107,196,224,225,104,121,99,34,19,112,121,28,191,160,245,10,17,84,184,88,225,151,167,54,240,195,72,254,120,18,22,155,131,146,29,227,234,30,101,250,135,69,125,243,191,220,108,252,27,73,15,229,136,53,207,18,173,204,19,205,199,182,167,225,33,249,143,99,91,17,55,149,227,252,128,238,114,212,169,242,145,36,176,68,219,87,139,157,11,63,61,59,211,206,153,189,127,223,109,58,97,39,141,146,29,253,92,94,80,25,18,106,154,118,230,19,134,225,160,83,60,150,40,14,114,137,33,215,197,110,48,190,240,56,91,138,248,129,37,247,39,83,175,2,103,194,229,110,102,216,12,120,6,3,226,163,55,78,249,252,111,226,91,6,137,148,130,47,48,247,229,23,243,182,71,150,137,124,20,124,66,139,32,193,148,161,185,236,79,174,99,200,112,53,55,117,29,34,237,204,153,30,100,212,1,178,63,101,108,21,60,226,164,189,178,191,164,14,130,253,211,82,162,209,199,23,248,243,208,248,249,158,141,215,199,86,0,246,74,146,131,115,160,41,65,31,203,224,248,194,77,33,67,47,171,200,140,46,76,21,188,172,177,183,243,246,224,185,32,56,122,180,233,201,25,233,15,85,45,133,25,16,136,35,136,145,142,15,86,80,133,48,119,224,178,65,40,193,213,90,108,89,160,56,151,217,217,57,103,175,63,242,81,89,154,80,29,72,39,62,162,124,64,207,184,236,170,24,70,121,44,61,235,14,3,108,68,201,57,178,69,188,58,91,211,235,251,154,69,34,123,86,213,66,253,253,216,176,67,99,197,91,185,250,198,244,215,134,106,130,27,155,101,61,23,181,173,83,247,184,185,24,221,87,94,129,150,24,83,250,180,99,14,23,157,95,133,189,98,219,252,120,118,181,213,41,131,138,220,245,32,75,155,209,55,31,197,21,188,175,14,108,96,144,219,70,87,169,105,80,215,39,54,253,164,135,220,113,179,11,26,86,90,17,173,82,168,51,234,219,159,197,190,211,12,96,163,96,156,21,216,237,81,71,8,238,177,222,65,238,18,207,224,198,6,78,77,58,229,128,113,49,80,53,64,60,188,235,183,243,253,19,186,159,48,179,25,11,199,176,100,249,48,94,85,170,164,215,111,157,248,47,235,115,199,148,241,90,5,156,158,194,36,48,2,128,54,251,107,121,73,162,149,9,148,65,58,167,164,203,170,52,197,196,44,120,167,22,204,41,135,101,200,149,248,38,73,57,71,205,69,158,255,72,185,219,30,199,49,162,53,242,190,45,142,206,11,94,30,40,120,221,10,171,209,31,64,30,69,102,138,222,180,169,4,28,97,34,15,174,50,15,217,31,255,141,56,24,233,173,156,216,252,142,255,94,59,43,223,147,253,34,44,189,10,93,55,252,67,27,40,123,12,243,5,33,140,234,16,240,115,171,26,131,179,201,114,216,135,196,14,204,11,226,91,159,139,238,182,65,152,10,212,173,146,189,31,16,197,251,214,140,176,101,41,217,127,19,65,118,112,116,119,159,28,52,102,175,254,92,132,73,106,70,124,121,229,34,136,208,230,102,14,165,73,4,170,233,83,76,138,148,54,152,21,227,68,40,188,180,162,79,72,48,228,26,205,64,66,33,171,221,163,170,114,114,184,172,219,201,168,200,24,77,52,12,80,226,95,105,205,101,189,221,3,5,202,38,226,148,208,76,126,116,245,120,125,186,56,187,96,82,46,133,211,10,66,86,187,156,137,23,160,98,171,226,232,11,114,200,18,250,211,87,122,21,93,163,90,104,194,160,53,194,74,207,94,195,91,24,76,184,136,174,136,22,245,12,54,167,76,106,249,48,251,40,188,97,95,223,30,22,142,194,231,189,143,57,151,51,105,150,197,223,211,167,34,90,118,91,128,229,236,240,185,96,234,208,26,179,111,122,244,232,80,12,38,10,75,30,38,189,236,165,19,26,106,197,252,71,235,185,204,73,177,213,143,142,148,0,198,150,67,125,250,112,233,80,164,49,60,6,157,40,93,68,163,97,177,11,138,69,11,80,35,151,37,226,112,83,104,68,199,208,112,120,18,122,5,174,225,120,249,246,187,239,139,207,193,43,156,214,226,0,98,218,49,189,224,164,249,146,98,223,125,50,17,156,249,81,199,227,5,93,233,167,93,238,114,241,192,104,44,145,2,60,79,168,0,112,62,78,120,31,150,105,225,33,243,194,10,247,239,80,186,67,248,147,112,190,206,149,49,185,35,4,129,193,254,128,152,100,164,105,79,44,168,54,203,1,129,230,43,92,174,4,56,200,148,20,82,211,212,136,193,83,214,240,81,138,39,11,132,114,55,99,194,4,143,40,233,177,238,255,46,166,183,5,115,190,182,171,253,136,6,248,32,219,26,252,55,109,189,224,176,219,6,131,136,170,148,101,102,58,242,121,97,120,125,146,126,232,251,70,200,193,191,199,169,112,172,43,218,147,205,17,215,99,9,141,194,206,149,104,71,115,45,250,190,121,28,115,88,81,131,250,172,238,160,98,146,119,165,113,166,10,172,34,174,43,44,119,114,32,110,169,188,210,22,181,71,3,8,218,196,202,103,105,234,72,209,168,202,3,206,120,58,52,91,169,202,207,73,67,52,223,246,40,85,129,186,17,147,193,231,46,110,139,178,74,210,186,252,20,42,212,66,107,31,239,184,60,105,247,138,212,29,59,35,147,239,109,123,57,144,11,149,66,71,134,57,20,223,47,197,51,83,184,140,102,217,213,245,43,232,173,139,129,135,141,23,147,64,170,6,101,154,52,47,242,34,140,3,101,199,41,95,122,146,104,251,210,114,60,120,85,93,235,23,132,185,200,46,225,58,185,30,23,139,234,67,231,176,36,70,216,129,111,57,23,74,254,117,89,199,41,209,178,61,214,211,184,105,167,86,249,49,90,42,123,168,58,104,222,200,67,41,108,0,17,167,116,177,110,201,116,233,182,36,97,100,6,194,14,109,98,123,229,192,135,60,139,212,178,229,24,178,75,57,129,64,124,38,73,23,182,0,233,69,40,62,242,69,133,151,96,88,46,115,166,144,227,171,12,67,150,150,224,205,128,11,68,98,7,65,199,98,217,18,163,103,246,75,237,111,191,192,188,237,204,240,118,109,98,193,54,170,132,185,37,96,110,213,152,18,190,35,50,82,137,93,149,215,225,221,42,90,5,238,158,171,51,61,216,167,102,11,175,66,32,95,200,136,58,38,185,31,31,7,154,137,77,199,135,129,68,11,138,218,56,51,63,138,232,178,118,35,168,128,222,75,254,4,133,240,20,138,225,42,242,179,147,238,252,236,171,207,216,158,161,187,121,28,211,191,97,168,90,83,211,109,149,65,124,180,9,172,11,247,233,144,178,35,236,201,59,110,14,121,70,14,224,61,254,78,212,28,174,65,117,240,197,140,63,81,231,180,236,142,119,35,45,55,146,227,92,243,89,103,227,113,113,7,241,196,218,216,222,133,210,176,201,227,29,129,190,164,242,224,9,230,82,122,179,114,75,246,39,15,229,149,39,223,54,20,209,236,251,52,201,186,78,73,37,151,126,3,228,78,186,96,42,131,8,164,251,31,66,192,181,12,97,55,186,77,32,219,199,151,33,3,42,85,29,142,29,6,107,115,68,114,214,114,140,199,143,20,245,129,9,78,83,246,169,65,41,122,99,69,204,115,173,8,254,95,66,163,162,48,175,244,113,209,100,147,112,188,220,233,113,5,212,201,138,91,38,191,72,7,99,178,116,234,92,48,244,0,211,154,27,247,206,232,89,85,99,233,132,72,85,200,139,238,153,179,24,123,99,134,246,142,188,239,9,157,112,162,234,185,118,245,59,130,224,204,31,163,171,38,159,221,225,99,216,177,58,35,104,109,10,125,89,23,53,56,37,68,165,189,60,83,249,63,161,240,70,141,1,210,143,125,157,56,227,11,24,55,38,168,16,119,213,155,223,143,131,175,37,234,125,238,16,194,101,201,158,4,110,18,210,221,84,87,14,13,169,250,241,240,1,12,205,98,246,198,75,250,239,249,104,97,127,57,19,15,104,126,28,59,196,119,32,32,82,17,212,81,175,226,118,175,241,105,177,135,71,82,187,16,240,159,71,37,41,230,115,64,156,184,169,24,234,219,0,246,117,253,167,73,143,69,3,130,245,116,43,177,166,154,119,212,153,47,46,26,192,155,252,200,241,110,201,195,252,231,181,147,45,221,62,85,89,150,72,79,230,174,245,52,49,209,202,184,143,160,9,190,63,249,33,193,163,53,123,237,31,46,225,42,225,49,158,14,120,71,133,247,37,52,27,195,168,0,173,254,175,48,203,127,136,142,20,140,58,102,224,52,13,72,195,143,146,84,91,160,228,92,126,63,39,81,150,207,232,13,28,22,22,113,169,45,140,23,5,46,155,127,197,116,25,54,226,104,89,169,95,100,83,211,41,119,115,107,60,190,170,12,213,173,189,220,228,10,211,105,116,245,166,208,229,181,165,201,68,170,57,36,97,78,110,76,75,65,230,77,138,17,146,196,148,196,16,237,121,105,24,158,75,121,236,185,205,129,31,100,68,181,179,248,183,65,29,74,96,126,223,176,27,19,62,148,147,12,48,70,173,22,7,123,162,216,137,16,123,171,81,196,100,84,138,92,119,3,209,28,49,46,184,35,78,201,26,213,233,176,139,204,161,161,100,134,151,46,27,220,236,243,154,104,171,179,29,24,244,219,213,4,109,217,17,167,110,219,11,225,255,47,80,164,122,91,85,104,133,179,78,39,122,132,12,176,53,220,175,184,93,42,5,93,129,217,176,225,1,179,77,53,121,239,203,231,143,218,94,107,129,31,11,195,254,148,78,105,60,149,153,223,20,120,153,7,211,141,71,154,236,170,254,85,202,104,196,108,18,145,215,252,129,244,163,252,137,151,112,146,157,1,59,187,240,13,15,2,216,118,65,35,126,38,27,221,174,235,245,160,106,120,196,95,105,214,48,54,136,226,74,65,88,37,3,224,245,60,140,2,150,249,134,212,251,59,123,169,14,76,79,118,67,227,62,202,182,40,50,114,7,24,44,54,254,33,251,230,193,198,191,167,178,228,71,214,100,187,93,9,99,58,230,102,178,170,160,39,178,130,14,57,7,70,171,249,174,14,35,35,120,237,233,152,182,162,97,118,134,142,150,24,7,159,154,144,20,178,175,155,125,114,58,253,140,118,189,3,236,201,17,137,170,158,6,138,214,209,52,137,203,102,157,11,99,113,92,97,55,117,153,111,20,219,251,13,105,77,46,143,89,53,195,147,116,53,124,195,182,95,154,49,226,94,206,124,56,128,210,109,131,196,167,229,110,5,138,241,184,84,170,48,209,20,77,49,194,144,208,224,23,8,82,52,152,83,235,136,168,48,59,7,125,42,229,139,89,170,227,83,9,67,233,174,188,101,17,74,229,208,35,149,23,105,183,73,116,1,80,193,46,164,25,242,129,1,17,88,87,87,94,55,96,126,151,60,35,202,219,9,3,222,161,131,34,149,198,202,198,131,167,91,75,106,85,22,230,193,8,201,156,81,226,164,111,44,147,161,162,209,240,123,26,148,30,161,104,16,29,236,170,204,149,74,126,34,109,24,139,125,1,32,228,137,89,30,201,147,146,189,177,123,185,72,228,107,91,49,121,163,27,243,72,155,29,183,58,67,212,196,210,201,58,31,102,67,158,141,70,175,80,213,3,99,198,124,34,110,94,209,77,20,85,45,162,82,18,61,189,203,199,56,131,228,230,7,53,226,247,217,35,66,115,37,68,130,210,200,156,186,44,33,11,229,31,84,159,92,194,52,14,158,187,179,106,80,194,179,80,226,202,110,147,204,167,44,63,158,49,55,80,115,164,46,156,244,58,137,134,55,253,220,75,9,103,136,249,242,3,215,220,53,123,17,75,112,40,131,105,76,0,16,17,245,242,195,47,165,106,200,206,26,130,189,65,203,2,99,181,5,143,191,100,128,52,249,154,169,127,159,85,163,175,105,201,79,170,124,33,172,15,229,166,146,194,104,108,129,91,132,33,195,224,4,116,61,113,89,52,79,251,121,2,32,71,98,121,115,214,245,87,160,16,97,250,177,149,55,39,223,212,203,76,231,248,127,176,129,187,75,9,209,101,237,148,65,111,200,193,164,44,66,237,159,220,85,84,91,89,208,128,237,151,180,31,151,237,151,16,114,221,155,43,42,4,83,34,238,79,149,66,231,157,222,132,11,145,104,170,56,236,84,248,183,36,85,4,10,143,170,141,177,87,7,163,114,225,72,248,238,122,146,203,203,157,4,155,198,245,193,60,218,180,175,34,89,80,195,35,71,85,234,238,86,77,49,244,128,157,230,211,30,114,38,88,35,242,190,254,27,132,194,18,236,121,228,133,95,97,44,236,154,28,64,235,14,62,141,6,104,2,239,196,0,239,190,200,189,55,225,88,118,166,28,3,155,39,73,135,166,250,86,28,103,243,78,21,135,177,206,135,183,141,13,148,181,253,155,176,98,53,113,191,110,156,23,111,210,0,12,145,6,255,146,80,247,0,74,171,33,213,96,90,118,193,89,208,79,47,247,61,246,11,199,235,65,231,27,63,41,110,254,129,80,132,0,167,84,59,171,175,164,131,185,207,179,36,207,187,236,180,205,188,150,112,119,170,82,180,155,78,6,33,163,196,74,97,85,204,95,48,248,81,22,74,219,228,3,163,28,111,155,134,69,37,9,187,242,25,75,186,8,17,151,196,130,59,118,14,82,207,194,129,82,65,199,147,72,96,117,243,22,125,145,219,206,184,153,41,144,219,98,96,155,34,94,181,44,163,237,168,33,89,151,218,192,247,57,198,126,236,197,141,63,109,159,157,29,83,185,46,181,8,73,42,95,252,161,116,224,219,172,169,119,219,52,46,170,69,178,172,93,174,0,45,81,139,114,181,102,240,100,159,66,137,156,200,175,244,173,51,117,206,244,24,77,6,23,82,12,37,118,160,225,85,183,69,79,100,126,129,93,155,18,95,145,39,32,118,241,90,236,152,14,20,126,31,234,84,34,120,172,90,243,50,162,34,238,83,91,24,255,99,225,240,27,114,166,100,243,207,98,170,111,107,224,19,79,177,203,231,135,126,205,13,231,108,153,215,16,143,6,18,244,71,18,188,143,224,169,189,54,129,185,202,121,10,142,246,219,251,81,92,184,115,207,55,223,23,9,172,6,80,2,236,96,4,51,62,54,135,46,10,0,229,235,188,235,218,127,115,177,136,157,40,2,71,146,32,245,200,137,190,179,220,117,208,242,197,14,183,79,124,35,171,203,89,139,208,30,50,32,249,148,242,236,98,48,88,255,143,25,1,235,159,210,127,229,219,6,20,19,41,23,220,116,32,214,217,7,197,244,101,247,93,18,117,151,140,84,68,104,42,232,36,226,57,55,57,181,128,52,6,203,130,54,199,103,197,158,184,138,127,61,223,65,111,57,25,181,72,139,155,65,139,48,15,128,95,194,241,163,12,246,39,191,53,212,114,194,90,65,109,13,121,48,171,160,68,35,192,251,149,193,182,207,178,158,107,32,192,59,214,166,145,205,76,194,17,236,248,105,195,184,201,91,214,106,71,163,206,253,189,15,166,160,158,55,182,108,213,82,244,47,221,194,227,48,139,93,104,165,186,46,214,47,63,142,36,158,192,116,253,133,77,50,45,85,208,33,203,120,156,6,55,217,53,210,131,30,194,170,65,32,80,32,81,218,104,125,77,236,131,42,23,51,41,208,230,40,175,127,201,126,254,209,89,221,187,181,101,185,235,139,217,248,49,187,232,192,124,28,52,88,70,236,155,38,60,43,157,178,180,45,203,113,4,9,67,86,60,136,52,5,61,152,126,254,205,152,68,61,64,58,226,75,218,19,204,177,16,138,148,243,180,234,110,6,134,194,139,167,50,151,95,62,160,137,209,208,255,81,199,177,240,114,1,163,160,235,235,172,203,57,245,240,94,121,56,11,132,16,23,152,180,38,90,26,107,103,77,223,70,133,160,220,55,161,159,238,135,127,195,39,208,86,53,94,195,241,255,207,90,238,9,252,64,51,154,107,238,114,42,193,58,242,19,108,172,209,86,71,42,197,80,100,152,114,254,57,174,37,64,50,36,160,251,173,106,84,18,16,170,209,101,166,151,240,142,96,134,97,50,207,93,244,231,22,49,72,181,188,188,85,53,41,160,158,84,157,23,30,169,226,115,33,73,115,107,143,0,226,138,147,191,74,190,144,231,29,158,45,154,232,182,228,53,105,112,118,75,176,179,123,111,233,14,139,90,157,138,223,14,191,88,106,91,191,149,119,119,125,12,238,211,244,188,43,214,146,153,165,147,172,221,81,131,160,19,124,234,236,188,144,176,73,96,127,208,169,247,17,186,160,163,61,186,59,233,72,217,58,90,43,43,23,250,105,188,236,66,19,98,125,250,90,130,162,167,174,46,218,37,184,26,92,237,34,0,26,104,74,167,221,23,105,113,9,187,125,231,185,93,92,121,93,23,185,54,19,90,235,249,3,121,58,43,88,53,140,51,45,206,210,228,223,67,147,216,82,11,167,178,164,218,132,152,116,134,84,112,15,165,106,15,116,46,222,118,186,76,133,157,255,99,27,35,96,230,14,223,36,164,244,30,234,71,169,225,124,239,103,239,185,44,71,223,241,177,16,211,173,64,220,127,244,65,244,249,195,214,90,121,43,248,177,241,128,96,74,224,104,16,53,79,225,14,219,175,78,129,103,35,184,131,156,66,49,75,196,237,145,109,124,157,74,188,157,84,32,153,170,210,235,165,6,155,60,118,114,50,169,40,37,1,220,122,220,107,20,39,19,238,244,128,227,140,103,0,179,250,11,140,38,165,57,63,111,193,84,165,175,223,21,24,232,153,190,211,114,99,96,103,146,32,24,107,66,117,93,27,243,49,114,246,219,30,34,20,17,69,183,243,131,101,22,123,146,89,58,14,130,29,141,36,211,54,162,164,189,208,207,2,157,64,29,178,133,166,206,71,226,123,104,195,207,127,14,140,247,187,212,124,199,222,83,46,134,206,111,75,190,63,73,82,47,139,200,197,11,130,44,168,239,104,124,162,31,115,106,15,77,72,8,188,215,102,185,145,177,146,105,215,243,128,236,120,202,35,200,18,3,56,41,51,228,233,136,75,253,209,15,226,133,173,67,184,30,89,158,18,91,156,153,18,111,152,178,1,79,85,158,151,216,76,58,134,155,146,49,89,17,51,188,208,128,156,11,43,131,131,106,12,149,63,166,121,16,63,219,137,51,65,222,5,172,189,253,110,113,53,167,226,44,245,31,50,38,174,100,68,22,13,112,212,36,155,239,195,60,53,18,123,223,198,86,22,195,153,183,238,240,84,186,32,5,221,42,82,204,140,146,40,142,221,64,66,150,70,55,47,30,39,14,91,230,39,190,250,204,44,92,192,48,150,46,192,2,42,75,126,145,237,31,191,38,153,131,36,227,179,79,231,201,9,204,104,33,64,247,81,36,153,134,244,72,253,218,167,247,131,248,178,75,238,207,226,79,244,209,92,176,76,70,26,233,159,72,80,240,245,86,236,211,60,129,147,52,202,224,10,121,136,140,72,97,73,10,133,96,120,170,207,50,34,150,192,32,223,232,196,218,17,88,13,218,31,177,119,20,156,206,58,133,152,213,248,174,186,249,107,70,175,113,37,10,115,145,51,107,100,20,219,82,204,77,140,219,219,169,215,58,48,94,235,31,79,145,66,12,48,214,3,229,197,44,184,188,88,27,187,162,100,106,211,186,207,12,7,55,129,174,102,0,79,203,232,178,166,41,96,67,20,205,236,10,17,185,214,114,166,94,180,205,186,114,55,253,184,106,217,46,50,15,196,129,214,56,81,178,117,165,228,136,107,226,194,252,239,232,52,189,121,119,33,227,225,214,234,74,40,173,225,105,36,9,32,65,235,127,209,218,119,230,246,90,85,92,208,117,25,145,241,125,158,150,196,130,194,200,251,49,170,85,124,87,213,239,96,184,96,197,63,244,187,217,215,49,3,224,114,164,10,22,251,65,108,238,13,29,254,18,139,129,219,58,169,151,73,96,64,221,26,16,12,14,12,78,9,203,11,80,73,221,118,103,173,1,169,193,215,109,126,166,137,12,12,135,17,81,209,32,12,131,60,0,153,66,201,121,182,155,39,109,173,1,186,45,253,219,88,63,179,91,22,106,108,66,107,17,105,97,59,6,133,136,82,129,125,190,184,234,131,23,198,146,94,243,204,25,190,50,160,81,176,220,38,215,41,120,112,38,74,163,171,24,106,116,214,231,194,77,99,71,195,47,141,134,111,103,119,122,241,34,5,170,123,150,232,85,63,156,112,76,202,78,176,136,79,161,164,245,223,119,235,27,8,99,121,57,0,225,90,143,129,173,209,102,133,158,64,233,181,113,212,237,35,132,15,88,36,85,226,152,217,11,16,251,213,25,7,85,125,48,155,221,141,133,205,66,237,6,5,241,72,247,133,199,177,78,236,71,27,110,205,207,241,40,22,141,156,101,179,172,227,30,248,161,147,84,177,176,26,32,103,36,110,30,67,137,223,121,255,110,247,94,76,30,149,83,111,96,72,165,93,200,58,207,176,213,13,29,75,187,45,112,179,43,234,213,242,216,43,249,33,207,40,167,96,46,219,167,44,111,57,183,96,243,201,5,215,73,106,130,134,7,142,153,17,97,126,88,35,57,154,246,15,16,48,120,187,131,106,242,11,250,99,54,230,135,88,172,62,208,30,127,145,236,44,247,246,202,229,174,206,139,144,172,167,141,73,106,163,33,202,57,80,76,67,219,18,99,153,119,22,223,8,132,90,173,119,88,241,34,158,228,149,129,248,73,110,153,176,170,26,33,117,151,227,204,107,181,26,21,245,164,236,219,77,199,199,35,205,68,49,148,238,100,242,214,99,155,100,23,181,56,99,13,119,225,107,153,143,182,246,225,208,95,196,75,114,87,98,134,84,115,210,91,16,159,38,83,255,6,141,147,176,178,28,7,98,154,157,117,22,186,222,203,229,195,97,78,111,21,1,209,7,216,220,49,206,103,113,12,92,248,125,213,205,208,125,25,23,255,131,122,18,244,102,110,19,246,57,97,29,160,122,12,249,191,178,249,218,202,196,118,95,227,2,202,72,253,166,224,126,142,247,255,235,17,182,40,239,72,49,69,198,190,146,45,197,143,72,232,60,106,114,24,207,64,199,21,148,63,154,255,94,65,161,221,130,35,137,115,115,180,84,241,144,61,126,156,106,22,242,150,187,185,206,193,114,109,233,188,162,195,80,84,37,148,76,38,233,82,107,55,196,65,244,142,66,169,247,79,119,3,176,143,31,254,163,250,36,254,95,244,199,37,243,80,12,199,218,35,41,133,113,33,14,19,65,68,109,255,12,46,255,36,190,184,245,158,28,243,54,230,255,252,10,28,140,185,137,52,36,177,174,246,253,228,33,46,4,171,48,142,104,247,44,43,68,29,108,218,170,183,172,241,193,73,207,219,37,138,1,150,130,219,251,45,165,77,163,56,41,211,48,28,136,245,232,57,137,129,92,21,128,45,154,238,208,32,231,214,120,74,179,72,201,37,186,206,84,50,7,123,49,12,239,253,65,164,149,178,102,109,53,34,240,96,200,137,6,135,145,49,172,151,73,182,67,200,127,30,211,36,85,185,165,56,97,54,221,209,90,70,22,143,152,129,15,204,59,5,143,171,180,132,244,145,20,44,11,142,181,72,223,151,147,26,241,164,157,222,7,97,79,43,35,103,66,163,25,155,118,174,109,181,98,111,56,136,55,63,81,51,89,250,61,148,153,110,132,172,218,99,18,104,242,83,175,53,197,209,126,182,44,53,73,229,104,21,252,214,227,27,176,170,31,200,156,251,40,253,90,104,145,10,1,175,235,135,77,56,137,11,51,99,233,59,250,122,62,196,2,245,142,86,59,143,192,123,130,214,245,182,157,134,228,82,199,243,29,167,83,105,75,4,236,116,174,50,18,89,242,200,87,109,23,221,184,42,3,82,80,103,135,218,190,7,129,98,180,64,149,196,181,217,136,28,58,56,53,14,16,248,30,82,197,85,149,53,2,112,81,243,53,131,126,174,187,3,237,209,3,20,9,246,22,3,194,201,118,169,89,116,66,199,66,16,175,193,47,238,65,137,126,87,148,144,167,191,216,137,23,120,162,24,80,68,168,161,148,167,6,137,56,1,160,59,75,181,56,92,175,90,233,7,212,173,52,242,167,91,64,194,196,220,18,71,186,221,224,84,47,76,156,55,190,180,102,18,21,27,55,125,249,219,154,48,54,210,58,72,73,154,78,48,73,105,233,200,178,230,208,130,172,18,160,79,130,20,166,83,203,232,203,108,136,211,228,152,192,103,222,8,46,245,50,29,25,234,254,228,47,202,93,242,41,33,139,115,212,186,141,90,222,177,4};

// The scrambling tile of 128x128 pixels.
// Each pixel contains an optimized 8d key used to scramble the sequence.
// The keys are optimized for 64spp in 8d.
static const int scramblingTile[128*128*8] = {194,116,144,33,145,166,117,83,205,129,3,34,203,142,154,237,239,3,114,13,119,93,117,208,63,128,231,42,199,8,205,128,59,100,210,181,25,62,197,185,176,72,107,140,62,55,184,2,223,65,107,25,50,153,173,37,104,152,174,145,51,80,202,73,157,124,76,50,145,14,200,104,109,191,1,179,11,31,186,198,104,129,223,50,162,234,168,244,180,250,170,74,50,59,161,34,170,246,242,215,225,139,27,215,25,12,153,2,190,60,138,11,14,106,223,6,215,202,231,124,102,37,142,13,189,31,133,83,101,19,95,241,168,227,42,112,134,32,226,65,220,45,69,168,127,82,115,114,105,48,109,11,241,97,181,251,88,44,218,160,164,155,90,193,75,35,82,1,250,196,53,112,173,42,71,203,74,241,20,157,46,144,1,24,245,78,149,216,94,91,110,226,244,2,129,215,74,147,44,21,37,29,75,244,119,136,119,141,44,77,81,241,93,149,64,192,34,80,43,222,67,92,66,220,50,11,83,115,237,141,183,211,136,89,134,115,248,70,132,222,231,83,86,228,11,153,176,91,104,73,236,250,208,87,126,3,165,242,71,0,152,88,197,208,111,134,82,219,37,67,13,91,211,210,16,29,241,16,43,77,131,22,242,46,84,213,74,192,112,91,250,194,14,36,113,198,59,162,34,156,226,23,64,20,101,182,172,75,18,43,247,185,107,136,17,36,152,159,213,214,107,18,136,225,186,120,244,103,247,113,215,129,75,38,7,142,75,112,89,109,94,3,151,117,60,66,91,243,250,127,161,102,163,218,225,144,204,219,16,189,38,235,232,24,200,110,179,66,113,132,129,184,209,186,36,32,19,37,73,30,99,177,221,104,38,126,100,201,104,225,18,53,132,52,93,255,32,7,53,35,128,255,87,207,40,161,30,32,71,110,97,133,159,182,7,132,11,251,86,217,160,215,29,176,79,255,253,1,58,70,43,206,127,241,20,241,215,125,54,238,222,214,101,202,4,59,7,245,155,5,209,144,248,217,185,225,230,53,56,90,162,44,78,100,113,218,140,176,190,251,36,182,32,38,193,222,248,10,232,173,57,43,107,89,52,4,108,53,58,60,169,86,243,185,131,109,187,214,176,1,65,200,45,94,241,34,183,17,144,224,131,30,38,22,57,104,57,4,185,3,35,226,28,1,173,207,55,9,247,76,208,67,9,222,103,56,213,178,201,69,101,216,108,64,130,174,132,113,209,42,154,234,132,95,47,17,209,217,217,242,147,73,130,3,73,24,97,129,187,191,160,20,73,43,84,148,16,84,4,56,151,71,69,60,143,3,86,126,13,132,100,47,138,199,162,28,251,172,229,226,92,244,253,13,222,172,11,223,199,59,169,72,212,1,74,170,218,80,221,108,82,154,157,255,149,197,202,131,189,105,21,48,238,174,138,133,200,166,145,205,16,155,26,168,205,23,69,226,155,242,122,172,250,4,239,100,187,40,43,125,179,252,196,107,105,76,209,23,140,211,222,48,131,11,229,153,220,20,159,39,24,171,124,249,46,17,34,15,86,200,53,163,223,195,135,3,72,47,165,45,207,0,181,132,63,180,26,115,34,139,53,63,30,234,97,223,85,48,35,150,12,76,79,176,171,140,160,135,101,126,57,120,167,145,153,77,4,95,236,94,222,186,219,138,34,223,215,176,46,11,48,142,47,233,249,48,147,233,63,184,139,82,182,72,102,106,37,112,0,145,145,134,163,245,137,76,181,199,243,202,168,183,187,89,70,152,203,216,32,240,242,221,65,183,96,202,186,53,236,187,17,25,183,129,236,100,217,181,99,241,155,97,1,190,64,104,205,48,177,141,2,1,96,111,200,27,47,34,114,44,37,212,177,25,43,8,134,176,173,11,113,0,44,24,194,179,17,124,118,46,34,236,223,110,2,75,108,39,176,4,103,157,183,154,198,11,112,196,97,219,1,196,107,51,148,164,199,204,4,96,135,171,203,242,93,139,34,102,185,163,24,10,90,48,176,233,175,176,57,217,69,240,42,92,98,176,73,0,71,121,150,236,182,221,92,224,118,230,243,82,179,151,76,54,120,36,204,204,31,177,4,138,225,129,245,211,90,169,85,214,121,78,125,46,101,78,234,56,49,148,108,204,50,90,201,3,56,32,144,89,247,226,56,0,0,71,107,90,117,107,201,102,131,186,191,73,77,145,205,39,137,13,253,178,10,134,143,32,144,94,180,121,56,124,20,137,92,81,136,119,218,115,0,219,191,77,103,185,17,135,113,218,208,50,150,255,199,47,91,148,180,90,51,58,28,0,122,254,164,188,15,100,124,204,37,57,40,130,105,24,248,8,36,121,104,168,122,237,199,185,51,214,99,189,98,209,104,236,45,67,50,147,138,19,178,35,71,8,34,152,242,185,76,30,52,194,26,142,148,187,207,84,103,49,118,106,137,153,111,90,37,207,144,72,81,240,188,137,151,130,64,203,130,194,81,117,229,68,129,5,179,215,75,250,240,239,87,60,71,18,143,167,20,36,255,182,191,18,18,47,178,236,196,56,237,79,4,62,184,194,150,4,209,60,196,39,33,219,86,229,185,69,232,234,99,216,212,99,26,32,180,121,233,152,104,77,205,12,167,137,62,143,70,235,236,2,173,182,61,239,1,239,43,32,162,160,63,30,177,33,93,124,65,18,51,195,24,16,254,51,113,86,106,220,31,87,244,5,34,124,182,167,118,211,109,175,218,121,144,184,236,211,105,56,50,3,115,217,181,227,70,237,31,8,253,27,28,13,230,172,51,82,99,168,115,74,76,254,41,92,116,71,108,111,135,132,205,101,241,169,107,154,167,148,212,163,131,91,101,204,75,89,110,186,234,171,13,201,123,33,251,94,76,63,252,154,188,121,151,180,86,238,56,183,217,231,115,154,188,40,74,3,206,223,212,32,184,15,60,108,167,198,44,179,144,232,79,107,254,8,117,172,65,148,78,32,216,168,87,160,121,74,188,119,76,217,67,119,147,7,6,57,230,94,86,123,156,53,29,46,251,80,115,225,79,253,184,196,93,111,123,116,69,27,137,223,113,98,216,114,18,185,197,97,208,134,185,48,49,151,169,133,63,174,87,229,89,176,241,27,14,79,41,211,224,52,69,162,38,92,37,85,239,253,86,160,171,188,208,228,156,56,134,212,153,168,146,250,135,61,201,3,70,84,41,174,246,66,154,217,57,60,131,155,156,122,40,203,5,230,123,254,55,41,35,162,121,3,218,130,250,41,48,87,127,97,22,137,252,94,230,252,78,112,144,187,9,251,18,50,10,193,72,22,115,140,191,41,155,230,155,55,140,128,95,40,33,150,114,52,116,42,75,249,74,71,125,238,19,47,181,160,242,134,13,214,46,156,37,109,83,35,36,58,131,131,33,36,188,124,35,201,154,211,84,216,53,99,221,123,6,131,7,55,11,226,13,37,68,40,188,228,1,198,214,215,117,181,21,40,69,37,33,88,41,184,61,150,66,236,83,17,56,182,65,56,110,8,142,199,46,176,221,107,117,110,208,246,38,98,109,151,17,224,154,71,160,75,69,138,29,246,12,45,34,86,211,177,30,196,202,119,43,113,102,24,160,201,78,35,12,255,116,2,164,253,14,31,166,38,249,31,144,174,217,40,181,89,248,59,151,131,93,48,178,253,122,91,75,6,195,95,59,176,168,114,94,108,145,29,197,191,112,236,71,160,147,34,209,128,77,183,98,161,15,149,238,165,181,211,40,160,219,242,233,67,234,223,82,216,243,155,215,128,125,117,34,187,234,130,159,84,147,229,40,134,225,1,49,77,70,107,65,77,24,192,20,106,219,134,25,30,57,195,219,159,91,169,33,163,79,199,248,236,177,168,54,153,36,170,163,108,217,22,34,178,204,89,117,5,36,248,37,18,38,110,75,153,92,175,105,16,44,229,227,126,67,138,35,33,177,147,61,150,127,150,54,168,167,156,241,170,179,180,143,114,150,145,235,187,145,172,54,95,94,66,184,106,179,249,169,60,221,67,167,17,206,147,226,245,77,70,203,29,197,245,246,58,99,228,200,246,184,161,219,196,77,52,217,116,179,109,192,184,114,246,23,26,190,31,135,118,164,164,196,174,28,103,60,54,209,127,181,203,82,45,249,39,207,253,205,220,98,5,162,249,115,100,176,17,131,216,1,209,209,8,115,232,20,121,203,213,134,42,185,94,204,118,211,230,120,150,65,155,106,210,174,169,178,195,216,214,129,248,5,248,167,215,222,251,251,103,29,241,89,63,120,28,210,23,247,232,216,141,230,199,225,42,233,216,122,171,90,12,237,139,92,132,169,209,117,140,18,58,206,69,188,213,22,129,123,70,16,211,32,76,235,14,136,171,33,203,94,103,163,100,250,94,222,27,101,148,168,92,102,148,199,39,115,69,131,154,23,141,82,47,74,158,189,129,123,106,174,94,64,28,217,142,155,71,88,32,48,118,99,199,246,78,195,169,94,159,161,146,28,168,101,198,13,200,151,58,142,177,96,249,127,46,202,210,118,74,36,107,176,135,23,211,179,252,107,158,155,161,69,128,237,191,186,15,142,7,216,16,66,172,128,200,112,230,199,31,252,137,42,125,116,240,179,60,56,93,111,111,62,11,34,91,190,166,89,104,216,25,238,117,17,179,32,232,190,18,23,137,16,36,216,182,112,68,169,185,45,237,142,119,92,30,1,95,159,251,142,50,74,108,200,155,212,72,196,61,75,233,72,16,112,1,168,202,92,250,206,37,120,126,129,74,86,133,83,249,43,29,36,9,22,107,47,156,148,53,54,46,110,164,230,10,115,168,225,53,10,14,32,247,74,3,84,35,179,6,22,106,185,90,92,5,92,69,242,111,146,101,161,19,89,174,3,100,87,85,127,179,245,101,61,96,83,4,28,25,85,100,142,106,22,43,14,38,116,147,164,245,40,56,248,176,154,171,54,207,33,41,70,78,26,186,80,207,240,47,69,252,151,146,110,61,178,147,243,40,39,139,133,55,45,217,125,156,64,200,107,25,162,74,246,191,202,112,255,148,233,132,247,137,163,0,237,76,8,249,4,225,11,12,115,104,2,70,229,56,33,119,71,244,209,71,171,129,47,96,74,139,202,162,188,101,217,7,183,112,170,154,120,87,208,132,170,106,174,211,141,111,144,133,92,225,222,221,86,55,50,134,7,162,187,213,2,196,198,255,66,106,254,136,157,217,126,253,177,57,49,46,147,212,99,93,33,109,15,133,215,134,64,81,127,126,226,118,116,190,64,178,193,108,191,223,98,145,158,244,145,23,191,66,85,235,216,84,208,194,205,52,227,110,111,126,225,176,154,60,31,181,76,146,215,28,1,131,210,163,222,79,12,188,218,135,55,66,216,53,198,177,176,99,130,219,249,51,174,136,147,199,166,204,187,67,93,37,217,43,176,109,101,47,208,126,194,8,179,44,187,8,227,152,209,63,163,11,128,28,237,92,194,182,103,95,137,168,108,236,205,66,177,55,105,246,186,19,0,219,181,15,247,225,64,213,150,178,58,245,99,128,219,205,125,89,76,21,36,125,231,243,125,236,34,202,111,4,0,50,72,50,139,52,211,85,229,74,231,244,220,83,119,231,193,210,94,234,93,1,5,222,221,207,174,32,60,177,23,55,212,8,60,178,106,95,224,221,99,31,9,51,70,84,89,207,122,208,142,237,177,4,198,122,179,155,18,244,55,12,17,104,162,152,228,86,75,244,84,145,26,137,23,50,78,151,31,51,104,162,155,29,81,222,167,103,244,167,162,59,89,4,171,119,203,134,190,3,125,167,142,129,199,189,65,162,139,52,81,87,44,135,3,90,190,33,77,89,236,63,40,46,204,195,136,73,67,4,175,23,130,138,152,195,87,3,108,172,242,37,147,4,57,37,88,43,9,224,243,136,171,63,45,174,242,213,59,121,159,76,247,118,169,62,77,61,163,88,69,96,151,35,34,24,111,245,62,55,118,14,246,18,222,84,226,204,25,112,129,71,134,149,133,196,62,101,128,45,212,147,175,35,49,82,55,242,169,55,223,32,53,145,59,106,64,87,99,102,181,95,181,25,215,44,247,235,187,101,178,91,154,217,152,141,185,75,6,81,166,18,231,16,112,64,101,112,103,235,143,230,148,40,177,228,50,58,69,121,190,192,175,83,146,220,59,193,117,204,20,50,168,8,52,168,46,52,218,221,109,7,157,113,6,40,13,110,179,4,0,171,213,177,74,117,121,146,31,152,33,158,191,134,74,123,175,138,129,81,205,171,150,122,15,159,208,185,206,71,51,246,17,133,213,250,28,89,68,58,210,80,94,31,103,242,202,114,13,88,237,6,38,92,248,158,26,182,253,199,232,10,91,173,219,216,234,167,70,174,9,255,105,203,28,34,203,246,245,73,110,104,60,28,59,112,195,192,66,52,171,219,48,123,210,197,108,19,133,21,39,255,77,237,74,219,198,251,114,77,38,20,173,34,60,208,179,137,196,34,211,88,140,12,142,21,45,218,237,206,13,202,40,163,160,152,180,219,10,211,38,70,169,251,6,21,222,240,95,99,125,214,233,147,16,199,117,242,118,237,10,156,168,212,123,193,222,72,20,138,206,7,204,28,148,178,18,173,100,137,177,224,166,255,66,161,75,158,29,208,191,85,84,112,229,74,109,180,212,81,47,149,219,91,136,205,151,134,9,130,126,246,0,128,180,106,7,108,64,234,54,185,178,200,73,116,98,139,10,138,129,207,15,59,243,184,13,124,155,120,143,35,82,12,184,167,82,167,10,69,184,136,11,166,63,35,46,229,170,177,53,198,128,121,197,213,109,223,111,145,112,37,237,250,143,25,177,167,208,198,128,54,36,171,224,130,211,252,142,102,23,173,121,193,226,50,251,110,129,163,119,209,114,199,227,174,4,104,7,7,138,191,202,132,131,129,124,86,243,225,163,169,169,142,222,44,237,176,125,75,123,224,79,196,68,89,27,79,15,250,197,194,199,178,3,93,3,5,109,29,58,217,72,131,243,42,193,253,66,249,244,76,169,45,28,109,62,158,100,84,13,13,91,171,121,105,207,102,40,30,222,255,197,235,155,177,116,208,179,224,189,74,165,152,209,43,174,13,128,93,77,157,175,230,13,82,21,92,3,77,142,250,70,73,55,190,235,240,191,35,124,5,80,65,5,7,124,151,7,155,92,105,111,27,74,210,46,170,67,252,131,25,87,225,38,147,221,16,41,184,202,181,144,154,11,3,29,173,68,220,25,129,210,25,15,135,107,28,215,254,178,22,190,254,96,53,199,92,180,66,42,136,65,145,186,150,179,209,180,102,195,105,202,154,26,99,123,110,125,21,237,6,152,80,93,154,81,200,212,149,114,80,216,13,227,28,103,57,123,171,214,20,200,90,83,55,101,67,46,174,133,157,214,227,14,186,60,163,143,127,194,235,70,59,229,162,168,118,159,140,55,203,205,253,0,90,152,160,241,242,163,0,12,116,59,89,76,158,23,175,146,255,54,119,47,68,113,192,240,36,87,51,250,179,212,214,235,14,186,244,145,32,208,76,169,224,154,217,147,189,145,238,122,1,74,79,253,108,178,19,153,227,194,85,251,43,140,15,71,46,27,167,185,17,220,56,195,226,14,120,160,187,5,229,61,196,82,101,210,72,194,25,223,183,193,136,192,139,213,252,197,153,248,195,13,220,76,55,230,93,54,209,135,49,35,48,217,86,23,33,172,250,42,141,188,95,136,15,177,173,65,128,63,177,109,18,11,212,201,244,34,150,107,218,245,135,80,84,228,15,104,150,225,1,119,168,191,243,122,141,220,231,217,180,74,113,174,158,69,230,211,160,191,213,104,36,154,28,20,80,180,225,77,42,32,167,244,15,73,33,217,122,183,71,25,13,133,31,54,241,162,77,122,32,252,81,229,232,102,50,91,85,0,188,192,154,121,37,130,225,26,141,231,205,252,229,68,226,31,60,198,177,124,254,137,165,169,45,229,184,125,148,144,210,57,33,16,147,58,128,150,148,86,192,1,142,102,137,43,85,114,143,175,183,67,61,119,53,114,53,182,123,94,178,253,45,124,11,40,136,90,159,186,139,69,189,200,161,211,16,33,98,4,77,215,190,215,68,182,50,39,234,39,73,141,68,122,250,182,159,47,118,76,22,188,243,253,202,72,27,202,115,106,241,242,13,212,184,179,52,35,204,205,198,96,90,79,227,26,183,198,202,60,10,84,241,88,93,219,239,68,1,159,43,14,171,25,6,241,62,205,227,115,172,253,244,4,53,248,159,32,91,149,214,212,23,46,86,236,82,150,226,51,182,215,184,239,253,24,86,223,248,114,207,215,123,47,193,247,254,115,70,190,229,55,242,171,0,37,69,158,250,69,233,164,85,69,32,180,104,106,19,178,83,1,38,168,151,79,24,136,8,109,34,151,198,137,17,139,45,52,105,133,210,81,40,127,116,54,24,247,200,55,127,97,106,57,245,141,128,42,79,98,7,125,100,95,56,1,66,27,248,45,147,236,124,202,158,154,227,44,126,235,42,60,190,74,85,65,186,238,160,44,130,107,168,96,232,85,129,245,174,64,119,69,222,234,248,49,228,165,74,92,213,83,18,199,241,195,6,225,145,199,132,90,61,158,92,236,75,229,80,239,247,58,54,66,118,200,42,113,43,202,4,219,54,49,166,109,11,179,205,187,56,63,227,3,18,220,250,255,13,11,187,53,238,167,122,254,231,61,171,1,253,231,91,205,125,41,176,31,220,112,151,193,29,153,169,189,19,30,193,40,64,242,254,54,221,23,255,118,186,39,28,142,167,52,66,42,179,100,18,167,179,218,7,74,187,128,154,14,241,97,245,72,1,143,114,53,253,73,202,99,157,70,115,14,234,119,31,181,59,20,186,199,57,149,107,194,65,23,42,245,79,104,215,203,90,167,176,118,133,98,162,250,7,155,119,69,63,104,149,156,10,51,81,124,56,140,232,188,243,217,136,120,160,33,248,104,194,30,113,111,148,15,179,234,90,75,207,102,172,131,161,120,198,137,123,97,167,2,91,222,179,96,172,85,216,39,162,28,49,90,42,237,243,222,136,222,49,59,35,240,200,115,4,136,81,23,255,172,14,229,176,198,38,122,83,146,188,44,188,215,152,245,60,72,208,224,193,168,109,82,145,197,185,245,134,55,192,85,188,159,193,0,241,84,104,65,88,135,254,14,223,99,178,169,94,191,123,191,137,65,254,16,253,166,86,117,127,161,53,96,148,181,104,193,235,70,203,177,26,142,145,206,246,66,113,167,0,72,255,18,209,41,199,88,88,38,10,19,228,71,55,166,135,3,203,51,107,99,30,230,188,4,122,109,68,14,114,113,112,120,248,38,54,29,113,176,158,9,70,100,255,7,61,208,150,106,51,20,8,231,207,225,63,113,13,92,143,62,64,124,220,158,54,157,135,43,69,138,92,175,62,22,219,175,173,136,23,144,33,96,27,255,81,64,33,95,39,88,200,233,90,94,207,77,129,144,220,202,4,215,218,122,39,19,143,76,199,234,158,149,171,155,186,79,7,130,151,68,52,147,235,101,30,243,158,243,62,70,251,199,40,154,60,112,49,29,216,155,238,131,224,240,100,132,112,154,121,121,59,119,206,223,62,162,77,64,140,73,31,99,199,101,7,207,51,138,44,120,38,147,11,65,33,175,246,40,219,132,160,1,154,252,71,212,37,187,184,209,92,226,33,37,229,33,89,208,212,119,109,220,152,68,31,48,23,100,92,215,210,68,93,235,82,199,26,36,23,155,170,98,45,131,222,203,127,137,167,112,87,130,240,89,32,165,117,51,197,159,251,182,209,237,163,239,205,127,37,69,60,194,66,31,241,96,165,24,108,215,128,220,34,125,53,217,177,124,27,166,19,119,33,187,96,122,50,186,12,20,78,10,172,221,221,239,32,0,197,206,191,119,100,245,1,60,103,116,234,52,70,120,124,239,135,12,234,88,99,100,162,54,17,64,3,185,41,39,127,50,51,29,7,97,171,112,25,155,160,232,15,189,93,77,239,226,70,98,8,45,252,2,119,213,11,113,20,159,115,169,105,132,230,111,227,190,82,105,136,105,110,134,41,167,183,204,109,130,232,49,11,91,76,162,16,191,253,232,35,182,195,77,82,143,26,66,11,180,210,198,83,128,45,238,74,80,246,67,14,116,40,97,108,112,60,117,79,123,12,68,206,155,204,2,45,25,36,235,82,100,131,112,69,28,183,24,104,120,206,8,73,51,53,43,92,125,142,158,113,30,208,32,101,170,136,126,154,29,147,227,152,226,58,17,110,146,28,200,187,125,210,199,151,131,221,86,190,84,188,239,203,113,28,171,137,98,165,108,56,70,4,6,72,81,132,181,21,10,153,48,138,198,150,171,240,167,148,13,79,0,179,165,159,189,165,23,74,221,119,189,65,152,41,116,166,223,179,220,190,32,115,89,129,98,148,51,193,23,102,47,129,17,35,18,208,249,221,152,55,111,175,238,145,196,209,204,55,101,137,130,104,163,139,223,173,217,91,4,49,137,13,245,233,165,205,107,138,40,6,163,18,78,247,53,130,200,229,236,254,50,179,66,58,24,19,197,241,184,57,82,223,32,88,105,195,189,69,29,176,39,30,174,213,77,109,16,204,51,166,116,175,113,113,113,106,104,229,152,83,27,82,83,105,23,42,131,34,60,74,209,202,40,164,218,63,12,213,79,187,25,24,175,9,75,144,156,206,177,23,120,178,1,105,157,217,52,30,33,106,53,55,82,137,128,41,242,253,3,42,109,75,177,34,240,136,76,115,90,98,234,175,243,234,71,82,68,80,198,160,59,152,32,83,232,1,176,188,177,234,249,161,248,216,143,185,192,40,207,253,110,0,5,225,23,142,84,58,176,244,245,254,192,209,102,117,23,139,29,173,217,10,237,106,101,15,231,205,157,199,232,218,144,187,229,51,168,45,128,241,155,243,52,193,217,175,158,237,233,112,217,183,189,250,2,248,79,177,170,245,84,113,112,221,27,72,138,151,29,227,137,31,89,192,141,170,113,190,18,143,21,198,93,146,245,87,123,130,209,233,122,116,215,246,223,204,186,102,60,4,210,39,143,55,84,98,5,26,48,1,71,30,146,135,245,232,206,124,220,14,61,8,190,142,208,25,175,178,81,190,200,14,12,118,2,149,16,25,248,106,153,236,0,210,33,61,162,239,19,236,49,175,248,179,135,229,56,121,145,76,133,75,121,32,151,46,209,74,92,145,184,236,35,209,215,111,59,225,122,10,105,251,120,0,208,235,115,44,67,250,114,32,72,136,201,213,90,242,125,184,124,215,87,185,16,228,24,19,218,215,205,237,179,154,48,54,113,166,134,211,145,151,102,205,135,209,140,13,156,183,157,60,77,242,233,97,184,26,76,10,27,70,213,125,121,41,38,3,106,73,138,140,9,200,179,25,72,156,105,198,127,237,177,253,99,75,162,209,189,243,15,18,89,85,148,219,105,228,255,171,75,77,3,240,103,220,253,231,167,48,57,146,110,163,236,64,110,140,54,181,203,223,93,197,171,7,141,243,53,209,199,90,187,23,60,139,51,27,36,60,47,5,42,184,180,13,21,224,59,11,161,218,15,23,34,108,182,176,18,237,27,67,201,74,93,80,182,229,10,76,199,119,45,80,187,209,99,143,178,87,109,83,9,118,127,224,125,105,8,200,180,51,101,134,224,64,74,201,19,64,9,2,17,68,114,89,97,56,202,17,50,83,176,35,81,91,121,13,142,91,59,139,72,230,211,48,249,219,201,233,125,135,238,140,235,112,125,53,234,187,141,43,202,101,142,78,170,186,55,20,44,201,118,183,94,18,144,161,50,218,151,148,94,117,18,232,61,32,240,62,91,83,251,227,188,150,177,150,167,98,248,59,240,26,165,108,141,241,199,51,173,145,231,32,123,74,124,222,162,160,37,237,133,27,98,51,161,12,224,150,168,218,96,116,248,185,122,99,162,6,86,11,45,185,38,99,251,0,131,78,180,83,48,80,88,11,222,32,111,206,115,232,174,34,206,54,156,16,22,38,184,18,101,152,76,126,160,89,247,3,220,110,233,94,42,40,129,200,89,9,97,127,29,128,21,35,178,52,57,190,230,128,72,165,3,37,112,42,225,144,134,32,22,238,116,235,164,118,75,33,218,100,116,8,187,111,65,62,81,59,0,242,219,26,2,114,87,30,112,47,65,8,6,225,65,101,199,198,82,24,6,104,97,242,19,106,157,15,223,159,134,106,67,32,23,165,173,172,84,1,57,104,46,30,0,33,73,34,120,213,99,222,140,135,21,49,33,211,216,54,248,112,95,152,240,10,126,154,137,18,178,45,253,169,116,156,169,12,204,208,25,145,138,182,222,60,196,233,53,40,83,140,222,83,237,238,8,142,165,141,4,58,234,199,228,82,21,204,23,253,110,94,255,178,48,170,27,204,225,125,51,245,3,8,227,164,99,55,194,74,15,178,25,150,64,25,250,88,94,44,83,215,181,188,225,145,118,40,25,235,176,241,226,5,148,205,114,217,235,64,215,213,227,121,253,225,109,135,223,251,226,62,189,123,225,82,136,107,213,98,174,9,83,86,99,22,4,148,45,5,148,164,111,215,242,22,84,150,16,66,80,49,213,255,242,158,147,135,117,211,72,248,53,236,131,140,204,106,122,71,175,94,188,72,28,107,177,70,246,24,77,38,125,224,176,94,24,126,21,168,123,149,6,221,186,47,171,189,150,17,58,97,19,209,61,16,212,46,63,11,189,175,133,92,2,90,52,153,152,160,57,53,31,211,12,224,139,40,199,181,245,69,23,193,142,138,50,9,26,11,50,137,8,110,119,10,86,250,229,137,30,79,119,42,51,13,119,167,138,84,222,191,199,184,14,79,3,92,60,43,6,179,9,123,42,150,93,242,184,163,0,253,52,33,80,100,161,178,195,116,233,219,93,89,111,150,73,108,20,174,230,97,105,177,208,150,243,10,83,11,26,173,83,169,216,127,124,83,228,169,232,186,254,104,176,13,225,234,96,222,34,131,37,38,32,235,135,29,35,163,10,132,226,159,244,93,90,130,244,174,10,62,42,186,181,30,38,203,207,17,236,147,229,113,80,153,19,229,101,27,253,186,19,157,183,219,110,86,217,69,91,46,162,193,126,196,152,134,39,40,50,7,157,199,229,245,1,137,239,90,161,233,97,191,197,166,65,58,93,177,12,128,219,223,34,233,236,200,64,108,175,218,121,20,228,99,1,223,186,194,246,207,226,219,163,67,231,235,78,251,184,186,92,118,230,221,246,236,65,248,137,242,71,109,233,65,76,234,4,161,200,131,188,176,70,74,87,190,75,231,128,239,57,229,117,95,10,128,118,33,121,201,122,81,203,158,97,58,109,10,104,117,15,57,79,223,71,140,85,103,42,96,120,79,114,205,170,168,41,67,106,67,240,220,251,23,37,120,1,121,183,102,196,31,30,245,4,176,52,5,99,5,102,205,118,64,251,6,151,98,97,225,79,104,55,12,9,32,216,253,238,2,110,53,43,58,228,35,80,183,175,56,190,99,196,95,175,240,58,131,180,209,209,91,23,221,199,203,37,80,124,244,213,95,104,14,58,108,17,185,106,56,55,236,211,218,96,182,14,244,192,40,139,40,56,178,26,139,69,111,156,237,128,53,4,98,32,253,2,3,128,18,75,54,206,72,172,242,124,61,177,148,141,113,146,225,249,11,1,128,13,97,45,90,172,241,0,47,35,198,191,133,200,136,52,51,246,61,88,190,180,166,16,82,161,69,132,24,53,189,70,91,51,143,74,234,97,154,34,4,99,48,87,193,5,40,81,250,250,210,55,157,9,160,187,11,116,200,167,245,210,21,56,121,102,2,83,103,42,27,69,31,209,11,13,217,87,7,178,221,207,241,11,66,172,146,191,179,140,89,210,205,48,57,94,105,200,188,177,81,98,214,134,195,96,198,175,119,50,254,135,42,209,214,248,223,239,169,252,125,233,128,235,153,179,212,67,75,98,44,251,152,166,192,10,67,181,187,97,77,219,11,239,81,239,207,147,73,185,213,144,209,32,162,145,120,188,193,102,233,159,85,230,157,93,221,42,231,231,234,8,16,94,26,100,133,17,188,124,21,22,195,89,1,145,169,59,239,79,88,152,57,105,107,48,201,29,118,177,114,245,120,191,86,113,113,179,251,54,204,89,46,223,117,171,24,237,107,162,12,55,12,230,246,119,164,116,108,249,246,9,119,104,93,133,10,71,10,249,254,249,190,131,188,243,116,201,91,114,240,125,71,41,98,70,151,229,60,251,228,23,144,94,135,226,191,146,47,175,153,107,228,237,46,140,30,223,84,47,117,51,211,101,176,198,18,205,222,16,16,165,31,252,47,220,55,226,214,6,31,244,35,229,178,217,129,173,61,229,37,118,180,225,23,87,36,101,222,102,90,168,28,90,7,82,9,227,9,216,133,181,123,93,47,126,82,221,161,178,194,162,148,95,69,161,28,149,203,209,119,53,245,94,181,133,241,7,120,91,47,144,129,5,88,21,1,181,42,124,172,7,14,71,21,84,204,219,88,208,235,75,21,207,55,99,16,72,137,149,125,101,213,120,0,7,18,57,51,74,182,126,43,22,53,87,38,132,231,227,140,233,75,114,33,1,64,215,35,250,133,99,37,99,25,222,144,219,15,229,86,122,74,72,142,48,155,109,12,31,23,126,204,237,67,91,0,245,141,32,176,33,153,121,213,190,50,63,229,218,66,172,249,254,122,208,186,193,174,251,239,247,147,8,103,8,189,246,231,89,116,115,224,26,203,124,30,79,226,109,60,91,197,238,107,83,233,224,253,240,207,26,182,160,129,57,196,36,202,207,87,32,45,43,50,151,97,198,144,241,230,172,178,14,122,82,226,24,219,148,57,130,67,146,238,36,235,114,225,236,177,103,210,155,31,129,250,197,16,130,213,121,177,161,78,14,241,9,18,153,67,164,88,142,87,82,57,80,57,5,76,28,90,5,33,227,214,180,201,153,88,42,169,239,26,3,136,38,99,201,184,68,203,30,125,39,203,159,84,176,181,248,157,126,149,213,57,238,45,6,153,101,189,228,141,57,121,54,13,226,222,56,28,30,36,232,60,200,221,72,75,25,157,49,51,160,28,78,39,30,137,240,71,160,80,241,184,115,6,86,149,246,33,110,185,190,14,166,237,7,107,215,158,190,40,169,106,50,31,116,203,186,104,222,152,113,54,25,205,230,166,8,154,219,212,215,23,234,20,103,124,198,29,4,98,72,15,97,205,242,128,9,109,199,189,140,49,119,59,22,3,252,116,104,163,81,129,16,41,230,206,74,181,95,167,227,96,246,16,231,124,128,128,54,60,0,239,250,108,170,143,192,191,5,28,131,161,225,142,161,154,30,13,24,166,247,78,194,135,229,243,96,74,214,120,214,238,220,108,108,44,254,194,40,1,137,221,142,7,114,246,205,151,219,45,175,190,112,130,176,43,193,32,166,254,142,125,94,34,94,55,171,98,115,101,72,54,28,194,29,17,29,35,144,25,91,191,190,251,8,21,6,12,241,164,0,230,151,251,136,185,16,224,128,3,46,170,17,165,106,63,153,22,122,127,194,60,191,246,34,11,33,208,54,197,110,30,0,194,196,63,180,208,54,15,164,119,215,219,170,15,111,13,157,51,239,214,249,13,208,203,34,107,64,77,245,22,75,39,43,32,198,143,90,136,236,173,255,100,205,117,7,85,52,54,68,64,90,2,84,182,131,36,181,62,224,85,31,194,24,102,35,44,189,115,105,74,68,170,115,105,197,50,46,182,42,192,126,234,222,9,63,171,9,72,125,38,132,21,234,18,141,218,213,217,133,51,82,65,249,40,196,25,99,195,208,20,83,223,54,179,238,202,253,160,108,175,244,31,61,223,126,167,99,179,230,192,239,68,101,162,9,138,201,119,121,0,51,50,105,130,222,120,93,119,108,53,43,73,128,203,3,56,13,180,37,113,236,234,211,89,247,44,176,181,239,141,30,77,174,192,234,175,39,138,116,46,134,206,43,102,236,37,86,100,132,229,108,67,211,139,71,156,176,132,158,214,199,134,171,21,61,156,178,194,32,129,46,188,165,130,154,66,48,93,82,109,86,193,150,165,139,195,115,107,142,133,17,104,210,142,32,75,133,58,139,52,210,56,188,250,213,42,177,138,162,99,209,233,99,122,121,117,70,161,156,90,119,119,77,107,223,137,50,82,109,107,229,118,205,162,119,209,59,77,118,165,195,37,171,245,7,164,72,106,27,32,20,225,18,14,20,51,97,150,246,170,69,18,108,77,10,51,91,73,116,48,78,202,135,123,250,132,86,15,150,146,51,159,120,254,33,162,101,101,124,115,183,114,4,206,76,131,84,241,40,68,66,98,114,31,91,124,150,163,218,15,145,143,116,122,254,134,57,129,209,164,66,180,121,87,155,142,177,161,135,132,91,74,224,183,187,17,76,198,125,42,173,89,162,244,64,183,210,98,243,205,71,160,134,246,90,102,46,3,215,18,117,118,147,130,180,82,140,149,189,183,72,164,87,64,10,246,46,79,124,107,240,52,111,144,99,194,77,59,124,41,222,33,155,61,219,225,239,211,183,223,56,140,39,213,105,58,105,188,19,146,83,164,215,223,56,113,239,105,206,90,196,211,251,160,142,190,29,166,217,8,184,24,150,138,250,137,117,60,102,186,146,234,244,251,93,61,228,155,29,103,253,223,123,181,15,106,170,128,129,55,6,71,61,133,213,45,239,158,219,92,16,29,111,50,234,30,44,112,78,81,149,201,241,59,123,75,105,55,100,171,227,3,84,71,131,123,102,128,26,59,88,30,235,217,99,67,188,137,205,11,2,17,112,124,198,212,126,45,197,18,9,92,113,144,104,33,118,97,73,239,61,254,217,33,111,19,86,62,84,55,69,46,101,34,234,146,98,15,102,27,52,235,143,189,145,83,12,225,18,5,155,157,49,189,169,6,19,238,189,40,135,116,237,144,243,173,229,39,6,128,217,213,212,149,170,32,98,255,249,157,110,56,180,43,225,80,229,226,0,150,81,150,3,154,230,143,226,67,177,166,69,242,122,58,79,169,66,46,62,206,31,163,185,102,247,62,21,215,144,134,224,223,140,109,42,249,199,207,60,212,150,164,36,116,193,250,254,216,165,42,103,6,159,182,58,239,22,199,178,187,239,203,218,230,149,26,116,13,47,18,81,26,127,124,190,112,123,54,140,29,158,213,187,80,12,26,216,45,44,203,122,50,202,198,237,243,55,230,159,118,54,38,104,63,182,118,240,225,186,183,10,102,160,144,40,78,170,185,172,163,23,223,107,169,10,195,198,84,8,44,176,68,236,184,31,171,182,138,131,94,199,48,59,34,51,227,185,63,72,29,21,61,38,31,229,78,47,31,107,132,133,154,208,67,32,159,14,135,128,212,245,12,91,59,66,25,83,236,85,174,48,145,182,226,111,140,82,137,33,220,75,40,96,224,235,158,176,101,38,121,202,178,49,189,102,202,102,136,111,148,114,19,167,199,220,152,120,137,216,246,209,205,234,121,40,113,165,130,176,218,112,168,206,174,107,147,198,222,81,147,248,180,199,119,70,52,195,1,80,92,204,105,21,28,9,8,252,86,218,69,2,164,85,66,71,64,22,1,177,81,188,247,157,189,107,2,247,79,26,53,7,184,107,94,36,30,134,211,152,17,216,84,243,236,49,196,30,44,203,223,228,231,120,72,84,60,75,225,102,12,67,127,90,189,191,24,137,112,201,201,79,180,115,189,178,122,45,197,60,190,49,209,181,90,41,179,99,33,13,193,15,49,159,162,110,102,123,124,138,18,164,133,0,145,76,123,40,59,253,155,73,151,152,4,139,59,35,151,35,188,29,193,8,10,53,158,0,210,0,217,33,198,159,38,29,23,202,28,168,220,99,209,7,104,81,43,246,53,123,0,245,202,78,11,225,26,124,143,120,218,247,216,66,223,171,125,108,37,223,218,211,197,244,199,89,138,210,70,121,249,113,186,195,205,137,25,212,251,69,11,165,202,27,253,65,185,117,212,103,161,159,116,218,69,241,189,169,5,175,23,96,179,235,171,184,16,104,61,21,131,121,68,203,230,93,41,197,20,162,55,211,253,147,52,199,3,219,126,50,47,175,46,70,95,181,43,14,198,115,229,253,30,176,166,103,212,11,213,1,168,236,97,1,127,230,121,34,90,42,104,4,35,85,81,117,183,149,207,168,117,4,183,3,135,126,182,149,222,17,145,10,147,107,72,247,219,245,133,197,59,43,86,107,195,216,121,49,192,229,39,172,192,65,60,247,210,228,199,62,92,114,129,12,240,157,118,38,170,97,97,11,30,242,247,230,153,20,168,231,101,95,236,135,209,5,86,35,146,166,26,134,75,236,212,159,130,151,156,251,27,169,54,93,159,143,119,249,171,174,209,142,174,230,78,177,161,212,174,234,80,142,67,244,40,83,250,204,83,230,226,143,210,255,26,238,108,76,245,174,119,105,247,61,21,234,76,107,144,96,233,38,66,148,101,150,169,105,214,161,11,24,139,155,26,185,194,242,109,201,120,36,106,248,166,16,208,16,128,63,160,115,74,212,208,28,185,165,125,241,181,247,47,124,181,250,206,102,208,41,9,51,60,117,45,172,64,203,173,80,141,116,97,60,125,67,69,35,88,97,103,49,103,146,0,35,121,108,92,169,212,54,171,226,114,108,214,169,248,206,171,245,102,238,129,99,191,172,216,222,67,138,227,167,61,53,17,246,173,247,115,41,167,34,28,246,23,179,125,206,33,59,2,166,29,224,66,98,171,149,181,179,92,186,37,82,203,112,5,176,224,191,57,157,139,17,43,235,68,237,187,115,86,182,32,68,88,108,161,40,251,65,16,177,244,2,148,31,140,68,71,183,102,222,144,8,178,57,104,205,164,28,100,200,9,238,199,122,68,10,160,63,172,222,199,191,64,175,140,209,131,214,228,80,30,171,146,50,128,66,84,218,127,20,7,165,59,188,168,34,129,175,19,75,226,30,146,55,111,24,167,231,160,189,89,54,46,204,202,214,14,243,213,251,70,4,105,160,128,174,80,94,41,60,168,92,140,162,114,71,43,125,108,192,207,111,68,23,166,141,171,222,229,101,219,46,39,255,251,16,7,232,36,106,39,48,121,35,205,54,131,1,100,237,32,79,153,196,121,211,204,28,159,64,10,244,112,185,161,3,174,95,3,24,255,59,181,53,80,119,43,13,152,61,219,58,200,142,102,19,5,174,50,161,201,186,113,37,204,250,60,56,112,81,235,175,240,220,191,251,44,193,245,233,253,122,84,232,195,5,182,139,170,211,42,95,55,254,177,127,216,226,104,65,99,103,100,246,43,106,11,169,103,103,248,241,1,226,152,229,36,56,184,182,198,230,184,222,101,97,191,173,39,230,246,130,174,165,182,232,243,185,52,92,78,151,163,1,170,104,63,242,26,79,7,55,24,253,39,241,248,153,113,254,44,43,14,80,99,225,24,150,197,35,46,158,114,113,45,12,199,65,94,254,119,117,31,192,123,38,85,133,252,237,76,39,62,216,164,130,103,234,121,162,16,223,149,229,167,2,194,209,124,178,18,237,41,191,120,12,185,199,21,54,189,160,14,51,25,142,155,192,54,181,1,82,238,58,67,254,43,199,69,98,53,102,231,178,32,119,37,46,203,123,13,186,77,94,42,219,34,31,125,4,40,241,74,120,94,147,138,99,40,227,116,88,162,21,94,198,37,251,81,165,110,160,7,61,237,37,152,43,123,35,25,110,171,24,21,52,162,183,6,114,152,37,27,199,194,31,228,107,187,102,217,61,105,90,170,183,92,109,254,40,107,216,177,221,161,196,191,179,251,102,148,63,133,235,125,73,31,207,39,228,66,160,153,173,10,188,106,246,207,28,46,62,31,71,83,57,197,101,52,103,154,165,42,87,183,106,111,248,117,4,79,23,176,226,207,201,209,105,212,2,7,229,168,199,226,46,208,62,30,43,76,194,203,80,165,39,53,45,12,238,121,121,14,10,105,149,31,212,116,181,6,13,30,113,6,128,83,145,132,71,220,131,94,211,35,119,122,118,62,77,105,132,1,171,178,155,6,42,43,99,78,114,247,154,164,146,38,229,100,123,48,132,191,41,22,230,54,191,14,131,57,47,198,6,172,201,35,17,3,230,53,35,32,75,4,14,202,209,187,10,47,140,46,187,69,252,173,224,211,128,3,196,109,142,75,140,128,197,19,176,205,254,49,78,235,98,221,84,134,28,237,75,42,24,105,87,204,163,126,217,65,246,231,133,56,14,31,209,210,163,135,118,113,189,77,2,35,218,60,132,226,160,106,194,153,202,111,213,233,215,76,58,166,237,109,157,24,136,4,83,19,112,140,30,4,191,28,201,40,156,120,209,207,106,47,102,184,177,91,206,8,61,205,138,86,224,89,25,244,75,255,241,42,42,143,179,220,70,204,99,178,62,102,197,219,117,90,235,57,92,167,238,248,62,10,241,59,119,55,162,111,39,51,87,182,53,62,39,202,36,107,205,16,92,170,66,84,233,184,15,112,68,178,133,215,62,65,37,113,121,81,177,59,123,97,143,90,161,57,161,216,113,90,136,124,182,61,96,235,32,183,14,209,169,208,107,164,123,104,7,51,188,10,172,22,61,68,90,98,229,12,101,210,208,204,73,148,192,21,31,162,149,197,20,176,195,54,121,170,211,123,143,156,60,133,70,229,170,9,133,176,98,123,170,196,139,13,59,39,66,5,250,73,206,13,69,23,85,234,139,240,58,106,129,7,86,102,179,152,231,135,66,78,39,112,127,84,194,133,233,107,111,162,188,10,249,142,79,243,100,139,213,26,82,86,20,202,3,134,172,44,245,154,47,251,109,44,65,80,226,71,85,207,164,147,64,233,41,40,171,19,134,120,182,201,29,61,126,255,162,217,254,116,39,76,126,63,115,14,48,89,217,148,122,71,119,92,122,88,223,40,125,7,234,142,99,69,93,164,175,19,246,239,246,161,96,7,140,231,241,163,217,218,34,3,29,166,247,70,220,83,35,141,105,104,5,94,154,218,101,140,185,99,33,69,5,200,129,173,73,37,19,67,184,168,79,228,153,7,206,40,67,206,47,144,214,216,197,233,69,64,171,146,8,40,237,102,30,114,34,42,177,26,215,253,192,189,172,186,31,63,106,139,69,133,181,136,253,213,66,96,241,66,40,206,116,198,181,43,166,148,120,169,28,64,176,114,179,131,79,52,0,90,143,69,196,179,92,21,14,250,191,165,110,168,30,134,15,83,3,188,202,224,87,194,80,133,8,128,3,118,240,12,112,210,255,125,20,127,136,117,110,194,20,138,151,106,119,130,77,173,208,193,36,122,137,154,87,185,155,144,207,119,209,237,101,111,7,186,241,129,15,48,244,48,116,60,160,71,145,227,125,202,49,229,36,186,149,206,50,123,151,52,96,234,182,124,131,55,214,158,51,206,194,36,33,230,125,114,119,231,68,49,231,69,123,84,204,202,74,47,28,22,224,179,123,254,97,36,3,25,102,175,50,135,162,212,33,233,53,1,190,157,0,167,102,215,244,46,177,223,21,140,58,81,72,45,73,162,242,132,233,216,86,204,8,25,236,181,151,215,81,233,70,24,118,155,138,216,81,122,178,180,244,126,131,192,23,183,100,231,52,131,146,38,2,40,137,6,55,193,151,24,182,207,68,164,22,104,141,248,18,46,124,32,137,137,154,252,105,20,230,204,229,38,191,48,116,1,104,123,86,10,121,79,127,255,85,221,122,8,81,227,58,243,27,110,234,248,30,25,140,3,172,60,17,28,238,226,0,87,224,145,44,20,95,151,106,221,237,252,175,3,117,9,48,39,63,83,41,60,29,188,231,239,25,163,49,215,175,198,189,231,42,164,189,50,212,166,14,170,194,125,118,13,91,240,167,21,148,15,172,58,95,195,175,62,58,164,44,203,1,193,178,34,153,134,62,76,187,210,95,137,252,138,13,66,146,21,156,152,76,57,255,50,249,15,154,176,0,122,124,89,163,25,75,70,93,52,39,8,39,53,17,184,243,123,22,0,134,76,173,98,65,59,241,105,230,121,2,15,95,22,241,246,28,173,139,98,55,64,199,141,239,225,127,145,20,90,157,147,75,212,150,154,43,68,172,145,108,143,52,167,75,138,41,49,220,138,238,151,224,12,140,157,149,113,199,253,11,45,239,245,251,152,225,147,25,11,193,198,254,66,205,189,26,59,21,78,213,206,96,72,45,45,254,248,68,175,26,12,63,41,24,2,212,5,45,23,134,207,113,236,79,128,75,65,135,117,127,93,239,181,140,1,94,171,76,75,231,45,118,55,186,114,230,243,121,18,113,193,75,158,158,114,7,86,220,35,3,162,46,15,126,89,30,252,234,171,114,114,17,15,20,195,26,164,34,225,200,57,90,253,25,19,251,6,201,88,213,51,137,169,223,159,194,70,166,0,128,211,200,58,223,83,162,193,122,141,207,176,245,205,77,148,105,149,134,99,130,1,102,251,136,141,192,47,150,20,145,223,14,154,25,198,134,119,211,13,237,148,177,85,70,129,84,93,158,44,40,28,39,140,114,138,130,125,150,79,3,193,88,136,169,134,7,96,22,37,136,150,238,163,224,201,225,209,155,109,178,224,231,90,67,7,197,173,125,117,21,110,109,149,121,186,12,252,254,107,206,113,82,88,19,234,215,108,117,169,120,19,13,55,56,141,207,187,194,13,128,218,199,149,154,9,31,198,176,73,98,115,239,247,94,159,212,228,245,142,140,12,35,49,240,26,67,104,175,39,121,195,182,126,79,177,138,105,85,106,61,193,79,147,145,114,207,189,127,63,35,15,129,37,80,77,120,70,126,65,220,183,202,63,81,161,195,153,9,53,43,15,69,114,218,35,11,168,34,21,167,116,83,103,24,197,51,26,155,4,231,220,64,168,211,150,142,211,219,240,78,135,215,236,64,202,157,247,128,161,201,247,26,236,135,201,134,142,150,68,179,54,76,207,34,74,242,213,244,25,194,22,35,96,73,194,148,240,235,2,195,106,157,227,37,230,37,86,144,243,167,243,207,2,74,15,144,106,231,179,54,15,209,137,104,64,137,107,46,21,86,199,75,177,128,40,187,34,71,98,97,156,142,2,254,217,93,220,239,248,107,4,175,231,115,204,228,206,227,50,16,8,54,100,184,31,99,213,19,83,29,215,12,104,187,137,232,93,42,92,87,241,244,126,171,31,136,162,227,240,63,139,40,101,199,14,196,22,10,250,143,131,24,162,30,181,14,142,150,51,90,18,34,161,229,7,110,187,233,7,11,111,135,108,228,184,252,40,0,97,64,82,172,178,147,158,157,152,67,65,134,209,82,111,20,181,26,130,142,183,19,138,40,52,47,131,30,193,216,202,176,216,59,102,84,20,177,40,144,42,11,234,73,210,42,217,77,134,159,161,84,87,22,200,102,49,0,139,154,73,5,55,198,200,79,36,28,187,35,236,78,103,123,140,182,110,130,54,124,19,121,183,202,54,219,228,101,8,199,214,242,111,233,232,102,127,64,83,252,253,122,2,85,184,168,169,223,225,28,162,18,164,146,125,177,48,225,150,158,147,245,112,181,97,86,130,223,28,254,31,119,104,121,111,250,248,39,137,232,112,94,111,190,230,223,53,96,171,251,70,109,254,207,61,50,164,252,233,114,229,48,199,38,136,86,243,158,44,27,177,183,88,144,122,110,219,10,208,114,52,176,192,204,228,208,20,38,236,146,24,145,58,131,235,144,238,80,12,50,234,61,82,100,225,74,60,127,71,207,172,23,241,199,175,39,174,203,25,59,23,185,239,98,24,185,168,94,88,6,112,39,51,53,36,178,94,224,71,238,61,179,237,190,201,8,68,11,11,213,5,17,49,234,128,159,9,16,157,152,207,66,139,159,196,56,200,172,94,249,76,208,221,155,83,160,17,116,223,65,66,38,107,92,84,189,202,155,48,59,122,72,180,31,76,35,250,93,133,143,39,212,235,148,170,107,148,98,206,234,16,135,15,128,158,96,222,154,166,185,241,89,24,176,209,233,32,119,28,111,240,99,59,205,229,137,216,165,79,14,79,191,199,233,221,189,152,143,33,188,255,239,69,6,150,175,70,47,139,99,10,81,149,162,36,182,41,245,89,237,208,81,169,33,14,167,121,184,76,96,40,139,46,208,139,155,36,29,24,14,206,22,15,44,54,33,244,2,179,177,3,64,52,32,180,91,24,15,238,201,95,105,32,211,131,185,53,28,176,109,200,109,180,126,108,252,183,182,198,53,93,160,136,60,79,107,158,246,239,178,22,172,53,228,142,112,140,55,56,176,223,15,61,207,57,175,128,242,222,132,11,243,35,174,169,202,101,95,4,235,95,146,83,45,95,191,230,250,129,239,113,149,110,233,59,165,230,143,249,158,187,228,89,36,202,110,86,13,111,211,212,50,232,202,237,220,233,104,33,46,122,121,129,198,224,1,36,213,251,117,102,199,124,26,43,40,74,254,7,20,124,228,221,244,136,200,143,168,70,8,55,202,252,132,252,222,95,241,27,78,242,192,20,239,2,139,158,59,194,51,194,21,7,74,69,237,85,138,41,176,205,151,153,84,9,95,63,176,224,8,101,227,219,197,40,102,47,188,212,134,27,218,138,210,15,248,36,159,49,132,103,220,206,142,166,109,87,81,219,219,254,24,49,98,143,107,222,47,8,88,58,107,186,186,206,252,19,213,171,191,241,132,66,109,242,28,139,111,141,125,221,53,84,170,159,77,137,0,148,56,77,49,157,216,126,28,145,127,240,10,138,209,11,11,136,188,57,0,250,1,234,93,151,63,123,102,120,159,92,2,133,95,180,4,239,21,184,227,127,243,157,199,185,14,130,225,34,63,94,102,130,170,40,0,43,58,114,198,255,213,223,255,36,248,99,180,175,43,125,0,150,132,173,76,76,0,9,116,101,65,139,70,237,73,41,62,86,92,150,131,123,242,148,134,109,63,144,70,86,157,109,237,32,175,215,51,81,45,165,255,48,117,30,56,206,122,214,245,8,89,192,215,96,124,86,51,38,90,176,113,154,69,72,224,13,126,131,125,3,245,63,58,116,128,189,253,160,255,141,237,35,106,137,40,33,17,23,212,110,90,96,14,234,22,54,24,190,119,130,228,187,95,84,210,6,77,150,85,176,248,37,25,35,61,9,239,43,159,36,87,194,248,215,46,36,19,157,235,62,93,124,151,21,250,245,66,30,16,188,65,81,53,128,201,121,214,188,187,39,223,62,153,12,96,134,168,24,203,196,137,25,138,160,135,31,201,57,145,169,222,234,129,141,158,168,192,179,132,236,44,125,162,175,149,223,26,75,223,246,105,12,149,43,60,26,174,44,216,76,104,180,96,153,200,37,228,93,37,92,241,47,244,76,93,246,166,248,234,242,34,122,15,175,191,229,106,191,166,87,6,122,226,81,72,231,183,46,16,224,64,30,191,185,28,22,43,109,97,247,200,67,224,25,143,156,247,235,194,31,184,243,177,212,239,237,71,11,140,227,210,39,145,210,94,141,220,161,254,44,116,104,78,251,203,184,39,189,86,93,227,179,15,187,232,209,127,81,146,11,98,50,118,180,253,69,95,87,48,163,201,123,242,103,160,19,63,60,203,245,52,60,46,7,75,139,210,195,200,29,216,121,93,158,207,238,53,35,206,114,130,215,102,40,248,33,36,190,162,212,213,117,184,180,35,247,14,85,220,85,125,63,183,128,233,178,62,212,6,159,55,179,135,129,162,180,115,189,87,177,130,228,9,80,175,154,102,252,78,92,107,154,253,97,251,37,67,40,111,9,246,109,172,254,167,45,99,180,3,110,116,58,228,195,100,57,159,118,239,115,222,180,237,101,155,181,23,177,95,174,178,99,96,124,242,254,56,98,147,176,168,27,199,47,83,100,253,107,53,31,222,130,72,81,221,37,60,38,123,45,174,95,31,29,51,200,172,213,190,104,128,73,231,217,59,52,199,78,104,230,5,214,169,105,10,69,174,6,195,118,22,131,188,25,63,248,194,91,24,77,168,48,36,195,46,5,224,229,6,233,250,191,118,80,16,179,59,245,49,105,100,72,102,245,204,152,124,48,207,72,68,9,175,153,192,71,177,254,155,106,180,81,218,195,1,201,112,227,57,12,234,167,30,215,19,217,41,210,35,252,210,95,253,110,122,40,159,104,51,236,123,16,137,46,133,74,199,219,244,96,88,97,35,215,83,69,75,106,69,119,60,241,108,225,238,132,3,197,90,46,152,18,254,245,11,74,240,226,217,182,251,149,119,43,20,63,5,200,239,65,152,246,22,21,21,193,69,4,201,34,30,58,134,38,9,44,204,108,36,75,141,130,23,81,194,40,53,104,56,92,168,141,173,81,133,177,9,228,86,167,95,32,7,136,234,34,200,191,233,124,237,237,130,38,96,249,212,133,105,139,34,130,117,39,106,144,253,169,49,47,86,233,2,231,86,11,248,0,46,111,178,240,33,178,31,129,170,169,248,250,90,63,62,45,50,52,187,6,229,133,133,208,97,230,105,141,89,190,87,198,31,133,186,138,0,72,104,121,239,184,117,183,36,218,250,87,152,162,127,175,102,188,190,0,152,217,122,9,175,125,126,186,64,210,123,190,136,125,54,82,254,253,90,152,71,126,8,99,145,39,169,0,76,95,97,105,13,140,64,234,190,214,171,112,23,128,201,42,151,48,73,242,136,43,225,195,93,247,89,237,202,1,79,223,35,67,55,120,13,183,241,253,165,141,164,220,237,183,31,155,87,243,251,252,120,161,227,145,215,150,133,36,124,143,142,43,61,207,226,248,48,221,250,83,11,196,218,9,43,53,158,133,208,67,90,11,234,202,191,34,118,194,125,173,146,8,15,204,237,25,245,191,176,91,144,42,236,192,48,87,117,116,46,166,223,202,127,72,53,252,241,138,131,169,100,86,61,59,54,42,24,116,1,24,104,176,124,216,135,9,250,85,114,168,84,130,161,212,217,36,16,160,220,222,201,217,150,86,128,68,199,228,251,84,106,197,131,33,107,45,254,115,42,38,172,62,194,85,144,87,50,40,62,8,192,248,54,250,52,88,79,186,47,162,12,23,110,119,239,19,238,214,170,30,236,9,140,147,49,181,191,91,120,120,132,181,49,243,35,255,223,229,229,237,58,155,17,226,116,231,58,42,245,152,143,51,67,38,57,75,247,232,222,0,56,7,21,253,105,86,38,9,14,163,50,64,71,253,109,34,0,153,9,25,245,11,129,85,28,106,109,26,105,204,220,120,115,48,160,234,111,80,200,64,81,118,182,187,201,144,126,247,143,89,36,91,249,143,61,93,53,93,141,187,126,139,220,130,68,113,230,98,239,81,204,44,144,40,137,159,35,167,9,87,131,122,56,182,24,48,22,115,117,219,242,88,9,254,220,171,137,159,205,93,25,238,38,49,91,82,139,145,18,39,17,37,154,15,131,171,154,188,136,27,166,63,217,172,40,161,143,138,61,223,75,115,66,219,130,191,74,191,20,215,44,196,43,169,2,8,210,155,35,81,37,1,170,117,105,102,253,91,198,13,221,115,201,160,153,3,231,209,129,180,147,181,131,42,194,191,156,118,104,72,38,241,246,168,151,150,111,119,135,253,105,182,54,150,58,134,168,77,230,0,183,149,201,140,13,182,250,56,234,41,194,160,28,77,137,8,164,62,122,18,31,27,205,26,249,77,76,204,185,96,204,70,97,40,1,183,217,239,116,140,42,89,239,193,88,242,142,161,108,234,135,27,95,174,161,238,230,184,1,157,180,132,48,56,69,246,204,42,249,137,25,39,46,25,192,155,253,26,22,19,222,88,136,209,135,30,61,147,191,90,4,67,227,29,67,46,183,92,232,77,134,196,193,36,69,195,254,209,128,105,86,167,85,55,157,47,50,138,208,86,100,202,106,208,122,67,193,171,163,27,130,37,132,206,215,141,206,235,77,103,130,99,108,200,183,39,15,94,232,105,88,210,105,139,89,173,248,180,56,130,114,235,175,99,66,172,130,115,212,205,232,243,89,65,151,210,114,152,36,241,127,136,166,218,188,129,39,221,100,187,232,150,175,72,6,219,166,98,113,54,212,96,223,207,181,171,55,24,118,139,142,205,182,45,93,168,17,140,100,158,65,104,243,87,71,165,197,115,218,132,76,174,116,220,28,84,221,4,165,175,216,254,174,31,160,132,224,57,213,28,236,61,126,75,254,60,91,32,27,12,90,134,211,243,191,70,27,91,130,70,237,106,181,227,3,19,180,236,155,22,238,230,33,246,236,145,116,47,14,231,179,110,226,25,117,6,193,141,47,160,137,248,16,153,208,54,87,12,36,38,209,176,54,172,42,85,178,239,91,48,243,255,178,155,160,5,232,75,129,2,193,111,176,63,130,20,30,168,105,166,37,36,238,211,48,120,74,225,124,93,185,178,13,194,25,63,111,34,200,104,103,164,75,141,254,57,50,212,59,94,199,11,157,245,200,87,104,243,42,101,92,254,132,154,61,188,113,211,90,140,139,177,179,149,83,233,52,219,58,148,241,115,64,150,236,79,12,159,8,124,65,133,22,196,0,175,138,93,161,254,121,212,19,55,155,88,245,161,27,26,205,169,225,232,234,214,206,163,7,30,238,207,189,33,24,159,249,42,227,210,216,40,136,159,128,146,67,225,202,248,166,26,132,204,249,41,143,249,248,94,134,238,248,234,166,98,26,206,113,161,186,156,137,35,27,238,11,22,59,33,91,214,158,1,146,117,216,248,78,195,160,202,227,144,137,221,51,117,248,68,37,34,158,213,12,109,103,146,30,221,77,204,49,215,222,3,156,250,49,107,181,227,14,65,5,121,32,126,33,178,13,255,125,219,22,25,240,5,114,200,52,226,225,90,205,166,129,129,77,173,168,24,227,107,2,149,86,133,74,167,165,103,23,73,125,131,105,111,7,181,75,68,203,84,155,207,3,91,38,226,31,51,36,198,22,183,60,17,247,69,210,195,8,53,131,246,212,54,195,201,89,3,54,178,89,166,169,123,75,118,89,20,130,139,117,18,219,60,16,27,117,228,115,87,51,62,110,237,16,38,226,36,118,64,147,227,30,6,254,33,234,94,152,18,72,194,196,28,14,0,246,44,6,220,137,28,156,226,7,79,109,238,86,34,133,224,189,118,211,17,88,142,87,82,34,52,215,173,249,72,60,113,57,131,175,216,163,31,161,40,31,99,161,41,164,56,213,192,185,242,175,10,90,61,63,253,98,255,162,247,105,253,197,194,171,57,249,49,155,130,106,175,255,48,235,208,146,163,30,82,127,245,27,163,108,34,55,109,237,60,124,101,106,132,126,19,140,50,44,202,211,96,226,192,63,83,238,16,72,113,251,208,190,70,31,83,88,169,247,250,178,242,33,183,225,62,190,176,11,92,193,221,141,127,162,167,126,107,157,144,236,31,18,23,196,93,142,177,202,248,101,220,54,231,31,195,79,162,29,214,57,125,241,5,210,12,177,25,239,16,40,33,14,111,149,173,83,41,15,253,143,68,73,81,45,35,198,87,87,219,41,253,44,88,148,115,89,240,167,163,242,85,139,74,149,144,42,151,93,75,41,100,120,147,70,145,244,207,253,205,91,202,250,23,108,72,199,211,108,59,64,173,211,225,235,138,206,210,218,71,240,164,198,12,150,108,130,141,196,235,203,139,95,116,85,116,219,236,174,245,191,116,251,151,64,46,76,113,180,40,114,253,64,164,40,36,48,93,241,100,148,245,89,64,82,20,235,192,244,200,122,66,20,13,80,103,116,75,39,131,221,174,236,45,49,219,22,253,73,100,65,46,57,99,227,174,67,109,28,228,175,60,209,253,227,9,99,65,142,238,191,204,241,4,212,166,146,17,243,12,199,151,169,170,212,113,217,26,105,18,87,105,1,236,131,207,209,150,160,89,199,114,32,236,45,125,14,7,78,71,227,9,144,14,253,242,175,3,66,75,178,178,229,36,17,71,216,63,158,133,68,6,167,137,172,10,202,87,111,31,208,129,173,45,67,82,3,61,164,64,133,150,167,247,130,124,187,152,133,47,222,54,110,165,211,35,142,4,162,8,195,111,240,217,189,24,96,202,206,183,223,234,50,25,211,202,137,148,134,117,169,198,32,240,25,78,248,239,182,84,31,119,86,109,227,247,201,219,120,200,171,100,75,49,225,220,96,57,144,91,230,167,73,153,0,33,98,237,234,61,195,200,164,39,31,18,140,209,123,137,136,33,211,39,184,224,127,0,236,217,178,244,171,206,161,9,115,200,35,19,220,112,27,140,231,179,204,17,239,201,167,118,50,98,242,251,64,195,142,29,247,247,28,4,88,214,160,250,131,3,177,71,92,250,234,178,157,13,45,19,86,162,83,167,185,69,60,206,220,251,104,191,167,81,102,223,251,60,56,63,123,169,72,155,218,47,109,179,80,161,199,92,82,254,130,215,234,149,148,93,88,165,161,192,200,21,55,126,80,22,255,12,43,137,146,190,45,149,163,43,185,97,34,48,109,157,234,228,74,46,9,138,134,243,10,175,221,59,70,244,96,54,200,111,242,215,54,250,125,29,254,105,98,201,87,105,50,196,3,180,254,55,38,99,111,2,196,159,65,51,50,183,224,197,70,5,103,253,165,243,229,92,141,29,36,55,60,137,165,33,146,33,104,71,14,57,70,225,43,243,134,250,57,166,214,75,14,228,119,98,81,240,76,106,97,116,23,44,39,208,112,57,101,87,121,71,101,110,155,94,82,129,113,253,184,255,249,118,1,218,119,165,167,168,11,88,108,41,111,215,76,159,163,135,156,112,13,127,81,136,86,226,146,70,143,225,87,199,148,18,189,81,128,78,61,237,116,204,107,239,206,88,184,241,117,76,237,12,152,132,229,241,30,151,227,185,194,79,60,120,123,151,31,45,196,126,5,0,26,46,213,45,189,0,215,241,153,131,246,61,252,28,180,0,7,12,37,156,39,199,129,209,6,94,50,186,135,205,105,224,15,195,82,51,253,249,133,26,126,203,166,167,213,211,143,225,102,230,156,80,207,31,185,3,84,81,217,142,198,22,211,111,224,147,26,191,110,19,147,108,9,181,0,238,240,219,238,146,113,130,182,228,9,30,235,24,216,64,73,212,41,204,190,78,220,121,43,159,36,41,58,250,223,250,25,74,174,2,100,65,142,201,20,113,165,40,163,147,41,193,62,112,92,185,158,133,93,195,254,187,125,252,201,204,72,237,117,178,30,226,0,201,131,158,37,43,241,39,130,104,206,153,76,174,179,62,138,172,177,215,106,163,53,107,217,100,34,67,77,153,252,70,134,129,12,48,110,235,122,40,238,35,232,28,126,215,139,213,154,40,123,28,41,185,60,131,102,167,176,6,59,237,33,134,231,189,149,83,19,224,164,169,123,6,253,119,95,0,235,215,40,7,45,151,242,249,7,219,43,127,212,114,135,250,5,0,211,31,229,177,205,135,142,42,64,6,0,154,152,193,153,147,36,252,85,250,236,152,217,73,92,13,120,174,193,128,169,11,181,205,29,137,219,183,130,157,75,210,11,185,204,52,121,155,15,86,188,215,198,46,111,146,79,158,99,35,101,93,148,206,8,182,216,201,61,172,248,150,14,239,147,17,60,244,170,196,215,151,226,168,160,235,214,37,255,90,52,223,145,246,46,147,52,171,47,228,152,6,16,61,187,146,0,2,51,155,208,53,155,59,194,36,30,246,63,127,183,210,6,42,202,113,239,244,39,52,12,189,248,232,237,108,123,138,105,4,164,182,219,61,0,248,243,244,63,6,92,180,48,255,52,37,45,245,94,78,122,245,5,11,238,84,84,238,109,251,196,225,49,2,2,202,185,72,77,145,238,6,93,228,156,132,123,130,222,115,70,236,86,6,165,76,42,193,72,201,1,168,121,153,182,161,34,61,111,84,41,225,162,142,245,41,196,75,11,225,198,153,144,126,73,113,237,171,176,195,144,80,119,119,30,202,189,216,133,160,140,112,79,181,11,67,55,164,87,26,18,116,28,57,131,93,238,254,153,224,67,253,67,27,242,36,130,194,165,214,13,0,74,206,106,91,47,179,54,97,77,189,11,186,26,213,79,84,71,123,9,220,242,145,209,7,227,16,36,39,246,234,18,114,212,99,57,254,106,88,23,177,110,116,177,215,109,125,36,16,218,134,73,111,115,154,200,17,139,67,80,43,157,84,180,96,5,157,82,99,153,119,220,8,181,132,83,72,155,229,189,215,234,250,14,125,239,59,154,184,221,19,182,216,67,112,210,27,218,72,163,57,32,47,85,217,90,172,169,86,42,26,2,245,213,191,183,88,92,147,153,40,124,187,69,229,114,159,88,55,44,67,83,251,88,139,215,164,110,230,217,154,242,218,103,1,109,200,230,255,162,75,105,244,37,111,138,246,173,118,43,73,233,99,45,229,177,243,196,149,255,176,233,117,109,219,100,216,48,99,124,40,187,221,43,154,208,171,107,23,194,126,237,229,11,164,218,183,237,217,214,27,97,173,133,176,91,7,135,45,156,189,255,188,80,159,55,212,215,12,228,83,153,225,60,94,221,26,27,184,33,91,185,158,35,89,129,9,41,127,249,129,235,170,211,208,142,163,239,14,251,219,246,200,22,207,32,121,156,89,224,198,228,133,134,75,66,47,168,248,53,219,128,17,120,194,204,240,158,98,86,149,185,148,104,230,109,58,243,149,180,101,78,115,130,87,75,87,96,181,100,191,179,207,117,23,243,168,84,162,166,136,122,39,36,120,183,69,139,216,64,92,211,112,29,141,140,63,55,86,162,5,42,238,194,69,29,55,17,156,119,92,199,119,108,115,66,51,238,45,2,153,37,116,116,47,242,9,56,78,233,53,81,253,60,222,99,229,227,61,81,50,38,244,79,255,122,23,131,58,43,140,188,227,247,2,141,21,226,237,230,59,151,4,69,51,231,243,91,76,55,224,74,17,67,101,12,122,118,89,71,236,19,105,0,83,36,97,72,44,70,245,1,201,143,45,56,59,134,160,143,171,15,202,38,87,18,143,124,139,113,197,187,189,234,131,14,236,219,198,65,124,47,255,123,4,208,81,59,181,116,109,2,184,132,151,61,136,157,179,159,48,179,237,128,105,9,93,235,181,155,231,242,140,18,76,230,159,66,173,209,159,3,73,93,235,18,103,142,97,17,134,249,48,205,104,209,35,119,225,108,13,23,174,69,52,248,243,96,28,142,29,215,127,237,36,92,19,86,46,179,113,11,68,104,195,235,126,1,24,67,205,206,36,95,17,1,50,78,68,100,61,255,212,209,234,62,110,188,245,215,123,109,192,204,96,188,138,21,15,242,113,37,152,20,59,122,8,224,10,99,191,148,210,5,12,12,5,226,32,144,243,186,12,161,236,0,40,191,247,36,100,162,156,191,181,9,75,223,9,172,88,75,253,51,87,233,223,173,238,126,83,42,178,93,90,19,178,176,220,85,60,90,167,4,249,13,244,93,22,70,173,115,67,64,252,199,173,251,212,194,223,9,61,110,140,182,201,194,232,81,52,97,181,135,223,245,98,60,197,210,186,247,248,58,72,43,204,120,228,62,89,142,151,166,27,66,236,185,152,135,162,189,39,66,172,204,92,249,25,161,22,35,94,113,246,197,232,135,60,255,2,145,177,205,25,144,206,8,189,207,250,213,6,185,173,18,45,202,219,159,116,228,88,89,44,123,212,9,207,125,98,25,238,29,213,195,136,119,10,223,225,6,203,30,29,154,97,3,221,25,187,28,197,45,112,9,242,35,132,65,214,96,165,246,224,2,121,246,55,95,184,222,233,165,177,156,207,27,196,77,196,84,134,100,51,134,40,89,249,198,152,219,173,153,231,234,166,209,35,84,65,121,211,137,25,36,249,136,132,193,59,165,187,252,219,54,85,82,27,133,239,104,122,150,111,191,203,169,230,176,36,170,76,101,213,49,85,136,58,131,29,173,24,175,75,170,58,176,117,91,83,144,87,149,46,0,119,126,70,216,236,183,206,104,143,124,244,234,114,234,43,36,223,210,239,118,33,157,47,75,102,51,56,35,215,122,114,184,48,198,227,83,34,208,137,218,248,55,96,196,247,152,84,132,244,255,254,52,34,244,11,253,122,42,29,199,75,145,2,184,126,213,41,194,21,10,126,247,204,140,72,44,191,12,17,180,108,147,93,254,127,71,156,31,160,46,11,208,104,22,129,253,45,43,66,44,227,248,115,227,108,195,191,4,252,61,86,96,118,215,180,113,227,95,74,168,233,188,41,71,148,241,125,73,18,162,214,173,16,87,120,116,211,76,239,57,84,34,169,131,43,8,98,21,24,98,157,228,43,103,65,90,205,243,130,87,203,117,99,184,149,96,67,254,38,202,67,86,249,222,57,188,219,227,245,25,8,71,78,131,76,37,118,112,247,205,25,42,90,47,198,157,206,164,127,158,80,183,183,87,149,162,73,187,233,249,113,44,40,249,102,192,149,247,55,46,152,172,97,69,124,17,217,21,235,173,176,242,19,85,226,8,221,179,243,0,21,214,79,200,53,192,98,47,14,124,39,132,26,88,114,129,47,35,32,166,21,93,76,149,194,76,91,56,77,1,104,237,94,47,88,26,79,117,163,30,155,155,241,5,138,83,142,220,178,244,245,251,192,176,44,215,139,183,245,53,49,237,24,101,250,151,248,55,172,72,78,193,222,191,229,41,215,46,103,14,84,172,251,35,43,180,79,185,136,46,124,144,34,168,80,68,52,53,119,133,203,39,187,61,64,233,239,32,165,56,36,94,154,211,2,69,144,44,43,228,71,61,7,106,131,224,247,212,63,53,190,160,158,232,38,23,161,206,187,189,229,67,144,45,73,109,49,30,128,194,253,56,61,221,189,166,5,12,115,207,204,51,131,25,230,36,7,165,36,160,184,71,50,61,119,77,186,55,201,168,198,230,144,56,188,134,52,166,231,134,116,34,208,108,114,91,40,34,140,159,118,131,117,26,58,255,170,184,7,141,236,61,242,193,27,185,33,89,226,75,188,234,22,223,10,124,70,131,39,78,170,147,153,164,74,72,48,134,184,59,163,21,242,84,0,148,24,43,21,109,73,90,41,86,81,46,191,153,149,28,63,5,116,99,178,132,142,254,203,228,105,66,87,139,144,44,102,101,28,59,171,33,219,125,215,101,14,42,161,174,159,104,241,156,31,72,170,82,252,212,225,102,216,65,66,90,67,229,25,141,25,71,28,39,201,108,73,151,172,58,231,238,85,227,48,114,27,7,215,1,133,143,23,228,122,30,208,23,3,123,67,73,209,198,87,153,156,78,94,209,180,200,117,130,188,147,250,103,201,32,166,113,43,169,229,219,129,233,111,55,10,196,146,222,200,235,51,118,11,219,166,68,215,51,132,49,221,20,132,208,253,49,205,11,224,149,214,68,77,146,107,118,153,142,232,29,115,191,121,110,73,132,219,23,66,223,84,138,76,125,55,167,99,168,148,229,39,214,61,174,68,186,159,33,155,77,110,152,2,167,114,151,19,209,142,147,11,166,144,18,77,107,235,19,68,218,253,191,123,167,104,40,244,198,230,201,8,74,241,32,131,130,234,40,159,107,255,24,142,1,114,17,231,142,254,164,248,167,248,29,141,174,163,124,64,229,126,49,103,134,222,17,249,165,164,15,152,155,249,200,141,83,174,216,177,56,93,242,247,175,46,197,156,179,198,31,172,115,44,97,141,115,200,55,168,111,194,71,147,124,176,45,162,119,78,37,81,88,178,89,103,102,81,245,175,247,167,227,104,30,23,4,128,104,172,237,150,63,223,254,107,104,236,183,40,205,253,87,113,95,252,171,33,68,19,25,235,71,174,47,210,183,162,78,197,253,190,42,56,211,80,90,18,154,106,183,36,175,236,75,46,168,117,114,60,29,229,152,248,160,144,15,79,250,251,189,229,118,88,153,129,251,206,199,201,239,214,44,57,120,45,5,147,240,235,133,8,97,205,99,159,6,155,140,51,56,210,143,188,150,217,57,48,67,83,89,41,190,69,118,246,207,181,228,61,2,142,161,176,16,221,136,73,21,165,144,129,23,252,127,71,26,128,161,125,19,120,27,78,67,147,163,231,232,232,28,254,103,45,58,96,245,146,26,146,220,27,59,56,188,146,130,50,117,21,223,53,254,127,109,210,237,151,62,246,158,213,141,254,177,139,186,92,222,42,113,11,27,64,156,87,212,230,23,192,58,68,93,145,71,126,115,192,158,88,84,162,167,134,149,211,7,69,161,130,179,249,33,100,177,139,165,208,175,106,98,159,213,203,2,252,247,39,84,216,243,213,8,65,19,120,67,202,120,3,232,31,171,54,255,22,115,44,118,71,131,103,224,9,210,200,29,72,88,199,248,104,251,215,255,59,144,120,66,178,253,244,10,84,144,254,203,123,228,242,206,79,219,179,220,179,255,220,26,25,223,40,151,102,220,24,180,42,237,134,130,118,208,48,198,0,235,206,174,64,87,155,16,178,200,162,178,111,223,162,127,182,84,245,71,13,84,46,244,76,36,135,61,178,78,232,92,213,21,130,35,250,7,87,161,232,82,135,112,37,59,64,107,201,161,225,33,98,182,38,233,132,227,197,120,103,85,25,37,141,161,203,127,116,191,190,76,58,157,109,223,182,79,56,104,99,107,103,3,216,62,103,8,45,149,229,116,135,102,102,24,227,150,74,233,125,126,36,205,196,19,102,93,66,62,237,139,220,38,188,220,191,106,154,106,220,118,229,65,16,1,156,70,106,205,252,226,241,7,34,164,67,164,128,162,119,125,40,176,160,234,197,31,66,143,37,229,195,208,36,83,112,56,207,59,208,216,7,118,139,3,219,129,202,115,245,195,149,22,144,11,249,85,71,194,52,60,21,14,219,93,155,112,45,251,221,28,205,188,188,26,32,239,249,236,142,249,44,122,40,20,173,76,97,176,141,106,255,22,42,44,145,48,69,79,140,53,141,47,65,183,45,253,147,20,222,116,96,162,145,94,112,22,53,78,105,149,51,126,118,145,244,43,173,128,57,201,136,176,34,101,247,87,49,200,45,54,136,214,249,208,17,194,58,32,130,234,193,129,199,243,1,132,247,27,252,1,96,81,76,175,176,137,26,69,70,246,145,58,118,14,131,2,167,19,210,4,164,91,157,182,72,60,26,176,195,157,213,97,245,205,132,3,221,203,244,103,188,133,93,30,239,206,188,163,66,182,76,27,88,57,134,39,100,96,55,18,216,14,141,60,202,24,113,4,25,95,160,26,237,7,88,42,119,141,172,135,124,81,87,48,195,245,27,203,215,241,88,188,50,214,31,104,69,231,65,71,136,14,232,205,106,183,27,151,142,164,211,147,183,86,227,184,0,137,18,27,131,106,195,143,30,62,142,96,32,5,201,29,119,32,45,178,65,22,212,7,26,27,209,97,134,146,130,236,100,223,31,96,196,210,108,225,88,88,134,125,21,104,209,199,182,248,24,215,169,113,33,16,110,160,32,130,26,224,91,22,82,238,139,138,55,20,214,118,226,239,78,130,238,194,82,223,32,133,167,39,61,18,166,174,20,226,169,166,152,70,45,6,29,55,245,228,150,88,14,77,11,236,45,154,118,111,156,150,103,241,32,164,66,113,134,124,10,17,213,65,139,204,158,65,0,16,13,200,180,118,72,208,214,78,226,243,117,57,64,161,55,138,234,7,234,5,184,180,155,80,64,170,213,169,207,147,140,117,186,162,245,169,108,170,48,93,193,197,253,253,45,146,41,170,254,247,19,43,44,219,28,9,197,242,100,2,137,83,75,128,0,9,55,57,77,205,175,246,5,202,78,36,101,6,211,30,115,174,201,171,127,159,114,195,249,99,30,195,88,36,96,58,137,193,246,195,29,57,69,19,174,129,202,231,162,21,77,57,218,42,188,26,58,16,31,222,66,18,113,2,4,132,96,86,115,183,25,134,41,187,117,67,102,185,245,118,156,126,1,64,175,137,241,26,109,78,17,66,246,69,40,103,149,68,194,12,164,45,67,52,91,231,136,119,54,107,74,115,233,250,177,156,109,122,136,121,181,131,57,123,110,202,214,225,138,203,165,209,46,203,154,156,165,178,92,156,42,9,149,59,69,107,92,163,177,12,172,105,235,237,84,132,243,114,10,41,139,224,128,248,206,100,19,89,50,125,182,120,228,190,132,179,206,183,175,185,188,99,128,35,67,186,190,111,178,135,100,53,117,52,124,184,33,250,159,123,161,92,80,64,150,165,101,27,174,145,73,88,60,251,223,182,230,54,152,138,24,9,243,128,47,41,248,6,146,124,33,49,171,147,95,114,164,121,230,170,78,185,206,254,99,82,53,178,115,52,149,189,98,18,55,151,102,73,190,162,141,89,241,201,70,1,162,160,194,75,134,86,193,148,227,236,147,198,220,42,243,195,32,77,29,51,132,120,52,239,215,206,58,49,73,103,195,247,237,153,37,15,152,134,173,248,173,214,50,14,119,100,196,219,165,133,190,3,134,13,203,15,191,176,99,196,233,233,159,229,177,15,71,29,105,146,147,76,186,209,16,24,25,114,130,163,176,112,101,154,121,78,128,243,26,124,250,35,250,45,234,127,163,0,204,22,16,40,139,124,35,1,18,177,208,47,0,82,49,16,152,132,213,243,12,57,237,22,126,236,223,32,176,36,201,189,36,132,239,83,183,250,163,77,106,157,62,215,173,139,45,10,3,7,172,152,149,148,23,207,139,101,166,51,120,48,159,48,55,22,75,187,131,60,178,62,1,23,122,55,196,108,254,147,111,103,189,218,135,143,47,48,34,250,27,76,101,117,41,4,39,178,103,44,112,107,110,29,202,102,231,64,253,93,61,234,16,176,230,89,241,44,188,174,223,18,167,154,48,14,64,187,121,54,13,16,34,134,175,118,145,5,75,28,177,177,105,98,114,87,181,106,168,16,115,15,60,121,99,180,171,75,116,23,52,110,16,247,90,76,103,25,42,238,32,112,198,79,49,201,240,249,193,10,121,149,10,169,70,88,253,141,100,26,35,177,89,133,247,212,215,68,156,174,123,32,148,226,121,78,76,162,110,242,50,188,122,69,49,129,212,66,39,73,122,45,226,41,90,111,63,219,46,109,24,137,223,212,22,197,58,112,62,10,39,222,60,138,170,238,209,25,38,218,87,147,117,34,143,103,111,64,72,4,109,182,67,0,213,194,9,7,211,6,118,86,203,138,210,214,243,12,134,99,60,51,34,243,94,133,16,51,92,36,197,76,235,150,42,27,159,30,234,243,250,188,39,202,106,180,129,179,116,196,17,143,12,246,172,170,125,243,18,103,11,87,138,127,233,154,63,15,227,136,10,200,251,189,233,156,225,199,10,203,128,27,135,158,181,221,7,53,96,217,90,70,148,83,144,35,67,217,119,219,246,91,171,120,219,47,77,47,51,115,16,133,11,44,209,10,182,64,163,86,21,161,67,55,102,4,245,8,29,6,141,218,57,96,44,139,3,131,218,155,150,153,115,67,144,68,128,233,79,48,8,131,78,218,168,1,188,113,192,144,103,5,119,108,183,24,205,185,114,94,89,54,93,240,115,74,117,68,97,0,64,186,75,64,236,9,14,30,237,105,29,96,248,40,64,5,135,196,124,249,155,3,77,2,246,102,224,174,237,135,163,87,208,28,101,116,221,99,47,240,158,61,83,83,137,28,43,24,248,4,135,75,181,69,203,40,105,97,69,88,127,82,238,193,146,85,151,68,138,175,192,135,61,210,33,23,76,46,240,113,103,212,30,73,200,18,227,93,84,211,150,25,200,133,80,180,180,58,110,20,115,226,255,44,159,187,118,41,91,107,20,121,165,170,251,54,181,91,10,49,184,153,16,69,122,121,21,245,180,184,93,205,62,177,120,184,231,24,159,119,182,237,209,117,71,248,192,120,50,76,20,18,39,174,140,123,139,71,223,202,192,219,190,114,57,164,62,145,96,111,93,198,0,131,53,192,187,139,249,5,58,199,153,13,102,164,248,143,208,128,128,18,32,45,197,143,113,132,180,21,21,218,5,22,41,221,245,93,247,122,37,9,237,212,202,93,168,220,50,158,92,92,166,127,104,56,180,245,237,84,105,115,194,216,201,92,241,173,152,108,203,38,216,91,186,30,70,185,221,118,140,77,71,203,15,16,233,205,52,108,177,61,86,4,188,122,73,253,178,194,85,164,197,233,205,160,124,19,36,114,117,153,0,162,43,210,98,247,214,166,30,139,185,249,106,113,248,137,103,147,118,39,236,85,167,142,168,3,66,27,252,118,171,239,2,141,158,123,220,107,166,56,76,111,255,23,33,137,160,132,109,118,221,220,84,154,73,195,107,3,64,239,92,238,208,73,205,230,169,16,13,67,244,197,70,242,85,231,184,8,147,200,95,33,181,108,105,215,67,197,106,190,167,184,97,3,160,203,174,174,156,248,16,109,54,176,106,56,95,229,60,106,232,170,124,160,211,144,12,179,156,5,240,99,46,167,135,190,242,169,141,102,75,242,22,225,39,248,175,89,115,63,170,140,46,161,87,189,114,167,80,139,218,148,38,235,239,133,253,25,159,145,185,116,156,54,170,255,159,97,112,215,174,29,228,164,157,253,10,177,179,30,169,72,21,13,59,177,31,32,178,88,25,208,62,1,77,182,139,235,103,132,80,192,209,124,14,248,26,246,170,44,130,64,23,87,16,173,47,16,233,132,211,178,76,114,177,240,177,223,112,52,94,248,251,177,196,87,152,59,200,188,254,176,189,53,107,250,137,231,241,78,60,38,76,151,190,45,98,83,199,37,176,239,233,201,244,20,224,72,139,175,119,68,176,229,216,56,190,80,234,75,83,82,106,33,137,215,98,103,248,109,146,5,144,134,54,190,96,232,128,24,170,76,100,58,172,251,121,35,174,71,91,142,62,173,115,60,94,42,194,66,235,170,235,22,75,83,123,236,131,17,252,216,9,75,127,219,19,31,117,213,59,186,6,228,49,201,173,126,26,183,183,153,178,161,163,86,126,33,60,135,161,183,103,156,239,30,15,255,14,147,33,221,236,12,11,237,21,178,60,74,255,25,17,229,228,72,70,9,232,32,40,162,237,176,213,161,47,31,42,26,245,219,198,126,85,69,135,9,196,99,230,247,6,145,227,27,127,255,27,51,137,186,193,28,66,7,33,199,10,123,19,169,60,142,63,241,116,103,85,125,48,148,34,176,74,100,132,36,153,187,25,20,200,239,36,36,48,31,6,77,69,92,41,26,208,152,135,68,89,192,134,243,215,8,195,132,42,158,222,61,2,72,134,16,246,171,81,141,198,7,23,144,45,148,245,180,142,67,188,9,23,137,225,174,118,94,82,71,0,84,37,200,218,21,52,83,48,88,0,204,125,204,12,91,10,150,201,172,131,230,53,68,54,62,79,209,55,137,198,229,226,107,116,15,52,229,174,166,35,167,159,69,71,136,130,163,123,177,142,91,85,106,33,131,85,94,225,216,21,17,93,160,235,252,238,253,185,248,233,12,66,198,112,177,61,106,213,140,233,152,114,161,63,118,43,168,21,227,73,14,12,197,36,171,60,115,81,9,85,166,182,233,3,17,167,158,250,78,116,118,24,45,100,18,238,190,86,180,251,140,254,95,186,88,212,188,195,157,241,120,231,35,135,25,227,240,57,101,152,137,120,231,10,1,52,108,190,23,63,200,8,136,152,87,243,240,192,23,158,79,51,135,106,3,20,222,51,107,5,108,13,77,192,159,91,192,47,111,33,135,70,23,189,207,161,58,234,203,75,12,112,31,38,88,75,87,132,114,157,187,23,85,188,43,85,208,150,48,52,71,173,49,106,108,92,76,185,94,198,66,214,58,8,31,86,144,178,144,93,159,146,171,162,133,94,100,139,85,11,8,89,90,147,233,92,40,12,197,248,208,11,138,150,26,220,23,155,204,166,156,144,34,215,21,235,118,101,172,133,110,10,67,207,142,161,114,117,171,12,19,211,148,66,107,165,130,10,86,212,180,101,109,223,193,159,128,106,7,77,94,194,228,128,160,77,41,208,80,176,255,187,60,165,96,116,68,113,184,74,116,189,111,66,237,27,65,183,240,82,29,243,171,102,105,177,226,32,160,40,189,126,220,233,38,180,68,10,212,66,81,19,236,167,83,235,215,202,210,24,125,230,91,158,104,87,238,7,178,89,51,235,1,133,36,188,215,212,51,155,13,49,237,75,222,114,254,145,85,217,154,250,130,107,187,147,75,198,94,237,100,249,111,153,199,103,40,62,212,180,223,243,109,48,8,59,203,15,74,100,117,60,57,52,92,135,141,222,211,16,149,78,68,10,196,172,148,170,225,200,84,18,151,93,213,36,235,30,23,190,107,194,144,206,73,144,239,0,99,42,170,42,248,202,139,57,211,35,144,44,63,75,48,116,61,192,159,184,138,149,161,211,221,60,122,81,149,160,64,223,41,203,112,165,188,173,125,146,144,194,163,204,131,169,72,107,209,244,101,115,118,175,149,209,186,207,245,153,6,21,101,233,150,206,108,28,28,50,3,254,198,102,116,223,246,64,215,176,152,39,25,166,170,77,26,71,127,173,162,179,19,182,158,169,9,166,57,25,51,53,168,17,88,79,6,15,5,34,197,222,17,221,136,94,106,184,237,15,233,89,191,31,243,198,201,235,210,210,134,86,45,22,28,140,222,138,150,167,207,205,85,235,91,224,69,26,55,51,204,5,223,58,191,231,251,59,204,50,177,239,122,214,252,8,172,255,162,97,17,53,136,51,145,171,88,59,29,45,50,80,120,170,92,133,61,42,35,148,59,175,229,176,198,108,255,34,224,49,219,169,237,138,180,99,193,200,201,220,129,153,35,156,242,145,165,171,236,168,190,251,224,137,166,34,248,179,153,225,93,20,197,238,183,51,134,209,184,140,241,241,210,157,29,192,99,155,254,57,194,122,129,148,175,131,161,199,51,158,204,230,163,168,137,218,49,0,254,241,72,222,196,164,231,133,32,208,3,54,42,93,255,167,190,197,57,76,86,20,170,55,120,154,34,92,81,83,191,1,1,113,112,179,159,120,58,250,57,134,202,148,55,111,19,115,66,185,199,170,159,190,32,244,116,3,132,204,220,180,182,98,166,240,206,135,30,9,161,107,155,237,108,105,223,234,189,139,88,60,213,217,146,184,216,222,93,27,89,235,36,204,173,21,89,170,15,246,25,227,79,112,82,154,14,63,0,119,157,159,75,193,30,156,80,10,41,22,58,216,14,150,161,228,85,20,92,2,75,142,213,232,127,19,9,192,115,162,173,142,143,141,228,193,140,18,255,59,184,53,110,101,161,12,126,23,158,190,176,235,17,23,239,117,65,203,147,248,24,60,117,163,193,136,25,198,74,60,132,89,215,148,172,11,91,152,53,229,129,202,92,86,77,24,219,60,104,136,192,29,72,196,119,78,26,21,178,171,126,201,21,181,127,125,159,166,176,211,4,161,27,56,218,101,27,17,127,87,203,110,188,121,14,20,114,103,208,186,122,93,117,130,54,154,31,153,206,137,166,238,110,57,84,51,202,220,209,235,107,96,69,193,218,224,56,30,125,48,0,94,13,177,76,86,143,102,176,215,212,217,186,243,55,231,188,190,164,52,139,1,164,86,62,82,89,228,149,110,103,196,3,48,48,6,101,196,194,94,160,157,175,64,80,47,66,177,180,75,132,90,154,123,251,172,217,201,65,23,79,74,96,183,165,162,102,19,119,110,17,113,38,37,161,91,161,209,76,133,38,145,135,230,55,80,217,142,1,159,36,136,75,106,143,113,202,56,22,254,21,224,135,187,47,23,172,227,193,90,83,203,196,108,160,33,99,91,236,104,183,40,182,20,196,141,31,95,175,250,206,9,193,108,232,86,221,245,218,22,38,248,71,107,128,211,202,60,193,113,10,229,197,203,33,137,162,10,155,14,178,193,18,144,28,78,60,227,101,27,230,188,5,8,69,126,131,21,55,228,195,81,108,17,230,51,45,154,64,8,140,141,114,148,60,17,226,63,138,166,67,140,224,36,67,59,15,218,105,7,69,98,157,8,129,5,213,85,24,75,157,117,31,184,167,75,179,202,120,86,43,231,171,126,94,228,240,72,32,3,163,50,196,150,38,88,203,65,187,47,184,156,22,103,250,249,200,83,30,97,17,79,145,241,225,6,119,12,177,173,165,38,5,142,185,97,224,138,170,157,32,255,3,252,209,122,113,62,56,218,116,57,215,146,113,161,232,110,77,43,179,174,76,70,240,92,140,220,9,81,12,11,67,67,82,217,126,30,233,44,92,184,117,34,172,236,210,142,158,20,46,194,161,103,225,184,79,55,172,89,116,118,59,181,100,2,141,167,176,127,29,77,106,155,128,95,225,92,97,250,122,187,162,87,65,157,127,40,208,174,120,99,37,131,161,7,43,11,106,80,63,7,91,13,89,188,169,58,39,240,142,255,111,7,198,109,9,51,166,140,103,66,163,95,249,242,201,233,67,24,216,68,157,103,110,38,198,195,34,158,205,123,50,223,199,172,177,133,131,143,136,193,168,209,157,147,59,139,15,155,19,51,146,236,142,19,131,226,154,48,218,208,253,132,126,226,189,205,179,77,20,118,254,124,243,195,65,79,113,111,141,84,228,204,228,224,117,177,78,222,217,80,79,180,33,25,163,39,5,61,35,29,46,14,82,102,42,168,86,47,152,48,221,88,32,56,236,18,87,119,76,105,108,120,36,115,27,109,72,60,225,176,204,178,194,149,240,223,176,210,172,219,214,63,247,163,97,83,190,179,49,220,132,213,94,206,6,69,166,52,192,55,247,1,0,97,21,238,223,140,197,66,194,89,86,146,154,122,72,198,252,79,85,91,140,252,86,12,207,37,53,147,16,202,188,135,24,146,186,187,201,92,26,7,206,245,191,26,205,221,232,100,254,240,252,25,137,172,169,98,81,83,178,64,163,47,45,37,103,71,211,249,81,199,169,60,56,33,169,144,124,210,80,16,8,61,59,133,168,225,80,11,150,18,146,77,221,26,24,2,11,109,186,233,37,126,4,242,53,97,227,221,242,214,196,218,86,227,187,202,225,222,206,250,59,181,135,201,48,121,252,127,89,8,233,23,205,249,17,139,141,189,50,179,118,80,112,37,214,63,14,11,125,180,11,174,46,25,197,234,121,99,214,137,216,123,179,31,189,182,202,135,114,212,231,113,76,209,194,72,29,137,112,149,238,230,193,59,38,152,160,141,223,171,36,113,115,122,87,126,53,87,32,55,229,254,81,82,188,53,108,57,25,207,182,91,157,48,105,153,169,131,121,76,225,246,151,121,78,149,98,39,215,69,95,249,103,146,33,175,213,55,33,28,77,134,27,129,184,5,21,84,36,211,220,155,146,157,36,67,194,181,252,247,73,153,60,37,218,138,103,89,16,227,68,172,161,20,226,38,160,18,213,191,237,152,21,154,58,40,214,141,114,208,123,223,127,71,75,20,71,210,23,178,138,179,164,135,50,210,133,30,90,61,141,80,94,238,88,139,111,234,153,168,12,195,171,187,150,53,181,19,52,200,209,102,178,151,100,203,237,232,148,156,248,121,167,16,124,109,99,172,20,160,8,161,222,197,167,100,153,20,68,124,212,31,153,15,252,100,55,119,219,210,180,26,235,10,139,66,213,61,78,44,58,40,159,77,111,91,177,226,16,201,139,133,218,73,227,40,112,41,136,111,65,255,253,244,53,71,243,179,104,251,153,93,231,116,251,46,133,146,254,133,190,49,11,36,209,124,204,131,115,64,67,34,224,121,220,135,85,100,101,122,189,85,177,231,64,101,186,142,220,184,62,242,99,247,173,135,100,86,100,25,120,133,155,251,111,102,84,23,84,170,229,253,207,89,224,216,176,47,250,234,208,113,213,39,157,204,68,218,80,213,66,125,126,25,121,80,148,164,54,237,117,206,115,49,230,248,13,121,219,213,138,118,153,80,10,165,245,42,152,93,123,166,83,184,37,102,153,232,101,133,34,142,247,155,63,197,186,19,33,164,97,135,81,235,126,44,38,79,173,114,110,144,31,144,199,104,154,119,7,50,31,49,213,113,143,37,202,155,12,198,212,82,191,119,10,7,77,69,28,95,18,104,156,210,113,80,91,65,28,72,130,12,227,22,222,158,94,254,148,231,234,250,17,129,239,238,181,197,143,172,185,16,145,157,215,93,189,203,120,112,75,206,241,100,137,154,82,82,47,69,205,138,65,15,144,83,224,231,126,234,99,0,129,177,100,86,193,245,204,178,238,48,234,68,46,246,189,47,76,188,6,44,193,102,42,37,253,62,29,57,77,255,107,220,247,135,134,69,111,65,93,94,195,68,118,131,4,116,99,45,18,82,106,144,9,104,65,32,227,65,124,158,180,87,207,180,141,102,79,40,198,95,155,196,162,98,104,209,103,6,136,131,135,27,102,226,151,4,19,145,158,21,34,231,27,167,47,122,185,101,18,242,221,71,181,90,240,249,107,76,6,224,253,5,158,110,180,6,227,252,57,233,191,147,11,195,106,194,161,214,181,231,157,29,42,197,205,32,3,112,114,171,98,147,65,83,152,27,252,193,184,213,67,36,161,186,220,158,175,1,13,200,222,188,194,159,156,139,142,91,226,181,233,77,197,141,129,143,215,124,120,150,187,182,65,78,96,227,140,44,111,86,94,121,18,41,3,157,94,136,163,127,8,241,182,249,100,14,121,114,153,235,71,4,107,155,162,31,184,236,177,101,66,139,169,142,21,38,160,10,141,101,193,78,0,181,222,248,122,161,196,125,231,136,240,65,76,179,182,160,189,162,123,91,179,206,59,29,180,144,82,117,163,77,105,248,177,139,60,240,144,82,176,230,195,174,59,21,222,82,198,53,238,18,16,125,43,95,91,111,134,28,14,21,62,150,236,61,142,96,248,81,120,153,226,215,62,23,93,215,154,177,105,178,2,139,117,56,5,157,29,7,209,206,118,120,58,165,2,85,161,181,91,122,120,164,54,73,81,57,23,163,254,71,208,15,117,237,72,160,37,117,203,130,234,84,245,205,37,236,89,174,230,253,152,253,109,223,142,222,108,48,90,67,205,212,206,134,160,1,239,214,85,161,228,131,51,238,67,132,208,178,69,148,192,181,234,91,9,104,128,71,92,96,36,80,26,229,0,79,188,2,19,72,77,214,89,145,58,237,74,77,221,112,105,153,46,70,171,46,237,44,249,123,176,15,121,85,183,130,107,66,231,105,97,84,186,250,106,110,9,23,143,196,164,35,115,75,26,27,231,144,161,141,86,72,94,203,127,109,105,240,180,14,107,213,232,130,201,129,207,155,190,8,156,91,195,203,74,218,157,166,41,179,200,89,59,156,44,201,135,46,214,214,69,59,48,202,133,12,98,195,74,47,235,3,128,102,112,100,172,187,238,40,211,191,195,124,167,69,27,23,140,76,245,76,46,42,203,196,178,147,235,150,214,138,74,140,84,149,103,206,217,72,167,112,31,41,197,99,189,223,238,229,254,180,10,250,52,221,42,46,171,180,154,141,121,93,125,249,241,183,254,148,138,214,174,210,132,47,219,133,180,204,173,247,123,58,228,62,173,174,22,185,158,182,226,157,159,208,52,176,181,53,187,110,118,107,83,192,4,165,165,176,155,246,138,243,13,73,101,25,16,204,237,243,19,193,24,25,86,122,134,6,71,161,9,60,167,35,205,87,254,118,64,252,103,126,202,104,20,200,222,22,136,22,236,17,232,163,65,156,13,105,133,120,33,167,66,47,61,252,12,239,93,221,200,175,164,233,1,221,83,22,203,194,161,197,64,234,36,148,60,0,69,39,253,235,33,228,189,72,151,37,221,239,159,223,214,77,183,54,238,173,255,218,27,69,37,253,59,8,254,28,93,153,102,79,247,191,158,186,90,132,206,231,35,76,163,162,35,139,92,90,14,50,190,243,188,83,211,12,28,42,97,224,55,87,219,41,246,50,202,193,58,63,234,93,192,100,235,82,201,163,42,251,42,219,139,91,221,149,50,204,242,165,24,137,194,175,148,172,162,202,103,54,138,32,192,67,164,48,185,182,84,45,216,199,187,208,206,118,111,3,188,50,62,132,112,139,210,16,54,247,163,187,89,233,37,205,46,147,125,29,122,103,205,247,59,9,74,223,82,25,146,67,109,69,78,247,25,54,201,223,137,131,204,236,181,66,149,227,139,227,218,30,184,100,67,102,131,148,58,210,163,126,145,82,214,237,63,227,92,3,64,118,130,96,12,81,177,39,71,29,67,170,4,143,186,1,172,57,106,164,149,99,167,22,166,35,164,45,4,160,166,73,191,43,26,183,209,66,199,56,93,65,28,21,250,210,143,105,252,140,10,81,242,240,212,139,103,202,57,68,49,237,155,200,109,209,123,77,62,90,76,20,222,107,244,90,218,171,29,168,180,25,222,94,220,88,10,178,166,242,226,71,95,129,211,38,208,180,10,203,120,6,27,249,206,112,155,201,92,78,111,40,147,8,66,47,94,115,79,138,237,154,187,156,151,16,240,151,174,226,109,54,139,51,97,117,237,213,141,71,101,191,249,145,254,205,152,44,154,159,63,100,23,156,30,225,235,153,57,70,31,245,5,217,154,240,51,87,93,193,232,18,5,93,193,72,1,202,109,238,94,69,130,102,37,63,249,169,234,243,58,108,8,249,94,79,130,70,97,203,220,127,115,67,36,147,65,207,206,212,145,245,106,109,163,77,142,211,30,173,211,110,162,100,40,177,141,176,148,136,66,152,193,94,123,75,252,205,18,192,186,110,121,247,204,56,45,184,184,252,32,217,200,169,179,93,217,163,22,16,218,163,4,5,167,192,242,62,236,251,67,209,65,46,106,84,240,244,233,125,90,27,11,73,121,223,248,123,198,240,44,73,195,181,122,86,184,248,141,235,11,180,118,121,209,134,66,247,243,184,235,204,90,76,215,210,198,208,15,199,82,6,134,148,26,177,200,240,215,251,190,66,31,250,72,12,178,241,185,116,8,187,212,157,37,72,183,170,158,170,144,245,67,96,80,117,7,42,165,111,80,131,116,107,250,154,129,142,80,146,125,64,58,4,79,201,79,103,188,123,204,41,106,82,161,195,197,245,55,189,57,224,184,149,202,219,104,175,240,182,65,51,77,71,163,156,143,1,201,156,209,242,202,142,204,121,162,245,16,110,131,116,34,36,34,155,204,220,156,101,91,64,50,155,39,158,151,115,248,199,36,134,7,152,135,23,11,114,208,223,130,80,242,203,153,199,100,183,103,57,248,252,123,187,123,83,164,116,198,89,106,63,255,204,128,127,162,229,239,38,251,84,203,49,57,243,170,84,111,236,241,151,204,241,19,20,108,140,98,177,134,242,236,148,202,157,152,236,153,63,235,238,45,198,74,187,85,230,35,218,84,22,204,86,237,29,128,50,50,43,4,255,120,173,134,119,19,115,33,229,218,231,148,237,217,236,189,86,218,177,75,205,185,232,205,122,192,77,45,169,16,20,175,5,62,56,192,38,188,154,62,154,18,53,116,183,182,9,111,116,238,82,216,119,9,236,99,77,46,195,242,119,238,224,90,135,31,219,113,81,202,202,218,115,10,215,126,88,15,199,237,133,101,125,141,90,191,85,242,139,146,138,140,158,7,200,192,120,145,205,2,17,136,210,226,116,53,156,139,56,108,77,105,52,50,109,167,125,205,16,241,129,187,129,160,76,237,98,26,204,33,170,90,178,179,79,219,90,72,164,16,92,137,96,193,112,102,115,83,170,150,157,148,242,25,118,173,58,207,208,170,230,101,50,232,184,5,77,180,39,14,254,191,184,194,127,119,116,58,154,189,28,51,184,97,83,36,195,74,220,227,77,155,161,76,55,128,106,209,2,132,148,159,151,49,120,51,14,170,145,142,52,35,106,109,227,225,96,159,51,13,141,171,114,96,244,177,201,59,222,105,122,211,105,47,244,244,101,36,56,113,123,97,25,57,80,149,44,151,57,24,139,137,220,87,216,117,77,132,35,121,17,94,126,181,7,159,39,234,144,198,198,57,110,32,213,188,198,65,138,183,203,169,202,37,210,200,111,14,8,187,221,42,176,49,79,148,233,46,36,186,229,179,19,129,200,253,171,73,239,201,152,75,13,197,101,1,120,245,226,95,242,210,118,26,188,228,251,99,252,78,1,221,73,77,150,142,87,228,49,11,177,74,139,2,230,74,48,92,182,156,100,226,177,227,59,84,84,220,108,235,156,169,97,57,24,211,227,232,185,247,157,6,55,136,42,28,224,183,46,145,42,151,164,81,146,51,63,234,117,223,82,121,65,178,239,33,194,143,168,68,95,185,216,100,199,65,233,222,117,33,200,73,251,22,47,14,43,128,248,220,123,0,16,58,58,106,32,65,226,250,16,135,39,71,187,165,232,6,65,48,190,115,42,143,31,40,147,94,76,147,173,66,76,205,177,252,203,21,52,86,69,1,221,133,218,2,50,233,230,191,57,202,86,247,70,39,28,10,151,206,122,243,105,176,141,76,127,124,68,249,125,106,128,113,7,104,34,96,151,49,56,253,57,106,4,14,153,140,223,230,30,145,49,1,252,190,117,143,57,253,227,192,78,195,129,48,66,27,244,92,110,129,165,220,108,205,225,58,196,140,171,123,180,12,8,135,5,49,187,156,67,56,19,107,7,16,90,41,108,162,26,222,77,197,105,4,109,113,101,218,107,210,3,220,47,216,251,165,240,90,66,248,16,148,218,171,219,210,115,161,136,156,239,168,131,101,159,120,64,3,254,163,112,27,222,226,80,26,253,4,87,135,91,231,2,67,147,117,180,124,32,171,111,127,155,77,201,2,135,104,238,97,179,74,171,84,202,218,243,123,31,153,182,100,38,192,253,55,93,247,110,137,23,77,192,46,115,247,147,62,242,196,217,152,123,111,71,100,103,168,61,191,120,113,170,134,77,58,38,244,126,80,240,197,165,251,14,94,246,169,128,60,85,225,255,94,201,57,159,90,42,84,190,124,113,210,175,228,190,58,177,24,16,115,104,92,157,206,190,173,166,13,138,148,149,70,67,82,86,116,248,134,26,210,146,18,169,12,73,173,219,208,241,60,251,164,225,246,192,44,145,60,25,109,214,72,7,1,209,18,122,94,144,73,38,12,70,207,88,56,150,32,221,220,5,237,88,82,153,147,114,213,13,121,72,239,188,42,253,139,190,157,216,122,185,52,237,75,69,103,232,210,62,159,244,111,26,172,136,192,240,7,83,24,98,98,75,155,175,166,241,55,173,113,97,135,239,99,195,129,183,218,89,3,235,156,206,189,79,214,99,85,189,167,38,23,87,220,66,198,174,172,48,139,240,118,191,196,200,93,44,203,130,104,132,16,63,223,68,215,122,200,77,26,15,203,190,4,177,163,64,7,108,27,77,104,154,64,125,219,123,14,66,146,45,66,138,222,91,235,15,91,37,70,173,127,90,104,46,188,192,81,152,146,63,156,3,234,156,54,106,136,150,157,52,94,98,219,160,165,124,172,176,67,185,144,161,166,251,175,156,172,99,131,114,214,250,71,167,12,221,144,130,142,51,107,5,120,50,151,29,101,242,90,173,135,54,169,121,227,108,236,95,149,202,145,58,207,53,238,198,253,7,158,219,34,49,161,96,143,211,51,93,134,50,35,23,150,238,196,124,131,209,232,169,47,64,4,73,9,169,55,89,185,106,122,171,247,232,220,174,16,90,14,233,222,213,101,67,36,26,19,121,145,63,112,81,37,213,114,70,171,133,106,129,127,24,16,246,117,149,182,205,4,31,10,216,195,43,177,233,45,1,171,176,204,8,59,215,165,203,234,152,19,155,26,212,16,192,229,176,76,199,242,237,255,6,110,151,63,5,88,71,143,246,209,64,211,123,139,232,251,213,184,36,219,192,143,222,147,211,145,46,159,104,137,248,5,162,225,166,53,175,11,228,212,163,234,123,87,152,227,120,103,228,210,104,24,230,7,114,41,253,161,119,177,63,81,142,143,255,203,158,193,202,189,180,181,198,235,44,214,206,132,248,253,150,247,143,218,119,187,227,89,149,27,248,30,145,76,63,108,184,61,228,115,198,230,170,216,87,189,0,63,194,46,174,132,119,143,251,62,67,174,255,45,149,109,69,149,116,61,138,110,85,100,123,251,52,132,142,125,76,33,112,3,17,247,68,66,33,195,103,222,135,22,29,89,240,81,226,181,253,82,219,190,114,100,69,217,38,233,209,34,163,254,166,194,129,250,127,125,116,120,184,155,244,158,209,103,106,124,129,40,133,70,210,130,253,174,50,156,197,206,254,218,254,113,221,215,57,79,15,218,157,20,98,17,216,79,49,118,83,181,237,14,186,17,160,236,178,16,56,171,233,227,132,179,87,78,148,248,54,121,69,230,12,119,253,247,1,229,161,9,185,14,7,158,159,25,24,52,21,11,59,81,3,39,84,191,13,255,190,55,176,124,36,254,236,140,120,93,53,60,37,208,219,72,229,64,56,168,154,159,221,74,85,251,50,119,149,3,199,66,122,39,252,22,152,144,229,36,139,171,42,18,56,206,250,130,129,248,140,19,29,156,45,133,170,177,31,24,12,39,11,79,171,70,217,245,148,236,12,108,79,64,203,31,191,45,230,67,79,128,217,181,7,73,119,224,104,53,51,79,104,5,54,182,50,111,15,201,77,133,112,158,43,186,127,174,223,254,122,136,26,39,109,91,168,248,48,120,131,209,187,252,135,137,89,163,134,130,238,102,85,63,78,12,140,226,237,42,213,83,235,51,145,156,165,228,37,91,79,157,209,85,7,127,121,209,86,216,82,244,90,189,172,187,114,115,122,159,43,141,124,221,15,38,95,158,81,62,96,204,57,38,253,188,104,211,43,137,138,142,25,11,222,61,132,128,49,14,47,102,138,50,191,75,168,110,199,116,157,46,182,99,175,109,160,60,24,191,193,48,119,1,18,141,158,166,16,144,222,149,8,91,182,174,187,110,153,215,204,201,176,183,96,52,26,1,11,99,253,60,41,85,231,245,119,186,231,214,157,245,143,106,53,172,235,168,180,189,174,89,78,188,100,210,4,114,242,57,244,164,150,26,38,191,34,89,168,234,174,86,113,199,254,90,41,151,137,82,181,183,79,100,56,165,185,69,168,70,36,176,84,84,106,82,73,65,102,176,204,90,92,5,211,5,253,98,98,248,91,184,65,236,248,239,57,250,4,96,74,30,39,72,236,165,180,204,129,205,137,197,101,147,240,78,145,253,155,9,131,249,251,129,26,208,233,70,106,117,74,217,170,5,79,220,207,167,155,212,132,219,162,50,70,106,138,135,120,15,46,48,17,154,28,141,155,86,189,90,129,153,43,36,135,21,253,12,135,243,199,72,220,70,73,0,169,134,197,154,99,52,67,62,106,230,198,77,86,36,61,233,105,66,129,69,198,13,22,250,86,99,35,49,8,127,28,190,207,233,158,130,231,82,38,57,196,124,236,218,232,142,249,36,249,105,25,188,166,97,159,136,242,123,10,235,156,52,152,200,14,69,65,197,91,200,6,240,90,86,255,202,127,128,47,108,189,193,138,36,62,93,187,122,235,18,189,152,212,103,200,2,0,85,209,151,51,125,36,57,21,169,210,9,228,152,49,123,124,34,198,79,59,127,53,71,121,42,15,79,172,159,167,198,108,76,114,238,225,40,93,126,102,85,44,109,78,199,23,246,24,223,170,125,225,208,190,195,30,165,233,149,174,67,255,203,62,201,32,149,18,72,116,28,153,135,46,154,32,186,208,26,32,234,224,14,87,186,153,36,62,164,160,182,164,0,181,209,131,162,152,49,178,177,125,170,13,200,245,94,152,197,21,87,46,221,241,56,83,29,26,142,188,79,65,111,31,25,49,87,137,72,110,202,185,98,64,102,155,111,78,220,40,58,13,149,239,152,46,102,99,56,188,227,179,23,200,51,15,124,130,200,90,114,223,157,20,238,12,178,60,192,214,202,32,179,215,107,146,43,142,147,212,83,178,28,206,78,122,96,24,37,134,207,144,95,174,106,187,38,147,120,110,113,161,253,99,201,102,18,65,223,39,24,247,58,10,172,149,2,233,56,64,51,31,214,237,104,15,232,242,11,212,140,187,30,160,157,56,82,205,173,242,40,26,23,197,92,128,163,11,42,8,167,35,86,250,167,131,171,27,133,203,242,81,239,84,3,48,100,220,136,38,255,130,250,117,64,101,2,225,107,198,153,45,142,211,72,102,214,189,198,245,2,242,83,187,123,207,12,253,52,31,229,244,98,247,0,36,206,15,7,229,56,222,162,41,240,203,62,6,10,197,222,103,225,41,160,33,228,12,67,202,117,210,46,8,255,82,235,47,93,53,197,108,198,65,251,44,38,109,33,104,152,5,105,45,219,191,127,72,217,32,237,49,171,137,113,254,7,125,156,67,41,151,127,155,154,17,25,184,248,118,249,116,139,33,1,79,178,9,52,144,218,79,119,50,49,184,247,58,85,65,92,152,51,47,99,125,194,4,73,146,110,231,225,151,244,138,83,240,88,184,145,240,45,4,220,219,63,114,246,42,83,217,224,46,16,195,141,152,236,111,54,149,42,244,252,152,47,175,6,215,59,252,209,135,42,148,196,53,190,96,121,239,216,250,223,151,189,73,249,78,241,234,53,65,84,151,180,33,115,143,82,219,221,135,113,17,178,192,244,146,241,164,134,219,171,56,184,82,13,245,152,11,136,8,134,94,1,204,39,21,164,12,198,78,221,98,18,22,230,151,246,61,141,226,125,247,249,14,105,226,122,30,162,158,228,237,127,238,120,126,222,174,214,241,124,218,132,0,248,238,19,148,95,252,153,213,101,239,133,44,238,129,249,168,176,52,139,6,211,41,11,22,41,150,41,162,66,236,236,71,4,60,13,182,150,254,179,85,55,36,199,162,148,211,65,13,150,173,238,182,238,21,130,183,13,169,220,99,223,196,203,209,255,57,73,229,253,101,26,76,148,143,253,108,112,66,62,163,44,30,235,236,104,61,125,151,144,195,82,132,164,53,3,154,47,146,189,196,60,207,127,83,200,251,221,213,133,50,12,83,218,221,167,199,88,218,196,166,91,39,93,51,84,43,20,11,92,123,96,47,131,61,191,21,179,236,7,88,159,48,6,107,121,129,99,48,111,201,130,137,98,237,122,174,151,194,215,139,70,203,95,160,117,223,88,64,216,218,115,247,73,39,38,254,82,10,117,130,116,12,78,78,76,7,166,181,247,154,75,193,41,3,98,167,196,42,172,200,83,141,5,32,149,237,132,186,225,249,238,160,90,117,136,80,129,146,181,169,21,210,55,205,240,15,246,172,215,186,92,141,218,175,248,131,33,137,83,94,206,163,80,100,49,242,178,11,99,233,35,90,79,152,149,180,40,48,61,115,89,5,23,156,50,37,133,240,166,207,0,255,131,82,150,83,206,214,125,157,129,29,189,233,68,49,109,131,7,69,89,126,248,168,124,86,215,181,223,133,170,60,77,210,132,248,194,47,53,91,95,149,177,198,83,222,61,92,106,126,220,135,48,159,100,69,158,3,254,21,254,215,223,70,197,9,10,30,236,81,131,105,216,186,85,247,225,37,184,92,137,245,200,47,130,223,126,67,138,220,213,28,230,168,248,233,121,52,66,7,205,169,250,173,68,42,241,25,9,239,137,226,167,113,47,131,34,84,194,255,234,235,1,133,47,101,193,169,112,187,96,25,162,252,10,32,63,55,195,195,221,78,188,252,3,11,232,245,91,67,222,225,138,238,209,18,136,123,202,231,38,177,73,3,202,81,92,73,71,191,245,174,222,63,204,159,123,205,246,43,86,160,100,188,202,87,19,11,188,238,26,144,99,146,21,188,37,255,128,22,249,0,9,116,31,88,181,216,154,246,48,108,160,200,114,177,131,45,248,108,4,193,34,134,104,19,245,39,129,242,213,62,73,248,145,245,180,235,146,144,108,254,46,18,216,20,162,158,21,231,156,66,217,66,213,73,5,183,245,74,206,111,240,14,228,206,222,229,7,187,203,233,241,31,180,139,145,167,200,214,244,171,9,199,139,144,131,5,236,48,185,203,193,249,160,143,64,212,8,220,143,5,162,191,34,10,190,195,15,14,21,151,203,55,204,146,55,29,23,212,1,85,32,231,184,184,73,151,42,76,89,25,253,249,74,73,66,0,148,43,162,38,74,17,199,207,232,0,216,128,4,73,198,141,30,142,227,151,10,220,241,227,136,254,191,254,128,227,33,94,135,51,137,39,4,183,246,81,78,108,172,52,237,234,4,19,8,97,34,218,222,43,19,254,26,203,42,24,46,113,48,23,237,159,157,229,46,204,107,55,61,178,145,195,242,47,71,53,217,154,151,135,4,192,148,167,2,110,89,188,202,50,16,255,204,187,88,46,225,145,22,119,129,135,138,244,57,18,21,209,148,137,148,131,43,67,17,72,149,251,188,160,22,248,128,224,238,209,59,131,167,143,13,1,33,184,105,110,217,179,7,39,104,149,95,206,4,127,52,60,62,147,237,180,201,212,126,74,77,16,140,231,139,62,124,102,84,249,223,14,15,16,3,62,201,56,234,26,87,4,145,244,196,87,227,42,67,9,187,237,223,114,1,244,57,248,146,0,205,14,189,86,69,184,170,130,67,61,179,118,39,196,92,120,69,173,4,91,14,32,5,185,152,90,174,253,99,153,118,234,42,249,192,5,48,115,56,66,31,72,178,178,93,117,62,28,34,176,131,213,196,93,176,197,90,105,166,222,87,164,111,16,8,217,61,153,154,129,117,247,10,160,214,38,195,126,161,189,226,248,55,198,28,238,162,215,232,59,108,181,30,189,101,132,147,173,131,167,25,151,55,184,124,171,220,126,176,188,205,193,143,84,174,7,172,62,152,21,100,195,161,217,163,6,137,255,40,196,25,64,64,64,65,159,139,50,142,8,252,210,141,178,213,85,134,214,190,107,179,170,174,236,92,249,129,65,134,173,249,215,162,29,131,109,22,36,18,61,33,195,37,201,4,46,14,236,129,242,44,243,248,18,79,237,157,165,167,211,237,30,126,86,213,8,10,170,234,176,112,76,70,214,175,253,49,73,250,153,215,158,183,61,194,146,211,34,236,154,174,205,136,202,172,231,83,32,220,51,248,103,230,0,178,18,205,62,87,124,231,165,7,162,101,208,132,33,228,74,207,133,117,214,147,195,10,149,135,12,5,61,32,0,139,83,188,21,145,57,218,119,133,186,215,176,235,207,52,90,152,145,99,224,249,66,244,106,237,235,233,195,112,154,158,149,139,229,54,236,16,56,139,125,162,135,219,117,58,41,122,223,168,58,236,207,77,75,143,113,66,50,153,201,71,121,192,56,118,246,3,154,70,36,187,43,245,231,22,160,169,2,215,46,230,62,200,0,153,65,14,155,89,21,202,63,34,55,144,142,106,90,73,63,188,249,54,6,210,250,175,16,192,128,23,224,179,13,93,50,91,50,88,106,222,80,89,129,53,181,203,35,158,84,205,146,250,166,100,204,103,196,51,167,166,140,79,135,65,147,73,107,184,233,7,252,195,6,85,209,144,22,114,63,135,3,223,178,149,201,203,148,144,59,76,98,22,51,55,1,108,65,140,178,32,73,179,80,22,115,104,122,37,108,212,50,230,178,26,60,75,219,221,218,242,177,234,28,29,160,151,128,237,188,76,151,195,176,93,50,114,225,145,197,99,222,145,21,139,220,213,31,119,109,69,223,130,157,190,73,84,46,229,249,19,179,167,117,27,55,154,164,141,89,216,176,127,51,123,116,211,196,96,197,75,50,175,132,209,154,189,169,60,120,174,216,78,100,157,163,36,221,161,245,2,101,178,186,47,99,167,199,52,91,220,90,192,14,160,208,49,250,9,175,179,110,92,47,81,204,48,187,220,22,113,8,203,171,191,154,143,223,32,49,77,159,150,155,212,247,116,198,215,93,35,238,111,123,121,131,87,221,216,157,15,215,132,119,91,133,252,97,162,85,246,0,75,193,225,82,237,80,32,226,221,233,166,164,4,17,68,238,202,223,187,133,230,222,157,227,252,241,148,72,28,242,157,71,139,158,228,224,139,9,244,213,184,89,71,132,226,163,78,78,90,5,18,185,138,78,74,115,67,35,133,241,61,147,56,140,247,98,75,244,226,186,22,96,242,249,21,110,65,187,201,116,48,245,13,244,227,161,212,99,220,175,134,201,172,185,166,81,112,183,88,181,237,158,238,217,153,230,29,14,236,170,56,253,6,129,53,26,254,186,82,199,207,142,121,184,191,148,168,175,253,209,123,229,94,156,114,217,229,131,244,122,84,57,122,254,24,55,194,218,35,215,91,117,193,57,198,165,49,217,220,175,8,130,14,33,182,188,84,6,152,219,159,43,175,50,48,147,226,238,183,40,85,27,7,48,1,149,118,40,73,179,23,185,16,97,17,117,145,10,104,113,145,134,151,34,150,97,232,184,153,187,230,16,22,73,206,45,128,140,253,33,100,30,243,87,211,187,29,93,98,109,254,145,85,21,140,24,61,227,38,102,100,162,130,234,242,190,64,68,129,160,155,43,4,132,73,87,59,185,4,84,200,55,58,39,18,151,158,77,173,238,29,192,127,94,53,65,97,55,4,207,226,252,237,130,228,217,21,197,181,170,159,124,236,111,193,190,169,157,94,155,71,44,93,88,1,179,200,209,29,41,140,231,31,153,107,53,157,75,38,1,210,131,57,136,154,17,53,100,169,225,188,131,141,20,253,146,218,139,36,188,112,177,158,145,218,197,123,95,254,140,31,125,116,74,132,131,105,142,224,251,230,144,149,213,53,223,17,102,154,255,97,77,191,51,39,222,16,248,120,96,130,165,130,141,9,209,28,53,199,25,144,84,13,91,129,8,255,13,122,249,85,0,142,50,248,56,7,114,118,70,193,54,9,246,148,153,38,51,177,54,41,240,72,198,76,88,236,70,1,49,103,100,52,120,101,175,32,99,214,33,155,72,190,197,6,16,96,72,4,165,213,54,83,92,151,11,33,255,140,194,81,79,61,137,77,68,182,223,141,11,202,181,176,205,85,107,64,233,204,128,120,117,20,148,48,222,224,221,158,207,10,212,101,42,242,91,237,165,171,183,167,59,77,7,71,23,84,166,151,124,215,69,195,4,123,182,180,50,204,175,118,17,144,17,210,50,153,82,133,226,21,125,89,182,85,46,38,176,161,12,18,101,131,155,201,138,171,25,159,208,182,137,144,221,194,29,214,19,154,97,246,2,154,147,104,231,128,21,236,233,177,143,83,234,178,117,142,128,153,202,80,206,179,203,173,36,83,217,248,236,60,239,44,134,169,181,160,145,210,251,18,127,91,235,34,255,221,23,58,107,131,102,38,210,95,4,114,63,62,153,201,2,194,177,12,76,153,92,195,56,28,38,179,3,187,86,232,61,229,115,179,100,213,75,80,39,189,153,190,170,186,168,70,18,70,108,126,94,101,13,65,45,222,147,103,90,73,22,80,239,95,123,124,147,141,220,163,56,2,238,135,234,180,32,14,54,38,140,139,173,112,217,51,57,76,88,135,180,7,183,138,174,137,37,143,10,50,220,63,24,144,96,56,151,235,130,99,247,158,164,71,230,230,124,65,23,189,155,85,194,176,204,30,149,184,191,83,250,145,32,94,11,134,48,29,255,157,222,10,82,197,196,64,247,156,7,105,200,12,88,253,158,20,100,102,228,174,183,252,211,106,55,224,214,75,128,61,220,231,56,167,255,33,14,91,2,110,82,237,102,122,193,145,52,77,11,60,15,69,12,204,87,49,130,188,30,2,206,74,235,131,189,84,168,185,115,53,9,65,225,97,45,171,228,200,143,179,161,6,94,160,206,69,191,190,149,118,83,129,42,33,77,84,68,227,67,186,199,221,54,133,151,131,66,184,184,235,41,45,39,76,156,192,63,208,124,183,149,188,224,128,192,38,222,255,59,186,189,182,160,101,63,60,11,207,131,115,55,79,210,65,166,237,220,146,98,91,46,112,22,156,151,202,231,51,129,240,31,104,155,212,113,45,75,76,193,133,153,128,115,29,196,149,109,4,59,74,197,151,102,235,91,40,29,178,204,183,107,232,251,48,196,160,214,194,101,82,128,108,127,52,31,182,197,111,203,224,132,174,231,114,204,119,159,176,46,157,254,69,46,113,40,182,10,2,228,82,219,248,28,198,199,154,186,64,57,45,232,129,236,224,186,73,40,237,43,162,210,27,112,242,21,2,227,20,208,109,80,249,116,144,163,209,10,112,138,0,16,173,174,8,235,43,203,73,147,244,154,171,225,135,0,70,10,186,52,47,177,74,215,53,166,176,198,31,186,22,84,111,199,223,155,185,195,89,17,132,4,246,212,180,75,232,14,234,152,220,27,163,70,5,209,162,159,49,166,28,19,183,15,18,104,57,222,188,21,182,57,71,116,175,249,57,73,85,197,155,18,116,254,245,171,158,58,114,18,86,246,156,239,168,104,107,184,157,180,247,236,146,132,193,115,97,182,165,96,35,141,110,160,239,9,136,157,40,188,135,242,99,147,203,165,57,99,17,139,218,105,36,49,108,197,157,213,190,252,250,160,136,246,242,106,123,201,200,194,215,65,166,179,252,172,148,212,118,97,119,164,2,1,132,221,243,189,203,72,237,245,235,159,183,112,254,221,203,241,228,43,89,62,244,205,143,47,231,146,111,103,215,70,76,47,235,1,225,137,87,103,53,143,22,47,207,171,131,111,40,119,148,52,250,51,1,229,42,88,151,82,226,226,10,156,52,249,27,161,34,87,142,156,176,8,42,115,249,183,191,92,194,42,60,122,110,63,135,242,26,53,178,208,223,81,67,213,53,41,38,247,83,64,57,221,144,137,42,206,57,4,75,99,190,76,45,153,22,28,61,244,251,191,252,61,176,38,92,90,184,119,248,120,254,140,8,209,25,76,108,150,251,151,225,156,23,113,148,12,85,171,7,160,225,26,95,60,170,254,27,181,146,221,197,160,186,148,213,197,21,121,16,180,42,142,179,195,47,116,142,77,21,165,10,21,60,90,117,144,138,216,230,235,41,130,186,25,7,195,64,74,138,160,100,157,33,137,158,79,88,81,125,151,0,223,118,46,147,247,183,28,151,152,107,250,242,148,14,72,7,96,27,121,51,63,29,76,170,244,172,72,174,20,42,21,179,1,243,84,206,21,166,185,128,138,8,6,159,54,1,195,92,6,114,53,143,99,186,62,96,212,49,19,162,13,215,46,83,117,85,67,106,139,148,54,96,50,137,110,47,174,146,121,211,61,60,233,109,178,102,59,55,49,42,229,126,135,26,75,148,40,93,73,83,80,196,155,227,249,14,72,157,207,241,156,223,193,11,244,205,24,53,9,28,85,155,127,39,141,63,41,35,125,91,40,33,30,71,235,197,77,28,111,51,222,224,223,109,230,65,152,16,94,203,133,66,197,205,84,55,69,244,62,74,222,251,67,65,202,7,230,109,62,253,219,131,31,39,28,40,229,193,144,76,139,48,229,190,133,212,116,248,246,156,14,105,21,148,82,19,6,218,150,238,162,52,117,159,235,178,158,181,0,17,145,75,237,7,253,140,237,168,96,93,51,63,63,225,20,50,103,80,23,254,207,219,57,139,123,204,247,203,73,198,237,159,102,188,48,66,123,187,199,7,233,133,37,242,195,199,197,44,127,33,226,23,96,163,202,240,211,96,57,112,233,178,165,12,39,152,174,116,192,153,247,230,41,225,243,127,107,130,177,166,159,227,192,226,148,208,100,108,73,35,203,162,46,91,78,144,184,159,58,188,49,215,167,45,140,169,192,5,19,49,157,69,221,167,216,54,16,170,95,52,125,183,232,134,241,51,56,144,33,141,73,71,255,99,9,53,51,200,132,76,202,66,90,75,191,47,165,9,134,58,80,67,243,1,166,75,0,176,150,111,45,229,79,110,216,36,140,6,36,149,19,246,217,178,89,198,232,146,56,143,212,163,243,30,132,217,215,31,198,10,28,61,152,172,61,156,216,210,212,193,228,163,237,231,248,218,90,254,171,115,127,227,217,89,126,249,255,136,138,201,37,255,38,33,116,83,49,200,220,198,31,57,92,22,108,123,162,114,204,231,10,16,88,68,164,119,254,232,155,76,26,136,117,233,18,212,160,27,70,116,136,164,169,35,219,19,102,4,34,16,34,144,91,50,100,220,102,232,253,148,208,114,64,201,12,193,41,214,220,60,239,75,225,188,97,206,212,94,163,216,2,211,82,172,176,242,18,70,17,193,1,160,222,29,229,134,220,68,45,248,218,85,20,6,216,121,20,171,145,111,201,24,167,100,7,188,120,200,110,28,98,27,74,205,47,238,104,233,135,157,51,202,143,13,187,63,2,161,177,138,137,214,229,170,152,162,192,223,128,83,207,254,200,20,215,119,123,11,37,29,44,225,239,142,127,230,32,224,69,37,24,71,161,116,160,219,73,97,29,70,12,159,158,234,116,214,21,81,52,185,204,153,73,99,140,90,46,40,70,155,44,21,173,155,30,68,142,88,199,206,29,155,173,6,78,125,132,113,79,201,174,211,75,203,8,167,47,73,129,147,176,176,249,133,42,60,194,162,19,13,186,12,231,51,180,30,33,49,105,194,50,37,187,197,183,189,247,147,200,250,181,8,5,175,239,41,73,177,37,6,34,138,16,2,79,133,188,120,107,137,102,36,105,183,112,121,78,13,19,105,245,89,173,68,41,222,10,158,114,96,190,29,75,23,22,229,51,97,219,141,244,2,108,153,176,126,163,129,129,46,81,165,93,227,217,238,68,94,222,140,109,16,145,217,92,184,61,43,116,7,84,73,55,222,35,82,35,210,180,72,151,195,51,18,113,47,35,109,159,234,161,64,35,190,205,4,138,247,188,24,76,47,82,221,122,234,178,208,142,105,188,196,230,139,201,28,17,237,90,185,48,27,9,182,0,9,206,71,55,138,222,180,88,23,235,75,10,39,230,18,54,73,138,147,25,158,55,237,79,206,96,192,216,132,61,233,47,205,232,33,184,13,33,86,145,120,109,30,33,196,186,255,242,125,13,6,19,0,178,224,33,135,234,86,73,9,172,251,173,40,129,225,36,53,82,31,157,114,80,180,57,158,177,17,118,183,23,188,18,33,197,168,157,24,214,136,176,7,197,30,3,232,177,60,157,229,148,26,185,65,175,242,141,105,254,22,129,47,204,195,225,120,92,230,233,42,86,240,247,127,4,125,19,67,132,164,223,62,176,24,161,243,96,246,220,45,181,31,225,8,191,181,217,19,116,129,181,120,181,35,107,12,189,85,200,27,241,189,92,23,78,130,204,42,4,204,106,57,79,244,118,128,47,59,34,83,167,214,199,129,155,30,226,62,168,23,199,215,112,13,37,52,243,122,42,218,222,128,86,48,179,166,114,107,74,174,237,56,231,242,172,9,110,219,132,194,216,3,239,67,208,3,60,184,112,47,99,161,208,246,8,70,192,39,146,219,74,161,62,181,76,210,218,15,158,64,13,237,99,200,50,87,153,219,91,227,79,75,98,73,179,235,199,238,117,15,187,250,29,233,232,170,35,217,213,183,183,221,239,142,41,112,232,145,77,140,160,226,69,195,200,32,105,170,166,136,177,65,219,247,106,201,122,135,158,120,36,232,180,210,68,166,230,16,181,18,9,15,228,231,192,187,120,104,133,56,61,74,229,177,153,99,2,40,252,244,126,79,80,1,97,41,69,67,188,77,242,152,154,7,91,229,44,109,22,216,173,122,209,26,238,57,233,48,144,102,153,1,26,137,68,221,191,109,138,194,22,246,185,84,229,46,26,125,168,252,116,86,102,170,140,223,174,219,245,112,118,153,153,84,136,124,89,34,71,64,150,243,55,73,180,31,62,82,190,74,4,85,167,153,127,197,97,177,53,43,53,54,94,73,25,37,52,104,244,136,243,120,12,0,122,151,109,154,211,47,197,5,102,206,84,42,192,127,136,70,182,218,86,138,55,216,107,142,73,189,131,74,194,167,252,210,0,205,13,75,101,127,119,235,188,38,157,1,135,155,196,110,120,139,158,126,121,147,236,224,97,228,62,161,43,136,198,24,50,132,193,69,205,96,25,13,56,180,81,81,198,45,92,165,194,71,173,65,115,66,119,134,16,153,171,137,194,176,70,31,19,83,160,67,202,211,201,70,151,125,182,219,226,61,247,40,252,155,132,215,168,193,201,76,35,242,53,96,184,226,90,131,43,202,14,63,179,255,108,184,170,173,71,113,136,50,107,41,183,188,181,53,220,153,63,201,201,236,33,16,235,213,11,4,211,240,57,24,165,215,33,50,46,0,0,213,220,179,136,65,68,27,173,182,250,72,108,70,130,248,98,176,105,48,187,36,133,254,5,207,209,116,47,9,198,120,235,50,73,127,90,246,73,125,223,85,78,103,25,145,68,149,186,202,187,59,81,132,207,176,238,191,195,7,52,178,145,249,0,38,68,118,22,11,130,97,22,53,28,53,93,4,20,62,164,53,70,78,2,174,235,18,134,117,236,190,64,104,127,60,156,166,50,90,153,185,223,131,125,254,156,193,45,52,164,20,208,244,132,207,4,251,108,178,18,233,120,34,253,144,136,136,209,144,59,89,211,225,171,14,83,234,56,78,242,246,161,75,134,214,102,224,121,118,239,204,77,253,48,9,148,190,85,84,195,194,116,250,2,185,125,184,201,134,29,56,152,235,20,56,22,192,197,41,164,1,196,172,154,220,24,188,155,103,198,70,179,221,178,235,46,160,54,120,158,90,165,131,220,186,37,135,229,188,97,130,191,114,21,89,158,82,104,220,58,6,212,113,83,91,23,237,63,184,208,15,194,209,169,223,117,232,3,131,64,7,167,145,8,51,225,157,195,8,3,146,129,126,19,154,33,34,117,24,7,55,190,144,253,188,79,243,169,59,233,12,176,234,188,154,133,229,26,182,85,172,26,24,250,182,235,65,78,239,42,3,199,45,97,233,159,251,63,10,6,48,110,242,145,249,162,74,15,86,22,158,250,152,118,25,44,214,49,231,128,91,197,75,237,142,241,221,214,97,154,36,42,222,25,139,94,247,220,223,133,231,236,77,62,47,223,217,188,211,52,213,20,27,224,107,53,201,60,246,127,42,140,239,59,195,0,77,57,203,132,228,8,164,206,245,43,40,105,248,240,168,164,44,212,186,172,226,144,183,14,30,126,254,173,222,35,213,11,8,122,42,12,228,232,154,223,167,156,62,212,218,1,28,39,29,65,1,194,220,140,143,56,20,112,13,134,237,144,216,172,6,36,158,97,213,239,160,224,117,160,157,13,7,26,182,113,237,68,24,110,128,21,181,143,194,198,76,175,45,149,201,123,205,241,68,229,113,86,189,125,153,114,18,193,88,89,30,112,76,189,57,78,168,250,16,170,231,84,18,154,109,80,23,8,167,169,237,35,179,41,245,5,1,18,16,34,118,227,166,252,30,148,87,149,46,165,190,185,31,168,169,83,144,6,109,223,182,21,113,132,225,41,100,90,44,239,98,152,173,244,44,244,124,247,32,74,251,43,54,238,115,226,15,26,238,22,235,70,244,70,253,34,199,5,73,41,136,6,159,20,246,117,56,112,17,15,103,118,84,177,55,124,154,30,65,249,45,17,26,119,249,109,74,145,9,220,103,179,91,196,32,115,138,46,216,226,142,167,111,198,158,101,231,213,156,184,104,211,237,121,13,236,89,145,102,202,42,184,120,205,200,120,126,198,24,162,63,106,19,136,114,152,236,199,185,74,33,3,31,124,224,248,70,240,174,124,145,106,96,11,253,230,225,126,133,158,252,89,206,236,218,144,49,134,224,144,56,145,178,175,93,102,123,208,0,11,16,229,148,127,196,73,102,94,30,196,136,168,104,230,3,92,59,229,75,96,11,174,7,129,7,46,183,40,96,58,234,155,33,56,176,67,2,208,233,48,213,207,20,140,227,7,232,231,147,172,26,101,233,229,120,35,251,121,83,103,4,151,77,47,173,143,230,147,42,231,41,37,12,247,242,110,109,24,192,39,121,14,88,67,168,218,141,34,183,89,182,124,160,232,136,122,226,234,203,159,95,133,132,193,188,36,40,153,68,3,55,202,85,218,48,78,66,34,225,59,149,6,28,28,101,154,64,231,98,72,114,29,16,177,22,148,119,146,26,89,55,180,64,53,65,122,43,176,145,190,160,78,169,29,152,255,202,93,108,155,182,6,251,242,179,208,28,168,142,112,207,150,164,251,87,26,244,191,24,210,72,145,176,21,128,86,133,179,163,209,161,123,221,194,157,128,0,213,193,171,71,238,23,146,94,117,154,84,20,29,212,163,154,241,113,169,232,17,111,159,246,193,224,71,24,116,130,80,220,22,114,227,11,112,94,47,41,125,160,59,121,119,50,202,191,157,15,105,72,149,188,10,131,158,233,193,2,187,190,128,2,59,1,1,203,205,192,254,45,200,174,224,210,19,41,56,220,236,56,226,182,48,63,200,202,14,234,240,214,10,18,35,202,36,114,40,226,227,163,137,61,94,62,120,204,36,232,4,205,218,48,82,68,203,47,198,161,43,59,189,255,135,241,223,149,33,40,221,205,200,150,30,176,187,111,103,135,64,50,210,71,123,65,159,140,28,201,254,119,98,52,113,229,182,225,230,63,148,67,182,96,171,34,68,65,136,202,92,111,143,44,8,114,117,140,79,38,126,227,25,45,114,17,218,5,227,185,71,109,59,27,96,117,27,158,18,54,46,74,10,193,20,19,12,12,249,95,21,29,117,100,75,109,97,100,137,151,156,116,73,169,231,20,64,243,30,12,126,148,87,157,93,244,96,240,1,133,59,173,215,129,148,4,12,81,84,58,143,135,6,130,240,177,65,69,170,141,250,139,234,190,105,6,168,63,202,152,41,44,224,58,17,210,226,145,94,89,10,179,51,156,134,149,60,237,68,3,148,136,114,92,12,201,5,212,54,76,55,219,171,239,63,7,111,183,59,200,108,23,4,136,66,39,215,7,63,233,64,122,46,48,200,90,7,242,122,183,50,77,156,200,203,133,147,204,233,233,168,75,103,245,29,88,58,255,114,255,217,253,53,112,60,254,91,159,97,161,202,233,112,96,71,248,157,224,25,255,156,89,48,223,111,61,69,245,13,133,113,182,97,8,83,198,178,230,129,169,136,107,125,106,14,156,4,54,143,124,74,216,228,176,31,183,22,149,173,187,123,84,72,212,16,149,251,176,193,178,99,233,56,24,65,163,220,151,177,187,17,61,75,220,144,143,106,52,22,20,78,170,229,253,139,230,35,52,77,199,159,134,251,66,115,198,209,143,4,111,3,145,32,6,105,99,134,107,76,237,43,137,97,138,230,220,160,62,209,228,81,190,233,112,218,28,166,48,186,166,241,193,19,144,248,6,167,253,129,32,235,103,75,35,89,60,201,78,31,127,110,16,80,27,202,174,154,61,74,114,54,173,75,163,173,96,172,204,232,195,89,89,56,119,190,187,208,80,242,202,218,143,25,104,191,231,247,246,147,97,201,106,153,75,200,248,131,159,33,7,154,180,70,77,137,47,57,36,151,149,15,58,118,117,6,189,228,99,249,202,130,43,209,161,16,181,234,121,147,133,226,151,65,176,190,169,107,77,249,13,52,224,165,139,254,100,40,186,79,16,91,158,245,122,202,83,223,191,34,58,156,108,250,140,232,244,39,136,119,176,131,82,75,76,44,18,65,174,111,57,189,129,240,12,2,41,14,143,39,249,153,18,176,30,169,175,9,147,254,132,120,32,254,212,48,66,154,161,10,70,157,142,84,145,30,176,108,82,136,238,9,103,23,48,141,41,59,247,226,226,194,39,37,199,213,225,236,241,201,221,43,113,59,35,236,84,60,109,252,194,103,36,197,91,140,3,211,48,228,95,141,245,124,41,29,50,162,26,13,27,142,216,234,236,84,3,235,230,232,47,55,120,126,214,34,210,177,139,24,100,94,46,49,83,72,32,102,222,236,236,80,239,234,200,235,98,123,16,65,51,77,103,71,202,219,72,114,159,74,79,53,1,180,14,220,114,67,141,185,214,229,80,94,130,76,28,38,53,164,50,142,7,145,26,96,53,232,23,232,117,57,165,204,157,105,61,106,202,167,178,107,157,244,193,151,115,243,183,211,208,127,153,143,197,250,67,181,193,123,43,126,102,137,235,104,85,168,7,157,30,224,44,102,130,48,65,36,252,131,59,204,151,56,83,34,227,140,54,233,246,160,249,58,204,124,44,72,126,96,233,203,246,87,175,96,12,155,36,155,89,40,173,169,61,231,64,23,75,38,217,190,83,226,37,203,245,47,216,95,93,121,62,81,116,82,198,208,250,199,46,47,131,186,181,40,87,22,79,179,45,44,32,194,115,218,84,147,239,13,218,110,132,126,71,188,159,195,100,58,134,228,66,156,251,225,124,12,123,101,132,19,165,116,155,255,110,92,232,35,206,201,89,160,102,230,183,188,99,66,160,223,80,250,11,6,97,164,76,242,43,79,57,27,187,146,42,254,21,146,73,245,221,62,67,115,169,168,65,198,195,230,133,201,154,206,51,195,213,225,97,44,247,149,30,232,194,247,181,160,83,178,211,211,163,89,115,84,125,71,222,49,250,179,216,155,198,174,2,152,191,95,193,123,131,205,70,89,234,72,139,12,34,206,196,36,120,82,111,240,218,94,48,56,177,223,49,4,81,70,220,19,181,239,168,170,68,231,163,154,249,163,27,199,246,163,248,27,246,139,139,20,0,161,219,190,36,63,179,7,79,83,23,167,98,32,255,13,139,38,160,56,25,93,161,5,24,162,174,17,17,127,227,190,54,209,42,237,98,82,144,84,220,25,9,253,165,68,64,234,250,204,180,62,35,59,108,0,52,104,48,166,138,111,248,207,209,241,213,133,170,102,184,3,228,167,229,147,114,146,91,87,104,50,24,138,183,114,86,3,233,43,51,141,163,181,246,153,245,9,51,169,129,238,112,19,140,199,193,22,227,34,47,89,133,220,252,132,226,13,133,109,200,195,222,135,82,1,15,77,24,126,50,12,45,58,26,87,93,17,76,117,241,31,31,68,122,226,172,211,188,114,238,244,223,120,177,80,107,105,249,245,182,178,200,22,215,236,47,207,185,236,180,107,98,168,43,229,101,227,86,121,164,90,121,171,131,130,50,33,212,102,38,26,166,77,28,234,123,56,214,133,199,123,68,62,19,118,157,231,60,196,111,38,2,100,127,43,41,11,67,52,232,145,1,97,206,176,215,32,211,102,153,125,198,224,48,6,229,51,184,251,134,99,230,5,221,220,109,132,74,44,0,12,197,206,89,241,203,187,126,177,27,52,48,100,192,165,120,157,243,249,56,95,198,196,140,55,188,53,111,77,149,16,62,234,254,243,138,64,55,157,201,30,190,22,203,66,161,102,10,252,160,27,242,136,210,207,201,176,204,42,178,50,162,205,40,231,189,27,82,110,170,101,219,148,124,195,52,180,178,70,214,174,124,213,82,62,176,1,141,80,135,249,141,75,232,151,137,201,161,245,164,21,82,23,220,125,205,143,177,81,149,66,218,95,209,157,151,227,246,196,164,41,31,16,1,116,75,48,219,135,73,11,110,117,178,62,199,230,0,211,219,154,91,165,191,106,65,162,145,35,22,200,253,106,102,249,200,221,155,224,196,223,35,238,123,248,137,46,87,224,40,199,82,22,236,86,110,7,95,196,85,90,219,70,178,125,220,116,236,3,212,76,178,74,140,23,1,189,63,129,93,32,247,148,104,65,223,136,194,87,136,61,105,118,61,182,232,90,7,207,202,241,77,37,125,186,86,3,48,9,92,231,166,154,61,106,172,11,228,91,135,145,189,120,2,175,32,153,133,71,147,61,193,169,14,116,167,68,148,217,107,212,101,238,104,118,64,172,106,19,126,224,104,158,79,131,146,229,77,108,183,251,154,61,190,119,14,47,181,107,37,57,42,69,70,36,180,9,133,216,188,242,132,153,162,33,62,198,255,240,89,4,211,235,253,222,237,243,71,42,34,144,253,185,157,163,3,112,153,16,61,36,237,216,46,188,198,11,150,33,63,234,212,140,238,220,54,250,224,19,204,171,150,97,12,54,126,33,142,91,178,99,24,48,100,241,176,219,209,245,50,146,100,220,178,147,2,237,136,243,174,44,90,205,220,239,179,255,147,205,150,98,161,30,149,127,36,62,193,238,60,242,29,69,129,247,245,175,24,64,225,5,194,227,172,90,225,50,24,172,33,207,107,147,24,53,84,108,203,202,2,84,47,224,101,56,58,16,187,130,18,114,245,36,84,90,33,160,16,251,137,81,44,51,175,224,63,155,17,72,145,173,184,236,29,141,205,35,24,206,98,228,73,216,178,33,169,47,13,39,67,175,89,70,109,98,153,223,16,1,79,73,186,161,27,57,141,189,63,71,40,188,87,255,54,25,210,245,85,231,92,179,48,76,96,172,231,64,87,53,82,79,235,101,57,136,233,101,101,50,30,56,150,210,3,84,107,38,50,67,234,17,166,72,90,220,148,31,208,20,97,73,120,217,97,187,34,114,237,115,80,55,44,21,166,67,174,226,79,5,37,168,209,124,15,245,94,35,159,174,252,234,120,223,6,77,23,86,118,155,100,250,22,71,246,240,230,69,205,8,92,46,238,182,114,244,249,121,178,75,22,138,231,241,193,216,211,140,57,41,173,162,252,230,188,176,137,200,5,68,190,72,178,12,173,205,2,252,246,72,240,13,71,13,9,27,65,56,10,84,65,251,33,170,128,63,151,31,210,145,76,92,226,241,111,253,90,28,70,65,213,155,35,42,125,70,26,36,25,46,156,64,218,0,135,65,234,137,145,100,91,71,221,55,223,176,205,233,169,40,150,67,189,181,35,242,176,76,191,86,99,116,183,41,227,111,242,5,219,81,179,1,163,133,220,119,54,199,205,194,232,120,205,111,136,220,101,81,115,98,160,99,129,70,221,128,148,35,98,194,205,134,205,177,68,161,162,133,102,0,166,181,198,242,130,152,110,162,238,179,212,237,107,218,248,252,221,15,225,122,173,46,159,208,9,157,41,230,12,214,204,168,194,211,129,94,197,2,178,90,125,2,169,125,162,79,34,24,39,203,60,85,16,213,180,10,55,232,137,0,217,209,61,204,52,195,184,148,50,75,229,35,56,226,185,218,224,218,161,71,53,150,46,13,219,13,159,86,74,214,236,12,208,231,56,127,82,229,124,22,74,235,174,84,120,142,51,213,107,204,150,214,166,121,79,252,19,146,49,40,222,47,169,239,0,136,29,95,161,142,227,252,174,117,20,19,157,235,97,212,101,179,213,200,63,40,215,54,28,229,148,198,94,70,143,203,220,225,131,16,79,206,59,62,209,203,239,61,52,170,244,235,212,238,28,114,197,56,216,220,21,41,129,110,90,161,188,77,19,31,162,227,137,19,236,153,255,177,248,140,225,79,207,172,237,191,208,45,204,65,230,162,151,218,207,29,147,100,73,62,36,52,27,41,22,192,64,170,202,128,59,54,198,43,177,110,251,195,202,172,135,179,100,97,141,24,207,244,212,2,91,94,65,244,210,6,219,8,40,110,17,67,197,51,243,8,36,245,178,40,140,39,245,40,156,244,60,113,140,138,186,53,250,223,144,53,40,42,237,11,56,180,124,64,186,54,156,119,186,227,56,182,151,228,131,6,65,129,248,11,110,122,127,54,129,210,170,60,80,97,142,95,177,6,236,201,64,107,240,18,126,230,102,7,49,172,213,20,34,230,65,76,64,11,77,179,64,83,81,65,189,80,146,96,194,114,151,249,53,17,132,154,20,188,179,120,59,100,136,168,206,93,52,194,178,189,173,213,19,128,50,240,75,188,250,137,216,142,181,189,57,119,157,38,122,27,20,57,132,59,193,181,19,213,174,50,38,46,194,213,198,52,74,132,84,63,196,247,101,154,127,194,157,75,215,126,163,239,126,64,109,222,126,228,52,71,222,98,178,120,161,78,205,118,215,56,14,78,197,74,63,224,21,80,217,198,90,14,79,106,17,13,58,0,190,145,125,105,107,209,247,105,215,116,43,254,118,204,230,69,201,65,246,62,88,144,63,44,149,132,5,236,115,254,188,58,132,136,145,238,39,28,237,61,168,151,232,213,195,36,105,36,246,145,146,27,155,222,220,182,20,174,115,160,18,157,103,160,67,141,136,63,99,53,224,211,229,202,199,38,85,123,81,207,93,143,254,185,166,100,141,20,131,19,108,164,19,161,252,176,21,48,239,55,95,12,153,186,144,42,163,39,173,242,61,12,240,225,118,1,159,224,46,15,128,223,71,178,28,134,91,13,54,162,79,230,110,115,99,127,162,170,12,231,231,52,33,236,52,193,36,235,233,204,50,234,193,204,189,106,67,79,30,254,48,141,159,40,83,90,53,115,131,156,166,48,91,194,141,55,29,221,172,132,144,122,190,243,149,19,227,154,126,114,110,211,180,220,72,158,5,34,16,230,171,237,221,185,42,19,17,84,63,93,87,238,88,168,189,75,196,110,234,68,231,69,235,106,200,47,230,106,230,201,132,179,20,236,126,130,155,143,165,164,239,52,105,134,45,1,197,235,169,93,254,155,175,29,175,183,29,51,140,32,238,198,128,172,31,10,17,158,166,57,112,18,93,230,191,159,104,81,143,29,72,140,168,52,41,172,43,248,190,188,191,38,61,95,148,75,200,175,103,241,61,177,85,70,110,64,59,6,196,255,16,63,38,144,125,77,56,190,229,127,78,97,148,68,85,25,253,184,166,205,6,38,58,59,93,60,136,202,217,241,217,3,92,175,182,132,99,49,223,9,80,46,187,168,207,176,215,5,229,39,250,155,146,56,234,226,15,74,193,135,242,59,45,21,149,73,0,91,232,89,196,58,11,66,74,28,248,204,120,198,141,143,2,110,240,221,219,219,208,226,159,28,103,53,117,164,129,12,184,110,62,232,45,250,222,242,116,171,172,55,104,227,63,222,160,138,174,244,30,86,251,43,99,152,162,60,159,208,201,59,228,60,169,4,110,36,70,64,74,253,65,208,229,146,243,246,131,34,214,197,76,114,42,246,156,118,26,250,180,191,162,240,248,180,67,213,86,78,208,245,47,30,34,205,81,100,158,185,44,251,151,205,130,74,54,183,21,27,117,14,189,100,15,175,229,138,76,36,53,66,194,145,63,151,7,186,223,20,242,142,227,169,249,158,209,97,43,14,199,255,27,148,101,219,146,93,165,35,51,244,181,21,151,216,194,188,75,162,162,202,43,141,153,84,88,172,127,223,93,40,143,97,132,235,46,153,166,168,86,68,41,212,62,122,170,202,132,32,56,147,136,173,170,160,183,57,148,239,165,15,81,98,248,196,129,126,236,210,91,126,96,33,220,79,61,120,137,253,129,193,145,209,102,210,230,244,201,163,146,19,134,212,249,252,62,251,211,154,26,87,154,19,26,98,167,221,170,9,227,229,2,89,208,218,193,10,161,10,161,126,223,106,50,106,40,65,143,124,197,3,112,64,39,72,176,235,62,253,116,209,46,25,180,217,190,252,96,2,17,55,96,222,198,90,16,50,239,27,129,216,232,94,237,136,68,89,169,189,50,73,39,76,214,73,50,81,51,138,158,11,236,125,117,87,69,190,54,173,229,201,80,244,38,0,85,214,164,64,44,146,236,26,36,193,222,37,46,8,201,210,226,129,218,117,73,158,204,19,104,150,94,151,44,72,19,7,164,204,54,215,54,110,114,2,135,222,242,224,53,244,55,146,221,80,58,83,190,106,81,32,216,100,57,216,28,228,70,96,237,26,36,211,250,57,133,114,236,215,70,219,172,186,84,103,207,29,249,238,212,133,176,94,161,175,237,21,220,178,65,160,96,112,53,120,36,10,73,128,76,239,251,37,115,38,162,52,115,209,33,176,94,48,36,212,236,84,134,194,171,13,76,181,120,48,52,10,149,66,88,113,111,62,174,206,196,15,51,132,224,238,192,155,96,5,96,65,89,175,142,206,138,123,229,30,183,210,7,157,32,215,72,49,140,12,54,10,120,208,83,211,22,59,120,80,89,145,38,214,96,34,235,42,220,88,128,218,245,193,221,140,14,42,20,146,213,37,5,114,15,5,169,59,212,100,183,41,3,253,217,230,204,196,70,43,80,57,61,128,123,140,53,254,70,18,216,217,66,68,90,50,217,180,98,209,163,209,33,168,192,132,162,129,95,192,2,57,253,240,65,243,206,148,240,157,207,237,41,72,30,177,106,178,171,141,234,249,21,155,156,208,184,125,216,134,147,206,33,97,73,77,194,104,148,88,169,121,68,120,111,137,242,169,109,121,131,157,132,210,24,248,198,185,72,90,208,193,106,246,197,174,173,146,58,92,164,3,233,47,213,138,194,29,205,224,162,230,112,147,232,147,22,14,243,212,174,129,233,51,199,10,102,150,174,48,167,21,5,243,204,134,2,145,115,50,219,166,127,118,158,35,19,178,36,195,239,76,238,229,203,23,173,118,117,253,131,225,126,64,39,121,3,107,178,94,60,29,89,61,108,22,6,11,253,16,231,46,255,10,2,76,215,24,228,176,70,61,173,198,121,51,215,80,133,94,48,204,121,20,133,240,72,219,42,111,37,162,230,244,32,70,44,250,179,12,33,230,216,16,178,119,6,0,231,221,138,197,153,102,142,38,197,93,16,99,151,186,118,113,72,191,110,101,215,162,90,67,70,117,181,128,156,203,145,228,147,247,179,189,5,137,190,78,130,251,163,118,36,138,65,241,56,214,247,204,79,218,11,155,184,207,196,176,11,79,219,254,56,229,226,53,210,95,191,182,248,202,146,111,213,16,227,158,185,194,65,72,167,184,83,190,57,171,191,178,44,245,209,13,8,30,193,132,26,82,207,109,152,184,124,13,151,88,129,9,232,124,8,172,130,159,179,172,207,223,4,209,127,92,189,13,34,34,158,237,161,240,237,52,157,69,178,139,146,230,62,123,218,37,151,146,88,65,241,231,56,233,151,195,204,139,219,5,50,73,95,50,94,86,208,190,133,80,91,163,85,93,65,107,105,196,105,216,72,120,200,52,255,131,126,32,45,72,218,50,216,177,108,197,54,120,77,229,221,43,91,188,251,208,222,58,176,251,3,241,128,209,152,22,225,56,191,227,38,66,12,48,42,49,129,90,253,131,130,132,216,33,154,85,31,98,242,251,238,163,32,36,221,137,94,247,72,138,64,3,13,208,45,134,32,12,241,17,166,11,55,112,211,240,91,14,167,69,242,26,172,134,226,237,253,146,81,21,89,111,52,111,243,64,100,174,139,198,216,35,74,130,170,167,64,192,138,71,56,67,42,189,255,38,6,216,106,39,197,213,191,143,51,195,216,180,11,55,110,114,169,159,20,176,209,147,177,52,148,220,147,190,22,70,226,132,66,246,35,206,78,80,22,132,92,37,214,43,209,129,60,80,41,179,193,5,108,20,33,95,248,217,52,170,213,169,34,77,67,49,251,78,172,86,108,248,128,80,236,155,193,176,34,3,66,4,70,82,193,255,87,194,199,2,244,169,194,10,177,37,134,37,188,172,108,169,3,82,93,137,155,173,124,167,155,70,160,137,67,105,144,247,45,213,164,38,216,39,220,233,3,54,252,150,192,79,42,156,130,92,75,137,151,63,213,101,143,157,202,8,167,194,127,171,28,199,94,23,237,239,128,170,86,52,103,229,45,113,46,0,158,21,165,43,208,132,15,249,46,130,230,174,206,178,174,249,91,64,220,182,106,144,50,105,179,245,186,237,117,186,86,246,62,71,16,253,20,92,162,147,212,202,226,247,175,114,91,209,9,143,234,79,180,89,78,192,214,116,73,53,79,216,242,91,190,125,132,62,163,169,201,100,175,64,222,4,166,154,171,94,254,65,94,143,220,197,12,211,241,134,209,98,7,239,166,226,126,14,7,126,219,148,58,10,6,214,182,107,53,241,154,115,120,155,218,69,42,58,172,21,24,23,34,197,79,99,76,255,148,46,194,103,89,172,84,4,137,202,168,195,31,242,235,132,70,228,188,52,93,9,98,189,125,26,114,144,4,8,215,179,33,166,106,65,43,189,138,193,162,236,154,200,0,184,88,144,25,255,255,3,207,186,93,249,19,112,235,60,208,43,91,188,122,217,205,34,217,144,111,168,25,135,134,28,0,14,109,138,45,46,231,200,0,211,10,9,5,142,247,131,41,220,21,47,209,127,60,175,51,105,73,211,93,211,114,113,130,121,103,123,253,148,80,84,235,7,47,230,76,69,75,136,184,112,219,67,238,219,215,78,59,92,167,13,97,12,10,220,246,73,87,74,191,23,156,36,74,213,212,46,28,12,111,75,84,178,142,233,251,11,104,126,148,92,151,71,240,161,70,148,214,41,138,11,170,213,26,84,210,175,132,56,98,121,166,47,19,204,17,246,207,50,238,244,207,138,1,21,194,8,228,116,144,124,33,226,49,76,240,70,131,28,8,207,85,235,52,102,163,134,177,196,122,45,254,8,131,156,114,121,205,166,20,244,238,124,121,81,250,74,68,30,232,239,245,247,149,110,156,148,34,74,192,68,244,81,179,142,83,252,250,243,42,229,116,71,90,57,9,137,156,112,122,142,177,114,147,204,229,52,212,91,145,99,144,218,243,138,195,1,250,69,40,19,55,52,136,5,219,181,113,139,121,247,113,60,75,131,149,9,59,16,170,213,147,150,42,94,23,243,146,230,206,137,62,186,206,191,7,240,248,156,97,52,175,90,8,165,32,163,155,57,48,184,32,73,52,141,104,91,168,80,157,1,51,170,153,91,59,196,186,247,52,10,11,66,19,149,111,133,246,127,44,24,180,9,255,144,28,42,180,138,98,196,88,37,155,214,119,38,4,205,178,110,39,72,181,192,61,173,52,74,205,10,183,236,8,70,112,99,189,145,161,98,71,239,1,124,100,132,79,177,115,223,50,90,218,187,129,30,124,196,248,49,245,160,176,122,202,149,137,101,140,228,72,77,32,190,172,152,134,47,28,120,218,77,109,190,174,34,138,236,149,228,88,231,80,248,85,249,135,236,70,219,178,70,28,25,133,75,94,198,48,186,18,132,207,18,253,208,235,28,213,118,27,99,220,86,177,128,83,74,86,8,136,135,217,61,34,184,179,78,103,68,166,139,139,151,225,227,127,191,27,102,41,145,82,103,250,232,35,52,67,94,15,163,108,211,30,38,40,191,209,217,64,115,104,107,246,221,59,40,183,201,7,166,156,11,37,88,162,134,140,47,184,87,210,31,152,13,30,128,181,101,5,110,110,185,155,24,193,30,113,110,96,196,78,117,76,83,152,95,15,234,147,128,18,182,129,195,236,191,165,240,216,160,236,228,213,226,100,98,4,171,161,65,85,62,155,65,247,170,156,46,192,30,141,228,9,165,216,18,253,92,192,210,158,33,237,247,244,55,10,231,16,59,210,63,83,36,45,248,146,150,202,33,68,59,10,79,153,5,111,192,32,153,59,196,96,10,132,86,32,187,57,165,223,187,116,104,154,59,166,209,70,84,109,119,18,135,154,203,92,55,31,146,69,58,127,251,243,218,22,111,223,106,195,70,80,92,214,91,0,165,105,156,188,185,57,107,176,203,73,211,241,89,169,238,22,53,126,31,137,198,228,199,166,228,183,150,20,199,187,0,30,252,136,136,43,79,205,252,45,137,53,182,210,200,14,142,14,248,135,242,63,137,24,145,96,8,226,179,56,119,25,164,252,51,247,75,93,112,30,129,29,165,192,75,197,165,239,115,48,134,187,218,46,78,52,90,37,65,195,89,15,158,58,82,211,26,158,52,209,188,16,71,175,246,77,115,84,173,97,213,77,69,10,133,198,43,114,198,43,38,103,59,202,31,192,208,227,20,252,197,150,63,121,166,230,160,228,86,139,120,125,148,157,62,220,27,74,154,160,176,140,11,146,10,135,145,162,40,215,4,99,113,223,184,207,106,107,67,211,249,79,87,222,212,18,52,113,145,38,154,193,218,22,115,148,164,165,212,169,151,21,162,253,121,92,222,60,157,199,68,224,66,12,206,81,107,172,221,96,19,71,225,251,1,140,243,0,124,164,178,196,34,27,135,98,137,1,198,59,11,238,234,85,129,110,177,187,84,46,11,126,35,131,184,65,122,149,235,94,152,24,80,53,115,58,252,20,81,234,99,33,123,184,133,234,222,107,30,179,77,185,207,13,200,112,2,98,158,195,119,216,162,103,31,247,66,245,110,53,197,41,14,179,10,178,53,138,229,197,192,179,56,247,51,74,74,185,13,208,196,217,205,232,77,121,74,64,116,200,242,123,109,141,197,7,229,74,82,104,177,237,197,175,228,128,154,13,38,199,193,161,220,156,66,100,144,19,218,19,25,155,121,172,131,161,118,214,196,231,43,105,81,95,221,164,96,203,133,238,90,236,139,56,59,9,214,18,110,41,155,146,20,81,220,6,91,255,204,165,150,231,112,131,179,168,135,4,237,47,113,31,97,24,0,155,245,159,234,171,190,142,86,29,26,61,122,136,187,137,107,91,68,145,166,10,3,207,75,173,107,172,151,21,52,96,29,76,20,142,137,119,210,119,142,127,169,215,42,26,70,246,65,73,116,138,53,10,210,102,68,25,33,116,67,201,186,227,90,160,29,85,80,192,109,116,73,132,5,233,137,36,118,138,74,250,130,114,151,50,94,174,71,123,172,122,42,41,123,139,53,201,106,232,239,210,177,22,163,168,55,253,254,158,73,133,91,212,20,53,116,209,105,43,196,125,0,109,24,241,212,193,194,47,20,116,200,238,248,52,130,54,247,110,41,246,196,81,254,250,191,88,49,117,52,218,75,240,153,4,229,17,71,63,249,27,254,196,44,87,209,112,96,31,101,32,40,50,207,232,99,163,163,147,126,17,201,251,46,70,218,194,94,75,102,115,119,116,54,107,246,228,102,205,140,38,77,201,239,53,207,120,54,20,35,45,195,214,145,150,55,92,185,50,48,218,186,74,196,92,82,233,238,62,151,65,155,125,109,186,21,225,165,222,210,98,117,155,224,151,203,187,98,104,167,145,135,187,32,16,254,156,33,183,112,147,41,136,94,38,200,83,7,10,170,65,188,146,218,169,48,232,67,191,4,182,129,192,239,7,25,120,10,78,89,238,177,219,188,148,77,249,112,130,205,255,185,2,44,4,117,63,41,213,61,74,135,80,52,115,32,183,173,9,83,208,237,53,218,98,172,248,178,232,13,152,248,167,168,68,187,118,230,177,231,78,8,154,140,248,2,109,221,40,92,231,180,232,211,23,23,96,174,215,101,6,167,35,223,71,172,86,189,177,179,0,38,146,60,224,191,88,132,139,93,140,92,179,66,250,72,82,219,31,180,118,24,186,119,95,120,218,13,112,202,141,116,245,191,145,157,28,182,134,246,80,138,125,4,172,115,255,205,125,112,100,35,82,113,95,2,53,123,188,188,188,112,51,96,54,231,154,179,44,174,113,103,159,182,2,63,45,199,159,250,166,222,8,24,50,204,130,237,93,137,141,3,11,151,179,235,69,94,37,196,2,27,207,152,207,254,30,194,9,104,145,217,7,250,13,228,219,102,125,129,150,28,154,51,8,66,150,182,164,187,157,165,9,56,121,201,127,224,139,232,28,33,171,41,68,8,29,60,20,174,255,45,24,226,58,34,146,208,165,227,3,48,230,209,1,138,210,210,71,77,163,71,120,145,29,145,237,6,164,97,67,152,107,100,246,33,201,226,130,245,53,114,62,79,18,29,152,228,192,51,69,154,85,65,53,37,105,210,33,30,151,206,208,172,105,180,39,14,18,168,108,189,28,187,159,145,52,57,110,151,107,42,236,184,58,1,150,76,215,193,193,155,120,218,192,162,237,158,166,183,73,154,77,176,24,81,168,241,130,111,236,86,195,213,229,68,72,109,206,90,82,82,122,50,81,77,67,132,111,77,46,231,15,137,58,204,64,228,14,90,39,133,66,242,71,196,229,96,151,196,223,243,21,105,96,139,169,35,11,63,200,167,232,229,246,156,102,250,204,145,30,216,32,154,96,169,160,252,101,65,249,90,65,132,43,75,74,127,79,12,58,67,0,74,168,70,252,72,141,253,229,150,7,226,105,3,113,245,254,136,21,63,38,146,242,220,195,94,91,61,93,49,123,67,61,89,82,155,220,198,17,109,241,142,4,22,174,41,37,66,186,9,170,158,186,12,88,250,195,101,165,20,254,28,133,64,2,107,23,179,115,210,80,158,100,90,183,5,211,101,74,15,197,69,20,22,91,157,158,188,107,238,1,14,232,136,153,238,39,74,243,166,161,171,131,234,230,107,1,102,139,169,95,242,122,181,227,183,121,36,163,227,137,40,134,121,19,33,110,208,101,26,5,183,167,238,101,139,234,8,174,146,141,225,200,105,230,198,17,161,71,61,156,48,75,93,207,7,112,150,159,26,204,120,51,153,69,177,35,113,37,10,186,215,69,144,58,246,55,110,198,253,235,97,125,21,62,159,225,164,233,74,54,7,76,172,29,138,216,88,57,132,3,16,126,143,162,231,27,234,222,227,244,88,61,178,127,25,213,243,121,248,54,129,189,92,5,113,144,96,99,75,77,187,26,254,81,110,127,226,123,187,244,196,76,75,16,220,57,244,182,48,49,104,84,34,221,137,24,48,202,201,243,37,77,78,33,206,14,7,83,69,73,116,88,199,26,33,182,166,70,126,231,202,132,172,25,35,243,242,217,226,242,162,149,132,211,247,220,34,86,98,2,109,202,131,132,46,253,193,165,126,193,58,0,29,245,117,62,249,150,23,179,241,38,132,44,217,69,114,43,179,111,168,152,125,207,120,78,237,33,41,172,123,49,72,152,20,39,66,219,45,120,177,88,148,180,108,53,66,255,95,46,93,229,90,127,43,212,254,227,210,68,180,60,219,95,207,165,131,23,1,25,209,106,70,217,24,235,249,238,189,186,81,225,249,197,142,33,81,110,77,193,186,245,51,10,249,42,252,116,126,41,118,113,38,213,67,173,114,73,29,58,230,133,125,154,167,59,221,234,225,243,7,218,49,56,17,237,100,37,159,28,17,152,120,77,33,28,5,163,241,40,111,255,220,216,195,92,240,193,111,230,226,236,58,161,56,192,91,236,84,104,3,43,33,97,127,203,44,31,29,31,78,74,125,172,188,100,58,10,72,137,95,89,0,20,106,57,93,101,174,108,109,109,130,215,220,222,227,80,226,213,129,120,21,235,246,58,250,123,12,105,185,246,4,131,32,239,70,98,102,197,84,63,53,218,44,11,154,99,53,49,190,75,56,115,156,189,2,171,217,174,36,83,114,204,23,245,145,71,222,202,31,190,101,191,198,159,207,5,238,82,183,250,118,218,236,53,103,160,76,42,169,130,126,29,50,60,184,104,174,213,231,155,30,216,53,16,212,200,252,115,190,152,21,110,204,74,54,124,182,146,4,82,219,192,126,210,118,48,136,249,104,79,96,97,98,197,218,245,83,212,157,27,171,249,58,174,158,206,146,253,5,159,200,226,175,91,250,243,202,114,45,235,153,185,244,19,166,78,194,5,71,39,87,88,208,112,167,245,208,176,215,105,31,63,59,149,107,246,199,119,96,247,240,58,199,62,111,221,233,99,216,80,209,108,17,23,21,99,130,183,248,49,14,6,22,80,204,34,198,238,51,187,227,120,65,22,75,61,27,104,121,110,119,207,198,113,131,10,57,219,103,207,145,96,146,15,15,109,99,250,194,151,159,115,168,136,176,158,4,171,144,74,162,188,199,74,108,165,172,42,46,12,208,6,155,50,221,202,109,251,105,138,182,176,107,235,213,217,48,250,172,201,96,233,143,186,87,249,135,26,13,91,15,168,181,190,207,216,27,223,216,21,52,22,188,83,5,200,208,253,78,9,136,20,41,147,135,114,137,175,230,212,0,108,197,108,45,100,139,190,220,136,50,74,171,112,200,18,245,168,3,68,228,234,26,26,157,103,104,63,24,77,26,251,139,199,59,100,26,229,166,73,4,27,163,224,57,45,75,144,47,60,151,56,49,239,248,147,67,108,242,198,216,106,94,203,189,155,84,41,78,56,247,55,11,48,75,122,83,36,193,18,120,68,25,36,85,77,33,213,164,54,221,8,65,104,57,131,153,18,139,163,237,127,153,124,185,61,240,229,86,150,183,182,253,173,152,239,26,153,153,168,255,80,220,51,49,149,88,64,167,178,214,237,84,63,148,174,136,78,204,239,214,56,103,221,54,72,215,44,102,41,146,89,217,138,191,153,219,167,4,198,55,27,88,69,42,61,148,44,123,41,33,14,83,22,155,162,64,132,193,20,65,220,131,96,207,229,6,207,36,16,237,121,167,168,95,26,204,125,24,53,248,230,36,156,148,181,36,101,250,42,153,147,194,248,242,61,111,246,73,75,232,230,200,122,108,54,125,7,53,21,128,198,67,190,253,10,121,203,87,129,243,198,253,17,108,207,27,94,12,79,54,11,184,161,52,70,252,52,109,163,114,183,60,115,56,57,80,19,10,177,24,180,36,123,85,0,228,239,112,233,137,80,240,62,248,244,222,38,188,81,201,6,185,239,246,71,57,94,246,157,139,5,249,67,3,166,109,24,179,2,210,81,231,73,36,232,14,236,155,141,214,254,122,109,48,229,185,114,216,155,126,193,43,25,18,245,97,128,113,203,165,237,136,232,201,98,126,174,13,157,201,245,194,252,220,155,134,96,162,87,138,69,103,35,156,83,184,89,187,187,169,118,116,53,177,109,219,249,157,200,101,209,115,51,192,217,153,27,55,148,60,103,232,222,183,116,196,141,242,58,23,206,94,93,234,178,190,167,234,223,131,57,95,253,146,197,31,105,61,21,51,72,208,180,124,110,30,52,252,120,197,153,35,17,55,118,157,137,155,72,245,57,24,100,110,245,132,173,67,255,235,63,12,218,152,156,59,129,78,216,5,230,27,26,82,214,188,99,11,73,127,24,106,24,60,215,152,187,151,92,120,65,150,25,24,173,154,242,53,156,223,250,232,104,112,65,165,232,16,232,34,18,92,27,90,154,228,23,233,46,115,219,134,167,100,86,237,210,62,16,92,225,152,41,144,138,90,199,229,59,199,153,228,144,145,85,251,47,20,107,216,213,7,136,206,19,146,101,152,63,150,238,85,89,24,84,253,111,31,93,98,89,247,163,184,13,87,120,66,48,45,113,7,56,90,61,91,140,253,111,227,196,31,166,92,77,240,199,8,33,41,22,104,249,35,117,228,4,52,183,94,232,58,74,191,56,116,137,246,198,45,66,167,88,38,126,198,209,33,250,184,250,28,148,114,43,183,121,94,207,21,244,216,61,10,118,238,239,210,245,185,166,186,32,205,152,39,135,90,9,160,88,159,232,232,86,215,10,1,128,154,98,232,120,117,197,241,196,195,89,240,57,23,218,76,199,176,137,155,151,128,29,60,47,112,177,138,22,63,122,187,162,169,119,209,19,10,212,91,13,44,108,253,255,104,104,166,198,44,96,234,78,126,52,20,192,98,157,31,60,224,151,174,39,170,0,63,220,200,250,119,209,160,130,198,204,162,237,160,188,88,11,187,8,93,233,230,8,229,43,180,217,187,73,126,73,184,50,158,84,210,232,159,87,151,170,250,189,61,196,61,32,154,210,122,216,200,253,31,80,210,103,104,162,123,48,161,155,88,228,12,209,185,83,93,36,183,79,169,66,111,222,56,142,30,13,227,78,83,97,178,232,205,245,95,201,202,93,95,143,8,118,105,251,144,234,85,238,224,232,100,228,91,123,32,119,114,186,106,172,165,124,27,66,188,169,73,150,167,12,191,213,26,65,60,150,133,40,33,142,23,116,129,214,161,144,185,179,162,66,147,174,105,218,204,179,246,54,226,217,150,215,253,156,212,161,120,172,221,118,233,141,251,146,30,49,211,179,239,120,247,170,193,43,10,2,4,128,143,175,129,185,38,174,241,34,176,3,102,191,29,110,216,130,203,118,21,164,183,164,220,173,242,124,37,90,23,97,6,155,102,210,165,241,145,220,191,240,155,69,92,240,191,61,89,16,255,180,6,237,183,84,217,187,134,167,181,252,182,34,36,69,50,194,43,205,72,174,151,207,207,57,132,110,152,198,28,134,195,179,182,14,142,245,146,59,110,173,229,162,58,87,197,236,139,170,203,130,20,196,195,33,67,166,238,214,72,206,222,236,55,166,206,94,59,211,176,245,251,247,161,23,0,26,37,241,56,113,175,90,211,11,41,90,180,66,198,242,209,158,152,63,183,123,5,152,30,195,84,112,57,234,134,153,33,111,82,240,244,0,70,136,36,69,100,32,187,33,150,93,62,138,151,50,153,11,35,35,7,230,19,196,65,39,179,133,188,34,69,110,113,151,76,139,14,135,89,14,81,166,85,122,144,10,198,139,160,168,159,132,84,24,153,131,49,182,16,4,185,207,5,168,108,130,31,205,253,99,148,164,206,211,183,103,219,178,112,158,225,49,91,232,157,1,77,142,244,188,253,188,132,56,109,203,133,177,199,255,151,67,36,191,192,26,123,132,159,105,103,69,159,48,181,131,190,45,167,164,47,229,13,47,62,217,165,11,233,70,126,10,64,89,141,13,144,68,87,28,131,156,144,200,115,200,246,10,153,113,58,192,104,253,131,165,228,92,87,202,203,246,123,237,77,19,211,151,224,152,39,128,215,249,155,59,243,67,10,51,231,232,13,34,235,243,179,142,230,238,142,3,96,31,178,157,233,198,150,170,3,222,96,182,13,75,4,54,84,177,31,241,120,77,161,93,216,165,213,162,43,123,183,83,116,234,250,134,19,73,42,172,242,217,110,197,12,245,31,53,171,167,100,53,59,159,163,222,252,80,150,33,147,196,25,193,11,97,144,192,96,166,121,22,3,89,141,88,192,126,235,1,214,202,235,180,158,229,0,100,72,237,236,21,84,246,80,156,149,58,6,20,160,113,21,132,162,159,225,20,125,10,66,19,134,149,215,41,39,86,11,19,24,147,255,100,143,84,201,122,20,214,47,249,79,248,84,242,114,171,228,213,141,151,19,242,217,51,129,97,248,176,55,195,220,152,12,234,78,240,207,110,55,143,165,10,234,208,188,91,102,149,0,174,214,204,249,38,78,208,146,239,88,37,139,14,63,95,234,33,144,56,157,87,8,247,106,145,37,135,111,55,150,169,147,149,4,246,155,138,233,7,238,48,90,50,209,133,98,94,12,240,49,4,92,67,254,177,184,11,61,79,27,183,8,228,63,163,21,43,210,121,209,198,219,68,238,19,204,25,152,248,202,125,119,103,163,112,171,75,123,80,178,206,176,10,57,101,50,159,121,107,33,218,57,155,101,216,76,219,205,66,42,222,29,168,189,4,55,59,131,175,128,143,122,45,219,95,1,213,176,156,98,150,45,124,30,129,96,200,171,12,198,95,179,76,163,79,184,45,134,123,165,88,141,20,190,86,212,252,185,148,49,111,56,232,17,241,20,88,191,0,99,232,165,14,61,230,5,51,100,135,161,32,22,234,24,8,91,74,81,103,22,123,244,233,244,248,60,67,247,121,198,150,253,109,128,156,254,47,52,245,241,43,210,160,110,8,137,36,114,32,115,16,131,53,215,59,127,52,106,87,240,222,104,44,98,70,6,116,132,129,28,253,227,111,74,190,242,146,254,60,218,183,177,89,250,4,176,4,234,221,42,237,109,180,237,202,36,48,45,25,198,178,200,131,136,191,19,32,249,159,96,30,159,232,84,237,243,127,12,76,160,42,88,244,193,172,125,210,100,86,108,254,139,124,168,20,44,181,45,4,105,33,43,55,201,181,3,6,60,135,66,253,44,52,78,33,217,18,200,127,94,119,188,34,78,40,1,239,59,115,7,34,254,41,222,242,39,78,105,240,95,10,206,137,167,54,196,206,166,170,115,16,177,72,94,1,39,142,108,228,187,131,170,127,152,68,109,52,18,248,60,154,221,45,153,158,66,157,61,110,182,25,193,148,119,134,248,144,225,99,214,146,94,71,84,31,247,31,70,150,1,173,55,62,237,245,51,134,172,126,65,122,106,90,176,150,245,4,179,107,128,233,230,63,115,52,145,90,150,206,15,114,252,208,186,21,41,214,47,203,185,174,198,30,181,165,253,246,48,135,177,201,128,16,11,97,103,31,103,114,195,13,247,227,117,241,45,126,180,122,199,173,28,152,222,15,60,110,194,87,230,194,248,42,185,228,197,64,226,149,11,225,12,178,3,225,3,201,246,45,3,67,168,34,105,152,44,31,0,92,133,174,46,122,0,104,5,5,81,64,225,52,130,218,94,157,34,92,188,209,128,217,247,80,61,88,197,39,14,4,147,72,2,25,66,203,208,2,25,238,44,121,73,189,121,91,218,145,97,109,74,240,85,156,238,186,102,92,59,232,75,252,142,53,184,33,56,59,8,145,132,184,129,173,25,119,93,138,137,20,53,201,7,102,65,134,134,194,43,203,35,196,86,32,195,170,232,41,60,244,41,150,189,87,27,34,11,136,144,135,178,240,144,152,218,216,43,244,187,195,12,46,169,129,126,33,121,183,15,151,59,245,252,108,234,251,163,124,100,79,136,247,151,186,29,8,61,228,225,73,179,165,40,244,21,13,23,78,194,15,147,66,96,229,144,41,24,113,117,183,180,120,249,228,112,42,159,180,242,97,37,28,124,33,168,7,242,205,197,175,73,150,148,145,67,249,102,174,41,144,249,70,161,126,141,23,161,68,249,244,221,19,81,8,123,205,115,237,252,189,147,253,83,200,85,147,36,75,228,4,210,44,102,214,59,222,14,125,185,91,123,20,216,2,95,13,180,94,91,149,37,154,183,6,222,208,17,100,7,148,164,45,236,198,27,30,78,3,157,211,208,73,130,249,21,63,137,43,111,92,183,124,114,39,133,194,13,249,251,169,204,153,182,11,228,101,136,104,210,156,195,207,100,122,201,254,88,231,78,61,96,93,204,59,212,159,71,43,150,185,214,128,85,171,244,172,163,167,224,239,214,141,69,150,184,220,180,142,220,196,222,243,3,240,19,248,89,38,255,48,208,180,80,213,25,94,225,7,201,228,27,23,89,25,23,172,215,147,88,114,91,66,69,82,253,173,65,186,33,83,83,175,151,27,51,173,56,56,236,169,246,87,236,223,61,55,202,22,90,207,159,214,106,255,1,44,248,148,249,56,114,249,179,93,84,157,223,54,194,96,48,94,214,251,141,179,162,55,50,98,40,233,169,150,123,229,188,214,170,174,120,242,20,193,198,217,6,149,43,69,86,230,222,154,69,113,202,215,76,85,134,99,248,111,253,76,63,51,109,179,134,38,53,111,59,218,179,61,111,48,7,9,48,208,120,182,212,136,152,238,104,129,119,162,29,144,45,186,181,43,74,50,109,149,204,93,165,202,210,117,156,119,233,43,160,41,210,186,13,243,78,250,204,58,56,120,61,94,164,189,201,13,138,93,118,38,235,159,52,188,231,149,203,92,129,228,66,100,222,71,155,119,149,87,252,102,246,81,228,113,13,85,21,106,201,1,102,36,203,229,223,78,162,210,21,4,211,234,234,93,115,198,191,91,82,86,77,83,248,104,80,227,246,129,86,40,7,195,245,49,84,182,244,174,155,199,61,53,234,168,133,131,121,249,196,197,125,57,216,132,203,226,142,191,95,198,134,34,33,226,204,141,64,169,116,156,30,233,133,219,140,78,169,8,252,212,238,63,72,69,148,153,213,123,53,220,191,2,89,26,99,139,60,178,52,110,30,55,95,234,1,75,148,7,119,53,27,112,54,193,10,234,5,238,24,248,122,215,21,236,198,89,86,162,232,236,13,76,142,36,206,159,92,224,42,55,180,145,159,101,95,126,67,207,62,31,133,8,119,12,60,196,130,239,249,227,71,36,158,198,96,113,88,35,75,251,105,197,188,20,88,51,130,34,126,39,183,204,145,191,1,18,109,24,25,194,161,239,241,31,180,34,211,184,100,13,193,13,138,112,30,216,159,46,108,181,118,219,40,238,231,217,172,119,246,23,199,69,128,62,194,189,114,152,251,26,95,20,219,75,30,92,166,80,40,74,211,152,115,53,161,38,145,245,235,43,206,50,246,206,94,69,68,15,199,115,231,0,19,162,73,51,204,5,227,110,228,66,79,254,14,140,115,41,61,190,199,180,86,130,232,133,46,48,230,57,55,98,224,49,34,155,199,21,227,80,37,75,220,215,121,31,202,148,100,90,63,48,66,21,42,253,111,220,36,134,3,25,235,179,112,181,68,191,132,18,56,128,134,196,58,89,234,56,92,2,156,178,28,189,192,83,153,207,38,179,223,4,214,203,61,21,215,114,154,215,60,197,43,18,234,15,94,209,93,214,242,220,124,11,230,250,44,212,144,127,194,133,119,242,159,190,203,28,201,115,77,219,77,47,16,250,135,158,174,221,111,19,47,255,181,240,229,179,141,83,200,254,121,255,55,172,70,99,13,126,97,182,195,33,40,117,63,111,104,117,67,106,225,199,194,199,81,162,106,133,36,132,125,212,79,60,235,152,23,40,119,15,15,180,15,6,23,52,29,224,52,211,142,172,87,51,76,230,210,151,163,124,54,22,149,9,46,41,75,112,158,171,62,33,114,43,44,5,59,184,158,53,170,113,9,11,96,182,110,233,196,62,216,69,27,196,161,111,212,142,198,232,176,236,165,50,48,51,40,216,8,110,7,60,32,76,247,0,159,175,170,24,164,70,7,45,169,1,13,112,35,114,69,60,49,219,30,223,18,234,86,108,127,252,149,30,71,126,194,107,7,96,20,161,214,137,162,183,175,103,76,167,244,143,176,188,58,120,124,115,218,148,169,150,97,247,223,151,102,76,46,44,23,135,14,169,212,10,121,242,21,107,237,147,23,11,83,251,3,90,235,226,183,56,254,240,122,8,14,180,152,159,27,249,105,10,182,136,35,178,24,71,185,44,191,49,42,163,254,20,8,15,166,132,42,249,48,184,64,162,236,174,114,20,184,254,101,144,18,91,77,131,253,232,161,160,28,238,65,17,30,207,21,111,249,254,85,78,214,45,61,163,81,157,157,87,50,254,241,189,108,32,157,13,206,71,130,88,227,85,198,209,205,50,17,34,229,140,60,133,189,128,42,152,127,105,54,120,232,108,228,186,114,161,62,239,254,187,14,19,13,5,144,14,104,12,131,176,171,242,34,148,136,3,47,183,131,124,89,159,2,32,250,73,146,214,93,5,214,57,244,217,113,151,94,120,155,208,153,99,10,229,83,13,206,48,126,25,101,101,205,180,23,127,173,189,135,131,149,225,76,178,173,224,237,240,216,243,199,157,37,242,50,68,201,110,146,129,8,132,218,210,220,203,142,16,28,208,2,59,19,199,100,211,165,23,92,66,36,62,222,236,221,19,3,155,80,233,100,185,246,11,10,205,115,60,101,116,59,253,114,206,49,165,33,158,31,65,219,217,127,77,27,54,58,165,6,248,203,177,48,29,224,122,39,120,175,36,208,107,146,107,5,232,203,39,58,225,62,156,109,218,27,89,190,10,96,176,41,7,97,8,225,73,222,150,27,141,99,231,27,158,12,20,239,33,58,34,131,198,39,5,53,226,83,60,141,63,9,63,248,140,45,41,116,59,1,35,173,54,63,242,228,241,99,4,2,238,165,57,154,109,91,20,45,239,125,168,42,90,66,178,203,111,37,128,0,73,163,153,38,18,214,184,206,104,33,146,20,178,20,153,3,45,28,114,190,123,131,166,36,29,200,191,74,122,208,255,67,124,242,109,20,119,240,28,76,68,195,115,43,190,111,236,148,82,110,117,191,115,193,83,174,38,131,54,156,224,21,191,173,208,66,232,170,227,196,175,166,106,0,18,130,77,190,84,85,213,160,27,83,188,67,153,210,195,112,221,148,125,235,44,53,182,166,212,165,41,202,40,164,237,57,135,87,41,151,131,141,226,42,206,84,202,156,101,214,123,215,59,251,231,46,149,198,110,211,40,96,80,67,104,146,206,35,130,184,75,133,157,181,186,6,12,43,247,180,12,111,162,11,237,221,219,146,11,124,112,114,118,153,205,157,93,23,237,110,145,212,231,227,21,233,241,105,71,0,249,135,62,210,162,184,66,33,200,78,233,72,108,232,70,93,41,186,50,51,25,123,197,145,210,37,249,23,143,106,84,87,4,115,179,96,189,144,25,218,27,123,145,134,67,241,21,3,196,144,99,131,106,231,193,110,245,111,91,233,1,214,153,168,124,78,238,8,178,111,179,184,195,212,245,226,9,64,58,45,111,93,246,205,199,103,129,110,25,65,241,138,72,132,83,252,187,102,114,86,62,129,208,161,41,126,123,152,207,79,195,42,146,169,161,43,220,141,195,107,95,118,36,1,118,102,249,100,202,117,119,0,203,141,32,122,44,7,196,76,92,68,199,26,189,22,20,242,184,141,59,45,146,225,183,238,25,4,162,122,104,208,140,205,246,192,90,43,161,14,112,61,15,19,46,11,164,109,82,33,6,95,70,30,127,59,64,41,82,135,122,10,39,5,34,43,4,203,42,49,143,171,180,129,157,56,50,169,147,98,221,211,94,166,119,240,39,152,80,68,28,4,234,87,8,178,195,19,155,28,237,212,66,181,91,114,158,133,194,31,213,104,81,84,91,134,198,173,9,76,102,70,85,32,153,10,98,132,76,88,156,43,158,38,19,243,247,80,237,183,35,45,124,156,126,123,104,46,240,47,118,168,0,24,63,152,198,47,169,95,50,120,208,164,249,32,172,125,195,219,173,226,84,114,197,174,28,180,3,11,108,245,222,180,13,185,142,58,176,43,5,130,189,122,202,30,156,75,10,238,225,139,194,167,21,1,22,241,86,154,45,134,16,186,154,152,123,214,51,97,166,49,214,141,57,66,151,114,185,175,66,192,13,173,204,192,24,165,191,81,63,81,122,13,180,70,119,197,3,62,254,115,103,24,123,216,25,220,98,255,123,36,170,204,60,50,135,243,81,132,208,79,219,239,15,243,124,49,150,141,80,220,65,161,214,180,145,152,215,31,53,113,196,136,75,89,29,240,27,212,55,221,216,78,231,150,2,8,193,135,183,240,110,130,113,240,148,104,14,253,43,74,91,226,179,102,205,165,232,194,91,173,239,25,175,231,255,203,99,21,232,246,148,94,115,43,245,81,102,212,183,106,87,201,73,46,95,82,229,134,99,175,97,22,69,96,134,31,62,111,97,132,202,12,254,40,169,13,207,219,181,222,239,35,175,31,26,182,245,5,238,217,152,49,80,115,249,46,77,112,40,96,190,30,162,95,119,64,112,201,182,82,177,218,228,85,47,57,51,255,154,198,165,226,65,55,193,94,121,196,133,146,58,86,91,68,126,240,165,199,61,76,248,64,23,241,25,95,55,90,92,95,214,190,185,46,233,59,195,42,204,37,237,178,88,42,8,154,106,112,184,91,151,186,76,102,21,39,101,145,131,80,97,98,91,195,181,39,172,209,187,163,245,161,201,154,182,54,122,89,241,198,149,162,255,1,50,225,192,223,13,247,98,250,228,47,68,6,236,240,225,48,0,153,16,68,204,255,227,219,26,84,25,90,245,177,241,62,172,142,193,245,10,184,45,0,31,53,165,209,32,63,133,228,214,208,57,197,106,195,144,158,104,116,4,127,121,216,188,231,223,16,214,35,224,102,126,227,54,237,54,26,251,39,245,38,126,178,13,145,150,233,181,231,113,24,14,241,215,167,214,226,188,230,112,214,13,250,192,228,128,41,135,3,211,66,10,225,114,132,110,115,207,94,246,27,2,197,186,124,129,200,148,65,250,206,213,75,175,197,25,74,62,82,222,117,247,88,224,144,35,88,47,96,222,125,78,2,128,222,18,204,82,246,171,103,39,248,31,194,140,82,157,221,223,13,63,203,63,158,135,204,39,42,14,191,144,245,114,194,186,89,146,253,20,153,158,55,173,107,23,7,14,8,58,196,229,181,137,29,87,42,62,173,238,60,79,233,69,45,145,22,118,50,133,47,165,23,216,199,38,165,216,62,78,13,81,47,249,22,147,60,193,29,147,248,232,19,178,109,172,111,245,124,88,233,140,230,132,98,129,197,83,254,232,154,66,28,183,93,166,185,9,153,228,229,190,221,51,99,54,132,68,38,156,205,40,76,205,167,94,90,132,196,152,237,63,152,240,100,79,23,122,237,20,150,163,62,149,186,143,59,218,135,19,107,20,146,46,53,6,247,182,35,142,79,75,209,168,57,184,8,109,199,150,220,15,124,45,33,116,132,29,20,51,219,206,36,23,237,240,154,141,140,88,136,175,28,248,4,39,44,250,81,32,168,35,28,219,215,55,98,33,137,2,199,153,249,26,57,85,54,212,124,146,129,206,12,208,39,245,19,191,133,117,88,161,13,161,217,232,3,194,110,146,23,212,13,211,172,49,164,219,157,136,31,202,20,173,95,169,38,190,14,3,253,110,55,231,172,233,36,85,117,120,114,147,168,99,161,178,168,151,72,12,50,27,50,66,170,147,123,141,43,160,20,143,146,149,183,99,211,125,213,189,148,241,6,35,33,85,22,195,205,144,17,210,216,133,211,225,203,19,99,95,151,224,101,52,150,153,159,127,180,48,24,237,177,241,37,70,212,200,126,82,178,44,160,151,44,210,152,112,21,221,253,78,38,251,116,119,52,235,113,237,157,113,4,33,44,253,125,65,173,135,72,24,54,110,130,104,178,153,182,79,133,107,163,98,233,96,0,90,191,111,234,174,224,82,198,50,250,122,52,198,205,104,87,78,8,123,31,163,203,142,91,22,27,236,107,155,221,159,134,114,26,116,40,174,157,29,18,64,7,244,154,37,95,19,157,57,159,22,125,217,139,154,67,215,246,178,133,114,174,27,129,213,213,224,219,52,125,230,138,37,101,11,124,43,144,245,178,62,86,127,38,91,159,64,171,225,225,189,180,113,205,5,94,160,95,133,244,6,195,152,189,138,95,151,238,101,16,240,94,153,114,82,165,81,4,3,159,80,153,181,160,176,135,206,72,219,33,160,250,47,103,94,126,1,209,164,192,130,38,52,27,107,109,2,241,74,182,73,107,22,116,199,17,23,162,74,15,86,250,217,99,7,116,167,210,148,117,127,207,82,209,181,241,151,54,5,254,97,204,113,178,10,79,37,252,209,206,153,215,190,15,55,246,211,110,226,230,18,133,4,174,5,101,206,111,13,217,81,168,101,148,184,176,38,183,97,192,142,12,224,86,120,130,183,218,240,115,28,84,101,46,27,140,143,61,130,98,81,63,14,154,64,194,131,132,226,35,111,204,77,55,145,145,232,10,13,68,247,243,209,208,146,179,147,190,126,248,220,116,219,179,17,168,25,177,207,220,5,216,18,241,182,95,155,149,113,48,85,30,18,49,161,221,211,3,159,17,19,81,5,54,189,87,38,80,91,119,6,163,109,254,126,0,71,108,242,54,83,157,140,3,81,251,82,219,113,39,142,211,4,2,250,192,246,120,19,74,180,88,202,99,13,136,114,85,26,116,134,255,190,247,229,72,225,191,174,221,185,102,238,240,184,5,151,121,86,238,197,255,123,255,241,187,167,243,107,86,255,32,56,108,161,99,15,93,56,191,221,111,186,250,206,80,24,142,167,28,16,91,162,214,234,82,212,88,46,78,3,243,45,84,180,1,181,102,29,30,43,67,187,175,237,47,19,122,128,52,31,94,92,105,236,245,126,195,97,44,107,91,144,190,141,254,222,114,123,125,3,166,87,10,123,38,247,225,148,252,162,202,205,171,246,132,94,170,67,98,157,209,90,201,90,130,72,139,166,91,111,210,8,180,88,230,227,89,109,1,169,148,14,189,64,63,58,70,125,131,63,110,160,2,117,97,226,131,110,234,3,100,80,123,113,159,249,240,20,169,44,53,75,227,178,241,215,167,43,29,210,112,164,249,96,35,56,127,197,216,99,148,100,60,169,253,32,104,102,243,85,153,179,195,134,97,117,239,58,187,44,224,156,104,51,208,124,162,233,219,152,189,148,195,171,23,88,234,223,40,105,254,37,61,69,210,60,179,167,71,162,106,215,97,150,64,168,137,139,70,123,92,88,108,166,173,190,130,130,54,141,242,70,133,185,55,184,26,135,127,126,78,176,65,10,100,213,87,8,207,25,230,53,194,50,240,54,28,208,46,11,33,192,49,140,3,222,188,28,10,78,161,137,57,157,180,141,211,58,37,166,47,28,134,140,182,46,58,176,47,190,176,38,19,189,208,60,234,102,43,89,234,75,13,219,59,107,102,113,235,19,18,162,182,122,86,224,57,188,146,149,168,137,135,28,61,75,75,208,153,76,12,159,231,210,18,3,236,250,247,173,233,237,105,56,27,214,233,135,7,48,60,33,88,215,179,150,38,79,62,240,92,218,249,229,175,168,248,152,23,149,252,253,156,219,154,240,147,158,173,187,122,138,180,247,205,176,194,229,100,36,223,56,230,166,218,172,164,165,26,121,206,106,209,192,100,26,69,157,141,255,60,5,71,251,100,84,75,9,147,138,42,224,14,91,68,129,214,58,225,90,17,125,188,160,2,60,109,92,115,102,17,80,83,192,194,184,252,173,52,86,21,254,208,34,136,55,75,81,132,194,185,70,83,146,104,94,24,135,188,79,95,145,57,28,16,123,95,13,242,13,226,76,72,95,51,109,9,18,0,180,25,85,13,106,64,2,211,85,28,208,235,227,71,216,209,200,58,218,208,227,46,114,76,80,59,204,36,29,152,249,163,48,22,80,236,105,17,175,90,23,71,140,176,154,96,225,4,165,14,90,149,148,80,130,221,184,28,115,31,24,78,78,246,152,234,10,51,65,10,169,17,176,245,144,207,31,94,221,55,249,253,155,136,220,14,103,82,243,122,52,166,101,36,73,235,34,217,77,144,215,42,241,52,7,205,198,122,217,159,89,42,250,196,236,100,14,109,231,61,82,12,33,148,10,120,34,168,230,97,37,180,109,99,88,163,200,17,29,140,253,152,85,129,58,22,8,100,249,191,82,149,56,173,56,134,182,191,83,163,63,14,44,198,112,174,84,137,185,206,112,168,240,128,35,8,119,136,36,14,106,39,246,144,35,40,100,152,251,8,18,67,95,23,11,100,223,87,111,151,205,7,251,51,117,116,161,12,145,6,246,21,132,117,63,227,11,140,24,196,14,97,240,144,252,132,100,136,187,141,21,183,35,215,90,151,126,75,121,40,131,196,237,192,18,141,104,32,114,171,60,36,106,170,125,241,19,167,184,113,231,135,121,195,247,201,28,122,189,97,243,112,44,81,93,172,168,110,183,181,48,141,76,5,118,67,67,184,145,119,9,245,152,56,60,75,109,125,76,244,239,56,126,120,123,92,184,51,187,108,117,93,126,181,166,103,235,26,80,88,146,7,0,84,29,35,81,139,116,213,24,127,3,62,225,85,110,250,107,239,20,134,121,46,87,81,117,212,91,144,4,165,239,208,47,105,163,95,153,254,170,110,17,120,124,227,36,30,225,177,101,178,40,141,190,141,23,51,180,204,6,194,197,59,228,12,193,186,47,77,125,41,30,55,232,167,128,136,219,89,161,216,189,152,191,73,26,172,171,118,178,180,64,7,163,61,218,151,144,49,200,75,10,246,193,135,222,245,29,90,101,241,43,87,105,9,200,133,75,73,192,103,118,168,107,43,106,160,205,51,165,168,28,11,252,90,131,129,238,126,136,10,145,200,12,172,236,91,92,87,202,164,10,202,83,42,250,40,27,105,176,218,84,170,137,46,74,147,202,248,62,150,251,71,86,11,133,97,236,92,166,18,39,106,214,72,113,150,56,3,57,188,219,212,87,155,105,28,217,215,134,153,119,237,171,13,176,45,199,223,186,203,180,255,205,67,9,213,185,92,45,255,84,49,0,106,166,195,193,115,35,161,163,94,132,46,60,134,7,63,223,56,135,103,16,36,67,194,87,45,62,244,253,146,201,114,124,136,255,190,102,28,91,147,97,171,204,217,147,148,115,251,106,188,117,255,71,203,178,206,129,12,92,237,86,89,22,43,106,219,118,146,140,184,28,220,67,159,183,31,59,50,87,104,91,131,240,173,38,136,27,22,131,199,186,220,176,221,222,28,69,67,112,81,222,113,32,18,61,23,103,237,141,29,41,136,107,152,114,226,129,60,36,101,116,175,118,204,41,123,37,236,171,144,98,107,134,198,183,122,101,96,17,112,197,118,57,234,33,20,91,114,65,104,215,199,107,127,239,45,36,83,61,83,222,171,28,174,147,210,3,59,55,175,170,152,19,43,63,227,87,112,181,165,135,180,98,60,88,25,254,233,158,255,217,49,130,143,150,213,10,178,59,58,157,145,189,199,252,233,234,51,142,195,184,92,74,98,200,214,199,171,154,19,153,122,252,51,160,156,141,23,50,71,197,21,172,36,139,80,251,112,131,69,160,73,157,158,203,135,208,26,28,88,186,145,210,77,82,134,25,14,209,100,15,124,68,251,52,35,138,150,67,171,9,149,71,93,31,92,29,27,49,51,15,91,221,52,27,40,37,52,90,165,153,236,182,243,54,3,77,139,168,63,196,81,51,178,136,12,165,235,166,86,108,45,229,67,130,190,82,157,74,230,237,206,157,16,77,140,107,142,116,66,130,53,193,4,39,122,117,10,3,201,69,111,180,223,51,249,246,168,76,72,103,125,175,228,182,171,89,185,242,225,221,144,113,17,159,251,218,241,213,24,166,66,216,106,184,110,182,84,66,234,122,233,160,190,219,89,179,159,87,85,236,36,215,196,53,75,208,248,106,176,42,128,43,238,232,63,166,186,60,229,12,253,153,103,81,113,109,212,171,146,73,118,173,180,187,254,247,221,24,162,175,140,139,24,19,98,126,34,47,209,3,42,57,18,79,99,25,91,8,123,201,156,190,152,123,23,86,156,100,151,120,64,201,206,10,7,119,97,106,84,146,79,202,82,112,79,184,254,0,94,6,19,113,152,48,88,174,37,82,164,86,141,63,124,33,176,232,18,84,181,251,33,100,71,141,138,43,253,101,173,190,75,52,168,227,89,135,24,22,124,198,201,72,211,197,82,146,4,212,66,231,127,9,248,95,236,154,67,65,24,198,108,71,226,33,83,220,110,150,75,38,61,128,94,140,244,242,95,104,125,173,196,3,177,1,56,75,154,248,177,106,158,209,216,90,123,49,247,233,52,198,196,182,203,57,146,208,67,214,193,67,32,48,9,122,221,197,110,67,114,96,235,34,3,159,61,227,95,237,250,211,120,151,27,245,232,198,186,51,122,46,161,121,33,76,124,29,164,9,162,22,171,65,192,30,135,138,166,82,188,74,89,224,100,80,11,88,156,6,92,99,110,128,47,96,60,22,128,114,54,18,253,205,33,83,127,74,205,116,110,103,177,244,108,61,116,171,100,200,135,246,202,81,157,109,121,225,6,245,90,155,210,80,130,210,76,239,65,63,52,24,111,161,101,19,89,59,2,57,102,136,85,94,84,9,241,42,106,23,40,41,190,210,155,174,66,104,111,87,187,63,8,198,164,94,189,99,162,37,108,226,86,21,205,123,84,176,145,232,127,242,232,49,198,95,219,186,50,25,228,108,87,255,63,31,77,81,101,113,90,91,51,191,16,91,182,7,149,66,213,118,157,169,73,9,3,145,50,32,179,166,93,118,254,188,67,131,147,66,204,135,5,24,111,62,164,231,0,104,177,202,204,110,72,242,22,76,76,107,136,68,248,156,167,236,82,173,139,58,223,218,85,97,99,186,83,248,196,183,104,180,81,21,163,149,135,98,34,127,166,2,243,242,201,211,127,217,169,39,225,154,21,213,58,54,32,228,187,138,228,233,7,25,123,207,179,228,150,217,50,195,137,61,205,235,53,254,231,225,81,252,77,166,218,189,237,225,251,180,49,133,83,146,78,179,75,206,219,200,80,151,253,42,20,14,10,236,3,127,252,199,84,49,23,1,112,147,222,195,46,156,181,220,84,176,203,102,130,214,149,62,68,133,212,157,187,123,57,149,74,148,160,14,187,253,203,98,18,16,99,240,187,118,176,194,208,55,214,183,132,10,153,233,82,78,95,241,174,74,139,234,66,170,161,168,175,196,67,143,245,121,91,227,149,76,203,51,113,90,99,221,247,112,222,165,254,4,40,104,224,199,75,93,39,205,105,138,117,0,60,143,0,206,248,146,135,134,192,40,47,224,229,219,46,131,76,196,79,234,219,5,219,44,110,44,137,237,152,30,117,43,4,239,144,163,51,115,219,50,223,35,157,32,218,123,158,226,208,73,90,33,201,87,63,180,41,94,215,28,39,69,241,105,189,233,190,186,194,163,211,80,24,86,137,189,228,172,72,128,22,212,68,17,3,155,25,252,116,52,135,212,59,106,68,188,253,115,187,114,37,156,241,84,80,124,58,1,140,48,166,89,226,31,220,222,75,155,150,240,89,28,36,35,69,14,95,85,12,126,42,251,20,196,93,86,104,207,42,55,25,53,238,255,28,118,235,226,119,50,7,107,124,238,238,147,4,2,174,45,121,248,6,120,139,84,219,55,46,170,217,79,97,32,175,126,0,118,45,86,114,154,115,104,50,246,251,246,32,95,134,156,237,94,248,235,143,255,187,51,9,11,230,195,54,142,107,192,95,166,196,6,81,78,181,134,73,248,208,59,24,89,154,170,30,159,173,175,68,128,153,229,194,181,174,33,87,128,22,148,28,168,186,150,206,129,136,158,49,205,185,202,203,167,53,239,112,46,126,165,128,228,175,156,7,184,3,10,133,116,186,108,188,242,232,12,192,99,178,50,72,39,165,26,47,53,28,100,74,48,32,205,48,11,13,151,52,151,246,26,31,31,208,69,25,187,216,32,173,198,190,30,29,146,171,81,116,159,200,129,142,216,167,11,30,195,226,204,210,202,175,124,94,211,88,198,254,72,87,104,36,210,19,28,235,249,44,109,84,60,65,151,188,213,34,153,184,158,177,235,152,87,52,26,203,116,233,113,60,242,176,216,195,113,88,238,65,32,132,48,163,94,65,125,244,218,77,163,120,179,33,251,158,123,200,60,146,11,203,228,186,137,104,175,141,132,180,144,139,73,6,73,155,113,23,247,43,254,51,144,150,150,22,206,36,193,60,220,157,145,35,232,33,222,36,114,165,54,48,39,39,113,22,112,130,52,87,193,50,93,104,90,40,95,113,208,10,221,6,255,144,90,11,73,145,95,38,208,181,163,226,243,122,225,36,144,100,199,228,238,69,105,165,158,197,5,84,168,167,97,133,39,204,165,165,180,155,10,253,181,89,40,25,182,240,116,67,190,137,202,21,157,234,59,69,230,139,156,121,34,187,230,84,166,144,196,141,134,9,122,83,252,150,226,0,172,18,67,252,88,94,45,9,171,53,59,206,165,19,81,82,147,150,220,42,109,67,6,107,112,160,129,88,26,76,247,223,168,147,84,159,21,106,151,64,112,61,211,10,250,240,160,128,208,229,204,27,244,57,18,225,251,230,137,114,233,51,162,239,160,51,0,89,106,106,155,249,147,36,226,25,110,255,128,204,90,209,47,143,161,139,225,151,29,16,61,209,232,90,147,192,175,171,189,8,245,87,204,215,217,102,234,186,90,84,34,245,193,3,160,173,111,245,188,131,109,86,141,144,192,42,151,152,77,37,104,119,106,114,6,184,125,207,174,45,251,107,230,102,6,104,122,127,185,180,93,74,91,175,97,250,208,111,194,73,242,2,25,209,43,63,214,80,238,55,222,178,36,246,199,154,84,131,166,126,37,176,14,188,89,166,168,113,178,104,77,103,51,255,139,163,252,156,104,240,41,73,227,173,166,92,144,252,182,163,173,84,149,65,34,228,148,156,254,152,28,95,246,76,122,213,116,45,194,157,236,125,53,240,113,50,79,120,208,71,249,27,100,62,121,84,126,148,0,231,188,10,182,87,110,152,171,164,97,159,134,228,89,61,174,147,96,68,124,227,50,23,243,94,255,169,71,243,9,184,243,194,43,179,142,127,113,80,108,191,174,157,29,231,140,2,176,22,100,241,240,86,162,91,179,182,37,215,223,98,62,77,173,117,250,246,245,178,247,189,22,1,146,59,149,137,108,114,169,16,8,243,167,154,41,201,55,5,200,227,206,213,196,31,151,10,230,172,175,52,39,99,59,144,210,87,199,228,164,196,47,170,172,230,176,54,187,245,81,243,198,77,159,112,49,234,217,199,29,157,13,173,200,25,37,31,95,7,187,190,181,241,182,17,214,83,200,71,212,255,56,41,241,87,236,136,98,63,204,169,203,27,157,129,17,165,197,197,212,200,249,128,196,122,166,6,219,28,53,142,232,83,213,49,218,38,93,208,168,148,86,184,195,251,118,17,190,122,103,43,53,45,116,110,36,149,83,51,69,153,23,22,219,113,249,86,19,124,104,130,42,187,131,180,33,228,110,213,216,17,135,54,141,192,38,155,210,136,47,57,37,1,9,202,241,58,187,42,86,181,53,45,147,238,28,111,69,26,207,63,13,189,170,14,184,139,174,107,127,115,131,12,168,138,190,36,90,73,227,132,161,90,173,253,50,75,111,220,88,255,37,251,145,57,157,40,196,123,4,43,241,61,177,138,81,107,149,249,17,48,172,190,228,1,22,63,25,94,228,79,87,186,128,89,54,242,230,248,208,142,172,107,242,27,243,80,115,156,76,24,251,89,190,96,18,134,24,233,24,188,215,120,24,55,111,25,10,127,212,93,7,77,16,29,18,116,84,84,98,230,246,24,100,42,158,163,127,246,229,17,236,64,155,140,179,4,95,67,242,162,73,120,121,101,225,82,55,72,28,122,168,50,148,126,20,177,28,50,172,227,133,159,140,137,124,159,84,218,189,125,228,204,78,155,66,186,197,152,226,70,149,1,60,187,233,41,246,48,42,37,34,99,1,199,95,97,94,233,112,215,205,25,218,153,179,80,63,150,201,174,135,220,224,224,240,250,195,119,234,25,167,201,251,83,86,71,106,214,153,211,84,80,107,96,149,68,145,193,193,172,219,194,39,183,140,246,201,116,73,218,177,200,132,36,167,11,45,255,54,66,237,32,67,32,27,144,78,112,108,149,51,30,180,121,147,0,64,70,189,241,241,20,104,6,69,144,175,254,206,30,139,63,90,39,199,182,64,124,102,175,0,33,215,189,11,127,242,238,78,225,69,68,104,67,33,231,175,102,67,113,105,24,205,132,149,99,238,39,156,230,59,193,57,236,73,214,158,164,134,84,44,14,204,47,78,186,50,24,192,101,128,139,206,154,45,203,179,135,223,6,13,199,82,255,208,84,23,11,70,128,209,86,250,4,185,76,221,149,204,116,212,13,160,249,116,195,1,80,24,77,95,199,43,153,11,91,215,43,209,43,91,101,149,113,106,179,78,61,157,102,242,42,180,179,214,60,139,100,152,186,223,40,36,2,255,176,154,233,211,29,253,104,243,181,37,78,153,43,93,75,252,88,167,243,134,10,48,4,169,229,19,2,187,28,156,6,246,123,68,3,238,40,198,34,93,91,93,28,212,50,133,139,223,229,31,143,211,185,36,184,60,217,187,150,2,123,69,4,114,92,198,92,32,122,112,15,101,213,45,136,3,190,105,159,83,62,239,118,165,176,229,16,140,69,91,31,189,21,96,143,8,170,196,4,61,27,70,195,30,172,150,42,169,137,176,66,232,86,214,41,100,147,199,63,245,151,60,44,231,105,203,179,98,190,57,121,99,149,26,130,45,244,231,251,81,245,132,123,85,157,4,254,121,239,248,5,14,198,99,63,79,105,16,94,195,130,118,50,125,124,250,90,238,167,188,53,161,130,179,143,224,134,27,221,32,83,168,103,199,70,174,153,39,249,194,103,120,64,96,195,153,169,207,116,2,170,101,104,210,6,204,180,87,123,61,63,231,16,34,174,193,225,61,125,53,172,109,82,32,47,131,106,230,174,27,46,63,39,215,179,108,168,98,120,124,223,26,108,74,167,253,72,85,64,231,9,114,165,53,212,132,36,73,139,25,173,92,194,202,175,249,131,210,125,243,128,6,86,28,155,202,69,57,20,141,237,101,226,201,246,169,90,166,108,101,177,214,214,136,92,20,5,252,216,25,241,35,103,2,186,131,247,160,135,173,123,7,10,65,183,61,245,110,129,136,20,88,129,63,210,11,101,146,15,99,168,108,217,8,68,190,126,237,30,35,45,250,131,238,84,222,195,56,24,110,42,219,36,242,222,97,47,99,30,217,174,185,3,25,198,224,186,235,76,88,42,33,194,93,179,67,82,153,5,192,220,74,173,213,143,79,215,244,110,140,177,101,39,182,140,254,64,88,167,74,27,144,25,149,160,69,218,184,90,6,10,168,32,139,245,249,83,248,35,14,54,152,246,209,86,70,62,17,252,101,120,72,66,211,254,215,64,103,86,214,51,197,11,122,132,114,214,222,2,45,220,63,236,129,174,157,42,196,215,242,126,190,130,27,41,46,21,39,156,117,158,63,29,218,225,250,202,219,86,61,244,160,236,193,53,76,2,149,165,41,247,140,30,220,98,61,185,63,53,206,235,92,227,50,132,19,242,158,206,90,223,37,130,77,250,7,171,94,245,135,16,9,136,199,105,220,93,204,144,19,81,241,39,35,163,4,208,253,160,159,6,88,228,112,132,188,77,14,42,149,232,118,68,190,51,156,240,68,189,117,228,46,19,160,163,30,68,104,67,178,132,227,194,56,254,249,158,107,70,15,1,33,109,96,149,46,30,166,171,59,12,254,114,245,68,45,12,89,15,161,191,41,125,13,11,2,33,139,63,63,67,99,253,116,87,170,75,50,58,8,85,164,141,169,196,115,61,108,3,50,154,157,27,63,243,71,178,135,105,223,45,77,252,162,172,103,98,43,237,80,54,79,47,180,84,159,192,112,214,179,255,175,6,57,220,58,107,246,97,228,116,135,208,100,248,51,248,167,177,47,54,231,5,29,226,24,169,12,54,94,241,159,125,155,86,108,50,88,77,244,100,13,60,132,54,243,231,97,75,11,116,20,37,253,112,112,0,200,225,58,237,57,71,50,111,131,249,71,153,9,168,145,176,109,232,53,238,228,85,78,45,81,29,109,159,56,80,81,14,154,232,147,149,90,184,186,67,68,150,128,223,226,138,155,253,236,176,208,149,199,92,106,144,139,26,218,142,8,128,193,248,178,153,13,33,211,128,59,3,71,144,112,48,198,114,100,249,104,203,107,232,230,10,57,53,208,86,159,34,147,238,197,15,209,101,87,200,241,203,224,10,155,248,216,255,108,186,216,126,220,211,67,33,169,36,82,45,220,112,56,96,54,104,251,109,199,125,67,202,10,234,235,92,255,39,192,136,186,126,220,36,42,150,194,250,133,223,132,173,190,178,48,58,67,43,144,150,146,213,63,26,189,39,174,8,223,206,143,237,210,220,199,162,218,175,87,102,213,181,123,82,80,216,225,211,249,90,238,176,28,196,24,36,60,227,126,98,99,130,2,114,46,60,148,38,72,103,244,124,63,134,147,20,71,247,122,109,178,223,3,240,199,29,170,12,188,71,51,62,45,167,59,157,196,114,172,165,26,165,64,15,171,103,40,223,150,211,221,233,30,113,118,116,120,26,209,175,251,83,105,212,95,186,63,148,244,31,22,126,29,222,32,193,231,119,37,254,185,214,110,180,242,187,10,232,205,216,106,157,46,206,75,177,206,45,142,79,37,167,128,179,241,98,224,80,21,246,9,203,237,122,195,97,75,68,200,43,150,130,44,42,176,204,156,125,51,188,214,133,194,4,169,122,56,152,3,47,94,60,168,48,228,192,101,155,84,132,233,162,117,191,1,30,19,220,39,224,21,179,240,37,215,110,63,115,122,139,47,222,24,149,17,122,181,81,115,216,4,165,133,181,137,137,101,187,145,244,79,103,74,208,201,71,12,131,148,8,42,65,51,129,7,245,245,85,87,204,228,119,236,103,250,74,85,58,167,151,142,37,232,121,66,40,235,154,253,126,242,65,193,232,161,100,86,195,104,163,203,102,79,18,18,186,42,48,1,46,227,252,134,106,237,229,201,126,175,130,130,61,95,232,132,131,14,82,1,57,50,206,119,120,60,129,178,88,190,182,228,63,111,178,79,162,21,48,161,151,223,162,15,47,144,122,187,46,119,82,219,220,234,19,149,155,125,53,128,109,75,69,174,146,19,123,170,164,87,102,125,188,137,173,137,44,203,121,129,172,178,70,213,33,253,105,93,5,98,151,141,115,2,88,15,46,32,107,87,52,76,223,85,119,130,121,249,34,21,232,21,63,153,146,228,84,11,136,3,216,24,240,51,135,32,216,82,253,6,37,45,139,232,229,81,80,196,108,150,228,100,65,240,102,149,8,138,14,120,167,162,166,156,16,6,178,80,33,232,239,5,243,152,10,241,50,130,236,171,127,199,10,76,220,224,110,16,104,229,96,166,103,199,95,157,16,23,31,45,217,12,25,41,127,17,120,34,253,244,16,125,121,208,13,41,23,250,185,160,217,217,114,90,34,169,237,224,68,175,250,173,58,65,20,21,251,148,227,232,97,65,193,11,254,131,24,234,83,151,216,97,2,107,144,218,189,38,48,208,177,55,147,126,178,50,171,246,8,41,157,181,95,31,33,43,164,26,56,143,148,44,38,21,108,250,176,168,153,73,232,139,33,79,163,174,63,79,151,208,105,10,195,183,2,132,81,183,203,98,224,236,72,95,141,13,47,120,150,66,149,148,45,39,10,166,119,116,142,242,134,74,13,55,222,167,115,247,101,156,74,81,41,16,136,150,189,146,151,181,17,38,35,58,243,226,169,171,36,59,130,214,127,242,181,129,20,201,185,220,247,179,99,159,34,248,163,39,218,96,122,30,153,141,255,33,22,90,29,82,232,188,249,242,245,133,158,250,47,193,69,164,99,129,51,132,121,202,148,228,127,115,44,247,72,255,149,103,54,96,243,161,102,156,218,254,52,123,94,39,12,150,188,139,3,127,7,222,102,41,3,60,137,109,230,163,109,253,242,48,174,229,161,209,94,247,36,253,13,244,183,202,91,244,21,37,74,135,28,85,75,111,171,166,107,8,211,6,253,38,241,116,122,138,248,219,93,21,116,131,203,71,181,71,72,88,22,15,216,234,193,117,106,157,178,186,131,170,54,202,86,223,228,82,244,42,45,203,46,242,252,255,81,249,220,48,249,132,237,42,77,69,86,171,4,255,222,186,175,106,215,174,80,124,31,205,126,76,54,55,68,169,222,114,64,61,234,65,238,163,101,107,93,248,60,142,106,128,123,24,30,186,205,206,219,221,103,235,120,239,230,87,40,38,72,243,18,222,176,46,176,172,223,148,231,74,80,75,230,171,189,202,150,52,42,128,24,131,63,120,224,77,116,244,82,174,45,94,122,212,85,228,166,155,75,61,167,238,73,127,76,154,199,224,109,201,131,16,74,110,177,221,82,97,99,165,128,193,176,184,168,76,35,161,54,180,7,159,4,132,26,101,140,212,104,219,229,29,29,99,239,207,89,145,55,142,53,131,10,118,162,219,204,36,253,241,217,119,45,211,252,190,233,236,36,182,214,173,173,14,253,81,118,111,139,236,72,218,149,175,119,116,60,232,122,90,215,97,193,67,41,182,87,228,10,34,108,94,2,53,128,55,11,137,204,141,159,157,250,3,113,163,204,205,8,40,168,80,140,40,217,147,8,194,210,76,22,131,13,231,164,165,214,150,232,157,227,89,85,71,210,226,82,53,4,196,179,118,136,6,254,64,112,73,125,178,226,189,153,73,51,226,7,202,204,212,153,105,50,22,114,199,237,119,80,5,17,88,117,195,62,241,69,219,101,52,238,94,147,32,251,124,30,61,252,226,142,26,196,2,118,62,21,98,239,65,174,5,90,240,79,137,23,216,177,3,31,119,68,104,5,24,225,85,103,42,207,182,231,237,83,240,83,117,126,47,229,149,66,217,205,40,246,38,200,231,185,210,127,75,158,12,53,139,105,24,114,156,230,45,61,132,95,61,184,21,129,164,129,149,186,119,35,216,97,255,82,60,207,207,108,61,132,234,74,33,0,241,200,53,117,70,51,75,78,40,201,213,78,131,205,125,74,233,113,208,109,101,187,241,170,38,206,199,89,31,141,246,23,42,129,129,134,45,241,226,176,220,252,129,7,186,125,15,190,17,244,98,239,5,5,138,219,8,238,111,194,42,2,167,225,105,134,73,202,226,244,23,177,137,63,238,104,37,224,33,15,98,60,29,206,182,97,3,92,145,59,112,149,22,26,156,179,109,70,81,142,149,243,85,245,127,157,73,175,216,246,14,170,88,187,208,191,231,36,207,123,205,53,210,251,44,131,149,189,122,149,104,228,224,24,134,81,121,13,27,215,116,94,73,114,157,10,54,233,125,196,195,21,247,102,56,53,89,43,101,95,104,97,139,72,100,199,11,232,212,144,76,245,194,66,61,0,99,35,255,39,159,148,237,85,214,162,192,69,150,175,189,169,201,118,49,238,26,181,78,13,214,148,7,37,1,173,180,110,71,56,6,117,81,52,15,254,174,10,242,65,124,162,232,138,2,130,39,253,23,221,162,129,95,116,33,238,237,66,36,193,74,77,168,140,191,93,35,87,82,140,132,139,149,167,79,88,235,169,115,138,184,175,253,71,62,18,120,116,129,121,131,28,240,144,102,47,231,127,243,131,220,12,246,6,182,176,191,41,135,3,111,209,58,148,28,165,73,114,172,71,190,30,241,93,131,11,169,205,231,27,109,70,40,134,144,210,188,244,122,75,217,132,56,54,5,121,192,80,200,97,164,214,200,217,159,235,78,23,73,189,143,200,35,74,112,72,171,12,151,49,200,251,163,69,72,1,9,27,42,136,129,140,249,167,13,51,236,227,176,158,113,157,189,50,234,164,163,137,182,104,57,45,141,254,71,225,173,10,27,242,138,79,81,48,28,126,121,244,46,169,73,40,31,223,69,37,52,63,201,197,13,89,76,13,222,195,101,142,227,192,89,75,242,19,242,161,224,66,133,105,253,128,100,120,143,245,4,178,212,32,111,25,144,125,153,98,210,189,164,23,206,21,144,253,200,100,185,12,59,23,81,31,59,93,34,185,113,37,31,241,186,67,36,54,63,163,80,237,212,49,136,9,30,153,208,23,76,101,15,162,170,5,199,7,132,183,238,250,147,23,195,37,225,104,39,64,92,199,167,33,90,53,137,43,164,17,183,239,82,19,26,222,10,86,187,2,119,149,234,163,1,97,227,235,50,246,221,212,238,4,139,253,164,86,36,67,14,91,211,91,98,218,179,161,30,21,199,82,10,221,86,180,16,58,245,92,120,18,68,69,88,179,156,90,149,201,206,171,212,14,239,148,88,191,27,22,217,216,254,74,151,21,61,124,226,195,70,218,139,190,57,201,223,119,84,117,182,42,49,108,183,79,107,174,246,42,51,117,146,79,30,223,155,47,65,55,68,54,10,209,144,15,37,52,88,31,44,119,141,211,203,195,182,151,40,171,102,11,34,118,170,245,100,76,70,22,203,80,117,32,66,75,88,24,82,106,113,21,137,83,32,135,81,254,144,19,21,42,162,97,77,234,166,10,109,46,217,148,152,126,96,53,254,62,185,105,146,229,40,247,144,189,147,234,65,246,174,253,33,253,20,3,122,150,45,227,30,246,22,192,115,136,14,146,253,180,255,75,114,14,138,246,78,157,227,83,92,77,241,170,184,94,45,108,125,131,197,153,44,187,68,14,61,131,204,96,75,189,60,13,173,92,172,59,78,244,101,194,105,87,122,207,156,230,236,26,58,117,33,14,237,155,199,71,52,99,87,185,179,101,108,91,55,32,49,21,230,176,146,46,201,187,171,255,69,212,33,55,199,165,161,209,169,214,254,129,205,216,96,170,234,61,60,33,189,168,80,34,156,146,214,4,148,220,216,89,50,165,201,23,171,118,21,55,220,236,119,11,179,88,30,216,193,225,220,238,186,18,200,114,188,221,103,13,104,236,190,164,233,160,87,24,102,7,205,93,63,119,190,92,122,10,25,79,6,103,246,7,120,108,134,95,69,93,106,168,116,249,78,55,0,72,210,191,186,245,247,57,50,196,208,35,29,62,54,119,20,142,188,19,213,243,44,203,31,151,183,41,115,188,94,228,21,187,231,141,79,15,241,134,240,168,44,230,199,87,230,190,117,247,204,186,218,116,135,224,126,212,152,139,38,235,203,87,218,213,146,4,10,204,73,100,134,209,244,181,252,206,72,63,52,57,211,86,26,158,138,210,24,58,236,105,24,231,20,161,23,130,29,94,36,102,11,23,234,141,244,25,151,37,16,40,135,136,104,241,151,111,232,112,175,75,40,196,229,200,36,75,10,53,17,79,48,55,221,164,240,54,234,253,99,111,175,250,134,63,17,172,62,11,52,192,249,165,60,231,44,53,100,188,156,28,110,42,98,122,153,36,238,96,100,234,204,44,141,11,77,5,65,76,128,113,129,47,235,76,2,75,88,18,249,94,185,81,204,7,157,35,3,247,198,252,53,1,126,26,95,89,232,69,48,13,156,63,102,69,68,224,84,211,242,11,242,13,252,250,199,170,133,247,85,235,132,5,199,71,89,51,250,189,250,142,157,76,41,61,22,63,75,137,147,129,201,91,35,76,237,136,109,137,86,101,61,118,152,164,70,91,209,118,137,174,195,195,238,0,96,198,60,23,142,185,23,6,145,111,83,192,138,178,90,125,180,66,87,220,140,152,68,189,250,193,86,115,178,245,132,106,172,37,54,216,158,114,146,111,196,103,197,106,163,224,181,8,58,28,125,106,203,235,228,104,33,53,108,86,119,150,240,104,165,147,66,230,130,26,73,12,191,16,199,66,245,222,22,251,53,167,115,49,41,176,62,22,95,226,113,21,175,94,5,246,208,179,246,32,78,158,75,9,244,182,229,3,143,168,157,68,47,4,114,74,191,126,110,76,218,86,194,239,17,223,217,167,157,230,250,59,215,180,142,52,243,212,101,225,64,139,100,200,144,246,134,195,190,52,110,239,200,105,240,36,235,14,162,195,66,126,219,212,76,207,231,175,156,194,35,13,244,0,138,245,133,225,123,33,200,166,44,167,41,240,127,164,7,55,203,119,7,78,190,53,197,34,34,170,213,69,237,223,154,11,220,122,218,218,99,28,157,255,213,149,114,208,202,209,214,163,162,145,88,210,176,208,71,31,234,8,244,240,168,95,196,61,24,167,184,69,49,193,209,63,233,161,179,87,46,9,49,21,43,48,166,40,31,11,74,90,18,238,68,100,204,78,22,116,215,3,65,45,206,34,82,232,246,153,210,200,129,210,178,95,72,59,78,212,240,132,149,218,224,205,213,120,170,107,215,1,211,127,145,39,100,23,126,245,223,155,133,208,49,53,197,6,60,123,13,206,40,146,167,203,254,125,144,207,143,189,241,232,60,117,122,223,15,171,176,239,146,198,194,55,154,236,213,45,232,64,207,115,186,238,149,60,161,146,33,206,201,204,160,230,60,196,20,171,194,235,180,135,37,19,63,61,14,31,97,17,77,127,39,33,200,18,44,126,123,52,28,54,91,252,243,86,48,94,120,237,94,214,226,92,183,182,125,173,212,133,252,201,217,180,116,246,0,116,192,12,186,179,243,43,255,5,177,178,171,244,74,177,2,249,109,144,148,237,56,13,69,244,73,123,142,2,67,198,43,194,163,75,89,24,64,118,161,11,228,183,169,224,48,6,201,59,32,215,224,150,147,120,199,14,162,252,235,69,90,3,146,135,46,92,82,78,113,119,244,231,51,177,103,33,97,117,215,67,244,188,29,154,72,151,232,83,2,71,238,1,105,125,126,59,157,89,67,80,102,251,131,197,214,194,145,102,219,118,115,10,159,143,237,53,219,49,39,193,110,111,32,128,69,183,221,161,182,57,157,92,33,243,165,53,6,60,166,181,111,169,10,245,7,255,14,68,194,117,83,150,130,224,203,78,74,148,76,189,203,96,80,173,214,93,200,180,253,194,88,154,246,81,252,100,23,21,170,85,238,172,21,117,181,220,32,157,186,171,25,73,236,181,47,190,115,165,148,33,230,50,101,101,55,25,56,167,180,28,137,70,224,195,234,77,167,55,137,103,196,39,1,4,83,22,185,124,194,25,105,205,64,26,177,83,215,8,69,170,194,4,138,138,23,72,114,166,251,156,183,8,187,3,196,108,251,58,125,243,57,156,178,156,193,143,211,21,136,246,6,7,169,9,104,231,208,89,235,113,151,156,124,7,208,51,34,194,236,231,189,235,214,102,141,161,69,79,50,178,116,28,114,87,90,80,170,95,37,243,80,76,223,74,237,150,27,246,230,90,201,68,255,246,115,247,75,23,55,154,200,200,171,254,5,164,7,152,203,229,165,42,120,130,217,180,78,240,228,172,85,75,24,133,69,56,114,18,130,76,74,123,3,251,93,21,112,253,224,241,77,91,203,79,134,87,236,212,248,243,57,2,100,110,125,229,36,248,192,15,155,7,39,243,254,131,109,225,133,135,2,200,153,32,186,137,108,61,150,207,252,108,28,241,175,59,233,16,25,227,157,114,57,196,3,154,187,96,169,18,218,253,165,250,140,135,108,31,192,132,55,90,240,69,188,15,7,29,208,0,179,189,244,157,239,94,194,2,28,106,173,213,27,45,185,51,92,225,222,9,156,253,150,53,111,165,94,139,164,39,219,36,39,13,123,79,205,107,158,35,204,55,51,76,219,180,19,87,96,3,197,224,213,155,130,30,52,178,205,183,105,226,165,54,80,74,244,13,117,206,243,186,98,148,238,36,136,0,246,75,169,58,144,161,119,221,34,236,211,244,167,186,203,19,201,230,185,44,150,43,76,193,118,149,247,67,161,223,225,192,89,189,231,210,39,120,214,216,133,97,57,116,232,74,126,242,172,151,56,5,200,28,130,182,96,1,188,229,194,129,177,188,79,187,191,131,181,125,2,238,76,250,76,68,44,253,211,246,0,155,239,204,168,81,83,240,167,147,27,237,197,173,8,156,35,151,212,110,240,185,113,120,190,208,196,153,124,40,150,116,24,220,216,149,165,95,40,230,242,120,82,7,28,10,27,248,218,125,52,112,73,81,107,245,144,105,197,115,56,240,73,63,148,17,192,238,190,115,5,230,65,221,229,132,60,234,132,55,243,22,43,232,206,82,132,16,231,161,168,233,249,209,135,162,135,37,21,243,130,212,54,146,144,197,255,178,23,17,203,220,109,237,24,178,195,139,66,67,11,211,26,140,128,242,205,207,69,176,161,53,151,224,252,9,44,210,33,40,144,127,141,224,210,45,27,54,191,24,111,195,149,57,51,37,164,64,184,87,31,7,137,141,71,232,168,105,47,196,35,104,245,247,98,125,175,161,252,57,235,6,76,175,213,132,45,134,30,137,213,212,124,134,50,61,106,30,106,54,122,214,242,25,14,220,238,162,168,136,183,232,11,151,170,50,133,241,193,145,0,222,214,226,214,231,23,7,23,214,48,117,84,32,255,167,26,87,138,89,50,52,49,167,164,74,33,49,221,25,39,34,175,89,35,7,247,92,30,34,91,213,16,28,79,173,237,229,203,236,214,26,109,85,184,176,243,34,209,139,93,95,188,197,94,11,227,239,155,250,186,232,147,13,254,215,165,93,133,205,147,117,97,97,62,75,154,223,117,153,48,72,223,14,158,240,14,104,31,147,194,97,253,252,166,211,105,123,146,119,36,98,128,214,155,139,112,98,251,200,115,66,45,244,1,224,219,130,44,221,14,246,131,47,228,175,195,61,5,215,157,50,4,222,207,93,108,235,187,60,241,187,24,62,18,41,114,8,65,25,20,131,97,20,58,104,73,216,120,57,127,45,242,97,125,8,110,54,126,185,242,57,188,153,186,37,216,169,27,48,219,148,231,240,18,192,208,167,174,73,127,233,94,57,106,184,133,193,197,52,199,82,112,119,181,36,197,118,94,195,89,119,154,23,135,23,13,193,174,102,159,101,205,0,178,49,100,235,59,130,87,3,207,73,97,22,157,158,34,13,211,241,25,47,172,184,236,56,13,195,18,51,176,190,78,34,19,234,28,177,190,180,160,232,97,2,178,147,181,134,101,231,148,233,208,61,101,3,150,244,211,30,156,193,65,19,221,221,136,237,207,217,5,85,116,247,85,119,80,120,36,240,84,234,120,112,250,75,237,34,81,92,126,208,161,179,212,10,44,82,241,191,183,184,187,246,196,244,114,224,136,215,88,96,138,174,29,202,153,121,5,98,159,149,73,251,132,137,25,20,222,239,38,223,0,120,205,225,133,95,207,107,247,114,174,102,148,131,243,115,154,127,204,97,39,157,114,17,238,130,144,147,6,208,17,170,17,137,86,13,160,224,132,26,107,205,178,173,99,209,235,100,183,62,79,8,224,164,120,233,120,28,60,55,240,108,101,218,121,221,81,10,225,124,238,107,191,215,129,156,9,111,84,185,248,92,136,185,38,88,188,175,62,54,59,86,157,227,45,11,214,131,191,51,25,221,213,110,223,48,15,212,1,240,51,99,138,149,235,212,210,47,21,22,125,126,175,242,6,65,71,86,1,81,87,51,8,227,121,187,31,72,53,243,34,122,99,147,153,126,35,245,209,252,86,158,12,157,211,137,210,117,133,103,25,149,206,133,201,37,163,159,104,172,178,139,247,102,65,128,69,167,89,232,175,162,147,151,30,212,87,32,164,242,6,153,166,129,152,245,205,6,158,121,95,96,85,77,160,158,84,98,123,0,40,211,180,189,75,246,48,171,66,154,79,79,155,190,55,254,177,204,29,74,180,11,160,49,152,160,235,244,252,212,53,203,55,2,162,93,219,213,163,212,219,164,14,17,2,51,200,222,170,98,97,17,86,156,58,248,253,99,122,62,235,148,29,241,116,136,255,219,236,194,173,5,193,55,176,27,2,32,177,0,133,199,195,62,202,59,97,240,163,38,217,29,41,36,110,74,185,58,221,147,188,148,67,57,188,19,44,71,39,233,203,58,203,12,203,162,215,75,32,238,124,229,87,162,32,230,253,41,3,245,56,180,249,140,177,165,254,106,63,219,18,83,247,125,125,129,216,163,234,182,246,95,224,187,206,120,220,58,59,27,214,172,254,105,172,203,145,35,226,64,207,45,104,166,246,39,21,67,174,175,167,88,165,0,16,248,225,227,109,249,40,189,119,14,64,120,99,194,54,19,43,145,255,73,183,11,221,160,205,22,182,27,76,83,34,5,85,166,41,124,78,117,84,232,94,72,70,184,12,24,163,77,21,206,99,165,158,53,137,228,168,14,113,189,54,113,241,181,214,83,166,93,25,120,207,242,115,76,162,215,242,117,55,123,101,73,236,95,110,83,118,101,57,72,149,20,119,222,21,117,213,116,147,152,128,25,132,15,246,24,139,174,142,32,158,99,211,255,153,111,114,141,157,64,228,162,44,46,70,255,235,151,162,32,222,174,9,163,163,245,73,234,228,35,154,152,89,12,178,225,136,66,5,132,146,231,73,177,25,100,45,163,31,120,212,148,156,112,66,116,30,93,29,232,118,254,216,18,121,241,37,87,98,224,208,240,144,167,231,95,207,16,198,217,200,113,169,37,243,124,164,53,187,73,93,220,178,141,159,35,93,0,97,205,237,146,171,61,63,202,125,112,210,19,117,82,177,86,149,118,81,60,67,44,210,170,228,167,57,205,163,30,126,178,79,135,1,159,232,143,126,145,138,218,65,107,239,195,173,187,168,2,129,21,206,183,34,167,116,14,137,114,235,50,147,252,182,206,72,252,37,64,122,135,37,220,102,216,221,158,75,139,62,59,61,250,132,123,68,29,232,41,90,102,62,14,94,193,195,168,180,102,59,154,208,160,238,76,251,192,120,81,84,204,181,86,252,96,0,38,194,222,125,230,27,7,27,11,63,216,62,209,38,26,38,111,53,125,179,76,197,126,108,91,196,67,235,47,206,16,226,144,62,8,135,244,108,103,23,79,88,28,67,241,95,219,137,169,70,239,21,8,137,67,50,217,88,225,110,159,55,200,28,55,49,156,199,245,121,245,96,223,151,38,121,158,71,223,236,229,164,42,174,175,0,248,230,211,21,109,1,67,160,37,210,200,169,32,48,181,211,138,171,142,170,158,169,123,74,67,57,65,204,36,188,9,245,39,95,185,236,125,100,104,235,41,22,68,30,4,21,171,242,225,5,243,81,135,185,233,79,0,199,118,129,179,154,215,108,31,96,57,114,208,144,196,166,234,205,114,239,114,190,254,234,30,88,241,67,209,57,226,132,112,200,41,148,108,141,158,57,27,53,214,3,185,141,35,52,12,6,197,12,34,217,101,109,150,113,130,234,143,127,75,174,191,208,100,137,51,163,91,8,199,95,29,61,50,74,29,129,227,181,241,119,53,90,24,209,110,60,112,110,41,113,7,13,164,10,0,211,214,218,89,209,119,44,13,42,208,147,86,22,126,156,205,220,225,235,174,88,174,144,229,142,130,117,80,74,118,142,79,168,166,1,95,162,128,59,42,217,207,97,68,187,119,77,172,143,159,66,107,197,56,38,6,128,190,251,235,77,250,37,113,240,189,83,100,248,12,105,216,160,22,48,75,196,49,156,131,232,119,85,77,247,136,87,23,23,121,52,126,35,19,130,65,6,150,73,225,176,59,148,120,199,60,177,67,255,19,242,36,30,178,56,9,243,91,137,85,235,245,121,116,247,121,157,153,102,194,96,99,254,208,176,154,12,31,83,131,1,121,70,141,246,140,75,103,34,46,69,191,73,156,3,218,25,95,93,23,51,144,140,135,222,217,45,76,155,148,59,148,134,238,131,135,207,142,190,138,205,237,7,43,133,118,53,94,97,249,80,203,98,118,72,39,170,217,78,35,67,100,228,247,166,105,100,223,80,97,113,32,117,135,136,82,141,119,142,78,198,158,160,168,131,91,55,172,172,78,8,130,23,152,206,221,215,49,9,47,147,248,179,26,21,62,43,85,129,129,127,48,152,56,21,168,242,182,41,227,216,10,79,239,64,197,33,204,118,36,78,174,14,42,95,183,17,237,239,58,153,131,66,162,174,67,219,33,68,57,129,176,246,46,1,156,66,240,26,176,165,39,192,20,88,248,167,82,203,27,3,124,241,202,142,26,201,143,208,234,193,229,142,56,238,6,83,184,18,201,72,195,45,99,196,216,191,234,184,111,181,164,242,61,217,238,1,123,213,25,225,34,233,44,189,95,205,51,36,58,8,73,186,41,43,54,255,42,205,202,178,29,10,48,2,42,232,241,239,225,148,89,142,129,33,48,79,191,54,173,187,156,73,44,222,90,67,187,6,228,88,161,31,16,41,161,3,124,24,141,22,230,125,136,147,54,1,130,24,253,47,21,222,188,241,9,194,172,183,185,51,218,230,6,252,177,238,133,176,246,160,24,104,90,148,98,149,82,242,3,223,73,57,142,162,0,161,39,216,9,91,167,244,116,110,16,198,233,163,48,121,205,63,49,110,7,183,32,78,197,32,152,191,223,176,78,253,26,243,24,172,58,102,116,154,81,141,48,234,174,105,17,233,249,128,111,138,83,211,188,185,40,129,182,14,229,125,116,67,29,52,85,2,176,110,163,167,99,157,185,240,120,115,85,240,49,156,234,54,104,155,120,195,123,222,47,0,134,25,129,115,107,253,115,37,100,30,221,109,64,87,82,24,129,45,198,190,62,246,40,30,185,34,96,111,41,154,146,25,247,228,145,119,229,231,183,124,66,92,181,242,88,71,103,167,50,193,72,35,186,93,123,21,182,194,61,30,168,23,30,11,179,126,159,137,217,123,37,182,150,4,104,249,3,221,76,30,1,147,40,108,219,217,185,242,70,212,34,104,78,207,162,188,47,162,226,233,112,20,100,68,211,208,51,152,138,204,78,16,225,88,34,142,68,183,102,29,190,4,159,4,119,56,0,13,174,239,248,98,40,151,81,100,134,68,202,199,27,60,80,84,209,17,151,211,59,33,78,126,195,2,141,90,204,178,97,177,255,246,228,240,163,25,212,183,228,105,117,137,54,104,177,187,223,14,10,235,231,232,175,245,21,63,65,220,46,136,127,3,31,142,14,236,94,235,203,16,138,95,194,72,120,94,137,98,139,201,156,8,129,70,204,85,147,17,255,90,135,146,71,25,26,120,217,5,134,86,90,88,50,72,12,75,64,66,86,124,214,28,188,92,32,200,229,19,123,227,73,96,184,126,98,193,184,19,142,192,130,94,56,240,240,144,203,17,58,80,14,54,73,106,207,60,80,54,5,85,178,132,24,81,103,51,32,242,159,30,191,35,44,183,139,225,207,126,157,212,42,182,165,88,42,247,68,195,16,218,19,51,240,159,223,85,194,111,171,13,201,117,104,117,197,159,162,202,140,78,42,107,148,102,128,120,50,20,51,99,90,100,115,162,82,253,88,42,127,195,18,70,3,199,67,44,76,119,219,84,113,52,73,254,227,40,115,99,31,87,48,228,201,99,137,135,207,111,47,199,197,182,154,195,246,114,232,50,57,98,218,232,118,252,254,189,65,242,132,160,43,19,99,238,113,143,100,167,141,43,251,200,105,82,109,19,51,239,92,202,28,103,42,15,98,39,49,216,208,107,24,236,39,41,150,75,158,215,145,150,49,37,58,74,233,246,153,106,201,21,36,115,6,49,133,85,11,253,31,247,214,7,30,82,122,255,124,225,237,17,21,113,100,139,13,102,100,159,165,68,97,205,80,213,251,45,19,221,125,238,240,206,204,79,17,170,80,160,19,255,86,114,17,175,247,208,19,202,67,134,175,233,80,108,143,106,14,185,160,110,115,98,227,104,35,82,26,74,11,76,90,72,128,219,48,80,118,199,71,34,88,193,197,52,114,152,219,112,239,42,58,177,107,65,29,145,160,239,91,169,218,113,147,124,20,6,100,14,77,26,249,79,24,168,199,40,24,117,10,246,172,202,25,240,64,108,126,130,102,231,157,1,40,232,106,198,122,22,147,212,106,79,70,232,126,106,238,194,129,42,167,235,64,161,42,145,206,45,152,97,231,41,158,27,223,185,140,111,6,77,137,226,208,220,139,3,190,86,134,111,130,208,122,117,167,49,186,255,146,196,151,177,147,46,156,200,244,118,59,87,236,141,234,52,158,196,240,90,208,223,195,229,158,212,236,93,11,38,103,103,206,211,119,144,103,99,203,50,237,82,216,177,144,5,68,206,156,105,99,203,82,43,229,205,253,112,122,10,30,22,237,69,16,119,59,31,74,50,78,118,190,252,242,6,17,130,51,144,79,176,47,140,187,243,80,139,88,84,18,212,176,206,245,199,230,32,46,242,190,66,231,53,41,36,131,101,172,69,209,81,115,65,25,98,241,129,154,170,171,210,223,55,136,119,253,73,97,80,32,20,88,90,36,143,190,190,210,15,150,57,223,24,255,9,184,38,128,247,213,246,187,41,50,154,98,226,192,242,156,244,49,198,97,252,42,248,132,37,199,215,37,220,149,41,197,218,22,145,74,186,144,185,20,186,237,221,52,135,102,162,7,168,21,237,232,143,237,131,58,213,92,240,206,229,198,102,3,147,40,21,21,155,13,216,235,70,174,53,220,129,68,242,78,82,106,76,17,57,251,155,115,32,202,84,226,82,151,243,20,65,151,66,193,12,143,56,87,123,227,141,250,69,40,139,154,10,228,17,214,174,179,204,104,80,101,64,249,181,31,28,156,154,207,224,240,221,101,196,165,227,203,98,245,196,183,100,200,232,81,254,88,35,138,169,118,163,115,174,43,27,146,82,34,76,252,110,34,116,152,108,38,132,134,73,230,153,152,188,150,77,2,202,20,107,149,229,149,75,163,174,68,114,102,201,131,150,79,93,201,144,108,67,53,126,156,83,45,119,206,51,213,122,20,177,94,131,228,26,7,98,249,189,134,196,84,36,0,95,235,176,166,221,255,19,143,1,167,109,62,193,55,56,106,211,170,53,71,177,148,8,95,167,117,156,47,161,4,241,47,168,233,110,176,184,173,3,83,238,19,253,105,189,229,78,194,70,168,96,116,96,60,174,24,152,47,99,75,108,25,35,5,138,58,206,38,195,74,151,86,58,119,236,34,193,32,74,155,61,255,79,222,17,102,236,85,181,232,74,64,178,41,252,82,193,236,255,88,240,196,177,32,215,155,65,63,229,46,7,58,166,154,132,185,16,3,226,19,90,102,229,187,110,52,28,44,212,121,7,74,141,76,28,119,110,0,132,106,63,16,157,69,54,198,129,77,84,66,116,157,75,195,185,56,113,27,78,191,88,221,226,56,13,99,170,139,148,199,21,101,35,40,195,43,243,117,2,80,4,199,69,187,22,224,43,144,91,100,246,163,249,217,59,162,135,71,79,125,147,201,202,64,5,172,228,199,222,159,240,60,46,192,62,146,147,153,93,183,152,227,13,22,202,47,56,142,218,71,44,246,124,96,224,158,86,234,125,83,87,255,67,1,205,2,109,218,246,135,36,235,210,14,234,197,125,81,10,144,6,160,42,8,43,163,78,185,89,94,229,252,104,81,22,21,188,58,146,240,39,235,117,97,84,201,55,233,56,42,17,227,92,255,44,246,86,134,6,37,94,211,226,140,49,74,115,241,126,223,146,203,230,176,171,249,12,6,76,48,9,189,130,232,212,51,163,133,155,190,94,62,52,150,16,145,134,111,110,162,81,221,60,135,29,137,140,155,80,9,29,0,199,229,162,118,105,84,146,201,216,159,165,54,63,116,135,182,35,152,229,124,192,184,97,70,172,74,196,170,98,57,255,198,136,93,222,134,246,118,233,20,24,25,63,20,228,119,131,68,72,237,127,253,181,104,134,116,235,246,176,110,7,64,62,207,134,15,11,58,178,58,233,224,3,87,13,208,183,5,33,124,28,163,8,254,86,33,116,61,33,21,219,253,248,31,103,59,44,165,205,50,190,156,143,179,228,26,73,221,133,2,82,38,35,229,235,224,48,173,92,85,86,12,204,231,97,20,51,86,23,134,67,108,190,121,12,103,46,91,196,213,58,146,55,40,201,239,252,218,185,79,127,171,190,192,75,109,183,84,218,202,245,23,111,110,171,231,30,86,26,24,180,82,207,228,231,158,27,128,98,58,82,221,116,228,176,10,197,19,201,39,100,234,79,118,35,32,49,40,23,24,112,100,32,13,216,162,241,74,114,41,33,242,40,79,136,129,129,238,186,64,39,105,47,59,104,98,144,77,64,114,180,240,98,17,152,109,178,214,81,117,96,5,157,92,184,28,31,206,103,30,107,28,104,157,125,63,125,198,235,21,102,183,99,236,51,185,18,184,55,79,157,47,26,129,65,234,53,105,153,140,232,32,224,10,91,150,86,181,31,47,47,185,198,230,124,85,176,62,130,93,174,191,136,45,142,86,186,82,52,155,54,49,185,101,128,225,36,142,162,131,89,101,17,25,235,238,69,180,193,251,46,12,208,254,8,183,57,91,166,203,126,220,69,27,184,27,170,245,95,82,192,188,52,3,172,192,59,225,82,26,248,3,1,56,226,198,121,7,234,250,15,15,66,198,143,18,91,234,164,161,227,54,16,14,79,242,204,154,136,5,74,83,66,239,190,111,209,213,90,93,71,73,234,23,38,144,55,140,115,135,159,244,26,200,170,104,118,206,3,63,111,238,181,123,111,254,0,13,205,235,123,252,76,7,5,110,144,73,167,229,35,106,76,248,222,80,186,83,218,221,71,26,250,110,160,191,205,211,90,46,164,3,252,173,156,232,140,65,44,49,172,141,143,231,165,80,17,157,128,6,64,200,172,64,119,153,52,218,204,234,161,91,106,89,192,80,200,186,157,94,204,247,138,243,170,205,8,45,200,197,250,240,56,242,233,243,149,82,232,92,136,59,37,253,252,14,194,15,81,127,91,41,113,53,172,149,98,169,76,203,243,43,22,156,99,193,106,201,104,63,148,132,110,122,151,202,90,63,243,175,15,167,210,225,78,178,177,188,79,133,193,103,10,176,237,71,253,49,201,83,220,166,107,232,88,0,208,4,114,29,213,186,168,150,201,60,24,247,226,253,121,191,113,16,55,134,144,1,181,187,32,34,55,2,153,43,84,45,28,53,199,103,188,45,124,102,3,79,102,46,201,170,77,203,57,83,194,170,9,167,115,255,146,71,108,108,87,210,126,140,46,9,106,3,171,194,82,7,172,12,116,17,49,18,71,237,126,82,36,91,35,236,145,228,40,196,242,238,7,130,78,230,182,230,60,243,192,118,67,118,111,9,8,38,217,51,58,50,138,232,105,167,16,76,182,107,136,218,46,35,213,12,6,21,104,134,167,78,127,171,132,255,85,146,80,98,136,62,25,229,138,200,14,76,111,63,168,147,187,193,10,95,173,158,191,99,202,68,108,73,162,57,133,222,229,201,27,179,6,238,61,74,58,131,224,249,92,34,199,164,20,155,227,223,127,75,87,214,69,28,179,1,73,90,17,87,147,146,50,152,74,251,191,74,197,165,170,115,89,84,59,201,242,61,215,86,125,184,114,197,124,111,23,156,47,206,57,141,221,37,240,138,97,118,67,90,14,170,57,46,81,173,72,245,7,142,91,40,15,101,152,116,204,178,91,27,190,233,107,204,142,114,23,34,9,11,134,16,129,92,26,121,254,28,62,54,84,184,219,98,107,66,212,199,120,160,49,240,131,230,99,215,146,146,123,106,185,0,123,61,218,135,150,107,157,165,220,43,61,56,211,73,42,211,164,109,143,112,211,104,162,197,160,37,148,64,13,85,109,253,87,144,26,235,236,232,229,225,29,250,4,186,118,158,36,16,100,167,204,84,40,255,237,232,120,119,104,89,56,225,32,175,234,225,231,20,173,50,147,175,150,161,235,38,20,2,4,76,151,62,56,228,113,75,88,154,10,131,80,254,181,20,242,138,27,159,251,198,220,107,145,234,155,156,235,238,114,71,118,51,178,162,86,31,231,92,104,45,156,154,39,94,143,70,101,159,219,54,213,244,116,34,143,159,142,228,201,194,67,215,37,160,101,217,160,22,190,100,233,132,203,161,199,125,202,60,11,124,98,90,205,128,62,12,3,188,159,83,200,183,114,108,168,146,155,217,16,204,114,141,232,76,187,57,2,10,107,155,232,46,88,237,116,68,0,119,170,214,157,238,76,80,69,97,81,240,180,38,2,28,12,245,97,71,194,163,198,90,240,26,117,162,219,128,198,205,91,21,204,39,134,118,23,200,210,233,46,169,224,126,212,243,221,81,62,167,2,254,110,64,138,116,50,127,6,187,76,76,171,181,122,143,237,100,65,172,173,117,204,200,20,243,206,101,169,151,219,42,83,24,225,100,191,103,226,46,158,30,85,93,230,188,122,212,31,52,157,94,74,35,118,246,185,178,107,50,231,5,9,149,68,4,119,11,225,33,104,12,128,247,46,149,203,221,245,150,4,123,154,77,158,0,93,80,27,255,237,10,56,175,133,185,17,68,15,11,199,248,71,183,158,249,147,148,188,199,107,84,226,168,230,137,221,26,146,236,236,216,65,124,255,117,28,123,214,80,98,100,144,225,196,36,211,12,92,30,133,236,14,217,228,99,104,224,63,197,0,192,247,137,69,177,125,216,64,210,225,142,39,181,88,111,3,212,171,71,70,229,195,151,132,59,53,123,35,141,138,249,227,242,171,36,17,16,187,164,238,226,179,244,103,137,35,188,243,137,195,85,162,9,143,67,22,185,74,188,90,118,45,13,76,134,65,239,27,197,43,204,125,150,222,233,248,75,121,246,255,138,168,2,58,193,32,243,86,81,42,54,61,143,63,250,252,148,26,20,197,12,74,185,65,30,124,49,49,179,73,72,84,21,106,237,45,3,78,100,5,230,193,247,135,173,83,105,214,5,172,242,151,97,218,250,170,81,190,55,107,231,50,167,59,128,42,22,136,199,244,179,206,223,220,13,52,184,197,208,171,43,141,37,253,201,118,27,192,26,159,217,158,218,233,224,221,17,61,84,73,195,223,239,177,159,78,234,138,238,13,74,176,183,93,201,177,162,221,109,144,169,52,202,181,138,136,3,48,109,162,241,10,247,233,101,245,243,70,127,170,116,62,64,133,48,178,112,194,238,45,75,166,90,250,168,200,205,183,2,134,182,254,249,226,201,2,77,251,77,95,242,10,124,69,72,139,166,31,215,6,90,33,27,227,145,78,87,170,112,235,45,239,155,18,175,205,249,43,29,7,216,196,222,226,250,8,33,91,23,127,104,171,47,207,153,230,5,130,36,199,47,1,16,153,94,89,156,183,215,102,16,87,100,8,62,178,193,204,173,121,3,249,129,151,63,103,167,6,188,46,185,127,195,53,114,3,253,234,26,15,33,146,125,48,64,234,183,45,58,129,123,38,90,251,228,138,33,157,163,107,221,5,157,0,247,149,176,164,129,228,211,226,233,23,12,92,230,13,55,43,146,94,15,77,57,133,46,28,17,159,87,250,143,87,150,84,54,56,86,208,151,204,131,143,5,80,214,50,246,155,128,178,209,31,60,45,201,38,185,51,242,164,143,47,250,122,217,185,204,139,168,90,0,55,112,20,173,98,207,137,82,164,184,12,42,98,245,120,30,139,125,11,20,225,206,160,28,231,188,206,114,165,107,13,7,88,153,210,21,227,146,5,200,80,4,81,52,163,145,163,160,44,190,172,202,194,147,19,246,123,221,148,204,83,248,74,60,115,104,116,17,241,183,27,53,13,221,115,85,98,226,172,32,23,209,113,107,152,28,166,38,62,198,195,57,221,12,95,44,231,196,82,216,53,254,91,190,36,17,126,50,175,162,24,105,105,21,114,223,125,154,27,32,169,154,102,87,121,160,139,88,179,87,236,196,61,63,178,198,33,244,205,213,61,30,176,140,122,58,248,167,26,30,73,86,2,52,58,42,230,218,28,29,121,21,57,13,30,134,58,113,98,55,60,61,57,74,125,20,106,138,139,3,145,207,52,182,173,131,219,57,32,236,13,116,116,86,235,83,61,77,181,57,100,89,131,66,49,67,239,133,24,131,182,93,61,97,27,136,207,200,6,39,2,102,195,56,218,10,41,32,166,163,47,51,249,67,211,110,213,245,99,219,14,224,55,107,7,233,127,6,12,83,74,29,78,58,125,118,145,226,118,5,228,210,58,117,231,149,36,149,52,204,25,69,70,84,36,220,158,59,8,174,26,85,159,238,187,48,194,198,138,110,171,143,149,29,247,30,134,126,237,168,25,4,248,46,168,134,148,38,210,64,41,210,153,202,39,15,133,86,28,154,159,219,238,160,147,92,76,168,194,226,155,100,38,132,239,197,115,255,32,120,83,111,33,131,128,95,183,56,155,157,238,6,125,80,39,49,244,7,214,42,134,47,175,62,23,118,18,45,163,48,40,215,210,131,207,51,251,209,42,30,92,92,99,67,214,170,166,71,174,35,102,82,52,131,131,74,165,158,67,237,140,49,81,154,229,251,42,149,171,253,205,116,14,53,104,171,210,243,28,51,246,105,88,199,206,231,18,229,156,25,191,42,136,238,44,243,76,22,183,179,207,70,12,245,165,28,49,37,192,42,207,49,25,182,176,140,211,204,92,135,25,233,41,197,237,245,203,196,124,232,167,120,252,242,211,228,20,227,235,207,141,197,13,178,85,86,217,138,211,28,46,227,52,211,222,236,163,166,77,80,220,186,164,119,90,253,67,127,139,107,143,60,141,151,30,51,24,250,226,73,1,196,5,149,26,215,166,109,93,190,59,105,35,182,105,219,94,240,135,144,198,8,93,188,203,78,149,168,208,30,122,56,83,72,10,241,248,64,208,38,157,67,156,124,85,125,34,221,212,201,153,78,100,44,23,223,249,76,71,227,61,237,52,55,87,210,181,66,69,121,17,213,179,211,130,95,4,67,93,220,254,72,123,165,149,139,231,252,185,182,28,169,136,121,50,82,45,95,100,230,98,107,174,183,133,14,26,45,108,80,255,184,207,206,137,7,200,164,235,200,141,197,79,139,247,169,121,157,14,93,127,117,233,72,180,196,159,216,108,185,124,171,237,56,236,66,117,232,149,251,95,181,227,243,16,193,99,16,59,135,7,207,39,162,39,17,84,125,186,254,247,25,82,44,151,233,95,37,46,129,5,163,125,122,222,32,170,15,119,172,132,240,229,52,122,251,123,154,143,149,112,255,124,193,15,168,188,144,41,96,43,114,113,142,183,179,5,1,83,227,3,198,123,177,96,24,192,214,99,99,242,125,115,29,170,210,239,177,3,188,150,207,196,194,184,145,217,78,150,112,239,122,155,211,183,217,142,178,214,235,48,234,126,45,155,72,182,255,28,224,255,9,126,202,41,241,210,243,174,175,191,193,139,250,190,186,211,56,39,233,139,150,245,33,250,170,182,203,145,160,255,3,168,124,75,193,142,8,187,58,82,143,36,31,145,60,28,84,65,235,74,228,0,241,15,90,83,87,20,89,179,75,12,132,253,129,24,204,188,78,136,30,78,139,27,18,19,172,56,66,246,149,13,219,20,144,33,33,245,208,183,105,191,27,173,191,99,150,152,200,173,229,161,156,195,127,174,218,230,218,152,170,94,128,10,65,216,198,6,190,75,106,94,182,187,237,218,182,159,174,191,139,123,253,65,38,144,104,129,19,110,240,132,154,53,30,232,62,36,74,132,179,81,149,163,182,179,47,137,170,11,54,235,102,227,204,187,148,196,59,184,100,40,183,7,20,202,11,163,69,179,238,96,200,252,166,179,152,87,28,186,133,73,98,135,127,98,123,139,138,45,155,89,196,170,19,130,32,45,41,217,143,33,118,152,198,182,103,126,181,54,81,113,162,198,83,206,181,189,252,159,117,14,224,0,43,36,170,235,89,252,152,8,159,216,124,224,51,202,20,25,152,205,89,82,53,47,41,133,100,31,36,39,61,140,30,23,186,184,172,208,18,58,2,35,203,144,160,119,32,7,41,188,151,226,234,200,189,184,48,190,63,78,13,225,54,45,49,14,84,10,228,47,252,180,44,209,124,113,1,241,240,62,117,87,110,139,246,146,9,79,39,37,207,157,56,79,166,129,37,135,13,36,107,34,234,34,22,155,55,120,3,47,88,125,152,133,25,110,231,12,95,112,173,135,181,223,18,99,180,193,54,237,246,161,87,53,79,205,196,59,221,145,69,51,13,77,112,2,68,31,218,209,183,6,254,77,74,72,219,103,176,10,162,80,229,70,133,5,152,237,5,23,232,233,169,243,222,113,41,196,57,196,171,209,71,186,168,180,94,166,135,130,220,57,146,202,121,200,86,102,15,19,125,14,84,101,51,50,111,251,81,83,132,118,23,30,167,58,162,76,175,7,207,237,94,139,191,169,199,8,46,4,151,132,223,245,220,1,150,69,237,36,240,32,14,118,101,219,109,68,207,58,46,43,73,38,204,116,89,4,41,74,255,186,69,99,74,240,167,119,79,152,75,64,129,252,186,14,146,173,134,48,64,252,51,177,226,205,30,28,58,70,216,185,175,166,29,175,236,15,144,23,240,192,103,107,28,101,37,208,189,205,84,193,11,113,234,36,45,238,8,67,155,51,52,148,8,192,67,194,213,16,11,223,174,54,50,232,143,7,227,120,39,136,69,227,231,127,237,30,125,145,0,198,124,248,1,3,54,245,83,178,175,226,243,128,53,30,89,19,186,21,139,191,192,54,141,63,195,12,174,31,233,74,67,115,93,221,54,225,232,69,82,29,37,212,136,109,136,155,36,53,159,67,245,9,206,60,238,211,217,24,234,2,235,5,110,227,186,175,165,248,29,230,98,193,222,144,185,241,61,147,229,204,215,229,49,241,239,133,250,127,184,143,125,94,23,204,138,94,254,244,137,123,18,108,141,253,26,141,33,154,32,126,134,27,197,20,28,164,59,13,228,104,199,198,29,215,176,173,109,229,212,30,105,58,173,63,80,127,200,240,125,56,214,229,106,210,212,250,52,110,95,0,231,135,213,153,26,69,93,1,59,13,31,158,92,205,206,229,125,74,59,67,123,20,118,236,93,181,176,74,19,151,186,16,97,138,126,242,248,247,43,35,107,157,163,75,167,35,88,13,70,31,154,212,181,18,42,165,33,98,60,133,128,250,169,212,40,200,32,192,214,113,250,102,93,248,93,76,200,72,238,98,112,75,177,37,64,74,146,66,90,91,175,231,145,125,243,185,251,99,52,212,242,188,74,191,193,223,139,1,224,142,86,231,124,158,181,54,73,34,166,221,234,146,133,234,15,37,253,189,70,76,220,181,230,17,8,205,98,65,2,177,64,60,168,204,69,72,201,3,194,120,252,173,78,241,196,3,121,68,245,229,170,164,201,116,132,65,177,61,72,153,60,133,254,75,130,138,255,94,14,18,41,128,46,17,46,144,176,139,78,245,51,198,155,114,180,233,75,155,24,39,31,96,170,106,182,175,52,216,83,95,149,103,252,95,107,217,63,194,149,17,78,172,162,59,245,255,178,21,44,0,108,11,242,161,76,235,217,90,193,117,200,103,99,235,98,236,187,166,117,115,130,203,9,18,68,204,97,185,76,168,105,77,115,181,171,63,121,31,117,112,106,130,201,254,160,237,25,205,125,16,124,176,242,113,72,44,27,149,172,105,237,223,214,31,7,36,175,201,173,122,179,132,202,214,209,26,95,55,209,241,141,71,69,95,178,82,63,0,207,215,12,122,157,51,55,205,248,44,235,117,163,87,22,198,217,44,35,80,15,152,141,23,204,79,110,48,15,237,88,227,13,149,158,81,235,234,209,164,121,250,35,24,225,239,196,211,240,85,69,198,134,227,101,238,233,73,65,47,53,163,79,160,49,178,203,160,1,208,19,141,225,96,237,141,209,187,207,108,139,122,252,77,80,22,191,128,207,124,128,89,190,58,88,180,46,251,183,240,133,219,140,191,192,136,38,129,120,66,150,91,235,80,41,229,125,197,116,56,30,96,39,71,229,17,142,243,234,155,50,8,106,242,181,250,172,18,170,223,51,108,15,32,136,251,219,49,207,191,95,171,211,8,43,116,209,190,232,237,136,2,56,22,171,207,230,104,187,115,106,85,118,186,20,161,225,112,180,195,153,68,75,142,239,83,90,225,186,50,189,5,237,145,88,222,91,172,184,44,139,5,138,154,171,187,104,62,160,82,171,145,109,253,154,33,156,95,8,90,190,114,44,212,37,57,221,18,63,27,9,52,100,36,209,88,3,128,242,24,100,156,45,115,208,36,173,112,77,49,182,48,216,142,135,113,144,150,11,58,37,118,55,234,211,38,213,232,219,19,163,109,55,111,100,197,123,181,182,240,146,254,211,252,115,222,207,80,24,54,85,212,10,235,143,181,237,34,192,103,24,37,35,130,0,49,12,191,3,58,46,157,55,200,159,25,85,245,192,192,46,60,89,238,173,49,193,125,196,26,80,26,196,130,4,125,233,41,95,8,18,71,60,96,26,201,65,22,189,3,198,51,216,203,177,141,242,71,45,111,216,112,182,12,63,88,84,105,132,55,89,236,199,239,66,72,11,112,65,252,165,56,6,254,205,186,137,172,45,59,65,153,149,217,101,53,159,178,49,68,150,114,96,83,146,96,97,10,33,136,233,49,153,6,166,37,36,66,140,92,231,191,207,228,171,155,105,145,98,79,29,112,40,145,123,43,20,247,49,84,43,141,141,51,19,186,18,80,104,6,250,3,150,225,239,86,206,50,102,83,144,247,37,39,31,123,206,81,24,248,43,13,13,222,22,107,106,138,72,99,114,52,29,218,194,49,43,39,127,60,151,235,178,112,45,26,57,62,201,236,145,80,49,16,221,203,79,223,8,187,85,72,57,196,116,212,27,120,247,33,29,66,34,103,236,35,20,58,74,35,57,156,95,103,136,186,4,37,164,14,234,122,184,106,15,142,155,158,177,96,62,71,9,137,253,209,252,232,235,16,82,155,94,248,229,193,52,193,246,204,205,163,165,130,76,167,226,107,1,42,79,26,46,34,239,156,253,58,88,24,142,27,250,52,102,113,108,171,52,250,203,204,111,233,58,142,177,134,93,50,84,85,230,162,240,170,95,100,41,64,172,94,115,192,194,144,20,167,39,106,149,36,251,239,111,241,223,66,90,194,240,28,81,173,5,253,57,237,235,246,174,181,20,134,50,199,233,174,1,209,30,35,98,47,159,78,14,39,233,150,245,201,140,75,244,53,109,55,122,66,175,78,214,121,80,61,24,240,180,218,88,102,178,59,118,18,154,49,250,162,31,146,177,0,171,63,238,224,26,218,185,250,198,100,55,228,35,194,147,238,241,20,83,101,58,195,18,45,154,17,193,153,157,36,19,148,136,25,237,224,2,237,232,32,135,9,132,12,137,35,139,46,120,124,69,120,85,150,153,8,31,180,47,30,136,211,229,198,182,45,22,157,6,50,65,101,220,161,9,151,198,39,100,72,55,78,2,95,186,47,230,73,191,78,200,122,61,165,253,165,117,188,160,105,218,181,240,219,22,53,237,216,176,235,226,181,224,181,245,210,145,71,211,181,77,34,225,217,134,244,200,187,30,236,226,220,61,28,205,27,250,61,133,171,249,219,224,5,164,62,112,74,227,197,201,5,241,47,109,74,189,12,54,51,222,36,206,215,13,66,49,10,201,51,127,124,239,53,229,139,13,114,241,254,52,38,57,171,228,21,243,235,236,251,252,209,241,41,146,65,196,228,217,161,18,221,48,143,224,227,175,92,53,133,222,211,133,1,73,127,102,44,252,157,253,213,168,168,132,222,13,50,229,219,198,244,144,224,135,50,163,127,178,231,154,22,60,77,100,191,189,153,212,147,198,28,164,216,1,221,86,28,117,112,3,19,220,22,115,236,128,36,161,161,200,192,114,252,112,236,73,210,112,242,105,31,197,27,239,58,46,68,31,158,144,139,184,126,2,132,235,205,58,105,21,124,87,51,193,209,33,139,130,208,76,25,137,173,0,28,100,68,198,4,79,65,13,2,98,170,255,145,87,90,173,197,72,244,209,119,54,72,161,143,19,244,132,104,0,77,64,97,26,158,212,230,82,246,21,30,105,32,150,201,0,218,94,147,143,233,78,204,177,203,85,149,218,146,11,180,246,18,247,224,55,215,73,71,135,62,154,141,30,226,12,244,213,126,176,253,39,236,145,248,251,226,238,22,207,172,231,144,225,228,161,13,143,91,152,249,232,190,42,11,76,207,121,131,222,207,184,48,120,238,136,63,48,50,211,240,167,206,38,105,162,160,60,245,56,193,101,94,170,226,48,159,55,238,166,247,142,112,43,249,14,90,124,172,228,240,77,212,19,217,108,3,53,3,125,83,204,206,172,207,132,13,14,106,216,30,197,50,64,143,145,39,188,175,206,236,20,74,52,228,152,77,206,231,40,78,25,229,0,148,78,4,219,220,180,48,6,136,168,46,47,110,230,140,189,163,127,62,18,157,27,154,187,9,89,255,32,138,141,149,74,252,13,57,86,169,67,247,79,130,113,145,30,251,171,160,78,215,0,24,76,108,248,7,219,182,232,127,99,29,62,191,17,90,18,109,178,45,190,82,43,14,190,114,29,62,53,212,149,165,168,241,16,255,139,237,124,182,96,248,177,227,202,182,115,202,253,49,117,57,99,186,67,152,62,24,195,255,14,39,175,61,249,30,230,175,20,10,187,7,197,107,109,166,242,232,253,55,128,9,37,106,41,30,96,160,254,205,22,127,60,202,231,189,24,119,57,220,0,6,207,35,250,98,49,9,84,20,195,104,246,85,167,26,94,43,234,236,55,66,34,62,97,204,192,35,233,119,186,124,50,26,49,14,207,118,50,108,94,214,131,108,37,123,29,29,221,187,120,166,17,246,236,122,91,64,149,95,175,23,17,56,233,33,157,109,30,104,211,32,12,124,215,25,129,67,212,240,140,102,193,91,195,255,145,168,29,31,133,246,78,92,17,94,22,93,18,253,94,37,150,12,212,204,146,70,154,74,224,136,203,133,5,39,233,2,84,106,159,56,233,53,255,151,189,98,164,30,149,59,184,197,112,22,159,0,61,182,170,250,100,235,232,84,187,165,104,32,248,16,211,97,174,64,75,88,132,17,243,130,71,251,46,99,53,207,165,149,213,169,73,56,42,213,189,219,42,189,154,200,131,233,28,214,13,40,132,188,184,57,213,85,92,32,57,29,64,165,88,157,115,78,163,180,152,244,202,9,172,8,233,109,125,52,172,69,17,151,110,107,240,25,152,49,24,229,39,30,111,39,195,164,242,144,190,244,228,124,16,174,46,88,43,0,169,250,73,97,46,118,223,179,73,239,200,85,243,182,254,32,178,218,113,52,177,61,169,126,150,2,94,40,162,48,29,76,95,2,14,66,151,93,246,223,148,0,41,24,91,36,200,171,62,131,111,173,41,3,88,145,46,161,16,236,9,151,56,111,237,187,4,130,158,169,186,30,132,244,95,88,89,177,162,202,253,206,32,253,186,190,224,152,105,82,94,242,157,97,204,219,184,218,200,82,28,59,207,102,164,41,88,134,105,141,220,133,238,99,193,22,112,130,183,172,234,16,5,79,8,203,100,61,160,93,28,143,143,27,99,240,216,96,232,97,80,11,66,229,42,55,101,99,19,19,160,220,53,203,33,59,140,107,162,129,190,27,79,106,142,103,238,10,146,8,175,86,228,47,235,169,20,42,121,97,249,130,44,77,254,47,55,197,194,11,230,101,242,225,140,207,78,122,187,106,239,175,220,185,188,160,113,90,237,206,46,66,162,62,176,140,161,47,187,98,131,192,249,179,80,51,163,181,172,141,220,239,11,119,162,185,180,65,72,130,78,56,61,187,242,36,70,204,13,62,235,212,183,143,162,188,49,253,166,181,25,179,215,183,193,185,165,128,58,56,85,51,245,86,103,121,162,162,195,199,74,67,115,227,160,71,87,226,91,174,135,255,90,150,16,174,68,70,140,208,34,1,32,168,197,48,255,228,179,30,244,255,253,211,152,169,51,84,107,87,58,43,237,64,130,241,173,66,0,116,6,78,158,26,168,217,171,74,104,32,146,168,30,192,159,120,149,32,55,161,129,204,129,79,28,155,142,168,89,69,241,89,91,17,157,205,22,23,21,210,125,69,183,240,184,203,103,242,147,0,65,179,215,178,221,147,167,220,16,49,238,163,224,147,136,73,164,61,138,132,55,219,211,126,182,51,72,14,220,124,27,65,68,158,90,142,23,132,63,24,18,160,72,232,82,144,159,217,246,244,114,145,233,138,128,38,182,193,99,19,124,62,134,76,155,198,213,134,108,19,130,79,204,16,210,115,228,58,73,246,218,243,151,123,192,12,248,221,61,135,9,207,84,229,23,207,55,149,131,55,1,123,160,190,63,244,114,228,6,229,60,249,232,203,97,183,216,243,143,161,66,144,179,21,16,123,137,225,64,109,52,246,231,142,238,125,128,140,147,72,10,170,160,30,221,129,246,205,247,109,195,162,168,222,143,158,75,106,145,29,148,35,38,62,65,253,193,236,226,36,123,2,59,215,112,230,222,228,58,6,186,57,109,248,176,0,101,57,175,150,19,242,112,70,87,96,173,235,163,182,123,141,31,139,234,242,14,51,178,238,30,111,201,157,149,105,73,251,196,75,207,129,58,178,210,218,34,2,80,93,196,15,57,28,190,187,35,235,220,36,145,102,12,144,201,45,128,6,215,108,66,240,20,139,209,150,81,69,222,175,36,107,193,14,217,225,140,238,184,146,233,0,174,70,149,111,102,35,44,179,73,54,109,150,48,47,9,148,41,37,98,148,64,100,207,88,32,54,179,135,115,93,34,92,23,140,245,185,120,127,29,0,153,155,42,69,1,40,82,117,77,185,143,181,183,49,95,102,149,136,216,169,139,59,83,79,149,139,137,18,191,230,128,26,97,169,132,5,139,61,161,218,53,130,45,120,110,180,241,98,144,54,161,62,105,236,237,85,113,48,155,83,123,46,61,16,161,44,81,45,34,245,162,232,103,10,176,235,28,212,60,235,49,190,134,118,12,32,189,209,56,62,222,7,101,47,17,108,31,126,41,90,137,77,66,63,236,80,237,240,182,194,108,42,159,169,209,112,235,104,43,223,108,179,34,178,64,87,29,92,75,188,101,180,25,169,30,132,75,188,40,175,46,215,80,93,63,235,188,220,250,125,109,73,111,100,135,120,129,144,12,226,208,77,165,46,5,172,41,130,17,45,31,4,9,189,139,174,11,79,192,243,135,50,21,144,170,173,62,225,124,253,241,35,73,19,156,250,87,181,11,93,247,182,25,187,170,184,178,13,154,237,204,24,80,223,226,95,100,168,95,36,68,239,156,89,49,67,33,107,189,109,163,17,93,80,172,118,146,246,252,19,186,61,117,38,195,229,167,132,13,124,116,9,214,57,253,147,153,127,51,159,202,164,115,33,137,119,155,30,247,244,67,160,211,138,14,216,64,18,91,227,216,119,90,70,105,191,181,109,133,67,31,160,112,81,164,163,22,187,133,143,156,110,172,232,88,252,217,213,101,189,28,51,59,151,39,127,198,201,58,254,178,17,149,164,143,207,19,65,243,120,186,48,185,238,162,107,16,249,141,252,108,241,209,59,189,237,130,41,145,219,96,70,60,55,46,59,138,129,63,46,144,246,45,163,125,17,81,234,83,50,152,211,184,161,72,3,128,61,242,51,198,99,85,62,148,125,207,231,220,26,107,116,111,228,52,237,229,221,34,195,132,252,218,23,177,245,120,110,97,129,94,251,235,144,75,38,14,102,95,134,85,162,35,1,57,56,101,14,189,66,80,156,33,104,104,169,226,56,83,248,142,83,191,146,239,203,202,99,158,179,106,249,225,207,28,233,131,41,192,221,48,106,97,29,149,188,219,78,143,97,48,125,78,253,222,111,142,165,37,68,210,1,86,53,44,31,30,243,122,208,210,23,93,119,198,58,193,157,25,155,25,60,112,47,207,169,118,180,204,163,81,35,20,63,13,114,145,179,93,215,85,140,128,68,231,10,88,13,240,0,152,105,53,162,97,150,232,146,184,121,63,214,38,244,229,46,166,180,177,115,237,178,134,26,60,19,246,87,60,102,57,134,69,13,210,240,186,115,131,200,78,51,69,224,188,64,242,202,15,53,104,255,148,155,178,192,170,146,96,142,163,192,85,28,219,27,150,138,240,142,29,120,0,104,175,27,154,73,234,86,161,148,90,111,82,182,164,135,35,25,247,82,126,5,172,184,53,181,125,173,112,169,157,195,68,83,159,64,121,57,67,166,215,65,82,206,145,230,63,246,122,225,203,60,71,196,156,243,184,26,104,186,19,86,137,242,17,186,190,113,187,22,141,161,153,56,106,138,122,38,190,175,11,65,217,95,108,51,100,237,235,162,219,151,127,23,244,234,119,188,235,87,97,120,162,187,196,237,211,3,223,4,26,48,180,211,221,54,206,47,238,18,71,122,195,176,213,1,13,213,137,122,25,184,110,253,168,166,20,62,207,109,4,230,0,62,242,255,114,135,123,87,26,63,112,59,237,11,43,67,21,123,46,10,187,127,126,86,67,252,198,105,22,100,109,204,142,20,140,115,60,13,144,11,132,198,134,110,6,88,78,204,216,253,56,209,163,150,231,154,210,73,176,222,158,119,254,250,211,231,156,29,5,6,137,196,8,98,54,196,18,68,63,68,108,65,200,205,151,140,54,190,153,174,55,37,17,247,80,224,130,110,76,187,136,254,108,213,238,198,39,189,170,13,96,6,136,211,20,17,71,255,78,57,187,88,13,131,102,225,143,38,98,25,98,31,69,84,64,174,25,109,36,93,57,97,73,150,37,182,45,119,51,169,184,183,19,226,77,6,14,7,185,50,247,143,172,56,27,11,7,232,102,138,210,12,6,28,28,36,16,178,137,139,8,148,184,42,10,123,34,70,245,15,146,53,16,214,190,188,18,223,161,108,99,158,12,172,198,104,206,45,168,39,70,55,126,192,247,129,52,94,193,155,50,149,204,148,59,36,33,192,219,144,192,246,32,229,45,124,64,157,107,255,23,50,37,209,176,73,70,126,6,117,193,74,195,155,0,37,92,75,252,97,69,47,207,16,116,254,189,75,231,41,237,106,182,65,101,21,168,207,231,166,6,95,141,32,166,58,79,129,186,108,34,203,201,196,242,31,111,95,111,68,205,124,75,28,250,96,130,251,51,49,153,229,9,112,136,43,88,196,172,216,146,13,254,114,191,139,251,32,159,63,60,114,56,239,170,190,76,235,197,69,34,138,28,176,125,56,142,56,22,244,207,213,227,9,207,80,227,185,186,208,10,118,93,124,217,215,242,233,20,20,150,174,72,79,109,15,233,36,23,63,107,27,28,117,25,204,235,201,165,198,133,150,217,222,44,148,65,56,54,123,208,239,97,219,234,94,48,196,142,112,44,117,141,103,223,151,148,110,21,123,171,172,208,144,174,252,153,115,87,218,238,236,35,253,182,71,238,97,161,106,251,195,254,238,236,48,6,191,12,56,201,95,140,60,52,201,243,137,241,208,130,99,234,184,72,149,32,69,185,40,164,234,114,139,57,185,75,32,17,111,190,180,184,34,39,128,114,44,155,183,113,38,4,23,112,112,100,247,49,108,137,199,163,24,48,65,180,180,170,144,215,107,39,243,174,63,204,227,246,82,197,41,123,55,196,59,218,28,85,49,121,126,29,244,81,182,19,90,138,103,125,92,16,100,106,101,151,74,99,86,45,81,120,142,82,119,125,0,13,33,168,188,24,187,82,212,177,241,106,156,112,0,122,70,170,36,221,143,73,160,243,109,110,249,128,149,183,199,68,137,16,152,133,16,55,145,157,27,240,188,105,107,154,138,90,16,33,44,186,215,175,189,186,18,220,217,183,255,148,212,102,125,165,143,97,254,163,98,191,199,107,45,26,63,129,27,136,235,51,45,171,36,186,74,229,33,83,215,109,244,110,69,193,164,175,35,155,251,22,65,157,195,124,122,87,23,163,96,136,225,175,222,146,137,233,89,254,63,46,44,126,5,173,41,11,57,107,127,241,113,163,6,141,85,16,32,110,185,252,150,172,61,202,10,25,183,127,73,169,153,180,99,90,31,243,152,252,59,144,153,174,87,253,167,242,131,217,235,31,222,0,240,194,184,66,68,86,196,22,11,140,70,74,86,7,205,13,25,191,200,77,6,142,238,198,7,122,162,254,73,9,242,211,3,90,167,212,33,223,250,204,7,105,113,18,144,124,153,102,6,57,28,187,138,43,52,74,149,207,168,247,15,80,120,87,103,230,36,35,86,211,207,216,153,44,51,181,20,20,119,201,116,1,80,181,134,10,136,164,178,55,126,8,211,251,24,147,169,25,215,8,180,194,39,18,121,30,214,109,210,101,68,17,42,25,37,173,232,228,156,13,109,77,246,183,131,185,135,218,62,74,127,149,221,186,82,218,166,142,139,159,141,163,240,71,116,140,142,208,129,132,131,204,7,173,25,215,64,199,163,54,187,82,37,43,142,153,196,199,252,159,23,111,134,188,80,197,82,191,37,80,189,140,192,213,91,102,26,194,161,91,133,201,129,207,178,185,145,121,247,194,237,7,111,246,71,96,106,124,198,3,246,106,232,127,244,145,188,132,229,111,224,179,21,234,186,37,221,104,16,215,77,11,38,82,202,125,246,188,182,114,240,137,92,216,124,253,234,87,22,50,8,131,191,247,52,63,155,22,26,150,224,49,190,120,161,2,48,230,136,188,47,105,158,243,61,241,208,76,115,98,200,17,118,15,74,179,32,228,239,19,4,220,220,95,159,194,171,14,72,141,235,39,135,102,60,216,25,40,236,13,104,216,242,162,117,93,87,102,149,214,238,137,10,91,113,130,140,8,34,227,91,246,21,129,70,0,47,235,11,193,116,54,82,40,52,218,53,54,124,31,109,132,143,67,0,206,174,59,137,69,147,125,170,65,146,45,227,222,32,215,175,62,140,57,21,180,146,38,175,106,27,233,238,87,70,34,230,196,242,156,45,159,160,212,196,107,104,140,62,161,186,229,204,120,100,175,38,136,18,103,192,70,111,144,145,127,237,133,111,181,170,166,237,58,79,66,38,158,143,79,164,233,93,18,117,65,168,4,40,63,83,62,145,199,57,230,152,122,202,139,178,72,41,240,90,165,128,225,171,69,222,220,143,148,148,37,201,146,247,128,175,93,70,221,157,129,4,195,90,61,196,230,217,154,18,216,154,146,237,62,142,116,68,50,63,131,226,21,83,186,150,50,129,124,49,67,151,227,141,35,12,21,237,220,154,121,158,39,138,11,152,88,148,40,107,194,118,151,98,126,154,82,222,171,197,249,100,210,219,184,51,91,215,149,153,126,148,189,24,190,98,57,183,171,67,46,12,105,231,121,66,49,167,34,105,1,254,35,113,254,236,218,102,61,174,23,202,236,247,54,180,26,90,78,124,210,116,245,130,146,67,164,118,171,7,198,174,116,180,124,26,68,33,192,19,146,235,0,229,67,47,243,14,158,210,19,251,115,38,32,216,42,16,36,70,79,159,239,163,169,25,180,63,70,154,202,63,87,53,214,221,117,56,26,61,53,116,136,71,197,40,22,67,162,125,195,182,116,126,119,60,89,20,0,68,221,46,104,159,69,56,203,238,231,214,138,91,116,14,83,233,254,123,60,126,246,36,187,165,98,45,139,166,143,26,29,226,245,57,137,204,194,40,206,241,163,71,233,183,129,16,109,64,190,168,229,90,47,154,45,112,116,82,215,110,113,247,194,69,195,109,116,5,40,159,133,157,26,96,86,133,141,200,84,40,162,122,121,154,111,51,150,46,135,126,155,158,130,50,233,127,106,207,175,183,135,105,113,141,164,208,162,105,158,119,64,174,118,1,107,172,4,175,76,102,163,134,188,145,123,170,11,121,84,152,111,16,108,163,174,251,90,145,255,162,210,146,215,141,190,78,136,35,242,47,100,22,207,211,98,169,21,111,156,150,249,7,107,212,231,119,114,189,136,203,115,31,193,239,211,128,135,137,56,96,93,213,133,203,119,3,69,213,4,187,172,61,226,101,64,132,254,203,167,16,69,156,73,94,83,216,114,204,107,75,150,242,187,60,39,151,232,155,19,250,156,200,183,175,155,120,234,104,149,90,61,104,171,160,116,46,147,4,233,127,159,3,42,221,147,252,61,155,120,173,19,236,44,185,114,132,92,54,106,123,224,37,97,153,12,243,61,221,140,112,147,14,186,174,113,200,139,185,146,212,157,249,16,108,6,183,17,184,76,159,18,113,186,119,165,146,231,219,23,78,118,225,118,192,110,68,144,92,121,255,164,194,72,133,213,11,223,122,216,133,160,22,4,208,107,177,89,138,132,56,10,126,30,166,117,134,141,112,123,148,96,37,97,143,168,80,211,69,101,168,154,101,120,152,50,125,153,43,112,116,85,182,120,205,115,64,121,173,192,4,3,232,234,80,111,46,101,21,229,237,194,103,16,31,15,57,127,29,203,229,251,52,12,29,123,32,247,253,172,121,35,6,25,146,69,75,176,173,189,27,92,77,43,152,95,10,22,187,229,185,85,136,152,191,34,245,50,180,178,192,65,98,160,42,171,180,13,206,255,133,156,67,177,23,144,113,154,191,136,126,78,17,224,22,253,212,145,18,3,149,40,110,68,116,55,79,118,51,83,211,75,112,126,3,119,149,111,55,19,232,81,34,123,192,100,150,19,145,134,45,246,155,64,115,26,32,237,243,161,136,33,243,8,37,200,15,59,173,97,155,7,43,246,82,194,91,214,23,32,139,84,83,28,214,90,185,194,204,155,92,191,149,121,223,21,145,140,95,107,121,224,67,63,187,135,7,223,130,159,164,251,160,212,177,33,226,140,127,107,166,93,151,250,235,164,163,113,29,87,245,159,245,191,32,250,39,48,141,71,89,171,242,5,132,130,24,202,182,120,196,17,178,26,56,122,129,176,255,124,198,148,25,68,130,15,128,118,44,32,252,36,7,20,57,164,167,143,10,247,18,203,138,26,157,144,228,94,231,29,50,99,167,228,183,228,213,252,191,12,164,148,34,228,224,164,190,188,221,106,69,12,75,234,184,220,183,32,9,225,235,176,144,177,33,236,169,42,120,161,148,165,30,247,31,85,212,239,87,53,91,5,130,113,143,17,239,221,205,132,10,232,113,172,1,123,49,79,246,195,50,105,205,114,181,196,49,103,54,160,228,67,3,0,114,179,61,226,231,3,216,39,24,83,106,225,238,112,234,202,37,106,154,39,163,166,44,240,83,174,82,189,6,81,167,55,32,46,113,83,225,242,65,4,113,78,207,251,79,123,79,36,205,95,189,51,180,40,117,147,25,179,176,86,168,2,243,179,181,157,146,180,206,200,100,80,116,115,132,164,116,238,132,188,74,202,159,77,114,163,130,148,134,194,195,44,185,108,202,50,190,255,206,9,19,171,11,183,70,207,212,248,230,238,187,236,68,3,113,228,231,91,167,46,47,255,13,238,136,167,209,194,103,235,175,43,7,19,202,241,59,14,33,62,17,38,197,40,150,163,44,11,133,59,195,8,169,34,59,187,34,106,81,90,121,102,192,36,193,132,115,55,53,96,18,160,199,20,119,28,7,211,146,0,216,6,89,200,1,132,88,156,219,17,142,178,15,80,58,105,246,116,74,18,29,16,37,112,166,120,161,35,244,30,97,17,127,24,40,142,163,200,104,49,122,140,195,40,116,31,196,220,67,112,252,36,243,224,217,206,180,249,107,155,8,127,27,153,158,64,194,52,29,97,216,150,155,223,57,247,52,169,223,168,167,131,27,244,105,56,109,149,196,3,68,126,14,167,165,36,160,205,241,94,179,49,218,12,48,148,217,83,232,5,47,72,166,137,222,34,15,180,54,84,238,210,185,83,91,213,138,66,44,234,191,125,106,120,39,80,20,175,220,152,57,157,122,148,161,71,217,226,55,45,209,20,55,157,188,70,64,195,240,137,179,227,202,69,173,103,155,192,145,32,115,163,45,55,149,32,143,62,193,188,67,219,59,52,101,101,23,33,187,235,94,56,104,33,74,201,136,175,157,193,60,89,150,54,64,198,172,110,255,136,165,86,120,89,25,247,113,150,129,94,215,90,11,252,193,224,115,92,156,137,73,241,22,23,56,6,204,103,172,146,15,37,108,106,78,180,31,155,66,34,201,236,4,25,157,79,84,117,214,216,228,145,47,174,38,30,210,92,142,152,22,65,41,82,115,16,52,215,142,197,247,213,18,104,199,173,244,11,180,145,62,30,113,28,121,31,236,156,21,6,37,51,1,190,117,237,169,157,142,16,41,30,77,108,209,19,194,72,214,184,200,91,12,254,141,133,74,143,152,82,151,77,146,108,159,59,47,222,200,75,140,203,21,184,74,107,88,242,155,198,143,160,66,13,95,194,153,8,254,137,65,28,104,191,26,227,100,202,15,88,236,70,47,165,221,42,59,74,238,107,41,100,111,236,183,61,68,206,189,75,202,104,184,158,165,16,6,82,103,155,19,167,203,243,198,190,155,49,41,4,238,145,148,161,215,31,234,3,35,46,170,40,211,158,200,58,182,108,124,8,243,172,69,97,156,198,29,13,214,214,209,44,156,136,5,205,141,207,202,207,227,204,66,204,239,54,212,1,47,61,50,159,250,111,56,159,108,59,120,84,193,189,39,64,152,165,85,240,178,31,57,120,172,173,226,100,158,248,133,77,210,174,200,110,162,231,128,45,154,199,166,182,18,104,251,74,49,68,19,205,37,58,88,233,2,231,9,139,215,29,112,238,141,183,75,44,134,26,252,14,68,57,191,25,76,181,179,74,74,0,100,21,8,245,51,220,89,39,121,15,223,55,1,132,84,2,249,186,185,36,114,239,167,32,199,70,111,172,81,239,174,1,10,103,60,140,107,81,187,56,9,167,9,84,216,252,209,188,110,133,134,76,166,73,59,230,4,141,238,154,204,104,3,249,162,135,183,22,73,113,242,105,54,231,147,94,86,90,111,217,51,0,73,214,114,94,42,195,40,31,63,205,153,165,53,205,3,29,151,168,151,59,40,168,89,152,193,157,53,42,255,58,30,11,197,80,44,29,93,177,141,164,135,165,127,154,111,184,93,137,190,101,108,98,48,222,30,37,226,172,120,125,57,194,146,221,135,119,143,62,2,126,246,83,55,54,123,95,159,68,119,72,148,15,41,111,164,227,154,90,107,34,86,73,0,45,166,204,95,79,91,40,173,139,198,221,44,103,78,29,251,145,230,110,53,137,75,172,111,196,238,73,49,208,35,177,255,229,173,252,201,176,253,191,94,213,246,84,104,115,129,187,221,131,138,155,219,106,250,240,168,182,123,62,73,128,245,189,208,86,178,47,1,219,39,172,162,38,195,237,214,97,153,55,134,42,151,193,51,239,70,49,33,123,138,197,205,231,245,37,57,77,106,122,89,66,172,73,209,168,237,60,16,193,195,50,45,122,189,19,166,120,206,43,176,230,54,75,22,180,94,103,212,3,59,214,108,218,224,200,17,39,197,115,12,178,27,134,210,214,245,75,83,223,0,122,249,227,28,61,115,226,76,141,171,225,106,215,116,113,161,66,23,198,124,111,31,9,77,16,53,205,106,234,107,199,167,29,83,146,145,235,171,95,90,66,167,178,150,154,239,137,168,133,200,65,213,71,225,172,106,7,204,6,178,247,146,171,125,230,74,19,28,252,86,197,88,109,212,178,177,195,89,232,87,246,229,51,36,203,162,41,72,162,25,146,156,242,104,146,147,66,133,224,117,228,87,227,12,95,108,209,100,53,181,198,93,114,37,129,254,165,56,237,203,19,248,234,32,10,76,3,30,193,196,28,47,188,226,105,215,108,108,76,165,14,150,149,144,223,243,7,153,96,251,51,132,29,190,91,159,129,245,5,198,233,240,54,181,132,232,220,252,5,26,163,9,58,91,184,201,187,15,4,202,54,88,252,88,3,43,191,82,40,65,37,237,189,145,41,163,14,123,218,127,197,115,35,163,45,200,211,205,148,181,55,107,113,130,129,21,51,110,6,158,155,185,244,246,12,11,61,20,213,136,64,171,14,208,10,240,47,8,26,171,145,231,241,87,130,161,5,133,48,114,142,209,68,124,145,51,220,43,124,213,3,69,119,162,26,193,23,226,188,194,16,231,99,82,50,158,113,122,51,36,184,111,46,89,149,116,212,108,89,75,83,69,88,81,93,90,59,159,121,243,28,28,35,164,56,172,121,172,44,88,35,126,92,41,135,177,59,142,216,12,2,71,176,75,100,7,206,161,219,25,29,81,199,227,94,230,135,144,188,65,48,37,41,224,231,190,183,74,204,202,34,93,93,98,221,197,227,85,252,46,150,224,209,153,38,17,43,236,170,226,45,55,142,157,200,20,142,235,12,137,132,134,218,87,136,187,163,187,64,109,2,92,30,146,110,11,113,112,238,5,136,198,201,3,73,43,26,156,45,29,167,152,113,47,138,57,199,65,202,8,154,150,167,31,249,123,217,103,45,146,184,89,30,117,33,35,51,133,243,249,111,109,70,39,209,76,176,7,140,115,195,94,3,123,61,234,143,137,153,241,174,229,28,227,222,172,205,139,226,22,218,250,247,201,61,158,22,61,146,86,172,43,252,181,129,148,242,163,170,26,242,237,206,253,107,80,235,13,207,44,154,161,237,216,68,206,234,252,196,129,144,42,73,90,162,3,23,138,129,249,128,108,39,165,144,96,175,65,181,229,123,222,157,220,176,8,48,103,205,188,202,77,83,157,254,209,217,11,68,86,201,169,183,214,142,28,75,164,8,157,177,109,184,8,94,129,32,54,44,197,220,157,143,25,23,61,56,68,118,228,80,196,22,208,19,67,91,57,71,11,85,47,44,90,80,224,163,213,30,91,184,104,70,17,44,89,56,63,42,195,196,71,155,25,195,103,19,87,174,37,134,150,35,83,175,86,141,52,186,245,38,30,130,84,43,184,142,158,208,30,195,175,184,77,182,145,13,231,156,232,168,32,124,177,89,102,115,33,111,155,119,182,59,29,230,74,54,241,118,26,42,19,142,21,218,131,53,56,149,78,240,188,180,64,149,198,192,232,41,185,146,74,102,216,45,79,28,170,181,200,103,67,83,9,199,26,55,42,108,208,252,57,20,120,117,94,237,166,62,37,224,97,64,146,100,63,163,94,67,154,62,164,104,58,16,97,49,129,167,120,142,145,77,188,54,189,7,28,47,60,59,170,205,174,49,205,132,49,101,214,126,206,186,95,86,156,112,253,111,110,237,2,83,226,116,106,66,105,182,127,93,40,210,236,252,70,209,183,27,11,73,1,250,43,254,205,179,143,171,1,30,217,165,165,166,203,117,254,224,127,161,53,3,98,53,120,42,243,4,213,20,7,236,217,49,207,24,253,216,36,38,222,119,39,229,227,23,69,39,170,224,225,77,209,233,37,208,189,33,31,223,158,100,234,179,136,89,27,79,145,86,219,249,124,239,197,89,249,104,212,197,70,107,169,200,87,107,70,82,142,41,23,19,159,126,147,17,6,129,38,250,20,97,214,36,12,30,27,231,209,96,146,5,187,161,249,210,221,87,221,12,167,189,124,209,224,44,61,139,249,233,249,132,181,48,219,46,78,158,249,61,229,12,204,35,64,37,131,180,167,37,53,183,39,237,166,178,240,108,209,18,176,178,182,151,132,215,193,176,43,40,240,32,250,123,44,222,6,54,35,224,173,22,91,7,224,45,29,234,231,13,9,105,145,44,153,237,149,169,82,226,203,121,184,246,243,172,7,22,7,251,81,16,34,42,35,111,67,138,86,32,112,157,34,218,31,243,129,242,253,123,126,206,228,134,97,194,205,210,113,36,185,89,225,192,140,195,208,154,80,154,60,193,71,213,93,148,69,180,54,253,96,118,95,179,42,64,45,3,105,216,209,95,41,199,205,106,129,144,166,160,234,48,230,30,161,158,170,131,178,151,104,124,191,125,187,97,85,31,122,74,24,136,166,113,228,188,213,193,189,204,255,122,171,184,202,146,92,205,238,249,89,70,77,147,230,132,64,141,135,77,75,161,111,182,203,87,251,111,249,87,2,0,126,197,133,192,128,141,125,49,105,204,199,137,176,114,29,48,150,163,42,235,189,88,21,7,1,188,1,216,84,195,236,161,162,240,101,229,188,235,125,95,78,62,213,60,185,121,128,109,248,213,19,60,116,0,118,102,155,223,233,192,123,63,26,44,3,219,215,164,121,13,32,154,250,82,80,141,3,62,221,40,203,252,246,168,198,60,168,163,243,53,149,4,240,42,179,104,229,61,138,203,67,237,171,125,249,1,48,234,87,210,193,65,173,248,8,245,125,221,209,73,169,160,121,24,250,10,242,115,140,99,77,66,229,187,76,153,136,219,56,69,97,178,148,66,155,199,222,120,253,213,75,239,10,140,83,29,60,77,228,201,212,64,81,190,35,110,145,202,65,38,146,41,250,201,151,134,96,0,157,94,74,99,117,25,237,53,206,46,120,124,232,8,28,136,68,24,202,236,46,236,80,208,145,82,118,94,103,132,157,210,223,223,122,119,83,134,7,84,98,245,253,78,0,3,132,42,97,5,115,133,7,41,83,222,207,25,66,134,83,61,141,243,111,71,197,192,210,231,227,104,132,122,204,105,51,186,223,203,22,170,230,127,180,228,170,17,62,136,128,177,31,208,28,23,162,113,10,23,30,12,223,27,197,125,162,99,18,45,50,126,12,62,250,181,210,187,34,166,96,204,230,143,208,109,137,251,61,126,65,106,226,250,151,225,116,207,86,81,130,176,140,50,9,36,94,69,179,206,148,40,194,44,114,27,201,42,174,24,142,245,110,155,225,178,109,45,76,112,119,160,164,76,78,114,118,66,113,236,182,65,145,141,42,121,117,205,119,16,244,147,179,104,185,135,59,21,191,105,123,110,151,141,47,218,194,62,89,126,2,255,79,54,177,120,208,242,75,147,236,195,213,138,230,83,109,10,162,179,35,9,34,252,203,105,171,38,113,13,198,253,101,21,85,9,207,2,71,55,224,83,177,112,220,14,10,142,225,29,112,70,234,222,230,217,216,171,137,54,217,137,48,170,98,150,96,63,223,155,163,47,179,247,121,48,152,109,48,160,183,222,233,251,173,133,210,112,203,35,249,244,153,231,62,205,236,43,140,245,235,59,34,34,251,138,32,207,226,30,229,44,236,184,169,93,6,206,197,222,166,72,83,130,41,228,52,166,60,117,110,38,54,178,144,45,53,94,120,206,252,5,27,242,188,109,79,221,57,69,167,167,189,139,98,212,55,121,195,157,127,115,55,235,135,108,119,137,162,183,144,212,96,103,80,32,87,11,198,44,245,223,248,233,147,184,170,104,115,202,42,19,215,119,223,109,194,243,22,7,54,91,219,142,56,15,132,169,49,107,16,64,67,126,58,145,46,49,184,119,82,125,56,247,26,45,138,205,139,112,79,191,180,253,104,238,75,28,63,110,171,204,161,37,216,136,229,197,205,57,98,170,167,212,230,144,235,173,255,191,49,7,144,212,253,163,7,176,234,171,149,97,123,223,65,76,142,174,126,83,112,134,163,125,95,144,231,169,168,103,85,170,242,165,29,247,74,239,91,88,101,174,97,255,64,247,182,75,175,174,18,1,196,150,85,13,104,147,212,241,140,230,16,10,116,35,59,51,87,205,172,166,0,230,75,101,53,215,19,24,87,192,24,70,227,193,0,117,71,226,154,132,208,81,170,110,25,91,1,147,162,93,71,113,108,86,123,154,10,125,165,236,216,221,11,150,213,105,68,229,235,147,130,104,11,245,74,115,149,38,221,0,20,81,21,66,110,121,213,92,200,69,214,119,41,73,251,162,90,74,93,70,145,160,47,162,80,99,32,122,52,74,220,103,194,227,244,173,60,174,194,132,246,167,183,172,216,207,217,188,41,127,168,191,197,6,237,160,33,87,157,33,122,12,204,188,183,76,213,90,121,238,54,47,204,37,228,155,57,193,21,57,78,22,182,98,52,221,164,45,118,210,26,65,60,2,236,141,62,66,30,182,163,94,146,162,238,177,3,237,170,125,134,142,177,38,215,168,42,41,203,75,151,37,202,42,245,43,207,241,185,234,148,3,138,232,160,140,158,252,194,228,142,221,255,89,251,131,149,186,64,119,200,165,251,163,138,22,187,180,171,113,25,12,234,105,46,83,230,112,246,158,158,134,203,83,87,241,154,181,174,124,132,233,152,68,229,126,135,115,152,254,91,72,115,94,78,22,144,61,245,106,253,217,63,37,32,189,120,118,66,71,182,169,169,13,35,30,233,223,68,192,10,166,252,131,57,29,143,126,210,40,231,176,214,91,142,138,44,90,233,80,143,191,30,204,158,194,136,133,196,88,112,58,147,9,141,160,88,3,161,47,29,1,128,242,116,9,186,56,141,165,50,60,120,202,165,121,142,26,186,231,176,220,209,15,138,57,145,199,101,206,131,41,158,245,133,6,108,56,33,91,227,4,151,85,141,12,87,86,48,4,154,12,35,99,38,169,13,61,178,163,12,16,35,109,248,23,140,35,117,90,60,162,183,88,184,60,123,20,138,80,232,6,152,198,96,37,164,118,172,204,36,213,133,52,86,237,132,149,230,224,203,68,235,107,170,138,66,251,230,88,191,59,229,89,18,224,229,132,237,46,255,28,234,216,206,86,113,81,11,161,58,211,206,219,103,75,68,15,3,89,13,64,133,72,71,87,250,221,47,72,53,72,9,43,158,56,191,102,180,14,103,66,72,16,217,39,80,19,243,226,159,21,192,222,68,15,241,91,22,45,89,97,157,36,216,138,151,31,225,68,177,137,98,123,120,45,233,108,231,95,113,109,118,59,41,1,208,56,187,6,66,29,155,223,39,9,114,63,92,45,174,221,85,2,116,248,210,49,121,149,89,45,12,56,243,175,205,43,153,185,155,245,15,150,10,45,34,34,214,22,52,38,247,84,106,34,218,39,63,147,195,170,210,168,121,8,182,82,40,12,194,172,176,76,211,161,21,24,15,94,76,27,145,78,9,54,213,136,28,234,221,215,184,206,231,191,149,24,250,209,80,96,183,161,10,246,24,216,246,203,172,179,249,146,202,188,21,42,185,44,173,154,87,169,8,1,104,30,56,97,120,216,118,92,36,105,110,144,41,218,94,85,62,211,131,157,38,110,44,123,34,36,68,40,40,206,23,98,53,63,62,49,101,177,16,32,166,195,34,230,70,160,178,70,166,138,68,209,120,216,157,85,249,99,253,245,251,147,37,11,8,36,234,96,243,102,74,244,88,2,123,22,25,72,239,109,92,45,194,226,185,86,105,245,44,105,152,247,249,43,12,169,80,72,193,146,240,59,127,168,98,68,172,153,116,153,115,133,204,219,252,8,51,104,217,137,248,87,190,9,27,189,219,31,107,55,42,109,28,48,53,18,151,60,1,190,8,54,102,92,20,111,3,88,165,132,38,8,245,103,194,170,92,195,46,46,203,71,205,13,50,39,87,154,175,28,5,253,112,27,249,152,97,194,50,253,139,232,74,19,137,45,248,184,61,29,30,13,90,119,246,112,237,30,2,57,91,190,246,156,228,174,89,121,151,224,150,102,42,161,122,11,221,53,141,159,32,33,167,254,225,229,165,142,45,144,187,166,245,106,198,81,158,204,244,119,72,217,203,24,22,184,50,50,92,2,235,186,148,91,167,26,221,157,182,73,102,167,189,46,205,154,5,135,114,86,56,62,137,187,157,168,123,210,190,195,17,215,81,208,57,220,170,160,174,10,32,17,63,206,213,8,120,208,191,130,56,88,94,245,51,198,88,193,83,101,214,191,221,132,97,5,82,228,90,212,26,88,70,135,246,246,113,209,207,128,111,144,244,72,171,65,205,160,78,138,224,227,72,197,94,190,46,81,139,1,66,60,184,34,72,173,28,18,240,153,181,6,71,143,30,88,166,249,181,185,119,233,157,251,89,252,190,55,113,148,2,182,75,15,122,77,88,38,84,71,81,48,83,67,187,232,84,234,211,214,94,111,26,118,212,219,217,96,73,97,34,238,230,96,159,69,93,131,104,127,10,231,29,68,82,188,223,238,80,70,228,98,125,140,2,234,80,29,248,82,229,142,7,160,172,81,235,174,221,95,50,61,201,86,219,177,136,96,36,169,255,222,116,242,83,230,52,11,2,160,246,253,226,98,35,216,240,167,10,200,37,145,62,203,13,248,107,238,201,90,144,61,22,43,130,86,138,72,57,138,176,237,15,88,169,242,102,122,117,139,71,39,127,228,216,240,62,168,199,231,49,189,251,46,54,233,100,239,146,88,121,94,29,182,254,130,37,79,78,253,54,89,78,113,0,15,241,223,9,66,64,63,199,160,195,46,48,231,194,173,240,166,240,102,106,26,69,222,106,9,185,190,111,128,235,97,193,50,100,189,62,49,98,201,156,0,184,9,178,172,117,251,80,204,213,7,196,193,38,250,130,57,173,201,196,160,128,188,27,104,172,248,250,66,167,161,217,210,168,182,208,84,158,154,78,125,78,188,143,188,200,127,215,45,230,189,50,10,200,208,50,129,63,180,123,200,190,113,0,157,10,33,171,7,226,232,4,169,13,225,180,36,24,182,95,85,82,81,63,120,228,66,68,21,112,230,42,100,23,148,82,203,10,47,200,206,98,72,146,33,12,22,210,210,11,184,78,213,30,68,118,56,245,195,200,108,232,174,4,101,118,32,69,130,75,181,122,52,57,142,224,242,245,108,15,62,0,144,156,207,254,84,146,24,92,214,161,128,113,179,243,207,159,60,167,115,140,65,152,207,0,110,109,172,26,82,140,233,24,22,91,165,167,95,136,140,56,1,94,89,14,187,15,178,64,78,170,129,129,249,243,203,44,211,11,118,152,193,16,160,219,40,33,205,145,252,225,174,151,3,46,239,35,123,65,85,215,15,82,159,225,252,143,20,157,225,157,130,159,151,250,228,175,236,186,0,184,249,219,11,222,238,16,0,224,48,26,74,129,232,14,28,155,154,31,110,189,73,217,147,248,44,26,47,37,11,211,185,110,163,82,34,56,52,149,190,236,246,103,176,98,210,92,27,17,80,105,39,114,229,61,230,0,140,120,57,86,93,158,103,213,160,116,160,251,34,197,220,20,139,150,165,255,98,132,109,204,44,197,92,87,137,195,131,129,21,208,145,4,87,151,228,77,9,253,4,232,45,87,242,155,155,142,140,114,14,228,159,39,60,134,56,3,203,128,225,66,206,232,72,88,5,255,73,148,194,90,48,228,182,217,129,119,59,191,14,174,220,45,36,207,135,2,228,0,237,213,122,33,199,205,1,134,214,3,204,119,186,123,191,116,143,224,128,103,87,111,120,61,39,25,37,154,36,240,190,199,204,136,119,215,186,197,255,51,189,123,148,233,156,94,62,94,7,238,7,13,131,113,99,95,44,37,15,48,110,81,134,73,18,158,237,151,214,33,76,207,192,169,62,40,134,135,82,221,234,175,232,101,197,17,215,79,163,247,166,52,251,28,199,45,50,160,191,18,254,192,243,0,32,116,164,122,70,250,200,60,61,28,162,197,87,4,108,20,140,1,102,34,80,239,69,31,169,254,118,64,9,246,114,17,146,78,66,232,179,79,86,222,134,118,180,99,210,96,128,253,139,130,195,174,1,2,228,174,126,33,167,72,151,38,64,79,149,108,6,167,16,73,13,42,211,221,217,227,21,136,144,44,75,173,148,116,156,164,24,19,21,177,233,45,195,56,32,12,68,50,117,0,218,161,195,16,121,222,236,167,167,254,195,134,75,162,48,222,3,81,212,26,175,61,244,8,55,162,214,161,87,181,213,155,219,168,62,205,113,137,79,236,221,44,18,240,105,222,110,13,33,27,184,213,8,168,72,114,100,52,89,13,214,214,175,68,215,219,133,88,8,196,102,157,153,154,133,105,6,7,130,77,10,148,43,28,58,74,152,31,84,139,236,62,113,89,208,116,97,83,201,191,176,237,211,98,122,46,165,109,2,190,145,16,140,47,252,38,6,80,44,128,178,163,125,148,36,171,31,16,211,10,3,168,60,165,51,225,41,59,179,67,205,53,240,182,169,192,83,129,47,52,183,98,40,100,195,138,52,69,128,73,124,107,130,137,16,4,155,103,98,206,78,141,74,166,74,137,21,208,80,203,228,65,180,91,128,16,160,204,206,234,180,216,186,142,181,126,50,14,164,115,84,29,176,89,150,201,242,188,9,54,161,44,177,82,38,100,244,64,48,133,253,184,36,97,145,131,16,183,50,171,194,39,149,24,72,173,5,240,163,214,51,120,194,44,250,213,31,4,9,106,195,57,215,211,58,210,21,144,111,1,62,212,223,108,180,121,45,6,97,120,119,22,229,47,177,146,114,190,219,125,164,67,237,93,151,178,235,196,14,247,98,107,140,152,104,226,145,242,31,74,134,5,124,230,167,70,149,226,210,92,124,19,183,245,114,19,124,206,168,255,4,243,205,0,236,13,166,215,225,44,166,69,231,219,84,245,207,160,50,189,74,112,212,149,3,246,161,69,156,131,197,29,18,220,90,84,183,221,3,102,225,122,236,202,207,68,231,152,38,117,171,43,116,157,194,75,32,10,78,219,130,159,240,132,42,16,167,57,114,194,64,141,217,8,34,10,116,220,36,143,101,88,120,166,198,118,161,37,15,51,120,203,136,67,200,236,136,154,23,25,202,184,198,96,155,148,75,165,242,3,210,223,197,63,82,137,250,143,226,56,156,38,89,130,223,129,119,8,230,59,217,8,230,204,213,128,252,200,216,89,115,104,38,97,12,60,124,181,49,188,44,66,141,154,129,139,61,232,41,91,202,201,37,143,98,252,33,185,245,180,20,42,173,20,139,227,170,101,252,19,126,14,128,36,95,12,252,131,197,71,47,2,214,167,51,145,239,173,196,81,154,71,210,41,152,78,5,247,213,215,198,126,105,185,41,6,32,193,35,243,243,113,17,248,217,65,101,59,181,172,222,110,241,185,86,77,79,213,127,142,8,105,36,74,50,78,222,46,72,214,171,94,232,223,51,231,119,51,91,54,126,26,136,192,190,252,91,251,162,162,23,8,26,153,68,218,167,72,163,214,80,136,250,35,204,140,26,155,230,12,142,4,208,38,225,27,165,16,127,81,68,165,171,147,21,44,196,77,122,203,121,144,39,32,97,221,188,222,100,46,174,255,102,195,137,165,163,160,66,98,40,165,16,251,12,208,182,244,246,165,62,50,5,176,77,145,212,159,81,26,0,230,12,150,3,132,5,240,135,251,223,134,198,255,73,14,6,33,142,190,126,79,26,57,25,208,51,199,6,230,71,132,173,62,134,214,31,215,69,75,31,7,164,39,139,157,178,63,27,7,74,39,67,130,232,42,233,60,100,57,101,129,159,149,229,166,128,228,74,185,230,73,88,161,148,160,114,65,117,231,102,194,39,117,128,105,157,45,86,225,192,112,194,27,103,22,170,92,229,65,184,172,242,3,12,93,107,94,131,253,173,165,79,26,211,17,191,85,12,224,77,30,82,27,49,106,30,250,125,225,251,241,191,214,160,138,186,80,21,80,115,139,166,32,187,215,133,13,169,133,110,198,100,22,217,86,30,115,163,73,207,212,24,114,238,51,146,96,204,61,66,112,174,243,170,121,44,35,164,123,18,54,200,10,159,164,63,113,119,47,132,28,154,192,166,114,222,87,227,225,31,166,96,126,201,86,63,255,25,98,180,81,4,90,13,56,236,181,76,166,9,186,185,54,249,99,151,15,205,125,191,48,194,75,13,165,189,168,116,230,165,26,53,3,242,82,143,134,86,97,241,201,67,170,222,202,81,201,121,252,129,50,144,3,79,149,118,86,45,45,199,250,92,147,206,83,100,23,41,254,65,4,41,244,135,3,0,72,50,127,198,126,159,64,27,76,105,105,192,175,84,231,181,111,190,208,6,126,235,173,78,155,200,81,147,13,87,186,69,81,108,166,147,122,64,16,163,242,32,34,166,129,221,161,113,22,151,58,68,17,14,231,14,115,142,41,147,37,13,107,112,0,203,255,95,182,20,54,28,190,67,8,193,234,206,201,213,46,144,56,223,40,230,3,159,191,138,254,85,185,255,125,34,174,14,60,131,121,142,97,29,189,236,241,210,209,126,202,57,140,9,206,62,151,68,219,63,210,227,181,153,99,152,197,109,75,77,182,33,193,146,145,9,67,121,13,248,231,123,20,241,194,141,149,171,44,130,20,221,67,19,200,85,165,247,1,107,86,12,86,170,0,107,187,157,250,216,239,143,209,98,3,18,89,157,214,126,139,101,189,11,186,119,244,133,120,158,227,232,233,84,192,101,121,8,168,138,195,199,186,74,163,17,53,221,16,206,185,237,139,199,187,47,53,133,64,24,221,138,193,66,149,215,141,134,213,158,76,222,6,78,89,121,17,225,188,7,102,238,64,163,129,67,162,53,79,40,195,177,142,43,86,78,156,202,80,46,152,123,44,97,73,12,190,127,132,163,233,15,86,111,89,202,144,171,82,182,224,107,84,210,94,19,9,181,50,217,103,181,141,116,178,230,109,166,177,66,206,69,50,252,86,100,177,0,65,40,61,204,211,235,27,229,85,63,71,81,197,124,14,237,120,145,62,254,174,57,110,31,4,180,63,123,198,64,20,116,155,198,166,101,49,78,35,106,90,253,12,41,210,68,180,251,54,79,79,239,112,93,102,136,78,46,107,156,104,66,74,184,241,58,221,166,222,177,65,174,36,205,168,232,90,73,18,53,62,29,148,226,29,171,88,75,61,119,95,160,75,71,72,167,241,15,191,166,182,20,230,199,166,110,230,148,17,16,107,34,201,154,139,170,59,150,110,135,153,165,163,179,15,27,109,210,216,157,39,75,146,113,50,46,212,210,143,192,1,115,68,208,74,178,84,74,7,74,71,107,195,38,107,45,2,46,142,253,112,92,171,20,17,48,100,5,102,159,224,26,6,37,198,9,150,102,222,106,225,226,40,5,215,30,132,254,136,183,191,54,133,98,31,233,81,22,245,148,153,69,24,107,88,190,113,16,57,112,94,253,118,127,135,210,193,140,1,203,113,48,252,103,38,108,100,102,191,251,138,50,106,48,5,51,140,246,11,135,41,246,4,184,139,47,3,151,160,242,146,131,255,4,63,86,77,255,152,172,162,222,239,154,31,24,131,147,80,34,34,156,183,177,92,108,59,44,160,228,74,182,111,103,59,221,18,241,246,51,246,164,118,12,132,91,71,33,36,138,117,32,253,243,245,24,228,200,79,31,31,246,166,164,74,107,35,253,38,151,73,160,47,159,43,110,240,115,41,104,94,192,54,115,172,132,192,102,9,109,208,28,244,1,62,196,159,31,255,92,245,192,98,5,158,55,233,81,129,7,248,138,131,11,227,15,152,193,131,189,129,40,148,225,144,176,34,175,3,137,55,232,145,156,12,170,94,175,68,91,178,177,176,157,105,181,167,91,55,69,39,181,70,174,228,21,43,154,47,32,147,110,243,16,14,254,86,91,163,145,255,34,234,7,238,32,132,154,16,35,190,247,173,128,128,51,108,147,45,159,116,63,218,95,245,145,21,239,191,60,102,16,44,10,47,207,75,95,233,139,0,8,29,178,153,102,181,18,147,160,223,61,131,146,129,141,62,42,160,138,50,133,143,204,34,248,138,110,5,203,191,135,32,218,166,174,171,226,149,224,69,251,162,17,95,238,132,217,153,202,131,219,147,225,175,69,93,42,196,10,58,205,131,68,89,96,89,214,188,247,130,247,223,152,236,234,250,144,227,232,178,85,135,71,46,36,201,225,44,193,49,224,208,90,202,65,103,97,8,65,184,27,5,0,63,193,13,138,185,179,152,95,71,181,248,46,0,36,140,150,35,207,155,231,12,132,41,233,32,43,62,54,54,216,44,194,45,204,231,205,48,171,41,181,7,133,192,39,55,229,243,239,111,159,196,50,75,148,37,246,2,144,77,113,213,233,149,75,229,9,165,161,198,222,76,3,37,232,165,69,148,53,111,29,124,246,248,238,86,147,165,8,231,24,6,91,7,96,191,130,92,132,104,132,49,160,199,131,95,164,21,221,112,38,206,172,90,123,225,19,50,204,142,211,21,61,139,34,241,199,94,184,146,177,31,189,77,231,160,21,251,133,18,33,240,53,253,12,72,19,230,208,101,66,81,33,7,67,231,160,24,220,226,60,126,23,229,131,207,97,223,42,121,53,158,145,12,97,136,69,101,98,140,130,7,203,69,188,42,0,48,77,239,91,208,70,25,177,43,86,127,46,112,32,176,157,39,73,243,215,44,195,155,219,193,104,186,131,52,252,101,159,175,237,191,22,80,100,96,121,139,163,66,235,102,118,47,87,60,112,56,207,211,236,91,159,137,157,30,136,219,8,166,174,52,182,7,89,137,129,21,165,87,184,124,17,239,58,119,194,254,224,13,171,10,126,130,59,84,220,152,243,30,129,110,51,152,142,125,132,27,177,77,84,184,23,238,34,195,66,198,167,208,95,173,150,14,125,0,71,21,83,36,201,27,17,190,177,135,171,192,152,139,108,132,182,191,173,94,109,51,100,189,84,131,138,159,109,151,5,83,80,146,81,52,90,229,205,172,104,69,39,245,18,117,198,248,82,190,209,209,206,39,245,223,217,139,160,163,88,232,72,144,50,76,200,187,137,123,96,128,48,15,75,91,232,83,109,107,80,13,11,61,201,82,251,124,241,30,170,251,238,199,220,71,143,83,166,131,115,25,101,132,201,69,169,207,122,101,82,76,216,192,211,193,233,217,28,31,216,93,119,243,255,82,55,106,28,167,14,41,246,116,51,74,164,91,248,159,67,85,161,182,66,171,249,124,78,144,54,38,36,173,81,223,168,167,35,69,32,149,18,41,162,223,23,66,254,188,48,122,21,208,58,176,124,108,51,240,106,203,16,182,43,157,122,193,194,61,58,46,69,178,107,96,119,104,226,52,1,182,210,46,193,13,186,238,95,135,135,51,247,132,116,104,178,76,142,242,156,232,168,249,71,18,145,116,142,119,78,254,177,36,44,119,202,101,188,143,193,89,214,206,121,140,184,108,198,32,35,91,212,48,240,183,71,165,86,197,18,217,130,98,124,241,80,184,144,144,213,91,7,74,9,154,23,130,180,81,145,179,115,45,153,172,65,155,154,43,245,29,221,170,99,243,113,196,232,196,19,114,72,90,84,153,155,198,175,85,62,16,226,71,4,253,59,147,1,18,35,12,215,254,107,237,54,12,59,209,7,159,219,40,194,55,46,222,239,62,211,47,241,131,128,119,69,138,198,195,222,130,151,32,200,129,130,40,117,126,33,227,242,33,138,64,200,111,45,56,150,66,172,47,27,142,142,181,27,197,197,8,29,166,130,8,1,223,33,106,177,195,133,29,141,45,66,174,97,47,184,171,22,251,243,132,179,46,247,163,199,90,203,146,145,130,14,5,250,175,181,142,184,37,32,6,79,175,157,117,111,250,254,22,78,220,150,239,139,112,207,12,162,249,173,93,120,43,54,254,171,207,185,229,103,147,131,118,27,1,110,138,148,185,193,122,56,78,51,2,33,174,202,45,24,179,237,230,58,228,220,220,111,47,10,61,186,107,230,89,160,22,157,11,206,224,252,57,254,206,193,143,63,171,63,227,87,189,82,194,248,188,16,61,161,101,153,140,22,46,248,211,151,251,63,5,172,34,30,222,231,224,23,222,155,26,113,7,229,253,8,66,150,203,108,18,120,27,15,99,150,210,237,46,161,8,195,94,241,5,26,46,49,57,72,128,88,68,66,75,57,226,213,240,117,102,71,118,161,208,77,213,127,51,42,42,169,77,88,204,158,53,12,65,236,191,94,117,28,142,177,51,46,24,213,117,47,62,98,159,165,44,84,238,160,15,37,146,107,82,98,172,139,43,148,19,89,160,102,192,124,96,238,108,232,19,34,48,134,149,32,237,39,149,103,129,21,177,198,2,123,232,228,157,53,93,11,0,255,69,204,216,166,167,47,201,83,134,48,234,183,168,1,24,1,101,52,213,80,233,21,193,65,188,156,103,193,181,118,48,24,201,38,228,91,2,189,195,188,214,42,196,81,253,83,204,147,205,106,233,90,67,194,4,102,55,210,58,4,6,104,229,209,62,155,242,92,47,110,239,206,178,195,155,167,48,59,50,197,1,202,103,151,152,58,203,201,109,200,80,125,140,40,209,72,113,210,91,90,213,150,202,9,199,87,190,104,160,113,213,97,205,25,171,80,188,151,87,125,143,194,114,251,188,165,66,99,253,192,112,127,51,232,17,173,158,158,76,99,69,226,130,64,138,152,194,197,41,11,214,66,96,252,124,136,241,173,192,87,13,33,180,89,92,36,85,4,30,23,61,106,207,106,19,206,148,214,4,124,252,75,198,213,212,74,230,16,32,235,54,57,72,95,202,21,231,71,20,127,74,183,161,32,10,28,189,106,119,94,64,20,13,113,129,126,255,46,113,9,245,255,246,185,102,205,239,40,254,122,254,102,155,132,189,116,8,15,127,123,76,91,116,96,206,1,143,191,165,89,194,125,179,199,104,181,109,59,8,211,100,123,247,207,218,136,152,27,123,218,159,163,184,175,149,100,101,75,63,255,2,144,108,145,102,105,86,47,37,23,105,164,126,41,160,219,214,28,246,20,232,66,107,231,106,83,230,242,169,146,245,240,45,94,160,121,22,193,71,187,240,6,175,153,19,222,40,25,240,111,180,80,12,192,235,153,7,225,177,112,244,201,230,112,12,137,6,142,86,178,191,188,247,242,204,125,237,88,193,78,137,121,14,89,64,89,231,168,118,199,91,128,167,189,97,162,46,148,7,58,144,184,33,130,95,253,162,111,114,114,33,77,54,151,176,163,53,111,60,148,61,57,95,195,172,49,137,215,237,218,42,38,73,92,20,252,98,205,53,23,77,151,249,38,115,31,99,63,84,140,162,235,77,244,196,114,134,216,75,145,137,248,18,98,219,190,36,62,181,210,195,121,30,90,24,26,226,251,20,72,161,207,68,205,41,23,195,91,115,139,184,167,60,197,223,107,144,45,78,100,157,207,89,162,119,210,115,53,31,35,114,170,144,139,211,37,45,128,217,131,80,105,102,200,138,68,91,38,169,174,168,238,204,244,23,63,242,70,110,232,46,244,69,143,128,245,51,41,69,170,250,167,183,128,150,77,82,181,77,176,192,131,137,163,194,123,103,214,56,84,213,235,3,236,48,11,255,69,235,13,245,46,195,160,150,67,211,216,253,150,10,142,240,80,222,36,248,240,138,174,41,6,73,205,116,25,135,20,101,168,123,96,246,151,140,156,123,92,21,187,244,249,86,67,224,160,10,162,185,196,160,52,96,255,243,106,147,218,7,251,97,136,124,42,65,245,149,129,86,159,62,223,73,168,166,204,70,184,240,235,189,218,121,188,241,155,235,249,5,193,86,182,181,155,42,215,218,233,184,194,47,52,179,49,41,40,160,188,207,50,190,24,2,237,120,134,17,196,126,225,39,56,137,85,220,47,47,77,32,94,183,64,197,132,180,0,25,195,175,244,236,68,185,225,35,238,201,35,106,134,63,215,252,128,243,99,57,15,93,174,134,160,220,237,104,96,195,62,62,154,160,213,53,49,207,214,238,120,109,180,83,155,187,198,36,161,92,3,71,135,99,52,80,246,86,178,193,80,53,105,91,68,9,236,143,189,3,219,192,241,79,187,90,154,166,59,227,238,85,149,20,241,40,212,26,49,189,54,20,55,47,92,194,181,200,19,33,202,12,102,23,103,166,123,45,89,22,125,161,33,26,250,187,223,110,54,21,83,9,197,175,120,246,219,79,108,39,211,172,83,72,169,191,138,242,1,163,120,137,164,139,61,7,0,160,110,208,68,157,19,39,128,181,112,201,164,101,48,60,208,67,50,115,130,134,202,178,41,236,209,72,191,154,78,198,202,36,9,164,180,73,133,77,103,56,234,26,40,124,156,224,142,37,71,90,38,91,140,145,79,196,70,201,65,17,141,175,93,106,76,45,32,42,199,65,205,190,174,41,4,109,203,83,199,23,18,79,10,37,130,184,59,33,84,197,79,239,121,99,164,39,65,165,75,52,115,27,229,7,33,245,212,187,99,215,226,252,5,217,246,94,132,65,197,40,113,126,168,126,145,160,221,215,157,21,135,57,67,171,41,59,158,61,76,163,193,220,79,136,149,155,158,252,170,32,191,170,10,28,209,238,106,22,206,5,51,42,75,201,97,35,205,70,6,214,128,133,89,235,215,73,212,195,136,167,186,163,207,65,238,193,101,89,9,135,178,28,159,252,42,236,253,89,193,99,161,24,34,119,235,13,251,253,27,75,212,228,181,239,58,245,115,126,174,107,58,235,24,216,56,35,97,215,75,120,27,247,66,239,233,194,234,200,101,241,176,128,21,130,129,246,115,17,99,214,201,191,223,173,71,115,92,240,206,58,77,246,252,212,233,203,43,166,202,85,69,52,148,38,246,205,196,223,160,211,193,210,35,214,4,192,252,216,225,240,51,223,174,94,236,254,163,234,237,58,147,89,117,12,160,207,9,252,102,29,42,27,173,231,147,70,176,31,103,99,236,249,67,136,13,238,205,105,81,21,64,197,206,129,16,171,244,106,238,217,212,133,58,250,98,137,192,214,21,191,184,231,169,244,193,226,149,75,70,254,8,5,41,236,216,134,15,140,191,4,165,149,237,128,40,28,8,150,79,128,50,179,227,4,197,153,107,115,202,144,224,88,141,221,108,148,199,211,57,101,180,226,162,171,209,190,194,99,149,238,182,111,142,137,96,139,238,157,139,155,199,111,80,108,231,130,157,5,80,55,212,200,47,114,160,217,201,155,52,100,35,205,112,225,46,32,200,109,209,88,167,27,179,171,113,42,139,135,94,174,136,169,10,205,44,147,180,244,18,166,65,217,121,104,164,159,222,148,87,88,81,11,81,250,187,210,177,224,72,117,228,57,146,167,92,34,84,115,12,117,82,98,94,228,169,178,11,241,36,45,226,47,10,181,103,66,29,54,142,30,203,250,145,143,41,204,156,81,89,124,192,216,229,199,83,45,83,104,190,202,238,32,15,228,203,232,88,113,65,21,29,215,198,15,95,61,131,28,146,123,198,34,222,187,22,36,89,226,44,67,212,104,230,127,6,124,125,43,111,107,136,244,13,49,126,125,107,209,189,207,23,63,94,17,100,180,255,62,212,58,98,19,64,95,52,77,149,238,221,54,88,144,61,235,108,155,42,37,95,85,243,92,144,24,19,177,109,174,252,160,42,25,101,42,255,244,121,136,47,24,76,10,22,226,178,211,101,135,57,249,119,49,8,234,122,54,127,5,60,41,216,100,1,232,92,78,242,83,182,221,165,65,152,117,27,70,77,214,91,207,98,14,121,89,126,233,131,224,80,174,205,97,188,239,60,184,25,28,221,208,15,50,58,166,14,217,218,224,166,205,49,231,224,219,236,191,250,87,132,209,149,216,45,99,59,78,200,244,238,145,176,237,56,208,141,180,68,239,126,244,95,226,0,207,240,198,109,85,139,82,154,108,253,96,40,103,235,29,181,37,60,77,255,74,122,165,26,18,176,195,179,69,51,86,152,208,106,176,78,39,22,177,141,117,39,174,202,212,142,130,159,235,218,97,115,56,243,157,57,69,254,95,67,47,59,12,49,64,140,172,112,185,117,49,223,78,147,231,229,142,21,159,151,146,158,124,223,209,103,128,212,137,53,47,145,228,38,183,223,233,54,221,101,52,210,178,128,69,54,68,103,80,148,75,145,76,16,148,167,125,93,172,74,198,189,129,163,112,233,178,217,39,131,166,239,35,21,131,76,87,41,154,79,62,7,239,72,129,10,197,128,36,182,215,25,118,146,62,240,232,104,146,237,20,148,86,132,234,33,131,220,0,100,53,119,78,27,122,142,61,153,13,153,59,138,121,20,137,86,169,127,161,188,188,95,172,90,34,21,164,244,17,218,252,159,79,161,238,224,128,236,59,58,114,203,231,91,167,226,116,59,170,252,243,245,205,180,27,192,113,241,31,117,229,177,216,104,241,229,130,247,184,79,210,206,108,255,25,55,153,54,44,15,16,48,173,118,152,20,255,26,36,150,131,96,196,22,137,193,251,242,226,127,96,240,162,93,245,19,250,102,116,202,186,139,196,136,52,12,154,71,226,56,137,86,115,19,100,112,2,39,211,213,204,147,33,229,235,226,50,209,169,159,50,219,187,35,57,52,36,129,222,233,49,77,131,47,41,16,113,154,15,115,125,121,85,228,226,72,52,4,112,90,189,217,75,237,45,27,144,81,168,231,218,39,177,119,66,173,39,145,248,33,230,75,125,136,175,151,174,8,151,138,73,109,182,88,81,191,4,112,3,153,176,229,206,177,242,84,222,194,37,141,222,223,139,113,208,249,155,120,124,223,237,225,136,14,97,127,184,233,68,108,124,129,247,59,179,28,83,117,63,124,79,241,213,159,157,158,161,127,40,160,38,143,8,12,150,197,34,60,248,146,230,9,159,232,70,120,209,136,214,149,190,18,55,248,169,46,73,32,216,190,102,186,148,219,252,89,67,244,18,176,211,221,82,103,1,41,194,83,139,135,209,121,132,150,92,158,228,21,209,45,34,214,85,20,48,229,210,31,61,194,47,96,65,151,99,80,126,145,40,215,66,195,221,165,54,253,215,223,228,127,188,182,238,42,134,238,249,69,57,96,129,167,79,72,249,51,124,97,134,154,60,204,230,243,150,164,37,176,179,10,209,229,98,145,47,238,181,58,93,115,130,145,1,146,230,198,216,210,127,85,222,93,122,181,33,50,243,68,217,4,166,166,121,114,31,252,17,106,137,107,148,109,221,231,88,228,46,128,184,201,244,242,8,77,181,61,173,21,110,97,10,236,216,58,181,54,185,243,249,251,198,236,115,167,100,227,111,31,129,194,72,7,90,105,181,239,182,213,13,90,90,163,177,212,149,156,118,84,175,195,161,10,180,97,209,214,156,160,230,248,181,34,92,74,249,97,79,210,253,146,192,11,105,130,116,203,52,40,142,212,108,31,105,40,125,35,0,103,120,233,167,145,111,34,47,127,155,225,139,143,54,42,13,98,13,149,8,97,58,66,133,0,118,61,36,208,8,206,48,103,94,55,39,248,78,37,151,1,77,148,118,251,217,20,148,36,76,249,67,179,5,126,181,37,153,208,142,184,6,25,107,9,110,220,132,230,128,81,97,216,89,210,21,89,76,82,103,250,188,81,110,13,145,128,221,140,171,177,65,82,102,93,105,113,2,221,35,11,238,238,183,164,115,31,89,2,151,35,201,55,185,10,41,38,188,48,208,102,193,1,222,221,121,243,253,132,77,95,28,100,197,165,4,118,241,92,118,234,223,87,56,108,196,197,26,83,102,124,50,145,204,13,47,31,183,91,35,25,192,42,240,221,226,90,141,181,89,180,74,196,165,58,221,1,205,182,170,120,80,163,72,28,135,215,78,225,199,149,254,9,44,216,176,232,201,240,79,60,48,199,213,233,245,104,103,144,253,199,151,227,228,120,96,156,239,100,223,155,81,97,84,64,63,105,67,98,60,147,80,112,28,56,84,97,63,16,10,223,19,105,209,29,21,179,234,199,187,104,90,241,134,129,118,58,180,219,78,50,45,59,240,94,228,108,118,124,16,190,221,140,85,150,113,14,190,39,235,25,187,54,211,138,110,36,151,178,216,50,135,201,233,18,92,183,62,189,155,24,23,119,250,41,162,216,203,190,8,231,184,162,100,27,196,121,17,48,225,223,98,251,195,67,232,37,197,12,122,246,184,42,233,85,203,212,104,41,254,246,224,76,225,128,218,244,120,233,70,102,87,173,25,15,165,67,75,254,8,156,234,55,164,48,172,15,223,162,147,104,113,52,120,154,195,82,49,39,50,225,199,112,176,56,60,196,139,208,100,151,135,50,43,48,172,182,33,114,163,144,108,170,173,232,197,141,41,241,40,143,22,157,207,238,0,31,61,55,244,100,6,109,39,209,150,185,236,218,47,63,5,211,140,212,121,167,236,132,170,232,36,128,152,102,219,220,180,200,205,137,226,211,168,213,180,124,4,203,196,170,190,244,61,229,25,45,147,5,187,103,81,50,56,149,149,95,31,136,159,110,115,37,153,112,200,126,144,120,118,213,53,53,196,2,196,46,1,246,134,30,204,102,237,163,251,89,161,116,163,36,180,17,162,102,43,153,47,174,247,239,206,213,169,185,140,196,98,162,47,221,190,249,218,112,112,103,75,27,166,83,209,251,90,119,92,22,50,205,65,159,11,226,50,23,225,77,73,58,1,222,60,193,119,168,107,47,187,1,32,15,217,123,143,107,166,46,31,116,191,124,35,145,139,245,191,12,68,230,60,163,150,203,77,210,29,32,75,54,105,210,86,55,173,61,153,160,223,132,167,134,226,154,123,135,214,106,84,85,170,187,143,167,188,65,186,89,135,117,45,25,69,114,64,228,6,181,219,151,152,60,254,111,242,250,54,154,160,230,113,76,75,24,4,9,198,76,244,84,33,57,30,233,147,171,141,57,76,109,77,1,133,252,162,197,124,235,195,124,76,59,207,64,129,27,143,121,95,14,188,38,94,232,203,212,119,185,178,135,154,161,57,165,44,224,97,98,74,54,199,95,233,145,230,244,74,245,152,182,228,162,6,227,13,14,152,249,247,169,255,91,12,130,131,116,192,161,246,121,126,230,228,28,154,228,146,127,202,32,122,172,84,42,183,214,148,173,66,188,231,151,158,88,192,143,241,206,95,15,3,143,117,238,197,231,240,137,41,3,189,126,33,34,199,131,77,15,66,231,78,246,239,129,103,231,77,218,89,46,129,139,12,254,135,13,195,61,183,149,210,162,98,37,9,83,206,26,65,102,177,152,95,108,54,249,124,44,199,102,75,111,16,241,95,30,222,177,158,66,115,192,90,42,76,242,80,104,127,47,252,168,68,53,29,184,151,147,117,225,167,67,231,205,181,105,219,105,215,82,182,154,217,52,48,227,155,126,180,43,102,46,240,242,142,112,191,112,86,62,126,234,108,232,204,125,151,249,112,205,60,95,125,14,35,11,225,87,79,213,174,192,255,163,27,59,217,97,158,64,170,113,150,8,156,7,244,42,67,252,7,241,64,252,149,45,191,123,79,229,230,16,62,78,61,107,123,225,132,16,15,22,190,1,177,114,121,231,170,218,93,52,123,42,123,184,101,244,146,188,26,219,157,192,159,17,105,1,112,172,10,145,47,136,46,87,108,212,211,90,102,56,194,248,35,21,228,208,219,168,9,83,143,82,194,24,220,42,10,13,162,199,199,59,252,211,218,55,230,43,155,176,118,205,42,170,110,63,126,59,51,66,8,187,115,125,144,94,60,221,230,213,100,100,25,207,237,107,229,191,160,105,206,214,170,36,26,106,181,115,60,142,241,55,240,125,94,125,112,217,13,186,251,90,75,181,214,200,12,21,58,109,126,52,231,154,185,218,115,34,34,86,128,148,135,58,120,243,121,211,174,183,71,52,103,115,115,248,55,247,73,47,98,193,113,223,102,0,186,144,139,168,179,193,204,0,154,85,236,147,72,138,168,11,201,107,235,37,50,190,190,95,168,59,58,167,212,26,162,189,137,169,195,131,58,91,234,148,120,145,83,64,244,104,169,130,15,195,67,126,58,198,50,152,166,14,177,160,220,205,221,192,177,51,228,119,161,69,1,2,171,92,207,167,139,232,68,253,175,43,205,34,17,241,105,248,176,31,84,189,185,43,38,98,190,156,25,208,54,215,38,238,188,107,220,68,49,128,248,236,189,247,225,90,60,173,180,73,158,125,78,155,68,85,186,97,189,76,80,102,27,3,7,144,242,158,94,81,70,40,143,161,101,168,24,233,149,88,175,190,9,68,241,9,190,77,101,29,153,161,241,43,114,202,30,130,66,171,50,168,120,236,126,72,32,32,58,141,184,226,133,65,157,121,60,61,126,211,202,144,72,142,34,20,212,9,129,242,221,189,37,5,254,244,159,32,174,47,234,27,169,235,212,170,17,16,156,176,249,241,249,97,203,202,219,186,92,199,26,132,248,209,241,26,136,129,245,221,5,137,159,236,85,244,133,44,185,157,84,156,125,38,201,75,28,108,215,129,109,51,79,204,161,78,103,114,92,202,122,65,42,245,214,139,118,105,156,205,39,123,243,93,30,104,151,10,11,187,239,91,117,194,245,27,26,227,180,91,53,86,252,216,39,51,59,216,219,90,92,161,43,111,125,29,248,145,95,198,18,132,53,13,232,150,236,205,216,55,176,151,91,196,35,109,236,54,168,168,252,95,152,211,218,165,139,228,142,164,220,201,3,21,171,185,215,142,175,118,171,118,78,186,121,135,222,74,26,230,92,23,3,231,71,255,156,202,211,77,161,183,177,161,213,136,184,122,124,142,253,213,52,127,16,136,151,171,160,214,110,124,197,209,110,142,16,75,13,240,206,255,254,196,164,94,31,232,122,174,242,153,175,81,117,160,88,164,27,229,59,158,39,13,99,40,78,47,108,106,180,237,162,97,46,44,19,204,155,2,104,110,231,39,163,40,146,84,50,149,163,195,254,167,131,180,44,26,59,0,219,110,9,171,8,1,206,132,214,79,4,226,129,20,17,195,200,91,159,177,20,60,71,169,14,95,41,11,181,2,212,121,189,64,135,113,192,178,183,140,167,210,38,134,73,220,176,152,169,248,56,74,6,107,161,153,29,226,85,168,117,219,244,98,108,134,148,83,249,99,226,119,30,175,1,147,98,226,1,109,55,251,249,151,153,228,235,182,81,249,182,97,37,238,113,45,220,150,75,13,180,252,154,32,180,174,202,16,47,149,177,170,52,197,86,23,30,143,38,57,129,66,189,250,237,209,21,103,206,180,180,190,204,222,112,238,93,216,135,191,5,151,255,238,49,76,15,21,181,139,42,127,86,64,7,138,186,164,88,83,60,202,103,255,242,208,173,36,121,4,145,242,119,187,228,57,117,195,137,204,175,100,39,118,71,126,234,0,168,189,29,129,37,122,91,173,219,138,190,241,160,217,238,33,185,212,133,13,197,186,60,30,126,168,88,76,166,208,53,119,116,139,245,117,184,57,111,234,201,66,254,221,67,204,188,67,188,98,44,249,197,4,36,254,145,116,52,24,158,116,37,154,219,56,29,185,158,46,31,94,18,67,164,245,220,44,6,98,194,17,121,23,175,190,230,220,16,99,85,139,218,119,185,69,109,18,146,219,201,122,66,189,177,158,142,207,198,76,169,169,163,91,237,248,226,0,226,84,108,26,95,230,211,113,217,241,244,175,213,203,202,123,159,250,241,145,222,144,50,180,194,0,38,131,189,5,40,83,207,16,15,137,184,147,38,186,16,240,207,188,123,143,6,167,190,185,142,120,118,190,31,162,153,95,84,215,112,129,110,147,113,20,67,223,123,166,238,236,243,69,98,214,120,61,100,122,223,69,186,236,182,53,108,160,114,87,186,179,122,241,247,244,111,90,103,42,116,217,81,235,144,248,142,157,63,28,33,123,32,50,50,11,174,93,214,25,149,175,69,232,118,49,229,76,4,54,74,199,112,12,228,244,8,66,17,55,48,24,156,84,202,147,197,2,227,4,159,60,123,92,129,63,235,12,136,179,140,205,15,88,90,79,65,26,254,78,250,229,162,247,167,33,189,42,234,159,68,245,206,75,162,49,250,65,3,104,231,254,191,228,209,6,13,222,48,243,6,170,1,3,109,60,64,221,153,167,252,113,88,56,184,97,188,184,123,174,166,8,175,34,153,248,80,184,74,221,114,217,79,67,104,246,123,98,200,68,69,82,68,126,255,225,108,51,72,24,249,159,240,193,89,93,116,152,218,134,181,87,107,66,125,18,190,106,49,219,245,9,193,3,103,113,65,127,220,232,166,145,77,116,63,228,157,90,14,66,36,128,52,122,54,23,220,165,171,139,145,172,61,177,85,187,198,113,97,77,94,105,219,61,240,179,3,75,163,77,248,101,4,211,219,140,243,17,22,223,240,77,242,207,38,6,106,208,88,159,171,50,3,122,176,249,38,217,106,59,254,115,89,95,76,122,240,16,150,112,57,120,113,101,79,6,181,116,44,109,124,74,253,138,169,102,203,230,194,80,22,48,134,118,119,157,255,235,71,3,134,134,105,207,197,132,203,77,122,134,176,0,236,128,207,97,102,144,124,65,194,209,170,108,64,131,46,189,57,78,250,79,38,95,146,18,39,167,217,236,16,249,44,138,79,73,153,101,177,230,148,222,231,215,157,247,191,219,159,84,51,51,98,89,73,44,31,107,201,205,180,8,112,214,11,156,255,212,189,47,55,236,217,234,251,250,136,213,12,103,10,0,221,236,58,125,32,121,101,189,204,134,53,245,158,54,235,14,177,227,191,194,202,43,21,234,193,165,38,113,203,1,54,238,71,115,128,228,76,91,27,49,148,114,252,148,76,236,15,248,36,243,240,164,17,224,248,11,218,92,19,80,152,47,226,219,130,77,68,217,123,187,8,253,84,228,41,44,143,202,31,33,105,242,51,142,127,67,46,236,94,232,172,139,192,155,81,34,239,61,75,192,23,119,94,84,169,75,228,71,211,215,240,74,188,115,188,95,245,54,173,49,147,195,80,69,19,52,154,212,168,155,229,128,242,236,143,195,95,142,222,244,190,71,53,215,128,147,231,117,145,70,55,61,22,187,82,115,114,107,135,38,50,132,148,128,186,209,101,28,228,50,206,35,111,41,153,234,143,15,7,229,177,94,187,251,197,189,249,43,34,70,112,203,239,176,30,22,140,53,159,18,105,31,122,229,64,13,163,254,180,69,123,17,225,49,36,159,43,173,67,157,253,227,44,19,233,235,7,45,247,43,136,209,77,179,52,43,255,18,226,150,156,27,48,31,231,188,241,166,185,16,22,226,147,69,32,64,64,212,202,98,47,88,246,220,98,214,79,251,153,225,101,6,132,4,156,211,150,204,216,162,161,1,177,91,1,55,59,175,144,2,164,70,193,187,72,123,52,103,251,214,203,252,42,77,234,88,228,38,107,151,236,209,146,18,178,108,89,35,227,187,171,2,188,227,107,123,131,212,139,228,63,85,88,2,132,177,221,248,149,153,84,59,95,4,43,222,37,65,134,218,152,142,11,34,90,125,198,231,138,56,1,8,45,250,44,26,184,215,30,153,128,56,202,192,88,180,3,189,233,226,105,93,2,188,209,64,60,140,209,224,24,152,199,111,42,158,221,202,86,181,213,199,129,151,100,219,213,125,181,92,211,2,102,83,136,35,180,238,225,11,3,245,129,85,84,4,225,120,176,204,26,144,213,26,238,196,34,73,45,237,149,217,159,29,73,13,193,166,241,130,202,94,179,194,52,21,221,141,102,112,116,117,66,29,61,114,2,208,225,50,187,233,187,111,193,62,205,44,133,239,181,36,220,126,197,182,42,242,185,21,202,162,44,46,51,214,214,29,197,143,234,35,26,55,174,151,127,202,232,101,19,157,225,26,147,154,255,26,13,81,128,153,18,197,180,28,231,120,4,93,80,209,73,28,16,8,169,42,206,202,169,123,229,4,40,244,49,125,226,45,222,65,106,33,52,46,120,98,22,66,40,73,215,11,34,167,133,52,138,210,8,182,23,191,212,252,134,45,69,162,67,52,1,34,217,156,119,154,212,82,188,226,62,231,157,144,174,79,152,227,118,218,107,151,199,142,8,126,38,156,126,156,211,249,0,243,52,160,218,207,56,120,206,124,142,240,152,200,108,140,219,96,105,207,19,180,98,191,37,102,2,203,80,212,47,77,155,144,188,144,201,204,115,2,236,97,83,222,109,79,52,168,236,24,214,215,107,57,242,163,208,53,35,37,122,33,64,168,194,194,42,64,189,42,52,124,134,80,168,34,90,25,139,61,183,85,11,105,74,2,226,182,194,56,213,58,135,11,35,28,104,223,236,182,110,253,105,81,122,204,53,173,219,46,202,229,130,49,194,245,6,246,97,94,241,143,194,60,76,125,164,220,137,122,163,115,96,58,241,130,247,21,103,254,19,57,223,104,159,29,17,197,1,84,188,79,184,235,125,207,139,7,212,68,142,200,172,29,232,13,194,156,131,88,26,70,245,213,126,79,184,20,246,235,232,206,19,192,4,39,197,39,41,179,208,197,9,98,201,60,191,226,188,177,207,238,112,184,226,204,52,145,200,65,66,160,68,94,153,120,197,81,200,172,233,102,174,251,52,36,164,98,162,185,156,146,165,29,153,108,191,82,217,74,120,89,158,64,255,70,114,242,246,46,11,241,180,214,203,33,97,116,253,112,187,79,222,244,26,90,251,107,175,228,97,142,233,40,220,103,121,185,82,22,84,253,82,232,228,24,193,179,46,117,97,108,100,10,205,136,205,120,218,96,181,140,195,66,139,117,5,222,78,148,35,200,120,253,254,201,181,45,59,25,43,199,186,58,250,48,80,16,121,7,148,41,196,112,174,227,189,143,12,13,81,77,32,73,78,17,51,125,72,52,35,102,239,184,86,119,140,107,10,140,171,61,65,123,60,98,204,244,145,186,198,195,154,221,12,252,76,22,238,243,238,252,138,193,134,142,243,216,230,65,221,204,193,16,218,195,143,246,116,227,200,67,219,99,141,178,39,47,47,176,103,112,145,116,96,46,3,177,124,1,31,230,244,124,225,148,106,140,122,102,135,131,50,252,68,156,178,228,167,40,32,243,221,44,122,89,172,224,50,142,132,72,32,177,148,254,5,229,24,237,62,190,27,19,185,244,210,174,10,70,33,52,138,92,210,136,166,216,113,154,139,230,66,206,169,240,19,238,246,229,205,12,254,86,190,204,59,237,239,17,245,199,53,105,89,90,175,56,225,203,208,144,56,82,173,20,127,68,118,125,197,88,200,157,5,107,250,213,133,13,141,164,170,79,173,32,250,25,143,136,41,97,245,203,25,96,198,83,241,151,168,167,49,101,0,143,101,89,114,46,72,147,212,112,220,65,62,105,44,205,70,185,18,84,29,246,164,31,229,21,14,67,26,197,37,163,220,14,216,251,210,60,65,165,151,53,103,41,255,175,129,206,186,85,141,161,133,28,49,46,131,70,188,230,254,17,100,240,77,22,62,175,241,238,66,33,86,125,74,29,113,134,94,204,64,129,2,114,148,122,62,206,170,236,186,77,89,49,222,231,134,253,84,176,79,38,211,72,156,212,208,168,100,13,46,198,4,90,249,23,177,15,25,211,229,184,107,161,255,75,34,162,43,203,170,67,161,39,162,105,166,15,55,64,247,196,84,96,108,61,111,3,151,253,63,248,164,117,41,242,196,44,51,117,56,84,163,118,151,186,135,109,149,119,143,37,95,55,195,51,109,199,96,32,92,19,214,110,39,15,8,157,49,56,196,69,57,53,25,154,246,104,133,145,52,237,99,166,30,151,125,27,210,218,184,234,59,15,144,198,43,134,114,123,67,84,62,38,209,123,85,221,56,19,52,70,94,253,76,208,126,44,61,204,93,219,226,106,137,251,88,44,130,194,158,78,199,12,106,241,183,126,226,125,1,92,206,119,182,192,214,116,118,9,235,100,139,16,145,118,246,60,138,245,213,192,30,59,203,76,127,125,114,18,35,13,202,139,204,29,177,98,38,91,128,117,131,12,219,246,246,99,199,205,138,166,20,115,205,76,204,2,69,118,207,112,28,219,197,225,186,112,140,126,32,210,9,127,185,193,250,139,31,111,135,155,154,226,196,156,192,156,211,174,210,52,167,176,161,161,221,71,185,213,202,56,141,150,161,140,25,136,136,108,125,80,213,117,247,124,242,43,18,1,200,147,232,150,185,126,158,91,105,84,91,108,181,11,6,134,67,78,95,219,34,204,13,163,77,60,182,220,93,51,202,6,99,116,166,51,44,215,253,202,209,156,9,98,139,254,251,62,122,255,108,63,157,30,116,26,38,57,237,235,87,127,113,220,53,86,103,35,49,214,195,33,9,118,246,233,36,182,108,192,157,155,210,166,149,197,89,154,7,180,134,217,135,255,126,197,127,142,235,250,248,26,22,115,30,120,233,185,106,31,116,178,132,11,62,85,13,10,81,143,142,26,201,158,135,60,234,49,146,12,27,42,96,194,117,85,31,158,160,102,233,202,119,175,6,23,167,53,49,70,5,96,70,139,128,201,42,242,93,103,229,20,165,152,9,64,205,249,156,185,1,205,153,84,214,28,28,112,175,219,255,58,172,16,95,74,189,30,249,185,217,215,88,12,86,37,249,155,87,63,206,120,140,187,41,159,1,229,88,175,201,62,220,10,168,222,190,4,85,126,142,102,115,62,108,249,25,129,86,177,0,61,13,157,85,20,114,177,123,104,19,119,7,187,13,244,229,237,210,225,1,10,41,230,134,150,111,89,76,48,198,236,136,180,252,134,172,49,26,96,242,64,203,107,195,127,175,255,166,40,105,219,24,197,218,16,189,167,168,247,207,7,154,229,192,220,168,169,92,247,68,62,41,128,230,5,203,206,98,39,188,154,138,158,47,48,237,178,70,48,119,153,189,60,148,114,125,52,40,9,98,16,113,120,200,50,30,101,203,192,238,98,5,213,110,153,211,229,255,89,171,37,60,10,235,98,255,64,132,24,59,65,154,107,146,154,143,15,87,176,38,251,179,135,153,179,197,248,90,245,102,251,88,27,214,239,78,229,3,60,210,139,185,79,131,245,111,27,225,239,72,48,38,147,89,136,168,49,86,37,113,87,99,142,33,5,244,119,23,93,2,38,184,54,125,193,19,245,185,48,25,9,193,110,241,125,117,122,138,191,178,94,146,147,152,49,21,159,28,139,55,127,85,67,154,182,54,49,102,61,240,73,222,166,41,215,76,138,241,204,201,174,245,70,193,177,148,214,39,161,35,234,199,2,201,88,143,47,80,231,10,16,79,21,128,104,30,217,216,190,225,126,134,131,106,244,54,102,76,117,132,126,88,206,162,113,239,38,86,78,252,70,67,80,241,98,90,148,85,224,56,224,152,47,58,231,19,22,191,160,214,29,111,26,138,241,25,9,189,212,61,216,146,220,77,84,140,207,129,96,97,223,138,208,251,216,168,57,3,1,149,218,214,220,8,17,9,43,107,217,191,20,108,45,152,187,57,12,85,175,75,37,147,250,192,9,3,139,42,212,133,229,81,226,13,222,206,115,215,225,188,50,213,167,178,170,107,149,196,249,174,216,36,192,14,150,151,18,45,120,2,206,205,36,69,135,187,243,226,242,137,239,16,115,216,102,39,251,64,194,78,21,226,124,155,107,32,193,54,42,228,108,65,190,127,5,106,164,94,117,0,94,47,46,194,234,106,30,235,32,200,215,61,138,66,84,221,45,200,230,175,239,69,31,233,165,248,156,83,70,117,26,128,169,160,213,142,34,242,13,140,237,31,31,175,66,73,64,154,234,90,4,59,117,133,235,14,241,9,73,229,240,101,236,5,74,123,183,146,221,126,209,144,217,74,128,180,28,149,245,118,123,103,158,122,30,31,191,130,130,184,42,235,17,16,145,11,45,90,173,110,191,14,197,1,244,180,61,205,171,152,29,85,193,228,202,63,101,71,54,79,10,196,15,112,42,48,125,213,108,245,26,100,44,253,133,164,81,100,248,211,61,2,1,243,111,82,255,73,47,7,144,252,78,50,172,213,46,33,159,17,139,41,32,28,42,35,77,82,138,240,40,153,160,33,104,157,138,40,120,63,17,66,10,168,224,244,177,52,149,33,74,107,118,169,85,191,133,248,28,218,188,62,46,177,137,251,190,161,100,133,217,121,135,71,247,57,187,185,81,69,234,4,193,80,189,27,79,97,144,169,79,255,112,104,111,233,62,190,14,3,87,13,87,235,37,37,212,243,13,249,20,122,254,246,216,113,104,68,250,214,150,143,110,182,23,91,232,192,70,75,68,108,245,58,133,234,8,240,254,193,199,149,9,3,78,213,248,150,119,220,101,119,200,101,209,43,241,160,196,22,187,103,254,60,154,178,23,118,116,235,121,32,151,73,73,194,203,225,95,183,105,153,144,99,74,250,127,66,42,85,49,217,220,89,195,73,3,152,22,13,149,125,223,62,33,104,214,222,185,165,195,30,46,176,135,91,237,11,110,176,158,250,137,235,198,157,115,225,118,199,168,90,207,8,207,220,194,77,134,81,126,34,131,67,127,80,59,152,125,37,179,112,10,61,185,203,53,52,139,238,218,197,18,19,125,48,226,205,21,157,85,74,34,79,79,148,142,143,71,98,80,11,177,138,66,11,28,94,7,0,105,159,204,225,24,249,121,72,69,172,213,229,105,106,215,248,53,110,207,222,79,156,254,252,86,28,67,116,170,41,138,122,47,255,178,197,192,205,142,63,24,139,32,15,21,165,134,150,16,133,55,13,49,214,125,91,211,19,168,5,137,165,222,42,198,136,43,39,161,35,120,33,125,64,117,216,56,46,35,8,37,53,100,192,59,241,197,19,226,94,226,108,122,210,250,12,122,195,27,53,110,79,229,206,182,183,24,16,123,42,4,39,111,47,6,79,29,105,195,24,120,216,245,13,119,128,240,45,10,216,18,240,177,11,164,214,218,169,100,92,77,211,242,120,9,66,136,121,76,124,209,175,119,180,200,249,163,167,27,156,9,216,169,177,239,227,25,116,13,223,251,42,90,157,96,145,238,240,247,254,229,58,119,234,229,140,124,236,146,113,143,127,164,253,255,218,50,15,238,92,170,114,10,123,2,147,136,128,19,35,213,192,112,205,111,33,222,152,253,233,21,82,89,61,71,85,83,216,111,151,90,61,115,255,100,206,177,175,3,124,118,105,46,112,166,120,48,65,98,172,58,14,35,126,0,165,127,65,94,63,74,251,177,77,245,139,207,131,237,6,238,86,194,170,85,124,154,105,63,243,162,252,140,54,229,31,238,216,184,187,152,90,154,28,79,247,114,103,119,20,65,17,40,91,254,180,102,106,219,42,53,87,5,162,104,250,66,49,227,64,205,195,39,160,230,153,223,96,200,122,239,65,148,190,81,187,88,166,39,249,187,159,77,155,56,68,158,198,85,239,82,109,91,66,175,93,214,149,233,143,16,123,210,77,139,13,241,106,249,208,145,21,153,206,222,93,235,72,143,7,54,106,91,227,122,214,219,119,202,152,94,88,141,71,55,227,169,223,208,178,215,50,173,227,232,128,64,99,17,221,213,219,15,129,12,133,224,135,67,91,35,25,29,156,213,140,87,47,119,50,74,174,193,35,115,34,69,30,87,233,82,69,156,51,60,177,171,250,23,13,107,62,55,95,161,178,48,58,48,137,186,190,57,8,102,182,153,221,66,250,209,60,183,23,168,158,64,225,4,250,14,74,40,83,4,246,27,230,102,38,25,22,147,140,194,208,125,125,42,8,231,163,17,168,58,178,39,59,88,58,157,108,185,122,44,202,149,50,208,35,140,181,206,133,110,73,72,14,129,181,248,109,191,41,43,13,253,122,158,84,88,92,91,138,24,36,226,83,103,176,134,34,79,218,144,170,149,30,10,167,222,4,253,40,254,100,102,16,8,99,147,218,171,110,13,73,147,156,81,53,132,223,202,116,123,179,131,110,230,141,224,187,100,198,74,78,75,130,235,117,32,231,14,198,217,240,84,205,50,211,172,5,92,94,74,27,197,214,94,233,126,75,117,163,216,101,22,3,24,92,36,152,210,88,246,114,16,70,235,210,5,237,91,179,7,59,193,38,158,28,250,117,247,126,239,78,227,17,221,108,107,147,147,121,247,151,56,161,180,29,134,31,155,242,51,120,134,120,120,3,125,251,106,70,84,222,2,225,153,106,141,59,160,212,97,231,100,1,31,86,9,30,238,190,218,198,56,253,44,119,186,136,193,138,5,201,49,167,179,213,156,191,15,206,36,207,30,196,149,106,53,5,8,61,28,42,25,160,107,111,216,3,113,218,128,171,92,128,39,201,24,189,193,116,124,231,47,27,109,131,98,135,157,147,41,49,131,162,99,221,146,19,190,147,52,123,21,178,128,184,200,227,129,111,209,80,128,131,67,178,16,39,101,217,152,147,153,27,215,217,173,186,106,138,206,119,40,113,229,160,135,18,101,48,137,139,253,45,184,28,119,160,150,9,169,133,77,9,98,243,231,39,167,252,53,44,206,132,189,184,181,244,214,58,185,124,118,251,16,235,197,164,189,198,83,148,64,215,111,139,85,199,235,41,234,199,129,96,13,242,3,49,117,45,69,50,105,208,77,252,246,34,119,33,103,46,193,145,252,150,241,77,31,16,53,241,73,213,94,250,157,232,12,154,221,209,159,79,61,81,229,185,221,208,197,127,167,108,91,58,210,16,148,42,70,22,224,142,197,55,186,71,116,241,33,62,114,161,217,200,229,70,80,5,165,65,210,198,198,92,165,31,157,227,177,187,93,85,106,142,121,72,85,152,8,246,247,182,114,106,172,37,227,150,249,23,246,231,202,158,52,210,222,43,228,72,199,18,56,71,113,18,75,197,62,199,49,42,130,125,140,40,194,207,251,17,214,94,136,18,238,241,23,93,219,53,123,154,165,103,37,70,209,201,82,106,253,152,169,98,67,50,108,128,192,251,10,99,198,109,71,33,50,187,147,135,53,224,108,112,243,221,110,98,164,158,218,107,157,165,158,222,134,39,23,235,170,196,103,182,112,140,245,29,151,129,35,46,2,41,255,136,13,58,165,102,2,110,214,32,217,216,92,8,2,43,151,134,219,152,59,76,37,78,37,251,150,69,184,234,238,86,21,57,210,19,230,247,205,173,247,254,222,8,118,191,206,29,74,86,223,96,130,114,12,105,123,141,6,94,168,61,2,39,40,190,99,85,111,167,143,16,145,125,145,124,133,53,179,35,143,184,122,19,125,175,57,74,19,82,132,31,64,188,255,200,45,140,110,72,75,58,221,186,10,189,255,105,119,23,17,131,96,78,236,120,170,55,118,61,69,242,82,67,137,163,250,70,211,178,220,181,216,196,241,93,236,160,201,211,223,9,250,190,196,115,75,40,192,39,79,151,33,200,72,112,63,255,135,141,213,172,188,80,34,230,87,60,250,137,140,215,173,152,199,124,236,173,126,99,117,35,83,107,221,30,100,147,90,240,48,189,178,156,3,237,218,83,220,230,146,37,10,52,169,108,108,221,131,128,250,160,166,8,190,128,98,255,126,166,145,39,58,117,160,146,25,1,1,48,221,246,168,6,126,85,136,50,207,138,83,239,134,107,226,24,106,153,116,169,126,233,158,52,195,254,23,62,20,2,74,184,98,37,54,105,114,171,11,137,17,1,127,213,234,251,143,232,194,57,111,150,179,84,236,172,132,141,68,213,183,24,224,119,97,9,232,209,99,234,207,237,218,36,233,121,139,30,114,178,223,189,249,83,136,27,182,172,233,162,214,60,221,35,41,134,143,246,95,45,236,143,3,57,96,91,174,34,217,183,239,161,187,191,46,246,196,135,161,119,62,177,244,218,227,210,42,148,61,216,1,111,34,249,228,218,245,8,107,85,153,31,58,59,40,9,14,126,164,236,127,153,240,246,42,155,192,230,70,242,17,148,21,58,110,179,119,83,249,191,23,201,232,5,130,192,60,44,104,124,36,242,68,156,243,238,95,123,125,156,252,184,81,97,109,66,179,75,9,182,226,80,127,103,141,79,198,143,146,212,236,106,188,169,203,96,155,29,255,220,33,79,92,55,135,51,79,251,102,123,217,42,15,63,127,176,8,213,60,76,13,168,109,203,171,250,27,94,35,51,159,126,175,245,17,0,146,1,209,34,178,68,240,21,102,162,226,165,60,191,138,169,116,74,160,183,146,38,242,227,118,162,101,119,131,216,141,93,223,142,123,99,97,61,93,221,189,203,102,65,248,120,162,132,81,130,106,2,227,55,41,225,225,120,6,21,252,169,182,233,129,247,134,152,78,220,11,116,64,235,185,13,155,109,28,106,87,49,153,134,153,104,150,19,37,29,234,236,156,8,231,217,251,39,161,237,1,8,136,191,154,118,51,186,250,44,97,176,136,110,13,189,190,220,212,111,238,143,215,102,227,29,87,31,229,34,141,83,49,55,6,50,184,60,111,85,72,61,199,15,206,229,178,129,116,175,162,215,86,227,210,154,109,243,16,117,30,211,198,26,7,254,9,122,223,202,85,155,25,177,136,182,150,235,243,209,152,49,82,166,130,234,148,137,134,130,89,215,55,127,136,71,99,169,221,54,174,157,75,93,172,71,94,177,157,181,241,95,255,253,213,147,100,38,40,142,186,241,138,236,60,14,36,88,223,91,67,37,124,85,196,69,139,174,208,221,226,106,233,214,171,160,196,85,143,250,166,123,173,180,220,208,141,12,54,166,118,180,132,196,39,55,207,159,139,61,27,205,126,78,73,175,97,27,134,83,39,146,208,100,67,204,80,253,70,140,91,73,67,151,83,142,238,158,176,181,211,32,216,126,61,192,197,69,125,102,151,240,240,140,126,49,136,85,42,82,249,232,220,46,135,80,112,172,175,18,107,108,161,99,156,215,28,162,252,137,248,186,194,212,249,209,233,158,233,51,182,194,49,184,134,255,237,241,132,141,56,235,232,120,111,157,51,121,254,5,94,215,224,220,154,40,95,3,203,188,157,197,77,39,75,2,127,215,135,36,125,114,50,14,4,217,43,86,115,57,124,151,144,21,35,26,25,239,222,161,138,33,81,204,208,85,253,179,109,86,59,201,149,175,100,228,178,127,163,96,245,238,204,54,79,1,82,178,251,45,59,231,224,230,240,31,219,86,181,216,226,216,46,200,221,238,130,254,132,56,196,158,154,252,80,40,76,75,194,96,198,129,141,201,35,222,99,184,205,238,129,245,79,205,109,168,67,149,79,248,93,33,111,87,197,238,253,237,85,242,41,229,216,147,204,236,114,254,18,171,172,12,141,21,27,120,198,10,104,27,90,27,234,18,203,245,216,150,255,200,118,27,246,190,220,167,160,13,10,250,10,253,238,164,80,167,109,194,205,207,94,64,82,122,235,129,235,39,117,131,1,57,234,130,168,89,20,149,27,171,200,233,74,65,202,84,217,102,185,106,178,184,230,115,97,168,211,254,230,227,34,162,221,88,97,88,230,31,32,56,118,23,161,3,179,246,138,42,173,117,43,78,225,248,171,47,156,76,35,93,239,59,109,159,38,46,161,125,160,113,103,27,122,167,64,9,74,50,104,123,131,166,110,190,222,214,218,55,23,210,2,241,148,116,144,9,232,21,64,136,101,188,224,222,198,141,199,118,167,236,19,165,90,84,126,97,197,70,220,11,136,247,2,171,106,24,98,33,218,129,219,80,42,232,63,18,90,135,227,65,218,166,236,65,119,108,210,33,169,221,165,31,234,27,250,211,147,142,93,205,42,2,10,169,12,206,173,237,231,206,157,176,97,220,213,72,31,232,158,53,6,17,191,101,13,83,219,170,23,142,189,224,116,189,115,16,150,55,211,47,175,229,138,29,165,9,192,20,121,112,148,182,19,232,206,36,24,182,165,93,19,171,101,16,218,80,45,29,179,206,10,187,14,130,88,228,196,8,146,166,25,5,57,180,61,133,219,46,200,207,154,53,231,29,138,104,17,198,168,239,159,135,28,97,130,59,57,205,168,244,201,227,68,137,240,35,82,114,208,123,65,169,27,181,151,55,35,119,18,255,25,105,132,114,39,8,137,2,48,20,171,154,26,67,131,83,114,122,194,71,32,16,166,174,18,70,92,168,146,32,114,12,48,137,251,58,184,101,251,151,230,15,201,179,43,231,157,40,107,26,19,157,45,61,252,18,60,202,10,188,22,97,155,25,162,128,27,115,235,180,227,28,47,212,130,156,216,6,18,86,206,242,188,54,25,210,237,79,225,50,96,244,124,104,179,113,7,156,56,129,104,167,52,118,67,184,117,149,109,161,177,101,115,239,99,89,109,61,171,219,211,161,41,219,22,38,73,59,99,100,49,208,59,142,250,60,95,253,55,51,172,40,89,36,158,99,41,156,148,153,255,27,129,112,185,117,144,240,252,140,102,149,149,92,121,50,28,5,226,111,160,177,26,203,92,154,249,40,138,131,82,168,87,242,215,217,66,232,107,191,131,85,156,251,69,138,103,199,110,199,169,241,126,243,14,6,77,197,137,161,97,246,107,226,169,191,19,10,190,100,15,243,140,164,56,14,245,39,111,229,134,47,153,31,175,209,213,163,188,62,190,12,178,23,212,12,115,159,63,106,47,151,179,13,20,6,138,93,182,79,223,107,238,36,0,144,52,95,219,4,41,28,2,91,215,99,18,167,89,235,29,22,204,123,198,178,56,49,101,170,252,212,231,118,62,139,160,160,108,20,232,201,13,151,133,227,52,27,223,48,210,0,119,141,239,57,255,120,17,164,112,105,48,237,3,175,230,248,64,176,155,78,170,107,227,137,122,218,32,72,18,245,174,142,79,206,57,4,180,176,133,206,243,166,104,9,110,160,155,83,155,145,146,242,85,179,101,40,48,147,117,101,44,228,161,21,47,135,112,116,192,39,131,36,207,154,111,56,163,199,30,176,214,142,120,20,140,159,63,117,32,37,155,211,109,42,204,103,213,152,169,24,156,232,146,228,209,104,7,247,157,118,151,15,115,103,163,29,170,197,101,30,173,197,171,231,122,90,199,38,190,197,236,218,81,77,58,33,252,134,98,232,177,197,199,129,28,236,96,214,141,240,12,62,125,56,63,10,254,141,174,30,182,82,213,234,248,226,215,181,226,197,96,12,110,150,182,145,240,222,122,154,33,144,255,205,211,119,232,250,232,254,114,132,234,58,135,214,150,231,165,172,239,33,139,13,215,45,246,130,159,230,150,24,171,53,38,144,148,18,226,134,140,183,155,0,235,0,239,224,137,41,45,25,124,9,78,176,206,119,175,89,213,62,131,132,147,224,39,8,65,221,31,251,100,201,185,83,64,229,18,96,107,126,121,24,122,6,56,123,115,92,73,23,166,226,94,199,86,114,228,43,247,171,183,193,22,181,92,244,138,17,188,63,55,238,92,197,114,18,89,70,188,213,168,195,64,216,192,178,71,253,64,53,183,152,197,178,133,201,69,238,178,79,132,58,162,208,122,21,248,73,240,140,134,229,66,226,191,192,242,156,40,224,253,220,2,15,236,196,158,56,173,253,105,66,134,162,154,110,174,8,105,102,236,157,66,103,200,58,134,204,106,129,123,89,181,141,252,221,96,62,176,69,132,131,221,17,160,78,102,159,72,66,40,75,121,86,45,164,227,136,104,42,200,103,75,178,138,14,230,52,178,18,148,155,242,83,228,216,112,37,232,179,91,161,255,60,232,83,212,86,181,48,121,47,84,51,198,23,183,43,78,247,91,20,45,189,111,185,10,206,227,99,234,158,109,55,67,6,156,106,22,59,147,205,95,224,156,112,1,178,85,51,107,16,145,243,76,228,155,147,59,240,130,229,27,128,1,32,154,22,69,20,83,53,110,168,162,69,100,46,119,203,214,150,188,222,203,182,15,119,225,28,199,141,169,25,223,245,82,213,45,134,72,21,22,243,58,156,251,196,163,252,31,233,81,216,11,132,89,81,196,41,88,242,69,82,201,210,84,150,198,192,178,85,254,6,118,4,133,11,171,106,247,117,5,91,91,38,174,21,196,60,244,242,211,214,193,185,107,234,208,208,202,10,197,160,50,73,62,25,224,31,101,205,53,93,53,95,232,47,124,91,52,221,73,76,207,140,210,121,195,9,134,232,220,117,27,162,91,117,13,237,125,109,54,137,254,5,241,245,107,80,149,58,254,241,195,16,14,187,151,97,134,158,58,171,84,172,60,167,43,95,109,54,148,220,31,241,211,79,105,44,121,86,139,155,213,192,217,176,36,113,146,13,158,239,114,20,227,110,252,13,88,167,54,148,253,56,1,164,101,149,179,99,114,204,81,97,131,150,192,135,76,103,180,188,174,139,89,241,35,228,40,167,56,130,152,253,45,110,177,101,33,11,242,74,227,96,101,166,95,11,80,23,22,11,119,99,22,219,51,8,9,208,205,117,28,140,194,13,67,56,47,192,17,247,210,244,125,146,207,13,28,65,77,71,136,29,132,139,12,132,38,165,228,159,146,228,189,102,240,117,143,157,179,90,184,248,45,24,205,29,158,53,77,224,121,133,93,60,145,230,118,17,3,175,191,59,211,197,76,111,106,117,92,231,183,5,56,99,84,90,111,130,159,240,105,5,163,118,194,145,168,243,180,108,255,106,214,63,236,48,166,47,78,129,155,142,111,125,35,18,154,19,227,188,120,230,62,100,98,191,255,35,53,112,144,77,103,34,236,55,249,11,255,44,111,182,14,145,51,88,85,176,116,187,139,1,129,182,45,163,253,59,15,236,226,115,169,177,65,51,150,184,226,86,125,186,99,129,102,135,140,39,177,65,247,166,163,119,159,89,68,188,254,73,250,189,155,135,93,43,203,30,136,125,73,142,107,36,231,188,130,174,201,156,220,196,52,145,163,148,208,158,156,114,77,145,2,167,43,67,169,254,45,132,9,92,39,130,226,204,186,149,18,58,147,231,17,82,62,202,245,225,42,71,32,123,135,128,254,221,125,132,49,153,126,141,158,13,124,148,91,120,117,125,108,0,168,167,69,160,133,196,141,62,190,42,83,94,171,192,66,156,111,181,73,83,240,165,67,51,98,96,144,56,162,101,238,25,104,106,182,83,198,151,88,60,114,211,54,90,20,22,163,22,170,3,169,255,254,201,34,84,186,29,104,195,70,246,88,131,160,16,112,180,142,94,37,58,72,146,188,118,6,89,188,23,72,235,253,29,107,166,121,178,77,32,185,204,153,194,88,187,245,175,139,6,207,224,148,5,194,40,16,103,205,245,115,80,42,110,20,74,113,222,133,77,114,71,209,91,167,112,206,66,74,130,7,207,22,249,36,50,122,86,177,233,8,242,89,52,86,164,95,192,227,251,146,172,1,87,129,91,8,206,95,236,34,135,149,190,64,198,231,201,33,109,113,28,250,20,11,24,98,115,148,225,56,9,233,223,20,66,25,64,39,160,252,132,13,68,43,142,36,14,209,140,61,189,33,196,222,157,238,132,17,112,208,28,18,141,206,46,212,142,229,98,177,35,172,54,248,57,101,204,222,115,152,40,139,106,78,20,166,151,140,176,221,228,235,115,160,151,58,183,252,178,2,219,194,227,149,212,109,7,142,44,28,14,73,99,88,207,220,61,9,16,93,167,120,3,19,140,105,206,61,152,104,201,11,61,122,121,46,10,69,217,157,74,31,199,136,35,218,49,75,217,205,79,214,78,76,5,28,38,59,64,148,238,177,102,180,10,42,68,132,196,208,87,216,89,214,56,30,59,139,74,210,54,153,238,163,230,79,46,139,147,131,35,225,24,214,49,212,88,252,81,83,234,97,157,236,171,100,56,251,189,49,152,223,102,120,237,120,218,183,164,189,132,166,235,108,152,251,168,141,157,113,15,97,2,93,44,140,222,142,25,102,235,44,225,89,202,75,162,190,135,242,243,168,87,135,152,25,68,156,196,219,78,133,160,128,7,221,143,182,168,71,85,128,97,36,196,19,169,126,131,229,146,145,59,164,212,193,139,216,46,64,249,69,104,54,27,2,25,224,41,41,88,166,28,184,108,103,50,61,30,10,9,121,27,87,63,149,176,17,164,114,172,247,12,175,178,50,151,197,206,115,134,132,137,20,211,125,124,13,131,72,22,9,205,163,150,190,71,87,14,232,244,96,55,86,255,147,154,182,196,194,36,171,73,95,131,30,114,157,85,156,243,193,143,56,220,17,8,244,105,198,115,179,14,204,82,243,228,249,137,25,41,200,170,246,230,88,69,37,92,32,238,100,37,176,138,94,14,144,203,94,90,113,217,111,158,89,193,140,30,103,129,109,20,78,108,252,11,107,65,77,88,210,145,209,83,217,100,228,254,127,158,9,249,100,158,27,15,232,210,85,25,75,227,161,100,195,32,195,98,62,25,0,103,110,170,113,229,74,172,236,246,243,29,194,93,225,26,103,236,53,16,222,179,87,38,128,225,101,26,227,11,207,149,63,130,105,186,31,76,222,155,26,17,106,128,146,13,5,73,100,164,202,200,57,220,19,213,117,138,219,132,155,121,215,116,128,132,79,164,151,98,151,199,237,252,39,114,192,189,111,192,249,80,165,189,87,27,86,164,254,74,110,79,230,209,74,167,166,147,134,217,107,212,107,26,186,168,170,90,168,116,133,23,145,240,157,77,161,3,98,128,185,76,128,51,163,105,170,112,154,151,131,31,170,165,5,100,148,144,247,62,113,17,224,206,207,125,125,206,92,89,101,168,46,200,107,222,48,133,128,13,28,168,95,4,182,224,213,79,112,133,128,157,226,138,211,66,111,128,252,42,39,235,139,103,174,115,204,42,121,16,114,243,112,41,28,58,46,28,70,130,121,230,92,155,135,225,67,134,83,222,251,54,169,221,90,207,107,133,7,157,166,252,117,143,100,89,13,234,96,236,204,147,241,64,112,231,76,8,215,21,172,239,146,222,91,241,64,237,221,226,56,79,67,109,88,213,13,128,55,22,57,153,94,27,114,226,5,228,106,2,194,88,191,245,227,205,105,112,37,217,85,120,92,42,129,156,34,13,165,61,29,157,27,84,215,14,218,52,133,158,47,95,104,107,216,242,5,204,73,229,97,48,34,1,84,164,138,239,22,171,245,117,27,80,141,252,8,106,239,245,215,125,108,138,84,94,10,252,143,192,18,170,210,218,236,17,250,244,101,48,108,82,224,227,12,99,255,247,158,193,11,137,143,55,114,69,240,210,80,189,109,118,60,193,24,86,99,164,182,212,148,191,60,82,6,160,3,191,58,133,199,27,177,163,220,158,182,92,101,224,186,231,211,133,137,109,102,163,179,240,38,215,94,206,180,189,140,30,250,139,45,60,235,47,151,212,104,132,27,179,16,48,147,20,136,138,79,120,63,143,84,31,233,168,73,107,101,20,178,146,45,61,175,183,68,11,166,158,67,13,110,105,86,184,15,239,167,161,184,137,109,164,131,225,168,96,85,175,98,16,250,63,86,62,63,21,98,3,237,214,110,54,65,173,120,101,16,50,103,138,80,140,251,203,164,249,107,139,226,142,55,199,99,26,146,112,22,131,16,97,142,3,81,87,1,96,37,155,119,251,11,213,193,180,191,242,44,239,223,99,37,143,33,97,50,253,77,20,124,120,5,225,34,210,160,218,57,135,161,32,208,4,226,183,50,51,148,55,175,73,33,76,251,171,227,64,81,32,239,101,241,108,129,166,85,228,225,175,4,117,99,164,25,232,126,14,67,28,53,81,46,9,88,244,73,159,108,241,173,14,122,92,195,72,16,6,42,184,192,74,11,87,220,221,215,134,164,59,227,236,114,246,203,46,217,20,147,146,65,111,85,153,159,24,137,38,44,233,110,71,48,131,168,119,9,184,243,181,56,183,173,0,214,172,42,161,151,233,97,244,228,255,223,180,101,110,187,196,228,80,176,153,142,75,179,77,117,93,136,82,193,37,79,209,5,72,105,99,21,181,135,156,20,90,191,192,198,99,75,14,184,246,6,140,91,12,231,209,64,66,88,71,195,91,229,20,78,45,193,123,122,235,134,224,158,250,57,49,115,233,45,153,124,235,61,56,245,29,136,144,70,151,246,213,196,253,255,199,215,188,202,164,203,143,63,227,115,64,57,67,95,135,216,219,186,154,205,120,32,15,237,85,142,137,137,241,185,230,90,2,196,109,91,105,217,142,207,233,109,63,118,105,113,54,75,163,170,194,133,189,118,98,34,232,173,89,108,248,69,125,150,116,54,65,148,94,113,232,121,165,138,155,218,84,233,128,185,90,161,152,248,189,146,96,2,137,162,251,42,138,93,34,117,31,138,205,79,169,160,109,75,196,158,210,138,177,99,131,231,195,218,46,126,252,180,60,255,14,206,166,83,237,123,35,172,9,144,147,222,106,82,41,110,15,123,242,216,133,51,26,123,4,81,57,252,91,48,176,178,155,69,129,221,84,105,40,99,233,142,191,233,220,247,90,100,146,206,201,66,93,9,84,67,176,104,128,14,139,5,59,168,80,125,252,162,193,196,111,225,248,147,142,107,127,149,97,246,107,111,200,16,92,83,206,104,13,23,226,90,144,236,40,133,73,14,31,87,132,22,122,116,225,117,17,108,149,214,180,200,121,158,114,148,137,11,40,232,153,151,58,24,83,168,164,17,19,111,34,201,231,190,253,245,80,151,30,42,121,229,248,72,91,206,211,35,107,218,165,84,128,76,225,109,57,105,17,243,211,29,10,4,78,31,121,56,39,74,151,151,91,44,105,28,245,64,98,160,217,122,186,38,171,127,109,123,218,50,190,159,148,133,249,238,211,99,156,63,247,132,109,51,18,102,134,27,63,205,111,148,106,196,107,110,38,192,254,7,79,64,81,127,206,68,170,115,104,190,16,121,186,42,177,247,170,20,56,51,110,29,215,243,149,144,205,139,151,37,69,24,134,152,22,168,229,153,230,57,150,182,198,44,106,103,155,182,178,36,55,178,108,90,65,46,161,222,15,166,116,76,167,157,159,155,240,217,176,150,159,195,112,10,45,169,191,212,219,27,47,69,206,113,251,194,77,91,153,69,99,174,151,15,226,29,161,31,43,7,91,109,147,55,247,41,149,203,140,142,184,11,44,92,173,120,167,3,251,73,181,155,21,35,231,2,145,126,3,230,141,122,196,5,11,157,193,214,89,184,130,74,106,127,201,172,99,172,184,114,175,231,89,158,245,65,96,174,133,252,90,178,180,168,245,208,70,9,226,134,176,115,204,148,151,189,92,162,82,108,138,247,28,15,72,175,66,103,4,11,137,110,28,81,97,96,118,249,194,95,188,6,3,229,188,118,47,93,163,227,103,74,118,90,161,67,138,154,185,125,201,207,31,57,188,223,154,97,76,221,69,167,155,65,211,113,154,78,45,114,24,114,184,173,150,89,53,119,153,226,172,106,44,146,62,91,68,167,244,2,129,101,193,243,101,249,107,236,243,99,1,118,204,192,208,104,143,215,186,104,68,228,73,230,92,236,209,209,141,230,9,101,91,177,205,61,67,203,218,40,122,152,49,99,215,213,244,144,134,254,125,230,142,203,177,27,212,228,66,187,180,214,154,236,229,102,1,190,77,4,131,210,95,173,140,96,86,244,240,65,81,24,221,79,165,138,164,117,3,187,212,208,188,109,132,109,60,61,63,138,109,72,155,67,155,63,50,183,145,241,75,181,79,209,247,240,148,176,127,175,81,202,152,198,225,56,30,183,150,198,189,36,236,35,46,195,40,80,223,45,42,169,25,53,4,109,5,100,244,162,92,83,78,114,21,100,2,182,29,68,84,127,201,255,2,36,135,100,218,232,4,133,2,103,107,100,243,228,57,163,19,105,85,122,136,41,51,90,90,31,226,148,185,155,172,235,42,142,208,246,11,18,218,192,86,170,79,32,114,35,37,229,235,89,36,127,202,63,234,209,106,245,250,58,196,177,175,2,22,196,217,169,219,167,76,107,48,99,108,232,59,168,251,138,51,43,79,233,57,155,151,21,12,2,132,5,161,65,85,107,41,231,21,127,113,47,254,233,60,20,239,113,111,60,169,237,111,176,124,199,169,39,24,85,248,232,44,195,109,205,84,80,54,182,73,185,87,108,72,71,62,49,174,135,154,102,71,130,124,214,46,155,52,38,236,219,91,59,18,9,134,128,74,241,128,94,27,211,210,81,106,126,95,7,25,72,210,120,221,39,70,195,43,94,219,111,130,179,210,100,55,119,106,22,243,152,159,201,38,151,77,81,221,132,157,22,18,198,172,30,86,123,133,192,9,164,19,162,67,4,70,179,29,39,80,90,21,97,196,85,57,35,139,118,130,7,205,252,209,136,87,175,2,21,114,219,207,228,219,173,193,215,100,60,125,148,55,68,182,36,191,50,114,171,227,227,35,77,58,137,172,59,111,112,13,114,168,211,187,223,130,120,137,16,171,82,29,212,134,53,38,105,138,144,224,114,107,61,40,122,225,96,133,24,97,12,221,78,15,139,148,152,34,190,126,92,152,41,105,175,173,61,78,183,145,100,83,43,34,19,206,122,74,94,252,89,135,190,30,201,102,110,133,158,141,136,68,78,233,146,138,173,128,132,194,194,163,101,190,247,23,167,71,164,107,13,27,104,254,174,217,69,233,100,30,250,234,205,43,78,199,161,235,249,24,199,245,231,253,66,24,179,7,163,11,144,127,136,254,109,231,214,160,122,86,125,255,91,66,148,47,234,66,179,95,127,146,133,202,224,89,113,70,73,191,151,203,129,22,251,1,123,182,187,118,148,18,177,22,185,83,169,38,147,30,171,104,138,175,109,192,153,132,157,131,80,228,133,210,244,158,96,105,199,238,118,135,127,224,72,233,11,228,238,217,160,254,85,29,136,239,191,118,42,216,168,82,6,116,161,2,12,53,89,75,235,251,19,187,127,168,66,93,10,124,190,237,118,172,29,206,232,9,142,228,153,74,123,90,63,30,126,76,27,6,167,178,101,105,140,110,54,102,171,131,20,81,110,139,53,131,138,226,127,170,90,99,214,64,101,224,37,95,121,113,200,89,107,232,27,34,111,155,95,111,190,110,127,8,121,58,176,122,110,116,230,232,6,131,131,195,68,246,62,217,68,115,45,60,198,35,79,20,91,48,58,52,51,6,73,196,75,68,192,37,255,132,91,133,106,252,141,84,139,200,208,145,113,164,76,40,69,209,181,185,183,96,79,48,142,217,79,251,208,173,123,96,27,95,154,52,32,191,168,179,160,205,211,94,37,202,65,12,11,253,193,79,43,176,223,151,25,242,232,193,2,248,65,133,200,137,82,117,113,76,11,141,82,196,87,89,65,78,149,217,104,194,170,81,85,4,224,181,100,107,152,145,38,201,204,189,238,139,136,157,54,151,220,153,12,54,90,74,8,60,231,4,124,242,110,5,241,255,60,237,231,203,123,151,234,97,39,187,223,43,244,160,21,208,85,38,30,26,1,157,61,84,158,201,198,67,4,133,41,48,107,145,198,132,175,20,195,185,71,83,194,169,53,178,191,66,73,115,153,73,89,103,157,174,18,113,43,10,11,103,175,10,9,114,180,134,1,6,34,37,32,2,218,177,25,238,251,13,52,161,46,20,20,2,127,210,204,194,237,169,163,120,122,188,66,52,202,136,189,56,228,56,164,36,203,115,121,231,239,198,205,79,42,117,91,149,102,214,126,76,168,26,154,21,75,80,129,98,227,189,138,108,3,144,65,64,231,142,98,18,126,148,105,230,179,99,204,237,127,182,208,160,92,30,104,233,215,172,16,183,179,16,77,136,231,191,28,4,24,108,225,122,235,59,136,144,33,32,255,103,254,123,128,44,53,102,25,77,232,115,196,62,210,182,53,232,71,74,225,81,4,0,146,184,224,216,187,90,141,209,35,169,154,193,171,175,2,115,185,144,162,226,156,184,34,6,186,163,189,204,64,220,32,28,138,175,42,125,231,217,90,154,35,252,134,60,32,224,215,40,145,159,82,244,158,223,40,82,30,68,119,198,156,168,90,149,24,132,218,9,107,176,66,170,8,208,111,103,146,10,112,55,228,113,167,59,130,28,151,239,244,181,109,102,55,214,1,176,190,188,123,198,220,8,52,139,161,6,204,42,166,11,120,105,47,219,42,153,181,3,195,72,43,46,22,118,89,11,141,23,43,110,141,217,127,0,151,19,3,217,205,217,235,1,251,102,130,200,1,89,173,63,165,49,134,199,37,45,161,205,95,44,168,206,24,206,172,59,38,33,17,57,16,66,131,52,197,51,44,189,176,140,119,194,101,46,101,202,254,246,29,221,191,8,57,17,190,239,144,231,167,55,49,71,221,157,159,211,31,172,221,38,222,82,217,184,74,126,128,38,157,86,232,129,191,123,175,52,108,238,188,72,187,99,160,158,77,140,176,117,150,177,191,180,110,198,199,162,219,208,103,179,74,117,192,119,93,199,93,97,14,103,191,145,130,41,29,163,175,37,36,152,2,14,120,223,162,94,96,141,195,63,255,221,143,50,35,99,120,49,198,251,2,181,177,240,21,12,158,184,6,240,234,212,27,228,51,30,45,38,252,161,139,17,157,78,191,14,134,0,159,41,46,233,104,0,176,140,11,14,188,246,117,22,203,236,164,14,221,239,122,10,43,225,35,255,137,222,143,217,222,179,40,51,12,188,216,169,51,196,252,15,228,121,107,13,90,63,6,39,151,118,124,211,19,41,81,122,130,120,91,59,255,157,79,87,136,152,220,139,84,153,199,175,165,70,61,32,69,9,56,16,152,221,151,80,133,222,131,129,187,186,39,221,255,216,27,96,159,72,133,79,27,218,97,30,121,57,183,18,23,127,96,181,244,43,185,198,87,247,126,132,233,21,33,185,80,99,70,226,152,208,84,116,164,117,130,249,170,36,21,70,240,96,85,25,64,45,195,10,7,164,85,218,225,249,223,74,14,232,83,209,254,251,77,54,76,204,244,43,56,246,218,77,192,55,138,229,3,123,204,28,155,232,111,222,86,170,146,117,97,246,77,86,145,86,155,204,217,209,142,104,155,18,151,203,202,238,121,129,149,29,180,81,131,96,102,146,164,31,130,123,85,240,93,73,142,0,66,6,58,9,80,171,89,11,105,121,189,98,104,3,188,246,228,61,221,61,109,228,44,255,248,208,142,58,33,48,67,182,144,120,63,102,208,124,24,249,185,119,10,134,79,91,217,240,44,113,138,38,81,81,38,172,137,168,119,123,58,115,13,10,188,43,16,113,107,105,43,14,119,202,141,170,173,96,195,93,253,243,78,103,100,64,196,249,188,121,128,21,103,193,129,54,163,126,199,106,244,187,108,68,105,55,16,196,136,215,31,158,47,208,109,247,122,101,76,55,198,175,27,194,232,191,190,175,172,206,120,57,74,168,140,231,49,221,8,52,149,207,48,190,96,51,242,67,63,78,178,147,102,72,227,251,145,182,66,127,168,74,191,136,135,54,10,146,15,65,134,73,89,253,214,11,217,105,30,67,196,225,92,99,5,205,115,120,214,84,189,254,233,7,190,17,45,37,168,76,91,11,75,90,170,44,121,133,174,80,0,151,174,242,77,62,179,171,191,248,170,179,75,7,8,93,235,240,18,125,186,12,39,10,194,246,119,198,228,102,72,118,130,120,189,251,182,105,106,127,104,243,103,67,163,82,176,173,52,167,108,15,69,200,24,191,56,105,191,25,27,173,14,133,215,241,250,29,242,11,218,223,83,97,27,27,160,190,7,215,117,147,21,2,61,135,124,88,191,35,110,94,49,146,175,134,126,29,113,206,230,89,179,31,131,246,132,96,74,176,246,40,218,39,8,145,33,77,126,156,147,119,0,7,57,253,188,252,144,12,76,108,67,114,23,5,25,113,213,67,79,2,239,37,171,212,38,48,16,75,242,208,88,169,158,227,137,43,248,34,164,52,102,150,126,200,219,243,153,161,232,5,186,142,85,141,237,9,105,145,153,198,99,201,42,128,229,40,130,154,117,46,254,70,185,130,130,18,59,187,65,184,101,84,194,33,116,125,189,105,174,218,157,18,76,197,87,201,97,189,124,73,120,71,16,190,173,193,180,152,225,101,21,128,43,58,219,126,189,11,102,81,24,42,24,1,251,89,62,185,53,115,42,238,160,9,57,146,206,249,170,106,190,97,152,179,104,69,81,252,252,26,234,175,78,57,141,162,235,240,43,176,94,110,142,177,253,141,71,211,110,228,126,161,19,204,119,115,102,214,187,29,244,247,86,228,124,217,137,62,209,136,159,204,232,127,7,61,249,114,186,71,255,49,170,63,50,7,186,250,222,243,64,61,195,4,145,221,112,240,104,116,129,17,111,91,156,121,207,108,119,72,118,213,37,13,242,169,98,87,125,222,158,112,223,243,124,161,129,10,189,125,229,70,214,217,115,235,190,11,162,203,46,86,21,10,169,110,72,21,204,25,48,201,205,72,65,121,130,243,189,72,74,117,179,192,217,74,174,118,42,222,29,215,64,239,176,103,4,191,182,35,126,160,228,118,242,60,162,132,38,73,73,138,190,243,190,26,206,152,124,143,60,10,117,226,133,102,115,53,109,121,46,73,154,59,18,253,168,9,210,9,220,70,232,83,186,142,218,2,96,90,55,13,192,28,174,67,232,184,229,136,47,70,200,59,64,32,26,176,50,203,185,81,166,224,153,150,127,245,22,9,253,203,159,74,25,212,16,181,169,77,138,169,109,100,232,110,138,179,199,160,120,3,113,191,204,22,127,185,4,15,88,221,248,218,173,96,148,108,140,211,158,110,66,149,200,58,103,44,91,253,43,109,242,87,159,196,33,207,241,21,59,29,179,16,6,164,160,8,18,150,109,120,33,239,2,36,232,46,189,185,130,111,107,27,176,52,143,226,231,31,170,224,191,14,139,59,202,142,227,167,227,119,222,198,121,3,242,89,228,69,202,178,253,218,188,173,233,66,255,176,69,105,205,244,220,82,63,55,111,113,168,35,255,81,12,118,79,238,2,232,49,121,19,133,16,28,24,40,250,42,169,170,52,34,241,87,123,30,177,169,118,43,73,27,223,145,191,166,160,23,163,243,189,175,24,229,190,218,174,26,106,31,174,30,123,217,143,155,137,187,180,10,97,100,98,235,135,161,137,24,53,165,255,163,64,170,72,12,62,114,130,106,251,211,139,252,120,160,130,67,145,73,146,179,81,22,158,246,113,248,229,118,245,127,71,106,52,251,240,91,221,123,112,111,76,182,121,83,255,31,120,190,178,4,59,240,252,90,183,42,167,249,74,210,250,203,34,240,115,193,222,175,117,170,33,196,92,196,246,189,103,220,222,222,177,181,52,202,48,89,99,223,219,162,243,111,249,141,245,167,184,158,39,190,74,7,160,120,144,43,239,171,77,142,180,114,88,109,152,98,64,160,20,27,136,4,156,90,129,202,226,228,134,155,216,18,28,201,46,239,25,14,91,36,111,240,217,231,145,93,233,170,135,246,98,34,146,89,22,223,140,119,189,199,148,73,18,188,143,59,11,57,112,246,244,241,143,68,243,130,148,248,5,42,112,25,113,42,157,53,87,106,165,213,162,49,107,89,160,43,167,53,113,203,23,183,65,84,99,36,159,82,115,222,183,44,238,51,138,87,21,195,50,207,254,113,229,53,139,103,195,76,111,204,236,35,183,0,42,228,252,11,51,43,168,106,10,160,146,20,212,208,78,65,0,131,103,166,70,251,25,104,190,134,84,78,125,133,29,57,63,40,85,171,140,143,10,167,36,179,54,25,142,32,23,165,18,156,84,6,77,22,195,228,251,47,95,152,44,19,100,126,234,64,109,238,37,86,35,12,165,100,165,242,64,175,169,192,83,66,248,159,254,174,9,42,81,166,108,238,68,125,185,191,107,68,141,170,135,115,0,69,171,221,199,186,211,188,0,240,243,100,95,165,223,205,87,9,242,59,183,217,242,236,172,89,138,92,129,221,197,155,189,17,51,177,5,97,139,179,99,45,85,115,239,45,88,133,127,162,108,203,190,122,148,133,240,26,146,241,70,87,68,127,214,158,86,46,26,197,168,99,14,249,255,142,64,209,171,139,37,98,240,186,75,186,226,7,130,205,171,202,181,23,253,230,116,104,14,25,157,25,206,35,155,89,86,248,224,176,12,0,85,245,172,232,183,127,93,32,14,54,79,28,233,96,78,45,173,75,100,82,250,252,95,113,146,241,164,76,7,153,245,165,118,17,147,206,232,235,133,55,248,170,118,143,115,195,234,2,251,162,138,136,99,57,231,156,232,16,126,111,223,190,121,166,190,73,61,49,50,17,89,11,229,114,40,130,182,121,39,58,161,248,139,153,88,127,23,220,88,208,138,209,244,118,255,213,79,165,92,29,255,103,68,22,243,53,250,145,93,176,69,1,22,22,225,167,22,211,147,150,42,52,39,235,109,30,49,136,12,191,162,252,187,53,38,137,124,82,98,97,19,131,144,130,29,102,95,240,161,72,200,230,114,100,124,11,99,133,173,251,93,213,116,177,206,80,192,21,108,108,105,27,196,134,185,200,89,203,137,170,179,100,191,55,18,188,53,230,19,151,149,95,196,137,35,229,32,124,176,94,43,191,157,166,186,204,98,145,44,161,162,45,103,124,224,128,40,124,232,13,130,148,137,225,107,15,214,117,43,100,102,135,150,243,191,223,17,161,97,78,71,198,166,50,28,133,27,26,189,79,80,35,194,58,39,102,171,123,71,126,86,21,19,202,139,242,177,107,236,157,128,231,0,253,150,199,238,75,157,109,23,255,17,78,204,139,69,67,201,183,143,45,78,179,95,33,188,207,80,143,190,213,171,50,174,48,155,4,137,42,241,134,139,126,26,244,140,230,244,158,155,28,238,204,194,40,202,24,168,102,213,242,159,205,212,30,213,42,187,6,90,77,205,107,53,77,214,248,173,91,171,211,67,83,234,136,64,238,234,238,227,32,123,1,223,114,17,149,41,13,134,22,17,45,153,199,220,6,160,24,32,60,145,163,19,85,251,27,5,63,126,173,7,235,156,14,132,31,189,247,79,78,141,82,207,15,100,145,30,250,163,209,215,251,26,169,218,247,146,4,248,53,41,176,253,126,158,21,232,220,254,54,97,115,83,218,127,146,12,61,20,11,123,15,224,62,231,240,199,33,99,226,88,2,186,239,2,60,155,167,225,168,153,236,232,12,149,43,192,180,241,67,43,9,252,234,216,10,72,83,41,225,162,129,207,75,170,161,154,45,230,173,242,185,104,140,109,222,191,164,87,199,238,193,104,185,121,173,106,142,3,125,252,100,43,104,89,150,20,52,238,229,96,174,24,38,169,92,243,215,110,175,87,52,70,35,244,30,42,161,120,129,89,236,109,101,24,178,126,252,238,176,178,62,114,242,107,224,0,131,175,40,184,73,239,159,166,176,156,31,42,79,174,217,83,232,209,140,85,213,53,100,244,122,245,119,135,155,125,86,185,242,233,232,158,119,63,9,76,94,39,235,210,92,177,13,121,61,34,168,22,255,182,40,226,69,178,182,43,145,230,112,80,74,204,182,90,93,207,238,189,173,182,248,49,71,43,85,26,230,124,231,137,152,248,195,241,193,111,196,129,42,44,69,16,161,230,132,34,25,210,17,234,43,26,38,53,111,25,106,40,123,166,151,252,38,226,73,205,112,192,24,241,126,152,174,43,124,214,163,121,85,179,82,38,116,187,192,155,113,134,197,204,85,48,83,145,14,176,92,134,79,9,132,234,180,33,74,157,193,107,162,252,196,239,161,158,210,78,76,66,234,236,112,173,122,84,59,233,130,118,24,24,20,103,120,25,150,120,30,144,210,151,252,60,44,66,24,58,188,114,46,111,40,135,99,195,201,97,244,209,53,142,208,224,77,9,78,149,189,187,132,206,89,15,153,147,24,116,117,167,77,217,88,223,140,163,91,51,237,103,185,152,153,177,89,5,60,147,20,19,68,203,44,19,41,20,60,167,98,159,0,15,215,46,242,52,178,27,24,53,28,35,111,17,143,111,15,50,21,176,42,191,28,134,216,164,146,6,15,178,22,173,136,88,58,193,235,78,146,69,178,123,76,16,250,111,85,97,38,167,102,12,68,249,248,3,186,158,82,104,179,112,3,10,48,113,82,55,171,78,202,19,213,253,123,245,6,68,106,209,173,144,186,213,93,149,191,115,174,216,184,66,103,234,249,137,245,210,134,134,67,231,146,6,52,109,143,192,212,46,42,183,169,243,41,168,62,225,160,164,171,199,247,107,61,127,91,115,95,160,125,178,194,66,122,85,182,203,180,195,156,104,123,123,114,189,230,254,100,167,130,115,118,240,115,205,173,67,130,88,197,239,102,25,43,210,133,100,244,182,118,221,233,165,202,69,234,188,11,49,97,197,35,65,20,195,251,157,112,59,6,224,15,23,74,54,148,244,232,236,122,60,27,143,17,65,70,158,165,64,55,121,71,14,194,185,34,154,185,103,211,171,7,29,34,233,64,253,251,183,68,243,192,115,105,168,197,160,216,23,226,68,108,235,231,100,15,5,43,181,60,234,225,85,11,36,82,48,33,252,36,127,44,221,26,99,5,83,54,180,95,216,171,210,188,64,241,125,57,185,99,248,183,198,221,96,22,215,212,83,87,121,234,117,9,192,58,92,66,88,111,186,137,84,83,97,223,248,206,113,163,87,65,66,87,93,247,107,225,56,216,168,44,125,63,241,83,34,211,75,49,94,170,128,119,216,64,248,234,131,125,107,140,209,48,3,109,153,216,133,125,24,90,42,244,135,39,122,163,68,15,39,224,96,235,96,15,68,183,52,4,131,79,96,24,20,225,26,143,93,231,157,4,31,157,182,44,196,78,112,170,148,217,155,59,1,10,227,49,135,74,1,221,103,68,74,60,168,176,13,205,74,210,143,39,77,43,236,51,182,246,131,233,46,203,206,150,64,37,183,94,169,228,125,48,132,22,162,46,214,159,116,123,85,147,170,167,169,102,237,251,178,41,161,106,95,145,122,185,130,63,83,199,85,246,118,221,143,174,179,208,89,74,239,247,39,44,178,196,135,202,184,253,87,29,168,79,165,164,98,10,126,228,133,146,183,173,189,125,227,104,181,194,16,181,235,233,188,38,175,25,240,182,166,116,143,222,122,24,134,215,94,221,155,13,67,143,104,100,21,183,45,24,188,179,99,21,209,92,37,93,198,3,162,185,31,95,167,90,100,255,234,147,80,68,111,71,229,211,108,116,38,43,213,115,233,115,25,138,25,132,215,19,174,103,20,12,114,86,210,166,87,3,123,9,178,128,221,129,85,115,6,16,170,143,67,41,191,110,64,146,59,144,144,18,194,116,68,172,237,230,111,7,8,12,67,14,208,200,129,45,205,232,233,242,210,28,176,29,120,212,172,147,95,44,125,107,93,62,34,161,136,95,226,85,94,8,213,65,130,106,27,55,109,27,254,37,169,91,14,231,48,227,185,3,120,63,11,110,56,34,72,244,45,20,40,56,129,161,34,28,155,2,233,254,130,92,83,107,76,68,194,27,134,104,92,101,105,69,210,167,77,141,80,192,35,110,192,127,77,249,183,186,166,21,193,115,11,53,68,198,170,120,233,102,208,125,66,15,23,96,229,104,50,38,35,48,220,50,192,237,119,49,239,225,87,183,228,135,137,60,215,160,233,170,102,66,30,255,247,137,214,19,53,109,10,207,16,151,93,37,40,142,9,95,185,223,231,23,139,182,233,83,161,167,68,50,4,191,16,12,150,166,207,188,157,177,50,119,19,59,1,74,42,249,178,51,219,116,120,72,112,57,80,94,133,200,195,0,71,225,105,243,5,220,209,207,106,213,126,81,140,75,229,190,96,197,88,153,213,174,67,91,36,241,200,158,14,207,2,65,1,156,12,162,4,212,227,207,207,213,160,187,15,123,68,63,9,179,15,105,53,153,66,168,169,172,54,216,198,4,250,190,84,103,115,253,207,240,115,111,59,9,53,184,228,196,242,15,106,3,23,163,233,35,120,116,219,230,154,118,183,24,108,147,61,87,207,172,207,250,159,2,157,182,207,171,239,151,44,44,215,78,9,6,93,231,212,128,11,124,69,149,195,82,145,247,193,113,6,198,86,71,197,178,201,101,40,144,156,209,128,4,160,141,83,17,54,232,33,148,177,195,201,11,57,110,238,153,5,202,96,19,186,73,251,129,217,82,174,147,86,161,161,80,254,97,201,245,166,229,234,206,224,228,51,77,162,181,92,245,65,136,147,22,95,191,76,233,96,118,84,64,147,51,128,50,216,18,185,80,156,79,244,173,229,77,19,228,99,73,193,245,84,178,162,159,96,196,14,115,13,87,135,197,185,2,111,71,70,108,145,15,171,72,236,45,13,113,248,234,28,252,8,25,219,89,132,196,137,90,173,30,107,85,91,5,42,152,143,56,105,83,178,199,225,252,132,64,237,189,217,160,222,100,99,108,219,158,200,68,220,133,202,59,189,107,222,131,240,170,203,153,109,218,1,67,227,156,137,144,226,93,218,170,171,186,24,246,192,59,192,178,183,159,35,149,74,168,108,117,251,150,218,60,153,74,186,173,70,252,10,252,23,207,116,6,116,45,13,180,75,61,225,249,213,119,80,107,204,83,56,59,119,146,182,1,167,49,249,235,195,234,211,126,57,68,22,44,94,29,47,59,147,205,73,49,70,196,167,73,88,168,80,224,251,235,110,112,89,159,213,73,183,222,0,77,117,10,19,199,137,18,5,205,49,98,3,12,129,254,44,43,147,71,76,196,225,248,110,84,232,108,65,151,202,9,42,153,226,233,185,11,51,224,109,170,42,174,165,9,226,43,151,39,51,89,229,14,198,66,34,198,21,84,20,91,238,46,137,128,59,247,89,68,6,203,229,14,233,14,173,2,177,77,40,9,186,34,123,3,218,138,47,238,231,35,78,207,206,41,11,13,228,117,137,212,212,72,126,150,179,22,140,250,96,227,99,76,78,39,252,16,28,114,139,25,103,52,20,103,209,232,115,1,70,132,159,190,199,141,73,241,140,239,132,152,106,65,18,45,95,213,148,242,101,185,41,17,13,220,177,98,12,163,57,155,80,98,164,91,9,18,46,237,13,71,186,81,51,46,205,191,198,85,79,189,56,43,235,179,221,46,227,185,23,134,211,223,60,72,104,45,148,151,8,137,27,71,51,115,175,191,58,143,79,114,32,211,116,192,61,42,161,16,181,178,114,121,218,50,48,163,124,255,195,76,8,36,181,109,104,182,166,146,74,208,142,125,90,53,195,182,101,151,120,175,94,61,13,156,185,232,82,15,76,149,51,248,77,119,158,190,104,175,143,140,239,69,45,190,71,191,129,249,243,239,114,254,176,77,243,92,234,67,65,96,137,63,141,182,103,186,178,113,137,180,56,72,99,187,41,190,22,177,203,198,216,232,212,19,219,179,118,7,214,222,7,154,96,146,13,4,17,159,210,63,72,11,24,139,248,111,107,34,99,167,111,111,227,76,118,225,217,16,173,227,164,82,178,164,240,196,98,253,50,63,203,60,73,41,153,159,108,141,190,143,66,225,231,229,206,193,230,136,211,18,145,160,24,212,38,129,247,136,147,80,238,167,134,45,158,64,122,161,218,136,217,46,212,76,41,160,74,214,81,27,50,123,248,154,102,194,150,104,56,63,72,11,244,77,182,99,23,183,117,231,93,41,231,66,20,209,241,64,170,96,126,115,21,6,234,21,218,148,131,7,110,245,72,248,222,43,110,196,48,122,221,208,95,53,69,90,61,39,106,231,204,138,216,26,242,230,66,233,251,171,29,24,223,101,84,219,85,22,14,43,150,64,91,45,23,82,50,0,252,10,78,98,88,45,63,53,236,74,198,46,223,238,147,16,245,238,185,39,194,31,179,20,215,102,83,157,255,227,250,126,240,36,240,137,249,160,221,194,100,195,45,253,219,55,128,198,218,127,150,191,8,247,174,152,182,146,156,238,213,42,180,19,180,209,243,255,208,231,189,158,233,81,136,105,51,8,251,84,149,205,90,109,111,25,31,7,149,167,0,167,233,53,128,23,246,163,33,232,78,160,138,62,103,129,147,231,173,4,208,235,123,167,77,208,34,91,101,222,102,54,31,241,194,101,211,228,54,79,154,68,203,193,219,227,15,51,44,255,76,192,152,133,63,181,3,200,217,12,144,133,158,160,227,196,239,38,201,91,231,243,49,120,14,224,169,120,226,64,0,136,55,55,18,53,56,204,201,151,116,42,63,3,43,83,228,203,192,25,98,131,210,8,230,39,203,211,178,74,54,193,118,23,2,175,186,252,186,75,169,128,220,6,210,136,200,30,190,156,196,255,217,91,42,94,233,128,33,168,160,69,73,128,131,25,111,86,205,37,217,157,78,45,17,253,145,176,110,216,74,168,249,130,190,191,66,13,208,51,130,200,134,236,219,85,133,221,186,203,39,214,57,6,181,94,241,98,49,5,61,194,160,167,43,103,190,43,43,216,86,102,214,144,241,242,23,125,179,110,12,11,103,88,99,236,175,153,176,191,234,86,84,248,36,72,72,30,102,75,41,254,229,172,70,24,253,82,70,197,48,82,185,2,206,118,43,206,157,87,128,230,177,65,196,248,112,88,150,18,248,138,190,75,187,227,44,9,25,118,212,94,81,188,179,133,218,209,215,135,183,100,213,213,161,73,96,68,172,190,213,205,104,251,184,176,162,100,73,37,77,60,125,125,15,254,238,80,245,234,132,166,30,229,250,98,73,230,161,23,245,76,229,157,77,104,255,77,92,217,204,200,179,36,177,30,125,152,172,204,40,100,206,156,188,21,252,227,202,68,130,25,70,150,200,128,190,193,105,22,82,154,5,40,89,185,95,154,132,134,101,98,155,163,102,33,55,175,136,4,25,92,189,211,166,178,133,87,220,97,62,148,198,1,100,177,237,71,50,248,201,18,29,174,243,222,117,65,244,70,237,117,69,69,204,182,109,113,67,182,209,158,81,188,90,212,112,58,17,12,112,175,250,218,70,155,93,24,69,100,129,33,31,201,102,138,191,99,116,0,6,238,152,70,243,213,239,68,93,154,48,64,195,54,27,11,95,184,217,67,95,12,20,30,53,142,17,30,17,88,164,124,108,207,131,53,30,133,255,246,202,206,226,106,26,105,0,157,229,220,59,106,234,188,179,236,29,0,248,80,90,90,5,64,15,63,165,108,162,113,225,44,45,67,111,40,183,90,231,95,31,52,45,50,128,5,228,182,18,117,115,142,39,71,243,50,218,148,34,23,152,198,234,123,100,119,218,37,214,37,18,73,96,254,145,186,139,18,70,72,32,252,43,113,215,195,93,246,241,88,127,247,22,149,71,141,141,120,111,250,53,244,132,237,253,93,203,72,189,170,2,138,61,227,87,109,177,250,60,4,37,24,106,194,134,132,165,83,181,174,47,69,209,215,79,99,212,75,187,67,224,213,17,198,129,174,57,83,26,176,185,228,251,231,182,72,59,67,21,251,129,106,168,165,93,46,117,63,62,153,27,141,12,62,220,93,27,63,137,158,242,74,235,192,185,99,130,174,232,19,207,49,184,117,113,90,243,49,158,10,136,251,141,128,236,44,29,173,111,214,60,247,243,51,250,84,16,116,49,164,230,194,191,152,52,250,103,103,0,223,183,37,45,88,191,46,238,200,49,89,107,114,85,73,152,57,69,253,234,112,39,9,238,229,88,124,209,122,227,206,44,58,35,176,219,213,168,129,66,58,235,133,57,154,160,135,196,69,31,9,238,132,153,191,210,37,24,21,229,238,151,113,100,182,135,98,17,90,191,199,211,70,248,56,19,199,161,142,247,148,226,46,158,77,188,218,75,135,236,227,38,67,255,37,111,81,249,68,228,56,78,50,90,195,143,133,62,156,17,215,111,211,129,186,222,201,45,173,68,177,92,162,60,121,112,160,102,65,130,81,248,0,189,160,88,84,187,195,146,57,52,13,210,119,106,215,72,79,226,108,107,221,39,240,131,105,55,241,237,37,46,157,245,110,107,77,7,150,219,61,161,139,120,115,77,188,35,97,55,105,73,35,13,191,112,82,142,108,223,215,152,246,165,217,146,144,68,29,227,13,172,218,230,219,3,145,65,228,173,193,184,216,69,207,253,74,179,221,182,123,54,102,7,88,170,77,238,55,241,248,88,107,243,214,64,237,240,199,62,104,235,205,166,241,228,96,59,249,81,143,83,148,97,70,54,174,32,74,199,116,98,192,252,106,240,99,88,239,130,172,165,63,146,96,200,12,233,159,201,210,156,74,205,166,192,1,111,134,154,214,211,30,219,109,148,169,172,94,135,18,120,1,181,237,172,238,105,12,148,250,158,123,50,11,243,110,138,35,241,191,173,36,25,151,98,59,145,3,175,73,51,75,152,36,170,63,163,101,45,119,216,75,147,62,157,36,197,73,195,129,136,104,101,23,218,128,215,162,142,185,185,253,7,6,46,172,144,255,0,236,13,192,181,102,182,93,14,204,178,253,167,78,179,97,70,151,214,5,91,99,165,82,3,75,134,9,72,80,100,176,244,17,140,38,116,190,196,52,158,120,7,213,27,105,54,164,113,198,231,51,127,70,238,152,162,163,87,209,50,241,148,148,150,125,159,175,252,106,36,180,149,170,114,243,154,63,254,5,37,142,250,43,193,194,248,91,34,184,116,192,11,82,237,12,12,115,77,63,50,194,38,46,136,191,76,116,50,212,23,191,69,168,74,185,139,213,68,42,52,218,140,177,193,68,84,39,18,75,111,255,112,201,235,200,134,203,31,158,84,155,184,200,248,129,102,19,148,94,215,107,36,40,193,5,80,87,3,9,28,125,20,202,84,1,177,13,233,154,26,185,61,8,129,62,145,10,5,145,224,121,9,242,76,29,3,6,81,112,203,246,96,231,190,52,248,158,123,117,141,26,171,155,54,156,146,65,79,240,61,204,80,226,205,5,250,239,181,135,24,180,71,92,174,94,33,217,77,135,94,107,11,168,96,56,71,79,140,32,246,236,230,116,188,208,54,230,10,221,104,94,122,245,55,18,195,183,23,113,66,34,156,242,9,206,169,230,105,147,145,139,182,193,182,157,251,138,78,20,162,30,196,135,21,182,83,249,193,59,227,194,106,124,140,128,246,181,242,219,85,116,164,241,204,169,30,132,168,200,90,207,105,130,90,239,238,112,203,22,182,25,106,65,229,94,141,195,189,149,215,143,179,46,190,31,52,208,155,207,111,119,58,200,199,216,88,251,254,233,194,185,246,106,70,102,167,253,240,102,116,149,75,246,185,83,244,23,133,137,177,41,218,156,136,42,100,29,210,69,34,86,9,19,230,7,82,220,86,177,219,233,26,66,49,223,216,153,215,35,176,103,120,25,208,79,144,64,177,218,92,22,138,126,40,94,200,167,8,216,78,118,244,180,19,69,3,97,252,115,65,82,15,78,33,224,1,96,223,41,4,136,102,109,138,111,57,20,27,236,150,34,158,116,147,160,219,238,222,248,32,127,90,181,17,247,3,231,198,96,179,93,25,227,18,70,210,136,0,132,70,90,123,192,59,2,191,117,233,116,254,139,60,48,129,174,188,254,26,254,195,216,212,17,110,249,169,70,129,247,212,151,116,226,74,138,172,140,240,24,113,237,115,116,13,147,214,116,254,145,99,77,26,12,165,104,233,32,125,158,202,125,56,96,210,253,202,211,176,118,31,49,19,100,89,176,185,56,77,151,182,107,123,161,182,180,70,64,86,132,140,86,114,141,88,3,4,103,110,9,146,66,30,60,145,120,229,50,172,143,181,168,105,114,202,102,20,151,149,77,33,66,207,84,9,50,173,56,38,255,159,91,73,25,171,40,49,38,99,236,186,122,246,117,205,187,132,4,138,75,27,64,84,247,8,47,143,83,39,125,56,182,216,44,14,116,13,114,183,159,142,83,182,102,45,103,189,75,249,221,168,245,129,179,18,126,180,92,205,227,41,159,7,201,246,108,214,21,119,176,10,127,65,110,9,90,101,89,233,250,171,202,166,78,83,86,71,99,0,117,154,81,173,91,102,228,204,14,80,110,177,148,105,55,251,174,215,62,38,144,240,172,24,63,241,61,8,134,228,119,100,120,55,166,227,140,240,81,23,77,150,109,134,250,148,228,100,192,17,91,140,73,230,77,14,210,71,188,121,142,160,37,38,94,60,214,65,78,36,225,242,200,109,78,52,71,25,211,238,6,33,248,38,221,129,195,228,54,121,32,77,92,146,198,207,130,22,142,74,125,91,203,69,231,143,185,57,121,124,4,75,117,100,10,92,117,208,195,150,40,50,135,53,194,154,236,147,235,121,118,110,201,34,59,51,175,66,73,44,208,58,43,54,138,83,78,9,214,71,72,221,132,72,246,151,22,160,195,236,194,17,47,248,254,199,31,190,84,43,208,221,178,189,22,177,196,92,69,2,82,182,233,42,104,243,239,159,80,244,14,32,104,185,123,8,101,201,45,17,236,28,246,112,32,35,45,63,244,84,245,40,48,37,141,18,202,9,244,14,217,235,242,217,129,167,156,228,210,212,103,109,35,246,126,195,85,114,169,18,15,140,39,108,205,112,84,31,165,144,157,45,212,171,42,167,202,161,123,247,253,174,120,253,60,26,231,162,70,62,30,243,109,209,38,198,24,88,121,114,7,91,14,40,116,90,138,116,164,213,184,139,121,97,12,156,233,170,76,191,52,52,224,164,19,192,67,142,108,178,205,149,101,13,160,203,122,164,164,110,125,95,127,147,7,52,43,65,96,84,219,251,96,2,239,135,32,91,235,249,66,5,192,95,144,66,187,225,118,5,138,193,157,218,143,252,29,193,31,166,254,42,185,250,77,10,112,49,209,113,164,85,64,254,114,251,108,218,116,250,210,127,198,136,63,224,57,141,66,61,40,204,167,73,18,150,226,144,157,147,42,143,252,244,23,233,61,195,199,141,117,31,95,18,240,250,172,37,113,91,84,52,220,171,226,167,191,191,203,129,151,3,125,190,82,199,254,189,160,16,255,82,164,118,251,233,141,4,229,92,85,111,206,149,121,5,145,50,183,179,152,217,93,195,156,136,205,193,119,41,59,21,254,92,107,194,85,41,18,36,237,149,64,55,21,19,167,119,100,218,133,28,143,181,9,173,122,61,65,27,156,179,226,5,116,135,107,177,157,68,135,181,17,136,102,154,85,77,245,163,56,70,157,72,103,67,174,184,207,220,69,86,234,134,248,100,42,86,252,245,127,129,187,73,121,228,198,189,49,245,195,56,170,243,58,76,139,188,216,175,109,77,154,19,221,245,95,191,144,194,144,39,208,223,238,214,243,164,151,5,226,31,232,128,244,16,225,255,28,228,0,171,6,183,158,190,12,226,218,86,242,183,236,26,76,69,198,142,5,231,144,53,168,250,115,152,3,144,214,197,86,67,149,238,155,110,209,247,184,84,14,72,215,21,193,179,135,167,134,253,43,228,120,248,74,129,99,222,245,21,89,49,67,163,229,120,68,15,215,75,209,41,166,121,134,194,254,2,203,144,0,195,73,17,209,27,20,222,162,209,151,31,14,51,232,33,114,76,250,227,86,214,43,60,64,21,148,8,45,168,157,200,106,42,247,141,10,165,234,228,76,81,60,39,228,231,157,41,94,94,11,57,245,217,241,237,74,210,29,205,164,217,83,24,107,184,12,45,107,219,204,214,161,43,61,188,79,77,251,6,9,248,49,4,118,23,146,2,136,170,7,140,101,243,101,166,76,202,200,246,102,191,167,181,185,10,219,229,98,255,116,184,219,5,68,243,3,145,141,91,232,19,53,123,183,172,71,77,202,108,80,26,208,52,21,123,204,166,204,110,4,135,74,23,212,183,241,25,160,63,158,3,87,50,109,4,19,158,125,10,189,194,250,174,59,150,4,101,133,94,141,39,154,51,90,48,98,104,195,24,24,128,41,232,193,84,199,93,94,48,48,252,141,111,80,96,3,84,24,28,149,127,28,54,236,143,91,107,27,207,175,125,239,4,52,121,96,74,125,70,194,9,82,76,26,41,99,103,198,63,166,70,49,54,83,232,155,141,227,167,99,68,137,215,130,191,179,181,201,253,144,194,181,14,186,100,114,83,100,113,87,233,47,40,202,131,228,22,198,225,35,15,3,24,69,102,225,250,43,81,61,108,20,156,183,10,3,60,240,42,94,151,224,200,26,50,129,38,85,34,110,50,212,143,0,192,121,67,190,1,166,173,65,41,194,135,195,155,178,176,94,126,100,157,117,138,184,59,90,86,185,46,20,64,147,48,128,65,174,6,45,228,70,230,184,1,103,177,102,240,81,1,252,215,2,226,87,253,150,208,102,43,46,64,106,231,84,122,54,201,46,206,92,12,66,117,152,212,224,209,62,254,120,140,254,119,252,240,43,207,130,207,216,13,101,50,211,98,241,178,60,240,31,147,158,120,40,103,194,116,128,21,36,114,66,48,157,73,78,28,42,95,53,21,133,162,105,234,95,2,201,148,135,25,126,38,46,109,1,28,108,42,121,29,242,23,127,26,206,237,171,204,196,101,11,174,27,141,230,245,0,199,120,231,72,223,111,112,13,243,93,186,53,148,191,234,87,47,212,138,202,92,125,173,84,110,164,59,234,194,76,159,169,66,212,124,201,197,112,253,143,68,8,101,69,49,139,210,44,111,252,224,106,11,193,247,135,111,252,162,46,21,78,55,196,27,64,63,13,93,224,39,214,249,119,176,203,171,241,26,206,144,30,0,94,60,58,83,28,147,20,36,33,48,129,16,239,78,51,75,134,37,163,191,183,189,119,6,114,234,219,28,112,245,105,221,96,236,226,89,135,108,102,124,96,72,160,95,156,95,70,118,118,26,188,140,106,55,249,221,84,155,251,210,98,4,204,166,71,140,255,183,205,197,48,201,231,88,68,238,241,150,15,212,121,71,107,144,11,103,205,193,144,127,157,0,115,100,215,34,36,243,248,95,184,190,46,114,91,248,159,168,164,20,179,216,100,18,17,209,55,110,166,51,209,133,18,187,44,86,29,146,217,155,25,166,214,222,176,38,197,159,40,205,76,136,66,229,13,13,154,212,229,215,17,253,200,151,47,193,70,90,244,196,105,4,2,94,25,4,19,22,24,15,60,115,151,90,193,57,111,33,240,174,180,206,214,85,42,8,39,221,253,144,13,46,108,246,120,129,184,233,26,32,169,223,122,193,35,110,92,50,184,220,162,85,18,188,187,171,37,222,215,86,42,169,8,5,219,47,237,22,34,28,112,63,244,190,223,45,81,82,194,58,52,162,122,35,77,250,71,166,140,22,223,79,154,104,206,179,80,209,233,129,90,115,51,242,217,238,237,248,82,89,190,108,24,175,226,131,101,235,176,208,149,185,57,85,75,3,175,206,236,208,3,103,162,4,147,186,4,102,223,86,15,155,55,179,252,216,222,115,15,29,163,193,222,199,217,3,10,55,198,168,0,92,193,134,39,130,72,80,67,200,123,49,192,144,165,152,223,72,41,236,108,234,102,149,172,148,78,111,124,205,237,164,167,166,126,173,237,179,129,40,172,79,222,242,200,252,143,125,198,168,163,75,122,153,99,216,130,171,186,0,166,29,114,221,8,37,179,65,2,243,250,23,160,186,224,8,65,242,141,228,169,121,212,77,73,212,197,245,233,50,249,49,135,19,110,8,10,206,19,0,223,8,86,167,207,207,12,242,221,35,8,203,141,245,223,157,221,128,9,190,46,55,29,37,165,220,72,168,128,216,57,59,194,134,223,126,135,189,19,18,233,69,209,92,218,96,123,157,34,51,229,156,187,210,139,148,7,52,208,198,244,123,245,118,3,28,65,15,205,76,146,117,48,104,90,248,196,10,170,38,10,125,15,157,206,238,173,130,175,19,244,70,75,1,151,86,146,1,239,47,185,94,35,26,198,225,253,179,67,64,38,100,184,17,206,76,106,85,62,74,83,195,82,59,230,194,22,221,173,51,30,34,6,60,86,181,100,62,206,23,23,42,33,113,18,99,243,166,145,182,39,9,2,89,228,15,144,53,15,37,80,229,123,150,214,253,117,160,97,9,85,181,213,195,27,106,224,3,117,155,150,147,17,241,25,160,177,120,227,186,199,10,150,48,201,95,101,86,87,14,131,178,24,85,182,201,230,21,134,56,103,101,207,254,100,180,154,149,75,62,205,27,178,226,222,130,29,21,83,152,98,240,145,17,79,53,110,172,76,161,140,185,171,56,113,206,136,53,129,152,43,19,15,88,160,31,199,128,235,95,45,36,77,134,252,74,27,34,152,66,209,233,251,104,134,187,178,249,69,121,114,27,168,108,24,29,161,239,174,46,132,247,128,64,8,224,81,32,233,139,208,27,81,106,161,6,144,98,119,254,235,122,137,1,88,104,36,92,43,116,91,197,151,112,111,234,251,46,156,65,52,74,151,244,237,215,154,110,36,77,147,120,42,221,128,8,253,165,149,74,138,156,32,239,21,173,223,53,107,79,235,237,100,252,172,58,210,92,111,5,237,71,162,216,169,22,60,233,122,94,174,241,65,24,70,147,243,63,14,95,71,44,43,204,91,57,212,67,81,38,219,92,86,224,105,207,78,228,102,161,81,146,152,126,197,231,76,188,202,250,150,218,178,43,57,100,251,0,133,14,38,4,211,252,140,170,41,109,38,134,240,241,16,69,170,171,4,155,173,198,17,107,212,107,84,34,236,136,117,0,154,229,81,82,5,97,204,14,148,117,229,21,129,137,60,4,192,235,237,174,63,125,214,97,210,106,88,35,40,240,55,108,166,102,106,61,14,110,126,219,104,197,103,207,23,249,126,56,205,130,74,205,10,31,211,23,116,250,79,108,217,86,0,147,10,105,106,229,22,194,172,72,168,173,102,134,228,236,27,11,52,83,182,163,66,12,167,65,48,215,73,53,103,194,194,54,83,217,203,46,58,52,243,118,203,36,219,220,44,81,174,91,3,35,98,226,89,208,6,238,9,1,22,141,186,125,118,68,90,32,122,160,42,203,88,195,106,62,14,174,201,214,237,169,124,39,35,69,38,158,35,88,212,26,118,117,127,39,246,206,228,121,149,194,64,139,187,29,110,254,246,247,154,164,183,136,182,30,7,87,199,125,111,167,101,221,183,97,243,110,125,123,24,43,140,150,185,48,203,83,29,25,33,173,145,168,163,237,225,233,32,217,246,208,97,219,164,125,81,212,125,83,235,164,226,114,245,24,14,80,11,86,64,82,133,22,139,181,4,76,39,172,167,87,76,153,90,219,214,76,130,173,140,21,179,43,187,117,84,61,55,55,217,131,88,142,76,47,156,216,153,187,210,64,19,51,132,91,55,220,161,40,146,218,180,89,37,196,45,105,136,54,127,71,190,196,132,224,178,41,68,79,64,206,39,70,53,58,24,40,91,138,237,180,19,165,34,35,229,139,164,43,245,192,14,222,214,150,47,78,56,204,43,222,235,168,196,235,125,225,38,54,43,117,141,118,170,63,215,242,217,94,12,194,46,16,35,185,129,38,220,12,87,172,63,90,79,232,208,206,231,188,58,140,224,194,246,174,185,47,198,127,21,207,228,165,217,83,101,76,34,173,164,163,163,39,172,228,68,252,153,4,205,149,69,92,34,242,234,88,211,131,105,223,184,64,19,148,196,109,163,222,105,162,145,28,46,74,173,247,40,161,104,157,41,87,25,34,4,157,37,79,199,102,2,45,56,142,33,215,74,243,206,112,83,205,224,172,165,49,45,146,171,75,199,35,218,64,10,140,238,30,209,45,13,161,228,147,133,27,3,230,95,66,88,106,239,103,107,149,8,183,84,147,10,26,243,202,5,210,237,228,45,120,187,192,91,86,236,243,128,197,116,184,23,89,199,225,203,208,131,225,69,159,97,165,218,215,12,10,46,211,35,238,9,141,170,178,232,91,82,219,129,208,80,186,25,158,53,180,30,3,34,139,89,158,152,60,84,252,69,74,106,35,135,152,15,137,157,255,226,1,249,35,223,27,131,224,122,45,255,147,45,64,193,55,253,62,189,229,55,76,101,24,138,171,45,248,208,117,16,17,122,10,138,131,192,210,22,59,119,20,165,241,54,227,103,233,7,219,200,117,97,220,42,119,243,218,163,33,158,214,133,79,4,164,150,60,71,35,113,226,20,142,208,20,8,205,150,93,120,167,188,44,51,88,82,89,182,174,1,168,105,193,186,119,139,179,197,195,125,210,135,189,187,243,191,154,253,48,146,209,195,109,153,131,97,101,99,69,105,67,151,87,60,47,255,220,177,160,117,182,42,146,134,74,89,225,152,30,210,25,133,164,112,253,191,16,36,231,132,62,63,121,91,31,43,140,41,4,54,27,215,126,111,22,6,225,225,254,221,114,91,96,236,153,233,100,202,78,214,75,229,150,27,102,198,12,46,83,151,84,33,85,199,177,32,103,168,25,85,95,0,244,72,105,194,62,8,185,2,221,179,168,78,210,254,234,142,209,27,42,252,195,240,157,214,80,96,88,71,141,77,58,219,172,162,143,55,61,135,174,107,40,235,114,38,48,93,29,74,129,224,105,169,7,70,50,69,190,67,13,226,241,88,65,249,45,175,184,240,249,180,237,69,13,232,185,148,9,71,239,174,8,247,122,118,70,133,150,133,41,221,118,76,44,236,51,49,119,124,148,75,31,23,19,168,51,90,86,111,170,13,36,36,85,76,77,143,42,228,204,41,97,124,176,32,226,36,109,159,53,231,170,102,215,229,88,5,238,149,65,169,171,215,252,188,165,44,182,39,157,172,123,129,187,135,68,188,51,50,249,62,199,253,76,80,88,87,251,193,43,113,109,8,225,134,46,30,141,86,99,163,178,102,230,241,40,106,153,29,218,175,45,223,120,149,246,140,53,83,197,204,116,164,34,158,59,102,243,244,142,207,194,209,56,83,5,20,97,70,5,250,241,12,58,78,66,235,7,146,128,176,246,34,158,203,140,155,188,111,77,234,198,197,87,162,115,12,131,237,205,80,13,38,99,116,73,140,88,93,56,127,60,123,15,129,165,45,4,196,139,24,115,32,57,91,3,164,195,19,27,91,208,233,198,196,111,146,160,103,201,248,110,38,79,109,160,50,14,82,63,167,160,205,209,235,183,130,65,125,60,66,121,221,6,121,218,162,141,67,202,4,250,202,217,209,88,120,146,209,229,76,50,86,34,119,174,14,49,47,121,80,126,87,83,80,214,166,151,71,156,192,111,209,154,97,139,223,43,147,221,198,175,187,85,141,8,121,53,137,112,118,135,83,28,118,189,73,23,7,208,156,17,198,165,3,207,70,196,102,235,124,48,197,175,236,135,84,250,4,58,216,149,60,190,56,42,127,200,203,187,174,236,153,135,29,22,122,13,180,172,245,202,1,50,90,10,156,154,174,15,119,232,121,104,134,110,202,14,1,228,76,117,240,75,39,55,167,76,160,29,119,87,56,43,227,167,202,206,224,16,215,184,41,109,101,107,56,140,88,62,245,241,193,232,223,218,143,192,225,50,227,236,74,148,96,76,236,92,17,99,203,52,242,167,243,71,52,4,31,64,202,93,229,87,95,2,131,86,148,66,174,49,119,30,64,145,3,237,228,55,154,87,40,192,30,62,111,181,148,104,63,206,15,67,103,223,140,67,45,209,11,237,124,63,73,179,8,149,51,207,89,240,70,159,253,90,198,231,99,89,3,32,8,96,185,71,203,122,70,116,29,137,14,26,251,102,181,44,68,133,97,46,159,22,35,195,216,132,196,124,81,218,62,239,235,213,66,77,123,179,249,243,221,202,10,151,176,239,43,203,212,240,186,135,165,204,55,96,25,121,218,72,237,54,40,62,242,126,82,236,107,37,224,115,105,225,94,229,138,140,134,88,237,10,251,242,150,136,143,244,160,247,168,128,145,246,145,86,182,247,222,198,54,70,111,87,107,45,149,55,222,147,12,42,160,82,162,168,38,18,18,6,236,189,253,22,11,190,234,64,175,165,7,171,107,184,28,18,57,165,103,182,81,48,228,107,71,199,34,65,71,233,34,47,1,249,32,240,10,76,57,169,210,189,32,217,27,107,121,110,81,163,0,202,76,80,14,16,13,116,43,178,39,110,83,171,201,9,7,175,2,168,243,192,210,218,245,93,81,211,221,168,71,200,228,94,175,250,94,166,82,209,203,220,202,14,117,172,46,225,72,206,77,247,80,176,237,130,209,46,9,116,96,198,132,238,165,151,230,47,160,237,21,56,131,180,218,59,248,165,177,251,209,192,31,8,112,2,22,251,188,110,118,57,155,177,192,219,17,48,98,250,183,196,107,99,9,59,125,130,27,162,36,72,249,193,122,29,0,242,171,83,225,180,70,169,130,178,220,222,236,117,125,191,218,89,166,26,21,29,148,120,212,31,96,9,57,169,153,15,229,14,137,218,40,172,145,148,17,158,5,194,194,173,247,68,233,16,78,27,242,172,25,71,154,229,21,218,133,81,84,138,168,255,101,106,133,152,191,57,32,171,26,163,166,174,167,239,84,65,172,202,156,91,111,100,188,79,107,68,117,92,109,59,211,80,37,187,52,167,28,73,252,28,207,6,148,64,223,119,88,90,59,252,142,210,201,70,72,100,253,21,202,0,122,95,48,119,125,182,52,10,32,212,255,114,254,129,195,26,125,197,16,114,70,139,119,242,194,121,136,17,44,207,48,96,19,42,217,107,97,128,204,203,39,17,234,181,65,74,220,17,84,29,14,192,163,183,199,19,85,221,112,83,8,63,111,215,57,34,106,246,9,25,50,146,235,75,105,211,107,107,187,43,188,49,209,107,21,140,107,96,150,187,159,240,15,102,65,255,101,188,157,117,100,104,167,32,123,147,131,87,122,183,139,206,208,83,78,127,165,149,157,202,175,27,120,113,123,81,255,198,188,250,137,8,165,205,151,74,60,163,245,9,1,166,125,103,87,41,195,31,3,81,119,57,207,22,11,245,65,71,94,252,77,221,191,197,74,96,171,153,207,96,190,224,67,238,149,192,48,107,134,25,229,218,10,243,208,103,211,43,49,69,8,215,38,89,219,12,194,122,22,219,38,242,233,17,43,235,237,158,111,43,43,148,187,91,70,75,154,237,223,25,22,59,229,136,116,5,231,228,3,131,153,128,75,250,245,213,107,211,138,96,160,112,236,27,26,225,130,39,101,86,207,83,20,86,40,17,83,73,234,174,25,217,148,252,9,153,62,115,30,238,125,31,13,221,76,106,129,5,6,104,81,112,31,159,195,183,156,244,190,76,213,208,148,26,165,89,194,228,121,219,195,206,154,149,7,5,198,47,182,179,177,115,1,149,6,50,190,41,168,231,44,2,170,200,184,0,167,33,52,255,153,13,231,123,176,175,178,230,7,151,67,15,15,121,211,239,140,232,88,18,38,192,225,240,193,169,133,111,206,167,110,221,226,13,134,138,195,81,89,65,18,115,65,137,108,246,114,244,9,70,60,246,76,166,82,56,23,15,30,249,193,176,192,45,36,11,27,223,172,61,2,28,98,206,185,157,192,195,13,95,64,96,133,162,82,71,95,21,52,141,230,175,228,247,141,19,254,182,35,219,233,221,196,63,98,0,228,136,37,209,64,212,4,144,252,145,164,144,73,68,230,68,88,20,60,189,252,177,77,71,238,151,223,208,111,19,124,89,238,195,119,229,116,63,2,211,71,122,180,239,107,50,35,191,16,236,175,251,114,159,185,45,23,56,150,192,17,54,117,103,174,110,19,231,235,219,165,64,128,25,55,14,47,90,250,207,157,121,184,27,36,16,205,186,255,125,235,239,229,233,19,90,10,122,132,147,71,33,222,132,0,92,203,152,83,59,166,177,193,7,230,79,20,63,134,188,229,254,126,147,108,172,94,187,244,224,206,129,161,169,177,85,62,223,32,247,241,238,28,62,11,186,97,204,97,207,139,241,179,187,59,13,15,181,201,226,184,150,78,63,96,216,10,170,236,82,165,95,254,226,48,54,226,113,47,155,240,252,164,46,125,137,196,194,245,122,132,40,12,90,223,108,213,79,226,82,204,152,142,20,87,88,216,33,142,219,10,240,252,205,231,113,138,130,183,188,240,174,49,240,25,161,19,158,174,215,21,45,214,183,239,227,227,125,209,204,247,10,185,29,26,157,14,16,143,93,6,233,3,152,50,14,23,43,35,76,230,67,12,252,87,73,252,77,156,144,177,93,38,232,214,52,240,191,72,85,217,93,212,6,139,106,169,110,204,75,14,4,82,131,173,41,14,175,142,68,84,35,102,135,162,29,143,231,236,88,121,188,207,239,170,226,194,177,83,144,120,59,118,191,252,76,19,42,52,192,168,144,162,120,160,214,110,233,81,195,202,250,50,150,222,154,240,213,202,153,77,16,229,204,177,215,93,94,218,198,66,55,161,96,21,121,219,231,234,122,156,62,44,145,209,202,225,198,163,6,42,7,241,172,27,184,89,197,36,155,217,182,20,132,189,2,74,130,18,244,163,127,115,254,198,112,10,194,13,65,85,132,209,158,147,244,208,48,1,14,31,191,192,181,219,17,226,99,252,11,57,151,17,51,68,249,78,158,91,0,216,55,170,99,59,62,172,5,103,76,181,115,210,237,16,139,102,90,2,201,29,89,153,41,196,56,148,143,171,72,5,72,195,24,154,180,107,150,143,241,192,192,25,212,114,112,218,204,140,198,28,191,151,22,41,159,96,199,1,199,133,71,216,26,26,188,43,44,32,232,203,41,29,207,237,250,67,163,160,11,87,104,238,195,117,150,122,90,29,83,106,212,17,160,121,121,105,102,148,76,26,208,118,76,69,198,140,74,111,228,21,33,160,88,160,76,173,109,238,91,61,212,147,86,31,226,221,83,218,13,160,18,16,41,225,79,41,118,24,14,65,34,191,211,245,55,100,128,179,248,35,92,144,48,33,211,35,101,190,233,252,177,205,242,167,201,161,100,115,150,16,13,182,205,122,71,94,25,151,192,39,50,75,85,232,180,81,42,74,23,214,95,157,205,35,20,175,170,53,217,85,195,48,205,10,57,109,105,231,58,225,58,170,58,245,81,58,25,17,136,31,43,216,147,234,184,17,172,191,163,67,221,95,64,41,182,80,112,160,236,200,85,226,234,135,183,14,240,100,213,181,31,46,30,182,190,127,115,236,16,108,30,180,149,97,184,175,27,170,43,215,209,13,141,1,219,106,44,162,197,132,75,151,62,34,177,71,6,2,183,150,104,13,30,216,229,91,227,30,5,0,79,44,251,250,17,58,87,199,227,131,57,225,224,239,101,191,17,247,197,153,215,69,30,70,189,253,235,158,247,173,232,108,16,47,60,117,79,212,92,177,202,20,40,236,246,194,37,183,102,43,32,30,171,136,164,104,89,8,149,18,20,34,177,137,35,254,198,186,142,169,208,191,129,173,45,24,144,147,62,39,15,242,131,25,103,230,19,85,237,1,20,88,253,160,140,26,84,112,9,176,41,62,11,210,255,214,239,48,9,176,224,3,139,214,220,100,146,141,230,128,191,4,170,155,163,62,236,93,2,209,97,49,131,87,74,138,171,29,60,152,116,130,69,189,225,206,8,71,9,166,42,155,29,87,209,170,198,176,52,41,140,222,21,172,171,141,241,129,60,128,203,76,21,86,101,134,89,52,143,183,58,5,73,41,40,126,60,20,58,22,146,202,44,144,205,232,178,97,54,12,14,102,29,91,127,246,177,3,66,106,51,218,165,221,176,204,158,176,90,255,137,214,76,211,163,230,250,242,88,196,233,72,234,236,206,196,25,157,180,242,120,79,27,154,3,54,221,130,252,127,28,48,176,72,174,68,206,120,121,35,244,122,173,41,7,37,188,157,180,214,97,196,47,4,181,189,153,56,105,222,232,216,96,245,157,94,110,90,206,227,101,107,143,234,226,122,80,227,204,229,4,64,68,216,177,230,225,115,210,201,217,92,169,197,221,233,186,68,7,31,131,206,238,202,200,206,69,206,47,141,180,148,240,214,92,27,57,134,147,40,24,153,220,3,252,113,81,43,42,67,222,9,24,156,82,197,104,233,43,42,219,28,33,147,17,54,159,120,31,121,105,237,201,116,195,106,241,127,75,247,222,242,158,225,52,45,50,98,14,31,194,245,207,22,50,96,235,221,135,150,195,70,152,95,251,178,69,231,201,23,154,193,230,111,194,89,241,125,160,46,191,177,18,23,185,131,92,152,190,90,109,35,167,160,250,108,66,201,220,124,8,162,88,42,71,85,144,63,118,5,145,10,72,175,148,255,126,146,45,204,64,239,106,113,154,248,252,170,190,162,200,246,230,244,55,172,157,119,126,194,91,236,118,168,219,108,127,196,72,227,131,93,154,100,156,211,92,232,167,141,189,16,25,74,212,211,126,220,163,151,86,146,159,199,250,143,137,30,122,208,109,104,110,192,189,189,64,157,234,36,10,15,116,34,91,135,192,2,195,253,35,33,14,130,131,162,240,70,58,163,109,2,221,166,191,148,38,133,201,152,176,254,143,213,59,106,224,248,45,173,28,1,219,173,150,62,194,29,211,82,32,202,174,236,10,173,187,99,184,200,159,106,28,16,109,19,72,182,253,199,15,92,190,234,247,249,94,237,124,167,151,187,241,147,231,188,70,171,224,122,227,252,221,38,250,7,51,46,213,251,196,118,181,188,181,219,161,188,244,60,150,82,54,116,150,44,164,217,15,185,199,237,85,166,16,32,10,184,227,245,219,171,223,148,29,186,203,25,126,21,162,147,141,224,164,182,143,216,218,131,133,66,26,165,65,126,235,128,45,25,160,9,112,102,240,14,176,106,75,87,94,60,170,183,160,5,141,25,63,68,218,85,129,165,134,158,10,138,14,214,167,131,136,35,63,165,220,50,165,163,56,1,77,123,164,78,52,25,18,97,126,97,51,132,237,53,136,85,105,250,136,121,145,132,29,253,143,211,64,182,157,144,211,24,2,9,7,117,41,95,175,238,52,26,21,157,156,127,164,72,135,86,232,40,143,135,145,153,233,208,222,185,13,156,0,99,141,80,125,75,234,192,22,108,156,7,9,204,9,95,169,65,246,52,82,99,168,78,134,74,110,83,37,186,159,49,92,246,17,30,87,2,122,27,13,232,64,112,200,7,206,55,22,146,227,164,57,4,195,232,212,227,121,112,82,91,23,121,166,129,233,221,118,77,189,119,148,148,122,160,116,255,243,61,116,86,112,194,215,152,36,145,127,220,191,119,195,64,98,34,155,85,156,180,49,241,202,84,32,137,48,102,203,194,205,90,17,143,34,78,205,164,28,92,53,157,186,125,102,159,45,14,199,34,186,50,11,12,72,34,201,242,157,80,88,128,34,45,255,238,143,73,134,23,157,44,223,38,125,44,197,134,138,33,229,39,95,48,38,151,123,146,238,31,229,231,215,70,134,216,171,192,238,167,17,95,127,37,242,249,109,194,22,187,238,3,237,94,178,145,110,8,226,128,210,126,233,26,121,140,46,139,145,142,108,146,80,126,19,127,11,132,21,166,59,244,7,247,232,149,23,213,174,216,19,169,249,233,18,229,171,165,48,210,192,200,45,98,67,218,52,197,84,121,109,23,227,34,74,63,2,32,208,0,249,150,238,198,47,249,249,151,128,203,29,217,20,37,238,113,125,137,21,132,0,20,255,37,141,134,121,174,17,55,157,70,122,170,87,249,146,115,131,191,215,157,156,223,196,125,98,88,208,155,39,242,163,187,110,144,112,135,44,36,28,125,117,158,230,208,84,110,59,94,212,158,99,154,246,243,39,193,207,127,48,62,198,6,129,54,37,4,193,141,244,55,205,58,31,135,248,12,57,241,100,146,44,26,125,0,81,206,62,20,244,96,10,131,14,158,61,19,216,177,242,34,221,32,204,8,150,253,9,68,130,54,32,62,108,9,103,82,122,113,124,73,60,213,49,71,89,242,15,51,119,37,51,173,1,243,216,84,38,31,103,49,26,27,159,89,177,182,112,8,220,5,180,188,238,126,166,171,71,155,225,181,123,241,32,20,144,175,243,22,85,192,174,216,205,152,73,173,233,195,78,65,190,96,119,25,91,140,211,234,111,183,112,43,85,154,27,186,129,146,103,58,185,78,28,87,49,71,9,68,234,87,73,72,210,217,207,152,144,227,216,134,166,241,203,181,59,177,41,137,253,176,206,147,96,236,107,211,252,138,190,96,30,250,132,104,167,21,169,116,138,255,251,104,7,81,251,118,224,68,48,19,15,25,237,104,147,74,22,1,153,97,229,95,219,168,157,13,42,32,157,104,8,181,139,211,55,56,186,138,43,167,135,229,139,20,6,120,3,0,145,31,236,146,127,171,156,35,220,223,154,180,166,80,127,65,108,213,47,149,172,95,77,225,217,194,206,17,23,111,48,149,45,73,180,11,59,180,247,248,200,56,204,124,243,117,253,120,13,79,0,56,158,81,201,127,25,141,37,96,159,240,22,127,78,30,121,238,107,198,212,17,248,18,217,1,9,134,176,17,21,234,32,136,84,212,214,17,82,248,201,46,20,101,103,84,83,47,156,223,181,7,98,194,27,109,153,245,185,173,64,151,146,250,138,188,74,58,42,247,110,233,103,222,55,58,191,241,203,61,224,134,177,15,127,140,127,199,3,116,7,244,249,59,31,88,47,196,115,4,245,165,15,92,219,221,76,16,31,196,10,154,0,111,70,54,28,16,69,131,30,166,165,34,180,12,158,219,235,17,25,15,161,49,166,36,206,47,199,144,164,46,189,143,221,166,201,151,93,37,127,130,154,185,137,201,93,104,216,25,61,214,138,54,137,83,51,180,87,134,14,3,129,172,176,92,56,135,164,212,74,195,74,127,63,10,250,41,69,141,144,66,42,71,2,236,223,194,211,120,29,104,11,230,76,70,193,193,109,65,112,75,119,147,92,198,63,101,191,40,247,151,251,102,74,106,150,152,25,198,248,172,50,94,130,244,165,169,54,225,173,153,175,245,143,36,145,213,177,66,220,255,60,183,188,83,142,56,202,103,63,129,57,144,65,166,239,82,51,8,190,223,71,228,131,106,176,133,23,199,161,88,215,79,188,47,35,89,101,76,50,48,151,223,151,70,177,66,64,82,107,104,228,121,44,215,187,245,61,214,240,236,31,249,182,49,49,186,100,173,167,189,107,230,153,35,134,216,13,176,69,120,31,241,135,144,5,222,139,248,254,83,100,169,209,45,14,72,136,122,40,32,15,46,162,197,138,127,25,48,11,225,186,75,25,166,128,167,131,212,9,230,140,235,171,121,58,212,34,109,200,156,110,51,93,150,180,98,232,13,17,163,60,80,136,105,188,254,98,45,36,78,227,27,198,80,144,111,28,91,202,110,85,18,149,6,163,219,96,48,2,229,175,174,142,46,125,77,103,31,39,16,164,23,28,73,69,175,54,153,45,217,207,188,171,73,12,6,171,117,129,116,226,58,63,93,166,252,120,226,50,219,204,236,8,205,198,182,9,29,248,254,40,148,75,143,59,171,227,238,45,158,107,182,79,144,248,247,28,44,186,57,111,162,179,62,22,154,88,130,188,176,172,241,87,43,254,148,63,49,159,200,152,37,220,43,198,127,143,167,105,100,65,137,188,49,83,165,53,95,146,167,66,131,235,172,120,203,74,223,131,3,119,128,178,121,220,158,125,60,107,64,81,252,45,31,107,147,14,105,244,108,167,186,83,142,225,191,95,235,172,142,172,177,8,184,35,203,150,43,37,61,213,163,255,149,224,110,107,215,173,218,103,217,85,157,96,228,58,25,55,186,132,46,48,145,241,130,66,132,167,33,142,11,238,247,74,183,171,143,11,46,36,203,58,124,76,11,161,198,127,108,184,70,80,213,85,239,157,58,55,232,200,14,242,227,143,58,99,160,167,173,154,10,33,137,45,185,104,250,187,197,117,163,23,254,254,101,70,115,63,43,9,251,65,52,246,38,196,102,53,222,94,103,109,97,123,53,54,175,119,254,144,35,119,241,191,229,166,20,157,217,116,34,49,184,122,242,151,174,186,50,230,40,205,63,38,22,214,208,221,144,126,139,39,87,212,34,225,49,126,148,234,10,205,69,253,19,103,123,119,160,47,115,28,41,237,102,172,113,61,112,128,90,41,233,188,101,33,179,91,114,111,200,138,243,32,188,241,25,53,193,93,231,198,178,235,60,55,31,155,164,13,186,126,59,5,249,211,128,117,180,29,126,82,233,218,135,90,64,195,254,40,89,126,198,161,175,114,161,219,50,161,178,91,50,95,67,61,69,58,141,124,26,37,25,22,32,245,217,248,215,69,2,41,23,122,2,214,187,97,24,70,106,91,76,213,104,208,40,13,11,93,199,254,169,109,77,114,49,154,205,221,77,217,186,165,56,89,37,144,123,136,152,172,38,166,179,159,224,14,99,20,105,160,66,148,192,7,116,247,102,34,190,212,208,24,232,119,73,174,168,160,97,4,169,242,57,162,161,147,199,246,151,144,0,176,218,27,35,103,12,141,232,86,238,153,113,2,115,226,163,50,83,223,0,2,63,225,57,139,233,41,14,140,106,222,241,146,193,206,238,44,255,199,31,233,52,57,83,201,22,36,27,204,26,110,83,121,109,142,194,158,34,91,82,22,138,160,189,145,151,75,232,56,188,170,235,176,217,222,241,13,203,145,25,180,44,68,212,17,200,188,83,149,188,20,235,173,108,196,15,12,204,177,212,201,36,43,25,10,230,160,44,53,175,80,220,28,22,62,227,124,26,52,231,1,196,245,182,186,219,112,197,178,165,251,176,210,40,132,167,133,132,76,32,202,35,173,128,253,251,50,60,65,35,52,247,179,235,15,78,71,4,187,237,43,39,174,70,41,131,67,39,39,252,12,45,40,214,112,90,181,242,235,133,67,58,249,59,108,222,33,57,95,250,131,169,201,198,117,164,66,145,129,127,215,141,160,74,62,126,44,135,168,163,184,44,83,199,208,5,14,183,3,42,243,169,186,76,244,224,179,203,145,187,135,106,126,226,159,218,161,186,18,179,230,142,233,132,72,180,57,141,66,23,144,26,155,234,92,207,9,87,176,235,6,255,246,197,73,169,73,47,121,226,142,143,146,174,117,22,111,184,172,139,101,31,235,177,241,78,211,63,59,222,71,102,20,221,111,205,70,193,102,210,1,29,178,204,134,198,237,112,115,48,61,119,76,65,252,93,12,1,45,113,106,39,197,181,61,143,134,229,114,75,200,43,102,36,206,15,34,14,20,248,141,185,234,43,175,57,135,216,145,155,232,253,7,190,127,79,166,79,247,15,205,188,217,202,145,231,253,79,210,41,161,74,120,182,206,171,206,50,174,91,186,6,106,230,209,95,232,139,117,65,249,125,207,1,207,125,124,100,55,101,140,143,238,50,33,148,88,131,211,155,152,44,30,165,91,159,199,44,33,252,54,132,250,90,204,48,137,95,21,37,253,154,46,183,198,209,151,16,233,239,10,26,92,171,146,118,29,105,23,125,123,230,186,247,136,44,133,116,59,230,2,86,17,232,91,31,233,220,58,122,25,43,31,190,145,101,215,162,97,189,219,25,121,114,134,161,76,126,142,14,171,231,250,195,2,1,191,14,108,39,67,76,164,13,135,149,191,171,90,33,38,51,207,169,95,54,230,2,44,241,212,173,43,205,92,113,207,63,60,89,222,173,50,225,97,157,219,213,23,164,177,157,133,238,29,197,236,188,99,234,182,110,7,67,202,179,217,43,156,137,165,52,249,59,131,58,167,0,6,198,98,120,219,15,26,20,16,32,226,13,151,232,202,154,52,210,36,107,74,223,173,229,120,197,147,48,102,56,58,83,173,188,99,216,249,109,85,249,155,75,8,122,209,74,88,231,57,211,110,209,76,90,15,182,197,192,100,228,143,112,15,236,190,117,161,215,157,18,109,201,182,43,3,209,212,41,127,246,184,238,174,159,133,77,171,149,85,59,86,40,132,48,212,15,235,158,61,204,36,192,103,248,229,251,58,68,207,221,51,193,222,253,3,87,25,243,137,252,0,243,231,212,2,254,66,152,167,51,229,30,110,195,255,34,17,135,49,16,44,129,133,40,173,11,28,90,73,86,166,216,48,71,75,67,167,101,176,187,173,126,127,115,110,224,104,158,248,0,118,97,160,211,118,222,192,220,159,45,49,166,20,26,233,5,55,74,105,140,167,254,143,249,228,144,3,6,5,147,185,222,174,96,68,176,83,154,134,208,153,9,52,205,145,111,124,39,240,144,38,193,163,127,138,149,231,234,127,167,190,139,103,121,107,51,188,180,67,199,147,247,189,45,79,22,124,239,155,198,244,136,81,11,201,176,186,112,22,201,19,180,119,102,171,76,198,208,237,5,171,124,72,120,146,110,248,110,102,14,64,29,201,179,241,122,95,243,178,95,56,183,16,43,192,39,27,81,246,50,190,34,226,9,20,123,22,160,29,111,50,6,59,190,221,35,70,183,97,194,220,168,61,201,130,99,103,118,236,228,223,62,133,246,232,184,206,248,31,35,173,108,90,81,222,60,171,137,110,134,222,54,71,207,94,184,160,91,11,61,255,55,148,133,149,142,99,45,227,233,34,199,100,6,110,75,33,42,208,99,185,7,17,234,91,195,148,12,123,59,57,86,156,150,183,101,95,176,69,201,30,157,213,84,42,143,52,222,21,6,248,75,195,94,173,11,5,185,113,201,31,254,195,113,164,52,100,219,17,196,96,10,34,49,194,225,115,95,6,220,5,106,96,113,20,206,129,235,59,238,170,209,208,254,140,37,190,106,250,193,206,77,244,225,181,217,58,63,87,51,44,50,34,118,73,239,59,114,184,79,32,212,197,7,52,81,177,24,253,101,155,32,204,34,88,175,31,159,7,173,93,47,114,48,27,202,249,33,119,113,178,58,173,213,148,32,193,37,140,128,159,156,44,8,35,42,167,252,191,38,104,240,223,155,115,14,189,24,173,237,47,100,253,20,22,119,218,218,127,103,42,75,144,147,14,236,53,223,218,161,148,47,31,213,178,188,101,7,19,170,220,87,24,20,128,171,250,167,129,181,93,14,4,206,10,196,65,48,20,46,24,92,160,50,18,59,4,33,103,95,138,211,45,94,65,146,101,83,128,184,247,35,251,27,35,113,141,65,175,1,113,11,138,112,94,84,171,32,109,233,99,104,68,240,75,136,58,229,34,26,175,214,2,38,186,171,229,170,173,135,78,178,128,189,204,33,86,144,169,193,131,63,136,217,149,137,111,117,243,160,132,133,142,94,37,92,89,37,29,107,251,0,77,199,141,74,251,139,114,172,189,208,189,248,103,172,250,159,244,13,129,139,251,17,71,154,212,169,86,186,243,14,86,62,182,21,3,224,101,219,3,171,211,43,48,189,218,141,74,172,229,86,87,29,75,110,108,190,11,131,31,94,251,218,59,213,125,80,47,170,90,203,123,92,244,215,107,2,210,72,82,118,94,6,0,54,16,220,75,225,78,3,189,57,49,15,101,146,125,44,5,158,224,206,67,43,37,232,90,44,251,121,16,160,255,251,108,188,89,238,17,88,143,199,115,132,72,168,19,174,197,86,180,155,200,170,235,208,113,64,46,13,191,160,85,212,81,100,161,227,186,251,121,84,3,90,214,112,112,200,163,223,166,249,55,2,64,210,183,230,27,118,42,114,91,47,152,16,218,47,7,116,29,227,165,180,119,52,44,210,21,244,109,167,115,66,145,218,36,52,116,65,138,190,183,117,47,22,7,71,173,20,30,130,88,189,41,32,218,173,182,122,198,185,15,28,125,247,148,131,195,32,8,47,49,37,68,221,112,210,150,65,102,244,253,207,78,123,175,42,147,119,232,200,125,237,4,111,82,114,170,227,4,249,18,140,250,13,240,173,187,208,165,76,102,160,218,91,146,102,135,124,16,225,215,60,98,60,252,31,17,245,28,246,157,185,239,66,209,15,16,237,176,192,95,231,136,28,46,143,181,216,188,176,235,21,57,252,131,208,175,148,233,76,165,43,81,115,0,127,236,45,121,43,202,129,152,171,18,97,230,121,64,225,29,167,153,8,14,10,165,212,191,181,157,251,97,30,53,190,200,54,12,115,96,209,157,209,130,135,40,213,147,192,203,228,77,222,153,229,132,202,39,37,136,62,84,104,236,236,191,39,84,182,29,28,6,222,115,185,211,59,244,212,3,204,69,104,124,180,167,134,94,243,94,214,184,56,218,164,219,116,254,22,225,104,4,91,123,68,214,4,118,170,141,79,136,47,227,5,70,44,33,121,48,251,127,10,203,15,187,104,46,250,48,178,233,119,37,124,35,229,118,82,146,207,181,45,160,209,253,238,4,223,187,36,7,249,247,43,231,79,234,68,145,90,130,243,11,202,93,165,21,188,233,83,223,222,91,30,166,210,32,28,210,66,178,209,86,223,11,97,217,102,124,125,119,16,194,205,221,52,48,62,217,7,226,191,3,205,127,154,167,131,17,254,107,165,24,250,3,38,20,160,171,35,93,86,233,27,203,236,133,156,26,95,125,63,202,163,106,240,195,4,124,163,141,96,96,36,48,225,119,226,215,102,158,106,30,243,159,197,211,142,151,85,34,151,168,211,35,49,98,93,20,133,157,54,33,48,80,103,197,108,61,29,251,249,130,153,154,125,1,74,16,20,128,54,207,85,208,46,190,253,151,127,168,175,222,75,132,34,240,14,153,131,120,231,81,231,23,64,224,127,127,211,83,195,31,19,53,107,141,117,5,119,228,125,166,29,57,37,182,221,206,149,28,8,204,193,132,113,192,246,115,179,84,155,116,178,120,199,8,13,70,233,88,206,193,117,81,178,205,125,124,192,75,53,90,38,184,7,57,168,77,18,91,129,15,176,119,95,208,152,218,184,203,228,243,52,229,221,142,97,20,234,205,94,47,111,231,22,178,27,38,148,10,67,34,1,113,212,53,128,73,222,61,11,108,166,58,27,98,226,190,28,113,251,255,229,79,174,31,143,195,65,152,147,29,174,129,48,125,81,123,223,240,130,153,56,30,92,93,112,32,252,40,131,177,46,245,97,162,111,67,139,197,90,61,45,50,173,203,161,213,142,26,251,21,115,82,109,26,69,28,38,122,105,94,240,3,189,223,244,42,134,199,10,69,200,16,23,222,53,154,129,6,194,207,247,13,114,68,152,216,83,70,247,192,51,187,235,190,59,222,188,7,214,254,28,40,219,62,25,124,55,7,41,58,29,185,211,114,228,145,139,79,142,66,40,75,140,72,146,126,117,173,160,87,122,215,207,153,67,33,166,164,224,204,202,220,234,208,15,24,65,233,64,193,78,60,70,14,1,50,147,115,143,106,11,201,212,164,59,68,171,99,143,26,120,54,5,167,48,75,203,40,115,26,205,169,252,27,217,15,199,167,70,81,237,42,176,129,90,180,213,68,81,212,208,134,244,193,26,67,59,151,32,68,11,109,212,251,70,249,56,206,21,121,146,197,73,217,63,219,179,255,195,198,50,180,44,202,217,16,44,255,190,234,179,68,167,242,108,251,152,146,106,82,221,145,99,227,1,7,23,108,104,150,218,172,251,107,203,88,33,214,250,187,198,119,91,244,205,180,5,61,253,205,83,30,253,47,57,158,119,255,180,22,233,252,32,66,69,234,233,76,59,1,43,81,181,235,122,73,172,96,48,159,224,218,252,109,24,90,178,123,225,93,217,96,46,63,130,130,255,109,145,95,143,75,40,32,227,7,3,31,148,85,42,109,7,242,71,100,12,2,75,194,52,161,29,125,99,40,181,175,158,175,165,247,142,108,54,199,34,212,109,23,14,59,50,169,23,195,124,120,40,93,128,223,133,46,68,169,154,69,212,170,83,47,75,19,54,128,89,245,210,77,41,184,51,160,230,225,41,184,84,15,156,59,118,108,228,83,24,200,7,245,249,115,131,221,29,230,82,96,69,198,41,229,84,78,26,229,81,47,100,37,37,182,233,140,69,255,36,81,79,218,220,221,75,9,139,217,17,251,100,124,229,220,119,251,81,232,6,197,27,108,28,227,61,69,65,232,73,41,64,244,162,108,122,203,156,152,74,219,58,129,178,136,178,98,66,213,121,127,220,135,161,87,159,243,39,83,90,190,4,95,71,237,187,252,35,202,27,123,195,64,40,108,39,225,147,175,164,158,61,114,200,206,220,161,151,129,157,191,253,131,31,67,206,9,153,205,2,25,8,108,43,85,105,248,178,201,2,126,45,51,125,243,113,58,18,109,53,17,188,210,22,176,64,96,112,116,118,201,132,233,94,182,104,79,90,142,84,193,247,45,60,253,214,137,255,222,253,81,126,222,216,190,17,151,105,246,119,255,4,217,215,109,229,122,77,77,220,158,156,87,105,167,149,249,236,51,46,95,30,148,205,11,46,39,74,85,6,96,220,40,197,199,118,35,112,221,192,7,37,127,54,188,138,115,211,174,133,195,0,98,157,138,92,85,190,155,35,248,93,230,123,196,103,79,55,227,117,254,124,224,185,109,116,87,218,131,121,211,249,132,86,226,59,134,85,237,9,251,123,114,105,55,65,103,43,75,155,121,147,143,80,93,236,65,151,84,203,56,55,197,231,149,151,12,28,38,17,219,171,25,17,69,199,243,248,89,100,151,35,56,239,172,114,159,85,226,52,35,185,195,25,174,77,154,141,96,68,31,1,146,72,252,245,37,192,82,187,198,93,235,234,100,238,20,132,217,122,189,21,125,30,94,158,96,243,230,81,53,26,235,156,70,118,223,130,246,175,38,28,95,170,241,137,29,169,184,31,114,170,8,223,231,217,241,29,236,211,46,216,220,201,5,22,197,123,156,51,82,165,228,3,109,96,141,157,60,102,180,22,165,174,149,54,40,12,159,63,102,170,123,222,166,104,111,37,4,167,200,144,171,155,180,246,148,130,24,242,8,28,136,236,50,53,139,170,25,133,248,107,21,85,175,40,165,36,4,49,234,51,248,145,45,188,250,231,9,33,195,239,7,138,233,226,57,39,129,183,143,47,133,49,87,45,30,1,102,146,164,15,182,211,208,251,54,109,164,115,31,89,123,114,103,31,190,119,55,11,80,31,42,169,166,129,95,124,106,245,214,243,196,215,65,122,64,52,124,188,175,13,155,156,123,96,143,138,18,11,185,95,229,102,170,55,190,154,113,108,220,255,43,207,146,214,37,213,81,93,3,249,10,212,21,153,60,98,236,167,241,179,185,210,239,102,188,120,49,46,48,208,26,101,37,109,7,161,124,93,6,236,92,135,14,98,163,218,194,103,169,135,182,125,247,72,166,150,241,161,193,198,81,50,121,173,38,177,221,209,85,176,130,181,37,217,39,13,238,11,74,238,50,222,177,95,105,206,110,29,195,65,240,131,38,191,171,224,201,7,138,158,123,155,30,224,184,178,218,65,55,99,110,244,99,163,239,195,45,155,194,54,20,30,97,159,70,229,3,215,233,27,9,71,221,251,27,216,25,221,7,176,252,226,213,209,186,50,211,138,232,244,151,122,116,21,105,35,177,251,119,99,5,200,37,23,195,165,102,28,7,218,55,98,135,196,51,31,189,3,12,40,214,140,96,83,198,80,33,214,223,56,5,101,190,140,186,107,51,247,32,186,120,124,69,156,35,171,21,204,125,107,74,22,44,109,0,164,102,202,22,184,72,206,2,69,184,68,10,65,97,41,34,245,43,186,168,154,68,226,156,27,180,198,153,45,173,45,111,77,177,167,157,0,14,31,97,129,74,24,249,172,127,20,69,175,82,53,88,222,149,3,173,120,42,231,187,142,235,2,141,167,158,45,116,233,134,6,237,150,27,111,114,172,138,197,152,65,13,217,176,27,55,22,141,116,142,101,255,194,124,194,120,199,136,80,232,241,177,216,81,7,129,176,125,250,158,71,244,132,219,164,110,246,232,48,141,6,57,160,22,71,174,7,245,111,177,50,141,231,239,70,226,28,123,87,163,228,12,149,18,14,242,59,244,87,215,92,241,62,185,101,133,163,189,243,93,163,88,65,38,132,72,76,27,74,163,221,249,48,177,82,121,17,220,135,204,4,187,52,220,112,60,153,25,199,16,183,124,28,235,132,213,180,248,212,198,226,84,179,179,148,102,97,253,249,176,230,36,188,117,98,174,232,182,230,173,2,233,84,92,143,68,226,177,107,238,87,116,2,222,184,33,218,168,140,101,24,32,49,69,3,187,141,52,181,64,45,132,47,220,9,86,82,67,115,21,140,229,26,63,85,168,97,0,202,34,70,104,76,76,73,159,125,17,91,121,93,149,165,152,108,54,93,81,91,79,42,210,250,47,84,196,6,84,85,28,23,199,19,66,125,197,26,132,212,143,174,88,137,57,77,183,4,206,235,157,170,148,68,166,160,165,173,159,25,71,90,125,189,146,118,202,181,6,187,74,222,246,50,202,14,35,131,162,241,251,139,195,110,101,3,97,67,217,203,65,11,207,207,110,171,144,35,53,196,189,225,66,13,57,1,51,204,156,140,161,208,80,155,254,57,182,20,90,92,2,145,124,26,171,10,96,188,227,191,56,182,137,61,73,171,162,187,254,110,45,55,32,147,175,114,233,170,249,218,209,7,66,116,62,64,182,130,253,0,119,112,240,215,94,124,193,239,228,249,214,204,87,234,6,194,46,127,159,172,176,231,185,7,112,208,170,55,201,83,177,146,138,215,202,146,33,73,73,161,145,35,165,64,115,175,208,75,167,194,47,61,126,71,217,68,158,89,215,50,143,31,148,250,31,47,43,43,153,23,221,118,87,6,182,38,179,0,10,65,42,240,199,43,89,115,97,17,60,174,127,241,22,94,175,175,237,102,80,85,212,27,70,178,211,121,162,37,234,205,77,165,232,32,94,68,177,153,63,84,123,247,136,5,73,194,139,92,62,183,192,136,26,27,98,114,169,191,225,164,9,182,143,45,173,66,234,158,27,231,195,79,149,159,185,201,154,201,218,45,28,166,152,170,100,191,17,112,117,16,234,236,58,170,30,119,64,114,15,90,7,160,122,66,22,61,22,81,163,23,245,118,2,225,236,195,37,17,129,190,211,162,79,221,135,63,123,30,209,10,59,204,89,38,146,3,65,132,7,230,195,238,227,167,247,114,129,229,76,213,51,137,235,127,185,155,178,172,133,33,161,219,202,117,4,156,242,236,163,1,74,216,246,198,158,238,66,173,224,203,17,228,81,248,164,252,39,122,29,251,120,208,40,204,177,44,142,97,247,194,84,236,40,116,237,50,226,239,73,249,216,209,37,163,193,198,64,46,226,17,159,152,217,105,151,18,64,26,114,26,241,71,0,88,47,62,158,175,228,153,93,196,214,74,212,102,234,84,10,45,92,150,153,112,176,66,76,56,172,191,0,40,44,122,172,33,223,34,18,127,220,79,99,10,109,142,170,254,172,74,37,15,172,188,34,102,199,35,56,90,198,105,150,252,187,193,30,190,89,135,9,50,152,11,38,223,92,132,122,197,243,83,50,209,178,64,9,174,153,147,164,154,77,194,89,235,42,250,79,159,30,216,48,196,86,237,34,109,96,196,58,104,187,164,76,145,9,216,72,105,204,70,160,59,71,44,253,177,49,206,118,52,80,93,15,164,16,243,213,96,85,113,32,214,112,251,247,195,83,133,70,93,236,203,123,145,174,136,165,106,82,28,175,168,161,21,53,15,193,44,169,112,236,25,212,31,64,162,121,104,241,192,54,87,215,144,97,206,136,234,127,187,208,95,115,70,29,131,225,15,205,189,25,107,199,94,144,24,201,135,13,117,211,80,89,203,44,218,30,225,153,1,4,204,99,65,247,21,145,25,232,32,71,250,9,152,109,59,39,32,16,99,174,170,48,118,87,224,27,25,79,198,12,123,183,169,89,95,228,54,59,229,142,165,31,122,248,58,216,116,245,193,127,195,144,50,252,144,124,224,91,198,50,242,45,77,108,67,181,230,154,44,1,58,28,108,160,87,225,250,141,53,47,36,171,233,175,81,174,102,172,222,68,220,176,79,18,140,173,165,5,19,63,246,162,225,201,247,249,137,124,88,48,194,161,124,229,32,148,119,128,185,220,231,52,125,160,195,245,187,227,236,46,77,168,26,231,253,50,245,34,79,155,41,239,192,237,15,220,211,139,215,102,228,222,21,43,242,147,163,100,247,60,102,159,239,96,219,148,53,200,181,230,235,191,26,236,13,74,200,50,31,176,76,195,112,247,214,233,19,64,61,44,96,151,135,228,18,127,79,240,189,27,97,190,109,166,160,29,44,179,69,72,194,17,67,0,241,57,110,16,93,98,147,237,184,85,199,15,52,155,82,7,91,164,221,32,31,96,45,213,151,103,74,162,62,105,58,193,123,34,155,247,217,35,0,125,84,108,20,119,174,215,211,254,18,252,169,82,144,27,246,6,22,187,95,9,101,49,5,208,30,75,147,251,23,221,73,184,56,87,237,253,81,13,188,63,246,223,111,36,94,251,90,75,241,157,126,13,51,25,201,156,201,6,21,186,190,151,195,162,21,146,121,138,32,196,92,118,8,88,80,20,201,8,241,90,80,93,79,230,180,164,83,99,226,193,204,99,134,168,41,42,66,95,214,146,203,42,198,33,61,126,246,143,210,177,76,174,54,72,168,159,29,249,67,159,152,53,12,113,86,42,135,146,25,37,36,73,56,178,14,145,7,224,52,116,45,107,205,207,244,214,113,32,54,82,19,199,151,34,200,50,129,129,133,69,88,122,239,209,193,29,248,176,236,172,235,79,198,63,214,15,245,55,159,67,219,96,218,21,209,208,112,131,125,6,63,183,251,26,112,55,226,76,234,10,181,182,186,195,189,120,157,222,224,70,123,102,39,218,37,210,114,197,184,227,220,29,216,144,67,196,169,219,213,63,177,35,199,250,130,153,215,230,127,250,62,242,75,154,251,47,130,218,195,104,28,193,220,225,227,208,215,11,83,223,27,90,140,37,96,232,157,216,140,191,33,20,99,51,222,174,175,178,100,160,71,33,108,230,140,16,250,191,35,174,154,184,44,82,172,244,76,20,145,230,243,59,160,138,157,16,118,15,78,15,219,240,158,50,113,74,14,9,254,255,109,194,192,95,148,80,131,199,41,31,209,240,185,216,37,122,107,207,90,228,173,21,193,166,218,40,90,134,34,57,174,79,44,1,94,146,22,62,151,90,36,35,215,110,69,1,234,172,112,9,3,185,94,161,5,166,30,92,217,215,95,116,168,227,219,91,38,152,72,169,75,94,50,110,88,205,45,52,156,126,25,139,3,88,35,215,171,169,68,211,100,80,109,128,52,190,51,163,196,69,70,132,45,170,208,192,43,125,152,195,71,66,178,231,115,123,40,220,162,249,197,103,99,176,53,75,253,236,54,164,224,123,144,186,172,199,45,49,28,53,50,217,220,177,68,169,16,115,108,56,23,242,63,92,145,106,94,48,23,211,40,245,105,48,249,137,110,255,135,104,224,39,240,112,109,32,187,169,211,67,246,111,22,229,132,65,96,32,208,108,186,198,135,252,157,44,141,34,173,33,103,249,113,59,94,38,239,192,123,232,237,141,77,12,255,203,95,108,2,197,36,118,41,209,30,94,37,230,122,177,140,65,23,181,171,72,77,88,44,168,109,111,62,36,88,57,203,241,77,128,112,40,171,163,207,219,186,162,248,123,1,57,8,159,255,160,102,33,98,151,39,239,254,234,239,121,171,157,115,206,249,134,97,182,131,148,72,108,164,50,27,185,165,147,208,104,141,78,223,187,105,36,95,130,188,150,58,252,182,221,205,81,253,195,244,145,81,182,32,71,169,62,228,92,233,127,215,120,189,59,216,77,58,233,9,106,21,158,173,3,102,213,229,40,11,133,40,145,253,2,221,73,221,32,51,102,140,95,41,62,6,21,147,116,228,90,243,74,188,254,153,6,74,150,224,41,42,97,7,123,230,115,251,221,183,201,104,243,70,77,255,56,157,211,202,237,164,207,216,28,56,186,15,98,166,240,0,127,14,56,179,80,118,174,64,205,220,233,71,15,116,113,21,247,134,85,95,193,171,88,237,141,240,114,156,244,131,93,113,25,167,119,210,17,214,135,2,150,169,153,38,27,29,235,102,193,238,68,212,69,19,95,164,146,238,214,23,218,43,92,253,221,235,122,144,180,189,114,215,2,246,111,239,191,141,101,209,155,99,253,214,95,255,34,123,4,124,30,181,59,69,238,252,19,34,8,253,81,30,236,130,45,209,115,96,211,59,55,246,31,236,213,38,181,96,255,174,166,214,235,3,79,166,88,237,187,110,78,62,70,148,1,229,162,9,207,232,15,140,67,90,30,66,91,232,176,9,122,57,130,179,105,165,182,59,164,184,63,189,81,28,123,137,219,75,69,25,78,9,104,65,119,80,70,229,44,62,126,70,82,228,178,225,75,36,181,14,214,199,15,198,102,216,51,108,158,19,149,219,108,86,136,247,128,252,154,44,156,72,162,129,101,113,255,97,225,174,0,139,174,35,221,115,60,198,223,63,183,57,13,139,85,135,87,237,176,83,225,132,156,39,75,96,125,247,202,78,214,32,32,118,220,255,251,103,193,130,215,213,55,204,242,93,44,153,26,182,132,52,201,131,234,204,59,158,97,35,203,210,144,68,56,185,100,46,125,128,106,90,14,165,241,54,116,178,93,20,54,203,246,20,120,1,118,28,67,245,37,4,239,6,85,16,3,236,0,41,214,15,182,72,43,84,46,197,146,127,67,113,224,205,141,164,253,110,8,174,208,189,72,50,229,113,30,100,190,56,234,245,58,104,26,244,216,35,48,155,204,1,153,216,151,44,236,211,43,162,142,235,54,238,182,208,226,167,52,63,103,235,158,208,3,205,113,44,81,96,75,56,56,171,111,237,116,216,119,27,117,172,127,186,136,56,178,98,101,78,131,2,209,28,181,112,121,115,240,50,155,139,188,155,138,162,4,228,66,90,234,18,139,159,4,4,204,174,156,190,133,89,36,217,192,106,60,138,124,162,137,38,122,32,161,102,246,37,52,58,72,124,15,99,205,76,60,144,211,132,227,184,5,163,26,250,150,68,21,202,0,232,190,51,194,177,242,11,1,51,79,46,219,187,193,245,19,178,110,66,36,188,81,134,20,221,248,166,12,36,255,90,55,162,12,9,221,68,73,15,190,166,52,147,135,72,109,202,44,249,44,245,142,236,41,59,239,61,214,189,25,171,12,32,37,59,164,4,9,233,243,132,249,170,55,210,226,2,209,125,201,171,30,55,228,28,245,60,204,32,6,204,104,6,179,113,189,90,243,247,113,29,231,169,153,122,168,227,189,18,56,183,150,91,197,119,129,75,37,171,212,77,40,42,17,236,48,38,10,26,166,172,107,217,54,118,93,6,121,209,90,130,112,124,209,209,115,144,124,174,141,82,88,181,124,202,32,60,153,83,124,98,123,77,156,179,53,236,100,12,24,117,199,72,215,60,148,15,89,137,24,113,193,23,77,167,182,94,27,81,74,254,22,187,168,246,243,10,174,255,173,240,126,172,142,84,104,161,184,223,97,208,30,145,29,179,249,138,86,237,123,99,160,121,238,45,245,160,253,96,143,102,24,43,76,192,33,36,252,69,102,36,98,103,113,170,212,65,41,84,230,41,210,33,104,226,75,56,113,141,116,57,83,86,37,142,166,211,123,52,125,161,212,13,22,218,63,3,168,221,227,202,197,16,80,9,149,90,254,231,14,179,157,108,8,132,145,179,35,123,240,107,43,84,10,45,178,232,171,242,65,95,43,188,225,110,60,236,225,248,231,85,112,114,223,19,108,60,57,113,15,49,66,86,7,50,15,165,99,185,137,17,8,146,194,204,176,183,60,92,49,45,114,84,163,154,108,144,59,35,246,65,40,197,104,146,176,194,166,247,95,179,104,113,154,106,245,181,137,175,131,105,91,41,117,252,12,162,5,171,225,203,38,21,4,242,49,141,242,214,53,150,122,55,125,57,76,2,21,199,161,39,79,46,121,252,173,185,239,200,79,126,161,254,96,31,221,75,174,93,166,139,70,217,178,26,243,89,252,110,189,11,98,218,254,136,204,128,75,46,196,251,41,212,73,52,197,187,211,175,37,219,113,26,100,166,216,161,103,218,194,20,230,21,44,158,27,100,246,14,19,203,34,162,130,227,47,0,39,222,180,76,74,169,77,127,172,135,249,119,3,212,210,245,131,17,178,95,114,54,94,252,228,34,88,90,244,102,130,168,194,235,58,125,2,85,152,201,4,59,249,143,9,119,90,6,15,143,107,206,108,106,151,203,21,26,231,138,153,149,128,23,208,66,151,80,124,142,70,58,179,57,39,153,126,213,246,64,33,130,206,178,9,224,241,135,83,86,206,36,78,110,232,127,37,83,102,43,1,6,196,203,239,205,103,47,133,85,120,229,209,56,3,239,83,238,215,218,225,164,123,215,185,207,204,66,67,239,12,199,144,227,107,198,30,239,212,74,197,175,109,183,195,34,33,240,68,10,128,213,115,44,53,181,110,53,249,220,214,52,214,105,104,143,78,42,239,229,227,62,115,37,61,207,209,60,236,134,16,235,29,9,0,204,231,222,160,32,99,145,85,240,192,217,223,223,0,74,252,97,144,195,194,137,152,240,85,174,63,68,186,30,92,87,142,202,21,115,114,30,118,141,94,236,238,106,182,183,196,102,5,87,245,218,128,125,157,122,29,218,232,5,57,73,138,139,126,120,119,28,51,24,229,214,16,219,242,29,81,177,115,21,81,116,235,129,123,46,250,122,35,24,76,150,173,167,175,5,180,55,238,6,77,28,162,120,8,13,12,213,55,195,179,76,235,123,204,198,41,96,228,40,229,91,220,210,46,156,122,173,98,7,118,23,245,189,106,196,109,144,4,179,62,59,190,94,189,154,62,254,240,33,2,57,215,63,217,172,12,37,136,198,118,203,152,152,84,34,175,199,251,137,98,101,253,35,237,43,187,126,13,103,175,24,88,149,1,140,90,104,49,55,92,42,144,33,148,143,231,160,99,48,113,1,68,189,255,251,145,177,145,34,82,124,172,47,199,95,155,127,2,232,217,162,167,228,52,113,138,108,192,147,77,74,58,123,110,201,133,43,183,195,226,106,96,169,140,169,130,200,115,252,200,235,102,129,132,180,5,49,138,53,13,105,103,220,56,198,82,32,24,220,95,147,90,64,66,138,203,51,134,6,124,127,57,7,177,51,173,43,90,18,4,247,80,147,237,175,140,179,24,175,130,179,189,13,219,166,38,19,6,58,235,138,136,244,183,221,117,115,243,186,112,141,17,122,103,193,128,193,121,137,153,109,76,47,153,200,255,255,209,230,134,53,173,68,178,246,27,28,141,236,121,89,17,65,189,16,252,115,1,144,19,54,124,216,122,77,25,174,180,24,2,91,8,99,8,168,159,177,231,230,85,106,56,89,238,170,37,253,118,44,42,94,126,191,58,188,198,82,69,109,246,5,211,190,83,222,33,192,182,6,91,54,209,174,48,49,181,172,69,162,146,90,162,201,153,40,177,45,214,97,183,154,67,90,75,194,217,35,44,192,106,139,173,253,9,93,172,46,222,142,236,118,23,165,124,127,137,3,10,249,111,30,199,215,68,153,63,234,101,60,193,35,101,219,197,40,189,207,61,32,75,66,23,213,28,8,211,176,79,62,27,131,92,56,202,155,75,219,92,70,54,143,94,173,81,252,220,147,253,76,174,164,123,118,120,70,139,6,33,185,137,240,155,54,162,5,0,180,186,135,131,97,224,0,131,192,159,149,248,157,20,82,220,188,188,178,182,64,28,68,140,34,67,59,134,232,0,139,187,164,239,56,183,192,222,82,69,40,54,188,235,180,172,134,252,39,21,135,106,145,229,160,224,67,88,218,32,113,77,12,116,206,102,71,154,205,90,43,117,60,108,248,127,142,193,216,151,66,73,82,81,21,83,44,172,70,117,205,141,18,60,247,243,15,2,64,225,75,89,126,87,16,8,77,221,33,232,75,90,141,155,201,234,123,151,8,64,228,224,244,27,212,92,12,163,251,164,129,197,51,251,238,125,96,181,43,225,216,33,207,227,205,146,164,248,5,21,131,29,149,141,102,105,201,25,232,97,230,32,152,70,213,235,3,32,87,207,70,202,26,227,155,7,116,206,182,111,173,167,145,140,81,250,12,89,150,9,79,209,92,171,190,172,121,243,122,160,84,50,108,193,125,103,59,26,86,68,119,39,172,106,86,26,159,95,74,74,70,96,8,4,149,121,83,216,216,103,121,184,44,215,149,216,90,120,72,1,254,252,5,119,180,207,221,224,101,0,123,221,221,153,97,241,118,179,122,85,214,251,34,5,210,133,22,122,200,241,6,154,156,70,24,128,228,235,2,178,119,141,153,147,43,231,213,148,72,130,61,196,212,222,218,170,223,204,52,231,90,28,206,248,100,193,73,93,153,75,207,191,203,194,83,164,139,67,115,124,51,80,197,248,135,216,111,79,164,31,40,170,223,208,155,215,115,250,65,90,194,224,109,241,100,230,232,15,202,170,115,208,205,39,104,250,119,159,135,240,26,21,139,7,218,180,62,10,199,138,245,135,183,27,167,107,35,3,39,245,189,64,188,90,19,12,175,42,48,81,241,254,211,79,37,72,176,80,215,36,29,87,146,193,112,6,226,34,86,245,0,108,87,79,212,91,198,156,255,120,205,90,79,77,114,196,161,228,87,213,209,112,216,137,85,127,83,10,131,29,222,169,27,0,76,130,242,8,89,205,37,119,242,211,178,13,155,7,91,213,213,137,111,8,136,178,231,115,243,205,173,77,218,169,145,113,161,82,19,60,9,195,2,194,140,128,234,47,64,112,137,236,150,165,228,60,60,117,52,25,47,158,140,195,22,29,237,46,51,84,134,236,77,165,56,233,133,145,150,202,77,131,154,46,155,178,245,17,248,119,207,223,115,245,217,180,135,227,57,24,207,162,82,44,2,191,226,165,0,142,118,32,36,181,208,202,231,130,231,208,146,106,165,118,2,133,98,69,34,78,58,150,211,60,94,80,44,224,59,87,49,109,4,225,160,31,164,238,218,150,182,46,174,54,223,208,154,108,135,36,151,104,27,13,139,81,253,179,28,191,102,91,24,234,106,56,151,149,234,64,12,231,126,211,29,143,166,106,57,34,115,251,2,146,248,61,87,194,107,199,91,146,150,21,8,160,144,154,193,22,239,217,114,211,206,5,158,211,21,97,251,82,53,203,9,245,133,126,177,250,148,22,94,234,232,211,226,180,142,84,98,95,38,180,247,67,145,101,17,18,215,94,69,86,105,227,214,5,59,94,133,165,49,230,66,217,9,135,241,7,125,218,25,243,73,229,69,61,204,65,186,27,79,80,167,111,150,201,95,51,74,30,128,142,131,224,65,46,121,253,137,121,10,183,243,36,186,158,219,55,72,62,201,67,222,90,62,111,108,59,128,142,57,167,132,171,171,98,104,205,244,216,32,146,209,124,39,121,187,189,126,144,141,111,171,71,221,75,144,82,201,233,115,89,165,180,164,18,216,186,115,112,178,176,197,111,24,236,53,153,238,185,170,105,102,110,68,155,186,9,235,230,123,196,53,217,185,128,252,159,109,171,235,251,192,199,195,138,254,66,226,233,184,177,88,59,125,88,7,23,46,108,89,40,107,119,255,47,234,107,64,245,148,188,123,87,1,18,215,28,45,132,131,28,68,16,108,11,23,230,70,39,181,193,3,121,157,178,219,53,187,29,74,25,250,35,203,214,92,30,49,122,143,224,187,135,102,2,163,22,83,117,197,129,114,210,166,134,180,20,201,181,219,23,184,119,33,155,216,111,15,182,249,126,18,43,206,127,169,71,120,230,85,120,63,215,4,148,124,144,168,89,71,132,215,16,210,193,41,179,40,196,148,25,218,117,38,150,127,249,219,237,208,248,0,197,72,247,51,62,204,217,58,108,241,41,99,142,78,95,193,102,202,160,43,218,57,227,209,77,48,207,254,203,0,92,174,76,54,228,88,64,53,225,94,136,107,180,204,143,3,213,22,69,23,186,151,16,246,40,122,217,226,138,121,142,231,219,81,135,25,96,197,211,138,211,90,185,189,173,37,174,140,105,175,170,176,51,162,255,199,173,168,3,144,182,61,240,186,38,122,195,118,2,127,11,250,216,88,202,141,105,222,178,53,223,47,99,47,106,196,82,10,33,16,120,183,162,73,186,142,69,255,151,105,79,137,174,1,137,211,225,105,137,85,106,95,84,26,102,163,131,212,126,32,81,245,192,253,2,42,237,176,64,86,201,58,241,134,72,183,255,92,248,21,201,83,60,209,212,13,99,33,113,22,24,239,253,150,17,222,132,235,30,57,96,190,26,127,160,217,102,6,113,195,27,222,235,116,190,171,197,221,116,242,140,116,34,178,50,79,121,241,206,117,148,250,234,171,150,90,192,244,40,184,157,209,45,101,92,167,119,203,243,67,246,165,9,39,155,69,233,210,68,245,69,193,176,68,171,58,180,81,113,133,186,73,2,108,5,35,71,179,220,74,33,115,96,47,166,28,138,73,115,90,7,231,80,9,97,190,74,92,53,4,90,31,110,248,108,12,102,211,204,104,136,219,232,224,238,240,194,42,162,183,36,78,45,12,87,219,123,98,30,110,64,211,191,102,114,88,124,134,125,101,131,152,120,41,167,185,219,72,189,146,180,39,187,99,121,138,91,187,15,95,104,82,113,179,222,38,82,121,77,195,147,183,250,75,124,68,115,93,140,194,49,77,200,112,183,71,179,147,31,84,33,69,217,38,101,230,31,244,228,223,197,147,251,217,45,20,130,230,178,76,86,28,50,228,39,4,185,189,247,71,22,42,34,11,235,14,10,82,13,107,8,158,190,0,28,213,161,173,112,140,112,14,63,195,193,245,50,181,34,19,30,217,35,34,196,248,122,110,115,213,14,105,180,220,134,70,127,204,0,187,127,98,14,194,114,56,58,204,202,35,9,131,199,78,248,32,129,71,20,61,19,14,45,33,59,45,122,52,62,217,17,9,217,15,108,229,58,18,191,174,28,240,147,229,88,60,182,147,108,143,60,100,253,140,68,185,217,137,138,64,14,5,233,137,117,188,75,240,123,67,44,76,134,170,64,193,139,41,120,16,222,182,177,242,152,81,54,151,116,150,6,33,231,53,40,170,145,52,26,1,228,8,122,207,27,225,90,173,135,54,193,220,192,13,121,234,181,60,126,254,67,40,194,10,159,176,236,18,74,9,193,82,155,239,92,163,89,124,187,113,155,251,64,43,153,229,57,228,69,202,242,41,37,30,113,250,230,151,68,46,230,216,120,24,199,61,142,9,244,164,119,62,14,39,206,153,41,10,126,32,46,147,79,41,13,53,62,130,179,214,241,176,224,32,253,213,163,139,157,81,206,193,227,202,230,40,21,146,53,61,23,64,133,118,58,161,75,44,245,107,135,211,135,197,114,85,145,159,252,80,183,137,10,16,109,150,219,130,9,200,194,176,247,242,30,42,50,158,116,123,75,183,192,172,2,212,204,183,78,153,202,13,183,124,238,133,50,186,27,165,186,236,151,91,123,172,48,5,22,17,92,187,185,16,58,147,192,124,118,103,69,41,112,220,61,78,192,214,179,10,252,216,30,233,252,66,87,186,156,138,34,72,190,100,210,67,210,38,2,128,101,131,45,104,202,175,150,36,50,132,50,139,126,47,199,109,228,153,184,180,109,42,6,23,153,202,38,180,203,211,164,216,146,171,65,149,105,2,6,50,42,211,36,148,194,164,217,87,43,141,180,140,240,186,177,155,113,106,180,173,137,9,114,11,168,237,135,213,141,241,234,10,10,144,234,254,234,121,251,160,23,118,1,85,202,90,134,53,186,162,47,83,121,172,194,122,216,249,45,75,78,245,236,40,22,110,190,204,73,153,210,204,224,104,242,239,69,246,28,151,231,91,106,159,66,93,33,202,132,111,87,153,155,143,103,140,74,95,66,25,153,73,9,53,214,173,67,29,36,196,36,143,104,69,85,33,163,143,78,143,66,237,76,161,172,52,225,69,191,21,6,160,229,181,179,163,13,30,178,89,125,0,34,152,45,185,150,88,94,47,29,217,222,160,167,25,143,241,67,64,52,52,219,19,150,240,133,32,175,33,46,150,72,36,119,190,65,157,85,212,222,81,138,92,104,136,153,76,141,122,133,135,22,162,66,120,129,42,227,9,220,229,2,47,4,150,45,172,18,166,247,16,13,59,171,153,126,121,203,216,175,128,189,74,218,28,161,206,136,52,136,99,116,242,238,253,146,50,17,93,108,56,191,192,129,109,152,119,163,119,126,29,118,158,69,179,62,253,109,155,70,189,148,115,54,71,120,92,173,93,200,32,223,169,87,3,106,10,226,197,247,236,89,142,12,201,128,60,208,47,126,74,124,171,44,149,21,116,219,35,141,0,175,251,16,43,11,25,148,5,79,16,38,21,25,215,72,38,236,247,221,250,67,246,76,76,230,141,29,21,132,153,185,91,90,250,81,227,142,249,241,45,156,100,215,50,118,228,121,132,224,231,55,100,164,239,244,65,134,231,106,159,161,231,33,212,12,28,161,235,73,197,44,214,41,43,205,135,67,135,40,2,58,14,166,244,46,22,243,1,163,172,189,175,67,97,76,213,155,226,14,158,141,234,9,160,168,119,141,149,209,237,114,250,231,114,202,22,40,85,66,127,227,127,230,151,184,155,129,92,230,218,203,155,28,28,44,219,78,119,13,222,230,62,47,210,70,174,176,72,68,205,112,20,92,54,33,79,229,26,176,202,169,143,50,68,74,149,193,223,252,158,191,134,75,150,234,21,89,77,117,131,211,93,178,230,154,139,129,27,149,220,9,59,194,224,241,185,86,4,89,108,87,37,139,242,246,252,181,40,87,220,20,219,87,91,19,28,92,71,93,61,120,77,84,169,176,133,125,219,121,167,126,39,229,233,143,60,171,164,237,212,219,159,89,245,92,24,208,64,54,143,87,222,144,5,238,156,95,34,118,189,44,72,77,151,3,23,213,113,30,154,143,190,189,223,33,159,252,49,17,234,136,186,170,72,107,79,38,254,10,10,66,223,84,176,236,215,132,29,151,125,139,131,255,168,47,76,29,79,24,121,26,80,75,1,129,148,27,4,57,255,134,103,214,81,233,162,44,150,142,9,154,72,20,168,22,38,100,175,240,249,32,114,151,153,17,113,243,90,45,101,174,138,30,215,95,3,93,49,12,205,67,138,52,116,50,94,33,200,19,110,82,226,10,80,21,173,229,201,232,92,160,161,200,182,254,32,23,85,205,151,211,112,38,67,25,244,224,226,112,91,252,73,193,223,24,44,154,142,99,131,250,136,16,84,231,117,197,14,195,62,145,250,81,170,208,79,107,43,145,141,25,170,46,223,8,23,83,77,136,170,29,42,240,55,87,185,0,174,58,164,100,159,124,140,22,99,255,241,34,163,97,184,183,23,189,71,169,132,160,186,100,172,143,3,84,77,27,155,100,66,146,8,188,208,165,28,184,219,136,24,194,230,196,53,235,132,140,21,215,226,167,57,221,26,221,162,53,184,203,207,70,190,163,142,128,174,5,132,5,142,74,107,22,250,126,190,21,146,165,181,152,100,9,174,188,97,47,28,113,28,178,148,176,29,2,146,24,27,164,132,139,147,146,47,196,8,181,178,101,196,253,16,2,224,137,187,86,144,131,6,102,236,250,165,108,75,156,210,102,91,245,12,71,83,242,236,152,11,71,193,34,1,216,23,141,181,119,107,165,12,109,115,140,145,116,235,175,28,112,13,215,145,208,209,177,13,205,181,193,5,71,59,24,180,177,224,246,20,118,46,100,105,20,227,183,3,142,19,116,173,145,109,236,132,118,132,139,164,203,32,190,116,191,45,42,76,227,221,113,25,178,9,124,215,201,35,205,223,245,3,61,156,53,51,65,126,196,156,130,1,165,217,196,168,22,21,57,240,227,86,98,148,4,33,166,119,250,235,74,165,6,67,19,190,11,203,82,46,94,111,5,75,6,250,236,220,193,73,106,148,147,36,34,231,62,90,138,225,148,66,251,132,13,219,132,48,143,132,109,3,176,221,172,5,88,84,241,241,109,190,170,89,66,80,85,241,239,11,121,254,208,241,206,204,82,68,130,187,52,51,252,198,50,90,169,11,205,247,189,14,90,241,162,159,152,202,139,160,183,95,190,8,152,21,146,234,237,159,204,249,38,24,131,169,98,12,186,155,98,21,166,179,135,33,183,168,85,48,240,88,216,11,180,6,112,189,229,206,252,62,57,196,14,138,26,198,79,129,126,203,146,75,154,105,112,180,131,127,12,118,24,42,124,187,172,99,28,169,230,110,223,120,113,67,63,50,235,252,199,133,71,213,192,98,131,224,207,177,52,247,102,221,188,31,202,58,157,79,143,118,128,94,99,37,58,5,65,66,106,145,53,78,202,182,132,236,39,56,204,233,197,243,174,6,41,108,75,84,135,134,253,152,196,253,240,34,207,122,179,171,53,100,34,19,111,169,68,84,25,182,12,90,49,162,116,78,246,12,188,76,230,128,81,199,104,250,102,110,227,212,194,97,236,116,216,17,94,147,217,203,187,187,10,98,132,155,100,64,104,64,248,241,5,46,158,96,53,138,43,144,113,246,239,23,203,135,117,191,148,251,202,141,175,171,17,99,100,80,123,5,194,226,43,189,14,139,95,191,171,147,217,99,114,84,154,20,112,157,161,69,115,80,176,149,110,203,133,209,8,5,158,202,48,44,250,243,16,18,147,100,60,215,139,144,151,72,192,41,142,152,131,211,97,70,70,2,151,121,117,26,213,147,142,17,147,172,215,140,78,54,15,186,117,237,38,54,121,217,5,235,35,177,46,54,210,183,127,227,29,163,24,245,51,19,62,227,55,242,75,22,208,199,148,169,157,35,155,108,106,49,97,15,210,238,228,219,176,179,166,221,34,64,245,76,227,216,170,69,221,231,186,87,201,0,208,109,137,15,31,55,63,128,164,132,10,92,250,35,3,61,64,137,229,195,22,202,87,159,65,129,202,224,183,111,151,42,162,16,12,73,87,29,93,253,87,108,176,66,39,174,203,220,172,17,24,85,75,97,176,62,167,160,113,205,78,163,239,247,244,86,121,162,133,65,122,135,202,143,196,140,183,233,176,126,77,213,51,75,129,221,171,57,81,187,9,104,188,87,242,244,160,80,0,126,69,70,37,225,176,133,24,110,79,113,42,4,129,156,189,194,83,74,49,143,178,187,226,255,194,135,253,158,36,128,180,89,232,121,92,238,26,253,218,232,19,208,43,101,224,134,64,69,0,207,12,13,169,129,108,156,191,141,167,84,131,176,41,114,223,37,37,129,149,233,236,225,245,66,15,89,93,190,219,199,181,39,88,131,172,99,138,116,219,55,100,150,186,180,23,115,125,36,50,196,169,227,203,60,17,135,49,210,89,162,205,163,30,78,243,51,136,215,48,42,223,182,39,60,176,199,77,74,228,0,181,212,186,6,39,131,232,84,194,164,17,138,23,98,227,62,62,126,55,106,198,51,19,210,223,109,43,107,71,41,57,47,14,150,242,166,229,185,200,98,78,140,17,79,235,21,66,158,225,195,112,207,241,128,88,11,220,169,182,40,61,218,89,47,199,117,11,92,11,193,108,98,158,123,48,70,21,38,9,176,15,135,246,98,114,63,25,154,22,152,0,191,113,213,126,100,132,33,2,96,69,186,84,67,144,90,13,143,117,134,78,254,140,48,224,199,201,107,219,102,99,30,137,250,255,91,25,93,102,21,24,98,159,8,17,2,237,8,7,211,19,250,142,58,247,138,172,66,15,228,132,97,110,107,12,138,170,211,43,78,100,22,41,175,31,83,103,214,132,4,45,90,221,255,192,166,129,193,52,128,195,169,1,12,91,42,69,179,185,97,135,216,94,54,72,176,41,58,175,89,56,209,38,151,218,196,100,104,61,210,225,154,226,158,135,103,30,89,151,202,201,106,16,220,5,117,37,20,206,117,220,127,147,71,177,38,148,39,108,41,66,187,179,129,27,50,145,96,144,55,211,140,60,154,189,178,78,49,249,17,147,166,82,55,53,177,205,177,10,157,16,49,64,55,1,82,158,159,163,114,41,164,25,137,147,181,37,186,149,228,130,8,180,185,105,201,175,255,17,114,6,179,237,239,166,68,211,151,163,19,249,222,86,241,229,208,106,3,169,172,53,22,92,14,164,189,8,58,40,88,53,149,180,183,147,26,20,232,97,67,101,167,161,96,26,114,83,236,118,18,18,91,23,121,99,237,240,219,93,133,94,101,117,122,34,228,161,152,103,245,152,219,74,203,241,64,70,61,181,209,141,60,163,110,153,154,215,243,154,25,134,187,234,191,160,224,132,184,49,61,108,103,245,108,24,120,144,36,220,190,211,39,132,116,129,55,156,213,99,247,249,141,48,81,35,78,113,55,138,174,50,104,176,159,217,246,53,214,196,22,126,186,169,46,133,221,139,133,252,64,36,22,69,55,223,104,101,230,40,145,155,181,161,0,194,105,197,89,214,119,172,12,244,23,99,17,138,69,233,14,215,244,123,3,241,62,104,162,119,0,5,230,114,84,34,101,57,101,5,10,206,19,33,106,18,217,243,161,210,232,39,254,180,124,199,248,24,189,202,5,64,244,253,123,106,88,90,188,79,83,36,27,189,21,85,67,213,92,157,105,111,238,120,45,18,47,66,176,108,75,109,102,206,220,141,54,165,44,222,71,221,230,206,210,143,16,12,10,219,157,227,185,196,18,40,188,1,136,71,133,221,24,178,58,103,177,82,105,59,250,144,121,62,140,121,129,173,125,114,74,196,163,83,114,231,57,163,108,58,36,156,114,123,236,149,67,238,139,215,23,225,178,108,35,78,177,140,39,224,77,108,254,34,252,242,70,235,72,225,119,68,54,253,69,174,16,242,28,238,72,173,157,177,242,245,29,90,108,239,207,169,50,98,145,15,108,206,224,31,158,104,247,22,95,142,146,38,54,133,249,51,249,180,98,40,34,79,217,99,37,150,51,18,219,78,250,229,218,180,202,20,208,195,253,194,65,236,106,223,139,80,195,74,52,238,73,24,38,154,46,207,147,84,84,7,34,46,148,211,136,91,199,75,232,145,45,69,65,73,146,191,8,36,34,81,45,2,218,196,27,7,130,3,9,55,208,1,179,23,17,75,129,43,235,210,174,237,243,233,56,91,132,128,254,25,95,214,179,10,250,195,180,184,241,174,171,6,55,26,235,238,230,193,193,204,189,138,51,234,153,252,197,231,183,20,228,228,178,244,53,167,191,243,85,120,205,108,44,70,207,76,234,248,89,141,246,127,224,206,53,126,45,84,117,135,74,251,176,3,176,32,246,9,238,55,138,79,123,220,81,191,114,235,160,210,114,227,171,192,118,182,144,146,84,70,204,222,162,44,167,193,230,157,154,167,143,65,185,8,217,102,134,231,182,41,59,240,97,141,14,75,82,33,204,171,201,134,85,237,92,230,13,130,9,103,72,229,194,157,32,65,127,86,41,206,237,178,254,79,121,125,230,166,153,168,59,195,195,14,6,68,75,50,250,244,125,220,131,84,73,147,75,187,242,122,18,78,204,35,165,221,237,210,201,125,154,232,98,224,141,224,90,186,200,100,181,45,115,173,167,125,10,193,206,26,66,187,159,73,39,169,12,92,129,211,80,184,10,183,61,95,140,249,216,218,237,234,131,7,172,48,245,148,165,85,161,171,104,253,159,62,201,250,246,66,160,0,135,49,204,160,154,196,6,247,115,181,31,241,125,197,118,206,16,183,22,58,153,3,237,150,120,254,22,151,189,77,233,181,56,200,127,73,2,237,69,59,0,186,232,165,53,251,89,83,122,191,180,79,225,9,216,186,172,129,164,198,69,50,107,108,137,142,108,236,142,58,102,218,141,62,234,175,196,6,99,182,114,185,115,121,230,57,0,219,170,248,105,130,103,33,222,232,108,240,170,114,251,224,56,199,63,15,19,148,196,113,223,65,119,242,105,88,112,242,239,171,76,171,24,80,99,67,115,55,220,121,190,58,218,215,94,52,45,142,144,169,135,218,199,222,119,184,104,93,233,144,145,14,150,7,176,158,110,7,180,5,57,167,78,196,234,53,193,109,132,196,196,174,125,35,140,245,119,97,30,36,166,161,136,201,103,120,195,57,187,128,2,102,118,115,30,192,197,244,7,77,68,127,40,174,118,117,62,72,211,16,118,43,60,252,114,162,67,138,136,1,116,241,70,189,167,44,175,114,193,142,103,166,109,57,167,187,249,62,27,62,78,239,4,92,242,148,9,252,59,227,89,62,223,210,98,183,237,21,46,6,13,210,29,86,50,55,15,134,66,111,167,123,158,13,141,23,99,20,17,71,166,170,159,30,101,117,132,5,5,177,243,239,155,51,110,5,227,190,80,32,174,32,47,132,230,228,236,105,41,73,36,164,156,168,236,229,27,146,199,97,172,69,118,129,25,165,201,158,5,186,213,49,179,26,176,19,26,169,233,23,14,184,163,245,19,249,71,214,24,130,113,248,216,103,93,121,146,61,61,104,177,54,180,213,154,167,85,243,29,138,242,18,214,211,82,166,92,163,147,72,142,173,65,204,66,190,85,32,33,78,120,170,64,253,50,198,57,153,58,245,77,246,195,153,241,169,134,227,102,206,116,6,237,66,139,254,24,86,49,55,106,163,21,195,58,29,94,27,222,181,20,146,173,131,55,57,168,68,95,1,188,140,122,78,242,65,151,247,187,158,193,172,243,221,152,216,105,190,38,93,29,61,84,111,111,149,195,100,223,15,94,223,36,217,235,55,138,224,70,233,51,36,123,250,38,153,126,158,204,199,152,245,23,123,19,79,108,133,48,25,183,115,98,175,214,128,156,130,236,120,230,67,33,172,132,86,1,25,37,70,103,64,90,84,22,45,198,172,169,179,190,202,68,87,159,73,207,198,246,67,78,74,207,127,217,203,206,173,94,116,196,76,17,76,199,150,247,132,239,168,103,142,1,2,24,185,255,249,160,202,140,211,223,149,42,220,189,69,185,49,28,168,150,9,109,93,229,104,14,151,253,206,123,69,226,170,141,18,61,36,182,76,21,153,42,114,102,22,130,95,120,167,129,145,198,154,178,70,4,235,93,98,246,140,187,154,14,10,152,145,158,177,181,165,35,96,11,86,81,84,30,67,37,35,148,10,100,178,255,215,105,179,124,247,35,244,23,100,194,148,81,50,50,161,81,193,46,165,254,96,172,4,23,64,180,177,89,81,49,39,225,64,3,219,144,196,64,212,101,176,221,40,100,175,248,111,177,64,64,47,238,242,132,184,74,214,188,35,192,109,114,40,109,177,60,134,209,91,174,195,73,126,117,209,228,222,98,174,246,27,41,66,56,232,13,87,217,88,41,121,233,129,175,219,234,24,15,97,237,197,45,141,103,6,154,231,216,69,32,161,101,215,237,24,185,68,139,217,181,62,77,34,95,93,251,196,219,209,219,115,171,95,157,236,122,21,6,104,71,64,169,244,153,175,49,133,55,243,224,234,153,240,211,20,38,4,19,158,250,237,45,147,29,28,204,71,58,141,178,62,233,174,202,42,56,177,12,215,252,167,185,207,51,157,151,59,58,8,182,254,101,229,193,152,173,16,203,67,250,25,97,239,112,219,156,40,11,157,54,48,64,158,168,200,81,252,140,233,217,84,78,119,42,214,168,246,177,20,199,56,179,160,2,51,226,251,57,37,115,204,181,151,150,213,65,150,20,250,235,49,128,31,78,133,8,119,205,183,81,222,18,106,105,223,64,94,80,74,41,120,187,10,77,117,188,0,142,10,250,229,19,57,27,218,181,225,129,157,44,218,240,62,76,205,206,158,81,114,72,14,49,5,157,82,95,159,150,61,197,198,150,98,46,168,210,57,245,75,183,118,156,73,158,92,9,70,145,121,226,12,154,19,30,170,109,71,186,115,33,176,17,113,53,184,243,217,83,86,190,45,234,166,11,122,88,11,171,8,248,170,44,69,137,159,1,201,138,36,56,49,161,184,184,59,31,185,239,40,64,85,150,57,97,189,65,182,147,19,250,175,109,26,31,127,148,86,99,233,66,130,13,43,24,17,127,212,210,83,115,167,60,117,250,219,35,144,37,15,113,20,120,239,245,129,36,84,16,220,73,253,131,134,192,63,79,141,82,114,225,84,85,60,215,41,84,126,136,7,159,89,233,145,100,253,161,92,147,118,54,209,101,134,233,162,154,115,89,219,225,248,15,1,153,52,174,116,226,24,152,255,158,67,229,239,188,28,69,142,135,93,7,116,234,216,223,95,202,226,142,221,233,250,119,94,246,55,151,46,228,223,113,114,223,250,57,49,95,6,44,165,56,14,53,151,220,23,142,242,55,60,107,144,220,50,47,74,236,103,10,12,208,244,64,35,118,26,27,40,240,130,190,86,103,180,215,169,166,170,115,94,40,10,221,37,38,249,120,226,179,218,239,61,28,236,208,200,70,112,252,60,124,147,32,96,40,55,133,206,110,240,130,215,176,214,225,51,105,219,81,224,115,116,209,119,38,32,124,153,192,12,51,58,62,238,169,230,160,244,251,208,177,203,167,190,254,161,219,104,29,15,49,247,93,15,243,123,44,5,146,52,73,139,104,11,12,119,176,183,0,1,151,176,129,125,254,30,24,218,5,47,173,100,10,145,228,146,189,126,39,54,244,182,228,191,174,118,45,171,241,153,80,1,63,101,53,133,201,70,103,129,6,131,84,234,58,46,76,81,136,188,206,186,61,2,75,221,167,17,3,32,153,66,148,152,139,52,144,238,77,215,62,221,170,177,230,239,229,245,242,11,171,43,36,43,134,232,244,34,177,224,39,85,140,59,178,253,26,251,4,26,19,161,106,240,184,245,40,29,111,12,111,50,187,80,46,10,78,79,148,45,182,39,23,247,157,110,180,103,76,142,172,237,236,23,103,233,150,160,132,239,41,12,61,242,149,61,148,204,63,160,27,28,223,251,93,68,39,173,26,95,192,23,124,86,139,89,47,54,171,33,87,84,111,81,218,163,154,255,25,109,84,229,112,114,176,227,94,95,140,149,85,101,126,50,112,252,215,32,162,109,151,12,34,30,99,243,165,49,61,142,25,103,152,141,229,201,69,200,40,49,28,14,234,230,240,119,109,136,126,141,232,175,141,216,194,89,231,114,53,163,158,2,85,162,234,230,85,90,21,128,235,175,6,138,237,133,214,30,236,112,236,203,240,96,65,228,154,242,17,130,201,129,47,31,206,168,54,138,239,180,141,225,193,103,140,138,126,251,222,211,245,222,191,168,3,185,22,223,205,58,77,123,237,54,20,94,65,94,27,102,18,167,14,69,216,198,173,53,92,245,96,78,169,241,105,83,229,24,25,184,199,203,190,119,174,194,221,31,21,47,202,67,16,217,81,4,4,21,78,57,38,89,182,45,123,88,197,17,33,194,2,62,132,140,194,35,192,102,147,96,230,178,4,231,203,136,189,164,127,246,54,216,202,166,140,237,48,94,98,195,189,89,5,253,83,248,247,57,182,158,130,28,55,137,237,113,173,29,26,161,47,186,209,177,250,198,111,194,57,131,203,183,28,140,109,227,104,4,133,78,43,34,232,179,154,144,162,66,126,139,141,97,86,82,81,115,230,11,34,231,125,159,78,92,106,61,82,166,172,155,93,67,161,57,189,143,87,181,122,14,190,163,96,221,200,19,126,208,234,23,204,142,195,199,159,218,254,109,65,148,163,70,205,188,83,195,254,33,232,24,153,154,72,151,76,82,201,160,103,19,112,163,247,2,110,187,217,71,35,81,218,253,120,88,52,141,44,111,207,13,215,143,168,115,74,107,20,171,18,185,101,236,63,117,19,138,229,60,108,211,113,115,227,188,44,127,154,229,179,69,57,186,2,50,83,140,40,232,116,187,216,33,244,56,238,186,43,111,245,46,250,37,27,130,0,183,217,248,117,4,150,224,24,93,133,64,45,176,185,66,208,227,219,0,41,156,219,159,96,125,234,117,150,101,4,175,107,60,26,69,9,188,220,170,96,81,89,181,14,89,19,163,173,49,123,109,54,205,54,191,143,67,246,235,103,33,92,197,152,134,6,177,246,187,73,37,161,197,143,42,138,184,71,252,63,170,36,103,37,148,89,41,244,167,30,99,151,78,54,13,125,20,221,244,66,92,6,156,127,181,254,103,124,47,106,165,101,84,223,70,19,49,55,240,148,2,2,115,187,166,193,132,210,3,22,74,172,180,230,204,68,88,6,94,119,188,72,118,155,85,62,76,19,60,83,197,184,141,59,193,25,131,65,74,236,128,32,0,148,59,31,208,149,125,53,241,234,128,74,136,29,168,250,231,66,105,118,174,58,1,224,139,180,89,133,63,28,2,110,40,35,1,19,94,151,19,250,240,183,6,179,228,132,194,189,107,23,134,50,16,3,238,186,67,232,208,49,87,79,57,16,126,195,239,121,80,139,91,97,96,100,2,113,88,59,67,157,166,173,8,96,176,133,144,154,134,61,184,110,197,68,252,123,189,5,47,142,34,253,197,70,242,155,169,196,140,142,119,254,74,187,160,116,146,227,112,241,58,30,26,54,180,179,197,233,12,224,18,44,90,164,243,208,6,212,18,227,84,204,250,95,81,22,247,230,228,154,197,205,116,0,233,75,250,36,153,237,126,94,100,105,138,77,125,251,179,0,62,82,179,140,89,250,242,167,178,134,186,21,162,173,159,109,65,251,250,94,158,118,134,154,190,163,57,123,89,122,162,179,201,111,202,190,58,124,194,43,216,168,32,12,139,110,174,60,75,201,154,78,111,35,109,6,171,149,104,151,196,107,233,171,175,136,141,136,24,7,247,139,145,30,80,170,216,165,249,43,40,15,104,168,106,29,66,150,220,79,5,13,127,87,97,144,248,130,121,10,13,166,187,194,52,8,205,106,199,163,30,200,22,155,4,71,213,62,4,12,217,252,141,9,106,42,2,113,250,47,75,7,232,48,14,227,17,121,234,191,161,3,5,142,94,107,49,173,86,89,218,216,165,118,213,255,24,83,104,71,191,110,145,235,20,111,112,38,191,70,190,84,60,35,135,236,162,185,179,171,25,2,150,62,212,171,189,250,23,224,133,60,229,178,162,213,77,53,22,147,54,77,110,140,144,43,126,114,171,40,144,43,237,96,163,79,140,61,6,61,62,58,55,122,250,157,17,35,225,236,51,26,38,172,142,237,151,13,155,187,246,243,240,57,12,171,140,247,24,129,229,155,34,142,157,141,175,54,2,223,62,62,11,239,33,78,206,142,198,244,240,93,126,166,54,180,60,225,58,121,190,44,18,189,143,57,111,84,246,94,27,233,86,70,110,204,145,117,217,120,114,111,206,108,217,118,200,107,118,114,174,196,47,112,229,166,203,213,97,188,207,170,16,37,124,222,95,249,49,240,167,254,162,50,3,238,62,69,74,181,56,195,112,234,93,53,143,78,176,118,166,229,93,189,41,216,141,139,117,45,72,28,113,21,17,181,136,168,87,225,189,58,239,132,198,162,204,38,197,10,135,232,31,186,218,187,37,36,65,241,34,48,65,179,3,212,143,242,128,12,101,176,194,132,136,206,144,2,171,180,242,143,5,39,11,47,173,228,247,134,146,103,71,162,2,193,104,101,213,159,98,142,251,15,207,142,143,136,239,213,76,167,46,129,35,142,91,223,96,90,161,76,248,186,237,193,111,160,117,233,226,228,194,77,120,249,140,23,230,241,83,150,223,95,106,125,58,199,214,195,243,187,97,240,118,230,206,152,230,242,96,126,84,18,78,32,18,155,248,154,3,243,93,45,41,77,136,169,215,253,136,240,24,60,124,28,192,215,145,221,17,209,212,116,55,86,149,217,61,174,154,239,209,166,237,130,170,51,200,142,49,254,241,72,250,159,175,130,240,209,186,73,186,167,15,62,252,253,13,83,180,146,88,242,251,98,206,189,83,196,21,43,241,174,184,182,131,218,14,180,56,126,190,239,66,10,205,113,225,225,206,128,198,8,163,202,52,187,126,183,217,211,166,251,67,236,42,38,13,205,118,80,152,236,160,233,254,98,190,243,122,65,69,57,160,95,245,55,79,114,142,84,243,224,93,55,3,250,140,182,101,29,53,58,150,201,112,175,5,63,215,25,226,52,81,178,29,60,226,22,243,246,125,36,251,194,18,61,27,254,86,98,139,115,128,5,14,0,12,107,49,17,223,134,240,9,57,31,152,248,180,51,171,209,220,15,135,30,186,23,55,166,95,16,142,42,5,243,252,250,66,72,171,4,33,129,115,56,64,64,58,179,175,135,200,221,126,140,217,171,64,234,11,159,183,234,222,194,110,11,0,121,67,40,57,253,249,59,84,243,194,240,222,35,93,164,173,99,225,49,161,228,23,65,84,45,174,243,78,217,111,55,24,29,200,137,76,153,79,235,140,195,120,160,57,128,93,197,35,83,114,60,210,40,230,27,99,137,40,122,202,6,169,14,121,200,113,19,112,33,245,120,43,162,90,225,204,192,171,129,15,187,111,39,43,72,67,148,196,124,244,37,4,225,97,247,81,61,234,85,35,102,83,84,173,93,234,121,132,66,215,113,66,141,3,105,51,103,107,144,37,13,15,137,130,5,10,213,88,205,237,178,164,63,40,213,209,94,59,197,151,184,23,248,240,235,173,182,110,182,35,245,22,157,100,93,109,80,140,77,121,155,219,255,192,151,244,98,213,134,229,4,104,48,58,44,177,210,144,197,45,234,140,161,97,38,110,192,9,124,107,170,204,181,164,204,33,101,46,149,148,46,87,185,18,21,109,115,68,95,166,230,20,30,12,127,44,104,159,242,1,110,10,156,138,180,196,81,194,49,155,254,173,225,5,69,204,32,114,36,238,28,82,8,233,191,90,184,8,215,33,100,16,94,131,130,34,127,80,116,3,252,57,32,224,224,117,208,114,192,243,2,67,195,122,199,126,214,252,145,122,175,182,122,146,123,29,8,134,242,42,155,144,176,46,19,159,211,40,73,42,193,10,69,140,212,185,32,66,232,145,121,192,1,7,49,191,250,154,137,168,32,7,36,86,166,207,100,129,107,5,41,65,140,102,243,197,4,104,239,212,94,9,174,8,191,233,174,101,80,232,182,44,122,212,186,239,145,132,107,236,145,238,186,200,40,70,45,11,134,207,54,219,170,83,107,74,147,174,16,175,204,165,127,3,110,105,129,93,142,85,237,37,132,27,228,164,20,17,69,189,52,55,240,171,230,128,103,173,87,30,81,196,10,63,13,121,19,8,87,19,22,168,56,248,57,34,248,28,97,9,197,134,62,103,107,224,103,109,208,98,215,163,226,27,186,107,91,183,199,144,180,54,87,180,218,169,88,135,73,237,5,130,219,40,60,238,45,218,30,143,204,114,222,148,67,221,60,107,3,163,133,30,244,53,208,243,21,113,117,147,86,56,42,227,139,211,50,72,229,54,45,203,16,251,128,87,160,52,144,32,50,69,53,133,93,140,228,247,155,193,255,15,11,49,172,9,216,11,30,187,40,166,178,3,107,129,24,8,250,54,186,57,110,36,133,7,168,217,49,39,231,125,246,202,114,158,206,166,151,113,46,146,251,200,66,198,85,23,23,96,77,1,210,8,81,115,52,127,143,204,73,28,78,100,111,252,140,135,186,238,78,34,23,13,240,214,164,244,186,43,177,202,247,36,144,238,108,4,155,203,231,35,240,17,183,76,80,26,130,80,199,242,230,145,107,246,252,81,181,24,205,74,93,235,70,136,13,106,204,225,227,137,224,74,27,63,154,56,176,212,176,74,179,38,20,82,228,174,166,4,77,165,54,154,168,170,96,209,180,28,68,139,237,186,115,212,3,22,159,177,201,213,7,89,143,208,179,142,159,63,147,196,184,50,179,18,156,25,182,175,47,243,228,46,10,22,18,95,207,138,234,91,157,89,213,48,250,111,217,140,154,211,87,163,92,62,181,98,157,225,186,94,206,32,72,98,145,198,174,171,248,74,74,129,166,192,157,172,103,51,251,36,246,118,197,8,190,107,211,105,160,78,133,185,77,41,249,192,162,119,35,121,42,251,231,8,225,188,36,37,110,3,0,242,171,71,120,0,132,40,180,230,68,152,10,41,197,46,20,187,108,132,154,196,236,200,242,255,133,93,205,230,189,144,166,181,179,211,71,88,184,125,129,162,222,110,157,208,44,113,167,143,212,142,184,120,255,112,157,23,74,96,121,183,194,175,232,10,229,199,190,167,226,255,158,142,202,222,152,172,223,207,127,133,178,149,165,135,242,92,152,236,202,34,65,124,46,232,130,232,122,242,175,187,252,179,180,73,75,88,180,0,252,41,216,232,98,85,225,201,89,150,215,109,200,19,74,254,203,22,147,82,128,255,53,119,252,187,172,233,93,40,226,6,86,153,20,248,129,7,134,9,117,130,29,87,198,122,189,117,246,186,24,238,119,170,65,213,101,109,176,5,6,238,204,250,210,215,40,37,158,72,76,128,21,107,62,23,195,74,51,7,21,183,177,134,165,51,244,28,136,83,26,144,223,68,140,156,44,61,131,69,133,207,73,145,183,159,56,88,39,108,211,229,183,22,145,148,214,56,47,208,150,255,73,193,155,145,61,58,170,248,80,148,124,120,2,52,101,75,171,39,87,237,48,62,39,184,187,216,5,12,61,7,90,245,84,162,105,212,87,151,42,153,219,247,38,152,236,79,133,216,45,8,28,234,164,20,185,40,14,135,125,107,62,254,99,175,39,254,95,104,96,95,98,158,81,245,69,56,152,86,160,228,198,124,176,99,223,148,184,238,192,5,170,32,187,17,150,142,67,50,170,91,174,27,18,102,127,198,112,79,164,6,189,167,51,50,27,252,131,49,74,117,73,114,119,229,123,243,32,86,213,12,122,212,144,250,116,127,138,241,10,39,207,205,86,34,241,121,26,91,168,192,17,14,63,172,34,189,37,88,49,113,29,29,128,70,244,230,116,160,68,21,207,102,222,0,172,238,214,198,193,185,198,21,16,87,52,163,133,160,100,221,170,188,219,105,187,191,4,6,66,53,160,132,190,138,106,226,180,22,193,199,61,174,80,155,182,52,161,8,78,148,178,139,29,45,237,48,18,76,211,143,18,197,168,144,201,94,242,197,181,125,142,164,173,247,142,119,6,37,53,250,135,41,22,38,10,22,64,251,38,89,208,231,250,165,94,11,216,23,7,201,239,223,51,214,94,244,185,71,132,255,66,72,238,176,185,135,117,38,107,123,234,148,66,167,216,4,79,255,117,108,118,214,171,56,53,99,107,93,155,113,234,18,147,135,248,209,211,60,195,134,124,110,202,138,250,181,172,6,188,173,225,239,50,215,254,4,119,169,14,73,56,64,221,157,182,206,148,86,248,84,235,224,154,19,176,204,171,150,76,14,229,33,211,21,59,250,37,107,223,96,152,255,25,146,12,12,103,5,228,154,159,226,168,46,181,109,146,241,194,178,34,144,9,69,91,115,181,67,71,21,190,15,163,91,68,147,20,126,166,33,9,146,65,216,195,207,147,100,50,134,233,168,248,5,215,191,115,17,43,35,207,224,48,149,0,49,216,20,68,176,165,179,79,229,180,205,108,169,215,2,101,99,123,112,180,88,196,175,124,69,168,75,73,169,254,191,5,247,180,93,36,165,89,168,135,57,178,8,125,141,214,186,245,128,43,17,71,158,186,52,112,137,127,3,223,197,179,183,90,140,39,143,112,237,30,147,33,28,228,215,113,170,81,157,134,120,40,222,23,55,23,210,5,157,225,150,87,73,51,58,46,31,32,129,181,21,18,193,180,248,161,242,251,119,20,102,46,166,248,198,62,216,87,158,150,59,160,133,219,72,36,213,158,44,251,162,177,57,129,127,206,150,169,60,255,19,108,176,242,138,64,61,193,4,240,125,0,101,113,73,200,243,229,105,212,156,4,225,235,21,2,129,146,198,2,212,57,143,13,157,45,29,79,206,92,73,22,184,36,106,180,65,229,27,130,89,229,48,73,153,251,165,230,127,113,20,94,148,250,26,230,23,194,250,176,180,0,94,156,37,69,163,198,233,204,170,115,18,43,205,21,249,48,93,74,10,203,12,180,107,79,30,90,226,108,218,103,8,196,221,17,131,156,184,69,116,225,236,92,133,70,212,2,106,244,31,34,14,79,10,20,114,129,31,38,126,245,223,141,220,130,223,80,8,195,173,129,15,19,203,95,82,122,127,134,120,134,44,168,128,67,111,130,82,50,63,0,168,161,94,76,167,216,72,89,148,45,248,6,26,229,36,116,228,234,29,200,191,108,197,105,222,207,24,36,178,73,106,122,118,168,116,145,179,116,0,198,104,173,71,157,19,67,4,119,35,43,76,166,229,43,11,8,176,106,223,108,184,155,72,215,139,89,201,158,234,129,89,241,65,190,77,155,136,38,119,180,118,61,115,11,16,172,23,1,96,23,116,45,232,207,123,229,98,224,114,98,20,55,118,71,137,31,186,140,218,139,204,221,255,10,155,30,48,121,58,169,15,136,61,41,148,241,16,48,221,53,254,152,137,200,219,53,66,158,148,106,114,228,205,13,20,8,134,239,81,72,86,58,2,44,131,10,240,92,229,153,100,67,102,6,193,63,224,5,160,210,178,84,190,235,168,18,191,232,16,5,149,83,124,147,66,131,220,47,21,175,109,154,249,99,55,89,37,62,18,173,175,137,60,67,77,183,248,4,5,233,116,19,93,129,177,147,74,98,132,69,181,214,24,130,153,55,234,87,197,113,10,141,88,240,176,115,39,84,147,46,69,215,111,24,218,15,190,55,121,146,147,228,147,203,130,247,169,159,46,193,227,98,98,37,137,189,197,179,210,17,32,132,99,234,104,213,220,238,225,205,77,182,231,105,112,117,3,67,85,177,204,236,37,143,20,117,104,81,98,135,35,27,68,63,96,117,60,204,61,83,48,234,218,74,217,252,64,224,238,171,59,207,116,254,166,198,97,106,49,244,100,106,20,99,221,37,145,66,6,241,13,8,61,123,50,146,19,247,69,143,173,59,192,153,194,59,177,187,9,194,192,151,227,172,174,37,98,132,0,188,20,140,73,40,89,65,111,31,64,141,108,27,38,100,206,68,93,95,73,31,1,131,192,23,61,183,17,43,180,128,118,14,13,203,227,250,174,142,0,127,254,210,181,118,87,185,21,104,212,29,235,124,157,148,205,49,81,58,181,37,225,244,205,18,185,146,200,17,177,20,131,154,233,27,84,60,160,36,127,219,74,20,105,170,200,45,101,19,69,222,121,22,220,56,68,3,126,194,99,185,53,143,93,6,1,193,116,183,56,101,131,102,186,92,233,149,223,212,12,58,137,154,23,140,215,204,165,45,151,226,42,139,52,131,171,239,218,235,145,57,66,250,49,241,141,55,167,96,62,212,220,30,105,190,141,176,248,128,240,24,31,200,250,156,203,232,243,41,107,233,195,40,146,161,249,134,9,54,175,158,246,25,171,168,10,60,159,16,165,80,168,98,235,179,116,217,48,216,231,158,62,146,75,87,149,76,27,198,207,194,164,240,31,123,96,185,255,184,203,219,80,159,39,201,216,72,194,161,92,127,231,170,55,161,204,228,129,134,184,248,149,233,167,5,119,173,96,158,51,43,223,210,132,144,89,29,235,77,218,215,169,245,240,131,118,239,255,215,141,122,205,216,51,183,205,149,122,190,174,188,244,50,223,16,9,168,97,184,209,52,234,191,128,191,210,131,195,180,236,163,22,35,89,250,189,140,226,14,67,161,154,21,202,169,88,9,112,49,115,191,109,186,87,17,51,34,124,21,57,163,206,13,24,202,158,64,60,26,171,196,236,62,58,77,223,252,50,233,172,221,17,67,20,203,29,71,148,117,150,101,234,240,19,79,139,211,164,184,124,226,136,125,168,245,6,92,54,130,138,70,97,71,92,222,37,217,12,232,131,217,91,205,29,166,82,100,249,101,51,214,129,40,77,128,2,184,91,166,197,170,164,158,199,255,83,74,119,162,208,150,15,76,72,126,104,106,128,210,253,171,89,40,61,90,217,44,5,20,124,140,224,86,249,209,20,207,56,88,245,6,3,113,96,35,211,121,252,243,66,141,170,172,162,164,60,189,233,183,78,190,147,35,110,158,200,137,60,243,179,174,38,156,174,164,221,254,22,254,144,42,250,225,27,29,203,40,120,240,29,184,14,94,0,218,198,192,151,145,117,13,219,90,163,199,69,107,120,132,226,93,26,2,158,103,163,93,47,100,1,2,64,99,137,66,28,36,41,143,112,51,214,118,45,110,247,198,186,142,192,242,106,121,201,193,144,251,63,233,156,4,59,136,234,153,58,151,127,200,215,22,181,213,164,103,218,250,217,131,178,74,56,145,74,163,113,229,181,222,34,250,156,187,34,128,223,202,253,18,217,191,13,233,130,247,52,97,1,221,168,167,237,225,141,87,96,69,59,253,137,51,79,214,113,241,160,232,148,236,177,223,48,197,156,136,236,193,145,182,183,187,197,20,167,40,223,246,109,146,195,148,248,96,12,18,145,145,74,201,62,62,246,80,37,0,56,208,51,224,171,247,211,27,115,68,80,4,27,224,201,150,177,213,248,70,24,153,109,254,128,38,244,131,240,52,35,167,80,125,193,131,69,74,207,187,115,48,146,59,123,96,44,152,35,47,151,245,75,77,150,192,247,95,4,178,226,89,140,148,206,79,9,0,243,173,68,235,128,159,186,30,179,178,97,243,180,71,147,99,21,15,27,47,107,43,210,31,100,135,214,104,211,63,93,99,51,200,239,211,22,24,27,125,162,215,107,187,39,91,38,96,7,30,164,38,157,159,229,69,182,1,125,8,245,239,137,72,28,240,233,45,243,218,132,64,235,255,135,201,197,122,2,37,238,81,254,205,248,181,202,227,109,112,57,233,183,252,106,236,46,108,37,126,104,31,99,205,51,145,29,130,239,220,228,239,97,155,176,35,109,164,45,201,97,38,28,40,166,8,185,36,208,20,221,224,144,87,20,43,29,179,88,161,229,238,186,139,91,14,31,186,66,207,150,117,32,182,55,233,29,68,136,234,203,206,117,214,78,57,190,178,84,219,131,167,155,71,188,135,247,244,232,198,224,138,99,232,162,52,82,245,254,186,237,119,37,80,94,34,134,87,141,24,223,206,254,50,197,141,122,235,215,61,252,177,125,249,46,239,147,247,8,202,246,147,42,36,173,74,154,130,190,12,3,72,39,254,0,70,54,196,191,82,73,219,167,244,200,249,127,83,98,37,175,245,237,187,204,206,126,42,21,24,26,79,77,5,47,18,139,169,0,96,228,180,32,107,39,176,47,247,177,227,20,228,55,45,108,153,71,200,88,87,76,246,212,32,65,234,50,37,210,10,108,228,7,33,206,40,201,45,244,237,57,224,164,46,104,13,251,187,196,67,69,47,26,34,229,156,62,222,70,13,14,62,236,102,50,107,144,225,158,71,167,117,51,246,74,239,255,15,94,75,183,51,159,153,153,128,217,112,126,174,163,37,248,146,36,23,234,206,87,244,103,51,75,69,74,105,198,40,193,15,1,3,225,1,141,30,70,3,40,25,245,131,217,41,86,120,67,214,115,168,55,239,84,209,36,31,20,140,39,30,3,70,190,92,13,144,63,81,40,55,191,215,20,255,22,225,156,239,254,226,200,228,64,118,142,236,180,126,112,11,2,207,241,70,80,49,100,145,226,53,188,152,145,119,75,202,161,3,243,148,229,194,14,140,164,25,44,254,252,254,218,27,124,93,24,137,208,202,56,180,153,13,162,142,241,1,160,189,188,203,39,223,61,141,186,151,107,15,23,134,2,54,105,29,38,90,20,240,223,65,99,212,139,52,93,159,41,17,74,165,112,248,40,186,201,180,194,4,87,123,51,157,203,41,181,224,161,107,62,125,243,244,168,247,70,223,159,170,61,239,166,155,202,147,11,61,246,172,7,216,185,250,138,192,99,25,73,209,164,130,5,149,73,172,76,191,16,98,216,168,95,253,157,23,148,152,44,78,68,225,61,195,208,197,156,18,51,22,81,9,233,196,45,16,227,102,212,246,193,141,91,147,17,137,196,10,168,116,95,189,21,120,253,27,254,233,172,25,23,87,250,249,220,161,77,80,252,56,33,55,47,59,136,243,156,85,203,113,255,20,150,153,122,202,75,113,181,9,175,70,9,234,30,133,35,71,195,74,20,231,195,20,53,61,90,73,77,77,224,43,89,40,178,116,130,90,229,13,183,80,73,81,140,46,47,4,148,115,236,214,211,170,96,77,147,14,167,161,230,84,224,158,111,29,75,212,199,73,181,200,244,24,213,132,51,224,155,218,248,207,123,206,227,40,50,241,132,174,197,81,9,235,39,8,181,67,101,127,29,4,146,142,129,39,101,120,126,171,237,24,93,25,114,159,50,152,139,57,159,242,119,25,100,237,192,116,158,20,208,194,78,102,224,100,137,30,124,241,87,133,132,170,128,87,117,232,218,191,190,105,176,147,8,70,150,1,135,101,130,42,175,226,23,195,139,234,151,236,63,45,153,161,67,95,117,122,92,241,17,251,189,150,207,206,56,4,123,51,227,198,64,123,179,179,3,44,230,231,53,3,149,161,63,0,242,195,27,132,150,73,133,12,203,141,235,9,54,57,229,225,196,86,182,17,238,237,31,145,200,241,95,28,92,28,247,95,40,249,146,230,93,251,182,243,30,255,9,65,72,42,236,69,107,126,47,206,134,198,167,123,100,146,116,155,98,76,46,163,37,185,216,124,189,70,6,103,131,189,248,216,72,28,194,201,87,60,195,8,27,60,201,202,206,197,116,31,38,190,212,26,213,239,159,172,176,0,67,7,220,247,114,56,35,35,84,79,117,88,105,143,167,43,105,10,197,47,84,244,108,144,159,193,35,95,0,59,100,121,43,35,153,3,97,54,164,79,33,88,88,199,56,246,11,234,251,231,139,141,82,76,90,154,86,21,182,178,191,226,175,162,213,82,47,98,95,33,228,9,88,148,203,92,99,115,70,22,101,123,6,160,175,203,23,196,18,130,101,166,29,27,205,208,61,43,25,216,230,216,245,75,196,199,216,146,153,184,13,107,37,192,248,145,193,201,124,90,39,60,18,87,186,42,83,183,150,226,219,190,22,112,83,208,6,226,254,166,24,60,139,225,10,183,224,219,229,218,101,228,128,224,100,94,115,129,189,195,215,190,122,64,226,217,186,4,121,175,209,192,1,210,246,155,222,210,106,197,84,42,184,4,26,206,101,127,18,27,170,185,41,94,70,139,58,186,6,6,171,21,126,137,137,122,136,188,210,109,124,106,133,145,142,202,26,207,183,113,148,12,75,190,105,39,184,3,178,237,70,246,32,246,128,221,41,241,156,207,48,83,178,63,222,41,135,217,1,17,101,120,4,87,63,133,209,211,241,75,153,233,9,86,81,67,150,235,130,121,97,187,200,168,252,5,73,61,177,38,232,234,211,0,14,73,251,29,244,227,229,131,35,202,29,234,228,116,143,123,130,215,19,128,58,206,15,95,171,200,90,96,189,127,15,133,95,72,218,138,195,128,187,61,45,232,19,11,44,90,69,70,32,106,169,185,202,250,146,31,48,78,127,161,11,235,201,211,91,179,169,24,121,227,77,96,251,174,78,211,209,129,66,69,124,54,192,206,212,38,135,127,179,190,47,79,102,170,154,247,161,189,64,59,121,189,159,114,57,15,162,13,126,206,167,232,43,2,90,57,216,21,10,95,54,207,143,74,128,17,53,47,150,100,229,59,71,21,112,121,239,41,147,17,153,101,194,42,233,36,221,179,37,72,115,82,229,49,31,159,78,114,58,37,174,38,215,13,87,129,12,144,230,64,110,147,114,164,73,143,5,124,116,199,30,197,202,135,230,7,139,76,78,13,191,224,31,9,20,71,129,88,220,167,118,133,12,63,80,195,12,165,226,181,9,33,110,129,205,230,11,121,3,142,162,205,174,93,215,171,33,104,78,50,140,31,216,100,42,38,13,222,2,20,192,55,231,144,83,42,133,55,213,88,139,132,219,43,125,157,49,179,23,40,5,124,55,243,194,186,120,32,53,11,224,237,206,28,104,15,32,56,94,40,203,8,103,201,6,207,141,65,145,36,68,59,204,72,224,197,132,132,26,54,254,246,205,112,149,189,128,87,205,233,170,93,41,224,34,94,252,50,184,252,171,218,54,20,254,235,97,212,204,22,71,98,204,18,109,223,148,102,182,204,73,58,229,114,96,164,27,126,241,214,172,151,191,242,219,5,132,51,19,107,158,130,70,228,118,119,116,73,131,150,171,108,79,35,94,35,11,14,65,94,143,111,193,45,5,164,6,78,175,16,117,199,136,144,94,119,121,127,204,219,90,111,120,254,214,165,191,215,147,177,113,194,43,36,44,51,229,208,178,35,12,65,43,108,188,2,101,190,113,67,107,131,178,160,227,73,49,230,187,134,199,53,207,97,197,168,83,51,169,33,246,80,215,56,168,160,190,36,174,106,177,62,153,51,139,49,87,121,75,245,227,89,12,88,252,118,101,39,6,35,170,79,141,219,236,206,224,56,188,32,128,205,224,246,131,92,151,246,237,120,211,224,127,96,50,77,98,193,41,107,207,250,107,27,144,173,40,54,94,166,8,251,35,41,75,18,26,4,158,65,55,46,113,108,226,148,134,6,187,86,108,89,121,71,16,20,179,205,30,231,201,48,64,207,214,194,45,233,246,66,4,74,12,30,231,247,58,144,162,90,198,197,91,103,153,246,151,23,193,174,63,192,133,117,80,229,165,94,62,18,159,234,5,5,81,250,45,114,166,227,103,16,129,228,37,113,227,194,172,25,151,103,44,66,184,247,14,117,12,139,81,189,14,198,99,138,50,146,102,158,225,228,113,3,33,41,55,132,232,131,54,153,106,120,136,175,61,161,120,175,212,250,72,140,223,168,147,243,58,243,116,151,50,8,244,246,114,233,132,150,30,137,218,163,188,190,185,12,123,52,171,123,210,46,182,27,217,251,231,255,110,5,41,106,228,202,99,129,79,55,55,96,113,186,151,117,255,37,188,106,26,69,214,194,29,34,158,26,115,38,19,223,21,75,184,19,255,2,39,44,136,99,22,176,18,122,200,40,202,166,230,165,12,137,199,186,185,244,48,151,34,60,73,130,212,101,227,151,212,69,141,12,246,70,156,145,237,228,239,207,211,115,220,71,0,230,86,29,1,108,232,8,238,136,227,8,28,156,30,21,137,202,30,93,71,44,74,195,156,182,147,232,228,129,194,246,143,88,70,46,168,225,20,181,34,103,115,116,211,184,178,241,60,65,184,193,118,70,28,8,208,0,187,157,209,89,53,141,85,29,205,50,16,41,215,46,217,83,207,3,96,10,156,49,209,200,99,152,231,143,151,45,8,237,51,30,21,202,221,227,171,233,114,43,181,212,231,58,131,192,47,18,175,235,155,184,196,206,57,153,184,215,142,34,155,95,82,169,160,53,110,40,130,244,177,180,113,27,243,36,167,239,186,203,234,1,207,94,134,131,236,141,78,9,63,190,33,233,113,156,137,143,57,232,228,146,57,240,170,252,78,99,72,105,197,192,236,73,211,251,250,10,105,68,148,223,53,51,86,38,250,58,232,248,53,63,102,211,177,68,30,226,14,214,253,16,103,67,105,189,184,193,149,127,49,60,108,220,58,202,225,111,208,165,144,38,60,10,141,108,224,0,1,98,79,172,27,231,179,179,99,107,85,55,54,93,116,147,151,145,113,161,44,230,7,56,158,108,235,174,49,113,182,88,149,92,255,163,12,75,165,67,178,105,143,121,46,254,99,201,205,130,21,192,153,58,97,145,217,224,29,88,132,98,156,145,105,252,58,86,168,176,18,59,238,121,9,85,147,55,219,196,101,155,210,244,193,204,71,225,130,61,116,68,183,129,15,189,184,192,240,207,61,91,148,140,113,60,208,133,181,117,145,132,98,22,118,221,171,177,60,160,126,103,104,91,194,82,58,0,3,53,104,16,203,93,35,72,49,181,115,195,168,32,70,206,212,172,89,55,145,169,34,79,151,29,189,145,144,43,178,114,25,104,226,111,115,53,142,56,199,105,222,172,100,125,221,99,60,89,126,50,115,109,165,221,104,83,95,203,252,130,101,214,220,11,121,17,162,161,231,88,118,78,24,199,26,182,241,147,144,67,215,33,141,5,30,158,32,26,80,98,74,249,27,200,120,92,231,163,243,33,72,149,175,10,194,25,189,181,233,145,194,99,249,98,45,48,8,210,47,247,4,198,130,31,254,94,163,38,32,68,197,35,223,80,229,237,214,22,216,143,51,5,31,156,226,59,156,212,165,251,155,33,211,25,235,182,54,59,237,37,115,1,254,244,209,245,224,36,58,186,225,8,46,60,78,13,109,69,17,83,158,227,216,48,125,62,76,189,195,61,222,131,175,250,235,47,35,186,148,40,75,61,8,177,251,160,90,28,48,89,7,87,118,175,3,116,194,107,16,209,189,102,41,106,249,139,109,193,197,91,75,121,90,46,235,137,105,5,189,127,123,251,244,139,160,172,130,36,138,230,243,17,193,106,72,218,96,40,227,170,43,70,159,196,94,52,252,118,98,142,81,206,169,58,87,166,239,19,74,28,19,77,168,5,160,110,202,86,96,195,101,27,175,226,230,207,212,51,175,217,169,134,236,221,30,173,210,61,40,205,66,14,67,162,241,102,225,197,171,7,109,112,152,41,91,37,186,78,176,82,96,58,137,61,140,162,242,56,205,59,74,153,220,51,142,150,85,94,204,148,181,42,184,191,246,36,147,111,95,58,65,110,250,222,62,107,48,224,232,76,241,230,208,172,189,217,171,123,231,61,218,88,133,212,149,13,9,80,129,249,249,181,206,185,132,32,58,249,76,222,233,128,113,243,76,17,41,216,203,96,123,176,108,170,129,206,9,92,8,152,122,36,50,163,55,94,33,176,239,181,167,221,50,178,241,7,87,156,74,250,45,77,98,60,110,153,213,214,33,54,41,225,145,204,152,208,153,177,61,220,163,19,153,202,127,143,148,212,128,86,29,125,56,129,124,230,82,93,110,58,119,119,132,234,113,170,96,31,142,212,144,132,168,192,168,247,9,118,193,210,118,35,3,189,41,57,193,103,228,108,1,62,101,149,79,53,191,134,184,27,42,161,70,172,26,101,149,28,53,2,2,198,50,126,103,48,200,138,55,66,187,116,2,67,10,193,87,141,254,241,47,176,145,85,63,130,197,184,116,50,39,4,84,50,219,202,89,204,123,31,255,254,87,45,67,22,174,254,241,177,27,179,163,190,104,110,242,170,157,237,78,180,72,76,49,248,181,109,52,113,2,177,56,73,241,125,12,85,12,42,13,91,228,141,158,31,128,56,8,192,24,132,217,83,153,211,4,229,37,83,206,243,13,98,3,58,44,20,83,237,160,55,23,51,164,190,55,19,13,153,245,91,153,113,174,251,87,250,29,59,253,52,236,83,189,168,197,114,191,83,10,39,139,20,77,37,136,133,12,104,175,144,78,224,221,139,188,28,68,29,132,211,75,99,107,55,16,242,226,62,69,109,206,83,34,5,219,213,101,234,208,121,200,37,218,146,98,255,224,72,212,191,216,121,174,132,14,115,220,181,225,42,161,249,151,147,21,202,210,83,98,55,166,137,44,54,53,129,202,244,220,0,178,48,29,199,88,205,227,168,155,76,139,225,4,103,47,241,14,237,116,207,26,42,219,135,122,131,242,194,1,31,205,163,119,189,131,66,97,11,35,70,64,41,125,88,48,144,183,65,24,43,181,39,181,6,146,101,28,158,136,224,177,51,162,197,158,175,53,48,181,36,81,87,150,215,154,190,38,173,15,232,113,188,86,140,133,218,8,81,128,52,144,158,238,197,240,121,198,212,65,166,128,208,236,236,139,214,105,7,185,104,116,173,52,212,135,241,69,126,82,206,14,91,44,35,70,128,53,191,199,155,38,237,75,249,92,47,20,202,13,97,26,213,246,125,242,159,230,148,132,93,153,35,100,135,89,88,87,84,156,85,89,139,97,80,100,231,232,95,135,8,129,149,243,51,25,160,111,81,173,95,33,136,187,226,52,177,109,158,231,135,23,226,171,61,170,90,24,43,246,251,116,54,49,55,77,105,219,211,121,153,157,114,149,55,113,141,11,79,195,61,54,12,106,56,196,232,152,80,120,176,48,30,194,118,23,78,150,180,166,49,11,83,42,108,136,153,83,186,170,13,93,11,39,175,20,62,103,154,65,99,114,172,48,122,220,112,7,94,11,181,231,42,255,72,221,26,13,190,110,154,154,51,169,87,244,16,134,157,178,107,66,95,218,54,163,149,70,112,147,91,186,78,243,188,224,116,170,40,146,129,93,26,217,208,195,183,229,180,0,86,62,99,191,253,230,207,211,128,34,189,134,234,70,125,201,36,46,7,189,236,238,84,6,5,89,72,191,213,242,148,59,86,45,220,197,42,96,150,121,30,6,162,172,13,85,129,119,40,73,158,192,133,95,239,154,4,224,120,203,162,14,155,11,148,152,133,171,34,108,156,69,195,25,14,41,4,164,53,127,22,226,211,141,128,76,214,65,37,252,23,230,112,107,18,219,25,197,29,199,243,73,35,8,34,93,60,103,67,196,231,170,80,92,249,74,21,242,237,62,65,115,33,28,98,255,78,242,194,18,184,177,59,243,48,128,138,60,160,80,251,250,98,25,141,141,5,82,102,141,178,198,188,117,241,95,232,241,95,94,218,89,132,19,237,151,95,7,253,9,211,179,250,240,208,93,213,113,90,234,237,39,66,194,13,89,160,199,28,189,125,119,194,67,97,111,185,34,200,184,47,151,126,120,1,205,81,133,34,164,61,125,11,0,220,85,236,170,158,203,108,203,161,186,247,163,185,72,53,176,157,85,63,27,175,175,174,205,152,27,219,62,78,139,14,189,240,25,212,27,108,175,61,172,143,182,98,100,114,79,226,112,205,227,65,104,121,104,101,89,213,149,149,242,165,46,10,235,168,166,159,41,72,59,46,248,252,132,166,86,89,212,90,250,226,136,131,244,112,88,153,169,242,152,62,147,105,218,213,218,127,93,35,99,182,210,195,215,20,80,251,99,241,117,228,151,121,35,27,66,167,89,63,28,236,246,115,237,109,242,246,202,204,84,36,234,16,119,195,175,99,35,5,235,201,179,225,228,204,57,47,232,251,127,33,234,202,137,226,5,19,137,92,91,45,153,190,5,195,145,238,127,155,24,221,141,219,55,192,146,160,85,219,23,44,84,203,80,80,214,222,186,116,81,237,176,193,198,2,53,89,98,150,4,102,208,12,4,76,119,246,252,146,100,244,157,76,132,147,163,2,19,19,168,94,44,174,249,115,92,53,70,191,37,190,117,6,138,179,8,244,210,217,185,55,12,122,101,233,114,93,44,201,212,89,103,202,137,105,205,206,170,94,233,46,122,215,189,240,180,27,189,247,14,86,82,157,79,13,218,199,203,243,122,26,195,65,42,142,255,253,164,72,126,18,175,86,25,129,188,172,168,0,33,71,65,251,4,219,67,25,186,81,4,155,200,119,171,231,123,68,24,48,249,236,189,156,43,43,131,48,84,174,185,123,254,128,162,236,168,229,40,78,158,234,111,139,68,62,167,215,59,49,16,37,80,206,96,8,179,6,149,86,243,131,236,1,122,42,152,73,107,35,68,216,14,0,158,60,182,93,63,32,9,55,34,227,120,161,7,209,85,148,192,92,254,174,120,112,87,219,234,96,96,177,157,222,90,59,114,125,135,95,116,21,136,91,200,252,243,245,193,178,4,190,64,104,62,240,185,23,159,150,111,255,59,75,77,246,232,157,228,87,24,51,104,232,213,167,144,246,207,160,191,18,19,198,211,202,4,208,179,235,157,52,218,186,252,44,229,172,9,66,211,230,52,53,254,157,235,228,243,69,98,119,204,246,128,99,43,199,123,10,231,175,137,162,54,86,214,227,210,167,185,226,0,106,27,78,142,192,105,247,22,12,83,111,64,198,11,63,241,28,192,162,221,220,93,121,25,162,159,61,63,117,19,117,46,12,51,147,245,120,85,68,122,145,22,223,255,254,148,11,213,186,12,225,93,127,139,147,40,213,198,26,50,194,115,24,222,80,40,213,61,90,76,187,114,86,136,192,218,89,175,188,24,222,73,43,14,165,169,124,2,229,177,47,42,154,34,175,65,164,29,119,145,202,153,158,25,17,11,141,168,231,111,89,10,216,89,220,71,169,159,56,208,35,24,242,52,104,15,32,149,177,249,92,225,67,238,32,180,93,3,167,116,18,98,23,252,146,253,102,30,101,95,154,59,112,248,135,221,119,147,8,116,182,104,167,204,65,80,113,83,152,210,61,88,124,67,1,110,175,100,73,20,43,46,185,127,119,187,36,123,62,40,43,104,108,81,146,70,7,49,233,249,179,84,86,120,168,15,248,53,161,146,8,0,166,207,241,3,199,111,14,114,145,175,102,2,38,231,211,161,186,195,254,130,130,192,168,108,83,213,97,80,0,87,170,74,52,78,0,69,46,79,37,6,49,223,174,201,110,144,60,220,11,239,94,181,122,221,206,102,252,44,85,212,19,33,13,177,237,28,82,144,134,8,124,167,5,148,128,220,139,55,102,86,10,186,89,159,190,208,76,120,145,238,193,85,205,149,220,39,39,206,81,229,24,84,83,88,81,123,102,150,118,170,124,127,177,61,115,144,50,234,116,98,51,25,181,137,53,116,104,124,125,35,51,150,128,99,114,112,148,253,161,75,96,85,219,132,95,13,185,190,6,120,100,5,90,154,124,139,23,238,8,159,117,138,0,183,101,108,42,91,89,143,181,183,239,255,25,37,94,231,28,247,244,136,6,204,71,6,185,129,96,233,34,78,43,216,96,93,227,14,106,47,113,89,51,69,4,176,228,48,209,32,166,85,13,150,43,170,221,50,161,126,53,217,53,165,48,104,160,166,110,211,244,32,191,46,127,103,66,204,122,9,240,3,85,128,112,129,178,156,244,64,7,167,51,116,27,17,199,29,171,131,69,116,3,12,162,69,176,243,198,222,112,219,51,68,219,196,24,46,89,17,66,253,120,152,83,38,89,240,95,221,147,140,24,8,210,100,72,227,234,255,243,143,241,118,59,5,167,25,133,20,87,199,217,165,72,249,10,49,26,205,216,254,169,65,3,251,12,157,25,7,176,71,1,99,189,204,183,200,184,89,14,139,198,64,25,163,106,203,240,255,32,169,245,223,107,130,180,135,94,218,168,233,173,140,25,98,16,215,129,200,120,56,5,135,24,106,228,122,102,146,9,175,239,97,252,78,156,39,153,68,101,37,107,9,97,222,88,148,226,49,20,133,125,215,210,157,245,6,98,84,147,223,135,32,22,222,253,65,183,83,51,245,13,162,119,196,175,76,227,47,88,238,38,199,187,71,245,125,209,146,46,85,142,30,236,16,19,178,21,76,145,141,187,17,234,188,109,246,98,182,60,142,243,147,250,182,154,177,56,172,140,213,241,150,164,11,33,8,226,168,222,56,3,116,62,219,98,21,97,172,104,185,167,1,172,37,103,157,229,65,199,10,74,41,244,93,42,33,42,219,99,143,63,22,121,137,48,199,133,136,207,241,216,197,4,125,18,217,213,153,194,214,136,29,116,221,46,135,87,226,210,120,255,4,22,79,96,230,186,68,184,165,25,96,113,136,57,102,191,23,121,119,88,116,94,154,243,202,5,134,37,94,37,182,8,153,93,205,53,23,58,86,82,251,97,41,107,249,80,111,65,216,225,34,219,217,73,186,75,201,27,213,74,246,56,171,219,212,42,179,208,225,3,135,123,207,93,105,139,176,64,198,73,112,109,113,132,187,31,96,247,103,145,8,137,139,44,127,224,121,78,255,1,140,28,213,145,240,97,153,157,22,227,104,51,193,239,53,141,1,133,146,221,166,153,9,178,79,20,206,8,248,182,14,137,20,67,95,14,173,63,106,109,158,13,86,80,66,222,178,12,146,50,152,24,27,223,47,205,238,74,94,185,1,76,73,30,82,78,28,140,95,218,113,139,64,38,232,247,148,190,40,65,215,127,230,4,203,31,177,24,225,196,34,15,77,15,23,24,114,47,73,57,216,10,60,37,243,211,218,208,96,213,213,122,96,217,120,28,169,154,70,32,7,179,195,199,166,21,78,169,232,231,166,210,229,215,135,190,245,57,85,193,44,0,104,167,222,20,102,121,170,255,170,179,218,115,197,241,206,40,182,141,116,88,192,105,50,252,113,11,143,242,0,80,92,122,39,43,242,4,39,210,152,193,38,182,232,176,129,237,218,196,29,189,222,13,219,182,3,26,139,184,201,233,209,59,160,235,158,169,156,90,199,38,105,222,145,232,211,187,163,184,232,165,23,182,88,2,1,104,107,97,23,239,44,107,214,210,182,84,20,100,13,86,166,48,223,137,170,165,19,201,70,146,79,201,139,80,148,236,85,12,56,86,100,78,69,94,95,92,137,58,210,97,75,79,70,106,161,62,106,3,67,253,144,168,136,2,114,74,146,6,97,32,65,13,88,47,174,126,0,188,82,90,226,217,208,63,214,140,149,89,218,215,232,102,109,17,103,171,130,157,5,15,152,132,134,214,78,18,97,112,213,228,86,159,119,95,29,137,136,75,85,28,39,115,19,117,156,165,89,105,222,193,174,119,216,248,182,180,77,229,212,87,61,121,124,20,62,110,198,2,87,162,21,39,52,7,141,27,66,95,96,145,204,91,15,103,210,157,16,213,194,80,62,15,46,66,127,138,210,172,160,31,37,208,204,231,23,1,87,33,197,178,101,86,228,23,90,97,202,50,199,46,225,168,245,107,189,194,208,65,209,55,223,184,148,241,15,65,57,248,61,13,149,191,32,67,25,199,247,251,149,181,119,164,177,233,110,195,178,187,207,206,246,225,94,124,82,29,30,252,253,213,253,177,200,254,199,199,251,147,181,8,225,229,222,43,251,170,140,115,229,185,35,14,242,111,156,230,24,184,121,117,116,222,147,247,201,28,118,93,237,183,202,93,161,161,100,154,206,48,204,107,117,252,109,105,21,175,217,197,97,103,117,49,240,115,44,19,166,219,226,162,136,130,251,161,68,15,220,124,149,76,236,137,9,40,28,85,48,215,235,3,151,101,20,120,236,142,141,200,99,246,79,81,233,31,108,155,159,248,241,103,106,232,43,70,159,91,229,229,61,31,164,230,3,48,2,58,114,251,206,0,138,208,168,31,106,182,223,18,99,157,247,172,30,119,187,18,128,177,0,171,141,191,237,73,231,119,65,109,31,219,179,32,116,226,16,0,237,18,184,80,107,85,200,200,10,227,129,43,251,57,22,180,114,215,245,171,162,67,30,89,1,133,44,92,47,86,238,200,103,165,82,91,3,114,3,56,48,57,188,155,222,160,251,183,171,108,101,139,211,240,222,212,134,173,42,136,25,185,80,18,184,19,172,184,143,31,131,33,170,201,118,112,55,76,136,36,28,19,193,118,22,221,99,128,30,16,231,238,26,68,234,131,243,98,59,31,9,211,9,136,39,24,57,232,179,236,22,202,221,73,176,59,177,241,14,226,223,154,27,161,106,171,237,66,88,186,21,86,244,226,83,102,41,191,207,111,29,165,89,55,139,113,199,166,157,44,51,122,102,214,205,180,150,56,219,249,197,109,37,46,19,7,30,28,215,160,196,44,126,179,15,203,75,200,192,42,8,171,43,249,80,139,76,103,3,132,29,31,94,206,154,218,204,248,141,247,132,248,34,253,230,178,179,125,212,46,57,247,47,101,42,230,164,194,41,5,147,22,171,165,125,74,248,53,234,55,85,234,50,192,212,52,202,191,34,240,101,252,67,123,30,46,29,67,0,173,162,120,132,41,133,237,9,136,210,76,207,254,143,104,6,135,235,109,28,84,45,230,252,39,96,9,239,248,21,52,170,14,220,235,231,251,134,150,8,112,235,218,82,62,77,18,159,31,142,86,11,53,4,42,153,0,44,157,13,51,164,91,105,232,177,228,78,77,244,115,104,35,26,150,105,93,228,234,30,137,195,122,108,53,208,231,10,153,207,26,107,42,222,49,195,69,223,10,179,208,219,148,133,210,33,72,14,81,136,114,176,218,157,25,7,38,135,102,142,33,190,229,126,167,233,122,189,113,228,222,250,236,105,117,236,8,210,175,7,67,17,199,203,0,236,255,42,90,63,194,146,3,181,19,240,39,209,56,126,153,119,203,56,91,137,112,136,138,49,67,119,181,134,83,235,174,145,28,47,126,211,253,176,161,189,161,121,55,176,117,229,128,195,75,51,171,233,79,240,135,245,254,214,158,67,204,28,197,68,80,60,238,136,248,0,38,69,40,254,132,48,14,152,25,207,205,65,35,192,231,89,9,111,102,12,167,101,116,67,254,21,80,148,77,95,127,115,180,233,51,34,14,94,143,96,38,58,68,24,81,155,29,140,120,36,39,213,121,255,242,25,220,208,229,251,107,6,173,95,28,148,255,236,46,4,229,69,31,211,83,38,238,0,136,114,98,126,83,235,106,109,139,22,42,221,107,221,92,252,250,38,46,178,115,20,227,76,41,39,133,22,210,40,13,152,202,58,224,185,189,178,52,157,15,183,145,149,73,204,250,1,157,90,237,18,88,36,129,131,160,150,59,52,69,170,141,240,184,57,170,214,111,185,174,245,92,96,227,21,250,146,147,219,95,60,121,69,254,196,114,164,171,215,240,110,89,82,54,138,245,159,16,86,203,42,57,230,174,39,99,105,160,170,3,171,185,21,83,84,249,226,133,86,13,110,67,65,183,23,65,167,47,161,232,124,72,28,184,132,45,159,78,183,62,26,189,227,174,187,169,14,55,62,225,152,35,142,240,224,71,232,227,251,204,205,93,214,58,126,134,241,217,109,78,91,246,73,176,225,38,51,243,211,202,117,206,185,253,241,199,141,173,139,176,189,208,234,203,152,119,250,100,161,155,66,112,200,190,145,74,127,42,59,152,53,203,22,180,232,154,250,227,11,215,100,74,141,162,233,134,210,237,165,166,130,128,252,232,59,141,90,82,132,148,136,141,113,98,23,86,149,233,34,49,22,111,59,78,99,71,222,116,20,217,222,250,99,223,118,113,195,162,189,206,170,108,210,107,216,143,199,252,183,164,214,39,217,64,157,253,124,183,129,238,43,48,183,224,76,242,154,143,234,219,26,161,101,0,199,87,172,169,19,164,0,237,242,206,249,25,1,31,92,118,100,245,44,69,150,198,142,102,151,61,139,4,106,185,179,218,168,235,118,232,57,177,238,251,75,82,196,232,42,48,76,114,233,207,41,250,32,171,219,228,252,165,219,20,33,93,24,4,250,210,137,183,154,196,8,210,254,122,177,125,127,122,36,1,128,86,233,147,156,117,181,157,150,147,246,118,104,29,70,82,144,147,129,199,60,127,197,86,9,130,13,70,212,175,79,65,48,145,27,146,110,246,236,81,112,6,178,37,137,138,51,55,58,148,72,10,119,149,224,57,28,158,122,80,114,197,159,239,40,56,198,90,214,201,140,251,112,29,236,19,161,46,236,163,179,122,129,74,3,12,23,236,15,36,237,135,98,197,239,82,16,111,89,42,73,243,243,107,1,19,16,96,118,149,254,239,152,27,61,223,102,97,246,27,141,53,26,180,38,77,21,59,141,92,106,40,9,109,252,123,4,191,47,31,51,188,0,229,22,58,75,23,13,223,243,252,142,77,109,135,50,23,157,29,151,17,132,0,223,171,137,24,182,223,209,181,108,89,199,148,209,209,238,202,214,18,6,242,238,63,237,4,24,205,165,137,193,175,40,178,21,41,234,171,212,138,161,179,32,230,123,189,47,53,251,31,197,26,207,49,176,168,21,190,135,243,123,101,147,7,123,93,122,119,232,76,146,70,80,64,244,63,232,137,28,225,147,85,179,31,37,9,46,244,137,158,143,27,207,93,166,10,22,66,24,130,49,77,146,100,171,26,116,189,152,43,165,69,232,111,177,9,55,37,132,21,95,82,94,135,112,19,112,36,153,57,236,123,18,64,59,211,222,227,46,50,23,226,181,234,37,35,46,39,47,206,167,172,35,52,125,109,95,210,242,66,196,39,160,60,61,216,218,136,172,151,201,17,13,238,161,135,135,90,204,137,53,20,95,94,112,5,128,68,171,62,93,141,147,131,77,252,56,214,90,141,200,130,56,91,191,192,113,198,111,238,176,254,14,56,239,145,65,81,88,240,151,8,226,232,117,75,78,242,128,36,144,240,113,59,47,12,29,164,3,12,136,215,73,84,198,165,163,227,2,99,173,72,231,162,142,85,49,158,176,146,199,192,19,209,236,78,48,177,201,216,120,127,124,68,5,128,127,113,91,187,117,71,233,196,45,3,189,100,83,94,210,89,198,134,187,111,67,66,221,209,136,72,164,110,116,230,199,219,230,72,100,38,170,228,89,230,15,90,86,31,55,202,243,146,104,111,170,29,174,244,4,11,160,6,102,24,22,245,199,207,74,12,109,141,211,156,57,242,166,86,133,146,215,160,35,214,89,97,185,142,194,93,46,92,228,56,185,200,106,96,93,122,156,30,176,213,6,225,53,168,174,24,247,54,160,76,220,80,231,198,42,223,165,205,74,240,163,217,16,48,85,223,92,102,54,200,90,27,190,159,36,160,216,102,194,233,25,92,41,121,217,68,195,12,40,81,112,188,85,148,64,225,112,72,154,65,90,43,253,171,139,88,129,211,134,208,9,101,210,43,196,170,45,11,117,58,160,36,251,39,189,185,106,138,134,21,75,2,95,33,113,40,224,5,31,214,190,158,67,47,130,216,4,232,18,182,2,129,230,112,56,231,224,144,82,156,248,67,127,220,1,130,109,95,241,211,96,226,191,108,106,110,241,215,64,38,69,102,202,208,203,80,114,92,72,161,72,161,240,227,45,54,180,160,166,0,234,238,152,40,150,99,117,207,27,107,122,252,97,61,221,10,115,95,9,243,37,180,46,82,71,236,27,103,121,139,32,25,98,249,77,137,164,166,238,36,161,252,96,233,225,188,71,121,157,46,77,224,128,98,105,85,164,63,85,149,143,172,180,90,179,35,21,168,144,143,89,70,162,61,9,35,225,32,120,16,89,156,221,5,152,99,185,244,187,198,196,49,250,2,149,124,33,196,76,77,104,204,141,246,173,202,170,63,108,243,104,91,132,13,17,154,192,207,224,94,92,134,220,209,83,227,90,149,96,158,106,119,74,237,114,204,191,112,156,40,166,202,126,81,60,247,247,85,108,153,6,94,0,96,142,189,167,21,55,66,142,39,230,102,30,158,99,203,2,1,156,189,137,221,146,218,25,231,100,244,68,238,128,178,197,75,34,251,43,178,153,83,78,80,8,37,146,141,132,243,217,109,51,99,115,195,64,191,203,241,151,53,84,103,32,250,193,246,51,155,76,135,214,107,63,75,185,168,7,238,8,74,216,84,218,159,25,96,52,230,28,241,13,39,1,203,130,100,179,165,32,149,17,208,0,115,12,70,180,218,187,125,170,44,52,142,204,220,150,135,116,207,119,73,102,54,39,237,184,87,8,1,28,135,63,246,115,72,24,4,83,102,224,212,237,174,132,50,17,80,156,47,253,237,38,79,205,166,149,150,232,2,40,53,137,198,65,13,188,190,164,23,127,217,169,99,144,99,47,114,72,99,214,29,180,108,11,154,181,0,184,206,45,144,194,230,147,220,73,254,61,203,229,34,28,237,209,76,13,194,241,7,15,174,32,118,107,40,249,34,103,130,113,41,95,238,126,158,93,206,215,145,78,231,79,10,178,49,253,234,31,2,250,139,208,193,253,221,2,133,202,183,1,254,90,69,136,84,29,4,188,52,248,82,1,1,226,143,166,211,57,199,216,141,88,150,242,208,76,222,227,1,23,113,9,133,241,37,155,111,11,226,10,50,122,216,80,39,99,167,35,84,3,225,73,154,40,22,203,103,120,213,4,179,24,155,69,81,98,41,18,201,239,61,163,156,248,250,233,10,245,123,116,21,250,254,202,133,157,150,141,66,61,236,5,120,168,71,16,150,167,191,215,181,95,143,37,55,199,222,231,189,194,7,63,20,179,67,78,137,74,106,110,85,187,185,73,29,101,17,50,19,122,50,144,49,214,0,45,70,201,187,14,127,7,24,246,63,3,176,38,88,22,131,234,172,58,194,204,75,125,249,20,51,123,134,36,128,141,252,82,244,16,16,13,134,164,40,24,6,243,198,206,161,95,188,103,154,228,238,197,91,232,13,44,137,39,249,241,117,239,62,98,64,110,196,92,195,187,11,177,20,9,244,64,51,130,89,73,136,30,95,15,161,234,227,108,129,133,79,196,33,0,87,137,187,219,131,30,13,42,47,13,62,238,161,30,124,103,54,246,216,175,154,29,80,95,51,183,219,193,43,76,223,105,74,115,152,61,95,39,135,79,135,25,182,197,65,16,219,252,177,162,164,255,163,178,85,223,216,61,163,201,168,156,221,188,48,7,182,8,1,253,217,124,81,240,24,235,172,13,100,118,12,75,36,184,164,135,70,114,164,7,0,81,92,221,108,136,157,56,151,177,192,121,16,38,8,173,227,208,24,89,110,33,230,242,243,205,31,126,205,224,230,218,55,114,141,10,146,115,6,133,180,106,10,220,155,238,166,60,67,22,28,233,166,17,40,209,205,64,90,90,59,102,111,240,178,26,66,104,61,83,231,145,4,117,80,79,253,58,245,18,22,106,173,121,36,139,240,76,234,253,4,251,48,148,133,87,3,60,127,159,29,249,39,75,235,77,47,117,164,231,240,97,86,110,53,35,227,135,197,45,36,225,103,158,225,168,182,106,45,153,52,118,234,191,188,168,83,73,160,174,225,115,155,197,84,85,186,155,255,160,69,52,22,186,21,202,106,72,10,16,73,244,232,83,121,188,244,127,222,154,18,167,133,148,66,191,200,150,141,6,27,111,76,147,11,208,255,21,29,58,72,164,173,174,241,39,160,163,51,20,94,162,239,23,116,108,14,103,46,63,7,170,3,85,31,125,152,136,12,87,26,132,215,151,31,165,141,120,172,13,7,151,38,6,161,144,127,181,24,138,22,180,135,153,255,217,173,218,95,107,155,18,120,196,92,210,225,126,9,61,154,179,32,127,208,166,194,212,115,244,176,186,245,109,108,90,128,50,77,199,235,236,142,66,220,242,91,108,124,242,79,204,191,238,49,97,139,127,5,63,9,216,232,58,148,54,230,113,108,122,61,114,151,189,49,244,112,116,91,121,31,203,171,224,180,98,239,146,152,113,187,223,114,135,211,188,10,43,185,36,216,109,148,101,8,178,161,114,171,142,95,87,81,42,146,189,70,26,200,145,113,229,89,99,130,68,193,170,170,255,156,100,112,124,129,169,32,86,82,165,148,6,219,209,110,154,10,112,178,14,62,66,113,131,77,173,181,53,25,233,9,15,233,142,244,244,94,226,67,199,35,138,62,19,243,31,252,4,45,2,77,196,241,221,178,96,36,100,31,74,121,189,206,19,227,22,72,219,158,68,34,31,237,34,2,152,118,235,77,94,246,20,42,62,158,114,81,161,28,16,201,151,84,19,85,14,149,119,214,153,215,218,122,48,154,72,104,213,49,34,250,252,142,71,42,202,70,211,64,83,160,64,19,224,103,237,85,106,128,76,84,24,22,158,117,119,92,81,173,219,85,182,151,234,242,63,168,143,23,180,128,6,78,49,181,146,14,106,20,151,184,163,249,239,244,178,148,131,8,220,151,237,137,189,210,109,199,160,235,147,122,233,68,201,31,247,78,48,59,234,206,151,157,73,20,185,139,255,108,216,129,72,238,87,125,246,158,222,100,186,99,186,60,41,180,199,21,95,30,201,138,241,106,131,12,99,239,147,154,253,139,86,206,15,86,211,57,204,131,162,46,176,237,215,91,205,127,162,252,29,168,171,117,115,157,64,115,179,201,172,13,25,106,78,180,62,101,61,175,8,8,208,145,36,160,252,120,142,196,187,246,23,206,123,18,111,253,129,79,34,57,246,213,145,247,26,247,200,194,197,164,43,7,30,46,124,54,153,196,37,18,0,139,120,196,11,203,10,52,103,136,29,44,109,151,22,12,140,204,12,106,147,241,29,4,218,127,16,15,38,123,6,188,192,44,122,6,49,120,178,19,240,80,182,119,20,37,191,34,239,29,180,140,4,111,188,198,113,46,167,237,74,36,52,40,145,255,175,47,240,8,73,147,205,98,55,9,254,68,71,156,170,233,98,64,111,191,224,126,165,130,178,56,170,48,123,71,200,158,232,130,163,97,164,166,202,200,6,199,4,119,76,88,43,166,2,10,228,159,185,234,170,168,37,166,208,217,189,233,216,168,15,89,243,151,182,125,84,252,235,70,229,205,178,221,89,98,78,97,42,6,109,225,42,190,105,127,49,9,201,65,128,178,74,9,218,28,98,237,5,213,142,112,40,131,112,241,3,22,201,77,19,87,147,25,47,150,252,230,131,216,185,238,40,237,205,177,84,224,113,212,172,188,246,11,236,99,103,204,155,227,220,31,242,47,50,6,148,244,224,217,91,15,129,189,254,205,228,35,47,182,162,181,106,214,214,44,151,184,173,179,58,185,215,183,249,86,173,178,157,50,186,238,204,146,236,102,19,102,205,153,243,191,237,242,87,58,160,173,201,202,14,38,20,1,186,182,1,141,42,91,220,76,27,83,119,131,12,67,254,62,114,232,205,37,165,188,210,184,139,114,191,189,189,215,70,163,99,45,117,176,130,233,206,172,138,144,111,231,112,90,197,178,178,130,230,150,186,76,215,179,38,79,121,98,74,39,245,86,253,108,76,0,116,21,175,230,202,255,226,91,170,135,177,83,236,220,130,10,13,92,178,106,242,156,132,149,209,94,245,236,10,217,233,6,196,150,96,173,12,72,255,77,196,200,3,106,8,137,244,237,189,105,50,255,134,116,53,63,15,211,95,139,90,212,158,11,96,235,68,176,5,48,232,82,39,59,75,106,92,184,56,121,163,187,86,136,176,158,178,255,57,234,91,166,93,212,88,59,67,253,170,7,223,171,242,204,129,87,61,114,72,65,96,196,187,168,55,9,33,74,65,54,79,184,250,23,119,230,72,23,211,188,191,3,249,105,109,13,127,216,77,49,89,172,118,155,159,190,97,179,78,227,179,87,228,84,223,146,148,99,103,125,215,11,164,30,233,89,245,183,1,173,158,6,106,255,103,64,126,99,86,151,62,15,183,22,133,107,4,144,104,192,161,244,160,6,189,234,35,177,175,91,29,30,155,249,25,211,160,167,162,163,63,1,140,77,159,118,50,156,40,175,154,228,175,52,24,189,253,180,160,235,9,194,221,74,81,169,170,49,163,69,75,202,144,46,85,55,158,36,88,7,107,19,64,107,186,73,162,103,36,1,4,131,222,227,137,151,28,227,194,73,125,246,138,218,29,66,34,229,69,160,87,233,76,124,104,236,121,164,127,35,21,193,242,126,111,130,176,33,166,39,49,170,98,234,237,238,114,136,187,188,109,81,78,147,135,219,97,75,83,84,216,60,144,130,107,232,155,93,55,188,220,178,97,110,155,43,182,115,158,172,28,9,103,181,230,114,16,248,231,69,51,151,83,72,11,16,74,27,36,144,23,18,236,34,229,96,149,150,32,108,49,23,255,135,1,158,234,183,14,227,146,219,248,163,49,150,58,110,173,142,8,186,81,32,40,197,146,183,227,122,69,140,26,182,104,161,237,20,180,31,10,53,33,16,239,141,170,242,178,60,8,85,161,136,27,208,199,43,77,224,244,137,188,198,166,103,28,190,44,148,176,227,209,205,4,11,199,207,75,255,197,131,58,31,133,236,124,71,209,103,33,245,250,178,227,193,72,164,96,216,139,69,237,220,120,132,122,182,31,128,188,231,226,222,23,94,204,91,200,81,129,247,17,76,213,240,87,116,150,147,172,99,211,166,193,227,161,0,137,241,239,172,226,224,53,234,29,111,237,141,205,195,226,85,102,68,99,233,58,126,76,122,112,147,179,129,250,141,188,62,112,175,16,230,0,115,216,81,195,8,35,125,183,67,143,85,234,143,81,48,33,83,160,132,103,97,78,164,111,231,55,253,213,46,181,181,201,217,35,235,230,192,245,206,199,140,213,191,211,52,206,24,195,66,188,237,125,52,15,21,222,143,190,187,245,100,39,92,15,155,171,203,223,47,73,95,95,227,118,18,118,229,240,239,219,61,134,235,48,56,117,73,207,71,137,185,6,43,98,180,1,11,77,160,90,81,49,141,59,26,134,74,74,117,121,184,217,3,131,108,93,224,23,137,139,90,14,203,222,142,216,1,100,75,202,245,126,46,148,43,120,59,121,15,125,141,225,169,9,40,77,148,43,233,0,113,61,189,156,237,11,170,73,211,40,226,189,236,25,19,55,230,103,122,101,33,94,62,245,219,169,48,225,57,199,131,97,40,80,123,230,71,131,143,48,153,79,124,93,173,51,227,123,17,219,104,146,251,142,61,100,26,12,23,98,160,31,217,119,91,159,13,116,176,182,95,163,74,121,17,142,223,115,92,138,233,194,76,122,199,250,38,14,113,127,171,100,232,246,47,140,47,201,52,173,160,55,176,102,104,150,64,206,15,78,90,111,134,16,2,243,30,183,32,182,109,61,17,44,52,162,83,236,105,67,44,239,101,62,100,81,172,187,245,7,123,17,224,99,183,166,209,226,231,146,98,76,182,223,237,74,87,183,182,157,192,236,16,79,51,202,211,8,148,63,121,133,118,189,230,87,252,126,105,67,181,142,34,69,183,137,164,166,230,244,250,42,36,188,174,56,53,27,50,59,122,181,12,37,28,12,140,205,3,79,82,159,56,175,50,65,54,183,63,238,2,185,128,20,172,171,37,46,191,225,180,130,98,169,126,15,207,53,222,69,39,152,66,75,6,182,131,253,180,217,164,130,12,170,10,20,230,32,252,22,63,175,168,22,180,10,127,233,71,199,253,208,57,196,108,231,100,205,182,213,67,163,179,74,160,33,36,69,58,85,211,220,187,188,20,72,47,93,16,68,157,104,127,146,30,211,49,129,172,217,152,20,229,141,55,228,207,107,176,48,133,189,45,182,203,88,107,124,236,65,24,167,251,231,226,19,85,141,90,206,191,101,172,193,212,247,149,185,158,98,24,174,44,59,196,179,127,3,250,175,210,109,54,191,112,37,131,255,1,110,46,182,103,41,124,255,25,191,176,236,236,170,145,143,248,160,211,16,130,122,43,246,172,231,240,101,6,119,14,197,50,220,40,106,190,34,140,167,11,195,249,217,160,188,138,61,220,245,249,110,161,4,168,106,10,242,75,31,102,129,178,103,55,63,243,52,127,168,85,111,166,116,109,120,20,19,229,246,52,105,122,173,16,95,145,7,110,74,204,191,89,143,173,92,34,188,234,5,49,105,73,98,105,9,239,94,175,126,167,166,163,135,114,147,41,245,20,236,168,69,9,211,167,136,177,168,99,48,32,2,9,136,243,72,135,75,42,88,63,152,14,98,154,149,126,115,48,180,34,117,146,89,176,161,159,78,62,101,119,249,66,154,227,41,34,148,29,100,1,180,69,219,115,54,120,160,143,39,26,2,219,159,101,33,60,235,32,25,76,8,111,53,148,142,169,140,222,222,225,164,141,123,23,15,199,116,90,172,121,5,48,16,213,175,147,238,135,13,238,41,61,174,151,197,14,32,88,23,128,103,75,98,38,128,112,117,233,140,191,1,1,99,79,99,230,109,233,253,11,250,175,174,252,126,239,221,83,28,85,235,179,124,124,59,90,8,120,235,248,148,234,80,86,130,138,157,82,163,124,250,153,32,10,56,118,35,208,31,13,206,47,33,11,149,40,193,228,46,153,105,251,158,53,32,254,250,133,147,163,162,187,248,238,31,226,104,6,46,60,195,13,253,30,108,41,70,118,238,153,141,200,109,153,68,213,17,54,174,218,229,129,32,221,192,53,40,252,178,209,94,218,86,48,56,222,174,193,83,81,141,38,203,48,110,171,87,67,151,196,60,90,157,44,196,47,229,59,60,216,34,157,177,176,245,246,240,135,68,78,144,197,237,186,244,29,92,66,161,109,4,157,130,123,44,78,203,131,6,22,228,170,63,114,110,194,3,103,227,217,230,197,26,1,124,97,110,182,196,198,142,158,102,77,82,178,224,42,244,0,85,149,140,105,241,58,123,204,97,74,110,140,148,200,83,198,68,68,113,19,85,223,129,36,152,116,242,67,113,124,181,79,58,151,168,125,109,100,185,16,127,179,16,186,139,122,79,95,83,25,135,159,234,196,0,202,213,17,6,169,143,207,83,235,180,207,65,172,251,119,84,202,87,213,176,94,228,223,118,74,230,16,236,108,230,47,132,161,74,231,142,159,184,192,105,183,1,198,13,43,170,192,11,243,13,48,104,40,188,251,15,69,219,131,142,216,100,7,175,207,4,212,170,63,140,173,47,88,169,97,110,34,109,35,232,212,232,180,131,177,236,56,203,185,166,249,175,252,206,62,231,243,212,45,162,179,55,40,250,37,70,82,73,176,125,192,37,46,121,65,142,111,66,254,29,63,160,181,235,167,199,136,241,25,97,66,239,165,229,143,22,107,95,80,217,55,29,33,225,146,54,184,22,38,126,154,246,172,252,22,168,110,46,139,147,121,122,243,179,20,47,252,103,120,30,148,96,235,45,144,222,229,65,108,95,9,25,148,254,227,55,196,67,47,236,43,225,151,93,55,129,184,13,19,30,44,124,183,62,243,179,222,247,247,229,102,131,152,29,109,40,27,200,178,125,232,66,211,216,123,120,116,87,68,49,135,80,96,108,131,119,148,47,220,70,30,125,139,249,197,41,46,100,148,130,97,105,198,83,230,250,7,154,17,235,40,65,19,166,102,80,255,131,98,93,130,180,113,129,78,145,50,193,245,138,107,23,49,213,26,206,147,242,186,182,18,81,181,62,234,86,149,104,12,38,240,180,237,119,137,127,21,3,253,253,108,197,200,174,240,68,84,156,119,220,200,35,58,2,200,28,35,9,83,49,21,101,160,191,197,180,190,71,221,80,246,141,240,255,114,52,211,25,141,240,122,196,120,20,151,24,209,238,80,247,99,185,208,103,215,192,95,238,65,123,87,199,115,150,75,131,65,91,183,7,94,150,36,254,27,217,58,121,39,167,142,63,112,228,53,215,24,187,26,77,151,196,52,190,31,147,122,245,177,187,108,218,253,227,142,197,4,1,83,191,198,240,148,20,193,0,49,225,128,93,33,255,215,11,124,153,178,90,170,202,81,125,225,65,179,222,77,252,209,229,238,91,135,60,157,115,232,101,167,89,161,251,135,12,247,1,37,67,77,10,96,152,236,212,45,46,60,51,105,26,225,233,42,56,225,196,195,76,229,169,101,53,251,87,249,218,247,77,28,63,229,100,250,241,100,210,206,219,125,223,125,224,85,160,251,93,171,151,11,163,161,40,56,217,174,182,111,245,241,218,233,210,71,45,230,254,154,221,224,184,77,12,192,73,231,65,182,139,47,119,159,160,157,255,62,66,138,121,139,68,182,203,183,198,170,119,221,20,237,203,1,174,161,199,90,175,192,32,229,197,173,38,166,96,129,45,146,204,138,26,113,56,69,151,132,59,172,24,227,215,64,51,115,102,109,104,78,217,42,156,139,160,103,146,199,241,62,125,186,21,59,138,140,31,244,228,143,6,36,15,249,107,0,151,200,25,86,171,170,223,70,176,124,5,236,39,3,229,184,202,31,18,249,18,160,229,81,189,0,145,192,206,232,129,165,140,75,146,226,33,252,92,70,254,120,235,192,35,240,107,166,5,81,170,143,7,52,127,47,8,113,219,180,84,38,47,133,132,196,206,111,78,58,85,176,86,143,172,65,86,102,60,199,71,10,60,13,12,72,57,114,43,23,201,33,246,203,90,150,86,186,179,182,215,50,209,76,29,123,134,225,214,0,185,20,221,139,84,186,232,4,123,43,24,165,72,230,235,15,193,45,64,239,68,111,224,54,183,171,221,243,99,127,198,32,160,60,152,176,9,155,180,63,172,153,223,95,133,249,249,55,132,198,131,91,150,171,181,5,242,79,145,102,205,145,179,129,185,157,88,236,153,34,62,98,1,144,75,160,37,29,34,227,102,229,188,232,80,233,180,35,196,128,194,199,254,136,174,61,35,180,211,246,234,2,36,128,167,52,224,81,37,58,111,150,176,237,140,1,108,215,244,81,171,222,242,201,39,227,255,164,132,222,159,161,47,127,101,210,56,56,179,75,244,42,15,197,54,69,14,223,194,52,50,75,81,101,23,151,10,81,182,43,4,35,196,161,35,174,72,15,138,121,0,55,114,193,146,64,142,76,20,51,41,35,49,216,223,75,120,250,90,11,52,102,106,128,50,27,159,76,61,86,171,111,157,131,121,253,245,89,147,58,173,119,20,46,167,247,200,207,91,97,198,66,144,96,35,208,225,138,84,79,177,237,63,93,15,85,181,54,230,96,4,213,236,122,26,15,242,207,5,118,151,117,181,45,88,125,84,28,65,0,183,179,165,193,88,29,110,126,19,101,210,199,73,202,25,118,137,78,200,160,3,243,244,239,251,182,102,41,234,116,184,100,237,157,158,104,13,220,6,107,143,156,252,141,183,205,12,31,130,32,133,190,21,169,44,206,107,173,164,38,148,244,58,188,140,43,102,152,134,167,11,45,158,30,177,124,13,203,59,19,167,134,101,170,17,254,108,141,207,184,206,246,151,235,177,14,145,3,127,44,63,232,62,25,148,150,253,86,0,87,153,203,252,254,2,241,123,200,119,208,239,226,175,24,195,52,45,197,57,41,12,5,54,242,142,222,233,220,77,166,73,38,117,208,164,73,93,243,163,95,94,226,184,99,164,248,142,134,82,182,147,100,153,192,237,120,14,97,19,58,45,251,114,148,140,109,167,163,182,235,209,19,33,122,170,195,20,134,162,123,251,180,152,245,157,45,223,101,41,217,109,17,68,223,5,137,232,130,100,36,29,129,91,64,31,139,155,78,67,84,120,72,122,38,140,206,165,57,241,76,250,14,104,161,80,197,157,22,231,174,169,232,114,125,159,79,61,113,16,204,150,43,135,42,53,187,97,172,53,42,164,25,95,158,173,247,50,36,189,237,122,133,123,238,82,121,186,211,95,238,162,179,81,166,148,28,218,38,174,151,91,8,177,104,121,116,93,107,127,145,181,191,196,61,136,86,103,43,191,53,84,78,40,105,111,183,158,61,119,9,67,203,250,253,118,51,19,35,16,242,244,163,139,145,39,104,181,195,45,21,5,124,73,49,104,192,227,220,169,44,86,14,123,254,1,154,209,193,81,186,121,250,188,88,202,182,170,155,99,24,132,152,142,255,244,85,227,24,35,75,175,15,6,102,105,64,253,73,234,52,33,197,127,78,156,136,145,46,54,114,185,110,224,102,168,149,234,197,211,158,245,89,38,238,72,169,52,1,218,114,73,239,100,39,73,30,58,141,15,99,78,98,108,77,132,153,10,117,197,254,141,72,160,130,18,161,24,218,52,121,173,179,106,220,236,33,223,204,132,6,4,91,184,234,219,87,60,111,0,134,188,116,24,221,139,111,203,200,233,191,89,13,126,225,254,109,196,124,160,68,49,250,129,154,234,13,202,164,232,95,95,224,180,161,12,138,250,244,14,134,123,122,208,196,75,150,42,224,156,233,5,119,237,113,217,114,205,254,204,197,163,27,211,45,246,242,220,21,75,26,244,118,113,233,176,216,150,73,204,17,124,59,160,103,28,205,244,140,100,12,185,233,128,192,124,189,62,192,50,12,127,145,91,242,73,53,42,162,144,98,26,183,138,8,216,250,11,17,186,124,90,76,115,158,176,13,177,123,120,243,218,173,10,104,187,85,46,213,194,190,169,114,173,185,46,217,88,151,170,114,127,255,216,22,81,137,128,96,171,47,193,176,15,179,57,127,190,97,99,180,97,58,166,180,163,142,109,85,109,168,18,157,214,25,23,135,161,102,167,18,153,208,206,214,233,232,242,179,56,169,182,67,217,246,196,139,132,160,198,249,237,62,7,196,247,22,158,30,226,54,121,204,227,87,159,13,25,42,76,63,82,60,4,180,149,149,62,254,77,55,225,159,165,140,82,38,114,20,193,175,191,183,236,32,93,184,178,61,92,138,30,203,139,213,84,56,214,2,63,152,76,126,193,179,2,190,237,170,54,147,123,250,4,223,120,154,173,6,102,129,248,221,196,219,152,82,183,11,175,45,97,180,116,69,162,189,184,8,117,188,196,85,16,175,66,94,119,33,251,194,130,15,89,85,89,28,103,152,124,186,151,184,166,118,227,24,254,154,134,254,169,239,77,219,208,78,140,203,227,100,244,185,17,74,104,130,186,162,154,78,211,130,8,169,163,108,62,184,45,189,206,146,45,196,205,226,235,229,204,183,51,201,98,199,241,194,77,152,61,185,102,12,68,244,94,33,45,110,197,3,138,252,73,33,80,173,168,218,211,71,58,201,195,74,160,216,234,201,98,93,111,242,170,220,181,163,103,114,239,168,55,117,12,90,2,65,244,224,166,190,14,21,121,180,150,44,80,192,188,145,66,113,101,1,54,253,82,63,59,127,73,132,168,120,188,84,121,217,175,123,237,249,150,234,66,35,150,148,178,64,157,54,152,92,240,228,29,236,55,121,67,124,245,159,221,62,106,54,110,69,249,29,111,104,34,56,51,105,57,116,212,64,206,138,249,155,175,244,25,199,139,222,98,57,134,130,63,201,3,209,173,43,26,80,6,241,36,202,113,238,46,92,149,56,3,180,195,252,137,112,9,109,143,163,216,237,179,60,1,4,170,195,15,176,33,211,93,90,97,206,91,132,106,214,6,200,126,202,2,182,244,141,38,118,62,145,178,168,207,126,20,232,21,235,121,147,222,81,26,177,194,250,213,58,73,49,44,156,103,92,54,213,119,153,149,5,172,85,166,227,124,158,166,237,218,169,141,45,255,151,12,192,122,8,154,42,219,204,22,227,168,10,130,132,35,55,42,237,133,205,115,27,197,61,49,75,223,237,241,152,28,118,36,239,12,142,254,149,43,250,67,113,227,137,114,249,147,170,221,176,31,104,240,210,217,12,220,70,210,240,232,223,242,28,214,201,65,239,4,207,96,125,112,112,91,12,14,250,7,199,115,196,79,165,30,79,47,171,88,107,142,174,133,151,12,37,246,17,208,44,175,163,148,160,174,28,58,42,38,240,29,40,201,125,20,189,129,0,191,194,8,104,31,161,94,41,88,143,25,57,174,128,255,103,69,148,220,64,88,124,144,52,52,146,244,38,92,61,145,35,12,98,220,196,160,24,159,189,108,204,187,220,179,232,231,141,41,38,178,48,39,244,10,37,184,183,170,205,167,140,187,114,55,170,4,208,173,191,95,98,12,48,169,236,67,230,232,35,80,177,23,193,66,97,247,60,62,26,138,243,218,111,163,66,169,104,183,98,96,34,252,150,105,174,227,132,32,55,228,191,102,102,190,146,55,51,14,151,178,127,16,154,13,150,31,177,191,96,115,206,71,11,8,188,108,3,137,84,85,121,147,137,112,8,8,179,230,76,0,99,146,209,36,187,250,20,159,121,162,22,203,45,125,241,70,37,32,36,26,219,143,230,141,83,207,151,160,113,102,90,153,158,165,195,137,84,45,109,253,170,191,150,153,208,95,29,177,105,255,251,169,98,199,51,240,73,237,111,46,7,51,29,46,223,83,92,208,70,9,19,163,197,2,135,179,189,74,26,99,146,197,115,137,115,74,44,25,59,49,168,169,2,63,136,249,102,159,18,8,233,97,215,152,228,32,193,164,162,179,233,114,123,59,234,124,7,116,15,159,208,185,244,118,50,158,173,133,223,168,239,222,121,201,65,1,36,116,252,214,73,38,15,169,180,197,163,250,188,161,125,202,88,1,200,247,142,77,59,232,199,96,218,65,175,210,191,219,89,250,179,37,100,222,14,218,130,216,132,47,121,12,129,178,2,126,23,196,218,73,254,68,3,66,205,7,44,130,146,182,216,52,126,242,169,223,159,209,69,24,184,205,219,232,53,201,111,21,22,207,132,35,90,41,163,114,135,101,163,146,207,68,133,134,241,69,162,58,202,100,203,24,139,20,221,2,73,232,180,91,195,87,118,188,216,152,29,161,215,89,83,144,149,153,213,175,124,92,25,159,133,107,89,114,189,55,128,99,4,131,209,180,239,25,86,201,156,126,136,167,109,186,79,197,67,171,36,37,155,236,116,37,59,97,135,30,151,249,64,157,0,235,255,2,225,6,249,233,103,34,226,51,226,225,59,165,251,201,90,250,45,16,67,204,154,202,84,229,192,19,119,97,182,233,49,61,222,232,90,22,187,251,135,78,252,22,28,22,125,151,190,65,7,11,216,128,52,68,184,206,190,142,51,222,45,92,28,174,208,140,25,12,204,93,126,68,155,92,68,255,182,149,191,8,157,171,203,73,251,83,63,215,156,140,30,180,48,135,199,70,163,150,210,94,57,44,56,190,53,226,118,177,45,220,150,246,225,234,30,25,22,85,100,103,188,235,198,190,245,83,88,147,196,65,29,58,187,119,4,85,126,101,140,117,187,59,61,154,202,100,44,111,148,28,79,23,233,56,149,120,124,28,242,130,247,35,4,45,111,213,64,68,191,104,185,108,231,194,74,125,212,152,170,109,73,2,38,20,80,102,51,122,124,169,214,59,221,192,192,188,133,161,88,91,61,78,160,98,78,211,74,108,156,76,130,89,251,194,173,50,158,191,219,152,197,215,238,155,120,180,181,233,195,117,238,187,158,56,240,233,144,50,105,105,243,122,183,201,78,230,184,19,182,54,61,237,16,207,75,115,37,102,32,230,38,8,166,178,148,175,217,23,127,8,111,162,139,165,26,230,72,191,41,83,126,133,237,129,193,164,80,15,144,101,56,41,223,144,117,241,148,86,77,161,45,132,185,73,89,124,58,6,122,8,172,116,21,70,174,21,53,117,52,144,16,122,79,233,93,66,163,77,160,115,109,147,132,70,161,17,248,62,152,147,253,100,151,8,252,98,8,75,114,191,54,48,104,117,47,24,226,171,109,12,159,243,166,173,128,124,56,7,221,11,30,112,226,209,157,58,201,14,213,130,233,153,175,130,248,167,231,237,159,186,171,189,247,144,13,182,116,186,13,48,77,238,159,19,159,43,221,90,225,8,159,128,233,37,72,121,231,61,16,112,248,0,202,117,133,134,74,43,209,143,139,82,252,56,45,216,209,11,177,60,17,244,67,152,89,42,140,90,146,50,130,164,36,91,145,207,33,53,8,249,197,234,153,0,224,79,16,191,127,222,180,4,35,38,234,155,218,57,26,76,97,50,85,177,225,119,193,120,35,159,217,54,170,119,227,117,41,32,170,243,121,249,110,9,242,138,87,162,243,65,115,49,227,29,17,83,162,94,1,247,169,121,208,153,188,72,96,208,160,221,125,82,84,142,59,6,167,233,236,74,198,111,39,12,139,153,173,73,210,193,14,141,196,89,230,193,139,30,178,156,199,204,207,248,153,58,37,145,140,181,207,56,55,40,14,129,25,123,220,87,244,241,85,249,226,206,210,121,188,141,219,240,250,198,96,151,18,224,253,243,63,185,80,36,93,38,102,16,162,164,173,247,37,117,205,186,109,14,23,28,159,94,18,191,43,23,204,64,164,68,125,79,43,87,95,153,173,130,35,14,126,123,217,162,177,73,96,180,239,178,78,7,168,172,48,126,147,152,191,82,167,204,95,151,160,192,132,100,0,37,168,58,174,246,235,81,51,185,152,119,144,76,204,4,157,20,163,197,165,200,36,55,135,12,73,1,9,170,157,4,171,116,94,129,192,45,49,56,168,215,237,230,114,46,185,212,165,135,165,118,55,8,72,137,13,100,8,34,104,94,187,72,89,242,66,243,2,214,29,84,58,199,108,14,105,168,208,0,6,118,90,23,138,143,230,137,183,194,168,238,131,36,118,218,204,121,13,89,147,46,39,46,51,124,63,252,248,226,237,22,18,61,7,236,189,78,171,65,153,233,197,52,186,162,164,156,181,13,18,48,125,1,50,127,160,0,95,137,66,23,34,96,130,116,192,47,55,33,172,165,158,165,55,34,52,99,8,157,139,112,17,44,172,152,172,74,0,46,255,187,236,54,21,120,47,240,221,235,236,148,42,50,69,175,221,185,226,175,98,231,245,203,43,23,239,133,159,221,92,231,191,237,30,81,31,151,117,181,113,243,176,16,37,77,20,46,142,249,178,141,200,78,207,141,48,53,42,177,239,7,170,143,18,123,191,248,145,246,113,95,226,47,18,251,18,204,107,78,2,5,121,43,151,124,65,252,2,41,159,107,165,29,114,51,246,164,100,238,161,177,51,71,252,184,241,11,121,60,198,240,139,86,7,63,10,251,161,40,191,232,113,85,112,247,233,47,237,178,107,74,142,87,58,127,143,28,77,56,78,86,61,206,180,27,186,31,129,249,196,121,249,191,169,181,234,43,123,97,102,59,72,227,176,40,42,108,128,144,3,248,243,220,50,161,97,127,147,202,141,44,52,47,99,33,238,152,97,223,8,189,111,254,23,164,87,192,13,28,48,218,225,173,242,36,246,86,97,232,212,242,199,132,170,213,130,233,218,219,250,212,125,127,60,21,14,210,93,59,223,74,163,237,20,30,162,49,195,83,122,158,61,41,232,108,178,93,20,130,132,33,82,73,183,46,70,37,47,32,133,73,213,182,177,187,156,112,186,98,239,76,216,102,161,6,105,186,242,183,43,228,63,138,47,200,225,108,177,249,186,212,203,81,59,62,94,16,186,248,164,104,168,99,80,107,80,16,99,145,5,192,103,152,140,93,68,87,243,56,238,8,96,7,49,38,61,244,46,81,25,7,129,175,79,27,172,151,208,112,229,86,36,19,125,12,118,57,252,88,178,217,163,165,226,150,130,3,186,215,184,136,216,0,105,240,92,212,43,59,169,37,60,142,25,178,251,53,125,174,117,172,130,202,111,14,177,117,9,209,199,90,245,214,224,42,33,52,222,166,133,208,177,177,229,59,237,106,236,39,128,55,207,36,76,151,235,9,132,28,244,204,215,118,53,136,64,5,236,192,124,227,23,139,208,76,74,226,148,41,134,13,168,78,44,233,108,1,179,119,35,171,162,248,201,227,105,130,77,179,1,54,157,0,208,103,31,41,242,150,51,172,244,102,111,224,226,70,148,149,101,18,212,226,231,117,109,249,81,255,92,64,219,146,49,44,71,184,84,94,190,149,95,235,121,191,149,130,230,109,36,103,22,141,163,137,117,7,56,111,189,116,240,79,146,162,129,58,236,171,95,182,205,204,226,141,95,21,88,227,43,93,125,12,72,111,94,167,255,85,206,200,122,6,87,48,188,188,205,159,94,17,145,32,17,95,38,157,211,69,144,103,34,24,156,222,237,76,185,104,170,144,253,147,156,64,131,99,155,36,64,36,158,232,132,10,152,2,193,125,113,100,142,60,155,65,48,1,224,119,67,71,46,79,40,233,143,201,68,35,236,115,135,13,149,99,152,192,106,226,144,39,185,193,201,237,237,92,173,74,110,151,76,193,173,162,54,89,105,174,183,49,33,224,115,100,70,168,185,21,168,8,196,41,49,74,102,102,89,115,169,174,65,154,90,236,71,163,190,125,188,90,221,178,139,236,62,158,49,235,252,11,104,145,112,83,220,100,110,229,57,244,253,21,255,123,135,224,52,26,40,202,115,231,229,58,18,200,204,15,9,213,39,221,24,243,123,115,47,47,17,26,32,17,195,30,151,61,211,199,171,204,87,94,162,169,151,168,252,79,89,216,31,81,156,17,27,12,60,66,70,215,222,221,95,250,121,59,56,94,12,197,69,43,189,50,170,215,249,160,216,114,78,62,95,14,133,227,83,53,227,118,34,111,52,10,23,49,161,46,75,70,161,239,86,16,144,50,148,112,93,210,164,235,86,50,173,99,47,162,34,101,145,150,33,25,96,177,93,19,76,76,123,148,251,177,128,214,158,216,114,124,110,175,129,72,20,19,176,108,43,129,58,122,185,11,148,52,213,197,38,175,16,56,108,196,40,217,234,53,129,25,57,32,208,251,157,35,202,164,146,205,248,94,164,244,119,133,71,40,208,83,30,22,183,95,88,17,137,190,175,7,252,90,135,123,201,144,174,168,252,237,84,179,5,247,144,75,44,31,27,29,228,113,232,56,91,93,86,30,14,228,234,145,6,37,13,9,75,206,252,19,18,62,180,216,135,58,124,59,11,223,144,213,39,117,195,38,207,244,64,93,6,115,192,183,39,176,101,93,246,209,159,198,24,253,160,190,14,85,95,207,128,60,251,34,175,84,188,64,221,61,76,178,250,31,163,80,198,211,83,157,189,64,112,86,35,100,50,185,240,51,115,232,185,177,41,153,231,158,109,14,187,103,49,195,181,126,3,149,43,88,219,175,254,43,154,34,76,247,198,131,251,56,88,37,118,102,4,5,187,185,214,93,124,219,162,215,155,188,142,63,74,32,148,201,4,48,52,82,188,92,210,1,39,151,107,229,236,146,41,6,148,49,125,82,24,83,64,210,183,80,29,218,105,222,64,94,88,86,121,252,104,85,127,79,103,197,144,81,101,59,220,166,219,117,164,8,101,46,202,175,213,147,54,157,133,244,137,116,26,125,78,107,109,33,163,211,99,87,21,244,100,187,209,186,54,128,126,250,228,165,186,73,47,155,108,87,232,194,165,121,66,17,122,217,174,92,69,87,164,234,135,138,139,180,181,162,164,136,213,253,84,100,142,189,5,191,211,63,120,197,97,68,90,225,250,42,49,169,126,22,159,252,111,34,106,160,166,124,98,70,155,43,23,58,229,102,8,236,158,133,9,214,27,32,136,238,223,139,142,29,154,214,15,194,66,98,68,18,99,104,37,99,117,243,202,98,121,68,16,198,24,38,107,104,248,86,210,75,194,225,111,132,22,162,114,133,56,152,28,97,33,75,95,177,30,126,8,101,129,187,103,186,116,234,129,138,34,60,33,30,32,39,239,238,195,86,27,152,190,131,67,160,155,254,61,198,172,91,91,168,188,40,180,222,192,168,141,150,93,44,152,81,34,250,8,119,77,219,89,73,101,181,66,95,97,18,28,126,46,103,209,5,203,16,42,119,200,91,86,255,215,90,145,60,74,119,207,55,242,81,221,68,116,134,192,101,175,213,129,98,114,176,135,225,80,24,171,200,141,17,176,188,249,224,202,110,144,161,43,105,196,231,90,19,223,171,34,211,90,5,158,70,215,142,63,222,240,239,183,72,46,240,233,44,146,242,16,120,99,167,193,176,62,82,195,224,211,176,3,145,116,138,215,220,93,80,108,231,73,28,52,232,85,121,134,60,117,20,16,201,106,74,29,119,77,13,145,232,42,126,177,234,81,215,133,230,244,90,208,22,74,133,68,52,200,132,245,8,135,97,136,208,223,136,35,94,43,124,83,198,81,51,252,160,220,255,29,194,77,32,41,74,195,223,209,208,89,41,45,1,107,52,78,70,102,110,134,173,158,112,147,81,183,166,38,220,193,28,134,141,78,124,31,195,224,152,131,167,93,235,139,41,180,71,130,124,229,208,128,123,184,88,89,131,229,103,240,169,93,71,25,238,174,99,190,162,81,7,142,252,46,240,201,128,96,10,227,84,37,232,216,78,26,107,67,52,143,233,67,92,84,70,118,205,56,9,141,40,138,121,31,207,15,138,239,78,230,173,129,35,117,46,47,59,221,249,204,117,56,89,9,249,155,200,36,12,245,253,201,5,46,111,211,148,77,64,147,254,23,118,240,21,0,4,118,184,62,104,95,52,224,3,133,40,61,199,21,221,71,224,22,138,22,203,24,228,52,230,168,33,50,206,136,155,126,147,97,164,42,117,137,111,172,206,41,97,55,88,104,35,103,150,29,222,157,85,109,228,208,6,90,212,46,112,207,20,245,74,223,113,21,234,131,247,169,195,77,14,144,33,26,127,29,152,238,207,152,250,141,206,179,209,188,134,60,211,127,193,18,90,119,214,244,66,99,197,62,68,114,194,174,77,223,230,67,54,102,222,56,90,44,173,118,210,189,212,73,135,150,41,24,71,167,218,52,87,174,23,91,152,29,80,224,165,86,145,64,130,108,26,45,127,175,243,35,127,45,29,122,1,97,215,222,226,57,61,115,195,145,4,147,129,89,52,44,73,107,255,14,52,38,56,171,119,97,83,38,215,116,202,50,34,67,165,73,230,94,185,71,134,55,67,53,193,79,154,36,41,42,102,4,90,82,183,139,198,110,98,218,82,146,190,165,216,248,175,101,190,21,185,102,93,104,144,253,237,208,220,231,115,169,207,249,39,30,166,91,207,181,197,243,225,174,215,58,26,110,211,237,2,135,163,0,75,165,222,3,5,171,131,192,146,197,90,129,238,81,134,239,46,84,148,79,200,252,251,72,51,223,139,195,219,8,56,90,150,102,38,209,216,18,138,227,197,195,20,159,252,0,107,24,60,61,251,236,189,86,16,57,150,56,35,197,140,56,157,61,215,51,125,255,159,37,173,0,194,166,60,144,101,45,43,169,180,223,73,153,236,117,200,147,168,92,219,117,203,208,221,161,111,8,71,237,36,145,229,230,112,195,233,153,166,167,184,215,136,121,243,234,161,83,10,193,185,51,94,12,174,8,163,118,236,123,25,207,167,168,118,94,224,109,251,83,233,172,161,46,224,171,121,53,13,175,201,224,239,179,60,107,253,191,246,206,230,250,104,239,76,146,47,16,57,34,22,197,133,226,195,28,8,115,254,95,158,186,47,210,36,4,164,147,44,81,19,37,246,190,63,223,7,248,95,234,238,84,88,239,75,254,118,92,247,45,47,99,40,250,235,95,59,75,92,189,201,177,94,124,52,84,74,136,213,48,105,235,176,126,11,151,221,179,27,214,51,89,35,246,33,112,244,80,47,255,114,153,19,145,218,130,190,143,134,192,90,84,49,140,65,34,128,239,70,175,170,145,117,45,106,36,1,200,52,167,105,185,249,33,35,78,133,106,92,186,44,75,125,190,136,151,181,188,126,58,15,70,130,71,79,88,50,83,14,18,174,150,149,75,237,24,243,101,236,220,245,150,29,175,44,37,171,1,246,135,2,235,67,39,233,80,150,69,9,239,39,38,157,38,56,9,223,240,51,46,250,61,49,135,193,242,26,96,240,144,224,160,255,31,108,203,3,71,167,46,200,82,2,8,110,84,157,79,21,187,160,114,144,41,92,177,28,110,170,83,40,49,109,166,7,182,86,91,101,181,49,103,145,60,106,143,226,166,4,228,10,33,181,254,30,131,157,56,238,212,215,46,159,179,1,72,1,100,143,32,56,16,36,102,160,246,62,135,169,133,148,149,93,51,237,72,17,71,22,27,73,4,53,183,93,75,236,248,122,103,31,84,161,139,24,217,116,232,156,159,88,181,13,154,34,180,142,16,249,164,109,12,171,181,15,247,40,151,115,139,203,184,205,238,195,162,232,16,205,61,253,106,217,213,227,230,231,104,58,29,113,217,209,58,187,219,213,28,237,159,141,71,125,185,162,67,234,168,159,6,249,243,49,81,61,247,177,138,224,4,91,211,145,246,150,207,197,29,74,220,249,35,108,202,212,194,182,185,43,75,140,97,166,249,151,91,119,175,64,125,187,238,90,78,113,188,127,199,41,176,144,18,218,163,72,202,187,22,136,28,64,77,227,104,10,210,130,43,243,152,95,80,186,75,158,175,239,3,123,97,190,29,187,165,141,179,218,246,243,83,39,52,248,44,105,46,91,112,54,45,20,240,218,135,213,102,210,136,228,139,75,131,159,81,118,35,184,211,58,238,243,164,78,249,153,244,174,134,64,242,191,253,42,138,93,218,82,241,51,127,197,250,227,252,84,237,87,9,56,253,218,212,93,223,15,236,152,87,89,206,223,218,177,9,175,101,72,113,55,174,178,177,56,1,64,27,134,202,25,154,254,188,102,248,138,144,150,133,170,253,151,88,106,54,177,58,63,17,252,216,58,41,95,198,55,205,202,17,82,96,43,230,248,20,46};

// The ranking tile of 128x128 pixels.
// Each pixel contains an optimized 8d key used to scramble the sequence.
// The keys are optimized for all the powers of two spp below 64in 8d.
static const int rankingTile[128*128*8] = {40,40,54,54,50,50,20,20,43,43,2,2,23,23,22,22,5,5,33,33,9,9,42,42,11,11,16,16,25,25,58,58,4,4,63,63,45,45,42,42,27,27,33,33,15,15,12,12,55,55,53,53,6,6,25,25,7,7,30,30,44,44,18,18,42,42,16,16,63,63,58,58,22,22,57,57,58,58,24,24,47,47,12,12,8,8,43,43,49,49,32,32,45,45,53,53,46,46,25,25,33,33,19,19,29,29,57,57,19,19,62,62,23,23,59,59,20,20,3,3,61,61,13,13,21,21,21,21,3,3,34,34,38,38,46,46,49,49,10,10,52,52,44,44,17,17,10,10,52,52,37,37,8,8,51,51,55,55,28,28,41,41,47,47,21,21,41,41,53,53,27,27,61,61,45,45,7,7,34,34,62,62,32,32,48,48,6,6,44,44,28,28,63,63,43,43,19,19,10,10,38,38,23,23,51,51,57,57,14,14,35,35,54,54,19,19,36,36,58,58,50,50,56,56,5,5,53,53,40,40,16,16,37,37,1,1,5,5,52,52,51,51,57,57,56,56,41,41,7,7,56,56,41,41,13,13,39,39,4,4,39,39,15,15,47,47,61,61,34,34,18,18,6,6,12,12,39,39,21,21,6,6,62,62,60,60,53,53,3,3,18,18,56,56,42,42,18,18,35,35,17,17,51,51,39,39,22,22,14,14,17,17,42,42,0,0,29,29,46,46,46,46,24,24,34,34,41,41,2,2,5,5,31,31,32,32,4,4,8,8,13,13,63,63,7,7,22,22,28,28,61,61,48,48,62,62,18,18,30,30,46,46,57,57,44,44,15,15,13,13,21,21,17,17,38,38,36,36,16,16,5,5,17,17,51,51,37,37,46,46,49,49,16,16,30,30,60,60,50,50,47,47,45,45,21,21,44,44,33,33,53,53,2,2,53,53,23,23,31,31,39,39,1,1,26,26,2,2,21,21,62,62,1,1,63,63,25,25,18,18,53,53,30,30,56,56,16,16,10,10,8,8,6,6,33,33,11,11,18,18,7,7,9,9,52,52,36,36,21,21,60,60,17,17,48,48,43,43,29,29,0,0,2,2,19,19,47,47,21,21,22,22,1,1,61,61,33,33,25,25,0,0,53,53,40,40,54,54,4,4,33,33,21,21,24,24,26,26,17,17,24,24,11,11,49,49,35,35,30,30,61,61,38,38,60,60,0,0,22,22,17,17,26,26,8,8,3,3,52,52,24,24,9,9,32,32,17,17,56,56,42,42,39,39,25,25,62,62,57,57,33,33,5,5,12,12,54,54,6,6,34,34,13,13,10,10,35,35,1,1,62,62,4,4,2,2,14,14,28,28,48,48,12,12,41,41,62,62,44,44,32,32,21,21,59,59,0,0,52,52,13,13,12,12,31,31,13,13,1,1,38,38,46,46,18,18,4,4,43,43,34,34,14,14,40,40,40,40,16,16,52,52,30,30,5,5,37,37,20,20,15,15,19,19,6,6,35,35,9,9,38,38,14,14,41,41,22,22,36,36,2,2,61,61,57,57,46,46,10,10,41,41,39,39,6,6,32,32,6,6,14,14,20,20,51,51,23,23,1,1,42,42,46,46,48,48,18,18,3,3,61,61,41,41,32,32,17,17,56,56,32,32,17,17,46,46,19,19,22,22,17,17,12,12,17,17,33,33,9,9,10,10,22,22,46,46,3,3,50,50,61,61,23,23,45,45,55,55,37,37,16,16,34,34,46,46,51,51,46,46,60,60,0,0,51,51,5,5,14,14,30,30,45,45,49,49,10,10,59,59,1,1,14,14,22,22,38,38,42,42,40,40,27,27,0,0,52,52,61,61,6,6,56,56,46,46,11,11,35,35,44,44,29,29,1,1,1,1,11,11,26,26,33,33,23,23,7,7,31,31,39,39,60,60,49,49,23,23,10,10,48,48,36,36,53,53,3,3,1,1,34,34,26,26,57,57,43,43,38,38,8,8,53,53,16,16,33,33,63,63,46,46,1,1,14,14,12,12,5,5,11,11,60,60,10,10,52,52,16,16,60,60,26,26,20,20,2,2,7,7,48,48,18,18,12,12,39,39,27,27,17,17,44,44,2,2,31,31,15,15,6,6,43,43,2,2,16,16,27,27,20,20,3,3,53,53,50,50,8,8,30,30,17,17,9,9,48,48,18,18,23,23,43,43,6,6,33,33,40,40,13,13,32,32,11,11,36,36,57,57,0,0,53,53,31,31,17,17,50,50,26,26,28,28,50,50,56,56,52,52,38,38,59,59,18,18,44,44,63,63,8,8,31,31,30,30,21,21,53,53,59,59,3,3,0,0,12,12,59,59,34,34,47,47,35,35,63,63,11,11,31,31,43,43,36,36,57,57,36,36,34,34,25,25,10,10,33,33,13,13,49,49,11,11,16,16,43,43,29,29,20,20,7,7,6,6,56,56,40,40,34,34,13,13,55,55,40,40,30,30,16,16,8,8,62,62,33,33,62,62,49,49,5,5,49,49,58,58,62,62,1,1,32,32,32,32,35,35,0,0,12,12,36,36,47,47,4,4,27,27,13,13,45,45,33,33,53,53,34,34,38,38,45,45,14,14,49,49,7,7,29,29,45,45,20,20,30,30,4,4,12,12,28,28,36,36,31,31,35,35,1,1,5,5,9,9,52,52,3,3,5,5,59,59,22,22,16,16,17,17,20,20,25,25,39,39,0,0,13,13,25,25,8,8,37,37,9,9,5,5,50,50,8,8,45,45,34,34,10,10,0,0,52,52,13,13,41,41,6,6,11,11,0,0,55,55,27,27,62,62,13,13,52,52,32,32,54,54,50,50,24,24,48,48,61,61,48,48,31,31,38,38,41,41,23,23,16,16,23,23,27,27,28,28,43,43,42,42,47,47,40,40,60,60,8,8,58,58,52,52,35,35,23,23,56,56,42,42,40,40,25,25,44,44,62,62,37,37,27,27,47,47,45,45,43,43,51,51,33,33,52,52,10,10,53,53,52,52,35,35,43,43,12,12,61,61,60,60,44,44,57,57,47,47,63,63,8,8,32,32,53,53,5,5,19,19,28,28,55,55,14,14,27,27,61,61,40,40,44,44,37,37,25,25,36,36,4,4,45,45,25,25,49,49,54,54,53,53,26,26,52,52,58,58,17,17,56,56,61,61,40,40,58,58,57,57,9,9,1,1,63,63,38,38,38,38,15,15,17,17,28,28,12,12,36,36,35,35,0,0,46,46,47,47,2,2,41,41,34,34,13,13,39,39,4,4,48,48,55,55,30,30,35,35,48,48,19,19,9,9,49,49,3,3,29,29,55,55,8,8,53,53,63,63,15,15,33,33,5,5,56,56,54,54,4,4,57,57,11,11,35,35,16,16,24,24,10,10,52,52,25,25,49,49,62,62,43,43,63,63,21,21,37,37,5,5,50,50,21,21,36,36,21,21,56,56,47,47,16,16,63,63,39,39,31,31,51,51,51,51,37,37,14,14,40,40,24,24,49,49,44,44,58,58,31,31,63,63,25,25,21,21,2,2,25,25,36,36,1,1,37,37,4,4,30,30,47,47,4,4,51,51,16,16,26,26,52,52,12,12,0,0,16,16,23,23,2,2,2,2,23,23,1,1,21,21,37,37,27,27,9,9,47,47,43,43,16,16,18,18,26,26,15,15,0,0,17,17,20,20,39,39,41,41,21,21,61,61,41,41,1,1,13,13,9,9,36,36,27,27,3,3,7,7,7,7,62,62,43,43,41,41,37,37,57,57,49,49,46,46,33,33,61,61,2,2,54,54,54,54,10,10,1,1,16,16,24,24,24,24,20,20,58,58,12,12,33,33,15,15,2,2,31,31,41,41,38,38,12,12,23,23,29,29,36,36,43,43,36,36,43,43,34,34,55,55,33,33,11,11,18,18,44,44,53,53,35,35,40,40,37,37,52,52,36,36,50,50,52,52,32,32,40,40,58,58,53,53,14,14,35,35,32,32,42,42,23,23,9,9,61,61,47,47,58,58,15,15,28,28,62,62,8,8,6,6,22,22,4,4,12,12,14,14,48,48,5,5,12,12,24,24,8,8,57,57,42,42,41,41,42,42,29,29,24,24,48,48,6,6,22,22,28,28,29,29,42,42,18,18,49,49,0,0,10,10,40,40,30,30,51,51,5,5,45,45,13,13,37,37,27,27,33,33,45,45,37,37,8,8,2,2,3,3,15,15,16,16,52,52,49,49,16,16,51,51,6,6,1,1,37,37,42,42,5,5,36,36,46,46,7,7,56,56,1,1,17,17,14,14,55,55,44,44,7,7,2,2,42,42,16,16,24,24,8,8,53,53,4,4,27,27,33,33,26,26,53,53,18,18,5,5,44,44,36,36,59,59,22,22,21,21,52,52,4,4,18,18,59,59,37,37,11,11,53,53,2,2,56,56,20,20,37,37,9,9,28,28,24,24,27,27,26,26,19,19,20,20,24,24,49,49,30,30,5,5,46,46,3,3,12,12,18,18,44,44,9,9,4,4,17,17,8,8,4,4,41,41,12,12,18,18,33,33,15,15,47,47,25,25,4,4,59,59,21,21,22,22,10,10,41,41,10,10,22,22,49,49,6,6,62,62,60,60,33,33,36,36,53,53,48,48,37,37,7,7,56,56,15,15,63,63,38,38,56,56,61,61,39,39,47,47,37,37,7,7,61,61,20,20,12,12,5,5,20,20,38,38,51,51,2,2,29,29,25,25,40,40,23,23,5,5,2,2,39,39,48,48,5,5,36,36,9,9,23,23,1,1,49,49,16,16,42,42,28,28,17,17,40,40,21,21,32,32,40,40,25,25,48,48,36,36,15,15,1,1,31,31,44,44,46,46,33,33,16,16,33,33,47,47,11,11,56,56,16,16,4,4,27,27,38,38,36,36,25,25,6,6,24,24,23,23,35,35,35,35,51,51,16,16,42,42,33,33,62,62,17,17,26,26,32,32,6,6,13,13,22,22,20,20,29,29,25,25,63,63,21,21,47,47,32,32,40,40,59,59,1,1,16,16,53,53,11,11,14,14,39,39,62,62,18,18,62,62,0,0,9,9,29,29,3,3,56,56,15,15,58,58,46,46,34,34,13,13,45,45,30,30,7,7,24,24,1,1,50,50,53,53,56,56,12,12,45,45,27,27,2,2,22,22,60,60,44,44,24,24,8,8,32,32,17,17,31,31,55,55,2,2,44,44,19,19,18,18,44,44,26,26,16,16,17,17,23,23,61,61,41,41,46,46,21,21,18,18,56,56,16,16,10,10,37,37,55,55,23,23,14,14,29,29,19,19,58,58,4,4,40,40,43,43,27,27,3,3,30,30,2,2,12,12,50,50,23,23,56,56,6,6,61,61,0,0,38,38,34,34,39,39,37,37,40,40,20,20,30,30,13,13,33,33,60,60,56,56,21,21,14,14,17,17,57,57,13,13,54,54,60,60,36,36,50,50,14,14,58,58,33,33,40,40,30,30,54,54,14,14,50,50,45,45,26,26,0,0,21,21,35,35,48,48,19,19,40,40,17,17,25,25,45,45,16,16,61,61,19,19,62,62,52,52,17,17,45,45,27,27,9,9,10,10,21,21,10,10,25,25,29,29,8,8,4,4,55,55,24,24,24,24,18,18,58,58,57,57,35,35,62,62,41,41,14,14,47,47,48,48,36,36,52,52,59,59,16,16,61,61,32,32,12,12,5,5,28,28,4,4,60,60,59,59,17,17,0,0,17,17,17,17,47,47,11,11,10,10,56,56,38,38,26,26,46,46,12,12,43,43,24,24,62,62,47,47,38,38,53,53,31,31,30,30,63,63,4,4,5,5,52,52,53,53,26,26,5,5,30,30,38,38,9,9,2,2,3,3,4,4,44,44,39,39,38,38,9,9,31,31,9,9,45,45,50,50,46,46,29,29,13,13,24,24,48,48,62,62,47,47,35,35,24,24,49,49,45,45,7,7,24,24,60,60,55,55,36,36,31,31,4,4,62,62,26,26,0,0,1,1,36,36,42,42,17,17,34,34,4,4,62,62,14,14,0,0,58,58,58,58,56,56,4,4,44,44,43,43,57,57,5,5,47,47,24,24,19,19,61,61,34,34,62,62,29,29,27,27,24,24,11,11,55,55,29,29,53,53,2,2,37,37,21,21,61,61,48,48,21,21,21,21,39,39,59,59,54,54,36,36,30,30,39,39,31,31,14,14,34,34,26,26,7,7,36,36,2,2,57,57,47,47,63,63,4,4,0,0,32,32,32,32,24,24,50,50,0,0,29,29,42,42,21,21,15,15,12,12,22,22,47,47,18,18,1,1,50,50,19,19,15,15,55,55,45,45,58,58,39,39,0,0,18,18,57,57,53,53,8,8,13,13,34,34,2,2,28,28,5,5,30,30,52,52,23,23,31,31,20,20,2,2,16,16,10,10,12,12,10,10,35,35,30,30,36,36,29,29,61,61,8,8,48,48,59,59,45,45,36,36,15,15,14,14,51,51,29,29,1,1,20,20,2,2,26,26,38,38,26,26,11,11,54,54,12,12,30,30,58,58,32,32,17,17,56,56,0,0,58,58,49,49,36,36,48,48,39,39,12,12,13,13,42,42,11,11,52,52,3,3,10,10,29,29,20,20,41,41,14,14,1,1,43,43,10,10,51,51,50,50,40,40,45,45,6,6,23,23,28,28,16,16,24,24,56,56,12,12,8,8,57,57,1,1,50,50,9,9,9,9,13,13,24,24,56,56,57,57,20,20,19,19,24,24,50,50,48,48,26,26,51,51,17,17,53,53,56,56,4,4,24,24,16,16,34,34,12,12,24,24,48,48,58,58,22,22,31,31,50,50,15,15,27,27,25,25,16,16,12,12,32,32,16,16,42,42,61,61,30,30,27,27,26,26,37,37,9,9,2,2,4,4,9,9,41,41,27,27,58,58,50,50,30,30,49,49,59,59,41,41,2,2,34,34,7,7,62,62,60,60,44,44,37,37,30,30,59,59,34,34,46,46,31,31,19,19,59,59,37,37,13,13,56,56,42,42,11,11,61,61,26,26,54,54,33,33,17,17,55,55,13,13,29,29,27,27,53,53,53,53,62,62,34,34,35,35,41,41,6,6,5,5,17,17,16,16,49,49,20,20,22,22,14,14,49,49,38,38,46,46,11,11,5,5,15,15,27,27,25,25,54,54,4,4,41,41,61,61,22,22,8,8,37,37,56,56,17,17,41,41,23,23,8,8,10,10,56,56,50,50,23,23,57,57,56,56,8,8,53,53,60,60,29,29,53,53,46,46,45,45,38,38,38,38,19,19,36,36,8,8,20,20,34,34,51,51,34,34,47,47,48,48,3,3,14,14,17,17,8,8,52,52,15,15,18,18,20,20,36,36,29,29,0,0,33,33,20,20,48,48,8,8,55,55,1,1,36,36,43,43,52,52,38,38,3,3,17,17,21,21,6,6,25,25,63,63,33,33,30,30,54,54,11,11,0,0,37,37,39,39,53,53,48,48,14,14,63,63,45,45,53,53,46,46,10,10,49,49,54,54,41,41,48,48,4,4,54,54,46,46,12,12,44,44,36,36,17,17,3,3,21,21,33,33,13,13,0,0,55,55,19,19,54,54,8,8,0,0,47,47,27,27,18,18,23,23,63,63,42,42,37,37,14,14,47,47,35,35,46,46,58,58,45,45,58,58,58,58,6,6,30,30,4,4,25,25,20,20,12,12,11,11,45,45,8,8,2,2,59,59,7,7,2,2,16,16,42,42,4,4,32,32,21,21,43,43,31,31,48,48,42,42,18,18,4,4,13,13,29,29,20,20,48,48,39,39,44,44,12,12,20,20,40,40,45,45,33,33,8,8,47,47,32,32,53,53,57,57,49,49,46,46,4,4,26,26,56,56,18,18,18,18,44,44,32,32,39,39,57,57,14,14,1,1,14,14,20,20,47,47,37,37,14,14,4,4,0,0,14,14,8,8,13,13,23,23,35,35,18,18,46,46,5,5,9,9,20,20,13,13,9,9,50,50,46,46,2,2,4,4,3,3,3,3,5,5,56,56,32,32,52,52,53,53,28,28,31,31,2,2,39,39,60,60,16,16,48,48,42,42,25,25,15,15,42,42,53,53,6,6,37,37,34,34,56,56,53,53,46,46,46,46,7,7,20,20,46,46,41,41,45,45,4,4,8,8,30,30,6,6,12,12,48,48,30,30,63,63,16,16,19,19,9,9,15,15,32,32,52,52,19,19,53,53,26,26,52,52,42,42,61,61,51,51,9,9,19,19,36,36,52,52,62,62,50,50,24,24,45,45,22,22,9,9,25,25,6,6,24,24,42,42,42,42,27,27,36,36,50,50,47,47,43,43,18,18,39,39,54,54,38,38,60,60,29,29,37,37,17,17,62,62,52,52,39,39,7,7,48,48,10,10,38,38,28,28,45,45,38,38,55,55,49,49,7,7,25,25,52,52,56,56,38,38,50,50,40,40,30,30,10,10,12,12,55,55,27,27,3,3,3,3,20,20,57,57,8,8,40,40,45,45,25,25,59,59,22,22,12,12,60,60,56,56,18,18,4,4,15,15,18,18,22,22,12,12,45,45,53,53,40,40,50,50,9,9,8,8,35,35,10,10,56,56,5,5,30,30,43,43,13,13,7,7,33,33,13,13,21,21,51,51,38,38,21,21,56,56,63,63,51,51,41,41,25,25,41,41,15,15,2,2,14,14,46,46,7,7,34,34,10,10,35,35,43,43,54,54,27,27,56,56,27,27,35,35,44,44,21,21,17,17,5,5,55,55,2,2,58,58,29,29,56,56,60,60,12,12,58,58,31,31,47,47,59,59,49,49,0,0,0,0,36,36,57,57,18,18,10,10,27,27,32,32,25,25,39,39,13,13,4,4,54,54,18,18,51,51,58,58,15,15,34,34,2,2,4,4,12,12,45,45,56,56,18,18,55,55,37,37,19,19,14,14,10,10,55,55,47,47,18,18,12,12,8,8,60,60,55,55,52,52,56,56,42,42,6,6,57,57,39,39,19,19,44,44,40,40,13,13,43,43,41,41,30,30,55,55,41,41,38,38,56,56,62,62,15,15,42,42,63,63,45,45,48,48,32,32,38,38,37,37,20,20,33,33,59,59,46,46,25,25,49,49,31,31,9,9,24,24,48,48,14,14,31,31,43,43,32,32,38,38,11,11,28,28,61,61,42,42,55,55,34,34,38,38,38,38,40,40,50,50,51,51,15,15,53,53,19,19,58,58,35,35,20,20,33,33,38,38,10,10,14,14,0,0,22,22,47,47,20,20,46,46,35,35,57,57,55,55,27,27,60,60,1,1,19,19,25,25,32,32,19,19,12,12,62,62,59,59,0,0,46,46,41,41,12,12,21,21,11,11,12,12,43,43,20,20,32,32,53,53,9,9,58,58,1,1,42,42,41,41,9,9,25,25,23,23,43,43,36,36,0,0,31,31,48,48,22,22,21,21,48,48,41,41,38,38,40,40,20,20,28,28,57,57,32,32,25,25,26,26,5,5,41,41,0,0,10,10,13,13,53,53,59,59,13,13,21,21,43,43,19,19,40,40,41,41,61,61,61,61,16,16,16,16,33,33,38,38,13,13,31,31,3,3,48,48,39,39,32,32,40,40,6,6,35,35,52,52,53,53,5,5,45,45,59,59,43,43,12,12,5,5,41,41,34,34,37,37,12,12,43,43,60,60,19,19,47,47,48,48,28,28,38,38,48,48,3,3,28,28,47,47,17,17,38,38,16,16,53,53,57,57,57,57,28,28,38,38,47,47,63,63,17,17,15,15,43,43,32,32,20,20,0,0,27,27,20,20,16,16,56,56,19,19,35,35,42,42,16,16,23,23,4,4,35,35,39,39,47,47,27,27,41,41,16,16,34,34,21,21,8,8,56,56,56,56,20,20,14,14,5,5,28,28,59,59,5,5,12,12,58,58,38,38,41,41,49,49,54,54,39,39,53,53,39,39,53,53,57,57,8,8,12,12,51,51,43,43,37,37,17,17,0,0,29,29,57,57,34,34,56,56,35,35,15,15,6,6,5,5,9,9,55,55,21,21,3,3,3,3,11,11,21,21,6,6,0,0,0,0,47,47,7,7,10,10,5,5,0,0,3,3,25,25,0,0,49,49,8,8,22,22,24,24,0,0,21,21,12,12,55,55,28,28,7,7,17,17,28,28,34,34,16,16,4,4,30,30,26,26,12,12,51,51,55,55,39,39,26,26,63,63,22,22,26,26,53,53,52,52,58,58,61,61,56,56,33,33,59,59,46,46,46,46,63,63,4,4,22,22,48,48,53,53,33,33,56,56,2,2,15,15,57,57,14,14,28,28,32,32,28,28,18,18,5,5,52,52,54,54,17,17,59,59,35,35,58,58,26,26,1,1,3,3,56,56,25,25,10,10,35,35,46,46,1,1,11,11,61,61,20,20,7,7,45,45,4,4,51,51,54,54,26,26,38,38,33,33,48,48,3,3,56,56,25,25,35,35,62,62,62,62,17,17,15,15,8,8,10,10,20,20,27,27,48,48,48,48,28,28,4,4,62,62,59,59,13,13,9,9,12,12,48,48,51,51,41,41,19,19,60,60,57,57,10,10,50,50,30,30,48,48,12,12,3,3,14,14,41,41,36,36,28,28,39,39,36,36,40,40,61,61,29,29,1,1,41,41,15,15,25,25,51,51,32,32,20,20,38,38,59,59,60,60,28,28,27,27,24,24,48,48,57,57,7,7,20,20,50,50,22,22,60,60,20,20,38,38,22,22,48,48,36,36,38,38,50,50,62,62,1,1,14,14,62,62,56,56,61,61,53,53,39,39,16,16,27,27,33,33,62,62,14,14,13,13,26,26,32,32,43,43,10,10,16,16,13,13,46,46,8,8,20,20,26,26,34,34,28,28,42,42,18,18,52,52,47,47,12,12,25,25,55,55,10,10,55,55,13,13,2,2,52,52,50,50,20,20,48,48,38,38,42,42,2,2,12,12,56,56,7,7,13,13,52,52,15,15,58,58,29,29,13,13,27,27,40,40,62,62,18,18,36,36,12,12,11,11,51,51,32,32,52,52,12,12,47,47,29,29,25,25,35,35,1,1,48,48,50,50,34,34,6,6,17,17,35,35,24,24,57,57,5,5,50,50,36,36,21,21,19,19,52,52,56,56,23,23,49,49,49,49,62,62,16,16,34,34,48,48,43,43,25,25,31,31,42,42,2,2,63,63,35,35,22,22,9,9,16,16,40,40,43,43,57,57,23,23,20,20,17,17,27,27,20,20,16,16,51,51,27,27,31,31,18,18,57,57,54,54,40,40,60,60,59,59,25,25,5,5,41,41,51,51,5,5,55,55,5,5,2,2,34,34,40,40,44,44,3,3,41,41,36,36,6,6,57,57,7,7,8,8,28,28,44,44,21,21,1,1,38,38,1,1,30,30,52,52,36,36,57,57,51,51,4,4,41,41,9,9,18,18,56,56,46,46,58,58,2,2,32,32,35,35,32,32,57,57,54,54,35,35,10,10,22,22,12,12,37,37,18,18,10,10,17,17,38,38,23,23,10,10,26,26,44,44,45,45,42,42,49,49,14,14,54,54,2,2,45,45,54,54,61,61,11,11,60,60,58,58,15,15,40,40,10,10,16,16,46,46,19,19,0,0,16,16,34,34,29,29,18,18,51,51,55,55,40,40,48,48,34,34,59,59,24,24,29,29,43,43,46,46,3,3,29,29,6,6,29,29,58,58,8,8,19,19,15,15,17,17,2,2,63,63,27,27,17,17,10,10,45,45,12,12,17,17,1,1,55,55,48,48,43,43,14,14,8,8,24,24,8,8,5,5,34,34,8,8,6,6,48,48,34,34,23,23,48,48,40,40,6,6,47,47,2,2,40,40,24,24,24,24,58,58,14,14,22,22,26,26,32,32,34,34,60,60,22,22,7,7,16,16,0,0,14,14,43,43,29,29,28,28,30,30,51,51,25,25,51,51,24,24,2,2,62,62,17,17,6,6,37,37,60,60,26,26,32,32,60,60,57,57,9,9,16,16,24,24,54,54,44,44,0,0,61,61,61,61,32,32,36,36,40,40,0,0,6,6,29,29,62,62,47,47,40,40,63,63,49,49,34,34,36,36,29,29,1,1,49,49,39,39,50,50,45,45,30,30,28,28,5,5,18,18,49,49,2,2,4,4,10,10,43,43,14,14,9,9,27,27,29,29,1,1,60,60,57,57,36,36,5,5,14,14,34,34,32,32,25,25,42,42,34,34,3,3,38,38,24,24,3,3,36,36,13,13,39,39,32,32,51,51,49,49,30,30,16,16,41,41,12,12,48,48,42,42,57,57,21,21,14,14,18,18,17,17,33,33,8,8,5,5,37,37,44,44,8,8,55,55,29,29,52,52,17,17,5,5,9,9,45,45,38,38,22,22,2,2,32,32,48,48,35,35,45,45,10,10,21,21,4,4,61,61,4,4,42,42,45,45,37,37,40,40,8,8,11,11,56,56,60,60,48,48,5,5,29,29,38,38,21,21,13,13,37,37,20,20,62,62,37,37,4,4,23,23,13,13,22,22,5,5,2,2,20,20,29,29,22,22,17,17,36,36,61,61,24,24,38,38,20,20,10,10,42,42,2,2,45,45,57,57,0,0,61,61,52,52,53,53,9,9,9,9,56,56,17,17,43,43,48,48,14,14,53,53,45,45,38,38,6,6,40,40,16,16,8,8,5,5,7,7,48,48,50,50,3,3,60,60,55,55,30,30,44,44,2,2,32,32,40,40,22,22,17,17,62,62,39,39,42,42,48,48,40,40,52,52,11,11,23,23,0,0,52,52,40,40,21,21,42,42,51,51,12,12,27,27,49,49,3,3,11,11,30,30,45,45,29,29,13,13,8,8,16,16,17,17,42,42,24,24,15,15,42,42,45,45,46,46,26,26,10,10,29,29,14,14,57,57,17,17,14,14,30,30,48,48,10,10,50,50,36,36,26,26,14,14,9,9,22,22,54,54,12,12,9,9,63,63,28,28,45,45,1,1,9,9,27,27,11,11,43,43,54,54,11,11,50,50,6,6,8,8,43,43,62,62,2,2,25,25,51,51,20,20,38,38,53,53,22,22,57,57,49,49,46,46,14,14,58,58,7,7,9,9,56,56,0,0,6,6,25,25,41,41,27,27,6,6,6,6,45,45,0,0,17,17,19,19,7,7,54,54,11,11,6,6,63,63,6,6,16,16,5,5,21,21,41,41,58,58,9,9,27,27,25,25,28,28,52,52,9,9,63,63,14,14,34,34,2,2,13,13,37,37,34,34,29,29,58,58,26,26,52,52,26,26,22,22,38,38,40,40,37,37,36,36,5,5,3,3,25,25,19,19,35,35,10,10,21,21,2,2,52,52,12,12,8,8,28,28,27,27,8,8,57,57,1,1,23,23,2,2,1,1,34,34,27,27,18,18,44,44,35,35,46,46,19,19,21,21,24,24,1,1,37,37,3,3,34,34,46,46,34,34,42,42,21,21,51,51,9,9,51,51,6,6,48,48,10,10,61,61,41,41,23,23,14,14,12,12,34,34,44,44,31,31,38,38,28,28,15,15,33,33,9,9,33,33,12,12,17,17,23,23,38,38,13,13,31,31,45,45,3,3,27,27,46,46,7,7,24,24,36,36,15,15,23,23,41,41,41,41,11,11,9,9,60,60,8,8,43,43,21,21,40,40,17,17,28,28,29,29,16,16,53,53,8,8,44,44,63,63,33,33,3,3,26,26,15,15,55,55,13,13,14,14,4,4,2,2,14,14,14,14,63,63,29,29,4,4,7,7,44,44,7,7,18,18,38,38,53,53,51,51,38,38,51,51,6,6,13,13,4,4,27,27,41,41,26,26,16,16,10,10,31,31,45,45,20,20,14,14,40,40,17,17,44,44,58,58,34,34,5,5,32,32,42,42,13,13,60,60,42,42,6,6,4,4,48,48,40,40,6,6,49,49,24,24,2,2,25,25,29,29,58,58,47,47,48,48,20,20,5,5,41,41,5,5,50,50,37,37,2,2,27,27,11,11,17,17,24,24,40,40,46,46,48,48,57,57,13,13,39,39,35,35,0,0,37,37,58,58,56,56,19,19,14,14,17,17,33,33,33,33,25,25,61,61,61,61,46,46,22,22,12,12,34,34,12,12,9,9,23,23,24,24,3,3,48,48,54,54,27,27,35,35,18,18,45,45,19,19,52,52,52,52,48,48,4,4,60,60,12,12,15,15,48,48,29,29,62,62,55,55,7,7,52,52,38,38,23,23,32,32,20,20,9,9,37,37,16,16,21,21,40,40,35,35,6,6,38,38,55,55,53,53,33,33,62,62,61,61,28,28,61,61,26,26,3,3,34,34,26,26,20,20,12,12,47,47,52,52,19,19,34,34,26,26,16,16,19,19,27,27,5,5,46,46,10,10,1,1,55,55,9,9,63,63,3,3,24,24,13,13,36,36,8,8,43,43,11,11,46,46,0,0,29,29,46,46,37,37,51,51,15,15,49,49,14,14,11,11,31,31,5,5,17,17,28,28,15,15,0,0,18,18,26,26,18,18,21,21,19,19,5,5,1,1,52,52,30,30,48,48,61,61,16,16,11,11,7,7,46,46,45,45,48,48,17,17,8,8,36,36,50,50,16,16,53,53,50,50,63,63,53,53,50,50,37,37,52,52,0,0,27,27,29,29,59,59,18,18,30,30,10,10,63,63,28,28,42,42,17,17,8,8,17,17,17,17,27,27,17,17,39,39,51,51,47,47,35,35,43,43,41,41,4,4,61,61,23,23,58,58,43,43,58,58,14,14,50,50,34,34,47,47,16,16,34,34,50,50,32,32,27,27,12,12,40,40,28,28,39,39,54,54,14,14,36,36,38,38,8,8,34,34,0,0,30,30,48,48,61,61,10,10,32,32,9,9,26,26,38,38,2,2,35,35,8,8,22,22,2,2,61,61,11,11,43,43,18,18,52,52,34,34,13,13,54,54,36,36,62,62,46,46,45,45,10,10,40,40,0,0,48,48,48,48,17,17,36,36,60,60,23,23,17,17,5,5,40,40,19,19,10,10,43,43,50,50,25,25,0,0,14,14,60,60,13,13,4,4,8,8,26,26,26,26,3,3,43,43,4,4,43,43,3,3,43,43,43,43,49,49,8,8,44,44,48,48,61,61,19,19,60,60,16,16,41,41,33,33,7,7,58,58,56,56,12,12,53,53,3,3,19,19,52,52,55,55,20,20,53,53,39,39,58,58,44,44,16,16,51,51,19,19,45,45,41,41,57,57,45,45,8,8,17,17,58,58,56,56,40,40,59,59,57,57,1,1,33,33,53,53,41,41,39,39,12,12,30,30,8,8,57,57,40,40,32,32,50,50,27,27,63,63,14,14,30,30,34,34,25,25,40,40,10,10,56,56,41,41,18,18,20,20,35,35,47,47,26,26,4,4,14,14,56,56,2,2,21,21,7,7,47,47,36,36,40,40,45,45,16,16,27,27,10,10,25,25,2,2,63,63,13,13,21,21,23,23,11,11,5,5,61,61,25,25,56,56,42,42,32,32,5,5,28,28,12,12,42,42,46,46,27,27,49,49,18,18,14,14,38,38,41,41,10,10,21,21,0,0,41,41,30,30,59,59,3,3,32,32,8,8,14,14,60,60,33,33,47,47,56,56,22,22,8,8,59,59,18,18,7,7,0,0,5,5,48,48,1,1,14,14,14,14,48,48,21,21,1,1,31,31,43,43,13,13,44,44,49,49,15,15,40,40,58,58,34,34,8,8,54,54,19,19,54,54,12,12,36,36,58,58,4,4,38,38,55,55,1,1,46,46,34,34,33,33,52,52,28,28,60,60,36,36,41,41,7,7,34,34,1,1,36,36,53,53,17,17,16,16,15,15,52,52,22,22,30,30,39,39,16,16,46,46,61,61,51,51,2,2,40,40,3,3,57,57,6,6,23,23,2,2,46,46,40,40,40,40,45,45,1,1,2,2,41,41,27,27,57,57,34,34,57,57,30,30,51,51,0,0,25,25,44,44,13,13,41,41,32,32,4,4,52,52,27,27,48,48,21,21,45,45,3,3,62,62,6,6,43,43,3,3,14,14,12,12,1,1,35,35,46,46,35,35,14,14,50,50,32,32,10,10,24,24,42,42,25,25,60,60,23,23,16,16,22,22,1,1,28,28,6,6,54,54,25,25,30,30,28,28,58,58,62,62,0,0,4,4,55,55,38,38,49,49,55,55,28,28,29,29,16,16,18,18,53,53,45,45,32,32,32,32,39,39,55,55,34,34,5,5,61,61,43,43,17,17,8,8,7,7,7,7,63,63,53,53,12,12,32,32,3,3,45,45,60,60,53,53,41,41,17,17,29,29,35,35,40,40,10,10,59,59,18,18,0,0,45,45,45,45,20,20,25,25,46,46,9,9,51,51,43,43,58,58,20,20,0,0,13,13,30,30,8,8,58,58,57,57,57,57,54,54,46,46,7,7,7,7,11,11,0,0,33,33,10,10,46,46,3,3,22,22,52,52,8,8,61,61,34,34,11,11,38,38,48,48,16,16,62,62,57,57,5,5,36,36,12,12,1,1,48,48,58,58,17,17,45,45,40,40,46,46,57,57,7,7,6,6,32,32,17,17,24,24,56,56,56,56,57,57,59,59,17,17,3,3,4,4,42,42,27,27,6,6,11,11,11,11,55,55,21,21,8,8,50,50,7,7,42,42,27,27,0,0,13,13,37,37,14,14,8,8,26,26,37,37,4,4,59,59,62,62,42,42,7,7,36,36,45,45,63,63,32,32,27,27,30,30,23,23,60,60,42,42,41,41,37,37,61,61,4,4,45,45,4,4,2,2,23,23,24,24,29,29,2,2,40,40,32,32,16,16,26,26,63,63,24,24,37,37,6,6,28,28,27,27,54,54,14,14,25,25,46,46,8,8,23,23,22,22,6,6,40,40,20,20,16,16,49,49,6,6,56,56,18,18,37,37,39,39,24,24,57,57,13,13,61,61,4,4,21,21,21,21,40,40,41,41,36,36,53,53,18,18,57,57,13,13,55,55,0,0,48,48,59,59,59,59,18,18,26,26,15,15,58,58,59,59,18,18,14,14,1,1,59,59,50,50,2,2,54,54,40,40,16,16,11,11,15,15,27,27,0,0,5,5,42,42,41,41,42,42,47,47,5,5,6,6,62,62,58,58,23,23,52,52,62,62,29,29,32,32,24,24,16,16,1,1,12,12,25,25,44,44,3,3,43,43,42,42,55,55,31,31,36,36,47,47,40,40,29,29,24,24,21,21,9,9,47,47,38,38,16,16,43,43,16,16,15,15,17,17,6,6,2,2,34,34,5,5,12,12,38,38,50,50,9,9,2,2,19,19,25,25,53,53,9,9,19,19,63,63,35,35,50,50,26,26,25,25,15,15,56,56,21,21,45,45,32,32,50,50,4,4,30,30,49,49,42,42,55,55,52,52,60,60,10,10,50,50,20,20,24,24,23,23,49,49,41,41,38,38,31,31,29,29,44,44,60,60,3,3,30,30,26,26,52,52,29,29,25,25,29,29,12,12,47,47,40,40,39,39,52,52,46,46,19,19,26,26,37,37,58,58,60,60,15,15,22,22,32,32,29,29,52,52,22,22,24,24,2,2,1,1,8,8,10,10,60,60,56,56,46,46,36,36,4,4,3,3,43,43,32,32,46,46,40,40,59,59,56,56,7,7,18,18,31,31,6,6,32,32,14,14,32,32,2,2,55,55,3,3,11,11,24,24,20,20,22,22,0,0,20,20,29,29,50,50,50,50,3,3,5,5,0,0,17,17,30,30,16,16,57,57,36,36,11,11,6,6,13,13,4,4,18,18,30,30,27,27,16,16,26,26,6,6,56,56,59,59,43,43,19,19,42,42,3,3,54,54,59,59,7,7,36,36,2,2,9,9,57,57,34,34,34,34,36,36,26,26,54,54,20,20,8,8,58,58,16,16,34,34,40,40,54,54,63,63,54,54,13,13,17,17,18,18,31,31,0,0,2,2,16,16,8,8,3,3,30,30,19,19,49,49,62,62,6,6,57,57,46,46,44,44,34,34,61,61,56,56,56,56,45,45,11,11,10,10,44,44,27,27,36,36,17,17,16,16,45,45,49,49,56,56,41,41,41,41,59,59,25,25,8,8,6,6,21,21,56,56,35,35,43,43,48,48,43,43,33,33,41,41,52,52,12,12,2,2,14,14,47,47,20,20,58,58,48,48,0,0,9,9,42,42,21,21,25,25,11,11,50,50,28,28,8,8,25,25,34,34,52,52,45,45,39,39,39,39,41,41,50,50,33,33,37,37,9,9,51,51,39,39,34,34,37,37,53,53,63,63,39,39,7,7,50,50,48,48,15,15,44,44,52,52,52,52,13,13,50,50,27,27,50,50,26,26,36,36,8,8,54,54,23,23,24,24,13,13,41,41,56,56,18,18,24,24,10,10,21,21,33,33,35,35,31,31,0,0,33,33,44,44,37,37,13,13,26,26,13,13,8,8,6,6,56,56,54,54,41,41,25,25,7,7,23,23,1,1,34,34,29,29,46,46,24,24,33,33,19,19,35,35,22,22,18,18,2,2,34,34,54,54,33,33,55,55,45,45,52,52,55,55,58,58,38,38,7,7,51,51,25,25,9,9,43,43,32,32,42,42,57,57,39,39,7,7,52,52,14,14,55,55,25,25,4,4,47,47,58,58,10,10,57,57,14,14,51,51,1,1,28,28,29,29,12,12,18,18,48,48,63,63,63,63,37,37,22,22,32,32,50,50,22,22,13,13,6,6,53,53,1,1,46,46,21,21,47,47,58,58,62,62,24,24,32,32,1,1,36,36,36,36,30,30,63,63,55,55,37,37,7,7,13,13,3,3,18,18,53,53,3,3,33,33,28,28,6,6,10,10,25,25,56,56,56,56,48,48,24,24,61,61,63,63,58,58,22,22,1,1,16,16,19,19,23,23,29,29,40,40,57,57,4,4,25,25,57,57,34,34,29,29,32,32,48,48,50,50,20,20,5,5,47,47,55,55,62,62,4,4,62,62,3,3,56,56,2,2,9,9,62,62,0,0,6,6,22,22,56,56,58,58,9,9,20,20,37,37,11,11,45,45,10,10,7,7,18,18,34,34,10,10,15,15,42,42,20,20,53,53,35,35,55,55,21,21,12,12,17,17,26,26,44,44,12,12,1,1,54,54,45,45,0,0,3,3,0,0,34,34,34,34,9,9,38,38,28,28,23,23,1,1,62,62,58,58,21,21,22,22,24,24,61,61,13,13,23,23,10,10,22,22,8,8,58,58,16,16,17,17,31,31,2,2,31,31,51,51,23,23,20,20,56,56,10,10,29,29,54,54,13,13,8,8,53,53,7,7,27,27,9,9,55,55,24,24,1,1,36,36,38,38,22,22,16,16,50,50,5,5,25,25,41,41,1,1,38,38,52,52,33,33,30,30,5,5,57,57,60,60,0,0,36,36,9,9,16,16,17,17,42,42,0,0,16,16,26,26,61,61,58,58,23,23,42,42,54,54,18,18,22,22,15,15,36,36,25,25,1,1,56,56,40,40,61,61,35,35,40,40,15,15,32,32,31,31,4,4,51,51,50,50,58,58,31,31,19,19,63,63,51,51,52,52,38,38,40,40,30,30,52,52,32,32,20,20,62,62,60,60,38,38,17,17,31,31,5,5,6,6,14,14,7,7,3,3,21,21,33,33,41,41,0,0,10,10,63,63,57,57,16,16,33,33,45,45,6,6,33,33,60,60,50,50,43,43,0,0,14,14,34,34,16,16,13,13,8,8,42,42,63,63,0,0,48,48,41,41,2,2,11,11,36,36,62,62,11,11,62,62,59,59,20,20,17,17,4,4,2,2,22,22,17,17,0,0,30,30,63,63,61,61,14,14,43,43,2,2,32,32,0,0,38,38,21,21,21,21,14,14,42,42,8,8,40,40,15,15,50,50,30,30,24,24,53,53,24,24,61,61,50,50,58,58,4,4,2,2,49,49,55,55,43,43,34,34,10,10,54,54,44,44,24,24,28,28,24,24,43,43,53,53,19,19,63,63,5,5,6,6,28,28,52,52,2,2,10,10,3,3,12,12,8,8,32,32,5,5,47,47,45,45,18,18,26,26,51,51,0,0,59,59,34,34,17,17,44,44,28,28,56,56,59,59,53,53,57,57,40,40,42,42,36,36,52,52,31,31,49,49,52,52,40,40,51,51,62,62,46,46,56,56,36,36,10,10,41,41,56,56,52,52,30,30,8,8,33,33,9,9,7,7,55,55,6,6,34,34,36,36,49,49,52,52,28,28,44,44,4,4,52,52,46,46,35,35,1,1,50,50,48,48,14,14,46,46,62,62,48,48,24,24,24,24,10,10,12,12,18,18,0,0,36,36,7,7,10,10,44,44,52,52,51,51,10,10,7,7,43,43,47,47,12,12,25,25,56,56,41,41,20,20,26,26,5,5,12,12,51,51,14,14,31,31,27,27,15,15,1,1,59,59,41,41,50,50,6,6,57,57,40,40,15,15,25,25,41,41,14,14,62,62,32,32,19,19,56,56,12,12,4,4,56,56,40,40,24,24,31,31,53,53,7,7,63,63,31,31,51,51,61,61,49,49,42,42,59,59,5,5,34,34,31,31,19,19,59,59,61,61,5,5,56,56,26,26,48,48,32,32,39,39,47,47,58,58,19,19,3,3,34,34,0,0,17,17,44,44,45,45,32,32,22,22,10,10,27,27,51,51,61,61,0,0,20,20,45,45,57,57,2,2,9,9,43,43,1,1,15,15,34,34,38,38,24,24,44,44,13,13,63,63,7,7,48,48,20,20,34,34,0,0,37,37,39,39,23,23,35,35,51,51,7,7,31,31,2,2,4,4,25,25,6,6,54,54,12,12,9,9,54,54,21,21,55,55,59,59,53,53,24,24,40,40,43,43,14,14,17,17,15,15,14,14,21,21,3,3,61,61,60,60,9,9,55,55,46,46,2,2,28,28,1,1,10,10,47,47,45,45,16,16,43,43,51,51,6,6,47,47,20,20,7,7,8,8,53,53,60,60,4,4,48,48,24,24,32,32,18,18,24,24,38,38,47,47,15,15,16,16,32,32,46,46,5,5,24,24,20,20,1,1,61,61,2,2,6,6,39,39,40,40,5,5,0,0,35,35,52,52,7,7,46,46,47,47,40,40,17,17,33,33,48,48,59,59,9,9,11,11,7,7,14,14,62,62,23,23,26,26,32,32,21,21,41,41,45,45,54,54,17,17,45,45,34,34,7,7,2,2,7,7,33,33,31,31,62,62,36,36,56,56,60,60,52,52,0,0,43,43,12,12,8,8,25,25,9,9,26,26,35,35,36,36,10,10,29,29,43,43,27,27,21,21,12,12,10,10,51,51,24,24,58,58,51,51,59,59,11,11,18,18,15,15,1,1,10,10,28,28,7,7,56,56,2,2,9,9,32,32,11,11,20,20,30,30,8,8,27,27,28,28,57,57,52,52,25,25,27,27,45,45,46,46,40,40,44,44,17,17,13,13,8,8,11,11,51,51,56,56,1,1,1,1,41,41,6,6,24,24,2,2,32,32,61,61,46,46,5,5,13,13,39,39,30,30,43,43,34,34,32,32,52,52,47,47,31,31,21,21,50,50,37,37,2,2,37,37,57,57,6,6,37,37,37,37,55,55,35,35,49,49,50,50,15,15,39,39,3,3,1,1,48,48,32,32,51,51,10,10,59,59,38,38,0,0,52,52,52,52,13,13,59,59,3,3,31,31,1,1,37,37,47,47,17,17,5,5,32,32,5,5,15,15,7,7,3,3,8,8,14,14,42,42,59,59,21,21,0,0,0,0,12,12,24,24,37,37,2,2,31,31,30,30,5,5,16,16,53,53,6,6,56,56,46,46,57,57,41,41,48,48,34,34,8,8,41,41,56,56,56,56,6,6,16,16,32,32,45,45,63,63,5,5,22,22,46,46,33,33,30,30,29,29,48,48,47,47,34,34,48,48,2,2,63,63,5,5,40,40,60,60,32,32,34,34,50,50,17,17,61,61,60,60,21,21,6,6,4,4,44,44,61,61,18,18,25,25,16,16,5,5,8,8,11,11,53,53,7,7,47,47,58,58,57,57,59,59,32,32,15,15,52,52,47,47,16,16,16,16,5,5,15,15,56,56,50,50,1,1,4,4,7,7,48,48,32,32,48,48,26,26,10,10,44,44,26,26,30,30,23,23,61,61,47,47,16,16,25,25,30,30,51,51,40,40,58,58,49,49,42,42,26,26,62,62,53,53,20,20,37,37,55,55,40,40,7,7,62,62,52,52,23,23,17,17,23,23,46,46,35,35,0,0,1,1,20,20,47,47,32,32,60,60,42,42,42,42,13,13,44,44,22,22,32,32,5,5,29,29,21,21,60,60,45,45,56,56,59,59,43,43,8,8,25,25,41,41,28,28,5,5,50,50,40,40,11,11,13,13,26,26,40,40,21,21,36,36,1,1,32,32,26,26,45,45,1,1,19,19,28,28,40,40,53,53,46,46,33,33,2,2,58,58,2,2,6,6,43,43,41,41,37,37,19,19,62,62,40,40,51,51,22,22,58,58,54,54,24,24,0,0,29,29,9,9,33,33,30,30,50,50,53,53,4,4,56,56,43,43,41,41,36,36,56,56,59,59,17,17,51,51,61,61,55,55,23,23,48,48,7,7,7,7,3,3,26,26,39,39,61,61,54,54,23,23,10,10,9,9,48,48,57,57,45,45,58,58,11,11,19,19,19,19,14,14,10,10,19,19,39,39,10,10,49,49,15,15,51,51,46,46,41,41,18,18,10,10,10,10,16,16,13,13,25,25,21,21,45,45,25,25,6,6,61,61,12,12,46,46,29,29,62,62,4,4,39,39,29,29,40,40,43,43,1,1,15,15,14,14,12,12,1,1,14,14,29,29,19,19,16,16,10,10,28,28,23,23,38,38,17,17,41,41,18,18,2,2,49,49,43,43,60,60,34,34,36,36,63,63,18,18,39,39,10,10,28,28,24,24,12,12,54,54,31,31,26,26,41,41,41,41,21,21,50,50,39,39,8,8,35,35,17,17,47,47,4,4,31,31,50,50,34,34,32,32,21,21,54,54,4,4,58,58,62,62,0,0,11,11,27,27,22,22,59,59,3,3,43,43,5,5,26,26,10,10,46,46,56,56,49,49,15,15,8,8,5,5,17,17,18,18,7,7,28,28,6,6,35,35,32,32,33,33,31,31,25,25,63,63,16,16,26,26,30,30,21,21,17,17,38,38,2,2,15,15,30,30,11,11,58,58,4,4,16,16,12,12,20,20,13,13,50,50,35,35,10,10,8,8,32,32,57,57,0,0,21,21,58,58,21,21,20,20,10,10,22,22,38,38,26,26,43,43,15,15,25,25,9,9,34,34,14,14,41,41,56,56,25,25,30,30,36,36,23,23,62,62,21,21,52,52,41,41,11,11,43,43,51,51,27,27,17,17,46,46,62,62,9,9,5,5,1,1,41,41,49,49,55,55,54,54,4,4,4,4,21,21,43,43,59,59,52,52,2,2,24,24,60,60,22,22,42,42,63,63,43,43,6,6,9,9,40,40,34,34,41,41,8,8,14,14,52,52,27,27,29,29,15,15,62,62,1,1,33,33,4,4,36,36,1,1,2,2,45,45,35,35,24,24,3,3,15,15,0,0,42,42,54,54,6,6,0,0,40,40,28,28,13,13,6,6,52,52,50,50,23,23,15,15,11,11,12,12,61,61,3,3,14,14,43,43,54,54,27,27,30,30,59,59,10,10,9,9,11,11,11,11,24,24,13,13,17,17,21,21,30,30,9,9,6,6,6,6,11,11,3,3,36,36,20,20,29,29,0,0,6,6,33,33,12,12,53,53,5,5,42,42,51,51,9,9,43,43,40,40,34,34,10,10,32,32,11,11,14,14,10,10,46,46,28,28,14,14,16,16,5,5,63,63,50,50,49,49,13,13,33,33,37,37,38,38,10,10,45,45,6,6,58,58,62,62,20,20,19,19,32,32,22,22,21,21,16,16,29,29,55,55,13,13,33,33,23,23,25,25,18,18,17,17,19,19,5,5,31,31,23,23,22,22,11,11,12,12,11,11,31,31,46,46,4,4,19,19,12,12,55,55,33,33,32,32,30,30,22,22,8,8,3,3,8,8,10,10,53,53,9,9,10,10,10,10,57,57,8,8,1,1,18,18,10,10,13,13,30,30,9,9,15,15,2,2,30,30,5,5,46,46,49,49,58,58,41,41,6,6,23,23,1,1,17,17,63,63,15,15,19,19,32,32,40,40,58,58,5,5,32,32,11,11,40,40,32,32,44,44,60,60,9,9,47,47,13,13,9,9,53,53,20,20,39,39,52,52,18,18,34,34,41,41,23,23,49,49,11,11,12,12,13,13,57,57,49,49,62,62,12,12,50,50,38,38,14,14,44,44,55,55,57,57,4,4,18,18,26,26,18,18,13,13,54,54,14,14,22,22,62,62,56,56,60,60,29,29,6,6,18,18,19,19,19,19,35,35,5,5,2,2,9,9,55,55,2,2,58,58,22,22,11,11,56,56,63,63,53,53,54,54,6,6,54,54,37,37,11,11,17,17,29,29,45,45,37,37,10,10,10,10,6,6,61,61,62,62,58,58,14,14,51,51,57,57,56,56,6,6,59,59,9,9,2,2,20,20,26,26,11,11,32,32,39,39,61,61,53,53,11,11,38,38,42,42,62,62,18,18,63,63,12,12,32,32,24,24,29,29,62,62,9,9,7,7,54,54,32,32,6,6,48,48,2,2,18,18,30,30,55,55,0,0,8,8,5,5,58,58,63,63,31,31,41,41,32,32,19,19,54,54,33,33,45,45,10,10,35,35,38,38,44,44,46,46,52,52,18,18,40,40,6,6,18,18,52,52,24,24,2,2,7,7,33,33,53,53,28,28,8,8,36,36,35,35,56,56,60,60,41,41,20,20,44,44,0,0,53,53,28,28,55,55,14,14,39,39,55,55,19,19,46,46,38,38,52,52,32,32,59,59,16,16,57,57,37,37,43,43,32,32,15,15,44,44,16,16,19,19,15,15,37,37,62,62,40,40,2,2,37,37,26,26,23,23,6,6,3,3,36,36,51,51,52,52,44,44,10,10,62,62,59,59,35,35,41,41,28,28,24,24,51,51,23,23,22,22,1,1,48,48,26,26,41,41,45,45,49,49,23,23,38,38,49,49,21,21,29,29,17,17,12,12,34,34,63,63,28,28,16,16,4,4,1,1,42,42,29,29,5,5,3,3,53,53,13,13,34,34,14,14,2,2,42,42,42,42,24,24,60,60,52,52,32,32,51,51,20,20,0,0,24,24,50,50,42,42,48,48,2,2,24,24,15,15,1,1,2,2,20,20,42,42,11,11,60,60,11,11,35,35,14,14,38,38,39,39,8,8,15,15,0,0,38,38,14,14,2,2,35,35,16,16,21,21,41,41,27,27,38,38,33,33,0,0,43,43,60,60,42,42,12,12,5,5,31,31,41,41,16,16,51,51,17,17,12,12,14,14,44,44,27,27,6,6,35,35,16,16,4,4,54,54,49,49,24,24,20,20,21,21,10,10,13,13,34,34,63,63,41,41,30,30,22,22,24,24,28,28,63,63,11,11,27,27,48,48,25,25,24,24,33,33,34,34,41,41,14,14,44,44,54,54,33,33,17,17,62,62,6,6,56,56,6,6,28,28,21,21,19,19,4,4,38,38,5,5,2,2,2,2,11,11,28,28,12,12,16,16,48,48,48,48,23,23,0,0,16,16,43,43,52,52,4,4,44,44,45,45,10,10,12,12,5,5,23,23,59,59,60,60,8,8,2,2,7,7,56,56,45,45,21,21,44,44,22,22,10,10,44,44,40,40,21,21,50,50,52,52,51,51,41,41,16,16,17,17,50,50,7,7,49,49,35,35,16,16,30,30,47,47,15,15,12,12,60,60,60,60,18,18,20,20,34,34,40,40,51,51,5,5,28,28,53,53,58,58,46,46,14,14,16,16,20,20,34,34,19,19,6,6,45,45,22,22,21,21,60,60,33,33,18,18,19,19,13,13,57,57,53,53,58,58,51,51,3,3,57,57,46,46,25,25,46,46,0,0,18,18,9,9,17,17,6,6,18,18,30,30,0,0,33,33,29,29,47,47,17,17,6,6,42,42,22,22,11,11,61,61,15,15,52,52,19,19,17,17,4,4,43,43,8,8,15,15,14,14,52,52,18,18,45,45,10,10,32,32,3,3,42,42,33,33,11,11,0,0,4,4,41,41,50,50,60,60,34,34,15,15,29,29,12,12,5,5,36,36,0,0,34,34,7,7,22,22,49,49,15,15,2,2,52,52,13,13,24,24,31,31,33,33,49,49,14,14,2,2,1,1,40,40,8,8,60,60,35,35,9,9,40,40,34,34,61,61,46,46,24,24,53,53,48,48,16,16,37,37,43,43,11,11,50,50,3,3,30,30,1,1,52,52,8,8,33,33,28,28,62,62,40,40,56,56,23,23,3,3,24,24,61,61,29,29,14,14,13,13,15,15,48,48,34,34,52,52,36,36,3,3,13,13,52,52,50,50,21,21,39,39,49,49,50,50,57,57,35,35,54,54,7,7,51,51,48,48,51,51,62,62,62,62,31,31,8,8,28,28,57,57,9,9,27,27,1,1,37,37,49,49,1,1,59,59,34,34,32,32,25,25,28,28,48,48,28,28,2,2,26,26,17,17,50,50,2,2,9,9,0,0,31,31,46,46,50,50,8,8,22,22,34,34,30,30,40,40,33,33,32,32,0,0,60,60,30,30,17,17,0,0,10,10,7,7,9,9,48,48,60,60,57,57,49,49,18,18,33,33,20,20,49,49,19,19,11,11,0,0,9,9,33,33,41,41,36,36,53,53,13,13,3,3,44,44,22,22,36,36,50,50,38,38,23,23,28,28,8,8,2,2,11,11,36,36,30,30,42,42,41,41,32,32,49,49,5,5,1,1,30,30,27,27,7,7,28,28,41,41,28,28,46,46,34,34,18,18,13,13,56,56,61,61,33,33,20,20,7,7,47,47,40,40,51,51,12,12,62,62,25,25,30,30,2,2,39,39,24,24,2,2,54,54,6,6,16,16,42,42,14,14,40,40,29,29,25,25,16,16,34,34,44,44,6,6,42,42,40,40,16,16,51,51,39,39,16,16,7,7,19,19,52,52,24,24,14,14,4,4,14,14,15,15,20,20,41,41,49,49,29,29,17,17,21,21,41,41,52,52,21,21,63,63,47,47,36,36,28,28,43,43,41,41,42,42,49,49,43,43,35,35,18,18,7,7,27,27,29,29,12,12,26,26,15,15,22,22,6,6,33,33,9,9,54,54,60,60,53,53,2,2,29,29,24,24,2,2,5,5,45,45,39,39,30,30,19,19,36,36,62,62,11,11,0,0,43,43,5,5,60,60,53,53,58,58,36,36,19,19,61,61,7,7,52,52,27,27,36,36,3,3,41,41,47,47,21,21,31,31,13,13,31,31,44,44,15,15,45,45,7,7,29,29,28,28,37,37,27,27,27,27,3,3,51,51,28,28,13,13,59,59,9,9,27,27,0,0,6,6,6,6,14,14,15,15,46,46,28,28,41,41,43,43,6,6,25,25,30,30,55,55,0,0,15,15,28,28,62,62,10,10,51,51,14,14,22,22,48,48,29,29,54,54,39,39,24,24,56,56,62,62,49,49,2,2,19,19,24,24,59,59,6,6,10,10,43,43,21,21,49,49,30,30,21,21,18,18,34,34,58,58,1,1,44,44,11,11,55,55,32,32,23,23,5,5,42,42,57,57,24,24,40,40,15,15,58,58,43,43,26,26,45,45,61,61,45,45,45,45,18,18,36,36,44,44,46,46,17,17,28,28,15,15,19,19,55,55,35,35,21,21,48,48,56,56,18,18,13,13,30,30,59,59,32,32,56,56,2,2,22,22,41,41,45,45,27,27,12,12,60,60,4,4,35,35,48,48,30,30,59,59,36,36,29,29,35,35,7,7,24,24,29,29,46,46,0,0,37,37,19,19,6,6,42,42,37,37,3,3,55,55,19,19,9,9,8,8,2,2,40,40,7,7,24,24,25,25,3,3,24,24,23,23,11,11,47,47,13,13,55,55,27,27,27,27,3,3,52,52,24,24,38,38,32,32,15,15,29,29,33,33,11,11,3,3,7,7,61,61,0,0,8,8,63,63,34,34,13,13,18,18,7,7,3,3,3,3,52,52,35,35,33,33,2,2,52,52,18,18,48,48,7,7,9,9,51,51,28,28,13,13,1,1,39,39,39,39,26,26,18,18,41,41,4,4,13,13,35,35,19,19,45,45,40,40,6,6,62,62,2,2,24,24,38,38,8,8,63,63,34,34,0,0,32,32,49,49,42,42,57,57,62,62,40,40,42,42,14,14,3,3,52,52,52,52,29,29,44,44,33,33,30,30,4,4,7,7,30,30,54,54,25,25,58,58,15,15,14,14,18,18,6,6,57,57,24,24,28,28,33,33,13,13,57,57,13,13,57,57,13,13,4,4,31,31,59,59,2,2,31,31,56,56,49,49,6,6,28,28,35,35,28,28,59,59,37,37,30,30,15,15,22,22,13,13,30,30,9,9,38,38,63,63,35,35,14,14,38,38,25,25,5,5,19,19,56,56,55,55,34,34,25,25,21,21,27,27,44,44,33,33,59,59,59,59,63,63,54,54,27,27,61,61,11,11,60,60,52,52,24,24,48,48,60,60,48,48,29,29,0,0,38,38,56,56,4,4,16,16,0,0,21,21,12,12,61,61,41,41,6,6,35,35,25,25,6,6,15,15,21,21,10,10,19,19,51,51,40,40,4,4,59,59,52,52,28,28,20,20,0,0,58,58,20,20,46,46,22,22,46,46,43,43,18,18,48,48,15,15,57,57,52,52,34,34,37,37,60,60,41,41,52,52,44,44,44,44,22,22,25,25,37,37,47,47,36,36,20,20,52,52,2,2,2,2,36,36,6,6,26,26,39,39,45,45,14,14,30,30,6,6,24,24,26,26,35,35,17,17,39,39,11,11,21,21,27,27,25,25,17,17,42,42,16,16,26,26,53,53,62,62,44,44,36,36,45,45,8,8,17,17,49,49,63,63,58,58,60,60,58,58,14,14,38,38,18,18,27,27,47,47,53,53,28,28,63,63,60,60,4,4,60,60,31,31,23,23,10,10,46,46,47,47,38,38,32,32,16,16,18,18,20,20,46,46,30,30,14,14,23,23,41,41,41,41,19,19,16,16,21,21,5,5,4,4,48,48,33,33,50,50,51,51,54,54,15,15,36,36,39,39,44,44,48,48,31,31,37,37,35,35,0,0,37,37,38,38,33,33,48,48,52,52,8,8,57,57,57,57,37,37,30,30,48,48,8,8,33,33,16,16,28,28,44,44,23,23,15,15,46,46,40,40,41,41,48,48,43,43,17,17,49,49,21,21,62,62,24,24,6,6,38,38,57,57,46,46,47,47,12,12,7,7,3,3,37,37,62,62,31,31,30,30,54,54,62,62,43,43,7,7,5,5,41,41,15,15,33,33,42,42,22,22,51,51,16,16,19,19,57,57,57,57,53,53,49,49,41,41,5,5,29,29,49,49,33,33,37,37,61,61,60,60,25,25,54,54,29,29,4,4,25,25,25,25,0,0,13,13,22,22,12,12,25,25,28,28,29,29,1,1,20,20,46,46,5,5,53,53,55,55,12,12,10,10,31,31,11,11,63,63,16,16,24,24,8,8,53,53,33,33,15,15,22,22,46,46,5,5,2,2,57,57,24,24,20,20,11,11,45,45,14,14,3,3,34,34,53,53,11,11,3,3,4,4,17,17,59,59,12,12,1,1,28,28,45,45,3,3,48,48,48,48,35,35,11,11,19,19,2,2,27,27,42,42,36,36,56,56,53,53,33,33,9,9,8,8,38,38,27,27,19,19,51,51,26,26,50,50,60,60,23,23,2,2,3,3,54,54,46,46,6,6,32,32,4,4,5,5,8,8,10,10,44,44,15,15,42,42,56,56,25,25,63,63,12,12,59,59,19,19,9,9,25,25,4,4,18,18,47,47,27,27,20,20,7,7,49,49,13,13,16,16,46,46,1,1,8,8,21,21,31,31,22,22,40,40,60,60,46,46,10,10,39,39,44,44,31,31,53,53,4,4,51,51,22,22,41,41,41,41,22,22,3,3,19,19,4,4,37,37,31,31,27,27,19,19,63,63,44,44,29,29,1,1,48,48,26,26,59,59,63,63,17,17,27,27,7,7,44,44,21,21,24,24,10,10,37,37,36,36,24,24,12,12,20,20,45,45,26,26,41,41,13,13,40,40,51,51,41,41,31,31,0,0,36,36,24,24,54,54,27,27,57,57,32,32,47,47,7,7,6,6,50,50,51,51,54,54,18,18,28,28,15,15,3,3,45,45,29,29,52,52,38,38,0,0,8,8,59,59,19,19,38,38,8,8,11,11,34,34,19,19,27,27,22,22,45,45,38,38,12,12,13,13,28,28,24,24,10,10,20,20,6,6,19,19,1,1,42,42,50,50,41,41,23,23,8,8,16,16,38,38,63,63,25,25,7,7,15,15,47,47,37,37,25,25,8,8,60,60,22,22,55,55,41,41,35,35,40,40,63,63,57,57,61,61,12,12,41,41,55,55,13,13,29,29,51,51,0,0,23,23,17,17,50,50,50,50,22,22,18,18,39,39,53,53,32,32,7,7,53,53,6,6,29,29,28,28,47,47,34,34,54,54,23,23,17,17,17,17,21,21,58,58,32,32,40,40,42,42,0,0,59,59,61,61,63,63,35,35,19,19,35,35,55,55,5,5,35,35,6,6,44,44,59,59,25,25,43,43,62,62,9,9,34,34,25,25,58,58,52,52,48,48,3,3,19,19,12,12,62,62,17,17,24,24,43,43,18,18,62,62,42,42,10,10,62,62,13,13,5,5,15,15,9,9,14,14,61,61,36,36,39,39,54,54,1,1,53,53,51,51,49,49,1,1,30,30,7,7,4,4,18,18,31,31,35,35,3,3,26,26,47,47,57,57,31,31,48,48,59,59,16,16,44,44,6,6,13,13,7,7,24,24,5,5,15,15,21,21,30,30,27,27,49,49,18,18,36,36,54,54,36,36,46,46,35,35,24,24,51,51,38,38,17,17,19,19,23,23,31,31,48,48,38,38,57,57,42,42,10,10,47,47,49,49,14,14,5,5,49,49,10,10,0,0,48,48,37,37,44,44,49,49,10,10,61,61,25,25,48,48,31,31,48,48,24,24,47,47,52,52,25,25,11,11,55,55,40,40,33,33,33,33,62,62,23,23,30,30,38,38,36,36,2,2,53,53,35,35,43,43,60,60,48,48,58,58,54,54,23,23,32,32,1,1,6,6,0,0,25,25,30,30,16,16,15,15,29,29,36,36,2,2,25,25,49,49,47,47,54,54,15,15,22,22,59,59,63,63,53,53,44,44,23,23,22,22,12,12,3,3,6,6,5,5,14,14,29,29,56,56,6,6,26,26,38,38,44,44,37,37,5,5,59,59,19,19,17,17,5,5,52,52,21,21,51,51,61,61,27,27,6,6,58,58,20,20,51,51,29,29,61,61,24,24,7,7,48,48,61,61,49,49,8,8,8,8,59,59,19,19,22,22,41,41,16,16,42,42,59,59,59,59,10,10,17,17,27,27,63,63,38,38,61,61,57,57,60,60,8,8,44,44,24,24,3,3,49,49,37,37,35,35,0,0,19,19,12,12,12,12,5,5,49,49,15,15,26,26,47,47,52,52,51,51,15,15,6,6,14,14,7,7,37,37,39,39,22,22,11,11,52,52,30,30,23,23,12,12,6,6,46,46,21,21,7,7,59,59,30,30,21,21,42,42,39,39,28,28,6,6,29,29,48,48,47,47,49,49,63,63,26,26,17,17,31,31,35,35,5,5,20,20,41,41,11,11,11,11,12,12,37,37,22,22,36,36,0,0,14,14,57,57,49,49,29,29,55,55,38,38,19,19,24,24,1,1,20,20,56,56,47,47,21,21,45,45,9,9,37,37,31,31,12,12,8,8,56,56,1,1,41,41,41,41,15,15,23,23,62,62,13,13,59,59,22,22,1,1,57,57,2,2,52,52,22,22,19,19,19,19,39,39,22,22,12,12,21,21,1,1,55,55,14,14,57,57,44,44,1,1,14,14,60,60,19,19,4,4,2,2,22,22,24,24,27,27,44,44,57,57,19,19,26,26,31,31,11,11,51,51,36,36,57,57,18,18,52,52,52,52,12,12,17,17,52,52,18,18,28,28,62,62,21,21,9,9,27,27,54,54,3,3,35,35,43,43,52,52,32,32,40,40,33,33,43,43,63,63,8,8,38,38,33,33,61,61,50,50,25,25,40,40,5,5,24,24,46,46,59,59,14,14,3,3,22,22,18,18,54,54,10,10,34,34,13,13,58,58,46,46,32,32,38,38,25,25,38,38,36,36,46,46,20,20,63,63,42,42,59,59,36,36,6,6,10,10,51,51,8,8,29,29,0,0,33,33,62,62,40,40,37,37,47,47,1,1,45,45,63,63,2,2,14,14,32,32,28,28,49,49,44,44,53,53,0,0,33,33,48,48,57,57,46,46,60,60,13,13,37,37,32,32,6,6,54,54,4,4,24,24,29,29,25,25,20,20,50,50,15,15,6,6,30,30,32,32,12,12,36,36,7,7,13,13,7,7,26,26,16,16,58,58,8,8,23,23,21,21,2,2,0,0,44,44,44,44,15,15,56,56,63,63,48,48,10,10,33,33,1,1,1,1,41,41,14,14,24,24,8,8,61,61,63,63,40,40,56,56,62,62,61,61,24,24,6,6,29,29,55,55,61,61,63,63,48,48,44,44,38,38,4,4,61,61,1,1,33,33,34,34,15,15,23,23,11,11,57,57,29,29,9,9,31,31,52,52,37,37,19,19,59,59,3,3,30,30,62,62,44,44,14,14,26,26,23,23,59,59,25,25,55,55,21,21,3,3,41,41,47,47,54,54,46,46,19,19,32,32,12,12,62,62,12,12,52,52,62,62,59,59,0,0,41,41,16,16,9,9,59,59,11,11,49,49,19,19,37,37,20,20,17,17,53,53,28,28,27,27,14,14,3,3,1,1,8,8,29,29,0,0,13,13,13,13,49,49,10,10,42,42,39,39,20,20,36,36,21,21,30,30,36,36,42,42,51,51,52,52,3,3,9,9,60,60,32,32,5,5,34,34,19,19,25,25,8,8,13,13,57,57,38,38,14,14,38,38,41,41,9,9,34,34,17,17,14,14,25,25,2,2,58,58,11,11,10,10,62,62,55,55,13,13,47,47,50,50,36,36,26,26,46,46,36,36,31,31,32,32,3,3,25,25,6,6,40,40,55,55,45,45,25,25,56,56,6,6,45,45,35,35,48,48,53,53,40,40,54,54,28,28,10,10,48,48,22,22,33,33,17,17,29,29,46,46,52,52,35,35,47,47,10,10,11,11,63,63,21,21,30,30,33,33,28,28,15,15,5,5,19,19,3,3,23,23,23,23,16,16,42,42,33,33,31,31,26,26,8,8,30,30,38,38,8,8,13,13,48,48,32,32,50,50,12,12,4,4,54,54,24,24,7,7,44,44,58,58,39,39,4,4,40,40,63,63,61,61,13,13,62,62,40,40,44,44,35,35,54,54,56,56,48,48,33,33,47,47,5,5,49,49,34,34,11,11,44,44,28,28,37,37,59,59,0,0,56,56,47,47,43,43,21,21,4,4,39,39,37,37,35,35,0,0,17,17,46,46,10,10,45,45,2,2,23,23,12,12,28,28,4,4,45,45,25,25,20,20,22,22,38,38,4,4,49,49,12,12,16,16,61,61,9,9,10,10,19,19,19,19,30,30,38,38,9,9,33,33,34,34,52,52,29,29,45,45,43,43,22,22,27,27,24,24,63,63,32,32,17,17,58,58,48,48,57,57,24,24,4,4,52,52,38,38,13,13,26,26,9,9,30,30,33,33,6,6,22,22,52,52,57,57,16,16,0,0,56,56,29,29,28,28,8,8,7,7,55,55,38,38,23,23,17,17,37,37,9,9,2,2,57,57,29,29,55,55,7,7,2,2,19,19,36,36,21,21,60,60,18,18,48,48,8,8,8,8,21,21,29,29,61,61,24,24,51,51,28,28,55,55,1,1,53,53,50,50,7,7,3,3,35,35,36,36,7,7,52,52,48,48,20,20,38,38,2,2,37,37,7,7,23,23,60,60,58,58,29,29,13,13,45,45,24,24,61,61,50,50,1,1,21,21,7,7,5,5,45,45,32,32,2,2,19,19,47,47,23,23,26,26,47,47,35,35,20,20,58,58,35,35,21,21,33,33,0,0,3,3,26,26,7,7,1,1,54,54,28,28,35,35,22,22,17,17,5,5,31,31,43,43,2,2,37,37,0,0,50,50,15,15,59,59,18,18,56,56,50,50,13,13,16,16,26,26,15,15,22,22,48,48,33,33,62,62,41,41,14,14,20,20,48,48,39,39,56,56,31,31,22,22,59,59,63,63,45,45,36,36,45,45,34,34,35,35,18,18,44,44,42,42,40,40,53,53,24,24,20,20,14,14,57,57,53,53,33,33,42,42,29,29,5,5,44,44,13,13,7,7,31,31,15,15,3,3,12,12,60,60,41,41,60,60,53,53,58,58,43,43,57,57,53,53,50,50,63,63,40,40,5,5,10,10,51,51,58,58,25,25,61,61,44,44,50,50,61,61,10,10,33,33,20,20,22,22,24,24,6,6,8,8,44,44,21,21,59,59,43,43,36,36,59,59,56,56,11,11,27,27,57,57,2,2,29,29,34,34,30,30,39,39,56,56,34,34,17,17,0,0,41,41,8,8,57,57,28,28,38,38,41,41,1,1,0,0,34,34,52,52,28,28,26,26,38,38,16,16,61,61,47,47,38,38,12,12,0,0,19,19,51,51,33,33,16,16,5,5,8,8,42,42,27,27,46,46,40,40,62,62,24,24,16,16,14,14,52,52,23,23,12,12,4,4,41,41,20,20,21,21,50,50,50,50,18,18,46,46,61,61,17,17,27,27,4,4,51,51,1,1,34,34,33,33,10,10,18,18,4,4,10,10,17,17,20,20,27,27,50,50,49,49,25,25,59,59,43,43,60,60,2,2,52,52,12,12,59,59,33,33,60,60,42,42,59,59,9,9,32,32,60,60,31,31,28,28,39,39,7,7,57,57,28,28,62,62,1,1,43,43,12,12,57,57,45,45,14,14,55,55,14,14,10,10,24,24,15,15,41,41,0,0,42,42,53,53,51,51,2,2,7,7,6,6,37,37,48,48,18,18,44,44,14,14,35,35,35,35,23,23,44,44,36,36,53,53,23,23,60,60,14,14,37,37,53,53,53,53,41,41,60,60,10,10,9,9,14,14,43,43,20,20,54,54,27,27,27,27,35,35,60,60,62,62,46,46,45,45,42,42,4,4,59,59,59,59,35,35,5,5,26,26,49,49,3,3,48,48,4,4,46,46,40,40,21,21,21,21,46,46,48,48,1,1,37,37,2,2,28,28,31,31,50,50,37,37,9,9,11,11,7,7,39,39,40,40,50,50,5,5,53,53,20,20,9,9,32,32,21,21,24,24,4,4,47,47,18,18,51,51,32,32,42,42,4,4,28,28,41,41,0,0,37,37,23,23,15,15,16,16,63,63,52,52,15,15,34,34,48,48,13,13,1,1,62,62,53,53,50,50,10,10,55,55,13,13,49,49,7,7,31,31,13,13,32,32,10,10,45,45,0,0,25,25,4,4,45,45,51,51,12,12,20,20,44,44,7,7,38,38,4,4,43,43,17,17,46,46,14,14,38,38,27,27,28,28,32,32,21,21,2,2,61,61,44,44,41,41,53,53,47,47,2,2,50,50,45,45,49,49,26,26,12,12,18,18,11,11,26,26,52,52,51,51,35,35,23,23,4,4,11,11,2,2,40,40,24,24,59,59,29,29,14,14,30,30,7,7,5,5,31,31,41,41,55,55,54,54,15,15,17,17,10,10,36,36,44,44,14,14,30,30,18,18,28,28,28,28,18,18,1,1,20,20,9,9,32,32,49,49,55,55,60,60,25,25,36,36,5,5,59,59,57,57,10,10,25,25,28,28,61,61,53,53,10,10,13,13,7,7,39,39,50,50,0,0,16,16,2,2,57,57,18,18,40,40,17,17,12,12,13,13,17,17,15,15,35,35,40,40,14,14,2,2,19,19,49,49,21,21,27,27,14,14,17,17,45,45,49,49,4,4,36,36,4,4,51,51,42,42,56,56,38,38,35,35,35,35,8,8,55,55,33,33,34,34,13,13,43,43,28,28,1,1,42,42,4,4,42,42,33,33,14,14,54,54,52,52,23,23,13,13,32,32,28,28,43,43,7,7,41,41,58,58,37,37,47,47,56,56,8,8,60,60,49,49,18,18,42,42,26,26,12,12,21,21,41,41,7,7,21,21,20,20,21,21,49,49,4,4,0,0,46,46,32,32,32,32,22,22,4,4,17,17,50,50,52,52,7,7,26,26,30,30,29,29,5,5,5,5,36,36,13,13,17,17,42,42,60,60,58,58,27,27,47,47,52,52,53,53,41,41,48,48,60,60,14,14,4,4,45,45,23,23,0,0,18,18,8,8,40,40,48,48,23,23,14,14,4,4,18,18,9,9,29,29,6,6,2,2,5,5,5,5,46,46,51,51,2,2,33,33,25,25,29,29,55,55,40,40,34,34,7,7,62,62,50,50,29,29,58,58,51,51,6,6,4,4,33,33,19,19,46,46,17,17,19,19,2,2,39,39,41,41,8,8,20,20,18,18,53,53,10,10,16,16,12,12,55,55,48,48,3,3,62,62,4,4,60,60,34,34,13,13,19,19,33,33,36,36,14,14,5,5,39,39,60,60,4,4,1,1,34,34,58,58,14,14,36,36,35,35,22,22,52,52,37,37,11,11,49,49,3,3,17,17,30,30,33,33,19,19,0,0,38,38,52,52,61,61,51,51,37,37,32,32,17,17,39,39,62,62,39,39,16,16,48,48,41,41,41,41,49,49,22,22,9,9,19,19,61,61,15,15,9,9,49,49,60,60,25,25,24,24,9,9,42,42,13,13,27,27,8,8,41,41,62,62,37,37,60,60,4,4,51,51,23,23,25,25,32,32,16,16,18,18,33,33,0,0,42,42,5,5,36,36,29,29,0,0,52,52,22,22,44,44,58,58,21,21,17,17,34,34,25,25,25,25,50,50,22,22,32,32,42,42,43,43,8,8,19,19,8,8,9,9,61,61,32,32,10,10,21,21,42,42,21,21,6,6,32,32,5,5,13,13,35,35,12,12,21,21,1,1,42,42,53,53,49,49,10,10,27,27,36,36,23,23,16,16,34,34,31,31,28,28,3,3,63,63,33,33,23,23,10,10,38,38,8,8,51,51,10,10,41,41,41,41,56,56,40,40,51,51,39,39,54,54,61,61,33,33,48,48,14,14,15,15,3,3,19,19,24,24,15,15,35,35,10,10,56,56,30,30,52,52,31,31,23,23,48,48,4,4,53,53,48,48,19,19,22,22,24,24,54,54,3,3,16,16,10,10,27,27,44,44,47,47,42,42,33,33,15,15,5,5,3,3,24,24,39,39,37,37,9,9,50,50,6,6,44,44,25,25,33,33,17,17,32,32,0,0,19,19,44,44,33,33,61,61,16,16,49,49,30,30,50,50,62,62,38,38,38,38,60,60,54,54,34,34,32,32,4,4,22,22,24,24,11,11,62,62,28,28,49,49,19,19,57,57,4,4,56,56,59,59,62,62,8,8,26,26,50,50,43,43,40,40,32,32,27,27,38,38,40,40,49,49,0,0,15,15,33,33,3,3,30,30,4,4,32,32,2,2,5,5,13,13,59,59,28,28,20,20,24,24,6,6,16,16,13,13,33,33,5,5,49,49,63,63,40,40,0,0,6,6,14,14,1,1,5,5,16,16,58,58,24,24,43,43,36,36,18,18,19,19,61,61,34,34,20,20,57,57,32,32,28,28,51,51,28,28,8,8,31,31,17,17,2,2,35,35,46,46,1,1,10,10,38,38,49,49,33,33,44,44,14,14,34,34,43,43,4,4,21,21,53,53,27,27,29,29,10,10,37,37,31,31,3,3,31,31,38,38,44,44,40,40,32,32,32,32,38,38,17,17,14,14,60,60,39,39,35,35,43,43,56,56,53,53,39,39,16,16,5,5,38,38,36,36,45,45,51,51,33,33,53,53,14,14,0,0,44,44,57,57,17,17,58,58,44,44,27,27,48,48,6,6,47,47,61,61,29,29,18,18,48,48,32,32,21,21,30,30,54,54,63,63,50,50,63,63,34,34,1,1,42,42,0,0,6,6,42,42,56,56,2,2,58,58,54,54,50,50,7,7,20,20,18,18,31,31,20,20,48,48,21,21,13,13,58,58,44,44,58,58,5,5,51,51,19,19,55,55,32,32,27,27,7,7,2,2,37,37,43,43,9,9,3,3,57,57,42,42,22,22,0,0,59,59,48,48,17,17,24,24,57,57,29,29,20,20,58,58,33,33,9,9,5,5,19,19,20,20,6,6,29,29,20,20,31,31,43,43,25,25,49,49,30,30,44,44,24,24,57,57,46,46,15,15,9,9,46,46,12,12,59,59,53,53,57,57,25,25,10,10,11,11,0,0,9,9,1,1,44,44,33,33,49,49,57,57,16,16,35,35,17,17,8,8,7,7,0,0,55,55,24,24,38,38,4,4,45,45,61,61,11,11,36,36,5,5,45,45,49,49,40,40,1,1,18,18,26,26,37,37,19,19,13,13,57,57,57,57,51,51,35,35,34,34,8,8,52,52,17,17,23,23,52,52,1,1,19,19,58,58,27,27,59,59,45,45,51,51,59,59,15,15,56,56,34,34,35,35,50,50,38,38,14,14,36,36,0,0,44,44,53,53,30,30,11,11,26,26,19,19,19,19,3,3,47,47,14,14,29,29,28,28,27,27,35,35,25,25,57,57,39,39,4,4,20,20,33,33,42,42,40,40,38,38,39,39,34,34,48,48,63,63,16,16,58,58,60,60,19,19,0,0,42,42,28,28,36,36,44,44,55,55,13,13,57,57,3,3,13,13,45,45,16,16,3,3,52,52,29,29,22,22,20,20,17,17,6,6,39,39,58,58,19,19,19,19,48,48,20,20,11,11,30,30,12,12,47,47,10,10,45,45,57,57,35,35,6,6,34,34,10,10,27,27,11,11,57,57,4,4,36,36,55,55,6,6,31,31,6,6,44,44,0,0,8,8,16,16,7,7,56,56,36,36,2,2,38,38,45,45,54,54,21,21,10,10,27,27,41,41,61,61,12,12,46,46,5,5,48,48,50,50,55,55,12,12,50,50,8,8,30,30,59,59,2,2,44,44,44,44,2,2,21,21,1,1,41,41,21,21,58,58,26,26,8,8,27,27,17,17,42,42,34,34,58,58,6,6,10,10,42,42,19,19,61,61,22,22,24,24,12,12,27,27,9,9,29,29,34,34,5,5,32,32,44,44,51,51,12,12,6,6,17,17,15,15,54,54,52,52,11,11,31,31,40,40,20,20,37,37,13,13,10,10,1,1,62,62,47,47,1,1,61,61,63,63,45,45,19,19,49,49,15,15,14,14,40,40,7,7,52,52,56,56,2,2,0,0,44,44,26,26,57,57,13,13,59,59,48,48,10,10,23,23,55,55,38,38,43,43,10,10,44,44,10,10,40,40,4,4,2,2,14,14,16,16,13,13,42,42,22,22,38,38,33,33,12,12,15,15,52,52,4,4,33,33,27,27,29,29,57,57,32,32,48,48,6,6,17,17,9,9,17,17,1,1,39,39,27,27,20,20,16,16,36,36,43,43,3,3,0,0,8,8,47,47,27,27,27,27,54,54,53,53,17,17,38,38,35,35,42,42,9,9,58,58,0,0,0,0,56,56,40,40,28,28,19,19,13,13,35,35,46,46,56,56,26,26,30,30,0,0,1,1,38,38,19,19,54,54,5,5,61,61,1,1,2,2,0,0,0,0,9,9,45,45,30,30,53,53,15,15,1,1,34,34,60,60,51,51,32,32,5,5,34,34,26,26,53,53,53,53,5,5,44,44,40,40,20,20,46,46,59,59,18,18,13,13,55,55,31,31,51,51,27,27,3,3,12,12,19,19,36,36,42,42,54,54,42,42,48,48,53,53,29,29,28,28,22,22,55,55,1,1,62,62,29,29,10,10,61,61,60,60,48,48,39,39,62,62,51,51,29,29,7,7,48,48,17,17,4,4,41,41,36,36,56,56,54,54,34,34,27,27,42,42,22,22,35,35,7,7,26,26,26,26,38,38,31,31,49,49,51,51,54,54,54,54,17,17,60,60,9,9,55,55,63,63,42,42,16,16,35,35,31,31,40,40,24,24,6,6,0,0,52,52,24,24,22,22,13,13,1,1,13,13,46,46,39,39,45,45,41,41,31,31,55,55,4,4,53,53,9,9,15,15,20,20,17,17,0,0,60,60,32,32,58,58,44,44,54,54,11,11,22,22,42,42,23,23,28,28,47,47,61,61,36,36,46,46,7,7,52,52,37,37,35,35,43,43,28,28,26,26,7,7,16,16,16,16,22,22,23,23,16,16,16,16,8,8,24,24,18,18,25,25,33,33,10,10,52,52,26,26,63,63,31,31,5,5,37,37,36,36,2,2,12,12,5,5,12,12,29,29,28,28,60,60,14,14,53,53,20,20,41,41,13,13,46,46,40,40,38,38,2,2,9,9,27,27,13,13,0,0,37,37,53,53,28,28,28,28,10,10,17,17,41,41,3,3,49,49,7,7,49,49,14,14,8,8,14,14,4,4,35,35,3,3,49,49,30,30,7,7,61,61,18,18,43,43,32,32,57,57,1,1,51,51,32,32,41,41,54,54,17,17,34,34,62,62,45,45,1,1,43,43,29,29,22,22,37,37,44,44,24,24,17,17,60,60,61,61,3,3,36,36,45,45,9,9,23,23,6,6,41,41,30,30,2,2,57,57,8,8,3,3,62,62,37,37,10,10,29,29,35,35,25,25,21,21,48,48,8,8,16,16,23,23,19,19,35,35,3,3,14,14,1,1,13,13,45,45,40,40,52,52,13,13,1,1,10,10,38,38,34,34,62,62,4,4,45,45,32,32,56,56,7,7,45,45,16,16,59,59,18,18,59,59,3,3,18,18,42,42,57,57,50,50,48,48,16,16,50,50,0,0,60,60,11,11,17,17,33,33,44,44,8,8,53,53,51,51,54,54,26,26,36,36,3,3,38,38,2,2,56,56,48,48,21,21,5,5,61,61,29,29,21,21,10,10,27,27,18,18,0,0,39,39,55,55,59,59,15,15,19,19,13,13,57,57,28,28,22,22,40,40,25,25,58,58,58,58,27,27,19,19,54,54,6,6,59,59,7,7,12,12,33,33,13,13,41,41,40,40,9,9,21,21,56,56,0,0,7,7,33,33,21,21,50,50,5,5,44,44,14,14,50,50,15,15,54,54,48,48,38,38,54,54,11,11,14,14,10,10,38,38,36,36,28,28,44,44,49,49,9,9,34,34,27,27,44,44,7,7,58,58,23,23,27,27,46,46,23,23,47,47,59,59,6,6,38,38,54,54,15,15,37,37,33,33,11,11,3,3,4,4,44,44,63,63,52,52,46,46,40,40,2,2,49,49,26,26,9,9,35,35,46,46,39,39,23,23,45,45,19,19,8,8,40,40,33,33,46,46,18,18,32,32,20,20,57,57,14,14,28,28,61,61,27,27,3,3,50,50,44,44,44,44,10,10,50,50,53,53,19,19,1,1,39,39,12,12,35,35,34,34,51,51,60,60,60,60,39,39,30,30,53,53,46,46,59,59,22,22,0,0,49,49,49,49,44,44,12,12,7,7,39,39,32,32,10,10,12,12,49,49,58,58,62,62,8,8,24,24,48,48,46,46,61,61,16,16,38,38,6,6,47,47,9,9,32,32,12,12,44,44,13,13,60,60,38,38,59,59,10,10,36,36,3,3,50,50,9,9,39,39,47,47,9,9,32,32,4,4,56,56,2,2,46,46,33,33,8,8,34,34,16,16,25,25,36,36,20,20,29,29,52,52,13,13,43,43,1,1,12,12,56,56,11,11,42,42,26,26,49,49,52,52,55,55,4,4,32,32,6,6,21,21,2,2,3,3,14,14,2,2,56,56,7,7,48,48,2,2,61,61,53,53,51,51,18,18,45,45,12,12,7,7,9,9,27,27,3,3,33,33,29,29,60,60,7,7,2,2,58,58,34,34,60,60,0,0,59,59,30,30,30,30,14,14,1,1,58,58,61,61,49,49,53,53,28,28,16,16,25,25,38,38,50,50,10,10,46,46,23,23,60,60,25,25,31,31,39,39,36,36,3,3,54,54,42,42,35,35,0,0,50,50,17,17,18,18,2,2,3,3,18,18,6,6,14,14,42,42,14,14,40,40,8,8,46,46,56,56,63,63,50,50,19,19,60,60,24,24,14,14,60,60,0,0,9,9,30,30,3,3,49,49,28,28,42,42,44,44,0,0,17,17,59,59,46,46,42,42,41,41,4,4,63,63,23,23,24,24,40,40,19,19,7,7,17,17,36,36,52,52,55,55,34,34,8,8,34,34,2,2,17,17,39,39,15,15,33,33,33,33,57,57,2,2,29,29,12,12,58,58,7,7,0,0,46,46,13,13,42,42,7,7,42,42,33,33,9,9,52,52,30,30,28,28,5,5,37,37,15,15,31,31,42,42,5,5,11,11,58,58,58,58,37,37,24,24,15,15,42,42,51,51,39,39,44,44,39,39,33,33,0,0,0,0,7,7,62,62,14,14,1,1,61,61,13,13,9,9,55,55,28,28,48,48,42,42,42,42,33,33,7,7,19,19,14,14,12,12,12,12,37,37,10,10,28,28,61,61,33,33,20,20,44,44,57,57,38,38,51,51,50,50,38,38,62,62,41,41,25,25,24,24,37,37,36,36,8,8,12,12,25,25,6,6,23,23,18,18,62,62,16,16,31,31,17,17,62,62,20,20,21,21,1,1,40,40,15,15,1,1,6,6,52,52,40,40,43,43,3,3,1,1,21,21,55,55,20,20,6,6,9,9,27,27,61,61,3,3,26,26,1,1,54,54,36,36,53,53,37,37,51,51,52,52,11,11,3,3,11,11,27,27,42,42,9,9,11,11,53,53,4,4,29,29,22,22,31,31,49,49,39,39,1,1,12,12,13,13,34,34,6,6,15,15,28,28,2,2,21,21,51,51,48,48,20,20,22,22,41,41,45,45,1,1,54,54,11,11,39,39,43,43,63,63,7,7,32,32,56,56,19,19,58,58,23,23,0,0,53,53,10,10,52,52,34,34,2,2,31,31,41,41,49,49,21,21,13,13,41,41,39,39,60,60,36,36,32,32,10,10,30,30,28,28,23,23,10,10,17,17,10,10,29,29,24,24,56,56,8,8,8,8,18,18,55,55,10,10,52,52,53,53,59,59,1,1,11,11,34,34,48,48,48,48,55,55,18,18,1,1,20,20,13,13,0,0,47,47,41,41,39,39,38,38,38,38,26,26,53,53,14,14,4,4,52,52,51,51,37,37,20,20,34,34,53,53,2,2,40,40,8,8,51,51,20,20,8,8,49,49,43,43,43,43,54,54,20,20,59,59,47,47,4,4,50,50,41,41,35,35,60,60,57,57,39,39,51,51,27,27,55,55,31,31,16,16,36,36,55,55,62,62,0,0,57,57,31,31,13,13,41,41,52,52,62,62,2,2,51,51,46,46,7,7,52,52,46,46,36,36,23,23,44,44,34,34,47,47,55,55,57,57,17,17,31,31,1,1,46,46,38,38,52,52,16,16,48,48,41,41,56,56,43,43,7,7,36,36,17,17,35,35,28,28,38,38,4,4,5,5,43,43,16,16,63,63,29,29,24,24,35,35,26,26,8,8,48,48,8,8,10,10,13,13,23,23,54,54,53,53,7,7,28,28,32,32,15,15,20,20,27,27,34,34,35,35,56,56,9,9,41,41,11,11,11,11,14,14,25,25,60,60,1,1,53,53,2,2,13,13,2,2,57,57,22,22,36,36,16,16,51,51,0,0,39,39,58,58,19,19,6,6,2,2,54,54,45,45,52,52,47,47,19,19,54,54,21,21,15,15,5,5,58,58,56,56,51,51,53,53,38,38,44,44,63,63,21,21,42,42,2,2,42,42,8,8,36,36,25,25,2,2,6,6,20,20,21,21,9,9,0,0,4,4,20,20,45,45,28,28,17,17,38,38,42,42,45,45,35,35,39,39,7,7,43,43,26,26,21,21,25,25,5,5,43,43,17,17,58,58,3,3,57,57,42,42,3,3,27,27,12,12,35,35,35,35,38,38,11,11,4,4,51,51,48,48,0,0,1,1,48,48,34,34,27,27,51,51,2,2,17,17,18,18,45,45,28,28,23,23,50,50,11,11,32,32,29,29,27,27,23,23,37,37,1,1,21,21,12,12,30,30,21,21,11,11,14,14,21,21,10,10,58,58,20,20,4,4,51,51,45,45,44,44,51,51,3,3,28,28,24,24,26,26,23,23,46,46,4,4,54,54,22,22,31,31,46,46,39,39,40,40,8,8,50,50,1,1,63,63,23,23,41,41,32,32,13,13,0,0,62,62,63,63,56,56,44,44,8,8,22,22,6,6,37,37,45,45,53,53,19,19,51,51,32,32,51,51,5,5,61,61,42,42,56,56,5,5,9,9,3,3,2,2,35,35,40,40,14,14,7,7,9,9,10,10,39,39,40,40,15,15,39,39,27,27,56,56,55,55,27,27,60,60,35,35,16,16,15,15,54,54,15,15,58,58,33,33,28,28,59,59,36,36,1,1,34,34,8,8,35,35,45,45,2,2,30,30,23,23,60,60,20,20,44,44,14,14,33,33,43,43,20,20,31,31,33,33,44,44,47,47,45,45,22,22,8,8,63,63,31,31,55,55,18,18,3,3,58,58,3,3,53,53,45,45,27,27,57,57,13,13,13,13,34,34,25,25,13,13,2,2,52,52,18,18,14,14,42,42,55,55,4,4,31,31,38,38,56,56,11,11,34,34,20,20,36,36,0,0,15,15,54,54,18,18,13,13,17,17,45,45,2,2,45,45,16,16,63,63,48,48,29,29,15,15,53,53,34,34,58,58,3,3,23,23,30,30,3,3,18,18,45,45,50,50,4,4,19,19,23,23,29,29,20,20,15,15,47,47,41,41,10,10,4,4,25,25,6,6,35,35,35,35,6,6,36,36,30,30,58,58,31,31,13,13,21,21,47,47,56,56,32,32,11,11,18,18,40,40,17,17,0,0,63,63,29,29,44,44,20,20,2,2,2,2,12,12,0,0,55,55,33,33,33,33,12,12,29,29,38,38,45,45,39,39,5,5,4,4,43,43,31,31,37,37,52,52,48,48,0,0,13,13,50,50,44,44,2,2,29,29,25,25,20,20,28,28,16,16,46,46,0,0,59,59,26,26,8,8,59,59,34,34,59,59,58,58,2,2,2,2,48,48,0,0,21,21,15,15,60,60,23,23,59,59,54,54,58,58,4,4,60,60,43,43,57,57,26,26,40,40,14,14,54,54,61,61,1,1,16,16,18,18,16,16,53,53,19,19,37,37,27,27,22,22,63,63,31,31,24,24,24,24,13,13,40,40,13,13,41,41,17,17,36,36,52,52,56,56,6,6,25,25,7,7,24,24,1,1,14,14,37,37,42,42,48,48,56,56,25,25,25,25,59,59,2,2,13,13,33,33,30,30,26,26,51,51,48,48,7,7,9,9,21,21,39,39,5,5,42,42,5,5,26,26,39,39,27,27,19,19,59,59,18,18,21,21,61,61,44,44,10,10,3,3,53,53,12,12,27,27,11,11,40,40,33,33,54,54,36,36,16,16,56,56,4,4,22,22,15,15,46,46,60,60,13,13,4,4,6,6,5,5,56,56,57,57,0,0,37,37,19,19,24,24,63,63,12,12,33,33,44,44,30,30,55,55,30,30,60,60,53,53,10,10,53,53,62,62,2,2,28,28,2,2,16,16,38,38,20,20,58,58,52,52,61,61,25,25,55,55,62,62,58,58,14,14,28,28,48,48,11,11,51,51,38,38,48,48,29,29,36,36,0,0,28,28,59,59,35,35,46,46,15,15,39,39,0,0,8,8,12,12,13,13,28,28,41,41,40,40,7,7,0,0,61,61,60,60,16,16,62,62,32,32,2,2,30,30,2,2,50,50,52,52,27,27,62,62,62,62,31,31,31,31,50,50,46,46,16,16,39,39,48,48,44,44,43,43,2,2,16,16,48,48,46,46,52,52,7,7,31,31,15,15,58,58,27,27,2,2,12,12,4,4,27,27,52,52,26,26,32,32,60,60,63,63,2,2,2,2,21,21,44,44,36,36,55,55,33,33,60,60,30,30,1,1,57,57,10,10,50,50,57,57,23,23,59,59,63,63,34,34,26,26,60,60,46,46,17,17,49,49,8,8,1,1,16,16,14,14,52,52,31,31,36,36,29,29,30,30,19,19,14,14,27,27,8,8,27,27,19,19,4,4,25,25,57,57,17,17,59,59,58,58,9,9,62,62,48,48,25,25,11,11,15,15,16,16,28,28,50,50,34,34,54,54,11,11,39,39,27,27,14,14,48,48,53,53,43,43,32,32,51,51,57,57,38,38,19,19,34,34,17,17,32,32,43,43,52,52,2,2,50,50,38,38,51,51,55,55,57,57,18,18,34,34,25,25,2,2,44,44,10,10,6,6,29,29,13,13,17,17,50,50,36,36,56,56,49,49,39,39,30,30,34,34,4,4,15,15,42,42,14,14,22,22,55,55,41,41,61,61,2,2,14,14,21,21,58,58,10,10,38,38,9,9,56,56,38,38,38,38,7,7,59,59,43,43,2,2,53,53,26,26,9,9,21,21,62,62,59,59,5,5,40,40,1,1,12,12,38,38,33,33,8,8,56,56,30,30,2,2,45,45,63,63,54,54,2,2,10,10,27,27,60,60,8,8,56,56,1,1,43,43,11,11,45,45,24,24,11,11,5,5,37,37,17,17,32,32,63,63,10,10,14,14,10,10,53,53,25,25,56,56,56,56,16,16,53,53,8,8,29,29,24,24,47,47,32,32,21,21,27,27,47,47,15,15,29,29,50,50,20,20,48,48,13,13,41,41,30,30,0,0,5,5,17,17,21,21,43,43,35,35,63,63,8,8,42,42,51,51,53,53,42,42,9,9,25,25,56,56,15,15,7,7,28,28,49,49,21,21,10,10,4,4,41,41,9,9,18,18,28,28,47,47,33,33,22,22,35,35,15,15,5,5,46,46,41,41,44,44,35,35,37,37,13,13,48,48,29,29,39,39,35,35,11,11,20,20,1,1,61,61,45,45,6,6,63,63,5,5,48,48,21,21,25,25,17,17,9,9,16,16,38,38,56,56,22,22,59,59,63,63,20,20,0,0,53,53,34,34,12,12,4,4,15,15,5,5,25,25,10,10,23,23,18,18,10,10,36,36,35,35,5,5,39,39,13,13,36,36,34,34,27,27,20,20,25,25,48,48,33,33,28,28,24,24,60,60,60,60,22,22,40,40,2,2,55,55,28,28,47,47,22,22,53,53,21,21,35,35,50,50,20,20,37,37,42,42,8,8,29,29,19,19,60,60,49,49,31,31,54,54,44,44,47,47,18,18,40,40,23,23,4,4,48,48,50,50,10,10,46,46,48,48,29,29,16,16,17,17,30,30,49,49,8,8,5,5,35,35,43,43,53,53,19,19,37,37,56,56,0,0,2,2,16,16,15,15,9,9,55,55,36,36,40,40,36,36,13,13,2,2,40,40,3,3,3,3,17,17,38,38,16,16,59,59,51,51,63,63,35,35,26,26,61,61,33,33,27,27,25,25,29,29,63,63,19,19,51,51,21,21,47,47,48,48,48,48,13,13,24,24,44,44,8,8,50,50,53,53,38,38,36,36,22,22,5,5,53,53,4,4,0,0,54,54,1,1,14,14,47,47,42,42,51,51,13,13,56,56,25,25,20,20,62,62,1,1,27,27,15,15,5,5,33,33,10,10,38,38,11,11,40,40,44,44,49,49,10,10,61,61,47,47,31,31,31,31,15,15,6,6,45,45,16,16,11,11,59,59,17,17,63,63,4,4,34,34,15,15,41,41,49,49,24,24,12,12,41,41,56,56,37,37,63,63,4,4,58,58,15,15,25,25,21,21,51,51,33,33,2,2,63,63,42,42,1,1,40,40,32,32,37,37,36,36,6,6,7,7,51,51,37,37,35,35,56,56,8,8,33,33,28,28,50,50,4,4,48,48,40,40,51,51,15,15,31,31,0,0,0,0,23,23,37,37,46,46,55,55,25,25,46,46,17,17,0,0,38,38,27,27,6,6,16,16,15,15,60,60,48,48,26,26,28,28,21,21,17,17,39,39,23,23,16,16,52,52,36,36,62,62,53,53,13,13,57,57,4,4,29,29,47,47,31,31,54,54,55,55,53,53,15,15,37,37,22,22,39,39,49,49,27,27,60,60,48,48,7,7,20,20,54,54,41,41,62,62,17,17,37,37,24,24,22,22,23,23,7,7,20,20,50,50,49,49,15,15,38,38,49,49,13,13,17,17,25,25,15,15,7,7,9,9,3,3,40,40,3,3,25,25,29,29,36,36,17,17,24,24,26,26,11,11,34,34,41,41,40,40,0,0,43,43,14,14,20,20,0,0,41,41,60,60,43,43,3,3,27,27,35,35,43,43,44,44,52,52,7,7,23,23,13,13,40,40,5,5,39,39,54,54,20,20,4,4,39,39,12,12,45,45,47,47,45,45,31,31,13,13,10,10,34,34,11,11,63,63,15,15,39,39,16,16,37,37,11,11,25,25,24,24,42,42,24,24,7,7,40,40,19,19,14,14,62,62,14,14,42,42,43,43,24,24,51,51,60,60,34,34,36,36,40,40,31,31,44,44,59,59,44,44,41,41,8,8,24,24,61,61,14,14,24,24,11,11,22,22,1,1,6,6,23,23,51,51,25,25,5,5,21,21,53,53,37,37,35,35,27,27,40,40,46,46,0,0,49,49,21,21,12,12,45,45,54,54,52,52,48,48,46,46,14,14,53,53,42,42,42,42,30,30,19,19,38,38,8,8,35,35,56,56,8,8,16,16,20,20,37,37,26,26,53,53,50,50,18,18,12,12,18,18,37,37,12,12,20,20,13,13,23,23,27,27,41,41,53,53,41,41,25,25,1,1,35,35,34,34,25,25,33,33,5,5,23,23,14,14,37,37,8,8,35,35,47,47,41,41,5,5,8,8,50,50,39,39,25,25,1,1,52,52,46,46,13,13,4,4,29,29,62,62,30,30,34,34,4,4,52,52,63,63,11,11,20,20,25,25,24,24,35,35,37,37,1,1,34,34,6,6,51,51,4,4,2,2,19,19,13,13,0,0,41,41,19,19,15,15,9,9,35,35,16,16,2,2,4,4,43,43,22,22,7,7,56,56,35,35,37,37,32,32,40,40,8,8,41,41,7,7,16,16,58,58,3,3,9,9,56,56,37,37,51,51,21,21,31,31,46,46,9,9,51,51,36,36,15,15,29,29,14,14,6,6,43,43,13,13,57,57,54,54,60,60,10,10,13,13,0,0,32,32,0,0,35,35,29,29,38,38,11,11,47,47,51,51,30,30,31,31,57,57,61,61,19,19,30,30,54,54,56,56,15,15,23,23,20,20,36,36,17,17,0,0,49,49,51,51,35,35,33,33,31,31,0,0,12,12,48,48,18,18,37,37,9,9,27,27,49,49,21,21,42,42,40,40,43,43,20,20,52,52,41,41,63,63,18,18,5,5,58,58,32,32,38,38,16,16,37,37,13,13,24,24,3,3,45,45,29,29,27,27,42,42,32,32,47,47,33,33,7,7,25,25,48,48,38,38,1,1,58,58,17,17,21,21,3,3,3,3,41,41,4,4,28,28,24,24,11,11,38,38,43,43,17,17,25,25,44,44,1,1,3,3,29,29,51,51,52,52,63,63,11,11,37,37,23,23,2,2,22,22,26,26,39,39,36,36,21,21,43,43,2,2,51,51,43,43,0,0,60,60,28,28,49,49,58,58,54,54,25,25,60,60,7,7,24,24,6,6,54,54,25,25,2,2,6,6,44,44,46,46,60,60,33,33,32,32,35,35,63,63,27,27,42,42,24,24,5,5,41,41,50,50,5,5,60,60,56,56,21,21,0,0,34,34,37,37,38,38,15,15,63,63,36,36,7,7,29,29,56,56,30,30,26,26,18,18,60,60,50,50,42,42,59,59,36,36,2,2,56,56,19,19,33,33,17,17,3,3,35,35,35,35,31,31,25,25,42,42,61,61,9,9,30,30,48,48,52,52,29,29,16,16,20,20,33,33,16,16,19,19,15,15,10,10,36,36,47,47,53,53,57,57,27,27,32,32,38,38,17,17,10,10,38,38,60,60,48,48,41,41,45,45,58,58,41,41,7,7,37,37,63,63,21,21,33,33,59,59,59,59,39,39,39,39,5,5,20,20,47,47,0,0,4,4,3,3,10,10,1,1,36,36,44,44,51,51,63,63,52,52,56,56,19,19,61,61,13,13,56,56,22,22,9,9,53,53,13,13,48,48,43,43,7,7,42,42,15,15,35,35,2,2,28,28,3,3,4,4,15,15,41,41,41,41,26,26,29,29,60,60,50,50,37,37,4,4,54,54,5,5,63,63,34,34,36,36,60,60,54,54,54,54,42,42,56,56,24,24,26,26,50,50,16,16,59,59,54,54,18,18,48,48,20,20,52,52,33,33,3,3,6,6,14,14,14,14,15,15,18,18,54,54,43,43,46,46,28,28,51,51,27,27,45,45,20,20,32,32,20,20,50,50,25,25,56,56,20,20,34,34,8,8,10,10,50,50,42,42,43,43,47,47,36,36,9,9,26,26,47,47,4,4,19,19,35,35,42,42,23,23,12,12,53,53,9,9,15,15,63,63,42,42,35,35,53,53,48,48,8,8,58,58,2,2,52,52,32,32,48,48,42,42,35,35,15,15,23,23,26,26,19,19,46,46,28,28,25,25,11,11,3,3,47,47,0,0,9,9,45,45,11,11,16,16,8,8,32,32,16,16,15,15,34,34,43,43,47,47,46,46,37,37,35,35,53,53,48,48,46,46,19,19,19,19,58,58,13,13,37,37,44,44,18,18,8,8,42,42,23,23,32,32,33,33,8,8,28,28,28,28,56,56,48,48,3,3,14,14,37,37,6,6,44,44,62,62,17,17,55,55,49,49,48,48,57,57,6,6,51,51,13,13,39,39,13,13,12,12,50,50,44,44,58,58,52,52,16,16,51,51,30,30,4,4,37,37,18,18,42,42,0,0,58,58,45,45,4,4,15,15,46,46,46,46,56,56,30,30,55,55,9,9,49,49,46,46,20,20,25,25,15,15,30,30,12,12,47,47,47,47,29,29,36,36,38,38,28,28,41,41,43,43,4,4,23,23,62,62,31,31,28,28,41,41,40,40,44,44,37,37,58,58,29,29,2,2,4,4,17,17,21,21,9,9,42,42,24,24,48,48,0,0,12,12,29,29,51,51,46,46,19,19,22,22,39,39,55,55,36,36,46,46,23,23,17,17,3,3,7,7,8,8,57,57,45,45,21,21,29,29,7,7,14,14,18,18,46,46,33,33,9,9,37,37,49,49,48,48,30,30,12,12,55,55,50,50,5,5,1,1,38,38,2,2,32,32,40,40,60,60,9,9,15,15,26,26,42,42,10,10,59,59,14,14,24,24,46,46,1,1,18,18,29,29,62,62,47,47,44,44,43,43,48,48,18,18,46,46,27,27,27,27,28,28,52,52,54,54,33,33,7,7,15,15,37,37,5,5,17,17,24,24,56,56,6,6,18,18,9,9,41,41,2,2,61,61,32,32,9,9,52,52,1,1,35,35,29,29,51,51,30,30,12,12,3,3,22,22,7,7,4,4,20,20,27,27,59,59,47,47,52,52,42,42,41,41,1,1,25,25,46,46,50,50,33,33,15,15,8,8,6,6,24,24,26,26,52,52,44,44,15,15,28,28,46,46,16,16,22,22,53,53,12,12,16,16,5,5,9,9,56,56,50,50,0,0,10,10,61,61,47,47,45,45,2,2,35,35,46,46,2,2,8,8,33,33,11,11,33,33,61,61,29,29,20,20,27,27,50,50,25,25,53,53,26,26,26,26,15,15,23,23,61,61,37,37,37,37,63,63,51,51,0,0,1,1,5,5,51,51,33,33,54,54,30,30,17,17,18,18,39,39,3,3,12,12,22,22,21,21,7,7,30,30,6,6,20,20,60,60,54,54,34,34,43,43,6,6,61,61,46,46,9,9,11,11,8,8,29,29,19,19,35,35,47,47,15,15,10,10,36,36,32,32,39,39,45,45,17,17,16,16,50,50,37,37,17,17,30,30,20,20,32,32,23,23,18,18,41,41,42,42,38,38,18,18,17,17,48,48,8,8,41,41,24,24,46,46,45,45,6,6,17,17,42,42,3,3,33,33,8,8,28,28,1,1,41,41,5,5,28,28,54,54,49,49,16,16,31,31,11,11,38,38,45,45,1,1,57,57,29,29,54,54,47,47,28,28,4,4,8,8,44,44,45,45,51,51,24,24,12,12,45,45,6,6,42,42,6,6,19,19,51,51,35,35,11,11,18,18,9,9,61,61,17,17,4,4,3,3,5,5,53,53,8,8,5,5,56,56,27,27,33,33,8,8,50,50,43,43,42,42,0,0,49,49,51,51,35,35,4,4,26,26,9,9,59,59,11,11,63,63,43,43,55,55,44,44,47,47,63,63,52,52,48,48,25,25,15,15,16,16,6,6,14,14,4,4,9,9,56,56,30,30,35,35,35,35,44,44,44,44,52,52,24,24,7,7,12,12,48,48,56,56,58,58,6,6,27,27,41,41,37,37,43,43,39,39,12,12,1,1,6,6,4,4,22,22,24,24,49,49,38,38,47,47,59,59,53,53,57,57,32,32,11,11,13,13,8,8,3,3,57,57,5,5,17,17,62,62,6,6,41,41,12,12,16,16,32,32,3,3,63,63,26,26,21,21,37,37,5,5,62,62,23,23,9,9,31,31,12,12,34,34,51,51,33,33,38,38,9,9,54,54,11,11,63,63,47,47,3,3,34,34,23,23,7,7,26,26,11,11,51,51,52,52,59,59,35,35,21,21,10,10,1,1,55,55,48,48,9,9,57,57,50,50,53,53,54,54,30,30,5,5,23,23,37,37,27,27,24,24,34,34,23,23,11,11,32,32,12,12,44,44,44,44,63,63,17,17,33,33,43,43,5,5,40,40,38,38,11,11,2,2,12,12,24,24,6,6,27,27,18,18,31,31,17,17,34,34,57,57,49,49,24,24,0,0,29,29,52,52,23,23,62,62,62,62,20,20,19,19,2,2,25,25,2,2,30,30,4,4,0,0,29,29,12,12,48,48,58,58,13,13,9,9,23,23,5,5,11,11,24,24,54,54,11,11,52,52,62,62,7,7,8,8,31,31,19,19,17,17,16,16,9,9,17,17,9,9,21,21,59,59,8,8,42,42,35,35,49,49,27,27,9,9,3,3,15,15,49,49,10,10,62,62,37,37,33,33,26,26,2,2,0,0,50,50,28,28,58,58,14,14,30,30,6,6,49,49,16,16,44,44,44,44,30,30,53,53,57,57,5,5,37,37,7,7,43,43,57,57,17,17,50,50,35,35,56,56,55,55,50,50,51,51,16,16,18,18,45,45,48,48,56,56,28,28,19,19,20,20,4,4,16,16,19,19,17,17,17,17,6,6,38,38,0,0,52,52,8,8,30,30,43,43,54,54,11,11,24,24,2,2,42,42,50,50,48,48,50,50,62,62,40,40,27,27,32,32,5,5,60,60,2,2,42,42,24,24,35,35,17,17,61,61,21,21,54,54,52,52,33,33,42,42,18,18,15,15,31,31,10,10,0,0,30,30,51,51,0,0,35,35,0,0,49,49,47,47,40,40,58,58,14,14,63,63,0,0,50,50,54,54,50,50,51,51,0,0,23,23,40,40,4,4,26,26,10,10,59,59,54,54,36,36,32,32,7,7,49,49,52,52,22,22,47,47,14,14,21,21,46,46,44,44,27,27,17,17,51,51,16,16,27,27,0,0,43,43,50,50,48,48,25,25,61,61,1,1,6,6,50,50,36,36,1,1,31,31,2,2,47,47,20,20,33,33,18,18,36,36,3,3,10,10,17,17,18,18,5,5,11,11,24,24,47,47,19,19,2,2,20,20,53,53,30,30,17,17,39,39,60,60,42,42,16,16,33,33,35,35,14,14,20,20,28,28,9,9,11,11,17,17,62,62,29,29,54,54,0,0,36,36,16,16,62,62,11,11,29,29,7,7,25,25,25,25,11,11,18,18,45,45,49,49,46,46,8,8,15,15,29,29,9,9,18,18,3,3,7,7,52,52,61,61,53,53,31,31,35,35,5,5,9,9,50,50,11,11,50,50,19,19,35,35,46,46,48,48,48,48,40,40,18,18,42,42,14,14,51,51,37,37,42,42,8,8,12,12,46,46,30,30,52,52,3,3,48,48,55,55,42,42,36,36,1,1,18,18,4,4,63,63,8,8,12,12,30,30,32,32,6,6,30,30,34,34,33,33,37,37,8,8,22,22,42,42,46,46,30,30,10,10,47,47,10,10,42,42,10,10,24,24,20,20,30,30,54,54,36,36,48,48,16,16,16,16,45,45,41,41,54,54,61,61,19,19,3,3,60,60,3,3,41,41,29,29,53,53,51,51,40,40,49,49,53,53,3,3,15,15,1,1,50,50,8,8,49,49,39,39,20,20,53,53,54,54,43,43,2,2,54,54,8,8,51,51,4,4,32,32,24,24,60,60,41,41,0,0,36,36,63,63,44,44,5,5,51,51,36,36,48,48,23,23,42,42,0,0,33,33,47,47,25,25,31,31,47,47,51,51,59,59,0,0,62,62,43,43,21,21,45,45,57,57,59,59,1,1,16,16,21,21,8,8,42,42,46,46,29,29,2,2,0,0,12,12,54,54,49,49,1,1,19,19,1,1,43,43,42,42,39,39,13,13,58,58,38,38,6,6,25,25,16,16,44,44,1,1,53,53,56,56,42,42,31,31,37,37,2,2,40,40,38,38,40,40,33,33,1,1,59,59,42,42,8,8,20,20,10,10,26,26,8,8,10,10,18,18,49,49,21,21,25,25,42,42,46,46,52,52,31,31,5,5,13,13,6,6,37,37,17,17,24,24,3,3,6,6,58,58,42,42,40,40,25,25,45,45,61,61,51,51,29,29,13,13,22,22,48,48,20,20,53,53,40,40,27,27,44,44,7,7,47,47,36,36,32,32,39,39,61,61,0,0,13,13,0,0,9,9,51,51,14,14,5,5,30,30,16,16,52,52,21,21,43,43,37,37,37,37,63,63,14,14,10,10,50,50,39,39,15,15,32,32,24,24,33,33,22,22,56,56,48,48,52,52,17,17,31,31,11,11,23,23,25,25,16,16,29,29,34,34,29,29,39,39,56,56,0,0,59,59,34,34,8,8,18,18,52,52,33,33,14,14,42,42,60,60,58,58,12,12,12,12,49,49,17,17,8,8,12,12,16,16,57,57,27,27,41,41,50,50,30,30,55,55,47,47,51,51,16,16,1,1,5,5,15,15,9,9,52,52,8,8,38,38,1,1,11,11,19,19,60,60,34,34,3,3,60,60,46,46,1,1,35,35,26,26,3,3,30,30,9,9,60,60,1,1,59,59,52,52,11,11,28,28,40,40,2,2,40,40,17,17,0,0,62,62,16,16,22,22,19,19,62,62,57,57,19,19,34,34,41,41,36,36,51,51,53,53,5,5,0,0,41,41,41,41,32,32,7,7,12,12,63,63,30,30,46,46,8,8,5,5,33,33,15,15,23,23,22,22,2,2,55,55,25,25,25,25,14,14,13,13,1,1,52,52,53,53,29,29,10,10,60,60,6,6,18,18,6,6,23,23,31,31,48,48,44,44,41,41,0,0,22,22,32,32,44,44,12,12,53,53,8,8,16,16,11,11,10,10,63,63,15,15,23,23,3,3,60,60,11,11,16,16,62,62,38,38,4,4,42,42,10,10,28,28,40,40,8,8,51,51,4,4,43,43,36,36,49,49,48,48,7,7,33,33,38,38,26,26,8,8,18,18,47,47,30,30,13,13,37,37,56,56,42,42,8,8,36,36,59,59,54,54,20,20,35,35,1,1,43,43,57,57,30,30,36,36,28,28,51,51,15,15,42,42,38,38,45,45,53,53,48,48,36,36,16,16,17,17,15,15,30,30,6,6,60,60,46,46,50,50,33,33,1,1,9,9,7,7,42,42,0,0,5,5,46,46,58,58,10,10,52,52,50,50,26,26,34,34,9,9,17,17,34,34,20,20,33,33,24,24,35,35,43,43,18,18,21,21,51,51,56,56,13,13,7,7,3,3,15,15,18,18,56,56,8,8,35,35,28,28,32,32,11,11,12,12,25,25,42,42,46,46,6,6,3,3,1,1,35,35,29,29,24,24,1,1,0,0,56,56,47,47,0,0,44,44,9,9,14,14,49,49,30,30,60,60,23,23,40,40,60,60,32,32,52,52,38,38,41,41,23,23,32,32,63,63,2,2,26,26,20,20,20,20,45,45,6,6,51,51,57,57,4,4,16,16,16,16,61,61,57,57,37,37,35,35,51,51,7,7,16,16,53,53,24,24,57,57,7,7,7,7,26,26,50,50,15,15,50,50,11,11,53,53,52,52,41,41,12,12,53,53,36,36,57,57,13,13,38,38,46,46,7,7,60,60,34,34,19,19,46,46,51,51,1,1,40,40,57,57,48,48,54,54,23,23,20,20,50,50,1,1,26,26,8,8,1,1,59,59,35,35,59,59,59,59,17,17,45,45,56,56,0,0,30,30,58,58,41,41,14,14,15,15,23,23,38,38,47,47,39,39,19,19,27,27,38,38,62,62,32,32,30,30,13,13,58,58,6,6,37,37,4,4,7,7,18,18,2,2,52,52,7,7,12,12,30,30,54,54,44,44,35,35,37,37,7,7,52,52,22,22,55,55,52,52,12,12,43,43,36,36,41,41,2,2,49,49,30,30,43,43,54,54,56,56,16,16,34,34,59,59,1,1,17,17,7,7,31,31,4,4,12,12,53,53,3,3,0,0,18,18,25,25,35,35,33,33,60,60,10,10,56,56,16,16,24,24,10,10,14,14,21,21,29,29,9,9,33,33,53,53,2,2,36,36,7,7,63,63,63,63,21,21,16,16,42,42,10,10,48,48,3,3,48,48,16,16,54,54,45,45,9,9,13,13,30,30,10,10,58,58,44,44,35,35,45,45,16,16,6,6,62,62,41,41,48,48,23,23,48,48,44,44,25,25,32,32,5,5,32,32,37,37,49,49,50,50,52,52,2,2,0,0,23,23,14,14,48,48,7,7,9,9,36,36,29,29,15,15,34,34,29,29,18,18,15,15,29,29,8,8,5,5,55,55,31,31,14,14,48,48,41,41,62,62,37,37,47,47,51,51,34,34,8,8,38,38,49,49,22,22,25,25,52,52,11,11,0,0,0,0,26,26,62,62,18,18,22,22,16,16,8,8,37,37,54,54,0,0,40,40,40,40,38,38,6,6,13,13,3,3,57,57,55,55,12,12,55,55,8,8,21,21,3,3,45,45,14,14,48,48,28,28,1,1,33,33,41,41,42,42,62,62,49,49,0,0,12,12,3,3,18,18,5,5,26,26,21,21,51,51,32,32,41,41,14,14,7,7,50,50,5,5,9,9,49,49,4,4,7,7,18,18,17,17,63,63,35,35,62,62,57,57,26,26,51,51,14,14,43,43,57,57,26,26,17,17,35,35,43,43,34,34,48,48,6,6,7,7,17,17,59,59,13,13,53,53,58,58,27,27,38,38,16,16,52,52,23,23,59,59,36,36,33,33,17,17,17,17,59,59,29,29,22,22,58,58,11,11,38,38,34,34,56,56,35,35,15,15,10,10,2,2,34,34,18,18,30,30,24,24,18,18,26,26,56,56,6,6,38,38,8,8,44,44,47,47,52,52,23,23,57,57,31,31,32,32,7,7,0,0,57,57,26,26,52,52,0,0,12,12,17,17,54,54,29,29,5,5,18,18,49,49,45,45,55,55,37,37,52,52,30,30,60,60,3,3,44,44,33,33,52,52,48,48,26,26,51,51,4,4,18,18,46,46,6,6,6,6,52,52,55,55,63,63,56,56,54,54,48,48,13,13,63,63,37,37,59,59,8,8,21,21,14,14,27,27,9,9,6,6,53,53,28,28,18,18,47,47,0,0,10,10,33,33,35,35,2,2,32,32,9,9,38,38,60,60,29,29,47,47,53,53,44,44,46,46,30,30,2,2,6,6,45,45,14,14,46,46,53,53,4,4,56,56,29,29,4,4,17,17,12,12,18,18,57,57,16,16,17,17,29,29,36,36,37,37,26,26,50,50,2,2,18,18,2,2,33,33,11,11,56,56,30,30,56,56,13,13,30,30,8,8,13,13,29,29,13,13,14,14,30,30,43,43,35,35,52,52,2,2,32,32,6,6,9,9,32,32,52,52,8,8,34,34,62,62,16,16,22,22,20,20,24,24,18,18,25,25,25,25,46,46,32,32,12,12,22,22,11,11,57,57,30,30,14,14,33,33,47,47,35,35,50,50,0,0,9,9,15,15,6,6,50,50,8,8,5,5,55,55,61,61,28,28,17,17,38,38,31,31,6,6,20,20,59,59,53,53,17,17,49,49,30,30,32,32,43,43,42,42,26,26,43,43,56,56,38,38,35,35,6,6,33,33,22,22,47,47,9,9,16,16,12,12,40,40,24,24,57,57,25,25,5,5,27,27,53,53,51,51,24,24,40,40,62,62,0,0,40,40,59,59,13,13,36,36,35,35,50,50,16,16,17,17,14,14,4,4,22,22,16,16,17,17,9,9,21,21,48,48,56,56,14,14,58,58,11,11,58,58,31,31,46,46,11,11,18,18,8,8,35,35,15,15,59,59,48,48,19,19,47,47,5,5,10,10,4,4,2,2,24,24,63,63,30,30,54,54,25,25,6,6,7,7,54,54,18,18,50,50,39,39,12,12,20,20,54,54,26,26,11,11,32,32,8,8,42,42,46,46,7,7,33,33,32,32,8,8,5,5,63,63,50,50,6,6,53,53,28,28,41,41,42,42,52,52,18,18,36,36,57,57,35,35,48,48,20,20,26,26,30,30,51,51,10,10,29,29,35,35,34,34,36,36,0,0,32,32,28,28,23,23,35,35,38,38,5,5,54,54,9,9,20,20,22,22,51,51,11,11,54,54,24,24,53,53,14,14,27,27,13,13,32,32,9,9,55,55,8,8,0,0,22,22,28,28,28,28,30,30,36,36,55,55,45,45,38,38,54,54,11,11,51,51,3,3,41,41,25,25,60,60,32,32,50,50,25,25,14,14,51,51,26,26,8,8,0,0,18,18,38,38,13,13,10,10,25,25,23,23,49,49,57,57,34,34,54,54,12,12,33,33,26,26,44,44,3,3,15,15,10,10,36,36,4,4,51,51,42,42,56,56,26,26,28,28,40,40,55,55,6,6,33,33,39,39,44,44,57,57,16,16,12,12,43,43,1,1,16,16,5,5,40,40,20,20,4,4,5,5,50,50,5,5,52,52,47,47,46,46,17,17,11,11,48,48,56,56,23,23,48,48,14,14,56,56,17,17,39,39,41,41,43,43,43,43,38,38,56,56,34,34,17,17,56,56,9,9,18,18,41,41,48,48,2,2,48,48,6,6,56,56,5,5,17,17,11,11,63,63,0,0,57,57,6,6,60,60,0,0,6,6,61,61,17,17,23,23,33,33,38,38,15,15,28,28,12,12,36,36,12,12,62,62,3,3,7,7,18,18,15,15,19,19,57,57,9,9,56,56,54,54,26,26,58,58,12,12,14,14,36,36,4,4,55,55,15,15,17,17,9,9,15,15,4,4,56,56,6,6,12,12,52,52,44,44,48,48,21,21,16,16,14,14,6,6,22,22,24,24,40,40,62,62,43,43,10,10,30,30,30,30,63,63,21,21,14,14,53,53,25,25,29,29,20,20,42,42,18,18,56,56,41,41,51,51,56,56,27,27,40,40,53,53,48,48,2,2,50,50,39,39,63,63,24,24,21,21,56,56,28,28,34,34,26,26,3,3,12,12,50,50,30,30,1,1,29,29,53,53,26,26,51,51,29,29,50,50,48,48,17,17,0,0,41,41,30,30,9,9,35,35,61,61,57,57,37,37,7,7,14,14,33,33,23,23,11,11,49,49,9,9,41,41,7,7,49,49,4,4,9,9,46,46,27,27,48,48,56,56,8,8,24,24,27,27,32,32,40,40,11,11,2,2,6,6,60,60,37,37,43,43,5,5,16,16,13,13,36,36,33,33,0,0,4,4,53,53,5,5,37,37,51,51,38,38,7,7,35,35,29,29,2,2,28,28,19,19,9,9,59,59,22,22,16,16,52,52,41,41,1,1,5,5,27,27,25,25,49,49,21,21,22,22,36,36,37,37,57,57,45,45,57,57,34,34,53,53,35,35,35,35,32,32,23,23,29,29,42,42,30,30,46,46,21,21,25,25,24,24,0,0,60,60,46,46,38,38,6,6,20,20,13,13,32,32,39,39,11,11,5,5,48,48,27,27,39,39,28,28,30,30,12,12,27,27,31,31,48,48,37,37,58,58,46,46,50,50,25,25,21,21,30,30,32,32,15,15,24,24,11,11,3,3,54,54,35,35,0,0,41,41,44,44,18,18,46,46,57,57,22,22,31,31,32,32,50,50,33,33,7,7,42,42,28,28,19,19,1,1,17,17,32,32,56,56,18,18,39,39,4,4,53,53,20,20,53,53,13,13,46,46,21,21,5,5,23,23,1,1,35,35,8,8,7,7,63,63,56,56,9,9,23,23,33,33,27,27,7,7,54,54,0,0,4,4,7,7,61,61,8,8,30,30,31,31,2,2,37,37,19,19,32,32,16,16,61,61,5,5,8,8,16,16,11,11,43,43,34,34,46,46,52,52,10,10,24,24,32,32,60,60,13,13,53,53,9,9,53,53,27,27,37,37,19,19,29,29,43,43,52,52,12,12,63,63,32,32,48,48,8,8,14,14,53,53,54,54,3,3,32,32,56,56,13,13,14,14,33,33,62,62,49,49,49,49,46,46,24,24,6,6,19,19,38,38,48,48,53,53,38,38,6,6,28,28,44,44,11,11,41,41,46,46,63,63,50,50,36,36,61,61,52,52,14,14,59,59,3,3,53,53,32,32,49,49,18,18,16,16,36,36,61,61,6,6,28,28,62,62,11,11,5,5,50,50,24,24,22,22,34,34,1,1,32,32,34,34,18,18,1,1,10,10,47,47,7,7,24,24,51,51,0,0,4,4,45,45,16,16,11,11,29,29,24,24,57,57,17,17,24,24,20,20,3,3,33,33,60,60,34,34,34,34,39,39,12,12,41,41,15,15,59,59,58,58,59,59,34,34,62,62,39,39,23,23,43,43,2,2,15,15,54,54,36,36,10,10,26,26,21,21,48,48,35,35,36,36,57,57,41,41,33,33,51,51,19,19,4,4,57,57,20,20,47,47,59,59,47,47,7,7,30,30,51,51,62,62,1,1,29,29,8,8,22,22,30,30,57,57,58,58,52,52,1,1,21,21,25,25,0,0,19,19,35,35,34,34,62,62,24,24,32,32,21,21,34,34,35,35,17,17,17,17,47,47,19,19,35,35,43,43,13,13,49,49,37,37,9,9,56,56,37,37,10,10,22,22,16,16,11,11,32,32,57,57,33,33,32,32,34,34,33,33,33,33,42,42,16,16,6,6,17,17,33,33,36,36,37,37,26,26,39,39,37,37,16,16,37,37,22,22,50,50,53,53,35,35,7,7,22,22,7,7,2,2,13,13,62,62,0,0,30,30,20,20,61,61,26,26,40,40,13,13,53,53,42,42,29,29,43,43,37,37,45,45,13,13,44,44,36,36,46,46,37,37,17,17,16,16,23,23,42,42,54,54,15,15,17,17,19,19,15,15,34,34,16,16,18,18,2,2,8,8,6,6,23,23,44,44,62,62,15,15,49,49,25,25,31,31,13,13,60,60,21,21,34,34,21,21,10,10,42,42,57,57,11,11,60,60,0,0,56,56,19,19,57,57,17,17,11,11,21,21,0,0,19,19,45,45,8,8,24,24,54,54,26,26,24,24,46,46,32,32,35,35,52,52,19,19,48,48,14,14,51,51,1,1,8,8,23,23,6,6,31,31,28,28,31,31,51,51,59,59,61,61,36,36,51,51,40,40,53,53,36,36,57,57,51,51,2,2,48,48,35,35,37,37,52,52,56,56,8,8,61,61,6,6,23,23,38,38,58,58,61,61,7,7,11,11,41,41,35,35,45,45,53,53,18,18,7,7,24,24,44,44,0,0,9,9,12,12,22,22,52,52,45,45,3,3,10,10,33,33,7,7,3,3,62,62,56,56,1,1,9,9,54,54,31,31,53,53,6,6,40,40,13,13,30,30,39,39,35,35,26,26,15,15,17,17,2,2,57,57,13,13,31,31,6,6,15,15,20,20,34,34,1,1,47,47,18,18,23,23,15,15,45,45,15,15,37,37,25,25,42,42,5,5,31,31,28,28,60,60,57,57,12,12,38,38,5,5,16,16,15,15,49,49,50,50,17,17,27,27,16,16,8,8,20,20,12,12,9,9,25,25,56,56,36,36,56,56,21,21,42,42,21,21,2,2,16,16,6,6,37,37,41,41,9,9,16,16,28,28,0,0,0,0,34,34,4,4,57,57,30,30,42,42,47,47,11,11,34,34,37,37,8,8,19,19,12,12,10,10,46,46,33,33,24,24,8,8,22,22,20,20,30,30,41,41,37,37,56,56,36,36,26,26,48,48,10,10,34,34,38,38,9,9,24,24,24,24,1,1,8,8,33,33,25,25,58,58,34,34,4,4,32,32,45,45,60,60,50,50,48,48,43,43,6,6,18,18,43,43,47,47,60,60,62,62,50,50,3,3,50,50,15,15,54,54,18,18,12,12,4,4,30,30,3,3,34,34,2,2,37,37,11,11,38,38,52,52,12,12,33,33,43,43,4,4,62,62,38,38,29,29,52,52,0,0,7,7,2,2,38,38,62,62,51,51,8,8,62,62,22,22,35,35,44,44,13,13,62,62,50,50,9,9,21,21,36,36,5,5,44,44,18,18,60,60,36,36,30,30,63,63,49,49,6,6,15,15,28,28,61,61,36,36,35,35,56,56,35,35,56,56,60,60,57,57,36,36,26,26,8,8,54,54,30,30,48,48,59,59,12,12,49,49,22,22,49,49,13,13,11,11,55,55,24,24,36,36,18,18,34,34,25,25,34,34,3,3,3,3,55,55,47,47,15,15,30,30,3,3,49,49,62,62,6,6,3,3,30,30,40,40,4,4,7,7,5,5,7,7,30,30,55,55,42,42,35,35,1,1,49,49,23,23,39,39,12,12,63,63,0,0,30,30,29,29,51,51,4,4,61,61,50,50,55,55,35,35,37,37,51,51,43,43,26,26,37,37,51,51,9,9,38,38,51,51,18,18,60,60,8,8,27,27,49,49,26,26,23,23,45,45,5,5,48,48,26,26,44,44,56,56,23,23,25,25,51,51,4,4,8,8,48,48,36,36,13,13,28,28,16,16,53,53,37,37,59,59,4,4,22,22,60,60,27,27,40,40,33,33,35,35,0,0,54,54,44,44,23,23,48,48,32,32,17,17,56,56,39,39,38,38,18,18,43,43,48,48,39,39,30,30,62,62,36,36,14,14,54,54,33,33,34,34,36,36,52,52,61,61,33,33,46,46,18,18,50,50,53,53,31,31,5,5,6,6,2,2,39,39,18,18,54,54,59,59,50,50,35,35,40,40,5,5,54,54,18,18,41,41,52,52,27,27,28,28,34,34,26,26,14,14,60,60,58,58,44,44,0,0,9,9,39,39,50,50,48,48,49,49,48,48,50,50,43,43,46,46,32,32,10,10,18,18,6,6,21,21,34,34,31,31,15,15,60,60,24,24,2,2,28,28,51,51,1,1,29,29,41,41,22,22,35,35,31,31,35,35,31,31,51,51,2,2,58,58,43,43,40,40,63,63,16,16,37,37,35,35,38,38,38,38,49,49,0,0,23,23,47,47,10,10,60,60,16,16,62,62,9,9,31,31,16,16,11,11,7,7,58,58,37,37,3,3,11,11,43,43,7,7,24,24,25,25,17,17,60,60,16,16,0,0,32,32,48,48,34,34,47,47,53,53,2,2,19,19,49,49,48,48,48,48,18,18,33,33,0,0,1,1,48,48,50,50,55,55,25,25,55,55,58,58,0,0,59,59,37,37,34,34,13,13,5,5,18,18,33,33,44,44,25,25,20,20,61,61,43,43,1,1,2,2,31,31,44,44,9,9,18,18,58,58,61,61,8,8,56,56,43,43,44,44,41,41,28,28,2,2,12,12,41,41,53,53,51,51,53,53,22,22,30,30,47,47,60,60,4,4,56,56,31,31,1,1,31,31,13,13,12,12,7,7,47,47,50,50,18,18,61,61,54,54,18,18,15,15,28,28,30,30,60,60,12,12,46,46,27,27,46,46,23,23,38,38,0,0,34,34,30,30,28,28,12,12,26,26,4,4,13,13,0,0,18,18,25,25,59,59,5,5,35,35,37,37,56,56,59,59,13,13,17,17,28,28,6,6,24,24,37,37,3,3,3,3,31,31,37,37,45,45,48,48,1,1,0,0,12,12,2,2,60,60,2,2,26,26,22,22,48,48,54,54,36,36,32,32,33,33,40,40,32,32,51,51,5,5,27,27,57,57,40,40,35,35,63,63,55,55,42,42,50,50,2,2,38,38,4,4,7,7,38,38,21,21,29,29,15,15,52,52,36,36,14,14,8,8,0,0,53,53,10,10,48,48,0,0,42,42,47,47,26,26,12,12,48,48,47,47,35,35,27,27,40,40,46,46,2,2,34,34,60,60,19,19,28,28,33,33,58,58,29,29,29,29,21,21,35,35,54,54,35,35,50,50,2,2,4,4,49,49,27,27,13,13,3,3,49,49,53,53,63,63,55,55,7,7,17,17,60,60,34,34,21,21,32,32,2,2,11,11,17,17,48,48,40,40,50,50,44,44,48,48,24,24,39,39,11,11,11,11,36,36,51,51,45,45,28,28,53,53,32,32,32,32,4,4,19,19,8,8,28,28,22,22,61,61,16,16,57,57,49,49,34,34,35,35,20,20,32,32,53,53,19,19,4,4,38,38,3,3,49,49,49,49,40,40,8,8,32,32,8,8,59,59,32,32,17,17,13,13,20,20,14,14,40,40,49,49,48,48,3,3,12,12,48,48,4,4,7,7,62,62,34,34,46,46,20,20,22,22,1,1,35,35,30,30,36,36,6,6,28,28,9,9,59,59,21,21,32,32,53,53,40,40,6,6,33,33,20,20,45,45,38,38,28,28,59,59,54,54,35,35,20,20,29,29,17,17,12,12,28,28,13,13,58,58,51,51,50,50,6,6,43,43,15,15,37,37,16,16,36,36,33,33,32,32,49,49,24,24,49,49,44,44,2,2,43,43,38,38,6,6,49,49,18,18,1,1,32,32,57,57,18,18,24,24,63,63,38,38,4,4,31,31,32,32,10,10,58,58,53,53,54,54,52,52,52,52,2,2,23,23,43,43,56,56,18,18,49,49,17,17,19,19,61,61,43,43,44,44,9,9,28,28,5,5,12,12,9,9,32,32,30,30,20,20,63,63,56,56,2,2,53,53,11,11,25,25,60,60,41,41,3,3,13,13,14,14,7,7,27,27,16,16,28,28,63,63,37,37,8,8,48,48,22,22,23,23,46,46,36,36,47,47,55,55,22,22,40,40,27,27,8,8,4,4,10,10,53,53,15,15,39,39,21,21,14,14,15,15,48,48,11,11,51,51,23,23,49,49,1,1,25,25,19,19,50,50,21,21,29,29,57,57,24,24,29,29,36,36,3,3,16,16,11,11,9,9,47,47,30,30,56,56,31,31,4,4,57,57,22,22,37,37,33,33,19,19,13,13,0,0,58,58,2,2,59,59,19,19,2,2,28,28,50,50,6,6,9,9,61,61,20,20,16,16,0,0,2,2,25,25,36,36,31,31,13,13,10,10,40,40,7,7,27,27,58,58,11,11,9,9,62,62,23,23,63,63,38,38,58,58,18,18,13,13,26,26,56,56,19,19,51,51,37,37,48,48,22,22,42,42,3,3,63,63,18,18,15,15,21,21,38,38,19,19,11,11,54,54,49,49,49,49,63,63,33,33,59,59,0,0,49,49,47,47,19,19,56,56,4,4,54,54,25,25,41,41,24,24,43,43,4,4,58,58,20,20,20,20,60,60,22,22,9,9,23,23,29,29,25,25,13,13,25,25,16,16,34,34,46,46,36,36,31,31,35,35,51,51,41,41,12,12,5,5,44,44,27,27,34,34,2,2,58,58,2,2,59,59,54,54,6,6,33,33,2,2,0,0,40,40,8,8,48,48,50,50,40,40,7,7,25,25,0,0,3,3,45,45,42,42,60,60,55,55,2,2,36,36,29,29,18,18,58,58,42,42,54,54,40,40,40,40,60,60,41,41,52,52,26,26,22,22,32,32,32,32,2,2,1,1,46,46,48,48,10,10,17,17,52,52,8,8,21,21,5,5,31,31,13,13,40,40,26,26,12,12,58,58,56,56,19,19,19,19,8,8,26,26,62,62,38,38,38,38,26,26,21,21,55,55,13,13,44,44,60,60,34,34,39,39,30,30,46,46,9,9,43,43,5,5,41,41,56,56,40,40,44,44,15,15,46,46,8,8,16,16,1,1,20,20,36,36,9,9,16,16,17,17,17,17,0,0,20,20,30,30,7,7,9,9,7,7,24,24,0,0,34,34,8,8,33,33,18,18,0,0,15,15,29,29,51,51,51,51,42,42,48,48,59,59,37,37,5,5,6,6,11,11,21,21,56,56,34,34,15,15,1,1,21,21,63,63,38,38,40,40,34,34,14,14,37,37,51,51,16,16,20,20,46,46,32,32,60,60,14,14,1,1,51,51,9,9,1,1,22,22,19,19,62,62,20,20,39,39,0,0,0,0,3,3,24,24,13,13,46,46,14,14,35,35,44,44,8,8,24,24,29,29,12,12,40,40,53,53,2,2,13,13,51,51,2,2,58,58,17,17,41,41,17,17,50,50,62,62,3,3,61,61,1,1,62,62,42,42,42,42,53,53,44,44,1,1,47,47,19,19,33,33,17,17,36,36,36,36,10,10,26,26,5,5,48,48,0,0,5,5,51,51,56,56,10,10,39,39,31,31,35,35,20,20,29,29,36,36,54,54,2,2,47,47,51,51,37,37,40,40,35,35,16,16,62,62,39,39,17,17,1,1,44,44,17,17,5,5,11,11,7,7,2,2,1,1,21,21,4,4,5,5,29,29,51,51,47,47,4,4,1,1,57,57,57,57,37,37,8,8,20,20,24,24,16,16,32,32,35,35,21,21,21,21,24,24,42,42,62,62,28,28,43,43,17,17,41,41,27,27,53,53,24,24,50,50,48,48,10,10,26,26,8,8,15,15,43,43,33,33,43,43,20,20,40,40,46,46,55,55,47,47,63,63,38,38,5,5,21,21,47,47,48,48,56,56,15,15,33,33,43,43,32,32,61,61,52,52,41,41,9,9,16,16,47,47,12,12,22,22,57,57,42,42,55,55,20,20,13,13,10,10,30,30,19,19,38,38,43,43,8,8,53,53,26,26,2,2,38,38,12,12,55,55,1,1,54,54,19,19,48,48,10,10,43,43,14,14,49,49,60,60,9,9,25,25,25,25,10,10,51,51,29,29,25,25,40,40,43,43,11,11,24,24,17,17,37,37,44,44,54,54,26,26,1,1,0,0,49,49,31,31,8,8,5,5,24,24,45,45,43,43,58,58,38,38,51,51,24,24,42,42,17,17,10,10,14,14,61,61,4,4,1,1,23,23,54,54,10,10,3,3,20,20,15,15,29,29,1,1,8,8,49,49,8,8,59,59,24,24,60,60,0,0,8,8,18,18,33,33,42,42,23,23,33,33,58,58,41,41,17,17,51,51,8,8,56,56,47,47,55,55,0,0,36,36,8,8,7,7,28,28,52,52,3,3,14,14,11,11,15,15,39,39,52,52,5,5,55,55,60,60,28,28,39,39,54,54,23,23,25,25,44,44,58,58,35,35,56,56,53,53,48,48,41,41,11,11,22,22,57,57,16,16,33,33,5,5,51,51,20,20,41,41,1,1,18,18,60,60,20,20,13,13,33,33,40,40,57,57,43,43,60,60,58,58,25,25,13,13,29,29,30,30,48,48,0,0,17,17,18,18,63,63,59,59,14,14,4,4,14,14,0,0,13,13,38,38,41,41,7,7,58,58,17,17,50,50,14,14,2,2,39,39,25,25,9,9,11,11,55,55,25,25,31,31,52,52,28,28,60,60,44,44,59,59,7,7,28,28,4,4,34,34,40,40,45,45,33,33,19,19,36,36,47,47,47,47,38,38,20,20,51,51,49,49,36,36,30,30,63,63,25,25,56,56,52,52,10,10,44,44,18,18,24,24,8,8,52,52,53,53,60,60,33,33,13,13,33,33,43,43,31,31,20,20,31,31,41,41,50,50,13,13,12,12,15,15,44,44,2,2,16,16,2,2,25,25,19,19,40,40,36,36,54,54,47,47,7,7,33,33,58,58,62,62,48,48,54,54,3,3,39,39,29,29,9,9,54,54,33,33,23,23,46,46,39,39,31,31,37,37,36,36,33,33,19,19,4,4,31,31,12,12,17,17,59,59,42,42,29,29,41,41,7,7,0,0,57,57,45,45,9,9,57,57,60,60,20,20,30,30,25,25,17,17,63,63,41,41,32,32,23,23,57,57,2,2,18,18,0,0,32,32,33,33,31,31,4,4,6,6,57,57,38,38,11,11,18,18,34,34,62,62,47,47,31,31,15,15,61,61,49,49,9,9,62,62,21,21,23,23,54,54,48,48,7,7,0,0,54,54,55,55,55,55,12,12,35,35,23,23,30,30,8,8,2,2,23,23,35,35,62,62,11,11,26,26,0,0,45,45,18,18,27,27,55,55,29,29,27,27,5,5,41,41,18,18,3,3,0,0,2,2,41,41,6,6,53,53,13,13,58,58,31,31,19,19,52,52,22,22,57,57,49,49,40,40,43,43,55,55,21,21,44,44,50,50,39,39,57,57,35,35,38,38,21,21,33,33,34,34,45,45,8,8,62,62,23,23,54,54,38,38,49,49,28,28,38,38,46,46,39,39,31,31,22,22,2,2,16,16,47,47,39,39,21,21,42,42,44,44,1,1,25,25,36,36,30,30,36,36,18,18,45,45,18,18,30,30,45,45,37,37,26,26,52,52,57,57,11,11,40,40,34,34,19,19,6,6,3,3,56,56,15,15,50,50,41,41,0,0,46,46,3,3,18,18,36,36,29,29,48,48,43,43,8,8,36,36,11,11,55,55,10,10,4,4,17,17,56,56,55,55,10,10,52,52,24,24,32,32,8,8,48,48,57,57,33,33,36,36,43,43,11,11,0,0,19,19,13,13,57,57,2,2,23,23,17,17,43,43,17,17,12,12,13,13,24,24,4,4,14,14,5,5,30,30,47,47,6,6,5,5,3,3,58,58,3,3,13,13,37,37,49,49,23,23,34,34,24,24,55,55,45,45,38,38,45,45,29,29,35,35,29,29,18,18,38,38,6,6,55,55,40,40,50,50,56,56,19,19,44,44,7,7,30,30,42,42,4,4,19,19,3,3,7,7,18,18,48,48,29,29,12,12,37,37,2,2,38,38,33,33,46,46,0,0,7,7,12,12,52,52,1,1,42,42,51,51,12,12,28,28,34,34,48,48,23,23,56,56,61,61,32,32,7,7,42,42,44,44,44,44,22,22,47,47,48,48,5,5,43,43,7,7,13,13,5,5,45,45,50,50,60,60,15,15,34,34,45,45,9,9,5,5,27,27,15,15,10,10,26,26,44,44,55,55,38,38,2,2,11,11,42,42,37,37,21,21,18,18,39,39,6,6,25,25,14,14,61,61,33,33,53,53,7,7,17,17,2,2,42,42,45,45,26,26,52,52,54,54,20,20,62,62,12,12,58,58,32,32,18,18,2,2,30,30,0,0,10,10,42,42,8,8,4,4,7,7,29,29,30,30,44,44,14,14,62,62,38,38,13,13,38,38,17,17,53,53,45,45,20,20,1,1,14,14,18,18,23,23,58,58,37,37,57,57,15,15,56,56,63,63,59,59,25,25,41,41,40,40,18,18,33,33,9,9,32,32,57,57,53,53,53,53,58,58,25,25,44,44,3,3,50,50,59,59,55,55,4,4,2,2,56,56,60,60,51,51,9,9,35,35,44,44,45,45,23,23,46,46,18,18,5,5,26,26,36,36,5,5,32,32,32,32,18,18,58,58,60,60,4,4,15,15,24,24,43,43,33,33,20,20,43,43,33,33,35,35,43,43,5,5,33,33,14,14,23,23,37,37,57,57,10,10,18,18,28,28,63,63,21,21,38,38,31,31,0,0,22,22,8,8,24,24,63,63,7,7,17,17,10,10,0,0,18,18,22,22,4,4,37,37,10,10,3,3,55,55,0,0,18,18,4,4,25,25,27,27,5,5,53,53,19,19,2,2,33,33,12,12,43,43,29,29,37,37,34,34,28,28,2,2,27,27,15,15,21,21,38,38,35,35,29,29,3,3,18,18,9,9,53,53,48,48,9,9,46,46,2,2,62,62,60,60,16,16,38,38,53,53,53,53,47,47,19,19,14,14,32,32,44,44,21,21,36,36,24,24,8,8,28,28,2,2,29,29,1,1,1,1,58,58,8,8,10,10,41,41,11,11,33,33,43,43,35,35,7,7,14,14,45,45,10,10,38,38,23,23,35,35,45,45,17,17,40,40,24,24,61,61,47,47,27,27,45,45,19,19,18,18,30,30,39,39,13,13,49,49,21,21,17,17,32,32,51,51,1,1,63,63,14,14,29,29,40,40,8,8,56,56,45,45,40,40,3,3,3,3,8,8,20,20,5,5,39,39,57,57,43,43,20,20,10,10,3,3,30,30,16,16,46,46,2,2,27,27,37,37,36,36,44,44,22,22,8,8,32,32,34,34,60,60,53,53,59,59,45,45,54,54,39,39,61,61,57,57,32,32,23,23,42,42,6,6,38,38,20,20,19,19,50,50,28,28,43,43,43,43,30,30,39,39,63,63,22,22,17,17,53,53,52,52,16,16,51,51,44,44,1,1,44,44,58,58,38,38,27,27,14,14,31,31,14,14,52,52,28,28,13,13,8,8,17,17,26,26,18,18,48,48,44,44,61,61,1,1,9,9,47,47,23,23,5,5,20,20,24,24,19,19,60,60,40,40,41,41,46,46,16,16,15,15,9,9,25,25,24,24,49,49,38,38,49,49,35,35,46,46,61,61,31,31,36,36,0,0,1,1,17,17,23,23,12,12,58,58,26,26,57,57,42,42,2,2,30,30,0,0,23,23,22,22,39,39,33,33,14,14,23,23,41,41,50,50,34,34,47,47,34,34,7,7,50,50,57,57,12,12,21,21,15,15,34,34,20,20,14,14,47,47,60,60,25,25,42,42,55,55,56,56,22,22,35,35,8,8,56,56,44,44,62,62,36,36,51,51,7,7,58,58,40,40,46,46,61,61,42,42,39,39,35,35,5,5,42,42,6,6,41,41,44,44,28,28,25,25,2,2,42,42,27,27,13,13,38,38,43,43,42,42,24,24,32,32,27,27,62,62,31,31,31,31,53,53,52,52,4,4,6,6,62,62,2,2,12,12,37,37,8,8,37,37,4,4,5,5,16,16,63,63,32,32,0,0,46,46,63,63,27,27,61,61,10,10,18,18,3,3,59,59,31,31,12,12,5,5,13,13,25,25,60,60,4,4,46,46,56,56,16,16,61,61,52,52,27,27,37,37,15,15,12,12,30,30,35,35,10,10,0,0,59,59,15,15,42,42,61,61,47,47,54,54,39,39,14,14,9,9,48,48,16,16,4,4,41,41,16,16,9,9,46,46,33,33,45,45,16,16,6,6,21,21,7,7,8,8,50,50,11,11,12,12,57,57,51,51,42,42,26,26,47,47,38,38,27,27,22,22,9,9,53,53,18,18,12,12,58,58,7,7,42,42,25,25,3,3,11,11,55,55,1,1,8,8,13,13,30,30,19,19,16,16,15,15,56,56,21,21,3,3,45,45,18,18,2,2,50,50,38,38,59,59,34,34,47,47,25,25,10,10,57,57,14,14,1,1,25,25,32,32,45,45,40,40,5,5,19,19,29,29,2,2,42,42,10,10,58,58,50,50,39,39,53,53,16,16,3,3,52,52,34,34,42,42,32,32,55,55,19,19,10,10,2,2,15,15,58,58,7,7,32,32,4,4,25,25,17,17,40,40,10,10,7,7,5,5,29,29,21,21,17,17,39,39,19,19,29,29,60,60,46,46,38,38,20,20,50,50,6,6,43,43,57,57,37,37,28,28,2,2,42,42,47,47,53,53,39,39,35,35,32,32,47,47,41,41,14,14,20,20,15,15,28,28,44,44,48,48,4,4,41,41,26,26,44,44,62,62,62,62,34,34,22,22,7,7,16,16,17,17,19,19,53,53,17,17,53,53,29,29,38,38,28,28,42,42,15,15,59,59,6,6,37,37,41,41,19,19,32,32,43,43,23,23,34,34,4,4,40,40,22,22,13,13,50,50,0,0,20,20,19,19,51,51,32,32,20,20,18,18,31,31,22,22,39,39,2,2,51,51,56,56,0,0,4,4,51,51,24,24,12,12,44,44,3,3,49,49,13,13,41,41,31,31,8,8,21,21,5,5,34,34,44,44,18,18,0,0,7,7,17,17,42,42,29,29,58,58,1,1,44,44,40,40,9,9,10,10,6,6,2,2,13,13,31,31,21,21,52,52,20,20,41,41,35,35,14,14,63,63,0,0,16,16,16,16,19,19,8,8,45,45,24,24,26,26,13,13,45,45,49,49,61,61,3,3,11,11,13,13,28,28,46,46,52,52,0,0,54,54,42,42,50,50,51,51,49,49,42,42,60,60,10,10,41,41,22,22,6,6,45,45,34,34,45,45,49,49,2,2,14,14,13,13,14,14,41,41,18,18,60,60,48,48,38,38,5,5,32,32,7,7,16,16,18,18,36,36,49,49,2,2,4,4,30,30,40,40,14,14,22,22,13,13,15,15,31,31,9,9,56,56,8,8,16,16,24,24,41,41,13,13,58,58,6,6,31,31,17,17,16,16,54,54,45,45,9,9,36,36,30,30,34,34,26,26,6,6,47,47,17,17,49,49,52,52,56,56,59,59,33,33,40,40,35,35,6,6,46,46,26,26,32,32,46,46,24,24,1,1,63,63,24,24,54,54,50,50,2,2,34,34,35,35,9,9,12,12,49,49,4,4,33,33,18,18,22,22,54,54,10,10,32,32,20,20,11,11,52,52,16,16,44,44,48,48,12,12,7,7,46,46,20,20,59,59,15,15,33,33,24,24,46,46,36,36,0,0,8,8,51,51,55,55,4,4,5,5,23,23,9,9,4,4,55,55,38,38,16,16,24,24,30,30,18,18,53,53,15,15,20,20,51,51,9,9,28,28,62,62,18,18,20,20,9,9,31,31,22,22,23,23,15,15,40,40,12,12,6,6,36,36,59,59,57,57,46,46,17,17,60,60,34,34,0,0,8,8,2,2,35,35,15,15,12,12,35,35,5,5,35,35,24,24,0,0,47,47,37,37,8,8,33,33,41,41,36,36,17,17,58,58,52,52,18,18,17,17,49,49,54,54,39,39,37,37,39,39,21,21,38,38,12,12,44,44,22,22,53,53,25,25,53,53,4,4,45,45,57,57,5,5,14,14,56,56,14,14,15,15,58,58,7,7,4,4,42,42,25,25,4,4,34,34,53,53,45,45,21,21,3,3,0,0,47,47,36,36,38,38,38,38,60,60,15,15,62,62,57,57,12,12,6,6,41,41,14,14,41,41,52,52,17,17,58,58,26,26,36,36,48,48,19,19,58,58,5,5,1,1,54,54,22,22,24,24,16,16,12,12,42,42,56,56,30,30,19,19,22,22,28,28,21,21,40,40,11,11,15,15,55,55,8,8,18,18,10,10,63,63,30,30,52,52,7,7,16,16,36,36,13,13,7,7,57,57,60,60,24,24,2,2,63,63,34,34,27,27,54,54,25,25,36,36,51,51,25,25,17,17,45,45,2,2,13,13,62,62,10,10,7,7,36,36,24,24,36,36,55,55,24,24,7,7,6,6,34,34,37,37,28,28,48,48,30,30,24,24,49,49,4,4,45,45,57,57,37,37,39,39,17,17,10,10,45,45,7,7,35,35,48,48,32,32,20,20,29,29,57,57,44,44,42,42,14,14,28,28,24,24,40,40,55,55,57,57,7,7,49,49,38,38,58,58,20,20,54,54,31,31,26,26,15,15,54,54,25,25,18,18,9,9,54,54,25,25,22,22,24,24,31,31,46,46,60,60,39,39,1,1,41,41,38,38,8,8,47,47,2,2,41,41,58,58,34,34,0,0,3,3,5,5,12,12,48,48,4,4,35,35,0,0,19,19,13,13,27,27,1,1,34,34,8,8,50,50,32,32,41,41,33,33,46,46,49,49,44,44,48,48,3,3,56,56,50,50,55,55,55,55,14,14,58,58,39,39,6,6,48,48,41,41,57,57,8,8,39,39,52,52,40,40,5,5,33,33,46,46,39,39,43,43,43,43,30,30,16,16,53,53,34,34,30,30,33,33,63,63,36,36,51,51,22,22,56,56,11,11,4,4,28,28,53,53,21,21,56,56,38,38,36,36,0,0,17,17,26,26,57,57,18,18,18,18,38,38,48,48,39,39,16,16,50,50,38,38,33,33,9,9,34,34,11,11,56,56,8,8,26,26,15,15,60,60,4,4,4,4,49,49,22,22,2,2,35,35,62,62,49,49,22,22,27,27,37,37,37,37,11,11,23,23,39,39,56,56,60,60,42,42,17,17,52,52,0,0,32,32,62,62,35,35,21,21,29,29,54,54,62,62,48,48,13,13,6,6,4,4,36,36,53,53,56,56,56,56,7,7,20,20,12,12,47,47,54,54,30,30,46,46,25,25,11,11,38,38,10,10,47,47,53,53,16,16,21,21,63,63,4,4,13,13,58,58,6,6,63,63,53,53,45,45,17,17,12,12,58,58,31,31,36,36,18,18,13,13,54,54,25,25,3,3,10,10,11,11,5,5,42,42,48,48,9,9,20,20,7,7,12,12,28,28,22,22,19,19,36,36,28,28,30,30,11,11,5,5,3,3,3,3,4,4,36,36,18,18,0,0,40,40,36,36,40,40,25,25,39,39,40,40,23,23,34,34,12,12,28,28,1,1,16,16,54,54,2,2,24,24,24,24,20,20,43,43,40,40,41,41,28,28,15,15,20,20,12,12,29,29,2,2,16,16,30,30,15,15,2,2,30,30,57,57,26,26,8,8,38,38,29,29,21,21,14,14,49,49,8,8,52,52,33,33,30,30,54,54,37,37,52,52,29,29,34,34,10,10,63,63,8,8,29,29,35,35,0,0,37,37,51,51,58,58,18,18,43,43,35,35,16,16,18,18,22,22,9,9,20,20,14,14,45,45,45,45,63,63,40,40,35,35,55,55,4,4,23,23,8,8,18,18,13,13,30,30,23,23,19,19,57,57,55,55,55,55,28,28,58,58,57,57,14,14,48,48,34,34,46,46,27,27,3,3,40,40,41,41,6,6,54,54,6,6,53,53,10,10,46,46,37,37,37,37,6,6,18,18,20,20,33,33,14,14,52,52,13,13,2,2,19,19,56,56,4,4,25,25,12,12,61,61,56,56,59,59,43,43,24,24,5,5,26,26,8,8,58,58,31,31,56,56,3,3,18,18,12,12,18,18,20,20,3,3,3,3,25,25,31,31,1,1,10,10,8,8,34,34,58,58,30,30,43,43,53,53,56,56,4,4,12,12,63,63,18,18,1,1,25,25,8,8,58,58,22,22,52,52,62,62,38,38,36,36,44,44,15,15,24,24,20,20,24,24,52,52,51,51,33,33,22,22,0,0,34,34,35,35,57,57,12,12,49,49,8,8,54,54,7,7,39,39,6,6,5,5,40,40,8,8,59,59,54,54,48,48,0,0,50,50,37,37,53,53,45,45,18,18,56,56,47,47,26,26,37,37,52,52,1,1,29,29,40,40,47,47,24,24,0,0,12,12,2,2,62,62,6,6,10,10,51,51,54,54,37,37,11,11,57,57,44,44,45,45,39,39,55,55,6,6,41,41,36,36,51,51,26,26,0,0,43,43,31,31,5,5,41,41,57,57,29,29,10,10,28,28,4,4,49,49,8,8,31,31,35,35,20,20,27,27,38,38,55,55,8,8,58,58,36,36,29,29,51,51,15,15,62,62,43,43,26,26,53,53,50,50,43,43,6,6,52,52,23,23,56,56,8,8,53,53,28,28,55,55,55,55,37,37,33,33,9,9,52,52,1,1,44,44,45,45,15,15,36,36,1,1,39,39,51,51,5,5,55,55,1,1,23,23,51,51,50,50,21,21,1,1,7,7,12,12,0,0,20,20,63,63,2,2,30,30,33,33,53,53,35,35,11,11,9,9,16,16,33,33,31,31,18,18,20,20,18,18,4,4,51,51,45,45,23,23,61,61,29,29,41,41,21,21,4,4,30,30,52,52,58,58,5,5,16,16,26,26,14,14,62,62,28,28,2,2,52,52,1,1,33,33,4,4,33,33,48,48,51,51,0,0,3,3,6,6,25,25,33,33,37,37,59,59,30,30,57,57,61,61,61,61,44,44,39,39,1,1,45,45,57,57,10,10,27,27,31,31,61,61,8,8,16,16,9,9,16,16,21,21,48,48,31,31,61,61,54,54,48,48,34,34,48,48,13,13,27,27,60,60,12,12,38,38,60,60,20,20,21,21,6,6,54,54,54,54,42,42,6,6,28,28,40,40,7,7,26,26,30,30,40,40,35,35,45,45,11,11,0,0,53,53,56,56,28,28,38,38,35,35,56,56,44,44,8,8,61,61,21,21,24,24,9,9,53,53,34,34,28,28,11,11,34,34,44,44,47,47,37,37,26,26,31,31,43,43,21,21,58,58,34,34,56,56,62,62,49,49,36,36,16,16,56,56,33,33,50,50,19,19,22,22,49,49,51,51,42,42,1,1,23,23,36,36,52,52,21,21,45,45,29,29,0,0,1,1,59,59,56,56,32,32,2,2,56,56,19,19,1,1,8,8,6,6,35,35,9,9,10,10,63,63,52,52,10,10,44,44,61,61,8,8,35,35,61,61,19,19,27,27,63,63,48,48,51,51,46,46,32,32,29,29,49,49,26,26,2,2,6,6,56,56,24,24,11,11,44,44,28,28,51,51,20,20,45,45,58,58,25,25,1,1,11,11,36,36,16,16,23,23,21,21,1,1,54,54,51,51,35,35,50,50,10,10,7,7,10,10,28,28,11,11,25,25,37,37,23,23,46,46,28,28,19,19,52,52,26,26,62,62,47,47,24,24,44,44,49,49,63,63,47,47,6,6,43,43,22,22,56,56,1,1,9,9,50,50,2,2,63,63,10,10,2,2,14,14,5,5,24,24,24,24,4,4,32,32,38,38,14,14,61,61,6,6,46,46,30,30,37,37,46,46,27,27,19,19,62,62,58,58,22,22,21,21,23,23,26,26,25,25,11,11,32,32,56,56,56,56,37,37,43,43,3,3,8,8,4,4,42,42,25,25,1,1,39,39,7,7,46,46,28,28,18,18,10,10,43,43,28,28,1,1,53,53,31,31,16,16,25,25,18,18,30,30,40,40,21,21,9,9,44,44,12,12,8,8,22,22,19,19,15,15,57,57,11,11,58,58,29,29,28,28,25,25,57,57,48,48,27,27,34,34,43,43,5,5,13,13,10,10,21,21,10,10,53,53,40,40,13,13,15,15,9,9,29,29,62,62,32,32,23,23,51,51,17,17,41,41,13,13,63,63,62,62,13,13,5,5,32,32,46,46,10,10,63,63,11,11,62,62,35,35,25,25,0,0,8,8,53,53,41,41,24,24,27,27,12,12,5,5,39,39,26,26,20,20,59,59,41,41,38,38,12,12,11,11,32,32,4,4,51,51,14,14,34,34,2,2,31,31,4,4,4,4,14,14,55,55,58,58,3,3,5,5,7,7,10,10,21,21,40,40,58,58,25,25,62,62,41,41,21,21,41,41,14,14,58,58,47,47,58,58,14,14,3,3,30,30,6,6,52,52,12,12,10,10,48,48,38,38,55,55,60,60,7,7,37,37,24,24,35,35,27,27,27,27,41,41,8,8,0,0,47,47,25,25,47,47,51,51,38,38,33,33,4,4,38,38,44,44,61,61,51,51,16,16,18,18,47,47,13,13,10,10,58,58,44,44,53,53,54,54,20,20,21,21,58,58,2,2,42,42,36,36,26,26,13,13,50,50,37,37,33,33,3,3,62,62,45,45,18,18,47,47,47,47,34,34,18,18,35,35,3,3,40,40,41,41,36,36,27,27,8,8,33,33,32,32,40,40,60,60,45,45,9,9,50,50,4,4,36,36,29,29,20,20,45,45,20,20,50,50,23,23,1,1,3,3,59,59,12,12,33,33,36,36,12,12,7,7,9,9,49,49,58,58,29,29,7,7,22,22,19,19,59,59,49,49,46,46,56,56,53,53,46,46,16,16,5,5,49,49,15,15,45,45,27,27,29,29,26,26,42,42,2,2,56,56,12,12,10,10,50,50,59,59,47,47,2,2,39,39,50,50,0,0,20,20,0,0,5,5,10,10,51,51,47,47,35,35,44,44,21,21,58,58,26,26,3,3,58,58,29,29,6,6,8,8,50,50,43,43,5,5,55,55,10,10,12,12,22,22,63,63,41,41,3,3,51,51,33,33,33,33,9,9,14,14,48,48,0,0,45,45,43,43,12,12,10,10,60,60,22,22,9,9,48,48,20,20,17,17,0,0,13,13,27,27,57,57,30,30,25,25,16,16,2,2,31,31,19,19,29,29,18,18,27,27,19,19,32,32,3,3,35,35,10,10,7,7,19,19,52,52,58,58,12,12,21,21,19,19,37,37,35,35,40,40,18,18,13,13,8,8,41,41,31,31,37,37,17,17,21,21,36,36,19,19,53,53,2,2,41,41,22,22,17,17,33,33,44,44,48,48,34,34,35,35,33,33,63,63,47,47,48,48,18,18,51,51,60,60,0,0,29,29,28,28,26,26,8,8,27,27,50,50,49,49,42,42,55,55,38,38,25,25,14,14,11,11,33,33,3,3,27,27,4,4,6,6,30,30,57,57,54,54,54,54,14,14,62,62,53,53,11,11,6,6,32,32,15,15,16,16,52,52,3,3,41,41,18,18,6,6,20,20,18,18,38,38,38,38,42,42,7,7,34,34,37,37,54,54,49,49,40,40,1,1,42,42,25,25,40,40,8,8,40,40,3,3,49,49,20,20,11,11,4,4,16,16,10,10,40,40,5,5,62,62,10,10,62,62,40,40,21,21,37,37,39,39,47,47,9,9,27,27,50,50,16,16,23,23,26,26,11,11,24,24,2,2,54,54,20,20,10,10,37,37,8,8,7,7,63,63,19,19,28,28,60,60,26,26,10,10,33,33,56,56,51,51,15,15,25,25,61,61,46,46,43,43,39,39,9,9,12,12,21,21,34,34,20,20,38,38,62,62,38,38,25,25,37,37,30,30,23,23,10,10,10,10,16,16,26,26,25,25,35,35,39,39,58,58,24,24,45,45,20,20,36,36,21,21,22,22,52,52,55,55,59,59,11,11,41,41,42,42,1,1,58,58,54,54,37,37,6,6,35,35,29,29,33,33,59,59,16,16,53,53,63,63,20,20,18,18,29,29,34,34,36,36,6,6,3,3,11,11,59,59,30,30,61,61,58,58,11,11,51,51,3,3,34,34,32,32,17,17,20,20,23,23,16,16,34,34,62,62,38,38,22,22,6,6,61,61,41,41,16,16,52,52,42,42,38,38,58,58,6,6,9,9,60,60,39,39,3,3,26,26,9,9,44,44,58,58,10,10,14,14,40,40,40,40,40,40,1,1,31,31,52,52,45,45,26,26,41,41,30,30,47,47,41,41,41,41,63,63,26,26,32,32,1,1,24,24,18,18,12,12,3,3,27,27,33,33,0,0,21,21,50,50,26,26,20,20,33,33,31,31,42,42,56,56,5,5,37,37,53,53,28,28,34,34,55,55,32,32,13,13,38,38,16,16,51,51,0,0,9,9,18,18,10,10,33,33,4,4,58,58,39,39,32,32,21,21,57,57,34,34,31,31,23,23,45,45,15,15,6,6,9,9,45,45,32,32,19,19,8,8,3,3,34,34,30,30,0,0,16,16,52,52,62,62,4,4,0,0,35,35,6,6,49,49,9,9,2,2,47,47,38,38,0,0,33,33,25,25,14,14,43,43,41,41,56,56,1,1,5,5,63,63,21,21,55,55,63,63,29,29,17,17,5,5,42,42,34,34,46,46,55,55,40,40,43,43,57,57,46,46,5,5,32,32,62,62,50,50,13,13,29,29,23,23,5,5,56,56,16,16,5,5,53,53,4,4,57,57,63,63,38,38,39,39,55,55,35,35,42,42,56,56,27,27,32,32,37,37,40,40,24,24,19,19,21,21,21,21,34,34,30,30,58,58,48,48,3,3,49,49,51,51,34,34,46,46,13,13,34,34,46,46,59,59,59,59,28,28,20,20,29,29,54,54,39,39,0,0,41,41,23,23,0,0,17,17,36,36,4,4,18,18,13,13,9,9,8,8,31,31,4,4,55,55,41,41,59,59,63,63,36,36,37,37,48,48,26,26,28,28,30,30,61,61,12,12,8,8,6,6,0,0,46,46,44,44,63,63,53,53,8,8,56,56,51,51,5,5,47,47,19,19,61,61,46,46,6,6,27,27,16,16,18,18,49,49,26,26,47,47,44,44,38,38,37,37,18,18,18,18,37,37,0,0,40,40,11,11,37,37,19,19,10,10,3,3,22,22,11,11,53,53,34,34,4,4,29,29,38,38,23,23,18,18,20,20,19,19,55,55,31,31,12,12,52,52,47,47,61,61,37,37,48,48,33,33,17,17,9,9,12,12,32,32,29,29,32,32,42,42,44,44,40,40,57,57,39,39,2,2,38,38,0,0,63,63,4,4,25,25,62,62,32,32,20,20,12,12,13,13,51,51,6,6,3,3,7,7,50,50,44,44,37,37,55,55,43,43,21,21,27,27,48,48,48,48,33,33,42,42,52,52,12,12,17,17,33,33,14,14,22,22,56,56,52,52,4,4,27,27,17,17,53,53,26,26,32,32,7,7,28,28,0,0,48,48,41,41,46,46,3,3,61,61,47,47,58,58,50,50,4,4,36,36,45,45,24,24,32,32,62,62,63,63,57,57,42,42,61,61,47,47,36,36,41,41,33,33,60,60,7,7,8,8,14,14,36,36,40,40,5,5,5,5,53,53,37,37,43,43,3,3,36,36,0,0,12,12,49,49,4,4,58,58,52,52,2,2,63,63,60,60,21,21,11,11,2,2,20,20,1,1,25,25,62,62,32,32,4,4,27,27,60,60,63,63,32,32,54,54,59,59,61,61,42,42,54,54,18,18,18,18,42,42,5,5,30,30,44,44,50,50,40,40,22,22,10,10,48,48,21,21,57,57,28,28,22,22,48,48,30,30,54,54,59,59,21,21,10,10,35,35,33,33,41,41,56,56,22,22,5,5,29,29,40,40,35,35,31,31,56,56,41,41,49,49,7,7,40,40,54,54,7,7,3,3,39,39,10,10,12,12,48,48,55,55,47,47,50,50,23,23,33,33,15,15,5,5,15,15,4,4,22,22,60,60,0,0,19,19,10,10,0,0,57,57,19,19,26,26,55,55,56,56,3,3,3,3,7,7,0,0,44,44,30,30,39,39,59,59,63,63,17,17,35,35,19,19,34,34,48,48,57,57,54,54,60,60,32,32,33,33,24,24,11,11,55,55,14,14,10,10,12,12,19,19,22,22,27,27,5,5,36,36,37,37,48,48,9,9,19,19,15,15,22,22,30,30,50,50,53,53,11,11,6,6,1,1,47,47,5,5,42,42,11,11,41,41,63,63,46,46,14,14,6,6,36,36,28,28,34,34,61,61,56,56,19,19,52,52,62,62,49,49,28,28,2,2,9,9,14,14,23,23,56,56,39,39,62,62,40,40,5,5,23,23,0,0,61,61,19,19,39,39,19,19,0,0,26,26,5,5,13,13,41,41,10,10,32,32,28,28,45,45,17,17,37,37,9,9,46,46,7,7,53,53,29,29,39,39,14,14,36,36,55,55,33,33,0,0,62,62,26,26,4,4,33,33,33,33,8,8,11,11,31,31,25,25,17,17,31,31,54,54,7,7,1,1,33,33,28,28,13,13,36,36,10,10,12,12,32,32,56,56,0,0,59,59,33,33,1,1,19,19,61,61,48,48,40,40,27,27,55,55,28,28,22,22,19,19,0,0,48,48,32,32,41,41,36,36,28,28,7,7,38,38,15,15,44,44,23,23,33,33,3,3,2,2,40,40,37,37,21,21,0,0,18,18,38,38,40,40,0,0,33,33,30,30,33,33,41,41,58,58,58,58,29,29,14,14,18,18,25,25,24,24,32,32,40,40,39,39,4,4,4,4,22,22,25,25,4,4,13,13,15,15,51,51,25,25,32,32,7,7,25,25,43,43,20,20,2,2,53,53,59,59,13,13,28,28,51,51,34,34,11,11,58,58,6,6,26,26,34,34,8,8,62,62,15,15,23,23,53,53,56,56,42,42,42,42,53,53,10,10,26,26,61,61,40,40,59,59,18,18,58,58,5,5,54,54,38,38,62,62,17,17,32,32,60,60,23,23,15,15,37,37,40,40,28,28,3,3,56,56,18,18,4,4,24,24,21,21,17,17,41,41,8,8,29,29,23,23,61,61,22,22,35,35,52,52,10,10,2,2,30,30,26,26,4,4,13,13,3,3,28,28,25,25,28,28,57,57,49,49,8,8,55,55,24,24,29,29,29,29,42,42,8,8,19,19,16,16,3,3,38,38,48,48,31,31,12,12,31,31,42,42,16,16,32,32,60,60,58,58,50,50,30,30,29,29,32,32,26,26,41,41,43,43,0,0,37,37,42,42,32,32,62,62,32,32,14,14,46,46,53,53,42,42,45,45,39,39,36,36,42,42,21,21,52,52,16,16,30,30,2,2,41,41,49,49,61,61,54,54,12,12,34,34,15,15,0,0,2,2,36,36,33,33,2,2,36,36,59,59,34,34,5,5,41,41,22,22,34,34,32,32,25,25,36,36,44,44,14,14,1,1,20,20,6,6,54,54,56,56,36,36,20,20,39,39,0,0,30,30,23,23,28,28,4,4,27,27,23,23,23,23,29,29,15,15,38,38,34,34,25,25,13,13,53,53,25,25,23,23,42,42,42,42,28,28,34,34,1,1,9,9,18,18,7,7,12,12,32,32,18,18,61,61,10,10,0,0,52,52,34,34,57,57,50,50,20,20,27,27,25,25,57,57,54,54,32,32,44,44,37,37,22,22,42,42,6,6,29,29,36,36,0,0,46,46,2,2,7,7,24,24,38,38,13,13,7,7,58,58,44,44,1,1,6,6,23,23,27,27,57,57,41,41,60,60,51,51,37,37,56,56,45,45,9,9,8,8,5,5,36,36,49,49,50,50,9,9,57,57,55,55,59,59,33,33,27,27,36,36,39,39,25,25,4,4,43,43,52,52,0,0,34,34,63,63,4,4,29,29,36,36,43,43,38,38,34,34,41,41,17,17,43,43,29,29,2,2,20,20,33,33,63,63,6,6,43,43,36,36,47,47,4,4,24,24,4,4,1,1,44,44,9,9,51,51,28,28,23,23,52,52,41,41,15,15,15,15,16,16,49,49,38,38,34,34,49,49,17,17,47,47,26,26,19,19,45,45,56,56,46,46,18,18,46,46,8,8,25,25,58,58,17,17,14,14,23,23,10,10,55,55,56,56,30,30,49,49,32,32,59,59,32,32,11,11,44,44,7,7,2,2,55,55,15,15,3,3,35,35,37,37,51,51,12,12,32,32,8,8,36,36,5,5,10,10,47,47,11,11,37,37,3,3,34,34,42,42,41,41,59,59,52,52,18,18,2,2,4,4,49,49,60,60,45,45,19,19,2,2,29,29,0,0,41,41,8,8,51,51,32,32,4,4,30,30,0,0,32,32,9,9,46,46,50,50,48,48,17,17,63,63,63,63,40,40,24,24,37,37,51,51,1,1,35,35,3,3,14,14,15,15,16,16,14,14,18,18,43,43,16,16,17,17,61,61,22,22,36,36,58,58,34,34,14,14,56,56,40,40,17,17,1,1,56,56,28,28,0,0,48,48,2,2,2,2,19,19,11,11,42,42,48,48,18,18,4,4,32,32,32,32,1,1,18,18,42,42,7,7,46,46,27,27,58,58,54,54,53,53,49,49,24,24,25,25,52,52,46,46,15,15,15,15,38,38,40,40,7,7,6,6,8,8,48,48,52,52,15,15,52,52,47,47,7,7,20,20,16,16,52,52,15,15,25,25,1,1,18,18,22,22,3,3,21,21,46,46,25,25,44,44,26,26,6,6,57,57,13,13,27,27,17,17,39,39,19,19,4,4,28,28,60,60,44,44,51,51,44,44,54,54,62,62,0,0,8,8,25,25,8,8,2,2,44,44,43,43,57,57,36,36,7,7,23,23,31,31,22,22,13,13,47,47,18,18,32,32,29,29,11,11,5,5,32,32,27,27,8,8,5,5,5,5,6,6,2,2,7,7,13,13,60,60,23,23,10,10,57,57,57,57,28,28,47,47,32,32,19,19,49,49,47,47,60,60,39,39,10,10,40,40,20,20,61,61,8,8,21,21,23,23,24,24,20,20,61,61,3,3,12,12,42,42,61,61,15,15,16,16,37,37,27,27,40,40,27,27,57,57,19,19,2,2,50,50,21,21,3,3,31,31,17,17,61,61,26,26,23,23,7,7,16,16,14,14,57,57,9,9,14,14,9,9,50,50,24,24,2,2,27,27,63,63,45,45,50,50,24,24,59,59,30,30,8,8,60,60,12,12,29,29,12,12,34,34,28,28,36,36,62,62,20,20,18,18,1,1,49,49,63,63,1,1,54,54,28,28,26,26,8,8,35,35,18,18,18,18,44,44,38,38,50,50,59,59,24,24,29,29,5,5,9,9,16,16,40,40,54,54,8,8,8,8,49,49,56,56,57,57,52,52,7,7,20,20,10,10,22,22,38,38,34,34,3,3,44,44,28,28,36,36,8,8,51,51,48,48,21,21,59,59,41,41,37,37,55,55,2,2,6,6,41,41,8,8,52,52,32,32,37,37,13,13,46,46,2,2,54,54,43,43,28,28,19,19,60,60,37,37,62,62,42,42,49,49,48,48,16,16,14,14,58,58,52,52,0,0,37,37,59,59,15,15,38,38,46,46,25,25,47,47,2,2,56,56,0,0,30,30,41,41,22,22,4,4,15,15,33,33,17,17,26,26,44,44,47,47,28,28,51,51,7,7,33,33,31,31,7,7,47,47,19,19,0,0,17,17,18,18,36,36,59,59,38,38,59,59,12,12,32,32,59,59,37,37,50,50,59,59,30,30,48,48,20,20,46,46,7,7,0,0,31,31,27,27,60,60,19,19,11,11,50,50,48,48,17,17,57,57,40,40,27,27,52,52,37,37,5,5,30,30,47,47,52,52,47,47,1,1,51,51,2,2,2,2,41,41,20,20,18,18,48,48,48,48,58,58,59,59,8,8,18,18,25,25,6,6,3,3,0,0,26,26,20,20,60,60,8,8,28,28,1,1,61,61,35,35,18,18,24,24,52,52,48,48,33,33,2,2,25,25,18,18,42,42,47,47,2,2,2,2,50,50,37,37,50,50,0,0,54,54,31,31,49,49,27,27,34,34,55,55,9,9,23,23,54,54,63,63,2,2,36,36,10,10,14,14,11,11,1,1,11,11,32,32,21,21,53,53,20,20,55,55,52,52,10,10,20,20,51,51,46,46,10,10,54,54,11,11,7,7,61,61,51,51,60,60,33,33,5,5,39,39,22,22,47,47,47,47,37,37,62,62,12,12,26,26,6,6,43,43,61,61,57,57,32,32,35,35,1,1,20,20,16,16,53,53,57,57,63,63,61,61,0,0,5,5,61,61,16,16,3,3,29,29,27,27,17,17,49,49,54,54,5,5,13,13,10,10,41,41,34,34,48,48,6,6,29,29,39,39,12,12,7,7,36,36,17,17,17,17,26,26,22,22,5,5,22,22,42,42,33,33,3,3,14,14,28,28,0,0,52,52,62,62,8,8,28,28,26,26,4,4,33,33,48,48,44,44,29,29,19,19,43,43,49,49,52,52,9,9,43,43,42,42,24,24,13,13,44,44,36,36,19,19,18,18,17,17,53,53,58,58,27,27,34,34,13,13,16,16,38,38,4,4,20,20,14,14,31,31,51,51,12,12,1,1,46,46,0,0,61,61,15,15,18,18,46,46,4,4,45,45,55,55,21,21,26,26,48,48,21,21,10,10,59,59,6,6,31,31,35,35,38,38,4,4,6,6,31,31,39,39,34,34,45,45,25,25,49,49,60,60,37,37,61,61,60,60,51,51,23,23,23,23,11,11,9,9,35,35,50,50,27,27,48,48,5,5,35,35,38,38,18,18,27,27,34,34,45,45,15,15,37,37,50,50,1,1,37,37,0,0,52,52,14,14,49,49,40,40,39,39,33,33,31,31,14,14,47,47,8,8,50,50,23,23,20,20,32,32,53,53,56,56,0,0,24,24,1,1,16,16,59,59,17,17,56,56,22,22,60,60,57,57,58,58,43,43,16,16,11,11,51,51,43,43,20,20,50,50,9,9,44,44,51,51,1,1,5,5,25,25,45,45,47,47,58,58,9,9,14,14,4,4,55,55,28,28,55,55,32,32,58,58,25,25,25,25,37,37,8,8,60,60,21,21,61,61,11,11,39,39,12,12,28,28,11,11,55,55,26,26,22,22,58,58,51,51,51,51,34,34,20,20,16,16,6,6,29,29,9,9,28,28,58,58,52,52,50,50,10,10,0,0,11,11,30,30,61,61,62,62,32,32,34,34,34,34,9,9,33,33,40,40,44,44,21,21,35,35,27,27,44,44,41,41,22,22,54,54,42,42,16,16,34,34,55,55,41,41,26,26,29,29,5,5,39,39,40,40,23,23,63,63,18,18,32,32,0,0,43,43,20,20,53,53,24,24,42,42,41,41,27,27,22,22,60,60,22,22,8,8,4,4,16,16,61,61,54,54,57,57,46,46,3,3,33,33,37,37,33,33,3,3,22,22,16,16,46,46,2,2,26,26,21,21,62,62,16,16,60,60,18,18,25,25,20,20,27,27,21,21,17,17,38,38,48,48,35,35,21,21,56,56,8,8,11,11,20,20,13,13,7,7,2,2,3,3,22,22,38,38,38,38,44,44,45,45,8,8,10,10,45,45,28,28,54,54,40,40,8,8,54,54,41,41,4,4,21,21,11,11,45,45,48,48,25,25,10,10,18,18,49,49,23,23,10,10,12,12,49,49,5,5,29,29,32,32,33,33,7,7,48,48,4,4,17,17,61,61,5,5,1,1,19,19,62,62,8,8,34,34,31,31,24,24,42,42,56,56,13,13,20,20,17,17,46,46,2,2,15,15,27,27,33,33,41,41,25,25,30,30,30,30,63,63,29,29,30,30,58,58,33,33,26,26,48,48,63,63,60,60,2,2,33,33,43,43,43,43,48,48,21,21,36,36,12,12,6,6,22,22,26,26,29,29,30,30,61,61,18,18,16,16,28,28,15,15,28,28,32,32,58,58,15,15,32,32,10,10,4,4,45,45,0,0,22,22,61,61,18,18,54,54,26,26,2,2,43,43,8,8,47,47,4,4,8,8,19,19,45,45,13,13,14,14,58,58,44,44,19,19,7,7,18,18,63,63,52,52,6,6,29,29,3,3,28,28,12,12,40,40,53,53,52,52,55,55,48,48,43,43,53,53,37,37,51,51,17,17,4,4,56,56,17,17,35,35,16,16,47,47,27,27,35,35,19,19,4,4,63,63,27,27,12,12,11,11,26,26,8,8,12,12,36,36,5,5,45,45,61,61,56,56,17,17,57,57,12,12,47,47,30,30,26,26,50,50,17,17,0,0,43,43,41,41,34,34,21,21,25,25,61,61,11,11,32,32,17,17,3,3,13,13,48,48,58,58,6,6,21,21,2,2,51,51,57,57,12,12,0,0,15,15,24,24,21,21,14,14,57,57,25,25,3,3,30,30,48,48,7,7,50,50,22,22,5,5,60,60,36,36,0,0,14,14,57,57,44,44,35,35,0,0,35,35,22,22,39,39,20,20,49,49,58,58,38,38,54,54,32,32,26,26,26,26,63,63,36,36,11,11,7,7,59,59,9,9,28,28,31,31,41,41,10,10,20,20,9,9,59,59,50,50,41,41,5,5,2,2,31,31,8,8,50,50,60,60,11,11,41,41,9,9,1,1,31,31,15,15,43,43,3,3,60,60,20,20,25,25,19,19,32,32,11,11,56,56,28,28,63,63,18,18,50,50,21,21,44,44,48,48,29,29,30,30,21,21,38,38,2,2,35,35,11,11,26,26,8,8,55,55,11,11,38,38,4,4,18,18,52,52,36,36,56,56,4,4,25,25,63,63,15,15,46,46,42,42,47,47,6,6,10,10,28,28,59,59,12,12,33,33,18,18,18,18,1,1,16,16,37,37,40,40,11,11,27,27,37,37,7,7,36,36,44,44,42,42,9,9,13,13,9,9,14,14,41,41,43,43,33,33,57,57,8,8,9,9,36,36,33,33,22,22,20,20,42,42,4,4,25,25,2,2,21,21,54,54,61,61,61,61,48,48,15,15,32,32,29,29,40,40,41,41,26,26,19,19,3,3,0,0,53,53,1,1,12,12,3,3,57,57,22,22,28,28,48,48,25,25,28,28,52,52,51,51,0,0,51,51,42,42,13,13,0,0,52,52,39,39,20,20,58,58,61,61,26,26,18,18,17,17,9,9,28,28,58,58,27,27,37,37,9,9,29,29,12,12,13,13,24,24,35,35,63,63,6,6,43,43,5,5,36,36,37,37,8,8,44,44,41,41,4,4,36,36,50,50,47,47,15,15,0,0,4,4,53,53,54,54,37,37,41,41,39,39,9,9,63,63,12,12,19,19,55,55,6,6,58,58,2,2,48,48,23,23,63,63,45,45,8,8,35,35,55,55,22,22,30,30,25,25,9,9,51,51,8,8,4,4,38,38,6,6,10,10,42,42,56,56,29,29,14,14,23,23,37,37,13,13,7,7,25,25,57,57,49,49,4,4,0,0,40,40,16,16,30,30,52,52,63,63,22,22,23,23,35,35,30,30,30,30,26,26,52,52,47,47,37,37,39,39,16,16,30,30,28,28,54,54,0,0,56,56,18,18,50,50,18,18,32,32,53,53,44,44,10,10,10,10,33,33,3,3,14,14,36,36,22,22,19,19,61,61,41,41,49,49,37,37,42,42,23,23,36,36,31,31,35,35,47,47,10,10,33,33,60,60,4,4,12,12,26,26,41,41,36,36,51,51,37,37,44,44,48,48,48,48,4,4,22,22,25,25,19,19,33,33,39,39,38,38,58,58,46,46,31,31,12,12,46,46,51,51,34,34,30,30,61,61,32,32,13,13,32,32,56,56,34,34,53,53,50,50,44,44,44,44,36,36,29,29,1,1,42,42,15,15,20,20,48,48,6,6,50,50,47,47,57,57,23,23,48,48,22,22,5,5,16,16,32,32,34,34,8,8,31,31,30,30,21,21,37,37,62,62,34,34,48,48,11,11,51,51,2,2,50,50,10,10,42,42,19,19,47,47,21,21,7,7,12,12,17,17,1,1,2,2,50,50,11,11,54,54,44,44,36,36,42,42,12,12,30,30,9,9,51,51,14,14,50,50,49,49,35,35,2,2,38,38,56,56,33,33,39,39,13,13,63,63,54,54,20,20,6,6,46,46,8,8,61,61,40,40,8,8,2,2,1,1,12,12,42,42,35,35,21,21,26,26,56,56,60,60,34,34,61,61,59,59,11,11,50,50,48,48,14,14,4,4,14,14,14,14,35,35,42,42,26,26,60,60,62,62,23,23,37,37,61,61,8,8,41,41,42,42,17,17,10,10,5,5,20,20,54,54,19,19,38,38,26,26,4,4,7,7,61,61,41,41,8,8,5,5,22,22,9,9,42,42,61,61,11,11,7,7,63,63,15,15,32,32,6,6,58,58,16,16,20,20,17,17,41,41,61,61,6,6,49,49,55,55,29,29,8,8,2,2,61,61,58,58,52,52,32,32,44,44,18,18,37,37,17,17,19,19,61,61,43,43,20,20,34,34,18,18,18,18,7,7,36,36,21,21,8,8,40,40,20,20,19,19,8,8,46,46,12,12,3,3,43,43,59,59,39,39,43,43,38,38,6,6,29,29,16,16,4,4,21,21,35,35,43,43,50,50,48,48,21,21,33,33,33,33,49,49,5,5,19,19,56,56,31,31,27,27,6,6,7,7,18,18,4,4,14,14,13,13,48,48,20,20,30,30,43,43,42,42,4,4,46,46,15,15,33,33,62,62,23,23,56,56,12,12,21,21,46,46,43,43,14,14,54,54,3,3,22,22,41,41,59,59,7,7,17,17,32,32,46,46,46,46,27,27,57,57,26,26,33,33,49,49,31,31,34,34,11,11,9,9,37,37,62,62,14,14,52,52,58,58,49,49,52,52,32,32,47,47,4,4,21,21,14,14,17,17,61,61,56,56,39,39,41,41,4,4,59,59,57,57,45,45,31,31,28,28,18,18,40,40,43,43,12,12,22,22,8,8,62,62,28,28,51,51,15,15,3,3,12,12,28,28,32,32,45,45,44,44,20,20,50,50,28,28,5,5,22,22,54,54,19,19,10,10,35,35,11,11,5,5,40,40,25,25,16,16,23,23,47,47,24,24,42,42,24,24,49,49,53,53,19,19,46,46,44,44,36,36,23,23,14,14,57,57,43,43,33,33,18,18,47,47,20,20,45,45,21,21,4,4,20,20,5,5,58,58,42,42,36,36,36,36,23,23,5,5,38,38,7,7,19,19,13,13,32,32,40,40,21,21,40,40,36,36,39,39,17,17,36,36,36,36,18,18,53,53,26,26,16,16,3,3,5,5,12,12,24,24,6,6,56,56,22,22,29,29,63,63,4,4,26,26,32,32,44,44,53,53,57,57,26,26,54,54,21,21,42,42,25,25,5,5,55,55,40,40,0,0,49,49,57,57,62,62,20,20,22,22,34,34,12,12,19,19,17,17,56,56,38,38,34,34,47,47,7,7,58,58,24,24,62,62,30,30,61,61,62,62,36,36,20,20,4,4,26,26,5,5,19,19,14,14,30,30,38,38,13,13,8,8,33,33,51,51,63,63,16,16,32,32,33,33,6,6,41,41,51,51,22,22,34,34,24,24,5,5,9,9,17,17,49,49,37,37,41,41,63,63,9,9,28,28,61,61,48,48,48,48,35,35,4,4,25,25,51,51,20,20,31,31,17,17,63,63,39,39,25,25,7,7,38,38,10,10,50,50,37,37,8,8,47,47,9,9,5,5,19,19,10,10,15,15,47,47,5,5,59,59,56,56,62,62,37,37,55,55,4,4,58,58,21,21,10,10,22,22,7,7,58,58,3,3,20,20,3,3,39,39,18,18,54,54,19,19,54,54,59,59,14,14,20,20,48,48,32,32,54,54,48,48,8,8,26,26,59,59,27,27,4,4,62,62,21,21,2,2,62,62,58,58,9,9,29,29,2,2,33,33,16,16,41,41,23,23,47,47,37,37,34,34,28,28,55,55,32,32,51,51,23,23,21,21,33,33,20,20,43,43,55,55,8,8,48,48,51,51,40,40,48,48,44,44,40,40,55,55,45,45,45,45,45,45,18,18,31,31,11,11,15,15,13,13,29,29,61,61,39,39,26,26,41,41,60,60,20,20,6,6,32,32,42,42,39,39,13,13,28,28,4,4,24,24,34,34,52,52,45,45,49,49,27,27,25,25,26,26,5,5,11,11,16,16,54,54,50,50,36,36,56,56,0,0,60,60,25,25,22,22,61,61,35,35,56,56,46,46,27,27,51,51,63,63,32,32,48,48,24,24,56,56,42,42,56,56,23,23,45,45,8,8,27,27,11,11,15,15,60,60,48,48,21,21,10,10,5,5,18,18,60,60,16,16,4,4,49,49,7,7,28,28,40,40,16,16,30,30,43,43,17,17,6,6,21,21,32,32,53,53,60,60,46,46,34,34,47,47,32,32,35,35,15,15,59,59,10,10,32,32,1,1,58,58,38,38,29,29,24,24,52,52,26,26,61,61,36,36,19,19,13,13,17,17,11,11,52,52,48,48,25,25,31,31,45,45,14,14,43,43,32,32,31,31,42,42,44,44,26,26,38,38,6,6,7,7,39,39,31,31,40,40,28,28,2,2,54,54,36,36,56,56,7,7,39,39,9,9,46,46,37,37,58,58,3,3,28,28,12,12,49,49,0,0,4,4,6,6,33,33,61,61,36,36,56,56,60,60,3,3,22,22,17,17,24,24,52,52,16,16,20,20,20,20,41,41,35,35,18,18,0,0,24,24,28,28,55,55,48,48,41,41,30,30,8,8,45,45,35,35,38,38,7,7,24,24,60,60,58,58,50,50,4,4,20,20,27,27,54,54,46,46,26,26,28,28,10,10,59,59,8,8,53,53,25,25,38,38,61,61,30,30,54,54,33,33,5,5,21,21,34,34,21,21,59,59,44,44,45,45,50,50,48,48,56,56,40,40,63,63,43,43,11,11,29,29,6,6,15,15,52,52,30,30,40,40,51,51,37,37,18,18,6,6,41,41,7,7,14,14,51,51,35,35,33,33,9,9,32,32,41,41,43,43,4,4,50,50,47,47,27,27,11,11,19,19,59,59,23,23,12,12,18,18,7,7,51,51,45,45,38,38,23,23,42,42,47,47,40,40,3,3,38,38,49,49,48,48,4,4,42,42,62,62,9,9,15,15,5,5,61,61,15,15,50,50,11,11,10,10,27,27,33,33,4,4,19,19,27,27,31,31,35,35,39,39,53,53,16,16,45,45,34,34,0,0,28,28,3,3,18,18,17,17,36,36,48,48,51,51,42,42,5,5,28,28,15,15,38,38,62,62,40,40,10,10,7,7,7,7,48,48,38,38,17,17,20,20,62,62,22,22,17,17,3,3,41,41,49,49,30,30,62,62,15,15,30,30,26,26,50,50,54,54,60,60,33,33,25,25,60,60,47,47,12,12,8,8,12,12,43,43,2,2,4,4,39,39,18,18,50,50,48,48,17,17,56,56,12,12,19,19,26,26,32,32,4,4,24,24,61,61,3,3,40,40,5,5,15,15,16,16,4,4,59,59,43,43,12,12,48,48,25,25,22,22,16,16,2,2,60,60,52,52,29,29,11,11,25,25,18,18,62,62,17,17,63,63,7,7,7,7,37,37,60,60,10,10,11,11,40,40,37,37,59,59,21,21,52,52,8,8,62,62,22,22,16,16,13,13,34,34,48,48,9,9,37,37,48,48,52,52,31,31,35,35,31,31,16,16,11,11,37,37,28,28,8,8,63,63,12,12,50,50,11,11,28,28,36,36,43,43,1,1,2,2,44,44,36,36,27,27,37,37,12,12,44,44,19,19,27,27,12,12,18,18,57,57,9,9,20,20,21,21,24,24,10,10,9,9,61,61,16,16,8,8,11,11,37,37,56,56,3,3,24,24,8,8,23,23,54,54,40,40,10,10,52,52,5,5,19,19,53,53,14,14,34,34,18,18,21,21,2,2,41,41,23,23,27,27,13,13,56,56,42,42,1,1,8,8,8,8,51,51,10,10,42,42,4,4,26,26,38,38,45,45,23,23,62,62,19,19,61,61,57,57,58,58,1,1,52,52,30,30,34,34,6,6,36,36,0,0,48,48,26,26,28,28,12,12,48,48,63,63,38,38,59,59,27,27,27,27,2,2,14,14,12,12,32,32,4,4,34,34,42,42,25,25,60,60,50,50,15,15,19,19,45,45,49,49,15,15,36,36,21,21,54,54,4,4,32,32,52,52,11,11,37,37,9,9,12,12,38,38,39,39,15,15,1,1,1,1,6,6,1,1,18,18,48,48,52,52,61,61,46,46,25,25,51,51,39,39,54,54,0,0,34,34,17,17,39,39,5,5,20,20,39,39,2,2,4,4,20,20,32,32,42,42,44,44,46,46,46,46,47,47,2,2,39,39,62,62,11,11,38,38,6,6,46,46,40,40,44,44,8,8,43,43,30,30,41,41,41,41,21,21,16,16,49,49,48,48,53,53,54,54,8,8,25,25,63,63,15,15,21,21,21,21,27,27,41,41,4,4,13,13,9,9,50,50,9,9,30,30,26,26,19,19,7,7,60,60,3,3,21,21,59,59,52,52,25,25,37,37,13,13,49,49,21,21,23,23,48,48,12,12,1,1,13,13,53,53,16,16,10,10,25,25,13,13,55,55,58,58,29,29,34,34,22,22,30,30,29,29,15,15,50,50,24,24,12,12,53,53,35,35,33,33,57,57,56,56,38,38,11,11,35,35,21,21,38,38,42,42,16,16,24,24,27,27,59,59,4,4,3,3,58,58,4,4,37,37,57,57,13,13,55,55,11,11,2,2,48,48,20,20,51,51,2,2,17,17,45,45,45,45,26,26,0,0,54,54,30,30,40,40,48,48,3,3,25,25,29,29,49,49,0,0,16,16,55,55,26,26,35,35,40,40,19,19,4,4,59,59,46,46,37,37,4,4,51,51,14,14,20,20,37,37,36,36,32,32,54,54,52,52,37,37,14,14,27,27,10,10,19,19,37,37,2,2,1,1,43,43,18,18,40,40,55,55,33,33,41,41,28,28,30,30,48,48,11,11,36,36,47,47,23,23,45,45,28,28,16,16,56,56,26,26,20,20,38,38,55,55,59,59,32,32,38,38,12,12,25,25,3,3,62,62,45,45,42,42,6,6,24,24,7,7,42,42,32,32,57,57,14,14,51,51,4,4,55,55,23,23,31,31,16,16,9,9,35,35,32,32,24,24,36,36,25,25,40,40,43,43,50,50,19,19,11,11,54,54,44,44,19,19,8,8,8,8,49,49,9,9,24,24,27,27,37,37,56,56,33,33,57,57,18,18,19,19,48,48,41,41,7,7,60,60,3,3,32,32,30,30,19,19,35,35,50,50,32,32,5,5,40,40,52,52,15,15,4,4,7,7,1,1,58,58,33,33,3,3,23,23,39,39,6,6,29,29,47,47,38,38,34,34,50,50,37,37,60,60,17,17,36,36,31,31,42,42,35,35,18,18,36,36,58,58,52,52,42,42,1,1,21,21,54,54,38,38,0,0,5,5,45,45,30,30,8,8,16,16,0,0,19,19,24,24,55,55,48,48,17,17,57,57,60,60,56,56,31,31,53,53,44,44,44,44,26,26,18,18,9,9,40,40,16,16,52,52,32,32,7,7,10,10,2,2,39,39,22,22,57,57,7,7,30,30,5,5,22,22,20,20,30,30,48,48,39,39,56,56,50,50,41,41,3,3,45,45,11,11,52,52,21,21,56,56,59,59,0,0,63,63,1,1,11,11,42,42,48,48,34,34,30,30,62,62,55,55,43,43,0,0,40,40,48,48,51,51,56,56,33,33,0,0,59,59,29,29,39,39,22,22,12,12,10,10,7,7,25,25,37,37,12,12,61,61,17,17,18,18,41,41,20,20,44,44,5,5,22,22,14,14,40,40,26,26,4,4,0,0,26,26,42,42,38,38,62,62,28,28,63,63,42,42,43,43,6,6,59,59,23,23,22,22,59,59,43,43,29,29,24,24,33,33,1,1,23,23,12,12,29,29,16,16,4,4,9,9,44,44,54,54,36,36,44,44,30,30,1,1,57,57,22,22,4,4,53,53,17,17,44,44,54,54,24,24,8,8,10,10,0,0,21,21,56,56,9,9,51,51,54,54,18,18,8,8,30,30,13,13,33,33,40,40,17,17,60,60,2,2,9,9,7,7,15,15,13,13,17,17,43,43,31,31,58,58,36,36,1,1,53,53,23,23,12,12,38,38,10,10,51,51,1,1,48,48,31,31,53,53,10,10,4,4,37,37,18,18,3,3,40,40,43,43,57,57,63,63,50,50,61,61,11,11,42,42,63,63,56,56,63,63,31,31,20,20,28,28,34,34,8,8,24,24,7,7,46,46,29,29,19,19,8,8,6,6,13,13,48,48,35,35,23,23,51,51,0,0,62,62,37,37,5,5,52,52,38,38,62,62,8,8,46,46,35,35,13,13,32,32,13,13,38,38,29,29,22,22,26,26,51,51,24,24,8,8,57,57,6,6,37,37,62,62,46,46,13,13,51,51,50,50,15,15,11,11,32,32,23,23,41,41,0,0,19,19,45,45,53,53,43,43,5,5,48,48,40,40,17,17,22,22,3,3,2,2,55,55,3,3,24,24,16,16,33,33,38,38,35,35,6,6,6,6,57,57,13,13,50,50,20,20,0,0,3,3,48,48,46,46,5,5,34,34,55,55,4,4,36,36,41,41,55,55,23,23,23,23,28,28,15,15,0,0,11,11,19,19,7,7,20,20,10,10,10,10,9,9,12,12,49,49,49,49,38,38,55,55,3,3,7,7,26,26,18,18,51,51,8,8,63,63,9,9,47,47,23,23,9,9,37,37,55,55,12,12,54,54,27,27,61,61,33,33,51,51,21,21,25,25,36,36,43,43,14,14,40,40,63,63,33,33,28,28,61,61,52,52,12,12,55,55,22,22,6,6,44,44,8,8,62,62,34,34,16,16,57,57,44,44,28,28,59,59,36,36,5,5,57,57,29,29,25,25,27,27,23,23,54,54,9,9,12,12,23,23,46,46,17,17,47,47,25,25,24,24,0,0,32,32,26,26,14,14,38,38,62,62,56,56,62,62,18,18,1,1,21,21,45,45,24,24,25,25,15,15,37,37,17,17,11,11,10,10,59,59,44,44,14,14,12,12,0,0,61,61,5,5,26,26,6,6,39,39,26,26,48,48,9,9,19,19,34,34,0,0,50,50,37,37,20,20,16,16,27,27,63,63,0,0,49,49,7,7,4,4,13,13,24,24,17,17,11,11,42,42,50,50,62,62,21,21,55,55,23,23,39,39,19,19,43,43,6,6,63,63,13,13,6,6,18,18,23,23,16,16,31,31,2,2,9,9,14,14,35,35,46,46,36,36,43,43,36,36,4,4,5,5,19,19,11,11,44,44,41,41,59,59,56,56,0,0,55,55,32,32,24,24,19,19,27,27,4,4,21,21,54,54,0,0,13,13,22,22,40,40,36,36,3,3,61,61,42,42,33,33,37,37,54,54,45,45,50,50,14,14,0,0,50,50,37,37,7,7,11,11,6,6,11,11,36,36,4,4,2,2,29,29,55,55,14,14,42,42,50,50,22,22,3,3,12,12,43,43,29,29,32,32,57,57,35,35,39,39,4,4,38,38,21,21,4,4,5,5,51,51,34,34,34,34,23,23,8,8,60,60,52,52,25,25,30,30,57,57,41,41,23,23,60,60,46,46,48,48,17,17,45,45,36,36,7,7,0,0,59,59,34,34,57,57,63,63,50,50,11,11,13,13,31,31,37,37,2,2,25,25,30,30,17,17,43,43,5,5,52,52,8,8,43,43,24,24,46,46,21,21,56,56,10,10,62,62,62,62,1,1,44,44,20,20,33,33,56,56,32,32,52,52,20,20,53,53,36,36,25,25,39,39,48,48,56,56,12,12,36,36,26,26,36,36,30,30,53,53,17,17,48,48,2,2,6,6,16,16,25,25,58,58,50,50,25,25,51,51,18,18,37,37,7,7,37,37,41,41,27,27,9,9,17,17,1,1,17,17,56,56,41,41,34,34,37,37,53,53,35,35,41,41,6,6,13,13,44,44,8,8,10,10,25,25,43,43,52,52,28,28,14,14,25,25,13,13,19,19,49,49,31,31,36,36,50,50,4,4,0,0,28,28,28,28,37,37,50,50,39,39,30,30,17,17,18,18,63,63,55,55,58,58,26,26,61,61,33,33,60,60,11,11,58,58,26,26,5,5,32,32,17,17,53,53,32,32,56,56,18,18,19,19,16,16,56,56,57,57,9,9,36,36,45,45,17,17,49,49,1,1,19,19,1,1,56,56,14,14,33,33,21,21,37,37,51,51,25,25,52,52,16,16,29,29,60,60,10,10,0,0,2,2,33,33,58,58,5,5,11,11,34,34,20,20,10,10,35,35,43,43,1,1,55,55,58,58,32,32,6,6,3,3,43,43,41,41,7,7,48,48,32,32,6,6,3,3,41,41,18,18,9,9,45,45,45,45,54,54,19,19,33,33,5,5,37,37,2,2,14,14,20,20,18,18,3,3,28,28,19,19,8,8,27,27,4,4,6,6,8,8,56,56,37,37,11,11,38,38,38,38,41,41,14,14,32,32,44,44,53,53,3,3,29,29,56,56,16,16,16,16,62,62,16,16,11,11,20,20,0,0,37,37,11,11,49,49,27,27,1,1,37,37,4,4,59,59,13,13,23,23,13,13,56,56,18,18,9,9,53,53,47,47,59,59,42,42,7,7,39,39,35,35,38,38,52,52,11,11,54,54,1,1,23,23,63,63,25,25,59,59,50,50,31,31,45,45,58,58,7,7,48,48,56,56,9,9,48,48,22,22,42,42,4,4,0,0,7,7,35,35,17,17,13,13,22,22,29,29,10,10,27,27,1,1,63,63,6,6,37,37,0,0,3,3,57,57,41,41,9,9,14,14,43,43,18,18,9,9,17,17,16,16,31,31,30,30,34,34,23,23,18,18,32,32,28,28,53,53,52,52,44,44,0,0,4,4,43,43,39,39,62,62,27,27,31,31,29,29,26,26,22,22,21,21,52,52,23,23,35,35,57,57,12,12,38,38,28,28,21,21,2,2,32,32,41,41,12,12,60,60,44,44,8,8,14,14,29,29,26,26,44,44,40,40,12,12,15,15,34,34,60,60,19,19,4,4,22,22,18,18,44,44,46,46,13,13,5,5,27,27,26,26,56,56,61,61,56,56,45,45,6,6,0,0,11,11,39,39,7,7,12,12,5,5,19,19,57,57,9,9,13,13,8,8,42,42,46,46,41,41,52,52,50,50,11,11,7,7,36,36,24,24,41,41,17,17,23,23,43,43,8,8,33,33,49,49,54,54,23,23,61,61,19,19,39,39,53,53,11,11,21,21,49,49,24,24,57,57,41,41,27,27,38,38,1,1,1,1,35,35,6,6,2,2,36,36,0,0,4,4,25,25,3,3,62,62,0,0,58,58,42,42,10,10,24,24,39,39,6,6,61,61,31,31,32,32,38,38,56,56,39,39,60,60,41,41,33,33,43,43,12,12,8,8,7,7,3,3,37,37,46,46,47,47,44,44,20,20,27,27,40,40,25,25,21,21,15,15,36,36,42,42,57,57,40,40,59,59,18,18,19,19,40,40,39,39,30,30,4,4,38,38,34,34,4,4,55,55,63,63,37,37,12,12,30,30,7,7,61,61,31,31,24,24,39,39,18,18,61,61,22,22,54,54,25,25,60,60,48,48,40,40,5,5,13,13,17,17,39,39,55,55,40,40,25,25,29,29,62,62,55,55,16,16,46,46,3,3,55,55,7,7,40,40,51,51,35,35,4,4,57,57,8,8,47,47,1,1,12,12,25,25,44,44,45,45,7,7,6,6,60,60,25,25,39,39,53,53,18,18,35,35,40,40,27,27,35,35,58,58,23,23,27,27,1,1,16,16,0,0,17,17,12,12,1,1,44,44,17,17,34,34,30,30,62,62,42,42,47,47,32,32,7,7,33,33,39,39,54,54,27,27,26,26,52,52,14,14,41,41,16,16,54,54,26,26,33,33,23,23,56,56,46,46,16,16,23,23,32,32,43,43,5,5,3,3,45,45,40,40,5,5,56,56,25,25,35,35,7,7,6,6,38,38,1,1,29,29,3,3,18,18,6,6,41,41,60,60,29,29,63,63,31,31,27,27,10,10,58,58,20,20,63,63,3,3,16,16,15,15,32,32,13,13,23,23,60,60,28,28,19,19,7,7,59,59,11,11,56,56,53,53,8,8,55,55,24,24,18,18,60,60,47,47,55,55,28,28,62,62,21,21,39,39,58,58,36,36,8,8,59,59,48,48,61,61,39,39,26,26,4,4,16,16,44,44,25,25,30,30,39,39,13,13,10,10,1,1,39,39,3,3,2,2,40,40,61,61,50,50,38,38,26,26,45,45,41,41,38,38,55,55,25,25,29,29,10,10,45,45,18,18,10,10,54,54,10,10,55,55,33,33,60,60,51,51,59,59,54,54,4,4,28,28,44,44,10,10,50,50,17,17,8,8,17,17,59,59,44,44,41,41,28,28,3,3,47,47,33,33,55,55,58,58,31,31,38,38,55,55,38,38,40,40,56,56,43,43,4,4,21,21,60,60,39,39,63,63,11,11,32,32,55,55,51,51,31,31,41,41,44,44,8,8,58,58,35,35,35,35,30,30,24,24,49,49,34,34,55,55,17,17,42,42,53,53,45,45,25,25,56,56,7,7,52,52,2,2,18,18,35,35,49,49,24,24,2,2,48,48,60,60,62,62,30,30,26,26,25,25,33,33,25,25,17,17,32,32,39,39,14,14,27,27,31,31,18,18,3,3,47,47,50,50,7,7,1,1,2,2,15,15,15,15,22,22,0,0,37,37,31,31,29,29,41,41,29,29,56,56,24,24,46,46,9,9,23,23,17,17,27,27,32,32,54,54,44,44,22,22,53,53,11,11,59,59,1,1,33,33,8,8,46,46,29,29,36,36,27,27,34,34,3,3,19,19,18,18,52,52,38,38,42,42,19,19,2,2,44,44,31,31,20,20,35,35,40,40,47,47,52,52,40,40,4,4,31,31,50,50,17,17,59,59,9,9,29,29,27,27,21,21,36,36,8,8,62,62,44,44,53,53,19,19,45,45,48,48,1,1,5,5,22,22,8,8,19,19,0,0,50,50,6,6,51,51,32,32,1,1,34,34,6,6,36,36,36,36,46,46,57,57,47,47,62,62,7,7,10,10,27,27,46,46,27,27,51,51,5,5,1,1,17,17,14,14,49,49,44,44,2,2,36,36,56,56,18,18,35,35,14,14,60,60,12,12,16,16,17,17,20,20,2,2,55,55,5,5,11,11,10,10,36,36,52,52,56,56,58,58,23,23,58,58,47,47,52,52,27,27,4,4,22,22,12,12,27,27,50,50,62,62,1,1,24,24,19,19,15,15,17,17,53,53,56,56,31,31,58,58,23,23,22,22,16,16,28,28,14,14,3,3,48,48,60,60,19,19,38,38,3,3,25,25,55,55,33,33,5,5,51,51,10,10,50,50,6,6,1,1,13,13,10,10,58,58,60,60,32,32,8,8,7,7,4,4,23,23,13,13,29,29,11,11,55,55,43,43,44,44,56,56,55,55,12,12,12,12,15,15,44,44,55,55,45,45,4,4,7,7,19,19,10,10,57,57,29,29,17,17,22,22,27,27,39,39,21,21,9,9,13,13,63,63,3,3,34,34,53,53,10,10,60,60,9,9,34,34,20,20,59,59,55,55,10,10,61,61,14,14,50,50,41,41,54,54,52,52,58,58,19,19,25,25,53,53,48,48,19,19,62,62,0,0,32,32,23,23,16,16,3,3,12,12,47,47,21,21,45,45,43,43,12,12,45,45,38,38,4,4,62,62,8,8,21,21,37,37,0,0,59,59,3,3,59,59,19,19,14,14,30,30,36,36,49,49,42,42,35,35,24,24,50,50,60,60,49,49,58,58,63,63,61,61,45,45,9,9,22,22,58,58,18,18,1,1,49,49,63,63,8,8,51,51,7,7,9,9,42,42,16,16,42,42,5,5,46,46,40,40,46,46,42,42,25,25,47,47,1,1,26,26,47,47,27,27,27,27,4,4,30,30,59,59,26,26,6,6,53,53,60,60,32,32,13,13,11,11,8,8,51,51,2,2,50,50,16,16,11,11,34,34,17,17,6,6,16,16,62,62,4,4,10,10,4,4,22,22,15,15,7,7,51,51,42,42,50,50,36,36,4,4,47,47,14,14,42,42,33,33,53,53,1,1,22,22,38,38,7,7,11,11,19,19,10,10,34,34,45,45,49,49,20,20,30,30,52,52,14,14,57,57,33,33,12,12,3,3,27,27,20,20,22,22,8,8,50,50,24,24,14,14,22,22,4,4,21,21,29,29,2,2,50,50,22,22,40,40,51,51,39,39,27,27,58,58,24,24,4,4,8,8,39,39,29,29,27,27,0,0,31,31,34,34,50,50,19,19,4,4,40,40,51,51,36,36,60,60,16,16,34,34,50,50,22,22,31,31,26,26,6,6,23,23,7,7,51,51,58,58,24,24,1,1,6,6,30,30,7,7,7,7,9,9,36,36,39,39,49,49,57,57,55,55,1,1,25,25,2,2,26,26,55,55,47,47,30,30,8,8,14,14,12,12,39,39,58,58,27,27,56,56,43,43,41,41,54,54,13,13,1,1,55,55,44,44,61,61,16,16,27,27,47,47,46,46,1,1,20,20,63,63,20,20,54,54,27,27,52,52,15,15,44,44,21,21,36,36,6,6,0,0,54,54,12,12,63,63,39,39,4,4,24,24,0,0,14,14,16,16,61,61,8,8,31,31,24,24,48,48,59,59,13,13,29,29,56,56,29,29,35,35,42,42,41,41,58,58,22,22,38,38,13,13,18,18,35,35,1,1,3,3,31,31,51,51,39,39,63,63,38,38,9,9,25,25,20,20,8,8,29,29,21,21,17,17,3,3,52,52,62,62,57,57,39,39,1,1,41,41,36,36,46,46,48,48,46,46,33,33,56,56,52,52,16,16,53,53,43,43,45,45,13,13,60,60,58,58,31,31,36,36,37,37,57,57,3,3,1,1,19,19,47,47,38,38,23,23,37,37,2,2,1,1,28,28,38,38,45,45,15,15,15,15,9,9,48,48,40,40,44,44,30,30,2,2,31,31,8,8,14,14,38,38,10,10,26,26,26,26,63,63,2,2,16,16,26,26,55,55,6,6,20,20,30,30,55,55,9,9,28,28,9,9,22,22,45,45,52,52,52,52,55,55,44,44,55,55,14,14,32,32,3,3,25,25,45,45,24,24,38,38,1,1,47,47,54,54,52,52,34,34,16,16,47,47,10,10,37,37,59,59,11,11,44,44,24,24,7,7,50,50,6,6,58,58,63,63,45,45,44,44,9,9,24,24,8,8,59,59,38,38,20,20,12,12,21,21,53,53,37,37,19,19,12,12,3,3,46,46,2,2,54,54,46,46,28,28,41,41,36,36,53,53,5,5,0,0,27,27,34,34,51,51,32,32,36,36,52,52,32,32,58,58,44,44,17,17,26,26,18,18,1,1,4,4,6,6,57,57,2,2,18,18,9,9,57,57,3,3,54,54,40,40,17,17,63,63,50,50,3,3,29,29,11,11,42,42,41,41,48,48,42,42,46,46,38,38,0,0,2,2,5,5,45,45,18,18,57,57,11,11,18,18,38,38,44,44,6,6,47,47,32,32,43,43,34,34,6,6,34,34,32,32,55,55,41,41,48,48,48,48,22,22,62,62,49,49,57,57,32,32,19,19,18,18,60,60,59,59,22,22,4,4,52,52,22,22,39,39,58,58,18,18,60,60,15,15,29,29,28,28,49,49,22,22,15,15,36,36,56,56,24,24,40,40,62,62,37,37,23,23,43,43,19,19,24,24,32,32,11,11,16,16,59,59,41,41,44,44,18,18,1,1,0,0,11,11,16,16,18,18,13,13,28,28,56,56,22,22,6,6,54,54,24,24,54,54,63,63,31,31,43,43,13,13,62,62,60,60,16,16,37,37,60,60,26,26,53,53,51,51,14,14,60,60,21,21,10,10,29,29,54,54,5,5,57,57,18,18,51,51,25,25,34,34,14,14,9,9,54,54,15,15,46,46,17,17,14,14,39,39,46,46,17,17,52,52,2,2,31,31,51,51,7,7,44,44,33,33,24,24,42,42,22,22,4,4,7,7,48,48,20,20,5,5,26,26,4,4,41,41,51,51,62,62,61,61,55,55,16,16,13,13,62,62,11,11,45,45,25,25,38,38,47,47,27,27,50,50,23,23,52,52,1,1,6,6,50,50,4,4,4,4,10,10,41,41,49,49,25,25,45,45,48,48,15,15,38,38,44,44,29,29,22,22,40,40,51,51,58,58,29,29,19,19,50,50,56,56,4,4,27,27,52,52,38,38,52,52,35,35,0,0,5,5,10,10,4,4,57,57,62,62,19,19,2,2,4,4,8,8,62,62,32,32,39,39,57,57,35,35,20,20,2,2,9,9,5,5,21,21,60,60,39,39,28,28,1,1,1,1,28,28,30,30,61,61,48,48,53,53,21,21,14,14,28,28,63,63,14,14,36,36,17,17,59,59,61,61,5,5,38,38,56,56,13,13,56,56,24,24,58,58,60,60,57,57,52,52,48,48,5,5,63,63,61,61,29,29,16,16,21,21,17,17,16,16,16,16,63,63,55,55,57,57,13,13,7,7,29,29,12,12,21,21,41,41,31,31,11,11,62,62,12,12,29,29,27,27,24,24,43,43,56,56,10,10,18,18,20,20,14,14,22,22,58,58,24,24,42,42,4,4,43,43,55,55,32,32,22,22,51,51,53,53,40,40,59,59,2,2,6,6,58,58,36,36,23,23,3,3,54,54,59,59,47,47,53,53,18,18,62,62,57,57,49,49,53,53,5,5,33,33,17,17,51,51,13,13,9,9,8,8,0,0,14,14,54,54,6,6,1,1,44,44,40,40,3,3,25,25,38,38,42,42,41,41,18,18,36,36,49,49,26,26,42,42,19,19,47,47,56,56,58,58,29,29,36,36,16,16,34,34,3,3,15,15,0,0,43,43,29,29,9,9,25,25,30,30,60,60,43,43,0,0,49,49,45,45,38,38,49,49,9,9,7,7,39,39,30,30,56,56,61,61,42,42,40,40,37,37,7,7,50,50,37,37,42,42,42,42,40,40,6,6,31,31,57,57,38,38,25,25,39,39,47,47,21,21,31,31,20,20,63,63,33,33,62,62,59,59,8,8,5,5,38,38,29,29,28,28,33,33,32,32,46,46,30,30,52,52,38,38,48,48,9,9,11,11,26,26,41,41,9,9,42,42,1,1,10,10,28,28,39,39,5,5,45,45,26,26,60,60,29,29,11,11,21,21,42,42,19,19,30,30,4,4,34,34,61,61,41,41,44,44,26,26,40,40,48,48,56,56,48,48,14,14,38,38,51,51,33,33,56,56,51,51,3,3,19,19,0,0,37,37,47,47,23,23,9,9,60,60,22,22,40,40,30,30,50,50,9,9,17,17,5,5,55,55,53,53,57,57,58,58,20,20,42,42,41,41,60,60,13,13,0,0,26,26,26,26,32,32,46,46,33,33,59,59,45,45,35,35,33,33,42,42,0,0,7,7,0,0,19,19,11,11,16,16,47,47,0,0,9,9,3,3,19,19,53,53,46,46,9,9,56,56,52,52,25,25,29,29,45,45,40,40,0,0,45,45,57,57,57,57,56,56,34,34,48,48,19,19,48,48,43,43,33,33,46,46,49,49,10,10,20,20,31,31,5,5,13,13,13,13,13,13,12,12,49,49,35,35,38,38,37,37,54,54,28,28,24,24,52,52,39,39,45,45,53,53,10,10,29,29,16,16,46,46,26,26,18,18,16,16,1,1,63,63,50,50,5,5,13,13,33,33,24,24,24,24,40,40,57,57,49,49,33,33,53,53,26,26,34,34,25,25,35,35,8,8,41,41,5,5,16,16,2,2,48,48,1,1,48,48,38,38,24,24,28,28,57,57,12,12,55,55,39,39,51,51,48,48,34,34,31,31,49,49,49,49,38,38,34,34,47,47,32,32,49,49,35,35,45,45,18,18,25,25,29,29,48,48,5,5,58,58,31,31,43,43,43,43,2,2,49,49,33,33,40,40,49,49,14,14,45,45,51,51,37,37,1,1,27,27,1,1,18,18,8,8,40,40,22,22,18,18,19,19,46,46,37,37,28,28,6,6,39,39,4,4,14,14,44,44,3,3,14,14,8,8,23,23,10,10,37,37,44,44,6,6,27,27,55,55,31,31,40,40,18,18,17,17,49,49,42,42,35,35,39,39,7,7,60,60,25,25,26,26,10,10,43,43,48,48,57,57,18,18,1,1,54,54,53,53,4,4,24,24,14,14,5,5,60,60,2,2,18,18,39,39,39,39,38,38,2,2,19,19,52,52,0,0,26,26,24,24,42,42,1,1,62,62,51,51,27,27,19,19,42,42,19,19,19,19,19,19,6,6,31,31,22,22,5,5,5,5,2,2,44,44,13,13,24,24,2,2,37,37,21,21,41,41,0,0,52,52,10,10,61,61,34,34,1,1,36,36,29,29,5,5,62,62,40,40,13,13,3,3,46,46,3,3,61,61,51,51,23,23,42,42,0,0,0,0,29,29,35,35,20,20,62,62,45,45,37,37,22,22,59,59,59,59,36,36,44,44,3,3,8,8,50,50,6,6,39,39,24,24,6,6,43,43,53,53,63,63,39,39,23,23,61,61,59,59,21,21,43,43,4,4,40,40,5,5,43,43,10,10,3,3,53,53,60,60,8,8,50,50,36,36,20,20,32,32,3,3,62,62,36,36,51,51,14,14,42,42,29,29,10,10,43,43,26,26,13,13,15,15,37,37,10,10,40,40,62,62,14,14,20,20,62,62,14,14,14,14,63,63,54,54,10,10,45,45,61,61,30,30,62,62,4,4,29,29,14,14,23,23,44,44,24,24,9,9,17,17,50,50,27,27,17,17,57,57,30,30,52,52,35,35,43,43,27,27,41,41,46,46,59,59,20,20,43,43,21,21,27,27,40,40,10,10,33,33,4,4,24,24,42,42,42,42,33,33,13,13,0,0,29,29,63,63,0,0,60,60,40,40,42,42,3,3,7,7,43,43,60,60,28,28,62,62,4,4,36,36,61,61,33,33,26,26,63,63,44,44,60,60,50,50,13,13,35,35,1,1,43,43,16,16,26,26,9,9,46,46,37,37,20,20,12,12,20,20,23,23,29,29,15,15,32,32,7,7,57,57,54,54,41,41,53,53,41,41,57,57,41,41,62,62,49,49,8,8,21,21,8,8,23,23,44,44,24,24,56,56,56,56,58,58,13,13,44,44,14,14,50,50,40,40,37,37,19,19,60,60,20,20,0,0,12,12,54,54,10,10,56,56,0,0,11,11,34,34,7,7,31,31,49,49,25,25,40,40,36,36,2,2,16,16,39,39,59,59,39,39,13,13,1,1,29,29,22,22,58,58,47,47,57,57,29,29,2,2,16,16,4,4,35,35,26,26,49,49,60,60,38,38,9,9,38,38,37,37,47,47,1,1,41,41,21,21,51,51,7,7,0,0,51,51,40,40,11,11,6,6,33,33,31,31,54,54,25,25,47,47,8,8,8,8,1,1,52,52,61,61,1,1,27,27,9,9,20,20,45,45,9,9,31,31,20,20,36,36,19,19,32,32,58,58,56,56,19,19,39,39,41,41,34,34,45,45,20,20,13,13,21,21,19,19,53,53,17,17,48,48,2,2,55,55,32,32,23,23,58,58,6,6,32,32,13,13,38,38,4,4,1,1,42,42,5,5,27,27,27,27,17,17,55,55,26,26,4,4,62,62,9,9,58,58,3,3,19,19,38,38,57,57,56,56,12,12,24,24,50,50,13,13,8,8,12,12,29,29,5,5,27,27,0,0,19,19,14,14,45,45,32,32,4,4,45,45,30,30,5,5,24,24,56,56,22,22,53,53,45,45,15,15,34,34,11,11,62,62,2,2,1,1,19,19,8,8,38,38,7,7,50,50,49,49,38,38,23,23,6,6,29,29,31,31,29,29,20,20,40,40,28,28,38,38,26,26,18,18,28,28,56,56,45,45,24,24,3,3,50,50,24,24,39,39,48,48,5,5,30,30,1,1,33,33,29,29,58,58,3,3,32,32,13,13,49,49,53,53,40,40,37,37,20,20,13,13,24,24,32,32,51,51,42,42,57,57,38,38,42,42,30,30,23,23,28,28,17,17,42,42,25,25,24,24,45,45,1,1,7,7,1,1,36,36,32,32,28,28,33,33,2,2,62,62,48,48,63,63,40,40,38,38,62,62,5,5,6,6,38,38,17,17,54,54,53,53,60,60,55,55,52,52,58,58,7,7,17,17,22,22,48,48,43,43,27,27,19,19,45,45,33,33,23,23,4,4,23,23,1,1,19,19,56,56,3,3,6,6,57,57,52,52,40,40,6,6,45,45,33,33,7,7,0,0,5,5,61,61,36,36,44,44,54,54,3,3,26,26,8,8,33,33,11,11,46,46,39,39,14,14,11,11,10,10,33,33,39,39,23,23,50,50,39,39,13,13,6,6,14,14,52,52,34,34,9,9,1,1,3,3,18,18,48,48,59,59,29,29,37,37,20,20,48,48,2,2,15,15,50,50,29,29,18,18,41,41,32,32,28,28,2,2,47,47,21,21,35,35,41,41,14,14,18,18,55,55,18,18,44,44,46,46,58,58,40,40,21,21,60,60,14,14,39,39,27,27,7,7,29,29,48,48,4,4,20,20,17,17,17,17,33,33,24,24,6,6,26,26,5,5,20,20,0,0,54,54,16,16,33,33,62,62,33,33,6,6,5,5,57,57,16,16,38,38,16,16,41,41,44,44,14,14,4,4,32,32,41,41,33,33,57,57,63,63,56,56,47,47,16,16,2,2,24,24,51,51,20,20,23,23,33,33,10,10,44,44,1,1,37,37,12,12,54,54,14,14,21,21,4,4,8,8,3,3,10,10,33,33,50,50,13,13,1,1,41,41,15,15,48,48,59,59,52,52,31,31,48,48,28,28,18,18,57,57,56,56,14,14,1,1,12,12,40,40,41,41,8,8,59,59,5,5,7,7,55,55,15,15,27,27,24,24,30,30,28,28,13,13,56,56,0,0,49,49,29,29,35,35,37,37,53,53,62,62,27,27,61,61,4,4,21,21,26,26,40,40,9,9,18,18,42,42,22,22,3,3,45,45,40,40,21,21,16,16,25,25,50,50,56,56,9,9,18,18,62,62,56,56,21,21,20,20,24,24,10,10,37,37,49,49,29,29,28,28,47,47,32,32,54,54,25,25,31,31,33,33,5,5,20,20,40,40,13,13,25,25,14,14,53,53,52,52,23,23,41,41,36,36,41,41,61,61,49,49,62,62,16,16,18,18,5,5,61,61,6,6,7,7,6,6,58,58,13,13,35,35,43,43,26,26,23,23,12,12,47,47,61,61,43,43,47,47,61,61,31,31,62,62,19,19,49,49,20,20,60,60,22,22,49,49,8,8,9,9,25,25,13,13,31,31,27,27,52,52,47,47,19,19,52,52,39,39,31,31,49,49,62,62,12,12,22,22,42,42,56,56,6,6,11,11,22,22,0,0,56,56,19,19,15,15,49,49,62,62,61,61,24,24,41,41,55,55,59,59,12,12,28,28,36,36,33,33,29,29,36,36,1,1,13,13,50,50,33,33,42,42,14,14,24,24,17,17,20,20,58,58,11,11,38,38,11,11,54,54,24,24,8,8,16,16,14,14,55,55,42,42,7,7,16,16,9,9,59,59,1,1,39,39,25,25,49,49,20,20,58,58,60,60,46,46,23,23,0,0,6,6,4,4,8,8,58,58,39,39,3,3,36,36,41,41,2,2,7,7,28,28,33,33,8,8,42,42,29,29,26,26,50,50,7,7,33,33,0,0,63,63,33,33,10,10,31,31,50,50,22,22,16,16,7,7,9,9,63,63,61,61,2,2,19,19,63,63,14,14,50,50,47,47,1,1,1,1,5,5,15,15,60,60,60,60,0,0,47,47,34,34,57,57,40,40,0,0,33,33,53,53,14,14,53,53,38,38,28,28,40,40,57,57,61,61,61,61,3,3,40,40,33,33,13,13,15,15,16,16,40,40,18,18,48,48,49,49,8,8,44,44,12,12,54,54,32,32,38,38,28,28,41,41,1,1,44,44,31,31,31,31,63,63,14,14,41,41,20,20,50,50,45,45,1,1,10,10,2,2,55,55,2,2,25,25,59,59,4,4,40,40,26,26,63,63,26,26,53,53,6,6,42,42,59,59,32,32,3,3,58,58,54,54,21,21,48,48,31,31,10,10,42,42,19,19,25,25,18,18,39,39,54,54,48,48,62,62,43,43,49,49,44,44,19,19,8,8,11,11,38,38,50,50,48,48,6,6,32,32,2,2,63,63,32,32,2,2,52,52,54,54,45,45,49,49,46,46,24,24,60,60,54,54,55,55,8,8,9,9,37,37,46,46,54,54,51,51,31,31,61,61,13,13,42,42,58,58,53,53,14,14,18,18,6,6,31,31,61,61,2,2,60,60,2,2,48,48,52,52,17,17,6,6,7,7,37,37,12,12,9,9,51,51,39,39,1,1,1,1,30,30,2,2,5,5,18,18,37,37,34,34,11,11,27,27,42,42,37,37,39,39,51,51,35,35,7,7,23,23,41,41,33,33,4,4,5,5,40,40,1,1,11,11,4,4,1,1,61,61,48,48,25,25,54,54,28,28,51,51,34,34,8,8,54,54,59,59,36,36,51,51,22,22,56,56,60,60,47,47,58,58,12,12,12,12,21,21,11,11,1,1,62,62,56,56,54,54,43,43,24,24,1,1,46,46,49,49,48,48,16,16,10,10,39,39,48,48,37,37,14,14,23,23,14,14,40,40,12,12,55,55,27,27,56,56,48,48,54,54,54,54,8,8,15,15,43,43,28,28,36,36,48,48,11,11,42,42,13,13,27,27,3,3,49,49,5,5,46,46,35,35,2,2,52,52,19,19,49,49,44,44,12,12,32,32,55,55,17,17,51,51,11,11,5,5,12,12,58,58,20,20,25,25,9,9,50,50,37,37,39,39,16,16,31,31,59,59,43,43,32,32,10,10,34,34,13,13,33,33,61,61,40,40,49,49,13,13,58,58,16,16,31,31,47,47,13,13,44,44,43,43,19,19,40,40,27,27,43,43,52,52,2,2,14,14,7,7,61,61,43,43,40,40,3,3,50,50,28,28,17,17,28,28,42,42,48,48,11,11,23,23,13,13,26,26,34,34,43,43,11,11,14,14,5,5,57,57,17,17,43,43,44,44,50,50,58,58,55,55,62,62,5,5,58,58,34,34,4,4,5,5,16,16,8,8,41,41,37,37,11,11,26,26,12,12,57,57,46,46,52,52,18,18,43,43,19,19,49,49,10,10,48,48,5,5,28,28,3,3,58,58,39,39,52,52,32,32,54,54,22,22,23,23,16,16,59,59,32,32,49,49,19,19,26,26,46,46,52,52,56,56,54,54,9,9,22,22,13,13,24,24,10,10,54,54,49,49,8,8,37,37,33,33,54,54,44,44,59,59,62,62,0,0,31,31,0,0,39,39,21,21,8,8,25,25,3,3,19,19,24,24,19,19,34,34,17,17,6,6,47,47,2,2,18,18,49,49,55,55,9,9,52,52,26,26,31,31,20,20,25,25,47,47,34,34,15,15,26,26,8,8,28,28,31,31,37,37,19,19,45,45,55,55,62,62,25,25,27,27,25,25,51,51,50,50,41,41,2,2,41,41,55,55,0,0,50,50,34,34,40,40,17,17,40,40,12,12,42,42,10,10,21,21,11,11,15,15,23,23,2,2,40,40,63,63,57,57,57,57,30,30,62,62,10,10,26,26,47,47,6,6,40,40,48,48,31,31,60,60,17,17,34,34,61,61,7,7,41,41,50,50,42,42,63,63,28,28,14,14,44,44,9,9,19,19,27,27,34,34,56,56,22,22,22,22,37,37,52,52,10,10,18,18,27,27,9,9,48,48,2,2,19,19,16,16,21,21,61,61,9,9,63,63,44,44,15,15,16,16,19,19,40,40,22,22,0,0,56,56,27,27,25,25,39,39,5,5,29,29,14,14,36,36,31,31,4,4,60,60,29,29,34,34,28,28,62,62,38,38,40,40,22,22,1,1,12,12,39,39,14,14,22,22,49,49,19,19,22,22,24,24,34,34,47,47,31,31,62,62,9,9,63,63,25,25,33,33,30,30,17,17,33,33,35,35,18,18,37,37,9,9,35,35,42,42,37,37,52,52,10,10,55,55,28,28,16,16,11,11,53,53,1,1,20,20,5,5,15,15,18,18,43,43,9,9,33,33,56,56,59,59,31,31,31,31,3,3,55,55,26,26,40,40,37,37,0,0,16,16,33,33,24,24,29,29,39,39,15,15,7,7,56,56,36,36,28,28,29,29,35,35,54,54,40,40,36,36,3,3,32,32,49,49,35,35,48,48,10,10,0,0,61,61,51,51,3,3,60,60,40,40,13,13,56,56,18,18,1,1,48,48,48,48,45,45,13,13,32,32,39,39,18,18,51,51,14,14,31,31,57,57,32,32,35,35,1,1,50,50,5,5,1,1,52,52,45,45,32,32,34,34,39,39,48,48,57,57,44,44,30,30,60,60,21,21,35,35,39,39,63,63,42,42,15,15,25,25,49,49,39,39,7,7,50,50,11,11,54,54,48,48,53,53,39,39,30,30,34,34,58,58,38,38,32,32,59,59,32,32,35,35,21,21,62,62,41,41,33,33,39,39,48,48,21,21,31,31,50,50,25,25,11,11,56,56,40,40,19,19,12,12,34,34,17,17,14,14,49,49,20,20,10,10,27,27,5,5,20,20,26,26,45,45,51,51,20,20,27,27,21,21,20,20,29,29,46,46,0,0,18,18,22,22,16,16,5,5,27,27,5,5,0,0,29,29,7,7,19,19,20,20,12,12,3,3,39,39,11,11,17,17,54,54,48,48,17,17,21,21,21,21,18,18,40,40,47,47,4,4,43,43,14,14,29,29,33,33,1,1,61,61,35,35,47,47,17,17,33,33,19,19,10,10,3,3,8,8,13,13,11,11,51,51,15,15,40,40,54,54,3,3,36,36,40,40,30,30,4,4,28,28,53,53,57,57,42,42,23,23,43,43,40,40,2,2,17,17,25,25,39,39,62,62,13,13,12,12,31,31,35,35,62,62,26,26,43,43,60,60,52,52,2,2,54,54,60,60,27,27,56,56,45,45,63,63,8,8,8,8,38,38,44,44,35,35,37,37,9,9,14,14,23,23,40,40,56,56,39,39,39,39,18,18,21,21,22,22,57,57,53,53,13,13,54,54,31,31,23,23,47,47,15,15,20,20,32,32,14,14,23,23,57,57,21,21,28,28,40,40,61,61,42,42,17,17,25,25,45,45,0,0,36,36,8,8,63,63,31,31,30,30,3,3,16,16,63,63,21,21,19,19,52,52,31,31,35,35,23,23,0,0,27,27,10,10,13,13,42,42,41,41,5,5,11,11,57,57,32,32,30,30,46,46,11,11,35,35,7,7,1,1,3,3,47,47,48,48,14,14,30,30,41,41,35,35,44,44,53,53,0,0,45,45,3,3,29,29,19,19,28,28,41,41,22,22,41,41,22,22,27,27,36,36,44,44,0,0,48,48,63,63,11,11,24,24,18,18,16,16,57,57,56,56,15,15,16,16,17,17,42,42,31,31,24,24,48,48,60,60,31,31,13,13,0,0,62,62,55,55,20,20,28,28,26,26,10,10,44,44,40,40,61,61,60,60,13,13,11,11,17,17,42,42,44,44,34,34,43,43,47,47,26,26,18,18,4,4,14,14,56,56,5,5,3,3,4,4,24,24,49,49,21,21,58,58,47,47,34,34,32,32,14,14,49,49,17,17,40,40,56,56,52,52,8,8,58,58,26,26,61,61,4,4,38,38,19,19,6,6,10,10,52,52,9,9,51,51,43,43,3,3,53,53,34,34,31,31,37,37,18,18,6,6,34,34,41,41,20,20,0,0,12,12,10,10,42,42,48,48,39,39,10,10,33,33,48,48,8,8,31,31,9,9,57,57,5,5,40,40,18,18,57,57,0,0,32,32,25,25,63,63,54,54,2,2,48,48,21,21,51,51,14,14,24,24,6,6,29,29,48,48,9,9,22,22,42,42,42,42,50,50,18,18,4,4,32,32,20,20,5,5,55,55,36,36,10,10,0,0,22,22,54,54,39,39,57,57,63,63,11,11,4,4,48,48,18,18,8,8,8,8,34,34,33,33,9,9,23,23,61,61,48,48,26,26,15,15,1,1,49,49,30,30,54,54,20,20,3,3,20,20,0,0,18,18,16,16,32,32,24,24,45,45,32,32,28,28,14,14,10,10,13,13,20,20,34,34,43,43,43,43,2,2,26,26,5,5,20,20,44,44,55,55,6,6,32,32,50,50,16,16,4,4,19,19,28,28,24,24,1,1,51,51,44,44,12,12,49,49,57,57,57,57,24,24,38,38,57,57,47,47,61,61,61,61,49,49,2,2,48,48,40,40,25,25,0,0,39,39,13,13,27,27,43,43,50,50,5,5,51,51,31,31,32,32,53,53,5,5,53,53,10,10,11,11,42,42,9,9,10,10,32,32,27,27,27,27,29,29,42,42,13,13,27,27,63,63,2,2,46,46,48,48,41,41,61,61,61,61,40,40,0,0,1,1,16,16,19,19,15,15,51,51,38,38,38,38,6,6,56,56,11,11,29,29,63,63,1,1,31,31,60,60,11,11,43,43,12,12,42,42,50,50,50,50,20,20,17,17,28,28,59,59,20,20,12,12,45,45,6,6,61,61,25,25,27,27,17,17,8,8,14,14,63,63,27,27,25,25,56,56,35,35,45,45,17,17,10,10,3,3,48,48,59,59,61,61,48,48,1,1,26,26,8,8,56,56,22,22,41,41,39,39,37,37,10,10,21,21,41,41,46,46,49,49,36,36,17,17,7,7,7,7,58,58,32,32,58,58,62,62,34,34,31,31,35,35,48,48,22,22,0,0,60,60,14,14,46,46,23,23,8,8,55,55,63,63,26,26,42,42,44,44,53,53,24,24,36,36,54,54,54,54,16,16,5,5,46,46,47,47,8,8,1,1,23,23,58,58,59,59,34,34,52,52,52,52,14,14,49,49,47,47,1,1,15,15,48,48,41,41,57,57,14,14,5,5,30,30,16,16,54,54,46,46,12,12,9,9,52,52,10,10,32,32,53,53,50,50,54,54,48,48,55,55,41,41,32,32,42,42,1,1,20,20,56,56,34,34,32,32,1,1,52,52,61,61,12,12,29,29,32,32,19,19,25,25,12,12,9,9,1,1,43,43,8,8,52,52,2,2,27,27,48,48,28,28,8,8,18,18,16,16,49,49,54,54,57,57,45,45,39,39,46,46,20,20,29,29,37,37,2,2,61,61,35,35,26,26,49,49,27,27,1,1,33,33,21,21,9,9,19,19,62,62,4,4,0,0,53,53,1,1,33,33,36,36,58,58,24,24,12,12,35,35,48,48,40,40,13,13,37,37,13,13,8,8,45,45,38,38,20,20,12,12,16,16,31,31,28,28,25,25,49,49,19,19,37,37,32,32,14,14,49,49,49,49,18,18,40,40,2,2,15,15,11,11,55,55,47,47,6,6,38,38,7,7,11,11,31,31,58,58,36,36,51,51,16,16,63,63,6,6,14,14,56,56,49,49,50,50,7,7,10,10,6,6,56,56,31,31,45,45,3,3,20,20,55,55,23,23,34,34,30,30,38,38,4,4,35,35,15,15,28,28,13,13,36,36,11,11,7,7,3,3,37,37,42,42,4,4,30,30,15,15,47,47,38,38,50,50,25,25,31,31,44,44,15,15,42,42,16,16,15,15,24,24,14,14,11,11,25,25,20,20,20,20,41,41,30,30,20,20,28,28,23,23,34,34,36,36,2,2,4,4,25,25,9,9,25,25,3,3,59,59,44,44,31,31,56,56,13,13,3,3,45,45,57,57,4,4,20,20,8,8,0,0,1,1,44,44,32,32,13,13,18,18,48,48,51,51,32,32,25,25,57,57,16,16,37,37,48,48,55,55,21,21,17,17,53,53,13,13,61,61,11,11,1,1,13,13,7,7,5,5,30,30,11,11,12,12,1,1,21,21,16,16,0,0,0,0,1,1,25,25,5,5,51,51,7,7,2,2,54,54,8,8,26,26,59,59,0,0,46,46,56,56,2,2,51,51,0,0,2,2,5,5,3,3,24,24,9,9,12,12,2,2,16,16,53,53,63,63,4,4,30,30,27,27,62,62,46,46,33,33,11,11,42,42,59,59,4,4,10,10,24,24,12,12,52,52,30,30,2,2,39,39,22,22,41,41,32,32,57,57,63,63,11,11,48,48,42,42,8,8,38,38,40,40,35,35,35,35,46,46,32,32,17,17,4,4,25,25,50,50,28,28,27,27,25,25,56,56,18,18,5,5,57,57,15,15,26,26,12,12,53,53,9,9,62,62,11,11,59,59,58,58,60,60,60,60,63,63,1,1,30,30,30,30,46,46,4,4,22,22,28,28,42,42,15,15,15,15,4,4,37,37,45,45,9,9,5,5,37,37,61,61,61,61,15,15,10,10,36,36,19,19,16,16,9,9,14,14,50,50,19,19,56,56,8,8,44,44,54,54,61,61,25,25,14,14,31,31,40,40,9,9,29,29,17,17,37,37,28,28,61,61,6,6,55,55,8,8,24,24,57,57,45,45,6,6,17,17,51,51,44,44,17,17,28,28,40,40,10,10,21,21,8,8,33,33,30,30,25,25,17,17,17,17,10,10,21,21,53,53,44,44,32,32,36,36,46,46,7,7,41,41,24,24,35,35,15,15,59,59,44,44,40,40,21,21,33,33,26,26,40,40,6,6,49,49,45,45,3,3,21,21,4,4,63,63,17,17,6,6,29,29,19,19,38,38,34,34,16,16,40,40,49,49,15,15,9,9,53,53,61,61,18,18,44,44,35,35,19,19,14,14,2,2,46,46,4,4,49,49,43,43,0,0,40,40,22,22,39,39,39,39,14,14,49,49,7,7,38,38,29,29,8,8,34,34,61,61,63,63,60,60,2,2,13,13,42,42,53,53,47,47,43,43,43,43,37,37,62,62,37,37,18,18,18,18,25,25,13,13,3,3,33,33,63,63,0,0,47,47,36,36,47,47,62,62,44,44,48,48,61,61,32,32,30,30,16,16,52,52,0,0,9,9,8,8,49,49,33,33,56,56,6,6,28,28,5,5,51,51,27,27,50,50,23,23,5,5,56,56,48,48,11,11,41,41,15,15,55,55,3,3,37,37,27,27,36,36,47,47,31,31,37,37,13,13,2,2,36,36,26,26,1,1,52,52,6,6,7,7,38,38,23,23,43,43,53,53,63,63,38,38,42,42,56,56,32,32,26,26,36,36,7,7,44,44,25,25,3,3,15,15,45,45,7,7,40,40,43,43,13,13,62,62,42,42,43,43,36,36,5,5,48,48,9,9,52,52,32,32,10,10,8,8,25,25,41,41,41,41,32,32,51,51,59,59,32,32,24,24,1,1,40,40,57,57,47,47,38,38,42,42,20,20,42,42,7,7,29,29,15,15,37,37,58,58,3,3,42,42,22,22,34,34,56,56,25,25,1,1,46,46,62,62,43,43,33,33,30,30,43,43,60,60,59,59,54,54,51,51,26,26,23,23,56,56,48,48,11,11,58,58,38,38,32,32,12,12,19,19,18,18,53,53,41,41,63,63,13,13,60,60,27,27,50,50,29,29,16,16,48,48,16,16,62,62,44,44,50,50,36,36,54,54,62,62,62,62,50,50,15,15,36,36,26,26,11,11,47,47,35,35,55,55,36,36,50,50,45,45,6,6,20,20,54,54,43,43,41,41,18,18,53,53,14,14,47,47,22,22,9,9,10,10,53,53,53,53,57,57,11,11,61,61,62,62,22,22,25,25,17,17,26,26,43,43,13,13,51,51,54,54,35,35,41,41,53,53,46,46,18,18,32,32,17,17,20,20,39,39,60,60,35,35,3,3,35,35,5,5,43,43,59,59,11,11,59,59,27,27,38,38,14,14,33,33,38,38,45,45,11,11,43,43,32,32,59,59,24,24,38,38,42,42,6,6,33,33,44,44,1,1,35,35,25,25,41,41,30,30,52,52,4,4,24,24,11,11,0,0,57,57,30,30,31,31,24,24,42,42,19,19,3,3,7,7,36,36,18,18,63,63,2,2,39,39,49,49,16,16,33,33,0,0,20,20,48,48,40,40,41,41,5,5,32,32,14,14,36,36,16,16,48,48,36,36,40,40,57,57,45,45,41,41,48,48,7,7,45,45,41,41,22,22,28,28,53,53,33,33,62,62,8,8,48,48,39,39,62,62,48,48,58,58,1,1,56,56,19,19,53,53,57,57,34,34,43,43,33,33,9,9,15,15,44,44,58,58,29,29,48,48,15,15,18,18,35,35,2,2,13,13,10,10,27,27,54,54,0,0,46,46,45,45,38,38,29,29,49,49,26,26,56,56,4,4,45,45,57,57,10,10,37,37,30,30,28,28,6,6,26,26,44,44,8,8,44,44,57,57,59,59,22,22,35,35,11,11,37,37,14,14,8,8,55,55,29,29,44,44,8,8,56,56,58,58,30,30,61,61,51,51,28,28,4,4,10,10,49,49,0,0,46,46,36,36,4,4,34,34,49,49,13,13,33,33,15,15,60,60,54,54,27,27,1,1,12,12,32,32,0,0,24,24,47,47,8,8,56,56,10,10,36,36,12,12,54,54,30,30,44,44,5,5,14,14,35,35,41,41,26,26,24,24,19,19,56,56,28,28,41,41,5,5,40,40,40,40,28,28,14,14,1,1,15,15,47,47,8,8,57,57,9,9,39,39,37,37,48,48,54,54,58,58,27,27,56,56,9,9,0,0,33,33,8,8,34,34,36,36,59,59,36,36,31,31,33,33,8,8,15,15,27,27,28,28,14,14,16,16,11,11,20,20,36,36,40,40,2,2,62,62,1,1,8,8,18,18,14,14,56,56,18,18,17,17,40,40,48,48,44,44,27,27,0,0,30,30,7,7,28,28,45,45,13,13,7,7,0,0,30,30,24,24,36,36,15,15,38,38,6,6,5,5,32,32,13,13,18,18,63,63,49,49,36,36,36,36,16,16,2,2,4,4,26,26,27,27,11,11,63,63,1,1,44,44,20,20,8,8,39,39,11,11,56,56,19,19,20,20,16,16,8,8,48,48,39,39,51,51,50,50,18,18,49,49,39,39,40,40,4,4,32,32,2,2,52,52,8,8,57,57,34,34,60,60,37,37,36,36,1,1,32,32,33,33,40,40,44,44,58,58,14,14,55,55,54,54,52,52,5,5,53,53,17,17,29,29,60,60,29,29,32,32,37,37,40,40,18,18,11,11,44,44,13,13,32,32,60,60,22,22,1,1,47,47,38,38,48,48,8,8,47,47,40,40,36,36,50,50,48,48,44,44,56,56,31,31,47,47,38,38,19,19,17,17,17,17,5,5,41,41,52,52,15,15,48,48,24,24,29,29,4,4,59,59,52,52,53,53,35,35,22,22,23,23,38,38,17,17,32,32,26,26,32,32,63,63,57,57,60,60,7,7,23,23,3,3,40,40,43,43,50,50,42,42,48,48,59,59,51,51,40,40,15,15,26,26,2,2,33,33,24,24,32,32,2,2,3,3,12,12,23,23,12,12,27,27,39,39,5,5,22,22,37,37,19,19,7,7,51,51,31,31,0,0,45,45,11,11,14,14,62,62,39,39,53,53,24,24,34,34,5,5,58,58,10,10,33,33,18,18,59,59,34,34,34,34,42,42,12,12,52,52,41,41,30,30,27,27,14,14,37,37,4,4,33,33,8,8,5,5,25,25,2,2,24,24,25,25,58,58,15,15,25,25,48,48,8,8,32,32,43,43,49,49,39,39,18,18,6,6,20,20,29,29,48,48,61,61,55,55,5,5,40,40,6,6,54,54,39,39,24,24,50,50,31,31,52,52,8,8,23,23,1,1,19,19,53,53,3,3,44,44,24,24,57,57,37,37,60,60,0,0,9,9,20,20,12,12,63,63,59,59,35,35,52,52,7,7,10,10,8,8,23,23,37,37,33,33,9,9,60,60,35,35,44,44,45,45,54,54,5,5,59,59,23,23,21,21,53,53,41,41,5,5,51,51,2,2,24,24,50,50,41,41,52,52,49,49,5,5,23,23,38,38,60,60,27,27,49,49,32,32,49,49,2,2,15,15,44,44,27,27,2,2,8,8,46,46,24,24,18,18,5,5,50,50,56,56,56,56,51,51,36,36,63,63,19,19,29,29,35,35,16,16,52,52,53,53,62,62,24,24,55,55,49,49,37,37,60,60,54,54,47,47,44,44,36,36,7,7,59,59,34,34,54,54,2,2,31,31,16,16,2,2,0,0,12,12,1,1,28,28,23,23,56,56,32,32,19,19,30,30,41,41,13,13,34,34,37,37,63,63,47,47,33,33,40,40,61,61,22,22,4,4,7,7,44,44,57,57,52,52,30,30,40,40,19,19,7,7,21,21,29,29,45,45,63,63,43,43,45,45,7,7,39,39,1,1,1,1,15,15,18,18,7,7,40,40,5,5,3,3,19,19,27,27,26,26,61,61,40,40,38,38,50,50,49,49,16,16,42,42,62,62,5,5,45,45,54,54,47,47,39,39,29,29,8,8,23,23,4,4,12,12,6,6,16,16,21,21,27,27,25,25,37,37,47,47,17,17,12,12,22,22,3,3,62,62,5,5,48,48,45,45,31,31,45,45,60,60,9,9,51,51,21,21,36,36,19,19,29,29,1,1,0,0,7,7,40,40,61,61,2,2,26,26,11,11,0,0,53,53,39,39,27,27,26,26,35,35,33,33,3,3,8,8,22,22,2,2,55,55,62,62,26,26,36,36,2,2,6,6,25,25,15,15,48,48,44,44,28,28,10,10,25,25,45,45,19,19,24,24,51,51,4,4,52,52,2,2,42,42,37,37,2,2,33,33,6,6,60,60,8,8,34,34,19,19,50,50,27,27,22,22,1,1,38,38,33,33,51,51,21,21,56,56,38,38,19,19,13,13,29,29,6,6,45,45,34,34,5,5,3,3,17,17,51,51,2,2,7,7,53,53,16,16,20,20,19,19,44,44,55,55,44,44,36,36,34,34,36,36,47,47,45,45,33,33,22,22,36,36,60,60,39,39,55,55,6,6,41,41,10,10,17,17,7,7,51,51,60,60,52,52,56,56,32,32,27,27,27,27,48,48,56,56,27,27,28,28,21,21,38,38,13,13,42,42,42,42,52,52,25,25,9,9,20,20,17,17,59,59,58,58,19,19,19,19,7,7,32,32,22,22,52,52,20,20,7,7,28,28,29,29,21,21,20,20,57,57,24,24,50,50,13,13,33,33,13,13,56,56,19,19,0,0,23,23,11,11,39,39,46,46,17,17,36,36,8,8,27,27,43,43,6,6,18,18,54,54,52,52,15,15,9,9,19,19,55,55,45,45,30,30,17,17,31,31,29,29,33,33,16,16,2,2,17,17,16,16,49,49,55,55,7,7,1,1,43,43,6,6,11,11,8,8,13,13,12,12,10,10,32,32,14,14,34,34,2,2,45,45,18,18,12,12,21,21,12,12,59,59,10,10,4,4,25,25,43,43,41,41,58,58,40,40,4,4,28,28,37,37,1,1,53,53,29,29,0,0,24,24,26,26,26,26,42,42,62,62,33,33,20,20,0,0,6,6,8,8,0,0,1,1,28,28,29,29,11,11,30,30,16,16,49,49,3,3,22,22,28,28,11,11,0,0,7,7,4,4,34,34,19,19,1,1,23,23,17,17,22,22,26,26,1,1,39,39,43,43,60,60,43,43,59,59,56,56,62,62,0,0,40,40,55,55,25,25,12,12,2,2,46,46,2,2,6,6,57,57,58,58,35,35,20,20,33,33,63,63,18,18,31,31,0,0,49,49,24,24,7,7,41,41,51,51,47,47,53,53,35,35,6,6,26,26,10,10,42,42,54,54,61,61,0,0,47,47,3,3,14,14,58,58,57,57,17,17,52,52,27,27,6,6,10,10,41,41,18,18,52,52,24,24,35,35,12,12,50,50,42,42,20,20,51,51,44,44,19,19,8,8,24,24,0,0,46,46,60,60,23,23,5,5,4,4,11,11,20,20,38,38,37,37,44,44,16,16,41,41,54,54,4,4,62,62,37,37,20,20,51,51,24,24,24,24,62,62,20,20,2,2,7,7,40,40,11,11,9,9,52,52,37,37,0,0,36,36,35,35,42,42,29,29,37,37,5,5,3,3,16,16,36,36,43,43,9,9,62,62,8,8,9,9,50,50,0,0,13,13,27,27,39,39,3,3,48,48,16,16,7,7,12,12,21,21,42,42,33,33,17,17,25,25,39,39,24,24,44,44,41,41,35,35,59,59,4,4,48,48,43,43,56,56,31,31,53,53,23,23,47,47,60,60,20,20,30,30,54,54,7,7,39,39,56,56,26,26,50,50,8,8,51,51,57,57,46,46,56,56,13,13,35,35,15,15,60,60,35,35,29,29,40,40,63,63,28,28,40,40,37,37,62,62,27,27,39,39,51,51,24,24,5,5,15,15,56,56,29,29,14,14,59,59,11,11,44,44,7,7,49,49,46,46,60,60,53,53,34,34,12,12,15,15,44,44,36,36,42,42,36,36,45,45,5,5,12,12,54,54,25,25,40,40,23,23,37,37,42,42,50,50,50,50,32,32,4,4,28,28,8,8,11,11,58,58,19,19,36,36,27,27,40,40,3,3,35,35,25,25,4,4,16,16,42,42,12,12,49,49,11,11,53,53,62,62,48,48,9,9,30,30,39,39,43,43,47,47,56,56,48,48,12,12,12,12,19,19,20,20,6,6,24,24,23,23,17,17,34,34,63,63,23,23,9,9,34,34,49,49,49,49,5,5,23,23,38,38,1,1,59,59,37,37,43,43,56,56,23,23,52,52,36,36,37,37,27,27,18,18,48,48,23,23,52,52,52,52,26,26,60,60,54,54,32,32,35,35,48,48,27,27,2,2,28,28,42,42,46,46,12,12,1,1,8,8,54,54,63,63,52,52,50,50,34,34,1,1,45,45,18,18,38,38,26,26,1,1,56,56,35,35,3,3,42,42,13,13,36,36,61,61,10,10,57,57,42,42,13,13,10,10,15,15,39,39,48,48,24,24,33,33,10,10,39,39,10,10,44,44,7,7,3,3,49,49,13,13,55,55,26,26,41,41,34,34,22,22,16,16,55,55,45,45,32,32,9,9,35,35,58,58,45,45,45,45,23,23,51,51,3,3,52,52,7,7,44,44,49,49,59,59,44,44,20,20,22,22,11,11,5,5,43,43,26,26,26,26,43,43,34,34,39,39,14,14,7,7,38,38,28,28,21,21,29,29,48,48,48,48,63,63,34,34,60,60,61,61,33,33,39,39,7,7,2,2,44,44,57,57,53,53,60,60,1,1,53,53,57,57,11,11,56,56,9,9,25,25,15,15,26,26,29,29,2,2,25,25,9,9,58,58,48,48,11,11,2,2,52,52,53,53,36,36,21,21,4,4,34,34,7,7,29,29,18,18,55,55,37,37,28,28,44,44,38,38,31,31,21,21,1,1,36,36,7,7,30,30,61,61,51,51,41,41,7,7,39,39,39,39,36,36,13,13,46,46,9,9,32,32,18,18,6,6,9,9,48,48,40,40,57,57,55,55,35,35,42,42,20,20,29,29,23,23,16,16,9,9,20,20,53,53,50,50,52,52,7,7,58,58,1,1,21,21,53,53,31,31,31,31,58,58,27,27,5,5,3,3,54,54,52,52,25,25,16,16,34,34,59,59,33,33,7,7,40,40,25,25,49,49,23,23,33,33,2,2,59,59,8,8,24,24,55,55,39,39,41,41,27,27,33,33,1,1,34,34,5,5,25,25,13,13,19,19,47,47,56,56,0,0,21,21,19,19,47,47,42,42,62,62,22,22,39,39,62,62,1,1,14,14,14,14,12,12,43,43,17,17,45,45,3,3,24,24,4,4,27,27,35,35,34,34,25,25,22,22,53,53,60,60,2,2,54,54,51,51,17,17,58,58,42,42,25,25,3,3,7,7,53,53,26,26,44,44,24,24,30,30,42,42,10,10,35,35,18,18,10,10,12,12,48,48,24,24,47,47,8,8,13,13,25,25,38,38,51,51,6,6,61,61,8,8,53,53,6,6,60,60,15,15,12,12,9,9,59,59,45,45,47,47,13,13,36,36,16,16,43,43,60,60,16,16,20,20,24,24,62,62,25,25,58,58,45,45,54,54,9,9,51,51,43,43,38,38,18,18,37,37,24,24,29,29,53,53,22,22,18,18,26,26,5,5,57,57,46,46,5,5,23,23,4,4,12,12,46,46,11,11,9,9,27,27,54,54,63,63,62,62,8,8,39,39,21,21,33,33,37,37,2,2,15,15,4,4,40,40,14,14,33,33,15,15,56,56,12,12,42,42,59,59,59,59,54,54,47,47,28,28,30,30,16,16,34,34,10,10,23,23,27,27,6,6,0,0,0,0,12,12,36,36,42,42,12,12,41,41,47,47,14,14,55,55,29,29,55,55,60,60,63,63,32,32,27,27,25,25,52,52,15,15,52,52,27,27,8,8,56,56,42,42,30,30,51,51,28,28,45,45,46,46,23,23,7,7,34,34,3,3,50,50,16,16,45,45,8,8,5,5,50,50,26,26,56,56,47,47,37,37,19,19,6,6,54,54,19,19,21,21,9,9,35,35,50,50,8,8,9,9,1,1,18,18,4,4,43,43,37,37,24,24,21,21,56,56,28,28,37,37,52,52,54,54,32,32,2,2,8,8,46,46,57,57,9,9,21,21,35,35,19,19,35,35,12,12,13,13,36,36,35,35,20,20,15,15,54,54,11,11,19,19,53,53,39,39,47,47,22,22,3,3,25,25,28,28,11,11,1,1,12,12,62,62,47,47,24,24,44,44,37,37,44,44,56,56,58,58,5,5,48,48,16,16,15,15,21,21,60,60,7,7,18,18,49,49,62,62,60,60,12,12,53,53,43,43,4,4,63,63,29,29,23,23,63,63,35,35,26,26,36,36,36,36,49,49,25,25,15,15,48,48,5,5,60,60,18,18,30,30,31,31,30,30,7,7,48,48,11,11,29,29,4,4,62,62,27,27,26,26,19,19,63,63,40,40,5,5,50,50,13,13,24,24,55,55,8,8,38,38,39,39,37,37,19,19,57,57,34,34,12,12,11,11,25,25,18,18,27,27,6,6,54,54,24,24,9,9,56,56,6,6,60,60,52,52,35,35,19,19,44,44,26,26,46,46,42,42,20,20,55,55,60,60,28,28,15,15,13,13,30,30,50,50,1,1,25,25,39,39,47,47,50,50,18,18,56,56,56,56,44,44,44,44,60,60,11,11,46,46,24,24,10,10,6,6,30,30,37,37,17,17,19,19,20,20,22,22,7,7,3,3,8,8,35,35,8,8,32,32,3,3,6,6,28,28,37,37,47,47,41,41,50,50,14,14,40,40,50,50,14,14,24,24,5,5,32,32,32,32,6,6,10,10,0,0,48,48,19,19,42,42,42,42,58,58,36,36,12,12,42,42,12,12,27,27,19,19,46,46,49,49,1,1,24,24,49,49,32,32,26,26,3,3,3,3,37,37,41,41,28,28,40,40,51,51,35,35,25,25,55,55,37,37,36,36,28,28,3,3,22,22,16,16,56,56,61,61,46,46,56,56,52,52,0,0,33,33,55,55,47,47,55,55,16,16,28,28,62,62,34,34,22,22,22,22,21,21,27,27,40,40,12,12,33,33,43,43,45,45,26,26,58,58,25,25,2,2,49,49,17,17,21,21,19,19,19,19,60,60,8,8,16,16,18,18,42,42,45,45,11,11,24,24,16,16,40,40,16,16,37,37,34,34,36,36,29,29,9,9,2,2,31,31,62,62,4,4,41,41,3,3,3,3,57,57,48,48,28,28,8,8,16,16,31,31,34,34,18,18,41,41,54,54,46,46,32,32,19,19,6,6,54,54,18,18,2,2,42,42,20,20,14,14,63,63,28,28,24,24,33,33,52,52,23,23,3,3,11,11,59,59,36,36,19,19,44,44,34,34,13,13,59,59,4,4,6,6,9,9,54,54,15,15,25,25,63,63,12,12,29,29,28,28,28,28,42,42,1,1,56,56,52,52,32,32,3,3,10,10,21,21,27,27,60,60,47,47,43,43,30,30,7,7,41,41,31,31,24,24,60,60,28,28,24,24,8,8,18,18,54,54,3,3,29,29,33,33,46,46,27,27,20,20,49,49,56,56,23,23,2,2,55,55,24,24,58,58,50,50,46,46,54,54,2,2,16,16,36,36,8,8,7,7,49,49,60,60,20,20,59,59,12,12,63,63,23,23,16,16,2,2,9,9,27,27,13,13,55,55,21,21,3,3,8,8,59,59,46,46,25,25,34,34,23,23,57,57,13,13,58,58,5,5,57,57,60,60,36,36,1,1,63,63,20,20,50,50,5,5,12,12,11,11,40,40,13,13,39,39,54,54,26,26,43,43,51,51,8,8,9,9,42,42,58,58,13,13,55,55,7,7,23,23,44,44,40,40,36,36,32,32,21,21,26,26,12,12,56,56,57,57,18,18,22,22,21,21,30,30,40,40,3,3,36,36,50,50,6,6,31,31,18,18,20,20,5,5,47,47,24,24,19,19,19,19,56,56,60,60,40,40,45,45,40,40,59,59,6,6,34,34,59,59,48,48,1,1,5,5,22,22,35,35,59,59,53,53,20,20,35,35,41,41,56,56,63,63,38,38,3,3,59,59,7,7,2,2,56,56,31,31,58,58,53,53,16,16,34,34,28,28,2,2,43,43,24,24,16,16,51,51,22,22,16,16,6,6,58,58,31,31,57,57,26,26,30,30,23,23,19,19,42,42,11,11,44,44,57,57,3,3,26,26,42,42,18,18,16,16,38,38,40,40,58,58,26,26,3,3,39,39,40,40,63,63,29,29,23,23,43,43,53,53,2,2,9,9,5,5,55,55,7,7,12,12,7,7,2,2,0,0,49,49,53,53,61,61,26,26,12,12,4,4,24,24,58,58,3,3,23,23,34,34,38,38,40,40,48,48,11,11,46,46,0,0,50,50,37,37,22,22,0,0,34,34,18,18,54,54,59,59,13,13,37,37,43,43,45,45,41,41,29,29,38,38,10,10,47,47,20,20,25,25,61,61,42,42,8,8,27,27,41,41,52,52,45,45,38,38,28,28,9,9,16,16,30,30,60,60,27,27,18,18,0,0,42,42,58,58,18,18,40,40,14,14,15,15,55,55,23,23,25,25,16,16,11,11,54,54,34,34,53,53,24,24,33,33,43,43,20,20,28,28,29,29,32,32,8,8,61,61,20,20,58,58,61,61,10,10,3,3,19,19,63,63,32,32,60,60,7,7,35,35,2,2,57,57,26,26,18,18,30,30,46,46,1,1,57,57,6,6,49,49,19,19,9,9,2,2,32,32,49,49,13,13,15,15,36,36,49,49,38,38,62,62,2,2,34,34,4,4,35,35,25,25,41,41,27,27,50,50,34,34,18,18,42,42,4,4,52,52,46,46,1,1,13,13,53,53,16,16,38,38,59,59,27,27,56,56,52,52,37,37,0,0,58,58,4,4,60,60,58,58,59,59,53,53,48,48,38,38,21,21,9,9,27,27,28,28,25,25,13,13,59,59,22,22,41,41,32,32,11,11,14,14,54,54,33,33,32,32,6,6,15,15,41,41,34,34,42,42,46,46,18,18,10,10,50,50,0,0,59,59,53,53,40,40,38,38,32,32,35,35,43,43,33,33,2,2,25,25,9,9,53,53,61,61,15,15,63,63,11,11,13,13,24,24,20,20,21,21,54,54,0,0,6,6,14,14,45,45,13,13,35,35,4,4,53,53,57,57,17,17,19,19,47,47,9,9,31,31,47,47,8,8,2,2,19,19,53,53,26,26,46,46,57,57,60,60,51,51,32,32,39,39,19,19,61,61,1,1,4,4,49,49,7,7,17,17,17,17,6,6,24,24,23,23,40,40,22,22,35,35,30,30,48,48,33,33,42,42,25,25,6,6,34,34,29,29,23,23,36,36,9,9,39,39,14,14,18,18,20,20,62,62,48,48,47,47,13,13,56,56,2,2,45,45,10,10,44,44,36,36,46,46,21,21,35,35,23,23,47,47,9,9,14,14,43,43,62,62,5,5,3,3,46,46,56,56,19,19,34,34,45,45,34,34,39,39,35,35,56,56,6,6,17,17,39,39,19,19,41,41,15,15,50,50,18,18,7,7,24,24,6,6,46,46,14,14,51,51,48,48,61,61,32,32,51,51,44,44,55,55,3,3,2,2,44,44,42,42,32,32,8,8,24,24,50,50,30,30,36,36,25,25,7,7,22,22,24,24,30,30,56,56,4,4,33,33,49,49,59,59,27,27,35,35,27,27,46,46,54,54,24,24,8,8,23,23,47,47,63,63,49,49,39,39,42,42,35,35,24,24,45,45,53,53,40,40,7,7,49,49,11,11,46,46,26,26,5,5,13,13,23,23,43,43,58,58,35,35,19,19,1,1,24,24,33,33,31,31,35,35,7,7,57,57,27,27,49,49,62,62,13,13,43,43,29,29,49,49,10,10,22,22,25,25,24,24,13,13,8,8,16,16,11,11,0,0,11,11,12,12,42,42,11,11,17,17,7,7,59,59,26,26,16,16,3,3,35,35,23,23,25,25,9,9,25,25,63,63,37,37,42,42,10,10,32,32,15,15,4,4,0,0,28,28,43,43,27,27,12,12,20,20,56,56,7,7,38,38,33,33,8,8,24,24,3,3,60,60,28,28,26,26,25,25,46,46,48,48,62,62,19,19,58,58,61,61,51,51,9,9,56,56,28,28,8,8,32,32,47,47,36,36,60,60,36,36,21,21,10,10,14,14,10,10,50,50,24,24,10,10,52,52,51,51,44,44,55,55,44,44,18,18,22,22,14,14,29,29,58,58,25,25,17,17,53,53,36,36,6,6,55,55,16,16,8,8,33,33,4,4,33,33,6,6,61,61,14,14,29,29,27,27,6,6,40,40,24,24,1,1,62,62,15,15,30,30,24,24,7,7,40,40,47,47,14,14,62,62,51,51,43,43,35,35,20,20,7,7,42,42,51,51,17,17,47,47,3,3,45,45,31,31,41,41,36,36,8,8,26,26,27,27,51,51,61,61,63,63,13,13,8,8,38,38,38,38,45,45,14,14,6,6,3,3,39,39,8,8,7,7,58,58,56,56,39,39,4,4,54,54,38,38,43,43,23,23,34,34,62,62,14,14,8,8,5,5,62,62,32,32,45,45,8,8,22,22,25,25,32,32,53,53,11,11,11,11,61,61,51,51,16,16,5,5,30,30,35,35,31,31,17,17,30,30,60,60,21,21,6,6,22,22,52,52,43,43,48,48,11,11,44,44,8,8,20,20,38,38,56,56,1,1,36,36,42,42,1,1,60,60,18,18,39,39,63,63,12,12,23,23,31,31,49,49,63,63,11,11,31,31,56,56,12,12,55,55,18,18,40,40,34,34,30,30,40,40,49,49,27,27,35,35,33,33,46,46,24,24,62,62,15,15,24,24,46,46,21,21,10,10,63,63,8,8,5,5,30,30,2,2,11,11,8,8,31,31,15,15,49,49,14,14,38,38,21,21,33,33,63,63,38,38,10,10,26,26,53,53,25,25,57,57,32,32,29,29,63,63,38,38,56,56,13,13,35,35,48,48,29,29,23,23,23,23,24,24,21,21,40,40,53,53,28,28,9,9,61,61,33,33,56,56,55,55,16,16,37,37,16,16,33,33,46,46,23,23,51,51,61,61,14,14,6,6,27,27,30,30,12,12,50,50,45,45,1,1,25,25,21,21,44,44,8,8,14,14,60,60,1,1,23,23,28,28,16,16,12,12,47,47,48,48,1,1,41,41,47,47,3,3,5,5,38,38,61,61,16,16,0,0,12,12,20,20,32,32,46,46,4,4,4,4,48,48,6,6,11,11,25,25,5,5,25,25,37,37,12,12,13,13,48,48,62,62,46,46,38,38,44,44,22,22,15,15,22,22,40,40,44,44,14,14,51,51,8,8,17,17,9,9,27,27,60,60,29,29,59,59,43,43,61,61,44,44,60,60,59,59,39,39,9,9,0,0,39,39,42,42,0,0,25,25,45,45,21,21,47,47,51,51,11,11,18,18,63,63,14,14,10,10,7,7,28,28,30,30,4,4,5,5,1,1,28,28,7,7,30,30,29,29,20,20,54,54,52,52,58,58,39,39,14,14,1,1,35,35,1,1,33,33,55,55,29,29,41,41,5,5,13,13,45,45,27,27,49,49,26,26,27,27,43,43,11,11,53,53,50,50,3,3,52,52,46,46,23,23,20,20,44,44,60,60,35,35,6,6,1,1,60,60,7,7,1,1,9,9,23,23,23,23,63,63,57,57,55,55,44,44,5,5,10,10,57,57,12,12,52,52,35,35,43,43,33,33,24,24,19,19,54,54,28,28,0,0,50,50,51,51,1,1,3,3,7,7,1,1,48,48,26,26,45,45,28,28,20,20,59,59,55,55,40,40,30,30,36,36,20,20,17,17,32,32,17,17,14,14,4,4,10,10,9,9,54,54,27,27,15,15,8,8,38,38,17,17,33,33,55,55,40,40,32,32,7,7,29,29,16,16,19,19,53,53,0,0,11,11,44,44,6,6,10,10,32,32,44,44,5,5,8,8,60,60,33,33,11,11,19,19,52,52,62,62,62,62,54,54,31,31,62,62,38,38,2,2,6,6,40,40,19,19,28,28,15,15,46,46,10,10,54,54,61,61,8,8,57,57,4,4,22,22,25,25,7,7,24,24,12,12,23,23,61,61,57,57,26,26,31,31,4,4,22,22,4,4,32,32,48,48,36,36,25,25,23,23,63,63,40,40,8,8,17,17,16,16,46,46,47,47,52,52,36,36,0,0,59,59,0,0,31,31,10,10,35,35,9,9,1,1,24,24,43,43,38,38,55,55,17,17,9,9,7,7,5,5,44,44,13,13,63,63,22,22,8,8,29,29,55,55,21,21,29,29,30,30,58,58,35,35,20,20,35,35,19,19,63,63,39,39,31,31,0,0,26,26,36,36,55,55,28,28,35,35,16,16,1,1,2,2,58,58,26,26,51,51,14,14,0,0,35,35,43,43,8,8,21,21,44,44,22,22,38,38,49,49,34,34,61,61,49,49,51,51,6,6,4,4,34,34,37,37,5,5,19,19,3,3,19,19,42,42,25,25,41,41,31,31,45,45,3,3,17,17,41,41,43,43,23,23,1,1,29,29,52,52,46,46,15,15,1,1,6,6,58,58,27,27,21,21,1,1,26,26,25,25,57,57,46,46,42,42,55,55,54,54,13,13,37,37,18,18,10,10,39,39,53,53,20,20,54,54,24,24,8,8,4,4,16,16,54,54,55,55,37,37,28,28,31,31,13,13,48,48,42,42,61,61,45,45,29,29,26,26,60,60,26,26,34,34,29,29,5,5,31,31,62,62,61,61,45,45,54,54,18,18,17,17,26,26,57,57,10,10,52,52,34,34,25,25,27,27,36,36,6,6,34,34,43,43,13,13,8,8,9,9,10,10,2,2,39,39,8,8,55,55,17,17,29,29,28,28,30,30,25,25,54,54,21,21,24,24,24,24,12,12,52,52,52,52,31,31,9,9,53,53,52,52,53,53,14,14,45,45,29,29,26,26,2,2,12,12,8,8,15,15,32,32,16,16,10,10,51,51,13,13,33,33,30,30,36,36,7,7,8,8,30,30,52,52,5,5,3,3,51,51,12,12,31,31,60,60,39,39,45,45,27,27,7,7,62,62,40,40,53,53,54,54,35,35,16,16,26,26,2,2,1,1,62,62,49,49,25,25,49,49,33,33,37,37,4,4,6,6,48,48,12,12,40,40,45,45,16,16,44,44,56,56,31,31,32,32,32,32,16,16,48,48,52,52,22,22,9,9,30,30,8,8,58,58,25,25,18,18,29,29,19,19,54,54,0,0,16,16,14,14,26,26,52,52,23,23,47,47,50,50,11,11,53,53,1,1,37,37,2,2,26,26,50,50,25,25,44,44,34,34,11,11,25,25,54,54,59,59,52,52,61,61,44,44,46,46,45,45,29,29,61,61,58,58,41,41,27,27,51,51,22,22,56,56,4,4,51,51,4,4,20,20,8,8,19,19,36,36,6,6,50,50,55,55,43,43,36,36,4,4,15,15,28,28,4,4,56,56,39,39,15,15,41,41,3,3,14,14,5,5,52,52,28,28,60,60,10,10,10,10,21,21,59,59,20,20,59,59,33,33,37,37,48,48,52,52,41,41,57,57,27,27,0,0,54,54,0,0,18,18,16,16,3,3,61,61,12,12,23,23,45,45,53,53,18,18,12,12,28,28,36,36,62,62,52,52,23,23,37,37,45,45,37,37,55,55,34,34,8,8,45,45,57,57,15,15,21,21,48,48,1,1,3,3,39,39,34,34,3,3,41,41,35,35,14,14,54,54,0,0,51,51,41,41,50,50,54,54,53,53,51,51,32,32,25,25,54,54,28,28,26,26,34,34,13,13,56,56,38,38,48,48,12,12,17,17,52,52,53,53,32,32,59,59,7,7,38,38,36,36,19,19,16,16,61,61,50,50,42,42,15,15,1,1,36,36,18,18,37,37,47,47,38,38,27,27,37,37,17,17,5,5,39,39,13,13,61,61,0,0,52,52,24,24,2,2,58,58,0,0,31,31,16,16,37,37,16,16,46,46,42,42,56,56,32,32,37,37,11,11,11,11,22,22,52,52,42,42,54,54,19,19,10,10,49,49,13,13,3,3,42,42,48,48,30,30,44,44,27,27,33,33,2,2,14,14,37,37,17,17,5,5,17,17,59,59,33,33,46,46,9,9,43,43,19,19,42,42,52,52,58,58,4,4,57,57,7,7,43,43,34,34,36,36,16,16,21,21,37,37,8,8,27,27,60,60,54,54,3,3,49,49,8,8,24,24,47,47,41,41,4,4,13,13,49,49,42,42,22,22,1,1,42,42,24,24,21,21,21,21,9,9,43,43,42,42,45,45,61,61,37,37,41,41,35,35,32,32,44,44,53,53,17,17,1,1,6,6,3,3,40,40,55,55,61,61,24,24,48,48,8,8,51,51,23,23,46,46,47,47,43,43,42,42,22,22,7,7,35,35,40,40,39,39,26,26,47,47,21,21,42,42,25,25,41,41,26,26,15,15,8,8,1,1,33,33,17,17,45,45,46,46,59,59,32,32,49,49,40,40,24,24,11,11,0,0,48,48,63,63,56,56,57,57,28,28,48,48,60,60,23,23,25,25,37,37,22,22,36,36,36,36,19,19,49,49,33,33,6,6,56,56,1,1,43,43,12,12,40,40,20,20,46,46,12,12,19,19,10,10,37,37,4,4,36,36,56,56,46,46,49,49,23,23,60,60,15,15,0,0,47,47,40,40,38,38,18,18,10,10,3,3,25,25,53,53,13,13,17,17,26,26,28,28,37,37,13,13,14,14,18,18,37,37,48,48,50,50,27,27,55,55,26,26,26,26,39,39,63,63,54,54,56,56,58,58,6,6,22,22,43,43,15,15,56,56,12,12,15,15,41,41,35,35,21,21,22,22,56,56,9,9,30,30,1,1,43,43,20,20,40,40,62,62,14,14,50,50,31,31,6,6,34,34,30,30,16,16,57,57,17,17,33,33,36,36,17,17,44,44,37,37,57,57,15,15,50,50,36,36,46,46,31,31,49,49,44,44,48,48,49,49,16,16,51,51,22,22,61,61,25,25,1,1,18,18,60,60,19,19,10,10,58,58,30,30,32,32,34,34,40,40,5,5,43,43,32,32,47,47,3,3,14,14,58,58,28,28,63,63,3,3,51,51,40,40,2,2,58,58,34,34,49,49,59,59,29,29,55,55,60,60,0,0,21,21,14,14,6,6,39,39,14,14,13,13,22,22,46,46,0,0,2,2,43,43,11,11,26,26,21,21,8,8,51,51,56,56,0,0,10,10,62,62,47,47,29,29,4,4,15,15,19,19,31,31,56,56,40,40,1,1,26,26,25,25,18,18,13,13,53,53,44,44,58,58,10,10,17,17,41,41,2,2,37,37,47,47,6,6,25,25,24,24,60,60,43,43,32,32,4,4,40,40,25,25,4,4,1,1,2,2,34,34,32,32,56,56,58,58,30,30,58,58,4,4,8,8,9,9,49,49,10,10,54,54,9,9,53,53,58,58,15,15,59,59,50,50,23,23,55,55,0,0,44,44,56,56,28,28,1,1,0,0,25,25,48,48,4,4,21,21,10,10,15,15,31,31,46,46,41,41,23,23,45,45,49,49,16,16,22,22,17,17,4,4,0,0,37,37,13,13,9,9,6,6,8,8,42,42,18,18,44,44,55,55,53,53,46,46,8,8,48,48,55,55,25,25,5,5,29,29,7,7,48,48,23,23,56,56,50,50,47,47,31,31,17,17,41,41,63,63,45,45,10,10,50,50,60,60,32,32,55,55,18,18,18,18,7,7,50,50,29,29,8,8,21,21,51,51,22,22,5,5,8,8,8,8,48,48,27,27,30,30,57,57,63,63,63,63,44,44,2,2,34,34,27,27,40,40,17,17,15,15,35,35,14,14,56,56,52,52,44,44,43,43,38,38,22,22,1,1,0,0,25,25,33,33,10,10,42,42,40,40,30,30,7,7,31,31,52,52,47,47,1,1,32,32,32,32,52,52,18,18,6,6,3,3,28,28,4,4,58,58,36,36,25,25,0,0,44,44,26,26,51,51,17,17,37,37,2,2,43,43,8,8,51,51,33,33,4,4,36,36,50,50,18,18,34,34,11,11,45,45,19,19,57,57,19,19,33,33,26,26,43,43,43,43,37,37,9,9,26,26,50,50,63,63,51,51,33,33,36,36,35,35,40,40,8,8,9,9,24,24,23,23,7,7,43,43,2,2,45,45,63,63,13,13,20,20,10,10,55,55,50,50,20,20,46,46,6,6,51,51,38,38,25,25,36,36,9,9,34,34,6,6,31,31,43,43,48,48,51,51,20,20,56,56,17,17,32,32,7,7,35,35,45,45,53,53,52,52,59,59,58,58,19,19,16,16,51,51,32,32,8,8,34,34,20,20,38,38,55,55,27,27,21,21,50,50,6,6,60,60,58,58,7,7,17,17,22,22,18,18,21,21,24,24,60,60,40,40,26,26,51,51,54,54,44,44,16,16,29,29,28,28,2,2,50,50,59,59,6,6,10,10,61,61,58,58,40,40,25,25,36,36,56,56,22,22,25,25,30,30,24,24,50,50,16,16,13,13,49,49,26,26,18,18,39,39,7,7,8,8,23,23,54,54,49,49,3,3,6,6,22,22,32,32,24,24,26,26,16,16,36,36,32,32,39,39,2,2,10,10,14,14,50,50,35,35,12,12,52,52,47,47,36,36,39,39,35,35,42,42,62,62,46,46,43,43,37,37,29,29,4,4,61,61,63,63,30,30,8,8,15,15,39,39,4,4,33,33,47,47,41,41,57,57,44,44,47,47,42,42,44,44,34,34,7,7,60,60,49,49,50,50,8,8,10,10,27,27,14,14,11,11,61,61,3,3,58,58,58,58,14,14,36,36,53,53,6,6,5,5,62,62,3,3,35,35,56,56,41,41,49,49,29,29,6,6,5,5,1,1,25,25,4,4,28,28,4,4,60,60,0,0,61,61,0,0,9,9,32,32,53,53,1,1,60,60,17,17,47,47,16,16,5,5,27,27,14,14,27,27,10,10,23,23,5,5,2,2,44,44,7,7,44,44,0,0,60,60,32,32,2,2,25,25,44,44,17,17,14,14,60,60,8,8,58,58,50,50,48,48,9,9,38,38,22,22,19,19,7,7,57,57,2,2,40,40,39,39,10,10,39,39,3,3,14,14,28,28,49,49,41,41,7,7,2,2,52,52,8,8,25,25,17,17,60,60,48,48,2,2,4,4,33,33,6,6,32,32,25,25,14,14,33,33,63,63,12,12,32,32,35,35,3,3,18,18,37,37,39,39,41,41,20,20,39,39,15,15,15,15,2,2,57,57,62,62,33,33,48,48,30,30,49,49,38,38,0,0,26,26,37,37,19,19,58,58,23,23,47,47,51,51,33,33,24,24,34,34,33,33,44,44,21,21,50,50,13,13,17,17,34,34,31,31,11,11,15,15,21,21,2,2,27,27,53,53,42,42,54,54,36,36,37,37,31,31,41,41,44,44,5,5,9,9,29,29,49,49,20,20,59,59,13,13,56,56,1,1,42,42,10,10,12,12,59,59,23,23,24,24,54,54,39,39,58,58,39,39,6,6,6,6,50,50,61,61,12,12,26,26,6,6,45,45,1,1,50,50,39,39,30,30,3,3,61,61,3,3,54,54,18,18,27,27,46,46,37,37,60,60,51,51,2,2,41,41,57,57,0,0,36,36,33,33,10,10,20,20,62,62,28,28,18,18,58,58,15,15,5,5,47,47,8,8,1,1,19,19,7,7,5,5,42,42,3,3,21,21,8,8,1,1,58,58,55,55,9,9,12,12,29,29,38,38,17,17,62,62,24,24,7,7,1,1,10,10,34,34,35,35,6,6,26,26,49,49,9,9,23,23,6,6,26,26,58,58,32,32,27,27,44,44,49,49,9,9,8,8,24,24,6,6,48,48,22,22,1,1,59,59,27,27,41,41,35,35,60,60,44,44,23,23,44,44,57,57,20,20,3,3,56,56,39,39,54,54,61,61,25,25,31,31,5,5,7,7,35,35,50,50,25,25,23,23,0,0,7,7,33,33,12,12,48,48,14,14,13,13,62,62,57,57,6,6,16,16,26,26,56,56,1,1,27,27,49,49,39,39,28,28,24,24,11,11,32,32,19,19,40,40,61,61,61,61,31,31,33,33,13,13,25,25,59,59,9,9,27,27,26,26,52,52,31,31,25,25,18,18,37,37,40,40,24,24,7,7,26,26,23,23,7,7,30,30,29,29,43,43,61,61,24,24,53,53,48,48,9,9,43,43,18,18,6,6,29,29,41,41,29,29,56,56,25,25,4,4,21,21,29,29,31,31,52,52,1,1,10,10,28,28,4,4,11,11,62,62,38,38,57,57,36,36,31,31,0,0,48,48,45,45,60,60,50,50,43,43,22,22,36,36,34,34,47,47,62,62,24,24,52,52,29,29,58,58,4,4,55,55,42,42,28,28,0,0,58,58,42,42,58,58,16,16,45,45,50,50,5,5,4,4,62,62,36,36,38,38,3,3,37,37,18,18,23,23,36,36,42,42,21,21,43,43,6,6,16,16,29,29,42,42,40,40,25,25,32,32,24,24,57,57,42,42,27,27,49,49,9,9,29,29,20,20,4,4,11,11,3,3,5,5,47,47,17,17,7,7,48,48,22,22,59,59,58,58,24,24,11,11,6,6,32,32,21,21,17,17,42,42,60,60,47,47,16,16,59,59,46,46,58,58,41,41,28,28,4,4,17,17,37,37,14,14,37,37,18,18,56,56,38,38,8,8,18,18,58,58,0,0,40,40,47,47,36,36,12,12,48,48,5,5,6,6,9,9,57,57,17,17,22,22,33,33,18,18,25,25,60,60,11,11,4,4,14,14,19,19,2,2,24,24,37,37,60,60,33,33,7,7,56,56,17,17,16,16,50,50,57,57,17,17,9,9,13,13,58,58,41,41,0,0,2,2,8,8,24,24,25,25,49,49,22,22,49,49,50,50,0,0,49,49,23,23,21,21,3,3,55,55,27,27,56,56,30,30,10,10,2,2,16,16,11,11,44,44,7,7,13,13,40,40,33,33,12,12,37,37,36,36,40,40,13,13,61,61,45,45,20,20,55,55,57,57,38,38,42,42,16,16,23,23,17,17,20,20,3,3,56,56,49,49,28,28,30,30,9,9,14,14,57,57,1,1,18,18,23,23,14,14,31,31,45,45,12,12,14,14,28,28,43,43,56,56,58,58,47,47,51,51,12,12,49,49,37,37,63,63,46,46,16,16,5,5,48,48,53,53,1,1,40,40,37,37,0,0,32,32,8,8,18,18,31,31,49,49,17,17,9,9,22,22,17,17,47,47,15,15,32,32,18,18,36,36,16,16,39,39,52,52,18,18,9,9,24,24,21,21,36,36,9,9,32,32,21,21,60,60,28,28,21,21,37,37,6,6,56,56,34,34,6,6,44,44,9,9,28,28,21,21,53,53,47,47,59,59,35,35,53,53,10,10,49,49,33,33,30,30,1,1,29,29,37,37,6,6,1,1,34,34,1,1,24,24,12,12,57,57,53,53,63,63,4,4,5,5,60,60,3,3,58,58,2,2,12,12,49,49,40,40,63,63,60,60,37,37,47,47,26,26,13,13,8,8,37,37,23,23,33,33,0,0,47,47,26,26,51,51,24,24,44,44,4,4,19,19,40,40,8,8,62,62,14,14,10,10,53,53,22,22,18,18,44,44,48,48,51,51,0,0,14,14,48,48,18,18,22,22,46,46,43,43,34,34,56,56,28,28,60,60,21,21,44,44,24,24,14,14,41,41,32,32,31,31,27,27,48,48,46,46,0,0,57,57,27,27,46,46,2,2,3,3,27,27,24,24,22,22,10,10,5,5,27,27,32,32,2,2,47,47,15,15,51,51,51,51,8,8,19,19,17,17,41,41,27,27,54,54,13,13,53,53,34,34,3,3,29,29,61,61,18,18,21,21,23,23,51,51,7,7,0,0,52,52,54,54,27,27,16,16,49,49,31,31,28,28,36,36,55,55,16,16,34,34,1,1,34,34,60,60,39,39,20,20,24,24,49,49,58,58,58,58,34,34,2,2,26,26,51,51,34,34,51,51,15,15,57,57,52,52,34,34,9,9,17,17,5,5,4,4,41,41,40,40,34,34,31,31,19,19,60,60,59,59,22,22,59,59,61,61,47,47,3,3,9,9,12,12,16,16,37,37,36,36,57,57,59,59,50,50,54,54,44,44,54,54,63,63,52,52,51,51,36,36,8,8,33,33,15,15,24,24,21,21,4,4,32,32,34,34,50,50,48,48,1,1,23,23,56,56,33,33,9,9,37,37,18,18,55,55,11,11,30,30,9,9,27,27,59,59,15,15,58,58,23,23,36,36,5,5,42,42,16,16,17,17,14,14,5,5,40,40,24,24,16,16,9,9,39,39,27,27,50,50,49,49,34,34,40,40,57,57,21,21,32,32,17,17,26,26,7,7,20,20,35,35,55,55,48,48,22,22,50,50,4,4,33,33,11,11,1,1,56,56,27,27,6,6,55,55,9,9,40,40,36,36,16,16,0,0,59,59,4,4,31,31,7,7,39,39,1,1,33,33,2,2,7,7,27,27,20,20,1,1,17,17,5,5,54,54,0,0,11,11,34,34,22,22,42,42,42,42,44,44,60,60,12,12,2,2,43,43,51,51,1,1,36,36,34,34,49,49,41,41,13,13,4,4,39,39,15,15,0,0,41,41,28,28,28,28,33,33,31,31,41,41,21,21,52,52,56,56,12,12,15,15,57,57,11,11,18,18,4,4,29,29,2,2,52,52,50,50,53,53,56,56,18,18,32,32,10,10,11,11,20,20,50,50,2,2,49,49,34,34,49,49,29,29,17,17,24,24,53,53,13,13,32,32,14,14,8,8,30,30,21,21,11,11,4,4,18,18,9,9,1,1,36,36,24,24,39,39,49,49,42,42,54,54,38,38,36,36,43,43,17,17,52,52,41,41,30,30,27,27,56,56,36,36,22,22,46,46,51,51,19,19,52,52,39,39,48,48,49,49,52,52,5,5,28,28,57,57,3,3,28,28,53,53,11,11,62,62,7,7,59,59,48,48,45,45,41,41,15,15,48,48,16,16,24,24,41,41,37,37,13,13,10,10,20,20,4,4,24,24,53,53,52,52,50,50,5,5,45,45,62,62,1,1,14,14,3,3,22,22,43,43,1,1,1,1,23,23,29,29,49,49,30,30,50,50,34,34,13,13,10,10,48,48,55,55,1,1,60,60,37,37,31,31,24,24,58,58,37,37,3,3,29,29,25,25,4,4,17,17,25,25,4,4,3,3,35,35,53,53,52,52,8,8,2,2,8,8,9,9,37,37,6,6,42,42,14,14,48,48,51,51,0,0,61,61,55,55,4,4,35,35,24,24,0,0,56,56,18,18,25,25,15,15,4,4,22,22,27,27,14,14,28,28,35,35,13,13,63,63,31,31,31,31,30,30,26,26,8,8,60,60,29,29,33,33,3,3,24,24,56,56,0,0,52,52,14,14,18,18,50,50,19,19,50,50,26,26,47,47,52,52,14,14,55,55,20,20,14,14,61,61,25,25,33,33,15,15,50,50,53,53,53,53,48,48,46,46,11,11,63,63,34,34,57,57,26,26,58,58,50,50,29,29,3,3,35,35,50,50,36,36,15,15,7,7,57,57,6,6,46,46,30,30,51,51,60,60,50,50,34,34,6,6,0,0,24,24,5,5,62,62,19,19,34,34,22,22,29,29,51,51,2,2,0,0,56,56,21,21,2,2,57,57,29,29,18,18,35,35,25,25,53,53,43,43,57,57,3,3,17,17,3,3,19,19,30,30,31,31,20,20,21,21,17,17,33,33,10,10,45,45,32,32,45,45,57,57,1,1,40,40,14,14,25,25,54,54,22,22,15,15,38,38,40,40,13,13,22,22,13,13,7,7,0,0,27,27,49,49,0,0,9,9,30,30,20,20,39,39,4,4,23,23,22,22,31,31,22,22,15,15,30,30,8,8,37,37,52,52,13,13,32,32,1,1,0,0,60,60,38,38,20,20,41,41,35,35,49,49,46,46,45,45,8,8,41,41,1,1,49,49,58,58,4,4,38,38,38,38,21,21,22,22,37,37,45,45,36,36,36,36,22,22,39,39,26,26,37,37,12,12,25,25,60,60,53,53,40,40,41,41,63,63,2,2,32,32,7,7,49,49,33,33,40,40,3,3,11,11,2,2,17,17,18,18,47,47,12,12,2,2,60,60,52,52,45,45,43,43,6,6,62,62,58,58,4,4,2,2,17,17,6,6,39,39,8,8,23,23,35,35,40,40,60,60,5,5,57,57,6,6,18,18,14,14,5,5,48,48,62,62,17,17,40,40,40,40,61,61,41,41,28,28,43,43,18,18,51,51,13,13,28,28,20,20,41,41,9,9,23,23,20,20,31,31,17,17,58,58,43,43,5,5,15,15,48,48,33,33,2,2,60,60,22,22,8,8,19,19,61,61,13,13,47,47,1,1,29,29,4,4,9,9,61,61,7,7,41,41,2,2,31,31,32,32,26,26,9,9,20,20,2,2,44,44,55,55,58,58,17,17,46,46,26,26,4,4,53,53,9,9,61,61,8,8,50,50,42,42,46,46,61,61,49,49,9,9,33,33,32,32,32,32,25,25,27,27,2,2,4,4,34,34,43,43,14,14,60,60,52,52,33,33,28,28,41,41,34,34,24,24,55,55,39,39,49,49,63,63,61,61,55,55,58,58,25,25,42,42,62,62,9,9,42,42,13,13,26,26,15,15,10,10,0,0,9,9,9,9,19,19,0,0,14,14,19,19,3,3,39,39,28,28,14,14,42,42,20,20,61,61,50,50,58,58,24,24,1,1,22,22,5,5,40,40,62,62,1,1,13,13,28,28,24,24,58,58,54,54,38,38,0,0,33,33,2,2,5,5,20,20,37,37,59,59,39,39,10,10,34,34,25,25,24,24,36,36,28,28,21,21,50,50,50,50,48,48,56,56,38,38,48,48,44,44,0,0,54,54,59,59,17,17,20,20,18,18,26,26,3,3,21,21,13,13,16,16,62,62,0,0,53,53,10,10,57,57,51,51,56,56,37,37,17,17,32,32,40,40,9,9,45,45,6,6,33,33,50,50,8,8,1,1,4,4,47,47,24,24,36,36,10,10,60,60,38,38,8,8,23,23,49,49,35,35,52,52,15,15,53,53,44,44,4,4,24,24,19,19,20,20,20,20,39,39,6,6,60,60,44,44,54,54,0,0,13,13,61,61,8,8,30,30,9,9,53,53,27,27,40,40,49,49,41,41,0,0,57,57,28,28,16,16,20,20,42,42,15,15,24,24,52,52,50,50,5,5,60,60,14,14,16,16,21,21,9,9,55,55,36,36,8,8,33,33,18,18,16,16,27,27,58,58,19,19,43,43,12,12,28,28,16,16,38,38,52,52,1,1,39,39,57,57,8,8,42,42,5,5,7,7,63,63,42,42,49,49,58,58,57,57,41,41,48,48,38,38,56,56,7,7,41,41,29,29,22,22,51,51,16,16,28,28,38,38,38,38,51,51,45,45,25,25,46,46,1,1,0,0,14,14,50,50,50,50,14,14,43,43,19,19,53,53,26,26,0,0,53,53,12,12,33,33,44,44,1,1,2,2,43,43,14,14,10,10,8,8,4,4,30,30,35,35,33,33,21,21,46,46,25,25,11,11,37,37,49,49,49,49,37,37,22,22,16,16,40,40,27,27,42,42,23,23,50,50,15,15,8,8,45,45,9,9,24,24,11,11,4,4,12,12,5,5,18,18,4,4,42,42,39,39,34,34,26,26,38,38,34,34,17,17,53,53,2,2,20,20,10,10,38,38,58,58,1,1,29,29,18,18,49,49,27,27,60,60,40,40,33,33,28,28,43,43,61,61,4,4,51,51,39,39,54,54,45,45,42,42,19,19,42,42,34,34,37,37,34,34,46,46,35,35,24,24,14,14,36,36,21,21,4,4,7,7,48,48,8,8,35,35,11,11,10,10,46,46,37,37,45,45,2,2,44,44,34,34,36,36,56,56,63,63,45,45,36,36,53,53,45,45,47,47,30,30,9,9,18,18,6,6,54,54,26,26,50,50,45,45,38,38,30,30,23,23,10,10,57,57,62,62,34,34,50,50,27,27,50,50,3,3,1,1,43,43,14,14,49,49,0,0,59,59,5,5,50,50,4,4,50,50,60,60,63,63,34,34,55,55,40,40,9,9,9,9,44,44,29,29,37,37,32,32,24,24,41,41,48,48,33,33,51,51,2,2,50,50,58,58,0,0,17,17,50,50,11,11,22,22,23,23,37,37,41,41,57,57,55,55,30,30,14,14,41,41,44,44,52,52,12,12,9,9,20,20,56,56,54,54,31,31,43,43,29,29,32,32,21,21,54,54,6,6,1,1,56,56,13,13,36,36,16,16,1,1,36,36,50,50,7,7,38,38,36,36,37,37,20,20,15,15,7,7,22,22,34,34,46,46,63,63,52,52,0,0,6,6,51,51,49,49,1,1,10,10,31,31,63,63,47,47,61,61,16,16,47,47,15,15,60,60,32,32,26,26,50,50,51,51,11,11,22,22,36,36,59,59,28,28,35,35,0,0,6,6,26,26,26,26,13,13,50,50,16,16,43,43,24,24,58,58,57,57,41,41,1,1,32,32,22,22,56,56,31,31,30,30,63,63,0,0,46,46,30,30,28,28,31,31,20,20,45,45,7,7,30,30,2,2,6,6,19,19,50,50,60,60,11,11,40,40,61,61,22,22,37,37,56,56,62,62,47,47,25,25,25,25,62,62,43,43,21,21,7,7,32,32,55,55,28,28,39,39,52,52,33,33,20,20,24,24,17,17,32,32,50,50,30,30,54,54,8,8,38,38,27,27,63,63,35,35,43,43,39,39,7,7,20,20,29,29,14,14,24,24,7,7,15,15,30,30,33,33,1,1,49,49,4,4,45,45,22,22,49,49,23,23,35,35,12,12,36,36,32,32,27,27,59,59,49,49,57,57,35,35,30,30,57,57,9,9,56,56,57,57,15,15,10,10,40,40,34,34,0,0,15,15,34,34,52,52,20,20,22,22,32,32,50,50,58,58,40,40,4,4,35,35,4,4,34,34,7,7,5,5,12,12,12,12,50,50,0,0,37,37,48,48,51,51,40,40,21,21,46,46,50,50,13,13,22,22,26,26,4,4,4,4,36,36,6,6,42,42,18,18,0,0,54,54,12,12,37,37,61,61,15,15,9,9,28,28,50,50,55,55,54,54,55,55,26,26,9,9,39,39,13,13,5,5,59,59,23,23,19,19,54,54,56,56,25,25,50,50,2,2,41,41,2,2,48,48,14,14,21,21,14,14,3,3,46,46,35,35,27,27,38,38,6,6,7,7,17,17,25,25,4,4,62,62,59,59,30,30,25,25,62,62,46,46,56,56,54,54,30,30,57,57,11,11,36,36,26,26,5,5,13,13,6,6,22,22,42,42,42,42,54,54,53,53,11,11,59,59,32,32,15,15,34,34,20,20,24,24,38,38,7,7,26,26,17,17,24,24,53,53,32,32,38,38,42,42,7,7,45,45,62,62,59,59,33,33,6,6,39,39,12,12,29,29,1,1,22,22,15,15,18,18,16,16,17,17,32,32,58,58,35,35,56,56,24,24,21,21,5,5,40,40,12,12,46,46,5,5,1,1,10,10,56,56,59,59,11,11,55,55,29,29,22,22,34,34,20,20,36,36,40,40,43,43,51,51,8,8,58,58,5,5,30,30,58,58,35,35,60,60,7,7,36,36,13,13,44,44,28,28,21,21,5,5,46,46,8,8,59,59,53,53,54,54,52,52,7,7,21,21,60,60,59,59,8,8,48,48,38,38,52,52,21,21,46,46,31,31,28,28,55,55,1,1,15,15,14,14,6,6,5,5,12,12,30,30,3,3,63,63,58,58,39,39,18,18,28,28,27,27,56,56,50,50,53,53,20,20,23,23,20,20,62,62,34,34,51,51,1,1,51,51,17,17,40,40,51,51,31,31,44,44,3,3,44,44,38,38,9,9,15,15,13,13,5,5,18,18,19,19,18,18,31,31,15,15,25,25,56,56,33,33,31,31,37,37,2,2,40,40,37,37,60,60,42,42,3,3,43,43,7,7,37,37,3,3,18,18,9,9,47,47,37,37,49,49,20,20,19,19,9,9,31,31,39,39,7,7,4,4,53,53,22,22,37,37,39,39,50,50,8,8,32,32,53,53,29,29,3,3,11,11,35,35,46,46,4,4,4,4,2,2,27,27,27,27,41,41,27,27,12,12,42,42,62,62,2,2,14,14,49,49,54,54,56,56,54,54,26,26,52,52,19,19,11,11,41,41,32,32,61,61,6,6,52,52,54,54,48,48,40,40,12,12,38,38,52,52,26,26,11,11,35,35,0,0,22,22,54,54,26,26,50,50,54,54,24,24,50,50,34,34,8,8,42,42,27,27,39,39,22,22,27,27,0,0,39,39,0,0,6,6,17,17,8,8,57,57,49,49,14,14,55,55,31,31,26,26,51,51,41,41,61,61,10,10,23,23,55,55,28,28,5,5,62,62,46,46,43,43,39,39,48,48,24,24,47,47,15,15,8,8,1,1,19,19,8,8,57,57,14,14,2,2,44,44,28,28,34,34,31,31,33,33,8,8,39,39,22,22,60,60,38,38,16,16,54,54,60,60,40,40,4,4,36,36,16,16,30,30,62,62,33,33,0,0,17,17,60,60,23,23,54,54,0,0,55,55,12,12,47,47,26,26,13,13,21,21,62,62,38,38,40,40,29,29,32,32,15,15,6,6,39,39,50,50,3,3,48,48,17,17,23,23,2,2,14,14,1,1,24,24,16,16,45,45,38,38,25,25,42,42,28,28,25,25,25,25,36,36,7,7,12,12,45,45,25,25,61,61,0,0,33,33,41,41,3,3,54,54,53,53,59,59,23,23,63,63,48,48,2,2,36,36,37,37,9,9,33,33,3,3,48,48,19,19,42,42,14,14,41,41,13,13,18,18,63,63,18,18,19,19,14,14,24,24,8,8,18,18,23,23,26,26,32,32,31,31,46,46,16,16,6,6,37,37,38,38,20,20,59,59,10,10,56,56,34,34,50,50,12,12,6,6,43,43,35,35,51,51,46,46,11,11,34,34,24,24,54,54,26,26,57,57,25,25,49,49,59,59,5,5,1,1,44,44,32,32,36,36,24,24,2,2,32,32,45,45,61,61,49,49,28,28,54,54,44,44,35,35,5,5,35,35,53,53,19,19,25,25,11,11,48,48,48,48,55,55,43,43,17,17,21,21,47,47,63,63,7,7,36,36,39,39,27,27,24,24,45,45,17,17,21,21,11,11,46,46,14,14,6,6,26,26,54,54,12,12,60,60,26,26,31,31,44,44,9,9,53,53,40,40,29,29,1,1,30,30,8,8,10,10,36,36,55,55,35,35,47,47,12,12,35,35,33,33,2,2,19,19,58,58,49,49,24,24,19,19,32,32,11,11,46,46,58,58,9,9,22,22,12,12,0,0,13,13,53,53,26,26,48,48,8,8,11,11,2,2,54,54,39,39,12,12,45,45,31,31,16,16,18,18,37,37,46,46,59,59,60,60,10,10,53,53,53,53,11,11,37,37,53,53,38,38,63,63,28,28,34,34,24,24,58,58,32,32,42,42,58,58,0,0,51,51,30,30,15,15,57,57,46,46,46,46,9,9,6,6,58,58,61,61,55,55,58,58,33,33,58,58,37,37,53,53,29,29,40,40,48,48,13,13,53,53,21,21,27,27,1,1,49,49,30,30,6,6,19,19,26,26,23,23,40,40,52,52,41,41,14,14,22,22,41,41,16,16,6,6,63,63,44,44,19,19,24,24,46,46,25,25,2,2,28,28,15,15,6,6,19,19,23,23,55,55,27,27,35,35,24,24,11,11,28,28,25,25,20,20,50,50,23,23,14,14,53,53,27,27,49,49,36,36,43,43,32,32,46,46,15,15,53,53,47,47,10,10,7,7,56,56,56,56,41,41,20,20,19,19,26,26,32,32,63,63,55,55,60,60,13,13,10,10,33,33,1,1,23,23,36,36,7,7,46,46,2,2,21,21,29,29,1,1,46,46,8,8,50,50,50,50,4,4,54,54,56,56,13,13,29,29,1,1,35,35,46,46,10,10,30,30,39,39,2,2,14,14,48,48,48,48,6,6,8,8,39,39,24,24,45,45,24,24,26,26,20,20,27,27,13,13,17,17,34,34,30,30,41,41,32,32,2,2,1,1,26,26,60,60,39,39,25,25,17,17,11,11,62,62,42,42,32,32,28,28,16,16,16,16,46,46,18,18,27,27,19,19,20,20,27,27,21,21,2,2,1,1,21,21,7,7,39,39,36,36,2,2,23,23,45,45,1,1,32,32,38,38,14,14,13,13,38,38,42,42,13,13,35,35,24,24,40,40,3,3,32,32,41,41,18,18,14,14,30,30,26,26,30,30,62,62,60,60,38,38,8,8,46,46,54,54,14,14,31,31,61,61,5,5,33,33,5,5,31,31,35,35,12,12,63,63,3,3,48,48,30,30,5,5,61,61,60,60,55,55,30,30,8,8,55,55,5,5,52,52,22,22,41,41,21,21,9,9,51,51,20,20,50,50,53,53,52,52,13,13,48,48,9,9,62,62,18,18,39,39,3,3,18,18,55,55,27,27,46,46,17,17,27,27,38,38,48,48,54,54,38,38,15,15,24,24,48,48,2,2,0,0,37,37,23,23,60,60,18,18,2,2,41,41,26,26,39,39,50,50,10,10,12,12,49,49,12,12,48,48,21,21,4,4,53,53,55,55,51,51,53,53,60,60,31,31,21,21,61,61,5,5,26,26,14,14,51,51,36,36,1,1,50,50,26,26,17,17,14,14,18,18,56,56,60,60,17,17,61,61,62,62,28,28,39,39,1,1,3,3,27,27,45,45,46,46,23,23,48,48,10,10,36,36,16,16,51,51,61,61,50,50,9,9,63,63,29,29,61,61,39,39,5,5,11,11,52,52,29,29,44,44,0,0,20,20,60,60,33,33,13,13,44,44,14,14,20,20,34,34,18,18,60,60,19,19,29,29,7,7,44,44,29,29,43,43,12,12,55,55,36,36,58,58,31,31,62,62,4,4,11,11,1,1,26,26,45,45,4,4,59,59,44,44,39,39,13,13,27,27,0,0,26,26,36,36,34,34,36,36,12,12,16,16,4,4,63,63,62,62,42,42,38,38,22,22,53,53,19,19,36,36,45,45,15,15,34,34,40,40,34,34,1,1,9,9,42,42,3,3,60,60,0,0,49,49,9,9,4,4,25,25,16,16,2,2,34,34,36,36,24,24,1,1,50,50,53,53,59,59,52,52,22,22,46,46,32,32,40,40,21,21,7,7,49,49,39,39,1,1,4,4,2,2,61,61,9,9,2,2,21,21,23,23,56,56,50,50,4,4,33,33,62,62,50,50,0,0,6,6,12,12,29,29,8,8,59,59,6,6,46,46,53,53,19,19,43,43,45,45,3,3,36,36,1,1,33,33,30,30,33,33,45,45,37,37,6,6,57,57,37,37,13,13,52,52,28,28,39,39,57,57,20,20,43,43,13,13,24,24,15,15,20,20,52,52,22,22,29,29,53,53,20,20,24,24,27,27,2,2,6,6,29,29,10,10,42,42,3,3,19,19,46,46,28,28,42,42,16,16,63,63,37,37,3,3,9,9,55,55,3,3,16,16,17,17,43,43,59,59,49,49,38,38,63,63,52,52,37,37,17,17,2,2,50,50,53,53,1,1,61,61,0,0,59,59,56,56,4,4,50,50,26,26,58,58,3,3,56,56,20,20,61,61,21,21,7,7,63,63,33,33,7,7,18,18,53,53,34,34,18,18,47,47,23,23,58,58,10,10,20,20,63,63,14,14,30,30,24,24,41,41,7,7,57,57,48,48,44,44,49,49,53,53,34,34,35,35,48,48,51,51,35,35,9,9,7,7,6,6,63,63,28,28,44,44,62,62,24,24,18,18,39,39,47,47,23,23,52,52,7,7,53,53,17,17,56,56,3,3,33,33,10,10,11,11,4,4,11,11,44,44,24,24,42,42,46,46,58,58,49,49,21,21,27,27,4,4,25,25,48,48,36,36,29,29,40,40,61,61,14,14,34,34,24,24,55,55,33,33,61,61,50,50,15,15,50,50,47,47,4,4,35,35,39,39,21,21,4,4,51,51,44,44,2,2,28,28,1,1,53,53,17,17,13,13,31,31,49,49,10,10,31,31,1,1,41,41,37,37,53,53,20,20,33,33,12,12,10,10,43,43,39,39,49,49,26,26,61,61,12,12,57,57,22,22,56,56,12,12,26,26,25,25,15,15,8,8,40,40,63,63,30,30,17,17,47,47,32,32,54,54,15,15,27,27,48,48,32,32,51,51,18,18,34,34,32,32,30,30,20,20,55,55,18,18,36,36,4,4,25,25,24,24,24,24,55,55,1,1,1,1,56,56,59,59,1,1,12,12,23,23,41,41,56,56,32,32,1,1,25,25,63,63,52,52,51,51,10,10,17,17,59,59,46,46,0,0,46,46,33,33,54,54,53,53,49,49,50,50,41,41,61,61,59,59,14,14,47,47,26,26,48,48,49,49,50,50,5,5,23,23,28,28,38,38,39,39,33,33,54,54,61,61,43,43,32,32,58,58,1,1,48,48,42,42,20,20,39,39,43,43,0,0,26,26,33,33,10,10,11,11,20,20,4,4,21,21,40,40,46,46,2,2,48,48,36,36,11,11,26,26,42,42,52,52,13,13,2,2,51,51,20,20,32,32,22,22,30,30,43,43,15,15,62,62,51,51,41,41,38,38,61,61,51,51,37,37,36,36,14,14,33,33,19,19,44,44,23,23,1,1,11,11,50,50,15,15,22,22,41,41,37,37,0,0,46,46,10,10,58,58,30,30,34,34,21,21,63,63,8,8,61,61,0,0,46,46,46,46,45,45,7,7,55,55,5,5,21,21,31,31,11,11,39,39,61,61,61,61,16,16,7,7,39,39,37,37,31,31,35,35,58,58,22,22,42,42,45,45,32,32,21,21,52,52,36,36,15,15,33,33,21,21,6,6,14,14,21,21,8,8,57,57,17,17,54,54,37,37,24,24,35,35,8,8,2,2,15,15,49,49,43,43,13,13,44,44,9,9,32,32,29,29,34,34,60,60,46,46,51,51,19,19,24,24,35,35,27,27,32,32,45,45,15,15,46,46,8,8,52,52,39,39,52,52,21,21,20,20,57,57,12,12,14,14,4,4,16,16,39,39,0,0,9,9,10,10,26,26,0,0,52,52,41,41,45,45,58,58,60,60,8,8,58,58,16,16,53,53,42,42,2,2,36,36,22,22,27,27,21,21,23,23,49,49,26,26,6,6,55,55,61,61,39,39,16,16,34,34,35,35,35,35,25,25,8,8,1,1,40,40,33,33,38,38,44,44,45,45,30,30,7,7,13,13,11,11,8,8,30,30,57,57,43,43,49,49,29,29,44,44,38,38,49,49,51,51,59,59,41,41,12,12,11,11,42,42,19,19,24,24,58,58,48,48,32,32,62,62,51,51,34,34,29,29,25,25,55,55,44,44,33,33,18,18,7,7,16,16,5,5,2,2,1,1,54,54,52,52,55,55,11,11,21,21,30,30,62,62,17,17,47,47,8,8,43,43,1,1,47,47,48,48,41,41,61,61,24,24,52,52,62,62,24,24,1,1,8,8,34,34,41,41,33,33,52,52,37,37,7,7,13,13,20,20,12,12,2,2,45,45,39,39,58,58,34,34,27,27,36,36,10,10,4,4,40,40,49,49,44,44,35,35,44,44,60,60,52,52,43,43,46,46,25,25,0,0,0,0,53,53,4,4,6,6,49,49,49,49,30,30,44,44,32,32,8,8,21,21,4,4,46,46,2,2,44,44,21,21,38,38,39,39,23,23,25,25,15,15,54,54,12,12,26,26,32,32,16,16,23,23,20,20,7,7,28,28,56,56,61,61,49,49,60,60,2,2,54,54,14,14,48,48,24,24,34,34,54,54,22,22,12,12,17,17,33,33,46,46,26,26,17,17,20,20,61,61,19,19,20,20,5,5,22,22,41,41,51,51,19,19,43,43,45,45,26,26,23,23,19,19,2,2,34,34,59,59,4,4,38,38,4,4,41,41,21,21,57,57,25,25,8,8,3,3,55,55,19,19,52,52,42,42,60,60,45,45,60,60,4,4,54,54,55,55,35,35,8,8,17,17,53,53,0,0,22,22,63,63,59,59,49,49,13,13,32,32,33,33,11,11,18,18,8,8,16,16,57,57,30,30,1,1,8,8,1,1,24,24,34,34,8,8,57,57,42,42,41,41,3,3,57,57,30,30,34,34,33,33,60,60,6,6,28,28,46,46,52,52,37,37,27,27,58,58,30,30,23,23,37,37,36,36,50,50,35,35,60,60,48,48,25,25,62,62,36,36,24,24,55,55,56,56,51,51,23,23,2,2,33,33,35,35,34,34,30,30,14,14,39,39,7,7,0,0,26,26,21,21,26,26,4,4,9,9,41,41,13,13,26,26,59,59,18,18,0,0,37,37,48,48,5,5,46,46,15,15,59,59,12,12,58,58,22,22,22,22,46,46,36,36,32,32,50,50,26,26,47,47,1,1,26,26,40,40,28,28,39,39,55,55,40,40,34,34,23,23,16,16,63,63,8,8,53,53,3,3,46,46,34,34,35,35,53,53,52,52,30,30,39,39,26,26,25,25,4,4,9,9,59,59,22,22,43,43,30,30,23,23,61,61,9,9,14,14,48,48,44,44,0,0,51,51,45,45,38,38,31,31,22,22,54,54,53,53,37,37,50,50,8,8,0,0,62,62,59,59,11,11,12,12,55,55,36,36,33,33,20,20,35,35,33,33,62,62,13,13,7,7,25,25,37,37,29,29,12,12,16,16,14,14,22,22,43,43,3,3,32,32,62,62,7,7,48,48,24,24,46,46,33,33,37,37,21,21,4,4,50,50,57,57,15,15,12,12,39,39,41,41,35,35,12,12,26,26,36,36,49,49,52,52,52,52,44,44,57,57,54,54,4,4,46,46,23,23,22,22,2,2,40,40,14,14,19,19,16,16,50,50,7,7,7,7,55,55,16,16,7,7,39,39,7,7,30,30,10,10,4,4,21,21,3,3,8,8,36,36,32,32,37,37,38,38,17,17,10,10,1,1,63,63,32,32,46,46,57,57,59,59,61,61,50,50,28,28,21,21,29,29,34,34,42,42,44,44,0,0,11,11,14,14,1,1,24,24,17,17,33,33,18,18,59,59,62,62,14,14,24,24,12,12,41,41,59,59,17,17,13,13,52,52,17,17,8,8,45,45,12,12,32,32,54,54,38,38,9,9,49,49,34,34,63,63,11,11,39,39,20,20,51,51,52,52,49,49,18,18,10,10,39,39,14,14,14,14,1,1,56,56,5,5,23,23,42,42,41,41,18,18,48,48,29,29,35,35,31,31,50,50,31,31,37,37,14,14,9,9,32,32,20,20,39,39,0,0,4,4,36,36,9,9,5,5,63,63,16,16,48,48,51,51,36,36,5,5,32,32,63,63,25,25,17,17,29,29,5,5,5,5,60,60,41,41,38,38,32,32,48,48,28,28,61,61,27,27,12,12,60,60,22,22,35,35,12,12,50,50,11,11,13,13,8,8,35,35,51,51,53,53,3,3,58,58,46,46,35,35,3,3,54,54,14,14,2,2,10,10,30,30,17,17,38,38,58,58,33,33,42,42,8,8,21,21,39,39,34,34,31,31,44,44,16,16,34,34,35,35,7,7,8,8,34,34,30,30,58,58,58,58,57,57,25,25,43,43,58,58,22,22,18,18,12,12,40,40,42,42,7,7,26,26,8,8,33,33,36,36,9,9,18,18,36,36,20,20,20,20,28,28,38,38,61,61,17,17,16,16,16,16,18,18,58,58,28,28,2,2,32,32,10,10,42,42,2,2,61,61,23,23,47,47,44,44,11,11,0,0,21,21,46,46,63,63,28,28,61,61,19,19,13,13,36,36,8,8,1,1,6,6,1,1,29,29,45,45,39,39,6,6,9,9,20,20,50,50,44,44,49,49,29,29,42,42,28,28,49,49,38,38,52,52,62,62,17,17,28,28,53,53,45,45,39,39,48,48,52,52,0,0,37,37,47,47,48,48,0,0,58,58,36,36,1,1,61,61,55,55,21,21,58,58,51,51,57,57,30,30,54,54,4,4,3,3,43,43,11,11,51,51,17,17,13,13,50,50,21,21,60,60,53,53,53,53,38,38,24,24,13,13,0,0,41,41,40,40,4,4,23,23,22,22,9,9,57,57,8,8,33,33,59,59,18,18,5,5,15,15,25,25,18,18,59,59,26,26,34,34,3,3,22,22,25,25,39,39,48,48,3,3,26,26,46,46,11,11,12,12,13,13,39,39,56,56,32,32,5,5,17,17,11,11,52,52,4,4,1,1,28,28,8,8,58,58,11,11,15,15,4,4,23,23,2,2,12,12,4,4,6,6,62,62,59,59,61,61,25,25,15,15,34,34,53,53,29,29,23,23,60,60,58,58,12,12,19,19,7,7,26,26,25,25,19,19,34,34,12,12,29,29,43,43,36,36,36,36,25,25,43,43,12,12,6,6,1,1,27,27,26,26,34,34,57,57,5,5,17,17,53,53,17,17,63,63,11,11,8,8,2,2,32,32,39,39,53,53,58,58,8,8,62,62,60,60,24,24,4,4,56,56,22,22,18,18,39,39,6,6,5,5,48,48,59,59,53,53,23,23,28,28,53,53,4,4,53,53,8,8,6,6,36,36,54,54,27,27,32,32,55,55,20,20,51,51,37,37,36,36,44,44,33,33,17,17,28,28,58,58,6,6,44,44,25,25,3,3,54,54,5,5,31,31,12,12,38,38,2,2,36,36,4,4,33,33,37,37,7,7,53,53,24,24,19,19,16,16,49,49,9,9,43,43,18,18,28,28,33,33,50,50,30,30,15,15,32,32,53,53,39,39,34,34,16,16,10,10,12,12,3,3,6,6,42,42,0,0,44,44,9,9,8,8,50,50,2,2,9,9,55,55,35,35,5,5,51,51,33,33,24,24,28,28,60,60,48,48,61,61,0,0,58,58,32,32,53,53,24,24,17,17,51,51,13,13,18,18,62,62,46,46,47,47,42,42,50,50,54,54,39,39,61,61,0,0,34,34,52,52,36,36,23,23,56,56,4,4,25,25,57,57,51,51,49,49,35,35,46,46,29,29,17,17,33,33,60,60,56,56,0,0,3,3,41,41,43,43,61,61,12,12,50,50,11,11,26,26,18,18,8,8,33,33,5,5,38,38,13,13,9,9,26,26,43,43,4,4,54,54,23,23,9,9,20,20,2,2,28,28,30,30,26,26,5,5,7,7,62,62,10,10,45,45,46,46,62,62,46,46,47,47,31,31,38,38,55,55,1,1,43,43,42,42,23,23,26,26,61,61,26,26,59,59,41,41,19,19,63,63,28,28,58,58,25,25,14,14,2,2,7,7,44,44,29,29,49,49,49,49,9,9,62,62,15,15,22,22,7,7,50,50,1,1,23,23,56,56,15,15,54,54,7,7,10,10,50,50,14,14,20,20,9,9,49,49,13,13,33,33,24,24,56,56,24,24,13,13,50,50,33,33,13,13,1,1,7,7,49,49,33,33,46,46,51,51,37,37,12,12,8,8,18,18,38,38,3,3,22,22,56,56,26,26,43,43,57,57,19,19,59,59,43,43,38,38,27,27,32,32,49,49,42,42,22,22,44,44,6,6,49,49,58,58,56,56,9,9,25,25,53,53,32,32,20,20,10,10,7,7,21,21,3,3,38,38,8,8,47,47,47,47,18,18,0,0,14,14,2,2,22,22,34,34,51,51,8,8,23,23,31,31,44,44,4,4,38,38,42,42,8,8,60,60,49,49,23,23,46,46,48,48,36,36,27,27,63,63,61,61,45,45,47,47,36,36,59,59,19,19,35,35,49,49,45,45,22,22,37,37,8,8,27,27,52,52,40,40,41,41,40,40,19,19,6,6,6,6,33,33,36,36,3,3,29,29,14,14,32,32,62,62,59,59,48,48,40,40,3,3,9,9,47,47,29,29,44,44,12,12,4,4,28,28,56,56,32,32,22,22,35,35,22,22,9,9,4,4,10,10,40,40,39,39,59,59,3,3,58,58,9,9,58,58,57,57,58,58,9,9,24,24,35,35,60,60,19,19,35,35,14,14,59,59,31,31,25,25,6,6,8,8,52,52,62,62,43,43,7,7,52,52,42,42,48,48,14,14,29,29,28,28,18,18,49,49,58,58,11,11,13,13,35,35,63,63,13,13,16,16,12,12,0,0,5,5,32,32,4,4,10,10,19,19,35,35,53,53,59,59,57,57,9,9,44,44,29,29,17,17,6,6,26,26,11,11,41,41,28,28,51,51,23,23,5,5,53,53,13,13,2,2,11,11,16,16,54,54,15,15,17,17,20,20,37,37,31,31,47,47,39,39,5,5,24,24,54,54,1,1,63,63,25,25,36,36,56,56,17,17,57,57,5,5,20,20,36,36,51,51,56,56,57,57,55,55,62,62,54,54,34,34,26,26,3,3,41,41,63,63,36,36,55,55,12,12,49,49,43,43,48,48,38,38,16,16,25,25,26,26,48,48,16,16,36,36,27,27,6,6,30,30,18,18,55,55,16,16,17,17,50,50,23,23,59,59,55,55,29,29,42,42,0,0,4,4,39,39,10,10,8,8,49,49,8,8,2,2,28,28,36,36,13,13,15,15,29,29,38,38,23,23,2,2,35,35,12,12,1,1,22,22,41,41,28,28,42,42,51,51,32,32,45,45,38,38,53,53,36,36,32,32,56,56,20,20,39,39,24,24,37,37,0,0,62,62,5,5,26,26,19,19,3,3,25,25,30,30,35,35,24,24,33,33,48,48,5,5,32,32,52,52,24,24,37,37,35,35,46,46,26,26,63,63,3,3,60,60,36,36,21,21,10,10,3,3,31,31,45,45,37,37,29,29,36,36,52,52,32,32,61,61,14,14,44,44,50,50,2,2,58,58,52,52,21,21,15,15,31,31,62,62,14,14,48,48,54,54,45,45,2,2,35,35,28,28,13,13,59,59,48,48,40,40,32,32,23,23,12,12,27,27,51,51,39,39,39,39,14,14,13,13,52,52,3,3,63,63,34,34,52,52,8,8,37,37,43,43,4,4,20,20,38,38,9,9,1,1,44,44,27,27,10,10,3,3,31,31,42,42,44,44,57,57,42,42,0,0,43,43,45,45,63,63,38,38,18,18,43,43,24,24,57,57,4,4,48,48,38,38,54,54,16,16,41,41,41,41,51,51,18,18,12,12,41,41,15,15,30,30,38,38,42,42,56,56,61,61,12,12,28,28,1,1,45,45,15,15,44,44,44,44,17,17,31,31,42,42,25,25,58,58,24,24,39,39,32,32,26,26,3,3,25,25,26,26,24,24,21,21,43,43,22,22,42,42,43,43,25,25,56,56,9,9,4,4,16,16,61,61,53,53,32,32,2,2,48,48,5,5,17,17,12,12,52,52,47,47,32,32,57,57,33,33,10,10,57,57,40,40,50,50,40,40,0,0,49,49,12,12,37,37,29,29,42,42,41,41,19,19,38,38,56,56,54,54,52,52,40,40,44,44,21,21,54,54,50,50,47,47,54,54,17,17,24,24,4,4,50,50,25,25,44,44,59,59,33,33,53,53,34,34,36,36,50,50,37,37,17,17,29,29,15,15,19,19,58,58,2,2,33,33,30,30,8,8,32,32,16,16,31,31,10,10,43,43,28,28,18,18,61,61,28,28,52,52,31,31,62,62,22,22,14,14,37,37,62,62,19,19,22,22,4,4,59,59,49,49,16,16,55,55,49,49,40,40,25,25,63,63,58,58,53,53,4,4,31,31,51,51,22,22,34,34,58,58,6,6,29,29,59,59,33,33,23,23,10,10,58,58,6,6,11,11,45,45,20,20,48,48,56,56,18,18,18,18,19,19,60,60,53,53,39,39,45,45,40,40,43,43,63,63,44,44,47,47,41,41,3,3,46,46,42,42,31,31,35,35,38,38,29,29,41,41,44,44,63,63,6,6,34,34,57,57,25,25,35,35,45,45,43,43,34,34,6,6,22,22,23,23,63,63,9,9,9,9,59,59,40,40,4,4,28,28,42,42,63,63,32,32,5,5,45,45,50,50,6,6,9,9,54,54,34,34,2,2,3,3,18,18,7,7,2,2,32,32,37,37,25,25,59,59,11,11,41,41,60,60,0,0,51,51,5,5,13,13,50,50,22,22,18,18,37,37,59,59,63,63,1,1,46,46,22,22,4,4,4,4,50,50,14,14,2,2,15,15,17,17,12,12,1,1,55,55,27,27,39,39,43,43,25,25,38,38,59,59,61,61,3,3,38,38,20,20,12,12,31,31,17,17,1,1,27,27,53,53,22,22,43,43,38,38,38,38,28,28,38,38,33,33,26,26,57,57,56,56,54,54,28,28,37,37,46,46,46,46,1,1,40,40,2,2,62,62,3,3,15,15,43,43,50,50,42,42,38,38,23,23,30,30,10,10,18,18,45,45,52,52,50,50,17,17,31,31,62,62,4,4,40,40,57,57,28,28,12,12,56,56,14,14,61,61,4,4,13,13,45,45,3,3,30,30,56,56,60,60,27,27,24,24,27,27,40,40,41,41,59,59,12,12,46,46,54,54,56,56,13,13,24,24,51,51,2,2,9,9,0,0,39,39,29,29,29,29,19,19,42,42,17,17,7,7,9,9,61,61,10,10,8,8,33,33,2,2,0,0,21,21,39,39,49,49,6,6,44,44,60,60,15,15,47,47,36,36,29,29,20,20,39,39,15,15,30,30,34,34,60,60,59,59,5,5,63,63,41,41,37,37,37,37,6,6,18,18,1,1,33,33,35,35,55,55,10,10,37,37,48,48,37,37,45,45,58,58,53,53,50,50,37,37,51,51,22,22,57,57,37,37,17,17,30,30,56,56,8,8,38,38,29,29,14,14,33,33,39,39,47,47,14,14,35,35,18,18,60,60,57,57,15,15,32,32,36,36,50,50,31,31,16,16,21,21,12,12,41,41,2,2,33,33,16,16,27,27,0,0,30,30,20,20,34,34,7,7,54,54,37,37,15,15,56,56,4,4,33,33,5,5,58,58,56,56,44,44,36,36,7,7,4,4,39,39,3,3,0,0,7,7,7,7,7,7,15,15,35,35,29,29,42,42,37,37,23,23,36,36,6,6,44,44,45,45,24,24,34,34,57,57,60,60,22,22,14,14,15,15,30,30,36,36,5,5,13,13,52,52,0,0,8,8,48,48,5,5,38,38,52,52,37,37,54,54,32,32,18,18,30,30,9,9,20,20,23,23,25,25,2,2,50,50,30,30,10,10,6,6,0,0,21,21,19,19,58,58,45,45,59,59,26,26,1,1,25,25,24,24,31,31,21,21,27,27,59,59,56,56,8,8,59,59,12,12,18,18,30,30,10,10,45,45,20,20,12,12,11,11,14,14,34,34,46,46,23,23,50,50,63,63,41,41,44,44,63,63,15,15,40,40,8,8,58,58,33,33,59,59,62,62,18,18,2,2,31,31,34,34,38,38,44,44,35,35,8,8,10,10,54,54,50,50,7,7,57,57,41,41,7,7,45,45,28,28,9,9,4,4,59,59,62,62,36,36,7,7,11,11,45,45,37,37,44,44,49,49,26,26,24,24,18,18,4,4,28,28,8,8,27,27,50,50,20,20,21,21,25,25,51,51,62,62,10,10,1,1,10,10,35,35,13,13,50,50,9,9,51,51,62,62,52,52,20,20,34,34,53,53,10,10,35,35,50,50,41,41,22,22,16,16,49,49,8,8,59,59,3,3,25,25,7,7,43,43,11,11,40,40,24,24,63,63,22,22,29,29,9,9,0,0,23,23,1,1,57,57,25,25,6,6,0,0,28,28,52,52,56,56,39,39,16,16,4,4,36,36,48,48,56,56,10,10,19,19,15,15,36,36,6,6,58,58,55,55,36,36,13,13,41,41,39,39,2,2,32,32,55,55,6,6,59,59,24,24,7,7,51,51,39,39,27,27,15,15,11,11,47,47,42,42,16,16,55,55,32,32,60,60,31,31,62,62,11,11,60,60,51,51,16,16,16,16,63,63,49,49,24,24,52,52,33,33,62,62,29,29,6,6,62,62,46,46,36,36,50,50,27,27,58,58,18,18,40,40,54,54,1,1,34,34,1,1,17,17,3,3,20,20,12,12,63,63,42,42,51,51,51,51,49,49,10,10,38,38,22,22,40,40,22,22,50,50,12,12,45,45,26,26,16,16,28,28,52,52,4,4,37,37,12,12,32,32,60,60,34,34,21,21,29,29,36,36,12,12,15,15,55,55,57,57,10,10,9,9,24,24,34,34,56,56,20,20,61,61,32,32,1,1,53,53,43,43,54,54,41,41,57,57,2,2,12,12,46,46,50,50,37,37,49,49,2,2,31,31,62,62,55,55,23,23,62,62,45,45,45,45,37,37,32,32,8,8,4,4,44,44,18,18,61,61,10,10,48,48,51,51,18,18,6,6,50,50,49,49,52,52,19,19,33,33,40,40,32,32,48,48,37,37,43,43,12,12,44,44,53,53,38,38,6,6,2,2,17,17,52,52,18,18,3,3,43,43,7,7,35,35,58,58,21,21,2,2,13,13,36,36,0,0,61,61,23,23,40,40,37,37,41,41,8,8,33,33,18,18,41,41,52,52,44,44,33,33,10,10,28,28,4,4,37,37,28,28,40,40,42,42,47,47,1,1,48,48,58,58,18,18,14,14,5,5,9,9,26,26,20,20,36,36,37,37,50,50,22,22,6,6,63,63,45,45,12,12,52,52,16,16,51,51,37,37,11,11,47,47,34,34,47,47,3,3,12,12,38,38,55,55,14,14,41,41,18,18,60,60,62,62,46,46,60,60,2,2,22,22,26,26,33,33,57,57,49,49,5,5,18,18,15,15,56,56,53,53,26,26,22,22,13,13,61,61,42,42,32,32,7,7,8,8,2,2,11,11,58,58,58,58,42,42,48,48,0,0,47,47,34,34,38,38,21,21,39,39,9,9,55,55,0,0,11,11,4,4,43,43,36,36,34,34,58,58,4,4,33,33,15,15,5,5,26,26,5,5,9,9,14,14,38,38,19,19,28,28,55,55,36,36,28,28,15,15,1,1,2,2,20,20,11,11,60,60,42,42,13,13,44,44,28,28,22,22,26,26,9,9,49,49,46,46,9,9,19,19,40,40,5,5,17,17,54,54,5,5,59,59,15,15,9,9,63,63,34,34,2,2,33,33,62,62,28,28,8,8,48,48,27,27,0,0,42,42,11,11,38,38,47,47,54,54,23,23,4,4,11,11,11,11,9,9,48,48,40,40,41,41,19,19,43,43,15,15,57,57,11,11,49,49,20,20,33,33,60,60,58,58,36,36,33,33,52,52,29,29,42,42,8,8,54,54,27,27,3,3,28,28,44,44,50,50,8,8,32,32,60,60,34,34,13,13,8,8,9,9,32,32,58,58,61,61,32,32,45,45,41,41,58,58,23,23,39,39,0,0,2,2,41,41,33,33,63,63,28,28,46,46,32,32,15,15,12,12,5,5,6,6,41,41,19,19,36,36,49,49,42,42,10,10,18,18,45,45,52,52,5,5,40,40,42,42,18,18,14,14,61,61,3,3,20,20,6,6,27,27,16,16,46,46,5,5,38,38,8,8,24,24,15,15,5,5,16,16,24,24,11,11,34,34,63,63,8,8,58,58,35,35,56,56,26,26,20,20,5,5,35,35,15,15,19,19,1,1,60,60,35,35,44,44,15,15,0,0,43,43,41,41,28,28,62,62,37,37,0,0,4,4,4,4,14,14,37,37,22,22,24,24,49,49,20,20,0,0,14,14,63,63,2,2,23,23,61,61,62,62,27,27,53,53,11,11,7,7,27,27,55,55,12,12,42,42,4,4,48,48,45,45,28,28,31,31,47,47,34,34,10,10,16,16,22,22,45,45,48,48,60,60,13,13,46,46,19,19,0,0,32,32,30,30,40,40,56,56,40,40,19,19,41,41,53,53,60,60,49,49,57,57,3,3,20,20,39,39,61,61,24,24,21,21,30,30,24,24,24,24,24,24,37,37,52,52,35,35,31,31,18,18,5,5,59,59,60,60,27,27,56,56,56,56,36,36,33,33,29,29,50,50,24,24,2,2,60,60,26,26,3,3,22,22,34,34,6,6,61,61,50,50,33,33,21,21,2,2,25,25,13,13,18,18,27,27,0,0,39,39,12,12,8,8,38,38,6,6,21,21,16,16,49,49,8,8,13,13,5,5,31,31,20,20,17,17,58,58,1,1,23,23,42,42,56,56,39,39,34,34,44,44,17,17,7,7,5,5,31,31,56,56,63,63,29,29,33,33,38,38,39,39,40,40,9,9,58,58,33,33,0,0,55,55,53,53,56,56,34,34,38,38,45,45,1,1,2,2,26,26,42,42,17,17,29,29,28,28,57,57,5,5,31,31,12,12,1,1,13,13,13,13,56,56,56,56,45,45,19,19,60,60,25,25,8,8,20,20,61,61,4,4,23,23,19,19,10,10,29,29,45,45,21,21,48,48,12,12,53,53,17,17,44,44,25,25,29,29,25,25,32,32,59,59,35,35,18,18,12,12,31,31,9,9,10,10,42,42,45,45,33,33,35,35,58,58,30,30,32,32,6,6,12,12,29,29,61,61,53,53,57,57,30,30,59,59,5,5,37,37,14,14,43,43,1,1,2,2,37,37,54,54,34,34,5,5,1,1,35,35,56,56,43,43,3,3,11,11,48,48,31,31,30,30,13,13,57,57,20,20,10,10,39,39,18,18,44,44,13,13,28,28,44,44,3,3,49,49,62,62,60,60,48,48,38,38,63,63,32,32,27,27,38,38,20,20,49,49,24,24,6,6,41,41,55,55,4,4,63,63,9,9,14,14,47,47,38,38,50,50,14,14,24,24,16,16,57,57,30,30,16,16,58,58,60,60,44,44,10,10,59,59,7,7,48,48,48,48,54,54,9,9,2,2,36,36,63,63,55,55,39,39,5,5,58,58,28,28,17,17,46,46,2,2,57,57,28,28,9,9,54,54,56,56,5,5,43,43,40,40,60,60,43,43,19,19,39,39,50,50,61,61,1,1,57,57,44,44,54,54,42,42,24,24,5,5,32,32,8,8,7,7,13,13,7,7,31,31,8,8,38,38,29,29,10,10,22,22,24,24,56,56,35,35,46,46,48,48,57,57,58,58,29,29,5,5,63,63,61,61,54,54,9,9,32,32,33,33,46,46,30,30,18,18,44,44,25,25,28,28,1,1,57,57,63,63,31,31,43,43,61,61,26,26,7,7,37,37,39,39,38,38,57,57,63,63,43,43,40,40,49,49,48,48,48,48,43,43,0,0,26,26,46,46,42,42,11,11,52,52,30,30,34,34,0,0,4,4,8,8,43,43,17,17,9,9,49,49,47,47,29,29,3,3,36,36,61,61,32,32,2,2,55,55,15,15,12,12,15,15,23,23,55,55,63,63,19,19,20,20,1,1,57,57,9,9,14,14,16,16,33,33,58,58,6,6,60,60,59,59,17,17,37,37,51,51,29,29,29,29,38,38,27,27,42,42,39,39,29,29,38,38,61,61,9,9,48,48,4,4,40,40,35,35,33,33,14,14,61,61,50,50,58,58,53,53,30,30,49,49,42,42,7,7,3,3,44,44,4,4,19,19,18,18,51,51,16,16,4,4,7,7,23,23,50,50,33,33,8,8,46,46,29,29,33,33,19,19,16,16,38,38,35,35,40,40,22,22,62,62,31,31,16,16,19,19,57,57,14,14,53,53,52,52,27,27,48,48,0,0,32,32,10,10,55,55,29,29,20,20,21,21,19,19,16,16,2,2,20,20,36,36,0,0,48,48,51,51,52,52,24,24,31,31,0,0,33,33,54,54,51,51,45,45,13,13,40,40,37,37,7,7,47,47,23,23,10,10,1,1,59,59,63,63,51,51,16,16,18,18,29,29,42,42,48,48,31,31,0,0,3,3,60,60,6,6,5,5,5,5,43,43,34,34,29,29,24,24,28,28,40,40,59,59,32,32,43,43,57,57,2,2,46,46,32,32,50,50,54,54,51,51,50,50,1,1,55,55,18,18,12,12,4,4,24,24,55,55,50,50,30,30,63,63,36,36,15,15,1,1,16,16,15,15,61,61,17,17,62,62,9,9,28,28,10,10,5,5,47,47,1,1,44,44,19,19,19,19,16,16,33,33,39,39,34,34,59,59,36,36,27,27,32,32,20,20,12,12,54,54,17,17,37,37,20,20,45,45,38,38,6,6,31,31,8,8,9,9,8,8,57,57,43,43,33,33,19,19,32,32,46,46,50,50,31,31,43,43,39,39,54,54,17,17,33,33,20,20,35,35,59,59,4,4,49,49,50,50,39,39,63,63,23,23,26,26,54,54,36,36,47,47,44,44,1,1,40,40,47,47,11,11,20,20,30,30,39,39,8,8,29,29,33,33,54,54,4,4,0,0,18,18,58,58,41,41,27,27,21,21,60,60,19,19,36,36,61,61,18,18,21,21,17,17,6,6,42,42,43,43,16,16,40,40,46,46,20,20,54,54,60,60,59,59,33,33,48,48,35,35,48,48,35,35,7,7,31,31,54,54,47,47,36,36,50,50,25,25,20,20,34,34,58,58,12,12,48,48,57,57,32,32,53,53,16,16,50,50,6,6,31,31,8,8,22,22,55,55,16,16,45,45,37,37,11,11,13,13,26,26,4,4,10,10,19,19,47,47,48,48,20,20,49,49,39,39,51,51,63,63,23,23,3,3,38,38,37,37,26,26,32,32,32,32,4,4,29,29,20,20,22,22,8,8,36,36,13,13,55,55,44,44,10,10,20,20,13,13,13,13,31,31,7,7,25,25,57,57,31,31,40,40,61,61,19,19,0,0,56,56,62,62,40,40,12,12,10,10,60,60,14,14,38,38,16,16,14,14,41,41,6,6,4,4,63,63,6,6,49,49,50,50,38,38,43,43,55,55,26,26,48,48,28,28,33,33,37,37,15,15,42,42,45,45,3,3,42,42,63,63,57,57,25,25,27,27,26,26,50,50,28,28,23,23,24,24,14,14,29,29,24,24,27,27,0,0,28,28,13,13,63,63,36,36,63,63,36,36,18,18,18,18,56,56,14,14,60,60,45,45,24,24,32,32,8,8,14,14,48,48,10,10,19,19,61,61,20,20,19,19,37,37,13,13,28,28,5,5,19,19,11,11,19,19,8,8,3,3,56,56,26,26,53,53,9,9,5,5,15,15,51,51,14,14,6,6,10,10,52,52,50,50,36,36,9,9,5,5,4,4,38,38,29,29,41,41,32,32,28,28,8,8,37,37,34,34,40,40,30,30,19,19,26,26,13,13,2,2,9,9,13,13,56,56,22,22,16,16,36,36,20,20,39,39,62,62,10,10,40,40,1,1,25,25,18,18,45,45,26,26,42,42,29,29,21,21,54,54,4,4,18,18,28,28,60,60,35,35,52,52,61,61,38,38,35,35,18,18,30,30,55,55,33,33,40,40,14,14,61,61,52,52,38,38,7,7,13,13,9,9,11,11,50,50,26,26,49,49,18,18,1,1,9,9,21,21,57,57,26,26,3,3,25,25,4,4,18,18,59,59,45,45,49,49,25,25,32,32,32,32,52,52,8,8,50,50,8,8,29,29,4,4,24,24,11,11,63,63,24,24,14,14,20,20,54,54,12,12,11,11,36,36,56,56,51,51,3,3,62,62,21,21,31,31,44,44,12,12,9,9,13,13,21,21,1,1,20,20,28,28,28,28,5,5,25,25,12,12,58,58,49,49,20,20,50,50,60,60,2,2,40,40,11,11,10,10,49,49,8,8,18,18,10,10,21,21,26,26,10,10,56,56,51,51,48,48,40,40,29,29,29,29,39,39,44,44,56,56,7,7,8,8,21,21,28,28,33,33,6,6,29,29,10,10,53,53,2,2,44,44,16,16,26,26,32,32,4,4,12,12,44,44,17,17,37,37,14,14,12,12,12,12,34,34,49,49,39,39,15,15,6,6,52,52,16,16,18,18,45,45,54,54,48,48,0,0,32,32,1,1,25,25,0,0,36,36,20,20,16,16,25,25,53,53,40,40,0,0,52,52,6,6,48,48,52,52,42,42,54,54,53,53,16,16,4,4,51,51,50,50,35,35,40,40,19,19,57,57,53,53,15,15,56,56,34,34,19,19,11,11,9,9,10,10,49,49,56,56,38,38,11,11,44,44,59,59,54,54,0,0,25,25,25,25,55,55,26,26,4,4,20,20,52,52,32,32,51,51,7,7,26,26,1,1,34,34,43,43,14,14,1,1,4,4,63,63,37,37,22,22,19,19,56,56,43,43,56,56,51,51,36,36,29,29,23,23,12,12,41,41,7,7,12,12,25,25,63,63,50,50,44,44,21,21,3,3,27,27,41,41,60,60,23,23,28,28,34,34,27,27,7,7,55,55,40,40,34,34,25,25,18,18,23,23,27,27,13,13,56,56,7,7,44,44,34,34,42,42,11,11,56,56,37,37,32,32,62,62,21,21,49,49,51,51,40,40,5,5,54,54,26,26,61,61,2,2,60,60,19,19,0,0,5,5,34,34,6,6,28,28,20,20,37,37,41,41,46,46,28,28,55,55,1,1,6,6,36,36,35,35,25,25,61,61,32,32,47,47,9,9,33,33,55,55,36,36,62,62,31,31,33,33,8,8,18,18,35,35,44,44,20,20,53,53,24,24,42,42,14,14,39,39,36,36,1,1,44,44,61,61,8,8,9,9,34,34,43,43,59,59,4,4,20,20,26,26,2,2,7,7,45,45,28,28,32,32,37,37,2,2,3,3,49,49,18,18,61,61,18,18,19,19,9,9,19,19,57,57,50,50,5,5,43,43,2,2,51,51,45,45,44,44,39,39,14,14,5,5,28,28,13,13,48,48,42,42,28,28,60,60,52,52,29,29,30,30,31,31,49,49,63,63,57,57,10,10,28,28,55,55,12,12,31,31,4,4,4,4,15,15,49,49,16,16,6,6,54,54,24,24,56,56,7,7,11,11,13,13,10,10,37,37,33,33,13,13,31,31,58,58,43,43,36,36,34,34,6,6,63,63,18,18,31,31,56,56,51,51,52,52,35,35,15,15,56,56,16,16,32,32,26,26,15,15,0,0,0,0,15,15,2,2,29,29,45,45,7,7,19,19,25,25,6,6,36,36,50,50,13,13,34,34,0,0,62,62,57,57,62,62,19,19,7,7,2,2,20,20,31,31,49,49,12,12,53,53,62,62,20,20,15,15,55,55,37,37,10,10,0,0,38,38,43,43,47,47,58,58,6,6,22,22,41,41,21,21,50,50,20,20,14,14,23,23,6,6,12,12,4,4,10,10,7,7,5,5,0,0,29,29,37,37,27,27,14,14,47,47,45,45,2,2,47,47,55,55,25,25,15,15,55,55,45,45,32,32,4,4,2,2,17,17,23,23,33,33,30,30,58,58,11,11,31,31,55,55,2,2,1,1,11,11,5,5,48,48,34,34,39,39,34,34,45,45,0,0,9,9,59,59,8,8,36,36,41,41,44,44,31,31,34,34,42,42,60,60,4,4,3,3,6,6,19,19,36,36,58,58,10,10,13,13,40,40,0,0,45,45,16,16,0,0,52,52,16,16,44,44,49,49,47,47,7,7,48,48,56,56,57,57,44,44,1,1,43,43,9,9,30,30,27,27,32,32,62,62,43,43,54,54,49,49,61,61,58,58,50,50,45,45,10,10,60,60,32,32,7,7,61,61,6,6,56,56,14,14,58,58,27,27,8,8,22,22,47,47,60,60,15,15,5,5,57,57,0,0,52,52,23,23,0,0,34,34,14,14,29,29,5,5,0,0,59,59,53,53,37,37,44,44,25,25,3,3,39,39,52,52,29,29,1,1,30,30,4,4,57,57,15,15,4,4,28,28,48,48,29,29,34,34,36,36,50,50,57,57,1,1,49,49,47,47,53,53,36,36,57,57,48,48,56,56,3,3,46,46,1,1,43,43,35,35,35,35,10,10,55,55,43,43,62,62,4,4,55,55,39,39,58,58,62,62,39,39,32,32,52,52,18,18,8,8,8,8,28,28,46,46,25,25,19,19,44,44,61,61,35,35,54,54,34,34,30,30,22,22,27,27,38,38,23,23,26,26,45,45,13,13,28,28,63,63,23,23,5,5,22,22,3,3,31,31,44,44,45,45,35,35,3,3,10,10,49,49,31,31,45,45,0,0,20,20,13,13,53,53,37,37,54,54,36,36,54,54,56,56,5,5,45,45,37,37,32,32,20,20,0,0,32,32,48,48,56,56,58,58,39,39,59,59,23,23,30,30,16,16,41,41,54,54,50,50,44,44,56,56,48,48,13,13,53,53,16,16,3,3,37,37,63,63,17,17,15,15,32,32,39,39,17,17,61,61,2,2,31,31,46,46,59,59,43,43,17,17,20,20,10,10,23,23,23,23,35,35,55,55,45,45,11,11,1,1,4,4,2,2,53,53,8,8,36,36,63,63,23,23,43,43,33,33,5,5,44,44,51,51,15,15,22,22,16,16,5,5,46,46,30,30,58,58,34,34,62,62,51,51,19,19,13,13,22,22,35,35,44,44,43,43,52,52,37,37,16,16,39,39,14,14,13,13,14,14,26,26,51,51,62,62,51,51,48,48,59,59,32,32,52,52,0,0,8,8,25,25,62,62,1,1,50,50,17,17,39,39,0,0,23,23,33,33,3,3,3,3,0,0,21,21,41,41,59,59,10,10,34,34,49,49,60,60,6,6,12,12,3,3,5,5,1,1,1,1,62,62,8,8,6,6,51,51,31,31,58,58,12,12,2,2,12,12,29,29,22,22,15,15,22,22,42,42,6,6,31,31,14,14,3,3,8,8,52,52,19,19,35,35,43,43,32,32,20,20,4,4,33,33,29,29,32,32,19,19,43,43,39,39,4,4,21,21,52,52,20,20,28,28,31,31,56,56,57,57,50,50,42,42,35,35,15,15,0,0,42,42,21,21,3,3,31,31,44,44,58,58,61,61,6,6,2,2,51,51,58,58,30,30,23,23,0,0,28,28,5,5,6,6,54,54,18,18,6,6,4,4,57,57,12,12,54,54,51,51,4,4,24,24,26,26,17,17,29,29,42,42,8,8,17,17,51,51,54,54,29,29,0,0,21,21,11,11,63,63,59,59,6,6,34,34,3,3,41,41,52,52,45,45,13,13,48,48,30,30,44,44,57,57,3,3,51,51,48,48,14,14,0,0,33,33,47,47,36,36,28,28,26,26,24,24,11,11,5,5,32,32,24,24,47,47,48,48,20,20,5,5,62,62,19,19,34,34,43,43,48,48,0,0,8,8,33,33,28,28,9,9,18,18,56,56,1,1,49,49,41,41,49,49,59,59,19,19,36,36,53,53,8,8,61,61,33,33,60,60,35,35,58,58,56,56,24,24,0,0,16,16,8,8,61,61,13,13,52,52,26,26,2,2,5,5,32,32,32,32,63,63,14,14,62,62,8,8,57,57,57,57,34,34,40,40,7,7,3,3,15,15,39,39,62,62,49,49,27,27,32,32,14,14,32,32,44,44,1,1,21,21,49,49,22,22,2,2,53,53,33,33,27,27,20,20,34,34,49,49,24,24,34,34,61,61,60,60,29,29,2,2,36,36,18,18,19,19,10,10,14,14,29,29,53,53,48,48,8,8,53,53,62,62,13,13,4,4,59,59,12,12,33,33,1,1,39,39,20,20,63,63,10,10,15,15,48,48,17,17,52,52,50,50,29,29,30,30,26,26,14,14,33,33,9,9,3,3,2,2,5,5,26,26,2,2,58,58,21,21,58,58,26,26,9,9,23,23,51,51,17,17,59,59,16,16,41,41,10,10,0,0,53,53,63,63,62,62,1,1,22,22,4,4,40,40,25,25,56,56,47,47,26,26,28,28,54,54,27,27,13,13,49,49,5,5,21,21,9,9,28,28,25,25,53,53,12,12,37,37,4,4,6,6,16,16,51,51,52,52,35,35,12,12,37,37,21,21,53,53,17,17,15,15,23,23,41,41,12,12,12,12,61,61,40,40,61,61,5,5,10,10,16,16,59,59,8,8,18,18,3,3,28,28,10,10,9,9,53,53,32,32,5,5,55,55,58,58,45,45,45,45,16,16,0,0,20,20,20,20,49,49,27,27,27,27,41,41,11,11,38,38,54,54,32,32,8,8,44,44,46,46,33,33,11,11,54,54,45,45,53,53,18,18,49,49,38,38,3,3,36,36,28,28,28,28,24,24,1,1,55,55,48,48,0,0,7,7,26,26,11,11,54,54,34,34,46,46,38,38,2,2,27,27,11,11,38,38,5,5,50,50,13,13,25,25,43,43,50,50,60,60,47,47,20,20,59,59,34,34,10,10,40,40,50,50,52,52,19,19,17,17,1,1,33,33,41,41,1,1,25,25,23,23,10,10,63,63,25,25,0,0,38,38,14,14,18,18,61,61,48,48,54,54,47,47,48,48,62,62,2,2,29,29,41,41,21,21,29,29,24,24,58,58,17,17,30,30,3,3,0,0,54,54,1,1,34,34,53,53,10,10,46,46,39,39,38,38,40,40,28,28,40,40,30,30,48,48,9,9,51,51,32,32,24,24,33,33,62,62,59,59,56,56,47,47,62,62,45,45,2,2,6,6,51,51,54,54,59,59,45,45,13,13,49,49,9,9,36,36,24,24,1,1,50,50,62,62,20,20,62,62,61,61,9,9,40,40,1,1,14,14,2,2,34,34,50,50,15,15,23,23,34,34,23,23,61,61,44,44,1,1,35,35,40,40,9,9,9,9,7,7,27,27,22,22,8,8,29,29,25,25,17,17,53,53,61,61,37,37,4,4,40,40,39,39,48,48,15,15,54,54,45,45,49,49,50,50,23,23,21,21,22,22,40,40,9,9,2,2,2,2,26,26,45,45,44,44,3,3,40,40,40,40,48,48,37,37,8,8,39,39,49,49,35,35,54,54,52,52,54,54,24,24,48,48,25,25,26,26,49,49,33,33,21,21,0,0,4,4,0,0,52,52,6,6,4,4,28,28,35,35,46,46,13,13,44,44,1,1,0,0,25,25,11,11,45,45,40,40,20,20,15,15,34,34,5,5,28,28,20,20,44,44,22,22,39,39,30,30,62,62,51,51,28,28,37,37,45,45,16,16,49,49,51,51,7,7,18,18,56,56,6,6,2,2,28,28,25,25,13,13,22,22,62,62,55,55,19,19,53,53,26,26,25,25,33,33,33,33,22,22,9,9,48,48,11,11,35,35,20,20,45,45,15,15,31,31,8,8,52,52,41,41,30,30,23,23,58,58,14,14,24,24,37,37,40,40,12,12,54,54,26,26,3,3,39,39,8,8,35,35,55,55,53,53,60,60,41,41,10,10,23,23,63,63,1,1,50,50,25,25,45,45,38,38,13,13,17,17,57,57,61,61,10,10,39,39,0,0,22,22,50,50,38,38,43,43,39,39,20,20,33,33,41,41,23,23,46,46,3,3,48,48,27,27,57,57,28,28,12,12,57,57,48,48,37,37,4,4,56,56,47,47,61,61,52,52,38,38,8,8,36,36,9,9,32,32,37,37,50,50,3,3,2,2,17,17,1,1,53,53,11,11,20,20,62,62,2,2,56,56,12,12,43,43,39,39,11,11,0,0,3,3,42,42,16,16,11,11,6,6,36,36,60,60,19,19,45,45,30,30,8,8,63,63,40,40,61,61,60,60,10,10,21,21,14,14,60,60,61,61,8,8,35,35,19,19,4,4,9,9,51,51,13,13,43,43,2,2,33,33,2,2,34,34,15,15,15,15,61,61,2,2,54,54,53,53,31,31,27,27,40,40,26,26,30,30,59,59,22,22,9,9,15,15,50,50,16,16,18,18,8,8,18,18,22,22,8,8,54,54,2,2,24,24,17,17,62,62,22,22,9,9,50,50,29,29,21,21,5,5,28,28,58,58,17,17,16,16,4,4,46,46,23,23,57,57,24,24,26,26,10,10,49,49,2,2,6,6,51,51,9,9,19,19,32,32,39,39,52,52,35,35,7,7,22,22,56,56,54,54,14,14,43,43,63,63,33,33,2,2,61,61,62,62,11,11,7,7,9,9,11,11,25,25,18,18,19,19,40,40,11,11,59,59,41,41,54,54,13,13,0,0,48,48,21,21,11,11,22,22,49,49,34,34,5,5,44,44,21,21,20,20,59,59,39,39,43,43,14,14,16,16,4,4,55,55,25,25,50,50,43,43,24,24,29,29,15,15,29,29,6,6,16,16,59,59,50,50,20,20,41,41,2,2,54,54,1,1,46,46,37,37,28,28,35,35,4,4,9,9,36,36,3,3,36,36,14,14,20,20,10,10,7,7,30,30,56,56,14,14,1,1,13,13,17,17,29,29,57,57,44,44,30,30,56,56,27,27,45,45,41,41,57,57,44,44,28,28,14,14,32,32,5,5,32,32,52,52,31,31,44,44,59,59,4,4,33,33,8,8,3,3,21,21,0,0,55,55,30,30,41,41,56,56,5,5,3,3,49,49,10,10,47,47,1,1,19,19,0,0,57,57,30,30,22,22,45,45,25,25,63,63,51,51,13,13,13,13,26,26,58,58,12,12,40,40,7,7,50,50,22,22,14,14,11,11,17,17,30,30,34,34,16,16,30,30,12,12,36,36,51,51,0,0,26,26,34,34,20,20,25,25,34,34,54,54,40,40,42,42,49,49,8,8,20,20,36,36,57,57,39,39,49,49,24,24,26,26,59,59,10,10,56,56,54,54,54,54,22,22,61,61,7,7,16,16,63,63,23,23,29,29,3,3,11,11,58,58,33,33,19,19,33,33,60,60,48,48,41,41,47,47,53,53,11,11,58,58,37,37,24,24,2,2,28,28,45,45,12,12,56,56,43,43,12,12,35,35,52,52,32,32,37,37,47,47,49,49,27,27,4,4,2,2,63,63,12,12,12,12,44,44,13,13,20,20,20,20,35,35,18,18,29,29,51,51,61,61,12,12,36,36,7,7,18,18,11,11,32,32,46,46,21,21,56,56,58,58,28,28,9,9,17,17,36,36,52,52,31,31,2,2,26,26,22,22,56,56,33,33,59,59,0,0,40,40,20,20,46,46,4,4,63,63,8,8,31,31,40,40,22,22,52,52,12,12,25,25,25,25,6,6,23,23,56,56,35,35,45,45,27,27,17,17,36,36,58,58,45,45,19,19,57,57,37,37,37,37,47,47,13,13,57,57,5,5,49,49,37,37,11,11,35,35,34,34,37,37,52,52,42,42,61,61,19,19,15,15,35,35,19,19,11,11,15,15,23,23,13,13,42,42,19,19,43,43,15,15,60,60,47,47,2,2,24,24,6,6,16,16,48,48,11,11,4,4,57,57,39,39,45,45,58,58,56,56,38,38,57,57,4,4,38,38,19,19,5,5,47,47,1,1,59,59,48,48,58,58,2,2,30,30,43,43,4,4,2,2,17,17,14,14,49,49,0,0,40,40,27,27,60,60,43,43,14,14,61,61,17,17,14,14,36,36,20,20,45,45,13,13,52,52,3,3,3,3,1,1,4,4,15,15,41,41,53,53,42,42,46,46,54,54,31,31,1,1,33,33,38,38,34,34,40,40,45,45,36,36,35,35,56,56,24,24,14,14,6,6,54,54,15,15,5,5,60,60,59,59,48,48,34,34,0,0,6,6,26,26,63,63,54,54,24,24,6,6,39,39,60,60,4,4,7,7,36,36,28,28,46,46,37,37,54,54,44,44,20,20,31,31,39,39,38,38,18,18,18,18,54,54,6,6,17,17,10,10,42,42,60,60,59,59,21,21,45,45,59,59,0,0,10,10,61,61,52,52,31,31,11,11,43,43,25,25,20,20,11,11,2,2,62,62,60,60,31,31,10,10,25,25,3,3,48,48,34,34,48,48,54,54,62,62,1,1,44,44,32,32,29,29,6,6,12,12,36,36,52,52,5,5,35,35,38,38,56,56,10,10,39,39,38,38,10,10,42,42,31,31,35,35,32,32,28,28,57,57,41,41,35,35,41,41,44,44,55,55,21,21,42,42,50,50,45,45,42,42,29,29,35,35,0,0,23,23,11,11,2,2,1,1,33,33,36,36,35,35,7,7,8,8,35,35,53,53,33,33,37,37,35,35,34,34,57,57,11,11,3,3,10,10,61,61,38,38,38,38,4,4,4,4,6,6,34,34,44,44,0,0,31,31,5,5,60,60,61,61,62,62,5,5,7,7,33,33,55,55,11,11,3,3,42,42,16,16,61,61,56,56,39,39,28,28,18,18,41,41,19,19,57,57,19,19,22,22,36,36,44,44,59,59,48,48,1,1,27,27,40,40,24,24,38,38,18,18,48,48,33,33,34,34,55,55,1,1,12,12,3,3,4,4,40,40,19,19,25,25,9,9,16,16,34,34,16,16,10,10,48,48,2,2,35,35,0,0,42,42,58,58,29,29,47,47,22,22,42,42,9,9,36,36,0,0,57,57,51,51,5,5,36,36,15,15,6,6,8,8,48,48,38,38,16,16,12,12,11,11,60,60,54,54,52,52,17,17,1,1,42,42,19,19,17,17,12,12,3,3,35,35,9,9,58,58,27,27,10,10,40,40,28,28,23,23,61,61,8,8,14,14,16,16,14,14,20,20,23,23,59,59,14,14,27,27,44,44,10,10,45,45,29,29,43,43,38,38,3,3,9,9,36,36,53,53,35,35,40,40,4,4,29,29,53,53,0,0,50,50,60,60,26,26,35,35,17,17,12,12,28,28,47,47,53,53,29,29,24,24,11,11,46,46,25,25,22,22,24,24,39,39,1,1,45,45,8,8,1,1,46,46,1,1,45,45,48,48,28,28,13,13,32,32,28,28,24,24,56,56,55,55,1,1,21,21,25,25,16,16,30,30,18,18,21,21,36,36,37,37,1,1,18,18,9,9,53,53,29,29,26,26,5,5,25,25,33,33,27,27,2,2,47,47,38,38,55,55,19,19,57,57,49,49,6,6,2,2,47,47,52,52,12,12,10,10,1,1,13,13,52,52,39,39,27,27,11,11,40,40,60,60,47,47,13,13,52,52,6,6,12,12,48,48,61,61,50,50,63,63,41,41,45,45,13,13,56,56,34,34,36,36,1,1,32,32,2,2,39,39,34,34,5,5,39,39,10,10,51,51,41,41,6,6,8,8,3,3,6,6,22,22,31,31,40,40,46,46,30,30,57,57,17,17,56,56,37,37,19,19,23,23,39,39,63,63,3,3,46,46,43,43,33,33,23,23,28,28,60,60,38,38,26,26,26,26,17,17,8,8,24,24,63,63,43,43,21,21,19,19,30,30,23,23,33,33,26,26,27,27,27,27,32,32,41,41,20,20,48,48,46,46,12,12,60,60,13,13,53,53,15,15,12,12,31,31,42,42,13,13,31,31,59,59,39,39,53,53,26,26,23,23,29,29,4,4,17,17,26,26,29,29,28,28,7,7,39,39,30,30,0,0,36,36,37,37,6,6,23,23,23,23,27,27,62,62,31,31,41,41,53,53,57,57,20,20,53,53,36,36,34,34,6,6,51,51,23,23,43,43,53,53,17,17,30,30,17,17,35,35,25,25,8,8,6,6,35,35,59,59,17,17,6,6,44,44,32,32,16,16,61,61,11,11,48,48,54,54,6,6,22,22,35,35,6,6,19,19,25,25,33,33,0,0,38,38,2,2,18,18,37,37,3,3,5,5,49,49,42,42,50,50,31,31,2,2,1,1,45,45,9,9,63,63,22,22,18,18,59,59,13,13,1,1,18,18,16,16,16,16,8,8,44,44,11,11,59,59,60,60,20,20,57,57,17,17,58,58,24,24,35,35,32,32,61,61,10,10,16,16,14,14,51,51,21,21,6,6,42,42,20,20,59,59,8,8,49,49,15,15,59,59,29,29,32,32,26,26,7,7,34,34,35,35,51,51,52,52,23,23,47,47,44,44,51,51,6,6,4,4,40,40,4,4,58,58,49,49,33,33,23,23,2,2,48,48,25,25,31,31,40,40,25,25,6,6,19,19,48,48,42,42,52,52,39,39,23,23,7,7,18,18,51,51,2,2,12,12,13,13,41,41,35,35,46,46,8,8,25,25,18,18,8,8,42,42,28,28,7,7,14,14,13,13,53,53,31,31,50,50,59,59,33,33,21,21,0,0,2,2,34,34,16,16,33,33,24,24,53,53,51,51,42,42,36,36,60,60,17,17,11,11,21,21,19,19,48,48,55,55,29,29,49,49,22,22,52,52,18,18,53,53,43,43,28,28,51,51,54,54,29,29,51,51,24,24,0,0,58,58,22,22,1,1,26,26,48,48,0,0,20,20,8,8,37,37,62,62,0,0,11,11,49,49,4,4,48,48,55,55,32,32,8,8,1,1,40,40,29,29,38,38,49,49,33,33,24,24,22,22,55,55,1,1,13,13,45,45,21,21,12,12,62,62,7,7,60,60,47,47,14,14,59,59,27,27,16,16,9,9,62,62,33,33,49,49,63,63,17,17,7,7,31,31,61,61,39,39,60,60,5,5,8,8,42,42,16,16,48,48,29,29,44,44,48,48,56,56,0,0,53,53,61,61,30,30,32,32,41,41,10,10,44,44,58,58,27,27,3,3,47,47,49,49,50,50,27,27,53,53,7,7,13,13,44,44,6,6,44,44,43,43,31,31,58,58,8,8,11,11,36,36,31,31,32,32,33,33,10,10,56,56,14,14,62,62,26,26,12,12,7,7,4,4,33,33,30,30,22,22,26,26,18,18,60,60,60,60,25,25,6,6,24,24,39,39,50,50,9,9,25,25,28,28,39,39,54,54,59,59,15,15,24,24,61,61,32,32,24,24,40,40,47,47,10,10,49,49,40,40,44,44,5,5,57,57,22,22,25,25,5,5,1,1,1,1,59,59,32,32,0,0,6,6,12,12,55,55,5,5,63,63,30,30,15,15,30,30,5,5,18,18,26,26,2,2,42,42,43,43,48,48,24,24,14,14,2,2,36,36,8,8,35,35,8,8,19,19,34,34,7,7,32,32,27,27,6,6,22,22,2,2,4,4,34,34,56,56,23,23,9,9,19,19,3,3,57,57,7,7,11,11,32,32,0,0,44,44,47,47,50,50,61,61,63,63,47,47,60,60,38,38,11,11,33,33,62,62,35,35,37,37,11,11,40,40,58,58,25,25,59,59,56,56,13,13,43,43,39,39,18,18,28,28,51,51,40,40,4,4,45,45,62,62,7,7,5,5,35,35,51,51,4,4,22,22,28,28,22,22,60,60,51,51,62,62,3,3,34,34,62,62,9,9,50,50,9,9,61,61,18,18,60,60,37,37,51,51,13,13,4,4,53,53,24,24,51,51,16,16,14,14,42,42,18,18,51,51,23,23,37,37,32,32,57,57,24,24,22,22,8,8,5,5,3,3,28,28,14,14,54,54,52,52,11,11,30,30,30,30,17,17,36,36,36,36,45,45,35,35,13,13,8,8,17,17,23,23,1,1,11,11,28,28,37,37,44,44,10,10,36,36,46,46,45,45,28,28,31,31,31,31,4,4,9,9,1,1,33,33,17,17,35,35,48,48,6,6,15,15,47,47,56,56,16,16,10,10,30,30,18,18,15,15,63,63,13,13,2,2,17,17,19,19,52,52,62,62,26,26,63,63,27,27,51,51,24,24,58,58,53,53,8,8,31,31,11,11,12,12,55,55,56,56,7,7,7,7,13,13,0,0,4,4,43,43,8,8,22,22,59,59,2,2,62,62,10,10,49,49,36,36,24,24,14,14,38,38,51,51,21,21,17,17,7,7,39,39,32,32,61,61,39,39,29,29,24,24,44,44,23,23,63,63,35,35,10,10,34,34,58,58,4,4,13,13,38,38,11,11,63,63,27,27,10,10,51,51,10,10,2,2,0,0,33,33,51,51,40,40,21,21,16,16,13,13,56,56,16,16,31,31,36,36,48,48,9,9,2,2,33,33,45,45,1,1,4,4,12,12,61,61,5,5,15,15,12,12,6,6,8,8,21,21,50,50,7,7,16,16,36,36,56,56,8,8,53,53,45,45,36,36,23,23,29,29,60,60,34,34,1,1,22,22,52,52,25,25,36,36,45,45,41,41,10,10,35,35,26,26,2,2,40,40,7,7,6,6,30,30,13,13,48,48,25,25,48,48,23,23,38,38,9,9,9,9,46,46,40,40,20,20,27,27,39,39,2,2,57,57,26,26,33,33,58,58,40,40,30,30,5,5,19,19,38,38,6,6,12,12,0,0,40,40,28,28,5,5,40,40,39,39,48,48,2,2,28,28,16,16,46,46,21,21,10,10,5,5,42,42,60,60,22,22,36,36,6,6,17,17,0,0,48,48,50,50,33,33,49,49,1,1,54,54,50,50,15,15,29,29,33,33,52,52,21,21,17,17,7,7,50,50,29,29,56,56,5,5,23,23,11,11,2,2,9,9,51,51,24,24,52,52,23,23,25,25,29,29,39,39,58,58,26,26,48,48,14,14,21,21,25,25,7,7,21,21,48,48,57,57,37,37,59,59,20,20,27,27,27,27,35,35,46,46,51,51,4,4,11,11,44,44,40,40,50,50,40,40,4,4,9,9,54,54,7,7,38,38,27,27,29,29,40,40,22,22,6,6,43,43,56,56,2,2,35,35,48,48,36,36,12,12,23,23,29,29,23,23,13,13,1,1,21,21,38,38,43,43,46,46,38,38,24,24,18,18,32,32,35,35,27,27,6,6,22,22,57,57,24,24,40,40,19,19,53,53,16,16,33,33,9,9,2,2,18,18,34,34,24,24,44,44,63,63,29,29,26,26,21,21,50,50,1,1,12,12,7,7,57,57,39,39,8,8,34,34,6,6,23,23,27,27,8,8,42,42,27,27,12,12,20,20,53,53,26,26,25,25,39,39,20,20,8,8,3,3,45,45,14,14,36,36,24,24,23,23,51,51,31,31,58,58,11,11,8,8,21,21,31,31,42,42,62,62,34,34,23,23,17,17,5,5,19,19,63,63,43,43,5,5,41,41,9,9,41,41,37,37,48,48,50,50,23,23,24,24,6,6,25,25,0,0,4,4,43,43,16,16,63,63,8,8,56,56,2,2,1,1,19,19,10,10,24,24,55,55,24,24,2,2,33,33,19,19,55,55,0,0,30,30,48,48,37,37,35,35,1,1,23,23,13,13,13,13,39,39,42,42,53,53,37,37,54,54,32,32,6,6,60,60,42,42,56,56,49,49,41,41,53,53,46,46,7,7,32,32,35,35,24,24,0,0,48,48,40,40,4,4,25,25,27,27,18,18,4,4,22,22,10,10,38,38,17,17,49,49,37,37,38,38,35,35,6,6,54,54,25,25,33,33,48,48,41,41,52,52,48,48,61,61,11,11,48,48,4,4,34,34,14,14,32,32,17,17,55,55,43,43,63,63,53,53,46,46,24,24,43,43,8,8,47,47,54,54,39,39,12,12,45,45,17,17,28,28,51,51,47,47,47,47,1,1,17,17,48,48,63,63,5,5,52,52,39,39,51,51,41,41,25,25,12,12,18,18,50,50,50,50,14,14,18,18,21,21,2,2,60,60,19,19,32,32,35,35,25,25,48,48,0,0,16,16,4,4,29,29,52,52,49,49,39,39,1,1,50,50,25,25,17,17,23,23,49,49,0,0,5,5,17,17,36,36,36,36,48,48,36,36,45,45,17,17,2,2,5,5,30,30,11,11,59,59,36,36,53,53,28,28,29,29,9,9,32,32,63,63,50,50,56,56,13,13,49,49,30,30,45,45,5,5,60,60,52,52,38,38,28,28,24,24,0,0,25,25,49,49,59,59,3,3,2,2,45,45,4,4,9,9,37,37,26,26,42,42,10,10,45,45,49,49,17,17,49,49,58,58,54,54,49,49,11,11,29,29,54,54,40,40,63,63,49,49,4,4,50,50,47,47,14,14,35,35,25,25,43,43,2,2,14,14,35,35,32,32,13,13,7,7,0,0,11,11,5,5,22,22,56,56,62,62,54,54,32,32,26,26,58,58,60,60,7,7,20,20,0,0,10,10,27,27,60,60,21,21,53,53,14,14,24,24,29,29,24,24,15,15,60,60,43,43,15,15,50,50,61,61,58,58,27,27,59,59,31,31,0,0,13,13,38,38,50,50,34,34,60,60,55,55,62,62,25,25,56,56,37,37,4,4,37,37,8,8,31,31,42,42,56,56,10,10,21,21,53,53,61,61,1,1,46,46,25,25,52,52,25,25,44,44,39,39,7,7,5,5,39,39,15,15,54,54,63,63,21,21,16,16,32,32,31,31,2,2,12,12,48,48,8,8,17,17,18,18,38,38,40,40,24,24,40,40,32,32,1,1,14,14,16,16,24,24,0,0,16,16,28,28,63,63,49,49,22,22,57,57,7,7,10,10,19,19,39,39,9,9,13,13,29,29,37,37,34,34,61,61,7,7,30,30,39,39,26,26,15,15,54,54,3,3,36,36,13,13,15,15,63,63,10,10,21,21,26,26,2,2,22,22,5,5,23,23,33,33,40,40,46,46,60,60,8,8,1,1,4,4,45,45,15,15,19,19,49,49,18,18,38,38,13,13,1,1,52,52,10,10,10,10,27,27,8,8,16,16,20,20,25,25,9,9,24,24,1,1,48,48,40,40,50,50,29,29,55,55,36,36,1,1,17,17,4,4,45,45,61,61,42,42,5,5,23,23,6,6,37,37,52,52,56,56,31,31,41,41,5,5,61,61,9,9,19,19,39,39,56,56,36,36,4,4,50,50,63,63,42,42,16,16,5,5,2,2,39,39,52,52,51,51,45,45,36,36,40,40,34,34,3,3,60,60,25,25,10,10,31,31,54,54,30,30,55,55,21,21,27,27,25,25,4,4,51,51,24,24,59,59,59,59,8,8,41,41,36,36,53,53,12,12,8,8,9,9,19,19,37,37,36,36,57,57,37,37,1,1,48,48,27,27,30,30,53,53,9,9,44,44,3,3,56,56,30,30,32,32,17,17,9,9,48,48,20,20,34,34,3,3,33,33,11,11,52,52,10,10,14,14,17,17,19,19,13,13,16,16,16,16,56,56,44,44,51,51,18,18,35,35,19,19,61,61,23,23,30,30,30,30,39,39,15,15,10,10,8,8,6,6,55,55,11,11,44,44,7,7,38,38,63,63,11,11,56,56,30,30,2,2,4,4,51,51,36,36,40,40,36,36,53,53,24,24,23,23,15,15,36,36,0,0,15,15,38,38,10,10,41,41,18,18,10,10,37,37,35,35,4,4,54,54,30,30,30,30,25,25,32,32,56,56,36,36,13,13,47,47,54,54,43,43,23,23,54,54,42,42,26,26,11,11,47,47,22,22,31,31,8,8,21,21,57,57,1,1,23,23,21,21,53,53,59,59,26,26,32,32,43,43,3,3,1,1,39,39,49,49,1,1,49,49,49,49,22,22,49,49,20,20,29,29,10,10,16,16,14,14,14,14,35,35,2,2,27,27,49,49,50,50,19,19,15,15,11,11,8,8,5,5,56,56,51,51,33,33,3,3,20,20,39,39,37,37,3,3,18,18,45,45,26,26,21,21,29,29,29,29,27,27,26,26,13,13,24,24,36,36,16,16,50,50,44,44,26,26,19,19,34,34,25,25,17,17,8,8,24,24,22,22,11,11,4,4,32,32,35,35,5,5,52,52,59,59,52,52,2,2,61,61,7,7,8,8,19,19,56,56,18,18,56,56,5,5,38,38,22,22,28,28,36,36,46,46,49,49,14,14,4,4,28,28,9,9,45,45,32,32,21,21,50,50,25,25,16,16,45,45,12,12,21,21,43,43,36,36,56,56,55,55,29,29,36,36,23,23,39,39,41,41,44,44,46,46,46,46,56,56,19,19,8,8,43,43,53,53,59,59,60,60,58,58,50,50,43,43,17,17,28,28,7,7,11,11,48,48,8,8,32,32,33,33,16,16,44,44,1,1,5,5,2,2,42,42,12,12,1,1,43,43,25,25,1,1,5,5,1,1,43,43,28,28,60,60,41,41,20,20,25,25,6,6,60,60,4,4,43,43,2,2,27,27,52,52,16,16,44,44,10,10,58,58,32,32,60,60,33,33,2,2,43,43,49,49,43,43,34,34,47,47,23,23,52,52,4,4,61,61,37,37,41,41,57,57,29,29,34,34,2,2,9,9,8,8,0,0,52,52,40,40,32,32,32,32,34,34,47,47,59,59,25,25,56,56,60,60,21,21,9,9,10,10,30,30,35,35,45,45,14,14,36,36,7,7,9,9,48,48,24,24,16,16,61,61,53,53,29,29,22,22,57,57,8,8,17,17,49,49,9,9,2,2,44,44,50,50,25,25,61,61,17,17,23,23,60,60,52,52,7,7,1,1,46,46,47,47,46,46,8,8,58,58,58,58,10,10,24,24,9,9,16,16,28,28,21,21,10,10,1,1,22,22,61,61,2,2,56,56,53,53,42,42,53,53,29,29,0,0,4,4,56,56,5,5,26,26,9,9,44,44,37,37,34,34,32,32,52,52,27,27,44,44,27,27,35,35,3,3,14,14,4,4,40,40,28,28,52,52,34,34,43,43,13,13,15,15,22,22,62,62,62,62,51,51,63,63,46,46,34,34,18,18,28,28,39,39,25,25,7,7,26,26,10,10,44,44,42,42,38,38,41,41,20,20,37,37,50,50,31,31,3,3,12,12,7,7,56,56,51,51,16,16,12,12,29,29,9,9,41,41,2,2,36,36,47,47,52,52,63,63,25,25,14,14,20,20,8,8,23,23,50,50,5,5,10,10,31,31,3,3,0,0,49,49,48,48,41,41,58,58,5,5,59,59,6,6,24,24,50,50,23,23,57,57,18,18,19,19,22,22,11,11,44,44,13,13,19,19,4,4,13,13,52,52,53,53,30,30,5,5,55,55,20,20,33,33,57,57,62,62,51,51,4,4,56,56,58,58,45,45,52,52,36,36,29,29,22,22,3,3,32,32,37,37,15,15,20,20,11,11,1,1,26,26,56,56,26,26,61,61,8,8,21,21,60,60,28,28,63,63,12,12,35,35,34,34,52,52,25,25,29,29,8,8,27,27,42,42,49,49,8,8,43,43,4,4,41,41,35,35,63,63,11,11,60,60,33,33,38,38,17,17,18,18,0,0,49,49,42,42,9,9,47,47,44,44,5,5,23,23,9,9,44,44,22,22,37,37,40,40,11,11,11,11,12,12,33,33,21,21,60,60,18,18,53,53,30,30,34,34,19,19,21,21,3,3,43,43,23,23,44,44,0,0,1,1,62,62,1,1,51,51,22,22,11,11,42,42,53,53,33,33,48,48,54,54,4,4,41,41,21,21,54,54,43,43,36,36,46,46,18,18,21,21,33,33,38,38,29,29,21,21,39,39,26,26,50,50,24,24,4,4,5,5,19,19,32,32,18,18,46,46,12,12,17,17,45,45,26,26,7,7,9,9,56,56,0,0,10,10,11,11,44,44,48,48,33,33,15,15,27,27,4,4,4,4,10,10,50,50,16,16,51,51,31,31,53,53,22,22,19,19,37,37,44,44,2,2,0,0,54,54,49,49,27,27,11,11,40,40,61,61,55,55,26,26,5,5,34,34,27,27,61,61,18,18,14,14,24,24,18,18,0,0,20,20,4,4,43,43,10,10,9,9,3,3,11,11,23,23,4,4,18,18,52,52,44,44,59,59,55,55,3,3,54,54,3,3,44,44,24,24,12,12,48,48,0,0,9,9,53,53,7,7,18,18,38,38,5,5,50,50,59,59,37,37,49,49,42,42,14,14,0,0,14,14,7,7,15,15,44,44,46,46,60,60,58,58,59,59,14,14,6,6,20,20,55,55,35,35,9,9,50,50,18,18,32,32,43,43,36,36,61,61,57,57,39,39,34,34,19,19,38,38,28,28,32,32,6,6,47,47,53,53,15,15,0,0,17,17,19,19,15,15,46,46,53,53,47,47,62,62,2,2,10,10,25,25,54,54,36,36,18,18,56,56,12,12,27,27,27,27,30,30,49,49,50,50,19,19,7,7,7,7,0,0,54,54,15,15,16,16,15,15,31,31,56,56,33,33,12,12,3,3,30,30,24,24,34,34,44,44,39,39,48,48,41,41,4,4,58,58,32,32,60,60,40,40,36,36,13,13,9,9,30,30,53,53,44,44,60,60,20,20,12,12,0,0,57,57,36,36,29,29,28,28,45,45,48,48,22,22,8,8,4,4,39,39,30,30,30,30,53,53,39,39,30,30,8,8,58,58,25,25,2,2,28,28,30,30,4,4,61,61,3,3,56,56,5,5,42,42,55,55,18,18,27,27,41,41,48,48,46,46,38,38,58,58,2,2,12,12,0,0,28,28,61,61,37,37,41,41,60,60,12,12,5,5,52,52,30,30,11,11,25,25,39,39,48,48,49,49,42,42,46,46,47,47,58,58,20,20,23,23,2,2,39,39,8,8,7,7,1,1,3,3,1,1,6,6,20,20,14,14,34,34,46,46,55,55,30,30,58,58,49,49,49,49,1,1,32,32,12,12,39,39,35,35,50,50,1,1,50,50,7,7,53,53,19,19,53,53,56,56,2,2,57,57,40,40,46,46,5,5,36,36,36,36,28,28,19,19,53,53,33,33,58,58,25,25,56,56,11,11,13,13,4,4,0,0,20,20,9,9,9,9,11,11,29,29,24,24,12,12,18,18,10,10,24,24,54,54,32,32,16,16,39,39,14,14,22,22,1,1,16,16,24,24,40,40,46,46,34,34,20,20,46,46,62,62,18,18,13,13,61,61,12,12,27,27,55,55,28,28,14,14,46,46,57,57,36,36,7,7,44,44,11,11,20,20,15,15,62,62,47,47,17,17,57,57,13,13,53,53,27,27,47,47,17,17,62,62,49,49,19,19,22,22,21,21,31,31,41,41,34,34,25,25,27,27,20,20,53,53,54,54,6,6,2,2,50,50,10,10,13,13,22,22,31,31,48,48,59,59,62,62,40,40,36,36,17,17,19,19,46,46,2,2,24,24,21,21,45,45,26,26,45,45,63,63,40,40,7,7,56,56,63,63,7,7,23,23,38,38,35,35,2,2,27,27,54,54,54,54,12,12,62,62,29,29,47,47,36,36,32,32,41,41,6,6,1,1,50,50,30,30,48,48,6,6,56,56,35,35,52,52,26,26,18,18,14,14,28,28,59,59,2,2,53,53,2,2,6,6,25,25,37,37,40,40,51,51,9,9,15,15,38,38,27,27,54,54,1,1,18,18,36,36,41,41,31,31,59,59,16,16,53,53,59,59,53,53,18,18,5,5,17,17,16,16,32,32,43,43,62,62,7,7,22,22,52,52,2,2,21,21,37,37,63,63,14,14,57,57,44,44,18,18,32,32,53,53,49,49,38,38,30,30,21,21,16,16,38,38,31,31,49,49,7,7,47,47,1,1,41,41,5,5,61,61,40,40,56,56,43,43,36,36,50,50,30,30,38,38,26,26,18,18,2,2,51,51,37,37,46,46,54,54,40,40,18,18,49,49,15,15,45,45,40,40,24,24,24,24,20,20,44,44,33,33,9,9,15,15,6,6,42,42,45,45,16,16,46,46,54,54,3,3,13,13,9,9,40,40,32,32,0,0,17,17,45,45,51,51,9,9,40,40,19,19,56,56,8,8,26,26,6,6,41,41,6,6,42,42,50,50,45,45,31,31,6,6,19,19,36,36,43,43,42,42,59,59,40,40,29,29,29,29,24,24,19,19,7,7,37,37,41,41,17,17,19,19,33,33,25,25,1,1,1,1,8,8,28,28,11,11,27,27,20,20,56,56,42,42,11,11,25,25,52,52,37,37,54,54,19,19,51,51,20,20,53,53,7,7,2,2,19,19,18,18,6,6,18,18,28,28,10,10,51,51,26,26,2,2,47,47,7,7,20,20,5,5,34,34,6,6,34,34,34,34,52,52,7,7,28,28,63,63,19,19,48,48,15,15,56,56,18,18,46,46,24,24,60,60,36,36,44,44,42,42,12,12,46,46,17,17,21,21,47,47,11,11,31,31,5,5,47,47,32,32,0,0,8,8,7,7,58,58,20,20,4,4,60,60,40,40,34,34,21,21,62,62,38,38,62,62,9,9,57,57,21,21,43,43,24,24,14,14,58,58,17,17,28,28,9,9,25,25,58,58,30,30,8,8,60,60,21,21,32,32,38,38,14,14,3,3,34,34,19,19,35,35,45,45,41,41,3,3,12,12,23,23,1,1,53,53,24,24,30,30,57,57,50,50,61,61,48,48,8,8,22,22,16,16,1,1,52,52,2,2,61,61,33,33,47,47,5,5,55,55,27,27,28,28,25,25,13,13,3,3,49,49,12,12,26,26,22,22,40,40,13,13,50,50,27,27,16,16,6,6,40,40,26,26,10,10,31,31,60,60,62,62,62,62,39,39,43,43,12,12,13,13,35,35,34,34,38,38,6,6,1,1,21,21,58,58,47,47,6,6,12,12,32,32,62,62,44,44,42,42,29,29,45,45,22,22,50,50,14,14,1,1,49,49,36,36,61,61,18,18,42,42,26,26,8,8,60,60,9,9,34,34,30,30,11,11,62,62,0,0,57,57,40,40,30,30,9,9,5,5,18,18,18,18,59,59,37,37,3,3,27,27,63,63,41,41,50,50,58,58,56,56,8,8,51,51,56,56,7,7,61,61,21,21,30,30,17,17,54,54,42,42,22,22,29,29,21,21,28,28,25,25,51,51,17,17,12,12,23,23,25,25,49,49,17,17,37,37,47,47,54,54,29,29,44,44,32,32,45,45,62,62,13,13,22,22,49,49,41,41,12,12,21,21,63,63,20,20,17,17,63,63,0,0,52,52,12,12,7,7,4,4,51,51,23,23,16,16,47,47,34,34,53,53,51,51,0,0,17,17,54,54,32,32,7,7,17,17,38,38,54,54,13,13,8,8,25,25,42,42,17,17,37,37,9,9,2,2,14,14,56,56,0,0,1,1,1,1,23,23,44,44,1,1,51,51,61,61,11,11,48,48,33,33,25,25,17,17,45,45,47,47,12,12,40,40,57,57,4,4,25,25,21,21,8,8,19,19,62,62,8,8,37,37,6,6,58,58,4,4,30,30,48,48,52,52,5,5,17,17,0,0,48,48,18,18,34,34,47,47,12,12,62,62,8,8,51,51,57,57,11,11,46,46,23,23,44,44,61,61,0,0,53,53,45,45,11,11,16,16,39,39,37,37,12,12,36,36,40,40,21,21,26,26,11,11,62,62,43,43,34,34,18,18,27,27,7,7,28,28,61,61,34,34,48,48,56,56,3,3,61,61,7,7,15,15,42,42,35,35,49,49,20,20,23,23,32,32,42,42,22,22,32,32,14,14,3,3,19,19,33,33,26,26,20,20,56,56,6,6,22,22,32,32,28,28,57,57,0,0,31,31,28,28,10,10,20,20,37,37,14,14,6,6,16,16,28,28,57,57,28,28,47,47,56,56,53,53,37,37,44,44,11,11,16,16,44,44,33,33,1,1,28,28,1,1,33,33,34,34,63,63,62,62,1,1,32,32,35,35,8,8,42,42,11,11,58,58,30,30,1,1,45,45,55,55,60,60,39,39,62,62,26,26,34,34,41,41,47,47,9,9,32,32,6,6,10,10,14,14,45,45,43,43,60,60,6,6,12,12,42,42,17,17,8,8,8,8,10,10,1,1,44,44,20,20,36,36,8,8,27,27,62,62,58,58,32,32,1,1,56,56,2,2,23,23,39,39,43,43,57,57,10,10,9,9,8,8,59,59,50,50,36,36,45,45,62,62,19,19,49,49,4,4,37,37,8,8,27,27,34,34,28,28,5,5,20,20,9,9,63,63,10,10,43,43,9,9,15,15,17,17,23,23,26,26,54,54,27,27,21,21,3,3,46,46,44,44,43,43,46,46,43,43,53,53,23,23,42,42,6,6,49,49,4,4,26,26,38,38,5,5,48,48,42,42,16,16,23,23,3,3,61,61,35,35,52,52,8,8,2,2,62,62,4,4,22,22,12,12,59,59,39,39,45,45,20,20,11,11,51,51,56,56,1,1,36,36,59,59,18,18,46,46,49,49,31,31,4,4,36,36,38,38,0,0,36,36,33,33,16,16,20,20,40,40,43,43,39,39,7,7,36,36,45,45,38,38,59,59,32,32,53,53,0,0,62,62,20,20,55,55,21,21,5,5,34,34,15,15,43,43,60,60,12,12,16,16,29,29,37,37,25,25,35,35,27,27,62,62,26,26,27,27,51,51,50,50,37,37,1,1,45,45,45,45,53,53,0,0,49,49,61,61,25,25,42,42,27,27,55,55,50,50,4,4,7,7,62,62,29,29,58,58,51,51,41,41,51,51,10,10,46,46,27,27,36,36,11,11,14,14,15,15,9,9,2,2,38,38,54,54,35,35,13,13,30,30,24,24,22,22,12,12,53,53,8,8,58,58,61,61,43,43,58,58,21,21,23,23,51,51,58,58,22,22,12,12,6,6,5,5,51,51,9,9,12,12,48,48,20,20,2,2,14,14,39,39,1,1,51,51,1,1,33,33,54,54,2,2,31,31,60,60,57,57,20,20,61,61,56,56,8,8,56,56,41,41,11,11,12,12,23,23,29,29,47,47,18,18,10,10,44,44,55,55,8,8,22,22,10,10,37,37,37,37,34,34,62,62,1,1,38,38,40,40,58,58,35,35,33,33,4,4,44,44,25,25,25,25,60,60,19,19,5,5,60,60,47,47,44,44,5,5,53,53,36,36,29,29,40,40,38,38,34,34,52,52,54,54,45,45,55,55,25,25,60,60,2,2,3,3,48,48,40,40,21,21,52,52,60,60,46,46,11,11,13,13,48,48,13,13,41,41,40,40,39,39,33,33,44,44,31,31,48,48,44,44,53,53,61,61,27,27,32,32,6,6,34,34,17,17,45,45,39,39,27,27,21,21,22,22,0,0,11,11,49,49,40,40,41,41,12,12,52,52,60,60,25,25,49,49,49,49,51,51,26,26,41,41,24,24,18,18,2,2,46,46,34,34,37,37,37,37,37,37,45,45,20,20,48,48,10,10,61,61,54,54,23,23,6,6,26,26,5,5,18,18,27,27,7,7,42,42,22,22,30,30,22,22,4,4,0,0,1,1,7,7,37,37,62,62,23,23,22,22,0,0,36,36,38,38,17,17,62,62,41,41,55,55,19,19,8,8,32,32,37,37,31,31,6,6,13,13,56,56,48,48,40,40,10,10,60,60,20,20,20,20,1,1,18,18,18,18,9,9,45,45,22,22,62,62,25,25,17,17,25,25,20,20,23,23,57,57,9,9,17,17,17,17,12,12,62,62,47,47,21,21,48,48,30,30,25,25,48,48,39,39,14,14,52,52,60,60,10,10,54,54,55,55,54,54,3,3,4,4,22,22,47,47,23,23,51,51,8,8,29,29,62,62,22,22,29,29,27,27,20,20,1,1,22,22,53,53,0,0,45,45,52,52,10,10,34,34,53,53,25,25,2,2,44,44,9,9,44,44,3,3,33,33,11,11,6,6,52,52,46,46,19,19,56,56,15,15,28,28,60,60,49,49,47,47,28,28,22,22,6,6,4,4,42,42,56,56,49,49,43,43,10,10,1,1,38,38,3,3,27,27,11,11,33,33,33,33,23,23,44,44,52,52,25,25,16,16,25,25,1,1,29,29,13,13,19,19,43,43,43,43,42,42,54,54,20,20,50,50,12,12,26,26,4,4,54,54,51,51,57,57,35,35,21,21,4,4,27,27,20,20,20,20,6,6,54,54,27,27,19,19,32,32,6,6,46,46,26,26,50,50,55,55,49,49,47,47,52,52,14,14,12,12,48,48,62,62,4,4,45,45,33,33,28,28,55,55,22,22,17,17,34,34,19,19,37,37,25,25,60,60,45,45,5,5,54,54,49,49,55,55,9,9,18,18,21,21,40,40,18,18,62,62,22,22,24,24,15,15,60,60,28,28,52,52,24,24,61,61,32,32,5,5,9,9,15,15,52,52,21,21,35,35,30,30,59,59,0,0,35,35,18,18,63,63,14,14,59,59,30,30,27,27,56,56,34,34,10,10,32,32,44,44,57,57,4,4,8,8,37,37,49,49,40,40,12,12,0,0,9,9,13,13,54,54,15,15,2,2,52,52,33,33,6,6,54,54,10,10,39,39,42,42,15,15,2,2,42,42,20,20,62,62,34,34,1,1,25,25,28,28,26,26,10,10,42,42,19,19,31,31,3,3,46,46,59,59,41,41,36,36,45,45,52,52,34,34,38,38,19,19,59,59,34,34,55,55,20,20,37,37,41,41,62,62,11,11,5,5,63,63,13,13,53,53,11,11,1,1,2,2,53,53,16,16,3,3,23,23,8,8,51,51,37,37,45,45,2,2,4,4,2,2,19,19,37,37,56,56,19,19,37,37,39,39,3,3,14,14,20,20,4,4,13,13,26,26,42,42,63,63,9,9,48,48,49,49,55,55,38,38,43,43,59,59,53,53,9,9,29,29,24,24,54,54,59,59,48,48,34,34,48,48,2,2,38,38,51,51,0,0,13,13,2,2,52,52,44,44,1,1,40,40,37,37,17,17,57,57,53,53,43,43,60,60,52,52,50,50,57,57,59,59,0,0,16,16,20,20,6,6,45,45,34,34,47,47,52,52,39,39,32,32,18,18,17,17,27,27,56,56,51,51,18,18,37,37,10,10,10,10,44,44,18,18,13,13,35,35,52,52,38,38,34,34,28,28,24,24,45,45,5,5,37,37,3,3,14,14,20,20,13,13,12,12,19,19,6,6,61,61,52,52,0,0,7,7,40,40,22,22,16,16,21,21,47,47,30,30,17,17,17,17,39,39,22,22,39,39,62,62,17,17,16,16,19,19,63,63,34,34,2,2,30,30,45,45,50,50,49,49,17,17,7,7,31,31,18,18,56,56,1,1,4,4,43,43,5,5,50,50,45,45,60,60,3,3,48,48,53,53,63,63,53,53,10,10,47,47,42,42,23,23,41,41,7,7,47,47,11,11,48,48,16,16,61,61,49,49,38,38,22,22,3,3,24,24,29,29,4,4,41,41,51,51,34,34,55,55,58,58,16,16,30,30,63,63,19,19,1,1,2,2,19,19,26,26,3,3,41,41,32,32,5,5,59,59,30,30,28,28,18,18,1,1,56,56,53,53,40,40,34,34,38,38,0,0,46,46,13,13,40,40,1,1,23,23,38,38,54,54,46,46,1,1,2,2,19,19,22,22,15,15,24,24,45,45,18,18,20,20,30,30,25,25,6,6,16,16,14,14,5,5,24,24,55,55,49,49,46,46,15,15,42,42,7,7,1,1,17,17,35,35,19,19,13,13,61,61,45,45,31,31,50,50,20,20,14,14,10,10,49,49,3,3,58,58,56,56,37,37,31,31,4,4,20,20,6,6,37,37,55,55,4,4,25,25,28,28,3,3,32,32,28,28,21,21,61,61,8,8,23,23,52,52,22,22,14,14,1,1,23,23,3,3,23,23,1,1,53,53,4,4,46,46,1,1,34,34,1,1,7,7,30,30,61,61,40,40,21,21,12,12,47,47,14,14,33,33,7,7,54,54,38,38,33,33,56,56,63,63,36,36,18,18,33,33,22,22,45,45,47,47,43,43,3,3,25,25,28,28,26,26,43,43,35,35,33,33,43,43,56,56,14,14,44,44,6,6,5,5,41,41,10,10,16,16,0,0,21,21,39,39,4,4,16,16,8,8,21,21,19,19,11,11,42,42,16,16,37,37,1,1,29,29,59,59,12,12,41,41,35,35,44,44,3,3,57,57,44,44,43,43,61,61,49,49,5,5,59,59,7,7,40,40,63,63,47,47,46,46,36,36,0,0,11,11,17,17,33,33,26,26,49,49,20,20,24,24,10,10,29,29,47,47,59,59,19,19,62,62,30,30,63,63,49,49,14,14,52,52,37,37,10,10,33,33,56,56,13,13,19,19,44,44,54,54,25,25,47,47,53,53,32,32,16,16,33,33,43,43,16,16,25,25,1,1,46,46,8,8,50,50,33,33,29,29,5,5,18,18,17,17,39,39,18,18,51,51,50,50,51,51,12,12,63,63,51,51,13,13,13,13,40,40,12,12,53,53,47,47,3,3,25,25,1,1,39,39,3,3,58,58,4,4,57,57,56,56,42,42,24,24,22,22,4,4,9,9,45,45,59,59,55,55,9,9,63,63,13,13,8,8,5,5,15,15,36,36,46,46,51,51,34,34,37,37,32,32,2,2,13,13,29,29,48,48,12,12,40,40,5,5,31,31,13,13,6,6,1,1,29,29,3,3,4,4,44,44,2,2,8,8,25,25,9,9,16,16,1,1,34,34,10,10,53,53,13,13,36,36,44,44,6,6,55,55,26,26,30,30,50,50,27,27,30,30,24,24,30,30,29,29,5,5,5,5,29,29,36,36,54,54,40,40,9,9,39,39,34,34,44,44,24,24,12,12,2,2,40,40,12,12,20,20,51,51,40,40,43,43,4,4,6,6,13,13,48,48,27,27,63,63,35,35,4,4,58,58,24,24,59,59,57,57,37,37,50,50,45,45,57,57,36,36,62,62,19,19,39,39,15,15,46,46,18,18,16,16,37,37,14,14,23,23,35,35,39,39,21,21,30,30,51,51,53,53,41,41,61,61,58,58,37,37,10,10,0,0,18,18,30,30,30,30,7,7,3,3,6,6,44,44,23,23,43,43,6,6,47,47,16,16,8,8,8,8,27,27,37,37,10,10,18,18,33,33,12,12,35,35,14,14,19,19,7,7,7,7,31,31,38,38,45,45,15,15,26,26,37,37,12,12,0,0,55,55,35,35,35,35,23,23,56,56,26,26,55,55,36,36,33,33,30,30,55,55,5,5,61,61,4,4,50,50,60,60,22,22,6,6,37,37,10,10,43,43,63,63,33,33,3,3,37,37,51,51,17,17,0,0,54,54,49,49,2,2,28,28,31,31,54,54,34,34,6,6,25,25,16,16,57,57,42,42,53,53,32,32,60,60,54,54,35,35,44,44,16,16,57,57,19,19,56,56,35,35,46,46,26,26,53,53,7,7,9,9,49,49,63,63,49,49,29,29,56,56,31,31,28,28,58,58,39,39,28,28,52,52,46,46,5,5,33,33,17,17,4,4,45,45,3,3,12,12,48,48,35,35,58,58,17,17,7,7,20,20,12,12,10,10,9,9,39,39,40,40,27,27,40,40,23,23,14,14,30,30,33,33,35,35,45,45,27,27,0,0,1,1,43,43,44,44,33,33,10,10,42,42,49,49,35,35,39,39,42,42,9,9,56,56,31,31,31,31,56,56,36,36,10,10,47,47,49,49,32,32,16,16,46,46,21,21,46,46,45,45,60,60,47,47,46,46,16,16,18,18,36,36,34,34,38,38,5,5,6,6,38,38,5,5,21,21,40,40,16,16,4,4,52,52,19,19,37,37,4,4,35,35,13,13,48,48,8,8,47,47,33,33,12,12,11,11,34,34,26,26,14,14,51,51,31,31,43,43,34,34,27,27,25,25,10,10,4,4,22,22,10,10,52,52,17,17,39,39,38,38,55,55,13,13,39,39,52,52,20,20,1,1,1,1,22,22,42,42,45,45,49,49,6,6,34,34,44,44,53,53,26,26,0,0,28,28,56,56,23,23,17,17,32,32,21,21,14,14,39,39,48,48,7,7,36,36,40,40,17,17,31,31,32,32,5,5,32,32,1,1,36,36,35,35,22,22,54,54,40,40,44,44,35,35,30,30,36,36,38,38,1,1,55,55,24,24,48,48,48,48,12,12,61,61,10,10,48,48,2,2,27,27,40,40,13,13,4,4,30,30,58,58,53,53,12,12,48,48,13,13,14,14,0,0,11,11,50,50,31,31,4,4,12,12,33,33,20,20,60,60,18,18,39,39,5,5,48,48,29,29,63,63,3,3,3,3,50,50,5,5,63,63,19,19,11,11,11,11,12,12,61,61,36,36,62,62,4,4,15,15,25,25,16,16,30,30,4,4,35,35,11,11,58,58,14,14,7,7,29,29,41,41,34,34,32,32,5,5,30,30,62,62,61,61,4,4,2,2,61,61,0,0,19,19,42,42,9,9,5,5,43,43,18,18,55,55,53,53,28,28,52,52,18,18,49,49,18,18,40,40,63,63,35,35,0,0,40,40,10,10,24,24,12,12,35,35,47,47,59,59,1,1,19,19,4,4,40,40,41,41,4,4,10,10,25,25,17,17,44,44,49,49,34,34,52,52,62,62,54,54,46,46,7,7,60,60,18,18,37,37,17,17,6,6,50,50,53,53,42,42,14,14,45,45,33,33,46,46,52,52,14,14,14,14,12,12,44,44,38,38,31,31,42,42,42,42,45,45,40,40,2,2,45,45,35,35,44,44,9,9,25,25,28,28,11,11,0,0,50,50,59,59,6,6,34,34,37,37,25,25,6,6,48,48,36,36,5,5,41,41,41,41,52,52,28,28,26,26,49,49,16,16,31,31,3,3,19,19,36,36,23,23,13,13,3,3,43,43,48,48,13,13,37,37,52,52,14,14,36,36,32,32,54,54,1,1,4,4,1,1,6,6,53,53,60,60,63,63,28,28,31,31,33,33,31,31,8,8,16,16,6,6,39,39,22,22,15,15,3,3,41,41,26,26,60,60,17,17,27,27,49,49,21,21,39,39,28,28,39,39,13,13,63,63,12,12,63,63,55,55,57,57,6,6,31,31,63,63,29,29,25,25,8,8,60,60,56,56,41,41,58,58,9,9,61,61,22,22,37,37,15,15,17,17,22,22,19,19,8,8,13,13,38,38,61,61,47,47,58,58,59,59,40,40,56,56,48,48,13,13,27,27,2,2,12,12,26,26,19,19,9,9,58,58,2,2,13,13,61,61,33,33,44,44,13,13,43,43,55,55,26,26,16,16,0,0,1,1,46,46,36,36,11,11,63,63,12,12,16,16,47,47,45,45,3,3,28,28,10,10,58,58,35,35,54,54,16,16,22,22,46,46,1,1,54,54,8,8,21,21,23,23,23,23,36,36,19,19,9,9,46,46,37,37,46,46,0,0,36,36,23,23,28,28,51,51,8,8,2,2,8,8,61,61,39,39,38,38,14,14,11,11,18,18,48,48,9,9,5,5,58,58,15,15,10,10,10,10,57,57,25,25,55,55,54,54,41,41,46,46,47,47,22,22,59,59,25,25,57,57,41,41,3,3,12,12,23,23,52,52,49,49,3,3,1,1,19,19,12,12,27,27,21,21,25,25,49,49,46,46,18,18,5,5,51,51,59,59,28,28,18,18,11,11,25,25,17,17,59,59,12,12,27,27,34,34,39,39,22,22,38,38,49,49,44,44,28,28,16,16,8,8,58,58,3,3,52,52,37,37,32,32,51,51,36,36,0,0,35,35,40,40,1,1,16,16,10,10,17,17,28,28,44,44,49,49,1,1,29,29,32,32,2,2,30,30,16,16,22,22,62,62,30,30,7,7,17,17,20,20,3,3,34,34,55,55,43,43,21,21,15,15,0,0,26,26,24,24,2,2,43,43,0,0,61,61,53,53,8,8,3,3,53,53,28,28,35,35,35,35,56,56,1,1,54,54,61,61,4,4,63,63,22,22,24,24,53,53,13,13,59,59,30,30,61,61,42,42,41,41,13,13,10,10,19,19,42,42,31,31,35,35,4,4,40,40,11,11,60,60,29,29,34,34,36,36,56,56,25,25,31,31,51,51,27,27,35,35,38,38,16,16,1,1,57,57,45,45,54,54,21,21,13,13,11,11,45,45,19,19,2,2,28,28,13,13,48,48,27,27,17,17,50,50,22,22,43,43,59,59,36,36,4,4,50,50,31,31,29,29,42,42,33,33,3,3,2,2,41,41,47,47,39,39,35,35,3,3,58,58,42,42,55,55,25,25,40,40,9,9,45,45,43,43,6,6,23,23,22,22,8,8,36,36,0,0,2,2,26,26,62,62,42,42,13,13,18,18,38,38,42,42,44,44,19,19,54,54,27,27,29,29,51,51,52,52,12,12,46,46,38,38,53,53,3,3,54,54,58,58,9,9,21,21,1,1,52,52,14,14,11,11,16,16,13,13,1,1,27,27,47,47,50,50,42,42,34,34,57,57,10,10,14,14,61,61,21,21,37,37,43,43,3,3,35,35,18,18,62,62,3,3,21,21,63,63,1,1,33,33,28,28,48,48,62,62,62,62,56,56,22,22,2,2,27,27,22,22,50,50,30,30,31,31,15,15,11,11,49,49,36,36,34,34,43,43,2,2,5,5,23,23,19,19,31,31,15,15,51,51,3,3,3,3,37,37,61,61,2,2,29,29,22,22,41,41,14,14,41,41,35,35,59,59,23,23,0,0,3,3,4,4,54,54,11,11,0,0,50,50,31,31,29,29,9,9,0,0,54,54,60,60,37,37,43,43,20,20,4,4,23,23,0,0,28,28,7,7,33,33,4,4,7,7,2,2,54,54,49,49,62,62,1,1,42,42,40,40,38,38,39,39,45,45,27,27,6,6,60,60,17,17,32,32,30,30,21,21,23,23,9,9,10,10,4,4,48,48,33,33,23,23,15,15,49,49,15,15,8,8,15,15,57,57,43,43,26,26,57,57,48,48,11,11,59,59,56,56,16,16,16,16,1,1,12,12,59,59,4,4,29,29,47,47,19,19,55,55,28,28,34,34,43,43,5,5,14,14,18,18,42,42,26,26,15,15,1,1,48,48,6,6,54,54,0,0,53,53,4,4,45,45,29,29,26,26,4,4,8,8,41,41,22,22,0,0,36,36,35,35,10,10,38,38,1,1,53,53,23,23,51,51,54,54,59,59,36,36,8,8,33,33,56,56,20,20,61,61,5,5,31,31,2,2,17,17,3,3,39,39,49,49,4,4,38,38,3,3,23,23,10,10,17,17,39,39,32,32,20,20,2,2,62,62,23,23,34,34,6,6,27,27,44,44,3,3,60,60,57,57,13,13,24,24,53,53,49,49,7,7,20,20,59,59,10,10,53,53,3,3,26,26,6,6,24,24,0,0,22,22,2,2,60,60,18,18,43,43,48,48,28,28,49,49,21,21,37,37,52,52,6,6,45,45,32,32,1,1,8,8,57,57,9,9,35,35,22,22,43,43,7,7,59,59,38,38,34,34,27,27,38,38,62,62,43,43,40,40,28,28,62,62,15,15,45,45,15,15,36,36,55,55,10,10,20,20,13,13,1,1,55,55,44,44,1,1,46,46,3,3,28,28,16,16,59,59,41,41,6,6,44,44,45,45,16,16,40,40,31,31,61,61,29,29,26,26,30,30,29,29,5,5,23,23,9,9,13,13,49,49,23,23,3,3,11,11,45,45,0,0,50,50,30,30,13,13,53,53,8,8,54,54,12,12,4,4,46,46,52,52,34,34,26,26,63,63,22,22,8,8,56,56,53,53,37,37,28,28,58,58,56,56,31,31,59,59,63,63,23,23,6,6,33,33,44,44,40,40,22,22,19,19,28,28,56,56,28,28,55,55,12,12,59,59,33,33,24,24,54,54,60,60,15,15,42,42,60,60,48,48,46,46,41,41,31,31,41,41,48,48,35,35,35,35,35,35,5,5,57,57,14,14,46,46,25,25,7,7,37,37,30,30,52,52,32,32,11,11,13,13,39,39,30,30,47,47,0,0,36,36,0,0,45,45,25,25,15,15,34,34,38,38,26,26,22,22,39,39,1,1,12,12,34,34,21,21,46,46,39,39,41,41,16,16,17,17,23,23,50,50,10,10,61,61,50,50,37,37,32,32,1,1,45,45,62,62,48,48,38,38,7,7,15,15,5,5,43,43,4,4,17,17,20,20,2,2,6,6,2,2,63,63,38,38,36,36,61,61,47,47,51,51,43,43,61,61,0,0,34,34,33,33,18,18,29,29,19,19,44,44,46,46,36,36,48,48,11,11,7,7,50,50,10,10,34,34,14,14,61,61,26,26,36,36,26,26,2,2,23,23,57,57,0,0,34,34,0,0,33,33,17,17,53,53,31,31,7,7,14,14,26,26,59,59,32,32,28,28,58,58,27,27,23,23,49,49,6,6,20,20,0,0,56,56,13,13,15,15,37,37,33,33,16,16,24,24,38,38,39,39,13,13,23,23,51,51,49,49,48,48,4,4,31,31,34,34,50,50,11,11,20,20,56,56,48,48,25,25,49,49,53,53,56,56,4,4,22,22,2,2,24,24,24,24,51,51,2,2,26,26,19,19,20,20,31,31,10,10,24,24,31,31,11,11,39,39,19,19,27,27,10,10,8,8,13,13,5,5,4,4,26,26,48,48,36,36,9,9,37,37,11,11,28,28,6,6,52,52,18,18,2,2,6,6,4,4,32,32,33,33,25,25,4,4,42,42,17,17,8,8,4,4,23,23,23,23,12,12,24,24,12,12,7,7,7,7,12,12,20,20,4,4,26,26,14,14,55,55,14,14,41,41,32,32,2,2,8,8,12,12,33,33,27,27,44,44,36,36,16,16,33,33,20,20,18,18,26,26,38,38,33,33,12,12,28,28,38,38,32,32,57,57,50,50,52,52,21,21,22,22,10,10,48,48,17,17,59,59,58,58,57,57,13,13,47,47,45,45,37,37,42,42,45,45,29,29,1,1,63,63,14,14,33,33,19,19,61,61,46,46,44,44,12,12,62,62,58,58,33,33,20,20,18,18,0,0,36,36,36,36,20,20,31,31,0,0,36,36,26,26,48,48,12,12,22,22,7,7,20,20,59,59,5,5,6,6,50,50,45,45,26,26,54,54,28,28,27,27,0,0,48,48,22,22,31,31,10,10,12,12,28,28,37,37,17,17,46,46,8,8,52,52,53,53,43,43,36,36,8,8,26,26,20,20,34,34,21,21,41,41,15,15,1,1,25,25,60,60,6,6,26,26,18,18,9,9,50,50,32,32,63,63,30,30,48,48,47,47,2,2,55,55,55,55,39,39,34,34,52,52,35,35,9,9,23,23,20,20,2,2,40,40,13,13,10,10,18,18,12,12,39,39,40,40,45,45,19,19,42,42,46,46,58,58,5,5,2,2,47,47,6,6,56,56,63,63,19,19,30,30,20,20,38,38,17,17,8,8,62,62,42,42,52,52,36,36,36,36,30,30,8,8,60,60,47,47,14,14,10,10,53,53,13,13,34,34,2,2,17,17,56,56,54,54,29,29,38,38,28,28,30,30,28,28,16,16,32,32,6,6,59,59,37,37,32,32,29,29,11,11,32,32,8,8,60,60,0,0,0,0,12,12,3,3,46,46,22,22,37,37,23,23,38,38,0,0,16,16,47,47,40,40,46,46,39,39,22,22,19,19,58,58,42,42,32,32,11,11,10,10,14,14,53,53,35,35,24,24,14,14,43,43,16,16,8,8,17,17,26,26,20,20,61,61,29,29,5,5,19,19,62,62,41,41,7,7,21,21,1,1,22,22,63,63,29,29,19,19,14,14,18,18,62,62,39,39,29,29,27,27,49,49,33,33,32,32,7,7,44,44,21,21,61,61,41,41,19,19,61,61,7,7,34,34,57,57,58,58,5,5,5,5,47,47,53,53,62,62,38,38,45,45,57,57,45,45,34,34,8,8,4,4,6,6,40,40,21,21,59,59,23,23,32,32,39,39,44,44,5,5,23,23,37,37,63,63,25,25,15,15,10,10,39,39,60,60,9,9,37,37,5,5,34,34,39,39,34,34,29,29,43,43,55,55,45,45,27,27,1,1,18,18,29,29,47,47,25,25,9,9,47,47,32,32,1,1,41,41,20,20,60,60,47,47,4,4,19,19,19,19,17,17,61,61,0,0,63,63,45,45,48,48,45,45,17,17,59,59,5,5,6,6,2,2,25,25,33,33,47,47,5,5,51,51,63,63,35,35,57,57,48,48,56,56,24,24,17,17,36,36,29,29,29,29,43,43,62,62,40,40,8,8,0,0,28,28,1,1,57,57,43,43,41,41,3,3,20,20,26,26,43,43,17,17,7,7,11,11,34,34,23,23,47,47,61,61,37,37,31,31,52,52,16,16,7,7,17,17,45,45,55,55,5,5,1,1,42,42,27,27,7,7,21,21,10,10,15,15,9,9,22,22,39,39,9,9,25,25,28,28,61,61,34,34,9,9,59,59,22,22,50,50,46,46,47,47,3,3,11,11,8,8,11,11,21,21,48,48,56,56,4,4,39,39,58,58,36,36,29,29,38,38,22,22,5,5,7,7,22,22,44,44,3,3,63,63,5,5,1,1,13,13,58,58,23,23,23,23,17,17,57,57,41,41,29,29,44,44,5,5,48,48,53,53,32,32,58,58,7,7,1,1,4,4,38,38,22,22,42,42,29,29,47,47,14,14,40,40,2,2,47,47,42,42,45,45,7,7,48,48,26,26,63,63,19,19,48,48,62,62,6,6,10,10,15,15,11,11,31,31,3,3,47,47,56,56,54,54,21,21,20,20,47,47,35,35,31,31,47,47,10,10,36,36,17,17,12,12,9,9,45,45,59,59,46,46,8,8,62,62,53,53,17,17,54,54,53,53,23,23,40,40,23,23,44,44,20,20,51,51,59,59,15,15,35,35,38,38,34,34,35,35,24,24,37,37,36,36,2,2,29,29,17,17,24,24,12,12,55,55,25,25,29,29,56,56,38,38,11,11,61,61,29,29,49,49,42,42,4,4,32,32,29,29,14,14,8,8,21,21,28,28,41,41,44,44,21,21,4,4,11,11,21,21,39,39,16,16,39,39,38,38,12,12,11,11,55,55,57,57,0,0,29,29,21,21,7,7,59,59,20,20,48,48,8,8,20,20,32,32,61,61,15,15,54,54,7,7,27,27,9,9,59,59,26,26,28,28,14,14,13,13,41,41,9,9,10,10,48,48,50,50,16,16,23,23,21,21,33,33,42,42,29,29,44,44,7,7,50,50,6,6,12,12,12,12,33,33,63,63,46,46,39,39,13,13,1,1,29,29,9,9,8,8,24,24,15,15,35,35,46,46,12,12,19,19,47,47,41,41,40,40,17,17,47,47,4,4,61,61,5,5,27,27,14,14,41,41,21,21,42,42,54,54,39,39,26,26,21,21,51,51,47,47,44,44,2,2,17,17,11,11,16,16,44,44,1,1,14,14,21,21,30,30,47,47,3,3,58,58,13,13,12,12,61,61,32,32,32,32,21,21,4,4,29,29,49,49,18,18,62,62,4,4,33,33,59,59,14,14,43,43,12,12,17,17,47,47,38,38,36,36,63,63,1,1,13,13,4,4,32,32,12,12,54,54,12,12,18,18,58,58,43,43,14,14,14,14,21,21,49,49,35,35,51,51,59,59,34,34,42,42,54,54,8,8,35,35,20,20,40,40,61,61,50,50,7,7,21,21,10,10,39,39,62,62,30,30,19,19,41,41,1,1,23,23,0,0,22,22,40,40,38,38,7,7,62,62,7,7,22,22,52,52,49,49,30,30,57,57,27,27,61,61,50,50,48,48,14,14,52,52,22,22,13,13,25,25,7,7,1,1,1,1,11,11,33,33,48,48,25,25,45,45,31,31,54,54,8,8,0,0,53,53,16,16,50,50,4,4,45,45,48,48,30,30,37,37,47,47,57,57,24,24,19,19,42,42,60,60,54,54,21,21,43,43,38,38,58,58,18,18,59,59,56,56,52,52,50,50,56,56,6,6,50,50,16,16,2,2,53,53,9,9,40,40,28,28,3,3,29,29,58,58,23,23,1,1,32,32,34,34,4,4,12,12,47,47,63,63,27,27,54,54,55,55,43,43,9,9,9,9,33,33,50,50,35,35,2,2,43,43,22,22,9,9,34,34,17,17,2,2,24,24,36,36,48,48,8,8,42,42,58,58,16,16,33,33,16,16,36,36,41,41,52,52,50,50,5,5,53,53,24,24,48,48,5,5,28,28,53,53,42,42,21,21,63,63,23,23,1,1,14,14,17,17,51,51,23,23,14,14,7,7,19,19,33,33,20,20,57,57,39,39,46,46,11,11,20,20,27,27,45,45,22,22,40,40,17,17,9,9,17,17,56,56,58,58,38,38,58,58,62,62,33,33,3,3,29,29,4,4,11,11,30,30,56,56,1,1,24,24,39,39,55,55,48,48,48,48,35,35,0,0,26,26,44,44,40,40,5,5,39,39,20,20,55,55,20,20,63,63,55,55,0,0,0,0,38,38,53,53,48,48,62,62,58,58,32,32,57,57,5,5,60,60,58,58,15,15,3,3,18,18,32,32,15,15,28,28,14,14,19,19,14,14,4,4,0,0,0,0,44,44,16,16,28,28,56,56,2,2,30,30,13,13,32,32,23,23,59,59,42,42,24,24,48,48,32,32,15,15,41,41,19,19,40,40,35,35,19,19,36,36,61,61,5,5,9,9,39,39,30,30,10,10,57,57,5,5,0,0,39,39,20,20,33,33,14,14,10,10,51,51,40,40,52,52,2,2,57,57,8,8,38,38,3,3,24,24,53,53,32,32,12,12,31,31,2,2,19,19,0,0,11,11,44,44,63,63,18,18,62,62,61,61,8,8,4,4,17,17,48,48,42,42,38,38,34,34,28,28,51,51,39,39,60,60,1,1,49,49,44,44,6,6,40,40,6,6,53,53,2,2,11,11,22,22,23,23,38,38,35,35,55,55,21,21,32,32,1,1,2,2,20,20,24,24,20,20,54,54,50,50,27,27,8,8,1,1,4,4,21,21,59,59,26,26,52,52,48,48,21,21,58,58,42,42,29,29,60,60,40,40,29,29,1,1,24,24,52,52,62,62,7,7,47,47,38,38,3,3,10,10,55,55,43,43,53,53,52,52,37,37,13,13,55,55,59,59,57,57,59,59,57,57,27,27,34,34,40,40,29,29,18,18,32,32,58,58,33,33,48,48,26,26,27,27,54,54,15,15,50,50,56,56,54,54,20,20,60,60,7,7,2,2,25,25,33,33,59,59,1,1,25,25,13,13,20,20,4,4,20,20,12,12,10,10,61,61,32,32,42,42,53,53,25,25,37,37,14,14,48,48,12,12,27,27,54,54,49,49,35,35,53,53,28,28,34,34,6,6,11,11,20,20,10,10,6,6,27,27,59,59,0,0,45,45,12,12,49,49,55,55,10,10,53,53,60,60,18,18,16,16,52,52,16,16,10,10,39,39,36,36,58,58,37,37,27,27,49,49,58,58,21,21,40,40,57,57,35,35,48,48,59,59,31,31,37,37,48,48,4,4,33,33,54,54,24,24,49,49,28,28,42,42,1,1,61,61,19,19,25,25,63,63,61,61,18,18,12,12,38,38,31,31,11,11,7,7,7,7,28,28,37,37,1,1,20,20,37,37,4,4,36,36,6,6,28,28,62,62,59,59,15,15,33,33,35,35,2,2,59,59,54,54,46,46,60,60,23,23,60,60,38,38,12,12,9,9,19,19,31,31,11,11,1,1,47,47,47,47,3,3,12,12,8,8,4,4,7,7,54,54,6,6,25,25,15,15,18,18,12,12,50,50,44,44,9,9,55,55,23,23,9,9,41,41,36,36,19,19,50,50,63,63,16,16,7,7,56,56,31,31,54,54,59,59,0,0,14,14,47,47,8,8,35,35,23,23,1,1,17,17,32,32,5,5,54,54,40,40,3,3,23,23,59,59,61,61,40,40,38,38,49,49,4,4,57,57,5,5,8,8,35,35,4,4,32,32,26,26,15,15,10,10,57,57,29,29,7,7,4,4,43,43,53,53,29,29,4,4,34,34,37,37,3,3,22,22,4,4,18,18,61,61,22,22,20,20,58,58,30,30,3,3,5,5,53,53,2,2,19,19,28,28,19,19,1,1,38,38,58,58,51,51,4,4,34,34,20,20,3,3,48,48,1,1,39,39,12,12,34,34,41,41,36,36,45,45,18,18,7,7,61,61,53,53,15,15,49,49,48,48,7,7,36,36,32,32,34,34,58,58,35,35,14,14,1,1,23,23,30,30,16,16,48,48,44,44,15,15,10,10,34,34,6,6,7,7,2,2,13,13,4,4,40,40,41,41,41,41,17,17,35,35,28,28,40,40,14,14,36,36,5,5,7,7,49,49,55,55,7,7,31,31,40,40,50,50,8,8,27,27,37,37,51,51,57,57,13,13,53,53,47,47,27,27,51,51,36,36,11,11,61,61,8,8,27,27,29,29,23,23,54,54,44,44,6,6,30,30,19,19,60,60,4,4,56,56,4,4,34,34,23,23,37,37,59,59,63,63,10,10,22,22,32,32,44,44,9,9,6,6,49,49,33,33,23,23,7,7,16,16,5,5,51,51,44,44,32,32,40,40,56,56,1,1,12,12,7,7,61,61,1,1,16,16,5,5,18,18,55,55,25,25,3,3,30,30,25,25,0,0,60,60,5,5,55,55,53,53,52,52,44,44,49,49,7,7,25,25,2,2,34,34,22,22,52,52,51,51,29,29,22,22,1,1,49,49,25,25,6,6,31,31,0,0,46,46,5,5,30,30,16,16,10,10,62,62,7,7,25,25,59,59,63,63,39,39,39,39,49,49,28,28,0,0,15,15,30,30,54,54,37,37,44,44,60,60,34,34,10,10,16,16,10,10,55,55,37,37,28,28,38,38,31,31,39,39,46,46,54,54,61,61,34,34,35,35,57,57,36,36,29,29,34,34,48,48,57,57,34,34,6,6,54,54,45,45,53,53,10,10,50,50,4,4,42,42,60,60,25,25,15,15,25,25,56,56,50,50,49,49,36,36,60,60,48,48,54,54,49,49,40,40,21,21,27,27,35,35,59,59,33,33,27,27,61,61,34,34,39,39,21,21,11,11,18,18,54,54,14,14,18,18,61,61,25,25,7,7,22,22,31,31,53,53,4,4,62,62,20,20,0,0,14,14,57,57,31,31,52,52,29,29,41,41,20,20,50,50,4,4,51,51,26,26,10,10,24,24,25,25,35,35,15,15,58,58,30,30,52,52,20,20,56,56,8,8,32,32,50,50,62,62,25,25,13,13,51,51,34,34,38,38,61,61,41,41,16,16,11,11,31,31,61,61,9,9,38,38,45,45,55,55,12,12,40,40,53,53,18,18,6,6,48,48,31,31,8,8,16,16,26,26,29,29,41,41,63,63,51,51,2,2,62,62,52,52,16,16,5,5,32,32,47,47,39,39,52,52,50,50,51,51,17,17,43,43,41,41,62,62,56,56,52,52,40,40,25,25,14,14,44,44,26,26,5,5,22,22,53,53,63,63,22,22,29,29,54,54,34,34,61,61,15,15,4,4,15,15,25,25,25,25,18,18,29,29,61,61,50,50,4,4,63,63,21,21,34,34,13,13,19,19,1,1,2,2,16,16,63,63,31,31,14,14,25,25,5,5,8,8,43,43,50,50,46,46,23,23,11,11,32,32,0,0,10,10,7,7,47,47,37,37,52,52,14,14,58,58,16,16,63,63,56,56,44,44,27,27,56,56,18,18,55,55,26,26,32,32,27,27,34,34,49,49,35,35,11,11,25,25,42,42,44,44,20,20,44,44,29,29,5,5,16,16,58,58,40,40,44,44,29,29,54,54,57,57,54,54,20,20,19,19,48,48,25,25,30,30,22,22,43,43,2,2,22,22,43,43,14,14,51,51,55,55,56,56,50,50,1,1,59,59,2,2,44,44,25,25,30,30,13,13,31,31,11,11,33,33,29,29,60,60,6,6,5,5,53,53,35,35,44,44,11,11,19,19,52,52,27,27,7,7,55,55,1,1,23,23,41,41,1,1,11,11,27,27,4,4,5,5,47,47,0,0,18,18,42,42,45,45,29,29,36,36,8,8,0,0,27,27,2,2,13,13,51,51,22,22,36,36,20,20,1,1,15,15,47,47,5,5,21,21,42,42,15,15,28,28,9,9,36,36,43,43,6,6,49,49,34,34,11,11,38,38,13,13,15,15,20,20,7,7,63,63,50,50,30,30,22,22,38,38,55,55,3,3,52,52,15,15,29,29,60,60,45,45,51,51,15,15,7,7,8,8,53,53,30,30,6,6,5,5,31,31,61,61,51,51,38,38,1,1,9,9,7,7,2,2,29,29,47,47,16,16,4,4,23,23,30,30,10,10,9,9,34,34,8,8,45,45,0,0,38,38,40,40,59,59,23,23,5,5,11,11,31,31,51,51,40,40,50,50,5,5,27,27,62,62,28,28,48,48,53,53,60,60,1,1,10,10,60,60,50,50,7,7,15,15,36,36,30,30,25,25,28,28,6,6,25,25,40,40,4,4,37,37,18,18,26,26,6,6,38,38,56,56,56,56,49,49,12,12,3,3,55,55,59,59,16,16,39,39,60,60,10,10,28,28,16,16,8,8,4,4,60,60,53,53,32,32,0,0,61,61,8,8,40,40,48,48,40,40,23,23,12,12,9,9,60,60,8,8,40,40,25,25,58,58,19,19,30,30,1,1,10,10,49,49,18,18,31,31,32,32,19,19,11,11,38,38,56,56,41,41,31,31,22,22,58,58,48,48,22,22,6,6,17,17,28,28,28,28,23,23,29,29,1,1,54,54,57,57,6,6,14,14,60,60,36,36,34,34,53,53,21,21,57,57,2,2,8,8,18,18,51,51,3,3,40,40,13,13,36,36,2,2,24,24,50,50,33,33,54,54,29,29,16,16,61,61,49,49,62,62,46,46,17,17,18,18,17,17,21,21,1,1,60,60,9,9,24,24,2,2,37,37,0,0,39,39,55,55,34,34,42,42,6,6,7,7,32,32,13,13,36,36,37,37,46,46,34,34,7,7,22,22,53,53,56,56,22,22,18,18,58,58,32,32,44,44,52,52,15,15,21,21,62,62,52,52,25,25,36,36,8,8,23,23,38,38,42,42,59,59,2,2,35,35,13,13,43,43,63,63,36,36,37,37,33,33,51,51,20,20,34,34,9,9,3,3,29,29,58,58,12,12,38,38,4,4,15,15,20,20,21,21,51,51,41,41,16,16,45,45,41,41,55,55,19,19,2,2,16,16,15,15,53,53,9,9,14,14,39,39,51,51,6,6,49,49,26,26,24,24,23,23,21,21,47,47,40,40,31,31,28,28,42,42,6,6,9,9,60,60,19,19,1,1,22,22,14,14,38,38,52,52,57,57,31,31,50,50,33,33,13,13,28,28,55,55,2,2,39,39,57,57,36,36,39,39,60,60,60,60,41,41,7,7,31,31,30,30,28,28,45,45,4,4,19,19,7,7,13,13,53,53,62,62,27,27,32,32,55,55,8,8,52,52,58,58,62,62,25,25,62,62,8,8,19,19,5,5,15,15,32,32,43,43,33,33,49,49,45,45,15,15,36,36,56,56,13,13,0,0,21,21,38,38,4,4,49,49,60,60,4,4,50,50,34,34,58,58,6,6,13,13,40,40,45,45,22,22,9,9,33,33,35,35,55,55,2,2,5,5,38,38,11,11,5,5,26,26,21,21,50,50,7,7,51,51,53,53,10,10,0,0,50,50,3,3,19,19,1,1,8,8,40,40,51,51,8,8,21,21,11,11,42,42,16,16,19,19,14,14,50,50,52,52,41,41,44,44,43,43,45,45,7,7,44,44,42,42,40,40,10,10,42,42,55,55,13,13,13,13,56,56,34,34,4,4,11,11,50,50,57,57,7,7,21,21,28,28,16,16,1,1,31,31,16,16,24,24,12,12,9,9,48,48,38,38,51,51,36,36,37,37,22,22,52,52,20,20,47,47,52,52,21,21,20,20,14,14,59,59,2,2,61,61,60,60,31,31,27,27,17,17,50,50,34,34,32,32,60,60,35,35,56,56,22,22,33,33,55,55,4,4,19,19,50,50,37,37,26,26,42,42,42,42,27,27,33,33,47,47,63,63,28,28,57,57,56,56,24,24,33,33,36,36,23,23,22,22,22,22,18,18,14,14,54,54,9,9,20,20,16,16,6,6,39,39,12,12,25,25,46,46,37,37,4,4,36,36,61,61,62,62,10,10,32,32,8,8,12,12,52,52,10,10,60,60,32,32,51,51,11,11,5,5,39,39,50,50,38,38,36,36,12,12,51,51,58,58,35,35,2,2,14,14,60,60,56,56,54,54,49,49,13,13,42,42,50,50,29,29,16,16,10,10,14,14,21,21,43,43,14,14,20,20,39,39,23,23,25,25,27,27,38,38,51,51,61,61,6,6,34,34,60,60,2,2,15,15,33,33,30,30,23,23,34,34,12,12,25,25,34,34,23,23,7,7,57,57,40,40,5,5,39,39,45,45,33,33,25,25,42,42,1,1,9,9,19,19,19,19,35,35,54,54,46,46,38,38,21,21,51,51,13,13,51,51,53,53,61,61,54,54,9,9,8,8,28,28,10,10,45,45,4,4,33,33,32,32,20,20,36,36,39,39,33,33,51,51,13,13,13,13,14,14,61,61,48,48,26,26,42,42,45,45,29,29,45,45,62,62,55,55,20,20,44,44,62,62,35,35,62,62,29,29,47,47,38,38,13,13,53,53,10,10,48,48,58,58,54,54,56,56,54,54,2,2,2,2,34,34,25,25,22,22,35,35,62,62,20,20,57,57,50,50,31,31,40,40,51,51,7,7,1,1,28,28,18,18,48,48,46,46,19,19,2,2,7,7,4,4,50,50,8,8,14,14,35,35,31,31,17,17,50,50,51,51,42,42,55,55,0,0,50,50,43,43,14,14,34,34,22,22,33,33,45,45,1,1,46,46,15,15,12,12,15,15,51,51,37,37,50,50,20,20,56,56,8,8,37,37,36,36,63,63,8,8,10,10,59,59,2,2,40,40,43,43,6,6,52,52,3,3,35,35,44,44,35,35,3,3,1,1,44,44,3,3,12,12,30,30,62,62,36,36,14,14,0,0,63,63,14,14,30,30,0,0,21,21,2,2,51,51,25,25,9,9,1,1,60,60,4,4,7,7,19,19,17,17,58,58,51,51,57,57,28,28,32,32,55,55,8,8,28,28,33,33,8,8,61,61,61,61,58,58,8,8,30,30,29,29,29,29,15,15,29,29,12,12,38,38,23,23,60,60,13,13,37,37,41,41,56,56,42,42,22,22,23,23,13,13,32,32,35,35,24,24,18,18,3,3,18,18,20,20,42,42,48,48,53,53,16,16,4,4,1,1,42,42,62,62,40,40,45,45,31,31,0,0,42,42,55,55,26,26,30,30,41,41,16,16,13,13,15,15,51,51,18,18,42,42,33,33,50,50,18,18,36,36,42,42,17,17,13,13,54,54,50,50,24,24,50,50,50,50,13,13,19,19,31,31,36,36,29,29,2,2,5,5,48,48,57,57,21,21,52,52,25,25,2,2,0,0,16,16,46,46,24,24,11,11,47,47,18,18,5,5,13,13,18,18,28,28,40,40,35,35,39,39,57,57,33,33,43,43,13,13,39,39,34,34,20,20,53,53,56,56,59,59,10,10,47,47,47,47,12,12,36,36,53,53,41,41,1,1,59,59,27,27,27,27,9,9,4,4,42,42,24,24,27,27,55,55,22,22,60,60,49,49,24,24,9,9,50,50,48,48,59,59,5,5,52,52,29,29,25,25,32,32,12,12,7,7,23,23,24,24,8,8,56,56,19,19,33,33,16,16,2,2,24,24,32,32,44,44,14,14,39,39,29,29,27,27,23,23,25,25,0,0,40,40,32,32,31,31,9,9,29,29,20,20,9,9,23,23,17,17,21,21,51,51,61,61,44,44,37,37,16,16,35,35,58,58,36,36,49,49,34,34,51,51,9,9,30,30,17,17,48,48,43,43,16,16,12,12,14,14,2,2,37,37,42,42,5,5,50,50,48,48,22,22,12,12,8,8,37,37,15,15,47,47,28,28,48,48,37,37,6,6,4,4,40,40,51,51,62,62,42,42,5,5,42,42,5,5,44,44,40,40,34,34,34,34,27,27,53,53,15,15,48,48,43,43,1,1,45,45,12,12,14,14,12,12,61,61,28,28,2,2,44,44,2,2,37,37,17,17,1,1,63,63,34,34,29,29,38,38,21,21,4,4,16,16,63,63,55,55,47,47,14,14,16,16,5,5,3,3,30,30,45,45,35,35,29,29,17,17,34,34,21,21,32,32,45,45,44,44,58,58,52,52,49,49,28,28,12,12,39,39,42,42,10,10,29,29,42,42,35,35,63,63,30,30,46,46,10,10,63,63,44,44,53,53,40,40,27,27,22,22,38,38,46,46,60,60,51,51,46,46,34,34,16,16,54,54,14,14,62,62,40,40,16,16,28,28,1,1,7,7,46,46,30,30,14,14,10,10,15,15,29,29,8,8,52,52,33,33,17,17,5,5,30,30,7,7,49,49,34,34,5,5,56,56,46,46,26,26,13,13,10,10,25,25,56,56,13,13,31,31,4,4,27,27,5,5,58,58,5,5,1,1,26,26,3,3,19,19,38,38,6,6,59,59,57,57,13,13,7,7,46,46,31,31,47,47,44,44,55,55,54,54,59,59,17,17,17,17,37,37,45,45,37,37,35,35,36,36,43,43,40,40,57,57,9,9,38,38,56,56,16,16,4,4,36,36,5,5,59,59,14,14,53,53,59,59,46,46,46,46,11,11,37,37,40,40,51,51,31,31,61,61,23,23,26,26,12,12,54,54,11,11,10,10,35,35,28,28,20,20,54,54,19,19,24,24,42,42,43,43,2,2,29,29,23,23,15,15,42,42,34,34,53,53,49,49,10,10,32,32,49,49,20,20,7,7,54,54,57,57,13,13,32,32,24,24,22,22,27,27,20,20,24,24,9,9,41,41,3,3,37,37,21,21,19,19,59,59,54,54,24,24,40,40,48,48,4,4,50,50,58,58,40,40,11,11,1,1,32,32,0,0,50,50,15,15,26,26,56,56,48,48,34,34,50,50,45,45,2,2,44,44,15,15,11,11,12,12,16,16,30,30,2,2,50,50,15,15,29,29,31,31,8,8,20,20,52,52,26,26,51,51,4,4,2,2,60,60,26,26,10,10,61,61,11,11,41,41,31,31,50,50,39,39,7,7,34,34,50,50,40,40,19,19,38,38,36,36,9,9,53,53,39,39,46,46,37,37,38,38,17,17,4,4,3,3,15,15,16,16,30,30,7,7,24,24,39,39,34,34,48,48,11,11,62,62,0,0,47,47,1,1,63,63,48,48,18,18,1,1,0,0,19,19,61,61,0,0,28,28,3,3,59,59,3,3,33,33,18,18,14,14,47,47,9,9,17,17,4,4,61,61,43,43,46,46,63,63,58,58,58,58,24,24,38,38,41,41,41,41,31,31,13,13,16,16,13,13,13,13,28,28,9,9,2,2,33,33,46,46,11,11,25,25,4,4,47,47,8,8,40,40,10,10,30,30,14,14,14,14,42,42,8,8,54,54,25,25,37,37,57,57,38,38,40,40,8,8,30,30,6,6,2,2,2,2,18,18,37,37,59,59,39,39,38,38,1,1,20,20,5,5,53,53,23,23,16,16,0,0,36,36,33,33,39,39,26,26,51,51,34,34,38,38,49,49,52,52,38,38,62,62,61,61,13,13,33,33,17,17,19,19,62,62,19,19,10,10,39,39,36,36,54,54,52,52,49,49,4,4,6,6,63,63,32,32,43,43,12,12,24,24,42,42,13,13,62,62,50,50,61,61,47,47,12,12,33,33,28,28,1,1,40,40,54,54,28,28,31,31,40,40,2,2,48,48,57,57,49,49,40,40,63,63,14,14,26,26,31,31,17,17,38,38,6,6,23,23,22,22,43,43,14,14,5,5,23,23,60,60,53,53,55,55,36,36,14,14,20,20,5,5,27,27,26,26,51,51,60,60,48,48,29,29,18,18,25,25,28,28,55,55,20,20,25,25,58,58,61,61,48,48,24,24,41,41,58,58,3,3,20,20,32,32,9,9,50,50,53,53,23,23,8,8,14,14,12,12,35,35,27,27,52,52,6,6,17,17,52,52,40,40,22,22,55,55,53,53,44,44,26,26,5,5,38,38,11,11,2,2,38,38,17,17,55,55,21,21,23,23,40,40,63,63,8,8,1,1,34,34,46,46,4,4,32,32,21,21,44,44,31,31,21,21,54,54,60,60,24,24,52,52,17,17,8,8,40,40,35,35,38,38,57,57,38,38,40,40,14,14,4,4,38,38,7,7,22,22,2,2,51,51,1,1,4,4,2,2,30,30,26,26,6,6,46,46,61,61,4,4,7,7,33,33,32,32,43,43,42,42,20,20,35,35,36,36,61,61,26,26,63,63,15,15,36,36,60,60,30,30,46,46,56,56,54,54,10,10,30,30,17,17,8,8,7,7,49,49,11,11,52,52,33,33,10,10,19,19,34,34,0,0,4,4,8,8,54,54,38,38,56,56,14,14,29,29,33,33,36,36,30,30,10,10,46,46,50,50,14,14,63,63,18,18,40,40,22,22,14,14,47,47,48,48,6,6,61,61,39,39,62,62,11,11,3,3,56,56,44,44,37,37,60,60,22,22,54,54,29,29,57,57,45,45,53,53,7,7,59,59,50,50,45,45,26,26,32,32,52,52,62,62,9,9,8,8,51,51,24,24,29,29,24,24,44,44,46,46,14,14,28,28,32,32,6,6,21,21,32,32,19,19,15,15,30,30,48,48,59,59,45,45,35,35,7,7,21,21,10,10,47,47,22,22,21,21,2,2,19,19,0,0,12,12,13,13,42,42,27,27,35,35,23,23,53,53,50,50,58,58,16,16,15,15,32,32,62,62,9,9,5,5,47,47,40,40,30,30,27,27,10,10,20,20,10,10,55,55,42,42,5,5,22,22,45,45,62,62,29,29,55,55,17,17,27,27,56,56,34,34,27,27,63,63,12,12,36,36,55,55,20,20,19,19,17,17,38,38,6,6,38,38,3,3,51,51,31,31,9,9,7,7,7,7,59,59,30,30,1,1,0,0,36,36,15,15,52,52,1,1,40,40,8,8,10,10,59,59,48,48,54,54,56,56,50,50,24,24,39,39,22,22,24,24,51,51,31,31,25,25,27,27,12,12,39,39,3,3,0,0,63,63,33,33,37,37,28,28,59,59,63,63,59,59,31,31,32,32,29,29,57,57,59,59,38,38,16,16,4,4,38,38,10,10,12,12,50,50,44,44,16,16,10,10,48,48,43,43,41,41,39,39,20,20,48,48,38,38,42,42,23,23,32,32,29,29,58,58,13,13,40,40,22,22,38,38,2,2,20,20,22,22,44,44,15,15,61,61,0,0,13,13,34,34,34,34,6,6,25,25,29,29,8,8,63,63,40,40,21,21,16,16,28,28,24,24,17,17,58,58,16,16,46,46,18,18,2,2,7,7,10,10,17,17,36,36,10,10,44,44,40,40,8,8,14,14,36,36,33,33,31,31,38,38,44,44,7,7,58,58,37,37,63,63,1,1,46,46,40,40,15,15,12,12,14,14,30,30,56,56,58,58,56,56,49,49,12,12,58,58,3,3,42,42,8,8,18,18,20,20,41,41,50,50,23,23,45,45,63,63,37,37,54,54,51,51,13,13,53,53,56,56,1,1,34,34,35,35,45,45,26,26,7,7,28,28,46,46,37,37,14,14,12,12,28,28,50,50,43,43,34,34,26,26,52,52,17,17,21,21,21,21,37,37,12,12,59,59,41,41,15,15,42,42,12,12,55,55,49,49,58,58,13,13,3,3,43,43,13,13,8,8,57,57,4,4,55,55,25,25,59,59,38,38,35,35,36,36,10,10,16,16,44,44,0,0,33,33,35,35,13,13,20,20,46,46,57,57,40,40,14,14,12,12,43,43,37,37,34,34,39,39,18,18,18,18,50,50,38,38,44,44,9,9,33,33,42,42,19,19,61,61,12,12,47,47,40,40,41,41,51,51,33,33,48,48,41,41,54,54,48,48,33,33,51,51,15,15,28,28,48,48,25,25,22,22,12,12,30,30,51,51,62,62,10,10,50,50,37,37,62,62,30,30,3,3,19,19,2,2,43,43,49,49,57,57,40,40,19,19,9,9,30,30,14,14,57,57,61,61,9,9,22,22,32,32,18,18,57,57,12,12,32,32,6,6,39,39,33,33,27,27,30,30,12,12,23,23,32,32,5,5,18,18,25,25,8,8,8,8,2,2,17,17,28,28,2,2,40,40,14,14,42,42,45,45,63,63,20,20,35,35,40,40,47,47,57,57,35,35,59,59,33,33,30,30,44,44,55,55,58,58,26,26,39,39,26,26,20,20,29,29,15,15,16,16,32,32,27,27,39,39,23,23,15,15,59,59,6,6,14,14,41,41,48,48,3,3,3,3,3,3,61,61,7,7,19,19,63,63,0,0,36,36,53,53,38,38,56,56,47,47,28,28,1,1,1,1,24,24,34,34,38,38,52,52,50,50,22,22,3,3,19,19,62,62,30,30,32,32,39,39,50,50,11,11,61,61,54,54,34,34,21,21,16,16,41,41,52,52,10,10,40,40,23,23,16,16,12,12,16,16,15,15,6,6,48,48,21,21,12,12,2,2,52,52,37,37,8,8,8,8,19,19,3,3,50,50,10,10,58,58,16,16,23,23,4,4,63,63,39,39,46,46,10,10,6,6,63,63,52,52,48,48,53,53,59,59,47,47,49,49,48,48,17,17,0,0,17,17,31,31,20,20,53,53,13,13,37,37,46,46,2,2,58,58,16,16,18,18,63,63,11,11,40,40,58,58,14,14,52,52,19,19,13,13,16,16,52,52,31,31,21,21,16,16,20,20,40,40,58,58,53,53,33,33,50,50,2,2,22,22,59,59,55,55,23,23,1,1,26,26,3,3,62,62,1,1,58,58,14,14,6,6,6,6,48,48,40,40,4,4,58,58,34,34,22,22,8,8,10,10,6,6,17,17,53,53,2,2,16,16,31,31,47,47,60,60,27,27,39,39,18,18,22,22,43,43,27,27,56,56,24,24,32,32,46,46,18,18,24,24,51,51,11,11,29,29,24,24,40,40,62,62,14,14,32,32,46,46,42,42,50,50,61,61,19,19,50,50,6,6,60,60,21,21,43,43,28,28,34,34,42,42,24,24,13,13,7,7,10,10,53,53,19,19,31,31,7,7,29,29,10,10,24,24,51,51,49,49,12,12,16,16,41,41,3,3,23,23,63,63,49,49,15,15,20,20,18,18,21,21,22,22,2,2,27,27,58,58,15,15,56,56,49,49,18,18,15,15,29,29,51,51,24,24,13,13,15,15,43,43,19,19,14,14,24,24,45,45,32,32,1,1,35,35,34,34,54,54,33,33,48,48,60,60,36,36,19,19,58,58,30,30,10,10,15,15,20,20,30,30,46,46,57,57,42,42,35,35,11,11,46,46,60,60,22,22,59,59,43,43,32,32,43,43,35,35,48,48,8,8,45,45,29,29,7,7,24,24,9,9,11,11,54,54,61,61,28,28,37,37,16,16,17,17,41,41,11,11,27,27,3,3,47,47,52,52,0,0,54,54,19,19,33,33,51,51,9,9,62,62,58,58,58,58,62,62,13,13,24,24,7,7,38,38,21,21,47,47,3,3,17,17,56,56,47,47,4,4,7,7,11,11,43,43,63,63,19,19,48,48,21,21,26,26,20,20,54,54,38,38,6,6,50,50,24,24,36,36,23,23,44,44,29,29,53,53,55,55,3,3,60,60,2,2,25,25,55,55,18,18,42,42,33,33,13,13,10,10,17,17,44,44,17,17,54,54,0,0,53,53,3,3,4,4,49,49,0,0,2,2,62,62,1,1,39,39,5,5,55,55,41,41,25,25,16,16,54,54,53,53,51,51,54,54,32,32,42,42,6,6,14,14,50,50,12,12,17,17,10,10,34,34,7,7,26,26,47,47,17,17,22,22,26,26,21,21,26,26,17,17,52,52,48,48,0,0,31,31,47,47,16,16,34,34,25,25,0,0,47,47,48,48,32,32,55,55,1,1,26,26,18,18,0,0,39,39,51,51,17,17,25,25,29,29,11,11,44,44,51,51,22,22,4,4,58,58,5,5,18,18,58,58,15,15,54,54,54,54,32,32,12,12,38,38,9,9,58,58,8,8,47,47,2,2,24,24,50,50,50,50,32,32,26,26,3,3,16,16,53,53,17,17,43,43,2,2,15,15,3,3,48,48,51,51,62,62,50,50,44,44,52,52,18,18,20,20,6,6,39,39,13,13,12,12,16,16,10,10,9,9,21,21,53,53,55,55,15,15,24,24,18,18,39,39,4,4,7,7,35,35,43,43,8,8,56,56,7,7,45,45,9,9,39,39,56,56,30,30,12,12,56,56,36,36,38,38,27,27,44,44,6,6,36,36,14,14,14,14,16,16,46,46,36,36,19,19,9,9,29,29,21,21,11,11,3,3,54,54,27,27,24,24,52,52,4,4,25,25,2,2,48,48,5,5,56,56,28,28,20,20,1,1,42,42,57,57,50,50,1,1,4,4,12,12,37,37,28,28,36,36,22,22,49,49,8,8,40,40,59,59,36,36,36,36,3,3,8,8,19,19,2,2,5,5,6,6,62,62,47,47,17,17,44,44,61,61,63,63,62,62,14,14,53,53,43,43,14,14,41,41,8,8,3,3,54,54,45,45,26,26,1,1,59,59,17,17,34,34,37,37,54,54,62,62,13,13,3,3,35,35,12,12,12,12,12,12,18,18,20,20,21,21,25,25,6,6,59,59,50,50,51,51,33,33,34,34,27,27,23,23,31,31,41,41,34,34,40,40,29,29,23,23,55,55,16,16,22,22,27,27,28,28,5,5,52,52,49,49,53,53,37,37,12,12,26,26,56,56,18,18,1,1,1,1,14,14,38,38,18,18,62,62,52,52,22,22,25,25,4,4,44,44,33,33,1,1,5,5,20,20,20,20,46,46,40,40,31,31,11,11,16,16,60,60,2,2,39,39,46,46,41,41,58,58,7,7,34,34,1,1,51,51,8,8,45,45,21,21,50,50,29,29,36,36,41,41,9,9,42,42,24,24,26,26,12,12,61,61,19,19,62,62,4,4,39,39,17,17,45,45,3,3,43,43,19,19,39,39,16,16,50,50,23,23,18,18,8,8,21,21,4,4,5,5,39,39,19,19,39,39,50,50,50,50,27,27,46,46,57,57,25,25,42,42,12,12,42,42,10,10,50,50,44,44,18,18,3,3,41,41,22,22,45,45,11,11,57,57,57,57,60,60,12,12,5,5,50,50,33,33,25,25,10,10,36,36,17,17,53,53,7,7,53,53,63,63,61,61,22,22,2,2,43,43,31,31,62,62,31,31,62,62,36,36,53,53,4,4,49,49,28,28,15,15,52,52,61,61,36,36,8,8,44,44,6,6,14,14,20,20,55,55,19,19,23,23,5,5,60,60,49,49,18,18,23,23,3,3,17,17,8,8,51,51,46,46,41,41,6,6,62,62,12,12,52,52,2,2,48,48,34,34,1,1,0,0,4,4,11,11,62,62,27,27,56,56,57,57,63,63,56,56,32,32,24,24,38,38,19,19,16,16,6,6,53,53,51,51,4,4,56,56,24,24,7,7,31,31,16,16,0,0,40,40,25,25,38,38,52,52,31,31,28,28,0,0,43,43,36,36,17,17,16,16,12,12,35,35,58,58,59,59,49,49,37,37,8,8,4,4,43,43,12,12,37,37,2,2,17,17,45,45,35,35,58,58,20,20,20,20,14,14,40,40,40,40,48,48,59,59,35,35,22,22,16,16,34,34,12,12,8,8,29,29,54,54,14,14,42,42,42,42,12,12,34,34,16,16,61,61,57,57,6,6,43,43,47,47,14,14,49,49,20,20,7,7,51,51,28,28,14,14,9,9,0,0,3,3,9,9,33,33,3,3,23,23,32,32,11,11,6,6,18,18,15,15,4,4,0,0,32,32,16,16,2,2,57,57,28,28,54,54,40,40,58,58,57,57,53,53,29,29,26,26,44,44,20,20,48,48,35,35,4,4,19,19,24,24,31,31,42,42,7,7,49,49,16,16,53,53,16,16,4,4,12,12,56,56,1,1,28,28,26,26,57,57,3,3,37,37,30,30,62,62,8,8,55,55,42,42,28,28,31,31,40,40,63,63,6,6,50,50,16,16,48,48,20,20,50,50,9,9,15,15,14,14,3,3,14,14,7,7,29,29,22,22,56,56,46,46,19,19,8,8,24,24,44,44,6,6,34,34,14,14,11,11,1,1,16,16,58,58,46,46,29,29,48,48,4,4,27,27,51,51,44,44,33,33,41,41,42,42,17,17,36,36,25,25,54,54,14,14,30,30,63,63,43,43,49,49,36,36,14,14,11,11,28,28,34,34,8,8,10,10,52,52,63,63,21,21,27,27,3,3,34,34,40,40,41,41,42,42,60,60,25,25,58,58,6,6,58,58,26,26,8,8,44,44,58,58,1,1,53,53,14,14,28,28,32,32,31,31,19,19,59,59,56,56,5,5,15,15,10,10,61,61,56,56,16,16,11,11,18,18,50,50,62,62,6,6,48,48,16,16,15,15,53,53,53,53,44,44,55,55,28,28,29,29,40,40,18,18,45,45,23,23,28,28,38,38,52,52,36,36,3,3,48,48,30,30,6,6,63,63,59,59,34,34,1,1,48,48,28,28,3,3,20,20,48,48,43,43,0,0,3,3,16,16,28,28,52,52,50,50,36,36,10,10,57,57,43,43,61,61,46,46,14,14,17,17,11,11,6,6,62,62,58,58,60,60,62,62,17,17,24,24,50,50,56,56,2,2,28,28,62,62,23,23,49,49,43,43,39,39,57,57,53,53,9,9,19,19,6,6,24,24,3,3,39,39,33,33,32,32,30,30,46,46,8,8,41,41,48,48,42,42,51,51,50,50,61,61,49,49,32,32,22,22,41,41,40,40,14,14,36,36,23,23,16,16,15,15,37,37,4,4,24,24,38,38,26,26,28,28,23,23,5,5,23,23,33,33,30,30,44,44,7,7,15,15,48,48,51,51,19,19,13,13,46,46,21,21,37,37,18,18,37,37,27,27,56,56,45,45,35,35,54,54,16,16,43,43,40,40,19,19,20,20,47,47,62,62,18,18,32,32,38,38,11,11,20,20,9,9,27,27,23,23,22,22,5,5,5,5,8,8,57,57,3,3,17,17,0,0,13,13,47,47,25,25,13,13,9,9,58,58,8,8,26,26,39,39,25,25,7,7,54,54,42,42,44,44,58,58,1,1,6,6,8,8,54,54,35,35,43,43,16,16,51,51,19,19,41,41,19,19,2,2,60,60,3,3,8,8,0,0,52,52,53,53,17,17,20,20,57,57,59,59,8,8,56,56,42,42,44,44,18,18,62,62,54,54,24,24,28,28,35,35,16,16,19,19,4,4,45,45,20,20,25,25,10,10,56,56,34,34,38,38,63,63,2,2,59,59,45,45,11,11,25,25,4,4,15,15,6,6,38,38,24,24,31,31,25,25,0,0,3,3,37,37,56,56,22,22,10,10,14,14,57,57,10,10,3,3,22,22,55,55,56,56,20,20,61,61,46,46,2,2,62,62,57,57,40,40,5,5,30,30,31,31,9,9,31,31,40,40,20,20,47,47,48,48,2,2,48,48,37,37,21,21,46,46,23,23,35,35,7,7,34,34,16,16,31,31,49,49,42,42,8,8,1,1,20,20,37,37,5,5,48,48,16,16,0,0,30,30,14,14,18,18,29,29,36,36,9,9,46,46,60,60,26,26,13,13,38,38,29,29,4,4,47,47,0,0,41,41,42,42,3,3,10,10,35,35,28,28,30,30,0,0,3,3,60,60,3,3,48,48,0,0,45,45,54,54,38,38,46,46,20,20,2,2,3,3,9,9,57,57,22,22,47,47,12,12,25,25,54,54,17,17,18,18,2,2,37,37,15,15,62,62,3,3,52,52,41,41,6,6,17,17,50,50,61,61,13,13,26,26,5,5,5,5,44,44,2,2,52,52,56,56,2,2,46,46,21,21,25,25,22,22,35,35,39,39,57,57,58,58,23,23,13,13,32,32,39,39,62,62,23,23,13,13,62,62,12,12,2,2,33,33,50,50,8,8,37,37,23,23,16,16,9,9,14,14,17,17,40,40,52,52,45,45,13,13,41,41,62,62,50,50,1,1,9,9,52,52,5,5,0,0,39,39,24,24,6,6,45,45,14,14,1,1,11,11,10,10,43,43,34,34,49,49,33,33,13,13,36,36,42,42,1,1,27,27,60,60,25,25,47,47,32,32,61,61,6,6,3,3,9,9,37,37,58,58,14,14,39,39,62,62,20,20,2,2,33,33,25,25,53,53,35,35,55,55,12,12,56,56,32,32,28,28,1,1,5,5,31,31,0,0,16,16,17,17,5,5,3,3,6,6,29,29,45,45,40,40,31,31,48,48,10,10,1,1,59,59,32,32,63,63,0,0,19,19,13,13,10,10,11,11,25,25,50,50,62,62,22,22,39,39,39,39,17,17,16,16,16,16,15,15,2,2,21,21,8,8,60,60,2,2,30,30,56,56,52,52,18,18,56,56,30,30,6,6,50,50,50,50,49,49,13,13,41,41,14,14,14,14,28,28,2,2,45,45,5,5,44,44,58,58,2,2,0,0,16,16,8,8,12,12,9,9,48,48,48,48,44,44,38,38,1,1,13,13,43,43,44,44,48,48,0,0,32,32,8,8,55,55,15,15,37,37,52,52,32,32,16,16,1,1,33,33,4,4,25,25,12,12,12,12,15,15,52,52,15,15,40,40,4,4,18,18,16,16,14,14,34,34,0,0,52,52,60,60,54,54,51,51,36,36,21,21,27,27,22,22,1,1,21,21,27,27,45,45,53,53,54,54,19,19,47,47,18,18,13,13,41,41,50,50,10,10,39,39,38,38,32,32,12,12,60,60,43,43,13,13,2,2,17,17,37,37,53,53,11,11,7,7,10,10,42,42,33,33,21,21,37,37,32,32,51,51,27,27,31,31,24,24,45,45,9,9,56,56,13,13,4,4,44,44,62,62,4,4,60,60,10,10,30,30,19,19,42,42,55,55,35,35,37,37,26,26,5,5,9,9,32,32,49,49,27,27,56,56,52,52,16,16,5,5,20,20,10,10,32,32,31,31,10,10,42,42,47,47,35,35,56,56,58,58,7,7,31,31,21,21,21,21,38,38,55,55,38,38,32,32,8,8,7,7,4,4,36,36,57,57,58,58,58,58,48,48,60,60,12,12,5,5,35,35,41,41,12,12,14,14,19,19,60,60,16,16,8,8,43,43,16,16,6,6,14,14,18,18,4,4,15,15,51,51,8,8,23,23,48,48,50,50,63,63,48,48,33,33,1,1,6,6,43,43,33,33,16,16,63,63,36,36,44,44,23,23,57,57,11,11,32,32,21,21,20,20,20,20,9,9,38,38,25,25,31,31,40,40,8,8,20,20,25,25,8,8,49,49,3,3,59,59,40,40,54,54,39,39,6,6,24,24,1,1,24,24,4,4,37,37,42,42,6,6,8,8,2,2,40,40,33,33,33,33,36,36,40,40,61,61,36,36,57,57,21,21,14,14,55,55,5,5,15,15,34,34,35,35,19,19,8,8,3,3,50,50,54,54,40,40,28,28,8,8,32,32,58,58,14,14,52,52,59,59,4,4,39,39,22,22,9,9,0,0,48,48,33,33,27,27,25,25,17,17,16,16,46,46,41,41,26,26,18,18,6,6,31,31,40,40,27,27,46,46,56,56,57,57,41,41,21,21,3,3,54,54,49,49,57,57,19,19,55,55,37,37,19,19,17,17,57,57,21,21,38,38,38,38,26,26,49,49,27,27,21,21,53,53,46,46,3,3,1,1,12,12,60,60,31,31,44,44,18,18,10,10,45,45,6,6,42,42,38,38,51,51,11,11,14,14,22,22,11,11,41,41,62,62,31,31,59,59,56,56,32,32,21,21,28,28,14,14,52,52,16,16,12,12,54,54,14,14,59,59,11,11,18,18,33,33,21,21,56,56,40,40,47,47,58,58,51,51,1,1,4,4,22,22,30,30,0,0,53,53,21,21,13,13,6,6,46,46,24,24,58,58,1,1,15,15,17,17,33,33,42,42,0,0,32,32,42,42,0,0,30,30,35,35,10,10,26,26,13,13,30,30,29,29,18,18,63,63,20,20,3,3,62,62,46,46,40,40,62,62,16,16,4,4,1,1,27,27,36,36,63,63,10,10,11,11,44,44,9,9,49,49,54,54,19,19,9,9,2,2,13,13,17,17,45,45,10,10,15,15,22,22,30,30,2,2,2,2,58,58,2,2,50,50,37,37,53,53,26,26,1,1,53,53,29,29,45,45,36,36,20,20,47,47,47,47,20,20,35,35,30,30,40,40,60,60,63,63,60,60,7,7,58,58,58,58,57,57,40,40,19,19,60,60,22,22,28,28,36,36,18,18,50,50,58,58,44,44,43,43,4,4,42,42,17,17,51,51,40,40,63,63,14,14,60,60,2,2,22,22,45,45,30,30,11,11,57,57,61,61,26,26,22,22,35,35,53,53,23,23,27,27,18,18,31,31,55,55,15,15,27,27,49,49,11,11,60,60,44,44,11,11,40,40,48,48,7,7,31,31,26,26,61,61,31,31,2,2,42,42,18,18,3,3,6,6,51,51,3,3,30,30,20,20,51,51,8,8,25,25,52,52,57,57,59,59,53,53,16,16,39,39,43,43,19,19,11,11,17,17,30,30,42,42,7,7,31,31,32,32,28,28,48,48,38,38,46,46,63,63,21,21,19,19,58,58,14,14,1,1,55,55,3,3,8,8,10,10,51,51,44,44,39,39,31,31,0,0,60,60,56,56,35,35,40,40,44,44,34,34,15,15,55,55,54,54,3,3,30,30,39,39,8,8,57,57,2,2,33,33,18,18,45,45,19,19,33,33,9,9,18,18,7,7,4,4,52,52,50,50,53,53,60,60,58,58,24,24,51,51,10,10,51,51,2,2,42,42,59,59,45,45,36,36,41,41,46,46,9,9,43,43,15,15,45,45,3,3,42,42,29,29,45,45,15,15,24,24,44,44,39,39,35,35,35,35,28,28,44,44,49,49,6,6,55,55,28,28,45,45,54,54,27,27,31,31,13,13,27,27,20,20,16,16,36,36,18,18,27,27,25,25,35,35,19,19,33,33,57,57,19,19,49,49,18,18,8,8,35,35,39,39,26,26,53,53,20,20,30,30,49,49,10,10,44,44,9,9,59,59,45,45,49,49,33,33,61,61,52,52,42,42,44,44,4,4,8,8,44,44,9,9,54,54,29,29,8,8,53,53,6,6,47,47,53,53,38,38,7,7,29,29,33,33,12,12,25,25,36,36,49,49,36,36,55,55,23,23,1,1,11,11,22,22,23,23,63,63,22,22,46,46,45,45,12,12,51,51,2,2,63,63,15,15,56,56,5,5,2,2,20,20,20,20,62,62,56,56,51,51,1,1,50,50,37,37,13,13,14,14,14,14,60,60,40,40,1,1,50,50,14,14,37,37,11,11,30,30,8,8,6,6,45,45,55,55,58,58,14,14,3,3,31,31,45,45,3,3,28,28,5,5,37,37,42,42,36,36,32,32,56,56,4,4,58,58,23,23,59,59,10,10,53,53,27,27,25,25,1,1,24,24,1,1,42,42,20,20,37,37,63,63,1,1,52,52,16,16,17,17,29,29,2,2,35,35,23,23,58,58,12,12,36,36,34,34,62,62,40,40,3,3,28,28,33,33,8,8,40,40,30,30,62,62,20,20,52,52,43,43,6,6,62,62,1,1,5,5,14,14,10,10,22,22,24,24,16,16,21,21,6,6,12,12,39,39,40,40,17,17,22,22,24,24,4,4,1,1,21,21,27,27,30,30,47,47,18,18,29,29,9,9,39,39,42,42,17,17,23,23,46,46,50,50,58,58,49,49,10,10,61,61,32,32,19,19,0,0,5,5,19,19,4,4,57,57,23,23,62,62,3,3,21,21,35,35,29,29,49,49,39,39,55,55,15,15,2,2,14,14,8,8,9,9,35,35,36,36,10,10,45,45,27,27,43,43,4,4,62,62,4,4,9,9,14,14,54,54,47,47,13,13,19,19,60,60,4,4,48,48,1,1,44,44,43,43,56,56,7,7,18,18,1,1,40,40,38,38,21,21,50,50,60,60,60,60,16,16,60,60,5,5,43,43,41,41,2,2,21,21,38,38,5,5,38,38,43,43,62,62,15,15,10,10,26,26,50,50,56,56,10,10,12,12,7,7,58,58,14,14,18,18,60,60,52,52,2,2,0,0,54,54,4,4,41,41,25,25,47,47,18,18,1,1,16,16,10,10,42,42,1,1,57,57,57,57,34,34,16,16,29,29,45,45,14,14,24,24,61,61,40,40,60,60,6,6,9,9,6,6,10,10,48,48,57,57,23,23,17,17,30,30,14,14,9,9,0,0,38,38,18,18,42,42,21,21,42,42,11,11,10,10,14,14,23,23,21,21,27,27,61,61,27,27,39,39,52,52,16,16,26,26,26,26,62,62,38,38,21,21,32,32,30,30,33,33,45,45,3,3,43,43,36,36,61,61,23,23,29,29,21,21,7,7,38,38,58,58,14,14,22,22,43,43,38,38,6,6,44,44,9,9,36,36,57,57,47,47,57,57,52,52,5,5,13,13,50,50,26,26,12,12,42,42,54,54,24,24,32,32,44,44,56,56,35,35,33,33,21,21,17,17,8,8,20,20,0,0,0,0,34,34,58,58,40,40,19,19,3,3,47,47,1,1,2,2,26,26,61,61,42,42,22,22,0,0,11,11,5,5,46,46,45,45,34,34,43,43,3,3,15,15,33,33,28,28,36,36,51,51,14,14,52,52,33,33,33,33,35,35,22,22,60,60,38,38,38,38,34,34,24,24,50,50,42,42,12,12,4,4,40,40,5,5,20,20,1,1,0,0,58,58,4,4,9,9,41,41,22,22,46,46,9,9,3,3,12,12,61,61,44,44,58,58,56,56,8,8,34,34,42,42,54,54,28,28,37,37,26,26,28,28,46,46,60,60,63,63,3,3,42,42,9,9,0,0,15,15,39,39,32,32,13,13,51,51,59,59,36,36,41,41,4,4,48,48,11,11,26,26,35,35,57,57,56,56,51,51,4,4,2,2,41,41,25,25,31,31,35,35,9,9,26,26,4,4,53,53,25,25,25,25,26,26,41,41,23,23,1,1,30,30,40,40,47,47,50,50,63,63,8,8,35,35,16,16,18,18,2,2,28,28,7,7,6,6,3,3,2,2,25,25,21,21,38,38,36,36,14,14,41,41,61,61,22,22,31,31,30,30,21,21,15,15,15,15,45,45,48,48,11,11,36,36,5,5,3,3,12,12,59,59,40,40,57,57,28,28,4,4,56,56,42,42,41,41,40,40,20,20,12,12,12,12,60,60,11,11,36,36,24,24,19,19,32,32,61,61,54,54,1,1,58,58,18,18,1,1,40,40,12,12,41,41,42,42,27,27,40,40,10,10,56,56,35,35,55,55,44,44,18,18,44,44,45,45,33,33,30,30,55,55,23,23,52,52,57,57,56,56,35,35,39,39,52,52,2,2,3,3,2,2,28,28,7,7,46,46,33,33,31,31,59,59,45,45,12,12,4,4,1,1,6,6,57,57,13,13,45,45,2,2,1,1,58,58,28,28,15,15,8,8,40,40,31,31,2,2,12,12,54,54,52,52,7,7,12,12,6,6,57,57,24,24,58,58,21,21,54,54,63,63,46,46,38,38,22,22,53,53,56,56,31,31,29,29,11,11,2,2,5,5,31,31,36,36,20,20,40,40,3,3,3,3,2,2,33,33,59,59,1,1,14,14,50,50,50,50,15,15,37,37,11,11,23,23,46,46,40,40,3,3,16,16,30,30,55,55,34,34,52,52,12,12,49,49,34,34,19,19,6,6,57,57,37,37,26,26,63,63,32,32,55,55,47,47,7,7,52,52,20,20,47,47,55,55,34,34,23,23,2,2,14,14,39,39,53,53,15,15,56,56,35,35,18,18,47,47,40,40,40,40,7,7,26,26,48,48,62,62,5,5,62,62,44,44,61,61,32,32,38,38,50,50,4,4,1,1,57,57,29,29,61,61,53,53,39,39,41,41,45,45,15,15,26,26,32,32,11,11,2,2,28,28,48,48,8,8,13,13,41,41,42,42,38,38,13,13,2,2,57,57,41,41,2,2,38,38,48,48,4,4,29,29,39,39,21,21,18,18,58,58,1,1,48,48,22,22,31,31,37,37,8,8,45,45,41,41,27,27,6,6,32,32,55,55,53,53,10,10,32,32,7,7,11,11,44,44,53,53,58,58,27,27,36,36,53,53,32,32,18,18,38,38,9,9,36,36,20,20,43,43,22,22,34,34,28,28,49,49,19,19,38,38,35,35,9,9,30,30,5,5,55,55,4,4,10,10,44,44,52,52,8,8,46,46,22,22,32,32,42,42,52,52,31,31,46,46,55,55,22,22,25,25,18,18,51,51,62,62,0,0,22,22,42,42,43,43,36,36,49,49,33,33,60,60,18,18,11,11,55,55,56,56,58,58,21,21,46,46,15,15,27,27,37,37,19,19,35,35,46,46,22,22,46,46,8,8,28,28,49,49,26,26,28,28,24,24,58,58,36,36,37,37,14,14,33,33,52,52,55,55,29,29,49,49,42,42,41,41,39,39,60,60,22,22,8,8,25,25,7,7,11,11,9,9,59,59,61,61,61,61,38,38,56,56,46,46,6,6,57,57,19,19,17,17,6,6,54,54,54,54,30,30,34,34,25,25,21,21,17,17,1,1,48,48,46,46,26,26,50,50,30,30,60,60,48,48,25,25,34,34,15,15,18,18,17,17,45,45,9,9,13,13,48,48,8,8,0,0,15,15,24,24,53,53,10,10,31,31,55,55,49,49,15,15,18,18,54,54,36,36,63,63,25,25,1,1,13,13,36,36,40,40,60,60,0,0,6,6,3,3,59,59,9,9,42,42,53,53,58,58,51,51,42,42,18,18,30,30,24,24,41,41,60,60,11,11,28,28,2,2,54,54,39,39,52,52,19,19,4,4,35,35,17,17,5,5,13,13,28,28,43,43,2,2,12,12,56,56,37,37,2,2,33,33,40,40,34,34,44,44,7,7,14,14,38,38,56,56,23,23,44,44,24,24,1,1,5,5,1,1,9,9,35,35,45,45,9,9,2,2,33,33,0,0,31,31,22,22,13,13,22,22,59,59,34,34,10,10,1,1,56,56,49,49,23,23,27,27,63,63,32,32,60,60,22,22,52,52,47,47,14,14,44,44,32,32,59,59,32,32,3,3,32,32,60,60,41,41,9,9,58,58,27,27,52,52,56,56,10,10,54,54,15,15,34,34,40,40,20,20,43,43,45,45,37,37,42,42,18,18,37,37,3,3,53,53,51,51,31,31,5,5,25,25,14,14,35,35,62,62,3,3,5,5,29,29,38,38,59,59,51,51,17,17,34,34,38,38,1,1,24,24,29,29,25,25,15,15,50,50,32,32,25,25,22,22,21,21,39,39,37,37,20,20,5,5,6,6,12,12,57,57,3,3,62,62,6,6,52,52,5,5,28,28,10,10,19,19,17,17,27,27,8,8,59,59,18,18,8,8,4,4,15,15,58,58,36,36,20,20,20,20,30,30,35,35,58,58,1,1,28,28,32,32,38,38,31,31,57,57,39,39,10,10,2,2,42,42,28,28,29,29,32,32,56,56,12,12,25,25,22,22,8,8,58,58,20,20,36,36,20,20,60,60,32,32,22,22,48,48,17,17,61,61,9,9,42,42,25,25,16,16,5,5,17,17,15,15,54,54,55,55,56,56,3,3,16,16,32,32,8,8,12,12,38,38,50,50,38,38,34,34,16,16,34,34,4,4,20,20,30,30,42,42,12,12,18,18,44,44,2,2,46,46,11,11,52,52,50,50,44,44,17,17,18,18,1,1,25,25,48,48,35,35,25,25,36,36,2,2,53,53,58,58,24,24,18,18,4,4,33,33,56,56,17,17,57,57,28,28,32,32,11,11,62,62,4,4,6,6,15,15,10,10,17,17,23,23,45,45,43,43,13,13,29,29,50,50,15,15,2,2,16,16,41,41,16,16,51,51,7,7,59,59,62,62,16,16,32,32,40,40,12,12,50,50,58,58,22,22,51,51,13,13,3,3,50,50,36,36,61,61,41,41,22,22,36,36,49,49,27,27,60,60,48,48,21,21,37,37,3,3,34,34,34,34,0,0,7,7,54,54,22,22,16,16,49,49,2,2,33,33,37,37,5,5,23,23,13,13,7,7,35,35,43,43,47,47,6,6,22,22,0,0,21,21,16,16,21,21,40,40,15,15,51,51,29,29,17,17,34,34,7,7,39,39,29,29,30,30,2,2,44,44,34,34,8,8,20,20,57,57,29,29,31,31,57,57,30,30,1,1,54,54,24,24,46,46,16,16,41,41,59,59,34,34,3,3,53,53,42,42,26,26,61,61,12,12,2,2,21,21,25,25,43,43,48,48,18,18,44,44,33,33,43,43,34,34,9,9,22,22,1,1,16,16,53,53,19,19,46,46,58,58,9,9,28,28,25,25,36,36,40,40,29,29,40,40,47,47,37,37,53,53,22,22,45,45,46,46,15,15,26,26,50,50,36,36,58,58,52,52,18,18,4,4,50,50,2,2,3,3,56,56,43,43,46,46,49,49,33,33,21,21,1,1,8,8,14,14,12,12,36,36,21,21,1,1,55,55,60,60,4,4,14,14,58,58,38,38,4,4,30,30,8,8,43,43,53,53,54,54,58,58,26,26,48,48,34,34,62,62,2,2,15,15,38,38,16,16,20,20,57,57,14,14,34,34,13,13,12,12,44,44,43,43,41,41,57,57,34,34,28,28,32,32,61,61,61,61,4,4,51,51,62,62,38,38,1,1,23,23,52,52,38,38,9,9,30,30,23,23,22,22,10,10,23,23,62,62,51,51,20,20,25,25,57,57,50,50,25,25,28,28,22,22,21,21,58,58,62,62,14,14,61,61,31,31,3,3,15,15,46,46,33,33,55,55,54,54,38,38,0,0,51,51,61,61,32,32,14,14,3,3,16,16,9,9,8,8,17,17,28,28,23,23,5,5,24,24,8,8,35,35,30,30,6,6,47,47,63,63,27,27,52,52,23,23,20,20,63,63,13,13,39,39,1,1,34,34,0,0,32,32,56,56,60,60,56,56,38,38,3,3,10,10,33,33,0,0,40,40,13,13,42,42,12,12,8,8,27,27,34,34,8,8,52,52,42,42,18,18,21,21,33,33,34,34,3,3,22,22,53,53,7,7,0,0,6,6,27,27,15,15,18,18,21,21,40,40,36,36,23,23,4,4,9,9,37,37,14,14,58,58,51,51,30,30,11,11,28,28,14,14,56,56,51,51,4,4,48,48,57,57,36,36,43,43,21,21,11,11,1,1,6,6,42,42,42,42,46,46,5,5,9,9,25,25,42,42,8,8,61,61,39,39,28,28,25,25,4,4,25,25,10,10,13,13,11,11,14,14,43,43,43,43,17,17,30,30,35,35,21,21,25,25,45,45,12,12,47,47,2,2,13,13,27,27,28,28,14,14,25,25,7,7,52,52,53,53,46,46,17,17,30,30,20,20,33,33,32,32,21,21,59,59,39,39,29,29,50,50,31,31,53,53,29,29,47,47,45,45,55,55,52,52,37,37,59,59,60,60,41,41,37,37,5,5,50,50,10,10,60,60,7,7,1,1,55,55,13,13,6,6,37,37,20,20,62,62,35,35,19,19,57,57,52,52,24,24,37,37,10,10,42,42,38,38,28,28,22,22,34,34,2,2,61,61,44,44,7,7,40,40,15,15,34,34,28,28,22,22,28,28,34,34,1,1,6,6,52,52,21,21,2,2,16,16,35,35,44,44,53,53,38,38,36,36,43,43,0,0,32,32,15,15,27,27,42,42,32,32,61,61,58,58,54,54,49,49,21,21,16,16,34,34,38,38,48,48,45,45,48,48,55,55,2,2,25,25,33,33,21,21,44,44,63,63,13,13,35,35,48,48,18,18,31,31,58,58,2,2,35,35,59,59,7,7,0,0,59,59,9,9,52,52,63,63,27,27,27,27,20,20,39,39,9,9,13,13,40,40,6,6,19,19,5,5,3,3,32,32,47,47,34,34,8,8,11,11,40,40,1,1,47,47,27,27,29,29,63,63,42,42,9,9,28,28,4,4,59,59,25,25,26,26,38,38,48,48,1,1,0,0,6,6,63,63,55,55,21,21,14,14,2,2,12,12,39,39,13,13,16,16,54,54,31,31,7,7,56,56,25,25,59,59,34,34,5,5,51,51,39,39,38,38,56,56,20,20,33,33,37,37,43,43,2,2,0,0,54,54,58,58,34,34,40,40,34,34,10,10,58,58,5,5,23,23,28,28,32,32,40,40,62,62,54,54,32,32,49,49,44,44,51,51,41,41,46,46,31,31,49,49,37,37,20,20,50,50,6,6,17,17,55,55,53,53,20,20,50,50,27,27,26,26,54,54,2,2,52,52,58,58,57,57,57,57,40,40,55,55,50,50,22,22,1,1,6,6,28,28,11,11,0,0,1,1,3,3,46,46,40,40,39,39,45,45,24,24,10,10,21,21,33,33,9,9,24,24,16,16,49,49,10,10,17,17,60,60,15,15,12,12,53,53,16,16,48,48,3,3,36,36,51,51,21,21,58,58,50,50,22,22,21,21,20,20,51,51,47,47,59,59,42,42,57,57,21,21,32,32,23,23,38,38,2,2,23,23,60,60,17,17,20,20,14,14,17,17,14,14,22,22,60,60,7,7,9,9,49,49,16,16,53,53,55,55,42,42,57,57,31,31,42,42,8,8,4,4,4,4,43,43,48,48,0,0,49,49,27,27,61,61,36,36,46,46,12,12,3,3,39,39,61,61,28,28,4,4,3,3,9,9,29,29,0,0,53,53,30,30,20,20,21,21,60,60,3,3,62,62,45,45,46,46,57,57,58,58,61,61,56,56,10,10,4,4,61,61,9,9,6,6,17,17,47,47,62,62,17,17,55,55,2,2,19,19,18,18,5,5,52,52,56,56,29,29,47,47,25,25,62,62,43,43,5,5,5,5,1,1,54,54,62,62,52,52,40,40,4,4,60,60,13,13,19,19,46,46,7,7,17,17,16,16,57,57,39,39,51,51,43,43,58,58,47,47,43,43,39,39,2,2,6,6,28,28,9,9,23,23,6,6,49,49,25,25,2,2,21,21,51,51,17,17,53,53,34,34,7,7,10,10,12,12,38,38,16,16,29,29,37,37,41,41,20,20,48,48,6,6,3,3,12,12,48,48,44,44,4,4,3,3,43,43,12,12,34,34,55,55,25,25,14,14,21,21,2,2,28,28,25,25,21,21,0,0,28,28,3,3,56,56,52,52,33,33,24,24,19,19,14,14,0,0,20,20,15,15,17,17,2,2,49,49,29,29,42,42,4,4,52,52,9,9,22,22,55,55,23,23,31,31,9,9,34,34,32,32,30,30,48,48,39,39,22,22,14,14,39,39,1,1,6,6,7,7,5,5,31,31,44,44,32,32,40,40,11,11,30,30,54,54,47,47,18,18,11,11,38,38,58,58,18,18,18,18,16,16,28,28,7,7,15,15,15,15,48,48,9,9,19,19,24,24,2,2,52,52,55,55,20,20,13,13,17,17,6,6,17,17,17,17,19,19,24,24,27,27,5,5,6,6,23,23,12,12,63,63,33,33,39,39,0,0,4,4,17,17,55,55,24,24,40,40,7,7,16,16,44,44,42,42,34,34,34,34,38,38,43,43,53,53,25,25,52,52,61,61,8,8,6,6,58,58,14,14,53,53,35,35,46,46,2,2,54,54,11,11,39,39,8,8,57,57,37,37,58,58,28,28,49,49,24,24,18,18,3,3,10,10,15,15,44,44,59,59,47,47,14,14,12,12,35,35,36,36,10,10,54,54,3,3,52,52,14,14,62,62,63,63,50,50,51,51,37,37,25,25,18,18,39,39,5,5,45,45,30,30,20,20,1,1,36,36,46,46,37,37,7,7,24,24,12,12,13,13,49,49,10,10,6,6,9,9,58,58,9,9,50,50,52,52,19,19,19,19,4,4,35,35,27,27,36,36,32,32,2,2,38,38,59,59,0,0,24,24,56,56,5,5,62,62,59,59,61,61,35,35,45,45,52,52,36,36,16,16,50,50,0,0,44,44,39,39,5,5,47,47,42,42,1,1,62,62,50,50,9,9,11,11,51,51,24,24,1,1,30,30,53,53,35,35,24,24,19,19,62,62,60,60,6,6,44,44,35,35,46,46,31,31,39,39,41,41,60,60,26,26,38,38,40,40,21,21,37,37,49,49,0,0,18,18,6,6,25,25,3,3,32,32,36,36,42,42,17,17,8,8,55,55,10,10,33,33,4,4,51,51,5,5,61,61,34,34,41,41,48,48,30,30,57,57,31,31,19,19,11,11,36,36,32,32,17,17,41,41,49,49,34,34,18,18,47,47,51,51,38,38,46,46,28,28,12,12,56,56,31,31,60,60,62,62,16,16,18,18,6,6,42,42,38,38,3,3,45,45,60,60,55,55,25,25,28,28,55,55,62,62,8,8,4,4,3,3,7,7,36,36,57,57,37,37,55,55,38,38,48,48,28,28,41,41,56,56,26,26,8,8,46,46,16,16,62,62,25,25,38,38,52,52,37,37,35,35,4,4,11,11,56,56,52,52,45,45,25,25,14,14,39,39,60,60,11,11,12,12,30,30,3,3,16,16,2,2,53,53,0,0,43,43,15,15,8,8,57,57,8,8,33,33,44,44,11,11,46,46,37,37,23,23,46,46,45,45,26,26,9,9,3,3,32,32,14,14,4,4,39,39,37,37,60,60,55,55,22,22,3,3,47,47,33,33,6,6,49,49,48,48,50,50,1,1,48,48,58,58,18,18,37,37,57,57,55,55,24,24,20,20,53,53,16,16,25,25,13,13,6,6,25,25,40,40,23,23,34,34,10,10,19,19,10,10,7,7,52,52,8,8,21,21,28,28,9,9,1,1,4,4,14,14,11,11,48,48,63,63,51,51,3,3,26,26,14,14,48,48,24,24,7,7,61,61,34,34,41,41,12,12,46,46,48,48,63,63,49,49,14,14,16,16,6,6,43,43,34,34,57,57,31,31,20,20,37,37,39,39,2,2,19,19,9,9,5,5,27,27,3,3,6,6,39,39,2,2,24,24,9,9,24,24,2,2,32,32,22,22,0,0,1,1,2,2,27,27,50,50,5,5,1,1,59,59,39,39,56,56,0,0,24,24,52,52,55,55,24,24,45,45,31,31,22,22,21,21,25,25,59,59,56,56,31,31,20,20,14,14,23,23,24,24,43,43,24,24,33,33,26,26,23,23,4,4,8,8,26,26,54,54,4,4,51,51,43,43,51,51,57,57,48,48,42,42,34,34,22,22,32,32,15,15,30,30,48,48,14,14,51,51,55,55,33,33,18,18,4,4,1,1,19,19,29,29,27,27,7,7,6,6,49,49,4,4,8,8,15,15,23,23,55,55,3,3,11,11,23,23,42,42,40,40,60,60,5,5,29,29,57,57,12,12,46,46,17,17,8,8,1,1,37,37,39,39,62,62,2,2,36,36,20,20,43,43,22,22,7,7,28,28,19,19,58,58,7,7,19,19,36,36,21,21,19,19,18,18,33,33,0,0,32,32,24,24,31,31,49,49,24,24,46,46,59,59,8,8,10,10,25,25,49,49,17,17,5,5,2,2,62,62,5,5,35,35,41,41,6,6,54,54,3,3,47,47,27,27,57,57,8,8,7,7,55,55,53,53,43,43,56,56,31,31,14,14,60,60,5,5,63,63,22,22,33,33,6,6,35,35,49,49,46,46,14,14,26,26,58,58,11,11,50,50,11,11,14,14,62,62,19,19,8,8,44,44,6,6,32,32,9,9,57,57,42,42,53,53,56,56,37,37,20,20,62,62,37,37,53,53,8,8,49,49,10,10,1,1,57,57,9,9,28,28,17,17,47,47,62,62,3,3,9,9,9,9,43,43,33,33,62,62,59,59,53,53,61,61,32,32,36,36,6,6,38,38,4,4,27,27,28,28,36,36,2,2,16,16,3,3,16,16,7,7,5,5,62,62,28,28,16,16,40,40,56,56,51,51,11,11,41,41,35,35,32,32,21,21,18,18,5,5,37,37,31,31,56,56,2,2,24,24,49,49,19,19,12,12,11,11,28,28,41,41,7,7,14,14,46,46,7,7,43,43,41,41,63,63,7,7,61,61,57,57,9,9,44,44,39,39,49,49,61,61,32,32,38,38,34,34,8,8,14,14,3,3,39,39,21,21,14,14,20,20,11,11,57,57,45,45,34,34,13,13,56,56,39,39,8,8,36,36,17,17,26,26,60,60,36,36,50,50,10,10,43,43,29,29,7,7,36,36,36,36,20,20,47,47,1,1,11,11,13,13,55,55,30,30,0,0,51,51,8,8,12,12,48,48,12,12,53,53,19,19,23,23,0,0,37,37,10,10,6,6,48,48,17,17,44,44,9,9,59,59,49,49,27,27,38,38,28,28,19,19,3,3,51,51,36,36,46,46,62,62,49,49,50,50,42,42,20,20,20,20,7,7,24,24,25,25,12,12,4,4,27,27,53,53,50,50,44,44,32,32,21,21,31,31,8,8,2,2,38,38,14,14,50,50,44,44,16,16,34,34,48,48,8,8,62,62,47,47,30,30,57,57,5,5,47,47,50,50,49,49,17,17,18,18,50,50,1,1,20,20,17,17,3,3,37,37,42,42,36,36,31,31,48,48,8,8,36,36,7,7,7,7,2,2,47,47,14,14,45,45,54,54,11,11,26,26,6,6,54,54,18,18,37,37,63,63,32,32,0,0,4,4,24,24,15,15,1,1,22,22,35,35,59,59,43,43,55,55,60,60,2,2,40,40,52,52,7,7,49,49,61,61,3,3,19,19,15,15,17,17,52,52,42,42,49,49,24,24,36,36,58,58,18,18,7,7,8,8,55,55,41,41,58,58,22,22,48,48,34,34,27,27,40,40,24,24,1,1,9,9,1,1,40,40,46,46,14,14,27,27,11,11,53,53,20,20,11,11,38,38,0,0,13,13,60,60,20,20,23,23,27,27,31,31,11,11,8,8,47,47,13,13,31,31,21,21,5,5,33,33,7,7,25,25,30,30,54,54,14,14,28,28,23,23,61,61,34,34,22,22,41,41,62,62,5,5,10,10,17,17,25,25,6,6,52,52,24,24,28,28,58,58,37,37,61,61,53,53,44,44,41,41,16,16,38,38,44,44,38,38,60,60,9,9,26,26,52,52,33,33,9,9,56,56,23,23,8,8,1,1,27,27,24,24,29,29,8,8,57,57,30,30,29,29,57,57,41,41,38,38,29,29,46,46,51,51,28,28,14,14,43,43,46,46,26,26,23,23,21,21,61,61,6,6,47,47,35,35,24,24,29,29,56,56,56,56,10,10,14,14,54,54,2,2,36,36,60,60,62,62,21,21,8,8,29,29,61,61,35,35,19,19,10,10,47,47,61,61,11,11,39,39,30,30,51,51,36,36,42,42,13,13,28,28,41,41,46,46,54,54,51,51,52,52,33,33,37,37,4,4,13,13,5,5,10,10,63,63,34,34,8,8,43,43,20,20,52,52,35,35,10,10,28,28,14,14,28,28,31,31,27,27,16,16,41,41,12,12,20,20,56,56,29,29,50,50,19,19,28,28,59,59,4,4,32,32,40,40,23,23,12,12,28,28,18,18,16,16,30,30,11,11,28,28,34,34,29,29,19,19,41,41,50,50,17,17,37,37,34,34,53,53,24,24,14,14,59,59,43,43,48,48,4,4,49,49,51,51,63,63,1,1,63,63,42,42,48,48,63,63,42,42,17,17,3,3,25,25,23,23,7,7,25,25,1,1,31,31,35,35,11,11,24,24,6,6,44,44,6,6,40,40,8,8,37,37,5,5,38,38,54,54,58,58,9,9,52,52,7,7,39,39,39,39,18,18,36,36,2,2,5,5,43,43,23,2