// This file is part of the FidelityFX SDK.
//
// Copyright (C) 2024 Advanced Micro Devices, Inc.
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files(the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and /or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions :
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// An Owen-scrambled Sobol sequence of 256 samples of 256 dimensions
static const int sobol_256spp_256d[256*256] = {32,226,72,70,57,171,246,75,112,81,109,239,120,101,230,103,103,41,249,86,253,99,132,184,214,147,128,248,17,149,163,17,60,40,169,196,77,79,102,23,250,77,75,151,95,123,234,198,25,26,184,114,230,188,105,18,231,233,175,151,19,174,202,71,84,229,247,148,182,127,92,14,41,112,162,253,35,101,137,30,111,134,95,122,28,2,41,254,181,91,101,188,145,31,166,38,53,193,1,122,99,86,178,36,198,169,113,255,97,221,227,231,29,100,30,141,250,254,16,157,2,220,187,95,181,125,207,187,105,119,156,41,16,194,93,216,227,124,138,90,227,1,88,153,233,69,120,36,19,189,120,4,185,220,185,109,184,96,247,173,210,227,54,3,18,9,139,213,156,57,61,101,37,247,21,201,10,143,11,38,146,18,118,129,95,191,75,207,12,252,238,104,47,39,190,229,31,56,20,127,42,178,100,141,93,222,192,247,186,7,224,161,72,100,87,69,218,44,25,195,185,118,179,123,231,170,96,225,204,52,117,60,3,86,25,143,230,18,11,165,72,188,158,3,66,105,50,200,226,145,227,45,183,62,82,176,191,36,248,191,189,122,96,185,146,166,203,78,144,189,67,174,154,182,86,169,90,236,101,40,71,107,81,93,159,82,75,230,157,191,34,35,235,139,150,193,10,142,217,77,154,249,74,13,196,248,56,154,27,6,242,226,105,94,66,67,145,112,31,145,133,68,21,0,44,212,254,153,183,238,98,102,145,199,100,213,196,52,131,141,216,209,236,122,58,249,188,108,8,206,62,199,207,103,160,247,207,255,101,185,1,113,223,126,182,0,50,93,250,174,194,18,65,111,206,104,156,3,48,195,122,212,10,101,235,200,13,183,173,7,192,3,101,228,84,168,121,241,205,122,115,132,155,242,215,22,236,242,69,35,48,245,3,175,68,57,4,15,226,155,222,140,54,48,80,200,194,149,213,68,225,14,182,122,147,195,69,166,191,17,176,58,222,58,190,70,66,153,196,215,121,123,176,190,161,145,203,121,255,27,207,28,113,22,44,232,46,84,181,131,245,220,27,202,161,38,94,208,39,143,52,5,154,85,121,139,226,223,159,246,170,56,94,209,188,71,205,76,16,233,168,172,200,37,19,123,120,202,28,175,232,88,120,107,157,198,111,253,18,24,36,35,43,169,199,197,137,194,12,238,138,232,17,17,58,115,39,234,4,164,225,215,14,185,232,76,215,171,142,206,206,132,90,31,130,24,0,165,34,91,126,113,64,202,144,114,132,125,58,184,234,211,246,238,168,7,1,172,169,218,67,29,185,66,73,49,222,167,243,189,36,116,23,223,219,200,84,67,94,53,79,26,202,204,91,180,221,166,106,18,207,17,128,137,246,235,162,13,129,130,49,76,104,189,138,55,174,71,152,49,116,204,207,103,198,147,225,142,79,8,172,59,234,225,192,168,181,144,185,6,233,243,61,123,46,55,44,16,228,79,156,235,190,115,61,162,115,182,122,230,138,204,140,86,173,80,99,207,211,181,23,141,152,17,180,35,121,168,67,205,107,74,55,229,234,210,6,94,48,186,210,189,2,200,190,181,227,128,211,225,215,228,74,7,188,195,36,82,10,131,96,99,138,63,1,210,39,134,153,112,72,163,196,55,126,37,125,107,234,166,129,80,61,97,121,20,123,222,3,155,219,62,49,207,87,182,26,214,167,142,89,38,36,112,87,100,56,245,240,152,23,7,237,11,185,206,233,203,131,42,53,35,60,40,211,114,9,13,189,130,196,210,173,39,208,56,110,34,240,65,75,234,76,73,34,39,2,118,174,237,52,194,197,28,155,161,135,180,200,3,89,210,26,154,145,45,57,54,85,26,118,207,212,58,101,69,202,184,36,234,219,155,41,29,80,22,193,175,145,100,50,29,149,166,168,162,213,130,36,25,234,78,84,97,191,139,95,156,9,12,41,97,110,222,8,16,250,161,130,45,111,195,83,213,16,141,154,48,124,175,89,25,27,9,172,242,51,167,76,109,69,107,23,80,23,166,12,16,180,156,182,238,148,249,59,130,75,122,59,134,240,69,220,21,230,47,1,124,66,180,77,247,147,103,66,98,211,96,105,213,127,178,144,102,213,33,247,141,232,67,62,86,230,222,146,68,122,27,147,7,85,69,31,22,67,67,78,13,149,221,57,121,176,133,161,84,201,146,119,196,217,19,132,52,76,135,247,107,29,131,248,220,156,248,29,41,36,202,174,136,253,191,226,91,179,96,69,213,172,0,206,75,192,54,69,120,138,218,171,185,232,211,139,8,31,11,50,119,28,197,83,158,170,229,244,195,190,23,213,87,70,17,102,197,39,59,88,152,234,95,106,29,195,236,114,136,6,159,105,101,2,119,184,47,212,218,188,165,163,138,174,114,71,54,127,64,183,39,51,42,209,202,106,96,215,154,56,33,102,25,62,111,9,49,4,98,142,198,128,138,13,74,95,229,42,164,19,175,179,111,138,19,157,125,94,34,221,103,246,144,141,176,129,201,55,100,23,12,139,33,227,91,223,224,69,120,83,245,50,57,190,21,54,86,245,95,250,34,71,249,100,201,144,16,221,0,40,74,133,38,145,48,217,119,132,34,138,67,161,62,221,126,108,207,140,42,156,13,224,198,142,19,55,85,254,155,140,168,250,58,118,137,42,78,8,48,89,195,167,91,243,246,88,23,22,206,17,190,56,125,171,116,245,129,121,57,144,228,159,197,243,217,239,86,188,152,88,239,112,120,245,119,147,189,25,128,240,72,208,29,162,23,152,24,143,226,136,174,171,58,178,10,5,250,209,239,88,62,34,251,156,163,231,247,102,112,46,48,61,233,24,71,54,73,12,81,195,243,115,138,145,194,164,135,148,51,201,104,74,24,78,107,65,246,118,159,165,130,206,34,157,177,180,10,126,163,167,129,75,0,149,115,172,21,242,139,162,170,92,238,35,46,24,108,101,62,26,147,180,210,227,166,103,149,188,192,92,115,141,161,120,90,231,250,181,130,208,232,151,157,141,208,27,81,82,42,162,244,186,62,163,6,254,94,107,138,123,144,14,216,138,235,104,135,98,77,82,57,47,77,171,213,192,134,69,226,93,197,9,63,181,197,169,22,248,190,55,178,250,167,76,157,101,170,138,94,156,44,12,155,102,133,133,149,43,224,51,130,44,138,3,195,25,161,29,216,1,188,160,73,4,196,125,240,92,88,50,192,176,234,39,109,96,39,60,165,226,80,248,179,232,244,141,102,81,131,110,19,206,225,222,115,198,63,195,251,19,155,77,51,194,251,124,13,77,69,106,112,114,187,126,67,222,81,227,163,80,172,25,70,205,111,48,160,111,165,112,243,47,236,107,81,15,83,95,132,80,133,178,116,87,10,195,139,151,122,44,82,111,24,234,156,187,202,250,20,233,186,204,184,154,149,117,78,205,119,71,166,192,239,88,148,154,229,200,139,163,129,12,155,167,252,50,198,46,106,221,91,235,75,2,14,240,122,62,178,218,42,223,213,6,17,212,242,32,190,96,163,121,63,228,65,111,229,63,70,140,232,221,248,216,80,5,145,12,27,33,195,86,111,42,125,70,44,232,82,209,40,234,168,224,215,215,133,247,128,76,248,178,34,253,61,204,193,105,44,227,66,45,238,159,16,241,67,99,178,235,181,68,204,234,144,58,40,132,125,203,25,204,148,151,253,195,198,81,8,54,248,148,248,58,54,235,82,71,67,181,212,241,43,111,111,202,69,166,200,66,87,245,207,70,112,64,26,240,149,82,86,28,104,17,59,72,154,106,1,173,59,21,204,184,231,15,224,161,253,174,78,249,25,217,35,144,180,57,102,174,57,138,227,125,141,246,16,35,201,173,170,31,107,205,169,59,19,52,209,226,49,136,168,13,238,63,53,78,203,68,18,146,228,165,245,244,84,215,78,230,167,83,239,15,210,34,99,90,184,143,187,50,98,95,182,121,47,53,112,15,53,239,130,105,66,142,11,185,224,203,20,44,156,28,197,195,65,118,36,206,88,55,37,18,112,9,20,231,73,6,11,225,79,180,145,124,204,29,245,148,198,53,210,171,103,53,215,106,111,154,237,107,2,249,79,145,126,255,255,53,222,196,57,237,131,6,63,45,70,68,190,191,12,210,247,162,41,135,184,234,206,153,176,115,255,114,178,110,24,25,66,114,55,29,79,253,67,124,245,37,236,13,88,232,186,18,143,178,59,5,237,10,249,253,37,88,46,134,71,53,74,172,186,69,137,11,154,60,68,120,125,100,91,182,239,177,38,28,125,208,165,38,150,207,244,41,88,127,241,251,168,84,195,111,37,211,165,113,3,212,184,180,207,48,52,204,171,213,128,154,138,218,69,214,154,99,201,203,109,93,71,190,5,99,1,72,173,15,149,49,253,51,82,171,179,114,131,68,114,133,15,104,227,141,109,39,68,225,130,50,51,133,154,148,48,28,230,9,43,157,50,133,203,239,37,160,233,120,54,20,116,57,174,116,158,45,8,196,14,200,80,203,212,233,1,0,88,172,214,196,22,192,224,142,138,146,230,105,100,153,155,112,241,124,26,71,253,143,4,191,50,49,88,226,25,142,141,13,12,50,159,122,211,42,168,23,217,253,218,151,135,3,152,114,102,191,76,186,42,124,70,19,56,25,85,234,58,57,225,230,253,56,194,107,134,142,201,213,43,14,33,242,16,141,205,196,99,143,100,115,5,99,128,100,221,174,110,191,83,165,164,78,60,124,209,199,63,185,120,175,43,3,24,40,153,1,83,147,223,112,72,242,148,166,115,36,138,42,13,63,1,45,173,225,83,121,19,23,208,171,146,240,108,150,3,213,83,210,238,72,120,80,197,2,4,159,197,138,216,19,178,24,173,212,237,169,129,129,102,51,63,203,142,11,134,180,207,105,98,133,253,20,224,6,126,194,167,33,132,90,101,179,113,216,222,132,30,88,23,229,210,85,6,154,226,252,17,39,174,208,255,8,11,252,159,110,195,86,250,59,161,218,31,140,167,41,33,201,143,250,68,82,205,44,4,77,43,214,212,60,82,214,41,44,125,236,152,34,64,133,184,58,145,227,65,70,73,166,49,21,158,242,114,42,75,209,36,72,188,192,146,223,138,76,27,235,115,153,105,169,96,209,231,4,33,105,226,175,187,91,218,12,73,168,214,254,98,208,113,214,116,177,49,34,94,22,127,175,12,155,193,56,187,115,187,240,136,234,206,189,250,115,219,154,17,52,62,198,63,225,81,77,90,127,246,219,192,106,223,78,102,88,142,46,208,156,230,196,67,182,18,112,210,126,198,59,15,234,166,243,77,61,149,24,223,70,245,142,178,199,101,195,190,109,78,244,224,12,84,52,158,184,88,212,155,159,128,187,54,48,209,190,202,157,70,122,109,33,221,124,227,1,196,124,121,163,138,238,25,129,134,83,111,124,60,142,46,143,48,85,63,5,77,46,251,193,209,81,108,149,108,1,47,137,175,85,106,148,27,204,145,104,3,152,84,228,215,113,141,6,117,115,151,206,248,61,43,182,198,76,88,12,222,132,75,73,8,205,190,32,12,159,70,205,4,158,0,107,220,104,90,223,181,80,7,111,166,130,16,168,145,218,242,101,35,165,172,12,217,239,157,76,37,238,176,63,124,243,45,101,181,191,200,64,186,170,42,104,154,191,224,67,145,240,72,82,103,93,108,220,251,36,178,110,145,98,136,83,2,171,177,220,23,98,221,2,160,216,219,237,90,105,255,48,157,136,55,102,122,181,7,225,55,229,254,215,169,94,22,44,65,136,50,190,151,198,54,132,81,245,106,71,91,141,176,162,15,210,33,14,140,108,81,17,135,249,17,44,15,121,28,16,114,178,210,7,129,250,11,239,18,86,203,161,124,2,185,178,83,110,168,3,81,125,80,149,8,67,30,212,0,129,8,77,255,114,243,68,8,119,210,232,104,244,127,165,159,26,176,206,160,228,34,116,10,3,91,65,149,163,43,43,44,171,113,113,223,206,17,63,64,215,216,94,118,5,139,66,201,213,30,120,149,18,236,99,41,81,175,245,1,7,171,209,151,134,28,32,122,201,13,18,46,236,215,113,188,192,221,39,69,117,121,255,119,26,59,142,121,126,238,179,163,183,245,98,199,32,46,39,137,236,232,52,138,4,60,86,83,12,100,44,195,49,107,228,105,56,183,18,177,222,50,189,188,97,197,148,94,99,1,198,221,121,206,54,31,212,145,62,73,77,213,189,38,66,13,139,69,173,57,26,11,176,245,141,166,141,203,10,48,45,201,17,131,241,115,13,165,235,28,129,88,72,36,124,169,128,6,145,10,109,219,198,187,90,149,67,215,68,116,33,56,204,217,236,231,0,205,84,97,113,175,30,185,95,187,166,164,123,103,0,218,18,150,180,103,151,153,146,97,15,161,171,246,252,131,198,186,58,55,210,93,58,157,3,142,220,98,50,202,151,2,115,205,200,3,236,146,210,233,71,222,129,198,18,131,29,157,152,63,201,45,197,253,170,121,124,232,64,197,112,22,208,106,99,54,41,247,146,135,234,142,177,3,38,157,234,222,46,189,233,76,41,150,255,135,82,99,244,246,187,81,215,16,76,188,188,104,156,21,239,255,206,97,35,217,194,13,70,106,106,238,171,232,93,223,145,190,50,39,144,48,13,113,146,151,178,156,18,131,231,168,108,178,224,7,44,122,98,87,166,65,220,174,138,98,95,93,188,127,246,195,136,215,160,201,137,35,217,167,126,219,175,109,180,111,127,222,93,69,133,2,58,198,186,238,108,57,157,101,174,249,26,46,210,254,251,76,43,197,209,161,52,197,28,246,173,229,35,43,13,81,122,34,245,212,223,50,135,69,70,192,171,78,9,135,189,54,168,232,131,250,208,59,227,252,247,231,40,235,203,254,51,25,198,223,165,81,140,141,67,194,180,31,194,172,47,195,56,153,118,221,30,217,17,85,154,184,122,15,130,179,86,8,37,33,200,95,144,73,175,68,185,197,128,182,154,171,147,182,86,172,23,236,20,92,194,110,253,124,133,82,127,206,92,34,108,69,170,47,61,41,87,108,218,3,244,7,124,51,153,83,186,164,116,154,85,123,43,135,177,107,28,189,81,241,214,189,235,233,142,6,109,183,130,75,79,107,99,67,31,164,248,227,114,159,230,115,116,115,252,33,75,4,171,191,217,88,245,156,203,48,239,140,253,211,46,184,136,34,21,248,161,128,156,16,88,64,71,34,174,125,70,164,125,92,205,214,79,157,199,223,143,214,138,213,150,169,17,16,181,95,200,208,91,91,55,125,7,1,39,91,6,103,252,246,22,71,110,149,236,73,1,247,51,2,168,88,124,234,86,100,6,94,1,17,215,157,34,238,126,194,222,109,67,175,96,45,252,99,58,3,34,192,251,95,240,36,188,243,191,229,74,164,55,171,108,239,73,208,140,114,46,244,36,30,33,56,14,209,94,86,28,9,153,30,23,102,165,252,98,77,72,233,22,126,152,98,40,246,35,93,137,114,191,114,200,54,214,8,238,145,43,119,180,186,55,74,170,232,166,247,56,233,9,162,16,241,95,47,5,109,72,125,67,35,130,55,138,75,157,246,85,244,3,230,60,226,159,12,234,155,160,180,119,243,253,179,202,194,53,218,65,208,230,212,71,228,29,49,220,31,146,244,249,84,46,237,203,93,171,73,33,115,46,109,10,163,137,73,18,133,213,236,174,230,216,119,127,80,199,18,100,180,236,191,127,152,158,226,45,72,70,181,106,90,21,229,46,41,109,55,237,81,0,158,169,63,40,22,85,246,181,235,161,180,28,175,136,87,132,184,54,121,185,69,89,58,20,54,81,101,87,37,251,152,4,162,108,113,248,178,219,151,240,144,158,242,185,138,4,34,148,255,250,66,75,144,141,25,248,244,89,180,203,97,141,149,179,129,213,186,64,101,242,119,130,121,108,230,198,74,228,155,96,237,140,201,158,44,127,161,120,219,94,11,95,27,145,80,184,107,215,88,252,32,89,59,97,159,249,183,75,131,180,65,184,179,85,80,88,74,128,53,126,191,54,169,0,133,100,248,196,158,91,121,110,12,248,130,87,248,186,85,136,101,181,0,90,45,34,227,84,17,40,96,221,187,167,131,112,48,70,62,240,138,78,245,248,226,203,255,32,242,246,141,200,17,167,32,151,12,72,159,221,190,56,115,237,233,226,113,71,228,167,60,113,127,28,174,27,176,227,160,77,221,157,64,14,166,82,60,78,7,91,16,214,169,78,222,97,33,229,210,4,255,104,234,42,181,7,177,190,23,40,135,53,67,63,28,151,60,167,81,21,190,110,214,160,222,51,228,87,83,113,220,46,182,163,193,79,214,249,120,197,244,197,169,252,20,33,253,246,46,198,16,208,35,110,5,37,236,172,149,234,155,32,36,8,249,70,224,226,40,16,146,131,224,173,250,111,102,227,160,196,255,167,81,196,62,24,6,39,4,245,139,98,158,201,247,5,6,2,61,92,5,65,70,24,206,135,30,246,146,155,22,29,247,25,112,186,5,208,134,240,95,137,29,48,148,222,92,36,165,248,10,244,222,158,131,46,156,217,243,219,101,123,98,209,124,89,178,16,48,173,142,241,134,127,160,217,64,134,35,244,28,253,59,26,10,212,162,143,252,94,0,198,0,16,156,116,145,64,255,206,234,251,104,250,213,247,171,89,86,125,48,237,216,196,160,45,90,227,12,33,58,31,88,200,117,101,36,105,135,49,134,64,181,233,40,63,100,189,192,13,48,58,159,183,105,34,162,170,166,132,83,141,116,29,39,216,84,29,224,211,54,145,251,248,148,150,203,26,51,179,47,134,175,80,66,223,24,221,52,170,59,241,37,95,232,183,15,162,203,144,221,60,248,8,211,255,78,249,55,59,23,131,11,165,152,182,82,168,71,89,48,249,78,107,182,117,73,21,79,42,128,232,89,103,207,13,224,32,236,175,138,201,54,26,98,122,91,253,144,222,108,171,101,120,208,168,40,29,46,64,23,171,248,115,40,80,28,107,143,65,188,142,205,155,234,86,121,157,124,23,44,177,188,201,222,229,244,169,241,155,62,102,187,15,28,49,168,157,29,135,202,9,160,102,125,112,184,31,209,162,114,13,130,215,93,15,255,110,50,54,19,144,98,47,46,170,252,210,5,161,176,69,185,97,187,253,94,124,215,85,69,73,136,150,68,137,217,52,113,151,241,70,44,102,126,10,143,167,133,81,239,233,109,73,171,141,93,133,112,185,133,103,206,49,208,130,79,127,234,48,173,231,82,200,74,68,194,188,185,26,56,199,134,122,3,153,227,174,245,23,34,49,20,68,184,202,1,232,252,31,171,45,85,7,114,187,66,203,169,98,117,144,15,165,104,143,111,174,100,197,60,7,53,248,238,100,12,162,96,40,189,247,101,64,57,57,14,195,114,229,155,228,32,111,37,141,8,8,163,2,223,6,96,54,144,175,85,141,51,77,41,60,192,113,15,103,101,44,30,102,189,100,251,227,71,37,62,123,4,63,119,25,116,47,205,191,156,1,106,136,248,37,151,162,72,226,41,208,133,69,146,114,137,43,245,90,115,117,90,122,134,180,218,136,10,36,210,53,138,90,139,213,130,56,173,119,174,71,72,213,138,87,171,101,156,110,0,164,38,191,156,215,148,220,106,138,50,237,54,37,49,215,127,45,81,226,61,181,195,147,154,208,170,94,34,8,228,121,71,182,239,63,56,65,244,0,70,162,73,198,63,16,134,216,58,187,203,234,115,44,209,105,127,183,130,74,82,203,219,128,128,162,13,47,106,252,31,56,155,184,119,56,139,70,241,3,104,153,43,183,28,68,241,224,25,154,52,51,131,108,142,150,13,106,43,251,166,76,47,218,150,11,125,109,109,179,145,213,217,241,16,32,208,48,33,217,59,171,245,248,174,34,191,77,111,183,221,49,141,59,221,76,224,103,190,107,171,215,232,44,84,133,236,88,227,175,24,57,144,252,229,182,140,36,219,42,92,101,187,212,188,34,205,167,99,168,91,224,154,187,112,52,190,62,212,191,250,250,68,229,248,142,143,161,185,243,117,222,69,61,162,247,179,140,133,135,164,217,144,222,8,114,20,240,161,44,27,187,82,122,237,53,167,43,2,215,122,219,61,163,54,181,154,176,222,239,12,13,63,88,213,167,98,162,94,254,89,113,112,242,88,158,65,229,215,16,126,234,96,129,34,233,231,85,152,90,16,97,32,90,134,18,131,114,130,148,249,76,135,186,171,103,192,83,45,100,96,36,88,217,197,165,86,194,168,112,149,125,108,133,112,117,199,26,221,35,245,88,233,9,113,47,138,31,61,114,47,51,32,197,55,17,175,164,93,204,223,215,203,221,224,147,103,78,214,230,214,71,214,220,169,117,39,0,147,198,108,242,153,155,144,235,250,162,35,53,61,45,156,227,244,108,123,32,227,129,77,252,146,213,168,197,237,147,123,38,228,75,144,165,144,102,113,198,22,145,14,101,195,177,43,62,151,113,96,81,189,204,180,207,197,24,72,76,135,127,181,246,81,18,167,113,85,184,62,190,140,86,209,148,134,111,32,60,108,33,233,115,99,216,239,112,146,92,217,236,252,213,215,98,122,215,64,175,155,179,121,195,7,207,252,163,51,58,143,187,255,188,122,6,199,73,36,149,218,141,142,43,108,99,2,232,187,65,216,24,169,125,102,148,113,59,233,176,194,207,77,204,245,20,43,145,104,88,88,212,187,237,152,64,18,141,254,53,255,111,53,61,62,49,143,145,197,10,207,36,198,166,88,7,199,42,201,145,219,135,53,239,108,162,82,202,181,4,255,82,23,38,141,213,120,0,218,105,2,141,120,255,138,20,27,255,97,202,151,0,166,227,16,196,48,139,91,164,4,170,177,243,27,154,220,212,167,205,179,84,245,205,50,51,155,45,39,99,124,70,27,48,182,173,3,26,38,214,1,26,23,216,248,214,89,78,142,7,44,2,118,103,73,72,202,187,222,242,74,37,84,166,251,191,67,11,231,116,61,33,17,96,93,116,165,173,88,153,105,123,125,159,243,89,143,66,211,213,23,47,204,192,2,231,229,224,32,30,45,9,31,149,216,137,119,152,34,22,131,206,47,216,201,89,197,58,66,204,67,92,0,150,199,161,213,185,96,252,164,78,46,247,41,134,48,118,14,77,30,250,176,12,138,96,58,51,142,9,249,103,99,29,247,189,31,126,29,86,211,201,108,216,195,90,32,119,124,219,207,128,192,119,91,217,60,215,24,182,244,100,241,153,24,3,99,115,167,33,25,239,186,42,198,202,179,57,117,112,11,208,212,50,26,170,22,148,206,252,232,159,56,64,37,184,40,232,109,62,164,199,64,198,112,56,71,12,215,108,220,20,211,118,70,182,19,212,219,182,104,5,188,255,61,162,241,25,176,78,25,176,239,21,205,246,214,246,86,45,101,158,9,252,149,38,59,72,225,119,121,209,20,85,6,84,253,24,182,126,20,150,105,176,238,54,59,96,46,28,214,21,80,112,19,118,125,115,134,244,30,35,230,238,255,199,220,32,200,9,142,2,182,14,101,191,176,143,96,217,200,124,194,43,105,61,93,143,135,53,12,228,233,30,150,173,228,73,179,184,84,21,117,63,245,231,49,129,29,249,46,23,172,195,94,36,76,227,246,71,159,188,8,88,119,49,177,156,203,88,101,195,170,151,183,106,100,9,246,64,254,1,90,4,9,163,154,231,88,68,182,99,67,75,171,107,142,196,79,237,114,70,178,128,33,83,168,67,129,82,214,135,38,206,41,152,140,168,52,239,28,171,28,29,180,246,185,183,243,85,129,112,168,63,139,133,0,162,86,166,48,132,244,159,151,235,175,64,110,168,85,97,233,11,62,25,177,16,57,124,63,250,59,218,136,209,136,192,23,168,160,206,65,84,30,73,213,235,181,104,66,27,98,126,183,219,93,200,115,84,141,57,55,20,131,91,14,228,85,181,19,4,110,176,90,101,40,91,107,155,7,70,21,114,154,141,146,125,246,64,1,216,213,232,23,143,224,115,244,247,144,186,71,134,69,183,141,25,186,91,29,145,163,250,202,181,57,216,172,131,228,242,181,187,52,94,218,252,4,118,44,52,124,160,37,176,17,218,121,140,191,107,102,91,222,49,91,229,106,179,221,170,200,88,38,138,167,10,48,157,47,99,57,137,88,76,206,141,214,208,48,80,226,18,227,6,175,180,63,107,247,251,197,59,51,247,13,109,209,162,206,192,125,112,94,235,247,26,88,14,126,241,225,249,81,162,7,157,238,150,138,24,69,121,155,219,17,169,180,218,93,230,99,92,139,53,179,145,30,14,205,171,75,247,49,194,3,14,177,24,222,122,30,75,174,121,243,104,233,244,81,4,47,70,43,206,113,229,119,231,49,72,144,78,214,29,193,41,75,14,97,19,84,148,246,3,250,243,7,246,233,153,48,135,226,204,199,93,210,3,97,11,106,117,170,122,92,97,150,179,177,220,46,59,17,151,242,160,233,237,81,78,255,87,243,237,113,135,216,131,97,197,224,41,142,85,234,243,135,58,152,220,191,227,149,78,77,30,82,167,63,217,43,227,106,173,223,128,161,49,70,29,184,169,178,179,124,224,2,243,210,229,112,103,15,29,78,229,91,9,68,198,94,135,241,207,69,183,229,46,78,63,189,93,163,10,91,172,13,205,180,217,216,102,237,239,3,217,247,218,0,147,130,158,175,242,39,94,23,238,221,229,211,72,140,103,207,7,73,10,200,247,155,254,35,165,152,2,137,237,154,128,235,215,210,1,132,104,143,128,91,191,225,241,171,220,16,165,209,59,10,1,128,151,229,116,17,20,188,108,57,196,105,197,5,64,216,75,255,49,10,35,243,39,238,142,201,1,32,8,28,116,21,216,226,89,90,231,210,128,81,149,93,249,111,150,128,11,228,231,236,178,74,34,174,187,230,84,78,197,136,17,197,25,242,154,123,24,78,245,178,254,76,70,182,72,15,115,54,62,10,89,172,129,113,97,148,204,240,100,172,169,122,13,95,182,26,184,25,191,255,250,250,137,18,19,72,145,135,112,125,227,63,65,26,54,228,181,30,158,27,191,9,236,168,115,248,144,187,132,253,45,84,154,196,103,30,149,123,53,42,206,172,146,175,44,203,69,239,45,147,0,121,103,125,132,136,192,38,62,79,29,241,17,151,110,28,38,221,234,230,228,182,64,241,144,165,124,145,120,49,50,129,18,33,242,212,143,68,167,109,134,179,113,176,85,93,87,105,133,15,66,249,8,43,9,147,72,30,6,2,85,185,204,160,20,76,70,119,163,67,200,121,228,185,204,22,48,31,122,177,123,93,159,108,114,65,90,91,67,95,139,6,187,3,78,142,38,96,61,68,23,146,93,32,245,153,131,61,126,1,194,201,158,51,161,172,0,176,76,143,229,81,201,36,157,210,139,109,215,12,9,41,152,243,188,240,144,194,27,114,193,162,39,43,9,203,46,137,76,217,93,125,215,74,43,75,0,153,246,95,88,44,134,248,43,87,166,46,133,1,77,197,205,206,31,50,102,178,248,22,226,192,156,203,195,155,193,32,35,158,173,76,75,79,240,112,7,161,130,162,85,225,67,223,15,127,53,24,49,231,201,248,16,114,146,228,17,178,247,166,162,2,32,180,41,188,9,197,103,77,246,35,30,71,112,6,222,168,64,60,248,242,61,201,130,219,58,182,38,143,103,45,104,219,7,121,119,138,183,148,149,107,216,169,2,89,111,185,120,49,74,173,174,35,38,194,214,86,32,216,229,123,41,64,108,178,152,13,174,71,86,192,147,84,112,246,98,151,238,63,210,134,112,5,28,254,154,125,236,82,78,22,114,230,212,88,97,54,211,70,203,48,159,59,21,36,55,56,141,194,247,133,160,138,224,66,180,74,137,37,94,5,120,135,170,119,209,147,221,28,19,215,139,29,199,87,234,102,225,111,74,180,27,169,131,129,29,44,138,81,235,206,181,229,133,192,201,163,110,48,203,245,95,200,183,29,29,31,255,74,216,148,92,109,191,130,29,236,248,204,126,228,208,76,200,13,128,197,198,255,211,23,197,132,124,133,71,155,21,132,233,191,189,212,255,108,47,94,109,53,232,234,95,174,83,223,18,188,255,239,215,139,141,51,127,243,199,103,111,117,45,101,67,184,104,196,20,34,25,184,251,144,47,226,217,214,217,125,47,52,41,242,113,104,13,56,74,44,166,36,63,154,133,145,18,80,160,124,59,47,48,219,63,43,134,67,115,238,189,252,67,6,164,83,181,123,230,213,252,7,222,130,221,30,79,68,34,162,2,61,134,162,207,49,146,161,216,82,98,181,190,57,57,164,128,97,121,148,131,128,152,66,106,247,15,154,148,82,42,174,142,17,249,123,23,138,78,106,245,159,202,19,26,160,50,138,153,136,182,101,89,247,195,169,69,220,50,155,45,140,251,248,183,139,84,17,44,98,83,13,102,234,106,135,22,255,212,246,163,28,11,251,123,18,5,150,221,6,2,137,17,176,56,215,12,166,187,52,149,11,97,119,140,245,13,201,20,98,80,27,26,125,126,58,232,231,83,52,195,75,116,248,147,230,123,171,77,81,168,163,120,39,158,18,54,60,212,117,67,148,122,151,78,51,30,88,27,152,83,92,191,105,162,106,233,12,27,116,4,53,100,189,242,253,169,182,10,105,196,84,229,122,141,80,15,0,38,26,50,176,229,18,32,169,241,202,190,190,225,100,193,44,196,209,193,83,89,43,228,8,127,48,9,221,186,199,251,97,138,218,190,131,202,206,62,148,128,44,48,107,164,177,57,149,171,214,244,57,198,194,87,179,232,10,17,65,243,255,109,19,208,42,55,68,178,164,84,21,57,206,5,27,252,203,144,108,90,231,137,198,221,204,164,204,56,73,223,129,127,246,244,144,140,13,229,195,199,39,42,93,103,202,8,45,68,203,17,186,154,9,154,228,59,255,134,120,125,170,90,18,141,31,17,116,10,189,48,63,147,112,188,11,184,92,95,253,180,92,80,106,57,112,187,229,228,69,3,1,47,47,72,146,48,135,37,111,82,27,20,77,157,222,115,123,120,119,159,196,99,7,116,57,222,119,79,79,212,213,215,145,225,154,187,25,22,126,89,170,169,123,159,94,29,177,63,137,207,167,192,97,134,193,17,236,199,8,35,214,220,156,72,183,180,8,63,200,171,93,216,103,110,145,159,209,158,236,233,50,228,220,144,113,159,214,222,157,156,27,133,183,240,127,191,28,41,222,148,155,247,32,97,96,128,237,98,236,159,107,157,192,176,19,81,248,145,219,183,179,73,178,81,38,137,81,108,189,148,180,164,63,244,107,140,13,253,2,84,88,16,121,200,120,77,203,104,24,207,202,194,62,253,155,102,96,168,116,28,237,163,138,91,149,34,82,230,211,109,230,176,130,28,82,186,233,159,99,238,249,81,38,106,243,246,4,63,80,43,104,47,1,253,236,84,79,158,5,81,26,18,242,70,42,11,229,216,154,236,16,203,159,227,7,207,120,26,197,81,87,177,4,32,197,147,111,255,229,91,211,194,195,230,35,169,151,31,196,33,181,120,192,254,71,84,152,228,208,209,129,98,55,39,210,144,146,192,231,249,121,170,81,218,202,197,150,149,234,93,90,178,167,209,244,86,25,140,141,156,206,14,247,240,217,14,39,99,82,121,16,119,157,210,169,220,50,58,255,48,130,189,120,154,59,60,85,94,135,23,15,171,6,31,212,224,89,73,100,179,91,61,170,128,28,33,227,9,149,128,12,110,120,44,9,52,192,4,24,65,221,114,24,77,109,0,237,94,4,42,232,84,150,134,32,50,33,84,234,130,136,89,117,253,79,60,135,69,29,50,128,196,38,41,43,37,78,168,73,163,249,45,207,177,76,38,115,76,143,118,145,106,166,6,142,230,193,147,145,87,195,222,73,219,219,89,33,68,237,118,120,146,164,74,130,237,16,47,79,228,9,153,184,5,127,80,182,81,105,196,51,244,192,237,160,118,200,191,94,235,152,191,202,161,231,171,19,116,102,94,206,253,175,4,193,18,70,53,214,98,123,181,137,167,190,84,96,169,2,204,232,54,221,169,175,186,172,137,170,75,32,249,57,119,86,19,52,123,234,142,11,108,19,58,84,98,250,242,114,170,31,205,195,117,12,243,41,93,222,0,101,219,102,129,196,192,91,8,186,233,243,37,194,183,162,121,59,93,71,52,178,114,96,72,252,185,254,109,31,107,112,168,64,226,160,216,43,49,74,50,139,112,148,135,148,88,184,35,26,29,171,245,47,96,61,39,146,159,194,252,57,202,244,245,218,216,18,29,71,237,39,25,197,164,184,67,97,53,45,16,218,207,244,97,249,96,167,93,62,103,162,164,67,186,159,2,26,136,32,184,9,167,169,183,210,72,43,253,167,72,211,171,205,117,92,82,32,5,197,107,8,68,106,237,8,142,148,101,227,90,210,67,13,252,233,3,242,79,95,172,175,195,246,251,254,247,71,7,224,252,37,255,4,158,178,131,23,77,77,22,178,114,155,151,162,207,53,98,63,132,143,232,73,194,185,91,243,57,47,83,36,154,42,31,150,56,15,33,40,14,111,70,137,225,158,138,108,119,114,255,48,176,231,182,51,219,163,86,122,80,104,197,169,107,181,97,55,228,63,47,73,106,27,23,65,207,177,34,218,221,147,192,237,165,74,89,152,255,181,169,250,226,99,10,232,6,181,45,3,222,174,26,248,155,12,199,237,65,205,85,22,125,164,146,124,17,73,140,71,36,57,173,173,157,157,161,35,164,157,190,71,67,29,142,133,206,231,64,185,95,111,65,166,220,233,245,73,242,25,16,29,223,124,142,199,177,13,24,198,245,218,190,115,38,32,45,236,12,96,101,63,17,230,151,217,117,234,153,112,111,91,162,196,247,185,166,60,2,8,145,56,160,48,175,226,250,67,51,132,106,42,213,138,119,167,9,240,25,8,56,22,165,218,9,62,218,121,29,43,177,130,210,166,150,15,220,225,225,152,34,255,104,115,223,108,131,55,250,255,49,92,130,20,179,218,73,38,116,122,102,17,118,237,183,109,65,232,122,235,4,68,3,245,160,150,224,73,183,115,6,100,124,166,210,201,82,249,142,15,23,20,60,118,137,170,181,229,205,108,201,240,169,87,195,99,76,138,15,228,158,47,216,146,8,248,175,110,207,39,94,180,173,250,47,24,2,201,150,241,233,238,16,120,75,140,84,49,212,106,98,213,162,86,181,76,170,35,124,116,48,164,197,74,131,117,229,28,19,139,154,0,123,202,110,178,10,79,113,166,22,172,117,191,54,48,27,183,59,223,105,57,148,54,241,188,72,118,58,255,33,235,238,206,33,254,197,162,45,154,226,221,57,145,225,19,36,11,164,245,79,188,132,50,190,248,255,75,183,214,242,69,109,232,147,130,166,70,86,58,124,161,96,88,92,166,32,184,117,117,232,148,14,163,81,163,242,0,239,41,82,240,105,189,74,68,200,164,195,85,62,74,56,226,196,41,2,105,154,95,205,207,232,106,98,226,99,112,210,188,162,203,188,28,65,78,18,252,134,93,120,74,188,64,154,12,133,146,228,14,25,9,13,157,22,83,145,169,201,189,221,137,49,232,138,179,182,165,146,2,109,172,21,172,40,157,230,199,70,170,17,231,133,250,192,45,75,214,33,111,3,120,209,54,12,206,159,226,150,136,96,94,25,66,56,178,106,7,73,214,104,156,236,28,249,93,15,229,9,0,132,16,69,155,125,179,207,94,14,13,244,207,241,54,32,52,63,98,162,154,191,75,209,229,33,193,255,57,31,229,86,153,43,207,166,165,245,54,40,212,29,222,70,136,130,40,74,185,218,104,130,108,129,245,188,86,215,76,131,33,190,168,234,99,175,11,251,216,73,187,108,44,255,201,238,119,247,44,86,81,235,45,3,57,216,75,34,73,180,36,35,240,164,214,36,117,135,41,119,211,38,76,81,196,8,21,97,136,235,119,71,123,36,176,199,227,228,108,128,149,137,5,164,77,148,159,81,47,176,108,234,54,46,235,56,167,178,84,254,105,129,190,49,65,57,236,213,149,152,10,85,206,195,221,92,221,54,74,114,134,198,83,208,132,62,75,99,76,23,147,221,170,238,47,2,231,238,159,31,157,21,230,120,116,37,205,171,183,193,105,172,143,117,1,93,76,23,54,218,89,41,8,34,70,14,172,247,13,165,93,149,104,106,13,209,88,202,31,127,1,56,213,196,57,128,219,160,128,36,102,11,50,241,144,120,109,249,181,6,101,158,193,159,198,121,72,53,117,201,226,238,36,19,89,190,170,97,242,166,133,255,187,116,117,149,110,240,34,46,115,10,173,23,253,193,26,88,218,204,250,37,212,109,250,201,191,194,118,95,136,247,161,207,241,204,135,2,78,149,74,112,131,147,47,174,61,6,17,165,170,245,205,230,27,4,219,42,253,132,224,5,105,216,149,164,189,139,111,218,70,124,62,36,131,167,58,160,166,166,15,182,6,55,43,51,18,46,56,174,90,10,0,14,29,74,85,33,208,147,69,176,90,198,106,36,37,30,25,35,124,178,130,4,84,25,198,20,229,53,83,27,191,7,155,221,115,87,5,220,83,80,84,102,251,48,221,102,199,149,98,72,199,4,97,43,61,78,97,140,141,115,8,36,76,209,170,73,151,35,27,50,135,70,240,173,0,121,54,23,163,78,109,212,129,93,171,216,134,28,83,113,141,233,192,101,187,144,201,55,84,241,226,162,50,111,152,243,114,9,111,93,4,89,234,55,65,28,241,78,143,188,189,252,70,80,238,69,204,212,181,122,171,109,189,186,144,136,240,116,95,234,155,53,70,170,203,113,36,46,45,134,195,163,140,104,104,25,181,136,167,116,55,237,25,77,120,91,44,239,159,52,190,41,227,220,175,171,101,213,127,105,222,163,58,68,40,210,118,247,1,76,42,20,189,248,76,43,113,25,81,37,26,154,234,25,226,251,39,69,143,3,138,235,220,47,9,31,25,63,195,193,72,173,92,80,43,152,143,80,74,126,49,33,238,113,228,171,168,241,82,49,174,116,73,94,130,72,230,253,161,187,183,237,195,41,153,143,130,252,152,169,147,185,106,2,207,13,134,90,175,141,157,242,255,161,154,42,107,178,145,195,16,211,119,181,175,211,84,142,39,77,187,239,159,12,177,186,243,150,95,140,58,167,52,103,146,158,98,247,173,141,219,214,180,87,55,184,155,216,203,67,81,243,45,171,219,220,110,144,106,5,138,225,212,232,110,202,220,68,84,250,115,120,118,200,167,154,108,73,90,190,72,34,47,249,229,114,4,80,142,144,22,68,254,128,128,196,171,194,100,131,176,168,30,203,107,42,65,59,156,176,21,156,53,86,125,203,58,216,87,127,233,238,153,162,195,175,35,133,212,69,25,61,96,246,99,19,132,120,219,58,140,93,223,248,9,43,246,147,166,10,33,40,237,26,6,87,228,81,182,159,34,234,48,74,27,30,186,36,136,63,92,110,3,131,130,27,239,155,0,156,219,146,232,148,189,133,204,227,35,102,6,13,242,251,69,127,251,171,127,248,242,116,126,174,84,115,6,193,135,29,128,225,230,162,23,222,79,106,4,26,156,61,251,88,57,81,76,237,7,19,107,37,95,147,230,99,193,76,98,87,252,124,217,105,200,201,204,245,189,226,154,95,54,19,34,64,85,66,163,243,6,203,46,201,0,174,183,154,181,226,46,152,199,255,75,54,243,29,83,133,231,240,6,21,38,68,184,253,109,54,23,224,31,102,11,112,103,43,17,38,125,238,71,104,161,159,219,136,215,196,141,170,10,56,156,93,207,152,188,114,22,157,0,165,25,138,205,58,248,67,193,58,28,147,32,38,229,221,175,114,14,42,161,2,223,231,204,164,6,92,49,52,64,37,164,223,252,197,118,55,243,108,10,158,239,219,175,244,102,22,194,134,212,9,249,244,43,86,97,41,53,9,224,110,61,250,140,202,187,95,171,204,21,221,58,141,24,176,120,96,194,232,84,28,125,246,218,142,73,131,254,249,22,179,71,110,208,97,247,139,162,171,64,251,79,190,180,190,186,29,110,165,88,119,225,30,58,64,49,68,45,83,93,122,136,199,146,158,106,5,211,222,64,64,160,74,72,185,138,112,186,135,133,95,31,236,77,86,54,59,235,32,245,245,133,152,27,233,115,154,253,233,222,36,218,216,218,211,137,127,103,199,95,165,151,234,33,228,72,167,103,13,43,119,38,71,23,218,227,177,230,222,214,149,81,102,246,94,251,84,233,90,116,77,26,118,194,122,55,75,208,137,52,159,238,73,8,33,157,218,178,213,108,45,131,207,210,31,144,133,204,239,144,183,230,251,195,57,195,154,39,61,36,39,117,126,121,69,224,198,15,198,98,59,82,181,202,28,149,49,219,53,48,163,19,164,57,251,219,61,159,235,12,121,100,151,160,191,93,194,90,22,119,28,191,219,210,170,234,145,2,111,53,86,140,171,46,232,231,111,18,43,83,2,142,131,38,36,99,174,3,26,169,105,31,214,250,212,191,8,1,141,69,73,158,180,248,93,117,146,242,10,188,63,7,61,149,69,118,161,141,117,25,193,18,187,220,194,82,13,30,5,225,194,158,252,56,159,129,5,240,0,213,85,67,54,209,242,151,41,141,172,187,12,215,255,6,5,126,185,11,225,35,202,5,182,98,154,26,217,237,193,140,136,38,71,118,166,44,17,223,179,101,97,16,153,33,21,204,15,219,189,120,219,24,117,23,4,153,22,143,40,174,238,185,27,159,69,251,1,227,108,218,69,111,198,184,236,14,216,136,208,115,154,211,47,149,116,98,114,40,90,83,116,92,109,38,134,140,104,157,197,116,57,122,111,5,224,4,175,201,244,62,210,203,188,216,230,131,214,184,164,54,48,242,179,251,201,77,16,77,13,77,23,34,66,146,24,12,187,238,151,92,139,64,114,217,125,244,175,10,155,138,118,58,245,52,121,17,241,62,231,105,214,169,120,184,4,155,16,20,12,215,206,40,237,161,186,68,63,141,166,178,6,127,126,151,70,195,245,163,96,91,23,138,173,211,99,103,164,14,51,246,20,75,76,135,150,74,215,220,71,15,76,77,215,250,38,227,176,76,17,15,179,232,18,19,165,54,194,146,187,110,158,216,55,66,145,232,119,152,61,63,121,155,194,202,244,22,81,66,36,140,38,108,209,21,139,25,159,255,185,60,117,9,245,95,46,99,220,27,61,151,235,253,38,161,64,188,88,189,117,249,42,176,56,54,107,62,80,240,135,153,86,180,137,121,111,177,208,196,3,194,236,106,173,82,40,195,1,146,180,204,141,11,192,120,252,52,4,116,199,14,254,104,216,4,219,7,221,233,33,47,34,247,94,0,104,240,54,18,128,85,240,255,179,195,197,161,240,178,242,197,103,68,166,60,95,131,245,148,198,163,124,209,39,120,42,206,15,106,91,118,113,89,19,66,66,241,200,64,65,37,82,169,139,136,203,234,192,172,175,27,160,244,10,91,4,183,109,177,183,93,233,92,26,227,67,87,232,184,97,234,202,240,80,213,42,133,15,68,206,0,206,110,170,227,223,113,90,208,60,11,93,245,151,50,51,86,152,199,229,35,248,13,119,64,238,165,152,108,70,48,149,157,110,249,189,25,187,246,251,124,64,0,176,165,128,174,39,200,94,100,193,34,233,19,192,83,39,177,228,74,234,195,128,251,203,238,192,16,66,200,223,179,30,106,195,189,26,217,157,142,161,132,38,20,179,217,79,34,97,189,231,106,19,144,223,172,39,206,91,192,115,254,111,141,170,103,121,61,72,101,60,110,173,73,193,25,89,206,122,137,151,213,60,169,7,42,226,224,249,190,43,17,190,187,240,163,77,26,192,162,70,170,154,216,20,183,212,229,81,56,157,247,123,219,168,91,21,53,107,174,135,98,32,176,146,78,98,190,30,232,190,171,107,188,254,223,5,25,58,134,150,36,28,218,134,107,40,253,245,199,11,1,191,26,173,238,5,142,204,170,161,157,127,172,254,27,185,235,87,15,3,74,170,36,195,132,163,3,126,33,178,173,141,106,23,111,96,111,124,164,68,230,2,210,18,190,148,45,70,148,194,38,160,67,130,166,172,81,5,91,142,239,190,58,3,102,81,212,68,68,73,134,6,117,116,100,47,57,100,207,232,224,125,32,30,193,162,117,36,57,8,27,203,56,199,110,251,56,35,162,240,157,224,0,42,206,199,201,33,95,5,127,132,29,178,152,101,166,1,242,99,155,248,47,71,180,75,84,99,65,91,32,31,136,206,52,48,74,184,208,83,85,179,51,105,125,87,66,145,207,127,71,239,255,157,126,120,139,232,35,64,70,128,118,191,41,217,7,185,86,117,216,187,163,194,206,174,218,56,214,58,160,248,111,154,70,17,108,212,91,199,245,32,108,125,43,198,192,38,68,101,100,147,129,87,52,240,50,91,92,218,108,127,101,155,228,123,77,147,41,86,207,159,139,140,93,22,169,163,63,89,236,154,98,131,93,39,55,237,122,107,6,174,184,202,126,27,199,141,16,52,167,250,44,52,64,134,244,66,235,39,127,190,88,127,61,105,107,157,35,59,146,10,14,155,241,227,170,104,180,47,95,20,235,236,196,100,29,66,255,252,236,249,128,214,5,234,40,241,34,234,45,47,166,217,121,36,243,35,251,23,126,3,133,136,164,113,22,69,236,180,239,139,48,255,146,161,48,135,129,150,245,193,181,210,85,120,4,249,147,174,66,17,136,154,208,148,214,82,198,29,171,4,223,212,84,104,93,95,153,151,59,52,212,150,113,85,179,189,60,151,118,28,93,220,49,114,124,228,164,99,165,40,1,5,200,121,138,132,77,15,5,21,162,216,252,37,141,224,202,125,209,225,242,62,177,195,93,254,238,77,226,148,168,119,167,195,151,180,25,60,215,48,166,94,44,45,114,159,78,24,155,132,119,38,31,231,227,51,37,35,33,239,40,171,12,250,68,190,248,231,228,59,213,61,15,65,53,179,92,176,23,172,176,32,72,135,37,241,24,107,242,184,186,57,99,239,241,14,0,114,211,202,79,176,88,52,130,56,18,75,55,22,208,79,100,1,57,105,53,174,100,13,234,232,158,118,211,9,144,128,160,76,177,166,10,90,95,110,144,254,243,190,208,135,184,198,226,200,27,9,38,241,0,208,210,237,180,2,22,149,157,19,155,249,21,3,55,195,149,105,206,24,110,148,19,249,58,78,186,176,25,100,216,4,198,194,104,71,150,103,193,54,223,28,146,80,51,157,194,14,178,180,189,161,192,44,225,168,111,47,225,151,43,100,26,191,125,146,222,221,199,216,186,126,173,89,90,229,77,60,34,228,75,219,182,85,232,170,22,24,130,197,101,20,253,116,141,176,241,34,223,208,190,53,49,201,93,144,151,241,108,236,120,86,232,128,234,238,83,111,80,172,96,67,34,128,6,29,10,136,122,7,204,83,50,186,1,23,79,169,21,92,114,15,132,236,51,188,123,139,240,236,199,67,208,132,52,13,194,187,174,29,120,140,151,198,252,88,147,102,219,35,162,73,126,98,77,213,8,169,217,193,210,100,239,19,153,49,43,252,194,75,228,65,143,184,39,77,42,202,171,40,113,137,164,157,33,120,131,63,197,218,5,250,238,192,175,128,92,206,161,173,254,238,133,100,158,136,16,101,127,238,52,208,92,82,3,217,66,93,246,228,193,254,74,72,78,122,33,105,54,8,66,93,246,194,222,27,194,33,125,31,125,186,243,13,92,218,44,36,132,226,180,89,124,205,104,135,159,122,252,15,162,223,62,10,250,171,0,131,127,85,178,231,79,207,40,253,46,196,118,242,128,72,35,191,117,82,21,59,50,253,123,77,220,143,104,20,203,224,176,13,252,32,28,67,43,91,75,244,94,186,135,19,180,199,223,127,142,98,37,239,28,103,87,65,235,18,238,103,120,238,30,86,59,98,172,2,220,161,99,43,3,209,122,161,55,146,255,1,36,249,99,184,3,3,168,72,232,46,73,223,106,79,159,210,38,156,147,51,126,50,165,108,52,49,96,42,238,80,99,70,146,206,224,54,97,97,16,213,14,248,251,126,49,66,87,134,179,227,232,143,91,185,125,0,158,183,5,242,48,7,152,160,171,198,163,34,181,199,170,68,125,93,97,109,136,230,150,33,113,56,104,7,226,175,49,100,51,84,213,22,135,7,237,200,148,72,116,142,163,153,122,86,4,164,15,210,118,24,67,210,223,220,137,144,48,144,180,185,234,2,241,154,213,43,109,156,143,172,26,128,135,231,119,24,217,131,61,148,77,141,150,92,115,120,2,154,217,75,86,241,208,171,108,103,82,89,209,129,238,172,132,255,207,27,146,164,74,184,68,92,141,13,124,214,138,185,244,149,236,189,182,103,67,87,10,32,216,220,143,80,210,206,245,104,149,139,20,55,5,113,172,207,125,29,89,249,19,112,108,14,88,182,201,165,18,10,245,121,6,178,148,34,12,59,196,61,173,239,178,241,33,155,25,242,134,32,227,233,188,135,113,163,52,64,251,178,224,118,246,79,167,5,63,212,177,112,180,80,242,169,49,210,21,134,141,17,157,190,91,64,227,91,38,133,159,225,105,247,226,195,200,172,31,220,215,170,68,107,20,234,183,178,143,56,158,107,86,223,172,215,193,84,10,65,89,99,158,61,203,224,96,108,213,54,164,149,13,125,118,120,95,189,114,57,41,211,241,237,209,190,6,62,79,184,242,245,149,195,91,85,198,131,178,227,71,202,112,154,51,82,29,130,223,121,113,6,199,251,129,30,201,68,187,181,197,35,52,79,104,12,235,40,127,72,62,197,101,25,50,235,135,22,61,18,204,9,17,58,139,193,112,118,161,34,157,65,113,190,135,176,140,117,20,216,176,111,50,116,217,162,214,180,80,45,31,21,53,93,2,228,123,100,207,17,230,207,97,240,183,85,31,41,46,45,3,43,72,155,187,165,203,128,67,28,120,236,54,20,65,238,109,110,179,222,136,198,17,77,149,130,251,103,177,204,150,184,189,37,5,55,241,217,14,130,255,116,126,175,235,144,116,140,66,14,51,205,67,99,220,51,208,79,206,154,127,22,85,71,77,215,145,255,44,243,64,209,227,67,73,110,151,218,87,197,55,237,118,245,39,169,244,170,245,203,108,245,142,50,189,176,80,21,202,93,146,1,53,148,177,158,56,213,31,235,149,163,76,7,160,96,185,175,209,247,27,135,158,217,147,16,10,240,197,137,20,206,239,82,56,27,22,220,198,2,89,79,127,31,142,1,6,55,182,200,142,137,107,201,174,111,181,210,207,62,30,104,243,208,79,121,233,86,23,51,192,246,38,237,63,185,68,166,75,123,229,116,251,234,207,59,122,231,68,113,211,62,70,25,143,151,209,232,208,160,147,131,216,54,242,90,239,63,40,144,174,63,16,36,202,26,114,183,89,217,89,136,230,91,48,252,125,202,164,150,89,145,56,123,247,12,54,155,187,186,61,40,196,208,28,136,119,101,36,210,226,52,175,235,200,109,39,72,109,208,243,138,191,212,112,241,255,140,84,135,41,149,18,74,71,117,169,225,47,36,251,47,104,143,61,234,88,50,148,255,119,218,157,33,205,193,198,233,229,11,62,162,92,119,220,137,255,123,184,226,35,157,8,174,39,63,216,248,137,225,131,8,2,82,204,80,214,39,91,209,189,161,6,81,144,36,198,76,197,109,194,10,4,72,54,53,184,115,91,225,10,11,168,200,46,218,124,246,135,15,89,53,166,8,241,71,83,123,154,209,50,174,37,55,123,83,140,20,54,44,56,182,163,26,6,6,190,38,53,147,232,222,149,68,107,255,157,252,151,137,92,252,145,148,33,103,9,72,231,13,116,195,38,2,23,236,159,143,19,6,218,213,124,179,244,182,30,110,173,19,168,90,131,57,252,205,106,250,34,115,21,156,227,2,178,233,51,164,166,165,72,112,14,41,93,38,111,111,37,191,106,207,33,185,185,90,72,233,134,236,98,171,160,112,169,40,190,94,93,171,234,98,137,93,127,65,248,80,186,131,116,191,197,63,31,50,255,195,58,34,142,54,220,246,198,63,55,183,44,126,0,217,209,232,158,8,7,110,86,107,240,61,28,52,138,97,149,20,247,180,192,143,33,83,155,177,22,187,216,48,139,83,169,139,99,123,154,74,125,236,38,59,46,27,30,157,211,15,232,203,47,94,136,56,194,51,139,205,174,21,161,217,7,160,227,59,236,156,91,143,154,27,42,117,22,168,18,246,201,35,37,107,157,58,5,158,76,100,112,62,84,117,50,22,6,96,111,120,207,116,151,161,13,67,239,116,206,98,64,136,103,8,201,197,9,81,239,18,226,93,190,46,81,229,232,167,200,193,215,90,182,212,93,78,67,26,105,97,197,49,164,150,52,143,248,121,13,95,217,227,206,14,80,200,179,171,10,146,200,142,90,137,125,253,146,71,131,33,45,48,69,241,119,153,254,188,241,25,222,97,30,63,46,136,159,57,134,89,0,129,234,189,184,64,200,208,245,48,167,116,134,99,230,3,164,217,19,159,106,99,97,202,22,164,70,66,13,97,32,58,239,114,37,9,60,59,67,157,37,172,251,50,177,13,116,63,7,119,74,90,248,108,175,187,95,134,112,101,157,132,160,143,70,245,232,144,69,184,106,150,9,184,122,224,32,162,162,167,166,203,10,237,99,78,75,217,159,250,237,184,75,97,163,68,55,215,93,14,236,225,12,141,49,8,40,126,117,77,135,80,77,205,97,75,21,26,145,221,123,172,2,182,77,86,93,204,86,114,144,92,13,141,25,97,222,15,100,182,160,159,142,35,220,49,107,187,208,137,105,153,135,0,174,222,172,239,170,133,207,178,208,164,230,211,2,139,92,32,192,133,89,232,32,239,245,110,166,136,37,21,196,131,79,242,98,209,25,180,252,102,119,100,85,102,115,189,106,122,226,157,178,221,143,154,92,187,57,68,241,18,33,225,250,134,114,116,72,134,250,27,40,97,219,30,86,74,184,102,193,26,66,181,24,165,153,255,190,75,185,18,121,114,85,220,59,224,145,174,176,36,67,144,74,196,161,88,9,48,79,220,4,67,25,232,105,176,32,242,28,201,66,116,178,36,164,218,208,31,240,68,239,166,138,242,198,226,27,136,232,255,174,210,152,60,200,61,15,238,2,218,231,198,130,236,180,235,65,221,66,82,162,92,235,251,20,38,65,92,156,106,85,0,144,25,182,28,226,88,153,34,253,19,27,116,90,101,248,35,202,216,184,19,35,2,94,8,209,254,66,212,135,68,219,185,32,107,225,25,227,136,211,138,181,174,112,128,190,66,165,251,135,185,108,40,159,222,177,26,58,26,148,218,89,13,15,27,236,24,118,78,33,185,174,168,219,230,119,230,179,169,161,57,118,97,227,203,9,125,55,136,197,112,94,138,136,230,112,204,245,136,116,59,13,75,68,121,43,122,9,22,252,149,172,182,118,113,61,53,171,44,42,118,178,166,69,222,44,157,34,128,126,179,24,154,159,106,149,17,227,58,143,176,241,222,56,42,62,181,26,208,33,24,30,33,112,83,127,84,65,41,251,206,115,178,2,222,106,153,209,238,98,208,200,210,177,133,86,65,23,104,110,177,161,96,79,57,142,162,15,207,173,153,56,254,250,73,76,74,43,36,200,57,145,60,95,227,21,147,221,41,171,192,107,234,251,74,126,3,247,128,122,243,153,128,202,238,189,17,198,179,70,97,245,190,200,231,176,186,98,217,254,45,230,228,185,78,204,155,64,247,183,255,152,161,26,12,21,183,209,199,194,177,1,221,95,77,76,253,203,104,7,192,167,209,180,50,138,227,189,182,231,239,238,168,59,221,119,154,107,247,102,200,51,40,120,192,133,47,249,238,189,123,233,117,188,210,82,68,72,178,111,103,77,144,205,181,97,1,172,166,152,242,0,187,181,174,188,39,82,5,75,21,213,113,66,102,62,173,169,132,21,120,138,226,211,39,44,143,160,126,74,108,191,13,117,58,148,234,239,194,161,161,156,231,240,170,77,120,106,63,168,175,231,243,60,192,181,236,20,52,239,78,141,78,130,59,219,80,208,24,37,165,109,209,49,251,9,62,80,50,249,181,232,42,228,47,166,191,144,176,206,148,242,148,153,182,121,24,128,65,137,42,161,119,66,94,240,11,55,102,122,7,205,142,144,144,180,47,60,218,192,149,85,15,213,83,8,79,215,104,8,209,172,222,200,242,28,255,51,185,167,33,226,26,65,147,100,114,222,54,27,170,212,207,83,56,170,37,126,121,14,18,40,231,4,14,164,248,6,110,118,48,51,83,228,76,3,131,87,77,86,163,48,72,194,109,53,105,118,111,198,140,133,34,20,119,56,35,236,7,170,176,164,95,86,183,232,105,108,7,25,169,127,50,26,86,83,94,101,58,219,72,205,46,231,78,158,94,221,190,147,92,96,224,0,30,65,191,21,237,118,106,224,247,161,116,33,41,10,92,81,248,232,191,41,72,116,171,89,110,208,62,230,196,11,67,172,81,188,8,212,62,255,199,22,201,68,20,120,21,90,72,70,211,251,61,232,5,238,147,16,91,225,65,103,178,238,63,246,157,100,192,170,206,249,101,28,25,120,125,225,94,105,146,218,75,10,178,103,244,73,77,174,18,113,205,198,233,5,88,129,66,64,72,137,118,81,217,130,206,156,174,224,223,115,249,164,10,160,47,237,255,135,146,236,13,99,71,63,62,20,134,132,135,155,27,21,239,159,60,195,224,248,123,205,45,147,225,233,72,95,151,236,249,144,43,148,51,197,175,100,140,185,170,200,234,37,87,113,85,41,197,41,164,33,181,64,228,58,125,41,220,43,111,47,37,139,69,75,126,166,210,12,7,175,6,63,122,236,237,156,149,142,254,174,11,37,215,82,200,54,62,74,43,2,249,172,218,115,203,91,14,165,110,103,178,200,5,226,141,45,42,68,130,198,173,253,230,217,122,113,39,163,182,160,231,100,179,40,207,8,27,212,22,174,85,58,27,55,118,83,118,244,201,68,167,205,50,31,36,17,250,228,187,200,203,159,109,44,83,197,240,214,82,128,207,62,237,127,108,238,226,36,190,44,152,27,248,90,79,254,43,191,182,206,138,179,239,133,27,56,192,25,166,40,83,172,241,62,178,172,53,58,205,73,6,139,66,50,24,22,193,232,205,173,161,67,139,236,13,114,239,156,46,253,12,218,238,6,255,169,98,117,8,215,156,102,178,212,208,18,175,147,108,96,73,71,115,87,75,254,77,61,212,49,252,42,72,23,95,49,206,208,189,203,240,139,4,56,101,109,139,204,117,23,213,104,47,1,254,115,179,25,96,58,221,157,53,112,19,110,172,118,168,11,21,171,109,123,100,79,124,202,172,155,236,144,86,224,44,183,119,167,51,180,139,191,76,201,173,212,215,120,148,255,149,110,69,229,152,112,197,133,178,122,15,23,55,103,67,13,152,239,59,168,53,175,130,232,143,236,0,96,95,206,91,141,167,127,199,149,82,51,222,51,43,148,225,183,56,32,68,76,97,35,154,233,207,47,2,29,114,143,36,159,81,168,169,22,163,74,208,233,149,204,129,138,138,13,48,180,42,41,155,141,156,228,19,71,135,137,63,119,146,67,61,236,133,52,209,164,39,67,110,28,5,36,100,159,52,79,220,118,89,126,230,63,180,117,243,165,179,147,209,255,162,97,177,43,45,86,56,48,223,195,122,39,130,118,8,183,36,55,42,221,83,72,74,95,130,91,23,121,226,221,206,241,204,44,105,177,188,105,190,84,106,225,244,183,44,76,188,169,150,98,155,208,244,161,94,75,232,173,64,126,153,184,124,75,229,87,31,209,154,93,125,64,53,167,155,250,167,122,169,184,231,14,34,61,208,47,179,182,194,37,87,240,10,125,2,26,125,232,189,207,199,3,153,204,157,148,33,93,160,134,67,238,203,126,198,203,210,112,25,199,23,136,192,135,207,227,224,213,125,17,93,230,177,178,164,152,162,80,107,50,52,221,42,20,128,143,202,168,22,91,223,159,118,214,249,29,184,124,24,124,1,183,54,43,61,91,155,116,241,94,157,187,60,100,244,97,97,177,9,57,90,72,245,38,31,86,172,41,102,15,35,39,4,233,141,9,165,41,137,229,44,122,16,181,99,178,84,124,207,34,140,41,145,250,172,186,100,100,156,162,5,126,187,160,57,183,240,17,46,181,44,120,144,141,151,142,129,195,192,11,203,241,78,134,142,214,106,198,94,141,84,62,51,127,110,9,65,150,68,221,157,131,236,130,114,10,128,197,13,157,252,8,165,223,138,108,179,156,231,156,82,132,196,202,13,64,69,92,110,180,238,15,125,240,30,231,134,56,66,31,193,191,100,72,106,233,11,113,8,121,238,178,117,107,157,215,58,43,212,236,53,215,214,1,16,192,173,175,231,62,113,26,94,248,47,30,36,232,160,227,75,161,127,33,5,192,210,69,155,249,190,217,224,42,17,77,54,231,20,45,5,116,154,154,80,74,148,126,85,137,13,59,123,226,167,20,148,24,19,123,17,78,46,126,232,255,147,20,83,85,103,16,86,141,246,211,162,58,245,162,77,31,51,40,174,164,117,38,201,18,8,240,124,226,180,213,190,92,223,249,184,227,8,168,86,142,19,66,247,142,54,135,218,13,197,216,225,152,61,155,156,171,88,150,158,129,132,144,138,13,21,166,17,156,62,40,147,131,134,66,228,77,177,184,53,207,92,208,3,16,2,45,215,154,73,196,92,47,104,0,94,23,103,132,206,81,105,63,84,231,7,205,95,148,128,250,142,158,42,49,223,26,22,72,27,211,39,245,201,245,4,127,48,221,21,121,201,223,108,209,6,93,31,85,112,207,74,123,201,78,249,139,38,60,134,47,225,21,74,31,177,146,41,144,16,100,28,219,207,21,104,154,200,135,169,238,147,227,243,217,211,187,109,182,74,223,148,201,132,46,26,159,121,196,145,148,161,153,126,127,103,44,44,215,135,248,8,157,23,184,220,82,173,81,229,136,173,243,230,69,68,158,137,156,73,166,209,116,155,166,231,141,186,187,84,175,227,63,227,13,18,245,222,185,2,9,97,179,58,174,246,67,94,255,153,44,100,138,172,19,5,67,221,82,20,224,61,104,222,44,53,106,82,147,130,225,31,218,140,64,109,45,5,216,165,119,100,159,228,18,213,150,192,59,85,135,249,36,228,230,57,28,67,206,105,230,148,212,28,106,92,97,2,31,152,107,208,11,10,205,238,102,126,66,83,190,233,77,232,77,96,85,249,251,119,192,179,5,0,198,67,127,22,157,78,146,64,204,6,39,200,12,229,227,234,242,193,195,141,125,107,248,143,210,251,18,220,67,240,110,48,114,110,15,160,241,14,133,152,132,225,44,134,92,88,11,167,164,225,12,234,164,92,9,175,74,190,164,193,157,232,4,137,216,80,165,124,20,254,221,2,198,63,217,156,135,119,4,178,58,153,215,139,67,52,172,206,47,40,75,33,86,67,63,41,10,20,37,237,37,156,4,13,25,23,201,228,9,237,67,16,22,116,17,184,162,203,188,227,13,110,65,231,79,200,61,118,207,68,161,90,71,47,113,31,224,165,90,23,21,239,63,80,176,54,103,99,60,125,72,207,90,110,231,121,225,205,35,28,16,137,252,136,94,179,14,97,157,227,66,82,219,137,26,78,157,181,147,28,161,251,43,196,201,53,245,149,152,194,86,91,70,203,91,114,199,241,212,180,125,44,131,135,116,26,132,69,27,84,222,132,88,96,163,119,62,129,249,230,33,147,28,124,23,172,231,132,144,182,235,125,193,70,233,206,77,27,210,203,223,213,95,105,230,117,205,214,164,126,23,240,10,34,237,211,43,162,138,230,118,192,86,247,125,167,215,62,26,113,209,175,19,231,246,167,150,22,44,69,31,236,205,198,210,214,123,93,60,9,175,131,96,145,71,92,190,209,201,225,103,43,204,242,98,253,129,95,56,223,107,29,87,165,180,44,49,28,37,42,83,215,122,91,126,77,38,243,71,213,191,223,14,76,247,97,110,190,120,147,167,234,237,10,98,148,45,218,3,23,117,15,148,142,173,118,236,90,31,27,85,54,188,202,253,43,102,109,130,17,8,239,241,89,212,14,29,172,179,90,8,104,5,203,117,188,43,184,167,54,8,100,136,17,55,201,102,193,221,245,173,86,65,162,176,40,92,214,101,18,82,59,131,63,156,187,219,65,190,115,172,242,52,181,80,109,165,136,98,148,149,152,234,86,143,132,100,239,159,119,163,250,30,130,119,190,45,58,208,104,161,144,10,202,200,31,177,215,242,236,78,3,151,34,8,16,172,231,112,71,159,168,32,208,230,50,84,234,214,40,92,65,60,148,117,76,216,111,91,121,177,66,86,123,55,54,126,46,118,241,103,105,245,89,242,0,0,166,87,7,145,164,227,90,30,10,4,88,64,114,70,127,14,161,218,198,16,35,230,115,54,65,108,190,175,186,252,79,33,24,82,118,130,249,181,253,61,28,154,77,227,209,111,63,61,68,223,162,41,90,176,37,114,169,199,77,160,219,199,22,79,240,212,158,243,217,226,74,158,215,193,166,204,82,135,0,106,12,155,150,113,241,197,33,205,6,16,19,118,164,194,115,243,112,162,251,134,203,122,124,61,242,68,140,200,131,168,172,123,48,70,132,227,199,3,196,130,48,55,231,64,216,195,86,36,160,233,137,145,108,224,93,218,61,107,191,138,171,13,215,212,65,223,117,85,120,109,207,141,12,23,221,175,68,130,129,185,138,67,225,85,127,85,215,75,146,79,69,133,10,129,210,51,71,147,116,11,104,76,194,87,78,137,12,108,185,53,10,210,35,135,33,203,224,96,175,47,98,138,83,60,163,16,100,51,21,186,245,7,153,128,164,73,27,189,195,13,61,255,96,12,174,169,37,39,235,177,224,137,71,128,240,63,137,238,255,68,185,212,135,190,156,240,184,158,113,210,241,119,224,63,177,236,63,172,135,117,74,27,187,227,253,246,222,134,197,251,197,243,107,188,160,85,252,111,4,141,195,243,91,73,226,144,131,109,136,10,172,209,186,95,172,96,107,43,22,44,176,226,122,100,50,28,65,163,62,235,88,16,254,97,48,250,64,155,101,21,83,64,255,189,98,142,60,20,184,3,54,87,20,50,178,254,138,105,53,169,141,5,88,57,244,207,138,191,208,185,54,87,134,70,182,197,77,248,201,118,133,148,231,106,241,215,91,61,184,61,250,9,140,91,66,203,141,93,171,166,65,183,29,234,196,85,230,194,177,148,240,126,71,14,92,212,2,120,179,141,11,42,166,15,45,196,187,30,249,247,104,244,5,25,126,208,252,253,157,224,36,138,145,222,221,213,15,204,112,217,50,193,215,194,2,248,214,48,43,229,7,204,79,218,223,82,137,114,228,41,220,68,157,35,245,242,213,255,141,189,192,243,63,72,119,222,107,252,230,192,211,47,186,209,144,213,221,185,22,152,208,54,130,76,100,242,54,210,211,40,29,189,40,7,183,252,209,130,240,76,107,14,110,35,151,57,0,187,180,78,210,153,198,18,212,33,205,72,211,89,150,175,136,7,138,13,18,93,226,93,52,171,126,188,165,113,29,15,231,234,11,67,54,164,115,158,58,48,20,202,65,198,247,224,202,190,45,10,153,146,148,150,218,67,157,27,190,197,15,182,135,56,130,43,203,209,174,134,100,81,179,58,182,229,1,155,224,135,148,214,99,38,92,212,220,49,17,170,248,161,123,88,92,5,119,19,210,149,12,254,121,21,140,38,10,247,25,4,22,186,68,1,211,221,109,182,103,137,4,242,129,66,67,138,61,50,131,83,208,81,53,132,36,86,63,33,62,142,250,210,195,68,246,210,84,77,150,182,48,140,129,1,24,195,122,107,160,22,129,227,250,27,102,21,127,52,229,47,19,58,21,47,132,85,233,11,183,119,3,54,223,94,30,168,153,3,202,62,170,29,46,235,105,186,122,192,71,128,73,149,47,98,46,122,34,64,101,76,177,160,154,47,174,96,118,108,73,203,121,15,19,101,72,99,177,70,118,219,124,182,128,41,154,76,22,204,166,120,224,174,35,27,29,63,8,248,217,183,247,192,11,141,178,28,4,184,73,111,64,221,65,220,21,145,34,163,79,94,28,225,40,146,182,182,2,244,18,250,136,64,65,3,121,52,149,19,150,105,221,244,244,247,77,249,155,100,216,128,178,170,122,153,140,221,2,88,211,227,255,108,191,91,6,185,100,148,31,75,245,179,229,46,107,30,214,20,93,198,142,86,108,83,131,235,38,107,38,203,229,248,160,22,216,41,215,22,55,59,211,156,38,76,79,202,176,49,88,161,162,206,46,81,83,200,99,138,117,40,110,2,84,142,165,212,63,185,183,35,165,96,218,110,177,40,36,21,19,181,76,171,145,175,144,249,115,42,97,99,152,49,128,122,54,8,136,236,196,46,137,181,211,218,83,112,177,64,193,136,89,220,176,221,204,172,174,154,77,96,166,191,132,59,141,90,169,6,46,45,84,193,160,209,49,6,199,255,3,129,73,146,92,31,226,30,164,12,7,148,241,217,3,113,226,199,81,146,95,141,45,176,205,253,233,128,78,74,123,244,138,154,234,99,11,241,18,251,174,123,196,122,254,82,210,2,90,216,87,97,38,253,160,197,255,134,152,168,162,17,72,133,41,122,235,85,154,133,172,162,240,103,107,149,216,192,182,55,27,163,94,52,129,61,154,61,11,135,223,222,154,217,53,135,124,181,120,2,41,107,239,28,32,232,45,27,51,86,176,14,7,40,249,170,100,67,101,131,23,151,200,74,151,82,184,146,40,7,64,240,146,253,80,218,150,108,16,186,224,225,98,8,166,177,252,0,35,95,107,137,80,130,116,129,161,149,37,52,149,240,167,11,50,129,134,80,126,16,233,201,206,97,186,68,205,245,254,241,139,20,5,89,162,39,98,188,107,186,119,233,101,250,245,150,241,120,191,39,29,12,121,31,198,242,252,230,85,160,112,172,171,128,29,103,65,246,39,126,74,92,140,142,56,181,82,101,195,59,71,4,8,9,42,98,180,136,41,26,56,252,4,230,102,239,251,161,183,106,22,54,238,250,59,61,243,9,189,77,195,254,119,234,124,186,211,5,26,88,176,159,87,101,242,100,179,102,218,39,85,82,118,109,146,144,225,73,28,78,77,189,135,29,192,12,95,153,113,248,50,171,113,241,189,121,194,155,247,109,70,124,72,61,27,79,56,185,218,51,155,130,98,183,1,100,60,85,55,160,158,110,41,58,63,216,176,49,228,195,87,118,254,105,223,41,138,84,41,78,214,111,49,206,175,91,190,57,25,68,120,22,127,85,81,202,226,197,123,156,169,249,12,182,148,31,115,211,146,41,208,248,249,197,188,103,47,138,8,117,43,130,28,28,102,44,149,38,221,176,211,11,76,148,186,176,252,87,62,69,3,88,80,123,168,196,245,128,224,186,224,99,220,46,237,181,88,159,161,175,204,237,160,154,13,131,12,99,88,171,231,111,242,238,194,193,15,3,254,152,148,114,131,215,216,106,245,73,197,176,147,149,25,185,200,252,52,225,236,86,240,34,22,76,102,243,132,148,11,204,125,58,185,37,184,188,4,169,89,249,104,232,254,3,96,102,68,177,242,8,251,188,177,100,48,1,248,177,185,181,108,161,130,117,35,229,28,94,131,105,31,242,158,200,167,63,124,21,55,142,139,10,202,5,82,209,8,37,48,22,47,237,174,182,254,11,32,46,255,142,78,113,207,192,187,172,174,16,156,90,26,138,142,57,129,2,59,148,175,197,194,242,205,81,57,214,199,206,60,204,225,254,113,28,148,222,242,209,101,104,98,108,237,223,49,114,212,129,78,146,78,208,40,162,230,188,127,198,195,47,15,146,82,173,159,186,217,133,148,237,194,5,33,102,245,90,65,8,165,35,12,231,205,62,97,232,36,7,127,30,119,233,149,99,221,178,173,102,226,168,250,196,60,181,5,125,126,243,158,64,110,37,30,195,162,229,136,241,198,229,105,88,85,49,14,96,84,216,55,253,53,92,172,24,38,54,35,37,50,118,149,84,244,199,203,56,87,218,44,100,7,25,135,147,55,101,115,200,99,37,8,239,72,221,30,76,8,86,146,55,44,91,241,31,111,230,90,185,168,144,245,50,43,46,238,33,229,223,34,244,14,118,219,103,141,110,249,21,49,255,202,251,214,126,66,144,34,95,94,195,240,131,109,100,123,73,158,69,82,217,206,59,169,190,31,185,211,83,88,73,74,185,229,228,147,57,21,198,39,234,143,84,167,170,144,247,206,56,43,55,104,193,157,220,89,125,173,151,17,4,10,18,124,244,41,133,194,59,11,202,98,174,212,26,19,95,71,26,82,242,133,85,125,4,131,36,108,37,250,255,99,63,15,53,173,129,255,175,83,105,132,142,35,4,243,133,67,237,220,88,25,169,219,83,229,33,83,46,251,0,111,226,87,41,226,98,245,208,93,251,94,207,210,41,146,56,119,137,32,0,61,212,6,161,219,144,112,202,88,124,132,83,197,240,185,196,152,34,202,136,59,198,165,5,136,11,246,158,60,3,176,105,203,207,70,162,187,45,160,39,60,82,115,113,239,37,166,188,235,215,222,227,65,73,188,70,178,98,215,247,7,12,10,4,216,139,202,178,125,231,103,79,61,127,58,10,202,75,42,107,139,214,172,4,14,3,23,73,247,52,158,78,61,218,235,79,191,182,70,127,157,34,208,242,177,248,153,110,42,50,168,186,212,159,202,174,245,161,60,197,47,221,200,111,195,231,35,136,145,196,62,119,52,247,41,50,41,64,94,231,136,149,213,174,127,157,61,143,47,166,152,59,245,186,16,70,32,201,49,239,157,90,225,122,138,88,158,93,59,121,246,69,151,25,182,189,199,100,74,131,123,99,103,185,138,240,169,255,83,8,240,13,159,156,5,223,181,247,243,244,179,90,207,159,36,69,34,174,29,39,12,198,108,220,130,2,10,203,188,206,67,116,209,27,67,170,198,93,113,250,14,198,254,196,37,146,198,0,245,162,19,196,105,30,136,94,211,48,61,213,53,160,236,102,140,240,236,1,246,124,73,73,184,88,243,157,125,154,77,39,104,111,1,205,78,22,233,44,37,253,92,198,51,8,211,150,43,192,106,122,208,21,123,140,14,148,222,144,217,194,15,242,120,80,45,66,71,74,147,132,37,185,45,165,41,76,166,143,130,134,3,4,15,104,214,102,179,162,238,195,200,235,20,223,172,249,110,37,43,216,136,128,232,235,48,215,2,250,173,82,109,146,30,125,217,231,73,206,65,2,40,45,35,163,248,230,102,19,67,102,0,76,64,7,130,23,167,105,28,152,26,73,234,15,36,35,231,146,205,50,217,164,199,154,192,15,19,80,26,30,181,14,197,12,131,88,61,140,86,85,233,182,210,78,143,77,63,177,30,176,10,224,14,137,130,162,84,191,108,227,75,85,115,237,159,119,222,168,131,18,13,22,92,110,176,134,71,180,31,116,154,111,4,116,74,59,2,191,75,114,181,184,238,106,236,202,251,63,247,48,35,155,172,61,122,174,26,38,3,176,42,15,71,195,153,55,66,191,33,169,177,220,36,95,177,66,86,173,31,180,219,166,178,139,120,139,67,88,25,238,233,169,169,111,163,217,54,29,44,34,138,236,199,35,50,82,214,30,125,91,25,222,65,137,125,96,232,78,167,209,68,71,70,1,22,163,34,202,200,71,113,235,157,41,14,32,110,171,235,197,174,10,51,158,251,44,98,199,201,196,168,50,201,99,205,245,153,75,169,17,143,154,52,222,138,28,173,86,92,134,115,136,220,131,85,171,122,218,117,190,117,143,79,26,121,10,50,45,80,241,33,4,253,140,1,159,201,105,123,35,133,81,59,236,16,238,109,215,10,124,211,64,112,180,147,203,106,142,69,97,205,162,177,217,151,174,189,239,69,50,30,166,238,219,120,79,225,197,121,127,91,215,89,102,17,39,158,213,94,164,254,49,125,216,191,222,90,38,224,214,242,60,2,38,241,139,218,34,185,186,30,206,33,43,38,242,81,191,12,1,200,96,167,125,197,194,127,129,244,184,30,74,74,196,174,229,224,226,124,52,137,122,146,108,187,169,127,72,111,131,243,79,149,236,134,103,137,212,161,44,61,183,188,103,150,96,95,88,187,167,31,213,185,63,128,70,10,58,47,69,155,112,231,242,129,19,78,116,74,152,85,44,128,199,241,148,56,48,27,194,180,191,35,170,227,179,166,110,172,88,208,185,53,153,120,109,155,216,205,172,159,59,191,94,49,209,213,90,125,246,132,153,163,89,50,28,91,141,185,11,4,229,210,18,79,36,117,191,90,231,97,92,89,193,98,201,7,9,252,3,100,157,87,134,164,29,218,54,7,117,232,97,226,74,185,43,135,78,199,151,206,137,157,244,201,49,137,164,23,115,134,121,92,128,224,192,100,154,252,124,146,17,129,44,130,237,65,159,194,35,88,56,132,29,163,200,91,112,118,35,100,76,112,87,180,233,171,69,124,62,161,232,54,66,129,248,193,47,232,197,143,236,112,36,132,61,97,179,231,60,124,4,220,161,114,16,84,196,143,200,58,98,2,255,8,3,222,42,146,204,234,68,199,78,202,173,32,215,30,242,64,32,250,49,111,31,174,191,209,40,51,55,101,12,137,212,116,140,72,132,52,104,204,245,218,122,29,236,175,188,112,137,112,129,225,22,84,118,55,75,104,13,207,51,243,102,148,120,49,86,192,53,173,30,143,161,0,187,160,141,185,32,104,37,221,242,44,29,27,162,135,12,4,205,239,98,8,217,237,81,207,29,240,169,209,6,80,56,120,99,193,90,244,235,14,45,162,130,224,62,152,96,147,9,238,188,49,82,151,207,8,240,126,39,228,192,121,199,227,52,238,238,69,130,134,174,90,34,126,176,133,63,234,79,219,126,186,224,106,183,242,244,90,180,161,17,110,155,66,109,222,205,83,121,103,49,85,234,220,198,98,67,0,50,194,21,182,193,118,19,220,4,173,96,221,203,40,186,232,98,162,37,12,169,225,26,229,12,71,121,194,162,100,159,139,30,0,151,86,14,131,219,129,154,212,170,79,126,26,171,90,92,239,0,106,79,97,213,183,128,12,238,216,30,67,114,73,64,191,22,179,225,12,252,220,234,87,55,51,145,66,34,63,168,252,148,87,47,176,54,228,85,152,226,61,198,41,76,94,182,131,134,142,127,97,14,232,78,147,107,91,23,55,184,220,0,132,128,230,214,41,253,146,45,59,69,244,78,228,127,47,234,235,212,197,152,203,251,16,167,93,153,46,245,207,238,82,246,96,131,4,123,250,67,9,15,63,198,214,205,18,51,223,238,190,104,69,185,188,1,61,168,132,22,21,224,86,237,119,49,15,228,241,216,161,180,19,252,22,109,144,133,49,21,97,145,73,250,32,160,0,103,179,235,69,26,206,44,140,184,97,110,167,21,84,228,112,18,154,24,41,60,232,190,168,43,72,248,82,221,13,138,79,89,140,122,61,117,232,17,75,243,217,88,218,235,50,96,182,174,230,168,249,99,90,3,240,143,171,128,49,247,62,32,242,216,73,239,88,172,30,77,172,78,40,138,46,152,178,103,92,139,57,224,167,208,14,63,245,78,69,235,225,103,133,134,96,22,32,104,77,117,153,192,206,38,183,221,117,253,207,240,211,16,89,105,251,119,74,144,222,156,150,154,58,135,38,58,165,24,125,4,181,205,243,117,226,156,243,80,70,66,176,146,37,197,55,215,99,87,148,92,191,170,198,29,60,48,57,132,232,226,100,191,28,143,184,235,205,69,47,243,18,71,89,96,148,5,68,98,120,4,46,222,166,248,156,123,31,13,147,244,29,153,133,248,130,207,112,2,139,131,49,115,58,120,121,244,170,19,97,201,192,75,161,137,127,83,157,78,253,58,222,224,220,83,182,11,236,101,153,140,34,113,36,254,143,112,151,78,23,46,155,32,170,178,239,64,77,243,128,127,240,27,82,213,68,205,87,27,42,124,75,156,9,234,4,161,210,181,7,140,130,78,31,105,100,208,169,223,62,105,229,132,50,56,128,226,5,184,254,213,116,54,2,93,233,67,132,34,39,179,133,27,209,227,163,127,21,38,10,175,140,28,114,70,190,173,123,166,31,176,23,83,27,2,64,147,250,217,95,1,100,211,238,42,151,65,188,182,234,61,134,64,31,245,14,173,167,214,244,223,242,182,230,208,180,241,228,142,135,251,1,188,189,100,175,18,181,117,35,14,102,136,20,208,168,235,41,228,102,112,204,114,197,137,63,144,1,174,122,8,52,194,119,247,169,229,16,103,124,105,126,128,30,165,102,132,107,24,55,253,220,212,101,202,129,150,144,2,88,195,9,152,160,243,97,168,80,228,18,168,79,186,193,151,206,197,164,32,6,58,126,128,178,154,122,20,188,81,123,96,6,46,214,149,107,24,177,129,255,208,247,29,66,228,212,126,81,168,1,76,131,174,108,141,122,248,24,107,113,170,68,235,117,129,83,56,163,148,130,79,104,185,22,138,198,242,77,180,102,47,117,225,233,90,16,225,8,163,241,112,173,15,227,176,197,136,139,114,202,96,151,63,60,96,154,107,17,147,224,206,248,93,53,106,235,229,60,87,165,173,67,60,192,40,25,38,154,183,128,195,41,187,21,254,166,61,76,158,20,29,63,194,131,191,180,111,32,193,245,193,122,94,224,84,142,94,172,150,192,219,151,49,107,61,164,252,204,72,119,227,21,253,120,84,60,176,113,224,172,24,196,92,64,19,6,114,3,127,121,48,40,3,60,52,74,110,225,56,14,140,23,179,58,129,206,230,166,25,190,123,31,5,201,50,253,204,94,174,116,91,166,97,216,90,145,201,152,88,164,18,19,17,202,204,251,146,159,61,233,43,209,63,240,241,168,94,78,86,211,0,62,97,12,204,199,62,218,65,64,9,170,91,210,0,191,56,249,81,51,140,84,246,229,192,59,27,87,104,195,108,174,216,168,188,98,234,57,57,162,193,13,190,155,45,124,40,58,32,99,14,179,68,39,112,92,159,159,36,201,2,226,129,171,120,102,185,148,114,152,162,196,181,56,69,182,37,197,98,228,38,41,142,10,57,84,197,160,183,210,236,9,42,214,224,63,62,31,118,26,251,177,236,185,210,104,244,19,251,195,113,141,34,50,255,204,42,56,117,66,203,139,249,119,14,28,203,175,32,42,245,180,104,11,154,25,127,248,60,200,28,180,91,39,244,161,108,240,140,189,72,32,119,76,235,30,100,46,74,250,110,234,232,192,243,51,124,39,251,186,123,64,23,149,105,161,56,180,49,163,245,34,42,187,145,64,13,82,135,95,186,146,44,214,135,104,194,94,110,93,178,242,130,21,226,63,156,184,127,204,241,167,193,180,9,237,106,90,105,165,19,198,246,140,189,35,66,77,27,170,145,237,170,99,161,189,234,238,51,219,82,212,214,32,43,128,193,45,163,2,216,44,192,84,104,92,99,93,116,94,163,255,90,174,176,184,147,127,46,68,22,63,23,62,151,173,125,237,52,101,54,144,205,184,145,103,197,86,53,11,127,158,118,175,217,13,86,251,47,11,230,181,185,174,212,134,254,17,229,174,154,246,87,107,230,55,252,104,84,104,251,201,66,110,183,24,71,54,10,178,175,12,182,18,163,73,203,244,85,216,175,129,81,60,17,112,71,155,136,34,122,134,137,245,172,152,64,127,55,97,0,148,116,138,88,45,172,16,250,169,10,55,168,155,249,246,117,74,112,183,220,144,84,127,245,255,79,75,162,219,9,150,235,53,199,122,194,58,198,192,83,66,183,114,7,36,198,143,179,218,40,178,248,218,185,108,140,103,50,91,31,235,191,230,109,62,140,189,224,31,241,31,255,48,167,106,18,242,164,95,24,208,232,159,107,188,95,66,187,61,92,245,43,201,191,135,1,41,19,255,103,156,115,9,219,112,48,74,62,113,152,120,196,200,133,105,206,67,75,26,102,159,159,237,244,74,119,46,70,217,24,102,5,82,212,11,224,67,44,241,148,125,122,140,30,141,56,185,122,202,228,228,152,203,143,221,92,116,168,69,113,89,106,187,215,201,255,151,132,143,105,97,52,138,102,179,146,194,72,5,11,142,16,31,119,218,54,11,45,117,143,78,191,169,116,115,101,231,67,196,81,203,175,126,36,74,3,153,52,15,176,118,87,2,10,235,166,166,25,217,24,97,56,174,121,208,62,83,81,159,25,1,81,67,213,89,71,34,140,83,221,7,159,118,96,172,176,235,249,185,28,97,166,17,64,245,165,23,63,251,128,105,12,76,148,92,91,188,236,238,25,184,58,203,60,22,171,192,183,224,144,158,173,39,61,188,92,76,155,181,102,5,187,207,150,94,58,3,250,36,236,210,151,254,24,164,165,111,28,108,229,47,22,146,124,12,137,148,24,184,174,127,13,247,114,83,177,100,178,209,116,247,77,184,99,249,116,52,90,208,48,242,239,23,251,172,248,54,133,62,24,240,90,110,209,64,19,65,231,127,36,40,74,61,89,232,108,40,133,183,241,255,164,20,180,249,37,233,11,144,123,198,10,134,56,30,115,232,181,188,113,167,11,26,133,132,207,13,144,114,236,85,141,70,151,42,10,176,211,160,243,33,210,57,247,197,33,32,215,207,152,153,82,222,95,87,217,232,251,9,157,52,92,92,186,221,244,36,132,244,171,126,222,212,178,213,118,239,52,68,215,228,157,37,229,77,151,40,95,205,177,209,250,59,223,193,65,135,147,161,220,60,30,20,221,12,251,251,237,115,218,76,211,222,227,113,244,133,150,144,25,141,230,202,17,219,118,142,8,254,249,111,8,74,66,92,214,206,5,252,176,47,65,208,174,127,25,182,208,254,125,215,136,104,95,122,148,47,160,24,171,217,115,108,36,46,111,121,54,209,200,78,201,242,47,82,146,153,116,84,30,151,175,199,2,189,89,106,30,113,219,11,101,233,191,165,1,168,238,15,156,187,76,114,205,125,10,232,251,59,152,234,16,241,125,111,195,40,170,83,198,62,219,137,128,20,195,25,33,235,77,95,39,151,116,175,239,44,250,171,84,173,154,211,23,212,157,160,162,208,164,16,244,147,14,14,17,6,104,150,53,108,250,78,227,27,137,22,252,98,238,175,243,37,70,13,183,79,164,152,113,101,78,244,30,197,103,210,103,214,38,156,171,0,17,21,28,178,30,168,20,31,200,208,51,52,113,15,151,103,235,237,40,10,81,34,216,193,173,182,231,138,223,70,74,110,140,135,128,67,193,157,182,109,142,223,157,163,206,148,192,228,100,183,148,130,219,246,217,18,184,83,27,227,178,40,188,85,136,45,33,244,69,87,159,128,40,97,108,157,0,46,148,60,23,222,235,38,205,188,53,18,244,187,182,168,183,237,144,27,24,195,130,65,220,216,15,20,137,249,27,41,218,232,246,197,92,106,119,80,113,188,192,30,233,34,219,39,146,187,114,27,18,165,104,236,249,38,44,105,166,205,230,49,128,243,36,251,113,40,38,25,215,224,120,27,235,159,12,92,34,87,109,158,74,60,6,136,178,187,38,91,137,86,88,121,201,214,195,151,83,64,228,135,143,158,147,97,176,188,111,251,247,113,197,192,23,113,9,177,188,15,65,193,111,153,189,107,45,251,63,75,15,75,144,12,21,147,41,0,174,131,76,50,32,230,156,172,12,21,217,99,174,122,176,90,142,255,218,205,218,102,252,254,211,225,2,68,190,66,50,226,64,173,14,103,174,112,42,47,226,144,59,125,110,69,123,255,9,156,24,136,238,168,115,76,198,25,170,142,181,178,27,82,125,25,38,98,50,248,232,139,82,51,79,162,74,26,73,204,26,40,13,40,2,73,96,105,177,92,99,35,99,110,56,185,105,177,205,31,100,153,114,150,60,150,252,43,129,210,116,71,159,252,129,54,152,242,65,180,226,15,50,224,127,124,175,143,91,38,46,62,8,22,59,186,178,38,77,246,103,48,216,212,109,56,156,174,127,24,51,123,161,249,178,142,219,27,68,158,78,254,94,242,73,34,240,204,200,93,216,7,25,228,165,205,3,19,2,181,77,104,175,11,217,230,194,135,111,69,253,161,56,50,214,192,155,137,146,17,189,167,202,57,121,74,241,142,45,201,161,154,57,125,92,44,130,241,88,74,115,124,14,144,36,13,187,40,11,139,4,59,158,157,206,13,92,151,135,1,219,94,61,152,173,99,202,240,172,225,103,253,248,69,184,171,34,33,169,218,245,125,15,58,199,178,40,202,80,134,75,170,110,92,65,6,58,200,15,51,116,102,229,188,24,164,185,80,221,62,235,227,1,238,159,158,44,47,211,248,136,211,153,57,241,104,231,90,19,39,187,253,118,187,69,91,208,213,90,157,249,110,157,246,186,4,46,212,11,235,27,55,22,236,16,139,224,123,76,76,174,18,156,21,2,25,59,83,147,157,186,202,18,243,139,77,192,205,43,11,67,231,130,169,53,171,6,241,244,138,2,96,125,93,209,194,120,187,162,104,129,237,118,242,149,94,212,207,222,141,202,202,204,103,231,34,132,92,157,95,239,176,202,195,185,87,154,63,219,10,215,8,146,73,190,222,17,110,27,90,35,66,27,93,191,17,12,120,158,138,224,58,68,152,169,243,48,157,252,163,132,148,157,222,184,145,161,202,141,123,93,61,82,14,213,82,53,66,165,100,215,10,77,207,216,139,35,208,176,63,63,80,219,7,147,222,36,12,252,16,92,225,56,96,70,218,129,99,205,25,99,208,253,109,43,104,153,0,224,39,192,163,67,138,85,157,8,128,148,197,89,194,87,99,206,81,141,47,214,217,156,211,187,184,220,33,32,20,31,143,48,136,147,54,141,147,129,53,91,215,115,208,74,187,36,225,92,30,238,23,79,195,80,124,161,28,40,129,212,156,128,13,94,16,64,122,47,166,181,116,236,218,16,106,162,20,12,250,106,59,75,168,173,41,229,75,239,230,135,79,240,61,106,144,243,222,80,207,8,155,238,226,204,246,25,2,83,116,227,42,121,189,61,88,237,200,221,66,111,84,209,44,204,5,74,21,249,236,194,187,52,103,164,109,114,191,27,0,240,99,60,253,103,92,69,90,87,109,109,138,61,171,55,129,98,152,62,65,82,93,47,130,95,171,12,145,48,243,4,220,47,118,144,188,144,153,224,242,141,144,94,218,128,144,77,106,98,182,215,118,91,73,238,22,122,110,3,109,89,91,34,0,57,72,86,228,158,153,209,235,58,200,213,223,68,254,49,210,128,11,87,0,207,25,93,183,141,193,9,142,11,15,213,209,90,220,249,117,222,163,188,42,116,162,111,235,175,70,29,243,205,184,46,214,112,219,68,27,190,37,228,13,196,98,127,58,220,90,248,241,41,128,82,170,102,78,72,99,103,47,49,238,210,203,217,40,130,83,98,143,81,119,52,173,166,24,234,61,253,11,147,118,189,128,69,161,207,122,161,251,67,139,246,0,44,109,95,241,166,224,177,225,201,10,38,201,24,44,192,55,22,191,109,159,167,39,67,213,33,100,6,197,183,223,105,223,51,37,21,232,53,7,12,64,243,13,77,22,76,175,156,127,201,50,147,144,135,179,71,59,88,161,195,29,23,213,184,66,77,202,54,134,198,21,205,74,59,68,197,2,150,28,192,219,164,192,158,231,193,240,26,176,33,136,97,129,95,91,76,114,79,86,97,220,135,80,233,39,150,150,27,223,206,160,84,151,120,226,45,231,200,167,121,200,46,1,132,39,112,88,96,85,173,249,29,67,46,208,224,131,84,81,64,218,16,15,12,243,215,86,157,212,204,147,221,26,11,10,114,75,9,240,8,16,58,152,196,219,149,51,8,94,225,203,7,157,156,249,220,220,207,80,128,47,103,189,58,38,83,183,122,51,230,254,146,160,37,235,226,233,55,164,177,33,246,224,67,54,25,126,27,216,100,83,102,46,231,99,215,206,57,243,30,174,54,153,209,116,17,156,121,215,104,69,33,59,37,187,95,75,158,233,68,148,64,236,174,32,201,143,189,99,126,50,216,65,155,184,98,84,102,243,47,178,99,59,227,198,213,53,206,39,35,180,9,162,212,58,190,48,80,234,176,124,165,130,234,100,117,5,245,122,210,159,134,31,165,144,196,154,81,131,130,236,180,4,23,225,45,144,92,99,117,71,130,142,141,103,81,168,211,2,123,203,171,59,133,24,46,169,116,160,216,233,44,215,66,201,119,51,58,75,50,68,116,127,170,113,129,55,193,109,155,237,246,191,189,150,135,24,5,204,65,201,86,15,202,87,40,122,227,52,245,82,182,54,65,104,165,101,190,208,117,246,203,163,168,171,35,67,186,170,221,100,63,0,206,157,229,28,237,147,132,88,91,215,64,64,22,48,88,246,232,140,146,211,199,110,230,207,238,78,66,78,104,253,244,227,114,94,210,30,6,33,43,1,110,176,2,156,178,126,202,213,183,124,213,218,56,96,100,54,192,53,69,60,180,73,48,142,15,85,251,191,216,147,246,47,251,203,203,138,14,174,9,73,186,102,220,0,200,22,56,137,234,117,155,105,229,151,192,129,193,93,234,222,103,57,195,107,240,92,18,180,41,23,23,255,255,135,26,222,109,47,129,205,129,52,192,82,153,195,24,72,58,156,127,159,210,114,67,196,173,239,17,84,216,115,57,151,70,218,133,179,61,149,175,160,128,222,103,91,202,239,92,198,173,251,58,186,236,105,215,23,167,254,58,4,21,22,17,213,211,230,47,195,183,154,245,187,224,165,236,107,184,195,149,49,79,138,158,97,201,64,138,145,249,37,253,56,175,148,83,197,74,69,186,47,38,63,14,241,224,30,52,152,74,163,144,190,253,92,176,164,109,217,165,118,19,56,214,162,10,193,213,18,95,72,55,150,22,199,50,196,111,155,204,32,122,25,68,234,156,43,178,92,160,204,83,138,2,184,248,7,132,201,144,69,176,216,12,49,175,55,89,163,91,23,159,27,226,183,111,153,13,35,140,237,237,170,126,119,171,55,105,81,53,55,142,131,46,39,136,83,145,158,216,192,73,71,22,117,124,243,85,81,130,52,28,216,143,226,153,141,3,162,141,249,125,8,119,27,65,133,135,123,117,71,161,45,130,255,194,160,178,21,123,106,105,199,3,146,205,115,157,18,61,181,226,101,151,234,244,10,17,216,104,186,3,215,32,157,200,151,190,41,62,181,74,5,160,213,185,70,97,253,164,115,81,108,228,207,4,144,210,54,224,36,93,21,210,109,58,54,121,127,235,182,110,122,161,24,48,114,193,83,31,221,109,136,70,83,212,203,195,232,231,69,5,55,157,106,77,101,19,58,55,127,91,240,85,64,11,229,155,10,93,177,2,144,20,75,121,186,81,171,50,1,196,62,217,231,16,206,250,186,173,24,60,218,230,99,216,36,3,103,61,237,73,61,170,38,35,224,158,166,103,119,128,4,5,152,194,141,234,113,149,54,196,25,235,18,81,227,137,137,138,115,20,204,38,189,115,69,224,31,135,6,32,171,72,87,42,144,71,72,255,171,79,132,159,83,151,209,62,152,25,79,133,19,172,154,90,84,80,101,131,150,37,245,195,199,210,235,98,122,229,215,7,164,79,63,62,80,142,144,161,189,235,24,212,200,109,145,185,104,122,29,112,81,147,15,4,108,147,244,184,155,249,18,80,201,174,227,93,226,109,63,7,17,14,209,141,194,160,30,170,18,60,144,32,224,177,0,106,248,126,107,84,185,179,106,146,13,238,80,251,18,50,96,122,216,217,112,187,148,102,111,47,244,158,22,39,76,59,150,43,22,117,202,253,88,26,166,126,243,142,239,81,69,185,255,93,56,20,32,232,185,22,217,19,198,221,159,42,176,105,127,180,90,189,136,213,241,120,92,0,77,136,165,142,142,126,142,164,219,231,41,237,134,253,191,235,254,252,57,52,25,89,120,215,145,142,87,152,149,107,177,79,86,176,4,105,59,150,254,14,74,110,116,206,16,0,218,98,156,66,18,10,16,202,136,15,80,236,236,233,75,132,186,168,174,233,16,240,124,0,189,243,98,252,33,121,215,44,173,199,127,71,233,97,165,227,102,12,62,59,225,180,119,55,117,95,159,229,177,99,143,111,247,182,37,180,23,219,51,67,250,113,124,122,213,160,93,82,156,170,252,0,1,76,22,11,250,91,147,112,1,233,251,21,112,60,137,25,215,114,231,83,28,55,129,94,198,200,247,80,156,163,198,211,214,235,239,111,210,160,137,128,181,114,163,61,8,94,83,46,49,30,181,239,140,222,109,66,167,226,89,159,32,73,145,21,222,213,65,62,66,94,137,206,128,169,236,73,167,141,150,232,238,36,44,136,68,28,4,21,153,225,253,254,31,210,190,138,17,5,228,142,90,163,91,64,60,208,230,70,88,201,198,140,171,37,112,143,83,251,39,36,63,189,48,135,196,100,189,76,124,37,117,179,153,183,236,97,94,72,5,144,76,23,71,22,137,91,101,17,51,31,37,37,248,167,248,202,225,125,28,24,192,51,67,242,20,243,183,110,138,211,210,110,39,221,189,226,241,100,225,217,111,128,6,152,234,156,179,79,2,139,150,103,51,47,252,21,104,71,84,83,243,17,144,151,52,96,128,26,163,179,77,162,97,109,136,128,106,219,50,111,229,203,148,252,102,19,181,220,239,169,7,60,6,173,111,160,55,24,162,69,223,39,186,222,104,184,206,203,0,68,178,244,108,51,107,230,205,176,248,207,12,225,122,184,184,1,99,226,173,135,71,136,45,243,127,168,160,134,31,180,45,53,1,213,36,43,83,51,59,61,115,223,67,123,54,86,38,128,71,198,210,179,241,150,253,253,1,26,104,127,234,182,86,121,188,19,134,211,19,249,75,96,210,137,255,175,48,38,23,82,107,180,73,87,97,17,31,217,160,77,243,143,164,224,77,154,152,148,205,66,240,48,168,156,21,103,19,214,154,17,173,156,16,31,18,63,134,224,211,145,46,114,33,113,105,125,72,78,202,25,183,28,255,45,63,169,16,225,2,237,156,45,254,223,125,195,250,99,49,156,250,188,216,169,104,171,157,188,114,72,110,29,153,187,99,254,51,237,255,23,98,131,248,193,121,59,142,7,176,78,52,182,134,170,136,125,40,234,245,225,74,212,208,176,105,253,8,32,143,69,180,249,246,10,31,176,129,144,255,199,193,59,12,181,231,207,169,241,243,19,253,220,49,45,195,42,147,102,239,117,186,240,63,156,184,43,225,119,87,44,38,11,106,231,241,208,145,167,222,147,22,240,37,62,139,30,249,0,209,78,164,84,131,254,178,126,91,170,226,29,73,170,154,101,221,202,18,92,146,134,178,38,195,106,88,228,86,86,172,34,113,89,4,85,139,78,39,3,161,49,94,245,107,21,206,162,64,240,35,201,126,89,226,156,229,141,165,29,4,22,197,202,125,44,200,64,176,137,55,95,167,234,104,86,244,217,45,234,206,4,6,171,85,146,235,237,168,81,103,77,204,104,16,110,90,132,100,240,72,96,188,201,254,56,43,229,76,8,144,250,190,182,102,89,64,104,238,222,184,173,138,130,235,233,91,226,30,237,38,236,194,116,180,36,198,97,37,242,32,60,224,15,13,203,190,121,127,41,1,108,205,117,79,104,173,232,164,128,0,31,193,82,164,115,1,175,199,50,22,0,215,136,87,212,105,174,240,47,27,51,93,165,183,61,96,31,150,125,70,38,192,85,215,191,65,159,42,123,59,211,210,39,96,64,53,80,103,134,214,75,89,23,40,114,4,148,61,56,175,176,119,180,61,162,119,184,21,110,204,103,52,202,109,151,202,204,240,215,165,116,96,52,113,64,112,42,171,54,172,169,69,253,44,153,24,232,19,141,73,3,80,141,143,57,23,209,218,79,5,176,20,117,197,223,97,0,0,216,103,205,251,42,189,173,104,182,224,240,187,184,90,150,165,151,54,237,248,21,195,252,26,86,186,43,130,85,173,165,88,77,47,61,60,251,197,177,40,114,201,153,72,161,39,61,136,217,22,39,227,180,112,20,184,0,22,255,248,87,132,120,113,8,6,226,212,166,57,112,185,75,15,83,79,196,106,136,205,5,59,250,63,35,80,140,176,236,196,248,3,221,98,250,104,32,99,152,165,109,139,192,40,49,68,14,50,89,102,202,12,64,120,114,49,227,205,144,18,43,180,65,47,167,89,67,145,180,44,241,173,23,232,86,141,103,210,72,240,225,180,133,221,238,4,125,161,121,44,204,5,162,64,34,84,167,152,247,154,190,162,116,71,83,180,181,174,3,151,227,180,162,28,198,133,1,195,199,54,251,220,4,182,126,209,15,24,207,187,240,50,11,120,250,158,87,125,246,74,64,175,190,21,150,255,202,170,125,38,228,16,24,166,186,7,113,0,133,182,112,138,188,2,24,120,236,10,76,154,89,48,23,228,159,219,144,219,209,76,59,25,100,202,46,203,178,117,252,97,240,97,42,143,205,52,199,220,7,0,109,217,139,126,170,178,227,213,192,16,171,133,173,237,240,186,6,14,155,94,157,194,99,123,174,181,74,164,126,56,178,0,172,77,163,74,172,53,5,161,130,161,162,149,232,150,69,170,172,59,70,142,112,87,58,16,192,67,8,250,29,140,221,17,117,167,133,43,180,141,157,214,18,131,114,105,147,206,25,138,207,188,30,41,9,97,113,247,123,251,56,165,182,239,95,79,152,45,113,160,213,230,249,227,167,149,52,172,156,182,242,134,61,19,90,144,248,100,252,168,76,213,246,126,123,175,8,114,218,41,247,90,229,94,238,86,73,43,35,42,116,168,217,75,167,166,122,230,82,130,255,164,51,9,86,79,111,49,152,198,132,96,62,12,131,23,66,96,51,213,29,13,144,20,26,228,66,41,228,68,254,126,173,192,51,62,41,184,136,182,93,102,144,250,65,236,200,19,121,182,87,125,72,97,132,164,29,130,211,26,115,217,177,199,35,54,132,98,87,138,188,229,34,130,240,81,186,231,130,41,17,74,64,27,41,169,251,229,192,38,247,81,85,224,10,181,80,164,164,112,73,150,53,119,166,144,157,52,98,187,48,28,64,77,33,237,100,1,46,123,40,27,232,128,105,190,126,27,132,205,16,107,184,30,187,240,29,128,81,177,9,175,37,159,188,53,109,59,15,33,102,39,182,31,73,163,176,14,150,178,216,231,41,152,253,100,240,46,106,181,137,111,240,101,204,74,57,134,179,49,230,134,124,152,70,64,166,43,65,203,80,53,157,166,39,138,142,243,74,145,217,9,194,93,128,67,93,129,161,161,254,211,189,239,205,32,171,253,118,141,204,240,183,222,146,198,220,187,58,201,238,218,179,206,89,183,40,198,33,53,38,40,144,216,247,161,189,216,173,9,22,72,148,174,45,3,127,35,125,111,140,15,207,119,246,38,244,195,69,85,106,121,28,241,125,124,103,116,108,152,84,133,165,68,92,5,189,160,223,125,159,69,84,91,214,24,52,36,207,180,152,8,156,70,209,194,220,165,138,212,192,246,132,124,186,64,218,179,23,131,210,117,7,15,197,250,249,187,104,74,19,195,232,168,66,171,125,133,252,89,123,236,67,152,150,187,82,161,241,29,160,206,15,254,101,201,34,79,182,6,88,237,204,67,3,24,199,64,58,22,71,118,31,80,235,148,111,111,74,248,229,15,0,160,215,0,121,227,15,243,58,122,251,203,236,223,102,217,235,105,113,239,209,206,227,198,166,116,250,85,48,71,14,78,216,2,167,129,129,240,167,56,89,118,161,125,49,228,56,221,13,219,207,36,68,253,27,45,219,117,151,229,111,247,206,97,173,132,8,74,182,16,125,54,238,31,46,244,50,250,3,216,182,42,120,67,61,39,106,101,23,248,21,80,151,115,41,105,95,47,32,90,53,3,164,31,12,113,105,26,135,101,186,43,191,173,143,177,4,75,109,96,7,121,5,231,218,250,45,96,254,193,146,225,251,238,21,240,27,207,43,187,7,61,254,195,234,210,152,46,241,186,188,216,234,82,179,109,61,190,139,211,58,36,74,149,107,249,150,196,71,226,167,232,40,42,19,152,17,194,16,94,5,11,57,37,43,99,98,248,81,211,60,69,192,80,94,225,241,197,53,76,100,1,166,253,132,17,3,72,232,72,214,60,18,151,159,15,167,78,27,76,142,22,21,129,121,10,185,35,246,49,165,218,73,182,236,65,1,175,236,230,71,209,189,163,164,179,194,209,86,6,180,219,147,94,15,212,246,83,21,183,250,40,230,78,222,159,74,94,13,20,247,51,90,218,253,125,50,81,72,93,1,200,50,199,223,192,197,223,38,208,98,122,118,7,82,178,154,193,50,199,199,7,184,231,120,39,2,232,41,182,32,75,56,236,176,5,0,113,190,13,109,1,175,212,249,89,21,130,204,162,228,119,244,190,87,252,151,13,40,209,103,93,95,199,103,141,133,122,94,189,161,222,26,229,214,114,137,110,97,84,81,251,213,80,122,215,144,113,154,105,12,130,191,24,0,226,159,46,86,119,142,104,231,72,118,224,91,195,94,179,212,168,32,243,2,25,219,4,197,34,167,252,198,18,155,87,88,62,165,118,253,176,96,152,186,128,214,140,226,59,11,113,104,102,96,136,126,9,13,140,165,46,116,134,52,249,105,131,168,226,83,93,216,194,247,236,251,159,42,118,243,93,85,175,120,106,134,75,146,217,187,183,49,138,190,5,189,3,203,106,166,110,104,108,70,111,165,41,203,34,212,254,32,10,2,238,30,243,126,47,119,175,63,107,73,75,131,105,17,54,253,158,128,179,196,198,64,151,178,55,47,159,191,106,78,234,208,198,108,42,131,2,33,44,121,43,48,137,107,252,205,15,84,242,200,169,148,239,199,117,248,6,151,51,83,45,149,57,75,160,202,27,122,235,14,50,90,135,90,94,140,171,241,123,236,90,200,243,190,6,111,165,246,139,34,141,151,172,38,34,66,201,218,83,110,52,12,146,6,26,248,102,120,174,193,25,147,171,152,87,174,79,55,208,166,73,111,90,214,25,117,239,102,226,213,182,128,93,49,129,174,3,2,180,9,250,166,8,32,141,187,26,55,157,229,144,64,195,91,154,133,56,176,6,198,60,119,115,232,70,213,143,59,250,97,136,50,75,125,198,19,151,141,168,48,163,47,67,211,114,119,103,69,9,119,244,236,196,164,248,228,69,215,205,245,16,57,177,244,43,224,109,172,45,14,5,161,195,63,81,38,117,19,125,248,179,103,199,168,84,151,192,55,216,72,96,43,117,199,103,51,202,42,177,40,169,84,157,153,173,244,141,108,142,38,188,53,35,151,221,147,12,148,111,151,129,212,37,253,142,191,152,21,241,153,150,30,71,95,49,124,83,150,47,109,169,199,96,70,141,167,74,79,11,152,159,93,215,159,185,141,249,140,114,217,75,87,133,177,114,114,27,32,86,10,246,20,157,127,160,164,227,79,194,177,107,49,142,179,84,144,135,178,81,30,7,228,120,116,11,103,210,83,15,94,77,40,116,144,27,125,81,192,231,217,112,4,184,78,6,144,65,184,221,84,114,52,150,241,217,130,114,219,252,15,34,244,209,76,178,193,231,229,38,137,147,0,147,242,150,26,33,32,28,132,60,63,134,221,9,214,135,97,120,217,109,78,130,199,253,153,215,234,19,186,201,199,169,20,132,151,74,179,54,65,25,171,126,126,88,23,247,222,39,52,65,85,45,245,229,214,38,98,14,0,10,216,42,17,230,34,91,84,144,209,31,186,211,140,175,188,80,202,99,174,124,88,40,32,214,235,133,253,145,179,186,102,42,135,61,67,235,163,133,41,35,25,168,87,141,24,186,210,233,150,19,220,120,81,123,169,245,18,197,27,207,176,15,197,115,139,69,152,82,211,148,77,184,232,173,29,253,46,123,173,245,217,54,231,135,218,236,101,196,45,109,136,189,206,68,215,214,77,251,43,39,224,144,62,135,50,114,247,67,110,247,38,143,220,5,1,173,142,88,7,149,152,225,194,10,114,152,121,105,239,242,249,117,29,172,2,39,98,218,33,31,69,93,11,210,222,132,40,251,162,173,144,13,165,165,242,181,202,215,89,196,228,253,39,70,73,153,144,63,184,211,2,204,107,51,166,197,173,14,15,96,66,141,11,12,244,148,50,16,214,9,8,52,6,165,105,91,184,10,10,62,135,250,200,159,69,227,229,86,98,229,73,27,200,217,108,233,211,81,90,93,45,50,50,149,19,35,23,116,202,113,21,211,33,217,140,128,86,228,185,130,140,104,87,180,174,131,213,254,48,90,67,239,159,204,139,229,42,236,142,82,151,187,165,11,12,150,53,56,10,76,97,213,117,217,51,242,133,135,229,78,117,95,26,31,69,32,138,147,70,226,136,42,0,8,199,224,233,35,206,48,207,61,99,52,101,204,118,143,245,236,120,33,226,57,223,53,32,255,6,236,127,223,89,137,99,84,204,80,106,20,237,64,149,193,65,7,41,202,120,56,115,112,137,35,254,243,28,47,4,229,33,115,177,48,219,231,48,63,139,95,214,209,6,170,197,116,222,104,88,254,141,16,48,222,226,9,47,121,65,188,142,38,129,229,60,122,25,131,229,78,249,211,139,93,199,181,248,231,247,38,161,131,223,146,216,88,123,189,77,186,220,2,185,53,173,226,101,153,213,103,171,140,207,44,51,120,168,36,182,213,176,87,166,170,61,250,49,139,249,215,135,168,170,59,95,118,142,249,166,177,121,94,175,159,219,228,219,117,28,222,43,180,225,108,140,7,25,5,94,45,171,5,65,137,255,40,123,190,89,181,94,76,172,91,161,197,240,85,79,172,28,47,57,205,233,102,137,143,28,155,20,20,157,41,148,175,43,167,5,82,171,148,109,247,237,236,176,176,124,1,158,189,93,168,51,115,231,208,228,55,164,123,212,27,25,190,38,1,120,25,153,91,236,95,116,67,210,173,224,156,220,91,207,120,91,114,212,191,71,198,205,146,136,65,91,33,204,192,154,155,243,71,11,55,239,100,89,204,247,199,59,120,22,68,109,137,194,203,81,61,247,11,226,242,210,155,195,209,1,193,108,163,178,20,22,170,30,148,214,80,229,153,91,103,246,237,10,245,110,211,150,205,98,239,92,94,71,206,91,253,204,90,157,216,152,35,148,167,8,201,167,24,239,191,158,102,23,131,159,64,99,81,159,58,193,185,68,1,28,24,38,198,132,80,191,19,122,235,99,129,100,49,253,29,52,194,32,108,106,166,243,179,53,189,96,59,73,241,61,32,223,84,218,118,59,32,64,9,98,239,207,219,101,38,106,54,148,148,25,5,50,107,106,152,242,117,192,102,56,184,19,232,133,157,243,182,52,144,217,94,101,153,221,88,157,52,224,159,93,159,71,2,115,200,230,116,202,177,236,75,20,176,16,39,147,24,150,195,21,251,77,57,185,113,216,168,48,127,164,56,104,92,23,85,141,159,93,53,192,103,163,130,24,85,85,160,61,246,23,185,196,18,158,228,129,148,126,206,52,198,191,182,12,98,112,31,56,160,62,208,196,234,1,56,249,23,61,115,25,164,254,151,45,11,124,107,53,151,131,221,52,249,185,90,5,4,129,177,134,168,239,37,50,111,225,178,53,251,9,5,87,32,111,75,239,38,160,33,50,128,211,5,250,31,61,177,31,115,182,221,118,33,225,75,165,5,43,89,152,62,217,185,246,122,194,98,47,193,42,74,46,144,111,16,231,76,88,151,7,93,68,144,237,82,117,206,167,239,6,137,55,125,14,88,92,201,143,148,62,216,55,224,150,178,38,77,42,167,163,233,124,131,220,55,50,219,117,225,244,220,233,124,27,133,246,213,86,54,152,29,92,98,226,98,54,110,144,186,41,161,225,72,199,30,105,121,160,56,141,23,100,40,88,208,169,32,196,122,95,231,57,244,199,120,13,232,165,250,170,24,34,231,23,205,33,18,214,128,56,165,14,48,104,223,133,183,73,58,100,111,112,115,239,70,81,81,38,94,88,232,164,212,242,0,59,114,36,133,89,252,41,204,37,193,144,244,255,242,124,20,131,112,126,131,187,205,71,229,86,90,197,199,245,45,120,190,56,223,164,63,177,75,188,238,180,176,137,182,95,221,29,158,104,4,224,38,183,94,172,67,44,62,168,237,218,85,159,58,25,168,173,108,204,228,81,18,145,207,176,19,10,212,78,133,108,169,178,117,11,19,155,152,200,117,243,99,143,126,93,75,167,4,103,249,245,27,30,184,78,162,35,174,200,4,59,119,138,195,58,130,59,179,147,48,207,134,201,207,31,90,145,168,212,195,79,220,16,253,80,24,42,159,61,178,241,81,140,246,198,225,166,94,74,63,254,3,218,93,2,74,194,239,192,68,55,75,132,51,79,200,162,72,133,34,87,86,7,157,235,37,94,78,191,150,81,213,162,147,20,232,243,173,36,1,244,91,3,192,10,224,194,229,74,147,19,192,165,168,153,5,127,230,113,185,206,127,146,80,114,246,179,16,31,90,0,242,254,82,189,36,246,211,7,118,168,33,154,220,184,107,101,40,150,196,194,242,253,216,72,132,210,147,230,224,198,34,75,25,74,233,205,159,168,6,197,50,217,127,251,94,27,0,89,55,171,138,10,197,251,46,127,84,139,97,212,131,44,89,5,181,154,11,223,2,106,249,29,222,72,44,89,57,56,8,138,102,140,86,159,219,77,239,32,203,126,142,214,192,72,16,119,161,71,155,250,58,115,189,112,51,213,249,25,85,78,170,171,102,164,103,133,109,37,229,130,167,116,64,21,234,76,246,89,206,141,235,89,223,141,56,47,168,166,97,190,26,197,70,97,133,200,148,53,45,183,39,129,38,122,174,116,58,75,115,221,204,101,52,24,94,177,14,237,2,172,234,210,8,208,25,77,235,113,24,108,216,242,184,180,255,173,101,240,51,246,200,240,13,156,209,93,60,66,170,252,82,230,13,215,146,117,255,210,7,34,122,10,106,156,176,21,68,222,248,33,83,152,206,191,60,18,158,149,114,74,41,60,203,244,210,249,189,212,25,25,75,131,95,76,207,254,188,23,124,249,162,255,170,137,0,81,97,181,221,127,2,120,240,234,80,28,115,105,158,136,89,77,135,103,255,251,8,186,242,63,176,164,122,8,11,128,19,58,243,8,212,252,204,84,170,108,158,179,247,0,254,32,87,139,213,136,45,180,92,145,67,92,246,247,205,97,103,87,101,163,137,0,61,23,230,147,218,153,102,235,104,17,24,246,70,190,79,179,238,178,41,56,128,115,241,148,114,229,173,144,63,54,151,123,191,45,145,222,89,230,29,59,34,163,123,120,56,34,137,149,161,32,221,255,87,39,50,57,112,84,159,209,51,170,143,167,190,117,145,202,12,127,248,132,142,52,118,154,247,22,242,179,161,240,146,155,7,176,79,18,1,228,242,227,81,34,121,92,236,105,176,207,233,51,86,159,119,70,173,14,42,103,31,241,149,157,98,49,61,96,106,94,142,12,146,88,63,16,173,84,14,216,170,188,7,119,188,94,156,24,78,218,117,39,252,216,201,136,241,118,24,231,164,15,9,211,193,68,14,9,140,214,99,95,235,172,219,136,83,12,95,75,88,48,152,236,153,95,137,236,38,125,35,176,220,87,52,101,106,40,172,224,140,105,118,201,227,143,43,59,162,152,247,197,72,70,232,183,21,160,2,64,169,41,69,166,102,52,189,217,130,19,196,230,34,133,35,31,17,193,45,252,112,79,79,223,99,168,154,14,19,74,179,41,246,27,199,128,101,54,80,252,173,165,241,80,26,204,142,255,57,94,25,56,246,22,133,229,144,110,212,118,251,36,49,81,254,183,116,222,99,70,181,22,74,96,199,161,124,176,7,199,9,56,128,64,200,185,222,37,225,144,156,152,22,99,76,208,43,99,207,169,146,220,182,136,30,96,166,118,49,125,40,132,106,49,212,158,91,55,84,208,213,75,63,190,113,71,83,98,109,21,176,11,204,253,157,79,106,111,232,239,253,187,98,141,32,52,39,209,183,100,176,183,32,232,137,209,189,13,67,230,44,99,233,235,31,211,62,149,120,185,114,79,123,8,153,151,112,255,65,154,228,16,226,177,21,18,10,146,172,134,181,123,4,253,122,188,229,98,89,112,147,19,145,108,246,176,210,201,128,231,96,230,39,140,7,175,246,144,253,114,34,223,14,48,134,160,78,112,135,138,197,142,208,213,221,156,197,198,131,42,169,203,191,140,36,205,131,59,11,239,147,205,235,193,132,59,199,198,42,204,244,120,24,172,221,253,85,141,118,110,76,153,91,146,222,142,200,251,52,172,145,250,47,123,86,49,253,220,27,77,170,51,36,179,148,26,32,251,162,197,246,163,248,65,123,233,68,194,166,153,206,118,238,22,134,49,13,218,176,11,183,124,197,148,169,251,224,80,11,209,166,233,229,19,220,114,244,144,246,17,131,119,108,78,6,26,238,121,82,13,57,179,139,149,164,255,235,181,20,240,76,155,71,61,89,192,100,16,244,93,71,199,139,70,203,107,44,233,154,66,40,255,1,15,20,206,89,244,23,68,123,164,177,175,187,170,150,195,150,44,96,99,142,169,220,220,197,235,124,72,198,60,112,180,196,35,190,154,107,29,177,10,243,111,210,61,157,156,223,255,101,5,210,27,224,15,23,138,119,65,201,139,134,84,70,122,22,204,153,5,193,108,54,149,173,173,37,200,81,229,93,72,7,45,14,51,177,85,166,96,189,55,43,70,88,172,251,17,221,163,81,62,196,216,14,31,82,46,38,65,125,42,32,4,9,145,100,31,102,106,231,86,31,167,246,39,11,28,118,34,92,179,80,65,191,115,43,247,211,118,115,124,156,122,145,222,177,73,161,7,117,51,20,29,178,100,26,127,202,208,177,209,121,101,140,194,20,229,139,123,55,186,209,31,33,39,115,64,97,128,152,60,147,70,35,97,4,156,87,181,58,244,132,109,115,229,91,215,10,28,25,21,57,163,234,21,101,81,18,220,78,130,105,85,41,164,78,228,156,201,182,234,93,221,241,194,212,66,84,4,11,81,116,94,234,37,200,8,214,228,253,58,205,250,62,168,189,1,46,223,0,158,154,29,127,247,188,25,193,165,228,117,234,121,149,167,254,11,3,15,12,91,42,46,11,240,230,134,120,108,46,58,63,23,230,140,113,173,206,94,55,63,20,187,32,255,142,32,192,135,161,231,95,115,204,50,125,129,245,15,153,89,124,35,87,200,91,78,68,126,100,158,103,224,232,192,132,174,34,19,19,48,139,182,247,255,70,88,227,139,253,31,10,222,62,188,140,85,169,143,143,14,29,108,159,46,98,211,30,129,63,149,77,230,246,61,181,103,153,124,242,214,63,70,78,193,78,208,159,94,20,59,30,81,88,112,124,123,183,101,239,217,86,232,137,59,250,5,110,107,71,27,31,15,33,62,200,161,218,153,82,134,5,7,141,180,7,152,169,23,182,33,150,252,223,90,209,54,177,15,50,19,8,253,37,226,84,143,33,164,230,38,215,102,42,156,198,36,35,149,175,75,79,102,252,69,215,7,165,103,252,189,221,18,204,32,86,110,22,47,74,38,247,11,126,5,145,242,247,20,9,190,177,121,79,16,110,73,41,45,141,3,247,35,3,252,191,45,7,156,127,115,198,74,194,5,25,124,110,61,109,115,151,84,72,182,140,170,23,217,123,133,98,143,18,53,128,55,78,61,89,152,214,253,63,133,196,183,215,107,107,158,245,129,15,153,169,246,158,65,172,8,47,226,30,126,10,64,163,175,108,218,130,19,89,235,34,206,150,176,199,6,140,234,201,165,130,107,208,64,112,36,44,115,250,199,236,204,60,127,43,124,225,163,49,76,103,210,254,126,180,82,44,230,68,93,12,246,201,186,72,190,172,76,128,42,173,0,221,120,14,150,19,197,121,163,71,111,214,183,143,24,187,70,13,255,228,250,134,173,209,183,166,208,21,225,94,109,145,98,70,255,76,151,190,150,183,152,248,238,224,187,111,4,2,111,236,73,135,133,67,34,193,94,52,159,42,187,59,38,75,152,72,134,112,236,191,233,150,43,156,14,167,70,226,7,114,200,31,140,164,33,84,232,169,15,96,172,175,192,57,229,71,227,101,139,17,90,45,154,32,255,204,159,141,200,159,147,45,152,135,128,51,11,78,181,154,83,92,144,157,134,244,234,140,201,95,218,104,165,146,35,28,223,139,111,128,149,30,162,119,191,217,136,196,219,138,212,22,168,182,19,118,34,168,68,234,104,231,59,166,128,52,254,212,215,218,117,66,31,249,88,61,78,33,130,242,94,66,17,169,102,100,130,251,1,125,169,71,110,165,239,246,162,251,220,185,184,20,76,133,171,122,57,219,218,181,169,220,38,166,27,206,53,166,180,135,172,64,7,187,131,182,110,67,34,191,25,145,197,184,217,30,140,72,15,212,194,123,34,239,194,64,110,117,35,199,82,17,157,252,230,226,228,44,151,158,81,101,191,59,18,175,143,139,235,12,185,50,15,106,29,143,82,247,211,52,208,35,153,64,11,50,37,13,38,232,128,45,104,62,240,201,122,137,83,140,250,178,64,142,202,168,54,119,221,215,71,166,35,108,71,223,239,99,153,12,8,134,64,200,182,235,107,96,111,231,153,200,254,189,247,49,93,127,4,200,77,43,160,120,224,252,243,224,46,190,166,143,82,46,207,86,235,116,203,190,88,18,55,121,70,227,215,107,69,58,245,221,133,33,73,230,34,36,254,49,127,129,180,253,175,209,180,54,94,124,96,104,97,243,225,38,248,166,230,189,233,78,38,61,122,43,51,76,9,219,127,1,239,79,151,48,213,26,208,118,80,108,178,180,167,38,224,5,87,106,12,73,252,109,195,190,244,1,237,106,212,236,116,74,192,255,121,219,152,67,18,77,38,21,51,27,121,200,196,0,84,219,179,46,124,54,85,12,179,49,241,46,197,14,33,28,79,227,246,94,112,66,187,209,230,116,161,40,15,78,57,156,110,138,178,73,41,255,178,62,43,236,180,171,248,21,243,240,13,110,71,67,79,176,57,76,207,194,20,219,223,36,60,83,50,200,87,245,137,235,132,89,144,67,4,174,55,221,14,212,138,175,187,209,186,54,80,178,238,243,36,9,199,108,128,111,120,61,208,105,53,44,233,236,78,63,226,71,197,238,242,101,100,227,70,160,209,41,198,56,65,115,138,237,132,126,95,23,46,122,98,177,164,159,251,98,212,145,111,203,95,36,21,53,163,88,57,51,139,255,60,181,38,187,107,75,128,165,215,232,130,56,103,173,192,192,119,72,104,142,246,79,232,200,17,207,225,61,55,106,74,61,126,180,229,233,187,223,190,82,11,232,15,84,52,13,98,154,199,134,191,227,132,219,235,17,230,249,92,249,34,165,54,132,101,234,209,220,66,6,69,181,50,132,160,155,246,171,5,167,56,49,27,175,90,222,36,13,217,116,128,9,151,3,203,43,43,40,205,132,14,248,28,88,180,107,146,95,19,175,0,109,41,170,148,148,54,179,0,71,101,59,99,221,143,205,42,59,156,112,136,31,59,18,231,136,191,41,46,122,77,101,152,172,123,108,116,111,53,229,4,163,218,156,39,171,198,100,223,236,90,205,126,143,72,67,138,159,241,118,154,239,154,219,34,182,123,33,163,113,46,15,249,238,36,50,215,132,241,226,207,196,181,96,162,212,88,224,190,81,179,12,136,146,122,238,83,129,26,72,105,125,20,146,253,67,112,232,12,188,96,52,161,160,121,241,50,77,49,218,20,78,169,246,196,95,213,12,11,243,170,71,1,244,78,233,115,143,34,201,250,23,100,9,97,17,4,211,193,128,42,106,170,138,9,75,28,208,247,157,32,4,210,106,87,15,97,167,209,22,160,123,52,183,148,194,21,14,53,212,119,43,76,147,154,56,43,175,79,109,103,68,93,115,95,230,242,89,230,162,136,47,37,79,109,220,24,217,83,40,241,45,113,250,138,133,115,120,72,115,222,65,36,226,44,1,172,128,192,152,113,44,162,139,24,194,114,139,90,162,31,228,198,129,96,97,224,87,232,183,43,193,104,251,129,67,148,240,227,100,4,27,202,89,241,226,221,189,142,102,74,1,234,197,88,247,95,217,142,161,58,118,124,174,252,162,242,248,126,19,199,138,191,202,209,59,204,127,100,65,187,50,108,197,107,107,205,55,228,48,246,168,68,28,74,186,102,54,116,29,188,57,221,206,122,202,240,151,15,23,162,146,91,12,88,51,69,3,110,205,52,5,186,49,46,171,126,221,23,30,236,45,162,17,198,211,238,177,147,106,5,203,206,78,143,1,167,153,96,15,225,28,219,223,209,68,221,218,102,32,19,138,90,130,254,63,73,240,165,99,150,83,198,65,210,22,92,216,204,186,182,213,249,35,2,80,190,138,101,47,225,210,232,29,85,90,174,228,82,244,173,189,193,47,20,238,93,189,172,27,25,87,244,243,224,87,201,186,153,42,69,160,195,77,180,136,128,231,197,161,163,94,0,191,87,57,125,254,155,170,223,110,165,95,181,188,82,153,240,68,118,58,137,253,184,248,35,170,207,20,197,246,93,21,36,48,195,147,75,92,94,166,34,77,198,225,189,122,91,111,136,32,138,146,132,33,113,35,32,184,97,10,255,132,98,61,203,100,65,30,160,150,30,85,22,8,32,101,187,142,240,176,3,67,219,207,113,202,242,213,177,61,155,141,225,69,7,10,3,184,65,132,69,241,149,214,97,91,168,150,187,136,18,190,15,66,134,232,239,202,169,247,10,160,246,157,238,77,41,185,221,165,157,108,94,145,231,229,169,101,1,167,15,161,20,158,211,139,204,107,228,206,211,185,65,246,158,167,12,107,190,45,182,28,192,44,106,148,62,159,222,82,10,227,237,251,3,151,152,139,76,162,183,169,202,107,181,200,129,195,124,71,208,135,234,26,203,154,53,208,137,99,150,100,142,114,50,153,183,126,133,1,253,9,202,235,65,46,106,126,8,5,105,93,53,17,35,209,62,117,114,152,57,29,66,71,127,2,130,103,158,7,17,86,195,64,229,219,75,195,212,33,209,50,154,59,27,177,135,24,163,107,219,137,197,220,7,153,96,131,0,65,187,83,25,18,15,100,245,27,6,174,119,25,182,124,115,158,7,84,182,105,34,75,231,222,190,48,233,221,49,119,79,153,174,200,28,223,87,37,72,254,237,189,199,23,239,255,69,27,152,251,104,233,142,231,80,48,149,197,234,170,200,149,73,120,9,20,212,128,69,99,144,23,22,83,89,207,47,19,17,198,156,214,226,55,130,85,146,54,5,58,224,214,6,27,36,31,164,126,182,225,53,4,52,100,11,28,220,125,41,101,102,215,188,97,6,55,113,252,140,78,81,115,58,203,129,115,132,109,206,21,68,78,20,128,95,62,34,72,211,75,41,78,234,223,115,175,57,229,107,227,179,9,162,15,86,211,207,126,44,120,162,65,99,15,187,57,91,18,41,138,119,15,37,90,138,187,40,13,121,164,30,26,160,7,116,143,9,149,10,228,215,85,75,134,113,241,72,248,12,116,160,177,187,166,188,208,252,178,182,169,220,121,139,203,135,116,198,224,193,215,214,189,110,168,68,129,130,192,8,226,15,122,181,16,37,227,17,156,38,246,249,4,89,193,12,237,32,109,66,52,139,50,235,10,231,210,19,204,191,161,192,238,27,142,203,62,146,194,119,135,132,70,245,214,127,209,179,254,19,43,72,110,124,118,71,34,142,134,163,182,130,140,131,160,56,194,13,10,6,8,136,131,171,206,237,108,163,127,8,17,208,116,17,165,125,236,166,45,180,115,123,110,117,255,84,33,201,176,66,60,220,2,92,128,59,50,147,27,232,7,251,48,118,128,215,225,182,113,163,1,165,184,212,132,246,28,57,13,84,140,97,222,230,172,120,254,160,216,70,239,215,0,111,160,68,51,0,31,109,79,49,38,221,94,95,37,226,200,239,75,160,227,1,122,27,49,244,122,133,67,125,60,12,216,60,89,219,92,146,252,169,205,31,71,112,119,174,142,76,205,10,173,28,31,26,119,222,159,151,151,214,150,124,197,51,174,17,3,58,240,120,130,175,51,87,155,106,76,197,143,86,226,95,45,72,196,34,230,99,248,121,236,163,207,67,132,152,165,42,252,107,111,171,10,114,221,71,94,190,87,197,251,236,116,86,60,82,253,64,166,236,178,150,126,252,230,179,186,45,52,123,29,16,175,237,157,13,213,215,69,153,217,233,51,38,227,186,80,200,188,65,110,196,78,3,202,66,175,161,253,111,249,120,23,44,176,170,211,138,243,128,128,115,108,85,27,23,107,91,1,212,31,154,136,228,166,30,96,59,92,34,162,61,242,225,232,47,195,154,45,144,74,125,246,69,128,166,229,187,39,196,152,5,66,133,189,18,245,235,31,214,153,14,205,11,130,1,238,167,83,107,14,41,235,8,139,62,37,74,87,110,189,142,226,150,1,219,52,58,115,150,62,55,66,239,30,11,157,138,57,159,200,148,184,237,250,169,248,88,159,137,188,98,30,50,189,59,15,225,149,129,184,102,146,114,254,181,178,143,54,171,186,63,219,29,83,52,76,222,208,189,242,11,81,188,87,249,54,213,162,246,147,7,72,54,22,48,119,146,108,131,16,194,137,175,45,132,109,33,243,243,40,190,135,54,116,177,29,228,193,151,91,207,114,183,37,198,58,44,53,196,42,118,27,144,95,155,137,80,255,233,76,228,204,81,135,24,99,82,230,130,134,134,90,185,64,21,78,113,200,124,44,66,8,202,250,219,158,245,90,117,100,130,99,79,193,113,76,66,140,147,91,76,194,35,42,183,235,58,162,251,48,190,103,86,96,173,72,202,179,222,118,203,182,225,42,46,211,245,250,204,238,192,46,2,210,178,141,212,84,160,233,228,60,100,58,151,244,252,138,108,189,119,187,104,222,9,36,11,182,33,204,41,164,233,176,152,233,86,233,50,206,99,64,128,110,66,233,201,123,179,225,189,88,55,210,152,178,238,149,204,213,200,212,190,228,170,205,255,165,46,209,51,91,74,229,36,181,120,52,6,82,169,229,225,218,231,110,222,218,6,179,193,106,30,34,243,244,157,149,112,198,254,119,89,250,217,97,62,28,209,188,203,80,211,129,242,222,66,129,254,133,112,29,113,174,62,6,239,237,224,23,116,214,189,215,75,239,171,17,204,68,178,19,31,37,201,108,153,71,126,166,217,28,201,87,186,193,62,200,110,44,41,74,172,66,60,174,120,134,18,85,137,113,240,138,170,198,225,97,115,26,202,243,51,96,31,18,185,179,52,52,98,63,170,11,216,247,18,9,35,203,107,220,12,6,21,178,236,232,102,112,57,211,73,9,28,24,100,146,157,25,199,182,169,71,71,6,60,175,82,210,8,190,110,18,136,70,15,43,13,60,52,12,43,123,111,248,2,36,45,160,215,73,52,54,36,80,105,210,238,113,115,116,84,251,91,72,109,192,195,188,108,51,89,2,189,86,142,28,210,69,246,138,253,85,224,49,223,6,47,125,40,72,173,56,214,70,132,134,51,244,168,101,112,151,126,77,102,143,239,4,13,116,106,10,103,119,126,65,6,31,18,107,68,76,241,127,130,133,186,61,250,68,253,189,150,134,117,83,51,83,25,187,118,78,134,35,123,184,148,245,53,68,14,88,131,0,68,159,141,48,76,196,130,198,34,56,19,203,64,75,87,26,133,28,73,19,242,167,183,2,251,172,114,9,7,155,151,79,86,68,141,54,101,212,74,210,65,219,237,175,83,252,71,245,207,108,46,196,105,180,46,85,217,5,128,221,226,157,62,176,224,25,140,26,228,142,51,187,96,116,42,92,18,197,211,133,4,0,207,161,141,187,60,8,215,220,174,187,41,153,27,83,242,133,205,30,135,7,207,178,168,111,3,85,173,149,137,68,187,204,184,237,209,59,41,154,36,35,7,212,199,183,241,25,178,86,195,41,137,201,81,164,246,218,251,180,218,161,189,193,147,17,147,15,78,69,23,170,86,93,28,58,170,81,208,143,20,240,63,182,158,203,197,94,135,254,11,135,124,183,89,193,71,88,184,98,208,164,134,197,140,75,234,159,83,20,177,109,123,195,118,229,245,116,207,220,6,11,187,253,37,198,220,195,29,176,38,46,67,200,232,90,245,23,105,165,133,57,29,208,185,232,69,180,3,5,19,111,91,226,98,197,90,102,20,243,203,137,88,156,217,18,24,141,253,17,194,150,75,120,212,232,5,187,191,80,176,71,27,94,71,149,230,108,103,17,129,248,166,186,196,171,152,249,136,146,130,38,204,223,106,175,46,105,241,113,125,212,159,243,233,110,229,177,187,141,186,157,99,212,232,218,25,58,4,212,122,110,11,236,187,184,12,168,127,135,212,37,81,184,79,102,171,143,151,189,158,113,56,80,94,110,58,223,118,37,73,53,158,134,151,251,250,216,143,88,233,8,206,211,238,115,195,53,186,238,140,128,150,50,225,14,236,49,195,224,75,85,229,24,20,244,72,136,144,15,96,152,6,156,158,133,144,200,229,50,186,234,205,77,101,31,5,147,136,55,31,158,100,141,179,213,225,15,161,176,225,156,40,169,60,57,227,45,170,44,97,107,83,178,31,102,192,84,212,43,159,32,188,252,47,248,53,6,68,8,126,187,27,46,133,214,4,199,153,29,177,123,35,170,100,66,253,178,46,37,206,97,62,17,208,98,178,195,223,64,76,251,94,132,241,102,36,130,182,53,98,94,253,122,211,197,204,144,195,101,203,40,158,215,192,102,44,87,233,61,81,147,158,79,117,222,27,26,219,168,15,59,142,65,113,172,49,253,190,191,188,12,59,244,226,238,7,59,116,34,120,56,20,118,83,59,78,142,79,43,150,41,207,228,35,234,182,14,86,50,120,254,31,74,82,5,29,39,173,104,87,10,249,237,158,29,211,250,239,50,64,90,200,107,209,100,26,135,182,38,139,177,27,64,6,87,21,235,204,230,235,222,248,48,156,212,204,138,22,36,123,3,40,93,25,200,55,162,51,116,3,140,58,246,81,78,59,89,103,138,23,220,89,171,48,48,203,181,80,163,171,109,173,17,34,188,238,42,205,32,106,18,122,80,8,247,127,26,32,148,141,138,226,57,27,129,234,74,40,235,202,6,106,127,1,11,117,117,236,240,123,227,139,185,241,205,42,57,186,237,83,21,90,3,25,88,42,109,224,140,238,11,177,108,46,111,28,229,139,95,217,72,101,173,235,131,28,2,85,51,19,52,105,218,235,176,84,57,140,165,80,238,93,92,6,47,138,188,132,100,36,219,223,236,201,112,201,190,0,20,146,68,95,16,147,1,52,108,54,185,188,154,104,247,173,127,160,214,230,207,56,112,98,105,62,42,66,97,101,47,220,193,114,23,202,61,21,118,64,16,191,112,119,123,20,117,173,202,70,39,239,112,202,66,142,163,211,106,89,2,97,150,55,78,226,111,190,170,144,53,195,72,96,89,229,178,153,130,164,161,86,154,154,21,95,120,12,31,122,50,142,245,189,124,17,218,35,201,75,20,203,234,97,11,70,151,3,185,169,71,243,91,56,248,117,103,8,162,90,14,193,33,124,194,169,48,150,40,80,127,37,151,74,195,221,99,145,74,172,228,150,120,147,204,160,67,110,187,30,236,197,101,7,127,128,115,7,243,235,20,66,101,40,114,136,254,206,220,67,96,231,89,65,202,234,82,8,131,187,238,220,213,142,223,77,25,167,69,68,87,110,101,200,142,51,26,234,143,164,214,134,215,222,141,23,42,75,147,88,211,199,154,201,24,72,202,13,136,234,25,52,120,254,136,185,193,163,187,133,84,93,81,133,177,73,126,136,46,251,136,144,180,33,34,18,230,128,47,79,79,106,150,8,58,160,248,106,132,183,215,17,146,173,177,243,32,65,1,175,14,45,235,55,127,69,29,175,177,184,199,168,231,173,143,212,218,44,28,243,157,87,243,247,193,142,155,49,191,221,140,235,246,53,125,204,139,60,232,18,220,63,106,61,252,172,154,140,47,208,189,55,163,20,44,108,250,50,252,255,204,45,52,2,76,66,64,241,107,21,163,134,187,242,247,136,203,1,7,118,226,244,67,198,15,238,194,74,9,230,186,185,49,162,49,71,168,31,130,160,103,223,244,225,108,133,142,123,181,164,114,112,172,100,229,165,150,250,57,212,15,63,204,70,163,4,98,111,152,45,37,45,245,228,45,244,111,124,250,163,197,120,243,232,117,56,154,191,145,196,141,125,8,55,90,132,216,85,224,174,60,253,201,63,198,114,202,235,236,103,174,176,192,65,93,161,74,226,65,222,241,126,119,113,174,16,71,68,19,253,160,250,79,117,231,129,159,61,132,104,164,251,78,110,48,246,12,36,172,100,111,152,87,36,40,95,115,60,227,74,123,204,149,244,119,65,162,114,102,121,19,155,249,117,248,51,151,33,42,115,199,237,144,43,180,51,121,129,23,83,127,226,56,9,32,222,44,201,44,21,7,249,122,183,224,239,85,204,10,181,91,19,103,103,133,205,12,229,38,97,31,108,141,82,255,186,32,185,59,95,66,45,15,41,179,36,56,178,53,39,230,128,252,12,104,165,98,132,4,223,238,44,36,222,188,218,52,250,146,212,148,237,85,68,175,72,79,155,38,36,230,62,122,67,208,138,241,5,49,158,119,106,100,178,247,61,154,161,134,111,198,28,192,44,150,189,7,205,154,142,45,190,172,69,107,176,36,105,64,30,153,120,233,138,210,10,19,201,37,119,182,152,85,43,37,56,68,199,14,82,214,220,245,249,231,141,77,20,190,252,61,102,166,209,230,24,109,225,229,78,195,145,93,109,32,127,163,49,126,248,87,165,80,47,35,155,3,51,50,146,244,105,171,122,226,62,82,242,157,209,37,222,157,224,156,21,73,10,238,198,123,110,60,209,122,158,82,5,221,166,227,119,183,251,80,175,245,112,156,150,175,183,247,162,53,159,213,33,71,40,168,227,104,244,244,210,154,12,114,234,6,153,36,147,203,170,108,85,64,250,110,225,137,2,143,243,163,40,173,220,191,63,210,108,131,154,142,83,175,46,56,41,236,83,221,81,161,144,135,172,99,88,139,115,229,148,143,162,9,203,12,44,238,102,165,234,230,179,179,242,16,227,158,20,196,203,126,102,121,194,246,105,131,73,192,81,122,192,229,32,52,68,139,60,16,102,94,4,190,236,77,238,222,73,240,221,6,252,179,240,56,85,108,237,167,95,168,223,161,49,28,186,57,93,43,203,125,223,42,221,67,47,174,96,56,99,204,115,41,252,252,106,153,180,228,242,100,155,42,105,108,181,215,47,150,176,81,36,192,211,244,135,162,127,189,201,80,62,117,91,125,58,245,215,9,16,165,134,52,42,43,225,155,28,21,189,76,85,226,216,155,133,105,120,60,145,152,6,52,150,149,2,255,255,126,255,45,36,58,37,21,112,25,5,210,187,69,74,195,46,226,170,12,90,154,7,142,228,89,148,22,211,1,150,132,252,99,19,215,135,242,15,150,0,17,251,192,38,133,71,164,62,161,144,240,178,62,63,254,50,137,26,207,233,156,52,145,94,86,239,132,26,146,181,46,165,248,100,14,76,252,16,214,130,195,166,67,120,113,30,255,126,197,11,57,108,130,66,163,177,70,30,223,117,244,53,44,13,86,39,70,58,213,212,230,152,164,76,152,10,227,3,6,230,216,73,88,108,91,245,126,137,58,224,132,168,129,199,254,247,134,142,56,81,168,160,119,44,222,123,230,189,204,92,245,18,227,172,58,240,174,149,68,71,210,183,169,241,146,73,86,210,216,156,250,239,161,219,212,210,69,48,33,137,81,185,192,218,197,2,122,26,76,13,121,61,31,44,239,37,158,126,254,241,131,26,167,224,67,133,125,52,204,195,141,119,131,208,214,151,86,54,137,139,144,178,173,220,170,156,70,125,66,38,125,127,135,146,246,160,95,230,1,248,184,55,65,56,225,139,169,106,17,246,153,98,119,248,67,85,148,28,157,200,233,186,149,138,180,147,37,42,212,190,28,189,109,117,242,168,56,133,17,29,241,89,218,5,242,81,50,61,166,175,124,106,47,237,20,201,235,69,95,202,35,243,79,223,34,85,47,100,252,168,29,171,20,189,109,65,14,156,71,195,246,94,104,211,21,29,195,84,33,131,207,221,120,139,57,78,126,88,195,191,172,133,96,242,110,140,236,227,76,154,55,32,134,193,20,204,21,192,232,157,224,147,175,193,96,9,127,18,107,239,96,240,98,139,149,104,92,151,196,170,198,104,185,117,179,26,20,72,48,36,47,32,86,42,189,173,80,71,219,151,79,181,88,45,26,191,38,133,45,54,131,31,109,115,161,163,34,38,89,40,49,173,198,48,17,40,39,121,77,90,70,42,251,130,168,125,184,76,60,95,94,136,227,248,145,210,226,191,137,247,72,210,17,141,52,5,102,220,23,111,146,114,218,208,22,105,9,130,97,83,57,25,228,137,6,99,12,24,29,89,25,101,217,133,196,253,246,158,114,75,8,90,142,28,147,19,22,164,240,205,1,21,145,19,225,61,98,21,22,215,32,158,9,44,97,148,104,201,219,76,43,45,162,73,151,252,188,155,192,134,113,103,109,255,54,42,206,24,76,87,154,98,187,78,193,50,86,191,222,86,162,165,38,191,118,117,72,31,6,174,147,231,105,158,70,133,79,138,223,55,73,210,90,194,194,112,167,14,253,133,160,197,234,193,24,75,239,106,47,115,70,102,75,122,123,87,158,185,162,180,84,210,222,141,172,125,211,117,181,155,250,182,51,247,178,100,123,8,8,173,224,246,222,40,35,31,171,203,195,36,34,6,53,171,105,219,106,216,77,18,130,182,37,225,3,235,196,203,114,168,7,2,10,14,230,118,6,134,118,20,184,145,213,218,127,110,182,193,145,91,202,110,11,96,118,1,8,96,103,167,236,180,15,141,151,253,100,7,112,25,70,89,121,233,178,158,234,47,68,162,185,146,146,7,74,2,17,238,108,171,91,64,92,173,85,82,121,240,175,136,132,26,123,225,64,169,132,53,192,187,113,8,165,133,192,249,61,166,108,170,2,175,11,243,183,162,93,109,51,151,40,206,39,150,0,84,130,215,29,211,96,200,244,193,206,63,137,9,225,205,195,93,147,70,125,177,146,164,76,247,0,61,118,12,73,75,151,145,218,82,180,207,112,233,175,169,104,180,29,149,4,129,248,70,10,159,34,67,208,4,235,146,205,128,223,104,17,16,189,72,150,29,148,21,85,152,237,97,200,84,57,234,9,165,16,73,40,118,10,18,222,171,43,231,169,211,149,179,250,145,227,129,66,53,2,35,228,99,7,1,101,161,122,247,98,103,47,32,194,21,66,228,215,171,211,95,93,47,71,164,197,154,72,46,73,190,186,131,152,104,252,1,237,94,154,240,6,67,188,57,183,3,28,30,181,14,142,247,193,242,88,231,188,86,198,130,125,97,9,115,137,196,6,38,94,170,51,157,253,197,152,195,181,150,253,125,49,6,217,29,102,120,252,248,217,191,232,176,151,7,118,12,126,164,219,67,123,72,16,146,223,203,183,0,196,87,186,185,173,67,246,204,171,20,21,86,98,182,253,7,186,6,120,189,118,3,229,237,60,53,90,120,139,87,229,79,153,85,139,16,81,100,189,150,202,125,164,42,132,10,163,190,85,177,69,169,181,85,186,64,77,182,99,209,185,183,19,5,1,24,167,247,211,71,7,154,124,136,40,199,61,196,217,202,170,170,93,64,20,178,234,247,41,59,124,192,158,211,128,28,144,37,95,61,108,113,150,27,161,102,97,250,86,162,10,193,27,201,55,193,56,84,164,176,59,172,180,2,117,209,83,226,255,156,104,115,80,9,171,177,196,38,252,19,138,252,29,242,231,74,93,205,161,41,158,79,204,211,0,30,248,42,125,237,167,151,3,163,35,219,102,225,38,80,160,246,91,202,15,81,5,104,108,210,239,193,131,146,27,150,17,171,71,221,84,112,204,146,94,186,237,255,206,118,141,107,20,169,226,15,43,75,224,52,120,186,0,134,235,166,30,237,98,31,139,146,29,104,64,56,3,249,66,92,147,217,211,9,31,96,178,69,148,227,230,101,236,243,45,246,172,39,229,59,69,106,63,147,212,148,179,217,10,220,19,61,36,147,54,173,248,250,238,79,181,163,211,105,11,79,136,249,56,91,202,219,147,180,212,42,140,52,110,222,216,92,215,61,213,55,188,33,239,190,201,255,96,1,215,85,244,86,49,152,17,180,172,68,196,115,71,107,182,243,219,136,48,23,116,210,242,8,233,123,235,101,169,61,55,63,1,51,205,161,189,96,59,52,218,197,250,26,88,73,52,217,104,199,216,234,189,209,12,232,29,210,128,20,244,127,219,15,204,123,222,84,167,249,54,43,174,28,118,186,210,116,176,58,78,38,166,130,144,219,92,43,91,180,1,195,20,39,139,0,25,240,204,75,61,178,95,199,10,3,136,139,50,249,155,86,95,70,214,41,166,76,132,6,166,146,35,118,145,100,203,149,154,211,215,94,104,5,44,83,183,45,251,89,212,57,197,144,82,87,170,120,45,105,80,129,100,131,159,10,127,221,163,246,63,192,154,53,205,6,127,117,223,24,147,216,93,28,239,163,214,221,158,12,149,255,83,88,41,136,165,138,1,254,6,44,25,143,22,104,150,94,24,196,25,238,193,216,170,71,103,76,33,52,211,45,205,235,134,41,248,86,65,9,32,255,32,95,30,250,243,251,43,119,170,184,85,107,38,21,98,231,54,218,226,16,72,174,6,221,38,211,120,221,119,117,120,67,209,251,33,84,155,163,163,47,53,96,15,51,76,204,87,153,85,170,54,66,113,12,174,34,104,136,90,62,76,103,210,150,82,37,200,148,44,89,113,229,33,173,240,114,61,21,131,193,157,216,181,193,207,219,29,42,99,21,186,158,11,145,155,4,216,22,244,162,245,120,63,128,57,117,241,213,60,251,251,149,87,153,99,63,22,75,81,103,103,239,199,225,110,110,88,38,125,240,116,161,226,53,38,183,2,223,68,221,87,205,73,201,187,129,82,39,35,166,109,116,96,250,15,15,242,104,227,86,21,140,48,172,188,54,214,185,33,4,199,217,220,218,185,44,244,170,133,64,135,231,135,80,159,130,65,112,36,250,209,241,226,74,174,130,199,202,217,218,87,161,162,130,254,242,150,34,63,117,178,224,76,211,80,201,111,72,69,137,93,62,24,23,249,115,80,83,95,17,166,84,223,132,120,6,53,34,199,208,205,80,109,133,213,92,49,18,214,230,123,245,73,80,228,94,106,241,165,216,84,255,96,177,178,90,92,5,219,185,153,238,208,136,79,150,15,232,139,179,52,146,235,158,62,239,136,154,45,92,190,176,19,91,40,214,152,149,209,222,247,97,175,74,250,98,231,204,211,233,2,168,136,18,202,254,144,196,95,80,187,220,123,31,164,176,207,23,248,81,3,174,138,206,65,83,36,29,70,32,71,21,227,157,254,228,2,4,215,71,27,252,9,219,49,49,23,248,163,43,170,192,126,75,198,97,91,38,182,93,204,141,250,187,145,128,158,103,88,73,178,191,233,253,231,3,169,38,117,163,181,44,217,91,138,15,239,82,140,19,78,13,168,212,227,46,202,225,130,28,150,211,105,239,25,243,208,76,174,52,37,170,87,125,141,221,90,95,41,51,53,205,112,75,54,129,102,51,87,222,28,117,188,154,174,103,66,55,95,247,97,127,31,107,22,117,195,115,97,108,19,52,70,179,212,190,15,8,213,49,139,119,170,201,169,8,199,203,166,183,90,134,185,169,133,135,9,251,66,104,187,220,182,164,82,21,125,132,197,116,14,169,241,211,104,107,169,17,246,140,46,235,236,23,84,93,180,72,214,10,39,185,197,170,73,30,43,35,75,114,202,126,143,2,127,114,206,107,25,116,183,11,43,3,146,183,121,214,79,26,240,70,203,45,88,74,11,137,245,21,38,44,66,143,61,168,69,76,204,92,186,121,203,15,46,213,237,131,23,220,68,52,188,111,185,48,81,35,208,159,218,44,76,71,236,152,61,103,92,247,136,123,88,196,109,213,91,97,190,88,164,237,171,59,217,231,230,51,149,191,114,162,41,91,249,249,25,109,183,231,25,48,30,35,44,156,199,26,146,144,26,85,40,82,54,83,253,102,88,29,52,114,160,176,0,95,4,217,205,123,143,97,62,149,15,178,195,166,156,183,183,170,183,54,232,197,211,241,7,215,241,86,159,151,161,98,116,91,139,14,111,22,41,155,5,43,72,245,246,20,196,27,62,112,149,21,253,42,111,173,148,25,42,199,41,53,84,169,17,246,92,25,211,161,41,159,252,62,243,4,19,121,43,66,199,74,28,208,193,205,33,126,84,173,30,16,26,179,244,95,188,90,6,16,178,251,191,203,121,130,161,12,52,170,24,14,141,2,163,190,6,52,205,187,57,245,252,9,53,65,132,246,126,90,3,26,54,238,222,74,237,35,163,214,83,43,254,139,112,244,74,15,241,20,255,217,117,129,81,233,181,187,160,29,30,245,145,199,163,29,171,87,228,222,50,229,60,139,23,152,179,33,23,124,180,100,223,209,21,191,93,240,166,209,66,67,28,158,237,190,62,80,188,131,151,72,22,159,212,121,139,49,254,184,106,134,122,77,103,165,81,70,69,174,0,7,179,26,152,234,23,37,155,212,120,59,223,226,216,189,170,9,42,206,10,123,140,130,214,229,149,218,74,215,152,151,235,170,53,33,209,190,193,105,61,182,108,226,176,32,213,78,117,106,23,56,121,61,82,213,107,121,107,114,185,20,99,151,57,44,105,153,238,174,24,192,241,254,251,80,193,143,221,0,58,227,109,190,129,185,22,131,37,221,129,34,101,144,152,33,250,198,183,73,236,69,174,215,68,64,181,94,33,132,40,149,248,252,133,191,99,245,130,21,43,49,211,224,204,33,169,240,230,120,107,228,46,140,168,241,32,17,95,48,147,101,16,176,251,83,160,253,105,171,56,79,198,139,36,48,144,120,99,236,171,235,56,117,196,171,178,244,170,61,79,183,32,202,66,50,130,211,99,78,199,73,255,242,30,138,199,156,129,107,187,182,255,144,201,230,138,199,111,154,10,126,232,144,99,117,187,160,97,221,177,191,5,239,139,181,240,32,249,247,61,216,207,154,217,224,246,49,118,3,194,107,197,233,3,242,99,182,58,45,151,176,238,101,118,57,44,123,195,112,61,129,140,199,98,25,86,104,2,141,220,161,128,109,32,8,89,147,249,11,246,14,255,195,81,233,46,89,37,122,225,211,69,132,120,138,169,254,0,72,208,116,247,244,60,55,28,135,15,11,28,174,65,40,253,148,181,6,57,220,134,224,205,255,225,22,228,49,200,228,182,179,141,237,217,9,47,114,203,57,24,173,236,15,100,174,120,178,73,84,236,141,45,188,142,252,66,85,56,248,161,247,21,240,209,145,198,24,158,227,106,158,18,248,204,21,1,99,35,91,187,157,228,98,106,35,231,158,103,53,119,135,62,168,207,48,5,118,236,117,255,204,65,60,49,102,180,55,82,149,17,205,214,182,198,223,77,55,234,99,156,29,161,90,22,138,7,126,240,213,226,110,63,214,97,71,161,203,216,10,31,25,62,71,223,163,238,97,14,115,144,121,112,103,4,186,16,66,51,105,110,65,111,32,206,82,213,231,74,107,199,255,85,48,249,19,123,45,142,3,104,77,86,181,99,8,158,50,3,108,43,23,113,246,189,180,107,134,24,9,137,36,178,9,176,197,63,33,63,164,220,217,243,175,16,197,210,28,16,109,192,143,193,240,252,44,124,8,108,179,168,171,135,107,32,216,49,136,123,109,133,33,176,167,185,189,30,120,210,5,211,14,127,118,199,147,121,246,58,33,239,172,251,87,223,152,144,13,169,216,65,87,59,132,210,118,116,30,68,72,68,155,103,230,81,33,26,21,82,14,73,251,183,147,86,222,194,97,44,169,244,82,155,95,253,205,116,91,165,44,64,31,163,242,253,93,23,26,209,14,33,97,62,148,115,63,247,111,137,13,9,163,215,243,223,218,10,114,82,195,219,233,24,117,167,173,231,13,156,77,46,231,130,200,122,169,91,49,229,215,250,140,73,229,240,44,212,41,117,112,31,126,218,196,58,241,101,147,26,195,148,98,153,198,104,87,90,149,128,60,239,177,50,49,11,242,239,230,196,182,89,101,80,215,168,143,70,48,53,53,215,22,99,194,129,245,128,163,40,102,25,14,99,189,152,35,135,13,16,105,137,188,32,226,246,176,38,30,36,65,146,145,240,83,103,2,107,133,21,172,41,239,28,250,134,170,228,80,43,122,211,87,111,228,168,29,171,79,69,62,152,18,69,203,96,169,144,83,50,37,65,208,1,113,46,2,67,73,221,2,181,73,185,209,20,163,237,141,222,221,69,220,155,12,177,239,150,84,234,58,111,225,3,31,187,110,139,78,139,234,186,202,73,72,34,125,59,43,206,220,68,6,49,123,14,147,144,206,60,95,31,173,236,244,239,64,11,119,89,226,7,117,175,218,115,104,165,195,209,202,140,132,15,6,115,213,209,69,238,7,89,37,249,156,158,67,124,208,100,194,232,148,52,214,125,166,99,224,152,46,109,187,234,230,51,60,189,191,120,28,13,67,152,105,230,40,147,153,215,16,149,231,51,170,159,88,97,228,216,161,34,87,65,129,153,213,186,140,150,104,113,164,25,120,246,58,78,221,124,33,179,135,7,220,233,68,9,15,123,101,187,131,139,95,177,234,29,215,24,57,107,53,194,252,161,247,70,224,245,22,104,10,41,39,213,190,186,249,159,32,28,196,55,153,225,205,18,72,227,70,120,101,199,237,132,225,10,124,88,154,151,215,153,67,177,100,244,99,169,37,127,97,122,188,216,217,79,187,227,87,69,243,42,139,151,228,79,141,154,88,240,7,29,255,165,129,150,70,173,212,207,194,245,243,54,210,111,168,77,71,140,61,28,64,106,8,196,60,68,154,18,110,22,252,63,172,163,34,138,138,105,145,101,244,110,11,75,95,244,220,224,140,191,243,85,79,137,128,246,173,146,28,1,68,146,131,190,104,107,105,10,183,141,149,204,59,176,190,91,3,180,254,33,47,24,58,4,53,177,211,193,103,6,161,57,156,191,177,108,76,83,185,133,20,167,103,26,75,148,54,239,124,182,71,95,160,157,60,112,22,149,136,53,82,150,241,250,192,35,199,124,207,79,66,84,131,7,63,140,114,16,166,158,30,0,73,131,202,144,116,46,50,92,60,23,147,147,14,236,195,64,128,205,63,248,146,1,49,182,30,96,166,149,196,243,131,88,93,119,167,118,22,137,56,179,169,223,194,48,235,4,196,19,7,210,55,75,235,92,247,15,83,174,53,132,172,34,214,91,205,147,70,34,195,103,132,175,68,245,7,227,205,122,160,7,72,137,123,51,243,8,7,82,113,179,53,171,249,151,156,75,82,204,101,194,53,247,2,201,39,125,151,8,4,189,190,40,95,41,72,181,116,99,58,100,136,118,164,13,191,107,164,69,39,229,204,2,248,254,87,112,64,247,106,105,66,193,73,104,67,75,181,248,105,39,227,153,139,164,41,215,76,244,118,95,99,56,13,94,20,67,33,205,238,108,249,81,105,60,177,18,155,229,73,173,205,78,164,144,180,161,191,210,203,150,190,16,55,228,110,203,212,118,15,103,25,67,152,199,2,36,17,117,201,129,88,197,112,153,188,44,58,196,160,131,198,150,19,223,209,224,90,127,231,71,1,40,82,195,12,242,223,233,211,68,210,32,176,1,106,119,179,211,33,221,107,210,194,227,213,88,3,122,19,130,145,199,16,66,179,41,215,40,18,133,40,191,25,49,31,101,27,16,11,60,119,20,186,217,168,204,250,28,173,159,38,166,106,2,35,49,133,30,16,174,41,134,5,154,247,72,247,171,23,225,89,228,141,14,221,122,56,188,54,252,90,121,252,169,8,168,27,59,138,8,245,70,122,230,65,165,140,117,136,206,11,169,209,146,240,8,234,87,27,21,119,136,227,84,138,65,172,42,227,109,202,167,67,219,148,125,32,179,242,176,224,42,235,163,145,195,63,145,122,135,21,164,85,133,249,38,87,145,90,3,151,203,189,99,172,189,248,86,207,193,226,138,44,42,179,190,99,83,127,92,185,32,159,58,246,239,241,246,235,227,205,219,169,42,77,149,0,212,210,172,47,174,68,122,133,7,78,152,86,30,65,58,84,65,40,113,125,213,150,112,146,1,46,218,175,242,206,243,3,22,233,246,135,129,96,57,130,15,151,104,91,220,169,42,107,34,44,14,229,23,97,55,219,134,96,213,252,133,227,120,195,1,46,17,86,212,120,130,91,248,166,233,51,66,254,106,183,117,42,44,36,169,196,204,173,91,96,109,228,171,28,189,45,250,183,121,167,12,164,164,245,225,177,164,170,138,139,161,93,90,83,85,26,198,104,106,203,108,131,144,196,153,22,188,229,99,101,228,68,84,115,35,112,19,129,18,184,189,228,220,191,206,106,106,126,188,176,42,150,208,166,249,215,76,49,78,167,49,137,16,206,210,203,31,206,130,158,233,143,12,168,123,152,246,181,110,5,9,143,33,8,20,72,188,117,52,80,18,200,90,101,236,228,207,56,241,5,217,53,40,86,180,67,214,216,113,227,232,42,4,123,161,29,225,131,69,60,164,193,158,200,54,177,14,32,137,153,25,110,144,200,246,156,194,61,16,88,79,24,113,181,5,133,88,82,165,176,38,251,156,45,231,111,141,37,120,107,195,254,51,23,243,143,18,30,92,222,216,31,27,168,49,204,158,75,50,29,108,173,189,227,162,147,5,233,159,187,189,71,11,14,221,15,68,223,60,234,186,227,182,193,229,131,242,98,115,34,126,30,59,20,56,101,249,9,38,148,110,79,181,179,181,29,240,61,110,204,161,242,160,184,30,38,49,180,136,78,22,156,1,249,192,217,132,67,3,250,243,132,141,231,10,84,231,97,122,73,28,88,116,105,213,193,202,47,183,216,19,80,71,55,14,123,32,194,193,121,208,234,113,73,234,146,93,189,196,164,129,140,201,122,187,60,67,10,121,125,17,246,192,134,16,58,220,3,66,88,63,127,197,206,164,85,151,11,143,43,109,35,215,25,113,90,99,90,205,22,209,122,41,112,244,206,253,59,161,241,168,251,89,190,186,151,193,3,142,219,1,102,68,147,87,145,74,157,223,203,18,248,51,21,219,92,9,251,196,149,82,153,103,27,151,252,54,21,4,47,205,56,172,183,3,29,202,225,83,16,70,15,21,227,219,225,178,248,157,53,135,57,185,163,37,123,167,126,80,187,41,181,17,191,207,228,71,37,158,205,118,62,248,250,194,59,71,214,167,103,233,25,73,205,178,231,128,78,53,113,28,73,140,86,87,88,87,238,196,137,77,234,138,39,195,39,117,89,71,3,123,115,108,182,175,148,180,142,193,159,155,141,71,168,172,98,136,187,112,36,25,146,98,217,160,17,34,77,55,98,189,208,173,74,117,181,200,124,182,123,12,56,62,149,214,75,112,112,107,126,242,224,85,234,235,172,131,250,233,229,99,14,92,194,36,21,156,167,172,215,243,141,214,57,79,177,104,94,207,160,8,3,102,237,50,84,126,223,147,92,211,221,196,52,130,24,176,159,132,65,156,131,71,126,4,33,143,91,104,28,50,153,209,95,181,28,75,113,70,67,27,109,192,39,174,135,252,172,218,211,94,160,62,199,154,79,251,16,22,195,15,22,140,253,36,242,85,72,147,22,121,33,25,195,83,123,67,179,160,66,85,146,45,114,228,93,116,57,55,217,212,216,31,50,167,229,242,19,107,240,57,124,255,142,191,249,148,74,39,163,43,156,151,201,207,220,46,185,27,203,141,137,15,92,5,101,198,159,181,2,84,128,42,9,10,185,221,175,55,128,247,131,98,98,146,152,8,240,110,121,15,67,233,2,21,145,83,105,182,127,239,100,153,185,165,225,124,59,119,26,175,192,81,4,98,42,93,184,200,34,68,13,134,123,5,43,164,167,218,32,67,79,70,4,196,254,131,50,201,157,133,80,79,208,242,155,224,237,252,110,27,249,238,45,235,77,229,182,93,205,123,32,5,3,78,154,69,213,117,216,130,198,46,105,47,78,76,255,250,230,254,99,106,218,110,21,186,185,71,173,236,91,67,119,59,38,141,202,223,39,183,153,239,2,113,168,121,123,54,217,55,237,94,11,1,190,38,16,170,216,147,239,88,254,229,245,220,108,102,247,55,229,237,173,167,179,231,185,82,226,109,53,81,87,15,55,217,69,204,109,3,164,126,143,193,42,141,227,90,36,226,83,128,215,12,177,216,190,140,85,129,225,224,25,74,141,225,41,192,131,60,180,130,169,191,124,58,1,135,224,63,27,9,138,244,124,167,199,35,2,120,62,25,218,238,78,254,29,125,60,19,72,168,31,194,52,28,70,137,193,242,203,2,91,43,138,248,5,135,204,165,116,67,10,198,121,98,100,238,143,43,94,209,39,162,232,129,176,41,254,158,40,195,167,51,206,48,151,123,55,64,65,233,220,176,238,73,3,129,139,129,242,194,88,95,199,147,187,75,237,229,171,30,89,115,154,239,165,169,235,59,98,63,177,91,115,84,142,203,97,103,79,66,2,91,157,207,14,45,246,75,211,46,69,228,42,158,158,132,228,178,36,163,98,194,69,11,37,186,217,155,206,244,54,125,9,122,128,237,37,159,232,91,68,159,92,116,153,244,199,136,214,88,171,186,117,98,60,171,163,232,45,147,151,123,170,237,130,250,83,244,253,125,237,248,178,237,111,15,63,154,122,147,51,15,60,204,111,139,245,231,228,185,51,36,176,237,79,48,4,150,130,163,59,120,29,126,54,40,104,116,142,238,121,237,189,107,191,35,8,119,113,131,109,108,173,24,9,142,108,8,49,51,202,146,192,173,17,1,241,218,187,124,164,246,139,220,70,143,192,138,152,227,175,189,77,209,86,106,63,119,2,159,194,2,163,89,30,119,83,127,152,98,60,123,145,96,155,67,36,124,94,20,93,243,98,219,253,143,238,124,45,39,226,10,242,116,227,184,129,242,21,192,51,94,97,231,64,148,237,211,59,177,198,10,216,238,62,4,109,230,168,9,132,240,215,0,86,29,251,174,78,233,243,27,50,92,197,253,214,2,123,146,246,222,140,146,148,108,237,15,4,222,247,156,154,132,10,40,151,8,10,70,114,132,181,145,136,176,233,7,169,57,111,204,90,220,67,215,132,40,150,216,152,69,54,80,43,171,67,46,100,140,33,185,115,58,154,35,242,247,6,43,31,174,39,80,101,216,73,40,132,227,201,14,85,37,194,50,3,146,118,78,76,36,211,88,24,220,98,14,33,120,148,222,160,20,160,118,195,167,167,92,128,37,5,53,38,72,206,146,123,57,213,135,200,109,71,35,239,160,169,225,222,136,217,153,92,67,165,51,105,189,47,203,155,237,217,9,216,232,29,225,177,49,205,230,232,177,124,66,19,114,207,198,114,64,45,161,124,66,110,85,157,81,102,32,22,83,53,111,196,27,133,196,169,162,223,120,126,235,105,163,132,221,206,150,110,214,226,227,26,172,30,160,193,251,235,130,209,125,165,77,58,39,115,187,196,165,24,148,33,237,15,73,76,51,191,88,212,165,137,89,220,47,35,108,174,114,48,214,113,39,163,180,185,63,88,233,112,0,120,241,137,168,24,63,138,54,82,207,177,179,66,101,46,177,222,3,52,49,103,68,5,246,78,182,234,55,35,29,9,19,192,144,78,132,224,162,148,96,89,62,61,109,6,178,98,241,196,88,167,22,196,56,11,139,35,94,112,213,134,206,158,24,179,145,144,24,250,44,149,253,67,210,8,0,244,166,243,0,180,234,155,46,191,122,41,93,142,70,154,56,201,66,159,207,162,193,63,26,46,204,221,206,29,100,232,161,225,87,106,130,47,154,66,253,50,33,4,103,71,134,239,65,137,220,222,90,200,221,145,253,16,73,125,66,213,113,239,82,209,96,85,98,196,87,143,30,250,24,217,92,120,23,123,71,64,51,243,204,192,239,147,75,30,170,32,161,187,95,176,78,235,9,173,103,112,9,93,39,55,89,66,223,135,55,158,58,28,249,4,53,46,175,138,48,65,135,70,136,1,162,20,77,236,103,41,150,88,60,162,162,221,75,62,108,114,118,100,40,120,101,241,122,160,0,109,225,54,161,239,188,6,149,136,139,198,177,179,32,43,126,52,149,57,217,226,136,215,201,55,32,213,229,87,28,109,36,223,42,151,98,71,107,140,255,230,206,183,84,127,109,108,57,226,37,11,140,188,250,216,82,32,241,186,122,68,173,128,81,29,57,2,23,81,10,233,198,238,113,91,11,7,17,184,180,159,230,116,147,143,120,21,24,1,220,118,49,16,80,204,12,78,41,111,117,193,98,56,148,193,219,160,156,230,56,126,1,172,183,95,204,229,202,75,218,108,245,33,254,8,58,127,98,209,197,176,100,60,110,139,133,80,43,42,133,200,12,216,121,186,89,171,171,252,220,132,121,46,180,75,79,8,157,91,112,112,34,247,193,147,132,119,236,30,223,101,129,132,197,45,134,84,202,92,249,70,208,211,158,206,209,216,202,106,106,96,1,80,249,182,103,247,124,85,169,42,212,67,245,112,214,156,147,143,216,186,202,197,119,5,230,23,226,199,79,150,253,252,85,1,193,145,96,212,15,165,73,246,244,50,249,165,95,254,252,112,62,100,237,167,234,181,238,164,135,224,175,19,225,82,153,135,122,209,81,59,123,165,21,127,99,54,56,18,153,226,205,161,95,202,7,79,126,124,92,208,244,46,5,176,227,206,200,16,140,97,250,131,187,54,34,117,52,52,206,150,201,200,182,45,201,225,80,46,100,113,199,193,12,116,224,253,59,85,244,248,161,239,199,164,208,63,114,103,163,167,185,246,203,19,33,102,53,236,108,3,205,170,155,230,73,204,142,178,233,7,187,171,191,137,254,60,149,218,98,40,42,87,10,3,146,207,162,67,113,25,173,141,27,217,143,225,97,164,2,208,116,57,181,180,112,233,183,114,62,110,197,29,79,155,213,7,115,94,60,229,43,83,79,119,171,196,20,78,239,233,51,87,6,32,5,59,166,121,176,193,0,2,145,150,183,130,7,36,179,159,57,212,66,179,111,151,174,27,202,58,35,12,121,174,29,17,69,244,46,87,1,173,238,194,40,107,180,147,157,209,184,241,104,251,123,242,164,42,31,93,118,82,79,189,47,105,102,158,30,210,164,16,47,140,226,212,235,70,176,78,30,247,193,162,137,19,102,181,9,248,156,29,149,41,73,2,34,88,183,198,106,254,34,124,19,150,32,99,71,253,14,190,121,107,200,168,38,114,205,153,112,139,204,16,149,101,168,127,70,40,156,157,78,179,113,220,4,46,194,124,96,187,139,83,36,28,169,50,209,88,176,134,217,219,55,18,186,165,170,11,175,60,216,24,132,95,218,101,75,194,66,64,184,1,56,29,86,92,86,243,122,204,124,185,21,219,37,111,68,82,178,41,69,127,186,121,223,219,84,41,169,105,54,165,5,128,102,12,67,130,217,46,97,233,254,216,57,121,145,39,46,34,136,82,175,114,153,215,16,119,138,116,45,137,136,230,59,132,221,97,0,150,250,153,211,18,141,254,212,157,9,45,217,191,16,24,133,130,194,151,189,230,92,187,55,12,247,187,8,115,13,29,222,207,59,92,230,24,146,39,165,2,54,188,107,162,190,178,185,22,188,187,172,42,164,239,225,92,55,26,237,230,59,0,75,13,33,47,250,12,161,72,4,185,159,244,163,208,129,102,176,239,178,99,211,97,92,241,234,19,85,70,42,189,55,130,151,119,38,50,126,239,231,40,153,124,51,220,63,234,208,163,211,170,63,37,231,40,152,183,204,90,227,246,208,8,196,85,209,243,92,102,174,199,27,110,145,27,1,158,35,176,107,152,163,227,75,21,184,120,238,57,155,201,3,194,165,57,117,211,136,236,17,128,98,177,93,111,46,94,137,155,5,70,101,212,42,190,79,218,62,143,123,151,171,59,185,175,9,185,245,254,235,130,177,69,252,61,157,29,229,105,128,229,192,180,37,158,214,254,13,129,64,53,209,247,56,140,241,97,250,119,174,250,204,68,97,184,208,29,20,117,25,12,105,234,224,76,223,115,197,177,7,235,247,19,42,20,85,78,15,81,181,192,153,4,160,176,82,106,67,212,194,132,240,190,45,126,79,192,122,42,28,239,165,14,139,14,152,62,129,78,48,66,45,207,97,240,165,178,129,234,169,234,59,12,218,46,249,54,76,20,225,254,11,128,237,242,61,101,16,36,207,202,13,244,205,77,104,204,51,50,1,5,95,211,151,110,251,255,185,191,151,167,102,140,98,163,129,27,38,60,101,197,176,252,212,232,136,208,157,118,51,83,111,209,188,223,78,130,47,24,91,236,170,159,121,55,3,202,0,155,212,180,173,74,37,161,201,91,108,166,174,27,239,60,20,65,158,225,185,85,89,127,76,244,27,86,150,160,201,13,106,79,143,68,200,236,55,107,243,76,149,215,188,118,183,198,159,26,140,136,153,211,173,159,16,57,139,31,93,149,70,6,141,53,112,164,6,184,239,106,159,222,67,158,26,121,136,223,39,46,140,67,170,202,95,88,179,214,186,212,140,8,12,94,34,77,226,17,17,162,210,225,20,151,177,74,9,100,126,170,73,142,33,144,154,131,151,205,235,28,118,190,6,137,98,50,237,7,94,230,246,133,250,179,160,199,89,103,9,203,111,37,216,185,171,40,117,6,107,87,133,165,172,22,140,220,186,41,97,187,57,196,102,220,15,169,194,254,170,33,237,69,78,127,4,30,119,51,251,153,50,179,106,153,232,131,96,100,243,32,78,78,223,191,150,158,39,30,201,43,12,220,233,103,223,247,156,210,213,52,75,203,102,114,46,35,81,55,175,89,207,53,66,198,247,164,132,51,64,124,120,125,108,35,3,184,185,202,162,122,93,58,198,11,176,146,221,62,6,92,250,135,230,38,135,125,76,89,22,140,243,110,14,212,252,94,85,234,86,142,168,158,28,94,124,183,180,213,174,80,170,142,88,83,48,201,169,249,109,156,83,4,161,186,46,235,85,83,86,244,7,52,58,188,19,124,117,35,105,13,185,191,47,252,142,77,194,147,27,235,193,126,138,65,32,134,118,24,227,33,219,142,48,59,235,147,8,183,94,74,184,233,4,78,44,55,20,167,190,216,145,187,105,253,135,93,68,15,204,76,81,176,255,140,229,106,248,29,154,109,79,247,240,181,62,181,2,28,187,26,136,254,180,92,158,140,81,194,11,245,237,48,28,57,112,87,48,233,185,13,251,113,29,199,152,222,226,254,232,119,199,120,251,113,224,226,89,162,215,74,115,227,118,145,197,176,156,161,226,233,79,170,203,163,113,106,144,108,25,85,163,91,129,143,75,216,56,51,156,13,106,116,79,121,79,152,139,128,156,169,174,94,228,172,49,115,235,134,42,145,67,107,214,122,8,49,156,210,218,178,151,67,247,169,0,56,164,44,222,132,125,193,90,153,10,15,29,69,159,229,98,193,181,138,65,215,14,65,89,116,209,247,174,22,72,27,141,214,94,36,169,203,34,123,25,192,248,196,238,148,225,225,253,59,44,43,96,2,26,21,96,123,202,184,253,55,162,172,81,29,95,172,11,133,235,129,224,183,94,71,85,29,23,65,246,242,222,224,109,136,62,63,145,107,248,167,160,195,242,204,135,237,253,107,53,91,77,34,207,186,102,102,84,28,14,44,194,39,232,156,245,132,232,76,102,63,206,240,49,132,118,211,1,70,75,30,42,3,149,207,174,223,160,227,64,221,207,62,64,74,186,97,163,201,85,231,33,84,76,132,47,66,189,73,137,21,77,184,234,168,231,171,247,76,32,229,1,138,186,116,5,60,65,8,57,133,57,165,125,190,51,105,242,89,1,141,234,53,168,34,89,88,55,63,52,10,226,116,30,115,175,214,74,234,133,248,48,242,17,47,155,75,131,130,124,207,192,199,156,142,142,119,122,3,15,49,119,155,82,80,171,180,19,29,133,31,247,222,9,245,206,244,22,69,12,85,112,250,23,97,212,191,32,152,5,115,206,31,197,19,250,138,219,130,3,84,216,78,11,80,213,13,161,199,128,136,64,7,53,223,221,247,108,10,139,128,47,36,225,149,145,94,106,22,86,14,62,13,43,181,226,188,243,228,218,231,144,137,51,46,13,237,21,72,193,233,132,28,220,20,8,4,122,72,237,253,246,222,239,176,0,105,79,66,248,100,211,232,18,217,109,127,11,57,83,34,123,20,60,137,153,193,152,195,96,127,130,205,193,250,201,146,44,174,91,40,108,105,104,231,248,136,114,61,136,124,241,31,128,186,165,230,218,248,76,54,35,51,13,80,241,46,59,34,214,111,253,168,149,252,124,4,81,171,131,110,58,165,172,223,166,5,45,240,154,11,195,26,117,137,238,192,41,98,219,74,113,235,25,234,46,9,144,57,228,196,138,122,230,73,229,42,31,24,18,166,217,131,24,95,177,251,18,240,249,10,235,122,112,16,73,162,6,70,8,231,108,54,87,216,194,174,60,128,244,234,190,212,213,146,128,244,187,133,74,29,128,195,60,234,120,57,168,116,97,234,156,164,173,42,225,70,177,38,184,43,121,148,186,19,207,224,19,253,214,102,184,227,77,205,223,63,242,184,142,75,134,48,96,96,243,151,83,50,87,123,186,147,177,176,62,113,237,99,50,108,201,126,185,218,219,219,241,171,55,44,28,194,49,254,72,63,140,63,178,112,216,15,3,183,189,172,230,154,116,254,246,200,73,82,76,41,15,168,132,147,25,115,46,90,151,15,180,193,60,237,178,105,74,47,191,86,59,221,105,248,98,26,140,49,149,76,146,83,229,173,71,134,78,113,171,186,136,69,240,102,228,167,251,86,198,107,167,79,180,215,210,44,58,98,143,79,188,44,133,107,54,248,165,231,104,149,127,120,62,61,159,252,239,41,101,177,140,108,77,90,49,230,151,125,115,153,80,213,191,17,98,59,202,149,108,239,233,23,177,26,245,216,97,198,111,31,75,248,67,177,55,207,157,212,233,20,69,111,167,232,80,21,144,9,32,199,43,200,181,141,195,9,143,237,154,121,175,158,247,124,39,117,184,48,30,51,103,4,19,16,28,84,98,72,251,204,19,32,194,90,236,170,52,202,181,96,92,120,59,184,47,169,66,177,66,217,150,2,50,182,17,7,131,32,76,227,116,70,174,42,90,163,89,35,33,148,41,240,228,253,31,107,201,210,198,152,13,86,70,112,248,225,121,155,252,134,99,239,2,8,98,108,44,76,227,160,213,104,141,16,130,205,118,253,123,220,48,200,187,80,35,114,62,45,188,107,29,79,220,169,244,147,158,70,102,122,231,232,149,243,55,230,115,28,185,83,39,179,237,221,41,170,240,44,143,39,216,163,87,213,39,157,118,225,99,80,190,57,171,200,20,2,7,166,112,211,127,0,69,167,84,159,62,190,37,46,1,194,192,152,94,188,50,203,38,220,128,2,108,156,32,255,174,254,89,135,44,97,26,237,37,203,70,32,238,3,218,163,213,145,32,244,50,67,233,217,30,131,135,205,0,46,29,143,192,99,180,144,34,96,7,74,212,164,44,215,190,88,252,138,84,97,50,251,203,44,252,175,247,178,155,79,180,28,8,80,184,205,211,9,119,150,32,91,150,4,102,212,89,217,117,71,241,163,146,90,113,142,34,228,139,182,236,101,97,47,152,88,91,161,47,37,246,4,92,89,174,210,15,82,44,118,249,82,198,192,155,172,220,91,168,190,233,35,204,84,24,113,139,102,112,42,108,124,19,27,148,60,159,78,38,239,90,234,5,193,172,28,58,20,182,11,43,162,123,82,184,178,167,19,172,101,106,3,69,146,204,136,46,70,35,133,166,103,74,245,222,246,76,109,232,173,160,36,50,39,140,112,227,59,10,18,127,30,232,161,113,146,233,102,248,171,205,245,154,98,101,53,109,65,36,82,31,241,200,111,216,27,255,10,48,237,213,82,221,17,250,248,215,19,150,56,175,233,19,230,30,233,199,3,100,121,176,189,175,63,20,231,105,113,121,51,88,188,231,109,177,58,34,9,199,121,226,157,183,76,219,41,224,204,61,144,124,88,115,7,214,74,179,178,42,119,144,76,98,58,171,185,134,98,123,177,87,100,213,183,165,147,22,29,151,19,74,146,102,107,158,201,189,0,79,185,36,105,84,104,73,152,103,132,228,196,39,102,113,158,255,56,212,198,37,172,139,31,238,98,184,182,42,69,108,194,245,23,205,45,21,76,115,162,181,174,59,213,233,59,240,184,32,212,226,199,126,11,205,232,217,187,51,197,98,94,117,94,105,152,41,48,22,181,8,146,134,207,30,237,255,240,248,183,191,187,67,210,16,185,191,54,193,2,218,22,99,176,191,233,78,247,165,4,231,131,62,37,109,244,76,194,155,129,212,66,0,101,223,162,211,13,80,169,217,16,68,4,155,216,61,35,76,162,144,217,34,209,73,249,250,253,186,140,124,41,237,124,22,168,97,40,95,47,38,188,204,216,150,184,229,185,174,113,3,154,126,238,50,165,170,12,27,209,53,157,76,118,81,252,10,140,31,103,160,43,171,6,65,205,225,154,85,121,76,216,228,29,241,184,200,160,225,86,4,199,137,80,222,199,30,9,163,177,222,131,91,24,3,147,148,250,20,157,246,166,73,41,246,240,159,85,53,172,227,255,239,211,188,78,85,210,198,63,175,149,47,251,126,139,167,245,143,5,212,41,111,52,133,173,37,114,122,63,214,212,6,98,213,169,140,241,226,233,95,47,169,91,89,117,116,228,30,78,123,163,137,11,19,142,70,121,166,215,141,20,57,100,202,75,131,150,222,136,204,79,199,205,220,46,9,129,92,116,55,148,224,138,82,32,255,250,251,59,239,99,130,13,77,106,233,191,37,70,164,141,160,195,95,192,54,39,178,189,46,17,135,160,255,198,62,249,69,57,5,74,22,165,134,209,143,179,8,28,219,212,141,148,242,233,231,171,234,72,186,111,252,84,120,130,253,206,225,145,123,88,19,194,150,24,168,247,191,92,162,203,56,94,55,72,199,142,76,50,37,253,13,142,159,201,100,153,149,243,217,240,192,204,254,66,239,13,23,161,166,210,210,120,35,7,141,179,109,83,57,146,163,16,195,195,129,214,39,34,155,158,29,244,128,143,18,233,121,150,87,80,227,145,22,207,133,15,10,172,79,48,176,209,68,66,116,22,167,251,162,90,108,98,148,98,84,46,164,185,106,48,68,247,163,112,24,15,78,105,58,173,251,63,10,252,91,83,158,57,178,63,21,40,113,231,82,251,191,134,27,71,131,203,150,222,121,48,211,181,0,62,91,119,123,77,252,183,63,204,142,239,211,87,244,129,213,2,81,221,210,104,182,252,35,116,91,198,172,132,76,148,89,3,74,8,96,232,19,70,18,232,128,18,145,133,229,23,13,93,175,174,68,105,55,192,81,168,1,142,132,193,37,99,188,243,51,14,26,6,195,29,149,159,115,77,169,235,22,66,101,37,224,43,146,152,141,191,222,67,12,74,51,124,129,141,11,37,97,10,50,79,112,123,54,180,89,156,10,237,145,90,99,35,116,84,163,249,196,70,103,144,16,14,13,233,42,5,213,163,203,205,92,6,212,210,195,46,141,24,15,1,215,71,30,31,0,4,24,15,93,217,35,228,173,104,78,117,69,140,243,168,119,62,223,200,171,123,57,184,88,64,53,21,153,201,0,115,146,22,119,84,228,16,189,124,213,148,92,15,178,58,83,69,87,213,137,150,254,92,197,211,157,193,255,150,115,3,222,48,64,41,28,208,245,211,29,135,30,54,205,250,93,94,57,155,196,37,151,90,109,165,11,249,203,106,37,64,103,100,206,108,40,181,36,238,104,208,241,13,26,75,32,133,101,47,132,226,199,174,3,139,186,102,206,19,21,6,166,44,184,63,7,255,61,155,90,233,60,161,86,176,23,97,194,237,176,234,251,116,25,226,11,145,130,13,179,158,222,252,26,235,132,202,117,229,195,232,158,52,183,96,47,219,235,210,51,146,103,15,241,22,194,84,73,169,183,142,81,87,203,6,251,105,254,2,56,164,156,137,219,71,205,59,144,217,70,38,73,57,73,70,131,114,20,249,181,50,184,200,127,251,28,30,92,166,20,252,156,141,128,223,214,176,136,154,210,238,245,131,123,1,114,106,160,197,74,57,4,101,162,185,66,93,219,192,225,68,181,231,74,140,180,121,162,114,142,129,187,73,66,192,218,128,28,39,134,251,0,243,48,55,112,205,204,80,144,149,109,100,247,179,224,228,198,89,225,7,131,170,203,32,130,21,23,249,122,134,208,160,239,23,10,91,107,175,27,56,59,104,18,71,209,245,4,165,227,203,178,69,1,114,130,119,193,171,64,18,182,174,155,16,84,193,55,150,153,90,251,6,94,161,253,223,200,143,16,162,175,93,211,88,243,61,118,144,204,158,163,68,183,243,85,64,42,52,155,32,39,213,93,165,239,188,8,152,93,228,136,71,213,103,158,57,252,54,203,34,230,180,127,56,46,22,5,220,190,103,131,16,64,135,114,68,112,125,205,54,108,113,157,5,31,108,20,138,80,149,170,6,114,65,223,21,159,246,115,158,118,220,203,106,20,66,204,213,59,225,109,136,122,206,137,104,126,66,24,195,83,223,112,36,241,154,219,254,255,248,77,142,202,95,86,171,11,42,188,7,245,217,138,49,224,34,61,121,28,57,25,3,70,9,40,108,107,108,211,160,206,154,77,59,153,161,172,200,23,84,154,131,94,122,115,145,19,13,234,127,86,154,80,149,41,50,98,186,251,36,10,53,159,223,103,104,248,67,154,136,228,46,83,243,36,33,221,157,116,83,109,54,89,171,46,252,120,86,50,220,23,252,185,68,192,125,37,223,233,232,110,16,135,71,175,199,37,75,162,17,48,41,32,39,131,59,145,161,20,26,149,216,99,1,188,240,87,189,8,24,224,227,175,207,156,151,37,76,105,62,202,86,172,9,208,0,186,72,213,78,103,254,132,192,92,113,242,42,224,245,111,181,206,107,130,182,212,63,185,27,28,41,112,220,209,148,172,7,140,225,168,124,67,203,73,76,139,41,226,87,30,125,197,216,76,36,160,168,194,202,181,254,134,0,148,187,242,94,239,72,9,21,148,168,92,66,161,144,73,37,106,39,176,127,116,44,183,89,77,47,138,171,10,169,117,147,107,92,29,184,69,82,220,13,130,34,214,197,214,6,152,46,180,228,77,211,162,47,149,169,145,56,196,174,84,97,93,246,216,30,34,211,137,93,8,161,64,73,106,220,60,107,201,86,86,124,51,9,66,244,168,8,22,125,147,200,68,23,23,247,75,139,87,52,54,5,53,175,14,218,127,126,196,104,220,88,75,122,52,99,226,111,88,137,95,199,196,6,2,87,182,200,67,133,205,210,73,174,53,64,12,134,84,182,73,199,7,65,88,7,24,83,187,31,81,35,236,229,37,177,78,42,143,233,94,241,133,195,255,185,7,218,41,43,231,129,3,23,175,147,37,26,188,70,161,146,126,24,12,38,104,96,209,143,227,254,9,198,24,192,4,227,59,174,32,240,251,5,34,127,186,184,83,193,62,41,187,33,39,239,28,16,118,164,36,171,230,136,212,122,52,86,39,165,85,61,117,145,179,83,209,229,95,227,85,170,136,187,59,115,217,179,60,48,21,67,116,58,14,145,89,89,35,229,5,152,217,138,26,10,189,186,35,83,210,174,165,179,87,168,247,177,43,213,204,247,37,109,164,15,182,108,253,170,140,83,214,151,0,211,81,132,64,43,30,248,18,149,11,44,248,98,107,216,117,38,96,167,82,124,152,140,191,51,40,145,207,31,45,189,144,120,151,236,172,94,196,233,80,172,227,217,187,197,174,24,108,153,189,212,51,44,156,203,149,74,222,95,240,202,168,235,255,91,215,29,201,254,8,156,120,134,162,218,172,153,51,254,189,4,238,93,65,227,158,247,6,74,254,126,91,58,204,84,167,188,223,91,180,79,147,62,150,135,231,158,186,185,126,91,13,115,56,108,78,17,205,175,102,47,20,157,73,175,89,225,242,141,119,215,191,236,127,186,252,109,87,164,233,22,213,98,137,134,97,78,12,13,150,30,160,164,149,154,108,167,156,104,67,228,187,152,143,135,114,154,47,7,21,89,131,179,34,253,135,40,109,220,0,127,213,82,85,64,161,1,113,242,240,66,56,78,225,32,59,26,177,12,19,79,6,212,120,217,177,7,187,76,85,122,133,9,219,81,118,109,201,21,119,47,122,30,190,208,241,78,63,16,91,45,44,253,13,228,18,228,187,96,222,132,166,77,100,226,124,234,61,59,174,40,117,26,163,5,65,107,1,95,18,170,126,100,95,216,113,98,15,186,246,133,3,205,221,228,159,206,212,201,240,175,113,198,72,187,233,28,104,253,239,168,246,139,120,149,143,34,146,39,220,145,216,114,243,109,219,151,117,75,33,162,197,181,62,19,128,118,215,96,101,54,68,109,7,171,133,54,145,1,15,56,224,58,123,172,196,221,3,133,158,85,120,21,246,153,166,1,17,66,48,223,247,230,95,15,223,253,250,109,197,6,190,76,117,7,245,185,143,129,188,191,215,198,20,90,194,172,250,78,233,102,182,120,92,116,208,65,80,84,235,77,57,207,221,127,16,225,96,218,22,104,216,138,195,220,101,236,3,109,87,42,198,95,96,164,202,48,107,45,17,107,246,2,243,229,149,152,83,101,228,91,80,183,254,119,138,201,64,197,135,212,15,171,151,44,69,249,208,188,57,253,250,157,63,153,226,131,155,3,224,56,103,144,28,200,229,192,71,131,21,129,219,235,31,205,144,191,146,253,77,67,78,216,241,242,228,244,174,123,254,65,212,26,35,218,100,1,28,145,247,37,254,116,206,212,40,200,241,209,30,238,181,165,198,211,144,87,158,142,226,70,232,172,134,42,41,121,222,108,17,68,45,47,16,56,26,77,188,99,188,115,118,252,245,11,51,25,44,27,128,31,32,221,54,158,109,102,53,155,4,245,73,26,234,174,198,111,64,52,171,213,56,173,114,145,152,204,191,140,179,22,93,211,35,243,221,136,103,201,155,0,41,110,183,62,30,176,252,190,108,47,23,203,166,160,173,17,124,11,189,244,44,4,13,133,74,224,19,240,200,254,27,57,180,193,89,67,10,147,117,127,169,109,96,98,8,10,21,26,37,181,81,247,202,60,172,58,139,237,116,143,140,46,52,176,49,71,231,243,80,161,14,219,152,25,62,178,232,150,162,47,124,122,155,221,61,212,160,224,158,136,39,24,24,159,93,108,6,145,49,245,189,95,22,153,45,100,83,225,12,97,201,53,242,6,2,23,210,62,108,106,189,178,189,42,64,247,93,171,233,157,196,159,103,239,240,111,60,164,43,151,83,198,183,204,37,185,207,113,120,130,103,10,4,90,144,149,54,51,128,82,233,108,119,172,85,82,79,203,25,184,22,113,202,100,46,34,121,95,234,102,43,243,242,211,223,171,133,152,188,18,134,67,47,2,94,11,17,249,254,0,115,150,132,37,136,76,84,42,91,153,219,138,4,233,91,164,1,243,162,12,134,75,244,55,138,40,252,182,74,245,239,39,45,157,106,56,118,130,15,190,210,138,155,237,239,57,182,77,69,190,113,237,27,178,173,214,149,95,133,12,106,208,89,63,129,174,51,58,43,142,103,103,138,109,123,39,101,45,171,1,233,54,34,208,63,121,151,241,39,0,207,133,172,100,150,134,5,196,133,184,171,253,201,139,186,75,242,123,53,174,38,249,95,72,254,64,108,209,147,37,177,166,69,3,178,95,255,47,41,195,232,6,73,119,89,203,225,150,80,125,183,56,28,82,112,89,167,237,204,73,139,208,233,7,168,90,35,244,133,50,216,254,240,80,227,187,102,135,27,213,192,201,21,175,236,199,100,103,36,247,192,4,133,40,125,16,111,25,177,101,37,180,170,49,230,106,169,123,73,58,231,60,106,230,145,116,211,215,134,199,90,18,243,210,29,225,79,224,248,108,204,147,215,73,244,75,154,145,95,137,151,193,154,146,43,242,175,5,62,42,113,9,57,70,59,133,75,165,250,154,186,143,167,22,47,252,137,102,87,181,104,147,207,195,205,88,18,48,209,126,182,35,179,10,30,175,25,163,6,202,85,185,99,52,208,20,19,242,169,14,253,227,198,85,129,68,11,99,112,59,79,142,105,188,254,123,148,88,153,70,89,84,106,236,34,181,241,51,194,138,62,14,134,245,151,117,235,135,10,139,140,204,146,196,96,242,114,217,131,102,142,129,65,132,108,64,29,42,233,238,33,19,249,17,222,195,125,158,124,202,110,18,183,150,111,199,70,127,8,180,135,203,33,143,230,228,90,44,43,118,241,57,168,162,89,150,106,102,32,60,250,93,143,196,239,12,214,171,73,180,196,199,210,115,112,192,13,9,123,222,213,148,91,19,101,236,101,30,146,43,164,10,156,101,112,151,65,89,151,245,154,56,37,194,99,153,35,80,3,93,62,246,6,68,42,34,155,207,230,215,121,37,213,153,36,165,136,123,181,144,31,215,138,161,118,151,196,108,131,138,93,13,158,182,138,197,184,0,44,139,70,0,204,15,179,245,235,111,229,61,119,1,248,135,70,169,50,116,69,16,223,77,223,248,176,81,63,205,104,150,100,178,216,215,7,243,251,58,16,117,59,213,117,122,156,183,0,72,126,132,100,86,92,240,106,174,220,88,51,75,166,111,176,139,229,215,30,173,166,246,249,201,187,24,250,69,150,214,224,9,17,218,53,173,213,254,11,60,19,32,202,124,40,131,51,99,223,226,217,190,252,29,14,39,73,199,37,180,254,114,46,169,46,109,205,172,86,62,198,113,209,186,149,211,122,42,239,238,71,133,33,39,217,86,131,68,199,243,26,0,143,97,215,140,217,34,11,55,192,118,66,69,203,200,128,171,40,250,94,127,204,76,168,232,153,226,37,150,4,8,22,177,75,64,204,39,19,45,127,173,174,14,222,159,184,66,88,61,250,133,231,114,166,164,33,157,77,203,31,222,189,111,131,178,107,117,10,165,203,18,211,117,188,134,254,238,158,123,143,231,245,189,89,21,88,66,169,241,24,26,210,108,105,249,56,37,196,36,26,110,237,31,34,198,114,72,218,133,14,40,38,0,26,218,130,56,146,228,86,253,43,36,112,162,58,232,178,162,105,114,186,74,187,229,215,195,101,241,14,24,95,246,248,101,255,68,164,79,41,18,245,65,11,228,167,132,169,52,170,196,91,52,224,204,230,105,193,231,254,49,143,85,42,221,140,233,18,131,116,86,127,103,136,113,15,23,95,39,90,226,59,168,56,73,43,227,171,60,251,5,66,24,207,129,225,168,127,243,190,108,173,215,76,110,107,75,120,242,147,252,217,57,234,116,1,133,221,90,162,174,126,61,236,200,53,105,71,155,217,56,85,6,214,13,60,119,234,225,200,186,152,215,237,225,105,85,252,240,252,38,75,220,200,6,243,144,34,127,161,14,197,107,63,75,235,195,72,44,27,244,129,243,201,59,241,45,173,62,200,145,232,76,142,208,183,15,77,119,157,26,157,170,159,104,206,13,248,132,68,229,234,196,252,168,229,154,203,44,177,54,200,235,132,93,52,10,196,60,152,226,220,27,98,85,215,82,144,161,12,76,202,47,71,231,225,223,105,35,201,195,174,188,10,168,199,141,255,108,74,166,226,33,4,203,54,202,178,27,127,250,86,181,225,246,70,219,65,173,49,214,202,71,22,67,184,54,90,182,251,202,40,14,235,63,201,190,75,65,15,33,62,81,56,157,55,187,67,3,223,5,188,105,211,72,202,95,229,207,20,1,219,121,116,56,5,116,227,97,48,200,192,252,86,238,56,125,89,89,89,100,76,5,180,81,31,33,111,202,211,182,51,25,81,28,239,153,125,85,67,149,136,118,157,65,84,65,43,74,86,81,238,45,7,227,222,145,234,95,152,157,225,22,53,47,59,189,252,16,40,26,171,155,247,98,73,206,206,218,9,241,152,213,3,15,107,123,100,86,78,2,200,194,8,78,101,235,150,113,69,232,13,102,131,200,41,240,126,186,238,184,20,62,218,235,221,116,53,44,20,219,104,254,112,139,81,119,100,253,105,53,62,247,159,166,75,128,64,51,7,193,108,154,115,34,146,127,75,102,17,112,81,35,33,255,104,228,11,97,24,252,219,214,122,235,2,28,34,128,252,220,126,248,87,48,200,149,102,191,135,59,48,111,142,210,22,87,41,25,209,90,114,67,98,234,128,53,45,198,155,116,161,66,14,216,226,63,200,18,7,20,213,60,221,77,128,48,20,142,208,197,61,210,161,90,77,80,146,220,80,168,29,93,171,234,195,182,134,136,225,120,206,94,147,141,52,199,5,155,74,143,12,252,50,79,254,135,78,145,222,143,150,128,28,137,206,79,88,83,195,0,213,182,223,225,201,191,235,235,39,175,202,211,139,11,109,8,255,251,237,232,33,37,250,169,184,42,115,205,55,220,211,160,190,225,201,208,87,227,181,15,92,123,111,172,104,71,23,236,206,214,177,119,77,128,149,238,102,224,147,48,143,82,158,83,179,110,112,12,75,86,190,48,208,14,156,92,140,55,64,14,23,106,204,140,48,97,72,62,247,14,217,121,31,224,171,233,69,177,129,185,71,17,87,96,138,78,19,178,198,229,37,235,51,51,208,149,100,111,39,54,197,126,215,245,125,0,18,64,157,246,4,183,62,21,82,209,182,193,74,163,255,99,143,38,119,30,171,116,62,129,241,64,167,205,128,48,19,141,208,126,96,231,17,94,11,123,106,132,252,127,95,4,217,84,100,231,9,56,144,178,55,92,107,154,194,164,113,19,93,117,152,188,49,241,135,95,131,177,63,10,247,179,86,47,153,63,125,70,239,205,3,48,196,135,152,123,146,5,229,21,112,255,72,4,180,42,148,238,234,211,163,111,223,49,176,36,101,182,121,145,65,242,151,27,181,100,235,212,127,238,78,165,2,36,188,117,89,217,137,39,32,249,156,72,106,48,65,177,35,119,166,109,125,93,15,74,133,194,177,8,208,79,4,23,216,37,3,20,67,12,40,52,11,160,213,96,177,234,40,240,251,19,126,81,186,153,249,204,11,91,78,70,238,38,31,243,13,156,49,165,95,148,218,155,179,139,30,216,15,153,27,164,59,189,173,159,141,146,16,21,167,183,161,203,82,140,66,150,182,16,73,40,176,102,55,118,132,173,249,137,117,137,145,90,53,86,164,24,152,171,14,64,192,181,253,238,22,204,59,115,228,173,155,232,15,108,250,14,135,190,177,25,54,114,152,83,38,132,125,185,243,134,112,168,170,99,100,155,125,107,46,165,146,10,12,243,170,39,155,195,220,140,129,9,27,178,166,144,112,200,134,3,146,228,27,60,217,251,147,93,72,56,196,158,217,177,53,113,146,111,93,172,7,71,165,196,105,120,164,255,79,158,235,183,45,61,139,128,87,87,24,202,89,236,50,129,135,90,217,225,115,211,102,32,22,124,87,167,76,209,47,193,179,5,176,1,172,115,53,235,4,198,69,17,146,1,156,60,169,171,3,154,137,1,8,160,180,39,33,145,194,221,167,74,225,147,22,226,175,161,190,155,99,104,36,234,28,206,255,153,106,146,140,248,208,160,159,129,189,81,79,151,34,57,191,19,60,238,132,173,126,112,102,40,167,236,248,169,15,165,62,167,248,117,241,242,52,190,179,82,62,174,253,135,166,242,116,101,164,25,44,212,205,199,182,51,26,85,54,11,16,243,103,183,145,84,222,115,193,84,191,14,243,49,214,76,187,20,39,29,243,173,156,181,219,109,64,24,75,52,179,28,160,231,99,85,33,44,165,96,91,1,116,151,203,247,43,74,128,179,172,198,31,77,89,11,160,120,13,159,140,72,217,110,79,78,206,233,178,98,50,152,74,216,73,133,249,217,70,75,56,129,241,107,234,100,37,103,60,16,188,2,190,11,70,104,226,153,93,247,153,143,161,19,20,220,168,207,59,231,145,117,83,136,104,18,107,25,84,26,105,116,169,98,24,122,32,236,228,193,206,223,235,29,238,49,143,225,2,196,58,61,127,140,102,14,140,100,86,158,130,245,106,213,21,195,130,77,170,38,87,189,28,239,43,9,141,221,172,71,101,23,117,196,97,176,152,245,228,11,197,252,84,206,70,36,202,196,205,27,80,137,39,25,75,180,73,162,224,150,97,44,115,24,151,153,239,190,250,64,81,124,193,49,199,158,225,239,216,251,150,194,11,43,136,66,171,93,122,163,101,50,248,76,30,251,201,114,80,75,69,109,212,155,11,141,217,118,95,15,127,174,149,147,216,251,178,89,253,92,51,157,16,128,60,144,26,219,47,131,125,182,76,241,164,209,6,26,7,92,85,220,173,245,230,208,98,209,124,70,173,192,190,132,55,211,201,186,183,60,108,73,202,134,11,25,98,22,219,173,173,140,39,222,243,91,17,177,81,168,144,244,94,105,34,211,227,16,134,9,254,20,51,4,182,243,203,82,63,238,89,246,230,147,185,200,52,129,113,141,167,177,99,18,247,119,52,84,13,203,187,89,98,35,178,30,13,149,205,77,136,197,164,183,202,225,132,158,34,253,166,180,170,81,56,53,16,116,34,149,120,212,66,17,226,5,193,175,148,81,251,230,23,177,141,43,79,103,153,84,172,51,44,242,34,237,188,74,225,118,144,129,40,56,96,157,254,134,231,14,209,110,23,26,41,253,29,33,247,80,149,196,100,34,23,183,198,124,246,191,174,56,254,31,119,127,229,154,236,190,38,98,101,91,126,182,201,156,27,210,62,101,17,18,95,17,62,112,173,218,95,8,203,29,169,3,23,137,111,219,234,54,156,50,148,31,227,60,56,205,74,105,149,45,57,162,39,83,232,38,150,169,204,161,15,212,82,220,124,196,127,1,123,135,186,208,13,210,224,127,223,143,131,107,123,201,10,21,58,99,135,64,212,81,242,174,16,20,198,65,72,42,58,79,59,206,26,52,133,57,223,232,6,119,87,13,47,214,82,42,153,242,77,203,163,205,22,188,0,129,78,179,114,86,63,119,183,248,180,74,200,49,174,239,118,170,130,129,69,61,251,182,192,219,239,214,192,255,58,247,26,49,105,232,74,79,103,145,214,114,231,134,233,230,182,242,244,118,246,117,136,107,207,19,107,184,247,251,123,157,189,96,101,189,162,223,179,99,10,86,165,128,163,231,16,244,57,68,233,20,250,104,28,166,38,49,110,177,66,17,127,187,199,42,122,137,238,193,107,95,247,227,189,113,10,75,176,213,70,136,141,144,164,87,37,42,23,127,141,164,183,78,139,218,128,235,216,244,18,237,172,200,24,113,21,112,117,16,59,41,136,9,155,210,169,170,75,221,91,65,24,147,102,178,110,106,220,193,124,222,37,240,191,119,132,54,85,182,115,221,35,234,48,168,174,45,235,227,126,189,190,94,228,240,101,211,112,91,127,57,151,48,255,55,129,17,139,254,252,80,114,75,182,22,51,188,91,109,69,192,230,36,179,138,232,162,3,131,1,137,52,56,241,139,77,224,236,177,175,210,192,80,187,135,105,224,116,81,229,132,151,223,232,67,207,191,76,55,255,26,58,42,239,48,161,0,251,40,166,214,231,173,40,122,99,165,8,170,84,14,152,38,0,60,172,198,70,127,95,75,16,127,6,6,164,64,141,172,238,59,222,131,224,43,38,141,127,96,100,62,2,30,34,180,54,230,3,150,5,231,193,31,96,61,201,7,121,144,136,49,68,114,1,180,193,165,67,117,98,92,230,45,153,167,120,227,39,220,201,40,218,176,242,79,255,176,197,84,44,219,188,24,123,109,252,180,10,54,56,205,152,158,23,34,226,122,114,118,86,190,135,145,210,139,53,111,80,254,12,33,99,114,50,69,174,102,63,40,134,203,163,241,201,210,132,197,30,194,21,41,67,111,169,59,137,176,140,87,223,35,219,148,41,17,47,87,132,177,195,184,155,62,44,57,51,61,166,176,0,78,17,239,248,132,24,90,111,0,114,11,243,116,156,217,62,172,237,169,184,102,49,203,132,170,173,228,19,92,247,110,129,213,51,246,166,189,117,14,122,133,32,168,49,250,110,109,130,233,47,207,247,73,245,53,4,163,18,37,68,143,96,159,144,46,41,170,94,167,114,150,192,69,209,251,219,13,111,213,186,98,240,94,100,151,249,137,215,40,31,202,233,102,233,87,154,45,180,231,125,239,156,180,218,112,223,97,62,42,141,65,252,126,67,80,247,250,233,208,232,35,192,160,163,194,226,126,10,45,236,6,185,108,216,204,37,163,11,79,111,48,215,146,155,158,134,141,203,55,89,61,222,33,78,82,125,74,58,124,11,39,39,25,125,19,251,109,165,69,192,6,62,4,243,172,60,180,97,171,114,245,37,98,216,173,83,172,42,223,203,123,98,129,233,163,55,50,102,117,207,223,131,8,155,151,246,17,163,194,153,249,69,72,100,93,139,51,97,70,143,174,24,21,44,73,67,97,203,26,232,224,113,226,185,74,242,203,51,164,179,209,188,168,1,102,93,74,120,214,135,191,193,209,7,112,218,199,145,10,92,23,239,226,242,205,187,159,126,171,125,35,158,53,118,74,19,183,224,31,116,118,13,32,211,205,92,131,123,48,181,32,124,7,233,247,254,24,251,109,189,0,184,187,80,73,194,94,100,239,81,170,145,20,235,132,230,56,141,90,22,151,198,88,153,66,134,20,94,237,62,58,110,218,255,50,111,198,109,211,202,21,39,7,30,238,147,85,35,154,58,236,112,221,70,102,211,120,115,74,109,188,70,229,214,191,122,134,120,195,231,217,122,35,113,9,110,154,50,82,32,35,111,159,191,205,52,223,124,250,77,32,228,68,131,215,255,245,107,10,80,105,104,31,4,173,207,219,31,219,171,182,182,254,211,181,183,202,185,238,165,167,38,248,72,193,90,249,154,165,80,64,209,68,160,49,226,93,135,143,48,97,211,47,187,29,120,160,203,115,39,87,245,227,220,244,5,60,57,251,126,42,117,244,81,69,98,77,242,210,249,188,19,130,253,198,56,95,174,249,187,185,215,132,16,226,25,29,180,25,54,143,69,121,134,79,117,180,218,210,211,236,58,207,231,69,104,95,149,166,212,59,105,131,68,83,21,233,177,143,135,83,237,99,3,20,58,123,234,249,128,199,117,238,163,124,52,215,100,124,76,146,61,253,192,135,196,87,201,115,149,98,141,214,85,252,207,188,13,34,208,166,93,132,22,39,44,115,121,203,93,78,137,69,196,253,197,120,148,36,21,208,5,95,43,5,122,145,41,160,12,117,201,143,36,62,133,73,185,73,185,155,194,182,166,248,96,33,9,112,7,42,39,42,203,253,23,196,161,187,66,234,58,217,44,48,7,139,47,158,58,153,179,83,189,27,100,164,156,234,199,98,117,100,38,11,24,163,169,221,244,159,173,191,177,229,194,60,25,229,142,239,38,104,95,145,238,47,214,188,90,21,66,126,66,111,210,228,101,36,242,172,130,97,234,90,20,62,166,38,11,198,159,44,245,249,131,27,135,234,87,83,2,62,185,253,129,60,125,165,26,164,138,148,193,87,246,201,45,72,3,33,31,191,29,45,33,15,238,109,8,39,100,38,195,128,83,7,133,205,161,144,113,161,194,75,111,13,7,188,92,227,251,80,96,18,64,26,145,25,40,183,204,243,127,122,119,214,146,16,231,175,187,101,92,23,25,172,45,195,139,252,212,135,73,86,24,33,203,30,64,143,202,39,238,180,143,39,141,32,30,65,76,186,57,211,14,143,45,98,183,16,106,103,221,249,6,53,137,24,139,142,183,198,247,95,139,222,54,254,33,32,110,206,70,243,213,3,192,199,172,149,164,83,182,93,148,177,50,21,141,173,13,238,107,195,127,67,110,37,112,43,142,183,230,190,209,160,162,156,23,27,134,24,34,52,140,72,249,61,178,169,148,8,130,66,147,91,31,208,121,252,240,86,4,49,94,172,145,170,231,175,155,91,81,34,65,35,19,119,54,89,16,204,192,75,121,73,147,188,144,117,13,228,38,41,170,216,212,138,219,190,30,66,160,168,25,44,46,139,91,239,138,252,75,214,254,70,38,167,102,27,83,199,3,87,193,132,173,198,46,20,126,199,149,77,169,28,80,101,104,137,62,96,184,186,195,156,232,54,165,152,181,234,109,221,187,146,210,235,81,120,213,202,4,54,76,73,143,91,58,186,245,234,169,42,230,22,18,250,90,107,166,223,111,105,64,154,164,4,224,90,136,137,59,115,161,111,33,203,195,109,85,228,153,230,42,60,71,72,5,2,62,18,247,95,210,226,191,18,86,215,250,188,187,220,235,252,237,222,248,38,43,49,68,167,200,78,234,221,147,5,179,21,224,63,87,13,134,86,163,63,36,111,99,183,191,107,252,17,109,125,244,237,227,124,248,96,249,123,151,124,55,89,15,60,83,228,51,167,78,178,149,160,185,115,84,80,74,205,223,140,130,90,11,7,178,123,40,235,140,10,228,159,27,22,21,27,35,97,198,101,3,45,152,101,159,133,198,240,50,167,96,88,76,87,206,44,39,249,11,105,101,233,91,94,0,117,182,228,62,63,40,7,175,93,108,94,109,10,13,105,155,235,242,84,115,42,225,207,146,64,214,155,15,160,204,116,101,205,129,106,90,130,161,1,205,66,106,134,110,197,2,121,251,255,76,57,17,131,177,22,249,53,191,239,3,209,175,23,202,194,236,120,82,27,150,175,201,140,218,92,66,6,242,27,242,72,21,153,249,76,147,161,201,108,133,37,82,63,157,26,16,157,157,53,227,144,45,33,251,159,166,102,14,146,8,130,61,71,232,239,55,149,154,94,62,201,196,46,66,64,182,197,173,177,174,129,184,239,93,144,26,35,78,229,198,0,35,11,0,24,58,31,116,17,14,148,173,217,199,57,30,154,70,63,65,205,96,139,15,161,221,167,15,248,53,144,210,247,198,28,89,183,77,185,161,137,46,60,33,250,124,201,6,162,14,149,173,139,246,183,196,97,174,62,140,41,85,124,32,241,157,180,188,116,43,88,101,206,143,162,87,136,175,53,8,137,29,26,223,233,139,150,187,232,66,160,175,236,60,249,74,124,88,0,169,71,249,158,190,158,10,136,161,14,192,129,205,123,206,139,139,194,116,10,232,178,229,135,29,133,175,175,159,206,251,200,116,49,111,179,231,204,59,114,82,198,44,18,188,92,104,214,214,0,99,131,131,20,13,139,95,163,166,89,240,125,147,162,92,27,236,208,194,108,76,213,90,135,100,0,183,53,71,191,95,49,61,227,177,149,62,19,73,102,79,254,208,162,75,217,114,173,130,116,114,179,103,102,51,151,84,216,208,210,52,137,180,99,72,124,128,249,247,136,183,36,28,249,242,125,70,239,231,22,75,183,222,194,216,180,98,166,182,159,27,186,214,74,253,234,220,112,80,103,58,215,113,70,28,68,149,92,181,110,119,67,179,179,9,96,140,249,194,72,173,244,144,58,9,141,246,68,237,118,179,124,164,96,125,30,196,126,104,19,176,107,25,7,162,89,236,206,184,139,167,166,16,55,67,7,93,251,90,252,86,252,171,140,238,114,28,106,253,2,64,26,18,192,199,145,70,224,41,158,81,211,254,47,235,74,231,215,176,97,187,165,209,79,109,189,21,14,209,97,193,29,254,42,24,157,72,5,143,9,214,54,90,86,243,143,140,12,163,2,158,213,69,48,232,80,165,123,73,197,247,8,241,232,198,127,142,153,236,153,145,20,27,64,72,56,14,13,147,102,116,211,20,44,176,108,13,229,36,230,81,206,9,197,5,42,177,137,125,239,52,138,145,92,76,16,223,134,138,221,234,177,91,177,210,67,1,151,117,176,201,125,211,227,144,217,180,31,53,97,31,147,33,222,114,225,63,236,245,62,68,54,30,147,134,96,110,84,124,209,201,141,3,62,115,79,24,228,194,3,74,218,184,3,66,224,170,40,123,37,121,61,129,54,53,103,197,43,89,135,6,26,104,193,193,136,152,56,142,183,224,128,35,138,123,231,218,184,64,116,133,134,79,71,93,163,18,65,127,217,137,72,42,147,44,193,117,255,58,201,221,139,83,224,169,171,21,200,243,196,43,229,12,27,96,110,87,50,136,174,144,220,236,35,210,9,136,71,10,14,95,205,206,230,46,210,240,140,197,31,1,18,188,0,238,15,228,67,49,220,86,132,126,70,124,204,88,118,84,251,214,36,171,200,70,160,93,190,20,193,149,122,208,201,60,231,13,227,143,217,98,120,101,241,47,166,37,0,246,166,53,179,69,210,170,111,102,237,39,29,58,140,90,17,30,66,50,240,135,134,156,130,216,158,96,227,238,43,173,150,62,156,252,12,213,121,200,99,178,38,253,248,51,29,232,51,139,88,26,160,174,235,4,96,47,68,39,65,224,118,4,246,129,110,151,23,33,196,101,107,18,57,33,181,138,239,175,105,157,49,247,51,175,4,49,223,166,210,239,121,16,164,212,230,198,33,63,150,165,9,54,147,43,215,241,224,55,27,106,204,89,39,184,161,80,49,4,115,240,147,14,244,80,211,157,188,47,240,27,232,175,82,215,194,147,55,86,12,143,240,196,252,206,171,147,238,96,167,220,204,222,124,57,43,217,33,94,205,196,224,116,99,78,12,233,159,227,1,76,43,79,235,217,146,66,161,211,175,94,65,74,199,243,183,6,81,84,203,242,106,233,76,173,158,214,45,43,108,174,250,106,136,126,230,63,14,251,213,18,71,87,50,64,255,236,85,183,102,109,45,1,174,202,9,149,185,253,197,58,210,45,138,136,51,85,221,138,73,184,106,127,134,253,72,58,18,180,62,151,29,82,139,220,202,116,64,248,20,81,96,109,47,138,242,186,193,36,58,228,83,194,172,38,0,252,218,244,10,112,115,142,57,210,57,11,64,200,229,159,61,193,101,132,118,218,80,148,208,24,56,50,42,216,65,221,198,222,42,94,40,195,189,60,175,28,71,25,114,164,42,45,8,67,46,142,204,238,25,167,37,150,221,46,11,216,39,161,104,150,116,113,1,94,67,6,9,155,180,85,217,5,244,160,99,51,203,177,93,136,13,60,29,150,143,141,45,240,202,86,52,252,208,169,251,4,6,159,54,129,123,18,109,207,1,191,79,38,187,105,43,96,244,160,246,58,53,1,126,98,82,106,12,250,65,44,103,65,155,146,190,0,201,249,32,20,57,171,220,149,156,114,51,66,148,220,137,156,113,120,32,169,126,124,13,130,177,138,31,55,46,148,240,128,29,71,141,116,145,112,8,66,189,190,216,123,114,164,94,213,103,242,213,46,100,240,150,169,179,251,110,47,164,50,174,245,163,245,59,14,243,8,35,82,74,151,19,130,70,32,129,139,54,14,190,35,131,230,71,44,133,253,187,52,219,118,239,235,58,76,31,196,252,32,242,187,197,157,187,55,29,121,51,214,250,24,234,46,96,133,232,102,63,43,191,186,226,113,189,64,205,186,249,119,43,113,194,61,250,58,221,69,191,75,14,152,187,167,243,108,156,124,46,5,218,175,243,118,7,240,85,167,144,192,213,61,210,252,162,165,162,46,86,124,240,63,149,35,88,159,198,71,207,56,140,25,144,133,248,190,191,241,252,13,124,234,108,165,9,106,44,119,178,102,193,221,168,140,143,125,102,211,106,41,163,241,103,12,131,227,10,78,64,224,131,209,128,108,224,131,81,196,188,208,57,0,65,7,171,245,92,68,97,155,26,19,0,220,173,153,62,182,16,55,19,229,89,135,80,157,145,162,168,60,3,54,77,8,252,62,78,45,97,13,187,5,95,233,221,143,244,218,237,9,191,191,111,230,19,235,185,24,229,133,236,211,127,22,70,243,186,237,63,6,52,140,155,111,172,124,143,130,20,198,240,17,48,164,10,74,221,17,240,102,82,73,186,66,214,132,28,226,189,253,197,216,71,13,102,76,54,192,250,157,250,97,33,169,125,119,76,18,127,148,89,55,79,41,27,171,173,241,40,25,242,210,152,51,104,129,66,79,162,178,205,127,78,159,148,90,244,237,62,200,220,157,71,215,30,45,95,17,166,151,2,107,156,25,214,202,113,205,64,70,182,24,9,62,176,176,190,16,176,188,96,117,242,77,22,88,50,108,118,138,246,209,82,199,143,160,77,201,121,197,140,194,143,8,181,195,45,95,221,40,139,214,14,153,166,70,195,180,165,102,177,227,237,193,79,231,55,66,91,102,116,212,200,47,182,152,106,44,255,140,122,66,158,160,250,117,112,5,28,227,9,101,161,115,43,75,216,160,129,201,85,4,155,212,168,94,163,160,204,9,102,25,233,102,160,184,227,106,238,100,129,31,84,122,126,254,145,223,210,150,80,172,229,177,248,245,3,169,238,5,16,2,78,51,54,207,82,72,227,99,136,26,105,129,53,22,17,45,214,181,195,68,36,56,169,195,242,5,8,191,67,154,4,98,246,26,112,153,140,77,237,240,2,154,115,169,245,170,100,202,110,18,149,98,123,104,24,71,192,232,157,222,215,83,47,36,18,129,246,103,237,227,185,218,144,30,199,136,151,160,138,100,74,32,166,208,86,67,75,237,132,120,166,153,52,64,10,225,171,2,81,131,86,59,191,48,93,62,184,125,186,164,181,232,91,66,146,242,21,173,53,43,188,74,248,215,108,185,224,167,76,81,71,206,93,12,235,166,22,241,224,190,133,235,131,111,103,60,230,112,49,52,171,86,194,94,59,123,115,191,87,69,241,194,32,229,82,37,247,66,83,202,39,30,54,213,89,3,78,249,44,22,248,167,57,0,84,189,32,168,147,103,6,140,148,202,187,193,37,38,180,46,29,166,57,72,223,230,106,44,108,111,251,141,251,89,7,111,191,116,203,52,57,144,49,241,196,170,155,145,94,130,81,6,8,48,239,173,230,55,130,69,187,163,225,66,214,151,106,237,182,124,152,252,164,152,71,188,138,18,156,234,158,96,75,48,112,107,71,163,19,180,198,24,225,112,151,114,89,6,217,49,26,232,78,138,51,90,69,91,193,126,130,54,20,217,158,121,249,61,85,203,2,97,83,109,237,170,254,0,91,197,122,244,126,45,233,234,109,127,179,19,219,93,31,65,76,94,19,176,192,62,20,225,161,144,181,212,117,211,254,177,20,119,165,4,191,21,105,172,116,103,36,198,101,166,240,111,212,21,87,239,249,26,153,242,52,76,142,34,251,237,81,66,187,57,122,29,236,37,110,21,148,230,218,247,104,63,1,234,5,69,199,73,134,157,172,42,231,147,224,75,141,129,211,82,4,89,195,246,70,171,181,93,183,55,108,159,166,33,84,4,185,111,204,210,203,121,247,47,11,38,196,128,175,73,224,158,13,7,251,219,162,20,164,80,64,199,241,117,6,96,69,101,173,208,37,165,211,107,165,193,43,31,159,138,214,247,2,33,12,191,208,158,105,240,17,229,141,41,237,45,38,45,115,88,232,28,191,188,150,228,13,47,17,235,94,149,41,105,96,203,124,26,222,106,9,189,50,92,15,120,136,57,57,255,99,51,112,155,217,186,209,181,137,48,198,43,39,230,86,230,26,217,240,223,93,238,195,80,220,79,238,160,255,161,52,146,25,191,179,0,106,203,39,179,207,46,133,153,151,239,88,57,122,189,135,89,178,115,230,216,10,114,143,251,93,168,61,169,202,150,202,196,237,75,49,182,183,125,110,19,34,1,136,14,89,81,155,227,118,201,69,250,152,109,216,132,250,88,147,48,2,191,100,195,211,13,126,162,119,72,133,229,123,207,22,23,212,210,63,155,150,227,57,166,222,129,67,70,42,85,154,245,247,41,193,230,95,156,113,40,103,226,86,19,6,181,49,124,103,224,189,223,33,119,236,24,20,229,68,141,154,5,89,177,163,212,125,152,33,38,48,226,24,141,151,158,51,86,207,22,139,80,172,113,125,82,37,229,71,24,29,22,151,195,95,177,29,49,74,158,121,217,68,52,92,168,158,88,196,251,22,3,155,79,122,252,156,221,200,181,70,100,216,71,156,175,156,86,2,231,130,108,43,211,119,75,181,114,163,95,222,24,246,255,186,183,186,101,37,137,223,53,194,47,117,58,55,235,209,179,14,167,242,26,134,221,36,193,38,118,184,207,96,67,32,145,250,154,128,94,25,66,185,48,57,213,130,222,58,197,173,252,78,101,199,141,206,155,94,81,157,155,216,239,200,168,141,203,59,210,55,17,55,170,5,110,70,51,20,19,17,219,187,198,121,220,48,135,101,52,185,215,244,4,37,229,220,138,211,126,144,244,210,14,194,134,9,176,26,52,128,5,94,173,63,199,171,196,37,142,16,185,13,98,224,38,105,153,24,182,124,179,35,177,69,226,224,127,75,236,2,98,7,44,185,3,14,107,156,129,152,51,36,29,203,211,203,108,162,74,162,216,89,12,128,9,112,14,157,147,3,227,248,177,51,228,239,231,213,231,254,82,42,244,137,106,99,170,156,192,66,71,139,213,5,156,125,195,124,229,130,190,205,89,225,241,254,176,95,30,219,40,248,129,218,116,222,75,183,241,249,60,88,178,52,92,157,156,113,232,162,36,107,47,55,17,155,162,70,224,125,82,84,211,203,26,49,246,193,94,207,161,122,216,126,138,16,206,87,28,38,45,30,196,186,30,68,206,95,156,208,218,236,93,107,125,217,121,46,223,4,69,183,46,238,206,71,72,167,159,167,48,118,25,0,159,147,140,99,166,172,4,113,21,161,52,102,54,219,194,90,106,50,6,156,202,21,86,112,33,45,53,6,124,162,83,226,178,246,1,165,167,177,190,237,128,219,79,114,30,187,31,146,10,157,251,80,124,108,191,233,91,104,68,35,156,13,54,123,191,37,77,245,82,222,206,8,246,133,27,217,87,116,7,145,65,128,81,142,250,19,137,207,10,217,88,150,119,183,30,231,123,9,189,145,113,150,247,204,148,101,142,228,144,127,101,122,157,153,221,45,112,44,139,13,223,94,18,221,245,14,185,252,132,117,15,173,122,121,1,251,109,2,107,25,97,29,180,199,11,124,161,138,37,92,119,254,245,118,34,128,28,100,200,80,5,114,99,208,232,126,215,247,226,193,129,111,229,166,12,107,30,67,118,84,156,100,158,204,44,28,118,134,227,10,22,153,126,77,13,134,137,18,167,115,62,98,60,182,179,66,109,93,146,39,135,247,137,193,45,175,156,83,87,217,63,250,57,154,128,151,152,45,35,43,126,198,229,219,126,200,145,4,236,251,153,196,162,89,73,134,96,119,107,128,190,147,228,64,73,220,100,124,73,203,91,213,77,92,68,50,107,69,237,110,138,228,193,175,162,213,78,39,118,105,39,11,196,157,25,195,35,53,250,121,123,219,197,179,143,206,30,210,251,106,231,243,37,84,55,23,7,30,84,11,121,92,53,9,191,28,49,57,237,112,78,183,12,215,243,99,159,238,14,246,197,136,207,69,0,120,99,89,37,184,54,94,128,204,224,174,118,50,226,59,151,162,115,167,144,223,213,199,4,87,55,193,10,212,169,238,242,254,70,213,252,87,32,245,18,157,79,122,232,143,103,31,93,140,93,243,91,156,91,223,136,12,68,98,200,179,170,185,195,112,27,104,3,205,165,28,186,174,118,57,189,119,144,158,95,158,164,143,139,58,87,217,43,22,68,43,126,240,70,94,163,225,233,248,227,168,70,198,16,51,205,239,192,4,124,244,190,80,130,188,253,65,63,201,98,243,142,139,238,115,52,164,188,234,11,203,33,66,111,40,174,113,78,139,135,102,209,122,166,53,10,2,10,140,215,139,223,100,11,23,208,126,65,214,52,37,98,93,37,250,159,75,209,155,248,86,107,5,114,199,254,105,179,240,132,18,228,65,136,188,180,168,141,149,43,234,13,114,25,92,32,8,212,172,186,194,234,241,77,20,142,76,140,225,110,176,248,93,52,69,8,47,143,25,99,166,56,37,228,218,183,234,205,236,237,168,228,136,179,145,123,254,230,182,37,220,223,96,199,45,24,147,73,86,254,47,90,124,89,129,192,199,167,216,217,62,148,163,46,107,74,67,155,206,30,163,44,42,238,69,77,5,86,126,151,131,136,59,134,63,72,23,50,35,228,75,48,172,147,4,200,35,217,142,56,51,159,145,237,51,218,27,192,43,193,90,63,194,218,149,77,69,58,68,24,177,235,144,245,52,41,241,21,63,202,204,123,60,245,245,147,59,230,53,58,179,177,6,108,72,142,101,202,171,147,1,238,27,183,145,157,7,29,13,111,137,129,183,185,196,139,126,204,48,220,237,170,227,65,153,226,170,245,241,69,250,74,235,39,129,115,94,113,165,212,140,219,239,255,30,2,150,71,167,222,250,123,230,253,102,110,67,175,23,73,166,0,144,47,148,163,151,221,23,81,24,247,230,191,244,11,1,206,112,51,40,182,33,40,163,61,107,169,167,6,202,202,72,255,23,102,172,225,38,148,226,88,109,43,255,21,145,157,184,0,241,95,26,253,89,42,53,13,149,184,8,74,173,119,80,63,39,122,131,186,46,224,96,135,125,146,230,186,215,105,91,230,163,169,125,167,150,59,214,137,125,94,22,30,51,110,143,175,201,170,44,185,136,253,28,105,89,77,41,65,135,12,60,237,170,191,75,127,88,149,34,205,123,6,139,121,217,249,166,254,165,197,104,144,84,48,58,172,21,122,128,85,199,148,36,114,91,239,123,1,206,8,169,49,206,39,142,97,137,189,224,169,198,119,13,171,201,140,49,157,103,118,88,94,210,27,126,242,245,68,55,25,204,114,244,247,64,29,145,137,154,56,172,22,62,19,227,79,143,90,5,12,201,194,154,224,71,103,79,31,119,20,146,114,219,19,44,92,21,211,69,49,20,95,47,183,25,195,60,209,50,238,182,244,59,9,94,112,27,36,210,214,7,152,57,84,87,219,76,117,252,173,214,2,188,162,120,141,43,194,108,127,121,25,148,205,129,10,46,39,41,144,243,52,218,147,187,37,188,247,50,228,177,63,51,214,17,10,240,24,244,129,34,87,146,124,5,230,163,171,120,234,22,101,103,156,68,245,144,114,132,132,244,163,47,127,235,219,88,243,187,140,196,153,78,126,139,116,152,107,147,27,119,0,2,213,231,59,70,73,214,67,31,130,51,71,155,189,211,225,165,140,83,24,36,56,202,105,50,33,140,155,216,216,209,252,54,156,254,20,81,120,206,235,241,53,194,44,177,128,30,239,26,95,124,88,90,21,132,123,188,158,141,127,241,223,95,178,108,21,221,145,222,26,192,180,84,129,78,175,117,146,57,215,116,10,13,53,12,252,227,64,32,115,213,68,143,238,155,225,101,184,132,28,92,127,89,232,1,139,160,185,99,115,92,29,188,211,254,180,85,121,47,205,53,199,122,73,153,119,188,74,163,229,129,90,48,50,178,91,189,168,116,38,32,114,55,89,132,116,208,124,128,113,113,16,206,199,26,163,212,71,1,250,155,96,53,100,44,246,31,136,208,243,220,60,176,23,103,88,245,48,51,59,225,235,226,76,182,53,49,135,126,117,23,4,0,51,62,11,237,65,252,21,246,193,84,14,85,217,111,240,108,226,134,59,194,210,198,214,9,245,99,101,81,3,89,134,225,173,80,61,204,115,250,25,191,22,137,42,177,155,159,237,248,200,39,189,1,66,189,88,8,198,57,47,194,59,150,74,50,244,192,145,124,139,137,9,88,183,226,179,162,219,55,201,222,186,109,36,242,146,104,134,170,9,120,67,123,240,251,118,184,113,206,203,242,204,29,95,103,160,139,24,229,246,174,44,232,1,92,51,119,121,192,74,200,193,169,150,115,168,56,37,31,105,175,166,10,183,252,135,115,233,34,0,229,124,183,246,177,143,42,237,125,2,142,154,240,49,228,213,15,77,123,202,79,84,0,147,189,200,161,106,243,41,87,86,158,216,240,246,100,112,9,91,213,220,206,108,190,57,220,218,99,189,47,194,120,28,127,254,169,178,91,243,109,75,134,210,210,244,242,159,54,217,20,133,68,233,153,234,101,91,233,30,96,171,224,92,91,176,236,182,188,20,131,21,122,84,104,171,14,236,252,249,75,212,235,191,95,11,62,141,94,241,165,26,219,173,197,153,214,168,223,240,94,213,113,148,95,22,212,203,134,117,232,60,147,51,11,201,54,4,81,122,170,58,150,209,147,128,196,78,68,78,148,160,114,198,127,162,120,180,68,133,22,76,101,119,11,93,246,9,232,183,127,140,173,92,221,236,51,178,45,217,246,70,118,91,129,102,24,199,252,7,6,116,81,43,240,49,115,77,164,134,23,10,184,92,26,223,238,174,254,108,5,221,29,205,3,38,30,51,143,196,202,21,102,228,51,105,45,191,54,175,140,175,135,132,56,183,9,116,20,68,132,18,220,233,176,239,82,87,160,87,75,33,255,121,193,156,78,230,23,79,64,52,198,99,148,130,106,107,8,203,26,34,248,194,178,123,242,238,250,69,219,168,219,185,118,64,221,220,7,62,58,172,34,161,85,252,155,52,152,60,87,103,183,167,226,234,225,170,247,90,38,143,81,89,210,156,20,60,194,148,113,179,171,5,77,184,78,26,208,131,200,86,18,46,116,74,134,61,119,29,194,3,117,40,80,168,90,103,191,42,184,95,218,91,28,155,54,146,65,95,188,105,77,14,205,75,249,117,46,221,98,224,169,93,190,83,43,182,146,208,7,135,154,99,250,12,2,189,246,105,220,172,175,69,1,167,218,186,57,136,247,112,149,221,32,11,202,229,160,52,60,200,208,193,198,75,246,250,53,55,150,176,139,93,85,222,206,205,111,9,73,162,186,211,69,140,188,136,164,203,223,18,225,119,181,234,138,60,23,112,75,105,15,203,7,125,177,246,31,45,74,151,48,22,139,175,136,183,250,161,111,94,119,158,113,175,140,79,29,122,65,55,233,80,125,200,31,209,18,35,82,3,116,190,125,208,46,253,125,100,73,160,238,5,244,38,184,200,7,167,119,122,165,28,250,26,52,110,188,151,63,208,63,248,94,165,164,111,163,146,32,37,5,60,85,192,27,61,24,60,161,222,0,4,254,155,189,84,196,0,157,35,12,162,103,138,192,135,38,45,40,41,69,63,30,177,222,41,253,200,54,63,230,237,20,103,172,23,99,192,215,2,181,198,52,12,1,157,162,169,147,206,27,237,188,158,40,214,164,233,240,100,201,245,24,178,38,205,66,140,166,43,132,117,143,233,22,167,190,202,18,188,127,240,184,49,182,87,84,214,121,140,169,20,29,122,133,69,18,168,61,132,146,108,35,131,109,86,101,183,150,34,77,90,194,24,46,232,28,48,183,206,47,100,61,163,165,74,17,92,27,210,106,16,222,186,117,41,103,197,144,3,27,9,248,132,189,88,83,122,219,49,116,2,50,30,40,205,76,130,35,126,83,228,228,138,171,171,135,39,196,227,87,106,235,241,239,86,179,253,11,23,99,7,66,41,158,178,157,76,234,6,5,214,254,184,155,181,84,197,165,122,251,119,249,236,166,219,144,14,253,20,200,71,185,128,249,58,15,196,101,206,51,124,190,50,159,255,10,172,123,168,253,230,89,10,236,71,194,62,129,71,92,165,85,0,198,135,157,141,191,50,13,140,37,124,110,249,46,46,25,251,68,145,8,18,120,51,137,142,119,244,148,246,141,26,132,163,135,241,35,159,49,77,209,163,230,111,6,242,146,195,49,170,2,124,194,17,165,42,155,254,34,50,37,48,67,234,117,90,102,69,129,61,195,172,78,87,34,46,79,146,168,210,166,122,231,226,222,204,251,20,75,223,196,242,130,34,225,110,75,207,175,78,24,239,45,171,104,198,59,0,19,49,11,243,112,43,250,158,62,80,155,237,46,52,188,185,245,171,68,197,202,251,110,93,211,94,67,191,87,157,87,233,13,61,47,52,206,80,194,167,66,67,198,170,244,247,174,171,50,79,255,184,161,14,254,202,162,162,254,221,148,221,251,90,102,154,71,98,61,150,1,32,250,227,57,240,168,21,174,152,107,235,75,2,198,35,117,161,148,210,231,214,184,87,241,102,16,184,144,221,165,158,108,17,177,46,228,156,159,149,123,171,239,250,40,10,62,189,159,144,124,7,64,76,122,161,214,158,46,206,191,99,142,189,68,40,168,172,65,88,130,102,169,121,107,188,201,117,35,139,212,14,176,77,110,172,197,14,238,254,189,108,234,224,228,68,226,121,230,183,185,224,25,14,142,86,3,2,21,133,116,109,24,125,214,126,192,236,107,42,30,208,247,43,102,62,205,11,213,177,80,163,92,245,82,101,244,192,151,191,169,102,204,190,167,232,66,226,12,115,238,131,188,181,235,30,55,68,17,186,125,64,121,44,39,147,240,53,20,40,101,224,109,239,226,32,115,253,200,113,202,118,207,81,168,138,146,224,129,38,168,181,120,87,225,170,24,6,223,254,59,48,103,66,191,112,18,100,232,149,121,191,132,39,231,12,223,111,202,150,238,150,76,143,41,37,183,222,8,16,24,33,99,101,144,218,10,68,70,133,97,95,109,42,67,13,102,0,93,189,206,41,149,160,206,101,195,209,76,22,231,109,76,142,113,78,222,63,202,227,65,140,154,29,47,96,41,58,77,137,107,249,152,7,126,53,105,31,221,134,107,150,14,18,108,110,152,91,57,88,146,199,220,12,79,116,220,134,180,176,224,71,97,52,154,76,94,230,58,14,196,154,89,27,162,219,96,227,91,143,175,92,36,179,222,30,59,163,32,250,146,96,163,83,134,33,18,27,99,127,113,171,35,52,143,96,219,71,71,254,216,30,244,75,88,241,242,50,213,1,83,56,154,152,153,219,130,166,175,82,10,125,111,96,137,38,46,205,11,85,195,29,184,117,250,218,58,49,10,40,30,139,211,81,157,249,51,33,100,201,34,96,197,189,206,48,180,50,2,111,154,109,10,90,116,189,224,85,45,153,10,96,210,142,179,131,174,213,131,9,90,194,235,113,201,152,223,253,134,198,136,215,196,121,114,145,127,197,63,226,22,10,124,149,177,37,12,217,218,113,9,235,142,49,103,237,98,82,140,8,127,97,56,61,78,76,142,106,216,56,78,153,139,60,223,243,28,34,38,199,137,132,50,118,151,58,141,192,20,249,138,53,114,177,45,146,78,147,234,123,244,61,157,119,7,88,41,82,17,102,213,59,93,79,45,40,157,139,219,81,12,134,18,77,1,101,45,228,155,66,227,243,242,202,71,136,205,94,102,239,237,253,62,207,30,222,178,58,135,219,74,150,232,27,209,251,37,198,33,83,209,39,249,183,21,38,213,39,143,198,149,91,161,250,193,43,45,233,70,234,118,173,231,180,151,157,138,7,167,198,81,194,51,164,200,83,56,176,121,167,225,108,50,245,125,137,148,215,111,59,19,64,109,5,114,176,218,137,186,235,94,254,156,96,194,168,34,159,84,171,68,70,215,155,148,244,240,11,54,128,75,56,161,201,231,65,137,194,113,32,89,201,13,141,169,131,94,198,168,132,135,101,50,165,181,8,159,184,15,19,74,16,105,43,25,168,214,106,76,164,64,91,12,74,22,16,124,27,121,145,188,125,255,96,131,33,245,145,180,29,62,194,137,30,62,243,129,77,13,158,163,117,162,206,61,236,135,244,220,166,174,217,73,139,0,254,201,26,125,241,33,68,187,155,235,119,25,72,196,151,8,255,8,84,250,43,102,204,134,121,186,123,144,48,2,235,7,229,41,190,150,181,169,203,226,194,118,180,182,162,220,222,14,52,114,197,229,86,207,201,148,241,246,69,68,231,8,57,6,21,171,44,83,134,151,83,25,48,142,91,248,21,21,213,9,104,208,21,12,133,100,100,144,124,237,193,56,180,34,39,246,232,53,212,121,61,127,221,103,74,114,150,223,11,229,210,6,76,40,95,192,199,167,100,100,64,117,44,73,13,187,42,241,47,212,35,164,55,64,85,88,41,102,68,165,110,72,100,66,38,33,14,166,233,157,80,35,137,1,69,63,111,169,42,19,65,190,106,104,216,90,154,147,190,183,207,177,145,142,190,213,148,10,228,251,99,58,72,148,192,227,20,1,79,110,181,47,89,218,133,7,75,111,229,49,60,97,179,158,28,51,110,139,80,56,147,33,182,227,153,92,32,1,241,44,181,143,24,16,252,26,129,134,63,65,186,1,160,90,254,21,88,43,220,101,222,156,214,211,98,172,42,254,193,103,147,61,229,181,85,228,223,127,163,201,157,106,97,82,251,201,89,32,245,234,92,103,151,70,111,44,210,74,166,88,95,204,82,185,9,218,72,146,27,181,139,97,122,22,228,206,84,237,87,140,101,100,110,216,186,226,110,186,109,140,162,59,52,3,26,96,176,41,84,66,47,216,100,110,106,2,55,106,165,232,43,156,42,193,122,42,74,224,96,101,41,240,141,4,88,29,113,31,121,80,196,152,15,234,154,70,129,228,97,137,99,89,108,64,143,32,111,199,220,209,192,20,24,80,192,202,191,169,156,133,210,36,179,17,149,67,213,52,180,176,134,253,181,179,174,87,217,236,254,162,137,201,192,88,23,89,195,231,73,182,226,224,149,99,172,221,135,5,241,132,86,236,118,69,50,108,27,103,65,17,127,75,11,160,71,85,227,148,153,62,103,83,250,192,254,215,123,252,157,8,112,132,210,193,21,244,168,131,44,69,226,190,243,10,225,163,84,190,118,32,19,193,234,220,32,188,74,90,197,143,70,191,99,113,186,143,49,131,109,253,62,234,221,183,103,238,89,65,67,11,230,9,222,24,95,129,14,228,125,126,166,49,29,239,36,39,124,130,203,200,105,29,231,182,43,1,179,193,103,230,251,205,22,182,65,191,137,110,165,113,180,60,209,87,212,7,69,241,130,157,125,59,225,89,244,120,134,142,170,92,19,65,251,87,163,83,32,185,163,202,187,191,34,192,183,186,236,30,222,225,180,237,142,162,77,93,190,100,248,70,134,164,253,105,255,142,189,83,50,161,225,223,241,240,252,170,90,122,221,22,108,187,81,31,252,76,218,238,217,175,90,110,37,190,8,65,147,181,160,202,39,24,230,218,92,233,102,123,98,72,215,163,152,111,198,25,215,60,213,1,254,4,168,45,13,40,238,142,158,60,70,241,144,183,215,236,146,149,13,234,215,133,3,112,135,7,8,40,195,214,105,244,172,246,200,198,238,153,112,100,59,137,18,122,9,204,17,41,181,111,41,61,21,160,16,170,194,218,178,62,88,92,199,233,200,24,70,246,142,224,164,200,210,237,216,75,100,45,115,160,117,92,38,226,170,215,156,203,215,210,248,231,199,216,248,161,125,167,132,103,180,186,9,249,4,154,16,237,107,80,28,27,235,150,39,210,201,153,66,17,97,165,29,15,167,130,23,77,17,106,160,90,248,47,219,164,20,127,81,248,1,36,254,22,50,208,65,145,45,220,160,93,16,45,62,229,177,187,144,167,142,26,248,232,6,191,77,59,136,49,2,33,116,66,65,146,218,44,111,73,2,222,99,111,24,180,41,67,103,39,216,168,240,207,142,34,241,86,17,173,37,58,64,186,213,98,181,151,159,141,26,22,31,45,92,64,9,10,26,76,181,236,145,18,8,30,219,158,183,71,138,134,56,65,70,34,140,141,13,54,245,29,155,227,200,183,113,40,113,203,86,214,2,162,90,237,5,247,2,186,149,205,73,75,106,255,178,8,39,126,21,96,43,117,216,10,81,98,244,208,25,252,177,189,21,50,204,13,115,42,29,115,2,10,234,207,168,29,131,228,241,82,183,158,85,177,161,142,249,81,208,74,7,73,61,160,142,153,121,63,78,230,152,77,38,100,58,119,15,102,23,145,201,189,165,77,147,230,208,2,84,68,22,86,13,32,68,58,88,73,8,48,139,117,27,222,40,32,182,33,168,89,188,113,162,162,146,225,102,118,158,53,22,82,149,184,240,92,212,243,40,50,170,149,147,223,104,185,45,162,20,59,162,173,157,5,224,233,8,159,219,28,215,102,178,59,121,254,199,162,199,99,2,69,53,6,16,218,9,6,241,44,220,188,45,208,250,244,235,250,209,70,110,222,198,183,219,47,135,143,170,11,226,178,201,194,8,0,115,63,105,158,9,227,172,16,176,218,211,18,70,236,5,109,35,119,143,218,145,213,190,153,247,240,232,191,61,9,58,130,175,235,45,122,195,207,43,194,102,133,91,46,230,18,78,212,122,114,168,4,94,120,96,72,18,12,142,191,141,105,202,78,241,114,85,34,238,84,11,10,254,50,188,122,76,216,117,121,110,3,95,91,62,253,60,174,139,195,120,183,220,61,229,75,22,220,190,134,216,68,90,111,184,152,40,130,43,39,76,144,94,215,83,252,62,127,27,6,175,158,50,87,41,85,95,32,24,14,193,22,92,54,156,254,77,61,50,7,243,25,48,156,89,56,17,33,107,135,110,160,52,80,216,55,217,98,40,102,1,34,70,233,200,205,172,234,156,17,180,123,113,143,67,81,224,51,149,12,213,251,3,2,63,30,249,181,254,120,160,155,133,96,137,181,35,5,182,121,214,39,128,129,237,203,19,137,24,93,101,255,228,209,34,58,241,253,187,131,60,8,241,178,36,11,26,109,21,150,214,31,242,19,60,118,147,158,111,23,164,168,73,67,92,231,211,6,86,222,242,248,107,142,231,119,143,1,168,27,187,91,70,38,230,162,216,232,152,83,71,41,183,182,189,94,221,128,7,217,182,42,49,232,20,23,3,87,95,213,181,137,117,14,161,52,243,122,183,193,90,134,182,58,222,179,72,150,241,129,197,216,227,156,20,75,90,202,71,128,15,137,242,183,117,188,168,252,39,243,76,167,222,12,190,250,197,206,164,145,191,47,206,24,20,40,253,36,4,220,72,143,199,19,105,30,48,219,215,196,37,15,182,38,220,134,239,35,187,29,230,68,215,139,220,215,90,25,184,246,196,149,239,249,142,248,63,141,205,161,28,87,142,170,237,214,67,142,251,97,163,163,242,208,139,28,201,5,249,160,111,232,64,231,207,201,197,196,206,92,127,71,17,57,48,200,25,226,176,113,210,162,108,233,45,224,15,40,196,161,187,228,55,88,74,235,30,68,12,209,70,87,243,159,85,208,70,192,75,111,14,15,239,6,234,134,248,30,113,51,255,128,43,104,82,6,158,241,74,19,174,199,229,132,238,6,70,145,96,242,208,185,17,12,251,210,13,113,233,186,188,29,9,195,244,71,62,26,195,82,44,209,10,230,93,188,92,234,241,145,115,67,77,67,44,210,249,228,5,84,43,160,77,103,214,59,87,195,200,20,129,254,173,229,229,37,115,254,49,72,119,145,188,255,12,95,191,110,239,124,12,213,234,217,4,211,133,39,184,242,103,223,13,5,50,56,74,214,135,66,130,62,223,167,91,175,30,40,134,82,42,167,175,169,33,40,205,88,123,104,96,189,142,226,130,73,0,60,121,128,225,203,146,1,170,4,93,235,72,243,97,77,129,92,246,173,53,161,138,204,83,70,234,80,223,20,176,62,149,150,127,141,182,196,163,80,117,13,31,248,64,166,35,112,96,44,221,70,128,124,229,74,60,65,83,15,20,135,165,184,82,153,163,153,145,137,168,21,68,140,120,76,239,1,57,32,133,38,158,157,114,92,79,139,129,100,233,109,73,206,6,164,101,18,250,41,214,14,185,87,241,153,142,116,3,55,77,138,149,123,112,38,59,191,132,156,136,205,108,175,236,117,66,107,36,241,192,147,149,227,116,253,26,209,34,134,94,214,68,212,25,142,117,207,151,32,13,101,187,154,38,54,165,162,58,254,142,54,86,89,13,232,46,36,31,67,169,250,183,168,205,55,163,165,77,37,211,28,12,51,80,99,47,117,190,69,215,83,246,24,48,152,252,50,167,183,242,94,21,63,211,171,23,199,4,160,172,57,57,92,128,50,52,174,87,77,255,17,221,149,165,195,162,43,38,226,27,221,101,124,188,82,226,222,49,132,246,31,27,81,255,205,69,176,163,195,253,83,47,80,99,157,132,223,160,92,39,120,73,149,51,171,255,67,218,107,160,220,58,236,28,119,180,1,82,24,146,160,44,200,70,141,109,254,12,126,229,95,99,96,3,216,221,136,205,113,142,122,186,243,183,255,22,253,97,176,39,222,179,209,180,233,133,72,37,54,158,28,65,95,13,1,59,153,193,87,230,128,104,160,201,205,2,196,6,125,232,155,188,65,83,240,126,145,178,63,143,0,240,193,78,184,2,226,82,240,49,22,50,167,206,196,168,121,68,212,156,249,154,95,24,93,83,113,168,33,14,246,208,135,139,78,122,101,123,8,177,97,182,122,128,106,140,8,192,100,143,88,196,50,29,207,215,143,65,120,133,133,118,94,128,12,106,130,195,165,203,112,192,173,166,222,59,23,34,6,82,131,16,84,214,205,87,208,140,201,182,166,221,131,122,181,85,150,65,139,133,103,23,179,159,231,7,175,204,95,130,131,126,45,155,135,76,69,145,54,197,251,173,9,206,46,189,122,101,178,24,17,52,231,121,151,60,255,66,47,5,0,134,235,185,232,129,137,35,158,3,110,230,211,73,61,209,224,71,153,55,248,61,100,233,170,140,66,27,177,253,40,208,209,143,4,27,108,105,166,136,60,8,218,119,168,182,107,8,119,5,118,31,219,43,94,70,182,91,68,254,135,245,212,250,26,105,156,109,180,133,177,249,140,89,130,79,55,31,123,18,154,42,191,139,9,240,237,151,107,173,188,134,243,132,118,79,249,197,52,29,174,60,127,48,203,213,101,118,178,117,92,200,49,217,119,172,213,150,231,103,134,168,200,159,174,105,85,8,72,53,243,196,179,102,171,173,207,190,134,186,250,180,231,155,193,203,81,248,175,8,196,145,73,186,178,63,177,60,238,12,42,169,79,173,245,76,171,131,19,102,237,156,201,116,42,209,167,158,198,227,114,197,227,182,212,229,151,110,140,149,239,82,124,137,145,167,26,54,159,102,237,132,139,121,181,115,78,145,179,231,40,243,114,107,190,126,230,152,86,21,43,130,126,87,172,107,120,215,174,119,95,238,138,107,162,109,30,0,156,48,191,59,137,171,39,151,249,219,16,202,29,186,7,225,198,202,213,119,26,30,46,66,61,154,127,212,160,121,30,139,137,77,16,197,1,225,23,181,190,52,124,88,224,250,45,111,131,115,99,26,188,227,244,207,13,101,230,130,96,187,90,109,141,203,246,150,213,238,2,180,162,199,113,129,255,97,7,65,101,37,145,166,70,193,39,68,86,45,6,162,80,189,182,147,237,204,108,173,114,12,139,6,79,110,178,50,39,17,113,41,178,217,61,88,132,240,93,181,152,170,7,71,170,146,115,177,209,87,215,16,157,38,76,45,46,220,16,103,58,125,32,153,241,187,154,232,13,56,84,165,56,94,8,6,118,36,14,96,65,93,68,50,208,97,85,185,103,1,161,83,67,194,38,128,76,181,204,102,151,40,72,219,119,58,243,206,0,99,50,157,241,110,31,75,39,89,181,28,80,34,47,54,40,145,0,60,100,212,148,16,35,19,189,130,103,237,1,19,109,241,72,134,148,103,72,23,209,106,186,211,41,196,18,76,23,75,122,68,251,50,11,252,232,52,72,57,5,52,226,217,252,184,71,71,112,106,214,93,60,250,235,235,115,148,64,183,222,82,158,135,135,145,153,54,138,126,116,216,66,235,51,100,7,1,111,11,231,57,153,174,195,76,173,195,2,137,227,217,61,109,233,31,68,5,179,235,72,80,16,191,118,37,76,119,131,246,39,251,58,127,172,229,32,135,167,216,216,39,54,7,180,45,236,44,47,186,218,5,45,145,201,222,24,126,214,198,237,218,245,74,159,119,201,233,27,224,213,175,46,43,252,104,209,254,53,126,25,166,190,157,66,64,23,226,4,74,69,28,42,238,195,233,33,1,64,116,16,110,32,81,97,57,242,250,108,13,200,31,184,115,30,190,65,111,225,197,90,215,174,221,193,216,165,11,16,3,153,141,181,161,223,213,141,64,243,41,33,65,208,245,48,203,171,242,234,120,183,57,60,85,83,188,148,249,94,62,178,164,119,223,137,180,49,184,166,120,134,127,76,230,216,208,161,5,42,237,196,235,114,222,23,134,110,242,244,163,1,42,228,3,251,93,156,48,46,154,200,19,163,205,213,250,142,212,14,156,210,48,20,148,235,204,232,128,21,3,100,38,184,230,249,138,117,207,253,60,79,102,174,115,184,21,102,194,116,47,69,98,110,200,73,248,186,30,220,75,239,155,228,138,141,255,84,179,127,17,124,167,107,102,248,93,59,11,170,167,110,129,228,140,41,111,215,131,169,31,210,192,131,220,50,29,241,34,235,141,60,96,178,83,126,109,14,186,209,248,63,130,108,186,180,105,95,192,234,29,87,8,197,153,103,55,13,10,116,247,40,153,54,84,199,120,69,98,185,228,4,234,107,80,168,240,218,9,114,58,196,150,245,120,244,210,164,160,201,55,20,40,135,138,179,149,228,199,157,192,174,190,79,35,154,208,104,215,44,229,241,125,186,156,42,60,224,60,98,79,40,64,126,207,165,212,10,115,54,25,33,126,58,236,50,194,209,149,85,111,178,89,79,15,60,227,54,174,229,243,135,42,102,50,171,254,95,21,247,31,125,0,215,95,9,254,115,158,204,23,106,103,28,139,202,110,125,119,242,110,213,56,152,116,42,49,235,231,28,252,0,141,119,191,200,51,122,183,74,56,200,99,174,153,239,174,227,16,247,241,53,17,43,147,201,28,236,24,172,158,183,250,239,232,109,178,138,191,154,85,92,101,93,173,175,120,149,115,204,109,250,109,193,172,203,85,254,72,122,109,173,97,223,35,161,59,23,39,177,164,124,186,70,76,36,143,143,79,179,160,167,125,30,112,233,209,141,126,247,37,119,77,159,6,86,22,186,250,64,148,109,116,69,157,161,219,213,126,74,234,55,4,74,150,191,164,59,229,208,73,147,153,74,155,93,93,177,111,177,180,36,107,46,26,222,118,125,41,31,110,95,84,199,96,81,223,99,229,230,111,208,187,44,207,189,197,162,155,118,66,246,102,5,157,180,61,121,27,171,235,38,194,219,47,109,32,238,247,114,130,158,184,151,243,155,87,210,50,16,172,39,124,229,145,237,44,49,206,229,30,118,171,255,129,65,10,175,28,62,65,30,217,20,113,253,179,149,240,28,118,112,140,20,237,39,7,159,242,230,64,144,209,53,33,213,116,176,141,135,111,225,244,248,107,202,235,131,88,130,60,113,17,151,144,193,21,155,78,5,33,221,177,64,101,141,166,1,217,83,16,24,8,33,203,8,73,180,252,201,36,37,193,112,158,81,36,62,12,87,125,150,121,19,39,92,191,173,210,244,36,77,195,88,140,26,156,4,231,27,111,89,251,35,188,185,246,75,176,127,162,75,144,137,255,124,36,161,108,144,154,177,88,19,197,21,51,61,242,175,177,115,118,58,158,40,174,196,158,97,198,184,209,36,126,232,71,189,204,186,7,102,36,124,234,204,89,172,220,192,86,101,51,175,40,9,191,17,115,155,117,200,237,22,138,77,48,250,240,160,224,117,133,170,182,144,213,211,213,2,243,145,65,254,0,2,248,48,33,249,80,119,29,108,76,228,213,3,143,250,23,23,131,183,155,60,55,214,27,114,225,198,150,10,35,148,123,109,118,26,2,65,205,51,165,231,113,146,183,118,99,110,128,192,107,84,128,130,68,16,88,195,165,35,170,219,153,195,92,132,226,34,20,77,81,240,139,150,107,214,77,155,204,106,79,19,168,44,71,198,240,87,142,60,44,60,246,5,116,90,243,72,82,123,206,123,164,157,159,113,100,46,227,97,151,247,172,49,26,253,214,112,110,75,191,20,199,178,121,153,73,146,167,80,165,179,249,104,118,42,76,8,126,200,69,25,1,35,35,219,85,218,235,253,164,63,211,195,178,60,208,120,222,151,167,79,238,35,131,109,53,18,149,50,40,14,206,218,230,111,82,234,124,19,223,6,18,94,196,199,189,219,79,203,3,86,63,184,11,70,220,145,70,39,204,13,70,25,105,99,18,2,0,24,161,197,244,35,162,11,157,34,54,196,92,138,255,30,83,77,170,69,196,207,11,28,60,155,7,88,6,248,72,159,21,242,123,4,244,230,249,74,32,130,186,174,143,2,140,24,130,73,170,186,195,129,0,221,95,213,21,27,147,128,194,103,91,111,210,249,82,200,180,140,107,187,79,132,95,135,105,220,39,219,47,101,130,232,19,153,84,96,21,214,227,184,212,26,88,77,22,173,250,215,51,120,214,55,206,86,220,178,39,170,15,114,12,97,98,239,4,124,47,250,230,133,149,196,82,209,165,151,0,207,30,106,133,62,251,241,196,196,47,179,145,179,2,155,15,5,165,22,67,52,207,39,246,123,134,219,252,174,231,168,82,8,7,192,229,168,45,215,86,100,235,111,169,107,12,249,89,109,86,160,142,181,238,237,223,92,168,130,150,236,224,116,222,45,18,13,13,164,73,38,27,208,24,138,45,80,4,148,58,149,54,128,230,244,22,230,218,179,87,51,104,223,178,9,209,228,14,206,192,249,41,82,34,115,235,125,150,192,196,1,165,252,62,83,243,157,37,218,134,192,149,232,139,145,253,205,51,17,97,192,121,157,60,181,170,126,156,5,44,196,235,223,123,170,2,118,228,255,243,8,132,196,221,30,242,92,159,112,180,131,51,25,126,253,184,7,4,110,34,217,37,185,91,186,44,77,80,104,181,58,171,9,210,180,17,119,8,141,229,247,64,62,232,121,118,112,133,52,173,5,202,94,170,37,212,28,222,193,97,51,164,107,197,181,220,102,52,58,47,147,194,179,174,14,89,19,221,145,39,174,86,249,64,89,192,101,143,207,156,186,210,1,137,143,225,13,38,98,59,92,137,53,31,64,212,100,157,144,100,131,3,65,115,94,185,87,13,25,176,45,184,207,19,250,197,231,86,217,51,191,125,60,11,95,125,105,236,148,166,54,6,42,0,150,180,138,38,30,235,72,106,14,217,69,184,242,46,197,173,38,89,234,41,197,213,165,79,86,118,231,142,207,69,207,108,20,53,179,160,231,84,99,156,253,80,13,15,65,18,73,160,149,31,76,124,141,4,48,207,86,81,87,66,32,121,213,115,116,230,240,201,247,195,159,66,154,244,180,174,14,101,84,3,66,175,40,177,65,194,101,162,234,26,55,222,21,72,164,219,243,129,30,172,104,212,50,6,152,90,233,235,35,221,207,165,225,44,109,74,127,123,173,56,87,209,84,211,48,214,123,5,105,101,78,188,169,175,36,172,214,19,232,125,217,130,252,99,237,244,61,173,193,82,209,216,57,13,12,202,82,193,78,70,69,206,74,240,191,91,25,179,254,242,177,68,23,139,165,101,32,52,246,25,212,240,38,237,147,60,156,190,36,3,56,163,125,228,107,228,6,235,44,250,90,92,77,158,36,217,168,161,77,26,49,125,99,103,191,115,41,120,16,231,243,69,108,169,115,81,127,195,48,164,132,75,173,147,62,148,220,3,189,186,165,200,86,60,18,172,193,207,129,196,167,69,181,134,232,130,109,48,76,133,202,38,184,207,153,39,149,26,4,242,77,59,193,254,102,222,99,68,91,147,245,252,14,111,57,224,121,244,233,148,97,66,37,162,181,44,60,144,184,181,187,204,143,33,120,225,243,226,97,190,168,25,134,240,146,145,251,166,104,183,243,126,93,104,93,84,55,148,49,84,30,71,204,203,236,226,179,113,247,64,213,92,207,126,35,130,231,86,232,149,34,79,127,8,155,120,228,29,247,142,10,151,52,57,180,40,56,93,99,171,253,160,143,201,101,183,204,59,240,23,208,83,198,151,231,231,147,28,110,4,156,102,57,157,18,249,18,50,20,130,56,53,156,41,45,170,41,117,136,179,222,121,239,18,168,166,237,2,237,98,107,148,236,81,60,2,33,181,218,46,71,254,197,234,84,204,80,27,160,118,123,153,37,55,238,240,199,98,227,116,197,126,232,21,255,98,226,206,152,34,211,121,85,69,183,195,225,202,232,188,79,208,206,156,187,96,21,189,252,76,203,227,241,70,211,61,52,217,12,33,243,41,50,152,77,47,82,19,140,197,235,100,59,65,70,115,52,246,95,80,145,224,57,224,221,213,78,145,49,47,117,102,248,205,92,84,18,215,150,191,135,145,62,36,193,200,52,133,187,34,96,149,139,1,97,248,25,51,64,247,58,93,111,15,225,212,223,114,61,92,11,95,154,153,245,208,78,148,39,150,34,40,110,50,154,11,54,4,145,21,134,166,233,0,193,39,105,2,102,29,28,168,238,231,117,248,142,40,50,56,142,240,142,165,151,16,85,30,155,98,225,239,177,187,143,215,228,29,118,98,85,69,167,21,45,116,143,40,42,152,1,87,158,139,169,81,137,18,54,65,178,145,44,82,225,241,84,208,111,202,139,17,95,107,130,255,148,105,65,106,172,230,171,55,197,239,133,168,4,152,247,235,19,138,175,168,216,216,171,23,160,83,71,40,126,234,228,1,76,145,9,132,135,166,202,190,232,233,218,105,184,138,161,252,19,33,132,61,159,183,129,62,37,37,194,79,104,59,218,204,215,82,166,4,190,36,224,43,97,59,71,51,188,214,175,54,18,10,15,153,110,203,218,59,225,113,185,123,75,111,206,104,24,163,254,170,85,40,105,9,229,41,218,37,240,211,103,89,253,97,34,77,188,114,220,132,215,129,26,109,149,186,128,119,108,19,20,122,172,175,10,20,169,9,104,195,150,51,8,159,140,86,232,226,177,7,196,200,167,207,106,126,27,140,222,219,198,149,46,0,13,93,255,121,205,23,206,245,185,247,15,231,173,156,59,156,16,48,118,254,93,148,203,237,189,158,180,101,52,62,155,57,8,175,171,215,67,69,104,60,72,232,226,185,20,206,65,59,42,125,90,124,100,202,134,141,239,191,110,203,164,223,50,232,219,4,222,205,22,70,62,180,75,143,174,228,44,62,245,202,39,117,215,33,145,80,106,131,177,244,66,46,89,167,198,251,80,38,72,190,90,118,85,34,158,83,17,61,132,124,53,24,63,24,90,249,68,131,245,198,183,117,13,157,137,70,189,73,23,75,77,13,25,88,126,217,87,108,92,8,133,154,15,158,112,113,94,186,162,177,9,232,181,162,55,24,38,161,79,176,4,233,11,158,170,242,240,168,77,25,3,223,158,186,182,26,129,84,106,135,108,205,79,254,175,227,1,238,248,79,5,72,169,217,128,158,1,139,110,157,12,39,55,95,3,2,113,179,81,229,38,144,253,35,77,155,97,157,9,47,133,35,238,97,246,176,156,164,3,236,181,42,140,173,1,46,164,218,168,228,127,219,160,224,59,249,247,7,155,98,77,199,215,146,55,151,221,185,163,241,26,122,137,164,190,205,207,4,237,134,165,74,238,223,226,15,248,242,139,107,210,187,234,4,145,23,231,180,229,53,254,166,201,220,10,14,58,33,230,72,92,230,207,170,109,188,229,137,28,147,22,41,192,213,40,215,216,127,14,228,9,13,85,247,106,247,1,155,206,136,4,23,190,148,170,106,194,155,170,96,227,85,168,247,195,20,113,172,17,34,38,123,79,167,110,206,207,53,66,173,162,178,166,84,120,160,160,218,186,227,34,87,100,212,219,28,84,255,59,138,26,28,227,102,205,94,75,152,55,216,163,46,225,96,152,57,32,57,159,27,251,178,201,231,5,139,31,163,136,69,71,125,19,213,46,252,84,88,215,163,249,153,181,25,227,174,4,105,93,98,251,60,164,4,222,26,165,85,83,87,45,206,132,134,6,108,89,96,76,139,144,143,144,116,59,72,48,184,248,230,195,135,167,29,166,42,207,49,87,221,159,42,168,96,157,181,125,152,96,130,72,48,100,105,145,96,98,200,116,7,131,166,69,99,117,55,141,40,125,106,249,33,118,191,121,159,138,79,27,90,132,13,52,0,61,44,246,212,77,127,107,26,124,234,104,26,14,238,68,79,124,247,99,81,60,135,27,62,83,231,104,214,53,69,104,188,95,120,30,105,222,150,218,223,80,221,209,86,113,125,226,123,36,1,136,94,206,253,124,34,218,2,77,208,172,39,238,148,151,111,237,3,135,99,41,22,142,129,39,56,105,255,31,62,12,171,5,206,94,114,13,174,185,89,199,225,131,239,187,92,132,102,86,138,156,36,55,112,65,191,209,70,60,75,110,59,216,180,148,36,118,238,139,97,222,17,236,209,68,163,76,177,206,58,196,113,2,166,47,131,113,199,180,134,23,174,24,119,20,124,144,29,221,9,90,224,188,131,232,13,244,94,200,129,51,27,11,124,24,154,5,91,171,150,238,212,117,175,71,155,110,168,3,236,162,196,193,74,101,6,238,157,132,151,181,88,122,26,84,194,170,253,198,124,142,133,185,66,4,105,5,152,87,209,178,134,243,242,197,214,209,103,53,218,128,193,9,83,231,55,111,29,235,133,45,107,115,71,203,15,1,69,200,105,216,1,163,183,18,222,54,6,56,48,104,228,237,119,166,90,242,184,97,160,218,194,255,151,131,120,180,104,202,167,157,179,147,77,161,34,65,201,171,236,177,175,0,92,134,255,40,217,133,61,187,44,165,109,184,127,37,189,61,62,60,232,182,210,78,123,118,207,185,156,158,77,117,67,26,37,222,174,87,192,241,152,180,170,218,35,86,86,91,87,98,97,192,129,140,194,233,36,79,152,203,136,73,223,63,26,117,190,88,188,60,42,9,45,54,223,198,207,196,237,26,244,60,233,67,132,223,113,147,253,16,126,10,119,41,159,99,237,109,167,23,248,146,7,166,214,75,0,234,202,90,254,26,71,82,240,116,216,96,236,109,46,104,255,134,115,253,155,36,36,129,188,183,140,151,14,153,244,139,244,252,214,160,8,249,226,35,58,185,116,255,126,128,120,235,190,225,169,185,175,255,64,176,56,247,249,7,18,39,92,249,142,98,47,116,247,126,6,66,208,245,253,217,123,160,123,49,99,18,90,47,9,80,207,212,123,18,61,155,193,44,242,205,146,4,96,210,222,194,220,47,172,241,165,29,155,45,163,105,121,174,115,233,211,216,182,136,24,90,234,77,214,70,94,160,35,59,16,39,71,24,186,43,251,99,53,11,47,60,159,24,144,250,41,114,90,26,97,209,154,96,63,178,67,28,211,107,179,90,253,127,165,163,26,175,163,165,60,47,25,151,210,245,25,91,122,31,176,184,179,128,161,75,71,166,119,40,19,58,101,115,237,145,211,239,250,235,224,4,46,64,94,118,213,191,21,42,27,169,75,217,193,182,121,215,57,216,234,245,160,135,78,21,125,113,51,250,39,177,32,227,61,57,182,118,16,212,181,130,153,240,62,148,127,188,127,160,37,3,231,33,68,181,179,95,116,179,14,247,145,214,104,222,71,140,17,161,171,218,105,81,195,25,20,202,235,110,70,90,42,47,194,109,74,85,60,77,65,92,205,106,16,171,147,0,227,16,251,48,224,101,8,46,29,94,50,36,213,78,254,13,7,254,227,219,219,18,45,213,145,136,25,210,42,32,47,62,61,139,31,140,17,210,249,37,178,80,160,59,139,26,250,178,179,208,129,81,82,239,54,209,224,20,156,174,251,26,130,136,28,68,243,28,42,28,17,51,90,6,39,125,11,249,223,165,193,243,148,129,17,210,146,186,89,202,253,59,205,5,52,237,17,181,104,92,54,142,214,177,178,59,214,195,73,72,186,175,17,1,0,220,146,69,144,120,89,133,146,152,239,230,141,237,0,78,250,117,54,179,45,38,167,90,149,136,233,115,8,227,210,205,255,208,177,5,45,173,12,189,122,109,122,136,191,40,176,51,234,201,4,208,42,147,44,56,120,17,43,69,93,97,143,103,130,166,129,101,7,40,85,92,157,218,212,230,114,139,2,233,64,93,127,49,140,232,168,194,0,74,215,40,158,61,12,247,57,151,103,148,42,210,155,139,211,87,19,0,208,70,224,199,34,241,199,70,169,161,135,61,105,233,172,62,114,0,96,15,45,231,45,55,172,39,55,41,225,133,190,138,162,53,142,120,95,183,32,192,36,208,155,102,233,86,61,53,30,206,83,199,125,72,101,207,29,247,104,10,148,18,184,234,165,202,151,116,193,119,185,112,23,192,20,152,65,174,8,254,94,56,95,112,30,175,131,75,160,36,26,226,61,55,97,225,40,77,212,181,0,239,155,198,208,128,240,202,248,190,135,42,46,22,94,11,61,30,199,55,16,98,142,1,63,173,36,147,172,74,152,45,239,201,204,46,115,27,81,227,120,112,155,184,99,79,214,130,147,122,64,139,9,147,208,82,76,15,123,98,5,74,218,198,40,175,162,34,226,243,95,227,126,94,45,242,141,118,9,49,66,13,62,135,201,56,200,96,255,212,204,11,3,243,18,242,108,74,227,62,173,115,180,224,226,248,249,141,136,245,6,158,110,65,8,248,189,225,236,226,84,45,8,72,133,12,176,12,140,172,135,245,88,80,88,0,185,175,79,207,75,134,219,100,194,29,255,125,135,114,8,126,63,172,235,145,65,229,120,37,197,36,66,254,60,122,61,197,192,6,79,197,152,198,219,179,231,14,155,211,69,154,175,209,49,59,91,6,25,138,1,144,199,28,148,67,149,19,37,147,101,173,173,206,196,37,179,47,184,185,251,43,182,74,221,246,66,82,220,131,113,87,197,241,66,226,95,156,93,186,196,250,229,244,248,189,22,207,27,43,104,3,210,183,207,145,95,190,74,251,145,107,71,36,138,225,83,79,207,145,78,210,137,175,90,23,239,94,181,98,41,136,109,211,114,150,87,255,49,149,169,69,132,65,211,140,205,214,29,22,127,210,12,110,19,72,139,152,200,229,246,220,110,222,227,189,5,36,90,254,53,6,237,122,57,142,108,23,90,140,146,218,237,207,124,148,18,43,1,231,98,177,83,35,133,156,57,105,201,222,84,80,168,12,176,33,62,83,81,72,91,127,176,136,94,105,255,254,90,145,155,68,132,45,203,4,81,16,2,218,66,189,227,170,31,12,196,122,121,143,12,99,122,129,195,234,210,79,14,55,209,162,72,6,182,66,57,203,144,165,124,104,28,239,250,145,78,30,73,201,115,103,29,184,58,64,70,85,21,63,220,48,82,120,182,147,193,160,57,159,29,228,110,185,119,116,208,106,226,116,121,81,43,222,244,81,208,45,54,252,92,150,203,97,118,228,145,19,251,135,68,118,217,134,205,225,179,191,233,152,12,91,197,183,100,112,245,155,90,49,164,31,226,11,161,97,101,12,52,104,87,67,185,88,236,186,244,207,7,33,67,86,181,69,233,84,8,132,228,204,119,32,165,140,91,72,140,72,59,85,160,243,119,182,101,202,174,103,225,103,157,66,245,6,239,65,118,228,82,220,95,37,111,101,138,161,191,68,163,207,254,132,5,33,34,56,45,15,145,79,100,40,250,236,235,36,175,245,20,209,154,13,198,149,155,0,80,11,84,80,172,105,217,187,232,7,132,48,231,150,103,105,189,165,83,77,153,247,75,244,46,186,175,219,208,150,199,180,28,58,132,148,105,13,207,113,32,133,101,252,13,167,207,239,200,38,246,25,126,101,156,150,20,134,155,28,193,203,237,91,8,31,34,172,248,160,57,105,219,239,42,133,226,116,81,43,132,235,167,30,68,43,231,221,164,52,182,249,179,61,153,161,159,137,151,189,73,236,246,163,36,98,19,85,248,126,173,105,179,75,212,179,6,192,100,128,153,211,199,108,66,203,86,207,169,95,199,34,119,154,244,10,13,220,112,98,175,183,40,113,55,27,57,116,86,1,170,179,54,173,252,94,178,69,116,19,143,251,130,194,112,136,117,223,38,229,127,85,195,14,156,30,223,71,155,223,129,124,152,171,136,110,120,95,180,53,100,168,25,3,216,42,54,85,46,69,119,107,155,145,251,64,53,185,193,15,13,139,6,167,11,60,47,89,97,48,152,126,89,204,146,71,95,57,111,150,78,240,251,102,115,113,11,147,15,192,253,231,25,248,245,109,134,153,56,58,101,46,144,2,253,31,2,83,198,61,64,121,63,76,80,67,29,12,66,28,147,254,92,69,68,35,212,156,221,161,237,249,146,56,121,137,145,156,246,183,247,139,124,62,163,212,103,229,186,93,174,69,23,160,26,196,181,43,175,176,60,110,211,55,131,146,61,179,46,79,154,194,63,7,77,202,244,150,202,18,92,217,129,241,239,222,111,51,135,13,231,255,23,171,205,2,165,228,225,46,247,213,245,181,190,140,154,241,182,186,251,24,83,159,137,53,64,138,170,164,60,147,27,90,82,193,36,201,173,182,188,108,188,229,45,193,211,18,253,200,185,25,95,180,93,30,219,69,195,239,222,97,161,110,214,36,114,96,168,76,77,164,53,131,226,197,100,0,42,106,159,84,214,55,249,124,216,170,102,155,118,134,77,181,65,115,14,167,123,89,46,212,228,181,29,222,148,86,228,253,74,236,231,197,148,188,137,167,27,127,12,253,186,84,67,146,211,91,131,122,218,230,239,254,175,168,1,213,249,121,7,221,136,146,201,36,166,47,73,221,190,128,205,126,206,89,121,78,233,57,64,136,20,67,198,178,249,191,17,131,33,149,197,130,104,170,130,142,237,246,170,147,192,156,248,187,123,25,225,139,220,171,61,24,24,114,110,77,3,160,244,82,56,94,113,16,27,118,228,217,56,29,253,10,75,145,97,193,150,89,210,52,60,146,17,127,187,216,5,195,108,15,251,39,157,158,86,49,193,199,155,106,6,73,80,247,203,61,88,81,56,93,158,179,40,245,81,68,136,69,32,237,101,122,112,165,100,55,9,127,59,26,9,41,16,102,92,246,179,125,108,231,225,63,120,88,135,69,195,239,197,51,245,72,72,59,15,231,42,3,184,123,64,176,64,2,15,246,220,67,193,252,8,159,56,20,44,137,45,172,109,183,204,159,101,6,17,221,228,44,160,69,242,153,202,128,203,12,4,126,92,35,50,234,50,118,36,235,41,31,25,142,113,24,62,9,95,20,19,50,125,158,204,53,186,86,53,189,102,153,228,219,22,2,99,14,143,147,221,199,23,113,107,196,224,225,104,121,99,34,19,112,121,28,191,160,245,10,17,84,184,88,225,151,167,54,240,195,72,254,120,18,22,155,131,146,29,227,234,30,101,250,135,69,125,243,191,220,108,252,27,73,15,229,136,53,207,18,173,204,19,205,199,182,167,225,33,249,143,99,91,17,55,149,227,252,128,238,114,212,169,242,145,36,176,68,219,87,139,157,11,63,61,59,211,206,153,189,127,223,109,58,97,39,141,146,29,253,92,94,80,25,18,106,154,118,230,19,134,225,160,83,60,150,40,14,114,137,33,215,197,110,48,190,240,56,91,138,248,129,37,247,39,83,175,2,103,194,229,110,102,216,12,120,6,3,226,163,55,78,249,252,111,226,91,6,137,148,130,47,48,247,229,23,243,182,71,150,137,124,20,124,66,139,32,193,148,161,185,236,79,174,99,200,112,53,55,117,29,34,237,204,153,30,100,212,1,178,63,101,108,21,60,226,164,189,178,191,164,14,130,253,211,82,162,209,199,23,248,243,208,248,249,158,141,215,199,86,0,246,74,146,131,115,160,41,65,31,203,224,248,194,77,33,67,47,171,200,140,46,76,21,188,172,177,183,243,246,224,185,32,56,122,180,233,201,25,233,15,85,45,133,25,16,136,35,136,145,142,15,86,80,133,48,119,224,178,65,40,193,213,90,108,89,160,56,151,217,217,57,103,175,63,242,81,89,154,80,29,72,39,62,162,124,64,207,184,236,170,24,70,121,44,61,235,14,3,108,68,201,57,178,69,188,58,91,211,235,251,154,69,34,123,86,213,66,253,253,216,176,67,99,197,91,185,250,198,244,215,134,106,130,27,155,101,61,23,181,173,83,247,184,185,24,221,87,94,129,150,24,83,250,180,99,14,23,157,95,133,189,98,219,252,120,118,181,213,41,131,138,220,245,32,75,155,209,55,31,197,21,188,175,14,108,96,144,219,70,87,169,105,80,215,39,54,253,164,135,220,113,179,11,26,86,90,17,173,82,168,51,234,219,159,197,190,211,12,96,163,96,156,21,216,237,81,71,8,238,177,222,65,238,18,207,224,198,6,78,77,58,229,128,113,49,80,53,64,60,188,235,183,243,253,19,186,159,48,179,25,11,199,176,100,249,48,94,85,170,164,215,111,157,248,47,235,115,199,148,241,90,5,156,158,194,36,48,2,128,54,251,107,121,73,162,149,9,148,65,58,167,164,203,170,52,197,196,44,120,167,22,204,41,135,101,200,149,248,38,73,57,71,205,69,158,255,72,185,219,30,199,49,162,53,242,190,45,142,206,11,94,30,40,120,221,10,171,209,31,64,30,69,102,138,222,180,169,4,28,97,34,15,174,50,15,217,31,255,141,56,24,233,173,156,216,252,142,255,94,59,43,223,147,253,34,44,189,10,93,55,252,67,27,40,123,12,243,5,33,140,234,16,240,115,171,26,131,179,201,114,216,135,196,14,204,11,226,91,159,139,238,182,65,152,10,212,173,146,189,31,16,197,251,214,140,176,101,41,217,127,19,65,118,112,116,119,159,28,52,102,175,254,92,132,73,106,70,124,121,229,34,136,208,230,102,14,165,73,4,170,233,83,76,138,148,54,152,21,227,68,40,188,180,162,79,72,48,228,26,205,64,66,33,171,221,163,170,114,114,184,172,219,201,168,200,24,77,52,12,80,226,95,105,205,101,189,221,3,5,202,38,226,148,208,76,126,116,245,120,125,186,56,187,96,82,46,133,211,10,66,86,187,156,137,23,160,98,171,226,232,11,114,200,18,250,211,87,122,21,93,163,90,104,194,160,53,194,74,207,94,195,91,24,76,184,136,174,136,22,245,12,54,167,76,106,249,48,251,40,188,97,95,223,30,22,142,194,231,189,143,57,151,51,105,150,197,223,211,167,34,90,118,91,128,229,236,240,185,96,234,208,26,179,111,122,244,232,80,12,38,10,75,30,38,189,236,165,19,26,106,197,252,71,235,185,204,73,177,213,143,142,148,0,198,150,67,125,250,112,233,80,164,49,60,6,157,40,93,68,163,97,177,11,138,69,11,80,35,151,37,226,112,83,104,68,199,208,112,120,18,122,5,174,225,120,249,246,187,239,139,207,193,43,156,214,226,0,98,218,49,189,224,164,249,146,98,223,125,50,17,156,249,81,199,227,5,93,233,167,93,238,114,241,192,104,44,145,2,60,79,168,0,112,62,78,120,31,150,105,225,33,243,194,10,247,239,80,186,67,248,147,112,190,206,149,49,185,35,4,129,193,254,128,152,100,164,105,79,44,168,54,203,1,129,230,43,92,174,4,56,200,148,20,82,211,212,136,193,83,214,240,81,138,39,11,132,114,55,99,194,4,143,40,233,177,238,255,46,166,183,5,115,190,182,171,253,136,6,248,32,219,26,252,55,109,189,224,176,219,6,131,136,170,148,101,102,58,242,121,97,120,125,146,126,232,251,70,200,193,191,199,169,112,172,43,218,147,205,17,215,99,9,141,194,206,149,104,71,115,45,250,190,121,28,115,88,81,131,250,172,238,160,98,146,119,165,113,166,10,172,34,174,43,44,119,114,32,110,169,188,210,22,181,71,3,8,218,196,202,103,105,234,72,209,168,202,3,206,120,58,52,91,169,202,207,73,67,52,223,246,40,85,129,186,17,147,193,231,46,110,139,178,74,210,186,252,20,42,212,66,107,31,239,184,60,105,247,138,212,29,59,35,147,239,109,123,57,144,11,149,66,71,134,57,20,223,47,197,51,83,184,140,102,217,213,245,43,232,173,139,129,135,141,23,147,64,170,6,101,154,52,47,242,34,140,3,101,199,41,95,122,146,104,251,210,114,60,120,85,93,235,23,132,185,200,46,225,58,185,30,23,139,234,67,231,176,36,70,216,129,111,57,23,74,254,117,89,199,41,209,178,61,214,211,184,105,167,86,249,49,90,42,123,168,58,104,222,200,67,41,108,0,17,167,116,177,110,201,116,233,182,36,97,100,6,194,14,109,98,123,229,192,135,60,139,212,178,229,24,178,75,57,129,64,124,38,73,23,182,0,233,69,40,62,242,69,133,151,96,88,46,115,166,144,227,171,12,67,150,150,224,205,128,11,68,98,7,65,199,98,217,18,163,103,246,75,237,111,191,192,188,237,204,240,118,109,98,193,54,170,132,185,37,96,110,213,152,18,190,35,50,82,137,93,149,215,225,221,42,90,5,238,158,171,51,61,216,167,102,11,175,66,32,95,200,136,58,38,185,31,31,7,154,137,77,199,135,129,68,11,138,218,56,51,63,138,232,178,118,35,168,128,222,75,254,4,133,240,20,138,225,42,242,179,147,238,252,236,171,207,216,158,161,187,121,28,211,191,97,168,90,83,211,109,149,65,124,180,9,172,11,247,233,144,178,35,236,201,59,110,14,121,70,14,224,61,254,78,212,28,174,65,117,240,197,140,63,81,231,180,236,142,119,35,45,55,146,227,92,243,89,103,227,113,113,7,241,196,218,216,222,133,210,176,201,227,29,129,190,164,242,224,9,230,82,122,179,114,75,246,39,15,229,149,39,223,54,20,209,236,251,52,201,186,78,73,37,151,126,3,228,78,186,96,42,131,8,164,251,31,66,192,181,12,97,55,186,77,32,219,199,151,33,3,42,85,29,142,29,6,107,115,68,114,214,114,140,199,143,20,245,129,9,78,83,246,169,65,41,122,99,69,204,115,173,8,254,95,66,163,162,48,175,244,113,209,100,147,112,188,220,233,113,5,212,201,138,91,38,191,72,7,99,178,116,234,92,48,244,0,211,154,27,247,206,232,89,85,99,233,132,72,85,200,139,238,153,179,24,123,99,134,246,142,188,239,9,157,112,162,234,185,118,245,59,130,224,204,31,163,171,38,159,221,225,99,216,177,58,35,104,109,10,125,89,23,53,56,37,68,165,189,60,83,249,63,161,240,70,141,1,210,143,125,157,56,227,11,24,55,38,168,16,119,213,155,223,143,131,175,37,234,125,238,16,194,101,201,158,4,110,18,210,221,84,87,14,13,169,250,241,240,1,12,205,98,246,198,75,250,239,249,104,97,127,57,19,15,104,126,28,59,196,119,32,32,82,17,212,81,175,226,118,175,241,105,177,135,71,82,187,16,240,159,71,37,41,230,115,64,156,184,169,24,234,219,0,246,117,253,167,73,143,69,3,130,245,116,43,177,166,154,119,212,153,47,46,26,192,155,252,200,241,110,201,195,252,231,181,147,45,221,62,85,89,150,72,79,230,174,245,52,49,209,202,184,143,160,9,190,63,249,33,193,163,53,123,237,31,46,225,42,225,49,158,14,120,71,133,247,37,52,27,195,168,0,173,254,175,48,203,127,136,142,20,140,58,102,224,52,13,72,195,143,146,84,91,160,228,92,126,63,39,81,150,207,232,13,28,22,22,113,169,45,140,23,5,46,155,127,197,116,25,54,226,104,89,169,95,100,83,211,41,119,115,107,60,190,170,12,213,173,189,220,228,10,211,105,116,245,166,208,229,181,165,201,68,170,57,36,97,78,110,76,75,65,230,77,138,17,146,196,148,196,16,237,121,105,24,158,75,121,236,185,205,129,31,100,68,181,179,248,183,65,29,74,96,126,223,176,27,19,62,148,147,12,48,70,173,22,7,123,162,216,137,16,123,171,81,196,100,84,138,92,119,3,209,28,49,46,184,35,78,201,26,213,233,176,139,204,161,161,100,134,151,46,27,220,236,243,154,104,171,179,29,24,244,219,213,4,109,217,17,167,110,219,11,225,255,47,80,164,122,91,85,104,133,179,78,39,122,132,12,176,53,220,175,184,93,42,5,93,129,217,176,225,1,179,77,53,121,239,203,231,143,218,94,107,129,31,11,195,254,148,78,105,60,149,153,223,20,120,153,7,211,141,71,154,236,170,254,85,202,104,196,108,18,145,215,252,129,244,163,252,137,151,112,146,157,1,59,187,240,13,15,2,216,118,65,35,126,38,27,221,174,235,245,160,106,120,196,95,105,214,48,54,136,226,74,65,88,37,3,224,245,60,140,2,150,249,134,212,251,59,123,169,14,76,79,118,67,227,62,202,182,40,50,114,7,24,44,54,254,33,251,230,193,198,191,167,178,228,71,214,100,187,93,9,99,58,230,102,178,170,160,39,178,130,14,57,7,70,171,249,174,14,35,35,120,237,233,152,182,162,97,118,134,142,150,24,7,159,154,144,20,178,175,155,125,114,58,253,140,118,189,3,236,201,17,137,170,158,6,138,214,209,52,137,203,102,157,11,99,113,92,97,55,117,153,111,20,219,251,13,105,77,46,143,89,53,195,147,116,53,124,195,182,95,154,49,226,94,206,124,56,128,210,109,131,196,167,229,110,5,138,241,184,84,170,48,209,20,77,49,194,144,208,224,23,8,82,52,152,83,235,136,168,48,59,7,125,42,229,139,89,170,227,83,9,67,233,174,188,101,17,74,229,208,35,149,23,105,183,73,116,1,80,193,46,164,25,242,129,1,17,88,87,87,94,55,96,126,151,60,35,202,219,9,3,222,161,131,34,149,198,202,198,131,167,91,75,106,85,22,230,193,8,201,156,81,226,164,111,44,147,161,162,209,240,123,26,148,30,161,104,16,29,236,170,204,149,74,126,34,109,24,139,125,1,32,228,137,89,30,201,147,146,189,177,123,185,72,228,107,91,49,121,163,27,243,72,155,29,183,58,67,212,196,210,201,58,31,102,67,158,141,70,175,80,213,3,99,198,124,34,110,94,209,77,20,85,45,162,82,18,61,189,203,199,56,131,228,230,7,53,226,247,217,35,66,115,37,68,130,210,200,156,186,44,33,11,229,31,84,159,92,194,52,14,158,187,179,106,80,194,179,80,226,202,110,147,204,167,44,63,158,49,55,80,115,164,46,156,244,58,137,134,55,253,220,75,9,103,136,249,242,3,215,220,53,123,17,75,112,40,131,105,76,0,16,17,245,242,195,47,165,106,200,206,26,130,189,65,203,2,99,181,5,143,191,100,128,52,249,154,169,127,159,85,163,175,105,201,79,170,124,33,172,15,229,166,146,194,104,108,129,91,132,33,195,224,4,116,61,113,89,52,79,251,121,2,32,71,98,121,115,214,245,87,160,16,97,250,177,149,55,39,223,212,203,76,231,248,127,176,129,187,75,9,209,101,237,148,65,111,200,193,164,44,66,237,159,220,85,84,91,89,208,128,237,151,180,31,151,237,151,16,114,221,155,43,42,4,83,34,238,79,149,66,231,157,222,132,11,145,104,170,56,236,84,248,183,36,85,4,10,143,170,141,177,87,7,163,114,225,72,248,238,122,146,203,203,157,4,155,198,245,193,60,218,180,175,34,89,80,195,35,71,85,234,238,86,77,49,244,128,157,230,211,30,114,38,88,35,242,190,254,27,132,194,18,236,121,228,133,95,97,44,236,154,28,64,235,14,62,141,6,104,2,239,196,0,239,190,200,189,55,225,88,118,166,28,3,155,39,73,135,166,250,86,28,103,243,78,21,135,177,206,135,183,141,13,148,181,253,155,176,98,53,113,191,110,156,23,111,210,0,12,145,6,255,146,80,247,0,74,171,33,213,96,90,118,193,89,208,79,47,247,61,246,11,199,235,65,231,27,63,41,110,254,129,80,132,0,167,84,59,171,175,164,131,185,207,179,36,207,187,236,180,205,188,150,112,119,170,82,180,155,78,6,33,163,196,74,97,85,204,95,48,248,81,22,74,219,228,3,163,28,111,155,134,69,37,9,187,242,25,75,186,8,17,151,196,130,59,118,14,82,207,194,129,82,65,199,147,72,96,117,243,22,125,145,219,206,184,153,41,144,219,98,96,155,34,94,181,44,163,237,168,33,89,151,218,192,247,57,198,126,236,197,141,63,109,159,157,29,83,185,46,181,8,73,42,95,252,161,116,224,219,172,169,119,219,52,46,170,69,178,172,93,174,0,45,81,139,114,181,102,240,100,159,66,137,156,200,175,244,173,51,117,206,244,24,77,6,23,82,12,37,118,160,225,85,183,69,79,100,126,129,93,155,18,95,145,39,32,118,241,90,236,152,14,20,126,31,234,84,34,120,172,90,243,50,162,34,238,83,91,24,255,99,225,240,27,114,166,100,243,207,98,170,111,107,224,19,79,177,203,231,135,126,205,13,231,108,153,215,16,143,6,18,244,71,18,188,143,224,169,189,54,129,185,202,121,10,142,246,219,251,81,92,184,115,207,55,223,23,9,172,6,80,2,236,96,4,51,62,54,135,46,10,0,229,235,188,235,218,127,115,177,136,157,40,2,71,146,32,245,200,137,190,179,220,117,208,242,197,14,183,79,124,35,171,203,89,139,208,30,50,32,249,148,242,236,98,48,88,255,143,25,1,235,159,210,127,229,219,6,20,19,41,23,220,116,32,214,217,7,197,244,101,247,93,18,117,151,140,84,68,104,42,232,36,226,57,55,57,181,128,52,6,203,130,54,199,103,197,158,184,138,127,61,223,65,111,57,25,181,72,139,155,65,139,48,15,128,95,194,241,163,12,246,39,191,53,212,114,194,90,65,109,13,121,48,171,160,68,35,192,251,149,193,182,207,178,158,107,32,192,59,214,166,145,205,76,194,17,236,248,105,195,184,201,91,214,106,71,163,206,253,189,15,166,160,158,55,182,108,213,82,244,47,221,194,227,48,139,93,104,165,186,46,214,47,63,142,36,158,192,116,253,133,77,50,45,85,208,33,203,120,156,6,55,217,53,210,131,30,194,170,65,32,80,32,81,218,104,125,77,236,131,42,23,51,41,208,230,40,175,127,201,126,254,209,89,221,187,181,101,185,235,139,217,248,49,187,232,192,124,28,52,88,70,236,155,38,60,43,157,178,180,45,203,113,4,9,67,86,60,136,52,5,61,152,126,254,205,152,68,61,64,58,226,75,218,19,204,177,16,138,148,243,180,234,110,6,134,194,139,167,50,151,95,62,160,137,209,208,255,81,199,177,240,114,1,163,160,235,235,172,203,57,245,240,94,121,56,11,132,16,23,152,180,38,90,26,107,103,77,223,70,133,160,220,55,161,159,238,135,127,195,39,208,86,53,94,195,241,255,207,90,238,9,252,64,51,154,107,238,114,42,193,58,242,19,108,172,209,86,71,42,197,80,100,152,114,254,57,174,37,64,50,36,160,251,173,106,84,18,16,170,209,101,166,151,240,142,96,134,97,50,207,93,244,231,22,49,72,181,188,188,85,53,41,160,158,84,157,23,30,169,226,115,33,73,115,107,143,0,226,138,147,191,74,190,144,231,29,158,45,154,232,182,228,53,105,112,118,75,176,179,123,111,233,14,139,90,157,138,223,14,191,88,106,91,191,149,119,119,125,12,238,211,244,188,43,214,146,153,165,147,172,221,81,131,160,19,124,234,236,188,144,176,73,96,127,208,169,247,17,186,160,163,61,186,59,233,72,217,58,90,43,43,23,250,105,188,236,66,19,98,125,250,90,130,162,167,174,46,218,37,184,26,92,237,34,0,26,104,74,167,221,23,105,113,9,187,125,231,185,93,92,121,93,23,185,54,19,90,235,249,3,121,58,43,88,53,140,51,45,206,210,228,223,67,147,216,82,11,167,178,164,218,132,152,116,134,84,112,15,165,106,15,116,46,222,118,186,76,133,157,255,99,27,35,96,230,14,223,36,164,244,30,234,71,169,225,124,239,103,239,185,44,71,223,241,177,16,211,173,64,220,127,244,65,244,249,195,214,90,121,43,248,177,241,128,96,74,224,104,16,53,79,225,14,219,175,78,129,103,35,184,131,156,66,49,75,196,237,145,109,124,157,74,188,157,84,32,153,170,210,235,165,6,155,60,118,114,50,169,40,37,1,220,122,220,107,20,39,19,238,244,128,227,140,103,0,179,250,11,140,38,165,57,63,111,193,84,165,175,223,21,24,232,153,190,211,114,99,96,103,146,32,24,107,66,117,93,27,243,49,114,246,219,30,34,20,17,69,183,243,131,101,22,123,146,89,58,14,130,29,141,36,211,54,162,164,189,208,207,2,157,64,29,178,133,166,206,71,226,123,104,195,207,127,14,140,247,187,212,124,199,222,83,46,134,206,111,75,190,63,73,82,47,139,200,197,11,130,44,168,239,104,124,162,31,115,106,15,77,72,8,188,215,102,185,145,177,146,105,215,243,128,236,120,202,35,200,18,3,56,41,51,228,233,136,75,253,209,15,226,133,173,67,184,30,89,158,18,91,156,153,18,111,152,178,1,79,85,158,151,216,76,58,134,155,146,49,89,17,51,188,208,128,156,11,43,131,131,106,12,149,63,166,121,16,63,219,137,51,65,222,5,172,189,253,110,113,53,167,226,44,245,31,50,38,174,100,68,22,13,112,212,36,155,239,195,60,53,18,123,223,198,86,22,195,153,183,238,240,84,186,32,5,221,42,82,204,140,146,40,142,221,64,66,150,70,55,47,30,39,14,91,230,39,190,250,204,44,92,192,48,150,46,192,2,42,75,126,145,237,31,191,38,153,131,36,227,179,79,231,201,9,204,104,33,64,247,81,36,153,134,244,72,253,218,167,247,131,248,178,75,238,207,226,79,244,209,92,176,76,70,26,233,159,72,80,240,245,86,236,211,60,129,147,52,202,224,10,121,136,140,72,97,73,10,133,96,120,170,207,50,34,150,192,32,223,232,196,218,17,88,13,218,31,177,119,20,156,206,58,133,152,213,248,174,186,249,107,70,175,113,37,10,115,145,51,107,100,20,219,82,204,77,140,219,219,169,215,58,48,94,235,31,79,145,66,12,48,214,3,229,197,44,184,188,88,27,187,162,100,106,211,186,207,12,7,55,129,174,102,0,79,203,232,178,166,41,96,67,20,205,236,10,17,185,214,114,166,94,180,205,186,114,55,253,184,106,217,46,50,15,196,129,214,56,81,178,117,165,228,136,107,226,194,252,239,232,52,189,121,119,33,227,225,214,234,74,40,173,225,105,36,9,32,65,235,127,209,218,119,230,246,90,85,92,208,117,25,145,241,125,158,150,196,130,194,200,251,49,170,85,124,87,213,239,96,184,96,197,63,244,187,217,215,49,3,224,114,164,10,22,251,65,108,238,13,29,254,18,139,129,219,58,169,151,73,96,64,221,26,16,12,14,12,78,9,203,11,80,73,221,118,103,173,1,169,193,215,109,126,166,137,12,12,135,17,81,209,32,12,131,60,0,153,66,201,121,182,155,39,109,173,1,186,45,253,219,88,63,179,91,22,106,108,66,107,17,105,97,59,6,133,136,82,129,125,190,184,234,131,23,198,146,94,243,204,25,190,50,160,81,176,220,38,215,41,120,112,38,74,163,171,24,106,116,214,231,194,77,99,71,195,47,141,134,111,103,119,122,241,34,5,170,123,150,232,85,63,156,112,76,202,78,176,136,79,161,164,245,223,119,235,27,8,99,121,57,0,225,90,143,129,173,209,102,133,158,64,233,181,113,212,237,35,132,15,88,36,85,226,152,217,11,16,251,213,25,7,85,125,48,155,221,141,133,205,66,237,6,5,241,72,247,133,199,177,78,236,71,27,110,205,207,241,40,22,141,156,101,179,172,227,30,248,161,147,84,177,176,26,32,103,36,110,30,67,137,223,121,255,110,247,94,76,30,149,83,111,96,72,165,93,200,58,207,176,213,13,29,75,187,45,112,179,43,234,213,242,216,43,249,33,207,40,167,96,46,219,167,44,111,57,183,96,243,201,5,215,73,106,130,134,7,142,153,17,97,126,88,35,57,154,246,15,16,48,120,187,131,106,242,11,250,99,54,230,135,88,172,62,208,30,127,145,236,44,247,246,202,229,174,206,139,144,172,167,141,73,106,163,33,202,57,80,76,67,219,18,99,153,119,22,223,8,132,90,173,119,88,241,34,158,228,149,129,248,73,110,153,176,170,26,33,117,151,227,204,107,181,26,21,245,164,236,219,77,199,199,35,205,68,49,148,238,100,242,214,99,155,100,23,181,56,99,13,119,225,107,153,143,182,246,225,208,95,196,75,114,87,98,134,84,115,210,91,16,159,38,83,255,6,141,147,176,178,28,7,98,154,157,117,22,186,222,203,229,195,97,78,111,21,1,209,7,216,220,49,206,103,113,12,92,248,125,213,205,208,125,25,23,255,131,122,18,244,102,110,19,246,57,97,29,160,122,12,249,191,178,249,218,202,196,118,95,227,2,202,72,253,166,224,126,142,247,255,235,17,182,40,239,72,49,69,198,190,146,45,197,143,72,232,60,106,114,24,207,64,199,21,148,63,154,255,94,65,161,221,130,35,137,115,115,180,84,241,144,61,126,156,106,22,242,150,187,185,206,193,114,109,233,188,162,195,80,84,37,148,76,38,233,82,107,55,196,65,244,142,66,169,247,79,119,3,176,143,31,254,163,250,36,254,95,244,199,37,243,80,12,199,218,35,41,133,113,33,14,19,65,68,109,255,12,46,255,36,190,184,245,158,28,243,54,230,255,252,10,28,140,185,137,52,36,177,174,246,253,228,33,46,4,171,48,142,104,247,44,43,68,29,108,218,170,183,172,241,193,73,207,219,37,138,1,150,130,219,251,45,165,77,163,56,41,211,48,28,136,245,232,57,137,129,92,21,128,45,154,238,208,32,231,214,120,74,179,72,201,37,186,206,84,50,7,123,49,12,239,253,65,164,149,178,102,109,53,34,240,96,200,137,6,135,145,49,172,151,73,182,67,200,127,30,211,36,85,185,165,56,97,54,221,209,90,70,22,143,152,129,15,204,59,5,143,171,180,132,244,145,20,44,11,142,181,72,223,151,147,26,241,164,157,222,7,97,79,43,35,103,66,163,25,155,118,174,109,181,98,111,56,136,55,63,81,51,89,250,61,148,153,110,132,172,218,99,18,104,242,83,175,53,197,209,126,182,44,53,73,229,104,21,252,214,227,27,176,170,31,200,156,251,40,253,90,104,145,10,1,175,235,135,77,56,137,11,51,99,233,59,250,122,62,196,2,245,142,86,59,143,192,123,130,214,245,182,157,134,228,82,199,243,29,167,83,105,75,4,236,116,174,50,18,89,242,200,87,109,23,221,184,42,3,82,80,103,135,218,190,7,129,98,180,64,149,196,181,217,136,28,58,56,53,14,16,248,30,82,197,85,149,53,2,112,81,243,53,131,126,174,187,3,237,209,3,20,9,246,22,3,194,201,118,169,89,116,66,199,66,16,175,193,47,238,65,137,126,87,148,144,167,191,216,137,23,120,162,24,80,68,168,161,148,167,6,137,56,1,160,59,75,181,56,92,175,90,233,7,212,173,52,242,167,91,64,194,196,220,18,71,186,221,224,84,47,76,156,55,190,180,102,18,21,27,55,125,249,219,154,48,54,210,58,72,73,154,78,48,73,105,233,200,178,230,208,130,172,18,160,79,130,20,166,83,203,232,203,108,136,211,228,152,192,103,222,8,46,245,50,29,25,234,254,228,47,202,93,242,41,33,139,115,212,186,141,90,222,177,4};

// The scrambling tile of 128x128 pixels.
// Each pixel contains an optimized 8d key used to scramble the sequence.
// The keys are optimized for 128spp in 8d.
static const int scramblingTile[128*128*8] = {186,177,231,241,225,108,249,27,35,51,24,255,248,108,208,189,32,65,235,177,118,194,116,190,252,50,181,227,10,234,191,197,242,53,98,196,25,55,254,115,224,186,254,229,9,56,146,221,109,85,203,252,86,37,45,120,46,57,239,97,28,219,45,255,25,95,141,18,81,19,134,168,42,77,122,18,6,60,136,123,63,160,180,61,145,59,58,42,49,75,138,94,237,154,39,39,4,73,136,50,225,139,192,121,83,90,148,237,61,222,163,121,2,127,87,138,247,148,3,5,239,111,175,240,202,44,227,89,130,7,194,94,231,143,105,113,46,78,163,135,245,106,209,107,44,7,254,5,149,153,58,40,50,9,166,174,140,147,155,22,31,220,232,57,253,81,226,255,14,209,19,190,50,152,145,140,136,69,48,4,175,181,240,137,110,233,189,144,161,200,235,175,90,79,56,233,24,231,21,234,60,151,66,34,33,21,221,6,161,211,239,19,159,38,46,24,80,130,251,200,171,33,165,168,205,126,52,106,64,118,153,84,57,16,105,21,60,65,28,236,10,176,151,10,70,195,62,113,130,124,117,115,17,165,228,12,86,137,154,180,176,188,208,246,164,39,183,198,45,139,4,251,187,4,120,161,211,36,130,191,21,35,39,37,14,190,140,182,149,155,33,14,224,198,179,136,75,0,26,53,25,136,16,139,65,238,80,1,202,166,209,35,74,158,158,54,222,181,185,120,121,23,99,117,85,217,98,55,224,163,145,32,186,38,99,110,226,136,154,231,189,30,16,193,125,95,95,158,164,173,89,170,40,199,90,42,176,244,133,158,157,115,33,88,247,132,47,151,0,148,166,186,11,228,43,189,10,72,169,126,233,112,86,243,80,206,48,64,202,89,95,3,245,27,241,106,54,191,143,148,243,49,183,41,36,122,84,4,26,75,194,3,131,119,189,116,243,80,197,18,52,117,70,82,197,202,204,0,196,252,13,12,49,107,23,203,200,150,68,109,182,175,61,177,8,226,97,181,44,196,58,2,152,154,73,41,38,48,73,164,100,187,250,48,245,131,167,151,172,231,9,153,161,42,162,131,142,228,249,18,1,130,51,60,67,138,216,64,19,230,213,195,51,84,190,218,168,57,30,36,153,109,186,195,11,36,6,214,104,98,74,170,88,255,6,32,105,191,222,233,89,238,151,191,17,225,234,228,160,229,112,247,5,14,209,242,210,233,186,98,102,208,100,232,10,28,92,77,119,218,225,26,203,140,14,224,197,219,212,157,158,91,27,239,9,199,40,214,207,42,124,82,27,9,146,197,198,56,233,72,1,202,35,43,167,121,73,114,177,202,60,21,106,28,42,119,36,153,35,177,16,28,211,38,170,159,227,219,219,129,72,231,164,251,236,100,139,157,85,54,179,227,206,230,109,46,176,190,77,1,6,186,95,116,124,143,24,62,114,212,201,237,31,154,119,35,192,159,150,20,126,195,132,226,16,28,206,23,74,212,159,208,186,155,178,64,196,34,96,184,147,150,161,70,27,207,167,87,180,155,50,73,0,151,104,7,181,136,18,195,56,182,101,152,52,30,73,176,134,44,94,0,80,26,161,153,145,39,155,149,251,116,177,148,99,31,45,159,157,216,29,13,16,215,13,42,6,33,42,227,52,74,81,155,167,226,223,14,8,146,13,219,98,209,128,111,124,59,13,157,111,38,49,184,83,4,156,232,59,204,21,70,65,13,130,253,205,207,32,187,142,26,41,246,158,123,224,49,205,149,53,40,196,107,202,48,252,95,250,187,197,52,2,189,250,191,206,16,12,49,38,69,73,241,69,217,210,24,50,67,172,148,168,209,219,91,205,48,87,192,237,98,121,252,200,27,44,46,135,234,50,206,219,196,221,101,79,83,218,96,77,229,193,176,158,67,114,227,170,73,205,224,128,118,195,215,103,79,202,108,161,22,113,6,239,181,102,210,101,20,209,220,234,240,164,8,183,79,123,95,244,244,42,213,23,17,19,90,197,73,180,1,152,23,21,78,36,114,23,252,137,63,2,85,228,10,57,99,216,27,7,51,41,242,14,72,193,3,197,185,187,210,60,74,113,136,206,167,71,143,189,129,58,77,62,206,184,6,252,88,246,132,146,189,170,98,154,223,47,21,157,178,184,33,186,9,44,46,160,153,161,37,214,42,83,100,223,117,114,214,1,24,175,246,75,188,135,190,13,17,194,135,66,0,1,229,3,157,84,81,78,179,52,80,56,179,61,62,132,217,250,92,55,184,139,52,182,108,5,177,151,128,110,237,30,21,99,191,152,122,108,114,155,24,116,184,240,223,30,23,186,190,68,172,106,62,26,157,253,53,21,187,189,28,213,85,190,233,184,201,120,28,199,87,138,229,239,56,177,115,120,129,198,167,108,66,66,73,43,110,246,76,40,75,113,206,139,13,41,234,70,217,188,229,18,208,54,113,8,215,156,17,93,71,71,221,32,40,183,20,85,200,140,220,244,39,151,246,29,23,189,229,239,169,255,178,215,202,181,169,112,235,10,66,232,34,178,125,114,152,208,153,249,131,178,26,211,148,204,224,240,199,116,171,249,130,190,253,228,26,98,161,254,144,17,172,99,165,180,89,26,0,50,225,199,148,248,242,32,93,195,38,225,130,87,253,242,147,239,147,157,156,223,196,64,167,153,126,13,219,145,238,67,152,176,45,19,249,253,202,80,156,56,188,208,127,244,213,112,35,183,88,62,237,201,217,56,66,160,75,119,231,95,214,50,3,234,100,11,212,71,167,49,22,14,82,135,5,30,187,209,150,36,193,116,24,144,207,192,100,27,19,179,26,181,54,59,2,23,7,60,197,169,60,118,239,146,45,23,245,159,114,25,154,163,147,81,24,137,19,89,75,122,181,33,28,70,133,155,50,239,223,186,20,205,211,157,36,53,41,225,129,8,230,152,28,24,171,107,7,145,176,69,9,39,28,211,67,160,135,84,15,93,115,129,123,74,130,214,205,90,67,208,71,171,129,171,239,129,57,217,20,172,28,168,163,201,23,247,41,170,50,107,24,159,221,1,174,0,91,123,116,255,216,180,87,10,79,28,81,249,232,181,125,0,199,104,89,183,166,24,216,198,254,138,16,167,158,145,130,153,168,179,199,211,19,189,238,142,249,209,213,213,58,40,28,89,252,200,50,46,79,47,82,66,60,226,56,79,61,135,234,164,17,183,27,144,101,117,181,226,23,101,112,149,45,122,29,236,81,106,22,158,58,133,200,136,84,237,197,219,85,2,254,157,222,249,79,118,97,135,102,196,115,53,86,34,73,21,43,111,210,44,80,90,12,120,153,88,223,39,162,39,146,84,112,75,193,194,135,172,142,16,80,140,245,177,5,173,152,8,153,244,14,123,231,218,179,72,231,253,2,124,246,213,233,119,92,30,141,72,229,53,245,208,150,190,237,41,34,10,205,101,249,238,160,91,194,52,35,95,196,134,188,92,205,136,102,171,204,83,195,217,208,222,234,122,91,104,255,216,253,197,194,113,225,186,29,4,11,64,149,96,234,147,158,26,71,76,158,245,21,114,208,16,5,203,159,246,119,123,201,149,190,169,230,238,60,81,7,119,75,142,78,107,216,107,198,17,107,127,40,0,71,106,18,169,97,222,179,182,186,83,64,196,22,236,173,229,165,113,17,1,23,156,189,69,85,161,102,9,137,74,113,167,192,112,247,118,139,79,223,180,237,26,242,75,250,128,33,147,194,137,154,227,9,96,85,9,220,147,184,132,247,171,153,135,123,28,90,21,10,50,75,114,164,188,253,104,127,72,227,201,152,189,170,155,130,112,228,169,52,77,173,134,110,158,149,102,2,191,133,196,39,221,149,115,32,188,48,27,28,222,95,15,220,240,123,29,44,195,130,221,178,122,177,135,145,150,183,148,220,132,230,199,69,99,48,133,192,152,236,113,76,211,111,65,159,8,211,36,55,186,68,221,155,40,206,112,88,125,31,213,136,86,206,242,238,227,4,169,140,36,202,28,247,134,218,188,130,116,250,140,79,105,93,248,123,218,101,16,10,223,61,167,189,208,20,199,226,237,92,158,250,0,242,182,65,117,163,136,254,100,1,180,26,51,222,65,142,28,50,61,223,80,209,179,237,7,25,209,127,66,251,120,64,150,105,54,82,32,55,155,242,88,202,68,164,211,110,135,63,217,79,153,177,0,219,147,233,122,237,84,154,246,81,139,61,154,51,221,53,231,93,61,134,202,20,101,194,7,215,189,31,168,156,231,46,231,119,229,233,90,153,63,127,101,155,4,9,157,115,157,233,115,202,204,202,68,118,59,177,38,102,1,216,72,10,19,243,25,24,179,116,230,137,20,8,17,13,160,184,51,142,71,155,171,191,135,67,253,5,97,75,224,221,155,110,45,2,69,170,145,206,35,135,125,40,227,4,49,34,236,55,46,166,127,4,194,198,158,56,188,102,241,4,113,79,60,44,187,80,161,100,64,252,85,194,231,183,136,101,31,16,58,155,43,94,6,149,84,85,195,109,3,0,46,92,123,85,156,45,83,223,158,147,102,81,194,40,163,99,3,148,229,150,53,126,29,7,74,73,231,210,44,130,141,25,173,126,79,15,212,219,220,237,157,166,64,31,26,33,219,62,148,175,8,97,215,110,13,251,17,44,247,204,203,130,15,166,147,140,255,1,200,37,162,97,96,93,225,97,55,114,107,238,3,75,216,149,159,251,22,141,174,32,215,29,4,41,223,25,62,198,53,115,62,6,38,99,60,187,99,30,52,91,130,194,43,54,40,170,13,203,106,231,165,54,158,238,216,141,107,92,115,198,23,153,232,150,25,73,2,202,151,19,224,116,255,137,236,82,216,95,214,30,199,160,245,157,234,80,217,239,242,88,6,68,38,169,111,254,108,181,66,142,184,116,163,255,172,223,252,131,4,250,23,232,79,218,254,255,112,173,146,199,142,232,158,200,105,118,138,233,193,232,69,176,164,86,151,19,70,255,47,65,60,137,204,80,148,210,75,19,65,232,36,31,248,38,4,199,53,159,110,211,246,191,30,68,164,96,111,34,182,196,63,16,64,131,203,212,170,32,19,178,243,212,206,102,170,15,239,177,73,229,52,74,166,49,97,131,157,35,192,111,38,6,223,140,126,131,23,176,132,5,215,145,253,107,212,124,9,14,13,166,232,102,105,149,229,100,163,0,212,32,178,112,192,99,87,250,205,183,242,158,67,223,2,146,228,23,105,112,122,1,60,235,45,17,80,148,39,139,86,34,52,31,205,148,5,134,230,209,7,82,152,145,242,152,5,8,9,160,164,18,58,108,3,125,200,244,249,76,62,212,61,44,190,14,0,248,5,63,176,213,244,45,51,102,116,140,135,24,85,235,227,188,97,197,131,11,162,168,31,136,180,84,236,147,177,18,134,117,86,184,240,158,37,58,113,119,158,190,36,139,55,54,164,202,66,255,160,199,87,51,204,225,135,20,215,198,157,155,145,229,92,23,118,223,139,158,163,30,9,23,148,24,207,27,237,218,20,150,153,17,199,88,13,164,131,210,114,158,33,206,124,160,131,148,172,58,33,15,103,161,246,167,50,123,36,140,130,22,210,32,235,163,45,84,131,146,203,223,35,213,35,25,88,216,57,237,112,177,6,225,163,188,52,226,255,248,204,104,84,213,130,191,127,216,211,240,106,163,102,161,157,64,13,13,123,92,20,100,75,87,216,246,105,174,197,160,89,212,245,74,210,243,111,171,131,91,228,199,94,163,25,235,153,245,38,98,178,230,159,146,124,64,122,254,134,56,146,1,195,87,219,205,124,102,201,0,107,161,211,150,196,176,128,146,232,13,138,138,250,126,136,211,194,247,130,146,253,4,224,152,123,204,168,144,247,28,145,244,241,181,43,29,114,45,73,202,84,176,67,98,139,81,182,163,87,160,176,242,180,10,6,104,205,165,213,49,156,144,162,240,255,0,248,175,141,152,76,139,124,227,44,111,76,48,67,238,120,152,72,198,154,197,157,150,55,224,15,97,133,241,143,63,213,31,92,121,130,215,56,185,129,208,94,105,9,104,253,244,208,193,170,188,4,39,11,187,43,73,126,251,217,154,160,250,45,190,49,133,75,244,1,24,82,103,145,132,237,215,0,33,83,190,166,147,64,253,83,219,27,59,208,85,101,238,192,109,198,12,153,126,28,192,209,186,192,209,171,101,222,44,150,42,195,151,209,175,35,203,25,18,109,54,188,36,84,161,38,195,124,86,133,14,194,167,2,44,119,240,222,74,193,135,125,42,105,251,7,130,129,160,70,200,121,251,187,17,146,100,246,236,106,182,10,33,230,179,251,250,163,89,7,39,18,0,209,245,176,101,204,217,245,8,226,232,154,134,190,145,175,38,214,61,75,119,114,217,253,167,211,43,193,118,19,193,186,110,60,251,49,97,84,245,177,215,137,97,7,155,42,161,145,226,91,217,73,184,247,240,83,73,115,251,17,157,234,250,46,176,230,243,133,44,163,199,61,95,184,149,251,219,248,243,32,162,13,202,171,225,6,136,96,25,10,211,96,209,201,160,118,199,14,91,42,115,111,93,207,106,108,90,203,90,170,169,26,7,250,86,133,160,83,164,190,31,212,2,226,27,37,70,190,125,185,45,83,174,244,100,201,97,19,121,85,161,0,171,231,149,126,26,111,90,158,194,252,96,35,7,239,92,203,220,237,109,57,114,88,104,56,49,128,55,55,69,90,61,212,238,26,189,60,95,238,8,38,98,137,69,98,201,252,14,118,87,74,44,72,212,81,82,39,61,223,128,126,82,48,108,215,253,168,81,44,13,34,230,208,206,137,17,47,20,220,116,200,240,180,145,41,32,131,105,10,198,209,226,109,104,28,182,149,110,188,0,120,142,108,122,19,240,96,204,160,188,82,132,23,185,9,36,133,177,169,37,152,23,17,209,6,186,144,48,6,60,188,48,132,154,43,191,219,72,4,5,24,53,163,145,218,134,8,130,114,229,131,53,190,4,87,76,52,20,147,48,212,215,92,195,36,115,87,107,223,168,61,171,36,46,50,161,125,197,70,216,253,133,197,166,244,27,58,22,8,100,144,40,237,39,52,173,9,70,14,86,170,252,239,43,198,60,181,76,188,247,211,204,193,128,33,55,219,237,211,188,126,31,59,150,39,240,213,181,226,60,15,202,80,65,218,172,5,248,174,57,170,171,186,21,172,48,155,69,51,252,12,29,5,222,159,217,231,128,22,38,168,212,16,231,66,113,18,81,123,208,80,237,246,123,227,251,24,69,120,236,251,107,252,217,64,212,47,6,99,213,37,102,135,19,30,4,66,204,62,92,143,215,0,5,113,134,104,181,208,153,156,14,108,86,98,45,94,213,113,22,230,12,40,159,211,97,111,56,240,115,222,147,125,108,211,108,197,165,130,89,65,42,221,157,226,172,152,176,172,12,90,236,234,188,70,49,238,126,159,140,14,84,109,26,51,100,152,160,148,167,47,222,31,223,8,129,233,80,63,59,194,18,234,78,210,15,11,45,182,121,93,172,255,171,70,67,28,51,75,6,60,124,16,215,230,88,115,248,3,178,119,174,2,243,117,43,87,24,218,86,175,62,103,45,110,54,93,118,222,223,161,34,10,236,17,38,201,213,66,5,26,229,11,229,43,124,226,194,42,97,40,93,206,232,104,243,191,188,237,204,24,31,11,143,162,129,95,52,116,29,102,72,190,11,116,207,111,29,47,95,38,26,62,217,247,22,233,81,166,5,33,246,80,21,183,136,150,93,163,166,154,22,105,188,224,68,228,85,254,23,142,219,141,185,7,160,185,199,93,6,46,240,6,208,158,245,165,74,72,44,67,164,133,241,102,68,118,174,72,225,201,6,240,138,56,89,209,160,223,62,104,64,33,57,201,156,132,227,95,219,20,57,85,181,156,237,40,173,37,35,35,188,194,235,178,72,58,44,245,202,71,18,135,183,29,113,51,117,184,129,215,20,249,112,22,138,2,249,212,143,70,117,13,91,199,111,136,73,121,247,120,55,34,229,85,193,76,189,89,242,63,152,157,205,103,13,38,146,5,226,9,106,110,7,157,207,41,159,200,220,92,151,121,254,44,32,254,107,247,1,211,72,44,178,114,108,197,238,64,82,73,147,28,56,232,165,64,28,170,118,122,221,164,242,127,166,127,119,20,250,214,150,143,25,0,72,184,180,160,129,138,144,174,97,149,113,199,56,19,89,2,211,103,163,176,41,61,140,46,101,247,222,167,33,150,178,130,106,57,167,60,80,77,244,77,26,201,144,62,96,73,133,178,156,60,148,89,82,245,28,40,182,191,48,156,44,63,120,211,184,178,47,242,112,130,116,92,247,181,183,189,188,134,195,171,219,96,230,173,52,94,245,3,240,36,35,218,90,208,237,120,121,15,190,5,130,187,233,111,116,245,106,145,99,93,219,192,35,198,144,8,142,202,56,219,228,249,109,239,135,5,59,205,117,36,209,139,58,184,16,198,11,98,170,81,154,40,77,248,5,135,171,194,159,77,139,155,222,165,166,223,45,77,217,13,145,174,188,113,148,194,0,137,170,169,154,62,219,29,95,132,167,243,166,3,61,14,187,59,181,160,192,3,97,219,236,153,228,236,3,8,55,248,180,146,237,130,95,221,73,24,70,170,191,94,112,149,216,160,110,27,42,221,3,169,47,242,217,82,155,202,100,88,199,35,225,81,251,62,176,47,190,185,195,93,237,8,12,28,185,160,227,197,198,45,13,144,254,65,175,110,199,202,160,133,23,153,169,30,194,113,170,233,41,113,20,72,255,255,204,150,192,20,30,85,209,161,125,21,218,18,191,71,247,189,117,146,184,167,161,78,149,17,218,224,93,205,247,20,81,62,108,110,147,203,171,14,4,39,31,82,102,49,31,1,127,72,77,219,126,205,7,215,32,236,184,236,33,240,71,221,126,187,54,225,56,32,187,64,20,177,64,249,193,45,234,50,14,177,251,239,197,192,218,56,6,142,211,220,178,147,205,56,78,126,145,59,215,21,51,97,183,146,25,241,164,136,54,29,251,226,6,37,38,9,69,211,89,119,106,14,57,83,249,117,208,71,233,233,51,58,46,188,108,51,227,202,192,152,18,28,238,129,235,178,191,109,121,213,248,142,119,194,172,253,219,62,65,205,115,60,26,196,39,102,41,97,111,58,173,169,159,209,137,177,89,102,223,148,28,213,148,89,147,17,48,127,51,220,131,144,164,186,151,96,5,216,157,128,76,168,109,158,64,9,232,237,77,133,110,75,101,79,24,144,101,211,150,142,78,93,23,21,15,162,145,42,128,73,18,148,17,167,162,249,137,38,20,138,61,215,184,141,19,139,22,215,157,233,205,153,231,238,128,159,62,234,145,63,60,72,227,224,74,21,94,253,9,21,227,239,159,156,16,230,217,113,13,22,207,17,3,209,151,152,145,182,57,28,18,203,72,96,163,53,91,66,77,186,120,156,100,165,37,227,94,196,92,45,227,156,123,37,251,202,237,171,181,225,209,234,151,3,216,48,17,141,147,17,248,1,73,169,163,140,9,221,7,219,132,247,167,58,73,237,5,51,71,166,87,99,78,23,163,61,252,252,172,0,69,115,168,183,69,6,94,156,28,241,206,182,230,195,105,59,239,92,82,240,25,253,214,170,48,240,5,231,5,133,93,187,121,225,164,110,21,14,9,191,246,192,59,149,79,255,58,219,167,202,241,130,129,246,252,22,238,156,185,201,158,233,90,109,251,171,244,107,81,154,110,80,133,144,169,151,224,14,139,197,45,97,144,28,54,101,76,196,75,236,13,45,43,21,78,89,93,200,219,80,83,29,93,99,255,230,19,56,247,9,224,96,171,166,67,124,30,219,96,220,93,206,126,93,228,77,214,93,210,182,201,63,206,178,18,81,202,62,176,201,69,89,213,188,196,26,171,202,207,169,212,127,181,224,186,11,136,247,75,8,187,17,89,134,142,34,175,168,191,124,16,134,219,59,222,186,125,131,12,155,24,133,7,60,80,148,9,134,16,42,179,70,251,113,103,170,243,84,0,139,68,133,81,215,213,99,233,109,124,104,111,24,159,215,176,44,193,245,70,154,97,230,242,90,42,208,95,104,116,177,219,65,221,120,72,106,241,222,96,52,186,125,109,245,19,248,223,246,165,51,82,239,238,138,132,208,137,62,146,228,187,143,151,156,248,114,68,80,197,130,130,28,228,11,234,237,250,108,232,176,102,42,244,31,43,203,44,138,161,88,36,64,36,13,243,233,188,69,43,50,48,164,253,22,69,96,46,116,191,38,49,209,94,120,213,224,209,144,159,51,125,127,167,186,18,106,94,84,71,174,24,148,196,213,227,20,153,109,194,104,236,138,149,196,5,60,146,123,51,220,68,132,61,204,129,99,193,106,39,110,111,178,70,34,118,109,113,114,73,201,42,107,164,251,240,65,183,212,81,73,115,164,112,246,231,183,159,205,34,145,179,255,48,56,171,4,164,155,175,154,102,182,137,57,25,112,137,246,131,52,178,9,175,9,148,247,144,225,77,80,11,31,178,215,54,35,96,172,94,154,198,214,149,31,87,185,86,157,89,199,237,174,99,252,127,36,211,17,18,65,186,110,185,193,185,202,50,142,184,36,183,47,198,39,151,119,189,50,118,187,223,131,153,36,208,34,107,155,210,46,158,252,19,205,216,246,112,79,188,4,148,182,157,131,129,34,61,93,53,205,171,28,199,175,9,93,18,170,202,79,233,248,31,217,153,14,104,67,252,128,223,220,95,69,118,43,253,178,170,191,51,87,113,112,222,114,171,30,10,17,134,52,193,112,15,204,36,89,4,249,86,186,248,14,153,126,163,132,179,217,147,65,150,239,82,143,185,228,161,10,193,243,123,41,184,62,31,198,150,192,11,30,97,15,201,31,103,237,78,149,245,169,95,153,58,253,154,186,179,181,115,150,200,126,76,245,79,201,9,200,35,206,69,69,156,171,156,228,247,252,206,224,144,5,180,57,188,53,218,65,24,9,172,28,161,115,224,10,219,251,208,102,172,123,85,253,203,239,214,159,108,115,70,104,241,92,219,130,26,45,236,147,212,181,39,124,250,235,239,67,210,62,97,112,229,248,232,198,228,30,103,153,182,171,209,93,119,158,177,149,74,12,131,52,118,20,202,71,8,33,255,4,85,224,191,111,103,28,16,227,122,225,239,97,118,65,167,71,46,95,160,228,176,235,102,11,123,178,195,152,49,214,79,61,8,179,104,203,65,198,65,41,11,104,177,100,143,36,184,77,12,103,232,49,196,33,41,39,15,105,159,193,189,62,55,253,227,250,4,85,157,14,202,166,154,144,12,90,97,221,255,250,47,239,0,45,134,237,125,193,179,229,226,62,111,224,231,22,225,109,26,36,98,124,70,30,247,138,99,96,10,10,13,106,92,132,123,50,17,224,253,60,109,128,218,63,217,180,75,183,56,1,132,55,109,151,110,8,102,175,253,117,56,178,111,103,157,55,158,107,123,210,17,95,6,133,142,200,191,129,129,6,118,69,86,10,49,89,113,225,24,85,91,135,249,250,102,112,203,134,64,238,182,239,121,7,57,150,67,208,142,130,12,141,73,143,12,176,76,141,113,173,233,129,230,135,161,242,22,86,81,74,67,48,3,253,170,0,60,98,62,175,240,135,13,84,123,94,37,93,44,186,179,235,28,100,199,199,119,0,152,196,22,237,164,131,68,165,89,242,148,31,152,252,82,200,101,234,121,6,116,47,250,130,232,143,98,163,95,54,247,24,27,40,188,58,87,69,119,29,62,4,183,255,247,68,86,9,222,179,3,23,245,106,208,30,193,190,212,247,66,31,225,25,71,120,248,99,110,245,210,43,147,240,176,27,202,237,194,226,42,52,77,90,86,6,206,245,1,61,228,86,68,251,1,41,3,109,97,59,252,87,68,62,210,136,242,121,97,129,89,44,196,132,239,190,108,151,128,97,4,141,224,200,78,148,101,97,116,197,158,168,255,167,141,223,71,63,255,59,77,154,171,116,73,177,120,93,0,166,229,189,39,25,207,85,181,102,240,51,251,160,121,38,191,89,171,156,152,180,20,87,138,186,182,62,82,252,79,247,132,126,182,15,37,255,109,61,2,1,41,44,255,72,90,88,78,235,15,213,55,175,64,191,182,186,97,200,17,117,111,181,188,161,203,241,36,116,60,213,203,150,79,234,5,74,213,190,208,255,236,188,228,195,123,191,190,35,21,38,4,255,134,213,225,36,0,15,204,167,100,50,65,60,110,151,111,49,21,21,193,101,105,34,231,162,231,95,60,16,71,176,220,88,191,68,183,49,97,213,168,142,184,196,53,118,188,134,134,21,235,207,41,127,173,222,152,58,247,81,54,55,89,137,164,61,36,102,16,114,138,188,135,148,136,95,63,163,135,182,3,115,107,249,127,13,114,170,11,176,252,21,235,220,254,172,130,184,172,20,106,67,75,38,145,209,131,33,190,99,151,136,133,98,158,107,63,96,74,51,182,102,47,94,159,72,16,25,135,157,40,254,111,233,65,73,112,122,50,230,172,132,193,144,187,172,242,196,84,33,40,58,127,32,0,226,248,83,102,235,188,51,170,1,104,85,245,191,66,151,163,182,144,55,251,59,185,40,30,50,15,51,207,143,57,249,25,6,12,45,197,145,122,78,73,117,57,105,186,101,231,203,213,73,6,21,244,253,109,25,171,33,111,16,213,36,4,26,98,78,222,162,145,137,169,178,52,125,202,115,156,148,149,223,112,243,63,182,195,12,208,123,148,193,58,96,34,50,152,26,139,219,55,41,32,90,189,23,154,244,168,226,132,57,216,25,146,173,28,236,64,168,248,25,162,119,153,188,97,182,201,9,47,197,250,253,43,143,35,54,120,221,151,57,135,125,132,99,255,159,43,152,184,0,10,30,17,149,32,112,156,16,242,125,4,110,138,40,223,31,94,207,238,155,48,99,40,133,128,250,100,60,145,47,17,169,174,140,249,200,194,76,29,218,116,143,156,92,152,69,71,217,205,69,244,127,29,198,207,108,72,78,60,142,207,152,52,23,179,145,8,116,161,206,9,8,181,171,217,106,165,238,32,112,6,166,201,76,50,138,166,110,16,69,238,218,213,225,152,120,0,224,104,143,190,245,38,143,9,206,245,66,17,241,151,171,226,111,57,26,21,132,86,162,91,242,23,86,22,158,39,253,168,189,11,48,24,14,254,245,34,251,65,146,115,142,52,202,224,83,64,132,47,78,131,114,223,72,145,64,53,10,246,239,248,23,167,21,238,10,168,236,35,11,136,112,91,65,175,83,29,152,44,120,66,157,193,76,16,190,192,177,112,153,79,103,69,71,0,211,164,8,225,55,228,206,223,59,114,131,64,149,214,197,209,223,196,44,167,142,203,107,233,168,45,144,122,85,129,105,219,38,70,158,116,30,70,140,65,22,104,148,132,21,84,44,191,107,151,85,212,20,22,0,237,76,111,246,23,76,247,138,210,125,117,223,238,28,166,254,208,19,211,107,253,202,162,39,234,165,14,176,54,0,189,93,71,173,191,146,54,99,67,221,96,182,187,198,9,138,154,76,106,212,200,220,55,129,12,65,15,163,181,78,105,17,244,244,55,200,110,21,172,63,134,78,22,145,55,20,206,196,4,117,228,148,225,251,10,244,68,195,89,135,11,172,252,211,57,212,93,252,224,120,155,211,110,122,90,94,234,237,102,26,29,129,94,231,248,102,65,25,151,31,106,112,236,209,35,222,174,70,173,9,141,104,31,1,124,102,164,220,8,10,4,1,236,143,5,151,128,15,21,198,201,28,162,231,83,226,119,6,109,152,61,206,157,54,23,131,205,10,55,13,130,129,202,0,46,213,45,214,116,8,128,8,137,130,65,211,66,214,76,69,191,20,59,137,142,14,4,69,229,91,235,148,6,222,36,62,147,236,225,109,40,201,253,94,204,166,165,226,181,40,55,70,43,128,30,208,221,145,76,24,110,241,26,138,180,115,70,205,232,232,168,16,89,69,182,223,40,203,201,166,107,42,79,192,9,163,70,16,124,37,95,172,120,171,88,211,247,121,131,13,206,43,206,211,172,206,15,28,108,168,116,246,109,255,220,31,0,250,189,185,135,94,141,219,49,109,91,142,30,250,194,224,164,158,177,228,105,178,214,35,3,46,135,238,238,9,220,202,238,168,233,252,238,216,186,205,74,15,14,171,189,135,201,231,201,189,146,137,53,156,112,229,98,23,148,94,111,154,36,107,127,27,252,182,110,152,211,229,39,24,89,111,123,178,134,119,145,109,18,204,148,69,30,19,245,206,136,109,152,121,40,2,226,25,247,54,16,157,139,182,124,238,68,222,79,80,183,188,198,0,12,1,219,111,74,62,252,187,115,95,129,11,76,194,228,183,54,174,127,85,182,83,220,28,238,55,120,56,156,68,21,131,6,56,170,98,126,199,164,101,243,218,75,243,226,62,79,222,29,214,85,73,225,47,146,17,122,88,86,108,224,162,232,1,253,191,229,118,55,224,227,34,123,75,227,48,120,254,30,81,129,76,195,253,82,146,229,98,72,254,66,47,150,37,98,228,231,31,119,51,164,124,115,177,226,45,50,10,151,210,239,236,226,88,50,87,100,105,141,109,86,74,48,55,111,138,14,122,81,157,117,57,171,23,230,218,89,175,106,228,225,19,165,123,125,0,236,131,235,188,24,222,186,174,24,165,180,8,189,217,182,216,223,190,137,251,116,223,132,122,208,232,228,251,228,84,228,41,212,79,139,22,141,113,101,44,21,108,136,134,202,189,25,109,71,25,97,171,114,253,253,127,115,158,80,224,191,119,45,122,71,91,7,235,0,212,174,36,240,44,155,91,124,45,248,208,117,33,142,33,78,52,62,247,247,110,216,83,132,127,147,104,124,23,21,174,136,215,65,221,227,17,3,192,70,94,79,7,23,74,11,134,160,92,30,227,84,38,77,108,95,22,187,215,68,96,53,229,92,241,17,222,199,198,199,11,224,232,246,201,204,163,202,17,6,133,21,150,8,212,204,40,161,238,215,177,6,41,116,136,66,160,144,157,19,177,239,131,78,230,16,83,19,132,140,14,135,162,175,114,85,208,153,28,79,238,6,31,197,237,247,157,209,6,155,5,194,152,47,47,48,145,205,252,5,195,213,194,224,133,103,26,236,120,142,110,86,14,31,55,164,64,119,12,131,203,245,146,52,126,45,65,181,120,252,24,169,65,55,233,129,121,20,146,138,3,219,236,22,179,119,90,181,42,8,153,102,178,101,83,198,12,105,76,91,242,128,94,26,11,244,44,109,115,55,21,5,200,221,86,162,69,34,16,41,218,211,64,121,195,170,146,44,180,251,114,170,112,252,164,203,137,103,6,185,92,54,198,221,23,49,10,204,238,231,79,118,226,45,4,105,73,230,67,177,181,27,242,161,87,233,89,210,145,45,101,255,239,210,202,212,141,35,238,151,242,50,126,142,144,91,93,74,227,3,56,8,1,118,254,78,25,7,136,213,10,105,7,227,228,51,141,248,121,85,22,222,79,163,57,155,106,187,234,91,253,186,29,83,12,191,212,66,143,42,177,206,85,168,98,206,215,158,116,73,178,136,118,254,6,5,114,114,97,213,247,205,87,5,184,28,132,248,242,152,105,212,194,85,159,175,221,17,104,253,151,194,130,124,197,199,135,9,196,141,132,166,70,77,150,163,104,38,155,69,235,246,128,93,6,103,210,19,227,77,224,42,109,130,102,215,73,114,134,75,10,209,31,23,67,254,43,116,53,63,247,189,78,71,171,225,214,219,235,110,13,162,31,191,72,49,75,250,30,142,113,100,190,211,26,211,40,129,5,64,20,181,222,0,47,44,245,29,23,133,206,167,147,173,102,87,44,77,26,234,157,245,249,142,148,206,36,16,35,103,129,8,54,60,14,21,21,162,12,186,157,27,155,24,109,91,131,94,5,26,181,37,229,88,105,156,237,4,117,92,18,9,84,80,116,115,135,71,52,93,171,224,248,150,229,161,254,90,91,229,109,228,232,169,44,166,35,142,125,109,201,201,171,72,45,159,4,155,224,187,42,164,168,255,57,165,0,29,49,131,19,116,38,44,249,220,91,37,148,43,253,143,224,0,153,26,173,50,193,116,242,217,10,7,26,45,25,73,103,163,3,73,29,60,218,244,26,12,8,204,143,52,187,152,73,38,52,248,250,230,129,121,218,177,142,43,141,3,34,180,197,235,151,25,142,91,94,190,164,7,30,87,224,25,15,172,169,195,9,146,129,173,61,174,79,186,84,234,162,212,70,240,90,109,65,252,172,221,0,89,43,196,145,229,128,123,237,215,46,208,12,242,222,49,124,41,76,202,26,46,30,6,245,124,179,209,3,81,100,65,46,14,51,200,194,203,79,36,216,246,50,11,68,186,189,139,139,14,187,37,119,62,63,52,104,147,175,228,227,210,112,134,90,25,173,46,144,203,40,146,72,219,155,248,147,66,175,126,210,220,158,102,9,199,180,121,238,65,192,100,1,133,233,99,251,194,151,44,55,32,187,89,181,95,69,169,225,118,74,108,220,144,200,235,203,161,192,206,105,84,123,91,60,39,25,230,226,25,249,233,54,94,46,250,41,176,89,197,13,189,165,6,52,85,109,123,76,128,99,160,173,140,52,60,67,213,218,183,225,39,36,52,167,48,24,54,35,138,47,151,21,41,23,255,31,164,14,170,53,17,167,143,175,131,135,0,91,39,68,62,185,71,246,7,195,62,212,73,101,182,248,24,208,233,214,120,169,184,94,229,237,171,61,245,39,95,49,184,63,41,5,41,136,129,208,154,250,168,50,34,203,135,196,153,133,247,161,218,185,130,68,9,190,57,131,136,184,31,25,78,166,247,244,228,17,26,8,170,109,164,183,189,42,6,118,97,168,68,241,172,168,29,88,99,168,241,222,240,106,76,90,173,73,193,20,63,102,94,184,243,18,217,211,228,106,14,43,153,222,227,126,178,189,27,137,159,9,20,190,159,51,88,236,146,60,190,6,128,23,89,231,237,105,55,12,135,28,11,238,35,101,151,46,224,38,148,84,80,0,81,200,114,107,105,0,176,180,73,141,111,81,118,80,133,154,212,125,35,1,56,230,204,56,248,127,175,198,122,74,3,56,69,40,28,171,175,47,119,70,120,190,40,114,208,97,223,231,205,94,119,215,102,69,37,167,233,219,240,23,108,113,14,193,233,110,83,239,13,104,36,96,235,27,13,106,34,166,57,236,54,210,21,115,175,237,124,112,115,13,89,117,88,111,34,237,6,204,123,215,180,189,194,137,204,130,138,127,246,231,202,155,76,165,23,135,12,136,193,206,187,141,68,172,97,216,92,155,171,35,203,138,30,152,95,82,50,234,26,147,29,5,110,142,201,35,25,62,56,80,30,226,43,13,87,0,231,53,30,25,37,240,101,52,4,127,25,6,25,228,102,59,19,222,221,62,198,175,94,40,171,53,94,33,41,31,69,156,59,75,40,76,207,19,79,3,173,122,136,131,133,159,63,247,200,154,210,157,85,142,120,75,187,15,23,30,213,103,100,80,239,3,230,27,176,237,209,46,26,126,78,32,57,102,40,180,242,133,79,21,57,198,42,162,241,128,93,137,165,213,214,164,48,180,177,4,9,89,166,111,4,245,98,74,117,191,154,117,0,232,107,78,32,254,8,205,137,255,146,53,119,110,151,253,87,215,199,251,46,131,30,179,255,25,33,105,104,229,25,108,143,207,76,236,252,87,205,170,123,82,78,34,228,238,22,175,84,4,98,69,119,13,10,56,35,102,0,194,132,180,7,48,123,79,70,104,33,117,241,162,41,30,42,9,254,245,55,77,78,111,31,213,12,109,134,21,1,127,198,100,250,223,148,209,8,99,247,79,140,191,213,252,109,54,84,162,21,90,43,227,96,219,19,116,186,86,81,83,80,209,209,235,173,12,23,95,173,254,214,127,233,78,11,63,116,246,144,99,216,150,60,37,85,134,211,139,63,128,58,112,65,151,179,190,174,189,217,4,197,99,25,179,215,53,93,210,145,120,18,246,72,2,194,213,73,208,243,11,235,98,132,74,10,20,137,12,72,61,94,184,224,233,50,52,163,150,83,22,225,237,24,105,50,161,16,132,243,192,183,171,100,174,9,7,141,28,220,183,183,68,156,2,177,71,28,168,96,97,41,159,118,13,59,53,69,224,100,146,21,149,229,177,223,45,14,147,4,147,7,169,0,150,155,157,8,144,196,59,68,36,177,233,251,123,232,39,66,139,177,232,206,51,90,20,159,126,36,205,39,249,39,223,60,96,116,176,41,207,251,1,135,165,235,160,24,45,193,33,218,32,154,8,236,210,197,77,121,33,229,5,88,29,18,91,163,22,75,11,80,225,48,0,2,119,221,247,80,205,193,178,125,194,45,50,78,195,208,182,212,228,86,206,123,43,78,49,46,142,86,210,112,18,23,61,111,26,227,89,205,29,232,158,20,188,227,250,210,207,181,13,121,215,69,243,186,213,227,110,79,128,71,1,115,185,80,118,142,169,186,4,95,230,11,136,5,67,4,35,165,249,219,151,198,1,209,172,208,51,245,151,148,14,222,65,236,42,253,222,236,191,34,166,130,3,253,174,47,99,33,113,55,164,147,154,108,31,74,162,152,56,41,13,221,102,16,18,70,175,236,151,113,41,123,26,80,167,46,101,37,60,125,118,58,55,40,37,117,131,114,233,215,36,246,225,119,50,39,239,125,121,31,45,122,55,191,168,245,227,210,103,146,162,118,73,37,18,176,7,177,229,124,69,204,31,162,74,118,81,200,74,221,157,60,21,176,183,150,65,213,80,173,31,249,189,107,194,103,128,3,60,175,105,205,101,140,208,237,37,72,182,228,141,253,149,3,123,46,160,31,106,203,224,48,4,218,249,3,38,88,253,213,234,250,108,191,36,119,61,89,6,92,194,134,230,10,32,128,20,131,191,58,161,151,16,145,147,115,198,65,30,37,23,161,32,16,125,215,114,179,218,27,78,230,79,196,76,249,215,28,140,183,76,47,77,126,216,209,188,6,77,254,132,28,118,101,61,177,226,51,214,60,186,170,137,110,33,45,194,58,207,9,55,173,0,178,253,104,197,87,112,45,234,24,202,119,115,12,204,96,44,40,211,199,196,195,26,249,84,43,78,192,227,216,12,14,97,165,215,23,184,206,112,76,37,180,128,187,89,116,80,22,61,19,137,79,181,233,239,26,18,167,158,92,26,116,84,49,221,248,102,5,23,181,215,118,127,90,97,25,200,147,227,161,34,88,78,39,150,105,69,200,35,150,61,8,138,103,70,148,26,32,247,92,141,69,179,197,126,105,116,76,212,82,147,21,76,35,119,16,59,177,82,145,124,245,204,213,238,219,147,117,20,168,105,28,120,206,52,131,142,79,0,234,76,20,41,124,159,73,158,47,42,147,228,134,88,99,237,150,93,20,89,241,9,57,41,158,127,6,68,8,199,216,43,192,94,33,169,118,39,54,235,57,145,117,250,210,255,42,99,249,26,49,115,204,180,4,158,248,234,85,10,0,159,225,162,191,114,251,155,71,61,234,18,35,53,71,158,27,149,132,2,102,242,19,232,83,186,243,105,23,207,22,199,8,206,234,146,2,160,196,90,14,111,237,165,212,184,45,90,140,232,10,40,1,25,191,240,222,32,46,71,65,80,40,242,224,147,1,219,190,59,21,239,208,239,52,209,7,226,226,100,210,87,47,215,42,32,216,173,42,34,20,84,52,47,207,5,210,155,161,2,50,55,213,153,111,15,69,147,34,146,23,213,168,202,236,33,248,115,2,200,107,122,101,73,234,129,195,225,101,128,98,54,250,186,226,90,66,145,195,216,188,100,65,86,229,180,204,151,246,33,137,124,40,106,201,52,243,60,95,60,39,222,197,163,39,237,183,143,210,238,187,163,14,35,97,192,222,10,140,150,29,65,13,207,150,172,237,107,36,237,76,37,130,195,153,8,233,196,75,11,233,82,216,113,86,28,229,105,36,189,14,100,151,44,67,101,96,184,19,221,146,45,255,50,208,110,8,77,109,22,96,67,31,19,55,140,223,117,13,244,220,170,8,138,205,29,100,161,87,181,49,71,91,114,180,19,192,34,215,60,168,112,200,120,237,176,233,160,60,10,5,170,43,179,218,62,1,8,37,186,37,84,55,39,195,163,80,126,13,228,32,195,239,34,214,176,247,122,246,155,148,165,251,10,250,32,13,89,129,194,74,232,194,228,12,243,93,246,205,134,142,165,242,132,56,157,163,67,199,52,166,17,76,151,221,39,14,183,51,129,129,110,31,60,197,161,62,90,161,250,27,48,121,106,51,54,28,31,157,249,196,57,236,255,56,199,254,59,11,37,101,214,227,172,200,74,201,146,117,195,237,152,210,79,141,223,18,79,210,13,215,74,235,64,249,144,162,114,234,26,108,75,130,147,242,109,51,178,173,243,137,54,163,140,112,250,193,103,250,186,194,233,126,2,67,84,65,185,102,240,233,7,207,76,13,168,103,25,54,103,30,24,188,140,101,107,229,171,146,143,224,56,10,129,202,90,41,26,123,32,75,232,253,233,159,201,123,119,216,239,180,94,151,53,145,234,28,113,9,194,123,13,210,143,193,225,217,166,203,98,191,129,200,243,189,83,177,191,74,29,151,245,55,167,117,170,40,66,246,212,231,8,172,151,12,38,170,194,18,149,20,134,73,43,237,88,32,141,254,116,230,10,234,24,205,171,4,218,75,88,139,194,232,170,96,216,151,235,213,5,31,28,104,212,23,21,47,182,6,72,98,188,176,251,62,187,199,93,80,180,177,137,160,83,98,70,129,166,181,47,174,74,14,63,17,148,49,43,92,48,39,101,153,47,144,74,248,45,250,206,26,107,38,143,134,73,251,28,53,145,36,85,207,213,84,175,191,78,149,161,207,48,109,144,59,20,128,62,33,185,124,148,53,131,231,67,107,68,228,96,68,76,188,96,202,220,40,63,86,151,117,98,57,238,26,235,6,47,117,122,144,222,159,99,2,12,112,233,104,107,204,95,7,86,115,82,47,238,198,104,5,94,111,157,158,244,81,181,19,233,82,171,219,126,168,42,243,198,201,33,141,149,171,54,209,180,204,140,170,224,130,124,187,60,61,253,244,137,255,118,50,22,50,232,203,137,186,99,35,206,26,40,19,101,241,228,92,217,39,168,77,117,164,81,37,137,7,36,192,24,161,64,231,104,110,228,127,4,125,95,56,196,149,33,0,25,0,86,136,108,79,140,96,254,119,137,138,200,0,12,248,20,130,140,196,32,195,105,244,29,149,188,85,87,194,216,197,74,210,154,189,15,88,229,60,91,15,41,176,253,105,135,112,176,186,47,156,167,36,145,116,204,71,242,246,44,111,79,88,139,12,117,76,43,114,197,138,147,247,182,206,82,1,210,183,208,20,199,2,147,23,135,115,227,16,175,228,246,8,213,141,177,94,164,74,211,57,147,229,161,24,10,48,213,8,146,77,250,111,230,153,209,238,119,98,80,126,91,186,66,147,120,119,12,102,154,211,103,115,109,18,109,230,5,152,139,13,114,221,137,57,236,63,5,225,63,38,204,125,78,55,46,47,236,181,212,165,10,138,8,34,78,161,221,66,90,253,124,37,153,202,84,147,40,95,242,65,125,243,55,240,63,118,212,27,121,25,57,230,120,87,97,141,154,21,120,13,183,103,90,201,103,23,122,34,168,70,80,150,41,211,85,129,70,149,65,157,36,206,100,98,73,2,83,215,31,208,37,225,76,122,74,74,24,218,114,39,26,236,113,90,185,195,59,13,234,61,161,67,98,214,65,46,237,88,78,67,186,250,27,41,157,62,144,160,133,86,46,158,6,166,143,172,18,8,87,102,231,52,141,255,16,150,75,51,212,215,166,121,43,98,163,49,207,22,129,232,150,19,175,34,100,231,141,41,146,50,64,163,246,76,119,43,140,4,128,138,125,225,45,228,233,170,181,42,243,58,23,102,163,87,196,10,186,247,239,23,184,82,190,219,140,109,142,23,46,125,110,135,0,122,240,163,175,217,54,153,71,45,229,34,89,65,32,146,67,118,206,112,5,241,99,175,243,179,130,112,200,252,140,133,135,178,142,102,201,176,163,77,193,127,102,208,213,178,9,217,118,117,26,175,205,185,30,143,127,222,40,215,58,37,184,126,118,139,235,158,88,202,10,140,58,165,88,141,77,56,81,117,66,13,210,177,163,27,9,97,144,224,194,181,197,132,73,204,151,152,6,73,167,203,83,160,6,138,85,12,23,167,7,116,48,141,244,231,107,157,8,183,42,184,243,216,116,152,151,156,32,40,146,60,91,100,109,128,249,45,17,25,158,44,13,143,226,219,174,45,64,149,83,98,195,198,240,29,8,207,96,103,21,139,159,193,13,222,117,192,160,222,147,114,189,120,102,17,202,253,162,136,36,125,49,184,178,195,156,12,238,173,30,82,167,27,136,0,61,147,123,94,213,196,7,238,178,145,245,148,21,253,248,88,107,86,222,147,252,39,25,163,218,19,230,195,157,130,108,56,10,3,31,146,137,135,217,165,254,252,178,177,51,193,177,85,170,4,71,87,40,203,176,190,238,61,16,48,231,194,141,242,34,28,21,108,244,10,175,130,215,246,242,92,6,77,187,193,220,22,227,99,16,127,163,33,213,99,99,175,181,109,99,165,165,144,30,186,103,120,121,19,168,133,61,163,96,55,50,108,107,93,126,72,22,224,84,126,129,174,147,153,36,68,84,170,139,188,167,119,249,162,68,79,106,126,178,204,24,234,141,189,31,52,201,83,99,74,71,22,215,112,116,142,200,97,53,250,74,171,86,136,233,36,178,156,90,173,22,231,215,168,72,208,152,197,162,7,156,112,10,241,234,49,69,11,106,208,172,60,244,137,242,213,115,18,221,171,151,205,250,137,195,15,189,106,46,192,98,190,167,17,171,2,98,176,43,73,195,124,211,139,47,255,199,49,107,184,193,103,46,204,236,45,74,130,122,248,71,66,246,252,77,16,94,241,118,15,223,229,226,89,236,229,15,123,246,153,9,80,88,31,5,40,31,197,33,98,36,138,233,56,112,232,54,102,161,144,193,166,72,200,178,19,235,176,53,170,40,25,178,138,99,53,133,118,26,95,90,134,130,54,154,129,55,16,90,199,151,8,79,154,79,233,19,153,30,104,38,204,222,93,44,2,0,101,4,206,29,203,176,131,236,182,102,60,80,8,157,180,102,79,176,107,142,97,71,130,56,190,35,71,25,113,116,135,132,72,1,49,93,136,254,240,132,123,43,246,210,33,127,44,134,25,169,128,208,62,77,250,34,212,136,124,125,157,116,50,39,130,179,49,73,214,172,221,35,80,251,200,66,198,79,55,31,11,139,218,198,156,78,29,10,13,129,182,135,61,72,180,63,236,246,128,151,107,77,234,23,232,244,182,210,251,73,116,2,185,226,86,36,150,84,87,203,41,194,235,46,93,129,102,11,213,192,184,13,119,146,160,56,41,177,233,89,222,228,228,198,108,39,17,115,63,41,231,22,53,94,225,39,204,211,31,18,106,12,101,67,202,194,4,209,214,60,112,216,4,223,225,45,122,183,162,146,125,207,21,204,96,211,104,243,122,56,173,242,92,136,145,171,100,4,131,167,120,182,113,149,216,162,11,219,138,130,130,133,5,113,4,114,129,150,76,146,0,174,6,124,64,84,78,142,8,12,252,25,64,86,100,108,0,30,4,104,171,211,96,191,76,97,98,127,0,220,110,170,9,10,121,68,195,163,250,152,124,150,136,56,64,150,101,140,119,144,50,169,181,110,52,145,113,158,155,230,157,108,11,166,114,205,66,56,24,238,152,231,14,18,135,30,134,71,188,3,120,115,74,42,129,254,177,55,172,27,107,98,12,249,132,98,148,9,168,217,107,74,185,92,244,105,122,47,27,108,245,42,142,180,40,118,84,185,251,71,183,226,0,193,36,211,249,87,207,111,140,171,150,116,254,101,41,219,128,186,149,123,181,111,119,88,180,88,147,115,231,141,23,231,3,247,214,19,207,143,224,156,17,205,114,20,195,143,37,142,29,68,84,54,197,145,252,133,179,161,87,159,195,90,123,91,220,143,26,168,83,160,133,92,165,132,175,132,201,224,238,152,90,54,180,144,20,86,232,112,54,110,127,52,122,167,38,96,198,128,185,61,111,63,74,168,87,148,38,236,31,178,103,118,57,108,167,229,72,185,166,209,233,190,99,112,7,122,254,10,21,165,51,242,140,87,227,19,51,34,253,29,165,215,225,217,247,216,39,9,162,135,222,133,12,213,59,168,22,20,232,137,67,219,184,156,76,172,53,139,1,162,122,80,148,36,62,134,86,200,69,81,199,187,56,136,228,61,108,202,192,111,106,3,60,61,68,146,83,0,201,200,195,247,223,222,188,134,26,21,25,43,254,204,145,236,65,137,198,202,209,232,94,31,64,134,153,53,214,85,221,77,177,98,16,95,167,181,20,10,208,111,76,188,165,225,147,56,113,67,101,229,185,16,63,95,178,47,193,171,71,19,143,102,7,184,245,166,85,240,136,28,15,237,84,216,120,39,183,116,211,98,60,194,126,31,155,202,131,167,210,43,78,172,111,147,5,26,227,159,35,68,234,140,12,237,43,52,103,64,197,137,60,212,201,181,104,146,200,121,206,19,37,224,158,81,196,114,217,184,227,238,40,173,210,120,188,101,51,27,88,45,167,23,81,206,107,24,132,60,162,13,85,162,36,123,44,188,143,138,248,197,239,77,146,183,224,7,54,143,125,77,137,152,139,241,134,152,186,179,211,222,0,255,144,91,213,29,202,227,252,98,40,165,132,31,60,55,79,161,191,18,22,101,62,53,105,115,82,210,142,24,182,81,115,160,228,211,196,115,243,219,36,29,168,215,173,60,208,138,228,225,87,237,54,171,146,207,84,1,183,82,23,218,189,216,55,228,239,178,62,109,175,93,53,76,46,75,193,61,127,110,41,14,195,84,253,24,60,41,41,63,144,17,103,71,174,110,175,157,141,30,113,78,45,227,179,191,8,4,60,187,197,33,200,202,65,188,10,180,217,10,84,194,89,173,242,250,111,28,19,65,196,227,167,34,88,248,91,197,253,3,96,255,141,234,149,162,202,145,32,188,138,248,53,142,129,139,174,215,126,13,138,154,253,181,17,151,232,132,182,6,22,118,42,76,117,128,139,237,34,115,96,228,127,119,141,250,41,121,112,157,100,116,189,106,175,28,188,148,209,98,126,30,155,38,116,135,97,32,157,147,129,222,172,152,35,118,93,229,65,198,174,112,245,117,121,140,164,244,114,79,26,82,9,242,187,244,93,9,252,200,21,119,254,248,11,238,202,74,210,246,27,204,152,166,240,171,71,110,76,186,153,40,130,201,181,17,72,173,68,131,157,57,96,89,2,113,65,8,189,220,98,89,49,197,156,173,244,223,251,0,138,207,56,176,208,127,207,74,218,225,6,20,113,156,126,222,79,56,251,110,187,83,92,47,201,86,29,242,177,66,86,68,5,70,10,66,169,164,189,150,104,79,241,234,50,111,246,84,58,240,74,244,200,249,246,223,53,57,72,181,37,110,152,111,150,59,232,136,131,189,106,67,54,208,124,118,180,104,7,132,65,202,170,35,3,133,213,248,192,215,164,139,6,131,197,76,207,70,189,9,214,177,173,226,74,46,53,65,83,166,164,211,75,9,221,88,215,147,46,244,177,71,225,165,187,181,225,36,91,241,173,170,181,240,107,53,163,154,167,64,247,182,32,118,180,231,182,69,231,163,77,115,43,202,15,151,230,184,254,13,149,42,173,27,35,92,120,24,159,157,19,134,227,87,126,219,51,143,10,105,111,35,94,146,107,137,169,23,93,225,82,220,150,21,51,191,198,241,62,237,56,25,180,104,107,212,149,106,40,250,127,185,126,221,129,160,214,171,90,127,139,176,124,85,101,25,49,199,83,182,76,48,99,165,152,178,70,83,86,89,192,139,158,94,12,82,115,189,189,40,44,210,5,159,84,111,206,100,60,52,170,61,212,64,130,212,27,148,194,109,246,101,7,42,186,121,184,100,97,98,177,45,246,238,69,109,116,108,246,19,0,27,83,106,39,52,125,28,141,42,92,137,190,192,26,222,188,139,120,191,137,145,57,24,253,161,229,86,189,6,179,229,122,195,45,146,119,26,96,27,174,222,86,188,207,69,124,191,92,217,119,184,236,109,242,115,66,41,162,226,75,72,118,46,74,121,78,13,82,135,165,75,136,220,233,156,3,91,13,218,50,78,148,216,190,135,98,113,95,146,145,237,225,146,110,238,163,162,249,161,212,154,27,127,157,125,160,121,243,241,242,138,43,163,101,53,231,74,123,252,211,134,9,194,29,110,101,92,128,58,167,26,13,189,89,151,86,138,190,18,20,170,95,92,250,131,167,45,111,52,182,159,200,173,77,43,90,46,189,136,152,154,152,204,227,43,144,186,84,255,187,204,75,138,170,232,91,122,171,130,63,3,151,106,214,13,251,96,1,129,186,239,241,22,168,232,71,176,91,171,29,186,52,242,195,27,229,192,209,184,139,50,140,7,61,206,181,41,60,48,29,150,49,239,130,109,105,142,21,14,56,156,222,224,3,190,0,247,249,122,202,237,79,82,94,181,153,97,44,65,77,147,204,223,179,153,165,8,220,247,57,8,211,98,227,233,183,252,36,38,215,158,2,37,11,89,149,3,122,13,39,44,20,80,69,2,149,75,148,229,226,122,39,69,167,87,121,98,255,59,119,56,95,176,189,22,165,38,92,56,182,25,129,23,139,233,142,175,114,56,204,49,87,229,128,12,215,172,37,224,85,57,215,120,167,244,95,139,74,29,41,114,177,124,219,221,224,11,107,190,176,190,254,25,208,30,89,14,186,20,169,160,111,103,197,129,126,37,171,75,244,171,19,139,105,55,68,217,165,140,177,139,154,103,34,160,102,189,215,124,39,127,224,188,90,105,58,47,155,22,187,201,94,237,43,46,81,124,28,117,60,165,199,32,70,176,50,50,220,161,239,131,234,0,40,71,132,127,107,54,125,213,235,73,55,157,180,92,47,98,255,45,50,97,166,90,29,114,225,6,197,226,213,40,96,188,64,56,84,4,178,61,108,235,106,161,94,91,15,186,238,151,234,221,131,94,125,20,242,216,218,61,226,223,229,62,158,247,235,69,226,63,85,173,253,74,219,176,192,18,3,132,255,168,22,245,154,223,162,185,31,4,165,161,55,37,60,154,28,209,135,118,33,91,246,177,233,87,112,17,39,40,21,156,57,25,61,226,34,229,153,160,234,26,20,68,221,90,192,132,86,165,53,167,181,0,233,88,252,41,22,199,131,249,23,89,56,115,136,218,135,239,25,100,21,198,211,89,141,91,57,129,156,248,40,178,190,133,22,210,253,85,23,28,215,54,59,229,249,82,98,195,122,115,194,94,72,208,223,209,233,88,195,85,42,101,213,243,99,53,65,242,140,117,27,2,153,44,131,86,228,109,190,54,100,102,137,124,254,16,16,148,37,43,31,167,43,168,172,183,222,35,1,169,58,63,131,129,7,238,126,191,86,113,166,199,225,230,109,197,116,233,86,122,127,82,40,244,171,3,78,112,130,93,249,241,51,215,179,91,208,82,26,67,179,7,225,13,208,146,219,197,128,221,166,192,22,179,181,35,20,9,147,34,155,208,81,175,96,106,168,151,147,215,101,61,9,125,76,81,212,67,157,233,20,108,172,237,152,152,162,91,233,182,197,22,155,38,188,207,224,87,204,232,24,221,118,17,106,73,13,59,24,233,114,61,242,201,240,90,41,129,147,32,115,70,84,67,147,96,227,218,5,253,254,226,72,94,133,81,248,206,35,148,229,224,241,135,28,125,117,142,177,127,12,110,254,194,175,127,168,182,209,201,173,102,115,157,178,179,193,106,110,121,142,228,60,173,168,242,158,25,166,172,11,43,48,92,185,3,136,11,226,12,76,7,162,249,121,29,229,180,149,70,145,246,230,75,78,104,101,32,159,90,207,17,170,42,219,32,116,45,169,0,168,129,60,80,176,132,119,165,54,15,15,79,5,220,24,166,218,137,74,39,221,100,34,89,160,253,118,5,147,227,73,140,21,148,3,129,250,3,171,93,94,47,73,181,160,25,98,24,76,208,254,216,33,41,216,61,69,240,166,201,66,63,203,49,92,249,188,214,76,123,179,168,117,73,174,104,58,235,75,135,39,58,31,35,196,164,0,149,43,91,0,74,30,61,28,124,89,184,25,166,100,147,135,232,81,75,133,87,203,108,143,244,209,70,158,109,253,179,244,246,156,142,242,180,101,108,34,109,180,48,232,170,187,213,168,225,82,163,168,216,43,110,153,124,159,142,174,15,134,96,229,180,152,191,47,8,77,219,131,229,67,139,151,249,128,47,35,153,116,234,161,157,88,223,16,13,134,228,183,52,177,229,33,35,100,241,98,225,24,92,72,46,112,240,51,249,20,51,153,98,79,79,199,76,242,47,112,207,48,141,34,237,134,248,240,151,186,136,15,164,160,118,46,99,249,14,64,57,24,67,50,35,110,10,182,111,216,107,67,194,115,233,165,108,236,72,68,169,244,39,173,146,24,70,203,205,107,168,135,155,223,40,37,154,106,96,255,199,35,237,25,136,108,161,237,78,237,189,154,30,247,112,38,247,60,137,159,98,214,253,13,14,155,116,97,48,159,111,11,50,104,187,238,190,66,242,103,51,130,129,20,252,89,8,93,230,70,240,68,178,203,204,241,55,138,81,132,53,173,31,241,22,158,211,176,165,241,23,155,75,9,122,223,182,46,237,136,190,75,242,211,121,196,192,47,89,35,184,8,121,30,207,242,123,110,224,53,136,0,45,41,129,165,171,237,53,30,141,130,167,33,187,39,95,160,109,23,253,13,145,127,14,120,184,198,49,56,136,73,145,101,113,246,121,60,29,28,116,47,97,240,240,51,22,191,121,56,51,13,197,105,102,167,229,166,91,46,30,3,18,193,219,211,50,46,22,112,161,103,59,211,90,169,250,241,189,72,106,239,114,117,215,243,161,188,163,237,75,77,223,234,9,98,94,86,61,153,7,22,77,26,203,136,255,212,101,73,62,155,13,13,54,137,25,135,189,218,21,35,129,38,160,19,165,21,52,162,101,106,118,161,168,195,46,47,31,97,220,213,173,130,118,227,28,219,128,158,160,202,225,255,50,17,144,150,223,113,59,162,42,189,45,219,25,102,240,31,87,204,28,213,116,132,88,32,93,214,104,181,29,1,89,240,232,63,213,49,136,168,83,50,234,22,197,239,52,202,124,74,4,6,196,15,14,144,57,165,226,98,78,188,127,8,45,169,135,124,98,231,106,225,229,51,142,107,64,41,225,164,11,206,113,161,63,223,226,252,143,134,108,225,158,114,19,157,160,203,202,231,165,93,139,236,229,205,51,25,70,188,227,238,132,131,215,80,162,159,3,252,235,181,54,75,201,170,194,217,130,88,44,146,191,41,175,78,176,15,80,155,255,198,202,164,87,155,39,152,78,75,87,49,221,166,219,78,77,139,199,103,136,4,202,13,133,109,235,82,92,118,33,106,144,1,247,141,160,135,82,171,141,163,176,6,103,33,119,84,110,230,164,23,13,13,34,169,117,167,173,109,21,33,17,193,193,169,251,83,77,12,80,97,76,209,215,21,16,31,97,192,110,211,103,66,160,200,185,239,10,242,96,222,219,117,245,162,2,1,208,150,126,104,17,213,217,204,65,162,112,112,134,162,197,196,94,116,221,161,85,41,26,87,14,224,0,238,126,208,34,156,105,63,83,103,31,198,64,150,172,26,181,11,254,199,36,60,85,126,247,2,35,21,190,180,106,73,75,167,253,241,211,127,133,165,190,71,84,29,252,177,30,113,218,69,21,38,227,186,63,110,67,212,61,22,103,51,163,77,74,199,26,25,96,71,203,165,27,162,174,124,171,211,90,244,251,152,121,188,40,7,161,82,210,186,157,171,35,242,44,81,234,178,148,178,162,197,185,173,67,29,127,60,212,227,55,64,87,58,42,171,236,228,137,241,58,148,137,195,5,209,164,6,59,71,184,94,18,167,40,233,48,6,1,160,90,253,64,252,254,66,158,166,113,100,209,208,82,154,45,162,34,82,172,37,93,140,183,14,98,53,113,17,33,44,202,63,100,244,105,39,177,184,187,204,109,230,248,101,49,61,160,52,14,135,230,144,0,45,140,51,118,191,100,164,9,33,101,50,126,230,35,152,21,47,24,2,66,177,8,28,43,239,240,26,241,47,215,93,229,168,115,200,208,51,34,254,240,180,54,149,221,43,174,192,246,168,205,253,227,104,167,184,188,120,224,21,21,197,243,154,179,102,210,250,18,67,107,74,253,173,215,236,15,152,230,97,83,167,210,37,142,56,249,78,46,26,203,208,129,177,108,127,172,71,178,79,202,101,133,226,117,110,212,214,131,235,165,39,115,67,94,233,197,236,102,128,171,163,180,84,21,162,185,232,188,172,89,38,88,62,32,250,122,174,75,44,30,101,197,255,16,36,103,75,195,127,196,87,114,70,90,105,247,110,121,138,112,61,101,33,80,59,196,25,89,188,104,233,98,60,127,63,124,176,85,217,178,94,199,67,150,126,192,220,192,32,191,99,48,119,58,96,216,119,52,22,36,127,53,212,61,132,216,53,3,109,147,210,234,43,217,140,35,67,236,176,114,247,41,73,0,143,148,38,254,91,41,59,3,79,219,152,243,30,82,63,67,144,13,107,165,117,196,225,44,53,93,196,54,229,247,103,43,105,244,42,86,243,55,79,156,9,190,152,24,175,100,248,59,237,191,193,194,175,157,20,55,100,140,209,72,12,111,107,139,82,32,149,184,27,117,113,39,49,91,96,182,19,121,249,186,250,221,87,227,29,132,11,206,90,215,90,172,131,137,89,140,244,242,95,109,119,181,21,64,55,145,63,5,94,153,131,216,198,111,46,42,219,244,224,100,246,98,24,60,10,97,117,250,45,230,32,52,78,47,126,174,6,243,118,52,169,47,223,27,50,214,193,114,130,180,201,121,64,110,241,119,149,87,8,60,80,248,142,17,30,44,145,233,197,57,157,197,46,250,102,199,203,29,58,229,252,144,44,111,142,17,109,42,90,151,176,34,204,36,26,144,4,111,28,203,102,41,14,207,18,4,25,1,20,141,197,61,32,11,150,67,1,171,31,246,24,116,25,209,97,227,190,28,58,48,104,52,149,236,170,9,107,42,64,200,132,86,89,110,231,33,219,235,175,42,38,105,192,96,196,89,181,178,27,16,248,197,57,84,186,64,226,51,240,75,195,42,49,171,83,90,173,211,26,104,50,227,129,14,217,84,42,79,155,255,134,13,28,254,22,75,30,93,109,30,29,238,210,206,165,111,112,179,203,248,48,207,179,108,211,175,31,184,235,241,141,172,83,57,245,96,44,10,142,15,90,222,33,206,72,27,11,172,2,221,23,223,87,140,187,151,250,157,128,220,251,139,145,61,198,149,63,90,28,160,49,204,28,28,194,168,117,127,97,18,45,68,218,230,124,255,108,22,82,80,208,69,135,182,190,1,198,95,219,148,131,178,48,13,93,79,158,102,230,212,143,224,72,86,98,16,99,215,209,108,183,84,151,117,6,185,214,238,162,71,156,239,27,220,166,55,176,42,211,224,101,123,174,167,181,158,68,27,18,25,72,225,26,64,87,104,123,49,153,57,193,52,237,236,125,79,105,145,29,174,151,223,194,207,212,36,72,202,243,4,180,90,102,198,96,204,222,80,245,25,101,52,94,244,167,20,102,27,197,236,26,71,84,88,139,46,15,12,62,232,92,63,65,215,187,226,206,135,171,253,145,66,75,201,40,157,66,37,117,65,115,39,74,139,63,3,8,53,205,222,100,246,188,241,253,79,10,222,10,112,154,119,10,203,137,209,124,92,134,171,84,69,28,72,59,36,243,182,140,154,237,165,236,103,206,109,76,195,144,36,181,18,46,161,233,106,144,3,29,208,193,160,144,29,64,64,225,20,192,255,135,172,165,16,148,152,218,211,239,173,146,20,160,211,191,103,229,171,185,89,63,239,159,118,211,125,167,27,217,111,188,153,199,16,7,94,22,127,179,94,24,136,22,30,215,18,238,144,185,78,158,220,70,240,234,8,165,107,119,89,189,224,229,2,7,199,74,55,11,137,105,58,63,144,53,76,69,120,233,8,108,165,213,126,111,166,70,68,10,9,163,217,182,167,199,185,157,43,156,193,171,174,201,154,23,241,50,154,184,26,118,228,172,221,165,109,158,176,31,63,67,255,185,57,18,206,180,59,243,237,88,31,19,69,51,252,80,46,49,11,222,34,36,233,75,50,57,33,91,73,44,174,116,22,71,126,52,213,243,98,63,191,46,145,181,239,219,95,1,239,68,85,49,228,43,187,243,52,238,41,240,246,74,66,4,113,101,191,12,92,240,94,234,37,58,207,72,36,48,214,95,162,213,195,93,50,237,203,145,108,225,96,35,103,182,168,170,0,49,242,1,86,99,16,14,9,197,254,18,61,66,98,250,154,32,214,59,57,120,216,11,107,146,113,227,221,79,173,93,39,85,220,135,238,42,72,17,116,160,108,105,51,182,180,104,4,255,227,171,207,94,226,77,106,95,230,53,219,80,64,96,95,14,52,197,180,6,178,110,104,124,4,3,182,103,188,192,99,117,237,80,143,3,1,250,208,103,86,211,146,11,111,234,124,49,77,215,115,55,120,36,10,194,133,171,240,250,124,156,183,200,123,87,22,106,98,240,2,59,118,67,21,121,239,42,34,198,44,57,226,255,74,154,18,56,88,55,236,226,120,217,154,68,188,53,40,120,179,142,170,13,22,17,185,52,125,173,2,38,179,168,252,96,123,200,21,24,1,112,149,65,106,28,174,8,190,156,58,67,32,204,102,153,37,99,59,40,183,40,104,78,25,47,70,235,109,151,85,94,230,196,232,58,218,215,9,124,158,191,181,36,219,70,214,35,46,113,120,0,15,59,64,70,158,144,143,190,37,78,107,51,187,91,167,68,204,142,140,240,63,28,140,237,74,162,236,155,124,16,34,238,58,239,37,115,110,230,56,172,10,126,96,223,109,113,89,173,144,179,56,61,62,220,41,11,208,78,24,88,134,197,160,196,113,87,29,228,69,100,160,29,245,83,9,232,142,108,94,171,59,139,232,218,206,145,67,114,33,181,115,247,204,41,161,146,133,188,46,240,195,37,121,33,62,145,90,100,225,8,49,4,237,206,187,243,183,58,37,220,212,34,152,41,105,20,224,229,120,70,141,141,24,227,255,235,12,224,20,46,208,225,241,227,173,233,126,222,118,90,135,161,3,88,219,165,24,172,146,0,44,53,250,198,162,179,1,199,248,218,208,67,29,7,146,201,245,109,47,199,246,21,8,207,246,192,202,69,86,145,17,113,112,37,135,30,193,229,79,136,68,172,39,30,197,199,98,139,181,167,242,213,159,199,192,87,96,24,243,180,127,250,248,93,135,3,253,150,108,48,122,74,37,67,110,140,16,233,44,253,104,124,170,177,199,38,51,40,195,138,71,134,82,71,212,153,124,172,26,235,184,206,205,166,114,238,180,225,120,64,154,149,192,30,183,196,174,101,165,36,55,138,99,37,221,76,232,174,50,60,58,245,211,147,246,23,39,53,204,129,232,91,187,147,85,48,78,156,127,93,142,127,218,127,252,149,113,75,156,112,219,17,187,34,1,84,53,143,100,110,215,226,249,158,139,143,236,84,52,170,59,108,129,215,87,169,53,117,43,231,180,79,205,62,154,149,190,41,222,62,193,155,157,158,126,98,181,0,109,167,154,179,167,244,184,23,119,93,174,72,1,87,74,215,113,16,234,166,62,189,75,185,73,41,9,75,213,67,89,214,116,122,192,220,247,54,53,132,100,102,7,26,247,10,78,145,120,119,193,204,103,175,9,118,147,116,187,126,240,24,121,201,242,114,203,123,21,89,41,227,127,71,78,155,182,123,106,165,159,25,26,213,110,72,3,128,41,4,244,154,218,165,54,159,202,14,249,132,42,89,214,211,95,134,69,98,86,134,144,170,232,14,196,75,51,113,220,12,227,189,93,233,239,44,230,69,107,187,219,181,236,58,188,150,116,64,171,113,119,53,173,5,154,78,219,41,80,184,252,42,59,147,41,12,134,94,199,71,8,126,29,136,206,68,172,112,126,121,141,12,225,201,174,154,216,87,71,223,139,70,96,79,113,107,145,83,170,229,123,100,191,1,195,8,27,55,113,115,51,58,49,82,221,199,77,57,197,171,20,176,193,194,77,9,229,96,105,9,35,146,77,109,199,229,121,0,11,86,156,203,54,138,14,241,43,131,78,50,116,5,174,163,45,184,18,33,75,230,233,202,76,202,101,221,98,224,50,142,233,74,2,187,144,103,77,172,209,243,236,105,130,183,194,125,25,70,86,212,0,181,157,34,103,131,245,192,86,195,152,60,173,98,245,232,39,11,148,40,123,92,52,194,50,196,24,199,195,187,162,141,50,133,196,101,162,148,96,245,158,79,134,120,18,134,17,124,254,163,126,135,197,178,122,50,54,179,222,134,167,22,206,148,39,189,250,53,22,26,201,164,205,84,152,172,43,196,47,55,141,116,33,184,24,167,121,99,199,165,92,46,35,38,223,251,209,154,153,143,40,189,26,25,104,185,37,156,95,182,225,27,88,59,191,102,37,229,4,17,155,25,96,101,173,33,107,34,148,177,52,55,178,29,255,59,182,183,150,54,159,104,251,16,87,94,72,160,41,206,79,176,76,106,73,158,240,242,58,86,39,9,234,159,3,42,58,110,221,71,242,37,215,186,107,39,218,34,55,172,221,174,215,95,209,110,124,151,170,164,39,188,163,204,12,165,103,119,135,22,225,56,130,88,229,139,52,31,188,41,192,95,61,119,56,64,38,122,57,35,40,52,32,17,122,226,236,180,137,56,45,178,116,156,189,204,151,72,106,225,159,217,180,49,241,92,151,231,18,217,236,48,197,227,121,58,176,237,124,210,47,251,123,248,233,56,176,214,61,30,202,253,125,14,172,54,43,25,18,113,250,244,51,93,67,71,24,108,59,221,143,67,96,4,12,22,171,98,4,52,89,17,43,14,185,252,107,50,122,64,24,29,131,49,94,166,27,123,252,162,142,127,12,41,5,28,144,127,199,227,36,32,111,45,185,49,91,25,107,140,171,94,86,20,203,27,76,251,145,144,87,3,203,80,139,117,76,132,88,136,135,129,245,83,92,78,84,158,142,58,221,50,113,139,148,134,9,123,73,63,120,224,218,110,32,32,228,171,73,95,165,42,82,132,39,156,103,231,34,167,163,88,206,101,125,229,253,47,246,234,140,148,71,222,19,33,25,178,114,191,235,47,192,228,207,68,80,57,86,56,38,6,98,123,6,31,154,71,69,3,228,124,84,105,249,49,175,2,132,70,157,178,142,64,239,230,129,19,94,76,7,186,61,64,70,160,153,225,111,93,79,107,233,113,97,29,206,58,112,230,94,126,155,200,148,114,84,31,92,37,164,12,168,55,47,156,198,240,192,100,62,68,61,185,71,220,47,60,249,15,2,242,54,73,179,182,205,129,25,227,178,193,92,183,208,140,32,230,51,14,200,111,30,137,167,167,161,54,165,108,2,71,38,196,179,23,53,35,48,199,142,198,68,111,186,66,73,148,19,192,20,221,53,203,38,2,6,120,73,29,186,232,45,27,165,89,125,151,188,250,3,198,123,140,72,219,171,65,153,94,105,158,164,187,45,151,108,17,149,111,134,84,237,151,137,20,200,246,49,69,192,222,183,40,228,244,208,76,206,15,130,224,33,245,73,232,39,167,169,65,4,170,68,100,109,136,6,60,3,242,242,31,138,210,182,31,171,125,246,161,17,8,146,27,11,238,219,220,219,132,20,120,172,45,56,204,53,236,22,3,157,47,105,50,229,191,234,16,159,60,65,229,118,100,77,29,169,62,171,14,83,155,121,71,127,184,215,121,92,147,71,243,56,61,174,9,155,160,198,30,43,86,74,147,106,36,169,42,40,122,244,187,146,33,177,33,20,11,131,45,185,63,198,174,133,75,150,31,83,34,185,21,135,32,123,83,202,117,191,3,155,143,253,191,3,40,147,246,136,55,224,137,131,57,0,158,136,20,95,55,21,55,97,161,51,100,255,102,73,245,171,144,30,125,54,27,194,46,247,44,63,234,24,49,215,72,241,32,142,155,179,157,186,73,52,46,103,180,25,163,252,77,119,172,57,75,187,216,63,152,28,64,72,167,142,198,235,152,126,75,68,203,201,34,254,144,197,68,6,79,35,120,73,127,214,163,222,33,219,247,161,20,234,216,225,76,107,60,50,219,230,62,198,216,146,67,30,221,96,10,190,213,148,34,29,235,116,164,151,44,119,136,5,119,66,186,229,131,116,55,5,238,102,127,200,135,134,176,58,1,254,243,165,140,35,162,34,5,196,200,38,231,165,221,27,51,153,208,50,183,201,187,31,202,174,192,60,160,101,117,74,201,81,57,197,2,194,36,179,202,117,239,214,66,139,137,198,175,30,25,33,194,123,230,163,91,234,61,90,7,254,85,116,51,66,184,186,24,216,168,139,226,175,83,217,222,46,104,156,43,97,126,219,27,112,100,47,57,64,56,36,188,162,184,235,232,167,211,117,77,48,107,142,145,6,90,55,95,36,186,231,151,210,177,61,76,131,96,232,97,36,198,239,81,2,57,162,101,158,122,138,83,65,16,18,78,181,137,97,178,225,249,162,93,215,190,203,117,243,231,124,111,161,183,232,184,2,237,1,97,158,170,44,126,243,179,12,116,46,161,124,249,242,17,67,175,240,171,115,245,103,207,114,141,152,2,112,47,208,179,106,60,156,39,57,220,223,86,155,254,16,56,36,121,71,137,111,141,31,219,116,164,133,52,80,34,12,160,198,244,85,143,230,58,33,162,109,137,177,94,105,174,125,1,74,143,190,84,108,149,93,34,251,143,191,227,140,63,188,35,189,229,253,31,155,177,72,130,144,75,236,53,93,49,184,168,31,206,125,114,126,1,72,164,60,112,117,30,122,235,242,182,80,88,41,147,154,104,5,54,22,214,238,136,228,40,204,78,178,231,243,151,1,181,209,68,184,238,190,134,51,146,133,132,68,178,169,108,135,224,12,81,224,231,75,137,108,145,190,96,149,40,92,179,57,27,151,59,88,144,60,115,123,82,57,213,126,147,201,239,37,32,196,197,233,209,84,142,235,38,198,77,251,54,188,101,117,173,199,159,16,17,134,37,240,182,196,211,235,217,171,31,50,158,232,127,93,255,33,85,218,208,2,183,233,253,50,189,57,69,198,190,33,109,185,96,52,78,230,20,69,98,24,106,59,81,94,33,226,84,15,140,198,236,120,111,218,86,181,182,24,21,246,105,219,152,128,109,144,49,37,57,215,18,27,149,178,149,230,50,252,238,204,109,188,137,240,54,216,72,57,201,47,72,5,107,141,155,140,245,245,232,179,93,177,187,128,95,61,69,56,89,181,172,98,227,236,94,179,6,139,89,96,102,66,33,120,145,129,175,126,107,54,106,177,177,246,153,42,88,158,98,248,87,224,64,178,137,220,99,16,183,101,89,245,117,117,52,18,164,115,93,196,235,214,132,19,128,163,57,144,248,243,59,187,235,43,20,237,252,203,241,25,12,74,17,165,152,177,138,148,80,206,177,167,53,191,157,1,173,126,74,79,9,25,79,4,157,205,113,31,67,130,20,157,163,230,246,239,4,143,28,101,173,32,47,3,174,59,5,42,8,88,191,89,95,118,107,37,1,78,196,231,211,245,133,177,119,230,208,84,60,163,176,184,120,62,158,54,58,221,168,187,15,23,243,189,79,185,175,23,156,113,67,97,135,211,243,183,146,16,170,225,254,193,245,104,122,230,228,11,57,159,238,21,154,48,200,155,134,36,43,143,156,69,174,11,164,191,101,53,93,108,197,9,56,190,195,79,240,183,138,113,154,103,237,7,142,97,162,120,197,21,95,37,113,98,102,69,159,35,32,31,138,104,171,32,94,40,247,185,125,241,69,6,65,46,162,9,142,186,67,193,111,162,169,176,15,147,222,231,0,152,182,96,32,164,220,35,75,107,152,54,63,37,100,55,127,145,175,170,60,7,229,193,224,14,54,132,140,173,111,62,222,253,193,62,157,228,190,4,35,231,239,138,111,162,236,50,172,230,157,111,37,200,95,212,172,54,181,67,21,81,240,202,144,61,160,18,95,160,170,24,168,11,59,172,13,48,249,93,66,253,206,147,92,127,123,186,13,208,138,91,127,120,229,5,94,105,52,185,46,100,58,151,46,42,191,125,230,14,7,31,99,132,36,204,33,217,51,196,187,225,58,103,167,148,76,215,139,75,27,105,168,137,221,175,93,99,174,98,189,139,248,184,132,228,187,107,11,98,117,253,59,97,216,176,243,90,84,34,31,253,33,18,251,122,245,0,230,78,232,8,152,90,241,186,215,156,95,181,245,88,71,51,159,39,75,193,253,104,65,177,193,40,65,226,81,99,88,178,70,47,159,63,202,168,173,110,0,200,14,31,107,86,197,223,223,108,13,197,216,215,48,4,155,65,4,194,170,208,249,100,75,68,49,234,37,141,17,207,55,189,138,6,34,233,90,75,167,192,178,241,204,179,199,151,24,55,139,248,201,136,27,48,56,162,108,20,146,227,55,132,59,254,130,52,150,36,101,189,40,9,242,215,67,86,82,54,174,200,6,118,180,104,136,154,141,199,203,208,53,79,213,199,2,39,213,147,67,175,82,207,74,70,215,76,55,219,213,108,250,205,115,25,9,6,107,153,142,65,183,34,136,38,3,5,136,28,174,43,142,216,56,122,160,121,119,127,149,110,3,221,249,108,59,24,195,171,22,152,243,123,63,102,106,128,93,104,80,106,184,226,125,168,14,182,97,170,232,239,211,107,148,233,239,76,103,218,175,219,54,139,232,78,76,14,197,28,72,185,146,178,99,56,124,71,83,201,197,211,101,194,120,93,220,195,68,132,26,49,153,89,121,241,27,17,153,187,252,249,25,95,194,222,102,192,133,234,117,181,227,208,109,203,85,77,138,190,185,85,162,79,74,94,135,2,4,128,73,178,35,6,121,115,255,70,156,232,233,105,245,222,233,155,70,66,240,38,179,119,216,10,126,53,195,71,181,132,26,94,214,12,212,182,167,152,17,214,220,183,92,194,223,110,0,189,72,127,37,174,197,181,59,7,144,153,93,202,210,104,209,193,174,152,75,128,214,104,93,201,35,189,0,82,73,58,177,111,41,174,46,37,176,50,47,249,251,169,62,69,187,121,255,212,102,26,165,55,203,196,114,58,46,242,134,188,45,121,67,186,102,5,14,115,223,119,204,103,166,6,37,29,29,83,169,151,48,117,208,155,83,113,174,158,165,138,149,248,110,237,139,133,52,179,106,168,225,130,148,106,55,167,99,170,213,157,75,56,207,74,35,169,21,116,109,188,132,27,223,152,147,212,199,11,59,103,201,106,126,72,126,158,182,194,178,234,237,170,173,63,140,91,102,175,190,199,95,197,185,211,214,154,246,82,232,27,136,229,100,85,11,66,235,142,138,196,242,163,94,52,133,146,79,205,230,57,104,67,138,110,227,162,160,3,82,74,197,38,158,160,87,81,240,161,197,50,149,151,190,90,183,135,13,128,128,245,247,217,116,186,195,89,53,96,9,95,241,113,192,181,52,98,59,5,250,55,85,236,0,82,59,193,78,22,14,33,91,64,63,206,71,235,42,251,228,157,61,111,62,207,219,141,83,142,63,97,46,243,218,226,71,90,231,148,117,250,142,157,94,156,193,251,235,125,38,81,68,176,155,241,170,230,135,40,205,74,164,231,166,91,23,211,30,242,76,66,95,158,92,214,56,219,142,184,93,157,247,205,169,216,226,176,55,150,64,60,62,180,250,173,71,163,47,194,38,84,4,182,0,245,251,217,248,145,38,231,173,80,47,111,91,74,96,123,251,255,83,12,109,71,125,201,91,3,93,204,195,125,159,214,172,221,112,74,219,151,16,87,176,20,144,206,186,177,198,90,123,67,80,213,97,103,53,65,202,246,33,30,58,122,21,21,205,95,179,217,183,53,6,254,216,44,8,1,4,7,20,123,130,163,114,206,168,114,23,32,247,107,4,10,22,1,196,0,0,23,50,20,140,42,58,233,42,216,16,6,138,175,39,160,217,134,118,127,163,173,162,174,25,34,185,25,100,20,236,46,121,245,152,7,88,76,100,45,88,12,23,105,157,43,140,206,222,111,236,35,14,158,110,138,14,47,0,167,199,77,117,120,160,211,163,183,193,154,117,122,70,27,109,67,91,4,62,28,197,231,133,185,204,227,23,50,229,127,133,130,159,75,33,182,223,195,68,172,186,119,9,52,105,252,13,28,16,160,57,91,248,212,242,157,178,126,23,188,188,56,111,17,146,56,140,161,101,14,93,237,232,54,127,250,232,138,26,137,155,99,149,200,117,90,73,56,186,20,77,211,177,75,191,226,35,124,2,163,241,77,156,7,37,161,19,82,7,48,105,231,135,78,70,41,179,44,88,195,12,169,123,49,207,202,84,44,154,80,19,2,123,115,21,74,88,154,159,240,153,1,159,240,73,200,22,151,149,228,67,118,110,39,174,141,30,237,56,112,64,211,29,141,211,245,39,101,72,250,54,167,21,236,12,69,210,214,53,223,58,184,53,164,76,69,37,193,104,75,46,84,46,124,8,199,86,73,163,206,38,189,236,78,246,55,228,148,64,14,184,86,52,183,102,102,92,26,186,219,42,73,2,58,73,14,50,110,82,120,29,38,144,62,232,217,139,203,23,198,3,63,216,86,114,102,116,96,11,64,30,99,114,5,21,67,141,145,151,92,62,120,108,14,152,149,9,152,245,121,48,230,213,9,51,141,245,65,55,234,183,254,221,157,20,140,50,57,134,75,212,236,58,49,169,208,6,105,109,40,164,180,90,222,27,37,145,2,167,76,175,145,252,214,105,72,138,64,200,84,70,144,222,5,100,141,158,60,168,146,108,138,110,130,228,155,200,78,91,164,163,53,179,24,111,38,154,172,187,25,230,148,219,182,79,11,254,20,78,112,148,56,225,45,23,21,108,46,149,60,204,233,34,94,185,200,43,237,38,145,226,111,190,80,55,21,204,171,228,106,251,248,53,219,98,144,81,84,249,90,135,246,209,148,194,85,109,77,69,158,33,203,10,228,134,74,125,228,85,50,58,166,154,75,85,46,248,155,43,75,68,163,77,34,234,79,53,20,28,98,143,145,91,169,55,40,250,209,177,250,173,6,195,57,12,159,58,93,168,45,95,227,20,24,77,19,30,22,124,20,9,21,202,234,174,70,135,86,156,246,150,200,138,218,96,19,53,118,22,79,151,63,15,111,3,86,145,237,158,122,221,255,131,215,43,222,247,176,239,85,70,223,32,134,242,76,70,63,165,111,17,10,245,237,240,55,18,58,225,24,247,184,184,23,58,214,78,50,11,215,139,114,242,187,108,48,37,175,215,112,122,250,207,86,67,56,19,61,57,91,202,16,36,120,20,108,251,29,164,180,186,45,125,213,197,214,95,165,51,7,181,192,23,213,4,83,140,55,2,37,243,120,129,173,159,208,27,119,133,76,20,183,214,179,69,73,68,95,115,116,133,174,73,206,252,241,170,80,189,146,151,69,175,159,60,223,83,152,124,159,109,159,91,218,163,139,125,128,191,75,70,131,159,238,234,99,111,69,92,147,152,201,6,68,113,82,86,115,193,175,8,124,239,192,181,207,161,108,190,206,224,239,17,101,229,61,95,192,248,56,19,97,222,91,168,103,175,94,141,93,117,167,168,198,222,141,132,177,0,250,81,189,227,105,53,51,57,252,150,203,141,152,134,95,4,2,151,61,7,234,182,149,246,250,236,182,205,53,49,161,234,146,220,98,224,31,176,229,97,164,48,112,38,12,24,149,229,23,148,102,199,181,136,244,76,71,252,108,45,69,31,145,60,9,57,230,160,255,12,149,102,207,94,10,16,143,97,66,105,36,62,124,5,202,21,103,57,48,121,125,213,6,154,151,49,142,34,98,249,54,94,55,189,10,251,221,54,37,212,128,132,110,234,223,136,229,58,30,189,193,11,109,60,189,47,193,235,104,90,78,40,169,142,88,20,224,150,144,225,153,114,72,21,218,171,46,30,158,154,232,173,218,89,144,96,90,118,124,69,183,23,150,42,222,35,20,176,217,111,173,86,148,22,86,46,222,91,12,92,150,201,160,32,215,85,176,215,9,253,240,255,146,78,69,96,6,107,68,10,176,78,245,24,7,242,183,250,130,7,210,6,209,64,15,149,5,40,242,178,206,169,186,69,214,200,251,43,174,169,194,4,247,128,236,60,196,150,195,51,74,222,87,194,210,174,126,0,247,221,28,64,92,96,56,0,233,209,87,240,170,168,63,49,232,243,29,168,21,27,3,210,20,5,220,112,5,171,23,177,151,134,254,143,107,169,84,23,42,241,229,90,150,148,91,7,122,203,125,198,42,195,116,143,235,13,124,244,183,171,136,233,205,204,8,119,140,12,183,105,154,226,230,128,115,100,144,98,187,9,194,101,179,207,6,16,103,3,37,109,79,73,54,106,172,75,40,42,1,218,239,10,51,34,212,160,53,141,190,8,143,231,107,130,61,115,170,235,2,111,232,194,83,62,65,18,157,109,205,196,173,139,70,236,233,143,35,67,202,230,110,16,235,210,51,120,201,214,75,121,175,174,48,221,247,200,69,107,203,190,210,200,83,51,233,79,197,106,216,122,33,242,4,53,145,241,158,216,92,74,68,52,49,215,67,196,241,5,78,236,15,15,65,249,230,113,167,103,30,208,65,90,62,114,181,239,65,214,220,90,62,93,46,25,86,217,129,29,73,63,39,143,131,237,147,13,152,47,203,179,151,227,241,140,86,130,158,181,134,220,230,145,237,221,218,180,170,25,66,154,16,88,186,169,204,55,68,164,73,217,222,255,76,142,24,213,70,159,122,250,97,117,167,29,43,216,24,222,206,69,187,223,231,146,84,218,123,172,252,183,253,217,49,133,182,95,246,44,26,53,51,242,225,145,199,71,141,159,203,8,219,191,101,229,87,1,12,192,177,255,232,28,69,170,207,50,212,247,109,120,245,159,189,8,142,250,118,116,237,205,144,45,252,234,197,97,214,193,198,156,251,250,3,139,89,162,243,30,158,248,139,148,55,29,64,198,249,226,188,199,18,123,117,71,119,188,115,28,106,8,166,73,45,147,217,201,191,66,241,231,10,10,139,179,156,239,144,76,141,90,59,217,62,66,153,207,57,187,39,108,248,111,8,15,98,123,150,58,130,121,90,63,15,163,30,164,167,117,99,80,39,225,26,50,46,122,180,93,142,2,72,162,97,127,73,90,192,208,250,234,117,122,254,44,221,215,48,125,187,163,244,67,228,208,40,160,158,175,5,65,209,212,30,151,93,41,17,71,169,86,31,33,190,64,202,56,147,120,103,255,197,153,108,206,115,121,142,178,130,159,33,147,249,228,93,66,107,154,216,165,216,240,213,60,1,166,151,150,194,172,2,199,222,60,116,104,77,57,43,11,17,112,170,241,131,154,211,170,76,207,125,174,193,190,241,203,122,199,68,141,99,212,6,10,220,152,237,130,3,218,93,230,190,197,78,14,219,166,121,243,214,145,228,49,221,135,235,100,101,242,233,140,196,136,120,126,238,8,143,226,197,80,187,86,66,71,128,228,0,47,186,0,35,237,40,164,135,187,13,20,160,11,189,89,172,235,67,247,162,38,186,106,230,114,56,74,56,175,42,106,116,227,135,117,184,206,0,183,35,200,154,188,194,80,41,181,35,11,192,33,238,248,19,180,238,68,215,109,116,13,94,156,110,97,45,140,180,150,153,210,173,144,118,36,206,150,180,255,183,162,189,250,76,141,164,62,174,175,194,150,53,241,153,103,22,14,85,161,144,42,87,129,72,28,118,151,92,93,190,130,161,120,17,108,7,247,19,43,217,143,17,214,83,207,37,43,238,195,109,227,44,123,7,41,217,196,86,160,236,72,113,225,210,218,212,38,235,158,99,199,212,202,195,85,114,40,81,146,35,111,127,118,142,111,92,135,178,165,174,0,204,132,26,121,192,51,82,137,205,58,53,26,17,208,218,225,76,50,91,38,119,216,220,182,8,137,150,223,17,173,244,145,93,51,130,213,142,53,232,176,26,20,130,20,124,253,243,117,19,168,29,152,118,155,249,238,176,163,145,113,12,158,120,42,65,122,241,148,25,227,228,58,251,215,231,27,31,111,107,58,105,222,145,93,38,20,238,85,61,252,250,87,120,132,99,33,17,157,236,93,125,148,239,255,31,147,159,96,76,131,251,35,156,47,223,170,75,32,37,175,101,46,4,192,59,16,226,62,33,183,17,79,77,150,17,139,8,16,64,253,104,12,146,84,150,109,228,189,147,92,57,52,137,25,115,81,149,38,19,27,253,213,143,189,93,247,111,120,144,137,51,186,221,55,8,56,145,168,81,135,121,114,175,56,39,158,92,157,61,119,75,49,137,96,74,8,44,124,248,217,8,117,133,250,74,1,54,181,11,38,78,144,167,229,63,12,97,36,203,139,131,225,196,57,204,139,107,143,70,84,193,177,4,161,153,71,144,147,127,19,45,141,120,36,235,143,21,52,83,123,219,40,97,94,74,41,51,219,211,54,192,102,52,47,46,190,32,238,232,175,10,76,110,6,84,238,242,125,238,166,101,28,166,52,228,167,61,124,246,62,163,21,116,235,199,90,51,255,243,113,87,105,100,229,182,244,100,143,228,202,236,128,225,34,237,113,78,222,248,180,124,118,4,98,125,53,246,109,81,13,13,23,165,171,144,129,206,104,45,22,120,14,92,178,83,34,57,127,236,234,231,43,250,69,206,132,218,82,50,249,109,77,168,52,239,176,38,57,168,57,254,133,164,78,13,130,88,38,62,112,244,183,71,93,117,191,186,92,240,131,15,195,37,188,174,80,239,65,118,56,167,131,62,168,153,225,159,210,38,146,49,182,212,183,34,239,141,240,45,30,147,168,29,255,236,243,14,32,135,40,134,240,178,49,230,254,62,222,79,72,87,159,142,41,49,38,117,236,215,141,95,238,104,63,201,144,252,71,201,39,59,165,67,43,105,91,202,6,32,125,113,189,147,95,40,57,119,92,19,163,145,60,143,182,10,194,142,250,155,139,206,149,191,23,10,96,56,222,220,155,246,193,81,110,12,119,222,32,190,40,239,223,33,81,169,32,83,240,228,83,122,162,251,156,167,210,188,230,57,189,99,153,225,192,124,229,90,41,25,146,199,90,188,140,174,63,56,238,197,123,78,71,239,19,211,158,191,173,23,185,161,41,130,13,223,171,214,93,62,38,181,216,159,223,169,225,56,7,171,38,158,250,125,124,218,95,242,220,181,193,118,246,12,170,219,148,183,1,209,93,226,112,244,7,157,6,8,224,246,120,252,22,151,163,243,205,180,248,100,62,255,112,137,124,65,62,148,54,10,187,107,218,29,118,128,73,78,150,81,70,183,76,39,40,102,151,70,174,224,248,242,245,104,130,153,83,143,165,241,209,241,95,35,44,136,187,76,207,151,84,232,110,143,110,70,83,60,234,249,173,10,117,197,231,176,47,71,56,3,84,133,77,143,225,253,184,28,82,111,60,182,61,190,126,59,121,131,178,50,180,189,25,36,89,102,115,107,95,28,241,164,121,9,74,169,121,18,143,161,47,145,57,156,10,88,0,31,97,200,103,10,67,101,188,131,168,47,152,209,56,218,117,130,190,34,128,239,238,196,65,230,71,82,88,192,249,218,161,133,181,212,171,201,246,57,34,138,174,65,124,24,102,85,120,151,97,67,15,59,93,65,119,116,57,231,157,252,94,196,69,107,194,96,141,98,23,160,2,127,164,106,134,215,186,123,190,189,233,137,102,202,139,214,126,103,195,199,141,212,231,204,152,55,51,25,184,66,118,122,40,251,81,185,188,204,145,190,15,77,77,179,166,77,103,184,149,40,120,48,2,153,236,76,124,235,236,168,224,231,188,66,115,146,101,52,43,102,233,53,229,124,35,175,40,237,180,155,193,16,8,25,189,217,160,152,135,124,10,12,178,53,119,200,91,141,29,118,57,252,77,199,93,0,9,192,42,159,151,3,93,16,13,212,219,147,94,181,92,183,171,113,253,204,89,86,172,26,206,170,54,233,194,93,38,215,94,166,152,172,141,184,144,190,91,176,158,54,13,120,31,169,93,218,157,173,98,117,181,176,230,187,171,228,247,116,196,36,106,150,86,133,247,162,134,238,184,68,15,154,39,67,159,152,73,153,60,208,109,219,113,238,7,48,55,50,178,100,89,140,88,26,15,52,145,38,27,158,96,32,240,185,196,180,38,123,21,83,123,204,39,219,134,210,62,28,84,59,58,31,179,214,29,126,197,116,87,2,103,66,187,14,28,226,68,166,26,119,109,79,32,28,187,13,254,237,136,125,210,94,159,133,48,35,108,18,141,4,145,157,35,75,109,156,98,58,237,26,47,114,53,15,71,12,178,141,55,120,116,158,233,88,129,148,57,124,68,77,187,203,202,150,138,63,183,75,169,127,73,232,56,156,184,228,43,106,157,253,42,176,145,145,114,1,116,112,233,153,119,198,99,0,94,26,206,45,12,201,172,40,146,216,5,217,156,197,90,29,218,25,238,62,237,68,197,11,0,128,172,145,97,235,12,207,172,237,103,156,125,85,30,144,169,122,89,65,225,44,182,143,113,77,217,237,235,119,184,219,36,71,87,145,99,133,139,107,214,251,110,145,79,140,149,127,71,54,204,160,243,76,35,96,108,246,114,133,30,147,254,69,198,197,118,11,239,0,92,179,237,203,46,174,39,50,196,141,21,111,176,172,247,49,209,65,77,108,22,100,249,174,71,137,157,167,101,36,144,143,70,102,144,233,59,74,160,63,163,229,27,244,16,49,235,102,38,194,170,196,69,50,11,154,28,227,216,229,251,219,8,165,171,34,221,174,64,100,188,135,149,3,134,200,45,80,24,152,50,166,36,7,250,167,247,135,49,167,183,239,61,166,10,170,160,149,109,229,137,222,56,243,55,84,49,37,118,73,49,253,199,67,196,220,83,123,104,5,254,113,193,169,36,116,113,65,180,195,19,21,17,254,103,253,7,212,193,239,68,95,44,65,218,92,157,132,168,121,75,98,132,174,11,51,195,154,77,56,64,50,218,248,12,93,120,65,244,220,176,108,223,102,182,202,142,244,216,141,220,145,167,193,230,140,57,174,56,253,131,101,126,224,80,182,233,68,150,36,69,132,233,48,234,70,243,99,228,181,242,81,127,115,10,161,47,184,230,111,255,136,17,228,35,179,235,110,102,65,24,67,38,168,231,108,214,12,141,78,35,160,76,8,163,124,74,253,222,28,38,92,45,188,180,239,222,185,113,85,67,91,48,184,89,108,81,106,66,31,51,52,99,123,128,170,235,28,233,104,238,169,223,69,183,18,185,91,182,48,24,17,139,16,237,96,88,34,21,91,126,251,109,0,43,135,213,188,75,123,124,11,155,174,24,162,49,74,229,0,147,52,124,101,25,30,42,26,181,173,81,153,153,243,156,29,166,218,119,172,132,167,35,14,131,150,206,24,220,71,135,62,154,142,26,82,122,65,27,148,12,129,15,168,160,172,64,174,23,191,64,40,206,13,57,119,194,129,119,48,9,174,48,77,201,210,212,117,135,172,30,204,159,140,46,169,199,214,43,103,142,228,204,136,31,92,255,13,149,91,159,163,193,4,89,101,125,102,2,136,249,1,62,144,218,31,96,215,93,114,176,149,23,73,90,143,195,241,246,244,216,21,215,63,83,82,47,9,170,98,34,183,130,0,219,178,89,98,236,63,3,96,144,163,212,49,224,131,57,2,102,144,192,210,244,242,251,33,111,159,65,147,238,84,63,16,94,124,58,135,189,15,175,15,137,233,139,113,83,27,184,145,46,139,97,164,29,19,51,48,14,137,218,250,132,12,97,161,1,51,86,198,168,120,114,196,246,253,90,131,131,106,182,206,230,242,84,179,99,250,138,245,17,223,151,219,60,110,9,129,134,6,212,214,253,110,171,41,88,197,160,59,229,79,166,44,121,66,92,148,65,248,95,251,107,5,166,148,153,141,88,172,24,220,47,237,118,140,213,28,175,239,144,31,95,191,57,40,162,137,86,86,13,253,64,144,213,46,235,179,52,215,55,187,82,198,167,63,123,209,94,126,104,184,170,54,191,127,136,108,107,180,177,45,23,176,218,70,233,77,10,143,50,0,171,239,78,134,63,112,60,91,150,80,141,212,198,85,106,121,201,184,2,5,222,103,59,155,180,34,30,190,42,130,177,60,234,250,129,186,206,28,164,45,203,193,30,157,199,47,57,210,152,129,20,62,23,36,38,145,44,130,0,203,52,252,141,9,213,172,144,77,210,249,102,80,210,189,92,88,60,132,89,206,61,242,221,146,6,181,216,167,108,194,124,164,183,240,144,126,50,38,126,182,188,162,57,100,14,197,91,178,178,168,160,230,198,70,5,215,32,229,12,242,52,249,51,71,69,240,240,91,184,214,112,207,31,251,242,163,50,4,118,32,18,191,246,75,89,28,61,186,21,57,85,65,28,10,51,166,30,59,109,102,33,127,136,30,224,183,201,50,10,118,29,92,101,184,85,216,205,212,21,64,142,47,77,215,28,51,189,126,178,99,142,216,8,84,189,87,119,133,95,199,254,72,63,95,43,232,128,4,24,80,176,134,250,43,63,29,221,34,81,126,253,19,158,139,37,134,108,218,0,232,156,10,202,36,107,76,230,73,193,14,233,15,137,77,134,240,69,156,45,233,162,89,235,222,198,90,66,233,184,171,227,76,76,92,37,189,41,167,247,31,131,32,153,172,228,115,42,123,135,108,214,55,34,119,250,0,187,217,163,219,74,54,115,23,213,37,255,205,237,245,5,158,154,94,65,173,52,178,14,28,17,22,157,175,5,66,234,234,230,51,185,145,157,125,56,13,174,61,182,47,114,122,14,189,172,27,189,119,58,133,13,32,251,137,233,225,243,135,23,135,127,247,201,103,230,236,12,96,170,33,232,105,241,134,42,129,176,8,227,0,241,73,239,150,35,100,9,8,189,95,8,242,68,97,1,163,189,7,175,66,69,162,74,188,255,251,8,78,95,102,30,223,228,190,64,39,133,44,19,77,149,104,43,219,59,174,5,134,253,142,208,205,52,52,255,166,209,58,246,23,156,39,221,181,1,103,210,0,65,116,188,15,15,149,15,131,230,122,204,247,128,197,104,141,241,22,251,196,209,230,253,7,171,49,253,67,246,75,21,35,236,156,37,64,195,77,196,229,144,205,92,172,29,95,196,57,233,143,33,189,86,126,56,39,84,147,17,178,75,198,33,208,26,1,22,132,180,24,250,192,38,77,125,4,96,103,209,213,7,27,79,228,98,198,222,1,140,152,126,4,121,23,199,170,135,43,231,7,30,175,220,106,133,253,100,75,116,70,6,189,59,150,51,109,199,124,209,37,210,218,165,215,163,50,5,226,5,69,34,244,138,186,42,8,252,81,207,144,125,252,47,195,150,62,158,64,125,16,94,146,89,89,216,56,234,55,101,129,167,114,29,175,52,46,200,60,235,31,110,132,26,173,50,33,8,127,152,45,22,165,135,224,49,107,146,62,76,12,39,161,127,131,229,104,79,3,216,178,123,98,40,68,57,156,95,214,218,81,254,105,245,169,179,31,133,171,103,23,230,52,246,60,106,230,92,183,236,64,254,46,79,202,98,184,233,61,128,126,19,175,114,51,155,109,172,185,17,10,65,55,137,239,166,211,90,169,86,89,201,27,159,170,171,144,221,76,193,239,91,226,129,53,188,199,177,24,230,227,164,159,43,200,205,161,154,65,148,82,40,215,126,172,143,66,87,115,216,62,254,149,149,32,35,75,99,161,80,7,51,181,86,16,236,204,81,28,53,253,110,182,96,166,4,82,207,238,45,183,245,46,8,88,197,114,168,190,242,40,145,102,224,230,7,112,244,119,149,222,154,116,8,129,178,21,57,229,102,90,93,51,81,186,165,133,222,36,197,216,64,202,206,116,220,55,202,149,44,115,60,158,192,24,38,54,237,52,221,57,185,67,61,178,217,162,215,183,106,46,232,159,219,66,220,17,15,116,228,91,48,51,107,207,38,97,17,32,253,153,102,2,44,131,29,34,122,4,252,46,147,177,27,82,178,116,164,40,133,12,68,22,180,177,23,139,251,101,26,246,240,127,92,67,50,204,160,246,135,2,3,31,33,206,84,248,243,33,229,69,254,191,219,110,221,144,186,242,70,130,102,245,11,225,20,56,254,219,249,53,139,30,33,6,194,205,241,142,245,8,61,160,31,206,214,59,131,137,82,63,249,126,33,48,142,44,224,196,225,130,71,57,12,43,254,132,24,43,236,130,76,148,75,221,123,66,4,240,233,96,197,48,32,17,68,214,1,32,196,144,161,112,140,207,211,232,97,206,213,59,181,68,113,48,134,53,40,30,180,120,194,5,110,165,240,44,51,186,120,110,46,195,162,96,236,12,38,223,61,42,164,209,33,109,33,3,23,57,160,122,51,155,241,171,47,77,148,111,53,47,252,137,35,92,59,110,241,81,97,138,157,83,55,142,166,195,83,95,141,143,37,1,118,202,47,111,79,203,73,148,122,129,16,124,147,178,197,236,39,50,153,131,221,97,17,181,64,91,169,198,206,167,47,226,50,157,64,194,89,24,255,20,65,128,140,158,218,186,175,168,55,98,40,163,154,205,174,194,225,235,169,177,27,76,86,173,41,155,189,172,136,93,131,150,45,161,8,30,233,13,186,243,49,240,151,180,6,151,37,28,23,254,57,227,179,70,52,55,247,255,73,160,214,163,18,39,248,59,62,37,86,152,46,63,124,41,231,30,239,141,25,20,127,92,247,220,130,140,110,21,106,203,206,131,175,156,42,47,92,207,238,109,171,86,203,14,103,13,14,88,181,92,124,143,83,1,77,71,188,0,15,35,41,19,2,238,160,97,250,17,118,179,15,23,200,132,210,220,154,82,12,91,235,51,0,132,193,107,238,162,99,35,7,186,161,10,126,226,191,104,129,112,237,97,159,44,146,127,3,166,140,84,34,254,241,119,20,153,52,90,165,109,87,114,102,51,129,103,160,169,242,185,185,110,121,107,195,187,234,124,114,217,116,208,245,157,75,203,239,25,220,14,209,104,230,112,30,178,24,159,77,253,199,158,14,227,34,89,226,187,56,150,85,234,209,7,157,145,160,124,44,20,20,63,248,181,36,104,13,206,32,103,5,194,227,96,116,170,124,1,179,17,227,58,25,7,185,100,113,175,129,26,38,192,146,114,117,190,15,87,226,137,245,23,201,102,135,99,49,82,73,121,228,221,244,89,37,147,180,126,203,248,166,195,33,138,179,236,221,81,173,85,184,56,22,165,29,15,48,161,130,10,16,40,113,175,213,101,117,22,59,157,96,30,199,227,108,85,121,122,36,57,221,63,60,28,98,41,210,0,184,58,231,7,96,39,67,10,216,56,203,115,20,134,246,30,70,163,245,209,189,155,2,135,40,139,245,4,1,48,126,66,30,236,226,100,15,155,65,25,4,64,5,55,231,199,243,236,165,123,210,237,133,47,198,64,96,167,44,79,125,25,29,109,180,162,10,81,125,105,153,131,135,246,27,215,44,157,77,171,224,215,245,54,12,124,78,173,71,205,210,169,182,153,248,87,60,228,192,169,151,126,38,66,116,113,142,142,128,135,200,146,114,47,74,65,134,39,79,240,49,49,77,210,226,135,70,83,56,15,38,48,8,220,58,205,175,183,62,220,152,228,184,158,9,201,156,6,86,103,228,26,1,255,95,40,5,27,128,28,34,247,166,72,223,11,141,58,8,103,219,135,177,14,171,164,45,89,66,205,252,202,147,231,220,209,188,62,210,177,196,132,217,219,161,253,131,222,154,138,210,169,116,232,17,133,100,64,234,44,109,28,235,243,179,74,251,206,36,21,44,95,113,81,33,44,207,29,145,209,90,30,226,209,206,62,64,199,110,250,132,238,140,77,161,222,144,195,103,169,59,162,31,78,108,200,105,167,33,83,152,86,91,43,222,248,170,4,102,135,242,138,95,35,103,195,132,6,33,53,177,230,175,255,122,205,53,43,183,8,66,202,123,56,199,113,250,145,67,45,49,138,76,145,30,221,188,72,155,80,73,40,251,220,79,228,100,211,145,133,241,17,188,211,113,17,106,169,16,197,76,204,125,56,71,60,103,70,195,97,164,167,204,198,47,97,245,13,22,100,225,174,195,228,38,86,11,50,59,31,49,203,177,84,210,201,172,171,162,200,159,73,62,82,45,220,53,59,158,178,173,252,142,67,78,59,171,169,130,163,36,246,232,38,210,114,43,190,192,70,89,39,252,210,40,117,10,174,221,13,42,141,170,77,58,246,172,41,237,200,126,165,134,230,226,32,131,175,118,250,184,131,19,182,13,146,184,198,37,25,27,129,123,19,72,166,35,150,252,132,103,18,104,219,198,147,88,235,113,20,102,5,54,168,22,227,111,16,160,20,136,47,235,224,242,122,217,238,20,59,34,58,216,153,184,91,191,74,146,120,120,86,71,46,185,119,196,65,43,85,132,155,29,200,58,217,40,219,15,41,150,105,57,100,58,26,53,43,1,72,55,55,46,3,239,236,178,145,238,213,231,140,74,89,188,63,172,233,101,6,131,82,249,141,101,29,222,56,59,215,157,62,114,249,13,121,158,78,46,12,122,235,132,83,158,252,91,133,150,151,46,44,111,227,89,121,191,137,162,44,5,0,85,117,141,149,51,106,224,10,7,216,23,208,23,149,243,156,170,101,236,212,237,153,168,242,220,56,178,61,114,198,190,248,104,2,235,73,123,108,249,68,74,216,175,186,189,14,239,46,69,96,156,6,0,117,46,131,177,19,138,57,46,143,238,39,79,34,74,244,21,233,224,156,43,152,60,102,50,237,85,236,36,107,20,182,35,240,115,210,19,190,21,222,191,0,179,215,181,51,125,211,160,203,36,237,13,169,20,100,86,21,105,101,168,176,43,122,233,16,227,88,233,119,30,114,241,161,100,180,214,36,114,170,52,151,21,199,10,9,239,53,59,2,25,13,28,122,213,188,216,101,16,11,153,50,90,96,179,15,207,126,26,8,254,241,59,149,179,253,193,63,155,209,208,188,53,26,204,41,146,76,222,189,125,90,138,199,162,183,36,132,173,207,121,85,194,180,214,33,72,208,93,188,181,228,108,47,68,73,89,84,185,94,211,102,105,22,186,70,37,45,33,150,206,70,36,76,46,108,169,219,173,49,74,206,227,96,90,193,0,42,143,215,176,231,69,160,166,225,115,25,109,136,231,120,45,156,144,12,99,154,3,245,125,138,68,119,222,62,8,218,49,127,84,133,83,38,14,212,59,101,115,103,71,133,153,32,190,215,174,188,123,71,47,109,143,212,228,4,104,82,32,104,63,221,189,103,95,84,18,80,125,130,113,108,196,66,30,170,136,37,97,166,198,121,76,104,54,9,68,34,144,118,149,201,3,26,67,137,155,132,117,88,42,144,223,32,178,185,213,167,8,72,112,208,9,236,153,164,133,79,0,189,229,146,144,108,38,89,20,110,82,71,225,86,123,82,115,250,203,40,47,83,195,166,179,60,112,229,32,68,203,189,164,213,142,80,120,87,200,96,35,194,43,6,134,155,188,123,245,146,208,110,197,0,230,41,45,179,73,145,27,203,81,78,34,201,194,37,159,205,65,94,37,217,199,183,28,12,110,33,119,191,192,23,30,60,202,103,16,228,131,110,219,7,229,85,21,181,162,64,223,222,166,10,57,29,140,217,210,133,132,252,251,49,223,179,222,217,100,78,37,35,218,240,128,22,218,212,38,197,114,127,193,91,220,209,119,218,195,170,146,218,50,97,0,213,163,168,219,98,123,147,204,182,255,115,250,248,159,86,114,18,244,197,206,62,28,236,132,19,148,27,196,226,154,229,201,39,225,227,240,27,38,104,238,91,114,167,25,59,15,90,170,20,132,174,79,139,190,45,9,82,12,252,187,217,242,217,77,107,94,180,158,59,130,83,41,198,81,3,231,51,46,110,190,199,125,156,168,6,118,67,33,94,253,159,230,1,189,17,40,68,220,185,211,68,210,62,29,135,57,34,211,223,171,182,203,59,45,60,246,216,187,191,161,37,182,57,218,234,248,127,197,237,32,226,92,162,193,89,250,159,39,228,119,180,191,229,162,219,225,39,217,17,14,158,84,83,213,49,100,5,211,16,210,158,51,254,143,105,81,99,48,146,56,165,65,33,207,99,176,47,107,119,42,55,49,105,203,112,126,246,228,122,233,28,136,196,29,250,235,83,83,27,246,120,113,50,98,16,34,8,48,94,89,2,239,96,153,24,25,252,245,23,233,33,35,159,165,126,234,12,175,248,229,197,84,56,126,148,86,29,105,156,74,114,26,38,166,18,120,161,154,24,170,216,111,178,117,188,190,49,198,68,133,189,182,193,101,234,175,121,211,222,70,203,194,44,105,221,213,255,222,105,168,189,223,155,55,46,169,190,47,53,234,193,222,61,10,197,224,205,50,9,188,84,230,244,121,58,173,174,36,76,10,81,134,78,83,218,177,180,142,19,171,73,93,234,43,138,50,238,145,135,54,191,215,173,55,28,48,14,16,27,167,207,39,190,81,34,229,224,51,39,47,108,56,20,174,38,244,53,36,71,255,142,25,201,30,96,116,69,72,52,10,129,65,2,87,247,59,234,248,182,120,17,140,238,244,252,253,98,195,26,121,199,246,229,60,28,205,176,172,29,247,18,83,2,64,135,162,226,131,58,118,249,244,130,176,24,201,145,117,101,191,142,197,143,162,36,96,106,178,66,23,239,114,119,159,68,24,10,225,35,40,109,179,121,53,178,176,48,55,123,220,67,13,170,106,50,23,37,242,126,64,228,153,83,41,149,224,43,175,243,202,153,69,4,225,69,184,0,15,178,141,182,132,71,200,192,185,187,245,176,166,28,67,36,30,179,79,61,143,31,99,193,157,224,123,115,167,119,6,17,55,9,209,66,30,153,38,29,117,200,134,218,134,171,69,35,134,10,69,221,172,196,25,104,190,232,19,137,174,195,224,212,30,55,222,189,165,50,96,182,18,8,233,15,150,1,252,92,254,9,66,212,178,126,97,11,96,56,142,114,145,80,98,114,17,150,187,123,137,7,29,236,238,117,160,43,85,83,36,234,194,236,82,104,15,22,193,216,136,121,243,181,224,117,51,200,132,65,138,3,28,65,15,70,220,104,33,64,13,251,225,60,156,238,91,13,66,120,253,123,68,230,83,203,42,122,83,123,85,192,170,106,56,224,247,141,198,153,5,127,6,98,26,157,73,45,59,151,10,112,180,56,3,63,200,7,251,43,117,134,74,70,149,187,236,97,52,158,114,8,14,201,236,191,148,75,98,26,59,225,203,19,218,169,238,22,81,166,187,24,199,152,169,229,35,106,19,214,49,143,160,238,114,4,186,197,54,11,83,74,122,28,181,29,255,165,75,253,160,16,186,40,82,48,75,76,37,235,130,120,175,197,237,67,131,207,49,62,134,194,39,122,20,175,182,47,9,161,96,156,244,165,84,108,45,219,13,235,246,133,156,57,41,183,45,189,143,85,156,98,51,235,61,52,238,97,83,107,43,177,161,8,25,84,215,96,207,221,34,47,31,230,193,116,150,42,161,114,89,99,22,123,100,111,178,9,116,202,126,150,189,92,99,215,19,168,218,157,172,168,146,223,149,110,162,255,91,170,161,211,55,63,106,111,146,43,8,36,61,238,107,180,96,169,107,171,89,86,121,12,59,43,237,77,11,99,180,183,202,133,95,130,8,113,243,247,22,86,145,1,10,147,174,203,233,70,133,133,71,123,88,21,24,76,147,204,82,247,114,173,252,79,198,207,220,117,87,28,120,254,203,79,103,174,48,24,106,215,80,71,42,114,54,138,78,76,22,180,195,246,32,104,231,6,84,42,157,235,37,140,87,27,136,155,39,205,225,65,41,23,28,110,250,59,156,38,225,88,24,104,97,205,197,154,146,198,142,89,138,227,151,119,162,0,242,95,249,35,92,255,195,208,171,134,198,46,227,245,213,172,134,253,172,42,211,195,145,58,133,173,36,250,201,83,119,85,214,54,32,120,197,82,15,211,112,71,89,214,197,30,201,81,206,81,76,141,3,99,253,124,247,156,121,251,216,249,251,195,27,92,243,188,244,61,184,185,0,164,31,137,219,9,192,143,179,135,9,12,195,164,11,239,54,157,227,22,206,191,160,11,164,81,48,18,29,164,85,20,45,230,96,146,231,143,26,11,133,133,223,105,123,21,109,208,252,113,210,170,61,110,211,241,22,102,208,63,127,55,211,35,33,214,198,118,194,96,204,124,36,223,168,5,0,139,226,90,221,32,232,22,192,194,49,107,199,19,157,33,163,107,193,226,234,252,198,42,169,86,81,248,65,235,244,149,215,255,17,62,49,121,117,249,39,56,152,58,16,88,127,138,33,10,78,194,211,94,194,41,39,4,17,132,113,141,123,38,40,33,144,108,248,31,72,146,225,160,143,106,226,168,48,108,252,166,48,124,223,162,47,223,115,228,229,65,94,151,64,170,203,57,223,25,228,134,111,190,196,232,234,202,132,161,213,203,165,40,108,51,178,240,71,242,134,69,4,36,206,157,44,228,79,72,19,81,132,176,178,85,237,137,84,77,91,90,205,139,24,199,148,56,15,111,2,200,9,67,244,167,35,178,172,253,169,243,234,167,225,175,89,137,8,240,250,86,21,109,227,171,189,88,116,196,232,13,127,43,88,0,204,170,213,199,141,105,153,96,57,39,181,201,133,139,187,156,67,86,167,234,137,46,78,149,176,110,144,104,17,59,130,159,221,64,194,114,41,61,154,170,214,4,40,91,13,185,137,191,82,122,56,186,237,150,217,252,196,132,42,48,66,59,216,251,212,219,46,99,103,148,187,155,231,15,88,189,181,36,220,65,79,9,72,181,34,57,141,135,83,30,13,203,79,94,91,134,106,232,182,205,8,232,33,98,226,205,253,208,221,94,52,22,73,233,99,7,211,178,94,244,253,79,38,232,60,109,24,243,105,220,160,91,44,104,56,92,64,72,160,155,119,112,253,33,253,41,199,240,147,184,183,77,75,18,56,249,116,31,181,32,218,185,188,57,146,214,214,116,240,49,175,59,160,153,249,1,79,74,139,80,66,4,193,207,131,123,140,136,111,164,233,70,26,210,76,7,107,164,143,76,199,93,50,141,56,65,242,24,113,67,21,249,90,103,56,130,165,43,231,249,153,185,255,102,2,64,15,208,165,80,24,98,245,18,104,8,231,154,236,172,118,35,234,186,254,248,202,173,103,89,160,0,94,153,78,163,112,172,213,244,246,6,1,53,125,238,6,208,166,2,152,140,45,100,200,171,95,177,85,101,103,100,60,15,31,232,82,228,57,116,54,77,250,123,20,124,195,51,169,57,120,199,5,17,102,241,23,254,145,107,220,120,33,107,194,53,251,10,11,196,19,167,166,246,61,43,205,9,195,14,229,127,63,3,253,159,252,236,63,27,56,74,19,112,230,170,214,253,92,0,63,81,1,213,218,242,87,11,103,81,85,243,78,36,123,159,6,27,209,113,61,88,127,159,231,179,160,157,102,35,255,38,95,175,198,174,46,15,88,32,122,58,35,252,116,65,45,78,242,207,27,80,49,49,234,246,193,227,223,72,72,119,157,94,224,11,199,21,153,234,253,87,236,72,227,114,148,43,81,6,153,226,119,203,66,235,79,18,191,45,156,198,76,78,242,3,189,111,168,129,176,175,43,216,88,1,46,142,167,86,237,206,84,168,171,218,194,70,235,166,171,46,170,165,69,172,168,8,5,101,64,209,244,44,84,92,39,130,51,180,81,33,36,110,64,137,137,248,60,30,193,166,192,242,41,182,158,57,101,158,98,117,14,185,46,41,161,177,4,168,113,171,199,179,88,10,212,48,118,210,215,170,129,48,187,93,42,202,218,254,204,163,179,84,50,125,100,34,52,29,161,25,240,48,58,58,46,233,180,53,223,155,192,45,36,55,242,227,177,210,109,42,167,206,113,219,223,233,111,54,151,126,228,177,195,232,127,104,243,30,230,204,194,197,97,244,200,247,185,115,150,137,147,30,226,132,173,22,129,71,153,226,5,171,151,129,124,198,102,3,197,112,0,64,122,166,106,39,120,157,144,209,102,222,146,56,70,207,107,130,80,51,83,77,82,153,194,107,80,54,72,108,11,77,223,130,74,244,126,38,31,68,205,27,240,203,229,202,21,83,109,233,26,11,51,146,147,43,150,99,66,204,215,77,74,80,47,121,183,64,157,82,131,90,39,207,139,73,128,157,23,37,253,43,23,34,222,31,53,237,229,243,205,87,194,182,9,242,215,255,217,92,210,94,60,122,39,133,195,90,199,127,28,118,206,80,204,4,2,64,252,36,0,137,251,233,252,69,189,49,12,45,246,241,29,235,122,230,90,105,248,229,20,170,143,131,195,239,234,48,39,228,62,111,110,179,12,236,85,241,14,34,253,250,141,6,42,244,103,185,234,252,168,123,152,243,91,24,208,190,30,73,28,152,231,160,33,175,20,116,132,227,208,236,111,76,208,205,33,188,215,165,53,246,50,202,21,225,96,175,36,100,55,246,53,185,114,211,113,141,48,127,194,229,57,113,80,216,169,51,208,193,132,11,226,239,114,121,81,219,105,76,205,210,77,239,76,13,186,245,208,251,94,244,96,231,243,122,198,0,94,208,222,214,31,109,75,94,3,81,101,240,1,211,241,88,18,60,244,66,239,242,244,59,58,103,237,160,138,121,114,170,17,227,179,86,147,36,116,111,26,224,241,177,238,215,230,111,134,60,240,190,229,153,9,79,40,112,42,45,45,164,161,50,204,204,64,136,246,26,183,151,102,115,229,174,133,185,234,102,180,94,225,242,211,210,68,213,192,216,221,222,102,71,79,185,69,235,55,117,237,13,253,171,100,238,105,173,150,207,23,146,0,79,205,116,211,222,48,118,167,172,238,31,87,119,251,142,164,241,187,214,196,147,100,92,83,226,105,203,243,145,58,199,173,172,88,200,50,192,146,79,84,22,217,117,150,46,115,16,69,210,63,120,214,236,184,168,85,216,45,71,209,63,170,234,211,105,138,89,61,3,125,208,226,13,141,74,3,188,1,236,114,239,2,11,225,31,64,208,167,197,6,56,13,221,158,231,36,166,0,118,181,50,94,232,61,126,248,65,84,53,215,60,190,29,38,126,57,71,184,74,90,233,204,97,224,140,95,192,70,246,202,117,45,109,71,128,255,230,198,127,136,85,65,165,88,218,253,223,176,233,16,255,237,231,160,221,139,46,124,51,100,93,46,203,75,29,200,196,123,112,218,74,10,221,245,77,120,144,75,230,116,251,179,38,235,88,169,47,136,96,165,104,73,166,181,228,66,33,2,112,238,183,179,31,147,33,99,27,52,1,168,38,110,132,106,205,146,106,139,169,134,27,229,58,237,13,31,120,158,181,36,105,112,75,115,13,20,73,77,247,113,66,215,135,109,216,39,153,235,30,86,236,152,139,246,72,255,17,21,6,189,27,244,216,18,51,18,30,107,79,216,42,52,27,165,139,70,228,122,101,134,247,213,53,116,141,71,236,86,211,45,162,29,4,144,177,31,217,235,168,233,0,38,117,211,40,192,213,26,188,67,50,71,27,197,18,52,61,75,172,185,31,84,97,49,197,12,72,221,36,161,106,68,205,24,137,167,71,169,72,134,189,247,82,176,164,127,74,25,117,19,122,52,13,199,199,132,112,62,52,238,57,138,245,81,83,207,42,194,132,80,19,74,154,19,73,11,202,14,233,103,202,59,93,200,215,129,106,168,144,211,87,151,229,150,44,14,148,233,205,171,59,52,42,121,133,224,160,219,2,90,234,15,71,0,99,184,102,85,80,33,113,144,168,220,209,133,122,40,50,134,229,240,210,8,63,147,225,250,223,28,70,232,203,9,238,113,248,24,189,2,252,230,246,224,91,238,93,149,38,37,70,54,103,176,195,81,11,156,253,139,19,172,217,148,95,232,114,190,126,167,229,182,189,44,118,146,124,134,62,66,39,233,234,174,62,145,219,236,44,134,251,162,53,139,164,129,23,241,34,164,169,9,189,64,29,81,223,155,92,191,230,170,34,225,12,159,13,152,183,188,160,122,203,158,127,16,154,211,126,61,176,109,120,3,27,199,112,165,13,15,197,20,225,56,116,63,171,237,91,52,140,194,196,49,162,13,109,43,43,210,214,243,161,212,218,82,31,110,56,32,157,180,70,48,161,97,5,200,242,218,92,199,8,118,108,31,55,221,186,212,151,214,178,108,125,243,184,148,234,88,117,228,205,233,191,207,233,159,196,175,87,185,169,201,152,53,112,39,27,140,120,10,146,198,63,227,183,164,37,29,136,29,86,12,36,170,51,42,233,230,227,87,192,144,26,44,176,251,30,55,20,45,99,128,164,43,84,139,137,112,222,114,59,67,88,25,166,35,49,95,38,109,83,191,3,249,12,253,43,116,189,105,17,145,148,52,58,122,63,59,71,167,181,6,229,125,155,42,197,220,101,222,175,210,35,26,237,214,107,168,240,17,30,136,85,202,108,184,170,178,243,245,161,32,209,236,52,33,176,133,133,224,233,130,8,106,2,28,198,218,152,198,26,132,152,88,160,14,200,197,8,95,108,57,14,10,120,200,220,17,82,56,94,42,100,238,247,68,215,8,81,35,220,112,244,106,66,46,217,1,178,52,62,54,242,183,114,87,19,49,72,151,50,153,223,120,162,199,51,47,46,168,79,24,250,123,54,157,245,60,177,243,55,246,14,187,139,24,49,234,82,3,120,198,121,147,50,217,113,250,117,209,207,153,58,106,46,91,181,92,232,106,16,110,222,58,161,91,69,121,170,113,94,47,135,94,37,65,101,107,201,151,87,199,108,37,122,74,220,152,60,195,120,57,129,165,201,34,52,54,3,169,62,239,69,195,59,34,28,92,116,194,167,237,30,94,30,117,210,200,181,227,225,184,215,122,245,237,213,6,131,67,255,124,175,243,101,56,247,196,81,41,230,146,2,6,254,180,84,29,106,153,112,63,162,205,170,216,125,109,11,230,141,158,175,224,211,101,91,144,69,230,85,243,216,14,109,180,31,246,32,74,9,164,93,81,125,225,44,29,173,172,69,114,229,225,96,195,123,182,67,132,202,226,20,171,51,222,202,204,186,9,208,13,78,8,196,11,185,3,105,48,76,80,92,13,179,245,166,234,216,26,142,151,171,41,124,172,117,97,244,193,54,2,5,142,166,177,237,15,139,198,41,97,130,111,129,68,33,223,12,2,36,164,30,67,216,13,254,226,33,178,192,154,234,8,213,25,181,125,130,101,243,218,206,215,122,201,174,235,78,214,81,52,94,170,16,254,91,148,36,17,46,188,33,225,224,31,15,187,206,157,79,121,99,179,112,89,255,147,214,115,194,27,28,13,53,75,24,27,173,201,19,100,22,254,216,167,4,83,72,198,39,133,53,175,113,7,53,238,64,129,65,94,35,247,54,179,154,81,185,44,9,207,94,139,114,19,62,86,101,16,209,240,113,6,158,114,218,204,11,92,229,103,240,14,1,96,134,146,28,33,54,116,61,253,246,51,146,236,193,93,87,32,227,209,26,217,68,201,245,54,21,188,99,63,219,123,152,143,101,53,46,11,233,224,137,137,6,77,62,14,244,235,113,21,235,240,151,35,244,202,165,103,46,219,153,44,192,75,76,198,160,232,144,59,89,179,127,43,237,191,132,91,230,118,94,126,244,135,212,54,156,216,12,83,244,209,214,226,164,141,52,10,5,147,78,68,93,112,30,9,242,159,244,90,31,151,59,8,192,198,230,90,204,124,53,55,133,248,167,107,167,143,148,46,238,207,108,210,230,76,73,96,179,33,79,177,48,138,118,190,182,14,48,141,186,244,123,116,18,102,25,64,55,179,108,122,88,231,40,76,230,28,24,156,227,217,202,20,133,244,188,110,8,216,198,173,67,209,59,244,207,241,185,221,78,204,166,83,26,241,103,25,146,9,8,215,143,8,237,136,122,23,92,30,220,85,228,54,247,154,213,235,5,183,164,62,73,125,208,0,112,99,108,185,73,41,224,89,106,82,24,165,61,78,166,144,104,240,10,193,108,175,192,39,243,164,182,223,136,127,94,56,254,195,164,3,137,223,144,169,31,190,118,13,6,238,210,210,118,151,139,250,115,89,216,195,222,32,53,87,18,170,195,134,247,232,114,251,16,38,237,109,253,81,94,16,148,133,18,148,98,152,67,25,28,187,82,143,45,158,8,31,114,183,230,86,179,99,138,151,25,17,231,112,109,72,98,151,66,61,50,82,114,151,190,164,65,13,204,231,60,194,17,71,75,156,143,69,38,30,36,136,70,29,166,173,144,82,248,139,64,234,183,112,171,39,5,141,27,248,191,179,50,216,172,203,9,111,15,199,48,228,21,169,196,65,3,47,54,178,178,162,197,48,169,60,114,152,162,247,123,169,98,158,150,4,30,225,159,240,111,143,152,141,162,242,176,48,119,202,59,134,44,131,140,68,19,125,7,104,251,192,235,26,53,214,161,182,71,50,56,208,94,232,164,242,18,194,35,26,138,219,190,60,242,63,41,11,153,223,215,169,255,34,21,21,171,65,142,107,83,146,116,6,109,67,149,175,250,158,246,18,88,64,57,141,172,162,51,27,240,64,83,182,151,5,53,12,47,103,83,250,180,200,129,116,209,115,162,240,198,44,19,116,93,174,135,44,16,246,201,179,9,233,180,227,62,47,138,72,20,140,192,95,186,237,2,27,10,33,236,125,27,79,121,216,215,225,187,25,179,118,112,215,228,191,6,94,74,54,214,253,142,211,248,64,94,48,103,179,243,32,139,220,142,247,205,235,9,173,206,212,144,45,200,247,50,152,143,179,174,77,108,240,207,181,204,15,68,206,108,231,75,181,82,136,14,146,113,195,14,104,147,201,95,252,97,197,29,190,158,173,116,0,203,127,236,238,210,109,81,83,209,122,254,231,183,112,148,36,106,195,30,179,204,12,243,13,236,212,88,75,141,188,157,45,218,207,76,54,138,203,89,150,40,249,114,202,132,160,239,129,57,248,16,99,126,19,235,30,52,204,170,81,209,158,3,102,87,63,162,77,254,172,163,102,56,84,168,70,111,64,128,86,143,34,144,142,40,201,138,131,58,67,116,47,67,217,133,148,146,75,147,195,202,100,103,69,150,120,121,99,28,155,53,182,148,217,115,167,251,213,182,214,164,197,156,74,29,46,23,249,189,229,248,207,46,246,44,195,164,231,160,186,206,170,9,203,211,16,68,108,86,87,224,10,208,48,147,205,86,170,204,71,104,35,78,183,166,163,208,67,191,238,148,152,37,230,209,112,7,253,133,146,50,225,4,224,66,90,52,48,69,46,24,229,112,179,92,230,68,130,134,9,57,74,79,226,109,132,200,131,197,157,0,145,221,147,214,241,44,140,228,145,206,96,113,202,232,33,153,135,194,29,129,200,248,117,163,38,101,86,216,52,68,224,137,110,211,88,217,99,135,202,157,56,40,33,159,96,104,144,157,27,223,251,209,85,192,219,239,143,43,251,205,112,230,232,113,15,30,250,36,138,196,239,242,36,69,51,116,142,142,129,253,213,79,107,37,200,151,3,228,222,52,35,90,18,66,111,255,95,43,26,114,142,61,195,113,241,0,16,31,218,120,205,170,248,64,237,204,222,214,83,161,12,67,92,174,8,193,164,129,27,95,116,188,246,67,213,181,8,100,195,182,254,169,204,28,140,78,100,69,25,99,85,100,38,149,103,184,233,154,173,253,195,128,190,154,236,87,164,210,4,124,49,93,198,152,84,240,206,140,205,214,34,108,119,234,176,215,196,83,200,132,84,204,176,203,46,234,222,163,137,86,226,55,113,98,235,160,174,237,218,122,9,161,30,13,102,222,178,87,48,145,17,1,107,100,19,75,202,63,40,84,168,84,19,241,238,229,177,27,173,145,123,74,34,157,53,18,91,209,127,207,7,108,185,102,37,62,46,201,128,96,173,140,191,23,199,247,118,73,146,55,168,230,82,135,31,141,225,140,40,236,16,14,220,185,230,173,154,75,193,253,208,198,209,189,159,26,97,206,117,220,84,178,141,87,49,48,231,173,21,160,168,246,33,141,82,107,109,34,190,32,58,207,208,51,242,247,24,88,37,11,208,13,67,187,164,70,112,14,81,135,78,178,183,122,69,81,161,188,184,150,241,206,133,230,178,163,64,70,239,251,129,230,87,180,168,74,129,162,97,208,15,7,142,70,80,10,246,146,41,26,82,113,73,62,125,4,214,246,164,20,134,50,234,5,83,236,170,160,227,220,231,20,119,8,4,64,203,206,62,206,91,168,48,33,78,253,39,222,160,98,4,64,170,171,140,184,192,60,94,192,182,80,15,183,91,28,63,28,131,68,6,170,160,232,168,15,135,158,191,2,141,161,35,213,175,48,100,15,205,157,255,101,89,21,183,242,142,91,42,17,246,114,100,242,222,235,2,22,215,188,51,237,60,4,5,153,147,174,59,213,149,226,71,162,66,127,11,116,186,65,98,76,160,253,10,126,211,248,112,183,61,249,169,157,138,193,66,160,247,131,178,8,206,32,135,43,87,146,190,118,184,36,158,39,139,202,43,148,10,233,64,126,55,172,165,147,117,47,153,235,182,191,119,149,32,198,217,95,207,48,94,190,195,10,128,234,166,0,1,90,48,37,140,125,91,31,125,45,59,7,112,123,131,145,246,39,72,171,13,214,75,206,57,95,174,16,110,154,46,62,68,73,129,42,58,165,191,16,90,226,32,147,190,245,22,9,154,201,198,7,52,200,45,70,97,242,238,104,14,155,238,22,75,225,245,101,51,201,60,74,22,86,250,21,47,113,255,87,26,219,28,193,53,146,56,83,22,217,186,200,64,79,28,160,213,217,192,202,36,7,120,150,74,56,206,19,158,242,3,65,74,233,47,154,17,210,83,246,115,19,146,246,172,133,83,54,33,91,83,241,204,221,82,87,104,154,0,212,142,217,179,245,42,34,96,83,236,227,67,0,87,36,213,168,232,6,15,42,237,113,90,105,216,233,218,227,231,228,22,24,126,183,227,244,183,9,25,23,247,116,231,60,212,209,91,243,243,115,243,97,112,1,180,237,85,201,184,235,74,99,152,140,102,63,105,16,128,219,212,3,77,139,203,214,184,83,24,237,75,118,236,78,118,115,123,226,207,107,201,234,155,54,154,237,209,109,223,20,178,41,162,26,146,193,29,216,177,68,167,2,184,115,100,179,230,233,129,65,94,125,119,127,83,194,125,222,94,255,169,116,146,134,3,141,34,180,42,122,87,144,236,37,145,250,135,123,221,109,221,16,82,57,216,216,48,133,240,131,94,55,232,109,28,206,111,10,108,62,11,202,48,83,105,78,133,50,215,211,96,105,246,14,89,49,69,113,10,175,67,132,55,49,21,74,80,79,86,128,21,221,253,25,111,209,86,29,227,204,250,115,104,13,149,14,47,243,78,147,14,172,152,227,47,170,85,130,15,99,115,55,196,66,146,63,29,43,176,24,162,60,29,75,98,114,147,172,74,230,166,250,179,212,69,166,11,56,61,164,125,201,91,166,65,196,116,69,170,217,80,68,120,236,209,81,113,84,61,8,68,13,247,44,102,47,23,87,23,145,177,39,60,195,42,225,225,172,35,215,253,205,159,221,103,173,67,20,193,184,101,9,101,138,186,236,36,167,89,183,114,141,133,24,105,139,112,204,220,229,54,21,120,251,103,157,104,228,238,197,77,11,31,151,98,143,212,239,100,223,245,205,50,201,12,143,143,52,210,145,50,170,158,105,24,13,253,115,228,99,22,120,19,19,234,211,75,19,224,253,227,134,212,114,165,185,152,207,5,131,69,190,111,40,22,14,166,5,61,238,104,133,216,235,30,94,143,75,207,165,219,31,168,210,255,135,214,160,22,180,242,107,144,247,239,53,54,18,252,197,211,10,183,113,220,33,14,69,121,4,164,195,199,173,158,155,72,28,245,237,220,176,40,125,230,148,65,51,130,166,81,153,22,247,69,38,126,116,117,156,126,90,41,181,59,117,97,123,154,75,68,40,77,220,14,125,29,244,100,87,94,186,158,7,30,240,89,105,48,54,196,172,251,222,86,87,194,88,184,185,46,187,218,185,129,102,231,122,170,146,255,188,174,207,223,131,1,147,222,11,116,235,236,159,252,58,52,143,234,93,15,182,197,7,18,156,230,84,3,243,71,185,175,11,149,30,62,79,118,30,125,161,156,36,235,58,199,24,40,22,115,176,224,126,139,176,230,130,163,60,4,241,223,149,33,179,212,221,110,169,106,176,47,32,76,4,117,140,105,102,185,251,112,11,102,185,103,177,144,92,45,36,240,29,184,204,86,180,47,220,191,52,103,172,58,38,136,27,68,19,210,105,6,44,10,187,127,207,162,191,106,142,233,183,104,185,90,123,4,205,168,36,25,218,187,223,14,176,246,106,74,17,16,182,66,163,243,165,164,30,105,111,27,138,234,189,155,239,211,83,103,156,101,165,79,183,201,194,191,125,80,250,170,163,216,33,118,167,65,76,20,171,140,127,3,194,253,211,39,226,191,140,24,167,212,133,20,245,104,173,229,127,241,221,19,57,77,43,56,68,189,97,9,157,128,190,62,219,179,122,223,172,215,25,218,51,77,242,157,248,233,2,210,187,221,130,197,201,70,31,247,132,224,142,210,182,174,166,29,34,228,58,162,83,127,204,37,12,231,21,165,19,34,62,199,7,241,7,51,216,173,111,162,49,245,47,53,217,236,135,163,196,205,232,86,247,2,9,70,61,69,107,5,98,44,254,64,255,147,160,20,42,242,2,115,254,129,93,235,135,112,163,115,117,172,64,57,3,189,8,211,12,143,205,166,123,34,63,174,186,56,202,184,114,57,249,169,236,65,176,125,46,94,227,137,101,224,187,198,183,93,138,30,88,223,39,80,82,38,30,108,217,121,11,112,81,170,62,238,118,68,131,250,90,165,142,87,254,121,182,48,85,62,253,12,232,124,200,243,236,153,81,128,213,94,33,77,225,255,46,167,153,7,0,134,170,36,174,50,248,26,32,110,208,241,198,12,58,235,58,24,123,38,79,38,151,171,100,13,68,226,176,34,210,168,97,2,168,215,55,9,140,237,111,19,70,219,197,56,172,193,186,75,16,115,131,210,133,58,155,84,248,45,128,144,13,9,153,115,3,97,149,75,14,42,72,67,38,236,30,135,245,83,82,149,99,227,216,236,194,191,21,146,169,169,196,15,0,242,68,192,46,11,252,218,163,68,81,201,229,139,227,210,47,52,178,40,251,89,108,232,51,80,195,228,100,94,104,251,29,132,251,58,231,119,180,70,100,16,243,153,76,90,66,213,16,178,107,106,217,234,133,137,25,209,147,69,113,66,238,177,198,108,24,139,213,246,236,139,213,211,35,151,162,99,1,111,105,216,226,58,226,149,239,176,219,46,199,56,121,45,87,193,222,57,3,185,161,107,94,223,100,207,83,170,179,183,30,183,110,20,158,11,82,181,92,189,100,146,92,85,167,184,250,56,103,220,172,236,59,207,163,95,48,176,25,74,200,120,184,88,35,182,80,10,3,121,190,112,216,217,206,94,89,168,232,167,26,119,54,3,82,205,112,184,134,119,144,53,212,170,179,112,222,113,218,232,251,83,189,216,223,204,189,74,242,219,142,75,214,184,252,79,178,111,152,255,215,154,231,144,91,85,3,65,73,153,83,233,108,103,61,172,231,195,6,248,184,119,65,16,208,168,126,13,202,187,166,135,10,91,102,3,87,221,40,99,166,204,156,4,38,30,165,93,44,24,123,6,35,83,131,68,61,237,65,37,86,21,139,81,109,195,79,234,87,110,73,251,158,222,118,218,159,182,79,103,149,197,19,81,152,61,70,106,152,218,97,99,151,90,133,16,215,76,207,241,20,179,78,227,9,46,218,32,0,184,47,96,56,228,197,248,114,191,206,9,84,57,240,182,221,221,209,45,89,45,35,89,220,175,121,21,232,89,231,215,1,110,137,201,249,81,215,73,226,169,55,24,235,45,243,76,42,56,130,53,154,221,140,72,179,58,212,176,6,59,52,171,217,129,114,55,167,144,145,159,60,17,218,55,57,23,252,135,159,222,192,178,175,16,137,70,150,98,140,167,42,102,13,182,99,125,120,130,141,164,232,41,24,253,49,195,169,4,166,24,119,94,10,220,118,24,134,30,115,97,74,217,165,9,24,58,133,22,100,178,230,65,29,246,132,126,238,155,246,195,210,36,170,213,144,154,250,216,105,218,69,193,149,24,60,137,125,112,76,82,48,185,46,103,96,72,222,143,220,79,180,200,91,128,19,220,255,149,91,71,196,8,97,219,58,65,119,50,160,66,10,130,254,104,169,60,248,222,22,171,2,149,54,231,123,198,79,108,255,82,48,207,200,200,5,84,16,211,30,45,64,94,7,229,50,58,181,220,184,15,46,79,28,235,71,209,243,225,21,63,11,10,88,220,155,221,32,33,13,177,12,189,36,16,149,113,32,136,163,183,241,223,156,206,154,19,119,175,239,12,245,143,151,31,150,42,117,5,244,84,174,232,55,134,234,140,245,226,235,231,162,210,231,78,30,3,247,43,168,141,245,243,85,106,24,138,32,99,242,235,58,187,240,137,73,126,254,224,62,238,123,77,37,176,114,171,119,225,225,237,88,48,145,98,245,22,237,63,77,52,39,121,131,12,2,255,8,178,164,63,232,18,115,11,206,188,169,182,116,98,235,134,131,240,145,134,88,13,254,44,72,27,133,215,106,109,232,126,72,189,27,127,137,6,238,65,39,73,249,245,52,36,50,122,222,91,204,178,39,51,209,11,173,84,5,55,59,184,4,170,12,254,4,237,54,42,153,6,114,46,45,13,3,241,231,220,8,33,125,121,255,124,135,216,212,223,108,246,31,195,57,199,99,103,115,128,196,193,51,204,27,42,73,9,138,92,241,174,73,97,3,42,162,169,253,178,89,187,53,183,31,117,235,148,128,56,224,156,209,217,225,153,70,252,249,176,202,52,111,209,22,4,9,43,222,195,82,49,217,61,161,210,97,141,46,194,84,99,173,219,93,137,32,120,80,16,70,210,69,86,223,162,87,197,71,53,34,124,166,207,11,124,24,43,152,94,31,220,188,252,207,55,112,87,150,79,16,66,10,240,35,48,76,217,186,233,116,54,199,87,79,139,106,247,183,3,176,1,68,130,252,67,54,57,66,214,62,207,183,128,56,42,82,6,107,127,234,68,190,254,83,73,97,108,179,174,136,227,85,14,154,88,134,141,102,167,94,151,22,114,116,81,36,120,246,40,42,153,12,115,73,51,179,206,221,52,7,164,19,106,254,8,253,244,160,173,34,33,188,0,144,174,184,175,39,224,95,193,233,128,179,54,5,101,242,85,140,30,169,235,10,162,247,49,145,212,13,85,143,1,150,22,54,132,144,83,70,82,119,114,48,104,3,98,69,221,108,91,30,176,9,18,76,168,162,221,35,13,18,82,94,154,63,13,47,241,217,5,58,63,201,5,20,148,121,162,35,205,79,64,150,48,24,83,91,214,219,220,66,49,60,89,191,233,1,131,159,104,118,135,255,223,205,0,75,158,102,138,244,124,96,62,67,231,217,66,115,44,80,101,230,121,135,90,99,146,109,77,206,111,204,117,133,152,145,100,239,96,113,103,157,76,194,52,71,136,101,145,26,75,144,255,25,34,104,36,17,67,173,24,65,177,16,147,3,151,118,42,64,77,145,141,215,169,114,88,79,52,234,34,52,167,45,153,196,136,163,156,141,217,62,77,59,190,19,62,58,92,48,144,95,151,102,202,3,149,164,45,113,91,46,191,210,80,193,35,174,188,213,206,67,78,196,8,189,73,185,193,99,178,223,214,193,171,235,253,171,137,108,120,124,109,225,234,59,136,225,126,176,212,35,226,29,248,194,121,168,211,161,90,197,186,253,124,97,153,213,169,52,214,175,157,113,144,209,96,15,101,20,90,215,145,134,53,9,244,106,52,85,20,69,198,23,244,251,67,237,42,220,180,115,7,87,172,51,163,107,163,95,160,48,249,95,146,5,242,75,170,171,52,177,38,240,214,115,67,180,29,133,238,125,105,114,207,106,91,246,232,170,204,125,21,77,95,39,236,122,194,170,130,187,80,214,242,214,94,141,82,153,5,48,110,167,11,50,235,55,231,160,21,217,65,113,83,27,207,0,213,186,39,101,213,216,157,137,28,131,190,13,248,107,79,160,128,26,113,134,115,149,66,168,155,87,74,46,72,98,245,201,66,225,29,175,44,180,97,200,28,242,32,109,196,161,94,110,151,182,169,254,87,70,102,36,28,130,218,214,133,166,242,221,52,9,220,10,221,15,144,103,44,101,0,221,145,21,83,208,61,211,193,252,165,42,204,73,106,27,117,13,153,70,96,32,133,45,72,161,66,122,83,179,135,241,67,105,150,191,230,24,16,140,138,86,173,117,253,50,186,173,47,72,236,132,191,24,179,186,44,163,51,201,212,189,178,254,211,129,221,205,111,223,162,205,216,47,35,195,37,230,5,204,36,120,158,81,4,250,158,58,148,112,100,80,99,9,131,13,155,90,96,18,166,65,128,193,199,85,32,107,155,149,99,11,113,165,112,14,248,57,52,108,20,225,139,2,101,169,77,128,161,118,6,171,145,205,146,155,163,43,26,76,239,13,238,63,80,74,77,180,184,15,214,71,78,39,169,233,101,219,212,132,33,13,226,17,14,26,213,122,227,3,19,31,162,14,214,253,132,166,42,186,77,93,143,206,158,221,218,72,20,105,214,127,146,201,220,217,48,97,77,203,2,121,12,225,138,77,129,217,149,174,163,153,187,84,9,19,60,190,172,49,172,231,241,14,206,236,46,47,64,20,155,180,124,229,105,67,105,94,69,28,162,245,102,73,222,39,76,210,133,223,155,108,37,76,191,182,66,227,103,200,78,6,122,52,71,140,109,125,185,235,14,119,64,140,53,177,231,237,106,30,182,166,121,120,45,53,220,121,81,30,86,79,230,229,3,254,74,106,106,61,74,35,46,90,30,251,219,133,97,53,41,93,62,154,229,9,186,16,99,222,35,143,202,2,218,83,240,216,198,26,38,98,14,109,24,3,243,15,46,33,114,134,13,67,57,18,49,22,43,135,87,79,96,37,107,232,93,161,91,89,91,53,234,231,169,87,201,206,210,114,13,244,114,164,207,208,162,116,198,66,33,151,203,133,176,68,25,92,250,156,198,117,177,62,203,125,75,243,191,149,88,220,180,127,53,125,220,140,240,192,155,166,51,108,3,50,229,251,160,217,83,121,9,81,254,10,162,100,2,89,44,51,198,165,161,245,174,163,113,22,25,127,255,214,80,154,96,54,219,80,220,202,158,169,122,151,24,47,117,167,167,79,99,53,226,0,140,161,153,76,113,59,233,244,11,187,131,58,45,44,230,81,50,213,88,53,33,14,164,114,6,69,198,92,105,164,220,108,51,136,153,175,24,53,147,118,62,129,5,58,76,29,111,179,56,132,62,62,21,250,175,175,43,136,94,56,54,102,160,222,250,134,29,40,73,142,55,83,37,245,191,71,55,245,58,61,161,216,103,79,32,245,8,65,38,213,194,208,43,96,124,77,41,225,242,10,174,59,106,37,169,180,166,29,167,145,65,67,52,240,62,170,128,124,92,103,104,222,120,164,151,208,145,97,123,202,161,59,23,155,13,170,76,128,3,97,191,213,108,69,151,109,153,210,104,146,208,130,3,77,150,177,141,129,212,70,190,160,92,14,189,141,192,69,39,94,166,174,129,9,86,55,192,204,188,154,181,51,69,41,197,201,205,72,1,3,160,120,235,207,142,75,33,6,216,132,203,5,1,235,249,115,160,29,240,110,140,107,40,99,72,232,165,241,248,82,232,118,127,129,108,237,232,19,21,128,114,82,81,219,167,7,17,167,89,140,149,65,148,93,1,1,216,90,55,18,61,243,104,185,41,170,157,177,201,214,139,168,78,134,72,134,194,208,52,210,195,187,117,141,160,6,211,82,209,212,232,179,217,158,53,20,230,193,187,203,122,150,38,205,249,49,7,35,155,148,188,72,196,216,146,2,8,114,124,135,239,160,217,15,178,114,74,177,63,8,157,134,47,223,40,151,68,240,96,7,63,192,130,233,216,181,134,240,167,99,142,232,239,183,179,188,99,122,112,34,69,7,186,105,222,70,211,95,21,248,45,187,196,106,151,181,213,81,195,239,191,142,108,92,213,35,223,49,108,47,161,139,32,208,35,71,116,77,244,123,50,198,97,10,135,194,29,72,52,77,91,246,196,123,8,237,91,112,22,213,133,167,161,197,87,180,22,126,103,134,187,100,160,236,124,231,145,255,187,109,177,252,166,200,105,46,189,223,96,194,161,33,46,242,249,70,152,224,161,106,61,192,247,89,243,5,238,73,58,108,67,54,160,65,138,122,236,209,188,111,182,68,208,73,180,33,43,184,92,150,67,27,184,184,246,44,43,156,137,193,107,184,76,177,84,115,217,141,115,22,226,107,124,202,32,50,69,45,255,227,71,32,135,109,160,110,72,172,69,177,32,179,13,118,14,21,75,28,76,64,3,143,252,151,56,239,40,176,161,156,122,31,211,81,196,166,117,249,123,225,118,126,197,51,184,233,15,104,94,51,62,73,17,39,108,107,18,202,63,65,101,73,190,59,56,22,151,95,104,187,245,181,67,16,38,59,189,218,128,253,83,126,180,217,88,180,179,133,157,154,97,241,118,122,25,147,181,78,192,194,182,127,153,33,134,207,167,112,176,242,145,245,138,182,203,24,147,101,154,32,132,143,84,133,7,174,72,223,139,72,154,154,19,197,145,230,19,123,120,127,76,175,69,207,20,55,35,194,91,240,153,184,203,74,94,252,180,95,51,227,77,252,82,224,128,137,39,42,44,166,85,146,24,209,194,148,164,171,95,133,59,104,212,53,68,243,76,121,21,215,242,252,0,37,19,81,42,125,71,125,126,178,29,41,190,196,81,134,9,200,230,56,85,112,214,12,67,62,122,83,112,1,209,81,89,185,36,77,69,129,126,241,87,156,244,206,250,10,86,122,185,71,108,216,177,234,122,3,179,105,212,255,167,168,21,1,221,215,139,53,28,163,224,121,124,170,109,149,27,254,51,36,111,213,117,241,55,225,79,51,107,198,224,240,125,241,74,26,136,208,142,113,234,148,218,227,104,16,29,216,69,174,184,80,181,234,114,229,216,151,188,46,70,61,126,178,163,224,121,73,237,123,96,112,219,174,120,68,231,218,87,185,179,43,228,250,85,138,96,185,101,72,77,251,239,28,113,152,189,33,123,124,72,240,26,57,220,17,51,153,91,249,228,188,173,74,124,80,127,128,216,36,211,60,55,76,244,195,104,134,41,136,26,95,216,60,231,60,150,24,233,157,250,35,216,157,251,187,237,76,83,230,139,45,101,168,138,90,48,50,179,67,112,174,237,212,121,121,201,137,248,184,227,13,208,0,195,150,3,199,204,76,41,10,206,144,177,133,203,85,100,201,247,91,73,54,254,76,22,198,87,81,233,114,14,85,86,40,196,244,135,210,2,39,229,216,150,240,232,237,144,203,246,106,39,183,22,54,46,113,113,179,175,39,58,175,109,241,97,178,9,81,106,173,71,240,80,18,91,147,147,102,208,100,241,57,121,140,187,23,98,25,123,88,148,164,203,21,117,148,49,237,221,84,162,95,89,216,48,226,211,68,171,63,90,216,27,230,19,138,198,152,88,136,38,112,19,8,98,213,26,118,190,212,6,140,187,159,68,148,94,179,7,68,88,37,150,16,175,57,244,67,237,163,30,84,94,215,56,242,27,19,13,171,131,239,233,111,45,53,236,191,73,48,45,49,157,110,9,221,11,122,86,50,202,150,9,186,181,121,189,113,143,18,169,173,61,66,187,219,74,172,53,251,121,65,244,201,130,170,99,78,136,195,54,70,62,62,153,69,54,84,202,142,143,148,242,221,245,173,133,187,34,18,227,143,15,210,132,101,13,109,166,62,53,179,3,191,154,10,30,22,41,104,167,67,145,69,143,194,72,29,57,18,58,172,228,75,177,82,22,204,131,180,166,2,91,48,25,206,255,141,189,27,146,96,50,151,102,90,46,63,150,170,157,8,159,192,7,17,221,188,144,222,4,1,234,154,217,184,50,76,115,143,47,98,112,142,174,114,112,75,15,103,154,22,111,79,226,116,96,155,113,42,151,60,184,101,99,20,86,58,56,42,187,193,135,172,160,69,75,8,248,35,195,215,111,21,97,175,212,11,196,18,189,103,33,177,37,210,214,134,220,245,112,190,104,159,244,136,234,163,160,56,105,141,176,193,232,138,243,208,89,49,166,132,159,214,133,144,42,25,22,60,131,44,1,38,134,20,173,13,68,34,18,53,128,37,238,134,32,0,243,250,199,125,21,125,52,72,60,3,77,191,190,100,249,149,249,175,76,100,144,122,241,47,222,124,214,34,150,97,103,194,9,204,192,132,148,87,4,208,224,179,179,120,154,195,106,68,87,232,0,187,100,225,204,195,66,248,21,191,247,244,201,95,83,244,132,87,209,122,33,66,249,75,163,164,96,174,213,220,111,127,245,172,116,201,65,27,233,49,106,139,168,191,116,241,169,61,8,33,14,153,179,151,51,221,191,143,191,93,186,153,32,103,100,135,178,91,159,208,113,42,167,177,55,104,66,103,99,41,11,240,179,103,85,67,101,212,181,105,110,57,69,67,162,216,232,135,68,141,76,241,69,71,237,27,248,106,47,64,194,55,18,88,159,118,89,178,244,129,8,125,218,253,58,131,36,216,177,32,239,28,95,59,86,103,196,131,76,166,74,94,94,182,147,206,114,169,90,179,85,176,219,126,195,110,51,86,250,106,30,173,192,99,216,81,112,100,151,73,237,118,115,67,36,155,18,75,196,180,107,204,42,130,29,163,209,125,29,155,31,92,89,31,76,86,133,28,101,76,118,223,218,75,71,55,148,32,91,173,95,193,174,90,176,190,86,163,71,255,3,222,138,244,46,205,12,162,166,215,151,135,60,184,51,254,33,47,206,122,50,176,41,54,128,213,51,18,218,35,141,222,44,187,15,53,165,196,161,151,138,82,217,116,213,199,66,240,22,71,0,135,23,163,91,20,58,87,123,201,59,6,141,159,162,202,75,234,143,54,48,238,85,204,121,228,204,6,69,114,60,199,111,9,104,167,68,174,45,169,73,8,29,131,197,51,82,57,24,125,116,44,198,66,236,225,64,116,143,142,239,71,31,67,202,166,190,69,249,87,120,91,23,150,195,6,228,143,25,141,243,229,197,98,214,123,254,137,218,158,113,96,162,242,226,133,201,216,17,47,124,127,171,113,110,237,30,213,193,214,97,77,31,247,200,209,229,119,116,129,163,75,101,89,56,220,14,153,112,201,129,82,51,38,66,87,176,197,235,243,62,196,109,108,45,219,17,35,204,151,193,42,45,115,158,46,176,155,154,40,24,7,140,172,138,244,104,52,105,178,26,32,7,202,181,158,106,117,243,69,1,64,58,252,126,115,98,143,5,195,195,156,103,98,228,40,62,8,150,218,119,186,231,26,220,7,45,219,159,55,96,35,78,191,216,206,156,182,220,2,126,201,123,216,220,138,170,221,51,221,62,69,12,26,85,102,46,49,44,211,86,155,247,73,212,81,59,192,168,50,39,228,232,5,79,17,219,51,131,247,232,209,185,11,228,88,84,117,251,5,208,252,132,177,179,160,235,194,216,5,75,30,94,177,236,192,242,123,6,46,244,154,229,238,51,24,25,30,124,194,248,157,50,223,250,61,204,64,205,14,19,223,140,51,76,247,25,35,209,40,10,32,129,162,4,219,254,252,103,166,161,174,126,193,250,246,172,174,55,70,152,110,220,216,128,239,209,171,78,56,206,56,149,232,83,171,212,249,104,17,147,153,226,90,161,117,247,74,157,75,138,136,51,43,35,4,76,60,66,192,29,10,178,73,73,90,111,233,75,203,29,246,218,81,198,116,46,202,104,239,212,17,93,88,245,85,203,191,16,188,97,144,87,187,52,248,5,232,126,244,144,219,198,174,107,244,132,59,145,126,164,35,161,137,248,189,199,118,124,58,231,247,68,81,177,106,114,11,54,156,232,173,37,177,167,78,210,144,144,145,168,6,26,126,123,122,8,39,189,14,11,122,148,125,58,199,175,109,68,231,175,203,92,164,117,192,14,110,78,174,156,151,249,187,202,121,157,158,96,144,238,209,10,8,70,164,255,159,251,242,107,235,178,227,12,73,169,161,189,165,67,237,107,206,36,141,62,222,72,91,156,213,117,139,45,126,227,187,213,51,159,130,251,215,69,142,140,53,143,176,122,247,114,113,60,226,201,143,67,167,129,100,195,78,49,249,102,234,83,213,79,208,80,169,40,230,147,157,238,203,243,27,11,254,122,213,191,222,233,24,111,231,115,65,56,177,24,152,53,227,83,41,11,209,254,147,40,96,72,51,220,35,163,224,135,88,79,174,44,81,19,104,121,38,140,157,189,107,100,94,12,84,25,146,206,197,183,5,51,25,233,213,47,117,198,51,36,6,181,121,53,172,61,188,193,164,169,109,7,91,7,137,198,199,167,59,35,144,2,61,64,200,174,129,12,197,89,52,127,203,130,69,111,53,133,238,95,35,164,64,46,16,136,68,136,147,206,5,80,98,150,154,15,22,251,19,138,235,172,159,40,88,230,173,3,173,154,72,252,114,72,37,77,90,157,162,23,79,201,36,201,10,210,128,78,6,142,127,178,119,147,52,206,193,55,184,53,101,147,192,124,219,239,52,21,44,74,192,67,84,93,58,2,44,215,33,116,217,155,75,20,168,109,139,57,123,214,52,252,16,126,154,61,220,171,117,119,183,173,66,229,254,106,72,147,159,31,112,124,139,61,231,62,90,234,222,69,159,198,234,48,52,34,240,193,162,106,107,236,245,211,76,146,128,241,152,68,123,36,130,168,153,247,155,224,250,167,145,171,83,222,139,229,118,107,182,231,138,158,97,201,89,99,189,180,146,74,83,201,18,76,142,94,188,9,46,63,229,78,64,92,28,58,147,227,252,58,224,52,169,38,223,234,220,140,163,120,7,224,176,236,198,202,188,213,243,172,13,169,209,124,123,54,252,31,3,195,111,196,105,197,4,222,83,206,145,197,150,208,89,49,101,13,83,114,209,43,63,55,53,207,41,100,23,96,116,61,162,230,65,202,31,108,1,146,230,10,43,117,180,152,47,99,43,9,46,85,134,138,56,97,241,15,21,75,243,16,78,33,240,94,187,135,246,48,23,224,104,211,155,141,200,171,246,147,148,59,63,248,244,112,127,67,123,18,136,136,55,42,119,130,124,118,190,104,54,94,143,71,43,170,248,106,71,203,211,252,107,246,206,92,52,1,17,32,154,249,176,235,53,114,88,106,62,38,243,26,153,129,134,246,62,115,101,24,41,118,198,136,77,206,84,148,234,111,114,63,111,26,9,136,73,156,20,53,127,24,97,47,227,227,176,12,181,175,8,187,217,205,123,2,109,99,137,217,18,1,19,51,45,8,81,240,128,20,76,199,248,32,35,238,137,0,69,4,199,6,154,87,121,74,183,59,147,96,230,173,88,192,188,202,132,157,100,86,66,55,180,211,91,134,213,251,245,101,155,155,178,53,205,193,213,85,90,190,163,57,98,177,51,244,73,186,78,28,41,222,35,82,149,110,235,197,102,129,79,95,211,238,226,168,46,195,251,50,213,97,27,70,69,177,165,194,140,44,185,86,213,250,245,89,131,35,236,168,54,249,106,59,140,96,118,72,66,185,61,41,196,124,162,130,221,37,51,63,250,156,99,114,3,126,180,194,237,152,37,124,180,71,62,20,175,42,1,34,187,86,168,189,189,121,0,168,235,121,53,184,166,18,59,237,13,110,250,181,239,137,30,244,56,167,89,32,195,136,152,84,252,203,94,247,144,176,156,212,255,32,69,212,226,170,95,235,68,89,93,84,147,149,189,253,225,239,15,193,252,216,1,80,208,240,75,62,45,155,161,102,17,37,216,141,129,249,8,128,130,109,223,152,33,59,185,137,94,23,239,192,199,104,34,252,251,6,178,122,33,31,205,115,28,18,16,152,60,207,50,109,61,116,214,37,17,35,206,250,48,180,220,211,217,180,201,70,70,78,109,135,162,215,224,66,180,72,79,65,248,60,232,243,166,203,131,116,114,154,208,109,90,61,112,5,221,147,133,11,30,58,104,241,118,235,63,50,85,91,46,13,42,85,75,85,25,101,222,236,236,26,88,90,111,8,85,235,205,227,85,227,101,21,205,72,232,220,84,162,250,139,122,79,172,48,240,185,118,189,173,53,234,7,231,189,14,188,118,35,43,183,145,230,178,217,104,41,110,165,43,193,50,180,236,45,70,202,15,248,42,187,231,61,73,218,5,80,130,115,136,241,82,67,97,17,132,92,184,56,103,68,199,3,19,182,127,72,42,176,124,130,10,187,249,218,237,94,131,171,29,168,159,207,230,79,88,65,186,168,130,70,104,146,251,172,148,64,171,169,124,214,165,189,0,137,171,183,71,244,94,240,221,112,147,248,127,240,154,60,69,185,145,207,193,66,142,200,236,187,14,41,85,230,133,46,48,166,182,109,217,91,70,130,91,254,185,101,254,137,12,57,221,78,145,68,143,157,196,72,223,159,80,75,182,169,135,24,69,144,160,115,244,124,45,63,18,150,26,127,234,171,54,238,156,40,158,237,139,100,220,43,148,36,5,233,53,110,102,124,200,53,250,40,48,123,164,88,253,105,36,156,89,12,183,113,117,47,88,27,45,153,9,88,64,14,55,157,240,92,169,168,138,24,47,106,14,189,212,92,162,33,146,194,117,203,57,131,10,3,192,187,218,140,174,153,24,8,227,52,38,148,53,80,145,32,241,118,185,104,25,98,208,86,212,124,184,72,2,133,32,157,45,125,133,193,48,78,129,148,152,27,52,171,163,135,71,172,163,231,143,249,38,170,153,168,203,23,95,87,47,57,250,177,76,236,132,244,235,198,29,221,59,27,224,132,254,14,238,41,148,66,5,73,180,190,5,149,82,157,226,169,43,248,53,27,215,64,242,167,69,67,45,18,97,77,235,174,58,70,194,36,25,7,169,72,55,72,51,248,231,135,202,144,149,125,189,24,17,132,195,153,77,14,66,236,66,175,211,63,246,45,76,227,76,188,212,22,252,237,37,37,6,150,191,58,96,235,33,50,6,4,152,160,96,119,13,228,7,189,148,176,94,11,139,254,152,167,72,1,67,34,24,7,50,252,147,11,203,3,179,78,1,109,163,179,250,23,106,139,182,166,174,117,70,36,219,90,74,4,169,224,130,36,89,254,14,89,139,33,115,49,184,226,78,25,24,246,110,202,93,151,169,34,85,214,252,54,31,103,233,76,230,112,128,88,87,27,1,251,42,10,68,201,92,12,156,202,246,16,242,11,46,81,118,45,23,227,35,251,155,67,201,32,125,48,120,247,85,81,72,115,162,82,123,102,148,164,200,191,161,147,248,0,197,137,129,152,4,176,71,195,58,58,195,233,9,119,35,16,186,164,202,154,12,83,41,144,21,232,204,191,19,146,114,244,55,228,103,76,177,200,109,225,238,160,181,90,118,33,253,150,0,167,176,71,189,93,27,122,244,122,146,33,72,28,32,56,34,158,160,50,72,106,156,136,167,226,117,93,188,57,61,84,29,235,6,137,190,243,75,103,88,17,74,102,149,186,104,116,224,26,232,64,4,87,230,167,238,91,89,126,14,59,154,196,231,76,200,83,95,4,36,26,199,47,132,215,66,0,144,93,142,207,136,8,17,93,46,124,59,55,129,5,157,47,165,108,37,79,70,36,173,52,182,107,114,162,77,42,229,208,66,178,13,89,161,245,253,129,16,129,131,85,9,251,63,110,188,140,108,39,0,241,95,180,57,165,95,133,31,242,129,72,50,28,99,160,39,240,64,182,241,35,102,29,190,21,65,76,88,212,230,154,161,217,91,64,135,13,70,73,169,214,94,115,186,12,247,89,234,184,67,32,127,46,243,8,135,61,128,50,112,167,37,253,236,107,139,206,24,167,119,28,110,255,95,87,166,202,48,195,49,78,225,145,57,95,168,202,12,226,242,156,225,65,2,93,176,249,169,9,180,189,35,110,149,29,180,110,59,110,120,202,54,7,121,94,185,3,62,147,1,77,125,224,4,22,45,244,23,66,95,9,247,223,56,247,0,62,159,190,148,89,129,200,119,87,199,170,255,46,66,119,143,89,202,185,161,230,253,106,124,50,28,156,149,203,75,161,69,46,138,61,36,159,119,125,212,251,145,70,153,165,78,117,0,33,42,251,202,9,216,119,117,169,16,217,168,118,88,11,228,220,60,140,50,204,215,204,96,65,95,94,39,181,188,121,79,132,39,245,94,43,131,160,215,86,66,178,196,93,82,166,210,200,222,153,194,61,160,230,162,116,254,31,199,114,194,17,151,112,37,45,111,168,219,31,246,127,120,249,108,37,166,2,234,41,49,34,96,139,229,79,11,217,55,236,59,84,33,155,217,203,203,34,38,126,16,121,25,238,202,87,109,95,201,156,110,186,212,92,172,99,102,218,104,68,211,40,91,245,76,254,120,112,158,111,128,53,105,12,176,236,171,53,63,16,186,201,67,100,25,63,237,243,40,252,139,82,186,104,228,181,45,158,111,103,197,87,18,116,137,76,231,158,61,146,35,32,12,87,209,235,201,176,236,37,211,12,120,122,194,173,198,95,243,7,19,12,86,170,237,183,63,53,124,5,14,158,68,132,192,210,17,160,118,148,183,88,123,196,103,33,154,62,233,176,203,123,141,183,181,68,211,88,3,187,15,59,166,73,226,204,227,164,149,57,201,71,165,222,182,166,162,52,203,129,132,121,230,239,37,32,212,147,87,158,69,209,22,37,236,218,111,198,237,180,97,184,151,146,184,60,51,75,96,169,237,140,237,235,54,153,224,127,40,210,138,83,15,182,243,124,40,24,69,68,54,200,205,30,154,187,198,227,155,190,252,11,171,172,179,75,40,48,61,216,184,251,71,120,59,131,99,97,153,120,66,79,91,0,41,151,194,213,174,142,209,180,133,78,227,87,163,201,57,13,41,184,245,214,234,91,104,229,55,186,214,116,41,125,173,229,40,138,132,91,140,144,43,247,38,54,82,2,27,215,49,249,174,54,2,186,59,1,5,71,60,120,81,47,16,160,25,74,220,33,82,229,52,12,57,233,188,16,133,243,130,190,34,218,193,30,137,117,135,253,183,216,180,22,153,254,97,27,189,223,130,238,7,180,229,132,4,138,58,81,218,72,204,168,97,231,56,58,220,119,174,118,10,153,41,148,207,123,77,68,0,131,232,15,1,114,67,234,125,107,111,15,212,139,49,19,118,23,109,88,131,80,53,127,248,252,224,165,227,84,142,190,91,24,165,172,251,121,219,198,250,31,14,141,230,167,195,29,228,224,177,110,158,133,37,205,65,32,201,96,254,140,208,19,155,223,206,76,224,251,230,35,9,210,134,76,135,75,21,52,236,163,208,3,247,244,200,79,32,163,204,13,169,171,41,14,198,189,147,240,157,17,57,20,73,96,238,117,177,8,65,183,71,222,23,100,168,3,14,104,215,37,91,59,19,52,12,21,140,231,58,166,26,208,242,162,97,194,92,27,222,248,108,234,147,236,10,141,245,253,101,84,146,45,90,111,11,22,201,140,135,201,202,36,181,21,225,23,34,93,97,42,213,20,59,195,88,164,58,41,179,4,222,185,158,81,56,122,47,174,206,166,198,160,196,214,37,111,238,224,199,144,194,197,114,37,26,60,0,28,243,172,127,48,90,206,140,90,212,233,143,17,225,142,29,241,61,156,6,58,117,200,248,173,83,186,217,246,251,60,86,72,235,168,138,57,229,105,143,156,81,194,90,22,96,128,160,201,131,149,226,73,35,89,28,126,52,74,185,216,13,144,208,10,106,89,197,192,34,176,227,7,114,123,206,223,244,137,132,234,117,228,123,112,114,144,62,231,71,99,34,103,145,166,227,192,78,180,78,138,221,189,187,245,88,81,37,119,234,25,146,20,197,6,37,182,252,22,247,9,4,132,25,78,241,100,39,31,83,42,163,47,62,104,32,208,97,45,173,238,251,141,1,64,10,172,142,2,164,130,234,187,232,241,106,137,12,185,67,126,52,158,96,130,2,174,215,134,69,32,180,73,29,137,193,135,148,147,183,129,189,212,240,226,75,239,86,185,247,106,84,2,245,166,5,163,9,93,16,1,28,112,16,125,153,255,250,166,62,235,51,237,31,226,27,160,44,235,85,252,173,49,241,160,19,66,142,236,141,138,144,12,6,112,99,51,107,104,190,194,23,118,1,50,125,191,161,120,12,123,198,231,246,81,69,60,106,232,174,63,152,219,185,202,109,219,115,45,41,82,188,78,177,205,116,6,126,70,56,178,94,126,105,9,236,51,50,206,58,23,19,112,31,24,56,141,31,130,88,3,153,224,118,210,30,246,91,35,232,39,133,209,131,84,132,109,12,62,244,100,200,248,211,42,244,88,76,146,34,49,96,93,250,3,85,175,235,220,130,159,32,202,75,23,120,31,191,165,151,39,228,209,120,91,38,89,193,123,91,197,114,64,137,9,196,22,224,121,237,71,135,210,92,169,77,196,236,139,84,72,177,137,31,155,217,7,71,161,39,21,46,115,40,54,37,191,205,49,15,124,27,142,252,12,10,127,127,73,12,185,215,141,110,13,239,94,228,122,172,79,20,138,33,222,8,7,161,87,20,19,238,197,14,53,55,41,96,172,196,46,15,236,57,231,143,172,90,86,251,33,131,82,123,165,0,14,42,50,64,52,124,144,45,226,248,56,73,42,178,151,188,249,190,255,22,203,58,83,233,134,232,59,155,126,140,138,72,208,150,233,175,28,92,158,215,219,164,239,146,20,218,128,66,213,131,234,140,29,135,12,155,237,241,153,204,145,133,86,130,184,190,252,203,164,151,189,215,59,129,119,143,161,224,184,164,60,133,69,158,231,35,156,232,3,102,190,241,221,221,104,240,42,193,24,236,107,233,43,77,179,26,188,227,126,165,89,192,113,198,44,133,70,192,152,5,237,200,72,226,67,155,80,80,100,208,79,168,67,253,209,162,97,180,54,76,239,119,232,222,90,37,201,148,25,126,154,233,145,143,104,124,158,126,196,140,92,131,103,103,233,163,245,41,233,254,52,115,226,39,75,37,253,150,141,188,179,237,159,220,10,101,131,236,148,212,214,109,159,229,156,32,218,66,28,193,45,99,55,61,213,60,235,143,25,70,204,191,113,103,238,171,228,80,100,190,63,74,212,122,39,214,231,205,27,206,78,146,129,220,250,22,183,202,54,136,176,89,159,65,77,219,226,61,93,62,12,128,76,254,127,150,190,26,69,61,82,112,174,209,186,36,12,57,146,104,87,132,184,145,209,104,32,152,141,80,184,68,35,67,33,60,163,196,179,136,243,79,58,3,87,200,57,176,72,120,50,67,90,26,60,192,128,37,160,73,239,120,217,66,129,61,172,160,252,101,220,83,128,54,178,209,134,174,209,94,137,152,39,110,76,216,124,56,114,43,89,232,205,222,91,14,175,223,131,41,139,131,17,0,185,124,118,203,252,49,64,38,135,97,127,220,45,54,110,78,2,206,87,232,100,202,65,119,253,223,81,57,22,169,229,62,45,192,80,114,240,207,227,121,158,15,182,106,195,29,231,60,176,105,176,224,23,226,208,170,198,94,168,56,51,245,223,242,59,182,48,114,232,89,250,44,123,120,170,224,96,88,91,34,142,98,165,239,172,19,8,42,133,179,78,8,208,44,27,241,120,255,1,237,22,21,21,204,61,214,2,211,92,224,234,134,120,140,30,18,120,251,198,86,103,46,49,207,238,126,215,28,61,115,226,9,72,199,194,6,81,251,4,99,120,118,101,111,34,109,44,40,143,225,200,204,199,76,11,54,163,37,252,207,231,230,32,195,203,212,235,5,12,24,81,115,172,11,138,135,89,27,22,57,120,31,233,232,31,209,213,10,156,233,69,224,13,213,253,16,164,247,4,88,253,246,163,194,226,144,18,49,19,209,234,12,48,104,174,138,22,182,226,128,47,62,18,42,21,154,26,232,212,141,11,214,249,38,128,122,156,113,54,208,218,55,140,72,74,218,13,134,72,8,46,248,68,122,71,222,192,237,39,94,175,66,34,89,208,130,89,211,208,66,10,191,173,253,155,223,187,170,112,123,225,232,13,116,238,162,12,246,240,73,205,234,188,149,1,8,159,38,105,139,117,253,255,9,81,58,97,244,110,22,162,13,74,38,190,35,173,39,44,100,10,46,168,230,69,2,237,79,109,132,119,204,165,36,11,71,22,229,103,204,232,124,136,186,19,93,63,250,234,18,45,32,68,132,33,185,150,114,159,185,51,140,53,123,110,181,18,236,232,182,54,227,118,77,134,225,226,184,42,191,50,130,129,224,46,107,74,187,133,199,149,34,225,150,255,63,108,65,136,249,180,1,129,230,111,73,144,224,69,6,150,51,197,13,217,30,237,68,240,4,195,144,17,3,162,115,232,32,66,13,244,18,120,118,70,106,244,27,250,228,187,181,31,152,95,122,10,25,243,159,27,175,66,172,205,202,117,199,10,146,135,175,119,238,243,124,235,163,79,101,49,148,122,134,118,240,220,191,28,138,141,124,33,126,2,130,232,216,104,113,58,122,45,112,223,152,106,96,13,226,168,239,246,57,104,73,111,174,215,53,94,171,88,107,238,135,192,66,243,211,116,143,97,46,21,242,122,182,9,152,248,2,149,102,213,216,254,134,173,83,137,239,152,183,184,19,148,70,157,87,137,180,233,100,189,158,133,242,13,126,8,37,69,84,85,118,218,121,44,18,90,39,49,211,240,8,243,120,126,77,183,1,246,254,241,142,87,48,137,254,205,227,146,80,165,168,114,236,196,71,100,122,116,55,25,9,109,7,130,19,146,22,170,136,117,110,177,238,0,110,101,237,178,246,143,207,26,207,206,189,116,125,182,152,80,54,143,24,122,166,70,44,90,58,8,199,57,12,20,112,54,135,54,28,10,19,80,159,232,101,59,133,147,18,26,152,253,121,8,46,48,28,8,211,217,100,162,198,143,254,244,230,11,176,225,66,74,244,230,192,36,207,100,230,148,64,84,49,83,114,222,101,209,235,126,191,17,108,197,193,222,133,167,209,20,205,132,113,117,225,203,219,209,169,159,179,182,1,226,1,102,0,81,165,16,199,238,14,119,158,1,86,166,155,250,135,100,178,223,69,1,87,172,51,91,239,25,24,237,248,62,240,87,175,35,99,229,228,201,251,81,237,141,103,125,41,202,236,136,149,26,205,167,216,74,115,160,205,126,39,12,218,32,33,87,145,44,53,99,151,78,161,92,248,182,248,103,183,2,197,70,6,36,60,242,132,49,231,150,31,10,2,145,247,213,230,98,183,194,156,250,219,117,129,109,90,8,54,250,245,36,252,108,58,157,141,244,211,114,202,117,198,232,229,178,146,71,62,143,225,195,98,39,103,19,147,250,144,190,200,118,16,177,75,28,40,50,17,158,220,186,4,24,9,189,119,51,67,27,241,196,10,51,142,50,222,121,189,74,198,63,29,75,219,84,65,139,89,158,159,54,138,86,14,139,61,131,124,1,226,138,121,195,93,201,121,187,252,120,62,167,140,35,52,144,3,54,91,167,138,79,109,10,6,227,125,241,60,49,123,4,2,245,116,250,95,116,89,193,8,235,77,221,7,226,26,104,156,17,247,147,16,240,11,58,163,189,174,136,20,227,141,88,24,164,199,59,108,218,16,109,26,238,124,31,25,129,107,109,24,142,202,140,3,152,58,68,9,139,125,128,219,26,29,140,189,208,109,91,46,206,130,95,57,73,47,78,237,110,200,90,101,247,110,153,236,233,203,119,242,132,85,179,238,45,22,115,177,253,63,180,109,200,167,252,52,66,202,92,202,201,22,68,104,155,236,71,200,183,4,176,96,152,5,119,253,34,4,225,177,196,97,115,88,42,89,136,163,200,14,66,220,73,231,154,217,68,98,151,35,101,74,85,42,144,150,27,227,243,171,25,37,155,120,155,225,176,28,17,250,117,137,23,2,90,129,129,241,237,247,30,193,144,211,221,40,166,149,18,78,27,229,254,81,80,248,44,203,97,239,11,128,75,79,149,39,235,206,7,198,212,113,32,40,166,208,134,117,39,109,26,52,149,166,15,198,211,69,86,222,242,183,2,197,146,125,82,190,244,101,140,5,152,146,88,68,148,138,214,159,82,219,205,85,80,39,179,78,103,157,213,21,175,59,144,76,250,81,88,15,162,184,134,238,108,72,86,209,252,171,89,60,196,2,206,123,207,98,164,252,28,11,195,154,206,216,182,1,16,244,124,183,112,61,116,245,111,161,57,183,41,144,126,231,102,184,48,146,104,188,44,253,146,227,45,36,19,197,125,246,65,110,56,128,105,155,120,20,171,201,129,50,98,186,113,2,77,242,222,93,216,79,7,79,152,21,184,121,153,103,28,75,189,34,36,126,224,110,7,226,244,245,199,198,186,165,31,5,68,227,104,243,207,92,214,8,180,2,186,254,122,71,237,112,9,59,39,49,181,83,235,78,125,148,126,252,160,126,190,199,219,229,59,191,181,238,182,224,249,92,225,176,209,194,42,58,204,232,131,250,222,6,105,7,145,215,189,252,138,114,174,14,153,131,47,81,161,196,17,230,240,197,182,54,48,25,18,122,245,126,64,76,72,96,26,46,247,1,190,61,34,204,158,78,244,26,237,173,226,132,140,218,27,219,194,44,229,40,142,94,0,50,64,191,1,27,215,73,4,19,238,61,138,92,17,12,118,152,8,196,86,248,27,242,188,198,233,205,252,225,37,11,207,14,208,68,89,185,121,29,202,227,219,155,26,57,55,40,143,226,227,163,250,210,70,91,50,159,244,248,94,111,9,11,118,56,254,112,92,113,2,237,105,116,248,135,3,66,206,196,169,177,61,134,139,249,249,181,146,80,186,23,165,190,214,224,41,137,239,188,58,43,222,246,162,63,39,60,227,37,214,232,175,225,41,169,86,119,116,103,8,249,44,225,156,149,214,183,205,114,208,225,62,228,128,233,246,76,204,70,86,87,102,251,250,24,145,56,207,33,17,68,71,38,188,142,135,66,253,29,221,159,4,119,20,113,248,15,216,174,205,107,13,116,3,98,109,103,87,245,107,0,144,111,181,9,209,241,58,86,160,100,165,2,17,250,103,100,61,149,125,151,168,26,207,108,79,227,140,3,34,209,206,77,176,2,171,254,65,21,113,23,118,28,103,200,50,104,46,248,231,165,121,157,200,144,195,67,147,149,71,156,221,123,53,133,170,119,94,148,140,116,187,119,209,116,206,150,68,159,67,129,136,108,62,221,42,213,182,36,62,99,130,52,182,102,24,233,229,11,12,57,72,45,149,191,23,87,104,181,25,35,229,101,50,136,183,167,16,230,93,126,98,5,163,131,217,229,200,76,151,8,241,107,209,238,92,86,182,187,196,96,196,238,204,241,16,220,233,130,164,237,116,122,221,209,92,137,107,51,158,125,12,153,98,109,132,208,145,196,223,235,145,113,16,195,119,54,79,56,198,216,159,89,173,138,160,38,192,125,82,217,172,113,9,40,219,126,182,163,75,209,8,30,181,20,139,6,187,88,97,135,193,142,68,236,105,85,122,82,76,109,70,97,246,233,29,253,72,252,195,46,11,226,7,18,176,32,221,45,79,36,29,158,0,146,180,113,88,86,9,142,141,20,106,243,205,191,8,75,183,149,234,116,241,202,42,18,247,22,219,102,12,201,88,115,154,205,249,112,255,69,87,4,31,13,1,156,100,36,149,70,51,203,242,163,19,36,182,94,189,6,254,201,119,134,147,84,173,7,74,125,119,180,70,10,76,15,190,124,215,115,31,14,132,239,146,50,7,183,50,2,150,113,182,231,170,152,146,3,4,157,180,206,226,101,198,69,218,16,14,58,145,78,202,196,158,234,242,129,183,105,182,193,169,112,63,140,227,53,180,78,58,72,201,4,40,57,196,54,49,34,28,6,253,200,19,26,82,251,208,229,39,196,108,21,84,110,16,188,50,176,110,191,125,199,71,178,147,18,103,29,123,77,128,164,114,113,120,170,210,122,103,193,228,195,66,196,253,198,248,234,188,42,25,63,102,61,9,90,102,140,120,234,141,51,187,17,71,69,24,74,40,242,5,7,108,21,136,68,57,227,168,204,147,176,69,95,252,27,74,10,12,93,172,134,198,249,77,128,11,4,2,237,46,161,236,138,117,157,16,231,58,81,141,117,130,84,150,253,221,113,138,39,13,95,142,254,65,26,172,201,173,235,158,255,103,96,78,212,121,137,153,136,147,143,5,71,20,128,25,129,40,187,17,73,72,5,148,67,188,175,29,19,220,139,80,206,46,134,81,100,218,134,87,232,43,16,140,111,156,164,109,203,202,89,1,32,212,212,165,102,46,43,203,44,175,169,27,199,160,125,20,212,74,121,111,198,245,140,135,181,155,159,41,108,141,110,255,101,177,143,138,249,213,234,144,191,129,174,135,69,116,34,114,104,168,250,131,63,219,203,33,82,22,227,15,122,146,152,22,111,19,214,180,241,11,155,126,205,1,243,184,62,212,28,66,158,158,168,15,246,95,200,85,27,32,237,11,255,4,187,211,14,36,220,50,249,191,174,223,148,41,24,75,252,173,66,97,36,123,147,195,244,98,81,240,148,98,167,35,126,234,205,13,42,141,140,67,0,97,239,75,59,100,112,59,8,63,181,76,71,33,101,57,44,252,254,102,201,254,74,241,205,53,188,254,188,184,247,232,8,43,253,5,71,210,65,244,114,33,213,125,81,61,10,92,186,89,161,39,234,152,91,90,198,255,80,0,228,142,171,189,204,138,245,124,241,187,205,105,226,219,156,73,254,173,75,147,41,65,82,34,55,87,118,176,4,129,65,46,38,88,116,129,15,137,140,60,226,53,105,16,39,165,58,37,38,20,201,30,105,246,61,226,186,142,233,203,244,165,43,164,186,21,151,135,81,51,43,111,27,242,53,235,195,206,246,173,215,218,221,141,139,9,248,238,198,240,218,152,22,7,199,178,45,149,221,2,220,121,196,222,55,157,121,205,39,177,220,225,240,83,96,53,30,112,150,4,76,13,228,106,12,240,247,8,186,159,120,124,12,129,174,175,255,60,209,124,244,249,157,49,52,127,211,221,229,251,121,231,56,32,75,13,125,188,223,98,59,97,54,16,6,181,192,188,247,98,198,122,205,7,205,166,8,65,123,109,231,13,50,51,183,102,170,212,116,34,71,239,166,93,36,128,175,175,224,10,166,215,232,66,114,10,240,161,66,189,101,115,232,129,119,242,74,62,239,122,198,196,175,27,172,161,210,6,29,69,102,200,204,9,65,205,40,26,55,179,156,67,52,29,210,218,52,130,109,249,60,201,207,209,122,108,159,182,20,81,97,215,250,240,87,103,228,63,75,81,28,107,75,96,144,145,96,85,79,135,122,173,11,33,222,177,141,165,176,178,239,159,223,240,44,142,254,250,90,57,147,86,222,90,5,157,89,229,250,254,192,243,166,9,74,233,118,193,195,219,132,4,80,159,162,104,159,128,249,55,194,197,45,209,87,10,249,105,57,49,124,78,15,23,9,98,53,63,116,87,45,67,13,55,36,243,97,189,87,125,144,198,34,229,32,246,39,184,36,206,213,141,2,144,194,226,200,239,216,18,0,178,169,13,174,32,67,142,129,238,190,95,131,116,89,168,0,153,118,129,165,147,227,22,109,65,176,206,187,175,133,151,111,223,176,238,56,203,118,31,17,81,174,21,192,66,98,241,242,109,251,51,241,191,136,125,229,134,101,23,250,29,43,134,30,126,219,143,222,159,42,169,25,65,161,75,152,131,215,135,151,134,200,100,183,175,46,9,151,116,236,73,219,224,60,8,24,192,242,64,23,157,212,91,148,192,59,25,194,208,251,87,216,139,34,201,197,126,112,203,111,59,201,217,102,150,216,202,58,181,18,128,175,250,241,198,234,105,139,98,183,60,44,172,47,132,143,105,153,228,160,88,24,225,131,121,148,131,228,81,228,243,208,34,102,61,19,85,7,52,147,156,154,48,226,56,46,61,223,45,182,20,36,207,172,188,196,255,219,216,47,170,80,176,183,239,194,234,174,253,86,155,180,142,239,207,183,171,141,105,237,176,153,168,187,35,130,120,132,106,212,255,206,204,26,221,174,168,226,230,105,207,161,204,119,0,82,254,117,197,73,207,46,36,136,220,186,198,7,219,48,23,31,229,103,194,189,47,246,202,169,22,152,127,23,77,123,16,245,247,148,102,27,67,92,15,107,138,23,195,21,201,18,4,93,12,226,70,115,62,203,73,86,181,229,102,121,48,91,197,207,36,36,233,118,36,168,8,169,48,91,146,1,18,210,42,225,225,56,77,64,36,243,20,3,84,246,33,74,148,240,51,26,74,177,114,186,150,198,102,77,165,184,139,35,203,212,99,132,48,107,85,91,221,232,177,198,196,97,64,99,137,220,44,27,196,170,5,213,62,189,41,153,184,164,237,193,57,89,241,37,64,81,132,182,23,121,69,65,216,49,23,105,226,116,158,69,97,137,137,163,100,105,179,66,34,37,17,141,94,98,114,77,104,157,56,34,173,77,7,195,38,254,61,210,14,93,15,7,23,86,63,172,44,51,37,219,140,209,253,108,164,79,135,32,180,115,96,168,19,77,218,98,5,142,84,102,112,101,67,156,191,173,10,67,44,119,78,176,246,208,102,191,56,54,201,162,226,84,189,48,145,102,224,183,255,13,191,74,135,247,79,198,190,79,179,18,159,162,179,6,81,230,94,250,96,212,204,167,186,218,168,82,146,225,1,122,21,89,184,182,235,25,23,152,13,92,3,245,78,135,42,51,249,80,112,244,118,175,54,55,150,231,20,29,21,207,55,18,151,218,16,253,41,170,37,0,183,104,228,174,1,110,45,86,205,176,204,67,59,43,65,78,42,146,96,217,236,216,7,38,152,16,251,223,31,35,218,88,205,0,33,199,25,225,189,253,158,240,36,96,151,207,123,179,54,170,232,242,203,225,50,127,107,5,72,26,32,67,184,49,101,153,237,106,3,213,186,184,34,99,146,195,212,168,46,32,56,121,184,160,49,90,193,44,136,165,125,80,90,167,54,146,184,193,120,100,69,243,106,226,167,30,173,225,232,242,8,249,126,131,96,200,136,229,0,235,108,34,134,30,223,125,129,188,154,45,154,252,177,73,87,176,5,120,157,235,226,73,113,93,121,205,135,124,103,176,158,7,33,148,233,104,149,209,74,70,0,158,225,108,170,237,122,13,193,234,9,113,18,52,82,20,244,212,16,215,12,118,87,82,219,36,203,77,246,136,209,116,202,129,110,36,44,207,75,239,184,153,93,238,121,26,12,165,179,251,87,179,1,247,201,185,4,191,86,80,37,116,190,38,153,38,19,113,0,46,165,78,52,10,200,19,112,102,235,90,59,84,195,22,181,188,181,63,42,241,39,125,173,185,136,184,160,222,63,117,186,251,165,248,239,245,51,98,139,200,78,185,21,200,14,47,62,151,93,75,172,226,57,252,39,243,215,155,198,214,160,63,172,255,176,39,187,83,184,50,167,182,195,135,38,77,122,170,173,119,195,187,172,195,2,218,77,4,195,205,120,105,105,204,187,57,67,144,247,170,215,165,40,82,167,72,252,143,106,176,43,93,133,84,9,9,122,249,214,125,135,138,84,156,131,115,39,252,100,153,100,120,239,161,67,38,79,87,81,225,36,176,69,145,157,176,59,29,36,251,89,182,30,102,159,238,236,245,227,24,93,235,41,158,4,255,238,10,136,164,119,94,233,173,106,104,150,146,4,172,192,100,193,131,138,144,248,30,153,227,217,22,29,153,230,122,93,102,80,57,154,132,206,115,77,109,138,64,115,158,12,198,27,101,152,43,225,133,225,207,21,13,33,172,58,183,105,82,55,201,230,178,210,167,116,18,53,29,118,183,93,154,133,28,138,68,161,223,83,161,100,177,139,92,202,252,10,187,130,31,223,95,95,226,5,196,244,98,139,119,72,250,57,208,51,154,154,123,81,223,148,196,44,16,221,63,94,142,93,57,59,129,96,187,67,190,71,230,245,39,161,41,145,23,13,212,251,89,126,28,98,3,5,162,227,234,229,120,149,63,215,184,252,111,9,83,11,113,228,143,121,124,14,19,10,102,91,23,255,93,57,13,194,127,143,187,59,114,91,19,166,217,222,201,38,238,82,57,162,155,152,223,246,86,67,42,112,248,118,254,241,250,7,9,114,235,122,244,108,146,188,87,116,194,50,67,102,50,144,225,231,218,232,113,146,182,84,232,228,88,208,27,99,22,126,79,128,156,130,111,169,44,209,19,22,145,143,155,243,67,105,165,163,139,163,143,62,45,50,244,188,228,89,131,129,132,72,174,35,168,80,140,150,31,42,106,41,227,120,230,138,132,55,217,154,232,84,22,196,57,141,122,229,86,182,18,132,89,211,179,43,45,203,65,33,131,213,46,169,230,248,153,3,198,225,48,204,44,197,177,234,77,13,29,87,111,25,226,213,198,202,150,45,193,29,227,29,201,197,182,43,116,157,125,89,254,66,54,205,198,85,248,4,18,216,125,35,153,19,245,189,249,104,172,115,203,87,216,229,209,241,184,84,216,89,134,238,59,138,67,52,148,59,13,81,140,91,82,213,147,17,71,92,229,38,54,19,249,251,87,79,146,253,65,216,114,203,145,32,129,242,125,70,170,98,79,229,152,119,39,27,24,105,56,183,105,24,38,79,167,32,145,2,106,54,221,231,146,125,145,94,86,178,211,254,201,121,129,153,70,190,193,200,218,127,129,79,141,161,204,219,53,159,185,35,63,24,13,70,95,192,64,171,3,54,237,102,132,149,78,228,31,170,21,215,246,112,217,218,167,222,33,137,101,197,134,46,176,22,210,39,107,221,157,24,207,198,210,187,5,130,210,19,208,234,198,121,65,148,148,29,125,107,186,200,30,129,189,118,78,112,199,129,62,223,131,158,101,82,213,136,31,17,38,165,20,78,189,111,97,241,121,97,196,247,200,134,13,201,218,136,253,213,254,155,26,21,20,65,32,154,253,44,88,175,83,175,226,127,247,125,119,126,150,153,190,149,245,61,41,13,251,121,153,105,246,106,172,248,27,121,132,5,225,84,24,84,11,187,139,16,30,82,156,122,91,68,14,13,23,78,172,171,132,142,106,15,253,115,163,178,128,40,61,106,18,28,44,201,154,217,29,244,131,16,115,64,32,255,179,189,254,230,82,89,228,174,71,54,123,25,77,107,209,2,216,9,167,234,198,141,114,18,209,27,94,226,228,165,173,34,231,23,24,53,239,184,223,106,49,230,1,244,39,111,43,163,118,174,21,33,91,101,208,30,108,106,137,139,96,251,151,18,174,1,132,81,28,218,25,19,166,93,47,188,225,109,20,140,78,243,62,54,102,141,165,182,232,242,0,214,253,234,74,110,235,153,250,75,234,197,44,30,242,122,175,6,237,3,55,3,224,114,122,183,130,152,82,255,228,194,109,107,227,107,7,187,59,239,63,82,187,29,8,191,36,14,19,93,142,255,79,123,178,186,217,131,107,66,21,186,0,169,192,11,171,103,42,246,235,173,78,217,202,104,74,42,68,93,197,124,51,79,122,95,74,71,161,9,222,67,175,231,28,122,167,0,236,94,89,51,4,219,170,15,62,148,53,117,191,123,183,206,84,188,90,102,0,197,198,111,0,239,88,237,161,9,8,94,32,240,179,40,80,12,18,89,100,156,53,89,240,3,199,85,188,161,93,75,201,60,58,48,92,231,66,50,156,205,5,19,153,157,217,251,159,158,20,255,195,192,194,192,73,152,58,191,140,147,231,196,91,123,52,183,184,207,255,224,252,113,39,83,165,19,26,37,60,73,73,70,44,18,149,200,29,68,186,218,248,213,144,68,83,252,180,8,57,116,208,46,43,206,239,225,89,190,22,45,74,20,197,96,130,234,245,23,124,113,92,236,27,130,255,126,81,146,98,74,223,136,135,77,41,152,70,70,11,157,222,82,238,55,196,56,157,153,210,23,232,143,213,59,91,68,93,149,139,232,158,56,127,71,81,4,7,166,231,105,204,194,82,159,147,170,189,131,125,153,81,48,60,162,110,55,24,12,149,175,77,114,59,168,52,145,28,169,113,16,9,225,160,76,31,27,122,2,165,214,157,61,168,134,215,31,202,125,59,18,34,71,40,49,13,116,35,28,158,207,44,21,218,130,74,59,226,80,164,117,71,178,140,105,87,53,70,221,72,173,117,160,219,61,197,165,110,130,114,149,35,225,135,188,113,136,50,52,58,0,115,133,114,164,229,52,61,136,131,157,32,245,77,192,45,61,98,221,129,157,161,146,23,156,41,179,31,16,151,130,232,151,125,24,254,196,179,73,124,167,106,30,28,47,10,206,181,230,3,137,121,223,14,218,7,19,131,118,75,13,243,202,168,61,39,233,8,8,102,226,46,17,160,191,12,31,204,87,153,106,50,212,41,230,150,142,150,249,180,57,92,160,223,7,42,86,207,73,90,129,177,37,1,221,195,45,224,137,230,193,79,29,202,87,45,4,238,217,16,44,165,92,64,119,209,141,110,124,47,165,190,222,135,181,118,83,205,211,89,177,176,4,111,43,181,196,187,173,164,9,135,204,251,51,16,119,233,67,252,211,133,110,220,177,220,14,252,132,94,48,64,178,54,15,241,3,152,12,51,138,39,213,233,206,38,183,179,230,146,107,161,141,143,204,195,18,181,7,127,150,209,229,71,210,78,206,224,147,75,88,76,7,11,39,207,141,13,187,61,50,20,124,197,244,222,188,149,18,119,168,165,228,108,196,207,97,113,138,236,120,0,197,54,227,221,192,184,33,101,218,255,114,219,179,138,156,226,195,234,222,246,98,154,115,207,61,73,211,21,97,9,54,205,30,114,52,206,10,143,141,112,9,48,252,191,19,91,86,36,9,166,92,207,251,159,85,134,36,190,178,125,214,61,231,133,208,213,132,80,207,41,240,122,158,208,106,170,54,56,217,149,99,215,123,5,183,48,210,126,149,14,76,170,220,151,102,49,81,129,2,220,16,50,142,174,156,99,243,44,222,149,73,145,245,21,196,53,119,188,114,83,26,218,44,86,214,68,24,157,27,149,209,77,199,4,165,61,58,6,94,84,201,91,237,174,17,126,255,91,196,232,12,121,220,130,132,238,146,251,209,104,224,221,17,223,151,95,219,141,12,185,76,168,74,145,163,208,205,218,38,203,76,160,90,27,64,252,201,99,40,189,128,80,127,223,131,117,38,140,213,180,71,40,163,77,189,41,193,173,247,57,130,228,150,192,239,107,66,253,227,34,101,240,180,23,21,236,218,245,146,142,86,18,192,210,127,214,235,64,74,53,183,192,126,226,116,241,20,20,144,252,81,37,51,181,187,2,195,242,91,46,86,222,144,153,202,54,5,151,11,206,163,169,137,25,68,241,16,163,113,162,9,155,188,1,14,124,116,170,186,128,55,96,74,114,204,33,183,240,57,87,73,141,197,139,45,231,224,201,154,56,218,148,33,238,230,87,181,161,77,118,146,28,25,190,38,162,195,163,30,235,51,252,12,172,72,216,97,100,255,118,80,60,221,208,191,106,228,52,180,33,20,235,12,209,101,86,166,201,34,226,144,130,126,101,58,231,91,133,252,18,84,9,178,114,163,142,10,163,70,210,120,26,132,221,249,176,66,212,106,5,189,28,55,192,123,239,225,245,7,13,48,141,1,156,230,84,156,80,209,220,5,140,233,92,241,220,24,4,101,63,100,190,178,220,40,201,11,45,105,30,137,253,78,215,135,154,34,177,241,137,1,162,229,221,197,176,158,236,112,193,138,9,175,82,135,10,56,54,216,78,124,155,128,35,52,157,227,77,86,138,140,189,155,245,241,111,84,140,2,31,70,155,211,228,155,176,67,58,147,172,27,215,3,176,3,15,199,221,160,44,186,169,246,44,203,236,203,56,183,177,56,145,198,19,205,60,134,18,50,3,61,113,134,58,165,231,176,6,11,22,151,36,197,240,118,45,92,134,176,46,153,88,3,25,137,62,34,197,140,88,44,249,227,200,24,74,235,32,24,0,97,200,229,204,208,253,57,149,73,207,219,139,55,106,78,157,85,105,170,157,182,217,49,135,3,119,206,5,135,218,185,207,83,206,1,28,136,220,134,236,39,88,199,217,209,27,146,204,65,121,193,169,51,226,238,236,121,135,136,155,49,251,11,85,107,78,235,236,212,81,118,99,224,204,19,193,81,70,159,227,246,249,66,211,133,220,1,59,151,254,96,148,137,120,125,40,196,12,136,104,67,53,115,166,204,82,138,166,109,209,71,4,193,208,30,248,123,38,147,166,239,43,225,187,227,128,242,171,228,63,227,212,85,228,89,82,69,123,48,61,139,148,15,74,64,113,199,31,68,247,149,160,90,8,149,151,83,146,135,146,30,174,10,26,99,62,110,147,140,171,192,70,21,227,149,79,77,175,183,224,171,226,49,40,73,44,160,222,49,173,16,5,151,136,30,25,106,163,191,13,89,94,66,31,127,31,131,166,206,121,135,207,152,174,119,157,179,163,75,22,180,17,53,223,107,93,75,239,70,17,188,187,221,93,247,19,161,33,83,91,10,193,60,154,217,46,30,129,187,50,209,133,87,238,44,68,52,167,122,227,18,1,153,187,156,144,126,146,162,241,25,56,239,20,55,181,205,40,145,145,113,17,168,156,206,250,144,196,114,230,218,255,59,232,177,220,90,74,167,80,246,141,101,57,169,204,166,205,118,157,94,35,48,241,143,211,91,54,70,48,54,60,179,193,10,24,249,138,42,143,11,207,135,161,193,155,116,8,116,206,221,174,159,110,95,128,0,171,227,193,94,38,174,18,253,187,227,199,23,203,84,7,255,10,250,218,52,162,111,72,107,53,41,241,202,122,172,194,185,55,219,231,200,216,168,119,54,86,206,61,24,79,147,15,179,198,99,97,205,153,175,73,232,136,85,127,220,141,211,208,20,194,65,185,182,216,127,192,161,32,148,120,48,208,40,39,199,74,187,232,19,150,48,44,216,47,34,200,50,251,235,59,164,41,4,153,126,105,110,32,96,28,100,87,93,124,223,149,4,232,14,69,173,172,234,148,63,140,1,58,131,169,198,129,58,217,120,254,105,196,61,31,74,188,99,251,242,126,44,25,91,187,163,1,147,72,120,67,202,101,33,100,180,117,32,113,27,71,164,240,252,107,43,78,48,249,23,80,16,206,246,86,55,169,37,113,224,87,36,86,159,39,10,106,214,242,163,156,151,134,82,214,20,201,134,125,77,24,194,23,51,98,172,231,179,238,8,252,11,109,80,49,50,160,214,14,207,82,216,73,62,81,118,249,118,119,159,123,42,20,208,238,172,188,20,136,210,36,145,77,183,45,153,140,203,147,153,186,102,69,168,4,231,70,193,79,192,240,247,27,134,133,212,71,217,100,253,4,112,200,71,205,23,142,254,223,84,254,145,240,192,111,249,214,28,130,129,247,136,195,199,203,144,238,170,164,118,74,253,54,37,199,189,202,132,33,38,15,2,161,180,223,74,54,32,0,213,163,146,223,219,36,58,243,5,221,188,111,47,115,195,244,53,137,177,179,74,33,29,111,203,225,233,225,66,31,10,33,198,150,149,214,233,35,191,38,226,169,203,152,227,162,119,244,70,178,69,160,167,191,210,196,67,148,237,37,145,161,238,106,215,131,54,187,163,150,59,250,81,168,11,103,157,19,30,49,158,233,21,145,74,13,37,251,114,27,0,130,104,23,33,239,55,174,183,59,75,70,212,229,88,29,37,75,188,228,224,111,115,237,232,251,93,254,105,33,169,165,29,108,126,174,7,73,60,169,251,107,217,111,170,132,63,171,221,118,205,220,176,140,37,240,207,183,97,115,55,8,35,89,66,205,137,122,189,202,42,75,65,193,43,230,68,201,62,101,29,225,230,92,90,92,30,100,222,114,63,161,30,109,0,228,251,238,227,73,216,250,191,236,246,113,72,136,39,165,110,234,64,90,141,150,226,148,108,148,66,178,56,246,21,6,71,159,55,137,204,91,74,3,85,196,25,159,219,172,188,143,68,163,22,147,82,138,83,81,219,36,173,41,58,250,127,211,35,134,228,37,67,38,152,123,31,78,191,67,67,182,151,20,216,222,174,97,249,29,61,3,223,91,213,102,171,137,116,144,184,123,0,203,230,143,68,176,211,153,3,216,249,134,201,251,206,149,18,42,129,229,187,238,182,66,131,76,90,55,1,162,97,87,137,42,40,29,5,165,79,49,178,55,199,12,6,134,109,29,152,65,192,89,0,43,67,127,223,24,197,182,16,135,46,16,250,19,159,7,74,221,25,99,210,108,176,31,157,150,231,143,237,126,165,127,102,153,149,151,62,244,162,58,180,155,207,105,61,8,44,202,113,188,165,8,73,21,40,12,60,111,238,13,140,197,108,123,17,106,197,209,23,230,102,204,13,210,31,13,245,214,21,0,211,177,117,192,190,208,180,195,205,172,16,163,184,57,85,108,245,61,100,8,190,123,221,60,211,152,104,225,236,243,221,57,76,239,100,251,173,132,13,54,247,172,129,155,113,34,163,140,228,88,225,188,106,172,57,5,230,69,135,195,200,50,73,189,203,111,78,204,7,250,181,218,138,48,4,3,188,121,212,90,204,113,131,30,105,112,118,218,79,11,161,45,114,235,98,173,78,21,229,208,181,148,61,10,170,140,181,121,116,76,151,154,144,52,102,5,243,197,142,19,204,156,31,102,149,212,143,82,203,69,74,210,64,232,180,12,134,2,164,17,224,237,47,132,40,132,112,44,126,228,46,138,80,115,94,244,214,231,186,170,55,83,167,30,172,231,120,86,73,21,112,229,86,30,233,0,175,83,255,220,11,8,195,129,142,126,86,152,20,251,108,140,67,11,236,186,12,49,40,130,87,10,115,222,42,108,98,181,107,199,63,178,110,122,172,184,125,148,142,234,211,42,210,48,72,89,182,193,215,89,70,111,78,22,92,111,63,64,115,45,226,196,186,153,43,58,46,3,247,133,128,252,115,137,114,10,249,174,93,184,110,152,118,131,80,15,80,86,11,39,131,5,238,16,86,205,252,236,100,74,29,84,80,254,129,21,162,23,177,101,70,154,228,68,115,71,156,198,252,137,229,204,29,240,79,43,248,211,216,107,74,66,144,24,116,0,50,88,49,232,35,185,246,62,26,65,24,161,126,114,2,66,162,41,192,66,138,204,5,121,146,180,219,155,140,119,31,165,150,103,252,50,72,202,17,194,160,100,196,223,225,83,22,93,108,123,210,213,244,144,187,211,138,100,240,110,50,42,200,59,252,211,16,115,204,86,112,174,102,246,202,235,97,115,162,15,190,152,207,25,241,37,51,137,139,74,32,43,253,58,54,42,109,32,73,50,207,189,75,160,10,112,37,69,171,85,179,224,137,3,100,121,125,115,189,9,1,123,84,104,112,97,190,180,174,117,143,14,241,65,130,76,176,252,76,31,242,225,115,129,78,182,154,203,212,116,53,182,73,132,50,108,210,169,242,195,21,25,31,107,245,209,187,50,218,7,233,113,86,236,175,107,132,39,254,108,200,81,193,180,13,16,253,215,75,49,42,164,156,224,195,120,130,193,255,96,151,236,66,22,203,208,200,7,151,243,96,60,155,253,230,155,14,179,206,33,236,0,122,150,146,135,216,179,75,245,134,103,193,18,174,253,121,222,143,130,17,84,229,216,186,210,12,177,10,220,13,243,179,182,157,150,17,112,57,166,136,111,0,232,159,178,120,126,240,210,89,198,81,194,55,170,245,60,252,128,148,59,136,63,254,155,248,106,96,139,158,34,187,205,221,200,68,161,97,36,41,61,170,23,180,107,129,46,49,26,130,1,100,165,72,238,84,238,186,185,180,243,69,207,186,251,183,228,82,139,230,138,190,205,58,172,91,204,40,238,66,30,81,161,74,46,250,82,86,246,87,237,22,34,235,73,120,166,252,107,22,124,162,173,16,113,218,246,24,173,96,218,57,237,94,237,51,188,134,191,20,254,86,159,43,54,230,155,43,19,228,32,0,195,205,203,130,111,237,204,35,75,198,239,244,114,127,221,39,253,222,207,138,97,242,141,237,6,129,63,248,134,175,154,46,73,138,33,246,134,116,124,154,108,230,133,160,153,215,255,42,185,203,139,90,141,122,229,243,22,138,120,129,58,248,36,98,35,211,253,105,107,224,254,84,228,188,185,48,107,207,185,81,36,109,169,200,122,202,121,80,36,254,113,37,126,230,233,58,143,67,164,59,13,205,157,85,172,233,47,186,137,111,158,3,55,122,133,158,26,107,242,172,227,202,199,128,8,68,191,173,250,52,82,137,118,2,144,171,123,215,15,88,7,64,213,174,109,4,117,91,194,47,229,227,84,71,249,32,173,242,192,174,151,59,50,50,4,211,200,162,192,65,177,143,164,42,107,212,245,153,49,107,173,148,78,211,248,250,49,190,167,66,82,135,15,97,18,185,17,223,146,5,221,143,106,144,100,72,204,77,85,139,146,38,46,181,42,188,226,251,115,1,164,87,93,121,122,187,120,27,151,81,166,145,30,166,220,19,120,168,192,149,16,204,26,70,228,217,22,59,33,97,18,65,25,38,61,199,121,133,185,69,154,246,100,222,104,187,57,150,152,190,96,151,113,178,29,211,148,161,146,171,91,152,174,20,130,176,154,164,81,38,146,24,142,163,186,19,74,207,44,14,170,117,140,99,89,41,95,104,133,181,214,52,41,91,6,110,240,161,32,18,30,197,201,219,253,174,9,149,1,228,18,98,163,195,228,205,54,209,131,199,56,177,28,44,159,63,207,4,167,233,130,171,52,67,136,104,82,20,172,42,46,166,100,74,86,246,253,139,63,82,7,223,50,21,230,0,106,217,141,213,237,10,215,218,207,220,115,44,248,226,226,182,28,190,203,74,115,169,201,234,193,132,77,110,100,7,14,234,244,76,216,210,143,146,245,178,155,98,78,94,143,225,143,68,80,84,89,86,138,124,96,3,83,100,42,167,248,234,203,205,41,133,250,163,229,232,223,92,107,47,225,223,181,206,91,64,224,72,249,247,3,143,159,35,16,36,194,250,164,56,242,247,186,126,161,230,26,169,116,120,230,15,129,77,117,79,26,76,158,32,40,134,243,218,64,130,208,90,234,31,118,1,227,214,125,108,77,171,206,35,142,12,231,124,143,94,79,177,39,152,1,137,11,73,207,239,140,28,4,254,85,89,132,235,28,155,73,159,167,69,213,90,136,144,219,168,238,9,188,199,119,229,94,171,113,236,144,129,255,43,52,87,10,232,132,193,160,99,4,138,235,173,142,216,120,64,24,188,86,26,161,72,2,135,146,7,212,133,68,85,85,46,226,251,46,129,93,90,247,155,178,96,53,172,141,225,205,25,79,210,69,177,148,231,219,194,105,204,241,129,127,227,220,36,233,47,254,140,181,199,60,208,168,97,125,46,48,52,219,110,89,199,96,20,189,204,124,133,189,109,71,9,85,226,202,229,115,219,77,245,190,85,157,90,43,243,73,195,30,15,158,186,153,160,70,204,31,142,240,167,40,189,72,62,244,160,216,72,241,197,69,59,62,111,108,107,254,79,213,192,103,54,121,84,47,175,218,208,71,187,66,106,61,150,43,204,179,66,189,140,40,132,163,55,186,87,125,162,64,183,254,177,215,189,125,136,25,129,145,204,15,79,96,12,38,100,58,193,20,78,64,9,31,143,108,92,80,70,184,106,118,206,14,42,16,145,135,90,9,111,154,250,84,108,178,22,4,209,86,177,8,127,116,195,184,224,197,43,146,133,21,221,180,172,110,231,225,64,232,242,7,52,188,21,207,197,18,204,213,158,184,59,56,92,58,39,42,140,21,57,27,198,173,139,219,235,216,184,86,223,182,35,86,193,8,110,254,208,19,22,237,123,45,84,153,5,4,180,142,183,38,66,139,1,158,133,14,151,218,170,145,200,182,87,112,27,174,68,211,48,203,209,114,113,93,178,237,119,201,92,229,240,127,29,26,50,196,166,20,0,169,159,26,177,213,171,243,246,196,231,203,83,160,18,232,229,75,237,191,93,50,16,55,61,242,154,192,39,116,184,226,83,165,169,48,222,135,189,165,31,41,36,153,157,214,5,161,46,34,62,251,162,54,180,231,99,162,197,60,1,10,243,240,111,237,43,148,10,27,254,145,241,185,193,11,93,176,140,229,92,42,207,234,91,56,140,228,12,57,80,119,231,157,177,39,99,70,132,116,245,100,215,241,56,227,131,96,58,172,23,66,49,203,75,47,84,25,48,150,16,65,36,224,216,128,21,43,50,123,254,132,75,48,221,206,134,162,53,4,225,145,234,88,221,225,236,21,182,172,237,254,107,69,204,82,246,29,50,208,219,60,208,241,156,53,47,66,246,70,242,79,54,94,27,118,62,195,255,76,36,90,0,110,54,186,236,213,76,228,199,28,54,42,112,205,70,52,109,160,132,168,108,116,192,236,3,168,211,29,51,230,250,234,193,21,44,249,49,75,225,100,234,130,240,240,200,215,232,98,250,48,11,152,39,215,57,190,24,0,210,157,153,222,36,230,160,8,73,42,150,37,65,184,1,50,33,253,136,64,28,105,198,22,223,207,133,30,71,115,74,28,73,198,154,117,158,188,34,252,102,102,93,14,20,182,42,71,70,106,47,173,229,43,182,193,11,157,90,170,221,13,219,8,9,10,100,68,217,22,156,135,209,33,104,132,154,77,137,159,216,7,183,15,157,39,230,151,196,222,158,72,57,158,27,6,243,104,191,32,185,196,140,193,176,209,136,15,83,87,184,139,234,111,6,142,86,169,95,129,93,45,3,191,51,162,152,239,97,234,35,5,33,93,55,193,52,113,40,105,253,114,96,50,103,198,182,231,202,166,59,15,133,19,102,199,29,103,24,64,11,21,76,219,184,132,59,95,32,174,46,152,172,140,173,181,231,101,188,184,147,183,143,25,46,241,9,144,111,153,107,16,74,250,28,144,70,148,96,209,98,113,28,136,175,126,0,180,36,131,29,253,179,191,121,157,0,191,199,206,146,126,139,143,5,176,220,172,179,125,230,35,38,40,6,45,58,153,60,144,59,56,1,80,234,158,250,128,45,95,195,254,85,175,231,208,179,44,110,178,8,180,121,120,0,75,132,109,9,133,48,211,227,80,182,107,30,122,216,40,161,4,181,124,250,232,162,72,131,165,230,253,249,213,148,203,202,122,217,115,0,159,224,254,217,217,142,65,159,154,205,239,201,212,222,128,109,86,113,231,65,251,80,167,133,198,213,249,116,129,85,251,150,239,26,45,31,202,146,164,164,204,80,99,143,126,128,166,140,117,12,46,35,194,209,46,239,100,220,19,148,205,237,82,182,119,80,195,22,71,227,93,165,117,181,129,60,26,154,217,91,223,155,194,88,83,228,197,151,73,155,130,194,232,121,245,236,177,244,169,186,85,102,251,52,110,159,182,110,195,226,100,202,154,119,112,214,96,195,141,11,20,195,116,160,132,211,111,204,31,211,86,181,237,121,227,79,157,147,195,88,108,105,240,199,193,19,93,236,44,250,146,65,80,140,165,20,103,45,106,70,67,132,167,131,175,171,154,40,119,82,150,97,189,175,58,42,113,88,159,22,7,57,228,15,95,232,182,45,171,140,164,127,74,121,254,33,146,164,153,96,78,107,156,194,46,100,88,106,177,120,251,22,246,212,178,203,216,164,162,43,176,182,28,134,130,121,252,61,12,169,172,202,58,16,45,134,235,128,44,49,12,12,96,40,148,8,148,226,172,224,143,190,178,4,183,83,95,82,34,152,231,205,169,88,89,93,131,180,77,153,239,14,19,204,166,164,231,56,221,68,248,100,36,33,55,63,90,119,141,96,241,70,155,7,103,141,252,70,196,121,159,81,135,101,28,176,81,4,152,95,180,191,37,102,94,146,142,84,105,0,24,10,29,30,9,53,250,193,132,13,38,28,246,164,137,165,182,115,184,158,154,203,219,90,40,61,39,233,184,92,104,187,54,49,242,85,169,10,189,173,63,114,36,65,49,195,254,174,195,219,12,95,149,70,185,158,168,157,241,33,70,82,130,207,196,245,238,234,43,29,225,181,31,57,66,161,179,8,74,208,55,60,67,17,190,5,76,255,32,3,83,223,182,192,77,218,27,32,85,166,76,174,82,244,23,55,212,163,249,191,159,218,37,139,83,141,70,80,126,176,5,142,132,22,221,117,102,228,24,190,241,156,205,113,99,203,161,140,133,93,63,48,240,191,119,149,235,89,103,185,112,121,199,71,122,245,126,50,26,163,201,174,61,178,102,142,23,196,191,21,15,238,157,226,132,232,174,28,139,106,78,17,141,66,155,218,217,39,66,175,179,81,204,128,64,37,202,148,47,244,205,111,232,209,193,140,229,148,44,26,173,107,211,214,159,185,104,69,43,111,39,167,132,15,113,211,238,129,189,65,149,46,5,135,148,83,40,184,52,113,148,178,147,217,156,65,102,238,170,80,218,209,43,92,115,204,158,145,125,13,72,139,37,52,196,44,236,211,250,191,116,12,24,247,82,34,126,87,18,209,3,219,207,79,113,91,170,79,170,149,45,66,123,165,237,201,120,117,80,214,221,141,3,92,145,176,90,105,95,2,13,177,248,200,210,108,76,193,13,242,167,14,9,250,64,212,29,244,136,164,52,197,58,245,66,34,141,44,59,69,212,243,30,11,126,25,254,199,163,211,199,51,95,54,241,185,179,80,211,52,37,41,48,2,178,60,167,177,255,178,23,134,234,167,165,5,232,33,191,12,240,130,242,253,104,228,30,132,14,206,4,164,171,245,93,195,26,128,218,50,127,171,8,101,147,110,151,160,2,175,184,22,71,115,35,107,160,255,13,30,204,65,64,139,12,188,38,176,139,52,143,3,27,99,48,102,215,76,249,153,217,189,110,53,192,129,25,37,215,127,119,232,117,32,10,47,161,43,155,94,99,103,64,228,216,155,22,243,8,83,232,213,244,1,236,64,195,50,171,63,17,184,228,47,241,145,14,167,31,171,141,230,196,159,79,166,33,246,131,21,168,198,34,36,92,161,129,138,144,120,125,215,48,181,203,195,32,99,110,38,209,29,44,23,163,222,59,52,113,52,222,221,213,31,112,243,110,54,118,242,103,43,149,215,73,180,113,150,7,96,108,212,238,231,14,204,241,100,193,55,206,30,99,177,235,96,19,118,211,21,156,13,28,57,161,176,120,21,163,227,157,207,17,48,174,183,174,236,198,63,77,24,168,128,47,149,175,59,24,32,146,12,52,166,165,91,106,97,61,133,170,205,169,45,209,149,105,219,255,164,111,31,85,147,21,183,131,13,50,12,170,129,254,45,18,193,60,23,91,146,183,1,2,209,118,105,78,148,221,43,125,136,85,65,141,52,215,241,12,148,20,95,142,155,226,29,26,144,124,139,53,49,228,49,26,164,210,36,107,45,232,15,10,160,165,182,105,51,235,81,68,15,41,127,94,81,250,88,9,110,164,240,231,113,176,224,153,223,40,166,96,174,208,231,30,10,175,244,96,115,12,103,143,20,128,76,178,133,120,139,253,88,149,31,253,166,215,133,108,1,47,179,117,23,97,99,53,255,26,102,33,255,116,34,244,82,21,125,209,178,162,109,192,152,8,156,206,180,63,255,139,80,253,240,65,137,23,177,191,57,60,98,122,89,75,125,170,30,168,167,97,154,36,35,79,79,224,114,246,252,173,150,78,194,10,133,68,192,117,163,132,172,35,215,122,141,113,229,158,64,131,244,112,10,32,208,125,202,143,192,45,69,12,213,224,200,101,120,6,237,200,221,239,146,58,210,138,93,236,147,170,154,35,236,53,142,164,66,143,172,185,3,250,104,132,10,161,43,247,36,105,111,106,129,8,238,128,51,147,104,99,140,142,211,181,44,11,224,156,205,185,105,151,52,171,200,183,217,254,171,33,112,166,40,198,205,148,78,185,239,26,225,229,153,166,159,250,219,160,59,196,103,224,201,246,115,107,230,128,50,196,215,228,147,39,187,129,32,210,47,253,194,111,67,29,3,134,196,253,227,82,53,50,143,192,50,134,14,11,49,84,155,240,53,154,35,2,35,21,253,205,106,0,207,49,192,74,163,98,224,142,12,196,0,90,125,172,60,206,255,203,183,254,161,255,19,21,48,73,181,242,191,66,39,156,119,209,180,119,76,215,70,43,23,135,223,164,131,75,174,38,13,47,187,46,19,22,126,203,15,244,210,73,28,28,35,63,203,146,69,143,79,151,127,217,207,210,68,155,219,36,106,67,19,225,31,195,207,32,195,1,18,80,11,147,86,85,78,15,1,184,228,41,127,200,179,225,88,178,245,252,221,219,162,146,207,149,93,169,71,68,198,35,11,174,123,228,71,211,20,25,6,120,180,45,147,18,62,15,29,175,42,250,157,109,59,182,14,41,209,70,6,110,138,243,179,79,195,250,119,116,187,208,161,235,209,26,116,81,254,222,191,117,163,51,132,102,230,44,251,152,76,29,94,246,200,138,78,37,10,99,209,118,50,103,254,67,102,101,75,27,136,102,155,146,231,175,156,111,34,229,175,221,185,223,162,50,37,233,165,169,151,210,191,2,126,202,222,146,238,173,61,163,118,201,140,224,110,202,99,248,36,115,143,156,234,241,80,86,226,167,136,183,239,204,165,43,40,117,130,34,236,224,26,102,30,12,253,210,25,233,23,42,197,173,45,135,158,101,213,252,131,239,69,134,184,88,156,31,18,149,217,135,37,111,82,160,85,109,219,47,87,134,188,101,226,186,132,96,200,205,93,193,238,171,141,32,8,217,85,43,228,198,90,249,157,214,33,81,112,181,138,193,204,218,40,216,163,190,145,185,13,172,189,151,102,65,0,224,214,134,186,159,45,77,10,223,65,155,120,154,160,117,229,204,69,140,215,210,57,57,215,175,117,185,72,125,185,44,243,162,123,155,170,12,189,92,240,162,252,89,61,30,110,31,142,214,216,73,234,119,129,250,140,175,61,184,148,179,88,211,236,17,140,236,192,74,204,188,235,23,189,249,145,50,161,255,170,10,145,243,173,31,37,254,143,27,148,215,169,55,128,135,111,0,145,215,111,239,214,253,107,247,148,13,111,251,243,233,112,73,128,188,243,84,35,158,114,25,121,221,255,209,214,112,77,71,191,236,250,229,127,110,6,230,106,103,158,32,239,204,44,236,17,60,231,38,131,206,144,160,3,12,54,28,111,233,142,248,33,163,26,154,218,42,249,10,64,63,195,106,209,80,252,89,131,206,36,95,219,140,184,41,42,16,9,91,79,89,190,247,179,145,22,155,251,107,236,50,34,64,242,124,242,16,145,163,33,5,0,100,26,42,111,133,36,54,124,254,236,54,230,229,209,34,4,46,188,243,162,206,235,97,145,229,239,252,86,223,239,76,8,147,134,108,90,141,155,213,145,114,50,193,22,157,107,160,43,127,115,73,33,194,166,179,249,207,230,132,17,238,118,141,207,202,157,170,115,21,232,157,202,188,0,234,114,76,72,157,255,140,237,8,179,9,76,144,238,233,185,205,32,31,55,208,126,213,255,193,41,237,238,76,20,250,138,85,93,31,133,22,220,245,24,127,254,248,148,138,55,130,153,251,23,114,146,138,210,43,125,244,5,110,151,22,133,3,20,125,124,121,249,222,227,26,230,0,194,11,24,132,150,36,221,0,84,248,231,163,22,80,84,145,87,149,153,255,75,126,86,253,223,252,148,68,189,7,96,245,214,228,77,6,91,81,204,155,101,226,94,162,160,25,152,2,63,122,91,117,228,190,210,36,218,89,207,49,229,2,221,123,75,36,63,72,137,236,147,216,169,119,76,167,100,153,27,53,17,161,95,155,176,227,112,133,24,171,87,154,121,128,240,200,180,32,180,161,129,204,202,6,238,246,218,215,16,9,106,135,116,153,121,200,195,106,215,49,126,67,163,46,240,21,83,37,168,98,3,80,141,12,188,54,170,128,253,20,37,161,71,85,129,111,137,19,53,158,190,73,211,78,113,147,114,77,98,71,45,30,212,141,170,141,171,31,195,6,126,100,234,8,249,149,251,5,250,7,164,78,145,129,129,1,195,31,125,150,121,86,133,63,63,251,149,184,121,71,129,139,107,83,174,180,230,37,217,131,109,99,67,114,200,233,195,251,83,126,23,105,48,102,95,165,102,75,144,16,207,186,37,165,116,149,9,172,123,117,186,244,207,44,45,50,190,253,131,62,101,77,40,165,58,227,232,212,157,18,143,43,140,235,28,116,108,187,9,32,153,244,21,119,38,159,118,48,80,51,145,162,164,203,24,122,62,28,48,125,49,3,62,131,161,191,157,87,38,109,159,119,200,187,191,254,189,75,54,229,222,98,126,171,194,152,172,115,255,153,0,51,92,151,189,222,68,113,42,187,241,22,229,172,90,154,250,56,83,252,171,4,239,4,59,93,179,157,71,201,218,154,97,212,74,16,165,216,6,56,92,253,208,158,237,27,40,133,47,197,188,65,159,1,39,203,121,113,141,179,251,163,127,219,62,156,84,254,4,154,207,103,42,237,1,229,209,246,43,234,26,249,137,36,95,231,234,180,11,211,102,45,159,226,70,41,230,168,106,39,132,64,98,1,7,73,67,164,94,174,245,161,34,138,84,236,227,176,204,134,45,115,106,248,236,93,40,28,50,121,102,32,83,4,58,5,89,70,207,159,254,208,83,213,7,34,124,230,52,201,138,109,54,34,80,78,194,107,102,151,91,150,89,48,220,59,117,157,73,104,180,143,61,53,201,16,114,192,159,109,192,27,212,0,124,142,74,182,203,43,11,205,89,194,241,122,60,1,123,160,174,158,244,82,62,231,240,237,176,72,191,210,155,182,209,230,190,95,185,190,49,165,204,71,14,79,77,240,229,146,130,141,140,229,30,210,143,19,115,140,78,49,247,180,49,26,243,100,139,139,3,242,163,100,162,141,242,110,64,234,90,36,85,58,34,48,34,85,200,94,181,225,80,48,1,157,16,78,158,212,149,186,187,43,178,18,187,190,104,167,189,38,87,223,119,128,223,7,89,157,122,205,183,44,127,235,64,156,185,82,219,46,227,238,151,207,138,36,186,160,42,231,146,235,15,229,134,204,69,85,9,192,47,134,129,193,3,53,77,252,116,22,243,225,10,41,70,151,186,110,174,77,71,203,96,194,66,107,136,159,208,250,67,48,13,155,72,73,212,194,210,202,131,135,113,220,225,174,135,203,152,13,97,14,141,169,172,113,161,105,125,86,141,171,150,168,175,170,101,85,161,222,103,174,155,91,8,45,165,87,141,33,199,247,107,20,53,129,202,243,131,254,96,185,57,25,159,101,166,244,205,249,185,28,191,130,157,148,253,170,140,60,15,71,158,57,197,216,176,251,106,14,164,82,140,73,125,22,107,23,40,34,34,4,211,174,114,188,40,84,121,14,221,65,152,127,23,216,152,103,71,159,173,176,135,234,237,202,14,248,224,65,76,37,68,94,152,81,3,87,159,7,130,118,134,180,70,13,138,226,168,149,66,170,179,40,146,231,250,49,74,178,191,199,237,140,91,99,28,168,72,41,179,44,82,196,191,195,174,25,7,62,74,202,175,16,92,24,71,205,51,219,251,5,37,31,120,59,237,106,33,48,88,5,172,54,133,255,175,11,99,104,216,24,114,51,69,252,159,69,17,145,119,166,72,216,30,229,146,157,209,152,5,45,55,228,247,145,217,150,18,109,82,138,193,136,209,14,38,107,107,205,103,200,115,61,196,251,127,225,141,182,112,232,202,178,228,77,10,183,8,202,67,151,237,77,200,143,106,141,167,25,4,219,23,191,234,9,88,114,229,193,41,0,107,244,93,1,142,195,57,29,141,208,15,255,226,253,1,132,29,79,80,67,232,179,7,128,64,0,104,77,89,1,128,128,47,220,180,0,90,9,138,31,215,212,13,24,28,183,22,40,147,96,119,110,86,232,190,156,210,247,78,167,155,109,22,176,73,142,119,250,196,253,99,98,80,82,114,253,55,245,163,13,202,13,110,87,7,174,178,53,164,24,107,233,196,227,161,144,66,48,125,85,212,236,172,190,115,38,250,153,205,27,177,0,122,35,45,121,20,196,164,102,95,218,73,33,2,189,178,254,107,211,183,152,20,154,221,43,14,210,165,119,109,70,3,14,188,219,180,118,71,92,13,27,129,87,127,160,163,169,157,115,232,53,104,55,212,207,253,151,184,237,68,18,184,167,248,160,20,67,79,199,182,67,137,246,243,38,253,34,174,87,24,249,92,147,168,81,166,71,16,142,91,242,77,20,199,113,148,148,120,200,19,79,99,63,163,53,4,205,180,124,125,111,157,12,131,69,195,20,125,3,16,81,82,130,182,146,206,75,34,142,106,35,224,137,76,95,181,33,61,33,113,121,137,82,38,50,230,78,117,140,115,102,122,17,252,246,111,111,145,106,30,198,124,233,235,229,254,69,128,111,90,96,180,118,80,166,186,138,110,188,90,120,84,22,176,36,173,21,42,232,5,234,53,193,199,191,130,205,157,238,142,43,48,176,151,204,56,13,90,53,123,184,156,253,185,199,136,169,154,248,232,251,144,212,139,102,41,157,147,234,186,241,57,107,39,197,156,97,83,56,236,152,182,143,181,28,106,81,4,97,5,205,116,21,117,17,220,211,254,1,45,170,96,14,237,24,2,16,40,223,40,205,189,163,54,85,234,188,224,118,182,194,83,199,233,220,214,123,61,111,27,15,237,99,197,26,99,114,239,10,45,249,193,143,75,171,36,121,207,229,16,22,177,51,55,144,124,64,117,191,1,39,33,218,89,65,96,26,171,57,61,166,191,167,156,64,235,47,59,7,26,240,100,156,205,3,12,184,97,164,3,136,88,220,116,167,4,235,76,208,202,230,51,147,255,82,107,212,64,89,90,163,11,227,121,180,83,128,178,146,41,185,79,111,236,131,25,207,116,161,128,60,196,125,3,214,90,25,66,183,96,125,130,196,96,197,220,241,100,24,205,175,250,116,40,227,242,15,206,169,45,200,52,178,200,53,254,160,163,97,164,197,211,223,120,50,210,153,101,123,252,204,171,94,35,44,151,133,205,30,171,97,97,27,234,167,243,246,11,103,193,45,255,205,167,212,72,9,236,174,66,215,173,207,119,12,48,156,81,41,151,210,112,63,83,72,82,149,118,15,150,109,142,63,238,176,117,133,150,76,220,213,104,186,194,157,113,158,72,77,106,199,198,92,68,99,75,110,97,205,221,90,5,51,62,43,10,36,135,230,36,102,69,58,10,33,166,232,74,243,194,37,15,246,32,35,21,125,156,25,210,155,119,184,176,4,123,59,214,150,186,88,118,231,253,120,150,158,177,85,188,110,142,225,153,113,181,228,28,121,26,154,23,51,19,32,231,239,72,88,28,197,132,146,177,229,60,2,21,142,189,19,83,206,15,141,136,235,171,102,12,92,195,134,142,200,91,111,7,231,127,228,99,34,33,153,32,148,172,239,122,185,41,155,137,224,239,91,250,164,195,238,130,90,250,98,239,130,221,250,83,106,223,99,155,234,175,122,136,105,255,166,129,42,215,237,130,140,230,139,126,237,178,206,56,61,221,144,248,86,81,35,184,113,227,153,238,90,66,245,9,30,209,57,188,110,170,243,184,148,219,52,176,42,167,103,136,218,96,247,188,249,109,118,156,194,89,152,255,16,13,41,78,99,252,139,120,177,48,90,31,29,215,136,58,246,155,123,131,132,185,152,141,131,131,102,43,238,209,252,247,108,87,83,70,124,129,131,128,21,8,36,7,255,249,217,122,7,129,118,40,173,11,186,183,149,207,147,126,150,149,173,112,218,85,29,165,177,93,97,253,168,233,158,66,147,77,21,123,162,248,204,116,30,170,204,162,26,83,248,108,104,0,20,44,13,86,240,47,111,46,50,117,88,70,235,230,145,227,63,128,245,207,16,192,59,237,91,165,91,170,218,183,156,239,76,174,142,112,152,199,87,224,72,85,144,124,142,249,145,15,228,249,243,13,38,220,218,39,191,4,206,45,38,185,34,202,58,116,219,89,215,180,65,23,102,212,193,55,24,131,19,98,98,76,75,134,182,88,163,245,94,48,126,147,93,193,208,125,89,40,203,154,58,193,244,119,84,60,74,54,126,202,58,131,16,239,221,60,85,228,74,108,71,244,138,245,68,228,62,82,86,99,71,255,56,108,133,135,115,98,90,38,228,235,135,108,152,220,231,46,230,147,36,103,76,213,167,40,143,39,246,235,89,123,43,16,180,20,151,77,134,154,33,214,76,168,139,108,88,230,199,75,253,7,134,99,61,241,23,128,45,132,142,114,3,62,117,39,119,171,37,212,103,98,229,178,171,102,167,199,116,3,235,164,250,73,58,230,40,103,197,21,239,66,44,76,158,234,23,166,108,235,220,184,34,24,122,215,25,123,55,126,130,24,214,4,15,232,62,103,93,104,161,65,123,161,187,180,102,227,161,136,231,198,242,158,97,47,126,120,32,97,160,212,56,196,152,120,245,203,36,220,153,10,136,165,250,174,77,71,243,161,143,107,160,218,16,204,32,46,129,120,252,23,14,230,225,87,239,2,41,168,176,84,85,142,141,226,50,103,210,98,202,137,183,210,0,159,85,111,154,240,79,200,187,23,135,145,145,238,69,40,141,20,236,118,144,105,85,166,157,10,40,133,141,99,149,104,15,21,176,110,165,247,254,28,156,154,228,83,248,8,19,161,125,71,219,231,172,241,112,48,27,70,123,224,111,82,245,141,3,162,181,77,199,4,93,214,150,184,115,229,243,11,219,148,46,30,254,215,241,174,196,156,173,50,52,141,203,190,238,222,33,77,214,138,194,205,228,35,90,73,64,63,151,215,104,227,80,4,54,168,120,92,16,229,96,148,226,52,76,77,92,224,197,218,73,145,65,243,60,240,217,241,96,159,30,203,85,34,39,75,235,44,123,148,59,11,220,165,209,43,118,123,240,97,124,220,228,186,254,43,45,168,87,253,11,241,218,9,36,190,142,221,241,43,212,191,38,90,152,36,254,60,79,106,45,73,153,102,2,57,175,19,61,45,160,137,43,32,164,20,62,231,7,126,232,75,209,159,72,139,181,119,165,216,175,143,68,209,240,191,198,43,42,152,88,191,31,243,110,101,187,8,32,226,194,73,149,203,44,187,218,53,87,63,183,154,177,81,59,94,20,131,180,5,97,105,60,145,94,109,41,55,190,67,229,9,51,104,118,50,231,169,94,252,67,123,106,131,28,145,80,238,44,177,105,211,207,98,90,86,152,207,194,248,255,100,168,247,189,204,192,103,248,167,37,92,109,206,201,112,153,119,127,78,111,112,87,190,158,78,99,199,205,104,82,50,96,86,116,235,215,96,90,61,250,246,156,195,18,6,212,217,177,178,113,200,5,203,90,208,63,158,60,142,197,127,2,227,85,254,49,77,27,99,228,193,180,172,121,162,0,142,246,196,83,84,162,202,24,130,40,139,40,194,198,84,96,252,205,228,57,241,176,1,255,182,200,221,160,54,48,199,241,58,105,81,39,96,98,121,103,235,35,84,211,10,14,68,130,240,96,208,185,218,40,64,40,139,237,236,227,40,32,226,10,69,165,8,191,194,31,184,175,170,155,25,231,24,151,124,70,169,124,56,222,122,123,187,249,34,103,152,246,151,255,85,45,67,48,117,136,152,215,82,154,237,1,201,131,134,81,115,4,177,216,1,115,119,235,76,114,211,100,35,142,152,212,112,152,120,83,217,52,136,55,41,154,192,231,157,218,7,136,43,7,50,233,230,215,24,55,118,162,245,195,25,94,212,152,139,23,139,218,195,236,128,129,229,127,181,131,109,23,144,129,132,102,131,205,73,59,12,229,188,211,9,156,136,172,132,238,162,132,163,100,239,45,128,37,227,148,170,222,83,246,196,226,165,46,117,59,164,221,192,239,181,63,152,154,206,73,32,255,32,16,134,46,170,69,40,184,57,35,215,48,129,137,81,117,7,48,225,40,183,142,73,172,132,108,111,159,184,231,17,176,108,117,255,232,229,29,236,184,9,94,214,218,1,218,80,186,207,99,35,131,31,222,77,73,205,25,178,22,21,163,177,91,200,12,139,127,106,250,79,151,151,141,143,41,66,41,88,150,182,11,175,61,71,127,249,112,9,208,168,95,175,147,179,150,141,34,78,206,9,153,185,146,69,60,147,202,34,254,130,91,190,197,58,224,232,60,193,6,167,208,199,221,44,27,46,65,122,213,226,124,232,112,96,76,115,36,238,109,238,103,101,210,21,45,182,210,122,158,13,248,18,139,160,243,233,245,255,228,179,2,52,251,141,171,142,1,190,2,110,224,240,174,249,203,80,0,92,64,244,106,32,203,34,246,86,86,100,55,33,120,134,44,221,227,48,222,13,130,152,110,7,52,249,90,28,183,129,28,51,253,9,25,149,187,73,26,168,99,90,23,222,74,226,116,75,200,86,193,88,238,84,31,233,136,147,204,131,250,7,20,94,48,76,222,135,71,154,29,24,130,215,234,128,46,63,154,233,226,33,42,121,41,37,126,96,62,11,128,142,34,230,101,52,96,10,143,148,7,186,99,185,116,13,102,206,19,178,251,162,213,199,37,243,116,237,53,254,20,236,103,223,240,65,33,206,16,222,138,197,243,112,36,67,24,214,107,101,193,1,204,99,48,240,29,101,202,11,211,165,43,81,0,127,72,206,8,103,188,109,255,60,117,27,71,48,217,175,73,44,174,129,54,173,164,20,5,82,25,195,156,66,4,90,125,42,235,212,131,115,148,204,189,33,75,154,188,250,154,199,184,59,193,243,62,82,254,248,56,38,253,186,164,74,4,156,240,82,225,20,34,13,6,167,221,104,206,75,121,129,227,41,83,28,229,27,205,138,119,97,2,0,252,40,5,253,234,198,23,11,101,30,191,94,178,193,220,42,92,47,171,17,75,147,73,120,236,230,170,158,74,187,152,111,206,120,176,94,33,103,147,237,64,244,19,33,225,232,211,2,195,188,148,205,79,149,244,123,112,163,234,158,96,74,104,117,75,4,230,220,169,75,243,24,49,101,27,185,44,224,7,67,57,166,217,220,233,223,199,107,58,196,179,16,90,185,101,98,200,145,96,97,111,151,235,101,21,129,113,132,27,252,103,153,195,37,203,184,60,28,140,121,10,246,7,203,147,52,236,142,158,116,64,48,35,252,157,214,254,115,120,144,149,239,229,125,79,18,50,155,75,181,48,148,41,4,210,3,72,236,137,134,82,43,188,220,137,44,128,220,191,85,44,83,81,142,15,24,46,95,148,54,48,56,200,55,61,138,72,237,181,115,187,17,19,146,143,93,128,34,28,117,189,167,71,73,18,237,161,12,26,107,29,176,48,226,214,128,9,228,160,89,14,91,216,132,68,103,235,143,149,100,92,132,246,111,175,79,132,103,33,139,57,107,247,220,133,74,219,92,35,46,211,178,63,163,179,31,49,159,21,3,214,29,35,171,41,73,224,76,222,148,177,114,193,11,39,183,220,2,178,83,213,12,61,125,172,4,244,174,188,166,91,133,106,249,195,176,158,58,197,141,220,207,200,163,58,134,171,206,29,147,186,225,177,101,143,211,66,149,96,238,142,153,178,94,71,186,173,89,135,138,142,181,118,236,164,73,200,139,25,134,86,68,161,181,163,91,28,18,106,234,164,150,54,73,36,187,98,245,77,145,166,121,47,240,135,242,92,146,182,162,63,14,59,6,84,103,181,198,201,25,73,18,189,190,184,176,39,1,55,198,50,105,106,176,94,7,205,139,103,86,113,109,110,154,248,209,69,82,236,229,65,55,210,218,94,55,113,125,144,229,193,221,78,83,180,106,146,221,233,250,148,40,222,61,209,5,18,104,230,221,162,137,74,191,163,216,40,24,211,158,121,67,70,238,142,16,65,219,93,93,45,11,214,206,98,180,34,217,165,121,175,153,172,24,154,184,235,45,157,129,130,69,9,184,25,197,53,119,186,115,3,243,205,206,144,134,90,24,82,218,26,45,118,101,202,175,138,190,173,38,230,154,97,26,180,232,79,149,212,96,35,121,244,157,56,93,8,36,82,134,25,208,209,215,55,220,50,132,111,80,29,234,167,125,11,85,240,15,213,75,85,69,38,104,249,121,206,44,167,34,23,137,52,68,156,216,12,17,16,181,89,115,79,33,198,100,47,238,74,104,146,198,83,78,32,45,220,34,153,211,220,107,100,220,9,181,78,45,142,42,111,192,157,230,129,47,90,186,246,55,50,210,170,160,141,108,195,111,52,153,172,138,81,163,168,180,207,216,141,180,15,238,6,133,143,221,186,19,91,200,96,48,156,40,251,99,210,70,157,29,52,12,79,12,15,146,244,204,214,167,37,113,2,133,123,204,202,139,199,119,128,81,1,67,205,171,189,77,141,200,83,223,1,214,233,12,58,85,123,30,37,58,84,178,145,7,181,231,210,52,70,168,116,170,134,76,46,150,242,190,158,155,68,250,150,207,193,201,24,58,23,119,143,231,153,236,69,139,169,123,36,70,207,204,224,102,181,24,252,51,119,229,92,208,96,200,108,92,89,117,194,104,73,116,100,42,243,116,203,185,46,119,222,2,217,83,121,157,127,93,98,164,203,250,188,244,68,71,3,230,80,248,43,229,52,230,82,99,222,245,188,188,65,174,236,191,163,145,179,172,87,61,142,21,167,242,186,0,159,77,228,81,22,0,31,185,8,231,53,109,246,24,160,230,2,234,135,117,192,18,162,143,42,136,112,10,248,146,87,51,236,13,181,235,118,191,164,206,58,87,200,143,170,77,206,171,178,87,66,33,20,88,124,232,78,48,103,177,251,230,220,247,119,254,203,121,153,10,222,225,54,177,218,135,119,52,218,215,43,232,199,92,192,197,95,40,234,76,195,51,199,70,72,103,220,87,249,252,124,86,254,218,215,151,210,131,132,13,234,249,192,155,28,42,125,242,251,244,85,167,104,104,123,192,188,104,61,93,41,96,45,132,198,118,68,169,138,150,117,103,13,79,131,125,27,205,30,111,0,71,41,197,172,192,101,95,29,199,86,69,11,36,133,71,161,69,15,67,8,119,210,68,108,34,220,34,49,51,11,110,107,51,74,13,164,227,164,148,180,121,162,5,36,174,28,43,0,203,165,111,111,148,17,44,7,63,249,155,128,118,187,47,27,204,13,61,200,251,29,194,155,63,29,226,179,252,110,34,149,43,31,42,49,250,110,235,240,140,193,102,37,40,84,156,48,227,121,119,75,252,109,249,8,205,112,107,6,224,36,151,231,213,185,162,234,206,161,114,17,244,202,231,253,21,4,124,36,170,192,236,138,18,194,78,50,211,108,134,158,18,245,217,138,105,205,225,23,223,131,148,146,163,36,80,64,212,45,51,14,85,47,72,79,133,63,148,54,175,15,212,184,64,17,224,193,111,204,35,21,246,139,126,251,39,208,95,252,254,70,141,205,118,131,123,21,57,57,34,76,227,245,18,122,254,35,29,236,111,42,96,187,161,50,168,184,145,40,165,203,39,34,47,152,189,68,215,134,255,61,205,26,27,86,8,147,238,151,141,162,16,210,142,155,93,58,140,207,120,28,138,82,223,88,8,204,27,239,7,73,33,14,42,183,80,132,36,130,50,249,69,186,142,151,116,148,245,182,43,22,137,64,68,51,52,102,100,217,159,67,84,159,155,117,147,42,100,180,129,240,108,103,146,206,90,255,125,138,93,115,17,171,25,147,86,135,58,112,32,124,19,43,33,247,72,139,181,224,109,54,46,84,198,9,149,230,88,58,39,208,235,45,244,166,82,232,145,193,44,61,254,179,251,236,117,159,184,176,204,243,178,232,101,202,38,199,125,222,147,212,239,129,131,242,105,107,249,172,110,179,215,106,179,46,69,129,104,179,249,34,131,191,204,117,93,15,74,90,76,136,180,85,26,24,98,235,91,141,43,22,129,58,117,181,15,48,60,12,214,36,149,53,26,53,198,165,205,42,192,216,254,102,249,209,55,2,95,43,251,122,27,173,203,209,202,28,19,123,212,167,1,200,52,166,204,111,178,91,182,67,255,186,18,149,223,112,91,79,242,230,211,17,216,236,208,90,3,236,212,94,178,248,217,159,94,6,104,65,71,197,225,196,3,136,82,67,219,215,176,73,20,42,81,131,47,193,145,1,25,201,216,26,215,33,201,125,247,68,156,45,134,105,196,130,188,217,148,120,233,48,58,11,68,30,173,164,109,190,96,2,1,149,119,176,104,165,15,202,135,139,72,196,155,12,63,92,145,176,32,178,58,73,194,48,29,59,42,241,155,212,19,35,223,107,158,98,101,24,91,252,4,253,156,196,247,135,108,240,18,237,150,43,242,41,136,184,91,45,85,247,235,43,24,166,134,117,27,73,242,58,72,99,63,110,176,219,186,63,138,109,125,219,40,58,146,59,181,122,141,193,43,6,168,48,64,61,242,70,37,20,105,18,56,197,206,149,203,210,100,31,37,93,187,21,101,156,34,28,29,130,203,153,43,144,106,0,118,93,137,79,206,91,32,196,52,80,231,42,79,151,238,1,100,107,219,230,202,157,110,239,117,220,56,58,70,158,255,222,3,203,56,181,2,105,218,20,83,201,102,35,99,15,212,151,148,46,8,120,113,20,50,149,223,243,58,243,122,121,73,87,73,125,131,197,74,221,31,183,232,222,177,220,27,34,92,187,180,6,171,222,139,1,52,134,134,42,86,35,172,60,71,117,239,236,86,249,140,206,191,110,230,42,235,252,178,91,150,235,104,91,232,111,201,37,196,20,51,99,75,20,200,74,146,87,43,126,181,40,231,48,93,92,229,60,65,156,253,184,196,125,193,252,177,120,124,218,144,105,111,208,103,115,122,137,221,96,112,121,80,198,109,190,111,244,209,75,249,88,5,105,221,153,140,80,204,116,247,59,225,64,129,37,97,131,189,9,228,73,12,243,124,180,246,106,209,63,236,96,125,190,113,162,73,240,126,133,149,113,1,15,49,37,77,59,245,170,48,160,21,118,151,139,249,47,47,160,82,103,75,98,195,238,176,84,187,26,103,9,214,102,186,92,171,16,161,189,137,239,158,110,172,12,231,211,164,78,155,144,182,93,216,189,76,18,107,160,255,52,251,194,117,27,159,147,31,44,33,203,58,250,10,227,61,26,36,153,3,146,71,186,81,154,13,172,215,118,92,109,166,159,235,206,72,250,74,107,61,194,110,27,102,194,238,42,252,144,162,73,111,116,254,236,217,208,107,222,3,40,244,80,42,216,100,4,203,31,128,218,125,250,165,215,149,228,128,17,196,70,210,139,30,121,110,23,212,77,205,185,194,224,201,176,36,197,45,69,138,155,135,17,23,214,36,87,136,251,104,205,196,67,204,77,159,118,155,182,75,155,36,29,173,119,78,131,34,175,166,63,222,142,32,4,87,181,230,17,235,55,127,172,227,180,44,150,182,156,35,157,54,237,79,80,26,53,66,159,30,171,30,219,193,111,80,225,143,152,212,154,221,97,241,126,141,208,100,89,240,111,66,118,61,167,182,52,223,54,156,37,106,255,4,80,232,62,74,95,52,129,38,73,46,218,167,14,241,157,254,238,198,172,125,47,221,208,6,206,200,221,213,36,91,197,248,195,116,246,235,48,174,209,56,229,40,101,227,33,175,200,208,196,45,133,134,20,190,36,145,150,167,30,246,254,30,9,196,173,167,80,136,32,236,116,60,171,146,136,176,59,44,22,122,225,51,70,160,157,186,16,92,3,198,219,179,148,211,54,13,55,228,202,181,182,131,121,3,190,55,46,167,155,7,178,65,149,224,36,170,152,58,86,238,126,92,158,52,155,42,83,207,160,50,41,83,228,24,102,83,51,99,90,151,128,189,147,108,0,228,254,169,133,134,131,58,154,19,185,97,49,12,131,180,135,228,189,49,137,112,143,173,118,183,160,80,70,136,35,88,175,208,180,203,84,131,134,26,57,119,109,152,113,169,184,65,173,21,73,77,129,93,176,248,242,238,131,76,255,13,154,149,126,144,125,150,179,68,33,69,1,202,28,147,97,219,61,76,93,158,240,117,149,85,227,9,27,17,211,123,222,110,252,156,86,30,166,20,184,233,76,88,11,250,191,120,190,242,236,67,31,35,28,206,180,228,201,97,205,134,228,108,213,129,251,151,178,179,55,109,45,218,253,3,163,0,240,65,188,221,64,68,161,169,5,235,101,61,76,88,126,154,191,243,113,56,33,123,82,24,170,90,250,29,31,78,122,35,104,166,59,218,234,179,183,61,12,252,161,240,228,175,182,84,61,229,217,150,161,68,61,63,49,240,102,216,146,157,16,160,221,139,157,177,213,6,214,28,6,142,138,211,216,25,207,45,154,143,5,214,238,244,218,57,129,137,92,163,185,161,178,123,71,51,92,115,184,100,186,53,97,76,246,17,219,164,46,36,132,91,120,198,187,132,89,25,150,27,63,59,92,6,175,23,75,148,215,132,101,214,182,226,86,152,109,37,35,170,209,251,23,96,127,46,242,156,33,168,144,97,151,50,117,80,197,215,19,124,125,201,4,45,49,121,14,67,3,129,125,166,42,175,236,147,12,245,188,242,192,98,16,121,139,238,11,166,78,243,237,67,195,0,210,35,236,250,225,93,169,232,74,85,240,155,157,109,225,198,129,27,54,161,79,187,2,152,52,20,42,91,103,180,115,148,59,31,35,192,5,71,0,186,50,172,104,85,210,39,128,47,26,47,214,208,235,46,11,163,32,247,49,109,174,38,103,6,195,136,77,94,236,100,192,37,30,175,27,22,1,162,218,227,24,137,8,6,197,132,181,104,178,139,114,18,31,177,116,124,118,131,201,42,44,122,100,2,182,106,221,7,190,207,92,22,234,5,192,54,38,249,85,198,67,82,64,57,78,66,9,198,107,84,53,58,103,113,165,96,75,153,237,36,117,20,60,207,115,6,126,235,162,6,206,24,129,74,25,152,193,169,62,245,82,110,228,99,216,171,39,206,140,22,249,190,166,205,39,87,133,229,46,198,69,114,45,64,111,194,80,97,252,45,162,208,42,255,105,36,2,203,245,87,78,247,221,168,39,245,242,64,24,32,0,151,34,131,190,230,138,133,7,197,138,121,1,138,166,29,33,104,129,40,216,134,250,212,1,190,42,37,129,205,132,26,135,225,9,32,132,221,97,26,149,252,200,16,244,221,16,2,47,204,61,39,166,39,146,79,38,215,197,12,64,64,4,9,164,85,131,156,196,70,36,52,97,193,2,32,164,99,131,30,67,22,233,32,39,251,117,30,44,31,160,33,55,80,21,229,243,122,88,46,136,35,20,166,231,156,95,116,9,109,24,173,254,116,62,40,173,64,14,244,4,128,58,157,122,152,177,15,67,188,157,158,18,47,151,8,169,158,54,17,108,220,75,1,153,75,173,12,179,18,97,205,111,71,4,211,104,92,53,62,102,251,151,247,180,68,1,97,136,42,159,78,62,19,156,46,2,148,121,65,239,35,196,174,55,210,189,233,10,32,170,145,51,66,3,221,72,1,158,176,245,6,169,147,1,81,220,163,122,106,174,8,51,175,99,30,195,137,246,132,254,77,159,174,157,217,124,199,76,13,75,223,242,49,193,23,122,29,11,124,125,35,173,51,203,235,83,100,96,222,11,183,104,30,66,15,88,153,60,51,106,188,52,231,235,121,133,37,121,190,185,245,61,126,120,218,140,54,129,148,57,95,113,215,167,112,178,11,53,28,203,196,3,67,50,197,141,128,177,244,158,70,26,197,154,69,103,41,135,127,134,126,236,88,107,53,70,96,182,137,14,65,98,78,161,126,163,89,83,72,100,80,147,123,175,162,93,63,156,64,87,97,223,207,29,205,76,174,94,181,248,77,0,242,108,168,203,88,176,214,30,202,201,160,56,94,15,95,231,145,122,212,41,234,22,141,193,214,120,169,196,112,137,40,201,174,57,60,33,223,190,50,230,173,125,135,101,22,152,126,149,4,216,128,167,59,78,186,177,168,235,156,166,126,15,80,5,253,203,24,165,107,136,14,122,161,73,185,173,238,110,12,159,18,95,190,252,205,211,174,137,21,107,238,207,150,198,253,37,236,36,75,213,155,166,6,124,209,194,207,195,56,241,45,182,45,153,212,173,201,161,106,147,143,43,203,131,78,31,58,198,29,219,160,134,150,254,178,13,151,230,154,48,179,42,162,107,123,201,165,42,127,18,139,108,73,29,68,27,104,38,151,39,209,22,201,52,169,241,138,51,240,178,77,136,3,235,133,65,246,73,23,99,143,246,185,184,27,55,16,0,125,95,67,39,110,58,6,220,205,82,82,116,200,33,231,168,138,53,84,133,154,163,72,153,66,227,203,27,108,107,239,112,154,199,102,186,43,201,8,92,16,216,9,174,57,97,144,30,234,130,183,15,199,182,110,222,232,151,186,136,210,147,54,14,232,7,252,177,31,198,219,14,31,107,216,129,115,170,166,3,10,102,186,188,156,0,169,117,85,38,186,83,160,216,51,87,86,47,73,246,2,129,167,200,219,64,168,242,148,183,32,53,209,62,164,145,77,98,34,231,201,15,254,17,129,134,27,180,208,116,128,98,205,114,143,53,203,141,68,53,171,163,148,67,144,82,33,80,46,90,149,41,32,147,21,2,182,55,234,36,58,66,187,181,210,94,187,141,172,181,233,189,114,30,33,150,175,219,106,222,251,109,177,95,7,166,16,187,22,7,221,77,1,197,115,22,212,31,126,57,15,204,106,74,23,76,186,243,7,4,176,63,87,222,183,249,107,64,172,146,93,156,181,244,126,178,155,128,113,140,187,189,55,171,56,80,54,140,85,121,221,102,82,81,126,213,68,49,128,122,134,19,60,32,200,216,56,80,129,204,215,228,90,217,127,186,1,90,226,180,89,70,126,212,49,132,226,166,222,71,109,9,59,253,26,171,215,248,6,44,61,40,153,220,23,74,104,211,43,160,33,253,201,229,12,242,46,32,70,221,196,80,105,151,34,237,250,123,33,17,241,17,213,238,177,26,52,199,170,191,237,71,232,42,193,141,29,166,128,2,25,31,147,24,48,170,226,148,199,42,242,72,29,30,68,123,135,112,22,68,105,141,254,109,48,3,18,165,23,236,44,46,200,147,21,47,99,22,119,108,160,138,26,83,24,231,179,106,16,159,69,240,29,76,54,95,4,115,127,246,40,71,107,154,3,246,148,32,207,6,104,139,240,115,49,133,2,99,158,70,134,173,21,132,21,104,147,182,198,17,28,166,17,26,41,191,133,18,60,173,14,29,60,190,205,134,195,207,64,113,9,47,100,234,123,224,42,151,59,206,43,248,28,235,95,249,97,120,233,9,63,252,89,107,103,198,79,21,48,115,139,114,107,50,137,50,132,26,233,152,196,124,39,173,198,237,155,155,182,97,22,135,118,228,145,232,218,28,114,182,207,7,185,23,238,113,20,192,11,143,200,27,13,144,246,197,39,11,205,75,31,136,35,23,43,191,95,109,84,34,175,204,247,245,143,5,227,174,206,132,136,252,95,164,86,208,219,5,164,243,86,191,54,232,62,223,0,124,148,168,238,249,49,248,37,48,113,99,195,234,146,224,36,46,114,250,171,214,125,33,161,139,114,149,32,215,4,62,4,174,113,16,108,70,12,99,195,203,108,13,87,180,207,98,94,205,87,32,218,188,70,1,7,35,109,71,21,99,233,36,58,116,217,249,254,66,239,21,27,118,171,159,76,109,242,255,28,116,90,30,136,147,8,21,64,36,189,200,99,222,207,227,146,30,34,233,152,128,201,208,104,245,171,203,25,197,234,247,216,226,175,82,28,248,141,127,99,69,23,69,27,220,141,49,240,102,250,150,167,222,37,7,236,49,250,34,208,29,22,110,64,245,250,33,52,237,27,107,28,249,99,35,250,128,42,46,212,112,68,35,24,144,212,24,80,105,140,25,207,239,209,53,241,11,74,140,117,248,141,152,250,15,101,154,121,135,183,43,46,3,119,140,130,236,95,218,186,249,249,146,46,241,121,185,225,220,225,81,149,228,112,182,229,222,125,31,221,247,169,157,165,142,77,133,164,255,144,183,192,139,109,153,155,224,91,136,167,97,55,128,64,147,151,185,125,176,38,148,149,132,134,241,237,152,170,184,202,144,65,254,240,134,164,0,85,227,71,97,167,92,118,9,149,228,221,148,211,90,67,25,145,216,231,230,59,45,204,105,205,208,227,246,61,221,220,157,255,208,77,98,78,196,81,172,231,26,203,252,97,195,143,126,166,189,184,137,13,102,49,190,18,122,205,61,247,53,128,22,58,139,211,1,186,184,139,167,157,89,50,4,151,48,146,61,194,23,22,89,10,63,197,58,6,122,26,87,185,249,38,54,160,57,227,120,226,197,152,113,108,179,141,218,198,214,6,165,243,47,176,99,23,34,22,253,231,103,195,219,138,67,69,96,107,137,114,194,204,71,156,73,126,178,224,78,127,61,92,255,218,180,97,122,66,154,82,175,132,108,1,232,90,7,129,193,152,198,195,130,93,58,179,222,75,30,153,178,192,115,137,182,205,247,113,19,69,112,182,183,8,56,112,82,217,47,17,246,231,54,110,150,219,98,95,48,216,65,107,58,219,222,80,95,171,27,221,117,34,178,108,157,118,39,127,80,227,202,110,53,114,49,44,247,225,66,23,7,116,16,248,203,87,23,111,219,190,159,250,29,87,155,142,72,220,56,219,160,168,2,250,33,211,60,178,115,192,211,166,99,42,163,115,243,213,207,165,171,100,114,25,66,220,103,157,171,210,193,118,166,170,219,109,205,222,221,111,142,163,208,114,61,40,189,80,197,146,171,42,83,131,78,34,74,11,51,192,217,146,23,31,200,45,45,44,196,158,137,215,189,54,6,46,192,188,218,103,244,144,41,97,158,208,254,118,179,57,65,187,162,231,15,47,100,206,6,246,118,26,220,86,96,198,160,171,178,198,1,209,168,51,24,22,169,29,224,197,158,242,87,29,202,20,201,244,217,242,72,222,195,97,61,255,251,107,109,14,211,176,61,2,238,145,108,150,141,175,18,186,237,11,112,58,232,184,165,49,175,64,164,146,103,109,201,205,242,148,235,153,118,98,45,3,241,164,56,86,167,47,44,222,245,185,213,42,74,81,42,130,255,59,102,246,75,24,32,224,231,124,251,233,18,0,10,220,132,24,230,98,45,245,129,130,18,204,68,243,65,145,7,167,207,188,190,107,135,106,177,221,28,46,140,135,88,199,172,107,189,21,14,111,134,123,32,250,184,36,52,29,133,46,41,74,158,218,30,46,215,213,101,50,223,218,148,234,21,64,90,212,161,200,222,43,20,138,54,42,144,229,205,35,39,149,119,0,158,224,78,13,150,217,27,223,114,32,9,55,222,91,142,237,190,182,156,6,159,185,38,140,144,33,16,84,60,113,32,176,171,176,40,79,198,28,14,90,223,181,19,162,223,139,41,24,8,244,229,23,2,12,151,98,191,166,194,8,244,119,12,106,148,90,172,21,105,84,177,134,180,80,1,21,185,102,245,142,179,53,160,27,110,163,233,137,130,240,188,140,217,123,34,49,209,217,84,252,197,117,194,82,191,233,81,52,203,142,77,82,237,34,65,51,195,1,132,150,35,173,165,200,93,37,121,124,3,60,10,184,152,245,49,46,52,160,238,139,158,214,232,112,38,32,68,21,141,187,16,249,41,127,10,238,253,27,37,52,176,235,59,21,226,193,143,29,66,150,62,164,225,211,50,234,22,144,142,116,239,204,2,157,27,32,50,109,131,240,139,155,225,248,240,79,41,240,229,181,164,135,75,83,47,51,117,12,97,96,77,123,201,102,209,113,224,133,231,95,184,191,197,125,172,173,90,125,172,11,81,212,10,175,153,124,164,244,27,7,20,133,69,153,153,82,20,83,22,174,229,212,20,88,215,175,108,219,133,185,73,30,28,88,200,85,1,163,64,213,80,20,99,17,4,109,158,46,148,34,189,19,19,107,125,127,101,95,158,44,25,215,37,176,105,86,67,205,100,95,19,211,163,137,28,146,44,91,102,50,219,67,233,139,147,11,111,82,247,148,68,87,232,6,175,31,157,254,72,69,173,42,164,3,206,147,184,201,216,25,101,152,142,58,190,251,99,236,160,23,195,194,105,103,62,246,192,12,226,134,117,97,185,97,154,23,248,95,106,111,10,159,68,176,245,231,69,115,180,102,147,123,237,90,19,64,3,69,68,31,39,202,65,106,167,134,6,97,49,227,168,73,198,67,253,44,50,23,10,194,9,245,158,61,146,111,191,184,35,246,50,63,230,186,212,225,239,244,56,76,80,176,138,150,159,74,39,70,122,110,149,168,24,60,53,16,13,228,148,117,192,12,154,118,32,14,93,166,226,50,93,215,130,174,149,160,231,39,192,63,34,158,240,13,77,33,157,210,30,155,22,116,207,183,30,130,23,209,195,173,81,31,235,204,4,203,232,45,160,191,50,220,226,180,225,50,160,78,80,148,218,94,63,72,213,189,64,157,221,233,248,251,168,47,138,23,191,203,43,191,98,39,94,11,15,193,183,223,12,146,40,22,103,223,140,233,63,146,26,95,252,205,162,219,245,199,31,194,83,178,10,69,160,80,107,33,101,216,246,239,161,65,107,232,24,162,2,196,235,203,32,175,57,67,11,201,205,202,100,99,116,95,210,200,205,132,252,51,201,24,192,47,28,36,57,102,201,97,217,173,63,224,199,21,116,221,169,121,247,102,66,111,107,62,107,1,215,98,184,5,8,3,163,125,156,70,63,160,20,124,202,93,59,162,202,149,2,182,84,226,213,183,151,52,205,162,89,234,129,180,158,197,227,142,11,121,152,169,187,192,84,45,80,244,222,22,55,225,82,106,42,15,201,87,217,185,37,137,187,170,34,84,198,109,4,124,35,138,220,166,164,189,59,147,173,164,116,96,56,191,55,119,184,163,92,110,65,255,122,20,176,56,15,115,108,91,185,177,22,62,10,97,78,225,184,20,20,20,1,110,73,241,54,180,45,107,221,171,104,34,51,255,245,192,146,169,222,244,113,130,79,204,125,84,225,104,148,86,49,117,204,64,196,86,148,4,147,164,34,161,200,67,146,126,73,28,172,213,185,233,91,218,22,27,61,16,42,126,138,153,202,28,227,34,216,177,222,230,153,84,137,45,3,150,168,106,184,74,88,58,166,239,188,120,176,90,95,30,176,224,254,35,117,138,72,54,106,198,213,92,82,182,101,111,150,197,2,101,237,228,189,61,206,213,40,65,252,233,26,57,88,48,253,45,135,242,11,55,93,35,46,193,129,163,22,159,208,106,93,223,249,146,229,65,235,153,95,111,117,90,83,49,32,173,17,41,233,175,70,62,140,176,73,3,34,117,163,187,171,223,15,46,98,183,58,125,166,207,53,54,117,178,96,60,11,3,15,98,252,8,123,243,16,221,222,22,231,164,23,0,68,19,85,128,229,132,24,19,68,93,90,134,246,24,147,111,242,25,74,120,3,203,72,47,131,33,116,247,130,139,247,14,151,249,106,33,234,205,137,114,155,245,99,59,157,201,186,31,141,111,112,25,113,248,170,29,232,16,44,205,222,51,28,22,114,199,9,175,132,198,214,109,38,95,14,198,240,225,31,63,215,94,27,238,148,253,229,51,220,159,24,113,174,245,90,19,155,121,150,28,7,58,140,12,170,166,44,245,120,85,84,106,63,30,107,158,37,220,25,180,196,222,37,23,176,188,250,154,144,112,36,161,54,169,76,63,251,100,1,224,140,82,215,1,207,4,170,87,125,196,41,9,90,178,152,237,152,172,130,220,147,231,43,111,50,33,191,16,141,59,114,219,131,220,175,31,166,239,139,180,202,221,162,254,145,77,137,27,48,201,203,123,99,0,207,241,162,0,127,160,202,248,204,158,74,0,106,72,217,134,171,137,17,25,219,209,176,235,91,59,152,6,26,182,141,73,52,10,25,186,59,133,131,69,183,228,25,227,177,56,240,120,135,150,27,135,17,53,64,116,134,184,189,74,57,129,26,37,59,225,98,0,111,12,202,1,60,153,235,183,63,124,38,255,146,182,188,235,216,106,37,57,250,94,66,193,249,69,199,124,102,202,36,116,247,88,250,74,250,25,197,109,247,169,201,3,227,222,36,37,4,115,170,100,95,96,41,164,39,118,164,111,110,211,55,197,133,146,134,199,76,76,60,36,185,214,159,69,218,197,70,174,138,143,178,11,13,121,205,125,38,47,234,20,90,178,166,123,38,122,45,46,65,200,94,192,217,213,124,27,89,240,191,199,75,42,29,195,122,179,35,150,172,255,126,59,0,159,38,35,24,55,39,161,160,210,69,2,253,2,116,136,185,53,227,9,185,43,82,179,247,249,241,234,231,14,79,92,232,128,89,218,91,27,100,90,148,18,203,35,40,250,12,174,175,45,72,114,111,227,8,136,182,12,235,113,160,194,211,110,76,91,165,117,147,98,52,109,232,49,65,80,54,141,47,238,44,125,78,100,179,74,112,248,95,23,38,152,178,120,246,55,32,249,168,147,131,203,214,126,63,101,47,132,139,220,110,38,242,177,161,91,177,53,52,45,77,150,230,188,176,129,41,91,120,61,191,109,146,188,57,52,8,159,18,110,138,191,14,32,71,239,41,127,209,129,32,235,68,80,8,14,89,35,78,102,183,62,178,171,251,44,116,97,57,124,23,161,196,172,123,32,187,152,253,176,73,183,55,111,144,45,51,173,109,191,232,6,2,243,222,33,93,242,255,138,12,141,213,54,210,206,132,11,230,62,33,166,226,32,59,1,145,35,155,115,199,126,238,90,152,142,149,107,226,188,102,124,159,200,68,140,141,150,232,219,13,171,2,142,128,113,237,71,228,225,94,236,58,135,20,215,38,201,102,159,173,56,213,5,108,177,16,194,206,45,199,11,236,24,93,235,120,6,62,207,253,197,78,148,193,50,61,237,211,61,134,56,73,12,60,171,169,133,139,46,91,107,57,143,118,17,162,226,144,17,89,62,162,241,99,191,151,228,153,4,130,4,209,85,224,100,135,135,4,108,195,82,161,98,6,156,4,131,75,235,3,123,1,38,198,153,76,73,116,118,169,157,221,107,170,119,140,163,33,170,222,174,56,116,128,167,55,214,208,210,158,49,26,94,218,174,209,92,119,135,106,84,215,100,17,142,119,186,94,90,223,149,55,157,253,218,168,166,255,167,59,54,65,103,169,230,9,85,123,101,87,97,113,248,93,23,177,20,113,254,134,6,61,6,237,138,188,144,55,86,79,204,166,218,132,106,58,229,161,116,180,106,10,165,250,160,8,205,132,29,145,65,95,17,132,236,155,51,146,38,184,167,238,174,146,61,207,180,43,187,68,205,141,225,216,229,77,176,163,126,183,16,190,26,92,188,190,117,32,40,114,192,34,30,237,68,232,82,62,81,238,62,199,241,140,233,203,82,134,54,51,20,135,82,218,92,151,60,23,197,144,61,104,177,71,43,187,233,252,137,130,180,102,71,24,167,210,1,198,122,214,228,127,18,184,89,101,40,61,63,97,203,50,164,29,249,18,53,250,143,47,63,141,183,10,26,254,26,231,251,130,194,248,229,199,184,147,253,89,195,90,92,183,122,83,18,77,11,224,107,249,146,156,69,126,65,30,100,63,139,235,250,153,201,131,155,33,206,89,234,236,50,229,46,248,236,159,20,38,82,99,161,9,201,53,130,127,168,8,99,13,14,25,95,73,44,108,147,7,9,9,89,66,34,136,238,82,25,83,254,28,8,132,252,185,20,190,114,135,53,140,32,40,211,63,6,66,12,193,144,112,196,179,101,234,152,97,194,141,43,111,86,96,174,27,3,158,209,235,190,155,230,252,145,101,24,50,252,115,49,13,158,214,199,182,254,20,173,204,111,179,95,44,234,134,47,112,98,191,90,144,183,135,230,135,57,180,66,157,20,46,238,143,45,216,111,98,50,216,218,45,223,154,32,120,216,241,177,89,96,31,133,35,145,35,255,173,10,172,70,115,153,60,183,72,161,179,105,243,185,22,57,34,186,149,185,153,215,25,53,157,41,149,8,249,217,198,122,231,2,111,194,156,112,104,122,133,41,96,181,176,239,127,179,47,118,209,37,106,229,156,27,235,120,237,234,196,109,177,218,160,166,240,195,128,21,189,196,101,78,158,199,156,254,2,210,22,185,224,206,153,69,115,195,12,34,196,242,88,124,180,77,114,77,187,137,182,97,147,25,177,145,166,128,59,65,57,131,192,153,241,238,122,214,158,101,3,48,193,176,142,206,141,122,50,152,155,47,104,50,101,76,238,221,132,38,43,199,98,100,134,210,139,56,232,176,12,91,245,148,151,253,25,171,47,14,211,123,53,66,125,236,228,236,220,126,101,109,38,68,59,3,158,133,124,90,65,80,47,248,227,165,1,219,10,189,78,200,62,142,171,127,19,105,150,202,137,200,156,33,95,66,215,210,36,7,248,131,208,186,175,16,42,214,45,98,211,220,254,49,174,210,16,82,25,103,25,198,41,117,245,203,1,113,207,70,221,255,71,30,80,250,221,235,10,122,107,122,224,126,124,224,65,45,37,139,253,146,100,69,82,165,57,217,26,84,12,245,222,158,48,205,52,248,2,10,130,9,132,109,66,84,16,212,22,15,171,162,214,4,5,217,218,15,132,35,152,82,198,53,211,154,144,32,237,240,91,11,120,228,47,89,191,250,216,121,70,118,132,47,137,44,11,119,119,142,226,112,182,82,223,133,4,174,207,63,89,181,213,156,8,182,85,16,230,57,17,8,118,46,60,226,92,184,22,44,171,139,136,188,177,0,125,212,8,131,230,103,11,230,60,208,102,150,198,161,215,191,132,202,255,70,215,46,197,141,149,82,139,76,43,74,195,226,35,15,122,139,75,141,69,162,192,110,123,187,102,47,59,192,210,175,127,172,1,54,83,88,43,76,214,38,12,247,166,12,30,168,102,171,223,53,179,10,82,219,83,184,104,45,128,240,2,178,235,170,200,155,24,214,139,86,151,168,212,50,68,207,199,250,188,10,44,212,74,125,142,125,83,225,6,215,17,145,150,177,206,10,156,3,14,66,122,235,221,137,208,39,78,51,232,173,153,180,38,98,128,45,165,209,148,189,104,111,24,166,71,126,211,93,212,230,232,41,192,161,133,97,192,237,12,21,26,123,18,132,188,66,226,178,109,136,253,21,33,197,51,220,193,109,79,31,137,218,175,3,100,98,154,209,152,66,101,131,215,120,147,202,56,223,99,60,149,10,10,197,36,240,187,99,55,193,131,93,72,48,188,219,45,108,186,27,18,65,152,62,134,101,190,141,7,63,7,5,141,111,184,64,242,113,197,203,51,137,155,119,11,41,200,152,177,115,179,116,142,233,179,27,189,120,22,241,89,190,74,81,165,127,177,91,227,50,199,141,153,63,215,124,143,31,252,186,42,43,83,105,150,192,248,216,195,57,80,64,28,221,223,56,53,97,166,186,46,83,213,68,164,17,165,242,107,72,97,73,206,186,204,236,182,206,206,121,190,188,130,18,232,143,237,30,205,145,167,100,166,92,162,73,67,95,146,100,190,126,126,204,205,128,41,186,35,245,101,217,157,94,40,16,148,233,116,219,35,186,69,68,74,196,131,7,224,224,73,154,81,26,133,98,113,236,202,167,5,68,164,27,197,163,141,178,13,73,70,24,202,241,157,191,116,234,54,199,220,255,200,77,96,149,110,107,113,13,57,101,34,70,137,223,79,79,2,40,0,255,130,70,227,7,122,73,60,13,159,88,104,118,108,248,68,251,166,149,181,95,123,10,89,247,217,122,31,92,28,42,40,203,166,82,244,169,22,59,48,199,33,173,89,8,114,191,69,16,146,101,138,60,56,231,227,137,35,155,87,220,143,4,228,64,158,109,93,235,111,160,164,50,148,220,0,108,101,187,255,131,252,218,23,7,153,12,250,174,7,89,197,19,242,47,55,62,23,175,137,153,205,109,124,145,144,82,84,87,13,127,25,157,36,91,17,65,14,72,159,59,6,81,202,64,60,182,235,47,17,68,31,29,15,180,233,59,171,184,100,132,131,217,222,56,38,46,224,142,7,8,114,210,191,60,99,144,192,131,117,228,224,215,130,232,205,151,110,232,237,206,123,229,54,185,20,184,166,14,69,96,68,99,183,211,199,144,252,173,3,154,210,210,139,173,223,42,94,100,52,82,6,21,85,12,136,10,141,90,207,209,126,40,29,48,248,46,154,167,200,215,201,118,37,229,212,2,232,16,18,203,181,157,243,1,28,53,24,197,182,120,176,9,44,227,255,173,186,117,165,228,182,50,47,173,142,109,231,142,0,146,168,87,34,166,230,232,103,114,235,218,5,241,185,80,52,237,190,177,115,190,63,96,60,250,39,121,140,74,195,61,224,218,32,160,244,228,80,168,11,34,162,222,130,64,53,117,156,230,68,77,185,217,224,207,152,216,200,227,198,231,182,213,161,72,20,36,10,205,66,150,129,210,127,90,235,49,89,65,125,223,172,222,216,88,42,142,194,100,136,91,208,186,113,77,49,101,169,2,145,155,133,196,130,107,20,27,249,40,128,154,205,108,202,210,187,189,50,43,15,115,132,151,211,137,105,240,41,49,252,61,90,191,227,245,148,227,7,107,104,166,20,219,20,254,95,242,65,184,71,253,129,242,93,193,35,87,77,84,179,1,141,175,106,128,91,101,205,95,66,198,157,227,53,151,65,217,78,203,131,112,152,122,41,112,80,128,119,100,218,54,9,192,81,117,169,160,222,180,144,163,69,130,191,243,132,122,247,136,147,117,70,122,150,96,115,83,248,122,31,228,255,100,109,138,214,15,143,101,64,245,206,129,81,32,128,115,87,153,239,139,172,166,130,90,82,193,5,144,81,136,59,164,51,72,31,169,24,144,254,98,95,125,39,252,23,33,73,107,196,31,157,236,66,96,170,104,245,68,148,244,101,233,142,108,39,233,151,227,90,134,236,105,233,156,153,252,112,129,129,26,152,248,152,39,114,166,128,57,45,237,57,29,110,108,173,58,225,124,93,26,58,46,120,161,73,179,232,167,207,184,129,126,104,11,89,115,201,148,137,136,244,13,94,70,194,114,103,155,16,251,89,166,36,23,31,133,68,234,130,233,108,239,21,146,71,185,43,76,36,147,41,109,73,43,35,90,165,130,91,85,74,178,216,203,150,130,240,85,55,118,222,238,185,72,5,47,188,191,245,75,190,89,22,36,54,209,31,180,179,187,177,212,133,220,60,238,148,184,211,35,135,76,1,140,145,152,169,208,19,99,143,114,237,88,202,214,38,206,142,66,188,126,210,144,60,17,195,70,74,54,179,239,209,103,201,57,66,231,126,235,173,81,162,243,148,198,12,2,42,4,204,231,159,117,85,134,67,185,250,227,195,95,151,196,74,194,240,239,66,161,225,82,250,204,93,52,153,159,54,207,65,115,5,164,44,38,27,173,23,235,200,252,107,66,44,179,22,199,127,226,40,105,167,113,168,181,227,116,198,8,249,240,173,62,13,98,93,56,28,250,168,151,181,92,35,159,40,226,45,174,206,86,107,155,206,207,0,145,221,90,150,242,199,12,249,32,56,214,170,202,143,66,238,224,177,147,101,242,182,111,150,165,14,130,196,42,158,64,190,156,12,102,102,116,142,79,141,89,1,122,178,126,240,239,92,78,146,131,107,99,240,115,131,245,132,159,211,110,244,99,139,190,121,90,136,121,5,85,184,203,114,233,89,237,189,195,240,185,72,111,222,235,176,219,116,86,249,14,166,229,116,71,225,12,107,186,22,63,201,140,226,157,174,147,207,116,231,69,28,2,80,236,33,197,177,114,43,44,239,254,183,102,212,164,167,111,204,204,41,69,255,60,88,34,20,98,85,77,139,249,90,153,195,121,37,173,188,235,185,139,206,231,246,43,224,153,162,119,205,218,73,186,15,129,65,128,44,191,196,191,17,138,250,67,96,7,93,239,121,253,182,149,123,196,52,116,102,214,155,199,107,5,54,209,82,197,99,230,48,7,193,83,66,206,19,125,19,219,65,246,47,93,155,102,23,253,225,1,32,6,143,84,85,120,192,77,210,157,219,46,36,81,218,232,64,221,150,228,52,87,97,14,250,159,45,195,90,235,153,43,241,132,216,201,128,135,64,172,186,135,151,19,48,159,128,17,106,182,169,141,217,16,33,22,127,75,91,93,161,100,248,34,161,5,34,11,186,4,240,186,255,184,49,221,239,166,47,166,59,196,193,227,101,175,2,100,84,149,51,171,118,168,13,214,219,57,147,211,250,181,84,127,170,33,205,6,194,52,27,190,254,109,223,250,188,49,126,219,254,171,166,183,23,13,233,244,24,233,170,45,129,187,255,125,192,211,248,1,188,7,1,31,167,119,105,204,81,233,72,24,152,193,122,250,118,23,140,167,169,223,183,51,70,54,82,96,208,95,62,161,220,58,92,36,24,129,63,61,119,253,118,145,153,166,9,67,126,0,220,158,154,181,74,127,167,43,223,187,111,89,134,99,19,63,154,11,13,47,134,166,122,25,98,64,5,60,247,115,211,22,21,218,97,224,122,67,60,17,193,22,108,232,118,59,33,150,157,13,143,51,162,133,52,192,15,224,4,148,189,255,194,245,126,212,144,33,35,172,51,245,179,216,162,235,209,233,90,34,208,175,150,154,91,46,56,226,37,141,108,180,26,161,237,230,138,11,253,185,62,211,167,201,64,109,180,194,182,114,159,240,151,34,198,220,177,64,35,236,143,33,1,2,231,156,209,247,24,80,216,121,241,138,122,132,94,245,148,88,10,105,209,142,140,107,56,233,53,166,102,99,200,133,53,243,129,191,113,130,0,72,81,147,106,83,173,118,224,97,56,120,136,216,220,110,61,86,250,146,169,94,103,115,52,15,139,112,170,42,58,235,135,249,135,252,241,239,49,238,49,125,60,133,218,10,169,12,226,0,128,99,133,157,194,188,209,5,10,133,213,85,204,107,51,157,124,224,153,68,198,148,31,29,170,144,154,200,45,94,208,51,17,102,82,55,8,149,208,18,178,225,76,0,98,115,173,8,63,224,9,233,123,74,225,125,76,109,14,123,246,64,196,95,145,39,73,119,233,108,221,26,240,43,165,141,189,136,191,134,171,54,47,96,107,148,5,149,7,144,48,159,216,149,45,120,135,131,151,224,102,110,41,67,132,75,40,178,120,96,68,144,141,71,254,224,147,237,230,150,205,106,240,119,154,229,182,132,146,153,253,192,180,235,75,131,151,22,56,232,166,238,79,165,237,136,232,239,43,243,150,185,178,50,37,154,107,240,28,210,98,123,40,196,57,244,45,106,23,127,96,84,214,191,212,247,47,229,232,32,105,175,219,252,123,149,162,214,201,235,232,119,120,178,149,18,158,219,241,6,249,35,138,233,44,102,47,10,107,189,75,168,35,44,107,222,41,147,69,204,77,43,247,158,168,4,105,167,148,28,174,157,50,209,79,15,132,29,146,175,34,65,92,252,213,113,124,128,191,193,178,49,237,126,73,151,187,223,27,135,217,66,63,241,173,218,12,76,222,117,52,225,142,77,239,91,5,157,44,70,152,70,129,206,133,10,38,80,135,16,61,244,147,8,17,82,43,37,214,229,156,7,208,104,214,226,180,102,217,230,56,180,91,78,202,121,208,235,144,247,235,231,39,100,189,212,193,108,238,73,106,0,53,110,88,108,152,217,23,63,78,255,35,144,43,127,28,159,183,31,129,154,21,83,62,78,72,238,107,113,14,121,20,121,98,206,171,119,209,206,25,200,25,202,13,233,25,232,220,161,40,33,151,216,19,136,0,37,81,103,131,22,19,229,61,119,208,108,183,5,38,85,245,175,219,113,152,248,17,83,33,217,52,218,109,74,139,129,53,220,146,28,137,248,84,33,93,110,65,204,91,44,234,121,78,116,252,113,132,204,99,52,116,152,70,237,181,109,19,102,86,90,236,34,46,104,82,183,70,64,54,129,116,110,182,101,171,43,57,77,65,73,37,232,76,82,80,96,92,222,202,128,247,213,219,96,25,235,195,148,19,12,95,2,34,242,107,144,3,238,95,39,87,19,149,137,85,20,43,125,131,5,170,249,95,184,204,105,201,232,230,63,3,42,149,109,82,238,128,195,178,180,136,204,235,207,228,104,33,155,92,183,41,98,136,213,20,224,250,45,36,251,251,151,0,253,180,220,163,118,162,49,6,178,129,187,70,139,169,170,24,152,119,187,84,88,96,171,44,30,108,189,231,127,240,167,166,182,43,7,5,96,123,187,233,144,245,254,242,39,7,77,237,218,75,3,22,103,23,145,38,9,219,8,231,23,25,142,12,172,190,33,179,51,237,87,45,144,79,229,251,100,179,155,150,189,172,190,163,62,237,158,111,36,251,190,254,62,45,17,54,231,45,90,151,38,232,17,218,175,45,121,142,38,225,234,172,22,134,222,57,243,124,107,216,19,142,197,58,210,104,149,67,171,99,0,253,213,169,17,163,169,90,176,176,208,101,130,105,87,210,125,78,248,115,140,197,88,108,106,33,84,217,24,34,79,30,118,34,119,159,71,57,163,200,117,135,213,122,45,191,24,180,196,2,206,166,52,189,82,155,65,59,221,151,84,12,37,185,36,55,202,170,99,9,83,115,94,1,54,183,210,20,127,142,161,213,118,59,88,43,85,183,215,6,38,212,183,166,211,233,254,79,43,255,19,1,70,235,95,32,217,56,109,229,131,217,28,39,140,44,103,194,49,218,35,149,169,55,1,204,110,193,69,216,172,107,76,153,149,199,118,228,173,247,157,88,165,210,77,184,119,15,89,158,135,86,119,136,117,235,68,48,223,168,18,164,225,161,225,62,77,127,16,187,229,185,108,32,86,79,228,80,214,130,206,168,58,69,232,127,85,4,165,30,21,219,188,125,238,27,153,49,129,220,27,23,64,90,170,76,235,91,19,41,125,53,229,106,169,53,18,200,141,56,233,67,181,150,16,135,5,40,232,27,57,27,115,232,92,204,186,246,42,80,254,37,122,11,168,167,116,167,80,135,45,222,183,224,39,220,236,59,102,77,255,243,34,55,93,227,29,36,204,4,54,20,222,95,86,121,147,10,57,208,104,196,144,119,141,55,23,199,105,56,121,38,254,43,246,217,102,224,77,243,138,167,243,223,70,245,103,139,145,29,87,50,25,224,23,250,240,5,137,45,154,199,17,246,236,153,234,164,227,10,220,182,249,142,37,63,151,201,7,73,98,127,214,99,20,166,8,97,230,120,150,96,58,48,166,46,223,194,181,245,65,78,170,201,233,121,5,12,244,94,200,85,100,8,176,161,255,215,2,141,237,34,245,249,255,227,73,213,23,90,76,111,111,228,94,132,42,28,161,244,102,93,137,254,233,36,200,186,238,148,128,105,94,175,3,134,252,209,91,249,163,233,226,213,194,246,161,244,191,155,150,196,150,46,83,34,168,46,128,151,202,183,170,193,210,48,99,162,87,45,16,123,164,118,116,206,219,244,242,223,204,200,67,96,255,184,110,220,232,142,193,148,164,89,10,195,56,132,153,61,104,186,156,204,142,111,194,55,96,117,144,17,157,124,13,192,240,76,21,183,23,96,8,110,7,65,99,12,50,253,49,201,226,217,235,115,251,56,6,186,12,184,234,131,155,200,165,77,59,244,16,244,40,212,77,77,161,245,33,37,122,240,223,50,107,148,31,45,184,231,10,76,27,209,45,175,136,143,73,76,5,22,170,6,196,171,92,119,233,143,22,252,8,174,237,128,128,138,5,170,75,248,240,201,65,159,152,246,186,231,8,235,78,147,235,49,76,40,63,110,177,71,113,84,90,136,167,55,29,255,182,58,82,249,115,216,171,193,227,99,19,129,67,138,173,173,70,149,24,49,87,144,150,187,154,79,40,45,198,45,248,169,153,95,33,178,198,250,41,144,108,174,31,215,86,121,211,29,76,116,156,38,89,189,228,77,224,239,12,48,136,150,234,111,224,58,105,231,55,135,115,74,15,57,174,68,31,25,39,237,248,209,128,242,17,194,4,3,229,21,22,226,10,195,40,43,19,255,205,126,140,14,40,189,36,108,197,217,241,183,143,186,50,54,88,97,127,151,65,146,225,232,241,117,156,2,76,109,110,67,204,238,121,142,70,164,76,82,38,152,255,226,124,63,137,65,254,192,214,69,234,110,119,103,37,36,24,188,253,37,218,203,83,114,44,44,236,88,30,210,94,59,201,84,234,190,121,43,89,116,13,217,188,174,146,118,177,112,69,59,138,112,93,71,233,177,46,170,193,114,79,117,116,66,36,94,108,7,97,104,132,8,35,138,90,184,8,111,175,172,44,187,188,38,214,157,56,118,43,245,128,98,20,45,64,112,18,42,88,110,7,37,87,100,237,36,68,192,240,132,230,120,164,85,243,19,137,229,206,113,43,247,143,34,140,250,26,152,49,170,30,203,158,248,176,145,145,248,246,132,89,241,163,39,248,178,128,71,221,148,169,59,244,65,234,67,169,190,117,234,131,225,165,244,146,102,110,26,55,242,43,241,184,101,159,52,27,126,177,74,98,141,78,86,181,69,73,15,105,54,79,222,233,171,164,133,111,86,64,198,223,243,93,162,54,4,135,51,214,2,48,73,230,99,138,144,238,161,171,247,114,52,249,46,25,142,209,101,42,44,246,42,219,77,37,238,48,98,233,52,195,88,135,253,16,91,202,55,114,74,128,117,37,83,212,183,7,49,85,12,234,239,254,160,0,166,88,82,1,245,56,206,47,177,202,20,208,250,42,215,2,110,240,177,226,207,241,122,99,231,162,183,249,255,246,28,81,251,84,247,254,43,234,94,218,132,35,55,254,142,79,65,239,9,220,48,229,209,46,185,106,84,84,59,245,146,193,67,144,144,161,184,91,214,196,176,0,220,85,1,246,213,13,26,195,145,240,69,12,13,12,63,129,176,204,58,198,190,149,172,72,11,180,35,201,235,207,222,158,61,252,157,82,245,27,196,93,117,32,181,112,242,11,3,48,120,167,180,36,188,103,181,61,112,22,191,59,92,91,144,194,90,5,83,61,186,81,19,134,198,87,8,175,229,76,93,24,192,67,189,233,249,151,219,118,42,25,6,250,36,62,132,112,171,255,152,48,174,241,150,167,28,174,159,29,249,14,63,103,91,105,83,248,156,30,224,183,245,46,119,210,177,173,92,228,162,44,120,196,114,174,20,118,90,130,86,3,129,188,38,105,168,218,54,53,61,114,120,145,29,35,54,138,96,62,200,203,30,194,130,26,125,107,216,13,27,211,140,17,18,167,64,63,29,255,184,114,229,39,73,88,28,234,29,125,226,65,129,136,217,207,205,224,230,137,81,190,90,23,241,151,30,75,104,243,17,252,58,92,179,220,26,43,18,229,80,72,80,114,54,44,17,214,65,107,12,5,61,142,167,135,211,241,85,90,255,112,3,254,120,5,170,148,170,20,34,99,109,99,238,72,189,202,153,16,15,249,242,96,17,133,46,111,242,251,163,253,31,245,61,107,170,23,147,248,180,101,162,121,5,213,45,201,188,241,209,100,181,62,175,236,157,244,126,50,190,99,59,74,152,159,196,36,106,26,34,196,34,78,90,63,31,111,245,19,103,6,81,43,175,162,228,199,75,77,89,208,180,14,128,178,9,64,90,193,214,197,189,153,38,128,166,195,85,249,19,81,237,135,132,16,233,160,9,135,209,98,62,236,208,0,21,7,3,96,213,153,41,6,65,226,65,240,69,203,15,23,215,220,119,232,95,166,29,16,245,223,66,172,228,252,221,241,228,162,208,98,44,250,56,119,151,182,192,189,180,62,70,14,146,132,114,194,48,121,78,5,1,190,128,1,181,105,114,135,26,99,140,186,151,90,68,150,179,218,62,248,47,4,75,206,185,212,224,39,220,239,82,101,103,107,56,101,21,77,217,177,137,111,88,97,55,66,190,219,250,51,244,76,39,167,218,88,225,26,247,242,160,166,126,33,235,186,147,141,116,9,229,40,236,152,244,205,39,122,170,46,164,144,227,222,152,104,161,118,183,154,88,47,146,135,60,43,186,148,77,242,96,228,8,17,164,76,109,10,125,182,136,155,18,5,209,173,235,210,3,73,208,105,129,248,254,74,126,67,216,230,144,94,151,133,73,146,97,84,121,217,140,185,70,129,219,108,126,143,1,244,55,102,172,62,199,30,23,158,128,197,191,105,207,115,234,47,32,103,136,129,126,121,19,42,19,186,211,223,100,161,127,117,238,165,255,14,52,168,228,119,96,232,226,0,54,198,62,101,160,224,14,171,215,49,13,90,98,18,27,171,200,47,170,246,114,17,64,9,59,193,55,46,32,12,17,43,81,92,3,60,0,157,12,194,237,115,149,19,129,7,122,143,214,162,9,64,219,96,112,129,211,225,248,64,69,97,149,122,155,127,227,107,219,28,156,179,222,231,43,124,33,170,152,57,86,98,226,233,171,250,167,114,86,227,200,75,250,248,124,182,193,115,60,233,187,223,98,104,202,22,108,58,225,11,90,75,76,76,223,173,225,145,53,176,97,110,5,134,12,150,18,113,9,236,35,143,61,139,29,148,19,18,234,208,5,124,185,245,234,53,54,136,7,19,213,191,188,40,72,229,13,144,153,146,102,230,112,49,220,138,159,30,139,78,250,242,209,152,233,44,62,23,99,204,76,235,34,69,200,25,95,140,13,180,158,21,218,22,251,131,55,142,44,135,7,138,234,250,145,9,75,128,251,44,240,180,176,150,245,17,55,236,70,116,151,27,230,109,235,238,255,220,70,92,254,17,210,100,246,168,210,125,107,100,220,39,50,223,129,98,124,108,237,58,210,177,140,124,118,200,80,237,78,185,137,104,29,25,45,1,127,80,138,116,188,219,160,3,248,164,231,49,14,77,218,132,184,206,234,230,100,148,206,82,167,178,236,121,75,111,114,223,119,68,188,95,24,243,90,2,0,191,85,119,123,48,76,234,91,211,233,16,224,223,115,236,96,111,100,171,199,238,109,203,239,40,78,169,245,240,166,77,180,89,81,79,247,52,33,100,126,247,28,196,65,133,215,185,87,209,255,234,252,57,185,68,5,53,32,37,131,6,217,104,245,161,231,217,174,1,179,248,181,164,130,201,47,200,81,212,208,235,93,253,168,233,78,230,73,142,239,47,156,7,38,81,193,5,153,240,199,150,115,202,199,26,5,228,212,170,74,129,206,8,241,123,209,156,55,230,25,193,252,103,233,168,199,185,35,99,30,159,101,181,98,64,93,183,176,185,72,149,204,36,219,166,139,95,14,106,208,19,219,130,119,188,146,80,29,18,74,107,204,177,76,14,102,222,21,52,196,163,174,186,102,74,193,103,212,65,163,169,163,23,240,32,23,74,243,152,191,17,68,31,212,226,184,5,51,234,180,27,131,249,231,0,58,83,166,21,158,36,253,169,59,51,134,175,72,158,216,201,230,235,210,178,112,202,94,178,68,30,124,24,166,86,173,232,202,220,226,33,61,13,150,232,35,19,88,90,78,1,55,190,182,139,31,94,55,23,59,47,113,59,22,200,201,2,58,184,233,210,58,167,216,2,189,62,23,141,56,152,158,100,26,173,7,140,3,124,175,154,236,48,139,50,249,241,95,121,176,245,115,31,113,207,146,88,115,114,137,143,152,95,184,150,210,212,130,44,142,222,189,98,213,253,219,3,87,227,44,66,186,158,175,151,246,232,57,71,226,46,236,97,191,237,55,90,190,145,171,71,112,15,158,156,179,84,174,32,179,66,66,48,168,124,193,247,40,12,2,121,178,241,208,239,40,62,18,214,177,215,67,111,232,72,18,126,65,25,169,98,217,113,150,97,121,68,158,177,96,28,132,98,80,231,134,173,194,21,95,174,60,202,152,113,40,61,95,230,21,231,133,136,40,29,210,87,172,16,217,169,44,42,164,118,169,51,18,71,11,37,179,112,216,146,7,78,42,26,199,48,178,236,94,122,140,230,87,219,100,175,66,72,159,66,198,89,18,197,194,103,232,200,225,3,55,7,207,108,180,204,161,39,28,1,14,234,239,61,235,39,80,240,23,32,255,58,96,118,122,30,86,125,49,39,62,167,118,26,130,151,35,141,1,137,155,65,62,206,2,41,206,223,37,80,142,128,59,99,175,62,1,4,42,38,52,127,228,63,24,219,200,246,61,199,98,120,46,254,108,16,199,10,92,96,203,17,217,154,184,59,189,70,192,1,65,72,37,136,203,214,235,21,8,2,14,170,166,96,139,94,121,135,177,81,0,13,141,42,134,138,78,225,18,14,138,191,125,178,213,11,173,219,231,141,112,236,80,104,127,94,242,26,158,92,66,134,138,216,246,60,170,255,107,246,155,219,251,46,100,183,197,16,86,237,103,188,210,223,42,38,203,252,14,0,13,169,137,193,141,189,137,202,236,170,196,194,192,247,57,182,51,14,90,7,167,159,58,118,17,179,204,37,170,104,11,243,60,233,156,109,2,214,212,248,115,61,188,188,136,206,5,10,120,92,49,223,152,144,31,1,149,211,32,25,91,82,211,142,192,17,40,230,131,209,196,220,158,90,13,105,89,5,112,3,149,222,139,61,162,247,176,31,66,95,104,175,235,14,118,230,40,206,214,187,44,238,55,227,148,240,214,47,14,120,86,7,219,55,133,28,214,119,122,73,91,229,180,91,17,243,65,2,223,174,9,80,180,110,79,10,133,75,156,111,166,95,17,36,212,97,34,3,133,162,1,179,44,130,19,180,233,249,128,117,1,239,104,134,64,26,33,234,240,163,92,249,236,23,211,249,82,106,88,106,222,47,141,254,5,81,33,211,72,133,21,19,99,21,59,57,70,148,28,100,226,141,224,57,69,93,48,141,182,166,195,196,32,122,144,158,138,171,69,144,174,49,200,100,235,102,218,89,188,63,231,88,148,82,250,87,187,29,190,71,57,71,135,162,28,126,43,44,86,120,139,174,234,143,134,199,78,99,82,128,253,125,38,246,167,75,86,45,22,247,33,230,239,221,131,180,155,30,181,40,0,161,251,163,153,15,234,203,15,245,252,186,205,188,236,127,42,223,18,188,114,91,136,1,211,43,187,28,33,192,19,206,208,80,0,237,162,197,62,209,242,245,5,247,131,247,116,14,27,143,166,86,148,91,45,1,68,252,180,80,176,186,69,219,186,245,179,222,178,139,75,153,196,160,204,105,138,74,71,148,209,119,25,103,107,55,77,80,228,167,178,109,182,10,17,15,52,37,244,126,235,97,229,201,61,131,11,174,94,69,240,37,33,184,188,70,19,193,227,242,175,239,81,52,220,130,116,1,156,242,237,31,66,78,250,251,193,140,77,19,69,190,104,4,63,101,86,249,164,34,142,20,76,7,78,113,181,34,52,158,221,0,94,175,112,70,146,57,153,184,191,191,82,65,160,219,88,210,158,39,67,32,158,246,49,107,89,226,172,146,211,215,114,144,70,18,186,243,187,96,78,62,71,179,161,158,217,102,176,185,6,117,174,246,159,163,250,252,168,116,236,161,168,249,59,179,126,60,10,153,44,53,123,115,42,127,210,18,214,252,178,162,111,186,215,210,69,180,207,13,246,127,19,255,121,8,25,100,113,100,232,180,74,184,22,196,35,56,226,88,45,21,122,237,16,204,83,111,188,19,112,83,144,33,80,125,238,68,22,23,92,32,32,177,195,67,28,113,244,110,216,248,238,117,9,153,84,156,189,167,188,244,188,83,145,160,187,158,105,177,80,229,16,68,33,53,109,236,210,210,160,95,138,41,125,221,238,240,108,93,46,36,97,142,63,24,25,120,131,186,67,95,178,240,112,127,81,4,63,202,86,101,72,165,11,151,108,13,66,126,150,232,217,45,27,105,41,40,95,160,13,14,43,181,165,144,10,112,188,179,84,163,96,0,71,123,101,166,53,186,83,199,253,26,89,98,94,105,130,130,128,212,151,149,105,119,189,144,167,64,77,103,209,192,203,236,87,205,201,210,168,71,70,80,226,177,169,39,70,211,69,234,228,237,55,76,138,43,189,8,19,172,147,142,148,66,8,154,14,79,181,140,146,81,14,47,3,0,163,206,185,168,54,42,160,78,86,77,199,197,65,40,51,98,88,83,171,249,16,28,217,209,234,124,232,63,174,41,196,31,88,114,91,194,221,189,30,51,215,168,18,200,211,187,198,119,194,160,121,122,197,134,5,94,160,85,113,103,108,186,80,99,133,174,0,116,234,1,156,226,130,157,71,173,238,106,200,113,68,147,91,117,61,29,153,227,47,208,89,56,120,174,239,228,244,48,76,134,119,20,106,26,166,7,52,194,208,76,180,62,129,43,203,201,111,199,175,56,235,176,198,217,129,221,151,97,13,121,106,201,133,128,45,113,95,85,92,3,159,177,156,237,93,5,60,141,41,210,62,104,104,213,75,206,12,54,55,119,117,127,16,87,135,243,53,93,166,138,19,163,205,90,171,8,136,205,220,209,104,146,171,62,236,189,83,235,57,244,35,52,49,211,224,2,43,116,176,236,0,239,166,193,52,74,65,82,189,247,176,129,138,227,96,85,182,88,189,64,100,129,119,237,187,40,159,252,176,15,201,246,227,59,81,189,170,42,77,144,183,114,149,110,154,255,41,245,255,73,61,27,178,223,132,247,121,241,113,13,214,113,139,228,72,224,47,77,54,231,140,191,211,41,42,90,20,90,146,145,219,248,221,40,147,245,245,81,161,186,180,28,33,40,87,28,73,214,9,172,29,45,68,214,122,196,195,241,63,78,203,19,7,229,80,52,202,2,131,32,10,109,10,7,204,155,2,42,230,144,16,12,113,219,60,193,31,94,216,214,151,85,38,250,157,157,133,12,154,12,231,208,234,155,114,198,0,183,206,113,250,146,17,191,87,96,173,198,250,129,186,67,161,171,97,178,172,125,22,230,71,113,249,48,206,115,53,100,72,14,18,19,214,63,24,76,36,203,156,64,179,124,220,174,255,3,4,79,187,117,31,41,212,252,25,12,14,254,13,44,31,47,191,35,78,22,231,185,49,166,119,33,251,221,55,121,115,233,216,33,20,2,43,76,127,162,235,29,247,214,38,93,71,64,255,26,61,7,27,222,236,145,74,99,136,157,142,216,99,67,199,250,191,129,153,213,224,57,62,14,188,249,120,98,106,245,239,73,38,132,177,179,137,253,42,184,50,59,235,168,110,168,158,232,21,19,234,86,69,140,247,43,59,100,57,37,148,131,61,115,18,101,43,205,246,78,56,184,245,120,187,97,174,47,108,73,249,129,39,197,249,209,142,162,213,127,212,46,14,7,251,182,205,112,182,59,27,123,159,204,209,177,151,3,25,235,41,181,212,158,174,157,51,227,4,187,65,160,8,53,174,226,69,136,128,169,19,57,113,59,97,116,143,59,8,18,14,85,94,237,159,61,62,11,241,169,214,237,249,223,164,128,85,226,202,235,32,45,206,254,220,42,89,97,83,149,79,138,234,87,77,103,208,111,140,239,240,190,177,65,181,126,36,105,250,176,213,193,217,101,57,193,35,250,10,125,131,122,3,113,69,122,26,55,133,106,204,166,188,25,14,51,246,99,246,138,140,89,246,212,201,128,97,12,144,127,35,215,234,130,139,191,157,114,9,70,252,134,40,212,200,42,227,232,228,141,123,224,50,192,125,53,255,126,161,245,148,214,217,20,109,121,97,223,168,7,182,104,98,162,181,6,49,4,79,230,126,120,52,235,66,29,3,190,113,164,213,242,235,42,96,47,186,83,248,103,83,10,114,40,185,16,147,183,165,176,248,229,168,17,41,29,225,42,215,119,23,230,191,247,68,59,168,153,9,226,101,202,191,219,115,179,223,9,163,163,85,20,73,191,86,245,114,197,82,183,79,171,231,5,94,110,223,21,161,124,224,194,79,120,67,202,4,119,3,116,75,158,5,192,230,93,19,16,15,18,123,70,78,200,126,130,24,80,114,16,232,83,108,76,25,26,69,180,91,128,163,170,60,117,168,128,140,156,227,210,226,235,97,155,75,184,140,198,55,251,83,103,36,251,40,141,0,45,240,6,153,77,187,58,116,192,104,136,154,113,114,67,59,253,113,154,136,114,244,214,75,70,71,77,242,117,248,204,10,25,233,76,72,65,219,102,4,5,109,223,72,1,218,65,16,103,109,150,190,53,3,25,184,255,168,2,25,124,150,176,32,190,192,236,240,105,139,182,15,187,135,221,242,15,122,135,239,249,125,27,14,73,151,104,75,57,188,52,53,207,66,125,34,80,6,163,5,34,198,200,131,58,30,88,236,171,88,248,40,9,177,113,164,182,120,140,10,42,78,128,186,85,159,108,145,126,128,154,21,1,99,134,231,189,27,255,167,155,205,67,231,252,44,203,164,98,54,50,228,62,226,127,92,86,19,55,254,52,12,252,255,151,92,69,25,71,203,123,113,123,112,152,96,176,144,226,109,31,217,187,106,168,205,80,161,99,195,31,76,172,118,117,122,142,9,28,218,173,110,104,193,159,181,87,117,247,96,27,213,116,145,172,214,80,66,90,254,187,94,148,68,249,50,145,216,123,226,156,170,83,234,208,73,175,20,188,68,53,208,153,109,11,167,43,82,199,160,157,36,50,187,146,45,108,219,220,56,52,125,21,106,67,137,138,63,22,189,139,39,172,119,3,49,91,198,189,59,148,119,136,44,82,115,92,4,19,6,118,33,94,145,235,90,20,51,19,52,57,6,115,4,92,245,240,179,165,41,62,27,177,145,14,7,157,174,224,102,114,193,72,183,79,62,190,74,230,37,224,34,28,6,215,125,60,213,13,130,21,250,23,118,120,218,169,187,86,201,153,248,11,129,90,253,205,152,200,230,5,18,18,215,33,136,96,87,177,102,20,216,94,76,30,88,163,150,161,212,133,199,193,128,105,166,105,179,81,137,228,61,221,68,138,139,254,145,232,107,4,101,210,247,142,26,219,114,86,41,199,147,176,2,221,76,81,247,68,246,23,117,155,200,244,109,252,240,112,152,142,9,103,217,188,227,220,202,169,21,242,23,186,145,116,192,181,182,52,19,242,32,34,121,160,88,38,120,117,243,42,117,18,71,141,116,228,137,208,29,104,30,126,153,219,134,222,52,88,9,238,97,230,199,82,184,252,106,191,121,58,195,107,244,151,11,177,7,219,1,107,225,148,113,179,158,173,64,59,126,245,176,141,185,86,93,50,175,228,60,32,189,60,81,63,125,151,52,168,53,42,136,69,74,254,39,106,50,17,172,139,206,179,35,74,245,74,56,134,11,101,224,144,130,225,181,55,154,140,1,157,64,101,175,62,4,123,239,115,236,186,185,56,100,83,236,213,88,210,207,96,174,202,237,30,178,36,169,139,128,104,9,207,80,172,178,221,49,220,13,215,184,100,78,76,191,112,138,232,43,79,187,223,143,100,136,202,41,200,48,16,191,38,217,97,168,144,34,189,244,140,224,19,39,64,55,180,235,9,247,80,131,162,227,42,65,48,196,76,32,254,22,188,162,108,8,245,150,245,21,42,57,79,255,208,217,84,21,195,248,168,59,21,20,80,177,203,211,129,2,63,15,167,195,200,81,22,127,60,29,196,170,245,227,196,196,34,80,229,111,203,67,19,4,43,25,219,128,203,66,179,1,1,0,248,8,178,43,160,5,194,178,9,253,235,57,13,169,185,101,48,0,217,241,212,129,238,227,118,252,78,255,203,35,220,167,131,231,224,210,139,243,175,215,69,128,207,201,207,40,33,150,173,112,116,50,184,74,174,137,96,140,210,161,209,112,41,241,250,53,238,204,97,43,44,191,43,9,87,33,83,133,203,171,253,156,240,157,78,32,247,130,212,222,55,141,116,16,249,79,223,239,247,127,116,241,157,37,207,47,199,118,246,153,181,84,45,28,234,125,235,13,7,19,15,103,248,66,123,35,20,24,178,208,141,20,227,146,104,59,74,228,93,55,67,235,192,128,22,207,167,102,105,156,152,85,187,46,121,254,7,185,29,86,233,81,195,36,41,76,107,174,78,102,206,80,34,125,152,22,111,105,123,202,81,184,194,226,191,86,84,80,247,34,22,163,193,205,122,123,12,53,27,189,50,32,148,206,249,106,215,190,70,237,133,16,201,238,214,113,112,231,137,7,74,14,242,109,153,3,32,61,21,61,240,254,189,208,67,48,171,5,113,20,8,254,34,16,180,108,31,79,154,78,24,173,0,85,71,117,199,243,87,116,54,151,244,96,221,231,105,158,211,200,215,24,16,74,99,152,253,68,24,83,121,132,219,172,250,81,23,23,119,107,9,5,247,48,107,69,159,157,225,96,199,55,205,106,27,24,247,90,223,28,250,20,140,130,31,96,68,117,210,13,70,62,7,185,74,29,229,154,85,165,141,181,81,210,181,254,68,124,140,97,247,33,131,120,247,95,82,44,35,27,114,163,94,37,155,3,112,35,69,161,222,163,144,75,31,73,124,191,17,162,75,217,38,251,37,250,108,0,67,131,184,81,173,200,126,63,102,29,180,184,11,198,224,76,203,61,72,162,4,114,85,86,227,82,126,60,129,206,119,5,243,164,245,40,89,4,101,237,245,227,11,57,93,172,176,231,184,17,251,6,57,41,87,3,18,204,22,185,71,128,255,14,4,118,105,172,250,12,2,66,198,176,97,235,49,94,207,5,12,210,181,103,196,248,122,43,252,196,219,175,148,195,254,55,207,218,169,147,222,5,7,60,61,81,191,98,72,159,67,109,58,118,136,133,65,25,55,17,120,40,221,123,114,220,182,116,147,173,176,215,109,188,54,88,178,151,124,94,144,16,63,24,116,73,72,81,241,73,47,38,156,200,85,14,150,49,0,1,146,20,244,162,55,242,5,2,88,227,246,66,148,204,104,182,230,205,160,38,232,160,17,238,104,98,224,212,10,194,237,225,124,123,6,35,125,140,209,48,6,180,135,105,180,92,225,14,186,129,94,36,152,55,10,225,92,194,116,16,202,32,202,105,43,115,131,206,191,87,83,213,55,47,243,88,50,89,15,7,187,23,56,193,222,208,164,7,110,171,242,127,169,163,103,26,68,144,78,56,3,160,29,158,43,174,223,119,37,190,243,244,66,62,201,124,176,195,117,168,80,116,203,181,189,236,92,112,83,169,240,161,7,14,61,39,162,80,242,182,15,122,42,111,148,67,7,236,189,130,131,8,129,53,161,26,176,190,157,217,137,253,235,176,116,194,116,87,132,152,227,112,217,193,206,84,183,92,230,123,23,116,219,197,97,169,174,109,80,224,169,79,99,24,162,240,213,126,43,215,110,10,165,19,217,157,156,130,159,16,236,223,102,103,106,238,211,128,141,38,99,128,153,130,186,17,190,48,184,137,253,159,213,195,193,185,79,215,73,81,77,223,51,19,186,128,50,68,73,165,177,168,146,50,165,170,143,28,78,109,61,107,37,91,115,122,191,116,144,2,237,250,189,19,68,99,157,12,142,172,227,229,190,223,40,184,133,180,25,236,9,134,149,146,218,168,182,242,14,41,121,54,152,202,28,250,31,85,112,186,137,145,73,192,96,47,50,72,245,72,189,16,31,208,182,151,10,69,163,169,14,225,176,168,95,92,170,126,89,67,152,93,73,219,97,78,135,169,54,196,240,208,103,98,145,141,4,211,252,226,215,25,217,56,200,181,164,8,207,12,217,143,199,165,162,77,219,17,215,137,214,55,125,159,28,110,120,128,220,233,125,54,73,229,204,108,106,47,90,156,75,227,235,27,141,57,78,188,117,16,3,70,228,124,93,155,196,38,0,9,202,36,184,145,51,112,157,51,86,230,141,158,61,183,228,54,154,22,7,23,92,239,88,9,98,200,186,170,72,237,172,24,53,91,234,198,240,201,42,13,165,67,202,105,242,206,57,210,118,228,46,162,239,95,221,234,70,10,30,125,247,91,206,85,243,241,228,0,194,91,65,4,207,230,41,213,138,46,135,100,200,97,182,36,206,60,229,2,222,213,45,207,112,192,9,128,102,141,180,228,251,42,150,149,191,185,179,17,117,8,157,173,162,190,251,20,221,53,167,78,78,15,77,153,215,78,100,43,73,179,65,51,216,62,89,176,205,248,59,175,216,83,99,43,235,84,6,157,38,85,125,36,231,78,240,215,33,42,62,5,34,55,196,163,207,248,140,107,8,137,101,217,216,125,66,126,225,182,8,221,234,4,76,13,183,169,207,32,123,224,18,17,11,75,31,33,30,6,104,192,139,75,129,54,90,248,110,151,251,162,128,101,174,38,57,193,218,153,223,62,112,49,49,160,198,213,27,189,108,249,16,95,198,215,179,215,111,62,131,43,179,167,53,42,125,195,76,126,127,17,238,93,68,9,144,220,50,166,130,47,193,12,132,47,8,173,207,36,188,220,197,50,61,228,161,235,155,142,52,240,235,231,16,6,29,121,185,182,170,75,254,130,190,31,77,48,147,243,202,78,52,5,186,76,166,21,179,6,90,149,162,62,55,245,174,7,136,197,194,117,197,98,227,67,0,235,59,155,230,23,157,65,152,250,231,250,211,32,32,140,135,135,35,115,116,128,43,239,109,117,116,95,31,138,174,27,17,122,102,131,185,193,194,14,122,218,107,125,184,217,3,1,129,236,246,31,191,171,82,109,223,143,93,3,134,133,170,112,149,229,170,89,150,190,72,175,255,110,163,32,175,230,174,44,194,127,82,173,112,114,148,182,151,61,36,150,86,199,151,85,79,240,47,153,68,208,178,145,86,221,48,35,174,127,155,49,119,11,193,230,16,227,121,71,40,213,48,253,31,146,204,250,57,36,231,197,19,61,23,90,163,191,81,178,3,253,62,23,166,183,39,135,124,9,55,199,26,116,59,133,27,33,176,177,227,182,53,24,195,44,51,13,193,196,14,24,48,165,43,182,53,34,19,180,38,171,126,66,247,53,21,242,237,70,201,49,103,32,179,178,84,211,2,93,10,86,33,237,158,121,59,119,12,201,201,173,232,106,213,211,201,198,64,236,201,14,121,113,21,97,108,124,66,239,253,44,251,110,141,28,65,126,201,242,147,180,219,239,106,13,206,26,59,68,169,78,253,187,111,5,180,61,227,101,174,204,121,7,125,26,144,119,80,197,111,204,169,49,240,88,75,192,60,216,166,208,25,29,214,232,0,123,244,237,229,210,121,247,37,155,75,190,200,43,180,74,94,80,93,159,126,38,117,71,200,56,1,204,92,208,38,58,205,77,88,238,196,33,176,56,68,7,162,157,228,149,173,94,84,82,79,206,246,178,175,136,38,40,74,245,97,193,176,228,251,205,12,3,60,220,181,235,226,212,37,48,194,10,13,255,4,144,39,83,30,240,217,147,152,31,144,250,187,111,40,211,99,251,145,248,36,26,185,161,221,249,87,80,47,169,102,191,74,197,40,23,174,82,96,219,133,104,159,160,252,251,70,75,158,166,129,191,251,190,212,210,21,171,143,158,213,246,177,201,62,195,14,33,167,244,147,246,151,149,62,36,223,127,7,249,36,255,17,197,245,113,81,133,218,29,158,145,149,116,113,239,59,167,99,144,133,189,126,106,219,200,104,217,175,17,51,29,230,31,7,2,200,12,162,12,39,23,17,238,21,59,187,115,97,134,27,48,82,224,31,117,92,132,139,183,195,34,233,175,27,126,209,198,55,71,224,132,169,62,151,188,210,255,22,43,105,121,68,96,67,203,148,223,45,53,128,83,134,150,32,201,45,31,159,72,141,177,188,20,103,230,143,6,193,45,49,14,95,90,154,27,84,195,146,164,109,178,187,143,171,158,145,144,111,166,178,71,0,64,24,91,61,94,95,67,238,83,203,73,40,209,32,93,159,81,250,70,139,144,54,188,137,224,164,8,199,254,182,9,20,50,7,165,14,78,175,199,26,49,194,248,70,121,104,44,201,189,237,95,97,58,103,21,210,236,223,74,67,246,115,113,17,118,255,248,241,222,29,80,244,38,192,245,84,14,31,248,173,118,238,101,27,18,159,60,210,51,60,167,28,232,220,53,107,51,138,130,99,14,64,70,174,71,33,27,144,229,194,59,6,222,220,107,147,3,237,233,102,239,221,36,113,169,231,177,254,106,82,159,72,133,58,119,97,22,152,224,34,199,75,237,116,201,197,193,57,199,220,50,159,184,3,250,192,167,176,174,136,153,114,187,47,5,186,192,217,178,112,133,25,23,189,205,207,43,210,0,106,213,251,206,135,240,155,121,211,82,237,35,207,234,202,101,227,167,123,222,132,135,247,100,195,126,102,86,59,28,4,102,130,94,161,98,107,118,73,106,26,242,30,197,26,165,99,233,145,10,125,38,103,121,20,252,153,244,251,62,175,103,31,8,62,159,141,178,97,141,84,126,84,177,249,83,72,168,25,184,35,151,210,123,198,74,83,236,53,97,201,109,79,16,224,163,24,81,98,113,192,20,116,62,70,185,206,23,90,124,215,126,181,194,66,225,54,241,195,141,37,45,10,240,16,198,196,151,28,82,143,30,3,140,171,183,5,220,58,13,5,159,112,160,205,182,39,135,123,231,221,13,180,179,55,114,21,34,10,9,92,167,77,99,16,179,25,26,183,158,112,115,142,79,59,56,35,192,194,180,163,76,44,34,46,184,112,181,129,160,87,44,81,175,119,66,211,166,207,29,80,56,53,198,199,113,218,13,161,180,206,245,129,100,51,224,150,47,175,236,198,126,235,220,139,53,104,25,96,36,148,80,8,225,214,20,185,185,180,55,87,121,72,40,196,58,85,11,164,94,117,209,238,12,51,38,157,79,121,140,251,212,197,72,49,225,85,213,197,219,213,118,223,190,196,24,202,77,64,122,209,11,245,133,55,244,193,124,127,179,215,131,255,151,198,221,37,88,89,25,245,74,115,97,204,191,27,233,193,90,243,32,36,22,118,36,203,3,79,142,177,99,47,9,190,93,80,131,211,188,148,155,92,216,16,194,232,43,238,99,178,172,58,168,133,198,131,75,94,147,118,98,57,204,150,218,250,137,164,125,35,26,96,192,245,181,239,206,153,132,90,197,62,34,233,243,159,223,119,6,159,51,239,159,83,100,103,243,13,248,199,213,69,168,118,188,67,243,14,54,148,106,177,126,41,77,117,238,0,81,191,123,193,28,123,61,152,120,9,250,10,38,175,36,134,56,27,229,37,39,137,61,74,228,197,255,36,232,42,58,55,251,231,39,53,197,204,46,229,230,250,202,162,222,194,200,251,130,86,223,165,170,254,99,21,135,50,207,217,187,190,210,180,252,142,119,198,189,169,108,63,252,108,75,37,189,235,98,122,56,196,198,11,213,149,237,120,149,204,108,156,162,142,195,127,8,45,104,175,203,43,191,123,151,5,121,155,217,246,188,243,157,209,72,138,136,170,191,210,6,77,52,229,84,85,215,107,237,186,149,243,22,78,211,60,212,31,152,225,138,218,40,202,11,66,106,128,24,18,127,3,199,75,100,137,43,21,119,182,219,45,213,81,89,173,58,137,106,55,36,97,67,115,172,48,148,104,234,224,189,180,40,177,168,200,229,246,150,50,129,135,253,163,202,98,204,170,189,229,65,78,155,192,249,168,254,205,138,11,31,233,18,157,191,77,190,73,47,218,198,131,158,249,13,242,107,12,59,11,229,253,98,125,145,96,10,22,208,204,242,65,247,35,73,24,165,76,29,15,237,35,91,171,170,64,2,1,164,17,253,128,241,166,113,146,171,13,91,114,148,137,190,142,212,12,29,201,85,187,142,71,101,236,229,74,9,121,185,75,129,172,125,20,168,144,59,92,57,51,69,39,119,104,184,166,20,69,97,139,223,197,135,60,114,141,101,37,213,125,250,118,3,135,21,187,23,221,220,103,181,234,182,216,222,211,120,88,123,56,221,186,187,114,247,106,180,56,235,170,172,142,94,163,193,225,159,89,108,108,92,140,27,23,228,10,158,185,201,59,97,20,85,106,188,53,230,0,230,6,234,18,179,189,120,110,182,198,19,148,17,44,131,169,15,37,143,149,144,3,155,136,141,57,44,19,115,13,72,137,77,168,129,45,126,19,177,139,12,211,182,207,124,65,246,118,165,28,190,14,73,210,245,85,63,24,76,92,76,248,244,48,85,133,43,93,1,32,248,196,183,150,98,96,18,236,194,69,176,135,223,108,232,179,211,77,171,21,90,245,215,46,117,116,117,253,142,168,11,151,118,162,48,196,99,116,13,248,114,29,3,218,241,210,101,101,42,24,79,62,125,26,161,129,153,169,88,161,157,51,156,238,178,200,173,36,127,230,140,194,23,198,253,69,110,61,97,103,63,202,253,216,144,209,129,9,82,45,150,41,132,128,9,171,92,53,73,179,165,131,51,129,8,1,75,142,253,219,57,156,160,237,145,124,116,0,13,132,221,35,44,119,139,24,149,60,192,71,32,121,22,9,10,33,119,98,97,156,248,158,171,59,254,107,41,153,239,144,149,233,166,231,118,158,104,214,104,230,2,237,212,152,148,130,146,197,120,248,22,216,143,18,115,205,189,86,221,6,223,84,175,57,216,126,146,59,136,10,5,54,209,168,193,141,14,87,189,217,51,87,59,14,155,72,207,207,97,20,23,168,117,25,26,46,220,126,53,31,207,171,106,72,122,116,162,98,138,116,116,66,170,113,235,103,249,38,216,77,223,159,167,77,81,249,116,50,94,143,115,50,129,249,124,32,183,196,69,79,155,200,108,31,170,200,245,117,4,224,168,159,239,58,2,241,68,230,96,78,226,250,29,55,236,104,18,76,203,62,222,21,244,178,171,57,5,61,202,219,199,47,191,13,4,127,99,247,17,151,45,95,69,39,121,244,104,93,44,196,186,100,126,30,172,9,25,184,13,124,115,156,56,0,133,254,196,124,121,129,76,29,32,2,10,197,226,48,3,84,136,9,104,117,67,194,180,88,3,107,103,104,183,46,164,248,17,136,54,33,105,139,51,213,198,104,222,115,5,121,85,49,249,151,60,117,59,208,111,144,57,74,247,212,59,202,132,40,51,56,237,217,25,118,59,123,66,61,144,77,81,232,46,174,23,71,129,74,9,78,62,117,45,37,199,93,137,196,20,200,30,195,77,22,252,242,229,36,126,178,174,63,141,102,244,41,125,139,62,63,134,20,9,192,59,240,200,183,236,245,1,2,169,219,209,136,5,42,36,195,127,24,97,191,239,212,177,194,203,23,179,185,79,209,30,221,83,178,57,100,46,222,54,221,64,75,122,102,144,73,161,178,147,120,171,144,202,69,193,186,135,161,139,8,81,29,74,60,184,81,86,9,7,7,202,115,179,34,19,126,128,18,51,159,199,201,156,30,210,243,81,147,85,153,157,133,70,61,232,24,71,140,10,146,97,136,202,4,169,116,139,136,239,3,225,252,205,114,214,91,180,75,66,99,228,66,108,5,125,131,192,24,230,21,199,222,116,31,221,194,156,138,161,78,134,254,35,155,107,70,53,70,44,210,170,43,145,242,83,217,49,161,244,46,37,167,140,224,136,64,52,42,66,188,209,115,37,162,55,14,218,55,125,157,228,178,207,248,102,182,240,146,198,178,158,245,103,65,120,117,68,245,154,215,26,182,175,46,223,70,203,31,98,213,224,237,176,51,180,223,11,96,239,57,216,112,222,130,186,215,20,161,230,198,24,90,138,115,171,183,101,219,133,186,188,88,148,60,74,23,60,182,116,63,61,186,147,190,58,126,25,123,90,226,126,189,35,77,108,231,141,228,116,175,149,213,34,177,171,139,116,138,115,131,183,14,221,148,153,151,119,13,246,79,25,191,253,76,104,46,85,221,1,177,230,97,125,19,81,82,76,248,218,25,143,233,51,135,90,169,224,79,120,85,83,39,189,7,245,50,176,135,234,3,95,6,243,18,165,64,229,86,244,224,39,196,228,223,74,12,79,247,104,33,198,220,75,69,207,127,12,3,254,44,249,255,163,124,76,44,121,5,75,117,89,22,6,224,86,204,186,126,173,5,178,22,97,58,252,170,226,104,46,22,177,141,239,105,50,217,244,11,24,248,233,238,78,97,215,34,166,157,31,165,162,142,3,31,166,143,194,147,187,136,163,139,67,53,213,161,21,128,199,82,20,221,4,229,48,67,155,107,194,31,155,224,182,160,137,168,2,176,162,85,140,65,36,237,185,41,4,208,84,149,43,198,202,101,71,52,248,156,115,210,234,219,79,108,15,94,196,149,16,201,15,135,182,161,9,216,42,231,128,94,241,162,54,237,74,191,162,94,108,59,248,236,226,30,178,147,44,130,250,204,24,153,172,81,43,165,176,94,30,1,172,242,58,141,203,38,222,212,185,43,232,136,115,181,13,22,108,30,72,164,168,136,41,215,77,66,180,46,162,129,195,246,48,108,114,41,166,174,116,89,95,4,193,248,91,138,52,83,113,80,253,146,111,159,182,203,227,247,45,58,191,159,255,81,48,245,106,56,113,104,178,93,143,194,137,60,115,75,85,231,197,52,180,109,251,77,77,116,175,1,211,35,103,254,107,16,120,80,127,77,149,37,206,122,48,132,98,175,117,28,205,12,3,131,6,7,81,224,63,205,37,146,131,222,221,67,149,194,226,150,250,66,240,194,137,16,97,207,59,233,18,51,180,142,223,111,30,128,147,54,241,203,42,124,249,42,141,127,3,100,247,124,189,202,231,114,24,243,243,56,1,123,120,117,16,50,31,124,117,83,41,128,16,191,143,10,173,68,81,143,4,92,3,66,93,111,42,56,15,210,158,67,30,132,215,45,62,91,219,229,52,124,214,137,62,159,167,137,120,211,27,9,47,54,223,69,207,192,215,8,149,95,4,147,211,98,254,163,135,27,104,223,139,170,244,0,148,15,106,155,28,169,40,49,149,28,204,114,99,172,63,237,50,240,28,77,175,23,13,236,67,83,193,109,253,240,175,109,227,249,8,161,188,227,154,121,103,248,180,118,71,160,176,79,214,51,116,142,90,7,135,179,140,50,123,110,72,108,116,234,214,131,39,170,60,90,164,253,3,35,29,70,125,159,170,40,189,73,8,123,136,168,11,43,177,91,26,205,141,10,6,49,53,148,195,18,189,47,90,229,73,139,62,11,234,128,137,246,4,193,46,206,254,130,141,20,82,142,63,219,245,51,84,38,37,174,214,42,31,88,161,11,18,46,214,170,99,114,120,147,180,210,178,97,195,91,111,190,92,23,134,106,202,73,183,192,91,79,38,64,180,51,178,176,145,160,48,149,133,59,183,124,124,27,66,194,213,125,16,120,101,137,196,56,127,115,59,64,212,26,48,66,53,205,38,180,69,141,50,24,149,242,2,89,35,23,10,149,154,233,240,164,56,106,81,220,86,199,248,203,8,122,229,36,92,19,235,114,17,234,15,62,199,62,255,104,69,74,120,230,214,63,155,98,246,73,34,24,239,58,119,119,7,58,206,254,95,185,231,139,12,252,188,212,248,176,3,23,108,176,216,13,134,93,166,242,73,251,34,106,118,244,107,213,82,145,136,47,32,47,205,143,47,209,132,180,42,173,185,132,105,55,217,205,99,147,221,239,10,57,13,55,95,29,220,163,239,114,199,254,15,26,92,2,247,163,183,92,157,223,85,27,214,22,204,93,150,8,119,41,218,12,160,5,62,190,101,162,250,23,122,48,88,190,220,124,28,95,119,114,188,175,67,77,14,134,149,227,239,60,46,117,239,155,200,37,90,14,64,0,196,121,209,18,234,30,65,16,155,59,22,66,123,207,200,255,96,40,116,71,9,118,142,120,225,239,153,134,205,224,83,223,83,235,199,173,146,238,54,85,81,10,51,188,27,38,29,27,190,209,207,211,120,184,201,242,60,75,126,159,91,83,148,170,37,79,31,234,229,74,4,171,28,192,237,188,26,253,232,205,219,26,251,105,158,73,91,202,199,139,196,60,3,62,95,229,219,169,158,190,35,53,77,232,0,14,36,56,102,167,75,219,2,201,44,121,206,238,207,142,1,120,128,54,108,103,159,174,2,74,99,239,72,230,37,210,220,191,111,181,173,187,112,101,195,100,214,110,187,133,64,140,162,179,211,34,115,16,106,153,72,45,138,58,12,163,229,79,65,91,156,63,219,190,73,202,64,226,237,123,93,149,83,67,132,224,23,89,186,229,247,70,146,220,12,132,6,247,223,109,64,21,185,196,201,195,19,155,188,150,16,90,146,195,186,62,170,84,113,134,83,117,169,181,62,18,91,165,51,195,146,13,211,218,247,174,54,210,103,241,195,215,77,255,207,27,84,204,251,73,67,245,169,248,222,54,109,45,234,171,127,7,189,14,181,53,160,253,78,2,180,61,188,146,166,137,83,32,143,246,172,153,129,70,166,181,195,24,172,107,179,142,237,242,44,145,81,51,54,154,31,140,213,217,254,131,128,214,25,174,213,147,39,55,182,82,56,90,253,157,17,111,146,159,184,79,46,226,172,32,183,36,165,126,183,24,215,11,168,33,43,159,84,190,107,149,35,233,101,178,87,30,201,131,29,134,226,152,6,3,170,141,161,217,233,232,5,110,63,86,40,69,195,64,234,228,51,163,121,24,193,112,186,193,137,189,179,195,49,134,192,49,20,17,54,242,87,236,4,169,64,192,54,66,84,194,138,34,74,205,205,177,161,43,171,121,44,72,35,106,100,47,212,166,43,245,67,49,31,45,162,114,40,193,114,53,154,166,162,214,51,198,135,242,102,251,182,221,157,211,253,45,249,51,241,183,29,218,230,255,95,60,61,181,239,90,59,67,22,16,247,91,44,113,243,244,157,166,104,96,242,18,180,43,109,69,25,63,57,39,141,207,19,108,68,38,163,87,57,221,233,132,168,222,88,193,247,51,3,32,64,8,245,9,248,69,104,35,222,221,83,62,94,39,236,128,135,245,73,12,81,40,205,141,189,194,134,211,79,24,105,130,161,41,230,194,158,142,238,233,173,39,116,195,111,132,237,205,13,124,173,29,61,250,0,31,81,24,132,0,27,241,221,48,120,86,13,150,225,227,160,250,82,51,55,77,58,99,18,198,255,47,61,136,89,101,19,158,200,105,238,186,198,13,234,92,193,7,108,160,83,251,192,223,174,91,44,246,89,107,104,191,68,203,123,130,199,181,15,191,66,223,50,120,167,176,188,101,1,165,152,21,124,110,75,131,47,196,50,183,79,112,229,215,44,224,49,56,7,184,108,109,238,252,9,167,7,55,0,247,237,178,182,57,183,45,205,229,220,172,29,151,118,1,212,46,179,224,183,15,15,234,119,121,144,25,192,63,150,169,80,94,190,220,226,159,62,129,168,159,249,44,6,197,138,137,204,6,8,101,179,209,23,72,236,10,54,119,0,4,142,63,235,156,211,229,107,142,145,212,49,176,244,224,34,69,18,60,175,128,156,242,50,73,34,60,249,58,135,161,34,144,200,206,164,41,206,167,164,245,118,11,75,244,92,149,4,33,99,35,190,247,87,8,16,25,191,198,148,206,88,164,165,15,142,102,160,51,35,57,64,66,159,102,182,206,138,240,95,117,242,183,129,152,161,242,205,196,231,190,111,103,60,154,164,180,218,221,100,112,50,84,52,26,216,10,118,116,181,73,57,66,168,154,117,21,154,165,71,232,143,188,67,238,152,192,4,188,128,229,87,225,250,125,49,167,74,25,245,63,226,100,46,126,231,112,234,28,191,104,53,1,222,232,251,183,68,108,103,54,136,171,213,239,92,106,63,35,142,211,76,189,90,154,159,116,180,94,130,122,65,20,130,121,56,157,236,25,161,214,102,115,196,17,167,55,44,133,126,226,201,163,146,147,27,129,91,119,207,30,238,107,25,151,233,125,4,160,138,232,207,9,215,65,234,127,131,255,61,188,219,204,194,72,105,132,228,252,232,179,171,145,24,128,58,143,138,241,102,7,234,216,51,150,226,192,144,222,42,184,70,114,19,33,134,194,85,69,19,105,47,31,112,72,114,184,125,193,10,72,119,235,59,57,101,75,2,79,142,195,69,63,45,86,42,73,148,231,80,23,100,41,74,197,22,200,194,211,107,255,87,228,247,211,58,160,72,249,94,254,204,59,7,226,50,115,5,73,120,50,120,136,131,161,62,106,32,187,149,224,220,19,211,147,60,220,45,42,70,229,128,185,93,154,24,86,113,228,107,96,77,103,26,35,246,173,11,207,16,190,239,215,67,3,11,135,95,161,27,215,195,226,199,205,130,104,146,242,75,231,109,218,180,66,133,63,72,192,105,240,177,59,67,170,31,194,19,166,66,127,153,38,0,128,72,59,133,144,71,39,252,98,108,232,11,86,83,42,83,217,19,64,55,176,22,162,28,177,149,180,156,254,114,142,78,157,58,59,43,141,91,41,68,155,88,35,54,79,213,167,206,79,93,53,230,188,18,184,87,108,175,190,230,23,29,166,234,72,229,61,41,104,15,253,199,137,217,218,93,98,142,26,159,182,213,207,186,89,146,154,38,144,218,71,14,176,60,145,53,153,202,78,116,242,70,147,57,76,234,82,65,72,220,5,239,81,136,80,90,132,29,236,22,226,203,202,76,78,14,146,91,213,240,86,164,184,25,153,226,200,13,106,97,198,111,87,97,212,189,36,118,254,237,9,41,60,133,35,148,142,118,171,26,19,51,155,203,128,231,48,202,0,30,96,221,161,93,201,254,122,91,186,76,7,252,137,7,133,119,218,186,213,255,246,18,97,55,238,183,127,117,179,81,221,37,130,130,98,133,41,79,243,21,80,168,2,132,254,183,68,5,30,63,238,193,50,252,19,56,214,165,168,9,181,78,27,122,255,216,78,112,37,210,27,147,163,32,169,141,181,4,90,185,85,56,159,209,36,223,48,7,114,42,17,152,29,192,17,143,20,38,136,198,165,3,185,75,212,1,102,95,154,84,120,69,223,2,233,108,41,211,216,236,74,76,22,115,44,164,155,58,217,201,227,110,204,174,105,56,27,110,248,215,142,162,185,40,17,58,150,107,189,31,72,115,208,130,173,107,235,104,71,172,206,143,79,172,106,119,176,117,140,94,182,24,146,210,50,21,206,73,81,228,162,114,96,58,150,147,40,151,115,99,105,30,192,160,216,221,164,113,53,51,229,49,219,106,88,170,35,179,80,148,2,30,129,89,7,79,253,45,49,5,132,22,160,95,245,70,45,234,181,130,195,230,242,77,58,180,251,24,86,238,226,170,38,131,197,72,250,230,36,239,203,191,232,81,113,107,142,59,118,245,160,50,102,169,44,71,161,217,171,40,168,108,77,40,25,213,177,199,204,110,36,19,105,33,153,132,38,34,218,196,218,51,202,218,221,235,154,80,217,15,147,92,216,234,175,14,17,113,20,113,245,209,128,53,223,185,207,29,230,117,217,175,11,19,3,22,81,121,171,204,171,28,184,68,248,46,6,221,140,6,177,241,64,13,24,100,157,71,121,120,35,0,174,172,29,255,63,118,249,125,243,75,48,161,18,143,145,25,91,141,197,50,111,45,117,128,188,207,207,8,24,139,170,214,97,48,163,78,13,215,254,203,206,14,94,30,208,181,157,209,18,134,89,239,58,185,243,162,154,44,190,85,235,22,251,230,246,2,144,2,209,25,237,123,171,45,136,66,156,105,79,161,10,122,86,137,152,100,81,140,102,39,8,196,129,42,244,66,76,5,57,176,115,246,174,42,156,222,7,166,124,12,53,235,58,42,108,146,148,239,99,178,249,223,202,41,130,143,112,112,81,115,192,219,234,172,49,108,127,176,78,253,225,46,35,255,23,220,12,126,241,37,79,58,28,129,248,178,230,204,89,60,2,68,202,20,6,219,217,188,254,75,146,166,103,95,108,156,252,205,212,175,165,76,171,245,38,144,210,108,137,143,167,5,28,100,84,127,12,199,151,44,164,15,152,106,51,77,182,34,108,8,229,246,151,137,193,14,217,68,166,234,182,46,81,214,126,3,79,100,55,243,99,217,58,215,167,219,186,81,110,39,222,252,154,217,107,23,121,7,160,199,103,9,25,150,98,122,61,210,160,219,240,82,188,135,91,218,245,27,29,85,150,132,147,220,121,143,30,89,215,181,151,104,242,63,8,95,64,66,49,218,254,63,107,42,169,243,117,232,72,35,12,41,146,214,214,230,53,206,248,177,28,210,138,177,224,194,17,213,234,217,222,69,102,35,77,124,185,125,184,67,203,132,130,59,156,101,194,250,4,29,178,134,128,9,248,40,111,162,95,27,111,28,134,116,200,198,168,222,88,66,68,44,239,240,218,255,59,25,69,36,78,77,11,115,44,19,204,126,69,95,1,234,93,83,28,125,207,162,252,67,165,57,69,133,112,39,229,73,209,85,107,207,123,144,122,186,137,22,146,249,76,158,121,55,98,63,121,140,128,117,255,89,12,223,97,44,215,145,209,13,28,84,84,230,2,253,241,74,52,188,198,47,4,241,254,98,230,238,225,205,13,92,248,199,207,108,197,212,241,178,211,75,200,9,166,82,10,113,175,79,251,179,228,157,139,154,234,241,240,203,174,204,99,37,29,199,248,255,242,233,40,128,19,252,233,17,156,240,211,80,76,253,255,11,230,43,87,75,179,105,130,246,127,52,99,236,80,211,98,119,55,128,203,214,78,215,146,174,249,60,61,217,86,100,100,11,154,169,98,92,129,211,185,4,133,127,154,92,2,130,45,26,95,122,52,58,45,126,198,76,229,149,17,14,197,34,42,183,181,131,16,9,103,112,210,161,218,85,237,73,25,120,203,252,57,86,110,46,125,174,166,194,22,79,151,151,170,4,81,223,207,217,91,18,144,238,39,56,83,103,200,105,21,70,248,180,240,220,20,238,8,97,22,189,228,223,154,152,29,78,183,253,164,238,238,201,83,40,247,198,83,142,177,222,178,40,135,147,138,122,118,249,90,42,46,234,17,245,115,246,202,206,168,130,204,169,109,79,222,30,48,36,147,188,107,5,145,38,100,237,21,119,169,0,12,140,231,42,192,72,102,2,33,154,232,43,153,78,194,247,237,150,119,220,192,94,206,115,231,208,86,18,74,178,242,87,46,237,18,22,136,126,94,198,97,124,22,16,29,201,185,0,236,0,155,59,24,12,159,249,46,32,43,142,204,81,211,218,40,52,38,51,65,84,107,96,137,52,218,36,208,95,22,222,149,188,227,148,40,184,165,90,135,50,202,246,67,78,112,146,10,84,10,102,57,244,42,144,45,165,186,22,129,246,161,119,141,175,161,4,91,67,187,213,175,162,172,93,208,97,144,101,176,178,76,177,67,45,152,247,134,99,87,255,148,155,157,12,71,199,229,26,196,74,181,7,87,208,142,147,206,163,166,48,53,168,194,152,193,189,65,238,179,182,143,100,137,160,114,23,204,178,153,196,10,143,246,121,92,124,111,134,83,175,222,242,105,126,42,173,114,237,5,242,128,21,61,107,96,241,7,90,140,31,207,69,100,89,17,33,137,164,248,245,205,49,250,145,134,214,106,100,71,182,216,225,192,182,154,105,73,239,69,48,155,200,143,205,39,115,188,179,255,169,176,79,104,68,206,238,44,197,82,61,126,157,0,189,135,58,129,158,213,204,102,157,235,121,218,85,4,24,25,37,34,210,106,208,153,8,220,12,54,143,48,66,5,16,235,38,51,74,223,113,30,56,80,226,148,214,161,2,228,112,44,245,145,15,227,31,235,198,44,84,157,113,20,136,26,162,105,2,243,144,14,15,50,187,85,172,211,120,8,216,190,188,255,193,246,246,117,77,147,156,202,107,124,169,144,117,148,131,212,182,124,149,172,31,158,143,114,98,107,244,90,26,168,63,222,116,108,104,183,101,220,212,249,156,252,31,172,183,203,35,177,51,222,105,167,245,252,57,105,140,232,117,107,226,64,72,156,49,170,248,61,250,159,228,86,237,211,15,138,151,201,240,68,141,190,23,186,152,222,157,51,92,108,240,108,115,84,178,50,35,109,240,49,158,234,175,206,171,146,142,252,73,248,177,250,234,251,40,50,102,137,89,240,122,1,81,49,199,136,62,136,142,212,50,234,136,119,59,221,87,225,47,165,157,221,204,57,235,249,110,77,148,195,60,108,51,198,25,45,48,15,190,128,172,145,111,100,179,62,17,160,166,86,113,25,59,171,7,84,225,100,112,60,183,177,123,122,142,98,139,215,3,219,217,143,38,72,76,221,2,248,70,81,86,149,186,94,11,237,132,213,217,171,231,123,16,225,180,175,228,126,42,65,133,73,21,132,233,97,223,230,135,89,127,125,119,185,156,73,19,166,100,72,110,240,118,183,12,172,235,77,219,148,208,190,224,164,215,148,74,28,198,21,81,46,210,250,87,181,111,124,177,161,165,159,82,44,195,12,83,49,249,253,224,165,3,110,108,254,252,152,82,238,87,82,0,202,180,81,94,251,132,165,67,126,207,214,240,100,140,60,208,194,89,188,65,154,72,50,116,160,74,105,86,156,208,251,83,14,247,189,103,144,162,202,147,14,32,253,161,142,118,168,236,205,230,0,200,188,217,99,79,27,238,136,47,132,67,94,70,218,254,162,65,202,252,42,49,55,164,233,71,197,62,153,97,133,141,48,109,85,33,81,88,2,203,44,34,102,60,52,239,2,216,1,125,56,188,171,45,169,136,13,76,123,188,154,246,223,133,6,93,218,190,189,82,226,240,217,72,211,85,209,213,117,179,215,44,251,236,51,176,204,251,63,75,225,211,8,189,140,232,228,227,41,182,197,167,134,236,141,54,216,214,250,244,158,244,241,253,242,101,201,115,235,234,219,113,152,27,17,163,108,117,181,131,169,240,224,194,8,117,60,184,72,175,240,193,108,204,250,129,194,246,75,113,154,229,21,94,81,218,182,76,250,248,157,235,125,86,200,69,52,30,147,248,89,45,114,150,122,116,2,2,75,1,140,118,22,73,139,240,132,231,57,214,13,35,8,249,74,180,116,81,233,181,97,23,41,188,112,248,251,178,205,127,43,201,121,2,214,122,187,119,55,178,45,199,214,38,226,49,89,112,205,211,35,213,126,136,47,145,86,56,237,210,237,230,168,22,85,35,123,46,64,246,170,140,23,208,197,61,73,22,160,64,231,38,92,61,237,249,45,69,209,35,104,46,217,228,27,90,217,188,48,151,168,234,29,80,13,224,246,159,163,171,12,251,46,251,206,230,178,138,148,33,113,150,153,121,44,109,160,217,36,236,153,176,157,246,168,139,132,220,212,240,62,92,83,47,109,14,198,237,241,241,58,57,53,87,82,96,81,5,182,150,11,224,179,241,65,213,20,195,243,242,111,219,96,41,191,81,145,184,76,198,108,77,250,122,239,29,192,197,245,235,92,4,34,144,174,126,196,121,87,110,29,187,146,248,209,157,117,93,25,251,119,177,89,118,67,119,187,155,197,80,74,35,109,194,149,15,106,17,49,155,184,7,33,48,110,128,211,90,243,250,229,235,171,189,225,198,47,11,51,100,73,68,17,110,13,32,71,232,194,255,183,238,178,232,120,67,4,242,26,146,179,72,143,68,15,104,208,84,135,55,108,165,158,34,236,149,128,60,57,69,32,189,24,243,80,77,84,75,228,189,143,85,25,248,5,30,211,248,170,118,43,166,208,17,223,92,83,186,31,112,123,56,229,110,182,189,197,35,32,206,120,205,132,179,1,178,185,180,178,157,16,219,57,31,177,179,113,170,128,38,158,74,58,191,124,187,10,80,100,166,226,248,2,5,160,170,91,185,23,28,125,2,228,104,202,47,66,196,82,37,63,153,153,149,141,64,206,70,235,245,195,158,159,101,132,70,184,43,148,172,157,129,42,44,165,94,136,86,45,174,50,22,3,25,143,224,221,158,143,214,77,251,34,129,149,132,219,38,184,221,236,97,73,143,42,154,146,51,44,142,251,56,59,210,157,0,32,138,199,133,162,213,217,39,101,24,0,67,69,174,221,168,197,78,200,23,26,182,45,68,49,222,244,2,194,120,181,213,63,31,85,91,3,166,27,90,129,185,48,0,6,196,113,194,213,188,2,114,103,45,80,198,224,35,126,150,241,136,250,82,165,38,110,107,71,128,127,72,2,174,179,4,161,183,179,38,111,216,28,26,188,108,192,249,182,218,71,225,249,202,203,22,104,0,8,220,158,3,236,54,253,105,132,179,195,8,110,194,114,19,72,245,21,5,231,69,49,242,138,119,186,107,150,94,62,123,4,253,7,155,120,129,7,6,190,66,107,90,125,137,29,142,199,56,87,208,178,49,109,141,214,38,107,157,105,21,140,137,48,99,248,141,174,150,57,151,249,32,114,104,246,87,207,225,224,204,64,175,169,200,175,145,227,216,4,55,121,113,235,47,210,68,243,57,230,122,119,160,141,229,241,106,160,9,146,74,2,237,129,167,160,137,154,100,118,114,165,161,177,232,121,191,90,102,175,169,5,237,220,118,227,61,185,121,209,173,121,180,236,6,104,123,157,93,9,246,140,174,184,74,54,66,122,233,107,212,68,72,31,226,91,242,159,45,19,149,45,13,200,199,225,5,92,191,231,146,241,133,227,208,36,190,51,84,181,147,84,30,252,166,202,244,103,154,182,102,83,214,73,89,49,83,69,64,35,247,102,218,225,106,82,223,27,180,149,186,124,248,92,163,173,108,65,177,112,141,169,233,172,119,155,54,221,126,156,149,238,124,214,172,202,177,175,174,208,169,160,102,16,132,52,111,172,220,222,248,26,139,47,118,124,142,166,41,95,34,223,94,60,209,186,158,200,124,33,57,236,18,127,253,146,172,194,132,100,232,146,102,191,169,209,100,210,111,213,172,151,233,48,67,209,94,84,52,184,80,92,78,205,237,66,241,251,243,149,120,7,145,50,60,11,47,51,94,27,84,51,80,203,167,147,97,174,66,42,225,96,84,85,109,165,207,7,238,124,203,133,52,167,250,4,145,74,155,80,247,243,149,251,210,225,150,64,76,60,242,106,199,230,147,223,1,18,251,201,35,141,127,202,85,197,241,174,225,29,52,192,1,188,52,51,18,115,120,254,21,181,42,15,171,141,33,164,242,181,143,146,50,128,98,220,243,87,103,75,131,156,188,21,166,116,200,3,132,139,229,3,241,13,78,133,58,55,224,193,112,138,231,165,233,3,46,225,72,195,242,5,237,101,91,227,78,246,48,119,36,100,90,219,1,40,114,134,210,95,66,75,199,245,116,136,249,147,185,109,174,216,219,40,182,165,248,54,183,6,95,82,241,163,124,236,226,19,55,229,191,19,238,199,251,63,172,231,11,79,109,232,114,205,176,31,176,68,203,46,37,52,187,128,17,71,37,215,209,216,166,120,136,198,135,80,54,246,100,190,0,75,42,250,59,135,225,156,173,174,250,243,211,213,179,87,25,44,235,245,178,62,77,255,77,114,233,198,184,100,84,216,94,201,86,212,160,190,152,219,63,27,200,47,188,22,153,232,108,61,250,60,210,115,159,133,219,175,25,75,97,173,145,29,133,47,83,180,244,70,162,146,116,40,198,177,208,198,181,170,70,105,104,150,195,43,132,0,230,161,9,104,117,81,250,206,31,15,190,78,120,79,251,63,138,90,177,35,246,192,163,170,96,170,22,116,251,223,178,93,119,170,254,222,167,71,198,92,109,254,156,197,154,111,242,111,124,243,223,74,240,177,89,192,174,18,98,182,16,211,162,159,230,32,250,137,203,190,101,177,34,143,245,145,148,164,151,4,186,67,18,32,53,87,15,23,151,3,29,188,103,177,154,23,54,10,177,61,126,30,73,168,238,125,187,191,190,233,84,132,231,113,46,48,68,207,86,238,165,130,67,250,66,235,94,182,150,213,68,220,83,223,126,180,161,219,13,56,246,80,81,245,158,148,7,233,1,123,213,147,111,206,50,246,248,180,228,99,45,205,55,45,104,176,196,101,155,219,47,43,53,252,119,167,188,245,46,58,90,161,197,243,191,13,166,182,196,61,172,176,161,11,143,103,253,9,162,219,33,137,4,59,31,9,167,241,100,137,37,224,36,84,29,141,67,108,83,234,250,27,180,249,104,155,179,37,255,13,162,215,57,84,154,32,156,223,23,193,0,33,199,70,146,209,118,238,205,248,20,97,202,193,212,3,38,157,201,146,126,246,27,134,67,46,68,43,15,98,120,50,84,42,135,93,29,110,109,24,94,38,228,203,230,208,41,247,83,35,222,213,219,232,141,151,96,53,216,46,211,251,79,27,217,231,178,33,147,90,249,22,152,251,49,47,161,67,236,55,239,112,132,35,30,151,249,237,173,117,203,58,88,199,226,237,178,70,185,155,71,4,168,99,161,202,207,106,37,174,66,75,254,202,216,0,128,252,186,185,242,132,104,8,162,209,129,238,252,159,75,237,24,225,108,161,187,111,161,232,24,218,179,252,3,221,199,103,202,226,57,121,6,97,63,205,119,163,181,128,30,231,244,228,215,94,141,195,8,1,202,112,70,91,131,117,99,121,230,140,74,147,56,188,220,27,17,139,102,188,32,81,95,0,232,3,73,100,65,151,68,6,37,246,85,111,172,233,159,63,241,34,66,96,44,250,145,239,208,112,50,219,39,157,19,6,146,63,231,65,157,177,193,186,69,237,53,142,194,44,166,237,124,241,64,210,190,162,113,161,36,212,47,14,185,61,115,121,8,213,238,236,167,45,45,153,74,152,81,139,113,131,164,251,69,156,193,172,162,26,4,91,23,55,7,190,69,61,184,124,183,71,22,185,83,236,110,187,105,193,54,221,100,171,158,97,133,190,163,165,68,124,246,32,9,200,133,119,75,139,243,10,247,13,51,128,230,169,22,74,73,204,222,84,182,126,49,68,205,81,18,241,234,26,86,192,148,68,28,49,94,62,74,139,99,93,10,62,203,159,194,67,146,94,3,92,175,190,100,132,229,86,211,13,212,99,180,107,219,23,18,53,122,149,79,34,33,251,136,185,183,32,67,44,153,236,89,160,77,117,181,165,92,241,98,191,171,25,204,178,187,179,139,208,80,92,198,205,108,101,79,210,73,73,132,21,100,104,196,124,212,17,157,26,174,58,36,50,66,42,189,148,163,50,205,105,31,205,108,106,177,54,71,236,237,189,123,97,129,32,103,146,232,228,199,119,161,92,114,69,149,185,179,28,168,49,237,218,166,50,85,119,169,67,225,201,169,89,48,16,130,151,35,19,200,89,84,74,38,147,129,173,183,177,222,110,81,164,22,16,225,251,204,232,174,149,194,37,115,152,252,36,90,248,100,191,98,90,139,32,209,46,161,189,161,195,120,126,108,178,76,22,170,213,108,8,164,143,58,68,183,27,166,103,60,117,26,186,56,214,132,19,187,141,213,51,222,198,110,10,42,177,98,237,140,11,83,157,165,158,134,119,81,83,77,16,245,194,119,187,118,74,235,48,28,0,175,106,248,140,93,22,159,73,183,135,210,207,243,64,252,92,114,194,203,53,124,20,67,46,66,51,102,86,159,124,49,217,105,102,247,1,22,108,176,99,177,52,210,151,22,69,6,124,13,116,213,51,32,217,160,201,48,161,215,86,150,249,142,142,117,247,46,29,146,102,109,149,132,183,111,159,24,65,198,155,188,19,38,132,30,77,193,172,98,194,187,69,68,194,42,202,100,219,120,124,45,199,205,179,78,195,129,189,210,85,105,190,179,26,229,2,163,178,33,30,176,223,250,240,126,85,153,131,177,107,62,54,155,253,144,52,175,178,185,206,56,58,66,42,143,117,101,28,167,243,175,76,77,127,189,129,53,35,189,78,133,173,224,253,35,44,94,170,156,33,142,23,152,174,97,133,196,58,90,228,89,143,136,149,211,37,144,241,186,15,210,245,53,86,236,200,83,153,168,108,109,191,206,108,247,163,13,191,149,120,174,208,102,102,190,63,239,7,248,217,1,56,6,171,23,24,75,209,27,87,233,82,23,218,35,167,89,85,14,242,102,55,222,177,70,90,136,5,131,144,160,37,168,10,193,2,99,31,109,36,254,227,68,113,25,212,2,160,45,39,245,185,192,217,153,167,151,63,27,79,61,192,116,135,49,244,94,44,151,58,125,20,52,86,35,196,223,50,196,41,233,98,238,226,192,188,185,89,219,30,32,235,201,122,99,130,160,29,226,42,237,208,55,12,51,218,46,5,58,86,85,145,165,98,225,59,169,85,154,228,166,71,13,183,190,141,159,149,148,136,244,179,187,168,64,164,147,148,48,65,64,170,96,165,135,145,240,75,164,13,117,115,209,187,175,98,248,98,38,241,216,11,185,99,119,146,55,32,210,155,71,235,21,75,191,34,187,82,106,78,231,190,181,171,246,131,110,189,244,4,70,209,66,84,4,160,14,83,95,242,161,138,15,171,3,241,177,198,96,33,97,98,188,217,58,63,27,250,31,116,134,8,241,200,161,113,26,88,106,251,99,11,206,137,5,93,6,21,40,202,114,157,211,204,228,146,121,13,94,251,226,237,231,243,54,192,93,44,195,201,252,215,142,49,255,39,9,58,237,157,184,49,253,13,86,15,205,44,143,167,96,233,181,48,174,37,208,220,40,107,48,120,141,245,198,233,224,104,137,54,92,213,206,174,253,132,4,217,83,217,49,160,254,148,255,117,72,14,75,35,202,153,213,20,204,2,184,250,137,129,102,24,205,36,177,26,250,172,93,235,10,178,111,228,182,159,108,234,48,183,179,161,111,220,97,225,152,44,62,209,130,198,46,100,210,216,178,241,46,182,56,236,166,26,176,35,73,221,222,66,208,6,132,72,83,95,29,90,73,86,119,97,163,67,225,92,82,185,178,156,174,94,157,33,202,4,191,228,157,85,3,37,203,55,42,199,38,92,9,48,95,12,43,95,34,79,187,246,58,128,44,5,35,88,78,247,18,216,178,90,18,154,227,161,14,10,220,25,133,147,29,235,72,221,185,213,151,144,65,185,226,140,126,83,148,72,127,71,235,206,52,115,116,143,162,154,226,208,51,41,183,252,174,158,194,133,161,151,22,185,187,148,206,183,62,66,25,112,135,105,40,204,141,39,122,6,76,193,33,211,221,149,8,156,77,179,172,182,77,21,254,203,172,180,44,90,151,197,227,193,250,142,246,66,135,14,21,121,228,133,192,95,237,21,73,100,136,92,209,95,251,210,74,74,87,73,90,147,74,33,92,133,10,95,225,4,119,190,235,138,17,249,60,151,123,61,107,156,101,8,243,240,223,210,26,13,220,61,239,253,233,172,187,157,131,253,154,186,163,226,172,155,175,250,164,221,114,3,135,123,94,215,58,172,105,50,40,119,42,212,213,160,128,31,89,103,127,103,180,26,248,35,120,236,73,98,176,86,238,253,125,6,59,83,205,74,89,232,27,197,67,109,96,233,163,97,19,209,148,45,48,255,107,143,189,114,150,179,237,243,75,77,176,108,152,164,28,113,137,123,203,105,216,20,202,201,149,140,69,233,229,245,234,51,171,111,125,79,233,44,221,41,211,105,142,79,178,147,48,38,83,232,175,237,1,188,159,36,15,243,190,170,177,165,122,42,138,219,161,87,21,221,93,27,176,27,140,22,9,218,212,197,58,211,61,49,145,179,190,107,40,215,128,45,79,117,153,63,237,106,113,101,172,137,80,107,50,90,4,8,179,56,52,218,254,148,219,23,252,112,236,16,58,164,185,10,162,141,254,245,140,72,196,87,102,194,34,156,26,142,62,225,51,188,144,178,222,144,191,135,83,161,181,103,142,0,172,131,61,202,176,150,5,162,115,85,13,163,10,9,241,191,181,102,0,206,218,204,2,197,1,223,183,118,141,178,6,148,18,92,5,219,46,7,180,139,48,212,235,32,60,189,169,103,134,141,237,52,255,198,186,172,149,207,139,165,146,98,116,175,23,199,210,156,187,72,111,163,77,116,112,147,145,13,78,111,242,22,119,120,184,15,135,218,131,38,115,187,111,215,120,57,170,9,232,185,103,197,181,62,167,148,132,19,187,120,176,99,143,15,71,103,19,238,247,151,61,86,155,213,113,227,47,228,5,241,149,218,97,54,67,30,144,249,122,189,159,165,6,233,59,251,86,25,203,134,216,175,199,197,113,111,187,84,144,37,238,90,220,0,250,82,47,7,168,140,26,150,200,151,70,237,65,86,46,144,196,37,194,13,233,105,172,72,184,229,223,208,125,88,107,166,230,27,172,162,246,157,154,223,149,75,108,26,153,88,93,47,138,151,80,49,22,243,66,117,246,62,200,83,175,192,176,160,88,87,235,190,1,207,37,94,217,178,184,217,90,10,201,90,108,67,206,172,140,195,204,8,7,10,25,94,89,39,219,202,221,2,166,33,191,253,139,39,244,199,201,8,49,193,46,44,163,61,198,111,183,232,121,215,208,192,103,35,180,164,58,75,73,230,170,102,181,244,192,237,55,201,52,168,182,215,74,204,79,244,240,157,7,34,45,19,166,241,247,21,199,27,111,89,230,244,225,9,163,119,0,175,8,244,221,245,159,125,220,194,7,236,60,234,184,172,17,46,37,113,209,169,46,161,13,110,46,147,138,51,35,173,206,110,58,156,251,46,33,158,239,77,6,77,132,171,145,8,195,137,253,238,114,159,190,105,42,156,3,24,18,61,195,137,124,190,216,235,204,192,111,139,107,116,56,14,124,69,153,122,155,175,11,232,32,22,224,57,106,109,34,77,184,220,0,252,8,122,213,130,170,196,48,126,231,161,59,222,238,36,78,35,223,118,28,191,110,192,116,7,248,206,217,169,187,14,214,41,63,194,204,166,67,178,217,61,15,46,229,216,180,184,91,40,213,11,174,117,136,144,154,214,61,255,157,42,138,53,2,50,2,106,116,111,42,229,72,140,245,205,124,229,58,252,21,129,83,192,119,233,200,242,69,81,251,56,13,43,187,104,86,250,22,95,197,18,167,16,106,154,86,11,253,39,244,40,21,163,82,226,231,241,213,24,101,13,92,250,22,28,79,177,44,97,115,225,167,163,91,168,231,111,127,237,52,114,56,180,141,220,39,99,220,201,106,241,45,69,238,217,184,241,172,12,100,210,205,76,199,8,112,194,74,239,10,247,197,77,201,37,71,81,240,249,197,133,136,217,215,90,49,242,216,234,84,98,61,106,120,94,118,68,89,196,36,195,179,101,93,41,174,191,42,64,252,53,51,34,110,68,131,12,18,234,10,1,115,102,22,63,33,60,49,151,212,142,32,53,77,15,104,146,180,81,72,51,89,9,93,44,97,154,103,57,85,2,252,125,114,80,229,22,252,228,220,236,65,34,82,108,226,113,199,189,69,154,66,40,51,30,233,100,183,147,8,221,150,108,216,255,143,189,181,7,92,194,49,18,202,155,177,138,206,193,78,89,126,148,240,144,108,189,73,73,179,180,3,145,244,81,148,252,191,41,253,249,13,219,134,253,237,165,53,254,15,68,143,56,235,60,45,173,132,66,174,251,132,59,16,77,213,17,187,189,206,200,205,34,53,251,247,70,170,3,44,5,218,30,205,197,165,165,12,8,216,160,223,193,152,198,204,125,1,224,239,217,253,126,146,127,18,232,142,180,159,97,110,115,15,235,165,24,192,15,58,114,154,177,165,95,128,81,142,99,52,252,206,114,187,208,132,34,34,184,233,77,175,60,104,230,6,172,95,149,228,145,216,162,239,70,201,244,231,232,222,132,86,167,84,241,122,81,202,69,237,85,34,118,40,101,160,106,205,182,91,243,126,234,233,169,26,30,229,0,117,154,170,63,179,60,84,236,97,130,54,121,215,79,4,67,220,59,86,238,234,122,228,94,81,87,165,249,143,111,241,91,157,15,177,80,182,179,231,205,28,237,182,93,33,205,24,36,46,21,55,178,141,141,221,165,113,24,12,149,222,178,148,167,107,45,142,39,217,157,203,29,145,240,39,40,163,150,221,104,55,209,126,158,129,35,235,31,226,177,85,60,158,136,251,26,235,73,8,21,164,169,168,147,195,149,226,142,27,184,252,134,209,143,51,25,27,246,183,78,212,12,52,125,147,173,136,62,130,157,79,255,74,60,183,166,185,117,126,68,72,171,19,29,229,177,10,39,123,123,0,19,70,179,44,102,188,114,29,154,188,250,47,52,5,227,244,25,229,60,131,87,13,99,232,206,238,152,144,82,205,104,180,23,72,43,208,10,58,110,209,203,46,174,127,136,35,96,225,85,57,142,171,21,16,114,155,159,71,60,39,141,121,107,137,10,121,191,149,43,122,44,59,158,229,39,243,192,104,152,135,25,240,252,21,168,211,222,124,86,30,44,5,172,76,114,99,167,179,237,11,6,124,153,123,116,73,162,63,150,140,218,200,91,176,36,13,244,51,181,204,98,177,157,54,233,250,48,204,144,25,221,100,43,219,48,212,110,242,233,140,55,112,37,229,188,136,30,145,238,114,15,227,120,52,248,119,90,47,230,145,241,109,200,208,84,175,5,109,228,116,2,152,123,176,8,139,255,226,215,142,95,81,60,128,14,104,81,65,63,122,46,129,31,200,25,37,255,154,9,157,158,225,35,131,243,59,189,160,78,188,247,168,207,183,94,242,169,172,49,128,217,189,83,184,97,237,61,90,220,137,109,89,84,211,75,48,75,201,70,178,34,94,82,178,64,228,155,82,255,65,72,54,95,135,146,133,62,65,200,22,207,129,185,132,254,166,20,140,229,186,144,85,60,172,70,24,241,5,102,70,237,185,11,153,12,216,142,68,253,188,175,95,59,36,77,179,49,255,24,241,134,105,74,161,53,148,75,211,29,239,78,53,154,237,107,39,15,209,216,16,255,147,61,94,80,8,40,206,238,123,136,29,86,126,152,193,72,201,136,37,184,235,109,141,8,232,231,37,27,210,170,225,145,106,90,62,72,106,184,247,43,143,60,188,89,69,125,202,114,9,193,25,96,113,167,80,34,153,240,186,53,110,133,55,26,225,90,190,138,16,226,61,150,236,31,228,121,105,254,139,211,160,215,81,215,7,119,151,12,162,158,237,47,20,132,94,210,107,154,35,49,146,113,201,255,17,48,38,110,154,127,149,228,5,47,20,146,195,131,252,179,69,221,174,43,126,34,152,142,5,91,104,195,216,137,146,236,24,167,72,121,214,153,154,26,128,60,30,182,213,25,27,53,149,209,234,132,243,222,103,100,134,40,79,133,235,62,31,39,172,178,41,255,18,114,70,91,194,77,33,238,61,125,237,75,219,103,20,225,120,170,232,253,237,209,183,173,252,56,230,222,145,244,22,197,95,51,218,37,175,201,170,116,126,77,61,122,199,203,216,96,115,87,220,233,176,213,190,203,144,75,97,69,219,230,11,184,237,206,183,228,235,140,224,200,85,111,79,197,80,163,250,72,190,122,202,139,188,131,97,68,5,47,198,64,177,237,11,121,112,174,90,215,166,237,35,205,106,91,123,84,139,185,136,200,188,109,90,24,249,249,184,0,232,117,181,152,194,106,7,149,50,179,249,157,39,73,103,6,41,44,71,196,134,50,241,203,177,140,88,206,73,176,79,23,188,81,121,80,80,96,65,219,83,17,154,122,99,175,177,54,225,33,184,125,140,95,58,74,40,113,211,82,171,113,148,64,154,96,234,113,91,173,64,150,135,68,132,233,7,30,88,241,168,192,175,62,207,25,96,194,130,107,109,2,192,109,77,136,84,196,133,113,239,76,211,17,68,66,76,114,72,191,79,96,0,41,205,220,180,195,49,209,19,18,11,223,161,216,17,218,76,167,70,24,164,66,62,103,86,234,180,32,135,181,195,147,210,6,137,57,157,67,58,4,184,34,130,38,60,196,38,175,158,35,156,120,240,122,63,136,84,32,50,146,255,192,135,144,26,231,158,93,34,14,152,115,247,58,28,123,202,67,159,166,5,236,59,65,196,249,159,70,28,140,232,108,176,205,249,170,204,0,219,254,80,154,94,173,10,188,230,166,102,134,141,164,123,237,148,45,122,140,18,114,34,167,55,175,34,221,124,89,44,173,86,228,25,44,76,61,194,66,231,47,145,148,1,4,24,104,19,125,128,143,238,16,215,11,7,175,143,107,251,191,235,20,97,70,83,59,34,158,34,78,95,183,50,211,46,5,225,196,254,85,243,231,250,2,240,196,8,26,70,73,199,255,234,199,180,135,63,53,185,75,59,206,177,162,125,116,51,9,202,31,202,174,144,72,4,25,170,10,154,176,207,241,47,77,174,68,184,177,205,78,228,91,179,206,78,13,46,182,120,160,65,132,89,3,218,131,103,158,167,255,45,63,253,78,10,250,133,199,104,150,233,146,191,190,65,188,106,85,179,100,176,8,139,213,57,224,160,155,63,204,64,35,0,192,178,16,131,70,70,162,141,250,122,223,131,178,167,222,145,110,191,95,161,137,57,221,44,156,247,81,18,133,162,216,103,205,233,178,45,173,40,224,182,210,226,23,28,25,32,151,229,126,65,88,219,140,221,109,225,191,117,193,144,224,140,184,127,5,120,111,5,81,34,74,83,163,18,1,148,114,205,90,253,45,153,26,24,2,118,179,47,145,123,50,252,212,116,147,254,38,114,171,158,54,22,163,127,126,6,98,146,36,175,139,122,65,13,210,149,8,12,197,97,152,145,128,245,129,107,218,50,246,178,85,199,96,52,10,57,234,190,63,107,45,84,162,253,146,229,52,128,40,203,102,58,114,242,211,171,245,71,55,187,184,232,37,93,236,86,156,253,144,150,238,34,57,189,5,243,244,147,144,220,83,131,3,53,38,165,42,138,121,221,34,63,215,243,37,80,92,145,143,128,58,184,168,74,49,55,34,84,65,119,53,238,241,51,213,156,148,8,123,13,195,80,95,148,132,248,3,174,253,141,113,46,103,76,27,226,175,4,67,2,21,87,21,112,103,167,91,236,84,75,234,53,123,226,186,176,230,65,147,134,95,202,254,122,85,72,210,148,87,166,218,76,81,83,197,236,92,147,73,181,57,215,41,8,245,212,116,228,247,205,25,62,254,249,163,240,255,188,109,11,44,183,72,188,35,250,153,251,158,252,140,227,55,222,174,219,215,241,69,252,8,251,178,194,22,254,29,97,80,155,88,123,29,25,40,49,120,158,44,82,75,45,213,11,80,124,30,228,15,79,196,206,94,232,217,74,210,24,108,174,15,213,98,232,150,185,160,46,205,117,104,68,156,211,135,204,97,139,123,135,13,56,145,165,86,36,54,60,111,54,71,162,28,123,210,128,127,119,132,46,77,128,254,171,56,202,248,111,234,0,250,240,125,29,241,73,0,109,138,102,130,16,117,82,219,108,28,216,147,50,111,117,3,146,6,249,159,199,215,159,208,35,139,175,75,243,193,153,176,229,49,121,43,214,141,254,209,80,32,17,113,58,141,230,128,218,221,205,116,32,66,105,103,197,249,203,67,105,195,123,177,185,178,206,36,29,207,151,218,176,47,186,82,253,30,52,51,85,231,65,255,254,200,24,2,163,239,179,38,207,75,33,95,243,203,153,41,152,116,19,143,102,2,197,44,113,187,137,249,145,106,164,52,70,184,133,159,189,247,15,11,112,172,139,130,149,83,65,69,162,204,92,41,19,42,180,209,95,104,55,25,25,72,200,103,34,55,219,123,227,203,251,90,231,192,107,140,81,60,232,31,139,101,243,181,160,102,89,4,143,122,73,231,237,44,197,211,103,64,3,31,72,95,241,59,105,165,41,31,210,16,29,234,97,80,9,127,235,249,47,116,102,172,42,179,137,45,60,253,221,115,129,5,61,96,102,188,166,60,61,137,133,93,132,188,206,232,8,193,87,88,158,206,206,154,99,131,66,188,187,168,125,132,96,142,42,7,42,251,123,162,191,42,101,15,192,83,47,88,211,20,214,65,186,69,199,115,194,16,72,107,105,177,15,158,147,189,163,17,212,14,202,225,169,243,19,6,121,247,58,154,76,63,142,244,60,157,69,181,83,51,75,195,64,200,143,126,114,10,238,31,23,63,175,120,113,41,24,106,23,15,159,39,73,102,59,193,223,174,241,42,39,194,199,134,174,193,181,248,137,251,57,186,237,84,82,250,134,48,199,84,180,57,223,18,91,248,96,248,102,172,51,194,115,197,56,88,232,27,171,37,24,254,120,43,79,27,205,98,28,234,72,136,217,226,194,108,155,106,92,137,36,171,197,241,48,93,47,156,151,189,1,1,57,80,74,177,90,115,54,183,202,214,191,160,69,144,90,163,150,210,230,238,90,162,182,201,152,38,145,246,65,166,88,169,241,170,168,108,89,83,35,53,231,239,30,102,3,124,241,211,245,146,32,128,83,49,12,157,176,18,152,41,233,185,221,73,177,230,48,148,57,21,195,6,7,114,143,231,82,69,90,13,72,66,69,45,140,47,176,76,77,103,42,19,129,63,67,65,18,23,143,226,60,167,47,207,201,206,69,255,124,69,253,194,175,141,154,60,103,74,136,122,80,32,186,112,118,76,133,125,90,173,123,28,60,21,137,170,10,104,74,243,53,194,200,113,74,128,60,139,251,184,2,233,69,150,71,136,117,31,86,249,69,24,201,156,167,179,76,139,116,134,210,117,108,218,211,141,41,142,2,119,185,6,77,173,99,137,31,64,76,95,236,167,53,191,155,99,216,68,183,117,49,24,4,123,219,99,129,101,13,74,96,240,125,140,162,249,151,174,86,102,18,184,110,242,128,121,117,171,23,159,45,241,8,230,223,96,58,166,39,230,240,133,236,184,185,73,144,197,111,3,174,80,184,26,233,0,130,104,141,78,197,195,221,20,186,162,156,165,63,225,120,28,6,85,17,149,92,231,141,119,50,253,112,57,122,130,42,27,84,108,151,146,166,249,111,71,196,187,149,214,23,240,93,95,232,46,8,245,151,57,164,90,158,55,136,135,79,77,171,81,101,46,138,166,69,59,107,243,22,62,231,187,15,100,156,220,246,156,46,236,237,54,48,255,247,95,8,36,232,170,242,170,102,178,68,194,198,166,197,180,171,178,93,47,165,232,8,65,250,130,117,220,159,43,88,132,166,60,186,208,36,118,16,0,214,158,177,70,234,97,141,6,236,168,187,251,85,120,18,76,111,234,171,118,227,110,42,83,127,67,122,150,10,153,111,68,217,183,27,106,175,230,158,113,224,134,221,247,68,249,180,0,235,156,94,23,215,111,246,121,158,174,10,69,42,117,203,77,118,213,254,25,129,72,199,81,125,114,85,247,89,125,69,232,75,118,112,136,35,76,39,28,189,33,113,213,228,37,164,157,161,10,152,125,236,43,88,142,102,246,234,170,0,119,213,239,243,217,77,150,132,233,247,180,137,20,72,24,101,134,245,159,249,27,33,244,200,208,53,23,146,53,128,154,235,64,172,30,71,167,46,91,193,102,245,19,45,171,76,136,98,105,233,28,55,110,142,17,245,12,222,157,82,48,237,187,171,99,76,119,13,93,236,156,228,243,190,142,25,212,199,102,22,208,109,144,37,234,241,206,137,25,59,183,180,88,59,62,140,245,251,189,30,201,128,124,68,142,39,5,51,245,1,133,141,120,197,234,60,73,117,79,64,190,146,165,183,71,61,27,84,179,135,168,109,210,239,118,168,60,170,108,121,14,36,19,19,47,159,160,253,22,154,73,47,153,150,245,218,188,217,108,27,103,204,134,39,28,120,223,12,42,71,135,255,9,21,102,188,155,71,181,125,141,235,17,169,157,209,33,12,24,45,153,186,125,33,220,1,219,209,241,211,230,37,238,42,53,122,227,38,76,49,40,38,59,238,195,250,38,253,152,178,107,151,21,98,204,160,138,134,116,23,87,219,172,119,154,17,172,102,171,14,63,147,96,25,206,39,50,86,167,77,81,94,226,176,156,64,104,70,74,155,142,191,22,184,194,122,94,113,168,80,152,172,89,91,94,179,170,228,88,184,87,236,156,192,112,208,122,173,28,164,101,231,179,32,228,194,85,189,97,195,179,61,42,112,40,216,144,8,225,196,19,29,60,185,18,30,196,200,241,241,200,100,129,118,240,183,17,51,141,206,113,147,135,118,108,4,77,106,176,89,41,34,68,210,144,255,156,70,240,58,107,119,222,248,138,88,166,60,198,201,205,13,228,97,236,255,254,173,100,251,152,208,10,144,206,157,234,44,29,78,28,139,41,163,126,122,2,222,28,207,111,195,120,245,64,166,62,76,215,242,42,147,102,58,162,112,128,102,19,81,229,54,183,112,253,145,120,227,21,118,186,67,95,192,194,59,39,179,194,15,139,231,160,238,229,158,245,181,93,86,171,27,34,128,192,2,129,238,177,225,36,157,255,62,111,238,100,245,180,44,59,39,145,167,61,40,244,176,47,223,159,4,87,235,251,137,188,99,162,51,122,67,252,164,204,205,42,171,60,28,233,96,202,251,43,3,219,181,197,56,105,105,235,180,9,23,52,9,105,43,150,192,216,245,41,61,120,202,29,123,124,55,68,15,218,52,190,127,195,55,20,47,131,75,154,199,211,29,2,64,47,145,116,11,171,11,5,178,206,245,46,93,168,230,187,155,30,45,28,77,168,231,214,245,43,16,55,212,109,137,16,206,173,124,247,83,164,104,215,84,193,102,0,38,128,10,170,177,153,247,45,47,159,146,127,186,232,11,0,88,179,130,182,188,254,9,105,82,174,192,191,99,103,209,118,125,243,183,149,96,118,252,73,29,246,140,128,223,197,65,104,181,235,44,137,193,171,146,45,99,100,66,84,0,21,145,186,103,59,122,114,190,138,189,42,96,25,102,128,13,225,124,87,91,197,150,163,112,130,204,146,244,175,206,102,26,230,192,253,124,15,129,240,82,103,251,93,62,86,83,142,70,9,83,142,212,199,91,232,18,185,211,208,92,144,169,239,36,159,168,90,14,220,212,186,1,28,142,173,23,4,27,211,101,155,96,148,211,59,98,118,228,151,28,118,176,206,106,103,135,236,30,219,184,184,164,132,193,145,28,168,240,206,147,129,208,155,123,18,144,201,105,223,249,140,193,146,186,106,247,2,255,159,225,52,2,127,68,94,54,28,169,60,233,232,141,206,76,247,76,72,78,227,11,166,70,59,125,93,166,110,67,113,3,153,94,91,205,198,76,105,98,199,73,122,221,128,105,54,127,109,13,116,199,208,129,151,214,93,70,107,41,22,190,145,210,106,154,132,50,51,122,158,220,175,77,2,0,119,162,147,106,56,150,160,232,67,122,179,100,241,252,132,169,110,229,195,26,245,215,125,191,107,248,196,98,159,12,76,169,46,154,115,116,37,3,64,6,37,142,185,208,31,12,30,1,13,77,112,172,26,29,37,161,225,79,232,158,27,119,123,30,121,6,146,82,53,203,29,12,16,19,157,237,106,217,15,14,36,127,38,100,158,95,127,170,152,103,42,96,43,247,67,132,27,50,52,47,8,218,153,196,110,47,184,221,132,30,216,164,232,54,27,197,84,31,155,39,111,18,64,249,163,216,69,10,0,134,98,186,41,212,220,196,73,59,112,45,195,91,101,213,78,166,118,143,37,150,179,216,82,165,0,132,168,146,11,28,122,173,109,150,15,157,238,180,69,82,253,116,254,145,224,62,103,105,102,249,183,176,229,46,111,96,113,228,37,153,95,0,83,214,19,224,201,178,115,115,138,219,3,132,223,36,129,86,82,217,17,37,171,34,211,201,5,241,3,94,204,107,74,207,107,202,156,53,163,216,51,196,18,4,104,105,4,215,152,107,219,133,72,105,205,238,45,60,219,239,191,62,236,241,99,7,49,182,91,12,111,158,89,55,114,34,148,156,53,191,195,212,236,53,96,73,93,32,50,87,243,36,16,59,249,201,124,18,42,10,190,11,75,107,162,30,53,138,172,155,64,125,81,171,229,241,90,163,66,96,171,126,185,254,233,175,81,249,175,160,190,149,201,7,172,239,83,158,176,146,250,248,184,218,253,153,36,208,253,38,126,237,146,133,0,88,250,35,106,3,89,156,130,176,183,17,108,1,99,43,146,243,143,74,100,39,56,68,95,146,158,77,112,255,219,99,75,189,153,12,215,108,231,138,79,253,160,176,224,201,239,127,79,255,178,164,104,213,233,131,39,40,161,166,93,175,119,213,176,34,192,44,126,166,222,124,149,37,120,12,192,212,170,86,194,75,69,140,223,237,46,239,59,73,240,164,198,149,201,75,115,189,69,137,103,75,187,52,12,68,187,63,94,163,48,166,6,105,53,12,88,28,193,18,41,66,36,56,66,19,122,195,42,212,110,206,169,215,35,250,169,92,185,194,161,206,170,103,254,38,125,43,67,250,44,201,213,130,113,121,183,189,156,36,139,24,136,141,141,96,190,221,137,10,203,205,136,250,200,193,185,171,44,188,153,224,45,215,244,68,127,147,153,143,39,66,230,253,180,187,169,235,41,214,237,171,0,86,34,201,102,119,237,248,198,81,136,197,231,2,126,235,195,173,242,18,77,94,48,39,77,136,246,157,79,237,168,145,255,133,63,23,192,116,202,109,163,5,253,115,19,170,230,72,163,15,52,114,185,124,205,229,4,182,208,74,3,119,210,47,32,178,226,15,37,3,154,229,237,141,159,178,226,45,17,247,232,237,151,93,17,121,9,117,233,29,58,147,19,51,53,86,190,133,252,159,161,41,215,114,252,187,226,126,159,36,182,155,19,89,62,87,163,55,107,103,1,117,206,199,161,195,131,26,200,39,215,59,15,68,21,211,58,185,105,48,87,199,14,193,62,11,124,114,51,202,220,36,226,202,93,109,210,123,67,37,116,29,210,102,120,4,182,99,60,12,130,83,187,154,228,100,67,154,99,44,71,71,174,78,47,253,230,161,219,115,107,228,224,234,237,5,58,190,105,113,48,189,95,71,195,187,151,232,201,34,139,240,167,73,133,183,49,35,76,25,4,136,8,10,134,219,60,51,214,129,28,142,186,48,163,79,136,94,253,130,68,202,161,73,40,141,6,52,141,218,230,161,216,10,247,9,197,32,168,141,220,4,250,7,208,24,24,168,95,40,1,228,7,143,32,67,201,67,237,36,142,38,61,95,253,70,249,163,220,176,144,113,2,116,17,101,168,127,145,231,91,106,30,192,105,253,230,57,229,97,9,16,13,98,148,250,221,69,72,219,136,77,186,51,91,157,84,14,145,231,117,35,88,185,92,203,33,10,179,84,3,16,58,205,2,24,98,175,239,135,137,191,34,221,55,117,69,66,139,177,120,211,151,31,241,242,185,229,223,6,37,203,78,115,92,182,135,219,159,112,124,181,118,66,254,4,175,200,6,113,221,152,217,41,182,88,14,105,212,249,21,107,23,102,130,224,144,124,106,9,25,85,95,218,105,111,249,236,131,207,16,27,189,243,168,229,68,117,41,140,178,100,27,214,51,64,112,53,23,51,250,83,198,147,219,199,131,120,61,133,42,70,61,216,186,118,161,29,107,209,142,191,204,142,138,143,60,204,191,13,210,185,81,222,98,77,108,247,107,125,160,72,173,140,128,84,104,95,208,100,201,231,123,178,153,253,207,118,204,212,13,168,58,84,64,98,95,36,155,129,16,65,46,204,17,7,206,3,127,174,191,118,234,247,126,2,53,164,160,73,207,227,149,198,13,185,163,107,207,51,150,42,198,170,67,81,24,72,11,10,116,111,156,127,49,75,54,131,28,115,54,118,35,94,35,108,26,156,179,190,221,180,75,234,19,45,97,193,104,254,208,41,18,178,39,26,13,49,122,32,230,183,50,75,134,32,109,94,57,38,25,167,95,48,166,16,56,127,126,218,39,237,35,228,69,184,112,78,162,38,174,49,11,109,51,149,248,239,121,35,12,34,130,138,191,213,252,22,1,3,169,18,145,153,160,224,66,12,164,106,246,67,24,89,145,214,50,241,241,158,125,114,114,87,238,142,112,98,30,20,92,163,133,203,208,112,1,74,47,136,150,180,217,175,73,74,15,114,246,34,188,95,93,224,71,9,2,1,124,123,191,123,171,28,5,29,65,154,19,97,97,17,110,43,54,132,255,108,235,235,151,0,153,147,0,113,137,172,86,99,21,219,88,33,25,95,99,76,20,191,95,42,121,106,120,76,3,99,194,40,92,41,3,203,107,212,140,219,183,133,120,57,226,53,225,41,125,26,250,78,158,41,218,184,178,25,129,64,141,193,59,37,111,96,182,120,42,196,141,57,65,24,200,124,239,196,2,149,78,11,68,97,171,252,150,189,46,146,215,254,125,161,35,129,28,94,34,52,112,235,42,251,221,145,199,53,45,221,144,81,152,25,152,21,125,4,233,233,219,160,136,212,27,102,216,254,214,183,139,172,176,180,25,223,118,195,139,180,10,223,243,137,242,94,169,74,179,131,42,173,67,11,18,112,227,9,116,134,207,139,12,60,239,205,227,173,159,54,206,32,189,211,12,215,15,74,110,44,69,96,224,218,157,208,246,128,194,231,188,84,147,239,137,141,116,209,63,4,250,33,5,136,83,179,62,213,8,110,94,94,152,17,87,169,58,124,89,80,57,99,130,240,60,232,41,27,91,92,56,248,149,64,147,16,179,207,29,177,61,124,13,11,242,231,219,168,250,86,71,34,131,49,66,202,252,139,118,204,97,62,22,28,162,152,113,73,169,108,4,23,173,162,60,190,132,45,230,18,185,107,216,49,153,189,39,15,78,44,105,116,245,151,35,0,188,35,101,187,242,37,46,80,226,249,165,83,144,188,226,224,101,7,163,125,188,6,184,233,127,178,103,89,62,46,60,84,34,48,141,232,234,142,69,101,87,89,185,249,48,5,17,224,66,157,124,199,230,243,174,34,42,17,162,54,250,207,200,181,66,224,252,206,37,27,42,227,28,123,0,156,144,250,232,165,124,135,15,168,95,228,211,133,27,155,254,247,77,252,242,42,59,123,60,2,211,83,116,216,34,70,95,181,251,67,140,235,243,147,192,246,6,238,228,16,241,36,161,140,3,81,222,140,240,221,90,166,108,1,30,229,176,99,43,53,217,50,155,184,181,28,50,16,193,1,84,198,83,45,176,4,205,77,108,240,77,13,51,42,19,217,198,69,189,178,91,16,195,48,22,155,214,86,93,76,155,51,80,27,244,87,41,155,95,168,183,161,111,121,43,235,112,77,188,168,105,91,34,47,59,216,159,14,199,105,83,130,223,213,28,86,141,167,137,91,121,187,119,168,151,253,101,42,69,56,118,237,133,82,38,81,84,176,52,203,139,31,163,56,96,45,116,237,237,132,95,67,83,209,208,13,218,131,111,68,97,186,244,230,30,91,209,192,238,176,125,39,253,210,227,56,163,129,155,95,234,75,144,166,38,64,112,130,223,64,195,48,54,237,235,214,223,210,95,75,220,122,71,100,205,144,217,42,208,48,135,134,236,88,172,149,218,244,125,157,206,57,139,156,16,202,172,188,79,2,158,99,185,247,90,214,249,211,143,197,115,245,192,85,216,51,7,49,99,61,171,39,11,57,134,230,199,67,202,46,20,186,12,116,184,115,29,27,90,177,26,213,37,16,97,163,141,187,10,130,3,99,178,178,90,134,132,205,149,89,52,213,213,95,152,8,181,94,132,50,204,130,188,132,206,202,137,255,222,241,125,68,176,114,180,67,52,128,28,184,201,26,101,179,238,25,10,40,193,12,123,86,62,219,11,212,24,13,241,32,178,208,139,117,211,217,201,32,255,188,7,208,17,222,120,62,115,117,32,124,192,227,68,108,217,126,211,249,220,138,71,98,163,127,194,137,68,145,150,143,136,128,134,115,16,203,234,90,137,194,52,74,189,114,137,80,90,192,20,153,79,251,67,152,165,195,62,42,169,154,85,61,174,153,233,98,122,147,229,163,43,71,13,162,200,201,67,239,46,142,230,17,79,246,236,0,42,92,233,77,238,78,163,47,99,33,25,111,208,245,65,41,248,11,130,68,170,6,204,62,101,75,92,102,80,89,40,168,32,133,100,221,98,106,49,213,8,71,110,94,83,111,65,23,61,150,167,49,166,42,73,214,37,138,174,120,133,75,201,92,5,180,5,66,25,31,66,190,183,127,15,181,15,245,237,39,127,181,118,170,74,79,141,115,220,246,84,67,98,10,112,83,80,5,191,73,134,132,79,35,107,63,138,250,154,210,100,132,32,234,234,78,242,82,7,200,246,166,108,22,131,129,94,110,247,195,118,255,254,130,45,128,200,14,253,160,113,133,123,132,218,179,131,229,250,108,15,94,33,99,241,61,83,154,48,74,218,135,135,15,187,214,190,95,14,117,219,45,161,79,187,254,127,70,192,61,173,128,222,176,195,35,115,163,39,39,64,208,244,49,70,130,37,194,179,127,147,79,73,213,192,226,171,113,43,122,164,107,66,119,59,62,125,31,20,99,90,192,102,116,123,89,94,214,83,176,203,246,20,243,122,214,97,184,98,13,99,113,189,50,105,193,245,207,176,21,137,1,95,192,181,66,170,230,143,103,82,117,150,84,229,54,131,102,148,236,103,90,46,33,228,160,18,57,34,29,39,47,240,43,153,179,236,247,3,30,238,218,248,250,16,119,209,64,91,210,60,120,235,250,240,17,127,38,242,3,213,12,158,210,189,174,224,202,113,55,53,216,162,173,145,125,201,115,189,248,119,177,26,78,87,134,229,58,91,166,38,220,150,58,250,40,255,69,168,124,116,94,231,135,27,27,28,116,216,211,40,168,229,179,110,220,5,35,42,186,227,239,206,197,56,208,234,224,14,32,223,56,30,204,206,4,151,60,123,26,227,12,140,197,222,59,157,53,70,95,105,123,98,22,168,175,70,51,25,28,148,96,60,118,153,17,23,84,148,79,169,68,30,46,31,142,160,23,144,244,232,9,206,174,171,53,137,253,87,59,5,190,163,249,119,186,171,128,88,11,136,234,174,175,191,24,182,0,61,91,116,45,173,171,204,71,77,244,123,21,3,237,76,186,77,158,130,242,9,239,113,60,108,180,239,206,38,162,180,128,103,145,244,52,44,178,178,128,190,93,155,225,174,145,190,5,144,24,178,22,115,88,210,7,211,63,28,232,220,134,32,236,54,63,55,236,145,196,88,53,72,232,101,108,228,112,87,165,205,225,53,142,238,52,81,170,185,36,248,215,30,74,195,198,74,143,159,18,116,65,117,149,135,39,76,237,245,227,124,173,75,149,51,154,246,245,5,225,61,156,56,241,105,137,18,67,119,237,216,131,246,16,233,26,138,128,224,234,79,169,230,166,192,230,3,196,141,30,250,14,163,230,222,92,175,139,216,99,28,168,119,216,151,8,134,115,25,31,219,122,58,252,181,164,211,161,96,11,35,124,69,98,212,112,1,80,131,249,94,47,151,66,53,209,124,29,180,128,22,209,128,57,92,142,188,97,78,195,129,186,131,25,148,126,223,202,141,125,127,27,234,232,86,68,10,100,187,39,8,61,77,80,114,109,222,120,228,56,147,55,52,162,179,34,227,199,216,75,249,179,3,243,39,108,59,107,120,183,107,252,60,62,254,99,156,15,16,185,106,236,79,203,152,33,34,180,124,249,155,99,84,224,1,14,233,141,220,13,127,234,101,7,154,102,90,44,54,39,47,21,24,76,91,111,151,220,127,218,194,49,39,75,244,173,174,145,49,67,227,155,245,89,126,104,211,233,21,26,114,145,132,232,246,167,199,231,106,211,125,181,241,114,29,144,232,117,153,55,136,225,5,133,185,106,138,36,43,54,249,183,89,213,79,228,133,175,254,164,119,35,139,133,46,30,123,101,39,193,134,55,55,138,222,182,160,210,146,50,150,178,85,187,210,108,61,188,40,122,252,78,149,126,83,189,87,57,244,255,203,92,81,30,153,84,159,237,150,237,32,29,212,127,59,218,149,235,150,111,224,1,166,202,0,40,134,244,101,205,11,146,203,205,227,12,112,67,138,39,203,212,114,93,51,160,249,42,5,219,11,50,186,24,30,62,173,4,117,35,215,1,24,120,119,55,24,145,78,236,162,227,21,55,112,209,202,227,202,40,254,241,87,20,239,117,200,131,91,241,129,194,9,73,212,179,92,234,111,244,138,227,123,187,65,198,83,156,136,199,47,142,3,90,78,157,92,199,15,234,142,107,144,156,7,128,164,149,198,123,97,163,114,106,190,246,29,52,90,25,8,35,253,168,8,131,247,76,76,35,232,1,153,208,76,82,70,45,227,62,242,51,206,236,26,15,116,144,230,145,111,19,157,171,112,247,161,155,30,227,13,169,100,228,125,155,178,180,237,209,63,28,180,103,90,201,175,110,42,41,172,128,123,245,222,61,167,186,104,112,171,89,175,134,19,53,142,58,161,217,85,150,133,137,199,99,16,242,141,106,159,184,23,236,216,88,23,233,137,153,20,76,47,107,125,177,137,33,124,8,200,119,54,27,73,229,149,202,145,40,117,23,152,122,187,88,67,45,97,179,237,45,252,95,21,125,229,231,247,36,153,55,190,155,196,198,133,15,6,190,122,149,193,161,161,100,122,198,253,116,254,107,136,83,97,102,186,172,251,186,133,116,209,132,14,213,110,62,76,118,251,216,222,86,125,243,128,142,36,106,131,177,242,196,79,197,93,255,89,169,253,193,113,82,117,246,237,240,104,205,244,118,234,74,110,62,57,6,93,76,68,248,157,249,106,17,25,49,82,236,189,33,252,26,7,82,71,252,176,55,88,217,129,71,16,188,92,116,67,215,158,245,208,4,12,15,175,216,76,60,120,57,2,15,242,89,73,185,94,52,102,98,132,150,145,218,81,123,254,59,168,117,183,170,125,5,201,121,36,213,14,141,124,23,233,20,40,252,250,135,104,145,238,91,10,116,129,241,135,235,20,115,13,77,70,40,70,213,41,137,240,108,192,53,103,27,2,78,143,196,107,44,11,216,120,168,159,208,172,161,158,81,115,49,189,56,117,169,141,7,91,154,62,75,175,182,33,17,151,38,32,35,176,182,103,69,26,211,131,199,251,186,168,37,213,195,64,41,90,32,26,90,46,71,76,194,70,45,216,86,180,58,210,24,57,47,20,112,253,89,141,14,98,11,122,87,255,231,123,93,67,170,114,75,207,230,27,182,87,96,32,0,38,86,228,125,112,133,219,161,232,94,246,75,100,202,111,236,46,79,240,36,49,181,125,133,36,125,148,172,207,1,156,241,206,43,85,168,80,95,137,83,201,11,109,154,78,253,99,30,178,121,200,241,70,193,170,85,129,159,151,93,98,206,176,82,252,191,154,22,229,225,41,181,160,87,89,132,126,168,2,210,220,84,110,18,78,70,65,150,214,18,191,149,82,173,189,36,205,129,190,22,148,61,214,59,40,148,38,91,132,201,243,149,148,114,72,234,5,254,145,23,210,9,175,159,239,214,21,113,20,140,126,19,99,213,55,139,86,144,83,169,146,243,53,203,230,156,90,26,125,62,216,211,242,157,58,220,65,49,205,161,102,246,20,234,74,253,237,255,222,255,25,156,174,193,222,218,47,28,247,166,248,249,94,208,174,214,149,29,160,230,201,48,93,214,57,163,31,141,242,131,186,209,176,236,40,241,218,17,215,29,34,162,46,45,218,104,154,69,219,223,73,78,214,104,216,16,181,227,208,70,203,99,209,236,51,154,152,78,62,1,133,93,102,43,167,38,48,203,75,160,0,81,173,72,94,143,41,24,100,118,79,248,84,56,17,50,72,138,122,197,152,158,31,249,76,10,126,200,16,111,120,94,233,57,99,62,69,172,242,235,25,44,98,59,199,73,250,44,245,118,157,88,96,77,189,108,158,68,63,137,172,35,69,221,140,239,233,186,179,21,36,75,237,87,52,50,126,32,23,23,152,219,5,114,189,47,158,78,55,37,252,180,15,204,219,20,215,35,238,194,62,49,225,36,41,201,4,119,153,208,242,87,30,203,35,78,202,171,197,183,251,207,16,184,247,211,35,220,198,163,81,62,59,145,53,245,119,140,195,97,37,133,50,219,28,60,24,105,254,156,36,31,180,237,21,63,222,251,14,210,163,45,8,190,153,219,151,57,132,227,17,211,166,197,66,62,62,124,139,89,111,99,46,185,178,106,122,106,96,103,113,191,24,172,216,180,23,62,18,76,203,112,233,8,231,51,97,239,40,5,158,91,153,93,102,157,139,57,195,170,60,228,52,130,216,203,40,185,40,228,132,113,107,189,255,162,44,58,72,68,130,1,249,166,59,21,242,161,145,77,159,20,212,203,133,73,61,123,166,0,210,31,107,79,21,111,167,74,182,95,226,81,48,234,24,99,222,212,133,159,92,218,188,73,18,80,112,64,192,241,206,146,240,230,127,21,248,98,207,193,198,202,178,167,245,39,117,194,130,214,148,160,167,66,73,104,197,70,177,139,135,196,93,121,20,230,114,5,139,181,132,65,78,75,187,206,137,145,123,149,11,222,115,141,11,133,148,156,134,126,239,22,1,239,148,57,190,106,199,70,64,235,139,60,174,208,248,90,74,232,177,47,46,107,141,175,249,116,48,148,242,103,19,28,44,242,45,242,254,12,137,28,228,208,83,104,49,253,45,224,83,169,93,223,72,101,42,219,33,44,165,209,88,136,238,239,91,251,171,173,97,100,161,254,14,133,50,135,50,204,104,204,28,76,156,133,202,247,62,226,234,75,233,179,1,0,107,157,72,151,159,132,16,152,27,154,98,228,159,11,98,128,47,96,59,84,1,6,238,199,20,154,199,223,173,66,191,43,38,119,246,42,15,16,157,36,181,225,142,131,66,96,118,36,102,37,176,93,140,101,190,108,172,151,211,83,155,28,12,196,85,87,3,94,147,161,5,4,109,13,88,133,27,98,144,106,44,211,252,130,38,251,195,214,102,177,105,45,78,130,238,109,209,77,69,241,146,200,159,53,214,7,122,225,117,63,92,50,138,81,74,18,147,103,235,82,89,77,147,19,57,79,161,192,104,152,49,23,12,202,31,210,71,241,125,91,196,244,58,76,165,209,6,52,108,173,38,75,193,197,2,220,149,123,58,11,190,194,170,194,147,52,100,165,135,61,116,220,88,137,35,100,203,154,134,126,108,234,35,37,187,158,123,208,28,181,201,219,232,137,124,82,82,233,47,53,99,117,41,243,230,255,38,150,112,76,3,230,188,189,100,107,250,59,227,72,16,146,98,204,234,197,192,40,80,240,102,81,218,249,152,253,171,75,8,201,86,24,250,52,144,6,102,175,84,59,196,230,132,166,47,163,237,39,181,44,188,125,103,71,72,9,46,80,209,165,118,41,88,144,130,121,165,182,166,121,170,110,177,201,202,187,97,32,176,90,168,224,188,71,55,187,97,92,190,26,175,180,119,120,144,52,193,174,110,183,223,180,199,48,187,101,208,75,106,190,183,181,95,1,135,31,160,14,174,157,247,20,128,233,110,181,61,99,8,198,90,69,184,105,21,103,146,112,43,67,163,152,41,228,154,211,91,76,181,55,200,54,142,36,153,159,166,76,252,139,150,164,95,252,173,53,119,248,180,228,235,202,127,23,193,163,165,70,104,3,212,246,77,13,193,83,117,51,214,29,113,144,89,64,114,179,223,71,55,79,99,16,91,230,206,156,137,85,75,190,185,192,101,73,147,45,52,254,55,130,39,91,140,109,246,253,137,222,90,139,160,217,169,189,19,215,72,134,164,117,108,185,137,43,102,1,14,58,108,24,141,232,76,205,169,148,226,30,178,19,231,4,159,242,61,127,68,137,232,215,139,90,63,25,182,246,32,190,110,18,75,77,165,224,218,51,93,225,188,230,206,214,157,254,136,190,185,133,208,145,141,252,43,127,159,176,10,155,158,42,83,74,54,163,12,74,119,102,159,81,90,173,120,75,9,101,27,109,125,171,106,152,44,128,242,242,131,192,103,137,37,156,208,107,37,82,203,116,35,26,87,228,66,85,58,71,32,97,99,229,113,211,60,128,101,123,65,28,68,223,206,144,104,234,163,14,10,210,75,248,160,238,19,142,91,70,182,224,121,218,97,41,110,66,67,110,115,46,19,188,101,50,134,54,128,128,49,241,73,110,19,33,204,127,116,92,132,61,58,38,238,134,121,98,145,236,223,87,243,99,107,104,172,232,243,129,181,174,169,137,169,171,212,127,171,238,12,126,246,184,208,226,190,171,7,249,225,231,191,215,11,193,166,109,11,17,54,237,160,107,154,20,115,158,247,64,198,120,120,236,207,238,7,71,4,205,16,27,250,164,115,54,48,119,40,198,251,240,105,163,254,0,101,62,114,190,22,144,253,66,219,42,119,179,4,126,47,71,147,32,161,34,5,125,8,150,79,247,243,63,15,71,16,195,124,85,62,130,138,193,222,199,235,93,40,161,75,207,204,151,37,170,19,173,92,125,182,171,118,87,237,46,47,15,39,169,218,51,134,12,45,41,253,93,21,178,41,231,183,82,62,159,84,109,104,208,165,173,143,75,152,127,164,96,29,165,38,42,168,106,75,67,88,59,163,158,165,56,48,65,251,11,161,162,240,77,7,16,155,151,93,168,147,56,77,87,163,105,224,26,21,44,75,235,89,89,107,99,70,235,230,233,112,70,7,163,60,198,207,242,126,195,26,0,36,37,254,128,248,223,197,11,108,248,177,203,79,28,139,185,1,47,227,69,88,126,206,178,98,172,180,65,101,102,205,55,147,15,155,77,64,134,188,95,66,132,0,253,97,195,56,109,212,121,188,181,123,116,212,213,243,228,182,66,217,144,65,191,223,190,1,224,130,163,243,164,243,12,249,183,236,217,49,201,37,111,253,144,189,132,147,212,210,239,245,110,198,22,65,206,46,120,254,167,81,246,118,247,40,94,228,218,94,125,63,252,129,224,29,172,76,125,230,175,250,76,21,10,70,31,241,221,138,188,124,5,74,10,47,241,143,209,123,221,101,63,81,34,74,229,51,155,157,34,3,35,204,46,52,72,201,132,213,207,2,196,230,188,157,208,225,193,94,192,124,207,175,181,20,88,43,158,120,80,39,24,224,65,59,57,229,149,1,5,200,92,36,53,240,79,174,63,26,85,176,54,226,195,168,105,180,189,168,41,161,219,34,115,196,168,174,17,201,146,183,93,221,207,16,160,221,73,145,161,199,8,251,253,205,157,89,179,185,199,166,71,6,153,73,223,9,200,184,86,158,152,246,176,140,243,212,94,136,77,137,77,156,239,205,86,122,65,129,86,78,98,25,248,131,24,134,104,143,27,55,47,149,149,144,50,42,101,104,7,170,22,138,56,162,58,221,245,37,87,20,242,251,52,73,243,12,207,194,247,207,42,161,228,12,211,152,120,30,49,94,52,139,202,148,63,62,118,59,36,138,222,99,43,48,0,165,61,132,255,137,223,104,90,214,161,119,182,253,195,234,26,32,217,72,48,90,203,42,10,43,169,226,34,90,210,25,222,98,8,130,225,168,196,22,125,252,11,105,3,81,149,174,176,105,117,95,117,9,17,193,86,180,191,95,166,26,75,73,215,112,183,40,211,23,77,108,76,120,181,90,160,146,41,75,80,94,48,177,217,241,17,104,242,75,107,52,158,10,158,240,20,40,188,50,10,41,207,61,110,113,159,119,10,59,146,59,59,131,243,40,154,67,210,130,233,174,153,131,171,127,95,236,250,144,48,103,249,183,103,233,6,222,142,4,23,190,128,65,71,211,149,249,95,82,6,55,65,165,50,250,225,67,89,109,223,79,154,249,219,86,14,35,217,29,112,147,188,230,229,171,104,188,236,34,193,115,136,173,37,6,125,160,46,136,222,242,229,44,142,9,253,27,154,182,93,114,33,14,167,169,143,55,54,10,29,180,107,111,50,18,241,61,184,18,149,127,144,61,18,248,183,150,163,37,24,142,83,36,13,11,105,86,9,84,104,87,172,10,120,82,203,35,91,186,99,13,249,71,148,93,70,154,46,42,212,51,223,43,226,167,241,116,131,72,122,75,156,139,4,26,97,162,118,140,249,143,10,22,134,50,222,2,211,177,142,235,21,168,12,114,117,139,217,215,129,15,135,230,62,7,111,50,71,169,242,142,198,83,222,34,76,58,172,154,215,155,191,162,163,233,234,197,107,184,92,166,154,90,163,57,110,36,201,226,7,197,174,124,239,238,201,61,11,211,248,46,71,29,121,121,158,125,76,27,79,162,218,160,100,49,141,17,11,244,54,162,219,105,65,19,13,177,128,177,166,51,154,115,191,163,0,110,232,35,97,39,63,123,7,66,156,188,106,70,35,183,150,103,240,21,108,203,147,52,76,117,98,124,106,216,196,100,75,102,192,162,97,205,233,96,18,98,77,162,207,91,199,78,172,127,174,102,122,168,34,146,158,176,93,11,56,152,132,189,158,75,84,210,100,134,99,168,243,135,239,200,76,27,115,100,99,77,190,241,91,175,226,121,42,169,96,39,217,78,85,106,213,80,132,179,212,81,91,14,206,172,101,14,72,39,176,245,52,39,99,30,192,115,246,12,48,125,151,224,199,100,60,144,190,252,186,131,161,139,135,30,210,254,148,136,46,54,104,14,213,208,168,105,36,48,252,109,80,117,79,17,241,47,188,210,18,6,48,6,49,208,134,78,247,221,7,77,68,42,138,137,209,64,12,95,138,47,19,11,81,157,142,133,84,16,6,21,74,186,113,81,77,40,10,156,8,46,170,254,246,241,86,149,2,59,9,83,25,177,6,57,0,90,8,5,58,250,1,167,197,197,255,251,8,182,65,203,7,109,200,19,200,233,124,96,161,214,226,225,175,173,134,152,89,64,47,229,167,15,94,88,138,46,65,76,32,73,132,162,75,41,71,199,244,133,87,213,151,129,116,17,86,201,175,131,230,16,79,173,73,193,102,205,67,217,76,185,142,63,230,47,104,78,241,95,169,105,237,100,36,155,98,164,37,141,187,137,14,129,112,94,133,221,246,145,246,203,45,100,170,16,161,163,182,139,173,117,38,200,63,60,32,248,186,112,65,189,120,52,39,203,251,119,87,210,142,81,142,240,248,84,74,251,189,146,139,84,117,205,201,69,166,135,37,183,113,50,16,138,94,126,43,173,19,174,213,60,61,63,211,174,123,106,140,128,210,246,54,26,165,46,130,158,253,160,199,68,161,97,46,111,54,97,170,245,78,214,44,28,8,17,127,90,37,24,88,42,121,239,255,220,101,28,105,51,205,64,91,23,16,64,176,181,240,26,89,138,158,214,66,152,147,66,128,95,141,144,51,13,152,236,10,252,41,4,216,40,136,12,202,12,33,27,158,52,63,11,196,216,207,254,150,37,47,5,38,10,88,53,236,85,61,193,55,12,84,232,74,182,32,15,59,2,201,67,96,198,163,188,227,186,252,84,124,187,232,245,151,142,192,45,79,8,103,47,101,225,11,45,84,216,253,240,234,202,254,99,64,6,14,173,75,177,241,117,99,5,154,129,134,177,117,74,187,127,141,97,70,80,204,233,176,108,218,112,155,215,132,238,99,74,20,243,87,135,146,227,36,169,12,246,234,148,91,215,119,97,217,90,140,150,155,36,80,40,11,223,173,120,132,1,43,125,106,207,21,39,200,250,54,173,4,95,91,5,249,216,251,223,22,90,234,30,172,151,179,24,244,16,134,214,172,236,12,75,233,44,12,128,205,101,12,89,13,255,177,187,66,28,15,121,201,5,179,37,69,58,174,194,135,214,174,201,87,26,83,103,149,194,13,87,68,91,66,98,196,179,41,6,53,181,140,189,123,151,163,81,190,164,24,1,164,119,168,168,37,71,205,180,13,67,18,48,200,17,42,104,44,138,15,76,103,11,76,101,9,207,118,5,184,63,67,127,10,169,105,1,215,202,12,176,225,152,169,53,221,217,179,189,29,113,237,243,217,71,238,165,189,139,22,140,68,29,28,209,173,74,129,132,100,244,118,51,236,234,3,139,101,92,214,10,228,166,57,18,171,92,111,240,20,46,187,156,22,204,21,166,193,230,197,189,212,46,3,245,221,215,53,219,26,171,182,41,68,18,143,241,74,179,93,91,206,193,116,13,236,190,226,140,41,81,90,2,56,142,225,144,95,235,206,21,38,13,201,46,233,100,206,14,75,192,143,191,85,253,143,89,21,165,224,3,51,50,115,35,173,187,22,125,61,122,165,147,52,148,147,9,52,111,129,159,123,104,167,11,43,112,216,89,78,147,28,35,199,220,199,14,194,164,3,88,101,211,200,90,173,81,98,17,59,121,198,64,31,7,171,18,247,121,139,40,224,166,126,114,12,144,25,224,92,143,110,116,224,121,17,243,1,28,105,207,101,122,132,250,90,75,211,16,200,65,187,208,56,56,180,9,197,240,166,58,120,56,163,13,205,77,52,50,143,90,217,142,214,179,8,57,105,160,187,232,226,241,105,47,163,193,195,62,190,55,75,226,164,217,73,177,175,19,109,178,148,105,64,126,231,125,133,207,65,215,160,230,252,86,3,154,79,206,172,18,150,9,214,218,35,151,100,103,175,165,233,7,230,54,117,243,128,6,206,235,30,22,217,155,62,36,54,46,166,14,144,176,61,88,1,228,190,186,15,77,121,3,43,76,74,191,205,164,115,102,232,158,12,104,106,144,196,63,165,175,50,173,145,109,26,99,75,90,207,187,159,115,19,10,58,119,175,243,215,128,55,166,3,253,239,36,217,23,233,114,88,227,98,201,112,82,250,99,113,229,254,207,47,78,52,152,199,173,93,61,125,142,47,177,178,74,144,243,171,194,196,241,158,232,75,127,192,235,157,16,56,42,1,102,209,124,228,195,19,224,11,63,202,109,60,222,151,178,29,62,181,116,136,135,54,28,147,198,4,179,8,209,185,212,48,202,23,177,252,241,81,91,61,55,20,146,213,46,165,241,103,109,10,121,31,203,234,225,94,115,233,41,15,27,17,226,227,152,173,43,247,219,184,136,102,83,218,230,166,19,83,189,36,175,80,220,138,245,250,229,196,137,66,209,85,28,250,133,189,243,27,249,171,240,3,249,188,132,109,131,107,144,234,250,250,237,11,252,103,149,116,68,133,92,75,4,70,74,181,217,58,79,111,31,161,208,150,97,29,72,114,204,212,88,98,193,31,250,161,177,156,149,188,95,75,89,38,121,37,173,176,70,29,137,104,121,168,55,235,29,72,113,172,163,148,96,26,79,49,239,3,251,186,250,190,76,226,150,174,79,164,177,83,178,229,176,34,166,86,50,2,150,100,132,17,147,155,55,71,210,116,198,19,123,138,249,136,202,56,149,114,160,252,5,225,206,240,163,74,27,226,204,254,233,146,177,100,213,147,100,4,21,147,131,82,22,143,255,88,234,210,120,58,137,86,35,230,248,26,194,90,32,252,242,58,134,56,33,33,89,37,230,217,180,45,148,217,248,176,205,61,175,185,104,220,222,87,246,219,196,123,200,151,103,93,65,196,170,69,223,156,110,112,147,163,123,118,27,153,125,122,84,28,42,146,221,205,253,196,222,178,224,190,18,39,13,68,3,216,133,153,33,34,129,89,219,140,160,128,131,29,170,149,202,157,165,88,56,237,176,134,16,192,252,127,49,217,238,46,231,175,174,207,5,139,88,3,163,179,161,218,13,75,124,63,229,180,149,191,103,104,127,183,88,41,1,78,105,50,106,163,137,179,41,31,86,45,24,179,106,1,57,60,85,89,214,121,29,181,132,79,140,89,108,197,173,26,141,53,3,80,85,88,43,49,67,79,187,95,74,82,73,242,130,63,50,118,125,213,177,236,136,57,45,33,178,210,237,131,102,119,209,125,102,122,10,229,138,83,130,121,117,216,245,131,158,168,217,213,95,7,149,164,97,241,39,121,14,66,29,119,57,174,180,30,126,85,48,18,168,142,7,152,187,84,134,2,114,224,16,67,181,124,227,197,88,239,248,125,41,215,28,132,46,172,249,52,221,121,145,62,30,157,236,160,223,60,37,6,155,201,95,135,108,32,10,3,203,250,185,182,112,232,80,194,133,88,22,9,239,86,12,241,151,69,31,109,98,91,91,43,43,253,138,110,66,102,93,55,205,204,255,225,4,11,203,80,153,204,222,51,178,38,4,29,42,199,7,75,200,217,22,29,74,237,234,106,27,197,213,3,5,53,17,24,116,194,127,19,3,205,62,79,97,38,242,162,99,45,250,118,121,47,131,174,158,11,180,193,32,75,181,53,217,105,228,43,203,126,173,205,177,11,30,54,25,117,10,19,64,193,80,123,45,6,15,31,81,168,75,146,236,231,244,131,53,159,95,117,162,182,178,60,139,227,185,89,115,252,56,167,184,212,93,173,32,240,84,184,122,224,160,4,53,197,101,72,7,89,180,112,90,62,154,140,176,36,133,204,143,95,133,233,88,46,213,185,115,167,186,157,55,84,229,246,187,190,176,201,55,242,232,227,109,51,117,80,150,172,152,27,182,32,114,124,13,167,3,11,114,53,9,109,10,142,85,11,73,45,237,248,93,223,106,84,21,33,252,236,84,11,7,65,124,37,134,36,171,89,174,17,82,9,52,40,164,170,167,71,243,185,236,51,169,170,90,154,167,23,103,158,38,176,152,161,237,119,165,15,166,141,228,90,42,204,240,107,136,13,141,29,45,207,122,159,50,240,130,78,2,54,161,26,32,71,177,169,185,255,217,212,145,179,151,97,5,45,95,120,110,98,53,177,251,58,147,3,53,165,254,182,29,174,50,70,245,21,207,100,249,15,60,122,11,25,212,216,177,13,87,38,9,34,248,73,109,59,38,231,215,163,106,90,250,232,81,203,223,99,35,125,48,52,102,50,169,31,38,124,227,62,212,16,65,20,148,15,138,55,128,43,126,23,134,186,159,53,215,70,127,191,115,10,254,92,231,133,71,11,251,81,246,153,186,233,249,17,135,250,66,243,84,222,227,31,129,140,253,118,221,214,239,198,230,120,194,133,95,252,72,242,153,110,30,149,131,239,112,235,53,90,159,158,141,12,231,220,183,0,139,253,83,238,189,231,35,24,131,239,84,217,131,232,155,131,236,36,213,172,1,76,128,228,119,210,193,190,14,190,133,184,24,138,246,144,225,48,57,192,166,132,237,179,109,60,47,103,174,84,34,179,77,227,127,160,175,11,187,206,118,64,168,230,226,27,78,105,164,74,198,239,133,28,28,181,206,181,101,245,108,199,213,105,247,50,90,30,114,192,243,250,229,198,152,53,238,138,224,96,37,212,23,212,132,231,226,130,54,105,225,176,86,131,224,95,194,85,164,7,46,152,11,233,181,32,159,11,212,148,208,253,179,69,148,24,223,190,251,188,71,111,22,111,162,96,32,227,4,24,139,105,185,49,79,225,73,21,95,154,40,67,35,93,105,227,117,10,63,167,179,111,102,63,93,60,59,201,143,215,152,9,253,123,218,42,4,141,199,43,148,122,56,7,251,46,225,114,129,201,220,14,122,81,14,214,138,158,187,154,226,209,77,116,166,9,138,187,185,97,197,37,232,235,35,143,192,249,210,228,231,255,45,70,54,252,206,190,86,29,141,239,167,73,220,53,9,19,203,141,150,3,92,59,0,68,211,50,162,94,215,143,181,234,164,8,101,136,27,64,150,42,227,136,141,152,28,105,17,74,56,72,16,208,17,126,201,140,127,149,218,55,249,123,218,87,50,245,90,151,206,36,37,230,218,30,252,136,152,37,131,216,234,249,192,203,222,41,179,220,206,58,2,214,211,188,72,153,171,239,76,65,79,158,203,225,19,227,25,170,107,98,32,24,15,101,95,64,68,143,249,19,31,31,52,227,194,1,170,162,193,87,251,115,163,202,60,243,17,5,219,91,38,139,138,232,130,2,118,135,12,25,42,227,20,26,84,164,177,7,85,61,219,132,134,161,162,186,33,102,210,29,103,35,174,203,196,125,122,30,148,6,78,155,100,114,52,236,79,220,93,142,99,96,232,3,145,202,81,40,85,185,220,28,176,79,239,52,24,186,205,25,211,103,112,50,61,65,182,170,164,110,105,86,168,246,219,32,150,100,102,91,190,121,107,97,171,214,65,104,185,126,79,27,218,252,132,43,17,13,173,101,244,135,60,57,25,146,38,1,240,156,0,56,112,127,65,1,86,57,142,173,247,146,4,19,81,81,123,89,233,105,1,166,91,5,86,213,253,92,75,190,170,182,102,84,92,76,69,85,205,164,53,72,245,85,188,89,148,246,6,68,252,163,162,8,66,132,4,20,83,37,208,67,92,185,250,154,77,171,204,51,81,153,153,201,174,242,119,172,189,145,129,253,202,203,82,176,158,159,146,77,19,219,90,239,32,88,57,84,24,251,242,208,84,242,162,49,135,122,109,207,96,246,58,202,206,249,67,10,96,246,158,29,185,161,228,9,249,20,60,207,141,89,24,144,207,42,24,246,31,92,105,7,87,99,5,198,130,18,101,176,48,186,203,33,230,189,51,180,28,213,203,50,154,240,192,171,61,205,247,101,5,91,214,131,175,193,10,62,253,30,185,83,191,2,208,115,4,114,57,244,249,41,159,22,60,125,183,72,70,20,147,91,252,131,224,84,190,26,70,171,33,125,83,112,183,105,182,63,5,196,160,177,49,80,123,238,174,61,9,0,194,109,55,40,29,33,55,214,72,130,239,160,113,36,125,131,189,48,186,95,118,57,167,111,25,34,187,47,130,179,96,69,50,29,176,246,199,239,101,40,132,37,36,245,219,232,19,48,180,99,48,132,249,228,169,184,232,46,165,127,81,165,128,179,104,56,202,179,249,49,76,69,58,250,231,126,11,37,222,92,32,222,233,60,4,24,225,93,190,211,3,84,215,88,167,93,24,133,235,251,164,201,70,184,175,22,253,167,78,183,52,244,220,57,32,120,173,255,175,235,37,60,177,127,51,82,58,116,67,247,161,127,238,255,240,165,90,169,189,39,61,65,26,243,215,148,131,18,153,125,210,240,144,88,132,18,41,67,80,106,47,177,204,84,201,86,108,205,87,211,110,201,126,134,85,191,223,206,182,163,224,96,50,185,242,120,81,240,85,154,212,141,37,88,94,156,25,117,32,180,131,16,126,94,25,84,59,213,26,196,208,124,47,74,107,126,32,244,174,19,124,65,122,101,251,149,171,167,166,167,145,56,140,158,35,187,102,191,82,82,106,158,67,214,215,92,182,79,67,142,74,208,228,159,250,88,149,120,3,6,138,83,174,200,108,245,223,55,64,159,38,98,17,175,178,50,190,75,165,64,202,210,251,129,12,51,109,136,81,10,186,220,219,209,7,114,14,239,45,231,79,211,176,49,238,225,34,195,245,113,170,74,183,198,195,247,147,45,32,218,151,204,178,9,84,139,254,187,14,81,127,232,36,102,245,148,199,43,244,245,69,112,168,179,135,129,81,252,219,84,75,80,141,215,143,231,91,187,120,218,233,208,214,96,2,236,150,216,114,209,181,81,168,143,208,226,241,220,171,187,104,254,124,87,214,1,253,194,99,36,44,213,61,9,241,10,253,179,35,65,25,2,231,168,250,56,253,159,34,139,217,113,28,245,135,169,160,72,194,178,20,160,7,56,158,69,190,195,43,189,69,142,254,172,65,27,161,19,186,34,162,62,76,33,142,209,208,52,125,234,88,46,156,22,171,28,134,190,106,6,100,157,60,53,38,237,163,58,98,167,118,68,139,134,88,90,11,232,13,152,234,226,90,43,254,179,10,22,53,63,177,89,119,103,228,48,221,119,148,252,126,193,206,133,208,76,117,52,162,199,132,61,169,119,68,224,71,202,149,125,18,73,253,234,255,150,122,115,104,104,191,11,201,234,127,5,193,247,197,18,103,169,229,22,43,16,189,10,20,65,235,200,175,191,133,80,102,38,99,60,30,188,121,117,180,45,0,2,225,251,255,125,221,84,125,149,183,158,62,109,57,203,229,107,144,147,125,129,37,208,11,123,134,62,244,19,216,90,4,105,67,56,199,35,188,111,202,28,67,172,123,170,8,32,129,111,227,90,209,14,128,24,206,126,234,237,177,93,103,166,96,87,215,109,64,69,162,150,112,173,67,225,79,152,81,32,121,164,244,148,87,233,168,35,8,41,236,120,87,253,62,182,253,53,51,114,72,249,43,160,47,62,55,43,77,223,61,180,196,222,217,18,175,31,60,112,80,208,186,29,189,201,93,92,73,242,181,28,39,51,163,102,117,8,183,124,76,191,151,113,8,54,89,113,81,186,100,113,127,237,38,32,232,123,154,103,115,172,73,121,93,26,132,131,234,163,69,152,252,23,142,118,170,175,20,206,115,99,37,33,103,210,92,213,212,86,177,153,0,57,164,60,4,177,142,137,220,158,204,40,132,243,180,10,140,109,30,243,115,126,63,194,227,125,195,93,235,157,143,245,43,77,27,137,131,109,93,109,34,77,88,132,155,70,230,91,87,19,240,237,232,54,228,107,76,9,214,2,64,175,231,217,172,56,49,117,160,167,225,244,213,140,112,191,123,175,94,102,243,237,246,73,31,125,137,235,59,10,231,1,201,126,19,201,35,232,155,224,238,19,7,192,56,33,138,70,185,202,54,209,229,137,107,4,184,71,25,205,76,147,153,86,32,9,25,171,64,190,199,86,126,254,21,253,50,167,227,81,245,244,173,27,180,222,114,160,158,201,235,165,32,38,157,192,155,240,19,245,87,1,97,225,150,228,116,88,64,4,242,206,62,172,100,189,27,195,226,221,50,168,115,178,18,168,24,180,197,89,70,229,44,159,124,26,204,117,225,143,104,160,132,48,200,36,249,229,76,156,148,24,236,120,0,77,14,113,30,31,83,98,7,168,154,119,186,39,128,127,204,17,178,14,78,223,40,72,217,221,26,2,62,39,218,63,37,182,86,154,134,106,163,170,65,203,171,179,91,136,162,237,24,198,98,5,76,233,45,60,18,238,225,144,184,70,9,95,138,121,224,125,53,85,13,82,113,68,48,93,203,81,32,78,114,152,254,183,160,131,179,128,162,229,7,185,193,31,101,138,243,25,164,63,165,187,88,240,252,238,167,57,199,241,150,120,114,21,222,82,216,96,200,165,250,130,192,166,119,98,240,81,108,216,138,74,82,125,2,80,161,236,136,83,182,97,229,72,168,46,156,223,110,108,254,245,177,238,151,16,20,146,239,43,185,218,144,213,220,143,189,19,149,197,159,116,223,62,160,158,225,126,193,252,14,21,165,44,202,83,216,255,135,57,247,204,208,28,7,179,87,137,235,32,208,195,107,116,233,124,193,23,178,221,192,139,210,10,197,196,102,185,179,6,131,161,199,148,203,178,175,200,58,220,120,247,79,192,136,184,141,182,38,250,90,157,192,138,118,135,7,152,109,243,231,129,217,192,120,43,60,89,42,239,251,229,187,159,87,104,231,129,124,225,162,242,190,79,227,63,9,91,175,204,83,182,147,82,253,42,237,39,184,124,7,33,113,44,73,252,78,110,10,14,73,105,223,183,17,216,114,31,117,178,119,12,12,58,113,15,162,251,90,48,116,232,232,138,55,60,125,59,175,229,141,50,4,53,107,238,160,241,130,104,224,215,108,189,50,72,215,63,83,225,53,75,125,76,48,135,132,239,63,86,125,67,200,155,176,65,209,75,139,138,26,64,247,213,148,75,27,72,191,212,238,81,82,242,176,94,131,64,81,65,119,243,199,2,238,232,104,211,171,245,222,12,255,9,237,200,18,233,72,185,94,214,110,50,64,37,74,72,71,112,57,91,252,151,90,140,158,219,46,74,255,147,167,44,206,87,150,43,4,40,87,50,246,111,50,165,253,4,39,41,33,40,32,194,43,103,242,235,187,61,224,144,113,91,21,198,134,79,237,95,135,44,174,184,143,70,127,204,134,238,40,199,10,37,152,83,252,99,172,133,189,154,212,152,195,9,167,142,170,17,54,12,254,35,76,115,179,72,81,126,82,16,97,73,153,111,87,90,191,87,220,92,11,202,223,87,183,101,139,179,43,198,112,36,249,103,20,192,21,103,124,26,91,100,90,233,43,179,241,14,220,248,89,137,137,224,14,92,49,189,22,141,134,241,15,81,38,198,134,139,68,192,213,149,213,191,138,244,118,236,56,152,30,194,255,174,198,202,219,16,136,159,52,243,122,163,48,252,246,28,39,127,25,186,54,126,168,108,31,168,42,114,228,240,235,2,196,175,27,112,114,143,63,72,194,68,40,125,117,145,74,129,179,193,246,236,164,142,178,88,190,93,197,5,173,87,137,51,231,214,201,177,160,3,203,144,159,131,43,110,55,166,101,155,194,115,53,104,163,232,100,85,105,238,1,249,151,66,234,9,112,105,188,118,70,196,18,130,145,116,209,41,56,64,27,66,140,144,96,63,243,84,20,185,186,51,214,247,8,211,211,182,213,133,224,36,248,54,121,184,140,241,223,93,139,47,127,162,35,187,6,42,21,60,114,167,55,67,79,70,185,19,64,15,94,85,136,236,146,0,231,174,145,115,77,145,66,1,209,229,83,101,34,45,112,115,65,169,98,173,118,165,253,92,53,155,94,97,6,101,37,160,52,171,77,34,231,21,185,9,54,42,221,1,100,179,160,131,30,238,43,32,69,99,20,211,80,207,87,30,149,102,175,48,11,164,136,216,18,130,61,211,126,104,61,198,205,162,59,243,78,237,57,198,127,237,124,53,244,84,66,20,36,238,33,39,249,237,6,208,68,161,239,247,137,110,250,104,178,234,0,146,19,226,254,64,81,3,199,198,113,202,250,0,108,2,137,148,8,144,253,76,220,130,28,80,33,84,246,250,195,241,25,188,233,55,112,114,242,254,114,11,223,251,6,225,34,171,43,40,5,205,25,126,141,166,87,1,11,178,233,117,156,42,238,74,15,82,144,169,19,84,232,16,13,57,137,160,211,54,13,152,20,63,27,119,250,53,66,53,22,255,160,59,255,192,101,68,249,37,190,104,241,216,77,64,70,103,145,114,244,207,110,217,86,248,145,172,229,82,27,72,48,74,154,162,245,88,187,242,25,252,162,231,29,217,215,222,21,248,176,247,19,190,120,49,214,198,0,20,29,155,223,58,199,39,221,248,156,62,133,241,239,100,35,221,75,61,206,2,230,150,33,199,161,145,198,41,215,125,216,188,64,73,53,88,81,50,217,4,39,68,87,233,169,104,236,207,36,139,79,55,212,164,81,211,19,158,30,135,179,107,149,217,3,136,24,109,125,103,67,129,89,129,85,135,229,127,182,153,128,196,179,81,226,169,118,126,92,51,162,85,66,70,226,173,248,245,227,237,176,61,249,115,152,240,187,157,147,55,235,111,67,15,195,124,101,48,87,242,172,15,91,43,58,254,166,37,144,68,231,226,215,0,11,184,173,105,219,74,47,3,181,134,212,175,219,182,2,171,133,213,143,168,105,161,6,159,130,220,157,164,213,32,191,124,83,231,154,166,110,98,98,38,169,187,246,80,235,135,14,21,131,64,228,214,171,47,197,124,27,71,126,21,6,53,173,155,181,137,236,11,49,54,248,179,243,216,175,14,114,16,227,45,103,205,112,6,19,20,72,14,186,201,204,133,158,204,73,26,115,143,176,1,194,192,69,68,119,190,163,159,221,214,138,138,128,190,96,134,52,173,166,74,108,165,33,169,136,73,89,141,158,240,104,109,253,219,15,42,162,92,225,229,174,96,179,165,138,223,73,133,40,83,171,242,151,213,138,245,220,3,235,202,67,113,96,58,119,59,230,47,77,76,102,226,237,76,78,55,190,118,94,233,92,122,214,186,75,226,82,157,213,200,229,92,41,250,213,221,89,2,110,66,40,225,147,48,81,166,167,175,209,233,131,88,233,223,160,225,176,242,228,118,23,154,70,130,174,91,68,232,59,35,241,80,186,188,197,246,246,6,17,80,67,149,21,195,191,250,14,46,178,94,198,240,184,212,48,191,248,81,78,216,78,50,80,185,107,65,174,12,140,66,160,73,42,87,192,29,176,71,86,243,228,22,69,2,94,120,6,224,44,222,71,146,18,77,132,105,18,218,86,107,53,84,54,140,156,153,220,239,65,72,151,175,197,199,207,224,86,161,217,208,203,95,44,203,214,114,117,95,195,223,8,70,107,22,42,8,210,244,101,153,109,42,220,181,3,201,154,57,125,111,102,46,139,130,101,73,113,124,107,45,153,47,49,78,31,207,89,21,179,114,46,194,101,89,249,136,36,124,238,142,43,242,252,249,100,215,64,94,131,113,198,226,233,14,114,33,223,13,9,239,59,112,187,218,63,115,210,235,7,84,241,213,160,122,207,111,126,195,54,212,144,95,84,99,47,203,119,208,212,123,92,103,198,156,132,171,7,69,241,249,41,39,175,243,43,73,230,176,132,224,172,239,253,243,234,143,245,186,83,223,32,138,19,22,173,175,7,84,241,97,185,3,204,225,6,85,168,20,174,73,31,162,217,255,82,194,185,209,210,20,195,245,224,229,13,182,153,6,207,223,195,21,29,39,6,242,0,246,114,36,85,91,157,52,63,98,108,27,141,92,174,235,200,27,159,16,152,50,240,117,195,45,217,134,209,165,82,122,217,44,81,236,70,92,55,97,51,3,176,192,75,159,243,146,111,234,66,93,111,128,250,137,98,39,67,101,81,157,152,35,106,104,126,135,253,167,178,249,187,8,185,203,220,244,132,99,234,61,220,46,85,157,135,46,130,249,128,181,226,209,130,38,147,228,116,19,226,210,45,74,132,133,29,175,219,183,180,124,73,129,187,13,109,179,156,85,77,82,166,127,159,218,171,99,150,83,40,64,139,37,164,229,228,115,85,255,50,147,81,81,107,112,192,104,61,236,237,120,14,161,223,86,47,225,254,42,254,173,158,98,247,46,236,9,255,15,159,199,214,233,25,215,236,221,54,230,235,56,168,210,204,175,100,140,16,103,123,41,95,7,201,147,145,197,236,24,128,163,109,93,11,236,72,49,73,138,72,32,57,96,143,209,115,98,21,162,167,97,70,213,252,186,18,249,135,180,82,201,114,244,200,144,139,181,174,84,88,16,41,156,118,21,56,140,100,78,71,252,9,33,48,4,245,57,96,115,124,81,201,78,240,119,214,79,47,52,234,89,241,115,110,117,236,57,107,46,182,184,215,32,215,14,250,65,139,160,37,168,15,53,100,109,149,67,255,15,5,58,60,120,146,75,232,135,122,197,143,225,126,80,29,181,13,33,28,186,100,87,53,5,26,247,177,56,210,77,239,94,184,222,166,120,253,172,78,43,207,103,186,176,77,176,136,229,133,7,152,187,93,173,115,147,41,166,151,229,6,185,8,243,64,213,161,71,173,248,252,241,98,244,2,59,87,84,18,220,36,255,26,174,44,184,203,30,79,148,26,193,101,110,41,95,228,102,27,214,90,116,221,234,211,48,151,238,153,64,110,36,202,220,222,64,248,140,49,118,94,164,67,49,37,219,104,213,119,35,153,157,227,207,143,62,112,24,78,152,109,35,167,222,104,126,101,30,243,162,66,48,104,114,121,1,99,185,69,57,159,122,171,88,228,160,113,75,69,81,87,140,250,46,166,86,104,49,131,137,215,33,176,161,130,173,5,128,223,37,248,175,154,30,59,141,29,37,186,105,36,124,55,125,74,190,83,65,60,1,59,176,181,93,28,168,140,70,84,223,208,190,14,35,45,72,75,35,127,126,198,4,206,166,238,208,144,166,25,21,202,148,239,85,92,3,194,151,196,61,230,177,253,64,206,91,111,40,192,177,57,89,101,84,126,186,198,79,39,202,86,33,163,159,165,79,104,115,92,52,100,149,186,95,108,58,252,100,151,171,125,215,184,120,167,135,227,232,122,185,239,136,16,215,97,27,61,179,255,126,118,203,228,15,246,139,160,127,198,210,195,28,242,63,214,116,156,169,140,146,15,249,0,165,33,92,85,232,157,30,80,107,165,172,186,32,189,241,31,153,233,241,148,128,136,248,23,125,12,237,179,13,65,82,209,87,14,255,123,157,103,103,129,242,110,229,69,171,181,63,227,83,101,4,122,42,183,210,72,251,208,172,219,122,40,114,77,225,42,109,238,88,47,234,148,141,206,19,36,83,34,117,145,179,162,109,34,138,178,241,194,17,78,104,176,78,69,128,0,90,152,211,185,88,141,131,226,244,55,39,151,130,245,150,218,168,175,206,134,94,167,3,245,14,69,180,14,203,129,20,252,26,84,247,6,43,79,87,102,56,82,236,15,233,84,71,187,45,151,77,173,129,144,115,76,86,189,37,80,237,74,79,204,134,207,41,75,93,225,129,247,129,119,231,81,119,28,226,104,137,194,250,155,34,105,183,201,54,109,58,249,87,142,162,192,249,113,156,212,182,98,74,199,230,252,176,119,19,161,89,24,105,188,124,104,190,119,102,136,153,58,72,128,202,198,198,38,195,112,120,99,201,37,176,232,46,159,188,18,44,221,172,127,8,154,89,1,100,188,235,69,214,89,99,88,13,60,246,151,242,249,2,89,145,35,210,118,227,229,238,95,22,38,77,117,50,199,253,243,17,51,87,26,105,222,229,14,129,207,137,174,64,195,206,177,203,223,96,232,122,83,120,170,109,214,129,169,28,151,116,223,117,135,130,141,2,122,13,208,253,193,135,28,99,102,109,254,49,126,47,160,100,5,126,67,21,252,239,39,244,18,215,75,252,75,26,82,56,173,181,237,238,52,4,138,59,238,210,192,68,6,223,155,245,235,161,184,157,200,214,91,77,71,188,18,255,82,168,167,24,93,248,33,127,25,199,31,26,235,127,86,252,25,111,41,44,53,21,48,22,248,113,36,52,219,235,238,87,185,129,242,222,9,249,224,159,143,51,41,191,193,38,150,65,74,26,42,193,253,204,84,139,145,63,253,46,15,117,205,131,97,13,238,19,178,83,145,148,245,167,242,8,103,227,197,137,253,106,221,7,12,64,133,48,143,83,117,91,123,52,4,149,139,86,67,66,172,158,64,31,216,111,245,149,254,249,80,4,137,250,32,238,248,10,81,219,154,128,89,13,22,255,114,245,208,72,191,44,145,121,198,82,159,244,177,166,254,136,218,166,251,112,37,169,132,202,60,187,254,225,246,162,239,200,208,214,127,107,228,191,192,170,210,236,195,95,123,95,94,83,48,195,183,242,232,76,112,106,233,141,71,36,88,102,167,1,247,169,202,39,122,250,49,26,69,140,232,206,199,187,110,190,234,108,197,24,48,177,99,155,229,118,205,56,87,137,121,46,46,197,255,20,157,131,31,254,9,209,155,198,170,119,201,171,188,247,32,177,247,135,23,124,209,185,183,149,104,32,64,225,77,74,85,64,124,154,254,61,178,35,44,31,101,187,251,193,29,65,193,140,69,21,85,81,9,14,150,244,182,223,13,196,171,15,183,230,107,145,6,69,252,43,81,252,187,95,167,134,238,85,153,88,132,68,69,45,232,61,35,226,99,83,226,171,225,169,12,113,130,65,51,46,120,223,39,233,113,140,49,167,118,190,44,255,160,62,49,2,61,225,94,12,103,54,189,123,59,96,181,120,48,175,230,59,193,82,44,86,154,222,166,134,42,164,192,64,101,246,122,17,58,0,176,213,30,189,143,183,15,180,144,73,186,39,139,16,13,30,249,147,72,74,228,108,105,34,198,161,63,8,154,204,73,44,159,196,14,6,0,124,31,32,243,213,4,76,12,89,200,224,80,229,142,25,226,43,126,239,66,60,85,161,195,147,171,191,70,86,109,179,211,124,168,171,75,77,100,173,213,158,86,96,123,252,243,41,225,214,190,71,122,163,88,151,68,193,176,4,45,86,244,145,218,80,215,170,102,110,130,154,67,180,67,166,117,81,235,184,161,50,145,66,181,145,217,45,229,76,222,207,53,65,130,150,171,216,80,37,136,87,162,181,232,99,40,190,52,110,144,52,149,186,203,249,241,216,199,115,26,12,198,192,210,59,160,127,231,184,158,65,68,208,203,104,225,175,153,191,226,34,34,0,79,25,198,247,122,24,34,67,160,56,202,23,255,84,209,220,161,2,5,251,19,95,149,43,241,56,108,246,5,73,234,29,182,63,123,128,225,236,103,50,135,3,90,189,28,141,160,54,182,185,73,26,157,172,69,100,139,237,229,151,156,0,119,231,188,185,100,230,110,149,127,248,138,63,115,128,198,129,7,18,217,105,222,11,57,191,215,159,167,55,86,40,229,191,196,64,234,175,155,36,178,215,128,71,121,116,139,170,248,159,19,105,195,197,50,160,164,214,92,204,23,243,198,7,86,13,173,211,253,220,100,66,130,117,238,239,141,106,112,127,163,99,52,147,238,100,124,67,115,41,61,134,228,207,116,57,190,197,147,65,184,97,56,77,47,151,227,130,70,141,252,191,60,177,138,163,184,121,105,164,113,139,236,89,65,69,148,187,214,153,231,234,225,61,242,148,212,103,236,0,145,128,225,81,252,153,199,254,141,190,1,217,94,6,254,236,139,96,75,216,228,61,0,218,157,207,24,101,176,112,114,218,249,235,157,190,77,75,78,69,178,207,80,149,60,201,120,151,121,65,124,89,240,201,77,185,143,70,79,216,195,155,97,4,116,193,180,52,155,202,87,21,66,118,12,37,127,218,92,57,49,244,136,243,130,181,124,26,222,172,121,139,163,167,119,251,25,189,124,255,78,23,223,43,88,235,97,244,95,118,130,97,252,32,216,197,213,62,134,69,233,152,103,217,33,166,120,32,205,2,1,74,196,183,112,20,177,17,68,158,66,255,159,240,164,18,109,151,94,153,144,2,45,16,95,152,86,157,52,185,130,51,99,183,240,204,175,40,48,75,10,157,241,18,203,163,64,225,41,90,242,166,128,67,96,25,238,145,205,159,162,190,96,81,50,124,120,219,74,176,227,24,223,3,137,139,20,170,55,151,1,13,135,236,27,29,75,250,202,229,198,236,55,169,184,94,195,165,185,38,177,58,17,160,236,232,38,170,138,164,188,131,225,82,57,230,78,26,229,205,202,241,145,236,19,78,181,132,237,131,41,55,11,76,198,191,136,177,170,119,39,243,147,191,254,252,8,160,20,237,149,2,238,79,255,124,129,210,112,248,234,39,255,146,8,225,46,212,231,210,175,148,41,21,234,55,55,3,248,102,99,190,97,50,144,26,244,121,37,231,165,62,65,50,129,6,41,59,193,207,155,32,101,148,64,254,92,200,172,59,144,7,154,76,130,229,166,101,250,40,162,88,174,69,92,98,209,34,170,247,80,75,140,219,192,32,226,84,217,216,84,192,106,87,135,155,177,196,94,117,65,178,91,45,220,182,41,148,156,146,12,229,68,254,134,102,15,81,131,237,62,255,190,36,9,117,130,91,40,9,213,237,169,106,142,78,212,173,213,239,133,41,228,210,56,98,210,172,244,196,239,38,235,25,198,202,237,141,24,44,92,236,39,48,85,49,87,174,95,119,229,135,180,97,202,116,129,150,17,61,105,177,208,239,61,150,253,92,244,181,123,166,130,4,59,104,15,167,169,1,149,93,205,124,199,129,197,254,43,254,40,78,57,201,106,125,119,69,56,224,156,72,75,35,28,6,179,188,129,96,93,134,80,110,214,116,68,143,171,92,12,109,128,231,239,128,189,87,144,215,25,42,71,144,79,187,103,2,41,36,30,151,109,127,149,212,112,216,170,248,121,223,144,129,92,35,13,58,15,149,68,59,141,30,245,34,48,71,223,206,178,105,25,9,8,64,118,94,244,213,3,95,207,142,164,82,251,160,29,151,86,82,198,83,227,213,57,67,25,160,140,30,196,242,9,42,153,170,218,21,184,7,55,53,105,159,223,161,76,211,191,62,98,163,69,158,107,105,162,55,126,37,81,0,56,40,252,56,113,233,128,174,49,169,212,3,251,60,163,123,12,176,190,175,130,50,169,220,14,12,11,55,233,222,186,180,46,208,56,201,131,84,216,127,45,11,255,27,175,243,197,144,103,192,156,125,164,16,3,34,111,177,25,48,147,22,85,164,118,174,27,61,54,72,142,155,180,155,25,65,58,80,115,152,105,25,101,37,88,24,48,118,24,212,68,189,81,1,214,200,8,208,248,82,94,139,144,228,50,135,58,136,25,187,254,13,126,41,214,98,158,129,110,27,66,76,216,94,241,143,167,2,109,170,171,139,53,220,108,239,214,249,185,23,163,52,26,156,82,187,60,54,164,51,180,90,49,177,234,145,193,38,78,113,98,195,68,252,183,109,223,204,156,163,125,188,177,71,15,181,222,158,88,32,12,95,226,214,216,153,122,38,182,180,0,171,80,186,127,48,34,178,88,129,216,196,121,110,228,203,100,229,147,254,229,79,7,44,125,94,49,163,6,93,188,20,208,243,179,131,199,222,142,61,244,118,88,2,2,39,75,90,124,202,204,16,142,157,69,65,156,187,166,155,136,73,36,63,160,225,166,63,185,96,7,31,208,10,182,191,225,110,13,6,210,53,104,169,207,181,203,131,138,50,128,159,148,142,205,23,161,224,128,155,161,205,61,78,115,195,20,39,239,71,130,69,210,104,57,251,252,166,54,32,105,229,88,161,16,40,93,144,161,132,96,150,253,102,237,190,30,41,107,238,82,120,231,95,238,62,106,143,82,202,130,37,13,113,48,60,98,124,89,82,183,142,211,250,35,215,94,34,176,51,129,16,205,53,137,204,134,144,243,140,46,183,19,72,175,125,186,169,148,183,219,244,15,41,145,182,1,186,74,191,189,130,191,117,46,121,7,5,11,30,128,90,73,60,41,214,137,88,141,188,235,71,93,215,252,187,111,212,240,34,87,145,245,131,221,220,169,60,33,211,139,121,201,208,76,193,184,192,82,228,118,215,223,211,64,130,66,206,212,22,203,90,99,61,249,120,3,88,218,0,98,42,29,172,52,42,208,220,122,132,217,118,21,47,199,202,164,146,45,126,3,82,153,82,219,46,11,185,95,28,92,118,9,226,219,175,80,35,113,104,115,250,204,57,111,37,102,60,79,134,241,78,174,23,99,97,134,157,234,197,106,187,73,154,33,198,213,221,86,30,56,170,95,20,248,203,94,94,193,134,185,180,60,225,68,72,78,243,112,87,22,62,105,217,180,236,9,234,119,43,102,76,241,255,177,97,110,172,9,43,4,105,31,165,104,56,51,18,201,240,75,184,69,63,6,29,213,170,17,116,98,111,5,20,139,194,157,191,234,79,239,188,58,244,136,25,47,236,206,239,170,108,24,240,170,89,228,21,103,172,6,160,221,234,238,23,86,26,137,56,95,165,220,158,169,155,204,72,234,147,175,198,112,143,192,102,20,200,104,236,125,89,48,106,164,224,139,142,60,225,172,199,15,20,19,209,99,85,160,200,188,29,193,138,136,108,140,27,170,164,214,41,239,129,209,238,160,161,12,55,132,237,2,162,190,213,246,52,172,227,197,160,156,33,156,142,177,53,116,217,35,150,72,39,109,243,189,162,16,200,65,156,112,174,216,162,93,220,77,0,150,159,89,5,184,230,102,96,27,30,148,141,168,76,174,101,205,79,172,238,163,215,67,232,99,95,67,89,158,65,247,104,99,190,64,224,76,127,47,150,186,219,219,6,163,14,49,8,147,135,78,253,70,97,36,96,63,43,75,229,96,236,187,110,142,174,202,184,13,100,153,121,130,102,203,196,45,113,145,127,168,184,111,87,45,160,150,214,172,154,232,6,129,144,205,215,142,164,102,168,213,41,185,54,97,103,249,239,97,99,45,168,186,234,161,190,130,193,128,175,150,162,210,210,152,211,249,42,108,149,215,190,166,10,203,125,146,140,211,22,128,25,104,111,149,160,187,213,176,172,187,17,158,83,38,252,128,104,6,233,46,68,88,67,198,85,251,225,171,132,186,63,241,29,16,113,83,107,231,45,29,227,22,123,67,137,162,137,43,229,245,8,119,68,93,129,133,192,184,10,103,179,115,182,27,8,59,99,186,220,170,14,145,168,58,96,149,185,237,24,149,149,132,110,129,60,152,25,13,123,253,203,21,42,149,28,84,248,240,16,33,114,31,88,129,118,175,134,216,96,76,157,161,184,173,5,205,185,66,151,56,25,160,105,104,208,76,253,8,72,169,16,61,226,156,226,243,180,114,214,175,216,186,35,198,187,101,114,173,125,78,36,225,85,93,54,105,46,161,34,122,71,61,96,172,112,60,208,53,166,139,173,233,20,33,211,161,162,172,162,4,215,233,36,181,181,14,87,198,198,230,213,37,239,214,157,75,166,216,245,120,156,112,55,2,99,168,66,29,74,134,56,7,119,96,33,30,32,120,134,28,90,172,55,12,32,165,137,23,80,93,134,143,40,168,90,98,65,82,140,26,52,161,213,101,184,205,45,128,72,28,118,12,148,40,44,248,162,119,119,254,143,65,66,139,33,49,11,213,124,12,134,209,5,121,61,209,67,222,74,19,30,99,170,154,109,111,211,16,68,97,73,9,106,63,48,134,217,92,142,255,243,202,151,248,115,86,230,184,31,190,226,25,84,32,28,109,99,9,252,60,56,142,175,97,105,248,92,219,115,241,170,115,102,61,90,150,115,104,185,216,1,55,254,195,194,212,181,192,143,100,162,113,46,212,3,254,98,37,166,73,241,61,246,96,100,18,168,62,68,22,245,92,241,52,14,32,106,249,149,110,198,45,18,244,96,143,21,126,171,24,22,168,98,206,118,146,215,13,245,51,75,236,179,154,72,7,248,179,6,50,139,176,49,155,1,229,22,53,135,201,122,208,32,146,106,110,111,212,178,253,52,144,52,52,157,208,153,176,16,252,255,235,128,217,110,172,58,38,104,211,36,254,11,179,41,253,112,217,54,150,167,120,41,43,74,167,243,236,181,115,155,61,84,111,204,180,10,66,170,58,55,110,149,167,222,14,84,96,239,248,151,93,192,143,134,134,159,98,231,71,242,50,137,24,113,97,37,108,132,239,245,76,50,161,37,80,61,237,250,232,246,128,176,193,67,65,207,254,48,190,74,160,197,91,197,116,4,135,78,139,196,111,191,34,131,147,137,26,196,79,82,104,132,139,158,22,203,56,186,129,107,135,187,23,106,11,28,38,181,123,31,64,105,30,75,253,223,178,221,95,129,21,144,91,205,186,121,127,104,121,161,71,61,207,98,1,46,196,113,43,110,177,103,63,221,135,100,18,204,52,99,41,248,127,96,130,5,55,92,138,155,159,47,105,199,69,238,207,255,67,73,108,237,192,140,142,98,218,65,238,189,0,87,186,96,2,53,232,219,0,188,90,29,178,53,167,4,93,9,246,106,220,10,78,52,131,14,198,21,209,242,187,142,189,170,246,62,102,226,142,203,16,66,192,169,34,220,252,244,157,179,62,250,107,37,61,227,144,179,162,134,154,78,21,45,5,156,140,174,118,224,27,80,61,245,152,149,74,173,49,19,60,82,151,238,185,174,10,24,196,78,213,40,80,125,197,24,19,206,202,62,84,184,236,211,21,167,221,156,196,162,221,11,22,176,216,243,154,36,39,218,229,221,206,32,17,22,71,93,51,17,74,50,110,83,86,92,21,99,222,164,21,76,74,195,222,7,108,184,48,10,231,141,250,84,140,89,232,182,143,189,252,75,162,249,0,126,156,173,247,65,127,44,33,111,133,200,87,208,89,187,169,116,150,2,80,31,141,81,142,31,202,242,238,27,109,178,201,191,85,218,253,98,157,226,12,139,125,168,22,240,113,66,106,101,6,169,66,108,115,61,96,224,39,139,188,3,104,177,0,124,35,203,187,2,33,186,222,247,194,202,96,233,132,204,200,158,92,240,194,39,218,193,197,24,114,234,228,43,110,219,197,252,159,116,130,139,147,202,30,194,58,229,123,144,240,35,109,12,58,119,255,144,136,139,91,243,65,103,42,229,120,231,254,69,42,211,105,180,130,255,244,236,10,123,166,166,163,57,163,224,91,86,100,106,172,59,234,178,101,155,145,123,156,51,246,90,67,87,149,224,158,57,252,0,16,59,154,201,98,45,185,160,112,105,189,214,150,35,119,247,137,42,148,249,242,230,184,174,120,32,130,36,105,89,20,69,64,222,135,191,26,149,168,65,248,137,112,158,188,138,172,236,8,141,64,55,54,138,238,244,32,142,218,243,174,225,186,228,55,64,23,149,116,84,7,249,31,41,229,117,99,85,224,218,29,173,61,170,140,183,25,48,23,25,53,38,247,179,32,64,110,171,12,232,152,156,216,122,10,192,132,123,119,150,207,80,124,98,135,224,138,215,109,86,21,150,183,217,119,174,50,168,28,255,15,32,35,102,225,39,17,59,49,217,88,93,80,253,118,121,84,197,171,101,108,229,167,107,255,130,30,168,153,250,150,229,48,152,25,179,77,32,243,167,168,108,87,187,11,135,53,153,13,26,100,130,251,45,160,182,171,188,160,6,207,246,160,91,82,189,176,78,86,89,154,243,94,124,167,65,68,84,234,243,37,168,252,116,42,26,49,6,39,150,211,148,254,3,31,38,151,187,160,155,238,16,12,236,143,70,151,69,31,175,125,10,124,49,154,85,25,171,36,85,235,52,190,123,115,37,124,174,203,201,154,39,58,36,38,106,53,90,175,126,195,206,151,139,40,163,83,76,91,97,188,36,45,251,133,90,84,120,145,163,169,210,81,222,195,66,172,170,30,99,10,221,211,88,159,161,19,210,118,157,79,80,111,45,34,255,112,107,49,72,151,183,97,100,213,105,219,42,54,142,157,54,193,53,53,61,56,7,52,135,236,207,207,212,113,10,227,234,191,255,209,133,222,171,98,187,71,62,185,174,146,140,157,28,70,106,201,165,48,210,242,60,66,178,71,108,211,118,87,136,61,190,135,63,224,112,79,8,121,162,41,229,197,124,21,20,114,146,182,172,37,185,16,53,156,208,173,161,40,175,19,148,150,233,230,12,170,206,243,92,227,202,25,171,144,219,246,20,64,210,31,50,74,111,195,154,123,137,25,105,17,193,198,77,5,155,202,39,101,83,222,55,12,177,81,16,220,41,220,41,100,63,148,48,170,251,51,29,249,235,14,84,117,39,203,206,201,22,187,237,74,219,12,127,215,232,163,185,218,134,10,68,122,221,125,223,114,97,129,74,140,121,167,199,100,182,132,242,247,239,126,226,248,40,75,131,49,162,240,195,220,220,191,221,143,203,215,191,34,95,39,244,62,29,77,6,18,88,3,60,10,231,53,5,79,64,108,165,68,129,47,124,17,102,163,194,10,145,185,148,53,197,153,113,223,175,109,38,56,143,181,157,130,247,66,138,14,199,141,178,208,200,99,157,218,203,150,137,226,220,108,196,199,205,10,168,27,223,33,92,54,71,0,144,250,194,248,46,2,78,141,234,55,243,73,17,161,38,60,246,243,9,7,198,39,79,60,183,127,136,6,189,174,22,36,253,111,197,9,53,88,114,56,100,30,37,127,99,40,132,27,170,217,29,32,36,23,139,241,121,132,241,230,227,250,150,188,126,186,12,156,107,204,237,184,70,170,1,18,97,160,193,146,176,46,18,29,210,19,67,33,34,17,107,76,189,33,190,34,21,145,99,18,93,29,22,194,10,215,207,17,27,110,139,144,68,80,172,189,159,29,180,32,130,236,98,190,33,188,28,153,166,230,117,212,130,49,217,110,176,21,118,17,53,62,106,222,241,232,187,43,145,52,206,5,112,119,180,153,247,204,111,14,143,137,169,73,123,151,3,56,38,203,130,74,181,198,192,79,135,157,237,115,132,177,83,234,104,210,7,87,0,222,108,65,108,198,234,68,239,92,227,194,210,212,9,73,33,67,50,193,123,173,44,130,124,169,151,76,209,157,65,30,158,84,252,131,19,111,91,47,70,50,193,139,131,172,45,134,77,214,22,54,132,145,89,158,181,34,112,117,175,232,82,39,138,208,32,83,197,110,42,143,56,93,223,120,127,190,78,139,16,115,218,168,40,136,100,139,46,211,11,67,59,139,113,186,38,69,138,89,242,101,104,145,140,243,154,221,207,176,85,177,113,33,199,16,180,98,65,207,231,121,159,243,185,127,22,43,152,246,121,173,60,221,190,249,108,44,7,101,3,12,45,41,211,67,168,189,12,199,190,92,1,180,14,246,251,102,202,210,166,228,113,150,119,110,4,46,194,129,85,48,118,202,64,104,237,70,196,230,154,229,221,119,187,134,47,253,87,42,219,42,78,158,62,251,110,207,110,42,167,201,169,224,180,166,90,172,78,211,101,133,208,109,31,155,95,37,193,132,182,254,102,251,136,23,153,113,207,253,40,254,238,34,62,190,49,136,117,172,255,10,104,226,81,250,67,127,38,8,51,79,218,100,63,85,67,205,235,224,49,103,57,104,203,187,30,236,226,163,188,168,181,241,79,67,71,165,103,71,49,193,215,150,51,38,207,2,81,50,252,116,226,44,156,62,68,56,208,221,77,38,177,60,91,195,47,122,68,211,71,11,45,198,38,131,42,239,221,32,195,6,168,34,255,81,162,97,123,95,213,223,130,76,160,40,113,7,231,136,100,123,46,108,109,59,22,21,125,63,37,126,56,30,251,142,206,245,83,204,181,56,176,187,240,189,116,59,244,207,76,175,21,49,121,177,251,84,79,49,226,133,255,135,38,134,103,137,90,80,245,148,42,22,157,163,106,64,208,151,234,56,85,11,86,215,207,189,197,18,200,47,37,168,243,220,237,151,122,220,85,195,172,226,66,188,135,164,30,190,25,23,199,115,76,164,198,168,99,69,1,205,242,13,15,112,71,226,58,50,100,147,220,51,148,105,109,83,184,57,49,214,97,29,104,240,17,55,217,73,79,8,96,74,227,255,227,154,215,142,197,35,10,31,56,172,34,250,205,77,8,107,23,234,36,223,34,67,17,219,235,159,121,39,242,248,208,43,75,150,120,4,213,178,164,138,151,172,167,233,19,227,149,206,231,117,169,18,109,157,196,92,80,14,171,46,124,171,213,58,67,9,152,212,93,234,222,37,179,87,104,244,93,177,227,90,14,63,109,251,12,126,34,158,108,129,193,146,15,61,10,201,91,9,214,79,133,94,195,16,80,178,124,94,29,61,174,179,252,191,250,60,59,60,217,26,238,87,247,47,229,204,114,27,67,182,39,73,244,49,67,112,95,177,154,5,61,92,205,11,2,156,30,34,106,180,47,33,67,159,0,119,171,127,210,21,17,72,80,16,7,88,60,216,181,231,198,117,22,163,6,112,165,93,199,19,43,66,82,178,189,145,232,58,106,178,105,227,166,18,71,160,62,85,232,232,39,9,111,165,171,33,77,227,20,91,79,191,45,153,248,28,7,242,33,157,171,233,162,29,246,251,170,244,172,178,178,194,27,192,43,151,238,209,180,155,176,221,216,185,170,205,204,12,75,112,128,99,73,179,168,103,115,237,156,189,83,140,97,96,90,142,223,55,181,134,107,221,173,205,161,57,248,49,29,136,89,154,6,167,219,212,201,185,42,206,8,188,90,48,76,26,45,199,28,47,125,103,80,102,181,202,224,33,134,28,72,104,197,17,159,161,150,244,237,62,211,210,42,166,146,79,81,140,252,214,168,32,219,54,191,215,59,212,204,44,58,200,170,14,174,236,157,48,30,221,192,252,149,237,144,39,6,46,214,220,58,193,150,165,55,46,74,19,219,73,33,3,11,66,185,116,246,217,15,194,9,60,121,46,18,151,60,89,205,163,14,110,2,114,7,15,181,9,122,39,161,179,35,9,49,243,203,49,125,165,227,160,48,208,55,232,127,150,31,51,250,213,15,228,62,90,227,232,57,64,32,215,103,253,19,67,195,30,127,54,97,220,85,171,18,224,113,45,191,29,84,104,232,105,74,50,189,56,211,31,18,219,186,47,180,65,188,188,21,101,189,50,129,88,161,177,151,164,59,139,189,41,69,191,36,232,171,130,87,230,87,186,252,90,231,209,239,237,145,28,179,80,52,200,244,30,73,235,184,27,207,53,123,175,227,46,100,167,203,130,84,46,102,11,112,158,0,13,28,75,228,129,140,11,195,155,67,221,86,121,21,193,106,150,83,236,255,120,225,215,94,228,32,182,150,81,231,185,246,73,146,125,105,210,76,175,83,75,172,235,182,72,27,7,54,79,102,205,190,131,76,127,91,76,103,235,126,174,147,8,248,163,134,131,21,252,3,142,113,155,210,231,37,72,137,95,182,240,122,214,24,76,43,204,178,168,211,79,86,102,48,1,213,127,212,135,33,123,202,153,67,113,188,118,99,22,90,165,237,114,92,129,97,55,182,25,114,246,52,52,79,223,91,23,78,112,60,103,25,139,130,100,223,53,247,170,24,77,243,158,191,18,44,215,250,249,245,178,143,168,52,220,51,235,152,134,74,19,23,34,173,247,36,50,83,70,157,5,160,228,15,26,106,31,139,7,218,86,32,65,176,5,96,96,189,201,95,21,69,222,4,248,236,115,163,125,172,164,14,106,0,61,167,73,94,164,81,231,223,187,20,142,24,187,124,162,185,182,165,128,103,213,212,82,156,40,12,174,71,229,173,25,72,170,121,203,184,236,13,19,10,166,123,166,115,154,86,193,19,119,144,33,71,2,60,134,239,227,88,44,177,212,212,180,107,123,48,24,100,123,91,121,1,85,153,45,74,234,137,28,47,84,233,85,190,211,239,255,29,87,161,28,230,67,99,166,82,88,4,124,151,144,225,62,71,94,20,150,221,239,230,243,183,137,65,99,225,126,194,14,236,39,72,218,219,33,69,246,255,251,89,30,205,43,208,84,51,132,81,150,16,246,49,105,210,225,164,68,26,2,100,221,241,164,196,109,199,39,124,75,218,163,51,123,52,143,184,3,216,176,48,160,88,139,208,26,76,24,32,115,57,136,174,227,208,177,26,146,137,128,20,241,114,76,133,145,122,160,233,158,181,139,87,132,149,160,9,169,241,138,245,18,151,186,254,40,208,88,60,0,159,183,229,44,236,61,200,109,113,193,88,200,24,253,245,110,136,189,246,206,151,220,243,3,223,11,228,91,45,67,67,241,205,4,226,169,143,102,53,110,95,15,216,192,194,95,0,146,253,245,97,40,70,244,100,42,11,52,214,71,118,104,186,168,148,47,222,180,10,102,186,6,63,215,176,127,82,236,60,89,70,93,83,74,193,132,252,199,239,84,94,92,33,137,66,111,187,122,132,196,42,159,251,74,14,129,88,144,23,237,4,226,167,185,244,154,141,235,226,247,196,63,232,97,135,46,65,1,58,111,73,3,151,197,28,103,124,67,139,168,159,195,81,229,115,75,49,67,43,229,169,109,221,15,248,208,34,241,51,194,128,147,247,192,111,63,41,246,207,12,199,138,89,232,128,24,234,181,134,38,50,223,53,84,212,9,106,145,93,124,186,87,33,80,52,130,243,157,103,118,148,112,182,210,35,102,98,54,61,225,71,144,231,100,35,98,254,201,144,156,13,183,247,193,195,30,77,243,111,77,0,3,234,16,176,244,112,149,120,109,151,61,91,244,125,105,169,157,245,40,165,226,174,183,199,161,138,160,184,173,224,179,160,120,138,244,151,12,182,36,164,38,49,105,70,18,38,252,169,183,188,28,57,210,27,77,76,141,135,153,59,194,144,84,128,34,4,208,213,39,154,66,199,136,129,200,46,203,103,66,214,146,108,54,28,214,115,77,170,119,123,18,221,202,157,68,232,161,56,22,4,118,176,197,122,30,132,42,137,130,149,165,57,146,4,9,35,250,31,151,255,188,75,37,45,236,0,74,74,228,94,117,35,221,95,79,209,86,45,163,40,191,143,166,86,181,220,22,212,18,245,93,247,102,150,188,188,24,252,41,255,194,165,229,43,204,238,37,26,158,190,197,58,196,211,188,211,95,194,134,148,240,219,91,174,49,193,165,211,43,144,63,142,238,174,151,217,63,155,255,45,40,198,217,37,204,174,154,245,215,192,214,46,195,62,221,117,99,105,31,115,125,37,15,42,161,222,134,248,3,55,69,49,103,115,34,186,162,70,9,188,151,35,13,174,169,162,189,198,21,224,119,10,240,25,12,215,42,242,208,124,176,10,119,240,93,39,49,155,204,55,47,247,26,146,45,143,0,4,158,237,48,148,1,109,205,198,237,13,44,47,16,3,166,225,207,237,213,53,65,21,7,184,249,164,16,91,51,184,36,144,248,81,136,172,89,136,185,16,218,83,28,180,248,127,228,254,99,147,251,44,139,105,114,230,10,62,198,27,62,181,53,91,51,183,198,21,55,55,167,167,135,6,65,37,203,249,11,134,129,47,255,9,245,20,92,117,4,12,233,67,213,24,190,136,179,88,120,83,144,179,10,176,175,95,9,239,132,172,7,107,218,225,144,83,244,156,20,170,12,234,216,67,61,168,197,232,86,80,156,136,119,134,16,142,107,17,120,81,154,156,118,124,223,82,104,159,121,114,196,75,13,78,142,43,109,32,213,171,11,27,98,205,132,209,244,38,99,126,75,45,12,112,66,86,126,69,27,125,244,120,206,70,108,90,198,222,246,34,205,49,113,222,134,3,113,51,200,96,122,144,5,251,105,207,205,103,191,167,0,127,11,182,223,202,20,241,217,51,51,149,74,56,9,242,162,80,214,150,111,23,141,139,199,106,4,18,238,19,183,233,132,117,63,10,232,139,52,157,216,107,231,227,15,99,116,138,56,131,220,154,196,86,233,131,123,158,252,7,42,203,90,191,16,162,31,2,58,195,70,45,13,191,16,51,32,66,154,164,56,30,177,50,254,87,153,233,225,132,5,115,69,125,129,9,104,25,29,198,86,191,14,226,90,167,228,189,162,147,55,243,140,254,241,188,185,189,131,18,145,125,219,166,196,240,76,233,117,167,109,157,255,231,64,39,42,254,28,143,115,3,54,120,216,100,62,195,27,233,252,134,236,168,63,95,74,199,250,228,217,21,215,136,177,160,122,98,237,53,71,133,8,156,87,36,103,96,57,145,174,146,218,51,127,148,176,228,164,204,196,81,169,68,49,233,54,132,142,7,138,209,60,237,32,231,122,87,24,60,153,203,27,91,173,60,26,43,151,78,226,125,180,242,128,245,79,160,222,222,251,186,144,208,6,179,118,89,202,225,158,205,57,248,94,214,188,48,20,194,43,114,202,215,173,131,120,113,154,196,233,242,19,159,133,48,61,195,251,223,166,89,241,74,60,101,19,242,250,14,83,30,143,111,3,34,236,6,54,9,136,126,233,182,72,91,2,56,129,214,209,160,208,99,248,46,135,243,217,237,163,124,63,229,184,65,165,227,183,31,8,218,36,130,226,43,251,21,121,130,190,89,217,178,147,64,107,121,239,243,43,150,111,47,162,199,251,194,54,128,106,196,206,148,80,193,32,180,108,27,72,123,223,169,237,60,148,162,111,2,36,12,225,91,158,63,41,131,207,142,229,217,142,182,177,1,222,131,242,54,233,65,245,29,119,112,116,97,46,173,131,227,132,152,195,27,66,134,79,241,34,219,234,8,65,65,233,96,52,196,228,7,84,87,255,100,230,224,105,152,2,249,217,131,63,52,121,32,166,165,30,183,149,41,183,70,179,28,205,132,154,55,180,60,55,138,32,136,138,244,187,111,29,157,227,46,152,122,8,33,215,31,6,230,5,90,148,66,162,8,27,80,24,97,128,33,224,197,159,159,78,137,46,234,226,244,245,195,74,149,130,54,76,215,108,61,114,145,210,192,100,214,60,36,234,99,5,230,57,253,91,139,13,74,65,227,252,48,89,218,168,80,183,121,74,234,32,21,168,169,182,114,92,174,215,211,118,164,123,76,105,231,32,217,96,56,26,80,60,190,147,75,145,64,111,185,190,227,118,85,152,159,121,221,176,249,111,150,203,171,206,237,253,84,173,73,146,136,33,112,201,136,168,87,155,216,58,84,204,205,237,129,133,131,61,64,199,153,213,149,129,255,34,49,73,190,188,35,156,122,133,39,157,210,78,17,147,124,181,30,49,196,67,83,43,166,148,167,115,116,74,177,31,86,149,184,163,41,118,193,188,151,15,196,50,186,37,90,205,20,16,73,147,77,182,197,175,99,122,124,157,162,212,32,183,88,88,6,81,199,176,46,64,195,20,225,137,194,234,48,181,45,232,255,75,249,111,54,236,144,50,23,253,173,7,16,145,154,34,188,150,171,118,211,69,185,221,220,123,148,27,87,174,208,132,221,78,92,133,61,148,179,143,132,95,78,95,54,152,32,210,189,147,252,185,7,152,108,127,207,50,121,46,153,147,37,134,196,36,143,67,193,249,80,240,248,185,162,113,203,12,203,115,198,231,128,242,204,155,0,64,253,122,235,135,44,104,2,227,144,184,50,65,39,209,139,201,97,204,135,72,0,14,246,62,99,221,242,54,90,212,85,55,20,112,206,212,151,37,2,139,56,190,219,226,123,109,84,145,54,165,106,241,28,111,66,148,229,234,238,133,25,35,111,48,158,230,244,145,113,209,252,252,3,11,81,98,27,253,70,214,224,109,39,28,167,46,123,125,182,85,8,249,237,160,231,80,48,84,182,163,237,212,107,1,0,77,242,21,82,229,121,15,93,148,238,6,227,239,52,135,70,159,224,9,66,104,130,57,221,157,41,23,77,115,69,142,157,229,66,47,7,171,67,171,100,199,119,64,108,91,122,108,212,83,57,112,176,246,232,145,205,178,51,124,246,42,160,88,245,135,41,138,78,176,50,121,133,55,43,213,30,216,114,233,171,43,85,75,29,66,16,211,34,88,134,15,191,102,99,211,145,173,22,106,3,159,60,224,128,21,97,105,169,25,104,206,151,21,240,3,134,1,125,196,167,17,129,25,115,42,176,18,189,248,234,248,223,8,113,217,121,17,20,11,65,48,124,213,155,178,16,79,216,20,166,85,246,138,250,216,74,255,147,186,10,28,6,187,139,33,180,247,51,183,85,0,106,242,125,168,190,127,225,151,74,37,16,59,135,49,62,49,107,222,142,197,140,39,180,108,121,219,11,61,245,43,17,250,219,210,147,196,150,242,242,225,95,219,19,222,96,134,84,105,76,223,51,238,26,231,172,175,215,36,82,109,78,204,179,87,19,13,58,185,229,132,232,90,75,231,38,178,175,90,240,174,112,140,212,79,221,142,151,114,95,221,223,95,131,157,60,20,70,214,242,82,131,171,57,44,207,253,237,49,147,62,17,237,181,142,192,179,183,238,27,179,230,225,23,21,210,40,228,74,86,214,135,102,139,85,45,11,159,234,210,21,235,130,71,233,104,70,14,231,196,76,73,87,86,55,59,89,182,150,24,126,60,190,56,30,156,91,182,150,59,192,89,15,133,26,77,9,42,203,106,238,254,118,191,31,55,228,64,233,87,180,58,107,160,229,197,129,14,12,78,68,114,224,176,74,24,8,70,219,193,242,178,95,72,18,202,245,206,33,193,197,81,53,53,113,33,194,212,9,252,5,46,144,230,115,79,6,157,245,29,26,49,130,194,214,239,38,58,119,155,129,69,17,214,188,198,158,238,162,189,134,195,101,204,217,46,155,34,134,180,213,92,84,38,143,200,245,169,218,52,157,171,142,91,77,193,225,50,37,230,112,206,227,162,237,33,228,44,177,80,44,56,19,20,54,176,99,206,93,126,44,206,171,104,4,140,217,69,27,122,9,119,64,194,79,127,200,1,108,225,186,127,185,102,193,155,217,90,39,167,115,216,164,40,46,84,166,124,36,249,161,17,3,171,20,2,8,110,115,36,131,50,3,212,0,139,173,25,11,40,64,223,17,41,66,150,173,135,49,144,154,5,185,65,29,34,51,78,61,41,184,251,46,47,139,192,40,26,140,234,223,245,142,29,174,33,181,176,210,134,15,156,62,38,57,22,223,40,160,155,38,37,24,16,145,75,70,35,219,29,0,199,171,27,129,23,130,47,24,42,109,46,9,15,12,73,97,204,44,110,226,115,254,113,192,150,238,84,10,220,208,125,123,254,115,67,10,85,21,50,198,221,117,183,211,194,35,200,120,60,26,153,149,251,0,31,254,119,65,228,201,145,2,71,238,133,192,216,251,152,134,154,33,255,197,80,79,74,252,174,18,97,132,216,199,71,87,82,6,241,47,175,119,168,110,241,20,160,191,61,118,25,124,224,205,220,150,188,160,59,8,232,88,90,11,90,150,203,241,222,231,229,67,73,211,137,187,73,205,144,94,68,158,218,194,48,58,1,121,241,105,54,171,43,145,29,137,131,188,153,154,57,70,128,204,133,157,156,165,157,4,5,126,183,179,85,83,133,217,226,209,236,181,234,116,190,220,100,80,101,189,188,146,249,193,244,240,85,117,26,227,242,78,70,87,90,237,227,173,102,70,87,151,230,209,230,128,40,209,9,232,156,213,230,75,37,98,14,84,49,79,47,252,40,172,238,120,63,241,32,10,61,239,165,118,6,14,35,59,244,228,174,32,4,58,134,172,2,39,22,228,151,131,159,226,26,92,151,56,41,153,20,13,163,40,145,135,36,158,218,150,185,44,169,82,147,146,183,161,251,196,182,170,178,13,212,102,12,11,86,73,250,182,246,6,249,44,97,19,35,238,235,3,242,36,176,80,111,184,247,136,202,33,236,28,255,34,96,177,255,55,38,154,110,40,251,227,56,121,106,144,171,12,175,128,104,194,98,216,248,49,237,63,100,5,192,165,66,34,158,55,39,155,27,224,140,161,31,229,17,159,20,151,149,19,150,154,30,196,112,198,155,7,224,155,89,145,160,73,185,21,66,248,255,18,64,85,187,198,91,240,178,99,207,97,89,252,204,42,72,122,228,143,235,9,180,40,62,71,151,140,168,162,40,130,34,86,60,168,117,47,119,219,143,106,198,165,239,244,119,242,19,94,254,0,237,100,40,201,142,161,221,111,68,231,223,129,116,203,44,102,32,115,100,179,27,237,72,187,111,70,85,175,0,223,43,68,98,75,181,171,236,210,110,122,101,93,85,128,147,44,88,37,106,80,122,129,68,16,237,37,127,93,184,26,155,231,155,132,90,80,190,55,28,119,142,91,0,70,63,115,146,191,3,177,66,67,62,209,242,165,137,13,231,40,117,25,237,229,250,187,172,5,112,212,225,251,119,168,221,111,242,26,4,90,125,70,198,63,216,200,127,241,105,99,36,10,36,195,126,6,130,212,86,62,38,236,36,1,79,215,20,130,110,208,168,96,180,43,199,182,146,244,217,137,41,40,199,153,208,134,176,166,95,175,115,163,34,217,178,104,234,218,164,116,52,215,155,70,42,243,140,126,26,77,62,105,163,101,20,97,85,44,124,102,209,146,217,137,84,136,98,74,20,156,201,33,163,237,177,109,65,111,167,32,4,234,26,40,125,95,193,34,0,117,43,53,164,64,3,180,68,3,237,54,178,132,165,16,82,13,167,153,60,229,210,177,207,228,236,145,49,104,80,213,88,113,237,189,39,18,205,49,77,95,95,106,86,23,193,78,40,115,226,162,77,252,84,70,153,8,47,54,116,132,160,64,28,14,252,144,39,15,146,230,157,194,232,78,52,38,23,72,172,199,217,111,254,71,87,84,187,79,233,8,225,140,79,169,30,226,136,219,191,229,147,130,51,75,151,93,253,129,238,205,244,56,134,10,66,87,27,243,241,41,138,25,196,194,47,236,22,147,127,87,81,134,102,202,81,26,225,227,67,65,248,165,179,99,115,54,238,242,190,77,98,12,169,248,185,244,69,28,126,220,140,3,218,218,47,30,71,9,253,202,159,33,193,54,208,54,136,45,23,76,12,43,86,111,157,51,194,25,245,40,97,217,120,232,94,112,27,163,23,211,101,190,203,142,214,51,188,30,151,83,76,101,84,46,43,125,231,229,99,14,181,135,110,74,211,56,28,163,18,43,233,51,193,54,27,57,168,95,195,156,46,21,50,233,70,150,198,142,245,50,39,201,182,221,243,155,137,29,38,26,164,217,71,166,153,16,46,148,225,220,115,212,150,224,194,85,6,141,160,77,1,205,139,197,233,52,136,66,78,114,2,197,173,51,214,16,250,111,219,171,50,100,241,234,173,169,72,132,31,36,99,116,47,88,90,61,196,48,133,16,43,113,240,169,45,200,79,110,221,113,179,163,189,107,228,175,210,102,15,158,96,19,181,253,225,228,246,46,42,48,209,233,145,102,60,204,69,86,245,47,11,28,202,30,251,16,64,205,36,208,106,35,90,17,77,154,20,206,49,148,12,4,100,115,98,255,148,75,45,243,21,28,244,181,186,52,192,5,102,193,198,82,48,170,212,3,250,25,247,86,19,160,94,150,7,98,32,200,59,138,79,144,81,140,113,243,104,167,215,64,237,243,80,112,198,253,205,198,71,247,86,101,187,41,130,80,37,148,88,150,166,192,105,28,88,85,231,198,84,22,109,59,136,89,238,213,77,16,235,100,6,178,86,45,194,139,94,117,191,168,226,70,141,236,196,156,94,134,246,207,133,107,155,210,232,208,116,110,199,123,174,215,79,230,100,102,211,138,231,100,155,57,97,68,178,201,72,100,2,83,0,150,134,75,83,104,153,88,241,173,200,126,166,46,109,96,248,31,212,66,179,44,181,45,231,27,248,233,199,29,8,71,251,138,226,1,97,23,30,12,110,113,121,170,4,73,90,136,97,98,215,110,225,105,72,108,34,164,127,237,119,160,57,111,61,218,135,87,113,178,35,244,151,156,179,104,118,84,39,43,253,242,28,177,191,225,245,75,229,177,153,141,186,27,251,214,74,115,4,226,207,57,153,243,4,27,187,219,155,56,157,222,9,11,184,74,219,56,20,167,37,10,208,122,130,148,104,172,100,131,151,216,78,134,234,10,27,223,139,60,237,179,248,0,157,129,155,156,237,239,69,240,39,233,224,12,215,173,234,136,244,57,246,233,152,138,119,228,25,121,175,3,37,152,124,255,241,34,223,255,122,153,204,242,199,123,220,88,79,47,49,14,114,123,159,86,79,56,48,27,98,60,52,219,42,170,118,49,11,30,52,104,126,22,101,159,114,235,164,47,235,108,85,189,98,67,6,167,206,34,240,216,34,91,16,167,214,38,73,88,33,148,1,113,225,26,173,196,116,183,221,161,57,86,112,200,224,204,229,244,173,137,30,156,133,126,44,127,183,175,164,104,6,39,52,21,107,5,19,5,29,74,246,185,234,87,169,30,88,59,252,240,252,89,187,166,7,48,244,253,107,90,79,131,5,211,51,120,212,31,15,102,3,24,89,85,157,235,79,21,217,205,237,231,223,133,142,29,132,32,233,147,145,9,171,50,136,132,10,151,84,64,159,51,162,53,9,24,90,15,239,103,44,111,88,77,31,96,227,167,153,178,89,46,65,97,120,234,159,116,153,220,58,103,154,111,236,35,25,9,63,80,213,28,121,174,6,37,177,128,0,34,8,61,120,219,193,163,56,234,17,50,108,19,175,10,241,202,129,51,206,176,105,54,140,205,104,113,187,139,72,57,58,137,101,101,153,202,121,247,82,7,183,182,88,242,117,5,214,27,136,159,51,25,143,7,39,39,163,100,228,155,112,116,162,91,237,53,151,121,175,114,155,88,34,96,132,153,27,231,43,129,85,77,207,93,45,75,54,38,169,208,106,182,188,74,35,3,204,147,105,234,218,187,235,118,80,21,104,89,221,37,251,21,4,55,215,202,5,32,187,114,229,158,222,107,124,120,70,117,252,148,124,153,215,129,247,202,111,77,89,149,192,46,78,126,212,149,2,70,142,167,114,71,188,231,225,63,82,98,55,123,56,157,240,240,73,107,127,129,35,49,180,1,28,53,251,71,51,15,151,131,85,89,248,82,60,206,68,75,230,79,188,86,217,174,251,6,82,129,144,80,17,80,189,126,85,167,177,92,137,31,130,5,15,250,23,242,135,208,148,43,174,34,111,215,137,21,228,161,88,242,238,204,128,2,213,28,236,170,72,105,121,230,174,243,67,41,167,111,17,100,214,170,204,210,70,58,86,9,70,41,127,198,102,149,74,225,163,39,255,21,85,13,68,89,158,104,254,166,178,114,235,67,232,111,178,55,210,33,207,29,102,25,157,225,218,57,132,156,91,68,175,3,15,215,69,237,65,190,184,162,107,199,76,245,57,12,183,170,136,215,95,144,101,66,157,166,223,252,91,164,161,249,146,188,109,200,191,131,133,14,248,75,108,80,81,93,75,13,93,172,222,144,31,18,132,98,89,132,232,147,85,66,138,211,73,130,28,28,118,165,38,136,213,75,126,134,96,175,32,46,193,28,206,88,111,190,3,11,243,213,175,65,1,13,220,135,185,48,135,79,51,26,208,50,205,93,140,18,246,174,157,56,196,76,99,234,232,62,18,176,192,227,250,179,59,122,91,119,129,139,39,21,43,154,38,250,245,254,39,84,23,6,27,69,180,17,226,250,22,192,30,121,228,107,45,47,214,254,226,12,145,33,231,1,235,249,45,220,124,244,103,41,65,18,218,215,250,35,227,46,13,240,104,107,188,224,230,222,56,230,140,161,59,9,58,104,44,218,171,23,67,221,145,0,192,122,201,118,189,81,39,105,195,178,1,96,52,150,89,152,235,176,36,182,214,80,13,113,36,1,23,139,217,90,62,67,127,142,17,48,221,76,96,144,111,130,230,248,45,88,13,96,82,81,125,84,98,15,139,195,165,85,110,223,7,151,118,83,79,112,120,218,4,187,73,39,205,130,132,179,97,109,234,172,126,194,42,63,180,216,130,180,102,252,53,4,166,154,156,207,75,83,15,169,13,155,191,203,67,196,26,129,13,222,69,51,21,109,17,13,65,55,165,228,104,26,162,214,230,53,116,94,17,160,137,46,254,140,72,247,238,163,243,12,234,134,114,8,210,3,20,121,35,244,30,93,202,32,26,58,122,242,11,105,129,144,112,221,131,20,162,79,153,154,209,212,169,180,107,5,196,142,29,46,167,175,240,133,102,120,205,149,121,188,247,76,80,100,136,53,128,87,4,245,245,151,22,41,104,158,59,127,26,254,131,111,154,29,201,212,173,107,3,144,219,92,30,193,64,101,36,101,105,143,159,196,239,115,133,252,254,234,31,186,234,222,183,95,247,243,84,122,121,186,176,194,125,191,126,175,118,120,103,212,18,130,87,85,105,67,151,12,188,131,106,9,99,78,109,75,104,138,159,107,33,219,230,123,251,115,152,78,36,252,169,166,161,197,36,128,216,42,129,146,119,79,146,19,235,180,209,86,114,18,184,117,130,153,245,122,198,225,27,140,246,0,135,180,10,245,190,7,192,171,239,78,75,158,16,228,212,208,160,158,5,249,145,169,60,217,239,222,178,12,100,174,62,27,149,143,14,7,136,172,19,89,193,247,245,22,90,179,122,78,21,103,43,32,140,254,122,172,198,114,67,104,198,164,16,116,123,79,91,207,17,129,255,28,32,7,198,212,102,158,153,174,183,46,112,2,149,181,3,138,50,147,131,93,163,162,90,40,122,184,51,76,89,101,14,20,223,216,48,186,0,120,5,8,237,218,104,11,78,79,122,37,241,26,155,246,138,49,108,255,165,42,135,132,93,76,242,216,178,41,213,61,220,84,159,142,40,89,78,9,23,18,188,10,64,120,71,6,141,242,166,208,132,81,68,54,155,244,82,158,139,38,200,17,232,183,27,223,23,123,90,100,179,110,22,203,145,194,5,215,95,96,27,54,148,127,226,179,162,235,106,160,176,64,151,181,195,101,108,255,160,71,24,22,225,206,157,62,76,76,13,188,191,147,98,131,215,70,175,94,83,124,49,56,102,75,162,69,49,186,224,238,129,194,112,239,69,26,161,76,222,239,240,225,33,50,217,83,237,235,244,126,155,75,229,36,26,106,189,123,160,105,111,177,20,7,34,178,168,159,205,221,173,229,63,70,70,40,224,70,167,143,247,169,33,33,253,148,203,39,72,219,58,131,114,32,176,65,75,237,117,141,34,43,181,197,166,238,108,161,200,180,165,202,118,133,94,248,222,176,183,46,100,136,54,194,229,251,66,171,147,172,79,53,78,100,7,53,208,204,195,74,129,184,57,4,130,102,102,135,224,184,144,39,138,123,153,126,55,63,181,187,52,170,112,144,66,173,254,156,103,201,1,201,110,30,145,240,81,243,191,171,106,11,75,9,83,121,187,129,11,109,242,119,180,238,190,74,200,32,65,161,15,33,13,0,221,42,150,164,131,92,10,53,103,181,23,42,244,142,190,100,245,26,219,85,243,216,199,125,165,255,202,91,200,127,212,5,128,52,175,153,249,221,207,6,134,248,74,77,233,219,105,134,38,180,23,214,123,175,206,101,77,83,201,31,251,138,246,73,108,193,251,111,139,253,230,72,162,195,88,238,37,246,136,43,241,229,135,174,27,150,186,37,142,67,142,7,123,5,5,200,226,159,117,100,2,191,158,21,76,159,160,124,97,18,82,221,210,84,13,182,66,20,238,30,91,159,210,127,16,74,12,40,195,44,79,163,231,100,229,114,246,42,20,82,86,30,233,109,118,64,37,36,152,4,231,101,80,111,153,15,100,92,240,102,90,154,234,209,3,43,55,24,33,137,232,145,183,60,222,203,205,127,245,175,208,81,239,188,208,206,5,71,0,79,232,148,231,168,242,42,29,192,255,159,39,174,65,38,123,247,221,248,53,112,41,157,189,114,24,248,48,181,22,253,226,245,43,135,164,201,8,134,40,223,57,43,162,216,191,207,159,46,224,223,186,211,160,2,143,39,239,203,161,121,100,44,165,62,112,40,89,41,45,75,178,244,189,250,67,32,42,100,210,223,139,153,32,193,171,72,48,218,177,228,40,202,199,223,5,88,247,226,69,103,18,175,10,79,149,158,30,112,231,130,49,179,32,63,251,231,55,121,164,214,192,68,187,248,125,112,102,59,209,71,46,248,179,152,232,119,83,242,44,24,124,216,137,250,3,225,240,151,50,122,187,135,73,100,199,142,41,109,222,47,93,33,85,127,69,233,171,61,144,42,21,173,117,106,62,106,226,19,99,236,151,174,90,162,2,39,97,204,99,127,191,211,119,232,76,220,128,80,167,88,51,177,17,224,170,110,5,97,241,31,104,140,120,186,72,59,251,12,132,196,122,32,8,129,150,142,185,244,145,208,30,38,122,235,253,168,253,112,63,252,29,227,128,39,45,35,44,240,14,210,192,55,215,198,220,178,203,152,200,214,195,1,252,78,38,200,135,9,9,15,172,18,179,24,121,71,31,117,11,220,156,154,121,142,27,15,227,169,168,131,91,122,199,204,200,101,173,78,192,54,9,206,101,136,229,74,196,10,113,229,118,220,242,115,180,101,119,90,222,117,69,167,166,98,158,202,60,244,48,110,216,168,46,193,178,97,193,146,196,165,151,31,106,92,91,109,92,133,5,167,43,77,180,50,149,231,134,217,148,92,48,201,15,75,105,113,64,23,100,216,61,2,123,158,233,131,176,239,135,244,235,236,236,154,42,158,107,42,254,234,174,216,191,234,216,218,193,104,39,23,29,157,160,24,152,116,143,23,156,0,242,53,150,182,220,58,153,45,230,5,230,176,169,62,44,154,202,166,252,140,6,171,216,23,133,228,47,230,241,181,128,170,5,246,246,46,250,172,95,141,133,199,29,20,189,21,231,92,83,87,188,82,252,27,8,73,114,83,204,125,220,125,135,167,119,119,212,76,104,101,17,186,203,1,124,242,172,217,29,179,71,82,35,110,205,194,212,130,239,193,125,197,82,220,164,178,60,107,3,66,6,129,160,135,83,39,10,195,6,182,213,115,95,55,56,224,120,12,94,78,112,173,194,194,52,155,48,59,208,196,83,235,52,252,116,62,220,221,78,17,146,254,123,75,164,25,49,104,6,57,194,91,209,217,85,108,86,10,210,62,185,148,244,96,235,50,90,5,61,177,12,83,184,13,31,8,190,247,236,89,236,61,252,70,45,26,77,37,70,84,236,68,5,240,198,134,54,25,153,37,37,209,117,118,212,210,124,204,84,6,109,146,183,188,114,223,86,201,31,62,131,180,223,243,110,146,216,133,240,18,66,25,53,40,192,83,11,162,103,111,147,172,160,126,50,173,185,190,96,69,103,218,79,180,71,57,234,253,197,222,98,232,137,25,17,177,57,112,229,226,195,133,31,208,200,216,40,78,242,145,115,240,143,148,168,244,7,111,78,170,158,97,72,85,173,215,205,141,122,64,76,244,63,41,109,28,74,182,76,122,17,130,102,136,247,58,201,60,79,18,104,150,82,164,14,234,105,137,242,145,71,137,231,115,232,69,72,151,108,140,200,110,159,204,73,162,11,160,200,77,204,201,221,202,0,1,20,62,202,92,159,101,133,56,130,178,114,133,27,82,184,243,197,84,124,156,249,179,1,127,29,14,6,234,121,52,31,131,83,199,250,110,105,59,246,243,100,57,168,169,83,115,11,120,103,234,56,28,125,118,164,64,171,14,23,200,19,149,79,28,77,33,149,204,81,116,152,47,185,102,187,185,22,24,93,84,228,223,74,214,9,149,27,167,192,132,191,212,27,124,160,251,210,136,209,119,9,243,126,82,208,185,189,241,176,46,126,0,65,112,195,181,201,74,19,167,63,184,76,125,47,20,102,148,98,255,107,74,65,66,129,141,105,3,246,221,232,115,133,13,234,96,143,56,155,144,89,140,15,1,195,45,43,34,202,188,28,12,15,127,236,97,193,219,97,62,152,0,224,113,1,251,41,135,64,83,197,4,253,182,157,57,225,6,74,9,216,55,202,63,223,218,68,203,48,128,113,120,223,161,37,207,27,26,211,120,250,223,93,15,59,1,254,195,43,181,75,145,139,3,144,210,228,147,145,134,232,171,183,11,59,69,240,137,152,216,33,74,230,162,194,198,159,145,97,75,217,10,12,198,31,191,162,214,234,180,2,4,225,50,246,220,172,90,214,64,86,62,199,211,169,126,139,34,158,133,119,255,12,87,68,177,83,4,171,211,51,248,99,145,112,203,184,209,168,248,85,151,111,59,102,25,152,56,170,128,96,155,195,225,162,110,166,144,170,74,132,51,249,46,160,176,39,237,154,147,128,45,21,155,32,193,201,176,8,89,39,208,172,58,209,139,8,124,112,56,4,185,183,112,55,245,115,254,8,55,3,66,38,248,168,246,14,90,193,110,43,37,37,236,47,69,99,225,102,124,240,249,12,11,99,174,175,165,35,141,161,139,117,167,28,173,202,181,2,130,82,109,5,22,32,235,12,56,211,58,27,102,153,147,217,212,188,173,146,233,31,170,211,134,226,171,21,63,246,170,198,113,84,184,145,85,216,141,222,229,219,135,194,208,212,149,216,162,174,220,102,215,97,223,125,173,84,114,57,48,237,250,154,108,89,104,85,7,95,109,190,136,133,94,246,9,33,167,250,209,1,196,203,244,188,231,145,78,57,222,8,10,3,188,103,206,175,125,39,243,192,199,10,3,183,64,117,223,176,38,16,34,44,168,180,13,159,34,120,65,133,160,40,217,238,55,187,6,169,35,36,221,89,141,171,254,233,176,50,28,87,118,201,13,245,132,51,132,71,173,210,222,109,184,80,151,166,160,119,164,117,138,153,187,174,187,133,239,56,30,136,13,249,48,112,42,110,64,213,150,166,34,148,97,252,244,215,176,24,26,62,58,39,88,199,185,213,162,1,57,146,110,33,202,95,69,181,98,114,169,194,60,1,141,121,59,243,194,16,198,152,247,130,125,160,188,108,203,196,235,201,56,226,144,116,226,217,226,35,20,103,28,110,116,129,123,83,10,94,130,79,143,79,80,91,137,159,116,91,171,6,102,133,176,40,96,197,165,232,118,129,155,10,60,10,128,231,145,106,149,125,56,213,45,250,127,105,217,22,170,221,54,185,225,54,15,28,174,89,157,83,233,17,141,163,182,226,144,51,19,246,220,169,0,192,95,181,89,147,218,242,2,140,93,110,114,173,182,232,114,207,162,101,250,137,39,144,188,78,158,119,93,146,234,29,206,224,128,80,88,103,227,82,144,229,93,149,186,241,13,254,180,34,123,57,169,113,66,126,158,172,41,100,204,110,163,254,109,200,217,209,159,37,237,51,167,165,152,134,105,214,211,148,104,117,113,86,132,75,194,67,111,114,83,104,72,194,56,56,158,143,47,135,207,86,210,71,50,177,231,167,39,215,0,249,61,112,207,144,124,154,177,252,184,25,207,191,0,236,172,161,172,226,38,200,229,243,94,236,91,25,35,38,14,85,34,186,114,147,23,49,39,185,246,91,31,154,17,48,9,22,47,33,148,155,150,115,26,225,93,133,51,170,110,89,175,23,83,189,169,96,228,96,24,91,183,242,52,240,77,13,138,188,67,14,125,94,144,131,76,123,106,104,187,108,25,114,63,233,216,38,199,110,63,253,249,104,190,235,185,82,121,5,98,94,3,230,178,236,96,193,22,255,217,182,116,249,160,88,168,131,196,107,93,253,129,199,77,116,204,110,115,255,151,251,20,71,58,253,108,121,139,142,221,232,1,83,47,249,125,7,195,230,30,201,225,38,35,179,119,14,72,111,5,169,125,197,247,99,215,109,69,54,93,222,199,29,128,217,102,144,215,166,173,12,155,28,47,93,182,76,133,33,166,153,126,15,168,71,116,54,164,176,114,70,130,15,94,190,167,228,200,166,207,173,123,136,176,141,164,163,227,112,61,114,195,164,223,196,183,59,51,193,198,31,194,143,168,204,244,207,70,177,125,131,167,94,96,84,233,231,33,86,78,87,149,67,14,57,33,217,35,40,144,90,50,231,14,145,32,75,120,175,252,78,211,162,48,112,86,171,65,25,235,107,7,82,125,36,67,236,177,219,242,167,212,220,190,206,183,146,150,221,26,193,131,171,119,32,73,12,109,33,244,57,175,85,114,60,107,101,215,69,93,63,2,9,112,213,36,151,178,226,83,240,114,166,98,131,224,197,31,80,232,185,140,3,252,197,59,128,86,180,132,14,242,249,135,169,118,2,188,98,40,0,99,196,236,13,244,5,230,156,160,196,34,155,199,210,1,203,221,27,200,240,21,102,118,196,89,2,51,58,28,101,50,78,92,80,120,183,27,237,114,39,161,77,165,98,226,247,146,223,92,12,56,110,152,191,182,230,176,114,253,16,8,26,106,226,106,58,80,228,222,179,184,62,186,114,202,236,124,111,225,230,210,3,211,192,59,53,75,212,212,89,24,133,161,216,246,234,193,142,225,63,137,177,133,243,66,147,4,41,140,162,142,243,111,89,109,19,179,58,216,8,208,243,239,142,119,253,245,57,132,113,172,19,115,203,16,228,206,110,238,104,6,205,248,0,100,145,121,34,206,235,7,192,238,42,76,57,27,5,194,4,84,142,13,45,99,212,185,69,111,202,224,158,114,93,177,12,109,220,61,234,6,167,224,3,237,162,14,51,185,120,112,74,246,56,186,146,230,86,103,127,26,6,36,133,12,242,232,107,118,240,147,116,219,241,191,165,180,148,160,45,137,157,31,203,15,238,176,44,253,135,255,125,7,137,153,139,216,156,251,17,21,112,221,135,169,246,253,114,216,96,212,223,137,79,233,18,241,101,101,91,212,235,208,29,193,103,125,28,46,115,133,6,204,253,245,18,173,93,246,119,150,12,137,101,65,12,122,72,166,214,128,138,182,188,115,85,16,15,152,187,207,149,197,19,213,156,26,247,131,36,252,193,35,207,51,192,5,197,112,53,240,184,42,94,44,12,116,174,14,195,36,72,237,117,137,184,0,181,235,56,240,186,145,89,103,235,39,84,223,207,102,160,202,141,35,138,171,77,179,133,114,111,170,141,251,196,125,35,47,94,189,111,114,53,221,49,164,188,176,105,4,228,131,123,69,52,202,79,57,17,23,115,144,36,193,70,161,18,67,129,30,7,118,114,152,190,65,17,185,16,123,197,92,66,15,3,187,140,205,246,228,69,59,33,109,205,115,177,33,135,100,175,53,82,73,208,189,234,148,56,205,71,126,117,183,230,206,154,59,199,242,204,158,9,61,176,157,119,249,38,108,181,183,117,197,111,185,87,60,130,179,111,234,87,197,35,81,141,170,255,215,107,55,97,164,245,172,243,22,121,163,8,160,57,110,250,166,161,148,22,115,45,3,93,151,249,146,217,114,10,23,230,131,24,46,47,32,65,172,101,196,235,215,228,38,26,57,19,199,77,62,61,20,23,42,155,236,144,61,249,171,110,232,156,253,90,47,112,242,0,105,134,86,212,8,30,191,234,64,63,71,221,108,189,167,156,176,11,186,223,15,150,213,149,173,14,154,217,69,146,164,41,237,39,65,105,130,3,149,40,220,84,113,124,143,9,3,251,145,24,85,220,101,189,184,36,107,10,82,132,122,160,183,68,126,101,154,198,68,228,61,41,120,174,201,209,72,194,8,75,123,102,183,10,145,208,236,76,230,157,47,11,81,18,104,229,56,166,195,186,252,208,141,167,98,104,3,132,160,171,71,247,177,123,112,176,17,158,222,84,177,10,39,170,251,193,102,180,160,110,253,163,133,221,112,71,26,178,235,53,1,222,131,55,58,159,7,54,49,10,60,118,166,15,194,174,231,252,97,39,52,137,216,171,244,32,217,92,53,128,25,125,151,125,98,139,52,3,79,123,183,105,107,25,160,15,34,139,69,220,103,152,210,74,29,203,22,230,134,49,84,120,26,177,239,41,135,248,86,140,59,234,235,212,16,112,235,157,144,14,232,233,18,249,35,246,53,145,122,157,1,196,28,170,135,204,4,107,23,42,30,198,34,201,65,90,18,40,70,221,132,3,237,238,120,253,65,26,65,181,176,175,140,149,119,230,87,169,221,20,186,108,53,40,59,98,156,20,19,158,47,3,17,219,47,25,166,122,8,55,124,222,236,160,224,36,10,87,175,217,215,170,125,126,59,108,133,65,66,204,87,197,41,71,35,218,248,185,200,155,225,179,205,172,204,31,38,226,222,4,253,121,46,128,218,155,201,98,151,33,52,104,230,29,242,129,177,14,52,250,90,226,245,136,71,9,44,238,129,189,108,158,69,58,42,147,221,36,201,123,62,94,135,149,74,192,207,82,63,46,39,69,170,233,216,208,170,46,191,76,200,195,27,104,119,63,40,61,109,187,39,35,215,160,89,62,176,47,119,39,62,184,14,47,162,197,245,17,43,97,22,223,182,208,86,203,171,33,0,44,112,49,189,193,202,118,246,208,103,144,151,35,9,40,188,181,100,38,56,228,136,128,106,237,148,37,43,153,152,135,64,230,196,182,233,59,152,166,109,198,236,33,226,230,228,139,232,141,224,163,239,147,17,196,194,95,40,163,197,213,248,253,243,80,92,65,196,211,208,13,33,128,247,118,101,72,110,250,255,134,184,107,110,52,57,138,220,174,226,6,102,117,60,9,251,110,92,173,187,85,139,99,195,119,172,163,179,59,121,12,10,219,87,190,207,38,114,0,24,208,19,182,90,78,80,58,185,61,204,220,95,208,198,137,86,243,212,226,210,218,219,209,97,35,250,63,93,218,69,37,112,220,179,43,59,115,104,127,104,17,217,208,150,125,179,251,42,29,200,233,243,63,183,61,195,145,105,1,3,35,194,105,40,28,187,14,16,193,121,53,158,23,3,254,2,63,7,238,2,74,89,38,89,207,250,11,28,150,6,133,146,204,228,171,249,195,195,247,17,64,81,164,238,0,43,192,101,14,245,233,156,17,231,130,96,79,229,98,40,52,4,81,112,9,27,18,242,32,240,255,253,239,155,194,146,81,47,85,235,203,71,80,77,1,167,237,28,187,2,180,167,150,198,205,26,110,8,95,95,6,23,181,237,142,194,23,22,127,72,99,253,28,250,121,91,103,176,194,173,25,233,50,83,89,81,28,237,31,230,64,72,208,87,158,243,156,104,71,123,87,162,250,245,75,181,66,90,82,251,41,3,233,110,92,170,101,204,146,18,199,194,227,152,7,232,174,118,204,50,166,152,5,90,35,94,41,126,160,190,124,48,8,85,36,245,28,189,43,102,170,95,16,173,20,180,230,177,217,130,78,36,31,125,61,120,47,199,225,112,30,137,99,86,155,216,123,137,69,222,100,206,47,232,42,69,146,180,134,173,84,194,54,72,84,170,179,169,63,175,231,170,174,176,212,163,78,197,199,163,206,166,118,15,91,195,200,169,16,75,10,121,23,221,254,186,41,210,13,201,217,180,238,18,77,113,113,163,103,0,217,43,72,99,155,11,219,91,43,42,88,142,99,191,222,117,144,22,68,52,240,157,211,198,136,63,79,105,118,102,230,159,121,195,72,39,121,229,2,51,62,211,84,250,39,51,217,54,65,210,123,183,91,123,156,70,65,155,77,27,91,75,89,174,228,21,56,77,97,247,183,41,247,36,162,182,115,165,56,33,246,187,88,143,147,118,40,36,10,147,217,170,244,72,156,25,83,136,254,9,157,85,28,21,137,159,44,53,18,43,133,80,232,150,253,252,252,216,122,195,104,203,74,43,51,104,56,94,144,225,77,32,112,100,44,86,233,195,26,11,5,157,155,232,249,77,191,224,176,210,61,215,77,140,23,2,28,168,114,239,236,135,59,86,28,199,42,255,141,74,235,51,112,45,122,116,222,210,218,82,164,110,165,59,224,99,58,243,213,120,47,224,228,80,60,50,16,53,185,83,160,145,104,209,254,21,246,97,85,230,205,79,214,220,253,112,106,170,203,136,53,123,129,193,165,208,197,69,14,65,143,201,40,227,217,74,224,211,79,102,51,236,252,220,174,218,53,56,103,132,17,221,216,145,25,90,241,37,190,121,192,91,68,126,105,45,174,116,16,11,239,249,180,205,241,189,128,142,104,61,1,223,52,25,15,19,125,221,33,20,165,232,23,17,10,84,4,183,106,19,233,188,66,195,189,187,31,233,41,150,14,228,124,30,127,230,59,160,89,121,46,39,144,150,242,89,94,85,116,157,158,59,61,145,113,154,22,141,242,236,35,219,112,168,13,37,62,242,141,31,118,58,71,255,55,61,67,40,198,47,242,207,114,231,92,254,182,17,53,45,203,22,69,205,255,73,205,44,192,80,13,240,38,4,19,87,19,230,3,118,241,94,28,89,157,181,179,104,174,17,21,173,37,32,132,194,93,146,4,143,68,45,89,126,81,135,229,106,27,134,175,66,143,37,34,117,17,136,179,91,144,27,60,122,205,67,158,12,86,31,16,203,162,100,114,112,145,46,51,207,15,155,58,250,22,149,247,248,111,245,56,88,138,238,69,121,35,11,29,89,114,166,193,143,1,50,110,73,120,208,97,134,22,63,197,104,211,235,13,88,243,31,39,138,13,247,181,185,109,200,164,219,140,232,224,211,92,167,180,56,34,226,181,211,83,146,198,50,225,128,180,79,56,180,61,138,21,218,204,14,160,74,39,70,83,159,34,240,221,248,111,128,129,247,119,63,213,236,198,64,138,232,20,142,189,138,152,56,108,64,42,139,223,20,50,174,141,80,56,175,100,248,177,73,163,159,24,76,121,105,185,207,185,152,199,92,35,120,31,232,232,113,14,97,76,55,24,142,68,245,75,106,86,115,59,4,154,242,240,110,25,23,150,42,194,239,187,110,225,222,0,71,27,213,255,191,241,62,247,79,93,230,221,39,196,167,121,7,95,13,67,127,254,57,160,254,241,14,223,105,146,4,170,105,29,92,93,48,124,181,49,26,174,141,175,206,101,33,77,108,11,140,163,218,163,203,52,89,165,134,92,87,89,5,24,234,207,88,193,85,36,253,243,99,114,223,118,201,60,37,228,204,165,118,224,24,2,17,52,40,153,185,188,168,55,90,168,231,34,35,72,80,221,118,217,6,107,108,172,174,204,156,173,92,6,21,99,205,184,7,169,215,189,115,235,164,187,43,22,45,243,82,238,129,126,145,31,152,132,219,218,127,255,9,99,161,83,222,128,27,128,6,74,227,17,197,204,120,137,251,223,48,11,185,83,5,254,231,99,89,24,70,81,21,227,143,195,4,162,252,123,248,4,41,97,20,122,212,30,26,94,41,170,217,249,170,251,158,23,211,2,19,86,201,228,29,189,106,154,67,81,84,184,122,69,52,38,99,116,107,134,209,90,204,111,77,98,100,234,205,27,12,51,150,101,235,185,223,184,217,139,5,144,148,179,201,146,229,103,36,140,22,102,146,57,66,199,149,225,203,158,81,59,102,75,109,180,119,153,65,92,104,31,247,188,98,103,120,200,211,122,216,7,142,13,250,217,213,83,103,138,250,159,251,7,219,100,60,179,247,60,243,234,208,108,49,54,146,47,143,221,182,58,97,221,168,10,14,168,92,241,125,112,106,120,38,16,112,120,154,117,82,103,97,215,167,111,95,46,10,190,199,31,198,170,177,94,129,40,107,95,179,151,153,36,255,5,172,63,227,201,107,172,198,1,254,96,99,19,142,142,50,218,238,212,126,74,141,204,205,46,214,28,84,82,155,192,219,91,152,104,157,118,55,178,178,40,31,65,123,179,131,210,174,248,112,8,75,207,244,154,133,15,60,71,107,14,140,101,206,150,1,83,60,198,142,240,47,152,30,107,149,247,49,224,37,118,213,99,128,244,25,180,39,150,198,227,38,217,132,98,69,55,223,72,174,65,180,57,68,163,56,201,246,64,148,216,180,31,42,99,68,122,13,34,39,242,57,83,114,151,62,187,42,177,109,90,180,153,127,174,41,225,120,73,38,129,127,103,30,131,136,148,63,241,16,140,30,162,93,221,140,159,21,148,52,80,212,227,108,41,28,9,169,87,229,67,34,53,208,3,189,253,151,238,173,65,228,163,237,147,185,193,182,90,197,104,236,95,142,119,14,40,194,87,152,109,102,152,102,147,100,86,108,19,122,133,24,141,80,71,203,71,213,21,41,28,100,89,126,148,77,61,196,163,204,240,217,228,71,212,20,212,222,101,210,128,195,223,216,206,95,191,120,232,66,101,44,217,180,220,250,232,178,86,153,99,214,95,127,207,61,111,85,51,49,145,207,155,0,65,173,92,181,147,59,247,244,83,166,226,138,247,57,253,236,32,193,135,51,103,76,119,128,233,143,24,55,6,106,53,189,138,129,0,219,222,95,34,178,218,196,24,115,234,23,194,141,233,18,28,4,224,10,47,121,108,42,228,165,241,5,34,99,116,38,152,149,72,215,190,174,83,94,208,84,90,101,181,165,89,73,250,66,51,193,69,60,101,3,187,74,77,115,28,33,136,209,16,109,172,59,216,109,145,182,52,5,107,155,98,114,36,34,62,30,52,195,84,37,42,49,14,83,40,232,95,255,233,221,102,19,68,54,74,241,110,57,150,19,91,73,244,109,91,67,251,252,229,61,150,153,75,78,25,244,223,68,212,32,108,175,253,155,39,94,32,38,118,113,2,231,188,210,43,75,28,165,156,241,131,218,223,126,101,179,86,244,129,207,33,58,75,50,161,33,251,75,138,66,15,86,165,95,43,202,8,96,2,95,155,120,46,87,24,220,79,80,229,80,38,53,217,116,176,52,100,191,200,125,173,131,78,38,165,6,22,79,127,7,119,37,116,87,67,224,9,132,126,82,123,92,76,245,216,83,130,56,56,98,50,232,195,89,59,52,210,136,94,232,17,224,37,232,205,74,143,245,167,215,144,15,207,102,180,41,196,126,167,17,4,148,35,206,207,198,77,43,8,52,238,137,44,15,176,194,103,4,42,92,121,41,181,43,71,64,2,221,38,22,160,130,72,248,33,208,20,22,176,141,3,103,142,102,180,138,137,141,157,121,82,63,50,171,147,181,187,57,128,146,233,167,203,192,186,148,139,3,4,188,243,199,27,164,102,240,44,179,138,206,30,39,70,6,43,154,226,145,39,12,99,10,233,18,69,124,181,37,117,172,189,92,77,34,9,211,104,226,255,39,223,243,113,99,190,224,52,18,164,8,229,87,98,3,242,165,166,29,225,4,38,8,104,5,1,57,107,6,59,194,207,128,113,113,108,87,163,134,242,240,166,236,77,249,7,132,230,121,127,252,28,139,53,136,174,88,144,81,67,63,245,213,177,86,209,186,246,48,23,195,96,95,130,137,145,82,6,34,122,58,34,177,156,248,241,87,82,196,53,109,211,119,185,219,107,57,51,122,151,168,60,193,18,191,49,8,153,55,16,115,23,164,181,89,211,161,95,81,192,192,128,117,98,169,170,145,206,124,191,128,95,108,240,19,243,213,115,130,68,64,20,19,66,204,142,29,124,136,121,32,218,119,29,243,18,39,218,198,106,132,0,248,44,196,96,184,145,30,13,33,30,125,154,71,167,13,93,235,63,11,151,88,152,223,93,3,17,13,162,233,247,47,182,123,94,198,66,88,243,28,129,52,138,92,159,41,135,67,65,155,135,21,235,44,87,216,80,68,59,100,222,231,90,130,69,16,44,125,96,57,145,10,172,209,152,25,84,20,47,129,132,62,197,51,247,22,226,142,162,17,251,97,214,26,131,36,180,28,248,16,145,29,128,48,93,220,46,189,64,7,105,106,153,2,24,165,219,253,138,36,225,242,14,80,0,181,197,34,0,255,81,52,173,189,27,229,255,178,97,127,74,150,60,201,111,177,65,8,119,206,135,224,91,171,43,168,118,51,121,167,181,137,187,97,98,84,187,208,20,215,173,133,156,63,121,109,86,211,179,109,84,147,120,54,235,147,65,101,240,54,45,170,241,183,11,77,162,209,13,169,248,74,90,98,144,19,241,201,21,67,31,130,163,11,60,215,122,68,97,219,105,210,102,102,114,76,165,67,121,162,162,102,219,130,160,37,112,81,30,146,42,75,129,35,218,30,5,138,64,224,18,109,108,209,221,40,122,212,144,180,121,114,246,118,19,120,149,41,145,191,74,235,21,100,58,10,160,112,212,172,244,34,242,65,136,199,40,222,125,168,212,236,179,135,115,37,159,84,99,53,71,221,217,185,227,95,74,211,241,40,113,159,75,93,154,45,69,37,183,158,103,109,74,127,176,38,242,120,114,176,91,173,158,88,64,7,21,182,90,253,117,31,6,249,28,112,174,84,219,22,242,88,252,19,63,197,148,86,240,72,102,240,17,110,105,198,70,5,224,179,6,107,105,139,247,135,196,174,49,247,189,115,70,140,153,169,179,18,57,111,93,126,113,58,189,77,91,102,108,253,175,100,161,154,215,192,31,255,190,101,183,183,221,116,19,236,41,30,114,130,176,198,154,84,160,16,67,61,146,205,61,91,238,50,213,171,13,64,173,134,252,220,240,125,242,69,235,82,96,155,245,6,75,89,216,218,219,169,102,106,222,232,112,126,92,87,172,106,61,246,112,208,59,130,87,63,76,66,220,141,108,51,110,85,113,39,127,138,110,239,102,234,251,112,79,252,248,61,141,216,237,119,210,137,196,21,104,111,203,88,7,123,229,51,232,10,35,110,33,114,55,50,114,157,236,114,185,157,196,221,237,57,64,210,33,86,52,90,214,233,96,222,162,64,74,251,233,81,104,110,47,140,53,105,188,223,67,20,82,219,212,107,11,186,160,132,213,122,91,76,234,131,99,150,125,10,231,55,53,120,146,70,64,33,229,24,20,142,187,151,94,56,231,42,119,43,208,70,143,215,254,7,140,39,197,2,74,123,229,212,221,31,65,0,11,157,8,173,157,159,13,200,230,231,114,186,8,217,176,221,226,204,22,171,14,84,245,95,22,51,31,189,179,246,7,207,50,55,36,92,223,21,80,149,237,127,181,182,208,164,175,102,54,215,186,166,7,79,76,99,65,102,128,239,236,209,209,237,114,235,142,253,187,103,36,75,113,190,40,245,174,67,213,160,185,10,99,173,86,16,62,212,48,115,92,245,201,233,250,59,129,66,181,59,124,40,81,255,223,174,162,58,173,182,35,135,226,148,105,197,199,68,226,181,16,112,60,236,219,133,191,176,7,230,18,160,179,74,136,193,184,178,186,199,55,40,82,89,249,72,68,58,254,101,142,123,44,63,183,1,201,128,239,100,144,139,160,252,221,103,138,84,47,155,35,81,30,130,184,136,58,17,13,131,70,225,37,108,66,136,249,150,90,27,54,65,176,180,229,175,79,255,29,185,62,179,134,16,125,125,243,93,236,133,139,7,220,191,143,244,86,146,240,57,20,175,234,83,60,159,216,61,220,32,42,231,223,6,251,77,9,184,87,136,177,139,85,46,114,208,98,167,150,63,109,14,8,54,99,55,254,118,105,29,103,110,234,117,204,152,203,59,89,42,246,208,193,136,5,41,216,68,65,197,86,37,93,116,209,50,53,215,70,196,162,40,166,47,44,186,177,168,117,5,208,142,173,152,107,130,110,197,92,30,39,206,52,178,194,177,41,108,74,119,58,187,145,132,211,229,213,155,87,60,8,1,42,12,229,177,232,236,38,145,98,5,67,79,101,47,38,1,99,116,129,211,235,215,190,233,193,99,54,126,159,9,1,30,194,94,240,90,197,208,176,114,84,219,123,217,236,240,174,140,127,173,99,113,65,248,157,253,91,72,127,253,165,233,137,241,8,0,127,155,225,34,106,22,108,77,6,196,246,39,33,56,127,191,244,64,110,185,143,196,255,148,244,116,181,155,10,229,13,30,86,133,109,29,198,237,230,105,68,128,36,217,3,236,92,175,145,157,11,168,218,70,71,44,136,201,1,191,151,233,191,32,82,54,7,207,111,33,163,63,84,98,34,255,238,230,65,128,239,4,29,129,177,57,114,87,117,26,159,26,177,41,120,219,160,235,95,73,152,45,13,33,169,241,239,156,57,80,34,197,198,29,106,245,162,32,242,3,153,108,55,89,102,170,161,101,1,203,134,253,7,206,183,115,28,194,31,252,13,11,64,195,22,207,21,247,229,89,189,254,249,137,151,227,63,118,91,36,204,230,114,185,248,171,29,29,123,220,112,32,148,136,193,164,193,129,171,177,150,77,201,19,28,53,130,65,230,24,192,7,177,52,141,88,231,95,60,78,26,176,63,72,63,87,36,81,7,245,43,223,133,94,42,222,226,21,134,41,123,138,79,191,194,87,150,219,143,19,11,91,26,80,9,56,138,52,243,189,112,117,55,198,106,219,169,83,187,1,112,12,125,223,89,9,208,2,156,225,124,30,3,159,143,66,4,220,82,26,92,160,135,94,14,142,72,126,46,4,25,150,117,4,233,97,198,55,140,155,47,29,3,188,222,242,159,202,121,246,155,200,113,254,6,220,119,131,248,81,222,133,82,219,154,65,81,83,101,189,84,35,175,187,51,172,142,41,109,2,178,189,4,249,145,57,164,39,69,45,88,252,151,120,191,46,88,2,145,42,89,156,161,2,90,36,244,96,101,239,94,2,157,96,187,250,225,240,57,53,84,74,87,245,160,22,169,79,229,9,77,136,43,237,200,41,137,140,154,79,61,252,172,242,228,130,150,218,143,168,143,127,96,237,158,152,4,105,160,28,207,109,50,61,147,74,96,26,82,215,231,158,201,39,8,29,212,26,237,92,125,36,123,31,233,162,184,200,180,236,128,46,130,82,157,45,67,132,175,4,192,151,133,28,173,1,165,64,220,56,172,74,166,148,55,22,202,19,177,152,103,200,16,220,242,197,156,84,189,111,202,78,96,121,145,156,133,145,26,203,126,123,97,44,45,162,138,195,76,97,151,16,35,21,133,218,133,202,209,205,136,159,236,160,213,220,176,17,218,101,202,26,249,221,181,3,207,185,229,3,142,19,177,148,254,42,255,199,175,72,163,209,169,87,70,77,38,32,79,30,228,55,250,137,38,157,64,225,49,198,66,103,165,19,118,43,52,82,79,177,162,58,104,162,202,8,233,116,28,154,160,233,46,165,221,131,249,18,234,56,240,154,108,139,18,197,254,136,127,175,207,132,191,37,241,74,79,214,93,61,79,221,231,147,73,184,76,59,154,132,14,189,133,186,214,14,223,148,217,165,192,45,128,236,118,224,127,121,211,25,131,195,234,30,5,119,240,48,81,84,54,238,66,91,178,189,165,40,2,52,51,116,91,167,255,88,94,222,216,45,23,98,21,127,98,168,211,61,208,202,242,126,189,103,218,72,107,227,195,160,181,31,149,186,161,69,6,160,52,232,57,255,13,162,144,213,67,225,92,229,87,183,150,180,137,83,111,107,208,51,171,249,24,174,29,231,166,40,174,165,238,130,97,142,175,66,169,143,148,100,10,183,163,17,114,226,194,122,31,189,165,164,127,246,204,106,64,82,198,39,39,224,43,123,6,169,54,121,141,235,183,217,153,67,115,218,255,98,111,193,164,110,249,58,235,199,216,103,140,76,48,230,214,215,243,184,30,82,60,147,189,184,185,15,51,87,84,20,175,176,106,20,238,154,154,107,154,34,59,200,132,240,144,206,188,121,106,53,14,170,64,140,246,125,193,4,38,157,210,49,93,166,199,241,245,5,183,155,45,127,57,187,249,243,219,101,180,82,163,175,95,191,145,172,200,209,176,162,67,64,174,23,56,190,144,47,43,120,83,194,108,56,183,183,255,26,67,63,186,64,8,203,199,40,3,90,229,96,139,209,71,163,67,243,9,252,134,97,82,122,66,179,72,109,182,101,149,118,147,136,118,212,188,182,125,20,232,4,115,74,44,84,120,30,181,45,88,117,58,173,74,241,140,109,184,113,15,57,27,217,99,168,65,104,58,4,221,204,242,21,92,173,195,249,71,226,61,12,63,2,21,159,22,207,202,32,206,69,75,25,28,199,151,58,220,66,215,242,165,49,128,252,125,34,208,223,161,12,81,98,40,240,149,99,170,85,82,228,103,214,32,17,162,77,240,115,94,121,51,19,42,70,129,6,110,153,209,38,82,19,189,118,14,8,65,162,1,92,174,111,4,26,199,181,172,176,107,118,107,53,98,14,108,242,15,159,224,115,120,63,9,43,246,116,215,136,141,85,0,223,74,188,92,199,237,66,168,141,188,122,190,105,251,69,187,237,105,32,227,117,212,88,222,226,127,233,132,116,5,135,107,194,78,234,21,119,201,116,59,140,188,10,122,13,182,54,50,152,11,103,71,131,14,219,81,114,6,42,194,240,202,44,49,138,21,250,207,228,199,95,42,88,254,173,138,140,205,193,236,29,41,7,196,247,44,243,141,124,109,52,200,157,24,20,166,38,35,244,0,199,9,23,146,33,25,158,117,129,7,30,10,105,155,29,147,73,16,170,162,167,88,191,206,144,238,26,162,133,11,13,137,40,238,73,238,132,129,15,22,101,245,72,249,20,215,223,56,63,87,64,29,47,188,58,185,48,246,205,48,64,69,50,89,172,237,60,134,77,96,85,75,100,235,201,131,103,57,196,93,98,226,63,85,218,103,117,192,105,49,219,77,55,136,93,167,115,160,250,111,215,244,31,120,134,22,70,247,3,245,92,216,126,2,56,222,177,141,158,142,87,125,207,219,115,17,131,187,30,105,200,95,2,93,2,165,35,249,51,1,207,130,215,188,195,91,88,141,205,80,138,173,139,56,150,190,76,119,164,155,249,64,54,227,132,221,191,240,254,65,23,157,115,214,220,228,60,68,1,56,182,252,167,222,23,97,248,18,254,243,196,111,112,6,72,107,226,232,19,122,127,93,221,125,121,178,157,155,173,79,218,202,93,118,62,94,155,195,218,160,116,235,98,23,241,113,78,18,238,175,130,188,65,241,173,20,112,45,214,223,242,129,96,208,59,24,226,251,70,143,125,151,86,22,184,12,42,104,157,191,28,51,164,78,186,108,108,241,36,252,187,173,20,34,111,78,133,198,175,2,28,233,135,218,192,101,252,145,41,210,56,165,226,9,136,52,141,106,147,157,204,149,235,21,16,217,230,246,27,28,178,41,40,27,242,170,243,194,122,45,28,188,202,220,233,247,39,236,41,112,2,252,193,236,253,41,69,5,0,18,55,129,202,179,198,61,49,87,50,29,57,184,206,135,235,94,254,131,130,48,142,109,242,23,211,240,92,244,73,145,202,255,76,131,30,213,61,20,118,14,67,184,186,61,56,59,33,4,79,137,121,159,110,124,218,10,43,108,184,246,216,142,172,195,78,22,195,120,107,61,133,83,53,229,66,121,62,159,139,96,44,228,204,82,16,72,135,75,234,123,147,227,137,203,146,244,160,52,91,198,11,132,109,65,252,199,154,151,54,134,232,155,154,243,252,42,76,135,205,144,94,197,201,228,51,154,215,112,132,193,111,216,76,210,131,148,85,123,89,120,233,207,240,190,208,132,99,32,237,132,168,217,101,172,87,53,184,184,87,221,80,253,94,143,57,203,165,192,118,64,46,171,53,118,214,212,148,78,92,23,33,63,141,46,174,52,116,36,107,59,71,118,24,62,242,253,114,223,184,21,4,240,244,118,32,121,238,124,32,180,102,205,186,107,236,42,41,202,82,120,131,242,20,160,228,29,119,150,236,158,178,65,108,232,18,45,171,219,159,111,31,247,55,249,167,215,120,115,216,237,248,34,166,104,91,86,137,178,128,23,246,33,226,115,140,33,160,134,2,120,226,178,162,202,99,159,36,51,232,207,169,219,81,57,28,83,230,39,74,102,205,129,101,69,226,217,127,35,238,12,66,235,197,95,236,251,147,232,251,194,110,38,119,71,23,34,84,228,52,48,113,116,93,117,212,49,163,183,128,123,227,3,63,132,10,221,233,241,27,132,109,118,245,135,229,230,192,24,120,153,182,254,253,112,238,82,191,203,227,33,168,178,218,172,14,206,236,243,16,250,227,19,145,204,247,190,36,155,54,135,152,170,190,62,22,106,237,57,37,101,180,185,53,218,69,38,101,143,159,178,194,47,59,229,202,165,60,108,236,36,73,180,91,70,39,85,113,18,139,135,103,186,119,134,120,151,177,210,205,213,34,84,97,136,130,81,222,225,178,83,233,123,75,16,38,57,159,125,246,228,74,125,17,125,24,177,159,41,218,7,105,120,59,151,152,242,81,21,110,12,26,131,219,13,88,162,236,68,229,238,254,118,189,203,145,248,233,239,214,251,177,50,70,57,251,62,216,122,193,198,127,234,236,46,169,126,145,135,254,238,218,221,207,213,155,141,243,128,227,109,137,106,188,186,10,14,45,84,220,255,6,229,100,139,53,26,31,144,50,2,123,189,42,98,221,146,17,156,228,196,33,7,216,141,244,134,192,241,176,102,109,220,108,117,126,245,13,85,116,211,28,65,150,136,119,6,37,92,95,237,210,241,1,26,212,70,176,104,163,159,18,41,208,166,166,202,56,234,99,151,218,38,147,103,104,196,98,38,197,43,29,238,46,197,192,123,22,4,49,16,163,201,88,24,240,43,145,106,164,167,56,141,254,41,50,0,235,171,162,89,176,24,238,88,65,151,212,0,192,25,114,209,154,29,171,105,237,54,215,138,191,201,209,53,32,204,187,216,250,100,227,113,61,192,197,83,248,41,204,107,232,38,181,130,232,18,226,92,34,129,250,143,251,165,26,129,202,50,184,3,240,0,3,13,206,11,74,132,234,41,174,12,2,57,205,62,249,44,94,22,147,238,224,60,178,225,173,103,120,177,161,182,231,71,44,109,111,158,225,33,87,50,223,31,9,85,32,92,135,231,45,196,233,125,190,217,109,106,220,161,231,109,23,167,238,182,45,207,106,176,10,250,233,18,220,70,212,221,32,193,151,123,223,78,31,214,81,169,130,21,98,127,2,124,93,15,125,139,232,6,23,112,40,155,18,194,97,30,25,21,204,154,51,233,53,111,227,205,165,246,140,238,4,181,45,76,75,64,94,251,2,173,73,148,8,166,93,35,157,42,34,210,229,53,249,250,37,193,110,39,22,42,217,15,205,212,128,226,136,191,148,152,228,137,148,28,6,110,237,117,251,183,56,105,7,193,38,154,179,174,227,124,193,139,161,102,34,129,142,13,192,128,53,123,37,95,250,99,198,126,240,68,206,201,75,35,9,181,241,95,77,248,60,47,133,126,44,43,40,30,177,238,214,216,33,157,247,156,167,40,145,67,163,151,137,58,176,117,82,107,199,5,130,57,136,54,216,191,211,4,25,44,230,228,120,220,177,130,1,212,113,167,157,15,183,211,46,232,21,163,174,232,112,1,51,184,57,188,157,142,8,77,151,250,198,149,97,30,169,215,46,11,2,214,80,40,13,205,238,156,59,0,154,41,23,201,58,21,209,115,0,172,149,98,8,231,204,155,34,249,178,46,3,66,141,87,187,18,9,246,83,67,252,4,210,33,168,116,178,108,17,147,135,102,205,228,113,206,29,227,129,97,69,240,135,23,144,65,102,222,48,131,192,28,155,78,60,41,241,239,113,134,140,198,231,45,149,105,81,208,67,108,232,62,105,174,2,15,57,107,152,221,106,11,11,153,213,27,181,115,43,212,54,61,83,42,114,24,98,184,177,193,184,34,252,69,242,192,134,91,191,62,194,186,79,75,38,147,143,105,136,237,34,154,234,173,142,218,150,131,66,131,28,209,224,194,163,236,194,134,219,207,56,133,77,203,68,196,135,213,238,107,128,153,80,134,241,60,195,135,218,174,34,132,218,146,133,128,212,126,150,186,231,214,240,68,145,232,158,61,251,219,229,12,157,232,77,95,155,138,86,194,206,157,217,205,140,123,184,104,179,163,56,88,167,105,21,253,150,235,123,15,93,78,63,206,219,226,116,149,107,18,45,181,230,226,175,221,234,141,230,205,52,83,157,198,22,36,221,38,89,127,161,105,26,111,13,90,7,104,175,14,109,52,11,68,195,112,200,234,66,91,147,132,248,35,148,209,66,231,212,174,185,131,57,110,107,39,160,185,13,8,65,62,231,15,100,169,15,44,188,44,229,184,178,164,182,42,159,93,39,68,78,161,136,255,64,158,103,230,199,184,116,168,3,93,123,194,215,65,81,5,0,127,124,254,246,58,232,242,81,235,232,237,26,139,83,43,194,55,146,181,66,193,196,179,47,63,250,209,45,218,59,142,121,66,11,231,116,73,51,151,251,25,179,222,60,117,160,113,124,118,23,194,13,206,231,162,142,217,238,190,22,208,221,109,148,254,22,87,201,234,33,18,185,31,41,157,13,172,151,215,21,121,16,132,54,154,164,232,212,10,228,253,50,154,48,50,252,233,23,229,237,198,185,180,253,178,241,226,114,67,85,204,70,16,208,233,251,78,246,45,29,58,223,182,164,43,209,167,216,87,207,64,13,227,124,134,211,121,186,118,237,114,12,118,2,161,14,182,187,109,48,243,94,118,102,173,180,11,8,175,246,214,171,1,121,247,105,19,95,44,249,122,40,234,183,147,251,167,21,47,207,177,166,18,99,84,224,43,11,246,192,99,152,85,244,58,234,201,154,246,145,82,201,61,161,246,143,147,248,103,189,85,141,132,136,148,214,11,242,88,156,129,58,132,122,198,52,246,207,134,48,70,209,198,18,72,32,74,139,246,231,197,174,104,125,8,97,46,207,200,161,83,181,2,36,175,170,133,105,73,37,104,33,46,146,242,34,60,135,106,82,101,176,80,41,74,74,145,166,207,154,91,177,164,57,178,139,207,37,242,51,161,220,153,182,195,32,212,205,204,129,144,33,199,162,9,223,21,53,80,32,58,137,31,51,164,248,182,138,98,171,1,168,26,196,122,61,114,170,192,73,47,243,120,137,177,94,148,72,57,254,243,255,214,142,202,94,136,33,114,44,56,106,246,61,115,254,233,170,128,252,59,250,37,36,235,14,136,239,162,43,58,40,185,114,48,229,175,172,112,213,161,66,147,36,182,20,90,61,83,5,206,122,226,231,115,14,170,255,190,22,136,236,154,234,48,155,250,194,233,186,240,31,211,128,177,199,48,173,236,199,23,245,32,122,71,88,60,101,155,190,36,197,84,43,29,205,226,56,242,8,169,210,193,123,112,206,246,141,138,224,218,60,163,22,76,98,109,12,206,172,58,66,204,106,179,210,76,35,41,184,178,99,41,232,35,248,69,222,42,2,80,158,194,243,255,251,187,32,207,119,8,30,40,201,36,42,195,112,84,218,2,251,79,153,119,10,46,230,86,134,95,21,57,246,61,59,224,145,82,6,75,244,245,69,195,245,112,79,66,173,48,45,40,106,139,245,197,8,190,119,168,77,27,248,211,85,149,189,169,18,120,160,246,184,215,147,40,150,248,0,78,178,140,134,162,135,99,164,35,163,144,84,251,3,155,167,143,81,131,225,8,178,248,167,171,56,223,68,153,159,32,9,174,205,11,95,211,212,104,50,50,23,26,130,154,202,202,57,53,37,8,180,251,254,68,152,62,242,166,83,152,145,78,151,49,11,52,70,44,53,213,213,196,36,51,117,123,15,242,1,194,154,237,243,93,9,10,6,138,24,244,31,160,242,1,8,110,85,135,93,80,146,169,249,51,44,157,165,88,18,206,9,89,151,175,237,190,39,113,21,178,220,23,42,180,152,218,22,113,47,150,163,122,103,135,240,189,222,75,154,255,136,34,109,142,220,57,204,66,121,41,241,121,79,112,55,227,187,243,169,172,230,79,235,226,195,82,243,241,126,126,250,76,159,91,231,231,136,88,192,66,52,61,205,243,163,141,75,131,82,210,143,24,88,164,249,187,17,108,145,248,115,213,198,139,195,167,26,126,112,218,77,1,196,194,146,142,51,140,135,206,124,203,103,205,95,141,218,62,168,90,13,3,87,37,137,230,254,233,17,10,195,83,248,25,14,48,155,193,27,65,41,238,162,145,153,76,49,89,126,215,60,69,193,151,180,83,38,111,238,63,75,129,63,168,170,69,132,37,64,148,248,187,118,150,127,59,105,144,220,235,213,30,181,198,76,172,165,54,207,14,79,248,82,33,88,156,147,151,31,37,129,50,40,196,139,22,184,254,128,15,1,195,177,239,81,208,113,139,26,133,94,126,115,161,251,184,5,131,77,243,205,194,248,228,210,88,154,240,157,125,207,254,152,38,82,202,143,202,246,13,172,43,222,243,218,104,132,201,14,50,209,51,130,1,168,234,243,134,69,56,245,122,174,27,252,139,85,38,6,71,238,170,223,234,23,157,199,118,226,237,144,57,159,87,216,239,25,148,220,9,42,162,205,135,41,215,179,23,191,26,251,236,5,181,25,18,36,232,235,226,13,91,3,10,72,170,224,31,233,76,142,83,144,246,4,215,246,197,118,232,211,91,102,28,62,77,238,198,198,205,47,2,80,198,78,218,241,1,50,172,165,110,155,6,233,133,206,51,53,95,199,227,145,40,230,131,34,234,134,224,177,145,148,242,36,100,185,9,76,4,59,7,0,109,209,0,92,67,163,116,85,200,222,129,37,17,45,188,79,223,53,149,201,206,222,90,138,197,3,151,244,129,162,143,124,166,216,150,21,140,46,248,202,87,208,191,168,161,31,148,249,3,131,135,25,174,175,14,240,115,112,232,138,152,123,26,242,117,102,0,87,241,199,22,126,119,32,17,92,238,40,204,36,62,64,141,118,236,248,131,29,20,72,75,205,40,130,140,194,209,13,30,23,64,193,46,101,41,12,192,90,70,115,191,241,173,19,18,5,40,76,249,155,220,191,85,178,230,85,100,152,99,91,106,244,138,50,195,201,155,198,211,255,241,66,194,31,99,99,40,229,173,135,253,151,133,236,66,151,180,113,78,15,101,148,215,5,187,3,186,170,238,185,196,14,102,56,224,209,248,178,80,103,205,95,181,30,35,132,60,157,214,150,159,252,181,160,40,174,101,142,238,220,176,130,43,153,122,142,112,21,254,165,104,62,58,175,109,54,255,181,103,49,47,133,98,58,83,178,72,15,56,151,35,140,221,96,33,194,128,94,249,99,222,169,247,14,95,174,251,182,171,137,31,48,172,163,165,176,101,120,3,59,24,235,238,98,162,158,155,36,81,133,142,129,251,64,13,17,41,20,45,174,56,178,115,60,62,205,57,194,230,66,54,40,96,211,46,113,11,174,4,165,142,156,218,135,4,185,20,160,121,181,27,102,203,194,125,231,210,46,55,157,135,227,101,21,181,211,34,156,134,206,94,55,6,95,46,147,136,41,102,12,64,83,144,6,88,111,190,58,75,38,117,206,191,25,88,12,5,61,56,47,200,189,134,195,177,51,131,58,169,70,153,41,175,183,252,235,78,191,74,239,20,115,196,213,123,160,227,170,168,227,124,194,22,29,234,91,233,100,230,124,129,243,208,120,186,6,254,88,129,91,109,62,112,183,255,114,119,165,123,120,106,124,188,117,177,224,45,246,61,117,105,181,217,215,121,189,87,52,42,37,223,195,252,200,196,122,183,65,53,111,251,11,55,248,244,64,202,106,32,49,18,224,65,151,100,13,51,62,235,54,45,168,186,239,199,168,60,171,44,73,216,86,225,75,131,16,201,82,152,22,229,104,161,12,43,246,54,31,236,219,238,30,183,248,9,248,113,255,161,184,226,47,195,83,30,217,187,182,177,40,43,85,19,20,42,245,231,10,227,115,207,78,246,163,97,176,108,73,129,35,144,38,127,212,56,3,15,233,205,51,188,238,100,252,199,70,106,161,67,10,50,48,100,124,159,168,125,73,93,228,195,84,189,2,117,90,24,228,173,154,254,72,177,188,181,179,202,14,7,245,167,190,197,185,165,36,29,250,37,1,6,82,240,10,234,238,64,20,154,27,217,138,38,135,164,230,96,7,209,144,14,63,80,229,65,157,154,183,169,209,97,182,41,39,99,53,178,32,202,85,207,220,232,56,253,56,60,77,140,152,29,187,142,34,233,243,136,203,51,59,94,103,38,235,249,97,125,150,28,124,203,246,116,67,93,88,16,230,115,237,162,85,88,122,168,30,233,11,150,55,95,100,192,40,96,189,188,49,48,75,223,33,237,130,105,56,171,63,233,62,104,34,152,83,167,50,173,196,117,28,191,181,157,195,94,27,126,26,179,218,137,173,114,132,212,156,255,92,8,26,15,181,113,7,74,115,98,88,172,133,32,88,223,117,84,217,25,148,37,11,48,224,245,216,146,147,177,160,54,241,246,185,136,164,83,114,147,252,226,208,205,211,159,118,135,246,134,218,108,184,129,125,130,14,69,116,81,129,54,91,227,229,180,129,109,209,113,89,38,232,135,131,71,230,96,5,218,138,77,60,39,123,6,40,213,87,198,50,244,31,89,129,45,83,127,236,47,42,162,88,68,238,102,225,230,224,222,106,148,254,140,65,238,250,241,212,156,53,90,190,77,244,49,17,30,171,250,136,254,40,94,17,22,47,56,218,88,35,20,47,187,96,1,110,251,146,29,132,21,224,174,67,200,166,147,247,80,62,220,6,73,53,68,62,171,244,159,2,157,251,176,178,170,196,251,26,157,145,227,236,173,224,247,67,236,149,226,14,51,94,205,125,102,110,131,11,62,75,241,132,29,74,250,9,185,38,234,171,250,47,58,72,87,241,158,181,112,55,239,9,233,226,110,74,93,246,108,234,184,231,86,37,125,80,202,58,82,163,242,215,182,50,96,244,86,178,25,223,196,103,183,131,160,116,122,193,179,99,151,63,238,17,125,215,154,56,5,51,216,220,216,45,155,249,219,213,119,19,243,143,67,143,236,219,44,112,230,129,70,210,243,4,0,119,146,253,12,221,23,79,34,67,232,64,216,35,182,67,219,246,159,7,105,73,27,204,94,204,162,115,130,34,240,216,200,80,161,254,147,199,125,64,32,15,237,36,250,209,183,129,85,156,174,31,9,185,59,26,55,1,209,164,232,15,107,239,35,63,253,108,238,112,30,105,149,183,41,210,248,238,167,254,84,182,67,237,28,40,254,86,200,106,80,192,203,110,232,83,203,65,14,95,4,104,85,156,35,121,83,144,39,245,184,110,90,69,119,11,100,175,132,154,11,111,110,213,135,163,241,141,152,137,177,231,208,195,238,107,136,7,175,52,196,47,255,130,219,140,49,187,80,115,75,158,138,247,96,143,198,0,9,157,185,165,70,139,189,64,129,85,182,176,167,82,85,63,185,0,231,180,177,89,77,4,138,246,227,158,244,229,130,103,195,179,226,69,25,159,139,57,118,60,224,185,124,59,83,183,206,13,247,191,121,218,119,159,142,8,255,225,45,5,209,126,79,140,160,107,251,250,99,189,95,107,108,217,187,0,102,53,5,138,26,213,205,48,46,236,3,177,147,154,217,50,240,38,21,35,113,114,150,53,26,89,34,15,10,120,24,23,52,63,177,34,209,64,93,59,41,57,56,127,243,68,83,249,37,35,178,74,42,119,30,170,98,104,24,64,63,119,204,202,3,47,45,146,87,242,170,200,253,119,30,29,130,232,97,50,198,41,34,141,149,232,115,232,5,31,195,112,216,78,103,169,246,78,211,246,91,90,163,77,250,196,159,201,66,80,100,106,90,184,128,209,74,173,247,189,162,234,36,127,194,172,61,244,24,17,166,197,4,20,224,186,201,97,123,57,227,215,226,152,175,162,225,90,28,159,45,213,150,220,168,95,154,252,238,214,159,186,13,38,180,28,96,72,49,134,136,61,88,227,50,46,55,36,216,102,171,237,113,226,131,92,236,18,193,207,236,75,173,167,147,20,65,208,226,90,203,192,189,87,39,106,196,58,233,9,36,74,197,101,33,130,225,107,76,75,178,135,34,21,251,192,62,10,198,43,213,164,6,153,133,252,96,37,58,88,239,16,209,157,155,138,237,203,245,192,222,145,62,132,252,90,30,136,225,192,48,62,165,204,24,213,146,47,202,75,31,31,5,229,207,145,96,146,158,164,169,209,252,40,1,74,190,9,242,255,37,188,45,75,167,156,205,66,84,68,63,193,71,143,195,46,211,172,81,227,69,74,249,107,21,45,159,17,166,90,193,125,44,72,45,61,13,121,218,64,131,74,81,249,111,33,16,255,133,44,215,224,22,127,146,215,66,47,97,12,169,237,251,238,69,188,240,221,136,141,12,231,255,5,70,161,36,165,16,27,10,231,129,86,70,180,56,78,86,246,49,156,118,233,245,207,138,182,60,32,224,52,231,2,136,237,219,111,167,52,234,8,110,173,64,145,81,149,10,176,70,126,106,226,30,144,135,177,201,163,137,225,3,62,144,124,141,224,231,149,66,47,211,123,203,227,249,211,122,181,180,237,187,14,222,214,231,61,3,12,226,24,42,2,169,13,0,153,209,163,133,91,180,0,237,160,117,6,2,94,135,248,86,149,198,12,14,67,130,237,213,92,239,171,200,75,14,142,97,83,76,163,53,217,201,116,170,63,64,93,247,236,73,13,47,121,51,12,225,90,110,8,222,171,100,167,33,195,122,12,70,168,21,6,44,126,213,17,64,233,203,87,32,152,109,78,67,167,80,107,220,242,0,218,189,205,248,72,0,36,123,52,181,106,121,13,1,26,166,174,78,100,196,67,58,243,197,168,57,158,106,10,2,14,66,39,247,74,221,236,93,145,194,156,249,67,189,249,10,22,85,64,236,109,90,90,64,112,151,214,42,136,167,105,62,223,105,20,57,99,27,45,137,51,85,123,71,155,186,38,179,149,72,118,101,174,38,20,173,95,22,189,209,189,162,144,126,45,35,56,62,196,45,230,145,58,204,236,205,209,251,34,242,201,144,245,104,49,125,55,236,204,228,78,242,254,150,255,67,0,157,16,251,145,158,233,237,141,215,193,242,156,136,187,190,167,204,203,61,201,2,10,170,2,215,117,102,224,133,31,189,13,245,161,74,205,249,232,212,208,148,164,124,147,145,69,214,241,167,22,105,134,44,81,33,172,101,187,138,216,44,202,173,22,223,208,31,243,83,250,229,142,19,25,45,46,93,164,215,164,183,248,161,78,231,181,125,145,217,206,69,0,235,191,73,34,151,253,84,45,76,178,47,177,133,240,92,90,74,214,79,51,154,161,12,75,240,223,235,157,233,140,61,29,38,223,224,132,145,223,223,82,21,3,168,24,100,86,103,22,13,217,175,50,98,98,145,30,103,106,60,218,116,104,50,207,97,77,46,217,19,254,14,218,20,124,91,140,141,209,227,252,191,125,126,119,69,49,251,27,9,14,8,61,205,115,231,9,190,179,68,175,211,127,118,45,104,181,71,132,78,251,105,55,110,224,121,46,195,119,27,159,96,240,114,177,101,219,221,99,33,28,171,231,196,108,85,168,82,190,243,116,165,220,115,168,107,110,201,100,58,239,89,198,100,56,64,206,177,39,77,192,199,56,149,121,135,49,73,151,81,123,166,104,76,126,208,226,13,126,243,72,93,119,191,255,1,128,92,166,164,100,64,245,105,151,202,217,52,197,135,191,178,180,241,60,113,88,129,214,175,137,7,11,197,72,185,47,216,208,239,178,2,75,155,28,128,179,219,229,225,58,244,167,96,2,241,178,136,225,99,159,57,78,211,179,190,65,221,15,65,145,27,98,168,148,102,243,11,23,141,15,176,69,253,48,93,18,134,84,234,50,21,105,148,133,247,110,155,109,245,114,93,115,245,55,172,176,243,122,173,45,47,31,144,120,20,63,185,41,25,126,97,225,153,156,74,133,39,18,13,25,35,67,116,138,84,134,31,103,19,24,66,26,153,68,200,218,206,163,214,47,95,251,221,221,1,132,19,234,85,170,237,206,248,10,141,225,86,224,243,194,11,140,21,116,243,74,52,57,13,221,33,195,192,78,238,188,11,66,53,197,5,56,221,186,137,120,216,198,172,221,251,43,14,10,57,134,27,179,65,247,84,43,169,205,228,196,97,239,11,71,108,61,135,1,69,70,233,80,234,93,30,0,52,126,240,174,6,91,197,40,5,214,101,213,72,120,162,29,126,65,47,113,152,125,52,211,197,232,141,18,149,0,193,87,13,220,23,1,229,199,249,186,244,201,21,146,29,179,209,205,247,39,201,98,150,246,42,96,62,240,235,121,135,66,200,115,35,73,253,66,191,16,57,102,233,58,253,111,102,213,52,60,104,199,2,206,9,37,54,15,123,29,157,22,53,44,39,131,209,20,51,193,209,131,32,94,198,192,87,199,235,215,60,38,19,120,33,231,17,252,110,33,4,165,142,30,180,252,102,184,107,158,172,133,127,164,43,210,64,39,236,216,61,115,151,202,187,147,243,52,59,64,155,125,162,189,110,36,214,129,138,28,227,186,117,104,212,148,56,63,165,151,243,195,221,125,105,198,32,107,134,94,210,98,225,229,60,100,131,216,241,83,240,227,120,162,190,173,84,43,235,70,251,172,137,168,101,93,108,94,147,129,133,211,30,6,243,249,50,174,237,231,163,134,135,71,247,247,246,27,16,153,217,243,229,161,251,120,24,137,134,228,33,94,246,247,184,190,185,53,5,160,226,118,242,13,89,245,14,108,103,68,242,62,37,4,59,189,127,96,240,173,90,55,152,59,29,224,214,135,158,59,191,58,206,112,189,134,154,227,22,132,148,227,228,133,216,225,137,163,165,247,74,129,30,160,123,13,180,25,115,21,20,213,147,175,81,226,251,59,134,194,173,47,203,132,200,22,67,121,129,207,173,128,105,178,132,137,158,50,174,13,232,18,43,216,170,120,23,183,176,91,193,90,145,22,35,246,32,166,217,93,155,26,30,238,229,201,21,81,140,176,46,18,114,111,17,99,133,189,33,116,156,104,210,239,87,125,179,125,113,157,35,15,211,109,114,94,242,65,216,84,134,101,67,206,226,76,225,122,137,127,185,108,250,4,56,200,106,61,182,232,115,6,181,169,194,129,167,218,205,8,160,110,147,241,183,198,195,31,150,123,64,173,208,129,108,253,223,27,72,105,216,252,20,118,207,28,26,166,196,195,120,235,156,87,115,84,151,106,243,16,132,42,50,105,130,154,81,40,189,84,215,69,210,226,85,149,253,188,195,74,113,240,81,12,4,146,199,99,60,124,254,2,27,90,196,170,26,134,244,13,41,92,217,167,168,150,95,15,174,214,156,184,160,31,148,156,14,176,142,106,62,167,198,153,19,24,254,67,239,94,25,173,184,142,190,78,17,55,9,83,251,169,149,121,78,127,57,216,90,234,27,112,246,88,70,84,212,194,20,126,11,88,92,81,212,228,71,191,20,171,33,125,241,13,39,100,144,196,244,240,230,9,208,20,86,255,254,252,17,167,193,65,157,187,89,143,139,89,197,103,125,108,87,150,216,245,17,95,100,135,32,204,220,200,91,224,148,143,54,81,67,200,80,46,87,220,192,20,226,198,89,36,44,18,213,45,139,62,225,78,204,118,36,15,170,58,245,73,95,107,111,201,177,59,7,83,69,82,192,203,114,35,93,44,61,188,104,246,248,120,41,203,70,229,221,122,90,117,36,55,76,179,101,234,124,97,178,28,214,102,142,68,105,142,132,181,218,243,82,113,195,126,227,190,61,90,125,124,205,123,96,249,27,90,121,67,202,187,235,24,218,180,90,119,212,177,169,30,223,208,125,29,212,40,210,101,251,82,77,25,74,46,248,181,51,247,96,125,137,132,232,179,130,247,33,159,146,106,91,148,190,201,96,159,66,190,111,50,143,188,245,126,218,121,104,19,183,85,17,124,81,77,71,197,122,208,108,132,241,229,165,45,101,236,189,145,219,211,87,197,178,60,28,58,11,16,43,69,191,139,175,46,137,244,31,193,90,63,111,194,238,104,94,37,157,179,214,216,234,80,177,249,90,45,221,114,180,19,113,32,231,167,109,12,11,66,160,152,235,217,86,17,131,99,182,241,202,16,35,205,145,4,206,248,87,61,82,30,217,96,235,82,84,100,49,5,130,118,248,142,23,19,197,221,76,153,36,241,233,78,50,14,247,1,107,34,190,3,39,48,29,143,93,122,239,154,255,190,45,2,145,35,141,91,202,158,38,91,204,249,217,169,160,28,156,109,157,231,26,144,205,128,169,68,249,134,40,89,76,136,111,201,246,149,202,202,24,121,91,188,2,214,199,137,139,198,241,89,130,141,197,36,18,200,194,203,59,181,89,225,193,105,76,27,246,104,138,241,211,209,167,200,237,46,181,56,145,140,2,46,75,229,73,24,52,143,4,127,25,95,96,54,237,76,24,114,23,122,0,2,10,155,181,151,25,98,25,224,247,50,61,83,224,221,57,96,13,186,85,237,109,147,103,121,77,105,48,230,149,192,191,178,23,28,44,168,246,8,55,129,161,11,137,107,65,243,152,200,33,229,223,217,238,24,202,250,235,153,90,84,68,7,139,240,107,177,117,242,31,189,252,253,70,189,48,31,220,238,253,147,212,134,253,123,40,218,228,175,215,162,61,142,194,62,250,206,181,49,45,142,202,203,41,234,54,119,61,27,212,63,199,228,176,19,219,240,163,120,87,123,191,73,108,6,128,40,145,228,78,8,32,104,169,196,204,57,56,103,205,16,8,249,164,196,104,89,94,89,175,7,56,42,13,178,200,108,87,244,121,35,73,64,38,58,95,0,127,200,74,113,139,51,75,221,139,60,42,236,104,208,66,151,229,220,156,80,86,233,9,110,31,94,250,79,125,15,119,100,167,143,118,32,221,81,128,113,172,74,26,58,71,147,127,180,176,66,45,217,60,140,237,165,196,6,18,122,68,178,116,127,170,78,234,77,47,110,251,50,175,2,57,151,102,28,95,159,243,123,70,30,83,228,54,188,76,161,221,185,90,225,63,126,217,136,254,176,163,25,26,125,18,138,207,191,96,235,184,220,118,106,241,130,94,70,52,70,190,224,49,53,195,230,59,134,94,74,168,132,41,95,216,207,75,68,208,54,5,5,167,187,147,93,201,139,41,120,129,66,93,94,160,22,149,195,139,160,153,226,175,9,134,153,37,15,79,180,135,36,139,207,178,251,11,185,44,169,16,206,47,207,77,192,45,76,219,173,94,14,45,92,7,43,209,183,137,192,161,201,1,9,7,220,138,160,35,70,208,58,53,79,244,193,105,117,242,139,51,50,235,238,173,118,114,64,239,33,112,49,162,120,255,145,12,48,143,119,188,119,202,86,24,253,135,204,166,181,108,14,64,3,11,177,175,186,82,1,17,165,23,183,183,78,128,236,141,239,65,233,137,35,97,179,232,231,118,64,149,61,98,226,152,230,142,151,3,121,63,210,53,254,155,199,14,125,216,226,43,104,147,212,15,22,235,21,55,111,111,16,124,144,202,139,156,45,119,69,119,137,239,135,164,6,123,22,123,130,212,50,140,245,221,8,131,232,30,183,238,143,4,106,191,131,86,78,48,80,125,159,3,185,226,0,223,87,111,66,24,83,73,1,77,131,173,114,35,68,29,120,191,126,208,111,62,150,41,29,179,16,136,114,63,25,89,46,216,50,186,107,6,238,7,69,65,190,92,19,225,148,49,215,27,40,4,164,136,187,47,101,103,245,56,188,108,89,40,119,219,53,222,239,246,229,98,93,46,182,27,131,43,181,85,196,130,215,69,56,244,108,126,242,131,228,103,189,252,51,232,154,76,16,217,190,246,168,140,246,104,178,240,61,230,112,89,145,151,82,112,139,109,52,234,104,160,133,242,138,143,131,109,62,140,26,164,220,159,134,250,137,56,5,133,216,215,107,78,119,161,62,130,246,254,119,36,28,13,200,86,232,64,203,250,58,143,223,61,89,17,241,66,236,239,147,73,216,75,250,139,234,113,106,144,185,230,204,55,92,85,97,228,39,47,143,139,217,209,121,196,59,131,142,75,246,74,216,133,44,20,214,49,105,36,235,247,205,214,214,135,116,32,215,25,20,72,50,16,245,232,211,231,136,193,251,167,151,0,208,198,177,59,175,110,102,62,79,244,190,135,127,71,176,122,121,236,148,200,111,99,114,80,6,75,177,79,0,200,90,113,45,84,187,85,31,210,92,138,91,245,31,167,105,222,229,151,146,234,96,164,206,127,101,132,5,248,99,200,58,246,196,244,25,99,214,160,211,88,60,10,226,52,24,217,43,212,202,166,173,47,193,77,247,99,194,95,163,146,15,113,23,223,23,237,122,106,250,206,212,12,165,252,117,40,177,199,112,3,168,116,136,174,255,50,58,167,198,164,25,198,222,119,225,10,206,214,183,83,223,22,40,231,10,152,18,11,144,29,177,189,218,137,18,48,96,17,191,164,46,243,36,53,90,246,66,42,39,11,1,193,10,66,88,137,17,30,167,201,232,150,255,72,164,25,187,201,204,140,8,102,154,223,5,239,255,60,108,146,138,172,104,219,245,192,168,112,150,190,196,68,255,208,77,250,163,168,199,209,252,134,160,233,194,60,75,206,118,200,110,95,206,211,197,50,191,69,241,225,217,120,142,21,130,181,119,126,208,76,8,204,177,80,254,230,127,175,28,5,137,19,142,10,170,5,61,47,138,87,117,118,153,159,151,100,89,90,20,231,89,156,183,101,110,114,205,100,253,125,224,3,237,24,72,120,243,74,229,184,90,118,102,196,31,140,73,137,248,184,196,107,28,138,80,254,28,35,94,119,130,205,84,160,117,129,227,115,87,89,124,67,151,159,194,108,140,48,9,215,152,220,47,75,83,231,235,32,102,13,152,135,250,206,224,15,182,192,249,192,47,254,10,238,2,196,108,139,45,150,254,231,207,237,197,62,103,7,176,193,4,77,231,240,243,15,5,186,119,213,233,254,254,202,150,160,35,205,22,159,236,220,228,227,44,106,194,178,92,169,11,190,82,223,62,66,6,18,139,135,119,176,63,65,57,12,73,54,253,45,20,69,13,73,116,176,223,81,34,155,66,199,247,29,138,116,73,255,86,9,254,26,76,157,37,207,89,50,165,107,96,87,85,239,218,230,84,125,148,74,107,195,64,216,114,164,244,167,239,121,63,191,69,148,38,203,19,68,41,180,180,122,0,193,136,17,71,99,147,245,226,42,221,12,127,58,254,175,247,104,177,169,222,98,232,35,46,221,212,53,136,115,31,129,199,219,93,115,122,98,251,80,140,68,229,7,14,111,245,222,171,194,177,16,69,100,230,254,122,7,139,236,199,106,253,138,216,118,230,202,50,47,96,190,202,148,165,217,52,210,225,195,153,175,228,39,51,121,18,238,76,161,187,207,159,190,33,209,171,186,151,84,131,244,14,210,189,127,104,28,2,229,167,106,114,110,162,29,226,175,239,130,231,155,144,145,233,154,109,49,54,63,179,132,235,139,159,165,142,178,43,30,13,31,120,44,239,24,185,226,82,29,208,162,156,35,30,176,33,47,40,47,13,209,212,5,57,56,36,234,207,38,18,76,153,46,0,167,160,210,80,75,255,190,11,168,104,182,98,127,75,69,251,207,107,253,147,83,153,95,241,154,30,13,25,133,253,163,45,155,115,251,37,64,10,115,48,27,189,121,78,236,13,169,6,111,153,234,11,249,197,214,5,151,74,232,186,104,190,72,136,122,200,17,84,107,237,69,128,118,50,144,25,43,210,30,145,96,0,138,11,86,7,106,234,122,84,125,1,130,78,107,211,20,35,142,82,194,60,236,254,10,178,95,114,201,122,218,236,59,1,110,144,89,114,59,94,120,162,30,254,17,75,237,187,48,7,240,177,172,48,17,104,93,195,226,189,38,6,81,107,94,95,43,85,19,111,58,160,192,195,91,40,137,54,142,130,218,203,67,254,51,44,200,49,164,98,43,14,135,196,95,18,51,160,141,33,140,13,182,232,21,158,28,22,96,249,26,63,152,133,254,191,218,66,121,99,52,162,190,76,18,109,137,188,130,92,191,246,119,240,37,88,25,37,203,241,111,254,32,124,113,129,155,7,106,246,53,245,100,128,152,136,40,246,119,220,249,128,140,137,230,243,157,219,151,192,136,59,237,125,150,197,233,94,76,57,229,118,166,160,136,64,233,153,37,253,71,21,143,196,69,94,157,229,166,4,133,201,125,227,145,14,182,243,182,129,251,194,250,81,108,226,44,86,84,253,142,250,248,28,121,128,85,20,237,6,42,146,86,3,216,33,254,1,138,155,81,42,245,39,82,154,146,156,228,113,155,121,37,246,131,147,180,241,218,222,143,112,212,138,188,225,201,3,43,73,3,235,119,78,88,214,51,68,139,20,97,71,177,125,166,5,147,217,248,132,150,157,81,182,142,241,130,89,193,108,99,185,76,2,117,67,221,153,98,85,230,40,73,106,143,230,10,159,234,247,91,184,226,16,250,11,166,63,103,163,230,144,70,28,206,49,103,110,130,48,11,245,231,236,254,108,129,141,228,174,245,233,48,77,183,23,227,204,58,241,48,137,9,51,93,234,158,3,64,157,117,150,211,225,93,154,133,158,212,116,210,217,209,74,135,6,14,116,11,177,234,86,214,141,25,96,34,225,230,165,2,170,145,39,121,149,126,155,111,231,172,36,26,163,176,188,205,212,98,255,3,201,95,29,227,169,68,238,17,60,102,93,56,150,161,47,3,32,105,76,208,1,26,56,169,42,226,183,202,14,90,120,100,110,98,89,175,90,176,249,148,152,19,168,180,132,131,24,146,176,206,127,107,221,151,195,217,35,119,197,109,252,55,201,102,7,71,3,234,214,48,171,101,241,145,118,86,47,131,199,251,196,55,56,85,90,3,48,173,10,49,16,62,163,7,123,231,9,117,130,198,124,186,237,41,97,112,151,197,191,106,210,2,89,188,38,50,127,4,109,45,248,147,135,62,182,49,115,26,107,227,221,114,103,124,189,108,188,24,171,171,111,61,23,105,248,214,72,6,44,6,96,133,64,141,91,186,99,15,205,255,229,132,70,136,150,134,75,240,94,199,73,182,164,50,75,251,78,147,90,73,131,40,193,132,222,154,73,42,46,3,21,195,74,110,194,3,83,1,147,93,247,8,38,147,234,16,109,93,219,109,237,107,184,50,99,107,21,232,8,180,0,8,190,205,213,153,40,178,21,212,104,96,223,182,191,191,12,207,131,247,226,150,53,211,80,90,245,202,221,45,36,232,103,125,2,151,87,209,16,174,43,106,231,98,160,14,6,181,21,113,11,226,5,38,158,242,210,238,231,117,182,229,58,55,211,180,171,86,11,207,94,4,102,57,216,155,100,20,157,26,110,21,62,252,100,228,169,152,162,1,36,111,216,242,97,107,151,137,53,130,178,217,8,165,223,58,33,136,174,116,122,59,243,1,154,97,110,77,190,126,199,177,150,202,207,92,180,225,233,166,72,113,60,77,204,30,22,54,39,207,237,94,203,218,202,81,228,156,203,69,18,197,194,64,248,125,223,39,51,47,234,97,255,50,185,245,44,51,139,96,126,69,202,104,235,233,161,28,123,228,44,73,69,231,172,73,244,251,47,167,69,1,64,69,133,161,52,201,240,190,221,131,162,71,148,226,31,211,244,220,86,160,99,236,148,81,235,223,248,146,129,185,241,178,253,94,99,91,157,59,62,188,105,81,239,205,151,0,44,183,102,113,154,166,164,142,238,242,136,23,146,222,122,146,121,56,164,153,6,102,130,153,175,106,127,169,1,176,171,20,100,64,51,160,128,234,167,106,141,198,150,227,140,238,182,89,43,55,6,235,6,124,48,127,104,240,203,248,43,27,55,0,6,90,53,100,40,94,252,18,59,135,111,152,93,65,42,215,212,43,53,124,8,100,1,86,255,145,21,21,234,173,247,172,62,153,94,159,234,51,166,74,117,200,119,103,190,0,244,97,48,154,69,178,239,246,123,67,215,91,232,186,138,231,90,53,237,67,4,179,221,236,70,125,154,66,231,42,169,91,140,9,30,225,49,63,121,182,104,0,66,66,207,91,226,212,104,37,18,21,224,84,130,45,72,42,0,69,14,91,197,14,67,133,230,54,20,26,155,178,209,218,132,72,190,158,213,14,191,235,147,57,24,159,92,37,61,121,104,89,214,66,167,110,5,213,164,73,81,41,61,121,3,173,123,202,213,65,56,63,148,55,145,137,82,88,11,250,65,143,203,191,185,33,98,128,22,178,253,135,65,227,76,105,56,177,223,177,83,119,175,240,241,207,83,36,135,31,92,74,224,117,191,74,162,160,102,187,193,235,188,81,122,180,87,100,253,55,154,69,128,208,22,209,19,195,124,75,134,159,177,212,42,96,210,120,150,138,152,107,112,90,211,110,63,193,72,252,120,159,129,232,211,118,221,78,242,4,141,91,184,141,190,190,247,123,150,13,52,249,110,189,193,95,151,101,148,182,176,106,84,9,103,229,17,96,198,245,174,25,205,177,71,14,236,34,126,168,1,112,64,68,228,185,194,129,236,138,64,130,49,67,215,58,29,101,95,133,89,87,11,14,119,194,116,214,190,39,211,63,106,21,107,131,106,27,70,152,55,64,88,150,165,165,26,84,117,140,141,177,200,35,79,129,126,227,108,94,67,228,6,208,61,53,113,85,221,241,150,144,245,242,150,161,78,222,155,149,251,99,178,6,183,203,185,223,62,114,139,209,136,201,158,60,61,101,86,143,182,47,220,29,194,89,99,77,157,148,201,51,182,108,99,4,204,86,21,198,234,42,8,233,5,47,185,91,115,41,38,155,4,76,17,181,17,243,168,213,200,202,253,108,90,60,131,199,8,65,198,168,21,28,154,229,4,173,174,166,29,220,135,214,233,5,165,171,6,219,154,229,45,67,102,126,20,249,158,33,53,1,198,22,125,151,75,208,24,27,203,251,27,106,240,174,92,139,169,9,165,197,79,255,204,127,37,109,32,77,134,76,102,24,35,250,17,223,8,234,156,159,53,248,59,200,217,26,182,29,151,18,39,133,57,41,123,190,104,47,55,157,69,164,28,99,182,10,9,59,176,57,91,16,58,100,76,191,56,32,175,123,71,64,121,105,204,38,222,127,123,177,203,70,212,41,111,106,14,211,73,86,6,79,70,122,10,94,122,85,118,83,186,122,95,199,116,82,224,87,241,236,27,180,33,193,179,122,217,157,30,255,69,160,98,89,245,143,16,246,28,2,98,92,123,37,70,78,44,161,146,211,131,145,100,0,39,117,80,110,160,193,181,145,230,75,103,173,130,20,78,75,242,238,152,195,157,208,100,135,215,139,52,113,106,215,116,65,134,170,55,106,91,79,209,75,137,223,139,34,155,204,177,131,86,255,114,55,19,2,179,116,101,43,218,38,203,28,224,160,108,136,81,129,246,165,240,135,2,44,233,73,195,220,9,241,9,198,31,68,180,202,68,87,152,129,102,53,250,236,2,166,185,205,25,26,109,205,249,224,219,190,127,14,184,164,158,120,177,169,123,250,235,131,220,85,63,156,91,50,16,219,177,175,218,223,231,104,46,232,213,138,184,230,0,127,197,31,114,75,50,49,51,15,108,178,215,220,28,172,61,250,247,147,176,30,104,29,53,216,72,146,146,229,26,70,151,198,166,23,119,183,84,245,150,218,139,170,236,118,5,83,64,55,175,105,199,245,115,218,236,56,191,19,112,178,164,47,41,31,153,100,65,64,175,24,85,166,185,252,81,63,46,31,100,188,141,16,80,240,219,2,107,164,135,123,33,229,218,71,140,33,121,71,9,9,53,99,148,168,21,114,54,109,254,139,184,168,166,99,149,108,39,4,235,90,14,241,39,250,198,2,40,31,236,138,44,41,123,161,175,18,225,185,40,95,164,138,193,14,31,236,42,226,13,186,194,199,172,99,75,161,103,174,205,91,108,230,200,136,99,217,162,11,174,254,132,240,222,231,52,13,240,56,130,116,20,184,167,165,141,171,190,115,6,242,159,111,75,103,151,22,195,32,127,88,93,46,190,117,11,155,178,87,3,198,50,155,44,181,108,106,255,101,172,10,132,87,74,16,34,113,38,25,131,161,56,82,154,189,152,248,175,168,46,75,111,220,245,185,249,252,216,135,29,249,243,143,237,21,239,130,113,248,53,21,42,38,250,198,158,109,70,157,213,23,225,118,157,227,204,201,125,142,26,80,246,72,109,87,130,180,150,170,204,255,163,193,65,178,133,69,253,97,232,138,255,210,145,118,137,52,33,230,244,147,131,36,171,224,117,222,222,202,25,46,36,78,37,209,215,51,96,190,74,29,137,12,220,60,170,222,101,15,171,37,66,77,110,49,115,151,29,214,194,96,243,36,127,132,72,108,53,82,188,177,171,25,237,206,136,83,48,10,142,65,123,252,154,56,9,80,148,116,1,182,97,218,76,184,213,129,219,99,141,194,24,191,132,130,247,121,69,188,9,79,42,6,225,134,75,247,210,58,13,129,66,130,115,253,26,46,16,246,95,97,139,177,25,238,32,33,170,177,82,181,177,145,199,103,32,243,211,175,140,136,89,216,107,10,88,67,194,133,201,80,100,67,63,7,160,195,61,183,57,110,164,22,157,101,46,254,194,49,181,28,22,112,219,199,30,25,157,143,87,136,188,205,22,192,189,97,249,222,119,216,63,32,154,235,224,107,50,221,104,194,129,217,54,138,197,123,96,73,92,39,117,128,221,94,245,186,139,24,60,116,153,124,86,41,72,140,211,181,13,19,150,191,237,236,221,143,93,190,151,80,153,166,8,23,218,10,156,34,86,167,67,232,195,221,140,68,215,188,224,198,198,149,172,71,121,114,80,220,17,67,168,31,30,1,77,182,44,160,63,12,25,9,134,186,136,207,224,29,35,102,90,108,75,114,27,6,203,239,154,176,134,110,194,90,167,124,64,143,113,223,183,43,137,44,127,12,70,114,159,144,194,238,127,28,97,230,151,212,37,100,133,139,127,129,21,236,100,123,208,201,187,108,204,188,44,99,148,94,65,100,223,237,192,81,120,94,158,251,127,63,171,242,214,225,177,127,115,139,103,16,222,76,142,47,174,18,182,169,127,157,79,26,191,243,255,186,120,192,42,240,207,173,173,151,177,33,236,100,186,239,69,18,149,249,233,7,77,161,184,13,154,51,43,13,87,168,164,156,146,248,201,0,122,110,30,212,99,133,244,150,116,89,121,134,64,117,128,59,29,251,58,201,65,125,12,204,178,255,14,219,146,169,121,43,170,7,245,194,194,241,109,102,22,8,238,107,25,47,174,179,159,154,202,220,35,63,172,7,173,150,220,229,37,87,22,141,74,109,186,217,4,167,89,85,103,16,6,50,163,186,178,51,63,180,89,205,13,41,167,188,50,131,222,95,218,134,69,125,83,3,193,253,218,146,70,125,106,14,220,48,243,212,201,208,146,181,11,250,240,165,125,211,140,199,41,200,88,191,138,5,137,13,46,219,92,34,139,201,213,221,45,139,208,56,127,115,38,204,103,169,153,33,76,235,174,183,172,129,197,220,193,223,65,146,171,219,208,19,167,128,70,76,181,217,16,27,41,121,198,115,19,91,108,192,241,140,61,81,174,162,168,54,84,225,97,184,54,167,35,123,179,139,227,202,87,135,155,144,146,12,68,61,97,31,166,152,248,25,76,232,10,30,120,53,42,199,97,23,8,30,92,55,248,224,108,38,10,207,2,106,196,255,89,147,148,202,9,2,228,213,126,241,115,5,243,29,222,47,105,175,176,249,238,113,147,62,150,68,158,199,92,126,41,10,165,174,132,131,253,133,210,162,170,125,140,4,208,156,243,83,192,64,61,63,117,37,210,152,160,149,79,67,212,40,205,197,15,184,61,55,57,51,31,21,22,164,59,37,52,245,241,16,11,217,15,198,129,243,123,115,150,229,111,254,160,30,114,106,177,110,229,75,210,34,117,237,10,90,254,46,137,186,114,161,17,234,18,21,171,72,162,27,104,108,136,31,108,85,75,205,171,164,175,21,153,159,77,94,228,61,244,34,91,175,37,185,21,3,175,34,108,191,95,19,103,15,27,75,157,220,71,65,60,175,87,26,87,51,172,238,229,175,119,135,117,153,161,195,169,194,41,132,120,155,28,116,47,193,149,134,182,136,243,192,114,240,52,254,167,221,80,60,61,227,54,7,245,21,180,177,50,224,183,32,194,5,114,154,63,124,222,3,10,72,123,89,218,115,206,254,234,182,118,138,200,227,135,221,135,78,74,55,156,113,85,194,15,63,112,48,56,193,52,175,46,42,180,237,12,222,25,92,234,251,155,78,9,194,16,158,164,237,174,107,91,114,40,157,113,106,65,94,59,141,161,168,61,87,40,83,45,46,126,83,124,55,243,219,236,77,66,43,178,91,131,55,67,148,252,240,42,113,7,94,62,138,249,168,55,242,166,77,79,102,236,180,103,193,59,188,53,189,148,5,230,236,82,127,39,88,134,86,16,189,192,243,190,199,104,189,152,145,82,117,33,154,171,183,188,249,43,105,226,157,185,237,53,35,225,201,233,215,235,242,88,78,140,83,34,208,197,255,176,123,49,220,46,218,200,245,191,131,10,29,173,161,44,191,130,38,186,242,138,62,98,182,21,199,161,57,83,29,97,60,227,111,100,199,241,192,248,74,31,122,101,202,236,199,59,86,34,160,76,127,28,206,71,74,206,88,58,78,100,36,100,103,210,140,211,139,160,195,81,121,166,112,131,31,174,99,180,118,210,131,88,46,245,128,85,28,228,146,190,153,202,2,212,10,235,192,254,103,24,14,223,229,120,150,102,214,59,38,222,30,5,179,220,206,219,38,113,204,153,189,64,125,131,51,144,19,246,109,49,71,98,51,219,3,157,127,197,188,39,202,25,1,68,66,145,43,192,73,65,14,26,178,235,143,99,212,184,69,162,127,127,57,63,37,187,80,88,98,67,216,212,53,51,54,85,135,209,93,220,206,80,35,93,152,44,18,51,12,90,81,199,150,61,209,105,65,66,124,196,128,41,207,205,206,214,194,250,115,245,81,235,49,237,237,133,131,14,86,253,25,103,121,238,251,36,190,96,111,81,188,79,16,93,231,16,80,123,87,105,221,61,128,225,71,32,166,113,219,93,25,36,45,139,34,24,5,77,22,50,43,29,217,222,9,61,219,112,202,4,160,28,127,94,108,235,27,5,178,23,188,192,117,204,233,223,27,88,26,90,13,182,171,27,124,85,245,37,230,164,88,246,61,53,128,223,159,49,218,59,109,7,88,109,148,64,248,147,106,223,143,208,130,77,2,108,21,251,92,212,77,84,189,219,76,236,134,243,143,47,139,113,58,40,248,179,32,171,226,131,234,8,3,88,37,179,246,239,135,182,25,165,66,172,125,252,189,153,204,108,80,42,107,251,146,128,118,93,51,58,249,239,144,161,72,116,8,64,57,109,186,57,67,43,49,117,51,119,24,14,150,43,188,95,140,212,161,53,205,253,214,106,98,45,158,182,136,12,162,252,24,133,219,5,84,60,86,93,253,35,204,216,189,126,148,23,131,140,226,14,238,147,95,169,145,121,66,24,139,93,199,89,207,206,84,195,124,54,15,88,208,195,91,205,18,41,243,110,101,36,134,37,59,23,44,203,233,253,84,171,123,139,240,12,198,186,121,0,95,120,240,20,30,134,30,12,62,126,23,19,187,48,177,242,174,252,177,25,0,211,172,254,195,24,120,67,29,216,13,206,195,50,119,59,11,218,233,89,123,96,207,78,77,61,159,120,13,100,252,29,122,35,18,111,116,28,251,163,153,35,18,54,108,219,208,132,16,35,28,39,213,137,99,147,159,186,77,237,69,114,16,199,66,167,92,230,42,249,191,192,148,20,251,149,137,122,57,146,90,17,89,86,45,121,148,114,225,140,88,148,151,71,200,109,51,127,0,136,141,100,96,234,221,178,16,188,66,251,9,238,183,140,32,167,38,251,148,115,219,134,39,52,14,154,250,175,90,204,44,97,42,53,190,169,72,199,242,44,126,15,161,192,95,130,185,194,12,14,33,150,168,161,162,255,42,219,53,13,197,12,243,225,12,45,8,105,200,29,0,94,127,125,153,92,194,158,8,88,52,202,217,69,145,95,195,94,191,23,204,73,155,86,10,22,139,67,213,11,139,59,232,90,249,129,213,105,22,48,249,83,139,133,19,33,237,99,195,168,64,251,236,20,14,75,194,157,24,204,16,91,83,240,203,187,63,129,160,56,244,28,105,88,120,17,25,79,230,31,208,188,245,82,123,189,6,160,1,105,228,84,152,27,164,129,37,238,155,6,207,144,2,141,222,73,162,106,247,132,143,78,79,49,164,64,115,101,6,156,20,195,197,165,11,61,176,16,207,214,50,48,252,44,100,39,21,243,138,172,115,185,107,49,123,34,239,2,100,37,98,159,69,126,241,17,130,219,212,144,13,49,254,139,194,47,128,215,7,63,13,134,177,191,170,208,14,253,20,80,59,181,6,78,23,221,95,141,133,240,228,150,43,15,92,77,228,242,215,89,202,170,209,83,2,233,200,192,201,250,196,136,145,246,195,39,236,151,225,168,207,241,199,60,13,157,231,162,175,236,147,61,81,253,230,12,2,45,114,58,158,67,168,108,206,45,150,107,96,96,90,180,242,23,29,146,164,43,63,183,218,204,136,208,95,56,75,176,225,196,118,113,7,41,207,65,22,75,7,198,255,57,194,17,166,95,125,98,175,242,11,184,56,62,163,127,78,125,129,167,202,219,8,154,79,29,13,49,127,71,255,192,204,192,224,8,161,209,155,144,78,251,2,84,118,204,218,225,67,241,8,220,116,208,223,248,240,115,95,84,212,53,209,241,104,164,56,201,137,8,4,239,111,148,7,69,129,242,47,233,105,130,139,66,151,252,212,254,101,159,211,160,161,240,156,56,48,215,164,166,174,76,175,184,50,35,187,150,38,241,218,231,87,147,208,66,170,250,208,58,100,202,134,121,145,193,188,100,67,4,192,155,122,195,90,198,108,169,109,73,10,252,103,164,147,41,198,255,73,22,86,90,120,198,206,120,115,31,131,43,233,114,204,84,34,239,161,123,236,177,130,143,179,80,93,70,141,222,239,196,40,183,60,126,160,191,104,133,41,46,49,98,63,137,216,190,172,53,35,88,14,142,192,103,50,197,188,238,175,99,93,153,178,101,124,142,172,4,64,253,13,52,42,13,114,16,94,60,189,186,49,249,141,144,188,71,151,62,226,192,21,29,77,203,26,76,27,92,175,251,203,162,89,78,202,175,88,208,194,205,235,83,196,177,184,205,54,104,148,204,85,72,123,205,140,89,238,176,49,212,248,215,195,139,253,190,237,29,131,45,237,253,107,147,164,31,161,228,144,234,183,126,94,103,56,90,16,233,120,39,194,2,21,89,137,11,172,59,168,247,242,91,16,166,168,37,211,4,33,62,15,89,217,32,12,171,206,40,240,70,213,49,209,15,68,50,106,48,88,22,111,25,196,233,12,113,43,203,214,238,32,39,186,121,234,29,100,25,90,214,240,106,94,7,207,62,209,86,76,80,77,33,28,201,119,57,131,121,35,37,223,183,113,102,32,71,177,60,205,154,106,239,54,162,218,113,32,129,223,203,75,95,187,117,25,161,236,200,70,245,11,100,81,171,252,88,210,193,98,239,169,121,223,108,209,76,85,12,238,29,130,121,99,69,172,64,248,252,235,10,183,40,19,124,138,134,194,148,188,72,15,228,125,123,168,169,230,225,176,74,132,131,159,192,120,253,49,2,159,208,164,254,151,22,20,64,156,132,149,55,69,240,242,18,254,88,142,62,252,143,129,95,157,68,148,173,137,110,10,33,72,87,226,234,130,235,17,94,172,171,212,67,182,55,54,82,222,200,132,213,225,81,169,192,221,59,132,231,33,243,44,217,233,221,88,191,73,114,129,141,204,214,47,69,104,77,142,157,242,209,106,63,88,252,154,86,53,133,187,227,184,28,25,24,85,35,178,18,209,11,158,99,131,211,74,220,222,0,1,156,27,254,84,211,164,80,124,52,23,43,21,92,20,89,139,251,70,73,3,91,141,40,92,62,68,49,87,128,136,140,13,10,148,59,113,205,213,209,211,83,146,38,195,46,122,88,121,35,88,170,222,34,114,225,220,197,170,252,39,34,42,77,36,193,164,234,62,246,180,124,230,82,107,180,60,142,160,128,33,104,187,64,197,114,131,132,30,232,250,73,97,245,148,181,79,66,147,136,219,45,86,45,224,164,123,143,7,214,225,173,243,239,154,167,40,83,234,248,175,100,199,37,140,231,49,43,167,104,229,181,177,204,44,25,177,98,78,225,155,222,18,35,168,170,38,213,34,91,237,41,188,81,66,242,191,223,53,190,6,119,54,153,21,135,160,236,167,126,141,80,176,203,52,236,128,8,156,90,255,90,140,199,103,126,6,56,241,93,131,192,246,244,115,56,245,75,48,76,73,179,251,108,3,154,227,175,60,239,240,44,155,132,105,216,143,146,200,131,26,139,167,76,90,130,70,17,104,150,120,118,53,133,66,98,212,157,65,46,58,26,20,41,18,99,78,113,235,24,191,15,1,95,130,105,248,29,228,215,98,131,128,211,50,31,129,71,232,77,144,194,24,26,88,25,223,51,196,151,11,20,94,11,208,34,20,51,173,242,189,201,2,252,0,235,244,222,214,41,98,160,61,178,39,193,90,23,119,122,255,27,153,225,75,56,156,207,0,243,126,211,160,221,71,96,190,101,54,238,66,196,99,253,166,168,61,147,23,122,99,216,80,37,139,228,45,181,116,126,208,96,235,237,90,113,92,120,68,171,32,236,198,208,52,55,243,166,44,224,196,28,232,124,152,217,117,232,194,22,190,204,61,184,45,245,168,227,122,249,12,115,27,197,31,175,125,189,13,36,71,199,227,102,158,99,65,85,28,95,247,101,161,13,203,133,68,3,246,139,28,38,215,78,70,229,251,139,28,85,247,240,179,75,242,157,27,144,19,163,32,75,162,135,65,148,138,210,46,87,199,147,38,155,211,229,57,83,66,134,93,161,158,237,195,86,113,132,95,151,179,23,173,65,100,109,198,208,197,21,109,241,122,96,79,54,114,86,103,232,121,13,226,114,108,218,125,207,74,17,245,212,58,88,147,151,210,237,110,180,64,158,62,113,115,244,107,117,20,187,239,59,162,2,46,144,220,249,133,253,199,203,111,144,99,59,49,70,120,178,51,229,210,250,138,93,212,242,135,161,104,149,228,21,110,216,220,20,210,47,57,196,217,207,220,245,42,185,164,56,64,200,176,41,160,95,154,211,65,104,132,46,165,203,129,55,122,246,139,166,32,244,147,60,94,15,53,193,62,194,212,237,79,10,131,28,249,10,186,67,177,147,255,38,184,248,151,37,57,183,240,40,63,170,141,23,215,167,191,184,233,120,173,99,93,20,64,163,243,102,176,69,171,233,2,114,206,96,33,110,36,21,185,10,66,180,230,172,202,200,146,55,92,73,14,173,59,227,185,128,89,21,153,54,133,241,196,65,210,166,244,2,198,242,176,106,135,220,129,149,206,67,164,235,240,95,219,148,93,207,26,115,39,172,208,130,25,15,11,127,120,126,147,150,9,0,244,196,83,72,190,106,53,248,227,47,204,244,204,154,124,61,192,227,147,175,182,83,86,115,143,113,8,195,167,92,207,19,222,180,21,198,115,208,185,244,8,163,30,169,202,39,113,197,199,59,200,89,158,163,79,87,205,231,100,120,42,178,209,35,226,253,120,49,3,123,198,233,217,48,143,60,48,204,37,38,127,48,78,23,80,15,52,32,229,28,115,105,233,34,235,1,1,204,168,169,72,11,34,72,7,234,227,125,155,52,156,211,8,174,139,120,183,10,93,28,23,162,132,9,4,84,37,92,78,28,94,162,221,83,51,142,178,107,194,25,64,78,1,82,252,152,140,15,152,109,134,188,109,133,149,237,207,84,98,70,232,43,106,7,151,149,219,204,14,35,180,255,36,118,241,239,177,136,146,117,1,156,155,225,89,233,32,14,48,222,120,231,88,94,103,202,204,116,69,65,15,104,45,25,251,0,67,82,191,138,188,15,158,55,92,92,181,193,164,24,220,88,14,189,183,229,130,205,38,217,69,72,238,249,161,46,105,162,127,159,253,71,230,244,82,199,122,177,16,76,170,32,149,197,97,187,21,233,94,115,34,207,63,215,190,125,90,203,40,194,133,188,46,133,85,103,167,148,21,243,242,85,57,254,166,66,28,168,186,209,66,58,15,23,65,38,192,35,65,152,8,37,211,202,194,1,193,216,25,30,83,205,165,227,184,141,120,25,210,150,73,239,139,84,213,16,193,176,22,84,119,202,188,170,30,90,34,154,120,146,212,34,90,184,49,157,114,197,23,15,180,222,172,96,92,162,144,224,63,180,51,242,16,8,115,173,42,94,20,241,23,73,116,55,32,7,4,37,54,89,56,228,178,41,252,141,51,58,186,58,27,96,79,27,1,125,66,76,187,108,115,44,225,119,22,82,123,17,32,23,228,48,77,80,153,63,185,76,71,33,4,57,210,162,80,144,77,145,173,135,141,38,64,83,147,192,186,139,88,162,70,75,48,6,174,182,200,187,85,147,63,9,174,20,97,159,178,133,233,133,185,216,45,195,144,23,98,73,179,208,143,204,170,139,64,33,190,69,117,237,41,161,89,13,41,73,126,133,237,83,139,101,79,5,43,179,219,242,184,157,61,27,14,54,145,200,167,134,42,95,147,79,203,216,3,242,134,85,151,182,11,132,171,219,85,146,235,107,139,88,94,11,171,157,181,143,58,108,106,87,20,241,161,120,88,89,68,4,137,85,37,150,156,89,133,226,161,4,21,140,59,227,193,236,55,5,179,137,139,84,206,190,255,2,229,162,250,72,254,249,243,170,116,26,213,232,218,89,78,178,115,239,241,32,84,138,114,171,176,218,205,242,94,241,149,88,92,50,118,229,40,105,141,167,89,68,31,216,2,68,148,208,158,25,247,250,253,178,131,98,175,195,106,126,184,66,176,195,190,155,86,181,165,144,177,162,213,113,42,101,220,247,151,34,86,123,224,164,217,223,201,35,161,148,202,34,37,141,207,48,214,31,237,191,38,51,195,223,38,36,54,24,219,78,83,39,33,56,178,221,46,108,223,47,178,158,111,144,107,78,98,49,240,244,122,157,206,8,63,20,104,63,109,4,98,49,62,234,27,154,13,23,82,110,28,227,97,19,28,17,25,24,147,17,106,138,83,197,17,255,231,228,128,192,138,66,222,252,98,123,254,108,30,53,139,91,191,91,95,107,4,56,135,35,162,26,147,146,228,58,181,161,188,74,10,138,67,155,93,153,148,109,165,124,192,61,92,205,186,156,171,187,28,24,101,149,87,173,207,172,7,20,103,173,132,5,108,3,245,37,8,253,76,83,127,224,245,193,130,253,66,64,210,0,243,137,90,191,225,42,215,201,107,89,22,224,130,159,55,201,16,29,214,186,193,245,55,242,24,19,16,68,22,19,101,215,214,239,108,216,46,12,121,213,161,161,206,219,160,138,115,218,3,1,179,84,142,241,133,30,166,255,133,67,87,210,64,89,64,234,188,49,110,59,158,99,18,192,56,204,134,148,106,240,1,199,137,46,37,54,128,106,176,130,168,59,81,16,77,252,176,183,120,89,226,45,70,106,86,11,167,52,155,24,156,239,78,7,122,181,114,177,51,225,37,95,123,240,22,124,183,6,87,124,207,51,2,114,203,173,119,59,227,101,254,198,200,57,120,54,49,8,51,105,219,61,77,196,216,58,0,171,209,36,213,101,223,84,32,161,154,52,178,227,30,113,93,204,81,222,35,202,60,117,46,25,26,206,233,20,121,245,165,86,22,219,218,14,80,43,253,146,196,47,149,6,247,194,63,125,168,143,150,204,186,139,133,239,81,138,115,130,118,66,92,237,226,238,213,116,116,49,234,27,86,171,130,179,148,43,86,139,164,53,236,215,27,49,219,239,132,229,40,9,250,228,147,214,151,71,36,251,101,253,152,193,253,165,56,43,37,163,197,208,96,30,226,10,78,111,14,192,114,27,150,20,160,150,4,104,128,159,224,55,133,127,199,169,238,195,74,29,102,180,214,174,244,35,79,61,132,215,221,146,9,160,35,70,226,214,106,140,239,134,68,211,140,113,194,84,45,89,28,106,243,243,167,80,56,54,62,8,233,192,154,72,70,173,78,78,73,107,14,80,18,109,59,204,182,76,153,155,36,184,153,66,191,57,50,81,39,129,131,69,185,71,63,72,250,241,142,85,108,66,238,4,176,215,229,115,41,179,37,5,126,242,5,172,34,108,35,33,56,226,8,225,38,73,37,112,17,253,189,122,47,198,155,22,88,76,239,186,28,184,0,116,245,191,142,91,197,197,237,178,25,177,102,231,179,19,7,91,254,140,50,158,23,55,35,242,131,143,93,215,18,177,156,218,138,230,150,102,138,203,186,190,212,60,50,247,132,118,166,178,82,194,41,73,191,206,239,195,17,195,178,31,174,197,44,223,20,222,42,50,172,50,74,96,83,211,50,205,172,184,240,36,128,83,52,224,141,158,226,223,82,232,37,136,156,66,76,95,145,37,228,121,172,142,250,217,237,183,22,158,123,180,19,174,138,18,250,145,132,24,1,150,146,213,121,4,219,77,27,177,173,145,161,40,87,41,166,230,87,48,45,36,165,89,112,136,51,169,55,75,113,74,199,231,177,3,5,73,197,231,242,61,174,244,202,249,10,228,247,84,164,70,117,27,165,5,54,75,164,45,233,236,110,119,39,72,150,164,153,245,119,93,160,55,51,136,43,3,78,176,171,62,217,12,64,52,185,12,37,196,206,32,29,84,146,162,155,203,8,177,83,90,49,171,140,207,187,135,149,209,173,15,160,213,54,172,53,84,60,163,170,222,49,189,80,89,91,31,64,196,43,241,191,143,119,126,92,2,147,160,212,10,228,86,2,0,112,149,227,14,111,156,223,83,23,208,203,252,40,217,246,117,27,48,160,1,52,35,93,27,150,207,153,210,175,250,85,67,140,65,211,75,168,66,10,144,223,209,43,86,13,129,202,138,202,242,52,125,160,72,162,138,161,6,180,220,87,210,187,200,156,137,185,17,151,228,246,234,88,136,48,240,179,134,245,157,142,8,124,209,98,147,163,139,234,178,230,233,255,187,116,140,49,191,246,239,115,114,73,153,145,237,197,59,97,150,162,232,208,231,57,196,235,68,158,168,79,162,245,202,105,244,13,207,24,50,17,24,105,113,214,91,12,54,19,47,10,160,48,94,203,229,151,225,163,182,184,119,253,48,81,251,31,238,186,185,207,105,229,176,139,188,218,224,203,121,240,221,214,75,3,199,159,229,60,113,40,56,118,40,217,233,239,157,145,134,157,144,194,228,236,92,52,3,16,177,251,202,221,88,197,81,90,61,248,254,133,80,200,84,37,132,236,251,100,98,110,60,192,19,97,50,145,23,97,190,49,228,107,174,202,197,85,22,14,236,163,131,5,25,17,142,172,13,182,165,66,204,251,134,214,33,8,185,173,162,35,100,198,46,77,98,200,167,199,10,87,242,155,200,131,141,225,151,232,239,196,130,102,43,207,244,211,139,195,189,221,16,212,1,236,152,134,187,221,12,226,175,74,18,17,137,113,62,120,189,208,48,88,228,38,19,16,25,252,74,208,160,76,200,159,209,208,0,206,12,247,229,193,16,134,214,189,64,81,100,130,118,14,43,139,64,92,197,90,18,2,63,150,75,65,90,217,176,64,253,249,74,9,27,205,142,16,32,242,215,235,239,7,116,111,209,240,247,91,228,130,80,57,234,159,48,35,5,131,204,98,162,98,82,122,29,32,55,183,149,138,130,181,132,94,19,169,170,63,149,121,239,42,20,237,7,59,50,177,65,5,229,55,49,129,233,185,71,246,113,37,18,178,2,196,172,169,105,177,158,200,1,252,229,102,105,142,29,157,93,33,228,181,240,159,48,93,89,99,51,126,157,121,166,160,1,30,122,143,62,107,2,207,153,120,36,194,103,239,168,203,189,161,40,198,216,59,150,35,40,121,195,154,255,135,140,155,169,68,14,214,41,229,138,42,233,25,247,29,203,74,196,23,22,217,115,198,191,176,83,83,173,45,197,54,47,222,9,153,213,181,6,47,26,33,41,155,242,119,10,181,241,130,76,196,61,97,12,146,47,203,196,113,162,97,135,134,60,111,253,123,19,70,128,176,189,136,29,184,205,74,117,122,80,66,22,172,139,89,214,182,250,169,73,100,53,127,57,248,122,19,246,148,119,16,69,45,1,41,92,218,63,5,157,224,148,255,91,221,165,123,250,251,102,43,228,220,236,162,12,81,157,70,110,229,184,142,192,73,160,102,45,237,211,89,17,189,183,126,161,231,205,6,91,26,146,107,165,47,18,29,26,3,112,85,174,225,150,40,134,240,12,109,178,54,41,19,123,233,37,174,68,8,91,24,138,244,193,43,144,95,38,53,13,73,251,62,154,16,122,254,114,96,172,6,68,20,174,244,127,3,113,176,125,239,247,178,151,149,16,43,26,56,233,161,43,136,58,18,68,182,244,166,30,147,254,23,116,114,227,112,238,18,40,128,188,22,237,99,211,145,169,72,100,75,75,18,63,158,212,221,1,244,196,232,75,155,85,163,127,128,50,157,92,164,35,150,172,255,170,120,63,213,33,82,111,194,220,78,81,181,58,98,174,152,132,93,95,30,166,205,169,144,131,76,134,102,54,47,61,151,234,204,120,26,24,174,187,176,44,35,93,53,96,38,198,19,249,3,119,129,12,233,97,85,251,58,117,152,249,2,84,16,234,205,51,94,98,25,209,136,94,92,121,128,59,5,216,130,32,48,33,206,185,216,62,132,7,92,150,21,59,148,21,62,42,74,155,148,222,41,167,67,207,166,102,23,163,13,136,182,247,170,114,105,67,102,151,129,10,179,38,144,211,130,234,243,61,52,90,113,119,222,130,161,4,132,164,121,248,251,43,180,241,13,185,203,133,68,74,129,9,197,233,193,142,251,247,166,170,226,241,212,91,173,58,244,84,193,111,112,83,84,231,175,75,197,241,116,249,5,211,48,169,177,66,73,200,58,109,206,2,47,196,167,193,61,204,150,201,42,229,226,184,103,205,30,115,99,65,166,145,115,200,157,138,113,186,60,252,160,165,218,115,202,231,234,30,228,8,216,81,192,42,50,226,197,101,152,114,191,171,127,233,144,87,64,25,178,50,235,219,14,241,192,98,103,214,99,222,230,244,93,19,126,14,27,9,95,232,209,73,64,15,161,186,206,21,145,228,110,145,174,8,130,67,133,255,170,203,168,136,86,42,187,216,74,136,182,107,73,154,190,245,223,6,189,152,101,191,200,214,37,165,83,168,209,204,218,113,219,22,197,156,248,16,156,11,209,30,180,33,253,144,139,253,40,230,71,213,13,138,51,148,161,40,95,7,83,150,37,182,241,142,101,63,182,114,23,252,142,227,191,14,128,141,200,166,139,204,53,123,97,2,173,182,69,184,18,175,1,218,212,107,205,200,144,252,125,90,182,19,206,237,20,150,32,15,177,201,70,254,144,171,37,31,252,106,207,254,226,84,162,19,47,21,38,167,19,167,185,215,238,107,103,98,149,144,9,242,104,205,128,180,188,79,10,223,160,196,165,101,117,254,209,176,9,134,218,73,159,39,169,163,252,210,156,95,212,136,214,222,194,64,116,58,52,70,194,218,197,248,171,189,110,187,83,69,247,69,139,67,85,208,219,63,2,191,146,116,68,218,128,210,15,161,192,85,175,170,37,4,149,65,179,159,251,224,179,227,133,64,172,184,47,10,74,16,20,30,172,149,145,106,229,42,66,154,236,95,74,123,72,43,19,130,160,140,1,149,190,45,154,190,215,31,255,110,216,150,156,146,255,13,31,148,80,45,33,233,27,12,240,101,35,185,138,55,115,209,222,65,119,11,54,253,186,229,209,11,74,205,151,115,93,107,151,88,223,20,199,3,81,163,130,153,0,103,140,82,87,212,128,215,151,53,150,23,196,189,72,12,124,11,229,69,157,159,101,140,122,209,21,151,211,204,189,75,180,99,250,98,74,225,177,48,188,127,148,35,68,238,4,41,125,170,116,248,76,242,52,45,110,174,167,37,27,63,78,229,165,214,53,35,47,35,246,207,144,104,138,236,4,26,163,254,145,127,134,31,6,219,25,198,94,232,140,246,61,234,91,106,230,252,23,112,97,250,90,206,228,178,57,81,76,50,241,88,97,246,77,92,53,200,24,159,143,51,194,222,254,238,215,152,149,214,204,205,221,71,159,201,108,162,202,131,42,8,1,102,46,109,8,45,44,42,145,142,236,155,144,167,229,126,219,121,15,178,155,186,228,206,219,89,60,241,92,177,45,244,141,116,234,199,46,148,46,55,249,215,75,64,141,211,221,73,224,25,175,93,204,173,70,22,229,39,189,88,61,161,74,230,183,132,164,85,186,25,150,147,175,138,35,78,233,190,149,180,114,52,56,67,187,85,107,25,130,252,81,182,178,70,82,33,119,35,73,229,131,205,69,101,63,44,72,197,104,10,67,119,245,118,26,250,211,252,167,166,227,183,108,230,48,234,103,150,74,145,39,108,192,214,137,167,216,54,36,188,102,168,187,160,197,11,250,23,124,100,232,88,28,10,245,9,110,98,80,118,87,199,158,77,174,13,88,253,64,236,222,94,47,162,44,68,93,52,114,151,83,169,104,67,179,2,162,90,88,0,221,214,106,195,63,236,52,164,204,119,20,179,53,150,211,235,236,118,243,175,225,5,107,186,64,82,168,89,15,4,163,239,190,133,6,221,146,96,65,241,179,241,120,103,16,120,17,16,121,252,109,70,168,155,178,226,162,244,41,201,42,184,63,206,76,213,18,90,31,98,44,1,58,193,16,253,29,75,72,22,221,233,190,232,211,121,156,48,179,93,236,246,227,185,29,138,74,227,255,22,18,127,123,206,95,186,187,119,73,189,178,128,93,19,4,133,43,169,130,230,108,6,113,32,237,85,151,4,91,29,53,215,102,212,140,3,50,127,223,24,100,23,64,177,39,112,23,93,92,221,100,44,160,206,175,151,179,15,27,86,200,251,174,237,6,247,224,251,199,60,67,101,132,204,7,167,16,127,88,133,36,235,23,44,234,107,250,1,168,89,56,91,15,94,199,228,167,69,140,226,81,65,208,45,107,93,60,173,160,138,115,125,98,137,140,31,147,95,147,135,110,155,145,146,157,163,55,223,29,93,225,56,70,176,161,7,10,228,166,241,64,212,204,235,205,106,165,222,75,39,27,49,32,77,116,45,199,10,171,116,208,229,187,35,140,252,194,83,202,34,21,66,14,95,215,75,111,252,30,204,162,79,83,10,60,255,206,54,18,134,86,130,24,162,60,232,22,158,250,156,162,183,132,207,122,173,179,152,13,214,15,124,195,236,233,124,250,188,30,125,212,166,6,146,237,25,64,86,185,34,86,161,60,25,144,103,135,120,94,193,144,34,33,119,203,78,87,149,219,132,248,64,168,69,221,226,28,183,251,15,65,102,231,157,148,152,228,1,79,23,107,74,109,20,243,136,116,170,173,175,67,36,141,234,114,191,15,178,114,217,190,233,109,199,29,138,7,8,80,9,83,93,169,73,126,29,239,22,215,12,74,69,128,153,142,96,39,46,218,135,87,154,187,98,40,188,47,88,168,238,152,251,181,43,34,46,220,31,125,249,131,170,186,47,117,77,34,155,40,7,176,94,95,137,227,65,242,73,215,123,179,195,130,88,193,84,238,227,115,233,238,74,152,198,155,173,216,102,25,98,83,100,217,109,23,246,102,12,106,42,9,130,38,53,36,2,77,240,135,182,14,215,255,25,94,246,249,141,172,239,252,64,6,109,152,10,183,203,124,171,159,32,82,219,186,139,80,216,138,126,81,190,229,126,98,218,214,24,77,134,13,155,117,214,248,202,104,236,135,173,230,153,245,221,143,195,87,215,212,163,26,7,145,178,251,208,201,239,255,90,236,232,229,21,14,228,172,146,14,167,40,12,116,82,206,154,255,243,44,26,136,178,201,149,76,138,207,24,19,37,174,145,160,19,160,232,6,25,194,182,152,21,178,78,93,14,179,76,119,18,38,232,219,17,147,108,127,124,173,40,29,115,112,247,166,121,3,188,62,120,61,240,161,10,106,158,123,216,60,142,238,87,196,146,30,149,124,42,38,244,113,54,41,155,47,31,149,156,200,19,105,46,144,53,223,157,196,27,231,124,225,180,230,67,198,83,145,88,117,161,244,94,17,99,178,247,220,179,194,145,239,92,231,227,192,153,103,33,122,47,243,224,77,161,37,199,117,219,150,7,242,225,3,33,190,113,224,213,200,194,196,217,6,106,247,210,127,168,29,17,183,172,172,55,68,40,207,146,24,195,247,225,244,90,196,39,180,131,60,165,31,32,227,216,43,180,183,218,214,25,255,57,155,100,40,110,238,189,140,149,142,66,86,0,185,58,156,148,181,62,248,195,169,7,227,145,34,60,98,68,48,8,183,185,239,38,84,243,42,153,23,23,130,223,94,237,69,214,223,15,130,3,132,173,211,95,24,210,128,41,122,77,200,206,31,153,131,102,20,162,57,4,57,153,183,50,63,228,223,231,197,174,252,28,170,148,180,88,54,199,94,238,138,193,230,189,130,202,111,21,131,55,157,168,83,7,147,250,209,41,199,201,143,6,159,235,204,47,221,17,243,250,180,86,238,251,215,31,78,197,127,251,60,238,151,163,119,158,185,104,225,175,70,32,89,228,186,83,79,9,106,212,157,25,74,192,226,36,84,45,119,74,29,90,217,124,25,255,7,205,249,241,149,96,66,88,163,211,61,153,107,16,166,16,213,137,135,3,107,68,246,51,165,138,124,236,115,12,121,76,123,58,222,0,186,237,135,106,24,179,243,18,97,106,84,83,56,243,127,198,30,168,0,249,246,247,243,35,22,182,67,244,134,238,35,89,21,249,79,145,65,1,73,138,246,183,127,75,166,17,156,124,0,181,123,255,167,51,115,220,244,238,88,154,16,36,219,176,90,123,118,128,172,15,236,191,57,20,104,81,32,91,177,191,138,166,27,79,36,16,5,132,138,43,122,148,131,236,171,200,213,53,123,217,122,92,175,170,42,33,94,9,16,218,30,177,41,156,128,68,54,183,125,186,44,52,56,5,240,59,126,35,67,150,139,91,220,120,216,100,196,51,163,88,97,247,251,53,167,190,84,113,120,32,187,209,116,212,108,188,165,152,155,50,120,208,81,208,191,89,38,190,125,38,112,214,55,135,184,122,12,6,140,90,207,0,222,174,34,34,132,5,16,56,16,57,73,14,17,69,200,129,24,127,92,8,4,75,214,112,186,220,19,74,11,195,72,142,61,223,28,252,28,119,15,106,181,225,39,209,148,101,24,106,203,61,37,46,193,20,226,230,165,80,49,72,191,3,51,211,101,52,128,246,76,63,2,168,99,164,12,203,178,89,209,207,213,133,8,230,212,91,54,233,233,74,20,111,149,66,60,163,175,230,227,2,65,236,115,247,238,161,128,245,65,40,115,68,94,18,254,51,71,229,4,31,58,233,55,8,66,197,123,54,53,253,202,10,175,68,81,235,184,17,12,206,85,144,159,17,57,197,128,53,117,144,148,176,114,17,57,253,150,232,98,159,71,178,7,201,206,173,248,177,8,226,28,238,245,231,95,50,112,160,62,123,208,149,43,54,232,185,46,122,159,163,19,156,223,168,78,239,176,108,189,206,65,249,78,66,138,241,183,76,129,47,210,64,201,95,30,97,143,171,197,115,226,176,204,244,139,166,214,131,29,1,96,216,131,222,250,42,72,164,177,162,6,19,254,8,32,157,76,88,205,29,255,148,249,1,21,121,69,191,165,149,100,7,6,113,201,204,175,140,96,183,129,140,31,186,87,252,110,117,133,51,154,241,150,30,60,41,129,21,201,186,238,96,100,228,152,2,166,227,188,123,189,231,188,77,123,95,11,249,216,21,133,215,117,43,95,186,70,60,242,120,185,204,188,151,71,43,218,52,165,195,169,156,156,226,253,57,70,4,12,239,42,93,181,110,22,115,2,252,203,12,27,50,134,125,156,244,111,59,203,167,99,104,99,193,107,28,8,34,29,181,229,18,25,1,227,174,13,227,213,71,167,125,14,79,182,20,27,36,105,166,79,229,79,225,246,153,185,33,185,55,176,145,230,43,179,60,45,94,132,125,250,131,230,244,242,106,97,172,186,6,91,8,251,196,160,212,28,224,206,129,157,13,144,122,100,157,218,142,58,1,219,212,228,66,170,115,43,32,111,217,103,89,168,157,53,13,102,194,236,37,246,203,187,207,214,214,21,52,230,199,25,195,220,29,18,245,182,104,176,62,119,37,65,10,136,107,249,155,178,3,220,102,98,169,141,240,162,38,130,59,6,188,162,44,50,82,255,139,194,149,174,153,187,172,85,240,32,86,45,132,91,174,237,108,93,3,90,42,212,144,177,23,111,240,147,225,165,163,80,211,100,244,150,148,12,13,225,89,168,182,142,137,7,107,36,86,228,152,214,141,224,241,144,212,233,132,101,133,60,54,178,214,219,157,121,77,245,51,157,22,224,180,121,192,173,41,70,218,123,106,107,204,208,4,144,19,30,234,218,57,213,159,126,78,54,6,249,62,255,2,200,164,77,210,227,25,180,200,69,102,231,84,13,95,73,135,27,152,30,87,22,178,227,192,107,205,242,100,55,241,102,217,113,109,203,69,16,131,249,100,250,148,242,70,80,59,230,174,85,167,233,7,176,253,166,240,106,95,87,12,68,243,151,33,120,89,95,186,237,141,137,16,92,255,133,125,208,190,124,217,194,153,18,102,228,35,137,122,112,240,212,100,7,200,34,194,162,8,154,102,201,223,236,192,200,225,155,4,205,90,254,215,238,240,143,222,129,145,232,209,223,226,174,241,168,148,45,4,216,251,204,146,148,205,44,211,23,221,27,254,199,61,110,252,192,212,20,3,253,77,74,244,215,220,2,15,151,123,40,68,205,21,125,0,139,117,29,141,58,123,71,214,148,91,99,214,227,90,93,211,94,136,125,233,221,12,84,137,41,16,226,205,100,21,59,128,127,93,137,85,170,152,82,181,25,229,143,96,157,121,163,6,215,251,95,242,147,42,25,91,177,157,115,226,226,242,3,135,1,159,221,30,43,173,91,152,101,238,94,31,214,93,186,119,58,121,107,9,222,136,3,22,247,122,200,90,201,68,197,173,148,198,128,255,17,101,246,73,251,157,33,75,247,157,196,58,107,48,67,127,147,36,25,247,98,155,80,125,73,118,121,234,167,145,75,6,118,235,54,104,144,89,108,86,109,4,51,79,147,11,180,170,32,126,43,74,244,7,169,131,143,178,48,69,153,25,3,207,130,170,123,183,116,59,169,142,43,235,66,221,32,65,44,195,111,171,164,123,244,182,101,18,41,37,134,251,127,110,217,181,114,110,85,234,196,92,209,233,165,33,46,176,91,14,242,110,4,48,234,226,93,166,39,131,254,185,229,118,50,95,157,203,117,194,51,56,32,154,18,118,10,34,77,242,21,128,149,105,15,16,132,76,67,208,45,114,91,40,194,221,87,25,148,41,94,59,148,143,73,47,38,54,30,78,183,17,131,11,62,10,87,182,92,141,243,103,194,72,251,177,25,85,74,15,160,224,71,10,168,169,51,143,88,1,50,221,175,64,74,171,171,41,6,182,168,137,224,166,56,90,29,30,247,70,47,235,64,60,85,223,159,244,218,94,217,144,3,19,144,100,49,213,189,85,2,96,229,169,54,174,238,243,35,65,234,94,237,76,198,172,158,77,34,8,52,26,14,33,121,51,79,36,121,94,3,229,34,11,191,76,199,15,200,10,238,208,108,218,200,90,166,142,2,194,27,163,71,13,17,16,2,208,233,158,43,111,25,23,44,244,147,200,118,113,214,189,50,146,207,223,80,70,3,190,122,85,109,51,233,129,185,121,74,79,205,22,56,242,117,147,151,127,171,180,10,131,18,56,159,4,170,131,115,135,230,218,187,46,246,107,206,19,138,52,16,8,42,233,110,122,27,134,158,134,64,210,212,1,82,132,157,149,30,36,202,248,161,63,61,106,77,148,94,113,165,18,127,137,23,212,6,170,110,56,187,123,101,67,7,240,93,124,53,82,135,13,91,188,92,80,121,101,176,13,174,211,156,146,87,16,101,45,167,204,1,113,141,186,45,167,150,30,221,188,108,155,75,102,162,5,225,95,184,66,162,60,128,63,76,86,234,84,238,198,133,98,67,253,176,241,242,22,200,28,227,101,18,145,118,89,182,39,234,117,86,181,79,88,191,112,122,251,98,174,223,10,185,255,105,22,237,252,83,198,6,216,222,115,123,110,99,219,63,232,96,136,252,182,100,104,25,62,7,29,132,187,80,129,205,14,86,96,201,182,160,244,209,44,227,204,240,168,188,47,90,61,227,174,112,185,182,54,153,63,181,139,1,193,183,22,245,193,185,135,165,12,254,196,88,88,204,78,101,210,94,128,247,98,187,225,100,235,147,80,255,48,16,224,184,226,42,240,154,59,147,128,192,19,126,88,105,207,230,248,129,210,111,240,111,142,211,218,252,33,74,245,225,239,223,202,134,231,163,109,228,91,116,242,137,254,88,105,174,215,176,154,86,12,138,79,77,221,7,239,220,36,112,166,147,40,252,197,5,70,167,154,92,231,148,88,5,116,28,85,80,104,221,128,124,244,47,75,163,220,83,184,109,60,47,93,50,141,175,184,168,50,75,106,80,165,237,223,102,59,90,63,214,251,255,212,235,238,80,36,218,254,93,32,224,244,229,136,85,250,30,32,75,194,118,27,243,8,204,141,243,242,124,210,98,55,169,54,155,5,38,216,147,33,239,53,193,1,199,228,142,14,15,32,188,77,33,48,213,77,209,253,122,127,9,55,93,60,213,101,79,184,106,238,76,55,185,146,36,167,18,154,18,154,85,249,25,93,195,175,28,63,86,206,111,104,178,182,63,133,131,221,74,202,39,14,26,208,167,194,117,149,198,87,22,221,214,229,52,201,5,128,94,47,70,34,103,31,95,153,209,42,148,120,101,84,94,10,231,224,109,1,219,146,155,222,218,8,23,113,218,21,144,194,251,41,139,75,24,25,151,116,92,91,11,117,222,2,215,68,28,254,3,106,236,231,201,49,79,181,11,35,217,152,216,185,244,216,1,66,14,8,209,164,197,99,13,91,178,239,82,35,231,195,218,1,216,53,80,0,129,15,34,201,206,15,188,20,134,126,143,78,200,199,48,6,153,12,130,10,225,236,32,217,52,120,34,3,92,73,221,108,41,86,204,217,204,55,199,253,110,191,214,235,97,101,94,154,190,58,208,185,209,147,118,42,116,246,21,110,219,67,71,75,15,220,146,103,189,125,104,250,177,215,141,241,219,42,21,61,210,182,30,92,213,245,9,143,132,72,131,67,176,13,179,120,8,18,91,67,45,92,26,203,108,114,218,95,233,254,16,104,39,176,57,53,22,126,204,186,250,247,147,244,220,75,72,169,254,221,202,127,2,246,69,183,143,59,218,115,144,190,221,61,171,131,214,99,125,187,108,50,88,43,84,67,4,203,51,195,218,117,108,76,7,223,82,189,222,80,154,164,36,83,80,74,221,4,129,143,60,94,52,124,85,28,42,219,155,105,133,141,66,7,33,203,78,122,254,127,74,148,10,19};

// The ranking tile of 128x128 pixels.
// Each pixel contains an optimized 8d key used to scramble the sequence.
// The keys are optimized for all the powers of two spp below 128in 8d.
static const int rankingTile[128*128*8] = {5,5,123,123,78,78,124,124,69,69,68,68,113,113,115,115,17,17,32,32,12,12,107,107,43,43,16,16,56,56,56,56,94,94,22,22,1,1,24,24,27,27,110,110,63,63,59,59,71,71,20,20,93,93,86,86,119,119,51,51,69,69,93,93,46,46,27,27,6,6,27,27,76,76,47,47,115,115,101,101,29,29,19,19,2,2,42,42,106,106,79,79,125,125,20,20,92,92,92,92,67,67,121,121,88,88,120,120,108,108,37,37,91,91,122,122,59,59,72,72,0,0,64,64,85,85,90,90,31,31,126,126,93,93,84,84,33,33,57,57,67,67,28,28,55,55,126,126,42,42,5,5,15,15,71,71,90,90,94,94,107,107,16,16,12,12,95,95,95,95,89,89,32,32,14,14,1,1,83,83,4,4,72,72,63,63,108,108,41,41,79,79,86,86,98,98,31,31,101,101,79,79,8,8,95,95,112,112,15,15,127,127,110,110,2,2,7,7,18,18,39,39,78,78,63,63,28,28,66,66,70,70,117,117,106,106,120,120,126,126,2,2,27,27,69,69,49,49,56,56,97,97,48,48,11,11,71,71,74,74,28,28,119,119,39,39,19,19,113,113,118,118,101,101,52,52,72,72,43,43,63,63,6,6,80,80,108,108,113,113,10,10,99,99,1,1,23,23,58,58,12,12,0,0,113,113,40,40,21,21,92,92,6,6,31,31,100,100,67,67,65,65,36,36,41,41,108,108,19,19,114,114,28,28,100,100,96,96,81,81,19,19,10,10,91,91,98,98,84,84,10,10,106,106,58,58,28,28,55,55,77,77,109,109,58,58,10,10,35,35,85,85,1,1,39,39,28,28,30,30,0,0,35,35,63,63,61,61,71,71,31,31,29,29,78,78,1,1,92,92,4,4,93,93,24,24,89,89,4,4,16,16,27,27,73,73,40,40,92,92,120,120,67,67,120,120,116,116,119,119,68,68,42,42,17,17,63,63,74,74,20,20,120,120,70,70,92,92,45,45,66,66,9,9,123,123,114,114,4,4,14,14,16,16,14,14,51,51,65,65,94,94,61,61,113,113,12,12,8,8,33,33,29,29,50,50,35,35,1,1,20,20,28,28,27,27,113,113,106,106,123,123,113,113,9,9,3,3,81,81,103,103,44,44,77,77,90,90,101,101,96,96,30,30,62,62,93,93,120,120,16,16,105,105,70,70,124,124,55,55,19,19,86,86,55,55,108,108,92,92,116,116,105,105,44,44,34,34,124,124,67,67,125,125,69,69,27,27,48,48,91,91,88,88,71,71,17,17,51,51,24,24,42,42,107,107,0,0,102,102,61,61,11,11,9,9,48,48,43,43,2,2,35,35,36,36,0,0,79,79,74,74,70,70,87,87,65,65,89,89,89,89,92,92,9,9,100,100,78,78,54,54,34,34,0,0,123,123,58,58,1,1,99,99,29,29,101,101,47,47,41,41,3,3,115,115,126,126,54,54,49,49,23,23,74,74,14,14,4,4,2,2,125,125,70,70,117,117,46,46,7,7,92,92,102,102,1,1,94,94,85,85,35,35,127,127,33,33,103,103,71,71,112,112,91,91,36,36,117,117,36,36,110,110,21,21,11,11,94,94,65,65,22,22,18,18,72,72,51,51,25,25,30,30,24,24,69,69,73,73,12,12,112,112,33,33,12,12,77,77,74,74,118,118,82,82,41,41,127,127,127,127,4,4,83,83,2,2,97,97,121,121,21,21,42,42,126,126,6,6,81,81,56,56,33,33,82,82,6,6,29,29,10,10,33,33,67,67,82,82,23,23,51,51,31,31,20,20,64,64,75,75,32,32,34,34,63,63,14,14,50,50,27,27,1,1,126,126,10,10,9,9,71,71,9,9,81,81,19,19,32,32,99,99,54,54,45,45,48,48,26,26,81,81,62,62,94,94,43,43,48,48,34,34,54,54,38,38,19,19,115,115,57,57,20,20,66,66,72,72,110,110,91,91,2,2,113,113,77,77,18,18,126,126,19,19,80,80,7,7,109,109,116,116,5,5,70,70,114,114,90,90,127,127,121,121,89,89,39,39,13,13,99,99,66,66,71,71,6,6,108,108,53,53,109,109,57,57,13,13,16,16,119,119,7,7,40,40,35,35,35,35,82,82,90,90,110,110,69,69,18,18,56,56,34,34,77,77,61,61,109,109,4,4,123,123,79,79,51,51,126,126,114,114,45,45,117,117,96,96,60,60,23,23,84,84,80,80,25,25,107,107,120,120,74,74,7,7,17,17,12,12,84,84,72,72,25,25,79,79,73,73,87,87,44,44,43,43,12,12,89,89,70,70,50,50,34,34,38,38,114,114,82,82,80,80,79,79,65,65,120,120,42,42,70,70,28,28,31,31,48,48,13,13,9,9,38,38,35,35,26,26,74,74,100,100,92,92,9,9,105,105,100,100,28,28,61,61,20,20,53,53,30,30,2,2,48,48,62,62,72,72,122,122,80,80,39,39,40,40,60,60,118,118,45,45,51,51,19,19,10,10,26,26,88,88,80,80,28,28,98,98,35,35,18,18,118,118,45,45,10,10,38,38,24,24,108,108,8,8,114,114,87,87,66,66,14,14,31,31,29,29,85,85,33,33,77,77,124,124,76,76,58,58,56,56,17,17,12,12,115,115,40,40,86,86,4,4,93,93,118,118,42,42,126,126,68,68,118,118,19,19,66,66,7,7,65,65,100,100,94,94,114,114,105,105,67,67,76,76,41,41,44,44,72,72,111,111,23,23,17,17,10,10,108,108,115,115,22,22,51,51,48,48,28,28,98,98,104,104,101,101,40,40,109,109,35,35,87,87,115,115,5,5,92,92,19,19,35,35,61,61,68,68,27,27,48,48,76,76,122,122,72,72,22,22,126,126,60,60,36,36,81,81,88,88,91,91,47,47,93,93,46,46,38,38,4,4,126,126,54,54,125,125,115,115,36,36,81,81,34,34,102,102,82,82,35,35,97,97,86,86,108,108,8,8,94,94,68,68,76,76,13,13,24,24,3,3,19,19,26,26,116,116,49,49,77,77,27,27,85,85,125,125,52,52,104,104,17,17,7,7,56,56,124,124,76,76,17,17,36,36,18,18,120,120,67,67,45,45,3,3,37,37,1,1,4,4,5,5,108,108,111,111,114,114,124,124,117,117,44,44,82,82,60,60,30,30,9,9,56,56,24,24,44,44,109,109,12,12,12,12,0,0,87,87,115,115,2,2,84,84,111,111,12,12,14,14,98,98,123,123,126,126,90,90,23,23,94,94,53,53,58,58,3,3,16,16,120,120,35,35,44,44,106,106,54,54,51,51,37,37,121,121,117,117,103,103,108,108,22,22,11,11,21,21,67,67,77,77,107,107,47,47,81,81,101,101,60,60,95,95,116,116,5,5,85,85,65,65,45,45,65,65,123,123,99,99,123,123,123,123,2,2,98,98,30,30,7,7,70,70,98,98,67,67,90,90,59,59,86,86,97,97,18,18,2,2,4,4,95,95,85,85,16,16,6,6,106,106,11,11,84,84,41,41,12,12,41,41,29,29,66,66,7,7,88,88,50,50,16,16,117,117,113,113,87,87,22,22,99,99,7,7,74,74,7,7,24,24,95,95,8,8,48,48,26,26,84,84,68,68,76,76,10,10,73,73,9,9,117,117,31,31,18,18,17,17,89,89,45,45,83,83,17,17,32,32,32,32,86,86,53,53,50,50,54,54,74,74,58,58,99,99,100,100,16,16,59,59,126,126,40,40,4,4,11,11,70,70,120,120,65,65,1,1,34,34,61,61,87,87,40,40,19,19,76,76,56,56,60,60,102,102,103,103,123,123,41,41,84,84,34,34,90,90,97,97,113,113,13,13,63,63,20,20,96,96,62,62,92,92,6,6,5,5,68,68,43,43,74,74,114,114,47,47,116,116,15,15,42,42,39,39,91,91,107,107,92,92,67,67,68,68,27,27,101,101,104,104,60,60,37,37,92,92,62,62,57,57,101,101,3,3,91,91,123,123,8,8,16,16,61,61,92,92,17,17,98,98,118,118,32,32,33,33,28,28,58,58,21,21,2,2,10,10,18,18,123,123,119,119,64,64,61,61,66,66,58,58,41,41,118,118,40,40,69,69,16,16,4,4,97,97,14,14,6,6,117,117,85,85,42,42,70,70,110,110,84,84,87,87,1,1,6,6,44,44,18,18,118,118,81,81,102,102,41,41,47,47,119,119,126,126,25,25,125,125,5,5,18,18,2,2,105,105,9,9,77,77,57,57,8,8,75,75,85,85,99,99,103,103,105,105,9,9,62,62,16,16,31,31,2,2,122,122,122,122,89,89,30,30,119,119,90,90,94,94,53,53,24,24,106,106,104,104,13,13,89,89,106,106,15,15,82,82,83,83,92,92,121,121,62,62,54,54,42,42,74,74,119,119,43,43,84,84,108,108,31,31,61,61,0,0,43,43,3,3,0,0,20,20,25,25,18,18,86,86,19,19,113,113,70,70,24,24,5,5,43,43,75,75,81,81,111,111,0,0,54,54,105,105,95,95,14,14,4,4,52,52,85,85,10,10,89,89,92,92,22,22,47,47,103,103,32,32,14,14,80,80,18,18,39,39,104,104,66,66,20,20,30,30,40,40,42,42,31,31,29,29,52,52,58,58,103,103,92,92,17,17,4,4,72,72,114,114,124,124,102,102,85,85,15,15,99,99,55,55,67,67,48,48,8,8,85,85,39,39,82,82,87,87,25,25,24,24,10,10,115,115,78,78,21,21,84,84,21,21,87,87,49,49,83,83,92,92,44,44,52,52,112,112,91,91,48,48,116,116,95,95,10,10,8,8,40,40,95,95,100,100,70,70,86,86,112,112,34,34,8,8,28,28,9,9,23,23,118,118,94,94,28,28,2,2,105,105,84,84,125,125,80,80,126,126,76,76,106,106,23,23,81,81,118,118,82,82,33,33,116,116,19,19,116,116,50,50,17,17,71,71,89,89,12,12,106,106,88,88,83,83,43,43,37,37,6,6,24,24,15,15,79,79,18,18,97,97,106,106,33,33,92,92,60,60,112,112,93,93,84,84,41,41,62,62,101,101,87,87,97,97,37,37,124,124,42,42,101,101,29,29,98,98,116,116,66,66,23,23,82,82,47,47,79,79,81,81,124,124,58,58,105,105,22,22,82,82,52,52,96,96,67,67,4,4,98,98,98,98,86,86,110,110,21,21,37,37,106,106,74,74,105,105,67,67,99,99,47,47,44,44,121,121,122,122,38,38,9,9,60,60,72,72,18,18,36,36,9,9,35,35,100,100,69,69,90,90,78,78,17,17,16,16,65,65,5,5,92,92,68,68,17,17,22,22,57,57,58,58,25,25,108,108,119,119,80,80,18,18,14,14,47,47,59,59,80,80,65,65,120,120,34,34,20,20,12,12,116,116,81,81,54,54,106,106,107,107,11,11,62,62,12,12,37,37,49,49,7,7,17,17,2,2,22,22,72,72,32,32,122,122,72,72,85,85,39,39,6,6,34,34,69,69,93,93,112,112,46,46,31,31,9,9,78,78,17,17,88,88,58,58,22,22,115,115,5,5,51,51,107,107,33,33,82,82,20,20,65,65,45,45,11,11,100,100,33,33,111,111,93,93,105,105,28,28,48,48,18,18,9,9,7,7,116,116,98,98,84,84,106,106,77,77,38,38,111,111,42,42,125,125,54,54,68,68,63,63,118,118,77,77,111,111,88,88,126,126,75,75,80,80,17,17,92,92,36,36,14,14,50,50,8,8,62,62,75,75,34,34,32,32,86,86,20,20,90,90,4,4,69,69,81,81,37,37,107,107,51,51,80,80,42,42,110,110,92,92,121,121,74,74,89,89,22,22,64,64,106,106,87,87,117,117,120,120,108,108,4,4,77,77,0,0,108,108,45,45,13,13,45,45,32,32,1,1,77,77,59,59,31,31,9,9,97,97,7,7,69,69,126,126,74,74,85,85,103,103,28,28,8,8,19,19,109,109,30,30,71,71,47,47,118,118,13,13,2,2,59,59,36,36,92,92,78,78,121,121,52,52,46,46,4,4,1,1,57,57,31,31,53,53,112,112,121,121,74,74,127,127,118,118,20,20,82,82,108,108,19,19,113,113,7,7,22,22,48,48,3,3,2,2,45,45,62,62,52,52,88,88,33,33,73,73,1,1,121,121,18,18,29,29,61,61,59,59,115,115,62,62,55,55,89,89,72,72,82,82,78,78,42,42,103,103,76,76,19,19,109,109,78,78,94,94,21,21,70,70,47,47,2,2,10,10,44,44,81,81,71,71,100,100,65,65,73,73,0,0,1,1,49,49,107,107,106,106,77,77,67,67,81,81,19,19,42,42,2,2,127,127,35,35,31,31,73,73,29,29,16,16,119,119,92,92,83,83,109,109,42,42,46,46,28,28,35,35,75,75,51,51,29,29,75,75,92,92,13,13,53,53,58,58,13,13,95,95,46,46,100,100,41,41,20,20,61,61,110,110,115,115,29,29,98,98,36,36,3,3,56,56,79,79,122,122,48,48,124,124,54,54,19,19,69,69,38,38,7,7,0,0,64,64,126,126,54,54,84,84,62,62,108,108,54,54,110,110,31,31,125,125,54,54,0,0,34,34,23,23,65,65,1,1,29,29,117,117,37,37,91,91,110,110,45,45,98,98,18,18,127,127,27,27,99,99,60,60,89,89,70,70,70,70,89,89,50,50,5,5,10,10,90,90,111,111,26,26,38,38,12,12,52,52,124,124,20,20,81,81,1,1,55,55,56,56,64,64,39,39,13,13,102,102,42,42,125,125,39,39,107,107,102,102,2,2,41,41,52,52,21,21,29,29,78,78,52,52,51,51,24,24,30,30,82,82,110,110,123,123,101,101,13,13,60,60,54,54,119,119,48,48,67,67,21,21,19,19,100,100,112,112,1,1,56,56,50,50,76,76,100,100,120,120,53,53,124,124,110,110,96,96,52,52,25,25,113,113,104,104,102,102,19,19,11,11,77,77,55,55,84,84,83,83,65,65,11,11,1,1,87,87,32,32,44,44,116,116,87,87,60,60,41,41,35,35,15,15,98,98,2,2,127,127,76,76,11,11,91,91,73,73,46,46,56,56,50,50,127,127,54,54,21,21,122,122,87,87,84,84,23,23,26,26,26,26,24,24,85,85,91,91,103,103,74,74,50,50,98,98,76,76,78,78,58,58,77,77,56,56,125,125,58,58,8,8,21,21,16,16,88,88,97,97,84,84,97,97,4,4,124,124,96,96,40,40,104,104,38,38,112,112,72,72,50,50,42,42,22,22,101,101,75,75,84,84,31,31,72,72,103,103,73,73,111,111,122,122,20,20,45,45,39,39,61,61,55,55,93,93,103,103,65,65,17,17,87,87,96,96,60,60,81,81,126,126,125,125,7,7,62,62,111,111,21,21,102,102,80,80,23,23,103,103,40,40,63,63,113,113,50,50,79,79,3,3,103,103,54,54,94,94,79,79,30,30,28,28,41,41,41,41,29,29,75,75,35,35,113,113,6,6,64,64,111,111,18,18,75,75,104,104,80,80,109,109,27,27,21,21,49,49,97,97,85,85,85,85,30,30,1,1,94,94,0,0,49,49,74,74,122,122,56,56,34,34,124,124,46,46,65,65,81,81,81,81,34,34,18,18,54,54,112,112,73,73,71,71,55,55,36,36,68,68,77,77,44,44,90,90,67,67,19,19,16,16,120,120,95,95,91,91,36,36,78,78,7,7,18,18,64,64,67,67,80,80,95,95,111,111,57,57,44,44,118,118,88,88,59,59,105,105,93,93,125,125,78,78,112,112,59,59,103,103,25,25,44,44,83,83,79,79,110,110,62,62,0,0,72,72,7,7,118,118,40,40,42,42,55,55,64,64,50,50,54,54,21,21,14,14,36,36,97,97,87,87,97,97,127,127,96,96,100,100,70,70,104,104,88,88,35,35,96,96,17,17,50,50,51,51,44,44,8,8,122,122,24,24,1,1,18,18,47,47,110,110,112,112,105,105,7,7,16,16,43,43,20,20,119,119,41,41,84,84,49,49,86,86,72,72,84,84,19,19,14,14,98,98,8,8,29,29,90,90,34,34,8,8,93,93,73,73,5,5,27,27,18,18,5,5,50,50,10,10,21,21,10,10,113,113,23,23,104,104,63,63,108,108,22,22,99,99,102,102,74,74,96,96,52,52,112,112,83,83,29,29,116,116,16,16,53,53,90,90,54,54,21,21,83,83,75,75,37,37,123,123,123,123,124,124,77,77,26,26,76,76,10,10,37,37,86,86,84,84,105,105,63,63,5,5,37,37,33,33,48,48,69,69,118,118,14,14,72,72,83,83,15,15,75,75,12,12,42,42,51,51,32,32,97,97,98,98,81,81,37,37,123,123,19,19,105,105,35,35,79,79,70,70,81,81,40,40,32,32,49,49,71,71,117,117,102,102,81,81,33,33,56,56,102,102,108,108,89,89,0,0,35,35,21,21,58,58,56,56,91,91,29,29,19,19,31,31,97,97,3,3,43,43,99,99,8,8,30,30,26,26,76,76,3,3,81,81,114,114,7,7,115,115,47,47,27,27,113,113,24,24,126,126,5,5,64,64,82,82,67,67,10,10,50,50,7,7,82,82,109,109,38,38,114,114,25,25,103,103,67,67,44,44,57,57,22,22,108,108,21,21,3,3,70,70,74,74,42,42,13,13,49,49,16,16,79,79,127,127,73,73,47,47,21,21,88,88,23,23,68,68,39,39,36,36,65,65,109,109,83,83,21,21,117,117,4,4,0,0,105,105,94,94,3,3,100,100,103,103,6,6,8,8,22,22,12,12,53,53,75,75,57,57,49,49,9,9,65,65,70,70,26,26,62,62,51,51,73,73,21,21,88,88,122,122,65,65,62,62,42,42,78,78,103,103,50,50,112,112,32,32,13,13,100,100,103,103,47,47,121,121,13,13,89,89,55,55,32,32,98,98,43,43,11,11,6,6,98,98,59,59,77,77,117,117,57,57,67,67,21,21,124,124,39,39,67,67,94,94,116,116,66,66,87,87,74,74,8,8,15,15,18,18,89,89,116,116,17,17,26,26,54,54,123,123,9,9,57,57,47,47,66,66,57,57,126,126,25,25,32,32,27,27,65,65,92,92,30,30,45,45,44,44,89,89,72,72,45,45,64,64,20,20,28,28,112,112,25,25,16,16,30,30,52,52,99,99,65,65,103,103,28,28,49,49,16,16,36,36,114,114,114,114,55,55,123,123,55,55,28,28,3,3,91,91,30,30,13,13,3,3,91,91,102,102,47,47,76,76,19,19,95,95,62,62,63,63,67,67,73,73,12,12,44,44,72,72,75,75,13,13,22,22,2,2,70,70,91,91,42,42,126,126,35,35,80,80,101,101,106,106,126,126,90,90,105,105,103,103,90,90,3,3,89,89,99,99,92,92,68,68,24,24,70,70,22,22,108,108,39,39,69,69,33,33,26,26,74,74,93,93,16,16,41,41,46,46,89,89,115,115,111,111,58,58,31,31,80,80,43,43,100,100,36,36,37,37,51,51,93,93,93,93,20,20,120,120,109,109,125,125,1,1,48,48,32,32,65,65,126,126,46,46,30,30,112,112,52,52,25,25,112,112,77,77,124,124,20,20,89,89,43,43,117,117,93,93,76,76,47,47,127,127,58,58,108,108,120,120,47,47,65,65,69,69,121,121,126,126,110,110,75,75,36,36,107,107,88,88,29,29,117,117,39,39,39,39,126,126,18,18,69,69,123,123,125,125,94,94,86,86,5,5,117,117,55,55,74,74,80,80,122,122,65,65,92,92,0,0,100,100,25,25,90,90,34,34,102,102,120,120,6,6,60,60,26,26,19,19,9,9,25,25,127,127,83,83,18,18,49,49,17,17,89,89,24,24,85,85,105,105,29,29,84,84,66,66,46,46,1,1,123,123,55,55,122,122,35,35,38,38,70,70,0,0,88,88,19,19,46,46,73,73,8,8,106,106,9,9,1,1,124,124,60,60,111,111,83,83,48,48,28,28,44,44,43,43,8,8,87,87,57,57,120,120,51,51,29,29,110,110,2,2,34,34,109,109,127,127,0,0,70,70,13,13,109,109,37,37,33,33,125,125,2,2,87,87,127,127,32,32,4,4,2,2,105,105,17,17,19,19,9,9,42,42,23,23,105,105,35,35,87,87,48,48,36,36,41,41,96,96,50,50,113,113,67,67,7,7,4,4,16,16,57,57,31,31,107,107,102,102,115,115,102,102,100,100,70,70,121,121,108,108,21,21,14,14,32,32,41,41,64,64,97,97,34,34,27,27,120,120,4,4,69,69,18,18,58,58,57,57,43,43,5,5,43,43,28,28,71,71,46,46,68,68,46,46,12,12,26,26,17,17,25,25,39,39,114,114,70,70,81,81,7,7,114,114,74,74,94,94,70,70,25,25,56,56,82,82,106,106,91,91,84,84,9,9,80,80,54,54,84,84,68,68,21,21,106,106,47,47,16,16,28,28,38,38,62,62,6,6,16,16,87,87,67,67,28,28,56,56,83,83,110,110,23,23,90,90,118,118,104,104,37,37,76,76,104,104,100,100,22,22,43,43,78,78,23,23,98,98,22,22,121,121,120,120,40,40,114,114,25,25,48,48,76,76,80,80,45,45,63,63,61,61,56,56,40,40,125,125,98,98,17,17,52,52,13,13,126,126,10,10,67,67,80,80,18,18,35,35,72,72,37,37,84,84,78,78,71,71,0,0,96,96,21,21,5,5,127,127,92,92,51,51,41,41,120,120,2,2,107,107,8,8,99,99,91,91,42,42,68,68,67,67,56,56,82,82,14,14,16,16,104,104,13,13,84,84,8,8,116,116,49,49,116,116,125,125,21,21,113,113,12,12,76,76,20,20,37,37,6,6,32,32,16,16,82,82,64,64,50,50,34,34,48,48,0,0,113,113,61,61,126,126,76,76,60,60,94,94,96,96,35,35,14,14,46,46,50,50,66,66,11,11,120,120,120,120,95,95,83,83,90,90,18,18,25,25,26,26,77,77,39,39,92,92,10,10,66,66,33,33,29,29,39,39,49,49,19,19,94,94,7,7,41,41,66,66,90,90,107,107,66,66,101,101,70,70,59,59,15,15,42,42,80,80,75,75,84,84,72,72,23,23,21,21,82,82,100,100,62,62,78,78,41,41,58,58,106,106,62,62,51,51,18,18,68,68,10,10,22,22,44,44,24,24,4,4,54,54,23,23,18,18,42,42,15,15,81,81,110,110,125,125,118,118,113,113,34,34,123,123,24,24,81,81,96,96,112,112,101,101,66,66,92,92,8,8,20,20,49,49,56,56,98,98,102,102,121,121,2,2,49,49,60,60,42,42,91,91,69,69,95,95,4,4,52,52,103,103,10,10,32,32,102,102,22,22,65,65,7,7,83,83,12,12,39,39,36,36,126,126,82,82,43,43,81,81,102,102,22,22,56,56,92,92,32,32,26,26,74,74,93,93,4,4,52,52,80,80,127,127,35,35,84,84,28,28,127,127,79,79,76,76,14,14,121,121,7,7,8,8,9,9,6,6,98,98,35,35,16,16,81,81,28,28,33,33,79,79,124,124,0,0,22,22,101,101,33,33,21,21,109,109,43,43,121,121,88,88,72,72,117,117,38,38,7,7,84,84,68,68,35,35,119,119,30,30,31,31,83,83,40,40,117,117,83,83,82,82,51,51,20,20,109,109,53,53,45,45,47,47,96,96,97,97,83,83,41,41,59,59,78,78,27,27,120,120,46,46,32,32,55,55,13,13,112,112,22,22,39,39,42,42,12,12,11,11,31,31,25,25,96,96,11,11,61,61,33,33,32,32,106,106,61,61,28,28,11,11,18,18,119,119,50,50,125,125,4,4,34,34,83,83,70,70,3,3,98,98,12,12,103,103,66,66,10,10,89,89,114,114,59,59,106,106,32,32,5,5,49,49,63,63,25,25,116,116,73,73,110,110,9,9,110,110,112,112,2,2,114,114,124,124,91,91,127,127,83,83,126,126,104,104,72,72,105,105,85,85,4,4,65,65,86,86,54,54,59,59,41,41,105,105,116,116,122,122,100,100,38,38,28,28,121,121,30,30,77,77,98,98,66,66,4,4,42,42,3,3,11,11,22,22,70,70,58,58,91,91,102,102,41,41,10,10,0,0,94,94,111,111,100,100,5,5,59,59,1,1,3,3,31,31,26,26,27,27,43,43,58,58,84,84,52,52,120,120,81,81,43,43,59,59,3,3,7,7,108,108,6,6,57,57,19,19,83,83,88,88,97,97,51,51,64,64,126,126,11,11,123,123,38,38,65,65,125,125,41,41,71,71,9,9,35,35,41,41,74,74,97,97,53,53,79,79,3,3,74,74,21,21,60,60,43,43,76,76,37,37,15,15,114,114,6,6,5,5,92,92,11,11,63,63,31,31,119,119,47,47,108,108,70,70,66,66,123,123,44,44,124,124,117,117,58,58,44,44,51,51,96,96,116,116,51,51,16,16,98,98,65,65,36,36,75,75,10,10,68,68,91,91,34,34,84,84,74,74,15,15,17,17,58,58,105,105,72,72,18,18,51,51,122,122,94,94,11,11,108,108,14,14,6,6,65,65,103,103,20,20,56,56,70,70,124,124,43,43,37,37,65,65,31,31,82,82,59,59,52,52,4,4,106,106,50,50,36,36,10,10,73,73,39,39,71,71,10,10,102,102,114,114,70,70,46,46,17,17,5,5,72,72,80,80,31,31,27,27,10,10,102,102,86,86,50,50,33,33,101,101,16,16,100,100,30,30,9,9,41,41,25,25,85,85,16,16,59,59,53,53,104,104,117,117,0,0,114,114,119,119,124,124,97,97,127,127,65,65,59,59,107,107,16,16,55,55,54,54,71,71,65,65,71,71,93,93,54,54,26,26,60,60,38,38,16,16,94,94,16,16,118,118,50,50,9,9,53,53,20,20,39,39,40,40,16,16,77,77,114,114,28,28,81,81,57,57,63,63,88,88,112,112,120,120,99,99,80,80,44,44,91,91,22,22,108,108,4,4,14,14,108,108,5,5,48,48,42,42,116,116,87,87,45,45,82,82,56,56,15,15,65,65,19,19,101,101,32,32,14,14,20,20,8,8,83,83,122,122,36,36,38,38,114,114,86,86,75,75,73,73,89,89,121,121,67,67,120,120,87,87,118,118,44,44,67,67,55,55,6,6,117,117,52,52,8,8,4,4,33,33,6,6,13,13,4,4,20,20,124,124,93,93,44,44,59,59,41,41,43,43,81,81,92,92,46,46,17,17,76,76,115,115,102,102,56,56,67,67,45,45,96,96,27,27,35,35,74,74,37,37,85,85,32,32,16,16,16,16,58,58,57,57,78,78,71,71,72,72,125,125,30,30,25,25,110,110,22,22,59,59,66,66,7,7,70,70,95,95,87,87,83,83,58,58,116,116,64,64,97,97,69,69,113,113,119,119,6,6,66,66,68,68,46,46,17,17,56,56,114,114,64,64,18,18,19,19,115,115,26,26,8,8,111,111,54,54,12,12,116,116,106,106,6,6,33,33,108,108,80,80,124,124,81,81,126,126,56,56,52,52,3,3,39,39,24,24,40,40,76,76,42,42,112,112,81,81,8,8,43,43,0,0,30,30,56,56,6,6,67,67,96,96,64,64,82,82,106,106,105,105,78,78,55,55,53,53,93,93,103,103,66,66,8,8,106,106,8,8,0,0,26,26,117,117,4,4,98,98,80,80,92,92,48,48,2,2,118,118,84,84,118,118,34,34,88,88,108,108,1,1,54,54,45,45,101,101,21,21,22,22,81,81,99,99,82,82,99,99,127,127,118,118,90,90,3,3,77,77,92,92,99,99,68,68,62,62,104,104,111,111,80,80,21,21,24,24,15,15,65,65,116,116,92,92,76,76,80,80,22,22,41,41,12,12,8,8,37,37,12,12,0,0,50,50,114,114,110,110,50,50,65,65,23,23,76,76,125,125,119,119,43,43,6,6,61,61,108,108,72,72,89,89,31,31,94,94,94,94,49,49,71,71,70,70,1,1,17,17,24,24,3,3,20,20,76,76,70,70,99,99,103,103,85,85,126,126,18,18,122,122,31,31,14,14,42,42,109,109,92,92,70,70,21,21,90,90,127,127,44,44,101,101,12,12,42,42,50,50,57,57,11,11,4,4,114,114,73,73,114,114,64,64,49,49,22,22,49,49,121,121,23,23,53,53,118,118,19,19,58,58,53,53,63,63,103,103,69,69,0,0,13,13,18,18,46,46,10,10,55,55,63,63,92,92,97,97,36,36,52,52,121,121,113,113,111,111,106,106,118,118,107,107,9,9,78,78,49,49,20,20,84,84,98,98,95,95,53,53,42,42,43,43,41,41,55,55,43,43,65,65,94,94,107,107,78,78,59,59,69,69,39,39,32,32,106,106,67,67,33,33,18,18,62,62,80,80,41,41,63,63,41,41,40,40,80,80,75,75,69,69,47,47,68,68,79,79,3,3,25,25,84,84,38,38,31,31,33,33,107,107,62,62,117,117,114,114,5,5,76,76,124,124,44,44,37,37,71,71,81,81,83,83,16,16,106,106,57,57,26,26,62,62,15,15,93,93,9,9,78,78,71,71,67,67,101,101,121,121,124,124,9,9,75,75,85,85,81,81,21,21,51,51,108,108,64,64,74,74,66,66,93,93,76,76,78,78,14,14,70,70,73,73,40,40,72,72,0,0,22,22,73,73,64,64,82,82,107,107,9,9,35,35,105,105,2,2,101,101,54,54,83,83,93,93,103,103,44,44,44,44,56,56,11,11,15,15,11,11,79,79,78,78,4,4,42,42,109,109,27,27,38,38,113,113,117,117,31,31,56,56,6,6,97,97,49,49,72,72,68,68,83,83,73,73,25,25,29,29,26,26,111,111,85,85,32,32,9,9,101,101,12,12,112,112,118,118,76,76,40,40,48,48,40,40,48,48,36,36,116,116,112,112,31,31,47,47,120,120,98,98,8,8,78,78,25,25,58,58,115,115,31,31,24,24,21,21,85,85,42,42,45,45,38,38,21,21,2,2,119,119,12,12,27,27,43,43,116,116,70,70,43,43,25,25,30,30,119,119,69,69,57,57,64,64,75,75,37,37,12,12,74,74,124,124,81,81,123,123,41,41,16,16,49,49,77,77,9,9,60,60,109,109,60,60,35,35,39,39,72,72,105,105,82,82,17,17,10,10,98,98,113,113,74,74,26,26,43,43,68,68,68,68,55,55,117,117,75,75,84,84,1,1,102,102,83,83,114,114,86,86,88,88,7,7,64,64,45,45,6,6,101,101,122,122,60,60,122,122,86,86,34,34,29,29,93,93,77,77,47,47,29,29,50,50,107,107,121,121,116,116,88,88,55,55,101,101,75,75,87,87,1,1,47,47,90,90,68,68,77,77,42,42,48,48,103,103,72,72,104,104,69,69,100,100,5,5,53,53,116,116,52,52,50,50,97,97,66,66,36,36,76,76,45,45,62,62,94,94,46,46,74,74,75,75,82,82,75,75,93,93,34,34,22,22,103,103,2,2,42,42,98,98,120,120,45,45,126,126,64,64,41,41,8,8,92,92,84,84,109,109,118,118,98,98,84,84,3,3,41,41,32,32,12,12,120,120,35,35,35,35,9,9,102,102,82,82,74,74,5,5,120,120,79,79,73,73,5,5,83,83,20,20,113,113,16,16,112,112,126,126,117,117,80,80,122,122,16,16,102,102,51,51,79,79,33,33,47,47,15,15,39,39,22,22,3,3,82,82,78,78,66,66,119,119,73,73,113,113,71,71,29,29,10,10,27,27,47,47,116,116,104,104,114,114,71,71,18,18,103,103,96,96,24,24,30,30,11,11,98,98,117,117,99,99,1,1,57,57,68,68,38,38,42,42,76,76,85,85,124,124,43,43,15,15,120,120,68,68,126,126,49,49,12,12,92,92,14,14,49,49,18,18,50,50,64,64,81,81,88,88,98,98,17,17,13,13,111,111,54,54,19,19,81,81,62,62,99,99,17,17,108,108,96,96,40,40,17,17,100,100,88,88,19,19,97,97,9,9,19,19,85,85,89,89,53,53,122,122,73,73,17,17,70,70,50,50,12,12,64,64,119,119,7,7,6,6,64,64,99,99,106,106,70,70,85,85,75,75,44,44,70,70,114,114,12,12,93,93,86,86,39,39,74,74,125,125,87,87,74,74,69,69,25,25,125,125,79,79,0,0,54,54,114,114,69,69,17,17,78,78,18,18,119,119,30,30,75,75,72,72,66,66,79,79,60,60,75,75,104,104,8,8,106,106,20,20,72,72,25,25,72,72,112,112,12,12,88,88,106,106,8,8,86,86,21,21,36,36,113,113,35,35,91,91,22,22,73,73,108,108,22,22,70,70,36,36,74,74,32,32,63,63,82,82,114,114,51,51,46,46,66,66,24,24,37,37,40,40,4,4,47,47,126,126,86,86,124,124,72,72,7,7,36,36,14,14,41,41,69,69,66,66,72,72,81,81,93,93,80,80,8,8,54,54,121,121,66,66,10,10,93,93,64,64,77,77,82,82,10,10,53,53,124,124,6,6,80,80,68,68,33,33,40,40,56,56,92,92,48,48,67,67,14,14,109,109,114,114,91,91,4,4,81,81,93,93,90,90,102,102,88,88,66,66,96,96,119,119,43,43,42,42,22,22,102,102,63,63,82,82,17,17,44,44,127,127,18,18,32,32,92,92,123,123,64,64,55,55,15,15,122,122,120,120,52,52,10,10,32,32,10,10,72,72,85,85,125,125,26,26,67,67,86,86,28,28,10,10,90,90,106,106,3,3,125,125,29,29,126,126,111,111,38,38,64,64,2,2,61,61,47,47,39,39,110,110,60,60,121,121,47,47,69,69,4,4,9,9,58,58,3,3,49,49,115,115,81,81,98,98,58,58,83,83,86,86,90,90,117,117,92,92,37,37,84,84,37,37,46,46,73,73,49,49,115,115,85,85,21,21,113,113,17,17,20,20,95,95,101,101,78,78,40,40,73,73,8,8,111,111,105,105,73,73,37,37,45,45,103,103,59,59,23,23,94,94,30,30,66,66,115,115,17,17,27,27,84,84,123,123,54,54,42,42,56,56,14,14,66,66,120,120,34,34,6,6,81,81,62,62,73,73,72,72,113,113,64,64,32,32,87,87,41,41,43,43,53,53,74,74,90,90,76,76,120,120,8,8,31,31,69,69,32,32,118,118,49,49,87,87,85,85,13,13,85,85,61,61,114,114,38,38,39,39,86,86,35,35,39,39,50,50,33,33,79,79,23,23,112,112,94,94,10,10,61,61,91,91,8,8,37,37,116,116,22,22,112,112,50,50,18,18,72,72,122,122,6,6,9,9,93,93,86,86,104,104,68,68,28,28,22,22,20,20,100,100,40,40,46,46,29,29,45,45,98,98,71,71,77,77,76,76,48,48,31,31,84,84,89,89,118,118,112,112,64,64,83,83,43,43,8,8,99,99,50,50,48,48,3,3,95,95,52,52,22,22,61,61,33,33,99,99,107,107,37,37,124,124,16,16,127,127,3,3,83,83,91,91,63,63,40,40,61,61,123,123,21,21,57,57,76,76,120,120,122,122,105,105,92,92,112,112,30,30,98,98,12,12,8,8,20,20,73,73,114,114,62,62,71,71,0,0,125,125,38,38,36,36,88,88,34,34,41,41,73,73,50,50,26,26,13,13,94,94,29,29,89,89,60,60,11,11,30,30,67,67,5,5,96,96,99,99,38,38,114,114,77,77,27,27,74,74,119,119,59,59,74,74,2,2,38,38,44,44,47,47,69,69,97,97,35,35,100,100,81,81,90,90,116,116,54,54,59,59,67,67,82,82,74,74,119,119,14,14,70,70,19,19,112,112,63,63,110,110,7,7,7,7,11,11,75,75,65,65,123,123,74,74,64,64,50,50,69,69,87,87,87,87,50,50,99,99,21,21,115,115,56,56,32,32,101,101,21,21,62,62,26,26,32,32,20,20,42,42,30,30,34,34,71,71,10,10,74,74,105,105,56,56,36,36,86,86,49,49,88,88,32,32,108,108,39,39,69,69,69,69,7,7,22,22,12,12,120,120,19,19,87,87,57,57,37,37,100,100,67,67,111,111,20,20,33,33,3,3,27,27,60,60,102,102,5,5,116,116,57,57,99,99,45,45,47,47,127,127,100,100,65,65,96,96,6,6,95,95,93,93,83,83,71,71,61,61,8,8,30,30,42,42,73,73,13,13,99,99,74,74,104,104,13,13,14,14,0,0,50,50,15,15,20,20,77,77,33,33,72,72,3,3,74,74,84,84,23,23,10,10,98,98,55,55,82,82,23,23,46,46,11,11,99,99,13,13,79,79,7,7,21,21,124,124,119,119,79,79,76,76,60,60,6,6,25,25,63,63,45,45,74,74,61,61,118,118,97,97,75,75,127,127,110,110,57,57,40,40,114,114,89,89,61,61,31,31,95,95,127,127,62,62,52,52,75,75,107,107,31,31,45,45,5,5,70,70,68,68,52,52,21,21,124,124,24,24,4,4,80,80,30,30,66,66,1,1,34,34,26,26,115,115,80,80,76,76,87,87,118,118,21,21,76,76,86,86,45,45,2,2,8,8,89,89,45,45,95,95,46,46,31,31,85,85,10,10,116,116,79,79,126,126,71,71,62,62,34,34,51,51,80,80,96,96,105,105,51,51,71,71,60,60,84,84,108,108,43,43,109,109,20,20,73,73,15,15,17,17,70,70,122,122,53,53,96,96,6,6,107,107,6,6,78,78,28,28,62,62,18,18,122,122,70,70,33,33,71,71,57,57,105,105,58,58,98,98,23,23,116,116,69,69,55,55,82,82,36,36,15,15,5,5,85,85,22,22,36,36,13,13,78,78,79,79,75,75,100,100,82,82,26,26,19,19,24,24,39,39,21,21,79,79,91,91,64,64,13,13,63,63,46,46,64,64,102,102,28,28,20,20,2,2,57,57,34,34,63,63,93,93,47,47,119,119,11,11,48,48,24,24,74,74,55,55,112,112,25,25,50,50,3,3,126,126,89,89,71,71,23,23,70,70,107,107,89,89,101,101,105,105,53,53,7,7,105,105,54,54,98,98,96,96,64,64,103,103,52,52,77,77,47,47,48,48,58,58,94,94,125,125,23,23,111,111,37,37,29,29,80,80,124,124,68,68,22,22,126,126,12,12,45,45,65,65,54,54,69,69,17,17,94,94,85,85,108,108,39,39,38,38,30,30,84,84,28,28,17,17,40,40,28,28,74,74,80,80,78,78,81,81,71,71,44,44,36,36,42,42,17,17,36,36,10,10,84,84,3,3,107,107,73,73,74,74,44,44,72,72,95,95,113,113,35,35,116,116,2,2,104,104,77,77,70,70,125,125,80,80,11,11,123,123,0,0,81,81,27,27,7,7,19,19,6,6,57,57,126,126,48,48,54,54,11,11,32,32,64,64,16,16,12,12,80,80,104,104,69,69,65,65,11,11,49,49,43,43,10,10,26,26,109,109,117,117,21,21,13,13,4,4,29,29,2,2,0,0,60,60,81,81,4,4,116,116,87,87,99,99,99,99,97,97,81,81,60,60,2,2,55,55,9,9,62,62,85,85,13,13,38,38,112,112,27,27,93,93,72,72,81,81,25,25,49,49,65,65,119,119,13,13,90,90,29,29,111,111,113,113,44,44,3,3,13,13,67,67,33,33,21,21,119,119,123,123,41,41,58,58,90,90,16,16,15,15,122,122,0,0,72,72,43,43,121,121,125,125,115,115,73,73,62,62,113,113,80,80,24,24,72,72,88,88,107,107,35,35,49,49,115,115,53,53,9,9,20,20,69,69,5,5,45,45,122,122,24,24,13,13,83,83,58,58,48,48,45,45,21,21,70,70,9,9,90,90,62,62,116,116,36,36,82,82,120,120,119,119,8,8,125,125,74,74,42,42,13,13,104,104,80,80,113,113,69,69,102,102,114,114,109,109,106,106,89,89,33,33,104,104,65,65,14,14,127,127,12,12,95,95,51,51,41,41,104,104,67,67,3,3,49,49,42,42,108,108,28,28,95,95,107,107,112,112,112,112,111,111,96,96,2,2,69,69,47,47,66,66,102,102,17,17,90,90,87,87,100,100,90,90,28,28,112,112,34,34,4,4,49,49,82,82,84,84,51,51,32,32,35,35,96,96,10,10,110,110,7,7,27,27,45,45,78,78,116,116,61,61,89,89,35,35,8,8,52,52,56,56,69,69,15,15,97,97,76,76,36,36,36,36,60,60,58,58,81,81,112,112,16,16,39,39,107,107,110,110,97,97,105,105,58,58,54,54,41,41,99,99,11,11,110,110,120,120,81,81,100,100,108,108,26,26,11,11,40,40,84,84,117,117,2,2,37,37,75,75,18,18,56,56,95,95,122,122,11,11,74,74,117,117,85,85,25,25,11,11,8,8,1,1,14,14,36,36,10,10,67,67,51,51,41,41,109,109,29,29,73,73,109,109,31,31,55,55,8,8,28,28,29,29,121,121,88,88,72,72,107,107,47,47,74,74,37,37,63,63,13,13,2,2,114,114,81,81,120,120,73,73,95,95,1,1,64,64,112,112,34,34,18,18,115,115,33,33,31,31,92,92,10,10,64,64,53,53,42,42,49,49,52,52,104,104,36,36,74,74,18,18,48,48,50,50,5,5,98,98,37,37,26,26,71,71,59,59,11,11,30,30,12,12,51,51,106,106,101,101,57,57,127,127,115,115,85,85,26,26,11,11,108,108,46,46,110,110,49,49,35,35,98,98,21,21,46,46,83,83,42,42,108,108,89,89,108,108,34,34,113,113,40,40,61,61,26,26,51,51,92,92,85,85,34,34,42,42,51,51,63,63,71,71,14,14,73,73,63,63,81,81,0,0,19,19,71,71,72,72,83,83,119,119,116,116,15,15,5,5,112,112,127,127,78,78,9,9,127,127,99,99,84,84,0,0,70,70,42,42,95,95,50,50,79,79,118,118,42,42,35,35,110,110,64,64,31,31,102,102,56,56,96,96,2,2,62,62,81,81,109,109,27,27,112,112,82,82,73,73,67,67,83,83,17,17,84,84,8,8,3,3,31,31,96,96,23,23,72,72,11,11,14,14,97,97,61,61,99,99,114,114,26,26,105,105,84,84,33,33,109,109,24,24,101,101,22,22,10,10,17,17,34,34,96,96,36,36,25,25,49,49,113,113,46,46,127,127,56,56,22,22,33,33,5,5,94,94,23,23,97,97,106,106,8,8,42,42,1,1,123,123,109,109,113,113,95,95,27,27,72,72,124,124,31,31,78,78,113,113,16,16,70,70,57,57,88,88,75,75,63,63,62,62,49,49,79,79,28,28,24,24,125,125,66,66,109,109,116,116,121,121,11,11,0,0,30,30,25,25,121,121,52,52,86,86,18,18,68,68,93,93,19,19,22,22,43,43,91,91,61,61,86,86,118,118,35,35,29,29,47,47,19,19,26,26,4,4,85,85,110,110,36,36,121,121,114,114,69,69,48,48,32,32,20,20,56,56,126,126,9,9,75,75,39,39,53,53,27,27,109,109,107,107,113,113,27,27,113,113,14,14,119,119,96,96,75,75,47,47,20,20,32,32,74,74,50,50,14,14,72,72,21,21,118,118,71,71,49,49,123,123,36,36,26,26,119,119,122,122,4,4,53,53,90,90,88,88,126,126,44,44,125,125,115,115,48,48,34,34,6,6,99,99,64,64,44,44,74,74,106,106,36,36,24,24,120,120,83,83,30,30,123,123,106,106,12,12,69,69,16,16,100,100,108,108,66,66,94,94,55,55,12,12,108,108,1,1,114,114,72,72,19,19,64,64,10,10,27,27,112,112,13,13,30,30,103,103,51,51,68,68,9,9,31,31,16,16,25,25,109,109,99,99,40,40,20,20,9,9,53,53,11,11,125,125,45,45,118,118,56,56,65,65,43,43,79,79,62,62,42,42,18,18,30,30,43,43,28,28,42,42,126,126,61,61,57,57,1,1,32,32,85,85,114,114,34,34,66,66,0,0,112,112,58,58,96,96,98,98,59,59,43,43,126,126,28,28,104,104,121,121,105,105,51,51,44,44,85,85,10,10,14,14,63,63,70,70,23,23,65,65,102,102,43,43,88,88,25,25,82,82,117,117,62,62,22,22,118,118,124,124,56,56,115,115,22,22,58,58,91,91,120,120,92,92,94,94,78,78,44,44,113,113,9,9,3,3,11,11,49,49,116,116,0,0,91,91,66,66,32,32,99,99,8,8,34,34,17,17,43,43,55,55,119,119,10,10,98,98,127,127,45,45,56,56,18,18,35,35,75,75,64,64,85,85,40,40,3,3,94,94,62,62,100,100,92,92,10,10,75,75,31,31,57,57,0,0,124,124,43,43,19,19,110,110,103,103,54,54,38,38,103,103,127,127,121,121,124,124,91,91,47,47,25,25,2,2,66,66,55,55,76,76,27,27,79,79,87,87,14,14,37,37,25,25,28,28,76,76,35,35,44,44,20,20,115,115,105,105,112,112,15,15,89,89,73,73,72,72,126,126,30,30,103,103,59,59,110,110,67,67,51,51,43,43,51,51,22,22,76,76,41,41,101,101,72,72,20,20,84,84,77,77,109,109,43,43,124,124,54,54,104,104,60,60,45,45,89,89,25,25,112,112,102,102,16,16,112,112,57,57,81,81,58,58,2,2,19,19,122,122,5,5,64,64,35,35,96,96,126,126,106,106,92,92,60,60,63,63,19,19,9,9,11,11,66,66,50,50,100,100,112,112,67,67,92,92,18,18,110,110,58,58,116,116,83,83,84,84,66,66,110,110,104,104,105,105,74,74,48,48,55,55,78,78,78,78,100,100,72,72,102,102,18,18,8,8,121,121,2,2,28,28,27,27,4,4,104,104,52,52,93,93,45,45,100,100,98,98,120,120,73,73,62,62,89,89,48,48,118,118,22,22,125,125,52,52,86,86,62,62,75,75,65,65,99,99,43,43,100,100,44,44,39,39,109,109,26,26,8,8,76,76,40,40,114,114,121,121,125,125,41,41,92,92,2,2,69,69,92,92,21,21,25,25,101,101,77,77,127,127,106,106,30,30,13,13,19,19,45,45,27,27,91,91,21,21,32,32,49,49,92,92,64,64,103,103,54,54,22,22,101,101,10,10,127,127,120,120,47,47,75,75,72,72,68,68,67,67,115,115,9,9,123,123,12,12,85,85,32,32,121,121,71,71,88,88,63,63,75,75,112,112,92,92,33,33,85,85,101,101,17,17,44,44,69,69,35,35,123,123,67,67,102,102,65,65,77,77,13,13,100,100,110,110,64,64,95,95,80,80,6,6,26,26,105,105,34,34,85,85,113,113,13,13,58,58,96,96,104,104,63,63,88,88,24,24,111,111,112,112,34,34,112,112,40,40,76,76,34,34,90,90,45,45,100,100,106,106,124,124,84,84,17,17,100,100,50,50,116,116,33,33,106,106,66,66,53,53,52,52,109,109,53,53,52,52,122,122,59,59,60,60,61,61,40,40,78,78,82,82,39,39,51,51,33,33,119,119,26,26,20,20,35,35,49,49,45,45,92,92,14,14,59,59,31,31,22,22,7,7,8,8,71,71,48,48,57,57,104,104,62,62,33,33,28,28,84,84,5,5,69,69,124,124,7,7,87,87,63,63,62,62,66,66,115,115,98,98,109,109,117,117,56,56,105,105,76,76,27,27,48,48,20,20,26,26,16,16,93,93,75,75,58,58,101,101,110,110,126,126,23,23,24,24,27,27,110,110,47,47,29,29,115,115,89,89,33,33,91,91,80,80,36,36,72,72,43,43,22,22,6,6,16,16,14,14,51,51,7,7,121,121,92,92,56,56,43,43,100,100,55,55,74,74,119,119,35,35,108,108,8,8,53,53,33,33,49,49,111,111,75,75,91,91,96,96,21,21,3,3,1,1,125,125,63,63,30,30,118,118,68,68,50,50,97,97,71,71,113,113,21,21,69,69,48,48,37,37,69,69,29,29,12,12,18,18,6,6,119,119,15,15,111,111,70,70,83,83,98,98,108,108,110,110,56,56,110,110,59,59,110,110,15,15,19,19,90,90,105,105,75,75,58,58,49,49,109,109,80,80,38,38,23,23,5,5,38,38,37,37,1,1,82,82,9,9,65,65,70,70,25,25,34,34,103,103,109,109,106,106,121,121,97,97,17,17,24,24,122,122,58,58,81,81,93,93,12,12,39,39,43,43,116,116,71,71,59,59,24,24,46,46,107,107,16,16,90,90,1,1,84,84,77,77,112,112,116,116,68,68,77,77,109,109,8,8,76,76,63,63,109,109,86,86,108,108,58,58,84,84,9,9,116,116,48,48,118,118,76,76,2,2,111,111,22,22,121,121,75,75,86,86,74,74,89,89,55,55,68,68,38,38,98,98,59,59,56,56,40,40,97,97,93,93,100,100,46,46,36,36,29,29,77,77,9,9,86,86,123,123,24,24,36,36,61,61,66,66,54,54,112,112,59,59,79,79,19,19,57,57,50,50,44,44,11,11,114,114,73,73,82,82,117,117,83,83,74,74,97,97,56,56,23,23,93,93,43,43,104,104,57,57,112,112,25,25,118,118,53,53,10,10,78,78,18,18,90,90,91,91,3,3,32,32,28,28,12,12,86,86,84,84,95,95,48,48,39,39,44,44,41,41,18,18,91,91,9,9,57,57,40,40,30,30,33,33,60,60,16,16,81,81,4,4,43,43,29,29,98,98,104,104,39,39,20,20,73,73,96,96,80,80,0,0,10,10,51,51,43,43,127,127,86,86,0,0,15,15,69,69,24,24,45,45,76,76,124,124,80,80,85,85,55,55,100,100,58,58,96,96,45,45,96,96,30,30,91,91,68,68,25,25,87,87,70,70,37,37,6,6,27,27,122,122,38,38,39,39,34,34,0,0,102,102,36,36,15,15,94,94,6,6,47,47,101,101,103,103,107,107,9,9,44,44,86,86,27,27,22,22,106,106,112,112,74,74,79,79,100,100,47,47,95,95,109,109,112,112,23,23,76,76,105,105,80,80,67,67,17,17,21,21,102,102,84,84,98,98,114,114,11,11,9,9,77,77,118,118,32,32,15,15,26,26,10,10,35,35,59,59,65,65,61,61,74,74,100,100,18,18,107,107,64,64,2,2,81,81,7,7,58,58,107,107,127,127,13,13,48,48,89,89,1,1,35,35,38,38,1,1,105,105,109,109,60,60,121,121,48,48,34,34,2,2,85,85,70,70,32,32,107,107,14,14,123,123,66,66,123,123,16,16,122,122,120,120,70,70,119,119,51,51,33,33,63,63,64,64,113,113,110,110,5,5,76,76,99,99,117,117,27,27,90,90,57,57,89,89,22,22,110,110,16,16,2,2,37,37,30,30,9,9,15,15,65,65,99,99,9,9,32,32,2,2,43,43,50,50,22,22,37,37,25,25,56,56,13,13,34,34,75,75,117,117,77,77,77,77,71,71,38,38,36,36,124,124,105,105,82,82,22,22,115,115,74,74,72,72,68,68,67,67,106,106,100,100,37,37,12,12,18,18,75,75,11,11,32,32,64,64,73,73,85,85,31,31,103,103,7,7,92,92,90,90,58,58,12,12,82,82,45,45,28,28,18,18,62,62,101,101,102,102,27,27,114,114,80,80,19,19,0,0,0,0,20,20,21,21,74,74,124,124,28,28,108,108,29,29,57,57,46,46,91,91,51,51,1,1,31,31,21,21,67,67,23,23,104,104,55,55,50,50,32,32,56,56,41,41,73,73,91,91,95,95,65,65,6,6,104,104,53,53,114,114,25,25,64,64,117,117,91,91,35,35,75,75,55,55,43,43,83,83,111,111,89,89,35,35,38,38,48,48,105,105,75,75,115,115,59,59,112,112,34,34,21,21,88,88,20,20,10,10,33,33,112,112,83,83,17,17,91,91,3,3,43,43,102,102,44,44,26,26,42,42,35,35,52,52,98,98,44,44,33,33,36,36,68,68,107,107,49,49,101,101,4,4,100,100,125,125,66,66,35,35,85,85,96,96,95,95,50,50,14,14,72,72,46,46,41,41,8,8,83,83,51,51,29,29,3,3,61,61,6,6,26,26,72,72,93,93,3,3,111,111,109,109,33,33,19,19,117,117,45,45,8,8,87,87,95,95,6,6,86,86,42,42,24,24,21,21,80,80,28,28,10,10,125,125,81,81,21,21,85,85,9,9,61,61,25,25,126,126,126,126,66,66,85,85,32,32,57,57,97,97,80,80,48,48,120,120,2,2,122,122,43,43,88,88,20,20,124,124,57,57,97,97,75,75,73,73,26,26,108,108,30,30,28,28,32,32,88,88,14,14,54,54,8,8,35,35,93,93,122,122,28,28,63,63,60,60,120,120,5,5,44,44,20,20,67,67,74,74,9,9,9,9,69,69,18,18,102,102,116,116,124,124,94,94,106,106,81,81,96,96,34,34,105,105,41,41,74,74,96,96,112,112,40,40,55,55,114,114,31,31,72,72,97,97,74,74,72,72,19,19,50,50,11,11,84,84,2,2,44,44,74,74,46,46,10,10,96,96,99,99,71,71,13,13,98,98,24,24,92,92,74,74,36,36,25,25,41,41,85,85,104,104,99,99,102,102,11,11,86,86,16,16,65,65,72,72,113,113,44,44,17,17,106,106,101,101,12,12,113,113,98,98,103,103,3,3,46,46,63,63,88,88,15,15,65,65,120,120,105,105,36,36,107,107,21,21,20,20,70,70,22,22,71,71,86,86,56,56,85,85,17,17,108,108,69,69,4,4,79,79,70,70,45,45,11,11,60,60,48,48,23,23,29,29,20,20,109,109,61,61,27,27,72,72,39,39,83,83,19,19,113,113,100,100,71,71,9,9,28,28,118,118,11,11,73,73,12,12,72,72,63,63,70,70,75,75,77,77,26,26,23,23,92,92,8,8,28,28,0,0,41,41,5,5,119,119,45,45,56,56,96,96,72,72,83,83,2,2,32,32,10,10,2,2,47,47,72,72,48,48,26,26,83,83,66,66,86,86,92,92,21,21,6,6,17,17,63,63,116,116,127,127,64,64,79,79,29,29,124,124,89,89,62,62,69,69,35,35,1,1,12,12,69,69,112,112,90,90,49,49,116,116,2,2,82,82,18,18,61,61,127,127,100,100,106,106,75,75,46,46,31,31,119,119,123,123,117,117,79,79,10,10,30,30,101,101,40,40,54,54,85,85,67,67,30,30,40,40,48,48,57,57,92,92,3,3,126,126,28,28,88,88,5,5,78,78,67,67,27,27,79,79,82,82,0,0,13,13,111,111,102,102,63,63,125,125,4,4,55,55,0,0,34,34,81,81,81,81,102,102,66,66,18,18,83,83,90,90,11,11,73,73,16,16,20,20,77,77,115,115,113,113,38,38,120,120,65,65,97,97,16,16,63,63,35,35,27,27,56,56,16,16,91,91,43,43,94,94,34,34,87,87,63,63,36,36,24,24,105,105,66,66,41,41,114,114,66,66,68,68,33,33,74,74,127,127,104,104,86,86,32,32,11,11,93,93,25,25,40,40,82,82,79,79,23,23,52,52,53,53,2,2,75,75,64,64,102,102,0,0,25,25,94,94,80,80,25,25,37,37,19,19,72,72,117,117,48,48,14,14,51,51,96,96,118,118,36,36,104,104,23,23,45,45,72,72,74,74,118,118,28,28,8,8,6,6,44,44,103,103,18,18,46,46,111,111,105,105,112,112,61,61,77,77,115,115,81,81,44,44,57,57,46,46,7,7,52,52,105,105,50,50,28,28,64,64,119,119,33,33,122,122,86,86,13,13,17,17,11,11,115,115,8,8,71,71,30,30,52,52,116,116,25,25,106,106,113,113,81,81,23,23,78,78,1,1,70,70,8,8,78,78,24,24,64,64,56,56,124,124,62,62,118,118,112,112,17,17,2,2,81,81,32,32,50,50,33,33,25,25,64,64,51,51,64,64,40,40,27,27,52,52,56,56,56,56,5,5,27,27,83,83,76,76,112,112,40,40,81,81,74,74,67,67,7,7,68,68,118,118,37,37,9,9,15,15,78,78,33,33,95,95,55,55,68,68,87,87,118,118,109,109,82,82,112,112,30,30,101,101,35,35,74,74,43,43,70,70,0,0,50,50,39,39,10,10,92,92,98,98,82,82,2,2,39,39,39,39,81,81,121,121,58,58,118,118,39,39,108,108,95,95,66,66,4,4,123,123,107,107,84,84,16,16,40,40,100,100,68,68,48,48,28,28,16,16,89,89,61,61,109,109,23,23,66,66,3,3,97,97,35,35,36,36,95,95,55,55,61,61,56,56,88,88,61,61,52,52,1,1,41,41,88,88,5,5,92,92,8,8,4,4,12,12,114,114,104,104,79,79,72,72,39,39,9,9,113,113,116,116,116,116,85,85,94,94,40,40,92,92,71,71,103,103,24,24,78,78,90,90,118,118,1,1,67,67,52,52,66,66,53,53,62,62,75,75,91,91,7,7,122,122,64,64,10,10,2,2,116,116,65,65,19,19,77,77,44,44,47,47,1,1,5,5,74,74,11,11,37,37,88,88,17,17,30,30,30,30,61,61,4,4,70,70,81,81,85,85,93,93,14,14,37,37,66,66,51,51,23,23,54,54,4,4,100,100,11,11,85,85,98,98,72,72,96,96,77,77,104,104,61,61,111,111,67,67,24,24,42,42,117,117,93,93,19,19,22,22,20,20,1,1,47,47,104,104,2,2,37,37,40,40,127,127,66,66,62,62,106,106,8,8,92,92,80,80,46,46,115,115,8,8,23,23,94,94,115,115,38,38,122,122,72,72,51,51,15,15,7,7,43,43,98,98,113,113,67,67,42,42,41,41,69,69,28,28,85,85,86,86,49,49,126,126,103,103,68,68,85,85,7,7,11,11,75,75,34,34,30,30,99,99,26,26,98,98,57,57,9,9,17,17,104,104,112,112,51,51,19,19,19,19,125,125,59,59,50,50,65,65,95,95,40,40,73,73,3,3,79,79,110,110,38,38,93,93,48,48,35,35,23,23,24,24,101,101,127,127,16,16,57,57,88,88,26,26,34,34,13,13,87,87,63,63,100,100,16,16,123,123,117,117,30,30,66,66,94,94,4,4,110,110,85,85,60,60,53,53,33,33,108,108,70,70,111,111,62,62,10,10,33,33,106,106,22,22,61,61,29,29,75,75,0,0,28,28,102,102,89,89,111,111,66,66,33,33,41,41,122,122,114,114,19,19,87,87,103,103,40,40,104,104,49,49,7,7,81,81,16,16,74,74,7,7,104,104,8,8,3,3,113,113,89,89,22,22,19,19,120,120,125,125,47,47,64,64,12,12,104,104,8,8,0,0,57,57,124,124,75,75,114,114,44,44,34,34,113,113,29,29,41,41,111,111,25,25,80,80,96,96,114,114,124,124,44,44,52,52,80,80,113,113,109,109,56,56,44,44,44,44,69,69,82,82,7,7,113,113,75,75,70,70,83,83,51,51,51,51,6,6,94,94,50,50,22,22,110,110,33,33,36,36,6,6,39,39,42,42,109,109,79,79,98,98,24,24,49,49,67,67,90,90,80,80,9,9,20,20,94,94,64,64,20,20,8,8,56,56,67,67,44,44,50,50,115,115,58,58,94,94,116,116,112,112,16,16,65,65,46,46,98,98,72,72,104,104,18,18,27,27,31,31,10,10,76,76,11,11,51,51,77,77,21,21,7,7,32,32,106,106,87,87,87,87,22,22,48,48,36,36,11,11,20,20,18,18,80,80,19,19,122,122,87,87,81,81,82,82,8,8,97,97,25,25,80,80,97,97,11,11,15,15,12,12,109,109,107,107,36,36,122,122,34,34,46,46,109,109,76,76,1,1,41,41,2,2,52,52,122,122,48,48,34,34,119,119,11,11,27,27,57,57,37,37,7,7,16,16,18,18,65,65,76,76,25,25,31,31,124,124,77,77,14,14,5,5,52,52,125,125,79,79,9,9,25,25,113,113,31,31,86,86,67,67,14,14,92,92,101,101,31,31,99,99,24,24,104,104,38,38,88,88,100,100,28,28,15,15,73,73,94,94,35,35,71,71,65,65,23,23,69,69,8,8,1,1,104,104,124,124,80,80,87,87,37,37,18,18,14,14,32,32,97,97,91,91,36,36,7,7,16,16,75,75,3,3,96,96,119,119,90,90,48,48,38,38,100,100,99,99,63,63,85,85,72,72,4,4,126,126,119,119,20,20,91,91,94,94,70,70,83,83,1,1,116,116,62,62,21,21,45,45,54,54,25,25,92,92,41,41,40,40,61,61,63,63,39,39,82,82,110,110,6,6,113,113,97,97,36,36,99,99,76,76,109,109,77,77,66,66,114,114,30,30,80,80,59,59,82,82,70,70,81,81,1,1,82,82,91,91,7,7,56,56,14,14,126,126,21,21,62,62,71,71,24,24,90,90,35,35,32,32,70,70,59,59,125,125,87,87,67,67,0,0,100,100,9,9,47,47,111,111,98,98,106,106,78,78,41,41,2,2,24,24,4,4,69,69,14,14,5,5,23,23,82,82,0,0,81,81,10,10,14,14,96,96,112,112,100,100,33,33,114,114,28,28,123,123,51,51,68,68,105,105,119,119,66,66,78,78,71,71,7,7,49,49,126,126,28,28,72,72,15,15,40,40,4,4,113,113,78,78,120,120,124,124,32,32,43,43,96,96,26,26,28,28,102,102,1,1,108,108,28,28,43,43,108,108,16,16,48,48,122,122,84,84,71,71,91,91,68,68,14,14,114,114,68,68,85,85,106,106,103,103,13,13,0,0,70,70,38,38,19,19,26,26,65,65,69,69,112,112,65,65,120,120,100,100,51,51,118,118,91,91,123,123,123,123,44,44,35,35,75,75,41,41,52,52,75,75,59,59,12,12,24,24,121,121,46,46,76,76,102,102,5,5,26,26,105,105,6,6,0,0,94,94,20,20,88,88,21,21,104,104,86,86,58,58,118,118,69,69,123,123,54,54,16,16,65,65,52,52,11,11,121,121,44,44,87,87,110,110,21,21,7,7,127,127,5,5,4,4,50,50,73,73,126,126,57,57,120,120,80,80,77,77,113,113,41,41,37,37,51,51,69,69,40,40,104,104,58,58,44,44,52,52,115,115,92,92,10,10,3,3,40,40,62,62,45,45,108,108,59,59,111,111,119,119,82,82,125,125,124,124,61,61,67,67,53,53,78,78,31,31,86,86,101,101,92,92,31,31,69,69,66,66,12,12,126,126,97,97,14,14,26,26,0,0,99,99,94,94,59,59,115,115,11,11,81,81,80,80,60,60,17,17,116,116,15,15,95,95,108,108,100,100,5,5,67,67,19,19,123,123,21,21,113,113,0,0,28,28,59,59,117,117,80,80,39,39,79,79,32,32,16,16,64,64,75,75,93,93,88,88,1,1,62,62,62,62,68,68,99,99,0,0,118,118,28,28,112,112,68,68,106,106,4,4,124,124,65,65,67,67,127,127,49,49,111,111,9,9,27,27,81,81,97,97,50,50,123,123,113,113,120,120,12,12,21,21,54,54,119,119,15,15,10,10,122,122,1,1,4,4,58,58,64,64,63,63,110,110,85,85,98,98,121,121,93,93,47,47,73,73,55,55,27,27,57,57,64,64,5,5,100,100,119,119,106,106,32,32,12,12,86,86,66,66,13,13,38,38,94,94,65,65,75,75,109,109,64,64,123,123,125,125,2,2,82,82,90,90,64,64,43,43,7,7,84,84,33,33,69,69,20,20,120,120,3,3,36,36,27,27,124,124,84,84,52,52,11,11,42,42,116,116,45,45,111,111,18,18,70,70,77,77,42,42,83,83,74,74,37,37,111,111,10,10,38,38,111,111,52,52,7,7,120,120,92,92,66,66,110,110,10,10,50,50,56,56,68,68,112,112,45,45,50,50,104,104,14,14,124,124,14,14,49,49,56,56,96,96,29,29,108,108,81,81,37,37,55,55,58,58,93,93,72,72,37,37,44,44,61,61,96,96,69,69,84,84,60,60,79,79,15,15,50,50,76,76,55,55,32,32,14,14,72,72,40,40,69,69,37,37,95,95,34,34,64,64,0,0,61,61,46,46,4,4,68,68,44,44,20,20,88,88,69,69,69,69,68,68,52,52,72,72,31,31,2,2,123,123,20,20,32,32,2,2,106,106,107,107,46,46,91,91,43,43,98,98,28,28,115,115,97,97,84,84,93,93,38,38,81,81,45,45,0,0,34,34,50,50,68,68,69,69,56,56,62,62,93,93,23,23,38,38,75,75,13,13,15,15,54,54,72,72,15,15,32,32,19,19,102,102,78,78,41,41,120,120,33,33,106,106,56,56,21,21,81,81,108,108,89,89,32,32,98,98,57,57,1,1,56,56,5,5,113,113,23,23,84,84,36,36,64,64,2,2,100,100,103,103,38,38,60,60,5,5,62,62,33,33,81,81,61,61,54,54,55,55,102,102,116,116,15,15,74,74,29,29,25,25,106,106,26,26,98,98,58,58,14,14,50,50,27,27,73,73,33,33,109,109,96,96,98,98,115,115,18,18,110,110,53,53,43,43,14,14,65,65,122,122,14,14,36,36,71,71,66,66,96,96,126,126,77,77,82,82,46,46,25,25,97,97,60,60,70,70,80,80,15,15,106,106,114,114,56,56,124,124,52,52,127,127,6,6,114,114,115,115,120,120,75,75,63,63,73,73,38,38,11,11,28,28,68,68,9,9,55,55,58,58,77,77,60,60,81,81,82,82,123,123,60,60,103,103,73,73,57,57,31,31,66,66,24,24,34,34,79,79,108,108,101,101,48,48,50,50,83,83,126,126,87,87,73,73,3,3,13,13,123,123,127,127,51,51,31,31,87,87,25,25,29,29,82,82,110,110,121,121,5,5,84,84,73,73,86,86,112,112,70,70,33,33,23,23,72,72,96,96,8,8,121,121,19,19,96,96,101,101,102,102,35,35,41,41,81,81,105,105,96,96,11,11,75,75,0,0,88,88,29,29,70,70,6,6,24,24,87,87,63,63,105,105,33,33,52,52,73,73,81,81,110,110,74,74,10,10,71,71,123,123,126,126,57,57,67,67,71,71,24,24,105,105,84,84,89,89,92,92,105,105,4,4,4,4,68,68,18,18,83,83,40,40,92,92,42,42,11,11,125,125,43,43,55,55,3,3,49,49,111,111,119,119,54,54,61,61,13,13,11,11,114,114,0,0,113,113,95,95,93,93,10,10,83,83,90,90,28,28,122,122,6,6,108,108,125,125,125,125,8,8,126,126,122,122,9,9,14,14,56,56,36,36,2,2,39,39,41,41,35,35,106,106,43,43,5,5,39,39,17,17,64,64,42,42,78,78,72,72,69,69,119,119,75,75,84,84,124,124,106,106,46,46,106,106,76,76,114,114,121,121,75,75,19,19,63,63,20,20,90,90,71,71,101,101,104,104,10,10,34,34,46,46,115,115,97,97,117,117,74,74,10,10,91,91,89,89,52,52,9,9,16,16,35,35,10,10,104,104,38,38,67,67,113,113,104,104,35,35,113,113,57,57,31,31,57,57,74,74,110,110,29,29,108,108,26,26,42,42,82,82,104,104,43,43,28,28,85,85,102,102,22,22,84,84,85,85,55,55,84,84,107,107,48,48,48,48,93,93,43,43,66,66,32,32,70,70,15,15,59,59,51,51,119,119,64,64,28,28,68,68,25,25,7,7,116,116,56,56,26,26,121,121,8,8,109,109,109,109,19,19,19,19,87,87,43,43,106,106,116,116,37,37,122,122,42,42,5,5,46,46,106,106,18,18,114,114,37,37,57,57,39,39,42,42,18,18,114,114,48,48,101,101,79,79,8,8,19,19,51,51,3,3,109,109,24,24,92,92,107,107,24,24,64,64,98,98,126,126,66,66,55,55,72,72,64,64,27,27,81,81,50,50,103,103,102,102,80,80,3,3,52,52,13,13,12,12,110,110,71,71,18,18,99,99,86,86,102,102,95,95,79,79,63,63,51,51,30,30,90,90,30,30,49,49,115,115,65,65,17,17,61,61,47,47,68,68,97,97,43,43,68,68,104,104,17,17,41,41,33,33,106,106,53,53,105,105,99,99,56,56,48,48,67,67,97,97,67,67,42,42,34,34,100,100,54,54,11,11,95,95,82,82,81,81,123,123,40,40,16,16,56,56,97,97,4,4,10,10,39,39,93,93,108,108,96,96,97,97,64,64,13,13,127,127,86,86,109,109,5,5,6,6,84,84,47,47,40,40,48,48,1,1,83,83,125,125,110,110,115,115,63,63,0,0,75,75,73,73,61,61,88,88,78,78,6,6,118,118,33,33,124,124,116,116,111,111,112,112,6,6,84,84,42,42,1,1,33,33,85,85,124,124,14,14,122,122,94,94,81,81,28,28,67,67,38,38,95,95,66,66,96,96,95,95,94,94,53,53,55,55,14,14,75,75,103,103,8,8,99,99,41,41,86,86,85,85,83,83,118,118,102,102,85,85,105,105,74,74,67,67,66,66,117,117,15,15,43,43,76,76,27,27,94,94,110,110,2,2,43,43,56,56,27,27,6,6,35,35,71,71,4,4,105,105,11,11,104,104,126,126,99,99,1,1,37,37,53,53,91,91,94,94,91,91,79,79,70,70,98,98,32,32,18,18,106,106,93,93,102,102,122,122,26,26,51,51,6,6,51,51,12,12,102,102,80,80,31,31,84,84,69,69,23,23,49,49,108,108,95,95,97,97,76,76,107,107,7,7,65,65,3,3,76,76,15,15,124,124,122,122,124,124,70,70,114,114,1,1,123,123,1,1,96,96,58,58,32,32,2,2,42,42,127,127,14,14,56,56,7,7,77,77,117,117,34,34,105,105,97,97,3,3,8,8,60,60,106,106,45,45,21,21,62,62,27,27,88,88,23,23,102,102,83,83,118,118,37,37,65,65,47,47,56,56,37,37,14,14,24,24,9,9,78,78,2,2,34,34,9,9,125,125,60,60,7,7,12,12,4,4,65,65,10,10,39,39,56,56,61,61,75,75,42,42,68,68,75,75,12,12,15,15,103,103,12,12,20,20,69,69,57,57,85,85,8,8,117,117,114,114,1,1,50,50,125,125,20,20,120,120,36,36,101,101,75,75,28,28,16,16,78,78,3,3,79,79,44,44,3,3,65,65,10,10,77,77,80,80,55,55,38,38,18,18,115,115,67,67,114,114,22,22,102,102,23,23,66,66,11,11,93,93,98,98,3,3,66,66,84,84,94,94,70,70,56,56,77,77,91,91,64,64,107,107,102,102,113,113,62,62,75,75,22,22,119,119,8,8,75,75,15,15,27,27,26,26,52,52,26,26,117,117,15,15,21,21,78,78,57,57,106,106,1,1,16,16,36,36,37,37,3,3,94,94,28,28,27,27,117,117,100,100,64,64,53,53,45,45,70,70,108,108,27,27,83,83,79,79,49,49,66,66,29,29,29,29,22,22,29,29,22,22,38,38,58,58,121,121,96,96,39,39,126,126,14,14,66,66,114,114,50,50,39,39,102,102,8,8,24,24,56,56,82,82,21,21,9,9,25,25,112,112,21,21,71,71,100,100,45,45,117,117,84,84,38,38,27,27,51,51,23,23,80,80,9,9,19,19,117,117,19,19,22,22,12,12,65,65,28,28,9,9,66,66,88,88,62,62,21,21,18,18,39,39,105,105,28,28,67,67,66,66,123,123,2,2,15,15,69,69,52,52,88,88,67,67,20,20,65,65,120,120,78,78,58,58,39,39,67,67,85,85,8,8,24,24,74,74,96,96,86,86,60,60,37,37,29,29,78,78,7,7,76,76,8,8,104,104,4,4,71,71,2,2,6,6,74,74,66,66,21,21,127,127,101,101,107,107,125,125,105,105,84,84,33,33,19,19,107,107,86,86,89,89,114,114,24,24,37,37,68,68,2,2,35,35,106,106,3,3,126,126,35,35,2,2,73,73,55,55,52,52,18,18,33,33,108,108,78,78,49,49,53,53,54,54,124,124,99,99,41,41,73,73,35,35,100,100,32,32,111,111,17,17,82,82,0,0,26,26,91,91,80,80,121,121,113,113,71,71,101,101,83,83,108,108,68,68,27,27,102,102,51,51,59,59,53,53,71,71,105,105,80,80,119,119,91,91,55,55,39,39,42,42,33,33,85,85,12,12,84,84,115,115,82,82,125,125,29,29,7,7,64,64,109,109,108,108,20,20,0,0,122,122,11,11,118,118,33,33,48,48,112,112,103,103,60,60,66,66,102,102,6,6,20,20,78,78,93,93,98,98,74,74,40,40,42,42,67,67,104,104,4,4,73,73,86,86,42,42,62,62,84,84,2,2,75,75,34,34,127,127,100,100,75,75,21,21,88,88,84,84,46,46,50,50,22,22,104,104,5,5,5,5,24,24,108,108,20,20,12,12,37,37,97,97,117,117,13,13,17,17,115,115,64,64,40,40,113,113,86,86,9,9,64,64,29,29,16,16,13,13,116,116,25,25,119,119,80,80,99,99,108,108,50,50,47,47,86,86,65,65,36,36,24,24,51,51,104,104,30,30,2,2,65,65,73,73,3,3,76,76,29,29,61,61,83,83,111,111,41,41,80,80,68,68,5,5,49,49,51,51,82,82,117,117,6,6,43,43,52,52,51,51,25,25,71,71,82,82,81,81,66,66,114,114,88,88,92,92,25,25,74,74,86,86,44,44,19,19,35,35,63,63,36,36,15,15,109,109,31,31,84,84,6,6,38,38,125,125,85,85,114,114,34,34,80,80,58,58,29,29,20,20,69,69,35,35,13,13,8,8,118,118,15,15,6,6,43,43,12,12,73,73,45,45,51,51,98,98,2,2,61,61,17,17,99,99,100,100,97,97,32,32,48,48,96,96,88,88,110,110,120,120,109,109,114,114,88,88,107,107,15,15,72,72,115,115,58,58,68,68,18,18,120,120,101,101,43,43,10,10,82,82,44,44,34,34,45,45,41,41,120,120,47,47,5,5,2,2,30,30,18,18,82,82,42,42,85,85,13,13,21,21,83,83,119,119,114,114,114,114,119,119,97,97,80,80,118,118,93,93,110,110,107,107,100,100,20,20,79,79,52,52,83,83,103,103,96,96,91,91,89,89,81,81,105,105,36,36,95,95,115,115,76,76,7,7,62,62,82,82,97,97,42,42,81,81,0,0,20,20,114,114,60,60,63,63,57,57,58,58,125,125,49,49,48,48,57,57,26,26,26,26,125,125,3,3,84,84,1,1,59,59,21,21,65,65,87,87,69,69,98,98,57,57,42,42,75,75,3,3,126,126,69,69,30,30,80,80,57,57,17,17,115,115,11,11,111,111,43,43,31,31,82,82,32,32,102,102,27,27,104,104,0,0,121,121,60,60,93,93,111,111,42,42,51,51,39,39,6,6,49,49,41,41,69,69,44,44,37,37,2,2,2,2,39,39,24,24,112,112,15,15,36,36,69,69,13,13,24,24,49,49,2,2,13,13,17,17,35,35,79,79,54,54,53,53,21,21,124,124,37,37,43,43,40,40,104,104,103,103,66,66,10,10,44,44,10,10,12,12,42,42,98,98,121,121,25,25,67,67,78,78,83,83,39,39,37,37,40,40,5,5,67,67,107,107,44,44,89,89,86,86,41,41,89,89,53,53,104,104,9,9,16,16,105,105,32,32,27,27,108,108,84,84,52,52,35,35,17,17,108,108,15,15,80,80,39,39,94,94,56,56,1,1,12,12,70,70,8,8,91,91,32,32,22,22,9,9,115,115,7,7,44,44,24,24,48,48,109,109,39,39,54,54,13,13,124,124,115,115,121,121,81,81,106,106,0,0,70,70,75,75,111,111,102,102,4,4,54,54,102,102,41,41,123,123,14,14,61,61,60,60,40,40,60,60,51,51,84,84,98,98,100,100,111,111,65,65,103,103,126,126,33,33,37,37,60,60,57,57,0,0,67,67,35,35,102,102,90,90,115,115,18,18,26,26,29,29,107,107,97,97,1,1,115,115,92,92,89,89,23,23,86,86,61,61,41,41,19,19,110,110,110,110,88,88,122,122,73,73,40,40,112,112,93,93,73,73,20,20,16,16,10,10,108,108,110,110,30,30,117,117,79,79,79,79,90,90,51,51,43,43,44,44,108,108,87,87,10,10,102,102,7,7,34,34,33,33,43,43,44,44,16,16,107,107,28,28,102,102,69,69,9,9,103,103,80,80,12,12,61,61,17,17,55,55,75,75,27,27,13,13,32,32,101,101,44,44,54,54,15,15,126,126,58,58,20,20,101,101,86,86,127,127,107,107,101,101,94,94,38,38,76,76,97,97,100,100,44,44,35,35,102,102,33,33,7,7,101,101,17,17,110,110,8,8,106,106,102,102,78,78,88,88,109,109,87,87,34,34,73,73,75,75,13,13,68,68,113,113,38,38,82,82,8,8,21,21,51,51,29,29,114,114,77,77,80,80,15,15,112,112,102,102,48,48,108,108,0,0,97,97,65,65,80,80,30,30,24,24,120,120,87,87,123,123,11,11,25,25,16,16,102,102,78,78,107,107,58,58,107,107,120,120,77,77,68,68,0,0,102,102,32,32,98,98,53,53,95,95,36,36,10,10,6,6,91,91,121,121,79,79,24,24,29,29,49,49,118,118,95,95,35,35,76,76,15,15,99,99,51,51,34,34,48,48,115,115,3,3,126,126,122,122,73,73,66,66,46,46,68,68,33,33,35,35,94,94,51,51,83,83,34,34,19,19,70,70,73,73,126,126,7,7,73,73,109,109,35,35,50,50,61,61,32,32,119,119,18,18,98,98,102,102,112,112,13,13,91,91,10,10,32,32,60,60,121,121,115,115,62,62,62,62,25,25,96,96,8,8,103,103,106,106,71,71,112,112,82,82,72,72,48,48,57,57,19,19,22,22,98,98,48,48,38,38,84,84,45,45,44,44,42,42,49,49,4,4,21,21,52,52,87,87,86,86,111,111,67,67,82,82,78,78,54,54,20,20,99,99,30,30,87,87,27,27,119,119,7,7,75,75,39,39,81,81,114,114,43,43,52,52,33,33,37,37,66,66,30,30,93,93,11,11,8,8,78,78,76,76,24,24,38,38,26,26,87,87,37,37,47,47,121,121,9,9,94,94,81,81,78,78,17,17,90,90,112,112,71,71,54,54,37,37,43,43,100,100,64,64,85,85,8,8,24,24,26,26,48,48,1,1,69,69,79,79,83,83,9,9,30,30,67,67,65,65,111,111,63,63,71,71,22,22,58,58,44,44,112,112,114,114,110,110,125,125,19,19,24,24,10,10,22,22,65,65,12,12,70,70,31,31,56,56,7,7,76,76,65,65,58,58,90,90,123,123,78,78,100,100,97,97,80,80,29,29,102,102,80,80,118,118,33,33,25,25,34,34,93,93,81,81,83,83,79,79,14,14,43,43,59,59,5,5,91,91,88,88,71,71,106,106,65,65,61,61,12,12,6,6,114,114,18,18,87,87,9,9,119,119,41,41,70,70,8,8,100,100,26,26,30,30,103,103,90,90,60,60,122,122,83,83,86,86,28,28,42,42,96,96,111,111,76,76,27,27,99,99,65,65,68,68,37,37,53,53,4,4,84,84,10,10,53,53,74,74,63,63,36,36,27,27,109,109,18,18,24,24,30,30,32,32,115,115,54,54,114,114,11,11,69,69,76,76,100,100,78,78,102,102,19,19,69,69,1,1,1,1,52,52,22,22,74,74,54,54,14,14,70,70,119,119,73,73,107,107,104,104,113,113,39,39,79,79,26,26,36,36,45,45,115,115,97,97,13,13,114,114,32,32,100,100,53,53,96,96,115,115,6,6,11,11,19,19,120,120,50,50,0,0,20,20,21,21,58,58,61,61,65,65,88,88,71,71,85,85,126,126,58,58,34,34,87,87,110,110,60,60,81,81,102,102,18,18,10,10,93,93,13,13,67,67,17,17,71,71,45,45,19,19,36,36,52,52,122,122,39,39,78,78,28,28,76,76,126,126,123,123,66,66,125,125,98,98,18,18,121,121,46,46,36,36,43,43,92,92,37,37,0,0,2,2,103,103,122,122,18,18,51,51,119,119,38,38,87,87,89,89,15,15,88,88,111,111,64,64,43,43,37,37,60,60,15,15,17,17,47,47,75,75,72,72,19,19,95,95,97,97,58,58,42,42,26,26,102,102,14,14,64,64,94,94,88,88,101,101,17,17,0,0,124,124,58,58,115,115,44,44,2,2,85,85,27,27,39,39,65,65,51,51,114,114,81,81,48,48,9,9,122,122,107,107,47,47,79,79,72,72,25,25,30,30,48,48,102,102,125,125,41,41,23,23,50,50,114,114,29,29,91,91,31,31,65,65,11,11,98,98,20,20,98,98,64,64,79,79,37,37,11,11,5,5,67,67,113,113,93,93,70,70,68,68,108,108,106,106,95,95,73,73,111,111,0,0,44,44,90,90,72,72,21,21,43,43,27,27,82,82,113,113,85,85,29,29,27,27,95,95,40,40,81,81,60,60,88,88,5,5,71,71,111,111,2,2,88,88,51,51,108,108,61,61,73,73,38,38,110,110,91,91,112,112,105,105,64,64,27,27,69,69,74,74,11,11,54,54,59,59,54,54,116,116,43,43,73,73,23,23,69,69,73,73,75,75,91,91,65,65,109,109,70,70,49,49,32,32,51,51,50,50,85,85,6,6,115,115,32,32,42,42,80,80,100,100,115,115,73,73,117,117,42,42,32,32,86,86,28,28,110,110,33,33,67,67,71,71,86,86,113,113,22,22,114,114,0,0,34,34,4,4,89,89,40,40,44,44,45,45,14,14,6,6,93,93,113,113,108,108,44,44,60,60,38,38,106,106,20,20,1,1,19,19,79,79,28,28,20,20,74,74,109,109,57,57,102,102,9,9,50,50,116,116,37,37,18,18,75,75,70,70,115,115,8,8,42,42,1,1,37,37,66,66,26,26,54,54,115,115,104,104,13,13,124,124,56,56,34,34,113,113,97,97,112,112,113,113,70,70,127,127,103,103,105,105,9,9,79,79,74,74,83,83,102,102,87,87,64,64,97,97,50,50,40,40,84,84,100,100,126,126,52,52,9,9,9,9,98,98,85,85,35,35,90,90,120,120,92,92,4,4,62,62,46,46,53,53,33,33,62,62,23,23,34,34,4,4,26,26,93,93,25,25,16,16,105,105,86,86,12,12,65,65,41,41,62,62,26,26,87,87,73,73,20,20,41,41,75,75,0,0,102,102,5,5,38,38,95,95,28,28,58,58,32,32,116,116,46,46,58,58,98,98,9,9,3,3,36,36,26,26,51,51,64,64,67,67,106,106,63,63,75,75,6,6,100,100,36,36,95,95,72,72,14,14,37,37,73,73,36,36,116,116,63,63,81,81,84,84,15,15,106,106,9,9,9,9,33,33,7,7,89,89,124,124,30,30,106,106,66,66,31,31,14,14,34,34,33,33,71,71,57,57,110,110,64,64,96,96,5,5,123,123,61,61,1,1,13,13,112,112,57,57,3,3,121,121,59,59,36,36,6,6,18,18,33,33,85,85,71,71,77,77,53,53,3,3,19,19,46,46,11,11,49,49,69,69,85,85,38,38,21,21,6,6,53,53,106,106,90,90,34,34,34,34,119,119,37,37,36,36,2,2,38,38,69,69,6,6,60,60,40,40,88,88,63,63,99,99,91,91,19,19,24,24,105,105,108,108,22,22,48,48,121,121,110,110,11,11,74,74,63,63,41,41,75,75,120,120,12,12,97,97,29,29,17,17,60,60,72,72,20,20,74,74,9,9,48,48,45,45,34,34,17,17,83,83,5,5,98,98,5,5,95,95,39,39,95,95,96,96,58,58,121,121,18,18,50,50,29,29,44,44,19,19,53,53,84,84,71,71,98,98,70,70,100,100,53,53,56,56,53,53,10,10,44,44,66,66,124,124,55,55,115,115,96,96,87,87,7,7,5,5,86,86,114,114,18,18,21,21,98,98,63,63,35,35,34,34,102,102,16,16,90,90,64,64,14,14,24,24,40,40,50,50,61,61,91,91,84,84,32,32,71,71,62,62,8,8,36,36,86,86,48,48,0,0,98,98,50,50,123,123,26,26,55,55,23,23,45,45,109,109,114,114,88,88,12,12,22,22,26,26,103,103,64,64,119,119,9,9,103,103,38,38,76,76,57,57,79,79,59,59,123,123,91,91,77,77,29,29,41,41,28,28,99,99,17,17,70,70,95,95,112,112,19,19,81,81,121,121,80,80,88,88,59,59,3,3,10,10,45,45,82,82,5,5,38,38,109,109,103,103,97,97,22,22,41,41,125,125,1,1,47,47,109,109,93,93,90,90,18,18,0,0,75,75,97,97,95,95,10,10,15,15,20,20,106,106,74,74,73,73,104,104,25,25,87,87,126,126,11,11,121,121,67,67,66,66,120,120,48,48,10,10,72,72,28,28,59,59,49,49,102,102,3,3,53,53,105,105,38,38,20,20,107,107,27,27,13,13,49,49,112,112,100,100,125,125,120,120,2,2,59,59,39,39,30,30,68,68,39,39,23,23,42,42,115,115,35,35,87,87,1,1,31,31,104,104,7,7,107,107,57,57,101,101,66,66,84,84,28,28,73,73,3,3,86,86,78,78,94,94,45,45,106,106,57,57,57,57,6,6,45,45,30,30,123,123,124,124,58,58,119,119,18,18,24,24,3,3,110,110,82,82,71,71,49,49,4,4,15,15,88,88,90,90,37,37,25,25,119,119,35,35,92,92,53,53,104,104,59,59,87,87,98,98,38,38,105,105,21,21,39,39,38,38,27,27,0,0,85,85,59,59,41,41,64,64,48,48,77,77,10,10,91,91,42,42,119,119,98,98,110,110,58,58,26,26,83,83,37,37,85,85,78,78,54,54,70,70,70,70,78,78,2,2,22,22,2,2,110,110,2,2,66,66,25,25,109,109,103,103,50,50,25,25,117,117,0,0,103,103,90,90,108,108,78,78,113,113,99,99,37,37,54,54,23,23,16,16,108,108,113,113,25,25,11,11,118,118,123,123,108,108,37,37,75,75,109,109,3,3,43,43,125,125,70,70,85,85,38,38,105,105,112,112,84,84,29,29,0,0,43,43,0,0,10,10,63,63,105,105,10,10,53,53,44,44,40,40,40,40,48,48,37,37,2,2,121,121,93,93,33,33,21,21,22,22,115,115,84,84,86,86,106,106,62,62,111,111,91,91,97,97,105,105,79,79,97,97,125,125,101,101,77,77,62,62,70,70,100,100,33,33,46,46,76,76,7,7,16,16,50,50,117,117,24,24,81,81,34,34,72,72,17,17,66,66,37,37,4,4,84,84,23,23,31,31,51,51,86,86,11,11,59,59,56,56,51,51,104,104,16,16,67,67,31,31,8,8,79,79,98,98,45,45,39,39,37,37,90,90,51,51,108,108,115,115,10,10,37,37,3,3,64,64,14,14,89,89,80,80,31,31,92,92,63,63,117,117,56,56,35,35,12,12,43,43,101,101,113,113,25,25,18,18,103,103,104,104,14,14,81,81,43,43,65,65,43,43,64,64,53,53,9,9,15,15,123,123,65,65,93,93,97,97,82,82,35,35,63,63,75,75,8,8,96,96,14,14,20,20,101,101,77,77,2,2,27,27,33,33,41,41,102,102,78,78,18,18,0,0,32,32,50,50,81,81,92,92,114,114,27,27,66,66,33,33,108,108,46,46,100,100,68,68,74,74,120,120,112,112,106,106,101,101,63,63,50,50,119,119,81,81,38,38,96,96,79,79,9,9,84,84,100,100,66,66,68,68,21,21,65,65,108,108,30,30,48,48,28,28,19,19,47,47,93,93,106,106,40,40,97,97,55,55,70,70,59,59,83,83,58,58,33,33,77,77,54,54,106,106,41,41,122,122,98,98,38,38,57,57,27,27,83,83,60,60,17,17,16,16,96,96,111,111,17,17,4,4,67,67,88,88,13,13,94,94,81,81,18,18,102,102,60,60,77,77,55,55,14,14,126,126,127,127,0,0,105,105,64,64,56,56,50,50,116,116,104,104,15,15,33,33,118,118,15,15,42,42,1,1,55,55,118,118,5,5,69,69,110,110,17,17,63,63,72,72,68,68,46,46,70,70,58,58,106,106,91,91,53,53,105,105,121,121,65,65,101,101,3,3,2,2,47,47,67,67,49,49,84,84,108,108,6,6,38,38,87,87,3,3,114,114,95,95,85,85,10,10,100,100,63,63,119,119,0,0,19,19,6,6,56,56,49,49,112,112,122,122,13,13,17,17,70,70,87,87,20,20,82,82,10,10,42,42,0,0,116,116,34,34,66,66,6,6,12,12,63,63,109,109,61,61,69,69,6,6,90,90,15,15,111,111,47,47,33,33,10,10,31,31,86,86,44,44,37,37,101,101,49,49,99,99,82,82,58,58,110,110,40,40,44,44,24,24,40,40,23,23,127,127,46,46,34,34,54,54,125,125,83,83,49,49,96,96,61,61,32,32,114,114,22,22,49,49,25,25,71,71,74,74,54,54,84,84,119,119,15,15,75,75,118,118,44,44,6,6,75,75,8,8,22,22,71,71,116,116,3,3,23,23,50,50,82,82,77,77,76,76,95,95,116,116,73,73,14,14,19,19,92,92,27,27,78,78,113,113,48,48,72,72,86,86,67,67,96,96,3,3,80,80,72,72,87,87,50,50,50,50,31,31,5,5,10,10,52,52,96,96,23,23,39,39,27,27,2,2,75,75,83,83,101,101,69,69,109,109,110,110,22,22,122,122,122,122,1,1,25,25,78,78,61,61,50,50,54,54,26,26,93,93,99,99,63,63,65,65,68,68,29,29,3,3,51,51,74,74,123,123,38,38,64,64,80,80,37,37,36,36,100,100,86,86,125,125,104,104,2,2,108,108,44,44,99,99,107,107,11,11,113,113,11,11,107,107,13,13,119,119,117,117,85,85,126,126,108,108,98,98,114,114,9,9,23,23,37,37,57,57,50,50,0,0,86,86,72,72,114,114,105,105,8,8,65,65,64,64,62,62,5,5,9,9,91,91,74,74,105,105,32,32,95,95,118,118,106,106,9,9,109,109,72,72,93,93,13,13,12,12,16,16,40,40,33,33,30,30,77,77,47,47,33,33,100,100,36,36,40,40,63,63,80,80,3,3,89,89,117,117,50,50,49,49,16,16,22,22,59,59,15,15,120,120,43,43,122,122,49,49,92,92,80,80,61,61,17,17,117,117,126,126,29,29,125,125,103,103,45,45,42,42,19,19,106,106,21,21,46,46,20,20,118,118,77,77,8,8,30,30,85,85,7,7,33,33,117,117,82,82,98,98,46,46,13,13,78,78,17,17,60,60,83,83,85,85,26,26,65,65,8,8,121,121,106,106,93,93,63,63,21,21,35,35,67,67,108,108,26,26,1,1,102,102,25,25,14,14,68,68,31,31,103,103,103,103,72,72,31,31,19,19,39,39,105,105,2,2,22,22,95,95,74,74,78,78,32,32,17,17,1,1,64,64,7,7,94,94,67,67,80,80,58,58,37,37,0,0,39,39,106,106,105,105,4,4,121,121,6,6,93,93,107,107,59,59,119,119,9,9,19,19,2,2,25,25,67,67,81,81,48,48,70,70,126,126,15,15,121,121,113,113,12,12,1,1,63,63,106,106,1,1,16,16,40,40,90,90,34,34,65,65,35,35,97,97,116,116,25,25,57,57,38,38,87,87,124,124,78,78,98,98,0,0,40,40,105,105,47,47,86,86,14,14,25,25,24,24,73,73,64,64,0,0,53,53,102,102,84,84,103,103,28,28,12,12,105,105,23,23,86,86,9,9,75,75,93,93,119,119,116,116,15,15,45,45,115,115,112,112,114,114,38,38,120,120,13,13,77,77,97,97,88,88,18,18,25,25,56,56,125,125,7,7,38,38,52,52,0,0,4,4,70,70,25,25,86,86,76,76,22,22,21,21,127,127,113,113,41,41,62,62,40,40,93,93,74,74,87,87,116,116,124,124,70,70,58,58,79,79,42,42,107,107,118,118,47,47,6,6,90,90,6,6,51,51,42,42,54,54,2,2,103,103,96,96,0,0,35,35,82,82,46,46,32,32,21,21,11,11,35,35,90,90,3,3,100,100,92,92,37,37,72,72,70,70,32,32,64,64,89,89,36,36,74,74,72,72,1,1,75,75,70,70,49,49,42,42,17,17,116,116,16,16,112,112,65,65,70,70,102,102,40,40,105,105,73,73,10,10,106,106,109,109,35,35,104,104,84,84,77,77,48,48,73,73,53,53,43,43,80,80,16,16,63,63,34,34,55,55,15,15,26,26,79,79,85,85,48,48,11,11,83,83,75,75,80,80,33,33,34,34,102,102,121,121,96,96,47,47,73,73,82,82,123,123,82,82,28,28,48,48,89,89,1,1,115,115,36,36,63,63,68,68,12,12,72,72,104,104,85,85,69,69,8,8,28,28,72,72,12,12,110,110,25,25,32,32,91,91,42,42,22,22,95,95,91,91,25,25,49,49,64,64,51,51,106,106,24,24,68,68,0,0,77,77,2,2,33,33,109,109,45,45,119,119,58,58,69,69,47,47,71,71,84,84,71,71,101,101,2,2,7,7,107,107,46,46,108,108,39,39,80,80,56,56,51,51,61,61,37,37,13,13,24,24,34,34,37,37,106,106,68,68,87,87,58,58,120,120,96,96,122,122,116,116,92,92,25,25,102,102,113,113,119,119,10,10,96,96,80,80,40,40,62,62,110,110,55,55,32,32,33,33,64,64,28,28,49,49,19,19,10,10,123,123,26,26,45,45,42,42,33,33,101,101,67,67,5,5,52,52,97,97,124,124,17,17,18,18,84,84,12,12,1,1,94,94,116,116,65,65,69,69,28,28,98,98,17,17,84,84,103,103,8,8,81,81,27,27,109,109,43,43,96,96,18,18,17,17,108,108,84,84,47,47,30,30,91,91,125,125,29,29,97,97,115,115,20,20,59,59,116,116,64,64,64,64,28,28,34,34,44,44,86,86,120,120,19,19,82,82,95,95,92,92,77,77,5,5,33,33,32,32,97,97,51,51,60,60,115,115,83,83,45,45,82,82,30,30,65,65,15,15,80,80,10,10,93,93,65,65,113,113,27,27,60,60,102,102,23,23,95,95,53,53,50,50,94,94,7,7,21,21,106,106,3,3,82,82,78,78,10,10,57,57,21,21,72,72,21,21,83,83,27,27,63,63,8,8,27,27,33,33,8,8,68,68,102,102,3,3,24,24,55,55,91,91,89,89,67,67,4,4,26,26,93,93,126,126,103,103,45,45,3,3,79,79,127,127,3,3,18,18,52,52,119,119,78,78,0,0,39,39,41,41,18,18,1,1,29,29,42,42,31,31,105,105,96,96,62,62,66,66,7,7,114,114,20,20,115,115,75,75,54,54,116,116,43,43,54,54,90,90,44,44,8,8,35,35,11,11,124,124,40,40,70,70,61,61,127,127,58,58,24,24,85,85,40,40,68,68,31,31,4,4,111,111,68,68,88,88,1,1,46,46,105,105,34,34,34,34,87,87,42,42,127,127,30,30,90,90,90,90,35,35,32,32,37,37,14,14,83,83,112,112,10,10,5,5,42,42,69,69,77,77,77,77,19,19,113,113,110,110,48,48,76,76,19,19,82,82,95,95,68,68,43,43,97,97,16,16,89,89,79,79,81,81,117,117,109,109,102,102,73,73,85,85,88,88,77,77,116,116,34,34,89,89,62,62,71,71,117,117,125,125,25,25,54,54,110,110,124,124,112,112,4,4,80,80,81,81,95,95,43,43,48,48,22,22,25,25,56,56,36,36,30,30,89,89,8,8,66,66,104,104,45,45,70,70,118,118,45,45,100,100,122,122,24,24,104,104,3,3,103,103,5,5,50,50,5,5,73,73,88,88,60,60,108,108,59,59,42,42,19,19,52,52,39,39,110,110,41,41,83,83,69,69,33,33,30,30,40,40,104,104,17,17,48,48,75,75,116,116,59,59,18,18,38,38,110,110,29,29,29,29,120,120,103,103,111,111,101,101,106,106,64,64,68,68,34,34,24,24,88,88,7,7,64,64,65,65,32,32,117,117,26,26,45,45,111,111,69,69,1,1,4,4,59,59,80,80,10,10,8,8,19,19,85,85,33,33,22,22,104,104,116,116,83,83,35,35,35,35,92,92,113,113,19,19,65,65,29,29,114,114,30,30,107,107,25,25,44,44,97,97,29,29,40,40,75,75,71,71,85,85,14,14,20,20,110,110,123,123,88,88,95,95,12,12,64,64,14,14,88,88,48,48,122,122,4,4,100,100,109,109,41,41,3,3,64,64,103,103,85,85,76,76,93,93,50,50,43,43,84,84,98,98,20,20,0,0,65,65,102,102,109,109,73,73,52,52,16,16,54,54,99,99,14,14,67,67,101,101,43,43,89,89,19,19,54,54,37,37,86,86,126,126,27,27,35,35,39,39,3,3,28,28,8,8,67,67,106,106,1,1,78,78,49,49,70,70,48,48,31,31,55,55,50,50,25,25,122,122,13,13,60,60,73,73,32,32,10,10,85,85,99,99,14,14,78,78,110,110,121,121,48,48,119,119,64,64,70,70,85,85,3,3,58,58,115,115,5,5,21,21,19,19,101,101,122,122,76,76,78,78,29,29,115,115,111,111,103,103,30,30,80,80,4,4,59,59,29,29,71,71,117,117,116,116,18,18,31,31,97,97,76,76,11,11,14,14,45,45,110,110,14,14,95,95,3,3,69,69,69,69,73,73,68,68,64,64,21,21,21,21,21,21,9,9,122,122,80,80,12,12,57,57,64,64,125,125,65,65,32,32,41,41,13,13,42,42,101,101,125,125,0,0,86,86,11,11,76,76,108,108,64,64,101,101,105,105,96,96,110,110,99,99,71,71,9,9,80,80,49,49,63,63,104,104,50,50,43,43,36,36,25,25,0,0,8,8,69,69,2,2,5,5,29,29,9,9,30,30,89,89,52,52,82,82,86,86,99,99,65,65,77,77,53,53,8,8,83,83,71,71,87,87,25,25,67,67,27,27,87,87,80,80,122,122,110,110,56,56,4,4,20,20,34,34,60,60,36,36,32,32,54,54,105,105,24,24,18,18,104,104,100,100,4,4,75,75,40,40,66,66,59,59,79,79,18,18,50,50,109,109,48,48,54,54,5,5,71,71,99,99,116,116,79,79,59,59,108,108,124,124,110,110,39,39,26,26,56,56,69,69,52,52,52,52,67,67,37,37,45,45,43,43,97,97,111,111,52,52,17,17,95,95,72,72,13,13,22,22,66,66,34,34,27,27,46,46,124,124,114,114,16,16,102,102,1,1,103,103,57,57,97,97,123,123,92,92,87,87,121,121,86,86,45,45,31,31,24,24,76,76,100,100,119,119,3,3,22,22,50,50,99,99,98,98,58,58,13,13,53,53,41,41,64,64,122,122,12,12,36,36,23,23,51,51,48,48,26,26,56,56,123,123,100,100,119,119,109,109,53,53,14,14,101,101,107,107,84,84,25,25,64,64,93,93,23,23,71,71,1,1,66,66,9,9,87,87,104,104,80,80,7,7,22,22,116,116,55,55,18,18,25,25,67,67,111,111,92,92,78,78,8,8,66,66,6,6,2,2,53,53,99,99,24,24,124,124,21,21,117,117,67,67,73,73,126,126,111,111,40,40,96,96,15,15,100,100,112,112,16,16,78,78,15,15,45,45,46,46,67,67,72,72,13,13,49,49,39,39,36,36,101,101,81,81,42,42,84,84,114,114,85,85,27,27,24,24,119,119,46,46,37,37,12,12,28,28,54,54,27,27,114,114,72,72,11,11,51,51,122,122,6,6,11,11,16,16,115,115,115,115,21,21,25,25,51,51,106,106,24,24,106,106,99,99,87,87,29,29,34,34,126,126,70,70,76,76,81,81,114,114,59,59,9,9,34,34,8,8,78,78,49,49,71,71,36,36,62,62,96,96,68,68,81,81,21,21,47,47,42,42,2,2,8,8,76,76,2,2,23,23,0,0,72,72,98,98,106,106,49,49,43,43,64,64,11,11,106,106,97,97,116,116,59,59,44,44,53,53,57,57,48,48,85,85,36,36,15,15,58,58,84,84,1,1,26,26,25,25,12,12,126,126,35,35,35,35,82,82,109,109,37,37,53,53,49,49,82,82,8,8,100,100,54,54,11,11,100,100,16,16,33,33,40,40,25,25,44,44,57,57,26,26,19,19,93,93,66,66,8,8,12,12,51,51,54,54,122,122,56,56,112,112,57,57,72,72,88,88,79,79,120,120,9,9,21,21,95,95,125,125,38,38,16,16,57,57,107,107,109,109,8,8,87,87,101,101,41,41,10,10,104,104,119,119,0,0,80,80,75,75,78,78,35,35,101,101,34,34,121,121,109,109,42,42,109,109,2,2,29,29,30,30,99,99,113,113,52,52,44,44,28,28,125,125,115,115,94,94,44,44,75,75,6,6,115,115,44,44,113,113,72,72,92,92,6,6,111,111,93,93,94,94,1,1,14,14,90,90,78,78,37,37,126,126,21,21,122,122,32,32,48,48,19,19,75,75,109,109,90,90,18,18,3,3,44,44,98,98,103,103,101,101,30,30,91,91,79,79,44,44,42,42,29,29,17,17,36,36,78,78,88,88,48,48,8,8,2,2,98,98,0,0,77,77,56,56,47,47,19,19,96,96,63,63,58,58,127,127,55,55,81,81,18,18,47,47,21,21,70,70,78,78,14,14,2,2,3,3,30,30,106,106,76,76,33,33,19,19,66,66,55,55,102,102,75,75,58,58,7,7,35,35,82,82,77,77,109,109,41,41,12,12,113,113,118,118,1,1,46,46,98,98,56,56,98,98,22,22,89,89,71,71,31,31,16,16,65,65,105,105,20,20,102,102,6,6,108,108,105,105,34,34,20,20,81,81,23,23,42,42,121,121,28,28,123,123,65,65,20,20,20,20,66,66,60,60,1,1,34,34,33,33,36,36,125,125,112,112,72,72,17,17,80,80,108,108,3,3,117,117,50,50,34,34,104,104,115,115,119,119,46,46,74,74,25,25,6,6,88,88,123,123,48,48,3,3,111,111,0,0,68,68,69,69,30,30,113,113,11,11,3,3,34,34,40,40,2,2,80,80,79,79,66,66,42,42,116,116,15,15,56,56,3,3,114,114,26,26,91,91,121,121,97,97,32,32,83,83,19,19,9,9,15,15,112,112,114,114,51,51,88,88,66,66,102,102,64,64,3,3,46,46,71,71,29,29,55,55,40,40,5,5,67,67,120,120,105,105,79,79,11,11,33,33,99,99,93,93,94,94,35,35,53,53,16,16,36,36,53,53,108,108,30,30,68,68,1,1,7,7,35,35,77,77,62,62,120,120,66,66,4,4,48,48,84,84,25,25,89,89,5,5,16,16,87,87,14,14,50,50,50,50,115,115,35,35,9,9,68,68,75,75,125,125,78,78,19,19,80,80,122,122,0,0,71,71,9,9,30,30,12,12,73,73,117,117,48,48,1,1,107,107,19,19,92,92,125,125,62,62,106,106,43,43,101,101,75,75,89,89,85,85,28,28,28,28,54,54,1,1,8,8,20,20,22,22,53,53,73,73,96,96,112,112,126,126,86,86,81,81,67,67,51,51,31,31,69,69,107,107,56,56,81,81,112,112,69,69,3,3,8,8,19,19,69,69,70,70,33,33,87,87,5,5,83,83,11,11,59,59,46,46,56,56,37,37,49,49,98,98,3,3,11,11,39,39,16,16,54,54,84,84,34,34,30,30,2,2,20,20,118,118,40,40,99,99,69,69,123,123,86,86,81,81,34,34,105,105,108,108,114,114,98,98,7,7,19,19,105,105,69,69,48,48,115,115,88,88,123,123,121,121,92,92,56,56,74,74,100,100,112,112,70,70,21,21,74,74,14,14,18,18,73,73,45,45,42,42,74,74,24,24,35,35,84,84,25,25,14,14,113,113,49,49,29,29,113,113,49,49,35,35,20,20,38,38,95,95,32,32,35,35,48,48,51,51,13,13,87,87,55,55,19,19,3,3,50,50,4,4,59,59,35,35,53,53,1,1,48,48,106,106,35,35,15,15,48,48,37,37,47,47,45,45,13,13,46,46,20,20,0,0,15,15,120,120,123,123,89,89,106,106,28,28,123,123,113,113,96,96,5,5,10,10,82,82,44,44,3,3,53,53,77,77,79,79,15,15,5,5,43,43,22,22,120,120,57,57,25,25,11,11,45,45,33,33,79,79,68,68,103,103,97,97,46,46,74,74,52,52,74,74,58,58,22,22,88,88,42,42,124,124,46,46,2,2,24,24,70,70,35,35,57,57,73,73,68,68,121,121,97,97,21,21,3,3,71,71,19,19,87,87,119,119,82,82,111,111,6,6,69,69,62,62,94,94,99,99,74,74,97,97,6,6,33,33,68,68,0,0,115,115,93,93,64,64,35,35,77,77,39,39,94,94,20,20,79,79,15,15,78,78,66,66,56,56,10,10,55,55,1,1,7,7,37,37,56,56,34,34,39,39,36,36,54,54,53,53,62,62,24,24,76,76,113,113,107,107,1,1,34,34,6,6,39,39,87,87,102,102,29,29,61,61,23,23,94,94,52,52,37,37,36,36,71,71,114,114,12,12,4,4,108,108,76,76,20,20,119,119,96,96,17,17,35,35,90,90,64,64,72,72,117,117,118,118,95,95,13,13,60,60,101,101,3,3,39,39,62,62,19,19,60,60,10,10,87,87,12,12,123,123,107,107,11,11,91,91,17,17,99,99,32,32,70,70,73,73,45,45,65,65,7,7,65,65,85,85,55,55,125,125,4,4,120,120,71,71,19,19,92,92,85,85,109,109,36,36,97,97,89,89,50,50,23,23,34,34,85,85,10,10,124,124,69,69,0,0,42,42,33,33,63,63,88,88,98,98,55,55,68,68,64,64,20,20,91,91,99,99,74,74,99,99,0,0,107,107,87,87,30,30,2,2,0,0,71,71,109,109,120,120,99,99,111,111,100,100,64,64,101,101,88,88,64,64,11,11,93,93,10,10,15,15,0,0,13,13,12,12,32,32,101,101,32,32,122,122,106,106,11,11,65,65,11,11,91,91,47,47,37,37,5,5,56,56,98,98,4,4,82,82,94,94,33,33,9,9,1,1,75,75,65,65,15,15,87,87,4,4,100,100,110,110,12,12,34,34,50,50,9,9,92,92,104,104,93,93,115,115,116,116,82,82,30,30,85,85,12,12,10,10,98,98,101,101,28,28,35,35,27,27,88,88,40,40,107,107,52,52,2,2,96,96,120,120,0,0,8,8,97,97,22,22,86,86,105,105,118,118,53,53,66,66,55,55,42,42,93,93,66,66,46,46,76,76,56,56,80,80,22,22,61,61,46,46,99,99,36,36,3,3,40,40,5,5,16,16,0,0,23,23,97,97,108,108,64,64,98,98,101,101,116,116,84,84,99,99,53,53,51,51,25,25,97,97,57,57,112,112,95,95,32,32,80,80,18,18,86,86,47,47,22,22,22,22,71,71,12,12,85,85,100,100,12,12,96,96,28,28,4,4,18,18,82,82,36,36,38,38,45,45,42,42,34,34,125,125,112,112,61,61,71,71,6,6,122,122,67,67,13,13,75,75,24,24,23,23,21,21,16,16,8,8,69,69,97,97,7,7,126,126,106,106,1,1,32,32,70,70,74,74,77,77,56,56,60,60,90,90,39,39,48,48,30,30,15,15,38,38,44,44,102,102,11,11,72,72,21,21,36,36,26,26,101,101,108,108,58,58,59,59,95,95,79,79,74,74,97,97,3,3,106,106,127,127,26,26,54,54,63,63,36,36,49,49,64,64,86,86,32,32,98,98,73,73,91,91,34,34,74,74,42,42,4,4,70,70,68,68,88,88,41,41,37,37,52,52,28,28,15,15,65,65,116,116,6,6,124,124,15,15,118,118,88,88,71,71,120,120,21,21,18,18,76,76,76,76,17,17,83,83,5,5,69,69,82,82,127,127,112,112,77,77,46,46,27,27,62,62,124,124,12,12,73,73,1,1,55,55,42,42,11,11,91,91,0,0,2,2,52,52,71,71,87,87,30,30,98,98,94,94,93,93,123,123,73,73,98,98,23,23,1,1,91,91,111,111,61,61,90,90,83,83,11,11,103,103,88,88,78,78,80,80,4,4,114,114,58,58,122,122,24,24,5,5,109,109,102,102,70,70,42,42,69,69,3,3,65,65,120,120,0,0,84,84,72,72,4,4,84,84,105,105,69,69,10,10,48,48,68,68,108,108,75,75,112,112,62,62,38,38,68,68,56,56,16,16,100,100,50,50,18,18,8,8,76,76,1,1,20,20,78,78,3,3,110,110,4,4,10,10,109,109,1,1,23,23,71,71,55,55,19,19,107,107,26,26,104,104,115,115,50,50,94,94,5,5,70,70,29,29,9,9,65,65,7,7,31,31,78,78,50,50,49,49,45,45,56,56,60,60,72,72,60,60,125,125,10,10,60,60,26,26,89,89,65,65,27,27,82,82,104,104,32,32,85,85,8,8,23,23,109,109,18,18,6,6,39,39,80,80,23,23,80,80,13,13,71,71,11,11,47,47,76,76,83,83,55,55,42,42,81,81,112,112,41,41,61,61,42,42,23,23,30,30,92,92,15,15,107,107,100,100,35,35,91,91,88,88,119,119,5,5,53,53,72,72,91,91,62,62,82,82,69,69,127,127,92,92,18,18,98,98,0,0,112,112,31,31,43,43,101,101,8,8,102,102,77,77,108,108,39,39,23,23,107,107,122,122,37,37,9,9,118,118,108,108,115,115,54,54,20,20,86,86,64,64,4,4,83,83,10,10,22,22,36,36,81,81,57,57,32,32,51,51,2,2,23,23,96,96,14,14,58,58,71,71,109,109,109,109,95,95,69,69,82,82,103,103,76,76,79,79,14,14,86,86,117,117,21,21,16,16,107,107,114,114,91,91,115,115,68,68,101,101,111,111,62,62,73,73,8,8,25,25,125,125,9,9,32,32,68,68,96,96,47,47,23,23,28,28,66,66,97,97,24,24,72,72,10,10,75,75,25,25,88,88,9,9,118,118,19,19,105,105,55,55,28,28,0,0,106,106,50,50,98,98,84,84,63,63,2,2,49,49,6,6,68,68,7,7,115,115,9,9,66,66,54,54,13,13,29,29,31,31,5,5,118,118,33,33,73,73,78,78,108,108,77,77,11,11,46,46,74,74,4,4,45,45,67,67,102,102,108,108,18,18,1,1,100,100,62,62,47,47,64,64,91,91,59,59,42,42,99,99,124,124,123,123,65,65,109,109,64,64,89,89,6,6,46,46,107,107,71,71,116,116,30,30,126,126,32,32,104,104,16,16,56,56,48,48,126,126,119,119,119,119,11,11,119,119,83,83,47,47,91,91,16,16,107,107,82,82,10,10,78,78,2,2,112,112,101,101,8,8,90,90,80,80,48,48,18,18,67,67,126,126,39,39,61,61,21,21,12,12,116,116,18,18,119,119,4,4,42,42,27,27,40,40,9,9,43,43,121,121,114,114,51,51,2,2,10,10,19,19,53,53,126,126,121,121,55,55,121,121,80,80,20,20,25,25,116,116,16,16,107,107,34,34,72,72,28,28,44,44,75,75,0,0,127,127,19,19,120,120,77,77,6,6,96,96,91,91,69,69,39,39,117,117,20,20,3,3,98,98,37,37,90,90,56,56,75,75,45,45,90,90,6,6,38,38,48,48,40,40,55,55,93,93,1,1,12,12,25,25,108,108,127,127,15,15,127,127,90,90,4,4,80,80,18,18,37,37,89,89,100,100,101,101,95,95,38,38,92,92,83,83,118,118,56,56,115,115,110,110,55,55,124,124,107,107,91,91,97,97,36,36,69,69,18,18,8,8,70,70,82,82,59,59,95,95,123,123,9,9,58,58,77,77,7,7,44,44,58,58,33,33,80,80,4,4,112,112,72,72,110,110,43,43,57,57,1,1,60,60,6,6,6,6,22,22,43,43,70,70,43,43,6,6,38,38,39,39,113,113,70,70,21,21,12,12,112,112,12,12,16,16,38,38,37,37,108,108,95,95,72,72,118,118,96,96,1,1,31,31,30,30,121,121,35,35,58,58,41,41,11,11,9,9,109,109,42,42,100,100,33,33,21,21,81,81,60,60,7,7,15,15,47,47,78,78,38,38,66,66,64,64,26,26,120,120,8,8,120,120,98,98,48,48,69,69,119,119,87,87,47,47,57,57,101,101,87,87,20,20,29,29,106,106,69,69,98,98,5,5,48,48,48,48,16,16,111,111,81,81,25,25,111,111,65,65,52,52,66,66,48,48,109,109,29,29,82,82,82,82,25,25,99,99,17,17,34,34,50,50,122,122,27,27,68,68,17,17,94,94,43,43,102,102,87,87,45,45,95,95,81,81,22,22,16,16,75,75,73,73,4,4,42,42,102,102,32,32,112,112,126,126,126,126,64,64,125,125,19,19,35,35,44,44,48,48,110,110,122,122,67,67,99,99,92,92,126,126,75,75,33,33,82,82,103,103,112,112,98,98,74,74,126,126,103,103,102,102,54,54,96,96,109,109,5,5,15,15,115,115,100,100,76,76,35,35,53,53,45,45,18,18,61,61,81,81,96,96,14,14,85,85,118,118,53,53,36,36,79,79,65,65,31,31,12,12,20,20,92,92,26,26,9,9,32,32,64,64,113,113,70,70,17,17,16,16,113,113,80,80,115,115,109,109,67,67,116,116,70,70,57,57,77,77,63,63,81,81,122,122,31,31,70,70,125,125,27,27,101,101,76,76,23,23,39,39,57,57,115,115,25,25,84,84,85,85,45,45,58,58,42,42,55,55,111,111,67,67,36,36,119,119,59,59,118,118,70,70,76,76,28,28,69,69,54,54,90,90,71,71,41,41,94,94,64,64,28,28,2,2,66,66,27,27,49,49,87,87,55,55,38,38,12,12,25,25,0,0,78,78,23,23,101,101,50,50,50,50,105,105,1,1,126,126,72,72,24,24,18,18,5,5,27,27,8,8,3,3,114,114,83,83,82,82,10,10,10,10,5,5,54,54,0,0,44,44,4,4,107,107,105,105,8,8,117,117,63,63,68,68,86,86,106,106,80,80,74,74,110,110,64,64,54,54,13,13,72,72,68,68,76,76,120,120,112,112,42,42,6,6,123,123,106,106,52,52,62,62,52,52,90,90,37,37,8,8,106,106,94,94,31,31,71,71,37,37,55,55,48,48,28,28,65,65,7,7,33,33,50,50,5,5,26,26,37,37,65,65,27,27,76,76,95,95,89,89,29,29,106,106,9,9,38,38,42,42,54,54,13,13,79,79,75,75,9,9,82,82,0,0,68,68,86,86,76,76,110,110,84,84,35,35,114,114,50,50,106,106,42,42,2,2,89,89,40,40,89,89,80,80,78,78,97,97,101,101,5,5,54,54,42,42,72,72,16,16,54,54,2,2,75,75,3,3,4,4,100,100,11,11,84,84,77,77,8,8,26,26,96,96,102,102,58,58,66,66,81,81,67,67,48,48,124,124,124,124,16,16,76,76,86,86,49,49,72,72,4,4,6,6,108,108,118,118,81,81,22,22,48,48,39,39,47,47,86,86,28,28,102,102,69,69,12,12,35,35,27,27,125,125,124,124,28,28,99,99,37,37,117,117,69,69,124,124,77,77,125,125,6,6,79,79,123,123,20,20,98,98,55,55,28,28,97,97,56,56,64,64,88,88,94,94,25,25,45,45,57,57,79,79,3,3,97,97,16,16,60,60,48,48,119,119,61,61,76,76,23,23,81,81,46,46,39,39,75,75,26,26,39,39,36,36,51,51,99,99,93,93,124,124,116,116,89,89,13,13,125,125,39,39,24,24,44,44,70,70,53,53,96,96,117,117,57,57,27,27,97,97,56,56,5,5,102,102,127,127,42,42,93,93,87,87,77,77,118,118,14,14,40,40,23,23,109,109,77,77,13,13,87,87,10,10,73,73,21,21,39,39,54,54,3,3,110,110,50,50,53,53,1,1,64,64,43,43,18,18,70,70,2,2,41,41,42,42,115,115,53,53,57,57,67,67,40,40,32,32,97,97,36,36,72,72,5,5,97,97,32,32,29,29,13,13,12,12,12,12,9,9,84,84,85,85,95,95,74,74,40,40,101,101,105,105,115,115,17,17,83,83,3,3,36,36,42,42,45,45,100,100,71,71,4,4,55,55,101,101,35,35,86,86,31,31,51,51,115,115,26,26,113,113,71,71,42,42,48,48,119,119,48,48,62,62,21,21,73,73,70,70,96,96,87,87,68,68,9,9,14,14,101,101,17,17,86,86,78,78,84,84,36,36,125,125,64,64,3,3,81,81,44,44,95,95,39,39,96,96,96,96,82,82,52,52,38,38,9,9,49,49,26,26,39,39,36,36,90,90,79,79,110,110,80,80,80,80,13,13,125,125,72,72,86,86,101,101,94,94,7,7,125,125,119,119,16,16,44,44,85,85,36,36,15,15,72,72,10,10,90,90,15,15,2,2,78,78,112,112,58,58,15,15,62,62,67,67,56,56,65,65,71,71,98,98,4,4,66,66,95,95,63,63,71,71,106,106,120,120,122,122,22,22,103,103,35,35,32,32,48,48,76,76,117,117,19,19,108,108,46,46,54,54,65,65,121,121,88,88,12,12,104,104,90,90,89,89,68,68,48,48,116,116,71,71,66,66,45,45,15,15,72,72,26,26,40,40,117,117,72,72,4,4,29,29,119,119,43,43,8,8,90,90,44,44,97,97,109,109,84,84,85,85,29,29,80,80,104,104,102,102,100,100,68,68,110,110,67,67,41,41,6,6,49,49,52,52,26,26,31,31,34,34,74,74,73,73,45,45,110,110,4,4,81,81,38,38,62,62,104,104,104,104,60,60,126,126,101,101,69,69,82,82,8,8,90,90,42,42,42,42,17,17,1,1,35,35,124,124,97,97,103,103,101,101,9,9,100,100,96,96,110,110,7,7,39,39,117,117,100,100,21,21,5,5,80,80,36,36,49,49,78,78,15,15,123,123,46,46,24,24,125,125,14,14,17,17,94,94,50,50,77,77,108,108,69,69,104,104,54,54,118,118,85,85,84,84,125,125,30,30,38,38,36,36,100,100,76,76,101,101,38,38,98,98,71,71,32,32,44,44,61,61,64,64,56,56,2,2,8,8,42,42,46,46,127,127,97,97,9,9,95,95,40,40,73,73,79,79,98,98,82,82,107,107,81,81,80,80,15,15,8,8,2,2,30,30,83,83,13,13,45,45,44,44,57,57,56,56,94,94,93,93,114,114,126,126,40,40,56,56,53,53,9,9,63,63,119,119,43,43,33,33,36,36,61,61,109,109,98,98,127,127,18,18,99,99,72,72,36,36,113,113,58,58,87,87,75,75,84,84,60,60,82,82,24,24,105,105,115,115,76,76,62,62,85,85,2,2,94,94,2,2,105,105,65,65,101,101,24,24,38,38,7,7,92,92,68,68,41,41,52,52,28,28,48,48,86,86,56,56,63,63,11,11,28,28,86,86,108,108,22,22,55,55,90,90,58,58,115,115,49,49,73,73,71,71,74,74,111,111,126,126,79,79,4,4,12,12,12,12,59,59,126,126,98,98,45,45,83,83,62,62,98,98,71,71,12,12,24,24,61,61,8,8,5,5,123,123,3,3,7,7,114,114,65,65,1,1,4,4,1,1,0,0,41,41,92,92,43,43,83,83,68,68,73,73,101,101,65,65,98,98,118,118,33,33,39,39,104,104,3,3,110,110,67,67,85,85,13,13,32,32,45,45,67,67,104,104,6,6,16,16,48,48,39,39,94,94,5,5,85,85,104,104,126,126,36,36,88,88,1,1,72,72,11,11,97,97,45,45,19,19,28,28,75,75,70,70,22,22,97,97,56,56,49,49,96,96,39,39,63,63,102,102,101,101,71,71,13,13,34,34,60,60,71,71,20,20,97,97,12,12,20,20,16,16,56,56,87,87,98,98,90,90,86,86,112,112,30,30,9,9,61,61,14,14,109,109,90,90,77,77,11,11,16,16,25,25,3,3,48,48,121,121,81,81,36,36,16,16,50,50,9,9,92,92,20,20,74,74,27,27,74,74,127,127,117,117,82,82,76,76,16,16,38,38,117,117,70,70,80,80,25,25,69,69,11,11,10,10,48,48,101,101,20,20,7,7,32,32,118,118,10,10,46,46,116,116,42,42,35,35,27,27,57,57,5,5,21,21,4,4,112,112,3,3,122,122,73,73,14,14,15,15,35,35,90,90,6,6,84,84,44,44,10,10,48,48,95,95,48,48,29,29,103,103,122,122,106,106,29,29,89,89,88,88,19,19,86,86,81,81,33,33,47,47,10,10,101,101,9,9,114,114,119,119,15,15,29,29,47,47,103,103,12,12,50,50,65,65,84,84,70,70,101,101,106,106,110,110,110,110,37,37,74,74,6,6,79,79,49,49,125,125,44,44,29,29,76,76,10,10,75,75,101,101,64,64,24,24,7,7,87,87,43,43,42,42,14,14,53,53,94,94,60,60,75,75,18,18,22,22,28,28,19,19,40,40,61,61,92,92,114,114,58,58,59,59,62,62,46,46,13,13,78,78,18,18,68,68,64,64,109,109,67,67,30,30,112,112,27,27,10,10,11,11,86,86,93,93,47,47,67,67,2,2,124,124,73,73,105,105,9,9,97,97,62,62,63,63,22,22,122,122,36,36,62,62,113,113,87,87,48,48,96,96,104,104,90,90,31,31,120,120,124,124,83,83,39,39,75,75,68,68,30,30,54,54,113,113,77,77,24,24,48,48,16,16,72,72,52,52,4,4,117,117,34,34,100,100,61,61,27,27,59,59,20,20,83,83,122,122,3,3,45,45,84,84,118,118,38,38,2,2,67,67,18,18,43,43,117,117,0,0,121,121,114,114,20,20,83,83,5,5,40,40,98,98,42,42,84,84,104,104,115,115,95,95,79,79,119,119,2,2,0,0,95,95,5,5,74,74,35,35,76,76,65,65,3,3,72,72,96,96,44,44,62,62,67,67,16,16,66,66,70,70,30,30,66,66,60,60,38,38,7,7,43,43,28,28,46,46,2,2,99,99,82,82,71,71,111,111,69,69,85,85,72,72,40,40,106,106,64,64,71,71,100,100,48,48,60,60,36,36,96,96,108,108,86,86,102,102,98,98,99,99,44,44,20,20,93,93,10,10,48,48,50,50,43,43,15,15,96,96,32,32,28,28,4,4,48,48,41,41,81,81,49,49,68,68,62,62,63,63,7,7,49,49,125,125,44,44,67,67,69,69,80,80,69,69,94,94,82,82,11,11,104,104,39,39,38,38,51,51,9,9,113,113,30,30,45,45,125,125,50,50,1,1,65,65,41,41,38,38,70,70,119,119,69,69,13,13,103,103,57,57,87,87,58,58,83,83,50,50,99,99,41,41,85,85,98,98,107,107,62,62,21,21,50,50,124,124,115,115,7,7,94,94,38,38,83,83,109,109,18,18,77,77,43,43,99,99,24,24,84,84,70,70,47,47,32,32,47,47,13,13,25,25,9,9,84,84,55,55,79,79,70,70,92,92,62,62,32,32,54,54,7,7,70,70,127,127,44,44,93,93,118,118,119,119,69,69,61,61,97,97,57,57,69,69,95,95,52,52,18,18,18,18,83,83,24,24,24,24,88,88,55,55,77,77,99,99,33,33,116,116,23,23,110,110,59,59,14,14,55,55,95,95,118,118,61,61,65,65,59,59,118,118,58,58,108,108,82,82,107,107,18,18,55,55,52,52,95,95,32,32,6,6,114,114,78,78,54,54,101,101,99,99,108,108,73,73,127,127,102,102,48,48,13,13,91,91,7,7,125,125,65,65,87,87,54,54,103,103,36,36,29,29,54,54,109,109,109,109,80,80,107,107,112,112,43,43,12,12,77,77,100,100,115,115,91,91,14,14,52,52,95,95,40,40,32,32,74,74,92,92,87,87,20,20,17,17,103,103,84,84,104,104,82,82,2,2,27,27,69,69,66,66,125,125,30,30,23,23,38,38,76,76,18,18,85,85,93,93,80,80,77,77,30,30,48,48,76,76,12,12,39,39,19,19,113,113,126,126,120,120,28,28,3,3,40,40,41,41,86,86,117,117,78,78,104,104,11,11,14,14,30,30,38,38,44,44,7,7,69,69,38,38,39,39,2,2,12,12,52,52,81,81,7,7,82,82,64,64,11,11,5,5,84,84,25,25,36,36,90,90,107,107,71,71,82,82,66,66,25,25,26,26,84,84,116,116,76,76,14,14,83,83,101,101,43,43,54,54,85,85,74,74,52,52,52,52,63,63,40,40,60,60,27,27,25,25,11,11,43,43,112,112,89,89,112,112,127,127,106,106,66,66,78,78,101,101,39,39,28,28,13,13,105,105,15,15,21,21,99,99,103,103,74,74,20,20,94,94,33,33,126,126,49,49,11,11,119,119,91,91,106,106,68,68,26,26,111,111,82,82,41,41,38,38,65,65,122,122,107,107,82,82,1,1,13,13,81,81,64,64,78,78,80,80,79,79,89,89,102,102,76,76,1,1,20,20,103,103,10,10,33,33,27,27,109,109,30,30,0,0,20,20,122,122,96,96,1,1,77,77,65,65,36,36,80,80,26,26,127,127,16,16,99,99,2,2,31,31,12,12,124,124,117,117,38,38,83,83,39,39,66,66,18,18,45,45,12,12,90,90,3,3,77,77,22,22,110,110,83,83,65,65,23,23,98,98,73,73,13,13,68,68,40,40,124,124,85,85,13,13,67,67,67,67,34,34,45,45,74,74,68,68,73,73,49,49,117,117,65,65,67,67,57,57,28,28,103,103,81,81,111,111,110,110,71,71,24,24,116,116,75,75,42,42,18,18,3,3,108,108,27,27,22,22,14,14,97,97,17,17,16,16,31,31,37,37,76,76,74,74,35,35,36,36,34,34,61,61,40,40,45,45,2,2,12,12,27,27,37,37,83,83,5,5,61,61,109,109,84,84,95,95,86,86,104,104,40,40,84,84,70,70,51,51,21,21,55,55,25,25,57,57,25,25,97,97,36,36,46,46,6,6,84,84,108,108,26,26,120,120,25,25,34,34,83,83,99,99,70,70,113,113,116,116,11,11,55,55,86,86,66,66,105,105,69,69,14,14,45,45,21,21,110,110,99,99,70,70,124,124,124,124,117,117,79,79,17,17,77,77,3,3,98,98,24,24,6,6,1,1,90,90,52,52,31,31,82,82,6,6,35,35,36,36,41,41,30,30,30,30,35,35,40,40,101,101,16,16,3,3,23,23,8,8,88,88,15,15,100,100,125,125,93,93,95,95,34,34,118,118,4,4,29,29,104,104,1,1,84,84,125,125,60,60,104,104,102,102,63,63,17,17,51,51,16,16,124,124,29,29,20,20,54,54,71,71,121,121,111,111,42,42,13,13,18,18,102,102,102,102,119,119,95,95,106,106,70,70,2,2,116,116,13,13,18,18,8,8,65,65,33,33,95,95,31,31,64,64,100,100,83,83,26,26,18,18,97,97,36,36,65,65,64,64,109,109,69,69,75,75,81,81,44,44,11,11,2,2,4,4,104,104,1,1,83,83,15,15,60,60,10,10,98,98,33,33,30,30,26,26,116,116,93,93,59,59,7,7,68,68,12,12,6,6,6,6,82,82,22,22,16,16,84,84,43,43,44,44,110,110,24,24,35,35,83,83,116,116,73,73,91,91,21,21,25,25,92,92,78,78,119,119,123,123,95,95,30,30,55,55,98,98,74,74,54,54,88,88,47,47,85,85,17,17,112,112,22,22,32,32,89,89,108,108,126,126,72,72,12,12,43,43,25,25,80,80,88,88,86,86,120,120,55,55,56,56,58,58,76,76,70,70,34,34,74,74,16,16,52,52,88,88,38,38,13,13,74,74,11,11,28,28,54,54,99,99,68,68,93,93,82,82,92,92,46,46,9,9,74,74,74,74,20,20,57,57,11,11,4,4,82,82,70,70,28,28,35,35,54,54,83,83,66,66,117,117,6,6,5,5,9,9,53,53,8,8,51,51,2,2,124,124,0,0,37,37,100,100,70,70,6,6,28,28,103,103,54,54,84,84,61,61,52,52,92,92,12,12,52,52,81,81,84,84,66,66,26,26,14,14,85,85,118,118,83,83,125,125,113,113,59,59,103,103,67,67,26,26,72,72,24,24,105,105,45,45,120,120,54,54,125,125,23,23,64,64,122,122,105,105,112,112,70,70,111,111,79,79,122,122,4,4,21,21,38,38,86,86,5,5,12,12,37,37,51,51,67,67,125,125,15,15,0,0,75,75,96,96,22,22,79,79,61,61,113,113,106,106,122,122,62,62,0,0,3,3,91,91,85,85,1,1,114,114,4,4,80,80,26,26,80,80,55,55,24,24,35,35,9,9,62,62,48,48,16,16,97,97,24,24,23,23,99,99,99,99,89,89,49,49,63,63,12,12,61,61,48,48,51,51,79,79,49,49,23,23,24,24,86,86,22,22,70,70,8,8,83,83,20,20,53,53,82,82,88,88,75,75,124,124,32,32,23,23,2,2,82,82,73,73,88,88,30,30,73,73,33,33,43,43,60,60,90,90,58,58,15,15,38,38,88,88,25,25,68,68,32,32,81,81,108,108,112,112,52,52,48,48,24,24,96,96,122,122,26,26,3,3,53,53,70,70,101,101,88,88,37,37,6,6,96,96,23,23,14,14,43,43,102,102,63,63,96,96,51,51,100,100,46,46,1,1,18,18,46,46,125,125,83,83,59,59,91,91,46,46,126,126,73,73,95,95,69,69,94,94,64,64,10,10,37,37,110,110,74,74,50,50,75,75,16,16,90,90,116,116,7,7,112,112,14,14,54,54,28,28,91,91,63,63,72,72,112,112,95,95,113,113,5,5,71,71,11,11,112,112,3,3,70,70,86,86,27,27,125,125,113,113,74,74,69,69,13,13,69,69,8,8,92,92,3,3,9,9,48,48,51,51,91,91,43,43,83,83,1,1,91,91,39,39,65,65,5,5,42,42,88,88,24,24,23,23,91,91,60,60,73,73,88,88,46,46,111,111,24,24,68,68,104,104,9,9,43,43,41,41,21,21,71,71,77,77,2,2,90,90,87,87,108,108,83,83,5,5,40,40,122,122,95,95,4,4,76,76,26,26,59,59,36,36,92,92,62,62,105,105,123,123,90,90,75,75,42,42,26,26,16,16,83,83,70,70,53,53,36,36,125,125,15,15,0,0,18,18,29,29,96,96,16,16,81,81,95,95,27,27,76,76,38,38,8,8,32,32,121,121,101,101,41,41,17,17,0,0,70,70,16,16,108,108,126,126,27,27,65,65,112,112,84,84,12,12,9,9,3,3,98,98,36,36,70,70,98,98,43,43,114,114,64,64,3,3,116,116,47,47,29,29,21,21,10,10,37,37,36,36,121,121,81,81,126,126,34,34,7,7,88,88,98,98,7,7,89,89,45,45,5,5,40,40,9,9,82,82,117,117,28,28,73,73,95,95,70,70,122,122,103,103,32,32,125,125,89,89,108,108,1,1,17,17,24,24,70,70,69,69,103,103,112,112,100,100,121,121,32,32,119,119,31,31,11,11,29,29,56,56,22,22,36,36,121,121,30,30,60,60,43,43,58,58,31,31,31,31,6,6,16,16,10,10,56,56,16,16,53,53,27,27,31,31,37,37,113,113,58,58,32,32,108,108,26,26,99,99,66,66,46,46,113,113,109,109,114,114,118,118,60,60,84,84,1,1,114,114,58,58,18,18,83,83,104,104,2,2,38,38,43,43,95,95,55,55,26,26,77,77,17,17,63,63,25,25,125,125,24,24,71,71,126,126,64,64,38,38,39,39,107,107,17,17,98,98,57,57,89,89,73,73,46,46,49,49,46,46,8,8,56,56,66,66,1,1,71,71,90,90,64,64,97,97,47,47,63,63,77,77,28,28,12,12,52,52,88,88,74,74,103,103,13,13,8,8,42,42,73,73,53,53,50,50,16,16,19,19,51,51,55,55,70,70,81,81,74,74,90,90,1,1,37,37,70,70,38,38,27,27,30,30,122,122,104,104,78,78,108,108,82,82,15,15,18,18,38,38,114,114,68,68,86,86,43,43,27,27,21,21,45,45,81,81,17,17,69,69,84,84,127,127,69,69,69,69,14,14,29,29,85,85,36,36,87,87,98,98,41,41,86,86,10,10,73,73,3,3,66,66,74,74,72,72,40,40,53,53,10,10,13,13,18,18,74,74,58,58,18,18,2,2,120,120,0,0,98,98,6,6,117,117,80,80,41,41,102,102,21,21,109,109,25,25,108,108,97,97,111,111,37,37,113,113,52,52,39,39,120,120,62,62,109,109,55,55,93,93,51,51,36,36,111,111,94,94,25,25,102,102,14,14,72,72,0,0,96,96,69,69,97,97,31,31,23,23,59,59,111,111,21,21,115,115,86,86,70,70,43,43,8,8,68,68,73,73,41,41,104,104,29,29,17,17,70,70,84,84,73,73,89,89,45,45,85,85,43,43,98,98,91,91,97,97,55,55,39,39,30,30,81,81,95,95,5,5,89,89,31,31,61,61,3,3,24,24,67,67,116,116,88,88,90,90,33,33,105,105,14,14,83,83,97,97,38,38,58,58,14,14,9,9,18,18,51,51,55,55,3,3,52,52,92,92,88,88,33,33,44,44,39,39,50,50,24,24,3,3,1,1,40,40,63,63,85,85,84,84,1,1,31,31,127,127,88,88,84,84,9,9,75,75,20,20,55,55,87,87,81,81,44,44,112,112,23,23,99,99,113,113,84,84,17,17,13,13,3,3,13,13,24,24,6,6,117,117,65,65,87,87,78,78,79,79,120,120,51,51,12,12,56,56,52,52,14,14,65,65,108,108,93,93,40,40,69,69,108,108,33,33,13,13,37,37,85,85,109,109,102,102,63,63,21,21,26,26,125,125,7,7,52,52,45,45,11,11,118,118,78,78,114,114,84,84,115,115,11,11,125,125,30,30,30,30,120,120,54,54,21,21,83,83,23,23,16,16,112,112,62,62,62,62,60,60,18,18,76,76,99,99,29,29,2,2,28,28,0,0,15,15,21,21,0,0,60,60,2,2,59,59,119,119,2,2,110,110,83,83,6,6,9,9,124,124,95,95,10,10,94,94,17,17,60,60,41,41,26,26,68,68,114,114,47,47,107,107,26,26,71,71,25,25,90,90,87,87,25,25,5,5,115,115,115,115,66,66,70,70,34,34,1,1,78,78,66,66,3,3,16,16,36,36,30,30,96,96,19,19,105,105,37,37,61,61,89,89,4,4,122,122,88,88,28,28,7,7,12,12,69,69,36,36,11,11,90,90,36,36,43,43,25,25,36,36,100,100,32,32,71,71,44,44,112,112,117,117,81,81,66,66,65,65,81,81,70,70,36,36,65,65,43,43,69,69,99,99,93,93,73,73,48,48,114,114,85,85,92,92,110,110,35,35,32,32,48,48,22,22,30,30,74,74,107,107,126,126,42,42,65,65,43,43,55,55,32,32,38,38,89,89,82,82,97,97,17,17,29,29,116,116,19,19,51,51,33,33,15,15,93,93,27,27,124,124,23,23,9,9,47,47,68,68,47,47,78,78,82,82,91,91,1,1,94,94,48,48,47,47,2,2,51,51,25,25,25,25,1,1,92,92,28,28,70,70,40,40,13,13,97,97,42,42,93,93,73,73,24,24,18,18,30,30,11,11,123,123,50,50,44,44,7,7,108,108,110,110,27,27,86,86,85,85,3,3,30,30,118,118,115,115,25,25,89,89,120,120,116,116,13,13,107,107,72,72,47,47,81,81,23,23,99,99,31,31,0,0,95,95,57,57,35,35,16,16,8,8,0,0,83,83,109,109,85,85,123,123,43,43,52,52,84,84,41,41,76,76,36,36,26,26,70,70,109,109,96,96,85,85,39,39,98,98,68,68,99,99,51,51,2,2,102,102,85,85,49,49,115,115,8,8,88,88,54,54,104,104,39,39,1,1,69,69,8,8,40,40,65,65,126,126,52,52,112,112,29,29,20,20,37,37,111,111,54,54,58,58,27,27,47,47,40,40,14,14,24,24,19,19,117,117,9,9,46,46,28,28,17,17,115,115,49,49,124,124,40,40,104,104,8,8,122,122,116,116,4,4,54,54,9,9,22,22,83,83,10,10,12,12,83,83,34,34,96,96,64,64,67,67,114,114,11,11,7,7,18,18,41,41,10,10,2,2,96,96,11,11,55,55,79,79,69,69,7,7,60,60,98,98,12,12,56,56,49,49,106,106,120,120,110,110,119,119,16,16,108,108,93,93,118,118,30,30,82,82,113,113,52,52,110,110,68,68,88,88,65,65,43,43,83,83,66,66,27,27,72,72,70,70,105,105,77,77,54,54,3,3,105,105,107,107,103,103,85,85,49,49,97,97,121,121,26,26,40,40,103,103,38,38,54,54,82,82,89,89,80,80,15,15,59,59,121,121,24,24,46,46,19,19,74,74,33,33,25,25,20,20,105,105,79,79,25,25,57,57,102,102,83,83,58,58,98,98,85,85,108,108,103,103,36,36,15,15,12,12,90,90,5,5,24,24,96,96,41,41,26,26,91,91,42,42,6,6,38,38,15,15,5,5,54,54,19,19,62,62,41,41,93,93,57,57,53,53,89,89,49,49,71,71,5,5,71,71,31,31,80,80,13,13,93,93,117,117,10,10,127,127,110,110,89,89,68,68,105,105,27,27,46,46,62,62,123,123,59,59,84,84,81,81,39,39,98,98,51,51,74,74,81,81,66,66,82,82,58,58,112,112,75,75,100,100,61,61,27,27,15,15,68,68,73,73,120,120,44,44,6,6,90,90,84,84,65,65,93,93,37,37,65,65,81,81,74,74,112,112,120,120,8,8,121,121,60,60,72,72,41,41,86,86,17,17,57,57,20,20,10,10,80,80,99,99,5,5,26,26,98,98,25,25,41,41,4,4,55,55,39,39,49,49,29,29,44,44,10,10,14,14,71,71,1,1,37,37,69,69,89,89,96,96,64,64,121,121,78,78,30,30,102,102,116,116,56,56,50,50,26,26,55,55,102,102,5,5,50,50,27,27,66,66,1,1,67,67,79,79,39,39,99,99,20,20,76,76,65,65,13,13,56,56,23,23,101,101,1,1,77,77,10,10,11,11,102,102,86,86,3,3,23,23,90,90,10,10,122,122,87,87,17,17,2,2,21,21,107,107,92,92,7,7,59,59,93,93,15,15,73,73,63,63,107,107,81,81,5,5,29,29,72,72,100,100,88,88,42,42,38,38,24,24,39,39,3,3,6,6,51,51,25,25,88,88,98,98,46,46,45,45,70,70,121,121,90,90,43,43,121,121,121,121,50,50,64,64,121,121,66,66,12,12,98,98,11,11,70,70,19,19,4,4,90,90,91,91,116,116,14,14,32,32,27,27,119,119,79,79,22,22,90,90,109,109,30,30,70,70,12,12,127,127,66,66,101,101,104,104,21,21,34,34,12,12,89,89,25,25,13,13,41,41,63,63,18,18,112,112,28,28,27,27,18,18,7,7,48,48,99,99,19,19,60,60,64,64,36,36,110,110,2,2,105,105,17,17,114,114,16,16,22,22,81,81,9,9,91,91,105,105,104,104,67,67,13,13,76,76,57,57,124,124,52,52,102,102,58,58,25,25,8,8,29,29,103,103,76,76,36,36,2,2,74,74,61,61,50,50,39,39,25,25,7,7,20,20,92,92,8,8,8,8,41,41,96,96,89,89,111,111,61,61,1,1,61,61,91,91,88,88,4,4,66,66,119,119,92,92,88,88,5,5,70,70,83,83,55,55,125,125,83,83,29,29,11,11,52,52,65,65,93,93,37,37,71,71,96,96,34,34,109,109,95,95,6,6,112,112,83,83,43,43,32,32,26,26,4,4,40,40,51,51,41,41,126,126,23,23,34,34,99,99,105,105,93,93,7,7,127,127,119,119,91,91,74,74,74,74,98,98,17,17,70,70,5,5,104,104,26,26,14,14,17,17,44,44,104,104,11,11,1,1,52,52,2,2,14,14,35,35,5,5,60,60,86,86,106,106,48,48,104,104,60,60,68,68,64,64,35,35,104,104,39,39,109,109,108,108,86,86,90,90,41,41,101,101,57,57,32,32,81,81,111,111,56,56,56,56,108,108,2,2,64,64,29,29,0,0,44,44,117,117,18,18,103,103,43,43,70,70,17,17,79,79,106,106,102,102,24,24,90,90,97,97,9,9,41,41,121,121,69,69,66,66,51,51,56,56,7,7,51,51,4,4,97,97,77,77,27,27,103,103,40,40,8,8,43,43,123,123,92,92,43,43,92,92,123,123,86,86,74,74,14,14,21,21,114,114,11,11,6,6,97,97,44,44,32,32,28,28,99,99,125,125,7,7,56,56,84,84,59,59,35,35,9,9,50,50,69,69,42,42,109,109,26,26,52,52,7,7,104,104,85,85,64,64,44,44,40,40,3,3,85,85,6,6,2,2,81,81,40,40,90,90,17,17,98,98,85,85,56,56,65,65,35,35,34,34,71,71,94,94,8,8,96,96,32,32,67,67,0,0,93,93,98,98,113,113,1,1,20,20,85,85,116,116,125,125,12,12,87,87,86,86,95,95,41,41,74,74,127,127,120,120,98,98,48,48,107,107,44,44,85,85,29,29,116,116,16,16,16,16,34,34,48,48,42,42,13,13,6,6,29,29,34,34,42,42,40,40,107,107,45,45,59,59,69,69,85,85,22,22,65,65,98,98,32,32,74,74,116,116,38,38,92,92,67,67,76,76,123,123,43,43,54,54,86,86,37,37,55,55,25,25,60,60,96,96,67,67,67,67,121,121,112,112,5,5,96,96,124,124,50,50,37,37,33,33,22,22,38,38,56,56,57,57,51,51,48,48,102,102,31,31,17,17,73,73,111,111,64,64,79,79,38,38,61,61,107,107,9,9,77,77,39,39,0,0,87,87,29,29,22,22,101,101,44,44,106,106,83,83,34,34,42,42,78,78,43,43,70,70,89,89,109,109,68,68,59,59,58,58,42,42,95,95,6,6,17,17,116,116,12,12,58,58,70,70,46,46,29,29,43,43,27,27,55,55,77,77,103,103,116,116,90,90,10,10,104,104,116,116,74,74,105,105,73,73,9,9,92,92,112,112,80,80,71,71,21,21,40,40,119,119,59,59,64,64,43,43,121,121,16,16,59,59,24,24,29,29,30,30,5,5,0,0,44,44,45,45,90,90,113,113,15,15,35,35,2,2,94,94,125,125,30,30,81,81,0,0,121,121,44,44,89,89,29,29,67,67,85,85,11,11,41,41,33,33,115,115,10,10,24,24,16,16,46,46,4,4,31,31,28,28,78,78,79,79,39,39,53,53,12,12,24,24,58,58,118,118,94,94,103,103,71,71,19,19,64,64,29,29,122,122,16,16,126,126,20,20,44,44,105,105,64,64,29,29,11,11,0,0,41,41,83,83,67,67,69,69,127,127,103,103,42,42,44,44,82,82,37,37,53,53,92,92,34,34,106,106,23,23,26,26,8,8,124,124,28,28,58,58,4,4,127,127,67,67,72,72,90,90,44,44,6,6,50,50,66,66,43,43,27,27,6,6,114,114,1,1,32,32,16,16,45,45,28,28,67,67,84,84,75,75,85,85,25,25,51,51,23,23,90,90,21,21,13,13,70,70,36,36,62,62,121,121,123,123,116,116,51,51,120,120,76,76,91,91,9,9,45,45,101,101,42,42,122,122,89,89,39,39,47,47,12,12,98,98,83,83,92,92,9,9,60,60,32,32,91,91,55,55,66,66,80,80,2,2,113,113,106,106,88,88,11,11,54,54,8,8,22,22,44,44,79,79,56,56,101,101,72,72,76,76,80,80,49,49,53,53,125,125,56,56,102,102,39,39,42,42,55,55,88,88,101,101,30,30,123,123,72,72,105,105,49,49,20,20,85,85,32,32,101,101,115,115,17,17,16,16,58,58,57,57,105,105,116,116,4,4,50,50,62,62,77,77,75,75,100,100,124,124,2,2,99,99,31,31,62,62,81,81,53,53,76,76,27,27,60,60,111,111,88,88,1,1,73,73,74,74,4,4,12,12,8,8,69,69,54,54,34,34,120,120,41,41,62,62,66,66,14,14,3,3,99,99,49,49,69,69,82,82,77,77,88,88,119,119,43,43,72,72,58,58,74,74,89,89,7,7,42,42,77,77,32,32,75,75,98,98,89,89,97,97,30,30,47,47,57,57,62,62,124,124,114,114,110,110,76,76,21,21,8,8,103,103,126,126,121,121,125,125,63,63,9,9,124,124,20,20,78,78,99,99,12,12,57,57,104,104,36,36,7,7,78,78,71,71,102,102,110,110,117,117,78,78,120,120,127,127,25,25,24,24,68,68,82,82,83,83,123,123,8,8,71,71,70,70,126,126,6,6,89,89,33,33,72,72,109,109,28,28,74,74,15,15,100,100,82,82,72,72,74,74,21,21,34,34,65,65,16,16,69,69,102,102,33,33,54,54,91,91,1,1,32,32,54,54,30,30,5,5,42,42,3,3,48,48,120,120,96,96,36,36,5,5,22,22,73,73,111,111,35,35,87,87,53,53,85,85,20,20,54,54,41,41,18,18,27,27,77,77,83,83,118,118,65,65,22,22,13,13,43,43,109,109,30,30,31,31,105,105,26,26,56,56,22,22,118,118,86,86,25,25,13,13,20,20,31,31,52,52,40,40,34,34,99,99,46,46,61,61,98,98,105,105,46,46,42,42,79,79,31,31,102,102,45,45,126,126,115,115,16,16,71,71,115,115,119,119,81,81,10,10,80,80,123,123,24,24,105,105,23,23,120,120,105,105,36,36,123,123,125,125,34,34,79,79,0,0,10,10,11,11,77,77,115,115,50,50,65,65,69,69,94,94,33,33,32,32,82,82,20,20,70,70,120,120,13,13,86,86,32,32,116,116,8,8,99,99,48,48,97,97,121,121,47,47,79,79,52,52,126,126,38,38,27,27,25,25,94,94,65,65,0,0,89,89,37,37,70,70,43,43,63,63,19,19,35,35,81,81,20,20,15,15,85,85,93,93,114,114,10,10,99,99,100,100,46,46,70,70,86,86,25,25,69,69,112,112,68,68,102,102,20,20,102,102,117,117,79,79,12,12,6,6,0,0,80,80,33,33,22,22,27,27,38,38,13,13,95,95,124,124,48,48,76,76,25,25,25,25,40,40,53,53,116,116,5,5,25,25,115,115,19,19,1,1,12,12,22,22,46,46,28,28,26,26,59,59,77,77,38,38,108,108,96,96,76,76,12,12,109,109,1,1,19,19,72,72,29,29,27,27,80,80,15,15,84,84,15,15,114,114,26,26,40,40,124,124,108,108,71,71,98,98,9,9,22,22,78,78,2,2,83,83,52,52,36,36,22,22,94,94,77,77,2,2,16,16,35,35,105,105,92,92,28,28,51,51,69,69,41,41,41,41,8,8,71,71,64,64,93,93,45,45,14,14,110,110,52,52,13,13,49,49,36,36,71,71,57,57,48,48,95,95,36,36,48,48,42,42,86,86,54,54,98,98,65,65,18,18,89,89,39,39,34,34,98,98,6,6,97,97,23,23,2,2,91,91,77,77,52,52,12,12,92,92,5,5,11,11,110,110,8,8,121,121,82,82,112,112,45,45,32,32,49,49,72,72,76,76,21,21,38,38,86,86,11,11,40,40,24,24,7,7,75,75,126,126,117,117,55,55,69,69,70,70,74,74,27,27,124,124,41,41,45,45,109,109,18,18,84,84,27,27,21,21,4,4,111,111,33,33,51,51,111,111,53,53,92,92,7,7,125,125,118,118,100,100,11,11,53,53,60,60,19,19,122,122,49,49,32,32,101,101,104,104,40,40,88,88,11,11,124,124,16,16,78,78,2,2,115,115,18,18,95,95,63,63,17,17,94,94,109,109,34,34,83,83,69,69,110,110,33,33,49,49,0,0,119,119,36,36,108,108,11,11,18,18,70,70,109,109,111,111,72,72,2,2,29,29,107,107,105,105,119,119,52,52,78,78,14,14,91,91,10,10,36,36,63,63,127,127,64,64,63,63,61,61,50,50,38,38,17,17,69,69,56,56,65,65,16,16,54,54,60,60,44,44,20,20,98,98,19,19,81,81,29,29,26,26,34,34,100,100,103,103,60,60,19,19,4,4,76,76,121,121,33,33,46,46,6,6,0,0,49,49,99,99,17,17,76,76,43,43,29,29,67,67,59,59,68,68,114,114,122,122,111,111,56,56,73,73,6,6,85,85,80,80,6,6,99,99,120,120,69,69,29,29,53,53,44,44,29,29,35,35,57,57,43,43,103,103,30,30,79,79,102,102,48,48,105,105,70,70,1,1,64,64,65,65,94,94,35,35,100,100,51,51,0,0,12,12,21,21,106,106,43,43,32,32,111,111,4,4,86,86,28,28,124,124,64,64,10,10,90,90,0,0,13,13,81,81,107,107,97,97,46,46,75,75,19,19,1,1,52,52,91,91,35,35,45,45,73,73,123,123,36,36,27,27,84,84,81,81,72,72,38,38,81,81,14,14,124,124,115,115,19,19,111,111,12,12,96,96,19,19,59,59,92,92,35,35,59,59,31,31,5,5,2,2,121,121,82,82,58,58,20,20,90,90,2,2,67,67,104,104,49,49,24,24,48,48,8,8,1,1,43,43,86,86,28,28,12,12,101,101,41,41,90,90,31,31,95,95,10,10,25,25,94,94,78,78,109,109,96,96,18,18,116,116,126,126,82,82,124,124,116,116,12,12,19,19,72,72,95,95,113,113,86,86,111,111,13,13,15,15,31,31,65,65,52,52,63,63,35,35,49,49,26,26,100,100,78,78,8,8,72,72,26,26,90,90,34,34,2,2,86,86,3,3,14,14,28,28,78,78,104,104,112,112,26,26,24,24,73,73,60,60,32,32,78,78,31,31,39,39,86,86,103,103,1,1,100,100,23,23,63,63,112,112,85,85,63,63,101,101,2,2,55,55,10,10,85,85,96,96,12,12,78,78,73,73,118,118,46,46,92,92,38,38,83,83,57,57,44,44,70,70,91,91,22,22,64,64,95,95,7,7,95,95,114,114,116,116,46,46,118,118,96,96,111,111,48,48,39,39,102,102,102,102,56,56,8,8,94,94,13,13,16,16,16,16,79,79,46,46,18,18,104,104,36,36,100,100,98,98,16,16,12,12,11,11,101,101,6,6,114,114,103,103,90,90,117,117,6,6,104,104,33,33,119,119,59,59,8,8,75,75,0,0,20,20,15,15,1,1,116,116,34,34,109,109,50,50,42,42,91,91,102,102,82,82,35,35,16,16,5,5,3,3,43,43,25,25,119,119,74,74,67,67,106,106,99,99,9,9,49,49,88,88,96,96,79,79,107,107,7,7,31,31,92,92,3,3,87,87,50,50,40,40,56,56,11,11,29,29,64,64,24,24,104,104,81,81,33,33,2,2,3,3,18,18,64,64,89,89,0,0,17,17,109,109,71,71,30,30,121,121,73,73,125,125,71,71,91,91,104,104,59,59,46,46,35,35,32,32,127,127,77,77,50,50,98,98,126,126,13,13,12,12,64,64,21,21,112,112,25,25,12,12,67,67,121,121,2,2,79,79,100,100,85,85,112,112,120,120,125,125,99,99,79,79,19,19,47,47,90,90,10,10,16,16,111,111,47,47,19,19,86,86,81,81,29,29,14,14,5,5,37,37,97,97,63,63,1,1,114,114,120,120,15,15,125,125,40,40,26,26,84,84,82,82,97,97,124,124,39,39,30,30,95,95,4,4,97,97,65,65,51,51,14,14,2,2,62,62,112,112,97,97,44,44,50,50,52,52,1,1,70,70,54,54,91,91,81,81,87,87,85,85,29,29,127,127,37,37,30,30,49,49,7,7,62,62,114,114,73,73,24,24,83,83,65,65,119,119,103,103,55,55,53,53,56,56,82,82,85,85,96,96,38,38,7,7,53,53,95,95,101,101,46,46,36,36,75,75,105,105,67,67,0,0,42,42,20,20,10,10,61,61,50,50,91,91,99,99,72,72,120,120,107,107,109,109,72,72,10,10,100,100,110,110,32,32,53,53,65,65,42,42,95,95,71,71,7,7,76,76,32,32,33,33,4,4,103,103,120,120,25,25,3,3,59,59,75,75,21,21,77,77,3,3,118,118,36,36,34,34,25,25,10,10,54,54,89,89,81,81,44,44,9,9,44,44,84,84,26,26,34,34,17,17,72,72,104,104,88,88,64,64,110,110,68,68,5,5,23,23,26,26,33,33,76,76,11,11,21,21,8,8,45,45,18,18,99,99,0,0,107,107,63,63,33,33,53,53,6,6,57,57,51,51,55,55,33,33,52,52,40,40,101,101,13,13,106,106,88,88,15,15,22,22,32,32,65,65,78,78,20,20,54,54,123,123,24,24,48,48,69,69,114,114,52,52,44,44,54,54,54,54,4,4,110,110,43,43,4,4,122,122,120,120,25,25,61,61,44,44,98,98,60,60,124,124,49,49,118,118,20,20,0,0,72,72,76,76,100,100,63,63,109,109,31,31,119,119,92,92,37,37,77,77,2,2,102,102,81,81,83,83,25,25,72,72,42,42,70,70,76,76,30,30,3,3,121,121,3,3,63,63,46,46,58,58,61,61,94,94,88,88,104,104,94,94,26,26,107,107,28,28,48,48,68,68,101,101,8,8,51,51,70,70,104,104,1,1,20,20,51,51,4,4,11,11,113,113,70,70,23,23,94,94,51,51,71,71,23,23,46,46,100,100,87,87,32,32,71,71,89,89,120,120,94,94,77,77,75,75,44,44,124,124,83,83,32,32,109,109,28,28,1,1,59,59,65,65,100,100,41,41,42,42,120,120,42,42,17,17,28,28,13,13,33,33,108,108,51,51,58,58,39,39,82,82,37,37,83,83,14,14,9,9,95,95,73,73,69,69,114,114,75,75,31,31,82,82,12,12,28,28,11,11,109,109,10,10,125,125,76,76,83,83,27,27,96,96,93,93,46,46,10,10,48,48,59,59,75,75,80,80,29,29,110,110,77,77,51,51,45,45,48,48,121,121,61,61,120,120,33,33,22,22,32,32,18,18,41,41,13,13,122,122,79,79,85,85,119,119,124,124,94,94,37,37,24,24,69,69,66,66,31,31,90,90,12,12,49,49,71,71,103,103,4,4,81,81,77,77,109,109,123,123,105,105,5,5,8,8,50,50,114,114,46,46,114,114,122,122,87,87,126,126,100,100,35,35,98,98,3,3,121,121,86,86,41,41,49,49,36,36,126,126,69,69,66,66,5,5,108,108,90,90,61,61,53,53,97,97,50,50,53,53,124,124,2,2,32,32,87,87,56,56,23,23,102,102,123,123,74,74,9,9,102,102,52,52,89,89,98,98,33,33,93,93,47,47,78,78,0,0,126,126,13,13,68,68,7,7,112,112,108,108,125,125,113,113,31,31,96,96,48,48,64,64,106,106,66,66,105,105,19,19,115,115,11,11,45,45,2,2,11,11,52,52,50,50,28,28,76,76,83,83,65,65,70,70,7,7,28,28,19,19,54,54,36,36,86,86,10,10,123,123,127,127,43,43,106,106,38,38,41,41,112,112,5,5,94,94,123,123,55,55,53,53,29,29,46,46,110,110,81,81,114,114,55,55,102,102,36,36,46,46,87,87,70,70,109,109,77,77,108,108,94,94,99,99,32,32,57,57,110,110,92,92,91,91,110,110,45,45,35,35,53,53,54,54,65,65,67,67,52,52,73,73,11,11,97,97,116,116,40,40,22,22,92,92,19,19,39,39,42,42,80,80,6,6,118,118,67,67,11,11,115,115,55,55,24,24,92,92,39,39,98,98,102,102,125,125,60,60,44,44,88,88,70,70,103,103,69,69,29,29,24,24,68,68,101,101,57,57,117,117,102,102,22,22,74,74,44,44,110,110,32,32,86,86,51,51,107,107,5,5,70,70,43,43,75,75,16,16,105,105,66,66,65,65,9,9,48,48,106,106,57,57,24,24,12,12,85,85,73,73,103,103,125,125,121,121,17,17,127,127,75,75,5,5,114,114,9,9,117,117,22,22,118,118,100,100,49,49,26,26,114,114,89,89,24,24,107,107,64,64,65,65,2,2,54,54,66,66,103,103,76,76,38,38,22,22,116,116,1,1,7,7,82,82,53,53,84,84,52,52,116,116,56,56,9,9,1,1,80,80,26,26,109,109,122,122,69,69,29,29,97,97,82,82,2,2,89,89,25,25,112,112,62,62,107,107,25,25,93,93,55,55,88,88,53,53,10,10,121,121,76,76,102,102,89,89,73,73,4,4,27,27,3,3,77,77,54,54,34,34,30,30,14,14,6,6,78,78,73,73,114,114,47,47,18,18,40,40,79,79,73,73,38,38,15,15,113,113,98,98,108,108,60,60,117,117,15,15,38,38,90,90,57,57,57,57,13,13,116,116,11,11,16,16,7,7,68,68,3,3,114,114,104,104,6,6,101,101,92,92,4,4,79,79,29,29,21,21,27,27,78,78,29,29,114,114,2,2,114,114,78,78,13,13,42,42,78,78,122,122,18,18,7,7,63,63,56,56,16,16,7,7,108,108,2,2,96,96,116,116,88,88,28,28,9,9,63,63,72,72,0,0,80,80,79,79,87,87,86,86,33,33,67,67,72,72,1,1,108,108,82,82,34,34,71,71,120,120,86,86,33,33,100,100,61,61,26,26,83,83,14,14,83,83,78,78,60,60,1,1,115,115,90,90,63,63,38,38,9,9,8,8,11,11,8,8,42,42,42,42,54,54,32,32,85,85,24,24,46,46,84,84,60,60,54,54,89,89,81,81,80,80,119,119,77,77,66,66,78,78,5,5,6,6,49,49,31,31,72,72,98,98,15,15,121,121,16,16,54,54,67,67,40,40,42,42,109,109,111,111,118,118,48,48,18,18,104,104,39,39,37,37,37,37,15,15,2,2,53,53,108,108,41,41,111,111,126,126,112,112,18,18,37,37,24,24,96,96,94,94,51,51,21,21,72,72,72,72,14,14,114,114,64,64,11,11,124,124,117,117,90,90,44,44,18,18,91,91,38,38,108,108,20,20,40,40,113,113,33,33,47,47,37,37,24,24,72,72,114,114,74,74,104,104,50,50,65,65,63,63,98,98,82,82,11,11,117,117,6,6,113,113,81,81,72,72,13,13,48,48,35,35,0,0,35,35,61,61,104,104,59,59,97,97,18,18,33,33,62,62,86,86,22,22,84,84,125,125,13,13,101,101,103,103,4,4,65,65,47,47,11,11,34,34,15,15,77,77,80,80,5,5,92,92,100,100,116,116,44,44,126,126,67,67,117,117,38,38,93,93,27,27,32,32,124,124,26,26,33,33,116,116,2,2,63,63,113,113,62,62,17,17,106,106,59,59,4,4,91,91,71,71,100,100,69,69,97,97,50,50,100,100,40,40,20,20,36,36,105,105,120,120,55,55,66,66,58,58,6,6,60,60,67,67,113,113,84,84,120,120,49,49,40,40,49,49,93,93,6,6,95,95,24,24,64,64,10,10,66,66,15,15,0,0,70,70,18,18,111,111,16,16,8,8,124,124,112,112,113,113,14,14,18,18,96,96,86,86,62,62,6,6,44,44,30,30,63,63,116,116,22,22,7,7,85,85,20,20,75,75,46,46,12,12,122,122,115,115,99,99,2,2,4,4,32,32,28,28,77,77,118,118,51,51,89,89,31,31,126,126,45,45,90,90,99,99,16,16,82,82,31,31,125,125,73,73,17,17,109,109,36,36,4,4,1,1,78,78,113,113,20,20,33,33,41,41,8,8,56,56,47,47,5,5,123,123,88,88,23,23,91,91,8,8,105,105,52,52,36,36,118,118,33,33,24,24,90,90,43,43,115,115,68,68,0,0,64,64,27,27,95,95,59,59,15,15,64,64,93,93,49,49,28,28,68,68,115,115,6,6,51,51,124,124,99,99,124,124,4,4,53,53,112,112,33,33,33,33,82,82,52,52,114,114,0,0,91,91,126,126,119,119,32,32,102,102,124,124,67,67,112,112,34,34,46,46,127,127,55,55,62,62,105,105,87,87,65,65,31,31,112,112,99,99,22,22,60,60,32,32,47,47,83,83,98,98,99,99,37,37,10,10,67,67,110,110,96,96,83,83,5,5,88,88,83,83,77,77,12,12,87,87,14,14,62,62,72,72,81,81,32,32,28,28,79,79,86,86,107,107,126,126,56,56,123,123,122,122,83,83,43,43,2,2,41,41,123,123,117,117,6,6,90,90,40,40,13,13,102,102,80,80,79,79,111,111,36,36,93,93,5,5,29,29,36,36,14,14,118,118,84,84,0,0,44,44,8,8,65,65,19,19,12,12,61,61,8,8,10,10,84,84,8,8,40,40,70,70,81,81,98,98,70,70,49,49,44,44,102,102,89,89,106,106,84,84,70,70,95,95,113,113,61,61,122,122,60,60,109,109,45,45,124,124,26,26,46,46,76,76,2,2,67,67,76,76,98,98,123,123,80,80,66,66,24,24,108,108,38,38,52,52,74,74,85,85,83,83,107,107,111,111,78,78,7,7,113,113,62,62,30,30,46,46,26,26,120,120,25,25,50,50,72,72,11,11,51,51,39,39,12,12,26,26,2,2,7,7,24,24,77,77,0,0,16,16,86,86,83,83,32,32,114,114,16,16,71,71,54,54,19,19,87,87,22,22,6,6,44,44,110,110,47,47,50,50,55,55,117,117,12,12,76,76,105,105,7,7,90,90,1,1,97,97,66,66,28,28,93,93,6,6,16,16,103,103,120,120,72,72,55,55,10,10,86,86,35,35,18,18,7,7,18,18,5,5,100,100,79,79,112,112,87,87,76,76,26,26,8,8,101,101,126,126,62,62,91,91,79,79,3,3,126,126,92,92,43,43,7,7,110,110,2,2,45,45,91,91,122,122,76,76,72,72,24,24,76,76,106,106,44,44,120,120,51,51,34,34,73,73,67,67,70,70,119,119,8,8,91,91,26,26,110,110,92,92,7,7,54,54,2,2,1,1,54,54,48,48,68,68,38,38,12,12,13,13,112,112,114,114,52,52,58,58,17,17,68,68,90,90,29,29,97,97,101,101,8,8,127,127,9,9,46,46,118,118,102,102,82,82,113,113,72,72,35,35,18,18,47,47,64,64,24,24,121,121,59,59,95,95,46,46,43,43,115,115,56,56,78,78,9,9,57,57,116,116,13,13,6,6,91,91,86,86,19,19,89,89,45,45,88,88,92,92,77,77,5,5,72,72,117,117,65,65,104,104,38,38,0,0,76,76,0,0,15,15,55,55,103,103,0,0,125,125,41,41,118,118,23,23,98,98,69,69,70,70,6,6,84,84,122,122,39,39,96,96,69,69,119,119,46,46,4,4,113,113,110,110,19,19,53,53,77,77,21,21,54,54,84,84,6,6,14,14,40,40,80,80,120,120,57,57,86,86,15,15,41,41,41,41,17,17,113,113,57,57,14,14,48,48,21,21,17,17,90,90,101,101,102,102,114,114,115,115,28,28,33,33,70,70,7,7,14,14,49,49,61,61,18,18,85,85,126,126,20,20,82,82,28,28,44,44,70,70,40,40,68,68,41,41,35,35,68,68,31,31,31,31,104,104,42,42,37,37,76,76,66,66,28,28,3,3,75,75,105,105,15,15,70,70,97,97,7,7,88,88,37,37,13,13,76,76,6,6,10,10,13,13,78,78,19,19,54,54,70,70,4,4,94,94,121,121,18,18,58,58,88,88,1,1,75,75,28,28,112,112,52,52,52,52,58,58,5,5,120,120,53,53,14,14,85,85,11,11,87,87,108,108,56,56,86,86,67,67,127,127,65,65,4,4,21,21,14,14,83,83,65,65,13,13,69,69,104,104,64,64,123,123,36,36,124,124,52,52,79,79,82,82,100,100,13,13,10,10,66,66,21,21,82,82,9,9,125,125,5,5,69,69,8,8,19,19,57,57,78,78,115,115,4,4,37,37,19,19,55,55,2,2,72,72,86,86,83,83,2,2,111,111,23,23,80,80,45,45,4,4,125,125,64,64,21,21,4,4,21,21,44,44,2,2,75,75,33,33,113,113,35,35,103,103,35,35,126,126,55,55,59,59,30,30,117,117,92,92,85,85,54,54,84,84,18,18,74,74,122,122,81,81,62,62,111,111,92,92,3,3,92,92,4,4,104,104,54,54,43,43,66,66,81,81,21,21,125,125,74,74,15,15,16,16,120,120,80,80,27,27,66,66,114,114,111,111,93,93,9,9,96,96,84,84,18,18,3,3,37,37,13,13,97,97,114,114,0,0,110,110,80,80,75,75,31,31,111,111,12,12,54,54,88,88,4,4,108,108,5,5,13,13,117,117,35,35,50,50,97,97,125,125,68,68,6,6,41,41,42,42,84,84,19,19,41,41,59,59,17,17,78,78,37,37,39,39,41,41,16,16,27,27,18,18,32,32,17,17,40,40,11,11,47,47,35,35,19,19,90,90,111,111,81,81,54,54,52,52,6,6,48,48,14,14,111,111,59,59,38,38,123,123,104,104,103,103,109,109,52,52,38,38,23,23,69,69,71,71,51,51,48,48,39,39,50,50,74,74,96,96,82,82,107,107,25,25,127,127,37,37,73,73,10,10,13,13,103,103,70,70,53,53,117,117,44,44,44,44,96,96,69,69,122,122,43,43,38,38,6,6,101,101,14,14,87,87,114,114,76,76,14,14,43,43,58,58,58,58,90,90,13,13,92,92,10,10,116,116,38,38,44,44,16,16,56,56,117,117,104,104,42,42,46,46,116,116,32,32,28,28,70,70,48,48,30,30,106,106,34,34,6,6,113,113,119,119,6,6,39,39,16,16,109,109,10,10,46,46,69,69,10,10,10,10,126,126,30,30,38,38,120,120,44,44,75,75,108,108,18,18,88,88,30,30,81,81,24,24,82,82,21,21,24,24,34,34,24,24,96,96,30,30,66,66,75,75,79,79,69,69,59,59,123,123,73,73,118,118,20,20,76,76,87,87,4,4,15,15,38,38,75,75,127,127,85,85,78,78,47,47,116,116,38,38,1,1,98,98,16,16,68,68,71,71,74,74,116,116,61,61,2,2,40,40,28,28,35,35,15,15,111,111,127,127,43,43,67,67,56,56,5,5,83,83,30,30,74,74,25,25,64,64,77,77,17,17,35,35,24,24,81,81,96,96,35,35,45,45,91,91,68,68,55,55,13,13,6,6,0,0,47,47,45,45,25,25,39,39,38,38,32,32,94,94,99,99,102,102,6,6,22,22,46,46,32,32,16,16,69,69,39,39,23,23,73,73,25,25,115,115,15,15,124,124,66,66,50,50,6,6,60,60,6,6,31,31,68,68,55,55,6,6,5,5,16,16,21,21,86,86,23,23,21,21,85,85,72,72,43,43,11,11,47,47,94,94,0,0,40,40,33,33,60,60,19,19,12,12,45,45,59,59,68,68,4,4,32,32,41,41,89,89,34,34,90,90,63,63,111,111,55,55,2,2,41,41,112,112,118,118,15,15,58,58,9,9,7,7,116,116,78,78,11,11,102,102,66,66,59,59,86,86,81,81,5,5,48,48,86,86,51,51,82,82,114,114,50,50,32,32,44,44,108,108,49,49,33,33,28,28,22,22,89,89,101,101,20,20,13,13,65,65,106,106,88,88,104,104,30,30,29,29,46,46,34,34,51,51,102,102,30,30,24,24,41,41,74,74,5,5,124,124,8,8,87,87,119,119,94,94,73,73,40,40,19,19,51,51,97,97,100,100,111,111,127,127,7,7,10,10,35,35,72,72,6,6,18,18,33,33,97,97,107,107,125,125,45,45,12,12,71,71,14,14,52,52,1,1,0,0,17,17,107,107,67,67,12,12,44,44,75,75,69,69,76,76,19,19,55,55,39,39,124,124,87,87,78,78,73,73,72,72,89,89,6,6,97,97,1,1,18,18,95,95,84,84,117,117,28,28,112,112,8,8,124,124,23,23,54,54,83,83,49,49,93,93,8,8,1,1,51,51,81,81,1,1,108,108,93,93,76,76,124,124,3,3,112,112,33,33,79,79,65,65,81,81,116,116,64,64,85,85,89,89,108,108,52,52,73,73,86,86,14,14,91,91,49,49,21,21,106,106,111,111,114,114,97,97,89,89,116,116,102,102,89,89,70,70,48,48,17,17,22,22,57,57,32,32,22,22,76,76,110,110,29,29,19,19,64,64,18,18,54,54,37,37,47,47,1,1,60,60,22,22,1,1,66,66,113,113,31,31,47,47,52,52,103,103,93,93,78,78,58,58,94,94,96,96,84,84,67,67,112,112,122,122,18,18,93,93,55,55,12,12,50,50,56,56,8,8,57,57,102,102,12,12,79,79,52,52,34,34,51,51,37,37,14,14,22,22,41,41,67,67,16,16,57,57,107,107,90,90,16,16,84,84,95,95,87,87,25,25,10,10,88,88,71,71,49,49,5,5,43,43,28,28,13,13,41,41,49,49,16,16,56,56,2,2,72,72,24,24,118,118,45,45,97,97,119,119,101,101,17,17,10,10,63,63,126,126,32,32,23,23,108,108,100,100,21,21,32,32,86,86,83,83,110,110,51,51,32,32,86,86,74,74,21,21,27,27,4,4,33,33,32,32,62,62,40,40,37,37,77,77,85,85,47,47,92,92,65,65,122,122,85,85,60,60,72,72,43,43,109,109,8,8,10,10,45,45,77,77,10,10,62,62,54,54,117,117,67,67,86,86,28,28,37,37,22,22,96,96,34,34,33,33,50,50,103,103,72,72,8,8,17,17,97,97,58,58,103,103,51,51,95,95,119,119,58,58,117,117,101,101,16,16,115,115,38,38,18,18,32,32,110,110,36,36,45,45,28,28,107,107,52,52,4,4,125,125,113,113,40,40,22,22,105,105,124,124,104,104,82,82,109,109,19,19,80,80,58,58,125,125,119,119,88,88,78,78,6,6,40,40,56,56,19,19,96,96,117,117,96,96,42,42,69,69,10,10,21,21,3,3,104,104,28,28,73,73,79,79,3,3,57,57,54,54,25,25,0,0,111,111,33,33,51,51,40,40,21,21,30,30,113,113,2,2,55,55,4,4,82,82,106,106,8,8,18,18,127,127,74,74,61,61,122,122,6,6,16,16,110,110,109,109,30,30,66,66,100,100,86,86,0,0,66,66,85,85,14,14,111,111,20,20,102,102,50,50,7,7,82,82,57,57,80,80,123,123,36,36,2,2,48,48,97,97,32,32,83,83,55,55,93,93,84,84,34,34,11,11,41,41,58,58,63,63,27,27,24,24,21,21,29,29,31,31,106,106,57,57,85,85,115,115,63,63,101,101,89,89,84,84,115,115,119,119,106,106,82,82,74,74,59,59,37,37,58,58,67,67,107,107,120,120,56,56,93,93,118,118,17,17,104,104,51,51,53,53,27,27,117,117,51,51,8,8,93,93,112,112,92,92,50,50,116,116,52,52,12,12,23,23,55,55,88,88,99,99,82,82,87,87,30,30,105,105,111,111,63,63,115,115,0,0,117,117,51,51,81,81,35,35,90,90,9,9,106,106,66,66,96,96,96,96,100,100,98,98,3,3,91,91,107,107,94,94,65,65,9,9,18,18,8,8,40,40,91,91,11,11,7,7,97,97,8,8,9,9,101,101,69,69,28,28,98,98,0,0,50,50,89,89,0,0,88,88,72,72,7,7,115,115,64,64,122,122,105,105,66,66,38,38,78,78,8,8,110,110,33,33,71,71,52,52,2,2,109,109,115,115,62,62,42,42,122,122,104,104,53,53,101,101,59,59,127,127,60,60,14,14,114,114,68,68,106,106,99,99,68,68,80,80,54,54,39,39,18,18,6,6,48,48,44,44,34,34,9,9,17,17,92,92,18,18,67,67,95,95,9,9,111,111,37,37,59,59,114,114,114,114,86,86,82,82,119,119,70,70,98,98,46,46,38,38,10,10,116,116,30,30,89,89,77,77,27,27,59,59,24,24,6,6,104,104,73,73,117,117,90,90,1,1,53,53,30,30,122,122,28,28,1,1,20,20,105,105,99,99,100,100,101,101,105,105,22,22,15,15,90,90,43,43,74,74,32,32,69,69,16,16,115,115,116,116,43,43,116,116,18,18,9,9,74,74,115,115,45,45,90,90,112,112,68,68,71,71,107,107,7,7,42,42,68,68,113,113,39,39,7,7,73,73,60,60,90,90,47,47,61,61,59,59,15,15,71,71,71,71,32,32,20,20,41,41,14,14,35,35,53,53,34,34,78,78,35,35,4,4,26,26,92,92,53,53,93,93,22,22,78,78,37,37,126,126,27,27,119,119,126,126,2,2,87,87,55,55,72,72,28,28,80,80,92,92,49,49,106,106,79,79,61,61,37,37,81,81,55,55,4,4,34,34,28,28,26,26,110,110,19,19,22,22,73,73,72,72,21,21,56,56,33,33,92,92,29,29,11,11,94,94,49,49,62,62,13,13,6,6,73,73,86,86,112,112,13,13,62,62,44,44,26,26,7,7,68,68,86,86,72,72,35,35,26,26,16,16,7,7,127,127,61,61,7,7,19,19,125,125,76,76,79,79,48,48,112,112,81,81,124,124,47,47,66,66,28,28,6,6,93,93,55,55,15,15,74,74,104,104,109,109,114,114,3,3,100,100,88,88,108,108,24,24,38,38,44,44,24,24,111,111,82,82,122,122,17,17,96,96,56,56,65,65,53,53,1,1,60,60,94,94,48,48,60,60,68,68,117,117,109,109,15,15,18,18,5,5,73,73,15,15,91,91,31,31,66,66,85,85,35,35,35,35,127,127,6,6,123,123,3,3,102,102,89,89,23,23,96,96,72,72,72,72,0,0,4,4,123,123,64,64,12,12,57,57,62,62,25,25,2,2,111,111,52,52,77,77,121,121,85,85,99,99,119,119,82,82,86,86,46,46,83,83,14,14,43,43,4,4,44,44,48,48,113,113,3,3,34,34,86,86,76,76,6,6,8,8,72,72,40,40,46,46,44,44,20,20,76,76,102,102,68,68,15,15,47,47,70,70,50,50,71,71,43,43,15,15,30,30,119,119,5,5,20,20,101,101,59,59,38,38,54,54,2,2,36,36,4,4,11,11,109,109,82,82,85,85,81,81,98,98,47,47,58,58,73,73,66,66,5,5,50,50,120,120,17,17,14,14,62,62,6,6,48,48,87,87,23,23,112,112,84,84,109,109,17,17,25,25,39,39,95,95,67,67,81,81,27,27,120,120,5,5,33,33,22,22,40,40,65,65,26,26,23,23,14,14,72,72,53,53,75,75,76,76,90,90,65,65,49,49,41,41,0,0,72,72,70,70,125,125,73,73,7,7,72,72,18,18,101,101,10,10,107,107,98,98,25,25,80,80,88,88,68,68,116,116,18,18,113,113,36,36,33,33,105,105,94,94,67,67,100,100,57,57,85,85,6,6,125,125,39,39,118,118,1,1,69,69,126,126,19,19,42,42,47,47,21,21,99,99,92,92,36,36,17,17,106,106,40,40,18,18,26,26,79,79,17,17,70,70,35,35,108,108,105,105,57,57,120,120,2,2,94,94,92,92,92,92,66,66,79,79,17,17,74,74,30,30,1,1,12,12,114,114,126,126,20,20,77,77,23,23,30,30,87,87,100,100,86,86,74,74,125,125,54,54,95,95,125,125,32,32,47,47,54,54,4,4,106,106,3,3,77,77,86,86,103,103,116,116,30,30,113,113,113,113,75,75,120,120,55,55,42,42,67,67,82,82,64,64,121,121,56,56,103,103,5,5,4,4,118,118,60,60,23,23,17,17,93,93,62,62,64,64,115,115,70,70,22,22,120,120,56,56,77,77,45,45,109,109,119,119,43,43,70,70,104,104,127,127,100,100,3,3,12,12,75,75,25,25,54,54,124,124,52,52,65,65,43,43,93,93,127,127,110,110,17,17,70,70,42,42,31,31,100,100,51,51,73,73,82,82,96,96,43,43,79,79,24,24,2,2,100,100,48,48,15,15,26,26,61,61,52,52,125,125,90,90,88,88,53,53,38,38,99,99,2,2,17,17,29,29,62,62,7,7,33,33,42,42,49,49,43,43,33,33,111,111,95,95,30,30,20,20,89,89,16,16,48,48,127,127,2,2,100,100,91,91,73,73,35,35,57,57,23,23,51,51,17,17,21,21,93,93,44,44,110,110,68,68,9,9,39,39,32,32,52,52,51,51,56,56,5,5,19,19,112,112,89,89,70,70,51,51,32,32,125,125,122,122,52,52,66,66,47,47,46,46,16,16,75,75,85,85,75,75,75,75,118,118,105,105,107,107,8,8,50,50,53,53,55,55,8,8,90,90,63,63,123,123,66,66,15,15,96,96,54,54,57,57,57,57,33,33,17,17,96,96,103,103,66,66,119,119,64,64,24,24,110,110,116,116,105,105,28,28,38,38,14,14,41,41,40,40,34,34,44,44,13,13,111,111,10,10,69,69,86,86,57,57,28,28,0,0,28,28,3,3,4,4,81,81,72,72,33,33,49,49,58,58,42,42,114,114,120,120,37,37,36,36,88,88,11,11,57,57,116,116,23,23,33,33,91,91,84,84,18,18,99,99,127,127,12,12,65,65,127,127,42,42,28,28,42,42,88,88,80,80,30,30,25,25,94,94,5,5,56,56,34,34,85,85,82,82,76,76,72,72,101,101,42,42,46,46,117,117,80,80,68,68,48,48,29,29,88,88,126,126,44,44,71,71,85,85,104,104,116,116,82,82,38,38,16,16,16,16,118,118,65,65,106,106,122,122,11,11,123,123,49,49,104,104,119,119,41,41,39,39,79,79,17,17,48,48,52,52,98,98,75,75,116,116,78,78,87,87,69,69,75,75,30,30,119,119,75,75,81,81,68,68,64,64,50,50,9,9,32,32,35,35,71,71,39,39,74,74,78,78,28,28,52,52,100,100,42,42,78,78,22,22,22,22,106,106,82,82,6,6,80,80,123,123,9,9,24,24,124,124,88,88,53,53,15,15,63,63,115,115,114,114,21,21,53,53,58,58,13,13,65,65,76,76,64,64,4,4,98,98,65,65,14,14,27,27,110,110,118,118,124,124,100,100,4,4,67,67,121,121,72,72,110,110,79,79,106,106,33,33,122,122,31,31,33,33,56,56,11,11,113,113,34,34,83,83,72,72,103,103,0,0,31,31,46,46,69,69,84,84,105,105,3,3,91,91,8,8,102,102,8,8,98,98,96,96,94,94,48,48,16,16,41,41,15,15,80,80,92,92,120,120,65,65,69,69,6,6,5,5,27,27,12,12,73,73,17,17,33,33,66,66,56,56,14,14,78,78,68,68,103,103,2,2,96,96,77,77,99,99,116,116,74,74,16,16,41,41,49,49,99,99,94,94,59,59,4,4,80,80,24,24,88,88,45,45,32,32,66,66,119,119,0,0,68,68,11,11,62,62,123,123,88,88,58,58,18,18,52,52,59,59,114,114,48,48,102,102,84,84,10,10,119,119,60,60,51,51,123,123,82,82,10,10,36,36,34,34,94,94,94,94,4,4,119,119,64,64,121,121,6,6,30,30,65,65,65,65,45,45,53,53,112,112,86,86,53,53,18,18,32,32,4,4,4,4,82,82,100,100,70,70,11,11,52,52,115,115,109,109,30,30,110,110,94,94,20,20,83,83,17,17,62,62,42,42,13,13,104,104,43,43,78,78,28,28,104,104,101,101,118,118,12,12,101,101,104,104,24,24,59,59,109,109,117,117,72,72,2,2,76,76,53,53,77,77,30,30,106,106,51,51,123,123,34,34,83,83,64,64,87,87,63,63,53,53,107,107,10,10,90,90,92,92,34,34,101,101,40,40,124,124,89,89,86,86,2,2,36,36,103,103,22,22,118,118,101,101,98,98,73,73,9,9,80,80,22,22,72,72,2,2,29,29,71,71,2,2,2,2,9,9,30,30,104,104,67,67,113,113,112,112,38,38,35,35,101,101,75,75,64,64,77,77,80,80,106,106,91,91,103,103,40,40,102,102,84,84,4,4,55,55,1,1,62,62,60,60,33,33,55,55,42,42,71,71,51,51,31,31,63,63,32,32,11,11,38,38,86,86,77,77,10,10,7,7,33,33,98,98,116,116,93,93,82,82,33,33,84,84,16,16,60,60,18,18,95,95,113,113,58,58,40,40,45,45,67,67,94,94,102,102,5,5,79,79,67,67,124,124,48,48,54,54,77,77,55,55,29,29,28,28,4,4,11,11,24,24,98,98,51,51,98,98,89,89,127,127,2,2,113,113,45,45,18,18,11,11,38,38,65,65,101,101,22,22,109,109,33,33,124,124,12,12,26,26,94,94,81,81,104,104,84,84,91,91,45,45,112,112,49,49,27,27,3,3,34,34,16,16,88,88,84,84,122,122,70,70,69,69,38,38,19,19,117,117,26,26,91,91,7,7,27,27,126,126,52,52,57,57,26,26,63,63,47,47,53,53,18,18,51,51,5,5,89,89,94,94,26,26,107,107,83,83,55,55,18,18,12,12,37,37,110,110,118,118,100,100,73,73,18,18,112,112,103,103,45,45,96,96,104,104,43,43,109,109,7,7,108,108,111,111,12,12,1,1,50,50,31,31,65,65,95,95,40,40,104,104,109,109,3,3,6,6,37,37,121,121,15,15,89,89,68,68,44,44,83,83,39,39,55,55,52,52,33,33,19,19,13,13,11,11,15,15,4,4,66,66,109,109,88,88,3,3,88,88,30,30,124,124,80,80,20,20,24,24,119,119,98,98,126,126,126,126,45,45,105,105,71,71,32,32,94,94,27,27,14,14,1,1,104,104,13,13,112,112,79,79,97,97,102,102,34,34,124,124,66,66,24,24,56,56,121,121,77,77,13,13,31,31,27,27,5,5,99,99,54,54,68,68,29,29,61,61,93,93,101,101,43,43,23,23,62,62,24,24,42,42,0,0,24,24,104,104,126,126,45,45,98,98,109,109,121,121,56,56,1,1,66,66,86,86,104,104,108,108,109,109,4,4,25,25,117,117,2,2,40,40,34,34,45,45,33,33,42,42,67,67,91,91,29,29,74,74,17,17,5,5,119,119,3,3,37,37,8,8,102,102,49,49,13,13,105,105,53,53,9,9,62,62,7,7,98,98,69,69,110,110,40,40,78,78,0,0,124,124,5,5,83,83,18,18,114,114,32,32,21,21,80,80,80,80,101,101,124,124,36,36,28,28,64,64,85,85,118,118,41,41,41,41,97,97,104,104,120,120,107,107,2,2,114,114,18,18,10,10,14,14,29,29,2,2,20,20,32,32,78,78,13,13,45,45,26,26,25,25,121,121,68,68,27,27,33,33,97,97,20,20,12,12,53,53,7,7,21,21,94,94,45,45,108,108,24,24,110,110,9,9,45,45,111,111,56,56,93,93,43,43,99,99,24,24,79,79,91,91,8,8,38,38,120,120,56,56,47,47,32,32,117,117,13,13,50,50,37,37,54,54,54,54,65,65,115,115,43,43,113,113,38,38,106,106,98,98,66,66,126,126,120,120,123,123,118,118,58,58,17,17,9,9,80,80,126,126,4,4,113,113,56,56,17,17,59,59,51,51,65,65,72,72,113,113,104,104,83,83,82,82,56,56,81,81,66,66,116,116,92,92,61,61,33,33,68,68,20,20,51,51,101,101,85,85,43,43,28,28,49,49,0,0,24,24,107,107,37,37,50,50,96,96,123,123,115,115,30,30,29,29,80,80,56,56,116,116,68,68,14,14,85,85,104,104,28,28,2,2,44,44,100,100,28,28,22,22,42,42,59,59,34,34,6,6,73,73,116,116,34,34,95,95,33,33,22,22,23,23,12,12,126,126,123,123,8,8,85,85,17,17,24,24,48,48,64,64,127,127,71,71,0,0,106,106,79,79,118,118,95,95,126,126,24,24,39,39,113,113,71,71,95,95,70,70,42,42,32,32,58,58,70,70,5,5,28,28,67,67,33,33,83,83,8,8,109,109,76,76,28,28,8,8,23,23,22,22,77,77,51,51,14,14,82,82,90,90,93,93,66,66,2,2,14,14,127,127,119,119,99,99,45,45,90,90,38,38,112,112,11,11,67,67,15,15,22,22,94,94,71,71,63,63,78,78,56,56,109,109,85,85,124,124,100,100,96,96,10,10,95,95,32,32,124,124,56,56,67,67,91,91,123,123,92,92,7,7,3,3,77,77,54,54,127,127,3,3,64,64,53,53,125,125,78,78,11,11,65,65,109,109,78,78,4,4,70,70,102,102,104,104,11,11,32,32,38,38,81,81,3,3,19,19,66,66,69,69,71,71,47,47,36,36,80,80,88,88,120,120,97,97,48,48,116,116,53,53,12,12,33,33,102,102,32,32,116,116,71,71,45,45,48,48,42,42,101,101,9,9,58,58,114,114,75,75,82,82,32,32,73,73,100,100,94,94,69,69,13,13,100,100,11,11,55,55,118,118,98,98,101,101,6,6,96,96,101,101,84,84,58,58,101,101,5,5,38,38,95,95,13,13,94,94,120,120,40,40,33,33,9,9,56,56,121,121,2,2,49,49,104,104,72,72,44,44,66,66,50,50,77,77,42,42,27,27,30,30,10,10,114,114,97,97,63,63,0,0,13,13,57,57,36,36,3,3,43,43,120,120,92,92,85,85,117,117,50,50,96,96,35,35,8,8,116,116,44,44,21,21,45,45,50,50,127,127,0,0,7,7,55,55,45,45,82,82,6,6,25,25,100,100,72,72,120,120,35,35,125,125,81,81,34,34,62,62,4,4,59,59,23,23,106,106,66,66,100,100,53,53,52,52,58,58,66,66,98,98,24,24,17,17,87,87,35,35,21,21,62,62,35,35,52,52,30,30,79,79,115,115,126,126,24,24,27,27,15,15,55,55,57,57,81,81,30,30,124,124,89,89,52,52,81,81,77,77,78,78,88,88,54,54,12,12,50,50,22,22,75,75,116,116,38,38,124,124,127,127,121,121,16,16,16,16,8,8,42,42,64,64,58,58,11,11,42,42,37,37,101,101,71,71,75,75,42,42,65,65,37,37,71,71,61,61,110,110,108,108,85,85,18,18,96,96,25,25,10,10,15,15,40,40,89,89,34,34,39,39,74,74,100,100,77,77,59,59,27,27,124,124,74,74,72,72,116,116,125,125,127,127,109,109,102,102,76,76,75,75,19,19,6,6,70,70,66,66,37,37,81,81,86,86,71,71,38,38,96,96,90,90,77,77,60,60,104,104,105,105,91,91,21,21,124,124,0,0,10,10,42,42,23,23,4,4,30,30,109,109,4,4,11,11,95,95,106,106,94,94,29,29,100,100,55,55,39,39,54,54,15,15,18,18,44,44,111,111,79,79,68,68,38,38,40,40,82,82,123,123,18,18,63,63,104,104,0,0,86,86,8,8,70,70,93,93,107,107,19,19,32,32,122,122,118,118,91,91,46,46,43,43,2,2,47,47,83,83,99,99,12,12,81,81,8,8,111,111,87,87,0,0,48,48,25,25,35,35,51,51,26,26,8,8,27,27,3,3,69,69,92,92,117,117,42,42,21,21,24,24,11,11,72,72,50,50,56,56,58,58,100,100,97,97,20,20,53,53,3,3,114,114,25,25,55,55,122,122,52,52,7,7,99,99,15,15,7,7,104,104,46,46,59,59,79,79,70,70,11,11,76,76,2,2,7,7,21,21,110,110,100,100,87,87,61,61,80,80,86,86,8,8,104,104,84,84,76,76,58,58,11,11,40,40,88,88,41,41,1,1,42,42,121,121,88,88,72,72,75,75,97,97,0,0,87,87,80,80,117,117,77,77,17,17,25,25,90,90,15,15,0,0,1,1,68,68,107,107,3,3,94,94,117,117,88,88,109,109,59,59,5,5,51,51,57,57,44,44,84,84,115,115,43,43,108,108,59,59,72,72,53,53,79,79,26,26,35,35,77,77,69,69,96,96,102,102,117,117,2,2,19,19,62,62,97,97,125,125,19,19,114,114,120,120,56,56,33,33,100,100,91,91,106,106,41,41,82,82,39,39,22,22,91,91,82,82,44,44,114,114,17,17,93,93,32,32,102,102,116,116,88,88,3,3,43,43,3,3,42,42,45,45,40,40,41,41,32,32,0,0,14,14,2,2,6,6,4,4,20,20,13,13,75,75,118,118,84,84,121,121,126,126,61,61,90,90,0,0,64,64,50,50,64,64,83,83,18,18,67,67,116,116,99,99,94,94,5,5,8,8,101,101,0,0,54,54,52,52,51,51,12,12,112,112,59,59,47,47,95,95,31,31,20,20,57,57,3,3,0,0,72,72,86,86,101,101,35,35,56,56,48,48,6,6,10,10,54,54,21,21,9,9,3,3,60,60,68,68,82,82,102,102,10,10,99,99,108,108,19,19,101,101,84,84,35,35,73,73,34,34,21,21,13,13,0,0,98,98,112,112,38,38,64,64,114,114,42,42,52,52,97,97,11,11,53,53,48,48,116,116,33,33,110,110,57,57,85,85,12,12,17,17,41,41,126,126,62,62,5,5,19,19,36,36,54,54,126,126,116,116,1,1,108,108,57,57,15,15,88,88,29,29,87,87,4,4,89,89,72,72,63,63,75,75,90,90,35,35,110,110,27,27,90,90,76,76,34,34,61,61,101,101,64,64,20,20,86,86,60,60,33,33,45,45,15,15,122,122,105,105,67,67,89,89,117,117,108,108,50,50,76,76,72,72,7,7,11,11,22,22,89,89,21,21,64,64,76,76,127,127,66,66,17,17,84,84,33,33,110,110,32,32,93,93,48,48,104,104,89,89,53,53,125,125,82,82,78,78,3,3,31,31,89,89,99,99,64,64,121,121,18,18,104,104,53,53,55,55,14,14,51,51,97,97,80,80,40,40,21,21,32,32,84,84,113,113,111,111,86,86,7,7,113,113,0,0,37,37,4,4,120,120,22,22,5,5,18,18,8,8,76,76,20,20,5,5,100,100,2,2,100,100,125,125,25,25,11,11,32,32,117,117,81,81,40,40,122,122,63,63,26,26,79,79,108,108,30,30,39,39,74,74,58,58,70,70,46,46,10,10,27,27,119,119,7,7,81,81,0,0,37,37,75,75,62,62,11,11,126,126,108,108,97,97,101,101,118,118,33,33,14,14,16,16,102,102,0,0,1,1,62,62,37,37,122,122,1,1,85,85,99,99,85,85,68,68,95,95,75,75,113,113,103,103,113,113,108,108,109,109,8,8,72,72,26,26,32,32,90,90,54,54,34,34,83,83,3,3,76,76,7,7,96,96,98,98,17,17,118,118,17,17,101,101,4,4,0,0,8,8,74,74,90,90,80,80,23,23,32,32,15,15,90,90,6,6,83,83,72,72,54,54,87,87,112,112,0,0,107,107,37,37,9,9,95,95,116,116,15,15,66,66,9,9,8,8,3,3,95,95,105,105,123,123,62,62,40,40,38,38,33,33,76,76,11,11,0,0,121,121,0,0,82,82,93,93,121,121,96,96,72,72,84,84,37,37,106,106,51,51,106,106,7,7,11,11,116,116,121,121,82,82,66,66,99,99,107,107,125,125,53,53,120,120,81,81,93,93,36,36,6,6,115,115,126,126,75,75,78,78,104,104,29,29,35,35,0,0,2,2,47,47,25,25,21,21,24,24,98,98,31,31,80,80,6,6,11,11,95,95,48,48,61,61,114,114,65,65,119,119,88,88,104,104,12,12,109,109,120,120,81,81,1,1,73,73,112,112,124,124,95,95,10,10,68,68,108,108,103,103,106,106,3,3,98,98,50,50,17,17,78,78,28,28,113,113,46,46,111,111,103,103,120,120,125,125,54,54,109,109,36,36,29,29,74,74,125,125,5,5,33,33,102,102,26,26,90,90,48,48,24,24,45,45,72,72,28,28,123,123,39,39,118,118,72,72,63,63,47,47,113,113,20,20,19,19,20,20,6,6,16,16,99,99,99,99,20,20,10,10,114,114,125,125,27,27,83,83,108,108,65,65,107,107,5,5,75,75,72,72,18,18,31,31,20,20,22,22,30,30,39,39,88,88,86,86,56,56,7,7,57,57,65,65,88,88,100,100,84,84,19,19,38,38,90,90,91,91,4,4,27,27,17,17,120,120,60,60,77,77,41,41,39,39,32,32,122,122,32,32,68,68,13,13,80,80,106,106,106,106,75,75,85,85,118,118,70,70,36,36,98,98,1,1,94,94,116,116,95,95,34,34,96,96,59,59,49,49,17,17,112,112,71,71,72,72,89,89,33,33,45,45,33,33,54,54,75,75,25,25,81,81,98,98,12,12,94,94,40,40,78,78,93,93,51,51,104,104,124,124,27,27,40,40,51,51,52,52,69,69,65,65,7,7,25,25,43,43,86,86,3,3,80,80,102,102,67,67,101,101,57,57,73,73,69,69,32,32,45,45,80,80,0,0,26,26,84,84,117,117,0,0,4,4,108,108,87,87,66,66,6,6,56,56,30,30,41,41,73,73,114,114,27,27,34,34,106,106,127,127,30,30,66,66,43,43,29,29,28,28,71,71,108,108,123,123,34,34,113,113,35,35,97,97,30,30,46,46,62,62,99,99,20,20,112,112,91,91,38,38,11,11,60,60,114,114,107,107,39,39,92,92,12,12,93,93,76,76,97,97,49,49,80,80,18,18,79,79,57,57,21,21,6,6,102,102,10,10,40,40,64,64,85,85,0,0,96,96,69,69,59,59,102,102,100,100,127,127,40,40,111,111,77,77,96,96,9,9,85,85,62,62,7,7,13,13,45,45,94,94,75,75,18,18,35,35,73,73,65,65,11,11,118,118,56,56,120,120,92,92,5,5,120,120,35,35,28,28,127,127,122,122,28,28,17,17,125,125,12,12,75,75,89,89,84,84,124,124,18,18,103,103,125,125,98,98,56,56,56,56,57,57,35,35,101,101,127,127,106,106,36,36,95,95,84,84,99,99,7,7,74,74,83,83,122,122,25,25,17,17,73,73,32,32,34,34,103,103,24,24,26,26,5,5,69,69,85,85,72,72,96,96,6,6,65,65,110,110,18,18,49,49,50,50,35,35,71,71,114,114,96,96,111,111,89,89,18,18,98,98,71,71,69,69,66,66,12,12,83,83,3,3,114,114,29,29,9,9,82,82,59,59,69,69,114,114,48,48,32,32,80,80,30,30,96,96,76,76,82,82,38,38,51,51,112,112,20,20,114,114,54,54,18,18,28,28,112,112,15,15,92,92,8,8,28,28,92,92,94,94,28,28,123,123,99,99,50,50,70,70,26,26,15,15,21,21,45,45,124,124,0,0,61,61,89,89,57,57,82,82,63,63,43,43,98,98,98,98,17,17,96,96,55,55,44,44,18,18,106,106,87,87,24,24,89,89,15,15,110,110,15,15,110,110,50,50,112,112,74,74,39,39,74,74,42,42,65,65,23,23,2,2,69,69,93,93,118,118,52,52,105,105,117,117,68,68,38,38,90,90,58,58,44,44,76,76,78,78,80,80,126,126,47,47,56,56,108,108,75,75,44,44,79,79,89,89,7,7,125,125,113,113,117,117,115,115,39,39,87,87,3,3,88,88,114,114,48,48,71,71,75,75,112,112,109,109,115,115,64,64,119,119,71,71,85,85,10,10,35,35,51,51,42,42,66,66,113,113,43,43,27,27,34,34,71,71,83,83,95,95,30,30,50,50,15,15,58,58,66,66,85,85,68,68,32,32,78,78,105,105,49,49,70,70,50,50,67,67,85,85,35,35,23,23,90,90,18,18,122,122,52,52,85,85,26,26,38,38,37,37,58,58,69,69,48,48,98,98,89,89,72,72,47,47,63,63,44,44,8,8,93,93,0,0,109,109,101,101,36,36,70,70,101,101,89,89,57,57,43,43,111,111,51,51,78,78,15,15,41,41,9,9,6,6,68,68,10,10,59,59,75,75,78,78,19,19,22,22,104,104,69,69,90,90,120,120,104,104,83,83,68,68,56,56,23,23,6,6,104,104,13,13,100,100,12,12,92,92,26,26,116,116,121,121,41,41,105,105,24,24,118,118,84,84,32,32,87,87,12,12,58,58,10,10,61,61,38,38,34,34,47,47,97,97,65,65,5,5,49,49,26,26,76,76,86,86,25,25,77,77,58,58,57,57,13,13,27,27,44,44,3,3,60,60,31,31,48,48,114,114,89,89,35,35,29,29,52,52,95,95,24,24,66,66,39,39,120,120,0,0,47,47,26,26,34,34,13,13,97,97,113,113,95,95,2,2,119,119,75,75,44,44,26,26,77,77,23,23,42,42,114,114,40,40,24,24,14,14,94,94,0,0,22,22,82,82,89,89,101,101,28,28,10,10,18,18,106,106,40,40,6,6,38,38,72,72,66,66,96,96,89,89,19,19,100,100,121,121,36,36,105,105,12,12,122,122,71,71,21,21,0,0,18,18,1,1,12,12,43,43,98,98,116,116,0,0,127,127,57,57,32,32,69,69,114,114,31,31,26,26,75,75,4,4,18,18,66,66,18,18,32,32,2,2,53,53,62,62,53,53,82,82,58,58,116,116,48,48,96,96,22,22,85,85,85,85,103,103,71,71,21,21,58,58,100,100,69,69,84,84,106,106,42,42,22,22,98,98,104,104,45,45,42,42,99,99,122,122,31,31,87,87,19,19,69,69,87,87,10,10,27,27,53,53,38,38,95,95,98,98,53,53,50,50,119,119,60,60,29,29,27,27,100,100,60,60,78,78,64,64,24,24,48,48,96,96,31,31,126,126,47,47,24,24,71,71,61,61,93,93,2,2,0,0,67,67,13,13,113,113,112,112,94,94,38,38,102,102,2,2,127,127,19,19,1,1,29,29,9,9,17,17,98,98,117,117,19,19,10,10,16,16,57,57,116,116,93,93,89,89,40,40,33,33,79,79,14,14,60,60,24,24,92,92,7,7,37,37,79,79,18,18,83,83,51,51,106,106,101,101,41,41,20,20,87,87,90,90,66,66,37,37,35,35,51,51,10,10,114,114,77,77,35,35,81,81,100,100,105,105,122,122,72,72,37,37,57,57,73,73,22,22,19,19,2,2,5,5,92,92,88,88,29,29,97,97,88,88,124,124,1,1,125,125,120,120,61,61,45,45,34,34,123,123,111,111,90,90,72,72,118,118,0,0,101,101,2,2,61,61,19,19,90,90,117,117,122,122,60,60,117,117,120,120,116,116,123,123,45,45,70,70,87,87,9,9,89,89,85,85,69,69,106,106,114,114,118,118,46,46,86,86,75,75,112,112,91,91,19,19,16,16,95,95,80,80,29,29,40,40,68,68,102,102,68,68,59,59,34,34,112,112,39,39,103,103,35,35,87,87,47,47,120,120,62,62,30,30,40,40,96,96,90,90,87,87,109,109,27,27,88,88,42,42,15,15,52,52,68,68,118,118,13,13,89,89,12,12,13,13,70,70,42,42,38,38,11,11,71,71,30,30,107,107,12,12,40,40,19,19,123,123,126,126,124,124,72,72,126,126,27,27,127,127,22,22,92,92,98,98,32,32,30,30,56,56,84,84,41,41,1,1,13,13,21,21,48,48,85,85,11,11,89,89,89,89,14,14,75,75,77,77,16,16,101,101,0,0,29,29,40,40,113,113,109,109,41,41,42,42,24,24,68,68,19,19,44,44,33,33,87,87,62,62,48,48,7,7,43,43,49,49,5,5,74,74,112,112,34,34,42,42,67,67,68,68,107,107,116,116,51,51,43,43,20,20,26,26,1,1,33,33,26,26,101,101,12,12,30,30,24,24,69,69,76,76,73,73,19,19,12,12,26,26,41,41,93,93,43,43,53,53,38,38,54,54,112,112,57,57,80,80,62,62,50,50,113,113,73,73,86,86,37,37,81,81,3,3,64,64,39,39,97,97,20,20,80,80,54,54,64,64,30,30,66,66,67,67,109,109,13,13,76,76,87,87,15,15,11,11,60,60,63,63,66,66,12,12,107,107,73,73,49,49,127,127,67,67,34,34,45,45,51,51,61,61,106,106,54,54,30,30,15,15,83,83,92,92,84,84,55,55,8,8,34,34,9,9,0,0,50,50,0,0,106,106,42,42,21,21,39,39,18,18,15,15,40,40,67,67,51,51,56,56,98,98,45,45,103,103,82,82,76,76,9,9,92,92,4,4,119,119,2,2,70,70,62,62,13,13,120,120,105,105,47,47,18,18,52,52,6,6,2,2,121,121,34,34,57,57,27,27,2,2,103,103,42,42,71,71,90,90,40,40,51,51,106,106,113,113,96,96,120,120,95,95,111,111,82,82,13,13,78,78,25,25,5,5,48,48,59,59,3,3,97,97,101,101,47,47,72,72,21,21,37,37,78,78,4,4,14,14,71,71,41,41,45,45,30,30,125,125,120,120,78,78,32,32,14,14,62,62,28,28,35,35,3,3,11,11,37,37,51,51,120,120,31,31,21,21,1,1,101,101,106,106,59,59,51,51,13,13,41,41,32,32,62,62,80,80,25,25,34,34,24,24,121,121,60,60,47,47,84,84,2,2,38,38,66,66,121,121,20,20,70,70,67,67,126,126,36,36,79,79,72,72,25,25,63,63,93,93,14,14,8,8,121,121,126,126,124,124,115,115,8,8,122,122,16,16,85,85,7,7,70,70,86,86,80,80,44,44,92,92,72,72,44,44,46,46,28,28,64,64,27,27,89,89,113,113,46,46,23,23,14,14,0,0,26,26,116,116,88,88,122,122,22,22,12,12,18,18,97,97,50,50,16,16,53,53,32,32,80,80,22,22,70,70,9,9,41,41,16,16,116,116,35,35,45,45,4,4,15,15,57,57,23,23,43,43,73,73,64,64,5,5,20,20,116,116,14,14,115,115,102,102,43,43,0,0,100,100,79,79,35,35,49,49,121,121,126,126,65,65,92,92,88,88,73,73,56,56,42,42,88,88,51,51,76,76,1,1,22,22,102,102,25,25,51,51,106,106,6,6,80,80,107,107,119,119,53,53,100,100,60,60,17,17,76,76,64,64,96,96,18,18,97,97,38,38,78,78,109,109,5,5,83,83,64,64,27,27,112,112,88,88,0,0,90,90,49,49,114,114,0,0,99,99,3,3,55,55,5,5,96,96,28,28,73,73,10,10,30,30,43,43,18,18,74,74,64,64,31,31,10,10,71,71,125,125,76,76,70,70,127,127,52,52,66,66,12,12,117,117,15,15,66,66,21,21,12,12,32,32,87,87,37,37,57,57,87,87,40,40,51,51,116,116,5,5,39,39,53,53,20,20,48,48,103,103,81,81,9,9,4,4,104,104,6,6,111,111,67,67,122,122,30,30,97,97,80,80,115,115,18,18,72,72,30,30,106,106,93,93,94,94,98,98,66,66,73,73,57,57,90,90,86,86,49,49,89,89,42,42,116,116,117,117,67,67,16,16,6,6,16,16,9,9,29,29,37,37,104,104,102,102,74,74,68,68,88,88,55,55,88,88,45,45,9,9,92,92,125,125,50,50,50,50,22,22,121,121,60,60,8,8,51,51,6,6,90,90,0,0,38,38,83,83,54,54,61,61,15,15,104,104,6,6,18,18,89,89,63,63,16,16,22,22,83,83,121,121,39,39,77,77,91,91,27,27,21,21,10,10,57,57,55,55,0,0,30,30,10,10,107,107,51,51,4,4,103,103,41,41,36,36,56,56,66,66,0,0,75,75,109,109,45,45,101,101,107,107,96,96,38,38,89,89,51,51,57,57,59,59,60,60,118,118,121,121,99,99,120,120,13,13,85,85,99,99,106,106,31,31,51,51,29,29,66,66,101,101,54,54,90,90,100,100,29,29,74,74,25,25,39,39,0,0,31,31,88,88,77,77,3,3,11,11,93,93,4,4,72,72,114,114,1,1,28,28,113,113,109,109,125,125,126,126,2,2,76,76,86,86,7,7,83,83,110,110,83,83,83,83,23,23,117,117,53,53,37,37,100,100,71,71,61,61,14,14,64,64,98,98,82,82,32,32,98,98,97,97,80,80,85,85,113,113,0,0,69,69,78,78,71,71,33,33,44,44,19,19,6,6,100,100,111,111,20,20,31,31,111,111,46,46,50,50,20,20,103,103,46,46,120,120,9,9,88,88,7,7,55,55,57,57,106,106,59,59,111,111,97,97,25,25,103,103,50,50,77,77,37,37,86,86,1,1,86,86,85,85,99,99,56,56,32,32,36,36,90,90,105,105,120,120,116,116,44,44,77,77,82,82,45,45,1,1,98,98,40,40,53,53,73,73,75,75,125,125,10,10,91,91,48,48,43,43,58,58,53,53,11,11,125,125,107,107,53,53,14,14,88,88,82,82,52,52,49,49,56,56,21,21,66,66,48,48,23,23,69,69,103,103,117,117,22,22,15,15,92,92,7,7,36,36,18,18,127,127,55,55,98,98,36,36,8,8,23,23,80,80,41,41,82,82,5,5,18,18,29,29,33,33,22,22,28,28,118,118,17,17,35,35,47,47,122,122,57,57,84,84,112,112,23,23,33,33,90,90,27,27,23,23,90,90,1,1,97,97,1,1,124,124,44,44,99,99,125,125,50,50,86,86,11,11,87,87,46,46,52,52,44,44,8,8,49,49,10,10,62,62,8,8,82,82,53,53,105,105,18,18,63,63,116,116,66,66,36,36,17,17,123,123,103,103,88,88,123,123,27,27,127,127,127,127,112,112,67,67,11,11,94,94,37,37,16,16,91,91,85,85,36,36,54,54,59,59,22,22,78,78,76,76,3,3,74,74,12,12,99,99,8,8,66,66,105,105,97,97,100,100,23,23,5,5,78,78,40,40,3,3,81,81,17,17,11,11,72,72,82,82,103,103,12,12,125,125,98,98,36,36,14,14,7,7,7,7,73,73,93,93,125,125,108,108,48,48,106,106,10,10,77,77,16,16,48,48,43,43,62,62,53,53,88,88,63,63,79,79,107,107,67,67,19,19,82,82,101,101,24,24,124,124,98,98,18,18,6,6,102,102,3,3,83,83,28,28,86,86,34,34,18,18,47,47,44,44,43,43,75,75,112,112,125,125,10,10,103,103,80,80,66,66,22,22,9,9,39,39,82,82,85,85,115,115,0,0,52,52,50,50,82,82,40,40,78,78,120,120,18,18,50,50,103,103,103,103,42,42,81,81,83,83,30,30,38,38,91,91,0,0,2,2,57,57,3,3,117,117,99,99,120,120,50,50,69,69,29,29,52,52,124,124,80,80,72,72,40,40,10,10,9,9,118,118,111,111,54,54,115,115,73,73,115,115,6,6,124,124,91,91,101,101,60,60,0,0,117,117,83,83,5,5,102,102,78,78,17,17,124,124,56,56,54,54,115,115,43,43,50,50,13,13,50,50,45,45,57,57,96,96,59,59,103,103,116,116,0,0,100,100,92,92,83,83,61,61,31,31,87,87,94,94,99,99,8,8,64,64,123,123,92,92,91,91,20,20,126,126,59,59,93,93,118,118,97,97,15,15,102,102,64,64,92,92,67,67,26,26,76,76,32,32,60,60,63,63,106,106,0,0,59,59,62,62,104,104,51,51,95,95,13,13,11,11,82,82,91,91,44,44,66,66,41,41,102,102,88,88,11,11,32,32,120,120,32,32,63,63,82,82,5,5,6,6,45,45,79,79,41,41,20,20,14,14,59,59,13,13,82,82,22,22,54,54,109,109,96,96,127,127,92,92,48,48,23,23,57,57,59,59,16,16,19,19,89,89,78,78,113,113,15,15,97,97,72,72,86,86,29,29,5,5,5,5,103,103,40,40,70,70,106,106,77,77,53,53,10,10,108,108,43,43,5,5,5,5,97,97,55,55,73,73,72,72,92,92,69,69,0,0,27,27,123,123,63,63,32,32,8,8,25,25,0,0,61,61,47,47,107,107,34,34,100,100,2,2,19,19,96,96,34,34,33,33,66,66,57,57,19,19,35,35,71,71,91,91,32,32,48,48,42,42,84,84,88,88,121,121,45,45,127,127,89,89,12,12,61,61,54,54,96,96,104,104,44,44,74,74,36,36,124,124,75,75,98,98,30,30,8,8,70,70,42,42,74,74,55,55,80,80,29,29,46,46,72,72,93,93,69,69,1,1,67,67,58,58,14,14,125,125,41,41,65,65,108,108,65,65,100,100,65,65,108,108,106,106,53,53,119,119,118,118,96,96,79,79,54,54,78,78,6,6,87,87,42,42,98,98,85,85,6,6,16,16,66,66,46,46,62,62,104,104,94,94,11,11,80,80,123,123,3,3,79,79,43,43,122,122,41,41,108,108,78,78,113,113,62,62,57,57,85,85,114,114,19,19,33,33,27,27,16,16,71,71,121,121,70,70,9,9,73,73,117,117,115,115,67,67,72,72,34,34,95,95,65,65,91,91,35,35,83,83,64,64,49,49,35,35,49,49,21,21,85,85,33,33,94,94,71,71,111,111,67,67,89,89,38,38,112,112,78,78,36,36,41,41,74,74,119,119,38,38,51,51,106,106,24,24,49,49,12,12,100,100,98,98,118,118,26,26,53,53,81,81,69,69,87,87,124,124,94,94,108,108,77,77,50,50,66,66,51,51,43,43,84,84,37,37,52,52,80,80,19,19,29,29,14,14,96,96,54,54,51,51,65,65,118,118,62,62,89,89,22,22,13,13,21,21,62,62,17,17,96,96,106,106,118,118,91,91,0,0,65,65,109,109,81,81,65,65,78,78,105,105,6,6,64,64,61,61,90,90,57,57,76,76,20,20,114,114,110,110,52,52,26,26,124,124,118,118,85,85,54,54,84,84,67,67,18,18,78,78,60,60,54,54,38,38,99,99,7,7,12,12,94,94,80,80,9,9,104,104,119,119,71,71,74,74,53,53,72,72,92,92,114,114,105,105,38,38,78,78,2,2,91,91,5,5,92,92,107,107,10,10,91,91,43,43,79,79,82,82,6,6,92,92,94,94,111,111,56,56,40,40,6,6,66,66,105,105,16,16,107,107,14,14,76,76,116,116,72,72,27,27,113,113,6,6,5,5,8,8,24,24,115,115,52,52,103,103,5,5,8,8,0,0,121,121,62,62,97,97,35,35,34,34,7,7,50,50,48,48,88,88,72,72,31,31,91,91,78,78,82,82,46,46,88,88,51,51,12,12,100,100,60,60,57,57,63,63,26,26,67,67,73,73,33,33,48,48,111,111,3,3,98,98,0,0,72,72,121,121,15,15,96,96,28,28,124,124,8,8,17,17,100,100,8,8,123,123,33,33,66,66,0,0,72,72,16,16,73,73,29,29,82,82,42,42,48,48,67,67,36,36,53,53,32,32,41,41,122,122,109,109,102,102,39,39,6,6,100,100,5,5,66,66,62,62,49,49,71,71,44,44,50,50,81,81,61,61,102,102,65,65,124,124,92,92,5,5,1,1,13,13,119,119,103,103,94,94,109,109,73,73,3,3,32,32,88,88,42,42,111,111,103,103,38,38,118,118,98,98,84,84,19,19,69,69,12,12,17,17,104,104,47,47,115,115,21,21,118,118,41,41,51,51,92,92,56,56,42,42,24,24,14,14,84,84,73,73,15,15,120,120,98,98,119,119,82,82,74,74,26,26,80,80,48,48,41,41,32,32,107,107,83,83,38,38,39,39,105,105,104,104,70,70,61,61,62,62,83,83,97,97,113,113,127,127,8,8,103,103,109,109,71,71,33,33,88,88,10,10,88,88,44,44,6,6,24,24,9,9,117,117,91,91,41,41,56,56,38,38,87,87,35,35,71,71,112,112,86,86,92,92,64,64,75,75,121,121,70,70,28,28,56,56,58,58,79,79,57,57,38,38,61,61,33,33,98,98,28,28,31,31,97,97,20,20,102,102,90,90,26,26,95,95,12,12,43,43,48,48,9,9,63,63,0,0,127,127,17,17,77,77,83,83,49,49,12,12,116,116,94,94,113,113,97,97,32,32,103,103,64,64,19,19,15,15,75,75,15,15,11,11,26,26,10,10,60,60,54,54,7,7,33,33,30,30,99,99,72,72,7,7,101,101,113,113,94,94,81,81,56,56,47,47,41,41,95,95,10,10,110,110,76,76,10,10,6,6,91,91,16,16,99,99,61,61,111,111,108,108,33,33,116,116,95,95,71,71,11,11,23,23,0,0,89,89,78,78,117,117,69,69,61,61,95,95,127,127,11,11,22,22,105,105,7,7,91,91,98,98,70,70,97,97,116,116,107,107,63,63,14,14,109,109,113,113,63,63,73,73,72,72,40,40,49,49,98,98,112,112,55,55,4,4,115,115,51,51,58,58,14,14,58,58,49,49,70,70,2,2,32,32,56,56,72,72,50,50,46,46,116,116,97,97,31,31,91,91,51,51,17,17,3,3,38,38,33,33,3,3,29,29,6,6,70,70,33,33,12,12,65,65,84,84,115,115,124,124,24,24,102,102,57,57,71,71,21,21,38,38,22,22,76,76,92,92,9,9,84,84,44,44,14,14,44,44,111,111,2,2,45,45,13,13,33,33,47,47,84,84,86,86,54,54,32,32,31,31,74,74,23,23,12,12,86,86,20,20,7,7,9,9,87,87,52,52,76,76,126,126,104,104,86,86,3,3,54,54,90,90,65,65,84,84,122,122,126,126,43,43,65,65,58,58,109,109,80,80,122,122,106,106,122,122,112,112,45,45,126,126,41,41,41,41,84,84,75,75,33,33,22,22,32,32,65,65,119,119,81,81,16,16,23,23,30,30,38,38,90,90,47,47,78,78,77,77,38,38,4,4,112,112,77,77,104,104,93,93,84,84,37,37,55,55,26,26,26,26,42,42,93,93,49,49,83,83,76,76,119,119,59,59,118,118,74,74,55,55,92,92,43,43,40,40,26,26,96,96,37,37,85,85,65,65,90,90,114,114,20,20,94,94,2,2,73,73,39,39,91,91,50,50,10,10,49,49,7,7,58,58,101,101,99,99,80,80,5,5,29,29,29,29,73,73,87,87,5,5,31,31,104,104,49,49,118,118,76,76,108,108,75,75,86,86,4,4,100,100,98,98,72,72,122,122,98,98,0,0,10,10,84,84,104,104,64,64,52,52,26,26,34,34,25,25,81,81,40,40,96,96,35,35,14,14,52,52,48,48,98,98,53,53,23,23,82,82,3,3,84,84,46,46,7,7,1,1,117,117,59,59,121,121,25,25,16,16,126,126,83,83,32,32,17,17,125,125,100,100,9,9,83,83,41,41,18,18,39,39,25,25,92,92,12,12,17,17,64,64,1,1,105,105,3,3,8,8,84,84,28,28,117,117,25,25,64,64,35,35,68,68,85,85,88,88,80,80,0,0,43,43,79,79,18,18,32,32,9,9,122,122,57,57,120,120,40,40,16,16,108,108,35,35,66,66,74,74,77,77,17,17,92,92,67,67,12,12,111,111,100,100,51,51,12,12,127,127,65,65,76,76,26,26,65,65,103,103,106,106,93,93,89,89,82,82,112,112,25,25,66,66,19,19,86,86,78,78,52,52,37,37,73,73,15,15,71,71,123,123,14,14,84,84,48,48,59,59,76,76,19,19,21,21,59,59,124,124,77,77,79,79,60,60,51,51,25,25,110,110,45,45,116,116,16,16,66,66,54,54,124,124,16,16,117,117,87,87,88,88,61,61,86,86,75,75,112,112,108,108,106,106,120,120,78,78,28,28,53,53,42,42,72,72,38,38,112,112,20,20,25,25,10,10,80,80,32,32,58,58,98,98,4,4,122,122,40,40,24,24,95,95,34,34,41,41,23,23,28,28,3,3,39,39,52,52,127,127,41,41,40,40,93,93,47,47,64,64,70,70,78,78,10,10,104,104,123,123,34,34,64,64,104,104,105,105,100,100,45,45,10,10,5,5,79,79,74,74,9,9,126,126,20,20,82,82,42,42,24,24,66,66,80,80,32,32,73,73,21,21,110,110,113,113,39,39,126,126,93,93,22,22,20,20,16,16,73,73,2,2,26,26,85,85,22,22,127,127,17,17,67,67,17,17,57,57,101,101,0,0,34,34,99,99,16,16,8,8,15,15,68,68,67,67,26,26,68,68,109,109,44,44,18,18,119,119,116,116,21,21,121,121,28,28,126,126,34,34,54,54,24,24,88,88,102,102,93,93,62,62,61,61,42,42,38,38,127,127,51,51,56,56,127,127,81,81,122,122,86,86,1,1,43,43,18,18,54,54,6,6,51,51,105,105,44,44,96,96,5,5,104,104,40,40,84,84,101,101,58,58,5,5,112,112,85,85,111,111,36,36,120,120,88,88,20,20,78,78,17,17,37,37,94,94,106,106,89,89,36,36,119,119,22,22,36,36,126,126,18,18,105,105,15,15,14,14,48,48,48,48,117,117,27,27,8,8,49,49,17,17,9,9,95,95,83,83,116,116,4,4,91,91,52,52,76,76,78,78,2,2,0,0,27,27,79,79,34,34,72,72,7,7,2,2,4,4,17,17,88,88,21,21,74,74,88,88,93,93,11,11,61,61,18,18,47,47,53,53,107,107,109,109,57,57,1,1,24,24,13,13,5,5,3,3,52,52,68,68,112,112,78,78,58,58,62,62,25,25,29,29,25,25,108,108,53,53,72,72,39,39,69,69,123,123,88,88,91,91,91,91,81,81,98,98,110,110,77,77,113,113,33,33,11,11,55,55,96,96,101,101,57,57,121,121,84,84,87,87,64,64,84,84,76,76,94,94,89,89,28,28,17,17,122,122,6,6,108,108,0,0,31,31,12,12,123,123,59,59,23,23,121,121,24,24,26,26,110,110,10,10,121,121,84,84,34,34,61,61,101,101,19,19,99,99,50,50,17,17,108,108,108,108,101,101,116,116,111,111,112,112,46,46,91,91,67,67,91,91,32,32,65,65,75,75,0,0,45,45,94,94,37,37,70,70,28,28,110,110,91,91,116,116,44,44,46,46,43,43,49,49,89,89,9,9,87,87,40,40,29,29,79,79,88,88,40,40,32,32,30,30,35,35,100,100,49,49,108,108,88,88,111,111,122,122,49,49,15,15,92,92,103,103,36,36,12,12,2,2,120,120,63,63,83,83,39,39,35,35,95,95,101,101,33,33,50,50,22,22,56,56,67,67,24,24,98,98,34,34,45,45,58,58,25,25,31,31,114,114,71,71,91,91,69,69,81,81,21,21,89,89,19,19,81,81,16,16,99,99,46,46,55,55,75,75,72,72,105,105,122,122,78,78,1,1,1,1,38,38,60,60,113,113,78,78,100,100,31,31,41,41,26,26,8,8,105,105,13,13,71,71,10,10,43,43,1,1,30,30,20,20,27,27,119,119,17,17,15,15,94,94,45,45,34,34,64,64,29,29,120,120,64,64,114,114,20,20,85,85,34,34,20,20,107,107,64,64,0,0,124,124,64,64,64,64,0,0,33,33,57,57,69,69,113,113,17,17,91,91,122,122,102,102,19,19,17,17,35,35,34,34,90,90,99,99,29,29,106,106,23,23,117,117,24,24,50,50,44,44,24,24,64,64,81,81,123,123,44,44,58,58,66,66,65,65,28,28,54,54,21,21,98,98,79,79,70,70,53,53,96,96,52,52,39,39,86,86,70,70,38,38,22,22,5,5,13,13,25,25,26,26,110,110,67,67,51,51,1,1,66,66,107,107,114,114,23,23,10,10,10,10,12,12,68,68,122,122,18,18,80,80,19,19,105,105,67,67,53,53,35,35,40,40,106,106,64,64,66,66,39,39,32,32,67,67,20,20,0,0,80,80,36,36,70,70,29,29,5,5,104,104,86,86,22,22,77,77,41,41,38,38,93,93,100,100,3,3,23,23,30,30,9,9,23,23,112,112,34,34,40,40,12,12,0,0,70,70,30,30,110,110,55,55,22,22,9,9,13,13,108,108,105,105,83,83,101,101,4,4,96,96,43,43,67,67,20,20,103,103,90,90,86,86,71,71,107,107,115,115,26,26,55,55,23,23,53,53,52,52,47,47,35,35,38,38,66,66,58,58,40,40,86,86,89,89,92,92,50,50,28,28,87,87,123,123,91,91,94,94,80,80,100,100,1,1,34,34,98,98,110,110,56,56,16,16,55,55,77,77,71,71,12,12,47,47,120,120,38,38,111,111,103,103,110,110,75,75,123,123,85,85,48,48,20,20,120,120,75,75,36,36,90,90,84,84,104,104,34,34,35,35,31,31,116,116,15,15,118,118,29,29,36,36,106,106,15,15,46,46,48,48,57,57,107,107,4,4,6,6,53,53,22,22,107,107,74,74,98,98,75,75,64,64,84,84,122,122,67,67,82,82,38,38,112,112,126,126,84,84,103,103,83,83,21,21,102,102,29,29,2,2,5,5,19,19,72,72,83,83,52,52,107,107,18,18,76,76,7,7,69,69,57,57,118,118,112,112,71,71,1,1,18,18,67,67,101,101,35,35,126,126,4,4,56,56,59,59,16,16,42,42,96,96,56,56,41,41,29,29,53,53,93,93,64,64,34,34,18,18,44,44,54,54,21,21,68,68,81,81,32,32,121,121,46,46,63,63,82,82,26,26,92,92,0,0,117,117,111,111,100,100,30,30,85,85,104,104,79,79,44,44,17,17,123,123,83,83,65,65,90,90,101,101,99,99,18,18,25,25,55,55,72,72,115,115,105,105,103,103,73,73,103,103,27,27,54,54,117,117,113,113,100,100,21,21,109,109,94,94,83,83,44,44,55,55,24,24,49,49,13,13,105,105,68,68,4,4,62,62,113,113,58,58,112,112,51,51,58,58,96,96,90,90,81,81,39,39,66,66,46,46,118,118,122,122,1,1,41,41,64,64,76,76,22,22,26,26,73,73,32,32,119,119,78,78,127,127,37,37,20,20,52,52,12,12,125,125,80,80,3,3,81,81,4,4,91,91,64,64,108,108,25,25,49,49,110,110,38,38,70,70,69,69,6,6,71,71,94,94,42,42,34,34,94,94,50,50,31,31,109,109,33,33,78,78,82,82,63,63,71,71,85,85,102,102,62,62,123,123,64,64,30,30,100,100,106,106,107,107,109,109,69,69,28,28,16,16,43,43,10,10,35,35,20,20,18,18,36,36,20,20,105,105,62,62,68,68,76,76,32,32,72,72,70,70,58,58,119,119,87,87,44,44,28,28,84,84,18,18,102,102,86,86,60,60,26,26,19,19,110,110,99,99,64,64,4,4,24,24,75,75,58,58,52,52,11,11,13,13,68,68,13,13,52,52,32,32,13,13,8,8,8,8,85,85,67,67,12,12,63,63,42,42,51,51,59,59,104,104,16,16,31,31,36,36,8,8,88,88,102,102,9,9,48,48,97,97,38,38,86,86,120,120,34,34,52,52,107,107,5,5,75,75,55,55,72,72,98,98,84,84,12,12,13,13,104,104,65,65,81,81,87,87,81,81,21,21,60,60,117,117,93,93,83,83,70,70,86,86,48,48,98,98,122,122,91,91,42,42,100,100,106,106,28,28,118,118,58,58,79,79,110,110,60,60,122,122,126,126,115,115,60,60,82,82,84,84,16,16,56,56,106,106,29,29,31,31,77,77,12,12,44,44,8,8,2,2,6,6,61,61,56,56,40,40,27,27,10,10,103,103,97,97,71,71,64,64,29,29,27,27,31,31,73,73,6,6,62,62,55,55,22,22,89,89,55,55,67,67,99,99,1,1,65,65,107,107,18,18,77,77,65,65,23,23,39,39,112,112,23,23,32,32,90,90,66,66,15,15,85,85,44,44,53,53,42,42,35,35,73,73,40,40,50,50,104,104,125,125,110,110,46,46,82,82,12,12,45,45,44,44,109,109,19,19,118,118,8,8,8,8,115,115,21,21,7,7,103,103,45,45,22,22,60,60,59,59,52,52,61,61,112,112,117,117,24,24,94,94,1,1,68,68,109,109,42,42,116,116,32,32,36,36,105,105,22,22,92,92,117,117,84,84,11,11,89,89,40,40,12,12,86,86,81,81,43,43,91,91,47,47,16,16,126,126,97,97,18,18,124,124,3,3,20,20,57,57,80,80,120,120,34,34,75,75,43,43,69,69,51,51,18,18,21,21,95,95,90,90,62,62,2,2,125,125,71,71,61,61,123,123,5,5,91,91,71,71,52,52,10,10,88,88,29,29,86,86,66,66,98,98,62,62,36,36,115,115,36,36,34,34,39,39,41,41,96,96,8,8,2,2,112,112,55,55,97,97,57,57,47,47,48,48,9,9,85,85,29,29,17,17,73,73,75,75,65,65,49,49,2,2,48,48,81,81,116,116,12,12,117,117,87,87,123,123,6,6,91,91,18,18,8,8,22,22,18,18,19,19,9,9,117,117,23,23,51,51,1,1,45,45,27,27,2,2,1,1,62,62,69,69,79,79,21,21,124,124,109,109,54,54,121,121,95,95,41,41,117,117,114,114,44,44,65,65,108,108,94,94,107,107,96,96,75,75,92,92,79,79,2,2,31,31,12,12,55,55,12,12,32,32,87,87,72,72,33,33,55,55,48,48,118,118,65,65,103,103,8,8,6,6,2,2,34,34,77,77,125,125,91,91,97,97,99,99,30,30,63,63,8,8,107,107,27,27,61,61,28,28,116,116,42,42,39,39,93,93,51,51,115,115,8,8,21,21,20,20,82,82,98,98,120,120,124,124,97,97,34,34,42,42,73,73,69,69,51,51,72,72,94,94,114,114,119,119,41,41,88,88,0,0,33,33,42,42,113,113,127,127,122,122,80,80,98,98,98,98,10,10,30,30,87,87,68,68,12,12,54,54,124,124,50,50,113,113,87,87,125,125,55,55,4,4,47,47,49,49,92,92,54,54,30,30,59,59,86,86,14,14,17,17,97,97,75,75,8,8,38,38,58,58,112,112,56,56,7,7,48,48,49,49,25,25,76,76,106,106,103,103,32,32,104,104,96,96,17,17,103,103,10,10,98,98,89,89,33,33,106,106,20,20,125,125,122,122,71,71,2,2,4,4,98,98,84,84,38,38,43,43,57,57,73,73,70,70,29,29,23,23,26,26,33,33,84,84,116,116,66,66,28,28,65,65,28,28,9,9,61,61,64,64,3,3,80,80,33,33,127,127,75,75,41,41,4,4,16,16,101,101,37,37,121,121,71,71,127,127,48,48,69,69,107,107,33,33,47,47,15,15,100,100,17,17,73,73,113,113,83,83,9,9,125,125,72,72,11,11,66,66,37,37,103,103,96,96,93,93,59,59,107,107,9,9,2,2,48,48,43,43,26,26,69,69,74,74,77,77,59,59,94,94,26,26,52,52,0,0,61,61,70,70,112,112,37,37,112,112,91,91,101,101,74,74,43,43,113,113,106,106,51,51,8,8,35,35,61,61,11,11,15,15,2,2,44,44,58,58,43,43,78,78,116,116,115,115,118,118,0,0,6,6,18,18,20,20,103,103,70,70,87,87,89,89,45,45,121,121,0,0,19,19,90,90,100,100,35,35,121,121,29,29,115,115,37,37,61,61,65,65,111,111,34,34,80,80,42,42,35,35,42,42,109,109,84,84,98,98,58,58,70,70,55,55,85,85,122,122,12,12,1,1,49,49,1,1,5,5,57,57,96,96,126,126,71,71,46,46,30,30,126,126,63,63,54,54,113,113,92,92,51,51,80,80,64,64,86,86,19,19,44,44,99,99,72,72,0,0,59,59,74,74,125,125,67,67,45,45,19,19,72,72,116,116,79,79,26,26,64,64,30,30,6,6,89,89,102,102,12,12,102,102,81,81,115,115,113,113,29,29,24,24,46,46,111,111,35,35,115,115,45,45,64,64,41,41,93,93,71,71,63,63,65,65,73,73,64,64,48,48,30,30,94,94,96,96,1,1,1,1,66,66,18,18,67,67,46,46,8,8,35,35,33,33,26,26,44,44,107,107,111,111,91,91,116,116,12,12,34,34,118,118,53,53,1,1,118,118,42,42,24,24,20,20,61,61,25,25,45,45,93,93,33,33,78,78,100,100,20,20,91,91,36,36,13,13,40,40,35,35,40,40,40,40,12,12,32,32,44,44,7,7,110,110,75,75,73,73,14,14,16,16,12,12,125,125,105,105,59,59,102,102,33,33,68,68,48,48,94,94,68,68,101,101,43,43,56,56,39,39,61,61,108,108,5,5,56,56,91,91,30,30,70,70,118,118,114,114,112,112,52,52,47,47,13,13,36,36,60,60,72,72,45,45,112,112,76,76,10,10,104,104,10,10,66,66,36,36,116,116,32,32,110,110,22,22,7,7,30,30,20,20,105,105,62,62,45,45,0,0,69,69,60,60,41,41,96,96,32,32,80,80,56,56,88,88,2,2,78,78,23,23,116,116,116,116,5,5,122,122,79,79,62,62,13,13,25,25,59,59,22,22,6,6,0,0,5,5,63,63,2,2,121,121,26,26,127,127,90,90,48,48,78,78,6,6,54,54,61,61,61,61,56,56,80,80,109,109,69,69,19,19,36,36,24,24,114,114,66,66,80,80,84,84,81,81,11,11,103,103,122,122,127,127,70,70,116,116,3,3,115,115,105,105,126,126,74,74,112,112,121,121,23,23,98,98,100,100,71,71,44,44,100,100,70,70,48,48,66,66,39,39,93,93,95,95,101,101,24,24,112,112,40,40,113,113,15,15,4,4,92,92,88,88,125,125,41,41,4,4,52,52,29,29,79,79,91,91,62,62,8,8,30,30,127,127,91,91,15,15,50,50,57,57,66,66,36,36,68,68,22,22,76,76,127,127,56,56,76,76,54,54,52,52,49,49,25,25,121,121,105,105,74,74,65,65,50,50,88,88,73,73,119,119,96,96,115,115,12,12,116,116,84,84,82,82,92,92,22,22,79,79,48,48,126,126,21,21,69,69,68,68,43,43,81,81,6,6,85,85,121,121,98,98,93,93,24,24,22,22,51,51,38,38,71,71,20,20,76,76,40,40,3,3,59,59,42,42,38,38,116,116,22,22,35,35,80,80,14,14,91,91,80,80,10,10,116,116,16,16,118,118,110,110,18,18,98,98,116,116,97,97,101,101,42,42,53,53,73,73,40,40,16,16,69,69,3,3,118,118,41,41,56,56,54,54,58,58,36,36,37,37,49,49,20,20,95,95,7,7,100,100,89,89,102,102,81,81,47,47,115,115,95,95,78,78,36,36,86,86,4,4,94,94,50,50,7,7,49,49,73,73,96,96,26,26,8,8,18,18,24,24,86,86,55,55,68,68,82,82,114,114,88,88,20,20,52,52,13,13,48,48,41,41,73,73,117,117,60,60,65,65,87,87,4,4,112,112,97,97,123,123,125,125,84,84,116,116,2,2,21,21,123,123,25,25,15,15,74,74,92,92,88,88,53,53,98,98,7,7,88,88,24,24,123,123,100,100,32,32,122,122,7,7,12,12,35,35,23,23,69,69,105,105,85,85,80,80,33,33,17,17,58,58,91,91,103,103,111,111,42,42,82,82,117,117,9,9,24,24,7,7,0,0,118,118,41,41,4,4,31,31,14,14,71,71,25,25,108,108,23,23,43,43,10,10,79,79,26,26,107,107,65,65,54,54,23,23,63,63,59,59,89,89,64,64,64,64,78,78,118,118,10,10,72,72,98,98,89,89,26,26,81,81,69,69,108,108,45,45,90,90,113,113,122,122,96,96,34,34,41,41,38,38,103,103,127,127,6,6,120,120,39,39,43,43,94,94,113,113,14,14,6,6,44,44,30,30,83,83,95,95,27,27,86,86,30,30,84,84,59,59,56,56,32,32,92,92,127,127,32,32,48,48,12,12,24,24,113,113,87,87,49,49,28,28,93,93,75,75,20,20,108,108,19,19,96,96,64,64,117,117,104,104,75,75,62,62,12,12,105,105,124,124,18,18,98,98,33,33,4,4,21,21,67,67,69,69,21,21,78,78,24,24,9,9,1,1,54,54,118,118,68,68,98,98,50,50,77,77,37,37,89,89,76,76,109,109,30,30,17,17,17,17,31,31,58,58,74,74,107,107,4,4,0,0,70,70,109,109,32,32,22,22,14,14,73,73,46,46,62,62,38,38,56,56,69,69,22,22,118,118,94,94,111,111,10,10,86,86,13,13,5,5,79,79,123,123,32,32,80,80,94,94,45,45,30,30,115,115,40,40,11,11,22,22,75,75,110,110,9,9,79,79,58,58,4,4,20,20,115,115,10,10,40,40,32,32,9,9,68,68,106,106,12,12,90,90,102,102,15,15,53,53,3,3,49,49,65,65,33,33,61,61,105,105,1,1,105,105,82,82,36,36,93,93,48,48,111,111,19,19,78,78,2,2,75,75,127,127,61,61,62,62,119,119,122,122,52,52,34,34,69,69,96,96,97,97,95,95,55,55,108,108,3,3,81,81,76,76,67,67,90,90,35,35,81,81,68,68,40,40,72,72,16,16,92,92,86,86,40,40,88,88,48,48,59,59,55,55,110,110,69,69,102,102,61,61,0,0,56,56,60,60,113,113,64,64,18,18,119,119,80,80,90,90,9,9,58,58,84,84,94,94,61,61,88,88,0,0,78,78,87,87,25,25,17,17,101,101,91,91,100,100,88,88,20,20,54,54,92,92,40,40,11,11,38,38,62,62,44,44,24,24,76,76,54,54,27,27,2,2,86,86,125,125,66,66,109,109,2,2,60,60,13,13,120,120,5,5,78,78,9,9,43,43,5,5,107,107,119,119,100,100,89,89,10,10,104,104,66,66,43,43,84,84,52,52,24,24,78,78,84,84,31,31,8,8,27,27,79,79,6,6,119,119,94,94,2,2,32,32,113,113,80,80,49,49,41,41,127,127,18,18,108,108,54,54,29,29,42,42,72,72,85,85,35,35,87,87,63,63,41,41,74,74,69,69,36,36,37,37,56,56,46,46,9,9,96,96,6,6,123,123,56,56,83,83,43,43,5,5,111,111,32,32,45,45,21,21,84,84,43,43,113,113,8,8,0,0,107,107,73,73,100,100,69,69,92,92,40,40,36,36,34,34,27,27,73,73,26,26,77,77,4,4,37,37,10,10,15,15,107,107,6,6,15,15,46,46,30,30,71,71,37,37,127,127,6,6,82,82,24,24,126,126,46,46,42,42,112,112,14,14,99,99,68,68,71,71,85,85,8,8,48,48,2,2,36,36,4,4,17,17,81,81,86,86,28,28,75,75,13,13,75,75,103,103,126,126,77,77,127,127,86,86,65,65,78,78,64,64,97,97,10,10,4,4,44,44,73,73,29,29,115,115,45,45,23,23,106,106,70,70,3,3,103,103,35,35,112,112,33,33,18,18,75,75,127,127,101,101,90,90,43,43,47,47,108,108,93,93,62,62,58,58,122,122,76,76,114,114,50,50,42,42,5,5,17,17,11,11,14,14,1,1,32,32,100,100,27,27,24,24,108,108,117,117,82,82,72,72,77,77,24,24,99,99,111,111,86,86,69,69,93,93,52,52,104,104,82,82,115,115,53,53,110,110,8,8,65,65,97,97,38,38,89,89,22,22,16,16,112,112,29,29,1,1,58,58,106,106,30,30,12,12,110,110,66,66,102,102,62,62,30,30,126,126,18,18,26,26,48,48,82,82,119,119,84,84,89,89,20,20,121,121,69,69,93,93,100,100,92,92,23,23,57,57,107,107,112,112,95,95,127,127,45,45,77,77,0,0,126,126,5,5,73,73,105,105,73,73,76,76,41,41,27,27,73,73,54,54,119,119,68,68,97,97,8,8,20,20,7,7,118,118,42,42,113,113,71,71,105,105,123,123,34,34,77,77,90,90,8,8,39,39,2,2,32,32,34,34,117,117,39,39,82,82,12,12,0,0,48,48,99,99,41,41,49,49,67,67,64,64,102,102,80,80,105,105,11,11,102,102,53,53,102,102,70,70,2,2,109,109,32,32,73,73,0,0,42,42,64,64,104,104,98,98,42,42,46,46,27,27,105,105,100,100,104,104,14,14,99,99,50,50,39,39,13,13,18,18,54,54,11,11,89,89,16,16,122,122,22,22,91,91,64,64,124,124,102,102,4,4,58,58,104,104,57,57,19,19,85,85,109,109,126,126,54,54,109,109,6,6,33,33,38,38,55,55,107,107,21,21,8,8,20,20,124,124,73,73,11,11,37,37,88,88,0,0,44,44,114,114,43,43,34,34,21,21,12,12,114,114,67,67,22,22,73,73,41,41,21,21,102,102,59,59,17,17,63,63,106,106,71,71,61,61,41,41,6,6,6,6,118,118,113,113,73,73,73,73,1,1,65,65,57,57,114,114,120,120,41,41,5,5,113,113,45,45,7,7,49,49,14,14,32,32,72,72,42,42,93,93,88,88,10,10,95,95,14,14,74,74,116,116,25,25,75,75,78,78,21,21,16,16,84,84,120,120,15,15,51,51,107,107,39,39,53,53,121,121,33,33,108,108,97,97,117,117,31,31,58,58,73,73,40,40,48,48,79,79,100,100,14,14,38,38,92,92,10,10,103,103,111,111,12,12,38,38,48,48,114,114,19,19,39,39,78,78,106,106,80,80,73,73,106,106,109,109,26,26,46,46,46,46,80,80,48,48,119,119,52,52,10,10,121,121,105,105,122,122,44,44,32,32,40,40,56,56,104,104,12,12,10,10,81,81,86,86,11,11,98,98,26,26,115,115,99,99,14,14,80,80,52,52,0,0,117,117,60,60,19,19,115,115,57,57,82,82,24,24,108,108,82,82,57,57,70,70,89,89,72,72,126,126,10,10,42,42,74,74,54,54,34,34,123,123,70,70,29,29,79,79,68,68,97,97,32,32,60,60,55,55,86,86,52,52,25,25,15,15,81,81,77,77,27,27,60,60,51,51,29,29,97,97,123,123,67,67,76,76,88,88,32,32,7,7,15,15,109,109,2,2,90,90,14,14,49,49,70,70,59,59,39,39,1,1,3,3,41,41,126,126,104,104,118,118,42,42,32,32,113,113,22,22,61,61,109,109,112,112,46,46,98,98,79,79,94,94,64,64,43,43,79,79,34,34,85,85,122,122,120,120,24,24,113,113,27,27,20,20,88,88,98,98,105,105,63,63,21,21,4,4,105,105,68,68,2,2,17,17,38,38,28,28,49,49,73,73,84,84,12,12,97,97,16,16,15,15,48,48,92,92,0,0,19,19,32,32,100,100,65,65,18,18,12,12,122,122,73,73,28,28,9,9,127,127,125,125,33,33,109,109,68,68,2,2,9,9,78,78,12,12,114,114,100,100,62,62,78,78,1,1,83,83,111,111,48,48,17,17,35,35,54,54,8,8,37,37,94,94,26,26,37,37,113,113,30,30,68,68,112,112,123,123,8,8,68,68,34,34,48,48,119,119,114,114,51,51,10,10,24,24,125,125,65,65,18,18,28,28,32,32,92,92,71,71,51,51,58,58,57,57,90,90,82,82,127,127,1,1,32,32,44,44,112,112,65,65,56,56,1,1,126,126,59,59,17,17,64,64,62,62,17,17,66,66,110,110,77,77,45,45,1,1,68,68,73,73,116,116,31,31,20,20,84,84,80,80,63,63,79,79,79,79,114,114,113,113,79,79,46,46,47,47,28,28,53,53,56,56,73,73,49,49,58,58,96,96,8,8,9,9,9,9,51,51,5,5,70,70,80,80,41,41,67,67,75,75,11,11,5,5,20,20,77,77,68,68,70,70,17,17,65,65,101,101,107,107,1,1,1,1,34,34,57,57,0,0,32,32,47,47,110,110,51,51,38,38,100,100,114,114,23,23,41,41,118,118,75,75,99,99,48,48,78,78,107,107,15,15,40,40,106,106,100,100,14,14,32,32,85,85,93,93,12,12,127,127,38,38,52,52,34,34,86,86,34,34,91,91,112,112,52,52,113,113,3,3,72,72,1,1,113,113,39,39,106,106,0,0,92,92,125,125,72,72,35,35,73,73,117,117,127,127,87,87,40,40,2,2,14,14,61,61,10,10,108,108,33,33,106,106,58,58,102,102,91,91,34,34,74,74,81,81,80,80,3,3,3,3,46,46,35,35,121,121,28,28,2,2,27,27,1,1,33,33,56,56,20,20,82,82,120,120,55,55,72,72,33,33,97,97,35,35,85,85,16,16,124,124,51,51,13,13,115,115,125,125,28,28,11,11,39,39,14,14,65,65,73,73,95,95,32,32,34,34,74,74,39,39,8,8,79,79,10,10,126,126,5,5,26,26,16,16,119,119,107,107,109,109,102,102,104,104,38,38,12,12,36,36,46,46,21,21,2,2,99,99,120,120,65,65,45,45,35,35,76,76,118,118,0,0,83,83,88,88,26,26,44,44,115,115,111,111,1,1,89,89,82,82,29,29,48,48,125,125,105,105,62,62,9,9,103,103,85,85,120,120,106,106,65,65,5,5,121,121,75,75,29,29,33,33,9,9,28,28,95,95,106,106,48,48,107,107,23,23,116,116,72,72,12,12,73,73,125,125,41,41,124,124,94,94,7,7,17,17,33,33,127,127,23,23,47,47,91,91,81,81,83,83,15,15,72,72,120,120,39,39,127,127,14,14,78,78,45,45,13,13,12,12,28,28,14,14,67,67,98,98,106,106,110,110,116,116,26,26,23,23,41,41,38,38,0,0,22,22,99,99,56,56,123,123,26,26,1,1,2,2,118,118,26,26,54,54,38,38,57,57,95,95,124,124,126,126,62,62,88,88,127,127,42,42,84,84,69,69,13,13,54,54,33,33,36,36,123,123,59,59,52,52,85,85,17,17,19,19,114,114,98,98,88,88,93,93,49,49,29,29,36,36,6,6,54,54,115,115,49,49,122,122,87,87,25,25,68,68,54,54,0,0,8,8,52,52,90,90,103,103,47,47,109,109,17,17,125,125,101,101,84,84,13,13,125,125,91,91,30,30,107,107,125,125,66,66,67,67,16,16,3,3,78,78,5,5,7,7,70,70,54,54,28,28,80,80,91,91,87,87,114,114,90,90,39,39,89,89,98,98,24,24,32,32,66,66,77,77,29,29,55,55,52,52,91,91,9,9,47,47,33,33,58,58,13,13,21,21,115,115,70,70,26,26,113,113,40,40,14,14,85,85,113,113,29,29,78,78,80,80,10,10,68,68,84,84,87,87,74,74,88,88,61,61,3,3,85,85,127,127,59,59,93,93,22,22,10,10,41,41,103,103,21,21,109,109,99,99,33,33,22,22,24,24,53,53,46,46,18,18,1,1,43,43,113,113,71,71,95,95,99,99,9,9,92,92,20,20,53,53,37,37,10,10,103,103,6,6,47,47,26,26,125,125,64,64,99,99,83,83,66,66,112,112,76,76,118,118,34,34,18,18,67,67,68,68,103,103,63,63,34,34,30,30,115,115,122,122,64,64,61,61,71,71,1,1,14,14,17,17,30,30,22,22,118,118,6,6,108,108,54,54,50,50,24,24,116,116,71,71,48,48,42,42,106,106,46,46,40,40,14,14,70,70,7,7,56,56,66,66,74,74,84,84,2,2,48,48,106,106,67,67,55,55,122,122,1,1,91,91,25,25,22,22,61,61,122,122,91,91,82,82,52,52,102,102,10,10,100,100,115,115,126,126,90,90,99,99,55,55,117,117,82,82,12,12,41,41,86,86,117,117,56,56,53,53,96,96,68,68,64,64,4,4,78,78,82,82,80,80,44,44,118,118,120,120,78,78,101,101,35,35,21,21,127,127,5,5,101,101,42,42,30,30,99,99,121,121,82,82,20,20,36,36,35,35,113,113,41,41,45,45,122,122,76,76,101,101,78,78,36,36,89,89,98,98,27,27,25,25,83,83,76,76,71,71,1,1,59,59,28,28,43,43,8,8,36,36,101,101,10,10,97,97,38,38,22,22,125,125,49,49,26,26,6,6,43,43,99,99,48,48,21,21,114,114,98,98,75,75,87,87,28,28,39,39,71,71,84,84,55,55,9,9,69,69,43,43,46,46,55,55,12,12,115,115,72,72,3,3,74,74,35,35,53,53,49,49,89,89,75,75,14,14,64,64,51,51,79,79,21,21,50,50,55,55,76,76,13,13,114,114,38,38,75,75,21,21,124,124,114,114,45,45,65,65,1,1,84,84,33,33,80,80,38,38,125,125,96,96,109,109,10,10,44,44,24,24,109,109,125,125,26,26,60,60,91,91,97,97,60,60,100,100,96,96,64,64,68,68,18,18,51,51,40,40,75,75,80,80,33,33,88,88,63,63,26,26,117,117,70,70,39,39,102,102,52,52,58,58,69,69,17,17,10,10,0,0,13,13,70,70,87,87,17,17,40,40,127,127,56,56,12,12,13,13,101,101,90,90,35,35,98,98,57,57,71,71,115,115,39,39,94,94,6,6,109,109,51,51,113,113,41,41,98,98,65,65,92,92,96,96,114,114,25,25,95,95,17,17,64,64,59,59,22,22,62,62,61,61,28,28,81,81,114,114,34,34,104,104,9,9,52,52,104,104,67,67,42,42,22,22,70,70,86,86,59,59,17,17,64,64,35,35,58,58,107,107,80,80,43,43,58,58,78,78,111,111,60,60,122,122,65,65,97,97,32,32,27,27,27,27,79,79,124,124,18,18,7,7,10,10,65,65,33,33,20,20,103,103,29,29,60,60,104,104,94,94,122,122,78,78,110,110,100,100,2,2,21,21,93,93,104,104,64,64,123,123,109,109,73,73,125,125,95,95,39,39,83,83,46,46,88,88,125,125,4,4,92,92,15,15,32,32,9,9,22,22,13,13,76,76,112,112,2,2,98,98,70,70,118,118,125,125,79,79,27,27,45,45,60,60,118,118,12,12,14,14,111,111,29,29,30,30,8,8,10,10,30,30,115,115,55,55,58,58,22,22,29,29,87,87,85,85,20,20,84,84,44,44,25,25,32,32,66,66,19,19,18,18,77,77,63,63,118,118,80,80,46,46,28,28,80,80,70,70,61,61,52,52,49,49,108,108,34,34,84,84,89,89,12,12,81,81,111,111,73,73,83,83,79,79,10,10,13,13,117,117,34,34,101,101,18,18,9,9,82,82,55,55,36,36,106,106,114,114,83,83,32,32,68,68,43,43,0,0,47,47,77,77,20,20,62,62,91,91,64,64,0,0,75,75,17,17,10,10,108,108,100,100,115,115,62,62,2,2,46,46,77,77,28,28,122,122,44,44,127,127,43,43,94,94,47,47,82,82,72,72,97,97,12,12,41,41,124,124,74,74,95,95,19,19,100,100,101,101,51,51,27,27,88,88,102,102,1,1,26,26,13,13,67,67,28,28,105,105,15,15,33,33,24,24,37,37,94,94,50,50,28,28,7,7,74,74,38,38,57,57,113,113,93,93,47,47,20,20,116,116,2,2,16,16,114,114,72,72,35,35,39,39,15,15,43,43,121,121,110,110,20,20,127,127,48,48,100,100,57,57,58,58,18,18,13,13,58,58,108,108,92,92,41,41,40,40,105,105,30,30,90,90,121,121,115,115,90,90,102,102,1,1,2,2,57,57,10,10,84,84,61,61,64,64,60,60,10,10,61,61,11,11,31,31,4,4,0,0,67,67,87,87,83,83,73,73,64,64,4,4,103,103,23,23,98,98,11,11,108,108,94,94,77,77,27,27,16,16,12,12,14,14,3,3,70,70,39,39,52,52,84,84,87,87,20,20,81,81,53,53,106,106,48,48,74,74,19,19,24,24,12,12,56,56,19,19,97,97,31,31,96,96,15,15,101,101,36,36,9,9,113,113,48,48,93,93,65,65,88,88,100,100,34,34,110,110,68,68,26,26,117,117,28,28,104,104,55,55,21,21,8,8,36,36,92,92,34,34,99,99,119,119,30,30,60,60,20,20,16,16,125,125,62,62,91,91,115,115,51,51,89,89,43,43,8,8,2,2,24,24,65,65,71,71,1,1,77,77,25,25,117,117,78,78,48,48,18,18,82,82,36,36,5,5,74,74,109,109,1,1,66,66,106,106,120,120,122,122,43,43,40,40,35,35,61,61,112,112,67,67,55,55,94,94,111,111,51,51,122,122,37,37,102,102,14,14,74,74,30,30,40,40,89,89,2,2,57,57,82,82,13,13,35,35,122,122,35,35,65,65,36,36,4,4,0,0,73,73,46,46,125,125,88,88,4,4,114,114,63,63,11,11,117,117,40,40,66,66,107,107,68,68,47,47,22,22,57,57,69,69,0,0,31,31,3,3,124,124,0,0,47,47,34,34,62,62,51,51,120,120,43,43,112,112,59,59,4,4,10,10,3,3,22,22,5,5,33,33,109,109,10,10,89,89,60,60,36,36,86,86,82,82,115,115,22,22,25,25,16,16,30,30,7,7,105,105,77,77,124,124,30,30,64,64,9,9,111,111,62,62,36,36,87,87,70,70,119,119,41,41,34,34,88,88,18,18,85,85,77,77,66,66,72,72,58,58,41,41,2,2,60,60,11,11,24,24,70,70,69,69,74,74,52,52,68,68,74,74,40,40,122,122,95,95,125,125,98,98,70,70,58,58,107,107,3,3,78,78,114,114,1,1,30,30,78,78,104,104,36,36,10,10,104,104,64,64,85,85,36,36,15,15,111,111,65,65,98,98,89,89,24,24,75,75,13,13,115,115,72,72,82,82,52,52,81,81,48,48,75,75,31,31,72,72,17,17,69,69,113,113,40,40,72,72,112,112,47,47,48,48,2,2,100,100,33,33,93,93,108,108,11,11,115,115,98,98,91,91,66,66,102,102,84,84,80,80,66,66,48,48,15,15,50,50,68,68,90,90,19,19,1,1,23,23,36,36,84,84,88,88,112,112,29,29,1,1,38,38,60,60,48,48,76,76,48,48,45,45,59,59,61,61,0,0,48,48,73,73,60,60,78,78,16,16,24,24,70,70,61,61,79,79,22,22,3,3,80,80,66,66,16,16,78,78,105,105,41,41,12,12,70,70,10,10,86,86,49,49,29,29,15,15,36,36,0,0,110,110,58,58,69,69,12,12,39,39,42,42,15,15,15,15,121,121,97,97,15,15,108,108,26,26,77,77,11,11,73,73,107,107,119,119,122,122,44,44,33,33,7,7,104,104,101,101,81,81,1,1,88,88,101,101,84,84,74,74,46,46,8,8,66,66,90,90,32,32,9,9,32,32,111,111,97,97,20,20,37,37,33,33,116,116,25,25,0,0,108,108,95,95,1,1,25,25,67,67,83,83,100,100,2,2,42,42,33,33,35,35,118,118,85,85,0,0,43,43,64,64,34,34,30,30,75,75,14,14,9,9,79,79,5,5,39,39,8,8,67,67,125,125,55,55,13,13,77,77,66,66,102,102,46,46,33,33,72,72,12,12,70,70,39,39,73,73,124,124,78,78,0,0,62,62,106,106,53,53,71,71,53,53,87,87,43,43,89,89,24,24,73,73,35,35,93,93,21,21,48,48,124,124,106,106,16,16,94,94,51,51,62,62,64,64,104,104,96,96,102,102,34,34,27,27,105,105,28,28,30,30,0,0,42,42,87,87,125,125,83,83,90,90,41,41,66,66,70,70,40,40,24,24,57,57,7,7,9,9,49,49,25,25,86,86,102,102,28,28,86,86,27,27,127,127,123,123,76,76,46,46,124,124,66,66,110,110,62,62,61,61,24,24,85,85,88,88,12,12,60,60,111,111,2,2,57,57,27,27,13,13,88,88,21,21,31,31,7,7,80,80,17,17,36,36,15,15,0,0,16,16,94,94,14,14,124,124,49,49,110,110,64,64,47,47,56,56,41,41,66,66,8,8,31,31,70,70,53,53,84,84,12,12,65,65,0,0,48,48,26,26,101,101,65,65,4,4,42,42,81,81,19,19,51,51,43,43,13,13,43,43,17,17,110,110,104,104,41,41,42,42,106,106,123,123,120,120,116,116,67,67,64,64,60,60,58,58,0,0,37,37,0,0,43,43,90,90,13,13,52,52,16,16,37,37,41,41,30,30,11,11,72,72,18,18,106,106,11,11,89,89,72,72,61,61,68,68,48,48,121,121,24,24,94,94,101,101,14,14,33,33,97,97,110,110,123,123,98,98,117,117,19,19,43,43,61,61,39,39,43,43,10,10,84,84,6,6,72,72,70,70,2,2,44,44,124,124,78,78,30,30,66,66,45,45,97,97,55,55,39,39,0,0,1,1,122,122,12,12,2,2,18,18,103,103,63,63,15,15,65,65,95,95,18,18,16,16,87,87,72,72,119,119,76,76,45,45,31,31,78,78,71,71,112,112,104,104,104,104,64,64,39,39,123,123,110,110,30,30,110,110,124,124,28,28,28,28,99,99,24,24,29,29,18,18,20,20,98,98,97,97,81,81,97,97,22,22,119,119,64,64,93,93,122,122,4,4,68,68,105,105,122,122,81,81,56,56,39,39,93,93,42,42,52,52,94,94,71,71,73,73,54,54,4,4,112,112,13,13,116,116,54,54,54,54,47,47,0,0,68,68,14,14,39,39,80,80,7,7,45,45,35,35,62,62,15,15,55,55,106,106,36,36,7,7,120,120,16,16,108,108,55,55,97,97,60,60,54,54,34,34,15,15,104,104,89,89,76,76,0,0,101,101,115,115,124,124,36,36,12,12,110,110,36,36,19,19,120,120,42,42,33,33,2,2,97,97,4,4,120,120,0,0,21,21,79,79,61,61,21,21,105,105,17,17,47,47,126,126,82,82,19,19,72,72,53,53,104,104,18,18,99,99,34,34,24,24,117,117,1,1,106,106,122,122,8,8,68,68,22,22,54,54,111,111,77,77,40,40,7,7,88,88,114,114,71,71,62,62,41,41,6,6,4,4,50,50,32,32,32,32,80,80,9,9,50,50,35,35,103,103,78,78,66,66,8,8,88,88,50,50,57,57,70,70,18,18,19,19,89,89,8,8,96,96,64,64,82,82,25,25,105,105,94,94,37,37,81,81,42,42,29,29,71,71,58,58,63,63,61,61,84,84,82,82,44,44,127,127,111,111,1,1,32,32,56,56,67,67,40,40,68,68,16,16,112,112,104,104,122,122,49,49,53,53,104,104,86,86,75,75,13,13,122,122,68,68,40,40,82,82,105,105,107,107,44,44,20,20,93,93,55,55,93,93,110,110,6,6,79,79,74,74,112,112,54,54,38,38,8,8,49,49,75,75,11,11,76,76,126,126,95,95,35,35,14,14,96,96,72,72,27,27,8,8,80,80,52,52,1,1,11,11,61,61,107,107,58,58,26,26,34,34,85,85,41,41,124,124,114,114,14,14,4,4,66,66,38,38,88,88,49,49,75,75,7,7,64,64,70,70,42,42,44,44,66,66,4,4,83,83,16,16,99,99,71,71,45,45,62,62,59,59,7,7,113,113,121,121,33,33,18,18,6,6,112,112,52,52,21,21,92,92,107,107,52,52,26,26,36,36,127,127,77,77,28,28,63,63,59,59,39,39,106,106,55,55,7,7,21,21,68,68,18,18,74,74,14,14,30,30,35,35,40,40,67,67,25,25,38,38,57,57,55,55,90,90,102,102,102,102,26,26,56,56,7,7,119,119,11,11,35,35,68,68,37,37,67,67,60,60,34,34,40,40,126,126,92,92,11,11,16,16,1,1,61,61,109,109,94,94,8,8,121,121,82,82,57,57,34,34,126,126,100,100,14,14,83,83,51,51,104,104,77,77,60,60,27,27,27,27,51,51,90,90,68,68,126,126,31,31,6,6,106,106,91,91,101,101,33,33,56,56,61,61,31,31,25,25,19,19,42,42,88,88,78,78,0,0,3,3,81,81,87,87,85,85,79,79,32,32,66,66,81,81,19,19,66,66,68,68,54,54,24,24,80,80,40,40,100,100,38,38,91,91,93,93,92,92,35,35,37,37,38,38,122,122,7,7,18,18,35,35,58,58,75,75,66,66,84,84,87,87,102,102,104,104,36,36,51,51,114,114,49,49,94,94,57,57,28,28,69,69,65,65,88,88,72,72,27,27,19,19,64,64,126,126,69,69,42,42,100,100,28,28,21,21,14,14,15,15,36,36,56,56,82,82,75,75,104,104,49,49,94,94,1,1,10,10,17,17,43,43,21,21,106,106,95,95,105,105,91,91,59,59,79,79,90,90,80,80,60,60,82,82,114,114,27,27,22,22,26,26,14,14,116,116,18,18,47,47,111,111,110,110,124,124,84,84,117,117,50,50,125,125,81,81,0,0,11,11,36,36,117,117,80,80,22,22,61,61,66,66,41,41,39,39,17,17,71,71,111,111,11,11,36,36,111,111,87,87,86,86,125,125,56,56,113,113,10,10,39,39,121,121,59,59,112,112,46,46,107,107,0,0,125,125,79,79,92,92,47,47,31,31,2,2,113,113,20,20,51,51,44,44,16,16,80,80,98,98,46,46,10,10,4,4,89,89,100,100,73,73,121,121,28,28,122,122,10,10,127,127,24,24,24,24,39,39,100,100,104,104,124,124,34,34,12,12,23,23,71,71,62,62,59,59,79,79,38,38,85,85,100,100,118,118,100,100,2,2,38,38,122,122,36,36,126,126,114,114,51,51,63,63,14,14,126,126,22,22,11,11,3,3,66,66,48,48,40,40,89,89,84,84,36,36,54,54,31,31,52,52,11,11,111,111,34,34,103,103,46,46,121,121,77,77,56,56,66,66,97,97,80,80,17,17,118,118,77,77,114,114,83,83,10,10,66,66,16,16,18,18,114,114,38,38,103,103,19,19,106,106,112,112,6,6,12,12,41,41,30,30,97,97,92,92,43,43,81,81,16,16,83,83,10,10,30,30,30,30,64,64,81,81,119,119,77,77,122,122,0,0,4,4,74,74,90,90,49,49,119,119,69,69,17,17,0,0,8,8,41,41,122,122,67,67,11,11,23,23,116,116,78,78,112,112,100,100,98,98,88,88,35,35,110,110,14,14,74,74,47,47,55,55,52,52,36,36,59,59,10,10,13,13,38,38,96,96,1,1,5,5,65,65,27,27,49,49,44,44,120,120,20,20,93,93,74,74,52,52,89,89,121,121,6,6,8,8,61,61,107,107,25,25,83,83,7,7,47,47,11,11,74,74,54,54,4,4,27,27,101,101,36,36,35,35,46,46,66,66,78,78,29,29,40,40,115,115,59,59,26,26,74,74,106,106,126,126,86,86,47,47,11,11,93,93,1,1,65,65,14,14,118,118,39,39,2,2,37,37,30,30,89,89,29,29,69,69,71,71,0,0,66,66,89,89,96,96,101,101,56,56,107,107,56,56,95,95,17,17,24,24,28,28,17,17,74,74,22,22,47,47,84,84,27,27,47,47,1,1,49,49,75,75,21,21,5,5,35,35,81,81,124,124,100,100,10,10,67,67,23,23,111,111,88,88,101,101,52,52,31,31,43,43,74,74,0,0,68,68,89,89,110,110,61,61,28,28,56,56,15,15,70,70,119,119,41,41,15,15,66,66,15,15,66,66,59,59,1,1,10,10,63,63,5,5,86,86,108,108,105,105,64,64,22,22,95,95,12,12,34,34,1,1,96,96,66,66,53,53,90,90,69,69,121,121,67,67,101,101,13,13,113,113,0,0,121,121,2,2,31,31,90,90,56,56,2,2,42,42,24,24,9,9,84,84,125,125,101,101,5,5,120,120,122,122,33,33,82,82,32,32,34,34,13,13,81,81,19,19,90,90,55,55,54,54,116,116,40,40,21,21,40,40,32,32,1,1,55,55,46,46,77,77,2,2,53,53,25,25,33,33,104,104,26,26,12,12,22,22,16,16,2,2,119,119,110,110,1,1,49,49,52,52,1,1,32,32,122,122,81,81,95,95,39,39,9,9,106,106,82,82,60,60,26,26,43,43,34,34,8,8,120,120,64,64,9,9,37,37,47,47,61,61,46,46,12,12,24,24,50,50,0,0,26,26,23,23,91,91,66,66,87,87,63,63,15,15,26,26,95,95,25,25,11,11,26,26,75,75,85,85,100,100,103,103,26,26,0,0,9,9,10,10,33,33,55,55,0,0,2,2,81,81,80,80,122,122,35,35,42,42,27,27,17,17,31,31,65,65,48,48,14,14,38,38,25,25,4,4,37,37,32,32,0,0,118,118,37,37,86,86,107,107,44,44,61,61,78,78,4,4,40,40,100,100,51,51,48,48,11,11,4,4,111,111,48,48,83,83,86,86,22,22,113,113,108,108,37,37,80,80,29,29,38,38,14,14,31,31,49,49,117,117,83,83,99,99,112,112,64,64,100,100,107,107,65,65,89,89,125,125,70,70,80,80,120,120,11,11,74,74,16,16,5,5,71,71,26,26,21,21,33,33,64,64,74,74,84,84,65,65,37,37,112,112,29,29,31,31,60,60,32,32,48,48,82,82,73,73,1,1,0,0,1,1,57,57,40,40,95,95,41,41,5,5,74,74,88,88,102,102,126,126,14,14,87,87,60,60,76,76,85,85,53,53,52,52,14,14,89,89,86,86,18,18,41,41,24,24,97,97,95,95,21,21,71,71,99,99,19,19,44,44,89,89,46,46,73,73,92,92,12,12,114,114,9,9,27,27,81,81,113,113,45,45,21,21,86,86,64,64,54,54,92,92,48,48,39,39,64,64,104,104,96,96,38,38,109,109,86,86,68,68,125,125,69,69,107,107,66,66,16,16,37,37,113,113,34,34,64,64,69,69,67,67,30,30,81,81,60,60,80,80,48,48,4,4,98,98,41,41,56,56,34,34,71,71,111,111,74,74,28,28,116,116,55,55,9,9,32,32,34,34,17,17,52,52,107,107,12,12,97,97,34,34,70,70,76,76,120,120,105,105,20,20,6,6,121,121,106,106,98,98,70,70,89,89,66,66,63,63,14,14,64,64,50,50,113,113,4,4,43,43,36,36,63,63,70,70,58,58,2,2,53,53,117,117,84,84,99,99,81,81,65,65,29,29,108,108,88,88,114,114,52,52,0,0,68,68,114,114,0,0,72,72,105,105,107,107,85,85,10,10,115,115,49,49,72,72,12,12,67,67,7,7,81,81,9,9,73,73,98,98,49,49,112,112,34,34,36,36,23,23,2,2,34,34,3,3,48,48,87,87,22,22,69,69,86,86,89,89,36,36,4,4,22,22,97,97,103,103,78,78,68,68,3,3,40,40,113,113,114,114,105,105,74,74,94,94,105,105,100,100,116,116,83,83,112,112,31,31,7,7,40,40,25,25,66,66,16,16,28,28,0,0,28,28,42,42,105,105,80,80,110,110,73,73,118,118,31,31,87,87,72,72,1,1,100,100,2,2,123,123,118,118,110,110,45,45,101,101,11,11,27,27,119,119,122,122,66,66,65,65,103,103,0,0,73,73,0,0,3,3,1,1,11,11,26,26,93,93,46,46,36,36,32,32,32,32,57,57,84,84,65,65,71,71,82,82,71,71,127,127,43,43,104,104,51,51,119,119,61,61,38,38,58,58,112,112,34,34,52,52,6,6,24,24,1,1,27,27,53,53,49,49,53,53,50,50,121,121,23,23,26,26,96,96,48,48,112,112,32,32,26,26,16,16,73,73,28,28,108,108,103,103,1,1,25,25,67,67,52,52,26,26,11,11,45,45,100,100,65,65,40,40,96,96,54,54,103,103,118,118,121,121,40,40,125,125,60,60,54,54,57,57,28,28,5,5,91,91,87,87,84,84,61,61,116,116,17,17,51,51,35,35,35,35,9,9,101,101,80,80,82,82,18,18,4,4,23,23,16,16,75,75,5,5,68,68,32,32,105,105,4,4,111,111,18,18,69,69,26,26,85,85,90,90,64,64,125,125,42,42,72,72,110,110,115,115,106,106,32,32,120,120,112,112,15,15,84,84,36,36,106,106,2,2,13,13,9,9,112,112,66,66,23,23,0,0,33,33,124,124,76,76,21,21,94,94,14,14,108,108,32,32,125,125,23,23,69,69,109,109,104,104,57,57,53,53,33,33,28,28,104,104,88,88,62,62,114,114,4,4,113,113,83,83,114,114,71,71,36,36,16,16,33,33,120,120,0,0,56,56,83,83,60,60,72,72,15,15,112,112,87,87,70,70,107,107,17,17,6,6,46,46,47,47,78,78,114,114,81,81,48,48,20,20,70,70,88,88,55,55,70,70,107,107,67,67,57,57,46,46,47,47,29,29,28,28,27,27,52,52,79,79,17,17,91,91,69,69,14,14,67,67,17,17,83,83,59,59,19,19,33,33,33,33,38,38,116,116,31,31,111,111,59,59,32,32,56,56,53,53,47,47,39,39,116,116,18,18,32,32,37,37,26,26,57,57,86,86,63,63,8,8,48,48,68,68,114,114,26,26,29,29,118,118,43,43,39,39,40,40,89,89,0,0,8,8,43,43,127,127,53,53,1,1,81,81,108,108,9,9,127,127,107,107,80,80,51,51,6,6,45,45,96,96,86,86,104,104,60,60,43,43,83,83,5,5,110,110,73,73,103,103,40,40,51,51,56,56,125,125,51,51,120,120,38,38,33,33,52,52,111,111,67,67,20,20,12,12,114,114,17,17,124,124,0,0,66,66,101,101,126,126,27,27,96,96,38,38,97,97,69,69,118,118,27,27,94,94,39,39,44,44,106,106,5,5,57,57,89,89,76,76,9,9,46,46,44,44,12,12,15,15,106,106,48,48,7,7,86,86,33,33,114,114,74,74,76,76,19,19,120,120,73,73,121,121,63,63,5,5,95,95,25,25,41,41,35,35,58,58,122,122,64,64,80,80,90,90,79,79,68,68,65,65,10,10,4,4,58,58,110,110,61,61,118,118,61,61,96,96,82,82,95,95,3,3,67,67,88,88,26,26,1,1,39,39,36,36,114,114,36,36,69,69,19,19,37,37,84,84,120,120,41,41,100,100,121,121,57,57,106,106,72,72,39,39,75,75,48,48,51,51,77,77,74,74,17,17,13,13,31,31,120,120,74,74,112,112,110,110,112,112,72,72,88,88,108,108,2,2,56,56,71,71,31,31,104,104,123,123,110,110,54,54,35,35,114,114,5,5,59,59,90,90,117,117,86,86,76,76,30,30,3,3,116,116,119,119,66,66,38,38,61,61,45,45,43,43,17,17,51,51,32,32,78,78,53,53,91,91,71,71,98,98,15,15,80,80,9,9,127,127,90,90,76,76,41,41,116,116,123,123,99,99,116,116,94,94,19,19,18,18,88,88,121,121,32,32,91,91,37,37,70,70,75,75,13,13,108,108,71,71,20,20,29,29,85,85,63,63,124,124,49,49,120,120,35,35,72,72,18,18,116,116,57,57,17,17,25,25,24,24,18,18,6,6,118,118,16,16,11,11,31,31,16,16,6,6,16,16,20,20,49,49,73,73,16,16,98,98,49,49,41,41,26,26,0,0,127,127,38,38,40,40,103,103,31,31,10,10,39,39,43,43,52,52,69,69,43,43,56,56,64,64,64,64,24,24,33,33,62,62,114,114,95,95,46,46,93,93,65,65,119,119,22,22,30,30,117,117,103,103,17,17,108,108,41,41,91,91,53,53,16,16,106,106,119,119,42,42,101,101,84,84,121,121,113,113,16,16,27,27,35,35,23,23,113,113,90,90,120,120,76,76,108,108,127,127,17,17,62,62,10,10,17,17,22,22,26,26,70,70,34,34,127,127,84,84,58,58,73,73,21,21,53,53,4,4,9,9,53,53,116,116,62,62,94,94,42,42,117,117,26,26,40,40,107,107,5,5,112,112,23,23,103,103,20,20,20,20,9,9,22,22,56,56,23,23,111,111,39,39,67,67,100,100,30,30,72,72,112,112,60,60,10,10,93,93,56,56,124,124,53,53,26,26,59,59,27,27,54,54,36,36,2,2,48,48,22,22,57,57,43,43,58,58,22,22,48,48,75,75,121,121,40,40,119,119,19,19,72,72,91,91,65,65,89,89,68,68,117,117,34,34,17,17,52,52,84,84,15,15,34,34,95,95,53,53,16,16,118,118,76,76,73,73,105,105,85,85,21,21,127,127,66,66,8,8,89,89,64,64,8,8,52,52,7,7,13,13,104,104,83,83,122,122,100,100,96,96,66,66,2,2,13,13,0,0,25,25,17,17,57,57,24,24,60,60,49,49,15,15,17,17,41,41,64,64,16,16,1,1,36,36,82,82,114,114,70,70,83,83,98,98,48,48,5,5,50,50,40,40,5,5,4,4,39,39,83,83,23,23,51,51,3,3,105,105,23,23,49,49,52,52,82,82,28,28,109,109,122,122,64,64,24,24,48,48,111,111,117,117,27,27,101,101,102,102,109,109,56,56,45,45,22,22,56,56,5,5,74,74,78,78,82,82,74,74,30,30,30,30,71,71,83,83,38,38,74,74,74,74,108,108,8,8,102,102,52,52,42,42,29,29,113,113,104,104,29,29,51,51,115,115,12,12,103,103,74,74,36,36,114,114,20,20,80,80,71,71,103,103,41,41,49,49,26,26,38,38,85,85,96,96,79,79,12,12,84,84,11,11,62,62,55,55,31,31,94,94,46,46,117,117,101,101,19,19,58,58,62,62,13,13,65,65,76,76,36,36,7,7,0,0,71,71,41,41,86,86,37,37,71,71,66,66,33,33,90,90,26,26,44,44,104,104,100,100,119,119,27,27,2,2,96,96,24,24,15,15,19,19,60,60,65,65,32,32,118,118,51,51,84,84,46,46,126,126,30,30,105,105,104,104,31,31,9,9,72,72,88,88,46,46,73,73,67,67,56,56,106,106,94,94,105,105,1,1,70,70,97,97,113,113,26,26,116,116,18,18,62,62,88,88,52,52,15,15,102,102,56,56,35,35,80,80,97,97,29,29,62,62,41,41,121,121,83,83,41,41,100,100,118,118,104,104,29,29,114,114,38,38,23,23,3,3,104,104,78,78,106,106,12,12,3,3,37,37,59,59,1,1,49,49,61,61,7,7,95,95,124,124,77,77,72,72,4,4,86,86,90,90,18,18,123,123,123,123,32,32,108,108,53,53,63,63,4,4,33,33,85,85,21,21,16,16,74,74,65,65,23,23,50,50,97,97,52,52,79,79,111,111,2,2,9,9,8,8,55,55,18,18,65,65,81,81,105,105,6,6,114,114,48,48,114,114,71,71,4,4,25,25,110,110,20,20,90,90,31,31,9,9,20,20,9,9,3,3,76,76,58,58,41,41,74,74,80,80,5,5,55,55,98,98,2,2,70,70,73,73,43,43,104,104,59,59,83,83,40,40,38,38,53,53,120,120,126,126,11,11,17,17,21,21,2,2,117,117,72,72,22,22,59,59,9,9,26,26,88,88,110,110,96,96,21,21,57,57,71,71,55,55,36,36,46,46,119,119,55,55,21,21,89,89,51,51,35,35,16,16,76,76,48,48,37,37,112,112,70,70,26,26,20,20,115,115,88,88,0,0,22,22,97,97,47,47,106,106,9,9,116,116,7,7,50,50,16,16,102,102,56,56,46,46,111,111,37,37,116,116,104,104,95,95,1,1,61,61,84,84,119,119,51,51,51,51,71,71,70,70,10,10,67,67,114,114,92,92,31,31,96,96,22,22,17,17,18,18,80,80,7,7,98,98,96,96,87,87,20,20,38,38,87,87,72,72,81,81,33,33,24,24,118,118,66,66,44,44,65,65,73,73,30,30,20,20,59,59,46,46,28,28,11,11,91,91,48,48,2,2,113,113,67,67,69,69,72,72,6,6,15,15,93,93,26,26,100,100,36,36,115,115,74,74,31,31,14,14,18,18,17,17,42,42,73,73,99,99,121,121,11,11,82,82,53,53,113,113,87,87,43,43,33,33,104,104,105,105,56,56,100,100,81,81,45,45,101,101,98,98,29,29,36,36,119,119,68,68,86,86,4,4,25,25,95,95,31,31,101,101,84,84,3,3,59,59,99,99,19,19,90,90,18,18,115,115,76,76,58,58,112,112,8,8,66,66,40,40,57,57,74,74,2,2,43,43,58,58,49,49,74,74,54,54,96,96,44,44,124,124,36,36,45,45,59,59,98,98,33,33,45,45,39,39,18,18,41,41,10,10,19,19,35,35,20,20,88,88,31,31,4,4,62,62,8,8,57,57,71,71,32,32,20,20,51,51,24,24,86,86,65,65,40,40,91,91,1,1,28,28,5,5,93,93,58,58,60,60,35,35,13,13,30,30,32,32,41,41,122,122,40,40,101,101,54,54,101,101,55,55,81,81,12,12,32,32,32,32,60,60,86,86,111,111,80,80,91,91,50,50,50,50,1,1,6,6,119,119,91,91,22,22,17,17,67,67,64,64,16,16,81,81,5,5,48,48,27,27,102,102,83,83,86,86,121,121,76,76,124,124,102,102,42,42,112,112,63,63,93,93,63,63,74,74,89,89,104,104,52,52,30,30,39,39,62,62,27,27,7,7,80,80,15,15,61,61,94,94,95,95,2,2,77,77,6,6,91,91,37,37,42,42,113,113,118,118,25,25,115,115,99,99,37,37,80,80,74,74,77,77,99,99,26,26,41,41,13,13,107,107,106,106,51,51,84,84,59,59,115,115,9,9,117,117,100,100,32,32,121,121,65,65,65,65,82,82,17,17,111,111,12,12,42,42,27,27,16,16,6,6,0,0,107,107,31,31,3,3,59,59,116,116,27,27,27,27,84,84,10,10,15,15,1,1,2,2,30,30,75,75,7,7,20,20,91,91,29,29,119,119,92,92,73,73,34,34,73,73,34,34,23,23,22,22,24,24,36,36,74,74,34,34,120,120,61,61,63,63,88,88,4,4,19,19,59,59,40,40,85,85,108,108,59,59,32,32,0,0,5,5,83,83,19,19,15,15,43,43,2,2,126,126,83,83,25,25,80,80,72,72,16,16,77,77,102,102,59,59,14,14,76,76,22,22,41,41,82,82,30,30,92,92,117,117,33,33,122,122,111,111,15,15,47,47,23,23,57,57,72,72,7,7,120,120,22,22,97,97,62,62,74,74,12,12,123,123,81,81,53,53,86,86,109,109,48,48,96,96,19,19,63,63,122,122,69,69,78,78,103,103,38,38,17,17,115,115,40,40,114,114,18,18,99,99,48,48,80,80,31,31,41,41,42,42,99,99,98,98,28,28,32,32,76,76,116,116,17,17,28,28,15,15,32,32,3,3,20,20,3,3,71,71,30,30,60,60,50,50,16,16,114,114,95,95,52,52,94,94,22,22,20,20,45,45,65,65,20,20,45,45,71,71,14,14,3,3,13,13,48,48,56,56,72,72,96,96,73,73,58,58,46,46,90,90,2,2,18,18,66,66,109,109,22,22,0,0,70,70,126,126,19,19,110,110,72,72,9,9,32,32,17,17,77,77,61,61,12,12,112,112,65,65,12,12,23,23,120,120,1,1,33,33,118,118,100,100,7,7,33,33,18,18,37,37,107,107,88,88,49,49,82,82,126,126,35,35,38,38,15,15,100,100,114,114,106,106,20,20,80,80,10,10,64,64,44,44,120,120,124,124,114,114,7,7,79,79,107,107,102,102,26,26,33,33,69,69,19,19,81,81,122,122,102,102,40,40,112,112,110,110,97,97,108,108,87,87,87,87,31,31,25,25,95,95,9,9,105,105,67,67,86,86,66,66,29,29,40,40,6,6,9,9,13,13,96,96,117,117,82,82,83,83,61,61,42,42,10,10,115,115,22,22,98,98,4,4,32,32,93,93,51,51,124,124,70,70,8,8,58,58,120,120,102,102,37,37,30,30,75,75,47,47,62,62,83,83,74,74,11,11,22,22,56,56,67,67,35,35,115,115,47,47,118,118,45,45,12,12,65,65,6,6,48,48,16,16,81,81,85,85,118,118,50,50,88,88,99,99,28,28,84,84,59,59,108,108,120,120,14,14,101,101,48,48,48,48,52,52,52,52,44,44,92,92,75,75,26,26,17,17,70,70,15,15,71,71,71,71,29,29,92,92,44,44,115,115,22,22,67,67,41,41,27,27,30,30,68,68,26,26,19,19,74,74,62,62,65,65,113,113,117,117,108,108,53,53,114,114,58,58,103,103,11,11,0,0,107,107,100,100,73,73,100,100,18,18,125,125,122,122,36,36,112,112,88,88,123,123,90,90,37,37,69,69,59,59,82,82,105,105,98,98,4,4,109,109,70,70,36,36,113,113,34,34,68,68,47,47,17,17,112,112,88,88,96,96,36,36,5,5,68,68,107,107,41,41,19,19,23,23,117,117,41,41,36,36,102,102,36,36,20,20,84,84,70,70,35,35,91,91,10,10,55,55,5,5,12,12,18,18,98,98,98,98,77,77,103,103,82,82,85,85,83,83,1,1,40,40,56,56,62,62,97,97,53,53,103,103,7,7,89,89,125,125,6,6,83,83,78,78,63,63,1,1,15,15,17,17,19,19,68,68,18,18,114,114,18,18,16,16,114,114,127,127,69,69,73,73,34,34,125,125,82,82,58,58,13,13,115,115,60,60,28,28,81,81,25,25,0,0,97,97,5,5,12,12,74,74,95,95,120,120,17,17,57,57,64,64,8,8,20,20,98,98,126,126,104,104,36,36,83,83,58,58,65,65,79,79,14,14,50,50,92,92,121,121,52,52,12,12,121,121,76,76,0,0,51,51,105,105,12,12,121,121,118,118,52,52,29,29,85,85,43,43,82,82,20,20,24,24,74,74,78,78,32,32,81,81,96,96,99,99,20,20,66,66,105,105,87,87,41,41,1,1,0,0,22,22,16,16,77,77,88,88,63,63,20,20,74,74,14,14,68,68,89,89,33,33,94,94,63,63,17,17,22,22,17,17,63,63,15,15,104,104,99,99,32,32,92,92,6,6,124,124,35,35,68,68,50,50,97,97,18,18,4,4,114,114,76,76,39,39,26,26,32,32,125,125,32,32,60,60,21,21,2,2,124,124,58,58,38,38,52,52,68,68,48,48,46,46,55,55,53,53,73,73,105,105,9,9,37,37,37,37,108,108,105,105,86,86,127,127,118,118,37,37,46,46,120,120,88,88,23,23,83,83,124,124,121,121,1,1,33,33,6,6,122,122,12,12,24,24,59,59,1,1,19,19,0,0,25,25,69,69,70,70,96,96,4,4,31,31,61,61,42,42,85,85,62,62,64,64,36,36,1,1,33,33,77,77,22,22,2,2,82,82,125,125,17,17,7,7,82,82,86,86,96,96,93,93,7,7,74,74,93,93,91,91,18,18,118,118,123,123,28,28,11,11,26,26,7,7,48,48,53,53,90,90,40,40,11,11,81,81,93,93,17,17,116,116,107,107,66,66,34,34,40,40,42,42,67,67,19,19,99,99,71,71,36,36,12,12,40,40,87,87,114,114,9,9,58,58,52,52,116,116,22,22,37,37,93,93,99,99,43,43,30,30,14,14,18,18,62,62,107,107,21,21,96,96,102,102,56,56,71,71,50,50,64,64,88,88,14,14,77,77,57,57,100,100,22,22,44,44,53,53,35,35,92,92,29,29,71,71,65,65,12,12,51,51,37,37,15,15,40,40,93,93,106,106,24,24,124,124,9,9,60,60,13,13,9,9,82,82,37,37,79,79,60,60,4,4,45,45,80,80,24,24,113,113,17,17,36,36,46,46,46,46,108,108,41,41,88,88,10,10,35,35,76,76,72,72,67,67,107,107,2,2,14,14,44,44,114,114,29,29,104,104,103,103,21,21,113,113,20,20,4,4,86,86,44,44,51,51,113,113,72,72,86,86,31,31,125,125,11,11,22,22,23,23,12,12,49,49,65,65,12,12,22,22,112,112,98,98,16,16,27,27,21,21,84,84,56,56,59,59,1,1,36,36,118,118,74,74,101,101,56,56,92,92,46,46,63,63,17,17,58,58,72,72,5,5,59,59,15,15,42,42,69,69,62,62,39,39,65,65,48,48,54,54,104,104,112,112,109,109,79,79,56,56,83,83,25,25,6,6,73,73,125,125,67,67,11,11,19,19,26,26,11,11,8,8,108,108,43,43,19,19,119,119,0,0,70,70,32,32,33,33,33,33,100,100,79,79,82,82,85,85,78,78,93,93,15,15,120,120,97,97,125,125,108,108,5,5,7,7,18,18,80,80,79,79,87,87,4,4,86,86,6,6,67,67,103,103,85,85,61,61,13,13,61,61,4,4,13,13,64,64,121,121,49,49,94,94,36,36,44,44,34,34,113,113,8,8,35,35,90,90,77,77,69,69,20,20,112,112,56,56,66,66,4,4,49,49,39,39,111,111,78,78,57,57,12,12,34,34,124,124,48,48,81,81,32,32,16,16,94,94,42,42,113,113,99,99,76,76,54,54,98,98,53,53,88,88,60,60,83,83,5,5,49,49,63,63,7,7,79,79,95,95,39,39,49,49,48,48,66,66,11,11,112,112,52,52,117,117,79,79,78,78,5,5,22,22,92,92,36,36,52,52,84,84,3,3,68,68,101,101,67,67,28,28,57,57,62,62,1,1,27,27,46,46,3,3,90,90,52,52,102,102,77,77,45,45,15,15,4,4,14,14,90,90,60,60,11,11,22,22,85,85,76,76,22,22,124,124,25,25,4,4,41,41,123,123,19,19,32,32,80,80,86,86,14,14,67,67,99,99,90,90,9,9,16,16,105,105,66,66,56,56,80,80,104,104,6,6,25,25,112,112,69,69,17,17,2,2,58,58,82,82,14,14,80,80,99,99,70,70,85,85,90,90,104,104,91,91,60,60,7,7,13,13,8,8,0,0,75,75,50,50,69,69,106,106,16,16,3,3,118,118,1,1,56,56,101,101,35,35,44,44,10,10,13,13,65,65,9,9,52,52,2,2,108,108,113,113,21,21,120,120,80,80,118,118,85,85,17,17,121,121,96,96,36,36,28,28,51,51,117,117,90,90,3,3,4,4,117,117,51,51,113,113,125,125,30,30,35,35,37,37,118,118,1,1,7,7,55,55,59,59,86,86,84,84,124,124,103,103,10,10,97,97,99,99,49,49,30,30,31,31,96,96,80,80,33,33,72,72,47,47,112,112,91,91,49,49,75,75,0,0,65,65,21,21,87,87,27,27,42,42,29,29,83,83,75,75,46,46,114,114,63,63,16,16,70,70,94,94,67,67,12,12,33,33,80,80,61,61,28,28,102,102,119,119,86,86,122,122,101,101,75,75,79,79,81,81,90,90,18,18,13,13,76,76,91,91,26,26,117,117,84,84,18,18,35,35,9,9,41,41,11,11,77,77,83,83,54,54,74,74,5,5,40,40,49,49,120,120,28,28,32,32,25,25,31,31,65,65,98,98,15,15,88,88,17,17,36,36,56,56,5,5,116,116,115,115,47,47,73,73,113,113,94,94,39,39,64,64,18,18,12,12,37,37,69,69,92,92,10,10,44,44,88,88,52,52,114,114,3,3,38,38,27,27,26,26,3,3,30,30,57,57,28,28,12,12,30,30,113,113,105,105,21,21,78,78,52,52,103,103,5,5,2,2,54,54,37,37,76,76,6,6,11,11,102,102,3,3,114,114,92,92,73,73,56,56,69,69,116,116,89,89,107,107,92,92,99,99,97,97,40,40,83,83,74,74,46,46,59,59,80,80,66,66,87,87,98,98,74,74,32,32,114,114,123,123,10,10,117,117,17,17,91,91,12,12,18,18,20,20,114,114,69,69,64,64,49,49,31,31,56,56,118,118,27,27,112,112,101,101,44,44,51,51,117,117,20,20,4,4,99,99,74,74,121,121,96,96,92,92,0,0,37,37,102,102,15,15,14,14,5,5,83,83,122,122,110,110,82,82,86,86,18,18,12,12,104,104,36,36,39,39,54,54,33,33,49,49,72,72,113,113,34,34,0,0,11,11,16,16,65,65,6,6,27,27,68,68,119,119,68,68,9,9,80,80,90,90,11,11,66,66,98,98,68,68,39,39,124,124,34,34,49,49,30,30,71,71,67,67,115,115,84,84,40,40,53,53,81,81,80,80,119,119,49,49,42,42,15,15,102,102,80,80,11,11,99,99,5,5,50,50,50,50,16,16,84,84,33,33,74,74,2,2,88,88,124,124,112,112,29,29,54,54,50,50,10,10,42,42,77,77,6,6,49,49,79,79,92,92,108,108,6,6,105,105,72,72,19,19,52,52,19,19,73,73,3,3,4,4,78,78,14,14,121,121,78,78,72,72,19,19,62,62,54,54,82,82,36,36,16,16,126,126,2,2,28,28,96,96,104,104,59,59,92,92,14,14,36,36,96,96,68,68,123,123,78,78,16,16,53,53,22,22,59,59,39,39,101,101,9,9,77,77,40,40,116,116,37,37,26,26,13,13,58,58,47,47,1,1,66,66,47,47,64,64,57,57,87,87,112,112,62,62,105,105,15,15,63,63,67,67,32,32,95,95,75,75,101,101,38,38,73,73,82,82,116,116,90,90,1,1,1,1,103,103,21,21,111,111,62,62,49,49,63,63,58,58,122,122,32,32,86,86,21,21,112,112,60,60,65,65,31,31,60,60,72,72,89,89,126,126,71,71,68,68,38,38,12,12,105,105,93,93,30,30,68,68,20,20,40,40,84,84,118,118,101,101,98,98,80,80,6,6,126,126,99,99,39,39,51,51,126,126,104,104,102,102,48,48,112,112,118,118,2,2,85,85,16,16,38,38,102,102,110,110,121,121,28,28,63,63,13,13,12,12,70,70,125,125,94,94,66,66,33,33,127,127,10,10,78,78,109,109,23,23,89,89,110,110,4,4,16,16,46,46,72,72,90,90,56,56,76,76,58,58,76,76,22,22,39,39,102,102,66,66,88,88,72,72,27,27,68,68,34,34,58,58,80,80,5,5,32,32,34,34,106,106,44,44,88,88,11,11,108,108,98,98,61,61,26,26,8,8,91,91,71,71,2,2,51,51,24,24,12,12,39,39,66,66,53,53,20,20,68,68,81,81,126,126,47,47,109,109,6,6,72,72,120,120,12,12,122,122,36,36,26,26,5,5,121,121,22,22,61,61,55,55,62,62,52,52,7,7,113,113,45,45,112,112,53,53,110,110,87,87,30,30,3,3,88,88,106,106,125,125,69,69,76,76,34,34,126,126,124,124,69,69,21,21,44,44,117,117,113,113,44,44,32,32,5,5,122,122,53,53,35,35,74,74,88,88,40,40,0,0,44,44,46,46,44,44,125,125,24,24,52,52,30,30,22,22,5,5,1,1,72,72,50,50,80,80,35,35,50,50,68,68,116,116,81,81,109,109,95,95,55,55,60,60,0,0,90,90,32,32,86,86,121,121,68,68,89,89,6,6,113,113,73,73,51,51,32,32,13,13,118,118,23,23,43,43,66,66,124,124,86,86,60,60,55,55,122,122,107,107,42,42,107,107,46,46,98,98,35,35,118,118,71,71,68,68,32,32,125,125,97,97,73,73,125,125,64,64,68,68,20,20,6,6,109,109,50,50,105,105,97,97,40,40,84,84,70,70,62,62,76,76,47,47,32,32,66,66,13,13,107,107,47,47,9,9,122,122,24,24,99,99,30,30,23,23,9,9,54,54,81,81,33,33,59,59,8,8,0,0,83,83,73,73,2,2,89,89,112,112,54,54,0,0,87,87,116,116,52,52,112,112,49,49,104,104,112,112,1,1,70,70,8,8,12,12,110,110,27,27,35,35,82,82,59,59,104,104,92,92,16,16,44,44,106,106,46,46,74,74,88,88,99,99,36,36,60,60,31,31,30,30,111,111,57,57,124,124,29,29,14,14,90,90,40,40,64,64,40,40,6,6,19,19,60,60,84,84,52,52,6,6,10,10,115,115,58,58,2,2,56,56,100,100,109,109,32,32,16,16,87,87,109,109,7,7,17,17,25,25,27,27,56,56,37,37,4,4,66,66,78,78,120,120,12,12,86,86,91,91,84,84,25,25,54,54,10,10,124,124,60,60,28,28,25,25,51,51,15,15,19,19,46,46,84,84,1,1,35,35,117,117,118,118,26,26,17,17,101,101,68,68,38,38,98,98,123,123,46,46,50,50,120,120,77,77,99,99,20,20,19,19,16,16,12,12,62,62,72,72,84,84,54,54,95,95,84,84,86,86,79,79,103,103,73,73,27,27,7,7,6,6,34,34,89,89,121,121,6,6,38,38,65,65,37,37,30,30,74,74,107,107,38,38,73,73,31,31,112,112,73,73,14,14,28,28,32,32,15,15,70,70,57,57,97,97,12,12,92,92,79,79,37,37,73,73,10,10,45,45,18,18,126,126,80,80,6,6,26,26,62,62,4,4,11,11,31,31,29,29,3,3,105,105,114,114,76,76,78,78,97,97,35,35,123,123,49,49,41,41,68,68,71,71,82,82,23,23,68,68,30,30,102,102,77,77,80,80,84,84,88,88,36,36,39,39,66,66,115,115,3,3,57,57,60,60,23,23,3,3,113,113,87,87,8,8,105,105,8,8,127,127,38,38,101,101,67,67,12,12,80,80,38,38,12,12,98,98,106,106,61,61,12,12,116,116,78,78,118,118,31,31,25,25,10,10,125,125,69,69,7,7,68,68,50,50,62,62,79,79,39,39,32,32,83,83,120,120,12,12,50,50,101,101,26,26,17,17,11,11,94,94,40,40,109,109,17,17,116,116,71,71,68,68,13,13,57,57,40,40,24,24,31,31,61,61,39,39,86,86,47,47,12,12,71,71,36,36,83,83,44,44,23,23,33,33,44,44,35,35,90,90,49,49,76,76,63,63,119,119,76,76,73,73,35,35,39,39,106,106,69,69,16,16,79,79,88,88,14,14,122,122,121,121,54,54,56,56,112,112,67,67,77,77,85,85,103,103,52,52,11,11,37,37,54,54,36,36,77,77,79,79,99,99,7,7,33,33,21,21,101,101,76,76,90,90,0,0,58,58,48,48,77,77,43,43,89,89,51,51,20,20,40,40,86,86,66,66,82,82,20,20,75,75,29,29,38,38,66,66,89,89,20,20,75,75,76,76,84,84,55,55,125,125,18,18,3,3,59,59,6,6,13,13,103,103,51,51,124,124,48,48,21,21,126,126,110,110,48,48,56,56,19,19,108,108,32,32,26,26,85,85,15,15,35,35,9,9,40,40,61,61,10,10,66,66,80,80,107,107,41,41,5,5,38,38,42,42,114,114,116,116,76,76,49,49,105,105,113,113,69,69,52,52,8,8,52,52,85,85,101,101,35,35,15,15,19,19,60,60,38,38,119,119,8,8,4,4,51,51,18,18,3,3,0,0,28,28,77,77,67,67,107,107,1,1,49,49,65,65,4,4,84,84,17,17,12,12,27,27,48,48,96,96,90,90,61,61,2,2,31,31,60,60,108,108,60,60,115,115,114,114,7,7,91,91,89,89,63,63,25,25,86,86,53,53,59,59,115,115,82,82,84,84,24,24,24,24,74,74,14,14,38,38,41,41,30,30,14,14,18,18,7,7,45,45,21,21,114,114,70,70,51,51,5,5,88,88,66,66,98,98,43,43,103,103,74,74,75,75,6,6,83,83,74,74,47,47,37,37,96,96,48,48,9,9,104,104,74,74,75,75,82,82,25,25,45,45,41,41,24,24,31,31,101,101,44,44,86,86,21,21,41,41,32,32,54,54,21,21,90,90,61,61,82,82,26,26,54,54,88,88,127,127,120,120,112,112,95,95,24,24,90,90,82,82,7,7,9,9,27,27,26,26,43,43,112,112,80,80,26,26,88,88,81,81,106,106,11,11,53,53,61,61,113,113,89,89,81,81,127,127,19,19,32,32,109,109,119,119,48,48,29,29,8,8,125,125,89,89,78,78,6,6,110,110,103,103,16,16,35,35,84,84,50,50,25,25,2,2,110,110,125,125,20,20,53,53,117,117,66,66,9,9,79,79,19,19,100,100,48,48,91,91,19,19,104,104,72,72,116,116,120,120,71,71,12,12,12,12,81,81,96,96,101,101,75,75,38,38,66,66,87,87,114,114,86,86,114,114,67,67,0,0,21,21,54,54,72,72,56,56,40,40,27,27,9,9,44,44,118,118,87,87,55,55,114,114,87,87,117,117,105,105,113,113,99,99,32,32,51,51,1,1,116,116,88,88,48,48,33,33,108,108,95,95,71,71,16,16,57,57,83,83,16,16,98,98,59,59,76,76,92,92,32,32,62,62,110,110,60,60,47,47,25,25,89,89,114,114,22,22,110,110,116,116,13,13,87,87,46,46,21,21,72,72,44,44,100,100,66,66,68,68,1,1,20,20,69,69,58,58,36,36,100,100,40,40,35,35,24,24,73,73,35,35,50,50,104,104,11,11,33,33,12,12,53,53,78,78,48,48,88,88,95,95,102,102,5,5,4,4,50,50,48,48,59,59,64,64,50,50,26,26,17,17,91,91,90,90,90,90,33,33,112,112,38,38,4,4,42,42,88,88,91,91,64,64,77,77,101,101,7,7,12,12,60,60,54,54,79,79,47,47,103,103,94,94,1,1,29,29,22,22,4,4,52,52,33,33,117,117,12,12,24,24,84,84,109,109,1,1,24,24,19,19,20,20,2,2,72,72,14,14,97,97,114,114,32,32,13,13,54,54,33,33,11,11,27,27,69,69,89,89,98,98,109,109,93,93,17,17,25,25,29,29,119,119,26,26,49,49,69,69,42,42,116,116,7,7,100,100,10,10,62,62,40,40,31,31,84,84,16,16,31,31,109,109,121,121,74,74,90,90,11,11,9,9,34,34,66,66,35,35,17,17,5,5,68,68,15,15,66,66,84,84,109,109,44,44,13,13,43,43,101,101,20,20,79,79,110,110,120,120,11,11,82,82,0,0,50,50,20,20,106,106,89,89,124,124,19,19,36,36,92,92,49,49,120,120,73,73,56,56,102,102,13,13,9,9,118,118,73,73,56,56,11,11,117,117,34,34,54,54,67,67,89,89,3,3,2,2,95,95,33,33,127,127,40,40,8,8,45,45,84,84,61,61,121,121,94,94,96,96,112,112,0,0,104,104,17,17,79,79,41,41,34,34,56,56,1,1,31,31,22,22,4,4,63,63,94,94,115,115,33,33,82,82,62,62,100,100,69,69,109,109,107,107,55,55,124,124,28,28,68,68,37,37,38,38,123,123,102,102,114,114,41,41,23,23,40,40,83,83,77,77,35,35,110,110,31,31,108,108,48,48,15,15,82,82,47,47,41,41,1,1,21,21,29,29,17,17,29,29,74,74,106,106,26,26,14,14,75,75,5,5,80,80,55,55,24,24,77,77,116,116,19,19,53,53,44,44,77,77,81,81,62,62,63,63,24,24,122,122,10,10,2,2,59,59,107,107,48,48,62,62,56,56,107,107,103,103,108,108,122,122,38,38,53,53,60,60,48,48,40,40,10,10,30,30,119,119,66,66,47,47,93,93,83,83,113,113,84,84,119,119,37,37,104,104,34,34,48,48,32,32,95,95,41,41,112,112,66,66,44,44,118,118,117,117,125,125,10,10,121,121,83,83,19,19,109,109,65,65,64,64,28,28,109,109,102,102,99,99,115,115,26,26,17,17,123,123,112,112,13,13,62,62,15,15,96,96,122,122,82,82,94,94,68,68,93,93,97,97,40,40,104,104,13,13,70,70,86,86,80,80,119,119,45,45,12,12,60,60,58,58,84,84,70,70,53,53,20,20,117,117,75,75,120,120,33,33,96,96,27,27,97,97,86,86,105,105,104,104,79,79,25,25,72,72,119,119,51,51,118,118,121,121,9,9,104,104,36,36,51,51,16,16,43,43,118,118,43,43,78,78,69,69,100,100,119,119,91,91,69,69,99,99,7,7,75,75,114,114,113,113,62,62,114,114,70,70,44,44,21,21,84,84,13,13,107,107,64,64,37,37,113,113,95,95,26,26,3,3,39,39,33,33,20,20,91,91,70,70,22,22,7,7,114,114,56,56,108,108,4,4,12,12,14,14,124,124,29,29,48,48,40,40,79,79,71,71,65,65,91,91,32,32,13,13,81,81,30,30,54,54,103,103,53,53,62,62,50,50,43,43,24,24,90,90,32,32,75,75,90,90,20,20,98,98,7,7,0,0,64,64,51,51,63,63,62,62,28,28,44,44,39,39,31,31,79,79,6,6,115,115,104,104,19,19,27,27,53,53,106,106,69,69,126,126,100,100,114,114,44,44,36,36,96,96,16,16,36,36,110,110,96,96,104,104,30,30,75,75,3,3,47,47,50,50,95,95,96,96,16,16,42,42,25,25,63,63,36,36,73,73,111,111,71,71,0,0,18,18,54,54,102,102,78,78,48,48,35,35,5,5,36,36,104,104,58,58,109,109,30,30,26,26,111,111,97,97,97,97,37,37,23,23,108,108,0,0,43,43,56,56,105,105,42,42,55,55,1,1,82,82,82,82,9,9,8,8,56,56,105,105,122,122,54,54,15,15,95,95,106,106,92,92,73,73,110,110,104,104,28,28,101,101,123,123,37,37,88,88,16,16,28,28,71,71,71,71,35,35,122,122,7,7,40,40,120,120,119,119,5,5,1,1,1,1,115,115,49,49,90,90,42,42,32,32,38,38,115,115,64,64,57,57,59,59,38,38,33,33,78,78,0,0,100,100,118,118,61,61,84,84,24,24,102,102,18,18,74,74,74,74,83,83,1,1,71,71,113,113,29,29,26,26,119,119,82,82,46,46,9,9,53,53,97,97,109,109,8,8,36,36,118,118,106,106,41,41,66,66,62,62,66,66,3,3,70,70,78,78,54,54,81,81,103,103,58,58,96,96,97,97,122,122,51,51,107,107,108,108,89,89,65,65,70,70,33,33,100,100,122,122,79,79,4,4,119,119,18,18,3,3,109,109,67,67,47,47,110,110,53,53,18,18,88,88,18,18,80,80,43,43,54,54,58,58,108,108,91,91,2,2,57,57,73,73,23,23,86,86,39,39,33,33,62,62,83,83,116,116,60,60,106,106,117,117,87,87,117,117,70,70,45,45,99,99,98,98,40,40,120,120,120,120,120,120,0,0,64,64,97,97,103,103,126,126,125,125,101,101,106,106,62,62,104,104,2,2,8,8,7,7,50,50,14,14,82,82,56,56,8,8,69,69,26,26,44,44,23,23,107,107,127,127,80,80,9,9,91,91,93,93,62,62,17,17,12,12,107,107,11,11,45,45,93,93,122,122,89,89,41,41,20,20,40,40,67,67,80,80,61,61,91,91,0,0,113,113,21,21,77,77,98,98,58,58,12,12,104,104,99,99,57,57,50,50,10,10,26,26,41,41,57,57,58,58,45,45,122,122,63,63,72,72,71,71,60,60,104,104,1,1,7,7,33,33,73,73,7,7,56,56,65,65,32,32,121,121,57,57,59,59,43,43,66,66,48,48,66,66,74,74,27,27,33,33,121,121,2,2,72,72,120,120,112,112,21,21,63,63,83,83,54,54,92,92,87,87,116,116,58,58,83,83,76,76,54,54,101,101,119,119,65,65,52,52,116,116,4,4,52,52,59,59,98,98,65,65,44,44,27,27,21,21,113,113,112,112,51,51,32,32,61,61,1,1,82,82,45,45,52,52,64,64,100,100,127,127,30,30,53,53,1,1,32,32,78,78,63,63,42,42,63,63,41,41,48,48,91,91,98,98,113,113,50,50,47,47,103,103,57,57,101,101,115,115,37,37,95,95,113,113,97,97,28,28,79,79,10,10,63,63,120,120,19,19,105,105,51,51,61,61,112,112,74,74,40,40,103,103,91,91,22,22,106,106,51,51,75,75,88,88,67,67,4,4,12,12,46,46,75,75,65,65,16,16,74,74,16,16,81,81,121,121,9,9,59,59,35,35,22,22,107,107,65,65,114,114,61,61,118,118,118,118,46,46,46,46,47,47,20,20,86,86,114,114,21,21,43,43,94,94,29,29,0,0,8,8,64,64,118,118,42,42,17,17,109,109,74,74,76,76,59,59,106,106,91,91,20,20,119,119,12,12,51,51,26,26,55,55,110,110,24,24,6,6,101,101,81,81,16,16,48,48,16,16,43,43,52,52,47,47,61,61,88,88,18,18,24,24,23,23,4,4,80,80,83,83,111,111,24,24,49,49,32,32,91,91,21,21,2,2,38,38,26,26,66,66,42,42,106,106,67,67,117,117,2,2,65,65,14,14,48,48,104,104,52,52,62,62,78,78,77,77,27,27,97,97,35,35,96,96,98,98,0,0,33,33,49,49,22,22,32,32,109,109,17,17,33,33,42,42,88,88,42,42,21,21,50,50,99,99,95,95,80,80,46,46,90,90,110,110,40,40,97,97,21,21,13,13,71,71,42,42,103,103,23,23,114,114,107,107,9,9,125,125,48,48,63,63,80,80,74,74,80,80,76,76,91,91,26,26,10,10,125,125,99,99,103,103,83,83,78,78,11,11,35,35,44,44,86,86,8,8,74,74,114,114,14,14,32,32,110,110,44,44,30,30,120,120,49,49,93,93,38,38,86,86,69,69,31,31,114,114,112,112,31,31,112,112,38,38,115,115,84,84,74,74,25,25,26,26,54,54,106,106,12,12,56,56,97,97,25,25,46,46,58,58,81,81,0,0,89,89,126,126,43,43,125,125,75,75,119,119,7,7,71,71,121,121,104,104,21,21,58,58,124,124,42,42,32,32,42,42,50,50,100,100,109,109,44,44,38,38,84,84,32,32,8,8,61,61,29,29,31,31,34,34,80,80,96,96,29,29,115,115,9,9,65,65,65,65,102,102,40,40,99,99,118,118,48,48,25,25,96,96,126,126,105,105,39,39,65,65,5,5,98,98,27,27,38,38,44,44,5,5,62,62,49,49,12,12,79,79,71,71,36,36,83,83,71,71,20,20,70,70,82,82,80,80,37,37,13,13,108,108,115,115,64,64,75,75,28,28,19,19,115,115,75,75,42,42,86,86,96,96,1,1,123,123,25,25,92,92,83,83,98,98,25,25,114,114,20,20,7,7,4,4,90,90,69,69,67,67,23,23,116,116,89,89,75,75,81,81,21,21,22,22,23,23,46,46,106,106,72,72,75,75,44,44,126,126,2,2,0,0,16,16,55,55,56,56,110,110,61,61,48,48,111,111,16,16,11,11,85,85,2,2,113,113,116,116,88,88,104,104,58,58,111,111,10,10,36,36,91,91,90,90,116,116,21,21,40,40,71,71,44,44,59,59,89,89,4,4,16,16,119,119,104,104,47,47,55,55,57,57,76,76,79,79,76,76,53,53,27,27,8,8,57,57,32,32,90,90,39,39,119,119,62,62,79,79,32,32,36,36,79,79,80,80,15,15,9,9,16,16,88,88,42,42,70,70,114,114,97,97,96,96,45,45,76,76,1,1,36,36,51,51,24,24,92,92,33,33,106,106,67,67,43,43,97,97,92,92,3,3,5,5,69,69,97,97,27,27,4,4,29,29,100,100,7,7,19,19,80,80,76,76,112,112,79,79,124,124,37,37,22,22,123,123,100,100,0,0,92,92,46,46,121,121,42,42,99,99,99,99,64,64,117,117,91,91,90,90,8,8,5,5,84,84,3,3,116,116,97,97,64,64,77,77,84,84,22,22,13,13,94,94,82,82,13,13,99,99,115,115,28,28,51,51,110,110,10,10,40,40,33,33,20,20,46,46,59,59,108,108,99,99,85,85,10,10,0,0,75,75,8,8,109,109,43,43,31,31,48,48,122,122,102,102,114,114,94,94,6,6,88,88,18,18,69,69,41,41,27,27,13,13,116,116,71,71,33,33,92,92,81,81,101,101,62,62,99,99,102,102,32,32,65,65,77,77,63,63,79,79,71,71,111,111,9,9,85,85,98,98,69,69,31,31,25,25,91,91,89,89,20,20,58,58,119,119,79,79,95,95,111,111,35,35,123,123,116,116,13,13,69,69,88,88,105,105,61,61,49,49,56,56,52,52,12,12,127,127,84,84,44,44,88,88,78,78,29,29,37,37,96,96,103,103,17,17,124,124,126,126,120,120,46,46,0,0,107,107,76,76,100,100,69,69,44,44,94,94,83,83,116,116,63,63,40,40,19,19,71,71,58,58,101,101,47,47,4,4,105,105,109,109,33,33,28,28,80,80,84,84,0,0,35,35,119,119,62,62,121,121,37,37,86,86,12,12,77,77,64,64,23,23,0,0,55,55,38,38,61,61,98,98,103,103,118,118,32,32,50,50,42,42,67,67,72,72,54,54,42,42,105,105,5,5,58,58,11,11,39,39,75,75,43,43,45,45,108,108,6,6,72,72,48,48,100,100,5,5,31,31,50,50,114,114,92,92,1,1,110,110,62,62,74,74,122,122,80,80,88,88,98,98,96,96,45,45,93,93,77,77,127,127,97,97,97,97,33,33,39,39,104,104,85,85,77,77,42,42,85,85,83,83,91,91,6,6,6,6,124,124,80,80,45,45,76,76,125,125,15,15,62,62,4,4,66,66,124,124,60,60,99,99,42,42,76,76,101,101,52,52,4,4,67,67,43,43,69,69,105,105,107,107,73,73,64,64,28,28,36,36,113,113,88,88,7,7,76,76,8,8,100,100,2,2,75,75,30,30,34,34,72,72,104,104,60,60,96,96,36,36,94,94,105,105,56,56,47,47,102,102,114,114,60,60,59,59,104,104,40,40,18,18,59,59,29,29,103,103,0,0,88,88,53,53,114,114,80,80,43,43,20,20,5,5,99,99,127,127,67,67,24,24,53,53,81,81,47,47,61,61,76,76,120,120,49,49,111,111,104,104,10,10,61,61,104,104,21,21,37,37,54,54,96,96,41,41,2,2,123,123,24,24,16,16,104,104,90,90,87,87,121,121,11,11,19,19,64,64,24,24,93,93,69,69,6,6,39,39,106,106,82,82,55,55,11,11,8,8,60,60,117,117,56,56,73,73,125,125,114,114,77,77,14,14,7,7,72,72,59,59,29,29,32,32,97,97,75,75,41,41,46,46,86,86,42,42,89,89,45,45,54,54,83,83,83,83,50,50,121,121,109,109,13,13,38,38,113,113,94,94,41,41,104,104,126,126,3,3,110,110,103,103,10,10,84,84,34,34,57,57,94,94,5,5,29,29,101,101,115,115,0,0,117,117,123,123,123,123,120,120,34,34,81,81,106,106,119,119,30,30,0,0,80,80,5,5,38,38,127,127,70,70,118,118,14,14,116,116,74,74,108,108,70,70,72,72,1,1,120,120,16,16,126,126,9,9,79,79,32,32,94,94,37,37,4,4,99,99,5,5,44,44,57,57,6,6,41,41,70,70,86,86,118,118,125,125,50,50,124,124,24,24,30,30,78,78,119,119,50,50,85,85,66,66,98,98,81,81,26,26,37,37,33,33,99,99,20,20,82,82,86,86,123,123,26,26,116,116,85,85,118,118,47,47,4,4,83,83,86,86,56,56,56,56,80,80,116,116,93,93,48,48,62,62,102,102,1,1,57,57,68,68,123,123,5,5,30,30,82,82,109,109,39,39,103,103,92,92,6,6,96,96,119,119,46,46,99,99,36,36,127,127,37,37,80,80,10,10,99,99,81,81,57,57,59,59,32,32,74,74,111,111,44,44,12,12,33,33,111,111,104,104,20,20,16,16,63,63,43,43,84,84,101,101,65,65,123,123,77,77,97,97,5,5,48,48,41,41,26,26,17,17,25,25,79,79,43,43,36,36,58,58,53,53,106,106,49,49,40,40,41,41,55,55,52,52,80,80,44,44,88,88,52,52,103,103,105,105,11,11,52,52,105,105,107,107,105,105,120,120,17,17,74,74,88,88,105,105,21,21,37,37,6,6,60,60,87,87,19,19,26,26,50,50,26,26,3,3,96,96,105,105,97,97,33,33,38,38,74,74,125,125,60,60,27,27,34,34,16,16,51,51,127,127,59,59,99,99,22,22,13,13,28,28,74,74,71,71,82,82,37,37,73,73,66,66,81,81,109,109,85,85,22,22,6,6,14,14,82,82,101,101,45,45,51,51,1,1,67,67,115,115,64,64,30,30,34,34,39,39,97,97,76,76,104,104,14,14,41,41,106,106,70,70,81,81,66,66,7,7,73,73,43,43,19,19,110,110,64,64,17,17,49,49,1,1,69,69,18,18,87,87,21,21,127,127,84,84,36,36,93,93,100,100,24,24,50,50,91,91,22,22,102,102,22,22,13,13,17,17,112,112,65,65,62,62,41,41,97,97,115,115,122,122,70,70,24,24,16,16,106,106,51,51,4,4,27,27,28,28,116,116,73,73,20,20,117,117,118,118,15,15,55,55,36,36,82,82,116,116,62,62,47,47,125,125,22,22,77,77,77,77,33,33,16,16,46,46,45,45,90,90,101,101,48,48,86,86,16,16,17,17,25,25,85,85,13,13,3,3,93,93,41,41,98,98,51,51,84,84,50,50,13,13,33,33,13,13,45,45,96,96,97,97,41,41,26,26,116,116,87,87,89,89,15,15,124,124,114,114,80,80,53,53,103,103,123,123,87,87,2,2,34,34,120,120,38,38,109,109,70,70,4,4,2,2,63,63,60,60,4,4,107,107,42,42,30,30,28,28,126,126,104,104,84,84,90,90,4,4,108,108,117,117,82,82,51,51,52,52,4,4,9,9,4,4,98,98,113,113,47,47,35,35,76,76,28,28,99,99,103,103,26,26,98,98,93,93,26,26,87,87,125,125,78,78,60,60,45,45,90,90,66,66,67,67,33,33,22,22,5,5,28,28,35,35,110,110,26,26,91,91,63,63,70,70,83,83,8,8,33,33,36,36,102,102,10,10,28,28,119,119,15,15,19,19,19,19,1,1,112,112,12,12,57,57,119,119,49,49,88,88,106,106,100,100,41,41,6,6,38,38,4,4,127,127,39,39,0,0,9,9,85,85,12,12,101,101,24,24,39,39,114,114,1,1,101,101,116,116,21,21,31,31,60,60,119,119,99,99,15,15,23,23,72,72,53,53,56,56,89,89,38,38,102,102,74,74,6,6,121,121,32,32,31,31,89,89,102,102,105,105,36,36,66,66,123,123,20,20,78,78,64,64,80,80,65,65,4,4,86,86,113,113,91,91,105,105,51,51,76,76,72,72,3,3,83,83,85,85,60,60,33,33,96,96,56,56,25,25,2,2,89,89,47,47,76,76,95,95,86,86,3,3,36,36,72,72,51,51,55,55,44,44,8,8,59,59,77,77,27,27,42,42,83,83,99,99,75,75,33,33,74,74,39,39,18,18,45,45,4,4,39,39,107,107,53,53,47,47,121,121,42,42,38,38,72,72,41,41,75,75,49,49,30,30,6,6,3,3,115,115,6,6,4,4,58,58,25,25,67,67,17,17,17,17,7,7,82,82,59,59,10,10,69,69,1,1,114,114,9,9,20,20,12,12,84,84,51,51,3,3,44,44,13,13,28,28,55,55,8,8,19,19,106,106,118,118,78,78,41,41,111,111,16,16,100,100,117,117,95,95,63,63,13,13,37,37,58,58,51,51,38,38,8,8,23,23,2,2,17,17,46,46,10,10,2,2,10,10,26,26,52,52,106,106,4,4,127,127,100,100,41,41,78,78,37,37,32,32,30,30,124,124,5,5,16,16,30,30,22,22,42,42,86,86,84,84,5,5,55,55,23,23,66,66,101,101,30,30,103,103,67,67,36,36,81,81,74,74,98,98,91,91,109,109,4,4,119,119,22,22,71,71,76,76,79,79,46,46,20,20,82,82,50,50,81,81,118,118,15,15,96,96,0,0,23,23,110,110,28,28,1,1,26,26,10,10,57,57,6,6,99,99,93,93,98,98,11,11,46,46,52,52,59,59,62,62,33,33,61,61,45,45,25,25,85,85,91,91,70,70,124,124,103,103,85,85,106,106,34,34,97,97,90,90,73,73,115,115,91,91,17,17,26,26,33,33,40,40,83,83,83,83,31,31,91,91,81,81,61,61,107,107,119,119,92,92,102,102,83,83,126,126,68,68,72,72,80,80,2,2,111,111,57,57,125,125,40,40,35,35,40,40,80,80,85,85,34,34,22,22,21,21,27,27,57,57,51,51,82,82,39,39,32,32,48,48,113,113,103,103,91,91,85,85,121,121,41,41,109,109,21,21,21,21,61,61,85,85,85,85,75,75,51,51,2,2,80,80,16,16,57,57,7,7,115,115,113,113,63,63,70,70,72,72,114,114,12,12,14,14,17,17,5,5,23,23,97,97,92,92,12,12,54,54,7,7,58,58,39,39,30,30,78,78,75,75,65,65,80,80,42,42,35,35,120,120,84,84,94,94,48,48,110,110,41,41,77,77,46,46,97,97,75,75,16,16,10,10,120,120,9,9,86,86,22,22,5,5,80,80,48,48,13,13,88,88,107,107,105,105,10,10,74,74,31,31,33,33,13,13,84,84,111,111,11,11,52,52,68,68,35,35,86,86,70,70,78,78,52,52,85,85,22,22,90,90,32,32,75,75,124,124,110,110,61,61,0,0,114,114,118,118,66,66,86,86,22,22,58,58,91,91,95,95,85,85,89,89,25,25,47,47,119,119,113,113,90,90,35,35,86,86,69,69,104,104,22,22,12,12,41,41,11,11,77,77,45,45,72,72,48,48,41,41,113,113,82,82,125,125,18,18,37,37,102,102,100,100,78,78,64,64,93,93,20,20,106,106,0,0,126,126,23,23,22,22,96,96,13,13,82,82,105,105,16,16,126,126,45,45,120,120,63,63,63,63,49,49,3,3,81,81,101,101,56,56,26,26,1,1,16,16,37,37,94,94,123,123,88,88,58,58,115,115,12,12,39,39,3,3,19,19,26,26,9,9,89,89,57,57,90,90,29,29,81,81,85,85,62,62,82,82,84,84,41,41,8,8,26,26,116,116,61,61,57,57,82,82,34,34,72,72,12,12,12,12,50,50,19,19,115,115,83,83,53,53,103,103,86,86,18,18,107,107,12,12,122,122,126,126,108,108,97,97,12,12,67,67,42,42,74,74,113,113,100,100,84,84,52,52,25,25,59,59,72,72,87,87,76,76,115,115,91,91,58,58,72,72,0,0,52,52,50,50,17,17,100,100,43,43,105,105,126,126,69,69,16,16,79,79,111,111,108,108,110,110,0,0,126,126,50,50,80,80,65,65,77,77,18,18,113,113,97,97,97,97,54,54,73,73,0,0,123,123,72,72,32,32,80,80,73,73,118,118,48,48,39,39,21,21,19,19,62,62,14,14,12,12,8,8,63,63,7,7,46,46,20,20,117,117,31,31,37,37,64,64,122,122,66,66,5,5,28,28,110,110,72,72,0,0,17,17,80,80,48,48,37,37,100,100,27,27,26,26,125,125,126,126,20,20,76,76,97,97,29,29,31,31,117,117,68,68,69,69,87,87,52,52,10,10,102,102,48,48,74,74,91,91,59,59,98,98,44,44,52,52,108,108,76,76,121,121,9,9,62,62,121,121,0,0,6,6,69,69,13,13,115,115,5,5,34,34,114,114,116,116,37,37,122,122,85,85,90,90,113,113,40,40,109,109,110,110,16,16,40,40,96,96,1,1,65,65,28,28,108,108,100,100,33,33,2,2,123,123,107,107,31,31,35,35,52,52,21,21,108,108,120,120,109,109,75,75,75,75,43,43,22,22,52,52,21,21,120,120,120,120,121,121,98,98,60,60,40,40,68,68,27,27,32,32,75,75,11,11,108,108,43,43,4,4,42,42,14,14,111,111,11,11,17,17,33,33,34,34,38,38,100,100,43,43,36,36,49,49,32,32,52,52,86,86,53,53,36,36,41,41,43,43,121,121,32,32,13,13,100,100,36,36,90,90,88,88,43,43,6,6,84,84,108,108,102,102,19,19,120,120,82,82,94,94,39,39,126,126,90,90,1,1,73,73,109,109,119,119,44,44,86,86,98,98,88,88,120,120,122,122,83,83,39,39,2,2,48,48,68,68,9,9,17,17,41,41,112,112,88,88,11,11,80,80,30,30,84,84,23,23,125,125,1,1,109,109,22,22,74,74,1,1,94,94,55,55,55,55,95,95,3,3,44,44,66,66,57,57,36,36,56,56,84,84,77,77,45,45,81,81,42,42,67,67,33,33,36,36,42,42,33,33,122,122,66,66,36,36,93,93,4,4,99,99,105,105,42,42,41,41,114,114,26,26,64,64,10,10,22,22,50,50,8,8,69,69,14,14,84,84,115,115,1,1,56,56,97,97,78,78,40,40,21,21,87,87,102,102,46,46,25,25,17,17,25,25,67,67,97,97,26,26,104,104,5,5,31,31,102,102,123,123,100,100,103,103,85,85,127,127,36,36,35,35,93,93,20,20,57,57,12,12,108,108,73,73,42,42,99,99,93,93,87,87,100,100,57,57,18,18,55,55,33,33,3,3,24,24,126,126,87,87,51,51,52,52,75,75,102,102,25,25,107,107,37,37,89,89,107,107,117,117,90,90,72,72,97,97,5,5,67,67,117,117,121,121,63,63,55,55,4,4,102,102,6,6,35,35,33,33,59,59,10,10,12,12,55,55,106,106,75,75,48,48,46,46,78,78,28,28,103,103,64,64,36,36,73,73,106,106,63,63,1,1,64,64,41,41,30,30,126,126,50,50,36,36,58,58,30,30,37,37,85,85,6,6,31,31,57,57,38,38,73,73,60,60,11,11,17,17,116,116,82,82,47,47,87,87,46,46,8,8,73,73,68,68,118,118,95,95,33,33,66,66,93,93,60,60,71,71,125,125,88,88,45,45,95,95,14,14,77,77,60,60,9,9,51,51,51,51,58,58,48,48,39,39,78,78,68,68,77,77,64,64,62,62,37,37,18,18,118,118,16,16,66,66,40,40,41,41,67,67,83,83,18,18,28,28,107,107,29,29,42,42,6,6,13,13,120,120,107,107,78,78,60,60,3,3,79,79,79,79,36,36,77,77,113,113,84,84,2,2,48,48,33,33,102,102,66,66,93,93,16,16,104,104,125,125,69,69,14,14,22,22,14,14,28,28,2,2,59,59,117,117,49,49,48,48,106,106,20,20,58,58,3,3,67,67,21,21,96,96,47,47,84,84,89,89,88,88,108,108,67,67,52,52,16,16,30,30,29,29,10,10,19,19,39,39,68,68,6,6,21,21,105,105,21,21,19,19,18,18,32,32,76,76,37,37,6,6,103,103,57,57,35,35,65,65,79,79,26,26,122,122,20,20,44,44,7,7,123,123,104,104,71,71,73,73,14,14,126,126,69,69,3,3,125,125,38,38,50,50,102,102,98,98,61,61,47,47,97,97,107,107,55,55,105,105,119,119,88,88,104,104,11,11,80,80,72,72,9,9,82,82,84,84,105,105,3,3,6,6,21,21,88,88,106,106,58,58,3,3,123,123,73,73,71,71,57,57,20,20,87,87,124,124,90,90,117,117,103,103,61,61,114,114,116,116,21,21,34,34,50,50,69,69,106,106,121,121,84,84,53,53,100,100,122,122,99,99,2,2,56,56,101,101,29,29,96,96,85,85,30,30,118,118,60,60,101,101,32,32,109,109,81,81,68,68,51,51,83,83,56,56,125,125,16,16,116,116,32,32,70,70,126,126,109,109,80,80,94,94,20,20,103,103,80,80,7,7,48,48,100,100,98,98,31,31,87,87,106,106,79,79,24,24,96,96,79,79,96,96,28,28,126,126,18,18,117,117,59,59,36,36,80,80,48,48,98,98,26,26,20,20,9,9,21,21,45,45,18,18,70,70,15,15,104,104,71,71,113,113,77,77,10,10,39,39,24,24,72,72,113,113,90,90,107,107,13,13,3,3,74,74,70,70,109,109,85,85,16,16,0,0,16,16,63,63,109,109,76,76,19,19,47,47,82,82,48,48,85,85,30,30,56,56,42,42,80,80,60,60,79,79,6,6,46,46,121,121,83,83,38,38,33,33,118,118,64,64,83,83,57,57,108,108,92,92,5,5,64,64,91,91,37,37,77,77,50,50,17,17,7,7,61,61,78,78,19,19,59,59,47,47,96,96,114,114,75,75,101,101,67,67,29,29,68,68,61,61,121,121,83,83,64,64,32,32,70,70,31,31,15,15,97,97,1,1,41,41,16,16,45,45,76,76,118,118,59,59,115,115,114,114,46,46,4,4,90,90,110,110,33,33,15,15,83,83,23,23,90,90,5,5,17,17,98,98,65,65,35,35,53,53,9,9,110,110,99,99,1,1,52,52,41,41,39,39,69,69,26,26,43,43,43,43,26,26,50,50,60,60,3,3,52,52,44,44,43,43,121,121,42,42,58,58,36,36,19,19,45,45,72,72,98,98,59,59,117,117,30,30,18,18,7,7,74,74,56,56,115,115,40,40,118,118,22,22,35,35,93,93,55,55,18,18,108,108,64,64,55,55,29,29,62,62,64,64,86,86,63,63,49,49,71,71,92,92,86,86,33,33,50,50,105,105,65,65,119,119,78,78,87,87,8,8,88,88,12,12,93,93,104,104,7,7,39,39,97,97,10,10,27,27,64,64,16,16,115,115,99,99,86,86,105,105,45,45,112,112,2,2,51,51,91,91,74,74,31,31,105,105,121,121,46,46,120,120,19,19,84,84,38,38,67,67,88,88,32,32,36,36,48,48,82,82,40,40,80,80,3,3,97,97,90,90,102,102,28,28,51,51,16,16,38,38,66,66,122,122,4,4,104,104,80,80,92,92,3,3,55,55,59,59,52,52,67,67,41,41,95,95,28,28,60,60,101,101,27,27,97,97,116,116,56,56,49,49,92,92,119,119,86,86,49,49,91,91,5,5,114,114,30,30,70,70,36,36,86,86,4,4,67,67,76,76,108,108,36,36,83,83,26,26,40,40,107,107,44,44,12,12,74,74,24,24,53,53,91,91,48,48,61,61,70,70,0,0,44,44,42,42,76,76,90,90,78,78,32,32,42,42,61,61,90,90,83,83,99,99,116,116,63,63,48,48,80,80,46,46,23,23,83,83,104,104,107,107,80,80,71,71,116,116,0,0,47,47,34,34,52,52,22,22,102,102,97,97,75,75,66,66,7,7,98,98,36,36,64,64,3,3,51,51,56,56,73,73,18,18,81,81,39,39,5,5,105,105,27,27,83,83,60,60,52,52,23,23,96,96,18,18,121,121,79,79,39,39,103,103,36,36,56,56,123,123,101,101,83,83,42,42,21,21,68,68,50,50,48,48,72,72,34,34,91,91,85,85,12,12,42,42,54,54,19,19,0,0,109,109,40,40,78,78,1,1,97,97,83,83,21,21,119,119,25,25,1,1,5,5,15,15,63,63,41,41,35,35,11,11,87,87,95,95,119,119,17,17,87,87,23,23,48,48,40,40,118,118,50,50,34,34,104,104,22,22,119,119,36,36,36,36,28,28,22,22,71,71,24,24,34,34,88,88,35,35,59,59,60,60,116,116,53,53,14,14,81,81,105,105,75,75,18,18,122,122,5,5,62,62,64,64,66,66,58,58,62,62,32,32,65,65,83,83,34,34,108,108,13,13,14,14,26,26,113,113,24,24,8,8,100,100,92,92,23,23,38,38,58,58,118,118,12,12,126,126,81,81,46,46,50,50,62,62,95,95,120,120,44,44,38,38,104,104,66,66,70,70,5,5,20,20,56,56,74,74,118,118,39,39,86,86,73,73,75,75,43,43,66,66,38,38,112,112,26,26,43,43,100,100,12,12,61,61,7,7,115,115,13,13,67,67,35,35,120,120,92,92,72,72,24,24,11,11,78,78,95,95,41,41,127,127,2,2,10,10,109,109,47,47,9,9,23,23,30,30,30,30,125,125,81,81,63,63,92,92,63,63,60,60,83,83,19,19,8,8,113,113,49,49,96,96,72,72,4,4,53,53,109,109,67,67,9,9,47,47,0,0,77,77,120,120,16,16,74,74,49,49,123,123,100,100,42,42,65,65,12,12,86,86,24,24,17,17,32,32,81,81,43,43,67,67,45,45,20,20,91,91,71,71,53,53,55,55,112,112,72,72,88,88,110,110,18,18,123,123,26,26,37,37,32,32,76,76,116,116,113,113,98,98,14,14,62,62,5,5,76,76,57,57,5,5,21,21,116,116,11,11,42,42,81,81,55,55,104,104,120,120,16,16,46,46,125,125,99,99,104,104,7,7,45,45,43,43,101,101,46,46,40,40,54,54,90,90,40,40,109,109,114,114,25,25,87,87,47,47,97,97,59,59,106,106,122,122,80,80,97,97,41,41,3,3,84,84,20,20,77,77,42,42,110,110,108,108,28,28,6,6,16,16,117,117,91,91,34,34,96,96,1,1,126,126,0,0,100,100,45,45,89,89,89,89,84,84,84,84,49,49,102,102,85,85,78,78,55,55,123,123,16,16,32,32,61,61,109,109,80,80,28,28,3,3,121,121,30,30,80,80,10,10,110,110,105,105,1,1,88,88,43,43,19,19,121,121,35,35,76,76,104,104,120,120,57,57,5,5,26,26,98,98,97,97,17,17,67,67,37,37,41,41,89,89,32,32,18,18,27,27,123,123,11,11,3,3,35,35,73,73,39,39,71,71,99,99,107,107,4,4,12,12,91,91,13,13,6,6,91,91,27,27,59,59,44,44,13,13,15,15,62,62,18,18,39,39,54,54,112,112,105,105,33,33,11,11,16,16,40,40,61,61,15,15,44,44,59,59,9,9,45,45,95,95,117,117,44,44,90,90,104,104,47,47,122,122,41,41,38,38,38,38,96,96,68,68,26,26,59,59,91,91,65,65,60,60,43,43,1,1,5,5,30,30,43,43,15,15,68,68,37,37,34,34,36,36,54,54,93,93,78,78,78,78,4,4,8,8,108,108,119,119,66,66,126,126,10,10,37,37,12,12,47,47,24,24,12,12,42,42,24,24,40,40,71,71,65,65,17,17,55,55,33,33,13,13,120,120,23,23,57,57,121,121,11,11,4,4,8,8,99,99,60,60,1,1,94,94,34,34,19,19,98,98,108,108,96,96,70,70,102,102,87,87,100,100,24,24,55,55,58,58,14,14,9,9,103,103,119,119,112,112,6,6,6,6,81,81,41,41,112,112,89,89,40,40,50,50,26,26,72,72,120,120,68,68,7,7,51,51,126,126,11,11,113,113,104,104,85,85,69,69,42,42,14,14,110,110,96,96,33,33,80,80,58,58,45,45,42,42,13,13,6,6,58,58,38,38,124,124,53,53,98,98,13,13,38,38,118,118,100,100,39,39,110,110,15,15,54,54,97,97,45,45,45,45,32,32,24,24,76,76,53,53,72,72,35,35,109,109,62,62,127,127,74,74,26,26,3,3,49,49,41,41,45,45,55,55,84,84,89,89,113,113,111,111,21,21,91,91,32,32,114,114,26,26,70,70,16,16,124,124,73,73,16,16,43,43,14,14,4,4,8,8,26,26,97,97,46,46,86,86,64,64,67,67,36,36,125,125,1,1,11,11,59,59,41,41,21,21,78,78,26,26,54,54,50,50,51,51,15,15,59,59,99,99,11,11,47,47,70,70,117,117,107,107,85,85,10,10,9,9,46,46,19,19,29,29,105,105,103,103,76,76,31,31,32,32,71,71,75,75,7,7,82,82,56,56,11,11,99,99,20,20,16,16,70,70,11,11,87,87,81,81,89,89,83,83,53,53,56,56,56,56,100,100,62,62,2,2,45,45,109,109,4,4,117,117,97,97,19,19,9,9,20,20,96,96,26,26,11,11,125,125,16,16,14,14,54,54,122,122,15,15,0,0,11,11,104,104,28,28,100,100,40,40,40,40,96,96,36,36,118,118,37,37,99,99,27,27,117,117,69,69,121,121,115,115,93,93,36,36,125,125,72,72,3,3,6,6,94,94,6,6,69,69,78,78,87,87,25,25,97,97,42,42,72,72,19,19,27,27,20,20,122,122,54,54,4,4,20,20,6,6,12,12,50,50,80,80,17,17,92,92,38,38,97,97,113,113,91,91,46,46,12,12,83,83,4,4,33,33,16,16,98,98,46,46,39,39,48,48,63,63,69,69,17,17,96,96,102,102,81,81,96,96,46,46,71,71,121,121,8,8,82,82,26,26,88,88,53,53,58,58,121,121,26,26,35,35,116,116,90,90,17,17,120,120,9,9,72,72,95,95,93,93,69,69,18,18,61,61,106,106,117,117,88,88,24,24,6,6,104,104,74,74,48,48,15,15,117,117,116,116,54,54,122,122,116,116,86,86,92,92,53,53,55,55,82,82,10,10,83,83,106,106,81,81,27,27,103,103,125,125,82,82,24,24,16,16,46,46,30,30,96,96,106,106,80,80,4,4,75,75,61,61,100,100,47,47,95,95,1,1,104,104,9,9,9,9,9,9,9,9,91,91,48,48,24,24,97,97,39,39,116,116,78,78,107,107,93,93,57,57,105,105,44,44,31,31,79,79,13,13,18,18,11,11,126,126,74,74,113,113,53,53,112,112,103,103,64,64,10,10,96,96,14,14,121,121,107,107,60,60,12,12,81,81,45,45,15,15,119,119,107,107,27,27,57,57,20,20,88,88,66,66,52,52,97,97,125,125,99,99,28,28,40,40,127,127,53,53,23,23,10,10,57,57,42,42,72,72,46,46,84,84,115,115,29,29,65,65,83,83,5,5,9,9,111,111,49,49,107,107,44,44,74,74,10,10,66,66,33,33,25,25,32,32,32,32,61,61,95,95,40,40,43,43,99,99,99,99,72,72,117,117,103,103,25,25,20,20,8,8,107,107,24,24,13,13,50,50,119,119,0,0,19,19,16,16,111,111,18,18,96,96,75,75,41,41,27,27,4,4,38,38,106,106,64,64,125,125,120,120,36,36,76,76,25,25,115,115,31,31,36,36,86,86,45,45,8,8,53,53,2,2,69,69,75,75,25,25,80,80,115,115,24,24,64,64,96,96,63,63,1,1,103,103,90,90,27,27,51,51,6,6,5,5,75,75,54,54,57,57,95,95,90,90,108,108,24,24,92,92,107,107,101,101,93,93,104,104,101,101,46,46,42,42,39,39,100,100,5,5,67,67,38,38,13,13,108,108,125,125,124,124,18,18,118,118,114,114,91,91,11,11,106,106,79,79,15,15,87,87,12,12,120,120,22,22,100,100,21,21,81,81,38,38,34,34,64,64,34,34,39,39,21,21,19,19,118,118,73,73,43,43,48,48,86,86,78,78,96,96,92,92,51,51,18,18,90,90,80,80,58,58,104,104,26,26,112,112,86,86,59,59,93,93,66,66,113,113,21,21,1,1,113,113,15,15,39,39,17,17,65,65,14,14,76,76,35,35,72,72,63,63,87,87,50,50,12,12,73,73,114,114,94,94,92,92,5,5,0,0,35,35,44,44,119,119,105,105,3,3,118,118,55,55,27,27,7,7,77,77,87,87,62,62,106,106,31,31,96,96,86,86,122,122,39,39,57,57,48,48,114,114,65,65,13,13,60,60,92,92,48,48,24,24,6,6,79,79,64,64,10,10,57,57,76,76,121,121,72,72,106,106,17,17,13,13,113,113,35,35,43,43,30,30,64,64,4,4,63,63,7,7,126,126,96,96,76,76,20,20,11,11,43,43,70,70,0,0,80,80,4,4,73,73,104,104,42,42,15,15,43,43,36,36,34,34,9,9,41,41,80,80,107,107,79,79,52,52,10,10,99,99,84,84,55,55,41,41,78,78,98,98,40,40,65,65,119,119,28,28,52,52,68,68,125,125,68,68,33,33,93,93,66,66,125,125,106,106,42,42,37,37,112,112,81,81,13,13,41,41,10,10,45,45,7,7,78,78,22,22,39,39,49,49,64,64,13,13,1,1,36,36,62,62,15,15,48,48,120,120,55,55,113,113,107,107,74,74,45,45,80,80,33,33,39,39,1,1,126,126,101,101,37,37,59,59,37,37,27,27,78,78,59,59,124,124,55,55,122,122,0,0,120,120,81,81,17,17,24,24,101,101,35,35,88,88,104,104,70,70,51,51,20,20,90,90,7,7,12,12,15,15,112,112,76,76,104,104,26,26,3,3,32,32,88,88,78,78,29,29,29,29,82,82,41,41,32,32,100,100,72,72,81,81,112,112,55,55,9,9,112,112,29,29,31,31,99,99,111,111,115,115,0,0,26,26,61,61,53,53,97,97,123,123,71,71,46,46,27,27,81,81,96,96,91,91,77,77,42,42,97,97,1,1,127,127,34,34,96,96,83,83,7,7,42,42,52,52,82,82,8,8,55,55,78,78,10,10,42,42,87,87,88,88,123,123,40,40,8,8,27,27,81,81,91,91,62,62,9,9,7,7,31,31,33,33,37,37,121,121,120,120,65,65,10,10,101,101,87,87,70,70,114,114,69,69,116,116,5,5,48,48,8,8,99,99,62,62,104,104,41,41,82,82,41,41,20,20,32,32,106,106,15,15,3,3,47,47,42,42,9,9,8,8,68,68,114,114,22,22,41,41,65,65,27,27,71,71,84,84,106,106,48,48,124,124,83,83,79,79,56,56,9,9,6,6,48,48,115,115,43,43,13,13,11,11,74,74,29,29,36,36,31,31,32,32,62,62,125,125,6,6,114,114,58,58,30,30,116,116,100,100,13,13,94,94,111,111,105,105,20,20,90,90,68,68,93,93,93,93,0,0,8,8,52,52,57,57,20,20,48,48,86,86,120,120,78,78,39,39,59,59,64,64,25,25,25,25,64,64,14,14,23,23,12,12,30,30,35,35,12,12,109,109,27,27,116,116,82,82,3,3,9,9,3,3,84,84,44,44,13,13,124,124,35,35,51,51,36,36,126,126,30,30,69,69,89,89,125,125,73,73,102,102,43,43,26,26,35,35,92,92,88,88,122,122,112,112,68,68,69,69,53,53,72,72,52,52,46,46,6,6,27,27,71,71,65,65,60,60,96,96,29,29,90,90,2,2,101,101,38,38,33,33,43,43,55,55,16,16,83,83,27,27,45,45,69,69,54,54,110,110,54,54,3,3,112,112,26,26,39,39,33,33,58,58,35,35,0,0,8,8,110,110,74,74,114,114,43,43,93,93,74,74,10,10,4,4,107,107,96,96,55,55,21,21,93,93,80,80,84,84,114,114,65,65,40,40,78,78,57,57,58,58,104,104,126,126,65,65,95,95,102,102,95,95,21,21,120,120,87,87,100,100,4,4,34,34,123,123,27,27,38,38,13,13,59,59,10,10,81,81,73,73,51,51,67,67,2,2,50,50,3,3,126,126,125,125,60,60,76,76,112,112,26,26,18,18,29,29,104,104,72,72,2,2,102,102,61,61,72,72,126,126,34,34,124,124,122,122,72,72,21,21,118,118,33,33,111,111,57,57,59,59,77,77,28,28,66,66,51,51,119,119,81,81,25,25,36,36,16,16,21,21,82,82,2,2,48,48,56,56,94,94,0,0,29,29,126,126,9,9,15,15,47,47,36,36,11,11,56,56,43,43,103,103,77,77,70,70,4,4,105,105,94,94,114,114,34,34,7,7,1,1,110,110,40,40,19,19,24,24,2,2,0,0,18,18,65,65,30,30,25,25,19,19,86,86,91,91,89,89,84,84,34,34,81,81,56,56,104,104,15,15,122,122,3,3,2,2,61,61,113,113,100,100,106,106,28,28,22,22,97,97,4,4,38,38,52,52,17,17,106,106,102,102,68,68,57,57,120,120,15,15,100,100,3,3,113,113,21,21,0,0,69,69,39,39,85,85,96,96,126,126,50,50,51,51,111,111,35,35,94,94,50,50,54,54,23,23,44,44,78,78,98,98,88,88,50,50,45,45,103,103,82,82,39,39,19,19,6,6,62,62,108,108,13,13,18,18,107,107,55,55,91,91,13,13,0,0,37,37,82,82,19,19,43,43,78,78,87,87,117,117,40,40,98,98,36,36,19,19,125,125,49,49,55,55,77,77,26,26,20,20,121,121,84,84,113,113,122,122,68,68,92,92,31,31,111,111,56,56,57,57,58,58,88,88,71,71,60,60,77,77,12,12,16,16,93,93,4,4,0,0,116,116,66,66,22,22,68,68,45,45,67,67,18,18,0,0,30,30,2,2,5,5,44,44,52,52,4,4,62,62,5,5,4,4,104,104,0,0,24,24,32,32,54,54,76,76,100,100,17,17,38,38,60,60,69,69,15,15,2,2,15,15,79,79,98,98,49,49,8,8,72,72,121,121,54,54,47,47,12,12,77,77,122,122,14,14,19,19,55,55,5,5,66,66,80,80,119,119,104,104,55,55,124,124,49,49,91,91,31,31,109,109,64,64,50,50,90,90,60,60,76,76,36,36,74,74,17,17,44,44,5,5,26,26,8,8,73,73,100,100,98,98,98,98,9,9,111,111,101,101,93,93,123,123,84,84,116,116,124,124,88,88,87,87,52,52,46,46,125,125,2,2,106,106,73,73,49,49,7,7,98,98,118,118,44,44,3,3,66,66,37,37,98,98,7,7,64,64,61,61,41,41,91,91,31,31,69,69,100,100,63,63,35,35,108,108,36,36,98,98,116,116,42,42,55,55,9,9,0,0,89,89,46,46,64,64,60,60,67,67,45,45,2,2,70,70,64,64,14,14,108,108,74,74,22,22,96,96,30,30,4,4,15,15,17,17,85,85,16,16,126,126,60,60,69,69,58,58,80,80,2,2,48,48,81,81,23,23,123,123,84,84,51,51,66,66,13,13,28,28,94,94,38,38,37,37,11,11,14,14,60,60,44,44,66,66,95,95,39,39,70,70,48,48,8,8,106,106,116,116,74,74,5,5,71,71,72,72,109,109,104,104,76,76,68,68,5,5,29,29,1,1,55,55,35,35,16,16,46,46,12,12,87,87,45,45,49,49,65,65,89,89,10,10,77,77,83,83,93,93,31,31,69,69,109,109,12,12,30,30,56,56,84,84,98,98,64,64,75,75,76,76,78,78,81,81,2,2,117,117,16,16,53,53,80,80,38,38,5,5,78,78,12,12,76,76,122,122,18,18,80,80,12,12,60,60,18,18,5,5,30,30,86,86,17,17,55,55,83,83,20,20,15,15,124,124,83,83,87,87,84,84,68,68,47,47,85,85,107,107,9,9,24,24,62,62,72,72,64,64,61,61,47,47,58,58,42,42,4,4,96,96,6,6,79,79,10,10,121,121,121,121,39,39,71,71,20,20,127,127,46,46,43,43,84,84,114,114,44,44,67,67,42,42,16,16,109,109,22,22,76,76,33,33,3,3,85,85,123,123,20,20,93,93,93,93,41,41,68,68,46,46,41,41,99,99,81,81,116,116,1,1,33,33,119,119,64,64,62,62,89,89,61,61,48,48,10,10,115,115,75,75,15,15,68,68,32,32,42,42,46,46,117,117,8,8,5,5,124,124,116,116,31,31,97,97,57,57,65,65,20,20,15,15,92,92,70,70,73,73,22,22,33,33,121,121,54,54,8,8,104,104,46,46,121,121,62,62,20,20,72,72,69,69,2,2,15,15,22,22,45,45,94,94,110,110,57,57,127,127,8,8,27,27,9,9,80,80,22,22,68,68,106,106,120,120,103,103,63,63,15,15,48,48,70,70,102,102,123,123,17,17,41,41,53,53,28,28,30,30,7,7,71,71,74,74,108,108,80,80,124,124,111,111,5,5,6,6,100,100,27,27,76,76,120,120,78,78,20,20,31,31,33,33,107,107,87,87,126,126,28,28,112,112,71,71,30,30,14,14,46,46,82,82,75,75,13,13,10,10,41,41,9,9,0,0,79,79,114,114,16,16,17,17,2,2,63,63,30,30,13,13,47,47,20,20,13,13,0,0,67,67,35,35,40,40,105,105,62,62,30,30,17,17,7,7,12,12,8,8,99,99,61,61,28,28,82,82,72,72,95,95,21,21,72,72,35,35,0,0,21,21,7,7,51,51,3,3,73,73,11,11,7,7,40,40,42,42,119,119,84,84,86,86,38,38,125,125,52,52,125,125,99,99,51,51,80,80,83,83,120,120,78,78,124,124,12,12,89,89,113,113,50,50,30,30,16,16,50,50,52,52,111,111,115,115,33,33,75,75,31,31,88,88,58,58,121,121,16,16,42,42,43,43,0,0,8,8,34,34,45,45,125,125,44,44,37,37,15,15,124,124,94,94,17,17,78,78,104,104,106,106,125,125,44,44,17,17,60,60,47,47,117,117,76,76,7,7,42,42,115,115,92,92,35,35,17,17,77,77,46,46,16,16,122,122,94,94,108,108,60,60,97,97,24,24,90,90,112,112,71,71,29,29,81,81,71,71,65,65,2,2,118,118,36,36,104,104,63,63,36,36,90,90,116,116,44,44,21,21,81,81,49,49,61,61,116,116,116,116,65,65,71,71,42,42,107,107,30,30,118,118,45,45,124,124,79,79,44,44,60,60,50,50,106,106,16,16,82,82,83,83,44,44,4,4,27,27,81,81,115,115,86,86,124,124,21,21,45,45,31,31,54,54,19,19,105,105,52,52,119,119,102,102,93,93,26,26,126,126,100,100,46,46,32,32,107,107,22,22,101,101,8,8,98,98,9,9,63,63,42,42,65,65,117,117,24,24,87,87,123,123,53,53,64,64,0,0,37,37,98,98,97,97,117,117,115,115,53,53,47,47,44,44,51,51,14,14,68,68,77,77,86,86,74,74,12,12,71,71,60,60,63,63,104,104,84,84,44,44,4,4,118,118,21,21,70,70,45,45,54,54,108,108,53,53,21,21,56,56,75,75,21,21,100,100,67,67,39,39,65,65,36,36,65,65,91,91,65,65,100,100,36,36,21,21,84,84,84,84,25,25,119,119,23,23,7,7,113,113,16,16,66,66,46,46,103,103,74,74,3,3,118,118,38,38,94,94,0,0,41,41,60,60,98,98,3,3,35,35,112,112,67,67,22,22,43,43,81,81,0,0,12,12,44,44,57,57,100,100,16,16,45,45,56,56,88,88,78,78,125,125,111,111,116,116,83,83,13,13,77,77,47,47,49,49,31,31,37,37,21,21,75,75,68,68,120,120,0,0,13,13,2,2,25,25,96,96,4,4,76,76,64,64,8,8,8,8,43,43,2,2,103,103,86,86,74,74,58,58,8,8,86,86,39,39,100,100,42,42,5,5,9,9,73,73,63,63,29,29,14,14,109,109,90,90,80,80,75,75,15,15,95,95,8,8,29,29,122,122,43,43,94,94,62,62,35,35,73,73,75,75,109,109,86,86,82,82,89,89,92,92,120,120,80,80,49,49,126,126,39,39,32,32,3,3,7,7,121,121,14,14,27,27,38,38,40,40,47,47,100,100,60,60,1,1,100,100,71,71,66,66,85,85,127,127,110,110,122,122,110,110,109,109,72,72,6,6,112,112,47,47,53,53,115,115,6,6,71,71,125,125,123,123,76,76,4,4,106,106,113,113,40,40,66,66,118,118,11,11,106,106,90,90,90,90,102,102,60,60,56,56,98,98,95,95,69,69,30,30,17,17,116,116,61,61,127,127,88,88,51,51,18,18,69,69,63,63,2,2,71,71,84,84,10,10,59,59,89,89,58,58,25,25,53,53,81,81,6,6,85,85,48,48,108,108,70,70,22,22,51,51,113,113,12,12,40,40,29,29,14,14,17,17,124,124,109,109,124,124,85,85,28,28,65,65,12,12,77,77,112,112,44,44,107,107,25,25,37,37,30,30,51,51,101,101,87,87,42,42,117,117,70,70,42,42,111,111,13,13,19,19,124,124,0,0,57,57,76,76,33,33,59,59,117,117,26,26,8,8,22,22,36,36,54,54,76,76,121,121,43,43,72,72,9,9,62,62,56,56,25,25,37,37,98,98,118,118,65,65,99,99,91,91,5,5,22,22,57,57,111,111,45,45,104,104,57,57,44,44,70,70,97,97,45,45,106,106,32,32,112,112,121,121,73,73,92,92,37,37,2,2,95,95,68,68,14,14,33,33,117,117,48,48,64,64,105,105,90,90,88,88,56,56,1,1,111,111,38,38,97,97,67,67,35,35,82,82,19,19,72,72,41,41,104,104,68,68,43,43,36,36,26,26,107,107,87,87,23,23,14,14,36,36,63,63,98,98,79,79,66,66,65,65,95,95,89,89,121,121,124,124,47,47,5,5,117,117,59,59,33,33,12,12,80,80,87,87,3,3,66,66,97,97,64,64,13,13,46,46,75,75,120,120,35,35,2,2,9,9,10,10,8,8,72,72,81,81,58,58,22,22,68,68,6,6,5,5,44,44,39,39,66,66,118,118,100,100,30,30,79,79,25,25,127,127,64,64,70,70,123,123,87,87,49,49,90,90,50,50,81,81,72,72,101,101,116,116,73,73,11,11,58,58,91,91,36,36,78,78,9,9,9,9,94,94,88,88,35,35,109,109,93,93,103,103,70,70,52,52,2,2,123,123,4,4,28,28,109,109,86,86,32,32,112,112,36,36,83,83,98,98,27,27,108,108,100,100,53,53,43,43,100,100,26,26,42,42,58,58,70,70,96,96,51,51,65,65,4,4,82,82,125,125,8,8,75,75,60,60,14,14,29,29,101,101,17,17,52,52,28,28,82,82,93,93,118,118,117,117,37,37,2,2,109,109,93,93,57,57,60,60,80,80,22,22,98,98,55,55,32,32,36,36,45,45,68,68,74,74,112,112,26,26,113,113,57,57,51,51,13,13,17,17,76,76,102,102,96,96,24,24,127,127,127,127,28,28,16,16,9,9,42,42,46,46,7,7,18,18,94,94,44,44,37,37,80,80,20,20,14,14,110,110,83,83,36,36,6,6,94,94,88,88,115,115,20,20,9,9,92,92,49,49,74,74,77,77,28,28,2,2,125,125,64,64,68,68,34,34,100,100,50,50,89,89,10,10,27,27,41,41,65,65,8,8,13,13,18,18,107,107,107,107,104,104,53,53,59,59,40,40,26,26,101,101,9,9,90,90,48,48,46,46,106,106,109,109,57,57,40,40,75,75,47,47,16,16,83,83,87,87,110,110,120,120,60,60,90,90,90,90,2,2,46,46,118,118,17,17,71,71,37,37,29,29,77,77,124,124,31,31,51,51,0,0,66,66,64,64,52,52,32,32,82,82,91,91,93,93,123,123,54,54,36,36,14,14,126,126,114,114,33,33,1,1,22,22,100,100,24,24,16,16,1,1,25,25,63,63,9,9,14,14,106,106,126,126,107,107,17,17,35,35,6,6,91,91,80,80,20,20,12,12,126,126,81,81,76,76,45,45,98,98,35,35,119,119,10,10,70,70,115,115,41,41,47,47,83,83,69,69,100,100,51,51,6,6,6,6,5,5,100,100,104,104,68,68,40,40,30,30,96,96,108,108,113,113,32,32,38,38,35,35,7,7,36,36,104,104,26,26,99,99,108,108,43,43,11,11,5,5,66,66,34,34,6,6,88,88,116,116,84,84,90,90,44,44,81,81,53,53,85,85,96,96,98,98,37,37,44,44,73,73,23,23,125,125,35,35,112,112,58,58,54,54,76,76,34,34,80,80,4,4,34,34,48,48,22,22,77,77,32,32,9,9,70,70,24,24,65,65,11,11,61,61,26,26,106,106,86,86,4,4,89,89,25,25,36,36,70,70,96,96,37,37,4,4,111,111,75,75,15,15,26,26,20,20,114,114,85,85,101,101,93,93,20,20,124,124,6,6,27,27,102,102,59,59,45,45,52,52,6,6,113,113,9,9,12,12,123,123,110,110,72,72,109,109,2,2,126,126,42,42,98,98,127,127,36,36,96,96,26,26,81,81,120,120,66,66,109,109,20,20,43,43,45,45,18,18,107,107,93,93,64,64,79,79,52,52,9,9,31,31,73,73,9,9,104,104,65,65,52,52,115,115,37,37,83,83,115,115,105,105,41,41,55,55,59,59,5,5,46,46,24,24,60,60,44,44,5,5,8,8,115,115,4,4,39,39,91,91,118,118,95,95,74,74,100,100,87,87,104,104,112,112,100,100,32,32,43,43,1,1,124,124,41,41,25,25,34,34,121,121,78,78,7,7,42,42,121,121,35,35,3,3,54,54,26,26,87,87,88,88,84,84,89,89,48,48,47,47,21,21,42,42,44,44,79,79,106,106,76,76,43,43,55,55,65,65,13,13,92,92,77,77,121,121,54,54,8,8,109,109,100,100,2,2,20,20,5,5,39,39,45,45,68,68,113,113,109,109,55,55,107,107,30,30,80,80,52,52,32,32,52,52,65,65,45,45,28,28,70,70,95,95,9,9,17,17,89,89,47,47,6,6,26,26,0,0,21,21,87,87,87,87,92,92,4,4,73,73,9,9,16,16,46,46,34,34,42,42,91,91,68,68,68,68,53,53,37,37,48,48,122,122,63,63,67,67,92,92,10,10,30,30,97,97,23,23,89,89,0,0,36,36,30,30,105,105,37,37,47,47,6,6,36,36,10,10,94,94,110,110,86,86,28,28,59,59,87,87,13,13,101,101,123,123,42,42,110,110,29,29,85,85,26,26,45,45,20,20,79,79,67,67,12,12,10,10,32,32,123,123,4,4,48,48,81,81,120,120,61,61,10,10,51,51,104,104,17,17,121,121,64,64,81,81,51,51,2,2,30,30,49,49,61,61,110,110,46,46,3,3,9,9,46,46,45,45,55,55,58,58,12,12,43,43,4,4,19,19,39,39,89,89,19,19,124,124,47,47,31,31,2,2,18,18,86,86,87,87,69,69,9,9,91,91,124,124,104,104,68,68,37,37,9,9,73,73,121,121,96,96,3,3,64,64,37,37,72,72,97,97,17,17,86,86,85,85,79,79,88,88,33,33,58,58,22,22,0,0,3,3,72,72,22,22,73,73,28,28,19,19,80,80,8,8,19,19,77,77,5,5,82,82,19,19,67,67,108,108,0,0,10,10,65,65,8,8,17,17,86,86,127,127,0,0,93,93,14,14,58,58,23,23,75,75,36,36,19,19,59,59,97,97,99,99,53,53,56,56,68,68,8,8,34,34,85,85,6,6,1,1,79,79,105,105,111,111,99,99,34,34,43,43,95,95,38,38,38,38,124,124,31,31,15,15,68,68,112,112,56,56,35,35,15,15,122,122,54,54,101,101,7,7,51,51,24,24,16,16,113,113,105,105,92,92,111,111,107,107,67,67,40,40,13,13,52,52,0,0,8,8,82,82,16,16,8,8,0,0,15,15,80,80,63,63,2,2,60,60,19,19,81,81,101,101,73,73,17,17,43,43,82,82,89,89,78,78,86,86,32,32,90,90,103,103,73,73,66,66,31,31,80,80,72,72,34,34,3,3,59,59,24,24,2,2,105,105,82,82,42,42,59,59,68,68,41,41,26,26,99,99,96,96,91,91,77,77,65,65,105,105,21,21,83,83,29,29,35,35,122,122,61,61,10,10,64,64,92,92,90,90,24,24,98,98,45,45,12,12,99,99,103,103,103,103,35,35,97,97,117,117,68,68,11,11,88,88,16,16,109,109,117,117,0,0,78,78,121,121,14,14,64,64,89,89,93,93,106,106,84,84,24,24,24,24,104,104,60,60,120,120,73,73,5,5,59,59,41,41,26,26,45,45,80,80,99,99,103,103,18,18,111,111,76,76,72,72,45,45,6,6,18,18,78,78,70,70,52,52,32,32,93,93,0,0,77,77,97,97,70,70,59,59,90,90,99,99,22,22,107,107,64,64,0,0,70,70,5,5,7,7,62,62,6,6,61,61,94,94,83,83,60,60,67,67,22,22,67,67,76,76,61,61,51,51,117,117,51,51,67,67,64,64,81,81,112,112,123,123,113,113,4,4,11,11,18,18,36,36,91,91,42,42,126,126,79,79,70,70,13,13,42,42,35,35,6,6,54,54,20,20,104,104,6,6,95,95,104,104,60,60,0,0,54,54,40,40,118,118,22,22,99,99,85,85,28,28,33,33,105,105,84,84,25,25,64,64,77,77,64,64,92,92,125,125,46,46,63,63,99,99,0,0,38,38,73,73,68,68,125,125,121,121,104,104,56,56,44,44,41,41,40,40,79,79,22,22,5,5,31,31,31,31,91,91,52,52,5,5,20,20,59,59,127,127,93,93,126,126,2,2,30,30,26,26,81,81,14,14,75,75,63,63,9,9,33,33,51,51,55,55,122,122,77,77,108,108,36,36,100,100,119,119,37,37,1,1,58,58,8,8,84,84,54,54,121,121,58,58,9,9,36,36,45,45,15,15,78,78,59,59,72,72,78,78,105,105,13,13,109,109,36,36,67,67,98,98,98,98,34,34,82,82,114,114,62,62,95,95,2,2,19,19,80,80,76,76,69,69,104,104,65,65,33,33,122,122,109,109,42,42,84,84,75,75,121,121,121,121,103,103,66,66,69,69,26,26,124,124,30,30,100,100,26,26,106,106,55,55,99,99,112,112,110,110,16,16,41,41,123,123,17,17,110,110,12,12,102,102,75,75,4,4,124,124,122,122,25,25,78,78,53,53,58,58,50,50,118,118,40,40,115,115,121,121,79,79,7,7,17,17,55,55,28,28,115,115,86,86,98,98,4,4,34,34,71,71,41,41,84,84,36,36,38,38,118,118,70,70,71,71,117,117,44,44,88,88,30,30,18,18,86,86,97,97,54,54,59,59,21,21,90,90,34,34,103,103,29,29,2,2,43,43,125,125,17,17,33,33,67,67,110,110,115,115,54,54,107,107,96,96,17,17,111,111,9,9,10,10,124,124,36,36,96,96,64,64,84,84,33,33,86,86,90,90,39,39,42,42,50,50,83,83,23,23,108,108,124,124,32,32,72,72,50,50,108,108,10,10,33,33,25,25,85,85,13,13,92,92,6,6,12,12,28,28,23,23,97,97,52,52,118,118,59,59,50,50,68,68,56,56,117,117,20,20,119,119,85,85,121,121,50,50,52,52,60,60,38,38,12,12,35,35,115,115,4,4,96,96,0,0,33,33,31,31,85,85,11,11,20,20,66,66,84,84,75,75,79,79,60,60,76,76,118,118,34,34,115,115,15,15,59,59,73,73,23,23,29,29,7,7,88,88,64,64,106,106,76,76,121,121,22,22,3,3,61,61,24,24,100,100,104,104,26,26,68,68,52,52,15,15,42,42,105,105,111,111,47,47,84,84,55,55,3,3,72,72,26,26,47,47,65,65,7,7,95,95,39,39,71,71,98,98,82,82,103,103,122,122,52,52,113,113,43,43,111,111,92,92,96,96,113,113,119,119,64,64,33,33,95,95,77,77,4,4,1,1,89,89,25,25,126,126,113,113,119,119,42,42,104,104,121,121,58,58,47,47,60,60,121,121,89,89,112,112,45,45,123,123,25,25,27,27,0,0,53,53,3,3,32,32,14,14,36,36,86,86,68,68,40,40,39,39,105,105,78,78,73,73,2,2,25,25,64,64,90,90,109,109,18,18,109,109,22,22,119,119,34,34,25,25,4,4,22,22,89,89,107,107,79,79,5,5,108,108,44,44,45,45,27,27,78,78,35,35,30,30,79,79,74,74,122,122,113,113,95,95,88,88,21,21,95,95,48,48,3,3,74,74,9,9,0,0,11,11,63,63,7,7,13,13,52,52,82,82,60,60,100,100,113,113,38,38,52,52,90,90,112,112,25,25,35,35,64,64,109,109,35,35,47,47,111,111,119,119,89,89,117,117,91,91,25,25,113,113,117,117,36,36,90,90,12,12,4,4,44,44,32,32,72,72,50,50,28,28,13,13,110,110,3,3,110,110,42,42,33,33,16,16,86,86,6,6,40,40,11,11,33,33,17,17,109,109,41,41,7,7,93,93,117,117,71,71,45,45,93,93,28,28,51,51,115,115,22,22,37,37,64,64,8,8,94,94,75,75,96,96,22,22,91,91,125,125,3,3,90,90,30,30,100,100,101,101,6,6,10,10,62,62,104,104,28,28,78,78,21,21,115,115,68,68,109,109,94,94,25,25,51,51,36,36,80,80,98,98,80,80,34,34,18,18,119,119,115,115,94,94,69,69,48,48,103,103,106,106,17,17,125,125,126,126,112,112,36,36,59,59,111,111,28,28,106,106,58,58,60,60,87,87,86,86,63,63,63,63,66,66,5,5,99,99,3,3,62,62,106,106,33,33,94,94,97,97,94,94,120,120,24,24,30,30,84,84,71,71,40,40,3,3,34,34,61,61,60,60,48,48,69,69,58,58,84,84,97,97,17,17,110,110,89,89,83,83,55,55,98,98,31,31,19,19,35,35,9,9,26,26,21,21,59,59,38,38,124,124,70,70,14,14,109,109,121,121,27,27,59,59,101,101,121,121,9,9,54,54,58,58,85,85,11,11,109,109,44,44,38,38,123,123,72,72,54,54,35,35,28,28,30,30,3,3,68,68,63,63,33,33,86,86,60,60,12,12,77,77,113,113,99,99,84,84,36,36,98,98,114,114,51,51,78,78,32,32,1,1,76,76,41,41,84,84,28,28,33,33,30,30,40,40,51,51,27,27,23,23,84,84,2,2,44,44,104,104,93,93,65,65,125,125,86,86,81,81,69,69,12,12,83,83,90,90,118,118,8,8,107,107,2,2,85,85,85,85,0,0,63,63,52,52,50,50,36,36,115,115,115,115,57,57,20,20,27,27,112,112,1,1,63,63,109,109,71,71,110,110,111,111,43,43,39,39,69,69,3,3,1,1,64,64,51,51,25,25,23,23,124,124,4,4,80,80,109,109,78,78,98,98,17,17,68,68,84,84,114,114,66,66,4,4,21,21,72,72,77,77,51,51,9,9,125,125,26,26,2,2,104,104,11,11,98,98,74,74,107,107,73,73,25,25,50,50,92,92,119,119,105,105,64,64,30,30,68,68,19,19,15,15,1,1,40,40,58,58,42,42,119,119,78,78,21,21,0,0,12,12,113,113,53,53,43,43,90,90,111,111,67,67,87,87,50,50,125,125,43,43,53,53,103,103,41,41,76,76,47,47,77,77,101,101,62,62,33,33,93,93,84,84,44,44,124,124,3,3,50,50,124,124,24,24,67,67,120,120,58,58,47,47,32,32,40,40,3,3,15,15,15,15,29,29,76,76,58,58,87,87,3,3,126,126,55,55,100,100,58,58,31,31,19,19,66,66,40,40,44,44,41,41,80,80,44,44,2,2,14,14,69,69,41,41,5,5,121,121,89,89,60,60,108,108,94,94,57,57,125,125,53,53,28,28,110,110,38,38,100,100,31,31,97,97,80,80,110,110,38,38,78,78,92,92,49,49,121,121,124,124,69,69,101,101,75,75,85,85,18,18,99,99,126,126,80,80,94,94,61,61,82,82,60,60,37,37,44,44,101,101,20,20,109,109,49,49,79,79,55,55,103,103,95,95,80,80,18,18,8,8,76,76,50,50,43,43,68,68,11,11,88,88,112,112,73,73,104,104,123,123,101,101,4,4,13,13,121,121,66,66,111,111,59,59,73,73,67,67,125,125,25,25,37,37,2,2,119,119,54,54,56,56,2,2,34,34,31,31,103,103,40,40,75,75,121,121,119,119,96,96,87,87,113,113,2,2,30,30,41,41,20,20,97,97,34,34,73,73,105,105,95,95,26,26,68,68,25,25,37,37,38,38,17,17,6,6,1,1,43,43,29,29,23,23,26,26,12,12,16,16,91,91,39,39,118,118,26,26,102,102,51,51,69,69,25,25,17,17,65,65,82,82,115,115,52,52,109,109,52,52,72,72,56,56,97,97,96,96,31,31,109,109,68,68,45,45,108,108,113,113,46,46,56,56,90,90,34,34,117,117,82,82,102,102,43,43,32,32,98,98,109,109,108,108,83,83,24,24,1,1,84,84,117,117,40,40,10,10,34,34,78,78,35,35,91,91,87,87,113,113,8,8,51,51,24,24,7,7,66,66,68,68,62,62,31,31,76,76,105,105,87,87,56,56,20,20,14,14,7,7,29,29,94,94,7,7,19,19,118,118,115,115,74,74,96,96,20,20,55,55,1,1,49,49,77,77,43,43,28,28,28,28,18,18,87,87,111,111,101,101,33,33,2,2,38,38,37,37,112,112,68,68,116,116,57,57,57,57,34,34,68,68,36,36,24,24,21,21,13,13,53,53,55,55,81,81,10,10,78,78,15,15,41,41,30,30,8,8,72,72,122,122,50,50,3,3,53,53,30,30,72,72,45,45,68,68,77,77,7,7,22,22,30,30,36,36,61,61,63,63,61,61,6,6,33,33,104,104,20,20,6,6,123,123,11,11,75,75,21,21,117,117,112,112,17,17,38,38,98,98,119,119,86,86,38,38,120,120,114,114,39,39,22,22,0,0,118,118,53,53,20,20,82,82,42,42,55,55,48,48,125,125,1,1,58,58,38,38,21,21,31,31,21,21,5,5,50,50,97,97,88,88,125,125,7,7,91,91,75,75,106,106,55,55,52,52,24,24,1,1,108,108,88,88,50,50,15,15,96,96,114,114,81,81,23,23,92,92,8,8,72,72,37,37,96,96,46,46,18,18,120,120,68,68,115,115,120,120,80,80,98,98,14,14,50,50,48,48,80,80,108,108,15,15,47,47,107,107,54,54,37,37,5,5,119,119,31,31,105,105,16,16,91,91,36,36,75,75,94,94,99,99,117,117,9,9,19,19,37,37,16,16,123,123,113,113,35,35,108,108,125,125,31,31,14,14,85,85,16,16,65,65,85,85,74,74,69,69,39,39,39,39,3,3,15,15,118,118,82,82,29,29,40,40,38,38,0,0,41,41,118,118,22,22,11,11,67,67,108,108,103,103,0,0,110,110,16,16,43,43,93,93,51,51,80,80,22,22,20,20,47,47,32,32,97,97,96,96,1,1,16,16,2,2,41,41,60,60,35,35,72,72,24,24,85,85,24,24,104,104,55,55,64,64,112,112,31,31,98,98,124,124,72,72,62,62,18,18,21,21,19,19,38,38,80,80,15,15,65,65,84,84,97,97,42,42,85,85,43,43,71,71,68,68,11,11,26,26,118,118,40,40,73,73,113,113,102,102,29,29,25,25,79,79,27,27,11,11,28,28,54,54,93,93,89,89,101,101,20,20,98,98,86,86,6,6,52,52,10,10,107,107,87,87,31,31,24,24,117,117,72,72,87,87,57,57,21,21,35,35,87,87,27,27,46,46,49,49,8,8,104,104,82,82,110,110,100,100,107,107,7,7,20,20,89,89,60,60,115,115,86,86,94,94,10,10,73,73,63,63,105,105,45,45,57,57,88,88,42,42,11,11,84,84,81,81,83,83,116,116,113,113,120,120,102,102,5,5,26,26,95,95,71,71,125,125,76,76,19,19,3,3,58,58,12,12,111,111,121,121,99,99,93,93,10,10,11,11,95,95,108,108,112,112,75,75,105,105,70,70,23,23,78,78,127,127,51,51,51,51,56,56,40,40,77,77,57,57,89,89,117,117,24,24,48,48,58,58,85,85,95,95,127,127,119,119,16,16,127,127,88,88,79,79,64,64,88,88,32,32,21,21,49,49,98,98,32,32,64,64,81,81,80,80,39,39,88,88,63,63,51,51,7,7,39,39,2,2,125,125,0,0,37,37,60,60,112,112,33,33,114,114,119,119,102,102,47,47,58,58,46,46,62,62,32,32,3,3,65,65,76,76,4,4,42,42,113,113,16,16,65,65,80,80,36,36,121,121,43,43,33,33,104,104,33,33,11,11,107,107,10,10,17,17,40,40,37,37,65,65,111,111,106,106,20,20,72,72,0,0,17,17,42,42,66,66,81,81,16,16,119,119,4,4,93,93,79,79,74,74,20,20,32,32,65,65,50,50,126,126,94,94,67,67,110,110,79,79,66,66,20,20,86,86,94,94,52,52,125,125,0,0,6,6,110,110,27,27,112,112,80,80,12,12,67,67,55,55,75,75,31,31,88,88,29,29,68,68,64,64,101,101,39,39,18,18,79,79,104,104,3,3,21,21,9,9,51,51,114,114,106,106,96,96,54,54,51,51,94,94,62,62,1,1,16,16,60,60,88,88,15,15,4,4,35,35,105,105,127,127,26,26,2,2,58,58,59,59,20,20,1,1,2,2,68,68,116,116,84,84,32,32,93,93,109,109,28,28,37,37,50,50,5,5,80,80,67,67,0,0,0,0,15,15,96,96,19,19,122,122,106,106,106,106,124,124,69,69,106,106,30,30,104,104,28,28,62,62,47,47,105,105,2,2,64,64,119,119,42,42,16,16,107,107,86,86,16,16,51,51,108,108,70,70,18,18,78,78,123,123,9,9,92,92,106,106,103,103,13,13,92,92,117,117,0,0,22,22,65,65,59,59,35,35,7,7,40,40,36,36,9,9,25,25,2,2,114,114,113,113,0,0,99,99,88,88,92,92,59,59,38,38,73,73,97,97,27,27,13,13,25,25,57,57,105,105,78,78,22,22,37,37,66,66,3,3,51,51,92,92,55,55,67,67,65,65,24,24,52,52,29,29,76,76,28,28,60,60,71,71,57,57,69,69,4,4,31,31,56,56,8,8,71,71,86,86,107,107,2,2,49,49,8,8,30,30,23,23,122,122,6,6,18,18,91,91,64,64,65,65,93,93,53,53,56,56,40,40,116,116,88,88,45,45,95,95,115,115,106,106,115,115,16,16,40,40,32,32,45,45,55,55,74,74,11,11,98,98,14,14,28,28,120,120,57,57,78,78,34,34,124,124,113,113,82,82,33,33,50,50,38,38,52,52,88,88,88,88,10,10,21,21,115,115,2,2,31,31,104,104,13,13,4,4,118,118,121,121,45,45,70,70,108,108,98,98,101,101,81,81,32,32,61,61,75,75,29,29,82,82,22,22,121,121,32,32,70,70,127,127,0,0,60,60,108,108,50,50,9,9,78,78,109,109,66,66,78,78,114,114,2,2,71,71,4,4,20,20,113,113,81,81,26,26,59,59,55,55,44,44,125,125,37,37,73,73,34,34,98,98,62,62,45,45,46,46,14,14,79,79,38,38,79,79,23,23,79,79,47,47,71,71,119,119,36,36,83,83,73,73,77,77,71,71,69,69,98,98,90,90,59,59,76,76,7,7,3,3,64,64,74,74,94,94,85,85,87,87,51,51,96,96,111,111,99,99,118,118,11,11,33,33,44,44,2,2,94,94,126,126,16,16,34,34,92,92,17,17,51,51,45,45,2,2,105,105,113,113,1,1,3,3,28,28,91,91,5,5,76,76,52,52,25,25,102,102,96,96,102,102,37,37,31,31,85,85,6,6,34,34,102,102,74,74,102,102,77,77,108,108,104,104,103,103,103,103,44,44,80,80,31,31,80,80,29,29,127,127,12,12,47,47,90,90,15,15,110,110,2,2,73,73,120,120,78,78,5,5,25,25,34,34,26,26,56,56,50,50,66,66,32,32,74,74,29,29,32,32,30,30,121,121,11,11,38,38,122,122,114,114,33,33,19,19,78,78,44,44,123,123,50,50,15,15,41,41,10,10,60,60,114,114,19,19,87,87,32,32,105,105,85,85,98,98,106,106,0,0,111,111,10,10,14,14,36,36,33,33,90,90,1,1,119,119,121,121,6,6,48,48,18,18,48,48,23,23,6,6,69,69,38,38,27,27,57,57,4,4,49,49,108,108,121,121,73,73,81,81,71,71,113,113,47,47,8,8,65,65,22,22,125,125,121,121,119,119,26,26,56,56,80,80,112,112,53,53,120,120,125,125,53,53,40,40,115,115,93,93,44,44,76,76,93,93,25,25,59,59,22,22,17,17,37,37,116,116,63,63,64,64,120,120,92,92,124,124,92,92,5,5,27,27,110,110,19,19,28,28,95,95,34,34,73,73,51,51,116,116,6,6,120,120,112,112,19,19,24,24,58,58,22,22,68,68,75,75,96,96,100,100,82,82,121,121,89,89,53,53,127,127,112,112,68,68,61,61,36,36,52,52,89,89,8,8,123,123,3,3,110,110,100,100,43,43,9,9,16,16,90,90,23,23,73,73,43,43,65,65,58,58,74,74,120,120,2,2,73,73,8,8,73,73,9,9,6,6,17,17,62,62,0,0,24,24,98,98,45,45,65,65,123,123,95,95,54,54,13,13,115,115,5,5,15,15,14,14,49,49,75,75,77,77,53,53,103,103,123,123,21,21,15,15,110,110,22,22,89,89,38,38,17,17,94,94,125,125,79,79,19,19,57,57,119,119,89,89,21,21,0,0,116,116,82,82,14,14,121,121,70,70,4,4,1,1,67,67,65,65,84,84,36,36,57,57,29,29,0,0,41,41,70,70,105,105,61,61,42,42,73,73,58,58,28,28,113,113,40,40,21,21,86,86,16,16,13,13,57,57,96,96,97,97,7,7,20,20,10,10,95,95,27,27,96,96,88,88,20,20,52,52,50,50,88,88,35,35,61,61,4,4,92,92,78,78,40,40,62,62,5,5,31,31,53,53,122,122,45,45,60,60,36,36,113,113,92,92,42,42,110,110,114,114,35,35,114,114,57,57,8,8,42,42,33,33,93,93,64,64,6,6,25,25,28,28,69,69,56,56,52,52,31,31,98,98,1,1,64,64,29,29,4,4,106,106,38,38,98,98,102,102,67,67,20,20,39,39,122,122,73,73,31,31,8,8,86,86,114,114,73,73,109,109,1,1,112,112,5,5,56,56,56,56,3,3,18,18,79,79,7,7,91,91,113,113,105,105,101,101,34,34,119,119,35,35,82,82,28,28,96,96,10,10,66,66,72,72,14,14,17,17,12,12,27,27,107,107,85,85,36,36,79,79,51,51,88,88,64,64,80,80,99,99,0,0,9,9,124,124,19,19,0,0,40,40,17,17,97,97,43,43,118,118,100,100,18,18,24,24,110,110,79,79,66,66,39,39,14,14,85,85,118,118,96,96,29,29,2,2,21,21,23,23,44,44,114,114,51,51,55,55,42,42,44,44,17,17,14,14,31,31,29,29,0,0,99,99,104,104,9,9,118,118,56,56,49,49,46,46,75,75,81,81,86,86,30,30,38,38,16,16,97,97,23,23,51,51,70,70,98,98,91,91,124,124,108,108,83,83,38,38,92,92,34,34,48,48,26,26,67,67,62,62,96,96,16,16,79,79,116,116,37,37,104,104,10,10,32,32,90,90,48,48,30,30,8,8,116,116,59,59,53,53,127,127,11,11,34,34,87,87,122,122,60,60,11,11,23,23,106,106,64,64,106,106,31,31,4,4,100,100,118,118,67,67,120,120,43,43,87,87,58,58,46,46,77,77,85,85,83,83,9,9,66,66,22,22,56,56,4,4,59,59,73,73,8,8,76,76,77,77,30,30,20,20,93,93,20,20,121,121,106,106,39,39,119,119,98,98,9,9,67,67,60,60,93,93,62,62,18,18,9,9,118,118,91,91,107,107,83,83,121,121,29,29,34,34,5,5,18,18,75,75,104,104,30,30,57,57,64,64,73,73,95,95,55,55,10,10,16,16,17,17,46,46,11,11,44,44,101,101,34,34,79,79,16,16,23,23,41,41,96,96,107,107,69,69,8,8,12,12,44,44,100,100,31,31,52,52,24,24,65,65,35,35,40,40,97,97,19,19,74,74,53,53,75,75,93,93,99,99,74,74,9,9,27,27,9,9,13,13,17,17,11,11,115,115,10,10,72,72,3,3,105,105,65,65,74,74,25,25,6,6,62,62,4,4,16,16,82,82,50,50,99,99,73,73,107,107,76,76,52,52,116,116,43,43,16,16,74,74,2,2,106,106,66,66,116,116,41,41,89,89,37,37,19,19,91,91,87,87,103,103,19,19,99,99,48,48,87,87,27,27,77,77,15,15,5,5,50,50,39,39,77,77,71,71,127,127,65,65,104,104,71,71,28,28,2,2,21,21,68,68,101,101,66,66,80,80,43,43,94,94,113,113,37,37,48,48,42,42,89,89,103,103,107,107,60,60,70,70,40,40,21,21,115,115,15,15,127,127,55,55,56,56,124,124,87,87,18,18,31,31,2,2,117,117,26,26,14,14,43,43,52,52,111,111,32,32,61,61,20,20,80,80,27,27,104,104,119,119,25,25,24,24,67,67,15,15,75,75,48,48,106,106,79,79,121,121,9,9,16,16,38,38,1,1,15,15,119,119,117,117,22,22,1,1,41,41,40,40,50,50,63,63,85,85,124,124,24,24,32,32,109,109,116,116,116,116,24,24,82,82,96,96,32,32,66,66,75,75,34,34,68,68,65,65,21,21,18,18,102,102,17,17,15,15,6,6,22,22,79,79,122,122,5,5,9,9,58,58,82,82,12,12,120,120,33,33,90,90,78,78,85,85,121,121,122,122,22,22,79,79,33,33,83,83,3,3,10,10,61,61,12,12,73,73,116,116,45,45,60,60,85,85,70,70,37,37,5,5,72,72,6,6,83,83,35,35,20,20,65,65,13,13,82,82,36,36,22,22,37,37,19,19,78,78,92,92,45,45,89,89,23,23,68,68,56,56,44,44,12,12,81,81,106,106,73,73,75,75,39,39,9,9,74,74,8,8,34,34,107,107,86,86,104,104,102,102,106,106,81,81,48,48,68,68,21,21,109,109,112,112,124,124,63,63,77,77,79,79,24,24,82,82,4,4,49,49,41,41,102,102,8,8,33,33,88,88,71,71,54,54,64,64,82,82,44,44,45,45,24,24,94,94,30,30,59,59,66,66,116,116,107,107,98,98,98,98,96,96,10,10,125,125,120,120,17,17,46,46,70,70,49,49,20,20,73,73,120,120,10,10,121,121,119,119,32,32,57,57,41,41,85,85,71,71,90,90,112,112,66,66,66,66,68,68,99,99,13,13,71,71,25,25,16,16,34,34,11,11,91,91,2,2,101,101,121,121,89,89,49,49,21,21,0,0,104,104,117,117,74,74,2,2,89,89,77,77,38,38,81,81,10,10,22,22,10,10,29,29,39,39,114,114,65,65,54,54,119,119,123,123,1,1,96,96,73,73,47,47,44,44,119,119,105,105,32,32,74,74,92,92,19,19,36,36,89,89,36,36,118,118,87,87,32,32,102,102,127,127,52,52,88,88,90,90,66,66,36,36,11,11,110,110,116,116,91,91,23,23,10,10,25,25,84,84,28,28,93,93,64,64,95,95,40,40,106,106,25,25,35,35,36,36,62,62,39,39,98,98,34,34,92,92,56,56,100,100,76,76,9,9,7,7,85,85,25,25,55,55,58,58,88,88,88,88,24,24,80,80,57,57,107,107,79,79,17,17,23,23,4,4,8,8,45,45,122,122,27,27,64,64,102,102,107,107,44,44,124,124,64,64,80,80,78,78,72,72,105,105,20,20,14,14,33,33,22,22,56,56,89,89,87,87,44,44,110,110,23,23,7,7,19,19,71,71,51,51,87,87,41,41,98,98,21,21,126,126,18,18,39,39,88,88,11,11,46,46,26,26,67,67,31,31,93,93,74,74,32,32,14,14,100,100,119,119,126,126,116,116,117,117,1,1,116,116,105,105,13,13,85,85,0,0,59,59,43,43,50,50,7,7,19,19,48,48,102,102,15,15,4,4,82,82,37,37,82,82,119,119,17,17,103,103,53,53,25,25,127,127,127,127,5,5,18,18,83,83,26,26,7,7,117,117,11,11,36,36,24,24,72,72,12,12,89,89,82,82,58,58,21,21,40,40,84,84,44,44,55,55,49,49,57,57,122,122,68,68,116,116,43,43,28,28,48,48,41,41,36,36,61,61,57,57,35,35,30,30,19,19,41,41,32,32,97,97,29,29,39,39,1,1,72,72,28,28,109,109,72,72,72,72,111,111,58,58,74,74,89,89,19,19,78,78,22,22,97,97,15,15,120,120,123,123,105,105,73,73,45,45,42,42,72,72,79,79,46,46,64,64,12,12,52,52,112,112,55,55,85,85,115,115,78,78,29,29,8,8,79,79,28,28,53,53,5,5,40,40,6,6,1,1,82,82,39,39,106,106,105,105,98,98,21,21,28,28,36,36,62,62,85,85,110,110,104,104,76,76,29,29,107,107,54,54,89,89,21,21,4,4,73,73,16,16,74,74,18,18,0,0,30,30,74,74,17,17,37,37,11,11,19,19,9,9,6,6,38,38,20,20,8,8,20,20,8,8,47,47,84,84,12,12,35,35,102,102,9,9,69,69,85,85,59,59,1,1,29,29,0,0,5,5,78,78,86,86,78,78,84,84,1,1,71,71,50,50,42,42,70,70,97,97,66,66,120,120,92,92,45,45,113,113,17,17,1,1,118,118,95,95,2,2,57,57,27,27,1,1,52,52,113,113,6,6,91,91,92,92,5,5,1,1,44,44,106,106,16,16,108,108,22,22,51,51,24,24,32,32,63,63,1,1,57,57,70,70,76,76,31,31,10,10,126,126,110,110,41,41,27,27,76,76,33,33,88,88,13,13,49,49,36,36,20,20,109,109,126,126,13,13,14,14,81,81,56,56,20,20,121,121,24,24,58,58,105,105,75,75,76,76,81,81,99,99,111,111,7,7,50,50,38,38,97,97,58,58,83,83,98,98,122,122,2,2,103,103,32,32,37,37,102,102,98,98,98,98,32,32,76,76,95,95,64,64,60,60,101,101,23,23,70,70,19,19,34,34,36,36,120,120,127,127,108,108,30,30,125,125,35,35,116,116,110,110,31,31,2,2,76,76,126,126,50,50,87,87,119,119,103,103,124,124,75,75,51,51,82,82,98,98,126,126,102,102,5,5,82,82,119,119,77,77,83,83,9,9,105,105,8,8,126,126,108,108,63,63,16,16,63,63,41,41,7,7,7,7,16,16,41,41,66,66,104,104,39,39,83,83,97,97,24,24,32,32,50,50,56,56,20,20,19,19,99,99,36,36,57,57,68,68,10,10,65,65,51,51,29,29,37,37,93,93,38,38,9,9,44,44,16,16,32,32,122,122,23,23,63,63,67,67,40,40,61,61,119,119,17,17,112,112,75,75,95,95,14,14,98,98,54,54,32,32,84,84,75,75,37,37,105,105,112,112,41,41,4,4,85,85,33,33,26,26,88,88,35,35,113,113,53,53,98,98,33,33,12,12,100,100,92,92,96,96,67,67,58,58,23,23,89,89,78,78,24,24,12,12,33,33,1,1,33,33,80,80,62,62,57,57,77,77,61,61,106,106,12,12,43,43,92,92,56,56,116,116,10,10,121,121,62,62,62,62,60,60,34,34,5,5,99,99,93,93,50,50,55,55,51,51,37,37,26,26,51,51,70,70,73,73,66,66,5,5,125,125,35,35,70,70,41,41,74,74,34,34,16,16,7,7,35,35,48,48,112,112,56,56,96,96,56,56,100,100,38,38,61,61,2,2,116,116,8,8,79,79,90,90,112,112,81,81,55,55,36,36,31,31,0,0,71,71,93,93,115,115,29,29,72,72,79,79,82,82,73,73,28,28,47,47,49,49,83,83,67,67,46,46,92,92,117,117,17,17,106,106,77,77,17,17,94,94,36,36,77,77,109,109,87,87,48,48,51,51,123,123,60,60,13,13,46,46,121,121,114,114,10,10,23,23,99,99,49,49,106,106,69,69,111,111,106,106,79,79,33,33,121,121,52,52,0,0,116,116,84,84,95,95,14,14,83,83,33,33,71,71,19,19,46,46,41,41,5,5,4,4,84,84,8,8,99,99,73,73,101,101,97,97,10,10,40,40,45,45,79,79,40,40,1,1,101,101,57,57,59,59,25,25,29,29,106,106,12,12,49,49,65,65,20,20,26,26,70,70,17,17,88,88,15,15,87,87,25,25,36,36,126,126,5,5,59,59,73,73,10,10,93,93,16,16,82,82,69,69,20,20,31,31,48,48,36,36,21,21,70,70,50,50,19,19,72,72,70,70,16,16,113,113,22,22,48,48,17,17,38,38,30,30,76,76,7,7,40,40,93,93,120,120,12,12,121,121,103,103,109,109,124,124,23,23,104,104,75,75,46,46,56,56,8,8,105,105,8,8,39,39,86,86,111,111,108,108,96,96,20,20,14,14,74,74,45,45,118,118,123,123,35,35,77,77,80,80,117,117,52,52,84,84,60,60,60,60,120,120,10,10,99,99,78,78,120,120,60,60,61,61,42,42,8,8,14,14,127,127,68,68,22,22,36,36,29,29,9,9,115,115,10,10,37,37,14,14,64,64,35,35,32,32,10,10,20,20,118,118,123,123,124,124,122,122,127,127,39,39,0,0,13,13,80,80,41,41,1,1,56,56,63,63,43,43,8,8,56,56,51,51,116,116,77,77,26,26,74,74,31,31,81,81,38,38,45,45,29,29,61,61,88,88,0,0,102,102,79,79,67,67,91,91,57,57,32,32,40,40,99,99,21,21,44,44,88,88,82,82,60,60,3,3,71,71,34,34,89,89,31,31,38,38,121,121,21,21,64,64,49,49,34,34,26,26,20,20,18,18,112,112,32,32,0,0,71,71,73,73,37,37,119,119,95,95,108,108,37,37,80,80,102,102,13,13,97,97,62,62,53,53,87,87,40,40,5,5,107,107,12,12,119,119,14,14,0,0,86,86,62,62,114,114,87,87,29,29,117,117,36,36,52,52,17,17,51,51,86,86,68,68,31,31,69,69,62,62,72,72,1,1,88,88,103,103,46,46,53,53,121,121,9,9,115,115,112,112,112,112,68,68,36,36,61,61,55,55,20,20,101,101,2,2,117,117,117,117,111,111,3,3,23,23,13,13,125,125,27,27,106,106,64,64,57,57,26,26,105,105,104,104,76,76,73,73,60,60,38,38,116,116,99,99,18,18,56,56,103,103,53,53,35,35,54,54,90,90,61,61,91,91,113,113,101,101,9,9,17,17,75,75,9,9,89,89,44,44,76,76,33,33,74,74,99,99,5,5,49,49,89,89,16,16,58,58,104,104,125,125,59,59,76,76,29,29,113,113,12,12,15,15,113,113,30,30,76,76,51,51,83,83,75,75,61,61,97,97,65,65,49,49,29,29,52,52,69,69,71,71,108,108,127,127,77,77,53,53,81,81,77,77,19,19,124,124,51,51,114,114,115,115,21,21,117,117,70,70,1,1,120,120,62,62,110,110,38,38,105,105,87,87,44,44,117,117,10,10,18,18,33,33,86,86,60,60,73,73,22,22,22,22,29,29,127,127,12,12,63,63,102,102,50,50,124,124,1,1,126,126,3,3,68,68,77,77,17,17,24,24,93,93,32,32,113,113,34,34,116,116,94,94,12,12,126,126,127,127,114,114,20,20,9,9,51,51,96,96,96,96,38,38,109,109,83,83,83,83,99,99,65,65,83,83,31,31,77,77,114,114,1,1,111,111,98,98,83,83,71,71,50,50,86,86,64,64,66,66,5,5,62,62,113,113,110,110,33,33,88,88,79,79,24,24,54,54,120,120,57,57,101,101,120,120,109,109,61,61,92,92,124,124,83,83,86,86,125,125,48,48,84,84,11,11,71,71,37,37,106,106,2,2,50,50,102,102,76,76,18,18,107,107,66,66,96,96,62,62,125,125,77,77,10,10,5,5,105,105,43,43,27,27,21,21,32,32,16,16,89,89,67,67,1,1,80,80,60,60,91,91,23,23,125,125,106,106,90,90,57,57,89,89,95,95,8,8,60,60,84,84,82,82,23,23,82,82,99,99,28,28,121,121,13,13,78,78,26,26,48,48,65,65,22,22,0,0,63,63,103,103,109,109,2,2,55,55,73,73,101,101,69,69,70,70,90,90,110,110,47,47,24,24,61,61,111,111,20,20,108,108,5,5,88,88,14,14,91,91,18,18,17,17,36,36,17,17,73,73,78,78,71,71,114,114,55,55,79,79,108,108,104,104,44,44,29,29,71,71,82,82,74,74,59,59,104,104,65,65,61,61,23,23,109,109,100,100,23,23,120,120,63,63,77,77,106,106,48,48,40,40,63,63,35,35,45,45,116,116,41,41,16,16,8,8,73,73,49,49,104,104,25,25,68,68,68,68,120,120,4,4,81,81,91,91,107,107,52,52,15,15,96,96,41,41,51,51,78,78,54,54,27,27,33,33,68,68,24,24,106,106,37,37,99,99,37,37,103,103,98,98,30,30,9,9,122,122,106,106,9,9,83,83,56,56,92,92,95,95,69,69,122,122,43,43,119,119,70,70,98,98,85,85,14,14,49,49,49,49,95,95,123,123,71,71,8,8,90,90,107,107,103,103,28,28,81,81,18,18,0,0,49,49,61,61,16,16,105,105,98,98,107,107,63,63,49,49,100,100,17,17,57,57,42,42,28,28,58,58,100,100,72,72,6,6,118,118,86,86,5,5,101,101,11,11,11,11,54,54,36,36,89,89,40,40,18,18,43,43,118,118,8,8,56,56,107,107,65,65,74,74,54,54,1,1,21,21,97,97,46,46,77,77,21,21,30,30,36,36,87,87,67,67,32,32,122,122,108,108,118,118,61,61,52,52,86,86,39,39,95,95,4,4,85,85,30,30,121,121,66,66,55,55,10,10,82,82,63,63,78,78,20,20,102,102,16,16,11,11,47,47,74,74,18,18,49,49,71,71,48,48,74,74,28,28,103,103,56,56,50,50,26,26,92,92,41,41,28,28,36,36,50,50,18,18,72,72,112,112,95,95,45,45,44,44,58,58,19,19,67,67,29,29,111,111,75,75,8,8,25,25,45,45,95,95,121,121,91,91,3,3,74,74,118,118,15,15,6,6,111,111,15,15,67,67,98,98,110,110,88,88,22,22,92,92,0,0,83,83,16,16,46,46,66,66,60,60,51,51,1,1,19,19,89,89,29,29,37,37,7,7,70,70,44,44,32,32,78,78,109,109,19,19,45,45,50,50,7,7,94,94,31,31,72,72,16,16,95,95,12,12,106,106,47,47,2,2,76,76,22,22,52,52,65,65,67,67,56,56,16,16,74,74,83,83,117,117,40,40,27,27,105,105,30,30,59,59,12,12,57,57,111,111,24,24,83,83,42,42,17,17,99,99,71,71,116,116,97,97,114,114,80,80,101,101,92,92,2,2,117,117,29,29,27,27,81,81,116,116,112,112,69,69,23,23,28,28,72,72,59,59,8,8,122,122,64,64,29,29,77,77,79,79,10,10,15,15,62,62,3,3,89,89,42,42,45,45,39,39,34,34,46,46,45,45,43,43,120,120,27,27,57,57,26,26,22,22,77,77,88,88,113,113,41,41,0,0,120,120,34,34,126,126,53,53,121,121,61,61,45,45,37,37,43,43,0,0,40,40,60,60,124,124,26,26,89,89,60,60,40,40,25,25,102,102,51,51,118,118,71,71,119,119,24,24,75,75,63,63,76,76,43,43,115,115,77,77,122,122,80,80,24,24,122,122,17,17,81,81,19,19,110,110,19,19,6,6,11,11,37,37,29,29,121,121,24,24,43,43,1,1,122,122,82,82,24,24,96,96,34,34,5,5,123,123,64,64,31,31,61,61,90,90,16,16,82,82,4,4,35,35,53,53,94,94,99,99,57,57,25,25,78,78,101,101,117,117,109,109,54,54,11,11,76,76,24,24,68,68,113,113,79,79,105,105,118,118,67,67,67,67,18,18,21,21,119,119,23,23,111,111,95,95,27,27,112,112,60,60,70,70,103,103,35,35,6,6,64,64,30,30,29,29,83,83,16,16,21,21,93,93,107,107,116,116,81,81,116,116,81,81,126,126,7,7,43,43,62,62,2,2,123,123,17,17,20,20,126,126,22,22,36,36,24,24,98,98,44,44,73,73,127,127,92,92,46,46,60,60,35,35,90,90,103,103,95,95,20,20,78,78,29,29,100,100,16,16,69,69,42,42,61,61,1,1,96,96,69,69,75,75,22,22,126,126,83,83,96,96,32,32,104,104,51,51,51,51,101,101,83,83,113,113,86,86,21,21,64,64,104,104,3,3,44,44,82,82,105,105,8,8,75,75,107,107,34,34,87,87,42,42,102,102,81,81,6,6,72,72,35,35,116,116,99,99,121,121,93,93,83,83,80,80,87,87,2,2,36,36,48,48,17,17,0,0,122,122,101,101,108,108,88,88,6,6,39,39,25,25,19,19,71,71,109,109,16,16,40,40,3,3,118,118,10,10,64,64,117,117,13,13,93,93,64,64,36,36,120,120,102,102,40,40,74,74,64,64,16,16,17,17,127,127,45,45,105,105,127,127,75,75,55,55,5,5,65,65,104,104,125,125,21,21,58,58,114,114,68,68,85,85,121,121,37,37,20,20,25,25,39,39,54,54,84,84,9,9,6,6,80,80,61,61,79,79,68,68,53,53,18,18,102,102,68,68,120,120,0,0,85,85,67,67,71,71,68,68,122,122,7,7,78,78,72,72,6,6,77,77,73,73,45,45,18,18,108,108,110,110,6,6,32,32,60,60,21,21,43,43,70,70,110,110,92,92,2,2,99,99,56,56,64,64,29,29,38,38,71,71,109,109,16,16,38,38,73,73,10,10,126,126,102,102,49,49,87,87,69,69,12,12,69,69,9,9,43,43,33,33,107,107,27,27,113,113,11,11,40,40,40,40,49,49,88,88,73,73,50,50,34,34,7,7,1,1,90,90,24,24,38,38,73,73,57,57,68,68,28,28,32,32,16,16,38,38,52,52,57,57,15,15,104,104,54,54,75,75,28,28,122,122,71,71,80,80,79,79,104,104,67,67,6,6,57,57,110,110,20,20,49,49,77,77,83,83,48,48,25,25,60,60,5,5,93,93,25,25,87,87,89,89,119,119,54,54,76,76,50,50,5,5,43,43,118,118,36,36,69,69,66,66,29,29,126,126,4,4,77,77,94,94,9,9,109,109,16,16,6,6,127,127,13,13,68,68,3,3,76,76,73,73,109,109,53,53,6,6,78,78,33,33,53,53,80,80,36,36,82,82,16,16,115,115,54,54,30,30,75,75,113,113,81,81,28,28,39,39,108,108,21,21,98,98,126,126,97,97,119,119,32,32,80,80,78,78,45,45,18,18,30,30,0,0,118,118,53,53,5,5,50,50,71,71,45,45,100,100,40,40,115,115,127,127,106,106,117,117,118,118,106,106,80,80,125,125,51,51,86,86,99,99,125,125,87,87,69,69,82,82,122,122,88,88,38,38,12,12,54,54,86,86,104,104,72,72,6,6,2,2,80,80,67,67,4,4,46,46,127,127,126,126,73,73,31,31,68,68,112,112,93,93,85,85,20,20,45,45,96,96,96,96,102,102,119,119,84,84,91,91,77,77,16,16,15,15,72,72,85,85,48,48,76,76,34,34,60,60,2,2,56,56,9,9,103,103,70,70,127,127,84,84,62,62,23,23,48,48,31,31,59,59,117,117,62,62,61,61,70,70,105,105,127,127,3,3,103,103,46,46,18,18,89,89,61,61,101,101,91,91,103,103,81,81,21,21,101,101,77,77,72,72,19,19,71,71,108,108,59,59,5,5,33,33,52,52,88,88,73,73,0,0,38,38,18,18,123,123,101,101,43,43,33,33,49,49,49,49,127,127,72,72,108,108,121,121,68,68,73,73,76,76,108,108,16,16,122,122,104,104,59,59,124,124,51,51,34,34,34,34,92,92,101,101,53,53,108,108,4,4,80,80,48,48,23,23,89,89,82,82,53,53,92,92,99,99,103,103,63,63,64,64,103,103,90,90,95,95,22,22,50,50,70,70,66,66,33,33,60,60,16,16,17,17,113,113,56,56,86,86,15,15,12,12,5,5,60,60,10,10,74,74,26,26,24,24,104,104,101,101,112,112,8,8,58,58,125,125,92,92,124,124,68,68,51,51,90,90,43,43,100,100,21,21,95,95,122,122,6,6,33,33,63,63,79,79,6,6,8,8,112,112,47,47,29,29,25,25,0,0,9,9,110,110,76,76,122,122,74,74,109,109,101,101,20,20,125,125,23,23,41,41,127,127,34,34,84,84,118,118,79,79,86,86,59,59,115,115,98,98,33,33,58,58,83,83,34,34,37,37,25,25,106,106,117,117,86,86,112,112,85,85,123,123,78,78,24,24,37,37,121,121,20,20,76,76,86,86,68,68,45,45,39,39,113,113,102,102,120,120,67,67,86,86,112,112,46,46,102,102,21,21,102,102,32,32,123,123,55,55,116,116,80,80,32,32,40,40,127,127,103,103,18,18,111,111,7,7,4,4,15,15,64,64,92,92,67,67,73,73,79,79,2,2,54,54,75,75,27,27,50,50,111,111,9,9,90,90,76,76,13,13,66,66,26,26,43,43,103,103,117,117,26,26,32,32,97,97,42,42,42,42,14,14,111,111,70,70,53,53,20,20,106,106,28,28,20,20,42,42,56,56,102,102,3,3,96,96,102,102,115,115,115,115,27,27,64,64,94,94,93,93,92,92,125,125,4,4,93,93,24,24,85,85,29,29,35,35,81,81,93,93,38,38,82,82,102,102,102,102,34,34,29,29,72,72,119,119,99,99,6,6,76,76,114,114,98,98,7,7,104,104,24,24,13,13,1,1,93,93,33,33,25,25,107,107,123,123,28,28,99,99,1,1,53,53,97,97,121,121,30,30,109,109,11,11,79,79,41,41,105,105,72,72,112,112,23,23,124,124,59,59,18,18,35,35,124,124,111,111,96,96,93,93,45,45,91,91,121,121,22,22,102,102,21,21,102,102,82,82,121,121,94,94,3,3,12,12,33,33,100,100,68,68,21,21,93,93,21,21,31,31,98,98,54,54,33,33,10,10,114,114,104,104,0,0,70,70,91,91,88,88,108,108,72,72,12,12,75,75,2,2,14,14,38,38,122,122,122,122,65,65,64,64,8,8,1,1,24,24,112,112,54,54,83,83,67,67,79,79,79,79,9,9,1,1,18,18,106,106,36,36,9,9,24,24,117,117,49,49,59,59,67,67,66,66,40,40,46,46,72,72,109,109,10,10,126,126,21,21,80,80,85,85,125,125,16,16,24,24,98,98,36,36,67,67,94,94,12,12,74,74,49,49,71,71,61,61,78,78,57,57,18,18,79,79,34,34,30,30,17,17,94,94,40,40,85,85,8,8,7,7,57,57,125,125,51,51,111,111,120,120,27,27,40,40,64,64,66,66,18,18,12,12,79,79,56,56,85,85,39,39,84,84,21,21,12,12,102,102,6,6,90,90,105,105,14,14,20,20,17,17,112,112,61,61,126,126,119,119,124,124,33,33,29,29,17,17,74,74,82,82,33,33,30,30,88,88,49,49,39,39,117,117,3,3,9,9,4,4,28,28,17,17,29,29,99,99,65,65,19,19,82,82,122,122,97,97,36,36,125,125,18,18,118,118,92,92,70,70,36,36,92,92,8,8,71,71,50,50,96,96,121,121,9,9,98,98,102,102,35,35,114,114,40,40,116,116,2,2,8,8,58,58,50,50,68,68,108,108,19,19,25,25,77,77,24,24,80,80,100,100,114,114,64,64,92,92,68,68,71,71,56,56,5,5,50,50,62,62,98,98,5,5,63,63,74,74,119,119,71,71,29,29,35,35,69,69,110,110,56,56,10,10,57,57,106,106,91,91,51,51,27,27,103,103,67,67,48,48,38,38,37,37,24,24,44,44,0,0,80,80,25,25,110,110,31,31,48,48,44,44,29,29,121,121,0,0,17,17,94,94,24,24,91,91,93,93,42,42,59,59,90,90,57,57,81,81,9,9,62,62,127,127,107,107,98,98,6,6,46,46,38,38,28,28,100,100,6,6,1,1,30,30,118,118,99,99,102,102,8,8,113,113,112,112,43,43,124,124,8,8,102,102,14,14,97,97,78,78,67,67,114,114,53,53,80,80,11,11,50,50,116,116,55,55,79,79,70,70,45,45,81,81,8,8,124,124,16,16,3,3,79,79,100,100,83,83,33,33,75,75,32,32,73,73,40,40,36,36,54,54,65,65,72,72,105,105,42,42,48,48,84,84,93,93,115,115,62,62,1,1,56,56,70,70,53,53,72,72,88,88,27,27,1,1,25,25,120,120,12,12,34,34,112,112,3,3,13,13,125,125,9,9,101,101,98,98,65,65,34,34,61,61,1,1,71,71,68,68,27,27,124,124,58,58,104,104,116,116,62,62,126,126,82,82,117,117,68,68,8,8,50,50,34,34,102,102,37,37,115,115,57,57,69,69,20,20,20,20,79,79,123,123,98,98,76,76,19,19,103,103,44,44,81,81,99,99,91,91,67,67,24,24,82,82,10,10,3,3,74,74,68,68,48,48,91,91,84,84,10,10,73,73,14,14,125,125,102,102,60,60,80,80,109,109,120,120,109,109,119,119,37,37,30,30,77,77,111,111,44,44,15,15,74,74,11,11,82,82,39,39,1,1,0,0,117,117,121,121,67,67,49,49,5,5,73,73,33,33,89,89,27,27,70,70,48,48,36,36,36,36,34,34,38,38,0,0,13,13,33,33,107,107,112,112,123,123,110,110,63,63,43,43,36,36,58,58,35,35,68,68,117,117,109,109,101,101,80,80,109,109,23,23,109,109,80,80,8,8,119,119,49,49,78,78,14,14,87,87,8,8,102,102,113,113,64,64,80,80,102,102,62,62,43,43,16,16,118,118,41,41,5,5,126,126,60,60,114,114,46,46,29,29,106,106,11,11,107,107,82,82,118,118,78,78,13,13,106,106,73,73,32,32,4,4,90,90,97,97,103,103,18,18,110,110,20,20,23,23,48,48,51,51,0,0,87,87,71,71,32,32,64,64,76,76,32,32,118,118,79,79,125,125,67,67,116,116,112,112,97,97,98,98,71,71,85,85,65,65,10,10,0,0,32,32,115,115,39,39,26,26,70,70,100,100,73,73,23,23,1,1,124,124,38,38,1,1,102,102,50,50,76,76,77,77,70,70,5,5,95,95,18,18,95,95,87,87,25,25,110,110,54,54,108,108,80,80,67,67,89,89,75,75,105,105,102,102,61,61,9,9,100,100,26,26,21,21,97,97,79,79,27,27,41,41,95,95,5,5,70,70,45,45,95,95,71,71,24,24,71,71,23,23,70,70,22,22,12,12,80,80,2,2,84,84,95,95,126,126,22,22,116,116,13,13,86,86,98,98,24,24,113,113,25,25,126,126,29,29,83,83,33,33,30,30,94,94,70,70,124,124,21,21,78,78,0,0,31,31,75,75,25,25,18,18,39,39,58,58,84,84,121,121,2,2,98,98,5,5,61,61,64,64,88,88,71,71,91,91,54,54,124,124,2,2,87,87,99,99,38,38,54,54,99,99,7,7,125,125,1,1,24,24,2,2,78,78,126,126,115,115,1,1,69,69,124,124,45,45,35,35,71,71,94,94,120,120,69,69,78,78,51,51,62,62,41,41,100,100,28,28,48,48,24,24,52,52,86,86,59,59,49,49,67,67,11,11,34,34,72,72,75,75,76,76,17,17,8,8,42,42,118,118,121,121,121,121,76,76,42,42,9,9,49,49,67,67,73,73,64,64,80,80,24,24,123,123,43,43,58,58,3,3,91,91,63,63,45,45,51,51,56,56,125,125,80,80,19,19,92,92,120,120,39,39,119,119,76,76,35,35,105,105,40,40,92,92,30,30,10,10,79,79,75,75,70,70,76,76,108,108,68,68,90,90,68,68,78,78,101,101,20,20,18,18,17,17,59,59,122,122,100,100,82,82,103,103,54,54,33,33,21,21,113,113,26,26,105,105,124,124,87,87,23,23,73,73,54,54,48,48,57,57,13,13,48,48,4,4,124,124,125,125,93,93,25,25,119,119,92,92,40,40,35,35,11,11,23,23,97,97,4,4,61,61,101,101,61,61,120,120,24,24,22,22,48,48,127,127,27,27,32,32,124,124,67,67,95,95,98,98,79,79,83,83,12,12,101,101,89,89,82,82,115,115,4,4,71,71,41,41,4,4,50,50,37,37,114,114,107,107,5,5,64,64,98,98,21,21,75,75,83,83,88,88,126,126,84,84,92,92,62,62,114,114,51,51,37,37,51,51,19,19,112,112,75,75,83,83,25,25,64,64,28,28,56,56,55,55,58,58,29,29,49,49,63,63,23,23,18,18,63,63,98,98,81,81,19,19,4,4,125,125,79,79,9,9,104,104,120,120,18,18,16,16,110,110,15,15,72,72,113,113,36,36,4,4,18,18,18,18,0,0,48,48,121,121,120,120,32,32,12,12,1,1,28,28,4,4,115,115,67,67,43,43,14,14,105,105,56,56,94,94,31,31,96,96,98,98,74,74,86,86,34,34,81,81,103,103,95,95,74,74,56,56,33,33,93,93,84,84,83,83,1,1,37,37,31,31,82,82,8,8,117,117,68,68,62,62,32,32,61,61,43,43,126,126,13,13,4,4,116,116,28,28,75,75,118,118,46,46,80,80,47,47,49,49,16,16,105,105,95,95,126,126,38,38,60,60,82,82,83,83,116,116,90,90,120,120,57,57,62,62,32,32,86,86,57,57,84,84,41,41,12,12,110,110,40,40,118,118,15,15,81,81,88,88,117,117,16,16,9,9,83,83,67,67,53,53,43,43,64,64,49,49,105,105,100,100,75,75,34,34,16,16,34,34,7,7,1,1,99,99,16,16,80,80,10,10,99,99,55,55,87,87,97,97,67,67,85,85,16,16,99,99,41,41,22,22,44,44,10,10,99,99,8,8,9,9,13,13,107,107,60,60,75,75,87,87,1,1,74,74,65,65,32,32,58,58,26,26,87,87,59,59,92,92,50,50,5,5,114,114,43,43,53,53,8,8,18,18,80,80,6,6,109,109,119,119,106,106,14,14,33,33,3,3,95,95,17,17,55,55,115,115,32,32,43,43,66,66,43,43,28,28,40,40,98,98,96,96,126,126,0,0,92,92,79,79,20,20,35,35,53,53,17,17,67,67,126,126,100,100,122,122,34,34,32,32,71,71,1,1,48,48,102,102,119,119,110,110,109,109,116,116,47,47,30,30,62,62,124,124,89,89,23,23,100,100,94,94,108,108,12,12,67,67,53,53,73,73,25,25,110,110,38,38,43,43,60,60,47,47,98,98,59,59,123,123,41,41,38,38,32,32,102,102,112,112,2,2,2,2,8,8,126,126,102,102,67,67,50,50,84,84,32,32,60,60,85,85,52,52,102,102,109,109,43,43,69,69,118,118,99,99,79,79,111,111,116,116,53,53,53,53,96,96,33,33,101,101,24,24,121,121,24,24,44,44,44,44,36,36,84,84,15,15,82,82,117,117,11,11,38,38,41,41,49,49,61,61,35,35,25,25,72,72,44,44,35,35,7,7,75,75,86,86,112,112,96,96,48,48,36,36,122,122,61,61,84,84,110,110,121,121,116,116,25,25,64,64,84,84,103,103,16,16,75,75,33,33,53,53,58,58,54,54,31,31,24,24,51,51,3,3,1,1,7,7,104,104,23,23,122,122,113,113,15,15,39,39,12,12,62,62,64,64,95,95,109,109,97,97,30,30,48,48,113,113,21,21,13,13,77,77,113,113,10,10,92,92,66,66,78,78,112,112,7,7,32,32,71,71,104,104,24,24,81,81,13,13,98,98,85,85,120,120,115,115,68,68,16,16,68,68,58,58,73,73,89,89,76,76,120,120,1,1,81,81,68,68,41,41,115,115,77,77,82,82,56,56,71,71,94,94,43,43,14,14,121,121,1,1,111,111,26,26,5,5,58,58,30,30,78,78,112,112,9,9,85,85,78,78,37,37,77,77,16,16,33,33,118,118,4,4,64,64,72,72,118,118,104,104,59,59,74,74,102,102,31,31,84,84,1,1,37,37,105,105,88,88,4,4,108,108,2,2,41,41,38,38,92,92,47,47,98,98,31,31,113,113,27,27,110,110,127,127,35,35,12,12,34,34,122,122,97,97,103,103,10,10,30,30,40,40,104,104,76,76,116,116,66,66,64,64,9,9,94,94,4,4,23,23,13,13,124,124,2,2,61,61,5,5,41,41,7,7,84,84,97,97,28,28,27,27,96,96,99,99,17,17,22,22,104,104,101,101,84,84,89,89,64,64,112,112,119,119,68,68,40,40,71,71,55,55,5,5,108,108,60,60,93,93,0,0,54,54,7,7,48,48,48,48,27,27,45,45,3,3,70,70,52,52,83,83,110,110,16,16,8,8,98,98,38,38,1,1,54,54,123,123,0,0,39,39,49,49,14,14,6,6,96,96,11,11,74,74,51,51,2,2,75,75,0,0,17,17,7,7,112,112,105,105,23,23,5,5,88,88,57,57,67,67,88,88,118,118,20,20,122,122,18,18,67,67,45,45,112,112,10,10,117,117,53,53,64,64,81,81,70,70,14,14,49,49,35,35,46,46,11,11,76,76,70,70,79,79,79,79,70,70,88,88,120,120,51,51,12,12,73,73,36,36,15,15,11,11,67,67,9,9,0,0,89,89,104,104,53,53,29,29,18,18,82,82,110,110,3,3,97,97,13,13,85,85,38,38,36,36,112,112,1,1,79,79,4,4,74,74,46,46,112,112,118,118,83,83,48,48,25,25,124,124,21,21,56,56,0,0,110,110,59,59,8,8,44,44,95,95,16,16,80,80,41,41,10,10,115,115,48,48,0,0,8,8,85,85,42,42,6,6,38,38,17,17,59,59,59,59,71,71,23,23,78,78,126,126,78,78,45,45,30,30,92,92,14,14,93,93,0,0,12,12,25,25,16,16,23,23,57,57,56,56,42,42,74,74,4,4,79,79,46,46,89,89,106,106,95,95,6,6,99,99,80,80,34,34,64,64,27,27,25,25,80,80,124,124,2,2,50,50,18,18,91,91,73,73,109,109,47,47,124,124,37,37,38,38,78,78,82,82,49,49,28,28,2,2,9,9,117,117,12,12,22,22,0,0,38,38,12,12,28,28,100,100,82,82,93,93,37,37,92,92,17,17,9,9,105,105,37,37,9,9,59,59,34,34,21,21,105,105,103,103,64,64,13,13,73,73,63,63,123,123,71,71,34,34,48,48,64,64,60,60,18,18,89,89,32,32,21,21,51,51,116,116,96,96,74,74,68,68,12,12,101,101,46,46,31,31,124,124,94,94,91,91,31,31,61,61,4,4,40,40,27,27,12,12,32,32,92,92,7,7,46,46,62,62,30,30,46,46,74,74,47,47,35,35,92,92,113,113,106,106,116,116,101,101,9,9,13,13,0,0,123,123,27,27,93,93,91,91,104,104,32,32,98,98,49,49,123,123,3,3,82,82,121,121,20,20,74,74,41,41,3,3,48,48,70,70,16,16,48,48,2,2,0,0,35,35,88,88,109,109,10,10,62,62,127,127,91,91,43,43,31,31,57,57,97,97,8,8,3,3,25,25,108,108,109,109,117,117,61,61,30,30,9,9,25,25,102,102,31,31,72,72,107,107,31,31,66,66,83,83,123,123,68,68,102,102,5,5,13,13,45,45,109,109,6,6,0,0,35,35,70,70,0,0,0,0,45,45,43,43,100,100,112,112,40,40,42,42,10,10,93,93,119,119,83,83,99,99,75,75,51,51,40,40,37,37,98,98,125,125,39,39,83,83,11,11,61,61,110,110,24,24,43,43,56,56,116,116,99,99,52,52,66,66,62,62,58,58,109,109,22,22,86,86,52,52,3,3,91,91,73,73,74,74,111,111,12,12,4,4,12,12,12,12,29,29,65,65,35,35,11,11,99,99,3,3,117,117,3,3,64,64,33,33,61,61,102,102,32,32,104,104,13,13,107,107,11,11,45,45,6,6,5,5,35,35,81,81,38,38,75,75,26,26,34,34,22,22,101,101,72,72,31,31,86,86,94,94,22,22,76,76,74,74,19,19,103,103,0,0,0,0,30,30,23,23,96,96,59,59,59,59,51,51,100,100,67,67,34,34,4,4,47,47,4,4,18,18,91,91,3,3,74,74,85,85,77,77,79,79,3,3,58,58,84,84,80,80,115,115,35,35,118,118,27,27,119,119,121,121,112,112,1,1,16,16,125,125,10,10,35,35,127,127,39,39,57,57,90,90,35,35,26,26,117,117,2,2,59,59,104,104,45,45,99,99,29,29,12,12,30,30,62,62,21,21,0,0,112,112,9,9,61,61,34,34,24,24,116,116,4,4,36,36,13,13,18,18,73,73,34,34,110,110,78,78,71,71,81,81,77,77,49,49,110,110,31,31,52,52,21,21,33,33,112,112,21,21,56,56,33,33,58,58,112,112,93,93,99,99,24,24,106,106,13,13,86,86,59,59,77,77,7,7,51,51,43,43,69,69,114,114,108,108,48,48,89,89,124,124,104,104,72,72,81,81,16,16,126,126,95,95,112,112,67,67,75,75,68,68,17,17,112,112,112,112,59,59,59,59,88,88,106,106,55,55,54,54,17,17,16,16,91,91,11,11,47,47,126,126,26,26,73,73,18,18,21,21,117,117,16,16,91,91,112,112,24,24,44,44,86,86,115,115,91,91,37,37,26,26,59,59,111,111,100,100,98,98,9,9,97,97,96,96,117,117,56,56,92,92,124,124,56,56,2,2,126,126,9,9,71,71,56,56,107,107,7,7,96,96,108,108,87,87,9,9,123,123,122,122,79,79,13,13,42,42,38,38,50,50,4,4,21,21,18,18,56,56,102,102,36,36,28,28,65,65,52,52,99,99,75,75,16,16,53,53,99,99,34,34,35,35,100,100,51,51,18,18,32,32,112,112,91,91,6,6,1,1,12,12,74,74,38,38,3,3,41,41,122,122,38,38,120,120,36,36,103,103,62,62,107,107,82,82,23,23,49,49,25,25,48,48,38,38,110,110,74,74,34,34,9,9,59,59,94,94,100,100,86,86,58,58,70,70,70,70,23,23,109,109,44,44,123,123,117,117,9,9,90,90,32,32,36,36,42,42,97,97,12,12,1,1,87,87,125,125,1,1,59,59,124,124,102,102,114,114,60,60,103,103,101,101,57,57,5,5,32,32,120,120,83,83,45,45,26,26,8,8,85,85,35,35,5,5,82,82,92,92,111,111,93,93,17,17,68,68,98,98,33,33,5,5,3,3,120,120,117,117,113,113,104,104,14,14,2,2,65,65,85,85,115,115,123,123,90,90,82,82,122,122,99,99,8,8,105,105,57,57,38,38,17,17,86,86,26,26,109,109,27,27,87,87,123,123,17,17,46,46,39,39,56,56,32,32,37,37,100,100,71,71,6,6,37,37,114,114,82,82,111,111,32,32,50,50,68,68,118,118,20,20,32,32,36,36,98,98,84,84,50,50,1,1,42,42,26,26,81,81,112,112,84,84,32,32,79,79,3,3,74,74,22,22,8,8,68,68,56,56,126,126,87,87,71,71,118,118,36,36,75,75,12,12,22,22,50,50,19,19,20,20,105,105,25,25,67,67,56,56,17,17,2,2,103,103,30,30,69,69,75,75,57,57,1,1,103,103,20,20,85,85,104,104,108,108,97,97,27,27,125,125,87,87,115,115,114,114,25,25,114,114,118,118,89,89,46,46,51,51,73,73,120,120,122,122,83,83,66,66,11,11,33,33,20,20,72,72,111,111,52,52,106,106,78,78,42,42,44,44,32,32,88,88,15,15,99,99,78,78,7,7,45,45,50,50,122,122,45,45,15,15,116,116,34,34,45,45,103,103,114,114,104,104,84,84,22,22,103,103,57,57,88,88,105,105,35,35,36,36,88,88,25,25,6,6,17,17,75,75,44,44,60,60,96,96,18,18,88,88,29,29,5,5,70,70,36,36,108,108,2,2,40,40,47,47,77,77,107,107,32,32,23,23,93,93,82,82,38,38,86,86,47,47,83,83,3,3,28,28,2,2,26,26,68,68,108,108,7,7,85,85,80,80,56,56,20,20,2,2,77,77,31,31,57,57,71,71,115,115,16,16,112,112,115,115,7,7,96,96,33,33,36,36,80,80,97,97,95,95,56,56,25,25,96,96,18,18,30,30,5,5,52,52,10,10,59,59,75,75,81,81,43,43,21,21,12,12,26,26,9,9,103,103,88,88,56,56,84,84,35,35,95,95,37,37,58,58,104,104,22,22,43,43,42,42,90,90,18,18,0,0,38,38,56,56,88,88,39,39,33,33,5,5,88,88,103,103,63,63,9,9,33,33,48,48,61,61,80,80,98,98,2,2,96,96,88,88,118,118,25,25,24,24,21,21,92,92,115,115,71,71,94,94,59,59,25,25,124,124,120,120,10,10,50,50,34,34,15,15,75,75,32,32,78,78,75,75,40,40,68,68,32,32,50,50,73,73,51,51,72,72,124,124,22,22,63,63,109,109,1,1,5,5,119,119,87,87,111,111,8,8,81,81,123,123,43,43,7,7,47,47,110,110,62,62,120,120,18,18,94,94,84,84,80,80,61,61,48,48,23,23,64,64,73,73,83,83,118,118,41,41,26,26,34,34,66,66,1,1,6,6,15,15,72,72,50,50,124,124,80,80,73,73,43,43,0,0,26,26,31,31,1,1,107,107,8,8,69,69,61,61,100,100,86,86,5,5,9,9,40,40,16,16,81,81,22,22,96,96,46,46,48,48,63,63,14,14,20,20,10,10,32,32,99,99,82,82,110,110,99,99,42,42,28,28,83,83,27,27,118,118,18,18,85,85,111,111,58,58,0,0,44,44,24,24,30,30,19,19,69,69,9,9,118,118,52,52,123,123,60,60,115,115,61,61,18,18,37,37,120,120,70,70,32,32,40,40,19,19,78,78,53,53,33,33,75,75,127,127,45,45,22,22,75,75,24,24,56,56,79,79,120,120,111,111,107,107,32,32,70,70,89,89,32,32,125,125,91,91,88,88,44,44,103,103,58,58,17,17,98,98,24,24,96,96,68,68,96,96,67,67,116,116,32,32,127,127,81,81,102,102,15,15,85,85,3,3,35,35,40,40,5,5,30,30,18,18,24,24,115,115,44,44,123,123,32,32,57,57,123,123,25,25,9,9,70,70,0,0,1,1,47,47,86,86,64,64,86,86,8,8,71,71,41,41,32,32,106,106,48,48,43,43,68,68,86,86,18,18,21,21,99,99,75,75,25,25,18,18,69,69,77,77,78,78,29,29,27,27,84,84,76,76,61,61,29,29,9,9,104,104,119,119,121,121,18,18,0,0,121,121,31,31,34,34,56,56,4,4,119,119,68,68,21,21,8,8,125,125,74,74,112,112,59,59,119,119,28,28,51,51,104,104,46,46,13,13,78,78,68,68,22,22,126,126,102,102,39,39,21,21,61,61,13,13,33,33,31,31,114,114,99,99,39,39,20,20,10,10,32,32,72,72,18,18,32,32,121,121,84,84,34,34,75,75,70,70,96,96,78,78,22,22,61,61,101,101,46,46,46,46,65,65,29,29,17,17,102,102,57,57,64,64,25,25,89,89,94,94,36,36,0,0,18,18,30,30,72,72,32,32,67,67,14,14,63,63,12,12,98,98,27,27,109,109,34,34,95,95,92,92,25,25,119,119,54,54,9,9,62,62,121,121,97,97,80,80,27,27,75,75,51,51,29,29,50,50,43,43,72,72,24,24,11,11,44,44,44,44,33,33,40,40,67,67,31,31,43,43,126,126,14,14,107,107,99,99,104,104,7,7,66,66,40,40,3,3,7,7,126,126,96,96,77,77,42,42,121,121,102,102,64,64,50,50,70,70,21,21,37,37,69,69,89,89,106,106,57,57,32,32,2,2,10,10,68,68,42,42,115,115,106,106,46,46,59,59,24,24,108,108,8,8,42,42,39,39,11,11,57,57,113,113,30,30,38,38,45,45,122,122,0,0,72,72,43,43,10,10,12,12,72,72,107,107,105,105,20,20,66,66,20,20,97,97,31,31,55,55,28,28,8,8,37,37,88,88,111,111,104,104,108,108,0,0,110,110,66,66,118,118,20,20,50,50,109,109,105,105,50,50,45,45,52,52,71,71,65,65,71,71,96,96,39,39,82,82,35,35,36,36,65,65,26,26,115,115,44,44,113,113,34,34,99,99,109,109,96,96,10,10,71,71,85,85,32,32,3,3,29,29,105,105,89,89,4,4,76,76,119,119,52,52,82,82,55,55,98,98,121,121,34,34,52,52,13,13,83,83,5,5,6,6,104,104,100,100,82,82,92,92,113,113,39,39,35,35,56,56,72,72,19,19,109,109,91,91,55,55,32,32,64,64,20,20,60,60,50,50,22,22,36,36,121,121,92,92,114,114,84,84,20,20,81,81,36,36,15,15,69,69,30,30,55,55,85,85,69,69,56,56,21,21,27,27,90,90,14,14,43,43,105,105,82,82,4,4,46,46,21,21,9,9,62,62,41,41,78,78,22,22,85,85,122,122,124,124,117,117,2,2,34,34,38,38,99,99,60,60,32,32,88,88,62,62,20,20,1,1,5,5,4,4,26,26,61,61,92,92,20,20,89,89,6,6,69,69,124,124,32,32,19,19,101,101,78,78,110,110,17,17,75,75,21,21,87,87,126,126,91,91,110,110,18,18,28,28,108,108,95,95,101,101,57,57,37,37,11,11,75,75,41,41,30,30,112,112,101,101,124,124,70,70,108,108,82,82,44,44,88,88,25,25,127,127,74,74,44,44,93,93,71,71,118,118,63,63,22,22,0,0,0,0,14,14,34,34,13,13,14,14,34,34,80,80,99,99,30,30,77,77,34,34,8,8,79,79,27,27,116,116,121,121,63,63,83,83,78,78,15,15,89,89,47,47,4,4,86,86,106,106,86,86,2,2,66,66,109,109,108,108,105,105,113,113,99,99,105,105,47,47,49,49,50,50,39,39,72,72,27,27,2,2,10,10,66,66,38,38,28,28,117,117,0,0,23,23,106,106,55,55,66,66,114,114,20,20,52,52,124,124,22,22,76,76,105,105,40,40,124,124,124,124,104,104,118,118,9,9,65,65,111,111,120,120,120,120,71,71,2,2,50,50,69,69,93,93,118,118,93,93,59,59,111,111,25,25,90,90,36,36,84,84,81,81,18,18,8,8,89,89,77,77,82,82,39,39,74,74,40,40,84,84,111,111,86,86,16,16,41,41,126,126,75,75,56,56,46,46,86,86,5,5,27,27,117,117,81,81,25,25,42,42,26,26,115,115,119,119,8,8,74,74,118,118,5,5,59,59,44,44,84,84,19,19,105,105,67,67,100,100,25,25,98,98,73,73,106,106,116,116,8,8,16,16,111,111,79,79,51,51,71,71,22,22,43,43,103,103,16,16,25,25,3,3,109,109,55,55,17,17,12,12,73,73,32,32,60,60,94,94,94,94,46,46,23,23,86,86,40,40,8,8,86,86,59,59,4,4,119,119,102,102,67,67,93,93,2,2,79,79,43,43,78,78,81,81,41,41,32,32,114,114,47,47,85,85,64,64,99,99,50,50,82,82,80,80,1,1,71,71,108,108,43,43,117,117,53,53,80,80,47,47,96,96,63,63,59,59,17,17,20,20,123,123,62,62,119,119,62,62,51,51,93,93,50,50,87,87,14,14,26,26,111,111,28,28,50,50,96,96,96,96,4,4,110,110,28,28,18,18,4,4,13,13,90,90,24,24,75,75,27,27,9,9,78,78,85,85,102,102,56,56,80,80,23,23,107,107,66,66,100,100,33,33,99,99,107,107,13,13,80,80,35,35,75,75,98,98,8,8,21,21,109,109,25,25,65,65,80,80,80,80,6,6,99,99,49,49,14,14,75,75,127,127,16,16,66,66,60,60,108,108,94,94,1,1,17,17,111,111,79,79,32,32,55,55,63,63,105,105,56,56,114,114,17,17,64,64,34,34,125,125,100,100,117,117,14,14,74,74,12,12,107,107,72,72,103,103,117,117,127,127,108,108,26,26,55,55,101,101,122,122,93,93,22,22,66,66,101,101,92,92,96,96,27,27,13,13,74,74,26,26,80,80,30,30,110,110,88,88,72,72,80,80,18,18,29,29,89,89,29,29,5,5,107,107,118,118,94,94,14,14,38,38,24,24,84,84,19,19,111,111,43,43,69,69,67,67,107,107,12,12,87,87,101,101,2,2,38,38,43,43,0,0,91,91,97,97,2,2,87,87,34,34,114,114,124,124,125,125,61,61,37,37,54,54,127,127,12,12,76,76,44,44,0,0,4,4,59,59,74,74,27,27,32,32,31,31,65,65,82,82,65,65,30,30,11,11,45,45,15,15,55,55,31,31,85,85,36,36,56,56,7,7,16,16,2,2,21,21,82,82,108,108,43,43,108,108,71,71,107,107,18,18,48,48,84,84,121,121,120,120,103,103,19,19,56,56,49,49,27,27,110,110,43,43,72,72,67,67,43,43,57,57,88,88,2,2,36,36,28,28,10,10,9,9,63,63,76,76,116,116,23,23,44,44,108,108,70,70,79,79,25,25,45,45,32,32,55,55,77,77,9,9,103,103,74,74,48,48,23,23,48,48,120,120,53,53,63,63,32,32,55,55,0,0,68,68,44,44,118,118,36,36,32,32,108,108,112,112,70,70,51,51,9,9,11,11,91,91,3,3,58,58,6,6,78,78,89,89,6,6,121,121,113,113,84,84,78,78,26,26,10,10,80,80,113,113,118,118,62,62,95,95,16,16,32,32,74,74,92,92,5,5,36,36,43,43,49,49,36,36,113,113,27,27,36,36,93,93,70,70,48,48,15,15,84,84,84,84,2,2,117,117,55,55,69,69,24,24,125,125,16,16,92,92,3,3,95,95,93,93,23,23,76,76,12,12,72,72,70,70,4,4,88,88,104,104,127,127,89,89,16,16,1,1,60,60,112,112,99,99,100,100,94,94,29,29,42,42,114,114,66,66,79,79,78,78,82,82,40,40,83,83,51,51,100,100,0,0,6,6,62,62,36,36,127,127,7,7,105,105,106,106,33,33,12,12,51,51,72,72,49,49,37,37,51,51,126,126,13,13,45,45,2,2,83,83,107,107,9,9,71,71,122,122,44,44,106,106,117,117,114,114,74,74,13,13,72,72,112,112,36,36,27,27,118,118,127,127,35,35,53,53,20,20,26,26,111,111,52,52,66,66,126,126,107,107,7,7,94,94,14,14,35,35,55,55,5,5,85,85,111,111,22,22,67,67,17,17,48,48,32,32,73,73,81,81,50,50,28,28,114,114,2,2,36,36,52,52,120,120,125,125,6,6,121,121,58,58,124,124,109,109,45,45,48,48,28,28,72,72,13,13,104,104,6,6,22,22,39,39,85,85,35,35,106,106,26,26,65,65,85,85,89,89,123,123,85,85,68,68,68,68,8,8,55,55,106,106,38,38,84,84,44,44,103,103,96,96,103,103,93,93,4,4,97,97,88,88,33,33,63,63,43,43,76,76,28,28,56,56,1,1,71,71,51,51,34,34,28,28,13,13,11,11,127,127,110,110,108,108,2,2,65,65,114,114,25,25,8,8,112,112,109,109,99,99,92,92,117,117,106,106,26,26,59,59,106,106,37,37,48,48,63,63,46,46,111,111,125,125,126,126,46,46,11,11,103,103,2,2,54,54,45,45,104,104,34,34,64,64,75,75,24,24,89,89,119,119,126,126,35,35,45,45,1,1,107,107,72,72,114,114,87,87,119,119,21,21,96,96,82,82,101,101,86,86,20,20,64,64,125,125,40,40,97,97,61,61,77,77,110,110,42,42,25,25,11,11,81,81,29,29,39,39,107,107,30,30,27,27,13,13,62,62,96,96,36,36,41,41,127,127,113,113,12,12,85,85,121,121,52,52,33,33,62,62,57,57,111,111,9,9,102,102,86,86,43,43,118,118,64,64,8,8,42,42,72,72,31,31,0,0,99,99,19,19,2,2,119,119,70,70,55,55,56,56,115,115,4,4,83,83,83,83,13,13,64,64,5,5,64,64,92,92,26,26,46,46,69,69,66,66,67,67,47,47,106,106,106,106,28,28,68,68,4,4,32,32,38,38,69,69,118,118,75,75,127,127,47,47,6,6,69,69,78,78,53,53,40,40,34,34,59,59,4,4,104,104,57,57,55,55,7,7,64,64,29,29,106,106,72,72,61,61,90,90,23,23,98,98,117,117,13,13,39,39,126,126,105,105,68,68,10,10,100,100,94,94,50,50,54,54,64,64,46,46,77,77,15,15,43,43,77,77,59,59,1,1,35,35,19,19,35,35,23,23,123,123,58,58,78,78,2,2,34,34,0,0,31,31,88,88,92,92,18,18,55,55,89,89,117,117,74,74,6,6,36,36,56,56,76,76,53,53,113,113,35,35,2,2,53,53,92,92,8,8,67,67,32,32,35,35,30,30,80,80,65,65,70,70,39,39,6,6,29,29,103,103,63,63,0,0,76,76,26,26,85,85,78,78,9,9,123,123,27,27,33,33,67,67,8,8,71,71,58,58,23,23,21,21,89,89,109,109,42,42,119,119,115,115,61,61,37,37,67,67,52,52,97,97,89,89,16,16,117,117,107,107,100,100,69,69,33,33,78,78,52,52,96,96,36,36,82,82,60,60,45,45,122,122,58,58,64,64,108,108,61,61,12,12,53,53,49,49,64,64,106,106,10,10,93,93,84,84,74,74,43,43,68,68,75,75,116,116,107,107,95,95,113,113,62,62,14,14,34,34,9,9,70,70,38,38,88,88,92,92,12,12,97,97,109,109,103,103,79,79,121,121,122,122,117,117,57,57,35,35,98,98,125,125,37,37,9,9,47,47,64,64,80,80,69,69,16,16,29,29,105,105,57,57,76,76,120,120,41,41,48,48,17,17,51,51,55,55,30,30,123,123,107,107,41,41,65,65,68,68,108,108,82,82,94,94,58,58,39,39,64,64,44,44,86,86,62,62,86,86,61,61,1,1,24,24,69,69,50,50,77,77,78,78,62,62,1,1,74,74,6,6,5,5,71,71,33,33,97,97,40,40,112,112,41,41,20,20,31,31,126,126,104,104,110,110,25,25,19,19,38,38,109,109,72,72,49,49,64,64,81,81,55,55,58,58,107,107,21,21,94,94,117,117,70,70,13,13,119,119,70,70,87,87,40,40,112,112,98,98,72,72,10,10,49,49,114,114,7,7,98,98,80,80,125,125,62,62,12,12,0,0,103,103,76,76,18,18,23,23,124,124,9,9,70,70,28,28,57,57,42,42,20,20,70,70,64,64,88,88,18,18,17,17,64,64,117,117,99,99,120,120,102,102,116,116,88,88,13,13,74,74,72,72,107,107,62,62,12,12,119,119,4,4,73,73,8,8,8,8,35,35,45,45,62,62,33,33,92,92,40,40,75,75,107,107,35,35,108,108,20,20,98,98,88,88,39,39,108,108,92,92,23,23,53,53,124,124,48,48,95,95,3,3,109,109,62,62,118,118,2,2,100,100,4,4,30,30,88,88,86,86,80,80,58,58,80,80,6,6,85,85,43,43,54,54,41,41,79,79,102,102,40,40,68,68,45,45,3,3,32,32,1,1,78,78,118,118,88,88,114,114,29,29,46,46,11,11,27,27,64,64,28,28,52,52,100,100,99,99,96,96,27,27,116,116,18,18,77,77,33,33,108,108,40,40,90,90,69,69,21,21,18,18,25,25,96,96,28,28,58,58,70,70,52,52,32,32,46,46,87,87,98,98,40,40,57,57,47,47,5,5,74,74,50,50,92,92,80,80,98,98,108,108,10,10,16,16,55,55,116,116,102,102,63,63,15,15,25,25,97,97,115,115,118,118,74,74,68,68,89,89,82,82,119,119,75,75,83,83,39,39,7,7,80,80,57,57,85,85,112,112,89,89,3,3,108,108,111,111,107,107,84,84,20,20,94,94,17,17,32,32,60,60,4,4,61,61,79,79,104,104,112,112,103,103,97,97,28,28,112,112,54,54,31,31,98,98,95,95,97,97,82,82,27,27,79,79,108,108,49,49,4,4,15,15,15,15,67,67,76,76,44,44,82,82,81,81,104,104,100,100,90,90,83,83,127,127,2,2,96,96,21,21,62,62,84,84,14,14,15,15,101,101,75,75,52,52,25,25,95,95,88,88,8,8,11,11,105,105,11,11,52,52,15,15,75,75,125,125,2,2,43,43,22,22,0,0,43,43,22,22,113,113,17,17,60,60,78,78,92,92,9,9,102,102,104,104,70,70,13,13,59,59,98,98,103,103,23,23,18,18,71,71,109,109,5,5,21,21,47,47,0,0,68,68,11,11,83,83,111,111,70,70,40,40,13,13,22,22,25,25,53,53,36,36,66,66,50,50,50,50,54,54,26,26,84,84,35,35,41,41,126,126,107,107,97,97,4,4,66,66,3,3,85,85,30,30,45,45,50,50,88,88,106,106,50,50,90,90,127,127,42,42,21,21,34,34,26,26,31,31,1,1,18,18,4,4,103,103,82,82,44,44,111,111,92,92,87,87,76,76,11,11,72,72,15,15,32,32,127,127,81,81,55,55,3,3,95,95,112,112,113,113,48,48,1,1,63,63,112,112,14,14,91,91,18,18,39,39,18,18,67,67,105,105,14,14,16,16,102,102,112,112,0,0,31,31,11,11,114,114,0,0,9,9,80,80,29,29,101,101,123,123,69,69,51,51,107,107,34,34,69,69,106,106,44,44,45,45,19,19,44,44,10,10,0,0,22,22,112,112,3,3,18,18,24,24,65,65,0,0,97,97,71,71,91,91,21,21,13,13,123,123,51,51,74,74,55,55,17,17,78,78,127,127,68,68,23,23,2,2,30,30,110,110,88,88,4,