// This file is part of the FidelityFX SDK.
//
// Copyright (C) 2024 Advanced Micro Devices, Inc.
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files(the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and /or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions :
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#ifndef FFX_BRIXELIZER_RESOURCES_H
#define FFX_BRIXELIZER_RESOURCES_H

#if defined(FFX_CPU) || defined(FFX_GPU)
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_NULL                                  0
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_CASCADE_AABB_TREE                     1 //  24 elements
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_CASCADE_AABB_TREES                    1 //  24 elements (Same as the previous ID, used for binding the descriptor array)
// The cascade octree previously occupied 24 elements here.
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_CASCADE_BRICK_MAP                     25 //  24 elements
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_CASCADE_BRICK_MAPS                    25 //  24 elements (Same as the previous ID, used for binding the descriptor array)
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_CASCADE_READBACK_BUFFERS              49 //  3 * 24 elements

#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_INSTANCE_INFO_BUFFER                  121
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_INSTANCE_TRANSFORM_BUFFER             122
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_JOB_BUFFER                            123
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_JOB_INDEX_BUFFER                      124
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_INDIRECT_ARGS_1                       125

#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_SCRATCH_COUNTERS                      126
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_SCRATCH_INDEX_SWAP                    127
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_SCRATCH_VOXEL_ALLOCATION_FAIL_COUNTER 128
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_SCRATCH_BRICKS_STORAGE                129
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_SCRATCH_BRICKS_STORAGE_OFFSETS        130
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_SCRATCH_BRICKS_COMPRESSION_LIST       131
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_SCRATCH_BRICKS_CLEAR_LIST             132
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_SCRATCH_JOB_COUNTERS                  133
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_SCRATCH_JOB_COUNTERS_SCAN             134
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_SCRATCH_JOB_GLOBAL_COUNTERS_SCAN      135
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_SCRATCH_CR1_REFERENCES                136
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_SCRATCH_CR1_COMPACTED_REFERENCES      137
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_SCRATCH_CR1_REF_COUNTERS              138
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_SCRATCH_CR1_REF_COUNTER_SCAN          139
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_SCRATCH_CR1_REF_GLOBAL_SCAN           140
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_SCRATCH_CR1_STAMP_SCAN                141
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_SCRATCH_CR1_STAMP_GLOBAL_SCAN         142
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_SCRATCH_DEBUG_AABBS                   143

#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_CONTEXT_BRICKS_VOXEL_MAP              144
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_CONTEXT_BRICKS_AABB                   145
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_CONTEXT_BRICKS_FREE_LIST              146
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_CONTEXT_BRICKS_CLEAR_LIST             147
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_CONTEXT_BRICKS_EIKONAL_LIST           148
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_CONTEXT_BRICKS_MERGE_LIST             149
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_CONTEXT_BRICKS_EIKONAL_COUNTERS       150
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_CONTEXT_COUNTERS                      151
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_CONTEXT_COUNTERS_READBACK_0           152
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_CONTEXT_COUNTERS_READBACK_1           153
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_CONTEXT_COUNTERS_READBACK_2           154
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_CONTEXT_SDF_ATLAS                     155

#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_UPLOAD_INSTANCE_INFO_BUFFER           156
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_UPLOAD_INSTANCE_TRANSFORM_BUFFER      157
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_UPLOAD_JOB_BUFFER                     158
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_UPLOAD_JOB_INDEX_BUFFER               159
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_DEBUG_OUTPUT                          160
#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_SCRATCH_BUFFER                        161

#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_UPLOAD_DEBUG_INSTANCE_ID_BUFFER       162

#define FFX_BRIXELIZER_RESOURCE_IDENTIFIER_COUNT                                 163

#define FFX_BRIXELIZER_CONSTANTBUFFER_IDENTIFIER_CASCADE_INFO                    0
#define FFX_BRIXELIZER_CONSTANTBUFFER_IDENTIFIER_CONTEXT_INFO                    1
#define FFX_BRIXELIZER_CONSTANTBUFFER_IDENTIFIER_BUILD_INFO                      2
#define FFX_BRIXELIZER_CONSTANTBUFFER_IDENTIFIER_DEBUG_INFO                      3

#endif  // #if defined(FFX_CPU) || defined(FFX_GPU)

#endif  //!defined( FFX_BRIXELIZER_RESOURCES_H )
