// This file is part of the FidelityFX SDK.
//
// Copyright (C) 2024 Advanced Micro Devices, Inc.
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files(the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and /or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions :
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// An Owen-scrambled Sobol sequence of 256 samples of 256 dimensions
static const int sobol_256spp_256d[256*256] = {32,226,72,70,57,171,246,75,112,81,109,239,120,101,230,103,103,41,249,86,253,99,132,184,214,147,128,248,17,149,163,17,60,40,169,196,77,79,102,23,250,77,75,151,95,123,234,198,25,26,184,114,230,188,105,18,231,233,175,151,19,174,202,71,84,229,247,148,182,127,92,14,41,112,162,253,35,101,137,30,111,134,95,122,28,2,41,254,181,91,101,188,145,31,166,38,53,193,1,122,99,86,178,36,198,169,113,255,97,221,227,231,29,100,30,141,250,254,16,157,2,220,187,95,181,125,207,187,105,119,156,41,16,194,93,216,227,124,138,90,227,1,88,153,233,69,120,36,19,189,120,4,185,220,185,109,184,96,247,173,210,227,54,3,18,9,139,213,156,57,61,101,37,247,21,201,10,143,11,38,146,18,118,129,95,191,75,207,12,252,238,104,47,39,190,229,31,56,20,127,42,178,100,141,93,222,192,247,186,7,224,161,72,100,87,69,218,44,25,195,185,118,179,123,231,170,96,225,204,52,117,60,3,86,25,143,230,18,11,165,72,188,158,3,66,105,50,200,226,145,227,45,183,62,82,176,191,36,248,191,189,122,96,185,146,166,203,78,144,189,67,174,154,182,86,169,90,236,101,40,71,107,81,93,159,82,75,230,157,191,34,35,235,139,150,193,10,142,217,77,154,249,74,13,196,248,56,154,27,6,242,226,105,94,66,67,145,112,31,145,133,68,21,0,44,212,254,153,183,238,98,102,145,199,100,213,196,52,131,141,216,209,236,122,58,249,188,108,8,206,62,199,207,103,160,247,207,255,101,185,1,113,223,126,182,0,50,93,250,174,194,18,65,111,206,104,156,3,48,195,122,212,10,101,235,200,13,183,173,7,192,3,101,228,84,168,121,241,205,122,115,132,155,242,215,22,236,242,69,35,48,245,3,175,68,57,4,15,226,155,222,140,54,48,80,200,194,149,213,68,225,14,182,122,147,195,69,166,191,17,176,58,222,58,190,70,66,153,196,215,121,123,176,190,161,145,203,121,255,27,207,28,113,22,44,232,46,84,181,131,245,220,27,202,161,38,94,208,39,143,52,5,154,85,121,139,226,223,159,246,170,56,94,209,188,71,205,76,16,233,168,172,200,37,19,123,120,202,28,175,232,88,120,107,157,198,111,253,18,24,36,35,43,169,199,197,137,194,12,238,138,232,17,17,58,115,39,234,4,164,225,215,14,185,232,76,215,171,142,206,206,132,90,31,130,24,0,165,34,91,126,113,64,202,144,114,132,125,58,184,234,211,246,238,168,7,1,172,169,218,67,29,185,66,73,49,222,167,243,189,36,116,23,223,219,200,84,67,94,53,79,26,202,204,91,180,221,166,106,18,207,17,128,137,246,235,162,13,129,130,49,76,104,189,138,55,174,71,152,49,116,204,207,103,198,147,225,142,79,8,172,59,234,225,192,168,181,144,185,6,233,243,61,123,46,55,44,16,228,79,156,235,190,115,61,162,115,182,122,230,138,204,140,86,173,80,99,207,211,181,23,141,152,17,180,35,121,168,67,205,107,74,55,229,234,210,6,94,48,186,210,189,2,200,190,181,227,128,211,225,215,228,74,7,188,195,36,82,10,131,96,99,138,63,1,210,39,134,153,112,72,163,196,55,126,37,125,107,234,166,129,80,61,97,121,20,123,222,3,155,219,62,49,207,87,182,26,214,167,142,89,38,36,112,87,100,56,245,240,152,23,7,237,11,185,206,233,203,131,42,53,35,60,40,211,114,9,13,189,130,196,210,173,39,208,56,110,34,240,65,75,234,76,73,34,39,2,118,174,237,52,194,197,28,155,161,135,180,200,3,89,210,26,154,145,45,57,54,85,26,118,207,212,58,101,69,202,184,36,234,219,155,41,29,80,22,193,175,145,100,50,29,149,166,168,162,213,130,36,25,234,78,84,97,191,139,95,156,9,12,41,97,110,222,8,16,250,161,130,45,111,195,83,213,16,141,154,48,124,175,89,25,27,9,172,242,51,167,76,109,69,107,23,80,23,166,12,16,180,156,182,238,148,249,59,130,75,122,59,134,240,69,220,21,230,47,1,124,66,180,77,247,147,103,66,98,211,96,105,213,127,178,144,102,213,33,247,141,232,67,62,86,230,222,146,68,122,27,147,7,85,69,31,22,67,67,78,13,149,221,57,121,176,133,161,84,201,146,119,196,217,19,132,52,76,135,247,107,29,131,248,220,156,248,29,41,36,202,174,136,253,191,226,91,179,96,69,213,172,0,206,75,192,54,69,120,138,218,171,185,232,211,139,8,31,11,50,119,28,197,83,158,170,229,244,195,190,23,213,87,70,17,102,197,39,59,88,152,234,95,106,29,195,236,114,136,6,159,105,101,2,119,184,47,212,218,188,165,163,138,174,114,71,54,127,64,183,39,51,42,209,202,106,96,215,154,56,33,102,25,62,111,9,49,4,98,142,198,128,138,13,74,95,229,42,164,19,175,179,111,138,19,157,125,94,34,221,103,246,144,141,176,129,201,55,100,23,12,139,33,227,91,223,224,69,120,83,245,50,57,190,21,54,86,245,95,250,34,71,249,100,201,144,16,221,0,40,74,133,38,145,48,217,119,132,34,138,67,161,62,221,126,108,207,140,42,156,13,224,198,142,19,55,85,254,155,140,168,250,58,118,137,42,78,8,48,89,195,167,91,243,246,88,23,22,206,17,190,56,125,171,116,245,129,121,57,144,228,159,197,243,217,239,86,188,152,88,239,112,120,245,119,147,189,25,128,240,72,208,29,162,23,152,24,143,226,136,174,171,58,178,10,5,250,209,239,88,62,34,251,156,163,231,247,102,112,46,48,61,233,24,71,54,73,12,81,195,243,115,138,145,194,164,135,148,51,201,104,74,24,78,107,65,246,118,159,165,130,206,34,157,177,180,10,126,163,167,129,75,0,149,115,172,21,242,139,162,170,92,238,35,46,24,108,101,62,26,147,180,210,227,166,103,149,188,192,92,115,141,161,120,90,231,250,181,130,208,232,151,157,141,208,27,81,82,42,162,244,186,62,163,6,254,94,107,138,123,144,14,216,138,235,104,135,98,77,82,57,47,77,171,213,192,134,69,226,93,197,9,63,181,197,169,22,248,190,55,178,250,167,76,157,101,170,138,94,156,44,12,155,102,133,133,149,43,224,51,130,44,138,3,195,25,161,29,216,1,188,160,73,4,196,125,240,92,88,50,192,176,234,39,109,96,39,60,165,226,80,248,179,232,244,141,102,81,131,110,19,206,225,222,115,198,63,195,251,19,155,77,51,194,251,124,13,77,69,106,112,114,187,126,67,222,81,227,163,80,172,25,70,205,111,48,160,111,165,112,243,47,236,107,81,15,83,95,132,80,133,178,116,87,10,195,139,151,122,44,82,111,24,234,156,187,202,250,20,233,186,204,184,154,149,117,78,205,119,71,166,192,239,88,148,154,229,200,139,163,129,12,155,167,252,50,198,46,106,221,91,235,75,2,14,240,122,62,178,218,42,223,213,6,17,212,242,32,190,96,163,121,63,228,65,111,229,63,70,140,232,221,248,216,80,5,145,12,27,33,195,86,111,42,125,70,44,232,82,209,40,234,168,224,215,215,133,247,128,76,248,178,34,253,61,204,193,105,44,227,66,45,238,159,16,241,67,99,178,235,181,68,204,234,144,58,40,132,125,203,25,204,148,151,253,195,198,81,8,54,248,148,248,58,54,235,82,71,67,181,212,241,43,111,111,202,69,166,200,66,87,245,207,70,112,64,26,240,149,82,86,28,104,17,59,72,154,106,1,173,59,21,204,184,231,15,224,161,253,174,78,249,25,217,35,144,180,57,102,174,57,138,227,125,141,246,16,35,201,173,170,31,107,205,169,59,19,52,209,226,49,136,168,13,238,63,53,78,203,68,18,146,228,165,245,244,84,215,78,230,167,83,239,15,210,34,99,90,184,143,187,50,98,95,182,121,47,53,112,15,53,239,130,105,66,142,11,185,224,203,20,44,156,28,197,195,65,118,36,206,88,55,37,18,112,9,20,231,73,6,11,225,79,180,145,124,204,29,245,148,198,53,210,171,103,53,215,106,111,154,237,107,2,249,79,145,126,255,255,53,222,196,57,237,131,6,63,45,70,68,190,191,12,210,247,162,41,135,184,234,206,153,176,115,255,114,178,110,24,25,66,114,55,29,79,253,67,124,245,37,236,13,88,232,186,18,143,178,59,5,237,10,249,253,37,88,46,134,71,53,74,172,186,69,137,11,154,60,68,120,125,100,91,182,239,177,38,28,125,208,165,38,150,207,244,41,88,127,241,251,168,84,195,111,37,211,165,113,3,212,184,180,207,48,52,204,171,213,128,154,138,218,69,214,154,99,201,203,109,93,71,190,5,99,1,72,173,15,149,49,253,51,82,171,179,114,131,68,114,133,15,104,227,141,109,39,68,225,130,50,51,133,154,148,48,28,230,9,43,157,50,133,203,239,37,160,233,120,54,20,116,57,174,116,158,45,8,196,14,200,80,203,212,233,1,0,88,172,214,196,22,192,224,142,138,146,230,105,100,153,155,112,241,124,26,71,253,143,4,191,50,49,88,226,25,142,141,13,12,50,159,122,211,42,168,23,217,253,218,151,135,3,152,114,102,191,76,186,42,124,70,19,56,25,85,234,58,57,225,230,253,56,194,107,134,142,201,213,43,14,33,242,16,141,205,196,99,143,100,115,5,99,128,100,221,174,110,191,83,165,164,78,60,124,209,199,63,185,120,175,43,3,24,40,153,1,83,147,223,112,72,242,148,166,115,36,138,42,13,63,1,45,173,225,83,121,19,23,208,171,146,240,108,150,3,213,83,210,238,72,120,80,197,2,4,159,197,138,216,19,178,24,173,212,237,169,129,129,102,51,63,203,142,11,134,180,207,105,98,133,253,20,224,6,126,194,167,33,132,90,101,179,113,216,222,132,30,88,23,229,210,85,6,154,226,252,17,39,174,208,255,8,11,252,159,110,195,86,250,59,161,218,31,140,167,41,33,201,143,250,68,82,205,44,4,77,43,214,212,60,82,214,41,44,125,236,152,34,64,133,184,58,145,227,65,70,73,166,49,21,158,242,114,42,75,209,36,72,188,192,146,223,138,76,27,235,115,153,105,169,96,209,231,4,33,105,226,175,187,91,218,12,73,168,214,254,98,208,113,214,116,177,49,34,94,22,127,175,12,155,193,56,187,115,187,240,136,234,206,189,250,115,219,154,17,52,62,198,63,225,81,77,90,127,246,219,192,106,223,78,102,88,142,46,208,156,230,196,67,182,18,112,210,126,198,59,15,234,166,243,77,61,149,24,223,70,245,142,178,199,101,195,190,109,78,244,224,12,84,52,158,184,88,212,155,159,128,187,54,48,209,190,202,157,70,122,109,33,221,124,227,1,196,124,121,163,138,238,25,129,134,83,111,124,60,142,46,143,48,85,63,5,77,46,251,193,209,81,108,149,108,1,47,137,175,85,106,148,27,204,145,104,3,152,84,228,215,113,141,6,117,115,151,206,248,61,43,182,198,76,88,12,222,132,75,73,8,205,190,32,12,159,70,205,4,158,0,107,220,104,90,223,181,80,7,111,166,130,16,168,145,218,242,101,35,165,172,12,217,239,157,76,37,238,176,63,124,243,45,101,181,191,200,64,186,170,42,104,154,191,224,67,145,240,72,82,103,93,108,220,251,36,178,110,145,98,136,83,2,171,177,220,23,98,221,2,160,216,219,237,90,105,255,48,157,136,55,102,122,181,7,225,55,229,254,215,169,94,22,44,65,136,50,190,151,198,54,132,81,245,106,71,91,141,176,162,15,210,33,14,140,108,81,17,135,249,17,44,15,121,28,16,114,178,210,7,129,250,11,239,18,86,203,161,124,2,185,178,83,110,168,3,81,125,80,149,8,67,30,212,0,129,8,77,255,114,243,68,8,119,210,232,104,244,127,165,159,26,176,206,160,228,34,116,10,3,91,65,149,163,43,43,44,171,113,113,223,206,17,63,64,215,216,94,118,5,139,66,201,213,30,120,149,18,236,99,41,81,175,245,1,7,171,209,151,134,28,32,122,201,13,18,46,236,215,113,188,192,221,39,69,117,121,255,119,26,59,142,121,126,238,179,163,183,245,98,199,32,46,39,137,236,232,52,138,4,60,86,83,12,100,44,195,49,107,228,105,56,183,18,177,222,50,189,188,97,197,148,94,99,1,198,221,121,206,54,31,212,145,62,73,77,213,189,38,66,13,139,69,173,57,26,11,176,245,141,166,141,203,10,48,45,201,17,131,241,115,13,165,235,28,129,88,72,36,124,169,128,6,145,10,109,219,198,187,90,149,67,215,68,116,33,56,204,217,236,231,0,205,84,97,113,175,30,185,95,187,166,164,123,103,0,218,18,150,180,103,151,153,146,97,15,161,171,246,252,131,198,186,58,55,210,93,58,157,3,142,220,98,50,202,151,2,115,205,200,3,236,146,210,233,71,222,129,198,18,131,29,157,152,63,201,45,197,253,170,121,124,232,64,197,112,22,208,106,99,54,41,247,146,135,234,142,177,3,38,157,234,222,46,189,233,76,41,150,255,135,82,99,244,246,187,81,215,16,76,188,188,104,156,21,239,255,206,97,35,217,194,13,70,106,106,238,171,232,93,223,145,190,50,39,144,48,13,113,146,151,178,156,18,131,231,168,108,178,224,7,44,122,98,87,166,65,220,174,138,98,95,93,188,127,246,195,136,215,160,201,137,35,217,167,126,219,175,109,180,111,127,222,93,69,133,2,58,198,186,238,108,57,157,101,174,249,26,46,210,254,251,76,43,197,209,161,52,197,28,246,173,229,35,43,13,81,122,34,245,212,223,50,135,69,70,192,171,78,9,135,189,54,168,232,131,250,208,59,227,252,247,231,40,235,203,254,51,25,198,223,165,81,140,141,67,194,180,31,194,172,47,195,56,153,118,221,30,217,17,85,154,184,122,15,130,179,86,8,37,33,200,95,144,73,175,68,185,197,128,182,154,171,147,182,86,172,23,236,20,92,194,110,253,124,133,82,127,206,92,34,108,69,170,47,61,41,87,108,218,3,244,7,124,51,153,83,186,164,116,154,85,123,43,135,177,107,28,189,81,241,214,189,235,233,142,6,109,183,130,75,79,107,99,67,31,164,248,227,114,159,230,115,116,115,252,33,75,4,171,191,217,88,245,156,203,48,239,140,253,211,46,184,136,34,21,248,161,128,156,16,88,64,71,34,174,125,70,164,125,92,205,214,79,157,199,223,143,214,138,213,150,169,17,16,181,95,200,208,91,91,55,125,7,1,39,91,6,103,252,246,22,71,110,149,236,73,1,247,51,2,168,88,124,234,86,100,6,94,1,17,215,157,34,238,126,194,222,109,67,175,96,45,252,99,58,3,34,192,251,95,240,36,188,243,191,229,74,164,55,171,108,239,73,208,140,114,46,244,36,30,33,56,14,209,94,86,28,9,153,30,23,102,165,252,98,77,72,233,22,126,152,98,40,246,35,93,137,114,191,114,200,54,214,8,238,145,43,119,180,186,55,74,170,232,166,247,56,233,9,162,16,241,95,47,5,109,72,125,67,35,130,55,138,75,157,246,85,244,3,230,60,226,159,12,234,155,160,180,119,243,253,179,202,194,53,218,65,208,230,212,71,228,29,49,220,31,146,244,249,84,46,237,203,93,171,73,33,115,46,109,10,163,137,73,18,133,213,236,174,230,216,119,127,80,199,18,100,180,236,191,127,152,158,226,45,72,70,181,106,90,21,229,46,41,109,55,237,81,0,158,169,63,40,22,85,246,181,235,161,180,28,175,136,87,132,184,54,121,185,69,89,58,20,54,81,101,87,37,251,152,4,162,108,113,248,178,219,151,240,144,158,242,185,138,4,34,148,255,250,66,75,144,141,25,248,244,89,180,203,97,141,149,179,129,213,186,64,101,242,119,130,121,108,230,198,74,228,155,96,237,140,201,158,44,127,161,120,219,94,11,95,27,145,80,184,107,215,88,252,32,89,59,97,159,249,183,75,131,180,65,184,179,85,80,88,74,128,53,126,191,54,169,0,133,100,248,196,158,91,121,110,12,248,130,87,248,186,85,136,101,181,0,90,45,34,227,84,17,40,96,221,187,167,131,112,48,70,62,240,138,78,245,248,226,203,255,32,242,246,141,200,17,167,32,151,12,72,159,221,190,56,115,237,233,226,113,71,228,167,60,113,127,28,174,27,176,227,160,77,221,157,64,14,166,82,60,78,7,91,16,214,169,78,222,97,33,229,210,4,255,104,234,42,181,7,177,190,23,40,135,53,67,63,28,151,60,167,81,21,190,110,214,160,222,51,228,87,83,113,220,46,182,163,193,79,214,249,120,197,244,197,169,252,20,33,253,246,46,198,16,208,35,110,5,37,236,172,149,234,155,32,36,8,249,70,224,226,40,16,146,131,224,173,250,111,102,227,160,196,255,167,81,196,62,24,6,39,4,245,139,98,158,201,247,5,6,2,61,92,5,65,70,24,206,135,30,246,146,155,22,29,247,25,112,186,5,208,134,240,95,137,29,48,148,222,92,36,165,248,10,244,222,158,131,46,156,217,243,219,101,123,98,209,124,89,178,16,48,173,142,241,134,127,160,217,64,134,35,244,28,253,59,26,10,212,162,143,252,94,0,198,0,16,156,116,145,64,255,206,234,251,104,250,213,247,171,89,86,125,48,237,216,196,160,45,90,227,12,33,58,31,88,200,117,101,36,105,135,49,134,64,181,233,40,63,100,189,192,13,48,58,159,183,105,34,162,170,166,132,83,141,116,29,39,216,84,29,224,211,54,145,251,248,148,150,203,26,51,179,47,134,175,80,66,223,24,221,52,170,59,241,37,95,232,183,15,162,203,144,221,60,248,8,211,255,78,249,55,59,23,131,11,165,152,182,82,168,71,89,48,249,78,107,182,117,73,21,79,42,128,232,89,103,207,13,224,32,236,175,138,201,54,26,98,122,91,253,144,222,108,171,101,120,208,168,40,29,46,64,23,171,248,115,40,80,28,107,143,65,188,142,205,155,234,86,121,157,124,23,44,177,188,201,222,229,244,169,241,155,62,102,187,15,28,49,168,157,29,135,202,9,160,102,125,112,184,31,209,162,114,13,130,215,93,15,255,110,50,54,19,144,98,47,46,170,252,210,5,161,176,69,185,97,187,253,94,124,215,85,69,73,136,150,68,137,217,52,113,151,241,70,44,102,126,10,143,167,133,81,239,233,109,73,171,141,93,133,112,185,133,103,206,49,208,130,79,127,234,48,173,231,82,200,74,68,194,188,185,26,56,199,134,122,3,153,227,174,245,23,34,49,20,68,184,202,1,232,252,31,171,45,85,7,114,187,66,203,169,98,117,144,15,165,104,143,111,174,100,197,60,7,53,248,238,100,12,162,96,40,189,247,101,64,57,57,14,195,114,229,155,228,32,111,37,141,8,8,163,2,223,6,96,54,144,175,85,141,51,77,41,60,192,113,15,103,101,44,30,102,189,100,251,227,71,37,62,123,4,63,119,25,116,47,205,191,156,1,106,136,248,37,151,162,72,226,41,208,133,69,146,114,137,43,245,90,115,117,90,122,134,180,218,136,10,36,210,53,138,90,139,213,130,56,173,119,174,71,72,213,138,87,171,101,156,110,0,164,38,191,156,215,148,220,106,138,50,237,54,37,49,215,127,45,81,226,61,181,195,147,154,208,170,94,34,8,228,121,71,182,239,63,56,65,244,0,70,162,73,198,63,16,134,216,58,187,203,234,115,44,209,105,127,183,130,74,82,203,219,128,128,162,13,47,106,252,31,56,155,184,119,56,139,70,241,3,104,153,43,183,28,68,241,224,25,154,52,51,131,108,142,150,13,106,43,251,166,76,47,218,150,11,125,109,109,179,145,213,217,241,16,32,208,48,33,217,59,171,245,248,174,34,191,77,111,183,221,49,141,59,221,76,224,103,190,107,171,215,232,44,84,133,236,88,227,175,24,57,144,252,229,182,140,36,219,42,92,101,187,212,188,34,205,167,99,168,91,224,154,187,112,52,190,62,212,191,250,250,68,229,248,142,143,161,185,243,117,222,69,61,162,247,179,140,133,135,164,217,144,222,8,114,20,240,161,44,27,187,82,122,237,53,167,43,2,215,122,219,61,163,54,181,154,176,222,239,12,13,63,88,213,167,98,162,94,254,89,113,112,242,88,158,65,229,215,16,126,234,96,129,34,233,231,85,152,90,16,97,32,90,134,18,131,114,130,148,249,76,135,186,171,103,192,83,45,100,96,36,88,217,197,165,86,194,168,112,149,125,108,133,112,117,199,26,221,35,245,88,233,9,113,47,138,31,61,114,47,51,32,197,55,17,175,164,93,204,223,215,203,221,224,147,103,78,214,230,214,71,214,220,169,117,39,0,147,198,108,242,153,155,144,235,250,162,35,53,61,45,156,227,244,108,123,32,227,129,77,252,146,213,168,197,237,147,123,38,228,75,144,165,144,102,113,198,22,145,14,101,195,177,43,62,151,113,96,81,189,204,180,207,197,24,72,76,135,127,181,246,81,18,167,113,85,184,62,190,140,86,209,148,134,111,32,60,108,33,233,115,99,216,239,112,146,92,217,236,252,213,215,98,122,215,64,175,155,179,121,195,7,207,252,163,51,58,143,187,255,188,122,6,199,73,36,149,218,141,142,43,108,99,2,232,187,65,216,24,169,125,102,148,113,59,233,176,194,207,77,204,245,20,43,145,104,88,88,212,187,237,152,64,18,141,254,53,255,111,53,61,62,49,143,145,197,10,207,36,198,166,88,7,199,42,201,145,219,135,53,239,108,162,82,202,181,4,255,82,23,38,141,213,120,0,218,105,2,141,120,255,138,20,27,255,97,202,151,0,166,227,16,196,48,139,91,164,4,170,177,243,27,154,220,212,167,205,179,84,245,205,50,51,155,45,39,99,124,70,27,48,182,173,3,26,38,214,1,26,23,216,248,214,89,78,142,7,44,2,118,103,73,72,202,187,222,242,74,37,84,166,251,191,67,11,231,116,61,33,17,96,93,116,165,173,88,153,105,123,125,159,243,89,143,66,211,213,23,47,204,192,2,231,229,224,32,30,45,9,31,149,216,137,119,152,34,22,131,206,47,216,201,89,197,58,66,204,67,92,0,150,199,161,213,185,96,252,164,78,46,247,41,134,48,118,14,77,30,250,176,12,138,96,58,51,142,9,249,103,99,29,247,189,31,126,29,86,211,201,108,216,195,90,32,119,124,219,207,128,192,119,91,217,60,215,24,182,244,100,241,153,24,3,99,115,167,33,25,239,186,42,198,202,179,57,117,112,11,208,212,50,26,170,22,148,206,252,232,159,56,64,37,184,40,232,109,62,164,199,64,198,112,56,71,12,215,108,220,20,211,118,70,182,19,212,219,182,104,5,188,255,61,162,241,25,176,78,25,176,239,21,205,246,214,246,86,45,101,158,9,252,149,38,59,72,225,119,121,209,20,85,6,84,253,24,182,126,20,150,105,176,238,54,59,96,46,28,214,21,80,112,19,118,125,115,134,244,30,35,230,238,255,199,220,32,200,9,142,2,182,14,101,191,176,143,96,217,200,124,194,43,105,61,93,143,135,53,12,228,233,30,150,173,228,73,179,184,84,21,117,63,245,231,49,129,29,249,46,23,172,195,94,36,76,227,246,71,159,188,8,88,119,49,177,156,203,88,101,195,170,151,183,106,100,9,246,64,254,1,90,4,9,163,154,231,88,68,182,99,67,75,171,107,142,196,79,237,114,70,178,128,33,83,168,67,129,82,214,135,38,206,41,152,140,168,52,239,28,171,28,29,180,246,185,183,243,85,129,112,168,63,139,133,0,162,86,166,48,132,244,159,151,235,175,64,110,168,85,97,233,11,62,25,177,16,57,124,63,250,59,218,136,209,136,192,23,168,160,206,65,84,30,73,213,235,181,104,66,27,98,126,183,219,93,200,115,84,141,57,55,20,131,91,14,228,85,181,19,4,110,176,90,101,40,91,107,155,7,70,21,114,154,141,146,125,246,64,1,216,213,232,23,143,224,115,244,247,144,186,71,134,69,183,141,25,186,91,29,145,163,250,202,181,57,216,172,131,228,242,181,187,52,94,218,252,4,118,44,52,124,160,37,176,17,218,121,140,191,107,102,91,222,49,91,229,106,179,221,170,200,88,38,138,167,10,48,157,47,99,57,137,88,76,206,141,214,208,48,80,226,18,227,6,175,180,63,107,247,251,197,59,51,247,13,109,209,162,206,192,125,112,94,235,247,26,88,14,126,241,225,249,81,162,7,157,238,150,138,24,69,121,155,219,17,169,180,218,93,230,99,92,139,53,179,145,30,14,205,171,75,247,49,194,3,14,177,24,222,122,30,75,174,121,243,104,233,244,81,4,47,70,43,206,113,229,119,231,49,72,144,78,214,29,193,41,75,14,97,19,84,148,246,3,250,243,7,246,233,153,48,135,226,204,199,93,210,3,97,11,106,117,170,122,92,97,150,179,177,220,46,59,17,151,242,160,233,237,81,78,255,87,243,237,113,135,216,131,97,197,224,41,142,85,234,243,135,58,152,220,191,227,149,78,77,30,82,167,63,217,43,227,106,173,223,128,161,49,70,29,184,169,178,179,124,224,2,243,210,229,112,103,15,29,78,229,91,9,68,198,94,135,241,207,69,183,229,46,78,63,189,93,163,10,91,172,13,205,180,217,216,102,237,239,3,217,247,218,0,147,130,158,175,242,39,94,23,238,221,229,211,72,140,103,207,7,73,10,200,247,155,254,35,165,152,2,137,237,154,128,235,215,210,1,132,104,143,128,91,191,225,241,171,220,16,165,209,59,10,1,128,151,229,116,17,20,188,108,57,196,105,197,5,64,216,75,255,49,10,35,243,39,238,142,201,1,32,8,28,116,21,216,226,89,90,231,210,128,81,149,93,249,111,150,128,11,228,231,236,178,74,34,174,187,230,84,78,197,136,17,197,25,242,154,123,24,78,245,178,254,76,70,182,72,15,115,54,62,10,89,172,129,113,97,148,204,240,100,172,169,122,13,95,182,26,184,25,191,255,250,250,137,18,19,72,145,135,112,125,227,63,65,26,54,228,181,30,158,27,191,9,236,168,115,248,144,187,132,253,45,84,154,196,103,30,149,123,53,42,206,172,146,175,44,203,69,239,45,147,0,121,103,125,132,136,192,38,62,79,29,241,17,151,110,28,38,221,234,230,228,182,64,241,144,165,124,145,120,49,50,129,18,33,242,212,143,68,167,109,134,179,113,176,85,93,87,105,133,15,66,249,8,43,9,147,72,30,6,2,85,185,204,160,20,76,70,119,163,67,200,121,228,185,204,22,48,31,122,177,123,93,159,108,114,65,90,91,67,95,139,6,187,3,78,142,38,96,61,68,23,146,93,32,245,153,131,61,126,1,194,201,158,51,161,172,0,176,76,143,229,81,201,36,157,210,139,109,215,12,9,41,152,243,188,240,144,194,27,114,193,162,39,43,9,203,46,137,76,217,93,125,215,74,43,75,0,153,246,95,88,44,134,248,43,87,166,46,133,1,77,197,205,206,31,50,102,178,248,22,226,192,156,203,195,155,193,32,35,158,173,76,75,79,240,112,7,161,130,162,85,225,67,223,15,127,53,24,49,231,201,248,16,114,146,228,17,178,247,166,162,2,32,180,41,188,9,197,103,77,246,35,30,71,112,6,222,168,64,60,248,242,61,201,130,219,58,182,38,143,103,45,104,219,7,121,119,138,183,148,149,107,216,169,2,89,111,185,120,49,74,173,174,35,38,194,214,86,32,216,229,123,41,64,108,178,152,13,174,71,86,192,147,84,112,246,98,151,238,63,210,134,112,5,28,254,154,125,236,82,78,22,114,230,212,88,97,54,211,70,203,48,159,59,21,36,55,56,141,194,247,133,160,138,224,66,180,74,137,37,94,5,120,135,170,119,209,147,221,28,19,215,139,29,199,87,234,102,225,111,74,180,27,169,131,129,29,44,138,81,235,206,181,229,133,192,201,163,110,48,203,245,95,200,183,29,29,31,255,74,216,148,92,109,191,130,29,236,248,204,126,228,208,76,200,13,128,197,198,255,211,23,197,132,124,133,71,155,21,132,233,191,189,212,255,108,47,94,109,53,232,234,95,174,83,223,18,188,255,239,215,139,141,51,127,243,199,103,111,117,45,101,67,184,104,196,20,34,25,184,251,144,47,226,217,214,217,125,47,52,41,242,113,104,13,56,74,44,166,36,63,154,133,145,18,80,160,124,59,47,48,219,63,43,134,67,115,238,189,252,67,6,164,83,181,123,230,213,252,7,222,130,221,30,79,68,34,162,2,61,134,162,207,49,146,161,216,82,98,181,190,57,57,164,128,97,121,148,131,128,152,66,106,247,15,154,148,82,42,174,142,17,249,123,23,138,78,106,245,159,202,19,26,160,50,138,153,136,182,101,89,247,195,169,69,220,50,155,45,140,251,248,183,139,84,17,44,98,83,13,102,234,106,135,22,255,212,246,163,28,11,251,123,18,5,150,221,6,2,137,17,176,56,215,12,166,187,52,149,11,97,119,140,245,13,201,20,98,80,27,26,125,126,58,232,231,83,52,195,75,116,248,147,230,123,171,77,81,168,163,120,39,158,18,54,60,212,117,67,148,122,151,78,51,30,88,27,152,83,92,191,105,162,106,233,12,27,116,4,53,100,189,242,253,169,182,10,105,196,84,229,122,141,80,15,0,38,26,50,176,229,18,32,169,241,202,190,190,225,100,193,44,196,209,193,83,89,43,228,8,127,48,9,221,186,199,251,97,138,218,190,131,202,206,62,148,128,44,48,107,164,177,57,149,171,214,244,57,198,194,87,179,232,10,17,65,243,255,109,19,208,42,55,68,178,164,84,21,57,206,5,27,252,203,144,108,90,231,137,198,221,204,164,204,56,73,223,129,127,246,244,144,140,13,229,195,199,39,42,93,103,202,8,45,68,203,17,186,154,9,154,228,59,255,134,120,125,170,90,18,141,31,17,116,10,189,48,63,147,112,188,11,184,92,95,253,180,92,80,106,57,112,187,229,228,69,3,1,47,47,72,146,48,135,37,111,82,27,20,77,157,222,115,123,120,119,159,196,99,7,116,57,222,119,79,79,212,213,215,145,225,154,187,25,22,126,89,170,169,123,159,94,29,177,63,137,207,167,192,97,134,193,17,236,199,8,35,214,220,156,72,183,180,8,63,200,171,93,216,103,110,145,159,209,158,236,233,50,228,220,144,113,159,214,222,157,156,27,133,183,240,127,191,28,41,222,148,155,247,32,97,96,128,237,98,236,159,107,157,192,176,19,81,248,145,219,183,179,73,178,81,38,137,81,108,189,148,180,164,63,244,107,140,13,253,2,84,88,16,121,200,120,77,203,104,24,207,202,194,62,253,155,102,96,168,116,28,237,163,138,91,149,34,82,230,211,109,230,176,130,28,82,186,233,159,99,238,249,81,38,106,243,246,4,63,80,43,104,47,1,253,236,84,79,158,5,81,26,18,242,70,42,11,229,216,154,236,16,203,159,227,7,207,120,26,197,81,87,177,4,32,197,147,111,255,229,91,211,194,195,230,35,169,151,31,196,33,181,120,192,254,71,84,152,228,208,209,129,98,55,39,210,144,146,192,231,249,121,170,81,218,202,197,150,149,234,93,90,178,167,209,244,86,25,140,141,156,206,14,247,240,217,14,39,99,82,121,16,119,157,210,169,220,50,58,255,48,130,189,120,154,59,60,85,94,135,23,15,171,6,31,212,224,89,73,100,179,91,61,170,128,28,33,227,9,149,128,12,110,120,44,9,52,192,4,24,65,221,114,24,77,109,0,237,94,4,42,232,84,150,134,32,50,33,84,234,130,136,89,117,253,79,60,135,69,29,50,128,196,38,41,43,37,78,168,73,163,249,45,207,177,76,38,115,76,143,118,145,106,166,6,142,230,193,147,145,87,195,222,73,219,219,89,33,68,237,118,120,146,164,74,130,237,16,47,79,228,9,153,184,5,127,80,182,81,105,196,51,244,192,237,160,118,200,191,94,235,152,191,202,161,231,171,19,116,102,94,206,253,175,4,193,18,70,53,214,98,123,181,137,167,190,84,96,169,2,204,232,54,221,169,175,186,172,137,170,75,32,249,57,119,86,19,52,123,234,142,11,108,19,58,84,98,250,242,114,170,31,205,195,117,12,243,41,93,222,0,101,219,102,129,196,192,91,8,186,233,243,37,194,183,162,121,59,93,71,52,178,114,96,72,252,185,254,109,31,107,112,168,64,226,160,216,43,49,74,50,139,112,148,135,148,88,184,35,26,29,171,245,47,96,61,39,146,159,194,252,57,202,244,245,218,216,18,29,71,237,39,25,197,164,184,67,97,53,45,16,218,207,244,97,249,96,167,93,62,103,162,164,67,186,159,2,26,136,32,184,9,167,169,183,210,72,43,253,167,72,211,171,205,117,92,82,32,5,197,107,8,68,106,237,8,142,148,101,227,90,210,67,13,252,233,3,242,79,95,172,175,195,246,251,254,247,71,7,224,252,37,255,4,158,178,131,23,77,77,22,178,114,155,151,162,207,53,98,63,132,143,232,73,194,185,91,243,57,47,83,36,154,42,31,150,56,15,33,40,14,111,70,137,225,158,138,108,119,114,255,48,176,231,182,51,219,163,86,122,80,104,197,169,107,181,97,55,228,63,47,73,106,27,23,65,207,177,34,218,221,147,192,237,165,74,89,152,255,181,169,250,226,99,10,232,6,181,45,3,222,174,26,248,155,12,199,237,65,205,85,22,125,164,146,124,17,73,140,71,36,57,173,173,157,157,161,35,164,157,190,71,67,29,142,133,206,231,64,185,95,111,65,166,220,233,245,73,242,25,16,29,223,124,142,199,177,13,24,198,245,218,190,115,38,32,45,236,12,96,101,63,17,230,151,217,117,234,153,112,111,91,162,196,247,185,166,60,2,8,145,56,160,48,175,226,250,67,51,132,106,42,213,138,119,167,9,240,25,8,56,22,165,218,9,62,218,121,29,43,177,130,210,166,150,15,220,225,225,152,34,255,104,115,223,108,131,55,250,255,49,92,130,20,179,218,73,38,116,122,102,17,118,237,183,109,65,232,122,235,4,68,3,245,160,150,224,73,183,115,6,100,124,166,210,201,82,249,142,15,23,20,60,118,137,170,181,229,205,108,201,240,169,87,195,99,76,138,15,228,158,47,216,146,8,248,175,110,207,39,94,180,173,250,47,24,2,201,150,241,233,238,16,120,75,140,84,49,212,106,98,213,162,86,181,76,170,35,124,116,48,164,197,74,131,117,229,28,19,139,154,0,123,202,110,178,10,79,113,166,22,172,117,191,54,48,27,183,59,223,105,57,148,54,241,188,72,118,58,255,33,235,238,206,33,254,197,162,45,154,226,221,57,145,225,19,36,11,164,245,79,188,132,50,190,248,255,75,183,214,242,69,109,232,147,130,166,70,86,58,124,161,96,88,92,166,32,184,117,117,232,148,14,163,81,163,242,0,239,41,82,240,105,189,74,68,200,164,195,85,62,74,56,226,196,41,2,105,154,95,205,207,232,106,98,226,99,112,210,188,162,203,188,28,65,78,18,252,134,93,120,74,188,64,154,12,133,146,228,14,25,9,13,157,22,83,145,169,201,189,221,137,49,232,138,179,182,165,146,2,109,172,21,172,40,157,230,199,70,170,17,231,133,250,192,45,75,214,33,111,3,120,209,54,12,206,159,226,150,136,96,94,25,66,56,178,106,7,73,214,104,156,236,28,249,93,15,229,9,0,132,16,69,155,125,179,207,94,14,13,244,207,241,54,32,52,63,98,162,154,191,75,209,229,33,193,255,57,31,229,86,153,43,207,166,165,245,54,40,212,29,222,70,136,130,40,74,185,218,104,130,108,129,245,188,86,215,76,131,33,190,168,234,99,175,11,251,216,73,187,108,44,255,201,238,119,247,44,86,81,235,45,3,57,216,75,34,73,180,36,35,240,164,214,36,117,135,41,119,211,38,76,81,196,8,21,97,136,235,119,71,123,36,176,199,227,228,108,128,149,137,5,164,77,148,159,81,47,176,108,234,54,46,235,56,167,178,84,254,105,129,190,49,65,57,236,213,149,152,10,85,206,195,221,92,221,54,74,114,134,198,83,208,132,62,75,99,76,23,147,221,170,238,47,2,231,238,159,31,157,21,230,120,116,37,205,171,183,193,105,172,143,117,1,93,76,23,54,218,89,41,8,34,70,14,172,247,13,165,93,149,104,106,13,209,88,202,31,127,1,56,213,196,57,128,219,160,128,36,102,11,50,241,144,120,109,249,181,6,101,158,193,159,198,121,72,53,117,201,226,238,36,19,89,190,170,97,242,166,133,255,187,116,117,149,110,240,34,46,115,10,173,23,253,193,26,88,218,204,250,37,212,109,250,201,191,194,118,95,136,247,161,207,241,204,135,2,78,149,74,112,131,147,47,174,61,6,17,165,170,245,205,230,27,4,219,42,253,132,224,5,105,216,149,164,189,139,111,218,70,124,62,36,131,167,58,160,166,166,15,182,6,55,43,51,18,46,56,174,90,10,0,14,29,74,85,33,208,147,69,176,90,198,106,36,37,30,25,35,124,178,130,4,84,25,198,20,229,53,83,27,191,7,155,221,115,87,5,220,83,80,84,102,251,48,221,102,199,149,98,72,199,4,97,43,61,78,97,140,141,115,8,36,76,209,170,73,151,35,27,50,135,70,240,173,0,121,54,23,163,78,109,212,129,93,171,216,134,28,83,113,141,233,192,101,187,144,201,55,84,241,226,162,50,111,152,243,114,9,111,93,4,89,234,55,65,28,241,78,143,188,189,252,70,80,238,69,204,212,181,122,171,109,189,186,144,136,240,116,95,234,155,53,70,170,203,113,36,46,45,134,195,163,140,104,104,25,181,136,167,116,55,237,25,77,120,91,44,239,159,52,190,41,227,220,175,171,101,213,127,105,222,163,58,68,40,210,118,247,1,76,42,20,189,248,76,43,113,25,81,37,26,154,234,25,226,251,39,69,143,3,138,235,220,47,9,31,25,63,195,193,72,173,92,80,43,152,143,80,74,126,49,33,238,113,228,171,168,241,82,49,174,116,73,94,130,72,230,253,161,187,183,237,195,41,153,143,130,252,152,169,147,185,106,2,207,13,134,90,175,141,157,242,255,161,154,42,107,178,145,195,16,211,119,181,175,211,84,142,39,77,187,239,159,12,177,186,243,150,95,140,58,167,52,103,146,158,98,247,173,141,219,214,180,87,55,184,155,216,203,67,81,243,45,171,219,220,110,144,106,5,138,225,212,232,110,202,220,68,84,250,115,120,118,200,167,154,108,73,90,190,72,34,47,249,229,114,4,80,142,144,22,68,254,128,128,196,171,194,100,131,176,168,30,203,107,42,65,59,156,176,21,156,53,86,125,203,58,216,87,127,233,238,153,162,195,175,35,133,212,69,25,61,96,246,99,19,132,120,219,58,140,93,223,248,9,43,246,147,166,10,33,40,237,26,6,87,228,81,182,159,34,234,48,74,27,30,186,36,136,63,92,110,3,131,130,27,239,155,0,156,219,146,232,148,189,133,204,227,35,102,6,13,242,251,69,127,251,171,127,248,242,116,126,174,84,115,6,193,135,29,128,225,230,162,23,222,79,106,4,26,156,61,251,88,57,81,76,237,7,19,107,37,95,147,230,99,193,76,98,87,252,124,217,105,200,201,204,245,189,226,154,95,54,19,34,64,85,66,163,243,6,203,46,201,0,174,183,154,181,226,46,152,199,255,75,54,243,29,83,133,231,240,6,21,38,68,184,253,109,54,23,224,31,102,11,112,103,43,17,38,125,238,71,104,161,159,219,136,215,196,141,170,10,56,156,93,207,152,188,114,22,157,0,165,25,138,205,58,248,67,193,58,28,147,32,38,229,221,175,114,14,42,161,2,223,231,204,164,6,92,49,52,64,37,164,223,252,197,118,55,243,108,10,158,239,219,175,244,102,22,194,134,212,9,249,244,43,86,97,41,53,9,224,110,61,250,140,202,187,95,171,204,21,221,58,141,24,176,120,96,194,232,84,28,125,246,218,142,73,131,254,249,22,179,71,110,208,97,247,139,162,171,64,251,79,190,180,190,186,29,110,165,88,119,225,30,58,64,49,68,45,83,93,122,136,199,146,158,106,5,211,222,64,64,160,74,72,185,138,112,186,135,133,95,31,236,77,86,54,59,235,32,245,245,133,152,27,233,115,154,253,233,222,36,218,216,218,211,137,127,103,199,95,165,151,234,33,228,72,167,103,13,43,119,38,71,23,218,227,177,230,222,214,149,81,102,246,94,251,84,233,90,116,77,26,118,194,122,55,75,208,137,52,159,238,73,8,33,157,218,178,213,108,45,131,207,210,31,144,133,204,239,144,183,230,251,195,57,195,154,39,61,36,39,117,126,121,69,224,198,15,198,98,59,82,181,202,28,149,49,219,53,48,163,19,164,57,251,219,61,159,235,12,121,100,151,160,191,93,194,90,22,119,28,191,219,210,170,234,145,2,111,53,86,140,171,46,232,231,111,18,43,83,2,142,131,38,36,99,174,3,26,169,105,31,214,250,212,191,8,1,141,69,73,158,180,248,93,117,146,242,10,188,63,7,61,149,69,118,161,141,117,25,193,18,187,220,194,82,13,30,5,225,194,158,252,56,159,129,5,240,0,213,85,67,54,209,242,151,41,141,172,187,12,215,255,6,5,126,185,11,225,35,202,5,182,98,154,26,217,237,193,140,136,38,71,118,166,44,17,223,179,101,97,16,153,33,21,204,15,219,189,120,219,24,117,23,4,153,22,143,40,174,238,185,27,159,69,251,1,227,108,218,69,111,198,184,236,14,216,136,208,115,154,211,47,149,116,98,114,40,90,83,116,92,109,38,134,140,104,157,197,116,57,122,111,5,224,4,175,201,244,62,210,203,188,216,230,131,214,184,164,54,48,242,179,251,201,77,16,77,13,77,23,34,66,146,24,12,187,238,151,92,139,64,114,217,125,244,175,10,155,138,118,58,245,52,121,17,241,62,231,105,214,169,120,184,4,155,16,20,12,215,206,40,237,161,186,68,63,141,166,178,6,127,126,151,70,195,245,163,96,91,23,138,173,211,99,103,164,14,51,246,20,75,76,135,150,74,215,220,71,15,76,77,215,250,38,227,176,76,17,15,179,232,18,19,165,54,194,146,187,110,158,216,55,66,145,232,119,152,61,63,121,155,194,202,244,22,81,66,36,140,38,108,209,21,139,25,159,255,185,60,117,9,245,95,46,99,220,27,61,151,235,253,38,161,64,188,88,189,117,249,42,176,56,54,107,62,80,240,135,153,86,180,137,121,111,177,208,196,3,194,236,106,173,82,40,195,1,146,180,204,141,11,192,120,252,52,4,116,199,14,254,104,216,4,219,7,221,233,33,47,34,247,94,0,104,240,54,18,128,85,240,255,179,195,197,161,240,178,242,197,103,68,166,60,95,131,245,148,198,163,124,209,39,120,42,206,15,106,91,118,113,89,19,66,66,241,200,64,65,37,82,169,139,136,203,234,192,172,175,27,160,244,10,91,4,183,109,177,183,93,233,92,26,227,67,87,232,184,97,234,202,240,80,213,42,133,15,68,206,0,206,110,170,227,223,113,90,208,60,11,93,245,151,50,51,86,152,199,229,35,248,13,119,64,238,165,152,108,70,48,149,157,110,249,189,25,187,246,251,124,64,0,176,165,128,174,39,200,94,100,193,34,233,19,192,83,39,177,228,74,234,195,128,251,203,238,192,16,66,200,223,179,30,106,195,189,26,217,157,142,161,132,38,20,179,217,79,34,97,189,231,106,19,144,223,172,39,206,91,192,115,254,111,141,170,103,121,61,72,101,60,110,173,73,193,25,89,206,122,137,151,213,60,169,7,42,226,224,249,190,43,17,190,187,240,163,77,26,192,162,70,170,154,216,20,183,212,229,81,56,157,247,123,219,168,91,21,53,107,174,135,98,32,176,146,78,98,190,30,232,190,171,107,188,254,223,5,25,58,134,150,36,28,218,134,107,40,253,245,199,11,1,191,26,173,238,5,142,204,170,161,157,127,172,254,27,185,235,87,15,3,74,170,36,195,132,163,3,126,33,178,173,141,106,23,111,96,111,124,164,68,230,2,210,18,190,148,45,70,148,194,38,160,67,130,166,172,81,5,91,142,239,190,58,3,102,81,212,68,68,73,134,6,117,116,100,47,57,100,207,232,224,125,32,30,193,162,117,36,57,8,27,203,56,199,110,251,56,35,162,240,157,224,0,42,206,199,201,33,95,5,127,132,29,178,152,101,166,1,242,99,155,248,47,71,180,75,84,99,65,91,32,31,136,206,52,48,74,184,208,83,85,179,51,105,125,87,66,145,207,127,71,239,255,157,126,120,139,232,35,64,70,128,118,191,41,217,7,185,86,117,216,187,163,194,206,174,218,56,214,58,160,248,111,154,70,17,108,212,91,199,245,32,108,125,43,198,192,38,68,101,100,147,129,87,52,240,50,91,92,218,108,127,101,155,228,123,77,147,41,86,207,159,139,140,93,22,169,163,63,89,236,154,98,131,93,39,55,237,122,107,6,174,184,202,126,27,199,141,16,52,167,250,44,52,64,134,244,66,235,39,127,190,88,127,61,105,107,157,35,59,146,10,14,155,241,227,170,104,180,47,95,20,235,236,196,100,29,66,255,252,236,249,128,214,5,234,40,241,34,234,45,47,166,217,121,36,243,35,251,23,126,3,133,136,164,113,22,69,236,180,239,139,48,255,146,161,48,135,129,150,245,193,181,210,85,120,4,249,147,174,66,17,136,154,208,148,214,82,198,29,171,4,223,212,84,104,93,95,153,151,59,52,212,150,113,85,179,189,60,151,118,28,93,220,49,114,124,228,164,99,165,40,1,5,200,121,138,132,77,15,5,21,162,216,252,37,141,224,202,125,209,225,242,62,177,195,93,254,238,77,226,148,168,119,167,195,151,180,25,60,215,48,166,94,44,45,114,159,78,24,155,132,119,38,31,231,227,51,37,35,33,239,40,171,12,250,68,190,248,231,228,59,213,61,15,65,53,179,92,176,23,172,176,32,72,135,37,241,24,107,242,184,186,57,99,239,241,14,0,114,211,202,79,176,88,52,130,56,18,75,55,22,208,79,100,1,57,105,53,174,100,13,234,232,158,118,211,9,144,128,160,76,177,166,10,90,95,110,144,254,243,190,208,135,184,198,226,200,27,9,38,241,0,208,210,237,180,2,22,149,157,19,155,249,21,3,55,195,149,105,206,24,110,148,19,249,58,78,186,176,25,100,216,4,198,194,104,71,150,103,193,54,223,28,146,80,51,157,194,14,178,180,189,161,192,44,225,168,111,47,225,151,43,100,26,191,125,146,222,221,199,216,186,126,173,89,90,229,77,60,34,228,75,219,182,85,232,170,22,24,130,197,101,20,253,116,141,176,241,34,223,208,190,53,49,201,93,144,151,241,108,236,120,86,232,128,234,238,83,111,80,172,96,67,34,128,6,29,10,136,122,7,204,83,50,186,1,23,79,169,21,92,114,15,132,236,51,188,123,139,240,236,199,67,208,132,52,13,194,187,174,29,120,140,151,198,252,88,147,102,219,35,162,73,126,98,77,213,8,169,217,193,210,100,239,19,153,49,43,252,194,75,228,65,143,184,39,77,42,202,171,40,113,137,164,157,33,120,131,63,197,218,5,250,238,192,175,128,92,206,161,173,254,238,133,100,158,136,16,101,127,238,52,208,92,82,3,217,66,93,246,228,193,254,74,72,78,122,33,105,54,8,66,93,246,194,222,27,194,33,125,31,125,186,243,13,92,218,44,36,132,226,180,89,124,205,104,135,159,122,252,15,162,223,62,10,250,171,0,131,127,85,178,231,79,207,40,253,46,196,118,242,128,72,35,191,117,82,21,59,50,253,123,77,220,143,104,20,203,224,176,13,252,32,28,67,43,91,75,244,94,186,135,19,180,199,223,127,142,98,37,239,28,103,87,65,235,18,238,103,120,238,30,86,59,98,172,2,220,161,99,43,3,209,122,161,55,146,255,1,36,249,99,184,3,3,168,72,232,46,73,223,106,79,159,210,38,156,147,51,126,50,165,108,52,49,96,42,238,80,99,70,146,206,224,54,97,97,16,213,14,248,251,126,49,66,87,134,179,227,232,143,91,185,125,0,158,183,5,242,48,7,152,160,171,198,163,34,181,199,170,68,125,93,97,109,136,230,150,33,113,56,104,7,226,175,49,100,51,84,213,22,135,7,237,200,148,72,116,142,163,153,122,86,4,164,15,210,118,24,67,210,223,220,137,144,48,144,180,185,234,2,241,154,213,43,109,156,143,172,26,128,135,231,119,24,217,131,61,148,77,141,150,92,115,120,2,154,217,75,86,241,208,171,108,103,82,89,209,129,238,172,132,255,207,27,146,164,74,184,68,92,141,13,124,214,138,185,244,149,236,189,182,103,67,87,10,32,216,220,143,80,210,206,245,104,149,139,20,55,5,113,172,207,125,29,89,249,19,112,108,14,88,182,201,165,18,10,245,121,6,178,148,34,12,59,196,61,173,239,178,241,33,155,25,242,134,32,227,233,188,135,113,163,52,64,251,178,224,118,246,79,167,5,63,212,177,112,180,80,242,169,49,210,21,134,141,17,157,190,91,64,227,91,38,133,159,225,105,247,226,195,200,172,31,220,215,170,68,107,20,234,183,178,143,56,158,107,86,223,172,215,193,84,10,65,89,99,158,61,203,224,96,108,213,54,164,149,13,125,118,120,95,189,114,57,41,211,241,237,209,190,6,62,79,184,242,245,149,195,91,85,198,131,178,227,71,202,112,154,51,82,29,130,223,121,113,6,199,251,129,30,201,68,187,181,197,35,52,79,104,12,235,40,127,72,62,197,101,25,50,235,135,22,61,18,204,9,17,58,139,193,112,118,161,34,157,65,113,190,135,176,140,117,20,216,176,111,50,116,217,162,214,180,80,45,31,21,53,93,2,228,123,100,207,17,230,207,97,240,183,85,31,41,46,45,3,43,72,155,187,165,203,128,67,28,120,236,54,20,65,238,109,110,179,222,136,198,17,77,149,130,251,103,177,204,150,184,189,37,5,55,241,217,14,130,255,116,126,175,235,144,116,140,66,14,51,205,67,99,220,51,208,79,206,154,127,22,85,71,77,215,145,255,44,243,64,209,227,67,73,110,151,218,87,197,55,237,118,245,39,169,244,170,245,203,108,245,142,50,189,176,80,21,202,93,146,1,53,148,177,158,56,213,31,235,149,163,76,7,160,96,185,175,209,247,27,135,158,217,147,16,10,240,197,137,20,206,239,82,56,27,22,220,198,2,89,79,127,31,142,1,6,55,182,200,142,137,107,201,174,111,181,210,207,62,30,104,243,208,79,121,233,86,23,51,192,246,38,237,63,185,68,166,75,123,229,116,251,234,207,59,122,231,68,113,211,62,70,25,143,151,209,232,208,160,147,131,216,54,242,90,239,63,40,144,174,63,16,36,202,26,114,183,89,217,89,136,230,91,48,252,125,202,164,150,89,145,56,123,247,12,54,155,187,186,61,40,196,208,28,136,119,101,36,210,226,52,175,235,200,109,39,72,109,208,243,138,191,212,112,241,255,140,84,135,41,149,18,74,71,117,169,225,47,36,251,47,104,143,61,234,88,50,148,255,119,218,157,33,205,193,198,233,229,11,62,162,92,119,220,137,255,123,184,226,35,157,8,174,39,63,216,248,137,225,131,8,2,82,204,80,214,39,91,209,189,161,6,81,144,36,198,76,197,109,194,10,4,72,54,53,184,115,91,225,10,11,168,200,46,218,124,246,135,15,89,53,166,8,241,71,83,123,154,209,50,174,37,55,123,83,140,20,54,44,56,182,163,26,6,6,190,38,53,147,232,222,149,68,107,255,157,252,151,137,92,252,145,148,33,103,9,72,231,13,116,195,38,2,23,236,159,143,19,6,218,213,124,179,244,182,30,110,173,19,168,90,131,57,252,205,106,250,34,115,21,156,227,2,178,233,51,164,166,165,72,112,14,41,93,38,111,111,37,191,106,207,33,185,185,90,72,233,134,236,98,171,160,112,169,40,190,94,93,171,234,98,137,93,127,65,248,80,186,131,116,191,197,63,31,50,255,195,58,34,142,54,220,246,198,63,55,183,44,126,0,217,209,232,158,8,7,110,86,107,240,61,28,52,138,97,149,20,247,180,192,143,33,83,155,177,22,187,216,48,139,83,169,139,99,123,154,74,125,236,38,59,46,27,30,157,211,15,232,203,47,94,136,56,194,51,139,205,174,21,161,217,7,160,227,59,236,156,91,143,154,27,42,117,22,168,18,246,201,35,37,107,157,58,5,158,76,100,112,62,84,117,50,22,6,96,111,120,207,116,151,161,13,67,239,116,206,98,64,136,103,8,201,197,9,81,239,18,226,93,190,46,81,229,232,167,200,193,215,90,182,212,93,78,67,26,105,97,197,49,164,150,52,143,248,121,13,95,217,227,206,14,80,200,179,171,10,146,200,142,90,137,125,253,146,71,131,33,45,48,69,241,119,153,254,188,241,25,222,97,30,63,46,136,159,57,134,89,0,129,234,189,184,64,200,208,245,48,167,116,134,99,230,3,164,217,19,159,106,99,97,202,22,164,70,66,13,97,32,58,239,114,37,9,60,59,67,157,37,172,251,50,177,13,116,63,7,119,74,90,248,108,175,187,95,134,112,101,157,132,160,143,70,245,232,144,69,184,106,150,9,184,122,224,32,162,162,167,166,203,10,237,99,78,75,217,159,250,237,184,75,97,163,68,55,215,93,14,236,225,12,141,49,8,40,126,117,77,135,80,77,205,97,75,21,26,145,221,123,172,2,182,77,86,93,204,86,114,144,92,13,141,25,97,222,15,100,182,160,159,142,35,220,49,107,187,208,137,105,153,135,0,174,222,172,239,170,133,207,178,208,164,230,211,2,139,92,32,192,133,89,232,32,239,245,110,166,136,37,21,196,131,79,242,98,209,25,180,252,102,119,100,85,102,115,189,106,122,226,157,178,221,143,154,92,187,57,68,241,18,33,225,250,134,114,116,72,134,250,27,40,97,219,30,86,74,184,102,193,26,66,181,24,165,153,255,190,75,185,18,121,114,85,220,59,224,145,174,176,36,67,144,74,196,161,88,9,48,79,220,4,67,25,232,105,176,32,242,28,201,66,116,178,36,164,218,208,31,240,68,239,166,138,242,198,226,27,136,232,255,174,210,152,60,200,61,15,238,2,218,231,198,130,236,180,235,65,221,66,82,162,92,235,251,20,38,65,92,156,106,85,0,144,25,182,28,226,88,153,34,253,19,27,116,90,101,248,35,202,216,184,19,35,2,94,8,209,254,66,212,135,68,219,185,32,107,225,25,227,136,211,138,181,174,112,128,190,66,165,251,135,185,108,40,159,222,177,26,58,26,148,218,89,13,15,27,236,24,118,78,33,185,174,168,219,230,119,230,179,169,161,57,118,97,227,203,9,125,55,136,197,112,94,138,136,230,112,204,245,136,116,59,13,75,68,121,43,122,9,22,252,149,172,182,118,113,61,53,171,44,42,118,178,166,69,222,44,157,34,128,126,179,24,154,159,106,149,17,227,58,143,176,241,222,56,42,62,181,26,208,33,24,30,33,112,83,127,84,65,41,251,206,115,178,2,222,106,153,209,238,98,208,200,210,177,133,86,65,23,104,110,177,161,96,79,57,142,162,15,207,173,153,56,254,250,73,76,74,43,36,200,57,145,60,95,227,21,147,221,41,171,192,107,234,251,74,126,3,247,128,122,243,153,128,202,238,189,17,198,179,70,97,245,190,200,231,176,186,98,217,254,45,230,228,185,78,204,155,64,247,183,255,152,161,26,12,21,183,209,199,194,177,1,221,95,77,76,253,203,104,7,192,167,209,180,50,138,227,189,182,231,239,238,168,59,221,119,154,107,247,102,200,51,40,120,192,133,47,249,238,189,123,233,117,188,210,82,68,72,178,111,103,77,144,205,181,97,1,172,166,152,242,0,187,181,174,188,39,82,5,75,21,213,113,66,102,62,173,169,132,21,120,138,226,211,39,44,143,160,126,74,108,191,13,117,58,148,234,239,194,161,161,156,231,240,170,77,120,106,63,168,175,231,243,60,192,181,236,20,52,239,78,141,78,130,59,219,80,208,24,37,165,109,209,49,251,9,62,80,50,249,181,232,42,228,47,166,191,144,176,206,148,242,148,153,182,121,24,128,65,137,42,161,119,66,94,240,11,55,102,122,7,205,142,144,144,180,47,60,218,192,149,85,15,213,83,8,79,215,104,8,209,172,222,200,242,28,255,51,185,167,33,226,26,65,147,100,114,222,54,27,170,212,207,83,56,170,37,126,121,14,18,40,231,4,14,164,248,6,110,118,48,51,83,228,76,3,131,87,77,86,163,48,72,194,109,53,105,118,111,198,140,133,34,20,119,56,35,236,7,170,176,164,95,86,183,232,105,108,7,25,169,127,50,26,86,83,94,101,58,219,72,205,46,231,78,158,94,221,190,147,92,96,224,0,30,65,191,21,237,118,106,224,247,161,116,33,41,10,92,81,248,232,191,41,72,116,171,89,110,208,62,230,196,11,67,172,81,188,8,212,62,255,199,22,201,68,20,120,21,90,72,70,211,251,61,232,5,238,147,16,91,225,65,103,178,238,63,246,157,100,192,170,206,249,101,28,25,120,125,225,94,105,146,218,75,10,178,103,244,73,77,174,18,113,205,198,233,5,88,129,66,64,72,137,118,81,217,130,206,156,174,224,223,115,249,164,10,160,47,237,255,135,146,236,13,99,71,63,62,20,134,132,135,155,27,21,239,159,60,195,224,248,123,205,45,147,225,233,72,95,151,236,249,144,43,148,51,197,175,100,140,185,170,200,234,37,87,113,85,41,197,41,164,33,181,64,228,58,125,41,220,43,111,47,37,139,69,75,126,166,210,12,7,175,6,63,122,236,237,156,149,142,254,174,11,37,215,82,200,54,62,74,43,2,249,172,218,115,203,91,14,165,110,103,178,200,5,226,141,45,42,68,130,198,173,253,230,217,122,113,39,163,182,160,231,100,179,40,207,8,27,212,22,174,85,58,27,55,118,83,118,244,201,68,167,205,50,31,36,17,250,228,187,200,203,159,109,44,83,197,240,214,82,128,207,62,237,127,108,238,226,36,190,44,152,27,248,90,79,254,43,191,182,206,138,179,239,133,27,56,192,25,166,40,83,172,241,62,178,172,53,58,205,73,6,139,66,50,24,22,193,232,205,173,161,67,139,236,13,114,239,156,46,253,12,218,238,6,255,169,98,117,8,215,156,102,178,212,208,18,175,147,108,96,73,71,115,87,75,254,77,61,212,49,252,42,72,23,95,49,206,208,189,203,240,139,4,56,101,109,139,204,117,23,213,104,47,1,254,115,179,25,96,58,221,157,53,112,19,110,172,118,168,11,21,171,109,123,100,79,124,202,172,155,236,144,86,224,44,183,119,167,51,180,139,191,76,201,173,212,215,120,148,255,149,110,69,229,152,112,197,133,178,122,15,23,55,103,67,13,152,239,59,168,53,175,130,232,143,236,0,96,95,206,91,141,167,127,199,149,82,51,222,51,43,148,225,183,56,32,68,76,97,35,154,233,207,47,2,29,114,143,36,159,81,168,169,22,163,74,208,233,149,204,129,138,138,13,48,180,42,41,155,141,156,228,19,71,135,137,63,119,146,67,61,236,133,52,209,164,39,67,110,28,5,36,100,159,52,79,220,118,89,126,230,63,180,117,243,165,179,147,209,255,162,97,177,43,45,86,56,48,223,195,122,39,130,118,8,183,36,55,42,221,83,72,74,95,130,91,23,121,226,221,206,241,204,44,105,177,188,105,190,84,106,225,244,183,44,76,188,169,150,98,155,208,244,161,94,75,232,173,64,126,153,184,124,75,229,87,31,209,154,93,125,64,53,167,155,250,167,122,169,184,231,14,34,61,208,47,179,182,194,37,87,240,10,125,2,26,125,232,189,207,199,3,153,204,157,148,33,93,160,134,67,238,203,126,198,203,210,112,25,199,23,136,192,135,207,227,224,213,125,17,93,230,177,178,164,152,162,80,107,50,52,221,42,20,128,143,202,168,22,91,223,159,118,214,249,29,184,124,24,124,1,183,54,43,61,91,155,116,241,94,157,187,60,100,244,97,97,177,9,57,90,72,245,38,31,86,172,41,102,15,35,39,4,233,141,9,165,41,137,229,44,122,16,181,99,178,84,124,207,34,140,41,145,250,172,186,100,100,156,162,5,126,187,160,57,183,240,17,46,181,44,120,144,141,151,142,129,195,192,11,203,241,78,134,142,214,106,198,94,141,84,62,51,127,110,9,65,150,68,221,157,131,236,130,114,10,128,197,13,157,252,8,165,223,138,108,179,156,231,156,82,132,196,202,13,64,69,92,110,180,238,15,125,240,30,231,134,56,66,31,193,191,100,72,106,233,11,113,8,121,238,178,117,107,157,215,58,43,212,236,53,215,214,1,16,192,173,175,231,62,113,26,94,248,47,30,36,232,160,227,75,161,127,33,5,192,210,69,155,249,190,217,224,42,17,77,54,231,20,45,5,116,154,154,80,74,148,126,85,137,13,59,123,226,167,20,148,24,19,123,17,78,46,126,232,255,147,20,83,85,103,16,86,141,246,211,162,58,245,162,77,31,51,40,174,164,117,38,201,18,8,240,124,226,180,213,190,92,223,249,184,227,8,168,86,142,19,66,247,142,54,135,218,13,197,216,225,152,61,155,156,171,88,150,158,129,132,144,138,13,21,166,17,156,62,40,147,131,134,66,228,77,177,184,53,207,92,208,3,16,2,45,215,154,73,196,92,47,104,0,94,23,103,132,206,81,105,63,84,231,7,205,95,148,128,250,142,158,42,49,223,26,22,72,27,211,39,245,201,245,4,127,48,221,21,121,201,223,108,209,6,93,31,85,112,207,74,123,201,78,249,139,38,60,134,47,225,21,74,31,177,146,41,144,16,100,28,219,207,21,104,154,200,135,169,238,147,227,243,217,211,187,109,182,74,223,148,201,132,46,26,159,121,196,145,148,161,153,126,127,103,44,44,215,135,248,8,157,23,184,220,82,173,81,229,136,173,243,230,69,68,158,137,156,73,166,209,116,155,166,231,141,186,187,84,175,227,63,227,13,18,245,222,185,2,9,97,179,58,174,246,67,94,255,153,44,100,138,172,19,5,67,221,82,20,224,61,104,222,44,53,106,82,147,130,225,31,218,140,64,109,45,5,216,165,119,100,159,228,18,213,150,192,59,85,135,249,36,228,230,57,28,67,206,105,230,148,212,28,106,92,97,2,31,152,107,208,11,10,205,238,102,126,66,83,190,233,77,232,77,96,85,249,251,119,192,179,5,0,198,67,127,22,157,78,146,64,204,6,39,200,12,229,227,234,242,193,195,141,125,107,248,143,210,251,18,220,67,240,110,48,114,110,15,160,241,14,133,152,132,225,44,134,92,88,11,167,164,225,12,234,164,92,9,175,74,190,164,193,157,232,4,137,216,80,165,124,20,254,221,2,198,63,217,156,135,119,4,178,58,153,215,139,67,52,172,206,47,40,75,33,86,67,63,41,10,20,37,237,37,156,4,13,25,23,201,228,9,237,67,16,22,116,17,184,162,203,188,227,13,110,65,231,79,200,61,118,207,68,161,90,71,47,113,31,224,165,90,23,21,239,63,80,176,54,103,99,60,125,72,207,90,110,231,121,225,205,35,28,16,137,252,136,94,179,14,97,157,227,66,82,219,137,26,78,157,181,147,28,161,251,43,196,201,53,245,149,152,194,86,91,70,203,91,114,199,241,212,180,125,44,131,135,116,26,132,69,27,84,222,132,88,96,163,119,62,129,249,230,33,147,28,124,23,172,231,132,144,182,235,125,193,70,233,206,77,27,210,203,223,213,95,105,230,117,205,214,164,126,23,240,10,34,237,211,43,162,138,230,118,192,86,247,125,167,215,62,26,113,209,175,19,231,246,167,150,22,44,69,31,236,205,198,210,214,123,93,60,9,175,131,96,145,71,92,190,209,201,225,103,43,204,242,98,253,129,95,56,223,107,29,87,165,180,44,49,28,37,42,83,215,122,91,126,77,38,243,71,213,191,223,14,76,247,97,110,190,120,147,167,234,237,10,98,148,45,218,3,23,117,15,148,142,173,118,236,90,31,27,85,54,188,202,253,43,102,109,130,17,8,239,241,89,212,14,29,172,179,90,8,104,5,203,117,188,43,184,167,54,8,100,136,17,55,201,102,193,221,245,173,86,65,162,176,40,92,214,101,18,82,59,131,63,156,187,219,65,190,115,172,242,52,181,80,109,165,136,98,148,149,152,234,86,143,132,100,239,159,119,163,250,30,130,119,190,45,58,208,104,161,144,10,202,200,31,177,215,242,236,78,3,151,34,8,16,172,231,112,71,159,168,32,208,230,50,84,234,214,40,92,65,60,148,117,76,216,111,91,121,177,66,86,123,55,54,126,46,118,241,103,105,245,89,242,0,0,166,87,7,145,164,227,90,30,10,4,88,64,114,70,127,14,161,218,198,16,35,230,115,54,65,108,190,175,186,252,79,33,24,82,118,130,249,181,253,61,28,154,77,227,209,111,63,61,68,223,162,41,90,176,37,114,169,199,77,160,219,199,22,79,240,212,158,243,217,226,74,158,215,193,166,204,82,135,0,106,12,155,150,113,241,197,33,205,6,16,19,118,164,194,115,243,112,162,251,134,203,122,124,61,242,68,140,200,131,168,172,123,48,70,132,227,199,3,196,130,48,55,231,64,216,195,86,36,160,233,137,145,108,224,93,218,61,107,191,138,171,13,215,212,65,223,117,85,120,109,207,141,12,23,221,175,68,130,129,185,138,67,225,85,127,85,215,75,146,79,69,133,10,129,210,51,71,147,116,11,104,76,194,87,78,137,12,108,185,53,10,210,35,135,33,203,224,96,175,47,98,138,83,60,163,16,100,51,21,186,245,7,153,128,164,73,27,189,195,13,61,255,96,12,174,169,37,39,235,177,224,137,71,128,240,63,137,238,255,68,185,212,135,190,156,240,184,158,113,210,241,119,224,63,177,236,63,172,135,117,74,27,187,227,253,246,222,134,197,251,197,243,107,188,160,85,252,111,4,141,195,243,91,73,226,144,131,109,136,10,172,209,186,95,172,96,107,43,22,44,176,226,122,100,50,28,65,163,62,235,88,16,254,97,48,250,64,155,101,21,83,64,255,189,98,142,60,20,184,3,54,87,20,50,178,254,138,105,53,169,141,5,88,57,244,207,138,191,208,185,54,87,134,70,182,197,77,248,201,118,133,148,231,106,241,215,91,61,184,61,250,9,140,91,66,203,141,93,171,166,65,183,29,234,196,85,230,194,177,148,240,126,71,14,92,212,2,120,179,141,11,42,166,15,45,196,187,30,249,247,104,244,5,25,126,208,252,253,157,224,36,138,145,222,221,213,15,204,112,217,50,193,215,194,2,248,214,48,43,229,7,204,79,218,223,82,137,114,228,41,220,68,157,35,245,242,213,255,141,189,192,243,63,72,119,222,107,252,230,192,211,47,186,209,144,213,221,185,22,152,208,54,130,76,100,242,54,210,211,40,29,189,40,7,183,252,209,130,240,76,107,14,110,35,151,57,0,187,180,78,210,153,198,18,212,33,205,72,211,89,150,175,136,7,138,13,18,93,226,93,52,171,126,188,165,113,29,15,231,234,11,67,54,164,115,158,58,48,20,202,65,198,247,224,202,190,45,10,153,146,148,150,218,67,157,27,190,197,15,182,135,56,130,43,203,209,174,134,100,81,179,58,182,229,1,155,224,135,148,214,99,38,92,212,220,49,17,170,248,161,123,88,92,5,119,19,210,149,12,254,121,21,140,38,10,247,25,4,22,186,68,1,211,221,109,182,103,137,4,242,129,66,67,138,61,50,131,83,208,81,53,132,36,86,63,33,62,142,250,210,195,68,246,210,84,77,150,182,48,140,129,1,24,195,122,107,160,22,129,227,250,27,102,21,127,52,229,47,19,58,21,47,132,85,233,11,183,119,3,54,223,94,30,168,153,3,202,62,170,29,46,235,105,186,122,192,71,128,73,149,47,98,46,122,34,64,101,76,177,160,154,47,174,96,118,108,73,203,121,15,19,101,72,99,177,70,118,219,124,182,128,41,154,76,22,204,166,120,224,174,35,27,29,63,8,248,217,183,247,192,11,141,178,28,4,184,73,111,64,221,65,220,21,145,34,163,79,94,28,225,40,146,182,182,2,244,18,250,136,64,65,3,121,52,149,19,150,105,221,244,244,247,77,249,155,100,216,128,178,170,122,153,140,221,2,88,211,227,255,108,191,91,6,185,100,148,31,75,245,179,229,46,107,30,214,20,93,198,142,86,108,83,131,235,38,107,38,203,229,248,160,22,216,41,215,22,55,59,211,156,38,76,79,202,176,49,88,161,162,206,46,81,83,200,99,138,117,40,110,2,84,142,165,212,63,185,183,35,165,96,218,110,177,40,36,21,19,181,76,171,145,175,144,249,115,42,97,99,152,49,128,122,54,8,136,236,196,46,137,181,211,218,83,112,177,64,193,136,89,220,176,221,204,172,174,154,77,96,166,191,132,59,141,90,169,6,46,45,84,193,160,209,49,6,199,255,3,129,73,146,92,31,226,30,164,12,7,148,241,217,3,113,226,199,81,146,95,141,45,176,205,253,233,128,78,74,123,244,138,154,234,99,11,241,18,251,174,123,196,122,254,82,210,2,90,216,87,97,38,253,160,197,255,134,152,168,162,17,72,133,41,122,235,85,154,133,172,162,240,103,107,149,216,192,182,55,27,163,94,52,129,61,154,61,11,135,223,222,154,217,53,135,124,181,120,2,41,107,239,28,32,232,45,27,51,86,176,14,7,40,249,170,100,67,101,131,23,151,200,74,151,82,184,146,40,7,64,240,146,253,80,218,150,108,16,186,224,225,98,8,166,177,252,0,35,95,107,137,80,130,116,129,161,149,37,52,149,240,167,11,50,129,134,80,126,16,233,201,206,97,186,68,205,245,254,241,139,20,5,89,162,39,98,188,107,186,119,233,101,250,245,150,241,120,191,39,29,12,121,31,198,242,252,230,85,160,112,172,171,128,29,103,65,246,39,126,74,92,140,142,56,181,82,101,195,59,71,4,8,9,42,98,180,136,41,26,56,252,4,230,102,239,251,161,183,106,22,54,238,250,59,61,243,9,189,77,195,254,119,234,124,186,211,5,26,88,176,159,87,101,242,100,179,102,218,39,85,82,118,109,146,144,225,73,28,78,77,189,135,29,192,12,95,153,113,248,50,171,113,241,189,121,194,155,247,109,70,124,72,61,27,79,56,185,218,51,155,130,98,183,1,100,60,85,55,160,158,110,41,58,63,216,176,49,228,195,87,118,254,105,223,41,138,84,41,78,214,111,49,206,175,91,190,57,25,68,120,22,127,85,81,202,226,197,123,156,169,249,12,182,148,31,115,211,146,41,208,248,249,197,188,103,47,138,8,117,43,130,28,28,102,44,149,38,221,176,211,11,76,148,186,176,252,87,62,69,3,88,80,123,168,196,245,128,224,186,224,99,220,46,237,181,88,159,161,175,204,237,160,154,13,131,12,99,88,171,231,111,242,238,194,193,15,3,254,152,148,114,131,215,216,106,245,73,197,176,147,149,25,185,200,252,52,225,236,86,240,34,22,76,102,243,132,148,11,204,125,58,185,37,184,188,4,169,89,249,104,232,254,3,96,102,68,177,242,8,251,188,177,100,48,1,248,177,185,181,108,161,130,117,35,229,28,94,131,105,31,242,158,200,167,63,124,21,55,142,139,10,202,5,82,209,8,37,48,22,47,237,174,182,254,11,32,46,255,142,78,113,207,192,187,172,174,16,156,90,26,138,142,57,129,2,59,148,175,197,194,242,205,81,57,214,199,206,60,204,225,254,113,28,148,222,242,209,101,104,98,108,237,223,49,114,212,129,78,146,78,208,40,162,230,188,127,198,195,47,15,146,82,173,159,186,217,133,148,237,194,5,33,102,245,90,65,8,165,35,12,231,205,62,97,232,36,7,127,30,119,233,149,99,221,178,173,102,226,168,250,196,60,181,5,125,126,243,158,64,110,37,30,195,162,229,136,241,198,229,105,88,85,49,14,96,84,216,55,253,53,92,172,24,38,54,35,37,50,118,149,84,244,199,203,56,87,218,44,100,7,25,135,147,55,101,115,200,99,37,8,239,72,221,30,76,8,86,146,55,44,91,241,31,111,230,90,185,168,144,245,50,43,46,238,33,229,223,34,244,14,118,219,103,141,110,249,21,49,255,202,251,214,126,66,144,34,95,94,195,240,131,109,100,123,73,158,69,82,217,206,59,169,190,31,185,211,83,88,73,74,185,229,228,147,57,21,198,39,234,143,84,167,170,144,247,206,56,43,55,104,193,157,220,89,125,173,151,17,4,10,18,124,244,41,133,194,59,11,202,98,174,212,26,19,95,71,26,82,242,133,85,125,4,131,36,108,37,250,255,99,63,15,53,173,129,255,175,83,105,132,142,35,4,243,133,67,237,220,88,25,169,219,83,229,33,83,46,251,0,111,226,87,41,226,98,245,208,93,251,94,207,210,41,146,56,119,137,32,0,61,212,6,161,219,144,112,202,88,124,132,83,197,240,185,196,152,34,202,136,59,198,165,5,136,11,246,158,60,3,176,105,203,207,70,162,187,45,160,39,60,82,115,113,239,37,166,188,235,215,222,227,65,73,188,70,178,98,215,247,7,12,10,4,216,139,202,178,125,231,103,79,61,127,58,10,202,75,42,107,139,214,172,4,14,3,23,73,247,52,158,78,61,218,235,79,191,182,70,127,157,34,208,242,177,248,153,110,42,50,168,186,212,159,202,174,245,161,60,197,47,221,200,111,195,231,35,136,145,196,62,119,52,247,41,50,41,64,94,231,136,149,213,174,127,157,61,143,47,166,152,59,245,186,16,70,32,201,49,239,157,90,225,122,138,88,158,93,59,121,246,69,151,25,182,189,199,100,74,131,123,99,103,185,138,240,169,255,83,8,240,13,159,156,5,223,181,247,243,244,179,90,207,159,36,69,34,174,29,39,12,198,108,220,130,2,10,203,188,206,67,116,209,27,67,170,198,93,113,250,14,198,254,196,37,146,198,0,245,162,19,196,105,30,136,94,211,48,61,213,53,160,236,102,140,240,236,1,246,124,73,73,184,88,243,157,125,154,77,39,104,111,1,205,78,22,233,44,37,253,92,198,51,8,211,150,43,192,106,122,208,21,123,140,14,148,222,144,217,194,15,242,120,80,45,66,71,74,147,132,37,185,45,165,41,76,166,143,130,134,3,4,15,104,214,102,179,162,238,195,200,235,20,223,172,249,110,37,43,216,136,128,232,235,48,215,2,250,173,82,109,146,30,125,217,231,73,206,65,2,40,45,35,163,248,230,102,19,67,102,0,76,64,7,130,23,167,105,28,152,26,73,234,15,36,35,231,146,205,50,217,164,199,154,192,15,19,80,26,30,181,14,197,12,131,88,61,140,86,85,233,182,210,78,143,77,63,177,30,176,10,224,14,137,130,162,84,191,108,227,75,85,115,237,159,119,222,168,131,18,13,22,92,110,176,134,71,180,31,116,154,111,4,116,74,59,2,191,75,114,181,184,238,106,236,202,251,63,247,48,35,155,172,61,122,174,26,38,3,176,42,15,71,195,153,55,66,191,33,169,177,220,36,95,177,66,86,173,31,180,219,166,178,139,120,139,67,88,25,238,233,169,169,111,163,217,54,29,44,34,138,236,199,35,50,82,214,30,125,91,25,222,65,137,125,96,232,78,167,209,68,71,70,1,22,163,34,202,200,71,113,235,157,41,14,32,110,171,235,197,174,10,51,158,251,44,98,199,201,196,168,50,201,99,205,245,153,75,169,17,143,154,52,222,138,28,173,86,92,134,115,136,220,131,85,171,122,218,117,190,117,143,79,26,121,10,50,45,80,241,33,4,253,140,1,159,201,105,123,35,133,81,59,236,16,238,109,215,10,124,211,64,112,180,147,203,106,142,69,97,205,162,177,217,151,174,189,239,69,50,30,166,238,219,120,79,225,197,121,127,91,215,89,102,17,39,158,213,94,164,254,49,125,216,191,222,90,38,224,214,242,60,2,38,241,139,218,34,185,186,30,206,33,43,38,242,81,191,12,1,200,96,167,125,197,194,127,129,244,184,30,74,74,196,174,229,224,226,124,52,137,122,146,108,187,169,127,72,111,131,243,79,149,236,134,103,137,212,161,44,61,183,188,103,150,96,95,88,187,167,31,213,185,63,128,70,10,58,47,69,155,112,231,242,129,19,78,116,74,152,85,44,128,199,241,148,56,48,27,194,180,191,35,170,227,179,166,110,172,88,208,185,53,153,120,109,155,216,205,172,159,59,191,94,49,209,213,90,125,246,132,153,163,89,50,28,91,141,185,11,4,229,210,18,79,36,117,191,90,231,97,92,89,193,98,201,7,9,252,3,100,157,87,134,164,29,218,54,7,117,232,97,226,74,185,43,135,78,199,151,206,137,157,244,201,49,137,164,23,115,134,121,92,128,224,192,100,154,252,124,146,17,129,44,130,237,65,159,194,35,88,56,132,29,163,200,91,112,118,35,100,76,112,87,180,233,171,69,124,62,161,232,54,66,129,248,193,47,232,197,143,236,112,36,132,61,97,179,231,60,124,4,220,161,114,16,84,196,143,200,58,98,2,255,8,3,222,42,146,204,234,68,199,78,202,173,32,215,30,242,64,32,250,49,111,31,174,191,209,40,51,55,101,12,137,212,116,140,72,132,52,104,204,245,218,122,29,236,175,188,112,137,112,129,225,22,84,118,55,75,104,13,207,51,243,102,148,120,49,86,192,53,173,30,143,161,0,187,160,141,185,32,104,37,221,242,44,29,27,162,135,12,4,205,239,98,8,217,237,81,207,29,240,169,209,6,80,56,120,99,193,90,244,235,14,45,162,130,224,62,152,96,147,9,238,188,49,82,151,207,8,240,126,39,228,192,121,199,227,52,238,238,69,130,134,174,90,34,126,176,133,63,234,79,219,126,186,224,106,183,242,244,90,180,161,17,110,155,66,109,222,205,83,121,103,49,85,234,220,198,98,67,0,50,194,21,182,193,118,19,220,4,173,96,221,203,40,186,232,98,162,37,12,169,225,26,229,12,71,121,194,162,100,159,139,30,0,151,86,14,131,219,129,154,212,170,79,126,26,171,90,92,239,0,106,79,97,213,183,128,12,238,216,30,67,114,73,64,191,22,179,225,12,252,220,234,87,55,51,145,66,34,63,168,252,148,87,47,176,54,228,85,152,226,61,198,41,76,94,182,131,134,142,127,97,14,232,78,147,107,91,23,55,184,220,0,132,128,230,214,41,253,146,45,59,69,244,78,228,127,47,234,235,212,197,152,203,251,16,167,93,153,46,245,207,238,82,246,96,131,4,123,250,67,9,15,63,198,214,205,18,51,223,238,190,104,69,185,188,1,61,168,132,22,21,224,86,237,119,49,15,228,241,216,161,180,19,252,22,109,144,133,49,21,97,145,73,250,32,160,0,103,179,235,69,26,206,44,140,184,97,110,167,21,84,228,112,18,154,24,41,60,232,190,168,43,72,248,82,221,13,138,79,89,140,122,61,117,232,17,75,243,217,88,218,235,50,96,182,174,230,168,249,99,90,3,240,143,171,128,49,247,62,32,242,216,73,239,88,172,30,77,172,78,40,138,46,152,178,103,92,139,57,224,167,208,14,63,245,78,69,235,225,103,133,134,96,22,32,104,77,117,153,192,206,38,183,221,117,253,207,240,211,16,89,105,251,119,74,144,222,156,150,154,58,135,38,58,165,24,125,4,181,205,243,117,226,156,243,80,70,66,176,146,37,197,55,215,99,87,148,92,191,170,198,29,60,48,57,132,232,226,100,191,28,143,184,235,205,69,47,243,18,71,89,96,148,5,68,98,120,4,46,222,166,248,156,123,31,13,147,244,29,153,133,248,130,207,112,2,139,131,49,115,58,120,121,244,170,19,97,201,192,75,161,137,127,83,157,78,253,58,222,224,220,83,182,11,236,101,153,140,34,113,36,254,143,112,151,78,23,46,155,32,170,178,239,64,77,243,128,127,240,27,82,213,68,205,87,27,42,124,75,156,9,234,4,161,210,181,7,140,130,78,31,105,100,208,169,223,62,105,229,132,50,56,128,226,5,184,254,213,116,54,2,93,233,67,132,34,39,179,133,27,209,227,163,127,21,38,10,175,140,28,114,70,190,173,123,166,31,176,23,83,27,2,64,147,250,217,95,1,100,211,238,42,151,65,188,182,234,61,134,64,31,245,14,173,167,214,244,223,242,182,230,208,180,241,228,142,135,251,1,188,189,100,175,18,181,117,35,14,102,136,20,208,168,235,41,228,102,112,204,114,197,137,63,144,1,174,122,8,52,194,119,247,169,229,16,103,124,105,126,128,30,165,102,132,107,24,55,253,220,212,101,202,129,150,144,2,88,195,9,152,160,243,97,168,80,228,18,168,79,186,193,151,206,197,164,32,6,58,126,128,178,154,122,20,188,81,123,96,6,46,214,149,107,24,177,129,255,208,247,29,66,228,212,126,81,168,1,76,131,174,108,141,122,248,24,107,113,170,68,235,117,129,83,56,163,148,130,79,104,185,22,138,198,242,77,180,102,47,117,225,233,90,16,225,8,163,241,112,173,15,227,176,197,136,139,114,202,96,151,63,60,96,154,107,17,147,224,206,248,93,53,106,235,229,60,87,165,173,67,60,192,40,25,38,154,183,128,195,41,187,21,254,166,61,76,158,20,29,63,194,131,191,180,111,32,193,245,193,122,94,224,84,142,94,172,150,192,219,151,49,107,61,164,252,204,72,119,227,21,253,120,84,60,176,113,224,172,24,196,92,64,19,6,114,3,127,121,48,40,3,60,52,74,110,225,56,14,140,23,179,58,129,206,230,166,25,190,123,31,5,201,50,253,204,94,174,116,91,166,97,216,90,145,201,152,88,164,18,19,17,202,204,251,146,159,61,233,43,209,63,240,241,168,94,78,86,211,0,62,97,12,204,199,62,218,65,64,9,170,91,210,0,191,56,249,81,51,140,84,246,229,192,59,27,87,104,195,108,174,216,168,188,98,234,57,57,162,193,13,190,155,45,124,40,58,32,99,14,179,68,39,112,92,159,159,36,201,2,226,129,171,120,102,185,148,114,152,162,196,181,56,69,182,37,197,98,228,38,41,142,10,57,84,197,160,183,210,236,9,42,214,224,63,62,31,118,26,251,177,236,185,210,104,244,19,251,195,113,141,34,50,255,204,42,56,117,66,203,139,249,119,14,28,203,175,32,42,245,180,104,11,154,25,127,248,60,200,28,180,91,39,244,161,108,240,140,189,72,32,119,76,235,30,100,46,74,250,110,234,232,192,243,51,124,39,251,186,123,64,23,149,105,161,56,180,49,163,245,34,42,187,145,64,13,82,135,95,186,146,44,214,135,104,194,94,110,93,178,242,130,21,226,63,156,184,127,204,241,167,193,180,9,237,106,90,105,165,19,198,246,140,189,35,66,77,27,170,145,237,170,99,161,189,234,238,51,219,82,212,214,32,43,128,193,45,163,2,216,44,192,84,104,92,99,93,116,94,163,255,90,174,176,184,147,127,46,68,22,63,23,62,151,173,125,237,52,101,54,144,205,184,145,103,197,86,53,11,127,158,118,175,217,13,86,251,47,11,230,181,185,174,212,134,254,17,229,174,154,246,87,107,230,55,252,104,84,104,251,201,66,110,183,24,71,54,10,178,175,12,182,18,163,73,203,244,85,216,175,129,81,60,17,112,71,155,136,34,122,134,137,245,172,152,64,127,55,97,0,148,116,138,88,45,172,16,250,169,10,55,168,155,249,246,117,74,112,183,220,144,84,127,245,255,79,75,162,219,9,150,235,53,199,122,194,58,198,192,83,66,183,114,7,36,198,143,179,218,40,178,248,218,185,108,140,103,50,91,31,235,191,230,109,62,140,189,224,31,241,31,255,48,167,106,18,242,164,95,24,208,232,159,107,188,95,66,187,61,92,245,43,201,191,135,1,41,19,255,103,156,115,9,219,112,48,74,62,113,152,120,196,200,133,105,206,67,75,26,102,159,159,237,244,74,119,46,70,217,24,102,5,82,212,11,224,67,44,241,148,125,122,140,30,141,56,185,122,202,228,228,152,203,143,221,92,116,168,69,113,89,106,187,215,201,255,151,132,143,105,97,52,138,102,179,146,194,72,5,11,142,16,31,119,218,54,11,45,117,143,78,191,169,116,115,101,231,67,196,81,203,175,126,36,74,3,153,52,15,176,118,87,2,10,235,166,166,25,217,24,97,56,174,121,208,62,83,81,159,25,1,81,67,213,89,71,34,140,83,221,7,159,118,96,172,176,235,249,185,28,97,166,17,64,245,165,23,63,251,128,105,12,76,148,92,91,188,236,238,25,184,58,203,60,22,171,192,183,224,144,158,173,39,61,188,92,76,155,181,102,5,187,207,150,94,58,3,250,36,236,210,151,254,24,164,165,111,28,108,229,47,22,146,124,12,137,148,24,184,174,127,13,247,114,83,177,100,178,209,116,247,77,184,99,249,116,52,90,208,48,242,239,23,251,172,248,54,133,62,24,240,90,110,209,64,19,65,231,127,36,40,74,61,89,232,108,40,133,183,241,255,164,20,180,249,37,233,11,144,123,198,10,134,56,30,115,232,181,188,113,167,11,26,133,132,207,13,144,114,236,85,141,70,151,42,10,176,211,160,243,33,210,57,247,197,33,32,215,207,152,153,82,222,95,87,217,232,251,9,157,52,92,92,186,221,244,36,132,244,171,126,222,212,178,213,118,239,52,68,215,228,157,37,229,77,151,40,95,205,177,209,250,59,223,193,65,135,147,161,220,60,30,20,221,12,251,251,237,115,218,76,211,222,227,113,244,133,150,144,25,141,230,202,17,219,118,142,8,254,249,111,8,74,66,92,214,206,5,252,176,47,65,208,174,127,25,182,208,254,125,215,136,104,95,122,148,47,160,24,171,217,115,108,36,46,111,121,54,209,200,78,201,242,47,82,146,153,116,84,30,151,175,199,2,189,89,106,30,113,219,11,101,233,191,165,1,168,238,15,156,187,76,114,205,125,10,232,251,59,152,234,16,241,125,111,195,40,170,83,198,62,219,137,128,20,195,25,33,235,77,95,39,151,116,175,239,44,250,171,84,173,154,211,23,212,157,160,162,208,164,16,244,147,14,14,17,6,104,150,53,108,250,78,227,27,137,22,252,98,238,175,243,37,70,13,183,79,164,152,113,101,78,244,30,197,103,210,103,214,38,156,171,0,17,21,28,178,30,168,20,31,200,208,51,52,113,15,151,103,235,237,40,10,81,34,216,193,173,182,231,138,223,70,74,110,140,135,128,67,193,157,182,109,142,223,157,163,206,148,192,228,100,183,148,130,219,246,217,18,184,83,27,227,178,40,188,85,136,45,33,244,69,87,159,128,40,97,108,157,0,46,148,60,23,222,235,38,205,188,53,18,244,187,182,168,183,237,144,27,24,195,130,65,220,216,15,20,137,249,27,41,218,232,246,197,92,106,119,80,113,188,192,30,233,34,219,39,146,187,114,27,18,165,104,236,249,38,44,105,166,205,230,49,128,243,36,251,113,40,38,25,215,224,120,27,235,159,12,92,34,87,109,158,74,60,6,136,178,187,38,91,137,86,88,121,201,214,195,151,83,64,228,135,143,158,147,97,176,188,111,251,247,113,197,192,23,113,9,177,188,15,65,193,111,153,189,107,45,251,63,75,15,75,144,12,21,147,41,0,174,131,76,50,32,230,156,172,12,21,217,99,174,122,176,90,142,255,218,205,218,102,252,254,211,225,2,68,190,66,50,226,64,173,14,103,174,112,42,47,226,144,59,125,110,69,123,255,9,156,24,136,238,168,115,76,198,25,170,142,181,178,27,82,125,25,38,98,50,248,232,139,82,51,79,162,74,26,73,204,26,40,13,40,2,73,96,105,177,92,99,35,99,110,56,185,105,177,205,31,100,153,114,150,60,150,252,43,129,210,116,71,159,252,129,54,152,242,65,180,226,15,50,224,127,124,175,143,91,38,46,62,8,22,59,186,178,38,77,246,103,48,216,212,109,56,156,174,127,24,51,123,161,249,178,142,219,27,68,158,78,254,94,242,73,34,240,204,200,93,216,7,25,228,165,205,3,19,2,181,77,104,175,11,217,230,194,135,111,69,253,161,56,50,214,192,155,137,146,17,189,167,202,57,121,74,241,142,45,201,161,154,57,125,92,44,130,241,88,74,115,124,14,144,36,13,187,40,11,139,4,59,158,157,206,13,92,151,135,1,219,94,61,152,173,99,202,240,172,225,103,253,248,69,184,171,34,33,169,218,245,125,15,58,199,178,40,202,80,134,75,170,110,92,65,6,58,200,15,51,116,102,229,188,24,164,185,80,221,62,235,227,1,238,159,158,44,47,211,248,136,211,153,57,241,104,231,90,19,39,187,253,118,187,69,91,208,213,90,157,249,110,157,246,186,4,46,212,11,235,27,55,22,236,16,139,224,123,76,76,174,18,156,21,2,25,59,83,147,157,186,202,18,243,139,77,192,205,43,11,67,231,130,169,53,171,6,241,244,138,2,96,125,93,209,194,120,187,162,104,129,237,118,242,149,94,212,207,222,141,202,202,204,103,231,34,132,92,157,95,239,176,202,195,185,87,154,63,219,10,215,8,146,73,190,222,17,110,27,90,35,66,27,93,191,17,12,120,158,138,224,58,68,152,169,243,48,157,252,163,132,148,157,222,184,145,161,202,141,123,93,61,82,14,213,82,53,66,165,100,215,10,77,207,216,139,35,208,176,63,63,80,219,7,147,222,36,12,252,16,92,225,56,96,70,218,129,99,205,25,99,208,253,109,43,104,153,0,224,39,192,163,67,138,85,157,8,128,148,197,89,194,87,99,206,81,141,47,214,217,156,211,187,184,220,33,32,20,31,143,48,136,147,54,141,147,129,53,91,215,115,208,74,187,36,225,92,30,238,23,79,195,80,124,161,28,40,129,212,156,128,13,94,16,64,122,47,166,181,116,236,218,16,106,162,20,12,250,106,59,75,168,173,41,229,75,239,230,135,79,240,61,106,144,243,222,80,207,8,155,238,226,204,246,25,2,83,116,227,42,121,189,61,88,237,200,221,66,111,84,209,44,204,5,74,21,249,236,194,187,52,103,164,109,114,191,27,0,240,99,60,253,103,92,69,90,87,109,109,138,61,171,55,129,98,152,62,65,82,93,47,130,95,171,12,145,48,243,4,220,47,118,144,188,144,153,224,242,141,144,94,218,128,144,77,106,98,182,215,118,91,73,238,22,122,110,3,109,89,91,34,0,57,72,86,228,158,153,209,235,58,200,213,223,68,254,49,210,128,11,87,0,207,25,93,183,141,193,9,142,11,15,213,209,90,220,249,117,222,163,188,42,116,162,111,235,175,70,29,243,205,184,46,214,112,219,68,27,190,37,228,13,196,98,127,58,220,90,248,241,41,128,82,170,102,78,72,99,103,47,49,238,210,203,217,40,130,83,98,143,81,119,52,173,166,24,234,61,253,11,147,118,189,128,69,161,207,122,161,251,67,139,246,0,44,109,95,241,166,224,177,225,201,10,38,201,24,44,192,55,22,191,109,159,167,39,67,213,33,100,6,197,183,223,105,223,51,37,21,232,53,7,12,64,243,13,77,22,76,175,156,127,201,50,147,144,135,179,71,59,88,161,195,29,23,213,184,66,77,202,54,134,198,21,205,74,59,68,197,2,150,28,192,219,164,192,158,231,193,240,26,176,33,136,97,129,95,91,76,114,79,86,97,220,135,80,233,39,150,150,27,223,206,160,84,151,120,226,45,231,200,167,121,200,46,1,132,39,112,88,96,85,173,249,29,67,46,208,224,131,84,81,64,218,16,15,12,243,215,86,157,212,204,147,221,26,11,10,114,75,9,240,8,16,58,152,196,219,149,51,8,94,225,203,7,157,156,249,220,220,207,80,128,47,103,189,58,38,83,183,122,51,230,254,146,160,37,235,226,233,55,164,177,33,246,224,67,54,25,126,27,216,100,83,102,46,231,99,215,206,57,243,30,174,54,153,209,116,17,156,121,215,104,69,33,59,37,187,95,75,158,233,68,148,64,236,174,32,201,143,189,99,126,50,216,65,155,184,98,84,102,243,47,178,99,59,227,198,213,53,206,39,35,180,9,162,212,58,190,48,80,234,176,124,165,130,234,100,117,5,245,122,210,159,134,31,165,144,196,154,81,131,130,236,180,4,23,225,45,144,92,99,117,71,130,142,141,103,81,168,211,2,123,203,171,59,133,24,46,169,116,160,216,233,44,215,66,201,119,51,58,75,50,68,116,127,170,113,129,55,193,109,155,237,246,191,189,150,135,24,5,204,65,201,86,15,202,87,40,122,227,52,245,82,182,54,65,104,165,101,190,208,117,246,203,163,168,171,35,67,186,170,221,100,63,0,206,157,229,28,237,147,132,88,91,215,64,64,22,48,88,246,232,140,146,211,199,110,230,207,238,78,66,78,104,253,244,227,114,94,210,30,6,33,43,1,110,176,2,156,178,126,202,213,183,124,213,218,56,96,100,54,192,53,69,60,180,73,48,142,15,85,251,191,216,147,246,47,251,203,203,138,14,174,9,73,186,102,220,0,200,22,56,137,234,117,155,105,229,151,192,129,193,93,234,222,103,57,195,107,240,92,18,180,41,23,23,255,255,135,26,222,109,47,129,205,129,52,192,82,153,195,24,72,58,156,127,159,210,114,67,196,173,239,17,84,216,115,57,151,70,218,133,179,61,149,175,160,128,222,103,91,202,239,92,198,173,251,58,186,236,105,215,23,167,254,58,4,21,22,17,213,211,230,47,195,183,154,245,187,224,165,236,107,184,195,149,49,79,138,158,97,201,64,138,145,249,37,253,56,175,148,83,197,74,69,186,47,38,63,14,241,224,30,52,152,74,163,144,190,253,92,176,164,109,217,165,118,19,56,214,162,10,193,213,18,95,72,55,150,22,199,50,196,111,155,204,32,122,25,68,234,156,43,178,92,160,204,83,138,2,184,248,7,132,201,144,69,176,216,12,49,175,55,89,163,91,23,159,27,226,183,111,153,13,35,140,237,237,170,126,119,171,55,105,81,53,55,142,131,46,39,136,83,145,158,216,192,73,71,22,117,124,243,85,81,130,52,28,216,143,226,153,141,3,162,141,249,125,8,119,27,65,133,135,123,117,71,161,45,130,255,194,160,178,21,123,106,105,199,3,146,205,115,157,18,61,181,226,101,151,234,244,10,17,216,104,186,3,215,32,157,200,151,190,41,62,181,74,5,160,213,185,70,97,253,164,115,81,108,228,207,4,144,210,54,224,36,93,21,210,109,58,54,121,127,235,182,110,122,161,24,48,114,193,83,31,221,109,136,70,83,212,203,195,232,231,69,5,55,157,106,77,101,19,58,55,127,91,240,85,64,11,229,155,10,93,177,2,144,20,75,121,186,81,171,50,1,196,62,217,231,16,206,250,186,173,24,60,218,230,99,216,36,3,103,61,237,73,61,170,38,35,224,158,166,103,119,128,4,5,152,194,141,234,113,149,54,196,25,235,18,81,227,137,137,138,115,20,204,38,189,115,69,224,31,135,6,32,171,72,87,42,144,71,72,255,171,79,132,159,83,151,209,62,152,25,79,133,19,172,154,90,84,80,101,131,150,37,245,195,199,210,235,98,122,229,215,7,164,79,63,62,80,142,144,161,189,235,24,212,200,109,145,185,104,122,29,112,81,147,15,4,108,147,244,184,155,249,18,80,201,174,227,93,226,109,63,7,17,14,209,141,194,160,30,170,18,60,144,32,224,177,0,106,248,126,107,84,185,179,106,146,13,238,80,251,18,50,96,122,216,217,112,187,148,102,111,47,244,158,22,39,76,59,150,43,22,117,202,253,88,26,166,126,243,142,239,81,69,185,255,93,56,20,32,232,185,22,217,19,198,221,159,42,176,105,127,180,90,189,136,213,241,120,92,0,77,136,165,142,142,126,142,164,219,231,41,237,134,253,191,235,254,252,57,52,25,89,120,215,145,142,87,152,149,107,177,79,86,176,4,105,59,150,254,14,74,110,116,206,16,0,218,98,156,66,18,10,16,202,136,15,80,236,236,233,75,132,186,168,174,233,16,240,124,0,189,243,98,252,33,121,215,44,173,199,127,71,233,97,165,227,102,12,62,59,225,180,119,55,117,95,159,229,177,99,143,111,247,182,37,180,23,219,51,67,250,113,124,122,213,160,93,82,156,170,252,0,1,76,22,11,250,91,147,112,1,233,251,21,112,60,137,25,215,114,231,83,28,55,129,94,198,200,247,80,156,163,198,211,214,235,239,111,210,160,137,128,181,114,163,61,8,94,83,46,49,30,181,239,140,222,109,66,167,226,89,159,32,73,145,21,222,213,65,62,66,94,137,206,128,169,236,73,167,141,150,232,238,36,44,136,68,28,4,21,153,225,253,254,31,210,190,138,17,5,228,142,90,163,91,64,60,208,230,70,88,201,198,140,171,37,112,143,83,251,39,36,63,189,48,135,196,100,189,76,124,37,117,179,153,183,236,97,94,72,5,144,76,23,71,22,137,91,101,17,51,31,37,37,248,167,248,202,225,125,28,24,192,51,67,242,20,243,183,110,138,211,210,110,39,221,189,226,241,100,225,217,111,128,6,152,234,156,179,79,2,139,150,103,51,47,252,21,104,71,84,83,243,17,144,151,52,96,128,26,163,179,77,162,97,109,136,128,106,219,50,111,229,203,148,252,102,19,181,220,239,169,7,60,6,173,111,160,55,24,162,69,223,39,186,222,104,184,206,203,0,68,178,244,108,51,107,230,205,176,248,207,12,225,122,184,184,1,99,226,173,135,71,136,45,243,127,168,160,134,31,180,45,53,1,213,36,43,83,51,59,61,115,223,67,123,54,86,38,128,71,198,210,179,241,150,253,253,1,26,104,127,234,182,86,121,188,19,134,211,19,249,75,96,210,137,255,175,48,38,23,82,107,180,73,87,97,17,31,217,160,77,243,143,164,224,77,154,152,148,205,66,240,48,168,156,21,103,19,214,154,17,173,156,16,31,18,63,134,224,211,145,46,114,33,113,105,125,72,78,202,25,183,28,255,45,63,169,16,225,2,237,156,45,254,223,125,195,250,99,49,156,250,188,216,169,104,171,157,188,114,72,110,29,153,187,99,254,51,237,255,23,98,131,248,193,121,59,142,7,176,78,52,182,134,170,136,125,40,234,245,225,74,212,208,176,105,253,8,32,143,69,180,249,246,10,31,176,129,144,255,199,193,59,12,181,231,207,169,241,243,19,253,220,49,45,195,42,147,102,239,117,186,240,63,156,184,43,225,119,87,44,38,11,106,231,241,208,145,167,222,147,22,240,37,62,139,30,249,0,209,78,164,84,131,254,178,126,91,170,226,29,73,170,154,101,221,202,18,92,146,134,178,38,195,106,88,228,86,86,172,34,113,89,4,85,139,78,39,3,161,49,94,245,107,21,206,162,64,240,35,201,126,89,226,156,229,141,165,29,4,22,197,202,125,44,200,64,176,137,55,95,167,234,104,86,244,217,45,234,206,4,6,171,85,146,235,237,168,81,103,77,204,104,16,110,90,132,100,240,72,96,188,201,254,56,43,229,76,8,144,250,190,182,102,89,64,104,238,222,184,173,138,130,235,233,91,226,30,237,38,236,194,116,180,36,198,97,37,242,32,60,224,15,13,203,190,121,127,41,1,108,205,117,79,104,173,232,164,128,0,31,193,82,164,115,1,175,199,50,22,0,215,136,87,212,105,174,240,47,27,51,93,165,183,61,96,31,150,125,70,38,192,85,215,191,65,159,42,123,59,211,210,39,96,64,53,80,103,134,214,75,89,23,40,114,4,148,61,56,175,176,119,180,61,162,119,184,21,110,204,103,52,202,109,151,202,204,240,215,165,116,96,52,113,64,112,42,171,54,172,169,69,253,44,153,24,232,19,141,73,3,80,141,143,57,23,209,218,79,5,176,20,117,197,223,97,0,0,216,103,205,251,42,189,173,104,182,224,240,187,184,90,150,165,151,54,237,248,21,195,252,26,86,186,43,130,85,173,165,88,77,47,61,60,251,197,177,40,114,201,153,72,161,39,61,136,217,22,39,227,180,112,20,184,0,22,255,248,87,132,120,113,8,6,226,212,166,57,112,185,75,15,83,79,196,106,136,205,5,59,250,63,35,80,140,176,236,196,248,3,221,98,250,104,32,99,152,165,109,139,192,40,49,68,14,50,89,102,202,12,64,120,114,49,227,205,144,18,43,180,65,47,167,89,67,145,180,44,241,173,23,232,86,141,103,210,72,240,225,180,133,221,238,4,125,161,121,44,204,5,162,64,34,84,167,152,247,154,190,162,116,71,83,180,181,174,3,151,227,180,162,28,198,133,1,195,199,54,251,220,4,182,126,209,15,24,207,187,240,50,11,120,250,158,87,125,246,74,64,175,190,21,150,255,202,170,125,38,228,16,24,166,186,7,113,0,133,182,112,138,188,2,24,120,236,10,76,154,89,48,23,228,159,219,144,219,209,76,59,25,100,202,46,203,178,117,252,97,240,97,42,143,205,52,199,220,7,0,109,217,139,126,170,178,227,213,192,16,171,133,173,237,240,186,6,14,155,94,157,194,99,123,174,181,74,164,126,56,178,0,172,77,163,74,172,53,5,161,130,161,162,149,232,150,69,170,172,59,70,142,112,87,58,16,192,67,8,250,29,140,221,17,117,167,133,43,180,141,157,214,18,131,114,105,147,206,25,138,207,188,30,41,9,97,113,247,123,251,56,165,182,239,95,79,152,45,113,160,213,230,249,227,167,149,52,172,156,182,242,134,61,19,90,144,248,100,252,168,76,213,246,126,123,175,8,114,218,41,247,90,229,94,238,86,73,43,35,42,116,168,217,75,167,166,122,230,82,130,255,164,51,9,86,79,111,49,152,198,132,96,62,12,131,23,66,96,51,213,29,13,144,20,26,228,66,41,228,68,254,126,173,192,51,62,41,184,136,182,93,102,144,250,65,236,200,19,121,182,87,125,72,97,132,164,29,130,211,26,115,217,177,199,35,54,132,98,87,138,188,229,34,130,240,81,186,231,130,41,17,74,64,27,41,169,251,229,192,38,247,81,85,224,10,181,80,164,164,112,73,150,53,119,166,144,157,52,98,187,48,28,64,77,33,237,100,1,46,123,40,27,232,128,105,190,126,27,132,205,16,107,184,30,187,240,29,128,81,177,9,175,37,159,188,53,109,59,15,33,102,39,182,31,73,163,176,14,150,178,216,231,41,152,253,100,240,46,106,181,137,111,240,101,204,74,57,134,179,49,230,134,124,152,70,64,166,43,65,203,80,53,157,166,39,138,142,243,74,145,217,9,194,93,128,67,93,129,161,161,254,211,189,239,205,32,171,253,118,141,204,240,183,222,146,198,220,187,58,201,238,218,179,206,89,183,40,198,33,53,38,40,144,216,247,161,189,216,173,9,22,72,148,174,45,3,127,35,125,111,140,15,207,119,246,38,244,195,69,85,106,121,28,241,125,124,103,116,108,152,84,133,165,68,92,5,189,160,223,125,159,69,84,91,214,24,52,36,207,180,152,8,156,70,209,194,220,165,138,212,192,246,132,124,186,64,218,179,23,131,210,117,7,15,197,250,249,187,104,74,19,195,232,168,66,171,125,133,252,89,123,236,67,152,150,187,82,161,241,29,160,206,15,254,101,201,34,79,182,6,88,237,204,67,3,24,199,64,58,22,71,118,31,80,235,148,111,111,74,248,229,15,0,160,215,0,121,227,15,243,58,122,251,203,236,223,102,217,235,105,113,239,209,206,227,198,166,116,250,85,48,71,14,78,216,2,167,129,129,240,167,56,89,118,161,125,49,228,56,221,13,219,207,36,68,253,27,45,219,117,151,229,111,247,206,97,173,132,8,74,182,16,125,54,238,31,46,244,50,250,3,216,182,42,120,67,61,39,106,101,23,248,21,80,151,115,41,105,95,47,32,90,53,3,164,31,12,113,105,26,135,101,186,43,191,173,143,177,4,75,109,96,7,121,5,231,218,250,45,96,254,193,146,225,251,238,21,240,27,207,43,187,7,61,254,195,234,210,152,46,241,186,188,216,234,82,179,109,61,190,139,211,58,36,74,149,107,249,150,196,71,226,167,232,40,42,19,152,17,194,16,94,5,11,57,37,43,99,98,248,81,211,60,69,192,80,94,225,241,197,53,76,100,1,166,253,132,17,3,72,232,72,214,60,18,151,159,15,167,78,27,76,142,22,21,129,121,10,185,35,246,49,165,218,73,182,236,65,1,175,236,230,71,209,189,163,164,179,194,209,86,6,180,219,147,94,15,212,246,83,21,183,250,40,230,78,222,159,74,94,13,20,247,51,90,218,253,125,50,81,72,93,1,200,50,199,223,192,197,223,38,208,98,122,118,7,82,178,154,193,50,199,199,7,184,231,120,39,2,232,41,182,32,75,56,236,176,5,0,113,190,13,109,1,175,212,249,89,21,130,204,162,228,119,244,190,87,252,151,13,40,209,103,93,95,199,103,141,133,122,94,189,161,222,26,229,214,114,137,110,97,84,81,251,213,80,122,215,144,113,154,105,12,130,191,24,0,226,159,46,86,119,142,104,231,72,118,224,91,195,94,179,212,168,32,243,2,25,219,4,197,34,167,252,198,18,155,87,88,62,165,118,253,176,96,152,186,128,214,140,226,59,11,113,104,102,96,136,126,9,13,140,165,46,116,134,52,249,105,131,168,226,83,93,216,194,247,236,251,159,42,118,243,93,85,175,120,106,134,75,146,217,187,183,49,138,190,5,189,3,203,106,166,110,104,108,70,111,165,41,203,34,212,254,32,10,2,238,30,243,126,47,119,175,63,107,73,75,131,105,17,54,253,158,128,179,196,198,64,151,178,55,47,159,191,106,78,234,208,198,108,42,131,2,33,44,121,43,48,137,107,252,205,15,84,242,200,169,148,239,199,117,248,6,151,51,83,45,149,57,75,160,202,27,122,235,14,50,90,135,90,94,140,171,241,123,236,90,200,243,190,6,111,165,246,139,34,141,151,172,38,34,66,201,218,83,110,52,12,146,6,26,248,102,120,174,193,25,147,171,152,87,174,79,55,208,166,73,111,90,214,25,117,239,102,226,213,182,128,93,49,129,174,3,2,180,9,250,166,8,32,141,187,26,55,157,229,144,64,195,91,154,133,56,176,6,198,60,119,115,232,70,213,143,59,250,97,136,50,75,125,198,19,151,141,168,48,163,47,67,211,114,119,103,69,9,119,244,236,196,164,248,228,69,215,205,245,16,57,177,244,43,224,109,172,45,14,5,161,195,63,81,38,117,19,125,248,179,103,199,168,84,151,192,55,216,72,96,43,117,199,103,51,202,42,177,40,169,84,157,153,173,244,141,108,142,38,188,53,35,151,221,147,12,148,111,151,129,212,37,253,142,191,152,21,241,153,150,30,71,95,49,124,83,150,47,109,169,199,96,70,141,167,74,79,11,152,159,93,215,159,185,141,249,140,114,217,75,87,133,177,114,114,27,32,86,10,246,20,157,127,160,164,227,79,194,177,107,49,142,179,84,144,135,178,81,30,7,228,120,116,11,103,210,83,15,94,77,40,116,144,27,125,81,192,231,217,112,4,184,78,6,144,65,184,221,84,114,52,150,241,217,130,114,219,252,15,34,244,209,76,178,193,231,229,38,137,147,0,147,242,150,26,33,32,28,132,60,63,134,221,9,214,135,97,120,217,109,78,130,199,253,153,215,234,19,186,201,199,169,20,132,151,74,179,54,65,25,171,126,126,88,23,247,222,39,52,65,85,45,245,229,214,38,98,14,0,10,216,42,17,230,34,91,84,144,209,31,186,211,140,175,188,80,202,99,174,124,88,40,32,214,235,133,253,145,179,186,102,42,135,61,67,235,163,133,41,35,25,168,87,141,24,186,210,233,150,19,220,120,81,123,169,245,18,197,27,207,176,15,197,115,139,69,152,82,211,148,77,184,232,173,29,253,46,123,173,245,217,54,231,135,218,236,101,196,45,109,136,189,206,68,215,214,77,251,43,39,224,144,62,135,50,114,247,67,110,247,38,143,220,5,1,173,142,88,7,149,152,225,194,10,114,152,121,105,239,242,249,117,29,172,2,39,98,218,33,31,69,93,11,210,222,132,40,251,162,173,144,13,165,165,242,181,202,215,89,196,228,253,39,70,73,153,144,63,184,211,2,204,107,51,166,197,173,14,15,96,66,141,11,12,244,148,50,16,214,9,8,52,6,165,105,91,184,10,10,62,135,250,200,159,69,227,229,86,98,229,73,27,200,217,108,233,211,81,90,93,45,50,50,149,19,35,23,116,202,113,21,211,33,217,140,128,86,228,185,130,140,104,87,180,174,131,213,254,48,90,67,239,159,204,139,229,42,236,142,82,151,187,165,11,12,150,53,56,10,76,97,213,117,217,51,242,133,135,229,78,117,95,26,31,69,32,138,147,70,226,136,42,0,8,199,224,233,35,206,48,207,61,99,52,101,204,118,143,245,236,120,33,226,57,223,53,32,255,6,236,127,223,89,137,99,84,204,80,106,20,237,64,149,193,65,7,41,202,120,56,115,112,137,35,254,243,28,47,4,229,33,115,177,48,219,231,48,63,139,95,214,209,6,170,197,116,222,104,88,254,141,16,48,222,226,9,47,121,65,188,142,38,129,229,60,122,25,131,229,78,249,211,139,93,199,181,248,231,247,38,161,131,223,146,216,88,123,189,77,186,220,2,185,53,173,226,101,153,213,103,171,140,207,44,51,120,168,36,182,213,176,87,166,170,61,250,49,139,249,215,135,168,170,59,95,118,142,249,166,177,121,94,175,159,219,228,219,117,28,222,43,180,225,108,140,7,25,5,94,45,171,5,65,137,255,40,123,190,89,181,94,76,172,91,161,197,240,85,79,172,28,47,57,205,233,102,137,143,28,155,20,20,157,41,148,175,43,167,5,82,171,148,109,247,237,236,176,176,124,1,158,189,93,168,51,115,231,208,228,55,164,123,212,27,25,190,38,1,120,25,153,91,236,95,116,67,210,173,224,156,220,91,207,120,91,114,212,191,71,198,205,146,136,65,91,33,204,192,154,155,243,71,11,55,239,100,89,204,247,199,59,120,22,68,109,137,194,203,81,61,247,11,226,242,210,155,195,209,1,193,108,163,178,20,22,170,30,148,214,80,229,153,91,103,246,237,10,245,110,211,150,205,98,239,92,94,71,206,91,253,204,90,157,216,152,35,148,167,8,201,167,24,239,191,158,102,23,131,159,64,99,81,159,58,193,185,68,1,28,24,38,198,132,80,191,19,122,235,99,129,100,49,253,29,52,194,32,108,106,166,243,179,53,189,96,59,73,241,61,32,223,84,218,118,59,32,64,9,98,239,207,219,101,38,106,54,148,148,25,5,50,107,106,152,242,117,192,102,56,184,19,232,133,157,243,182,52,144,217,94,101,153,221,88,157,52,224,159,93,159,71,2,115,200,230,116,202,177,236,75,20,176,16,39,147,24,150,195,21,251,77,57,185,113,216,168,48,127,164,56,104,92,23,85,141,159,93,53,192,103,163,130,24,85,85,160,61,246,23,185,196,18,158,228,129,148,126,206,52,198,191,182,12,98,112,31,56,160,62,208,196,234,1,56,249,23,61,115,25,164,254,151,45,11,124,107,53,151,131,221,52,249,185,90,5,4,129,177,134,168,239,37,50,111,225,178,53,251,9,5,87,32,111,75,239,38,160,33,50,128,211,5,250,31,61,177,31,115,182,221,118,33,225,75,165,5,43,89,152,62,217,185,246,122,194,98,47,193,42,74,46,144,111,16,231,76,88,151,7,93,68,144,237,82,117,206,167,239,6,137,55,125,14,88,92,201,143,148,62,216,55,224,150,178,38,77,42,167,163,233,124,131,220,55,50,219,117,225,244,220,233,124,27,133,246,213,86,54,152,29,92,98,226,98,54,110,144,186,41,161,225,72,199,30,105,121,160,56,141,23,100,40,88,208,169,32,196,122,95,231,57,244,199,120,13,232,165,250,170,24,34,231,23,205,33,18,214,128,56,165,14,48,104,223,133,183,73,58,100,111,112,115,239,70,81,81,38,94,88,232,164,212,242,0,59,114,36,133,89,252,41,204,37,193,144,244,255,242,124,20,131,112,126,131,187,205,71,229,86,90,197,199,245,45,120,190,56,223,164,63,177,75,188,238,180,176,137,182,95,221,29,158,104,4,224,38,183,94,172,67,44,62,168,237,218,85,159,58,25,168,173,108,204,228,81,18,145,207,176,19,10,212,78,133,108,169,178,117,11,19,155,152,200,117,243,99,143,126,93,75,167,4,103,249,245,27,30,184,78,162,35,174,200,4,59,119,138,195,58,130,59,179,147,48,207,134,201,207,31,90,145,168,212,195,79,220,16,253,80,24,42,159,61,178,241,81,140,246,198,225,166,94,74,63,254,3,218,93,2,74,194,239,192,68,55,75,132,51,79,200,162,72,133,34,87,86,7,157,235,37,94,78,191,150,81,213,162,147,20,232,243,173,36,1,244,91,3,192,10,224,194,229,74,147,19,192,165,168,153,5,127,230,113,185,206,127,146,80,114,246,179,16,31,90,0,242,254,82,189,36,246,211,7,118,168,33,154,220,184,107,101,40,150,196,194,242,253,216,72,132,210,147,230,224,198,34,75,25,74,233,205,159,168,6,197,50,217,127,251,94,27,0,89,55,171,138,10,197,251,46,127,84,139,97,212,131,44,89,5,181,154,11,223,2,106,249,29,222,72,44,89,57,56,8,138,102,140,86,159,219,77,239,32,203,126,142,214,192,72,16,119,161,71,155,250,58,115,189,112,51,213,249,25,85,78,170,171,102,164,103,133,109,37,229,130,167,116,64,21,234,76,246,89,206,141,235,89,223,141,56,47,168,166,97,190,26,197,70,97,133,200,148,53,45,183,39,129,38,122,174,116,58,75,115,221,204,101,52,24,94,177,14,237,2,172,234,210,8,208,25,77,235,113,24,108,216,242,184,180,255,173,101,240,51,246,200,240,13,156,209,93,60,66,170,252,82,230,13,215,146,117,255,210,7,34,122,10,106,156,176,21,68,222,248,33,83,152,206,191,60,18,158,149,114,74,41,60,203,244,210,249,189,212,25,25,75,131,95,76,207,254,188,23,124,249,162,255,170,137,0,81,97,181,221,127,2,120,240,234,80,28,115,105,158,136,89,77,135,103,255,251,8,186,242,63,176,164,122,8,11,128,19,58,243,8,212,252,204,84,170,108,158,179,247,0,254,32,87,139,213,136,45,180,92,145,67,92,246,247,205,97,103,87,101,163,137,0,61,23,230,147,218,153,102,235,104,17,24,246,70,190,79,179,238,178,41,56,128,115,241,148,114,229,173,144,63,54,151,123,191,45,145,222,89,230,29,59,34,163,123,120,56,34,137,149,161,32,221,255,87,39,50,57,112,84,159,209,51,170,143,167,190,117,145,202,12,127,248,132,142,52,118,154,247,22,242,179,161,240,146,155,7,176,79,18,1,228,242,227,81,34,121,92,236,105,176,207,233,51,86,159,119,70,173,14,42,103,31,241,149,157,98,49,61,96,106,94,142,12,146,88,63,16,173,84,14,216,170,188,7,119,188,94,156,24,78,218,117,39,252,216,201,136,241,118,24,231,164,15,9,211,193,68,14,9,140,214,99,95,235,172,219,136,83,12,95,75,88,48,152,236,153,95,137,236,38,125,35,176,220,87,52,101,106,40,172,224,140,105,118,201,227,143,43,59,162,152,247,197,72,70,232,183,21,160,2,64,169,41,69,166,102,52,189,217,130,19,196,230,34,133,35,31,17,193,45,252,112,79,79,223,99,168,154,14,19,74,179,41,246,27,199,128,101,54,80,252,173,165,241,80,26,204,142,255,57,94,25,56,246,22,133,229,144,110,212,118,251,36,49,81,254,183,116,222,99,70,181,22,74,96,199,161,124,176,7,199,9,56,128,64,200,185,222,37,225,144,156,152,22,99,76,208,43,99,207,169,146,220,182,136,30,96,166,118,49,125,40,132,106,49,212,158,91,55,84,208,213,75,63,190,113,71,83,98,109,21,176,11,204,253,157,79,106,111,232,239,253,187,98,141,32,52,39,209,183,100,176,183,32,232,137,209,189,13,67,230,44,99,233,235,31,211,62,149,120,185,114,79,123,8,153,151,112,255,65,154,228,16,226,177,21,18,10,146,172,134,181,123,4,253,122,188,229,98,89,112,147,19,145,108,246,176,210,201,128,231,96,230,39,140,7,175,246,144,253,114,34,223,14,48,134,160,78,112,135,138,197,142,208,213,221,156,197,198,131,42,169,203,191,140,36,205,131,59,11,239,147,205,235,193,132,59,199,198,42,204,244,120,24,172,221,253,85,141,118,110,76,153,91,146,222,142,200,251,52,172,145,250,47,123,86,49,253,220,27,77,170,51,36,179,148,26,32,251,162,197,246,163,248,65,123,233,68,194,166,153,206,118,238,22,134,49,13,218,176,11,183,124,197,148,169,251,224,80,11,209,166,233,229,19,220,114,244,144,246,17,131,119,108,78,6,26,238,121,82,13,57,179,139,149,164,255,235,181,20,240,76,155,71,61,89,192,100,16,244,93,71,199,139,70,203,107,44,233,154,66,40,255,1,15,20,206,89,244,23,68,123,164,177,175,187,170,150,195,150,44,96,99,142,169,220,220,197,235,124,72,198,60,112,180,196,35,190,154,107,29,177,10,243,111,210,61,157,156,223,255,101,5,210,27,224,15,23,138,119,65,201,139,134,84,70,122,22,204,153,5,193,108,54,149,173,173,37,200,81,229,93,72,7,45,14,51,177,85,166,96,189,55,43,70,88,172,251,17,221,163,81,62,196,216,14,31,82,46,38,65,125,42,32,4,9,145,100,31,102,106,231,86,31,167,246,39,11,28,118,34,92,179,80,65,191,115,43,247,211,118,115,124,156,122,145,222,177,73,161,7,117,51,20,29,178,100,26,127,202,208,177,209,121,101,140,194,20,229,139,123,55,186,209,31,33,39,115,64,97,128,152,60,147,70,35,97,4,156,87,181,58,244,132,109,115,229,91,215,10,28,25,21,57,163,234,21,101,81,18,220,78,130,105,85,41,164,78,228,156,201,182,234,93,221,241,194,212,66,84,4,11,81,116,94,234,37,200,8,214,228,253,58,205,250,62,168,189,1,46,223,0,158,154,29,127,247,188,25,193,165,228,117,234,121,149,167,254,11,3,15,12,91,42,46,11,240,230,134,120,108,46,58,63,23,230,140,113,173,206,94,55,63,20,187,32,255,142,32,192,135,161,231,95,115,204,50,125,129,245,15,153,89,124,35,87,200,91,78,68,126,100,158,103,224,232,192,132,174,34,19,19,48,139,182,247,255,70,88,227,139,253,31,10,222,62,188,140,85,169,143,143,14,29,108,159,46,98,211,30,129,63,149,77,230,246,61,181,103,153,124,242,214,63,70,78,193,78,208,159,94,20,59,30,81,88,112,124,123,183,101,239,217,86,232,137,59,250,5,110,107,71,27,31,15,33,62,200,161,218,153,82,134,5,7,141,180,7,152,169,23,182,33,150,252,223,90,209,54,177,15,50,19,8,253,37,226,84,143,33,164,230,38,215,102,42,156,198,36,35,149,175,75,79,102,252,69,215,7,165,103,252,189,221,18,204,32,86,110,22,47,74,38,247,11,126,5,145,242,247,20,9,190,177,121,79,16,110,73,41,45,141,3,247,35,3,252,191,45,7,156,127,115,198,74,194,5,25,124,110,61,109,115,151,84,72,182,140,170,23,217,123,133,98,143,18,53,128,55,78,61,89,152,214,253,63,133,196,183,215,107,107,158,245,129,15,153,169,246,158,65,172,8,47,226,30,126,10,64,163,175,108,218,130,19,89,235,34,206,150,176,199,6,140,234,201,165,130,107,208,64,112,36,44,115,250,199,236,204,60,127,43,124,225,163,49,76,103,210,254,126,180,82,44,230,68,93,12,246,201,186,72,190,172,76,128,42,173,0,221,120,14,150,19,197,121,163,71,111,214,183,143,24,187,70,13,255,228,250,134,173,209,183,166,208,21,225,94,109,145,98,70,255,76,151,190,150,183,152,248,238,224,187,111,4,2,111,236,73,135,133,67,34,193,94,52,159,42,187,59,38,75,152,72,134,112,236,191,233,150,43,156,14,167,70,226,7,114,200,31,140,164,33,84,232,169,15,96,172,175,192,57,229,71,227,101,139,17,90,45,154,32,255,204,159,141,200,159,147,45,152,135,128,51,11,78,181,154,83,92,144,157,134,244,234,140,201,95,218,104,165,146,35,28,223,139,111,128,149,30,162,119,191,217,136,196,219,138,212,22,168,182,19,118,34,168,68,234,104,231,59,166,128,52,254,212,215,218,117,66,31,249,88,61,78,33,130,242,94,66,17,169,102,100,130,251,1,125,169,71,110,165,239,246,162,251,220,185,184,20,76,133,171,122,57,219,218,181,169,220,38,166,27,206,53,166,180,135,172,64,7,187,131,182,110,67,34,191,25,145,197,184,217,30,140,72,15,212,194,123,34,239,194,64,110,117,35,199,82,17,157,252,230,226,228,44,151,158,81,101,191,59,18,175,143,139,235,12,185,50,15,106,29,143,82,247,211,52,208,35,153,64,11,50,37,13,38,232,128,45,104,62,240,201,122,137,83,140,250,178,64,142,202,168,54,119,221,215,71,166,35,108,71,223,239,99,153,12,8,134,64,200,182,235,107,96,111,231,153,200,254,189,247,49,93,127,4,200,77,43,160,120,224,252,243,224,46,190,166,143,82,46,207,86,235,116,203,190,88,18,55,121,70,227,215,107,69,58,245,221,133,33,73,230,34,36,254,49,127,129,180,253,175,209,180,54,94,124,96,104,97,243,225,38,248,166,230,189,233,78,38,61,122,43,51,76,9,219,127,1,239,79,151,48,213,26,208,118,80,108,178,180,167,38,224,5,87,106,12,73,252,109,195,190,244,1,237,106,212,236,116,74,192,255,121,219,152,67,18,77,38,21,51,27,121,200,196,0,84,219,179,46,124,54,85,12,179,49,241,46,197,14,33,28,79,227,246,94,112,66,187,209,230,116,161,40,15,78,57,156,110,138,178,73,41,255,178,62,43,236,180,171,248,21,243,240,13,110,71,67,79,176,57,76,207,194,20,219,223,36,60,83,50,200,87,245,137,235,132,89,144,67,4,174,55,221,14,212,138,175,187,209,186,54,80,178,238,243,36,9,199,108,128,111,120,61,208,105,53,44,233,236,78,63,226,71,197,238,242,101,100,227,70,160,209,41,198,56,65,115,138,237,132,126,95,23,46,122,98,177,164,159,251,98,212,145,111,203,95,36,21,53,163,88,57,51,139,255,60,181,38,187,107,75,128,165,215,232,130,56,103,173,192,192,119,72,104,142,246,79,232,200,17,207,225,61,55,106,74,61,126,180,229,233,187,223,190,82,11,232,15,84,52,13,98,154,199,134,191,227,132,219,235,17,230,249,92,249,34,165,54,132,101,234,209,220,66,6,69,181,50,132,160,155,246,171,5,167,56,49,27,175,90,222,36,13,217,116,128,9,151,3,203,43,43,40,205,132,14,248,28,88,180,107,146,95,19,175,0,109,41,170,148,148,54,179,0,71,101,59,99,221,143,205,42,59,156,112,136,31,59,18,231,136,191,41,46,122,77,101,152,172,123,108,116,111,53,229,4,163,218,156,39,171,198,100,223,236,90,205,126,143,72,67,138,159,241,118,154,239,154,219,34,182,123,33,163,113,46,15,249,238,36,50,215,132,241,226,207,196,181,96,162,212,88,224,190,81,179,12,136,146,122,238,83,129,26,72,105,125,20,146,253,67,112,232,12,188,96,52,161,160,121,241,50,77,49,218,20,78,169,246,196,95,213,12,11,243,170,71,1,244,78,233,115,143,34,201,250,23,100,9,97,17,4,211,193,128,42,106,170,138,9,75,28,208,247,157,32,4,210,106,87,15,97,167,209,22,160,123,52,183,148,194,21,14,53,212,119,43,76,147,154,56,43,175,79,109,103,68,93,115,95,230,242,89,230,162,136,47,37,79,109,220,24,217,83,40,241,45,113,250,138,133,115,120,72,115,222,65,36,226,44,1,172,128,192,152,113,44,162,139,24,194,114,139,90,162,31,228,198,129,96,97,224,87,232,183,43,193,104,251,129,67,148,240,227,100,4,27,202,89,241,226,221,189,142,102,74,1,234,197,88,247,95,217,142,161,58,118,124,174,252,162,242,248,126,19,199,138,191,202,209,59,204,127,100,65,187,50,108,197,107,107,205,55,228,48,246,168,68,28,74,186,102,54,116,29,188,57,221,206,122,202,240,151,15,23,162,146,91,12,88,51,69,3,110,205,52,5,186,49,46,171,126,221,23,30,236,45,162,17,198,211,238,177,147,106,5,203,206,78,143,1,167,153,96,15,225,28,219,223,209,68,221,218,102,32,19,138,90,130,254,63,73,240,165,99,150,83,198,65,210,22,92,216,204,186,182,213,249,35,2,80,190,138,101,47,225,210,232,29,85,90,174,228,82,244,173,189,193,47,20,238,93,189,172,27,25,87,244,243,224,87,201,186,153,42,69,160,195,77,180,136,128,231,197,161,163,94,0,191,87,57,125,254,155,170,223,110,165,95,181,188,82,153,240,68,118,58,137,253,184,248,35,170,207,20,197,246,93,21,36,48,195,147,75,92,94,166,34,77,198,225,189,122,91,111,136,32,138,146,132,33,113,35,32,184,97,10,255,132,98,61,203,100,65,30,160,150,30,85,22,8,32,101,187,142,240,176,3,67,219,207,113,202,242,213,177,61,155,141,225,69,7,10,3,184,65,132,69,241,149,214,97,91,168,150,187,136,18,190,15,66,134,232,239,202,169,247,10,160,246,157,238,77,41,185,221,165,157,108,94,145,231,229,169,101,1,167,15,161,20,158,211,139,204,107,228,206,211,185,65,246,158,167,12,107,190,45,182,28,192,44,106,148,62,159,222,82,10,227,237,251,3,151,152,139,76,162,183,169,202,107,181,200,129,195,124,71,208,135,234,26,203,154,53,208,137,99,150,100,142,114,50,153,183,126,133,1,253,9,202,235,65,46,106,126,8,5,105,93,53,17,35,209,62,117,114,152,57,29,66,71,127,2,130,103,158,7,17,86,195,64,229,219,75,195,212,33,209,50,154,59,27,177,135,24,163,107,219,137,197,220,7,153,96,131,0,65,187,83,25,18,15,100,245,27,6,174,119,25,182,124,115,158,7,84,182,105,34,75,231,222,190,48,233,221,49,119,79,153,174,200,28,223,87,37,72,254,237,189,199,23,239,255,69,27,152,251,104,233,142,231,80,48,149,197,234,170,200,149,73,120,9,20,212,128,69,99,144,23,22,83,89,207,47,19,17,198,156,214,226,55,130,85,146,54,5,58,224,214,6,27,36,31,164,126,182,225,53,4,52,100,11,28,220,125,41,101,102,215,188,97,6,55,113,252,140,78,81,115,58,203,129,115,132,109,206,21,68,78,20,128,95,62,34,72,211,75,41,78,234,223,115,175,57,229,107,227,179,9,162,15,86,211,207,126,44,120,162,65,99,15,187,57,91,18,41,138,119,15,37,90,138,187,40,13,121,164,30,26,160,7,116,143,9,149,10,228,215,85,75,134,113,241,72,248,12,116,160,177,187,166,188,208,252,178,182,169,220,121,139,203,135,116,198,224,193,215,214,189,110,168,68,129,130,192,8,226,15,122,181,16,37,227,17,156,38,246,249,4,89,193,12,237,32,109,66,52,139,50,235,10,231,210,19,204,191,161,192,238,27,142,203,62,146,194,119,135,132,70,245,214,127,209,179,254,19,43,72,110,124,118,71,34,142,134,163,182,130,140,131,160,56,194,13,10,6,8,136,131,171,206,237,108,163,127,8,17,208,116,17,165,125,236,166,45,180,115,123,110,117,255,84,33,201,176,66,60,220,2,92,128,59,50,147,27,232,7,251,48,118,128,215,225,182,113,163,1,165,184,212,132,246,28,57,13,84,140,97,222,230,172,120,254,160,216,70,239,215,0,111,160,68,51,0,31,109,79,49,38,221,94,95,37,226,200,239,75,160,227,1,122,27,49,244,122,133,67,125,60,12,216,60,89,219,92,146,252,169,205,31,71,112,119,174,142,76,205,10,173,28,31,26,119,222,159,151,151,214,150,124,197,51,174,17,3,58,240,120,130,175,51,87,155,106,76,197,143,86,226,95,45,72,196,34,230,99,248,121,236,163,207,67,132,152,165,42,252,107,111,171,10,114,221,71,94,190,87,197,251,236,116,86,60,82,253,64,166,236,178,150,126,252,230,179,186,45,52,123,29,16,175,237,157,13,213,215,69,153,217,233,51,38,227,186,80,200,188,65,110,196,78,3,202,66,175,161,253,111,249,120,23,44,176,170,211,138,243,128,128,115,108,85,27,23,107,91,1,212,31,154,136,228,166,30,96,59,92,34,162,61,242,225,232,47,195,154,45,144,74,125,246,69,128,166,229,187,39,196,152,5,66,133,189,18,245,235,31,214,153,14,205,11,130,1,238,167,83,107,14,41,235,8,139,62,37,74,87,110,189,142,226,150,1,219,52,58,115,150,62,55,66,239,30,11,157,138,57,159,200,148,184,237,250,169,248,88,159,137,188,98,30,50,189,59,15,225,149,129,184,102,146,114,254,181,178,143,54,171,186,63,219,29,83,52,76,222,208,189,242,11,81,188,87,249,54,213,162,246,147,7,72,54,22,48,119,146,108,131,16,194,137,175,45,132,109,33,243,243,40,190,135,54,116,177,29,228,193,151,91,207,114,183,37,198,58,44,53,196,42,118,27,144,95,155,137,80,255,233,76,228,204,81,135,24,99,82,230,130,134,134,90,185,64,21,78,113,200,124,44,66,8,202,250,219,158,245,90,117,100,130,99,79,193,113,76,66,140,147,91,76,194,35,42,183,235,58,162,251,48,190,103,86,96,173,72,202,179,222,118,203,182,225,42,46,211,245,250,204,238,192,46,2,210,178,141,212,84,160,233,228,60,100,58,151,244,252,138,108,189,119,187,104,222,9,36,11,182,33,204,41,164,233,176,152,233,86,233,50,206,99,64,128,110,66,233,201,123,179,225,189,88,55,210,152,178,238,149,204,213,200,212,190,228,170,205,255,165,46,209,51,91,74,229,36,181,120,52,6,82,169,229,225,218,231,110,222,218,6,179,193,106,30,34,243,244,157,149,112,198,254,119,89,250,217,97,62,28,209,188,203,80,211,129,242,222,66,129,254,133,112,29,113,174,62,6,239,237,224,23,116,214,189,215,75,239,171,17,204,68,178,19,31,37,201,108,153,71,126,166,217,28,201,87,186,193,62,200,110,44,41,74,172,66,60,174,120,134,18,85,137,113,240,138,170,198,225,97,115,26,202,243,51,96,31,18,185,179,52,52,98,63,170,11,216,247,18,9,35,203,107,220,12,6,21,178,236,232,102,112,57,211,73,9,28,24,100,146,157,25,199,182,169,71,71,6,60,175,82,210,8,190,110,18,136,70,15,43,13,60,52,12,43,123,111,248,2,36,45,160,215,73,52,54,36,80,105,210,238,113,115,116,84,251,91,72,109,192,195,188,108,51,89,2,189,86,142,28,210,69,246,138,253,85,224,49,223,6,47,125,40,72,173,56,214,70,132,134,51,244,168,101,112,151,126,77,102,143,239,4,13,116,106,10,103,119,126,65,6,31,18,107,68,76,241,127,130,133,186,61,250,68,253,189,150,134,117,83,51,83,25,187,118,78,134,35,123,184,148,245,53,68,14,88,131,0,68,159,141,48,76,196,130,198,34,56,19,203,64,75,87,26,133,28,73,19,242,167,183,2,251,172,114,9,7,155,151,79,86,68,141,54,101,212,74,210,65,219,237,175,83,252,71,245,207,108,46,196,105,180,46,85,217,5,128,221,226,157,62,176,224,25,140,26,228,142,51,187,96,116,42,92,18,197,211,133,4,0,207,161,141,187,60,8,215,220,174,187,41,153,27,83,242,133,205,30,135,7,207,178,168,111,3,85,173,149,137,68,187,204,184,237,209,59,41,154,36,35,7,212,199,183,241,25,178,86,195,41,137,201,81,164,246,218,251,180,218,161,189,193,147,17,147,15,78,69,23,170,86,93,28,58,170,81,208,143,20,240,63,182,158,203,197,94,135,254,11,135,124,183,89,193,71,88,184,98,208,164,134,197,140,75,234,159,83,20,177,109,123,195,118,229,245,116,207,220,6,11,187,253,37,198,220,195,29,176,38,46,67,200,232,90,245,23,105,165,133,57,29,208,185,232,69,180,3,5,19,111,91,226,98,197,90,102,20,243,203,137,88,156,217,18,24,141,253,17,194,150,75,120,212,232,5,187,191,80,176,71,27,94,71,149,230,108,103,17,129,248,166,186,196,171,152,249,136,146,130,38,204,223,106,175,46,105,241,113,125,212,159,243,233,110,229,177,187,141,186,157,99,212,232,218,25,58,4,212,122,110,11,236,187,184,12,168,127,135,212,37,81,184,79,102,171,143,151,189,158,113,56,80,94,110,58,223,118,37,73,53,158,134,151,251,250,216,143,88,233,8,206,211,238,115,195,53,186,238,140,128,150,50,225,14,236,49,195,224,75,85,229,24,20,244,72,136,144,15,96,152,6,156,158,133,144,200,229,50,186,234,205,77,101,31,5,147,136,55,31,158,100,141,179,213,225,15,161,176,225,156,40,169,60,57,227,45,170,44,97,107,83,178,31,102,192,84,212,43,159,32,188,252,47,248,53,6,68,8,126,187,27,46,133,214,4,199,153,29,177,123,35,170,100,66,253,178,46,37,206,97,62,17,208,98,178,195,223,64,76,251,94,132,241,102,36,130,182,53,98,94,253,122,211,197,204,144,195,101,203,40,158,215,192,102,44,87,233,61,81,147,158,79,117,222,27,26,219,168,15,59,142,65,113,172,49,253,190,191,188,12,59,244,226,238,7,59,116,34,120,56,20,118,83,59,78,142,79,43,150,41,207,228,35,234,182,14,86,50,120,254,31,74,82,5,29,39,173,104,87,10,249,237,158,29,211,250,239,50,64,90,200,107,209,100,26,135,182,38,139,177,27,64,6,87,21,235,204,230,235,222,248,48,156,212,204,138,22,36,123,3,40,93,25,200,55,162,51,116,3,140,58,246,81,78,59,89,103,138,23,220,89,171,48,48,203,181,80,163,171,109,173,17,34,188,238,42,205,32,106,18,122,80,8,247,127,26,32,148,141,138,226,57,27,129,234,74,40,235,202,6,106,127,1,11,117,117,236,240,123,227,139,185,241,205,42,57,186,237,83,21,90,3,25,88,42,109,224,140,238,11,177,108,46,111,28,229,139,95,217,72,101,173,235,131,28,2,85,51,19,52,105,218,235,176,84,57,140,165,80,238,93,92,6,47,138,188,132,100,36,219,223,236,201,112,201,190,0,20,146,68,95,16,147,1,52,108,54,185,188,154,104,247,173,127,160,214,230,207,56,112,98,105,62,42,66,97,101,47,220,193,114,23,202,61,21,118,64,16,191,112,119,123,20,117,173,202,70,39,239,112,202,66,142,163,211,106,89,2,97,150,55,78,226,111,190,170,144,53,195,72,96,89,229,178,153,130,164,161,86,154,154,21,95,120,12,31,122,50,142,245,189,124,17,218,35,201,75,20,203,234,97,11,70,151,3,185,169,71,243,91,56,248,117,103,8,162,90,14,193,33,124,194,169,48,150,40,80,127,37,151,74,195,221,99,145,74,172,228,150,120,147,204,160,67,110,187,30,236,197,101,7,127,128,115,7,243,235,20,66,101,40,114,136,254,206,220,67,96,231,89,65,202,234,82,8,131,187,238,220,213,142,223,77,25,167,69,68,87,110,101,200,142,51,26,234,143,164,214,134,215,222,141,23,42,75,147,88,211,199,154,201,24,72,202,13,136,234,25,52,120,254,136,185,193,163,187,133,84,93,81,133,177,73,126,136,46,251,136,144,180,33,34,18,230,128,47,79,79,106,150,8,58,160,248,106,132,183,215,17,146,173,177,243,32,65,1,175,14,45,235,55,127,69,29,175,177,184,199,168,231,173,143,212,218,44,28,243,157,87,243,247,193,142,155,49,191,221,140,235,246,53,125,204,139,60,232,18,220,63,106,61,252,172,154,140,47,208,189,55,163,20,44,108,250,50,252,255,204,45,52,2,76,66,64,241,107,21,163,134,187,242,247,136,203,1,7,118,226,244,67,198,15,238,194,74,9,230,186,185,49,162,49,71,168,31,130,160,103,223,244,225,108,133,142,123,181,164,114,112,172,100,229,165,150,250,57,212,15,63,204,70,163,4,98,111,152,45,37,45,245,228,45,244,111,124,250,163,197,120,243,232,117,56,154,191,145,196,141,125,8,55,90,132,216,85,224,174,60,253,201,63,198,114,202,235,236,103,174,176,192,65,93,161,74,226,65,222,241,126,119,113,174,16,71,68,19,253,160,250,79,117,231,129,159,61,132,104,164,251,78,110,48,246,12,36,172,100,111,152,87,36,40,95,115,60,227,74,123,204,149,244,119,65,162,114,102,121,19,155,249,117,248,51,151,33,42,115,199,237,144,43,180,51,121,129,23,83,127,226,56,9,32,222,44,201,44,21,7,249,122,183,224,239,85,204,10,181,91,19,103,103,133,205,12,229,38,97,31,108,141,82,255,186,32,185,59,95,66,45,15,41,179,36,56,178,53,39,230,128,252,12,104,165,98,132,4,223,238,44,36,222,188,218,52,250,146,212,148,237,85,68,175,72,79,155,38,36,230,62,122,67,208,138,241,5,49,158,119,106,100,178,247,61,154,161,134,111,198,28,192,44,150,189,7,205,154,142,45,190,172,69,107,176,36,105,64,30,153,120,233,138,210,10,19,201,37,119,182,152,85,43,37,56,68,199,14,82,214,220,245,249,231,141,77,20,190,252,61,102,166,209,230,24,109,225,229,78,195,145,93,109,32,127,163,49,126,248,87,165,80,47,35,155,3,51,50,146,244,105,171,122,226,62,82,242,157,209,37,222,157,224,156,21,73,10,238,198,123,110,60,209,122,158,82,5,221,166,227,119,183,251,80,175,245,112,156,150,175,183,247,162,53,159,213,33,71,40,168,227,104,244,244,210,154,12,114,234,6,153,36,147,203,170,108,85,64,250,110,225,137,2,143,243,163,40,173,220,191,63,210,108,131,154,142,83,175,46,56,41,236,83,221,81,161,144,135,172,99,88,139,115,229,148,143,162,9,203,12,44,238,102,165,234,230,179,179,242,16,227,158,20,196,203,126,102,121,194,246,105,131,73,192,81,122,192,229,32,52,68,139,60,16,102,94,4,190,236,77,238,222,73,240,221,6,252,179,240,56,85,108,237,167,95,168,223,161,49,28,186,57,93,43,203,125,223,42,221,67,47,174,96,56,99,204,115,41,252,252,106,153,180,228,242,100,155,42,105,108,181,215,47,150,176,81,36,192,211,244,135,162,127,189,201,80,62,117,91,125,58,245,215,9,16,165,134,52,42,43,225,155,28,21,189,76,85,226,216,155,133,105,120,60,145,152,6,52,150,149,2,255,255,126,255,45,36,58,37,21,112,25,5,210,187,69,74,195,46,226,170,12,90,154,7,142,228,89,148,22,211,1,150,132,252,99,19,215,135,242,15,150,0,17,251,192,38,133,71,164,62,161,144,240,178,62,63,254,50,137,26,207,233,156,52,145,94,86,239,132,26,146,181,46,165,248,100,14,76,252,16,214,130,195,166,67,120,113,30,255,126,197,11,57,108,130,66,163,177,70,30,223,117,244,53,44,13,86,39,70,58,213,212,230,152,164,76,152,10,227,3,6,230,216,73,88,108,91,245,126,137,58,224,132,168,129,199,254,247,134,142,56,81,168,160,119,44,222,123,230,189,204,92,245,18,227,172,58,240,174,149,68,71,210,183,169,241,146,73,86,210,216,156,250,239,161,219,212,210,69,48,33,137,81,185,192,218,197,2,122,26,76,13,121,61,31,44,239,37,158,126,254,241,131,26,167,224,67,133,125,52,204,195,141,119,131,208,214,151,86,54,137,139,144,178,173,220,170,156,70,125,66,38,125,127,135,146,246,160,95,230,1,248,184,55,65,56,225,139,169,106,17,246,153,98,119,248,67,85,148,28,157,200,233,186,149,138,180,147,37,42,212,190,28,189,109,117,242,168,56,133,17,29,241,89,218,5,242,81,50,61,166,175,124,106,47,237,20,201,235,69,95,202,35,243,79,223,34,85,47,100,252,168,29,171,20,189,109,65,14,156,71,195,246,94,104,211,21,29,195,84,33,131,207,221,120,139,57,78,126,88,195,191,172,133,96,242,110,140,236,227,76,154,55,32,134,193,20,204,21,192,232,157,224,147,175,193,96,9,127,18,107,239,96,240,98,139,149,104,92,151,196,170,198,104,185,117,179,26,20,72,48,36,47,32,86,42,189,173,80,71,219,151,79,181,88,45,26,191,38,133,45,54,131,31,109,115,161,163,34,38,89,40,49,173,198,48,17,40,39,121,77,90,70,42,251,130,168,125,184,76,60,95,94,136,227,248,145,210,226,191,137,247,72,210,17,141,52,5,102,220,23,111,146,114,218,208,22,105,9,130,97,83,57,25,228,137,6,99,12,24,29,89,25,101,217,133,196,253,246,158,114,75,8,90,142,28,147,19,22,164,240,205,1,21,145,19,225,61,98,21,22,215,32,158,9,44,97,148,104,201,219,76,43,45,162,73,151,252,188,155,192,134,113,103,109,255,54,42,206,24,76,87,154,98,187,78,193,50,86,191,222,86,162,165,38,191,118,117,72,31,6,174,147,231,105,158,70,133,79,138,223,55,73,210,90,194,194,112,167,14,253,133,160,197,234,193,24,75,239,106,47,115,70,102,75,122,123,87,158,185,162,180,84,210,222,141,172,125,211,117,181,155,250,182,51,247,178,100,123,8,8,173,224,246,222,40,35,31,171,203,195,36,34,6,53,171,105,219,106,216,77,18,130,182,37,225,3,235,196,203,114,168,7,2,10,14,230,118,6,134,118,20,184,145,213,218,127,110,182,193,145,91,202,110,11,96,118,1,8,96,103,167,236,180,15,141,151,253,100,7,112,25,70,89,121,233,178,158,234,47,68,162,185,146,146,7,74,2,17,238,108,171,91,64,92,173,85,82,121,240,175,136,132,26,123,225,64,169,132,53,192,187,113,8,165,133,192,249,61,166,108,170,2,175,11,243,183,162,93,109,51,151,40,206,39,150,0,84,130,215,29,211,96,200,244,193,206,63,137,9,225,205,195,93,147,70,125,177,146,164,76,247,0,61,118,12,73,75,151,145,218,82,180,207,112,233,175,169,104,180,29,149,4,129,248,70,10,159,34,67,208,4,235,146,205,128,223,104,17,16,189,72,150,29,148,21,85,152,237,97,200,84,57,234,9,165,16,73,40,118,10,18,222,171,43,231,169,211,149,179,250,145,227,129,66,53,2,35,228,99,7,1,101,161,122,247,98,103,47,32,194,21,66,228,215,171,211,95,93,47,71,164,197,154,72,46,73,190,186,131,152,104,252,1,237,94,154,240,6,67,188,57,183,3,28,30,181,14,142,247,193,242,88,231,188,86,198,130,125,97,9,115,137,196,6,38,94,170,51,157,253,197,152,195,181,150,253,125,49,6,217,29,102,120,252,248,217,191,232,176,151,7,118,12,126,164,219,67,123,72,16,146,223,203,183,0,196,87,186,185,173,67,246,204,171,20,21,86,98,182,253,7,186,6,120,189,118,3,229,237,60,53,90,120,139,87,229,79,153,85,139,16,81,100,189,150,202,125,164,42,132,10,163,190,85,177,69,169,181,85,186,64,77,182,99,209,185,183,19,5,1,24,167,247,211,71,7,154,124,136,40,199,61,196,217,202,170,170,93,64,20,178,234,247,41,59,124,192,158,211,128,28,144,37,95,61,108,113,150,27,161,102,97,250,86,162,10,193,27,201,55,193,56,84,164,176,59,172,180,2,117,209,83,226,255,156,104,115,80,9,171,177,196,38,252,19,138,252,29,242,231,74,93,205,161,41,158,79,204,211,0,30,248,42,125,237,167,151,3,163,35,219,102,225,38,80,160,246,91,202,15,81,5,104,108,210,239,193,131,146,27,150,17,171,71,221,84,112,204,146,94,186,237,255,206,118,141,107,20,169,226,15,43,75,224,52,120,186,0,134,235,166,30,237,98,31,139,146,29,104,64,56,3,249,66,92,147,217,211,9,31,96,178,69,148,227,230,101,236,243,45,246,172,39,229,59,69,106,63,147,212,148,179,217,10,220,19,61,36,147,54,173,248,250,238,79,181,163,211,105,11,79,136,249,56,91,202,219,147,180,212,42,140,52,110,222,216,92,215,61,213,55,188,33,239,190,201,255,96,1,215,85,244,86,49,152,17,180,172,68,196,115,71,107,182,243,219,136,48,23,116,210,242,8,233,123,235,101,169,61,55,63,1,51,205,161,189,96,59,52,218,197,250,26,88,73,52,217,104,199,216,234,189,209,12,232,29,210,128,20,244,127,219,15,204,123,222,84,167,249,54,43,174,28,118,186,210,116,176,58,78,38,166,130,144,219,92,43,91,180,1,195,20,39,139,0,25,240,204,75,61,178,95,199,10,3,136,139,50,249,155,86,95,70,214,41,166,76,132,6,166,146,35,118,145,100,203,149,154,211,215,94,104,5,44,83,183,45,251,89,212,57,197,144,82,87,170,120,45,105,80,129,100,131,159,10,127,221,163,246,63,192,154,53,205,6,127,117,223,24,147,216,93,28,239,163,214,221,158,12,149,255,83,88,41,136,165,138,1,254,6,44,25,143,22,104,150,94,24,196,25,238,193,216,170,71,103,76,33,52,211,45,205,235,134,41,248,86,65,9,32,255,32,95,30,250,243,251,43,119,170,184,85,107,38,21,98,231,54,218,226,16,72,174,6,221,38,211,120,221,119,117,120,67,209,251,33,84,155,163,163,47,53,96,15,51,76,204,87,153,85,170,54,66,113,12,174,34,104,136,90,62,76,103,210,150,82,37,200,148,44,89,113,229,33,173,240,114,61,21,131,193,157,216,181,193,207,219,29,42,99,21,186,158,11,145,155,4,216,22,244,162,245,120,63,128,57,117,241,213,60,251,251,149,87,153,99,63,22,75,81,103,103,239,199,225,110,110,88,38,125,240,116,161,226,53,38,183,2,223,68,221,87,205,73,201,187,129,82,39,35,166,109,116,96,250,15,15,242,104,227,86,21,140,48,172,188,54,214,185,33,4,199,217,220,218,185,44,244,170,133,64,135,231,135,80,159,130,65,112,36,250,209,241,226,74,174,130,199,202,217,218,87,161,162,130,254,242,150,34,63,117,178,224,76,211,80,201,111,72,69,137,93,62,24,23,249,115,80,83,95,17,166,84,223,132,120,6,53,34,199,208,205,80,109,133,213,92,49,18,214,230,123,245,73,80,228,94,106,241,165,216,84,255,96,177,178,90,92,5,219,185,153,238,208,136,79,150,15,232,139,179,52,146,235,158,62,239,136,154,45,92,190,176,19,91,40,214,152,149,209,222,247,97,175,74,250,98,231,204,211,233,2,168,136,18,202,254,144,196,95,80,187,220,123,31,164,176,207,23,248,81,3,174,138,206,65,83,36,29,70,32,71,21,227,157,254,228,2,4,215,71,27,252,9,219,49,49,23,248,163,43,170,192,126,75,198,97,91,38,182,93,204,141,250,187,145,128,158,103,88,73,178,191,233,253,231,3,169,38,117,163,181,44,217,91,138,15,239,82,140,19,78,13,168,212,227,46,202,225,130,28,150,211,105,239,25,243,208,76,174,52,37,170,87,125,141,221,90,95,41,51,53,205,112,75,54,129,102,51,87,222,28,117,188,154,174,103,66,55,95,247,97,127,31,107,22,117,195,115,97,108,19,52,70,179,212,190,15,8,213,49,139,119,170,201,169,8,199,203,166,183,90,134,185,169,133,135,9,251,66,104,187,220,182,164,82,21,125,132,197,116,14,169,241,211,104,107,169,17,246,140,46,235,236,23,84,93,180,72,214,10,39,185,197,170,73,30,43,35,75,114,202,126,143,2,127,114,206,107,25,116,183,11,43,3,146,183,121,214,79,26,240,70,203,45,88,74,11,137,245,21,38,44,66,143,61,168,69,76,204,92,186,121,203,15,46,213,237,131,23,220,68,52,188,111,185,48,81,35,208,159,218,44,76,71,236,152,61,103,92,247,136,123,88,196,109,213,91,97,190,88,164,237,171,59,217,231,230,51,149,191,114,162,41,91,249,249,25,109,183,231,25,48,30,35,44,156,199,26,146,144,26,85,40,82,54,83,253,102,88,29,52,114,160,176,0,95,4,217,205,123,143,97,62,149,15,178,195,166,156,183,183,170,183,54,232,197,211,241,7,215,241,86,159,151,161,98,116,91,139,14,111,22,41,155,5,43,72,245,246,20,196,27,62,112,149,21,253,42,111,173,148,25,42,199,41,53,84,169,17,246,92,25,211,161,41,159,252,62,243,4,19,121,43,66,199,74,28,208,193,205,33,126,84,173,30,16,26,179,244,95,188,90,6,16,178,251,191,203,121,130,161,12,52,170,24,14,141,2,163,190,6,52,205,187,57,245,252,9,53,65,132,246,126,90,3,26,54,238,222,74,237,35,163,214,83,43,254,139,112,244,74,15,241,20,255,217,117,129,81,233,181,187,160,29,30,245,145,199,163,29,171,87,228,222,50,229,60,139,23,152,179,33,23,124,180,100,223,209,21,191,93,240,166,209,66,67,28,158,237,190,62,80,188,131,151,72,22,159,212,121,139,49,254,184,106,134,122,77,103,165,81,70,69,174,0,7,179,26,152,234,23,37,155,212,120,59,223,226,216,189,170,9,42,206,10,123,140,130,214,229,149,218,74,215,152,151,235,170,53,33,209,190,193,105,61,182,108,226,176,32,213,78,117,106,23,56,121,61,82,213,107,121,107,114,185,20,99,151,57,44,105,153,238,174,24,192,241,254,251,80,193,143,221,0,58,227,109,190,129,185,22,131,37,221,129,34,101,144,152,33,250,198,183,73,236,69,174,215,68,64,181,94,33,132,40,149,248,252,133,191,99,245,130,21,43,49,211,224,204,33,169,240,230,120,107,228,46,140,168,241,32,17,95,48,147,101,16,176,251,83,160,253,105,171,56,79,198,139,36,48,144,120,99,236,171,235,56,117,196,171,178,244,170,61,79,183,32,202,66,50,130,211,99,78,199,73,255,242,30,138,199,156,129,107,187,182,255,144,201,230,138,199,111,154,10,126,232,144,99,117,187,160,97,221,177,191,5,239,139,181,240,32,249,247,61,216,207,154,217,224,246,49,118,3,194,107,197,233,3,242,99,182,58,45,151,176,238,101,118,57,44,123,195,112,61,129,140,199,98,25,86,104,2,141,220,161,128,109,32,8,89,147,249,11,246,14,255,195,81,233,46,89,37,122,225,211,69,132,120,138,169,254,0,72,208,116,247,244,60,55,28,135,15,11,28,174,65,40,253,148,181,6,57,220,134,224,205,255,225,22,228,49,200,228,182,179,141,237,217,9,47,114,203,57,24,173,236,15,100,174,120,178,73,84,236,141,45,188,142,252,66,85,56,248,161,247,21,240,209,145,198,24,158,227,106,158,18,248,204,21,1,99,35,91,187,157,228,98,106,35,231,158,103,53,119,135,62,168,207,48,5,118,236,117,255,204,65,60,49,102,180,55,82,149,17,205,214,182,198,223,77,55,234,99,156,29,161,90,22,138,7,126,240,213,226,110,63,214,97,71,161,203,216,10,31,25,62,71,223,163,238,97,14,115,144,121,112,103,4,186,16,66,51,105,110,65,111,32,206,82,213,231,74,107,199,255,85,48,249,19,123,45,142,3,104,77,86,181,99,8,158,50,3,108,43,23,113,246,189,180,107,134,24,9,137,36,178,9,176,197,63,33,63,164,220,217,243,175,16,197,210,28,16,109,192,143,193,240,252,44,124,8,108,179,168,171,135,107,32,216,49,136,123,109,133,33,176,167,185,189,30,120,210,5,211,14,127,118,199,147,121,246,58,33,239,172,251,87,223,152,144,13,169,216,65,87,59,132,210,118,116,30,68,72,68,155,103,230,81,33,26,21,82,14,73,251,183,147,86,222,194,97,44,169,244,82,155,95,253,205,116,91,165,44,64,31,163,242,253,93,23,26,209,14,33,97,62,148,115,63,247,111,137,13,9,163,215,243,223,218,10,114,82,195,219,233,24,117,167,173,231,13,156,77,46,231,130,200,122,169,91,49,229,215,250,140,73,229,240,44,212,41,117,112,31,126,218,196,58,241,101,147,26,195,148,98,153,198,104,87,90,149,128,60,239,177,50,49,11,242,239,230,196,182,89,101,80,215,168,143,70,48,53,53,215,22,99,194,129,245,128,163,40,102,25,14,99,189,152,35,135,13,16,105,137,188,32,226,246,176,38,30,36,65,146,145,240,83,103,2,107,133,21,172,41,239,28,250,134,170,228,80,43,122,211,87,111,228,168,29,171,79,69,62,152,18,69,203,96,169,144,83,50,37,65,208,1,113,46,2,67,73,221,2,181,73,185,209,20,163,237,141,222,221,69,220,155,12,177,239,150,84,234,58,111,225,3,31,187,110,139,78,139,234,186,202,73,72,34,125,59,43,206,220,68,6,49,123,14,147,144,206,60,95,31,173,236,244,239,64,11,119,89,226,7,117,175,218,115,104,165,195,209,202,140,132,15,6,115,213,209,69,238,7,89,37,249,156,158,67,124,208,100,194,232,148,52,214,125,166,99,224,152,46,109,187,234,230,51,60,189,191,120,28,13,67,152,105,230,40,147,153,215,16,149,231,51,170,159,88,97,228,216,161,34,87,65,129,153,213,186,140,150,104,113,164,25,120,246,58,78,221,124,33,179,135,7,220,233,68,9,15,123,101,187,131,139,95,177,234,29,215,24,57,107,53,194,252,161,247,70,224,245,22,104,10,41,39,213,190,186,249,159,32,28,196,55,153,225,205,18,72,227,70,120,101,199,237,132,225,10,124,88,154,151,215,153,67,177,100,244,99,169,37,127,97,122,188,216,217,79,187,227,87,69,243,42,139,151,228,79,141,154,88,240,7,29,255,165,129,150,70,173,212,207,194,245,243,54,210,111,168,77,71,140,61,28,64,106,8,196,60,68,154,18,110,22,252,63,172,163,34,138,138,105,145,101,244,110,11,75,95,244,220,224,140,191,243,85,79,137,128,246,173,146,28,1,68,146,131,190,104,107,105,10,183,141,149,204,59,176,190,91,3,180,254,33,47,24,58,4,53,177,211,193,103,6,161,57,156,191,177,108,76,83,185,133,20,167,103,26,75,148,54,239,124,182,71,95,160,157,60,112,22,149,136,53,82,150,241,250,192,35,199,124,207,79,66,84,131,7,63,140,114,16,166,158,30,0,73,131,202,144,116,46,50,92,60,23,147,147,14,236,195,64,128,205,63,248,146,1,49,182,30,96,166,149,196,243,131,88,93,119,167,118,22,137,56,179,169,223,194,48,235,4,196,19,7,210,55,75,235,92,247,15,83,174,53,132,172,34,214,91,205,147,70,34,195,103,132,175,68,245,7,227,205,122,160,7,72,137,123,51,243,8,7,82,113,179,53,171,249,151,156,75,82,204,101,194,53,247,2,201,39,125,151,8,4,189,190,40,95,41,72,181,116,99,58,100,136,118,164,13,191,107,164,69,39,229,204,2,248,254,87,112,64,247,106,105,66,193,73,104,67,75,181,248,105,39,227,153,139,164,41,215,76,244,118,95,99,56,13,94,20,67,33,205,238,108,249,81,105,60,177,18,155,229,73,173,205,78,164,144,180,161,191,210,203,150,190,16,55,228,110,203,212,118,15,103,25,67,152,199,2,36,17,117,201,129,88,197,112,153,188,44,58,196,160,131,198,150,19,223,209,224,90,127,231,71,1,40,82,195,12,242,223,233,211,68,210,32,176,1,106,119,179,211,33,221,107,210,194,227,213,88,3,122,19,130,145,199,16,66,179,41,215,40,18,133,40,191,25,49,31,101,27,16,11,60,119,20,186,217,168,204,250,28,173,159,38,166,106,2,35,49,133,30,16,174,41,134,5,154,247,72,247,171,23,225,89,228,141,14,221,122,56,188,54,252,90,121,252,169,8,168,27,59,138,8,245,70,122,230,65,165,140,117,136,206,11,169,209,146,240,8,234,87,27,21,119,136,227,84,138,65,172,42,227,109,202,167,67,219,148,125,32,179,242,176,224,42,235,163,145,195,63,145,122,135,21,164,85,133,249,38,87,145,90,3,151,203,189,99,172,189,248,86,207,193,226,138,44,42,179,190,99,83,127,92,185,32,159,58,246,239,241,246,235,227,205,219,169,42,77,149,0,212,210,172,47,174,68,122,133,7,78,152,86,30,65,58,84,65,40,113,125,213,150,112,146,1,46,218,175,242,206,243,3,22,233,246,135,129,96,57,130,15,151,104,91,220,169,42,107,34,44,14,229,23,97,55,219,134,96,213,252,133,227,120,195,1,46,17,86,212,120,130,91,248,166,233,51,66,254,106,183,117,42,44,36,169,196,204,173,91,96,109,228,171,28,189,45,250,183,121,167,12,164,164,245,225,177,164,170,138,139,161,93,90,83,85,26,198,104,106,203,108,131,144,196,153,22,188,229,99,101,228,68,84,115,35,112,19,129,18,184,189,228,220,191,206,106,106,126,188,176,42,150,208,166,249,215,76,49,78,167,49,137,16,206,210,203,31,206,130,158,233,143,12,168,123,152,246,181,110,5,9,143,33,8,20,72,188,117,52,80,18,200,90,101,236,228,207,56,241,5,217,53,40,86,180,67,214,216,113,227,232,42,4,123,161,29,225,131,69,60,164,193,158,200,54,177,14,32,137,153,25,110,144,200,246,156,194,61,16,88,79,24,113,181,5,133,88,82,165,176,38,251,156,45,231,111,141,37,120,107,195,254,51,23,243,143,18,30,92,222,216,31,27,168,49,204,158,75,50,29,108,173,189,227,162,147,5,233,159,187,189,71,11,14,221,15,68,223,60,234,186,227,182,193,229,131,242,98,115,34,126,30,59,20,56,101,249,9,38,148,110,79,181,179,181,29,240,61,110,204,161,242,160,184,30,38,49,180,136,78,22,156,1,249,192,217,132,67,3,250,243,132,141,231,10,84,231,97,122,73,28,88,116,105,213,193,202,47,183,216,19,80,71,55,14,123,32,194,193,121,208,234,113,73,234,146,93,189,196,164,129,140,201,122,187,60,67,10,121,125,17,246,192,134,16,58,220,3,66,88,63,127,197,206,164,85,151,11,143,43,109,35,215,25,113,90,99,90,205,22,209,122,41,112,244,206,253,59,161,241,168,251,89,190,186,151,193,3,142,219,1,102,68,147,87,145,74,157,223,203,18,248,51,21,219,92,9,251,196,149,82,153,103,27,151,252,54,21,4,47,205,56,172,183,3,29,202,225,83,16,70,15,21,227,219,225,178,248,157,53,135,57,185,163,37,123,167,126,80,187,41,181,17,191,207,228,71,37,158,205,118,62,248,250,194,59,71,214,167,103,233,25,73,205,178,231,128,78,53,113,28,73,140,86,87,88,87,238,196,137,77,234,138,39,195,39,117,89,71,3,123,115,108,182,175,148,180,142,193,159,155,141,71,168,172,98,136,187,112,36,25,146,98,217,160,17,34,77,55,98,189,208,173,74,117,181,200,124,182,123,12,56,62,149,214,75,112,112,107,126,242,224,85,234,235,172,131,250,233,229,99,14,92,194,36,21,156,167,172,215,243,141,214,57,79,177,104,94,207,160,8,3,102,237,50,84,126,223,147,92,211,221,196,52,130,24,176,159,132,65,156,131,71,126,4,33,143,91,104,28,50,153,209,95,181,28,75,113,70,67,27,109,192,39,174,135,252,172,218,211,94,160,62,199,154,79,251,16,22,195,15,22,140,253,36,242,85,72,147,22,121,33,25,195,83,123,67,179,160,66,85,146,45,114,228,93,116,57,55,217,212,216,31,50,167,229,242,19,107,240,57,124,255,142,191,249,148,74,39,163,43,156,151,201,207,220,46,185,27,203,141,137,15,92,5,101,198,159,181,2,84,128,42,9,10,185,221,175,55,128,247,131,98,98,146,152,8,240,110,121,15,67,233,2,21,145,83,105,182,127,239,100,153,185,165,225,124,59,119,26,175,192,81,4,98,42,93,184,200,34,68,13,134,123,5,43,164,167,218,32,67,79,70,4,196,254,131,50,201,157,133,80,79,208,242,155,224,237,252,110,27,249,238,45,235,77,229,182,93,205,123,32,5,3,78,154,69,213,117,216,130,198,46,105,47,78,76,255,250,230,254,99,106,218,110,21,186,185,71,173,236,91,67,119,59,38,141,202,223,39,183,153,239,2,113,168,121,123,54,217,55,237,94,11,1,190,38,16,170,216,147,239,88,254,229,245,220,108,102,247,55,229,237,173,167,179,231,185,82,226,109,53,81,87,15,55,217,69,204,109,3,164,126,143,193,42,141,227,90,36,226,83,128,215,12,177,216,190,140,85,129,225,224,25,74,141,225,41,192,131,60,180,130,169,191,124,58,1,135,224,63,27,9,138,244,124,167,199,35,2,120,62,25,218,238,78,254,29,125,60,19,72,168,31,194,52,28,70,137,193,242,203,2,91,43,138,248,5,135,204,165,116,67,10,198,121,98,100,238,143,43,94,209,39,162,232,129,176,41,254,158,40,195,167,51,206,48,151,123,55,64,65,233,220,176,238,73,3,129,139,129,242,194,88,95,199,147,187,75,237,229,171,30,89,115,154,239,165,169,235,59,98,63,177,91,115,84,142,203,97,103,79,66,2,91,157,207,14,45,246,75,211,46,69,228,42,158,158,132,228,178,36,163,98,194,69,11,37,186,217,155,206,244,54,125,9,122,128,237,37,159,232,91,68,159,92,116,153,244,199,136,214,88,171,186,117,98,60,171,163,232,45,147,151,123,170,237,130,250,83,244,253,125,237,248,178,237,111,15,63,154,122,147,51,15,60,204,111,139,245,231,228,185,51,36,176,237,79,48,4,150,130,163,59,120,29,126,54,40,104,116,142,238,121,237,189,107,191,35,8,119,113,131,109,108,173,24,9,142,108,8,49,51,202,146,192,173,17,1,241,218,187,124,164,246,139,220,70,143,192,138,152,227,175,189,77,209,86,106,63,119,2,159,194,2,163,89,30,119,83,127,152,98,60,123,145,96,155,67,36,124,94,20,93,243,98,219,253,143,238,124,45,39,226,10,242,116,227,184,129,242,21,192,51,94,97,231,64,148,237,211,59,177,198,10,216,238,62,4,109,230,168,9,132,240,215,0,86,29,251,174,78,233,243,27,50,92,197,253,214,2,123,146,246,222,140,146,148,108,237,15,4,222,247,156,154,132,10,40,151,8,10,70,114,132,181,145,136,176,233,7,169,57,111,204,90,220,67,215,132,40,150,216,152,69,54,80,43,171,67,46,100,140,33,185,115,58,154,35,242,247,6,43,31,174,39,80,101,216,73,40,132,227,201,14,85,37,194,50,3,146,118,78,76,36,211,88,24,220,98,14,33,120,148,222,160,20,160,118,195,167,167,92,128,37,5,53,38,72,206,146,123,57,213,135,200,109,71,35,239,160,169,225,222,136,217,153,92,67,165,51,105,189,47,203,155,237,217,9,216,232,29,225,177,49,205,230,232,177,124,66,19,114,207,198,114,64,45,161,124,66,110,85,157,81,102,32,22,83,53,111,196,27,133,196,169,162,223,120,126,235,105,163,132,221,206,150,110,214,226,227,26,172,30,160,193,251,235,130,209,125,165,77,58,39,115,187,196,165,24,148,33,237,15,73,76,51,191,88,212,165,137,89,220,47,35,108,174,114,48,214,113,39,163,180,185,63,88,233,112,0,120,241,137,168,24,63,138,54,82,207,177,179,66,101,46,177,222,3,52,49,103,68,5,246,78,182,234,55,35,29,9,19,192,144,78,132,224,162,148,96,89,62,61,109,6,178,98,241,196,88,167,22,196,56,11,139,35,94,112,213,134,206,158,24,179,145,144,24,250,44,149,253,67,210,8,0,244,166,243,0,180,234,155,46,191,122,41,93,142,70,154,56,201,66,159,207,162,193,63,26,46,204,221,206,29,100,232,161,225,87,106,130,47,154,66,253,50,33,4,103,71,134,239,65,137,220,222,90,200,221,145,253,16,73,125,66,213,113,239,82,209,96,85,98,196,87,143,30,250,24,217,92,120,23,123,71,64,51,243,204,192,239,147,75,30,170,32,161,187,95,176,78,235,9,173,103,112,9,93,39,55,89,66,223,135,55,158,58,28,249,4,53,46,175,138,48,65,135,70,136,1,162,20,77,236,103,41,150,88,60,162,162,221,75,62,108,114,118,100,40,120,101,241,122,160,0,109,225,54,161,239,188,6,149,136,139,198,177,179,32,43,126,52,149,57,217,226,136,215,201,55,32,213,229,87,28,109,36,223,42,151,98,71,107,140,255,230,206,183,84,127,109,108,57,226,37,11,140,188,250,216,82,32,241,186,122,68,173,128,81,29,57,2,23,81,10,233,198,238,113,91,11,7,17,184,180,159,230,116,147,143,120,21,24,1,220,118,49,16,80,204,12,78,41,111,117,193,98,56,148,193,219,160,156,230,56,126,1,172,183,95,204,229,202,75,218,108,245,33,254,8,58,127,98,209,197,176,100,60,110,139,133,80,43,42,133,200,12,216,121,186,89,171,171,252,220,132,121,46,180,75,79,8,157,91,112,112,34,247,193,147,132,119,236,30,223,101,129,132,197,45,134,84,202,92,249,70,208,211,158,206,209,216,202,106,106,96,1,80,249,182,103,247,124,85,169,42,212,67,245,112,214,156,147,143,216,186,202,197,119,5,230,23,226,199,79,150,253,252,85,1,193,145,96,212,15,165,73,246,244,50,249,165,95,254,252,112,62,100,237,167,234,181,238,164,135,224,175,19,225,82,153,135,122,209,81,59,123,165,21,127,99,54,56,18,153,226,205,161,95,202,7,79,126,124,92,208,244,46,5,176,227,206,200,16,140,97,250,131,187,54,34,117,52,52,206,150,201,200,182,45,201,225,80,46,100,113,199,193,12,116,224,253,59,85,244,248,161,239,199,164,208,63,114,103,163,167,185,246,203,19,33,102,53,236,108,3,205,170,155,230,73,204,142,178,233,7,187,171,191,137,254,60,149,218,98,40,42,87,10,3,146,207,162,67,113,25,173,141,27,217,143,225,97,164,2,208,116,57,181,180,112,233,183,114,62,110,197,29,79,155,213,7,115,94,60,229,43,83,79,119,171,196,20,78,239,233,51,87,6,32,5,59,166,121,176,193,0,2,145,150,183,130,7,36,179,159,57,212,66,179,111,151,174,27,202,58,35,12,121,174,29,17,69,244,46,87,1,173,238,194,40,107,180,147,157,209,184,241,104,251,123,242,164,42,31,93,118,82,79,189,47,105,102,158,30,210,164,16,47,140,226,212,235,70,176,78,30,247,193,162,137,19,102,181,9,248,156,29,149,41,73,2,34,88,183,198,106,254,34,124,19,150,32,99,71,253,14,190,121,107,200,168,38,114,205,153,112,139,204,16,149,101,168,127,70,40,156,157,78,179,113,220,4,46,194,124,96,187,139,83,36,28,169,50,209,88,176,134,217,219,55,18,186,165,170,11,175,60,216,24,132,95,218,101,75,194,66,64,184,1,56,29,86,92,86,243,122,204,124,185,21,219,37,111,68,82,178,41,69,127,186,121,223,219,84,41,169,105,54,165,5,128,102,12,67,130,217,46,97,233,254,216,57,121,145,39,46,34,136,82,175,114,153,215,16,119,138,116,45,137,136,230,59,132,221,97,0,150,250,153,211,18,141,254,212,157,9,45,217,191,16,24,133,130,194,151,189,230,92,187,55,12,247,187,8,115,13,29,222,207,59,92,230,24,146,39,165,2,54,188,107,162,190,178,185,22,188,187,172,42,164,239,225,92,55,26,237,230,59,0,75,13,33,47,250,12,161,72,4,185,159,244,163,208,129,102,176,239,178,99,211,97,92,241,234,19,85,70,42,189,55,130,151,119,38,50,126,239,231,40,153,124,51,220,63,234,208,163,211,170,63,37,231,40,152,183,204,90,227,246,208,8,196,85,209,243,92,102,174,199,27,110,145,27,1,158,35,176,107,152,163,227,75,21,184,120,238,57,155,201,3,194,165,57,117,211,136,236,17,128,98,177,93,111,46,94,137,155,5,70,101,212,42,190,79,218,62,143,123,151,171,59,185,175,9,185,245,254,235,130,177,69,252,61,157,29,229,105,128,229,192,180,37,158,214,254,13,129,64,53,209,247,56,140,241,97,250,119,174,250,204,68,97,184,208,29,20,117,25,12,105,234,224,76,223,115,197,177,7,235,247,19,42,20,85,78,15,81,181,192,153,4,160,176,82,106,67,212,194,132,240,190,45,126,79,192,122,42,28,239,165,14,139,14,152,62,129,78,48,66,45,207,97,240,165,178,129,234,169,234,59,12,218,46,249,54,76,20,225,254,11,128,237,242,61,101,16,36,207,202,13,244,205,77,104,204,51,50,1,5,95,211,151,110,251,255,185,191,151,167,102,140,98,163,129,27,38,60,101,197,176,252,212,232,136,208,157,118,51,83,111,209,188,223,78,130,47,24,91,236,170,159,121,55,3,202,0,155,212,180,173,74,37,161,201,91,108,166,174,27,239,60,20,65,158,225,185,85,89,127,76,244,27,86,150,160,201,13,106,79,143,68,200,236,55,107,243,76,149,215,188,118,183,198,159,26,140,136,153,211,173,159,16,57,139,31,93,149,70,6,141,53,112,164,6,184,239,106,159,222,67,158,26,121,136,223,39,46,140,67,170,202,95,88,179,214,186,212,140,8,12,94,34,77,226,17,17,162,210,225,20,151,177,74,9,100,126,170,73,142,33,144,154,131,151,205,235,28,118,190,6,137,98,50,237,7,94,230,246,133,250,179,160,199,89,103,9,203,111,37,216,185,171,40,117,6,107,87,133,165,172,22,140,220,186,41,97,187,57,196,102,220,15,169,194,254,170,33,237,69,78,127,4,30,119,51,251,153,50,179,106,153,232,131,96,100,243,32,78,78,223,191,150,158,39,30,201,43,12,220,233,103,223,247,156,210,213,52,75,203,102,114,46,35,81,55,175,89,207,53,66,198,247,164,132,51,64,124,120,125,108,35,3,184,185,202,162,122,93,58,198,11,176,146,221,62,6,92,250,135,230,38,135,125,76,89,22,140,243,110,14,212,252,94,85,234,86,142,168,158,28,94,124,183,180,213,174,80,170,142,88,83,48,201,169,249,109,156,83,4,161,186,46,235,85,83,86,244,7,52,58,188,19,124,117,35,105,13,185,191,47,252,142,77,194,147,27,235,193,126,138,65,32,134,118,24,227,33,219,142,48,59,235,147,8,183,94,74,184,233,4,78,44,55,20,167,190,216,145,187,105,253,135,93,68,15,204,76,81,176,255,140,229,106,248,29,154,109,79,247,240,181,62,181,2,28,187,26,136,254,180,92,158,140,81,194,11,245,237,48,28,57,112,87,48,233,185,13,251,113,29,199,152,222,226,254,232,119,199,120,251,113,224,226,89,162,215,74,115,227,118,145,197,176,156,161,226,233,79,170,203,163,113,106,144,108,25,85,163,91,129,143,75,216,56,51,156,13,106,116,79,121,79,152,139,128,156,169,174,94,228,172,49,115,235,134,42,145,67,107,214,122,8,49,156,210,218,178,151,67,247,169,0,56,164,44,222,132,125,193,90,153,10,15,29,69,159,229,98,193,181,138,65,215,14,65,89,116,209,247,174,22,72,27,141,214,94,36,169,203,34,123,25,192,248,196,238,148,225,225,253,59,44,43,96,2,26,21,96,123,202,184,253,55,162,172,81,29,95,172,11,133,235,129,224,183,94,71,85,29,23,65,246,242,222,224,109,136,62,63,145,107,248,167,160,195,242,204,135,237,253,107,53,91,77,34,207,186,102,102,84,28,14,44,194,39,232,156,245,132,232,76,102,63,206,240,49,132,118,211,1,70,75,30,42,3,149,207,174,223,160,227,64,221,207,62,64,74,186,97,163,201,85,231,33,84,76,132,47,66,189,73,137,21,77,184,234,168,231,171,247,76,32,229,1,138,186,116,5,60,65,8,57,133,57,165,125,190,51,105,242,89,1,141,234,53,168,34,89,88,55,63,52,10,226,116,30,115,175,214,74,234,133,248,48,242,17,47,155,75,131,130,124,207,192,199,156,142,142,119,122,3,15,49,119,155,82,80,171,180,19,29,133,31,247,222,9,245,206,244,22,69,12,85,112,250,23,97,212,191,32,152,5,115,206,31,197,19,250,138,219,130,3,84,216,78,11,80,213,13,161,199,128,136,64,7,53,223,221,247,108,10,139,128,47,36,225,149,145,94,106,22,86,14,62,13,43,181,226,188,243,228,218,231,144,137,51,46,13,237,21,72,193,233,132,28,220,20,8,4,122,72,237,253,246,222,239,176,0,105,79,66,248,100,211,232,18,217,109,127,11,57,83,34,123,20,60,137,153,193,152,195,96,127,130,205,193,250,201,146,44,174,91,40,108,105,104,231,248,136,114,61,136,124,241,31,128,186,165,230,218,248,76,54,35,51,13,80,241,46,59,34,214,111,253,168,149,252,124,4,81,171,131,110,58,165,172,223,166,5,45,240,154,11,195,26,117,137,238,192,41,98,219,74,113,235,25,234,46,9,144,57,228,196,138,122,230,73,229,42,31,24,18,166,217,131,24,95,177,251,18,240,249,10,235,122,112,16,73,162,6,70,8,231,108,54,87,216,194,174,60,128,244,234,190,212,213,146,128,244,187,133,74,29,128,195,60,234,120,57,168,116,97,234,156,164,173,42,225,70,177,38,184,43,121,148,186,19,207,224,19,253,214,102,184,227,77,205,223,63,242,184,142,75,134,48,96,96,243,151,83,50,87,123,186,147,177,176,62,113,237,99,50,108,201,126,185,218,219,219,241,171,55,44,28,194,49,254,72,63,140,63,178,112,216,15,3,183,189,172,230,154,116,254,246,200,73,82,76,41,15,168,132,147,25,115,46,90,151,15,180,193,60,237,178,105,74,47,191,86,59,221,105,248,98,26,140,49,149,76,146,83,229,173,71,134,78,113,171,186,136,69,240,102,228,167,251,86,198,107,167,79,180,215,210,44,58,98,143,79,188,44,133,107,54,248,165,231,104,149,127,120,62,61,159,252,239,41,101,177,140,108,77,90,49,230,151,125,115,153,80,213,191,17,98,59,202,149,108,239,233,23,177,26,245,216,97,198,111,31,75,248,67,177,55,207,157,212,233,20,69,111,167,232,80,21,144,9,32,199,43,200,181,141,195,9,143,237,154,121,175,158,247,124,39,117,184,48,30,51,103,4,19,16,28,84,98,72,251,204,19,32,194,90,236,170,52,202,181,96,92,120,59,184,47,169,66,177,66,217,150,2,50,182,17,7,131,32,76,227,116,70,174,42,90,163,89,35,33,148,41,240,228,253,31,107,201,210,198,152,13,86,70,112,248,225,121,155,252,134,99,239,2,8,98,108,44,76,227,160,213,104,141,16,130,205,118,253,123,220,48,200,187,80,35,114,62,45,188,107,29,79,220,169,244,147,158,70,102,122,231,232,149,243,55,230,115,28,185,83,39,179,237,221,41,170,240,44,143,39,216,163,87,213,39,157,118,225,99,80,190,57,171,200,20,2,7,166,112,211,127,0,69,167,84,159,62,190,37,46,1,194,192,152,94,188,50,203,38,220,128,2,108,156,32,255,174,254,89,135,44,97,26,237,37,203,70,32,238,3,218,163,213,145,32,244,50,67,233,217,30,131,135,205,0,46,29,143,192,99,180,144,34,96,7,74,212,164,44,215,190,88,252,138,84,97,50,251,203,44,252,175,247,178,155,79,180,28,8,80,184,205,211,9,119,150,32,91,150,4,102,212,89,217,117,71,241,163,146,90,113,142,34,228,139,182,236,101,97,47,152,88,91,161,47,37,246,4,92,89,174,210,15,82,44,118,249,82,198,192,155,172,220,91,168,190,233,35,204,84,24,113,139,102,112,42,108,124,19,27,148,60,159,78,38,239,90,234,5,193,172,28,58,20,182,11,43,162,123,82,184,178,167,19,172,101,106,3,69,146,204,136,46,70,35,133,166,103,74,245,222,246,76,109,232,173,160,36,50,39,140,112,227,59,10,18,127,30,232,161,113,146,233,102,248,171,205,245,154,98,101,53,109,65,36,82,31,241,200,111,216,27,255,10,48,237,213,82,221,17,250,248,215,19,150,56,175,233,19,230,30,233,199,3,100,121,176,189,175,63,20,231,105,113,121,51,88,188,231,109,177,58,34,9,199,121,226,157,183,76,219,41,224,204,61,144,124,88,115,7,214,74,179,178,42,119,144,76,98,58,171,185,134,98,123,177,87,100,213,183,165,147,22,29,151,19,74,146,102,107,158,201,189,0,79,185,36,105,84,104,73,152,103,132,228,196,39,102,113,158,255,56,212,198,37,172,139,31,238,98,184,182,42,69,108,194,245,23,205,45,21,76,115,162,181,174,59,213,233,59,240,184,32,212,226,199,126,11,205,232,217,187,51,197,98,94,117,94,105,152,41,48,22,181,8,146,134,207,30,237,255,240,248,183,191,187,67,210,16,185,191,54,193,2,218,22,99,176,191,233,78,247,165,4,231,131,62,37,109,244,76,194,155,129,212,66,0,101,223,162,211,13,80,169,217,16,68,4,155,216,61,35,76,162,144,217,34,209,73,249,250,253,186,140,124,41,237,124,22,168,97,40,95,47,38,188,204,216,150,184,229,185,174,113,3,154,126,238,50,165,170,12,27,209,53,157,76,118,81,252,10,140,31,103,160,43,171,6,65,205,225,154,85,121,76,216,228,29,241,184,200,160,225,86,4,199,137,80,222,199,30,9,163,177,222,131,91,24,3,147,148,250,20,157,246,166,73,41,246,240,159,85,53,172,227,255,239,211,188,78,85,210,198,63,175,149,47,251,126,139,167,245,143,5,212,41,111,52,133,173,37,114,122,63,214,212,6,98,213,169,140,241,226,233,95,47,169,91,89,117,116,228,30,78,123,163,137,11,19,142,70,121,166,215,141,20,57,100,202,75,131,150,222,136,204,79,199,205,220,46,9,129,92,116,55,148,224,138,82,32,255,250,251,59,239,99,130,13,77,106,233,191,37,70,164,141,160,195,95,192,54,39,178,189,46,17,135,160,255,198,62,249,69,57,5,74,22,165,134,209,143,179,8,28,219,212,141,148,242,233,231,171,234,72,186,111,252,84,120,130,253,206,225,145,123,88,19,194,150,24,168,247,191,92,162,203,56,94,55,72,199,142,76,50,37,253,13,142,159,201,100,153,149,243,217,240,192,204,254,66,239,13,23,161,166,210,210,120,35,7,141,179,109,83,57,146,163,16,195,195,129,214,39,34,155,158,29,244,128,143,18,233,121,150,87,80,227,145,22,207,133,15,10,172,79,48,176,209,68,66,116,22,167,251,162,90,108,98,148,98,84,46,164,185,106,48,68,247,163,112,24,15,78,105,58,173,251,63,10,252,91,83,158,57,178,63,21,40,113,231,82,251,191,134,27,71,131,203,150,222,121,48,211,181,0,62,91,119,123,77,252,183,63,204,142,239,211,87,244,129,213,2,81,221,210,104,182,252,35,116,91,198,172,132,76,148,89,3,74,8,96,232,19,70,18,232,128,18,145,133,229,23,13,93,175,174,68,105,55,192,81,168,1,142,132,193,37,99,188,243,51,14,26,6,195,29,149,159,115,77,169,235,22,66,101,37,224,43,146,152,141,191,222,67,12,74,51,124,129,141,11,37,97,10,50,79,112,123,54,180,89,156,10,237,145,90,99,35,116,84,163,249,196,70,103,144,16,14,13,233,42,5,213,163,203,205,92,6,212,210,195,46,141,24,15,1,215,71,30,31,0,4,24,15,93,217,35,228,173,104,78,117,69,140,243,168,119,62,223,200,171,123,57,184,88,64,53,21,153,201,0,115,146,22,119,84,228,16,189,124,213,148,92,15,178,58,83,69,87,213,137,150,254,92,197,211,157,193,255,150,115,3,222,48,64,41,28,208,245,211,29,135,30,54,205,250,93,94,57,155,196,37,151,90,109,165,11,249,203,106,37,64,103,100,206,108,40,181,36,238,104,208,241,13,26,75,32,133,101,47,132,226,199,174,3,139,186,102,206,19,21,6,166,44,184,63,7,255,61,155,90,233,60,161,86,176,23,97,194,237,176,234,251,116,25,226,11,145,130,13,179,158,222,252,26,235,132,202,117,229,195,232,158,52,183,96,47,219,235,210,51,146,103,15,241,22,194,84,73,169,183,142,81,87,203,6,251,105,254,2,56,164,156,137,219,71,205,59,144,217,70,38,73,57,73,70,131,114,20,249,181,50,184,200,127,251,28,30,92,166,20,252,156,141,128,223,214,176,136,154,210,238,245,131,123,1,114,106,160,197,74,57,4,101,162,185,66,93,219,192,225,68,181,231,74,140,180,121,162,114,142,129,187,73,66,192,218,128,28,39,134,251,0,243,48,55,112,205,204,80,144,149,109,100,247,179,224,228,198,89,225,7,131,170,203,32,130,21,23,249,122,134,208,160,239,23,10,91,107,175,27,56,59,104,18,71,209,245,4,165,227,203,178,69,1,114,130,119,193,171,64,18,182,174,155,16,84,193,55,150,153,90,251,6,94,161,253,223,200,143,16,162,175,93,211,88,243,61,118,144,204,158,163,68,183,243,85,64,42,52,155,32,39,213,93,165,239,188,8,152,93,228,136,71,213,103,158,57,252,54,203,34,230,180,127,56,46,22,5,220,190,103,131,16,64,135,114,68,112,125,205,54,108,113,157,5,31,108,20,138,80,149,170,6,114,65,223,21,159,246,115,158,118,220,203,106,20,66,204,213,59,225,109,136,122,206,137,104,126,66,24,195,83,223,112,36,241,154,219,254,255,248,77,142,202,95,86,171,11,42,188,7,245,217,138,49,224,34,61,121,28,57,25,3,70,9,40,108,107,108,211,160,206,154,77,59,153,161,172,200,23,84,154,131,94,122,115,145,19,13,234,127,86,154,80,149,41,50,98,186,251,36,10,53,159,223,103,104,248,67,154,136,228,46,83,243,36,33,221,157,116,83,109,54,89,171,46,252,120,86,50,220,23,252,185,68,192,125,37,223,233,232,110,16,135,71,175,199,37,75,162,17,48,41,32,39,131,59,145,161,20,26,149,216,99,1,188,240,87,189,8,24,224,227,175,207,156,151,37,76,105,62,202,86,172,9,208,0,186,72,213,78,103,254,132,192,92,113,242,42,224,245,111,181,206,107,130,182,212,63,185,27,28,41,112,220,209,148,172,7,140,225,168,124,67,203,73,76,139,41,226,87,30,125,197,216,76,36,160,168,194,202,181,254,134,0,148,187,242,94,239,72,9,21,148,168,92,66,161,144,73,37,106,39,176,127,116,44,183,89,77,47,138,171,10,169,117,147,107,92,29,184,69,82,220,13,130,34,214,197,214,6,152,46,180,228,77,211,162,47,149,169,145,56,196,174,84,97,93,246,216,30,34,211,137,93,8,161,64,73,106,220,60,107,201,86,86,124,51,9,66,244,168,8,22,125,147,200,68,23,23,247,75,139,87,52,54,5,53,175,14,218,127,126,196,104,220,88,75,122,52,99,226,111,88,137,95,199,196,6,2,87,182,200,67,133,205,210,73,174,53,64,12,134,84,182,73,199,7,65,88,7,24,83,187,31,81,35,236,229,37,177,78,42,143,233,94,241,133,195,255,185,7,218,41,43,231,129,3,23,175,147,37,26,188,70,161,146,126,24,12,38,104,96,209,143,227,254,9,198,24,192,4,227,59,174,32,240,251,5,34,127,186,184,83,193,62,41,187,33,39,239,28,16,118,164,36,171,230,136,212,122,52,86,39,165,85,61,117,145,179,83,209,229,95,227,85,170,136,187,59,115,217,179,60,48,21,67,116,58,14,145,89,89,35,229,5,152,217,138,26,10,189,186,35,83,210,174,165,179,87,168,247,177,43,213,204,247,37,109,164,15,182,108,253,170,140,83,214,151,0,211,81,132,64,43,30,248,18,149,11,44,248,98,107,216,117,38,96,167,82,124,152,140,191,51,40,145,207,31,45,189,144,120,151,236,172,94,196,233,80,172,227,217,187,197,174,24,108,153,189,212,51,44,156,203,149,74,222,95,240,202,168,235,255,91,215,29,201,254,8,156,120,134,162,218,172,153,51,254,189,4,238,93,65,227,158,247,6,74,254,126,91,58,204,84,167,188,223,91,180,79,147,62,150,135,231,158,186,185,126,91,13,115,56,108,78,17,205,175,102,47,20,157,73,175,89,225,242,141,119,215,191,236,127,186,252,109,87,164,233,22,213,98,137,134,97,78,12,13,150,30,160,164,149,154,108,167,156,104,67,228,187,152,143,135,114,154,47,7,21,89,131,179,34,253,135,40,109,220,0,127,213,82,85,64,161,1,113,242,240,66,56,78,225,32,59,26,177,12,19,79,6,212,120,217,177,7,187,76,85,122,133,9,219,81,118,109,201,21,119,47,122,30,190,208,241,78,63,16,91,45,44,253,13,228,18,228,187,96,222,132,166,77,100,226,124,234,61,59,174,40,117,26,163,5,65,107,1,95,18,170,126,100,95,216,113,98,15,186,246,133,3,205,221,228,159,206,212,201,240,175,113,198,72,187,233,28,104,253,239,168,246,139,120,149,143,34,146,39,220,145,216,114,243,109,219,151,117,75,33,162,197,181,62,19,128,118,215,96,101,54,68,109,7,171,133,54,145,1,15,56,224,58,123,172,196,221,3,133,158,85,120,21,246,153,166,1,17,66,48,223,247,230,95,15,223,253,250,109,197,6,190,76,117,7,245,185,143,129,188,191,215,198,20,90,194,172,250,78,233,102,182,120,92,116,208,65,80,84,235,77,57,207,221,127,16,225,96,218,22,104,216,138,195,220,101,236,3,109,87,42,198,95,96,164,202,48,107,45,17,107,246,2,243,229,149,152,83,101,228,91,80,183,254,119,138,201,64,197,135,212,15,171,151,44,69,249,208,188,57,253,250,157,63,153,226,131,155,3,224,56,103,144,28,200,229,192,71,131,21,129,219,235,31,205,144,191,146,253,77,67,78,216,241,242,228,244,174,123,254,65,212,26,35,218,100,1,28,145,247,37,254,116,206,212,40,200,241,209,30,238,181,165,198,211,144,87,158,142,226,70,232,172,134,42,41,121,222,108,17,68,45,47,16,56,26,77,188,99,188,115,118,252,245,11,51,25,44,27,128,31,32,221,54,158,109,102,53,155,4,245,73,26,234,174,198,111,64,52,171,213,56,173,114,145,152,204,191,140,179,22,93,211,35,243,221,136,103,201,155,0,41,110,183,62,30,176,252,190,108,47,23,203,166,160,173,17,124,11,189,244,44,4,13,133,74,224,19,240,200,254,27,57,180,193,89,67,10,147,117,127,169,109,96,98,8,10,21,26,37,181,81,247,202,60,172,58,139,237,116,143,140,46,52,176,49,71,231,243,80,161,14,219,152,25,62,178,232,150,162,47,124,122,155,221,61,212,160,224,158,136,39,24,24,159,93,108,6,145,49,245,189,95,22,153,45,100,83,225,12,97,201,53,242,6,2,23,210,62,108,106,189,178,189,42,64,247,93,171,233,157,196,159,103,239,240,111,60,164,43,151,83,198,183,204,37,185,207,113,120,130,103,10,4,90,144,149,54,51,128,82,233,108,119,172,85,82,79,203,25,184,22,113,202,100,46,34,121,95,234,102,43,243,242,211,223,171,133,152,188,18,134,67,47,2,94,11,17,249,254,0,115,150,132,37,136,76,84,42,91,153,219,138,4,233,91,164,1,243,162,12,134,75,244,55,138,40,252,182,74,245,239,39,45,157,106,56,118,130,15,190,210,138,155,237,239,57,182,77,69,190,113,237,27,178,173,214,149,95,133,12,106,208,89,63,129,174,51,58,43,142,103,103,138,109,123,39,101,45,171,1,233,54,34,208,63,121,151,241,39,0,207,133,172,100,150,134,5,196,133,184,171,253,201,139,186,75,242,123,53,174,38,249,95,72,254,64,108,209,147,37,177,166,69,3,178,95,255,47,41,195,232,6,73,119,89,203,225,150,80,125,183,56,28,82,112,89,167,237,204,73,139,208,233,7,168,90,35,244,133,50,216,254,240,80,227,187,102,135,27,213,192,201,21,175,236,199,100,103,36,247,192,4,133,40,125,16,111,25,177,101,37,180,170,49,230,106,169,123,73,58,231,60,106,230,145,116,211,215,134,199,90,18,243,210,29,225,79,224,248,108,204,147,215,73,244,75,154,145,95,137,151,193,154,146,43,242,175,5,62,42,113,9,57,70,59,133,75,165,250,154,186,143,167,22,47,252,137,102,87,181,104,147,207,195,205,88,18,48,209,126,182,35,179,10,30,175,25,163,6,202,85,185,99,52,208,20,19,242,169,14,253,227,198,85,129,68,11,99,112,59,79,142,105,188,254,123,148,88,153,70,89,84,106,236,34,181,241,51,194,138,62,14,134,245,151,117,235,135,10,139,140,204,146,196,96,242,114,217,131,102,142,129,65,132,108,64,29,42,233,238,33,19,249,17,222,195,125,158,124,202,110,18,183,150,111,199,70,127,8,180,135,203,33,143,230,228,90,44,43,118,241,57,168,162,89,150,106,102,32,60,250,93,143,196,239,12,214,171,73,180,196,199,210,115,112,192,13,9,123,222,213,148,91,19,101,236,101,30,146,43,164,10,156,101,112,151,65,89,151,245,154,56,37,194,99,153,35,80,3,93,62,246,6,68,42,34,155,207,230,215,121,37,213,153,36,165,136,123,181,144,31,215,138,161,118,151,196,108,131,138,93,13,158,182,138,197,184,0,44,139,70,0,204,15,179,245,235,111,229,61,119,1,248,135,70,169,50,116,69,16,223,77,223,248,176,81,63,205,104,150,100,178,216,215,7,243,251,58,16,117,59,213,117,122,156,183,0,72,126,132,100,86,92,240,106,174,220,88,51,75,166,111,176,139,229,215,30,173,166,246,249,201,187,24,250,69,150,214,224,9,17,218,53,173,213,254,11,60,19,32,202,124,40,131,51,99,223,226,217,190,252,29,14,39,73,199,37,180,254,114,46,169,46,109,205,172,86,62,198,113,209,186,149,211,122,42,239,238,71,133,33,39,217,86,131,68,199,243,26,0,143,97,215,140,217,34,11,55,192,118,66,69,203,200,128,171,40,250,94,127,204,76,168,232,153,226,37,150,4,8,22,177,75,64,204,39,19,45,127,173,174,14,222,159,184,66,88,61,250,133,231,114,166,164,33,157,77,203,31,222,189,111,131,178,107,117,10,165,203,18,211,117,188,134,254,238,158,123,143,231,245,189,89,21,88,66,169,241,24,26,210,108,105,249,56,37,196,36,26,110,237,31,34,198,114,72,218,133,14,40,38,0,26,218,130,56,146,228,86,253,43,36,112,162,58,232,178,162,105,114,186,74,187,229,215,195,101,241,14,24,95,246,248,101,255,68,164,79,41,18,245,65,11,228,167,132,169,52,170,196,91,52,224,204,230,105,193,231,254,49,143,85,42,221,140,233,18,131,116,86,127,103,136,113,15,23,95,39,90,226,59,168,56,73,43,227,171,60,251,5,66,24,207,129,225,168,127,243,190,108,173,215,76,110,107,75,120,242,147,252,217,57,234,116,1,133,221,90,162,174,126,61,236,200,53,105,71,155,217,56,85,6,214,13,60,119,234,225,200,186,152,215,237,225,105,85,252,240,252,38,75,220,200,6,243,144,34,127,161,14,197,107,63,75,235,195,72,44,27,244,129,243,201,59,241,45,173,62,200,145,232,76,142,208,183,15,77,119,157,26,157,170,159,104,206,13,248,132,68,229,234,196,252,168,229,154,203,44,177,54,200,235,132,93,52,10,196,60,152,226,220,27,98,85,215,82,144,161,12,76,202,47,71,231,225,223,105,35,201,195,174,188,10,168,199,141,255,108,74,166,226,33,4,203,54,202,178,27,127,250,86,181,225,246,70,219,65,173,49,214,202,71,22,67,184,54,90,182,251,202,40,14,235,63,201,190,75,65,15,33,62,81,56,157,55,187,67,3,223,5,188,105,211,72,202,95,229,207,20,1,219,121,116,56,5,116,227,97,48,200,192,252,86,238,56,125,89,89,89,100,76,5,180,81,31,33,111,202,211,182,51,25,81,28,239,153,125,85,67,149,136,118,157,65,84,65,43,74,86,81,238,45,7,227,222,145,234,95,152,157,225,22,53,47,59,189,252,16,40,26,171,155,247,98,73,206,206,218,9,241,152,213,3,15,107,123,100,86,78,2,200,194,8,78,101,235,150,113,69,232,13,102,131,200,41,240,126,186,238,184,20,62,218,235,221,116,53,44,20,219,104,254,112,139,81,119,100,253,105,53,62,247,159,166,75,128,64,51,7,193,108,154,115,34,146,127,75,102,17,112,81,35,33,255,104,228,11,97,24,252,219,214,122,235,2,28,34,128,252,220,126,248,87,48,200,149,102,191,135,59,48,111,142,210,22,87,41,25,209,90,114,67,98,234,128,53,45,198,155,116,161,66,14,216,226,63,200,18,7,20,213,60,221,77,128,48,20,142,208,197,61,210,161,90,77,80,146,220,80,168,29,93,171,234,195,182,134,136,225,120,206,94,147,141,52,199,5,155,74,143,12,252,50,79,254,135,78,145,222,143,150,128,28,137,206,79,88,83,195,0,213,182,223,225,201,191,235,235,39,175,202,211,139,11,109,8,255,251,237,232,33,37,250,169,184,42,115,205,55,220,211,160,190,225,201,208,87,227,181,15,92,123,111,172,104,71,23,236,206,214,177,119,77,128,149,238,102,224,147,48,143,82,158,83,179,110,112,12,75,86,190,48,208,14,156,92,140,55,64,14,23,106,204,140,48,97,72,62,247,14,217,121,31,224,171,233,69,177,129,185,71,17,87,96,138,78,19,178,198,229,37,235,51,51,208,149,100,111,39,54,197,126,215,245,125,0,18,64,157,246,4,183,62,21,82,209,182,193,74,163,255,99,143,38,119,30,171,116,62,129,241,64,167,205,128,48,19,141,208,126,96,231,17,94,11,123,106,132,252,127,95,4,217,84,100,231,9,56,144,178,55,92,107,154,194,164,113,19,93,117,152,188,49,241,135,95,131,177,63,10,247,179,86,47,153,63,125,70,239,205,3,48,196,135,152,123,146,5,229,21,112,255,72,4,180,42,148,238,234,211,163,111,223,49,176,36,101,182,121,145,65,242,151,27,181,100,235,212,127,238,78,165,2,36,188,117,89,217,137,39,32,249,156,72,106,48,65,177,35,119,166,109,125,93,15,74,133,194,177,8,208,79,4,23,216,37,3,20,67,12,40,52,11,160,213,96,177,234,40,240,251,19,126,81,186,153,249,204,11,91,78,70,238,38,31,243,13,156,49,165,95,148,218,155,179,139,30,216,15,153,27,164,59,189,173,159,141,146,16,21,167,183,161,203,82,140,66,150,182,16,73,40,176,102,55,118,132,173,249,137,117,137,145,90,53,86,164,24,152,171,14,64,192,181,253,238,22,204,59,115,228,173,155,232,15,108,250,14,135,190,177,25,54,114,152,83,38,132,125,185,243,134,112,168,170,99,100,155,125,107,46,165,146,10,12,243,170,39,155,195,220,140,129,9,27,178,166,144,112,200,134,3,146,228,27,60,217,251,147,93,72,56,196,158,217,177,53,113,146,111,93,172,7,71,165,196,105,120,164,255,79,158,235,183,45,61,139,128,87,87,24,202,89,236,50,129,135,90,217,225,115,211,102,32,22,124,87,167,76,209,47,193,179,5,176,1,172,115,53,235,4,198,69,17,146,1,156,60,169,171,3,154,137,1,8,160,180,39,33,145,194,221,167,74,225,147,22,226,175,161,190,155,99,104,36,234,28,206,255,153,106,146,140,248,208,160,159,129,189,81,79,151,34,57,191,19,60,238,132,173,126,112,102,40,167,236,248,169,15,165,62,167,248,117,241,242,52,190,179,82,62,174,253,135,166,242,116,101,164,25,44,212,205,199,182,51,26,85,54,11,16,243,103,183,145,84,222,115,193,84,191,14,243,49,214,76,187,20,39,29,243,173,156,181,219,109,64,24,75,52,179,28,160,231,99,85,33,44,165,96,91,1,116,151,203,247,43,74,128,179,172,198,31,77,89,11,160,120,13,159,140,72,217,110,79,78,206,233,178,98,50,152,74,216,73,133,249,217,70,75,56,129,241,107,234,100,37,103,60,16,188,2,190,11,70,104,226,153,93,247,153,143,161,19,20,220,168,207,59,231,145,117,83,136,104,18,107,25,84,26,105,116,169,98,24,122,32,236,228,193,206,223,235,29,238,49,143,225,2,196,58,61,127,140,102,14,140,100,86,158,130,245,106,213,21,195,130,77,170,38,87,189,28,239,43,9,141,221,172,71,101,23,117,196,97,176,152,245,228,11,197,252,84,206,70,36,202,196,205,27,80,137,39,25,75,180,73,162,224,150,97,44,115,24,151,153,239,190,250,64,81,124,193,49,199,158,225,239,216,251,150,194,11,43,136,66,171,93,122,163,101,50,248,76,30,251,201,114,80,75,69,109,212,155,11,141,217,118,95,15,127,174,149,147,216,251,178,89,253,92,51,157,16,128,60,144,26,219,47,131,125,182,76,241,164,209,6,26,7,92,85,220,173,245,230,208,98,209,124,70,173,192,190,132,55,211,201,186,183,60,108,73,202,134,11,25,98,22,219,173,173,140,39,222,243,91,17,177,81,168,144,244,94,105,34,211,227,16,134,9,254,20,51,4,182,243,203,82,63,238,89,246,230,147,185,200,52,129,113,141,167,177,99,18,247,119,52,84,13,203,187,89,98,35,178,30,13,149,205,77,136,197,164,183,202,225,132,158,34,253,166,180,170,81,56,53,16,116,34,149,120,212,66,17,226,5,193,175,148,81,251,230,23,177,141,43,79,103,153,84,172,51,44,242,34,237,188,74,225,118,144,129,40,56,96,157,254,134,231,14,209,110,23,26,41,253,29,33,247,80,149,196,100,34,23,183,198,124,246,191,174,56,254,31,119,127,229,154,236,190,38,98,101,91,126,182,201,156,27,210,62,101,17,18,95,17,62,112,173,218,95,8,203,29,169,3,23,137,111,219,234,54,156,50,148,31,227,60,56,205,74,105,149,45,57,162,39,83,232,38,150,169,204,161,15,212,82,220,124,196,127,1,123,135,186,208,13,210,224,127,223,143,131,107,123,201,10,21,58,99,135,64,212,81,242,174,16,20,198,65,72,42,58,79,59,206,26,52,133,57,223,232,6,119,87,13,47,214,82,42,153,242,77,203,163,205,22,188,0,129,78,179,114,86,63,119,183,248,180,74,200,49,174,239,118,170,130,129,69,61,251,182,192,219,239,214,192,255,58,247,26,49,105,232,74,79,103,145,214,114,231,134,233,230,182,242,244,118,246,117,136,107,207,19,107,184,247,251,123,157,189,96,101,189,162,223,179,99,10,86,165,128,163,231,16,244,57,68,233,20,250,104,28,166,38,49,110,177,66,17,127,187,199,42,122,137,238,193,107,95,247,227,189,113,10,75,176,213,70,136,141,144,164,87,37,42,23,127,141,164,183,78,139,218,128,235,216,244,18,237,172,200,24,113,21,112,117,16,59,41,136,9,155,210,169,170,75,221,91,65,24,147,102,178,110,106,220,193,124,222,37,240,191,119,132,54,85,182,115,221,35,234,48,168,174,45,235,227,126,189,190,94,228,240,101,211,112,91,127,57,151,48,255,55,129,17,139,254,252,80,114,75,182,22,51,188,91,109,69,192,230,36,179,138,232,162,3,131,1,137,52,56,241,139,77,224,236,177,175,210,192,80,187,135,105,224,116,81,229,132,151,223,232,67,207,191,76,55,255,26,58,42,239,48,161,0,251,40,166,214,231,173,40,122,99,165,8,170,84,14,152,38,0,60,172,198,70,127,95,75,16,127,6,6,164,64,141,172,238,59,222,131,224,43,38,141,127,96,100,62,2,30,34,180,54,230,3,150,5,231,193,31,96,61,201,7,121,144,136,49,68,114,1,180,193,165,67,117,98,92,230,45,153,167,120,227,39,220,201,40,218,176,242,79,255,176,197,84,44,219,188,24,123,109,252,180,10,54,56,205,152,158,23,34,226,122,114,118,86,190,135,145,210,139,53,111,80,254,12,33,99,114,50,69,174,102,63,40,134,203,163,241,201,210,132,197,30,194,21,41,67,111,169,59,137,176,140,87,223,35,219,148,41,17,47,87,132,177,195,184,155,62,44,57,51,61,166,176,0,78,17,239,248,132,24,90,111,0,114,11,243,116,156,217,62,172,237,169,184,102,49,203,132,170,173,228,19,92,247,110,129,213,51,246,166,189,117,14,122,133,32,168,49,250,110,109,130,233,47,207,247,73,245,53,4,163,18,37,68,143,96,159,144,46,41,170,94,167,114,150,192,69,209,251,219,13,111,213,186,98,240,94,100,151,249,137,215,40,31,202,233,102,233,87,154,45,180,231,125,239,156,180,218,112,223,97,62,42,141,65,252,126,67,80,247,250,233,208,232,35,192,160,163,194,226,126,10,45,236,6,185,108,216,204,37,163,11,79,111,48,215,146,155,158,134,141,203,55,89,61,222,33,78,82,125,74,58,124,11,39,39,25,125,19,251,109,165,69,192,6,62,4,243,172,60,180,97,171,114,245,37,98,216,173,83,172,42,223,203,123,98,129,233,163,55,50,102,117,207,223,131,8,155,151,246,17,163,194,153,249,69,72,100,93,139,51,97,70,143,174,24,21,44,73,67,97,203,26,232,224,113,226,185,74,242,203,51,164,179,209,188,168,1,102,93,74,120,214,135,191,193,209,7,112,218,199,145,10,92,23,239,226,242,205,187,159,126,171,125,35,158,53,118,74,19,183,224,31,116,118,13,32,211,205,92,131,123,48,181,32,124,7,233,247,254,24,251,109,189,0,184,187,80,73,194,94,100,239,81,170,145,20,235,132,230,56,141,90,22,151,198,88,153,66,134,20,94,237,62,58,110,218,255,50,111,198,109,211,202,21,39,7,30,238,147,85,35,154,58,236,112,221,70,102,211,120,115,74,109,188,70,229,214,191,122,134,120,195,231,217,122,35,113,9,110,154,50,82,32,35,111,159,191,205,52,223,124,250,77,32,228,68,131,215,255,245,107,10,80,105,104,31,4,173,207,219,31,219,171,182,182,254,211,181,183,202,185,238,165,167,38,248,72,193,90,249,154,165,80,64,209,68,160,49,226,93,135,143,48,97,211,47,187,29,120,160,203,115,39,87,245,227,220,244,5,60,57,251,126,42,117,244,81,69,98,77,242,210,249,188,19,130,253,198,56,95,174,249,187,185,215,132,16,226,25,29,180,25,54,143,69,121,134,79,117,180,218,210,211,236,58,207,231,69,104,95,149,166,212,59,105,131,68,83,21,233,177,143,135,83,237,99,3,20,58,123,234,249,128,199,117,238,163,124,52,215,100,124,76,146,61,253,192,135,196,87,201,115,149,98,141,214,85,252,207,188,13,34,208,166,93,132,22,39,44,115,121,203,93,78,137,69,196,253,197,120,148,36,21,208,5,95,43,5,122,145,41,160,12,117,201,143,36,62,133,73,185,73,185,155,194,182,166,248,96,33,9,112,7,42,39,42,203,253,23,196,161,187,66,234,58,217,44,48,7,139,47,158,58,153,179,83,189,27,100,164,156,234,199,98,117,100,38,11,24,163,169,221,244,159,173,191,177,229,194,60,25,229,142,239,38,104,95,145,238,47,214,188,90,21,66,126,66,111,210,228,101,36,242,172,130,97,234,90,20,62,166,38,11,198,159,44,245,249,131,27,135,234,87,83,2,62,185,253,129,60,125,165,26,164,138,148,193,87,246,201,45,72,3,33,31,191,29,45,33,15,238,109,8,39,100,38,195,128,83,7,133,205,161,144,113,161,194,75,111,13,7,188,92,227,251,80,96,18,64,26,145,25,40,183,204,243,127,122,119,214,146,16,231,175,187,101,92,23,25,172,45,195,139,252,212,135,73,86,24,33,203,30,64,143,202,39,238,180,143,39,141,32,30,65,76,186,57,211,14,143,45,98,183,16,106,103,221,249,6,53,137,24,139,142,183,198,247,95,139,222,54,254,33,32,110,206,70,243,213,3,192,199,172,149,164,83,182,93,148,177,50,21,141,173,13,238,107,195,127,67,110,37,112,43,142,183,230,190,209,160,162,156,23,27,134,24,34,52,140,72,249,61,178,169,148,8,130,66,147,91,31,208,121,252,240,86,4,49,94,172,145,170,231,175,155,91,81,34,65,35,19,119,54,89,16,204,192,75,121,73,147,188,144,117,13,228,38,41,170,216,212,138,219,190,30,66,160,168,25,44,46,139,91,239,138,252,75,214,254,70,38,167,102,27,83,199,3,87,193,132,173,198,46,20,126,199,149,77,169,28,80,101,104,137,62,96,184,186,195,156,232,54,165,152,181,234,109,221,187,146,210,235,81,120,213,202,4,54,76,73,143,91,58,186,245,234,169,42,230,22,18,250,90,107,166,223,111,105,64,154,164,4,224,90,136,137,59,115,161,111,33,203,195,109,85,228,153,230,42,60,71,72,5,2,62,18,247,95,210,226,191,18,86,215,250,188,187,220,235,252,237,222,248,38,43,49,68,167,200,78,234,221,147,5,179,21,224,63,87,13,134,86,163,63,36,111,99,183,191,107,252,17,109,125,244,237,227,124,248,96,249,123,151,124,55,89,15,60,83,228,51,167,78,178,149,160,185,115,84,80,74,205,223,140,130,90,11,7,178,123,40,235,140,10,228,159,27,22,21,27,35,97,198,101,3,45,152,101,159,133,198,240,50,167,96,88,76,87,206,44,39,249,11,105,101,233,91,94,0,117,182,228,62,63,40,7,175,93,108,94,109,10,13,105,155,235,242,84,115,42,225,207,146,64,214,155,15,160,204,116,101,205,129,106,90,130,161,1,205,66,106,134,110,197,2,121,251,255,76,57,17,131,177,22,249,53,191,239,3,209,175,23,202,194,236,120,82,27,150,175,201,140,218,92,66,6,242,27,242,72,21,153,249,76,147,161,201,108,133,37,82,63,157,26,16,157,157,53,227,144,45,33,251,159,166,102,14,146,8,130,61,71,232,239,55,149,154,94,62,201,196,46,66,64,182,197,173,177,174,129,184,239,93,144,26,35,78,229,198,0,35,11,0,24,58,31,116,17,14,148,173,217,199,57,30,154,70,63,65,205,96,139,15,161,221,167,15,248,53,144,210,247,198,28,89,183,77,185,161,137,46,60,33,250,124,201,6,162,14,149,173,139,246,183,196,97,174,62,140,41,85,124,32,241,157,180,188,116,43,88,101,206,143,162,87,136,175,53,8,137,29,26,223,233,139,150,187,232,66,160,175,236,60,249,74,124,88,0,169,71,249,158,190,158,10,136,161,14,192,129,205,123,206,139,139,194,116,10,232,178,229,135,29,133,175,175,159,206,251,200,116,49,111,179,231,204,59,114,82,198,44,18,188,92,104,214,214,0,99,131,131,20,13,139,95,163,166,89,240,125,147,162,92,27,236,208,194,108,76,213,90,135,100,0,183,53,71,191,95,49,61,227,177,149,62,19,73,102,79,254,208,162,75,217,114,173,130,116,114,179,103,102,51,151,84,216,208,210,52,137,180,99,72,124,128,249,247,136,183,36,28,249,242,125,70,239,231,22,75,183,222,194,216,180,98,166,182,159,27,186,214,74,253,234,220,112,80,103,58,215,113,70,28,68,149,92,181,110,119,67,179,179,9,96,140,249,194,72,173,244,144,58,9,141,246,68,237,118,179,124,164,96,125,30,196,126,104,19,176,107,25,7,162,89,236,206,184,139,167,166,16,55,67,7,93,251,90,252,86,252,171,140,238,114,28,106,253,2,64,26,18,192,199,145,70,224,41,158,81,211,254,47,235,74,231,215,176,97,187,165,209,79,109,189,21,14,209,97,193,29,254,42,24,157,72,5,143,9,214,54,90,86,243,143,140,12,163,2,158,213,69,48,232,80,165,123,73,197,247,8,241,232,198,127,142,153,236,153,145,20,27,64,72,56,14,13,147,102,116,211,20,44,176,108,13,229,36,230,81,206,9,197,5,42,177,137,125,239,52,138,145,92,76,16,223,134,138,221,234,177,91,177,210,67,1,151,117,176,201,125,211,227,144,217,180,31,53,97,31,147,33,222,114,225,63,236,245,62,68,54,30,147,134,96,110,84,124,209,201,141,3,62,115,79,24,228,194,3,74,218,184,3,66,224,170,40,123,37,121,61,129,54,53,103,197,43,89,135,6,26,104,193,193,136,152,56,142,183,224,128,35,138,123,231,218,184,64,116,133,134,79,71,93,163,18,65,127,217,137,72,42,147,44,193,117,255,58,201,221,139,83,224,169,171,21,200,243,196,43,229,12,27,96,110,87,50,136,174,144,220,236,35,210,9,136,71,10,14,95,205,206,230,46,210,240,140,197,31,1,18,188,0,238,15,228,67,49,220,86,132,126,70,124,204,88,118,84,251,214,36,171,200,70,160,93,190,20,193,149,122,208,201,60,231,13,227,143,217,98,120,101,241,47,166,37,0,246,166,53,179,69,210,170,111,102,237,39,29,58,140,90,17,30,66,50,240,135,134,156,130,216,158,96,227,238,43,173,150,62,156,252,12,213,121,200,99,178,38,253,248,51,29,232,51,139,88,26,160,174,235,4,96,47,68,39,65,224,118,4,246,129,110,151,23,33,196,101,107,18,57,33,181,138,239,175,105,157,49,247,51,175,4,49,223,166,210,239,121,16,164,212,230,198,33,63,150,165,9,54,147,43,215,241,224,55,27,106,204,89,39,184,161,80,49,4,115,240,147,14,244,80,211,157,188,47,240,27,232,175,82,215,194,147,55,86,12,143,240,196,252,206,171,147,238,96,167,220,204,222,124,57,43,217,33,94,205,196,224,116,99,78,12,233,159,227,1,76,43,79,235,217,146,66,161,211,175,94,65,74,199,243,183,6,81,84,203,242,106,233,76,173,158,214,45,43,108,174,250,106,136,126,230,63,14,251,213,18,71,87,50,64,255,236,85,183,102,109,45,1,174,202,9,149,185,253,197,58,210,45,138,136,51,85,221,138,73,184,106,127,134,253,72,58,18,180,62,151,29,82,139,220,202,116,64,248,20,81,96,109,47,138,242,186,193,36,58,228,83,194,172,38,0,252,218,244,10,112,115,142,57,210,57,11,64,200,229,159,61,193,101,132,118,218,80,148,208,24,56,50,42,216,65,221,198,222,42,94,40,195,189,60,175,28,71,25,114,164,42,45,8,67,46,142,204,238,25,167,37,150,221,46,11,216,39,161,104,150,116,113,1,94,67,6,9,155,180,85,217,5,244,160,99,51,203,177,93,136,13,60,29,150,143,141,45,240,202,86,52,252,208,169,251,4,6,159,54,129,123,18,109,207,1,191,79,38,187,105,43,96,244,160,246,58,53,1,126,98,82,106,12,250,65,44,103,65,155,146,190,0,201,249,32,20,57,171,220,149,156,114,51,66,148,220,137,156,113,120,32,169,126,124,13,130,177,138,31,55,46,148,240,128,29,71,141,116,145,112,8,66,189,190,216,123,114,164,94,213,103,242,213,46,100,240,150,169,179,251,110,47,164,50,174,245,163,245,59,14,243,8,35,82,74,151,19,130,70,32,129,139,54,14,190,35,131,230,71,44,133,253,187,52,219,118,239,235,58,76,31,196,252,32,242,187,197,157,187,55,29,121,51,214,250,24,234,46,96,133,232,102,63,43,191,186,226,113,189,64,205,186,249,119,43,113,194,61,250,58,221,69,191,75,14,152,187,167,243,108,156,124,46,5,218,175,243,118,7,240,85,167,144,192,213,61,210,252,162,165,162,46,86,124,240,63,149,35,88,159,198,71,207,56,140,25,144,133,248,190,191,241,252,13,124,234,108,165,9,106,44,119,178,102,193,221,168,140,143,125,102,211,106,41,163,241,103,12,131,227,10,78,64,224,131,209,128,108,224,131,81,196,188,208,57,0,65,7,171,245,92,68,97,155,26,19,0,220,173,153,62,182,16,55,19,229,89,135,80,157,145,162,168,60,3,54,77,8,252,62,78,45,97,13,187,5,95,233,221,143,244,218,237,9,191,191,111,230,19,235,185,24,229,133,236,211,127,22,70,243,186,237,63,6,52,140,155,111,172,124,143,130,20,198,240,17,48,164,10,74,221,17,240,102,82,73,186,66,214,132,28,226,189,253,197,216,71,13,102,76,54,192,250,157,250,97,33,169,125,119,76,18,127,148,89,55,79,41,27,171,173,241,40,25,242,210,152,51,104,129,66,79,162,178,205,127,78,159,148,90,244,237,62,200,220,157,71,215,30,45,95,17,166,151,2,107,156,25,214,202,113,205,64,70,182,24,9,62,176,176,190,16,176,188,96,117,242,77,22,88,50,108,118,138,246,209,82,199,143,160,77,201,121,197,140,194,143,8,181,195,45,95,221,40,139,214,14,153,166,70,195,180,165,102,177,227,237,193,79,231,55,66,91,102,116,212,200,47,182,152,106,44,255,140,122,66,158,160,250,117,112,5,28,227,9,101,161,115,43,75,216,160,129,201,85,4,155,212,168,94,163,160,204,9,102,25,233,102,160,184,227,106,238,100,129,31,84,122,126,254,145,223,210,150,80,172,229,177,248,245,3,169,238,5,16,2,78,51,54,207,82,72,227,99,136,26,105,129,53,22,17,45,214,181,195,68,36,56,169,195,242,5,8,191,67,154,4,98,246,26,112,153,140,77,237,240,2,154,115,169,245,170,100,202,110,18,149,98,123,104,24,71,192,232,157,222,215,83,47,36,18,129,246,103,237,227,185,218,144,30,199,136,151,160,138,100,74,32,166,208,86,67,75,237,132,120,166,153,52,64,10,225,171,2,81,131,86,59,191,48,93,62,184,125,186,164,181,232,91,66,146,242,21,173,53,43,188,74,248,215,108,185,224,167,76,81,71,206,93,12,235,166,22,241,224,190,133,235,131,111,103,60,230,112,49,52,171,86,194,94,59,123,115,191,87,69,241,194,32,229,82,37,247,66,83,202,39,30,54,213,89,3,78,249,44,22,248,167,57,0,84,189,32,168,147,103,6,140,148,202,187,193,37,38,180,46,29,166,57,72,223,230,106,44,108,111,251,141,251,89,7,111,191,116,203,52,57,144,49,241,196,170,155,145,94,130,81,6,8,48,239,173,230,55,130,69,187,163,225,66,214,151,106,237,182,124,152,252,164,152,71,188,138,18,156,234,158,96,75,48,112,107,71,163,19,180,198,24,225,112,151,114,89,6,217,49,26,232,78,138,51,90,69,91,193,126,130,54,20,217,158,121,249,61,85,203,2,97,83,109,237,170,254,0,91,197,122,244,126,45,233,234,109,127,179,19,219,93,31,65,76,94,19,176,192,62,20,225,161,144,181,212,117,211,254,177,20,119,165,4,191,21,105,172,116,103,36,198,101,166,240,111,212,21,87,239,249,26,153,242,52,76,142,34,251,237,81,66,187,57,122,29,236,37,110,21,148,230,218,247,104,63,1,234,5,69,199,73,134,157,172,42,231,147,224,75,141,129,211,82,4,89,195,246,70,171,181,93,183,55,108,159,166,33,84,4,185,111,204,210,203,121,247,47,11,38,196,128,175,73,224,158,13,7,251,219,162,20,164,80,64,199,241,117,6,96,69,101,173,208,37,165,211,107,165,193,43,31,159,138,214,247,2,33,12,191,208,158,105,240,17,229,141,41,237,45,38,45,115,88,232,28,191,188,150,228,13,47,17,235,94,149,41,105,96,203,124,26,222,106,9,189,50,92,15,120,136,57,57,255,99,51,112,155,217,186,209,181,137,48,198,43,39,230,86,230,26,217,240,223,93,238,195,80,220,79,238,160,255,161,52,146,25,191,179,0,106,203,39,179,207,46,133,153,151,239,88,57,122,189,135,89,178,115,230,216,10,114,143,251,93,168,61,169,202,150,202,196,237,75,49,182,183,125,110,19,34,1,136,14,89,81,155,227,118,201,69,250,152,109,216,132,250,88,147,48,2,191,100,195,211,13,126,162,119,72,133,229,123,207,22,23,212,210,63,155,150,227,57,166,222,129,67,70,42,85,154,245,247,41,193,230,95,156,113,40,103,226,86,19,6,181,49,124,103,224,189,223,33,119,236,24,20,229,68,141,154,5,89,177,163,212,125,152,33,38,48,226,24,141,151,158,51,86,207,22,139,80,172,113,125,82,37,229,71,24,29,22,151,195,95,177,29,49,74,158,121,217,68,52,92,168,158,88,196,251,22,3,155,79,122,252,156,221,200,181,70,100,216,71,156,175,156,86,2,231,130,108,43,211,119,75,181,114,163,95,222,24,246,255,186,183,186,101,37,137,223,53,194,47,117,58,55,235,209,179,14,167,242,26,134,221,36,193,38,118,184,207,96,67,32,145,250,154,128,94,25,66,185,48,57,213,130,222,58,197,173,252,78,101,199,141,206,155,94,81,157,155,216,239,200,168,141,203,59,210,55,17,55,170,5,110,70,51,20,19,17,219,187,198,121,220,48,135,101,52,185,215,244,4,37,229,220,138,211,126,144,244,210,14,194,134,9,176,26,52,128,5,94,173,63,199,171,196,37,142,16,185,13,98,224,38,105,153,24,182,124,179,35,177,69,226,224,127,75,236,2,98,7,44,185,3,14,107,156,129,152,51,36,29,203,211,203,108,162,74,162,216,89,12,128,9,112,14,157,147,3,227,248,177,51,228,239,231,213,231,254,82,42,244,137,106,99,170,156,192,66,71,139,213,5,156,125,195,124,229,130,190,205,89,225,241,254,176,95,30,219,40,248,129,218,116,222,75,183,241,249,60,88,178,52,92,157,156,113,232,162,36,107,47,55,17,155,162,70,224,125,82,84,211,203,26,49,246,193,94,207,161,122,216,126,138,16,206,87,28,38,45,30,196,186,30,68,206,95,156,208,218,236,93,107,125,217,121,46,223,4,69,183,46,238,206,71,72,167,159,167,48,118,25,0,159,147,140,99,166,172,4,113,21,161,52,102,54,219,194,90,106,50,6,156,202,21,86,112,33,45,53,6,124,162,83,226,178,246,1,165,167,177,190,237,128,219,79,114,30,187,31,146,10,157,251,80,124,108,191,233,91,104,68,35,156,13,54,123,191,37,77,245,82,222,206,8,246,133,27,217,87,116,7,145,65,128,81,142,250,19,137,207,10,217,88,150,119,183,30,231,123,9,189,145,113,150,247,204,148,101,142,228,144,127,101,122,157,153,221,45,112,44,139,13,223,94,18,221,245,14,185,252,132,117,15,173,122,121,1,251,109,2,107,25,97,29,180,199,11,124,161,138,37,92,119,254,245,118,34,128,28,100,200,80,5,114,99,208,232,126,215,247,226,193,129,111,229,166,12,107,30,67,118,84,156,100,158,204,44,28,118,134,227,10,22,153,126,77,13,134,137,18,167,115,62,98,60,182,179,66,109,93,146,39,135,247,137,193,45,175,156,83,87,217,63,250,57,154,128,151,152,45,35,43,126,198,229,219,126,200,145,4,236,251,153,196,162,89,73,134,96,119,107,128,190,147,228,64,73,220,100,124,73,203,91,213,77,92,68,50,107,69,237,110,138,228,193,175,162,213,78,39,118,105,39,11,196,157,25,195,35,53,250,121,123,219,197,179,143,206,30,210,251,106,231,243,37,84,55,23,7,30,84,11,121,92,53,9,191,28,49,57,237,112,78,183,12,215,243,99,159,238,14,246,197,136,207,69,0,120,99,89,37,184,54,94,128,204,224,174,118,50,226,59,151,162,115,167,144,223,213,199,4,87,55,193,10,212,169,238,242,254,70,213,252,87,32,245,18,157,79,122,232,143,103,31,93,140,93,243,91,156,91,223,136,12,68,98,200,179,170,185,195,112,27,104,3,205,165,28,186,174,118,57,189,119,144,158,95,158,164,143,139,58,87,217,43,22,68,43,126,240,70,94,163,225,233,248,227,168,70,198,16,51,205,239,192,4,124,244,190,80,130,188,253,65,63,201,98,243,142,139,238,115,52,164,188,234,11,203,33,66,111,40,174,113,78,139,135,102,209,122,166,53,10,2,10,140,215,139,223,100,11,23,208,126,65,214,52,37,98,93,37,250,159,75,209,155,248,86,107,5,114,199,254,105,179,240,132,18,228,65,136,188,180,168,141,149,43,234,13,114,25,92,32,8,212,172,186,194,234,241,77,20,142,76,140,225,110,176,248,93,52,69,8,47,143,25,99,166,56,37,228,218,183,234,205,236,237,168,228,136,179,145,123,254,230,182,37,220,223,96,199,45,24,147,73,86,254,47,90,124,89,129,192,199,167,216,217,62,148,163,46,107,74,67,155,206,30,163,44,42,238,69,77,5,86,126,151,131,136,59,134,63,72,23,50,35,228,75,48,172,147,4,200,35,217,142,56,51,159,145,237,51,218,27,192,43,193,90,63,194,218,149,77,69,58,68,24,177,235,144,245,52,41,241,21,63,202,204,123,60,245,245,147,59,230,53,58,179,177,6,108,72,142,101,202,171,147,1,238,27,183,145,157,7,29,13,111,137,129,183,185,196,139,126,204,48,220,237,170,227,65,153,226,170,245,241,69,250,74,235,39,129,115,94,113,165,212,140,219,239,255,30,2,150,71,167,222,250,123,230,253,102,110,67,175,23,73,166,0,144,47,148,163,151,221,23,81,24,247,230,191,244,11,1,206,112,51,40,182,33,40,163,61,107,169,167,6,202,202,72,255,23,102,172,225,38,148,226,88,109,43,255,21,145,157,184,0,241,95,26,253,89,42,53,13,149,184,8,74,173,119,80,63,39,122,131,186,46,224,96,135,125,146,230,186,215,105,91,230,163,169,125,167,150,59,214,137,125,94,22,30,51,110,143,175,201,170,44,185,136,253,28,105,89,77,41,65,135,12,60,237,170,191,75,127,88,149,34,205,123,6,139,121,217,249,166,254,165,197,104,144,84,48,58,172,21,122,128,85,199,148,36,114,91,239,123,1,206,8,169,49,206,39,142,97,137,189,224,169,198,119,13,171,201,140,49,157,103,118,88,94,210,27,126,242,245,68,55,25,204,114,244,247,64,29,145,137,154,56,172,22,62,19,227,79,143,90,5,12,201,194,154,224,71,103,79,31,119,20,146,114,219,19,44,92,21,211,69,49,20,95,47,183,25,195,60,209,50,238,182,244,59,9,94,112,27,36,210,214,7,152,57,84,87,219,76,117,252,173,214,2,188,162,120,141,43,194,108,127,121,25,148,205,129,10,46,39,41,144,243,52,218,147,187,37,188,247,50,228,177,63,51,214,17,10,240,24,244,129,34,87,146,124,5,230,163,171,120,234,22,101,103,156,68,245,144,114,132,132,244,163,47,127,235,219,88,243,187,140,196,153,78,126,139,116,152,107,147,27,119,0,2,213,231,59,70,73,214,67,31,130,51,71,155,189,211,225,165,140,83,24,36,56,202,105,50,33,140,155,216,216,209,252,54,156,254,20,81,120,206,235,241,53,194,44,177,128,30,239,26,95,124,88,90,21,132,123,188,158,141,127,241,223,95,178,108,21,221,145,222,26,192,180,84,129,78,175,117,146,57,215,116,10,13,53,12,252,227,64,32,115,213,68,143,238,155,225,101,184,132,28,92,127,89,232,1,139,160,185,99,115,92,29,188,211,254,180,85,121,47,205,53,199,122,73,153,119,188,74,163,229,129,90,48,50,178,91,189,168,116,38,32,114,55,89,132,116,208,124,128,113,113,16,206,199,26,163,212,71,1,250,155,96,53,100,44,246,31,136,208,243,220,60,176,23,103,88,245,48,51,59,225,235,226,76,182,53,49,135,126,117,23,4,0,51,62,11,237,65,252,21,246,193,84,14,85,217,111,240,108,226,134,59,194,210,198,214,9,245,99,101,81,3,89,134,225,173,80,61,204,115,250,25,191,22,137,42,177,155,159,237,248,200,39,189,1,66,189,88,8,198,57,47,194,59,150,74,50,244,192,145,124,139,137,9,88,183,226,179,162,219,55,201,222,186,109,36,242,146,104,134,170,9,120,67,123,240,251,118,184,113,206,203,242,204,29,95,103,160,139,24,229,246,174,44,232,1,92,51,119,121,192,74,200,193,169,150,115,168,56,37,31,105,175,166,10,183,252,135,115,233,34,0,229,124,183,246,177,143,42,237,125,2,142,154,240,49,228,213,15,77,123,202,79,84,0,147,189,200,161,106,243,41,87,86,158,216,240,246,100,112,9,91,213,220,206,108,190,57,220,218,99,189,47,194,120,28,127,254,169,178,91,243,109,75,134,210,210,244,242,159,54,217,20,133,68,233,153,234,101,91,233,30,96,171,224,92,91,176,236,182,188,20,131,21,122,84,104,171,14,236,252,249,75,212,235,191,95,11,62,141,94,241,165,26,219,173,197,153,214,168,223,240,94,213,113,148,95,22,212,203,134,117,232,60,147,51,11,201,54,4,81,122,170,58,150,209,147,128,196,78,68,78,148,160,114,198,127,162,120,180,68,133,22,76,101,119,11,93,246,9,232,183,127,140,173,92,221,236,51,178,45,217,246,70,118,91,129,102,24,199,252,7,6,116,81,43,240,49,115,77,164,134,23,10,184,92,26,223,238,174,254,108,5,221,29,205,3,38,30,51,143,196,202,21,102,228,51,105,45,191,54,175,140,175,135,132,56,183,9,116,20,68,132,18,220,233,176,239,82,87,160,87,75,33,255,121,193,156,78,230,23,79,64,52,198,99,148,130,106,107,8,203,26,34,248,194,178,123,242,238,250,69,219,168,219,185,118,64,221,220,7,62,58,172,34,161,85,252,155,52,152,60,87,103,183,167,226,234,225,170,247,90,38,143,81,89,210,156,20,60,194,148,113,179,171,5,77,184,78,26,208,131,200,86,18,46,116,74,134,61,119,29,194,3,117,40,80,168,90,103,191,42,184,95,218,91,28,155,54,146,65,95,188,105,77,14,205,75,249,117,46,221,98,224,169,93,190,83,43,182,146,208,7,135,154,99,250,12,2,189,246,105,220,172,175,69,1,167,218,186,57,136,247,112,149,221,32,11,202,229,160,52,60,200,208,193,198,75,246,250,53,55,150,176,139,93,85,222,206,205,111,9,73,162,186,211,69,140,188,136,164,203,223,18,225,119,181,234,138,60,23,112,75,105,15,203,7,125,177,246,31,45,74,151,48,22,139,175,136,183,250,161,111,94,119,158,113,175,140,79,29,122,65,55,233,80,125,200,31,209,18,35,82,3,116,190,125,208,46,253,125,100,73,160,238,5,244,38,184,200,7,167,119,122,165,28,250,26,52,110,188,151,63,208,63,248,94,165,164,111,163,146,32,37,5,60,85,192,27,61,24,60,161,222,0,4,254,155,189,84,196,0,157,35,12,162,103,138,192,135,38,45,40,41,69,63,30,177,222,41,253,200,54,63,230,237,20,103,172,23,99,192,215,2,181,198,52,12,1,157,162,169,147,206,27,237,188,158,40,214,164,233,240,100,201,245,24,178,38,205,66,140,166,43,132,117,143,233,22,167,190,202,18,188,127,240,184,49,182,87,84,214,121,140,169,20,29,122,133,69,18,168,61,132,146,108,35,131,109,86,101,183,150,34,77,90,194,24,46,232,28,48,183,206,47,100,61,163,165,74,17,92,27,210,106,16,222,186,117,41,103,197,144,3,27,9,248,132,189,88,83,122,219,49,116,2,50,30,40,205,76,130,35,126,83,228,228,138,171,171,135,39,196,227,87,106,235,241,239,86,179,253,11,23,99,7,66,41,158,178,157,76,234,6,5,214,254,184,155,181,84,197,165,122,251,119,249,236,166,219,144,14,253,20,200,71,185,128,249,58,15,196,101,206,51,124,190,50,159,255,10,172,123,168,253,230,89,10,236,71,194,62,129,71,92,165,85,0,198,135,157,141,191,50,13,140,37,124,110,249,46,46,25,251,68,145,8,18,120,51,137,142,119,244,148,246,141,26,132,163,135,241,35,159,49,77,209,163,230,111,6,242,146,195,49,170,2,124,194,17,165,42,155,254,34,50,37,48,67,234,117,90,102,69,129,61,195,172,78,87,34,46,79,146,168,210,166,122,231,226,222,204,251,20,75,223,196,242,130,34,225,110,75,207,175,78,24,239,45,171,104,198,59,0,19,49,11,243,112,43,250,158,62,80,155,237,46,52,188,185,245,171,68,197,202,251,110,93,211,94,67,191,87,157,87,233,13,61,47,52,206,80,194,167,66,67,198,170,244,247,174,171,50,79,255,184,161,14,254,202,162,162,254,221,148,221,251,90,102,154,71,98,61,150,1,32,250,227,57,240,168,21,174,152,107,235,75,2,198,35,117,161,148,210,231,214,184,87,241,102,16,184,144,221,165,158,108,17,177,46,228,156,159,149,123,171,239,250,40,10,62,189,159,144,124,7,64,76,122,161,214,158,46,206,191,99,142,189,68,40,168,172,65,88,130,102,169,121,107,188,201,117,35,139,212,14,176,77,110,172,197,14,238,254,189,108,234,224,228,68,226,121,230,183,185,224,25,14,142,86,3,2,21,133,116,109,24,125,214,126,192,236,107,42,30,208,247,43,102,62,205,11,213,177,80,163,92,245,82,101,244,192,151,191,169,102,204,190,167,232,66,226,12,115,238,131,188,181,235,30,55,68,17,186,125,64,121,44,39,147,240,53,20,40,101,224,109,239,226,32,115,253,200,113,202,118,207,81,168,138,146,224,129,38,168,181,120,87,225,170,24,6,223,254,59,48,103,66,191,112,18,100,232,149,121,191,132,39,231,12,223,111,202,150,238,150,76,143,41,37,183,222,8,16,24,33,99,101,144,218,10,68,70,133,97,95,109,42,67,13,102,0,93,189,206,41,149,160,206,101,195,209,76,22,231,109,76,142,113,78,222,63,202,227,65,140,154,29,47,96,41,58,77,137,107,249,152,7,126,53,105,31,221,134,107,150,14,18,108,110,152,91,57,88,146,199,220,12,79,116,220,134,180,176,224,71,97,52,154,76,94,230,58,14,196,154,89,27,162,219,96,227,91,143,175,92,36,179,222,30,59,163,32,250,146,96,163,83,134,33,18,27,99,127,113,171,35,52,143,96,219,71,71,254,216,30,244,75,88,241,242,50,213,1,83,56,154,152,153,219,130,166,175,82,10,125,111,96,137,38,46,205,11,85,195,29,184,117,250,218,58,49,10,40,30,139,211,81,157,249,51,33,100,201,34,96,197,189,206,48,180,50,2,111,154,109,10,90,116,189,224,85,45,153,10,96,210,142,179,131,174,213,131,9,90,194,235,113,201,152,223,253,134,198,136,215,196,121,114,145,127,197,63,226,22,10,124,149,177,37,12,217,218,113,9,235,142,49,103,237,98,82,140,8,127,97,56,61,78,76,142,106,216,56,78,153,139,60,223,243,28,34,38,199,137,132,50,118,151,58,141,192,20,249,138,53,114,177,45,146,78,147,234,123,244,61,157,119,7,88,41,82,17,102,213,59,93,79,45,40,157,139,219,81,12,134,18,77,1,101,45,228,155,66,227,243,242,202,71,136,205,94,102,239,237,253,62,207,30,222,178,58,135,219,74,150,232,27,209,251,37,198,33,83,209,39,249,183,21,38,213,39,143,198,149,91,161,250,193,43,45,233,70,234,118,173,231,180,151,157,138,7,167,198,81,194,51,164,200,83,56,176,121,167,225,108,50,245,125,137,148,215,111,59,19,64,109,5,114,176,218,137,186,235,94,254,156,96,194,168,34,159,84,171,68,70,215,155,148,244,240,11,54,128,75,56,161,201,231,65,137,194,113,32,89,201,13,141,169,131,94,198,168,132,135,101,50,165,181,8,159,184,15,19,74,16,105,43,25,168,214,106,76,164,64,91,12,74,22,16,124,27,121,145,188,125,255,96,131,33,245,145,180,29,62,194,137,30,62,243,129,77,13,158,163,117,162,206,61,236,135,244,220,166,174,217,73,139,0,254,201,26,125,241,33,68,187,155,235,119,25,72,196,151,8,255,8,84,250,43,102,204,134,121,186,123,144,48,2,235,7,229,41,190,150,181,169,203,226,194,118,180,182,162,220,222,14,52,114,197,229,86,207,201,148,241,246,69,68,231,8,57,6,21,171,44,83,134,151,83,25,48,142,91,248,21,21,213,9,104,208,21,12,133,100,100,144,124,237,193,56,180,34,39,246,232,53,212,121,61,127,221,103,74,114,150,223,11,229,210,6,76,40,95,192,199,167,100,100,64,117,44,73,13,187,42,241,47,212,35,164,55,64,85,88,41,102,68,165,110,72,100,66,38,33,14,166,233,157,80,35,137,1,69,63,111,169,42,19,65,190,106,104,216,90,154,147,190,183,207,177,145,142,190,213,148,10,228,251,99,58,72,148,192,227,20,1,79,110,181,47,89,218,133,7,75,111,229,49,60,97,179,158,28,51,110,139,80,56,147,33,182,227,153,92,32,1,241,44,181,143,24,16,252,26,129,134,63,65,186,1,160,90,254,21,88,43,220,101,222,156,214,211,98,172,42,254,193,103,147,61,229,181,85,228,223,127,163,201,157,106,97,82,251,201,89,32,245,234,92,103,151,70,111,44,210,74,166,88,95,204,82,185,9,218,72,146,27,181,139,97,122,22,228,206,84,237,87,140,101,100,110,216,186,226,110,186,109,140,162,59,52,3,26,96,176,41,84,66,47,216,100,110,106,2,55,106,165,232,43,156,42,193,122,42,74,224,96,101,41,240,141,4,88,29,113,31,121,80,196,152,15,234,154,70,129,228,97,137,99,89,108,64,143,32,111,199,220,209,192,20,24,80,192,202,191,169,156,133,210,36,179,17,149,67,213,52,180,176,134,253,181,179,174,87,217,236,254,162,137,201,192,88,23,89,195,231,73,182,226,224,149,99,172,221,135,5,241,132,86,236,118,69,50,108,27,103,65,17,127,75,11,160,71,85,227,148,153,62,103,83,250,192,254,215,123,252,157,8,112,132,210,193,21,244,168,131,44,69,226,190,243,10,225,163,84,190,118,32,19,193,234,220,32,188,74,90,197,143,70,191,99,113,186,143,49,131,109,253,62,234,221,183,103,238,89,65,67,11,230,9,222,24,95,129,14,228,125,126,166,49,29,239,36,39,124,130,203,200,105,29,231,182,43,1,179,193,103,230,251,205,22,182,65,191,137,110,165,113,180,60,209,87,212,7,69,241,130,157,125,59,225,89,244,120,134,142,170,92,19,65,251,87,163,83,32,185,163,202,187,191,34,192,183,186,236,30,222,225,180,237,142,162,77,93,190,100,248,70,134,164,253,105,255,142,189,83,50,161,225,223,241,240,252,170,90,122,221,22,108,187,81,31,252,76,218,238,217,175,90,110,37,190,8,65,147,181,160,202,39,24,230,218,92,233,102,123,98,72,215,163,152,111,198,25,215,60,213,1,254,4,168,45,13,40,238,142,158,60,70,241,144,183,215,236,146,149,13,234,215,133,3,112,135,7,8,40,195,214,105,244,172,246,200,198,238,153,112,100,59,137,18,122,9,204,17,41,181,111,41,61,21,160,16,170,194,218,178,62,88,92,199,233,200,24,70,246,142,224,164,200,210,237,216,75,100,45,115,160,117,92,38,226,170,215,156,203,215,210,248,231,199,216,248,161,125,167,132,103,180,186,9,249,4,154,16,237,107,80,28,27,235,150,39,210,201,153,66,17,97,165,29,15,167,130,23,77,17,106,160,90,248,47,219,164,20,127,81,248,1,36,254,22,50,208,65,145,45,220,160,93,16,45,62,229,177,187,144,167,142,26,248,232,6,191,77,59,136,49,2,33,116,66,65,146,218,44,111,73,2,222,99,111,24,180,41,67,103,39,216,168,240,207,142,34,241,86,17,173,37,58,64,186,213,98,181,151,159,141,26,22,31,45,92,64,9,10,26,76,181,236,145,18,8,30,219,158,183,71,138,134,56,65,70,34,140,141,13,54,245,29,155,227,200,183,113,40,113,203,86,214,2,162,90,237,5,247,2,186,149,205,73,75,106,255,178,8,39,126,21,96,43,117,216,10,81,98,244,208,25,252,177,189,21,50,204,13,115,42,29,115,2,10,234,207,168,29,131,228,241,82,183,158,85,177,161,142,249,81,208,74,7,73,61,160,142,153,121,63,78,230,152,77,38,100,58,119,15,102,23,145,201,189,165,77,147,230,208,2,84,68,22,86,13,32,68,58,88,73,8,48,139,117,27,222,40,32,182,33,168,89,188,113,162,162,146,225,102,118,158,53,22,82,149,184,240,92,212,243,40,50,170,149,147,223,104,185,45,162,20,59,162,173,157,5,224,233,8,159,219,28,215,102,178,59,121,254,199,162,199,99,2,69,53,6,16,218,9,6,241,44,220,188,45,208,250,244,235,250,209,70,110,222,198,183,219,47,135,143,170,11,226,178,201,194,8,0,115,63,105,158,9,227,172,16,176,218,211,18,70,236,5,109,35,119,143,218,145,213,190,153,247,240,232,191,61,9,58,130,175,235,45,122,195,207,43,194,102,133,91,46,230,18,78,212,122,114,168,4,94,120,96,72,18,12,142,191,141,105,202,78,241,114,85,34,238,84,11,10,254,50,188,122,76,216,117,121,110,3,95,91,62,253,60,174,139,195,120,183,220,61,229,75,22,220,190,134,216,68,90,111,184,152,40,130,43,39,76,144,94,215,83,252,62,127,27,6,175,158,50,87,41,85,95,32,24,14,193,22,92,54,156,254,77,61,50,7,243,25,48,156,89,56,17,33,107,135,110,160,52,80,216,55,217,98,40,102,1,34,70,233,200,205,172,234,156,17,180,123,113,143,67,81,224,51,149,12,213,251,3,2,63,30,249,181,254,120,160,155,133,96,137,181,35,5,182,121,214,39,128,129,237,203,19,137,24,93,101,255,228,209,34,58,241,253,187,131,60,8,241,178,36,11,26,109,21,150,214,31,242,19,60,118,147,158,111,23,164,168,73,67,92,231,211,6,86,222,242,248,107,142,231,119,143,1,168,27,187,91,70,38,230,162,216,232,152,83,71,41,183,182,189,94,221,128,7,217,182,42,49,232,20,23,3,87,95,213,181,137,117,14,161,52,243,122,183,193,90,134,182,58,222,179,72,150,241,129,197,216,227,156,20,75,90,202,71,128,15,137,242,183,117,188,168,252,39,243,76,167,222,12,190,250,197,206,164,145,191,47,206,24,20,40,253,36,4,220,72,143,199,19,105,30,48,219,215,196,37,15,182,38,220,134,239,35,187,29,230,68,215,139,220,215,90,25,184,246,196,149,239,249,142,248,63,141,205,161,28,87,142,170,237,214,67,142,251,97,163,163,242,208,139,28,201,5,249,160,111,232,64,231,207,201,197,196,206,92,127,71,17,57,48,200,25,226,176,113,210,162,108,233,45,224,15,40,196,161,187,228,55,88,74,235,30,68,12,209,70,87,243,159,85,208,70,192,75,111,14,15,239,6,234,134,248,30,113,51,255,128,43,104,82,6,158,241,74,19,174,199,229,132,238,6,70,145,96,242,208,185,17,12,251,210,13,113,233,186,188,29,9,195,244,71,62,26,195,82,44,209,10,230,93,188,92,234,241,145,115,67,77,67,44,210,249,228,5,84,43,160,77,103,214,59,87,195,200,20,129,254,173,229,229,37,115,254,49,72,119,145,188,255,12,95,191,110,239,124,12,213,234,217,4,211,133,39,184,242,103,223,13,5,50,56,74,214,135,66,130,62,223,167,91,175,30,40,134,82,42,167,175,169,33,40,205,88,123,104,96,189,142,226,130,73,0,60,121,128,225,203,146,1,170,4,93,235,72,243,97,77,129,92,246,173,53,161,138,204,83,70,234,80,223,20,176,62,149,150,127,141,182,196,163,80,117,13,31,248,64,166,35,112,96,44,221,70,128,124,229,74,60,65,83,15,20,135,165,184,82,153,163,153,145,137,168,21,68,140,120,76,239,1,57,32,133,38,158,157,114,92,79,139,129,100,233,109,73,206,6,164,101,18,250,41,214,14,185,87,241,153,142,116,3,55,77,138,149,123,112,38,59,191,132,156,136,205,108,175,236,117,66,107,36,241,192,147,149,227,116,253,26,209,34,134,94,214,68,212,25,142,117,207,151,32,13,101,187,154,38,54,165,162,58,254,142,54,86,89,13,232,46,36,31,67,169,250,183,168,205,55,163,165,77,37,211,28,12,51,80,99,47,117,190,69,215,83,246,24,48,152,252,50,167,183,242,94,21,63,211,171,23,199,4,160,172,57,57,92,128,50,52,174,87,77,255,17,221,149,165,195,162,43,38,226,27,221,101,124,188,82,226,222,49,132,246,31,27,81,255,205,69,176,163,195,253,83,47,80,99,157,132,223,160,92,39,120,73,149,51,171,255,67,218,107,160,220,58,236,28,119,180,1,82,24,146,160,44,200,70,141,109,254,12,126,229,95,99,96,3,216,221,136,205,113,142,122,186,243,183,255,22,253,97,176,39,222,179,209,180,233,133,72,37,54,158,28,65,95,13,1,59,153,193,87,230,128,104,160,201,205,2,196,6,125,232,155,188,65,83,240,126,145,178,63,143,0,240,193,78,184,2,226,82,240,49,22,50,167,206,196,168,121,68,212,156,249,154,95,24,93,83,113,168,33,14,246,208,135,139,78,122,101,123,8,177,97,182,122,128,106,140,8,192,100,143,88,196,50,29,207,215,143,65,120,133,133,118,94,128,12,106,130,195,165,203,112,192,173,166,222,59,23,34,6,82,131,16,84,214,205,87,208,140,201,182,166,221,131,122,181,85,150,65,139,133,103,23,179,159,231,7,175,204,95,130,131,126,45,155,135,76,69,145,54,197,251,173,9,206,46,189,122,101,178,24,17,52,231,121,151,60,255,66,47,5,0,134,235,185,232,129,137,35,158,3,110,230,211,73,61,209,224,71,153,55,248,61,100,233,170,140,66,27,177,253,40,208,209,143,4,27,108,105,166,136,60,8,218,119,168,182,107,8,119,5,118,31,219,43,94,70,182,91,68,254,135,245,212,250,26,105,156,109,180,133,177,249,140,89,130,79,55,31,123,18,154,42,191,139,9,240,237,151,107,173,188,134,243,132,118,79,249,197,52,29,174,60,127,48,203,213,101,118,178,117,92,200,49,217,119,172,213,150,231,103,134,168,200,159,174,105,85,8,72,53,243,196,179,102,171,173,207,190,134,186,250,180,231,155,193,203,81,248,175,8,196,145,73,186,178,63,177,60,238,12,42,169,79,173,245,76,171,131,19,102,237,156,201,116,42,209,167,158,198,227,114,197,227,182,212,229,151,110,140,149,239,82,124,137,145,167,26,54,159,102,237,132,139,121,181,115,78,145,179,231,40,243,114,107,190,126,230,152,86,21,43,130,126,87,172,107,120,215,174,119,95,238,138,107,162,109,30,0,156,48,191,59,137,171,39,151,249,219,16,202,29,186,7,225,198,202,213,119,26,30,46,66,61,154,127,212,160,121,30,139,137,77,16,197,1,225,23,181,190,52,124,88,224,250,45,111,131,115,99,26,188,227,244,207,13,101,230,130,96,187,90,109,141,203,246,150,213,238,2,180,162,199,113,129,255,97,7,65,101,37,145,166,70,193,39,68,86,45,6,162,80,189,182,147,237,204,108,173,114,12,139,6,79,110,178,50,39,17,113,41,178,217,61,88,132,240,93,181,152,170,7,71,170,146,115,177,209,87,215,16,157,38,76,45,46,220,16,103,58,125,32,153,241,187,154,232,13,56,84,165,56,94,8,6,118,36,14,96,65,93,68,50,208,97,85,185,103,1,161,83,67,194,38,128,76,181,204,102,151,40,72,219,119,58,243,206,0,99,50,157,241,110,31,75,39,89,181,28,80,34,47,54,40,145,0,60,100,212,148,16,35,19,189,130,103,237,1,19,109,241,72,134,148,103,72,23,209,106,186,211,41,196,18,76,23,75,122,68,251,50,11,252,232,52,72,57,5,52,226,217,252,184,71,71,112,106,214,93,60,250,235,235,115,148,64,183,222,82,158,135,135,145,153,54,138,126,116,216,66,235,51,100,7,1,111,11,231,57,153,174,195,76,173,195,2,137,227,217,61,109,233,31,68,5,179,235,72,80,16,191,118,37,76,119,131,246,39,251,58,127,172,229,32,135,167,216,216,39,54,7,180,45,236,44,47,186,218,5,45,145,201,222,24,126,214,198,237,218,245,74,159,119,201,233,27,224,213,175,46,43,252,104,209,254,53,126,25,166,190,157,66,64,23,226,4,74,69,28,42,238,195,233,33,1,64,116,16,110,32,81,97,57,242,250,108,13,200,31,184,115,30,190,65,111,225,197,90,215,174,221,193,216,165,11,16,3,153,141,181,161,223,213,141,64,243,41,33,65,208,245,48,203,171,242,234,120,183,57,60,85,83,188,148,249,94,62,178,164,119,223,137,180,49,184,166,120,134,127,76,230,216,208,161,5,42,237,196,235,114,222,23,134,110,242,244,163,1,42,228,3,251,93,156,48,46,154,200,19,163,205,213,250,142,212,14,156,210,48,20,148,235,204,232,128,21,3,100,38,184,230,249,138,117,207,253,60,79,102,174,115,184,21,102,194,116,47,69,98,110,200,73,248,186,30,220,75,239,155,228,138,141,255,84,179,127,17,124,167,107,102,248,93,59,11,170,167,110,129,228,140,41,111,215,131,169,31,210,192,131,220,50,29,241,34,235,141,60,96,178,83,126,109,14,186,209,248,63,130,108,186,180,105,95,192,234,29,87,8,197,153,103,55,13,10,116,247,40,153,54,84,199,120,69,98,185,228,4,234,107,80,168,240,218,9,114,58,196,150,245,120,244,210,164,160,201,55,20,40,135,138,179,149,228,199,157,192,174,190,79,35,154,208,104,215,44,229,241,125,186,156,42,60,224,60,98,79,40,64,126,207,165,212,10,115,54,25,33,126,58,236,50,194,209,149,85,111,178,89,79,15,60,227,54,174,229,243,135,42,102,50,171,254,95,21,247,31,125,0,215,95,9,254,115,158,204,23,106,103,28,139,202,110,125,119,242,110,213,56,152,116,42,49,235,231,28,252,0,141,119,191,200,51,122,183,74,56,200,99,174,153,239,174,227,16,247,241,53,17,43,147,201,28,236,24,172,158,183,250,239,232,109,178,138,191,154,85,92,101,93,173,175,120,149,115,204,109,250,109,193,172,203,85,254,72,122,109,173,97,223,35,161,59,23,39,177,164,124,186,70,76,36,143,143,79,179,160,167,125,30,112,233,209,141,126,247,37,119,77,159,6,86,22,186,250,64,148,109,116,69,157,161,219,213,126,74,234,55,4,74,150,191,164,59,229,208,73,147,153,74,155,93,93,177,111,177,180,36,107,46,26,222,118,125,41,31,110,95,84,199,96,81,223,99,229,230,111,208,187,44,207,189,197,162,155,118,66,246,102,5,157,180,61,121,27,171,235,38,194,219,47,109,32,238,247,114,130,158,184,151,243,155,87,210,50,16,172,39,124,229,145,237,44,49,206,229,30,118,171,255,129,65,10,175,28,62,65,30,217,20,113,253,179,149,240,28,118,112,140,20,237,39,7,159,242,230,64,144,209,53,33,213,116,176,141,135,111,225,244,248,107,202,235,131,88,130,60,113,17,151,144,193,21,155,78,5,33,221,177,64,101,141,166,1,217,83,16,24,8,33,203,8,73,180,252,201,36,37,193,112,158,81,36,62,12,87,125,150,121,19,39,92,191,173,210,244,36,77,195,88,140,26,156,4,231,27,111,89,251,35,188,185,246,75,176,127,162,75,144,137,255,124,36,161,108,144,154,177,88,19,197,21,51,61,242,175,177,115,118,58,158,40,174,196,158,97,198,184,209,36,126,232,71,189,204,186,7,102,36,124,234,204,89,172,220,192,86,101,51,175,40,9,191,17,115,155,117,200,237,22,138,77,48,250,240,160,224,117,133,170,182,144,213,211,213,2,243,145,65,254,0,2,248,48,33,249,80,119,29,108,76,228,213,3,143,250,23,23,131,183,155,60,55,214,27,114,225,198,150,10,35,148,123,109,118,26,2,65,205,51,165,231,113,146,183,118,99,110,128,192,107,84,128,130,68,16,88,195,165,35,170,219,153,195,92,132,226,34,20,77,81,240,139,150,107,214,77,155,204,106,79,19,168,44,71,198,240,87,142,60,44,60,246,5,116,90,243,72,82,123,206,123,164,157,159,113,100,46,227,97,151,247,172,49,26,253,214,112,110,75,191,20,199,178,121,153,73,146,167,80,165,179,249,104,118,42,76,8,126,200,69,25,1,35,35,219,85,218,235,253,164,63,211,195,178,60,208,120,222,151,167,79,238,35,131,109,53,18,149,50,40,14,206,218,230,111,82,234,124,19,223,6,18,94,196,199,189,219,79,203,3,86,63,184,11,70,220,145,70,39,204,13,70,25,105,99,18,2,0,24,161,197,244,35,162,11,157,34,54,196,92,138,255,30,83,77,170,69,196,207,11,28,60,155,7,88,6,248,72,159,21,242,123,4,244,230,249,74,32,130,186,174,143,2,140,24,130,73,170,186,195,129,0,221,95,213,21,27,147,128,194,103,91,111,210,249,82,200,180,140,107,187,79,132,95,135,105,220,39,219,47,101,130,232,19,153,84,96,21,214,227,184,212,26,88,77,22,173,250,215,51,120,214,55,206,86,220,178,39,170,15,114,12,97,98,239,4,124,47,250,230,133,149,196,82,209,165,151,0,207,30,106,133,62,251,241,196,196,47,179,145,179,2,155,15,5,165,22,67,52,207,39,246,123,134,219,252,174,231,168,82,8,7,192,229,168,45,215,86,100,235,111,169,107,12,249,89,109,86,160,142,181,238,237,223,92,168,130,150,236,224,116,222,45,18,13,13,164,73,38,27,208,24,138,45,80,4,148,58,149,54,128,230,244,22,230,218,179,87,51,104,223,178,9,209,228,14,206,192,249,41,82,34,115,235,125,150,192,196,1,165,252,62,83,243,157,37,218,134,192,149,232,139,145,253,205,51,17,97,192,121,157,60,181,170,126,156,5,44,196,235,223,123,170,2,118,228,255,243,8,132,196,221,30,242,92,159,112,180,131,51,25,126,253,184,7,4,110,34,217,37,185,91,186,44,77,80,104,181,58,171,9,210,180,17,119,8,141,229,247,64,62,232,121,118,112,133,52,173,5,202,94,170,37,212,28,222,193,97,51,164,107,197,181,220,102,52,58,47,147,194,179,174,14,89,19,221,145,39,174,86,249,64,89,192,101,143,207,156,186,210,1,137,143,225,13,38,98,59,92,137,53,31,64,212,100,157,144,100,131,3,65,115,94,185,87,13,25,176,45,184,207,19,250,197,231,86,217,51,191,125,60,11,95,125,105,236,148,166,54,6,42,0,150,180,138,38,30,235,72,106,14,217,69,184,242,46,197,173,38,89,234,41,197,213,165,79,86,118,231,142,207,69,207,108,20,53,179,160,231,84,99,156,253,80,13,15,65,18,73,160,149,31,76,124,141,4,48,207,86,81,87,66,32,121,213,115,116,230,240,201,247,195,159,66,154,244,180,174,14,101,84,3,66,175,40,177,65,194,101,162,234,26,55,222,21,72,164,219,243,129,30,172,104,212,50,6,152,90,233,235,35,221,207,165,225,44,109,74,127,123,173,56,87,209,84,211,48,214,123,5,105,101,78,188,169,175,36,172,214,19,232,125,217,130,252,99,237,244,61,173,193,82,209,216,57,13,12,202,82,193,78,70,69,206,74,240,191,91,25,179,254,242,177,68,23,139,165,101,32,52,246,25,212,240,38,237,147,60,156,190,36,3,56,163,125,228,107,228,6,235,44,250,90,92,77,158,36,217,168,161,77,26,49,125,99,103,191,115,41,120,16,231,243,69,108,169,115,81,127,195,48,164,132,75,173,147,62,148,220,3,189,186,165,200,86,60,18,172,193,207,129,196,167,69,181,134,232,130,109,48,76,133,202,38,184,207,153,39,149,26,4,242,77,59,193,254,102,222,99,68,91,147,245,252,14,111,57,224,121,244,233,148,97,66,37,162,181,44,60,144,184,181,187,204,143,33,120,225,243,226,97,190,168,25,134,240,146,145,251,166,104,183,243,126,93,104,93,84,55,148,49,84,30,71,204,203,236,226,179,113,247,64,213,92,207,126,35,130,231,86,232,149,34,79,127,8,155,120,228,29,247,142,10,151,52,57,180,40,56,93,99,171,253,160,143,201,101,183,204,59,240,23,208,83,198,151,231,231,147,28,110,4,156,102,57,157,18,249,18,50,20,130,56,53,156,41,45,170,41,117,136,179,222,121,239,18,168,166,237,2,237,98,107,148,236,81,60,2,33,181,218,46,71,254,197,234,84,204,80,27,160,118,123,153,37,55,238,240,199,98,227,116,197,126,232,21,255,98,226,206,152,34,211,121,85,69,183,195,225,202,232,188,79,208,206,156,187,96,21,189,252,76,203,227,241,70,211,61,52,217,12,33,243,41,50,152,77,47,82,19,140,197,235,100,59,65,70,115,52,246,95,80,145,224,57,224,221,213,78,145,49,47,117,102,248,205,92,84,18,215,150,191,135,145,62,36,193,200,52,133,187,34,96,149,139,1,97,248,25,51,64,247,58,93,111,15,225,212,223,114,61,92,11,95,154,153,245,208,78,148,39,150,34,40,110,50,154,11,54,4,145,21,134,166,233,0,193,39,105,2,102,29,28,168,238,231,117,248,142,40,50,56,142,240,142,165,151,16,85,30,155,98,225,239,177,187,143,215,228,29,118,98,85,69,167,21,45,116,143,40,42,152,1,87,158,139,169,81,137,18,54,65,178,145,44,82,225,241,84,208,111,202,139,17,95,107,130,255,148,105,65,106,172,230,171,55,197,239,133,168,4,152,247,235,19,138,175,168,216,216,171,23,160,83,71,40,126,234,228,1,76,145,9,132,135,166,202,190,232,233,218,105,184,138,161,252,19,33,132,61,159,183,129,62,37,37,194,79,104,59,218,204,215,82,166,4,190,36,224,43,97,59,71,51,188,214,175,54,18,10,15,153,110,203,218,59,225,113,185,123,75,111,206,104,24,163,254,170,85,40,105,9,229,41,218,37,240,211,103,89,253,97,34,77,188,114,220,132,215,129,26,109,149,186,128,119,108,19,20,122,172,175,10,20,169,9,104,195,150,51,8,159,140,86,232,226,177,7,196,200,167,207,106,126,27,140,222,219,198,149,46,0,13,93,255,121,205,23,206,245,185,247,15,231,173,156,59,156,16,48,118,254,93,148,203,237,189,158,180,101,52,62,155,57,8,175,171,215,67,69,104,60,72,232,226,185,20,206,65,59,42,125,90,124,100,202,134,141,239,191,110,203,164,223,50,232,219,4,222,205,22,70,62,180,75,143,174,228,44,62,245,202,39,117,215,33,145,80,106,131,177,244,66,46,89,167,198,251,80,38,72,190,90,118,85,34,158,83,17,61,132,124,53,24,63,24,90,249,68,131,245,198,183,117,13,157,137,70,189,73,23,75,77,13,25,88,126,217,87,108,92,8,133,154,15,158,112,113,94,186,162,177,9,232,181,162,55,24,38,161,79,176,4,233,11,158,170,242,240,168,77,25,3,223,158,186,182,26,129,84,106,135,108,205,79,254,175,227,1,238,248,79,5,72,169,217,128,158,1,139,110,157,12,39,55,95,3,2,113,179,81,229,38,144,253,35,77,155,97,157,9,47,133,35,238,97,246,176,156,164,3,236,181,42,140,173,1,46,164,218,168,228,127,219,160,224,59,249,247,7,155,98,77,199,215,146,55,151,221,185,163,241,26,122,137,164,190,205,207,4,237,134,165,74,238,223,226,15,248,242,139,107,210,187,234,4,145,23,231,180,229,53,254,166,201,220,10,14,58,33,230,72,92,230,207,170,109,188,229,137,28,147,22,41,192,213,40,215,216,127,14,228,9,13,85,247,106,247,1,155,206,136,4,23,190,148,170,106,194,155,170,96,227,85,168,247,195,20,113,172,17,34,38,123,79,167,110,206,207,53,66,173,162,178,166,84,120,160,160,218,186,227,34,87,100,212,219,28,84,255,59,138,26,28,227,102,205,94,75,152,55,216,163,46,225,96,152,57,32,57,159,27,251,178,201,231,5,139,31,163,136,69,71,125,19,213,46,252,84,88,215,163,249,153,181,25,227,174,4,105,93,98,251,60,164,4,222,26,165,85,83,87,45,206,132,134,6,108,89,96,76,139,144,143,144,116,59,72,48,184,248,230,195,135,167,29,166,42,207,49,87,221,159,42,168,96,157,181,125,152,96,130,72,48,100,105,145,96,98,200,116,7,131,166,69,99,117,55,141,40,125,106,249,33,118,191,121,159,138,79,27,90,132,13,52,0,61,44,246,212,77,127,107,26,124,234,104,26,14,238,68,79,124,247,99,81,60,135,27,62,83,231,104,214,53,69,104,188,95,120,30,105,222,150,218,223,80,221,209,86,113,125,226,123,36,1,136,94,206,253,124,34,218,2,77,208,172,39,238,148,151,111,237,3,135,99,41,22,142,129,39,56,105,255,31,62,12,171,5,206,94,114,13,174,185,89,199,225,131,239,187,92,132,102,86,138,156,36,55,112,65,191,209,70,60,75,110,59,216,180,148,36,118,238,139,97,222,17,236,209,68,163,76,177,206,58,196,113,2,166,47,131,113,199,180,134,23,174,24,119,20,124,144,29,221,9,90,224,188,131,232,13,244,94,200,129,51,27,11,124,24,154,5,91,171,150,238,212,117,175,71,155,110,168,3,236,162,196,193,74,101,6,238,157,132,151,181,88,122,26,84,194,170,253,198,124,142,133,185,66,4,105,5,152,87,209,178,134,243,242,197,214,209,103,53,218,128,193,9,83,231,55,111,29,235,133,45,107,115,71,203,15,1,69,200,105,216,1,163,183,18,222,54,6,56,48,104,228,237,119,166,90,242,184,97,160,218,194,255,151,131,120,180,104,202,167,157,179,147,77,161,34,65,201,171,236,177,175,0,92,134,255,40,217,133,61,187,44,165,109,184,127,37,189,61,62,60,232,182,210,78,123,118,207,185,156,158,77,117,67,26,37,222,174,87,192,241,152,180,170,218,35,86,86,91,87,98,97,192,129,140,194,233,36,79,152,203,136,73,223,63,26,117,190,88,188,60,42,9,45,54,223,198,207,196,237,26,244,60,233,67,132,223,113,147,253,16,126,10,119,41,159,99,237,109,167,23,248,146,7,166,214,75,0,234,202,90,254,26,71,82,240,116,216,96,236,109,46,104,255,134,115,253,155,36,36,129,188,183,140,151,14,153,244,139,244,252,214,160,8,249,226,35,58,185,116,255,126,128,120,235,190,225,169,185,175,255,64,176,56,247,249,7,18,39,92,249,142,98,47,116,247,126,6,66,208,245,253,217,123,160,123,49,99,18,90,47,9,80,207,212,123,18,61,155,193,44,242,205,146,4,96,210,222,194,220,47,172,241,165,29,155,45,163,105,121,174,115,233,211,216,182,136,24,90,234,77,214,70,94,160,35,59,16,39,71,24,186,43,251,99,53,11,47,60,159,24,144,250,41,114,90,26,97,209,154,96,63,178,67,28,211,107,179,90,253,127,165,163,26,175,163,165,60,47,25,151,210,245,25,91,122,31,176,184,179,128,161,75,71,166,119,40,19,58,101,115,237,145,211,239,250,235,224,4,46,64,94,118,213,191,21,42,27,169,75,217,193,182,121,215,57,216,234,245,160,135,78,21,125,113,51,250,39,177,32,227,61,57,182,118,16,212,181,130,153,240,62,148,127,188,127,160,37,3,231,33,68,181,179,95,116,179,14,247,145,214,104,222,71,140,17,161,171,218,105,81,195,25,20,202,235,110,70,90,42,47,194,109,74,85,60,77,65,92,205,106,16,171,147,0,227,16,251,48,224,101,8,46,29,94,50,36,213,78,254,13,7,254,227,219,219,18,45,213,145,136,25,210,42,32,47,62,61,139,31,140,17,210,249,37,178,80,160,59,139,26,250,178,179,208,129,81,82,239,54,209,224,20,156,174,251,26,130,136,28,68,243,28,42,28,17,51,90,6,39,125,11,249,223,165,193,243,148,129,17,210,146,186,89,202,253,59,205,5,52,237,17,181,104,92,54,142,214,177,178,59,214,195,73,72,186,175,17,1,0,220,146,69,144,120,89,133,146,152,239,230,141,237,0,78,250,117,54,179,45,38,167,90,149,136,233,115,8,227,210,205,255,208,177,5,45,173,12,189,122,109,122,136,191,40,176,51,234,201,4,208,42,147,44,56,120,17,43,69,93,97,143,103,130,166,129,101,7,40,85,92,157,218,212,230,114,139,2,233,64,93,127,49,140,232,168,194,0,74,215,40,158,61,12,247,57,151,103,148,42,210,155,139,211,87,19,0,208,70,224,199,34,241,199,70,169,161,135,61,105,233,172,62,114,0,96,15,45,231,45,55,172,39,55,41,225,133,190,138,162,53,142,120,95,183,32,192,36,208,155,102,233,86,61,53,30,206,83,199,125,72,101,207,29,247,104,10,148,18,184,234,165,202,151,116,193,119,185,112,23,192,20,152,65,174,8,254,94,56,95,112,30,175,131,75,160,36,26,226,61,55,97,225,40,77,212,181,0,239,155,198,208,128,240,202,248,190,135,42,46,22,94,11,61,30,199,55,16,98,142,1,63,173,36,147,172,74,152,45,239,201,204,46,115,27,81,227,120,112,155,184,99,79,214,130,147,122,64,139,9,147,208,82,76,15,123,98,5,74,218,198,40,175,162,34,226,243,95,227,126,94,45,242,141,118,9,49,66,13,62,135,201,56,200,96,255,212,204,11,3,243,18,242,108,74,227,62,173,115,180,224,226,248,249,141,136,245,6,158,110,65,8,248,189,225,236,226,84,45,8,72,133,12,176,12,140,172,135,245,88,80,88,0,185,175,79,207,75,134,219,100,194,29,255,125,135,114,8,126,63,172,235,145,65,229,120,37,197,36,66,254,60,122,61,197,192,6,79,197,152,198,219,179,231,14,155,211,69,154,175,209,49,59,91,6,25,138,1,144,199,28,148,67,149,19,37,147,101,173,173,206,196,37,179,47,184,185,251,43,182,74,221,246,66,82,220,131,113,87,197,241,66,226,95,156,93,186,196,250,229,244,248,189,22,207,27,43,104,3,210,183,207,145,95,190,74,251,145,107,71,36,138,225,83,79,207,145,78,210,137,175,90,23,239,94,181,98,41,136,109,211,114,150,87,255,49,149,169,69,132,65,211,140,205,214,29,22,127,210,12,110,19,72,139,152,200,229,246,220,110,222,227,189,5,36,90,254,53,6,237,122,57,142,108,23,90,140,146,218,237,207,124,148,18,43,1,231,98,177,83,35,133,156,57,105,201,222,84,80,168,12,176,33,62,83,81,72,91,127,176,136,94,105,255,254,90,145,155,68,132,45,203,4,81,16,2,218,66,189,227,170,31,12,196,122,121,143,12,99,122,129,195,234,210,79,14,55,209,162,72,6,182,66,57,203,144,165,124,104,28,239,250,145,78,30,73,201,115,103,29,184,58,64,70,85,21,63,220,48,82,120,182,147,193,160,57,159,29,228,110,185,119,116,208,106,226,116,121,81,43,222,244,81,208,45,54,252,92,150,203,97,118,228,145,19,251,135,68,118,217,134,205,225,179,191,233,152,12,91,197,183,100,112,245,155,90,49,164,31,226,11,161,97,101,12,52,104,87,67,185,88,236,186,244,207,7,33,67,86,181,69,233,84,8,132,228,204,119,32,165,140,91,72,140,72,59,85,160,243,119,182,101,202,174,103,225,103,157,66,245,6,239,65,118,228,82,220,95,37,111,101,138,161,191,68,163,207,254,132,5,33,34,56,45,15,145,79,100,40,250,236,235,36,175,245,20,209,154,13,198,149,155,0,80,11,84,80,172,105,217,187,232,7,132,48,231,150,103,105,189,165,83,77,153,247,75,244,46,186,175,219,208,150,199,180,28,58,132,148,105,13,207,113,32,133,101,252,13,167,207,239,200,38,246,25,126,101,156,150,20,134,155,28,193,203,237,91,8,31,34,172,248,160,57,105,219,239,42,133,226,116,81,43,132,235,167,30,68,43,231,221,164,52,182,249,179,61,153,161,159,137,151,189,73,236,246,163,36,98,19,85,248,126,173,105,179,75,212,179,6,192,100,128,153,211,199,108,66,203,86,207,169,95,199,34,119,154,244,10,13,220,112,98,175,183,40,113,55,27,57,116,86,1,170,179,54,173,252,94,178,69,116,19,143,251,130,194,112,136,117,223,38,229,127,85,195,14,156,30,223,71,155,223,129,124,152,171,136,110,120,95,180,53,100,168,25,3,216,42,54,85,46,69,119,107,155,145,251,64,53,185,193,15,13,139,6,167,11,60,47,89,97,48,152,126,89,204,146,71,95,57,111,150,78,240,251,102,115,113,11,147,15,192,253,231,25,248,245,109,134,153,56,58,101,46,144,2,253,31,2,83,198,61,64,121,63,76,80,67,29,12,66,28,147,254,92,69,68,35,212,156,221,161,237,249,146,56,121,137,145,156,246,183,247,139,124,62,163,212,103,229,186,93,174,69,23,160,26,196,181,43,175,176,60,110,211,55,131,146,61,179,46,79,154,194,63,7,77,202,244,150,202,18,92,217,129,241,239,222,111,51,135,13,231,255,23,171,205,2,165,228,225,46,247,213,245,181,190,140,154,241,182,186,251,24,83,159,137,53,64,138,170,164,60,147,27,90,82,193,36,201,173,182,188,108,188,229,45,193,211,18,253,200,185,25,95,180,93,30,219,69,195,239,222,97,161,110,214,36,114,96,168,76,77,164,53,131,226,197,100,0,42,106,159,84,214,55,249,124,216,170,102,155,118,134,77,181,65,115,14,167,123,89,46,212,228,181,29,222,148,86,228,253,74,236,231,197,148,188,137,167,27,127,12,253,186,84,67,146,211,91,131,122,218,230,239,254,175,168,1,213,249,121,7,221,136,146,201,36,166,47,73,221,190,128,205,126,206,89,121,78,233,57,64,136,20,67,198,178,249,191,17,131,33,149,197,130,104,170,130,142,237,246,170,147,192,156,248,187,123,25,225,139,220,171,61,24,24,114,110,77,3,160,244,82,56,94,113,16,27,118,228,217,56,29,253,10,75,145,97,193,150,89,210,52,60,146,17,127,187,216,5,195,108,15,251,39,157,158,86,49,193,199,155,106,6,73,80,247,203,61,88,81,56,93,158,179,40,245,81,68,136,69,32,237,101,122,112,165,100,55,9,127,59,26,9,41,16,102,92,246,179,125,108,231,225,63,120,88,135,69,195,239,197,51,245,72,72,59,15,231,42,3,184,123,64,176,64,2,15,246,220,67,193,252,8,159,56,20,44,137,45,172,109,183,204,159,101,6,17,221,228,44,160,69,242,153,202,128,203,12,4,126,92,35,50,234,50,118,36,235,41,31,25,142,113,24,62,9,95,20,19,50,125,158,204,53,186,86,53,189,102,153,228,219,22,2,99,14,143,147,221,199,23,113,107,196,224,225,104,121,99,34,19,112,121,28,191,160,245,10,17,84,184,88,225,151,167,54,240,195,72,254,120,18,22,155,131,146,29,227,234,30,101,250,135,69,125,243,191,220,108,252,27,73,15,229,136,53,207,18,173,204,19,205,199,182,167,225,33,249,143,99,91,17,55,149,227,252,128,238,114,212,169,242,145,36,176,68,219,87,139,157,11,63,61,59,211,206,153,189,127,223,109,58,97,39,141,146,29,253,92,94,80,25,18,106,154,118,230,19,134,225,160,83,60,150,40,14,114,137,33,215,197,110,48,190,240,56,91,138,248,129,37,247,39,83,175,2,103,194,229,110,102,216,12,120,6,3,226,163,55,78,249,252,111,226,91,6,137,148,130,47,48,247,229,23,243,182,71,150,137,124,20,124,66,139,32,193,148,161,185,236,79,174,99,200,112,53,55,117,29,34,237,204,153,30,100,212,1,178,63,101,108,21,60,226,164,189,178,191,164,14,130,253,211,82,162,209,199,23,248,243,208,248,249,158,141,215,199,86,0,246,74,146,131,115,160,41,65,31,203,224,248,194,77,33,67,47,171,200,140,46,76,21,188,172,177,183,243,246,224,185,32,56,122,180,233,201,25,233,15,85,45,133,25,16,136,35,136,145,142,15,86,80,133,48,119,224,178,65,40,193,213,90,108,89,160,56,151,217,217,57,103,175,63,242,81,89,154,80,29,72,39,62,162,124,64,207,184,236,170,24,70,121,44,61,235,14,3,108,68,201,57,178,69,188,58,91,211,235,251,154,69,34,123,86,213,66,253,253,216,176,67,99,197,91,185,250,198,244,215,134,106,130,27,155,101,61,23,181,173,83,247,184,185,24,221,87,94,129,150,24,83,250,180,99,14,23,157,95,133,189,98,219,252,120,118,181,213,41,131,138,220,245,32,75,155,209,55,31,197,21,188,175,14,108,96,144,219,70,87,169,105,80,215,39,54,253,164,135,220,113,179,11,26,86,90,17,173,82,168,51,234,219,159,197,190,211,12,96,163,96,156,21,216,237,81,71,8,238,177,222,65,238,18,207,224,198,6,78,77,58,229,128,113,49,80,53,64,60,188,235,183,243,253,19,186,159,48,179,25,11,199,176,100,249,48,94,85,170,164,215,111,157,248,47,235,115,199,148,241,90,5,156,158,194,36,48,2,128,54,251,107,121,73,162,149,9,148,65,58,167,164,203,170,52,197,196,44,120,167,22,204,41,135,101,200,149,248,38,73,57,71,205,69,158,255,72,185,219,30,199,49,162,53,242,190,45,142,206,11,94,30,40,120,221,10,171,209,31,64,30,69,102,138,222,180,169,4,28,97,34,15,174,50,15,217,31,255,141,56,24,233,173,156,216,252,142,255,94,59,43,223,147,253,34,44,189,10,93,55,252,67,27,40,123,12,243,5,33,140,234,16,240,115,171,26,131,179,201,114,216,135,196,14,204,11,226,91,159,139,238,182,65,152,10,212,173,146,189,31,16,197,251,214,140,176,101,41,217,127,19,65,118,112,116,119,159,28,52,102,175,254,92,132,73,106,70,124,121,229,34,136,208,230,102,14,165,73,4,170,233,83,76,138,148,54,152,21,227,68,40,188,180,162,79,72,48,228,26,205,64,66,33,171,221,163,170,114,114,184,172,219,201,168,200,24,77,52,12,80,226,95,105,205,101,189,221,3,5,202,38,226,148,208,76,126,116,245,120,125,186,56,187,96,82,46,133,211,10,66,86,187,156,137,23,160,98,171,226,232,11,114,200,18,250,211,87,122,21,93,163,90,104,194,160,53,194,74,207,94,195,91,24,76,184,136,174,136,22,245,12,54,167,76,106,249,48,251,40,188,97,95,223,30,22,142,194,231,189,143,57,151,51,105,150,197,223,211,167,34,90,118,91,128,229,236,240,185,96,234,208,26,179,111,122,244,232,80,12,38,10,75,30,38,189,236,165,19,26,106,197,252,71,235,185,204,73,177,213,143,142,148,0,198,150,67,125,250,112,233,80,164,49,60,6,157,40,93,68,163,97,177,11,138,69,11,80,35,151,37,226,112,83,104,68,199,208,112,120,18,122,5,174,225,120,249,246,187,239,139,207,193,43,156,214,226,0,98,218,49,189,224,164,249,146,98,223,125,50,17,156,249,81,199,227,5,93,233,167,93,238,114,241,192,104,44,145,2,60,79,168,0,112,62,78,120,31,150,105,225,33,243,194,10,247,239,80,186,67,248,147,112,190,206,149,49,185,35,4,129,193,254,128,152,100,164,105,79,44,168,54,203,1,129,230,43,92,174,4,56,200,148,20,82,211,212,136,193,83,214,240,81,138,39,11,132,114,55,99,194,4,143,40,233,177,238,255,46,166,183,5,115,190,182,171,253,136,6,248,32,219,26,252,55,109,189,224,176,219,6,131,136,170,148,101,102,58,242,121,97,120,125,146,126,232,251,70,200,193,191,199,169,112,172,43,218,147,205,17,215,99,9,141,194,206,149,104,71,115,45,250,190,121,28,115,88,81,131,250,172,238,160,98,146,119,165,113,166,10,172,34,174,43,44,119,114,32,110,169,188,210,22,181,71,3,8,218,196,202,103,105,234,72,209,168,202,3,206,120,58,52,91,169,202,207,73,67,52,223,246,40,85,129,186,17,147,193,231,46,110,139,178,74,210,186,252,20,42,212,66,107,31,239,184,60,105,247,138,212,29,59,35,147,239,109,123,57,144,11,149,66,71,134,57,20,223,47,197,51,83,184,140,102,217,213,245,43,232,173,139,129,135,141,23,147,64,170,6,101,154,52,47,242,34,140,3,101,199,41,95,122,146,104,251,210,114,60,120,85,93,235,23,132,185,200,46,225,58,185,30,23,139,234,67,231,176,36,70,216,129,111,57,23,74,254,117,89,199,41,209,178,61,214,211,184,105,167,86,249,49,90,42,123,168,58,104,222,200,67,41,108,0,17,167,116,177,110,201,116,233,182,36,97,100,6,194,14,109,98,123,229,192,135,60,139,212,178,229,24,178,75,57,129,64,124,38,73,23,182,0,233,69,40,62,242,69,133,151,96,88,46,115,166,144,227,171,12,67,150,150,224,205,128,11,68,98,7,65,199,98,217,18,163,103,246,75,237,111,191,192,188,237,204,240,118,109,98,193,54,170,132,185,37,96,110,213,152,18,190,35,50,82,137,93,149,215,225,221,42,90,5,238,158,171,51,61,216,167,102,11,175,66,32,95,200,136,58,38,185,31,31,7,154,137,77,199,135,129,68,11,138,218,56,51,63,138,232,178,118,35,168,128,222,75,254,4,133,240,20,138,225,42,242,179,147,238,252,236,171,207,216,158,161,187,121,28,211,191,97,168,90,83,211,109,149,65,124,180,9,172,11,247,233,144,178,35,236,201,59,110,14,121,70,14,224,61,254,78,212,28,174,65,117,240,197,140,63,81,231,180,236,142,119,35,45,55,146,227,92,243,89,103,227,113,113,7,241,196,218,216,222,133,210,176,201,227,29,129,190,164,242,224,9,230,82,122,179,114,75,246,39,15,229,149,39,223,54,20,209,236,251,52,201,186,78,73,37,151,126,3,228,78,186,96,42,131,8,164,251,31,66,192,181,12,97,55,186,77,32,219,199,151,33,3,42,85,29,142,29,6,107,115,68,114,214,114,140,199,143,20,245,129,9,78,83,246,169,65,41,122,99,69,204,115,173,8,254,95,66,163,162,48,175,244,113,209,100,147,112,188,220,233,113,5,212,201,138,91,38,191,72,7,99,178,116,234,92,48,244,0,211,154,27,247,206,232,89,85,99,233,132,72,85,200,139,238,153,179,24,123,99,134,246,142,188,239,9,157,112,162,234,185,118,245,59,130,224,204,31,163,171,38,159,221,225,99,216,177,58,35,104,109,10,125,89,23,53,56,37,68,165,189,60,83,249,63,161,240,70,141,1,210,143,125,157,56,227,11,24,55,38,168,16,119,213,155,223,143,131,175,37,234,125,238,16,194,101,201,158,4,110,18,210,221,84,87,14,13,169,250,241,240,1,12,205,98,246,198,75,250,239,249,104,97,127,57,19,15,104,126,28,59,196,119,32,32,82,17,212,81,175,226,118,175,241,105,177,135,71,82,187,16,240,159,71,37,41,230,115,64,156,184,169,24,234,219,0,246,117,253,167,73,143,69,3,130,245,116,43,177,166,154,119,212,153,47,46,26,192,155,252,200,241,110,201,195,252,231,181,147,45,221,62,85,89,150,72,79,230,174,245,52,49,209,202,184,143,160,9,190,63,249,33,193,163,53,123,237,31,46,225,42,225,49,158,14,120,71,133,247,37,52,27,195,168,0,173,254,175,48,203,127,136,142,20,140,58,102,224,52,13,72,195,143,146,84,91,160,228,92,126,63,39,81,150,207,232,13,28,22,22,113,169,45,140,23,5,46,155,127,197,116,25,54,226,104,89,169,95,100,83,211,41,119,115,107,60,190,170,12,213,173,189,220,228,10,211,105,116,245,166,208,229,181,165,201,68,170,57,36,97,78,110,76,75,65,230,77,138,17,146,196,148,196,16,237,121,105,24,158,75,121,236,185,205,129,31,100,68,181,179,248,183,65,29,74,96,126,223,176,27,19,62,148,147,12,48,70,173,22,7,123,162,216,137,16,123,171,81,196,100,84,138,92,119,3,209,28,49,46,184,35,78,201,26,213,233,176,139,204,161,161,100,134,151,46,27,220,236,243,154,104,171,179,29,24,244,219,213,4,109,217,17,167,110,219,11,225,255,47,80,164,122,91,85,104,133,179,78,39,122,132,12,176,53,220,175,184,93,42,5,93,129,217,176,225,1,179,77,53,121,239,203,231,143,218,94,107,129,31,11,195,254,148,78,105,60,149,153,223,20,120,153,7,211,141,71,154,236,170,254,85,202,104,196,108,18,145,215,252,129,244,163,252,137,151,112,146,157,1,59,187,240,13,15,2,216,118,65,35,126,38,27,221,174,235,245,160,106,120,196,95,105,214,48,54,136,226,74,65,88,37,3,224,245,60,140,2,150,249,134,212,251,59,123,169,14,76,79,118,67,227,62,202,182,40,50,114,7,24,44,54,254,33,251,230,193,198,191,167,178,228,71,214,100,187,93,9,99,58,230,102,178,170,160,39,178,130,14,57,7,70,171,249,174,14,35,35,120,237,233,152,182,162,97,118,134,142,150,24,7,159,154,144,20,178,175,155,125,114,58,253,140,118,189,3,236,201,17,137,170,158,6,138,214,209,52,137,203,102,157,11,99,113,92,97,55,117,153,111,20,219,251,13,105,77,46,143,89,53,195,147,116,53,124,195,182,95,154,49,226,94,206,124,56,128,210,109,131,196,167,229,110,5,138,241,184,84,170,48,209,20,77,49,194,144,208,224,23,8,82,52,152,83,235,136,168,48,59,7,125,42,229,139,89,170,227,83,9,67,233,174,188,101,17,74,229,208,35,149,23,105,183,73,116,1,80,193,46,164,25,242,129,1,17,88,87,87,94,55,96,126,151,60,35,202,219,9,3,222,161,131,34,149,198,202,198,131,167,91,75,106,85,22,230,193,8,201,156,81,226,164,111,44,147,161,162,209,240,123,26,148,30,161,104,16,29,236,170,204,149,74,126,34,109,24,139,125,1,32,228,137,89,30,201,147,146,189,177,123,185,72,228,107,91,49,121,163,27,243,72,155,29,183,58,67,212,196,210,201,58,31,102,67,158,141,70,175,80,213,3,99,198,124,34,110,94,209,77,20,85,45,162,82,18,61,189,203,199,56,131,228,230,7,53,226,247,217,35,66,115,37,68,130,210,200,156,186,44,33,11,229,31,84,159,92,194,52,14,158,187,179,106,80,194,179,80,226,202,110,147,204,167,44,63,158,49,55,80,115,164,46,156,244,58,137,134,55,253,220,75,9,103,136,249,242,3,215,220,53,123,17,75,112,40,131,105,76,0,16,17,245,242,195,47,165,106,200,206,26,130,189,65,203,2,99,181,5,143,191,100,128,52,249,154,169,127,159,85,163,175,105,201,79,170,124,33,172,15,229,166,146,194,104,108,129,91,132,33,195,224,4,116,61,113,89,52,79,251,121,2,32,71,98,121,115,214,245,87,160,16,97,250,177,149,55,39,223,212,203,76,231,248,127,176,129,187,75,9,209,101,237,148,65,111,200,193,164,44,66,237,159,220,85,84,91,89,208,128,237,151,180,31,151,237,151,16,114,221,155,43,42,4,83,34,238,79,149,66,231,157,222,132,11,145,104,170,56,236,84,248,183,36,85,4,10,143,170,141,177,87,7,163,114,225,72,248,238,122,146,203,203,157,4,155,198,245,193,60,218,180,175,34,89,80,195,35,71,85,234,238,86,77,49,244,128,157,230,211,30,114,38,88,35,242,190,254,27,132,194,18,236,121,228,133,95,97,44,236,154,28,64,235,14,62,141,6,104,2,239,196,0,239,190,200,189,55,225,88,118,166,28,3,155,39,73,135,166,250,86,28,103,243,78,21,135,177,206,135,183,141,13,148,181,253,155,176,98,53,113,191,110,156,23,111,210,0,12,145,6,255,146,80,247,0,74,171,33,213,96,90,118,193,89,208,79,47,247,61,246,11,199,235,65,231,27,63,41,110,254,129,80,132,0,167,84,59,171,175,164,131,185,207,179,36,207,187,236,180,205,188,150,112,119,170,82,180,155,78,6,33,163,196,74,97,85,204,95,48,248,81,22,74,219,228,3,163,28,111,155,134,69,37,9,187,242,25,75,186,8,17,151,196,130,59,118,14,82,207,194,129,82,65,199,147,72,96,117,243,22,125,145,219,206,184,153,41,144,219,98,96,155,34,94,181,44,163,237,168,33,89,151,218,192,247,57,198,126,236,197,141,63,109,159,157,29,83,185,46,181,8,73,42,95,252,161,116,224,219,172,169,119,219,52,46,170,69,178,172,93,174,0,45,81,139,114,181,102,240,100,159,66,137,156,200,175,244,173,51,117,206,244,24,77,6,23,82,12,37,118,160,225,85,183,69,79,100,126,129,93,155,18,95,145,39,32,118,241,90,236,152,14,20,126,31,234,84,34,120,172,90,243,50,162,34,238,83,91,24,255,99,225,240,27,114,166,100,243,207,98,170,111,107,224,19,79,177,203,231,135,126,205,13,231,108,153,215,16,143,6,18,244,71,18,188,143,224,169,189,54,129,185,202,121,10,142,246,219,251,81,92,184,115,207,55,223,23,9,172,6,80,2,236,96,4,51,62,54,135,46,10,0,229,235,188,235,218,127,115,177,136,157,40,2,71,146,32,245,200,137,190,179,220,117,208,242,197,14,183,79,124,35,171,203,89,139,208,30,50,32,249,148,242,236,98,48,88,255,143,25,1,235,159,210,127,229,219,6,20,19,41,23,220,116,32,214,217,7,197,244,101,247,93,18,117,151,140,84,68,104,42,232,36,226,57,55,57,181,128,52,6,203,130,54,199,103,197,158,184,138,127,61,223,65,111,57,25,181,72,139,155,65,139,48,15,128,95,194,241,163,12,246,39,191,53,212,114,194,90,65,109,13,121,48,171,160,68,35,192,251,149,193,182,207,178,158,107,32,192,59,214,166,145,205,76,194,17,236,248,105,195,184,201,91,214,106,71,163,206,253,189,15,166,160,158,55,182,108,213,82,244,47,221,194,227,48,139,93,104,165,186,46,214,47,63,142,36,158,192,116,253,133,77,50,45,85,208,33,203,120,156,6,55,217,53,210,131,30,194,170,65,32,80,32,81,218,104,125,77,236,131,42,23,51,41,208,230,40,175,127,201,126,254,209,89,221,187,181,101,185,235,139,217,248,49,187,232,192,124,28,52,88,70,236,155,38,60,43,157,178,180,45,203,113,4,9,67,86,60,136,52,5,61,152,126,254,205,152,68,61,64,58,226,75,218,19,204,177,16,138,148,243,180,234,110,6,134,194,139,167,50,151,95,62,160,137,209,208,255,81,199,177,240,114,1,163,160,235,235,172,203,57,245,240,94,121,56,11,132,16,23,152,180,38,90,26,107,103,77,223,70,133,160,220,55,161,159,238,135,127,195,39,208,86,53,94,195,241,255,207,90,238,9,252,64,51,154,107,238,114,42,193,58,242,19,108,172,209,86,71,42,197,80,100,152,114,254,57,174,37,64,50,36,160,251,173,106,84,18,16,170,209,101,166,151,240,142,96,134,97,50,207,93,244,231,22,49,72,181,188,188,85,53,41,160,158,84,157,23,30,169,226,115,33,73,115,107,143,0,226,138,147,191,74,190,144,231,29,158,45,154,232,182,228,53,105,112,118,75,176,179,123,111,233,14,139,90,157,138,223,14,191,88,106,91,191,149,119,119,125,12,238,211,244,188,43,214,146,153,165,147,172,221,81,131,160,19,124,234,236,188,144,176,73,96,127,208,169,247,17,186,160,163,61,186,59,233,72,217,58,90,43,43,23,250,105,188,236,66,19,98,125,250,90,130,162,167,174,46,218,37,184,26,92,237,34,0,26,104,74,167,221,23,105,113,9,187,125,231,185,93,92,121,93,23,185,54,19,90,235,249,3,121,58,43,88,53,140,51,45,206,210,228,223,67,147,216,82,11,167,178,164,218,132,152,116,134,84,112,15,165,106,15,116,46,222,118,186,76,133,157,255,99,27,35,96,230,14,223,36,164,244,30,234,71,169,225,124,239,103,239,185,44,71,223,241,177,16,211,173,64,220,127,244,65,244,249,195,214,90,121,43,248,177,241,128,96,74,224,104,16,53,79,225,14,219,175,78,129,103,35,184,131,156,66,49,75,196,237,145,109,124,157,74,188,157,84,32,153,170,210,235,165,6,155,60,118,114,50,169,40,37,1,220,122,220,107,20,39,19,238,244,128,227,140,103,0,179,250,11,140,38,165,57,63,111,193,84,165,175,223,21,24,232,153,190,211,114,99,96,103,146,32,24,107,66,117,93,27,243,49,114,246,219,30,34,20,17,69,183,243,131,101,22,123,146,89,58,14,130,29,141,36,211,54,162,164,189,208,207,2,157,64,29,178,133,166,206,71,226,123,104,195,207,127,14,140,247,187,212,124,199,222,83,46,134,206,111,75,190,63,73,82,47,139,200,197,11,130,44,168,239,104,124,162,31,115,106,15,77,72,8,188,215,102,185,145,177,146,105,215,243,128,236,120,202,35,200,18,3,56,41,51,228,233,136,75,253,209,15,226,133,173,67,184,30,89,158,18,91,156,153,18,111,152,178,1,79,85,158,151,216,76,58,134,155,146,49,89,17,51,188,208,128,156,11,43,131,131,106,12,149,63,166,121,16,63,219,137,51,65,222,5,172,189,253,110,113,53,167,226,44,245,31,50,38,174,100,68,22,13,112,212,36,155,239,195,60,53,18,123,223,198,86,22,195,153,183,238,240,84,186,32,5,221,42,82,204,140,146,40,142,221,64,66,150,70,55,47,30,39,14,91,230,39,190,250,204,44,92,192,48,150,46,192,2,42,75,126,145,237,31,191,38,153,131,36,227,179,79,231,201,9,204,104,33,64,247,81,36,153,134,244,72,253,218,167,247,131,248,178,75,238,207,226,79,244,209,92,176,76,70,26,233,159,72,80,240,245,86,236,211,60,129,147,52,202,224,10,121,136,140,72,97,73,10,133,96,120,170,207,50,34,150,192,32,223,232,196,218,17,88,13,218,31,177,119,20,156,206,58,133,152,213,248,174,186,249,107,70,175,113,37,10,115,145,51,107,100,20,219,82,204,77,140,219,219,169,215,58,48,94,235,31,79,145,66,12,48,214,3,229,197,44,184,188,88,27,187,162,100,106,211,186,207,12,7,55,129,174,102,0,79,203,232,178,166,41,96,67,20,205,236,10,17,185,214,114,166,94,180,205,186,114,55,253,184,106,217,46,50,15,196,129,214,56,81,178,117,165,228,136,107,226,194,252,239,232,52,189,121,119,33,227,225,214,234,74,40,173,225,105,36,9,32,65,235,127,209,218,119,230,246,90,85,92,208,117,25,145,241,125,158,150,196,130,194,200,251,49,170,85,124,87,213,239,96,184,96,197,63,244,187,217,215,49,3,224,114,164,10,22,251,65,108,238,13,29,254,18,139,129,219,58,169,151,73,96,64,221,26,16,12,14,12,78,9,203,11,80,73,221,118,103,173,1,169,193,215,109,126,166,137,12,12,135,17,81,209,32,12,131,60,0,153,66,201,121,182,155,39,109,173,1,186,45,253,219,88,63,179,91,22,106,108,66,107,17,105,97,59,6,133,136,82,129,125,190,184,234,131,23,198,146,94,243,204,25,190,50,160,81,176,220,38,215,41,120,112,38,74,163,171,24,106,116,214,231,194,77,99,71,195,47,141,134,111,103,119,122,241,34,5,170,123,150,232,85,63,156,112,76,202,78,176,136,79,161,164,245,223,119,235,27,8,99,121,57,0,225,90,143,129,173,209,102,133,158,64,233,181,113,212,237,35,132,15,88,36,85,226,152,217,11,16,251,213,25,7,85,125,48,155,221,141,133,205,66,237,6,5,241,72,247,133,199,177,78,236,71,27,110,205,207,241,40,22,141,156,101,179,172,227,30,248,161,147,84,177,176,26,32,103,36,110,30,67,137,223,121,255,110,247,94,76,30,149,83,111,96,72,165,93,200,58,207,176,213,13,29,75,187,45,112,179,43,234,213,242,216,43,249,33,207,40,167,96,46,219,167,44,111,57,183,96,243,201,5,215,73,106,130,134,7,142,153,17,97,126,88,35,57,154,246,15,16,48,120,187,131,106,242,11,250,99,54,230,135,88,172,62,208,30,127,145,236,44,247,246,202,229,174,206,139,144,172,167,141,73,106,163,33,202,57,80,76,67,219,18,99,153,119,22,223,8,132,90,173,119,88,241,34,158,228,149,129,248,73,110,153,176,170,26,33,117,151,227,204,107,181,26,21,245,164,236,219,77,199,199,35,205,68,49,148,238,100,242,214,99,155,100,23,181,56,99,13,119,225,107,153,143,182,246,225,208,95,196,75,114,87,98,134,84,115,210,91,16,159,38,83,255,6,141,147,176,178,28,7,98,154,157,117,22,186,222,203,229,195,97,78,111,21,1,209,7,216,220,49,206,103,113,12,92,248,125,213,205,208,125,25,23,255,131,122,18,244,102,110,19,246,57,97,29,160,122,12,249,191,178,249,218,202,196,118,95,227,2,202,72,253,166,224,126,142,247,255,235,17,182,40,239,72,49,69,198,190,146,45,197,143,72,232,60,106,114,24,207,64,199,21,148,63,154,255,94,65,161,221,130,35,137,115,115,180,84,241,144,61,126,156,106,22,242,150,187,185,206,193,114,109,233,188,162,195,80,84,37,148,76,38,233,82,107,55,196,65,244,142,66,169,247,79,119,3,176,143,31,254,163,250,36,254,95,244,199,37,243,80,12,199,218,35,41,133,113,33,14,19,65,68,109,255,12,46,255,36,190,184,245,158,28,243,54,230,255,252,10,28,140,185,137,52,36,177,174,246,253,228,33,46,4,171,48,142,104,247,44,43,68,29,108,218,170,183,172,241,193,73,207,219,37,138,1,150,130,219,251,45,165,77,163,56,41,211,48,28,136,245,232,57,137,129,92,21,128,45,154,238,208,32,231,214,120,74,179,72,201,37,186,206,84,50,7,123,49,12,239,253,65,164,149,178,102,109,53,34,240,96,200,137,6,135,145,49,172,151,73,182,67,200,127,30,211,36,85,185,165,56,97,54,221,209,90,70,22,143,152,129,15,204,59,5,143,171,180,132,244,145,20,44,11,142,181,72,223,151,147,26,241,164,157,222,7,97,79,43,35,103,66,163,25,155,118,174,109,181,98,111,56,136,55,63,81,51,89,250,61,148,153,110,132,172,218,99,18,104,242,83,175,53,197,209,126,182,44,53,73,229,104,21,252,214,227,27,176,170,31,200,156,251,40,253,90,104,145,10,1,175,235,135,77,56,137,11,51,99,233,59,250,122,62,196,2,245,142,86,59,143,192,123,130,214,245,182,157,134,228,82,199,243,29,167,83,105,75,4,236,116,174,50,18,89,242,200,87,109,23,221,184,42,3,82,80,103,135,218,190,7,129,98,180,64,149,196,181,217,136,28,58,56,53,14,16,248,30,82,197,85,149,53,2,112,81,243,53,131,126,174,187,3,237,209,3,20,9,246,22,3,194,201,118,169,89,116,66,199,66,16,175,193,47,238,65,137,126,87,148,144,167,191,216,137,23,120,162,24,80,68,168,161,148,167,6,137,56,1,160,59,75,181,56,92,175,90,233,7,212,173,52,242,167,91,64,194,196,220,18,71,186,221,224,84,47,76,156,55,190,180,102,18,21,27,55,125,249,219,154,48,54,210,58,72,73,154,78,48,73,105,233,200,178,230,208,130,172,18,160,79,130,20,166,83,203,232,203,108,136,211,228,152,192,103,222,8,46,245,50,29,25,234,254,228,47,202,93,242,41,33,139,115,212,186,141,90,222,177,4};

// The scrambling tile of 128x128 pixels.
// Each pixel contains an optimized 8d key used to scramble the sequence.
// The keys are optimized for 8spp in 8d.
static const int scramblingTile[128*128*8] = {33,142,7,39,181,232,53,172,7,185,47,193,65,81,131,87,0,100,62,236,34,185,70,28,180,54,28,106,188,228,73,211,137,45,153,3,134,255,207,241,38,88,9,149,164,88,226,56,169,88,194,248,245,174,154,88,210,233,22,231,190,96,47,198,166,29,93,41,215,155,141,167,54,41,8,73,4,226,62,21,131,197,100,133,177,51,106,201,148,226,24,248,50,59,161,34,201,151,114,107,161,46,65,69,252,0,149,28,180,124,62,190,119,20,107,194,46,117,170,32,59,6,26,87,83,105,48,67,154,15,36,197,29,138,135,30,37,131,224,172,199,84,102,185,57,69,212,67,169,52,148,92,199,37,127,49,5,189,128,212,207,217,22,203,176,236,18,216,137,198,129,142,171,127,167,118,99,247,130,15,215,252,97,179,32,213,179,155,67,105,103,71,81,143,5,135,73,73,149,224,33,81,14,217,70,139,69,209,240,113,116,59,40,147,255,39,225,34,60,174,41,58,61,205,244,249,157,221,241,239,22,162,245,92,133,247,1,180,219,40,94,147,38,145,210,229,97,191,82,196,164,238,89,241,104,118,207,175,155,84,5,21,18,175,145,65,148,41,31,64,81,182,18,195,214,188,107,187,124,101,95,241,130,69,235,14,5,211,143,37,230,208,12,21,66,144,171,88,102,7,123,83,91,90,176,8,151,249,51,227,28,228,6,203,45,255,226,177,165,163,240,255,136,150,237,149,180,69,184,167,175,64,218,221,37,220,252,84,84,19,132,206,67,163,209,71,35,87,105,235,71,0,223,148,14,170,207,150,109,199,94,233,67,78,17,129,210,175,67,250,22,58,252,205,190,76,77,61,91,233,232,229,64,78,210,162,223,197,36,187,54,119,38,188,158,99,111,169,92,23,155,63,111,31,161,195,168,103,11,174,83,212,26,49,245,154,247,177,119,254,63,42,189,203,69,46,246,16,3,162,133,0,23,74,28,112,121,97,224,26,131,116,175,43,160,227,22,197,87,250,130,159,222,152,27,134,233,168,251,77,35,48,45,108,217,96,253,9,87,215,117,6,223,229,151,233,189,250,64,20,245,157,236,228,200,251,221,48,195,181,168,11,86,227,149,129,73,239,182,103,73,81,222,188,98,3,215,184,150,43,226,205,136,5,22,203,103,106,206,21,208,51,245,161,237,243,244,126,15,168,132,106,6,109,238,98,91,146,205,189,138,92,187,115,94,100,222,142,135,218,176,188,109,219,208,6,240,151,221,236,170,98,116,156,95,253,177,128,251,56,110,63,111,80,113,154,145,0,24,159,166,182,204,71,202,75,56,61,49,227,238,40,35,132,85,157,243,99,92,96,126,123,35,93,243,231,192,46,2,58,84,75,193,43,219,138,27,254,110,180,95,52,38,51,110,230,26,95,192,239,43,192,99,28,48,107,120,48,144,145,17,157,106,198,185,1,181,36,52,4,80,100,12,83,13,67,213,39,204,186,58,127,187,100,198,22,157,211,40,161,172,54,174,201,68,251,115,97,8,5,131,228,101,34,140,245,252,45,209,216,121,189,193,3,77,25,133,157,114,194,128,45,2,42,230,143,76,27,201,223,206,7,76,21,200,194,56,206,107,100,59,94,3,154,42,249,176,69,151,216,30,86,186,245,132,175,144,247,64,173,169,134,101,176,129,200,247,250,62,150,185,83,252,112,71,156,216,229,169,142,36,86,129,27,201,173,253,194,63,150,21,197,181,164,2,221,48,1,102,224,228,81,216,80,156,98,96,48,240,125,82,238,157,64,39,75,226,237,165,118,135,127,174,116,92,83,49,189,67,182,91,8,184,91,21,202,230,228,157,69,153,102,224,10,90,63,224,221,162,128,43,180,27,209,253,27,191,250,12,195,91,206,102,70,205,132,186,38,28,145,37,220,1,167,119,11,175,39,87,32,203,184,0,242,82,159,62,163,86,181,24,122,232,41,200,95,78,52,111,253,218,225,43,73,224,215,174,193,187,29,210,19,154,197,214,142,249,97,7,114,209,98,100,232,224,23,1,68,157,105,28,21,68,147,165,36,125,197,206,248,173,112,236,199,242,183,144,122,74,108,152,59,47,222,11,226,86,134,147,129,119,93,98,115,196,239,143,19,51,55,190,164,229,9,150,192,39,202,24,22,79,252,227,231,139,185,230,206,168,192,90,55,124,35,184,119,199,126,183,102,18,145,115,229,68,21,122,249,175,73,216,180,2,108,104,145,63,206,230,32,18,70,78,139,142,200,39,158,211,214,121,116,17,149,225,97,71,188,91,200,217,15,254,148,102,172,51,222,80,22,190,195,122,139,164,248,254,236,220,184,253,152,220,225,19,159,86,243,84,37,199,21,190,101,161,238,59,58,230,16,65,1,183,50,161,234,178,227,165,42,241,73,177,63,216,164,237,232,237,85,138,36,13,183,167,17,80,26,204,33,217,111,230,134,72,7,158,59,120,170,217,241,214,174,217,207,1,24,27,22,80,94,0,117,75,118,253,34,216,226,225,33,223,171,161,208,204,86,213,183,45,197,207,111,123,229,28,8,31,41,69,58,41,40,134,254,58,28,91,39,81,84,72,1,34,154,76,141,194,45,66,179,192,87,94,116,47,175,32,17,143,65,63,108,72,227,225,84,58,40,33,77,171,217,54,141,227,29,251,146,154,17,161,245,122,60,91,234,129,190,59,152,246,112,206,96,89,160,254,99,137,173,126,204,44,154,155,80,255,236,44,250,243,216,57,13,19,240,66,239,117,103,125,109,82,34,159,72,215,242,143,89,211,63,132,153,205,49,165,208,211,238,104,181,151,196,16,170,67,194,230,12,231,215,76,235,225,4,234,223,222,186,220,155,243,73,68,206,130,67,200,248,148,237,28,123,214,43,168,52,136,170,113,229,121,162,31,94,231,69,185,200,105,214,181,6,243,240,73,115,16,189,18,220,30,185,91,232,65,198,11,230,220,236,110,7,246,167,238,48,180,101,178,241,45,28,192,240,204,142,189,109,82,237,158,44,118,151,112,6,115,163,49,247,95,183,108,57,111,21,73,202,74,81,7,207,253,132,120,236,251,195,187,10,252,58,108,156,231,252,222,186,6,39,234,37,216,7,82,249,234,24,180,36,11,122,134,37,138,246,28,252,146,209,51,159,94,89,58,141,128,117,95,219,178,178,213,71,251,223,89,40,218,96,229,212,165,85,81,239,30,230,85,203,233,194,101,211,160,135,45,89,193,210,128,22,17,157,3,104,210,35,104,33,211,69,153,71,212,183,61,150,50,142,234,149,238,55,23,183,106,177,218,130,172,142,203,236,112,203,72,57,158,186,31,202,251,145,171,125,220,171,228,86,153,168,103,111,219,242,27,15,194,125,81,1,143,106,22,196,101,72,139,132,40,24,42,86,192,223,35,15,157,193,102,199,81,154,233,18,187,29,246,40,51,216,67,113,79,198,184,53,168,255,16,28,201,120,247,58,181,14,77,38,60,207,60,37,71,203,206,146,99,88,45,137,183,51,188,112,2,252,196,195,254,64,229,190,189,189,111,142,121,125,248,148,248,180,196,225,13,89,86,33,137,16,157,24,133,94,62,20,25,37,32,162,94,231,130,145,156,252,182,154,50,132,235,107,213,30,121,94,254,115,220,233,58,15,23,165,227,219,12,225,192,36,101,217,255,58,13,110,133,48,20,208,151,63,20,78,80,165,28,151,165,235,203,144,65,236,105,134,244,90,24,111,45,153,117,30,32,237,132,247,55,192,234,79,6,128,25,40,154,30,174,211,57,21,50,46,240,69,155,94,227,3,187,158,73,204,240,71,232,167,46,139,125,122,90,59,96,101,194,64,7,195,187,119,112,239,255,125,162,133,78,31,115,122,124,139,176,175,208,242,199,144,29,101,0,61,155,243,138,232,54,63,23,197,159,200,112,130,3,67,13,17,9,214,204,134,122,196,93,220,32,105,122,237,204,89,205,149,77,244,33,91,153,68,146,229,132,79,181,13,134,250,13,25,239,184,162,226,188,168,54,15,13,162,19,246,151,12,24,254,41,190,104,175,199,125,72,28,134,142,102,191,221,76,32,26,188,97,58,245,18,89,88,252,117,99,234,26,123,162,22,152,18,187,164,161,85,147,43,14,223,32,122,81,79,109,221,42,165,164,157,178,57,243,120,0,91,163,246,232,63,63,192,168,41,184,103,205,135,246,235,47,75,188,255,199,250,87,156,40,8,73,225,105,219,34,153,107,224,66,214,220,112,88,53,27,164,177,254,205,197,220,109,194,243,103,125,218,144,167,196,194,44,138,166,2,128,227,148,152,186,37,73,18,239,144,120,253,82,27,250,175,88,2,38,157,6,187,143,146,15,158,108,42,45,8,210,177,157,152,154,102,106,194,216,94,118,12,157,163,88,133,227,232,176,218,50,73,50,16,205,237,184,114,81,250,33,176,88,117,102,102,144,81,148,205,113,98,119,119,121,201,23,201,105,242,84,38,50,104,160,216,245,174,246,73,27,0,40,48,239,72,79,53,0,145,161,101,1,129,47,208,51,15,178,223,115,241,21,243,178,236,152,36,94,62,17,160,35,164,1,179,55,88,126,220,45,147,228,204,97,68,118,90,161,178,216,69,225,10,5,33,227,197,79,223,199,162,74,29,27,19,169,141,81,33,224,241,27,197,187,175,35,15,59,64,135,248,93,201,99,225,205,221,194,213,214,220,3,203,211,8,88,184,218,169,132,72,36,55,34,80,151,90,160,150,228,29,203,22,188,85,80,141,90,173,26,99,32,202,115,247,29,255,77,156,62,210,47,159,41,92,100,191,88,49,240,49,66,211,99,74,168,118,61,56,8,38,33,223,74,227,64,59,36,170,209,97,6,153,143,192,82,51,189,231,195,116,121,19,199,163,144,184,64,3,190,62,97,156,158,240,74,67,158,112,93,242,239,65,246,51,192,47,161,12,197,140,238,19,48,186,224,110,8,157,71,217,111,110,58,191,23,224,161,177,32,46,206,236,55,225,191,229,89,229,204,42,169,151,160,222,35,110,5,56,250,127,172,189,201,219,153,98,67,237,160,158,250,188,129,235,156,146,155,29,168,118,35,157,60,202,51,184,240,36,59,200,178,21,249,196,233,232,47,233,169,248,118,116,40,76,12,211,235,249,199,172,207,48,130,130,75,145,126,154,43,4,118,246,57,220,175,130,190,71,188,193,228,199,72,187,66,104,211,241,246,147,135,9,166,93,195,87,78,214,179,40,185,250,234,193,60,142,119,20,178,168,18,26,96,243,123,139,230,244,244,196,208,203,3,238,78,11,110,51,197,236,15,162,203,102,78,69,9,248,193,123,130,191,42,212,20,166,125,185,58,40,52,176,18,216,165,228,94,91,48,151,214,211,201,239,52,221,203,133,3,151,55,229,93,49,243,16,71,130,87,22,43,206,157,227,137,139,173,242,77,19,249,214,232,102,180,175,198,76,230,84,150,204,74,3,103,115,57,76,185,216,133,252,184,139,108,80,64,6,254,14,63,252,104,183,3,188,232,151,41,97,82,171,147,195,83,29,34,84,101,159,135,161,76,247,70,110,175,42,154,62,183,115,163,119,194,141,106,137,230,225,45,3,109,37,241,32,170,78,13,134,195,174,36,206,15,26,107,146,9,218,97,162,134,173,191,109,78,35,31,216,253,57,139,144,201,121,225,4,106,168,246,115,252,61,249,39,234,183,79,206,245,247,250,174,37,124,41,229,176,13,141,226,163,255,125,160,214,116,74,182,105,67,86,31,173,106,185,245,7,177,209,186,160,80,122,37,26,243,13,136,228,136,214,76,118,11,110,155,29,129,196,15,97,224,143,156,123,156,144,174,47,255,157,30,116,3,73,229,216,177,156,125,151,249,124,215,129,135,138,190,154,65,62,96,60,139,109,69,236,3,203,87,226,142,79,229,211,154,146,180,116,247,131,197,40,222,64,82,40,113,84,43,61,153,4,75,174,236,191,247,90,69,153,176,82,154,237,242,177,61,52,171,134,212,180,72,43,73,142,210,144,37,52,57,236,195,137,159,70,149,5,216,61,125,185,182,229,197,180,170,25,17,176,223,176,67,246,235,109,43,135,249,32,73,18,150,124,218,213,232,102,134,170,143,239,178,104,228,132,217,65,183,167,112,143,159,140,49,246,193,186,12,51,245,90,206,167,216,53,147,159,27,115,202,209,214,161,34,71,181,167,239,65,249,68,127,9,73,148,41,50,212,217,203,188,110,64,212,128,203,89,215,228,146,83,28,156,65,74,115,137,37,169,108,69,115,54,172,194,130,165,176,248,64,111,124,223,53,48,132,202,56,40,166,82,2,252,132,122,199,234,116,224,89,195,38,98,12,250,90,117,4,161,69,244,14,142,133,128,214,226,214,7,52,32,126,226,45,109,209,180,107,85,230,9,25,139,133,158,206,246,143,255,76,74,148,38,249,102,205,214,133,151,152,128,210,108,234,221,17,107,162,56,47,41,174,142,189,136,228,173,146,228,108,150,242,203,243,47,232,41,125,182,223,209,119,21,24,247,66,71,4,159,223,100,69,4,20,205,106,10,126,147,176,217,12,52,177,70,157,99,8,159,48,135,207,143,210,107,147,108,20,4,133,238,195,184,172,114,33,77,9,30,39,131,76,241,115,122,18,12,21,78,178,98,170,56,182,18,193,164,135,206,245,138,216,251,254,22,75,39,196,115,202,93,230,166,181,103,232,213,195,130,235,13,15,103,67,137,127,72,237,35,79,174,113,162,244,5,167,47,20,24,104,58,63,158,18,32,154,196,135,79,135,86,114,146,254,188,126,28,58,77,82,76,78,48,224,246,153,82,228,106,95,207,61,202,25,123,65,96,228,93,145,149,248,237,62,35,173,79,195,3,134,172,37,213,213,228,192,16,170,240,233,75,244,253,179,95,159,50,199,188,238,15,205,94,9,8,119,75,196,10,232,87,192,78,60,11,213,44,244,24,178,224,34,49,223,96,2,142,204,25,46,210,92,48,31,122,78,249,58,20,118,151,227,157,109,167,116,237,133,110,41,100,124,0,101,78,156,50,211,119,78,93,110,69,28,17,79,222,84,64,83,238,91,34,105,81,196,19,156,178,52,58,231,55,90,133,220,111,116,101,250,202,231,245,193,83,223,235,101,10,13,109,242,171,41,42,156,207,26,87,24,50,82,212,65,250,251,220,25,51,9,229,232,222,198,9,199,6,197,250,23,24,145,28,84,84,148,37,190,10,62,202,162,94,241,219,67,235,180,108,66,20,161,194,208,206,154,247,28,239,4,126,112,74,128,152,198,113,37,171,156,209,171,225,96,71,172,218,27,96,118,38,135,81,182,163,237,216,100,232,83,76,191,118,93,30,23,180,199,148,164,50,3,67,4,166,163,133,30,152,75,234,145,171,14,134,214,18,84,165,103,247,59,51,58,218,221,220,180,42,143,117,41,184,64,178,162,165,204,204,178,36,49,143,83,45,220,214,190,167,89,195,234,214,196,219,62,4,67,128,57,102,56,55,34,139,51,254,231,167,111,0,169,67,209,129,184,109,73,174,17,214,141,244,124,99,59,131,224,112,240,205,118,30,147,7,109,141,225,120,119,169,166,17,252,82,7,4,106,171,253,222,246,198,252,97,54,250,227,130,96,221,109,103,174,198,21,237,229,93,90,52,33,224,201,149,193,216,226,216,88,252,216,49,87,141,141,112,187,6,224,87,1,181,20,69,39,240,111,239,45,22,163,252,40,171,131,120,39,98,74,188,99,54,180,217,130,125,207,3,242,75,201,71,129,167,225,167,210,32,114,134,192,121,23,133,87,82,216,138,90,255,14,245,21,141,18,71,14,18,189,141,250,116,86,24,88,131,172,189,235,81,110,165,168,161,184,234,151,249,126,18,154,120,120,254,246,41,45,238,189,65,244,102,203,231,125,90,10,95,182,97,94,38,146,221,161,31,252,52,63,79,133,226,90,222,192,178,244,181,155,148,64,156,193,238,236,136,167,117,52,230,210,22,251,26,205,37,253,164,245,25,206,141,88,63,127,94,12,217,246,64,101,66,103,185,79,143,75,238,198,105,210,200,220,196,170,124,127,79,32,220,172,198,127,241,65,223,40,3,181,125,148,204,131,30,208,235,232,45,125,45,45,58,45,185,51,51,56,53,207,57,28,40,87,127,255,147,11,139,108,233,244,43,21,84,223,66,172,9,53,235,170,53,62,203,212,248,61,4,165,16,44,57,49,121,139,186,162,124,193,81,98,14,189,131,91,144,248,169,142,29,138,197,72,152,199,130,190,232,71,138,241,119,90,142,23,61,22,66,47,74,182,131,221,255,56,180,0,188,215,235,21,247,226,255,26,126,173,116,3,132,196,43,111,168,248,232,150,163,21,170,95,154,3,200,117,245,103,115,251,17,136,89,184,178,95,104,167,253,168,131,157,237,57,113,130,239,238,96,116,191,137,137,221,7,88,223,155,212,130,165,227,178,26,148,172,157,124,100,175,132,194,198,202,70,161,99,21,153,111,254,23,178,20,66,152,123,92,77,153,64,92,243,225,228,55,44,139,90,73,22,63,102,12,183,129,67,19,211,19,38,26,62,76,187,164,255,146,53,179,235,224,158,192,180,32,36,127,74,15,56,145,251,43,184,158,82,70,207,205,64,163,57,254,142,138,117,65,231,116,207,206,231,160,107,180,148,252,246,243,32,57,180,191,118,148,147,100,36,107,223,174,102,80,46,189,10,182,152,111,203,202,136,187,208,191,228,189,196,36,219,167,110,46,125,216,38,109,196,92,67,126,139,163,17,172,250,90,18,127,134,109,73,87,156,63,106,33,191,25,131,58,176,0,209,241,233,104,214,36,21,132,14,4,91,52,4,26,116,122,82,75,248,36,11,168,30,102,168,200,39,239,18,238,132,9,128,179,82,109,82,143,240,68,157,31,79,140,122,108,100,175,54,132,1,49,68,238,89,240,133,241,123,150,29,138,187,207,195,137,254,230,179,95,180,255,148,218,38,122,207,253,87,199,53,150,183,249,232,234,253,219,125,35,118,145,71,226,185,203,149,168,197,157,45,17,51,150,236,187,213,85,76,204,114,137,121,26,142,238,6,133,102,106,103,194,245,106,98,139,12,144,40,29,204,241,224,229,240,223,154,35,99,241,88,71,181,197,63,40,206,71,22,62,176,15,109,54,1,244,105,61,19,220,115,77,21,168,39,70,6,81,186,85,241,146,79,223,63,183,217,109,115,19,183,20,131,117,102,22,223,31,169,208,254,0,156,146,32,12,77,205,202,207,108,41,19,137,161,67,177,48,192,75,216,55,98,236,90,73,133,80,5,250,81,112,108,126,51,193,17,168,169,130,141,123,177,191,47,251,73,218,152,11,252,172,239,122,118,51,131,142,17,44,6,94,42,46,190,72,73,31,19,7,163,26,197,243,77,250,148,20,51,59,125,207,87,150,136,155,214,4,226,251,30,209,119,187,222,60,19,11,198,207,227,59,102,231,50,47,233,17,204,97,198,231,1,132,42,173,157,41,52,178,8,154,252,8,6,137,249,97,14,83,196,146,63,24,252,57,211,187,249,224,33,56,237,158,134,126,173,58,110,64,54,196,111,254,176,114,3,231,33,130,63,11,110,72,142,77,21,121,206,107,171,162,42,71,13,173,217,212,89,53,223,61,249,83,185,46,18,168,226,148,228,10,89,15,122,127,58,37,41,73,178,217,153,16,200,225,52,218,107,144,49,89,26,13,159,161,59,74,130,80,40,255,36,140,98,195,111,184,134,54,185,245,46,244,71,167,155,7,19,183,159,177,198,224,70,14,25,106,19,34,95,105,239,10,176,150,94,185,154,241,104,150,156,137,187,254,176,83,245,33,111,172,227,188,158,163,34,236,48,205,134,28,180,179,159,30,26,42,17,93,232,114,9,172,147,114,202,86,126,68,152,169,34,170,229,40,190,142,72,29,66,106,136,58,128,252,160,27,145,176,159,161,47,114,165,51,196,10,236,246,145,41,101,131,11,73,188,10,169,147,125,63,50,120,65,33,148,194,73,212,159,244,42,164,188,101,32,236,254,115,95,97,182,163,104,233,151,109,154,133,169,77,158,247,28,12,78,100,147,148,55,12,231,172,22,45,188,233,148,220,135,13,33,232,8,16,138,136,133,119,105,207,197,183,132,47,41,227,21,108,2,76,152,20,221,188,139,106,90,135,241,39,170,251,242,249,69,238,215,98,28,35,220,45,2,89,76,202,185,124,122,29,8,207,141,228,167,32,161,216,35,218,126,219,77,57,89,226,206,230,180,214,85,123,81,83,19,13,28,173,137,25,24,234,171,249,212,186,97,44,133,123,70,5,117,172,252,5,52,116,213,68,113,83,250,154,174,118,112,222,212,74,151,21,199,110,97,176,69,37,84,113,182,157,209,237,201,153,59,47,240,25,33,178,228,217,230,226,197,156,41,241,145,9,62,242,85,109,251,90,38,0,5,128,112,236,50,232,195,37,21,229,36,4,210,5,29,16,167,50,109,52,223,132,25,66,27,222,211,26,12,158,115,87,215,189,66,42,180,80,1,51,66,99,82,218,182,160,163,77,73,155,180,36,61,143,145,228,250,130,161,7,31,223,177,117,215,18,250,216,53,214,77,95,129,169,209,83,171,224,83,255,87,137,68,87,93,218,22,181,178,175,182,198,198,173,239,66,72,126,36,186,229,168,240,168,226,193,68,171,250,233,158,13,113,218,63,227,210,32,27,23,44,54,247,194,46,15,38,180,96,232,153,69,18,204,106,138,242,19,54,161,102,151,188,185,100,99,88,127,255,137,199,41,32,121,14,233,171,78,104,205,141,118,20,7,159,252,161,90,150,4,113,150,63,225,205,98,228,179,156,69,38,4,128,189,142,216,29,141,107,85,161,158,33,167,51,58,53,35,101,247,196,174,40,206,63,183,186,239,108,51,114,117,181,196,46,136,117,161,91,213,103,114,255,234,198,222,9,193,146,154,157,27,137,192,19,122,102,40,173,39,226,5,74,181,186,31,234,247,251,51,194,150,64,247,71,243,196,121,116,143,84,156,246,105,253,234,62,194,84,234,20,22,107,106,164,188,101,28,193,194,115,197,222,174,251,84,198,55,124,94,224,164,229,3,16,124,123,183,4,180,183,173,97,103,37,87,125,178,234,216,206,2,248,207,161,136,30,246,189,180,184,205,58,187,60,90,111,93,253,185,237,116,251,127,182,135,189,182,1,10,45,226,81,250,100,220,16,41,184,74,28,131,4,43,230,30,114,159,140,218,48,39,100,40,70,82,142,119,129,72,86,12,141,12,9,2,210,94,58,137,20,63,88,250,18,53,65,34,107,108,84,1,176,76,237,246,180,217,67,221,64,157,127,94,92,2,111,234,52,114,199,228,243,87,122,39,89,111,4,214,29,215,218,38,60,156,120,103,112,235,248,91,29,178,103,200,155,203,109,68,10,105,93,246,46,85,26,215,236,39,206,163,172,242,148,175,28,123,179,169,186,145,225,6,143,231,164,85,13,228,25,212,218,77,185,213,173,78,4,6,204,202,168,159,248,156,78,58,92,254,129,160,228,91,12,54,153,155,234,238,118,14,132,15,178,34,211,28,51,68,199,60,135,25,185,177,172,247,147,42,168,4,133,94,44,42,56,140,59,134,211,67,230,151,235,14,172,148,188,250,251,255,166,229,212,113,128,47,162,138,71,200,146,4,160,22,67,52,50,67,176,55,190,232,83,227,132,38,42,104,176,35,164,233,63,138,36,34,242,89,128,225,122,127,30,252,14,104,18,200,26,77,112,114,136,209,10,0,254,85,218,174,18,175,248,111,51,169,105,196,195,149,158,96,198,12,136,225,121,203,135,54,103,23,247,189,175,228,117,191,214,31,104,164,154,218,72,230,196,47,44,186,171,7,194,46,80,158,28,58,36,65,229,215,248,82,177,161,11,230,115,101,54,93,54,125,194,82,200,65,192,98,8,65,184,28,169,137,168,255,153,67,144,50,40,48,2,121,92,87,63,121,107,45,181,3,132,233,206,96,122,201,141,102,98,148,39,101,187,42,220,116,69,187,14,94,6,129,73,44,4,46,91,150,42,81,146,238,199,100,197,18,217,165,35,250,171,127,135,218,135,179,82,194,70,133,37,230,164,76,159,252,9,244,13,244,97,110,68,252,190,247,204,168,135,78,87,219,85,90,171,36,169,46,205,216,137,57,167,186,148,88,213,73,26,110,189,143,200,183,119,153,138,96,89,196,237,205,222,136,180,142,119,126,143,63,93,11,57,104,130,116,116,13,158,91,220,55,121,243,25,29,104,155,102,223,207,153,250,53,58,81,133,173,99,178,106,92,127,190,28,123,186,120,214,149,96,32,7,214,200,120,120,239,118,213,215,141,233,129,133,31,241,206,41,208,174,84,80,55,109,99,196,10,166,130,139,13,41,117,45,88,176,189,219,74,247,122,188,105,245,8,56,129,59,77,241,135,157,238,183,192,27,111,206,30,73,40,139,80,140,121,235,14,224,169,160,88,50,154,102,43,108,197,17,65,208,223,29,57,231,0,186,203,75,233,246,66,152,84,71,81,38,14,100,134,248,179,92,249,104,73,122,86,218,94,170,30,124,97,111,215,203,241,213,194,246,27,123,120,235,143,141,190,202,6,51,195,149,73,48,201,233,56,238,165,129,153,45,153,243,36,96,183,10,151,70,243,64,150,71,140,235,169,37,203,213,28,120,48,233,128,64,212,125,202,185,34,184,116,226,35,3,243,103,125,53,255,15,183,223,206,38,121,115,70,187,82,209,159,55,62,59,192,244,5,6,100,74,197,55,138,174,209,166,216,36,16,63,60,42,64,80,102,224,2,9,199,204,73,127,241,3,151,85,22,173,189,119,175,217,169,190,170,125,135,80,42,196,34,68,15,182,215,14,241,123,116,210,21,53,75,149,237,226,74,188,230,87,11,14,132,13,7,158,92,161,162,113,56,121,218,118,40,211,101,40,161,157,163,211,242,238,209,51,25,104,67,197,219,206,104,164,164,152,124,64,148,56,130,139,182,54,84,36,38,228,50,50,171,43,15,88,216,43,189,172,7,239,117,236,221,80,244,224,80,195,97,101,66,76,83,0,64,86,71,195,220,18,229,195,76,182,48,158,222,122,221,61,36,250,60,30,88,96,57,69,88,62,207,215,86,128,185,90,161,102,120,8,14,45,12,118,101,149,189,102,224,211,59,31,119,86,137,100,89,23,230,180,208,69,27,165,141,227,255,12,164,21,162,238,207,86,249,184,3,239,40,110,119,104,176,45,114,184,57,117,171,161,138,83,190,0,92,217,218,58,141,242,84,125,20,99,16,9,63,142,96,149,110,123,70,222,83,240,249,111,153,66,172,121,92,100,185,236,26,225,144,100,103,223,14,95,87,236,216,193,151,17,51,230,137,194,147,6,17,29,193,26,173,170,87,165,26,254,252,56,180,178,60,247,197,36,72,210,212,130,247,69,222,210,81,18,143,207,131,31,176,203,52,51,159,155,149,221,166,39,31,170,130,115,204,79,228,67,238,162,248,23,1,251,43,80,69,117,140,136,12,230,16,65,96,126,79,0,168,241,234,245,241,51,83,189,184,47,122,15,37,42,211,15,193,251,196,165,96,55,138,252,76,222,9,215,168,48,34,142,34,96,85,46,22,69,52,196,101,33,104,134,209,248,93,201,39,72,1,53,54,31,108,62,136,132,239,229,23,212,82,27,26,180,32,180,84,13,33,250,144,85,89,91,21,104,150,104,124,148,72,131,192,114,204,40,166,247,134,109,152,15,88,173,128,183,232,199,7,116,235,172,12,10,81,143,70,68,211,29,176,196,94,28,47,146,218,34,152,250,169,81,26,133,202,156,45,126,240,21,109,211,174,45,198,201,226,34,230,204,194,197,171,91,83,212,240,208,153,109,76,59,156,78,126,202,9,193,131,96,194,247,136,153,16,149,194,50,51,229,51,219,213,122,170,72,108,128,20,92,105,7,87,225,41,241,60,234,35,156,244,54,221,111,89,113,127,85,75,45,255,62,75,208,149,209,103,91,211,78,103,15,182,44,81,156,119,88,48,114,180,190,74,77,105,12,48,108,254,105,240,135,145,23,208,251,138,191,43,189,218,182,43,218,82,48,170,0,38,82,126,150,79,166,181,180,166,54,75,46,21,203,23,60,238,68,187,1,50,102,75,254,194,151,182,61,237,157,251,190,207,189,204,41,38,75,85,110,115,194,10,208,95,162,219,221,30,236,162,88,191,73,114,17,75,219,192,71,244,40,101,230,248,31,177,58,172,161,230,231,100,72,115,74,189,220,90,221,117,46,178,119,55,117,181,111,253,3,110,181,64,106,73,193,159,82,13,239,253,229,33,158,148,61,244,75,34,109,59,25,44,208,28,208,192,254,173,236,226,207,141,15,152,31,195,85,120,97,133,114,39,193,155,141,240,208,225,119,93,252,131,122,153,175,65,164,102,133,59,22,115,204,117,254,124,186,168,151,227,14,198,82,7,29,168,60,117,149,139,77,62,151,131,245,213,28,92,162,182,2,1,55,49,5,68,47,150,43,112,45,92,105,86,123,138,51,180,74,0,252,64,145,155,95,1,101,154,19,12,213,5,85,120,148,112,39,121,142,192,58,99,140,232,93,67,64,213,96,171,127,147,5,121,23,40,33,168,205,4,18,247,15,86,153,156,146,10,48,65,60,160,89,228,38,76,198,96,22,111,33,40,16,82,18,95,133,216,58,250,246,150,206,46,208,51,114,53,237,163,206,68,155,69,112,214,112,37,50,5,242,172,71,237,59,29,34,228,144,1,128,247,22,185,130,236,78,170,159,20,94,175,160,249,2,114,138,174,232,45,224,249,28,7,83,250,120,228,214,238,18,145,147,233,188,79,104,124,57,72,219,151,130,247,132,42,205,22,221,7,184,18,209,46,93,80,91,123,109,249,74,254,232,57,161,102,61,175,132,7,72,170,190,185,148,209,99,130,7,180,91,133,82,47,87,175,111,82,223,111,82,63,108,115,30,53,35,215,236,180,25,126,77,237,172,176,199,69,17,44,37,98,37,137,13,109,74,40,210,197,100,195,46,26,85,69,157,180,238,172,80,90,147,152,92,229,125,12,218,195,96,124,143,222,31,234,16,233,34,136,36,150,208,83,200,229,110,86,23,177,198,201,12,16,104,13,75,57,42,140,72,120,69,111,203,78,147,253,69,59,119,31,117,80,132,191,131,179,2,214,141,90,161,66,29,202,29,230,24,53,163,17,221,78,185,183,114,176,181,34,251,51,43,90,151,148,76,75,180,51,22,3,81,139,92,160,200,14,176,18,28,156,97,22,57,221,18,182,133,46,63,9,254,66,238,118,125,127,45,151,29,75,123,248,166,145,67,237,117,21,0,183,71,226,215,4,215,65,109,82,142,205,191,112,205,12,91,115,24,225,95,66,103,28,212,9,195,192,168,231,177,227,86,59,38,107,163,47,61,252,126,141,160,35,24,25,2,0,199,115,191,121,153,6,43,76,6,72,234,148,243,117,169,231,27,92,103,3,124,216,0,197,115,104,48,23,158,202,118,134,91,90,241,100,130,70,188,74,82,59,60,101,171,82,14,241,96,143,215,44,147,152,184,13,225,198,26,237,50,162,11,103,182,231,239,204,148,78,109,62,12,11,17,51,43,176,40,61,24,250,163,66,134,99,82,219,235,1,4,92,137,135,220,207,7,241,64,72,156,144,242,13,76,7,41,147,167,210,118,92,78,80,10,140,189,126,204,169,161,151,196,255,240,93,60,25,160,164,66,249,58,17,17,8,169,2,198,38,39,47,163,33,8,149,235,224,13,177,8,1,216,23,232,156,230,174,236,194,116,94,162,115,30,136,156,30,194,235,8,173,36,23,2,209,215,220,202,149,62,58,94,166,67,188,211,213,130,253,70,152,31,120,157,4,96,155,8,105,1,79,44,126,246,237,99,20,99,211,122,143,82,106,3,32,112,98,129,176,126,156,155,253,140,40,194,170,225,176,224,57,127,227,11,144,36,129,86,17,41,60,162,55,81,211,110,174,32,187,31,48,179,152,72,65,58,241,65,76,29,141,168,218,19,130,3,62,50,60,228,251,63,219,23,225,115,92,155,116,91,232,93,136,208,164,249,18,168,49,201,129,109,77,246,73,151,115,43,205,119,104,188,50,125,70,21,218,157,213,2,75,10,41,55,69,240,47,89,170,122,229,250,241,190,60,35,215,235,209,4,2,94,44,132,211,194,72,175,54,218,135,250,132,43,191,73,28,18,219,81,63,109,124,132,40,176,194,133,240,31,138,11,109,251,121,225,192,248,201,57,136,186,6,147,130,237,113,100,98,198,255,88,32,190,42,35,97,213,68,70,214,188,171,35,28,76,57,84,54,196,56,82,219,162,232,75,70,158,100,232,232,45,121,218,138,162,222,195,67,141,101,244,251,10,170,172,91,225,245,117,147,113,134,48,13,140,2,133,74,72,161,243,87,19,157,15,94,54,116,158,21,245,24,219,246,45,55,239,225,204,215,94,141,240,250,208,202,230,53,54,152,235,147,113,30,72,252,162,26,222,135,221,233,69,200,213,49,90,236,76,229,216,249,172,228,22,151,202,104,233,174,115,60,200,115,222,220,97,159,41,241,69,114,155,4,126,19,250,229,193,164,91,243,255,73,209,107,10,20,197,248,127,3,238,137,183,170,99,236,163,54,198,87,64,145,109,111,60,115,26,79,189,19,160,24,86,134,59,190,166,192,96,122,104,179,111,78,197,82,159,69,150,157,204,222,27,129,182,115,17,48,234,35,147,92,208,59,7,200,121,78,37,243,107,228,26,236,240,100,1,109,1,100,23,179,179,38,0,148,178,24,65,38,172,61,227,140,25,23,112,167,213,8,243,205,10,119,20,30,140,88,38,147,152,8,127,154,231,10,232,148,227,9,55,128,49,240,106,226,227,108,143,189,227,193,85,209,126,182,150,121,93,149,168,247,248,158,5,14,110,151,128,85,233,8,63,24,16,136,13,228,206,172,252,80,50,58,136,89,183,239,22,221,38,89,182,23,207,94,139,160,6,106,221,143,184,27,62,242,131,57,197,213,238,234,190,210,12,165,102,5,113,108,176,227,113,86,227,71,186,226,82,219,126,177,199,207,81,235,243,140,108,79,47,152,33,176,160,31,183,236,60,47,53,100,72,198,87,89,175,172,34,28,118,254,234,123,247,158,245,37,73,180,57,132,123,160,31,68,110,73,175,182,90,48,85,92,36,85,0,237,152,160,209,141,50,122,76,95,125,21,13,240,46,21,138,132,53,65,152,133,95,9,95,15,230,109,161,116,103,110,215,162,15,90,53,243,172,151,19,95,178,58,78,162,166,91,241,191,26,136,60,146,202,137,100,56,13,186,168,154,215,30,11,223,123,67,74,212,2,8,29,14,143,137,29,65,28,113,177,141,86,123,58,97,78,211,255,149,9,190,24,43,96,148,154,32,124,41,110,42,242,233,180,131,244,151,185,66,49,129,142,197,122,235,13,90,185,96,252,253,111,115,63,205,54,94,73,195,1,81,3,230,202,202,10,197,146,6,167,134,173,49,213,126,175,75,49,73,245,226,218,89,45,30,186,170,22,178,74,195,105,160,3,59,236,252,44,209,94,225,92,47,98,104,254,140,54,237,181,6,212,69,101,134,18,103,169,185,137,198,156,27,27,84,164,242,101,255,162,12,228,38,81,23,197,97,216,34,254,43,103,146,27,179,132,55,228,178,3,219,119,3,48,177,194,29,146,198,97,171,168,37,118,168,141,134,121,255,117,19,47,109,66,151,7,107,89,250,218,182,27,112,251,83,162,87,169,174,57,187,133,128,32,154,165,65,38,155,186,110,199,57,32,10,142,129,9,25,252,81,37,145,3,122,163,174,132,202,77,179,209,212,151,121,33,104,254,208,151,196,152,207,31,81,87,60,191,0,253,129,113,38,226,44,163,39,92,205,213,8,44,221,217,58,52,74,44,186,49,153,230,199,229,36,237,114,143,225,87,184,162,29,108,185,219,23,103,33,252,137,199,26,190,41,28,72,2,197,112,2,135,45,246,29,19,146,110,82,159,140,188,9,172,72,117,63,15,216,128,0,101,15,125,124,187,54,246,98,29,22,235,97,41,32,105,24,75,193,113,198,106,9,244,133,36,155,16,13,233,84,202,241,75,129,142,84,168,131,58,185,119,164,34,201,88,78,80,209,157,156,24,116,24,134,100,204,238,136,181,95,126,120,235,187,138,56,66,76,99,93,142,78,202,153,162,119,144,134,137,40,65,229,98,69,171,27,28,85,87,110,213,54,196,98,90,38,224,123,37,196,54,82,51,132,189,174,214,95,114,29,84,202,70,45,19,64,132,52,218,192,160,126,135,153,154,3,121,105,120,217,149,43,178,135,236,85,232,105,135,57,143,34,51,122,151,10,232,100,134,176,42,233,98,249,60,139,71,121,7,245,132,118,171,215,161,67,119,76,109,121,78,17,98,95,8,163,224,8,97,97,168,250,91,190,153,5,250,201,117,32,28,119,224,91,194,52,21,235,12,10,219,70,66,185,169,42,147,14,114,219,107,90,168,227,255,176,134,238,254,109,138,180,201,114,156,37,87,97,212,82,132,100,91,23,215,226,66,17,19,186,97,190,238,107,148,147,82,122,186,159,81,91,14,253,158,54,126,235,214,47,172,2,230,167,226,167,199,66,20,97,167,145,158,79,205,50,4,123,183,1,110,211,42,219,251,27,105,9,142,238,241,34,131,147,17,30,207,241,114,74,9,74,141,69,8,172,67,253,95,8,178,241,213,181,45,217,58,17,45,169,169,36,63,24,236,226,107,189,254,33,27,215,122,241,161,254,118,45,255,163,159,218,152,210,244,18,148,36,75,200,202,14,234,131,47,153,209,178,4,79,33,100,96,208,73,230,5,241,222,119,173,40,123,218,37,45,197,92,158,252,212,0,170,95,118,137,254,240,136,7,120,64,144,179,106,249,222,154,95,82,245,21,234,174,221,202,132,46,215,167,34,88,215,246,116,58,150,31,51,51,210,21,35,102,179,244,18,133,214,105,169,182,175,45,46,47,133,190,230,184,52,36,78,15,22,226,113,172,218,50,169,189,142,63,162,154,231,250,72,160,21,215,22,69,126,196,81,140,182,131,135,111,50,37,2,185,130,151,199,124,11,223,200,18,208,167,101,101,235,173,122,47,225,178,122,61,117,60,53,97,197,236,228,39,66,172,205,171,13,19,231,168,222,177,208,9,72,224,109,45,251,43,139,84,119,106,42,254,179,91,227,185,92,213,241,74,146,79,9,70,111,37,11,124,166,202,207,88,146,113,228,129,232,59,162,69,119,16,240,221,160,71,49,109,194,103,180,73,55,112,237,100,5,191,236,65,250,3,199,26,116,48,167,52,45,95,25,146,247,101,52,51,200,91,214,220,192,126,143,37,27,7,104,253,82,207,220,192,17,78,192,194,188,132,64,130,39,123,113,80,209,185,106,176,213,220,114,226,2,44,151,51,43,231,44,5,203,90,81,4,205,106,86,141,149,37,166,60,22,168,89,181,140,23,136,14,70,185,79,196,151,72,252,116,156,121,48,61,40,16,225,233,79,140,191,120,52,172,40,83,197,234,225,79,65,101,121,142,245,90,66,84,140,184,82,25,89,46,173,247,234,134,240,5,160,128,31,126,178,189,188,22,175,3,107,2,44,52,177,208,21,57,5,53,30,0,184,116,122,250,130,0,20,139,130,102,49,66,39,189,238,160,194,3,80,210,231,40,84,215,31,219,125,70,99,37,14,197,74,199,179,91,246,95,62,68,152,218,43,50,2,211,26,127,138,191,144,222,155,100,149,135,51,242,196,69,103,28,130,245,43,203,13,91,245,128,248,62,40,7,80,246,50,180,9,139,132,16,127,214,5,12,252,250,34,129,14,171,227,197,38,48,161,57,254,205,172,136,249,109,167,100,169,209,246,208,231,69,185,40,149,125,145,252,170,58,38,242,113,90,143,15,47,62,159,4,2,19,48,155,209,45,81,115,168,99,193,5,63,50,189,73,65,28,191,192,192,70,252,200,79,55,70,221,55,68,43,154,208,179,28,233,39,27,214,79,230,116,189,252,54,209,71,126,54,70,241,151,62,246,52,251,97,188,134,45,170,117,40,80,124,147,179,161,67,102,139,88,186,237,238,236,131,111,90,173,139,24,27,244,215,2,81,233,246,12,145,227,142,21,131,219,244,249,163,30,83,134,167,212,133,248,205,128,240,51,176,108,214,89,36,107,250,75,33,48,69,82,219,179,37,18,252,108,25,148,114,40,201,60,73,139,153,234,150,253,153,15,218,144,225,242,142,189,227,61,89,36,139,240,81,251,241,234,159,250,149,18,253,146,162,199,229,175,150,184,98,135,91,15,219,190,224,9,197,208,83,234,18,167,84,234,177,24,206,24,87,177,166,211,56,126,101,187,190,163,31,53,79,179,136,172,179,195,62,74,10,155,79,165,44,33,70,184,160,22,179,156,217,138,85,139,141,235,75,87,156,226,140,128,145,168,157,107,22,132,230,145,245,40,129,93,103,49,206,95,174,135,217,40,67,132,127,222,180,216,84,168,146,59,163,237,22,155,89,43,203,83,30,202,157,84,109,96,63,26,87,117,142,4,175,254,174,198,6,171,117,179,81,219,35,216,125,108,173,71,44,154,151,227,196,175,60,62,20,250,2,4,121,112,137,97,149,130,152,172,189,8,29,119,6,216,79,104,241,199,232,143,130,113,115,232,139,83,60,125,243,224,98,98,114,85,184,206,206,249,31,168,96,27,229,58,214,219,24,48,154,134,233,254,2,39,114,234,114,51,115,124,96,63,104,162,56,204,222,29,51,125,3,134,27,102,206,26,251,21,4,55,87,63,236,13,130,138,66,25,169,18,135,116,25,243,18,5,193,111,193,3,63,105,28,138,114,197,174,39,127,51,116,1,235,240,118,22,214,38,237,51,1,174,107,50,249,185,192,26,89,25,216,20,96,86,219,13,248,240,153,6,224,79,57,70,127,233,204,70,131,211,237,24,43,11,151,87,188,182,245,232,127,63,206,177,145,200,53,217,184,121,183,64,196,177,145,193,65,45,127,139,183,162,23,181,27,57,206,9,78,157,10,151,1,102,32,53,189,36,51,163,225,50,90,234,6,134,123,184,56,80,20,62,51,181,2,25,74,154,209,131,109,172,240,203,251,105,190,77,35,253,240,85,132,162,62,112,135,68,96,24,155,134,181,49,45,117,50,240,231,219,61,225,148,142,177,0,29,103,240,217,193,58,217,160,33,246,44,26,239,169,234,20,2,119,216,52,111,181,202,14,9,233,108,107,112,149,180,22,44,125,113,144,145,116,226,12,170,105,102,25,251,162,214,235,193,136,166,5,52,197,100,128,121,67,155,180,228,235,137,10,101,95,150,8,160,22,146,171,175,57,153,54,75,62,163,49,20,63,35,204,201,128,135,177,49,166,233,105,206,246,161,40,45,217,146,238,153,233,117,25,227,145,164,39,55,42,198,117,128,81,4,90,170,85,13,238,155,39,246,224,157,103,81,10,114,29,180,152,71,147,172,252,98,5,238,211,250,98,129,37,100,42,144,45,11,18,173,52,74,228,57,32,245,69,77,110,18,90,77,114,206,10,42,159,112,18,89,145,31,141,100,58,240,71,171,13,92,191,237,53,78,242,218,39,238,195,32,110,121,80,233,180,242,82,98,122,50,37,250,87,242,45,207,152,217,104,95,234,36,212,47,209,32,240,197,101,164,115,62,49,17,53,92,74,94,33,54,88,111,107,23,247,110,29,132,36,21,17,100,55,30,4,174,31,92,158,63,152,88,227,112,63,233,206,106,110,15,149,46,55,133,211,105,247,158,234,210,102,197,99,100,62,174,127,62,26,5,210,164,251,147,11,50,183,152,237,72,215,121,81,205,193,201,42,114,55,60,15,68,218,195,4,27,229,115,150,133,201,104,236,172,165,224,242,235,200,2,90,16,69,147,104,254,31,207,65,146,71,216,86,153,220,94,84,85,156,120,150,52,55,19,81,84,194,73,174,182,30,153,109,91,67,96,149,139,143,243,123,68,130,55,157,147,205,237,206,178,60,191,203,61,163,142,102,141,122,156,39,195,26,119,235,201,82,237,29,170,171,179,84,205,57,97,134,244,182,150,179,69,96,229,237,157,88,242,187,30,108,190,44,99,30,131,196,176,195,249,191,57,190,106,160,251,158,143,100,158,213,149,27,216,198,184,89,9,8,104,111,193,22,125,201,217,155,119,174,232,66,215,8,14,103,189,184,241,87,34,22,227,4,182,3,136,108,135,79,182,15,213,235,123,67,161,92,202,249,201,124,47,170,143,15,223,207,111,190,123,207,51,142,235,110,93,94,203,119,226,0,196,160,175,252,118,94,42,50,195,130,163,188,108,54,47,166,51,229,19,240,241,14,62,112,26,211,28,111,175,176,114,77,71,107,162,221,165,249,230,88,74,205,25,47,100,61,157,33,197,192,147,135,31,177,111,46,162,82,17,133,6,14,43,242,86,123,6,185,148,152,135,2,125,74,114,18,165,124,84,57,3,11,82,45,94,70,56,254,219,90,126,140,127,75,166,18,21,108,79,9,109,59,204,27,24,173,172,57,181,224,181,216,214,21,163,109,47,159,122,91,131,180,220,247,223,40,253,230,125,183,8,34,71,156,47,29,55,179,128,255,8,137,118,135,201,140,138,182,135,94,89,151,91,248,49,219,35,206,52,169,122,217,100,195,117,31,242,95,9,175,253,146,153,122,221,31,98,255,23,163,40,96,107,101,156,3,116,191,93,183,192,49,106,144,124,32,188,98,187,235,118,64,54,192,166,87,132,126,27,239,185,196,79,177,179,243,195,219,66,95,71,76,116,90,16,29,154,12,193,110,240,199,133,44,157,114,168,140,99,234,78,138,195,112,28,34,189,50,149,186,48,121,64,94,70,6,47,138,136,54,17,122,88,60,2,228,168,22,140,24,253,157,52,202,95,40,90,43,234,166,67,212,128,47,46,121,225,140,216,185,55,61,252,235,20,230,129,181,126,38,144,12,24,20,76,69,119,137,133,24,190,30,94,41,235,106,8,37,93,14,187,169,110,124,176,220,66,167,175,148,243,252,58,131,238,108,134,123,129,5,171,255,182,110,3,97,181,61,113,117,24,19,180,83,145,238,160,111,14,206,42,153,213,137,30,232,53,212,1,95,154,160,223,120,235,76,2,206,62,66,163,159,111,246,83,60,102,182,62,249,197,129,203,229,236,8,7,14,145,113,151,251,50,4,220,95,190,85,221,73,2,141,79,26,154,234,24,105,49,148,170,128,38,213,45,245,32,169,8,4,128,139,109,2,31,152,136,187,30,190,141,141,181,58,114,19,7,45,153,68,62,49,103,0,165,152,136,213,253,87,251,16,165,200,180,196,225,126,78,8,189,250,145,241,42,128,118,244,250,204,5,172,3,118,14,38,67,44,18,111,17,41,162,219,222,77,229,36,3,12,44,224,48,176,160,129,42,124,207,80,208,111,231,150,4,128,131,67,148,212,20,195,204,99,53,70,207,165,43,44,142,181,5,165,82,32,146,5,101,140,76,139,169,67,226,152,106,7,208,153,251,133,77,199,53,13,206,34,9,165,203,201,222,217,16,251,20,118,34,156,96,172,151,206,196,219,234,142,197,118,57,131,1,251,219,179,36,68,41,49,202,100,160,117,157,75,198,240,211,199,110,57,39,99,247,114,188,44,182,104,84,42,180,119,52,148,132,224,144,238,137,250,220,219,56,0,62,238,228,193,131,140,47,78,36,81,135,214,162,179,111,245,111,64,249,132,50,23,15,98,169,48,202,69,174,157,30,29,186,250,36,45,144,184,227,47,14,234,16,245,184,6,254,178,141,89,213,193,37,92,134,101,220,182,25,120,99,122,7,118,183,97,205,247,152,46,27,38,224,126,58,233,86,146,127,121,25,72,129,165,67,171,242,73,171,65,192,110,233,23,179,52,194,73,22,140,119,110,128,6,63,87,230,157,241,97,119,37,170,205,51,25,226,233,188,40,200,78,14,141,140,54,154,171,59,238,169,130,115,250,210,191,107,79,18,110,155,148,105,73,33,41,247,84,162,4,76,54,123,154,209,163,187,85,203,12,145,163,221,141,61,230,188,242,216,19,119,221,51,42,125,188,229,137,28,238,42,121,135,222,241,166,254,241,109,200,223,53,24,253,145,60,26,71,168,233,15,97,37,101,61,223,73,169,4,254,13,57,79,10,221,8,127,46,44,169,164,87,219,213,210,1,232,83,180,102,103,158,180,230,198,166,188,151,158,164,167,89,0,45,245,208,179,120,80,97,33,222,168,133,169,237,137,35,163,64,251,50,144,75,108,127,147,158,164,17,137,245,165,128,129,136,135,227,134,26,20,121,142,239,90,231,178,11,102,30,215,36,159,196,50,178,108,56,113,20,25,215,31,160,123,245,40,168,177,148,24,12,97,130,247,25,152,164,18,90,13,22,236,139,92,115,6,109,245,6,165,64,22,51,143,87,221,140,133,47,216,218,133,132,202,170,87,215,14,20,45,218,196,108,9,175,223,240,160,152,64,251,7,226,144,98,120,150,62,129,153,215,229,181,236,246,240,180,52,131,242,145,10,178,198,95,161,225,126,30,178,31,15,195,57,78,39,6,218,253,29,74,221,248,55,86,32,200,201,70,229,126,7,42,191,224,4,177,250,65,84,94,88,64,224,200,147,36,213,34,6,81,217,77,178,230,35,115,126,131,207,110,139,40,213,104,127,75,208,124,66,198,48,87,142,67,237,146,35,3,76,208,202,87,248,68,199,208,171,77,229,171,136,133,19,63,183,106,121,183,223,84,201,5,244,109,99,140,109,209,254,214,61,97,29,45,195,198,119,209,10,203,167,115,17,38,198,122,69,12,119,0,46,229,126,35,210,77,240,235,156,232,9,109,85,55,149,104,31,226,115,67,198,86,235,154,110,138,28,95,34,78,131,131,43,248,107,177,146,65,147,156,48,134,188,180,103,209,246,192,165,135,39,233,141,38,79,107,250,102,56,1,122,8,105,81,97,19,172,165,59,14,103,191,109,59,103,95,157,75,30,92,196,109,79,79,164,220,134,188,133,145,24,187,207,41,3,83,216,78,9,88,161,130,91,214,186,53,22,71,12,248,229,206,146,70,215,31,16,148,167,17,213,177,32,135,47,173,14,4,46,30,60,157,180,242,104,62,88,205,60,219,255,103,76,213,4,41,147,248,132,238,86,16,4,5,113,21,229,254,244,191,197,116,171,53,112,238,249,228,235,42,99,147,154,173,101,221,44,81,84,84,88,253,30,192,137,114,48,103,84,224,84,195,218,94,162,214,173,224,70,218,179,189,196,247,152,172,116,195,192,170,186,156,5,5,178,87,240,115,206,186,35,53,160,191,24,216,96,174,10,59,193,11,82,40,126,67,8,154,148,143,245,240,23,116,249,43,142,109,168,114,11,58,228,201,116,38,114,152,248,53,170,129,133,14,57,227,189,233,39,152,74,17,1,124,67,44,117,113,119,141,40,177,94,152,207,161,209,128,254,217,24,65,47,140,40,192,178,224,239,159,177,203,81,107,8,181,217,79,162,216,219,5,110,0,177,40,16,142,158,245,97,44,212,16,108,170,46,156,241,140,104,158,100,62,126,92,193,102,68,120,70,129,186,24,187,130,131,6,83,36,189,237,167,179,224,71,226,244,195,150,222,239,71,61,158,225,194,16,233,81,208,161,128,223,167,17,222,22,18,75,129,38,212,193,90,150,175,64,72,87,228,247,53,229,91,115,154,117,139,125,78,145,35,109,124,33,165,223,191,123,36,32,239,156,170,145,120,52,246,111,11,93,136,27,109,212,174,18,67,119,145,244,89,245,50,144,124,19,255,254,145,229,157,153,123,206,252,216,216,16,128,217,231,180,48,181,218,165,143,191,3,92,10,145,225,81,22,44,223,230,190,243,220,86,0,97,29,222,160,76,50,118,216,62,215,80,39,46,61,131,53,41,39,183,59,157,107,144,45,72,142,7,32,175,162,93,74,108,242,165,216,42,120,124,58,70,83,180,65,254,21,3,186,124,24,108,92,82,166,110,159,28,44,43,192,21,77,68,222,27,231,135,19,246,124,227,201,6,3,143,152,122,189,218,215,110,164,253,179,80,3,96,34,229,51,182,52,60,204,158,153,212,138,84,140,44,121,245,185,100,153,103,147,21,161,200,216,126,62,56,94,37,93,66,172,173,133,44,198,237,42,245,149,75,81,221,165,75,132,248,2,230,247,222,143,224,152,126,74,214,135,23,151,93,25,184,253,241,12,101,68,228,192,102,246,123,120,114,26,13,222,159,168,58,98,64,236,71,15,178,68,158,249,74,118,6,88,120,109,12,136,30,215,80,130,50,96,37,177,142,31,190,29,20,196,18,87,151,59,123,23,51,1,57,20,148,34,33,218,175,83,195,1,24,155,43,228,84,93,235,76,230,14,0,23,221,239,210,154,23,185,168,49,79,19,13,32,243,22,183,31,72,93,111,251,244,36,165,196,63,113,123,226,86,183,188,244,31,188,148,225,117,30,13,222,242,53,221,166,173,121,12,62,167,166,218,190,0,251,16,65,216,18,185,251,252,184,42,38,57,54,247,151,38,192,63,49,101,98,232,205,44,213,164,122,140,231,253,221,253,203,252,108,219,115,220,168,217,51,91,236,79,68,93,74,248,197,128,168,2,238,160,139,109,99,68,108,192,88,245,4,203,135,138,197,239,204,69,226,163,220,34,254,68,220,90,44,182,139,34,134,194,187,168,199,148,23,212,82,140,137,76,36,35,240,137,121,147,145,58,201,39,170,128,244,241,146,195,53,226,141,68,94,60,220,27,79,240,223,72,216,72,73,89,204,152,244,136,201,129,225,79,243,43,226,211,217,49,222,51,205,16,196,86,54,15,42,159,50,48,59,1,87,220,83,64,173,33,245,151,209,124,201,8,20,86,242,210,221,189,184,51,240,82,200,16,178,193,184,112,50,73,105,219,79,230,5,86,78,148,223,45,201,62,160,33,238,199,178,210,240,157,120,167,244,146,49,55,185,139,52,252,139,39,153,43,203,121,13,64,189,22,151,84,48,87,138,19,246,53,64,163,106,131,169,200,46,213,163,179,116,50,97,97,132,131,222,250,114,211,142,66,232,185,106,61,152,176,235,172,98,51,244,123,83,7,158,49,99,178,192,166,194,56,90,130,175,206,153,32,202,253,202,241,153,187,119,11,239,4,235,37,179,1,174,117,45,61,89,44,137,248,144,79,204,192,185,48,159,4,170,85,2,209,27,163,74,152,115,121,133,186,94,223,128,103,250,81,12,115,163,113,21,61,95,67,202,44,33,113,141,133,103,228,35,251,208,104,164,31,255,28,90,28,116,123,41,155,114,242,164,16,143,16,52,164,214,226,83,41,122,11,83,149,121,14,232,243,196,115,31,208,115,235,53,38,167,92,223,65,202,218,9,222,85,79,32,189,244,229,203,75,4,96,217,88,227,50,56,88,2,33,199,237,126,246,32,50,96,7,146,208,206,94,199,2,28,57,51,13,134,85,191,13,208,2,104,213,241,163,143,190,234,208,138,228,162,44,145,172,229,42,168,252,24,91,21,204,35,12,42,108,6,85,190,63,232,229,51,92,6,55,121,192,209,168,171,87,100,139,76,37,181,49,158,136,199,189,202,54,163,95,60,103,132,164,106,178,137,96,141,192,245,43,253,118,224,10,242,238,172,189,226,168,193,171,44,249,179,24,17,55,173,118,100,72,74,163,217,201,225,223,163,112,177,83,176,189,242,63,218,144,58,82,224,57,105,105,54,105,231,115,54,233,128,127,74,179,166,96,163,166,153,84,180,149,175,27,191,206,176,221,103,20,119,126,214,208,167,4,49,22,228,23,122,58,210,122,81,145,212,63,230,69,168,58,72,164,99,114,175,125,66,175,200,45,240,10,32,10,91,140,80,125,174,107,220,43,96,197,71,25,185,0,138,53,33,242,14,231,57,93,40,89,186,238,2,114,239,2,177,193,164,98,136,99,255,235,239,209,102,208,98,220,194,13,45,63,242,158,209,73,187,96,255,254,150,234,159,65,23,252,194,226,60,190,221,206,148,76,82,12,221,140,5,194,46,230,179,99,168,170,176,208,133,162,123,157,230,209,189,241,91,224,3,48,57,53,96,232,237,5,165,89,79,47,251,144,219,239,60,65,82,86,231,105,251,70,230,147,65,123,176,183,119,92,85,31,4,184,202,36,45,108,41,200,70,79,248,64,18,160,44,2,131,94,97,80,215,128,50,165,244,222,201,240,250,157,178,239,10,206,45,250,33,40,9,153,238,82,70,118,84,204,200,17,243,12,221,26,6,91,56,42,94,155,156,253,250,32,67,63,65,23,93,228,67,98,163,135,203,136,247,232,233,159,154,0,122,246,64,233,167,229,81,233,97,2,46,226,229,225,33,78,130,21,16,205,115,54,230,87,94,232,158,78,163,57,106,213,3,56,12,118,197,106,177,224,191,35,14,64,190,18,129,214,189,178,173,229,163,254,157,13,66,170,222,199,170,99,85,62,82,30,79,177,87,24,113,43,30,194,177,139,3,88,96,126,157,150,34,61,191,64,70,74,16,181,146,119,177,27,132,0,218,73,99,49,108,180,25,129,237,28,16,13,6,79,102,7,246,64,191,216,201,164,244,72,80,92,108,11,212,19,156,154,65,42,170,252,157,16,3,252,104,159,26,130,148,101,90,189,83,114,70,162,137,117,247,205,205,89,90,129,158,133,208,15,73,237,1,160,89,214,28,54,151,97,175,184,156,189,207,22,91,51,254,111,8,46,22,7,195,123,114,102,95,149,99,14,177,27,163,37,170,16,100,34,127,198,4,234,226,234,89,173,96,159,224,194,175,190,30,121,171,140,24,55,82,226,8,159,21,22,60,122,44,42,131,175,239,109,197,231,171,95,60,147,167,35,208,83,226,68,237,189,247,232,207,6,32,83,38,105,145,197,67,3,108,197,135,161,172,123,29,244,117,247,139,232,212,48,9,144,218,241,75,154,240,130,167,43,115,93,236,125,42,39,218,9,90,97,152,134,83,150,193,55,15,233,144,185,0,75,176,16,145,13,126,180,93,10,147,61,182,203,230,83,100,210,251,12,47,8,17,44,181,105,136,129,64,168,111,76,148,8,212,171,75,32,147,254,141,241,209,233,115,20,137,194,235,183,86,156,63,144,76,16,45,169,6,103,56,172,66,167,213,58,44,126,64,235,60,108,204,231,184,33,154,205,212,3,71,136,114,185,84,170,165,189,149,99,114,58,110,3,80,146,6,69,36,111,203,152,157,156,213,199,66,123,229,89,83,201,150,219,60,85,168,147,83,73,107,52,20,114,236,238,145,166,30,42,20,236,166,255,6,148,59,144,83,61,92,225,174,5,222,35,69,107,231,221,121,254,54,48,232,59,33,230,108,37,160,163,104,71,54,207,128,218,101,225,29,69,11,244,62,198,189,107,181,225,190,249,240,177,180,5,124,134,26,166,143,25,169,27,218,25,178,173,64,118,21,48,80,92,73,248,68,88,4,127,254,44,224,164,170,38,166,238,148,86,12,130,205,62,68,156,162,141,250,159,153,55,149,109,187,58,244,204,149,202,193,181,135,80,101,30,202,113,157,147,213,141,218,5,47,100,192,103,200,171,196,187,255,3,101,50,183,158,99,195,229,35,246,158,111,171,166,59,207,207,226,191,169,176,91,15,94,207,75,255,219,198,219,80,226,149,153,168,152,218,220,14,210,46,46,52,5,70,198,205,217,109,132,179,205,193,5,73,108,89,87,225,151,15,102,186,23,17,29,255,138,149,65,66,62,147,15,26,59,225,58,40,202,161,10,144,11,168,223,98,129,29,139,16,84,187,250,212,175,250,25,162,10,240,106,239,80,47,44,102,209,99,146,74,76,82,171,130,188,16,85,46,162,134,77,173,69,9,156,112,91,13,248,240,127,60,184,45,190,147,59,71,104,147,170,144,70,160,217,231,222,144,234,107,88,42,207,96,151,127,90,24,216,103,71,199,171,231,104,63,238,106,158,232,136,38,160,40,112,42,214,33,4,98,118,94,221,245,29,244,51,248,11,30,175,11,22,21,41,72,65,2,174,133,174,158,112,5,111,59,101,249,0,143,15,60,183,238,248,108,137,129,43,110,243,239,147,0,145,97,101,47,232,86,186,6,90,41,245,124,23,141,236,184,187,151,86,12,22,106,25,49,176,22,45,33,46,81,99,215,104,50,166,51,39,28,204,80,113,39,179,31,195,66,197,218,236,41,127,207,82,73,222,114,82,109,28,33,190,75,225,140,124,49,34,173,247,207,32,205,229,133,206,188,229,169,66,214,21,42,162,52,224,221,29,203,13,87,212,116,165,204,253,126,100,123,89,210,11,232,198,134,191,157,175,98,227,190,197,203,252,233,215,68,241,36,111,71,205,132,129,179,73,93,178,132,72,140,119,194,42,251,27,238,94,238,210,6,91,101,5,253,212,236,245,75,231,42,174,44,175,244,231,127,159,112,35,67,252,40,199,238,76,88,52,91,28,61,83,230,115,190,123,210,80,215,134,86,191,131,85,70,207,227,157,129,35,106,147,201,116,47,146,108,152,52,131,158,35,242,131,43,52,125,218,47,13,191,202,192,110,74,27,255,88,89,165,54,20,178,67,202,249,74,241,92,208,1,135,53,34,15,224,41,236,48,17,134,99,194,13,242,209,46,93,73,66,88,129,238,211,216,116,150,160,203,60,89,99,234,118,50,194,248,206,115,161,177,186,38,10,86,114,123,108,13,22,223,131,58,128,27,80,49,67,241,133,44,149,172,242,225,241,121,197,52,174,179,137,105,116,223,192,159,155,198,62,158,133,98,5,171,127,46,248,175,157,251,132,131,232,35,127,25,242,111,221,146,7,98,40,193,153,131,144,34,65,51,163,184,115,49,52,125,79,28,57,107,103,136,36,10,195,6,191,82,189,64,121,84,210,25,101,39,160,3,76,141,37,1,65,25,96,97,154,68,249,23,83,4,57,197,221,126,57,190,51,155,117,82,197,209,81,107,136,144,90,180,5,71,94,203,175,136,192,209,29,36,146,125,14,187,117,156,237,176,187,96,206,10,211,208,141,111,29,125,122,68,90,228,26,98,49,126,179,251,180,201,161,119,237,99,107,96,85,103,221,137,1,16,38,254,120,233,128,40,177,110,89,173,145,246,179,81,78,135,62,11,81,229,83,217,39,106,158,164,243,221,239,23,78,158,236,16,179,104,248,149,188,95,131,29,111,213,71,131,57,213,152,217,112,253,19,158,246,195,73,193,20,80,69,98,161,128,220,101,236,216,94,117,7,223,31,155,134,50,78,8,46,247,111,245,68,113,35,94,154,71,195,136,249,173,233,243,143,126,117,172,169,89,8,83,30,3,172,146,47,4,131,207,2,150,22,180,247,106,251,53,77,151,249,67,194,29,59,121,44,235,83,114,245,39,120,124,203,152,129,57,42,7,62,63,179,210,33,224,232,81,45,34,60,94,59,93,182,138,210,251,5,74,147,131,194,208,175,62,127,115,16,213,86,181,86,139,237,46,15,15,0,71,123,36,211,98,110,66,191,34,143,5,104,101,52,167,120,61,33,150,38,69,199,70,133,112,28,122,165,226,132,54,125,247,213,138,109,79,183,217,208,180,118,171,126,97,117,212,32,24,110,199,253,207,199,167,191,207,231,164,92,120,79,233,1,133,95,15,67,38,172,237,107,138,228,108,217,61,151,218,214,110,251,51,230,20,43,210,108,49,213,127,141,214,97,80,54,231,86,167,157,138,127,126,118,151,79,33,234,80,48,121,109,70,103,41,104,5,66,141,11,92,235,29,132,252,8,225,150,3,252,181,136,178,243,53,134,47,190,169,163,195,126,193,66,49,142,95,36,181,47,14,166,134,116,142,145,235,125,184,184,8,127,43,172,171,195,37,128,140,222,117,187,64,87,102,78,113,189,135,81,87,67,52,244,16,248,72,178,35,2,167,179,134,165,121,181,109,20,252,213,158,180,70,232,92,71,55,52,252,66,0,100,129,128,188,71,136,157,45,145,255,199,102,240,222,15,137,145,172,171,199,35,211,28,12,100,241,199,49,213,79,172,155,85,125,83,115,43,111,54,200,193,166,32,193,223,21,22,0,44,159,145,28,193,132,221,244,116,198,105,188,67,203,80,184,131,159,121,37,79,229,211,29,24,220,133,26,249,10,89,145,154,196,174,175,229,60,79,77,5,28,152,2,67,123,52,4,150,7,242,11,126,157,132,4,151,146,155,170,70,245,179,28,184,175,176,125,165,152,139,81,133,181,124,102,176,125,50,250,29,174,9,138,94,234,4,187,154,61,180,129,48,66,161,255,56,89,36,135,135,13,248,33,33,119,120,21,104,136,28,224,87,104,52,197,110,185,63,254,238,107,203,119,161,171,30,183,117,102,225,145,195,22,167,143,59,89,173,133,254,224,102,188,138,193,67,126,104,242,224,240,192,20,97,70,129,183,39,11,168,103,171,56,182,44,129,242,211,23,91,175,47,126,155,22,149,65,111,85,75,99,44,127,215,146,31,64,249,111,98,177,213,57,174,11,130,36,72,165,237,197,182,18,57,101,253,240,11,43,250,26,250,221,39,94,147,96,24,205,136,144,176,108,31,107,166,128,169,121,113,150,174,236,204,147,194,182,41,6,194,214,65,138,170,45,183,188,117,93,210,144,93,154,221,158,47,18,74,54,7,78,86,160,134,31,45,185,57,221,72,197,174,58,126,47,58,97,30,51,26,119,97,164,106,229,55,193,75,181,56,19,253,191,172,131,98,45,84,7,11,186,154,72,193,222,93,149,201,240,170,55,117,74,71,161,197,58,64,139,105,28,54,191,250,102,180,149,7,242,18,67,61,136,238,113,95,195,129,108,67,132,194,29,101,78,46,49,210,131,15,78,42,62,37,77,46,15,63,210,48,9,227,232,58,63,167,64,246,140,115,76,101,46,117,27,2,91,227,21,193,216,24,35,156,179,207,4,109,120,37,64,175,197,246,202,152,200,116,51,181,227,108,160,11,250,19,8,18,139,132,120,188,192,253,245,179,131,4,161,189,238,93,61,237,155,66,95,164,242,187,197,21,201,161,76,77,11,37,11,106,39,120,178,238,224,214,35,216,48,226,253,47,35,110,187,96,181,122,75,182,170,254,202,40,244,11,166,94,193,73,63,137,54,28,228,135,191,44,240,84,32,32,18,193,111,83,155,127,116,179,7,118,72,226,207,220,112,41,179,167,143,142,157,85,27,223,208,154,246,158,55,13,51,102,50,65,72,48,121,66,240,150,15,77,159,131,20,202,119,13,141,197,52,1,201,39,53,23,148,11,45,159,240,128,78,155,159,73,51,93,22,212,88,221,66,121,211,248,5,78,83,212,157,138,210,162,252,166,170,168,104,77,242,58,58,255,247,117,12,153,22,239,195,241,89,165,142,54,231,169,62,236,121,122,255,163,245,208,113,81,166,120,126,238,240,100,178,75,77,43,237,171,209,11,201,55,80,191,138,61,178,175,94,86,171,197,204,27,184,211,12,160,202,20,193,211,229,36,139,130,126,218,203,223,157,10,22,77,117,238,213,53,232,191,190,215,101,193,197,71,45,192,79,84,210,200,233,95,82,75,132,30,203,149,137,160,37,200,175,134,131,210,120,227,217,189,54,224,223,57,163,180,236,62,57,89,177,2,98,223,69,156,95,212,135,121,189,8,56,102,41,224,16,54,188,55,150,28,51,245,233,82,53,85,129,53,143,54,197,119,37,11,88,83,215,25,103,113,83,84,232,35,238,66,78,94,198,190,76,63,22,248,24,221,211,122,92,125,221,217,10,210,121,239,253,148,49,107,236,145,113,210,127,202,26,246,118,5,75,180,108,195,107,213,20,104,81,74,10,250,155,5,88,176,181,107,219,45,243,208,221,123,187,142,245,53,184,210,145,231,188,204,118,56,234,15,112,97,241,152,47,129,85,210,106,229,136,42,54,241,5,115,94,65,148,237,46,33,229,127,103,206,69,42,108,24,31,128,47,223,151,69,26,34,198,255,156,222,3,126,2,55,191,116,254,66,69,49,8,13,88,159,230,90,183,122,209,25,100,110,207,37,95,32,202,221,188,50,59,223,131,208,168,179,118,151,215,159,142,94,23,240,77,26,200,225,26,94,240,232,167,115,243,204,244,54,242,100,246,187,17,109,80,177,215,240,137,125,182,38,180,241,33,169,226,164,3,10,133,232,72,250,163,151,149,196,233,159,88,37,246,8,43,216,209,11,66,104,229,244,25,64,87,26,206,176,19,71,187,189,144,175,201,79,149,95,17,254,109,25,129,250,9,228,1,221,43,12,76,216,150,32,8,23,26,89,199,196,73,133,255,202,93,232,186,181,125,66,223,85,134,106,124,3,124,157,233,88,42,132,81,31,98,85,235,10,33,159,217,1,198,26,250,217,242,90,153,42,217,15,135,144,254,115,97,96,26,0,71,91,148,87,83,161,4,86,46,21,120,209,18,151,147,80,204,129,144,75,48,0,184,175,187,125,103,84,71,193,41,21,1,121,247,20,214,241,116,40,31,166,83,198,232,165,91,23,33,90,84,110,140,85,235,61,50,63,180,151,56,200,77,139,253,17,80,240,174,40,146,179,99,121,158,233,145,72,238,153,235,10,251,102,208,0,14,70,84,61,161,180,190,17,39,113,50,64,206,241,185,0,63,153,129,141,124,114,200,100,205,11,249,162,49,89,9,177,61,203,38,144,33,2,231,6,228,8,157,9,112,166,19,220,10,21,204,23,237,206,187,151,202,228,7,84,104,85,0,150,72,158,213,219,92,123,135,154,181,46,214,213,20,74,171,40,139,205,179,38,57,12,56,154,149,124,171,86,34,63,25,6,196,102,190,252,135,169,0,29,68,48,82,107,151,146,7,53,215,254,189,40,254,84,35,45,255,133,167,185,166,50,58,190,73,149,149,129,31,220,141,135,229,76,160,176,41,167,76,146,45,55,67,159,128,116,73,43,247,96,30,130,171,90,207,127,47,114,71,118,229,38,81,109,18,12,129,116,117,74,3,26,217,6,82,126,251,13,255,101,191,162,116,122,148,20,142,122,195,218,77,72,106,246,200,93,143,229,83,88,37,78,40,84,65,52,99,111,178,209,212,198,219,168,22,251,63,250,23,43,205,186,62,162,32,178,223,49,130,53,114,30,105,161,154,90,176,39,84,118,235,61,201,184,136,17,127,154,119,69,173,25,207,221,3,246,151,9,104,14,221,253,30,47,89,85,143,22,19,106,203,200,71,207,30,106,88,219,129,93,44,118,230,28,206,124,30,214,254,215,223,149,214,59,221,201,3,244,82,10,231,111,59,156,16,145,226,30,125,166,207,79,5,47,133,6,97,234,184,214,128,187,39,189,46,11,218,253,71,106,245,89,85,79,221,255,203,24,234,235,155,122,158,250,88,114,222,82,216,16,69,61,83,232,179,24,54,151,238,233,18,112,238,201,158,89,185,229,161,175,165,146,135,123,137,174,50,155,120,76,122,172,72,120,4,204,84,162,142,177,147,50,209,51,49,80,100,77,64,111,206,210,17,217,230,13,5,43,182,34,74,197,97,10,128,238,174,174,111,217,215,242,251,221,142,184,168,32,165,186,231,31,225,178,128,161,9,152,220,21,19,144,82,243,184,48,169,98,131,196,85,201,165,187,148,84,216,84,60,253,227,67,169,89,175,91,23,28,122,161,100,26,185,13,25,91,19,116,234,163,47,112,244,96,195,4,101,131,178,12,157,191,107,105,246,79,80,52,236,126,85,230,75,251,250,243,195,214,193,0,211,246,127,2,137,126,149,193,235,190,9,16,97,132,159,24,28,155,192,248,101,63,248,117,0,19,217,116,200,221,239,244,7,50,218,228,86,177,115,203,158,102,215,149,20,112,64,195,95,69,237,241,15,16,74,230,106,219,232,63,41,92,17,209,244,146,4,35,229,32,236,194,35,174,176,237,206,255,91,36,30,175,242,149,103,13,207,120,253,200,230,13,20,106,239,98,8,24,225,75,77,152,30,255,59,105,205,53,254,69,233,92,92,74,251,168,172,199,211,204,64,77,161,65,192,12,159,88,114,155,221,205,87,173,139,199,59,74,230,131,236,71,39,112,93,120,18,233,86,242,22,223,226,119,249,15,22,21,48,207,94,71,94,162,221,68,62,197,199,192,38,220,39,29,87,19,66,217,83,199,166,78,186,205,168,116,35,55,223,235,24,208,248,25,247,162,99,205,114,150,97,98,169,66,29,31,186,245,89,59,8,93,203,1,146,58,187,246,138,182,254,53,240,197,138,205,178,43,251,40,142,161,69,248,31,168,105,31,69,121,135,105,205,132,237,6,21,106,34,196,165,70,179,107,93,36,37,62,240,29,18,180,237,164,42,93,53,77,217,165,242,222,200,35,205,201,128,167,185,101,196,56,210,63,123,90,162,164,76,49,73,67,138,29,176,237,187,50,246,14,83,105,207,218,250,79,8,73,87,72,114,6,146,63,148,93,65,184,76,188,49,124,176,242,148,224,119,251,83,22,168,4,242,112,253,29,160,21,222,247,115,174,50,158,188,56,233,225,254,208,205,24,225,227,45,1,209,151,211,53,189,26,116,76,0,239,38,196,109,69,17,237,248,81,90,148,10,99,53,219,134,145,116,51,227,68,207,68,228,25,36,6,149,174,154,7,123,105,47,76,58,215,31,117,181,199,111,60,229,124,229,206,212,49,126,49,211,173,47,162,74,233,195,70,251,130,177,182,107,189,249,204,138,243,76,9,55,153,10,19,62,131,82,134,139,251,78,182,144,63,217,207,36,172,30,134,194,185,225,20,248,18,191,190,121,183,138,217,205,143,241,63,71,118,174,176,156,126,234,153,177,107,221,218,136,151,34,36,44,115,254,164,23,84,114,59,239,154,182,255,194,161,78,4,112,107,72,246,2,244,55,194,197,34,48,185,236,10,249,32,245,112,61,64,96,137,39,230,240,145,226,125,130,250,4,178,253,105,31,44,121,160,64,65,137,20,102,184,245,24,8,19,228,87,245,241,248,188,95,98,114,47,243,92,195,200,19,23,100,104,121,227,167,35,236,237,172,70,75,63,110,173,38,93,168,253,3,150,127,69,170,63,80,158,238,185,13,113,40,173,64,96,200,99,248,193,222,45,213,168,153,32,66,147,237,243,217,181,40,62,252,130,240,92,174,134,149,199,30,193,186,172,202,198,213,120,235,81,129,238,30,248,5,189,111,98,235,240,79,149,21,195,15,54,82,77,238,233,224,106,61,129,77,223,18,109,200,1,239,184,209,203,165,142,26,204,192,190,188,232,5,193,222,4,160,217,131,222,191,5,240,135,182,169,73,25,161,204,128,24,210,142,87,10,103,95,171,178,85,77,12,91,94,145,157,133,100,178,244,41,37,135,208,21,52,26,154,144,225,221,12,224,207,154,229,85,237,95,109,252,90,11,206,141,108,139,24,241,191,137,240,0,97,52,126,197,35,186,165,80,75,190,96,57,186,203,196,99,105,182,137,251,93,5,81,33,253,219,42,96,198,254,234,187,146,199,99,63,103,214,57,250,166,142,250,231,187,73,63,198,186,99,138,46,236,107,246,42,119,88,70,248,252,36,188,79,232,38,89,133,86,214,226,16,147,55,26,81,97,173,41,137,159,168,8,67,43,52,50,118,235,53,87,248,243,29,180,66,67,59,204,175,19,169,79,129,205,74,107,178,141,0,122,77,1,111,66,240,240,215,111,217,205,78,196,153,230,35,76,195,237,22,217,232,100,170,113,193,144,195,188,16,249,23,173,168,171,211,138,18,217,102,154,168,115,154,246,156,66,208,109,184,84,103,115,97,83,239,244,163,162,181,27,181,93,95,232,142,60,24,58,222,211,179,136,19,166,11,177,199,20,238,178,9,225,250,119,211,34,116,164,129,243,68,93,242,159,176,230,122,133,75,4,141,55,68,205,154,177,224,246,147,116,116,113,128,28,42,8,130,70,236,72,86,25,50,105,67,163,51,222,227,123,22,96,178,195,206,169,112,58,229,76,108,19,222,94,64,149,163,109,187,233,183,143,178,33,225,97,165,95,104,117,247,200,241,31,46,124,102,130,233,16,225,234,121,209,1,66,186,21,104,111,176,131,116,129,133,132,184,5,4,39,197,145,97,139,7,96,209,202,4,122,70,226,46,86,158,213,86,158,119,253,5,60,217,48,225,126,51,236,24,128,231,16,72,11,186,144,239,186,146,221,177,242,160,173,142,53,198,253,226,51,118,36,182,195,139,38,38,152,9,195,32,217,90,18,118,50,68,229,189,169,74,147,98,191,180,5,69,119,225,158,91,252,141,122,53,191,250,4,116,171,152,83,126,123,85,28,114,64,211,41,83,233,102,216,24,19,78,66,159,163,254,127,115,10,205,224,109,210,196,206,163,237,208,76,16,75,218,97,107,43,54,49,99,156,232,110,171,163,141,34,180,135,21,62,234,182,189,47,102,82,79,192,94,49,175,83,154,79,236,178,173,12,100,115,38,192,41,124,180,220,120,33,68,40,103,34,91,102,196,158,6,60,108,1,231,124,122,227,59,222,131,14,74,213,184,8,9,239,78,230,108,210,100,216,116,54,208,236,84,2,201,116,81,26,150,79,149,43,57,253,16,193,236,84,227,239,140,149,206,9,162,239,186,220,145,171,122,45,11,175,185,125,223,151,35,49,96,84,175,9,36,147,100,200,218,64,219,228,186,127,106,39,232,0,180,62,254,65,112,1,117,150,74,196,168,141,53,193,65,102,91,254,36,133,157,153,25,152,158,200,55,180,7,77,162,120,166,110,5,242,9,11,180,237,60,239,36,203,14,108,185,182,101,49,236,167,16,50,14,123,89,138,88,55,88,99,172,49,166,103,215,67,143,50,152,249,36,233,32,149,152,47,86,181,36,116,21,179,125,20,42,238,133,71,236,223,103,235,82,155,154,234,37,210,74,220,122,8,4,252,113,162,234,235,99,48,90,63,236,240,127,83,187,196,105,216,123,148,133,57,222,198,202,146,46,81,147,175,205,7,58,111,249,183,134,251,68,138,47,33,195,168,93,15,46,144,135,118,53,45,97,39,21,188,65,255,155,186,34,233,201,227,225,188,173,252,77,57,42,129,76,186,49,103,113,58,126,148,59,162,41,14,162,231,59,147,29,15,237,49,97,29,66,75,136,61,123,60,19,204,202,14,237,119,135,123,190,149,220,249,115,6,211,158,73,162,142,17,63,184,171,225,190,119,236,24,181,222,171,189,172,204,202,238,171,200,245,131,226,50,6,221,0,211,235,45,76,159,90,245,174,245,62,157,32,114,65,46,135,13,65,185,104,4,7,219,125,21,32,93,204,146,115,28,106,249,40,57,252,96,36,181,200,209,41,126,127,179,83,39,93,102,186,106,180,242,143,172,43,81,85,44,140,100,102,208,32,204,226,69,159,30,60,222,28,39,94,204,138,238,173,229,203,42,52,127,233,47,133,208,80,12,216,134,144,178,64,81,74,239,200,57,173,144,230,160,6,167,26,69,176,13,188,10,8,130,242,159,38,59,172,231,226,104,254,88,247,201,98,25,52,200,249,44,43,196,94,218,175,246,64,175,26,87,172,178,60,103,103,254,123,172,165,118,245,145,201,146,231,160,12,57,50,122,40,192,55,126,253,158,77,144,28,120,174,25,40,196,211,172,155,175,246,7,136,216,142,163,183,146,117,5,239,114,58,68,114,133,96,93,90,178,126,40,224,128,236,39,222,131,142,74,71,122,123,115,43,168,100,86,78,57,167,242,194,234,78,179,147,185,139,94,107,53,183,171,200,136,180,223,90,20,34,3,55,211,215,82,249,151,227,169,233,254,66,98,165,89,100,206,54,231,175,90,69,119,79,133,49,67,176,245,143,226,113,101,8,207,127,200,129,12,111,112,176,15,95,236,113,87,214,120,161,37,178,69,236,56,248,16,78,36,30,120,173,226,162,170,95,174,62,117,181,61,237,245,208,254,174,37,78,55,151,48,160,110,80,140,171,90,22,208,4,118,123,2,55,228,134,222,227,190,2,123,67,31,173,198,187,114,241,80,80,46,146,189,37,215,205,231,186,148,139,217,179,222,116,160,32,64,62,244,101,98,231,128,217,84,74,255,193,121,225,19,46,108,71,186,30,246,77,200,246,79,24,146,199,63,35,46,206,224,62,66,100,35,228,62,202,89,96,136,117,211,96,0,93,40,170,95,181,220,125,214,220,161,250,194,149,144,247,213,238,228,43,222,94,134,142,36,128,254,179,165,170,35,97,127,189,126,158,177,241,95,16,248,202,9,128,200,100,25,63,85,28,2,245,79,143,104,76,27,224,147,170,166,155,19,32,3,14,174,101,13,228,229,65,184,73,111,209,176,160,60,234,194,86,21,145,74,104,172,65,219,207,2,192,105,54,127,65,123,57,25,89,218,12,31,159,60,160,89,14,173,180,172,87,203,154,132,33,163,237,252,121,76,250,144,82,86,41,206,220,119,241,206,204,44,249,69,128,115,121,170,39,252,175,72,162,167,91,75,241,181,110,94,212,126,177,250,235,125,116,124,234,211,134,118,88,81,246,17,136,62,168,58,139,8,171,206,238,37,41,86,154,86,1,31,82,71,21,121,89,162,194,8,208,27,213,41,109,58,223,117,225,246,27,32,193,163,229,93,232,194,184,220,37,112,182,157,178,9,16,55,209,19,206,54,45,98,225,65,146,41,123,69,126,195,122,35,254,14,229,245,141,42,23,209,209,123,161,183,169,62,37,167,71,9,174,1,88,105,244,135,188,188,210,118,8,211,122,172,124,113,229,40,156,132,33,184,126,59,218,169,66,154,61,2,232,168,9,30,230,193,200,143,142,102,25,149,150,49,132,136,29,234,112,10,140,3,92,241,22,57,25,235,97,26,9,105,226,47,187,246,61,9,75,139,2,80,83,30,11,254,187,139,137,153,13,46,237,34,80,172,148,28,201,174,114,160,255,187,60,109,181,53,109,67,0,71,38,32,90,80,65,139,101,189,6,33,46,204,98,40,29,113,7,162,108,39,0,255,186,77,171,212,211,179,42,161,185,106,236,25,248,170,219,115,212,241,113,120,206,232,25,1,119,158,173,166,111,15,175,52,194,175,22,36,112,185,237,83,238,6,156,176,128,218,50,127,131,7,239,168,148,136,206,40,101,122,19,148,97,159,74,43,152,135,74,99,218,236,208,142,133,179,6,117,13,233,84,241,145,6,21,110,71,22,112,48,126,107,208,185,20,106,83,198,58,147,20,53,39,251,155,132,217,39,45,245,41,123,53,86,35,250,149,213,58,96,175,100,77,82,255,229,246,139,196,111,26,90,57,165,143,189,125,0,41,192,35,224,164,129,90,159,240,211,120,236,211,166,168,67,21,83,59,141,28,50,167,199,33,223,254,166,132,137,157,51,82,38,142,178,39,243,168,14,17,108,10,186,96,1,99,179,214,81,62,114,48,37,35,8,43,40,191,102,72,135,67,204,226,84,254,1,19,72,254,122,53,89,76,73,248,252,89,66,123,147,56,24,216,200,24,142,163,226,251,184,172,207,237,124,75,193,64,27,245,219,48,75,73,112,17,71,62,33,243,143,24,205,244,142,180,138,5,172,21,242,139,246,216,50,100,234,185,11,115,231,157,171,220,233,28,192,17,145,52,1,199,189,223,182,204,106,170,60,229,243,205,51,146,179,148,26,160,228,240,244,138,123,251,108,178,71,123,51,112,22,115,31,105,177,188,82,78,117,237,169,33,211,167,53,42,179,25,37,51,164,71,137,56,228,88,85,45,178,175,246,114,157,219,142,137,241,155,55,132,21,47,106,191,196,141,220,147,150,233,190,156,33,146,111,136,138,104,7,185,52,29,221,16,220,182,113,154,210,254,172,134,125,244,160,34,118,230,96,196,92,222,180,97,236,178,147,255,175,182,97,4,180,149,32,110,235,96,204,237,136,142,7,237,179,237,150,42,19,39,18,186,100,247,70,28,250,180,75,165,86,41,153,90,243,15,108,192,120,21,63,100,19,109,125,219,186,166,52,254,106,215,149,144,161,42,162,173,118,102,20,44,188,216,28,147,206,130,29,80,100,193,174,107,28,77,244,54,233,8,129,77,10,187,17,208,235,252,126,188,19,86,101,53,18,90,242,110,45,227,87,161,35,253,143,198,98,108,218,92,49,238,85,68,5,72,225,222,60,28,159,99,19,108,251,244,100,120,168,42,101,211,125,64,13,101,140,104,216,175,1,170,232,60,159,234,82,192,66,31,42,147,246,116,111,186,179,26,91,203,223,107,120,119,145,140,65,40,59,86,173,239,238,177,85,37,99,77,100,8,195,161,63,220,214,186,68,126,41,190,45,54,194,71,187,10,156,101,198,208,53,97,224,163,94,110,59,237,21,154,212,212,228,122,95,123,193,207,5,30,191,39,203,181,239,80,88,106,16,254,233,61,92,48,6,171,226,106,112,165,28,180,213,219,121,214,222,136,36,67,32,127,149,169,157,230,62,7,160,103,4,110,127,27,42,240,115,144,180,105,181,133,72,39,84,12,252,3,190,159,104,202,101,43,29,240,241,7,230,38,197,219,118,148,60,28,140,130,238,243,185,65,60,94,70,87,227,30,181,179,184,69,31,62,68,81,155,206,69,156,45,215,117,118,59,126,246,183,5,37,32,245,74,239,171,197,166,84,65,76,138,109,34,52,150,181,24,3,174,218,22,23,12,110,228,201,70,187,225,150,1,6,86,182,183,15,199,106,145,158,106,116,246,168,151,234,234,203,229,107,146,125,56,141,25,149,179,33,181,63,52,178,126,53,105,153,15,237,221,113,169,143,100,118,242,107,53,236,45,77,7,26,7,253,13,29,221,177,212,147,192,16,114,218,59,79,92,155,65,46,101,195,224,75,51,192,82,71,121,137,26,41,253,81,92,164,230,134,97,243,175,178,49,81,233,92,233,24,60,142,173,191,46,240,161,192,85,249,22,197,114,162,210,74,60,123,151,41,146,232,8,184,206,252,183,118,204,31,207,255,198,130,215,171,225,2,183,177,153,248,157,80,112,7,233,190,233,99,177,9,25,231,17,64,198,43,111,2,88,207,53,188,179,21,198,162,172,131,161,202,149,41,253,54,17,238,7,69,71,74,141,18,68,93,104,47,229,6,54,222,115,3,60,79,61,232,19,34,144,146,133,230,78,137,53,13,243,218,194,105,1,109,4,252,203,166,73,65,244,103,121,172,205,38,244,134,212,204,147,35,195,159,95,231,147,246,122,138,210,131,97,252,42,151,18,29,132,67,107,116,104,113,60,56,77,157,185,34,208,170,243,57,237,57,244,24,14,14,135,162,53,83,184,179,228,194,237,38,174,185,221,30,137,118,62,177,184,96,238,152,143,57,244,186,52,133,230,213,37,17,141,46,167,33,84,215,225,189,204,0,56,251,169,64,52,191,17,165,175,166,238,116,192,31,18,114,191,173,168,91,7,131,96,104,172,96,179,234,53,129,248,145,46,180,13,160,43,24,167,70,9,246,217,236,177,67,138,162,209,106,128,221,73,65,248,79,47,59,62,160,28,164,119,23,152,48,204,185,180,41,88,139,169,190,67,249,179,37,68,164,17,145,37,88,208,130,22,140,16,174,123,123,204,160,242,109,246,81,22,146,220,235,236,90,135,128,217,51,214,48,148,185,255,164,45,93,55,9,54,24,196,251,52,30,49,242,22,98,221,85,41,177,161,156,243,208,67,160,59,135,40,109,10,123,124,106,195,34,70,88,210,109,77,46,117,190,212,244,132,215,111,100,95,178,23,87,172,208,54,236,128,42,93,121,44,205,12,185,165,52,167,116,186,127,0,155,213,11,95,29,62,177,199,85,221,144,61,147,227,104,4,175,231,14,237,170,204,171,225,149,251,232,145,118,62,155,24,134,198,50,110,75,234,109,142,254,29,11,177,112,72,216,171,100,76,166,34,81,118,145,244,18,45,186,98,189,72,109,104,172,83,31,184,135,109,23,61,34,234,214,253,167,108,67,237,123,210,253,202,205,227,53,249,107,51,91,108,190,254,125,215,179,143,174,216,138,117,131,175,131,190,54,253,151,197,200,87,240,77,78,247,209,126,190,113,96,93,30,10,150,64,7,142,91,38,57,24,128,178,125,2,223,165,151,21,211,95,57,53,123,166,205,115,74,41,194,218,123,31,219,54,181,106,98,160,118,205,188,45,181,160,223,225,215,89,119,119,181,56,145,78,6,246,75,170,52,27,152,255,0,213,82,229,106,251,95,89,163,189,186,158,149,148,206,15,40,173,39,233,217,80,236,27,216,246,29,100,195,30,217,173,168,199,4,250,121,181,15,214,91,0,140,173,134,84,123,21,70,148,145,77,245,202,7,125,124,204,23,144,187,213,47,52,62,253,29,218,106,209,178,215,30,100,82,38,58,22,45,244,171,150,0,248,84,132,223,42,181,25,149,218,91,2,95,228,131,34,76,54,97,116,233,127,221,6,86,182,182,206,197,220,34,217,61,177,123,28,248,139,230,50,187,237,205,162,166,154,89,123,94,110,240,154,139,228,229,97,244,58,238,129,198,148,112,35,39,10,241,223,219,130,237,66,52,105,133,149,237,47,158,237,57,234,105,204,22,21,236,100,110,97,17,131,56,141,199,229,168,180,56,49,158,245,176,193,101,152,139,234,113,101,74,110,220,174,176,73,199,47,32,177,174,227,104,167,161,209,139,176,169,123,156,194,8,156,14,45,152,102,128,55,73,217,33,169,231,27,0,2,215,187,243,234,31,193,63,248,177,202,128,198,3,128,35,223,119,222,25,205,60,117,201,119,55,205,179,116,103,104,130,148,79,222,173,95,87,176,79,241,136,0,167,13,64,124,182,112,3,32,23,112,165,24,213,36,211,118,4,31,73,90,133,165,110,64,93,53,135,28,195,124,139,117,114,8,187,56,114,171,116,160,173,120,192,63,191,192,229,100,245,22,186,107,115,18,209,188,15,212,14,52,106,210,69,143,60,165,25,23,61,88,251,163,29,171,198,192,5,147,50,144,95,229,85,90,140,138,31,202,179,149,71,255,160,167,34,39,16,31,96,236,241,174,243,8,67,132,220,201,210,237,49,67,12,132,166,113,24,142,41,32,97,111,59,24,252,187,72,48,210,18,64,244,6,65,145,207,200,110,155,115,215,118,46,47,118,113,159,232,144,210,63,140,214,72,82,197,103,100,146,147,197,115,112,237,124,215,140,233,162,93,226,105,77,150,112,148,57,43,3,113,243,212,9,232,67,219,56,237,129,178,107,38,234,55,94,27,50,147,43,56,248,198,33,214,240,122,137,137,19,55,173,201,153,109,225,243,234,230,253,13,17,238,29,60,45,22,56,164,25,94,206,167,164,25,91,182,89,21,190,105,247,32,52,221,54,216,32,230,160,250,178,204,199,161,146,45,60,151,189,153,253,59,105,174,24,30,37,191,107,104,45,226,128,18,176,204,19,10,244,13,92,177,207,224,167,16,191,16,19,74,91,202,194,181,120,208,43,48,155,248,141,100,59,138,56,177,122,30,44,71,144,243,237,136,190,50,232,93,7,239,169,70,139,7,69,175,246,244,83,111,4,53,110,152,35,241,28,95,244,34,39,51,130,191,33,111,172,176,35,219,27,189,30,193,222,242,91,173,77,146,59,189,177,41,186,178,86,130,155,38,227,219,40,37,153,88,183,183,204,120,38,78,40,64,229,111,230,198,243,123,234,152,146,158,216,16,234,5,113,243,79,18,74,94,146,199,85,25,228,196,207,171,37,134,70,160,76,213,103,87,121,24,90,193,175,239,107,218,167,204,140,210,246,31,47,35,143,188,82,203,169,34,141,170,53,28,104,110,156,132,57,146,24,253,87,136,56,83,115,152,72,245,252,218,66,111,241,229,109,72,182,102,103,189,143,149,88,210,131,210,148,234,166,174,246,246,235,236,39,40,221,26,251,6,169,16,6,112,229,216,152,21,184,92,108,155,192,35,16,164,47,117,1,87,215,65,99,20,32,136,124,181,60,112,26,85,169,242,177,25,250,195,167,75,19,30,208,137,252,88,77,150,196,209,67,9,54,46,78,71,203,67,49,182,219,85,3,66,240,200,188,196,33,52,97,201,68,84,163,131,90,86,156,144,213,31,232,15,118,182,70,219,143,138,201,30,34,22,10,202,144,151,241,34,241,206,63,224,198,217,192,184,247,77,163,48,211,75,31,63,6,104,176,203,200,157,58,160,60,74,131,57,115,31,142,85,67,95,148,120,177,54,242,226,67,53,117,104,253,253,96,182,3,237,101,84,39,108,244,201,105,21,231,243,173,242,186,212,238,73,92,181,230,68,35,96,172,176,232,209,134,32,202,87,80,68,187,207,49,198,149,102,212,27,182,97,117,173,103,223,5,55,175,190,231,100,123,25,211,80,201,187,172,145,97,126,55,61,102,171,102,79,64,5,77,127,140,196,98,193,109,191,87,50,223,113,236,100,206,171,227,161,134,146,212,178,202,110,110,146,138,137,138,30,216,30,81,88,219,46,233,116,127,3,121,166,134,195,50,223,23,0,58,68,89,192,80,150,49,49,111,240,98,55,225,206,230,198,10,28,76,165,34,5,73,37,176,183,21,83,247,107,217,121,210,72,218,221,239,11,18,232,155,245,2,228,155,66,234,91,10,33,61,145,25,90,110,242,113,129,69,234,78,100,33,205,102,193,81,254,132,72,21,252,87,74,226,204,49,179,203,46,86,233,147,205,99,77,251,250,251,151,214,28,217,102,156,17,38,252,120,70,39,76,85,128,79,226,252,11,53,215,207,38,173,218,73,244,157,133,248,5,230,5,122,202,144,87,229,223,234,18,117,130,10,146,58,246,41,151,110,168,146,145,243,255,196,58,9,211,13,10,231,205,246,207,219,216,83,192,245,87,246,185,101,153,35,177,179,181,55,148,98,40,129,21,122,23,5,110,125,136,107,136,201,123,36,241,1,86,158,123,166,174,96,245,196,93,19,55,232,117,45,46,86,210,68,231,16,0,170,17,236,147,193,146,17,218,89,108,159,18,156,198,207,198,125,48,162,214,45,149,162,54,181,157,120,49,95,2,212,223,36,169,109,223,29,166,132,19,232,118,21,162,152,193,162,108,160,213,133,196,242,61,181,146,230,204,72,81,76,5,12,239,156,167,80,115,248,27,28,14,114,202,187,99,239,139,186,25,224,164,66,87,4,182,222,169,216,155,190,244,247,146,200,143,254,231,156,238,121,63,170,96,237,157,66,246,180,251,93,0,251,107,38,4,212,222,27,154,92,197,198,41,193,53,220,84,74,206,222,233,98,174,77,176,94,128,23,235,216,89,38,148,32,23,61,204,77,43,93,33,69,170,37,237,23,195,190,242,59,252,98,237,156,25,33,190,47,54,124,30,250,217,220,98,128,93,34,158,161,55,90,123,103,206,236,95,119,109,109,9,42,167,28,103,44,177,152,81,50,61,166,26,142,39,229,3,222,236,115,247,29,93,37,24,143,113,152,248,230,164,42,83,151,227,129,127,1,186,48,229,230,70,24,106,60,114,191,246,35,74,220,175,235,199,6,16,11,207,153,5,16,211,251,15,147,9,123,89,54,90,205,67,219,27,35,67,132,27,226,206,134,120,241,26,251,192,149,9,127,65,149,252,187,156,17,188,10,16,163,36,73,130,92,180,28,85,9,254,14,36,206,15,118,130,111,120,117,87,149,1,174,183,160,37,50,94,101,236,60,142,124,65,198,254,235,164,168,246,100,225,118,153,15,116,253,10,53,250,35,141,49,19,29,218,8,29,167,242,55,64,187,6,236,97,75,6,32,103,58,39,6,94,27,64,201,125,159,35,49,106,200,16,90,154,235,177,125,112,213,75,78,44,45,23,118,46,66,30,160,54,166,83,18,193,156,237,172,193,139,105,189,146,106,15,50,146,158,50,169,136,83,69,202,19,253,230,2,233,0,33,140,251,125,159,165,104,14,246,73,120,123,198,76,82,146,70,11,118,247,247,208,195,211,121,185,195,125,8,120,218,29,235,128,253,97,202,44,30,81,50,72,47,52,194,55,222,128,8,19,18,86,115,9,250,132,154,195,151,149,38,110,171,199,255,15,105,167,163,104,225,190,194,246,48,116,248,241,173,7,183,5,42,110,231,148,75,98,247,144,218,13,74,74,89,212,9,137,190,1,50,10,65,102,186,9,253,184,23,85,188,48,204,50,173,233,20,238,121,34,35,184,170,47,35,145,105,194,239,123,198,167,118,120,65,62,103,98,174,26,25,0,79,145,36,117,239,166,207,144,61,111,50,178,41,162,41,116,186,76,76,34,134,173,98,17,14,151,141,102,135,4,17,204,219,154,29,166,92,157,254,53,225,137,128,65,152,58,239,9,185,86,122,42,144,170,60,83,86,173,154,178,226,222,194,42,197,130,215,104,127,191,14,24,214,58,249,75,92,101,24,212,143,103,56,73,242,46,223,48,93,176,246,249,129,56,157,26,37,124,223,23,168,187,169,187,251,140,176,149,57,1,140,204,152,90,7,5,93,72,151,247,102,194,42,135,105,65,19,56,112,10,112,212,166,252,132,69,121,109,80,102,215,90,147,158,66,235,231,153,245,161,56,234,91,146,96,53,231,159,71,174,237,141,68,51,36,228,35,208,98,104,211,168,77,104,113,176,36,87,205,65,190,165,38,58,33,111,9,155,5,205,196,85,237,112,127,207,28,207,2,6,96,27,159,93,42,47,46,24,178,34,99,209,183,206,94,104,187,89,46,109,18,149,66,23,58,27,70,217,243,35,77,36,131,111,194,254,40,66,151,188,15,148,219,139,9,95,178,133,11,252,197,186,19,16,82,176,239,77,71,47,17,120,72,254,241,152,160,97,73,53,238,167,184,24,247,112,43,122,12,184,35,34,42,38,92,125,152,255,251,99,88,160,82,223,45,225,230,204,28,208,104,24,76,246,161,221,164,104,8,133,203,252,4,80,123,212,18,162,240,248,138,202,127,106,176,168,46,133,13,67,224,222,99,244,181,252,211,195,215,212,205,58,173,140,89,13,38,132,63,44,59,237,44,24,53,90,55,16,69,101,48,35,100,78,25,196,37,67,217,243,198,36,237,209,216,139,230,33,238,47,199,35,196,227,183,157,207,151,78,234,176,234,253,248,252,7,207,102,226,248,94,40,220,62,254,227,132,38,99,95,167,36,184,116,146,229,162,109,97,35,196,69,180,45,182,72,208,52,229,110,115,0,145,215,204,186,150,125,48,21,102,6,211,174,235,61,146,44,127,0,79,96,116,200,219,155,247,210,174,10,245,51,116,198,213,34,175,14,176,73,44,5,200,156,109,178,29,80,231,31,33,95,242,91,244,33,137,48,221,132,173,43,98,1,121,192,189,239,52,236,232,134,105,22,200,185,95,183,39,198,102,46,219,219,96,177,23,77,186,27,79,34,28,44,140,169,58,164,64,161,184,23,200,0,4,148,137,196,96,120,233,242,235,141,116,18,118,191,82,171,18,71,29,59,105,165,12,193,0,122,142,5,241,191,151,2,176,83,169,205,10,186,44,245,207,133,241,203,185,90,75,204,217,255,148,194,248,196,22,45,147,97,255,125,64,59,33,35,218,171,29,228,63,233,48,4,45,183,179,177,144,167,199,101,105,253,209,135,87,119,197,121,46,76,101,38,82,161,176,38,190,160,29,196,75,157,228,202,203,111,36,114,223,228,10,55,6,197,206,155,167,153,126,43,102,171,103,156,0,174,210,12,56,124,115,99,191,184,226,92,225,246,192,83,51,213,42,167,162,18,77,243,190,50,117,185,220,237,252,100,230,128,134,147,153,135,60,90,14,25,131,100,60,68,218,186,203,84,252,88,175,59,131,221,140,3,193,86,47,33,188,167,155,179,201,74,14,230,141,157,201,245,222,75,93,79,64,145,49,97,192,176,248,250,153,39,213,79,162,78,158,108,234,192,252,230,172,125,189,237,231,220,58,56,121,197,45,10,121,162,108,35,3,190,92,47,96,95,21,237,248,3,251,53,164,35,107,241,42,55,231,115,114,205,117,254,18,22,43,84,51,114,192,71,156,223,243,114,232,97,69,88,104,56,5,251,46,190,237,2,89,238,1,151,56,9,252,208,197,74,210,49,43,226,233,245,101,241,218,11,208,142,212,219,229,229,74,31,241,255,34,114,40,104,93,86,37,146,164,185,15,208,222,231,91,103,152,135,112,236,33,110,113,187,135,241,37,79,125,114,80,176,163,215,45,89,49,48,210,233,139,165,130,175,28,206,252,230,30,112,65,104,32,91,195,103,42,251,94,63,215,224,39,105,211,138,105,115,82,30,10,206,182,147,204,41,161,97,98,161,200,205,2,4,24,49,115,84,184,55,34,165,15,77,150,159,41,15,59,180,44,131,247,211,140,27,86,197,168,119,182,236,48,235,120,74,215,93,102,177,4,50,209,87,51,34,176,190,69,16,175,15,190,27,205,128,51,23,133,23,128,79,57,108,234,60,224,15,94,177,238,246,141,77,159,245,42,231,205,86,227,174,80,236,136,29,255,1,18,189,103,59,196,4,165,113,154,107,55,61,27,92,84,94,136,135,90,10,246,141,160,118,227,175,232,26,95,160,17,97,20,78,61,188,34,155,198,95,2,48,202,14,135,211,204,148,226,130,101,43,120,90,124,234,167,210,127,147,183,21,128,3,62,233,195,101,148,41,28,188,108,165,222,253,5,133,200,163,55,88,200,165,89,6,189,36,106,225,82,207,254,243,184,6,186,82,44,192,199,12,233,65,86,101,19,172,24,226,131,195,196,173,67,101,3,254,21,52,39,203,135,83,233,45,79,233,223,119,231,17,157,183,102,121,188,200,108,101,73,14,204,243,99,110,107,94,229,1,159,204,12,106,22,169,157,10,3,185,137,218,213,144,150,55,173,126,82,196,112,63,123,227,252,85,89,115,142,112,100,70,120,106,184,15,68,166,90,142,250,37,31,91,71,244,213,226,16,35,92,8,7,189,74,126,196,92,147,74,10,48,161,2,36,210,95,159,143,111,177,35,167,212,142,30,48,40,10,124,48,143,201,113,164,217,183,73,139,65,60,6,26,107,66,232,4,105,123,38,113,242,156,161,201,39,108,193,2,73,214,237,218,90,39,28,187,53,137,165,58,0,199,107,213,126,225,16,210,20,133,206,93,148,140,196,49,108,235,106,165,105,84,193,194,186,15,226,194,197,123,210,19,156,213,138,28,76,168,26,24,88,17,28,177,51,130,177,31,140,78,56,5,125,153,64,11,218,89,119,116,20,45,95,32,246,24,205,235,106,201,139,63,129,132,54,150,78,48,201,133,106,94,164,225,215,151,83,10,115,11,119,76,99,211,172,72,245,208,180,110,251,206,247,148,134,27,65,218,30,144,236,53,23,93,1,221,186,199,151,58,42,48,132,98,241,210,222,185,69,202,18,241,23,122,52,73,147,59,240,57,76,107,228,46,119,135,101,33,249,23,37,146,153,78,199,173,30,196,57,74,180,7,255,191,182,164,137,138,201,61,95,216,99,157,35,88,153,102,151,102,198,76,29,196,230,190,11,107,230,3,81,218,178,194,162,97,136,193,50,48,171,219,52,158,106,168,76,207,43,125,238,130,75,154,47,176,76,106,68,122,242,136,167,167,51,62,160,32,15,46,168,213,93,111,13,152,36,16,185,71,42,37,9,216,82,102,118,102,147,52,18,253,83,240,108,73,109,86,107,207,141,254,142,49,82,45,0,69,37,225,48,228,86,78,52,29,55,205,46,64,124,89,161,125,12,214,224,27,28,162,136,73,97,112,157,199,153,202,160,108,50,127,27,224,3,177,181,17,171,103,237,188,238,44,36,7,232,17,90,205,243,122,234,30,9,76,7,232,20,168,18,8,216,177,19,60,226,116,13,70,200,132,105,67,82,1,20,216,6,156,4,104,239,78,99,78,19,211,102,205,255,5,125,123,223,140,88,174,91,42,125,238,13,150,243,158,228,242,255,137,30,25,237,107,230,79,70,236,30,186,44,83,46,124,54,215,94,144,34,155,2,109,65,251,228,199,201,13,91,10,138,16,255,75,204,234,99,174,159,51,173,81,210,112,51,242,105,111,112,173,46,36,153,194,203,123,112,139,228,204,133,41,219,161,79,29,65,249,130,130,200,85,127,23,122,10,225,250,247,248,214,126,77,214,254,215,149,181,162,106,145,106,102,202,13,56,183,166,163,88,82,137,249,127,131,77,137,159,10,22,66,61,46,119,251,102,182,254,182,101,19,67,230,85,3,221,173,10,180,241,86,172,170,50,224,155,164,128,186,21,191,254,5,219,7,83,96,184,11,171,75,162,25,247,101,204,192,18,12,73,222,42,57,34,42,169,158,81,33,211,76,91,127,164,81,135,118,22,42,15,116,107,145,29,29,192,43,204,61,118,64,223,216,255,67,208,246,216,56,54,181,37,189,167,129,55,99,60,205,180,13,219,10,153,199,185,149,174,151,198,222,178,68,175,178,65,18,166,37,140,5,208,41,240,220,120,94,52,255,26,239,147,181,98,171,204,187,216,32,70,240,220,217,20,153,147,178,147,64,247,128,209,82,244,50,132,8,62,0,171,102,94,35,234,216,78,145,209,22,138,170,141,86,233,119,196,226,63,254,122,162,66,234,31,55,179,218,204,253,160,181,115,173,140,205,253,236,88,123,174,33,20,65,255,70,161,111,151,130,74,173,232,234,158,0,231,193,169,60,137,132,112,120,169,42,233,81,65,172,178,165,84,71,210,33,95,37,243,75,246,99,149,230,12,146,206,113,137,55,79,64,141,112,92,239,254,244,154,127,40,114,239,42,92,108,129,111,170,193,177,245,172,147,196,178,136,220,127,64,249,198,211,210,60,194,88,190,5,96,90,199,119,184,217,141,255,219,40,202,139,1,147,16,110,160,194,207,172,134,52,104,155,108,48,98,121,152,13,176,115,65,13,16,211,19,163,40,73,87,41,129,167,232,14,40,36,91,102,172,187,159,29,228,209,77,140,199,161,228,143,154,221,168,186,208,11,31,162,110,162,219,136,96,40,130,49,81,77,138,243,72,18,15,140,131,167,58,125,195,241,223,248,76,188,193,115,38,14,197,36,49,234,223,87,230,208,210,157,217,156,115,56,100,5,198,211,188,28,166,152,34,241,173,207,181,102,123,143,1,4,79,181,28,50,215,11,210,138,6,98,2,238,110,197,61,221,60,178,162,119,76,222,84,230,10,156,61,172,240,52,106,42,63,222,53,66,76,114,228,78,14,90,228,133,19,112,236,152,78,37,31,191,242,157,2,87,17,16,9,136,132,173,181,115,202,245,69,242,116,147,172,74,84,229,174,7,97,42,50,61,202,219,123,165,65,132,213,95,136,188,28,10,63,82,214,10,221,139,247,214,26,236,48,69,34,225,129,129,219,211,141,205,156,149,36,58,75,139,6,179,15,195,155,136,107,130,245,214,139,188,56,19,209,63,242,78,116,219,131,157,1,191,6,97,105,244,162,111,249,163,80,112,126,239,135,53,126,167,58,114,127,152,144,137,10,145,108,242,33,119,8,29,114,91,202,139,85,221,73,77,66,105,214,172,201,45,17,147,15,12,201,74,167,145,215,152,241,126,33,206,103,157,133,148,162,172,31,16,44,19,98,175,97,164,23,218,194,85,199,74,196,211,91,171,165,141,208,146,81,193,106,106,28,136,219,251,53,240,240,92,135,163,202,28,32,217,233,65,225,119,89,39,3,166,232,101,124,69,232,209,105,0,144,171,239,130,158,224,103,176,193,184,11,187,31,96,232,38,12,63,55,147,135,250,70,239,118,234,28,176,211,89,64,83,169,229,155,2,139,216,149,79,151,10,74,44,71,46,177,254,147,90,143,39,122,198,127,104,29,84,35,19,200,180,247,1,118,128,41,218,66,49,47,188,48,15,108,211,216,166,147,217,4,148,142,107,188,65,51,44,157,61,238,120,182,255,29,179,183,1,180,102,128,41,126,11,187,147,41,96,17,124,69,184,154,176,120,154,244,66,217,210,52,70,71,15,175,93,93,131,107,95,201,154,198,122,124,176,45,32,2,148,156,218,186,37,112,54,252,129,132,27,198,178,213,51,2,4,218,115,69,254,110,8,167,45,93,71,86,215,144,169,97,127,212,156,114,2,111,150,255,204,207,53,53,23,5,25,225,151,8,211,9,58,240,64,91,186,36,207,36,189,117,206,183,41,25,202,214,59,20,124,247,81,31,45,97,45,109,137,34,71,239,60,228,119,111,215,121,67,182,16,72,105,80,15,233,75,233,219,210,220,24,139,163,188,114,117,21,193,160,230,5,137,8,34,97,52,28,125,30,221,199,173,64,170,244,25,195,42,79,21,164,109,30,86,187,14,171,129,240,19,190,135,202,99,237,32,207,131,74,179,76,47,166,72,60,148,28,192,64,112,16,95,121,190,54,250,250,99,139,227,224,46,0,87,28,38,217,69,86,112,136,119,118,56,46,245,200,169,151,191,188,101,62,115,93,5,9,160,229,131,189,72,85,133,237,247,233,9,29,194,165,82,27,254,63,86,151,170,201,176,228,155,114,16,203,68,69,54,41,215,57,12,190,113,48,171,38,196,247,200,43,206,188,179,140,239,120,145,178,99,119,172,197,248,251,243,239,122,82,221,182,226,229,88,18,98,38,22,100,219,175,70,7,154,140,226,44,1,147,219,189,193,225,54,184,76,170,128,170,63,255,47,33,77,173,21,225,255,120,8,160,18,29,80,98,137,40,77,236,95,133,7,153,116,80,90,168,148,135,234,7,238,218,82,220,6,251,97,196,48,206,135,198,129,111,47,26,253,113,103,70,237,95,7,93,204,141,175,38,188,248,59,120,107,9,142,183,59,67,43,31,157,77,106,144,169,88,11,173,37,40,201,237,129,180,81,163,102,53,17,185,108,158,185,108,217,91,138,49,82,96,24,182,90,10,138,32,189,221,166,169,60,153,202,108,193,128,190,220,84,25,65,186,182,90,141,127,3,251,194,7,164,177,157,125,243,236,54,192,208,63,61,171,98,129,182,23,243,152,116,155,43,208,142,57,66,169,105,72,121,77,10,91,29,233,100,107,154,63,183,12,252,240,232,66,71,27,211,200,32,104,107,48,180,240,136,9,201,71,225,14,186,50,179,148,132,73,46,132,24,32,65,59,86,57,165,246,127,93,126,30,180,239,208,8,211,71,222,120,229,32,32,228,231,231,117,98,165,145,217,221,52,7,29,173,145,241,197,106,92,33,30,135,108,126,75,249,35,254,222,90,67,228,89,216,107,117,9,122,208,121,53,95,81,255,112,195,107,12,242,180,46,242,182,184,15,93,75,16,126,106,53,26,196,203,165,107,37,44,35,108,203,228,62,209,233,255,192,112,138,48,2,21,125,107,43,71,148,157,56,8,179,37,88,206,156,137,223,100,253,98,68,90,173,115,135,13,222,33,226,127,252,213,92,35,46,185,241,66,221,29,75,62,101,219,140,113,192,80,73,69,185,38,248,123,29,131,132,46,113,98,39,72,60,153,213,122,93,168,19,19,57,119,232,156,251,53,68,120,198,46,200,70,212,172,244,75,70,189,82,124,111,106,232,192,249,216,222,58,1,229,128,176,17,192,9,250,231,183,184,176,238,159,210,162,19,249,125,20,139,133,127,217,142,230,153,38,102,3,243,154,144,5,96,67,152,58,199,87,185,85,179,131,155,103,118,132,34,74,2,142,2,76,80,77,59,113,48,207,241,102,167,154,19,214,115,226,10,243,179,136,123,214,131,233,42,234,146,103,185,164,183,125,142,144,196,125,244,137,226,78,100,104,104,190,33,127,16,116,209,175,170,136,242,94,47,132,35,16,230,115,1,8,73,225,137,117,106,109,254,29,115,176,86,205,111,155,219,98,118,180,28,186,121,190,1,132,145,90,4,123,34,79,52,110,155,121,31,216,53,150,172,27,3,58,42,102,130,33,158,136,121,115,43,250,196,193,179,70,73,230,52,137,6,210,1,155,154,59,122,65,252,36,202,81,85,202,175,30,213,109,178,36,41,114,217,85,106,85,202,191,59,222,227,29,134,106,80,23,155,86,211,132,157,213,141,216,104,159,224,233,103,35,135,52,178,206,254,102,30,193,29,202,94,0,116,47,57,228,21,172,222,10,140,67,188,85,12,189,153,16,29,77,103,244,119,251,119,7,46,62,49,208,108,10,97,134,115,100,18,4,87,189,98,11,2,37,98,170,90,249,41,16,217,118,83,3,66,157,200,135,0,77,121,195,201,130,182,124,30,98,169,160,230,164,203,10,236,148,181,189,155,243,249,75,141,111,34,239,58,208,89,29,149,166,72,121,21,207,194,169,126,157,128,139,33,113,55,194,116,113,154,242,52,181,171,71,53,188,24,205,249,223,139,28,185,22,196,61,153,239,14,39,112,157,209,175,243,41,42,83,174,131,11,182,228,169,182,113,181,249,116,122,13,100,227,194,175,199,87,159,244,185,193,140,189,54,58,232,200,150,11,147,234,63,101,174,17,237,32,141,165,102,115,162,97,137,83,240,42,151,24,24,86,251,225,122,254,255,4,195,64,50,252,66,106,194,55,205,197,80,209,191,58,91,48,115,189,108,225,139,20,189,192,177,191,203,235,42,79,122,50,124,147,12,212,189,2,9,111,57,159,81,227,230,19,10,57,29,235,184,54,238,153,221,89,8,21,200,247,47,20,202,201,159,60,214,194,74,230,223,24,84,32,140,198,185,217,80,11,46,120,222,2,238,2,131,24,14,233,45,111,81,50,0,181,178,109,118,24,78,114,24,110,251,183,108,178,176,17,108,184,173,121,177,112,51,172,243,124,167,179,90,17,73,231,25,103,103,44,167,34,248,202,7,229,123,182,160,192,106,182,127,245,245,129,104,157,130,152,136,141,223,62,27,117,208,20,101,28,224,144,71,225,119,202,66,29,132,5,139,97,223,168,172,37,247,243,78,244,54,40,159,134,35,110,254,10,169,118,232,150,95,133,33,22,180,153,135,63,76,223,136,64,229,17,84,49,81,195,253,166,191,173,142,81,61,36,241,237,246,53,156,139,2,10,212,60,140,96,4,49,28,146,222,110,224,177,246,113,94,164,14,184,233,99,193,214,153,126,121,69,118,97,228,28,188,227,61,8,85,111,117,254,55,55,140,152,104,209,48,230,121,205,133,78,105,254,94,103,199,162,177,120,241,227,37,199,216,76,245,159,205,111,42,187,167,88,148,80,46,19,64,171,206,21,56,149,58,165,22,187,19,121,90,179,56,89,142,143,70,77,166,148,75,4,86,195,190,192,50,55,35,220,37,117,87,224,177,137,219,148,193,125,94,187,32,207,90,253,135,180,240,19,164,189,50,7,200,111,80,47,15,236,45,63,138,118,118,133,157,166,218,149,190,162,229,79,47,96,1,110,219,61,14,125,127,146,152,184,83,5,17,71,179,6,216,25,25,238,112,22,96,237,80,16,79,70,139,13,253,171,178,89,34,228,227,47,233,53,169,170,185,242,208,67,31,99,164,96,11,141,48,218,150,8,144,84,55,87,157,75,99,55,183,122,128,1,166,129,75,50,129,188,197,235,49,101,81,164,162,160,78,229,47,185,81,232,95,44,0,106,20,40,109,135,81,208,62,55,64,150,10,182,235,204,10,160,4,219,212,79,163,88,214,75,172,164,118,179,254,136,178,201,18,48,129,66,149,198,223,40,132,123,223,92,223,10,148,149,146,102,155,88,56,76,98,40,214,37,114,10,71,16,81,204,186,18,203,27,133,205,52,210,20,174,114,229,122,136,219,87,82,232,250,104,42,142,25,151,36,188,44,119,59,177,101,63,201,185,82,107,113,170,160,138,5,164,175,119,217,155,226,70,109,54,176,43,170,114,252,217,30,236,27,179,206,166,212,99,177,133,117,25,27,163,190,195,73,22,174,166,111,40,199,171,107,28,184,231,128,76,41,138,40,6,75,144,77,40,212,160,150,18,205,58,18,157,26,106,221,235,24,192,158,133,115,192,81,212,192,210,186,9,159,219,84,34,195,183,55,75,113,132,94,253,184,36,172,61,125,191,143,168,68,49,26,115,239,221,134,99,254,207,99,146,242,54,54,226,173,196,135,189,156,137,69,234,218,150,206,191,47,131,106,55,244,253,146,193,50,208,142,29,216,192,128,99,177,221,160,232,123,169,137,147,172,78,219,112,62,232,3,185,199,148,73,230,1,130,149,118,108,103,219,160,157,191,132,86,177,73,39,162,11,55,169,72,112,27,238,95,22,103,14,106,231,232,80,136,98,226,50,234,158,97,110,34,32,157,223,148,206,231,157,94,62,142,210,212,15,243,116,208,21,187,24,206,162,135,102,155,155,192,106,63,8,208,92,53,164,95,213,97,1,121,14,222,104,180,22,187,148,196,70,147,157,115,215,169,216,120,112,116,85,207,63,160,80,250,244,175,69,128,246,32,14,7,236,182,138,222,174,67,58,252,220,126,177,233,32,49,116,228,120,197,101,210,28,38,184,232,97,182,168,50,192,171,129,124,84,126,103,241,226,159,175,100,71,135,183,250,202,1,76,72,210,177,115,206,79,235,91,191,167,105,200,103,249,251,85,20,1,209,139,120,58,85,87,151,204,141,182,253,255,222,148,227,126,50,19,230,188,35,179,252,236,43,183,61,209,164,102,33,114,229,160,31,161,43,63,59,13,13,241,32,3,79,41,7,189,0,191,51,248,159,228,67,217,26,46,203,203,31,43,68,96,33,199,25,237,176,191,231,128,188,205,84,183,198,252,97,89,143,43,148,123,217,248,233,232,82,158,255,41,29,168,59,242,208,75,75,189,140,147,204,97,76,163,127,100,122,213,160,80,254,73,14,78,205,204,125,78,227,149,43,229,161,82,23,85,93,129,236,118,33,29,46,68,126,3,248,145,39,242,106,95,214,189,84,141,163,78,176,137,85,85,9,210,189,194,0,245,40,37,60,51,82,128,21,152,125,5,37,9,134,13,116,8,65,154,152,61,173,84,156,209,245,70,83,175,132,236,248,224,37,120,117,21,44,127,125,227,137,108,66,141,18,83,72,98,163,115,44,120,98,165,159,76,189,164,62,9,119,254,35,219,90,196,197,95,250,118,70,87,152,205,151,61,95,135,183,33,111,84,148,149,209,194,121,94,236,188,160,92,150,233,85,165,229,88,190,157,13,73,116,99,165,157,250,158,181,138,83,216,102,184,196,38,99,215,110,54,113,205,253,114,138,187,103,113,6,101,139,6,214,78,95,228,44,137,254,31,158,133,98,119,33,146,219,159,163,129,250,49,244,103,64,176,135,217,132,68,54,129,126,64,126,146,100,197,175,202,150,178,221,8,227,218,95,121,243,250,146,18,6,33,74,108,211,230,246,57,229,14,10,215,189,82,181,191,139,34,131,53,170,44,164,175,169,165,40,175,240,198,190,145,77,74,255,139,215,211,16,26,29,117,90,55,45,174,157,68,3,93,146,152,104,144,100,51,123,183,56,201,179,208,237,94,204,183,211,135,124,73,216,1,102,148,64,214,94,78,253,255,46,36,249,79,73,84,72,232,0,105,57,98,212,39,155,219,131,188,121,191,37,113,205,158,158,5,243,148,189,69,31,48,221,78,155,164,197,166,54,252,199,56,78,194,108,63,224,200,89,27,250,225,26,227,34,181,128,236,5,176,130,166,24,84,45,61,226,233,188,36,91,213,161,111,14,80,123,74,143,32,187,248,103,10,188,32,129,174,49,28,153,186,33,13,143,37,81,146,231,70,80,36,30,108,65,244,209,210,12,98,196,241,58,143,252,239,91,104,90,203,122,72,229,168,24,24,36,181,37,69,92,17,15,111,53,116,28,206,112,139,14,51,47,110,250,216,254,235,53,217,16,107,216,79,67,127,216,151,152,19,74,247,232,113,250,24,218,139,79,28,234,71,169,188,181,175,186,7,87,86,203,83,22,249,141,182,66,216,188,172,23,227,209,162,44,45,13,210,216,39,145,61,39,154,127,23,221,187,34,38,195,2,71,96,74,187,150,37,61,60,24,91,148,167,161,148,64,27,55,99,178,48,149,135,224,0,11,99,78,246,207,98,126,1,77,146,190,206,250,132,219,228,113,143,196,119,202,25,12,137,225,224,164,3,81,6,73,132,182,212,183,24,166,122,50,94,122,133,94,147,199,182,223,244,104,237,133,216,159,54,110,27,59,158,248,6,166,11,20,11,68,90,154,183,91,181,11,246,131,47,57,219,220,213,59,249,11,93,108,196,25,172,217,169,209,9,192,13,100,197,41,208,253,241,29,130,89,111,111,239,203,251,223,151,234,28,33,146,244,198,231,52,40,57,63,232,43,137,251,38,4,50,161,219,11,17,3,216,163,189,50,245,185,116,164,192,17,122,174,139,89,47,93,47,198,40,246,159,108,40,177,132,172,252,89,234,178,102,170,10,13,61,68,30,46,144,142,245,92,3,145,117,242,25,255,196,199,131,169,1,216,198,134,208,186,147,21,170,104,88,35,37,173,195,105,22,173,153,63,56,224,175,64,79,166,44,68,87,246,243,4,147,17,87,123,238,162,120,110,142,194,253,164,247,136,56,27,220,250,197,105,43,145,130,190,172,13,142,127,127,93,220,236,43,19,18,238,75,138,108,79,239,44,4,145,250,103,233,32,142,8,56,77,88,88,253,2,131,203,143,202,35,167,228,201,15,137,24,129,115,21,241,40,96,65,193,222,188,6,105,31,113,253,187,147,194,116,231,115,244,238,100,89,3,66,225,220,239,55,213,7,187,137,60,233,165,26,118,210,138,68,110,8,3,237,43,29,249,137,118,51,15,94,48,240,33,244,161,32,20,111,82,110,149,254,247,43,200,191,24,19,215,19,234,198,61,161,106,142,144,206,249,86,75,250,100,210,151,85,63,123,196,65,233,143,3,131,118,146,177,91,252,179,249,249,47,60,142,16,146,15,193,118,30,250,131,136,206,122,139,123,238,220,209,187,214,2,244,7,56,61,74,60,245,203,105,17,242,2,153,33,224,48,102,61,238,229,221,40,124,129,164,203,185,21,228,127,229,6,32,243,115,34,181,137,85,188,161,94,165,62,81,140,112,154,145,229,10,126,130,157,184,48,172,29,65,36,144,17,59,130,62,23,216,96,161,41,85,77,34,139,30,134,107,157,184,90,183,102,27,248,81,252,175,31,106,149,108,185,2,56,174,183,8,233,92,12,35,238,132,95,160,215,37,43,199,104,135,61,215,42,138,190,202,60,148,15,221,161,185,21,177,205,155,197,196,136,100,136,241,239,225,145,99,35,100,65,184,254,156,112,237,98,215,75,144,101,147,44,113,163,158,81,4,248,127,223,76,136,111,224,149,127,4,9,70,174,117,206,184,233,27,134,110,154,185,116,139,168,168,182,108,214,228,171,140,96,47,234,250,83,60,241,177,81,17,100,217,169,78,243,26,82,172,53,247,148,211,214,185,130,24,71,182,126,198,225,7,33,131,240,44,5,97,9,176,71,128,113,144,229,215,76,122,177,76,70,20,82,103,71,204,56,183,179,240,252,199,75,117,46,107,140,19,142,105,52,243,66,49,76,224,53,131,30,192,95,140,112,206,185,30,104,152,132,171,64,25,208,14,64,41,234,180,110,131,180,30,247,93,235,167,135,107,74,158,67,118,68,14,186,2,84,160,191,159,74,160,234,47,146,183,54,101,126,242,150,128,109,235,30,70,5,161,10,152,118,83,48,23,52,146,191,3,64,21,117,171,81,140,135,218,89,91,76,104,206,38,147,52,133,174,253,201,96,177,255,58,83,175,170,155,161,185,44,61,23,151,35,155,142,2,79,144,194,198,64,67,109,13,149,92,250,2,89,70,139,48,4,5,91,245,9,164,169,10,25,161,100,152,115,163,231,29,107,53,251,43,144,215,86,237,75,161,188,172,5,50,190,160,186,27,78,28,19,221,53,177,230,194,123,84,10,69,82,170,214,23,185,95,194,63,215,179,85,142,14,127,77,165,74,55,1,89,50,141,243,190,108,100,148,111,87,106,234,117,200,235,239,208,96,43,228,110,119,253,195,120,119,3,249,18,164,34,188,90,73,160,99,216,109,0,0,78,99,250,56,150,189,175,44,68,69,167,243,215,201,212,59,167,27,29,229,140,231,225,41,14,85,222,229,252,210,251,1,186,47,105,212,166,195,4,40,106,241,219,31,157,236,29,3,178,123,242,81,233,112,241,169,43,150,157,89,241,9,164,76,185,157,181,206,92,230,95,198,132,99,14,67,250,141,61,196,220,121,26,213,190,74,35,81,2,101,32,25,170,48,70,82,50,152,160,174,44,77,216,195,125,119,127,86,61,49,125,150,40,189,157,178,131,93,219,157,232,126,149,197,116,212,89,141,175,231,152,134,156,207,112,247,229,39,127,29,147,136,187,120,22,186,119,97,154,90,27,131,134,238,96,125,53,77,92,133,201,118,173,247,7,108,254,4,161,107,137,153,110,120,14,121,238,136,109,10,48,115,139,166,189,39,188,245,129,58,149,18,89,126,127,80,0,120,78,210,177,198,66,20,15,161,82,43,220,56,246,168,108,76,69,100,234,11,70,245,125,56,205,25,251,35,253,235,254,55,62,185,230,255,14,230,140,212,19,143,81,134,238,16,247,125,78,150,54,148,61,154,42,69,239,249,12,30,39,12,221,45,232,75,73,250,49,105,16,201,242,165,24,48,57,141,31,116,48,255,3,194,228,122,165,33,161,177,140,186,165,6,112,157,188,150,155,18,181,104,224,137,118,230,211,16,11,136,234,240,181,251,253,182,65,242,4,253,35,123,226,252,29,221,140,46,193,101,142,249,6,50,18,159,73,186,239,25,202,175,116,81,182,21,180,152,218,253,47,162,53,148,227,118,205,116,86,125,236,168,81,245,117,108,156,104,254,238,39,13,215,116,190,86,20,116,51,130,220,250,38,210,168,61,20,187,26,60,29,90,158,149,145,44,229,177,24,174,62,148,125,117,84,157,114,17,162,31,100,183,117,251,8,210,18,65,104,81,140,82,186,200,153,20,252,14,57,77,253,202,211,150,199,151,136,147,34,205,42,208,48,225,127,147,124,195,63,118,145,148,202,59,106,215,5,130,50,103,212,91,178,8,5,214,29,230,237,54,127,246,176,232,210,223,193,174,4,62,161,228,179,211,108,132,224,42,31,157,30,195,212,157,167,215,118,177,76,90,201,194,78,144,52,168,108,114,53,236,101,194,162,168,87,150,35,84,164,81,234,171,46,16,147,145,68,158,128,178,144,94,202,209,88,169,173,46,239,61,129,210,99,47,212,83,198,39,111,195,33,33,13,73,142,43,59,9,212,152,17,106,238,36,130,93,37,141,107,96,125,116,96,233,87,97,76,126,195,68,118,40,218,227,147,11,88,14,216,33,5,51,192,155,107,204,160,229,129,71,79,135,208,237,23,41,184,201,178,123,42,222,169,140,164,132,178,50,216,151,220,9,248,206,237,178,203,195,178,156,90,105,196,65,197,141,108,26,245,5,212,197,95,56,57,18,111,215,183,25,73,160,132,90,173,238,238,222,20,186,117,160,80,244,218,27,157,0,252,60,194,66,126,82,3,121,41,159,52,116,142,128,173,118,222,34,206,145,96,32,228,165,85,65,119,97,49,194,191,227,127,39,144,42,88,156,192,248,3,123,173,126,241,187,140,233,101,62,44,49,230,194,194,139,21,1,148,239,194,18,11,225,51,155,224,69,222,178,207,185,172,48,162,152,219,42,88,165,92,133,44,224,255,59,236,82,0,207,203,88,192,12,40,65,234,47,124,227,98,104,36,248,20,215,180,8,155,176,119,225,82,217,97,55,32,125,196,235,127,212,80,19,216,201,186,126,233,75,71,88,151,75,140,161,241,125,55,154,196,221,38,170,174,94,2,206,70,179,214,148,114,162,101,117,1,205,31,249,124,69,71,103,229,201,174,8,199,93,1,84,243,16,106,66,66,138,80,39,139,211,118,113,36,235,76,69,26,49,232,19,7,58,20,83,175,68,184,248,111,46,0,13,121,239,167,184,222,227,70,106,97,178,95,238,184,139,222,57,71,8,66,150,79,34,229,148,103,236,85,21,2,64,100,146,145,159,71,220,212,109,179,87,53,143,128,42,185,16,174,102,43,179,194,192,36,37,191,147,73,102,149,211,56,67,226,106,50,183,10,130,90,100,133,208,232,182,189,60,98,139,33,50,43,86,218,197,142,119,254,33,157,48,178,111,4,104,1,223,176,47,200,150,219,213,33,225,104,250,249,118,21,47,194,154,211,255,20,140,66,6,89,237,37,95,112,39,58,247,225,89,206,221,101,149,74,199,149,186,156,95,30,137,26,213,182,175,215,69,3,171,184,226,101,180,18,56,164,119,75,27,126,164,158,209,12,92,150,42,236,237,164,235,127,197,185,215,158,200,200,126,99,89,120,248,250,25,240,96,61,120,70,84,143,212,104,111,42,86,132,234,187,91,26,168,174,206,236,196,28,81,132,75,198,0,171,21,69,251,15,152,29,89,19,124,94,115,99,40,96,0,38,175,81,24,182,208,186,208,150,217,109,130,79,149,69,135,171,99,235,20,48,215,124,87,187,136,233,79,83,64,230,67,181,7,246,239,198,50,73,114,239,245,226,183,75,124,33,116,88,8,126,0,100,102,122,149,205,151,14,153,46,254,64,57,123,95,174,224,193,222,36,149,77,171,127,72,152,193,184,213,244,101,229,153,28,17,23,157,167,46,71,57,25,91,143,131,167,126,171,100,180,10,231,201,186,29,108,94,189,93,160,5,92,183,206,202,245,69,105,216,31,10,51,186,124,82,87,94,29,179,190,11,75,157,53,190,5,215,200,72,177,173,114,112,183,196,183,202,222,73,57,12,126,50,221,234,103,163,236,12,223,162,177,86,213,243,44,30,44,251,84,103,67,21,171,7,176,190,138,55,182,87,147,19,70,37,148,252,131,253,14,125,193,112,180,205,233,44,63,232,17,226,109,60,123,251,28,88,249,147,57,51,89,49,192,70,127,90,111,12,164,104,212,142,70,156,192,237,205,224,59,201,252,131,173,28,84,217,81,4,144,211,24,202,181,182,92,165,214,139,67,232,225,87,33,36,192,20,219,90,175,141,251,41,152,174,5,233,12,83,114,148,205,198,155,181,64,210,209,135,147,8,190,119,136,188,75,111,145,167,67,65,47,207,155,190,42,191,93,39,178,226,228,172,48,229,156,31,9,209,109,24,93,105,221,171,122,134,236,82,245,254,214,138,221,135,35,135,186,229,174,23,236,13,10,12,12,140,56,28,96,72,200,186,246,191,100,55,173,55,172,50,16,38,126,8,201,197,197,126,9,14,59,112,39,61,216,141,114,114,70,92,33,142,185,114,150,79,166,70,36,193,35,156,119,68,152,197,137,220,83,121,189,217,217,129,165,112,79,79,34,166,70,40,77,137,9,189,185,152,180,42,156,196,179,23,241,130,114,202,220,179,95,104,136,199,219,223,158,176,208,66,28,90,144,47,110,165,27,159,78,45,197,143,153,112,63,101,184,233,6,138,217,189,42,77,249,191,222,255,178,165,240,94,138,121,92,241,163,209,93,66,142,9,250,187,236,104,193,236,185,216,82,213,34,114,184,157,13,193,198,222,162,14,233,92,25,96,193,108,52,109,192,241,107,186,12,245,24,116,252,211,180,17,240,222,63,214,15,220,207,145,95,141,2,63,158,125,45,141,228,238,59,39,98,30,155,115,253,255,148,169,156,136,226,144,224,51,48,75,204,110,94,173,79,95,101,194,124,187,53,241,247,47,90,24,36,171,220,130,247,169,47,99,206,19,59,6,161,214,181,6,34,79,211,228,217,99,155,31,172,175,168,63,195,18,36,80,69,240,207,116,192,179,210,106,188,184,48,181,149,169,114,191,38,88,73,142,217,119,36,84,8,190,80,176,51,163,76,22,38,131,94,213,167,81,4,208,78,246,49,235,248,56,132,10,101,133,165,240,223,105,153,213,11,108,143,47,197,185,162,192,18,76,96,249,142,164,102,243,195,124,29,140,197,245,196,222,249,113,188,144,217,213,217,148,181,170,61,148,94,112,253,107,79,24,163,197,173,53,194,66,108,250,155,7,129,10,176,86,209,207,34,158,69,135,246,81,236,124,123,33,110,233,195,94,158,135,171,62,227,67,56,22,34,239,180,99,144,187,170,203,78,240,6,34,244,2,36,208,74,188,26,70,181,48,216,240,21,176,148,38,87,94,30,196,232,194,31,159,37,168,137,70,76,72,240,247,181,174,189,89,243,58,9,87,11,113,232,184,22,3,56,53,8,208,85,200,78,32,42,251,22,38,167,168,237,21,38,146,39,177,248,176,11,212,162,249,178,197,81,195,143,162,169,75,18,145,160,138,79,166,92,118,175,53,56,218,251,224,53,180,219,148,250,136,128,105,116,130,83,217,25,159,149,251,166,11,14,154,254,44,140,199,125,160,65,238,147,62,2,182,113,227,141,242,219,59,148,240,178,4,92,45,93,37,112,219,62,10,32,129,172,6,212,181,204,178,155,105,237,176,104,97,247,89,211,93,46,133,105,246,12,102,76,193,125,136,174,208,168,233,64,81,108,249,226,42,49,92,16,183,189,229,12,14,140,65,38,225,129,197,220,103,3,84,22,69,233,110,129,141,152,236,114,152,234,64,232,155,129,148,57,127,121,99,16,192,216,212,165,68,125,63,230,235,202,222,26,94,15,94,14,167,67,231,130,9,66,187,199,61,95,219,153,43,95,123,52,68,8,254,219,252,118,70,214,42,159,208,76,2,105,21,108,44,82,49,135,236,74,1,57,158,43,239,198,144,68,40,193,59,138,150,235,213,25,227,160,155,52,195,197,3,46,240,245,106,108,218,83,186,253,231,83,178,2,57,248,117,184,42,111,65,46,78,164,70,173,142,94,158,155,230,88,58,125,162,19,134,136,162,138,197,93,188,43,81,48,187,250,125,228,223,59,65,165,182,181,115,181,43,128,124,197,197,142,174,237,39,45,162,53,56,189,229,168,92,250,228,83,244,146,38,76,3,157,145,89,56,161,212,2,17,102,171,76,227,159,162,174,63,140,227,100,65,115,137,28,65,45,173,48,75,47,21,141,4,69,67,123,166,12,157,61,119,243,65,228,162,173,75,157,147,238,120,86,228,197,152,93,116,37,63,202,73,244,168,37,210,22,171,113,161,167,111,234,197,16,235,9,61,77,52,158,116,133,188,174,63,138,130,193,225,50,95,189,77,124,75,241,230,208,84,54,73,74,4,249,0,45,112,95,135,43,117,48,38,227,101,90,161,122,102,133,65,98,63,17,68,101,134,192,115,38,154,4,77,249,221,65,150,51,19,233,194,89,12,140,28,227,118,244,224,95,207,181,205,237,235,193,128,253,125,174,216,201,3,48,56,22,182,144,4,37,97,46,87,124,111,2,214,192,218,132,204,59,0,213,174,255,24,97,229,247,35,101,202,91,184,37,246,166,60,253,155,135,102,13,52,100,16,182,166,140,213,239,25,60,108,239,90,136,250,0,124,35,159,141,254,178,205,3,221,54,163,167,158,19,100,228,83,127,37,161,12,205,49,220,233,125,187,136,25,42,40,118,100,8,33,190,219,40,202,199,128,40,85,190,132,201,244,145,179,106,78,48,183,189,152,107,140,91,107,23,81,100,129,109,91,191,116,96,198,120,181,247,226,131,86,118,87,69,111,168,51,247,254,189,194,84,162,76,136,131,61,172,250,242,181,159,110,204,92,216,21,57,131,163,216,189,14,211,244,193,230,34,164,158,125,85,178,32,81,134,187,181,101,39,169,111,86,60,55,72,85,180,101,244,25,246,212,111,78,244,193,105,112,242,152,76,119,162,28,8,206,139,170,233,0,222,0,80,8,58,147,237,102,212,153,142,78,206,227,209,5,16,215,162,91,114,166,244,30,101,220,1,22,110,7,6,34,190,131,64,231,12,141,98,59,1,30,160,144,43,85,165,40,43,3,176,64,219,212,51,63,35,250,228,145,41,123,25,38,107,226,32,253,102,29,231,179,34,3,162,158,167,198,149,183,46,176,54,179,7,101,119,63,141,17,247,149,225,203,61,174,19,158,250,181,189,186,128,248,140,211,73,151,166,101,172,151,229,7,209,212,186,132,220,194,223,250,8,226,144,33,48,196,18,167,137,95,109,136,201,58,9,110,231,234,164,52,107,211,116,89,74,197,136,47,56,33,173,71,40,69,132,72,229,30,163,13,219,232,178,203,6,3,232,14,45,159,164,217,105,58,224,161,249,92,155,184,34,67,36,251,67,112,121,75,57,218,229,37,24,126,38,20,157,135,162,215,163,254,127,164,237,127,237,21,170,96,38,198,81,194,181,153,145,130,1,113,230,206,177,10,30,233,27,50,246,87,67,34,254,92,172,138,152,137,48,110,69,85,159,54,208,112,120,117,175,66,233,202,116,104,142,2,201,138,176,214,251,121,45,168,41,57,67,95,207,240,180,239,168,128,107,92,165,79,154,33,88,34,87,149,234,72,210,210,141,82,142,167,63,216,3,5,3,47,146,138,61,27,50,246,5,183,225,232,19,224,44,69,25,171,140,157,143,125,26,76,96,165,151,10,156,160,5,100,174,153,177,147,128,55,77,136,52,248,144,39,107,68,132,181,18,22,24,21,133,106,69,167,137,233,97,201,248,196,83,83,254,115,114,27,9,46,10,67,37,58,229,177,193,171,2,214,155,180,174,232,52,204,112,9,125,213,83,121,18,132,142,166,101,37,197,195,3,123,236,36,154,129,42,24,43,23,152,247,151,176,67,104,219,242,217,146,128,80,214,38,47,174,149,32,117,92,132,116,132,75,191,188,203,39,82,79,139,57,99,168,214,95,200,208,99,128,76,181,14,63,142,247,103,198,102,55,24,72,24,233,131,253,107,209,100,167,165,16,46,104,148,65,132,213,93,11,113,109,12,114,154,69,118,76,104,177,230,57,89,219,104,134,5,65,242,0,215,174,255,185,67,21,232,46,85,23,169,198,74,160,211,151,60,234,183,79,113,45,112,166,112,57,187,39,141,200,252,152,0,222,199,119,52,38,69,128,68,202,10,140,87,241,178,112,162,226,59,34,121,193,132,166,219,28,217,169,72,133,81,142,24,70,28,2,87,30,66,23,153,220,183,76,182,79,141,159,193,144,133,16,34,225,95,192,28,163,60,251,155,98,147,72,5,81,209,204,247,154,7,20,61,96,228,37,118,139,24,81,12,185,24,250,128,246,104,150,37,117,213,113,219,204,125,82,223,202,4,79,166,182,142,236,148,43,77,79,14,19,14,7,84,249,64,210,54,183,145,35,240,38,205,141,107,199,35,73,197,141,242,13,222,113,221,88,214,30,174,203,154,190,84,93,147,93,52,170,4,188,97,142,11,86,46,111,144,105,194,8,165,152,142,209,217,175,196,108,46,128,153,84,20,91,35,20,94,126,47,199,69,72,212,99,78,34,59,99,193,87,90,84,48,208,93,1,49,136,136,33,255,197,4,85,115,254,133,95,178,93,225,124,177,231,163,253,44,222,44,97,224,183,32,223,213,197,98,4,2,171,6,32,20,131,72,120,133,188,119,57,190,192,169,229,18,176,243,231,59,184,211,221,93,89,131,157,247,68,63,93,117,107,183,128,220,165,238,107,233,28,249,193,253,92,86,149,201,98,163,77,172,233,77,26,109,32,231,78,126,181,126,102,2,146,76,20,184,203,249,243,232,145,85,66,59,121,53,205,86,159,141,24,161,43,191,162,49,98,86,132,46,36,85,60,13,42,13,49,39,172,87,174,149,110,225,191,145,94,182,116,169,62,148,46,244,76,102,206,185,163,187,72,73,138,64,125,11,236,141,187,113,30,202,50,199,81,194,160,8,224,159,235,171,144,177,101,2,7,206,204,55,186,187,192,22,126,15,147,169,59,212,149,141,33,115,185,26,125,12,137,11,74,205,11,14,54,174,50,104,85,209,254,31,230,60,37,114,152,61,114,251,39,195,44,228,132,219,190,235,201,185,94,185,53,249,123,63,41,166,116,251,145,61,69,217,43,201,174,107,141,195,169,50,52,223,207,114,195,65,104,203,77,194,243,120,153,133,83,65,216,224,238,224,198,189,165,175,131,198,208,113,77,58,103,145,177,166,147,16,160,221,96,150,245,205,67,155,24,95,160,129,40,15,101,35,103,231,135,221,87,5,243,184,236,55,126,203,33,149,191,25,163,53,205,204,131,204,4,68,166,22,42,213,239,65,232,189,202,145,190,42,127,19,238,131,111,207,70,154,115,217,174,127,63,92,108,214,137,172,88,220,73,159,146,214,193,246,156,67,164,208,134,114,108,177,32,32,193,122,209,233,110,222,174,95,66,188,227,199,95,160,214,186,12,0,235,1,138,112,140,227,245,40,247,26,80,217,205,126,143,1,45,211,66,213,149,177,223,26,242,0,241,205,36,46,53,70,200,27,52,232,88,89,158,190,111,25,238,241,132,148,131,31,97,136,61,101,37,183,245,27,250,203,108,174,223,133,22,1,150,18,209,31,58,28,54,212,176,196,200,52,171,0,183,237,217,7,120,104,54,19,138,57,60,145,60,242,214,179,99,197,221,22,7,202,0,211,176,194,87,249,218,62,59,222,2,86,9,47,9,10,4,179,152,101,18,212,96,169,19,114,163,74,15,205,244,96,2,94,126,25,73,158,191,200,211,33,46,3,0,137,0,87,73,79,112,249,51,200,17,52,224,164,110,125,107,65,16,152,126,110,9,104,251,180,219,141,207,165,49,79,239,94,234,6,248,150,19,163,101,166,7,127,104,71,13,163,91,31,255,154,97,63,9,46,250,245,55,40,120,80,168,16,204,4,39,150,122,113,106,137,169,25,10,193,123,65,24,162,233,134,142,2,238,8,103,239,69,180,180,230,114,254,72,213,11,56,180,193,176,233,172,221,171,193,149,78,251,166,105,136,22,80,128,176,1,144,39,12,13,167,144,128,50,49,250,121,200,153,215,68,52,27,196,171,150,40,24,6,21,91,245,226,208,227,73,114,83,118,117,25,4,26,171,26,75,247,90,250,48,178,195,128,50,15,205,243,216,161,19,180,210,239,76,238,202,172,49,252,195,247,249,67,144,49,47,70,108,21,234,151,5,195,249,177,109,99,67,202,63,184,94,85,25,8,153,10,45,76,167,125,20,113,88,154,87,118,146,65,233,153,127,181,241,234,205,198,230,97,249,28,68,52,94,68,89,9,88,47,248,105,79,92,15,205,90,68,194,84,92,80,232,19,18,96,53,227,161,254,99,36,184,209,124,89,63,191,215,190,104,92,255,213,189,139,56,217,192,98,201,79,31,213,51,191,223,41,159,22,92,205,167,163,166,220,50,76,142,229,104,26,33,32,216,217,150,33,207,38,134,63,148,176,215,191,185,107,67,15,155,26,32,249,163,139,120,174,220,108,220,50,152,15,199,222,63,83,123,198,87,192,213,210,70,225,254,11,85,119,35,54,126,139,188,0,195,98,224,46,227,49,97,72,174,109,203,239,96,207,9,205,130,97,160,242,138,77,112,52,249,157,207,32,161,208,168,21,172,17,214,62,10,121,186,76,115,45,25,38,158,13,138,21,29,82,73,210,242,192,67,51,213,29,87,89,190,209,149,11,96,236,63,192,214,247,135,204,104,104,98,179,1,140,128,73,30,247,1,163,71,98,145,188,188,107,74,175,19,109,102,102,110,13,202,211,236,166,95,207,75,54,173,199,39,26,188,206,32,100,2,82,16,48,32,153,144,81,222,37,238,89,182,46,79,141,20,216,218,170,146,63,124,3,97,14,199,150,197,138,50,182,220,118,31,244,235,128,195,234,1,117,197,65,94,49,138,38,215,33,41,95,160,141,30,250,209,28,215,12,197,14,171,114,112,207,27,245,236,134,253,88,67,34,207,68,77,208,6,160,92,197,160,216,83,130,92,113,107,16,120,120,6,216,149,41,140,57,222,4,164,145,223,176,210,171,141,0,206,183,201,232,56,30,32,33,55,24,156,243,205,64,14,210,14,33,14,55,196,179,195,67,88,156,62,53,88,161,47,249,153,181,42,61,111,92,195,27,98,200,99,125,127,231,220,170,241,162,216,234,0,95,146,255,39,226,65,91,106,107,9,255,182,246,231,98,240,219,45,104,92,70,151,104,133,78,242,176,162,144,81,5,84,223,242,68,108,195,219,252,60,208,6,234,105,163,94,162,94,64,77,198,230,235,67,84,100,33,112,218,177,127,48,100,162,29,51,137,111,108,188,92,77,221,168,112,123,19,25,68,180,69,59,228,116,179,69,215,168,44,195,78,200,177,25,163,0,46,115,193,27,204,143,179,131,223,196,145,63,53,229,166,179,155,210,143,82,177,48,110,160,130,232,208,203,248,60,155,54,61,254,80,100,134,77,246,240,188,121,249,158,169,95,17,54,141,141,197,165,86,52,58,8,89,121,153,65,249,94,137,114,126,135,254,144,195,228,30,21,69,156,215,179,154,232,164,202,125,29,204,124,48,58,12,246,41,230,103,153,91,128,138,171,25,174,182,35,125,114,206,215,255,82,189,83,177,57,31,131,1,223,194,104,236,67,163,191,73,190,132,56,213,143,253,160,237,220,25,187,114,210,231,130,118,168,96,172,143,199,62,92,105,3,50,234,149,185,60,147,166,240,15,194,163,126,33,138,187,126,197,180,0,192,141,251,84,229,226,225,245,26,52,149,253,65,15,190,37,127,179,162,163,123,168,224,37,58,72,231,139,245,157,180,77,139,145,241,52,20,184,112,84,193,41,234,206,62,44,80,186,81,75,148,45,2,23,99,71,236,14,47,153,155,8,230,159,223,48,11,248,232,103,210,96,118,114,63,128,135,9,167,248,118,157,25,51,255,164,160,184,220,234,119,61,71,130,115,128,33,231,149,121,105,176,74,192,149,201,130,77,147,192,220,172,209,133,77,214,129,127,126,211,13,69,68,245,37,134,132,212,81,190,58,205,207,160,52,88,3,145,111,234,114,2,64,130,71,222,232,94,35,123,116,43,16,138,72,118,43,60,204,90,93,33,104,234,87,179,110,112,168,152,68,118,2,240,16,131,47,116,221,191,237,81,254,50,106,191,132,226,21,168,72,11,98,126,178,55,51,16,64,107,238,122,45,225,214,139,20,171,245,235,42,98,204,43,248,32,247,240,6,32,215,43,4,150,210,1,180,13,186,35,203,103,237,193,146,206,33,207,253,182,195,222,160,31,147,249,241,30,87,47,223,237,121,212,219,41,109,168,169,213,175,102,202,223,50,178,138,21,168,83,242,126,227,3,103,39,75,97,219,98,221,225,52,203,88,195,124,245,102,156,248,1,201,175,106,92,182,224,231,6,31,227,104,101,155,102,230,175,137,184,91,174,18,159,251,36,251,130,174,164,220,156,66,234,30,135,249,169,7,160,205,53,173,68,231,111,63,138,71,129,152,50,65,4,222,13,30,80,127,80,148,208,95,179,74,13,13,122,179,236,3,221,0,156,64,195,68,201,170,26,56,252,89,19,143,86,181,138,156,210,163,66,217,105,51,115,255,36,220,5,163,113,10,236,100,251,221,113,104,116,97,130,174,96,111,94,215,109,70,215,121,21,55,2,227,123,52,34,211,172,9,169,68,253,43,188,52,212,104,99,249,244,178,68,148,202,86,241,232,115,74,120,109,160,28,248,204,7,151,88,129,49,79,4,90,42,143,188,156,108,14,16,206,189,153,182,178,195,91,68,238,86,67,32,239,237,212,142,229,78,183,48,105,111,27,181,206,178,91,140,187,82,143,20,176,195,208,65,184,83,43,242,138,61,114,149,131,16,80,102,24,161,127,50,99,4,135,126,41,0,219,120,216,178,55,21,21,76,220,231,5,6,7,14,50,99,69,214,41,187,180,244,21,212,85,52,166,5,226,232,201,252,148,113,72,154,134,35,121,254,65,222,144,72,208,200,141,244,101,192,59,162,252,169,60,238,185,148,220,106,222,20,50,128,105,78,194,64,133,42,65,231,122,194,206,219,132,9,112,132,213,156,210,205,106,151,60,81,163,106,30,11,226,232,203,76,242,137,169,100,57,7,142,209,217,28,159,83,157,206,154,146,0,212,92,90,208,134,6,67,32,172,163,98,78,242,207,150,81,52,248,246,212,207,176,41,197,244,10,154,203,82,53,130,176,228,47,78,13,184,61,172,26,105,191,19,85,77,15,242,145,179,109,9,181,241,4,197,70,20,121,91,217,27,248,141,243,136,35,64,23,15,93,13,185,103,146,226,82,19,105,57,174,72,142,92,54,63,16,105,30,155,61,69,226,231,46,238,32,227,175,36,252,147,86,15,21,42,157,102,182,169,98,196,140,59,1,159,53,84,120,216,56,203,29,75,177,219,117,153,236,188,0,83,104,196,0,219,197,87,40,114,142,81,29,22,176,212,116,197,74,246,231,224,251,151,196,240,180,252,103,161,231,24,17,102,100,216,25,33,131,24,131,190,197,126,111,129,249,205,253,40,130,193,52,176,141,189,118,58,157,129,233,194,146,6,170,2,110,37,108,128,138,72,126,203,241,70,17,45,203,122,84,231,81,194,97,13,87,109,200,55,93,221,213,19,120,249,43,150,9,165,135,58,88,207,216,188,95,117,71,14,142,31,35,5,72,196,33,172,153,169,219,74,29,237,116,148,45,177,20,28,126,25,157,1,77,185,68,100,151,42,169,237,54,138,93,142,111,11,45,183,179,154,67,59,181,227,17,106,126,97,0,14,67,138,186,54,157,154,60,27,248,137,109,26,137,61,184,207,4,84,99,104,241,23,146,196,67,9,81,198,156,217,136,2,243,220,211,125,166,208,76,108,232,70,96,74,85,206,117,185,73,4,53,59,58,105,141,240,179,212,32,75,50,78,68,255,246,168,113,76,239,247,49,250,31,176,186,61,93,74,219,184,17,251,233,244,106,100,135,47,107,172,255,74,74,44,134,158,9,113,246,217,54,150,173,228,102,252,140,76,109,164,35,43,238,238,196,179,239,243,179,153,131,66,34,34,222,84,138,255,170,56,208,24,10,248,239,88,97,180,130,132,239,32,153,218,36,119,120,191,41,70,0,99,117,135,93,94,60,78,71,134,87,13,88,66,162,211,92,238,177,169,30,190,127,26,146,13,90,209,177,252,8,10,57,252,113,56,196,231,64,142,137,7,245,132,215,146,240,44,166,20,92,223,243,196,34,56,159,86,133,251,64,181,92,38,89,172,1,192,100,201,70,53,51,21,55,176,180,163,147,138,11,165,59,192,162,215,56,84,87,85,66,17,190,19,146,182,230,53,99,10,220,106,96,118,102,110,50,30,171,102,245,158,27,129,20,107,124,68,103,56,17,107,221,171,227,59,181,113,2,55,228,157,50,110,117,135,58,212,143,75,177,131,69,232,217,37,5,189,233,39,137,102,150,206,223,11,116,233,236,61,27,155,196,7,163,176,224,65,161,59,227,20,69,140,253,254,148,112,59,204,222,4,1,108,120,24,2,109,12,204,144,228,52,247,161,208,172,165,95,247,137,196,61,99,172,76,200,238,163,244,100,165,9,91,121,172,107,171,80,248,234,132,196,28,22,174,216,241,125,124,187,231,112,28,237,129,212,213,160,249,67,153,105,160,227,142,180,216,252,198,212,171,187,157,213,133,226,200,0,106,182,61,132,112,124,181,95,66,142,181,152,217,88,60,155,125,230,255,1,133,192,243,82,192,153,200,191,233,44,142,222,212,172,34,236,193,52,227,151,110,52,57,102,134,209,157,178,55,24,104,125,156,242,207,186,167,69,28,164,32,129,216,68,179,104,43,164,213,46,100,23,148,59,64,24,64,33,157,158,77,19,95,151,27,18,104,181,222,25,89,202,28,53,4,89,205,109,122,233,229,181,226,234,94,15,104,31,18,236,158,114,22,215,169,44,77,58,240,146,218,115,152,49,178,180,98,239,221,231,53,84,15,139,225,93,191,194,124,16,228,120,126,22,174,188,37,160,90,14,3,92,24,172,33,197,55,128,147,41,1,132,154,181,215,179,16,56,17,215,69,16,204,29,103,74,158,222,195,78,82,254,175,184,69,139,17,191,143,35,77,115,2,156,248,243,38,64,31,49,110,172,24,108,85,208,46,146,28,242,32,69,73,24,47,72,154,96,184,1,43,14,216,162,187,121,11,0,1,149,158,64,252,70,123,208,118,42,226,71,222,177,39,14,15,220,33,170,240,166,231,46,222,37,244,144,231,247,65,82,104,230,18,185,6,234,135,42,6,0,83,103,55,101,242,222,82,24,178,90,10,95,191,223,250,108,45,248,110,138,64,94,49,131,225,37,52,232,254,196,255,183,122,251,245,250,129,199,238,12,235,48,67,150,196,14,69,205,104,138,214,5,233,43,6,25,219,166,20,157,245,148,171,237,46,190,101,8,104,26,176,157,76,193,148,245,164,245,106,82,56,63,38,114,182,150,81,52,139,74,137,195,202,21,166,159,95,151,210,31,200,139,111,132,173,164,122,94,130,137,119,97,187,47,164,239,30,179,210,151,182,233,190,167,15,6,152,227,163,56,143,245,22,29,218,222,23,199,148,100,62,143,254,250,91,11,246,162,11,76,40,201,201,35,212,23,250,145,39,79,214,211,137,18,178,151,246,46,36,171,225,56,139,98,68,30,57,76,204,194,118,246,247,223,47,119,19,43,200,251,15,167,228,131,14,250,76,207,215,198,248,234,69,237,46,95,188,54,166,4,133,41,13,248,209,189,201,226,117,214,48,199,3,177,129,173,94,190,60,107,78,51,105,123,98,232,13,183,93,24,57,13,222,132,252,77,176,80,234,181,124,55,232,56,76,239,17,8,176,66,214,141,34,24,113,100,237,94,169,37,215,78,163,70,149,121,31,206,113,134,229,67,164,192,25,78,5,54,88,227,254,52,196,50,53,4,75,181,201,11,43,76,207,123,120,81,157,213,112,90,96,216,125,4,61,128,23,163,112,45,82,108,89,119,47,55,172,106,148,253,86,81,32,127,80,26,1,209,68,192,120,133,115,216,114,176,105,167,230,10,72,43,5,225,250,191,234,207,36,206,42,184,184,82,208,225,176,133,114,227,193,143,13,245,127,157,116,7,74,204,221,207,194,179,214,78,116,115,106,129,19,99,88,242,203,208,16,34,44,136,16,194,231,101,23,185,39,33,198,13,23,221,208,173,213,155,202,78,118,45,83,170,254,143,226,210,33,248,123,112,132,150,254,74,176,99,54,180,241,191,157,178,235,170,202,101,237,209,228,86,220,138,199,184,178,198,180,71,2,241,83,207,27,159,161,80,189,27,9,1,27,99,175,237,254,129,233,34,131,121,93,44,207,184,106,30,250,206,142,241,122,44,254,140,120,120,152,105,177,195,71,16,15,159,128,141,37,196,164,63,134,164,186,237,122,164,99,25,194,125,181,90,252,56,13,33,204,142,228,236,26,107,148,167,233,76,44,74,38,226,140,252,39,187,156,104,60,52,111,3,250,168,248,246,149,162,8,30,214,20,172,138,12,185,205,103,89,42,105,22,183,24,165,243,225,46,127,45,169,93,77,113,152,93,161,229,85,72,113,138,44,175,33,45,191,160,101,213,50,233,138,210,69,121,88,2,49,193,252,142,12,123,21,130,218,128,88,31,87,7,44,124,41,231,164,214,25,68,167,119,146,147,201,156,235,126,16,145,154,177,112,223,16,180,131,217,191,99,243,233,182,179,251,160,139,199,32,120,126,186,12,156,18,138,28,235,50,140,6,254,129,238,8,64,64,168,92,245,41,176,67,46,50,105,175,27,199,15,169,248,135,223,237,163,88,180,61,228,37,122,14,198,134,75,28,247,232,211,62,221,51,50,182,196,136,205,202,181,205,8,221,50,105,134,106,56,84,107,57,244,28,98,74,22,201,205,247,22,89,35,64,149,227,124,214,112,185,157,69,52,193,108,28,55,54,160,37,36,229,80,84,111,252,89,57,217,9,20,158,218,88,27,8,231,189,30,168,60,24,222,17,48,149,41,239,94,253,235,13,106,140,144,182,104,78,1,208,154,108,111,121,90,128,0,233,67,177,215,76,174,196,53,10,57,103,227,235,208,142,29,56,254,30,252,41,120,85,63,131,236,1,57,172,89,60,140,200,221,48,128,212,14,35,38,72,236,15,162,151,29,91,150,218,188,66,111,46,122,70,204,136,20,191,14,154,250,155,0,224,144,172,70,72,100,236,254,57,4,37,52,131,109,44,10,128,117,0,38,37,255,217,215,166,52,33,21,55,212,77,190,47,31,38,145,32,171,197,104,217,100,54,174,206,5,15,249,83,217,30,107,122,217,128,141,75,98,89,154,89,83,193,229,43,145,175,228,254,198,166,104,87,105,191,195,113,236,218,200,186,135,19,24,163,207,76,132,234,144,118,199,99,75,153,122,236,13,40,93,17,113,167,77,127,43,205,14,162,142,222,236,17,35,25,55,178,48,88,161,240,115,7,84,89,141,47,74,223,139,105,203,137,155,24,88,224,184,174,136,78,100,5,124,135,236,165,222,191,233,133,100,103,109,184,34,143,185,19,211,37,130,141,207,150,202,196,121,88,199,0,248,52,144,217,235,26,176,18,175,127,123,211,148,83,144,65,138,220,68,34,198,135,155,236,128,21,184,158,92,199,31,85,227,176,34,12,26,254,216,181,182,4,21,11,163,15,23,13,228,198,27,241,69,55,214,188,70,85,122,149,218,175,42,121,138,161,11,205,230,164,169,177,125,187,170,53,40,88,156,222,101,16,221,138,230,152,198,16,56,160,236,15,124,218,73,197,81,196,194,27,73,80,0,82,219,181,183,6,237,35,151,11,228,254,66,252,92,173,232,102,86,24,170,21,28,40,211,239,255,238,104,60,10,196,82,44,239,127,226,141,211,135,65,126,70,49,195,162,64,143,37,239,2,71,132,178,47,188,224,83,249,37,188,177,114,101,187,144,206,218,198,233,158,20,65,16,251,53,93,249,16,137,35,82,89,88,132,213,62,56,19,179,2,33,75,53,203,80,246,200,110,84,215,231,217,26,107,179,161,114,18,213,234,236,212,143,10,15,1,230,118,162,202,172,176,128,177,185,102,231,14,247,79,39,30,163,56,249,109,198,227,87,47,196,149,75,9,139,229,107,238,188,10,99,222,56,245,200,90,61,216,96,72,94,43,178,41,183,68,22,14,197,111,81,142,118,80,221,113,137,121,34,134,135,24,181,45,9,214,192,184,178,128,234,226,123,97,157,166,27,198,118,191,65,29,198,46,151,68,208,188,172,162,79,66,154,215,237,102,52,93,53,75,220,70,148,173,148,96,230,239,112,205,196,222,123,115,183,173,124,148,109,192,89,85,152,119,193,204,20,215,110,122,13,126,218,121,144,158,65,90,110,115,11,136,140,12,54,237,185,193,44,21,145,217,89,126,14,139,119,209,39,133,83,223,33,103,80,237,208,39,180,149,65,151,234,74,207,251,3,197,133,93,236,142,131,43,112,165,209,8,104,215,255,198,149,218,196,28,120,0,133,158,253,49,80,45,3,185,10,66,241,125,105,81,235,253,215,225,168,108,119,64,78,248,166,59,54,89,57,69,244,62,17,79,93,187,154,164,169,242,153,58,238,129,75,90,150,163,26,188,148,53,48,56,108,31,6,238,75,136,237,168,109,88,205,127,185,61,121,198,243,22,34,4,143,20,150,60,115,4,252,94,177,150,155,246,179,60,69,49,160,2,103,112,239,0,171,30,4,105,183,203,121,20,28,187,44,125,8,59,34,19,166,108,22,66,28,227,103,76,223,27,195,61,255,32,229,86,178,177,202,135,222,48,127,171,162,77,128,43,139,232,65,188,172,165,213,178,94,201,106,109,26,12,26,60,225,150,112,66,108,176,160,218,58,140,111,48,111,29,7,240,28,111,99,91,52,25,126,83,220,46,159,195,85,141,160,102,193,198,129,119,235,206,108,34,55,29,188,72,248,156,131,123,227,22,68,144,85,243,183,78,77,84,140,203,26,254,134,241,15,23,193,32,28,197,1,240,250,45,95,95,240,167,141,78,137,152,154,121,170,114,237,183,182,230,159,40,124,59,61,109,199,216,80,156,186,67,196,179,200,8,231,224,139,208,218,233,122,207,156,234,184,7,1,14,97,41,132,112,237,134,235,41,9,14,251,221,116,157,171,84,220,29,138,236,237,87,55,79,138,232,3,85,188,244,246,78,37,11,161,16,123,140,89,95,122,116,30,11,125,225,153,45,141,71,89,75,51,117,77,250,0,110,158,178,152,162,240,167,178,92,132,204,11,179,141,216,24,76,109,85,83,166,16,131,160,112,171,83,29,154,127,150,83,240,91,188,251,231,163,127,35,53,227,4,188,217,135,228,229,56,209,101,194,198,27,170,152,29,198,78,53,142,138,154,99,144,85,181,213,253,104,224,249,140,177,206,177,107,5,229,119,185,46,181,120,194,95,127,34,178,51,113,150,165,117,79,61,116,88,228,151,218,237,60,250,230,73,156,36,173,49,4,217,85,40,110,75,28,255,22,215,97,217,91,131,230,223,48,159,243,80,70,145,122,17,160,27,79,141,178,208,196,192,222,170,193,211,85,226,241,26,50,151,31,186,189,103,75,83,197,191,210,157,5,138,66,176,178,204,217,102,80,190,82,24,220,70,168,157,149,65,174,69,241,194,31,184,92,164,8,174,226,22,160,184,25,191,119,50,169,117,147,227,90,102,99,149,233,193,109,94,90,211,96,121,229,231,137,79,154,198,84,72,49,131,218,33,109,98,250,201,67,49,176,4,59,159,101,183,61,131,38,49,11,58,250,199,204,109,219,153,121,81,141,164,0,145,86,106,64,155,199,4,209,74,218,209,91,48,200,231,188,47,179,172,137,96,69,207,143,26,1,2,102,170,161,173,150,253,176,44,94,48,137,246,27,171,14,48,230,16,103,104,5,58,74,75,106,132,33,163,60,163,121,160,21,33,245,116,74,223,133,174,146,56,188,18,50,105,248,220,205,233,132,88,124,148,211,152,255,245,50,195,50,9,148,90,225,180,240,170,213,244,21,179,255,65,122,59,195,226,171,159,199,128,68,121,46,216,51,112,207,60,227,208,219,136,198,55,202,52,11,233,133,175,174,86,234,103,13,140,39,124,86,13,158,86,201,19,157,181,165,37,51,184,178,221,212,164,207,228,130,26,97,193,140,200,246,146,115,147,41,52,248,102,213,170,235,238,254,94,113,166,29,253,90,27,124,42,167,211,43,37,164,4,102,55,25,98,85,178,245,117,243,20,221,37,29,108,203,1,41,67,234,76,151,201,182,239,38,84,29,110,13,29,7,133,201,150,136,208,141,35,101,255,18,199,67,151,144,161,120,203,220,167,243,236,165,9,248,151,3,170,11,41,152,250,73,160,140,149,45,121,201,186,187,139,154,112,253,196,129,165,138,9,173,100,187,234,211,238,104,120,19,222,188,66,195,67,121,21,153,23,103,255,190,40,115,141,23,59,217,255,59,210,45,65,68,216,232,204,125,100,244,241,164,224,197,57,151,71,213,107,149,222,3,35,48,37,218,225,27,35,225,41,164,129,96,212,139,239,196,218,79,126,63,118,234,208,51,214,135,110,253,132,223,225,42,170,210,91,177,206,57,237,6,43,58,220,247,143,143,119,172,158,73,41,128,209,144,77,108,74,217,225,122,151,93,114,144,185,56,42,171,42,219,225,151,100,253,134,162,88,38,25,244,225,225,242,153,10,254,200,79,135,60,114,241,143,249,223,245,159,116,29,76,194,227,101,117,20,6,243,99,40,218,27,164,235,181,230,150,105,186,6,222,215,209,118,236,121,195,230,144,29,35,38,32,118,251,50,137,20,20,113,86,122,168,250,200,45,88,228,71,120,233,241,109,243,135,93,34,99,67,112,128,32,183,208,84,233,204,111,25,166,187,168,138,96,96,32,14,45,174,161,179,133,12,116,2,73,147,21,210,174,129,50,17,33,118,102,46,52,82,245,215,93,51,120,175,221,23,147,40,59,64,178,27,181,193,60,153,7,251,191,237,219,146,51,195,226,0,56,112,123,68,162,43,63,241,45,190,252,187,238,224,146,198,142,108,204,165,61,152,85,12,85,226,129,89,171,254,232,251,176,104,97,123,133,97,29,227,248,59,21,183,186,37,226,5,13,214,112,80,203,206,243,104,199,48,232,101,106,225,76,123,80,105,252,10,249,255,33,49,160,145,137,199,166,234,203,61,18,47,7,63,21,43,247,142,37,10,136,43,109,83,157,100,91,202,187,226,24,167,37,217,222,221,56,15,220,251,32,191,47,207,60,41,237,130,98,15,31,250,248,61,100,229,249,99,39,161,216,150,248,157,15,250,72,217,178,206,212,1,3,23,110,250,6,102,176,1,69,81,38,80,47,145,184,20,217,83,10,3,255,178,244,125,42,24,149,82,249,158,182,209,104,11,154,17,165,79,86,255,166,46,43,85,111,188,47,48,159,98,239,78,159,254,94,131,139,46,1,112,211,252,228,184,9,239,122,239,6,136,151,4,8,149,167,21,83,117,208,226,21,119,243,228,207,29,207,115,190,196,176,132,151,231,154,228,136,17,141,15,215,173,217,108,167,226,54,72,109,159,179,157,192,252,149,215,160,74,199,123,179,8,37,15,240,240,153,240,56,108,64,117,109,149,16,74,219,215,206,12,29,226,176,59,45,168,203,229,27,144,196,57,203,201,100,255,121,80,224,145,99,214,109,110,63,94,48,108,2,255,172,166,169,141,214,31,178,94,250,154,138,79,54,204,13,200,56,200,7,154,194,72,192,5,198,234,69,126,56,68,196,191,190,219,179,220,54,97,199,222,82,232,213,116,161,139,130,78,77,98,200,67,110,54,204,178,145,152,242,85,119,218,118,13,168,163,181,176,211,163,160,153,131,47,224,70,65,55,117,32,107,116,158,145,29,184,113,248,137,104,238,226,2,254,214,191,205,160,185,31,89,188,125,46,116,161,164,57,188,198,109,87,168,45,47,93,20,171,141,64,202,204,65,76,128,215,217,119,60,176,3,120,117,143,130,3,61,111,80,107,96,78,62,103,156,59,13,225,213,149,58,52,164,6,26,96,185,12,222,245,68,234,14,56,169,87,64,108,140,82,78,62,206,147,11,121,69,212,56,156,143,113,101,107,170,217,124,59,172,251,160,95,68,245,96,12,25,229,135,140,252,8,168,3,199,254,99,160,242,195,149,104,3,96,157,217,80,211,167,187,251,208,5,144,91,246,86,69,28,161,69,189,255,225,243,153,128,63,178,77,207,19,161,146,29,128,143,26,46,44,11,228,111,43,152,88,17,244,77,218,203,171,200,118,39,105,86,37,9,89,224,101,191,48,163,80,71,200,48,212,213,217,78,188,0,210,121,13,52,18,18,197,49,234,97,246,74,214,6,188,126,13,203,158,185,97,51,100,5,192,237,237,146,75,212,64,98,57,60,98,254,165,242,181,99,198,178,13,1,163,231,210,88,233,214,229,51,157,160,10,12,54,42,59,64,86,81,253,188,41,175,119,173,173,70,159,82,7,25,101,143,193,75,210,204,82,62,231,253,138,201,204,223,251,209,157,63,59,105,192,173,34,121,196,79,17,125,241,229,239,75,161,3,19,88,199,191,57,0,144,156,154,224,31,214,170,247,143,17,135,50,42,197,142,19,3,55,198,157,35,255,167,0,31,172,111,144,185,252,240,36,81,220,28,100,248,230,135,210,77,189,61,54,3,228,195,106,18,209,236,170,109,8,229,218,96,229,134,73,0,198,165,45,173,141,206,213,186,208,80,24,40,16,208,122,217,105,219,1,196,187,2,149,65,18,217,185,121,64,30,204,216,235,226,76,245,194,4,197,77,125,81,223,162,255,69,174,151,109,210,201,94,59,218,98,160,134,228,150,188,65,73,124,235,36,184,109,69,68,243,61,192,123,75,21,95,85,175,115,64,90,140,1,253,80,130,46,174,191,189,15,14,6,181,224,179,247,174,242,215,233,186,22,229,59,221,118,218,154,179,66,96,199,227,88,46,1,201,56,229,166,87,222,145,77,137,114,69,135,67,250,137,101,50,28,161,105,7,171,224,30,156,207,169,92,78,99,47,103,132,102,231,86,16,86,238,201,14,146,153,0,159,75,41,103,219,92,99,68,74,152,39,75,169,73,36,105,104,135,163,132,154,77,83,34,34,232,239,121,183,83,223,56,232,24,60,46,217,241,241,169,5,149,132,89,131,240,126,155,29,142,91,107,224,161,74,144,91,147,110,7,86,208,105,28,79,175,52,219,159,65,13,208,122,66,169,206,213,43,153,139,174,36,128,9,0,12,111,150,238,85,20,13,65,96,143,189,206,94,237,156,165,21,158,206,222,42,15,223,74,137,174,80,148,7,242,121,249,247,66,235,198,52,86,59,27,38,119,255,57,227,194,74,35,28,136,199,161,254,143,143,146,87,100,214,137,93,246,168,220,228,43,73,239,96,53,10,153,250,82,44,234,191,28,57,132,24,131,106,244,7,43,186,139,31,31,38,251,123,4,215,157,208,34,127,231,109,160,215,190,21,251,98,5,114,177,164,136,27,12,46,176,144,160,41,151,248,121,225,93,79,247,114,223,72,160,218,172,56,167,15,202,239,180,195,138,246,125,32,235,125,224,83,116,241,61,198,112,56,253,207,96,159,78,83,105,104,150,22,224,141,167,198,189,202,78,116,109,241,150,62,97,152,70,61,140,1,123,105,81,2,75,242,246,59,23,28,106,84,58,182,82,16,94,122,171,234,230,71,55,179,119,61,241,154,111,150,195,74,241,41,179,52,145,174,50,194,36,96,141,111,130,149,235,48,226,54,28,247,240,246,48,13,217,36,2,13,220,128,95,226,232,65,159,205,242,155,177,200,43,228,243,201,75,231,165,126,228,57,107,206,199,155,193,160,167,183,71,132,89,116,219,224,152,9,137,242,213,62,161,159,251,25,182,154,217,189,139,43,126,211,35,190,71,13,87,25,53,68,85,250,236,208,186,60,162,130,45,107,148,247,98,122,102,217,7,211,86,234,137,206,36,151,56,43,48,47,105,190,203,126,134,145,70,26,84,232,246,203,127,225,75,69,222,216,63,216,251,36,159,40,33,85,162,76,216,197,225,15,204,6,153,178,220,187,137,31,130,57,83,168,106,161,236,51,188,120,87,198,118,174,145,153,165,154,199,25,45,226,112,89,181,106,111,85,105,125,100,219,224,124,10,214,15,248,184,39,67,60,54,33,255,222,212,126,92,142,161,100,7,196,139,136,243,113,209,223,248,151,8,119,164,98,206,120,145,214,22,58,155,55,221,94,178,32,240,81,126,249,100,151,172,160,228,172,60,68,57,79,32,110,238,148,28,180,11,184,28,176,141,50,74,45,114,56,168,173,38,95,21,95,14,36,63,53,94,186,136,186,195,91,227,0,87,14,202,248,29,182,9,22,129,141,171,22,168,184,198,121,146,4,148,53,22,173,61,43,116,0,183,24,132,51,207,104,127,59,134,22,207,40,21,13,44,169,98,130,191,130,7,89,247,238,204,120,211,109,116,150,167,39,15,92,39,215,111,62,242,54,47,189,138,83,22,33,194,9,184,10,194,70,248,105,237,175,67,21,128,243,230,198,205,139,117,70,229,45,86,197,173,188,88,193,232,42,44,213,242,231,156,78,134,188,77,237,221,203,167,115,96,162,252,44,24,152,145,91,23,158,203,167,21,152,18,85,167,191,60,194,211,252,138,210,125,25,93,128,65,56,203,224,133,8,116,142,29,139,155,14,42,37,232,252,156,17,110,50,31,217,182,135,230,103,33,183,40,22,41,139,191,173,24,34,123,158,156,186,148,198,174,102,46,216,195,209,20,163,64,93,177,84,159,222,138,100,80,138,250,83,205,161,136,219,93,250,163,179,16,2,95,188,75,200,75,204,0,160,20,26,182,246,62,179,43,139,129,51,150,239,247,180,255,82,255,5,142,81,200,171,177,244,228,53,220,190,65,98,162,201,35,39,181,11,239,108,3,49,133,26,203,203,87,17,54,5,30,245,153,243,156,204,214,150,186,52,195,12,112,212,12,206,129,204,232,58,210,190,199,229,105,111,163,152,182,182,188,132,193,141,188,231,209,49,44,209,205,7,206,80,104,145,205,108,197,20,65,47,99,130,218,44,126,218,22,198,225,88,197,86,212,227,149,153,93,249,165,222,171,174,57,213,246,185,135,97,12,177,200,252,108,110,152,105,210,55,209,180,20,156,84,31,78,67,171,139,82,143,181,180,174,18,208,52,29,204,134,220,152,243,203,111,203,178,208,79,234,173,36,38,13,101,219,59,187,29,23,165,214,119,72,53,90,197,213,189,152,168,159,150,183,37,77,129,141,208,139,90,221,187,41,210,62,20,27,143,191,22,243,233,108,65,104,73,73,16,166,180,49,167,156,111,208,237,218,108,145,94,237,54,104,110,76,219,97,130,180,113,206,122,217,134,14,112,230,133,20,89,52,35,99,100,202,75,106,1,30,55,242,155,48,175,118,141,37,250,66,68,161,154,187,147,194,47,253,127,149,204,215,137,110,235,9,167,66,21,173,206,72,149,73,95,185,0,14,189,137,188,53,86,0,150,217,137,96,157,235,159,29,112,200,4,233,231,228,239,137,42,90,138,245,219,172,218,175,255,60,14,173,231,16,155,157,182,73,83,40,236,100,72,163,227,99,235,108,98,132,167,22,247,155,202,121,223,119,178,103,95,137,215,8,35,163,216,141,75,40,22,85,129,95,145,199,64,116,125,29,57,65,139,232,128,148,96,198,204,139,206,57,50,143,29,30,115,92,179,24,36,62,40,46,25,104,42,239,140,72,101,51,253,131,149,167,8,37,171,233,202,153,150,45,115,140,117,253,121,110,191,34,239,154,75,187,205,32,132,28,111,151,204,40,4,225,82,201,31,51,241,27,138,229,244,216,23,28,225,164,77,11,185,76,86,9,39,108,212,145,19,60,177,244,24,114,153,114,59,164,109,218,41,168,209,202,10,64,38,200,176,246,98,79,27,11,217,85,114,134,135,253,57,81,144,75,218,180,14,42,157,186,126,33,52,255,190,34,236,12,118,113,138,43,115,44,190,7,216,164,43,48,132,237,18,151,31,125,38,110,82,132,41,186,211,38,226,169,154,106,96,174,242,216,142,127,121,191,95,142,100,201,123,254,101,81,166,117,1,97,110,153,66,147,248,145,174,118,10,112,3,188,140,31,216,230,11,136,154,34,115,89,99,178,211,145,134,15,95,163,115,254,84,130,217,54,224,24,207,204,57,146,221,112,48,207,222,248,31,117,201,30,153,159,123,177,253,31,163,237,140,177,77,165,2,225,98,3,186,133,52,42,159,221,92,105,94,248,159,198,225,51,11,44,22,37,72,48,201,158,37,70,210,175,48,221,164,130,1,20,237,4,15,254,182,8,244,138,90,163,23,211,223,225,42,25,68,29,193,102,165,43,165,220,92,50,129,176,55,118,107,199,114,15,67,163,191,1,233,183,217,208,251,11,60,184,29,136,200,113,249,44,194,224,29,60,193,230,94,225,193,72,158,88,112,60,202,174,76,55,205,186,106,178,93,23,67,140,252,113,216,223,249,128,59,40,95,206,137,139,206,120,53,109,73,230,29,30,98,123,30,105,121,188,134,41,68,250,183,46,12,170,7,145,212,100,215,35,152,138,17,26,183,112,71,48,213,244,210,131,74,132,82,115,74,129,131,91,51,129,147,66,197,146,102,12,122,73,205,177,14,73,122,214,37,52,122,10,236,199,214,6,25,232,228,188,171,47,233,25,63,236,50,230,45,51,64,7,111,234,153,168,161,100,118,180,38,87,118,206,35,238,102,238,254,91,240,217,117,167,196,163,87,68,202,158,14,16,131,255,187,184,158,173,130,65,159,207,123,164,168,134,254,9,48,57,124,210,135,253,58,26,226,38,246,205,89,240,171,2,171,19,83,160,249,131,8,178,142,107,184,85,35,238,188,184,211,208,134,199,210,142,238,160,137,46,200,91,114,159,106,150,150,20,51,34,175,170,31,180,216,132,231,0,96,211,166,191,33,170,99,51,112,192,57,86,199,26,7,181,152,94,37,182,185,137,51,169,3,93,39,48,213,45,147,163,223,159,171,164,252,14,205,105,50,33,113,1,151,46,160,208,92,123,103,125,93,61,196,79,166,9,72,55,203,129,53,159,161,153,130,178,192,159,34,69,37,36,222,95,74,46,109,91,57,119,209,137,34,255,69,150,33,76,100,153,199,73,151,244,59,243,17,218,106,28,101,45,249,217,41,125,87,38,52,57,144,195,26,250,147,40,128,21,84,216,21,110,47,129,99,151,196,113,2,50,200,252,77,128,4,58,187,111,144,250,63,87,120,32,46,25,4,95,197,87,139,125,156,239,45,103,200,151,234,61,142,129,206,35,112,229,37,109,133,252,124,222,110,115,241,47,22,194,99,147,73,98,104,17,67,147,8,238,144,176,222,172,44,110,196,28,202,224,120,194,62,81,116,184,77,192,6,21,186,67,252,39,33,204,57,95,19,3,247,2,3,219,237,106,166,49,146,250,44,127,153,106,122,127,55,164,43,234,131,205,58,103,125,15,182,160,209,93,71,9,17,249,156,147,48,144,16,246,172,100,33,168,54,110,152,35,2,106,166,186,84,234,230,88,222,58,130,246,243,151,136,114,82,65,178,107,169,160,215,37,22,147,51,182,251,11,163,67,101,111,42,213,250,126,52,77,102,168,38,26,203,92,98,172,169,12,97,5,36,200,226,215,118,15,147,92,190,81,112,136,57,48,179,159,228,181,22,144,121,218,181,103,253,192,239,58,54,115,230,246,167,241,248,38,163,100,222,56,6,183,89,150,208,18,235,76,195,137,164,12,26,7,225,201,115,123,65,197,210,250,16,202,21,185,155,214,38,158,134,134,108,172,11,138,236,190,140,127,27,49,16,186,255,13,135,204,242,251,243,162,83,128,157,62,67,30,113,97,40,191,224,205,249,151,159,70,132,81,20,157,230,188,236,2,36,100,204,129,15,205,171,62,186,112,153,245,243,147,57,34,204,250,45,171,41,218,38,49,239,111,5,119,238,163,178,149,244,0,246,27,225,249,200,90,211,54,104,46,142,69,196,216,188,221,252,88,30,238,39,179,187,154,154,253,193,224,67,141,169,97,188,103,5,160,45,151,92,16,50,237,141,152,27,252,94,156,14,119,236,145,48,94,67,32,37,141,53,117,215,119,72,166,55,203,94,146,44,73,142,41,247,229,192,30,204,107,225,94,216,176,80,115,222,55,63,124,200,215,9,130,110,7,6,59,96,13,170,235,50,72,167,3,117,81,92,179,250,181,6,249,136,29,208,45,157,225,25,209,164,48,62,38,225,5,54,131,234,90,196,179,11,245,204,201,245,43,14,176,191,20,1,21,253,148,205,78,73,251,31,152,47,201,124,116,254,44,245,41,165,67,234,26,220,255,121,129,164,180,130,225,89,174,0,36,184,249,246,109,152,5,8,127,182,33,77,21,242,61,147,102,172,149,193,199,73,154,34,123,217,69,236,125,193,204,66,148,133,75,151,98,160,250,42,46,178,104,10,33,118,23,146,194,193,184,97,110,156,47,96,227,236,118,172,22,241,16,65,221,149,243,32,14,106,164,230,72,3,61,240,15,213,248,214,228,217,142,94,132,64,70,247,157,80,133,235,150,208,48,79,152,246,144,41,81,86,125,189,78,27,233,175,60,202,236,161,242,191,130,150,255,249,3,26,244,97,152,242,156,186,114,98,101,200,117,194,101,65,128,200,245,207,207,146,126,241,17,239,234,246,236,208,103,168,156,253,104,96,93,129,90,134,108,89,9,118,200,29,46,132,130,239,170,56,191,35,100,153,119,25,96,27,12,99,168,80,150,122,221,97,173,244,68,205,175,251,77,82,6,210,92,34,212,109,113,65,91,38,27,203,74,158,177,67,61,16,255,117,228,231,169,91,13,248,36,149,62,190,122,97,22,56,204,250,227,170,158,91,184,77,139,3,43,253,160,210,155,232,74,112,126,97,166,13,165,170,255,22,115,212,177,18,204,249,105,26,102,35,232,59,16,159,200,157,206,215,34,34,36,35,192,51,125,163,62,20,242,225,239,77,115,191,93,84,85,19,167,188,255,2,46,76,29,226,53,92,237,214,150,58,162,245,11,70,89,143,78,196,233,168,227,138,26,128,131,109,133,70,216,129,129,22,17,98,159,150,228,17,58,17,185,173,162,211,119,82,114,191,204,183,3,181,21,8,14,63,137,202,11,152,219,29,164,255,237,118,43,59,60,136,136,244,39,70,211,162,26,253,12,154,240,179,3,225,195,56,222,23,134,62,55,61,24,131,32,10,234,192,237,4,203,164,59,162,58,91,184,25,226,189,136,236,217,19,166,151,127,209,186,83,178,70,91,5,201,107,235,118,158,190,133,106,214,232,33,236,170,133,113,136,135,94,7,122,29,206,213,28,134,241,74,208,190,168,74,48,23,230,202,85,21,11,154,130,28,81,84,217,8,182,253,198,198,146,146,44,173,252,51,222,242,105,226,70,18,251,149,58,164,253,255,45,44,202,31,179,135,118,33,112,124,168,137,12,231,129,242,219,146,159,76,237,187,188,124,42,164,123,85,86,147,48,195,16,239,0,108,122,83,209,43,120,35,80,220,144,68,7,207,2,27,75,115,34,11,179,112,125,145,188,106,124,78,152,103,62,67,157,76,206,121,151,163,175,84,46,232,101,95,234,238,87,26,81,248,228,99,121,111,103,11,21,244,163,216,193,135,44,193,218,76,104,240,163,145,21,95,217,218,224,150,28,42,126,119,0,139,138,140,117,31,132,35,165,205,163,69,218,135,203,233,204,129,117,115,109,180,1,219,49,207,176,3,30,153,216,78,175,130,126,94,206,86,12,150,70,190,78,212,242,65,53,49,105,197,245,110,57,150,200,75,196,239,180,132,10,200,124,92,116,190,105,107,237,43,61,209,228,175,56,248,152,28,41,176,118,120,134,194,95,82,51,30,143,60,163,227,102,16,46,122,229,132,125,35,27,197,189,41,38,117,125,108,128,128,125,38,138,116,145,82,199,153,175,20,193,243,214,93,90,185,105,25,207,181,135,209,211,139,248,120,149,74,27,128,11,59,130,63,169,171,183,132,244,200,55,33,65,226,110,85,44,224,195,187,157,204,217,154,57,33,69,232,212,215,160,110,79,99,112,179,0,239,23,230,1,56,97,19,176,242,239,209,192,29,160,163,16,48,118,223,197,163,181,192,11,81,86,238,37,4,173,247,10,229,123,207,247,17,125,98,58,117,184,149,194,238,105,159,237,22,69,178,127,155,211,193,18,185,184,74,194,191,246,95,26,47,86,90,224,209,136,150,196,245,196,87,34,155,128,45,51,198,201,34,60,61,154,246,113,115,87,93,222,23,24,116,142,153,222,195,111,186,157,8,242,138,51,81,149,160,220,79,184,148,208,103,249,251,250,37,122,254,36,205,195,173,14,209,112,49,49,247,171,228,26,177,31,162,155,42,193,132,23,152,238,142,132,171,54,94,205,39,170,25,218,52,194,38,49,100,92,230,226,243,39,23,189,194,147,206,182,139,159,124,32,121,248,65,98,80,205,30,112,215,209,192,33,160,65,57,139,153,43,78,66,34,45,232,25,12,192,153,73,122,58,8,249,81,131,103,106,214,88,22,62,175,183,137,89,81,0,90,1,198,233,158,55,68,147,60,71,135,136,141,80,165,247,225,174,93,248,200,154,202,233,16,118,161,38,246,210,250,193,248,223,196,43,178,172,74,36,29,101,125,163,243,243,250,235,29,244,244,144,238,254,105,17,224,102,171,163,91,232,231,230,157,76,16,98,96,146,61,183,149,58,146,15,134,53,127,133,10,243,105,85,46,78,21,76,254,6,49,123,224,5,1,115,150,73,92,146,20,239,97,207,237,245,36,88,193,248,180,63,83,144,133,235,178,164,18,137,193,77,78,203,129,145,32,127,7,56,92,105,93,232,60,236,34,47,143,215,69,35,69,44,202,102,83,93,115,66,47,119,57,145,141,147,212,93,139,156,12,88,83,42,188,125,89,199,82,221,90,51,178,36,91,129,47,202,217,39,245,38,6,82,51,2,52,102,3,61,122,236,152,228,77,111,31,220,85,235,83,157,222,23,137,80,54,122,8,216,111,82,142,87,123,197,44,154,123,251,81,183,95,92,53,33,167,226,70,167,157,193,30,6,238,220,176,57,52,202,221,29,202,160,20,46,17,143,245,80,186,45,13,98,250,9,232,68,38,33,201,164,219,229,3,71,91,196,195,113,33,44,21,227,54,109,119,86,149,121,93,205,7,49,120,179,180,200,205,198,52,91,79,245,9,33,184,190,252,234,43,212,210,139,40,251,8,174,59,228,26,246,170,169,202,135,46,172,221,214,239,160,77,205,197,174,6,165,53,109,149,8,190,205,16,98,240,27,167,248,217,154,200,246,236,36,156,131,138,197,84,67,4,9,251,179,194,12,106,38,8,46,144,76,24,208,84,21,75,8,35,64,225,163,220,14,220,14,219,163,202,190,51,119,149,145,146,84,59,81,170,233,176,236,17,141,73,66,33,81,13,93,154,171,228,248,95,68,130,195,62,21,215,45,35,190,233,86,90,1,153,59,97,80,33,12,39,84,108,70,130,61,160,15,193,103,68,45,28,233,99,121,211,103,182,183,14,253,121,188,67,29,190,107,102,84,98,84,23,83,174,208,150,108,252,165,166,177,148,29,200,219,177,171,33,159,162,8,191,173,45,158,0,128,216,56,95,236,81,20,13,32,193,43,170,225,236,132,21,234,23,113,119,161,192,53,26,214,5,223,62,106,154,15,101,191,233,131,171,147,128,21,84,202,93,52,35,104,70,90,79,12,5,59,100,107,238,6,150,95,186,52,153,9,46,62,132,70,91,88,212,12,99,104,235,21,166,26,46,135,123,238,182,14,217,200,52,233,45,208,30,246,153,234,30,238,176,216,142,236,210,239,69,186,232,79,184,96,71,211,88,13,217,185,244,159,151,92,54,168,212,16,228,116,228,96,235,21,57,240,227,37,100,200,37,0,137,142,73,53,13,30,171,160,31,219,98,64,150,212,91,98,214,204,219,191,219,182,216,204,195,165,23,19,254,152,44,42,121,229,198,2,211,77,255,92,85,23,230,138,179,48,78,156,131,114,79,94,246,95,125,40,134,151,82,1,128,165,138,136,27,246,196,246,223,89,156,208,234,195,176,65,173,231,62,83,207,232,6,211,37,116,67,109,180,116,129,107,34,32,195,106,47,57,104,68,203,110,223,233,15,157,110,190,36,66,189,132,233,16,211,17,104,203,133,52,100,14,85,154,28,248,64,144,77,120,228,133,228,97,135,70,93,80,133,181,0,185,86,18,9,133,97,141,170,123,101,173,50,98,12,251,10,23,156,230,5,10,53,147,153,94,182,145,87,202,248,27,130,8,161,117,83,135,239,207,91,128,143,238,41,221,227,18,113,104,33,180,150,202,181,160,75,13,206,0,83,9,25,163,22,164,196,175,69,133,134,34,166,171,145,80,107,177,175,37,209,101,86,130,138,242,220,128,14,199,134,66,34,231,123,41,30,208,227,169,159,36,231,218,211,103,175,254,254,56,198,88,206,236,10,160,168,166,107,175,82,46,25,171,142,154,21,236,173,111,181,152,41,242,41,145,22,185,137,132,5,206,101,79,204,175,3,148,120,63,185,44,130,51,135,188,7,183,172,155,200,90,120,134,201,26,30,6,142,173,175,143,151,107,61,21,224,253,155,55,96,166,196,248,199,181,231,65,55,6,90,76,88,233,210,118,107,91,65,96,196,58,0,107,125,29,62,51,20,184,69,218,157,183,118,91,147,24,152,41,46,192,12,107,25,165,89,11,196,199,203,202,111,105,55,146,255,110,72,109,132,242,85,253,240,218,125,112,60,187,25,253,186,51,77,55,41,66,171,227,236,110,177,206,87,67,254,125,148,48,146,105,176,69,50,142,87,236,153,246,6,46,63,142,8,155,30,2,201,197,51,58,4,100,58,175,210,254,118,172,187,21,42,150,21,231,200,246,76,108,150,205,115,94,166,190,1,206,235,190,204,130,130,197,2,88,225,187,168,0,107,0,131,191,95,142,97,210,47,20,47,3,254,117,27,114,244,76,20,172,157,57,116,248,141,38,232,18,78,92,244,53,254,127,6,126,33,192,90,58,72,74,124,0,214,85,32,21,52,85,102,133,185,25,223,128,31,96,25,205,72,216,4,155,156,108,225,117,197,56,59,124,63,61,247,19,216,190,208,176,27,105,153,238,65,157,141,157,51,211,98,153,207,86,167,37,210,71,238,13,163,106,187,104,7,0,146,233,74,228,165,67,199,247,177,121,76,112,41,93,228,19,47,102,59,162,245,152,62,163,134,220,225,215,94,218,52,137,28,35,201,130,206,103,68,142,102,68,35,24,25,190,47,150,17,62,19,239,214,239,214,191,19,134,187,74,3,47,193,116,138,19,128,252,141,198,39,175,129,207,27,172,48,98,213,42,167,110,241,52,182,229,220,16,110,58,129,82,33,143,192,106,60,247,191,89,158,70,203,7,221,121,99,199,10,254,163,221,114,61,106,66,197,218,132,147,236,141,105,183,52,203,79,120,96,56,233,30,75,47,90,65,244,58,181,158,116,207,200,65,145,35,144,14,57,10,228,254,201,82,57,147,222,172,142,87,135,86,177,31,151,87,49,235,113,103,6,61,139,68,21,165,31,99,236,192,80,206,120,147,146,15,201,2,170,237,100,185,126,18,170,223,162,56,88,90,153,46,25,99,30,50,133,79,233,51,219,229,28,63,118,137,85,18,226,159,115,39,64,243,39,72,173,89,107,161,71,15,76,65,130,189,41,157,0,115,21,148,105,42,90,74,105,173,20,155,75,150,74,132,126,243,78,221,245,169,238,42,121,171,181,117,116,218,89,31,203,42,178,201,204,71,116,126,50,59,154,213,150,90,66,68,132,163,30,160,107,41,61,221,17,137,82,254,218,50,126,234,218,76,175,74,216,102,137,197,244,147,190,214,253,16,229,188,53,127,117,180,19,123,23,194,44,27,11,46,158,239,233,71,185,222,158,240,171,189,140,206,119,217,180,45,125,236,127,128,242,66,33,65,107,46,6,236,120,217,86,48,252,23,163,37,64,3,189,163,227,92,120,154,108,75,89,190,241,140,30,100,94,23,119,117,208,106,96,35,89,4,57,4,206,39,100,15,206,2,178,18,238,53,41,14,84,93,115,213,48,125,151,207,238,7,37,241,229,142,108,112,57,18,67,204,78,177,136,137,123,156,111,12,146,219,152,125,36,24,121,237,108,233,80,183,88,128,73,5,54,74,80,251,157,141,3,8,122,253,213,35,70,211,126,156,53,85,224,74,94,146,101,10,47,134,199,80,235,114,170,74,223,205,52,128,154,109,75,11,186,192,188,187,119,119,45,201,95,245,163,114,228,128,147,46,69,60,55,39,53,149,224,205,143,77,148,187,161,78,211,106,84,192,195,191,32,160,14,81,222,232,24,225,138,71,178,154,9,84,31,164,64,209,253,18,28,192,122,25,13,82,199,140,135,147,4,38,18,198,131,130,51,8,75,252,5,167,226,137,84,172,62,163,250,118,175,78,170,94,126,149,200,199,16,101,154,184,72,106,72,111,41,240,85,74,182,12,208,29,181,152,167,226,170,16,253,189,169,174,46,62,164,71,52,204,65,229,226,142,211,3,33,183,10,210,200,183,56,8,128,240,207,245,148,129,5,184,252,34,141,242,209,143,196,208,51,244,73,221,174,23,24,202,21,21,116,157,93,164,249,190,15,56,22,150,220,224,229,43,140,21,136,228,133,162,159,143,93,200,127,161,65,1,207,189,25,93,235,181,95,123,130,80,104,221,131,41,4,215,243,92,250,80,182,81,52,204,153,51,66,205,228,130,213,178,18,127,155,90,209,15,102,83,39,176,65,201,65,1,23,96,134,35,21,3,106,73,34,129,89,180,25,18,114,41,9,181,242,9,184,127,159,188,129,29,47,248,12,215,136,230,128,162,58,99,189,94,42,253,165,180,177,62,168,59,57,164,90,170,125,162,113,35,185,62,235,243,112,139,195,188,253,152,116,169,55,41,210,94,59,51,194,204,166,172,123,56,116,182,223,166,239,214,229,20,140,152,228,29,152,4,60,34,3,54,137,56,149,24,238,171,144,32,104,187,65,174,252,76,163,253,58,25,227,253,45,223,18,221,54,113,32,219,226,15,15,63,5,97,135,89,225,182,190,50,109,213,218,214,73,177,212,137,102,143,192,12,38,199,175,250,210,71,163,63,16,112,21,23,8,37,52,65,156,121,119,79,62,98,37,148,97,132,109,66,98,220,12,61,73,172,211,120,94,144,124,133,46,121,65,136,43,173,242,252,51,156,226,132,229,122,200,245,247,240,235,20,132,249,38,33,243,108,245,37,252,72,99,111,236,216,26,109,107,3,245,134,121,46,48,95,221,122,56,47,64,135,145,134,98,0,140,129,191,25,34,44,123,33,88,212,2,112,140,192,103,71,153,18,35,173,67,11,80,10,166,205,25,17,94,118,124,125,184,192,181,242,128,240,24,14,32,175,212,37,253,42,158,59,11,179,246,161,99,252,42,145,99,187,182,64,129,16,122,202,117,229,45,43,191,245,111,74,184,245,175,173,11,6,250,171,65,135,220,63,53,103,31,114,149,94,143,21,121,89,15,229,144,89,158,174,163,66,184,157,27,44,23,124,48,86,155,60,135,69,138,145,246,108,164,62,18,253,7,174,6,62,209,181,89,201,163,48,190,36,12,67,119,82,219,58,6,147,142,118,165,188,107,187,34,94,125,75,65,57,196,105,222,149,4,245,208,149,26,179,102,38,157,135,16,19,153,78,119,229,142,66,39,41,240,189,139,121,155,87,153,203,230,247,57,75,237,3,22,254,78,253,243,195,145,243,199,226,219,108,109,48,201,126,120,62,206,196,46,36,240,17,223,128,240,123,125,122,129,31,100,147,126,155,101,136,241,191,184,245,235,237,84,178,114,126,194,219,113,134,1,50,240,121,81,99,69,50,204,180,68,248,46,176,249,5,34,40,80,224,109,123,158,115,243,55,120,227,252,253,26,151,88,131,55,91,68,24,113,195,226,66,192,77,14,232,82,162,252,135,61,146,8,2,25,85,111,153,243,104,166,168,95,105,241,142,129,194,225,95,22,79,99,213,31,195,27,71,211,244,136,206,168,117,247,138,203,194,114,173,5,112,149,83,186,189,170,111,82,141,90,170,224,166,65,113,142,77,32,70,50,85,175,23,43,117,192,97,198,138,78,173,103,113,109,63,112,55,178,148,72,187,117,130,252,105,110,158,35,192,47,15,46,205,229,137,112,170,169,171,43,167,131,91,77,241,51,116,66,237,223,95,238,230,19,252,54,128,153,60,218,59,52,106,231,242,145,19,172,124,66,93,63,233,69,182,54,33,228,247,51,82,111,151,137,196,58,42,142,43,216,71,177,40,196,230,176,176,182,175,183,48,8,168,170,176,206,31,8,58,137,225,118,52,143,186,142,254,145,244,96,11,110,103,141,249,44,70,12,23,240,228,249,238,105,107,13,29,211,214,27,80,10,40,230,181,135,30,167,186,97,101,53,109,178,239,77,138,64,213,25,189,86,209,238,249,20,60,117,3,77,28,64,199,205,190,97,60,250,111,167,221,157,203,23,2,36,120,254,64,210,124,70,143,251,187,73,38,177,23,245,90,205,92,132,17,151,64,46,202,221,117,127,199,250,169,22,102,142,131,99,97,46,169,133,178,18,77,243,78,211,228,251,37,136,250,42,15,199,250,73,89,226,51,213,112,55,59,62,118,174,227,202,84,250,227,89,230,159,39,83,125,21,158,12,101,52,43,37,96,76,122,160,74,210,61,181,182,19,200,183,219,240,177,35,11,243,127,124,25,27,121,41,29,38,163,22,218,183,74,58,253,39,166,203,126,168,140,223,75,9,145,74,248,164,222,222,184,9,95,113,10,60,196,144,170,213,123,210,230,112,150,53,87,102,187,223,14,228,43,137,217,115,79,83,23,198,116,178,101,174,169,225,160,102,138,247,220,231,69,159,79,105,247,36,155,49,166,168,224,83,68,113,115,14,206,170,246,164,134,110,124,181,54,189,233,216,93,186,213,192,124,93,185,204,79,40,178,117,67,65,117,208,198,108,226,14,243,56,158,61,253,7,17,93,54,10,30,177,137,23,173,58,37,61,122,171,57,23,225,227,46,165,136,29,31,51,121,147,201,156,70,54,207,250,109,51,47,32,78,141,247,210,95,158,179,141,249,185,200,77,226,67,163,184,101,147,181,183,98,67,59,245,2,80,133,2,191,246,136,135,129,139,112,126,200,214,194,106,237,150,18,101,61,219,57,78,237,10,162,254,211,249,112,37,61,245,143,204,168,124,187,243,92,231,216,217,228,225,134,94,239,228,69,116,221,255,94,109,235,175,89,96,90,40,147,211,177,65,195,12,1,168,151,228,153,41,45,227,127,67,132,48,200,58,28,219,137,188,170,158,72,2,64,198,148,25,27,246,242,185,13,28,176,12,191,50,26,68,29,157,142,227,129,145,5,41,211,141,242,53,170,20,237,180,60,210,62,223,122,118,186,168,93,207,52,124,32,115,153,113,40,250,44,33,186,0,129,187,63,46,161,92,93,9,209,77,91,57,76,20,134,236,198,172,97,40,199,245,64,37,221,52,96,169,178,191,95,235,203,220,123,81,127,75,151,46,54,46,114,235,109,7,15,106,178,70,52,46,206,37,155,72,77,88,90,148,10,7,215,93,86,84,20,241,100,65,225,174,188,102,27,96,54,177,184,175,164,158,131,5,149,231,19,148,30,187,90,204,157,56,216,64,188,250,100,100,216,43,178,94,150,188,225,153,60,89,169,157,59,237,226,204,173,139,24,159,43,117,158,122,96,170,53,126,60,73,128,228,198,233,225,124,230,235,137,200,145,143,187,238,52,162,240,247,239,206,70,87,28,58,200,163,144,53,107,4,68,97,187,152,43,236,131,212,187,101,12,115,123,110,175,239,30,118,146,27,34,214,177,196,128,19,51,27,99,0,154,67,47,101,59,69,106,223,161,163,134,238,105,221,16,127,206,219,117,205,222,114,97,98,42,4,159,202,222,36,146,125,8,52,34,215,79,51,60,85,187,23,52,155,1,1,86,20,162,85,85,152,212,254,14,164,191,74,167,36,231,79,169,73,192,243,210,21,14,142,131,6,67,159,137,112,66,198,106,240,21,180,85,103,88,30,41,95,92,175,33,159,153,91,189,228,120,108,30,33,58,10,76,68,205,77,110,232,33,48,182,35,42,199,181,18,76,63,145,121,211,165,104,15,112,40,156,130,147,238,200,109,195,39,74,29,145,178,188,50,39,39,132,32,252,253,161,30,85,58,146,98,35,8,239,40,228,220,32,17,224,23,220,239,181,197,196,124,217,35,41,127,255,91,53,53,50,10,216,250,189,134,91,51,89,113,118,162,146,183,167,183,233,80,147,176,109,121,224,206,78,158,186,47,176,129,176,214,211,131,29,61,14,109,146,23,164,28,10,252,131,53,168,146,207,7,213,4,106,245,131,80,252,140,158,225,34,49,253,139,247,40,102,240,130,207,246,23,106,91,241,43,213,59,1,92,75,96,43,29,59,202,205,249,151,111,145,233,202,254,204,35,226,168,51,122,36,142,188,254,139,86,105,1,168,222,194,27,67,67,50,108,11,130,134,173,66,4,151,251,53,156,237,232,62,77,188,123,201,184,22,9,79,72,10,79,160,146,101,250,253,94,224,128,177,26,255,23,182,114,96,162,252,120,47,207,173,133,143,96,136,203,175,240,60,124,160,200,17,216,1,118,142,177,14,91,198,89,246,0,194,83,151,8,148,40,170,131,220,139,3,113,190,163,86,121,198,195,59,237,251,158,92,185,161,10,207,198,67,144,47,77,211,220,133,147,113,139,245,38,199,254,18,51,102,90,222,226,141,244,99,48,212,158,48,147,109,150,126,104,220,180,238,230,56,140,219,240,234,236,240,51,38,184,237,179,50,96,185,41,155,157,243,239,231,80,102,17,220,88,81,240,254,108,165,232,10,0,169,58,65,38,123,114,20,177,92,166,218,188,109,84,64,74,175,100,39,195,156,46,131,16,20,225,54,97,16,14,170,129,94,81,243,149,110,113,2,237,76,98,204,28,45,26,252,13,19,69,88,22,81,240,14,10,161,120,245,72,27,127,20,103,103,33,131,128,7,9,188,92,51,99,164,67,243,14,51,197,253,53,64,142,153,19,224,1,138,33,100,39,14,254,29,57,120,252,173,159,187,227,126,203,2,142,138,116,70,232,229,96,254,2,122,2,96,233,23,31,69,231,209,8,212,170,102,110,252,246,94,92,135,106,232,180,117,111,109,51,171,211,118,205,31,36,250,181,128,223,20,179,34,156,124,8,137,110,3,78,160,63,84,29,147,143,127,175,166,95,180,93,254,45,125,12,190,218,214,71,153,171,116,213,172,10,214,205,215,193,52,12,147,214,61,167,73,124,167,131,242,139,95,116,68,42,208,19,104,34,63,141,47,54,72,162,22,104,248,122,51,87,199,246,121,32,135,136,213,117,188,157,222,223,200,159,145,206,142,177,198,195,188,188,206,177,31,143,245,160,10,76,84,201,3,176,216,64,4,160,98,60,125,202,252,74,24,141,118,237,107,74,211,131,104,30,157,255,66,188,61,27,84,85,107,142,70,235,144,188,58,196,28,38,1,196,196,124,48,88,169,121,238,147,43,222,110,85,180,178,139,127,46,147,39,65,193,10,108,75,52,161,182,20,99,145,193,196,205,115,1,115,233,252,25,29,116,55,124,142,115,208,66,178,111,6,73,204,41,127,140,205,125,182,183,217,175,247,237,22,16,40,85,7,201,23,51,91,202,181,144,164,234,242,198,13,141,80,163,83,130,101,64,140,191,166,13,85,208,182,60,233,191,34,16,8,212,22,158,250,237,230,118,149,233,20,150,213,62,11,143,148,94,154,242,177,6,247,199,141,190,221,75,250,23,204,15,115,123,94,69,162,203,49,74,129,119,168,84,105,227,122,247,144,37,57,150,167,78,255,127,202,77,117,116,136,74,119,235,218,242,113,174,159,10,51,192,105,28,84,240,147,156,9,112,144,37,70,203,39,38,35,214,16,155,182,171,118,189,87,99,134,154,46,162,36,180,25,78,147,227,55,112,100,36,138,81,168,16,76,232,32,230,127,93,47,109,236,251,89,250,7,154,11,234,56,68,8,135,36,3,25,129,209,195,29,76,203,204,228,206,207,59,240,33,43,61,78,156,185,223,33,225,153,137,167,229,52,137,241,51,134,127,224,46,126,132,29,236,121,190,8,12,83,39,50,255,220,30,226,36,147,219,17,165,126,75,212,131,67,60,65,39,111,70,29,114,32,99,239,130,223,108,147,218,110,15,23,89,114,211,4,104,181,208,199,33,30,137,216,150,147,61,28,137,35,16,198,77,86,216,54,181,136,206,23,48,9,13,33,100,186,227,108,75,212,86,102,218,113,219,248,91,170,70,189,130,139,140,17,179,110,72,50,11,187,2,33,132,240,49,109,133,158,145,179,169,85,31,243,113,146,46,14,212,132,39,233,30,132,15,27,137,57,208,248,133,253,54,50,67,83,57,216,42,111,205,112,190,22,35,198,139,126,106,3,51,90,31,243,90,149,239,134,168,128,212,72,112,116,144,126,129,119,129,140,196,76,162,10,6,195,190,122,30,173,6,224,140,29,184,64,78,76,137,244,43,229,89,250,23,43,82,226,54,25,101,52,205,206,155,50,139,33,197,224,175,178,201,210,148,105,62,154,71,221,86,168,137,164,142,156,157,34,56,142,92,75,234,8,246,253,112,208,53,200,133,75,32,161,34,223,45,95,94,3,69,34,194,178,143,71,228,48,39,206,217,149,56,214,141,40,27,141,23,77,154,228,80,84,7,34,167,33,177,194,93,52,235,134,10,34,133,62,202,47,137,235,5,200,193,190,180,33,28,147,242,140,124,143,117,154,168,34,26,165,57,245,97,164,125,186,219,73,160,255,218,218,187,89,96,57,1,38,56,180,27,83,34,148,55,57,192,104,104,79,39,117,57,167,45,203,131,222,129,2,216,48,108,228,113,178,2,196,74,121,83,41,31,103,57,251,80,40,102,175,32,130,208,23,47,238,215,70,193,69,208,109,31,101,44,82,33,2,20,100,97,144,85,166,124,244,102,246,255,112,169,186,73,107,93,193,234,68,7,138,46,135,207,231,194,221,113,112,156,130,248,203,113,58,202,178,120,170,159,152,46,205,166,47,1,111,238,126,32,39,132,134,36,127,123,98,24,219,232,106,224,66,96,115,109,196,24,213,183,112,233,223,22,141,32,65,158,218,56,124,54,178,84,22,47,77,97,17,178,94,184,192,151,131,234,186,174,15,31,10,80,159,84,106,55,236,3,87,104,61,76,91,50,172,229,86,234,122,156,123,125,105,218,29,172,190,224,97,89,121,226,209,93,166,181,248,137,68,216,77,36,46,189,55,227,160,196,244,243,191,181,179,232,115,87,45,234,250,136,8,211,215,38,220,148,229,130,170,150,206,166,130,85,129,5,47,75,134,69,42,177,94,145,57,192,155,120,189,49,17,226,19,189,81,247,124,34,218,11,12,227,109,32,146,46,115,183,228,153,0,168,174,240,54,172,221,32,190,185,117,73,44,218,138,58,133,57,91,230,90,116,143,173,152,103,255,29,64,225,115,237,109,122,67,38,157,163,14,21,22,144,111,155,129,228,35,65,189,26,204,10,128,124,58,29,203,188,49,132,148,64,84,128,102,161,233,154,233,14,41,157,122,120,219,140,240,82,63,166,174,100,161,64,68,180,56,202,30,216,122,5,121,73,9,221,43,199,92,242,110,58,46,159,34,9,52,165,134,98,53,50,46,52,12,224,36,167,211,19,203,73,89,227,192,144,240,51,245,234,25,97,108,28,103,200,246,249,76,38,95,41,230,99,167,254,145,250,240,43,125,223,155,87,204,5,194,159,160,127,230,8,0,123,189,135,146,165,128,76,127,119,255,52,113,61,83,3,152,166,177,120,226,199,71,206,124,26,235,224,107,160,244,142,166,184,163,191,16,24,34,60,144,82,69,53,107,111,175,65,59,175,155,240,216,107,123,168,2,248,229,11,213,214,80,124,219,197,40,161,207,20,11,245,178,224,218,182,53,119,149,82,253,13,37,36,125,47,68,38,8,162,180,73,98,181,21,215,96,220,77,178,176,31,84,53,40,243,194,163,175,74,196,173,107,57,84,60,221,89,109,209,134,77,223,178,141,7,185,124,130,248,251,31,155,247,70,187,114,75,123,135,1,236,151,254,189,246,202,101,242,215,109,56,158,42,237,248,112,91,68,117,236,187,218,118,123,107,212,151,140,34,79,234,43,55,175,168,61,167,109,67,46,153,120,77,66,38,126,118,183,195,168,68,113,237,76,10,132,62,106,152,182,145,120,194,52,69,39,132,62,250,177,139,53,254,125,4,22,113,101,133,160,246,107,175,66,34,187,77,246,72,201,6,81,134,148,11,63,23,213,89,70,156,212,41,6,212,8,227,25,243,137,196,116,212,165,150,214,105,245,113,28,143,119,93,153,218,186,171,38,232,108,52,38,159,166,119,50,242,125,106,44,199,182,115,237,121,114,0,243,225,34,111,178,126,147,174,10,210,104,252,168,207,50,179,74,9,220,78,161,156,205,196,240,97,172,118,239,98,151,138,14,197,198,194,49,67,155,35,139,112,62,78,100,82,19,58,1,149,10,201,126,86,99,133,89,11,66,215,64,218,39,32,40,3,53,112,15,16,112,11,187,186,58,172,41,21,184,34,117,26,139,145,86,9,7,63,41,11,67,208,3,52,124,4,204,249,32,3,62,192,51,109,157,222,135,141,66,160,198,58,150,61,69,126,130,43,203,0,16,197,89,49,156,7,22,112,83,53,197,4,171,187,97,157,94,56,103,156,90,126,72,81,76,6,179,31,20,234,140,178,218,195,27,119,28,129,202,32,212,75,147,178,239,52,158,167,143,1,234,98,214,122,69,10,105,213,208,163,170,37,92,63,222,6,141,33,147,108,134,14,209,12,54,172,250,169,185,215,139,129,28,245,177,64,221,183,7,185,234,63,160,25,195,65,85,216,39,186,218,238,173,7,227,106,177,63,102,61,242,23,23,164,20,225,3,86,64,146,184,139,145,13,113,218,37,117,150,26,53,204,208,127,180,192,91,235,249,191,248,143,102,48,141,93,164,87,252,48,24,248,209,88,234,42,0,12,231,237,250,7,122,189,173,214,240,8,35,2,59,123,42,68,178,226,157,254,144,73,11,111,34,108,37,3,189,190,211,119,216,248,250,117,97,196,36,157,229,115,105,98,58,225,5,187,43,153,69,213,159,136,177,206,120,239,81,165,80,233,44,145,22,5,61,0,194,200,83,134,64,143,84,18,244,139,3,163,135,200,239,94,233,151,116,227,249,238,87,57,134,84,74,127,123,238,30,214,237,220,88,251,208,139,93,106,179,160,252,180,150,123,230,103,126,179,168,200,68,179,252,181,237,15,5,136,80,184,161,60,167,115,162,128,224,166,185,87,102,167,177,196,235,83,226,229,14,84,196,78,246,253,147,113,54,231,102,84,97,182,82,229,166,75,0,197,239,157,113,185,199,119,38,56,42,16,240,30,129,39,74,90,250,126,139,86,177,58,104,62,125,111,238,92,46,154,129,13,86,181,235,9,103,110,116,154,39,36,123,64,93,57,155,203,66,250,142,49,193,115,204,15,155,7,157,110,10,144,52,116,126,127,53,140,207,40,163,18,104,26,164,226,24,150,208,248,74,218,127,10,159,187,46,241,221,189,114,158,51,72,80,18,241,201,97,136,237,253,41,237,180,222,158,108,204,249,216,250,159,62,54,60,253,122,250,25,69,97,105,43,151,225,226,234,209,199,3,23,28,172,86,251,172,252,198,94,2,210,125,183,188,200,25,24,195,142,64,116,184,130,173,253,105,190,96,56,163,78,142,93,119,197,20,219,166,8,154,198,44,65,124,2,187,208,141,34,158,206,110,115,67,153,202,168,48,236,58,76,202,112,147,123,59,115,0,204,224,138,224,164,46,224,105,219,110,79,103,62,106,143,190,80,30,119,65,111,91,83,155,69,103,50,210,84,147,18,1,59,255,174,55,162,13,111,67,67,54,45,43,74,96,142,155,105,29,8,204,57,35,51,88,174,186,14,65,164,85,109,177,43,225,128,242,130,194,11,74,250,213,56,30,237,12,64,172,210,218,89,20,50,128,73,126,10,168,161,77,8,117,236,107,15,138,78,228,203,75,244,81,176,235,34,108,33,137,170,52,166,73,169,109,32,7,169,6,82,88,239,92,46,109,58,92,223,9,77,134,209,247,6,78,115,130,68,252,72,137,174,32,55,50,207,230,132,0,250,254,65,182,139,61,123,96,3,54,255,218,159,163,242,252,62,76,186,207,110,16,40,62,64,200,132,0,250,232,58,219,229,100,156,216,18,132,22,68,83,169,226,176,118,151,175,5,127,4,24,194,39,1,161,16,55,23,40,223,181,13,80,15,203,96,142,255,120,87,17,16,223,62,47,206,132,169,66,230,143,159,28,29,71,155,251,152,2,2,78,202,7,140,51,146,114,216,236,92,145,169,171,146,68,201,133,146,56,191,106,53,47,52,121,74,154,255,254,140,214,53,212,24,58,46,56,93,83,174,114,6,239,251,88,178,109,46,30,177,142,0,190,159,133,22,99,221,99,165,46,182,31,175,167,225,246,234,192,100,17,25,125,19,159,250,189,233,76,105,29,87,236,51,243,179,17,139,236,215,248,16,1,162,111,104,142,20,253,184,136,104,62,186,47,24,81,198,165,195,99,253,246,24,45,92,101,93,183,2,156,207,50,135,91,38,95,18,239,70,230,127,210,254,189,106,56,64,37,35,33,203,20,16,111,84,73,58,184,113,186,77,89,62,30,136,199,231,115,210,247,39,122,52,116,242,172,30,223,208,19,165,253,136,26,157,175,166,45,37,146,253,221,34,170,106,75,117,75,225,180,177,101,179,251,63,189,65,212,5,53,110,218,245,231,136,76,55,163,199,55,236,66,213,164,206,32,107,172,94,38,60,136,117,172,16,230,224,107,110,244,35,89,62,156,241,156,90,36,245,202,20,14,69,49,5,158,144,230,199,97,5,126,26,141,127,144,120,139,30,85,67,26,27,147,248,87,25,2,153,216,76,103,196,53,165,39,122,234,111,166,42,27,55,80,100,148,161,45,161,197,108,126,211,8,178,249,168,44,51,97,36,139,201,89,192,45,158,194,43,25,240,161,65,67,206,85,146,32,218,78,86,22,224,177,55,137,137,1,114,252,143,250,41,30,189,95,181,212,12,184,72,192,192,218,248,210,160,62,65,172,236,190,40,155,150,248,131,73,181,65,196,126,181,62,147,36,69,170,187,53,66,160,128,95,152,59,94,149,74,119,12,245,145,0,218,139,148,50,207,51,231,120,63,77,37,72,212,77,204,114,103,25,31,180,57,212,247,30,208,33,41,193,185,52,183,168,169,138,50,15,137,166,208,62,203,201,56,191,101,174,49,130,64,214,21,3,90,128,48,236,205,42,167,184,206,63,72,238,132,135,129,46,87,66,136,24,90,183,27,195,57,95,186,63,117,148,2,220,171,118,224,183,166,32,74,198,83,146,21,70,9,188,135,240,225,67,252,225,85,31,232,64,196,174,171,7,58,65,80,0,9,214,75,114,168,196,215,31,29,173,50,213,198,117,45,135,7,25,123,169,71,106,27,153,169,195,206,138,52,75,101,39,101,27,240,79,191,104,93,63,155,107,216,184,251,188,99,209,85,25,73,173,247,219,101,226,144,72,250,57,233,141,150,10,187,133,120,174,178,194,234,184,19,18,214,33,206,213,85,137,170,221,68,135,213,38,100,163,165,202,117,170,37,131,82,171,12,236,93,145,241,229,174,28,199,166,30,38,99,194,135,234,23,218,44,236,97,50,234,198,47,221,217,240,57,43,163,27,129,100,69,246,163,238,244,50,33,115,106,10,194,52,45,230,59,207,220,107,42,165,90,178,171,142,185,147,5,234,225,218,208,247,14,200,120,146,159,230,5,154,146,234,237,131,162,174,63,30,81,208,193,249,90,143,98,111,103,181,116,130,34,147,247,91,200,139,69,156,232,150,109,155,207,120,146,77,183,55,109,165,124,97,230,168,7,166,238,120,224,59,249,45,169,65,119,104,99,199,228,196,218,61,116,150,176,234,197,233,36,165,8,23,189,31,189,211,2,5,149,15,24,239,157,253,208,26,203,252,11,82,167,234,156,188,235,209,33,109,28,147,143,187,163,42,77,13,17,54,138,90,90,244,67,82,145,178,189,185,230,77,165,96,53,97,141,113,16,159,87,123,187,57,153,20,97,196,130,45,21,167,160,170,119,28,84,254,119,50,75,246,220,8,159,48,109,14,236,249,232,79,96,246,33,235,244,33,246,18,109,4,19,26,142,55,67,32,18,106,133,68,207,221,139,232,31,25,212,38,136,149,31,89,129,186,194,60,163,22,101,165,102,238,146,101,27,27,197,35,213,25,233,93,193,37,180,193,7,53,1,246,247,169,10,87,208,170,213,61,23,48,17,72,249,78,204,249,175,192,203,247,69,13,215,34,118,65,80,16,97,47,20,88,97,236,20,128,17,111,234,238,45,53,177,45,72,188,231,151,224,27,45,81,231,30,175,12,14,66,236,247,76,235,176,106,195,36,195,225,120,16,218,112,233,171,143,103,53,185,49,30,113,9,131,46,61,149,45,59,100,31,7,136,119,7,252,48,80,242,232,252,78,159,165,50,141,70,173,5,130,140,176,8,220,175,56,28,56,39,47,87,96,161,217,91,109,159,7,30,151,28,46,16,33,56,9,62,111,78,94,106,240,73,230,38,68,125,167,221,185,34,91,135,169,216,82,38,66,7,172,84,161,34,194,113,114,177,15,35,225,186,69,205,123,174,187,43,111,76,117,119,150,67,196,183,40,200,172,162,143,87,49,79,107,155,141,182,10,152,124,197,88,209,220,16,91,134,72,86,12,129,7,52,60,209,229,170,32,159,121,25,121,242,8,176,205,176,187,230,6,158,67,106,26,217,107,37,38,139,204,227,149,18,109,238,96,188,247,80,70,8,61,121,215,150,232,222,9,2,126,236,125,157,47,16,14,101,178,82,113,182,158,12,62,235,14,188,7,193,84,171,114,40,1,85,49,113,255,6,33,91,235,151,49,107,16,198,65,167,100,147,131,255,209,181,56,174,156,224,102,188,36,180,171,40,13,74,164,13,11,150,51,141,25,77,126,6,121,148,231,111,31,227,111,81,147,125,38,240,36,57,241,205,27,85,250,79,5,32,215,44,72,205,247,149,203,50,152,211,39,131,115,43,148,129,230,34,34,198,223,92,214,190,22,25,63,81,136,204,158,145,169,227,152,103,69,97,56,146,2,251,4,110,55,216,126,43,123,231,239,120,174,177,93,181,112,102,91,99,143,73,77,250,96,17,89,36,78,55,58,13,155,193,146,60,197,39,15,137,132,142,3,18,139,237,239,134,20,6,44,62,30,211,174,151,34,26,92,115,13,208,17,209,213,153,125,206,193,229,96,216,46,205,12,130,118,226,175,58,229,109,165,152,217,90,157,52,215,170,226,144,190,207,127,230,10,198,168,196,122,68,109,112,12,54,165,251,209,33,168,0,39,151,62,143,62,16,11,44,7,61,53,117,6,102,153,255,78,124,73,192,50,9,118,49,50,11,28,14,218,91,24,127,250,152,53,61,206,48,53,36,226,235,186,87,214,174,221,61,195,32,247,53,84,23,33,53,37,18,101,113,65,245,51,193,60,41,116,30,216,196,179,160,29,251,20,178,172,248,163,188,90,151,83,159,186,57,134,198,18,162,97,163,48,151,247,198,133,193,108,94,47,31,155,184,122,222,79,50,216,183,216,0,3,228,162,21,101,141,11,3,198,19,123,44,177,176,235,93,214,57,85,23,193,186,73,17,221,143,113,137,69,102,99,226,192,148,93,119,186,22,118,204,255,214,150,40,42,112,103,94,66,147,138,247,62,94,16,134,150,231,136,196,22,33,194,40,224,24,161,41,74,39,131,33,192,242,250,106,144,111,141,71,110,147,14,25,129,124,168,44,243,133,70,5,157,157,147,120,56,2,248,250,206,46,152,101,36,21,209,62,36,117,138,169,146,138,191,77,108,130,232,104,3,211,75,14,151,176,68,217,101,182,203,188,140,175,36,148,52,34,201,136,81,254,180,199,204,216,234,157,159,103,157,153,157,234,219,178,32,73,55,9,226,33,234,1,133,124,67,110,42,22,36,223,246,99,45,184,236,62,210,11,151,99,182,175,19,217,101,77,231,244,157,51,119,205,252,252,218,149,70,218,231,180,26,160,128,234,27,86,89,167,82,147,8,29,246,42,33,169,208,210,226,140,229,212,157,208,249,85,63,159,63,146,233,36,145,53,123,129,159,245,83,201,220,119,20,222,110,219,111,249,14,190,205,16,126,251,112,121,252,254,30,37,156,169,4,85,116,96,8,30,105,0,89,113,67,120,117,150,246,3,116,77,112,164,47,117,122,187,210,122,221,136,9,46,49,246,187,253,230,216,205,181,37,225,29,51,214,124,189,167,254,143,48,13,119,19,89,5,132,167,143,254,102,155,11,235,153,176,244,220,122,137,46,198,108,227,152,222,74,250,184,235,12,131,3,226,190,150,165,200,53,149,223,149,51,0,184,223,228,66,5,60,151,152,189,63,2,56,150,129,247,228,55,142,249,143,22,83,38,124,13,40,183,30,125,248,81,154,115,157,236,242,59,252,193,41,16,73,211,51,69,95,245,226,171,94,57,202,169,161,43,151,31,158,176,55,108,225,34,85,231,123,77,35,65,27,63,73,119,35,45,252,159,155,109,45,140,177,187,4,217,64,57,110,191,3,60,82,3,8,61,227,118,124,68,73,148,117,181,38,28,56,52,19,118,99,148,67,187,46,166,79,173,8,106,238,91,201,123,86,22,18,134,138,166,31,144,124,246,63,35,99,159,17,197,19,24,37,15,39,67,170,212,96,39,220,221,45,149,74,20,232,183,164,147,50,28,83,207,148,150,61,239,41,216,140,91,203,239,14,218,197,231,148,64,113,225,240,161,140,11,96,255,179,251,106,219,37,124,102,93,7,19,251,242,152,131,185,104,50,129,241,138,44,229,154,63,158,147,232,228,74,183,72,169,56,0,174,155,122,110,109,179,94,37,44,102,109,151,36,75,192,40,68,243,131,129,216,120,56,226,184,238,219,55,46,10,32,122,215,173,57,22,72,194,180,79,90,193,150,207,218,30,169,239,219,74,23,193,12,60,140,195,41,121,204,36,96,165,49,219,137,236,199,2,228,128,28,182,195,43,153,26,31,247,210,156,21,146,192,54,76,207,78,192,142,93,142,41,228,197,62,134,24,102,181,230,52,166,75,56,185,233,216,27,115,107,18,91,231,112,183,85,54,28,79,65,250,66,160,202,205,135,239,47,176,194,153,186,215,120,218,165,45,252,23,63,227,146,98,189,78,246,211,177,253,202,234,224,64,115,247,102,246,42,117,225,19,238,128,118,222,106,204,61,34,96,162,241,27,253,119,198,54,6,66,161,153,225,102,160,45,159,36,70,208,20,54,7,223,155,55,228,204,132,159,18,83,181,214,150,153,143,231,36,166,100,104,223,166,205,155,44,50,225,246,114,236,136,60,215,151,214,29,165,186,139,38,47,100,143,216,177,40,49,10,22,26,208,25,100,9,83,64,58,27,141,14,145,188,115,35,221,178,133,35,30,155,56,59,250,189,51,10,231,130,190,29,143,40,209,107,39,135,196,177,89,114,217,247,105,86,81,21,49,55,77,144,241,192,206,13,247,246,218,72,14,69,195,28,201,85,129,54,174,89,64,252,50,124,158,42,130,166,124,179,206,134,188,132,142,52,103,113,220,248,185,100,157,30,97,103,85,49,159,227,129,83,109,37,187,255,55,111,59,44,178,251,44,34,218,52,152,25,109,98,207,221,41,248,182,98,125,137,246,41,33,10,69,4,164,97,225,64,199,67,61,29,137,203,21,208,95,202,32,131,189,63,238,226,208,86,120,69,37,246,9,247,95,68,231,214,56,129,32,219,72,129,15,164,232,61,41,117,13,20,46,191,176,231,191,111,89,0,2,197,185,253,213,36,48,25,198,157,85,128,83,49,184,12,48,210,36,174,13,235,104,241,88,175,250,71,32,167,119,28,67,164,62,214,127,8,128,3,84,173,187,42,15,35,5,207,244,74,113,254,7,106,244,250,234,1,7,214,109,180,142,27,167,156,64,232,233,168,2,192,254,43,43,61,119,59,148,229,39,148,38,102,112,152,212,240,190,31,64,51,57,208,17,100,237,63,80,51,82,76,20,233,226,140,12,222,35,61,89,186,247,115,42,191,225,26,99,135,29,91,208,168,219,148,132,152,56,204,220,121,25,209,115,90,46,49,107,177,198,44,45,220,71,148,244,238,8,242,88,245,203,165,108,83,223,88,106,228,134,117,130,72,168,53,183,235,54,242,43,59,175,3,119,93,190,45,52,23,130,245,135,16,36,158,168,218,244,24,243,137,248,220,191,152,58,238,186,155,173,131,199,140,26,77,43,218,86,125,88,236,147,26,132,231,176,203,15,220,14,112,42,32,254,5,238,168,57,78,7,52,223,180,160,247,57,243,215,47,230,164,112,192,47,138,110,231,3,155,215,235,12,53,1,237,43,148,75,4,84,219,36,86,226,44,251,22,115,249,232,31,153,67,25,107,243,5,250,4,124,196,125,93,112,250,42,120,50,225,165,238,174,222,28,206,46,165,98,82,96,76,242,128,47,49,117,47,187,89,61,192,152,174,68,54,193,86,232,115,245,198,63,142,142,0,50,113,130,176,171,2,144,161,180,6,23,67,105,121,13,46,83,53,99,211,123,239,237,250,72,237,165,44,76,78,136,139,160,85,228,51,12,230,196,36,223,62,248,244,154,33,27,255,244,208,165,64,104,52,66,138,126,9,220,68,62,36,198,74,119,4,124,206,36,149,155,201,121,28,4,180,27,157,214,140,3,6,184,44,215,188,230,240,177,162,179,215,75,77,84,63,74,54,230,59,192,90,11,191,173,139,60,92,240,45,241,65,94,184,235,79,163,176,241,176,144,67,198,98,49,2,83,99,103,68,80,29,242,17,246,85,147,202,84,163,139,8,12,0,15,252,150,39,130,29,137,183,177,171,17,137,44,47,40,30,42,250,247,103,254,31,19,88,144,85,161,212,217,38,103,12,54,91,126,85,235,252,106,90,123,102,251,78,49,254,163,225,48,156,112,212,42,68,105,150,112,129,70,206,134,177,170,23,156,249,238,234,19,8,8,216,146,70,134,92,83,104,91,206,173,130,253,119,159,204,50,219,60,22,184,95,116,152,56,231,212,63,203,118,212,196,225,46,182,133,29,200,104,50,90,191,21,32,86,131,148,45,204,20,137,57,121,151,98,163,212,182,112,50,174,251,6,77,24,53,163,142,43,18,169,124,103,189,74,249,233,210,186,227,23,112,221,63,134,149,119,46,48,194,182,71,147,137,19,153,213,64,157,45,128,66,40,139,114,144,161,3,93,101,227,110,38,76,105,244,209,82,44,146,50,103,181,166,222,123,244,203,58,180,103,220,32,35,13,115,98,119,100,245,189,71,50,190,52,46,169,45,1,185,10,146,69,6,120,98,17,87,209,35,32,156,17,147,100,38,199,198,67,17,67,27,215,117,182,3,119,26,11,31,27,25,173,228,215,174,231,245,60,184,149,139,220,91,152,248,122,101,93,249,249,112,64,199,228,116,17,3,187,94,189,87,136,124,118,144,212,223,197,27,72,60,21,4,45,116,136,25,165,197,50,67,63,178,29,198,186,41,248,87,238,121,122,188,67,50,134,13,96,167,68,221,247,242,105,166,108,177,52,44,205,70,54,130,80,164,144,242,183,133,158,229,120,138,172,84,173,208,67,72,201,207,27,229,139,13,242,96,235,137,255,195,157,107,28,92,202,89,160,137,21,178,190,57,15,74,227,242,3,143,5,158,99,86,113,179,241,27,38,190,196,231,173,28,40,137,112,7,198,167,169,12,58,119,170,20,160,113,138,239,76,87,220,67,157,12,103,5,193,78,22,224,14,151,214,57,120,149,217,217,17,202,201,230,111,95,6,166,63,197,165,171,146,182,132,146,156,43,232,122,226,175,192,190,100,107,66,143,194,168,116,130,76,57,196,205,34,73,127,168,27,133,199,177,46,7,26,86,246,195,207,9,175,76,99,19,22,224,10,134,196,32,115,65,68,81,101,212,76,93,234,136,58,178,62,198,92,27,51,143,182,229,158,71,89,196,150,64,3,33,62,140,49,55,46,116,118,219,194,170,216,140,246,181,126,201,243,153,149,3,139,125,210,229,65,188,58,45,146,210,206,232,103,99,130,170,140,121,102,203,174,45,153,141,228,133,30,57,24,233,170,193,28,49,16,162,53,6,238,92,81,147,140,81,117,169,183,203,196,114,127,35,174,205,51,126,26,85,30,90,29,105,234,185,225,196,11,29,240,41,179,240,13,72,113,81,113,73,168,136,82,33,106,134,30,211,161,148,201,149,96,221,194,125,131,5,97,3,12,127,7,244,245,156,7,22,137,204,97,31,245,99,55,95,242,92,85,148,143,222,104,138,249,176,77,229,216,146,20,161,186,232,77,249,121,238,145,156,239,217,139,163,193,108,145,17,158,50,253,64,253,250,189,213,115,175,140,229,49,77,116,75,239,237,39,15,16,228,51,185,239,121,94,162,5,184,79,89,154,74,191,88,43,86,93,210,227,77,242,4,9,210,143,197,118,84,163,51,43,76,26,121,124,219,154,32,231,29,118,10,72,254,87,82,137,203,223,118,1,225,251,99,35,46,112,154,40,89,150,107,165,113,145,243,28,98,144,90,11,48,185,98,1,26,231,111,28,40,162,54,206,229,153,143,246,160,190,122,183,28,140,52,91,114,72,202,17,88,150,177,49,98,162,241,98,225,211,163,211,81,123,206,88,67,65,9,15,163,176,120,205,111,119,96,148,248,176,185,99,121,230,245,37,64,200,150,67,39,52,149,61,141,224,27,159,31,23,95,120,133,52,12,171,97,204,240,167,30,168,160,174,78,31,186,144,98,107,197,146,123,232,191,223,248,82,99,143,80,208,59,136,161,130,48,199,249,1,195,61,16,145,213,211,65,18,242,225,253,178,29,132,22,112,223,86,212,210,168,136,19,229,81,61,33,163,222,91,176,129,19,234,180,248,96,58,255,159,66,13,151,135,135,35,211,21,238,210,246,172,46,35,33,56,221,15,3,190,107,11,38,98,132,163,66,247,222,10,131,35,62,158,49,170,127,26,204,55,198,175,140,85,210,27,5,113,219,128,103,158,229,139,223,6,197,240,113,9,78,47,132,26,6,95,83,64,84,140,244,99,208,78,212,31,93,19,136,64,59,23,140,232,243,122,173,107,245,1,23,189,234,249,19,106,197,125,151,178,108,133,228,64,145,230,13,244,213,25,154,149,63,14,21,29,238,73,126,166,117,135,157,222,189,111,76,81,85,95,39,44,8,121,82,224,254,171,146,60,116,59,166,67,158,177,89,228,173,187,0,6,123,200,175,216,208,86,110,241,31,153,202,236,92,69,204,17,188,199,182,206,215,23,157,165,65,165,61,75,148,12,182,54,118,66,36,136,45,120,224,180,56,70,215,94,53,245,179,84,120,237,111,237,178,64,143,160,144,161,226,175,109,180,203,42,134,184,141,244,218,7,50,58,176,158,160,56,197,62,44,90,165,6,172,251,82,76,142,167,33,53,26,176,93,200,147,222,143,211,63,27,21,131,201,201,107,143,229,78,179,49,148,66,216,69,61,205,34,190,142,26,72,68,94,31,106,253,225,184,165,72,62,225,119,64,0,24,181,109,89,240,90,42,239,2,250,240,33,29,212,180,90,125,83,168,217,99,11,61,219,23,23,119,41,88,133,36,44,111,213,147,171,113,242,201,96,149,244,16,130,121,16,63,251,26,49,44,192,19,77,33,84,84,3,121,171,229,16,3,37,35,215,0,89,166,85,13,113,229,125,53,103,180,173,242,198,224,13,253,223,32,30,71,101,16,214,198,53,220,19,5,234,8,210,152,129,110,32,37,248,131,25,114,70,73,228,155,17,118,13,186,139,217,148,119,187,120,228,134,226,13,146,206,227,164,120,219,115,86,115,244,77,221,108,26,190,211,191,73,61,6,212,170,72,104,128,114,26,40,152,27,67,20,135,202,215,253,243,174,245,159,155,219,111,194,235,6,220,103,112,152,153,146,57,112,1,7,107,30,190,95,63,50,150,97,107,222,8,193,48,180,7,105,38,200,103,180,35,155,234,178,223,48,246,203,74,207,57,136,254,96,181,198,211,208,70,150,95,108,36,153,121,201,139,61,87,204,234,8,11,96,148,37,178,178,212,50,147,118,37,176,87,163,150,206,187,219,24,199,89,65,62,231,72,147,219,22,131,28,203,216,117,193,193,10,163,89,3,253,210,210,243,213,54,5,162,209,55,125,180,246,129,172,50,105,47,136,191,123,151,138,174,21,29,176,169,253,121,246,88,191,24,114,164,151,40,196,174,79,94,206,218,194,92,59,5,238,49,74,54,249,236,96,243,202,15,144,68,21,204,36,202,114,208,153,144,27,143,81,222,176,0,235,243,42,175,217,255,131,218,225,191,58,102,68,86,153,191,181,213,251,176,101,52,109,32,97,2,237,71,0,186,100,213,33,86,214,135,183,52,54,132,50,72,10,136,15,24,24,227,187,156,252,89,238,94,232,173,42,176,178,26,186,34,87,154,188,9,157,27,61,7,162,48,126,76,66,239,222,183,41,92,145,254,28,7,208,250,249,207,214,132,198,156,56,74,31,46,236,51,44,70,196,135,124,229,251,139,32,195,131,75,229,176,244,227,117,146,63,113,103,36,232,149,82,4,76,31,154,121,13,22,1,185,129,124,250,146,47,93,233,53,248,111,33,178,9,59,181,103,8,203,35,128,204,206,122,33,60,253,252,22,138,93,205,199,70,187,242,152,95,134,209,244,53,222,36,22,223,14,215,5,241,153,254,11,185,9,53,70,104,194,250,186,142,27,88,86,71,15,182,200,129,7,17,145,93,205,166,18,186,51,173,199,193,208,68,212,220,176,32,2,208,26,53,221,153,34,51,233,54,12,158,128,59,177,23,16,231,92,77,252,128,119,160,102,49,79,112,120,223,186,250,106,238,71,243,156,138,204,232,119,109,79,10,64,164,130,179,105,130,234,253,88,139,234,117,165,185,197,103,25,61,201,213,209,121,60,212,155,28,7,57,70,70,197,152,206,254,158,120,12,20,143,55,125,119,211,241,247,148,221,186,237,66,208,43,189,243,9,135,225,107,228,107,18,64,31,1,126,165,195,255,24,22,42,34,23,32,221,83,46,191,73,239,143,167,132,46,69,65,187,246,6,253,222,197,231,83,52,230,31,136,235,46,227,127,228,247,185,69,143,57,84,182,133,189,55,127,171,157,150,167,7,175,46,206,131,255,170,223,187,15,245,227,113,91,252,187,208,206,81,150,137,154,187,173,200,50,48,24,46,49,165,149,177,37,193,44,50,193,81,117,101,110,255,182,149,242,30,56,172,58,129,79,29,75,45,2,248,44,190,125,128,45,205,48,81,122,245,84,97,232,245,180,64,52,196,109,167,117,9,170,246,155,101,151,74,192,238,226,178,225,95,116,212,174,232,208,183,182,0,46,238,104,98,124,70,65,210,246,8,156,133,83,210,115,224,76,244,144,157,96,65,26,54,154,84,35,177,54,179,35,225,142,166,10,170,23,40,70,42,180,136,0,148,3,68,14,72,191,194,67,5,22,44,26,198,240,19,168,64,64,99,22,65,101,181,244,223,5,217,226,10,126,222,174,20,190,250,51,139,220,81,103,15,123,29,18,117,128,11,184,234,66,173,114,176,247,15,150,161,126,160,190,39,233,97,127,229,170,164,50,208,179,97,141,188,238,123,45,48,245,85,94,113,218,13,127,218,117,17,146,202,104,19,20,142,128,103,230,156,126,201,6,205,22,16,8,238,74,237,2,244,216,12,66,165,37,129,120,173,49,124,86,77,224,13,157,123,106,54,91,135,12,42,166,176,188,32,120,209,66,76,35,176,52,156,253,37,46,147,7,63,83,130,77,58,143,27,180,160,211,188,40,206,149,253,213,237,124,148,156,54,85,100,220,58,161,13,251,163,87,70,60,112,183,200,110,86,100,123,0,185,244,59,26,99,80,180,1,42,173,215,15,121,221,170,188,111,7,121,68,130,30,254,98,201,97,11,140,187,8,233,72,192,65,21,195,64,231,225,109,115,29,107,5,207,139,241,52,54,215,104,211,63,60,10,72,182,45,234,225,80,14,169,13,17,250,151,249,78,204,225,180,42,204,21,39,212,191,161,100,35,139,246,61,197,90,24,18,250,204,174,97,101,64,10,205,167,192,164,3,100,44,35,25,26,195,90,7,92,185,214,13,200,242,16,121,70,152,149,3,7,139,149,214,5,222,192,217,135,72,55,136,214,227,120,79,150,97,74,85,135,224,14,26,254,139,111,252,171,31,34,221,253,77,82,69,112,38,38,182,211,9,88,38,234,155,25,74,237,204,104,175,64,53,50,223,194,194,65,202,119,216,237,183,185,207,85,119,112,121,157,68,128,240,111,209,74,235,191,23,246,114,149,172,33,53,48,84,247,232,170,48,79,128,41,172,173,50,232,113,158,66,16,25,188,130,120,9,64,119,25,212,192,152,36,107,91,171,149,180,179,206,152,95,45,64,83,152,189,154,210,98,214,250,250,23,106,68,10,203,100,188,229,176,38,89,108,61,84,134,198,170,220,108,184,2,193,227,6,22,77,104,242,36,149,18,18,63,129,133,255,108,85,97,146,98,18,224,75,235,154,252,190,117,237,135,238,124,73,69,150,192,206,170,67,210,188,114,22,171,239,68,147,250,150,89,1,14,67,245,207,224,168,78,121,117,20,90,92,132,176,155,35,121,26,251,125,157,32,208,18,128,161,197,234,29,66,75,75,39,45,116,69,93,90,142,169,34,82,106,246,128,90,169,1,28,11,103,166,123,79,132,121,85,2,157,191,204,242,107,39,225,142,164,10,125,24,86,216,111,189,183,184,110,131,22,167,113,128,50,13,145,140,87,232,218,60,39,215,143,164,127,24,77,143,41,153,175,91,3,57,159,179,106,133,151,69,45,89,115,2,118,138,79,43,235,177,251,159,25,139,135,48,55,96,108,159,216,208,214,42,102,43,153,125,75,74,64,136,124,77,91,244,31,3,168,30,126,192,102,112,37,210,98,104,35,2,111,176,99,157,158,8,40,180,194,26,89,252,173,52,218,235,69,49,160,189,107,15,171,222,180,31,147,73,64,111,81,237,151,134,198,89,234,52,246,23,227,206,69,54,100,22,70,103,99,95,174,172,14,12,240,97,249,154,108,43,203,121,101,116,203,96,55,198,42,68,248,42,161,32,224,124,107,100,151,83,62,40,193,196,150,127,160,215,213,3,42,147,195,183,84,14,134,196,194,184,88,49,128,228,121,215,28,168,153,30,182,255,178,226,213,193,45,116,62,10,5,37,6,212,185,16,35,21,233,128,94,206,14,100,221,89,24,10,16,51,195,205,185,15,207,35,162,255,50,210,37,244,81,145,186,130,234,227,15,96,44,89,232,62,206,86,3,91,186,144,38,140,156,203,252,166,144,0,171,108,39,3,73,202,43,36,26,16,58,151,190,209,95,85,108,186,201,43,175,143,56,158,190,109,55,131,16,160,196,229,92,155,75,178,139,15,121,155,76,167,26,73,214,200,162,231,244,125,156,116,96,244,31,93,177,16,91,63,116,9,72,102,205,201,235,95,64,37,113,63,200,132,222,193,232,239,230,251,134,121,87,53,105,27,153,79,86,239,92,12,81,211,166,94,99,62,190,246,84,157,49,141,230,253,114,71,44,29,58,20,142,10,56,69,181,67,241,205,196,20,241,171,237,67,36,143,107,248,28,126,233,16,255,159,77,194,115,217,147,6,37,89,30,115,44,44,165,137,9,160,113,28,63,197,248,28,180,255,243,16,121,117,233,223,179,158,237,71,22,216,245,114,251,22,170,60,77,42,27,60,234,68,238,206,144,159,165,227,38,159,63,13,187,82,103,33,8,86,136,106,246,174,169,36,204,17,139,75,167,193,90,191,237,233,47,209,181,37,102,88,129,107,50,30,6,39,209,201,234,172,87,196,22,172,97,121,167,137,143,217,209,251,114,222,90,76,168,128,25,203,85,3,35,69,233,236,42,146,71,146,81,197,156,121,9,219,92,157,29,75,146,29,241,211,235,242,44,222,231,140,195,148,17,31,95,129,8,106,10,174,180,251,200,199,220,90,76,7,176,129,202,247,72,14,146,252,238,125,26,93,38,2,208,114,85,142,87,46,217,195,64,215,186,132,160,195,195,73,212,6,104,64,15,101,227,5,186,71,9,182,216,98,49,152,127,31,64,184,100,217,129,151,186,164,248,213,236,75,13,194,185,213,11,77,177,39,12,43,159,9,169,201,95,133,95,37,115,43,10,235,171,158,165,219,12,208,56,250,240,228,235,192,216,216,18,110,121,21,85,17,23,255,181,35,119,177,89,9,236,2,127,212,30,222,230,223,8,140,205,201,154,144,224,94,215,144,108,3,236,124,102,177,114,106,172,7,54,175,93,205,146,37,106,123,171,178,120,57,52,0,186,7,84,51,214,236,10,21,249,111,227,95,194,69,25,203,65,177,26,47,5,111,102,205,129,24,247,214,65,139,250,149,71,253,31,25,19,134,188,34,86,232,84,220,116,42,193,244,221,107,4,98,50,119,51,240,108,104,45,2,228,102,218,84,46,57,99,48,119,40,183,47,230,232,6,139,179,154,211,90,229,119,218,125,252,41,220,177,0,236,146,147,221,51,145,137,48,172,107,4,229,139,72,226,142,97,58,78,23,42,58,163,137,72,14,187,80,55,139,137,53,85,64,39,11,240,89,57,215,9,85,226,219,184,36,236,204,102,178,122,141,172,228,29,13,147,231,106,161,78,83,155,92,77,34,63,160,144,186,255,147,235,68,125,173,137,17,126,156,160,190,2,70,68,142,48,2,184,97,202,144,116,254,166,118,17,111,80,141,128,225,87,19,193,11,35,203,74,99,190,63,217,49,91,237,201,60,162,164,140,237,100,60,176,119,25,124,8,26,199,93,126,105,220,65,63,139,249,115,93,9,196,93,81,206,136,238,69,204,97,83,1,219,83,182,150,54,138,11,125,230,108,28,31,174,49,237,7,186,151,102,73,153,235,9,80,103,252,23,185,36,64,25,236,75,186,18,153,228,244,28,124,90,50,196,168,80,210,56,249,134,78,128,27,115,139,70,113,9,15,27,130,10,88,162,131,235,241,70,87,84,91,238,197,235,101,152,230,16,99,97,178,70,22,41,12,48,37,246,88,192,42,12,22,141,213,175,107,253,59,221,216,149,178,89,46,108,105,48,125,140,148,240,12,162,243,43,164,60,200,21,59,130,176,245,5,32,95,164,113,79,192,5,215,59,231,183,59,67,156,148,3,199,240,102,208,10,244,135,225,203,63,93,104,157,51,104,14,241,31,185,79,27,52,238,36,43,209,41,22,185,46,79,20,64,28,154,17,140,243,58,249,94,199,170,255,184,203,194,2,44,110,208,39,222,3,169,107,20,253,129,188,254,166,192,62,40,227,9,139,158,149,16,81,32,113,217,64,13,176,158,7,144,39,18,19,112,106,28,234,228,20,64,248,99,31,92,125,212,255,159,122,187,218,151,5,134,81,54,240,76,243,94,124,109,128,50,245,221,153,248,209,217,28,5,47,156,243,8,71,134,12,143,185,161,184,22,46,161,153,37,20,180,40,159,48,16,48,174,95,100,132,255,67,41,220,141,69,221,61,182,254,103,133,216,48,120,154,141,245,22,77,215,201,173,7,33,19,172,113,141,86,136,21,25,192,69,206,127,90,32,186,89,55,127,111,126,67,75,231,211,130,88,28,36,232,219,165,20,240,32,175,176,147,86,227,20,162,38,94,133,58,110,80,32,255,147,21,196,164,119,19,210,59,45,85,249,249,220,250,199,228,243,212,107,88,253,33,255,32,208,180,116,79,197,118,59,195,8,133,139,102,233,54,79,117,116,43,231,246,186,135,38,30,182,225,90,129,74,71,209,220,22,244,126,198,64,32,217,80,102,116,6,10,102,49,171,169,45,93,179,129,102,209,233,65,152,48,4,231,93,154,217,111,206,31,41,76,134,191,95,181,77,255,248,238,26,227,238,131,30,24,200,236,94,8,6,200,14,95,130,251,143,179,10,9,64,118,89,48,25,245,107,137,25,182,76,238,68,34,13,93,51,234,68,27,13,185,86,209,115,29,146,6,57,45,31,50,14,136,152,153,115,90,78,176,90,136,210,31,246,230,169,254,51,239,113,33,55,63,147,90,118,103,197,190,24,36,19,172,223,177,6,1,102,90,7,114,91,191,212,166,121,140,109,180,70,80,212,18,49,127,28,61,107,109,242,32,194,6,210,112,150,47,132,107,214,31,67,194,197,129,91,75,103,41,246,249,58,232,99,148,153,75,176,96,179,48,148,232,130,86,229,40,74,136,149,49,101,179,183,118,60,195,106,199,56,51,164,77,214,24,253,41,199,221,168,190,196,232,206,55,233,98,245,143,94,111,204,147,247,24,231,44,250,104,122,101,44,7,251,86,206,10,176,230,109,251,93,59,239,100,81,154,122,41,40,133,209,89,121,140,250,133,51,171,61,190,185,167,67,127,136,84,9,206,76,116,47,94,91,73,152,117,23,55,247,116,188,236,212,162,16,1,40,249,217,150,226,183,50,150,77,250,66,29,34,138,43,34,167,243,205,41,66,201,201,147,172,158,1,143,114,196,228,239,143,163,118,30,194,152,227,147,108,130,104,52,170,3,223,20,3,48,76,105,182,126,75,16,188,21,105,3,203,227,210,127,73,43,44,37,150,137,170,5,253,56,93,25,137,133,118,127,2,250,222,106,242,116,45,219,205,80,163,209,154,219,53,159,192,201,212,113,155,128,225,71,16,43,79,199,251,61,2,185,41,72,12,148,227,227,246,223,108,234,152,140,92,86,103,124,89,199,102,116,250,237,43,90,215,252,254,98,78,98,20,249,226,237,115,40,120,124,255,9,27,69,189,121,104,134,9,80,207,220,47,235,96,220,36,32,55,192,11,186,170,208,198,184,230,253,197,25,153,211,16,243,122,30,178,141,180,140,93,114,174,82,131,198,167,171,106,109,253,111,95,48,14,48,80,250,111,86,181,40,68,8,241,127,142,1,70,228,200,227,235,183,129,38,186,148,233,230,165,128,180,119,93,35,148,72,247,246,111,48,223,131,147,11,111,254,52,85,200,52,170,156,242,232,16,82,122,226,245,138,166,43,89,223,250,81,112,48,166,213,130,202,22,206,255,203,23,67,82,91,68,179,215,105,228,111,231,63,59,205,180,108,197,35,20,46,150,170,245,90,84,53,55,46,30,227,186,168,169,43,93,23,192,156,118,126,98,41,4,8,3,52,78,194,60,75,206,30,114,131,221,85,2,130,157,134,219,91,195,36,223,52,235,33,155,223,25,106,72,100,244,88,37,194,72,164,118,44,142,229,92,173,51,158,14,106,128,235,41,80,24,72,49,227,242,10,7,250,127,53,209,10,208,25,62,125,223,225,59,135,108,211,99,97,77,161,42,208,252,212,163,24,7,76,199,54,12,41,247,13,208,86,77,246,149,69,72,80,149,150,119,222,91,159,182,157,72,46,39,115,128,215,60,20,60,221,48,255,120,65,111,188,90,192,14,218,72,41,150,87,209,195,199,115,55,170,30,177,125,236,139,142,12,26,108,229,100,251,206,204,160,9,56,90,168,40,26,214,157,230,10,95,84,222,203,53,132,88,44,161,67,115,39,82,38,157,247,113,81,199,85,233,114,52,47,134,211,184,228,167,167,222,120,53,71,109,26,79,227,228,92,122,119,0,44,191,76,43,38,71,174,98,89,7,236,250,16,61,115,140,68,18,91,11,203,132,227,54,38,218,86,239,105,248,26,8,45,6,102,131,13,207,73,62,64,126,14,221,233,242,50,253,76,27,175,145,198,30,225,22,82,153,128,20,80,153,80,108,240,29,145,70,96,166,135,199,17,97,225,236,89,212,148,117,247,255,178,127,96,46,5,247,170,210,101,21,51,235,210,183,240,36,55,42,243,237,42,137,107,119,188,58,13,154,51,14,111,20,138,88,187,151,117,42,58,59,171,52,5,65,98,119,232,75,13,93,12,225,58,52,15,125,129,248,48,154,214,110,211,47,84,140,194,250,202,27,48,80,129,28,237,234,16,43,92,223,33,94,19,240,226,139,45,252,177,153,169,202,68,243,80,237,150,26,32,170,107,171,250,22,158,138,26,201,175,190,178,78,102,21,113,209,105,107,113,159,175,80,20,165,232,38,70,53,112,62,11,98,167,165,46,38,238,43,141,179,77,238,29,80,59,1,159,117,219,225,168,87,124,27,212,47,132,200,219,206,167,17,161,219,181,58,148,58,113,223,194,239,112,78,226,232,206,160,122,123,4,228,57,132,248,235,188,196,223,252,81,168,71,53,54,249,80,93,75,44,61,157,217,236,155,69,153,135,182,7,140,150,48,173,134,4,188,91,131,7,77,151,250,143,225,65,104,1,168,38,44,251,121,12,174,140,220,20,2,234,202,29,61,98,123,113,53,11,157,15,135,211,201,206,214,163,241,67,143,71,223,170,202,226,235,23,55,9,242,210,237,186,41,31,107,202,81,177,28,81,51,197,11,175,3,232,64,60,41,0,16,94,136,33,164,161,7,102,0,96,11,102,137,185,136,118,50,64,70,76,188,207,17,16,109,50,197,226,133,0,171,154,196,240,42,72,255,3,19,119,175,156,124,243,7,90,172,38,37,30,233,13,82,57,120,53,58,121,220,101,182,198,83,62,104,211,240,122,246,37,171,166,190,102,130,21,38,82,183,189,128,211,110,207,162,56,83,206,219,69,244,117,79,71,214,77,192,23,161,193,30,70,9,235,246,65,209,20,227,1,204,178,115,93,236,58,98,245,5,53,69,152,250,68,24,132,255,237,174,66,119,121,46,19,119,193,104,39,234,210,243,235,81,106,155,243,194,225,92,245,125,56,78,231,20,222,125,217,120,88,58,114,171,37,182,46,137,32,91,21,234,198,199,77,108,154,73,171,141,142,116,22,147,53,110,113,54,176,38,98,117,178,90,182,139,189,13,37,174,210,23,168,162,169,237,222,146,199,235,242,65,162,185,197,182,58,193,193,169,217,124,144,23,91,220,168,168,193,176,184,3,226,247,49,74,39,240,201,232,24,204,131,222,21,112,48,45,208,19,154,51,1,52,129,27,247,220,110,153,171,50,20,212,97,117,159,92,112,174,145,252,149,17,214,237,110,141,14,166,112,83,90,130,44,187,207,167,156,206,62,103,120,82,52,26,176,219,9,241,158,56,183,17,31,205,39,229,63,205,248,18,238,253,126,185,111,0,134,116,49,46,78,232,251,127,229,178,15,158,214,197,153,66,132,183,121,77,23,221,0,208,67,80,22,14,14,80,51,198,233,94,98,205,188,246,175,165,235,31,59,131,147,88,119,162,140,149,29,113,205,139,110,185,142,221,243,202,227,116,229,12,243,138,198,83,38,110,242,101,6,233,31,38,167,238,232,94,64,242,196,222,144,139,40,52,40,232,48,163,215,230,180,47,114,76,105,168,106,30,248,231,125,157,162,169,221,37,224,77,159,55,232,91,166,203,65,241,199,60,29,250,188,210,255,92,54,28,209,44,140,61,233,114,42,76,227,142,83,26,218,0,123,250,62,237,127,11,90,98,39,106,156,254,206,186,101,5,17,92,17,106,56,158,52,24,167,141,56,71,128,93,126,56,22,157,165,76,197,43,246,161,113,148,171,197,79,73,131,49,162,236,155,72,35,110,43,79,61,244,81,41,156,80,152,25,206,183,153,26,6,155,49,107,27,177,142,190,118,110,231,157,104,19,214,102,104,230,44,131,202,166,134,153,68,118,251,150,45,1,51,129,163,179,218,171,134,218,142,221,164,96,47,121,6,41,12,23,76,220,50,221,177,159,237,47,201,112,204,247,115,223,178,53,101,76,240,164,217,222,14,190,66,193,41,62,209,115,103,207,33,183,134,184,11,161,191,16,77,245,238,151,47,72,40,129,52,192,122,233,232,62,69,61,197,245,226,169,245,19,6,46,217,96,121,157,81,93,86,170,29,39,240,22,52,83,68,10,69,28,9,106,46,79,223,154,159,50,201,93,13,173,228,66,98,0,254,174,5,40,238,130,89,126,206,58,80,57,65,128,99,160,129,151,75,154,149,224,172,59,10,247,137,248,123,215,207,89,130,224,8,55,43,243,118,176,100,132,41,13,8,123,196,171,215,42,234,88,4,218,62,74,125,35,221,132,72,175,1,181,239,155,73,9,251,43,85,234,72,50,138,103,8,195,25,237,230,184,126,59,64,107,39,127,23,86,178,134,64,233,225,73,6,194,224,241,8,48,124,139,208,48,30,12,35,255,218,195,187,4,57,244,74,228,230,137,167,44,76,91,29,28,124,89,138,172,95,55,3,195,111,139,169,128,176,181,227,77,220,166,10,109,65,174,194,103,5,71,200,199,208,111,95,219,114,159,251,189,216,190,34,68,29,90,94,200,130,17,54,199,75,116,64,225,244,90,47,175,172,188,231,124,200,180,43,85,18,83,93,249,242,158,136,153,165,117,195,230,141,44,203,128,175,94,144,139,73,42,73,29,235,7,198,155,16,92,211,253,162,6,61,198,210,4,7,160,105,255,245,8,207,51,188,72,185,48,235,151,149,180,227,140,112,137,234,16,146,54,115,188,46,64,81,171,110,216,94,151,252,212,248,226,153,231,169,168,77,134,60,57,115,160,202,220,196,149,171,71,157,129,72,210,27,162,214,216,215,233,152,49,90,150,202,56,131,36,10,21,53,27,231,35,7,41,198,233,135,14,67,152,114,198,218,55,26,107,251,156,91,171,230,15,7,152,176,239,70,97,244,76,179,222,222,103,69,223,14,65,34,227,242,245,173,180,125,93,239,19,242,126,86,243,91,134,11,37,205,30,185,46,2,251,22,50,83,5,255,42,167,117,47,153,79,43,126,74,188,48,37,36,92,135,63,62,39,79,124,232,50,28,171,43,29,182,109,159,50,202,79,38,42,243,249,14,114,129,21,75,208,221,198,228,245,199,31,125,239,78,5,238,111,60,78,28,242,17,11,174,116,110,10,183,78,116,99,33,95,40,179,38,16,109,91,105,111,11,212,247,170,74,86,182,31,211,166,241,174,243,237,136,32,246,47,222,8,160,224,238,236,181,216,246,193,59,132,185,112,129,65,30,214,72,48,159,75,175,214,66,9,104,148,23,220,47,213,171,136,66,10,11,171,200,60,33,50,145,250,111,130,168,117,93,216,114,195,2,18,203,2,222,239,43,91,7,140,181,84,90,144,96,237,125,64,112,182,162,7,250,90,102,94,89,217,24,219,212,235,158,153,73,144,127,111,227,182,229,143,226,199,111,29,45,65,62,187,135,139,130,7,126,15,33,195,243,210,31,164,68,221,141,22,73,212,139,89,41,196,17,4,129,254,7,110,187,135,68,139,12,158,93,178,97,113,235,186,125,123,6,233,192,236,94,17,110,74,157,129,115,194,245,185,190,55,111,140,35,201,176,104,33,130,121,210,222,249,170,237,77,170,75,9,232,45,3,110,216,174,205,224,209,53,128,149,209,167,166,170,205,152,252,104,152,64,104,209,5,235,173,84,173,249,238,44,102,49,84,241,64,221,104,122,173,240,79,169,126,92,11,21,41,90,13,194,91,250,198,188,210,40,205,254,22,18,148,171,23,22,126,192,124,116,120,1,73,38,241,123,6,223,7,179,65,185,97,235,51,31,191,217,29,208,103,206,67,236,200,102,2,191,24,64,253,107,71,91,173,36,127,209,96,200,35,45,29,189,196,119,254,113,110,116,129,172,58,43,35,91,122,50,65,178,187,212,149,142,79,38,176,179,41,139,159,212,239,133,201,251,0,170,164,86,217,243,166,78,52,55,212,145,39,255,27,238,182,38,247,146,107,10,169,45,127,248,115,62,8,6,60,53,13,37,159,33,246,140,26,80,213,241,3,18,203,2,122,58,42,157,54,147,181,66,251,246,151,194,41,219,208,180,104,175,80,2,239,204,44,111,198,36,58,168,83,14,12,19,171,162,236,245,134,168,173,7,201,114,208,83,119,56,150,206,174,42,148,127,237,180,119,174,32,234,9,125,66,213,252,52,51,129,247,99,203,160,1,53,166,194,173,66,40,129,32,239,121,59,24,167,56,151,74,253,91,208,138,121,165,239,101,197,215,35,186,212,26,159,190,108,37,127,115,56,8,78,78,183,255,249,76,58,75,149,120,172,142,18,192,243,128,232,13,209,251,3,219,4,220,34,33,199,90,179,198,178,122,111,63,213,28,18,109,250,142,67,25,118,36,108,64,56,231,204,36,106,48,218,135,50,15,107,76,166,33,20,72,38,79,82,179,77,58,160,165,211,247,124,86,168,233,159,193,27,229,68,240,245,241,117,255,179,172,166,36,172,48,243,234,240,135,114,46,18,102,65,0,218,127,180,9,206,108,146,188,16,112,184,93,174,23,43,173,207,254,142,68,80,74,44,75,161,211,227,137,73,232,115,133,155,231,122,216,195,226,123,92,47,84,99,31,88,90,204,84,52,102,133,42,19,105,94,80,254,140,149,8,45,236,37,18,46,13,220,17,89,17,105,9,48,123,166,98,51,182,185,146,171,21,95,9,92,247,86,115,242,240,66,162,225,130,101,206,203,221,86,238,150,153,202,113,129,129,232,86,247,219,25,64,232,89,24,46,139,173,41,162,215,124,219,169,254,43,51,222,29,83,31,189,180,237,90,237,83,78,47,53,108,87,11,22,100,165,212,227,126,15,189,86,219,61,191,51,102,186,100,110,16,41,154,13,238,32,254,203,145,85,217,134,118,221,130,54,57,195,234,114,196,4,21,42,212,184,195,19,243,218,58,55,225,203,253,50,158,56,250,229,239,88,245,17,150,198,229,205,219,184,223,229,12,45,213,61,180,65,249,183,164,45,141,225,240,219,211,95,18,9,43,251,192,73,114,68,85,20,148,109,242,39,243,189,204,102,18,92,76,83,187,37,247,189,177,226,176,41,91,153,231,157,7,110,117,205,130,164,57,77,255,28,177,224,22,136,133,6,89,252,185,216,28,23,102,180,100,1,40,135,103,155,251,201,124,176,102,37,252,221,231,145,188,18,239,81,116,134,94,115,245,237,156,76,13,47,39,176,180,124,162,60,102,237,27,144,238,161,224,193,162,237,72,162,124,205,145,124,239,255,47,0,249,42,234,78,181,233,74,25,231,208,160,115,35,93,179,23,145,195,250,67,246,73,222,251,222,130,181,90,244,196,52,102,188,109,139,118,191,243,81,157,167,194,204,227,135,106,183,88,190,212,53,223,154,34,16,20,107,194,216,139,9,43,41,50,87,181,30,123,26,7,46,206,166,171,72,27,129,148,215,180,56,54,176,216,136,26,41,144,92,86,252,224,73,114,11,13,128,71,98,57,48,147,162,214,235,121,40,79,127,198,92,81,195,20,14,106,108,51,122,106,255,220,113,81,200,91,64,115,168,140,248,26,197,237,98,67,172,11,138,86,20,160,237,84,177,98,192,96,72,198,129,202,40,244,253,16,6,181,230,178,9,169,228,150,8,53,42,73,195,25,159,130,198,196,100,102,117,126,137,162,219,106,159,92,107,1,116,122,42,49,128,201,162,197,186,206,31,146,116,175,186,149,121,74,134,218,168,106,47,161,250,196,39,174,199,149,2,210,147,34,172,154,202,52,56,178,142,241,232,63,119,133,100,132,176,158,32,12,10,127,216,133,39,43,95,79,59,54,62,93,238,162,152,187,251,111,46,111,26,25,57,24,141,197,100,188,35,57,158,58,153,3,186,79,31,164,179,4,231,165,227,4,17,129,70,212,84,217,159,49,21,207,118,89,236,46,199,225,32,179,180,88,196,114,98,255,87,129,239,7,103,120,105,21,70,158,82,58,230,112,175,4,183,83,239,75,44,53,136,176,235,97,70,139,194,167,50,217,218,65,79,80,250,44,240,104,186,137,37,139,148,54,174,188,165,177,61,108,180,172,27,13,3,81,35,76,60,220,111,57,153,8,34,24,122,36,57,80,128,73,230,11,178,19,10,212,94,189,81,83,251,46,255,249,197,26,212,10,44,125,207,78,17,23,107,49,106,109,154,113,53,133,130,3,14,122,15,11,144,111,216,141,254,107,43,170,2,164,36,105,146,234,200,69,166,82,193,179,54,152,181,162,177,178,138,14,54,109,82,6,97,101,51,79,40,77,132,230,188,137,3,237,83,206,136,84,15,34,193,215,18,248,255,190,2,133,170,148,215,164,212,231,63,180,249,20,185,206,58,45,41,240,219,159,150,220,205,213,160,135,55,63,132,226,54,75,59,150,74,136,200,37,14,16,92,149,178,84,143,230,193,185,56,178,72,195,46,188,146,127,107,111,34,21,87,255,38,9,43,29,172,75,5,11,66,60,51,148,241,157,31,47,120,117,88,136,192,174,209,252,153,149,67,225,199,88,245,18,77,196,40,47,100,131,177,161,247,223,164,53,63,92,8,159,145,140,41,156,68,6,164,74,132,91,59,168,90,63,73,20,238,215,37,32,162,97,165,168,14,13,109,251,157,69,28,46,243,7,132,66,136,55,72,234,23,177,150,145,150,197,232,18,16,13,46,147,61,218,176,229,7,25,171,25,170,12,241,61,74,47,9,192,12,12,193,109,110,56,132,159,202,131,88,237,79,80,141,52,96,251,240,163,137,155,245,50,111,106,234,208,175,230,194,164,227,20,44,92,53,217,86,68,39,37,183,198,224,85,245,58,33,87,15,245,86,166,104,41,158,3,31,87,230,148,124,190,255,167,84,241,21,163,246,183,224,113,208,76,223,61,0,242,17,124,99,214,130,233,216,2,224,137,205,163,232,213,153,180,247,221,55,157,216,18,88,139,160,176,157,238,24,236,133,105,52,214,74,81,46,11,249,72,225,222,192,103,240,101,219,154,151,168,247,118,151,33,101,145,125,121,253,70,143,106,122,71,86,170,144,59,146,241,240,49,45,23,129,155,203,187,225,173,111,185,232,228,135,216,178,72,183,22,118,194,53,136,82,101,172,226,168,62,32,99,64,56,208,106,121,59,15,124,75,81,3,91,146,104,28,175,127,7,146,107,91,46,25,64,133,125,93,59,211,43,108,92,30,15,228,239,125,116,168,10,131,167,35,127,23,139,118,84,149,116,59,163,132,14,47,4,254,121,166,173,140,128,49,23,227,173,139,67,13,221,62,237,145,32,142,168,75,202,204,37,237,24,222,34,33,113,166,167,191,190,234,155,38,235,45,159,177,119,159,2,251,82,119,125,216,81,192,136,134,41,8,46,163,31,216,186,245,118,79,10,184,119,32,167,66,72,189,197,137,253,188,188,208,220,76,95,119,165,213,227,46,182,238,55,89,149,125,182,190,86,192,155,253,2,217,222,108,140,15,1,25,184,22,219,192,165,249,46,169,210,43,63,8,189,86,26,11,36,43,245,149,144,92,144,23,18,253,238,123,46,30,143,179,93,51,208,131,69,193,50,136,243,112,196,35,94,245,157,230,40,109,51,45,144,136,167,126,77,169,17,131,229,148,33,74,123,245,112,115,125,0,119,134,138,179,105,186,138,107,93,171,181,233,253,63,238,117,60,93,81,181,239,87,149,214,160,107,105,255,81,27,149,228,12,191,173,196,172,129,167,185,106,132,249,143,66,102,131,20,115,79,121,122,74,61,222,0,237,183,6,98,34,55,129,242,105,46,114,75,220,63,170,34,253,217,159,237,68,123,179,122,162,163,106,138,86,204,121,189,229,93,20,67,98,136,5,230,213,183,14,217,127,153,232,188,132,159,118,202,210,122,86,173,52,131,153,185,162,166,117,83,146,133,236,134,119,170,63,168,238,154,109,65,202,188,175,229,22,231,57,205,225,199,78,114,40,150,153,245,223,16,99,160,138,221,17,2,21,248,216,22,200,88,20,58,128,79,123,73,133,216,58,166,239,84,6,240,180,9,48,128,2,116,249,255,88,137,56,215,29,84,112,16,222,117,37,60,80,16,63,44,198,223,51,194,50,253,9,99,147,107,118,91,228,38,30,14,241,41,67,244,4,180,10,122,25,153,185,199,170,3,216,78,227,135,201,236,148,26,59,208,125,41,209,231,179,248,11,213,156,240,224,39,132,205,165,130,223,212,194,21,105,221,178,43,169,104,208,73,225,139,117,127,106,188,213,196,10,5,219,182,165,65,20,134,248,122,193,101,176,55,98,43,44,179,54,77,173,227,121,148,130,142,195,213,214,218,88,8,181,144,93,143,112,66,175,61,10,10,121,197,185,53,21,188,19,2,68,83,189,165,144,164,123,52,4,11,245,70,214,198,68,150,58,185,73,172,165,115,63,165,144,28,194,125,132,74,187,223,15,40,92,185,155,206,71,102,230,189,108,105,83,196,153,99,175,44,236,68,66,203,215,56,214,249,51,75,142,79,145,116,98,118,166,180,96,213,4,18,116,88,106,168,197,98,88,205,66,194,43,38,191,88,75,171,240,75,70,147,252,95,149,202,224,102,47,173,148,3,84,72,131,197,19,185,48,109,251,85,226,42,2,27,223,98,194,101,115,22,74,233,21,8,205,142,91,208,130,10,197,86,206,166,254,212,165,91,27,214,239,13,240,29,92,68,10,172,231,141,128,5,248,170,204,43,89,192,155,154,206,178,183,140,105,229,132,86,192,66,234,13,59,152,159,38,223,228,145,86,228,199,103,243,93,252,98,193,186,182,140,174,253,61,86,151,163,128,6,19,204,89,217,245,55,30,124,75,115,73,4,187,73,103,124,237,76,227,154,193,55,60,108,46,85,138,34,245,226,159,97,51,105,254,255,39,152,250,1,36,28,172,55,49,83,47,21,182,14,148,24,25,121,135,3,13,188,237,60,110,10,14,95,165,18,211,185,253,99,123,190,250,219,156,137,137,249,106,0,205,34,102,105,248,132,217,176,21,202,127,71,113,211,200,67,56,51,247,225,25,113,169,94,245,161,64,254,148,9,4,109,29,93,224,132,155,72,51,251,158,72,106,188,167,154,128,41,92,90,121,109,130,89,166,237,115,49,11,166,58,16,169,160,40,206,216,112,252,8,151,64,101,172,176,72,234,51,201,140,95,0,189,131,162,145,127,127,158,38,28,210,6,197,71,232,51,98,77,168,66,215,214,243,163,209,9,246,223,231,112,176,115,121,187,123,129,66,223,168,75,140,79,143,161,120,69,193,37,254,147,98,225,172,74,125,250,198,162,73,101,67,120,0,140,22,192,154,77,147,188,83,212,202,115,100,112,132,239,118,223,160,79,54,17,15,53,218,230,115,242,120,164,189,80,66,177,34,8,89,203,80,3,88,72,1,121,127,37,208,230,114,120,184,122,33,134,140,67,96,124,159,235,64,110,234,56,118,231,113,44,70,23,55,226,49,235,238,117,191,71,238,151,62,25,101,136,91,47,31,112,10,147,175,73,240,54,233,159,149,109,24,243,130,52,48,214,60,143,47,18,191,196,75,190,167,1,140,82,203,36,92,104,116,50,50,104,94,156,53,81,134,155,65,63,237,196,166,157,254,207,133,133,146,12,188,149,222,211,97,86,45,224,171,219,193,52,238,42,2,60,195,179,220,181,54,38,110,111,192,145,240,15,182,163,177,159,244,124,156,49,105,116,138,149,63,129,227,99,63,71,178,66,148,148,199,251,99,88,18,34,43,181,110,163,141,123,4,107,204,135,132,238,22,6,56,50,82,26,55,61,196,7,189,109,61,100,42,175,10,203,227,140,65,26,129,226,127,178,203,47,155,108,31,221,128,22,219,226,132,61,8,59,145,160,222,193,81,246,4,108,189,226,198,96,72,155,25,253,205,155,200,60,73,216,55,26,69,184,148,174,136,27,7,14,197,206,102,169,51,151,168,83,34,251,71,238,50,19,53,133,27,102,60,176,78,13,28,65,177,64,195,84,187,77,157,2,249,87,226,78,149,79,177,237,68,16,10,54,76,83,127,148,114,124,89,84,158,176,210,175,128,117,130,9,98,43,246,238,205,231,92,240,249,3,20,177,60,31,233,228,199,7,89,213,110,27,5,66,177,145,127,75,237,198,0,89,3,131,42,127,28,212,143,100,156,105,117,33,183,143,90,118,121,184,66,218,13,153,45,112,247,36,33,51,219,162,247,89,241,235,217,194,134,184,140,252,95,89,148,19,103,245,97,112,230,245,114,252,78,97,106,98,148,231,170,131,34,23,222,235,30,194,17,96,58,46,36,201,255,127,197,247,75,214,209,42,192,99,74,72,236,232,129,202,170,190,201,131,168,70,62,116,87,85,128,219,234,82,15,218,82,48,155,249,255,66,90,246,170,78,140,51,69,219,5,207,106,80,83,203,213,99,155,253,129,134,142,174,45,211,229,98,158,146,45,250,158,45,58,234,214,120,126,196,108,57,18,125,231,162,21,94,195,173,25,160,18,189,168,35,52,141,1,80,126,157,130,48,16,176,76,216,95,98,54,13,182,166,96,62,98,241,138,17,153,146,44,73,205,22,222,198,29,86,212,60,140,13,30,39,193,119,228,25,157,237,32,133,170,254,200,26,53,31,191,42,92,90,254,183,71,122,214,115,122,61,69,86,11,6,167,58,109,32,15,196,220,208,219,228,93,79,229,169,224,182,174,3,65,88,199,5,185,96,68,60,17,223,84,86,11,109,200,123,247,165,191,150,35,113,24,177,38,90,113,159,84,46,174,232,97,189,89,212,68,6,19,106,55,97,161,97,17,94,171,228,154,161,62,160,16,40,205,115,16,56,36,155,230,94,122,155,200,61,133,19,136,104,185,151,186,136,41,76,245,46,168,241,134,223,9,180,217,126,76,65,24,176,124,181,134,81,190,169,20,195,226,79,210,182,163,22,188,236,161,118,42,211,20,4,84,164,113,45,213,159,219,158,107,70,170,54,159,239,97,136,239,121,51,16,138,36,159,84,42,176,246,48,45,108,218,131,148,95,219,61,2,47,228,226,112,237,74,231,65,93,137,228,224,22,125,151,221,164,31,227,210,89,103,219,245,215,169,19,36,206,124,193,4,200,28,11,162,73,32,133,217,124,244,128,98,61,55,207,223,34,78,8,230,241,176,232,19,101,216,155,67,231,202,214,133,161,22,149,197,248,0,221,34,247,131,46,212,164,104,72,16,98,152,199,29,83,167,13,23,121,58,224,121,201,118,60,240,190,70,118,88,252,5,53,40,160,254,29,68,124,250,85,234,202,237,196,81,198,156,73,111,18,174,0,181,228,173,39,58,228,204,51,75,242,14,130,39,142,82,8,24,59,127,136,179,95,226,46,240,209,38,153,4,184,176,106,233,242,170,28,235,58,175,171,190,163,118,15,129,52,131,113,17,87,126,178,253,6,146,92,190,131,199,171,172,222,174,135,144,167,103,244,96,208,93,69,168,100,252,27,66,154,85,41,255,87,216,121,253,41,162,226,201,246,39,98,199,183,177,6,78,133,91,47,88,103,117,222,233,84,190,104,214,120,64,47,151,8,236,33,194,228,91,40,117,24,85,117,30,53,115,198,83,109,40,28,213,0,85,200,9,98,164,186,238,244,200,121,184,58,248,198,45,128,127,207,155,238,229,81,24,109,223,62,65,204,103,57,236,143,231,2,51,53,125,32,6,240,12,108,232,210,39,153,210,159,177,156,40,24,60,96,175,253,21,144,2,111,56,11,234,37,78,131,129,199,181,99,214,206,200,99,180,181,39,102,11,189,33,124,13,65,215,80,34,107,45,98,241,108,231,15,212,38,153,9,224,100,160,104,146,3,100,157,144,253,180,2,74,179,116,17,252,175,140,150,93,196,249,140,135,129,9,37,136,82,166,105,178,153,93,82,117,86,23,153,153,126,64,199,8,113,146,184,122,38,144,125,78,132,11,174,215,73,176,159,185,53,130,72,255,191,138,184,229,191,246,250,133,76,244,50,219,105,153,221,122,48,227,99,51,244,145,176,99,225,31,61,194,4,239,254,130,183,239,240,229,213,98,124,37,163,68,34,168,186,254,39,31,154,32,55,213,122,156,55,66,229,102,155,14,229,39,21,169,173,109,176,140,38,244,203,145,30,112,84,83,189,24,120,217,176,21,224,3,122,71,115,138,170,154,7,87,23,186,233,169,122,35,208,38,2,144,209,112,0,147,146,182,54,42,9,32,199,47,34,8,30,219,197,112,58,85,79,23,251,116,216,199,210,68,149,201,81,38,44,191,112,151,78,75,31,62,105,199,173,154,33,0,9,168,180,57,108,248,155,113,122,101,123,196,184,180,40,93,68,228,142,254,132,235,86,228,240,187,113,229,21,81,146,180,248,45,96,20,179,66,85,144,236,170,77,77,226,25,74,59,34,106,66,220,7,20,1,156,139,91,112,112,34,36,35,134,200,195,108,103,146,169,106,85,13,152,234,88,153,210,116,37,21,186,103,193,110,129,171,191,51,117,74,50,52,144,78,50,127,125,99,174,43,254,53,45,86,180,174,34,170,173,240,61,255,82,152,145,186,42,64,228,111,26,170,245,105,53,209,209,37,97,249,27,25,70,67,64,252,86,193,246,79,230,70,212,156,74,221,111,254,166,94,131,118,42,62,254,225,64,21,129,97,182,40,230,250,135,105,180,244,157,243,80,204,22,223,203,188,0,227,110,187,40,246,241,158,114,139,160,245,78,113,200,230,204,89,22,170,115,128,52,87,79,145,65,90,30,237,243,79,215,54,250,49,242,24,29,215,93,243,37,24,114,66,0,90,206,234,26,159,62,14,158,69,64,83,117,210,120,29,77,76,13,173,137,172,58,94,95,158,92,71,79,32,35,116,250,85,48,90,39,85,83,30,80,182,96,154,98,71,203,223,234,214,190,251,70,5,254,203,55,70,81,95,154,167,0,180,49,176,237,46,135,49,212,120,167,247,55,234,117,139,82,218,119,23,214,206,136,37,229,172,171,165,42,144,125,144,78,8,245,126,118,219,188,81,77,109,98,27,109,106,131,29,185,115,44,58,88,220,53,11,57,118,124,19,178,184,0,222,21,122,84,72,74,242,65,244,48,110,54,53,167,39,85,224,18,183,203,112,174,249,167,20,58,83,235,190,166,6,19,108,212,202,130,193,206,164,121,47,32,209,206,72,102,220,99,171,63,24,195,104,154,110,140,221,199,166,208,41,97,167,175,123,17,142,91,192,214,223,112,176,213,116,0,174,119,24,214,179,68,129,221,217,236,69,193,200,166,40,164,213,51,89,125,139,207,180,211,78,100,56,33,55,90,212,110,45,122,115,100,243,118,141,8,128,154,169,0,193,207,249,119,205,134,32,75,101,70,194,198,99,125,160,166,218,50,235,210,11,174,254,2,188,235,225,50,119,10,149,245,250,243,167,33,66,194,39,224,196,137,132,150,13,127,236,170,81,21,123,248,205,159,59,92,245,162,145,132,109,160,236,26,87,85,212,81,10,51,117,47,47,43,220,123,110,248,125,17,7,97,42,215,231,226,227,42,113,113,124,85,135,82,206,150,10,70,8,249,12,140,123,12,48,93,22,158,208,210,168,32,165,240,216,177,248,233,189,49,236,40,214,199,202,250,37,27,167,221,36,208,102,20,183,215,173,123,48,39,116,93,55,207,189,167,204,145,179,33,14,10,73,3,220,232,49,26,59,211,193,29,222,67,236,233,53,107,243,136,141,43,160,224,206,137,19,178,0,94,73,163,105,16,68,155,75,223,35,120,82,154,58,4,80,60,94,24,174,34,162,104,29,32,113,166,195,82,244,123,20,106,242,27,157,58,11,105,174,197,247,37,240,18,35,109,29,243,37,46,112,200,171,239,0,138,143,57,185,6,236,51,229,241,147,217,154,97,18,245,29,113,230,36,105,24,10,184,139,63,255,164,20,81,197,208,148,167,74,243,163,11,213,132,108,255,56,240,83,34,143,200,248,123,11,49,44,217,78,39,55,60,37,255,68,49,24,218,246,193,230,196,187,209,0,15,183,210,6,131,38,190,37,173,124,36,111,194,179,37,51,32,136,81,129,136,35,7,190,18,197,80,20,175,76,21,143,167,117,38,172,152,218,101,43,241,177,66,244,121,195,223,177,84,131,154,154,107,244,122,12,220,64,47,177,234,150,103,59,194,55,184,88,221,132,40,153,60,83,87,216,145,145,160,213,206,72,221,49,221,34,30,203,35,229,44,172,192,131,178,105,168,158,111,245,28,94,170,82,153,221,7,121,5,124,56,8,96,15,57,199,103,231,154,18,76,80,46,225,177,245,85,220,149,41,136,91,226,47,197,37,66,98,95,243,255,225,95,174,24,49,155,156,191,126,0,186,92,246,172,89,140,92,173,199,248,190,220,96,74,227,7,8,152,76,14,218,253,156,228,152,198,89,214,196,100,136,189,8,205,198,220,3,79,31,147,90,217,246,23,184,132,4,211,104,144,221,119,49,103,181,36,218,75,233,58,14,80,64,60,71,77,60,134,131,1,62,72,130,220,0,1,67,243,177,143,246,40,168,32,29,137,61,215,207,106,48,64,52,21,82,165,1,59,168,80,46,148,25,160,86,200,10,105,134,75,175,230,151,160,253,146,67,118,188,81,174,135,193,104,57,96,193,135,174,158,172,141,23,210,94,246,255,104,185,196,87,163,37,34,197,73,22,214,189,225,161,91,73,12,120,54,190,173,59,3,135,135,122,148,96,222,163,148,177,253,109,22,11,57,246,235,221,62,143,107,180,102,83,164,142,120,251,46,17,3,165,230,59,227,106,62,218,131,84,80,145,149,11,51,96,85,135,97,175,128,59,87,114,238,178,119,112,177,42,5,137,138,211,139,160,57,132,219,233,5,138,52,89,208,60,171,225,152,253,108,180,14,85,118,132,26,200,6,116,189,83,94,182,149,125,242,126,20,123,100,59,117,74,139,4,157,230,222,219,96,195,200,120,180,247,86,222,227,65,106,210,33,17,219,134,48,49,85,107,255,72,44,54,183,140,47,18,14,72,94,14,144,45,113,188,165,49,175,59,62,253,199,166,252,230,147,70,49,236,160,139,238,166,128,131,146,182,108,104,238,114,139,232,28,38,253,105,198,106,212,147,120,125,150,117,219,33,148,168,68,131,243,109,254,207,214,143,73,61,58,90,211,211,127,100,75,52,127,226,150,197,87,176,178,13,247,43,131,18,99,84,219,110,102,28,214,157,227,154,19,177,81,95,118,215,48,83,103,157,90,216,103,96,112,58,2,95,137,130,107,149,111,18,61,38,32,58,216,119,80,209,63,136,69,107,12,226,104,205,74,206,9,152,48,37,137,203,3,63,136,254,199,112,232,212,124,75,158,248,6,140,46,36,7,89,200,18,35,195,56,70,127,41,185,8,17,142,56,170,217,53,241,63,224,74,27,160,114,35,14,48,60,126,197,58,232,211,40,72,196,98,131,228,58,202,20,211,96,171,125,45,20,90,100,197,151,240,217,77,165,235,97,102,2,175,109,206,16,253,173,127,82,218,196,201,198,84,170,56,117,213,49,102,2,79,103,106,220,168,249,194,25,110,151,225,176,203,22,66,84,20,132,43,75,38,85,103,228,230,200,126,101,110,147,68,229,49,21,104,38,193,152,215,107,131,231,165,219,244,27,252,185,157,26,88,47,44,201,20,22,185,121,74,252,29,94,122,181,64,23,119,128,26,197,17,87,190,182,43,210,40,64,115,224,86,63,149,74,78,214,247,211,37,32,106,120,24,93,20,227,101,57,189,117,59,128,176,105,127,102,22,126,141,230,73,210,83,144,139,113,123,32,173,115,160,28,142,74,0,230,188,241,84,20,220,102,43,73,99,53,198,119,197,12,170,98,8,251,188,137,25,91,153,169,204,99,11,123,0,8,157,92,196,39,200,252,181,231,158,214,222,107,124,15,10,39,13,219,51,117,179,75,236,156,129,132,160,72,223,178,63,49,65,159,82,106,76,178,36,21,114,16,159,86,99,0,197,160,26,12,233,159,115,163,232,239,189,36,9,186,226,152,160,219,166,181,72,219,209,32,142,252,129,52,12,2,247,132,237,1,171,24,229,240,189,223,35,246,16,179,106,87,65,0,204,14,224,179,90,244,8,31,61,91,0,192,56,69,61,221,54,250,236,172,53,9,37,58,95,196,98,156,41,199,15,88,118,2,168,8,248,10,218,134,224,163,138,241,151,177,39,52,120,84,22,230,146,230,20,150,72,199,3,24,8,216,25,6,211,172,218,81,91,61,213,20,92,55,34,231,156,13,124,140,63,193,139,58,107,154,24,70,62,98,192,54,12,95,165,54,88,86,230,244,2,221,101,99,38,154,169,107,174,191,26,76,102,193,151,93,57,141,152,44,142,51,150,142,99,120,45,39,43,181,175,7,238,224,138,157,31,133,95,241,218,112,74,201,89,32,34,108,133,239,77,114,146,221,247,67,205,183,37,145,107,45,214,42,69,204,8,129,116,206,137,137,56,13,206,9,83,92,169,153,43,87,179,109,21,218,212,128,70,195,233,162,226,56,46,144,179,237,207,24,160,221,59,52,254,122,111,80,33,198,23,191,191,161,188,131,116,136,67,83,201,187,170,72,176,51,8,77,140,147,183,149,104,63,13,140,16,145,103,30,113,228,99,31,146,204,240,144,154,227,155,70,228,211,45,248,84,162,148,59,31,6,146,110,183,128,227,44,67,92,167,115,15,23,91,35,125,173,99,249,197,202,202,34,130,212,255,73,245,213,161,147,24,185,43,88,1,28,19,52,55,230,86,201,96,60,199,90,112,44,233,142,64,197,10,178,143,148,36,43,14,220,244,216,150,22,33,226,225,8,237,79,16,8,154,179,131,155,35,236,208,178,72,164,230,87,90,109,4,105,8,189,246,96,225,53,77,182,123,104,195,156,210,25,50,252,104,228,147,240,120,132,32,91,57,27,109,57,193,218,24,179,198,218,25,245,186,179,220,12,0,241,22,185,227,18,183,130,213,78,142,211,25,91,238,85,236,225,187,179,215,109,157,19,235,128,20,162,88,32,199,229,248,196,149,243,177,91,210,19,31,106,59,44,190,58,90,253,19,224,124,44,255,13,207,208,75,188,40,221,144,122,152,207,31,88,5,138,100,222,149,66,240,225,243,55,203,24,192,95,236,80,177,196,69,198,137,168,15,237,187,221,73,241,254,208,189,116,133,92,198,207,201,102,176,56,137,134,139,91,107,152,209,229,69,156,99,131,110,60,93,247,55,2,60,124,65,238,249,249,158,113,112,3,243,212,78,149,9,56,181,151,184,250,35,174,100,2,76,29,116,207,194,69,198,99,32,135,169,159,79,230,27,234,227,83,77,239,132,32,111,3,154,36,237,41,194,124,234,86,185,212,244,13,2,115,91,140,48,184,142,178,69,1,246,128,208,206,52,115,83,200,153,40,218,142,22,53,79,49,69,142,42,109,134,106,43,253,172,152,191,42,202,203,251,198,59,102,141,241,148,86,187,172,14,75,204,119,141,174,74,219,65,10,248,251,150,42,241,58,147,190,25,0,151,71,218,57,54,31,72,154,89,149,57,196,194,166,37,182,119,35,174,20,141,85,12,88,160,251,179,78,22,81,183,78,159,22,243,94,172,44,107,23,52,37,202,138,238,61,238,163,90,102,115,251,14,232,180,23,171,25,232,246,180,107,33,35,84,85,202,28,6,160,240,192,71,23,186,10,47,110,225,249,61,119,65,115,202,63,245,243,66,126,247,237,234,28,95,33,243,12,75,23,144,243,117,163,222,32,28,82,231,91,41,73,223,255,31,180,164,146,172,32,122,205,189,74,167,99,182,137,118,43,195,12,25,47,75,228,153,187,94,48,45,181,83,93,206,212,132,184,212,226,72,12,62,78,141,12,28,112,216,214,32,249,49,119,39,221,114,202,61,171,76,46,183,36,224,132,229,244,71,229,75,13,13,1,212,113,35,11,241,148,4,224,209,208,161,251,237,80,141,209,190,176,182,53,96,209,99,84,38,241,57,247,85,244,9,149,149,140,9,47,42,8,52,162,82,232,181,139,58,67,158,191,133,158,76,86,120,91,180,66,25,24,237,34,65,102,149,121,32,32,251,105,106,122,175,251,248,238,229,138,247,113,128,192,83,183,245,55,209,64,87,128,74,235,124,52,186,87,195,175,46,18,191,8,77,81,132,5,217,169,232,67,80,239,253,186,66,28,93,201,7,175,89,173,120,150,105,130,239,244,253,243,57,34,68,221,17,167,73,241,251,44,121,36,91,250,200,78,225,9,83,171,103,201,7,186,42,192,251,59,65,246,97,84,36,73,166,207,93,70,160,99,51,58,213,227,47,99,231,215,15,178,99,23,253,55,152,160,30,148,97,197,101,0,91,168,135,234,222,90,151,246,213,148,177,64,28,174,210,139,114,165,252,241,46,81,37,148,196,142,81,190,61,19,20,213,211,176,133,157,140,126,77,56,199,238,48,231,58,76,92,236,70,7,214,171,41,245,16,254,31,170,104,77,161,137,250,148,121,8,100,210,170,77,67,15,42,8,160,20,229,187,185,53,129,165,172,130,16,204,99,10,31,32,111,90,140,224,102,116,73,62,109,36,211,252,79,6,61,54,88,149,70,242,251,152,40,9,70,219,160,235,65,99,121,14,157,230,113,60,25,177,92,30,59,175,40,214,179,10,138,193,130,5,57,233,55,54,222,93,9,104,222,94,93,172,110,12,107,136,16,1,193,62,153,181,136,53,200,19,198,33,131,250,138,190,58,225,129,208,238,0,97,230,253,163,237,85,236,73,74,130,44,243,130,132,164,163,200,179,182,231,180,40,48,243,219,247,127,253,100,199,183,210,226,90,49,134,123,212,247,52,233,37,251,107,203,202,143,101,7,130,189,25,142,94,53,119,213,125,148,210,153,10,21,205,9,175,203,16,115,92,3,153,139,50,5,230,13,250,169,182,161,102,173,100,243,211,219,51,59,237,226,124,68,94,113,62,241,58,121,64,179,112,66,251,228,46,20,173,177,167,132,147,167,218,103,144,206,132,9,105,248,4,27,204,21,33,242,68,31,117,235,64,178,247,176,219,7,225,170,116,203,196,251,100,201,143,131,29,117,135,220,209,51,240,190,106,136,180,107,8,16,242,166,198,26,233,75,54,109,190,227,132,74,246,61,126,44,196,6,118,104,117,32,35,73,40,207,180,238,39,51,132,90,138,38,56,229,167,86,8,237,159,114,143,135,89,211,90,1,154,41,233,146,188,232,78,208,223,29,158,19,222,16,38,161,182,16,68,51,200,206,45,131,92,166,178,13,236,100,249,39,110,193,140,193,22,151,192,249,31,231,23,184,34,115,26,161,151,17,219,170,171,70,228,75,174,121,166,169,235,228,191,219,81,10,197,22,241,180,23,212,249,237,25,60,173,82,73,18,143,172,24,183,40,57,69,221,117,51,170,206,1,56,186,4,164,26,123,110,30,39,28,195,226,109,152,24,32,160,78,11,140,33,161,92,13,186,117,237,139,65,166,91,132,242,236,135,192,171,151,103,163,65,58,32,255,161,20,77,47,90,245,220,134,226,14,178,83,14,155,231,251,240,176,148,31,255,38,200,241,195,222,34,178,83,97,10,204,250,14,99,255,0,153,235,239,26,59,118,223,37,10,71,195,29,42,31,77,126,0,2,62,87,28,254,196,193,145,152,246,151,62,161,148,26,171,234,163,206,111,191,112,45,216,86,156,67,108,56,66,190,14,156,212,229,38,83,124,151,146,216,162,209,64,96,95,232,90,128,49,2,63,118,127,81,132,219,229,26,227,108,206,186,229,211,60,140,245,198,122,8,142,145,228,64,10,178,76,132,142,86,21,162,242,13,33,100,189,3,236,53,117,222,158,42,70,206,255,138,151,35,40,169,13,232,194,150,27,177,173,161,203,32,153,169,249,209,124,182,61,46,198,43,23,162,66,130,183,83,160,178,97,21,221,125,148,205,23,77,219,131,178,0,21,140,50,46,42,201,181,143,42,210,19,28,53,183,139,96,171,255,131,122,220,114,114,195,57,231,194,240,153,160,168,72,72,243,245,233,132,18,97,93,121,227,25,226,72,70,95,25,98,75,109,15,88,88,167,73,186,47,240,3,249,214,184,70,128,208,77,252,86,232,205,0,150,113,178,62,239,235,113,30,126,91,40,178,178,22,238,201,66,36,50,4,5,102,27,215,13,252,73,83,49,9,200,130,223,162,133,76,113,251,6,143,104,123,136,80,76,174,71,54,57,91,152,166,209,18,141,28,165,68,89,20,78,237,164,206,118,31,229,131,195,170,4,90,99,44,8,173,135,53,51,22,156,168,166,207,154,174,66,164,195,166,93,251,231,57,221,136,219,160,120,27,250,4,231,203,107,151,102,62,101,58,154,216,9,191,89,237,232,169,116,2,135,101,20,7,57,84,10,47,119,251,84,31,233,229,88,157,118,145,44,88,135,148,66,141,175,134,16,137,154,45,218,189,125,161,33,65,103,17,241,148,101,99,40,120,126,249,180,24,32,92,56,118,23,20,134,231,119,99,185,108,105,163,12,254,160,120,31,224,3,150,223,188,10,84,34,234,248,55,189,28,49,86,161,111,87,21,154,104,63,54,102,26,104,227,185,36,62,53,171,251,107,253,137,218,12,251,37,15,171,188,244,194,172,42,19,74,108,17,224,44,253,33,166,152,172,27,173,66,88,71,223,217,180,243,166,69,128,55,32,24,182,183,218,87,197,237,56,99,75,1,195,239,19,184,160,68,156,232,63,114,235,213,24,82,128,25,118,214,131,196,86,74,74,92,110,205,164,159,165,194,84,25,101,125,243,134,176,214,214,32,46,138,25,1,205,110,252,238,221,165,42,39,248,201,217,195,27,220,191,21,51,242,126,35,47,39,172,176,134,137,1,213,6,84,220,231,133,249,90,125,151,77,134,7,52,130,148,240,194,115,179,213,13,155,173,23,11,115,245,27,122,103,24,218,21,181,216,91,102,251,34,76,13,105,207,4,159,247,239,75,127,145,132,181,198,68,89,90,136,198,81,13,248,90,191,99,193,76,20,25,136,67,175,150,254,211,110,128,212,56,106,253,199,53,41,161,31,205,233,130,18,37,122,249,107,251,34,36,16,56,162,122,42,174,195,197,54,231,145,166,148,108,5,100,179,158,230,75,137,250,182,209,35,168,109,139,160,41,12,44,229,148,149,85,67,184,87,225,232,176,239,61,92,228,81,2,200,69,151,147,173,81,222,99,216,111,103,30,44,16,57,64,111,204,186,239,167,167,161,172,69,71,164,75,254,3,137,38,222,158,80,125,18,211,17,103,164,199,136,33,206,43,210,137,114,102,210,153,27,81,19,129,207,172,184,4,95,29,7,85,223,146,201,165,132,147,151,89,68,249,35,243,122,166,231,22,29,87,244,143,167,83,123,241,6,192,55,128,142,30,99,88,142,182,123,60,89,131,70,233,26,246,8,9,207,210,39,247,236,160,252,248,170,189,124,147,117,166,5,177,166,66,253,175,40,255,125,117,220,212,144,8,233,199,132,154,164,96,170,184,66,139,249,91,156,83,42,77,5,117,130,157,67,207,83,167,121,166,173,231,186,19,111,61,147,223,193,31,37,99,185,204,180,175,29,169,246,9,136,249,51,117,97,233,117,21,35,150,186,236,105,24,226,38,144,188,154,79,39,81,82,224,200,140,209,204,71,69,121,246,118,156,11,174,202,184,243,169,181,231,27,156,223,230,254,216,121,79,87,146,116,160,112,4,181,135,168,97,69,159,145,55,228,161,154,221,147,95,133,54,46,243,113,38,61,239,61,183,41,48,143,105,198,71,213,102,59,70,151,154,26,101,252,148,41,233,101,145,134,249,78,115,208,171,127,89,56,172,231,105,182,93,140,131,68,236,105,181,55,215,76,64,131,120,50,30,141,239,114,59,74,176,209,2,196,228,147,173,114,108,161,116,29,198,100,190,172,231,52,114,246,181,165,4,235,41,236,195,31,156,28,11,39,121,21,83,35,113,17,252,19,90,191,93,120,136,3,103,37,247,68,255,26,96,37,121,0,51,52,69,60,71,109,78,33,205,80,230,154,194,210,102,151,173,182,244,138,117,57,152,196,99,11,76,153,244,70,153,247,253,83,54,210,129,123,228,94,234,101,246,234,33,137,184,243,72,156,70,133,20,8,141,217,124,136,141,3,163,224,176,91,36,19,176,8,204,5,248,222,4,54,243,59,227,84,42,244,24,93,2,227,194,85,11,212,50,69,57,189,148,122,156,110,232,235,83,199,221,96,14,77,204,202,224,241,202,156,71,83,211,67,95,1,9,83,238,195,237,61,236,39,74,67,130,90,198,55,85,216,48,24,35,170,76,48,225,192,191,104,50,35,185,178,125,207,183,150,12,194,58,211,84,177,255,169,233,140,79,162,22,170,152,106,244,160,212,172,73,146,226,92,81,131,194,122,162,95,240,244,189,201,77,156,1,218,58,110,146,236,184,186,85,161,237,183,58,122,204,202,172,162,226,144,118,190,179,58,247,3,223,187,43,8,39,73,63,148,51,177,182,85,152,141,170,168,108,169,12,198,50,202,153,9,193,50,166,121,15,133,149,99,198,221,155,142,176,78,176,166,210,231,7,219,25,71,74,47,47,255,148,38,121,8,7,49,134,76,51,86,230,167,254,40,165,247,93,20,250,187,126,178,138,205,111,25,133,170,144,33,74,52,148,88,208,142,69,252,232,177,155,47,199,173,94,117,207,128,216,185,237,154,71,55,1,74,230,107,219,132,92,183,36,119,215,139,216,87,154,133,123,19,54,13,226,32,132,154,12,203,152,44,191,57,230,161,185,38,99,65,114,44,240,29,64,109,138,232,56,217,105,189,202,175,167,119,70,107,220,152,149,229,166,38,27,121,174,165,13,172,28,191,116,187,228,119,52,155,211,177,175,183,94,85,92,118,143,117,108,11,22,16,169,125,53,71,254,85,41,161,138,72,231,141,226,204,107,169,72,21,50,220,120,253,91,202,86,223,36,50,45,3,111,8,241,143,53,159,20,40,45,94,6,68,102,57,179,248,155,100,97,70,133,141,123,38,242,190,238,4,226,114,38,147,213,63,9,84,97,205,30,23,232,72,122,191,164,254,27,135,95,115,59,12,178,231,182,97,121,247,75,37,144,112,40,44,6,104,4,17,14,150,159,83,27,150,231,58,76,236,156,45,2,191,98,120,154,221,8,220,70,105,201,100,1,99,120,111,146,242,185,185,111,157,21,139,166,204,170,152,168,247,71,130,36,255,243,111,98,191,63,131,107,91,86,55,50,163,155,249,194,60,71,166,25,12,153,161,141,132,85,100,125,193,245,191,171,65,206,223,204,236,212,97,99,164,128,76,40,193,170,255,209,215,42,250,174,255,13,39,139,174,100,230,200,100,54,151,226,223,11,99,234,179,105,113,10,117,76,153,214,25,239,83,113,250,52,71,155,178,232,177,109,238,133,241,139,248,221,4,81,40,38,125,84,218,80,16,229,184,111,237,18,104,3,149,28,174,58,198,7,130,178,226,171,189,42,244,53,158,87,210,98,94,126,198,85,101,240,157,182,151,211,216,60,231,0,248,229,88,223,53,208,177,131,246,152,73,4,109,122,172,28,42,207,61,66,229,223,171,232,1,227,220,39,217,55,211,234,66,213,163,78,14,250,194,149,153,175,130,234,128,229,150,119,232,87,46,35,188,149,223,22,228,16,7,236,198,236,29,19,51,76,3,113,76,162,131,25,158,45,10,213,129,233,252,168,133,254,49,37,113,190,145,80,217,161,113,161,9,141,158,104,126,101,40,136,96,151,103,29,29,68,206,156,151,237,189,148,198,242,148,188,58,60,244,39,9,148,204,20,195,15,194,247,80,129,85,130,195,156,184,197,127,72,28,39,173,189,100,179,197,219,8,129,121,208,186,38,116,171,20,134,231,10,235,214,220,145,175,141,161,92,104,174,9,180,9,117,253,41,184,131,31,239,68,83,211,186,75,174,245,63,204,164,39,247,205,223,128,24,137,46,91,133,80,221,54,40,232,233,142,37,69,144,211,176,154,244,95,75,128,34,52,21,218,39,174,139,91,249,215,194,85,213,253,86,102,90,2,1,24,85,111,253,219,62,29,106,39,66,25,68,189,206,112,124,136,46,169,87,125,110,221,5,110,51,100,26,99,244,95,69,39,155,36,9,154,6,216,135,254,56,122,243,220,223,214,44,102,11,101,98,72,166,121,44,223,207,183,118,161,116,55,214,78,56,203,29,74,104,243,13,89,128,53,145,156,167,204,105,151,45,134,55,240,239,121,24,138,116,53,236,46,184,141,18,122,192,77,65,108,239,141,163,211,247,110,199,123,213,126,251,163,99,5,40,134,167,48,166,71,177,56,139,184,57,4,16,88,202,98,118,218,139,190,85,237,43,173,114,86,57,120,143,25,196,214,196,76,71,121,118,58,59,177,229,0,59,118,62,7,229,218,77,240,216,58,204,210,151,94,62,69,237,13,67,142,22,129,185,179,22,115,204,65,190,111,81,201,84,233,85,81,143,4,169,157,253,170,45,228,150,253,114,231,240,70,132,217,23,96,81,240,181,92,153,227,180,186,223,231,133,145,94,111,28,126,159,36,220,135,0,217,193,93,100,51,32,232,78,176,239,166,64,252,6,113,231,224,8,147,2,149,113,7,143,51,120,178,245,216,53,28,230,211,170,73,118,155,192,60,166,136,15,179,40,146,52,102,16,224,196,67,182,164,127,162,68,49,242,115,10,187,117,76,228,8,91,32,118,238,80,231,69,191,126,55,225,82,97,1,49,195,100,27,102,0,140,8,1,128,149,32,108,77,51,14,198,109,171,183,26,83,171,126,49,230,2,6,129,177,241,156,37,37,202,112,66,76,230,179,14,63,22,207,142,107,69,191,74,205,117,39,39,13,242,120,120,121,127,228,175,114,141,37,238,160,152,230,28,15,211,25,126,247,33,78,68,15,125,195,158,99,185,72,50,174,149,97,128,123,235,70,151,186,134,69,197,125,19,87,232,165,144,144,225,100,54,119,163,173,25,219,120,116,110,77,169,30,103,149,142,79,143,115,249,155,140,150,116,190,231,113,111,144,19,33,232,119,102,250,140,1,68,167,147,73,144,131,243,168,87,52,81,82,21,137,116,245,120,197,243,93,231,158,208,142,20,169,159,68,255,215,113,88,119,123,235,158,30,234,61,96,183,62,235,25,68,43,166,81,171,43,145,127,190,99,104,36,79,28,249,45,197,87,205,39,240,184,201,186,145,7,196,156,140,72,22,54,233,170,91,78,65,119,49,64,100,249,74,123,240,18,124,243,203,173,151,84,244,88,233,175,115,187,195,74,229,67,222,117,15,157,210,251,55,176,81,16,115,69,22,192,242,166,137,54,203,83,77,91,201,156,159,73,251,33,169,18,217,172,218,75,230,243,183,135,128,24,57,216,248,173,159,166,129,246,111,170,243,124,208,181,68,145,131,39,229,16,135,189,182,14,145,50,237,234,67,181,175,181,45,171,167,244,231,190,147,52,19,60,17,251,161,39,136,168,10,153,109,0,165,180,226,89,194,100,83,136,223,216,34,78,114,142,242,215,95,106,107,6,48,159,87,86,67,209,119,159,247,167,240,110,137,163,121,45,139,52,185,127,13,226,203,19,42,195,115,193,39,248,183,17,243,64,97,75,196,14,200,251,109,64,118,58,184,163,242,5,122,130,251,58,229,86,215,46,218,229,246,106,228,37,212,144,10,194,70,126,250,7,29,222,251,87,97,131,153,213,130,4,210,2,246,228,176,31,101,59,195,103,160,24,67,101,251,22,87,36,83,236,7,190,72,95,168,232,38,13,44,113,248,1,234,159,186,6,204,249,237,141,94,143,103,131,100,106,182,45,39,203,125,159,205,33,216,33,90,74,192,238,108,140,27,110,232,35,19,236,123,205,213,60,167,99,98,159,42,41,207,146,97,75,245,19,219,169,8,2,134,214,186,227,38,231,40,202,167,61,162,197,21,83,246,143,152,49,246,61,132,11,2,188,49,53,22,216,220,111,42,20,253,218,14,86,84,245,200,65,255,187,173,219,19,230,192,101,236,70,50,204,182,95,22,184,240,94,63,119,173,169,233,47,38,217,163,27,241,45,45,139,125,53,240,252,8,88,191,230,236,184,14,128,137,136,216,11,99,253,235,182,113,241,56,173,52,149,100,171,35,247,117,200,174,46,126,89,52,31,199,23,25,23,118,136,115,2,202,132,202,21,242,132,167,8,223,234,234,222,202,198,188,153,228,12,36,96,180,228,223,68,67,213,242,37,151,81,130,146,33,173,165,130,6,126,161,91,155,251,230,67,106,89,48,8,93,223,36,89,125,224,207,78,119,225,75,3,39,151,44,206,235,249,36,68,42,227,10,205,167,53,247,36,49,217,32,235,64,110,217,199,32,38,52,100,123,18,88,215,134,116,0,255,18,0,18,144,75,187,70,254,72,20,173,229,27,67,157,45,41,231,55,69,12,199,242,159,111,34,164,117,245,205,104,244,179,18,67,79,246,21,209,33,5,77,74,54,205,118,88,79,184,53,5,145,235,57,94,141,134,243,71,98,162,204,114,92,165,108,96,156,3,23,176,45,34,235,162,9,118,202,205,51,141,158,239,17,241,155,102,117,184,16,96,222,186,156,128,93,234,15,5,55,119,132,109,28,37,152,253,78,79,118,72,173,91,140,135,49,61,156,246,187,130,240,160,80,86,67,80,36,228,74,142,177,208,175,4,245,209,206,212,27,14,31,124,238,139,5,89,8,242,97,227,179,183,45,62,114,250,179,138,160,197,159,39,167,141,76,249,151,230,62,14,122,253,48,56,236,181,211,53,207,125,137,233,51,2,45,188,90,10,78,163,169,218,8,134,253,135,27,125,121,76,235,186,67,239,200,80,40,86,160,246,120,215,142,31,133,26,99,24,77,253,249,100,215,94,139,118,12,210,87,217,167,5,83,83,252,125,80,11,127,255,126,55,63,160,230,183,6,14,17,141,189,160,171,199,168,175,119,29,206,105,23,157,168,193,227,219,211,230,32,176,135,235,17,196,246,138,24,124,27,221,255,210,24,250,129,107,231,205,142,43,243,4,174,246,104,176,31,143,78,171,13,232,58,133,71,164,138,67,7,24,175,133,210,191,154,100,213,195,129,152,82,202,148,128,142,229,249,179,104,186,82,194,54,68,25,238,133,27,104,114,183,82,134,64,85,197,109,49,250,251,26,74,23,106,30,162,91,204,0,139,236,34,239,7,186,96,43,154,48,24,80,195,101,201,49,213,233,22,69,255,126,1,124,25,235,84,43,144,189,40,144,13,129,244,174,12,226,126,141,191,154,242,23,181,73,22,78,230,138,70,90,250,81,59,140,111,77,33,166,137,168,118,17,89,216,13,126,124,244,224,31,169,15,169,25,217,152,98,177,200,188,69,2,108,53,115,44,230,0,42,25,156,14,176,108,219,133,240,12,121,18,221,192,187,131,247,185,73,186,245,56,90,5,78,45,11,151,114,72,87,169,84,183,25,9,159,59,148,220,237,11,185,211,218,90,237,88,214,214,197,6,90,199,182,98,78,67,38,132,106,67,51,99,4,186,141,220,118,104,125,117,177,85,146,150,234,70,95,96,170,230,44,1,220,158,236,146,180,14,201,232,42,231,240,106,167,252,7,111,113,96,231,65,12,198,223,218,233,143,13,240,98,55,112,154,84,149,94,65,35,80,227,129,52,112,176,220,21,78,163,70,37,227,30,142,213,116,222,69,101,130,112,87,21,45,254,51,86,244,55,46,61,106,212,110,173,203,40,111,188,127,207,72,222,49,154,23,186,179,19,93,155,24,93,17,126,82,94,169,39,203,128,53,125,124,78,114,182,6,127,136,231,33,91,194,71,252,251,46,85,149,43,129,173,154,228,166,130,159,231,149,54,160,102,54,80,21,6,124,230,170,141,97,156,184,199,69,161,189,185,143,125,108,134,28,147,149,133,240,153,92,120,89,213,138,155,30,66,156,213,81,171,137,213,246,204,247,213,231,225,126,226,12,107,109,127,85,155,26,253,124,127,54,105,165,133,252,146,11,173,95,181,59,38,250,56,30,185,178,19,186,211,142,72,237,103,69,43,154,53,163,0,146,211,221,125,221,71,160,208,164,224,114,219,202,33,181,93,149,189,87,139,213,118,35,35,26,195,86,147,242,68,48,106,195,114,190,17,109,7,63,215,175,180,164,225,150,101,214,32,180,34,187,40,113,119,187,71,210,4,26,177,53,32,168,143,221,35,78,224,219,191,54,52,120,229,226,197,192,229,131,61,193,2,123,28,19,72,200,136,13,39,253,176,69,36,35,222,134,191,225,205,207,25,24,71,92,127,254,178,241,216,234,208,13,74,88,45,232,37,234,242,161,187,111,80,9,106,246,154,48,58,118,127,194,82,82,54,84,10,216,115,189,151,44,135,209,130,194,121,16,211,75,57,12,162,212,7,64,46,111,244,182,106,8,252,95,203,209,54,89,130,216,97,48,168,96,139,249,243,192,130,13,158,143,211,36,89,104,252,214,177,60,59,207,7,51,41,239,55,227,41,109,167,120,25,75,198,136,76,22,224,234,242,70,152,109,236,149,254,176,230,254,4,125,19,142,246,203,25,35,248,171,102,243,51,107,5,247,28,95,157,234,200,131,208,226,233,111,181,241,0,49,121,71,100,15,219,104,233,165,34,128,36,25,12,172,63,236,56,175,172,45,134,129,5,249,29,118,158,237,169,82,12,116,229,176,239,181,224,148,29,140,4,81,24,255,105,4,109,134,141,113,202,75,173,62,21,77,105,104,86,45,43,125,252,184,125,140,140,90,58,177,20,46,176,107,249,140,53,119,160,135,185,152,173,112,255,136,64,55,26,38,222,183,74,120,125,131,207,206,16,104,87,85,35,172,126,45,196,167,50,161,167,98,140,18,28,113,89,107,218,168,168,164,225,78,51,214,50,145,18,59,117,145,7,91,195,40,56,205,11,223,222,252,23,154,235,39,19,64,39,237,192,113,121,97,146,89,203,214,211,198,105,48,246,207,107,58,143,63,194,216,216,114,181,125,147,17,222,235,17,172,11,31,185,194,23,122,193,182,150,61,133,64,226,131,46,168,90,212,47,116,204,120,58,16,173,135,219,91,253,236,121,20,70,62,230,58,27,242,132,62,203,159,45,199,106,91,189,27,8,28,54,230,225,39,202,226,227,71,137,242,167,169,43,113,16,218,161,52,235,114,152,169,158,109,69,171,57,167,144,61,133,36,108,56,187,214,133,126,91,8,94,245,171,121,95,2,110,36,251,104,75,150,112,248,207,108,76,230,81,191,216,136,79,237,120,248,70,114,70,210,194,52,133,235,21,140,11,80,13,201,86,194,155,57,215,111,80,33,99,146,95,51,44,51,76,91,213,223,185,41,140,233,76,151,61,252,192,131,237,118,115,102,172,121,10,238,254,38,12,11,254,86,111,238,181,201,226,191,237,177,88,223,36,44,246,33,84,0,15,38,212,49,200,203,173,247,5,79,4,37,195,127,241,172,52,52,241,16,244,246,108,53,228,161,31,96,186,21,232,185,24,169,87,210,32,23,145,153,120,111,205,166,73,2,139,226,250,175,124,224,132,59,65,15,81,31,69,56,127,197,111,148,125,84,58,234,240,252,251,190,141,150,108,45,82,135,99,224,149,197,97,99,193,142,18,60,217,131,245,202,47,63,127,246,59,133,227,104,254,79,35,45,203,244,43,180,198,216,101,24,216,165,135,98,177,171,164,214,113,192,167,46,65,148,162,239,155,55,17,82,91,137,85,117,233,193,232,33,225,129,180,4,18,184,120,30,242,217,161,72,189,28,188,64,145,135,52,62,136,127,32,216,253,150,45,42,50,111,106,165,45,153,62,207,7,7,56,179,99,162,44,123,20,55,192,188,101,238,49,103,7,245,10,242,14,93,85,156,69,198,120,50,18,41,55,110,154,217,253,26,128,64,97,167,138,143,127,11,111,112,235,130,238,95,88,191,231,8,41,181,187,104,48,58,95,108,0,252,157,219,111,50,38,181,123,18,57,187,145,234,112,203,225,142,222,210,242,36,206,26,133,160,121,216,10,22,216,6,84,64,91,34,241,196,180,25,200,113,241,212,218,230,73,47,142,79,64,63,183,229,133,161,57,234,47,243,26,116,105,21,171,139,130,88,157,60,166,14,68,3,150,111,178,182,160,90,43,7,4,239,94,210,78,28,155,201,54,106,34,144,15,89,198,209,30,249,143,1,225,101,5,94,226,36,26,140,229,233,124,64,45,142,253,144,188,226,152,251,193,202,151,107,65,101,57,68,136,157,90,7,65,203,6,94,168,166,185,237,86,29,148,22,41,41,108,232,117,10,19,42,132,140,121,80,226,0,45,154,46,57,51,41,91,123,201,59,47,218,103,169,152,154,146,129,107,166,181,125,61,125,170,99,160,138,87,43,36,221,0,194,68,63,12,174,52,103,233,169,190,107,21,109,125,125,9,80,133,50,112,156,198,196,241,141,80,234,44,28,102,167,155,177,165,14,61,66,145,240,98,34,88,195,68,19,92,212,183,200,207,31,127,57,54,143,93,166,14,254,247,80,171,146,224,29,61,202,220,135,199,223,167,107,192,156,79,138,127,115,132,155,255,238,79,244,23,157,253,107,189,208,173,248,80,92,137,219,253,221,113,103,252,237,214,145,6,0,104,171,229,127,199,250,110,151,245,124,207,45,40,119,145,123,113,100,147,61,18,198,57,101,42,176,216,35,184,184,78,178,215,151,207,56,238,128,80,95,208,20,27,207,44,81,184,56,220,150,32,176,155,254,107,218,46,189,87,48,239,59,234,243,214,214,190,128,55,249,57,79,207,248,16,36,31,51,166,48,139,85,65,200,34,229,182,187,226,226,161,213,160,243,180,236,68,253,252,242,232,242,173,81,84,210,215,73,141,224,107,107,243,244,123,166,94,33,53,93,76,48,246,233,229,51,209,155,23,211,79,210,144,238,192,191,94,159,236,253,30,135,68,1,254,245,153,102,18,78,1,229,225,141,232,220,216,147,71,165,181,3,247,49,211,80,29,166,126,44,129,131,231,90,55,158,72,167,31,179,90,41,211,147,48,58,76,7,25,209,184,59,244,199,174,67,94,224,172,76,200,240,115,168,183,223,209,241,151,83,114,223,228,186,146,59,179,96,25,102,87,207,14,11,13,52,99,116,145,212,82,209,248,46,46,193,104,112,235,215,15,75,115,74,73,96,166,39,95,67,158,84,237,34,247,10,187,232,179,104,240,173,194,149,20,130,107,47,136,26,238,17,225,236,124,5,59,230,193,111,200,244,164,56,190,252,237,243,204,64,223,114,38,143,43,60,211,19,35,44,18,104,223,162,68,88,244,32,227,131,173,210,135,165,141,143,1,97,200,29,210,80,49,181,78,35,223,209,252,100,142,29,242,25,166,86,93,95,199,95,99,5,209,74,253,39,231,123,219,135,253,21,33,69,249,110,169,131,90,111,184,11,172,132,246,196,71,155,87,125,229,253,102,118,116,248,69,222,44,25,114,70,222,225,124,32,148,29,130,95,49,14,207,107,212,201,173,45,86,37,171,46,132,4,184,194,36,128,91,248,141,197,159,63,36,175,91,23,248,217,196,213,222,157,44,155,225,168,116,143,96,4,119,39,253,111,180,89,21,123,18,139,195,191,138,160,184,26,215,94,57,142,51,76,25,189,242,172,191,31,134,101,247,188,190,125,195,119,122,248,176,46,110,30,154,237,140,167,92,36,7,216,34,162,210,217,235,109,44,5,125,185,118,194,37,134,218,248,182,213,222,96,146,52,115,116,53,214,108,167,13,149,233,41,106,241,55,1,239,133,10,49,144,3,113,7,101,233,96,34,23,50,167,135,115,62,218,49,15,181,56,42,44,38,15,50,172,242,136,131,5,8,204,177,193,228,210,214,89,73,204,35,96,221,195,112,0,155,243,32,157,245,196,230,202,50,145,123,71,33,98,105,12,40,202,229,174,92,208,240,229,54,125,118,219,40,227,179,180,200,198,220,180,43,169,139,129,157,68,87,236,168,23,98,3,218,82,217,167,51,75,244,102,28,12,110,168,148,235,138,90,175,176,130,134,56,246,20,159,174,101,89,254,42,137,8,61,13,34,86,162,47,243,35,111,68,99,48,206,38,216,23,158,114,243,154,32,16,236,207,51,136,5,73,113,240,89,86,165,158,125,164,122,61,77,122,28,196,226,119,76,215,4,161,250,17,55,172,9,116,129,66,132,70,46,7,146,215,89,208,205,126,120,162,86,250,28,47,126,178,12,213,79,191,22,225,105,193,43,74,63,53,15,115,7,152,16,157,66,52,202,67,173,201,201,246,152,141,109,11,106,190,254,84,138,233,214,90,227,40,229,27,242,245,117,232,216,106,151,253,17,235,113,42,6,227,233,97,185,101,202,60,205,238,211,82,113,59,253,106,144,245,232,211,188,219,29,167,205,62,184,5,209,158,175,46,186,233,231,166,200,3,222,102,65,213,154,180,85,129,69,241,9,76,208,171,19,249,180,91,136,233,59,189,93,234,245,46,222,244,15,18,250,29,69,63,150,201,244,46,110,86,180,6,226,119,75,181,247,213,104,187,224,49,165,251,3,139,86,68,250,173,40,165,27,9,1,9,212,233,4,176,189,31,73,212,62,12,69,169,146,4,146,47,165,107,107,34,134,160,142,123,53,142,46,77,102,222,130,159,183,80,20,57,23,134,240,90,166,26,47,131,153,83,63,170,14,8,188,177,179,88,230,102,49,42,107,232,209,86,198,202,171,94,137,229,218,157,213,167,77,103,158,187,60,171,9,54,231,114,9,167,66,33,132,5,217,241,207,76,236,152,159,81,191,4,162,129,163,114,72,109,87,229,39,157,130,98,25,150,123,216,19,94,111,176,241,162,225,181,177,39,60,163,20,222,217,35,245,240,161,78,243,18,109,237,75,73,211,212,233,88,152,18,12,178,213,92,7,29,114,64,81,118,33,83,16,99,29,111,221,39,45,11,30,170,200,55,162,217,170,64,79,149,168,143,243,122,40,105,253,169,149,99,236,55,176,215,18,191,248,224,149,213,9,83,247,137,235,203,49,4,198,108,134,75,114,166,38,140,205,74,80,209,62,211,129,42,126,144,163,77,206,193,151,253,128,40,111,216,126,175,42,69,205,95,209,136,158,248,89,176,200,216,143,189,23,78,53,113,125,114,154,250,217,177,120,13,231,240,240,47,171,139,44,233,146,147,37,179,186,69,46,121,254,204,0,91,74,146,95,207,209,90,42,43,208,26,209,159,113,143,34,20,144,14,221,19,174,215,203,165,136,92,46,54,184,49,76,61,210,75,237,122,187,163,209,187,107,149,136,159,179,142,14,129,127,193,113,134,114,185,189,145,209,205,73,251,7,96,130,198,205,104,216,207,16,27,190,66,26,50,109,230,153,134,6,160,159,139,175,215,196,31,188,18,185,188,61,138,175,89,47,47,182,13,209,56,152,219,124,199,172,227,230,5,22,141,249,69,182,221,74,11,117,12,56,178,60,190,233,126,62,217,89,136,79,255,40,96,135,24,151,189,225,62,60,202,151,184,139,241,215,79,69,162,251,178,76,217,4,197,108,127,166,12,253,206,125,229,63,126,205,148,171,146,193,116,188,166,43,9,2,1,126,23,81,235,64,252,178,74,183,224,124,107,153,233,192,71,94,11,226,73,104,6,43,32,99,72,80,52,171,206,119,222,170,248,163,61,190,229,148,206,230,231,55,41,75,95,199,105,10,14,181,124,66,7,118,32,107,49,108,246,49,225,117,236,96,67,250,111,42,141,7,8,110,108,99,117,113,174,107,245,252,145,146,12,96,139,79,23,96,29,227,183,150,169,242,221,151,4,17,3,64,248,211,113,147,192,241,69,208,22,44,227,162,110,17,24,57,99,54,146,39,184,110,130,236,64,237,176,213,164,113,13,84,121,163,169,202,137,20,29,241,3,30,21,241,151,140,99,50,24,238,107,53,139,203,142,252,96,18,184,71,31,231,88,55,243,151,3,75,100,112,228,120,29,75,147,24,50,68,210,115,136,200,45,240,54,185,3,93,71,255,130,57,111,247,1,57,27,130,184,165,110,212,10,99,168,73,41,191,69,12,172,127,51,142,50,112,180,113,125,102,43,146,28,47,10,69,12,231,169,192,210,6,38,209,23,124,167,27,135,234,22,154,164,23,176,137,60,157,130,209,224,57,146,14,236,38,57,105,240,77,255,129,92,23,178,27,254,15,62,248,49,50,167,225,192,33,176,201,83,175,50,63,195,35,9,217,171,163,25,117,211,215,179,221,234,119,75,227,143,143,6,32,148,36,139,250,255,101,42,245,223,41,39,165,86,180,28,75,158,71,35,39,230,158,190,94,163,114,83,133,125,204,146,169,222,102,115,236,230,199,185,70,185,241,211,240,37,218,161,192,132,30,223,66,187,141,91,124,24,183,205,48,199,107,204,179,247,52,121,226,182,18,60,220,120,117,99,249,40,71,255,183,171,98,18,164,129,255,48,111,103,250,92,225,145,96,229,159,104,152,170,79,186,254,195,4,2,215,167,22,171,99,191,28,174,95,138,254,229,116,132,30,111,70,240,245,148,242,219,222,134,82,165,238,217,179,179,86,145,70,140,92,231,14,207,102,194,63,172,203,65,33,218,13,155,76,185,107,122,95,50,42,255,201,34,115,53,221,61,41,55,94,55,86,3,229,122,31,101,170,198,255,57,152,125,9,124,187,108,137,148,170,101,16,212,95,43,188,79,166,228,125,79,144,215,249,48,179,87,182,151,117,158,196,21,58,28,207,138,21,173,249,0,134,173,172,239,144,45,31,103,165,152,20,98,131,11,96,153,203,110,36,193,250,237,145,141,155,127,240,254,224,130,60,239,234,33,68,31,235,220,191,193,204,235,243,16,95,177,163,163,181,9,83,47,185,186,114,63,38,20,131,221,16,38,73,235,220,108,157,203,230,154,185,20,70,235,23,255,212,212,145,42,8,27,142,188,20,202,57,171,42,184,35,143,159,221,174,249,59,69,159,151,149,107,153,79,214,251,179,211,182,123,242,191,229,98,218,128,239,13,10,246,229,177,24,111,52,220,192,118,36,182,155,160,120,140,236,234,63,65,33,50,244,42,108,232,176,94,123,220,43,246,114,13,122,103,154,198,244,112,94,33,213,137,138,140,101,205,122,157,27,107,172,192,36,192,89,190,243,84,14,189,4,115,131,185,73,41,53,253,114,208,23,223,233,78,34,189,235,159,166,152,42,242,134,9,115,139,192,100,53,117,148,164,25,63,108,0,128,154,144,122,89,124,136,132,13,161,108,149,253,193,224,26,78,74,173,152,128,215,186,232,156,112,78,112,75,94,196,58,34,217,191,215,44,109,159,235,212,236,73,93,210,183,209,55,204,152,149,239,39,129,164,201,208,178,112,214,223,83,185,36,19,6,182,67,84,52,59,18,240,118,78,97,209,102,30,170,192,111,53,145,74,79,59,199,187,22,47,235,239,247,130,231,210,71,162,38,169,184,252,134,148,43,190,22,50,9,38,175,134,160,226,255,85,161,158,114,184,227,0,116,152,189,250,171,175,151,241,200,233,162,247,43,18,224,100,249,241,117,183,19,144,184,219,8,22,85,213,235,240,26,187,245,165,242,110,144,173,158,128,46,40,171,42,153,26,168,204,105,25,159,112,47,204,155,125,83,254,66,29,232,184,98,44,122,2,96,170,157,176,6,55,5,73,95,254,9,174,142,57,194,37,65,122,40,1,123,72,59,224,127,89,62,188,191,12,71,200,80,35,89,70,148,217,90,134,164,242,64,84,43,97,29,201,172,93,208,180,73,68,87,24,76,38,148,211,170,93,172,125,173,214,200,30,226,145,69,16,36,25,191,96,25,192,129,81,249,57,169,121,133,232,158,200,78,202,132,92,219,213,80,99,103,46,248,41,147,160,55,227,2,155,238,150,160,25,241,169,123,132,186,124,153,118,29,228,80,162,197,83,220,44,168,250,216,5,200,14,79,35,150,189,139,25,142,169,116,218,16,44,57,1,18,42,175,192,132,111,212,78,206,250,192,138,84,137,51,170,136,78,17,255,98,119,42,249,240,203,145,119,206,40,54,136,88,11,35,103,100,15,215,120,14,187,134,190,53,239,35,181,189,201,91,47,127,2,152,175,34,246,229,160,42,39,21,137,20,181,17,87,253,224,100,218,134,173,93,196,110,207,64,106,70,52,87,48,134,182,109,115,216,134,78,235,173,237,15,122,85,118,93,245,185,17,213,255,4,135,204,53,244,245,255,21,80,97,99,112,203,99,116,108,81,104,243,42,169,88,246,170,139,163,193,84,55,143,234,137,157,153,3,77,103,30,212,73,164,133,40,178,78,150,207,47,8,5,58,190,170,159,148,48,113,114,130,1,156,88,144,253,44,24,147,221,37,226,50,52,169,95,167,195,74,194,47,56,87,202,188,232,18,246,62,226,58,225,251,83,248,108,34,97,174,244,205,254,208,118,115,7,82,251,36,144,201,102,149,155,218,135,76,174,151,164,178,151,156,236,164,30,13,0,128,98,74,76,175,10,245,193,1,170,81,152,243,62,18,59,121,216,177,88,25,3,201,185,249,49,215,19,105,148,131,185,218,49,76,13,134,149,19,32,180,123,58,2,199,103,25,192,75,6,207,130,99,112,15,151,27,183,93,77,16,214,241,217,230,79,253,200,134,143,181,8,91,43,20,133,136,119,98,172,90,133,79,7,12,193,201,110,74,25,48,166,40,161,240,191,125,153,176,159,182,187,56,89,70,255,75,6,36,194,17,163,33,60,75,32,57,185,202,53,72,104,136,127,71,43,252,70,173,238,188,136,12,113,152,108,184,88,230,27,69,45,97,33,113,96,249,242,17,89,4,244,230,198,99,77,192,51,202,147,123,80,77,230,245,243,243,127,150,228,151,45,66,49,228,253,83,220,108,1,224,145,238,135,215,68,176,193,135,199,220,186,248,37,207,145,32,25,235,159,151,65,78,174,197,7,187,83,140,60,148,226,118,203,84,46,126,179,43,205,138,195,122,250,35,14,95,165,147,88,1,132,168,56,113,191,12,0,168,77,182,236,192,70,225,133,241,224,214,176,190,22,212,59,222,248,53,17,43,176,204,68,140,174,149,112,217,161,78,126,241,243,93,134,182,44,29,201,88,153,175,254,114,241,7,235,152,193,172,236,218,243,205,249,169,167,137,89,190,26,208,132,16,21,7,65,46,107,154,191,211,41,95,52,125,138,197,211,243,188,207,27,82,84,9,111,70,196,25,82,35,63,3,126,128,139,126,26,38,164,135,166,35,40,108,202,65,13,189,220,237,73,179,209,56,146,18,166,197,58,31,146,38,142,119,141,73,224,99,83,51,246,163,194,250,69,223,188,235,41,104,69,73,97,253,93,216,45,220,138,160,168,110,44,111,155,34,25,171,230,65,81,136,236,250,68,6,71,247,27,136,113,131,144,150,64,35,20,35,146,229,187,32,234,172,243,76,90,8,231,9,101,191,1,2,72,142,183,150,221,192,123,85,87,113,71,188,255,4,124,192,90,165,164,118,142,160,141,17,67,131,220,177,188,252,203,10,181,97,18,106,15,238,51,19,209,240,211,101,196,75,253,7,81,98,99,53,182,87,150,53,96,196,117,95,154,229,137,186,143,255,229,13,127,182,180,132,197,57,162,101,97,20,70,210,243,175,157,55,93,95,241,173,156,165,33,44,134,153,28,209,235,79,157,209,1,135,169,203,183,103,28,138,164,157,178,251,46,30,170,215,186,50,62,158,5,57,56,127,187,141,1,188,201,5,255,235,136,13,201,131,149,227,179,255,174,114,217,185,171,61,62,199,21,182,135,244,168,117,111,217,142,172,23,238,163,30,218,66,153,151,160,166,177,179,15,242,138,66,236,213,254,162,101,21,69,130,104,231,180,94,113,175,181,211,88,89,244,46,191,106,8,180,3,135,225,139,108,105,132,218,50,75,243,122,151,133,11,211,0,179,115,98,212,225,127,124,64,15,237,38,107,222,65,48,153,82,77,250,82,12,239,225,185,17,69,198,195,64,121,238,161,87,59,138,105,111,52,201,56,59,247,242,216,1,164,141,205,183,153,224,87,155,211,191,209,128,253,64,0,199,108,6,40,122,226,10,205,29,104,236,202,164,80,4,89,252,92,216,106,175,184,141,165,127,105,197,210,145,22,115,114,29,241,123,195,200,36,109,105,227,155,188,131,45,51,143,140,161,119,131,19,161,175,140,103,106,228,183,215,176,95,93,98,255,139,170,143,17,97,150,61,207,242,26,164,156,239,32,167,136,87,130,34,10,149,201,191,199,198,34,232,241,155,217,238,46,122,245,146,46,118,184,148,86,81,49,132,13,241,202,135,162,127,12,70,32,61,204,176,110,92,152,235,51,35,152,155,210,130,201,142,62,169,215,245,79,149,141,9,59,202,157,77,227,57,129,153,154,97,219,191,73,238,21,168,42,208,204,139,177,242,91,242,251,179,215,120,130,234,49,235,82,88,65,4,183,85,153,12,2,152,123,43,77,74,65,5,28,78,163,104,163,8,131,215,64,1,228,173,68,102,72,21,239,155,199,150,213,4,137,32,73,84,253,231,146,52,190,15,187,163,239,120,129,248,33,90,0,30,197,217,66,170,210,140,119,236,189,74,128,134,232,191,165,23,71,146,56,129,124,206,222,147,21,198,97,145,202,202,25,123,92,141,11,61,58,253,1,81,132,29,161,235,157,168,157,246,132,130,159,135,37,20,241,80,254,184,201,209,43,3,212,10,96,128,58,115,160,191,85,16,25,65,27,243,178,32,230,104,190,245,232,25,180,177,188,19,37,142,32,110,175,62,167,190,55,146,188,87,220,243,172,75,232,198,122,160,49,205,25,100,203,97,62,174,101,36,101,190,134,45,121,141,91,127,171,81,48,57,114,213,53,49,37,213,171,125,109,38,192,132,244,84,190,188,48,138,199,207,251,178,36,52,124,123,254,175,156,236,55,192,67,154,102,69,214,189,2,169,53,104,175,183,96,20,127,6,68,181,31,95,83,17,13,240,216,94,34,240,97,42,185,117,5,65,23,193,170,61,244,58,119,49,240,141,160,161,35,168,21,14,119,68,203,73,88,148,87,181,118,83,28,221,191,200,10,98,132,115,196,69,180,76,17,7,167,137,202,175,224,72,151,83,80,166,57,101,239,6,90,7,129,157,128,56,243,199,14,125,42,249,219,154,184,1,246,88,25,115,156,191,255,183,251,27,140,9,228,95,111,168,147,159,226,27,88,158,31,43,73,127,168,133,212,73,72,176,91,78,180,30,217,243,71,173,71,209,7,69,37,248,104,194,17,161,240,129,104,219,226,78,76,83,49,37,165,170,164,147,164,122,141,26,186,181,100,136,187,192,11,4,5,80,237,159,125,92,73,106,63,168,181,131,96,83,142,172,42,104,216,130,129,66,181,206,173,22,138,153,225,130,65,54,221,59,51,28,183,231,214,72,137,142,211,206,231,215,176,102,144,166,51,14,120,120,38,97,6,234,219,139,75,97,14,63,253,97,205,60,80,124,100,109,137,83,236,206,101,131,186,32,226,17,145,64,205,92,96,95,95,46,4,127,119,84,204,123,255,123,15,158,53,162,235,27,77,204,217,96,223,93,6,249,243,176,48,176,235,77,252,111,236,129,25,39,88,228,169,114,205,104,163,24,241,154,159,11,83,1,113,166,206,176,188,108,169,68,194,252,29,138,240,20,88,208,189,3,203,173,215,40,22,141,48,18,56,89,212,74,218,185,8,14,240,36,161,217,196,27,56,115,31,118,5,85,168,131,162,247,50,14,28,53,109,159,94,180,204,145,143,122,109,11,71,46,167,226,254,153,178,55,121,33,208,26,194,157,255,215,75,134,222,239,25,39,146,221,104,13,11,164,101,232,242,111,140,253,146,95,52,30,5,126,96,23,113,13,68,136,83,206,8,241,212,80,37,124,214,117,199,45,17,156,225,102,251,242,110,187,156,126,34,73,193,109,26,9,245,69,102,110,213,116,59,81,235,31,38,30,143,189,75,138,200,159,43,26,114,175,3,168,22,162,23,182,147,244,55,155,229,13,102,237,152,133,222,133,46,126,86,23,162,151,146,236,51,158,36,219,19,219,235,145,79,223,184,179,209,186,87,39,225,233,135,146,57,174,41,212,237,185,246,136,1,3,48,84,228,165,172,32,0,168,96,234,175,57,193,47,51,28,114,124,245,166,17,71,154,128,252,136,174,196,14,103,66,91,79,3,61,42,89,160,217,219,17,5,182,87,230,129,7,182,201,96,74,63,197,220,222,0,10,20,95,251,212,75,98,86,130,115,127,196,141,59,15,182,233,102,7,211,116,47,174,90,226,212,235,183,149,71,82,229,105,34,109,19,149,160,7,99,114,67,112,49,209,53,214,27,106,208,229,87,116,215,169,13,219,72,219,215,102,159,118,64,245,174,237,237,105,221,118,63,78,186,12,68,119,179,209,1,80,74,234,89,189,56,188,4,185,90,2,104,210,38,98,47,162,55,9,68,164,146,45,106,188,60,145,165,186,72,220,39,17,125,220,83,86,83,98,123,165,98,98,194,129,135,89,57,59,92,19,67,159,210,76,252,102,60,201,85,189,205,221,145,134,94,244,198,130,22,177,63,165,233,74,39,9,187,211,34,252,239,176,108,59,152,39,138,150,243,40,113,27,181,139,191,17,162,99,110,186,193,157,205,1,0,213,44,196,170,104,165,134,70,190,24,142,197,196,13,192,241,129,213,127,162,7,179,3,151,144,189,69,219,209,27,223,46,195,231,136,29,210,38,185,139,198,125,117,19,148,91,59,245,12,110,189,151,52,63,60,201,160,38,170,3,82,174,95,214,99,148,203,133,95,110,92,117,82,175,209,119,163,69,210,106,223,93,48,78,78,236,211,99,121,201,42,50,64,126,198,7,91,209,215,42,156,35,3,18,184,200,227,21,183,226,25,89,254,110,55,234,226,119,40,159,69,24,113,44,18,25,178,95,175,124,64,125,230,147,141,119,186,42,52,207,138,150,96,108,13,220,197,149,238,148,59,180,155,97,212,138,138,73,13,151,12,238,143,65,252,243,52,214,91,95,82,87,61,34,67,69,210,226,200,220,11,13,121,92,21,127,129,255,45,39,254,39,218,67,69,211,191,9,221,37,252,3,42,97,223,176,161,155,237,100,143,114,96,183,36,32,166,206,136,155,121,26,87,9,149,182,165,54,173,141,19,192,11,53,181,56,230,136,171,65,154,111,182,113,15,103,252,224,232,24,106,56,190,160,140,251,247,126,133,188,168,136,47,239,73,164,59,252,165,103,161,42,127,63,149,205,93,126,121,159,204,161,156,2,186,145,29,38,156,26,231,69,70,17,103,129,187,87,63,129,78,64,120,36,170,129,15,232,253,177,33,115,220,174,27,175,240,148,10,43,202,166,74,220,35,238,151,149,207,94,181,183,228,41,210,42,249,193,57,250,41,0,107,154,96,37,238,140,109,176,136,236,84,55,167,64,51,128,45,37,184,1,224,56,87,137,89,59,164,246,252,16,161,101,65,95,141,232,13,13,138,2,95,91,73,198,167,48,64,151,59,229,178,93,253,246,177,198,153,208,15,133,55,195,104,102,128,104,191,182,1,229,188,22,253,24,182,169,32,11,132,90,63,188,235,187,23,85,179,184,133,89,99,223,40,88,252,242,158,128,34,200,214,56,41,205,171,75,231,220,228,56,121,194,58,160,250,88,170,179,10,108,230,141,41,30,93,231,243,190,243,56,6,105,162,253,227,233,132,21,64,145,91,165,111,10,234,135,60,128,250,126,180,159,234,84,20,160,201,138,248,138,219,21,248,66,73,80,240,38,140,135,66,194,16,35,24,79,151,237,114,33,251,20,37,24,25,80,99,169,100,42,253,47,149,225,20,240,26,141,237,190,188,13,138,111,190,65,74,39,64,255,145,123,175,46,153,59,11,50,14,237,225,23,2,13,221,144,130,247,166,98,23,151,37,143,244,221,129,238,35,9,80,30,128,14,164,212,6,55,23,14,33,161,4,110,211,201,69,176,15,160,191,200,135,171,72,47,14,218,132,8,188,233,185,85,93,195,189,109,26,242,87,77,10,162,8,194,39,35,98,49,39,60,112,211,20,78,194,52,237,101,89,194,62,205,212,12,163,188,123,97,134,193,233,27,103,124,128,10,179,100,180,79,60,65,180,112,82,199,141,2,237,67,13,48,94,211,75,140,126,192,187,221,135,155,199,173,174,96,123,203,154,17,217,214,138,125,252,116,61,231,162,22,162,91,182,135,229,249,45,233,90,82,38,113,9,113,7,62,154,149,153,110,255,115,68,142,10,25,146,52,180,64,237,121,247,225,87,5,142,122,83,239,249,12,34,42,149,175,84,223,120,178,133,188,225,198,37,202,246,193,35,171,204,41,82,178,209,139,103,128,121,23,98,166,201,22,251,107,100,250,209,14,220,188,81,148,85,224,72,146,208,116,17,185,53,145,218,245,192,109,205,60,235,82,198,1,166,227,171,131,226,79,0,188,181,23,196,240,102,88,159,44,250,230,250,201,91,65,183,120,160,76,22,208,126,25,37,148,87,225,67,57,143,119,157,44,53,156,174,151,116,252,251,250,58,102,206,185,72,6,107,11,121,189,5,151,225,158,30,89,132,167,47,3,211,170,159,105,56,67,77,202,243,23,255,15,4,160,166,5,243,242,238,153,36,147,154,122,0,237,36,48,110,80,240,13,111,73,200,178,192,243,161,207,55,246,77,169,244,105,226,71,4,174,221,180,91,115,50,90,42,179,163,182,207,124,5,6,131,180,249,239,166,239,70,124,118,125,227,223,115,164,85,117,228,163,137,221,236,83,173,95,12,244,15,204,37,97,12,66,206,67,201,120,113,114,35,77,161,137,169,199,68,209,188,231,204,89,188,85,13,151,228,37,111,41,125,122,39,66,36,143,105,108,231,73,216,193,250,31,103,135,87,62,234,184,145,48,77,236,232,130,122,251,100,181,68,100,139,177,138,108,101,143,208,90,125,46,155,52,10,83,223,105,204,2,150,132,103,32,45,241,187,59,42,17,81,57,104,165,162,189,81,125,196,191,143,255,100,115,228,230,221,181,25,236,66,188,44,67,52,15,39,147,238,70,255,64,26,208,231,133,218,220,197,38,203,95,144,14,188,147,174,153,182,4,117,246,243,168,202,95,129,73,28,206,176,203,243,26,63,238,42,223,144,218,189,174,192,21,4,243,102,143,23,157,47,156,134,73,107,129,194,191,12,103,189,100,26,102,208,232,91,50,63,89,168,52,193,151,104,190,96,228,38,138,46,163,95,226,156,46,91,124,210,73,128,43,181,245,143,5,0,134,253,139,100,30,166,189,21,50,121,29,53,123,84,133,238,75,194,96,46,5,231,187,1,177,31,167,114,18,52,216,202,62,189,131,170,21,66,187,223,123,56,174,184,172,184,151,37,97,250,195,1,241,87,71,179,146,106,117,46,237,27,41,100,245,191,159,89,219,133,47,139,251,62,37,19,61,20,90,162,232,173,10,243,91,212,68,74,238,218,81,46,139,144,145,160,252,233,135,120,54,209,62,254,127,59,61,150,90,102,34,226,60,32,65,133,116,196,158,121,29,55,168,233,58,117,184,59,141,130,182,187,152,61,224,114,59,139,190,127,92,231,62,62,32,182,175,96,4,25,86,126,191,56,157,73,211,61,121,0,175,175,162,179,33,85,54,79,56,35,139,112,221,80,103,6,50,196,20,5,199,100,142,162,140,124,143,61,44,245,33,229,150,175,135,181,168,175,10,232,217,187,53,116,28,241,49,240,108,90,70,145,81,235,217,92,65,243,248,215,186,137,39,51,190,230,194,1,126,201,122,242,80,216,149,18,1,39,221,76,197,194,224,0,8,97,217,137,253,44,225,139,124,242,186,19,94,48,154,226,194,228,241,50,186,56,170,200,113,234,175,219,16,92,200,119,82,255,39,156,113,187,207,135,47,235,98,75,218,163,174,102,91,44,51,142,99,85,221,214,113,23,198,53,152,84,131,33,178,43,249,146,233,224,202,192,246,61,210,200,9,51,62,105,138,144,10,228,252,33,37,24,24,168,249,87,85,254,128,101,41,20,224,108,81,60,149,194,158,113,83,217,97,105,88,167,102,95,26,141,126,234,233,77,14,84,92,5,134,42,182,201,54,198,153,236,181,62,25,177,33,231,79,36,0,66,136,107,30,55,83,50,162,249,148,176,199,71,6,155,152,223,112,130,36,16,221,168,10,134,71,143,24,49,238,187,124,153,82,48,123,131,161,102,202,42,60,50,76,161,12,112,26,19,201,92,160,33,192,247,229,18,237,243,112,55,202,57,219,167,45,64,139,41,53,203,207,150,33,215,222,236,113,215,230,43,240,153,183,60,249,227,152,113,217,162,156,222,71,197,35,163,189,178,46,193,50,3,108,175,0,47,209,217,136,39,92,143,201,97,249,36,62,103,17,82,151,128,135,200,133,224,25,207,185,104,182,250,87,183,43,104,210,40,46,19,192,146,207,119,226,145,159,39,26,96,110,8,74,225,80,232,107,189,196,19,146,151,30,113,35,99,102,146,76,220,225,4,242,218,235,207,136,165,189,50,104,241,63,228,124,196,8,25,185,75,181,155,160,228,79,180,12,24,165,180,134,211,52,168,114,233,186,94,255,205,180,166,63,255,150,211,101,241,186,112,247,2,149,85,67,196,194,127,62,212,196,102,82,89,205,52,219,57,118,83,20,221,25,95,205,122,49,70,77,103,95,134,58,193,255,73,33,72,135,178,0,119,208,25,180,251,71,77,179,227,136,213,158,61,182,27,54,238,52,108,205,241,191,92,11,34,189,33,0,119,90,45,154,147,247,24,32,102,50,43,181,237,74,85,78,124,150,238,0,32,150,154,178,200,193,94,154,22,130,70,74,56,116,71,143,42,183,102,121,157,165,5,26,52,207,83,40,230,205,13,50,220,201,237,118,73,208,122,164,253,76,156,86,250,58,2,83,103,198,245,102,61,34,31,44,191,88,108,230,195,229,52,1,203,190,55,219,89,231,196,161,114,253,118,167,54,241,25,6,106,235,7,82,94,93,2,240,31,22,59,220,61,109,60,166,240,11,205,72,75,163,169,204,206,223,27,173,253,147,147,116,140,207,219,51,187,16,3,109,104,188,143,110,38,228,74,189,115,217,154,160,217,14,116,42,119,238,204,179,185,52,67,225,36,69,23,215,11,17,84,23,246,125,112,134,8,241,250,131,195,129,210,199,40,186,231,103,195,40,141,99,185,120,186,189,11,162,158,6,254,134,166,185,212,0,127,146,162,213,26,248,167,74,185,221,80,79,42,95,39,174,91,221,149,97,110,63,236,145,2,13,131,166,25,104,191,209,92,162,189,213,233,0,12,192,39,201,65,236,22,133,63,60,29,31,111,133,254,90,18,228,224,254,57,30,94,64,96,50,61,66,107,40,201,133,156,47,165,176,69,54,133,178,162,30,204,197,9,65,128,77,37,4,183,222,147,30,132,94,129,7,23,11,252,109,153,62,105,20,128,92,170,127,44,47,236,41,184,55,190,191,1,120,25,87,160,194,232,163,201,18,53,190,200,167,15,170,43,0,84,183,105,43,26,70,67,217,248,120,231,69,14,0,154,198,217,248,94,115,209,63,129,127,251,231,2,60,120,57,64,110,194,33,228,45,41,152,248,15,228,144,73,228,104,161,54,26,32,20,30,183,1,192,109,143,156,104,10,216,72,40,28,112,77,232,120,100,38,160,156,39,133,254,130,113,113,129,12,219,30,249,99,103,188,203,58,146,114,48,110,237,165,50,73,0,14,75,42,65,235,104,236,93,198,84,176,227,203,204,104,135,108,235,47,164,220,80,43,32,88,43,25,197,116,178,240,92,135,147,210,51,79,68,111,87,194,57,16,44,239,248,179,110,9,55,112,206,176,85,176,27,213,127,138,186,166,245,142,33,125,118,167,158,152,230,153,73,144,138,191,55,110,239,27,33,94,164,20,146,33,94,39,212,93,149,46,102,115,153,228,203,24,144,76,157,245,63,44,95,59,166,248,16,165,103,177,82,191,57,165,44,46,217,239,207,23,135,67,95,186,67,160,103,234,195,239,236,147,27,108,195,205,40,249,6,107,28,77,152,29,3,225,156,206,139,67,205,211,19,16,186,12,135,123,71,247,112,63,247,210,18,154,12,169,26,163,196,25,210,146,31,142,73,65,65,139,73,193,204,81,82,1,74,115,90,66,208,52,173,84,118,204,161,87,87,243,72,227,77,60,20,90,31,60,197,76,204,89,126,234,209,131,61,63,183,159,64,158,200,104,59,83,165,15,230,244,20,146,25,15,26,36,217,143,170,246,220,208,27,171,178,88,40,107,89,126,79,53,55,190,9,210,60,201,10,43,229,222,6,110,220,236,197,115,115,152,104,174,75,89,119,69,66,179,160,11,235,62,187,250,248,32,44,27,32,131,6,150,113,66,177,188,75,219,174,140,145,242,10,247,96,199,76,8,56,207,111,249,222,80,184,255,249,49,121,149,203,115,105,185,50,207,76,47,29,188,246,239,1,25,18,103,102,34,184,65,199,203,115,226,241,62,163,6,22,43,130,232,36,58,103,82,52,35,206,113,57,246,240,223,70,107,245,195,201,4,59,135,205,66,63,20,29,2,239,26,237,54,143,28,226,175,47,13,98,108,104,166,20,208,217,116,134,79,253,201,28,117,201,220,169,174,175,171,135,71,161,40,238,20,152,6,158,211,169,251,228,85,48,142,131,247,194,15,255,124,44,86,96,35,40,33,129,9,114,129,186,193,107,229,28,51,184,125,112,243,146,55,243,231,71,123,59,233,66,191,59,244,78,185,215,242,92,134,62,82,211,183,142,230,237,218,247,41,228,174,36,23,240,255,23,87,170,160,138,128,73,251,98,64,47,30,155,242,24,233,161,40,17,227,62,8,200,235,3,12,37,86,128,25,21,182,46,21,190,104,255,204,105,166,222,4,37,17,94,111,203,202,88,84,166,170,167,159,15,95,39,138,36,151,189,222,90,190,51,153,253,151,66,186,100,71,163,57,103,43,142,38,175,8,222,147,241,94,211,204,170,76,226,168,198,206,39,218,17,69,241,200,160,52,192,189,222,62,74,194,213,142,213,99,218,87,242,31,190,15,205,76,155,95,12,131,44,104,243,72,63,223,20,151,147,114,100,86,110,13,10,189,33,148,75,44,135,131,74,15,29,120,208,145,175,81,47,69,37,111,128,132,208,144,144,236,169,163,218,219,99,116,201,59,125,12,203,140,156,73,252,22,197,2,188,86,23,166,120,0,116,67,41,70,161,210,108,232,97,165,76,128,227,242,23,72,198,143,244,90,187,97,10,149,18,99,100,10,60,145,145,2,89,126,204,199,93,44,28,177,40,252,22,95,177,71,111,19,85,243,74,104,104,178,114,204,119,229,172,16,146,104,113,20,81,157,78,203,0,134,29,177,4,255,230,97,27,217,70,84,108,61,93,182,240,182,48,234,127,136,216,162,234,203,47,162,90,154,155,163,152,222,149,156,201,205,138,134,153,147,165,67,5,26,57,25,180,167,44,53,213,7,244,11,171,189,80,94,75,69,171,212,26,172,43,199,76,251,185,243,241,170,236,31,73,61,68,136,163,89,157,218,222,33,22,229,31,166,35,172,92,32,185,160,15,80,174,0,109,254,220,121,198,9,176,62,119,54,0,90,215,46,236,35,75,131,182,191,227,14,36,183,240,132,141,62,4,90,162,227,148,104,125,7,231,185,25,96,67,221,81,202,39,208,1,251,169,205,252,22,238,162,244,167,238,197,111,25,121,163,112,115,148,36,83,34,125,123,97,247,253,217,22,63,174,175,175,162,194,22,112,147,117,239,250,25,138,89,138,91,81,251,93,114,59,196,97,162,63,234,189,105,106,151,122,83,29,0,224,121,49,91,219,78,79,36,186,237,235,232,45,83,4,175,215,123,162,215,187,229,59,176,45,1,199,250,18,251,163,135,184,119,55,107,228,231,24,105,191,22,29,212,237,88,207,39,222,0,194,78,251,164,245,54,240,174,207,37,105,56,109,242,33,219,46,212,218,157,119,229,115,104,52,143,251,46,124,42,212,13,21,27,81,146,5,147,5,61,246,112,238,26,35,161,13,180,178,26,210,0,132,231,164,114,141,74,113,0,220,16,244,108,235,78,44,207,14,59,224,128,163,179,45,92,247,147,23,161,79,24,177,33,29,168,140,15,244,110,80,153,3,157,51,104,1,218,37,74,20,195,100,162,63,150,157,157,176,140,208,174,82,129,68,203,231,254,240,92,115,75,241,178,147,120,135,21,16,246,6,168,233,100,65,55,40,160,45,236,112,60,115,255,123,220,228,94,30,130,210,166,150,105,150,241,137,141,63,197,135,3,209,206,93,155,53,151,93,168,30,215,168,55,147,134,223,20,4,151,58,80,109,49,121,43,100,137,111,144,188,131,225,80,4,25,17,102,54,164,217,61,172,188,8,146,56,32,166,237,42,202,234,161,55,85,69,114,48,234,96,151,248,21,88,5,20,244,43,125,149,214,74,11,111,223,219,130,131,245,227,41,32,66,239,115,12,131,201,214,24,248,152,22,19,115,66,213,16,177,208,31,94,194,21,227,232,236,107,5,130,212,12,122,202,162,80,144,9,136,70,6,44,230,248,238,251,196,24,162,179,81,157,102,242,255,216,151,44,216,240,114,75,54,113,130,18,39,99,40,200,58,65,202,210,133,20,206,170,160,181,44,120,142,106,220,20,94,168,198,11,180,181,160,136,73,69,59,243,193,103,150,131,224,189,134,150,108,113,41,5,80,12,244,205,146,218,92,49,238,159,236,111,146,168,231,85,153,30,196,251,200,255,176,168,211,232,218,132,224,140,53,46,246,203,222,96,9,61,213,233,114,70,215,254,62,218,232,94,74,236,143,186,183,114,253,0,122,255,253,1,82,149,165,249,62,213,133,161,189,36,253,106,35,217,183,25,42,134,211,128,153,245,214,157,144,62,173,185,4,142,207,128,170,217,48,60,20,231,10,5,214,229,251,210,136,77,69,23,252,166,140,239,66,37,155,123,62,237,56,227,161,155,175,165,60,215,218,169,106,229,202,26,75,136,246,67,40,216,39,167,200,151,197,115,31,254,252,34,155,214,24,255,6,41,110,219,254,181,31,165,31,117,137,117,237,17,147,222,177,211,184,156,0,101,29,245,51,199,125,220,242,2,242,52,44,103,57,23,90,51,18,167,28,121,184,63,194,42,73,63,165,172,53,127,107,122,245,130,183,32,163,97,47,59,243,85,14,49,190,2,40,241,95,206,163,132,13,195,45,179,189,124,118,190,151,248,8,226,169,124,144,45,5,210,50,217,78,20,131,12,134,35,51,200,155,80,148,7,74,50,165,138,83,27,50,142,250,159,121,109,123,87,53,154,71,246,209,85,71,139,216,226,33,90,219,202,33,217,215,37,183,239,100,198,150,254,40,70,141,116,157,83,131,105,63,212,133,197,34,149,249,146,177,228,224,136,183,75,165,208,30,233,97,218,107,181,108,210,255,159,118,111,123,217,180,207,211,107,119,107,7,131,125,160,137,157,165,213,178,45,155,36,254,125,56,67,27,244,177,52,219,42,38,69,218,243,212,240,191,234,250,115,181,44,19,148,34,190,224,238,186,160,29,38,201,105,54,107,205,97,12,125,76,14,31,233,139,77,27,251,103,120,3,208,195,169,160,228,167,231,111,149,93,197,18,75,158,71,54,98,201,187,132,40,145,250,139,229,209,246,42,82,252,67,246,246,127,228,113,94,88,29,74,82,9,85,166,202,30,156,63,39,62,15,163,150,182,231,220,244,187,28,220,17,231,250,28,53,198,178,133,97,252,125,159,187,98,206,114,30,250,157,223,236,37,13,206,97,4,245,51,167,115,169,243,188,247,126,44,158,88,95,219,247,235,120,218,116,34,216,128,12,123,199,75,192,68,157,255,51,71,53,235,46,47,212,248,92,90,112,245,156,34,126,65,223,243,166,204,216,27,236,61,227,210,30,53,128,104,157,6,223,16,1,222,33,230,158,39,190,178,26,242,97,154,198,131,196,65,83,252,200,133,144,147,75,252,235,123,237,38,13,22,26,227,41,215,62,23,14,153,226,180,11,10,121,15,234,164,253,100,101,140,12,62,248,213,164,244,31,74,127,204,126,25,57,44,152,104,12,90,115,229,226,241,165,23,159,73,82,236,8,103,176,236,11,24,137,218,245,83,114,87,29,165,67,200,131,78,249,137,216,197,17,83,173,174,172,202,169,14,101,219,48,56,150,83,234,61,254,129,147,40,237,31,90,248,220,163,179,215,184,97,185,214,16,123,172,168,144,19,142,242,1,55,219,93,77,172,106,141,186,74,133,225,235,174,202,54,95,54,62,18,78,197,75,69,90,20,207,254,51,163,217,157,159,120,237,197,67,212,243,13,16,2,30,155,161,2,233,218,50,11,233,216,227,174,108,183,10,206,136,210,177,243,144,136,74,100,145,148,147,140,40,49,69,174,8,183,131,17,53,100,196,236,166,119,239,152,14,242,70,193,78,42,160,78,137,251,235,35,193,127,198,47,63,2,237,234,41,78,110,187,124,209,113,182,200,152,114,174,51,144,110,145,205,92,108,106,242,103,238,225,223,219,7,69,49,186,65,134,66,219,62,38,207,228,113,186,245,251,137,40,72,229,120,45,124,229,196,87,69,195,115,77,226,237,101,235,114,173,5,137,7,69,119,28,233,221,10,198,86,180,120,99,144,161,223,136,11,0,79,239,40,50,215,184,135,113,164,116,159,126,229,27,177,237,98,161,222,47,34,36,113,147,34,111,178,233,245,75,174,146,175,16,191,81,255,138,155,178,240,123,207,98,254,233,240,125,164,56,242,197,137,153,168,241,117,97,86,167,116,183,213,69,80,24,105,190,104,49,88,43,101,189,116,192,231,52,180,75,126,158,142,42,39,55,40,150,197,16,69,58,36,188,33,30,28,181,240,196,121,107,59,193,173,5,201,87,249,145,219,74,122,101,100,90,107,142,205,104,182,214,157,89,87,180,102,74,56,92,234,143,29,110,10,250,82,89,223,170,157,60,239,84,101,133,201,62,167,35,29,1,121,20,94,170,233,152,193,115,12,127,51,238,103,248,103,30,121,252,244,16,8,225,221,111,214,189,174,249,131,234,2,94,250,172,178,235,170,9,215,41,19,112,12,231,248,160,128,34,159,234,22,107,225,228,8,66,184,156,137,25,110,153,202,8,229,69,53,31,108,6,136,31,181,138,150,107,253,45,200,105,150,16,35,13,51,109,1,113,58,72,135,102,73,38,53,80,148,117,103,1,251,37,58,145,254,182,180,0,183,45,239,223,226,71,177,82,179,230,163,113,132,136,13,222,137,29,233,96,70,82,163,239,154,69,90,31,28,53,157,82,19,81,103,212,254,88,99,186,226,192,211,254,115,35,65,129,176,197,239,222,93,40,93,159,164,244,181,59,192,178,156,73,96,232,239,146,219,33,196,169,54,85,64,121,19,219,150,179,68,215,108,15,26,82,46,58,118,87,158,67,62,76,33,114,238,170,25,98,176,204,154,52,223,102,0,151,5,89,103,154,9,42,115,219,209,64,215,135,76,63,182,176,213,177,168,80,45,184,129,138,20,81,109,65,226,64,153,160,19,157,190,164,15,104,247,121,181,225,129,43,44,126,30,193,63,215,174,105,92,141,162,73,48,117,203,146,103,59,75,68,46,207,213,87,160,116,101,96,144,103,67,138,29,25,16,236,178,211,180,158,70,3,9,206,192,144,127,185,89,233,232,245,93,230,188,174,241,170,121,239,223,65,71,113,229,150,12,141,87,159,113,73,202,140,182,84,66,236,109,223,103,100,9,110,67,91,237,215,109,228,245,34,244,228,89,45,239,2,188,173,160,144,149,195,80,192,210,180,12,41,25,210,84,3,231,142,50,206,1,102,53,154,81,82,108,253,31,7,4,165,82,136,215,21,91,157,250,240,143,195,17,243,208,117,188,197,16,215,110,226,199,38,149,186,90,48,28,16,87,119,9,243,32,40,25,224,204,106,30,82,76,118,162,33,10,178,29,37,8,154,194,80,62,167,238,249,209,160,130,86,75,121,81,114,154,211,192,121,55,89,95,236,196,47,30,169,32,96,73,205,41,23,59,204,119,54,94,94,58,46,36,62,254,152,17,36,38,236,100,80,228,187,22,124,92,252,31,178,23,212,157,52,203,46,87,233,145,151,129,15,68,171,37,212,199,92,135,127,0,189,40,182,115,200,135,91,159,109,55,198,172,62,170,220,50,153,120,3,130,238,215,72,98,123,76,205,73,31,132,233,101,25,153,202,249,213,60,106,222,171,47,165,2,0,172,112,100,190,8,110,175,31,249,112,157,187,183,150,87,207,208,100,236,234,22,201,34,74,224,238,49,157,148,115,37,116,246,80,224,211,160,21,62,34,95,69,34,231,227,89,115,112,224,49,189,79,251,240,78,70,72,15,168,108,3,237,214,28,186,211,50,90,191,130,89,147,170,244,162,234,228,98,172,249,6,207,235,219,205,22,24,80,53,103,47,10,251,216,153,131,12,191,210,109,120,136,38,232,77,55,53,215,4,193,218,238,93,235,182,118,206,15,158,170,195,56,183,69,255,114,234,5,36,95,63,137,186,106,215,20,241,69,67,247,198,182,92,171,105,150,18,244,169,230,65,134,113,8,37,130,6,138,126,145,79,172,175,230,17,120,83,198,86,197,34,252,1,62,141,71,236,27,7,226,14,191,136,208,210,40,123,191,157,94,200,22,98,123,73,108,25,7,170,15,104,150,122,20,36,164,219,48,101,213,62,155,156,181,209,235,211,223,255,135,12,253,182,213,157,181,71,230,56,226,227,217,233,168,171,33,220,83,27,9,118,9,58,63,230,243,94,26,99,216,86,193,102,167,92,138,240,213,199,136,187,86,169,214,220,212,160,102,3,159,214,83,154,33,250,187,246,145,92,222,156,205,61,252,209,136,242,188,151,124,244,110,110,64,40,107,140,130,39,49,23,4,140,240,21,171,148,83,233,219,154,132,192,236,175,222,153,211,2,8,20,195,207,16,246,156,111,249,72,206,175,206,57,37,13,208,86,81,206,56,182,110,110,111,224,93,209,110,54,170,157,121,4,165,206,72,238,90,111,156,135,247,192,168,241,246,166,186,126,23,107,150,182,166,244,188,93,46,151,168,209,139,86,224,161,57,48,81,184,134,211,129,118,62,200,42,14,234,138,211,104,194,109,252,86,47,197,174,131,30,46,60,199,89,30,68,79,49,11,120,208,234,10,190,37,119,85,217,142,25,98,157,56,90,26,67,221,249,22,160,164,9,209,169,36,234,65,210,237,140,101,229,204,230,223,126,216,187,13,20,36,201,23,142,153,2,143,172,187,80,213,14,141,211,205,47,87,190,227,52,140,164,88,127,77,149,45,255,148,136,182,50,219,231,244,228,161,191,0,1,5,88,1,165,117,156,24,115,199,233,226,213,77,138,52,168,12,122,162,43,82,188,94,84,166,121,13,74,249,128,169,140,33,156,108,122,42,10,48,55,3,5,159,82,128,58,222,80,237,214,18,20,91,119,122,150,15,29,72,52,240,120,54,181,54,95,169,212,26,76,122,13,126,1,31,16,23,13,136,140,50,57,57,74,203,152,30,254,23,96,152,141,104,227,72,248,198,236,6,93,31,241,139,13,133,58,159,107,15,190,191,234,238,65,252,228,231,229,193,134,141,189,43,31,22,220,240,62,89,249,232,155,31,171,250,193,41,153,55,124,65,46,56,151,1,13,49,161,5,209,180,131,7,170,130,118,41,142,35,177,191,18,116,73,104,140,226,83,107,53,233,198,80,74,109,227,172,4,143,103,202,115,215,173,122,25,185,46,244,96,52,173,205,167,39,95,158,197,82,178,249,225,159,61,67,115,46,94,230,173,235,188,148,164,73,222,229,61,224,52,255,67,22,106,189,202,255,117,141,29,74,127,132,122,19,99,108,86,34,236,173,28,199,215,128,99,89,240,9,23,231,248,215,253,138,152,32,77,84,78,115,167,49,46,91,40,6,37,59,31,51,249,162,136,150,141,23,253,20,102,228,187,175,117,150,122,74,118,192,222,92,101,216,119,118,57,208,100,41,204,217,51,75,253,35,109,233,102,154,66,236,139,2,203,76,8,229,188,90,152,182,84,93,196,117,217,114,132,215,25,181,185,112,22,61,249,190,14,7,253,169,73,104,209,217,242,35,82,171,244,68,201,34,229,107,168,161,13,94,0,201,233,248,87,141,254,147,117,48,6,134,119,190,101,120,43,72,85,163,193,234,175,74,205,37,129,192,247,255,13,170,119,119,59,82,132,251,50,99,2,249,155,144,162,225,64,211,105,96,200,121,185,79,40,153,159,1,253,224,44,64,172,117,160,60,177,174,57,224,179,52,190,6,104,220,163,253,245,47,133,70,84,41,34,14,189,202,145,23,72,218,57,221,204,31,247,148,249,32,76,43,222,9,72,141,225,223,173,195,213,193,176,146,117,179,162,143,237,38,165,21,6,107,186,144,39,163,204,35,90,7,67,132,206,44,130,42,236,120,147,22,122,123,53,102,19,67,202,58,72,114,151,223,159,173,162,156,56,169,86,235,95,168,248,36,1,138,76,55,197,181,188,101,16,5,17,168,108,166,242,237,76,240,169,251,112,30,26,255,144,19,167,170,181,3,10,185,239,86,149,189,108,101,148,163,57,136,220,32,217,26,115,7,229,54,199,104,224,84,108,80,93,176,213,174,72,173,191,118,140,28,193,124,20,150,130,69,168,207,29,208,4,135,193,149,9,11,235,73,100,150,120,87,26,129,102,216,119,186,244,140,117,157,10,127,195,255,100,29,60,136,159,193,249,252,53,1,67,85,205,182,192,202,13,71,173,19,125,58,245,249,157,29,117,32,7,242,30,125,174,226,227,174,156,10,19,70,51,158,64,217,43,226,60,49,214,117,77,3,21,25,247,77,29,4,170,108,231,22,207,7,41,36,48,197,245,202,20,169,230,58,118,220,150,208,43,191,38,218,163,232,146,140,63,211,249,22,127,136,130,202,34,221,165,73,18,134,3,218,208,75,131,50,83,69,255,108,168,164,155,126,250,133,144,16,145,37,43,164,110,105,222,11,119,44,215,182,29,80,84,113,43,72,194,98,53,112,76,53,194,38,54,215,12,56,218,30,70,163,150,122,173,153,199,215,176,199,116,199,242,229,204,35,44,186,225,191,1,16,80,255,2,123,237,168,225,183,112,53,63,242,109,43,153,92,91,180,84,65,18,132,254,49,198,110,237,84,43,229,9,250,52,51,137,35,226,64,194,181,167,88,99,198,21,40,17,212,66,7,157,58,41,99,253,83,101,33,211,167,222,100,213,220,42,249,104,84,232,55,109,38,30,1,127,240,128,187,189,94,67,222,56,191,129,201,83,74,19,15,48,99,141,125,197,68,164,237,235,238,252,155,59,103,176,110,83,199,216,216,146,119,155,26,204,59,212,39,213,165,182,82,144,52,122,196,174,214,1,101,218,59,158,181,233,58,107,32,122,195,143,213,23,229,21,220,66,210,70,116,195,65,107,201,195,57,130,109,14,82,251,148,242,122,114,65,41,72,134,106,231,5,152,34,164,205,237,208,86,247,80,216,40,26,146,209,100,83,74,83,103,42,219,183,171,44,210,240,26,179,101,12,165,34,5,240,115,35,28,45,76,150,30,210,64,28,63,107,66,225,148,14,242,74,129,158,86,171,175,135,171,20,156,123,109,251,171,129,238,7,104,184,227,125,168,121,60,16,190,204,156,236,23,201,102,248,69,219,132,185,74,190,141,234,127,127,198,60,61,167,39,43,102,188,117,250,229,183,219,251,213,180,235,132,33,238,76,23,76,222,47,183,28,37,176,26,182,19,234,34,11,57,255,114,86,90,17,55,142,126,127,101,231,108,93,174,213,5,194,218,150,119,30,82,151,175,174,64,63,48,126,60,4,227,170,183,46,234,182,184,139,30,129,124,162,29,141,133,13,212,26,66,139,144,148,244,179,101,86,92,45,200,125,2,77,110,7,135,117,184,59,31,242,84,125,251,110,144,213,214,85,30,94,222,144,165,35,45,106,18,149,121,124,102,163,106,209,90,42,78,112,27,35,119,87,78,118,52,104,219,184,51,127,149,110,126,103,104,226,23,66,95,31,200,50,222,86,46,100,225,24,76,76,167,222,181,34,124,145,0,43,216,186,112,200,63,39,87,153,243,115,42,206,55,95,221,221,202,206,191,193,126,19,91,101,63,125,215,236,59,244,182,212,31,220,234,216,28,229,166,77,16,36,197,40,138,151,76,78,220,245,147,48,129,126,152,25,233,52,137,74,235,55,138,249,116,1,130,26,150,224,37,230,4,250,23,121,233,230,219,88,229,124,49,69,198,244,230,35,23,246,125,119,168,169,221,189,191,243,53,59,193,78,68,64,2,5,30,115,90,47,6,92,75,109,120,64,193,132,101,251,148,136,98,82,217,190,202,164,73,146,112,37,179,113,77,16,255,123,34,184,244,126,139,52,224,164,119,6,55,140,159,209,241,59,107,36,147,238,240,101,79,169,85,167,120,235,243,154,100,239,27,90,94,83,237,123,94,23,204,213,80,32,148,142,97,191,101,84,51,178,143,125,123,254,65,236,202,231,20,0,19,226,221,132,158,52,115,26,99,149,63,241,51,96,232,83,218,95,103,41,144,101,4,41,41,36,8,63,26,229,52,26,60,208,120,5,149,215,103,235,100,98,1,173,235,238,133,244,90,169,104,64,191,3,41,225,71,40,207,62,197,253,157,179,119,233,128,195,72,215,15,61,71,184,131,72,56,140,70,237,104,246,73,184,124,254,79,136,235,50,6,190,57,231,235,135,92,170,230,218,135,104,125,71,178,70,48,232,147,95,96,125,142,86,189,236,48,100,229,57,197,39,52,130,26,230,89,198,104,78,114,227,252,215,77,183,128,236,96,202,149,95,195,254,133,137,80,184,129,202,239,205,157,40,211,46,249,169,191,234,191,253,170,2,157,51,116,216,94,86,58,48,235,174,215,148,109,175,195,112,7,144,191,133,81,127,141,88,76,131,26,101,86,62,46,192,124,7,3,60,21,47,134,188,42,8,141,240,74,107,222,32,157,71,52,117,180,121,110,133,180,121,211,178,1,156,185,23,217,111,207,141,222,29,204,166,87,176,142,37,241,5,81,118,102,109,176,5,71,45,240,193,9,220,47,26,35,43,131,109,86,126,254,114,129,72,196,186,239,155,51,93,144,213,82,40,117,148,228,99,30,173,154,221,75,111,190,110,140,228,152,109,160,23,228,124,169,54,129,60,214,76,190,183,88,23,154,184,192,1,221,31,108,106,202,148,33,103,162,146,119,130,193,4,220,44,254,226,176,38,62,242,60,32,204,59,41,73,33,141,113,81,243,215,13,87,139,68,177,67,37,207,96,144,85,114,224,186,31,236,29,231,63,158,165,99,25,44,78,174,226,219,71,32,107,184,223,218,168,161,252,19,109,249,205,193,42,56,230,98,116,142,234,29,15,15,179,249,235,250,218,187,16,89,155,223,98,73,141,211,234,34,78,237,218,185,164,182,174,246,105,111,232,15,60,51,243,49,247,114,113,95,184,162,66,134,30,36,232,39,254,132,225,236,91,64,176,205,180,177,218,207,14,95,214,4,192,194,219,123,165,33,231,55,185,48,231,235,171,210,137,46,89,218,125,188,191,28,170,202,124,193,248,138,137,239,142,244,116,139,102,216,144,162,191,131,104,195,198,164,106,215,76,12,27,136,167,65,234,7,129,20,238,231,132,151,113,179,9,66,196,159,200,250,5,73,252,39,146,129,119,84,54,124,137,215,133,147,197,216,239,39,79,163,230,174,118,190,209,18,93,60,16,163,30,201,60,59,151,86,170,177,33,162,110,82,36,61,228,147,220,51,87,197,212,133,254,134,194,247,147,55,94,182,56,184,112,2,112,91,163,77,202,87,139,64,215,133,171,4,115,167,132,5,8,183,55,18,175,255,178,45,26,125,61,142,249,135,35,182,31,194,6,243,245,222,154,27,93,195,237,141,226,52,35,219,44,53,246,236,253,213,80,11,54,154,18,217,172,237,75,137,83,144,229,165,103,237,38,91,203,206,3,159,127,92,214,128,36,98,65,84,207,179,243,213,216,159,152,120,33,87,35,151,126,195,32,150,14,43,143,11,210,226,109,99,26,206,45,199,183,248,31,43,103,254,207,75,130,121,168,21,246,115,251,208,212,106,221,226,122,160,186,89,3,54,91,91,86,55,162,160,16,29,70,154,174,41,154,202,191,12,39,75,246,196,117,228,65,77,50,48,66,30,199,225,61,253,166,137,137,217,41,212,24,246,210,193,133,150,145,58,6,37,106,241,246,252,116,31,59,181,35,233,48,72,165,194,132,59,119,204,5,137,46,135,243,202,52,202,192,109,130,1,151,34,202,29,251,182,152,28,2,194,131,186,110,5,45,223,45,244,173,67,86,250,102,228,17,113,170,55,78,24,141,147,219,126,67,80,91,82,66,154,8,70,216,77,98,151,228,141,39,194,176,94,194,9,163,200,196,189,222,44,52,193,31,52,70,84,7,23,168,211,20,185,190,76,86,205,67,78,153,101,39,76,82,6,193,34,253,146,72,105,57,205,84,185,178,97,213,17,1,32,27,102,199,147,180,88,204,244,224,239,26,100,232,220,46,211,255,141,183,49,218,32,27,136,43,183,123,231,78,81,116,25,100,253,200,164,189,28,183,5,157,85,212,93,192,101,90,48,144,97,3,173,205,227,104,168,77,244,205,196,104,121,138,246,80,61,210,83,237,240,235,42,171,185,66,92,123,128,20,78,86,184,3,210,201,244,56,142,149,0,28,109,189,121,246,202,73,253,75,112,252,103,228,61,205,186,231,239,42,241,14,79,46,129,192,217,115,7,135,70,6,5,50,159,62,219,130,153,89,201,206,167,105,245,204,15,94,228,5,180,90,53,119,92,59,168,148,54,94,115,226,1,90,61,74,48,248,110,17,151,123,192,102,180,252,57,31,124,79,218,182,120,35,33,18,39,205,24,197,206,215,85,4,165,148,47,163,50,130,251,129,155,254,248,39,77,146,203,60,150,106,54,21,238,172,224,162,59,95,127,25,98,129,175,195,245,244,64,102,71,225,41,118,183,78,66,115,125,175,178,152,236,212,3,102,194,1,190,249,252,69,188,15,246,52,10,234,188,158,98,41,183,43,210,13,210,48,7,201,144,130,7,34,14,250,23,227,167,179,78,56,247,40,30,88,56,237,46,52,99,237,209,159,39,230,128,81,212,54,65,12,104,52,90,143,179,148,214,131,103,250,232,38,203,229,194,154,78,52,20,154,78,43,254,127,163,187,84,9,213,203,16,80,155,93,221,161,223,83,178,155,94,159,208,67,205,78,200,138,124,180,220,165,21,6,40,240,221,42,96,223,13,108,67,128,75,69,124,207,220,134,88,164,11,162,141,106,208,52,34,164,48,65,214,97,246,132,29,84,218,203,43,30,110,161,19,156,140,86,78,114,18,138,174,155,254,43,153,108,184,14,146,14,98,61,9,191,129,232,27,183,192,165,101,117,255,251,235,184,5,225,152,130,194,208,6,221,12,58,217,193,57,21,235,140,232,81,125,24,235,105,156,243,61,236,16,7,205,219,96,58,87,13,31,100,196,173,117,176,249,45,201,183,160,57,141,142,207,73,207,218,54,2,114,246,6,116,8,5,126,190,104,17,196,194,161,38,174,11,220,204,41,58,126,89,61,76,193,50,215,181,20,39,131,8,244,190,142,129,195,211,239,197,15,173,78,164,111,59,68,149,215,221,95,35,11,132,24,16,153,252,162,133,94,217,22,3,235,209,15,82,125,9,64,58,114,209,127,199,254,75,244,74,37,216,56,253,47,224,116,132,106,54,16,29,50,78,181,141,213,255,148,150,32,104,50,145,46,12,254,230,36,9,98,218,105,115,225,179,245,240,119,188,79,250,223,232,163,189,212,207,116,81,32,227,104,90,253,144,89,81,110,240,43,99,230,172,221,40,227,238,182,71,42,172,18,151,212,243,152,86,110,90,23,58,204,171,100,0,159,60,8,216,190,25,7,111,133,219,175,125,160,158,27,203,9,73,158,214,197,101,101,134,138,86,73,111,4,71,123,188,122,165,93,23,89,168,95,121,228,195,66,232,10,66,49,38,226,36,149,178,39,244,183,152,145,68,249,102,184,203,59,104,49,150,163,145,114,106,238,55,228,65,97,66,246,120,20,81,19,115,195,6,71,207,189,141,195,65,4,62,120,91,220,55,175,14,79,204,83,235,164,9,92,35,13,57,159,254,28,144,234,53,35,95,73,8,174,228,112,246,32,85,16,75,120,185,103,177,31,196,155,64,31,216,1,202,117,84,154,136,10,127,116,7,223,52,141,7,114,106,215,2,184,66,55,85,214,57,72,58,173,98,7,40,61,0,3,156,230,33,175,62,222,130,105,43,85,178,145,38,104,241,238,93,57,169,172,68,230,104,240,119,121,60,196,41,32,238,31,107,109,39,17,154,5,232,161,115,143,182,154,22,84,156,126,109,241,48,222,185,128,47,156,168,22,15,127,27,237,109,132,237,7,2,194,92,240,122,216,59,138,229,195,23,22,161,12,7,66,166,130,116,234,106,182,129,94,135,5,47,50,240,185,46,238,218,80,165,19,120,42,188,71,203,121,128,239,207,241,251,115,165,121,66,90,168,144,41,69,5,172,55,54,89,241,124,31,226,231,117,32,110,104,224,104,163,218,25,228,147,136,213,155,121,213,93,255,62,176,191,182,160,78,24,243,194,61,222,139,134,120,197,18,76,112,76,59,93,123,89,41,116,98,176,204,60,154,235,49,107,246,90,5,186,39,240,87,112,114,10,183,127,137,21,125,233,225,166,164,79,251,107,84,52,21,66,10,63,15,145,117,17,225,198,168,202,125,117,67,35,250,62,114,13,130,73,128,9,3,3,28,103,63,179,73,227,12,187,188,170,17,87,26,88,252,164,41,114,46,100,137,87,88,90,137,8,243,11,114,212,74,141,176,108,17,16,222,187,110,28,236,26,44,77,103,162,195,1,209,77,131,222,91,5,152,233,230,249,251,163,22,174,185,127,175,215,202,229,237,178,56,37,200,214,49,157,253,144,198,159,91,84,66,232,138,185,255,173,159,207,242,30,122,117,228,247,221,145,227,201,154,205,53,114,56,59,183,80,114,58,119,72,69,39,139,40,245,155,28,201,213,149,88,15,218,89,101,68,245,120,66,127,184,223,45,34,202,185,223,107,132,85,75,248,242,29,104,81,84,47,177,226,181,27,34,232,15,34,60,185,69,221,239,132,140,224,14,130,54,197,188,204,42,157,20,56,1,182,91,184,126,105,39,34,204,153,119,176,186,78,92,198,11,73,145,171,53,213,191,249,159,23,167,254,180,24,149,52,184,160,255,237,206,129,58,82,216,191,3,14,234,48,102,220,131,118,245,178,214,131,177,175,23,227,158,235,217,88,231,167,123,248,233,142,112,194,177,21,165,114,158,59,88,143,33,146,225,105,248,127,78,92,254,84,46,207,239,78,240,165,203,213,148,61,212,141,96,54,163,86,100,131,222,210,15,73,176,204,6,195,74,141,178,161,239,122,172,38,178,194,215,57,163,230,252,56,61,50,152,53,128,111,102,149,51,195,70,254,25,103,248,126,67,171,22,148,205,240,239,88,202,221,192,231,156,27,62,212,144,81,149,124,8,118,32,92,244,118,186,128,113,205,95,151,71,182,36,223,137,36,74,10,226,87,104,114,147,50,173,136,215,111,240,252,43,85,249,227,29,176,224,225,12,67,111,72,24,161,68,235,140,157,255,2,212,105,118,209,208,13,218,97,22,185,71,175,37,102,164,245,27,166,128,242,162,235,230,188,157,27,249,105,87,151,149,162,202,190,254,45,46,10,241,191,90,248,236,69,221,19,64,77,162,19,193,78,29,140,55,67,227,0,249,116,241,176,212,211,114,224,156,29,70,168,207,99,222,157,113,133,223,88,202,91,96,178,110,50,153,84,179,48,29,1,18,231,99,80,24,47,87,36,221,254,199,27,234,99,37,91,85,244,103,163,127,207,153,56,182,98,14,205,169,197,132,64,194,26,109,181,217,196,84,180,108,182,9,55,156,184,208,9,118,13,14,237,152,95,99,158,114,103,16,145,239,89,40,181,43,14,73,61,116,120,3,213,60,187,14,37,212,125,215,160,130,201,8,12,49,7,119,172,176,82,104,36,243,54,249,34,177,0,230,94,108,37,94,90,204,32,65,253,144,75,206,18,56,125,201,182,240,35,176,115,232,56,219,11,79,187,185,46,39,145,50,179,218,29,235,204,178,75,89,233,181,83,55,181,8,243,159,173,65,15,71,229,118,128,11,202,85,234,161,106,201,180,145,81,52,156,220,35,104,202,139,58,46,6,215,21,165,163,170,130,20,36,235,96,176,185,140,53,133,244,182,91,116,97,127,249,170,65,41,239,238,162,49,204,123,109,158,64,212,204,187,42,153,92,160,15,210,154,56,219,225,123,154,242,167,192,45,28,18,34,140,132,119,57,112,105,223,73,67,89,126,200,97,35,156,28,168,16,13,39,201,189,116,131,205,107,74,125,2,0,238,30,78,115,6,65,56,77,11,152,86,125,141,57,125,240,206,69,162,135,201,2,218,159,141,90,181,36,197,8,55,87,154,11,161,202,99,64,253,180,155,87,107,56,66,58,239,56,64,60,243,229,126,84,18,143,127,190,255,76,166,107,217,2,235,161,209,17,21,152,88,152,195,187,110,56,3,135,12,234,50,231,1,68,177,7,53,65,42,136,175,93,247,0,161,83,159,32,63,203,82,30,4,181,30,104,66,144,65,108,1,213,8,61,184,180,191,39,21,145,193,52,85,235,192,234,3,237,178,58,29,230,201,188,190,160,214,41,146,101,181,61,84,62,105,181,132,217,222,116,156,103,137,227,46,42,162,44,130,246,172,149,29,179,255,99,130,52,81,65,160,130,26,5,114,223,173,149,176,47,196,235,230,228,6,111,245,75,31,93,93,229,147,4,192,118,50,31,131,109,177,220,56,49,34,83,59,50,169,28,238,3,34,90,66,34,93,42,106,78,95,148,34,86,67,148,225,177,162,205,42,239,135,0,204,165,49,34,146,221,51,87,52,136,173,13,144,174,201,111,193,9,166,209,113,83,219,93,117,45,49,245,192,127,153,216,74,3,245,53,223,230,250,12,160,97,171,217,234,37,242,107,136,118,101,106,207,253,225,227,146,111,190,64,112,42,30,165,228,81,116,153,141,217,182,140,110,31,254,146,101,15,32,48,116,125,109,199,115,131,118,218,119,165,45,238,227,58,106,143,59,118,64,18,176,22,50,197,227,255,160,210,100,104,35,27,36,128,89,153,231,213,251,236,184,182,101,194,49,151,230,0,61,170,83,164,118,88,164,211,202,226,165,213,252,32,83,205,140,40,174,182,177,206,157,226,156,233,7,171,59,78,133,230,110,56,43,90,165,250,10,116,108,127,87,64,236,107,156,87,197,28,76,60,26,154,236,110,16,45,195,240,62,203,44,200,161,130,221,207,7,203,123,1,56,92,210,109,48,118,146,98,251,156,179,252,51,44,82,222,44,156,33,116,75,239,9,187,252,59,109,38,250,211,235,35,207,54,13,68,18,194,240,56,228,41,203,8,199,180,209,15,146,24,224,43,14,161,199,100,53,56,49,253,45,183,170,39,131,30,172,17,165,26,13,17,71,18,4,115,205,28,162,163,233,40,146,252,167,170,186,170,167,244,167,8,249,138,60,193,113,63,15,61,63,228,12,186,119,252,82,250,213,42,79,150,41,66,91,103,190,166,85,41,44,135,22,59,75,229,102,227,21,217,238,87,60,45,154,117,11,64,170,235,100,114,224,11,149,36,190,133,206,6,29,187,79,134,228,185,252,149,119,43,42,130,197,45,75,127,71,181,45,120,30,175,239,88,90,69,17,196,8,241,15,107,219,167,203,157,192,142,21,70,204,74,208,78,38,203,162,155,7,106,153,234,121,103,113,227,204,135,115,2,15,96,172,166,195,27,202,203,69,120,126,181,123,86,137,68,9,69,94,47,27,133,142,82,185,21,3,179,80,164,217,153,223,36,181,150,190,33,233,170,254,125,27,161,41,80,97,179,199,61,171,248,112,95,77,156,44,183,183,142,98,128,162,221,60,126,32,84,74,133,244,174,44,104,14,213,125,117,149,52,105,41,11,166,86,31,151,129,38,108,45,176,74,212,51,151,134,235,73,182,161,252,148,169,47,244,114,71,126,207,187,205,136,12,97,44,13,244,202,19,81,108,31,190,21,249,132,239,12,145,116,219,117,236,176,123,96,196,56,205,73,14,141,129,173,118,108,0,67,94,226,47,200,250,4,24,128,27,152,244,177,148,18,120,88,173,145,224,223,174,32,228,118,207,105,189,69,214,179,247,136,147,31,168,157,92,133,32,157,30,160,254,137,17,120,142,145,132,10,151,58,28,219,112,134,99,99,198,87,98,122,184,181,72,75,249,77,28,97,134,73,91,9,76,55,67,85,98,210,162,41,144,196,179,26,103,59,246,117,133,55,122,88,160,90,189,70,43,235,101,213,250,131,230,132,58,105,172,36,238,4,253,216,55,25,249,143,180,82,102,124,244,11,60,204,99,204,71,99,11,22,47,112,84,126,121,48,11,112,11,190,197,56,105,218,20,33,110,101,72,90,147,36,14,229,48,170,200,90,92,30,76,250,83,178,176,145,65,76,232,174,222,144,215,108,70,130,235,15,36,39,194,133,218,19,59,21,16,34,32,122,186,243,74,225,220,1,189,24,134,220,135,94,119,59,117,90,62,90,184,217,150,112,9,192,119,9,172,96,244,137,182,132,11,217,148,233,35,184,60,61,97,189,141,116,127,173,207,21,119,142,187,248,32,33,197,211,128,164,91,213,201,38,214,65,86,56,79,139,69,133,234,187,109,144,110,116,60,17,230,193,30,59,40,9,166,73,3,254,211,10,151,151,91,93,254,241,205,35,250,57,138,79,88,65,156,95,86,21,74,110,132,217,200,27,98,190,168,215,88,223,147,46,93,148,28,178,141,111,148,211,237,218,52,127,226,179,36,114,237,158,0,81,201,246,102,227,241,183,133,25,134,236,144,48,13,182,108,91,86,119,152,217,192,32,155,4,131,220,65,193,251,250,196,67,158,75,170,8,115,131,181,241,112,87,216,114,218,86,65,72,219,183,5,110,139,206,136,168,30,17,58,237,126,199,236,36,191,91,209,180,179,56,20,150,44,203,104,129,56,14,244,42,115,17,114,117,10,246,50,172,159,213,109,71,166,85,41,87,96,2,170,110,38,215,202,15,210,68,211,123,59,181,133,12,6,91,252,201,185,94,19,83,12,4,197,222,108,197,239,94,249,106,165,205,193,189,91,86,250,45,197,59,242,46,190,251,197,132,114,67,233,58,97,132,142,70,24,247,242,237,143,182,52,87,127,238,56,95,178,111,34,47,49,191,51,37,230,252,25,74,47,151,127,236,253,150,192,130,150,86,178,99,168,24,18,42,197,101,44,97,208,109,184,122,129,152,23,183,210,243,232,173,198,11,99,52,47,113,139,251,68,99,45,193,53,42,78,73,19,168,100,200,118,181,92,248,92,250,158,27,219,220,218,35,210,150,48,54,233,146,234,148,166,160,237,208,220,20,55,86,165,254,166,38,42,83,228,106,27,109,253,242,107,23,25,163,73,146,0,243,53,4,83,153,149,113,71,224,35,81,219,140,142,138,131,144,90,76,76,50,60,117,54,246,198,253,144,54,188,249,118,26,213,196,249,221,50,123,53,142,153,68,166,93,211,143,30,22,27,40,21,232,29,21,36,161,81,220,162,97,120,203,103,98,45,80,3,253,11,11,115,240,49,107,223,118,23,245,104,199,236,109,203,87,215,245,202,184,74,123,70,37,110,19,0,174,84,139,248,28,25,233,174,168,239,211,201,140,5,12,102,172,183,93,75,85,135,57,209,124,168,144,6,182,15,180,68,10,160,191,205,107,23,118,226,234,187,47,147,212,102,224,229,126,27,17,172,52,111,201,100,244,96,102,39,181,133,8,216,138,5,229,23,33,170,79,85,49,193,99,171,183,195,24,66,15,167,0,7,166,8,36,49,178,95,94,81,173,142,55,87,105,100,195,31,218,9,27,61,240,76,115,213,11,97,197,23,203,37,224,52,118,18,51,122,51,85,247,142,99,135,83,124,157,23,17,69,144,237,201,82,62,207,55,3,229,94,159,205,65,207,25,107,9,82,47,222,153,252,177,21,48,250,131,227,84,226,150,189,146,61,142,51,62,28,48,121,219,216,144,251,119,170,102,253,105,148,164,110,36,212,17,132,154,92,124,135,64,145,128,216,184,202,231,176,117,61,250,78,37,156,230,170,80,86,189,194,89,60,252,190,14,195,1,241,251,183,92,70,21,132,121,104,255,157,255,124,39,171,102,177,80,111,224,93,63,101,168,207,107,202,131,181,137,175,23,221,148,26,182,155,155,47,143,227,9,252,75,223,155,68,59,55,232,124,36,164,127,255,60,168,116,23,164,211,109,85,106,165,187,44,145,211,40,170,213,122,10,112,210,60,95,109,253,35,77,156,42,217,23,122,40,58,167,130,24,90,191,103,206,121,187,56,26,102,65,85,28,130,159,63,206,192,146,133,215,3,124,7,107,68,169,76,252,23,15,143,223,107,149,171,204,219,148,20,120,236,238,98,206,155,135,185,16,246,62,128,211,149,100,195,126,86,34,83,235,129,125,250,241,221,165,45,149,145,9,224,186,81,120,59,225,213,55,64,33,221,215,79,118,254,105,3,216,214,52,117,243,239,132,100,118,174,241,6,77,237,88,37,85,228,247,121,3,44,146,17,195,85,230,237,191,91,74,236,246,106,126,204,165,187,133,20,174,36,135,163,101,134,207,238,117,120,155,49,134,218,152,107,24,236,74,156,148,234,205,129,240,58,59,112,206,121,211,193,199,126,230,125,58,215,72,143,134,232,42,57,216,188,21,196,242,17,248,94,162,67,10,188,53,177,253,65,142,90,46,158,134,165,150,81,47,11,73,92,2,68,205,52,149,73,179,147,254,48,3,7,50,51,129,201,2,109,252,93,137,18,6,97,217,197,93,44,31,37,188,104,68,152,66,21,175,220,88,42,152,92,121,25,4,31,233,43,179,139,55,113,20,223,47,68,3,249,228,94,214,2,45,160,113,48,123,153,223,247,128,4,3,49,157,99,102,191,135,74,17,68,208,91,14,7,0,91,50,209,7,178,110,19,21,117,141,152,120,96,44,144,104,0,62,92,62,146,162,220,14,19,30,67,127,138,233,203,123,141,11,231,100,31,215,217,175,58,223,117,3,36,67,149,251,195,0,246,74,96,195,21,127,80,214,54,164,138,92,33,99,129,101,244,209,189,42,179,66,79,131,226,140,10,30,159,35,59,108,68,86,98,164,33,38,182,197,122,223,188,220,103,201,193,255,143,171,217,122,46,162,40,19,1,146,116,135,45,107,204,8,172,213,207,93,135,255,33,91,31,211,119,43,203,228,151,159,217,137,156,152,17,25,116,203,120,14,70,169,149,8,190,78,227,186,74,122,130,186,99,191,193,145,121,142,157,144,38,10,197,79,67,95,225,166,235,26,92,3,245,109,182,124,226,237,124,27,169,218,36,177,86,190,222,244,73,113,26,106,189,148,185,33,13,193,132,92,61,139,114,43,193,253,241,98,46,170,193,10,23,139,53,238,159,243,145,23,67,202,217,148,135,213,154,186,122,236,12,149,251,102,47,59,147,225,69,144,241,70,42,126,50,226,214,14,87,142,147,94,113,119,111,201,146,127,187,233,49,121,131,180,63,250,54,128,27,181,185,102,89,235,42,45,13,241,86,171,36,91,221,145,194,163,161,126,28,25,14,142,180,184,192,99,55,190,173,162,163,97,142,71,228,49,246,55,145,132,172,89,135,235,249,146,8,163,29,234,219,17,212,32,218,103,172,186,231,139,236,208,252,56,111,17,0,145,243,157,1,190,180,252,243,68,163,162,153,100,197,12,251,202,42,169,226,23,211,30,202,106,217,91,161,154,206,212,122,58,15,89,107,236,232,75,212,40,19,51,145,166,53,93,29,180,93,197,5,94,95,221,108,45,8,95,117,237,227,204,172,21,45,114,98,255,159,39,245,194,114,171,62,209,111,201,113,245,11,3,36,225,144,49,3,75,80,21,93,80,228,69,59,39,189,126,149,185,22,174,155,244,145,173,240,74,167,184,26,132,74,162,179,195,23,63,115,75,177,114,212,214,249,25,104,187,146,111,145,59,252,137,104,121,160,89,110,237,125,24,139,59,173,32,3,163,151,115,114,96,93,18,148,199,94,95,190,222,105,130,26,74,154,228,90,186,125,168,217,247,68,126,160,199,1,118,20,138,248,53,220,5,72,86,4,208,249,241,22,204,113,226,241,253,61,204,37,176,102,83,126,84,204,78,0,41,3,241,209,118,114,14,208,162,221,71,148,4,225,53,78,191,175,231,3,90,183,2,224,251,146,88,166,183,14,40,190,21,162,77,8,200,127,16,14,163,68,78,182,76,25,218,146,121,123,91,203,56,41,215,234,191,166,109,8,17,63,202,168,135,114,154,99,103,67,215,148,156,235,156,122,245,252,78,139,251,132,109,67,101,206,230,139,76,195,177,81,4,231,56,126,230,238,154,52,26,20,236,79,117,219,22,18,218,223,53,67,194,197,114,38,56,235,175,167,189,214,91,51,25,156,136,183,58,72,164,231,2,181,118,209,16,221,40,127,24,175,102,103,123,115,77,100,14,4,123,89,233,114,17,231,10,157,226,2,246,202,32,196,45,100,35,44,202,97,71,76,248,122,235,226,6,19,125,41,133,120,154,209,36,73,153,188,223,204,52,207,50,94,105,115,233,65,112,211,254,213,84,60,235,225,96,71,100,16,181,16,8,7,149,73,42,121,3,36,153,1,207,16,86,91,191,71,233,202,252,78,2,226,172,72,70,29,16,237,18,183,15,154,85,193,188,250,79,229,120,115,96,243,94,81,229,75,234,62,82,224,142,79,21,188,20,84,45,169,192,102,212,169,38,33,114,27,244,221,101,197,191,107,158,87,58,112,236,39,204,207,207,28,43,240,163,122,212,83,132,57,83,169,181,238,198,165,29,148,104,70,182,211,113,90,170,229,132,212,200,33,31,162,215,160,213,26,150,91,3,40,250,236,112,166,226,109,230,72,116,0,188,181,213,107,33,100,191,90,80,253,194,247,161,81,52,193,103,76,181,157,155,102,159,14,170,128,169,160,175,49,94,45,84,177,234,228,125,153,153,65,150,31,85,127,240,83,232,251,116,30,238,91,164,187,216,58,160,121,251,82,26,187,3,189,175,90,67,106,160,197,173,231,157,159,217,89,109,59,147,12,68,113,132,46,36,14,32,49,166,117,194,110,76,110,182,129,137,6,4,40,162,162,105,132,234,238,52,89,56,107,48,231,151,69,86,121,7,132,29,144,126,177,64,97,37,112,171,11,105,233,81,205,252,249,116,39,167,218,100,144,230,197,197,193,36,78,5,223,139,60,227,43,194,106,170,112,238,116,238,140,120,238,238,56,223,224,91,229,21,184,150,135,135,197,104,242,154,171,169,184,167,173,16,92,30,201,68,146,24,95,7,171,88,39,61,139,84,242,211,228,127,4,199,252,234,20,9,130,53,103,86,134,16,87,14,67,238,35,165,89,214,145,30,109,128,220,61,0,94,254,101,242,23,157,241,147,241,130,203,217,207,58,42,28,39,181,134,227,137,219,196,180,28,32,36,211,22,29,48,4,179,18,58,168,117,113,161,162,142,179,34,205,43,5,14,115,168,131,161,161,11,206,180,109,143,171,113,73,175,67,59,107,194,159,133,219,239,83,24,132,128,215,185,216,176,21,19,66,51,155,26,23,13,76,241,116,237,70,24,165,51,229,162,68,249,3,144,226,215,222,147,131,234,217,140,189,204,169,179,125,82,206,78,247,212,8,213,250,165,50,98,235,2,255,3,193,110,80,124,109,136,181,157,235,74,220,222,119,37,223,73,16,9,11,150,106,14,162,114,120,142,222,174,255,86,95,121,12,75,151,19,26,146,59,100,222,90,40,130,254,130,78,169,75,205,69,97,54,32,107,155,144,248,237,171,40,215,162,2,140,141,19,220,18,227,204,162,20,206,106,164,128,128,213,67,224,186,39,120,182,20,194,2,121,131,253,147,190,138,163,206,228,247,74,77,215,246,40,75,247,189,148,82,25,72,178,228,164,66,35,32,171,228,136,206,80,238,75,101,135,39,42,219,191,128,94,7,171,56,192,242,165,36,185,89,168,218,0,233,147,129,123,179,187,157,163,6,85,212,217,188,26,220,173,176,35,155,56,127,0,60,203,179,238,127,119,167,219,62,106,14,166,70,239,16,197,106,82,115,111,16,126,115,181,52,233,107,110,230,83,100,219,0,102,50,192,243,67,34,205,248,65,165,190,11,175,250,126,195,120,54,58,87,135,35,0,33,141,94,33,124,9,123,161,62,166,140,106,27,189,65,42,187,232,175,93,53,211,57,58,166,195,162,205,212,16,68,142,157,115,218,86,7,121,7,132,218,178,108,170,243,141,31,29,5,112,235,32,247,246,220,172,48,4,127,60,157,180,29,57,142,27,134,73,116,39,170,191,154,71,221,96,212,70,41,228,66,63,127,102,167,183,8,195,225,75,133,221,135,83,24,135,240,16,152,155,143,178,96,1,247,120,177,19,33,27,218,92,199,75,192,182,72,33,28,108,8,186,169,75,153,217,6,195,121,165,212,192,235,185,21,207,57,161,72,85,106,123,79,145,8,179,54,218,60,47,252,4,118,64,121,179,32,188,119,120,129,198,134,43,75,140,95,237,205,200,194,134,154,216,245,248,231,169,204,202,128,173,74,120,113,132,179,244,190,181,227,22,124,181,234,241,47,128,203,226,70,137,142,186,205,213,55,107,127,82,94,208,67,92,68,160,212,177,140,121,20,245,23,90,46,77,66,239,133,90,98,237,62,81,4,193,72,152,23,94,184,124,83,252,115,130,154,76,80,169,232,134,48,35,246,122,158,240,138,111,41,88,35,188,49,22,159,124,143,142,211,81,35,111,160,58,56,75,152,192,83,139,209,75,78,147,135,170,8,222,166,197,69,111,2,176,5,120,92,247,196,209,154,1,177,173,0,200,217,137,107,252,132,27,123,189,195,255,188,57,111,182,45,194,177,44,248,78,55,76,77,120,161,0,81,61,115,146,225,62,176,159,33,39,15,134,216,137,218,244,200,35,203,71,199,157,158,151,25,53,110,90,117,74,174,34,177,43,26,110,164,209,234,174,13,212,102,148,206,203,136,187,85,144,163,181,76,240,147,4,131,139,150,107,57,191,113,56,157,113,89,73,123,18,120,110,41,174,49,214,97,241,134,15,59,133,224,203,185,166,157,77,249,171,188,235,226,56,171,41,111,59,130,156,197,156,87,40,178,84,70,229,26,39,74,51,41,98,226,189,120,121,177,115,32,176,33,122,202,190,64,66,180,83,213,209,150,10,47,106,182,81,9,98,239,148,40,113,43,160,158,120,149,71,239,36,173,29,200,82,253,97,115,17,45,252,44,110,98,246,252,95,179,231,183,192,106,201,204,73,159,45,158,75,21,58,108,174,192,120,131,87,51,69,184,144,66,135,3,236,148,211,42,100,240,97,181,219,209,84,188,95,55,77,33,241,174,201,246,119,114,82,243,113,190,211,91,18,40,219,56,30,45,50,197,124,93,140,67,207,20,166,29,247,2,144,229,187,129,223,97,221,189,23,253,170,29,103,129,224,253,159,36,183,94,105,88,187,86,10,108,68,150,126,206,208,221,5,57,108,136,203,171,189,144,16,177,65,248,144,176,2,101,206,168,153,5,17,159,26,21,43,124,50,21,14,82,212,88,118,101,200,192,94,56,193,238,56,41,211,48,146,53,164,24,118,21,242,57,122,50,226,248,36,203,177,228,105,224,208,87,115,154,167,212,34,139,167,227,12,128,234,174,34,196,64,202,24,237,201,235,130,152,189,181,205,112,191,126,23,244,169,83,145,205,180,61,103,110,85,221,128,21,68,15,80,88,219,168,18,185,228,24,199,10,255,102,31,114,22,60,226,159,51,124,236,181,86,15,198,141,232,145,245,81,99,35,237,85,133,14,195,170,200,229,124,223,52,111,3,180,50,40,119,13,143,59,178,153,152,53,59,229,18,173,168,132,98,224,32,175,139,158,228,121,246,251,87,181,179,87,33,229,125,105,107,144,152,10,194,18,182,57,181,66,86,244,215,219,138,184,107,25,23,22,27,66,226,98,137,103,236,145,237,151,225,239,72,191,118,142,2,233,31,60,137,172,55,200,186,190,229,32,219,15,100,84,225,162,13,79,137,214,83,194,122,132,157,61,100,228,141,225,67,29,235,245,21,153,216,5,16,77,129,94,122,203,41,24,164,227,184,31,215,28,51,255,127,179,171,44,157,227,120,230,206,219,219,246,107,199,68,100,150,148,152,27,51,46,147,17,160,201,67,244,236,63,90,67,63,248,85,212,209,156,113,154,157,104,161,153,135,27,53,113,23,15,227,165,117,116,81,40,252,186,3,125,219,159,98,147,94,161,220,144,2,1,75,209,10,252,179,237,30,101,45,95,140,155,100,83,168,146,165,125,223,168,6,172,232,64,107,78,9,146,17,132,207,123,66,88,114,169,210,89,208,85,21,250,232,212,42,214,121,119,201,34,106,153,134,72,193,29,62,194,177,138,123,131,248,11,43,241,221,104,201,32,123,135,184,100,183,114,106,159,172,18,52,82,14,89,176,185,195,132,145,122,100,74,91,165,213,12,13,97,140,230,163,81,218,179,218,10,70,233,151,50,117,39,87,41,191,74,140,254,232,43,183,201,113,91,109,195,236,226,198,113,163,134,199,107,204,203,61,74,11,61,191,251,120,249,219,11,86,96,170,102,187,146,237,30,174,141,228,159,167,43,69,86,17,112,214,37,37,251,255,124,89,1,97,245,163,203,28,100,115,173,61,30,40,210,82,98,168,18,64,228,175,173,231,119,118,24,89,98,60,141,68,139,208,80,148,108,121,99,130,205,34,225,243,222,255,43,238,152,196,107,181,67,152,253,197,174,240,223,152,246,50,235,216,133,146,148,101,61,55,14,195,68,220,140,130,226,244,124,54,121,60,4,97,247,252,82,64,203,172,106,124,199,60,195,185,43,223,159,36,254,189,180,43,88,26,58,78,213,74,30,206,47,106,31,142,219,144,53,159,168,118,107,211,79,113,88,225,62,224,117,252,242,53,47,105,174,86,103,225,206,238,219,92,228,85,174,218,180,205,253,152,234,58,108,109,209,227,46,93,166,101,220,60,168,105,94,158,67,141,161,83,248,46,158,212,199,74,16,98,139,37,72,195,139,111,162,108,198,212,99,55,231,49,82,3,112,227,95,189,254,233,203,3,235,36,208,146,164,9,33,98,230,92,161,177,137,235,92,181,253,125,41,203,133,124,74,222,66,92,19,175,131,252,79,51,188,60,231,28,188,162,93,239,56,201,69,6,129,176,125,233,109,1,13,231,143,5,164,251,2,164,160,217,241,81,226,228,210,176,108,17,139,101,120,23,190,198,97,168,151,40,184,23,34,6,36,144,183,216,175,205,53,57,188,56,82,104,171,225,36,193,169,247,103,18,188,209,129,60,226,211,225,177,139,181,81,255,19,207,21,46,176,9,55,132,203,93,28,91,175,238,207,214,201,65,51,211,3,166,138,81,241,213,27,207,238,211,135,63,30,90,14,3,60,41,242,133,110,117,150,228,60,50,161,255,59,62,126,232,126,103,101,230,160,12,76,238,179,196,126,38,6,75,195,18,185,123,200,210,157,68,56,131,102,4,185,135,9,83,88,220,36,103,45,101,137,161,232,178,200,187,196,246,32,141,115,80,229,44,133,25,85,122,62,249,247,141,136,75,134,211,55,154,62,127,172,202,161,186,126,174,72,107,151,235,147,214,112,180,86,78,214,117,203,102,148,99,150,181,169,139,232,149,175,129,142,7,30,69,191,178,179,79,12,167,166,85,107,3,112,212,54,34,17,73,13,236,86,124,1,162,154,72,67,232,41,185,219,232,3,19,89,187,208,214,132,54,185,18,192,167,176,189,229,250,146,106,216,83,199,222,122,147,90,192,227,204,114,159,6,60,193,142,8,208,202,174,182,203,29,16,195,62,211,201,204,43,223,212,230,200,109,192,35,87,198,79,204,217,223,91,31,182,166,157,231,191,34,73,135,240,21,130,141,98,60,86,81,239,147,0,74,175,114,80,227,243,74,162,57,63,13,208,58,161,75,28,134,123,151,26,175,52,43,119,82,177,231,233,112,79,206,230,7,196,92,249,152,60,131,194,89,198,158,166,88,147,148,124,133,220,59,254,227,204,75,150,232,160,37,75,130,150,63,3,62,245,22,48,119,39,255,77,40,82,110,199,96,140,142,179,218,155,189,3,207,133,176,62,54,94,98,121,62,183,227,108,50,190,3,250,129,96,85,4,56,91,40,174,38,76,35,118,125,235,121,87,60,195,137,228,167,5,54,46,194,198,44,76,11,41,167,213,119,146,25,85,60,228,174,255,222,36,249,47,238,64,75,231,127,140,237,202,185,26,249,210,192,251,0,123,16,161,219,47,96,122,208,207,55,76,122,99,104,96,177,102,83,65,152,8,100,116,226,42,75,134,207,188,253,107,163,104,69,249,32,159,66,41,90,69,86,210,57,81,123,156,70,112,218,231,185,67,168,138,41,117,92,106,49,40,251,143,171,67,244,161,47,39,39,95,63,136,129,28,104,184,129,31,198,103,214,248,49,13,91,222,100,251,149,69,118,217,226,96,230,204,39,214,79,138,93,195,51,124,247,254,141,11,185,105,225,179,26,232,195,30,29,82,219,76,176,112,194,143,66,35,171,15,67,10,78,187,245,36,251,190,221,156,100,198,205,250,235,160,170,212,242,195,179,99,184,176,224,46,185,1,64,162,129,58,6,20,219,244,231,82,121,141,245,211,164,65,78,214,60,223,61,202,143,185,41,182,244,61,40,52,3,4,144,248,140,178,201,114,240,190,149,220,22,249,27,94,82,18,43,233,76,78,133,54,191,120,85,10,91,127,169,35,75,158,52,154,167,10,250,26,207,209,60,124,47,40,202,106,199,138,214,30,224,242,5,253,81,242,148,69,60,86,82,246,196,50,90,84,238,191,124,145,194,237,243,166,230,171,221,27,189,145,74,170,148,102,235,85,78,13,238,109,138,96,50,74,127,189,19,202,225,83,197,15,232,97,185,233,140,237,191,52,157,199,230,57,183,211,137,131,189,43,114,34,117,87,207,244,193,79,102,24,197,111,77,250,94,86,141,81,80,80,140,168,81,97,23,105,109,129,163,145,150,103,232,170,179,41,91,193,101,133,253,64,167,172,127,112,131,8,226,89,91,91,67,124,116,67,213,115,212,229,20,81,254,115,55,199,160,59,86,152,17,167,168,145,237,50,158,225,6,20,88,61,114,211,204,134,152,41,191,52,32,31,189,216,13,16,65,204,55,2,234,55,72,170,91,103,142,250,132,126,69,43,156,199,151,167,71,157,62,127,168,31,172,139,85,242,248,178,64,17,130,57,39,68,24,56,214,36,217,216,61,102,12,95,6,206,157,153,66,15,238,89,78,30,178,110,54,121,248,79,121,244,137,236,150,86,237,125,191,177,251,155,200,106,219,128,144,198,242,124,64,1,216,185,40,7,77,102,122,125,230,71,227,74,202,219,45,237,103,95,29,5,158,194,24,247,8,85,91,22,237,173,143,225,255,108,196,14,76,148,64,174,237,207,89,160,87,137,82,7,245,185,221,22,48,189,147,17,209,160,237,12,17,161,63,126,43,195,153,110,130,26,82,245,39,216,251,112,172,165,140,70,10,231,105,188,216,236,136,71,72,97,231,120,112,107,207,36,161,193,165,76,41,177,242,204,57,180,41,70,61,11,195,51,131,75,148,250,40,135,25,97,193,103,113,59,19,127,194,15,169,232,170,52,211,252,171,120,247,129,242,158,181,81,173,155,223,149,19,122,144,102,114,212,201,113,13,134,175,124,227,87,144,132,42,245,44,101,190,242,254,48,54,166,85,10,240,56,188,89,141,181,202,45,197,167,52,64,253,74,210,253,122,155,80,242,163,106,126,163,165,209,86,71,6,251,214,92,47,179,75,104,124,122,152,176,54,185,194,93,151,51,150,175,90,16,53,88,210,30,34,183,232,6,21,56,90,95,7,8,1,59,193,231,184,118,46,84,236,59,139,253,249,83,28,27,105,178,98,19,6,148,192,94,27,216,17,168,3,218,15,52,237,2,237,235,100,251,139,32,190,239,201,11,38,86,133,89,222,245,120,179,189,57,45,229,61,224,12,168,95,197,255,130,237,165,30,104,212,50,11,245,98,251,242,214,59,188,100,241,223,75,38,56,175,158,21,146,78,64,183,162,247,135,58,192,211,199,8,215,145,60,238,50,218,61,126,10,201,175,195,7,48,14,224,11,183,224,135,51,139,105,32,37,108,167,59,21,89,237,107,110,40,246,205,166,16,244,132,83,157,232,124,191,86,1,250,237,130,193,85,106,225,76,106,107,220,128,111,72,118,89,65,169,66,159,52,189,138,46,8,37,113,12,45,116,113,183,79,62,14,35,9,36,148,142,140,20,239,81,89,187,227,69,114,119,58,107,5,137,86,146,135,246,58,169,144,57,226,22,180,193,139,150,233,38,98,75,187,103,146,249,21,35,200,229,39,200,208,171,192,60,152,10,220,213,16,240,214,158,231,36,67,199,97,88,218,174,43,190,31,2,38,214,206,245,38,48,1,161,12,80,178,83,248,68,172,18,41,119,219,157,195,59,179,229,60,33,5,89,171,240,199,110,6,148,184,27,207,220,24,102,161,129,144,56,9,203,212,91,5,76,255,8,180,63,129,187,198,123,123,17,224,220,34,134,85,85,193,32,17,185,47,166,142,249,211,128,21,112,40,40,240,238,173,157,159,51,102,77,110,81,201,221,140,23,241,73,245,65,187,98,231,80,29,146,96,232,86,93,215,91,169,232,232,202,67,37,88,166,218,152,20,78,22,40,204,235,75,10,223,64,205,18,23,134,240,102,217,233,82,190,253,235,102,253,213,167,181,1,179,246,86,56,84,226,181,99,18,100,5,242,131,24,230,114,186,124,242,62,160,5,177,134,69,199,176,94,251,49,154,244,147,128,94,170,61,115,148,193,20,233,40,103,166,184,142,207,94,204,225,49,12,11,86,245,93,116,135,219,212,213,108,26,121,4,116,108,210,23,156,184,100,237,235,55,53,21,229,34,82,36,56,145,129,28,134,59,13,10,138,102,102,11,30,226,84,36,31,86,32,69,32,100,13,113,192,168,244,183,136,155,188,58,50,190,105,232,122,55,16,42,219,99,164,98,126,255,159,251,194,163,124,83,19,237,160,40,25,77,13,96,96,17,213,230,41,228,90,139,145,156,91,69,0,216,128,16,145,41,31,92,162,74,167,211,104,117,5,131,130,43,59,71,209,123,149,155,98,60,125,77,89,191,56,188,255,131,93,58,123,102,210,139,78,119,237,18,41,69,230,31,110,14,110,231,170,255,177,224,39,51,167,103,42,123,152,57,20,134,36,144,220,238,244,65,233,64,244,169,118,180,0,132,177,208,132,190,141,163,100,190,115,233,64,246,75,157,85,88,118,45,244,41,181,34,77,74,104,245,254,124,2,120,85,33,121,84,68,233,215,35,242,155,137,228,223,223,152,64,68,203,133,135,227,62,231,87,212,162,11,239,129,26,144,68,53,101,236,154,242,160,141,7,10,199,213,132,139,65,183,189,106,18,62,189,21,47,130,26,118,70,80,162,0,100,123,141,59,195,6,236,61,221,123,155,119,208,19,60,21,146,200,198,161,181,240,7,18,134,172,102,240,209,142,119,251,21,151,231,179,206,190,34,158,166,40,216,92,7,116,183,131,135,101,156,7,242,224,158,123,73,116,189,59,49,253,156,203,204,69,225,56,201,239,241,254,125,91,252,12,84,20,182,244,66,23,99,116,74,82,231,162,4,178,184,205,159,17,241,148,157,163,198,82,253,145,157,109,1,249,118,24,144,103,162,144,37,52,69,182,116,24,127,90,217,38,180,6,200,6,225,50,25,152,151,16,38,222,114,165,254,185,65,207,88,44,8,245,221,11,152,57,79,229,4,176,44,188,246,118,243,218,123,171,221,67,193,246,239,154,133,157,123,87,133,224,111,50,255,21,192,182,6,58,210,193,156,70,12,3,194,133,13,36,14,7,201,156,209,37,195,51,182,159,237,206,104,67,230,248,187,30,2,191,79,120,100,161,2,126,88,113,16,12,238,34,135,164,79,88,118,68,10,135,55,234,49,77,117,27,254,173,249,210,34,248,49,224,226,215,75,68,228,203,182,241,162,184,246,97,225,112,123,252,92,37,68,128,18,32,219,60,1,133,136,4,107,174,21,94,248,140,34,74,87,182,141,222,141,56,11,59,28,191,189,122,71,33,142,235,1,26,34,238,90,111,242,162,117,14,204,170,214,233,232,10,239,69,62,111,92,89,230,143,254,122,46,161,190,224,150,149,107,1,200,159,251,252,119,68,150,85,125,53,161,103,241,163,234,222,57,37,28,92,109,20,35,138,39,197,3,77,209,238,227,34,182,249,189,255,222,191,43,198,129,35,136,24,29,168,0,122,210,244,71,137,79,153,73,41,144,104,81,60,32,15,240,47,224,204,4,9,176,151,67,215,103,210,47,42,236,92,93,62,205,149,97,103,115,85,238,217,102,136,56,51,148,152,186,177,67,179,241,17,75,33,8,65,88,64,51,97,74,170,66,204,18,74,12,137,250,100,42,100,95,87,90,27,45,163,112,94,205,113,35,204,58,230,72,252,4,193,70,210,123,208,61,35,220,50,223,82,190,26,81,51,234,17,31,155,43,102,70,26,96,62,41,118,225,34,11,143,11,75,78,87,100,43,145,209,116,158,42,168,238,241,181,245,203,56,222,133,252,36,238,152,223,108,42,17,202,58,98,14,196,76,224,76,117,34,226,113,60,2,56,32,179,57,95,29,186,209,171,71,18,107,143,56,206,62,182,205,43,46,150,133,9,255,248,232,68,49,95,38,78,63,23,141,48,200,71,3,108,31,161,8,112,252,7,197,61,122,228,222,84,70,179,218,58,237,10,195,73,23,62,201,9,57,144,194,218,1,126,142,31,39,106,78,157,16,118,201,168,25,1,99,116,13,96,146,103,54,151,106,110,224,123,181,172,4,119,114,146,239,241,201,202,20,13,169,211,211,139,101,202,253,248,0,110,240,16,117,191,179,210,47,124,194,211,110,149,171,188,140,237,209,122,146,201,3,219,198,87,185,89,93,13,85,216,51,243,180,249,160,111,162,146,41,238,68,234,141,172,134,112,25,158,175,165,250,64,39,187,59,229,187,255,217,22,189,1,125,250,74,106,103,75,125,28,18,117,141,38,2,211,110,182,25,75,193,142,208,206,133,93,98,83,228,19,107,138,23,71,161,57,169,198,77,217,222,113,99,142,26,189,255,141,82,0,142,212,46,140,138,18,45,93,153,42,184,1,166,163,87,214,125,45,205,247,179,36,235,30,169,213,192,140,191,29,29,195,109,150,249,75,225,148,242,62,70,75,30,242,147,169,102,219,26,160,0,86,99,232,21,151,195,254,60,71,144,242,91,121,212,35,25,42,139,127,71,65,245,237,63,106,82,68,192,250,232,123,224,80,120,132,109,115,236,186,66,142,220,83,14,73,53,172,219,112,119,23,6,241,20,211,21,5,205,199,59,230,51,22,254,49,158,17,68,96,5,56,190,38,169,37,102,19,2,100,152,47,95,236,153,68,195,122,174,249,155,111,177,210,78,217,107,229,74,55,35,154,207,227,194,41,98,45,67,221,107,5,230,89,207,238,117,64,82,112,0,156,244,153,135,44,203,149,173,165,163,93,88,233,113,68,54,237,91,237,92,66,172,240,105,52,252,97,118,159,102,171,237,211,160,194,226,82,164,72,128,157,143,88,143,152,255,191,190,248,229,194,94,233,153,146,18,93,84,49,56,92,178,89,10,185,107,25,33,192,253,201,213,48,113,122,193,60,163,187,223,121,130,35,88,136,30,163,91,211,29,218,202,114,113,23,232,254,74,130,179,189,229,241,39,183,206,120,198,129,6,239,218,176,150,201,247,153,58,193,180,43,167,28,155,189,40,105,164,200,189,158,68,234,250,241,177,147,173,43,33,24,201,235,158,17,72,227,168,117,139,166,154,180,89,113,36,6,15,255,42,26,175,59,165,150,6,237,178,179,199,242,215,194,25,21,76,25,7,32,218,0,153,212,112,33,195,56,3,243,196,239,246,87,242,160,133,87,183,116,108,109,166,217,74,49,31,42,37,80,47,231,158,236,55,54,136,159,129,148,137,161,193,238,100,237,52,14,195,82,183,178,186,105,106,225,176,95,196,187,82,87,82,255,223,233,62,217,188,42,146,3,1,125,13,36,28,125,165,165,118,131,88,27,42,131,105,19,120,245,24,41,222,59,119,230,82,19,42,29,185,74,198,36,88,59,4,83,250,146,100,165,69,1,194,108,59,68,172,214,93,253,193,194,66,30,82,239,159,231,189,123,33,1,104,183,104,225,156,77,16,60,207,10,206,188,71,242,1,146,83,14,67,250,247,207,192,250,137,102,12,248,40,174,184,74,98,67,4,197,222,210,223,215,235,159,32,151,39,38,10,215,223,18,23,137,248,48,187,138,161,12,192,10,176,144,45,160,229,41,37,12,252,201,197,180,163,180,81,179,19,82,251,188,21,83,124,201,102,134,147,170,135,78,145,163,39,211,230,86,145,4,135,71,116,205,202,226,88,185,85,234,91,242,88,55,11,62,66,224,191,136,218,149,232,194,31,61,74,37,253,183,27,222,72,2,133,232,16,164,211,155,204,77,88,107,148,72,219,140,134,238,0,241,164,254,30,108,218,175,2,20,100,230,176,30,96,142,198,107,21,81,173,222,14,253,48,178,12,140,32,238,152,159,84,74,19,55,220,198,85,129,119,200,64,164,231,69,101,151,31,141,140,29,236,255,220,46,11,120,130,202,250,218,86,66,235,180,62,158,233,235,171,23,232,172,186,48,6,75,249,20,171,50,219,212,251,18,242,234,32,144,224,84,136,240,167,169,154,14,8,94,211,89,73,99,115,234,229,199,15,119,100,106,255,194,211,202,81,157,56,34,254,172,203,181,123,168,70,73,17,95,185,165,233,5,119,188,50,58,108,206,227,35,70,42,53,250,191,102,38,140,158,41,246,63,175,146,227,133,221,49,115,205,116,65,45,202,32,200,90,116,0,147,202,130,37,11,8,198,50,146,13,255,216,87,255,5,138,74,148,216,220,91,25,211,185,107,18,209,45,128,3,110,177,62,212,252,141,104,80,88,241,198,255,161,96,71,120,201,225,128,161,151,198,220,252,131,28,145,96,233,205,6,187,245,119,230,28,116,212,26,241,74,134,239,148,106,11,81,115,180,77,147,181,179,62,90,184,131,156,247,132,187,93,71,140,140,194,228,91,153,225,126,26,51,198,253,123,194,65,114,87,35,215,225,11,219,191,159,85,194,89,246,43,221,108,20,51,211,120,49,184,221,78,35,188,56,77,231,146,200,88,197,231,221,165,182,66,8,225,246,228,206,235,24,190,182,210,57,2,130,219,146,163,161,97,213,47,155,200,177,177,56,105,241,55,220,178,198,121,108,107,14,66,43,165,170,160,105,158,77,9,14,188,56,58,186,158,241,13,187,35,146,0,147,135,151,113,236,118,16,150,109,34,91,83,4,193,36,26,144,124,155,93,242,122,39,143,158,194,107,70,158,101,109,186,105,130,0,92,34,117,76,207,89,1,4,31,129,211,139,7,12,11,223,195,111,220,196,253,213,13,162,113,177,50,153,63,1,100,248,180,35,108,86,193,53,115,230,220,214,91,202,210,40,55,43,1,164,45,250,117,91,159,1,221,91,48,111,203,144,232,60,252,235,156,155,100,71,108,180,227,108,140,210,195,15,187,9,147,251,142,199,138,62,159,229,200,100,37,35,1,139,208,220,182,142,91,58,73,151,86,170,218,194,21,12,25,176,223,143,60,35,205,30,103,229,68,147,135,25,208,55,111,244,118,61,56,246,164,145,121,215,100,171,36,232,24,200,187,46,169,179,237,197,88,223,106,68,24,212,255,28,62,103,120,85,121,188,64,253,190,250,110,200,100,199,161,228,54,214,19,166,160,118,116,248,37,118,79,56,233,218,34,36,100,191,181,106,250,82,55,144,42,21,247,232,211,234,248,126,36,71,181,240,234,25,134,82,155,3,135,13,201,119,129,134,56,217,94,63,215,114,194,58,65,40,199,159,174,28,10,149,204,219,190,102,136,201,24,30,177,228,252,117,163,140,105,228,79,140,101,229,250,216,152,188,155,173,92,192,143,204,44,91,41,40,194,241,22,130,215,69,232,25,154,43,127,15,74,234,251,233,130,215,139,249,55,36,10,4,48,237,94,230,173,90,86,59,106,57,138,21,40,142,108,108,189,39,181,20,19,199,125,45,139,34,21,245,76,216,100,100,67,36,152,248,241,30,128,208,246,99,199,237,151,143,224,182,19,2,51,23,233,117,204,201,209,96,151,255,112,252,116,141,239,127,145,48,66,109,125,63,128,79,7,244,84,225,24,78,92,101,41,107,250,20,200,196,123,62,216,56,85,104,190,61,44,229,149,140,183,167,32,212,237,254,28,224,166,149,128,154,134,135,100,178,125,52,141,243,184,182,42,164,213,185,63,129,149,212,107,46,104,3,18,193,80,71,0,137,101,148,40,24,139,93,35,157,16,35,12,209,68,78,186,249,129,36,138,89,94,82,73,25,230,230,94,148,91,18,46,84,216,114,239,107,143,243,17,138,51,189,199,204,145,25,97,237,78,143,37,121,44,235,58,21,121,40,12,96,144,242,112,242,11,250,69,152,76,14,10,231,198,70,126,87,152,21,187,126,159,226,7,36,178,88,168,202,38,131,19,184,206,186,168,228,161,103,214,163,18,164,25,143,195,179,55,69,93,96,85,108,172,33,25,84,24,16,128,123,110,52,12,148,231,161,139,14,121,79,139,161,181,87,73,124,214,19,182,140,156,166,26,247,98,105,91,136,101,232,13,38,108,49,68,13,141,87,12,53,188,184,206,169,151,66,204,81,161,3,240,15,2,146,236,9,61,178,221,205,115,151,177,132,153,170,5,172,235,62,182,151,164,174,129,74,241,64,234,69,217,57,29,246,165,250,179,198,185,202,158,60,38,108,38,134,46,162,167,246,50,245,108,52,74,53,219,42,133,88,12,244,205,25,191,113,85,66,73,30,244,155,52,230,76,80,129,61,29,205,225,84,246,83,204,115,19,113,48,150,19,79,161,3,11,163,154,237,130,42,88,123,85,16,58,195,193,55,238,11,229,32,215,68,189,174,241,152,231,241,198,24,227,106,224,164,243,255,2,58,60,71,197,154,19,182,43,6,12,11,41,26,183,188,20,152,142,151,156,33,67,140,160,190,208,130,121,198,112,138,238,210,218,146,79,222,65,160,235,66,125,177,247,100,60,114,251,137,221,161,161,112,122,238,184,50,134,53,32,76,200,134,47,203,241,1,54,133,52,147,251,132,232,166,102,216,157,105,43,43,67,229,234,145,39,140,178,238,82,152,80,9,209,74,160,24,58,161,228,140,109,152,39,154,46,147,80,105,36,128,255,27,28,219,47,34,49,71,237,127,15,182,205,122,161,159,46,165,199,76,50,74,62,27,231,231,23,201,46,27,174,131,135,160,136,85,16,65,40,17,170,170,108,152,142,179,15,184,246,187,71,51,183,79,187,143,110,13,14,242,92,11,68,85,69,37,57,56,113,103,47,14,31,195,81,83,102,12,170,236,191,1,142,35,19,63,152,243,213,76,27,167,16,49,250,140,182,39,230,190,153,157,16,179,1,136,63,201,131,226,5,239,248,53,175,74,83,243,207,41,107,11,193,114,203,199,112,102,212,190,145,31,198,212,1,10,250,156,183,28,139,105,55,91,157,248,168,1,57,95,23,186,64,52,192,87,162,103,223,128,146,134,210,2,17,188,151,24,162,114,135,5,130,81,129,209,97,214,231,171,244,58,157,175,24,31,30,187,17,205,227,27,197,97,128,192,100,163,23,185,92,129,154,17,50,151,12,167,190,33,144,134,118,96,62,126,190,219,109,29,26,173,1,199,204,126,208,116,128,180,97,19,209,226,83,143,157,185,173,107,255,176,79,230,112,213,209,87,155,104,149,210,132,109,23,202,139,123,37,110,239,212,252,113,248,223,95,123,22,14,187,177,158,42,183,247,70,24,130,5,61,166,164,199,92,246,88,206,8,192,133,192,185,154,212,20,19,213,169,237,26,40,194,11,33,2,50,122,42,245,192,82,54,232,213,25,54,228,22,102,213,175,5,101,75,236,92,53,236,118,27,186,115,80,112,123,57,22,148,12,2,209,94,106,36,239,159,9,107,126,82,145,238,28,67,4,205,140,237,236,171,11,207,146,110,70,149,179,3,114,110,221,197,67,185,106,56,8,175,117,209,69,45,50,107,93,225,241,164,223,176,39,128,165,236,26,130,114,3,70,174,29,87,210,181,158,155,39,161,199,194,123,221,101,13,139,168,174,136,161,129,109,33,155,140,148,35,108,224,161,222,172,116,179,56,190,117,235,6,118,67,157,117,101,26,103,160,40,188,17,243,217,206,120,92,48,6,60,182,187,118,5,184,245,17,138,78,40,226,53,201,114,184,88,88,19,53,42,114,65,225,47,66,89,82,72,218,159,119,117,121,21,146,23,89,97,64,204,191,92,13,113,225,35,140,117,251,201,206,66,36,62,113,123,50,151,116,29,205,169,45,169,201,63,28,157,139,244,2,203,246,59,158,39,56,194,227,150,55,66,87,214,190,222,149,149,158,188,254,62,115,189,85,119,220,157,79,160,232,245,5,242,64,32,148,183,32,253,193,35,146,56,183,68,75,133,47,207,87,123,30,112,136,99,172,205,154,66,4,221,71,130,178,10,141,140,39,196,103,4,151,88,76,72,118,18,71,187,166,145,27,12,22,233,125,75,236,14,72,0,242,82,10,165,147,230,53,116,132,245,81,145,117,122,64,85,235,130,202,108,73,111,100,207,56,94,112,112,83,142,151,8,231,175,219,94,48,32,75,159,108,181,171,71,221,112,7,217,143,151,22,150,48,237,144,99,212,75,207,188,175,137,28,149,216,31,52,84,4,174,36,176,224,7,30,9,75,204,236,172,254,22,251,137,201,181,104,227,126,120,118,60,168,154,182,33,166,96,240,57,100,191,47,68,97,208,76,175,119,62,1,60,189,22,23,131,63,182,75,99,175,51,194,42,203,55,232,14,83,226,251,209,35,200,134,172,182,61,34,84,189,115,37,161,245,82,183,136,152,208,134,255,114,117,104,88,3,120,28,5,101,253,109,204,204,216,20,125,223,144,124,124,120,158,3,108,248,51,171,129,96,243,63,75,193,174,78,114,17,216,253,141,235,140,91,46,46,9,228,176,18,125,1,87,5,215,24,116,127,82,56,83,184,236,133,169,21,238,40,252,9,76,44,135,117,101,253,161,212,247,58,137,21,129,221,125,243,94,69,157,90,181,19,69,144,163,183,64,9,210,3,247,43,67,177,67,69,164,109,163,126,162,85,172,238,207,122,100,124,49,12,177,179,108,77,25,103,208,58,4,207,107,37,73,202,105,216,121,186,139,81,153,201,83,42,146,220,188,192,12,109,226,48,49,7,215,191,213,250,29,44,172,110,56,101,132,35,46,148,22,129,22,128,249,39,191,70,232,124,182,232,194,213,220,110,37,144,145,78,13,110,245,227,138,57,81,161,246,232,108,253,80,173,18,43,22,116,153,152,139,88,215,202,199,70,245,115,240,195,176,10,81,38,244,207,205,44,80,49,168,57,59,114,184,125,50,103,213,239,91,240,89,20,90,18,54,10,121,43,27,177,77,221,28,245,110,219,89,160,92,169,221,196,146,19,241,242,104,230,157,180,21,15,129,51,2,52,166,249,103,19,212,204,26,46,154,249,151,59,32,159,90,132,167,43,36,209,53,30,4,24,196,63,34,80,9,143,128,54,133,37,146,88,175,236,167,29,150,116,74,154,0,77,126,0,116,230,16,66,69,184,152,186,10,170,148,45,61,195,8,217,138,80,250,10,163,178,129,129,12,119,130,232,241,20,175,250,180,197,189,187,199,35,226,136,249,61,54,59,0,176,185,195,202,230,195,43,54,2,137,17,157,38,134,219,11,28,238,166,82,178,45,170,114,10,70,73,149,132,233,249,6,169,63,179,0,104,13,191,69,40,165,14,230,168,216,198,20,200,215,139,97,183,168,105,34,88,230,128,207,132,103,145,112,214,116,132,34,88,129,98,253,249,40,95,90,63,46,113,105,55,182,55,157,234,161,14,149,6,137,45,206,165,6,171,252,183,54,32,32,34,53,128,140,22,83,191,158,98,14,63,86,108,108,114,158,165,34,167,61,137,139,66,135,115,174,45,121,162,232,90,213,105,62,198,113,83,204,104,107,51,222,54,196,59,172,99,219,210,239,22,111,74,66,79,225,77,97,78,186,67,206,212,150,126,50,223,197,147,77,98,241,160,21,117,231,198,224,45,162,121,16,5,232,143,247,151,174,1,117,180,213,55,24,249,184,136,146,171,5,92,134,202,137,7,13,205,192,39,47,23,87,27,2,139,167,33,75,191,219,113,26,0,217,123,183,23,199,14,184,252,36,240,169,60,238,248,150,76,11,54,186,195,97,178,88,255,49,184,156,43,212,23,74,140,149,192,53,215,37,1,206,45,204,156,253,4,46,31,194,241,224,121,3,241,66,74,224,158,39,175,16,167,195,50,42,13,74,113,184,27,50,158,177,92,96,99,132,59,132,26,100,157,153,184,197,199,10,210,147,248,1,1,13,42,191,232,234,199,121,69,98,255,139,45,208,140,255,90,157,22,59,55,33,139,99,142,43,54,84,67,182,132,71,43,16,207,68,95,29,213,6,215,57,85,40,73,215,54,68,71,122,223,27,252,15,235,230,222,95,249,120,157,82,250,5,163,144,50,107,233,67,0,150,17,114,94,210,177,153,238,219,108,122,30,48,155,57,160,34,69,127,191,89,188,193,65,149,75,66,90,104,101,44,151,30,82,48,166,130,88,108,192,209,72,196,17,203,103,80,151,143,51,15,248,226,33,132,207,87,10,3,142,74,74,86,11,77,64,40,153,34,150,48,173,196,136,47,88,25,18,210,100,36,243,24,98,10,133,190,233,56,96,110,190,36,155,179,101,129,249,187,245,209,180,31,108,155,126,112,198,232,121,3,29,134,74,78,108,66,122,136,35,110,30,55,114,121,9,73,125,78,2,171,72,98,158,241,1,97,51,147,153,243,62,234,41,79,59,151,88,105,139,28,22,17,32,75,68,174,8,11,157,242,140,13,157,61,94,70,136,163,146,8,44,182,38,13,183,88,228,198,190,78,149,88,248,17,136,210,16,172,59,62,79,11,164,13,81,102,16,249,135,187,198,44,196,16,193,210,189,193,176,207,13,0,12,220,93,26,139,116,95,136,117,32,68,232,179,117,27,233,11,180,152,252,144,251,63,49,153,171,119,245,9,110,107,110,231,95,155,236,45,39,233,201,163,123,243,71,169,248,217,83,62,250,185,63,227,151,148,60,208,45,27,104,149,74,204,40,231,93,109,87,118,71,64,151,252,245,166,76,247,248,141,26,32,229,65,169,218,190,130,86,199,103,33,230,166,32,2,235,156,17,21,149,11,150,249,250,47,251,227,84,16,118,189,128,146,185,158,254,5,77,27,104,89,27,217,28,107,68,198,131,158,9,254,218,177,253,119,191,13,201,12,72,45,135,150,67,61,49,192,79,104,111,168,104,78,219,46,176,205,31,24,238,155,78,122,0,223,10,69,69,219,105,195,44,212,255,83,59,216,45,47,75,200,21,63,140,249,82,157,187,223,81,226,120,6,238,129,194,37,48,249,61,246,121,132,223,20,38,157,133,218,251,183,226,208,162,240,191,199,223,140,87,159,8,231,108,56,199,247,198,216,72,151,208,150,157,199,243,202,218,254,65,24,106,184,128,194,141,206,253,112,170,140,208,36,213,12,250,172,85,119,197,194,109,75,68,150,157,194,158,199,161,46,74,125,143,112,162,210,60,175,209,36,92,163,226,0,14,140,195,42,156,101,224,218,66,121,9,163,179,37,96,60,245,117,217,16,126,155,228,206,44,84,110,177,56,64,165,161,51,127,133,160,12,95,225,189,8,176,10,174,102,128,143,69,212,222,77,80,178,14,79,70,242,21,22,149,113,227,72,151,114,180,2,195,58,25,98,190,188,243,15,191,48,34,195,101,252,159,119,240,81,174,156,221,115,232,148,204,118,227,247,19,49,0,99,252,6,204,236,107,208,24,230,113,64,177,243,173,211,160,25,76,99,30,0,119,13,132,255,109,9,86,229,51,235,246,189,41,32,99,64,9,222,180,207,112,167,55,46,72,101,142,122,1,75,19,96,78,12,155,28,8,253,27,1,157,167,189,224,144,217,180,41,182,50,225,129,163,145,35,124,209,41,11,225,248,40,136,165,255,124,247,162,232,47,51,78,225,193,166,113,254,85,164,85,4,248,177,46,190,197,250,223,51,99,222,55,16,192,45,49,77,45,132,76,248,62,31,221,26,155,171,115,74,97,220,165,117,98,44,202,39,173,36,212,112,189,164,218,168,51,38,79,200,165,39,5,63,244,214,28,100,142,254,53,87,23,186,124,249,178,139,59,193,125,131,131,224,131,211,67,79,214,153,69,74,155,241,236,39,42,38,53,84,74,211,107,240,55,1,209,88,174,169,235,176,150,101,234,175,44,145,54,121,116,150,184,201,242,106,216,182,190,152,121,201,215,213,100,132,204,233,72,227,189,39,96,26,99,243,22,125,154,59,144,224,86,149,38,92,68,226,47,227,19,174,106,191,205,137,95,190,111,22,155,202,211,12,61,127,246,65,240,133,148,170,94,119,194,22,111,31,155,242,161,30,50,34,210,36,198,63,246,239,13,93,91,47,196,176,199,56,248,3,53,105,9,93,186,37,7,255,7,160,197,201,88,139,167,11,8,97,153,226,208,221,51,86,86,226,175,208,109,85,137,165,181,172,113,16,10,3,193,138,59,234,146,45,16,199,62,111,223,8,155,7,38,183,4,73,205,74,98,159,209,6,66,42,117,197,125,190,2,93,28,233,234,248,221,147,129,216,196,89,52,106,53,17,2,152,223,118,18,252,15,150,38,150,124,114,128,185,33,98,185,204,94,193,2,186,100,120,160,51,122,52,204,231,134,134,138,210,209,130,8,252,253,240,188,176,72,130,51,19,27,242,98,143,204,159,14,35,5,203,174,48,244,193,154,27,83,137,15,125,1,254,1,85,97,155,221,116,211,91,97,250,209,98,93,172,77,75,119,96,165,247,149,78,221,160,41,228,153,255,216,123,68,211,197,133,144,187,33,110,10,159,133,152,190,199,248,173,112,91,61,214,132,98,67,238,250,29,129,123,222,120,85,251,32,124,45,167,59,84,229,103,246,83,33,15,4,117,50,100,168,1,82,96,161,186,29,136,72,54,218,72,170,58,88,159,82,215,28,154,15,21,7,112,165,19,21,231,28,205,145,29,1,110,239,219,17,179,119,187,28,89,178,198,187,111,31,128,240,80,12,176,188,79,202,65,83,67,204,97,43,11,175,119,39,162,89,41,49,213,2,149,60,18,199,59,190,84,214,29,16,84,97,99,81,42,214,223,31,229,29,1,17,48,239,113,34,111,9,217,135,30,38,72,44,179,21,67,20,28,195,89,194,135,132,42,204,93,112,79,207,172,208,151,147,96,25,112,146,77,70,22,233,124,98,183,35,59,194,62,81,37,40,132,218,232,160,214,91,167,192,95,63,227,96,7,154,221,4,121,230,244,196,232,92,231,117,178,44,63,34,91,120,216,197,12,144,70,30,112,68,31,169,110,43,185,90,178,113,136,220,27,75,183,81,100,91,14,199,211,0,150,184,50,172,90,60,61,2,35,142,63,67,101,199,131,204,148,101,46,252,142,235,243,239,214,49,151,242,9,217,102,22,4,14,189,159,201,40,28,79,196,17,55,164,227,95,14,200,255,15,97,253,45,55,22,69,148,209,86,244,224,225,26,113,131,19,190,35,155,94,130,5,61,137,215,119,94,189,106,124,27,179,92,78,46,88,190,135,46,216,199,99,194,142,184,53,86,33,123,125,35,135,9,43,237,59,51,134,134,159,231,236,212,161,96,153,32,82,219,159,84,254,145,211,139,29,236,189,42,245,135,71,56,92,129,129,116,132,213,21,36,238,9,61,170,145,102,128,123,28,50,137,223,123,61,137,39,43,105,3,137,89,17,192,197,98,214,132,243,235,61,183,183,119,55,95,230,204,208,160,157,151,57,64,203,213,125,32,128,127,12,223,183,78,194,158,142,78,148,47,244,249,163,236,153,57,199,158,155,215,68,214,102,96,47,117,169,207,2,226,80,38,111,122,21,223,73,201,233,23,195,19,193,153,126,197,249,66,26,35,126,222,98,30,164,146,237,115,48,85,127,184,165,4,124,217,45,199,150,236,172,218,198,76,195,206,169,186,185,129,219,205,157,215,220,12,139,68,156,110,7,146,0,203,230,214,218,139,157,160,206,16,248,204,129,29,241,202,14,115,66,124,21,38,136,251,58,28,199,172,60,80,127,224,201,180,189,27,140,235,163,212,20,115,158,116,194,101,42,93,80,155,102,155,222,184,147,24,153,232,19,132,17,130,163,8,215,242,162,117,28,89,174,25,71,72,123,39,211,68,141,101,33,103,173,118,189,227,117,149,229,113,219,205,93,170,185,237,250,60,39,32,255,129,147,80,141,8,130,220,24,133,86,133,63,66,145,74,54,240,186,1,100,24,159,153,12,25,237,203,208,239,203,157,179,6,116,121,5,210,220,103,42,175,109,203,148,241,56,93,50,125,146,98,123,60,49,191,136,249,49,145,134,182,45,22,253,171,0,214,90,144,25,238,243,140,59,89,24,153,160,14,9,3,69,255,32,171,89,228,60,152,162,238,68,215,196,61,223,19,49,43,24,198,224,251,215,175,94,150,45,186,18,29,192,0,92,154,121,94,11,72,62,155,204,139,68,229,66,129,193,143,168,100,18,71,93,120,202,64,91,52,182,190,136,75,13,107,99,156,59,228,161,132,247,91,196,105,102,14,154,126,60,241,156,94,168,150,165,145,32,172,216,152,139,187,128,46,100,248,178,13,174,136,38,22,206,13,169,76,60,114,14,80,23,156,211,38,95,179,79,189,247,92,166,22,158,170,42,53,250,182,88,166,114,213,133,78,9,32,7,222,177,229,44,153,147,117,28,29,246,39,245,215,90,109,74,241,189,60,221,41,112,147,135,13,61,1,153,218,225,212,121,248,229,88,0,105,219,133,111,187,11,105,136,27,17,115,119,167,153,8,18,243,179,196,61,69,16,3,73,21,129,201,242,57,230,200,166,38,66,78,239,28,4,45,132,9,164,217,233,126,235,50,189,151,142,72,77,138,220,111,159,73,221,17,140,13,138,218,69,117,32,191,148,26,234,233,238,53,141,238,139,162,235,36,213,42,169,183,180,164,43,64,195,128,22,36,83,216,13,53,42,4,156,85,35,18,5,106,52,144,113,107,74,21,155,28,64,38,99,84,50,131,123,95,114,139,6,73,237,116,142,237,253,191,184,221,157,115,45,110,79,13,214,195,83,27,223,116,152,177,249,254,77,61,237,24,197,166,227,200,131,108,99,105,48,179,73,90,234,215,167,41,43,113,120,139,226,118,255,82,145,95,107,141,197,159,221,70,209,163,114,183,127,23,145,111,228,56,196,69,79,140,128,254,136,172,139,13,194,84,45,151,120,106,56,9,160,137,60,83,103,57,229,133,58,33,219,9,121,41,95,137,193,199,47,167,131,215,33,97,184,228,205,241,203,137,174,12,87,0,201,194,91,242,18,190,77,68,176,142,193,158,62,249,15,225,217,45,174,12,43,39,199,129,45,157,96,139,187,185,71,143,176,254,22,152,12,53,251,28,250,56,6,242,69,2,158,80,85,7,187,23,159,163,45,153,126,118,23,167,68,129,174,226,46,173,130,247,163,45,209,235,112,231,32,117,47,199,51,216,175,116,50,15,100,48,52,113,154,77,145,56,202,213,203,118,213,130,228,69,1,10,126,156,74,41,14,89,166,49,72,137,23,230,47,203,150,31,33,184,15,110,53,54,248,134,50,242,18,83,72,33,17,47,65,89,2,65,200,140,13,115,25,32,226,54,209,254,127,131,36,83,48,115,172,116,57,66,231,166,30,254,221,30,33,7,133,113,21,196,6,75,207,48,27,91,167,75,163,54,216,147,4,41,210,55,24,2,114,93,239,90,61,64,252,237,184,255,139,123,218,76,128,151,90,210,212,181,227,144,127,34,81,226,125,232,131,78,230,52,10,162,229,91,194,23,223,147,54,122,77,76,134,147,82,234,199,44,105,83,249,201,144,155,139,242,232,215,129,72,16,142,66,179,118,65,37,148,127,98,100,75,71,234,188,88,242,6,119,139,165,31,133,87,213,125,42,44,24,229,125,249,155,105,28,29,72,97,145,223,120,118,105,147,81,203,90,245,220,4,211,203,79,155,64,26,161,228,232,127,81,164,86,206,82,205,224,38,126,211,64,83,4,125,233,104,185,213,238,31,165,2,127,53,184,30,221,181,161,154,152,4,143,207,63,119,169,132,103,135,161,48,33,167,201,242,92,239,125,204,121,153,25,224,121,13,0,154,183,198,64,5,222,195,31,114,103,250,210,92,247,0,176,64,248,135,13,46,24,48,62,22,24,121,249,51,100,67,163,225,77,167,137,188,39,142,86,100,158,97,207,178,180,18,53,125,246,207,0,104,110,184,178,224,187,187,152,202,204,151,194,50,179,107,238,212,2,167,237,245,199,252,127,131,53,120,59,231,241,57,61,156,82,24,162,8,230,101,13,31,15,192,151,177,215,120,214,135,116,28,61,132,38,136,164,139,90,180,33,167,22,95,226,61,106,34,34,29,105,25,55,101,50,59,56,88,148,251,14,179,185,127,29,72,223,217,220,144,6,58,79,3,150,218,153,242,238,27,192,143,173,71,64,52,160,52,135,47,92,203,141,107,239,157,205,66,207,169,109,101,174,109,228,154,215,8,110,127,101,136,236,161,24,166,135,167,247,144,106,121,231,162,44,57,55,60,1,111,67,184,144,132,106,184,63,84,137,179,13,75,83,99,41,15,52,138,227,0,105,92,208,231,117,83,251,127,136,178,164,110,61,57,71,87,205,253,185,93,214,191,41,84,186,37,120,67,4,173,3,249,241,201,154,84,171,192,83,123,223,57,162,47,78,205,126,149,206,248,28,193,187,42,21,141,252,136,238,168,160,50,164,90,201,5,135,177,94,81,112,158,35,152,139,36,0,13,206,36,118,252,182,143,97,16,253,6,107,86,78,23,177,54,104,55,196,136,69,94,72,168,154,236,114,66,196,33,170,172,81,232,202,192,134,217,153,99,161,143,134,57,223,89,232,243,189,160,212,173,182,64,130,132,180,25,230,216,169,195,134,79,255,233,12,66,190,202,210,186,102,39,49,202,242,134,82,112,57,41,237,99,228,149,127,234,53,167,55,115,144,142,77,210,239,29,189,138,93,82,62,20,8,170,13,167,78,156,16,117,41,119,141,137,20,158,59,72,11,63,152,232,97,130,141,143,10,233,197,69,204,144,169,241,25,235,108,56,56,203,81,8,165,162,4,150,33,219,229,177,202,72,100,89,159,77,255,47,44,114,54,66,28,203,192,12,29,43,246,62,54,27,199,87,53,201,122,11,1,214,252,227,125,10,79,89,152,131,235,223,96,115,107,251,219,228,244,244,187,189,212,232,231,249,48,234,216,30,121,96,121,254,234,22,111,35,142,234,255,74,77,12,131,145,238,248,150,61,64,98,224,19,158,94,3,93,3,84,198,124,69,66,30,30,114,213,85,225,200,243,11,59,136,98,16,189,114,43,187,149,216,63,133,102,87,212,68,42,229,179,217,34,102,52,88,115,84,20,54,76,146,68,215,25,164,120,164,108,139,147,29,235,122,252,152,238,7,102,236,185,71,227,174,248,106,202,92,181,7,42,210,239,100,25,151,156,203,32,154,248,166,71,244,140,171,144,33,101,188,243,30,114,52,221,54,123,31,249,239,9,233,129,21,109,11,179,137,28,66,187,57,2,28,114,252,190,209,117,119,121,114,61,227,60,4,85,253,22,187,214,93,34,101,130,131,191,192,174,191,159,116,165,179,46,170,39,5,40,203,102,93,216,210,215,132,36,38,103,6,2,85,228,122,61,172,115,165,221,185,31,86,110,172,150,173,44,195,1,107,28,22,137,121,108,219,188,2,180,106,27,98,5,51,27,148,12,109,209,71,145,33,141,43,167,248,201,25,73,220,69,170,108,87,220,58,122,189,238,208,95,94,194,101,30,183,117,85,127,71,211,227,107,237,154,59,79,30,243,91,126,44,109,4,205,13,87,162,19,124,147,84,79,88,195,194,160,132,52,57,238,214,58,165,151,77,226,188,29,195,208,233,230,53,87,194,222,234,81,127,37,253,67,57,46,93,183,16,166,20,149,246,125,83,88,13,80,34,141,183,190,107,55,166,104,50,27,161,167,47,210,152,220,110,236,82,38,82,173,213,120,243,201,230,141,21,58,83,135,50,58,131,195,178,70,61,88,11,105,51,35,109,15,37,13,99,205,87,70,180,128,118,43,253,3,129,83,100,159,252,145,113,215,154,208,113,219,77,41,127,41,202,221,16,180,81,82,1,136,66,28,221,138,171,77,176,17,48,128,106,173,131,186,185,240,242,248,45,99,127,156,240,7,220,95,0,198,83,44,194,113,170,80,111,234,188,91,174,249,104,175,228,240,144,248,89,235,251,138,218,137,67,79,187,241,67,234,80,53,120,20,221,98,107,122,87,39,189,55,24,175,6,80,125,171,144,46,9,167,255,85,171,78,158,143,39,156,112,36,98,209,143,80,79,39,109,133,243,140,89,123,29,11,51,71,141,41,40,112,147,198,174,123,48,156,208,104,6,231,227,3,157,102,116,84,110,46,248,229,228,15,159,13,10,224,160,103,107,60,0,126,104,44,91,112,213,198,50,206,243,135,179,190,180,168,70,251,81,171,131,105,180,209,214,251,23,58,210,4,164,194,145,12,8,238,51,200,218,243,37,18,56,165,171,156,89,196,8,0,28,240,191,19,186,74,34,90,204,114,21,198,199,120,57,103,104,7,155,165,151,21,246,186,164,206,36,95,117,5,31,94,121,254,211,24,253,99,75,45,50,101,56,220,233,19,163,96,143,237,178,60,133,119,190,171,12,53,111,115,60,81,207,138,244,163,125,98,158,110,122,191,23,224,165,155,36,63,243,223,83,162,147,184,23,227,189,131,66,4,146,92,121,221,112,4,225,239,255,139,53,126,145,196,15,23,199,57,154,205,149,33,236,154,82,24,15,160,95,12,245,162,29,19,146,179,215,83,153,138,22,4,83,159,34,177,219,252,36,36,240,166,149,206,246,232,150,20,215,96,190,236,229,68,71,100,7,67,63,13,193,100,109,80,88,137,253,66,139,13,177,77,150,242,238,108,230,51,138,194,110,238,248,66,47,69,74,227,107,216,10,199,141,134,197,237,71,69,50,126,215,151,93,45,250,196,44,22,53,82,82,123,6,73,2,153,63,105,54,49,24,18,191,150,201,66,117,172,189,5,79,90,34,82,246,89,197,0,165,132,19,113,106,205,141,134,143,242,15,215,198,228,145,188,120,63,151,197,31,169,123,6,178,123,137,52,162,225,164,158,96,228,40,125,235,186,83,125,84,93,27,69,246,190,213,196,252,113,2,101,168,73,96,49,69,20,45,152,22,191,90,193,72,201,216,122,73,28,101,108,160,48,104,100,104,247,14,139,57,216,97,33,86,43,37,103,19,173,187,194,99,188,51,134,117,206,129,148,94,154,121,28,6,147,171,209,122,50,229,40,63,169,212,201,70,137,251,26,155,187,191,51,175,97,133,171,184,251,65,189,162,102,200,130,8,110,240,194,110,108,24,123,180,0,191,56,147,215,31,26,222,56,202,68,206,35,245,207,244,239,59,18,197,95,153,229,134,176,252,174,205,200,208,25,166,92,62,222,22,238,72,144,207,46,225,151,24,9,43,142,58,61,242,191,234,187,9,117,113,13,105,115,131,236,105,52,219,217,86,200,1,114,208,7,19,23,7,207,97,19,22,10,76,15,69,123,10,101,159,9,106,174,169,119,154,143,161,151,102,26,45,207,109,29,214,246,116,224,248,173,22,80,114,99,33,217,28,3,160,166,120,85,181,214,216,55,8,4,27,114,44,129,63,32,101,76,10,194,132,57,146,90,192,254,17,142,86,37,80,152,192,215,94,57,105,19,79,91,100,132,236,213,194,136,125,185,10,234,96,199,141,102,251,26,225,199,77,149,175,96,75,47,196,253,237,158,32,74,186,168,87,204,80,65,88,131,11,204,173,165,29,153,75,69,249,96,88,236,117,219,105,150,155,14,175,114,63,141,116,133,28,246,28,194,149,205,169,131,57,106,41,60,107,133,56,199,119,255,81,122,116,29,17,67,252,129,37,190,138,252,186,166,103,159,17,249,146,215,110,178,193,51,94,78,125,62,85,157,163,108,161,147,108,162,205,241,204,253,13,70,176,176,185,196,18,21,98,58,67,148,131,35,237,172,213,101,159,138,203,115,83,215,232,44,246,37,186,236,91,92,106,61,82,28,141,107,165,182,31,40,7,158,133,29,226,128,109,126,182,253,254,118,180,43,204,101,58,111,45,25,198,43,229,11,230,5,157,13,227,10,215,130,56,231,43,16,13,182,210,31,133,37,145,74,60,33,0,211,45,50,23,151,178,107,93,107,117,92,184,206,90,155,13,161,218,20,179,178,217,91,159,91,196,129,12,84,104,200,52,226,255,82,205,168,105,65,79,228,150,136,59,60,23,2,250,228,82,37,118,16,31,26,65,52,82,97,204,5,64,243,218,174,208,212,251,95,169,111,149,193,54,175,43,24,26,141,144,156,230,132,226,36,197,16,234,104,58,108,63,23,167,205,210,166,207,162,119,215,135,3,162,198,177,232,104,209,229,131,209,26,31,190,174,55,157,40,133,210,63,138,32,77,254,54,205,217,116,240,95,80,117,231,24,65,77,238,234,23,102,224,109,50,51,95,161,0,244,247,202,222,2,66,58,187,221,136,122,65,90,61,131,175,114,66,242,13,14,184,215,123,74,51,0,102,149,69,233,24,100,87,20,104,12,74,54,230,172,6,25,137,31,32,176,12,91,115,54,73,12,196,2,214,242,105,251,147,69,189,156,79,225,44,15,32,157,213,200,7,30,34,142,96,79,151,19,63,174,152,144,71,87,80,99,0,33,182,201,47,73,52,22,40,75,11,199,21,100,36,54,123,44,95,255,229,59,157,85,17,201,130,20,82,103,247,193,106,51,183,140,199,237,168,136,113,202,53,3,143,3,17,241,135,173,140,3,217,215,39,209,84,178,67,50,204,64,51,31,122,116,136,33,77,31,44,190,237,106,60,120,85,245,247,45,54,129,244,132,235,215,42,88,135,20,158,47,225,56,234,209,144,249,88,81,187,160,246,160,3,109,69,167,74,9,99,227,195,45,90,119,19,123,44,221,141,120,113,197,13,24,131,199,51,87,78,235,115,70,112,89,52,139,10,253,152,147,103,202,87,23,132,89,219,164,170,143,55,29,30,67,207,241,84,3,209,194,113,75,126,145,56,201,63,107,16,120,85,167,156,17,30,239,225,1,66,68,234,6,100,167,3,98,64,41,125,95,155,145,85,156,131,131,0,253,23,249,120,200,107,158,124,239,115,49,63,7,169,195,49,51,119,255,33,223,56,27,161,97,144,120,208,218,158,246,250,204,159,146,232,241,221,248,114,170,45,153,75,156,252,229,213,182,168,89,93,98,108,246,105,36,75,37,8,5,93,19,95,184,178,75,172,146,9,196,142,237,36,103,220,126,214,92,127,233,98,171,132,1,222,179,29,81,85,12,40,29,251,73,32,109,228,27,134,19,115,16,85,168,69,87,8,93,177,61,154,226,9,203,241,90,175,7,134,16,5,247,81,196,240,207,240,84,151,188,243,172,189,155,147,74,40,78,94,25,203,17,88,47,200,86,244,242,43,74,91,119,5,157,179,166,174,1,200,89,31,242,171,233,60,123,236,156,242,117,144,154,133,164,82,132,32,47,231,213,159,252,6,65,226,148,195,195,144,209,230,23,230,226,95,21,10,193,48,89,253,139,159,182,166,236,18,127,94,117,231,95,210,130,151,35,99,90,2,177,190,202,168,150,14,51,229,79,194,161,183,175,91,231,116,240,6,39,54,161,66,12,210,245,17,14,15,152,166,230,68,183,180,38,211,161,86,45,64,8,163,77,131,25,203,35,200,106,194,148,187,97,216,229,208,61,123,106,168,33,226,23,243,24,55,11,76,88,29,251,254,86,110,230,26,230,13,202,178,22,66,209,231,9,163,99,231,39,219,194,177,26,119,148,123,204,87,186,127,8,93,140,189,97,156,195,243,1,231,181,160,88,65,66,157,180,253,5,214,63,131,112,251,162,103,45,253,174,27,68,28,168,158,243,249,137,111,13,127,200,153,43,173,117,7,15,79,29,42,220,177,168,230,86,186,129,120,142,206,113,160,211,228,83,232,158,238,62,201,116,51,234,146,131,234,211,211,217,86,98,107,112,221,248,135,90,152,149,53,182,177,226,191,76,133,12,107,239,24,136,62,84,49,87,137,116,1,188,120,206,98,155,49,223,112,9,51,60,104,46,204,73,133,174,166,109,77,26,147,172,74,173,56,233,236,37,152,109,57,248,125,128,126,154,111,5,110,63,61,133,7,79,91,229,37,162,162,4,204,9,248,223,83,130,233,156,81,228,234,183,108,25,84,6,41,157,14,192,221,188,221,101,196,187,0,175,253,151,35,23,28,166,27,32,23,64,32,86,58,131,129,149,220,166,235,21,165,253,235,249,165,93,181,89,198,158,54,106,47,229,50,191,131,30,104,61,115,239,57,52,201,5,4,208,183,72,166,29,194,203,112,32,8,68,237,106,212,215,245,75,28,148,215,236,28,184,140,184,70,192,141,242,246,192,85,11,60,66,244,41,52,90,2,243,93,221,193,22,66,29,148,233,76,236,249,220,12,2,72,77,48,85,144,15,234,171,180,80,41,97,221,98,214,141,199,10,11,16,160,47,61,57,79,99,89,7,170,252,142,23,240,243,117,223,194,74,145,244,48,222,110,97,12,105,183,228,79,155,190,33,90,172,195,62,69,13,120,208,65,247,249,171,171,189,66,146,8,122,94,136,39,40,7,123,38,79,76,130,208,86,51,50,52,231,231,188,207,188,0,6,146,125,137,13,202,36,45,176,47,151,27,70,217,165,1,252,0,118,202,166,108,188,27,104,195,36,77,1,62,125,87,16,130,3,205,216,90,41,144,20,168,46,136,111,121,35,0,125,242,50,157,79,120,27,178,214,30,68,0,219,55,114,155,225,173,5,199,165,42,49,217,5,116,211,112,1,173,213,34,42,88,48,159,67,191,133,29,58,85,106,39,127,152,60,82,138,131,12,1,131,29,180,211,252,250,170,52,144,17,60,103,175,160,19,107,129,176,145,205,90,92,234,138,208,39,139,195,245,253,22,59,193,192,101,219,86,38,90,45,234,175,46,125,1,78,191,200,84,171,176,43,196,180,15,132,72,30,226,46,156,229,24,57,49,116,9,86,181,244,228,70,177,13,244,3,87,1,219,232,80,5,139,31,219,163,88,173,167,0,13,20,255,49,8,202,100,48,76,191,103,208,35,170,196,215,32,209,243,170,43,227,29,74,71,253,87,246,188,237,148,121,56,233,226,179,7,14,248,6,186,142,99,209,30,247,194,115,65,130,188,102,225,159,38,56,247,97,77,121,4,50,249,220,100,149,23,216,18,120,36,44,111,161,44,129,21,108,143,102,92,241,202,148,96,73,184,236,50,217,73,61,185,143,67,33,14,41,88,235,207,55,119,166,15,44,252,245,146,177,241,170,115,43,40,241,223,191,193,46,188,58,23,26,171,131,116,187,28,224,211,90,190,158,225,163,245,52,80,245,150,92,36,195,199,10,115,143,68,194,103,99,75,151,193,160,113,219,46,131,210,169,240,25,207,185,179,59,57,121,167,138,129,94,27,191,16,193,197,85,218,96,222,93,220,208,0,159,43,204,12,237,67,204,111,17,13,94,62,177,162,250,54,152,23,102,202,13,98,184,168,160,223,48,137,77,71,72,221,76,209,134,89,252,245,63,163,218,96,69,102,250,72,94,22,209,203,106,91,238,233,199,103,236,227,144,212,187,193,89,179,60,217,162,159,36,182,131,66,14,224,185,80,230,90,67,82,189,64,124,17,147,23,20,188,208,153,227,68,105,110,196,70,197,6,15,98,120,160,237,119,144,245,125,139,71,2,213,94,133,28,71,73,155,50,218,69,196,34,55,241,40,99,159,204,218,194,249,190,95,13,12,206,140,60,237,37,101,243,85,198,24,137,44,196,114,145,241,118,250,74,64,195,157,73,128,192,39,122,79,226,166,165,196,5,93,174,126,121,124,224,254,107,29,187,88,191,252,77,24,57,104,65,130,129,218,160,235,168,113,168,28,190,93,98,95,252,203,187,240,155,10,124,98,209,188,219,123,61,78,112,37,4,107,216,98,90,102,135,28,75,178,107,70,77,177,120,10,26,76,199,144,146,81,146,53,9,7,61,44,81,248,202,13,124,34,73,40,217,100,223,252,19,106,22,70,43,185,45,101,166,215,5,246,185,102,205,84,113,79,27,151,28,149,105,114,233,119,146,236,103,131,225,78,91,141,78,194,83,216,84,248,84,61,226,231,190,84,195,227,177,116,254,204,23,199,197,185,213,28,113,210,182,45,50,161,232,148,254,253,8,26,80,6,212,33,137,46,11,253,245,243,236,130,204,238,60,133,203,191,215,56,182,131,49,115,94,51,232,251,165,172,26,248,93,197,45,219,143,84,34,216,88,79,187,155,158,91,73,132,235,116,166,202,92,106,196,118,220,106,147,108,67,95,4,123,17,112,182,38,77,183,51,112,117,155,136,139,89,179,16,53,17,179,174,214,184,118,15,45,200,163,245,46,147,39,183,151,232,44,112,51,200,8,126,68,79,154,209,44,179,83,100,239,46,185,132,62,216,72,31,90,57,175,243,158,46,139,101,146,230,5,40,164,3,2,126,69,24,56,94,126,248,54,182,32,9,127,90,241,132,80,229,187,14,39,73,9,84,52,70,163,239,22,248,99,175,186,215,0,247,60,145,240,155,211,188,198,43,84,117,128,40,248,35,65,172,62,86,228,204,217,20,95,252,167,37,160,233,135,214,30,221,139,95,149,122,109,164,35,29,57,53,59,102,208,71,99,113,168,194,38,126,33,252,147,170,168,47,242,163,58,205,68,52,185,18,67,252,74,117,222,49,27,204,232,184,197,66,161,87,23,44,241,238,176,63,115,204,144,156,100,241,94,37,143,67,72,82,152,95,241,105,175,170,99,197,132,230,239,65,19,90,194,222,66,118,119,0,153,38,83,225,60,113,206,226,101,236,79,174,80,220,251,74,150,59,114,214,97,239,50,155,40,5,31,74,110,56,40,89,104,236,175,161,168,170,147,175,138,95,147,235,33,199,75,181,83,56,13,144,157,177,129,94,230,178,226,136,13,12,19,227,172,64,197,124,22,59,171,219,133,51,254,233,243,225,51,72,96,223,233,132,211,240,16,252,197,153,233,160,20,208,38,31,43,77,151,124,180,61,105,167,25,198,133,222,207,181,126,202,88,57,145,95,151,182,235,197,220,225,233,196,165,32,241,143,206,144,232,69,37,169,42,161,94,253,249,223,171,178,14,114,134,175,64,0,225,1,113,154,44,224,245,117,10,72,55,10,146,1,104,15,203,34,36,134,59,151,80,44,252,166,131,232,114,151,56,10,161,199,202,155,79,171,156,25,131,54,216,201,91,128,46,3,234,208,69,46,22,114,31,97,209,244,87,251,200,105,225,204,36,231,112,99,71,50,9,23,57,66,197,211,221,50,19,111,45,36,184,33,179,47,168,17,61,126,142,228,236,192,26,15,178,176,255,110,103,151,146,138,203,164,147,117,240,163,30,159,126,139,49,40,105,132,47,6,139,173,183,92,158,182,176,157,248,236,180,214,12,42,120,119,197,97,127,107,180,225,226,242,254,85,2,174,158,154,107,249,106,127,29,137,253,131,230,140,174,183,88,18,206,115,31,129,5,94,67,102,214,138,184,205,222,70,170,177,145,191,161,95,75,144,89,138,77,132,68,197,237,30,90,197,119,159,215,112,60,110,67,24,131,160,196,79,47,75,51,172,254,8,35,63,5,160,237,123,111,171,29,41,54,23,244,240,239,53,162,102,154,211,69,34,14,214,190,177,176,46,228,88,44,72,3,79,69,24,1,202,35,141,170,90,166,0,157,23,113,193,163,220,64,119,128,172,131,114,197,48,227,120,43,213,155,24,142,30,188,146,202,172,186,102,122,40,184,247,160,210,51,25,245,64,204,2,92,73,90,115,21,56,142,198,237,70,43,78,84,4,128,3,23,218,169,163,216,160,18,29,237,110,16,115,68,52,252,162,210,237,159,114,9,20,36,195,183,113,2,41,158,110,86,11,124,49,35,141,150,185,151,12,218,101,148,188,134,141,100,234,103,218,136,202,57,99,228,176,80,32,239,61,162,191,254,224,79,108,251,47,56,7,239,12,205,114,202,220,41,69,147,168,155,119,115,38,204,19,54,73,128,221,4,73,28,28,231,202,30,97,79,7,249,79,71,33,80,111,138,131,219,55,4,176,82,63,133,207,178,147,53,38,225,90,187,86,43,135,230,69,227,208,109,2,110,198,32,58,4,133,18,45,5,213,83,146,244,232,201,60,253,69,215,128,21,193,222,233,208,81,114,130,22,163,56,48,116,231,127,5,116,211,83,75,176,236,38,20,69,122,133,110,124,61,140,74,121,135,47,105,165,5,39,121,81,169,115,210,186,131,184,111,246,151,97,116,49,135,40,254,168,66,88,179,73,151,83,53,181,187,40,145,73,211,69,141,133,107,232,154,50,254,187,189,241,206,93,124,34,72,239,221,187,185,193,66,23,108,85,42,161,249,141,34,107,230,163,51,2,197,231,48,156,188,9,44,206,151,86,108,122,96,174,117,1,236,152,123,188,140,182,54,36,24,97,194,74,229,74,115,111,234,130,109,160,3,231,61,74,32,23,79,94,212,30,151,159,45,74,224,103,245,185,148,22,45,166,58,254,8,178,50,36,213,25,160,34,174,220,36,239,172,109,105,64,140,226,29,248,43,8,85,105,46,156,144,87,81,42,88,192,248,241,142,110,102,5,172,198,43,153,199,71,58,232,121,137,196,250,211,126,211,18,115,129,5,224,150,191,94,128,88,119,53,110,31,109,146,22,62,237,71,122,70,185,218,92,221,20,142,221,186,171,95,103,213,0,119,80,89,25,11,44,251,102,15,107,96,251,147,120,226,39,118,85,214,228,187,222,115,106,97,31,18,8,253,213,26,72,222,125,215,235,82,227,246,71,78,127,67,135,77,252,149,191,159,176,206,232,10,227,192,249,66,254,67,144,203,161,219,111,90,132,86,234,170,212,53,27,40,170,74,182,186,24,107,125,10,146,157,201,97,205,194,217,238,59,227,209,226,129,200,140,60,233,23,84,134,1,8,156,67,18,254,246,247,110,64,10,120,181,231,114,89,156,237,187,204,121,238,212,34,197,91,215,254,201,253,128,223,125,229,151,37,190,71,122,89,148,1,250,198,197,241,174,116,124,129,28,42,37,238,215,108,39,141,233,251,210,84,130,66,92,2,59,8,233,131,190,251,124,209,88,0,253,82,227,222,194,146,17,223,14,114,27,176,188,67,140,51,3,219,243,164,129,200,166,151,243,31,11,160,212,50,81,224,234,174,84,81,63,90,255,95,58,184,81,133,142,84,229,106,100,222,70,229,213,45,63,106,225,207,142,206,156,239,69,226,234,85,104,149,119,52,189,176,10,136,120,45,39,8,34,28,203,205,10,96,44,211,55,132,184,202,96,235,24,127,106,228,8,182,120,144,174,120,36,195,161,146,159,208,116,254,59,214,52,145,26,157,139,234,122,194,245,141,76,124,101,46,106,59,201,160,163,137,54,16,72,141,100,73,88,153,139,24,93,28,86,214,178,162,90,250,46,195,221,176,61,178,168,155,63,146,212,91,231,182,50,128,182,143,79,58,190,114,245,132,221,255,192,61,147,13,23,158,199,219,69,4,124,54,166,21,145,232,181,59,173,81,183,248,223,217,97,55,68,234,10,31,230,253,197,117,155,51,142,211,204,205,85,151,234,56,174,8,129,12,135,161,237,240,80,252,43,142,164,100,127,76,77,136,132,210,19,148,70,129,80,93,95,86,195,215,81,106,221,245,115,12,82,158,78,234,111,66,22,170,62,91,215,109,122,6,129,202,68,58,154,206,84,46,196,172,37,126,228,217,210,155,254,229,240,115,70,54,73,25,180,144,97,68,80,154,108,158,192,123,120,158,1,149,85,48,73,97,129,215,41,91,199,149,183,214,38,3,135,54,80,226,250,4,243,112,109,7,56,142,71,10,197,186,251,155,249,182,176,94,26,203,122,179,19,150,39,28,134,185,64,200,167,104,103,235,55,201,72,17,122,177,216,84,188,198,145,208,219,138,229,125,237,203,129,248,146,221,178,158,216,72,110,162,108,162,164,143,212,231,233,178,197,153,130,165,226,5,128,214,53,123,152,225,20,140,169,98,140,244,54,238,170,138,127,133,182,171,103,253,192,42,163,69,170,40,31,29,162,200,11,91,2,53,131,134,6,219,153,12,194,209,196,191,154,32,248,122,160,49,9,111,7,116,123,110,126,98,14,67,105,218,208,77,43,204,247,180,175,237,144,89,157,247,14,228,178,18,32,204,222,240,179,12,174,163,139,197,179,15,230,98,116,170,26,158,225,90,112,30,209,189,130,49,78,60,193,118,114,197,136,249,17,51,113,159,161,146,9,249,60,193,208,79,108,136,55,96,244,64,143,12,76,155,245,104,69,92,143,237,241,151,212,121,219,99,103,54,46,63,188,109,212,149,182,198,249,102,116,153,85,235,121,73,34,91,62,110,230,82,217,93,157,182,37,163,194,188,225,229,14,239,93,47,222,117,26,88,202,226,101,177,231,241,71,69,43,251,3,88,190,179,236,245,185,29,206,102,201,134,94,245,244,1,122,64,53,23,172,132,107,123,130,103,79,96,215,180,159,195,63,120,89,0,0,234,153,166,180,106,168,138,222,121,132,147,169,132,233,250,247,54,7,234,203,27,215,126,115,175,120,160,239,248,234,30,34,211,206,237,55,32,54,121,98,32,59,164,140,112,253,227,30,25,179,119,61,95,226,250,133,202,252,150,116,160,123,217,180,121,141,75,87,103,146,236,222,247,62,28,21,84,93,94,158,214,25,78,180,20,141,220,67,94,181,86,9,51,234,132,248,31,88,36,28,16,239,84,133,227,130,104,42,56,125,90,244,118,161,101,61,242,51,189,248,175,184,191,133,48,22,82,230,131,195,236,150,178,251,109,90,125,246,202,112,158,143,89,89,17,199,56,163,79,158,97,239,177,184,110,246,81,229,25,92,87,233,221,225,215,147,1,82,26,245,87,54,209,155,70,42,200,68,50,168,209,15,88,181,160,58,86,226,195,191,95,131,240,51,239,26,235,203,130,34,240,148,195,168,30,59,233,116,87,171,54,225,227,81,177,49,40,27,189,196,93,162,169,156,62,175,236,184,60,59,251,106,76,12,51,125,14,142,232,90,36,121,128,53,123,183,154,186,31,90,180,165,221,55,172,173,42,227,216,47,59,37,54,58,254,135,210,126,163,163,43,13,99,64,82,135,23,233,235,126,255,242,36,146,135,1,4,161,118,4,67,254,249,182,39,12,53,187,17,203,72,255,58,144,19,252,238,207,209,32,123,189,125,225,252,222,98,146,103,19,10,38,232,209,119,139,120,164,99,93,44,181,45,15,166,40,247,241,57,100,218,136,204,236,231,190,126,13,55,177,25,92,41,150,241,105,113,52,55,139,62,201,149,99,60,65,77,255,25,78,28,155,120,193,102,89,157,28,18,218,243,222,231,70,174,124,12,211,134,202,42,214,172,233,230,91,197,119,90,130,176,16,250,171,98,196,29,88,172,65,124,217,186,158,43,199,29,47,41,129,189,141,199,32,73,126,174,75,49,186,236,114,23,17,108,8,249,36,115,47,55,29,170,241,169,254,195,23,22,23,119,180,43,77,69,138,5,9,55,138,84,147,255,77,196,58,24,236,60,217,207,217,122,46,165,111,100,200,188,197,171,55,49,131,216,54,33,224,244,71,173,135,117,166,239,250,60,14,68,240,192,230,225,87,74,63,255,27,99,151,5,238,185,178,28,53,238,91,146,72,107,109,4,37,40,223,14,87,4,73,147,253,88,207,107,115,81,199,142,161,195,79,38,5,236,141,185,106,138,32,195,23,56,39,224,160,85,237,79,157,208,93,119,76,234,149,171,12,67,24,98,8,134,213,153,148,6,231,55,103,22,138,11,181,11,22,59,58,252,176,70,249,46,141,111,209,233,95,39,145,55,169,105,84,117,183,196,47,252,111,82,170,3,61,132,7,219,20,20,102,53,253,26,24,171,158,250,244,40,42,76,131,242,141,198,45,246,5,180,252,47,84,209,107,227,185,206,71,65,44,103,4,109,136,168,40,217,93,107,143,114,41,83,151,180,224,33,25,123,7,52,85,91,225,6,74,139,127,97,218,94,107,221,13,130,22,75,197,17,185,244,203,234,216,124,14,150,9,138,41,56,5,132,10,84,56,152,21,162,50,252,170,40,176,230,198,222,110,177,57,102,68,203,19,12,74,251,96,27,152,45,141,236,200,132,80,72,186,151,35,183,149,160,34,186,167,243,122,237,188,173,188,35,40,170,9,98,35,173,157,172,140,53,120,129,204,177,165,0,146,80,172,133,60,178,87,108,238,176,200,126,117,172,225,118,194,156,13,151,163,11,12,178,120,155,150,171,219,196,11,5,91,114,219,212,172,127,22,247,240,31,100,44,146,176,113,195,220,154,48,135,227,204,145,10,72,66,139,211,102,172,172,160,167,1,242,65,16,32,235,145,93,124,59,110,178,101,29,199,70,6,147,251,109,238,223,252,16,224,141,190,126,208,9,109,198,253,54,27,147,25,113,189,49,208,185,105,57,111,201,88,110,101,76,90,129,7,220,8,137,177,150,187,0,219,30,181,68,209,191,228,238,125,176,160,61,136,184,196,167,178,212,46,136,202,196,41,35,89,117,60,147,86,218,209,198,201,245,61,199,71,71,44,54,120,65,74,50,18,35,106,82,166,173,19,62,146,58,66,142,8,27,146,64,226,182,226,71,0,191,207,220,170,204,116,255,12,124,236,63,222,2,57,10,39,96,255,98,126,45,136,215,150,213,101,129,250,200,50,90,61,23,255,157,210,89,65,51,44,108,105,143,166,134,184,45,85,215,46,43,231,107,184,153,44,124,86,81,154,48,104,18,29,174,88,22,218,10,69,195,30,123,106,136,227,208,53,36,14,62,42,245,31,245,7,171,8,182,176,158,234,155,132,58,148,3,4,55,47,246,45,12,116,247,79,71,191,145,82,99,110,79,84,34,250,36,17,141,242,154,67,189,129,77,234,70,116,161,237,148,160,55,121,244,102,183,195,70,220,243,96,115,237,75,25,78,131,202,2,27,243,85,142,52,130,140,11,194,43,33,2,248,181,40,143,182,104,242,47,49,51,34,206,253,150,185,125,218,119,240,170,229,123,229,58,147,153,105,86,4,25,75,31,171,111,4,12,245,63,39,229,52,70,149,237,78,68,69,40,159,89,28,108,50,39,24,195,142,79,76,120,209,176,213,3,179,76,85,194,21,3,24,83,97,223,129,194,140,30,134,53,23,199,159,43,255,63,99,22,202,63,51,206,74,150,23,177,145,32,205,209,6,122,9,104,139,163,213,243,149,66,173,98,175,190,45,134,253,179,78,27,110,163,215,55,97,47,213,17,88,169,224,137,41,145,16,203,51,240,164,64,51,79,116,12,132,149,248,70,169,224,232,33,66,5,205,171,228,178,255,17,6,167,185,179,157,165,143,145,119,153,148,57,211,171,17,186,57,75,185,55,99,255,174,202,138,61,238,231,176,84,25,4,80,8,36,211,76,75,23,111,17,11,18,151,35,56,37,79,74,241,91,218,242,134,133,77,205,222,96,81,198,127,210,181,0,210,123,58,217,181,70,48,95,108,61,63,178,156,107,193,254,108,150,9,205,128,142,19,124,33,97,144,153,153,243,168,61,32,203,97,45,173,228,52,114,148,142,238,250,59,62,223,37,174,108,235,77,161,159,7,28,176,115,153,29,173,105,200,7,171,144,177,193,176,125,29,80,176,180,139,221,125,77,134,98,102,201,152,161,202,26,206,85,136,193,11,221,15,213,220,189,167,152,136,93,52,77,123,228,119,88,238,62,236,92,129,12,247,65,190,233,134,95,60,71,28,94,65,117,91,68,6,180,79,34,175,135,137,53,153,137,98,54,39,126,242,95,104,160,122,34,122,106,51,159,208,188,66,169,73,192,47,248,208,112,81,169,209,220,180,225,143,7,129,157,64,156,112,244,84,245,191,52,163,118,236,224,21,19,204,85,187,192,22,150,164,66,198,65,228,7,171,131,249,114,31,25,9,184,158,222,13,104,190,245,237,144,53,170,190,107,232,225,56,129,101,171,92,118,129,185,130,149,249,111,134,63,138,247,141,125,207,190,89,110,78,2,28,45,18,50,102,139,61,40,50,53,133,40,22,203,36,136,152,194,4,173,47,172,236,161,169,138,24,237,122,15,23,79,141,187,135,89,205,27,74,70,176,94,228,75,33,220,40,115,110,98,93,227,215,175,46,186,52,135,201,205,101,229,146,172,215,236,187,236,31,167,14,140,209,60,112,81,113,81,240,18,120,148,52,44,146,222,221,191,60,54,168,53,254,194,9,5,76,199,131,18,134,75,221,40,132,228,15,7,164,193,172,166,145,50,186,76,72,244,183,109,138,11,241,83,192,29,151,237,58,81,83,206,201,103,31,34,122,9,70,182,235,147,200,154,45,143,204,32,151,157,20,220,112,147,168,199,82,102,148,246,76,33,153,177,5,86,6,161,141,124,149,79,110,190,38,201,98,49,238,198,56,166,16,184,203,0,178,41,65,134,220,124,172,2,63,72,110,61,76,7,233,87,242,84,229,211,61,64,118,124,14,142,251,102,225,224,86,36,116,6,156,255,148,109,48,91,235,235,238,178,22,213,176,88,181,110,229,218,71,134,121,65,79,252,247,223,8,206,200,81,152,200,50,114,77,237,120,137,18,225,125,27,79,255,144,113,45,164,56,54,221,224,25,13,66,247,22,87,50,71,20,145,198,243,199,6,196,206,91,32,13,148,114,60,240,101,188,73,49,202,69,229,209,21,234,139,254,241,59,154,149,171,145,64,20,211,164,29,229,194,36,107,155,134,206,162,5,202,16,21,78,25,217,212,204,158,216,253,205,108,73,26,212,210,6,251,179,3,175,17,72,91,188,245,223,197,68,99,150,13,95,27,203,213,192,127,18,62,198,73,189,13,9,37,176,99,216,164,117,97,222,128,189,247,126,229,48,36,167,58,243,67,50,110,176,171,6,231,175,152,41,18,167,94,222,31,235,160,2,64,195,238,165,1,199,249,162,135,40,148,248,156,84,212,170,90,163,208,228,173,123,217,91,4,104,120,36,183,211,36,186,108,3,179,216,141,237,148,89,67,19,107,251,125,31,152,142,38,235,96,7,105,212,84,162,208,103,19,161,71,196,99,176,58,199,184,120,210,253,81,50,207,48,252,205,134,81,237,235,107,152,228,99,88,132,245,152,182,46,143,122,174,251,150,42,116,60,60,179,184,173,59,160,246,23,188,63,164,98,87,187,77,137,214,249,57,80,83,36,200,215,204,13,102,205,253,42,74,19,253,244,131,237,86,50,252,72,225,209,45,219,34,96,174,118,225,145,255,135,230,178,247,106,228,21,170,55,24,188,0,103,172,199,254,209,250,234,222,132,161,11,5,8,90,134,151,91,137,130,153,79,23,245,199,203,163,156,117,210,79,214,244,93,62,154,214,188,161,28,39,167,179,62,196,164,216,218,39,249,46,103,249,157,68,186,104,132,144,248,93,3,126,61,61,178,206,210,79,105,74,201,232,136,71,66,80,65,0,36,244,103,53,237,130,124,242,49,70,34,235,95,204,176,166,164,209,124,155,150,94,154,189,44,68,195,130,68,212,166,219,171,196,101,125,126,249,187,177,201,114,54,12,234,4,102,237,215,212,133,144,182,126,235,129,85,40,33,51,19,71,232,241,36,241,170,241,145,114,57,166,17,195,16,213,161,64,35,250,138,198,81,197,96,239,97,133,154,204,154,219,152,228,222,169,118,210,68,0,33,109,131,174,226,211,35,2,189,6,225,148,253,228,252,205,165,108,236,232,239,53,94,93,165,53,245,38,46,215,158,143,246,74,13,182,107,81,48,38,135,76,44,226,230,241,39,252,219,82,189,229,197,168,197,82,182,66,173,127,181,175,126,166,129,9,207,1,127,43,32,122,189,220,213,242,42,186,53,8,10,101,190,205,132,118,226,247,192,101,7,75,194,67,147,91,44,195,153,129,35,54,162,96,171,31,110,143,146,166,178,39,87,205,61,50,142,241,100,18,114,49,113,236,53,181,62,21,47,164,125,40,161,46,165,163,39,94,11,178,156,98,209,189,0,120,42,101,104,223,68,243,242,45,84,111,27,193,103,108,119,201,122,233,137,253,244,70,74,166,229,27,9,54,236,88,53,174,154,157,138,130,112,74,23,75,244,187,104,119,79,1,137,125,210,179,27,25,39,222,0,13,43,179,160,141,250,196,42,59,160,136,176,246,140,100,30,76,22,27,90,162,243,56,84,10,10,96,252,32,196,17,99,150,50,107,218,73,169,198,177,20,17,199,201,48,129,208,132,107,39,157,35,39,245,183,114,150,141,30,153,109,223,193,83,231,144,183,194,159,58,53,35,84,147,132,70,237,210,166,126,48,93,225,35,140,90,58,91,221,42,254,107,10,13,189,64,253,50,190,156,35,236,14,53,164,78,31,99,92,53,81,57,176,172,80,229,14,152,176,36,225,49,31,208,236,0,146,231,91,117,164,80,145,100,169,207,39,161,192,198,163,222,212,37,49,39,174,32,22,165,158,244,177,65,58,70,32,0,184,224,72,169,146,24,3,102,55,176,241,13,26,47,157,235,24,199,24,1,23,175,129,81,252,252,52,24,180,219,185,175,244,76,205,76,148,53,45,58,175,61,4,76,223,210,56,90,217,127,11,195,234,206,62,251,139,138,81,53,172,15,226,195,250,85,31,42,35,16,42,198,236,114,10,104,100,206,117,32,49,78,122,56,107,130,109,166,221,25,142,13,87,3,64,234,190,245,247,157,226,238,43,244,222,188,120,161,157,244,107,231,22,25,45,0,225,156,142,12,76,50,55,118,141,138,70,189,69,240,145,45,21,59,146,24,19,205,251,235,83,177,237,211,32,210,141,245,186,84,168,182,83,240,228,169,219,49,200,221,177,3,78,192,45,94,133,135,229,72,1,2,85,145,88,91,71,233,166,92,227,216,152,216,91,221,32,128,64,36,225,128,141,99,37,232,240,59,206,219,226,94,64,83,217,201,113,207,140,45,18,176,165,165,24,208,179,106,62,46,13,171,172,74,78,217,136,85,40,56,123,88,81,79,227,16,59,160,63,72,80,13,158,208,114,57,193,129,38,25,217,3,2,243,96,163,194,58,28,119,16,220,125,6,128,22,198,102,37,67,230,0,91,88,57,121,86,87,224,66,219,3,188,150,145,100,70,127,236,251,178,103,139,1,208,40,9,220,205,166,56,35,176,69,114,146,127,60,89,242,90,101,250,48,105,248,190,120,225,42,98,182,51,246,95,107,2,231,126,197,35,106,180,60,55,180,187,223,31,87,75,77,38,19,169,148,222,71,20,136,57,215,200,49,245,193,90,61,194,47,167,233,141,124,78,133,119,246,156,109,97,142,81,98,12,6,114,179,101,67,254,234,160,33,91,152,230,218,189,253,41,135,66,173,60,206,137,24,2,102,168,191,45,134,230,192,59,131,114,191,169,223,248,95,122,142,227,227,197,115,28,73,198,175,192,219,239,100,107,7,82,229,142,52,194,157,8,101,9,238,175,9,64,66,68,124,101,242,216,53,94,254,235,122,117,110,251,106,146,184,22,243,246,8,0,43,84,25,46,35,78,242,187,171,82,199,10,160,199,169,253,241,55,7,227,243,224,25,242,51,116,209,61,138,246,6,82,71,150,207,87,241,20,59,85,150,54,201,8,54,205,145,151,168,132,173,150,167,74,229,188,210,225,76,96,40,222,86,1,196,211,133,132,13,51,159,251,89,32,208,137,165,191,191,90,134,208,88,80,131,213,97,178,153,206,148,238,160,47,132,118,35,156,10,204,188,214,63,189,92,159,77,254,119,9,37,4,225,12,50,83,10,149,1,119,206,242,70,17,215,129,28,74,73,153,94,102,25,116,140,51,80,167,182,93,158,170,152,42,189,115,140,201,197,109,125,66,130,147,189,46,29,175,249,38,58,212,164,147,33,187,122,107,16,210,109,104,11,130,111,136,94,255,95,124,39,83,39,178,170,117,7,11,156,165,92,128,187,102,90,110,144,143,148,192,128,5,0,65,162,225,237,152,190,23,144,55,19,232,90,141,158,25,20,8,245,108,235,212,228,43,53,158,64,190,234,2,252,116,227,3,213,143,124,199,137,243,189,171,33,79,209,43,216,239,223,92,37,146,33,210,168,48,249,137,63,213,45,37,155,75,106,248,240,162,99,178,70,21,97,165,48,46,9,173,8,39,188,223,197,65,16,65,127,98,40,85,34,247,9,10,122,53,66,218,57,250,245,209,119,54,183,39,75,102,69,221,151,215,3,123,130,131,220,202,160,158,154,91,68,66,34,57,188,198,109,39,72,235,28,187,160,150,105,205,115,229,254,171,142,191,16,142,106,247,4,141,186,235,143,191,34,142,125,134,63,246,67,49,172,147,150,16,173,49,56,116,187,204,105,248,142,166,38,9,181,216,127,224,72,66,77,166,242,239,63,157,247,212,147,172,133,96,5,64,122,106,110,149,44,123,175,210,137,46,191,83,254,233,145,72,136,40,25,160,184,23,148,172,208,221,79,118,74,109,171,254,143,63,55,220,5,183,32,79,9,32,226,70,201,213,101,170,46,18,55,162,16,188,244,120,173,179,25,86,73,123,75,12,109,156,4,154,48,227,15,53,12,43,54,247,201,187,193,61,249,200,167,48,136,243,26,198,233,242,187,37,171,118,210,121,158,211,147,27,134,155,22,174,110,207,9,38,157,198,113,73,100,16,125,64,98,191,123,78,13,248,2,58,121,253,146,128,220,69,30,208,241,177,244,249,18,210,8,190,30,132,125,122,46,45,24,0,250,68,73,143,67,139,190,33,98,104,230,74,90,177,152,11,224,190,40,56,114,237,53,244,162,59,150,233,167,229,141,1,147,4,119,138,99,231,95,124,40,82,98,86,245,161,66,165,202,142,120,61,16,130,89,246,42,38,152,119,240,79,205,227,250,30,79,101,201,57,193,177,56,112,149,154,34,122,215,184,27,45,122,120,63,135,50,136,246,171,119,151,205,72,39,140,187,243,179,96,10,57,67,149,60,89,172,211,152,181,53,241,35,119,253,49,164,136,209,2,182,60,153,241,41,233,41,250,67,95,160,252,67,242,96,248,3,35,88,212,102,43,53,203,44,41,130,29,35,122,181,166,215,224,115,179,205,94,252,24,213,150,236,141,48,24,80,116,64,31,92,252,25,115,226,198,231,105,53,69,18,96,130,26,132,17,99,38,35,40,89,45,40,3,187,31,241,160,219,142,91,98,164,210,112,142,225,28,13,25,198,117,43,187,199,242,5,130,239,91,144,167,160,163,19,87,210,194,153,166,106,42,22,169,170,206,90,71,75,46,159,208,81,129,180,5,68,39,14,104,177,176,135,173,97,1,135,218,55,71,235,10,9,54,44,0,169,171,162,218,50,59,1,155,223,246,243,112,107,45,237,7,236,78,139,37,107,69,159,227,41,22,193,16,227,55,113,95,51,76,174,14,139,83,10,250,38,246,206,30,155,105,50,185,234,64,36,127,230,135,216,48,240,205,132,239,227,167,193,106,19,54,175,93,122,235,37,15,5,247,214,13,114,151,189,29,249,140,170,10,22,66,115,87,201,20,36,50,209,173,15,236,70,180,194,144,94,66,46,212,199,68,178,140,205,75,168,205,218,7,211,42,151,150,16,184,233,97,50,70,112,21,146,54,156,105,132,76,158,118,156,195,32,143,178,237,194,111,3,233,185,190,130,242,254,114,225,225,88,39,252,180,129,36,113,220,58,248,167,186,1,230,97,206,84,226,138,243,181,215,28,220,125,117,4,209,74,67,17,190,99,227,77,41,179,245,82,208,246,53,119,83,164,49,104,44,172,50,84,134,195,63,82,237,85,68,133,73,234,77,189,50,149,155,130,57,80,61,12,65,124,93,151,133,27,114,25,75,145,171,75,6,42,254,8,203,223,69,176,90,214,66,42,203,82,236,9,206,180,77,117,186,83,148,38,195,153,171,118,151,63,21,52,241,138,243,179,89,193,35,76,160,87,253,112,68,41,100,13,217,178,196,3,134,25,127,49,136,102,117,181,201,33,41,232,18,113,222,154,85,120,140,246,136,50,229,90,189,14,53,91,112,56,180,101,180,203,170,10,11,102,88,43,190,183,135,180,200,145,116,156,101,51,183,62,206,75,124,160,157,92,31,130,232,169,231,121,35,33,132,187,155,36,83,70,183,189,163,139,149,228,139,112,224,165,0,158,79,18,75,31,112,160,239,103,158,11,180,40,191,148,17,76,136,185,148,165,4,251,76,111,224,68,67,90,155,196,134,154,31,221,156,40,156,35,81,138,44,246,225,173,26,35,182,209,24,48,215,152,157,115,227,135,223,204,255,89,86,104,244,165,53,137,62,55,112,40,221,20,192,112,27,221,128,53,50,115,232,88,116,63,99,142,218,32,70,135,111,148,20,130,46,70,230,129,54,42,200,57,144,222,154,26,230,144,42,211,27,190,100,202,17,188,185,3,129,185,133,219,203,161,37,79,96,200,88,163,163,75,56,207,192,78,42,240,178,108,108,191,69,26,31,9,73,3,68,249,192,42,85,11,186,153,123,82,57,96,218,70,153,184,80,236,79,188,140,211,172,58,22,27,141,29,206,214,77,4,149,203,35,21,245,192,16,16,108,106,213,197,223,83,89,13,79,204,152,2,232,127,99,35,30,247,193,24,14,35,86,30,240,194,230,166,134,26,171,52,46,101,53,161,84,151,233,239,148,8,32,159,235,133,181,62,210,200,81,59,192,190,246,46,162,183,247,147,182,106,174,153,102,95,34,99,231,106,155,121,179,159,35,94,183,22,200,126,8,187,222,122,38,1,88,109,81,68,230,9,89,145,217,205,154,154,77,154,133,109,99,21,47,174,104,231,68,211,179,221,50,186,6,60,138,219,88,233,250,158,32,71,89,241,17,252,130,87,253,208,104,72,223,216,167,77,105,188,209,20,183,198,100,144,51,75,230,27,47,121,203,250,15,16,1,64,96,119,108,254,144,83,206,248,223,187,54,26,121,79,154,23,94,198,173,61,53,79,3,10,109,30,88,60,206,49,121,171,118,157,35,67,175,228,164,13,16,93,84,147,49,249,213,162,189,227,224,201,34,69,221,2,25,195,90,243,254,244,158,130,33,61,180,238,207,116,113,14,222,68,132,36,154,28,245,210,65,239,117,129,9,103,232,159,200,107,233,97,169,9,221,182,2,129,195,131,193,253,34,18,252,160,206,113,223,39,45,105,93,118,183,15,47,155,179,203,4,35,100,137,136,231,220,181,107,74,83,236,40,105,183,8,136,89,75,184,231,61,174,24,105,188,234,166,14,32,34,166,206,171,35,44,125,95,215,11,65,16,71,18,130,124,55,52,91,85,85,75,142,186,67,204,234,111,122,195,58,116,150,218,24,83,171,89,87,29,73,131,241,217,94,79,242,247,26,245,230,124,209,233,186,100,4,39,92,128,36,202,86,189,247,60,117,153,0,197,231,13,234,237,206,166,190,197,17,18,216,45,98,226,50,210,142,152,32,221,61,255,249,49,150,64,213,101,97,17,138,191,98,109,236,85,186,131,187,88,70,207,252,116,79,0,169,241,59,50,133,186,55,135,125,73,86,233,214,51,22,191,52,226,105,76,204,145,56,74,128,70,63,85,156,152,24,55,66,15,45,50,20,36,198,29,8,102,235,153,107,55,66,127,184,26,91,121,3,178,220,193,93,23,208,54,184,176,58,221,140,95,5,186,245,74,67,33,90,15,24,144,73,37,123,227,137,29,217,116,3,24,152,113,4,93,37,136,209,252,19,245,77,179,150,242,234,83,3,189,216,186,232,178,245,43,136,42,87,173,105,142,237,115,159,133,183,172,240,158,240,86,168,95,2,10,95,30,174,73,205,77,89,103,80,62,155,154,94,11,112,117,128,190,63,110,224,195,11,100,126,108,149,110,64,234,199,5,158,70,88,50,114,41,46,224,34,24,67,184,15,88,30,38,163,145,105,138,132,134,73,18,208,160,251,151,49,243,86,11,119,210,55,219,35,173,124,104,240,130,32,146,141,168,106,26,95,85,135,162,160,132,36,218,19,162,185,188,95,84,167,148,190,174,113,102,80,176,206,92,9,78,116,60,32,175,63,203,170,246,29,141,55,201,19,98,40,252,79,136,33,244,80,96,215,158,68,31,37,187,42,170,139,32,0,202,235,102,208,10,153,17,59,11,240,185,216,246,185,109,222,251,196,39,3,127,94,126,43,183,237,48,12,186,157,68,214,51,212,16,139,166,47,184,21,181,144,248,129,232,227,65,232,165,237,241,191,211,229,60,186,119,213,136,65,94,33,28,47,17,219,220,11,180,63,37,4,41,183,147,234,121,174,132,107,103,207,97,254,61,45,16,42,237,168,90,8,57,119,41,27,200,36,102,134,120,175,154,166,186,22,43,216,168,242,76,185,76,10,7,66,134,220,124,191,19,161,216,230,188,87,64,71,84,215,112,96,28,106,114,9,178,74,110,167,228,179,154,217,50,62,145,219,28,176,10,182,52,8,9,104,14,113,111,164,133,42,169,193,105,194,122,181,177,230,105,157,139,84,127,220,191,222,229,241,145,210,239,216,4,246,119,141,181,174,244,205,79,212,66,90,138,212,198,12,89,32,56,235,148,167,147,238,6,110,36,6,37,99,66,170,171,226,134,216,102,149,60,99,42,185,90,196,156,138,18,124,108,175,157,15,166,24,27,102,2,135,5,112,184,105,102,35,120,154,19,115,200,115,231,85,231,101,50,89,129,9,197,39,221,44,145,218,92,8,185,162,202,142,183,4,91,0,239,74,239,48,99,97,96,127,38,172,229,80,197,248,202,19,249,149,40,135,44,64,63,43,87,150,86,206,61,11,6,21,66,53,186,2,103,63,177,54,241,3,138,8,238,78,113,225,224,174,201,144,129,250,81,13,60,243,106,116,200,54,153,26,21,63,29,251,27,232,112,58,54,146,253,6,37,45,227,72,16,243,13,88,93,83,80,1,246,251,173,22,195,200,90,142,233,121,234,81,48,219,33,248,110,127,173,31,117,192,161,51,132,209,208,194,205,176,198,146,56,123,13,171,92,235,44,57,157,164,86,186,120,195,70,77,42,129,186,177,70,5,235,217,68,154,229,233,156,140,187,98,26,15,100,9,237,227,90,114,221,228,190,105,50,129,167,108,141,174,205,193,198,248,75,55,46,178,93,9,60,73,106,247,244,176,4,104,46,229,51,97,108,43,67,165,53,241,141,75,242,213,191,159,155,131,213,178,2,29,205,230,21,210,21,66,80,63,227,163,17,215,142,62,153,23,42,173,96,6,1,230,66,238,84,36,103,60,94,11,255,157,202,97,73,196,170,213,122,118,240,221,112,165,141,77,218,199,86,6,129,236,163,179,193,24,26,205,232,70,209,72,245,71,233,25,152,161,197,53,6,233,21,30,3,116,68,82,20,248,77,15,47,31,76,103,167,193,66,222,115,67,33,69,4,49,54,233,129,242,62,202,4,135,119,76,159,222,232,220,191,128,39,41,150,145,17,119,184,40,212,165,33,168,159,228,164,170,248,239,241,29,151,61,83,153,41,168,97,83,95,240,100,36,52,168,183,26,191,178,85,18,0,45,9,168,189,152,78,47,250,17,40,194,134,44,201,141,155,65,167,214,106,255,251,212,197,85,48,204,116,85,139,201,77,67,145,234,181,47,77,93,91,47,158,158,190,11,251,217,213,230,198,43,146,40,138,66,53,79,15,156,216,34,55,164,43,221,155,21,168,44,168,195,246,118,211,209,85,213,76,197,194,128,191,141,10,76,86,238,214,21,103,72,57,186,181,149,173,192,23,125,170,77,109,173,150,215,251,78,127,149,125,12,255,118,238,161,111,254,155,67,33,176,253,86,21,232,36,84,241,215,181,44,245,60,235,42,227,168,55,177,203,69,125,49,187,46,166,143,165,190,64,110,170,69,27,26,123,211,2,193,65,85,80,1,4,71,132,65,148,21,253,17,28,109,232,138,170,42,136,227,7,55,223,28,44,136,254,161,17,205,174,16,87,151,216,73,145,15,183,85,252,82,193,16,152,85,251,172,79,116,73,63,106,90,13,241,203,236,200,137,122,103,179,204,222,158,104,164,177,230,19,242,247,206,172,189,115,120,170,238,198,242,114,239,214,214,171,19,31,35,83,161,230,103,75,184,177,25,180,203,130,144,129,122,181,209,91,173,244,111,168,218,127,77,2,209,142,82,146,129,197,61,252,216,203,18,82,208,34,46,166,170,14,234,136,87,24,152,216,84,149,17,53,117,167,185,246,13,251,13,127,1,96,12,37,116,247,78,125,44,230,89,234,79,240,231,201,167,157,109,222,252,206,125,52,58,176,160,0,240,137,243,155,68,255,31,94,21,16,181,199,89,24,46,2,94,233,174,2,234,5,245,224,172,234,20,171,125,60,12,113,139,188,86,237,97,223,196,141,88,147,147,73,64,192,246,135,8,107,231,14,19,161,96,204,75,102,64,28,90,161,58,107,56,30,72,143,118,180,74,107,73,125,31,216,105,119,99,67,11,109,215,57,214,158,127,198,53,26,44,238,103,163,161,221,144,124,255,0,125,112,74,162,1,107,49,220,149,74,2,226,17,117,94,247,148,117,182,197,243,110,147,167,185,79,4,108,36,144,153,149,245,205,72,112,149,33,56,238,60,113,251,67,124,76,167,190,239,81,16,127,125,247,155,238,150,149,18,61,168,250,4,169,9,127,205,84,182,93,158,77,19,192,21,179,89,211,120,10,82,33,126,83,173,172,166,251,113,61,139,84,208,244,118,61,129,156,43,209,26,57,45,100,123,183,6,57,234,128,202,200,23,153,63,67,33,123,239,211,199,214,10,131,167,69,219,96,199,241,45,67,138,121,43,140,64,157,199,10,26,183,180,22,234,117,70,64,214,41,206,80,194,172,139,60,133,146,89,243,178,3,6,138,55,137,77,201,77,210,24,162,80,214,180,124,229,115,39,22,161,171,60,98,103,205,237,5,109,148,88,192,212,149,51,220,67,1,42,21,217,209,33,20,69,86,187,48,166,144,127,178,149,107,167,25,0,98,106,163,177,112,119,10,183,23,105,217,187,208,169,90,190,49,173,167,42,117,230,175,219,249,226,191,99,114,161,47,4,98,122,254,253,105,188,227,119,14,53,116,105,222,129,86,154,118,43,95,255,151,88,106,155,219,45,237,42,184,201,37,138,47,236,209,118,101,30,146,232,41,247,122,245,29,201,7,94,14,18,81,73,33,3,37,195,146,141,113,154,110,150,75,239,76,235,98,177,218,103,57,220,178,187,74,4,59,76,250,153,182,29,247,3,125,143,111,226,19,7,167,137,124,135,158,232,190,91,101,24,165,12,192,192,95,214,233,84,87,123,100,24,23,166,27,212,243,117,186,208,0,7,5,175,125,120,152,21,252,170,42,27,177,241,209,28,194,225,63,236,128,83,161,167,38,248,108,49,117,105,244,145,246,183,127,16,109,162,48,83,90,218,117,38,6,140,163,195,111,8,185,126,29,42,115,26,103,94,163,75,100,236,79,192,56,57,96,237,229,175,120,63,137,255,135,25,79,157,13,59,21,185,35,138,90,244,210,135,252,30,87,54,180,234,228,27,229,192,98,21,35,144,192,1,116,54,73,230,146,180,247,65,122,245,207,146,197,111,227,232,175,2,160,83,45,90,198,114,207,159,194,70,64,219,84,128,158,0,122,198,251,75,38,39,184,186,54,2,84,124,69,181,57,198,191,211,246,192,181,202,108,29,24,108,181,90,184,173,158,195,37,233,7,187,202,30,243,140,137,10,170,20,167,109,111,104,238,112,217,77,210,183,181,14,81,203,139,163,250,127,171,177,134,196,114,20,92,105,67,76,198,233,29,72,103,69,116,94,151,62,14,234,10,241,194,242,119,173,120,145,210,134,44,235,77,130,182,3,229,118,233,61,138,180,114,27,196,223,43,249,237,86,10,64,147,220,14,135,127,110,247,33,172,71,11,217,3,38,40,159,229,83,223,4,101,198,165,143,45,88,154,105,122,85,194,214,241,220,159,164,27,40,65,187,102,22,151,204,171,228,126,99,43,11,242,38,132,138,44,168,55,5,211,8,248,84,181,203,2,255,242,124,144,145,140,227,102,53,234,145,199,235,28,171,133,82,78,143,67,191,213,76,146,84,21,97,49,41,127,21,103,167,151,67,178,48,186,84,60,186,99,121,78,218,167,9,18,203,242,251,108,134,10,7,55,139,254,83,191,191,66,220,135,197,46,234,87,157,56,194,147,180,88,214,233,111,38,163,75,43,178,174,56,58,73,186,0,58,231,58,38,86,133,152,195,138,245,246,44,149,88,209,147,64,81,71,60,148,21,255,226,86,201,193,251,196,161,194,170,170,54,91,168,250,207,229,246,230,79,43,116,16,28,77,145,16,90,104,87,47,124,221,39,108,175,73,162,192,207,122,252,47,160,255,217,18,65,127,94,39,34,224,227,80,153,14,120,192,59,117,69,107,94,18,201,79,97,143,79,234,64,208,193,248,192,65,25,90,220,34,119,183,223,62,133,23,118,249,102,86,145,83,201,56,152,220,75,192,188,115,102,173,229,0,185,188,57,180,113,95,166,113,136,47,69,121,59,227,144,225,147,204,98,235,68,43,94,239,181,138,158,108,22,80,42,139,147,16,225,185,114,218,89,59,156,244,57,187,69,193,245,152,114,83,38,127,166,92,80,101,106,52,35,226,62,111,142,152,248,67,84,216,173,188,78,203,190,164,198,42,223,173,10,242,253,97,26,139,37,81,128,139,203,194,157,175,56,81,43,21,145,35,125,244,220,84,231,3,179,244,70,109,167,199,177,52,206,56,109,178,62,34,131,32,152,252,126,62,79,131,98,84,64,238,225,51,211,156,7,238,40,101,108,196,69,40,223,221,82,255,90,245,115,185,135,141,57,142,161,107,127,237,192,145,4,242,25,135,14,60,95,128,255,62,71,233,18,187,236,189,201,168,167,126,234,205,50,123,48,190,145,1,77,217,216,201,67,144,84,35,145,224,158,17,253,204,77,179,142,180,204,106,47,14,232,130,188,238,176,130,59,133,193,157,20,213,212,58,166,7,206,74,42,91,207,152,55,73,134,17,255,153,77,219,240,199,104,163,115,193,120,168,21,6,118,48,6,10,100,62,11,122,34,93,24,226,177,155,138,246,55,25,178,173,233,191,168,88,24,44,88,13,9,136,10,121,58,245,174,254,169,66,129,160,98,136,23,129,143,126,245,51,65,224,253,181,92,116,152,126,88,208,245,11,177,33,58,224,64,219,54,48,104,226,31,162,79,61,117,140,231,78,236,126,6,5,47,232,3,247,44,86,154,3,185,15,228,221,178,19,72,87,112,236,206,117,183,201,71,148,176,212,13,180,166,170,157,200,25,246,24,133,213,193,41,209,241,72,111,166,185,138,55,12,159,27,160,254,118,130,158,54,178,237,6,50,184,202,131,59,35,19,126,90,23,232,177,48,125,251,208,69,68,236,115,65,99,202,69,0,175,144,96,221,99,207,12,230,188,241,106,145,145,43,116,78,183,98,17,41,22,31,195,93,137,215,127,67,181,154,77,201,148,73,177,35,110,236,177,236,135,204,7,108,108,216,236,243,174,190,176,73,68,132,180,98,245,143,79,192,7,158,242,237,35,195,54,154,167,110,142,158,169,94,10,203,187,144,174,105,74,162,152,207,102,69,190,24,164,221,61,125,20,134,2,57,137,173,219,191,198,99,40,32,238,174,99,230,102,93,51,57,71,223,238,160,252,251,162,80,67,184,24,197,165,189,223,158,103,73,97,67,144,249,197,184,87,82,22,179,125,144,154,46,200,115,130,114,45,234,97,140,217,69,75,97,219,49,249,81,3,39,73,122,26,44,73,200,222,14,170,8,137,87,132,167,125,153,174,234,248,177,105,173,131,132,76,122,227,255,34,76,171,165,93,178,101,167,80,83,117,213,145,227,112,222,48,194,116,183,143,104,246,160,224,164,73,35,41,144,5,36,42,191,115,102,81,117,100,105,103,97,248,222,130,180,118,208,10,126,211,241,91,118,1,101,87,169,37,69,74,55,12,117,20,176,190,119,80,62,205,212,73,236,189,94,241,109,206,235,157,58,235,76,147,12,189,162,118,233,46,129,229,103,75,222,148,2,21,4,249,18,18,78,2,19,243,17,160,140,149,252,97,175,150,230,248,244,207,124,74,145,174,21,53,43,181,87,225,37,127,13,116,16,115,151,210,60,187,86,109,154,233,65,83,164,175,74,147,27,70,28,238,55,254,0,45,131,21,241,83,121,244,76,63,145,57,13,178,174,79,148,63,174,47,23,139,247,92,201,65,78,34,87,30,86,93,212,238,191,160,57,196,211,52,30,149,207,219,201,35,251,19,72,122,214,167,223,202,217,66,208,194,122,204,127,99,149,190,244,45,61,42,133,21,113,248,57,166,101,101,77,33,11,201,162,189,188,77,60,11,24,228,240,206,192,33,45,230,239,212,145,76,63,83,82,182,164,234,230,233,234,143,199,27,116,245,19,102,65,151,175,236,85,195,180,142,206,43,113,6,61,251,143,190,227,251,79,216,41,158,137,107,172,242,214,249,83,69,106,19,67,167,235,185,77,148,75,153,60,196,135,242,74,54,197,132,218,183,237,9,233,137,220,206,40,233,49,11,241,204,56,106,179,236,120,67,199,241,195,119,34,176,61,229,215,90,60,196,123,96,115,133,44,66,235,168,101,174,123,5,101,152,116,34,126,159,209,27,108,217,238,24,100,113,7,136,61,72,0,151,1,202,105,205,105,84,132,42,174,175,192,178,140,167,75,83,67,254,42,129,61,188,60,129,219,230,86,121,106,234,246,173,75,230,154,236,79,209,222,159,55,122,87,236,119,242,203,76,134,80,236,243,199,3,145,57,117,118,252,71,14,131,90,96,210,100,29,228,69,97,201,42,129,141,201,57,127,249,161,158,107,128,79,56,185,44,129,109,50,7,122,74,130,120,197,4,8,209,84,131,120,31,17,178,27,146,159,184,111,34,230,206,102,41,74,146,94,0,61,185,108,98,91,114,141,234,64,68,113,20,214,61,148,133,218,14,42,4,167,199,250,123,206,84,60,168,45,11,143,33,152,248,1,50,217,144,14,89,133,24,38,152,226,91,157,22,150,102,14,31,107,236,78,48,38,105,158,92,243,64,156,248,20,127,113,32,216,9,201,40,123,214,182,203,243,116,35,71,99,148,148,214,170,30,57,109,80,183,31,190,199,203,41,148,21,209,8,98,145,15,148,217,50,247,124,172,91,197,163,243,76,172,148,245,165,213,110,194,165,220,251,238,246,168,55,201,50,205,238,92,62,112,242,32,210,204,159,77,137,131,238,18,239,217,36,106,238,126,147,223,24,85,133,150,134,13,178,79,34,65,185,86,41,29,203,189,53,176,57,92,216,14,125,193,109,199,101,226,80,125,20,222,86,185,167,186,55,100,206,158,105,103,90,165,101,115,12,76,142,34,202,248,72,63,131,84,96,74,172,73,119,147,59,245,25,111,157,227,237,133,15,79,236,58,130,125,14,91,59,208,89,86,95,141,53,234,38,235,107,184,106,82,248,165,232,234,113,148,16,79,254,34,66,161,42,119,41,161,240,117,183,124,166,93,250,174,30,216,163,133,190,233,11,233,166,192,230,54,135,75,45,198,7,173,8,66,60,208,199,154,225,82,174,227,72,32,76,175,133,103,112,233,151,22,225,148,101,76,47,240,85,160,164,66,153,237,243,78,253,131,214,77,197,137,84,80,255,85,148,98,73,138,221,59,23,7,79,67,154,19,153,124,49,18,78,115,180,71,133,64,102,188,65,147,89,168,28,70,64,101,93,74,175,213,115,154,123,84,213,37,19,64,159,186,64,224,65,115,8,221,240,14,100,104,254,57,129,207,106,95,111,62,237,30,18,237,138,141,185,115,60,198,194,181,118,214,235,212,204,158,123,8,128,56,182,59,3,113,138,182,250,31,74,226,213,77,176,233,70,184,150,255,65,56,4,26,137,81,174,46,58,77,167,176,224,247,140,231,12,132,151,52,29,216,81,189,157,177,61,104,63,27,88,59,174,215,204,96,24,48,173,61,169,1,180,253,201,207,85,112,238,114,10,165,99,199,246,115,89,51,130,31,147,237,66,231,180,1,66,150,126,189,56,120,243,3,192,240,101,120,208,109,253,178,78,202,176,97,6,77,102,105,3,253,35,153,161,121,83,73,47,57,66,86,101,132,127,110,74,233,104,243,162,168,95,37,144,87,89,66,0,136,208,127,181,2,236,65,101,197,232,112,217,72,153,208,71,96,87,240,218,168,13,107,223,104,203,123,167,148,10,32,163,38,112,221,207,228,28,205,133,5,20,124,105,162,76,36,236,229,42,100,139,181,203,15,119,59,210,200,222,233,211,222,113,186,91,183,53,104,147,160,16,108,180,56,226,45,144,253,110,232,0,242,246,132,185,81,249,176,94,245,126,161,208,106,58,134,100,110,207,84,103,119,247,163,121,153,194,204,222,213,248,60,226,241,139,136,203,139,234,113,175,191,60,183,53,217,67,79,48,159,235,45,215,224,111,194,127,84,114,111,77,70,22,65,193,132,71,148,187,52,134,76,70,159,73,229,118,105,4,91,40,206,150,255,121,160,172,131,131,16,2,210,231,45,207,18,230,186,253,203,194,120,6,23,203,78,108,137,78,105,156,122,50,109,53,183,184,117,142,52,46,74,70,238,221,146,226,129,199,6,112,168,152,134,80,148,170,110,251,250,227,252,223,58,166,202,56,199,75,6,18,154,53,119,12,87,201,90,69,124,252,206,30,77,66,84,128,64,118,17,219,148,73,6,135,32,157,44,196,136,231,71,255,240,46,231,157,229,220,42,84,33,211,88,10,69,34,124,145,126,254,156,190,112,50,229,144,63,98,227,22,108,83,17,233,50,23,3,66,22,219,173,70,122,244,253,101,82,200,217,10,221,209,11,229,74,56,225,84,49,200,47,33,252,151,150,72,139,105,222,193,43,52,234,21,253,114,12,27,211,252,117,31,197,144,255,184,236,228,66,102,124,77,206,43,207,251,239,118,80,238,214,185,214,102,183,239,135,115,218,219,253,176,48,79,158,103,200,230,27,39,51,202,127,91,124,141,29,82,144,218,40,174,80,30,176,96,68,6,84,200,175,126,158,126,212,182,0,210,250,250,2,10,9,65,40,233,59,60,242,74,117,220,20,118,153,159,201,93,76,231,241,135,221,236,34,89,37,240,40,103,5,6,142,152,0,148,178,214,211,84,123,51,225,214,218,73,43,35,244,210,95,3,149,250,252,74,19,246,121,198,28,234,48,4,138,117,144,39,240,157,77,71,167,59,252,89,35,96,224,191,125,172,104,66,113,183,27,79,24,33,116,151,86,27,2,217,32,17,102,83,100,231,145,52,249,154,232,170,124,59,189,106,144,132,201,49,87,240,157,138,42,19,68,104,143,69,183,111,29,130,82,36,60,77,247,68,152,216,172,196,158,248,218,236,219,16,59,182,48,3,199,215,126,55,168,3,100,254,240,231,205,1,140,26,41,100,72,200,111,7,85,255,171,218,63,238,182,68,57,129,242,73,179,179,75,230,222,74,235,165,228,36,138,72,189,24,240,203,80,51,63,251,69,178,40,7,211,253,223,184,234,187,127,29,173,161,18,59,206,79,213,192,40,239,215,21,75,223,187,47,31,177,139,232,147,197,233,5,253,124,11,241,173,127,143,106,180,21,24,2,100,230,244,119,74,192,227,151,112,215,147,150,102,219,180,134,242,175,62,218,135,27,87,171,194,196,44,193,219,96,180,167,91,76,114,243,246,96,52,186,237,210,3,26,144,240,112,147,79,96,103,122,48,227,232,197,241,113,61,77,188,72,189,219,217,188,47,194,13,250,203,76,97,225,239,75,167,38,101,3,48,242,156,63,96,49,215,102,150,209,35,217,180,96,198,68,220,43,69,99,21,242,122,232,119,86,98,27,185,114,32,6,15,36,120,5,7,98,245,201,9,1,190,253,167,46,20,139,245,99,90,43,237,242,249,154,171,247,244,86,91,240,60,80,183,143,20,42,38,237,228,192,9,7,51,244,108,164,148,31,197,126,147,152,122,173,10,217,36,75,134,90,61,3,240,164,150,31,17,144,65,123,20,27,17,228,100,132,22,155,249,28,247,119,10,13,121,111,5,121,53,244,119,130,153,190,185,211,73,69,32,18,177,127,161,105,139,182,207,253,62,6,141,237,158,130,38,103,36,87,227,223,6,208,243,116,204,158,4,35,7,88,75,213,45,117,241,98,168,133,189,198,124,136,211,84,145,17,184,122,9,34,143,30,89,227,108,102,159,228,131,137,160,168,144,245,231,35,215,2,221,66,204,141,254,251,138,45,41,225,20,180,87,47,186,116,20,233,161,162,230,148,136,227,96,72,191,56,183,93,68,26,138,229,227,199,10,26,45,11,222,104,147,221,143,248,177,0,99,20,51,95,174,20,174,229,184,185,58,194,117,17,55,87,42,35,21,226,77,165,169,127,215,121,174,57,67,24,229,243,186,127,241,73,251,153,185,173,89,61,177,163,204,45,132,132,109,53,36,59,38,200,85,21,89,37,112,215,157,52,141,229,37,126,114,5,71,165,253,56,30,73,180,63,241,87,236,237,211,242,169,178,151,85,107,36,221,99,173,164,38,132,250,19,199,120,231,140,211,47,149,239,33,143,179,22,71,2,1,199,226,118,98,6,118,206,245,137,16,204,106,204,134,211,225,203,73,106,157,52,89,98,72,42,96,211,150,168,87,30,58,6,81,247,30,102,130,6,247,54,60,236,44,17,142,247,69,155,194,75,24,9,171,85,209,100,235,236,145,9,69,66,116,8,94,224,231,227,76,205,169,70,36,176,52,189,129,81,255,62,190,212,46,244,145,160,106,210,177,248,60,63,229,167,35,142,197,49,167,104,123,65,157,6,159,115,12,50,184,255,134,62,164,84,211,11,153,227,13,244,98,228,152,209,50,38,6,124,125,34,108,20,19,70,80,5,149,243,226,218,215,94,192,111,137,227,169,75,172,42,95,64,234,151,44,33,217,103,32,101,208,203,73,188,114,131,92,81,82,217,248,169,86,141,242,248,254,154,231,233,188,243,13,89,38,199,71,242,142,70,30,195,133,35,9,201,185,94,228,60,75,239,126,11,36,202,93,205,11,220,175,242,85,248,180,144,22,212,232,17,244,213,193,127,25,125,107,240,164,1,3,33,197,25,139,121,243,246,33,144,50,171,194,127,24,5,151,66,48,185,81,86,35,216,157,105,17,177,239,83,141,135,111,147,229,130,234,204,244,117,212,228,206,244,100,72,132,253,242,249,107,149,118,158,204,218,224,88,28,8,244,32,70,206,44,75,227,76,101,153,167,113,100,120,206,87,194,242,75,226,34,78,247,230,139,118,117,94,12,105,170,163,108,106,65,238,84,116,133,155,255,95,232,46,227,223,28,77,80,61,237,65,205,104,61,204,87,227,202,91,0,212,54,7,74,240,21,135,230,153,240,28,100,125,80,19,102,232,243,203,34,67,196,179,207,98,151,208,76,175,27,19,180,194,203,165,171,232,212,195,45,86,211,132,168,140,46,107,110,15,172,212,148,137,120,93,178,9,141,120,139,64,46,220,5,223,129,166,143,204,171,66,75,224,188,226,30,44,46,77,129,161,161,121,40,1,137,33,150,8,182,2,107,25,221,51,93,189,190,17,156,60,17,74,18,94,81,48,96,236,54,222,134,221,137,255,38,90,199,215,176,105,18,238,231,129,146,31,70,39,165,245,178,232,128,81,245,134,16,72,138,195,24,213,160,44,29,175,106,166,120,235,44,203,71,81,199,118,55,155,216,27,102,67,137,107,144,250,57,49,39,182,206,139,70,45,22,172,174,14,72,239,253,61,234,142,177,117,160,141,224,144,159,23,174,56,97,186,213,97,18,10,147,222,239,83,112,70,159,61,100,94,254,65,246,70,80,193,200,230,199,133,176,173,198,221,220,81,147,181,119,0,108,132,221,157,139,108,61,40,12,188,202,236,84,7,184,90,129,167,234,47,77,107,195,91,111,21,159,82,81,62,196,241,239,118,71,158,102,238,145,137,13,14,245,183,89,96,248,118,206,40,164,252,216,124,96,111,210,89,187,38,255,208,46,113,124,240,189,58,150,9,56,185,175,174,35,69,51,110,68,151,53,16,114,237,92,0,94,99,152,195,139,254,253,245,6,158,77,169,154,121,206,55,248,32,232,221,73,155,83,32,46,12,231,158,159,33,59,44,165,190,105,195,233,22,131,153,219,119,209,220,222,75,102,60,61,172,180,135,49,184,48,195,83,61,174,69,100,186,159,59,232,239,112,175,62,194,194,226,56,26,163,255,48,204,125,92,32,23,92,17,46,136,164,235,0,227,107,179,160,0,85,15,60,114,124,9,198,212,92,67,255,198,154,42,112,31,233,251,228,255,15,32,45,114,80,123,221,147,222,22,26,99,213,48,22,42,242,103,231,58,193,116,13,145,30,124,241,171,249,229,96,104,191,80,64,207,61,197,255,250,242,214,41,153,52,101,27,213,176,192,214,24,84,252,180,188,74,63,171,47,103,74,177,145,240,242,34,247,47,189,118,6,77,140,9,185,10,203,100,94,62,217,63,212,231,209,86,148,219,224,156,96,155,39,70,141,183,202,25,215,152,246,78,122,212,251,177,202,197,67,92,196,208,198,212,149,109,78,111,116,46,46,239,21,107,181,210,162,213,66,11,173,238,247,67,200,17,255,160,103,197,152,90,215,244,88,164,135,187,248,201,207,212,44,160,217,204,240,83,38,54,180,98,130,192,161,129,231,14,56,63,67,202,217,90,203,245,156,81,179,223,156,254,25,18,221,118,150,111,128,60,75,78,244,224,191,105,10,142,31,11,184,203,216,121,200,115,128,86,90,223,80,0,141,180,190,91,165,214,143,32,183,105,126,240,211,58,209,186,145,245,152,47,99,137,244,158,250,127,182,50,130,215,120,134,45,195,96,244,40,189,98,180,99,63,220,176,54,71,218,236,119,232,132,139,23,211,119,254,113,66,213,213,74,171,90,123,26,229,220,40,229,44,32,47,222,181,168,109,147,179,213,6,42,91,115,179,207,84,117,144,233,100,162,75,220,169,251,42,125,236,13,87,238,140,16,17,34,124,41,1,75,244,193,206,39,157,22,226,30,134,158,58,223,136,43,76,203,8,224,134,35,101,233,249,243,116,127,93,37,141,145,157,68,217,111,33,252,170,46,149,100,238,228,71,234,131,176,41,51,130,46,240,188,40,60,28,214,106,73,86,178,157,121,30,119,176,6,206,241,118,66,149,201,65,90,173,135,174,152,60,223,131,197,159,205,0,3,32,89,240,204,192,186,20,174,8,160,1,190,63,143,168,56,190,76,30,33,157,107,164,220,79,35,215,177,18,56,108,45,248,74,221,59,34,158,44,242,77,210,170,92,167,235,121,234,167,241,153,124,154,122,99,234,104,228,15,128,106,106,237,120,235,198,8,94,96,110,192,192,219,44,84,199,201,105,50,0,101,60,134,210,225,33,236,143,181,209,208,164,29,72,24,102,159,234,93,197,247,85,168,195,120,117,88,194,173,137,124,123,109,113,223,129,26,172,233,108,86,216,167,201,176,122,187,3,5,51,107,216,218,230,123,186,4,80,176,167,166,36,101,90,151,92,199,26,196,105,149,174,48,131,78,141,218,3,230,125,55,46,222,173,73,32,94,116,96,252,109,224,130,76,76,33,155,203,194,23,180,144,171,135,103,130,230,126,45,31,148,60,193,11,224,230,24,8,65,175,165,71,21,225,104,184,81,67,113,108,127,233,172,53,96,11,52,97,194,195,179,87,158,117,198,37,224,193,32,249,153,38,128,168,29,130,129,196,160,245,51,153,35,97,205,208,129,90,212,186,75,8,207,213,88,157,27,33,88,50,52,213,28,245,217,22,47,206,36,35,68,16,237,15,1,13,215,110,174,143,136,52,186,3,188,162,111,124,35,24,167,151,128,224,183,30,92,205,70,58,156,106,33,10,6,161,217,53,16,215,107,140,67,202,31,104,176,43,193,15,178,144,40,191,247,230,217,159,31,218,215,238,151,125,124,43,126,20,77,108,122,232,12,13,177,121,188,73,81,122,9,119,43,45,246,119,78,55,18,136,176,143,249,82,149,41,59,206,137,147,146,106,11,113,189,133,134,1,226,158,250,173,92,211,209,42,208,113,228,101,210,241,26,101,92,164,94,253,172,83,70,226,248,151,179,133,67,235,237,248,195,179,175,121,145,255,17,143,0,89,232,51,56,98,84,16,119,119,250,43,85,235,215,208,251,241,34,75,69,105,212,126,19,59,25,119,216,125,223,83,99,75,1,93,121,4,58,121,223,27,223,6,233,52,52,161,123,251,129,69,140,172,64,187,166,232,179,50,152,131,31,170,229,22,207,19,0,128,76,189,215,11,133,12,224,164,223,155,107,232,162,148,91,199,241,187,117,247,204,109,225,31,83,2,141,101,33,139,158,188,160,244,174,65,243,62,222,210,178,191,171,136,6,10,48,194,126,162,214,102,47,57,156,86,100,106,20,31,208,211,123,164,237,59,162,29,148,59,67,29,86,234,24,208,107,203,192,113,107,211,43,34,131,162,190,41,23,79,77,17,147,198,166,240,73,79,218,57,182,40,215,206,232,51,7,218,53,220,86,202,12,7,52,167,129,150,189,225,68,133,128,202,214,202,98,168,95,60,137,11,135,182,166,42,26,115,156,0,65,110,163,82,50,170,123,4,33,167,233,71,160,178,91,204,175,252,91,7,96,202,154,120,213,116,63,168,15,241,184,165,158,237,125,174,76,18,153,21,135,240,1,195,14,55,20,238,8,87,63,146,36,74,167,138,133,57,220,138,195,244,173,212,208,38,242,189,184,242,1,42,136,231,224,12,254,148,49,193,171,157,161,154,81,223,195,230,32,155,128,9,153,107,161,211,127,223,87,69,136,57,185,36,52,95,116,71,222,80,181,139,12,129,67,70,106,140,12,248,24,38,122,145,204,91,252,96,142,75,20,132,55,8,187,176,158,168,195,217,1,194,158,12,215,91,186,62,238,123,110,202,144,233,129,117,33,52,136,17,177,24,62,224,42,194,70,143,233,6,163,213,148,28,224,34,156,82,34,222,21,205,95,210,143,44,53,108,91,171,244,242,100,56,111,159,78,159,96,101,21,203,53,229,113,43,192,13,13,6,204,246,148,132,123,114,177,101,213,154,237,42,6,105,219,17,49,45,69,125,77,10,66,127,220,211,249,97,25,50,180,56,251,74,187,158,55,235,213,74,25,120,233,66,248,200,206,253,81,200,103,245,171,55,251,99,46,25,143,120,61,46,103,214,214,75,237,162,166,10,121,119,200,230,154,35,26,213,49,53,123,35,255,17,165,172,200,174,215,183,97,0,153,20,184,28,155,229,201,17,74,100,103,19,179,26,55,152,200,242,217,184,101,219,63,176,152,44,222,150,138,44,20,107,66,71,158,228,155,246,20,112,96,203,130,252,61,198,189,7,201,152,38,42,64,116,47,190,155,21,61,243,244,174,147,55,235,76,46,181,119,251,145,73,62,35,223,61,29,161,94,22,116,232,243,15,37,89,143,108,87,182,129,233,43,224,237,227,79,210,33,130,240,99,195,175,153,164,8,179,80,159,225,49,133,8,118,102,234,119,210,177,223,202,248,150,148,199,214,225,196,42,179,120,145,220,198,62,108,168,175,150,161,78,225,41,11,229,182,6,18,161,1,100,21,13,206,95,242,143,172,130,57,232,58,38,51,179,80,62,45,242,26,77,217,231,123,42,194,1,199,65,72,123,124,21,224,88,199,57,201,63,172,219,105,150,27,120,55,118,87,175,143,97,50,35,20,60,111,194,185,3,47,4,195,27,29,254,133,214,116,150,244,5,134,124,22,94,226,84,63,183,164,118,157,42,255,239,59,69,56,156,216,179,235,122,95,198,47,61,64,22,146,60,66,73,120,218,63,60,170,198,104,63,72,148,198,255,175,146,130,96,137,9,223,103,177,210,80,251,131,201,239,36,145,255,222,64,212,119,94,134,186,232,37,144,82,8,99,15,77,39,221,3,79,216,248,243,49,85,126,95,142,157,36,230,0,81,34,40,164,230,209,103,193,164,6,153,13,123,223,43,218,61,62,234,77,247,213,174,224,176,50,61,186,238,87,108,190,206,111,136,193,35,209,45,17,105,73,245,83,210,62,145,185,180,184,168,159,255,114,191,171,216,168,28,53,148,170,120,7,81,24,202,207,236,72,198,150,45,101,23,19,116,82,103,249,157,79,203,137,137,79,45,246,21,57,145,157,126,201,38,179,222,166,38,250,79,151,112,163,146,6,171,211,173,70,247,243,1,110,202,235,189,8,119,186,79,141,246,131,216,228,229,103,204,57,222,183,208,170,111,216,100,171,161,218,220,200,24,8,141,39,180,196,31,42,229,76,71,87,0,42,34,30,194,129,60,44,135,12,128,136,37,236,123,134,64,190,179,230,230,189,69,96,31,94,30,245,173,29,77,69,108,59,17,16,240,151,86,125,210,165,167,247,172,132,26,144,65,136,175,28,106,40,143,8,145,99,106,32,4,158,208,239,239,158,58,243,241,130,228,116,99,233,101,229,253,99,178,163,205,211,104,89,221,202,106,83,245,133,21,232,170,33,12,75,63,75,105,114,240,250,237,76,187,243,111,26,175,162,23,83,198,160,141,74,28,189,52,125,214,47,56,170,130,153,9,67,180,204,31,220,214,126,44,255,161,43,239,188,51,160,230,232,71,51,80,247,51,40,20,224,208,84,245,143,38,93,47,198,97,36,14,210,89,48,49,19,133,7,29,227,2,175,251,67,25,186,39,206,177,204,86,45,10,219,104,241,161,140,249,121,97,83,1,54,2,90,68,243,184,124,220,19,205,221,240,48,113,221,187,60,43,86,230,177,71,86,214,50,171,223,231,167,143,68,120,234,33,178,4,147,147,184,22,15,208,153,168,147,121,121,156,146,19,206,8,178,234,228,75,27,75,185,170,125,140,21,81,136,30,148,198,114,179,135,97,190,3,218,206,181,89,115,222,232,50,16,130,190,146,205,42,177,111,144,187,97,36,50,185,13,135,6,41,201,191,133,166,204,176,31,41,73,195,155,190,189,118,120,196,193,128,223,87,186,99,137,213,255,234,83,128,113,246,219,210,112,233,184,58,135,51,229,87,199,185,239,235,132,62,102,237,218,83,222,192,37,199,19,149,83,66,67,64,139,231,189,150,30,94,17,138,80,121,224,226,230,24,126,96,210,3,42,185,108,172,125,64,206,253,169,90,203,180,109,119,141,70,203,214,126,252,28,20,153,49,229,107,155,192,114,106,70,44,218,15,19,99,13,179,151,199,230,229,68,200,19,126,253,81,47,196,72,122,10,148,128,240,104,253,57,181,1,187,191,211,188,237,231,81,135,66,236,200,195,211,16,205,58,171,56,162,40,242,211,222,155,155,69,65,148,123,54,48,125,129,88,236,221,68,4,2,145,150,142,42,53,28,118,41,11,192,245,186,9,1,34,217,137,130,14,153,60,47,7,189,120,186,162,145,200,207,121,78,158,149,15,247,110,135,242,103,115,188,38,147,118,65,1,202,34,158,25,17,221,118,254,229,176,98,176,156,244,154,97,145,134,28,78,229,39,226,127,81,191,203,102,177,138,144,247,43,124,86,115,111,165,194,217,18,130,56,234,80,186,131,204,53,33,170,254,17,224,223,119,54,253,248,92,57,135,118,139,106,163,207,42,63,55,5,59,81,12,175,220,63,121,51,193,165,209,86,249,91,205,144,42,33,81,172,180,138,243,235,60,159,238,60,162,87,149,193,35,96,10,206,191,245,146,210,108,229,185,97,242,233,209,163,63,181,241,206,224,32,251,235,190,163,144,105,112,206,126,53,70,34,253,242,9,85,100,43,26,134,252,233,72,121,33,187,6,127,79,154,223,10,162,99,193,217,35,116,175,209,133,113,59,108,209,234,180,61,240,163,103,21,52,183,117,72,190,249,253,51,169,86,34,155,178,149,68,177,52,244,140,81,78,238,238,165,216,217,33,254,118,150,245,41,234,123,54,38,19,33,34,54,25,0,94,78,13,109,221,99,17,219,234,108,255,180,0,134,141,124,106,155,65,199,15,37,152,111,45,219,237,114,208,152,210,48,145,35,56,108,16,173,21,99,161,79,169,35,225,13,110,35,88,30,3,241,14,230,71,14,97,77,109,94,181,2,32,172,241,246,24,159,167,250,167,107,80,140,194,132,119,35,32,188,146,87,200,16,11,95,195,212,138,213,207,120,137,169,93,70,230,16,160,137,204,183,193,193,88,9,238,194,77,150,203,27,246,92,73,122,81,109,113,92,64,118,131,111,156,182,41,19,122,228,153,55,36,204,73,150,231,247,128,42,235,62,82,65,71,54,49,163,125,131,29,87,141,249,193,135,181,129,134,161,98,125,129,191,23,225,239,143,68,182,111,32,15,138,148,54,37,174,31,38,206,151,1,1,168,202,214,17,237,14,47,242,88,197,19,223,21,92,93,186,81,222,95,199,87,123,71,4,211,218,230,103,90,166,66,192,212,204,200,137,43,46,12,222,43,99,128,172,37,62,106,215,120,27,99,27,123,221,128,19,207,1,95,40,139,186,243,42,94,3,239,37,213,30,6,183,46,114,37,189,205,171,71,174,124,148,66,132,189,150,38,19,116,4,92,73,147,157,166,155,113,86,232,67,35,192,220,97,215,224,153,225,108,50,185,118,249,245,231,245,46,6,112,0,34,191,58,183,185,27,215,70,58,179,99,167,89,20,19,140,65,52,78,218,215,10,33,92,205,36,248,48,20,7,107,248,34,186,19,137,164,251,228,188,199,116,6,232,18,84,150,77,173,142,151,155,110,131,12,62,176,0,187,209,186,154,199,35,103,229,212,119,168,77,12,141,172,176,106,77,74,43,92,48,90,25,135,232,111,214,187,33,220,99,209,116,2,118,5,92,146,76,102,32,187,175,153,112,212,71,167,120,247,143,52,73,183,203,252,128,242,252,100,63,38,75,177,181,230,221,1,40,1,177,239,15,187,128,236,58,185,234,86,84,60,98,206,184,177,85,182,251,192,51,53,156,168,54,49,99,152,45,90,116,220,195,21,129,206,113,236,11,242,10,1,198,111,238,66,162,35,181,36,120,57,105,198,154,73,184,14,157,37,172,149,236,111,193,104,166,161,89,97,231,5,77,189,253,222,153,249,70,117,236,103,16,233,100,47,35,244,61,59,186,114,104,107,59,52,211,111,213,217,50,72,137,76,60,26,55,3,101,175,116,76,123,140,73,179,174,77,83,11,199,197,252,109,24,179,15,227,220,157,180,195,175,154,156,118,199,10,243,34,31,223,129,68,107,76,54,42,205,248,187,254,92,91,215,152,122,66,171,69,144,32,54,238,53,136,195,20,127,6,67,22,29,147,32,43,108,236,44,215,39,236,134,84,96,116,252,242,240,218,255,212,27,28,54,13,255,89,73,39,172,69,37,236,76,203,253,62,118,188,47,59,250,137,68,80,79,54,138,55,229,199,12,12,209,128,200,246,143,171,17,43,221,55,144,226,28,17,29,27,236,250,162,212,171,60,224,213,29,201,54,162,55,12,92,78,128,252,13,55,183,57,73,209,99,9,139,80,38,20,143,203,166,6,109,91,77,168,191,226,185,105,0,37,247,22,178,120,201,250,0,194,237,101,211,108,224,52,215,218,73,1,140,107,100,90,60,163,205,105,135,171,191,168,129,123,253,133,191,29,92,230,159,184,94,38,234,122,218,85,114,191,9,197,123,0,21,7,14,198,187,151,133,195,164,221,216,175,110,6,195,89,10,225,12,148,83,235,117,18,139,236,132,72,112,81,95,4,211,112,172,120,178,99,43,160,166,193,73,53,231,89,49,189,52,31,108,214,7,132,7,130,197,2,209,173,12,23,6,115,192,139,253,66,49,214,174,145,236,148,7,197,162,29,42,221,151,149,31,94,165,241,226,32,155,222,8,108,136,8,94,44,133,159,158,84,71,26,179,51,199,198,254,195,251,191,167,133,19,178,90,214,53,30,41,211,144,170,18,109,56,134,213,147,134,129,31,8,131,169,32,132,186,120,251,172,72,164,153,236,89,5,153,182,221,2,84,71,19,231,104,33,86,30,54,94,116,110,188,25,125,107,255,203,182,41,138,14,68,22,155,250,114,123,174,47,89,49,13,116,202,48,255,224,110,95,31,163,243,194,101,177,74,28,145,238,33,123,237,213,159,41,125,24,81,246,175,35,26,70,117,177,74,139,79,27,175,109,108,108,78,107,143,39,103,146,195,251,95,4,131,106,198,12,211,210,219,57,42,161,250,189,30,12,209,175,139,210,148,176,101,224,195,84,170,36,232,83,247,91,84,85,126,19,97,109,19,57,177,81,78,27,93,18,198,196,72,231,44,109,183,60,138,255,240,65,179,227,50,168,226,75,158,177,76,7,134,95,63,115,131,225,66,39,117,229,131,234,151,19,82,99,179,53,255,36,132,91,248,123,241,237,124,50,178,253,93,21,179,135,247,235,73,24,0,152,238,69,148,77,237,229,104,116,122,71,0,157,124,253,50,204,104,0,62,179,178,155,108,186,76,27,71,47,75,8,218,116,140,148,99,110,83,233,164,173,219,92,10,82,77,107,229,2,123,196,106,247,16,201,40,76,221,224,62,245,1,129,242,52,163,115,202,212,203,29,154,255,249,142,232,228,30,62,112,38,24,89,153,154,62,122,195,117,183,31,119,98,132,47,218,249,5,148,60,246,178,139,61,124,26,128,171,112,78,195,225,225,188,138,172,185,0,29,188,0,20,113,187,10,252,220,44,18,170,191,62,89,39,149,37,67,190,207,10,28,5,47,145,106,50,150,2,233,112,201,143,188,246,157,170,208,168,141,237,57,163,72,91,215,246,27,169,159,79,233,198,208,197,59,187,133,50,80,156,6,108,17,243,69,172,53,89,101,192,80,221,149,20,155,14,6,242,142,28,254,200,114,202,10,162,145,15,31,160,29,235,103,65,175,228,175,141,170,186,198,224,55,39,51,38,158,62,220,51,34,215,2,1,228,145,144,252,220,207,70,178,125,220,183,124,239,11,184,42,125,89,245,162,195,250,47,132,26,114,60,181,76,199,164,66,243,80,41,147,123,85,243,242,141,111,112,200,147,242,152,146,145,124,78,144,194,134,40,34,62,227,115,231,154,25,14,252,27,28,162,9,202,171,100,96,173,151,16,172,248,208,50,178,74,143,47,63,40,48,29,62,150,199,4,20,146,29,224,157,225,223,204,240,233,138,170,43,134,210,225,126,168,18,135,212,134,101,103,87,138,243,243,207,167,112,32,102,105,207,100,58,180,232,152,32,116,38,128,42,112,224,185,237,133,91,31,229,175,135,149,105,59,157,1,156,250,97,136,120,188,157,121,180,89,20,72,139,52,116,97,130,76,195,93,39,117,160,124,224,104,133,162,59,40,207,16,210,136,103,98,186,119,95,4,165,241,164,123,217,172,11,164,22,53,94,78,246,138,231,195,135,132,112,202,136,114,206,250,94,150,3,17,155,231,250,244,219,91,76,125,33,57,62,77,123,97,168,108,17,220,32,244,119,116,160,85,133,229,41,123,46,8,206,79,240,131,51,185,166,222,80,242,35,69,125,103,123,201,73,207,70,240,190,55,3,63,159,26,194,159,166,98,86,246,175,97,124,223,62,7,139,86,148,254,239,254,180,87,200,47,7,229,203,1,208,90,181,169,122,108,214,83,164,182,6,171,239,99,14,84,182,110,122,90,12,59,76,92,168,160,69,177,27,184,247,68,90,42,6,220,48,141,47,117,146,93,63,6,108,226,81,149,213,168,105,36,185,21,165,226,168,28,126,3,168,75,208,26,143,141,125,219,175,198,177,200,143,5,198,63,248,89,167,35,198,142,113,90,94,56,71,30,45,59,216,171,138,30,230,11,182,39,191,198,37,29,216,45,17,68,186,125,108,143,251,219,49,104,3,126,182,153,3,188,100,164,122,235,215,145,71,173,41,3,16,139,28,0,69,43,160,73,25,24,235,139,31,57,200,83,171,245,119,250,41,210,151,174,125,71,106,197,131,141,16,160,234,92,160,247,119,189,208,212,132,219,108,62,215,142,100,9,251,87,87,73,10,162,204,240,175,75,19,157,28,47,193,107,84,226,38,236,184,241,212,136,97,77,138,224,133,23,199,243,81,215,180,28,227,186,105,195,10,175,198,142,166,18,92,72,99,229,41,145,92,151,130,113,198,11,151,128,54,207,200,101,61,147,27,46,9,251,128,211,248,0,106,26,127,168,0,228,198,90,126,152,102,246,149,203,139,45,17,137,19,149,142,30,210,144,106,132,243,20,23,42,17,158,155,211,190,4,239,91,134,229,41,120,250,107,173,68,240,182,135,167,171,249,113,11,32,133,127,181,231,84,108,95,186,139,55,146,109,78,196,121,71,174,146,15,88,166,132,215,172,151,133,114,67,222,100,250,115,195,137,187,87,243,29,95,72,139,237,10,84,88,70,86,206,118,208,165,114,100,193,247,183,126,254,186,196,103,159,21,36,211,217,15,12,24,131,138,212,34,247,88,30,1,157,189,172,65,8,124,106,226,141,158,214,215,173,233,151,59,106,168,112,61,133,27,239,137,97,247,76,117,70,195,119,195,45,13,88,141,232,127,200,244,166,20,166,181,8,177,211,176,216,8,116,223,99,205,158,245,61,177,111,254,246,109,197,84,118,221,219,236,207,5,239,106,74,69,9,214,122,121,5,31,148,15,198,12,45,75,50,198,230,2,233,243,88,116,160,196,106,47,165,16,15,83,16,140,12,39,191,86,23,233,233,113,162,106,239,40,225,175,68,108,189,143,211,57,87,172,120,162,207,142,237,136,33,83,73,73,127,104,151,129,24,0,97,203,48,171,2,179,143,26,65,38,183,22,47,61,41,100,89,116,77,95,195,147,247,247,28,17,204,250,20,78,214,175,193,55,111,75,14,49,104,178,5,98,59,237,227,164,123,75,45,67,202,82,34,60,31,186,236,35,155,88,0,72,249,193,162,193,142,58,235,91,61,77,242,119,147,144,175,62,72,78,185,102,84,142,133,71,16,6,53,62,42,221,223,181,151,171,60,182,232,49,169,42,9,162,245,252,227,222,59,5,197,8,48,216,7,203,44,131,49,125,48,64,175,191,32,248,197,110,47,207,224,96,138,173,39,140,214,196,161,82,164,97,134,32,234,171,233,176,216,198,55,242,181,15,178,70,132,140,147,23,85,132,137,122,30,231,152,251,181,123,167,116,233,98,172,143,103,51,21,44,161,87,45,148,166,47,95,193,154,143,186,27,198,124,16,28,59,2,158,33,232,253,235,190,10,220,126,78,215,16,209,146,30,199,253,72,111,77,201,19,67,10,246,153,140,223,58,55,220,93,65,66,131,64,122,40,73,28,207,209,155,97,153,63,13,253,249,246,20,232,150,98,65,32,242,53,190,65,148,177,58,34,51,244,199,178,87,8,8,134,209,13,227,120,176,47,103,250,46,235,48,163,113,17,9,252,211,60,179,115,111,128,21,101,111,71,210,215,232,176,2,48,174,214,133,73,195,85,253,9,124,120,78,105,217,114,55,92,49,95,255,9,228,225,237,236,247,102,161,10,163,24,250,140,11,66,44,167,44,14,246,231,125,249,119,242,215,122,3,154,61,105,219,219,103,238,24,120,15,49,211,35,202,223,223,183,123,187,158,182,149,209,242,130,55,123,95,56,15,175,139,253,120,86,255,122,135,13,104,56,92,22,17,173,69,51,216,169,187,67,171,227,247,26,190,145,16,56,107,89,119,165,192,197,188,109,114,189,55,199,87,127,214,161,83,163,83,142,195,74,60,71,197,232,196,217,61,108,166,241,82,209,227,73,65,63,14,145,36,252,182,150,60,208,95,173,91,159,38,134,188,195,127,68,205,200,132,122,18,76,131,41,105,204,189,143,107,158,60,126,88,122,194,129,8,129,52,238,118,170,20,159,79,147,250,231,1,123,37,23,190,96,101,215,21,106,61,220,197,189,77,120,228,49,72,107,231,76,59,171,198,231,129,110,55,119,21,24,123,120,159,67,85,62,235,3,70,235,247,39,106,75,146,9,248,103,190,83,50,70,45,19,33,89,158,173,114,41,104,203,170,135,233,101,71,176,145,118,171,100,145,52,104,122,207,120,97,46,109,52,8,189,32,160,28,218,15,234,43,109,54,153,112,19,201,205,193,242,157,78,219,205,168,48,134,27,136,234,41,66,150,28,158,44,22,104,184,207,13,49,73,191,20,146,146,133,254,96,138,149,196,183,116,198,107,60,131,68,181,140,219,123,142,135,191,157,254,243,92,23,161,184,117,43,224,71,100,199,212,104,131,102,221,104,106,251,222,143,192,181,144,75,244,171,100,187,67,205,221,81,52,90,24,27,195,160,46,0,76,189,53,208,84,166,186,250,58,2,130,143,62,151,194,191,145,109,116,233,234,93,241,13,118,26,176,9,115,192,184,173,231,29,46,11,21,215,56,236,13,22,201,172,3,0,114,246,143,238,245,68,29,193,220,158,149,168,87,21,44,130,226,13,138,193,31,0,251,75,113,167,77,41,128,88,179,182,237,220,150,218,6,77,100,92,35,194,2,12,220,190,140,245,115,198,36,62,51,162,50,64,141,20,36,125,5,136,115,43,159,185,255,22,207,220,105,177,235,176,61,89,45,230,69,31,34,161,24,190,144,246,120,112,202,187,31,37,246,168,105,12,60,232,171,180,200,45,97,153,38,204,117,195,20,243,112,79,77,229,105,20,210,49,53,104,126,176,104,130,15,77,44,14,92,8,25,145,69,154,4,8,223,96,148,40,130,80,146,38,73,88,85,26,76,102,25,22,149,204,78,251,153,126,173,21,184,110,87,192,225,119,74,244,194,228,228,208,44,112,179,238,3,31,140,135,110,21,67,127,243,86,169,29,103,35,11,23,49,131,209,213,47,156,20,128,46,236,11,237,31,66,19,33,105,26,142,170,115,85,24,16,126,223,14,87,223,56,189,47,16,226,98,233,76,27,69,163,143,93,218,171,10,231,124,151,220,107,111,202,94,60,143,30,182,232,28,24,197,101,128,95,254,177,199,75,61,224,82,190,129,65,220,245,1,96,139,228,168,245,188,48,129,16,144,17,252,196,116,14,221,161,23,42,138,216,185,17,87,221,112,106,67,207,49,97,127,72,167,151,217,71,210,21,175,79,98,40,145,38,227,55,136,93,202,126,59,71,212,202,162,245,113,157,16,94,140,57,112,242,151,65,244,56,161,53,51,84,214,26,87,138,61,9,135,243,93,32,234,124,171,153,35,38,100,147,238,240,21,243,96,35,91,10,39,99,139,160,196,151,67,170,98,112,57,252,54,154,182,83,35,44,205,13,217,198,10,156,36,153,138,166,196,241,22,79,62,53,205,204,57,230,174,179,124,13,110,197,246,161,16,227,191,238,113,161,149,113,27,55,188,24,164,204,249,128,61,8,165,116,22,28,101,37,96,119,186,83,135,49,42,63,9,70,235,59,137,162,144,82,252,120,198,30,11,124,246,145,191,102,215,32,46,174,74,145,118,116,241,87,82,22,186,244,226,76,29,123,252,173,215,125,79,27,91,46,210,42,180,97,159,183,118,23,67,127,195,205,41,39,172,129,161,5,124,28,53,49,94,137,39,60,216,13,247,243,4,141,223,92,226,178,180,200,177,109,107,22,205,120,44,121,153,38,118,55,225,240,253,214,73,118,110,114,38,126,171,25,13,135,247,79,120,146,141,6,203,40,87,3,178,173,242,147,85,77,116,54,202,187,237,126,94,103,112,86,40,132,121,239,150,123,239,7,143,93,0,167,205,21,164,131,223,149,198,153,220,0,181,193,111,120,245,65,74,15,79,61,190,242,118,155,40,103,109,191,30,166,201,55,19,213,58,44,199,137,162,240,144,217,27,32,151,248,26,2,202,48,202,87,154,192,36,206,213,225,231,237,39,235,162,122,157,158,157,200,16,12,98,145,95,74,226,162,85,20,243,10,70,217,99,247,191,163,140,22,79,106,242,232,214,186,93,41,76,49,91,76,251,177,71,115,169,95,109,128,232,228,179,202,150,42,67,151,65,175,239,244,73,60,135,131,221,249,70,211,180,75,246,51,22,38,184,166,127,93,195,148,223,110,23,241,170,196,58,162,61,7,165,176,96,151,131,171,28,35,96,59,255,60,209,164,20,119,224,139,121,107,59,215,212,163,16,241,143,3,73,51,87,132,50,34,101,22,33,109,186,151,115,233,182,243,114,199,223,79,41,18,37,80,126,13,200,108,93,237,54,128,211,31,113,74,125,40,190,186,248,98,239,26,188,170,88,111,205,125,250,235,215,129,205,25,101,23,146,197,35,42,105,20,96,50,99,111,140,191,139,26,73,205,160,50,233,128,255,151,191,17,117,10,121,207,138,178,202,213,146,17,170,200,8,203,106,221,83,18,63,115,160,133,113,52,130,104,206,234,28,228,155,106,137,204,17,37,70,252,152,44,112,219,224,57,139,107,132,122,247,169,244,126,41,237,4,138,42,186,69,49,135,190,197,91,135,225,101,95,220,33,142,174,120,125,57,236,163,0,78,242,24,165,61,93,31,55,31,9,103,195,169,122,40,82,85,113,188,154,184,57,131,184,193,111,196,45,127,164,25,95,33,14,187,103,180,67,196,107,38,186,8,101,10,116,114,196,101,166,222,7,73,185,56,172,177,89,75,195,243,170,33,134,230,63,87,121,143,99,23,21,202,4,172,44,9,57,45,162,115,84,229,201,207,205,203,177,40,229,51,247,181,226,91,209,17,95,113,254,63,163,112,101,155,120,52,10,236,18,161,70,12,215,121,217,74,133,102,93,228,202,98,228,48,141,109,214,207,22,4,123,130,115,248,236,72,1,190,57,76,222,226,42,51,237,132,160,229,138,133,199,152,212,37,154,172,29,20,199,131,225,91,37,135,178,56,86,90,170,72,98,86,72,28,11,1,105,211,72,28,25,163,181,146,184,236,141,211,83,213,155,9,103,83,175,228,194,242,20,103,233,3,31,215,210,54,253,183,201,96,234,247,216,69,209,33,3,60,234,75,64,236,86,103,120,247,204,62,30,58,137,60,142,40,134,90,235,120,196,21,97,221,138,67,0,254,21,197,77,179,88,173,139,80,98,161,237,204,87,105,6,160,116,42,85,63,6,252,159,39,96,205,112,129,19,96,234,240,107,211,35,88,3,238,8,19,124,199,139,226,121,13,195,37,201,27,182,169,169,109,31,215,212,85,177,4,210,22,203,217,65,117,164,213,26,104,226,167,100,117,115,192,249,106,4,92,219,206,29,165,144,167,201,24,53,60,100,62,212,152,172,203,214,92,229,35,21,179,182,58,179,12,103,27,49,107,40,86,178,27,41,155,176,203,41,17,101,171,11,36,201,126,31,46,125,88,62,224,101,255,212,155,25,197,21,19,51,46,189,209,210,249,25,135,177,158,47,46,182,238,189,155,99,126,209,15,80,77,196,175,153,31,169,230,187,44,53,144,45,9,101,38,36,71,107,14,78,139,3,235,195,166,8,234,237,198,3,75,119,35,141,215,21,238,177,72,171,24,76,61,244,91,123,125,154,83,158,60,190,225,29,252,154,230,228,175,138,115,104,208,20,160,187,133,50,205,113,54,27,8,136,213,226,96,240,105,223,146,12,26,227,146,79,52,225,99,248,121,29,205,108,53,82,253,218,46,250,121,173,171,242,84,80,184,89,71,0,230,232,99,158,114,52,230,242,65,43,245,212,215,69,38,92,172,230,29,231,55,157,83,145,14,167,155,144,75,35,25,238,176,221,2,151,220,191,228,32,174,10,151,189,2,130,133,177,36,9,55,202,181,175,245,142,43,81,38,128,119,136,121,67,20,44,215,95,216,231,206,238,4,245,154,167,51,158,74,253,65,155,13,28,236,28,250,166,93,103,112,129,209,42,220,23,69,190,214,33,155,6,229,191,148,178,72,39,141,151,148,133,87,48,143,84,179,100,21,57,236,203,201,106,77,125,210,6,134,241,204,166,135,31,185,75,71,55,194,95,146,160,181,235,159,240,146,69,56,173,221,131,56,119,9,149,7,108,154,104,77,92,217,246,237,245,140,240,114,27,94,171,223,71,228,51,17,193,65,145,130,100,58,216,36,206,135,161,1,97,220,2,91,213,246,73,130,12,31,140,5,0,99,52,208,190,139,52,218,13,219,26,244,114,60,216,144,25,164,244,166,247,113,28,88,141,242,111,189,217,234,28,123,104,239,54,91,165,125,34,196,205,226,116,66,188,205,26,216,0,33,137,76,142,112,49,182,32,86,114,175,20,172,198,53,63,71,183,129,187,54,81,139,195,102,175,207,79,41,75,20,41,150,154,139,240,247,200,13,23,48,99,158,133,171,12,114,171,49,196,45,229,35,150,188,104,201,217,147,218,146,207,0,181,9,97,107,144,128,207,244,14,156,120,2,67,141,164,48,138,40,188,197,21,215,33,34,84,68,7,223,60,10,193,198,90,248,84,221,215,188,121,177,165,95,179,2,149,61,199,96,228,96,107,107,81,223,133,237,141,103,71,7,63,97,241,218,113,200,85,219,3,113,144,145,68,132,156,16,90,205,177,247,114,103,109,144,252,3,154,21,35,216,45,244,49,131,80,11,7,224,19,254,191,211,77,175,162,155,159,19,27,47,16,155,144,129,207,177,37,185,120,151,202,144,91,209,92,50,217,220,186,105,4,191,210,143,215,87,8,179,1,221,32,185,0,159,251,60,10,229,4,84,135,10,209,90,22,24,16,170,9,204,187,254,127,207,238,10,30,167,122,206,223,57,199,218,40,222,143,73,12,145,53,168,167,153,94,152,211,191,77,92,189,59,2,252,79,3,136,46,125,175,87,94,55,71,113,63,48,99,166,222,33,123,240,36,15,217,179,171,63,211,229,169,186,79,99,49,34,213,120,221,172,57,216,232,17,131,192,137,8,9,245,17,193,238,44,67,223,226,27,246,174,112,45,206,178,232,61,242,228,115,100,216,11,30,237,96,3,101,244,155,232,12,217,74,251,138,211,15,253,122,79,4,237,92,30,220,27,236,209,221,110,68,130,94,214,205,137,19,33,237,90,111,79,203,171,54,229,180,207,223,11,224,191,32,218,217,154,129,200,202,206,94,105,253,78,145,176,64,178,113,227,200,58,119,78,215,164,21,221,112,54,156,75,133,148,94,204,22,40,145,245,145,88,140,133,13,149,133,208,61,7,156,189,59,185,87,3,182,98,161,106,76,179,204,13,162,79,111,107,71,253,40,194,153,7,55,251,125,3,129,133,185,104,230,103,220,17,206,45,212,163,35,96,210,207,4,224,225,61,170,115,49,122,82,55,246,99,117,228,60,194,168,155,233,216,149,234,233,147,180,46,206,32,227,87,229,167,6,57,91,127,213,253,170,154,80,203,151,234,93,161,40,32,190,214,66,254,150,104,191,57,245,211,103,242,142,197,11,66,114,26,230,162,142,155,183,107,121,3,10,88,186,57,220,13,254,177,59,21,161,225,122,21,151,97,115,194,82,81,103,196,14,4,166,14,195,62,212,219,219,15,94,59,236,9,145,224,20,176,172,35,80,118,199,8,174,187,145,67,64,21,173,7,54,254,234,84,88,154,210,117,222,238,147,111,189,248,114,144,174,43,29,249,161,75,85,187,214,80,239,3,188,97,224,184,207,176,5,82,182,167,122,32,192,7,198,111,69,27,255,10,213,117,220,130,40,5,83,140,6,102,235,118,28,199,82,50,114,141,3,148,248,127,1,214,51,218,21,126,161,220,184,13,40,119,161,39,220,95,131,120,198,65,156,87,239,115,125,151,6,177,132,117,91,64,12,126,117,138,31,72,229,0,38,69,186,113,236,175,83,49,51,220,24,98,249,38,93,235,188,212,15,175,128,106,146,132,12,142,109,70,229,204,153,157,177,0,124,217,45,8,128,220,87,253,127,93,56,206,244,124,108,4,207,191,158,69,222,199,80,156,119,229,32,240,236,19,182,143,244,48,176,211,162,109,202,56,182,17,246,151,230,242,141,220,50,25,72,138,38,216,67,255,5,141,19,80,189,131,90,134,214,180,8,15,249,150,115,0,19,138,63,94,140,69,50,155,163,125,6,46,189,152,147,151,167,245,31,111,103,24,218,139,251,80,236,218,165,64,26,58,218,204,217,236,184,143,34,197,236,155,242,151,228,89,160,221,246,168,193,225,121,91,138,198,8,45,84,122,73,126,26,189,20,148,67,100,176,203,41,135,135,41,213,113,240,17,145,119,237,232,130,38,246,185,140,243,36,114,57,46,208,62,43,228,173,192,148,63,207,223,153,226,160,188,49,163,222,75,163,50,8,1,229,46,237,216,250,138,215,163,142,199,154,115,147,66,29,178,54,138,66,34,103,66,48,125,198,74,152,245,166,82,183,11,110,220,48,220,28,28,5,0,99,153,51,62,143,121,204,205,199,129,227,103,148,131,209,45,155,86,150,200,207,68,17,23,171,37,235,13,101,215,205,8,162,123,47,190,79,242,156,205,211,102,4,87,120,17,109,10,188,118,5,41,34,245,221,6,111,159,119,149,226,175,144,225,240,44,151,174,186,43,70,78,45,156,202,123,214,110,240,125,93,56,98,114,235,89,75,15,172,139,45,5,241,100,129,16,16,155,99,219,127,237,232,81,250,193,54,33,6,42,209,177,227,179,43,151,138,137,162,142,228,63,2,39,25,211,228,182,160,224,13,154,125,198,187,108,130,251,87,135,180,90,7,151,142,141,88,94,179,206,163,178,193,146,127,167,131,119,39,49,109,93,67,114,26,20,135,100,17,104,111,143,242,211,227,124,127,159,1,120,182,12,122,1,101,28,8,170,47,174,194,207,170,54,74,117,160,183,97,129,196,247,114,76,126,86,161,6,131,149,196,124,134,86,19,108,33,25,205,220,223,74,58,210,98,195,31,228,191,178,63,102,92,157,233,209,207,211,132,5,233,51,146,11,166,166,5,119,249,244,42,97,155,224,209,253,225,201,135,28,86,62,200,28,241,31,189,62,176,66,176,109,215,1,246,60,230,92,139,22,48,194,161,148,213,168,147,100,103,220,217,102,162,240,22,126,198,168,38,169,64,206,131,94,155,236,93,215,138,216,65,82,150,29,96,10,245,175,49,189,141,248,237,3,57,124,98,100,163,168,194,223,180,195,83,234,58,173,167,125,231,91,82,154,41,118,53,119,29,26,12,135,46,161,61,76,52,63,176,230,55,134,199,136,144,59,210,205,101,75,216,221,254,116,169,121,202,0,173,189,233,56,135,242,210,64,53,252,63,11,87,193,67,213,170,249,201,37,75,10,84,15,120,36,209,2,69,148,245,13,179,77,199,181,148,90,103,157,249,245,239,207,131,76,93,210,76,81,104,211,235,153,243,5,158,174,129,130,193,128,117,51,86,204,112,255,188,249,81,115,151,130,26,84,155,225,198,152,211,251,32,250,33,80,155,169,221,125,56,105,130,107,173,14,253,108,20,83,231,239,51,250,187,43,119,64,89,213,180,250,175,2,192,42,152,27,141,253,154,234,85,32,20,147,30,137,5,227,38,73,217,171,92,27,250,191,26,43,193,78,169,39,24,171,35,244,233,82,218,71,97,9,154,60,20,124,12,189,97,139,113,4,130,102,145,230,115,104,124,220,110,204,219,28,109,44,210,56,96,184,239,59,142,253,61,231,226,245,156,202,226,114,161,187,6,238,68,91,160,76,34,221,133,59,91,190,200,221,99,209,63,8,2,245,73,194,115,61,203,94,50,71,88,136,106,90,182,221,220,152,217,170,32,228,226,57,45,4,220,238,78,111,83,184,2,94,135,93,30,193,12,249,180,82,27,22,158,212,219,41,144,12,38,167,114,223,195,144,76,249,30,136,14,90,66,187,55,246,27,114,16,115,191,27,237,229,5,246,146,218,179,208,241,120,167,156,89,4,53,65,70,229,226,154,69,132,10,165,180,50,203,33,78,197,181,15,236,26,120,28,181,187,59,194,116,101,94,152,30,113,201,66,25,179,211,158,1,36,206,38,34,130,5,135,189,80,18,159,235,82,39,215,89,90,164,109,177,201,139,255,226,167,18,194,14,42,111,93,220,179,10,211,214,119,64,101,177,162,203,105,17,107,13,153,217,83,200,41,114,177,65,130,179,87,36,171,183,161,93,15,164,251,72,145,165,88,87,201,208,166,59,81,57,41,74,245,49,169,216,208,249,186,28,234,36,123,97,144,71,125,151,163,107,62,134,93,138,155,164,7,34,46,80,57,253,227,201,233,189,247,36,9,132,95,74,155,137,44,161,142,77,232,47,34,81,212,197,165,140,79,178,11,118,106,193,23,54,53,83,222,50,23,2,41,11,124,252,243,218,59,66,206,10,195,19,163,223,174,41,60,115,248,254,131,37,175,153,0,178,52,223,81,50,138,66,234,205,171,150,182,52,202,150,177,88,220,206,15,219,78,191,241,200,105,186,252,179,249,205,237,0,178,167,95,158,207,217,113,45,167,176,166,151,224,130,180,90,86,184,106,103,65,144,205,233,253,254,214,121,117,90,226,246,218,169,127,72,136,148,80,116,68,184,194,105,125,28,234,202,237,62,27,209,151,67,217,146,215,202,4,239,191,99,28,109,54,132,193,143,9,173,51,183,236,61,161,254,90,106,140,28,250,140,176,218,187,191,46,222,214,34,230,16,34,78,148,5,227,36,121,9,68,183,179,49,245,5,34,114,225,32,178,27,79,103,233,159,222,101,209,187,241,176,251,151,68,72,109,238,43,123,183,169,199,123,63,55,56,16,71,63,219,94,76,191,182,91,173,119,53,183,50,114,164,30,125,236,132,181,136,175,76,108,106,101,6,238,162,196,95,105,40,219,198,31,170,141,6,176,40,255,217,24,69,183,17,40,172,112,100,152,95,113,18,37,79,19,115,109,138,14,223,255,1,199,144,24,75,234,130,110,144,108,223,143,97,16,233,131,76,195,203,148,114,65,208,23,127,96,130,18,123,40,229,234,193,99,70,147,244,195,201,22,75,138,241,107,124,49,21,106,74,153,223,136,201,246,240,243,217,237,138,228,12,45,69,173,52,119,136,211,218,253,35,241,47,237,25,125,106,33,202,55,121,94,35,204,155,55,102,179,170,121,129,72,211,191,134,168,69,98,227,215,173,166,8,7,229,108,177,161,144,73,232,184,57,148,75,79,140,45,61,139,198,39,8,232,220,81,163,156,57,119,201,86,152,71,43,187,9,37,205,170,250,227,221,172,163,6,208,56,239,245,120,173,41,146,117,134,168,205,182,119,122,185,3,88,191,94,167,66,97,90,105,233,3,54,227,234,100,153,142,129,126,194,205,169,221,241,66,59,5,130,95,80,120,45,153,172,28,132,193,52,194,56,98,13,155,85,240,8,18,5,173,177,204,245,47,68,16,27,129,170,145,239,191,86,166,169,158,41,167,231,49,188,150,65,180,237,186,83,90,130,74,221,37,83,32,169,121,172,206,183,76,17,71,52,243,121,195,37,13,74,130,6,182,224,80,9,36,58,167,145,207,114,244,27,143,97,197,175,250,42,147,18,116,225,186,214,215,238,45,80,152,23,166,91,82,229,252,171,140,217,39,72,108,100,98,106,217,100,112,85,184,232,92,175,78,95,140,26,121,241,62,102,120,184,183,249,130,236,189,117,160,32,178,101,176,87,147,33,97,192,124,116,26,228,251,61,188,51,166,255,34,73,38,130,232,120,110,12,6,36,246,70,168,207,144,93,25,58,39,225,115,142,240,234,18,42,50,38,136,151,37,8,235,113,32,80,101,75,237,154,140,75,250,7,149,51,53,14,186,52,45,223,106,41,3,131,217,4,195,25,98,3,252,67,115,18,33,111,199,145,73,126,52,157,16,15,91,254,215,162,241,195,136,237,35,164,17,182,169,63,114,177,157,10,227,175,139,200,99,232,176,113,13,230,144,169,51,4,203,123,253,27,252,162,12,112,69,196,247,242,203,65,102,174,64,214,29,84,201,182,120,187,172,90,140,134,64,39,111,246,43,188,89,5,116,180,13,151,110,131,180,151,224,89,12,252,132,127,115,8,71,62,246,97,20,224,224,123,12,30,234,42,246,33,231,129,30,45,49,64,48,110,214,138,49,43,11,117,183,36,182,138,111,225,186,82,104,28,169,50,217,143,5,188,250,245,95,83,72,237,253,255,19,161,91,76,139,70,244,60,229,142,75,154,165,37,229,54,66,107,135,140,245,116,71,84,253,141,159,58,35,210,118,161,217,21,33,41,12,186,194,130,45,174,68,18,120,137,111,200,206,121,198,85,217,85,34,109,153,134,9,161,6,198,217,66,239,105,113,92,255,217,142,208,235,27,90,49,75,64,129,19,242,215,64,182,65,50,146,113,224,53,173,172,118,21,64,155,144,222,37,237,63,145,21,205,64,185,57,106,134,54,20,128,229,144,83,73,153,157,42,44,253,216,33,239,248,171,162,238,250,141,101,245,152,97,245,251,25,66,64,7,74,210,210,93,29,215,69,227,11,44,90,183,40,206,13,198,200,140,50,247,74,143,7,88,132,18,54,192,236,149,24,209,157,15,106,238,242,158,233,154,111,54,79,249,192,205,198,185,43,208,198,104,146,250,35,32,185,150,20,131,45,145,83,152,50,31,127,202,91,142,50,62,131,139,52,139,180,82,220,172,115,5,10,82,223,104,57,189,247,207,36,206,134,75,88,124,162,203,190,130,157,208,102,108,239,16,99,139,3,129,47,150,23,233,59,60,26,122,213,40,130,240,75,48,160,51,204,30,145,186,222,114,205,66,34,112,116,137,232,209,136,202,96,227,229,195,54,130,48,4,250,74,102,83,37,204,191,36,0,153,179,162,60,40,145,99,114,212,214,198,198,137,110,115,55,186,194,4,148,241,16,233,34,30,22,242,22,193,164,116,147,46,83,152,254,164,166,127,163,134,128,177,115,20,89,83,222,192,17,65,13,193,16,52,150,20,181,7,224,157,85,242,177,5,102,195,100,99,107,60,255,178,191,251,242,208,150,56,62,172,27,151,246,203,130,42,150,10,172,71,93,36,174,3,247,196,39,167,120,74,178,199,83,249,77,14,104,6,163,161,214,91,59,27,173,83,187,130,106,55,224,192,24,222,82,152,146,218,30,223,84,148,208,76,164,249,71,181,132,134,111,21,21,24,25,118,27,174,120,9,213,79,74,102,85,205,211,218,69,6,178,40,188,71,195,201,139,80,6,189,172,222,102,251,90,254,221,117,56,218,57,110,105,134,106,1,190,134,217,33,137,47,118,252,70,121,191,100,139,219,102,170,84,90,3,219,165,138,74,182,203,241,99,246,21,82,238,226,82,173,86,70,4,54,19,49,38,216,190,200,22,194,220,66,178,67,14,227,28,137,218,45,73,27,241,35,49,180,70,176,116,3,107,184,173,15,224,31,120,198,236,172,71,168,189,26,95,84,98,105,157,188,224,231,53,61,134,19,174,102,249,62,64,178,137,50,206,195,33,185,194,142,201,184,190,63,28,9,172,75,46,199,194,164,34,179,49,207,106,188,224,97,98,217,235,218,254,252,244,176,122,83,198,39,139,67,102,201,212,30,201,92,175,13,208,210,187,239,176,226,141,180,206,135,157,215,73,158,89,141,83,47,221,154,40,10,43,33,195,166,218,37,51,222,233,237,11,15,138,161,12,178,230,159,48,67,200,239,146,73,129,170,222,193,141,155,126,13,254,210,218,18,3,240,51,131,133,102,129,13,37,45,19,27,184,167,181,208,231,105,179,244,220,58,235,236,68,250,27,219,89,172,242,4,155,236,201,210,52,90,119,24,133,148,194,77,84,4,206,135,145,179,60,102,19,89,175,44,137,13,93,153,184,38,53,141,116,22,133,19,15,95,104,63,202,23,161,60,197,28,48,237,192,170,178,208,145,39,209,124,156,177,57,28,124,33,14,166,163,78,222,12,188,120,254,141,80,35,46,123,102,2,194,187,15,232,76,28,168,38,131,222,178,111,240,127,19,108,196,155,119,70,117,212,238,86,42,126,42,233,125,251,83,181,132,90,5,21,242,61,169,126,150,176,44,92,34,123,122,100,102,137,188,179,93,183,155,161,124,153,12,127,48,190,126,78,200,138,234,254,26,100,151,253,33,119,19,14,66,30,130,238,6,90,92,65,186,81,70,249,178,92,194,140,74,13,182,182,121,146,213,25,95,209,11,45,4,234,99,250,143,241,129,189,216,157,177,90,176,23,19,253,156,223,161,6,104,28,187,75,158,195,218,104,115,107,123,76,13,168,229,30,126,77,108,101,234,155,125,177,231,237,160,102,110,96,152,143,18,156,36,1,122,124,185,36,193,122,80,108,90,30,37,162,137,130,44,230,121,230,31,77,238,17,13,86,7,30,104,135,71,108,72,144,59,82,163,177,120,56,199,7,26,252,173,156,91,238,45,84,189,151,90,5,230,3,145,193,54,238,251,44,67,37,102,65,234,105,254,194,22,145,142,121,114,190,156,54,72,219,85,190,64,125,179,203,159,40,106,244,169,101,14,186,104,25,135,133,181,30,149,165,131,232,62,147,125,13,200,246,123,173,130,31,181,5,228,203,117,16,129,127,168,12,175,233,89,37,72,96,189,8,61,163,133,219,103,54,79,117,163,51,252,58,200,251,182,217,185,93,50,242,222,36,85,144,80,46,196,36,238,47,144,152,30,235,24,67,49,163,182,7,8,155,245,237,109,69,177,141,119,142,85,95,235,223,174,121,137,85,77,50,39,56,185,179,4,149,186,55,12,204,36,170,65,112,173,150,4,243,169,129,63,95,74,75,249,212,31,224,252,147,17,123,50,39,54,116,67,137,103,41,139,121,46,117,155,135,78,158,12,65,196,142,130,69,219,3,198,208,70,255,82,162,156,82,22,108,76,112,68,247,8,24,2,178,224,56,91,106,114,55,114,4,59,197,234,217,165,201,37,146,38,96,113,132,80,113,80,86,156,70,39,167,233,216,68,167,224,243,180,61,234,30,117,32,200,0,5,151,201,144,33,230,243,21,70,141,84,192,15,134,227,26,213,88,96,144,72,224,100,1,170,238,2,104,177,34,126,10,228,234,127,78,62,226,222,211,197,208,120,36,203,118,191,19,255,77,117,250,150,135,152,71,143,217,97,25,166,214,34,219,134,157,17,14,104,215,134,128,167,66,24,30,70,78,9,195,56,58,86,233,112,93,235,17,162,19,166,173,109,107,5,26,57,219,236,22,199,236,154,155,42,230,0,114,88,13,89,196,51,3,16,171,31,37,168,15,46,35,11,40,160,234,96,129,35,219,46,222,221,242,13,156,48,172,58,135,112,116,202,209,10,58,37,73,33,54,142,61,255,94,135,27,57,184,178,83,84,14,20,255,219,254,128,137,228,169,196,43,32,187,200,46,26,177,249,104,87,174,9,80,16,21,41,233,120,173,77,75,231,172,70,204,96,89,117,238,243,54,153,247,240,38,151,69,51,221,55,157,227,203,12,227,196,82,39,228,66,191,120,250,248,145,110,141,158,135,188,38,214,72,28,173,196,206,114,2,202,89,84,203,132,150,180,109,14,229,142,138,58,70,18,205,81,234,50,154,146,47,199,71,87,76,76,178,112,241,174,94,148,188,243,237,250,79,177,57,134,64,88,178,242,233,131,147,129,57,204,166,50,254,104,138,122,48,7,116,49,247,169,26,221,161,53,171,116,92,3,163,120,138,210,239,42,129,187,82,176,24,138,0,145,221,86,133,171,88,142,120,89,178,3,94,144,72,59,28,169,247,6,32,94,2,40,191,66,5,217,118,193,244,193,182,20,142,114,226,186,20,112,129,162,181,164,3,131,155,30,226,184,214,51,115,6,249,161,246,230,217,110,174,14,232,128,54,179,28,184,96,207,249,233,238,209,56,94,207,142,113,243,49,108,0,70,114,52,7,116,231,120,147,77,98,70,128,86,177,99,203,121,141,155,170,149,43,147,86,9,134,38,182,72,97,154,86,206,240,29,137,137,124,110,77,179,76,227,222,166,201,128,84,105,79,199,237,36,157,216,165,125,48,59,142,233,114,164,64,7,255,170,150,67,107,118,199,30,253,188,26,21,43,66,176,208,110,163,141,144,63,172,190,104,191,26,110,135,195,18,239,58,114,73,172,235,138,18,60,36,151,134,131,121,201,218,122,39,142,216,188,161,87,194,94,232,190,133,3,31,32,56,200,101,228,85,87,199,191,138,59,139,198,64,24,38,215,70,155,25,185,101,76,142,104,188,84,156,101,222,92,41,16,204,40,166,141,164,90,75,119,214,152,165,253,101,220,87,71,239,109,184,54,219,19,47,123,95,136,119,124,213,235,49,145,35,114,72,205,188,248,23,211,128,62,86,146,165,5,85,1,214,178,101,125,243,9,207,42,29,162,90,191,229,104,197,89,101,30,58,89,5,113,16,99,233,128,87,199,251,190,78,32,71,105,143,123,225,28,1,20,118,50,111,102,127,234,94,185,146,36,75,146,94,244,214,9,236,194,248,188,30,66,131,8,36,118,84,95,199,123,34,7,138,188,172,174,54,185,80,113,213,148,208,133,250,174,28,8,119,117,26,226,238,82,135,100,248,22,1,54,228,225,144,157,15,93,26,72,59,140,147,146,84,90,49,140,37,148,122,245,65,185,207,163,187,208,155,249,209,255,187,75,83,204,196,129,15,199,62,229,251,186,161,201,31,71,6,199,182,121,39,87,76,94,251,64,226,228,58,3,89,172,13,23,234,208,197,175,38,180,39,134,228,16,116,228,35,127,159,172,179,102,240,164,255,217,52,225,171,243,131,129,93,189,7,118,57,153,114,221,191,230,93,50,246,150,146,182,197,170,245,104,36,210,142,13,162,152,61,29,208,95,160,88,59,142,218,248,176,184,200,5,80,78,117,73,234,82,219,203,46,58,134,233,246,73,113,9,116,12,42,159,117,44,111,227,247,177,236,74,135,83,195,60,78,43,203,224,138,181,235,195,88,189,88,121,195,162,193,45,49,132,254,212,208,63,86,211,138,25,227,185,69,129,126,127,224,45,29,47,31,24,167,99,59,78,155,133,16,17,234,166,35,218,1,9,132,218,173,228,228,155,120,196,81,144,150,66,154,132,167,65,15,156,185,90,50,114,217,45,153,190,121,198,44,6,154,103,186,69,98,156,170,65,122,48,120,120,232,128,222,163,189,55,145,60,131,148,27,203,246,240,105,225,58,11,77,227,22,174,223,192,238,69,253,37,132,246,199,69,11,191,95,196,31,102,16,156,30,17,191,81,7,113,199,48,141,96,54,64,192,136,145,216,168,102,24,153,108,105,253,241,23,116,5,156,136,149,201,145,182,32,22,95,3,254,241,72,155,252,154,234,148,29,194,118,97,217,163,244,240,15,57,98,60,90,198,209,11,235,197,31,131,68,115,189,73,107,201,61,45,134,29,163,224,144,159,153,168,232,171,99,100,5,26,134,126,36,122,101,241,158,10,199,11,169,184,167,199,7,141,145,160,239,82,242,132,180,26,117,162,84,45,72,51,147,198,29,248,31,233,50,12,91,40,221,221,133,247,220,19,170,221,183,112,148,222,36,158,54,216,229,208,20,150,156,122,34,90,14,244,83,182,78,151,174,68,68,170,39,66,42,207,100,97,116,144,20,140,223,70,176,127,138,94,120,158,233,229,81,199,187,127,1,229,166,139,36,105,255,14,200,165,19,116,72,191,51,13,68,17,42,231,150,98,176,114,140,113,151,181,224,166,139,145,74,33,228,133,216,137,154,223,134,60,212,21,19,218,138,43,251,141,164,240,28,39,122,29,144,44,57,175,171,219,152,20,101,238,144,18,34,242,133,81,227,121,81,14,162,135,247,3,207,162,43,228,179,124,127,109,164,187,223,117,240,72,112,227,119,231,82,174,5,144,163,120,181,34,62,104,90,167,126,64,212,140,111,9,32,40,72,149,197,56,210,195,102,158,14,208,189,64,236,147,58,193,82,67,51,81,78,143,36,97,223,40,62,22,182,114,242,190,92,6,13,203,169,35,235,32,19,29,1,84,75,226,176,243,44,156,81,87,21,27,24,2,173,111,38,147,1,11,143,25,20,83,123,18,178,49,113,47,252,31,175,76,230,124,169,153,131,69,124,171,148,43,26,238,5,157,130,76,207,253,93,247,243,78,188,134,120,134,252,177,188,229,138,115,99,103,104,96,74,222,240,3,123,148,147,186,18,36,112,118,229,34,153,96,44,135,154,23,242,128,156,3,22,16,171,137,223,0,230,121,92,224,17,6,237,160,255,178,83,203,246,66,17,214,187,35,6,91,2,206,158,232,215,210,199,253,31,238,65,217,72,22,243,117,29,119,89,195,110,33,227,94,18,1,232,97,253,97,240,144,183,112,120,124,113,20,169,86,63,12,140,30,181,151,155,222,211,110,202,253,197,178,252,12,13,88,25,124,62,123,250,137,70,115,74,49,113,25,213,117,196,19,86,82,223,239,158,145,221,103,30,153,103,79,66,235,26,134,84,194,151,156,223,251,18,104,221,90,246,5,49,153,186,172,9,122,50,17,240,239,185,232,62,153,95,107,204,125,66,50,183,175,23,30,167,40,41,108,151,54,26,169,36,1,205,252,194,235,11,49,171,140,22,157,61,115,252,134,217,4,158,64,134,42,133,153,100,21,164,184,141,23,209,152,245,253,108,176,25,30,207,16,172,9,177,94,157,53,223,109,126,78,116,87,193,245,61,237,16,221,55,248,22,192,40,219,89,42,126,224,38,53,160,105,97,2,149,183,241,105,81,108,93,220,194,8,188,1,73,90,219,91,222,207,196,36,48,108,86,13,25,200,94,18,42,150,245,70,26,84,254,187,160,196,25,26,230,238,76,103,109,246,254,203,146,67,13,210,169,65,199,12,7,30,202,219,92,188,198,142,142,203,86,253,241,231,55,111,127,233,65,204,173,56,183,88,146,190,131,220,184,0,17,138,125,98,114,27,154,84,5,183,67,111,49,2,52,74,213,233,23,123,23,200,245,138,169,60,78,127,132,96,132,61,27,91,143,60,23,17,98,24,57,254,191,219,105,175,78,225,41,197,197,134,14,129,45,195,99,5,64,193,40,70,97,187,93,211,184,224,99,10,177,145,79,15,171,71,207,159,202,44,68,93,111,255,240,20,121,241,27,165,66,188,132,91,216,225,12,68,221,144,122,214,173,205,161,175,178,41,119,237,34,192,209,127,171,118,187,117,3,169,49,56,121,170,26,20,249,242,170,100,154,167,166,86,231,195,133,215,212,114,208,0,86,255,211,43,11,164,236,15,166,4,195,81,174,218,170,112,192,19,37,15,73,195,213,61,150,219,51,60,65,8,156,43,241,11,192,228,191,24,96,19,115,42,207,123,87,22,157,216,3,204,233,90,137,27,173,16,63,249,187,163,9,146,109,24,131,143,93,133,139,137,131,197,109,163,0,19,101,131,53,254,233,165,156,148,28,139,10,23,47,177,86,101,32,253,120,12,121,104,176,38,121,35,220,31,99,87,16,249,208,89,145,8,9,188,109,62,80,96,131,188,240,140,6,167,48,142,66,160,190,220,169,223,13,70,43,254,28,53,234,91,143,62,55,55,91,7,211,218,178,16,236,170,38,100,193,198,152,2,34,57,221,115,221,75,19,192,155,161,224,221,71,126,113,210,47,224,194,255,20,192,27,41,116,85,38,166,219,173,151,123,141,164,219,186,209,29,42,109,255,64,157,19,66,111,136,94,233,232,56,152,14,21,194,94,248,86,21,5,187,190,155,71,21,140,101,173,188,144,4,155,24,64,204,47,203,190,6,10,33,28,125,49,5,211,226,43,194,170,180,241,203,134,58,46,247,78,110,20,75,158,84,61,178,128,255,195,125,135,109,227,174,20,98,218,166,216,34,107,250,86,46,225,33,52,180,232,77,7,216,220,121,71,50,190,45,75,123,173,177,187,213,168,244,213,42,252,254,171,199,132,150,57,88,50,67,162,141,80,242,244,105,140,215,241,167,73,140,102,0,72,145,98,58,10,56,58,132,84,148,134,249,111,36,41,246,221,171,41,227,203,25,193,74,8,244,201,249,34,208,104,2,14,222,33,19,167,166,6,90,61,219,254,13,44,249,48,189,75,192,183,94,241,238,8,100,174,183,154,150,182,44,40,19,155,91,214,93,195,181,66,65,162,162,179,147,229,132,139,222,79,168,55,223,208,17,25,26,181,182,103,111,114,1,244,123,92,137,189,246,11,52,33,224,13,225,242,242,178,111,209,0,236,144,253,212,38,35,205,141,189,216,89,41,61,56,7,243,18,181,21,16,134,174,126,175,218,43,34,155,224,29,66,54,171,16,191,171,39,142,121,37,150,88,87,229,87,227,101,219,36,223,15,151,153,229,226,193,136,196,61,188,141,35,78,48,255,187,180,65,159,140,185,57,210,33,94,220,150,35,37,139,47,20,112,193,245,155,18,221,241,92,157,149,143,66,220,156,20,69,183,252,153,131,74,135,11,178,249,47,204,65,117,48,118,104,132,170,173,122,39,123,112,149,207,230,93,125,186,90,28,115,217,13,67,25,148,229,240,37,38,77,94,13,124,239,92,24,223,32,55,162,88,116,164,51,207,133,192,83,34,219,42,99,195,19,160,12,252,123,119,18,46,37,248,114,53,162,148,148,164,4,59,95,44,87,164,236,64,45,214,198,60,175,253,214,97,92,95,13,48,142,163,203,25,2,168,218,170,118,171,183,129,78,71,110,101,75,189,185,190,135,23,221,44,145,30,162,100,12,70,202,64,44,98,236,223,242,220,170,113,122,89,44,11,178,147,239,57,253,132,61,199,133,93,103,104,45,36,39,160,251,60,36,170,181,87,254,161,57,164,18,19,18,147,222,61,211,31,172,12,68,224,52,74,22,47,134,195,228,105,115,226,205,90,41,92,100,207,151,186,133,128,154,70,194,172,193,19,177,168,190,251,231,161,138,26,1,167,88,141,252,131,53,114,158,20,202,14,78,113,73,100,143,231,214,235,40,143,60,236,92,225,71,210,122,185,10,63,96,32,126,65,153,205,173,43,206,153,98,39,8,101,202,193,131,12,223,23,68,169,50,17,122,136,40,62,47,88,79,223,186,171,9,206,90,130,235,153,247,21,113,21,252,28,56,200,215,49,111,225,213,136,132,113,134,15,25,35,113,78,111,19,56,204,75,179,202,167,238,90,160,253,232,168,12,136,76,133,71,70,163,81,189,159,122,103,42,229,132,51,53,167,187,210,72,180,193,221,84,88,174,24,77,252,101,210,72,158,234,222,116,221,170,19,95,251,176,47,135,3,248,88,30,168,17,208,200,184,129,74,182,254,38,99,190,39,51,248,223,17,84,155,12,221,50,81,9,134,51,26,121,48,211,105,113,22,32,173,177,113,180,248,18,234,83,235,247,113,6,105,245,129,183,162,160,150,150,232,12,253,172,11,68,30,54,181,179,224,61,120,125,197,85,65,80,189,30,211,191,203,170,203,29,151,140,102,98,21,69,72,132,24,68,45,147,245,140,150,16,236,239,114,110,202,176,43,232,157,148,237,84,96,97,96,214,183,129,47,203,142,183,65,103,109,32,115,201,174,80,248,19,180,88,208,114,242,87,137,41,3,49,99,110,211,160,188,109,29,102,214,93,84,168,73,7,11,154,99,48,9,176,192,214,149,199,207,158,249,44,203,192,161,46,130,177,160,215,192,134,75,79,201,166,154,144,210,34,92,46,208,191,85,177,160,95,151,122,65,241,228,232,31,62,101,1,183,52,197,3,54,225,234,252,41,215,202,121,72,180,233,249,254,56,242,41,22,11,155,179,237,25,123,226,142,66,96,244,127,64,245,176,204,200,47,30,34,29,37,160,121,61,21,98,237,172,215,151,61,73,70,152,193,88,214,131,156,96,118,226,99,51,120,188,70,158,166,55,40,105,99,44,105,255,70,123,130,242,21,44,32,50,78,175,31,41,4,181,107,169,11,242,157,191,95,104,202,229,156,91,158,238,177,197,158,25,129,255,9,132,168,57,110,140,115,140,76,160,76,13,210,35,113,151,11,12,72,25,197,204,177,159,38,51,80,2,3,213,248,59,65,157,209,227,48,89,180,49,205,249,76,229,166,171,137,78,89,106,169,145,101,136,71,80,1,220,83,173,174,104,119,24,2,5,162,36,220,116,170,221,32,30,125,86,62,41,214,57,224,116,202,155,190,219,179,239,184,193,247,76,174,45,97,21,206,153,95,5,237,73,72,1,141,240,68,197,84,102,106,239,212,203,202,186,198,145,181,109,147,217,251,131,136,202,142,51,138,4,40,60,211,250,246,13,121,167,105,137,208,103,89,60,79,8,123,7,142,110,142,119,130,74,12,190,106,80,206,43,144,51,14,225,85,120,122,23,21,214,146,254,107,71,13,136,45,147,115,170,118,8,215,142,184,158,141,146,30,255,173,51,235,39,58,186,190,13,166,222,195,212,27,109,71,107,63,47,49,175,66,208,185,54,15,151,220,65,240,188,117,159,173,215,199,202,147,183,252,72,19,32,235,198,240,196,231,240,133,169,230,74,191,210,225,45,128,193,1,107,147,172,144,22,195,116,42,164,74,176,110,208,114,234,250,89,115,79,77,194,79,94,178,148,61,248,146,108,245,236,219,138,172,252,178,37,204,174,194,3,8,62,4,131,122,188,231,125,225,48,166,153,88,147,250,211,252,157,57,67,165,141,35,225,66,95,60,192,209,169,54,124,209,47,241,215,12,63,100,180,66,208,235,122,27,62,22,171,111,169,143,146,33,170,120,23,93,79,180,44,174,227,145,104,208,49,70,88,134,18,102,207,51,228,237,27,142,166,62,242,26,139,254,62,168,10,42,154,189,134,177,248,119,21,8,199,68,186,27,241,181,106,82,14,220,133,239,200,24,227,214,122,91,210,85,49,105,247,249,51,185,136,51,216,170,245,27,86,162,70,132,167,178,223,149,23,73,212,37,180,135,229,177,99,86,225,196,241,183,162,205,253,56,221,103,55,76,241,195,91,36,62,113,46,5,134,37,187,251,110,173,4,104,85,54,144,221,197,156,161,97,28,155,129,60,122,112,87,120,79,176,92,137,24,188,13,180,96,181,14,72,199,118,129,177,150,153,207,241,53,104,16,61,140,215,70,102,204,150,189,145,133,35,173,233,242,213,122,135,147,180,21,6,124,236,20,125,106,208,33,228,221,106,235,89,215,186,82,159,62,212,178,185,231,207,45,36,4,187,146,177,253,128,59,15,228,128,147,67,158,55,75,198,112,247,48,179,142,112,75,9,2,61,237,6,93,27,215,86,168,15,239,36,44,197,81,4,94,48,185,251,125,102,73,133,53,44,3,154,235,59,250,176,72,43,232,180,195,46,88,77,93,219,22,203,35,111,70,36,16,136,139,151,150,68,64,28,215,67,55,245,235,231,55,87,39,72,116,217,112,37,219,236,87,137,194,14,245,18,22,81,213,203,213,90,123,116,122,223,65,247,227,208,95,232,67,202,24,223,249,100,91,87,79,108,59,49,70,218,171,101,24,106,136,200,179,18,251,196,148,8,52,218,232,66,163,160,124,30,140,187,179,74,189,64,130,151,77,22,204,242,162,255,150,164,25,79,49,239,200,174,7,55,206,183,206,179,235,130,213,61,164,53,5,166,179,241,80,37,65,48,189,56,170,166,110,0,31,194,70,52,37,232,186,215,102,45,155,248,155,152,138,110,223,218,92,227,135,49,144,223,68,214,18,126,177,141,130,61,135,122,31,142,157,115,124,40,109,1,74,158,187,227,120,144,246,32,40,168,252,90,160,236,14,130,88,230,75,78,50,211,162,231,223,251,133,185,98,224,196,27,98,76,3,92,116,219,135,19,34,169,134,83,73,47,237,75,4,132,88,148,112,183,189,92,107,86,218,140,167,134,241,150,133,69,193,176,41,193,126,87,98,62,188,202,131,10,235,38,175,16,243,218,177,59,51,245,144,190,221,233,242,128,203,19,158,133,63,202,213,79,141,88,71,191,125,221,235,20,81,74,161,239,110,16,226,189,108,58,201,202,63,163,240,53,189,47,24,255,70,24,1,108,225,92,79,210,216,33,14,36,158,219,51,242,131,58,17,71,114,212,208,200,178,194,80,214,148,102,118,67,169,9,3,242,158,176,249,13,157,47,228,221,45,14,168,85,164,21,225,42,250,118,227,240,38,151,119,62,179,44,139,1,255,208,55,40,11,117,169,156,97,204,124,169,157,117,171,42,150,163,9,24,208,189,8,150,72,7,78,243,48,11,9,114,127,25,219,67,253,244,0,203,121,68,123,49,79,144,23,55,239,193,201,86,201,236,74,196,35,202,20,144,215,43,64,89,83,216,109,95,142,68,100,41,117,80,135,51,222,91,246,174,97,213,39,28,223,148,75,125,161,40,199,114,205,125,53,195,41,11,129,217,25,53,85,86,251,54,48,107,229,245,154,77,221,218,5,90,94,69,226,250,37,139,245,122,81,132,253,222,55,2,94,175,107,198,231,236,34,233,57,95,173,99,123,125,55,89,164,233,203,227,136,147,185,180,154,212,68,220,226,81,89,214,201,107,189,123,144,194,200,229,238,112,162,31,227,223,116,235,159,124,159,158,228,43,79,8,136,217,8,68,99,180,89,93,119,171,128,30,80,34,59,1,14,184,49,209,4,87,106,139,221,111,63,70,253,111,126,226,80,59,40,196,105,45,73,107,189,77,229,118,120,26,34,103,167,101,188,101,198,190,244,40,238,227,167,80,65,46,88,42,108,92,169,180,103,97,110,159,214,170,52,30,238,121,223,55,82,181,132,188,128,159,25,220,45,160,206,172,224,74,182,170,176,225,242,42,180,222,235,10,45,99,207,102,137,140,59,253,201,254,76,174,128,81,71,229,34,46,246,117,120,198,101,109,190,14,147,95,182,247,250,27,151,21,70,249,26,227,183,23,122,187,40,133,243,163,134,10,133,93,242,8,141,169,254,167,146,182,13,12,76,100,97,117,223,223,139,161,214,163,95,180,227,229,208,61,194,114,146,128,244,93,191,197,200,197,162,17,135,242,210,174,143,215,30,36,153,215,108,90,59,144,227,216,75,103,255,114,60,43,214,97,102,230,147,20,246,184,149,24,138,153,169,12,140,73,91,197,247,107,213,75,7,63,202,141,158,2,36,118,124,232,241,93,145,66,58,137,4,11,102,141,27,42,150,183,43,54,222,231,20,11,36,158,101,162,91,232,130,113,58,250,84,243,200,200,251,210,87,237,128,197,19,146,194,4,47,220,92,83,49,166,98,227,251,230,124,16,205,48,214,162,146,19,243,143,250,156,158,90,234,202,189,219,13,199,237,74,117,186,134,94,48,181,169,207,11,35,237,238,236,131,242,81,225,26,151,3,168,238,91,72,145,14,1,18,196,52,4,138,4,9,46,78,20,53,80,138,196,31,239,192,196,22,155,85,112,9,209,94,12,102,76,74,22,243,130,32,18,200,102,124,207,24,191,15,238,167,154,254,241,9,169,40,67,202,143,208,180,89,158,22,214,64,116,242,79,255,60,80,22,119,149,214,103,76,9,28,223,166,154,249,197,192,23,144,30,9,171,57,61,86,242,176,113,193,176,218,176,47,109,23,164,248,204,109,18,98,24,78,149,55,122,184,106,158,172,194,225,233,55,64,234,134,26,113,81,249,214,80,207,49,1,193,41,75,196,60,117,77,84,18,98,218,207,119,100,1,228,175,177,8,246,72,145,51,97,240,107,76,255,192,6,225,161,204,60,13,145,212,250,11,206,123,14,253,223,208,207,204,138,174,200,243,93,219,125,196,229,4,184,184,172,161,145,168,29,207,101,155,178,50,240,65,135,205,181,203,65,181,35,252,110,255,245,73,212,38,189,114,151,237,3,251,156,67,62,47,162,208,168,119,230,57,140,230,159,239,163,40,63,17,209,242,100,49,167,11,167,87,45,120,170,67,235,15,195,46,86,178,226,100,231,205,120,80,10,92,100,193,248,142,149,79,14,206,64,114,7,215,132,179,23,21,84,131,76,198,51,193,180,168,253,115,126,30,178,235,10,84,181,143,189,188,122,208,22,63,80,161,96,202,203,252,211,58,43,17,71,21,93,216,35,138,57,139,156,103,22,90,83,167,202,219,159,19,2,110,181,142,119,188,226,140,123,161,43,150,78,222,113,7,45,59,175,59,162,98,185,113,61,90,2,59,19,37,90,241,70,36,186,155,138,61,148,126,252,230,54,169,21,10,141,35,53,139,41,179,56,38,44,86,211,35,187,234,90,25,133,240,60,30,203,62,144,197,177,233,253,154,101,136,220,177,61,0,151,121,38,250,146,144,70,202,126,57,240,3,179,249,198,248,125,132,196,230,231,192,239,197,45,152,4,170,177,59,208,224,100,231,7,247,203,183,227,210,185,150,90,61,13,121,255,246,233,144,137,16,152,253,219,204,28,81,230,248,74,96,63,81,118,246,49,61,144,103,128,241,111,156,184,172,212,124,198,237,214,113,14,242,79,243,141,71,0,40,10,55,222,88,190,137,194,40,180,200,22,225,95,218,149,4,70,237,7,89,11,238,247,132,152,4,20,105,174,124,151,114,81,243,187,208,216,235,186,139,251,141,89,10,239,144,196,141,111,196,86,111,73,109,136,16,123,95,122,14,72,71,91,229,8,220,186,175,85,197,201,136,241,203,45,78,89,99,220,161,221,35,250,160,198,31,205,6,246,232,224,216,102,252,203,75,189,148,5,19,220,160,93,236,172,227,242,3,182,57,64,110,88,94,223,70,165,164,46,69,115,87,82,88,119,233,179,62,182,2,57,73,65,55,103,229,91,197,53,96,69,3,212,77,20,254,46,92,32,166,4,131,116,40,207,197,58,92,90,41,193,38,160,143,54,247,133,226,116,13,1,46,62,134,147,8,236,111,114,121,195,127,182,147,85,196,240,75,159,116,160,132,188,120,35,107,82,28,193,94,106,139,77,187,178,175,250,156,19,145,90,19,213,58,198,79,219,176,194,253,110,254,40,203,25,8,85,170,253,110,226,138,3,40,73,154,54,48,214,80,220,58,124,167,51,128,74,212,45,12,161,103,216,186,127,118,57,197,113,255,73,106,13,169,153,252,29,97,115,114,108,30,122,2,4,34,187,0,143,106,235,191,65,157,100,86,180,38,83,114,0,231,37,80,51,120,148,187,39,187,189,33,245,19,133,252,62,145,27,54,236,191,156,100,143,156,150,37,37,65,137,25,246,18,19,125,76,76,3,18,139,218,188,53,232,205,222,0,34,180,73,234,169,103,194,212,7,51,87,82,251,120,4,52,216,254,0,223,92,12,115,13,132,49,250,240,235,98,188,165,128,245,232,107,35,40,39,151,116,54,104,146,168,89,43,76,199,159,119,97,24,106,154,166,37,71,64,182,91,108,41,184,51,192,218,232,17,142,49,81,30,90,242,19,43,105,159,96,121,162,197,211,236,186,161,172,116,40,229,12,244,94,76,117,99,16,83,98,228,142,35,191,252,191,70,188,185,193,144,207,72,192,202,109,92,243,36,41,47,210,93,15,77,71,36,11,67,71,1,189,124,214,199,160,179,187,121,17,54,48,122,212,200,19,138,206,20,244,97,216,66,140,143,31,224,39,215,141,47,73,136,209,43,110,108,200,87,185,197,238,231,124,56,186,64,54,243,30,211,196,37,214,118,102,111,148,145,14,245,126,64,61,31,125,142,63,96,57,170,214,229,36,119,18,7,88,122,85,8,26,120,167,170,236,167,134,62,209,241,27,244,116,83,228,77,116,18,225,32,239,172,125,176,41,87,216,154,229,10,165,65,155,77,203,214,216,112,70,225,147,39,42,14,54,225,231,161,5,4,226,255,25,114,141,152,21,153,165,223,107,82,188,235,236,97,27,98,132,200,138,142,26,55,210,9,242,247,13,220,254,114,50,131,85,74,191,231,47,232,34,50,11,132,165,41,4,188,58,10,125,23,242,54,24,87,61,248,209,195,118,90,12,39,100,196,88,13,219,114,247,225,23,201,0,31,194,43,65,80,204,167,69,95,208,189,95,143,29,131,244,195,212,188,9,50,192,98,150,95,96,153,140,98,45,129,8,249,188,160,66,137,11,60,244,205,202,95,191,162,130,170,232,212,242,134,246,120,114,10,142,213,118,23,49,79,154,78,175,118,49,25,23,175,151,161,145,126,242,181,230,173,182,25,235,248,147,188,176,13,164,20,173,22,141,28,98,202,67,94,252,26,219,156,26,243,197,106,84,215,123,35,248,189,76,232,77,148,68,27,53,182,124,99,22,56,3,81,42,69,170,108,65,142,255,99,210,190,157,221,213,45,184,121,84,84,213,127,73,54,149,87,228,14,61,159,43,135,15,137,167,238,33,20,144,29,152,157,66,134,246,239,91,16,178,186,104,251,3,158,39,119,32,233,251,156,202,161,76,33,200,151,244,161,71,66,255,150,198,195,38,34,163,51,141,78,79,70,59,182,88,160,221,213,245,101,95,209,76,28,44,36,77,132,65,80,245,129,40,71,255,243,137,10,60,183,222,205,249,235,39,108,216,82,113,238,230,248,100,144,94,127,37,179,212,255,251,250,49,151,76,196,233,131,28,163,182,176,195,146,175,117,238,110,13,138,83,162,46,104,34,207,74,219,23,21,165,221,108,194,232,151,203,104,43,252,125,160,19,162,175,140,4,234,76,219,140,158,54,50,98,236,124,243,123,187,237,49,181,154,161,98,216,76,244,111,145,58,196,254,71,13,200,242,134,38,48,140,213,239,214,137,86,92,213,38,9,208,204,239,233,175,99,25,224,65,219,67,127,20,126,252,176,47,199,246,173,182,169,240,108,45,165,181,129,94,135,164,206,189,228,102,138,253,168,168,77,92,140,160,50,182,86,20,115,67,36,32,154,142,106,114,157,190,247,43,225,83,144,219,162,106,144,167,155,39,80,66,61,69,203,57,20,37,41,95,175,61,49,159,9,116,184,77,14,237,144,241,240,218,204,11,244,225,217,229,69,206,238,95,21,0,236,6,193,125,180,32,250,190,247,136,185,191,8,104,89,148,65,248,54,124,31,58,119,126,222,194,160,211,56,80,92,96,159,255,134,196,242,206,35,6,11,8,119,226,90,51,76,229,60,124,72,210,118,47,82,250,79,135,245,152,245,204,108,220,85,147,54,40,24,186,13,47,193,129,7,37,222,152,41,170,15,76,221,26,37,69,229,150,252,176,102,21,92,62,6,35,52,229,114,45,134,122,20,230,218,101,112,123,22,96,128,164,143,115,169,108,91,235,238,9,253,105,137,124,182,137,253,110,227,5,107,121,52,144,225,76,35};

// The ranking tile of 128x128 pixels.
// Each pixel contains an optimized 8d key used to scramble the sequence.
// The keys are optimized for all the powers of two spp below 8in 8d.
static const int rankingTile[128*128*8] = {2,2,6,6,2,2,0,0,5,5,6,6,6,6,5,5,2,2,4,4,3,3,1,1,0,0,4,4,4,4,7,7,6,6,0,0,3,3,2,2,0,0,4,4,0,0,3,3,7,7,1,1,0,0,6,6,2,2,1,1,4,4,4,4,4,4,2,2,2,2,4,4,6,6,6,6,4,4,1,1,5,5,1,1,6,6,5,5,0,0,3,3,4,4,7,7,0,0,6,6,0,0,2,2,3,3,6,6,2,2,5,5,1,1,5,5,6,6,0,0,1,1,1,1,4,4,0,0,6,6,3,3,6,6,1,1,4,4,5,5,6,6,1,1,7,7,3,3,7,7,0,0,3,3,6,6,7,7,7,7,2,2,6,6,1,1,2,2,3,3,5,5,4,4,0,0,3,3,1,1,3,3,6,6,5,5,4,4,4,4,0,0,7,7,1,1,1,1,0,0,0,0,3,3,0,0,1,1,7,7,3,3,2,2,7,7,5,5,2,2,1,1,5,5,7,7,0,0,5,5,3,3,0,0,3,3,4,4,3,3,2,2,1,1,6,6,5,5,6,6,5,5,0,0,0,0,6,6,5,5,5,5,7,7,1,1,4,4,2,2,3,3,3,3,0,0,7,7,4,4,0,0,2,2,5,5,5,5,6,6,0,0,1,1,5,5,2,2,7,7,4,4,2,2,6,6,7,7,7,7,5,5,0,0,1,1,0,0,7,7,3,3,3,3,2,2,2,2,2,2,3,3,0,0,7,7,5,5,7,7,0,0,4,4,2,2,3,3,6,6,2,2,2,2,7,7,7,7,2,2,4,4,5,5,6,6,1,1,0,0,3,3,7,7,0,0,7,7,4,4,0,0,4,4,7,7,3,3,1,1,0,0,2,2,0,0,2,2,0,0,1,1,6,6,0,0,1,1,4,4,4,4,6,6,3,3,4,4,6,6,3,3,2,2,4,4,2,2,3,3,3,3,5,5,4,4,0,0,7,7,6,6,3,3,7,7,1,1,2,2,3,3,6,6,5,5,2,2,6,6,2,2,7,7,1,1,1,1,0,0,2,2,2,2,1,1,1,1,5,5,7,7,0,0,4,4,0,0,5,5,0,0,2,2,1,1,1,1,5,5,3,3,6,6,2,2,2,2,1,1,1,1,6,6,7,7,3,3,0,0,3,3,3,3,5,5,3,3,7,7,3,3,3,3,7,7,4,4,6,6,5,5,5,5,2,2,5,5,1,1,2,2,4,4,3,3,1,1,7,7,0,0,0,0,0,0,4,4,4,4,4,4,2,2,6,6,5,5,2,2,0,0,4,4,5,5,0,0,3,3,3,3,6,6,1,1,7,7,3,3,5,5,1,1,4,4,7,7,6,6,6,6,2,2,5,5,1,1,0,0,4,4,4,4,2,2,2,2,0,0,0,0,4,4,0,0,6,6,4,4,0,0,7,7,7,7,6,6,6,6,3,3,3,3,6,6,4,4,4,4,0,0,2,2,7,7,2,2,5,5,4,4,3,3,5,5,3,3,1,1,6,6,0,0,3,3,1,1,3,3,6,6,5,5,0,0,1,1,3,3,4,4,7,7,2,2,1,1,4,4,6,6,4,4,5,5,7,7,5,5,4,4,3,3,6,6,6,6,6,6,6,6,0,0,4,4,0,0,2,2,6,6,3,3,5,5,6,6,5,5,6,6,1,1,4,4,7,7,2,2,1,1,3,3,5,5,4,4,0,0,0,0,6,6,5,5,1,1,1,1,5,5,0,0,3,3,4,4,6,6,2,2,4,4,1,1,2,2,1,1,5,5,2,2,1,1,3,3,0,0,4,4,2,2,7,7,1,1,3,3,1,1,1,1,7,7,3,3,1,1,7,7,6,6,5,5,0,0,3,3,5,5,3,3,0,0,0,0,6,6,6,6,3,3,3,3,0,0,0,0,5,5,6,6,3,3,0,0,7,7,3,3,2,2,0,0,5,5,7,7,1,1,1,1,6,6,3,3,2,2,5,5,5,5,0,0,2,2,6,6,1,1,0,0,5,5,0,0,6,6,4,4,3,3,3,3,0,0,0,0,1,1,3,3,5,5,7,7,6,6,4,4,1,1,5,5,5,5,7,7,5,5,4,4,3,3,1,1,0,0,7,7,1,1,5,5,6,6,7,7,7,7,5,5,1,1,5,5,6,6,2,2,7,7,1,1,4,4,6,6,4,4,1,1,4,4,0,0,0,0,1,1,0,0,2,2,6,6,6,6,7,7,6,6,2,2,0,0,4,4,1,1,5,5,0,0,6,6,7,7,4,4,4,4,0,0,0,0,0,0,5,5,7,7,3,3,6,6,4,4,6,6,0,0,6,6,5,5,0,0,5,5,4,4,4,4,4,4,7,7,6,6,7,7,6,6,7,7,7,7,0,0,2,2,2,2,3,3,7,7,5,5,5,5,3,3,3,3,0,0,6,6,5,5,4,4,6,6,2,2,4,4,4,4,3,3,3,3,4,4,7,7,6,6,5,5,5,5,7,7,0,0,3,3,7,7,2,2,3,3,0,0,7,7,1,1,5,5,3,3,6,6,2,2,3,3,1,1,3,3,4,4,0,0,1,1,3,3,4,4,5,5,6,6,2,2,6,6,4,4,6,6,7,7,2,2,1,1,6,6,2,2,1,1,2,2,6,6,6,6,0,0,6,6,1,1,4,4,2,2,7,7,3,3,6,6,7,7,5,5,0,0,0,0,7,7,1,1,1,1,0,0,2,2,3,3,0,0,3,3,1,1,1,1,1,1,2,2,2,2,7,7,5,5,6,6,6,6,0,0,1,1,6,6,6,6,1,1,0,0,6,6,3,3,0,0,7,7,4,4,2,2,0,0,2,2,5,5,0,0,4,4,0,0,3,3,0,0,5,5,5,5,0,0,0,0,5,5,4,4,1,1,0,0,5,5,2,2,5,5,1,1,0,0,7,7,4,4,1,1,2,2,0,0,2,2,1,1,5,5,7,7,4,4,6,6,6,6,6,6,5,5,6,6,7,7,0,0,2,2,4,4,4,4,1,1,0,0,3,3,3,3,5,5,5,5,1,1,0,0,7,7,7,7,4,4,1,1,6,6,4,4,1,1,7,7,0,0,3,3,5,5,2,2,6,6,3,3,0,0,0,0,6,6,3,3,0,0,1,1,2,2,2,2,6,6,2,2,1,1,0,0,6,6,4,4,3,3,3,3,2,2,7,7,4,4,1,1,4,4,6,6,2,2,1,1,7,7,1,1,0,0,2,2,6,6,2,2,3,3,0,0,3,3,5,5,5,5,3,3,5,5,0,0,0,0,6,6,3,3,7,7,1,1,3,3,0,0,3,3,6,6,7,7,1,1,7,7,3,3,5,5,3,3,5,5,1,1,1,1,4,4,5,5,3,3,0,0,1,1,6,6,7,7,0,0,4,4,2,2,0,0,4,4,0,0,2,2,2,2,5,5,1,1,2,2,1,1,1,1,6,6,1,1,6,6,0,0,5,5,5,5,5,5,1,1,1,1,5,5,4,4,2,2,5,5,6,6,4,4,1,1,1,1,1,1,6,6,0,0,2,2,5,5,7,7,0,0,0,0,4,4,6,6,0,0,0,0,6,6,2,2,4,4,2,2,0,0,4,4,2,2,5,5,1,1,7,7,5,5,5,5,5,5,2,2,4,4,4,4,0,0,7,7,6,6,7,7,5,5,7,7,4,4,7,7,6,6,4,4,1,1,3,3,7,7,1,1,3,3,1,1,4,4,5,5,1,1,0,0,0,0,1,1,3,3,1,1,7,7,7,7,1,1,7,7,1,1,7,7,0,0,4,4,7,7,5,5,3,3,2,2,2,2,0,0,2,2,2,2,0,0,7,7,2,2,0,0,5,5,5,5,7,7,2,2,6,6,6,6,6,6,1,1,0,0,2,2,3,3,5,5,5,5,2,2,5,5,6,6,1,1,6,6,0,0,0,0,1,1,6,6,4,4,4,4,0,0,0,0,3,3,0,0,1,1,5,5,6,6,4,4,2,2,4,4,5,5,7,7,3,3,6,6,4,4,3,3,7,7,6,6,7,7,7,7,0,0,3,3,1,1,6,6,7,7,2,2,4,4,5,5,7,7,4,4,5,5,1,1,5,5,1,1,4,4,2,2,3,3,1,1,5,5,4,4,4,4,0,0,0,0,7,7,7,7,4,4,2,2,5,5,4,4,6,6,7,7,0,0,4,4,4,4,1,1,6,6,5,5,6,6,4,4,6,6,5,5,5,5,3,3,0,0,5,5,2,2,7,7,5,5,1,1,5,5,3,3,7,7,2,2,2,2,1,1,2,2,1,1,4,4,1,1,2,2,5,5,4,4,1,1,4,4,0,0,7,7,2,2,6,6,0,0,0,0,4,4,0,0,0,0,5,5,3,3,1,1,2,2,5,5,3,3,7,7,7,7,1,1,3,3,2,2,3,3,7,7,6,6,4,4,6,6,0,0,2,2,6,6,2,2,4,4,3,3,7,7,2,2,5,5,5,5,3,3,3,3,0,0,4,4,1,1,0,0,7,7,1,1,6,6,1,1,4,4,5,5,1,1,3,3,1,1,2,2,1,1,2,2,5,5,2,2,3,3,2,2,6,6,6,6,0,0,7,7,3,3,1,1,0,0,5,5,3,3,3,3,2,2,3,3,4,4,6,6,0,0,3,3,4,4,5,5,0,0,1,1,7,7,0,0,2,2,7,7,4,4,3,3,5,5,6,6,0,0,2,2,7,7,1,1,3,3,4,4,2,2,5,5,2,2,2,2,6,6,4,4,3,3,5,5,7,7,7,7,1,1,5,5,6,6,6,6,4,4,6,6,6,6,6,6,5,5,0,0,0,0,5,5,2,2,7,7,0,0,6,6,4,4,7,7,2,2,2,2,0,0,5,5,0,0,2,2,2,2,6,6,1,1,3,3,7,7,2,2,0,0,0,0,2,2,7,7,2,2,2,2,0,0,1,1,0,0,0,0,4,4,6,6,7,7,4,4,2,2,5,5,0,0,4,4,1,1,2,2,0,0,0,0,7,7,4,4,1,1,0,0,6,6,1,1,3,3,1,1,4,4,1,1,7,7,1,1,6,6,3,3,7,7,2,2,2,2,1,1,0,0,1,1,6,6,4,4,6,6,6,6,0,0,7,7,6,6,0,0,5,5,3,3,5,5,0,0,3,3,5,5,5,5,7,7,1,1,1,1,1,1,4,4,4,4,4,4,3,3,4,4,2,2,1,1,1,1,7,7,4,4,4,4,5,5,5,5,1,1,7,7,0,0,4,4,3,3,6,6,3,3,1,1,5,5,3,3,2,2,1,1,4,4,1,1,0,0,0,0,0,0,3,3,5,5,2,2,1,1,2,2,3,3,4,4,5,5,5,5,2,2,6,6,4,4,0,0,5,5,5,5,2,2,1,1,0,0,7,7,4,4,3,3,6,6,4,4,7,7,4,4,4,4,1,1,0,0,5,5,2,2,4,4,6,6,5,5,2,2,1,1,0,0,5,5,0,0,0,0,4,4,6,6,5,5,6,6,4,4,1,1,7,7,2,2,1,1,4,4,6,6,3,3,2,2,4,4,0,0,3,3,6,6,0,0,4,4,5,5,2,2,1,1,7,7,5,5,2,2,2,2,0,0,0,0,2,2,2,2,1,1,7,7,4,4,4,4,6,6,4,4,7,7,2,2,5,5,5,5,1,1,4,4,7,7,0,0,7,7,0,0,7,7,5,5,2,2,7,7,4,4,4,4,4,4,1,1,3,3,0,0,2,2,3,3,4,4,6,6,5,5,2,2,2,2,0,0,1,1,0,0,6,6,7,7,4,4,2,2,0,0,6,6,1,1,6,6,4,4,7,7,3,3,1,1,3,3,3,3,0,0,1,1,4,4,0,0,6,6,2,2,2,2,3,3,6,6,4,4,7,7,3,3,3,3,5,5,1,1,7,7,3,3,0,0,7,7,3,3,6,6,6,6,3,3,0,0,1,1,3,3,5,5,6,6,2,2,3,3,4,4,0,0,7,7,1,1,2,2,5,5,2,2,5,5,3,3,2,2,1,1,6,6,6,6,1,1,0,0,6,6,0,0,3,3,1,1,2,2,5,5,4,4,6,6,6,6,6,6,3,3,1,1,7,7,2,2,3,3,5,5,2,2,2,2,1,1,3,3,2,2,3,3,5,5,4,4,4,4,0,0,6,6,4,4,4,4,7,7,2,2,0,0,6,6,3,3,1,1,6,6,6,6,6,6,2,2,4,4,1,1,1,1,1,1,7,7,0,0,5,5,3,3,1,1,1,1,0,0,2,2,5,5,7,7,0,0,5,5,2,2,4,4,0,0,3,3,6,6,4,4,6,6,6,6,5,5,4,4,0,0,1,1,5,5,3,3,0,0,2,2,4,4,4,4,4,4,6,6,3,3,6,6,2,2,6,6,0,0,7,7,2,2,0,0,0,0,2,2,4,4,6,6,4,4,3,3,2,2,4,4,1,1,1,1,5,5,2,2,3,3,5,5,6,6,4,4,0,0,5,5,5,5,5,5,0,0,1,1,7,7,1,1,1,1,1,1,1,1,6,6,2,2,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,2,2,5,5,4,4,5,5,0,0,2,2,6,6,1,1,5,5,0,0,0,0,3,3,5,5,5,5,0,0,7,7,7,7,7,7,0,0,3,3,2,2,1,1,3,3,2,2,5,5,5,5,5,5,5,5,7,7,6,6,2,2,0,0,0,0,2,2,0,0,7,7,6,6,7,7,1,1,1,1,6,6,7,7,3,3,4,4,5,5,4,4,6,6,4,4,2,2,2,2,3,3,4,4,0,0,0,0,1,1,5,5,4,4,4,4,0,0,0,0,1,1,2,2,1,1,5,5,1,1,3,3,5,5,7,7,4,4,5,5,5,5,2,2,6,6,2,2,3,3,2,2,3,3,5,5,6,6,3,3,7,7,1,1,7,7,1,1,5,5,3,3,4,4,5,5,0,0,5,5,0,0,2,2,1,1,7,7,3,3,1,1,0,0,5,5,4,4,3,3,4,4,6,6,2,2,6,6,3,3,0,0,1,1,5,5,4,4,2,2,7,7,1,1,1,1,2,2,4,4,7,7,2,2,2,2,2,2,0,0,3,3,4,4,7,7,7,7,0,0,5,5,1,1,5,5,0,0,1,1,0,0,4,4,2,2,3,3,3,3,6,6,5,5,5,5,6,6,5,5,1,1,3,3,5,5,1,1,3,3,5,5,2,2,3,3,7,7,6,6,6,6,3,3,7,7,2,2,0,0,0,0,0,0,3,3,1,1,2,2,4,4,7,7,3,3,5,5,1,1,1,1,2,2,7,7,7,7,7,7,7,7,1,1,4,4,6,6,7,7,2,2,3,3,1,1,1,1,3,3,2,2,2,2,3,3,2,2,4,4,6,6,3,3,0,0,2,2,4,4,1,1,3,3,4,4,2,2,1,1,5,5,6,6,7,7,1,1,0,0,5,5,2,2,5,5,6,6,7,7,5,5,5,5,6,6,5,5,4,4,7,7,4,4,3,3,3,3,6,6,2,2,6,6,2,2,3,3,0,0,6,6,4,4,3,3,2,2,1,1,4,4,4,4,4,4,6,6,3,3,1,1,6,6,3,3,3,3,1,1,5,5,3,3,6,6,4,4,6,6,6,6,5,5,4,4,2,2,6,6,2,2,4,4,0,0,3,3,5,5,4,4,2,2,1,1,4,4,1,1,4,4,3,3,4,4,2,2,0,0,6,6,3,3,4,4,3,3,6,6,6,6,5,5,7,7,7,7,2,2,3,3,2,2,4,4,3,3,1,1,5,5,0,0,4,4,4,4,3,3,2,2,6,6,1,1,2,2,1,1,3,3,7,7,0,0,4,4,2,2,6,6,7,7,2,2,2,2,1,1,0,0,2,2,4,4,1,1,5,5,4,4,2,2,5,5,7,7,4,4,1,1,2,2,5,5,6,6,0,0,7,7,1,1,7,7,0,0,4,4,3,3,4,4,5,5,4,4,4,4,6,6,2,2,5,5,3,3,6,6,7,7,3,3,6,6,5,5,6,6,6,6,0,0,2,2,5,5,2,2,6,6,7,7,6,6,3,3,5,5,3,3,6,6,3,3,0,0,2,2,1,1,3,3,6,6,0,0,4,4,1,1,3,3,4,4,1,1,4,4,4,4,0,0,4,4,0,0,6,6,6,6,3,3,4,4,5,5,2,2,1,1,1,1,7,7,0,0,4,4,6,6,1,1,5,5,7,7,3,3,5,5,1,1,7,7,5,5,6,6,7,7,1,1,6,6,7,7,7,7,1,1,7,7,6,6,2,2,3,3,7,7,2,2,4,4,6,6,6,6,2,2,7,7,7,7,4,4,5,5,5,5,4,4,5,5,4,4,2,2,2,2,6,6,2,2,5,5,5,5,2,2,7,7,5,5,6,6,1,1,5,5,0,0,2,2,1,1,2,2,5,5,7,7,5,5,5,5,3,3,5,5,4,4,0,0,1,1,3,3,3,3,0,0,6,6,6,6,4,4,0,0,6,6,0,0,5,5,6,6,3,3,4,4,7,7,5,5,0,0,2,2,3,3,0,0,4,4,0,0,3,3,7,7,0,0,7,7,3,3,4,4,6,6,5,5,1,1,1,1,5,5,4,4,2,2,7,7,6,6,4,4,7,7,3,3,3,3,2,2,4,4,6,6,4,4,1,1,4,4,5,5,1,1,3,3,1,1,2,2,6,6,4,4,4,4,3,3,0,0,6,6,2,2,3,3,7,7,3,3,4,4,4,4,0,0,4,4,1,1,1,1,2,2,2,2,0,0,3,3,5,5,6,6,6,6,1,1,2,2,7,7,5,5,3,3,7,7,7,7,5,5,7,7,0,0,6,6,6,6,1,1,5,5,6,6,5,5,3,3,5,5,1,1,2,2,6,6,4,4,1,1,2,2,3,3,6,6,0,0,6,6,7,7,3,3,0,0,4,4,5,5,0,0,7,7,7,7,0,0,7,7,3,3,3,3,2,2,2,2,5,5,4,4,2,2,5,5,1,1,6,6,0,0,0,0,5,5,0,0,6,6,4,4,4,4,4,4,0,0,7,7,0,0,5,5,2,2,6,6,3,3,7,7,2,2,6,6,7,7,4,4,2,2,2,2,1,1,1,1,4,4,1,1,6,6,0,0,2,2,3,3,2,2,2,2,6,6,3,3,4,4,6,6,1,1,4,4,1,1,5,5,2,2,5,5,1,1,3,3,5,5,5,5,0,0,7,7,1,1,0,0,5,5,5,5,6,6,1,1,2,2,7,7,3,3,3,3,4,4,3,3,0,0,2,2,6,6,2,2,3,3,7,7,7,7,1,1,0,0,7,7,1,1,1,1,1,1,6,6,0,0,4,4,6,6,0,0,4,4,2,2,4,4,2,2,4,4,4,4,2,2,6,6,7,7,3,3,1,1,6,6,1,1,5,5,6,6,5,5,0,0,0,0,2,2,3,3,4,4,0,0,4,4,6,6,3,3,3,3,7,7,0,0,7,7,2,2,3,3,4,4,5,5,4,4,7,7,3,3,6,6,0,0,0,0,2,2,0,0,3,3,5,5,2,2,1,1,6,6,3,3,2,2,2,2,1,1,4,4,3,3,1,1,5,5,6,6,2,2,0,0,4,4,4,4,3,3,2,2,0,0,1,1,1,1,3,3,0,0,3,3,5,5,6,6,3,3,5,5,6,6,3,3,2,2,6,6,0,0,7,7,0,0,3,3,3,3,0,0,7,7,4,4,1,1,4,4,3,3,2,2,6,6,7,7,1,1,6,6,5,5,7,7,5,5,4,4,1,1,2,2,2,2,7,7,7,7,5,5,0,0,6,6,4,4,1,1,5,5,6,6,2,2,4,4,2,2,5,5,4,4,7,7,0,0,1,1,5,5,2,2,2,2,5,5,2,2,0,0,1,1,5,5,3,3,6,6,5,5,2,2,2,2,3,3,1,1,0,0,4,4,4,4,4,4,1,1,0,0,4,4,4,4,5,5,6,6,1,1,5,5,4,4,2,2,5,5,0,0,2,2,0,0,6,6,0,0,1,1,5,5,5,5,6,6,5,5,0,0,6,6,0,0,4,4,4,4,4,4,3,3,0,0,5,5,1,1,7,7,0,0,5,5,1,1,4,4,3,3,2,2,4,4,5,5,7,7,2,2,0,0,5,5,0,0,2,2,4,4,3,3,6,6,1,1,1,1,1,1,3,3,3,3,6,6,0,0,1,1,2,2,3,3,6,6,4,4,2,2,4,4,2,2,4,4,4,4,7,7,6,6,1,1,0,0,5,5,5,5,2,2,2,2,0,0,3,3,5,5,1,1,3,3,1,1,1,1,0,0,2,2,7,7,3,3,4,4,0,0,0,0,4,4,0,0,4,4,2,2,0,0,3,3,6,6,4,4,1,1,7,7,7,7,7,7,0,0,1,1,4,4,3,3,2,2,5,5,1,1,1,1,2,2,5,5,3,3,4,4,4,4,2,2,3,3,6,6,5,5,0,0,1,1,5,5,1,1,4,4,5,5,2,2,2,2,6,6,6,6,3,3,2,2,7,7,4,4,2,2,1,1,2,2,7,7,1,1,4,4,2,2,3,3,7,7,5,5,0,0,2,2,6,6,5,5,1,1,4,4,2,2,5,5,6,6,7,7,1,1,5,5,5,5,0,0,7,7,6,6,0,0,3,3,1,1,0,0,4,4,0,0,3,3,7,7,2,2,3,3,2,2,3,3,6,6,2,2,0,0,1,1,2,2,0,0,5,5,3,3,4,4,5,5,0,0,0,0,2,2,2,2,0,0,3,3,4,4,1,1,7,7,7,7,7,7,5,5,1,1,0,0,3,3,0,0,4,4,4,4,2,2,1,1,2,2,6,6,2,2,1,1,0,0,5,5,5,5,7,7,7,7,5,5,6,6,7,7,2,2,6,6,1,1,1,1,3,3,0,0,4,4,0,0,1,1,1,1,5,5,1,1,4,4,7,7,0,0,5,5,5,5,7,7,2,2,4,4,0,0,4,4,3,3,6,6,4,4,5,5,2,2,7,7,1,1,6,6,3,3,2,2,0,0,1,1,4,4,0,0,6,6,7,7,0,0,1,1,1,1,1,1,4,4,0,0,1,1,6,6,1,1,3,3,2,2,6,6,0,0,5,5,0,0,0,0,0,0,1,1,6,6,2,2,3,3,5,5,2,2,4,4,4,4,2,2,7,7,1,1,6,6,0,0,6,6,2,2,3,3,2,2,3,3,2,2,1,1,2,2,4,4,3,3,1,1,2,2,1,1,0,0,0,0,6,6,2,2,4,4,7,7,5,5,0,0,4,4,7,7,7,7,0,0,6,6,6,6,1,1,3,3,0,0,0,0,0,0,5,5,0,0,0,0,3,3,2,2,3,3,2,2,5,5,6,6,4,4,0,0,1,1,6,6,4,4,6,6,6,6,0,0,3,3,5,5,3,3,1,1,0,0,7,7,3,3,3,3,5,5,1,1,5,5,1,1,0,0,1,1,5,5,2,2,1,1,2,2,5,5,4,4,2,2,7,7,3,3,2,2,2,2,3,3,4,4,3,3,0,0,3,3,1,1,1,1,4,4,1,1,2,2,1,1,5,5,2,2,5,5,4,4,5,5,4,4,1,1,4,4,2,2,7,7,0,0,4,4,3,3,5,5,6,6,2,2,0,0,3,3,0,0,3,3,1,1,2,2,0,0,0,0,3,3,7,7,6,6,0,0,7,7,4,4,5,5,0,0,6,6,7,7,5,5,2,2,2,2,1,1,0,0,2,2,4,4,0,0,7,7,2,2,7,7,3,3,0,0,5,5,1,1,4,4,5,5,6,6,7,7,0,0,5,5,7,7,6,6,6,6,2,2,3,3,0,0,3,3,2,2,5,5,1,1,4,4,7,7,4,4,6,6,3,3,5,5,6,6,4,4,6,6,1,1,5,5,2,2,7,7,0,0,0,0,6,6,1,1,2,2,0,0,1,1,2,2,3,3,7,7,4,4,4,4,3,3,2,2,6,6,7,7,1,1,0,0,7,7,2,2,0,0,4,4,5,5,2,2,0,0,5,5,3,3,2,2,3,3,4,4,2,2,7,7,5,5,2,2,3,3,0,0,3,3,4,4,4,4,2,2,2,2,3,3,0,0,3,3,3,3,5,5,0,0,2,2,1,1,6,6,3,3,1,1,1,1,3,3,4,4,7,7,0,0,0,0,4,4,1,1,5,5,4,4,6,6,7,7,6,6,1,1,0,0,1,1,1,1,5,5,5,5,0,0,0,0,5,5,4,4,3,3,0,0,0,0,0,0,2,2,3,3,0,0,5,5,5,5,1,1,7,7,6,6,1,1,7,7,1,1,2,2,6,6,5,5,2,2,2,2,0,0,4,4,3,3,3,3,2,2,1,1,4,4,4,4,1,1,3,3,5,5,1,1,3,3,4,4,2,2,3,3,6,6,1,1,6,6,0,0,5,5,6,6,0,0,7,7,2,2,2,2,0,0,6,6,4,4,2,2,7,7,6,6,6,6,1,1,0,0,4,4,2,2,1,1,3,3,3,3,1,1,2,2,4,4,7,7,5,5,0,0,0,0,2,2,6,6,7,7,5,5,2,2,5,5,7,7,1,1,0,0,3,3,0,0,6,6,4,4,0,0,0,0,2,2,5,5,1,1,0,0,1,1,5,5,4,4,7,7,6,6,5,5,0,0,0,0,6,6,2,2,6,6,5,5,1,1,7,7,0,0,6,6,4,4,5,5,1,1,2,2,7,7,2,2,2,2,5,5,3,3,4,4,5,5,2,2,1,1,2,2,0,0,5,5,6,6,5,5,6,6,0,0,2,2,3,3,4,4,0,0,7,7,2,2,2,2,0,0,6,6,7,7,5,5,5,5,1,1,2,2,0,0,0,0,0,0,5,5,2,2,0,0,7,7,3,3,1,1,1,1,1,1,2,2,3,3,3,3,4,4,1,1,1,1,6,6,1,1,0,0,6,6,0,0,4,4,2,2,0,0,5,5,7,7,0,0,3,3,1,1,7,7,6,6,0,0,0,0,6,6,3,3,6,6,3,3,0,0,3,3,6,6,7,7,0,0,1,1,6,6,1,1,1,1,3,3,0,0,6,6,0,0,7,7,2,2,6,6,1,1,1,1,1,1,1,1,3,3,1,1,3,3,1,1,6,6,6,6,7,7,5,5,5,5,6,6,3,3,0,0,7,7,7,7,4,4,0,0,4,4,3,3,6,6,1,1,7,7,2,2,1,1,0,0,2,2,1,1,6,6,2,2,7,7,7,7,0,0,0,0,5,5,0,0,7,7,1,1,2,2,0,0,6,6,1,1,0,0,3,3,1,1,2,2,2,2,4,4,2,2,0,0,1,1,7,7,2,2,1,1,1,1,4,4,0,0,1,1,3,3,6,6,3,3,6,6,4,4,1,1,0,0,7,7,2,2,2,2,5,5,6,6,6,6,0,0,0,0,0,0,4,4,3,3,1,1,1,1,7,7,6,6,0,0,2,2,4,4,5,5,3,3,4,4,6,6,7,7,7,7,2,2,2,2,0,0,0,0,1,1,6,6,3,3,6,6,1,1,4,4,1,1,2,2,1,1,7,7,4,4,2,2,7,7,6,6,2,2,7,7,1,1,2,2,0,0,0,0,1,1,4,4,2,2,5,5,7,7,3,3,4,4,1,1,7,7,0,0,6,6,4,4,7,7,1,1,7,7,0,0,4,4,7,7,3,3,1,1,7,7,2,2,0,0,6,6,0,0,6,6,6,6,4,4,6,6,6,6,7,7,5,5,7,7,6,6,0,0,2,2,6,6,6,6,6,6,2,2,5,5,7,7,3,3,1,1,5,5,6,6,6,6,0,0,0,0,4,4,4,4,2,2,5,5,6,6,2,2,1,1,5,5,4,4,4,4,4,4,2,2,3,3,2,2,3,3,2,2,4,4,6,6,2,2,7,7,6,6,2,2,0,0,3,3,6,6,3,3,6,6,5,5,1,1,3,3,2,2,7,7,3,3,3,3,7,7,5,5,1,1,2,2,0,0,1,1,2,2,6,6,0,0,0,0,1,1,0,0,1,1,7,7,1,1,6,6,7,7,7,7,7,7,4,4,3,3,1,1,7,7,6,6,5,5,1,1,2,2,4,4,2,2,5,5,3,3,5,5,3,3,5,5,2,2,2,2,4,4,0,0,4,4,0,0,0,0,3,3,5,5,4,4,4,4,6,6,4,4,2,2,7,7,5,5,0,0,7,7,3,3,4,4,5,5,1,1,0,0,0,0,4,4,2,2,2,2,0,0,5,5,2,2,5,5,7,7,4,4,4,4,0,0,3,3,3,3,2,2,3,3,5,5,3,3,6,6,1,1,7,7,2,2,7,7,4,4,0,0,0,0,7,7,4,4,0,0,0,0,3,3,1,1,4,4,0,0,3,3,2,2,7,7,0,0,1,1,5,5,4,4,2,2,4,4,0,0,4,4,7,7,5,5,2,2,6,6,3,3,2,2,2,2,3,3,5,5,0,0,4,4,0,0,0,0,1,1,4,4,5,5,2,2,6,6,2,2,4,4,5,5,6,6,5,5,1,1,2,2,1,1,0,0,7,7,3,3,3,3,6,6,7,7,1,1,2,2,4,4,1,1,6,6,6,6,5,5,0,0,5,5,7,7,7,7,4,4,5,5,1,1,0,0,7,7,0,0,7,7,5,5,3,3,5,5,1,1,1,1,0,0,4,4,5,5,5,5,2,2,5,5,7,7,4,4,2,2,5,5,6,6,0,0,6,6,7,7,2,2,1,1,7,7,3,3,4,4,3,3,2,2,5,5,5,5,1,1,5,5,2,2,1,1,5,5,1,1,1,1,4,4,0,0,0,0,4,4,1,1,4,4,5,5,3,3,3,3,2,2,6,6,6,6,0,0,6,6,3,3,2,2,0,0,4,4,3,3,0,0,6,6,6,6,4,4,7,7,4,4,0,0,0,0,7,7,3,3,0,0,5,5,3,3,7,7,4,4,7,7,7,7,2,2,4,4,4,4,6,6,2,2,5,5,2,2,3,3,4,4,3,3,7,7,1,1,0,0,1,1,1,1,7,7,7,7,5,5,0,0,7,7,7,7,0,0,3,3,0,0,5,5,4,4,0,0,4,4,7,7,2,2,5,5,3,3,7,7,6,6,3,3,1,1,5,5,1,1,3,3,2,2,4,4,7,7,4,4,4,4,7,7,1,1,2,2,2,2,6,6,4,4,4,4,6,6,7,7,3,3,2,2,3,3,7,7,1,1,4,4,1,1,0,0,0,0,7,7,0,0,3,3,5,5,7,7,4,4,0,0,2,2,0,0,0,0,0,0,1,1,0,0,3,3,3,3,4,4,3,3,0,0,3,3,1,1,7,7,3,3,5,5,7,7,5,5,4,4,1,1,7,7,3,3,4,4,4,4,5,5,7,7,5,5,0,0,6,6,0,0,1,1,6,6,2,2,4,4,1,1,6,6,7,7,3,3,4,4,5,5,3,3,1,1,0,0,2,2,6,6,6,6,0,0,7,7,1,1,4,4,3,3,3,3,7,7,3,3,0,0,5,5,1,1,0,0,4,4,4,4,3,3,1,1,6,6,5,5,3,3,5,5,0,0,5,5,5,5,0,0,0,0,7,7,2,2,5,5,5,5,4,4,7,7,1,1,6,6,3,3,3,3,7,7,6,6,5,5,6,6,1,1,1,1,7,7,0,0,7,7,2,2,4,4,3,3,2,2,3,3,7,7,2,2,1,1,6,6,0,0,1,1,4,4,2,2,5,5,0,0,7,7,2,2,0,0,1,1,0,0,7,7,1,1,4,4,7,7,4,4,2,2,6,6,1,1,0,0,3,3,4,4,1,1,0,0,7,7,6,6,3,3,5,5,5,5,4,4,5,5,7,7,0,0,0,0,0,0,3,3,3,3,0,0,2,2,5,5,6,6,0,0,1,1,2,2,3,3,7,7,4,4,0,0,2,2,0,0,0,0,5,5,3,3,6,6,6,6,5,5,1,1,2,2,1,1,7,7,1,1,6,6,3,3,3,3,4,4,6,6,2,2,0,0,4,4,1,1,6,6,3,3,5,5,1,1,7,7,6,6,0,0,7,7,1,1,1,1,3,3,2,2,4,4,3,3,6,6,7,7,7,7,1,1,3,3,0,0,7,7,0,0,5,5,3,3,1,1,3,3,2,2,1,1,1,1,4,4,2,2,7,7,0,0,4,4,3,3,4,4,3,3,4,4,4,4,2,2,3,3,3,3,4,4,5,5,0,0,5,5,5,5,2,2,1,1,0,0,7,7,6,6,5,5,1,1,1,1,1,1,0,0,1,1,7,7,3,3,2,2,4,4,7,7,6,6,6,6,6,6,5,5,0,0,1,1,7,7,3,3,3,3,0,0,0,0,1,1,4,4,5,5,1,1,1,1,0,0,0,0,4,4,1,1,0,0,3,3,5,5,0,0,4,4,2,2,0,0,1,1,2,2,3,3,6,6,0,0,4,4,4,4,1,1,2,2,7,7,4,4,6,6,1,1,2,2,6,6,5,5,6,6,1,1,1,1,2,2,2,2,2,2,4,4,0,0,6,6,7,7,6,6,2,2,0,0,0,0,3,3,7,7,7,7,3,3,3,3,2,2,0,0,7,7,3,3,3,3,6,6,7,7,1,1,7,7,5,5,4,4,5,5,5,5,7,7,7,7,7,7,7,7,1,1,4,4,3,3,7,7,1,1,6,6,4,4,0,0,4,4,1,1,1,1,4,4,1,1,6,6,7,7,5,5,5,5,4,4,2,2,0,0,0,0,7,7,6,6,2,2,1,1,3,3,0,0,4,4,6,6,4,4,3,3,7,7,2,2,2,2,2,2,0,0,0,0,3,3,2,2,4,4,7,7,7,7,7,7,2,2,6,6,2,2,3,3,0,0,2,2,3,3,6,6,1,1,1,1,3,3,0,0,2,2,0,0,6,6,4,4,0,0,2,2,1,1,4,4,5,5,7,7,0,0,0,0,4,4,4,4,0,0,3,3,5,5,0,0,1,1,1,1,1,1,1,1,5,5,1,1,7,7,1,1,2,2,3,3,6,6,1,1,2,2,1,1,4,4,7,7,2,2,4,4,4,4,2,2,0,0,4,4,4,4,0,0,0,0,5,5,5,5,2,2,0,0,1,1,4,4,4,4,3,3,4,4,3,3,0,0,1,1,0,0,0,0,7,7,0,0,1,1,1,1,0,0,2,2,6,6,1,1,0,0,5,5,4,4,0,0,7,7,0,0,2,2,5,5,4,4,1,1,3,3,4,4,1,1,0,0,3,3,4,4,7,7,2,2,1,1,2,2,6,6,1,1,3,3,6,6,6,6,3,3,2,2,1,1,6,6,5,5,5,5,5,5,3,3,2,2,7,7,3,3,1,1,6,6,0,0,5,5,0,0,7,7,0,0,2,2,4,4,4,4,2,2,4,4,1,1,1,1,3,3,3,3,3,3,4,4,2,2,2,2,3,3,2,2,1,1,2,2,1,1,4,4,7,7,2,2,1,1,3,3,2,2,5,5,4,4,0,0,0,0,6,6,0,0,5,5,7,7,3,3,0,0,5,5,1,1,7,7,1,1,3,3,5,5,4,4,3,3,3,3,5,5,1,1,1,1,3,3,5,5,4,4,0,0,7,7,2,2,0,0,0,0,5,5,3,3,7,7,3,3,5,5,1,1,7,7,7,7,5,5,0,0,7,7,7,7,2,2,5,5,2,2,5,5,1,1,0,0,7,7,0,0,4,4,6,6,5,5,0,0,5,5,6,6,2,2,5,5,6,6,0,0,4,4,7,7,0,0,5,5,1,1,7,7,6,6,6,6,2,2,1,1,6,6,3,3,6,6,7,7,4,4,0,0,6,6,0,0,5,5,2,2,5,5,5,5,3,3,2,2,7,7,2,2,4,4,3,3,3,3,0,0,1,1,4,4,7,7,3,3,7,7,0,0,0,0,4,4,2,2,2,2,6,6,2,2,6,6,4,4,3,3,4,4,0,0,4,4,5,5,3,3,2,2,0,0,0,0,2,2,6,6,3,3,0,0,0,0,1,1,4,4,3,3,7,7,1,1,2,2,7,7,2,2,1,1,5,5,2,2,6,6,0,0,1,1,7,7,6,6,3,3,3,3,1,1,6,6,0,0,2,2,3,3,3,3,5,5,2,2,6,6,5,5,7,7,1,1,0,0,0,0,7,7,6,6,6,6,2,2,4,4,0,0,5,5,6,6,5,5,1,1,2,2,3,3,3,3,1,1,3,3,6,6,4,4,1,1,2,2,3,3,5,5,5,5,2,2,5,5,3,3,0,0,3,3,5,5,3,3,2,2,6,6,6,6,7,7,6,6,7,7,2,2,7,7,2,2,4,4,0,0,6,6,3,3,7,7,4,4,4,4,4,4,5,5,1,1,0,0,2,2,5,5,5,5,7,7,5,5,0,0,5,5,2,2,5,5,4,4,2,2,1,1,7,7,4,4,6,6,4,4,5,5,7,7,4,4,1,1,2,2,0,0,2,2,3,3,2,2,7,7,4,4,1,1,1,1,5,5,5,5,1,1,2,2,2,2,3,3,0,0,0,0,0,0,7,7,1,1,7,7,0,0,6,6,7,7,0,0,6,6,7,7,6,6,4,4,5,5,4,4,2,2,6,6,0,0,5,5,1,1,0,0,7,7,7,7,3,3,0,0,2,2,1,1,5,5,3,3,2,2,7,7,4,4,5,5,4,4,5,5,4,4,4,4,1,1,0,0,4,4,1,1,2,2,3,3,5,5,6,6,4,4,3,3,1,1,7,7,2,2,3,3,2,2,4,4,4,4,0,0,0,0,5,5,0,0,6,6,0,0,0,0,0,0,0,0,6,6,2,2,7,7,5,5,1,1,4,4,5,5,0,0,0,0,2,2,2,2,0,0,7,7,4,4,4,4,3,3,6,6,1,1,0,0,5,5,6,6,7,7,2,2,5,5,6,6,7,7,5,5,0,0,0,0,3,3,0,0,6,6,7,7,4,4,3,3,1,1,2,2,5,5,4,4,7,7,4,4,1,1,0,0,0,0,2,2,2,2,6,6,4,4,0,0,4,4,0,0,3,3,2,2,6,6,0,0,0,0,1,1,5,5,7,7,6,6,0,0,5,5,6,6,0,0,0,0,2,2,0,0,5,5,6,6,3,3,0,0,2,2,7,7,2,2,5,5,5,5,4,4,3,3,6,6,1,1,4,4,3,3,5,5,3,3,1,1,4,4,3,3,2,2,2,2,3,3,3,3,4,4,3,3,1,1,7,7,7,7,0,0,3,3,2,2,2,2,1,1,1,1,4,4,5,5,2,2,1,1,6,6,3,3,2,2,0,0,2,2,7,7,0,0,0,0,4,4,6,6,4,4,4,4,2,2,1,1,0,0,1,1,4,4,0,0,2,2,0,0,2,2,0,0,1,1,3,3,1,1,0,0,0,0,1,1,5,5,7,7,2,2,6,6,4,4,5,5,6,6,3,3,1,1,4,4,2,2,7,7,6,6,7,7,6,6,4,4,4,4,6,6,6,6,3,3,4,4,2,2,2,2,6,6,7,7,6,6,3,3,7,7,4,4,4,4,1,1,2,2,0,0,3,3,1,1,0,0,4,4,0,0,5,5,2,2,7,7,6,6,0,0,4,4,3,3,0,0,3,3,7,7,1,1,0,0,4,4,1,1,2,2,5,5,0,0,2,2,0,0,3,3,6,6,6,6,1,1,1,1,4,4,0,0,4,4,6,6,6,6,3,3,7,7,1,1,1,1,3,3,6,6,0,0,1,1,0,0,4,4,0,0,4,4,1,1,0,0,2,2,0,0,2,2,0,0,3,3,3,3,3,3,3,3,0,0,2,2,3,3,3,3,0,0,3,3,6,6,5,5,5,5,4,4,4,4,1,1,7,7,1,1,0,0,2,2,2,2,2,2,2,2,2,2,6,6,0,0,0,0,4,4,3,3,6,6,2,2,2,2,3,3,6,6,2,2,3,3,4,4,3,3,2,2,6,6,3,3,0,0,4,4,2,2,6,6,6,6,7,7,5,5,7,7,0,0,5,5,4,4,5,5,4,4,1,1,0,0,3,3,5,5,6,6,6,6,0,0,1,1,7,7,0,0,0,0,1,1,2,2,4,4,1,1,3,3,5,5,5,5,7,7,6,6,2,2,7,7,6,6,5,5,4,4,2,2,7,7,0,0,5,5,2,2,7,7,6,6,3,3,1,1,4,4,4,4,1,1,0,0,0,0,0,0,4,4,1,1,7,7,5,5,7,7,1,1,3,3,0,0,1,1,6,6,3,3,2,2,1,1,0,0,3,3,4,4,6,6,3,3,3,3,1,1,0,0,5,5,6,6,1,1,6,6,7,7,0,0,3,3,3,3,1,1,1,1,2,2,5,5,1,1,0,0,6,6,5,5,7,7,4,4,7,7,4,4,0,0,0,0,3,3,5,5,6,6,1,1,1,1,4,4,3,3,4,4,0,0,0,0,4,4,5,5,3,3,0,0,3,3,3,3,2,2,0,0,3,3,5,5,2,2,6,6,0,0,1,1,2,2,0,0,1,1,0,0,1,1,2,2,3,3,4,4,6,6,5,5,0,0,3,3,7,7,3,3,2,2,7,7,3,3,5,5,3,3,2,2,7,7,6,6,1,1,1,1,5,5,6,6,1,1,3,3,1,1,0,0,3,3,4,4,1,1,5,5,2,2,0,0,3,3,7,7,2,2,4,4,4,4,5,5,1,1,0,0,6,6,7,7,6,6,3,3,6,6,4,4,0,0,2,2,6,6,3,3,1,1,7,7,1,1,7,7,1,1,7,7,3,3,3,3,0,0,1,1,5,5,4,4,1,1,7,7,5,5,4,4,3,3,1,1,4,4,6,6,5,5,0,0,2,2,0,0,5,5,4,4,0,0,1,1,4,4,0,0,7,7,2,2,2,2,5,5,3,3,2,2,4,4,1,1,1,1,2,2,7,7,4,4,0,0,0,0,1,1,4,4,7,7,6,6,3,3,7,7,4,4,7,7,6,6,6,6,4,4,0,0,2,2,2,2,6,6,2,2,5,5,5,5,3,3,5,5,3,3,3,3,5,5,6,6,6,6,1,1,5,5,1,1,4,4,6,6,4,4,1,1,5,5,6,6,6,6,4,4,2,2,7,7,2,2,6,6,2,2,2,2,5,5,5,5,6,6,7,7,0,0,3,3,4,4,3,3,1,1,0,0,7,7,4,4,0,0,1,1,2,2,1,1,2,2,4,4,0,0,4,4,4,4,7,7,0,0,7,7,4,4,4,4,5,5,1,1,3,3,1,1,7,7,3,3,5,5,3,3,1,1,5,5,0,0,5,5,4,4,5,5,2,2,0,0,0,0,1,1,4,4,2,2,7,7,7,7,2,2,5,5,3,3,3,3,4,4,7,7,1,1,0,0,3,3,7,7,4,4,4,4,4,4,2,2,1,1,5,5,2,2,2,2,6,6,1,1,7,7,2,2,4,4,6,6,1,1,2,2,3,3,5,5,7,7,4,4,4,4,3,3,2,2,0,0,0,0,4,4,7,7,0,0,0,0,2,2,3,3,5,5,4,4,2,2,2,2,5,5,0,0,3,3,7,7,2,2,1,1,3,3,4,4,2,2,0,0,0,0,4,4,3,3,1,1,5,5,7,7,3,3,0,0,0,0,2,2,1,1,7,7,5,5,7,7,3,3,6,6,6,6,3,3,6,6,4,4,1,1,0,0,6,6,2,2,5,5,0,0,7,7,4,4,1,1,1,1,7,7,0,0,2,2,3,3,6,6,7,7,4,4,3,3,4,4,3,3,2,2,0,0,6,6,1,1,5,5,0,0,2,2,0,0,5,5,6,6,7,7,2,2,4,4,6,6,3,3,2,2,7,7,2,2,6,6,0,0,4,4,7,7,5,5,6,6,2,2,1,1,1,1,6,6,7,7,0,0,4,4,5,5,1,1,6,6,7,7,1,1,4,4,3,3,1,1,3,3,2,2,7,7,6,6,4,4,5,5,2,2,3,3,6,6,5,5,7,7,4,4,5,5,4,4,1,1,4,4,2,2,5,5,0,0,4,4,1,1,1,1,4,4,5,5,3,3,4,4,5,5,3,3,0,0,3,3,6,6,0,0,4,4,5,5,5,5,7,7,3,3,0,0,5,5,1,1,6,6,1,1,0,0,0,0,7,7,1,1,4,4,6,6,0,0,5,5,7,7,1,1,4,4,0,0,2,2,7,7,0,0,1,1,4,4,0,0,2,2,2,2,5,5,2,2,2,2,5,5,5,5,4,4,5,5,0,0,6,6,5,5,2,2,6,6,2,2,5,5,3,3,5,5,1,1,0,0,2,2,2,2,7,7,6,6,2,2,6,6,0,0,2,2,3,3,5,5,4,4,7,7,4,4,4,4,2,2,3,3,5,5,3,3,4,4,0,0,7,7,4,4,7,7,4,4,6,6,0,0,5,5,1,1,1,1,0,0,2,2,0,0,1,1,0,0,3,3,3,3,2,2,1,1,5,5,4,4,0,0,0,0,7,7,6,6,3,3,2,2,5,5,7,7,6,6,3,3,4,4,3,3,3,3,7,7,1,1,0,0,6,6,7,7,5,5,3,3,6,6,1,1,4,4,2,2,0,0,7,7,0,0,2,2,6,6,2,2,6,6,5,5,2,2,2,2,1,1,2,2,5,5,4,4,5,5,4,4,5,5,7,7,1,1,5,5,3,3,2,2,2,2,3,3,6,6,2,2,6,6,5,5,0,0,2,2,3,3,5,5,1,1,2,2,4,4,7,7,2,2,5,5,6,6,4,4,4,4,3,3,5,5,2,2,4,4,5,5,4,4,4,4,2,2,6,6,6,6,7,7,6,6,6,6,1,1,5,5,0,0,6,6,1,1,3,3,6,6,1,1,7,7,7,7,2,2,3,3,7,7,7,7,4,4,1,1,4,4,1,1,5,5,3,3,7,7,0,0,2,2,4,4,2,2,3,3,7,7,0,0,3,3,3,3,6,6,5,5,7,7,1,1,3,3,6,6,0,0,6,6,1,1,4,4,0,0,6,6,2,2,0,0,5,5,6,6,0,0,3,3,3,3,7,7,6,6,4,4,7,7,3,3,2,2,0,0,4,4,0,0,2,2,6,6,0,0,6,6,4,4,2,2,5,5,6,6,0,0,4,4,0,0,1,1,5,5,2,2,6,6,5,5,2,2,5,5,4,4,5,5,0,0,1,1,4,4,6,6,6,6,7,7,0,0,6,6,3,3,7,7,1,1,3,3,0,0,7,7,6,6,1,1,1,1,4,4,1,1,3,3,1,1,3,3,2,2,0,0,6,6,3,3,3,3,0,0,7,7,1,1,4,4,7,7,7,7,6,6,4,4,2,2,3,3,4,4,6,6,5,5,5,5,5,5,3,3,0,0,1,1,0,0,0,0,5,5,4,4,3,3,7,7,3,3,2,2,7,7,7,7,4,4,0,0,3,3,6,6,4,4,0,0,6,6,4,4,0,0,5,5,1,1,4,4,1,1,7,7,7,7,6,6,2,2,3,3,6,6,5,5,0,0,1,1,0,0,4,4,3,3,2,2,0,0,1,1,1,1,3,3,0,0,3,3,6,6,1,1,2,2,0,0,3,3,2,2,4,4,2,2,2,2,3,3,6,6,3,3,6,6,6,6,3,3,1,1,7,7,5,5,0,0,7,7,0,0,4,4,5,5,0,0,2,2,1,1,5,5,4,4,5,5,3,3,3,3,7,7,6,6,3,3,2,2,0,0,1,1,2,2,4,4,4,4,0,0,1,1,1,1,2,2,0,0,5,5,4,4,2,2,0,0,3,3,3,3,0,0,7,7,0,0,5,5,7,7,6,6,1,1,3,3,6,6,3,3,0,0,5,5,6,6,2,2,4,4,1,1,7,7,4,4,2,2,7,7,4,4,7,7,6,6,5,5,6,6,2,2,2,2,0,0,3,3,0,0,2,2,1,1,5,5,5,5,6,6,6,6,6,6,2,2,0,0,1,1,6,6,3,3,6,6,2,2,6,6,4,4,2,2,5,5,5,5,2,2,6,6,0,0,3,3,4,4,3,3,1,1,0,0,7,7,5,5,0,0,3,3,0,0,3,3,5,5,3,3,5,5,1,1,1,1,2,2,4,4,6,6,1,1,7,7,0,0,1,1,3,3,7,7,2,2,5,5,5,5,7,7,2,2,2,2,6,6,2,2,3,3,1,1,5,5,6,6,4,4,6,6,2,2,5,5,2,2,1,1,2,2,3,3,3,3,4,4,1,1,4,4,3,3,6,6,6,6,6,6,2,2,2,2,7,7,7,7,6,6,7,7,6,6,1,1,4,4,2,2,6,6,7,7,0,0,1,1,4,4,5,5,1,1,5,5,6,6,1,1,0,0,4,4,7,7,6,6,3,3,3,3,2,2,1,1,7,7,4,4,1,1,3,3,2,2,1,1,5,5,1,1,7,7,1,1,0,0,4,4,3,3,3,3,2,2,5,5,2,2,7,7,5,5,0,0,7,7,4,4,0,0,4,4,0,0,2,2,2,2,4,4,4,4,4,4,5,5,5,5,0,0,3,3,5,5,4,4,6,6,7,7,6,6,1,1,0,0,4,4,3,3,7,7,0,0,0,0,0,0,6,6,0,0,5,5,1,1,3,3,6,6,5,5,7,7,3,3,1,1,7,7,7,7,6,6,0,0,3,3,1,1,5,5,6,6,7,7,6,6,0,0,7,7,6,6,0,0,7,7,5,5,4,4,6,6,6,6,1,1,0,0,6,6,3,3,4,4,1,1,4,4,1,1,2,2,4,4,6,6,5,5,2,2,2,2,5,5,7,7,4,4,6,6,6,6,2,2,1,1,6,6,3,3,1,1,1,1,7,7,4,4,3,3,6,6,6,6,7,7,4,4,2,2,2,2,7,7,5,5,3,3,2,2,7,7,0,0,7,7,2,2,0,0,1,1,1,1,1,1,5,5,6,6,0,0,1,1,0,0,1,1,5,5,2,2,4,4,5,5,3,3,4,4,5,5,6,6,3,3,0,0,4,4,1,1,2,2,0,0,7,7,7,7,0,0,5,5,3,3,2,2,4,4,4,4,2,2,1,1,0,0,7,7,2,2,4,4,6,6,6,6,5,5,5,5,2,2,2,2,0,0,4,4,7,7,1,1,4,4,6,6,2,2,7,7,6,6,6,6,6,6,3,3,6,6,1,1,0,0,6,6,5,5,2,2,3,3,4,4,5,5,5,5,2,2,2,2,0,0,6,6,2,2,6,6,1,1,0,0,1,1,0,0,1,1,5,5,2,2,3,3,6,6,6,6,1,1,7,7,0,0,5,5,6,6,6,6,4,4,6,6,0,0,3,3,4,4,2,2,7,7,0,0,5,5,2,2,6,6,4,4,2,2,6,6,2,2,1,1,3,3,5,5,0,0,1,1,5,5,2,2,2,2,0,0,3,3,6,6,5,5,4,4,1,1,1,1,1,1,1,1,6,6,4,4,5,5,4,4,5,5,0,0,1,1,6,6,2,2,2,2,6,6,4,4,7,7,2,2,6,6,2,2,1,1,5,5,3,3,7,7,5,5,6,6,2,2,0,0,3,3,3,3,0,0,2,2,4,4,4,4,6,6,1,1,2,2,2,2,1,1,7,7,0,0,3,3,1,1,5,5,6,6,0,0,3,3,2,2,3,3,1,1,3,3,2,2,7,7,1,1,2,2,4,4,0,0,2,2,4,4,2,2,5,5,4,4,2,2,0,0,3,3,5,5,2,2,4,4,0,0,0,0,7,7,5,5,3,3,0,0,5,5,5,5,2,2,7,7,0,0,7,7,0,0,6,6,4,4,0,0,0,0,2,2,2,2,4,4,3,3,6,6,5,5,2,2,6,6,0,0,4,4,4,4,4,4,7,7,7,7,6,6,5,5,1,1,1,1,5,5,0,0,6,6,5,5,4,4,1,1,4,4,0,0,0,0,7,7,5,5,1,1,4,4,6,6,1,1,5,5,6,6,0,0,5,5,4,4,1,1,3,3,0,0,2,2,5,5,0,0,3,3,7,7,5,5,0,0,2,2,5,5,0,0,0,0,3,3,3,3,0,0,3,3,6,6,4,4,3,3,6,6,3,3,0,0,1,1,6,6,3,3,5,5,3,3,4,4,3,3,5,5,6,6,7,7,0,0,3,3,1,1,1,1,3,3,5,5,3,3,7,7,1,1,1,1,2,2,3,3,1,1,3,3,2,2,4,4,7,7,6,6,4,4,4,4,6,6,1,1,4,4,2,2,2,2,1,1,0,0,6,6,3,3,3,3,3,3,6,6,6,6,0,0,4,4,7,7,3,3,6,6,0,0,2,2,4,4,1,1,1,1,5,5,4,4,2,2,7,7,7,7,4,4,0,0,1,1,6,6,7,7,5,5,6,6,2,2,1,1,7,7,2,2,0,0,3,3,5,5,2,2,0,0,2,2,3,3,4,4,0,0,0,0,1,1,6,6,0,0,5,5,7,7,2,2,5,5,0,0,1,1,3,3,7,7,2,2,7,7,4,4,4,4,0,0,7,7,3,3,6,6,6,6,0,0,5,5,0,0,7,7,1,1,0,0,5,5,4,4,0,0,3,3,3,3,5,5,5,5,1,1,3,3,2,2,0,0,4,4,1,1,5,5,0,0,1,1,0,0,1,1,0,0,3,3,7,7,4,4,3,3,7,7,0,0,4,4,2,2,4,4,1,1,5,5,1,1,5,5,0,0,7,7,6,6,2,2,2,2,7,7,7,7,2,2,6,6,7,7,1,1,1,1,0,0,6,6,5,5,1,1,7,7,3,3,3,3,4,4,4,4,1,1,4,4,4,4,1,1,5,5,0,0,4,4,4,4,7,7,5,5,7,7,0,0,3,3,5,5,6,6,5,5,1,1,0,0,7,7,7,7,5,5,3,3,7,7,0,0,2,2,5,5,0,0,6,6,7,7,7,7,5,5,2,2,1,1,1,1,3,3,6,6,3,3,1,1,0,0,2,2,6,6,1,1,6,6,5,5,0,0,4,4,1,1,6,6,3,3,0,0,5,5,0,0,0,0,1,1,6,6,4,4,3,3,4,4,0,0,4,4,0,0,0,0,0,0,3,3,4,4,4,4,4,4,5,5,2,2,5,5,7,7,6,6,7,7,1,1,4,4,5,5,0,0,0,0,5,5,5,5,0,0,4,4,2,2,5,5,1,1,4,4,1,1,7,7,7,7,6,6,0,0,5,5,7,7,3,3,2,2,7,7,4,4,7,7,3,3,1,1,0,0,4,4,6,6,1,1,2,2,2,2,1,1,7,7,0,0,2,2,7,7,3,3,0,0,1,1,7,7,6,6,3,3,2,2,6,6,1,1,7,7,1,1,7,7,3,3,1,1,5,5,4,4,6,6,1,1,2,2,3,3,1,1,5,5,1,1,7,7,6,6,5,5,0,0,6,6,3,3,5,5,3,3,6,6,1,1,0,0,0,0,2,2,2,2,1,1,7,7,2,2,6,6,2,2,4,4,5,5,6,6,3,3,2,2,6,6,0,0,7,7,1,1,7,7,2,2,4,4,6,6,7,7,2,2,2,2,2,2,4,4,0,0,2,2,6,6,3,3,6,6,6,6,1,1,2,2,2,2,6,6,3,3,4,4,3,3,4,4,3,3,7,7,3,3,2,2,7,7,1,1,7,7,0,0,4,4,2,2,3,3,4,4,3,3,7,7,3,3,0,0,7,7,1,1,5,5,4,4,3,3,6,6,2,2,0,0,2,2,7,7,2,2,6,6,0,0,7,7,0,0,6,6,4,4,5,5,3,3,3,3,1,1,6,6,5,5,5,5,7,7,6,6,3,3,3,3,3,3,5,5,4,4,0,0,6,6,1,1,3,3,4,4,6,6,1,1,1,1,0,0,1,1,0,0,0,0,1,1,5,5,3,3,7,7,2,2,4,4,7,7,1,1,7,7,6,6,2,2,4,4,2,2,7,7,5,5,4,4,5,5,3,3,0,0,1,1,1,1,6,6,0,0,7,7,4,4,5,5,0,0,0,0,1,1,1,1,3,3,1,1,7,7,0,0,2,2,2,2,0,0,0,0,7,7,5,5,4,4,1,1,0,0,5,5,3,3,2,2,2,2,2,2,3,3,3,3,0,0,6,6,0,0,6,6,1,1,5,5,0,0,2,2,5,5,5,5,4,4,4,4,7,7,5,5,4,4,3,3,4,4,4,4,5,5,3,3,4,4,5,5,6,6,7,7,5,5,6,6,2,2,2,2,2,2,7,7,0,0,7,7,0,0,5,5,6,6,1,1,4,4,1,1,5,5,4,4,3,3,4,4,3,3,2,2,1,1,1,1,0,0,0,0,3,3,7,7,1,1,4,4,2,2,2,2,1,1,2,2,4,4,1,1,4,4,2,2,7,7,7,7,1,1,0,0,6,6,0,0,1,1,2,2,0,0,3,3,6,6,0,0,3,3,2,2,1,1,4,4,2,2,7,7,5,5,1,1,5,5,1,1,6,6,7,7,3,3,1,1,5,5,2,2,1,1,1,1,2,2,6,6,5,5,3,3,5,5,5,5,5,5,7,7,0,0,3,3,6,6,0,0,2,2,6,6,2,2,5,5,3,3,1,1,7,7,2,2,4,4,2,2,5,5,3,3,7,7,3,3,0,0,1,1,5,5,5,5,2,2,3,3,0,0,3,3,1,1,5,5,6,6,4,4,1,1,5,5,1,1,1,1,6,6,3,3,6,6,2,2,5,5,6,6,2,2,0,0,2,2,5,5,3,3,2,2,3,3,2,2,7,7,3,3,6,6,2,2,6,6,5,5,0,0,5,5,3,3,1,1,4,4,2,2,6,6,3,3,6,6,5,5,6,6,5,5,2,2,5,5,3,3,1,1,4,4,4,4,7,7,4,4,1,1,5,5,3,3,5,5,0,0,1,1,0,0,1,1,1,1,3,3,7,7,6,6,6,6,5,5,2,2,4,4,2,2,2,2,0,0,7,7,1,1,4,4,0,0,0,0,3,3,5,5,2,2,1,1,1,1,6,6,4,4,2,2,2,2,7,7,0,0,7,7,4,4,1,1,4,4,5,5,3,3,6,6,4,4,4,4,2,2,5,5,2,2,2,2,6,6,0,0,1,1,4,4,3,3,7,7,1,1,5,5,6,6,7,7,3,3,1,1,4,4,4,4,1,1,0,0,6,6,3,3,3,3,4,4,7,7,6,6,4,4,7,7,3,3,0,0,7,7,0,0,1,1,0,0,5,5,3,3,3,3,6,6,7,7,7,7,0,0,0,0,0,0,4,4,2,2,3,3,5,5,3,3,3,3,1,1,3,3,4,4,1,1,6,6,2,2,4,4,7,7,1,1,4,4,7,7,2,2,6,6,5,5,5,5,6,6,7,7,6,6,4,4,2,2,6,6,0,0,5,5,0,0,2,2,1,1,0,0,1,1,1,1,0,0,4,4,4,4,2,2,0,0,4,4,0,0,4,4,2,2,2,2,4,4,1,1,4,4,5,5,5,5,2,2,6,6,5,5,7,7,1,1,2,2,2,2,2,2,6,6,2,2,4,4,3,3,7,7,6,6,5,5,2,2,1,1,5,5,5,5,4,4,3,3,0,0,2,2,5,5,7,7,3,3,2,2,3,3,4,4,2,2,4,4,5,5,4,4,3,3,5,5,4,4,7,7,4,4,5,5,5,5,0,0,6,6,7,7,3,3,4,4,0,0,4,4,3,3,7,7,3,3,5,5,1,1,1,1,5,5,3,3,5,5,5,5,2,2,2,2,5,5,2,2,5,5,6,6,5,5,4,4,4,4,7,7,0,0,5,5,3,3,5,5,7,7,2,2,1,1,6,6,6,6,2,2,5,5,3,3,2,2,0,0,3,3,5,5,5,5,2,2,3,3,7,7,5,5,3,3,4,4,4,4,0,0,3,3,4,4,0,0,2,2,5,5,1,1,6,6,4,4,5,5,0,0,2,2,4,4,1,1,3,3,0,0,0,0,2,2,0,0,0,0,7,7,6,6,6,6,0,0,2,2,4,4,5,5,0,0,2,2,2,2,0,0,2,2,3,3,6,6,3,3,4,4,3,3,1,1,7,7,0,0,2,2,3,3,2,2,4,4,3,3,0,0,2,2,2,2,0,0,0,0,1,1,2,2,1,1,4,4,0,0,0,0,2,2,0,0,5,5,5,5,6,6,0,0,7,7,5,5,4,4,3,3,1,1,0,0,7,7,1,1,4,4,4,4,1,1,0,0,6,6,0,0,7,7,2,2,4,4,7,7,4,4,5,5,3,3,7,7,5,5,7,7,7,7,2,2,0,0,1,1,3,3,5,5,4,4,1,1,6,6,0,0,3,3,4,4,7,7,6,6,6,6,7,7,7,7,2,2,1,1,6,6,7,7,0,0,4,4,2,2,4,4,5,5,5,5,2,2,5,5,4,4,5,5,1,1,0,0,7,7,5,5,5,5,2,2,4,4,2,2,7,7,7,7,3,3,3,3,4,4,4,4,7,7,1,1,2,2,4,4,2,2,6,6,3,3,3,3,3,3,1,1,0,0,4,4,2,2,5,5,2,2,2,2,6,6,5,5,5,5,7,7,1,1,4,4,3,3,0,0,3,3,2,2,3,3,4,4,0,0,2,2,3,3,2,2,2,2,5,5,0,0,3,3,2,2,5,5,7,7,7,7,7,7,1,1,6,6,0,0,2,2,3,3,0,0,4,4,2,2,1,1,5,5,2,2,2,2,1,1,5,5,5,5,3,3,4,4,7,7,3,3,0,0,6,6,0,0,0,0,3,3,1,1,2,2,1,1,5,5,5,5,4,4,0,0,2,2,2,2,7,7,2,2,0,0,0,0,4,4,4,4,1,1,5,5,0,0,6,6,5,5,3,3,1,1,6,6,7,7,6,6,3,3,2,2,3,3,2,2,6,6,4,4,6,6,5,5,2,2,1,1,2,2,2,2,5,5,1,1,1,1,4,4,3,3,4,4,3,3,6,6,1,1,1,1,4,4,0,0,7,7,0,0,5,5,5,5,0,0,4,4,5,5,6,6,3,3,4,4,1,1,6,6,1,1,2,2,5,5,2,2,7,7,1,1,6,6,5,5,0,0,1,1,2,2,5,5,4,4,1,1,7,7,3,3,0,0,2,2,3,3,5,5,5,5,0,0,3,3,0,0,1,1,2,2,7,7,6,6,1,1,4,4,4,4,6,6,6,6,1,1,7,7,0,0,5,5,4,4,1,1,5,5,5,5,4,4,0,0,7,7,2,2,0,0,5,5,2,2,7,7,3,3,1,1,6,6,7,7,7,7,3,3,2,2,4,4,3,3,6,6,6,6,7,7,7,7,1,1,4,4,7,7,1,1,6,6,0,0,2,2,1,1,6,6,7,7,6,6,7,7,3,3,5,5,0,0,0,0,4,4,4,4,1,1,4,4,4,4,5,5,3,3,7,7,4,4,4,4,1,1,5,5,0,0,1,1,3,3,7,7,1,1,3,3,3,3,3,3,6,6,5,5,0,0,3,3,6,6,1,1,4,4,6,6,1,1,5,5,0,0,5,5,4,4,7,7,7,7,1,1,4,4,4,4,1,1,7,7,2,2,6,6,1,1,1,1,0,0,4,4,3,3,5,5,1,1,5,5,5,5,2,2,4,4,5,5,0,0,1,1,7,7,6,6,1,1,0,0,1,1,0,0,4,4,4,4,4,4,4,4,0,0,1,1,5,5,0,0,1,1,6,6,6,6,3,3,7,7,4,4,2,2,0,0,3,3,4,4,3,3,3,3,3,3,2,2,1,1,6,6,5,5,5,5,4,4,6,6,6,6,4,4,3,3,2,2,5,5,7,7,4,4,2,2,3,3,6,6,3,3,0,0,4,4,1,1,4,4,3,3,3,3,5,5,3,3,1,1,5,5,7,7,7,7,7,7,1,1,6,6,2,2,1,1,4,4,1,1,3,3,2,2,3,3,5,5,1,1,6,6,3,3,1,1,0,0,3,3,4,4,7,7,2,2,4,4,1,1,4,4,4,4,0,0,7,7,4,4,0,0,5,5,0,0,7,7,0,0,7,7,3,3,7,7,0,0,2,2,2,2,1,1,1,1,6,6,7,7,3,3,3,3,4,4,7,7,1,1,6,6,0,0,6,6,0,0,4,4,0,0,5,5,2,2,3,3,7,7,0,0,3,3,7,7,0,0,4,4,4,4,5,5,5,5,0,0,2,2,6,6,2,2,4,4,3,3,7,7,5,5,3,3,0,0,6,6,4,4,5,5,0,0,2,2,5,5,0,0,6,6,1,1,0,0,4,4,4,4,0,0,7,7,6,6,1,1,2,2,0,0,1,1,7,7,3,3,4,4,5,5,1,1,3,3,6,6,3,3,3,3,4,4,0,0,6,6,7,7,7,7,4,4,0,0,5,5,1,1,6,6,1,1,1,1,0,0,0,0,7,7,1,1,1,1,7,7,1,1,0,0,5,5,7,7,1,1,1,1,6,6,2,2,2,2,3,3,5,5,3,3,5,5,1,1,2,2,0,0,1,1,4,4,1,1,5,5,1,1,4,4,1,1,0,0,0,0,4,4,0,0,4,4,4,4,5,5,3,3,4,4,2,2,3,3,7,7,1,1,3,3,5,5,2,2,1,1,0,0,0,0,7,7,7,7,2,2,6,6,4,4,3,3,0,0,1,1,0,0,3,3,2,2,2,2,6,6,6,6,6,6,2,2,2,2,3,3,5,5,2,2,0,0,0,0,1,1,1,1,3,3,3,3,6,6,0,0,4,4,7,7,1,1,4,4,7,7,2,2,6,6,0,0,3,3,3,3,3,3,5,5,6,6,1,1,1,1,6,6,7,7,7,7,3,3,0,0,6,6,4,4,1,1,3,3,7,7,7,7,3,3,1,1,5,5,4,4,1,1,4,4,6,6,2,2,2,2,3,3,7,7,3,3,3,3,1,1,3,3,1,1,4,4,3,3,6,6,2,2,7,7,4,4,6,6,7,7,3,3,6,6,5,5,1,1,6,6,4,4,7,7,2,2,7,7,5,5,0,0,4,4,1,1,1,1,4,4,6,6,1,1,0,0,6,6,0,0,5,5,5,5,5,5,4,4,0,0,0,0,7,7,0,0,6,6,0,0,4,4,0,0,6,6,7,7,4,4,6,6,5,5,3,3,4,4,6,6,4,4,1,1,5,5,6,6,1,1,0,0,2,2,2,2,5,5,4,4,5,5,4,4,6,6,1,1,7,7,6,6,1,1,4,4,1,1,6,6,6,6,5,5,3,3,7,7,7,7,7,7,0,0,2,2,4,4,3,3,3,3,5,5,0,0,5,5,7,7,0,0,3,3,3,3,4,4,5,5,5,5,2,2,3,3,4,4,7,7,7,7,6,6,1,1,1,1,6,6,3,3,2,2,7,7,5,5,4,4,6,6,6,6,4,4,6,6,6,6,7,7,0,0,1,1,2,2,2,2,6,6,6,6,0,0,0,0,0,0,7,7,4,4,7,7,5,5,4,4,3,3,5,5,1,1,0,0,6,6,7,7,7,7,5,5,1,1,6,6,2,2,7,7,0,0,5,5,7,7,2,2,1,1,0,0,1,1,2,2,0,0,5,5,1,1,5,5,6,6,3,3,1,1,0,0,0,0,4,4,2,2,3,3,4,4,5,5,4,4,5,5,0,0,3,3,0,0,4,4,1,1,3,3,5,5,2,2,1,1,2,2,6,6,5,5,3,3,4,4,7,7,5,5,4,4,2,2,1,1,3,3,4,4,5,5,5,5,4,4,4,4,0,0,6,6,0,0,7,7,6,6,3,3,2,2,0,0,2,2,4,4,4,4,0,0,4,4,6,6,1,1,3,3,1,1,1,1,4,4,5,5,3,3,6,6,4,4,0,0,0,0,2,2,0,0,2,2,6,6,3,3,2,2,6,6,4,4,5,5,6,6,2,2,5,5,6,6,0,0,6,6,1,1,5,5,1,1,0,0,5,5,2,2,4,4,6,6,7,7,0,0,6,6,7,7,4,4,5,5,0,0,4,4,3,3,2,2,2,2,2,2,1,1,2,2,2,2,3,3,4,4,5,5,5,5,7,7,7,7,1,1,5,5,3,3,4,4,2,2,4,4,0,0,0,0,5,5,4,4,0,0,2,2,7,7,3,3,7,7,7,7,0,0,4,4,1,1,1,1,5,5,1,1,5,5,2,2,1,1,3,3,4,4,1,1,4,4,2,2,4,4,3,3,0,0,3,3,6,6,2,2,3,3,0,0,5,5,7,7,0,0,0,0,5,5,0,0,5,5,4,4,4,4,3,3,2,2,3,3,0,0,0,0,5,5,4,4,0,0,0,0,2,2,5,5,7,7,1,1,7,7,4,4,1,1,5,5,4,4,4,4,4,4,5,5,4,4,5,5,5,5,0,0,6,6,1,1,4,4,5,5,7,7,6,6,0,0,7,7,7,7,3,3,2,2,3,3,4,4,0,0,6,6,4,4,5,5,1,1,6,6,5,5,6,6,2,2,1,1,0,0,0,0,0,0,2,2,7,7,2,2,3,3,7,7,0,0,3,3,2,2,1,1,7,7,3,3,3,3,6,6,3,3,1,1,3,3,4,4,4,4,5,5,6,6,3,3,3,3,6,6,1,1,4,4,1,1,3,3,2,2,5,5,2,2,1,1,2,2,0,0,2,2,0,0,5,5,1,1,3,3,3,3,7,7,4,4,2,2,6,6,1,1,6,6,6,6,3,3,1,1,4,4,5,5,6,6,1,1,1,1,0,0,0,0,2,2,1,1,0,0,2,2,4,4,6,6,1,1,6,6,0,0,6,6,3,3,1,1,5,5,0,0,4,4,0,0,6,6,1,1,1,1,3,3,0,0,5,5,1,1,2,2,3,3,2,2,4,4,1,1,3,3,4,4,4,4,7,7,4,4,1,1,6,6,4,4,5,5,7,7,0,0,6,6,2,2,0,0,0,0,5,5,4,4,7,7,3,3,2,2,6,6,6,6,5,5,1,1,6,6,1,1,1,1,1,1,1,1,4,4,2,2,3,3,3,3,5,5,4,4,4,4,0,0,0,0,3,3,0,0,5,5,7,7,0,0,4,4,3,3,6,6,3,3,1,1,0,0,7,7,1,1,3,3,0,0,4,4,5,5,5,5,7,7,5,5,4,4,1,1,2,2,3,3,0,0,6,6,6,6,4,4,0,0,2,2,2,2,0,0,0,0,1,1,3,3,7,7,0,0,1,1,2,2,6,6,7,7,0,0,1,1,3,3,5,5,0,0,6,6,6,6,5,5,3,3,1,1,4,4,3,3,0,0,6,6,6,6,0,0,2,2,2,2,2,2,5,5,1,1,7,7,2,2,3,3,0,0,0,0,3,3,5,5,2,2,7,7,1,1,2,2,4,4,0,0,0,0,6,6,4,4,5,5,6,6,4,4,4,4,5,5,3,3,7,7,7,7,2,2,1,1,2,2,6,6,6,6,6,6,2,2,1,1,6,6,0,0,6,6,1,1,4,4,4,4,1,1,0,0,0,0,1,1,4,4,4,4,2,2,7,7,4,4,4,4,4,4,5,5,4,4,5,5,4,4,6,6,3,3,4,4,6,6,5,5,2,2,0,0,2,2,0,0,0,0,7,7,2,2,5,5,2,2,2,2,6,6,1,1,5,5,5,5,3,3,6,6,4,4,2,2,1,1,2,2,5,5,7,7,2,2,1,1,7,7,7,7,3,3,1,1,6,6,2,2,1,1,1,1,0,0,7,7,2,2,4,4,0,0,6,6,1,1,2,2,7,7,7,7,2,2,3,3,4,4,4,4,1,1,2,2,7,7,6,6,0,0,0,0,4,4,5,5,2,2,4,4,1,1,3,3,7,7,3,3,0,0,7,7,2,2,1,1,2,2,1,1,1,1,6,6,4,4,1,1,1,1,0,0,1,1,5,5,2,2,4,4,3,3,6,6,7,7,1,1,3,3,3,3,0,0,3,3,2,2,2,2,7,7,2,2,6,6,6,6,3,3,2,2,5,5,3,3,5,5,3,3,2,2,6,6,4,4,2,2,0,0,2,2,6,6,2,2,2,2,2,2,6,6,4,4,0,0,4,4,4,4,7,7,3,3,1,1,0,0,6,6,5,5,3,3,4,4,1,1,2,2,2,2,1,1,3,3,1,1,7,7,6,6,1,1,3,3,2,2,4,4,1,1,0,0,1,1,1,1,7,7,5,5,2,2,3,3,2,2,1,1,3,3,6,6,0,0,0,0,1,1,6,6,4,4,7,7,1,1,5,5,1,1,1,1,0,0,4,4,2,2,7,7,7,7,6,6,1,1,0,0,4,4,4,4,7,7,2,2,2,2,3,3,7,7,1,1,4,4,3,3,2,2,6,6,7,7,2,2,7,7,0,0,0,0,7,7,7,7,4,4,1,1,3,3,4,4,6,6,0,0,5,5,4,4,2,2,4,4,2,2,6,6,6,6,4,4,4,4,7,7,2,2,0,0,0,0,2,2,7,7,4,4,5,5,2,2,2,2,5,5,6,6,6,6,1,1,2,2,7,7,4,4,3,3,6,6,6,6,5,5,1,1,3,3,3,3,7,7,4,4,3,3,5,5,5,5,5,5,0,0,1,1,4,4,5,5,1,1,5,5,5,5,5,5,6,6,6,6,0,0,4,4,5,5,6,6,3,3,4,4,4,4,7,7,4,4,1,1,3,3,7,7,5,5,5,5,5,5,3,3,0,0,0,0,7,7,0,0,7,7,7,7,5,5,4,4,1,1,1,1,4,4,3,3,2,2,4,4,7,7,2,2,2,2,1,1,7,7,1,1,2,2,2,2,6,6,5,5,3,3,1,1,1,1,6,6,6,6,1,1,5,5,5,5,6,6,4,4,4,4,3,3,5,5,3,3,1,1,5,5,3,3,7,7,0,0,0,0,7,7,6,6,5,5,5,5,6,6,6,6,0,0,5,5,5,5,4,4,6,6,1,1,4,4,5,5,1,1,3,3,4,4,2,2,1,1,1,1,3,3,2,2,3,3,3,3,4,4,3,3,6,6,7,7,3,3,5,5,2,2,7,7,4,4,3,3,7,7,1,1,2,2,5,5,0,0,2,2,7,7,5,5,1,1,7,7,1,1,6,6,1,1,0,0,1,1,0,0,0,0,3,3,4,4,2,2,1,1,4,4,4,4,3,3,4,4,6,6,0,0,2,2,0,0,4,4,4,4,3,3,2,2,3,3,6,6,1,1,0,0,4,4,2,2,6,6,6,6,7,7,2,2,5,5,0,0,0,0,6,6,7,7,0,0,5,5,2,2,7,7,2,2,2,2,5,5,4,4,6,6,0,0,3,3,4,4,4,4,6,6,2,2,7,7,3,3,2,2,1,1,6,6,4,4,0,0,4,4,6,6,6,6,3,3,5,5,6,6,5,5,3,3,4,4,1,1,7,7,0,0,0,0,5,5,1,1,7,7,4,4,1,1,5,5,7,7,0,0,2,2,7,7,1,1,0,0,3,3,4,4,2,2,3,3,2,2,3,3,0,0,2,2,1,1,3,3,2,2,4,4,2,2,3,3,2,2,3,3,5,5,0,0,0,0,3,3,0,0,0,0,7,7,5,5,7,7,0,0,2,2,2,2,7,7,4,4,6,6,7,7,1,1,1,1,7,7,2,2,2,2,5,5,7,7,2,2,7,7,7,7,3,3,3,3,2,2,4,4,0,0,5,5,0,0,0,0,2,2,3,3,4,4,5,5,1,1,7,7,2,2,0,0,2,2,6,6,0,0,4,4,2,2,3,3,2,2,1,1,2,2,2,2,0,0,7,7,4,4,7,7,3,3,3,3,3,3,6,6,1,1,0,0,5,5,4,4,4,4,3,3,7,7,3,3,4,4,0,0,1,1,0,0,4,4,4,4,4,4,2,2,6,6,7,7,0,0,2,2,0,0,2,2,3,3,6,6,2,2,5,5,3,3,0,0,1,1,0,0,7,7,7,7,7,7,0,0,1,1,5,5,4,4,3,3,1,1,3,3,7,7,6,6,2,2,5,5,2,2,6,6,6,6,7,7,4,4,6,6,2,2,0,0,5,5,3,3,6,6,1,1,6,6,3,3,4,4,1,1,0,0,3,3,3,3,7,7,2,2,0,0,5,5,5,5,3,3,4,4,0,0,1,1,0,0,4,4,2,2,1,1,7,7,6,6,6,6,3,3,5,5,5,5,5,5,6,6,7,7,0,0,5,5,4,4,4,4,4,4,6,6,1,1,6,6,7,7,7,7,3,3,1,1,3,3,2,2,2,2,7,7,7,7,7,7,0,0,3,3,2,2,7,7,1,1,2,2,3,3,2,2,0,0,4,4,2,2,6,6,2,2,5,5,4,4,1,1,3,3,5,5,3,3,2,2,0,0,3,3,4,4,0,0,2,2,7,7,0,0,3,3,4,4,6,6,0,0,2,2,7,7,5,5,6,6,1,1,7,7,6,6,3,3,6,6,7,7,1,1,5,5,1,1,4,4,6,6,7,7,3,3,3,3,5,5,4,4,4,4,1,1,7,7,7,7,7,7,4,4,4,4,7,7,1,1,0,0,4,4,1,1,4,4,0,0,6,6,6,6,1,1,4,4,5,5,4,4,6,6,3,3,7,7,1,1,7,7,7,7,2,2,3,3,4,4,0,0,1,1,5,5,4,4,0,0,4,4,6,6,4,4,7,7,4,4,3,3,4,4,4,4,1,1,4,4,4,4,0,0,7,7,7,7,0,0,5,5,7,7,2,2,0,0,3,3,4,4,1,1,7,7,1,1,7,7,7,7,1,1,1,1,2,2,0,0,6,6,2,2,6,6,6,6,2,2,6,6,3,3,3,3,0,0,7,7,6,6,6,6,7,7,5,5,4,4,0,0,3,3,0,0,5,5,6,6,0,0,4,4,3,3,5,5,3,3,6,6,3,3,4,4,6,6,4,4,7,7,3,3,2,2,6,6,2,2,6,6,6,6,3,3,7,7,6,6,1,1,6,6,4,4,0,0,2,2,3,3,0,0,5,5,0,0,3,3,3,3,0,0,6,6,3,3,7,7,3,3,0,0,2,2,2,2,5,5,2,2,0,0,1,1,7,7,4,4,4,4,2,2,4,4,7,7,5,5,1,1,7,7,4,4,5,5,6,6,7,7,6,6,3,3,3,3,4,4,3,3,6,6,5,5,3,3,2,2,1,1,0,0,6,6,2,2,3,3,0,0,2,2,4,4,0,0,7,7,2,2,3,3,1,1,7,7,0,0,4,4,3,3,0,0,3,3,0,0,2,2,7,7,1,1,3,3,0,0,0,0,3,3,7,7,1,1,1,1,2,2,6,6,0,0,1,1,7,7,5,5,0,0,3,3,1,1,1,1,1,1,1,1,5,5,4,4,0,0,2,2,7,7,5,5,4,4,1,1,2,2,1,1,1,1,3,3,0,0,5,5,6,6,7,7,6,6,4,4,0,0,3,3,7,7,0,0,0,0,0,0,5,5,3,3,4,4,3,3,4,4,3,3,4,4,1,1,7,7,0,0,0,0,0,0,3,3,4,4,1,1,3,3,1,1,5,5,7,7,2,2,3,3,2,2,0,0,7,7,5,5,4,4,3,3,7,7,7,7,3,3,4,4,2,2,4,4,5,5,7,7,0,0,1,1,5,5,0,0,4,4,6,6,5,5,2,2,3,3,2,2,0,0,5,5,5,5,4,4,4,4,6,6,1,1,7,7,4,4,1,1,7,7,5,5,3,3,6,6,2,2,2,2,5,5,0,0,0,0,4,4,2,2,0,0,5,5,5,5,7,7,6,6,4,4,7,7,0,0,7,7,3,3,5,5,4,4,2,2,3,3,3,3,4,4,7,7,7,7,1,1,3,3,1,1,7,7,0,0,7,7,7,7,4,4,4,4,1,1,3,3,7,7,0,0,5,5,2,2,1,1,0,0,2,2,7,7,2,2,2,2,5,5,4,4,1,1,5,5,0,0,0,0,6,6,3,3,1,1,6,6,5,5,5,5,5,5,0,0,0,0,2,2,1,1,0,0,7,7,0,0,0,0,6,6,7,7,0,0,2,2,7,7,2,2,0,0,6,6,2,2,2,2,0,0,0,0,7,7,1,1,4,4,5,5,2,2,3,3,0,0,3,3,2,2,1,1,5,5,0,0,2,2,3,3,7,7,2,2,0,0,5,5,7,7,4,4,4,4,2,2,5,5,5,5,6,6,3,3,0,0,6,6,5,5,7,7,6,6,4,4,7,7,2,2,0,0,0,0,0,0,5,5,3,3,4,4,3,3,1,1,2,2,0,0,7,7,1,1,3,3,3,3,4,4,5,5,3,3,5,5,4,4,2,2,6,6,2,2,3,3,4,4,0,0,0,0,5,5,2,2,6,6,7,7,6,6,5,5,7,7,7,7,0,0,7,7,5,5,4,4,7,7,5,5,6,6,3,3,3,3,0,0,2,2,0,0,3,3,6,6,5,5,0,0,2,2,0,0,7,7,7,7,2,2,3,3,5,5,6,6,5,5,6,6,5,5,1,1,4,4,0,0,6,6,0,0,4,4,1,1,5,5,0,0,1,1,0,0,7,7,4,4,7,7,2,2,3,3,1,1,0,0,5,5,3,3,3,3,6,6,0,0,2,2,3,3,1,1,1,1,6,6,4,4,3,3,2,2,4,4,5,5,4,4,3,3,0,0,4,4,5,5,7,7,5,5,2,2,6,6,3,3,5,5,5,5,6,6,5,5,3,3,0,0,6,6,4,4,0,0,2,2,6,6,3,3,2,2,0,0,4,4,4,4,1,1,1,1,4,4,7,7,2,2,7,7,0,0,6,6,4,4,7,7,2,2,7,7,1,1,7,7,3,3,2,2,4,4,4,4,3,3,2,2,2,2,6,6,3,3,1,1,0,0,1,1,6,6,3,3,4,4,6,6,1,1,0,0,4,4,6,6,2,2,4,4,5,5,2,2,0,0,7,7,4,4,1,1,2,2,6,6,2,2,2,2,2,2,6,6,1,1,6,6,7,7,2,2,3,3,5,5,1,1,6,6,3,3,0,0,1,1,6,6,0,0,4,4,5,5,2,2,1,1,4,4,7,7,0,0,1,1,1,1,2,2,2,2,4,4,5,5,0,0,1,1,6,6,5,5,3,3,0,0,1,1,2,2,6,6,0,0,3,3,7,7,4,4,5,5,2,2,4,4,2,2,4,4,7,7,2,2,6,6,5,5,5,5,1,1,2,2,0,0,7,7,6,6,2,2,0,0,5,5,4,4,3,3,2,2,6,6,3,3,1,1,4,4,6,6,3,3,3,3,2,2,6,6,7,7,3,3,4,4,0,0,4,4,5,5,0,0,0,0,7,7,0,0,2,2,1,1,1,1,6,6,3,3,0,0,1,1,3,3,7,7,4,4,3,3,7,7,4,4,2,2,2,2,6,6,5,5,2,2,5,5,5,5,3,3,4,4,1,1,1,1,4,4,4,4,5,5,7,7,6,6,3,3,5,5,1,1,6,6,4,4,5,5,5,5,2,2,3,3,7,7,5,5,2,2,3,3,4,4,0,0,6,6,0,0,0,0,1,1,6,6,7,7,1,1,0,0,0,0,0,0,7,7,5,5,5,5,1,1,2,2,6,6,6,6,7,7,7,7,6,6,5,5,6,6,4,4,7,7,7,7,3,3,4,4,0,0,2,2,1,1,2,2,4,4,4,4,3,3,4,4,2,2,6,6,3,3,4,4,1,1,6,6,4,4,3,3,3,3,0,0,1,1,0,0,2,2,2,2,5,5,1,1,7,7,4,4,2,2,7,7,5,5,2,2,1,1,0,0,5,5,7,7,1,1,4,4,6,6,2,2,6,6,4,4,5,5,2,2,0,0,4,4,5,5,0,0,6,6,0,0,4,4,1,1,3,3,6,6,4,4,5,5,5,5,5,5,0,0,0,0,4,4,3,3,0,0,3,3,3,3,4,4,5,5,4,4,0,0,3,3,6,6,1,1,4,4,7,7,3,3,7,7,3,3,7,7,4,4,0,0,3,3,4,4,7,7,5,5,2,2,3,3,1,1,3,3,1,1,5,5,0,0,5,5,2,2,7,7,7,7,0,0,2,2,5,5,3,3,6,6,5,5,3,3,7,7,2,2,0,0,2,2,1,1,4,4,3,3,2,2,3,3,0,0,7,7,1,1,2,2,2,2,6,6,4,4,4,4,1,1,2,2,7,7,3,3,6,6,0,0,6,6,5,5,6,6,2,2,1,1,0,0,0,0,0,0,6,6,1,1,6,6,0,0,7,7,4,4,1,1,0,0,6,6,0,0,1,1,3,3,6,6,4,4,6,6,4,4,0,0,7,7,3,3,4,4,2,2,2,2,1,1,2,2,1,1,3,3,3,3,3,3,7,7,3,3,2,2,1,1,1,1,4,4,5,5,6,6,1,1,2,2,4,4,0,0,2,2,1,1,3,3,1,1,4,4,6,6,6,6,7,7,6,6,6,6,6,6,3,3,5,5,2,2,1,1,3,3,6,6,1,1,5,5,5,5,5,5,3,3,4,4,3,3,0,0,3,3,3,3,2,2,2,2,7,7,4,4,2,2,5,5,3,3,5,5,5,5,1,1,4,4,6,6,5,5,4,4,4,4,0,0,0,0,5,5,6,6,0,0,1,1,5,5,2,2,0,0,2,2,0,0,0,0,0,0,3,3,2,2,0,0,3,3,5,5,2,2,2,2,2,2,5,5,7,7,3,3,4,4,5,5,6,6,2,2,0,0,4,4,6,6,7,7,0,0,6,6,3,3,5,5,0,0,6,6,4,4,6,6,4,4,6,6,4,4,2,2,5,5,0,0,5,5,4,4,2,2,1,1,4,4,6,6,6,6,1,1,3,3,4,4,3,3,2,2,0,0,4,4,1,1,1,1,3,3,7,7,2,2,4,4,7,7,1,1,4,4,3,3,0,0,6,6,0,0,6,6,7,7,1,1,0,0,5,5,3,3,6,6,5,5,5,5,5,5,2,2,4,4,5,5,3,3,4,4,7,7,6,6,4,4,7,7,2,2,2,2,2,2,4,4,4,4,6,6,7,7,6,6,1,1,3,3,4,4,6,6,5,5,3,3,1,1,3,3,1,1,7,7,3,3,1,1,1,1,1,1,5,5,0,0,0,0,6,6,2,2,6,6,1,1,5,5,0,0,6,6,2,2,2,2,2,2,5,5,7,7,6,6,3,3,0,0,0,0,4,4,6,6,1,1,1,1,5,5,1,1,2,2,0,0,4,4,5,5,6,6,1,1,7,7,3,3,2,2,1,1,2,2,1,1,4,4,1,1,1,1,2,2,3,3,2,2,4,4,4,4,4,4,7,7,4,4,6,6,2,2,1,1,0,0,7,7,0,0,3,3,2,2,5,5,0,0,7,7,0,0,0,0,0,0,1,1,4,4,5,5,1,1,3,3,4,4,1,1,5,5,7,7,2,2,2,2,1,1,3,3,6,6,1,1,3,3,5,5,0,0,6,6,7,7,1,1,4,4,0,0,4,4,0,0,1,1,6,6,0,0,0,0,2,2,2,2,0,0,1,1,7,7,2,2,7,7,6,6,3,3,1,1,2,2,1,1,6,6,4,4,4,4,4,4,0,0,0,0,6,6,4,4,2,2,3,3,3,3,3,3,5,5,4,4,0,0,3,3,6,6,6,6,1,1,6,6,1,1,5,5,6,6,0,0,0,0,2,2,2,2,1,1,7,7,6,6,2,2,0,0,1,1,4,4,1,1,7,7,0,0,0,0,3,3,5,5,4,4,3,3,3,3,1,1,0,0,1,1,0,0,4,4,2,2,7,7,5,5,6,6,5,5,2,2,4,4,3,3,5,5,6,6,3,3,7,7,5,5,5,5,4,4,5,5,2,2,6,6,2,2,4,4,6,6,1,1,0,0,4,4,3,3,1,1,0,0,3,3,1,1,2,2,5,5,7,7,5,5,0,0,0,0,4,4,2,2,1,1,0,0,0,0,5,5,7,7,1,1,4,4,7,7,5,5,0,0,0,0,1,1,4,4,0,0,4,4,2,2,0,0,0,0,2,2,1,1,5,5,2,2,0,0,6,6,6,6,0,0,4,4,5,5,4,4,3,3,0,0,3,3,1,1,0,0,4,4,4,4,3,3,5,5,3,3,5,5,7,7,3,3,6,6,5,5,4,4,4,4,4,4,3,3,5,5,7,7,7,7,2,2,7,7,0,0,1,1,4,4,6,6,6,6,0,0,3,3,6,6,5,5,4,4,4,4,1,1,7,7,0,0,2,2,4,4,2,2,0,0,0,0,5,5,4,4,5,5,6,6,5,5,6,6,5,5,1,1,1,1,7,7,0,0,1,1,6,6,6,6,3,3,2,2,3,3,6,6,7,7,2,2,2,2,4,4,7,7,7,7,2,2,7,7,0,0,3,3,3,3,7,7,4,4,7,7,1,1,6,6,5,5,2,2,3,3,3,3,5,5,7,7,0,0,5,5,7,7,1,1,5,5,6,6,6,6,3,3,2,2,5,5,5,5,0,0,2,2,4,4,1,1,0,0,5,5,0,0,7,7,0,0,7,7,0,0,2,2,0,0,3,3,7,7,2,2,6,6,1,1,4,4,5,5,1,1,5,5,4,4,3,3,3,3,2,2,5,5,5,5,6,6,3,3,0,0,1,1,1,1,0,0,4,4,0,0,0,0,2,2,2,2,3,3,4,4,0,0,1,1,6,6,7,7,6,6,0,0,2,2,4,4,4,4,7,7,6,6,4,4,1,1,4,4,7,7,1,1,1,1,0,0,2,2,0,0,7,7,5,5,2,2,5,5,1,1,0,0,2,2,7,7,1,1,1,1,0,0,4,4,1,1,6,6,1,1,5,5,6,6,1,1,4,4,5,5,6,6,6,6,5,5,0,0,6,6,7,7,7,7,5,5,3,3,7,7,3,3,5,5,6,6,3,3,1,1,5,5,6,6,6,6,0,0,6,6,2,2,4,4,2,2,0,0,4,4,0,0,7,7,0,0,3,3,2,2,6,6,4,4,4,4,0,0,2,2,7,7,6,6,5,5,4,4,2,2,4,4,0,0,3,3,3,3,5,5,5,5,1,1,4,4,1,1,2,2,0,0,1,1,2,2,2,2,5,5,4,4,6,6,6,6,2,2,5,5,2,2,5,5,5,5,7,7,5,5,6,6,7,7,4,4,2,2,7,7,3,3,6,6,2,2,5,5,4,4,3,3,1,1,6,6,3,3,2,2,7,7,6,6,1,1,4,4,1,1,1,1,0,0,1,1,5,5,2,2,3,3,4,4,6,6,0,0,0,0,5,5,5,5,0,0,3,3,2,2,2,2,2,2,4,4,2,2,4,4,2,2,1,1,2,2,7,7,0,0,7,7,2,2,3,3,6,6,7,7,4,4,0,0,2,2,4,4,6,6,5,5,0,0,2,2,1,1,5,5,3,3,7,7,2,2,3,3,7,7,6,6,6,6,6,6,0,0,4,4,2,2,5,5,4,4,2,2,5,5,1,1,2,2,0,0,4,4,2,2,0,0,3,3,4,4,3,3,7,7,3,3,5,5,0,0,4,4,3,3,5,5,6,6,7,7,2,2,2,2,0,0,6,6,1,1,4,4,0,0,0,0,3,3,2,2,0,0,0,0,2,2,1,1,3,3,7,7,2,2,2,2,6,6,5,5,1,1,4,4,3,3,2,2,7,7,5,5,2,2,4,4,1,1,1,1,4,4,6,6,5,5,3,3,1,1,7,7,6,6,5,5,6,6,0,0,0,0,7,7,4,4,3,3,2,2,4,4,4,4,6,6,4,4,0,0,5,5,0,0,4,4,2,2,1,1,0,0,1,1,2,2,7,7,6,6,2,2,7,7,7,7,6,6,1,1,0,0,3,3,3,3,1,1,3,3,0,0,0,0,7,7,3,3,2,2,7,7,1,1,2,2,3,3,5,5,5,5,0,0,6,6,4,4,3,3,0,0,4,4,0,0,2,2,6,6,6,6,4,4,3,3,2,2,4,4,4,4,7,7,1,1,6,6,4,4,5,5,6,6,0,0,1,1,1,1,5,5,4,4,0,0,6,6,0,0,2,2,5,5,0,0,0,0,7,7,6,6,2,2,0,0,2,2,5,5,2,2,3,3,0,0,5,5,5,5,6,6,4,4,1,1,4,4,5,5,5,5,7,7,2,2,0,0,3,3,3,3,3,3,7,7,3,3,5,5,2,2,3,3,4,4,7,7,2,2,6,6,5,5,0,0,6,6,0,0,4,4,2,2,1,1,3,3,3,3,4,4,2,2,3,3,0,0,2,2,4,4,4,4,2,2,4,4,6,6,5,5,3,3,0,0,1,1,6,6,1,1,4,4,4,4,1,1,1,1,6,6,7,7,3,3,1,1,5,5,4,4,4,4,1,1,1,1,4,4,3,3,2,2,2,2,7,7,0,0,5,5,2,2,4,4,6,6,3,3,7,7,7,7,6,6,1,1,0,0,5,5,6,6,4,4,1,1,5,5,6,6,0,0,7,7,7,7,1,1,4,4,4,4,4,4,1,1,3,3,3,3,2,2,6,6,2,2,1,1,3,3,1,1,0,0,2,2,4,4,6,6,4,4,6,6,5,5,7,7,7,7,2,2,6,6,5,5,1,1,1,1,7,7,5,5,0,0,3,3,3,3,2,2,1,1,3,3,6,6,3,3,5,5,2,2,6,6,6,6,1,1,3,3,2,2,7,7,0,0,2,2,3,3,7,7,0,0,1,1,5,5,2,2,6,6,3,3,0,0,1,1,6,6,6,6,1,1,1,1,2,2,6,6,6,6,6,6,4,4,0,0,7,7,5,5,5,5,0,0,6,6,5,5,3,3,2,2,4,4,3,3,5,5,5,5,3,3,0,0,7,7,2,2,7,7,5,5,1,1,4,4,2,2,6,6,6,6,0,0,2,2,0,0,7,7,2,2,3,3,1,1,0,0,3,3,6,6,3,3,1,1,3,3,0,0,7,7,2,2,1,1,1,1,5,5,0,0,6,6,2,2,7,7,5,5,3,3,0,0,7,7,1,1,2,2,3,3,5,5,0,0,6,6,3,3,4,4,3,3,7,7,2,2,1,1,3,3,3,3,3,3,3,3,5,5,0,0,3,3,5,5,1,1,0,0,2,2,7,7,5,5,0,0,1,1,7,7,5,5,4,4,0,0,0,0,4,4,4,4,7,7,6,6,7,7,4,4,1,1,1,1,5,5,5,5,3,3,2,2,0,0,4,4,2,2,5,5,1,1,5,5,1,1,5,5,7,7,7,7,3,3,7,7,0,0,6,6,6,6,2,2,2,2,4,4,1,1,3,3,0,0,2,2,2,2,5,5,5,5,0,0,5,5,3,3,6,6,4,4,6,6,3,3,1,1,4,4,4,4,4,4,4,4,3,3,5,5,1,1,5,5,7,7,3,3,4,4,2,2,3,3,0,0,6,6,7,7,1,1,7,7,4,4,1,1,3,3,0,0,0,0,0,0,1,1,6,6,5,5,5,5,5,5,6,6,4,4,7,7,4,4,5,5,4,4,3,3,4,4,4,4,5,5,0,0,0,0,3,3,4,4,1,1,0,0,5,5,1,1,2,2,4,4,2,2,5,5,4,4,3,3,2,2,2,2,2,2,7,7,6,6,7,7,0,0,4,4,1,1,2,2,5,5,1,1,0,0,5,5,4,4,1,1,3,3,0,0,3,3,1,1,4,4,0,0,5,5,0,0,6,6,3,3,1,1,0,0,0,0,2,2,6,6,4,4,1,1,7,7,0,0,1,1,1,1,0,0,2,2,2,2,1,1,4,4,1,1,6,6,7,7,0,0,5,5,3,3,0,0,3,3,4,4,0,0,3,3,6,6,7,7,5,5,1,1,5,5,7,7,5,5,4,4,0,0,2,2,2,2,5,5,5,5,0,0,2,2,1,1,7,7,6,6,0,0,3,3,1,1,1,1,1,1,2,2,1,1,7,7,6,6,3,3,4,4,4,4,4,4,4,4,0,0,5,5,1,1,4,4,0,0,2,2,2,2,2,2,0,0,5,5,7,7,2,2,7,7,6,6,4,4,6,6,1,1,7,7,0,0,5,5,6,6,6,6,5,5,4,4,1,1,5,5,6,6,0,0,2,2,1,1,7,7,1,1,7,7,5,5,7,7,2,2,0,0,5,5,0,0,6,6,7,7,2,2,2,2,0,0,5,5,0,0,4,4,1,1,7,7,2,2,1,1,3,3,2,2,0,0,5,5,6,6,3,3,4,4,7,7,1,1,1,1,3,3,2,2,0,0,3,3,4,4,7,7,0,0,6,6,4,4,2,2,5,5,5,5,4,4,5,5,6,6,2,2,4,4,1,1,5,5,4,4,3,3,1,1,0,0,1,1,0,0,5,5,4,4,5,5,2,2,1,1,0,0,1,1,7,7,4,4,3,3,0,0,7,7,6,6,0,0,4,4,5,5,6,6,0,0,2,2,6,6,2,2,6,6,4,4,5,5,5,5,4,4,3,3,6,6,1,1,1,1,1,1,5,5,2,2,5,5,7,7,6,6,4,4,5,5,5,5,2,2,4,4,7,7,3,3,3,3,6,6,0,0,1,1,3,3,0,0,0,0,6,6,2,2,1,1,4,4,3,3,3,3,3,3,7,7,3,3,5,5,5,5,2,2,0,0,0,0,4,4,0,0,1,1,6,6,1,1,5,5,1,1,1,1,3,3,1,1,6,6,6,6,1,1,0,0,0,0,1,1,0,0,2,2,5,5,6,6,7,7,5,5,2,2,5,5,7,7,0,0,3,3,5,5,3,3,4,4,3,3,4,4,2,2,5,5,3,3,4,4,6,6,0,0,2,2,0,0,6,6,7,7,4,4,1,1,0,0,6,6,3,3,7,7,4,4,1,1,3,3,0,0,3,3,3,3,7,7,6,6,2,2,1,1,0,0,0,0,4,4,6,6,0,0,4,4,1,1,3,3,0,0,0,0,2,2,0,0,6,6,5,5,1,1,6,6,0,0,0,0,1,1,6,6,0,0,6,6,1,1,4,4,3,3,1,1,0,0,2,2,6,6,7,7,3,3,4,4,4,4,3,3,5,5,6,6,1,1,2,2,3,3,2,2,4,4,4,4,6,6,7,7,7,7,6,6,3,3,2,2,6,6,7,7,0,0,3,3,7,7,1,1,2,2,4,4,2,2,2,2,4,4,3,3,0,0,4,4,0,0,4,4,0,0,5,5,2,2,5,5,4,4,6,6,7,7,1,1,0,0,4,4,6,6,0,0,6,6,1,1,5,5,7,7,4,4,4,4,1,1,1,1,4,4,2,2,6,6,7,7,6,6,5,5,5,5,3,3,4,4,5,5,0,0,5,5,5,5,0,0,2,2,0,0,6,6,7,7,0,0,5,5,1,1,1,1,0,0,4,4,1,1,1,1,0,0,4,4,5,5,0,0,0,0,0,0,4,4,5,5,1,1,6,6,7,7,1,1,3,3,3,3,2,2,0,0,6,6,4,4,0,0,4,4,2,2,4,4,0,0,1,1,1,1,0,0,3,3,5,5,2,2,5,5,7,7,7,7,3,3,3,3,5,5,2,2,6,6,7,7,7,7,2,2,5,5,5,5,1,1,2,2,4,4,4,4,4,4,6,6,6,6,0,0,0,0,4,4,1,1,3,3,0,0,5,5,4,4,7,7,5,5,1,1,5,5,1,1,1,1,7,7,2,2,5,5,1,1,7,7,4,4,1,1,4,4,3,3,3,3,1,1,3,3,2,2,3,3,2,2,0,0,3,3,0,0,0,0,1,1,0,0,3,3,3,3,0,0,1,1,2,2,3,3,6,6,6,6,0,0,3,3,7,7,7,7,5,5,1,1,7,7,2,2,7,7,0,0,4,4,1,1,7,7,7,7,4,4,2,2,4,4,6,6,4,4,3,3,5,5,5,5,1,1,7,7,5,5,1,1,3,3,2,2,4,4,0,0,1,1,6,6,3,3,4,4,7,7,5,5,4,4,1,1,0,0,1,1,6,6,1,1,4,4,5,5,7,7,5,5,0,0,0,0,6,6,3,3,5,5,1,1,5,5,3,3,0,0,6,6,2,2,0,0,3,3,3,3,7,7,5,5,3,3,4,4,3,3,6,6,1,1,5,5,3,3,4,4,5,5,2,2,4,4,3,3,7,7,2,2,5,5,7,7,3,3,7,7,4,4,1,1,3,3,5,5,6,6,4,4,6,6,4,4,6,6,0,0,0,0,0,0,6,6,0,0,0,0,0,0,4,4,5,5,1,1,1,1,6,6,3,3,4,4,2,2,0,0,6,6,2,2,2,2,1,1,0,0,2,2,2,2,0,0,0,0,6,6,1,1,0,0,3,3,5,5,6,6,1,1,3,3,4,4,3,3,3,3,1,1,7,7,1,1,6,6,5,5,3,3,0,0,4,4,2,2,2,2,5,5,2,2,4,4,6,6,2,2,4,4,4,4,1,1,2,2,2,2,5,5,3,3,6,6,2,2,1,1,2,2,5,5,6,6,5,5,3,3,4,4,1,1,6,6,7,7,7,7,2,2,1,1,5,5,4,4,2,2,7,7,0,0,4,4,7,7,0,0,5,5,5,5,1,1,4,4,0,0,4,4,5,5,1,1,5,5,1,1,3,3,2,2,5,5,3,3,4,4,5,5,1,1,1,1,4,4,5,5,4,4,2,2,4,4,1,1,0,0,0,0,6,6,4,4,6,6,5,5,2,2,1,1,3,3,0,0,2,2,1,1,1,1,7,7,4,4,1,1,3,3,3,3,3,3,0,0,7,7,2,2,5,5,3,3,1,1,6,6,2,2,1,1,0,0,1,1,1,1,6,6,0,0,3,3,7,7,5,5,0,0,2,2,4,4,5,5,1,1,0,0,2,2,2,2,5,5,3,3,2,2,0,0,5,5,4,4,5,5,4,4,4,4,2,2,2,2,3,3,3,3,2,2,4,4,5,5,5,5,6,6,4,4,6,6,6,6,0,0,6,6,4,4,4,4,2,2,5,5,5,5,2,2,2,2,4,4,4,4,7,7,7,7,0,0,1,1,1,1,2,2,5,5,5,5,4,4,5,5,7,7,7,7,0,0,3,3,3,3,5,5,6,6,4,4,4,4,3,3,1,1,2,2,4,4,5,5,3,3,4,4,3,3,1,1,6,6,2,2,1,1,2,2,2,2,6,6,4,4,4,4,2,2,7,7,7,7,0,0,2,2,4,4,5,5,2,2,3,3,5,5,1,1,4,4,5,5,0,0,3,3,4,4,3,3,4,4,0,0,7,7,4,4,1,1,4,4,4,4,7,7,0,0,5,5,5,5,2,2,7,7,1,1,0,0,7,7,5,5,3,3,1,1,3,3,7,7,3,3,7,7,5,5,6,6,1,1,5,5,6,6,1,1,5,5,5,5,0,0,3,3,3,3,1,1,0,0,7,7,0,0,7,7,5,5,7,7,7,7,2,2,0,0,1,1,3,3,6,6,1,1,7,7,7,7,2,2,1,1,7,7,7,7,2,2,3,3,7,7,1,1,0,0,7,7,4,4,2,2,0,0,2,2,4,4,1,1,7,7,0,0,2,2,7,7,5,5,5,5,4,4,1,1,1,1,7,7,3,3,6,6,3,3,0,0,6,6,4,4,1,1,7,7,1,1,0,0,7,7,3,3,1,1,4,4,6,6,6,6,2,2,7,7,2,2,1,1,3,3,3,3,5,5,6,6,6,6,1,1,6,6,6,6,5,5,4,4,3,3,2,2,3,3,7,7,6,6,3,3,2,2,3,3,7,7,2,2,4,4,5,5,1,1,0,0,3,3,4,4,7,7,2,2,4,4,5,5,2,2,2,2,4,4,0,0,2,2,2,2,0,0,1,1,5,5,2,2,0,0,0,0,5,5,2,2,1,1,7,7,0,0,3,3,6,6,3,3,4,4,4,4,3,3,2,2,3,3,3,3,1,1,3,3,2,2,0,0,7,7,7,7,2,2,1,1,2,2,7,7,0,0,7,7,3,3,3,3,4,4,4,4,3,3,5,5,0,0,1,1,1,1,0,0,1,1,5,5,7,7,0,0,2,2,0,0,3,3,5,5,3,3,5,5,1,1,4,4,0,0,0,0,0,0,3,3,4,4,1,1,4,4,4,4,4,4,3,3,3,3,1,1,4,4,1,1,1,1,2,2,2,2,0,0,4,4,5,5,7,7,1,1,4,4,6,6,4,4,6,6,5,5,7,7,2,2,0,0,3,3,6,6,1,1,6,6,3,3,0,0,0,0,4,4,2,2,1,1,1,1,4,4,6,6,5,5,7,7,6,6,5,5,1,1,5,5,1,1,0,0,0,0,5,5,3,3,6,6,7,7,7,7,2,2,1,1,2,2,0,0,4,4,6,6,5,5,5,5,5,5,6,6,2,2,2,2,0,0,2,2,3,3,0,0,4,4,3,3,4,4,6,6,4,4,2,2,4,4,3,3,5,5,6,6,1,1,0,0,6,6,0,0,2,2,1,1,0,0,2,2,1,1,5,5,4,4,3,3,2,2,0,0,0,0,6,6,6,6,0,0,1,1,4,4,6,6,5,5,5,5,1,1,4,4,5,5,4,4,6,6,0,0,2,2,0,0,1,1,4,4,7,7,3,3,2,2,0,0,1,1,3,3,3,3,1,1,5,5,5,5,3,3,4,4,2,2,3,3,1,1,5,5,3,3,1,1,3,3,5,5,3,3,1,1,2,2,2,2,6,6,4,4,5,5,6,6,3,3,6,6,4,4,0,0,1,1,5,5,4,4,3,3,4,4,4,4,6,6,7,7,4,4,6,6,3,3,5,5,3,3,0,0,1,1,6,6,4,4,7,7,3,3,1,1,7,7,1,1,2,2,0,0,3,3,0,0,4,4,7,7,3,3,3,3,4,4,0,0,2,2,0,0,5,5,7,7,3,3,5,5,6,6,4,4,5,5,6,6,4,4,4,4,6,6,1,1,0,0,6,6,0,0,3,3,0,0,2,2,2,2,7,7,2,2,0,0,0,0,1,1,0,0,6,6,4,4,0,0,6,6,4,4,1,1,1,1,3,3,3,3,7,7,6,6,4,4,3,3,5,5,3,3,0,0,7,7,6,6,5,5,6,6,2,2,3,3,1,1,6,6,5,5,1,1,1,1,2,2,5,5,2,2,0,0,5,5,7,7,2,2,4,4,4,4,5,5,4,4,2,2,5,5,7,7,6,6,1,1,0,0,3,3,6,6,4,4,5,5,1,1,6,6,0,0,2,2,6,6,0,0,3,3,5,5,2,2,2,2,0,0,0,0,4,4,0,0,1,1,3,3,7,7,7,7,0,0,1,1,2,2,1,1,7,7,0,0,0,0,5,5,3,3,6,6,0,0,7,7,6,6,2,2,3,3,1,1,0,0,4,4,0,0,7,7,3,3,5,5,3,3,2,2,4,4,4,4,0,0,7,7,5,5,1,1,2,2,3,3,6,6,1,1,0,0,1,1,1,1,7,7,2,2,1,1,7,7,4,4,7,7,4,4,3,3,6,6,2,2,1,1,3,3,0,0,2,2,5,5,1,1,1,1,6,6,7,7,6,6,5,5,0,0,0,0,1,1,3,3,3,3,5,5,7,7,3,3,6,6,6,6,2,2,1,1,5,5,4,4,6,6,6,6,5,5,5,5,0,0,0,0,4,4,0,0,6,6,4,4,0,0,2,2,6,6,0,0,6,6,2,2,4,4,2,2,4,4,6,6,1,1,2,2,3,3,6,6,2,2,7,7,0,0,5,5,6,6,0,0,5,5,1,1,3,3,4,4,7,7,3,3,5,5,6,6,7,7,4,4,2,2,6,6,6,6,5,5,3,3,6,6,5,5,2,2,2,2,0,0,1,1,1,1,1,1,5,5,7,7,1,1,3,3,4,4,6,6,3,3,2,2,6,6,4,4,7,7,5,5,4,4,0,0,5,5,0,0,1,1,4,4,4,4,5,5,6,6,4,4,7,7,0,0,4,4,3,3,3,3,4,4,0,0,4,4,3,3,7,7,0,0,3,3,1,1,3,3,7,7,6,6,7,7,6,6,3,3,3,3,5,5,6,6,0,0,1,1,2,2,0,0,5,5,1,1,4,4,2,2,2,2,3,3,2,2,6,6,7,7,7,7,4,4,5,5,4,4,6,6,3,3,4,4,5,5,2,2,1,1,6,6,4,4,0,0,1,1,0,0,3,3,1,1,2,2,2,2,7,7,5,5,2,2,5,5,5,5,4,4,7,7,0,0,7,7,2,2,7,7,4,4,1,1,1,1,4,4,1,1,7,7,0,0,1,1,0,0,5,5,1,1,5,5,5,5,4,4,6,6,0,0,2,2,3,3,1,1,4,4,4,4,4,4,1,1,0,0,6,6,0,0,2,2,0,0,4,4,6,6,2,2,1,1,4,4,6,6,7,7,7,7,5,5,3,3,7,7,4,4,4,4,1,1,1,1,2,2,2,2,5,5,4,4,3,3,1,1,4,4,1,1,2,2,2,2,2,2,6,6,2,2,5,5,2,2,4,4,7,7,1,1,0,0,2,2,5,5,5,5,7,7,1,1,3,3,1,1,0,0,7,7,0,0,1,1,6,6,4,4,6,6,3,3,0,0,5,5,5,5,4,4,0,0,1,1,7,7,0,0,0,0,0,0,2,2,0,0,0,0,2,2,0,0,6,6,5,5,2,2,1,1,4,4,4,4,3,3,7,7,2,2,7,7,3,3,5,5,2,2,2,2,1,1,0,0,2,2,4,4,6,6,0,0,3,3,1,1,5,5,6,6,6,6,3,3,2,2,2,2,6,6,6,6,2,2,7,7,1,1,3,3,0,0,2,2,6,6,5,5,5,5,6,6,5,5,3,3,2,2,1,1,2,2,3,3,5,5,3,3,2,2,2,2,1,1,5,5,1,1,2,2,2,2,1,1,4,4,0,0,7,7,0,0,7,7,3,3,7,7,0,0,2,2,4,4,4,4,6,6,3,3,4,4,5,5,7,7,7,7,5,5,4,4,2,2,7,7,6,6,5,5,2,2,5,5,3,3,1,1,5,5,0,0,5,5,1,1,2,2,5,5,0,0,2,2,7,7,2,2,1,1,1,1,7,7,1,1,2,2,4,4,4,4,6,6,6,6,0,0,2,2,6,6,1,1,0,0,7,7,1,1,2,2,6,6,7,7,7,7,2,2,0,0,4,4,7,7,0,0,6,6,7,7,5,5,0,0,5,5,0,0,1,1,0,0,6,6,7,7,1,1,5,5,3,3,6,6,2,2,3,3,1,1,6,6,0,0,0,0,1,1,2,2,4,4,4,4,7,7,1,1,6,6,0,0,4,4,2,2,1,1,2,2,0,0,0,0,1,1,2,2,4,4,1,1,1,1,6,6,2,2,0,0,6,6,0,0,0,0,4,4,2,2,0,0,4,4,1,1,5,5,2,2,6,6,4,4,0,0,5,5,1,1,1,1,2,2,2,2,4,4,0,0,3,3,0,0,0,0,0,0,7,7,2,2,1,1,1,1,1,1,2,2,7,7,1,1,2,2,7,7,4,4,3,3,7,7,5,5,1,1,6,6,5,5,5,5,5,5,4,4,2,2,4,4,3,3,6,6,1,1,0,0,5,5,5,5,4,4,1,1,4,4,4,4,6,6,5,5,2,2,5,5,5,5,3,3,3,3,3,3,2,2,5,5,4,4,3,3,6,6,2,2,1,1,1,1,5,5,2,2,2,2,2,2,3,3,4,4,4,4,4,4,0,0,2,2,1,1,4,4,1,1,4,4,4,4,3,3,3,3,0,0,2,2,5,5,2,2,5,5,5,5,4,4,6,6,2,2,3,3,5,5,4,4,6,6,2,2,6,6,1,1,0,0,7,7,2,2,1,1,2,2,3,3,3,3,3,3,5,5,4,4,3,3,3,3,2,2,1,1,6,6,2,2,3,3,0,0,0,0,4,4,2,2,4,4,5,5,6,6,5,5,6,6,0,0,7,7,5,5,0,0,2,2,5,5,0,0,0,0,1,1,7,7,7,7,1,1,4,4,6,6,4,4,1,1,4,4,7,7,7,7,4,4,0,0,3,3,0,0,0,0,6,6,2,2,5,5,0,0,3,3,0,0,7,7,6,6,1,1,0,0,5,5,4,4,4,4,5,5,2,2,4,4,7,7,3,3,7,7,0,0,6,6,1,1,1,1,1,1,2,2,1,1,6,6,0,0,0,0,1,1,5,5,3,3,0,0,5,5,6,6,6,6,5,5,1,1,0,0,5,5,7,7,5,5,3,3,3,3,2,2,2,2,6,6,0,0,6,6,7,7,7,7,7,7,2,2,5,5,2,2,4,4,0,0,3,3,0,0,5,5,6,6,6,6,6,6,5,5,4,4,2,2,3,3,6,6,3,3,6,6,0,0,7,7,6,6,0,0,6,6,0,0,1,1,3,3,5,5,2,2,0,0,5,5,1,1,1,1,6,6,6,6,1,1,6,6,7,7,0,0,7,7,0,0,0,0,2,2,0,0,5,5,3,3,3,3,7,7,3,3,4,4,4,4,7,7,1,1,2,2,1,1,2,2,2,2,0,0,2,2,2,2,6,6,3,3,7,7,7,7,6,6,1,1,2,2,4,4,6,6,2,2,3,3,4,4,0,0,4,4,0,0,1,1,1,1,3,3,0,0,0,0,3,3,1,1,0,0,3,3,0,0,1,1,4,4,2,2,7,7,4,4,1,1,6,6,4,4,5,5,2,2,2,2,0,0,5,5,5,5,7,7,5,5,1,1,6,6,1,1,0,0,3,3,3,3,5,5,7,7,6,6,0,0,2,2,1,1,1,1,4,4,2,2,1,1,3,3,6,6,2,2,6,6,3,3,0,0,2,2,6,6,3,3,6,6,6,6,3,3,7,7,4,4,2,2,5,5,7,7,1,1,1,1,6,6,0,0,5,5,5,5,5,5,7,7,4,4,5,5,0,0,4,4,7,7,4,4,5,5,7,7,3,3,3,3,1,1,0,0,0,0,7,7,1,1,4,4,3,3,6,6,5,5,3,3,0,0,1,1,3,3,6,6,3,3,5,5,7,7,4,4,4,4,1,1,6,6,3,3,3,3,6,6,7,7,2,2,7,7,6,6,6,6,5,5,5,5,4,4,6,6,3,3,3,3,5,5,3,3,3,3,2,2,6,6,6,6,3,3,4,4,6,6,1,1,7,7,5,5,3,3,5,5,2,2,7,7,0,0,5,5,0,0,4,4,0,0,6,6,6,6,1,1,1,1,2,2,1,1,2,2,7,7,5,5,1,1,4,4,3,3,0,0,5,5,0,0,4,4,2,2,7,7,1,1,5,5,1,1,1,1,6,6,7,7,3,3,3,3,3,3,6,6,5,5,0,0,3,3,6,6,7,7,3,3,4,4,2,2,0,0,1,1,0,0,3,3,2,2,0,0,1,1,0,0,5,5,1,1,5,5,5,5,1,1,6,6,7,7,0,0,6,6,1,1,1,1,1,1,7,7,4,4,6,6,5,5,1,1,0,0,2,2,5,5,4,4,4,4,3,3,3,3,2,2,5,5,2,2,6,6,0,0,1,1,1,1,2,2,6,6,2,2,4,4,0,0,1,1,7,7,2,2,0,0,3,3,4,4,4,4,7,7,2,2,6,6,7,7,1,1,0,0,5,5,0,0,0,0,3,3,2,2,2,2,7,7,3,3,6,6,2,2,2,2,7,7,2,2,4,4,7,7,1,1,6,6,6,6,7,7,2,2,6,6,4,4,7,7,4,4,4,4,5,5,1,1,0,0,4,4,4,4,7,7,7,7,7,7,1,1,3,3,7,7,2,2,7,7,4,4,4,4,1,1,4,4,6,6,2,2,0,0,0,0,4,4,7,7,5,5,4,4,4,4,1,1,0,0,0,0,2,2,4,4,7,7,3,3,6,6,2,2,7,7,3,3,3,3,7,7,3,3,0,0,1,1,2,2,0,0,5,5,6,6,7,7,3,3,4,4,7,7,2,2,3,3,1,1,1,1,6,6,5,5,2,2,6,6,2,2,5,5,6,6,6,6,6,6,6,6,2,2,6,6,1,1,1,1,5,5,7,7,0,0,5,5,7,7,4,4,7,7,1,1,1,1,1,1,6,6,3,3,0,0,0,0,2,2,0,0,3,3,0,0,6,6,0,0,6,6,5,5,1,1,5,5,0,0,2,2,1,1,0,0,2,2,0,0,0,0,0,0,4,4,1,1,3,3,5,5,3,3,3,3,2,2,4,4,5,5,3,3,1,1,1,1,7,7,0,0,1,1,6,6,5,5,4,4,6,6,1,1,0,0,1,1,6,6,5,5,0,0,6,6,3,3,5,5,4,4,5,5,2,2,5,5,4,4,1,1,6,6,2,2,7,7,0,0,1,1,3,3,6,6,0,0,6,6,5,5,2,2,6,6,0,0,7,7,3,3,2,2,3,3,1,1,1,1,7,7,5,5,1,1,3,3,1,1,3,3,4,4,4,4,5,5,2,2,3,3,2,2,3,3,5,5,3,3,2,2,5,5,1,1,4,4,6,6,7,7,3,3,3,3,3,3,2,2,3,3,1,1,5,5,6,6,6,6,6,6,6,6,5,5,6,6,4,4,5,5,4,4,0,0,5,5,2,2,7,7,1,1,1,1,5,5,7,7,5,5,4,4,3,3,0,0,0,0,4,4,4,4,0,0,6,6,0,0,3,3,7,7,0,0,7,7,1,1,1,1,6,6,3,3,1,1,2,2,1,1,2,2,4,4,0,0,0,0,5,5,6,6,1,1,4,4,6,6,3,3,5,5,2,2,3,3,7,7,5,5,0,0,7,7,5,5,3,3,1,1,2,2,7,7,7,7,0,0,3,3,5,5,7,7,0,0,2,2,1,1,7,7,0,0,1,1,7,7,1,1,1,1,1,1,2,2,6,6,3,3,3,3,3,3,1,1,7,7,0,0,5,5,6,6,7,7,0,0,4,4,5,5,0,0,7,7,2,2,3,3,0,0,5,5,5,5,4,4,6,6,4,4,3,3,6,6,7,7,3,3,0,0,7,7,1,1,2,2,6,6,1,1,4,4,3,3,1,1,7,7,6,6,3,3,0,0,5,5,5,5,2,2,6,6,3,3,1,1,0,0,1,1,0,0,0,0,2,2,2,2,6,6,6,6,5,5,6,6,0,0,3,3,1,1,2,2,7,7,6,6,6,6,6,6,0,0,4,4,6,6,3,3,6,6,7,7,5,5,0,0,5,5,3,3,1,1,3,3,1,1,6,6,2,2,2,2,2,2,7,7,7,7,3,3,4,4,5,5,5,5,6,6,5,5,7,7,4,4,6,6,4,4,3,3,2,2,3,3,2,2,3,3,2,2,6,6,2,2,1,1,1,1,1,1,6,6,1,1,1,1,4,4,4,4,4,4,7,7,1,1,0,0,0,0,1,1,2,2,7,7,5,5,7,7,4,4,0,0,1,1,6,6,2,2,0,0,6,6,0,0,5,5,7,7,2,2,1,1,4,4,2,2,0,0,5,5,4,4,2,2,6,6,0,0,1,1,0,0,5,5,0,0,4,4,5,5,7,7,4,4,5,5,7,7,2,2,6,6,1,1,5,5,5,5,0,0,0,0,7,7,7,7,2,2,1,1,6,6,6,6,4,4,6,6,3,3,2,2,2,2,3,3,5,5,4,4,7,7,0,0,0,0,6,6,2,2,7,7,7,7,1,1,5,5,6,6,1,1,6,6,6,6,2,2,2,2,3,3,7,7,5,5,0,0,2,2,4,4,2,2,0,0,4,4,3,3,1,1,6,6,5,5,4,4,6,6,4,4,6,6,1,1,0,0,2,2,2,2,1,1,5,5,1,1,3,3,3,3,2,2,6,6,2,2,6,6,0,0,2,2,2,2,3,3,7,7,0,0,0,0,2,2,7,7,6,6,4,4,5,5,5,5,4,4,4,4,4,4,2,2,0,0,2,2,6,6,1,1,4,4,6,6,1,1,6,6,0,0,4,4,5,5,4,4,5,5,5,5,5,5,4,4,0,0,2,2,4,4,1,1,6,6,2,2,2,2,4,4,0,0,2,2,7,7,6,6,3,3,0,0,0,0,7,7,4,4,0,0,1,1,1,1,5,5,5,5,3,3,2,2,4,4,2,2,6,6,6,6,4,4,6,6,5,5,2,2,4,4,4,4,1,1,3,3,7,7,1,1,7,7,1,1,4,4,2,2,1,1,3,3,4,4,7,7,1,1,0,0,2,2,6,6,2,2,3,3,5,5,6,6,5,5,3,3,6,6,4,4,2,2,4,4,5,5,6,6,5,5,0,0,5,5,1,1,0,0,2,2,4,4,7,7,3,3,4,4,1,1,6,6,0,0,1,1,5,5,5,5,6,6,4,4,0,0,4,4,0,0,2,2,2,2,2,2,5,5,5,5,5,5,5,5,2,2,1,1,6,6,2,2,5,5,1,1,3,3,2,2,2,2,3,3,1,1,1,1,7,7,4,4,4,4,4,4,6,6,3,3,2,2,5,5,1,1,2,2,0,0,0,0,0,0,2,2,1,1,3,3,2,2,4,4,6,6,5,5,1,1,6,6,7,7,5,5,4,4,0,0,4,4,1,1,4,4,4,4,5,5,7,7,4,4,6,6,4,4,1,1,3,3,7,7,4,4,0,0,1,1,5,5,4,4,3,3,7,7,1,1,5,5,5,5,2,2,7,7,2,2,7,7,0,0,5,5,4,4,6,6,2,2,2,2,2,2,0,0,1,1,0,0,2,2,6,6,2,2,6,6,0,0,3,3,1,1,0,0,6,6,6,6,0,0,3,3,1,1,2,2,3,3,7,7,1,1,4,4,2,2,5,5,1,1,5,5,0,0,7,7,1,1,0,0,0,0,2,2,6,6,6,6,6,6,7,7,0,0,0,0,1,1,3,3,6,6,0,0,7,7,5,5,3,3,4,4,0,0,7,7,4,4,5,5,5,5,0,0,5,5,1,1,2,2,4,4,1,1,4,4,4,4,4,4,0,0,5,5,3,3,2,2,1,1,1,1,5,5,6,6,0,0,0,0,0,0,3,3,2,2,4,4,2,2,1,1,6,6,1,1,1,1,0,0,7,7,4,4,3,3,0,0,2,2,6,6,0,0,3,3,2,2,0,0,1,1,4,4,6,6,4,4,3,3,2,2,2,2,2,2,5,5,4,4,0,0,7,7,6,6,2,2,6,6,4,4,3,3,6,6,4,4,4,4,3,3,0,0,2,2,1,1,6,6,0,0,7,7,0,0,7,7,0,0,2,2,0,0,4,4,1,1,0,0,1,1,5,5,0,0,6,6,0,0,7,7,6,6,5,5,3,3,3,3,5,5,1,1,1,1,2,2,5,5,5,5,6,6,4,4,3,3,6,6,1,1,1,1,4,4,2,2,0,0,1,1,7,7,7,7,5,5,3,3,0,0,4,4,0,0,0,0,1,1,1,1,3,3,2,2,0,0,5,5,0,0,3,3,7,7,4,4,5,5,6,6,5,5,0,0,1,1,4,4,4,4,4,4,2,2,7,7,1,1,2,2,0,0,7,7,2,2,1,1,2,2,7,7,1,1,4,4,2,2,6,6,7,7,7,7,2,2,0,0,6,6,3,3,0,0,2,2,6,6,5,5,2,2,1,1,6,6,5,5,7,7,5,5,2,2,2,2,7,7,7,7,6,6,1,1,5,5,4,4,3,3,5,5,2,2,6,6,7,7,2,2,3,3,0,0,4,4,0,0,5,5,6,6,7,7,0,0,6,6,0,0,7,7,1,1,2,2,0,0,2,2,2,2,5,5,3,3,6,6,0,0,7,7,5,5,2,2,1,1,7,7,3,3,0,0,5,5,6,6,4,4,3,3,1,1,3,3,6,6,1,1,4,4,0,0,4,4,3,3,7,7,3,3,1,1,6,6,2,2,0,0,5,5,0,0,6,6,2,2,4,4,7,7,7,7,1,1,1,1,3,3,4,4,7,7,3,3,0,0,2,2,4,4,6,6,6,6,6,6,5,5,2,2,3,3,1,1,1,1,4,4,1,1,4,4,5,5,6,6,7,7,4,4,5,5,0,0,0,0,7,7,2,2,6,6,1,1,4,4,6,6,1,1,3,3,5,5,0,0,7,7,1,1,4,4,3,3,6,6,2,2,1,1,0,0,0,0,5,5,5,5,3,3,4,4,7,7,7,7,7,7,6,6,3,3,0,0,7,7,3,3,2,2,3,3,2,2,1,1,1,1,2,2,4,4,6,6,1,1,0,0,2,2,2,2,5,5,1,1,2,2,2,2,6,6,6,6,6,6,1,1,1,1,1,1,2,2,6,6,5,5,1,1,3,3,0,0,4,4,1,1,3,3,5,5,0,0,6,6,6,6,2,2,0,0,3,3,4,4,1,1,5,5,1,1,1,1,5,5,1,1,1,1,1,1,4,4,1,1,7,7,1,1,6,6,7,7,0,0,0,0,5,5,4,4,1,1,4,4,1,1,4,4,6,6,5,5,5,5,3,3,0,0,2,2,0,0,1,1,4,4,1,1,4,4,0,0,6,6,4,4,4,4,1,1,5,5,0,0,0,0,3,3,5,5,4,4,5,5,2,2,5,5,3,3,2,2,2,2,3,3,0,0,0,0,1,1,5,5,5,5,5,5,0,0,4,4,0,0,5,5,7,7,2,2,7,7,4,4,6,6,4,4,3,3,6,6,5,5,1,1,4,4,4,4,0,0,3,3,2,2,2,2,7,7,2,2,3,3,6,6,2,2,5,5,5,5,1,1,0,0,7,7,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,4,4,5,5,0,0,4,4,6,6,4,4,2,2,1,1,2,2,1,1,5,5,0,0,1,1,6,6,1,1,4,4,3,3,3,3,7,7,1,1,3,3,4,4,7,7,2,2,4,4,3,3,1,1,5,5,0,0,1,1,1,1,5,5,1,1,1,1,1,1,4,4,5,5,5,5,7,7,7,7,3,3,4,4,0,0,4,4,0,0,7,7,2,2,5,5,5,5,0,0,6,6,7,7,7,7,5,5,2,2,7,7,3,3,1,1,3,3,4,4,4,4,3,3,0,0,6,6,1,1,4,4,7,7,5,5,7,7,4,4,1,1,2,2,6,6,0,0,4,4,1,1,4,4,3,3,3,3,7,7,6,6,1,1,7,7,7,7,3,3,0,0,1,1,7,7,4,4,0,0,0,0,4,4,0,0,0,0,6,6,0,0,0,0,3,3,6,6,1,1,1,1,7,7,2,2,7,7,3,3,0,0,2,2,5,5,2,2,4,4,5,5,1,1,6,6,7,7,2,2,2,2,7,7,4,4,7,7,1,1,0,0,4,4,4,4,3,3,1,1,3,3,4,4,0,0,1,1,6,6,3,3,5,5,3,3,5,5,6,6,7,7,2,2,2,2,3,3,2,2,6,6,5,5,7,7,0,0,7,7,7,7,4,4,6,6,7,7,2,2,4,4,6,6,0,0,0,0,3,3,0,0,4,4,7,7,1,1,4,4,1,1,2,2,4,4,0,0,7,7,0,0,5,5,5,5,2,2,1,1,1,1,2,2,7,7,7,7,6,6,5,5,1,1,1,1,0,0,5,5,6,6,4,4,2,2,3,3,2,2,7,7,4,4,6,6,7,7,5,5,5,5,6,6,7,7,6,6,2,2,4,4,3,3,2,2,6,6,3,3,3,3,5,5,0,0,2,2,5,5,0,0,5,5,3,3,4,4,3,3,5,5,7,7,6,6,6,6,3,3,5,5,4,4,3,3,1,1,0,0,6,6,3,3,1,1,5,5,2,2,3,3,2,2,0,0,7,7,5,5,3,3,0,0,6,6,1,1,2,2,7,7,4,4,0,0,0,0,3,3,6,6,3,3,5,5,5,5,4,4,1,1,3,3,3,3,5,5,1,1,1,1,1,1,3,3,6,6,7,7,7,7,1,1,7,7,5,5,1,1,4,4,7,7,3,3,1,1,5,5,7,7,4,4,5,5,0,0,4,4,0,0,7,7,5,5,1,1,6,6,3,3,7,7,6,6,7,7,4,4,0,0,3,3,6,6,6,6,4,4,7,7,0,0,7,7,3,3,0,0,3,3,4,4,2,2,0,0,3,3,7,7,3,3,7,7,0,0,4,4,5,5,4,4,7,7,2,2,4,4,2,2,4,4,1,1,1,1,2,2,5,5,2,2,3,3,6,6,5,5,1,1,4,4,2,2,3,3,4,4,7,7,3,3,1,1,3,3,0,0,0,0,2,2,1,1,2,2,0,0,6,6,6,6,2,2,7,7,5,5,6,6,0,0,7,7,2,2,7,7,0,0,2,2,0,0,1,1,7,7,0,0,2,2,1,1,6,6,6,6,3,3,3,3,2,2,1,1,6,6,4,4,4,4,2,2,2,2,3,3,6,6,1,1,1,1,7,7,2,2,3,3,7,7,4,4,5,5,4,4,6,6,0,0,6,6,7,7,1,1,2,2,2,2,0,0,1,1,1,1,7,7,1,1,4,4,7,7,7,7,6,6,1,1,5,5,4,4,0,0,3,3,2,2,7,7,2,2,7,7,4,4,3,3,6,6,2,2,1,1,2,2,5,5,3,3,7,7,5,5,0,0,3,3,7,7,2,2,0,0,6,6,1,1,4,4,3,3,1,1,4,4,4,4,4,4,1,1,4,4,2,2,2,2,1,1,1,1,7,7,0,0,2,2,4,4,4,4,5,5,1,1,2,2,3,3,7,7,2,2,5,5,3,3,2,2,4,4,0,0,5,5,6,6,3,3,2,2,1,1,5,5,0,0,1,1,2,2,6,6,4,4,3,3,1,1,2,2,3,3,3,3,4,4,1,1,4,4,2,2,1,1,5,5,4,4,2,2,2,2,6,6,3,3,0,0,6,6,5,5,4,4,2,2,1,1,7,7,1,1,5,5,4,4,2,2,4,4,6,6,6,6,4,4,1,1,2,2,2,2,6,6,4,4,3,3,5,5,1,1,0,0,6,6,4,4,2,2,1,1,5,5,7,7,2,2,4,4,2,2,3,3,1,1,6,6,0,0,5,5,7,7,7,7,4,4,0,0,1,1,1,1,3,3,3,3,2,2,0,0,7,7,5,5,6,6,6,6,7,7,3,3,3,3,4,4,3,3,6,6,2,2,5,5,1,1,1,1,1,1,7,7,5,5,0,0,0,0,2,2,1,1,4,4,2,2,3,3,3,3,2,2,6,6,1,1,3,3,7,7,0,0,3,3,1,1,7,7,5,5,4,4,1,1,7,7,1,1,0,0,7,7,5,5,3,3,1,1,0,0,4,4,5,5,1,1,3,3,0,0,0,0,2,2,7,7,1,1,2,2,7,7,3,3,1,1,5,5,5,5,5,5,0,0,5,5,5,5,2,2,2,2,4,4,6,6,5,5,2,2,1,1,3,3,7,7,3,3,2,2,3,3,2,2,7,7,0,0,5,5,5,5,5,5,5,5,3,3,7,7,0,0,6,6,7,7,7,7,3,3,6,6,3,3,6,6,6,6,7,7,1,1,4,4,0,0,2,2,5,5,5,5,4,4,2,2,3,3,7,7,2,2,0,0,7,7,2,2,1,1,0,0,3,3,5,5,1,1,5,5,5,5,1,1,4,4,5,5,0,0,3,3,1,1,2,2,2,2,5,5,0,0,0,0,0,0,5,5,0,0,1,1,0,0,1,1,6,6,2,2,6,6,6,6,4,4,2,2,6,6,7,7,0,0,1,1,3,3,6,6,0,0,3,3,3,3,2,2,1,1,7,7,4,4,3,3,3,3,2,2,6,6,5,5,0,0,7,7,7,7,3,3,4,4,7,7,4,4,0,0,1,1,3,3,3,3,7,7,3,3,2,2,7,7,2,2,6,6,3,3,0,0,1,1,4,4,5,5,5,5,1,1,0,0,1,1,7,7,0,0,1,1,3,3,5,5,6,6,1,1,6,6,2,2,0,0,6,6,2,2,1,1,1,1,2,2,4,4,2,2,4,4,4,4,0,0,4,4,1,1,2,2,7,7,2,2,0,0,5,5,4,4,4,4,1,1,3,3,5,5,6,6,0,0,7,7,7,7,4,4,6,6,5,5,7,7,0,0,1,1,6,6,0,0,6,6,7,7,7,7,5,5,1,1,2,2,5,5,1,1,0,0,4,4,7,7,4,4,3,3,7,7,6,6,7,7,4,4,2,2,6,6,4,4,1,1,0,0,4,4,3,3,2,2,1,1,7,7,0,0,6,6,5,5,0,0,2,2,3,3,5,5,3,3,0,0,6,6,7,7,2,2,4,4,2,2,2,2,6,6,6,6,0,0,7,7,2,2,4,4,3,3,6,6,1,1,0,0,3,3,1,1,6,6,1,1,0,0,1,1,1,1,4,4,7,7,0,0,4,4,4,4,0,0,3,3,6,6,0,0,0,0,5,5,6,6,0,0,4,4,1,1,6,6,5,5,5,5,3,3,3,3,0,0,2,2,4,4,0,0,5,5,0,0,3,3,5,5,5,5,0,0,2,2,4,4,7,7,1,1,7,7,5,5,0,0,5,5,7,7,3,3,1,1,4,4,4,4,4,4,1,1,2,2,2,2,3,3,3,3,6,6,4,4,5,5,1,1,2,2,7,7,1,1,5,5,4,4,7,7,4,4,6,6,7,7,1,1,4,4,7,7,7,7,7,7,7,7,5,5,1,1,5,5,6,6,7,7,3,3,0,0,5,5,6,6,0,0,2,2,3,3,7,7,3,3,5,5,1,1,1,1,2,2,7,7,5,5,4,4,4,4,1,1,4,4,2,2,2,2,4,4,1,1,4,4,0,0,2,2,4,4,3,3,7,7,4,4,5,5,1,1,5,5,3,3,7,7,7,7,6,6,3,3,1,1,6,6,0,0,6,6,4,4,2,2,1,1,1,1,7,7,3,3,1,1,3,3,2,2,3,3,5,5,3,3,0,0,3,3,4,4,1,1,0,0,1,1,7,7,0,0,4,4,3,3,5,5,6,6,7,7,6,6,2,2,6,6,5,5,7,7,5,5,0,0,5,5,0,0,0,0,1,1,0,0,0,0,1,1,3,3,1,1,6,6,3,3,2,2,0,0,7,7,1,1,1,1,6,6,3,3,5,5,6,6,0,0,7,7,3,3,3,3,7,7,0,0,3,3,0,0,5,5,0,0,4,4,7,7,1,1,0,0,5,5,4,4,5,5,1,1,1,1,6,6,2,2,3,3,7,7,4,4,2,2,3,3,1,1,7,7,3,3,0,0,1,1,5,5,1,1,5,5,0,0,2,2,5,5,4,4,0,0,7,7,1,1,0,0,4,4,4,4,4,4,5,5,4,4,7,7,6,6,6,6,4,4,7,7,7,7,3,3,3,3,4,4,0,0,0,0,7,7,7,7,1,1,1,1,0,0,0,0,2,2,0,0,5,5,3,3,4,4,4,4,2,2,2,2,1,1,1,1,0,0,1,1,4,4,3,3,1,1,3,3,0,0,6,6,1,1,5,5,3,3,0,0,6,6,0,0,7,7,6,6,2,2,7,7,1,1,5,5,6,6,0,0,1,1,1,1,4,4,0,0,0,0,6,6,2,2,5,5,0,0,3,3,7,7,4,4,0,0,1,1,0,0,2,2,1,1,1,1,5,5,3,3,7,7,1,1,7,7,6,6,2,2,0,0,7,7,0,0,1,1,1,1,5,5,2,2,7,7,2,2,7,7,5,5,5,5,5,5,2,2,0,0,1,1,5,5,2,2,5,5,1,1,1,1,2,2,6,6,0,0,0,0,1,1,0,0,7,7,3,3,7,7,1,1,5,5,0,0,1,1,2,2,0,0,3,3,6,6,3,3,5,5,1,1,6,6,0,0,1,1,1,1,0,0,2,2,4,4,0,0,0,0,4,4,3,3,5,5,0,0,2,2,1,1,1,1,2,2,1,1,7,7,5,5,2,2,0,0,2,2,7,7,4,4,7,7,3,3,3,3,1,1,3,3,1,1,6,6,0,0,2,2,1,1,1,1,7,7,2,2,4,4,3,3,2,2,2,2,4,4,7,7,6,6,2,2,1,1,5,5,4,4,5,5,7,7,2,2,3,3,7,7,1,1,6,6,7,7,6,6,0,0,4,4,4,4,2,2,4,4,7,7,1,1,0,0,7,7,6,6,5,5,6,6,7,7,1,1,2,2,6,6,6,6,0,0,1,1,6,6,1,1,0,0,5,5,7,7,6,6,0,0,1,1,2,2,1,1,7,7,2,2,7,7,3,3,2,2,6,6,1,1,1,1,1,1,4,4,6,6,6,6,5,5,1,1,1,1,5,5,3,3,0,0,1,1,3,3,2,2,7,7,0,0,2,2,0,0,4,4,0,0,2,2,6,6,0,0,1,1,2,2,2,2,4,4,0,0,0,0,2,2,0,0,0,0,5,5,4,4,0,0,5,5,6,6,7,7,4,4,4,4,3,3,5,5,2,2,4,4,1,1,7,7,0,0,4,4,1,1,6,6,4,4,2,2,1,1,0,0,2,2,1,1,2,2,2,2,5,5,3,3,1,1,7,7,7,7,5,5,3,3,1,1,3,3,4,4,1,1,0,0,2,2,2,2,1,1,0,0,3,3,2,2,2,2,5,5,0,0,2,2,2,2,6,6,5,5,0,0,0,0,1,1,4,4,6,6,6,6,2,2,0,0,3,3,0,0,2,2,7,7,5,5,4,4,7,7,5,5,1,1,7,7,0,0,2,2,4,4,3,3,3,3,6,6,5,5,5,5,5,5,2,2,5,5,3,3,5,5,0,0,3,3,7,7,3,3,4,4,6,6,7,7,1,1,0,0,5,5,0,0,3,3,7,7,3,3,0,0,3,3,7,7,7,7,5,5,6,6,4,4,2,2,0,0,0,0,1,1,6,6,1,1,4,4,3,3,3,3,3,3,7,7,2,2,4,4,1,1,6,6,4,4,6,6,7,7,5,5,4,4,4,4,7,7,2,2,4,4,5,5,1,1,1,1,7,7,5,5,6,6,0,0,1,1,1,1,6,6,3,3,0,0,0,0,7,7,5,5,3,3,5,5,5,5,3,3,3,3,0,0,2,2,7,7,6,6,1,1,3,3,4,4,2,2,3,3,2,2,2,2,4,4,5,5,6,6,5,5,0,0,0,0,4,4,6,6,3,3,0,0,7,7,7,7,1,1,1,1,5,5,4,4,0,0,6,6,3,3,1,1,3,3,3,3,6,6,2,2,5,5,3,3,1,1,7,7,7,7,1,1,3,3,6,6,7,7,2,2,4,4,0,0,7,7,4,4,0,0,4,4,2,2,6,6,2,2,5,5,6,6,1,1,6,6,2,2,2,2,0,0,1,1,0,0,2,2,0,0,5,5,4,4,0,0,0,0,7,7,4,4,2,2,0,0,1,1,0,0,2,2,3,3,6,6,5,5,1,1,3,3,3,3,1,1,6,6,5,5,0,0,6,6,3,3,7,7,0,0,1,1,7,7,2,2,5,5,3,3,1,1,5,5,0,0,7,7,5,5,4,4,2,2,3,3,0,0,2,2,4,4,4,4,4,4,4,4,2,2,6,6,0,0,7,7,4,4,4,4,7,7,5,5,1,1,2,2,7,7,4,4,1,1,4,4,6,6,1,1,0,0,6,6,0,0,7,7,2,2,1,1,2,2,1,1,0,0,4,4,5,5,2,2,3,3,5,5,2,2,4,4,3,3,1,1,2,2,2,2,5,5,0,0,2,2,0,0,4,4,0,0,1,1,7,7,1,1,5,5,0,0,0,0,6,6,3,3,1,1,5,5,4,4,0,0,4,4,3,3,3,3,0,0,4,4,0,0,1,1,7,7,7,7,0,0,0,0,6,6,0,0,1,1,0,0,7,7,0,0,6,6,6,6,4,4,5,5,1,1,4,4,1,1,7,7,0,0,6,6,3,3,0,0,3,3,2,2,5,5,0,0,5,5,7,7,3,3,1,1,6,6,3,3,1,1,3,3,5,5,5,5,6,6,6,6,3,3,0,0,3,3,1,1,4,4,5,5,5,5,0,0,2,2,5,5,7,7,0,0,3,3,0,0,2,2,5,5,5,5,7,7,3,3,4,4,3,3,7,7,5,5,5,5,3,3,1,1,7,7,4,4,3,3,4,4,3,3,2,2,4,4,6,6,2,2,2,2,0,0,0,0,5,5,2,2,2,2,2,2,6,6,0,0,4,4,3,3,6,6,2,2,5,5,6,6,6,6,4,4,1,1,7,7,0,0,7,7,6,6,4,4,3,3,0,0,4,4,3,3,3,3,5,5,5,5,6,6,4,4,1,1,3,3,2,2,4,4,3,3,7,7,2,2,4,4,1,1,6,6,2,2,2,2,6,6,7,7,6,6,1,1,4,4,7,7,6,6,6,6,4,4,2,2,4,4,2,2,6,6,2,2,7,7,6,6,0,0,0,0,7,7,6,6,6,6,3,3,5,5,4,4,7,7,6,6,4,4,0,0,4,4,5,5,0,0,3,3,7,7,0,0,3,3,3,3,3,3,0,0,5,5,6,6,0,0,1,1,7,7,7,7,0,0,3,3,5,5,6,6,0,0,4,4,4,4,7,7,6,6,6,6,7,7,0,0,3,3,7,7,5,5,3,3,3,3,2,2,4,4,0,0,7,7,2,2,0,0,3,3,2,2,5,5,5,5,1,1,5,5,2,2,1,1,3,3,3,3,1,1,3,3,5,5,2,2,4,4,2,2,0,0,0,0,6,6,6,6,5,5,3,3,7,7,0,0,3,3,6,6,7,7,4,4,3,3,2,2,3,3,0,0,6,6,0,0,6,6,5,5,7,7,5,5,1,1,6,6,4,4,1,1,4,4,2,2,2,2,3,3,2,2,2,2,0,0,2,2,0,0,2,2,5,5,1,1,3,3,3,3,2,2,6,6,3,3,1,1,2,2,5,5,1,1,1,1,4,4,5,5,6,6,6,6,5,5,6,6,5,5,3,3,0,0,7,7,4,4,7,7,1,1,6,6,7,7,6,6,2,2,0,0,5,5,6,6,0,0,4,4,3,3,7,7,1,1,4,4,1,1,4,4,3,3,4,4,6,6,0,0,5,5,0,0,0,0,1,1,4,4,5,5,7,7,0,0,0,0,1,1,0,0,6,6,6,6,7,7,1,1,6,6,6,6,1,1,4,4,5,5,3,3,7,7,3,3,3,3,0,0,1,1,7,7,0,0,2,2,4,4,4,4,6,6,0,0,6,6,5,5,6,6,3,3,7,7,0,0,5,5,2,2,4,4,1,1,2,2,1,1,3,3,5,5,1,1,7,7,4,4,6,6,1,1,6,6,0,0,2,2,0,0,7,7,2,2,1,1,0,0,5,5,4,4,7,7,0,0,3,3,1,1,4,4,3,3,7,7,6,6,1,1,5,5,1,1,4,4,3,3,0,0,2,2,0,0,4,4,5,5,4,4,5,5,2,2,0,0,4,4,4,4,0,0,4,4,4,4,7,7,3,3,0,0,0,0,0,0,3,3,2,2,2,2,6,6,0,0,3,3,5,5,6,6,1,1,3,3,1,1,2,2,7,7,6,6,1,1,6,6,7,7,3,3,2,2,1,1,2,2,6,6,5,5,6,6,3,3,5,5,4,4,0,0,3,3,3,3,4,4,1,1,5,5,1,1,0,0,1,1,4,4,2,2,7,7,6,6,3,3,4,4,6,6,6,6,6,6,3,3,1,1,7,7,4,4,3,3,0,0,3,3,0,0,7,7,2,2,3,3,3,3,5,5,7,7,4,4,7,7,1,1,5,5,5,5,0,0,6,6,5,5,0,0,4,4,6,6,4,4,4,4,2,2,5,5,3,3,7,7,1,1,1,1,5,5,6,6,0,0,5,5,1,1,7,7,1,1,3,3,0,0,7,7,0,0,4,4,2,2,7,7,3,3,2,2,5,5,2,2,2,2,6,6,3,3,0,0,5,5,5,5,1,1,7,7,5,5,5,5,5,5,4,4,4,4,6,6,6,6,3,3,0,0,1,1,5,5,3,3,2,2,4,4,3,3,3,3,7,7,5,5,6,6,5,5,7,7,3,3,6,6,3,3,2,2,6,6,1,1,5,5,1,1,5,5,4,4,6,6,0,0,6,6,3,3,3,3,1,1,7,7,1,1,0,0,2,2,4,4,4,4,7,7,2,2,2,2,1,1,0,0,3,3,0,0,0,0,4,4,6,6,0,0,4,4,3,3,7,7,3,3,3,3,4,4,2,2,7,7,2,2,3,3,4,4,1,1,2,2,5,5,4,4,2,2,1,1,6,6,6,6,6,6,4,4,3,3,4,4,3,3,4,4,0,0,6,6,3,3,4,4,3,3,0,0,4,4,1,1,3,3,2,2,2,2,1,1,4,4,5,5,2,2,6,6,0,0,1,1,7,7,7,7,0,0,4,4,2,2,7,7,4,4,5,5,5,5,4,4,3,3,7,7,0,0,0,0,7,7,1,1,2,2,0,0,6,6,7,7,3,3,1,1,0,0,1,1,5,5,3,3,1,1,3,3,1,1,4,4,0,0,2,2,2,2,3,3,4,4,5,5,3,3,3,3,7,7,7,7,4,4,1,1,0,0,2,2,7,7,2,2,2,2,1,1,7,7,4,4,4,4,0,0,2,2,1,1,5,5,4,4,2,2,6,6,0,0,0,0,4,4,1,1,0,0,3,3,7,7,4,4,0,0,4,4,7,7,0,0,6,6,3,3,0,0,5,5,3,3,3,3,4,4,2,2,1,1,1,1,4,4,7,7,2,2,7,7,6,6,2,2,2,2,5,5,6,6,0,0,2,2,2,2,0,0,5,5,6,6,2,2,2,2,1,1,0,0,7,7,0,0,5,5,6,6,5,5,5,5,2,2,0,0,4,4,3,3,6,6,2,2,3,3,6,6,4,4,0,0,0,0,1,1,1,1,4,4,3,3,5,5,0,0,3,3,3,3,0,0,0,0,5,5,5,5,4,4,4,4,5,5,4,4,7,7,4,4,1,1,5,5,4,4,2,2,6,6,0,0,1,1,5,5,6,6,4,4,3,3,0,0,7,7,0,0,2,2,3,3,4,4,1,1,5,5,2,2,6,6,0,0,1,1,6,6,3,3,4,4,4,4,5,5,4,4,3,3,5,5,1,1,1,1,3,3,5,5,3,3,7,7,7,7,2,2,2,2,4,4,1,1,7,7,4,4,0,0,0,0,4,4,5,5,1,1,6,6,5,5,2,2,7,7,2,2,3,3,0,0,0,0,5,5,2,2,3,3,6,6,2,2,0,0,3,3,7,7,0,0,3,3,7,7,4,4,1,1,4,4,4,4,3,3,2,2,7,7,2,2,4,4,1,1,1,1,5,5,1,1,0,0,5,5,4,4,5,5,7,7,1,1,3,3,3,3,4,4,6,6,7,7,5,5,4,4,5,5,4,4,0,0,7,7,2,2,6,6,4,4,6,6,1,1,5,5,5,5,4,4,4,4,5,5,3,3,5,5,7,7,0,0,7,7,1,1,0,0,4,4,0,0,5,5,3,3,4,4,2,2,1,1,3,3,6,6,7,7,5,5,2,2,3,3,0,0,2,2,0,0,6,6,7,7,2,2,5,5,6,6,0,0,5,5,5,5,2,2,2,2,1,1,1,1,6,6,3,3,0,0,2,2,4,4,6,6,1,1,4,4,4,4,1,1,1,1,7,7,3,3,4,4,5,5,6,6,7,7,7,7,6,6,2,2,2,2,4,4,5,5,7,7,0,0,7,7,2,2,2,2,3,3,2,2,7,7,1,1,6,6,2,2,7,7,5,5,0,0,5,5,4,4,3,3,4,4,7,7,6,6,0,0,0,0,6,6,3,3,5,5,1,1,1,1,0,0,6,6,6,6,4,4,1,1,6,6,2,2,3,3,1,1,1,1,7,7,6,6,1,1,7,7,5,5,0,0,5,5,3,3,5,5,7,7,7,7,1,1,1,1,6,6,0,0,1,1,2,2,6,6,1,1,4,4,4,4,2,2,7,7,4,4,3,3,7,7,6,6,6,6,1,1,3,3,6,6,5,5,6,6,2,2,7,7,4,4,4,4,6,6,5,5,0,0,0,0,4,4,2,2,7,7,0,0,5,5,5,5,3,3,1,1,2,2,0,0,1,1,0,0,4,4,3,3,4,4,4,4,4,4,7,7,4,4,1,1,4,4,1,1,2,2,4,4,0,0,4,4,2,2,5,5,2,2,4,4,1,1,1,1,7,7,5,5,5,5,3,3,3,3,7,7,7,7,0,0,3,3,6,6,6,6,4,4,1,1,6,6,7,7,0,0,7,7,6,6,2,2,6,6,2,2,6,6,4,4,6,6,7,7,0,0,4,4,2,2,1,1,4,4,6,6,2,2,1,1,0,0,6,6,4,4,0,0,1,1,1,1,3,3,2,2,3,3,3,3,0,0,6,6,0,0,4,4,6,6,2,2,1,1,5,5,2,2,6,6,3,3,2,2,7,7,3,3,4,4,3,3,2,2,7,7,4,4,7,7,1,1,0,0,4,4,6,6,2,2,5,5,3,3,0,0,5,5,3,3,4,4,2,2,1,1,2,2,2,2,3,3,4,4,7,7,2,2,2,2,1,1,1,1,7,7,7,7,7,7,1,1,5,5,7,7,6,6,4,4,6,6,0,0,4,4,4,4,1,1,0,0,1,1,2,2,6,6,2,2,7,7,6,6,5,5,2,2,4,4,1,1,1,1,4,4,4,4,1,1,2,2,6,6,1,1,7,7,6,6,7,7,7,7,3,3,7,7,3,3,1,1,7,7,5,5,4,4,6,6,2,2,3,3,1,1,2,2,0,0,2,2,0,0,3,3,2,2,5,5,1,1,0,0,0,0,6,6,5,5,3,3,4,4,1,1,7,7,5,5,2,2,2,2,7,7,1,1,0,0,0,0,6,6,2,2,4,4,4,4,3,3,7,7,2,2,4,4,3,3,5,5,4,4,4,4,4,4,0,0,3,3,7,7,7,7,2,2,6,6,7,7,7,7,6,6,7,7,6,6,3,3,6,6,7,7,3,3,4,4,2,2,1,1,4,4,5,5,1,1,1,1,0,0,7,7,2,2,6,6,2,2,0,0,2,2,6,6,6,6,5,5,0,0,7,7,5,5,4,4,6,6,5,5,3,3,7,7,5,5,6,6,0,0,6,6,4,4,2,2,0,0,0,0,5,5,4,4,6,6,2,2,0,0,1,1,3,3,1,1,6,6,4,4,4,4,4,4,5,5,1,1,4,4,2,2,5,5,1,1,4,4,6,6,1,1,6,6,4,4,0,0,6,6,0,0,2,2,5,5,2,2,3,3,0,0,7,7,5,5,3,3,2,2,2,2,0,0,5,5,0,0,6,6,2,2,5,5,7,7,6,6,2,2,1,1,4,4,4,4,6,6,0,0,6,6,5,5,6,6,0,0,7,7,3,3,4,4,2,2,3,3,0,0,0,0,2,2,2,2,6,6,2,2,1,1,0,0,7,7,5,5,6,6,5,5,4,4,2,2,3,3,1,1,2,2,1,1,0,0,7,7,4,4,2,2,0,0,7,7,6,6,0,0,7,7,2,2,3,3,5,5,5,5,6,6,3,3,7,7,3,3,0,0,5,5,7,7,2,2,1,1,2,2,0,0,0,0,4,4,6,6,4,4,0,0,7,7,6,6,4,4,1,1,0,0,7,7,4,4,2,2,0,0,2,2,1,1,4,4,3,3,4,4,1,1,3,3,7,7,1,1,2,2,1,1,1,1,0,0,3,3,2,2,6,6,2,2,5,5,7,7,0,0,6,6,3,3,3,3,2,2,2,2,3,3,3,3,3,3,1,1,4,4,0,0,5,5,1,1,0,0,0,0,6,6,1,1,2,2,1,1,1,1,0,0,7,7,3,3,3,3,4,4,5,5,3,3,7,7,4,4,2,2,3,3,6,6,2,2,2,2,2,2,4,4,3,3,5,5,3,3,7,7,0,0,1,1,4,4,6,6,3,3,4,4,5,5,6,6,3,3,3,3,6,6,5,5,1,1,3,3,7,7,6,6,4,4,3,3,5,5,4,4,1,1,0,0,3,3,7,7,0,0,0,0,4,4,1,1,0,0,7,7,5,5,5,5,0,0,1,1,3,3,2,2,6,6,1,1,4,4,5,5,7,7,5,5,4,4,1,1,7,7,4,4,4,4,5,5,6,6,4,4,0,0,1,1,7,7,4,4,2,2,0,0,5,5,0,0,5,5,5,5,5,5,3,3,3,3,0,0,0,0,5,5,1,1,5,5,4,4,0,0,7,7,4,4,0,0,2,2,3,3,3,3,7,7,3,3,3,3,1,1,0,0,1,1,2,2,7,7,1,1,2,2,3,3,7,7,1,1,6,6,2,2,0,0,1,1,1,1,4,4,4,4,5,5,1,1,0,0,4,4,6,6,0,0,7,7,5,5,5,5,4,4,4,4,7,7,7,7,6,6,3,3,2,2,2,2,2,2,1,1,0,0,5,5,2,2,7,7,0,0,1,1,5,5,6,6,1,1,2,2,5,5,4,4,4,4,6,6,4,4,2,2,5,5,4,4,0,0,4,4,5,5,1,1,6,6,6,6,1,1,0,0,5,5,2,2,5,5,1,1,6,6,0,0,7,7,0,0,3,3,4,4,2,2,4,4,2,2,3,3,0,0,7,7,1,1,7,7,0,0,6,6,7,7,4,4,3,3,7,7,7,7,0,0,7,7,1,1,6,6,5,5,4,4,4,4,6,6,2,2,7,7,0,0,0,0,4,4,5,5,1,1,4,4,3,3,5,5,1,1,6,6,4,4,2,2,0,0,2,2,2,2,2,2,3,3,3,3,3,3,2,2,2,2,2,2,6,6,0,0,7,7,4,4,5,5,4,4,0,0,0,0,3,3,7,7,6,6,4,4,6,6,4,4,3,3,2,2,5,5,2,2,0,0,1,1,4,4,0,0,3,3,6,6,5,5,3,3,4,4,7,7,3,3,5,5,0,0,7,7,1,1,0,0,5,5,5,5,6,6,7,7,4,4,0,0,7,7,3,3,5,5,3,3,1,1,2,2,4,4,7,7,6,6,2,2,2,2,5,5,6,6,6,6,6,6,7,7,5,5,0,0,0,0,2,2,7,7,7,7,5,5,0,0,6,6,1,1,7,7,4,4,4,4,4,4,4,4,2,2,2,2,7,7,0,0,0,0,0,0,7,7,2,2,3,3,4,4,6,6,0,0,1,1,2,2,2,2,6,6,3,3,1,1,3,3,1,1,0,0,1,1,3,3,6,6,6,6,5,5,3,3,6,6,5,5,2,2,0,0,5,5,1,1,3,3,1,1,4,4,2,2,3,3,6,6,7,7,0,0,6,6,4,4,3,3,7,7,4,4,0,0,3,3,0,0,3,3,3,3,3,3,3,3,6,6,4,4,4,4,4,4,3,3,0,0,7,7,7,7,4,4,3,3,2,2,7,7,7,7,0,0,6,6,2,2,5,5,7,7,5,5,0,0,6,6,6,6,3,3,6,6,1,1,3,3,3,3,1,1,5,5,7,7,6,6,1,1,0,0,6,6,3,3,4,4,6,6,7,7,5,5,6,6,6,6,7,7,3,3,4,4,1,1,0,0,2,2,4,4,4,4,1,1,7,7,3,3,6,6,1,1,0,0,6,6,3,3,5,5,6,6,6,6,5,5,5,5,3,3,0,0,3,3,1,1,6,6,5,5,2,2,5,5,2,2,0,0,0,0,0,0,4,4,1,1,7,7,0,0,2,2,5,5,6,6,2,2,1,1,0,0,6,6,7,7,1,1,7,7,0,0,5,5,6,6,3,3,2,2,2,2,0,0,1,1,7,7,4,4,4,4,1,1,0,0,5,5,5,5,1,1,4,4,3,3,6,6,5,5,0,0,5,5,1,1,7,7,2,2,4,4,4,4,3,3,5,5,4,4,1,1,2,2,5,5,5,5,0,0,3,3,0,0,5,5,2,2,5,5,3,3,4,4,1,1,5,5,0,0,7,7,5,5,3,3,7,7,3,3,0,0,6,6,2,2,4,4,2,2,4,4,2,2,5,5,6,6,0,0,2,2,3,3,5,5,3,3,1,1,7,7,5,5,0,0,7,7,3,3,4,4,6,6,7,7,0,0,2,2,6,6,7,7,6,6,3,3,1,1,0,0,1,1,3,3,3,3,0,0,2,2,2,2,1,1,0,0,3,3,5,5,3,3,3,3,6,6,7,7,2,2,7,7,5,5,6,6,6,6,1,1,0,0,3,3,3,3,1,1,3,3,0,0,4,4,4,4,0,0,0,0,3,3,1,1,3,3,7,7,4,4,7,7,3,3,5,5,3,3,5,5,5,5,0,0,4,4,3,3,2,2,4,4,0,0,7,7,4,4,0,0,4,4,4,4,6,6,0,0,7,7,3,3,2,2,7,7,3,3,2,2,0,0,5,5,5,5,4,4,5,5,3,3,6,6,0,0,1,1,0,0,5,5,3,3,2,2,7,7,1,1,7,7,1,1,3,3,5,5,4,4,2,2,3,3,3,3,2,2,4,4,5,5,3,3,2,2,0,0,4,4,0,0,2,2,7,7,0,0,5,5,6,6,3,3,2,2,2,2,6,6,1,1,4,4,2,2,6,6,1,1,1,1,7,7,0,0,4,4,5,5,6,6,5,5,0,0,3,3,1,1,0,0,0,0,6,6,2,2,0,0,6,6,6,6,6,6,2,2,2,2,0,0,5,5,4,4,2,2,1,1,4,4,5,5,2,2,0,0,0,0,6,6,6,6,0,0,6,6,5,5,4,4,1,1,6,6,3,3,0,0,5,5,6,6,2,2,4,4,0,0,4,4,3,3,6,6,1,1,5,5,5,5,0,0,6,6,0,0,5,5,3,3,6,6,0,0,7,7,5,5,6,6,0,0,2,2,5,5,5,5,5,5,5,5,5,5,7,7,5,5,2,2,4,4,5,5,6,6,3,3,1,1,0,0,4,4,3,3,1,1,2,2,0,0,4,4,0,0,0,0,5,5,4,4,3,3,3,3,5,5,0,0,6,6,5,5,2,2,4,4,5,5,7,7,1,1,5,5,6,6,2,2,0,0,5,5,5,5,1,1,5,5,2,2,0,0,4,4,4,4,7,7,4,4,2,2,1,1,5,5,2,2,3,3,0,0,1,1,7,7,2,2,5,5,1,1,6,6,0,0,0,0,7,7,2,2,6,6,4,4,6,6,2,2,3,3,1,1,5,5,5,5,7,7,2,2,7,7,0,0,2,2,2,2,7,7,4,4,4,4,5,5,0,0,6,6,0,0,4,4,6,6,3,3,0,0,0,0,0,0,0,0,6,6,5,5,7,7,7,7,3,3,4,4,7,7,2,2,5,5,1,1,1,1,7,7,4,4,4,4,5,5,0,0,3,3,6,6,1,1,5,5,5,5,0,0,5,5,0,0,0,0,3,3,3,3,1,1,6,6,2,2,2,2,7,7,5,5,0,0,5,5,2,2,1,1,1,1,0,0,7,7,3,3,5,5,4,4,0,0,1,1,0,0,0,0,3,3,1,1,4,4,6,6,0,0,3,3,2,2,3,3,5,5,7,7,3,3,4,4,2,2,5,5,2,2,2,2,5,5,2,2,4,4,2,2,3,3,5,5,3,3,0,0,7,7,2,2,0,0,7,7,4,4,3,3,0,0,5,5,2,2,1,1,4,4,2,2,4,4,6,6,1,1,7,7,3,3,3,3,3,3,7,7,0,0,2,2,6,6,6,6,4,4,4,4,2,2,1,1,3,3,2,2,1,1,1,1,5,5,7,7,5,5,5,5,4,4,1,1,6,6,0,0,6,6,2,2,1,1,5,5,6,6,1,1,6,6,3,3,4,4,5,5,5,5,1,1,7,7,4,4,0,0,1,1,0,0,3,3,6,6,6,6,4,4,0,0,7,7,4,4,3,3,0,0,4,4,1,1,4,4,0,0,1,1,7,7,3,3,0,0,7,7,2,2,6,6,0,0,7,7,5,5,5,5,1,1,3,3,0,0,5,5,3,3,7,7,6,6,0,0,2,2,0,0,0,0,3,3,7,7,1,1,5,5,7,7,7,7,0,0,6,6,3,3,5,5,6,6,3,3,4,4,6,6,7,7,6,6,3,3,0,0,7,7,7,7,1,1,4,4,1,1,6,6,4,4,1,1,5,5,3,3,0,0,0,0,7,7,4,4,2,2,1,1,0,0,3,3,7,7,0,0,1,1,4,4,0,0,1,1,1,1,3,3,1,1,7,7,6,6,6,6,1,1,0,0,5,5,1,1,3,3,1,1,7,7,3,3,3,3,0,0,6,6,1,1,5,5,6,6,3,3,0,0,7,7,7,7,5,5,0,0,3,3,1,1,4,4,1,1,7,7,0,0,5,5,4,4,7,7,1,1,2,2,0,0,4,4,3,3,6,6,6,6,6,6,0,0,3,3,0,0,2,2,7,7,4,4,5,5,5,5,4,4,6,6,4,4,2,2,0,0,5,5,5,5,4,4,5,5,7,7,5,5,2,2,0,0,0,0,4,4,2,2,7,7,4,4,5,5,4,4,6,6,5,5,7,7,1,1,4,4,5,5,2,2,3,3,3,3,0,0,0,0,6,6,2,2,6,6,3,3,7,7,1,1,5,5,2,2,1,1,0,0,3,3,0,0,5,5,7,7,6,6,4,4,2,2,2,2,4,4,6,6,1,1,2,2,4,4,3,3,6,6,1,1,5,5,7,7,3,3,2,2,4,4,7,7,5,5,1,1,1,1,2,2,7,7,6,6,3,3,3,3,2,2,2,2,4,4,5,5,3,3,2,2,5,5,7,7,0,0,1,1,1,1,0,0,3,3,2,2,7,7,3,3,0,0,1,1,5,5,0,0,6,6,2,2,0,0,3,3,5,5,3,3,3,3,0,0,7,7,5,5,5,5,5,5,1,1,0,0,3,3,0,0,7,7,4,4,2,2,1,1,2,2,0,0,1,1,2,2,4,4,3,3,1,1,2,2,5,5,4,4,6,6,6,6,4,4,4,4,7,7,6,6,5,5,7,7,6,6,4,4,0,0,3,3,6,6,4,4,4,4,1,1,7,7,7,7,7,7,0,0,3,3,2,2,6,6,2,2,1,1,1,1,7,7,5,5,2,2,6,6,3,3,1,1,1,1,1,1,0,0,2,2,6,6,5,5,2,2,7,7,4,4,1,1,7,7,0,0,3,3,0,0,0,0,1,1,3,3,6,6,7,7,3,3,7,7,7,7,6,6,7,7,7,7,2,2,4,4,0,0,4,4,5,5,2,2,6,6,1,1,7,7,5,5,5,5,2,2,1,1,2,2,4,4,0,0,0,0,4,4,1,1,4,4,4,4,6,6,1,1,6,6,2,2,3,3,2,2,7,7,2,2,5,5,3,3,5,5,3,3,1,1,5,5,2,2,1,1,3,3,6,6,7,7,6,6,1,1,4,4,2,2,2,2,5,5,0,0,7,7,2,2,1,1,3,3,6,6,4,4,1,1,6,6,6,6,1,1,6,6,2,2,5,5,0,0,5,5,6,6,0,0,7,7,5,5,1,1,4,4,3,3,4,4,2,2,4,4,7,7,4,4,2,2,5,5,5,5,7,7,7,7,2,2,5,5,2,2,4,4,1,1,1,1,0,0,0,0,4,4,4,4,0,0,1,1,4,4,4,4,0,0,7,7,0,0,6,6,2,2,7,7,6,6,2,2,3,3,4,4,5,5,0,0,4,4,3,3,5,5,4,4,6,6,3,3,7,7,2,2,0,0,3,3,6,6,4,4,3,3,1,1,1,1,0,0,1,1,0,0,3,3,5,5,1,1,0,0,7,7,6,6,7,7,4,4,0,0,0,0,7,7,6,6,0,0,6,6,6,6,0,0,0,0,5,5,1,1,5,5,6,6,1,1,3,3,7,7,2,2,6,6,4,4,4,4,6,6,5,5,5,5,3,3,4,4,1,1,2,2,1,1,2,2,4,4,0,0,6,6,6,6,7,7,7,7,2,2,1,1,0,0,1,1,1,1,2,2,3,3,4,4,1,1,7,7,0,0,0,0,2,2,6,6,5,5,0,0,7,7,2,2,2,2,0,0,4,4,7,7,6,6,0,0,7,7,5,5,5,5,3,3,6,6,7,7,7,7,1,1,3,3,3,3,2,2,2,2,4,4,5,5,1,1,4,4,5,5,4,4,4,4,1,1,2,2,5,5,6,6,3,3,0,0,5,5,3,3,2,2,6,6,4,4,3,3,3,3,6,6,4,4,1,1,5,5,4,4,6,6,1,1,7,7,5,5,3,3,6,6,2,2,7,7,6,6,5,5,2,2,5,5,1,1,5,5,7,7,4,4,0,0,4,4,3,3,2,2,4,4,3,3,1,1,6,6,1,1,6,6,7,7,0,0,2,2,7,7,0,0,5,5,6,6,6,6,2,2,6,6,6,6,0,0,3,3,1,1,0,0,5,5,4,4,1,1,7,7,1,1,0,0,4,4,0,0,0,0,1,1,7,7,1,1,5,5,7,7,5,5,5,5,0,0,6,6,7,7,7,7,1,1,7,7,4,4,6,6,0,0,6,6,4,4,5,5,6,6,4,4,3,3,0,0,0,0,5,5,7,7,1,1,6,6,6,6,1,1,6,6,7,7,1,1,1,1,7,7,5,5,4,4,7,7,0,0,2,2,2,2,2,2,6,6,2,2,3,3,3,3,2,2,5,5,1,1,3,3,0,0,5,5,3,3,6,6,2,2,4,4,3,3,7,7,2,2,4,4,7,7,1,1,4,4,4,4,1,1,2,2,0,0,4,4,3,3,7,7,0,0,1,1,2,2,1,1,0,0,6,6,0,0,5,5,0,0,7,7,1,1,1,1,1,1,4,4,6,6,1,1,5,5,7,7,7,7,7,7,1,1,5,5,2,2,3,3,2,2,6,6,3,3,1,1,4,4,2,2,3,3,0,0,4,4,3,3,7,7,2,2,3,3,3,3,4,4,5,5,4,4,5,5,1,1,4,4,1,1,5,5,4,4,7,7,6,6,4,4,4,4,1,1,5,5,5,5,4,4,1,1,0,0,1,1,4,4,3,3,0,0,2,2,4,4,2,2,3,3,5,5,4,4,0,0,7,7,2,2,0,0,3,3,6,6,5,5,5,5,5,5,7,7,5,5,4,4,6,6,1,1,1,1,7,7,1,1,1,1,1,1,4,4,4,4,2,2,5,5,0,0,1,1,7,7,1,1,2,2,0,0,1,1,6,6,7,7,5,5,6,6,6,6,3,3,4,4,6,6,4,4,1,1,7,7,2,2,7,7,0,0,6,6,6,6,6,6,2,2,4,4,1,1,7,7,6,6,4,4,6,6,7,7,1,1,6,6,4,4,0,0,1,1,2,2,4,4,1,1,0,0,1,1,2,2,6,6,0,0,3,3,1,1,7,7,5,5,5,5,3,3,4,4,3,3,0,0,4,4,2,2,1,1,2,2,7,7,7,7,5,5,5,5,5,5,6,6,6,6,7,7,6,6,0,0,3,3,4,4,6,6,6,6,1,1,4,4,5,5,0,0,2,2,0,0,3,3,4,4,5,5,0,0,2,2,1,1,0,0,5,5,4,4,5,5,5,5,5,5,6,6,5,5,7,7,3,3,5,5,4,4,5,5,1,1,0,0,5,5,4,4,2,2,1,1,4,4,5,5,4,4,5,5,5,5,0,0,1,1,5,5,4,4,6,6,1,1,0,0,5,5,0,0,5,5,2,2,0,0,2,2,3,3,7,7,0,0,7,7,6,6,5,5,5,5,0,0,0,0,2,2,4,4,2,2,5,5,1,1,0,0,1,1,3,3,2,2,6,6,7,7,2,2,3,3,2,2,4,4,6,6,0,0,7,7,5,5,5,5,4,4,4,4,4,4,0,0,6,6,5,5,7,7,7,7,5,5,7,7,5,5,7,7,0,0,1,1,3,3,2,2,4,4,0,0,2,2,6,6,2,2,2,2,0,0,1,1,4,4,6,6,0,0,3,3,2,2,0,0,7,7,3,3,6,6,5,5,4,4,4,4,5,5,2,2,3,3,0,0,5,5,7,7,0,0,2,2,2,2,4,4,2,2,2,2,0,0,5,5,3,3,4,4,3,3,6,6,4,4,3,3,2,2,4,4,6,6,5,5,1,1,6,6,7,7,2,2,7,7,1,1,2,2,3,3,5,5,3,3,0,0,2,2,2,2,2,2,6,6,3,3,1,1,1,1,0,0,1,1,1,1,5,5,4,4,7,7,6,6,7,7,0,0,2,2,1,1,2,2,1,1,4,4,5,5,0,0,5,5,4,4,1,1,0,0,5,5,6,6,7,7,4,4,0,0,4,4,0,0,6,6,1,1,5,5,7,7,6,6,0,0,7,7,0,0,6,6,3,3,3,3,5,5,7,7,7,7,2,2,7,7,2,2,3,3,2,2,4,4,7,7,5,5,4,4,7,7,2,2,6,6,3,3,1,1,5,5,6,6,7,7,4,4,1,1,3,3,6,6,0,0,1,1,2,2,0,0,7,7,3,3,2,2,4,4,5,5,3,3,5,5,0,0,4,4,2,2,4,4,5,5,1,1,1,1,1,1,5,5,2,2,0,0,6,6,0,0,7,7,0,0,7,7,6,6,5,5,7,7,3,3,0,0,3,3,1,1,0,0,3,3,6,6,5,5,6,6,1,1,4,4,6,6,2,2,6,6,7,7,3,3,6,6,4,4,0,0,0,0,7,7,5,5,4,4,2,2,7,7,0,0,7,7,4,4,1,1,1,1,3,3,2,2,7,7,5,5,7,7,3,3,5,5,2,2,4,4,4,4,2,2,6,6,4,4,7,7,0,0,6,6,1,1,0,0,3,3,2,2,2,2,7,7,6,6,2,2,2,2,1,1,5,5,1,1,4,4,3,3,2,2,2,2,3,3,6,6,4,4,1,1,0,0,4,4,2,2,5,5,5,5,4,4,6,6,7,7,3,3,5,5,1,1,4,4,2,2,2,2,4,4,2,2,1,1,7,7,7,7,5,5,7,7,4,4,3,3,7,7,2,2,6,6,4,4,5,5,0,0,1,1,1,1,1,1,6,6,0,0,1,1,7,7,2,2,0,0,5,5,2,2,1,1,7,7,0,0,7,7,2,2,6,6,1,1,0,0,6,6,7,7,3,3,4,4,7,7,4,4,4,4,2,2,3,3,1,1,3,3,2,2,0,0,7,7,5,5,2,2,0,0,5,5,1,1,7,7,3,3,7,7,7,7,4,4,2,2,0,0,2,2,1,1,1,1,5,5,7,7,1,1,3,3,6,6,6,6,6,6,6,6,7,7,4,4,5,5,2,2,6,6,1,1,7,7,6,6,1,1,6,6,4,4,2,2,0,0,2,2,3,3,1,1,7,7,6,6,4,4,0,0,7,7,5,5,7,7,2,2,1,1,2,2,1,1,2,2,5,5,0,0,5,5,3,3,1,1,1,1,5,5,3,3,2,2,5,5,1,1,5,5,6,6,0,0,5,5,7,7,0,0,5,5,0,0,6,6,7,7,7,7,5,5,5,5,7,7,1,1,3,3,7,7,3,3,0,0,1,1,5,5,6,6,6,6,7,7,6,6,0,0,4,4,1,1,0,0,4,4,4,4,7,7,6,6,5,5,5,5,0,0,6,6,0,0,6,6,2,2,5,5,6,6,7,7,0,0,7,7,6,6,5,5,1,1,5,5,0,0,4,4,2,2,1,1,1,1,1,1,6,6,0,0,1,1,4,4,7,7,5,5,7,7,4,4,5,5,6,6,6,6,3,3,6,6,7,7,5,5,0,0,5,5,0,0,4,4,2,2,0,0,7,7,6,6,2,2,6,6,2,2,5,5,3,3,3,3,3,3,2,2,4,4,2,2,7,7,3,3,1,1,3,3,6,6,2,2,1,1,0,0,5,5,6,6,4,4,2,2,6,6,1,1,5,5,6,6,2,2,0,0,5,5,3,3,6,6,5,5,6,6,4,4,4,4,6,6,4,4,0,0,5,5,7,7,1,1,2,2,6,6,1,1,1,1,0,0,7,7,6,6,4,4,6,6,4,4,2,2,3,3,5,5,5,5,2,2,4,4,6,6,5,5,0,0,5,5,1,1,6,6,5,5,1,1,1,1,5,5,3,3,1,1,1,1,1,1,3,3,2,2,7,7,3,3,3,3,6,6,5,5,0,0,3,3,0,0,6,6,4,4,7,7,4,4,1,1,3,3,5,5,2,2,6,6,0,0,3,3,6,6,1,1,5,5,7,7,1,1,1,1,3,3,3,3,4,4,2,2,4,4,3,3,0,0,1,1,2,2,1,1,6,6,6,6,1,1,0,0,6,6,3,3,0,0,4,4,7,7,0,0,7,7,1,1,0,0,0,0,1,1,3,3,0,0,2,2,4,4,7,7,4,4,2,2,5,5,5,5,5,5,3,3,1,1,1,1,3,3,1,1,0,0,3,3,6,6,7,7,2,2,0,0,0,0,6,6,2,2,0,0,1,1,2,2,4,4,7,7,7,7,0,0,1,1,2,2,1,1,0,0,2,2,5,5,5,5,7,7,4,4,2,2,6,6,7,7,2,2,2,2,1,1,0,0,3,3,3,3,5,5,0,0,2,2,0,0,4,4,3,3,7,7,4,4,2,2,3,3,4,4,0,0,0,0,6,6,7,7,1,1,1,1,0,0,6,6,0,0,0,0,3,3,5,5,7,7,4,4,6,6,5,5,1,1,7,7,4,4,6,6,1,1,0,0,3,3,2,2,5,5,3,3,6,6,6,6,1,1,2,2,0,0,2,2,6,6,1,1,0,0,1,1,1,1,0,0,7,7,0,0,2,2,6,6,2,2,1,1,3,3,3,3,7,7,4,4,1,1,7,7,4,4,6,6,1,1,0,0,1,1,6,6,7,7,3,3,1,1,0,0,3,3,7,7,3,3,7,7,7,7,7,7,5,5,3,3,5,5,4,4,5,5,3,3,7,7,0,0,2,2,4,4,1,1,2,2,4,4,4,4,7,7,5,5,3,3,6,6,0,0,6,6,0,0,3,3,1,1,6,6,0,0,3,3,4,4,2,2,3,3,4,4,0,0,3,3,2,2,3,3,1,1,0,0,2,2,0,0,3,3,7,7,2,2,1,1,7,7,3,3,4,4,5,5,4,4,7,7,4,4,1,1,0,0,7,7,1,1,7,7,3,3,2,2,5,5,5,5,7,7,5,5,2,2,0,0,2,2,7,7,5,5,4,4,1,1,3,3,6,6,0,0,2,2,4,4,7,7,0,0,0,0,4,4,2,2,0,0,2,2,0,0,7,7,0,0,5,5,5,5,5,5,4,4,4,4,4,4,1,1,4,4,2,2,7,7,5,5,2,2,0,0,6,6,5,5,1,1,4,4,6,6,1,1,2,2,2,2,6,6,2,2,2,2,4,4,4,4,0,0,2,2,2,2,7,7,6,6,6,6,1,1,1,1,2,2,4,4,2,2,0,0,0,0,0,0,0,0,3,3,7,7,1,1,0,0,0,0,6,6,0,0,0,0,4,4,4,4,4,4,5,5,2,2,3,3,1,1,3,3,5,5,0,0,6,6,0,0,5,5,5,5,7,7,5,5,3,3,6,6,5,5,4,4,1,1,4,4,0,0,4,4,5,5,0,0,5,5,1,1,0,0,2,2,3,3,1,1,3,3,2,2,3,3,7,7,1,1,0,0,2,2,1,1,5,5,6,6,3,3,7,7,7,7,6,6,4,4,4,4,7,7,7,7,4,4,0,0,7,7,4,4,1,1,3,3,3,3,6,6,7,7,4,4,3,3,7,7,1,1,5,5,6,6,2,2,0,0,3,3,1,1,1,1,5,5,3,3,6,6,4,4,5,5,3,3,2,2,5,5,3,3,3,3,5,5,0,0,7,7,6,6,5,5,1,1,6,6,5,5,4,4,4,4,6,6,7,7,6,6,2,2,5,5,0,0,5,5,1,1,4,4,1,1,1,1,7,7,4,4,0,0,7,7,0,0,5,5,3,3,3,3,4,4,6,6,2,2,4,4,6,6,4,4,0,0,3,3,4,4,2,2,7,7,6,6,4,4,7,7,0,0,2,2,6,6,0,0,2,2,3,3,3,3,2,2,5,5,5,5,0,0,0,0,6,6,3,3,6,6,1,1,3,3,1,1,3,3,7,7,4,4,1,1,2,2,6,6,1,1,2,2,1,1,5,5,1,1,3,3,5,5,1,1,4,4,7,7,3,3,0,0,2,2,7,7,1,1,5,5,5,5,5,5,6,6,3,3,4,4,1,1,1,1,1,1,0,0,4,4,2,2,7,7,0,0,0,0,7,7,5,5,0,0,3,3,6,6,7,7,0,0,2,2,3,3,6,6,4,4,0,0,1,1,0,0,0,0,2,2,4,4,1,1,7,7,5,5,6,6,4,4,5,5,1,1,3,3,3,3,4,4,5,5,1,1,5,5,0,0,7,7,7,7,4,4,5,5,5,5,4,4,3,3,5,5,7,7,3,3,2,2,1,1,5,5,4,4,3,3,6,6,0,0,1,1,6,6,4,4,2,2,7,7,4,4,6,6,0,0,1,1,4,4,4,4,5,5,4,4,6,6,2,2,0,0,0,0,6,6,6,6,4,4,6,6,7,7,0,0,6,6,0,0,6,6,5,5,3,3,2,2,7,7,1,1,4,4,4,4,2,2,3,3,3,3,6,6,5,5,3,3,3,3,4,4,7,7,2,2,5,5,6,6,7,7,4,4,4,4,4,4,6,6,3,3,4,4,5,5,4,4,7,7,3,3,4,4,4,4,4,4,5,5,1,1,6,6,4,4,7,7,0,0,0,0,6,6,5,5,6,6,4,4,2,2,5,5,1,1,0,0,7,7,1,1,5,5,4,4,2,2,6,6,1,1,3,3,3,3,7,7,6,6,4,4,4,4,2,2,1,1,5,5,3,3,2,2,6,6,2,2,4,4,3,3,7,7,7,7,2,2,4,4,2,2,3,3,1,1,4,4,0,0,2,2,0,0,0,0,0,0,1,1,0,0,1,1,5,5,5,5,1,1,2,2,6,6,5,5,6,6,1,1,6,6,1,1,1,1,0,0,6,6,0,0,0,0,3,3,6,6,3,3,7,7,3,3,2,2,5,5,1,1,4,4,6,6,2,2,7,7,3,3,4,4,3,3,3,3,2,2,3,3,6,6,0,0,1,1,5,5,4,4,0,0,7,7,3,3,3,3,7,7,6,6,6,6,0,0,3,3,4,4,0,0,6,6,2,2,5,5,4,4,0,0,0,0,4,4,4,4,2,2,1,1,2,2,5,5,6,6,2,2,4,4,2,2,6,6,1,1,7,7,1,1,0,0,5,5,7,7,3,3,3,3,4,4,6,6,2,2,0,0,6,6,6,6,3,3,2,2,4,4,3,3,0,0,6,6,7,7,1,1,5,5,0,0,1,1,2,2,7,7,2,2,1,1,4,4,5,5,0,0,0,0,7,7,1,1,1,1,3,3,1,1,4,4,5,5,0,0,2,2,2,2,1,1,6,6,1,1,2,2,1,1,4,4,1,1,2,2,6,6,3,3,7,7,0,0,3,3,3,3,2,2,2,2,4,4,6,6,5,5,5,5,7,7,0,0,2,2,0,0,1,1,7,7,0,0,5,5,4,4,2,2,5,5,4,4,7,7,3,3,4,4,5,5,0,0,4,4,1,1,5,5,5,5,2,2,2,2,6,6,1,1,1,1,3,3,3,3,4,4,2,2,1,1,7,7,6,6,5,5,6,6,3,3,4,4,6,6,0,0,2,2,4,4,4,4,0,0,0,0,4,4,2,2,4,4,2,2,5,5,2,2,0,0,2,2,4,4,2,2,2,2,6,6,2,2,3,3,2,2,6,6,0,0,3,3,7,7,5,5,5,5,4,4,1,1,4,4,6,6,1,1,4,4,0,0,7,7,3,3,3,3,2,2,4,4,6,6,4,4,3,3,6,6,4,4,0,0,7,7,5,5,4,4,1,1,1,1,7,7,7,7,7,7,4,4,5,5,7,7,6,6,5,5,4,4,6,6,4,4,1,1,4,4,6,6,0,0,7,7,4,4,4,4,5,5,2,2,1,1,3,3,4,4,2,2,0,0,0,0,3,3,2,2,3,3,4,4,5,5,0,0,5,5,0,0,7,7,2,2,7,7,7,7,3,3,7,7,7,7,0,0,7,7,1,1,2,2,2,2,4,4,6,6,2,2,6,6,4,4,6,6,3,3,1,1,7,7,0,0,1,1,5,5,2,2,1,1,4,4,1,1,2,2,0,0,4,4,4,4,5,5,2,2,6,6,1,1,0,0,6,6,3,3,3,3,5,5,3,3,3,3,0,0,5,5,2,2,5,5,2,2,6,6,5,5,4,4,3,3,3,3,6,6,6,6,1,1,4,4,1,1,4,4,0,0,6,6,6,6,7,7,5,5,5,5,4,4,4,4,7,7,4,4,4,4,4,4,6,6,6,6,7,7,0,0,2,2,0,0,7,7,2,2,2,2,7,7,4,4,0,0,2,2,5,5,4,4,7,7,1,1,7,7,7,7,6,6,3,3,3,3,4,4,1,1,7,7,3,3,4,4,1,1,1,1,5,5,0,0,7,7,2,2,3,3,1,1,5,5,4,4,1,1,3,3,7,7,5,5,4,4,5,5,7,7,5,5,7,7,4,4,0,0,5,5,3,3,0,0,5,5,2,2,0,0,2,2,4,4,4,4,0,0,0,0,5,5,6,6,4,4,2,2,5,5,4,4,4,4,7,7,1,1,2,2,6,6,4,4,3,3,1,1,7,7,2,2,2,2,7,7,4,4,0,0,5,5,0,0,0,0,1,1,7,7,4,4,1,1,7,7,4,4,0,0,6,6,0,0,5,5,7,7,1,1,7,7,2,2,1,1,0,0,4,4,3,3,6,6,0,0,4,4,3,3,5,5,4,4,2,2,4,4,4,4,4,4,7,7,2,2,6,6,0,0,7,7,4,4,6,6,2,2,1,1,3,3,5,5,2,2,0,0,6,6,4,4,3,3,1,1,6,6,4,4,5,5,2,2,0,0,7,7,4,4,4,4,0,0,2,2,0,0,0,0,6,6,6,6,2,2,7,7,4,4,2,2,2,2,3,3,6,6,0,0,1,1,2,2,4,4,2,2,0,0,6,6,1,1,1,1,4,4,3,3,3,3,7,7,4,4,7,7,7,7,2,2,6,6,3,3,0,0,1,1,6,6,0,0,7,7,0,0,6,6,0,0,2,2,7,7,6,6,0,0,0,0,3,3,4,4,4,4,2,2,6,6,0,0,5,5,5,5,1,1,7,7,4,4,7,7,5,5,1,1,4,4,7,7,1,1,3,3,0,0,6,6,6,6,6,6,1,1,2,2,3,3,1,1,3,3,1,1,0,0,1,1,2,2,3,3,4,4,6,6,3,3,0,0,7,7,1,1,2,2,1,1,7,7,3,3,1,1,4,4,4,4,0,0,7,7,6,6,2,2,0,0,3,3,4,4,5,5,1,1,6,6,5,5,0,0,7,7,5,5,3,3,0,0,7,7,7,7,2,2,1,1,6,6,0,0,5,5,4,4,6,6,2,2,0,0,4,4,2,2,0,0,5,5,0,0,3,3,0,0,6,6,2,2,4,4,1,1,2,2,2,2,6,6,2,2,6,6,0,0,2,2,1,1,2,2,0,0,0,0,1,1,5,5,1,1,5,5,1,1,0,0,3,3,0,0,7,7,0,0,0,0,4,4,0,0,1,1,7,7,1,1,3,3,5,5,1,1,7,7,0,0,2,2,5,5,0,0,4,4,2,2,2,2,7,7,7,7,0,0,3,3,3,3,1,1,6,6,0,0,3,3,4,4,0,0,7,7,2,2,0,0,4,4,6,6,5,5,6,6,7,7,6,6,7,7,4,4,3,3,2,2,4,4,2,2,2,2,3,3,0,0,2,2,4,4,2,2,7,7,2,2,0,0,0,0,7,7,2,2,0,0,5,5,5,5,1,1,5,5,0,0,4,4,5,5,0,0,1,1,5,5,6,6,7,7,2,2,5,5,6,6,2,2,4,4,5,5,2,2,0,0,3,3,6,6,6,6,2,2,5,5,3,3,5,5,0,0,5,5,2,2,5,5,6,6,6,6,5,5,4,4,1,1,3,3,4,4,3,3,4,4,0,0,1,1,1,1,7,7,4,4,2,2,6,6,2,2,5,5,4,4,3,3,1,1,3,3,4,4,1,1,7,7,1,1,1,1,4,4,5,5,6,6,4,4,0,0,7,7,0,0,2,2,2,2,6,6,2,2,2,2,6,6,4,4,0,0,7,7,0,0,2,2,4,4,2,2,2,2,5,5,0,0,0,0,6,6,0,0,1,1,0,0,0,0,0,0,7,7,0,0,4,4,5,5,4,4,7,7,6,6,1,1,2,2,0,0,2,2,5,5,6,6,6,6,3,3,6,6,1,1,1,1,1,1,6,6,5,5,5,5,5,5,3,3,7,7,0,0,5,5,2,2,6,6,1,1,0,0,1,1,6,6,3,3,5,5,0,0,2,2,3,3,2,2,3,3,4,4,4,4,2,2,7,7,2,2,6,6,4,4,0,0,5,5,7,7,1,1,1,1,1,1,3,3,7,7,4,4,1,1,0,0,5,5,3,3,5,5,7,7,7,7,2,2,2,2,2,2,7,7,3,3,5,5,3,3,5,5,5,5,7,7,0,0,6,6,5,5,0,0,5,5,5,5,1,1,5,5,2,2,7,7,3,3,7,7,6,6,5,5,7,7,3,3,5,5,6,6,3,3,0,0,2,2,5,5,3,3,6,6,7,7,3,3,4,4,0,0,7,7,4,4,3,3,1,1,6,6,2,2,3,3,6,6,3,3,1,1,2,2,3,3,4,4,3,3,0,0,7,7,2,2,1,1,5,5,2,2,1,1,5,5,7,7,5,5,0,0,1,1,7,7,1,1,1,1,1,1,3,3,5,5,2,2,0,0,3,3,2,2,4,4,4,4,4,4,4,4,3,3,2,2,6,6,1,1,5,5,5,5,3,3,5,5,1,1,7,7,0,0,0,0,6,6,5,5,4,4,0,0,3,3,0,0,7,7,7,7,0,0,4,4,6,6,6,6,0,0,7,7,5,5,2,2,0,0,4,4,7,7,7,7,7,7,6,6,6,6,1,1,0,0,4,4,5,5,4,4,4,4,4,4,3,3,6,6,7,7,2,2,0,0,1,1,2,2,6,6,3,3,6,6,3,3,6,6,5,5,4,4,5,5,2,2,5,5,2,2,7,7,7,7,2,2,1,1,2,2,2,2,0,0,3,3,4,4,7,7,5,5,0,0,5,5,4,4,4,4,1,1,7,7,2,2,4,4,4,4,4,4,2,2,2,2,6,6,7,7,5,5,4,4,2,2,4,4,5,5,7,7,2,2,3,3,5,5,4,4,7,7,7,7,3,3,6,6,7,7,4,4,6,6,6,6,0,0,1,1,6,6,2,2,4,4,5,5,2,2,6,6,6,6,1,1,5,5,3,3,5,5,0,0,4,4,0,0,4,4,1,1,5,5,0,0,6,6,0,0,1,1,7,7,2,2,7,7,7,7,1,1,2,2,2,2,5,5,3,3,6,6,7,7,7,7,5,5,1,1,5,5,6,6,3,3,2,2,0,0,2,2,4,4,0,0,5,5,2,2,4,4,0,0,0,0,1,1,6,6,1,1,0,0,6,6,3,3,4,4,1,1,6,6,5,5,6,6,7,7,4,4,6,6,2,2,2,2,0,0,0,0,5,5,3,3,5,5,6,6,0,0,1,1,0,0,6,6,7,7,2,2,4,4,0,0,3,3,7,7,3,3,7,7,0,0,1,1,1,1,1,1,2,2,1,1,7,7,1,1,6,6,2,2,2,2,2,2,4,4,0,0,0,0,3,3,5,5,3,3,2,2,2,2,5,5,2,2,5,5,4,4,3,3,3,3,3,3,6,6,5,5,3,3,5,5,2,2,2,2,3,3,5,5,4,4,4,4,6,6,2,2,7,7,7,7,5,5,6,6,0,0,3,3,5,5,0,0,7,7,7,7,3,3,7,7,3,3,6,6,5,5,6,6,5,5,6,6,4,4,2,2,1,1,4,4,2,2,2,2,2,2,0,0,2,2,2,2,7,7,3,3,2,2,5,5,6,6,7,7,7,7,7,7,7,7,3,3,4,4,1,1,5,5,5,5,2,2,6,6,0,0,0,0,4,4,3,3,4,4,6,6,1,1,1,1,5,5,6,6,7,7,3,3,1,1,7,7,3,3,4,4,6,6,5,5,5,5,4,4,3,3,1,1,6,6,6,6,2,2,0,0,1,1,2,2,4,4,7,7,3,3,2,2,7,7,0,0,4,4,2,2,0,0,7,7,5,5,3,3,2,2,0,0,0,0,0,0,0,0,4,4,1,1,2,2,5,5,6,6,0,0,2,2,5,5,1,1,6,6,7,7,6,6,6,6,5,5,4,4,1,1,5,5,6,6,0,0,3,3,0,0,7,7,6,6,1,1,7,7,0,0,7,7,4,4,5,5,2,2,7,7,7,7,1,1,2,2,5,5,7,7,3,3,3,3,6,6,4,4,0,0,5,5,2,2,3,3,1,1,5,5,1,1,1,1,5,5,4,4,0,0,5,5,0,0,1,1,5,5,4,4,7,7,0,0,2,2,0,0,2,2,1,1,1,1,0,0,7,7,4,4,2,2,1,1,6,6,0,0,5,5,6,6,3,3,3,3,4,4,5,5,1,1,7,7,7,7,5,5,2,2,1,1,4,4,0,0,5,5,6,6,2,2,2,2,5,5,2,2,7,7,1,1,0,0,1,1,4,4,1,1,6,6,3,3,3,3,4,4,7,7,1,1,3,3,4,4,6,6,2,2,0,0,7,7,0,0,0,0,7,7,0,0,3,3,0,0,4,4,2,2,4,4,3,3,1,1,5,5,5,5,2,2,0,0,0,0,1,1,3,3,6,6,1,1,5,5,7,7,0,0,2,2,4,4,2,2,5,5,0,0,6,6,6,6,0,0,7,7,1,1,2,2,1,1,4,4,4,4,4,4,0,0,3,3,7,7,1,1,5,5,3,3,0,0,4,4,2,2,5,5,3,3,5,5,3,3,7,7,0,0,3,3,2,2,4,4,6,6,1,1,7,7,5,5,2,2,1,1,1,1,0,0,0,0,2,2,0,0,3,3,2,2,2,2,3,3,4,4,5,5,4,4,4,4,0,0,7,7,7,7,0,0,0,0,2,2,6,6,2,2,7,7,4,4,2,2,0,0,0,0,6,6,4,4,0,0,4,4,3,3,7,7,6,6,1,1,3,3,6,6,7,7,0,0,4,4,7,7,5,5,7,7,3,3,4,4,7,7,3,3,4,4,4,4,1,1,4,4,1,1,7,7,1,1,2,2,5,5,6,6,1,1,6,6,5,5,0,0,3,3,1,1,2,2,5,5,5,5,0,0,7,7,0,0,4,4,7,7,1,1,3,3,7,7,3,3,6,6,2,2,4,4,3,3,2,2,0,0,3,3,0,0,5,5,7,7,1,1,0,0,1,1,4,4,2,2,5,5,3,3,0,0,0,0,1,1,6,6,6,6,4,4,1,1,2,2,0,0,0,0,6,6,2,2,3,3,2,2,1,1,1,1,3,3,0,0,4,4,0,0,7,7,7,7,2,2,5,5,7,7,5,5,6,6,0,0,2,2,3,3,0,0,3,3,1,1,5,5,4,4,1,1,2,2,7,7,7,7,0,0,2,2,2,2,6,6,0,0,0,0,4,4,0,0,2,2,7,7,4,4,0,0,6,6,2,2,7,7,7,7,5,5,1,1,0,0,3,3,7,7,4,4,2,2,6,6,6,6,7,7,1,1,4,4,1,1,5,5,3,3,6,6,0,0,0,0,5,5,0,0,5,5,7,7,3,3,3,3,4,4,7,7,0,0,2,2,7,7,4,4,5,5,3,3,0,0,5,5,2,2,1,1,1,1,5,5,4,4,0,0,4,4,7,7,1,1,1,1,0,0,0,0,1,1,4,4,4,4,6,6,4,4,6,6,7,7,2,2,5,5,4,4,0,0,5,5,6,6,2,2,0,0,6,6,5,5,4,4,0,0,2,2,7,7,5,5,4,4,7,7,2,2,5,5,3,3,2,2,6,6,5,5,7,7,1,1,5,5,5,5,2,2,2,2,1,1,0,0,6,6,5,5,1,1,5,5,1,1,2,2,6,6,6,6,5,5,2,2,2,2,0,0,5,5,1,1,4,4,0,0,5,5,6,6,5,5,4,4,2,2,5,5,5,5,4,4,5,5,2,2,0,0,6,6,6,6,4,4,1,1,5,5,0,0,2,2,2,2,3,3,7,7,5,5,1,1,6,6,7,7,4,4,4,4,0,0,5,5,2,2,6,6,0,0,1,1,4,4,0,0,5,5,1,1,4,4,7,7,6,6,7,7,0,0,2,2,5,5,1,1,4,4,4,4,1,1,7,7,7,7,4,4,2,2,2,2,5,5,5,5,1,1,4,4,2,2,5,5,2,2,1,1,1,1,5,5,5,5,5,5,0,0,6,6,6,6,2,2,3,3,2,2,7,7,2,2,6,6,6,6,2,2,3,3,5,5,0,0,7,7,6,6,4,4,7,7,3,3,0,0,4,4,6,6,3,3,0,0,0,0,6,6,7,7,3,3,0,0,6,6,1,1,6,6,3,3,0,0,4,4,5,5,3,3,0,0,3,3,5,5,7,7,0,0,2,2,4,4,6,6,1,1,1,1,4,4,4,4,0,0,5,5,4,4,1,1,2,2,1,1,3,3,1,1,1,1,0,0,7,7,0,0,1,1,6,6,5,5,6,6,1,1,3,3,2,2,5,5,1,1,2,2,2,2,2,2,3,3,2,2,5,5,0,0,6,6,3,3,7,7,1,1,3,3,5,5,6,6,0,0,7,7,7,7,4,4,0,0,3,3,1,1,7,7,7,7,4,4,3,3,0,0,0,0,0,0,0,0,1,1,3,3,5,5,0,0,7,7,0,0,3,3,3,3,4,4,3,3,0,0,1,1,1,1,2,2,5,5,3,3,3,3,1,1,2,2,7,7,3,3,3,3,0,0,7,7,5,5,0,0,1,1,4,4,4,4,4,4,1,1,5,5,1,1,0,0,5,5,7,7,2,2,1,1,6,6,2,2,3,3,3,3,5,5,4,4,3,3,7,7,7,7,2,2,3,3,4,4,5,5,7,7,7,7,3,3,3,3,5,5,2,2,1,1,0,0,3,3,2,2,2,2,4,4,3,3,1,1,6,6,2,2,5,5,6,6,5,5,7,7,4,4,1,1,1,1,6,6,0,0,3,3,4,4,5,5,6,6,3,3,2,2,0,0,7,7,2,2,1,1,7,7,7,7,2,2,4,4,4,4,5,5,7,7,1,1,5,5,7,7,0,0,4,4,3,3,4,4,6,6,4,4,5,5,3,3,4,4,5,5,4,4,2,2,6,6,1,1,0,0,6,6,1,1,4,4,6,6,1,1,1,1,4,4,3,3,0,0,5,5,4,4,5,5,0,0,1,1,5,5,5,5,5,5,5,5,5,5,2,2,0,0,0,0,5,5,2,2,3,3,4,4,6,6,0,0,6,6,5,5,6,6,6,6,2,2,4,4,3,3,1,1,7,7,2,2,5,5,7,7,3,3,1,1,3,3,7,7,7,7,6,6,5,5,1,1,0,0,0,0,3,3,3,3,5,5,2,2,0,0,1,1,6,6,5,5,3,3,5,5,3,3,1,1,1,1,4,4,5,5,1,1,6,6,1,1,0,0,5,5,6,6,5,5,3,3,1,1,0,0,7,7,2,2,5,5,5,5,3,3,5,5,5,5,4,4,6,6,2,2,6,6,6,6,5,5,4,4,0,0,6,6,5,5,4,4,3,3,0,0,1,1,0,0,7,7,4,4,5,5,7,7,4,4,3,3,3,3,2,2,2,2,5,5,3,3,5,5,2,2,2,2,5,5,4,4,4,4,0,0,4,4,5,5,3,3,6,6,3,3,0,0,2,2,1,1,5,5,3,3,4,4,4,4,1,1,7,7,0,0,0,0,4,4,7,7,0,0,7,7,0,0,5,5,4,4,7,7,5,5,4,4,3,3,2,2,2,2,1,1,6,6,6,6,7,7,1,1,6,6,1,1,3,3,0,0,3,3,4,4,0,0,4,4,1,1,4,4,3,3,0,0,2,2,2,2,0,0,2,2,7,7,4,4,7,7,6,6,2,2,3,3,6,6,5,5,1,1,4,4,2,2,3,3,7,7,5,5,3,3,2,2,1,1,2,2,1,1,5,5,7,7,6,6,4,4,7,7,2,2,4,4,7,7,5,5,7,7,1,1,4,4,0,0,2,2,0,0,3,3,6,6,1,1,7,7,0,0,4,4,1,1,1,1,1,1,6,6,4,4,3,3,4,4,1,1,5,5,1,1,4,4,5,5,6,6,6,6,7,7,3,3,5,5,6,6,3,3,3,3,6,6,7,7,2,2,4,4,0,0,5,5,5,5,7,7,1,1,3,3,0,0,0,0,5,5,0,0,6,6,6,6,0,0,4,4,6,6,1,1,3,3,1,1,3,3,3,3,4,4,4,4,5,5,6,6,6,6,0,0,6,6,3,3,6,6,5,5,7,7,4,4,4,4,6,6,7,7,6,6,1,1,4,4,3,3,7,7,2,2,3,3,6,6,5,5,2,2,0,0,6,6,4,4,4,4,1,1,5,5,1,1,7,7,1,1,5,5,0,0,0,0,2,2,5,5,7,7,0,0,2,2,0,0,2,2,3,3,4,4,3,3,1,1,0,0,7,7,2,2,4,4,4,4,5,5,1,1,6,6,1,1,3,3,4,4,2,2,2,2,4,4,3,3,4,4,4,4,1,1,2,2,5,5,0,0,3,3,6,6,5,5,4,4,4,4,7,7,0,0,0,0,5,5,1,1,1,1,0,0,3,3,7,7,5,5,1,1,3,3,7,7,5,5,6,6,5,5,5,5,1,1,3,3,6,6,7,7,5,5,4,4,2,2,5,5,4,4,0,0,0,0,7,7,5,5,1,1,5,5,7,7,2,2,3,3,0,0,0,0,5,5,5,5,2,2,6,6,3,3,5,5,5,5,3,3,7,7,4,4,6,6,4,4,6,6,4,4,7,7,6,6,6,6,1,1,3,3,3,3,4,4,7,7,2,2,3,3,1,1,4,4,4,4,6,6,0,0,1,1,6,6,2,2,3,3,7,7,0,0,6,6,7,7,4,4,0,0,1,1,5,5,1,1,3,3,3,3,6,6,6,6,7,7,1,1,0,0,2,2,5,5,5,5,7,7,7,7,0,0,1,1,0,0,6,6,3,3,2,2,4,4,2,2,7,7,1,1,0,0,7,7,3,3,1,1,1,1,2,2,0,0,3,3,0,0,3,3,4,4,0,0,1,1,7,7,0,0,4,4,6,6,0,0,5,5,5,5,2,2,5,5,7,7,6,6,2,2,2,2,3,3,5,5,7,7,2,2,5,5,1,1,4,4,0,0,1,1,2,2,5,5,3,3,0,0,0,0,5,5,0,0,5,5,1,1,1,1,6,6,6,6,3,3,2,2,4,4,2,2,6,6,3,3,1,1,2,2,1,1,3,3,1,1,1,1,5,5,6,6,2,2,1,1,2,2,0,0,3,3,4,4,4,4,4,4,4,4,6,6,0,0,1,1,1,1,3,3,2,2,2,2,7,7,1,1,5,5,3,3,7,7,2,2,1,1,4,4,2,2,0,0,2,2,6,6,0,0,0,0,3,3,7,7,3,3,0,0,3,3,0,0,5,5,2,2,6,6,0,0,6,6,7,7,6,6,5,5,2,2,3,3,1,1,7,7,2,2,0,0,5,5,0,0,4,4,7,7,3,3,5,5,0,0,0,0,4,4,4,4,7,7,4,4,7,7,6,6,5,5,5,5,0,0,6,6,3,3,5,5,2,2,4,4,6,6,2,2,7,7,0,0,2,2,5,5,4,4,5,5,5,5,5,5,0,0,0,0,0,0,1,1,6,6,3,3,6,6,4,4,0,0,0,0,6,6,3,3,5,5,0,0,0,0,1,1,1,1,5,5,7,7,6,6,7,7,4,4,2,2,1,1,2,2,5,5,6,6,2,2,3,3,2,2,1,1,5,5,7,7,5,5,3,3,0,0,2,2,2,2,2,2,2,2,7,7,3,3,0,0,0,0,6,6,0,0,5,5,7,7,0,0,6,6,5,5,5,5,7,7,6,6,4,4,1,1,6,6,2,2,6,6,5,5,2,2,0,0,4,4,3,3,2,2,2,2,0,0,0,0,4,4,3,3,3,3,0,0,6,6,3,3,2,2,2,2,7,7,7,7,1,1,0,0,0,0,4,4,5,5,3,3,2,2,3,3,6,6,1,1,7,7,5,5,2,2,5,5,1,1,5,5,6,6,5,5,5,5,4,4,1,1,4,4,7,7,4,4,5,5,4,4,2,2,4,4,3,3,2,2,7,7,2,2,0,0,3,3,5,5,3,3,5,5,4,4,5,5,7,7,7,7,0,0,5,5,4,4,2,2,4,4,1,1,1,1,3,3,0,0,4,4,1,1,0,0,4,4,3,3,1,1,1,1,4,4,6,6,0,0,4,4,1,1,6,6,3,3,3,3,4,4,1,1,3,3,7,7,5,5,0,0,5,5,2,2,4,4,4,4,2,2,5,5,5,5,4,4,5,5,3,3,3,3,1,1,4,4,3,3,0,0,7,7,4,4,0,0,2,2,0,0,1,1,7,7,3,3,6,6,0,0,4,4,6,6,5,5,1,1,3,3,0,0,4,4,6,6,5,5,6,6,1,1,2,2,5,5,6,6,7,7,0,0,1,1,7,7,1,1,7,7,4,4,0,0,3,3,3,3,4,4,5,5,1,1,6,6,4,4,1,1,0,0,3,3,3,3,5,5,0,0,2,2,1,1,0,0,3,3,1,1,5,5,0,0,0,0,6,6,3,3,3,3,5,5,1,1,0,0,5,5,2,2,1,1,4,4,2,2,6,6,6,6,0,0,1,1,3,3,1,1,4,4,2,2,1,1,2,2,4,4,0,0,1,1,2,2,0,0,6,6,2,2,2,2,5,5,4,4,7,7,3,3,0,0,5,5,1,1,6,6,2,2,1,1,2,2,1,1,3,3,3,3,2,2,4,4,5,5,4,4,6,6,2,2,0,0,2,2,5,5,7,7,3,3,3,3,4,4,0,0,0,0,7,7,3,3,1,1,7,7,3,3,4,4,6,6,0,0,0,0,3,3,2,2,6,6,0,0,1,1,0,0,4,4,1,1,5,5,0,0,6,6,0,0,1,1,5,5,2,2,7,7,3,3,7,7,5,5,5,5,4,4,0,0,7,7,3,3,6,6,6,6,0,0,3,3,1,1,1,1,2,2,4,4,0,0,1,1,0,0,2,2,7,7,3,3,5,5,1,1,2,2,0,0,0,0,6,6,4,4,3,3,4,4,2,2,0,0,3,3,6,6,2,2,3,3,5,5,4,4,2,2,4,4,0,0,5,5,6,6,0,0,6,6,4,4,0,0,4,4,0,0,6,6,6,6,2,2,3,3,3,3,7,7,1,1,7,7,2,2,2,2,2,2,4,4,1,1,0,0,1,1,0,0,2,2,6,6,1,1,6,6,2,2,3,3,1,1,0,0,1,1,5,5,0,0,5,5,4,4,2,2,0,0,2,2,2,2,3,3,5,5,7,7,0,0,3,3,7,7,3,3,4,4,6,6,0,0,0,0,7,7,3,3,4,4,3,3,2,2,4,4,4,4,7,7,5,5,4,4,1,1,3,3,2,2,2,2,5,5,0,0,0,0,7,7,1,1,6,6,0,0,0,0,4,4,5,5,3,3,3,3,4,4,7,7,5,5,0,0,6,6,1,1,1,1,3,3,1,1,0,0,0,0,4,4,1,1,1,1,3,3,4,4,6,6,3,3,4,4,5,5,2,2,2,2,5,5,3,3,1,1,2,2,6,6,0,0,2,2,5,5,4,4,5,5,5,5,4,4,1,1,1,1,7,7,5,5,5,5,1,1,7,7,0,0,5,5,7,7,1,1,3,3,4,4,1,1,2,2,2,2,0,0,3,3,0,0,7,7,1,1,5,5,1,1,0,0,0,0,5,5,0,0,4,4,5,5,1,1,6,6,0,0,7,7,4,4,0,0,5,5,6,6,1,1,2,2,4,4,5,5,1,1,2,2,2,2,3,3,0,0,7,7,2,2,5,5,1,1,7,7,2,2,6,6,0,0,2,2,3,3,6,6,7,7,7,7,5,5,2,2,4,4,2,2,3,3,3,3,0,0,3,3,0,0,6,6,5,5,2,2,1,1,2,2,1,1,7,7,2,2,2,2,2,2,3,3,4,4,2,2,4,4,2,2,6,6,6,6,4,4,4,4,4,4,3,3,7,7,0,0,6,6,5,5,5,5,5,5,6,6,4,4,5,5,7,7,4,4,7,7,7,7,4,4,7,7,2,2,0,0,6,6,7,7,1,1,2,2,0,0,6,6,2,2,7,7,1,1,7,7,5,5,2,2,3,3,4,4,2,2,7,7,0,0,2,2,5,5,4,4,3,3,5,5,7,7,2,2,1,1,2,2,3,3,2,2,3,3,2,2,4,4,3,3,6,6,4,4,0,0,7,7,6,6,0,0,1,1,4,4,3,3,5,5,7,7,7,7,4,4,1,1,6,6,7,7,7,7,0,0,1,1,6,6,5,5,4,4,0,0,3,3,7,7,2,2,7,7,4,4,3,3,0,0,7,7,5,5,3,3,6,6,2,2,7,7,2,2,2,2,0,0,5,5,3,3,2,2,3,3,0,0,3,3,1,1,6,6,2,2,0,0,6,6,5,5,5,5,5,5,0,0,6,6,3,3,3,3,7,7,6,6,3,3,6,6,2,2,3,3,4,4,1,1,6,6,1,1,2,2,1,1,0,0,4,4,0,0,3,3,2,2,0,0,5,5,4,4,4,4,6,6,4,4,6,6,2,2,2,2,6,6,5,5,6,6,6,6,2,2,3,3,1,1,0,0,0,0,2,2,6,6,5,5,7,7,2,2,2,2,0,0,6,6,7,7,7,7,3,3,4,4,4,4,0,0,6,6,6,6,5,5,6,6,6,6,7,7,4,4,1,1,6,6,0,0,6,6,4,4,0,0,7,7,5,5,0,0,2,2,3,3,6,6,5,5,6,6,0,0,3,3,0,0,7,7,5,5,6,6,2,2,2,2,5,5,6,6,6,6,4,4,0,0,0,0,1,1,3,3,0,0,0,0,1,1,5,5,6,6,6,6,1,1,5,5,0,0,6,6,0,0,4,4,1,1,1,1,5,5,5,5,2,2,1,1,7,7,5,5,2,2,1,1,4,4,7,7,6,6,1,1,4,4,6,6,4,4,6,6,5,5,2,2,2,2,2,2,6,6,2,2,1,1,6,6,3,3,2,2,6,6,0,0,7,7,2,2,7,7,6,6,2,2,0,0,2,2,3,3,5,5,0,0,0,0,6,6,0,0,7,7,3,3,6,6,0,0,7,7,3,3,5,5,1,1,3,3,2,2,2,2,3,3,0,0,3,3,1,1,1,1,6,6,5,5,6,6,4,4,0,0,4,4,5,5,5,5,0,0,1,1,5,5,2,2,7,7,5,5,2,2,0,0,1,1,5,5,5,5,1,1,4,4,1,1,6,6,7,7,5,5,0,0,0,0,2,2,6,6,2,2,6,6,3,3,7,7,1,1,4,4,6,6,3,3,5,5,3,3,4,4,5,5,4,4,7,7,1,1,6,6,3,3,2,2,0,0,2,2,0,0,2,2,4,4,1,1,1,1,1,1,4,4,2,2,6,6,2,2,6,6,2,2,4,4,0,0,4,4,6,6,4,4,3,3,0,0,6,6,2,2,1,1,0,0,4,4,4,4,7,7,1,1,7,7,4,4,4,4,5,5,1,1,2,2,5,5,1,1,7,7,3,3,5,5,0,0,1,1,3,3,2,2,2,2,0,0,1,1,6,6,0,0,5,5,4,4,7,7,1,1,1,1,0,0,2,2,0,0,2,2,4,4,0,0,0,0,2,2,0,0,5,5,6,6,6,6,7,7,4,4,1,1,5,5,5,5,6,6,3,3,2,2,2,2,1,1,5,5,3,3,5,5,2,2,5,5,5,5,6,6,5,5,3,3,0,0,0,0,5,5,6,6,4,4,1,1,1,1,4,4,4,4,5,5,7,7,5,5,0,0,4,4,1,1,1,1,2,2,4,4,3,3,7,7,4,4,1,1,4,4,5,5,5,5,7,7,6,6,0,0,3,3,5,5,7,7,4,4,4,4,1,1,3,3,0,0,3,3,4,4,6,6,3,3,7,7,4,4,2,2,1,1,6,6,5,5,6,6,7,7,5,5,6,6,1,1,4,4,5,5,3,3,7,7,0,0,1,1,5,5,2,2,3,3,1,1,6,6,5,5,0,0,6,6,7,7,5,5,6,6,0,0,0,0,5,5,0,0,0,0,2,2,1,1,5,5,2,2,1,1,3,3,5,5,4,4,4,4,0,0,7,7,2,2,5,5,0,0,5,5,1,1,2,2,5,5,0,0,7,7,0,0,0,0,1,1,0,0,7,7,1,1,5,5,3,3,2,2,4,4,6,6,2,2,3,3,1,1,5,5,7,7,1,1,1,1,2,2,3,3,0,0,5,5,3,3,5,5,6,6,3,3,2,2,5,5,5,5,5,5,5,5,3,3,1,1,4,4,1,1,0,0,5,5,0,0,7,7,6,6,0,0,4,4,0,0,2,2,3,3,2,2,5,5,5,5,7,7,6,6,2,2,4,4,4,4,0,0,6,6,4,4,5,5,3,3,2,2,7,7,2,2,2,2,4,4,5,5,4,4,3,3,5,5,7,7,1,1,4,4,2,2,5,5,4,4,1,1,0,0,4,4,1,1,5,5,4,4,1,1,2,2,7,7,7,7,3,3,1,1,0,0,0,0,3,3,1,1,1,1,4,4,3,3,0,0,2,2,0,0,5,5,2,2,0,0,3,3,1,1,6,6,1,1,4,4,3,3,5,5,6,6,0,0,0,0,1,1,5,5,7,7,6,6,2,2,5,5,4,4,6,6,5,5,4,4,7,7,0,0,1,1,3,3,6,6,0,0,0,0,7,7,7,7,3,3,5,5,2,2,3,3,4,4,6,6,3,3,0,0,2,2,2,2,7,7,7,7,3,3,0,0,1,1,0,0,3,3,3,3,3,3,4,4,1,1,4,4,3,3,5,5,4,4,4,4,1,1,4,4,1,1,7,7,6,6,5,5,0,0,6,6,7,7,1,1,3,3,7,7,6,6,6,6,1,1,4,4,1,1,1,1,0,0,7,7,3,3,2,2,4,4,1,1,4,4,0,0,7,7,6,6,2,2,2,2,4,4,2,2,4,4,6,6,5,5,3,3,2,2,7,7,2,2,3,3,2,2,1,1,4,4,1,1,4,4,5,5,5,5,0,0,3,3,0,0,5,5,1,1,0,0,7,7,1,1,6,6,1,1,3,3,3,3,4,4,0,0,5,5,6,6,2,2,2,2,2,2,5,5,5,5,3,3,5,5,7,7,2,2,3,3,2,2,2,2,2,2,2,2,6,6,6,6,4,4,4,4,4,4,2,2,2,2,4,4,0,0,5,5,4,4,2,2,0,0,0,0,0,0,5,5,5,5,3,3,0,0,4,4,0,0,5,5,1,1,0,0,3,3,5,5,1,1,2,2,7,7,2,2,3,3,2,2,7,7,6,6,4,4,6,6,3,3,6,6,6,6,6,6,7,7,1,1,5,5,5,5,3,3,4,4,0,0,6,6,4,4,4,4,6,6,5,5,5,5,1,1,5,5,3,3,1,1,4,4,3,3,2,2,5,5,6,6,0,0,5,5,0,0,7,7,1,1,1,1,0,0,2,2,7,7,6,6,2,2,4,4,1,1,1,1,7,7,5,5,0,0,0,0,6,6,2,2,3,3,4,4,4,4,7,7,3,3,4,4,5,5,2,2,2,2,3,3,7,7,2,2,6,6,5,5,6,6,7,7,5,5,0,0,5,5,5,5,0,0,1,1,0,0,7,7,5,5,2,2,5,5,2,2,7,7,4,4,7,7,5,5,6,6,6,6,0,0,4,4,3,3,0,0,0,0,2,2,0,0,1,1,2,2,4,4,7,7,0,0,4,4,2,2,7,7,2,2,5,5,4,4,6,6,5,5,4,4,4,4,3,3,6,6,2,2,1,1,0,0,5,5,6,6,5,5,0,0,0,0,0,0,1,1,6,6,3,3,4,4,1,1,4,4,0,0,4,4,0,0,1,1,4,4,3,3,4,4,1,1,7,7,6,6,0,0,2,2,4,4,0,0,1,1,5,5,0,0,2,2,4,4,3,3,2,2,1,1,5,5,1,1,5,5,3,3,4,4,6,6,2,2,3,3,3,3,2,2,4,4,1,1,7,7,2,2,3,3,5,5,3,3,0,0,3,3,4,4,5,5,3,3,0,0,4,4,5,5,2,2,1,1,0,0,6,6,3,3,0,0,1,1,6,6,6,6,6,6,4,4,7,7,2,2,5,5,5,5,2,2,2,2,3,3,5,5,6,6,2,2,1,1,1,1,4,4,1,1,7,7,4,4,4,4,2,2,2,2,6,6,4,4,4,4,7,7,2,2,3,3,2,2,2,2,2,2,4,4,4,4,3,3,1,1,5,5,0,0,3,3,2,2,6,6,3,3,3,3,7,7,5,5,0,0,2,2,2,2,6,6,1,1,1,1,0,0,0,0,1,1,5,5,4,4,0,0,4,4,6,6,6,6,4,4,2,2,3,3,0,0,0,0,1,1,7,7,0,0,5,5,1,1,1,1,2,2,6,6,4,4,2,2,6,6,0,0,0,0,2,2,5,5,6,6,3,3,1,1,6,6,2,2,2,2,5,5,4,4,0,0,4,4,1,1,1,1,5,5,2,2,3,3,2,2,3,3,6,6,4,4,4,4,5,5,3,3,7,7,6,6,0,0,6,6,1,1,7,7,2,2,3,3,6,6,3,3,2,2,0,0,5,5,3,3,2,2,2,2,3,3,1,1,6,6,0,0,7,7,0,0,2,2,7,7,4,4,0,0,6,6,4,4,6,6,5,5,0,0,5,5,6,6,4,4,4,4,2,2,2,2,3,3,6,6,1,1,3,3,0,0,0,0,2,2,6,6,7,7,3,3,5,5,7,7,6,6,2,2,3,3,6,6,2,2,7,7,0,0,4,4,2,2,7,7,1,1,1,1,3,3,5,5,1,1,4,4,6,6,3,3,7,7,3,3,4,4,4,4,0,0,3,3,5,5,5,5,6,6,1,1,3,3,0,0,0,0,2,2,3,3,7,7,6,6,7,7,7,7,6,6,4,4,6,6,0,0,2,2,2,2,4,4,0,0,6,6,6,6,2,2,5,5,7,7,7,7,0,0,4,4,5,5,3,3,1,1,7,7,1,1,2,2,7,7,0,0,2,2,4,4,3,3,2,2,2,2,4,4,4,4,1,1,0,0,0,0,6,6,4,4,7,7,2,2,7,7,7,7,4,4,4,4,5,5,2,2,0,0,1,1,0,0,6,6,6,6,3,3,6,6,0,0,6,6,0,0,6,6,0,0,4,4,7,7,5,5,4,4,0,0,3,3,4,4,5,5,1,1,3,3,6,6,2,2,6,6,6,6,3,3,3,3,3,3,4,4,4,4,4,4,0,0,4,4,3,3,4,4,5,5,1,1,0,0,1,1,6,6,3,3,7,7,6,6,0,0,4,4,0,0,7,7,4,4,3,3,7,7,7,7,1,1,3,3,0,0,2,2,1,1,7,7,6,6,3,3,0,0,3,3,0,0,2,2,5,5,3,3,0,0,5,5,4,4,5,5,1,1,1,1,0,0,6,6,6,6,2,2,2,2,2,2,7,7,5,5,3,3,3,3,4,4,5,5,3,3,4,4,1,1,2,2,6,6,5,5,2,2,6,6,6,6,4,4,0,0,5,5,3,3,0,0,7,7,7,7,6,6,7,7,7,7,4,4,0,0,7,7,1,1,0,0,3,3,2,2,5,5,1,1,3,3,7,7,5,5,3,3,2,2,4,4,0,0,6,6,0,0,0,0,4,4,1,1,1,1,2,2,5,5,0,0,4,4,0,0,1,1,1,1,2,2,1,1,4,4,5,5,5,5,5,5,0,0,0,0,4,4,2,2,5,5,4,4,3,3,0,0,7,7,2,2,2,2,3,3,7,7,0,0,7,7,4,4,1,1,1,1,4,4,2,2,0,0,3,3,6,6,3,3,3,3,1,1,6,6,4,4,1,1,3,3,7,7,3,3,4,4,3,3,0,0,0,0,7,7,7,7,7,7,2,2,5,5,2,2,5,5,0,0,5,5,3,3,0,0,2,2,4,4,6,6,1,1,7,7,2,2,0,0,1,1,6,6,6,6,0,0,3,3,7,7,6,6,0,0,4,4,2,2,5,5,7,7,1,1,3,3,1,1,3,3,5,5,0,0,7,7,0,0,3,3,0,0,5,5,5,5,7,7,7,7,5,5,3,3,3,3,4,4,1,1,2,2,6,6,5,5,6,6,5,5,7,7,7,7,4,4,7,7,1,1,4,4,1,1,4,4,2,2,2,2,2,2,3,3,1,1,2,2,5,5,0,0,3,3,0,0,6,6,2,2,7,7,7,7,4,4,3,3,6,6,7,7,5,5,2,2,5,5,0,0,0,0,2,2,1,1,5,5,4,4,4,4,1,1,3,3,6,6,1,1,5,5,6,6,1,1,1,1,2,2,7,7,0,0,6,6,4,4,6,6,2,2,3,3,0,0,0,0,1,1,0,0,7,7,5,5,4,4,6,6,5,5,3,3,5,5,5,5,5,5,6,6,0,0,3,3,1,1,6,6,2,2,0,0,1,1,2,2,2,2,0,0,6,6,3,3,4,4,4,4,7,7,5,5,4,4,3,3,1,1,2,2,6,6,0,0,3,3,4,4,1,1,7,7,0,0,7,7,0,0,4,4,0,0,5,5,5,5,7,7,1,1,6,6,4,4,7,7,7,7,7,7,5,5,1,1,7,7,6,6,4,4,1,1,7,7,0,0,5,5,4,4,1,1,7,7,4,4,5,5,4,4,5,5,1,1,1,1,2,2,2,2,1,1,7,7,5,5,6,6,3,3,4,4,3,3,1,1,1,1,2,2,3,3,5,5,3,3,2,2,6,6,7,7,4,4,0,0,5,5,0,0,7,7,5,5,4,4,2,2,1,1,6,6,4,4,4,4,2,2,3,3,2,2,0,0,7,7,6,6,0,0,0,0,1,1,7,7,3,3,0,0,2,2,3,3,2,2,1,1,2,2,0,0,0,0,6,6,7,7,1,1,7,7,2,2,2,2,1,1,6,6,0,0,1,1,4,4,2,2,6,6,2,2,4,4,5,5,7,7,5,5,0,0,5,5,4,4,7,7,2,2,4,4,4,4,4,4,0,0,0,0,5,5,5,5,0,0,2,2,0,0,7,7,5,5,7,7,1,1,0,0,7,7,3,3,2,2,4,4,6,6,4,4,6,6,1,1,6,6,3,3,4,4,1,1,1,1,4,4,1,1,4,4,7,7,6,6,0,0,7,7,0,0,2,2,1,1,6,6,5,5,6,6,5,5,2,2,0,0,0,0,0,0,6,6,1,1,7,7,5,5,5,5,1,1,4,4,2,2,1,1,1,1,1,1,7,7,6,6,3,3,2,2,0,0,7,7,4,4,1,1,6,6,2,2,2,2,1,1,4,4,6,6,1,1,5,5,7,7,5,5,1,1,0,0,1,1,1,1,0,0,1,1,0,0,1,1,7,7,4,4,6,6,6,6,0,0,6,6,2,2,3,3,5,5,4,4,7,7,5,5,1,1,5,5,0,0,1,1,0,0,6,6,3,3,2,2,7,7,3,3,6,6,1,1,5,5,7,7,3,3,7,7,4,4,2,2,3,3,4,4,1,1,4,4,4,4,4,4,0,0,7,7,1,1,1,1,3,3,4,4,7,7,6,6,5,5,3,3,1,1,6,6,7,7,3,3,5,5,0,0,7,7,0,0,2,2,4,4,7,7,3,3,1,1,0,0,7,7,4,4,1,1,7,7,0,0,1,1,7,7,6,6,5,5,0,0,6,6,6,6,7,7,2,2,0,0,0,0,2,2,6,6,5,5,5,5,5,5,3,3,0,0,6,6,1,1,6,6,2,2,6,6,2,2,0,0,7,7,4,4,5,5,0,0,4,4,7,7,0,0,6,6,2,2,2,2,5,5,4,4,2,2,5,5,2,2,4,4,1,1,4,4,7,7,2,2,2,2,1,1,0,0,7,7,4,4,0,0,6,6,0,0,6,6,7,7,5,5,1,1,5,5,3,3,6,6,3,3,6,6,0,0,7,7,3,3,5,5,6,6,5,5,0,0,7,7,5,5,5,5,0,0,1,1,2,2,5,5,0,0,1,1,2,2,2,2,4,4,0,0,3,3,1,1,5,5,2,2,0,0,2,2,6,6,4,4,0,0,4,4,6,6,7,7,3,3,0,0,1,1,5,5,0,0,5,5,2,2,2,2,5,5,1,1,2,2,3,3,5,5,0,0,7,7,6,6,2,2,7,7,4,4,7,7,0,0,1,1,0,0,7,7,3,3,2,2,5,5,7,7,6,6,4,4,6,6,0,0,4,4,4,4,3,3,0,0,5,5,5,5,4,4,7,7,2,2,3,3,2,2,5,5,4,4,4,4,6,6,6,6,0,0,6,6,2,2,0,0,2,2,5,5,0,0,6,6,4,4,4,4,2,2,0,0,1,1,6,6,1,1,4,4,1,1,3,3,1,1,0,0,3,3,2,2,7,7,2,2,3,3,3,3,3,3,0,0,0,0,4,4,2,2,5,5,5,5,7,7,7,7,6,6,4,4,3,3,3,3,0,0,2,2,2,2,0,0,7,7,3,3,2,2,6,6,0,0,7,7,1,1,0,0,6,6,0,0,4,4,6,6,0,0,2,2,7,7,7,7,1,1,5,5,5,5,0,0,7,7,6,6,3,3,1,1,5,5,1,1,0,0,3,3,4,4,1,1,6,6,5,5,0,0,0,0,4,4,7,7,0,0,5,5,6,6,5,5,6,6,3,3,2,2,1,1,2,2,5,5,2,2,7,7,7,7,2,2,0,0,0,0,7,7,6,6,7,7,0,0,1,1,6,6,5,5,3,3,6,6,5,5,5,5,5,5,6,6,2,2,1,1,0,0,0,0,1,1,6,6,3,3,6,6,5,5,3,3,0,0,5,5,4,4,7,7,3,3,3,3,0,0,7,7,4,4,7,7,5,5,3,3,0,0,5,5,4,4,7,7,4,4,7,7,0,0,1,1,6,6,0,0,6,6,2,2,7,7,5,5,4,4,3,3,6,6,4,4,7,7,3,3,2,2,3,3,5,5,2,2,2,2,2,2,1,1,5,5,0,0,2,2,0,0,3,3,0,0,5,5,5,5,4,4,1,1,0,0,2,2,1,1,5,5,0,0,3,3,2,2,3,3,4,4,7,7,0,0,7,7,1,1,5,5,7,7,4,4,1,1,7,7,0,0,5,5,3,3,3,3,4,4,5,5,0,0,6,6,1,1,7,7,0,0,7,7,1,1,6,6,7,7,3,3,4,4,1,1,7,7,3,3,4,4,1,1,0,0,1,1,2,2,2,2,7,7,4,4,5,5,1,1,7,7,5,5,3,3,1,1,2,2,7,7,1,1,2,2,4,4,0,0,1,1,4,4,3,3,3,3,7,7,3,3,4,4,0,0,1,1,5,5,1,1,0,0,0,0,7,7,6,6,0,0,0,0,2,2,6,6,2,2,1,1,6,6,3,3,7,7,1,1,0,0,1,1,5,5,0,0,5,5,6,6,1,1,5,5,7,7,0,0,1,1,1,1,4,4,2,2,5,5,6,6,5,5,6,6,6,6,0,0,0,0,1,1,3,3,1,1,1,1,7,7,6,6,0,0,1,1,1,1,6,6,7,7,3,3,3,3,4,4,0,0,7,7,5,5,2,2,5,5,7,7,6,6,6,6,6,6,5,5,3,3,3,3,5,5,3,3,4,4,3,3,2,2,7,7,2,2,3,3,2,2,4,4,2,2,0,0,0,0,2,2,5,5,1,1,4,4,1,1,4,4,3,3,0,0,0,0,0,0,5,5,5,5,1,1,7,7,3,3,4,4,6,6,4,4,6,6,6,6,0,0,4,4,0,0,1,1,6,6,6,6,5,5,4,4,4,4,2,2,4,4,6,6,3,3,1,1,4,4,1,1,3,3,1,1,3,3,0,0,4,4,6,6,5,5,4,4,7,7,7,7,5,5,3,3,3,3,0,0,6,6,2,2,7,7,5,5,6,6,0,0,7,7,0,0,0,0,2,2,2,2,3,3,0,0,3,3,7,7,2,2,5,5,2,2,1,1,1,1,0,0,2,2,2,2,3,3,6,6,7,7,7,7,2,2,7,7,5,5,1,1,6,6,0,0,0,0,2,2,7,7,6,6,0,0,6,6,5,5,0,0,2,2,4,4,0,0,7,7,1,1,7,7,4,4,4,4,1,1,2,2,7,7,2,2,2,2,3,3,5,5,4,4,2,2,2,2,6,6,4,4,3,3,1,1,0,0,1,1,5,5,6,6,2,2,1,1,5,5,4,4,6,6,5,5,2,2,2,2,1,1,2,2,6,6,0,0,0,0,6,6,4,4,7,7,6,6,5,5,0,0,7,7,4,4,1,1,2,2,2,2,5,5,4,4,0,0,1,1,3,3,4,4,4,4,2,2,5,5,6,6,6,6,4,4,4,4,6,6,1,1,6,6,6,6,4,4,4,4,6,6,3,3,3,3,4,4,7,7,1,1,1,1,2,2,1,1,7,7,7,7,4,4,1,1,3,3,6,6,1,1,1,1,2,2,3,3,7,7,4,4,3,3,6,6,7,7,3,3,4,4,7,7,0,0,7,7,6,6,0,0,4,4,4,4,3,3,7,7,7,7,4,4,3,3,2,2,5,5,0,0,7,7,4,4,0,0,4,4,7,7,0,0,5,5,0,0,0,0,4,4,3,3,4,4,1,1,4,4,3,3,4,4,6,6,7,7,4,4,2,2,1,1,4,4,0,0,5,5,2,2,2,2,1,1,5,5,1,1,0,0,2,2,5,5,6,6,1,1,5,5,6,6,5,5,6,6,1,1,3,3,6,6,2,2,7,7,4,4,1,1,6,6,6,6,5,5,1,1,2,2,5,5,2,2,5,5,7,7,1,1,4,4,6,6,0,0,5,5,0,0,5,5,6,6,2,2,0,0,7,7,3,3,0,0,1,1,0,0,2,2,4,4,6,6,4,4,2,2,1,1,6,6,2,2,4,4,0,0,1,1,5,5,1,1,5,5,1,1,6,6,4,4,0,0,7,7,7,7,3,3,5,5,3,3,1,1,7,7,2,2,7,7,2,2,5,5,1,1,0,0,7,7,0,0,6,6,4,4,0,0,6,6,5,5,1,1,3,3,4,4,4,4,1,1,7,7,2,2,0,0,5,5,2,2,2,2,6,6,6,6,2,2,4,4,6,6,7,7,2,2,0,0,5,5,0,0,2,2,2,2,5,5,3,3,7,7,3,3,3,3,4,4,5,5,7,7,7,7,7,7,5,5,2,2,0,0,5,5,1,1,4,4,2,2,5,5,2,2,3,3,7,7,3,3,2,2,3,3,1,1,0,0,1,1,0,0,5,5,2,2,6,6,7,7,7,7,4,4,0,0,0,0,2,2,4,4,7,7,1,1,5,5,3,3,2,2,5,5,5,5,1,1,5,5,3,3,1,1,7,7,2,2,5,5,7,7,1,1,2,2,5,5,1,1,1,1,6,6,6,6,7,7,4,4,1,1,5,5,2,2,3,3,5,5,4,4,1,1,7,7,4,4,5,5,6,6,0,0,6,6,7,7,2,2,3,3,0,0,2,2,1,1,5,5,0,0,1,1,7,7,7,7,6,6,7,7,3,3,6,6,5,5,2,2,2,2,3,3,5,5,7,7,3,3,5,5,1,1,6,6,0,0,7,7,1,1,6,6,6,6,3,3,0,0,4,4,6,6,0,0,3,3,4,4,1,1,0,0,5,5,4,4,6,6,1,1,7,7,0,0,0,0,2,2,0,0,5,5,4,4,1,1,5,5,5,5,4,4,0,0,0,0,7,7,4,4,7,7,6,6,2,2,2,2,5,5,7,7,5,5,2,2,5,5,1,1,6,6,6,6,3,3,6,6,2,2,0,0,4,4,3,3,4,4,6,6,7,7,4,4,7,7,1,1,7,7,3,3,5,5,0,0,1,1,0,0,0,0,3,3,6,6,0,0,2,2,2,2,4,4,0,0,6,6,4,4,2,2,0,0,4,4,2,2,6,6,5,5,7,7,2,2,0,0,4,4,5,5,0,0,1,1,0,0,4,4,5,5,0,0,0,0,1,1,4,4,0,0,6,6,2,2,2,2,6,6,4,4,7,7,6,6,7,7,6,6,0,0,4,4,6,6,5,5,1,1,1,1,2,2,7,7,4,4,6,6,5,5,7,7,3,3,5,5,1,1,3,3,5,5,2,2,6,6,1,1,2,2,0,0,0,0,3,3,4,4,0,0,0,0,0,0,5,5,4,4,6,6,4,4,4,4,4,4,4,4,2,2,6,6,5,5,1,1,3,3,3,3,3,3,4,4,5,5,1,1,2,2,2,2,4,4,3,3,1,1,6,6,7,7,3,3,7,7,2,2,3,3,4,4,6,6,4,4,0,0,2,2,0,0,6,6,2,2,4,4,0,0,1,1,2,2,3,3,1,1,4,4,7,7,3,3,0,0,7,7,4,4,7,7,5,5,0,0,4,4,3,3,6,6,2,2,2,2,3,3,7,7,5,5,1,1,2,2,7,7,2,2,3,3,5,5,2,2,1,1,4,4,3,3,5,5,7,7,0,0,2,2,0,0,7,7,5,5,2,2,7,7,0,0,1,1,6,6,5,5,3,3,7,7,3,3,5,5,6,6,4,4,1,1,4,4,0,0,1,1,2,2,6,6,2,2,1,1,0,0,7,7,2,2,1,1,4,4,4,4,6,6,2,2,7,7,3,3,4,4,7,7,1,1,5,5,4,4,2,2,6,6,0,0,0,0,5,5,3,3,1,1,0,0,6,6,3,3,5,5,0,0,5,5,4,4,1,1,4,4,1,1,4,4,1,1,6,6,4,4,3,3,3,3,4,4,6,6,1,1,3,3,4,4,1,1,1,1,2,2,5,5,5,5,7,7,4,4,4,4,0,0,6,6,7,7,0,0,5,5,1,1,6,6,0,0,5,5,2,2,1,1,1,1,1,1,5,5,6,6,1,1,3,3,5,5,6,6,0,0,2,2,5,5,0,0,5,5,6,6,7,7,1,1,6,6,3,3,1,1,0,0,7,7,2,2,0,0,2,2,4,4,7,7,1,1,1,1,4,4,4,4,0,0,1,1,2,2,7,7,7,7,4,4,7,7,3,3,4,4,3,3,5,5,7,7,0,0,6,6,3,3,0,0,4,4,7,7,6,6,0,0,1,1,1,1,0,0,4,4,4,4,4,4,2,2,7,7,6,6,0,0,6,6,4,4,0,0,0,0,3,3,6,6,2,2,7,7,3,3,7,7,5,5,6,6,4,4,5,5,2,2,2,2,3,3,7,7,7,7,0,0,1,1,5,5,2,2,0,0,2,2,5,5,4,4,1,1,4,4,4,4,6,6,1,1,3,3,6,6,2,2,7,7,1,1,3,3,6,6,6,6,0,0,6,6,4,4,1,1,7,7,2,2,2,2,2,2,1,1,3,3,0,0,6,6,5,5,0,0,3,3,7,7,3,3,0,0,3,3,2,2,3,3,3,3,2,2,0,0,6,6,3,3,0,0,5,5,5,5,0,0,0,0,2,2,6,6,0,0,5,5,3,3,7,7,0,0,1,1,4,4,3,3,0,0,6,6,2,2,2,2,3,3,6,6,3,3,7,7,1,1,5,5,4,4,2,2,7,7,1,1,0,0,3,3,3,3,1,1,3,3,4,4,4,4,5,5,0,0,1,1,2,2,6,6,2,2,7,7,2,2,2,2,6,6,7,7,0,0,7,7,6,6,4,4,3,3,0,0,2,2,2,2,5,5,4,4,7,7,7,7,2,2,5,5,7,7,5,5,3,3,6,6,6,6,4,4,1,1,0,0,2,2,3,3,2,2,6,6,0,0,5,5,3,3,4,4,0,0,6,6,0,0,7,7,5,5,0,0,7,7,2,2,0,0,5,5,5,5,0,0,0,0,1,1,1,1,3,3,5,5,6,6,6,6,2,2,0,0,0,0,1,1,7,7,1,1,5,5,3,3,4,4,7,7,4,4,5,5,0,0,1,1,6,6,3,3,5,5,6,6,6,6,2,2,1,1,2,2,2,2,7,7,1,1,0,0,5,5,4,4,3,3,1,1,4,4,5,5,6,6,1,1,4,4,0,0,2,2,0,0,3,3,3,3,6,6,6,6,3,3,2,2,4,4,1,1,3,3,4,4,5,5,4,4,0,0,6,6,0,0,1,1,7,7,3,3,2,2,7,7,3,3,1,1,1,1,1,1,6,6,1,1,0,0,6,6,5,5,6,6,3,3,3,3,7,7,5,5,1,1,3,3,5,5,4,4,0,0,5,5,0,0,5,5,7,7,2,2,4,4,7,7,5,5,5,5,1,1,5,5,5,5,1,1,5,5,1,1,0,0,5,5,5,5,1,1,4,4,1,1,5,5,7,7,7,7,5,5,4,4,3,3,5,5,3,3,4,4,5,5,6,6,0,0,2,2,3,3,6,6,2,2,5,5,0,0,3,3,5,5,2,2,0,0,0,0,2,2,0,0,3,3,6,6,1,1,3,3,3,3,4,4,2,2,1,1,4,4,6,6,1,1,3,3,5,5,3,3,7,7,2,2,4,4,6,6,1,1,1,1,0,0,3,3,6,6,1,1,3,3,0,0,5,5,2,2,0,0,2,2,1,1,3,3,6,6,7,7,7,7,1,1,4,4,2,2,2,2,1,1,2,2,0,0,5,5,3,3,3,3,6,6,6,6,0,0,1,1,7,7,0,0,6,6,5,5,5,5,7,7,1,1,3,3,0,0,6,6,0,0,2,2,1,1,1,1,7,7,5,5,6,6,3,3,1,1,5,5,6,6,7,7,6,6,1,1,5,5,0,0,6,6,0,0,6,6,0,0,1,1,0,0,6,6,1,1,5,5,1,1,4,4,7,7,1,1,0,0,5,5,2,2,0,0,4,4,7,7,4,4,0,0,2,2,2,2,2,2,2,2,3,3,6,6,1,1,4,4,3,3,6,6,4,4,3,3,4,4,4,4,1,1,4,4,0,0,2,2,2,2,7,7,6,6,1,1,7,7,7,7,6,6,5,5,3,3,4,4,0,0,1,1,7,7,1,1,4,4,7,7,6,6,7,7,5,5,2,2,3,3,7,7,5,5,1,1,1,1,7,7,7,7,7,7,5,5,7,7,2,2,3,3,2,2,4,4,1,1,5,5,3,3,4,4,6,6,7,7,4,4,0,0,3,3,2,2,2,2,3,3,6,6,0,0,4,4,6,6,7,7,4,4,2,2,0,0,6,6,0,0,4,4,6,6,0,0,7,7,7,7,5,5,1,1,1,1,1,1,4,4,2,2,1,1,2,2,1,1,0,0,0,0,6,6,7,7,3,3,5,5,0,0,7,7,1,1,7,7,2,2,6,6,2,2,0,0,6,6,0,0,7,7,2,2,0,0,3,3,0,0,6,6,4,4,6,6,6,6,0,0,0,0,3,3,6,6,3,3,5,5,2,2,3,3,3,3,4,4,0,0,0,0,5,5,3,3,4,4,3,3,4,4,6,6,7,7,0,0,5,5,5,5,7,7,3,3,1,1,7,7,0,0,0,0,3,3,1,1,1,1,6,6,2,2,0,0,6,6,5,5,6,6,4,4,5,5,1,1,2,2,3,3,6,6,5,5,4,4,6,6,2,2,6,6,3,3,5,5,3,3,0,0,2,2,2,2,1,1,2,2,2,2,2,2,1,1,1,1,5,5,1,1,1,1,2,2,0,0,1,1,5,5,6,6,4,4,4,4,6,6,1,1,1,1,4,4,1,1,7,7,2,2,3,3,4,4,4,4,4,4,3,3,7,7,1,1,5,5,3,3,0,0,1,1,4,4,5,5,1,1,6,6,0,0,5,5,0,0,4,4,1,1,3,3,4,4,1,1,4,4,0,0,6,6,3,3,6,6,2,2,4,4,6,6,7,7,0,0,6,6,0,0,5,5,2,2,1,1,4,4,0,0,7,7,1,1,2,2,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,7,7,7,7,2,2,4,4,5,5,5,5,1,1,5,5,4,4,7,7,7,7,2,2,3,3,1,1,7,7,3,3,3,3,0,0,5,5,4,4,0,0,7,7,2,2,5,5,4,4,7,7,3,3,5,5,3,3,5,5,5,5,7,7,5,5,4,4,5,5,6,6,5,5,5,5,4,4,0,0,5,5,5,5,1,1,1,1,7,7,2,2,4,4,3,3,1,1,2,2,4,4,0,0,4,4,0,0,3,3,1,1,0,0,3,3,1,1,7,7,2,2,5,5,0,0,1,1,4,4,3,3,0,0,3,3,0,0,5,5,5,5,2,2,4,4,1,1,7,7,3,3,7,7,0,0,5,5,6,6,2,2,0,0,1,1,2,2,5,5,5,5,2,2,7,7,6,6,7,7,6,6,5,5,7,7,5,5,1,1,0,0,5,5,0,0,0,0,2,2,2,2,4,4,1,1,4,4,6,6,0,0,0,0,1,1,5,5,6,6,5,5,1,1,5,5,3,3,6,6,3,3,7,7,2,2,4,4,2,2,3,3,7,7,5,5,0,0,3,3,2,2,3,3,1,1,3,3,6,6,5,5,6,6,3,3,7,7,6,6,6,6,7,7,6,6,2,2,1,1,5,5,1,1,4,4,1,1,4,4,1,1,5,5,4,4,2,2,4,4,0,0,2,2,2,2,7,7,4,4,4,4,4,4,1,1,0,0,7,7,4,4,1,1,1,1,6,6,2,2,2,2,1,1,7,7,3,3,2,2,0,0,4,4,7,7,1,1,7,7,4,4,1,1,6,6,2,2,7,7,2,2,3,3,5,5,6,6,2,2,7,7,5,5,4,4,5,5,4,4,1,1,6,6,0,0,7,7,5,5,2,2,7,7,2,2,6,6,2,2,7,7,0,0,2,2,5,5,6,6,3,3,6,6,4,4,0,0,3,3,2,2,0,0,2,2,3,3,5,5,2,2,3,3,7,7,1,1,5,5,4,4,2,2,4,4,5,5,2,2,5,5,3,3,4,4,2,2,1,1,4,4,2,2,3,3,5,5,5,5,2,2,2,2,0,0,5,5,2,2,1,1,5,5,5,5,2,2,1,1,2,2,4,4,7,7,4,4,3,3,1,1,5,5,1,1,1,1,5,5,5,5,2,2,4,4,0,0,7,7,1,1,3,3,0,0,3,3,5,5,2,2,0,0,4,4,1,1,4,4,5,5,1,1,0,0,5,5,5,5,1,1,1,1,1,1,5,5,1,1,6,6,4,4,6,6,7,7,0,0,7,7,4,4,3,3,0,0,7,7,4,4,7,7,2,2,6,6,6,6,7,7,4,4,2,2,4,4,5,5,5,5,1,1,2,2,5,5,2,2,4,4,5,5,7,7,3,3,5,5,7,7,7,7,5,5,1,1,3,3,6,6,0,0,5,5,2,2,3,3,0,0,3,3,4,4,3,3,3,3,6,6,1,1,5,5,1,1,2,2,4,4,3,3,5,5,2,2,4,4,5,5,4,4,4,4,6,6,6,6,2,2,4,4,1,1,4,4,5,5,1,1,7,7,1,1,3,3,5,5,3,3,2,2,4,4,7,7,1,1,2,2,6,6,5,5,0,0,1,1,6,6,7,7,0,0,5,5,2,2,5,5,1,1,5,5,2,2,6,6,0,0,3,3,4,4,4,4,7,7,5,5,6,6,0,0,3,3,5,5,4,4,1,1,7,7,7,7,7,7,2,2,5,5,7,7,1,1,0,0,1,1,6,6,0,0,5,5,0,0,5,5,3,3,6,6,5,5,0,0,6,6,0,0,3,3,3,3,7,7,3,3,7,7,4,4,2,2,7,7,5,5,4,4,7,7,3,3,1,1,0,0,4,4,1,1,0,0,3,3,7,7,4,4,3,3,5,5,0,0,4,4,2,2,1,1,0,0,2,2,4,4,2,2,7,7,6,6,1,1,2,2,4,4,3,3,2,2,2,2,6,6,3,3,2,2,0,0,3,3,6,6,6,6,4,4,6,6,2,2,5,5,6,6,4,4,5,5,3,3,0,0,3,3,5,5,7,7,7,7,5,5,4,4,2,2,1,1,4,4,1,1,0,0,2,2,7,7,6,6,4,4,3,3,6,6,5,5,7,7,1,1,0,0,4,4,5,5,2,2,2,2,6,6,5,5,4,4,0,0,6,6,7,7,7,7,0,0,6,6,1,1,5,5,4,4,0,0,6,6,3,3,5,5,5,5,0,0,0,0,5,5,3,3,6,6,2,2,6,6,5,5,5,5,2,2,6,6,5,5,1,1,4,4,5,5,5,5,4,4,6,6,3,3,1,1,0,0,5,5,0,0,1,1,4,4,0,0,7,7,2,2,4,4,7,7,6,6,2,2,1,1,0,0,6,6,7,7,5,5,3,3,0,0,7,7,0,0,3,3,3,3,4,4,5,5,5,5,4,4,0,0,3,3,5,5,2,2,7,7,0,0,3,3,4,4,3,3,0,0,4,4,1,1,1,1,0,0,5,5,1,1,3,3,7,7,5,5,3,3,2,2,6,6,4,4,5,5,6,6,3,3,5,5,6,6,2,2,7,7,6,6,7,7,2,2,5,5,6,6,0,0,0,0,1,1,1,1,1,1,2,2,6,6,7,7,5,5,5,5,6,6,2,2,3,3,3,3,6,6,1,1,5,5,3,3,6,6,5,5,6,6,3,3,3,3,1,1,6,6,1,1,1,1,6,6,3,3,5,5,4,4,5,5,5,5,2,2,1,1,0,0,2,2,7,7,5,5,3,3,1,1,4,4,1,1,1,1,7,7,5,5,7,7,0,0,6,6,5,5,2,2,3,3,2,2,3,3,6,6,6,6,0,0,4,4,3,3,4,4,5,5,1,1,2,2,6,6,4,4,5,5,1,1,5,5,7,7,2,2,5,5,4,4,6,6,4,4,4,4,6,6,2,2,1,1,3,3,0,0,2,2,1,1,1,1,3,3,6,6,4,4,7,7,3,3,6,6,2,2,2,2,0,0,1,1,1,1,3,3,0,0,0,0,5,5,5,5,1,1,2,2,3,3,4,4,3,3,3,3,0,0,6,6,2,2,2,2,0,0,1,1,5,5,7,7,4,4,0,0,3,3,0,0,7,7,5,5,2,2,0,0,5,5,5,5,6,6,2,2,0,0,1,1,1,1,6,6,7,7,0,0,1,1,7,7,0,0,2,2,3,3,6,6,1,1,4,4,7,7,2,2,5,5,4,4,5,5,2,2,0,0,4,4,3,3,4,4,7,7,2,2,0,0,4,4,1,1,7,7,4,4,6,6,4,4,6,6,6,6,2,2,4,4,3,3,3,3,0,0,6,6,2,2,3,3,6,6,7,7,2,2,6,6,7,7,1,1,4,4,0,0,2,2,5,5,5,5,1,1,2,2,0,0,0,0,5,5,6,6,1,1,4,4,7,7,6,6,3,3,6,6,6,6,0,0,6,6,2,2,5,5,4,4,0,0,6,6,7,7,6,6,0,0,5,5,7,7,1,1,3,3,0,0,4,4,1,1,4,4,7,7,1,1,7,7,3,3,3,3,2,2,0,0,5,5,7,7,1,1,6,6,7,7,3,3,0,0,1,1,4,4,6,6,1,1,3,3,3,3,2,2,2,2,7,7,3,3,0,0,2,2,1,1,1,1,2,2,6,6,3,3,0,0,7,7,4,4,2,2,0,0,3,3,7,7,3,3,0,0,4,4,4,4,4,4,1,1,6,6,5,5,5,5,1,1,4,4,2,2,4,4,2,2,7,7,4,4,0,0,5,5,4,4,2,2,6,6,7,7,3,3,5,5,0,0,6,6,1,1,0,0,3,3,5,5,4,4,3,3,1,1,6,6,0,0,2,2,1,1,5,5,1,1,6,6,0,0,2,2,2,2,7,7,7,7,4,4,0,0,2,2,4,4,2,2,2,2,6,6,2,2,0,0,2,2,4,4,4,4,5,5,6,6,4,4,5,5,3,3,6,6,0,0,4,4,6,6,3,3,5,5,5,5,4,4,4,4,5,5,2,2,4,4,7,7,5,5,1,1,5,5,0,0,5,5,7,7,0,0,6,6,3,3,0,0,3,3,3,3,0,0,5,5,3,3,4,4,3,3,2,2,6,6,1,1,0,0,7,7,7,7,3,3,7,7,0,0,4,4,7,7,6,6,4,4,5,5,3,3,5,5,5,5,4,4,2,2,5,5,4,4,3,3,4,4,1,1,7,7,6,6,3,3,5,5,5,5,6,6,4,4,6,6,7,7,5,5,1,1,4,4,0,0,4,4,5,5,1,1,2,2,1,1,5,5,7,7,0,0,2,2,0,0,4,4,5,5,2,2,0,0,4,4,2,2,6,6,0,0,4,4,1,1,0,0,2,2,1,1,3,3,3,3,2,2,7,7,5,5,5,5,5,5,1,1,1,1,2,2,1,1,7,7,0,0,1,1,1,1,3,3,1,1,7,7,5,5,6,6,1,1,1,1,7,7,4,4,3,3,1,1,6,6,0,0,2,2,6,6,1,1,5,5,5,5,2,2,0,0,1,1,4,4,2,2,1,1,4,4,3,3,7,7,7,7,5,5,2,2,1,1,4,4,4,4,0,0,4,4,6,6,6,6,3,3,5,5,1,1,3,3,5,5,6,6,3,3,0,0,7,7,7,7,0,0,1,1,0,0,4,4,7,7,0,0,3,3,7,7,0,0,0,0,0,0,2,2,3,3,1,1,4,4,7,7,0,0,6,6,6,6,0,0,2,2,0,0,7,7,6,6,7,7,2,2,1,1,6,6,3,3,5,5,1,1,1,1,0,0,7,7,4,4,5,5,6,6,0,0,0,0,6,6,5,5,5,5,5,5,2,2,1,1,4,4,0,0,2,2,7,7,1,1,3,3,6,6,5,5,3,3,7,7,3,3,7,7,0,0,3,3,3,3,5,5,1,1,3,3,0,0,1,1,7,7,0,0,2,2,2,2,7,7,4,4,2,2,0,0,4,4,6,6,0,0,3,3,3,3,0,0,0,0,2,2,5,5,7,7,0,0,4,4,7,7,1,1,6,6,7,7,2,2,4,4,5,5,4,4,1,1,4,4,6,6,2,2,7,7,4,4,2,2,3,3,1,1,6,6,3,3,3,3,0,0,4,4,1,1,1,1,1,1,6,6,7,7,5,5,1,1,4,4,0,0,2,2,2,2,6,6,2,2,6,6,1,1,2,2,5,5,0,0,0,0,3,3,1,1,5,5,6,6,6,6,5,5,2,2,4,4,5,5,1,1,5,5,0,0,6,6,0,0,4,4,0,0,5,5,7,7,3,3,1,1,3,3,0,0,0,0,5,5,4,4,4,4,2,2,2,2,4,4,1,1,0,0,6,6,7,7,6,6,0,0,4,4,5,5,1,1,5,5,2,2,0,0,3,3,4,4,1,1,0,0,0,0,6,6,4,4,1,1,5,5,3,3,3,3,5,5,4,4,7,7,5,5,6,6,3,3,6,6,6,6,7,7,6,6,2,2,5,5,6,6,1,1,0,0,2,2,2,2,5,5,4,4,2,2,6,6,1,1,0,0,0,0,5,5,5,5,4,4,6,6,1,1,1,1,7,7,4,4,4,4,1,1,0,0,6,6,7,7,5,5,1,1,7,7,1,1,6,6,1,1,4,4,4,4,1,1,2,2,0,0,6,6,4,4,0,0,5,5,7,7,0,0,4,4,4,4,0,0,3,3,4,4,5,5,3,3,3,3,2,2,4,4,5,5,5,5,4,4,1,1,3,3,1,1,4,4,1,1,4,4,5,5,7,7,4,4,3,3,4,4,7,7,6,6,3,3,5,5,4,4,5,5,5,5,0,0,6,6,6,6,4,4,5,5,5,5,1,1,5,5,2,2,6,6,7,7,7,7,0,0,7,7,2,2,7,7,4,4,1,1,1,1,0,0,6,6,7,7,3,3,3,3,3,3,2,2,4,4,2,2,0,0,2,2,2,2,4,4,2,2,3,3,2,2,1,1,2,2,5,5,3,3,3,3,4,4,2,2,2,2,3,3,6,6,1,1,2,2,0,0,0,0,1,1,4,4,3,3,6,6,2,2,4,4,6,6,3,3,1,1,5,5,3,3,2,2,6,6,1,1,0,0,1,1,6,6,4,4,7,7,0,0,6,6,3,3,7,7,3,3,2,2,6,6,1,1,0,0,2,2,3,3,5,5,1,1,2,2,4,4,7,7,6,6,0,0,3,3,0,0,0,0,0,0,0,0,4,4,3,3,6,6,1,1,1,1,2,2,1,1,0,0,6,6,7,7,4,4,6,6,6,6,3,3,0,0,1,1,5,5,1,1,1,1,1,1,0,0,7,7,3,3,4,4,0,0,5,5,3,3,2,2,4,4,2,2,2,2,3,3,6,6,6,6,2,2,4,4,7,7,2,2,0,0,0,0,4,4,2,2,7,7,4,4,5,5,5,5,1,1,1,1,2,2,1,1,2,2,7,7,0,0,6,6,1,1,7,7,6,6,1,1,5,5,4,4,6,6,0,0,7,7,3,3,3,3,3,3,2,2,1,1,6,6,4,4,6,6,7,7,1,1,7,7,1,1,0,0,5,5,3,3,0,0,4,4,7,7,1,1,4,4,2,2,3,3,6,6,4,4,1,1,5,5,3,3,7,7,5,5,2,2,2,2,6,6,1,1,3,3,6,6,0,0,7,7,0,0,5,5,0,0,1,1,7,7,2,2,2,2,3,3,6,6,2,2,5,5,1,1,6,6,1,1,3,3,4,4,4,4,1,1,2,2,3,3,3,3,1,1,4,4,7,7,6,6,6,6,4,4,0,0,4,4,4,4,5,5,6,6,1,1,7,7,3,3,4,4,2,2,3,3,6,6,2,2,5,5,3,3,2,2,2,2,3,3,1,1,3,3,2,2,1,1,1,1,5,5,0,0,4,4,0,0,2,2,0,0,0,0,1,1,0,0,7,7,0,0,7,7,3,3,3,3,1,1,2,2,4,4,0,0,1,1,6,6,6,6,3,3,4,4,0,0,2,2,6,6,0,0,6,6,6,6,5,5,0,0,6,6,0,0,4,4,1,1,5,5,1,1,1,1,7,7,4,4,6,6,2,2,2,2,1,1,6,6,4,4,2,2,4,4,6,6,3,3,3,3,2,2,5,5,4,4,5,5,3,3,5,5,4,4,3,3,6,6,0,0,6,6,1,1,0,0,5,5,4,4,7,7,2,2,4,4,0,0,3,3,1,1,2,2,6,6,7,7,6,6,3,3,7,7,2,2,0,0,2,2,6,6,0,0,6,6,0,0,0,0,1,1,5,5,4,4,4,4,3,3,0,0,2,2,0,0,1,1,1,1,4,4,1,1,2,2,1,1,0,0,5,5,7,7,6,6,2,2,2,2,5,5,6,6,2,2,7,7,5,5,5,5,3,3,5,5,6,6,5,5,2,2,5,5,4,4,4,4,5,5,6,6,7,7,7,7,1,1,3,3,7,7,0,0,4,4,2,2,4,4,5,5,1,1,7,7,2,2,6,6,4,4,0,0,0,0,3,3,2,2,2,2,2,2,3,3,6,6,3,3,3,3,1,1,5,5,6,6,4,4,3,3,0,0,0,0,0,0,1,1,0,0,1,1,1,1,2,2,5,5,7,7,1,1,2,2,4,4,0,0,6,6,7,7,1,1,0,0,5,5,6,6,7,7,2,2,4,4,0,0,3,3,0,0,7,7,5,5,0,0,4,4,5,5,1,1,1,1,1,1,3,3,4,4,6,6,1,1,2,2,2,2,3,3,1,1,7,7,1,1,3,3,4,4,2,2,2,2,6,6,2,2,0,0,5,5,0,0,4,4,7,7,0,0,6,6,4,4,3,3,2,2,7,7,1,1,2,2,7,7,1,1,5,5,1,1,0,0,6,6,4,4,6,6,5,5,7,7,6,6,1,1,2,2,7,7,3,3,1,1,0,0,0,0,1,1,6,6,7,7,5,5,0,0,4,4,6,6,2,2,3,3,7,7,1,1,4,4,4,4,7,7,2,2,4,4,5,5,6,6,2,2,4,4,3,3,0,0,2,2,5,5,3,3,0,0,7,7,3,3,1,1,2,2,7,7,4,4,6,6,2,2,0,0,0,0,6,6,7,7,6,6,2,2,0,0,2,2,3,3,1,1,7,7,3,3,0,0,4,4,0,0,6,6,0,0,0,0,4,4,4,4,1,1,1,1,3,3,1,1,6,6,7,7,1,1,6,6,4,4,2,2,5,5,3,3,4,4,3,3,0,0,1,1,0,0,7,7,5,5,3,3,3,3,3,3,3,3,3,3,0,0,2,2,6,6,5,5,6,6,4,4,4,4,0,0,5,5,6,6,2,2,7,7,5,5,7,7,1,1,1,1,5,5,4,4,1,1,6,6,7,7,0,0,0,0,7,7,5,5,3,3,0,0,2,2,7,7,3,3,5,5,2,2,2,2,7,7,7,7,1,1,2,2,4,4,7,7,1,1,3,3,4,4,1,1,6,6,1,1,5,5,1,1,4,4,2,2,7,7,0,0,2,2,3,3,3,3,3,3,4,4,5,5,1,1,1,1,0,0,4,4,1,1,7,7,1,1,3,3,6,6,2,2,4,4,5,5,2,2,0,0,0,0,5,5,7,7,2,2,5,5,2,2,7,7,4,4,0,0,7,7,3,3,2,2,3,3,3,3,4,4,0,0,1,1,3,3,4,4,3,3,0,0,1,1,1,1,7,7,5,5,4,4,1,1,1,1,4,4,2,2,7,7,1,1,0,0,0,0,0,0,4,4,0,0,5,5,1,1,1,1,2,2,5,5,1,1,1,1,2,2,7,7,5,5,6,6,2,2,2,2,5,5,4,4,1,1,0,0,4,4,4,4,2,2,2,2,4,4,3,3,6,6,7,7,0,0,3,3,2,2,5,5,1,1,1,1,7,7,1,1,1,1,1,1,1,1,1,1,6,6,4,4,5,5,1,1,6,6,1,1,0,0,1,1,4,4,2,2,2,2,2,2,2,2,6,6,5,5,2,2,0,0,4,4,2,2,3,3,5,5,4,4,1,1,0,0,2,2,2,2,4,4,0,0,4,4,6,6,4,4,3,3,1,1,5,5,7,7,2,2,0,0,6,6,5,5,2,2,2,2,7,7,4,4,3,3,1,1,7,7,1,1,2,2,6,6,5,5,6,6,4,4,0,0,5,5,2,2,7,7,1,1,6,6,2,2,4,4,7,7,5,5,2,2,1,1,1,1,6,6,3,3,6,6,1,1,5,5,5,5,0,0,5,5,4,4,5,5,1,1,2,2,6,6,6,6,3,3,3,3,2,2,4,4,0,0,2,2,0,0,5,5,1,1,2,2,2,2,1,1,7,7,6,6,4,4,3,3,3,3,3,3,5,5,0,0,0,0,2,2,7,7,6,6,1,1,4,4,5,5,3,3,7,7,2,2,4,4,2,2,4,4,5,5,1,1,0,0,7,7,4,4,5,5,0,0,1,1,7,7,2,2,5,5,1,1,1,1,3,3,5,5,7,7,3,3,2,2,6,6,7,7,0,0,6,6,6,6,3,3,6,6,1,1,6,6,6,6,6,6,5,5,3,3,2,2,4,4,7,7,0,0,0,0,5,5,3,3,5,5,5,5,0,0,3,3,0,0,0,0,6,6,4,4,1,1,5,5,7,7,6,6,4,4,3,3,5,5,1,1,6,6,5,5,1,1,7,7,2,2,0,0,7,7,2,2,7,7,4,4,0,0,1,1,1,1,7,7,4,4,4,4,4,4,6,6,0,0,0,0,4,4,1,1,2,2,0,0,4,4,5,5,2,2,2,2,1,1,4,4,1,1,6,6,1,1,7,7,7,7,5,5,0,0,6,6,0,0,0,0,6,6,2,2,4,4,1,1,2,2,2,2,4,4,6,6,2,2,6,6,1,1,7,7,0,0,1,1,7,7,4,4,3,3,3,3,7,7,4,4,0,0,1,1,1,1,6,6,6,6,7,7,1,1,2,2,7,7,5,5,2,2,6,6,6,6,7,7,1,1,4,4,3,3,2,2,4,4,3,3,5,5,5,5,6,6,0,0,4,4,3,3,5,5,1,1,5,5,2,2,2,2,5,5,7,7,6,6,4,4,6,6,3,3,2,2,3,3,6,6,2,2,4,4,0,0,2,2,5,5,6,6,2,2,6,6,4,4,5,5,2,2,5,5,7,7,1,1,3,3,4,4,3,3,6,6,0,0,3,3,7,7,6,6,5,5,2,2,0,0,7,7,0,0,6,6,5,5,1,1,4,4,7,7,6,6,7,7,2,2,3,3,6,6,5,5,7,7,6,6,4,4,7,7,0,0,0,0,3,3,7,7,4,4,7,7,2,2,4,4,2,2,6,6,4,4,1,1,0,0,3,3,4,4,5,5,1,1,0,0,0,0,5,5,4,4,7,7,4,4,5,5,0,0,1,1,4,4,0,0,5,5,0,0,0,0,0,0,2,2,0,0,5,5,6,6,3,3,1,1,1,1,5,5,0,0,0,0,2,2,2,2,7,7,1,1,0,0,2,2,2,2,2,2,6,6,4,4,1,1,7,7,3,3,7,7,7,7,2,2,5,5,7,7,6,6,3,3,2,2,1,1,0,0,1,1,2,2,2,2,7,7,2,2,1,1,0,0,5,5,6,6,0,0,7,7,4,4,3,3,4,4,2,2,5,5,1,1,5,5,2,2,2,2,0,0,0,0,5,5,3,3,1,1,6,6,0,0,6,6,0,0,6,6,1,1,7,7,2,2,3,3,5,5,4,4,1,1,1,1,7,7,4,4,7,7,4,4,6,6,2,2,3,3,7,7,2,2,2,2,0,0,5,5,2,2,4,4,5,5,6,6,1,1,5,5,3,3,4,4,1,1,4,4,5,5,7,7,1,1,7,7,0,0,1,1,1,1,6,6,0,0,7,7,0,0,0,0,0,0,4,4,4,4,1,1,6,6,0,0,0,0,3,3,6,6,2,2,3,3,2,2,2,2,6,6,2,2,6,6,0,0,5,5,0,0,4,4,0,0,3,3,3,3,4,4,2,2,3,3,3,3,4,4,7,7,4,4,5,5,5,5,3,3,7,7,2,2,1,1,2,2,4,4,2,2,2,2,1,1,2,2,3,3,0,0,1,1,7,7,3,3,7,7,7,7,4,4,5,5,5,5,5,5,6,6,5,5,4,4,1,1,2,2,1,1,7,7,0,0,0,0,1,1,6,6,5,5,4,4,0,0,7,7,7,7,4,4,0,0,6,6,2,2,1,1,5,5,4,4,6,6,0,0,0,0,4,4,5,5,0,0,0,0,4,4,2,2,2,2,0,0,7,7,7,7,1,1,0,0,6,6,0,0,4,4,2,2,5,5,4,4,1,1,0,0,3,3,3,3,4,4,6,6,6,6,0,0,4,4,1,1,3,3,5,5,5,5,6,6,2,2,7,7,5,5,3,3,7,7,6,6,5,5,0,0,2,2,4,4,1,1,5,5,2,2,2,2,5,5,1,1,3,3,5,5,5,5,6,6,7,7,6,6,4,4,5,5,2,2,3,3,6,6,4,4,5,5,1,1,7,7,3,3,2,2,7,7,5,5,6,6,0,0,0,0,7,7,2,2,6,6,7,7,3,3,5,5,3,3,0,0,0,0,1,1,3,3,4,4,2,2,6,6,3,3,7,7,2,2,4,4,7,7,2,2,4,4,1,1,5,5,3,3,3,3,1,1,1,1,6,6,1,1,0,0,4,4,6,6,0,0,0,0,1,1,7,7,2,2,2,2,2,2,1,1,6,6,2,2,5,5,1,1,2,2,0,0,3,3,2,2,2,2,1,1,5,5,6,6,2,2,6,6,4,4,0,0,0,0,0,0,7,7,4,4,2,2,6,6,5,5,5,5,2,2,2,2,6,6,1,1,4,4,0,0,0,0,2,2,7,7,0,0,6,6,4,4,4,4,7,7,3,3,2,2,6,6,0,0,5,5,5,5,0,0,2,2,4,4,2,2,1,1,0,0,5,5,7,7,1,1,0,0,7,7,2,2,0,0,3,3,1,1,4,4,6,6,7,7,3,3,7,7,4,4,7,7,2,2,5,5,0,0,6,6,2,2,7,7,1,1,1,1,3,3,0,0,2,2,7,7,5,5,2,2,2,2,6,6,0,0,2,2,2,2,3,3,1,1,3,3,5,5,2,2,4,4,7,7,1,1,2,2,0,0,5,5,6,6,6,6,7,7,6,6,6,6,5,5,3,3,1,1,5,5,1,1,0,0,6,6,1,1,6,6,4,4,0,0,7,7,6,6,0,0,2,2,3,3,7,7,1,1,5,5,4,4,2,2,4,4,2,2,2,2,4,4,3,3,6,6,0,0,2,2,5,5,7,7,5,5,0,0,3,3,7,7,4,4,3,3,6,6,4,4,3,3,7,7,2,2,1,1,4,4,0,0,2,2,3,3,3,3,0,0,6,6,7,7,6,6,1,1,5,5,3,3,0,0,0,0,7,7,7,7,1,1,2,2,1,1,0,0,3,3,4,4,1,1,5,5,4,4,1,1,5,5,7,7,5,5,6,6,5,5,6,6,7,7,2,2,7,7,5,5,6,6,0,0,6,6,1,1,4,4,2,2,7,7,2,2,6,6,4,4,2,2,5,5,7,7,5,5,0,0,5,5,0,0,6,6,1,1,0,0,7,7,1,1,5,5,2,2,2,2,4,4,6,6,0,0,1,1,6,6,4,4,3,3,7,7,0,0,5,5,7,7,5,5,4,4,7,7,3,3,1,1,7,7,5,5,3,3,6,6,7,7,2,2,6,6,2,2,3,3,3,3,3,3,1,1,7,7,5,5,6,6,2,2,5,5,3,3,2,2,2,2,2,2,4,4,6,6,1,1,1,1,0,0,6,6,0,0,4,4,7,7,5,5,2,2,1,1,6,6,2,2,4,4,5,5,3,3,7,7,3,3,3,3,1,1,1,1,7,7,7,7,2,2,5,5,1,1,3,3,0,0,6,6,6,6,1,1,3,3,1,1,2,2,2,2,6,6,1,1,2,2,4,4,1,1,5,5,0,0,2,2,3,3,5,5,2,2,1,1,1,1,3,3,3,3,4,4,2,2,1,1,3,3,6,6,7,7,1,1,4,4,4,4,1,1,5,5,6,6,2,2,2,2,2,2,6,6,3,3,1,1,3,3,2,2,6,6,3,3,1,1,1,1,7,7,2,2,7,7,3,3,2,2,2,2,3,3,0,0,5,5,3,3,0,0,1,1,6,6,0,0,4,4,4,4,3,3,4,4,5,5,2,2,2,2,3,3,4,4,7,7,5,5,7,7,6,6,6,6,0,0,1,1,5,5,7,7,6,6,1,1,7,7,6,6,4,4,2,2,7,7,5,5,3,3,4,4,7,7,3,3,6,6,3,3,6,6,3,3,6,6,2,2,7,7,5,5,4,4,6,6,3,3,7,7,1,1,1,1,7,7,5,5,2,2,5,5,0,0,6,6,2,2,1,1,4,4,5,5,3,3,7,7,3,3,6,6,7,7,0,0,5,5,5,5,3,3,2,2,2,2,1,1,7,7,7,7,2,2,5,5,4,4,7,7,5,5,4,4,0,0,4,4,7,7,0,0,5,5,0,0,1,1,2,2,0,0,4,4,2,2,2,2,0,0,7,7,3,3,4,4,4,4,6,6,4,4,1,1,5,5,6,6,6,6,2,2,4,4,2,2,3,3,3,3,6,6,5,5,1,1,6,6,5,5,4,4,4,4,1,1,1,1,1,1,4,4,0,0,0,0,3,3,4,4,0,0,0,0,5,5,3,3,6,6,1,1,7,7,7,7,4,4,6,6,3,3,1,1,4,4,5,5,5,5,6,6,5,5,5,5,1,1,1,1,0,0,4,4,3,3,6,6,0,0,4,4,7,7,7,7,5,5,4,4,7,7,6,6,1,1,3,3,3,3,4,4,0,0,2,2,1,1,1,1,1,1,6,6,0,0,2,2,1,1,4,4,2,2,3,3,5,5,4,4,2,2,0,0,5,5,3,3,4,4,2,2,7,7,0,0,7,7,1,1,2,2,0,0,3,3,0,0,6,6,6,6,6,6,2,2,6,6,0,0,4,4,7,7,6,6,2,2,1,1,0,0,5,5,2,2,2,2,3,3,4,4,2,2,7,7,3,3,5,5,0,0,7,7,2,2,3,3,2,2,4,4,2,2,0,0,4,4,2,2,5,5,4,4,6,6,1,1,0,0,1,1,7,7,6,6,6,6,2,2,4,4,1,1,4,4,4,4,6,6,2,2,3,3,6,6,2,2,6,6,1,1,7,7,1,1,0,0,3,3,5,5,3,3,6,6,7,7,2,2,2,2,3,3,5,5,7,7,3,3,2,2,1,1,5,5,1,1,5,5,2,2,6,6,5,5,0,0,4,4,0,0,2,2,2,2,2,2,4,4,5,5,1,1,5,5,7,7,4,4,7,7,0,0,0,0,0,0,4,4,6,6,0,0,0,0,3,3,7,7,7,7,4,4,7,7,6,6,1,1,0,0,6,6,3,3,6,6,7,7,1,1,2,2,6,6,6,6,6,6,2,2,0,0,4,4,0,0,7,7,5,5,5,5,0,0,4,4,0,0,0,0,6,6,2,2,7,7,5,5,7,7,5,5,4,4,5,5,4,4,5,5,3,3,3,3,2,2,5,5,7,7,3,3,2,2,3,3,6,6,0,0,1,1,6,6,6,6,0,0,4,4,0,0,5,5,5,5,0,0,7,7,5,5,0,0,4,4,0,0,1,1,0,0,6,6,5,5,7,7,7,7,1,1,1,1,2,2,5,5,3,3,2,2,1,1,4,4,2,2,0,0,7,7,1,1,7,7,4,4,7,7,3,3,1,1,1,1,7,7,1,1,1,1,6,6,2,2,7,7,0,0,1,1,4,4,2,2,2,2,0,0,4,4,2,2,0,0,2,2,2,2,6,6,6,6,2,2,6,6,0,0,4,4,5,5,4,4,0,0,5,5,2,2,0,0,2,2,4,4,0,0,7,7,3,3,2,2,1,1,0,0,4,4,7,7,0,0,3,3,6,6,4,4,2,2,0,0,0,0,5,5,1,1,1,1,5,5,4,4,6,6,2,2,3,3,3,3,3,3,1,1,6,6,2,2,0,0,4,4,3,3,4,4,1,1,4,4,4,4,4,4,3,3,4,4,7,7,1,1,6,6,4,4,5,5,5,5,2,2,6,6,3,3,2,2,3,3,4,4,0,0,7,7,0,0,6,6,2,2,1,1,0,0,5,5,6,6,0,0,0,0,5,5,4,4,3,3,6,6,1,1,6,6,4,4,5,5,4,4,5,5,1,1,2,2,1,1,4,4,1,1,2,2,3,3,0,0,0,0,5,5,6,6,3,3,4,4,4,4,3,3,1,1,7,7,3,3,3,3,7,7,4,4,3,3,1,1,5,5,2,2,6,6,1,1,2,2,2,2,6,6,2,2,0,0,0,0,0,0,0,0,3,3,2,2,1,1,2,2,1,1,2,2,7,7,1,1,3,3,1,1,0,0,1,1,1,1,5,5,3,3,2,2,2,2,4,4,0,0,1,1,7,7,3,3,7,7,6,6,1,1,6,6,3,3,6,6,1,1,6,6,7,7,0,0,2,2,0,0,6,6,3,3,4,4,6,6,1,1,1,1,6,6,0,0,6,6,5,5,0,0,5,5,2,2,4,4,2,2,4,4,1,1,3,3,1,1,0,0,1,1,6,6,0,0,2,2,1,1,0,0,1,1,3,3,4,4,6,6,0,0,4,4,1,1,1,1,2,2,2,2,1,1,2,2,4,4,4,4,2,2,3,3,0,0,6,6,3,3,1,1,0,0,3,3,4,4,4,4,5,5,0,0,0,0,6,6,1,1,7,7,2,2,4,4,6,6,7,7,6,6,0,0,3,3,6,6,5,5,4,4,2,2,4,4,6,6,2,2,3,3,6,6,4,4,7,7,6,6,2,2,6,6,6,6,7,7,5,5,7,7,7,7,7,7,5,5,4,4,3,3,7,7,1,1,5,5,7,7,3,3,7,7,0,0,7,7,4,4,3,3,5,5,3,3,2,2,5,5,6,6,6,6,0,0,0,0,0,0,3,3,0,0,5,5,2,2,1,1,4,4,5,5,3,3,7,7,5,5,5,5,7,7,1,1,2,2,2,2,3,3,1,1,3,3,4,4,7,7,3,3,5,5,1,1,0,0,4,4,0,0,6,6,7,7,3,3,2,2,0,0,5,5,2,2,1,1,0,0,6,6,2,2,0,0,4,4,5,5,3,3,5,5,0,0,2,2,4,4,3,3,3,3,5,5,0,0,4,4,4,4,4,4,2,2,3,3,2,2,2,2,0,0,6,6,0,0,7,7,0,0,0,0,4,4,2,2,6,6,3,3,2,2,4,4,2,2,6,6,2,2,7,7,5,5,5,5,1,1,1,1,0,0,1,1,0,0,4,4,5,5,1,1,3,3,1,1,2,2,5,5,7,7,1,1,6,6,0,0,7,7,2,2,0,0,6,6,6,6,5,5,2,2,1,1,2,2,1,1,0,0,5,5,7,7,2,2,7,7,1,1,6,6,2,2,3,3,6,6,4,4,4,4,7,7,0,0,0,0,2,2,1,1,4,4,1,1,2,2,1,1,1,1,1,1,7,7,2,2,4,4,1,1,0,0,0,0,2,2,3,3,1,1,5,5,5,5,3,3,0,0,2,2,6,6,6,6,0,0,4,4,0,0,4,4,3,3,3,3,0,0,6,6,7,7,0,0,4,4,5,5,1,1,3,3,6,6,4,4,4,4,4,4,1,1,0,0,1,1,7,7,2,2,3,3,3,3,4,4,6,6,0,0,0,0,5,5,4,4,7,7,0,0,7,7,0,0,5,5,0,0,6,6,0,0,0,0,5,5,3,3,5,5,2,2,7,7,5,5,6,6,6,6,4,4,1,1,0,0,2,2,2,2,4,4,2,2,1,1,5,5,2,2,5,5,3,3,5,5,6,6,2,2,2,2,2,2,2,2,4,4,0,0,5,5,5,5,4,4,2,2,2,2,1,1,5,5,7,7,6,6,6,6,6,6,3,3,6,6,7,7,1,1,7,7,7,7,5,5,0,0,4,4,3,3,2,2,4,4,3,3,4,4,2,2,1,1,6,6,4,4,4,4,7,7,6,6,5,5,0,0,7,7,7,7,4,4,4,4,1,1,4,4,5,5,1,1,6,6,5,5,1,1,1,1,2,2,0,0,3,3,2,2,4,4,0,0,3,3,6,6,4,4,6,6,6,6,5,5,6,6,3,3,5,5,4,4,5,5,4,4,5,5,3,3,6,6,0,0,5,5,0,0,0,0,0,0,5,5,2,2,1,1,2,2,1,1,1,1,0,0,3,3,4,4,7,7,4,4,2,2,2,2,6,6,2,2,6,6,6,6,7,7,0,0,4,4,1,1,2,2,5,5,5,5,2,2,2,2,5,5,0,0,2,2,0,0,3,3,3,3,3,3,7,7,1,1,0,0,3,3,3,3,5,5,4,4,4,4,6,6,5,5,5,5,0,0,3,3,4,4,3,3,3,3,7,7,3,3,0,0,7,7,2,2,6,6,0,0,3,3,5,5,1,1,4,4,5,5,1,1,6,6,6,6,2,2,2,2,5,5,0,0,4,4,4,4,7,7,2,2,2,2,7,7,4,4,1,1,6,6,5,5,1,1,0,0,6,6,0,0,3,3,4,4,1,1,0,0,0,0,0,0,0,0,4,4,2,2,1,1,1,1,2,2,3,3,6,6,2,2,3,3,5,5,7,7,1,1,3,3,0,0,0,0,5,5,4,4,7,7,5,5,4,4,3,3,7,7,6,6,0,0,4,4,5,5,3,3,4,4,3,3,3,3,5,5,4,4,3,3,1,1,5,5,5,5,5,5,7,7,6,6,1,1,5,5,4,4,2,2,4,4,2,2,6,6,0,0,5,5,0,0,6,6,5,5,2,2,5,5,3,3,5,5,2,2,7,7,6,6,1,1,3,3,0,0,7,7,0,0,6,6,6,6,5,5,3,3,2,2,0,0,1,1,7,7,1,1,6,6,1,1,0,0,1,1,0,0,1,1,3,3,3,3,6,6,2,2,6,6,2,2,7,7,2,2,3,3,7,7,0,0,1,1,5,5,6,6,0,0,0,0,7,7,0,0,5,5,6,6,6,6,0,0,4,4,1,1,2,2,2,2,5,5,1,1,1,1,7,7,3,3,4,4,4,4,7,7,3,3,2,2,0,0,0,0,3,3,7,7,0,0,6,6,6,6,4,4,6,6,5,5,4,4,5,5,4,4,7,7,1,1,4,4,4,4,3,3,0,0,2,2,3,3,2,2,4,4,5,5,2,2,7,7,3,3,7,7,1,1,0,0,0,0,0,0,3,3,0,0,1,1,3,3,1,1,6,6,3,3,3,3,6,6,0,0,0,0,1,1,7,7,7,7,0,0,0,0,7,7,0,0,1,1,6,6,4,4,5,5,2,2,5,5,0,0,7,7,5,5,4,4,5,5,3,3,3,3,3,3,7,7,7,7,7,7,1,1,1,1,0,0,0,0,5,5,3,3,4,4,1,1,1,1,6,6,3,3,7,7,1,1,6,6,2,2,0,0,1,1,4,4,6,6,6,6,5,5,5,5,3,3,6,6,5,5,7,7,2,2,3,3,3,3,7,7,7,7,0,0,2,2,1,1,4,4,5,5,0,0,7,7,2,2,3,3,6,6,4,4,2,2,7,7,0,0,3,3,5,5,0,0,7,7,5,5,4,4,7,7,2,2,5,5,6,6,3,3,0,0,1,1,1,1,6,6,6,6,5,5,1,1,3,3,3,3,5,5,1,1,7,7,7,7,5,5,1,1,2,2,5,5,5,5,4,4,6,6,0,0,5,5,1,1,0,0,7,7,7,7,1,1,3,3,1,1,3,3,6,6,3,3,4,4,0,0,3,3,2,2,4,4,6,6,3,3,0,0,3,3,0,0,6,6,3,3,2,2,1,1,5,5,4,4,1,1,1,1,0,0,6,6,2,2,3,3,5,5,7,7,6,6,6,6,2,2,4,4,5,5,5,5,6,6,4,4,0,0,1,1,7,7,2,2,2,2,3,3,2,2,5,5,3,3,4,4,1,1,2,2,6,6,1,1,0,0,1,1,1,1,2,2,2,2,4,4,1,1,4,4,5,5,2,2,1,1,2,2,6,6,5,5,2,2,2,2,4,4,1,1,6,6,7,7,7,7,0,0,5,5,3,3,7,7,1,1,4,4,7,7,2,2,0,0,5,5,1,1,0,0,4,4,2,2,3,3,5,5,2,2,3,3,0,0,2,2,0,0,4,4,6,6,1,1,2,2,2,2,7,7,0,0,3,3,4,4,1,1,2,2,4,4,2,2,3,3,0,0,6,6,6,6,4,4,5,5,1,1,5,5,6,6,6,6,7,7,5,5,3,3,6,6,6,6,0,0,2,2,4,4,1,1,6,6,3,3,5,5,4,4,7,7,1,1,2,2,6,6,5,5,5,5,0,0,5,5,4,4,1,1,7,7,2,2,1,1,0,0,2,2,1,1,1,1,2,2,6,6,0,0,5,5,2,2,1,1,2,2,7,7,7,7,3,3,3,3,4,4,6,6,5,5,3,3,1,1,0,0,0,0,4,4,5,5,5,5,3,3,0,0,3,3,1,1,7,7,5,5,3,3,4,4,0,0,3,3,1,1,2,2,4,4,2,2,5,5,5,5,6,6,1,1,4,4,1,1,1,1,2,2,1,1,2,2,0,0,0,0,4,4,3,3,2,2,3,3,6,6,5,5,0,0,5,5,1,1,4,4,6,6,1,1,0,0,2,2,4,4,5,5,1,1,6,6,7,7,6,6,5,5,2,2,3,3,3,3,0,0,2,2,1,1,5,5,4,4,0,0,5,5,7,7,1,1,1,1,3,3,7,7,7,7,7,7,4,4,4,4,2,2,5,5,1,1,3,3,1,1,1,1,7,7,6,6,7,7,4,4,7,7,2,2,7,7,7,7,6,6,7,7,4,4,2,2,6,6,6,6,7,7,0,0,1,1,6,6,5,5,5,5,1,1,0,0,4,4,2,2,4,4,4,4,0,0,6,6,1,1,3,3,2,2,7,7,2,2,1,1,4,4,1,1,7,7,3,3,2,2,4,4,6,6,7,7,7,7,0,0,0,0,1,1,1,1,2,2,2,2,7,7,5,5,5,5,4,4,3,3,2,2,4,4,3,3,3,3,1,1,1,1,5,5,3,3,3,3,4,4,7,7,0,0,2,2,2,2,7,7,4,4,6,6,3,3,6,6,4,4,7,7,2,2,4,4,1,1,2,2,1,1,0,0,2,2,4,4,7,7,2,2,5,5,7,7,0,0,6,6,7,7,4,4,0,0,6,6,7,7,1,1,0,0,0,0,3,3,6,6,6,6,0,0,5,5,0,0,3,3,2,2,3,3,2,2,1,1,4,4,2,2,0,0,5,5,6,6,3,3,7,7,0,0,5,5,4,4,3,3,4,4,5,5,0,0,6,6,3,3,0,0,1,1,1,1,3,3,1,1,5,5,5,5,1,1,4,4,7,7,3,3,5,5,3,3,3,3,6,6,1,1,0,0,3,3,6,6,3,3,7,7,0,0,5,5,6,6,5,5,4,4,1,1,5,5,2,2,0,0,3,3,5,5,2,2,7,7,0,0,1,1,2,2,5,5,0,0,0,0,4,4,4,4,6,6,3,3,1,1,6,6,0,0,5,5,5,5,4,4,2,2,6,6,3,3,4,4,7,7,4,4,0,0,5,5,2,2,0,0,1,1,0,0,4,4,2,2,3,3,1,1,5,5,2,2,1,1,0,0,0,0,5,5,2,2,4,4,4,4,1,1,2,2,0,0,5,5,2,2,3,3,5,5,3,3,0,0,4,4,3,3,7,7,6,6,1,1,4,4,2,2,5,5,4,4,0,0,0,0,4,4,6,6,3,3,5,5,5,5,2,2,2,2,3,3,2,2,6,6,4,4,4,4,2,2,6,6,0,0,5,5,1,1,5,5,4,4,6,6,0,0,6,6,5,5,4,4,0,0,3,3,2,2,5,5,5,5,4,4,0,0,7,7,2,2,7,7,1,1,4,4,7,7,5,5,1,1,4,4,2,2,7,7,0,0,4,4,0,0,6,6,3,3,4,4,4,4,0,0,6,6,0,0,3,3,5,5,6,6,7,7,6,6,2,2,2,2,6,6,5,5,4,4,4,4,3,3,2,2,0,0,6,6,0,0,6,6,1,1,2,2,7,7,7,7,6,6,5,5,2,2,1,1,4,4,0,0,1,1,0,0,3,3,2,2,2,2,4,4,5,5,3,3,7,7,3,3,7,7,5,5,4,4,7,7,0,0,5,5,0,0,1,1,0,0,5,5,5,5,2,2,3,3,4,4,0,0,6,6,0,0,3,3,0,0,6,6,7,7,2,2,0,0,7,7,3,3,0,0,2,2,3,3,7,7,2,2,2,2,6,6,0,0,1,1,6,6,6,6,5,5,6,6,1,1,3,3,1,1,7,7,2,2,1,1,0,0,7,7,5,5,0,0,6,6,6,6,2,2,1,1,4,4,4,4,4,4,3,3,2,2,2,2,3,3,1,1,2,2,4,4,6,6,4,4,3,3,7,7,6,6,2,2,4,4,1,1,7,7,5,5,3,3,0,0,1,1,5,5,2,2,3,3,5,5,2,2,4,4,5,5,4,4,0,0,2,2,2,2,3,3,5,5,1,1,2,2,7,7,5,5,5,5,0,0,7,7,6,6,2,2,5,5,5,5,3,3,4,4,2,2,1,1,0,0,6,6,1,1,2,2,0,0,5,5,3,3,7,7,6,6,2,2,2,2,2,2,2,2,7,7,1,1,3,3,7,7,1,1,3,3,6,6,4,4,2,2,0,0,1,1,1,1,3,3,7,7,7,7,6,6,7,7,4,4,5,5,2,2,6,6,0,0,3,3,6,6,3,3,1,1,2,2,3,3,6,6,2,2,7,7,6,6,5,5,0,0,2,2,4,4,5,5,2,2,0,0,0,0,3,3,7,7,1,1,5,5,0,0,1,1,5,5,4,4,5,5,3,3,4,4,1,1,2,2,2,2,6,6,0,0,1,1,2,2,2,2,4,4,6,6,3,3,5,5,2,2,2,2,5,5,6,6,0,0,2,2,1,1,3,3,4,4,7,7,1,1,7,7,4,4,4,4,4,4,3,3,1,1,3,3,3,3,4,4,3,3,0,0,4,4,0,0,6,6,1,1,6,6,6,6,6,6,6,6,3,3,1,1,6,6,5,5,2,2,0,0,1,1,6,6,7,7,6,6,5,5,2,2,7,7,2,2,3,3,6,6,1,1,3,3,7,7,5,5,0,0,5,5,7,7,4,4,7,7,4,4,4,4,7,7,4,4,5,5,0,0,5,5,2,2,6,6,0,0,5,5,2,2,4,4,0,0,5,5,2,2,0,0,7,7,1,1,0,0,3,3,4,4,7,7,5,5,4,4,4,4,5,5,7,7,6,6,0,0,0,0,6,6,7,7,3,3,4,4,7,7,0,0,0,0,0,0,6,6,1,1,5,5,7,7,4,4,1,1,2,2,5,5,2,2,0,0,3,3,4,4,0,0,4,4,5,5,5,5,4,4,7,7,6,6,0,0,6,6,3,3,6,6,3,3,4,4,5,5,1,1,5,5,1,1,1,1,6,6,1,1,3,3,3,3,4,4,7,7,5,5,1,1,6,6,3,3,7,7,0,0,6,6,7,7,1,1,5,5,5,5,7,7,0,0,4,4,0,0,2,2,3,3,3,3,7,7,1,1,2,2,6,6,3,3,4,4,7,7,2,2,0,0,6,6,0,0,0,0,3,3,3,3,1,1,2,2,4,4,4,4,5,5,1,1,3,3,1,1,2,2,1,1,4,4,6,6,1,1,0,0,3,3,6,6,0,0,1,1,0,0,0,0,7,7,4,4,1,1,1,1,3,3,1,1,6,6,1,1,4,4,5,5,0,0,1,1,1,1,2,2,7,7,6,6,4,4,7,7,0,0,6,6,0,0,1,1,0,0,6,6,6,6,1,1,6,6,7,7,4,4,6,6,5,5,1,1,0,0,1,1,2,2,3,3,5,5,1,1,6,6,0,0,6,6,0,0,1,1,5,5,0,0,7,7,2,2,2,2,7,7,7,7,2,2,1,1,5,5,0,0,3,3,5,5,0,0,6,6,4,4,3,3,3,3,3,3,5,5,1,1,5,5,0,0,5,5,4,4,2,2,0,0,0,0,6,6,2,2,0,0,2,2,6,6,7,7,7,7,5,5,6,6,1,1,4,4,3,3,1,1,3,3,4,4,1,1,0,0,4,4,3,3,0,0,3,3,7,7,2,2,0,0,5,5,0,0,6,6,4,4,7,7,0,0,5,5,6,6,6,6,7,7,3,3,7,7,5,5,1,1,1,1,1,1,3,3,0,0,2,2,5,5,4,4,1,1,3,3,3,3,7,7,0,0,6,6,3,3,6,6,2,2,6,6,2,2,2,2,7,7,6,6,4,4,3,3,0,0,3,3,7,7,4,4,2,2,0,0,4,4,4,4,6,6,4,4,1,1,3,3,6,6,2,2,0,0,5,5,1,1,4,4,6,6,6,6,7,7,3,3,6,6,6,6,7,7,3,3,7,7,7,7,7,7,3,3,4,4,4,4,1,1,5,5,3,3,3,3,3,3,6,6,7,7,3,3,1,1,7,7,3,3,2,2,3,3,2,2,5,5,2,2,6,6,6,6,1,1,6,6,1,1,4,4,3,3,5,5,4,4,0,0,2,2,4,4,1,1,5,5,6,6,0,0,7,7,4,4,5,5,7,7,2,2,4,4,6,6,6,6,4,4,0,0,0,0,2,2,5,5,1,1,1,1,4,4,5,5,2,2,2,2,4,4,2,2,5,5,4,4,4,4,2,2,5,5,5,5,3,3,4,4,0,0,0,0,3,3,2,2,4,4,4,4,6,6,4,4,0,0,6,6,3,3,0,0,6,6,1,1,3,3,4,4,4,4,4,4,3,3,2,2,4,4,5,5,0,0,0,0,6,6,4,4,4,4,7,7,2,2,2,2,4,4,6,6,4,4,6,6,7,7,6,6,0,0,4,4,2,2,5,5,2,2,0,0,0,0,1,1,1,1,4,4,3,3,5,5,2,2,5,5,6,6,0,0,4,4,1,1,3,3,4,4,5,5,0,0,4,4,0,0,3,3,0,0,2,2,3,3,2,2,5,5,1,1,6,6,7,7,0,0,1,1,4,4,5,5,5,5,5,5,5,5,5,5,4,4,6,6,4,4,6,6,4,4,3,3,2,2,2,2,5,5,2,2,6,6,7,7,3,3,6,6,6,6,7,7,5,5,0,0,2,2,3,3,2,2,3,3,1,1,3,3,3,3,6,6,3,3,3,3,0,0,4,4,1,1,0,0,7,7,7,7,2,2,0,0,2,2,6,6,4,4,5,5,0,0,5,5,4,4,2,2,5,5,0,0,2,2,0,0,1,1,7,7,4,4,4,4,6,6,2,2,3,3,0,0,6,6,1,1,5,5,2,2,7,7,5,5,5,5,5,5,4,4,4,4,6,6,3,3,1,1,1,1,2,2,2,2,0,0,3,3,6,6,6,6,2,2,2,2,4,4,5,5,0,0,6,6,1,1,6,6,7,7,2,2,6,6,0,0,5,5,0,0,7,7,0,0,3,3,0,0,1,1,3,3,7,7,7,7,6,6,3,3,3,3,0,0,0,0,1,1,2,2,0,0,2,2,7,7,4,4,1,1,1,1,6,6,5,5,6,6,1,1,4,4,5,5,7,7,5,5,4,4,3,3,3,3,4,4,3,3,0,0,0,0,0,0,6,6,0,0,6,6,7,7,7,7,7,7,7,7,6,6,1,1,0,0,4,4,5,5,1,1,2,2,4,4,4,4,5,5,2,2,7,7,5,5,6,6,7,7,2,2,3,3,3,3,1,1,2,2,6,6,1,1,2,2,6,6,2,2,0,0,0,0,7,7,5,5,3,3,0,0,3,3,1,1,3,3,1,1,5,5,1,1,0,0,6,6,5,5,2,2,5,5,1,1,1,1,0,0,4,4,2,2,5,5,0,0,4,4,3,3,3,3,5,5,3,3,6,6,1,1,2,2,4,4,1,1,3,3,7,7,5,5,0,0,2,2,0,0,7,7,7,7,0,0,6,6,4,4,1,1,6,6,4,4,6,6,0,0,6,6,6,6,5,5,0,0,4,4,5,5,4,4,2,2,4,4,0,0,7,7,1,1,1,1,5,5,2,2,0,0,2,2,2,2,0,0,2,2,1,1,5,5,7,7,4,4,3,3,1,1,5,5,5,5,1,1,2,2,2,2,1,1,1,1,2,2,2,2,4,4,7,7,2,2,1,1,6,6,6,6,3,3,6,6,5,5,3,3,1,1,2,2,1,1,5,5,3,3,1,1,5,5,6,6,0,0,3,3,7,7,4,4,4,4,0,0,2,2,2,2,3,3,2,2,4,4,5,5,2,2,1,1,7,7,7,7,6,6,2,2,4,4,3,3,5,5,5,5,0,0,7,7,0,0,4,4,1,1,2,2,6,6,2,2,5,5,6,6,3,3,5,5,3,3,7,7,5,5,5,5,7,7,3,3,5,5,7,7,2,2,2,2,5,5,4,4,5,5,5,5,2,2,1,1,5,5,6,6,4,4,4,4,4,4,3,3,1,1,5,5,2,2,4,4,1,1,3,3,1,1,4,4,1,1,0,0,2,2,2,2,4,4,2,2,1,1,3,3,4,4,7,7,5,5,4,4,3,3,3,3,4,4,4,4,3,3,4,4,6,6,5,5,0,0,0,0,1,1,6,6,4,4,1,1,5,5,0,0,4,4,6,6,3,3,3,3,2,2,0,0,2,2,7,7,7,7,2,2,7,7,4,4,0,0,1,1,2,2,2,2,2,2,3,3,1,1,5,5,0,0,0,0,1,1,1,1,7,7,2,2,2,2,5,5,7,7,5,5,2,2,1,1,6,6,4,4,0,0,6,6,6,6,0,0,3,3,5,5,7,7,6,6,3,3,1,1,5,5,5,5,6,6,2,2,4,4,4,4,5,5,7,7,1,1,1,1,7,7,0,0,6,6,2,2,3,3,1,1,3,3,5,5,4,4,7,7,7,7,3,3,5,5,5,5,5,5,5,5,0,0,5,5,1,1,0,0,4,4,3,3,4,4,7,7,5,5,1,1,7,7,6,6,0,0,5,5,7,7,7,7,0,0,4,4,3,3,5,5,4,4,6,6,1,1,3,3,4,4,6,6,0,0,6,6,0,0,6,6,2,2,2,2,7,7,2,2,3,3,6,6,0,0,3,3,4,4,3,3,1,1,1,1,3,3,2,2,0,0,7,7,3,3,4,4,6,6,0,0,5,5,7,7,2,2,2,2,2,2,1,1,5,5,5,5,6,6,6,6,5,5,1,1,4,4,4,4,6,6,0,0,5,5,3,3,7,7,5,5,7,7,6,6,3,3,1,1,0,0,3,3,7,7,3,3,6,6,1,1,0,0,7,7,0,0,0,0,1,1,4,4,0,0,3,3,0,0,5,5,6,6,7,7,6,6,2,2,0,0,7,7,5,5,4,4,1,1,6,6,2,2,4,4,4,4,6,6,2,2,0,0,2,2,4,4,3,3,5,5,5,5,7,7,4,4,2,2,5,5,3,3,6,6,3,3,0,0,7,7,1,1,3,3,7,7,4,4,3,3,4,4,2,2,5,5,3,3,2,2,7,7,4,4,2,2,7,7,1,1,5,5,0,0,0,0,6,6,1,1,5,5,7,7,7,7,5,5,0,0,5,5,7,7,2,2,0,0,1,1,0,0,3,3,6,6,5,5,0,0,4,4,0,0,5,5,1,1,4,4,0,0,3,3,6,6,7,7,0,0,7,7,2,2,2,2,3,3,1,1,5,5,3,3,3,3,4,4,2,2,3,3,0,0,2,2,3,3,4,4,5,5,6,6,4,4,7,7,0,0,4,4,4,4,3,3,6,6,3,3,3,3,2,2,4,4,1,1,0,0,4,4,2,2,4,4,3,3,5,5,0,0,4,4,7,7,6,6,0,0,2,2,6,6,1,1,7,7,7,7,3,3,2,2,2,2,7,7,0,0,3,3,4,4,2,2,2,2,3,3,6,6,1,1,3,3,7,7,1,1,5,5,2,2,1,1,3,3,1,1,0,0,6,6,2,2,3,3,2,2,2,2,3,3,3,3,2,2,0,0,7,7,0,0,0,0,5,5,4,4,4,4,4,4,7,7,6,6,2,2,0,0,5,5,0,0,5,5,0,0,2,2,6,6,2,2,1,1,7,7,7,7,6,6,2,2,3,3,0,0,3,3,7,7,6,6,7,7,4,4,0,0,3,3,5,5,2,2,3,3,1,1,5,5,1,1,0,0,6,6,7,7,1,1,3,3,4,4,2,2,0,0,2,2,5,5,5,5,6,6,1,1,1,1,6,6,2,2,3,3,0,0,2,2,1,1,7,7,2,2,2,2,0,0,3,3,7,7,4,4,5,5,5,5,1,1,6,6,4,4,0,0,5,5,4,4,2,2,2,2,5,5,6,6,6,6,6,6,1,1,2,2,5,5,7,7,0,0,2,2,7,7,5,5,6,6,2,2,2,2,6,6,5,5,5,5,4,4,6,6,7,7,1,1,6,6,1,1,5,5,6,6,4,4,5,5,1,1,7,7,3,3,7,7,2,2,3,3,3,3,7,7,4,4,7,7,4,4,0,0,0,0,1,1,7,7,3,3,3,3,0,0,2,2,1,1,2,2,3,3,0,0,3,3,6,6,6,6,4,4,4,4,5,5,0,0,2,2,5,5,2,2,1,1,0,0,6,6,4,4,7,7,3,3,1,1,7,7,3,3,1,1,3,3,2,2,0,0,1,1,2,2,0,0,6,6,7,7,7,7,4,4,1,1,1,1,0,0,7,7,2,2,2,2,3,3,2,2,3,3,3,3,0,0,0,0,6,6,2,2,7,7,2,2,5,5,7,7,6,6,5,5,6,6,1,1,6,6,6,6,7,7,7,7,1,1,1,1,0,0,2,2,2,2,6,6,3,3,2,2,1,1,4,4,1,1,5,5,5,5,1,1,0,0,4,4,4,4,3,3,3,3,1,1,2,2,0,0,1,1,1,1,4,4,1,1,4,4,0,0,1,1,0,0,5,5,1,1,0,0,2,2,5,5,7,7,6,6,1,1,4,4,6,6,2,2,2,2,4,4,2,2,6,6,2,2,7,7,0,0,2,2,4,4,0,0,7,7,3,3,2,2,7,7,5,5,0,0,3,3,7,7,6,6,2,2,0,0,6,6,1,1,3,3,4,4,1,1,0,0,1,1,3,3,0,0,0,0,0,0,3,3,6,6,3,3,5,5,2,2,2,2,2,2,2,2,6,6,4,4,7,7,4,4,5,5,2,2,0,0,0,0,0,0,1,1,3,3,1,1,4,4,4,4,6,6,5,5,4,4,3,3,6,6,1,1,6,6,7,7,7,7,4,4,1,1,0,0,0,0,5,5,6,6,6,6,1,1,3,3,1,1,4,4,3,3,6,6,6,6,4,4,4,4,3,3,0,0,5,5,0,0,4,4,4,4,6,6,7,7,1,1,5,5,4,4,5,5,2,2,6,6,6,6,7,7,3,3,6,6,7,7,4,4,7,7,7,7,0,0,1,1,7,7,1,1,5,5,7,7,0,0,0,0,5,5,4,4,6,6,3,3,4,4,2,2,2,2,3,3,5,5,4,4,4,4,3,3,5,5,3,3,2,2,7,7,4,4,7,7,2,2,0,0,5,5,0,0,1,1,1,1,3,3,4,4,1,1,2,2,3,3,1,1,4,4,4,4,7,7,7,7,1,1,4,4,6,6,7,7,2,2,1,1,4,4,4,4,2,2,5,5,1,1,6,6,3,3,7,7,2,2,5,5,0,0,0,0,5,5,6,6,0,0,3,3,5,5,7,7,4,4,1,1,5,5,1,1,0,0,3,3,2,2,3,3,5,5,3,3,5,5,3,3,2,2,7,7,7,7,5,5,7,7,2,2,2,2,3,3,3,3,4,4,6,6,3,3,1,1,5,5,7,7,2,2,1,1,3,3,0,0,0,0,7,7,5,5,3,3,2,2,6,6,3,3,7,7,7,7,1,1,2,2,1,1,3,3,3,3,0,0,1,1,0,0,0,0,7,7,7,7,6,6,4,4,1,1,6,6,3,3,2,2,3,3,7,7,6,6,7,7,5,5,0,0,7,7,4,4,4,4,5,5,0,0,0,0,4,4,3,3,3,3,3,3,7,7,6,6,0,0,4,4,3,3,7,7,4,4,5,5,0,0,1,1,7,7,2,2,2,2,5,5,5,5,5,5,7,7,0,0,0,0,4,4,3,3,2,2,0,0,3,3,6,6,7,7,2,2,5,5,0,0,7,7,2,2,1,1,3,3,5,5,3,3,7,7,1,1,6,6,2,2,0,0,1,1,3,3,1,1,6,6,7,7,1,1,7,7,1,1,2,2,0,0,0,0,3,3,5,5,2,2,4,4,4,4,6,6,6,6,1,1,6,6,5,5,0,0,6,6,5,5,4,4,3,3,0,0,3,3,7,7,3,3,2,2,0,0,6,6,2,2,5,5,2,2,5,5,3,3,0,0,1,1,6,6,0,0,6,6,0,0,1,1,6,6,4,4,2,2,6,6,3,3,5,5,5,5,7,7,2,2,7,7,2,2,7,7,6,6,7,7,4,4,1,1,3,3,4,4,6,6,6,6,2,2,5,5,7,7,2,2,6,6,7,7,1,1,0,0,6,6,4,4,0,0,0,0,6,6,3,3,0,0,3,3,6,6,1,1,6,6,0,0,0,0,5,5,2,2,1,1,0,0,3,3,0,0,3,3,1,1,2,2,2,2,7,7,0,0,0,0,5,5,3,3,6,6,4,4,2,2,3,3,4,4,0,0,1,1,1,1,7,7,0,0,5,5,1,1,2,2,2,2,6,6,7,7,2,2,3,3,6,6,1,1,5,5,0,0,5,5,4,4,5,5,2,2,6,6,2,2,4,4,0,0,2,2,2,2,2,2,2,2,2,2,5,5,1,1,4,4,0,0,7,7,3,3,7,7,6,6,2,2,3,3,3,3,4,4,2,2,6,6,5,5,7,7,3,3,6,6,1,1,7,7,5,5,2,2,5,5,0,0,3,3,2,2,7,7,6,6,2,2,7,7,0,0,4,4,1,1,2,2,2,2,6,6,4,4,4,4,7,7,2,2,6,6,0,0,2,2,0,0,4,4,0,0,5,5,4,4,1,1,1,1,4,4,1,1,3,3,7,7,6,6,2,2,2,2,3,3,5,5,4,4,2,2,5,5,0,0,0,0,5,5,6,6,0,0,6,6,0,0,2,2,2,2,1,1,1,1,6,6,2,2,7,7,4,4,6,6,2,2,7,7,4,4,7,7,4,4,7,7,1,1,3,3,6,6,7,7,4,4,1,1,4,4,3,3,6,6,7,7,5,5,2,2,1,1,4,4,2,2,3,3,4,4,4,4,7,7,5,5,4,4,1,1,3,3,2,2,1,1,7,7,4,4,4,4,4,4,3,3,0,0,2,2,2,2,0,0,0,0,4,4,0,0,0,0,3,3,6,6,3,3,7,7,4,4,1,1,1,1,4,4,4,4,1,1,6,6,6,6,0,0,4,4,3,3,6,6,0,0,2,2,0,0,6,6,7,7,3,3,0,0,4,4,1,1,6,6,4,4,1,1,7,7,0,0,4,4,4,4,7,7,7,7,1,1,6,6,5,5,5,5,0,0,3,3,1,1,0,0,5,5,4,4,2,2,2,2,3,3,2,2,5,5,1,1,4,4,4,4,2,2,6,6,1,1,3,3,5,5,7,7,3,3,5,5,0,0,2,2,0,0,2,2,6,6,4,4,4,4,3,3,0,0,1,1,2,2,5,5,2,2,2,2,4,4,6,6,4,4,5,5,5,5,6,6,5,5,1,1,6,6,6,6,3,3,0,0,2,2,0,0,3,3,0,0,7,7,6,6,3,3,7,7,3,3,6,6,4,4,2,2,2,2,3,3,2,2,6,6,4,4,1,1,5,5,4,4,2,2,5,5,0,0,1,1,2,2,0,0,6,6,5,5,7,7,4,4,6,6,4,4,0,0,3,3,1,1,0,0,4,4,6,6,7,7,0,0,0,0,5,5,3,3,0,0,6,6,1,1,4,4,3,3,0,0,7,7,4,4,0,0,1,1,2,2,5,5,1,1,1,1,7,7,3,3,7,7,4,4,4,4,1,1,7,7,7,7,2,2,2,2,0,0,2,2,0,0,7,7,3,3,7,7,7,7,5,5,4,4,2,2,1,1,1,1,4,4,4,4,4,4,0,0,3,3,5,5,1,1,6,6,4,4,0,0,3,3,5,5,6,6,1,1,6,6,3,3,6,6,3,3,7,7,2,2,6,6,7,7,3,3,7,7,3,3,2,2,0,0,5,5,1,1,6,6,2,2,2,2,3,3,7,7,7,7,0,0,2,2,7,7,1,1,6,6,5,5,2,2,6,6,1,1,5,5,1,1,1,1,5,5,5,5,6,6,0,0,1,1,6,6,6,6,6,6,1,1,4,4,4,4,5,5,4,4,3,3,0,0,4,4,5,5,4,4,3,3,1,1,5,5,1,1,2,2,3,3,5,5,3,3,4,4,2,2,2,2,1,1,5,5,6,6,4,4,6,6,6,6,1,1,0,0,5,5,3,3,1,1,6,6,3,3,6,6,5,5,5,5,5,5,5,5,6,6,6,6,0,0,5,5,7,7,0,0,0,0,7,7,0,0,6,6,3,3,5,5,2,2,7,7,2,2,7,7,0,0,0,0,0,0,4,4,1,1,7,7,2,2,4,4,1,1,1,1,2,2,1,1,0,0,0,0,5,5,1,1,7,7,3,3,5,5,7,7,0,0,6,6,2,2,7,7,7,7,6,6,3,3,3,3,6,6,7,7,7,7,4,4,7,7,3,3,0,0,0,0,7,7,0,0,0,0,1,1,0,0,3,3,5,5,4,4,6,6,1,1,5,5,5,5,3,3,5,5,3,3,3,3,6,6,7,7,2,2,2,2,1,1,7,7,5,5,0,0,4,4,1,1,7,7,2,2,0,0,5,5,6,6,3,3,2,2,1,1,1,1,2,2,2,2,0,0,5,5,0,0,1,1,5,5,0,0,3,3,1,1,2,2,1,1,4,4,7,7,4,4,3,3,1,1,2,2,1,1,1,1,2,2,2,2,0,0,7,7,2,2,7,7,4,4,7,7,5,5,3,3,7,7,3,3,3,3,7,7,5,5,2,2,3,3,6,6,3,3,4,4,0,0,4,4,3,3,4,4,4,4,2,2,6,6,0,0,6,6,7,7,1,1,1,1,1,1,1,1,7,7,2,2,6,6,6,6,7,7,0,0,7,7,2,2,4,4,4,4,1,1,1,1,2,2,6,6,0,0,3,3,2,2,0,0,2,2,3,3,4,4,4,4,0,0,2,2,4,4,6,6,6,6,6,6,4,4,4,4,0,0,7,7,2,2,1,1,3,3,3,3,2,2,2,2,4,4,1,1,3,3,2,2,3,3,6,6,2,2,1,1,3,3,5,5,6,6,6,6,1,1,7,7,2,2,4,4,0,0,1,1,2,2,5,5,2,2,4,4,0,0,0,0,6,6,7,7,0,0,3,3,1,1,7,7,3,3,5,5,2,2,1,1,6,6,4,4,7,7,1,1,6,6,4,4,0,0,1,1,6,6,3,3,3,3,1,1,2,2,4,4,2,2,5,5,4,4,7,7,6,6,6,6,2,2,1,1,1,1,6,6,5,5,4,4,1,1,2,2,6,6,6,6,6,6,1,1,1,1,3,3,0,0,3,3,3,3,3,3,4,4,7,7,3,3,2,2,0,0,7,7,5,5,1,1,2,2,1,1,7,7,2,2,6,6,2,2,6,6,2,2,4,4,1,1,3,3,1,1,7,7,7,7,7,7,2,2,5,5,7,7,5,5,0,0,5,5,2,2,5,5,2,2,0,0,7,7,1,1,2,2,3,3,6,6,5,5,4,4,0,0,0,0,4,4,1,1,6,6,7,7,2,2,6,6,3,3,1,1,2,2,3,3,5,5,7,7,0,0,4,4,0,0,6,6,2,2,1,1,0,0,1,1,5,5,4,4,0,0,2,2,5,5,7,7,4,4,0,0,0,0,1,1,2,2,2,2,3,3,0,0,0,0,3,3,2,2,3,3,5,5,1,1,4,4,1,1,6,6,3,3,7,7,6,6,4,4,7,7,5,5,7,7,6,6,7,7,5,5,2,2,6,6,0,0,2,2,7,7,0,0,4,4,5,5,5,5,0,0,6,6,6,6,4,4,3,3,7,7,1,1,2,2,0,0,0,0,6,6,0,0,6,6,3,3,3,3,2,2,3,3,5,5,3,3,2,2,1,1,5,5,4,4,0,0,7,7,4,4,7,7,6,6,5,5,5,5,6,6,0,0,2,2,3,3,6,6,6,6,2,2,3,3,1,1,3,3,5,5,1,1,0,0,3,3,1,1,6,6,6,6,4,4,3,3,5,5,3,3,1,1,2,2,1,1,2,2,0,0,4,4,7,7,2,2,1,1,6,6,2,2,7,7,4,4,3,3,2,2,7,7,5,5,2,2,6,6,7,7,5,5,1,1,0,0,7,7,6,6,6,6,4,4,4,4,5,5,6,6,5,5,3,3,4,4,2,2,0,0,5,5,7,7,0,0,5,5,3,3,4,4,3,3,3,3,4,4,6,6,6,6,6,6,7,7,6,6,3,3,5,5,5,5,2,2,6,6,3,3,1,1,4,4,5,5,3,3,3,3,1,1,1,1,5,5,0,0,6,6,4,4,2,2,4,4,1,1,6,6,1,1,7,7,4,4,6,6,4,4,1,1,5,5,5,5,2,2,0,0,6,6,2,2,0,0,6,6,4,4,4,4,4,4,0,0,4,4,0,0,2,2,0,0,2,2,5,5,4,4,7,7,3,3,4,4,7,7,7,7,2,2,1,1,7,7,7,7,7,7,7,7,4,4,5,5,2,2,1,1,1,1,7,7,7,7,3,3,4,4,3,3,3,3,0,0,0,0,0,0,2,2,3,3,5,5,7,7,6,6,5,5,7,7,0,0,6,6,2,2,2,2,1,1,0,0,0,0,2,2,1,1,4,4,5,5,3,3,1,1,3,3,7,7,7,7,5,5,6,6,7,7,7,7,1,1,0,0,0,0,2,2,5,5,3,3,6,6,4,4,2,2,0,0,7,7,2,2,5,5,6,6,7,7,1,1,0,0,3,3,5,5,2,2,6,6,0,0,4,4,1,1,0,0,2,2,0,0,3,3,0,0,1,1,2,2,1,1,0,0,7,7,3,3,6,6,5,5,6,6,4,4,4,4,3,3,5,5,0,0,0,0,3,3,0,0,4,4,5,5,6,6,2,2,2,2,2,2,4,4,4,4,4,4,6,6,0,0,6,6,1,1,7,7,4,4,1,1,5,5,3,3,5,5,4,4,0,0,2,2,0,0,1,1,1,1,1,1,5,5,6,6,4,4,3,3,4,4,7,7,7,7,0,0,5,5,3,3,5,5,2,2,6,6,6,6,5,5,4,4,4,4,6,6,5,5,7,7,6,6,0,0,5,5,1,1,0,0,0,0,7,7,2,2,6,6,7,7,6,6,5,5,0,0,7,7,5,5,0,0,2,2,0,0,6,6,7,7,4,4,5,5,6,6,7,7,0,0,0,0,6,6,0,0,3,3,2,2,2,2,0,0,2,2,3,3,5,5,1,1,2,2,0,0,6,6,0,0,0,0,7,7,0,0,4,4,0,0,5,5,0,0,2,2,0,0,4,4,6,6,5,5,3,3,7,7,7,7,3,3,6,6,3,3,7,7,6,6,0,0,3,3,0,0,2,2,1,1,3,3,2,2,5,5,6,6,5,5,7,7,0,0,4,4,4,4,2,2,7,7,6,6,2,2,1,1,1,1,0,0,1,1,1,1,4,4,1,1,6,6,0,0,6,6,6,6,5,5,4,4,5,5,5,5,1,1,1,1,5,5,5,5,6,6,3,3,6,6,5,5,2,2,0,0,6,6,4,4,5,5,3,3,6,6,3,3,5,5,4,4,3,3,4,4,1,1,7,7,2,2,3,3,5,5,0,0,0,0,2,2,2,2,3,3,3,3,3,3,0,0,7,7,2,2,5,5,0,0,7,7,0,0,4,4,4,4,1,1,0,0,4,4,2,2,5,5,4,4,1,1,7,7,6,6,0,0,2,2,4,4,7,7,3,3,7,7,5,5,2,2,2,2,4,4,1,1,1,1,5,5,1,1,5,5,7,7,0,0,2,2,7,7,2,2,0,0,6,6,7,7,2,2,2,2,2,2,6,6,5,5,5,5,7,7,1,1,3,3,1,1,4,4,7,7,5,5,2,2,7,7,3,3,6,6,0,0,5,5,2,2,6,6,3,3,7,7,7,7,6,6,2,2,4,4,7,7,0,0,5,5,6,6,6,6,7,7,3,3,7,7,3,3,6,6,3,3,5,5,4,4,3,3,5,5,5,5,5,5,3,3,3,3,4,4,3,3,4,4,7,7,1,1,7,7,3,3,3,3,2,2,6,6,7,7,6,6,7,7,7,7,0,0,0,0,2,2,2,2,5,5,3,3,3,3,7,7,0,0,3,3,7,7,2,2,0,0,1,1,6,6,7,7,6,6,6,6,4,4,4,4,5,5,6,6,0,0,2,2,6,6,6,6,5,5,4,4,0,0,0,0,1,1,0,0,3,3,3,3,3,3,0,0,6,6,1,1,0,0,4,4,7,7,1,1,5,5,3,3,1,1,0,0,4,4,7,7,1,1,6,6,1,1,1,1,0,0,1,1,4,4,2,2,0,0,0,0,7,7,3,3,4,4,5,5,1,1,1,1,3,3,6,6,7,7,7,7,2,2,1,1,7,7,1,1,0,0,5,5,2,2,5,5,3,3,2,2,0,0,3,3,5,5,6,6,0,0,0,0,7,7,1,1,7,7,4,4,5,5,6,6,7,7,3,3,1,1,3,3,0,0,6,6,2,2,7,7,4,4,5,5,5,5,4,4,6,6,0,0,6,6,6,6,3,3,6,6,3,3,3,3,4,4,4,4,6,6,7,7,1,1,7,7,5,5,3,3,7,7,2,2,1,1,1,1,4,4,1,1,1,1,1,1,6,6,0,0,5,5,5,5,3,3,3,3,4,4,3,3,0,0,0,0,1,1,5,5,1,1,6,6,1,1,4,4,1,1,0,0,5,5,5,5,7,7,5,5,4,4,2,2,0,0,2,2,6,6,2,2,3,3,7,7,5,5,6,6,4,4,1,1,7,7,4,4,4,4,7,7,4,4,2,2,1,1,3,3,6,6,4,4,4,4,5,5,7,7,5,5,4,4,0,0,0,0,2,2,4,4,2,2,5,5,3,3,1,1,1,1,0,0,7,7,6,6,4,4,4,4,1,1,6,6,6,6,6,6,0,0,3,3,5,5,1,1,3,3,7,7,2,2,4,4,1,1,0,0,7,7,2,2,4,4,0,0,3,3,4,4,3,3,7,7,0,0,1,1,4,4,4,4,3,3,5,5,6,6,7,7,3,3,6,6,0,0,4,4,4,4,4,4,3,3,5,5,0,0,2,2,0,0,4,4,7,7,0,0,4,4,0,0,4,4,1,1,1,1,6,6,0,0,0,0,4,4,6,6,5,5,0,0,7,7,7,7,5,5,2,2,7,7,4,4,2,2,0,0,5,5,4,4,4,4,0,0,1,1,0,0,3,3,1,1,1,1,5,5,6,6,4,4,0,0,3,3,7,7,2,2,3,3,1,1,5,5,7,7,0,0,7,7,5,5,4,4,5,5,5,5,5,5,1,1,3,3,5,5,7,7,1,1,6,6,2,2,4,4,2,2,4,4,6,6,2,2,6,6,3,3,3,3,0,0,0,0,4,4,3,3,1,1,1,1,4,4,0,0,5,5,5,5,0,0,4,4,1,1,7,7,5,5,2,2,4,4,1,1,1,1,2,2,5,5,1,1,4,4,2,2,0,0,1,1,6,6,3,3,3,3,4,4,5,5,2,2,2,2,6,6,3,3,0,0,1,1,3,3,1,1,4,4,5,5,6,6,5,5,7,7,2,2,2,2,6,6,2,2,4,4,6,6,2,2,2,2,2,2,7,7,4,4,3,3,4,4,3,3,6,6,7,7,1,1,2,2,5,5,6,6,2,2,0,0,7,7,1,1,5,5,4,4,0,0,7,7,4,4,4,4,7,7,5,5,0,0,4,4,7,7,7,7,1,1,2,2,5,5,6,6,7,7,1,1,6,6,2,2,7,7,1,1,4,4,1,1,2,2,2,2,1,1,0,0,7,7,1,1,3,3,0,0,6,6,3,3,2,2,7,7,2,2,7,7,3,3,1,1,6,6,2,2,5,5,5,5,2,2,3,3,7,7,2,2,2,2,1,1,6,6,2,2,7,7,3,3,5,5,0,0,5,5,3,3,4,4,5,5,0,0,1,1,1,1,0,0,7,7,4,4,6,6,0,0,6,6,1,1,2,2,6,6,6,6,7,7,7,7,3,3,0,0,7,7,3,3,4,4,4,4,3,3,5,5,3,3,0,0,7,7,0,0,0,0,2,2,4,4,5,5,1,1,5,5,3,3,0,0,2,2,6,6,5,5,1,1,4,4,2,2,6,6,1,1,3,3,1,1,3,3,4,4,0,0,4,4,4,4,7,7,2,2,0,0,3,3,1,1,5,5,0,0,1,1,6,6,3,3,0,0,4,4,6,6,7,7,1,1,7,7,3,3,5,5,3,3,2,2,4,4,7,7,0,0,6,6,5,5,4,4,7,7,4,4,1,1,4,4,3,3,4,4,4,4,0,0,6,6,1,1,5,5,0,0,7,7,1,1,2,2,0,0,1,1,7,7,0,0,2,2,4,4,5,5,1,1,0,0,7,7,7,7,2,2,4,4,7,7,5,5,2,2,7,7,1,1,0,0,4,4,0,0,1,1,7,7,4,4,3,3,3,3,3,3,0,0,7,7,3,3,6,6,4,4,5,5,5,5,0,0,6,6,1,1,4,4,6,6,5,5,7,7,4,4,5,5,6,6,6,6,5,5,3,3,4,4,6,6,4,4,4,4,5,5,5,5,0,0,0,0,1,1,3,3,0,0,6,6,6,6,1,1,2,2,2,2,6,6,4,4,1,1,0,0,0,0,6,6,5,5,0,0,1,1,0,0,7,7,0,0,3,3,2,2,6,6,7,7,2,2,7,7,7,7,1,1,2,2,4,4,2,2,6,6,6,6,1,1,2,2,3,3,6,6,0,0,2,2,5,5,5,5,4,4,5,5,7,7,6,6,0,0,5,5,3,3,4,4,3,3,5,5,3,3,7,7,7,7,4,4,5,5,0,0,5,5,5,5,1,1,7,7,0,0,3,3,1,1,1,1,1,1,2,2,0,0,2,2,4,4,4,4,6,6,4,4,0,0,7,7,5,5,6,6,3,3,2,2,2,2,6,6,1,1,7,7,3,3,7,7,2,2,2,2,1,1,2,2,0,0,7,7,4,4,4,4,7,7,0,0,7,7,2,2,3,3,2,2,4,4,2,2,0,0,4,4,6,6,4,4,7,7,1,1,5,5,6,6,6,6,1,1,6,6,5,5,5,5,7,7,2,2,1,1,4,4,2,2,4,4,5,5,4,4,5,5,1,1,0,0,4,4,4,4,5,5,4,4,6,6,6,6,0,0,1,1,2,2,0,0,0,0,0,0,7,7,0,0,1,1,4,4,6,6,4,4,4,4,5,5,3,3,2,2,0,0,1,1,2,2,6,6,0,0,1,1,7,7,2,2,4,4,4,4,2,2,6,6,7,7,5,5,5,5,1,1,6,6,0,0,4,4,1,1,3,3,0,0,1,1,6,6,3,3,7,7,3,3,1,1,6,6,5,5,4,4,7,7,2,2,2,2,7,7,2,2,4,4,5,5,2,2,2,2,5,5,5,5,2,2,4,4,5,5,3,3,1,1,2,2,4,4,4,4,5,5,0,0,6,6,4,4,1,1,6,6,6,6,6,6,1,1,0,0,0,0,3,3,6,6,4,4,5,5,3,3,7,7,5,5,4,4,2,2,2,2,5,5,4,4,5,5,4,4,0,0,0,0,6,6,2,2,5,5,0,0,7,7,7,7,0,0,7,7,7,7,2,2,0,0,2,2,6,6,7,7,0,0,4,4,6,6,7,7,7,7,3,3,5,5,3,3,4,4,2,2,7,7,4,4,0,0,1,1,1,1,7,7,2,2,4,4,4,4,7,7,4,4,4,4,7,7,3,3,4,4,5,5,7,7,0,0,5,5,4,4,2,2,3,3,3,3,5,5,4,4,7,7,6,6,4,4,1,1,2,2,2,2,5,5,7,7,7,7,2,2,5,5,3,3,1,1,0,0,7,7,0,0,0,0,2,2,6,6,3,3,2,2,3,3,1,1,2,2,7,7,5,5,4,4,4,4,3,3,1,1,3,3,5,5,0,0,1,1,3,3,7,7,0,0,5,5,7,7,7,7,5,5,6,6,3,3,5,5,0,0,3,3,3,3,6,6,7,7,3,3,5,5,3,3,4,4,3,3,1,1,6,6,0,0,0,0,0,0,7,7,2,2,6,6,1,1,5,5,5,5,0,0,1,1,0,0,2,2,3,3,4,4,1,1,6,6,6,6,1,1,2,2,5,5,3,3,6,6,6,6,4,4,3,3,1,1,6,6,0,0,2,2,7,7,1,1,3,3,0,0,6,6,0,0,3,3,4,4,3,3,6,6,5,5,4,4,0,0,4,4,5,5,1,1,5,5,5,5,0,0,0,0,5,5,2,2,4,4,3,3,3,3,6,6,3,3,4,4,1,1,2,2,6,6,4,4,2,2,0,0,3,3,7,7,6,6,7,7,7,7,3,3,2,2,1,1,2,2,3,3,5,5,7,7,5,5,4,4,7,7,4,4,5,5,2,2,6,6,7,7,3,3,5,5,1,1,0,0,3,3,1,1,1,1,4,4,2,2,0,0,3,3,2,2,5,5,2,2,3,3,7,7,4,4,0,0,5,5,5,5,3,3,6,6,6,6,0,0,2,2,7,7,2,2,3,3,0,0,5,5,1,1,7,7,0,0,0,0,3,3,2,2,4,4,1,1,1,1,5,5,4,4,4,4,1,1,0,0,0,0,2,2,6,6,7,7,6,6,0,0,3,3,7,7,6,6,2,2,0,0,3,3,4,4,6,6,4,4,4,4,2,2,7,7,5,5,4,4,1,1,1,1,3,3,2,2,1,1,1,1,1,1,4,4,5,5,0,0,7,7,4,4,5,5,7,7,1,1,3,3,4,4,4,4,3,3,6,6,7,7,5,5,7,7,6,6,3,3,1,1,7,7,2,2,1,1,7,7,3,3,2,2,5,5,7,7,4,4,0,0,4,4,2,2,4,4,0,0,0,0,0,0,5,5,6,6,0,0,1,1,6,6,7,7,4,4,3,3,2,2,1,1,6,6,0,0,3,3,1,1,0,0,0,0,4,4,1,1,2,2,0,0,5,5,0,0,4,4,7,7,1,1,5,5,0,0,6,6,0,0,6,6,5,5,4,4,7,7,6,6,5,5,7,7,6,6,7,7,1,1,1,1,4,4,2,2,4,4,6,6,1,1,4,4,2,2,0,0,2,2,4,4,3,3,3,3,1,1,4,4,3,3,6,6,2,2,5,5,0,0,7,7,0,0,5,5,5,5,0,0,0,0,5,5,0,0,5,5,2,2,7,7,4,4,7,7,1,1,0,0,4,4,3,3,2,2,1,1,6,6,1,1,1,1,6,6,7,7,4,4,3,3,2,2,0,0,1,1,0,0,2,2,4,4,7,7,4,4,3,3,7,7,7,7,4,4,5,5,1,1,3,3,5,5,0,0,4,4,5,5,2,2,3,3,2,2,0,0,6,6,3,3,6,6,5,5,7,7,1,1,6,6,4,4,0,0,0,0,6,6,3,3,0,0,2,2,0,0,0,0,1,1,4,4,2,2,5,5,6,6,1,1,3,3,1,1,5,5,6,6,4,4,6,6,4,4,1,1,4,4,4,4,1,1,1,1,0,0,1,1,5,5,4,4,5,5,7,7,3,3,1,1,4,4,0,0,5,5,0,0,0,0,1,1,3,3,2,2,4,4,3,3,5,5,7,7,4,4,6,6,7,7,7,7,1,1,1,1,5,5,1,1,1,1,7,7,2,2,0,0,7,7,5,5,1,1,6,6,0,0,5,5,0,0,7,7,7,7,6,6,4,4,1,1,6,6,1,1,1,1,1,1,3,3,3,3,2,2,7,7,0,0,2,2,2,2,4,4,7,7,6,6,6,6,5,5,1,1,4,4,7,7,1,1,0,0,0,0,3,3,4,4,1,1,5,5,2,2,3,3,2,2,4,4,0,0,2,2,2,2,4,4,2,2,5,5,4,4,6,6,2,2,6,6,0,0,4,4,1,1,4,4,5,5,0,0,0,0,2,2,1,1,7,7,6,6,5,5,4,4,5,5,4,4,5,5,4,4,1,1,0,0,5,5,2,2,7,7,7,7,0,0,2,2,3,3,2,2,3,3,1,1,1,1,0,0,6,6,3,3,0,0,2,2,1,1,1,1,7,7,2,2,0,0,3,3,7,7,7,7,2,2,5,5,3,3,2,2,6,6,3,3,6,6,7,7,2,2,1,1,3,3,1,1,7,7,1,1,2,2,3,3,0,0,5,5,0,0,6,6,2,2,2,2,3,3,0,0,5,5,6,6,2,2,1,1,2,2,6,6,2,2,5,5,5,5,2,2,1,1,1,1,3,3,4,4,2,2,1,1,2,2,4,4,2,2,3,3,4,4,2,2,4,4,1,1,3,3,0,0,1,1,7,7,4,4,7,7,7,7,4,4,6,6,0,0,1,1,0,0,2,2,5,5,0,0,1,1,5,5,4,4,2,2,4,4,5,5,2,2,3,3,4,4,1,1,1,1,0,0,2,2,1,1,7,7,1,1,4,4,7,7,7,7,7,7,1,1,6,6,0,0,2,2,2,2,7,7,7,7,3,3,4,4,6,6,5,5,3,3,1,1,1,1,4,4,0,0,2,2,6,6,3,3,7,7,0,0,7,7,4,4,4,4,1,1,6,6,6,6,3,3,1,1,0,0,7,7,3,3,2,2,0,0,0,0,1,1,0,0,1,1,6,6,2,2,3,3,4,4,3,3,6,6,5,5,7,7,4,4,3,3,3,3,2,2,1,1,2,2,5,5,0,0,1,1,0,0,0,0,4,4,1,1,7,7,0,0,7,7,4,4,1,1,5,5,6,6,6,6,2,2,6,6,5,5,4,4,4,4,5,5,1,1,6,6,5,5,3,3,5,5,4,4,1,1,3,3,1,1,4,4,0,0,1,1,7,7,4,4,7,7,2,2,0,0,2,2,7,7,0,0,4,4,7,7,7,7,4,4,3,3,5,5,0,0,6,6,3,3,1,1,7,7,4,4,4,4,2,2,1,1,1,1,5,5,3,3,4,4,0,0,5,5,3,3,1,1,6,6,0,0,3,3,5,5,2,2,1,1,2,2,2,2,5,5,1,1,2,2,3,3,4,4,1,1,3,3,2,2,3,3,4,4,2,2,2,2,4,4,4,4,3,3,4,4,1,1,1,1,1,1,5,5,0,0,5,5,4,4,6,6,6,6,1,1,1,1,0,0,1,1,3,3,1,1,2,2,1,1,1,1,4,4,0,0,0,0,0,0,4,4,3,3,3,3,1,1,6,6,4,4,0,0,7,7,4,4,2,2,1,1,4,4,2,2,4,4,0,0,3,3,0,0,2,2,1,1,0,0,3,3,2,2,2,2,7,7,6,6,0,0,0,0,2,2,5,5,2,2,0,0,0,0,7,7,7,7,3,3,0,0,0,0,1,1,0,0,6,6,7,7,5,5,7,7,6,6,4,4,6,6,1,1,3,3,5,5,1,1,0,0,6,6,3,3,7,7,5,5,2,2,4,4,0,0,4,4,7,7,2,2,2,2,2,2,3,3,7,7,1,1,1,1,0,0,1,1,7,7,7,7,7,7,7,7,0,0,4,4,4,4,5,5,2,2,0,0,0,0,6,6,3,3,3,3,4,4,6,6,1,1,3,3,5,5,2,2,1,1,2,2,5,5,3,3,1,1,3,3,7,7,2,2,4,4,3,3,1,1,1,1,2,2,0,0,2,2,1,1,1,1,4,4,7,7,3,3,3,3,0,0,1,1,6,6,2,2,3,3,1,1,1,1,1,1,6,6,0,0,0,0,4,4,5,5,5,5,6,6,0,0,2,2,5,5,5,5,0,0,1,1,2,2,4,4,0,0,3,3,0,0,1,1,1,1,5,5,1,1,5,5,4,4,6,6,5,5,0,0,6,6,0,0,5,5,2,2,0,0,1,1,7,7,3,3,7,7,1,1,1,1,7,7,4,4,7,7,3,3,4,4,5,5,0,0,2,2,2,2,2,2,6,6,7,7,0,0,5,5,2,2,0,0,2,2,2,2,5,5,3,3,7,7,0,0,0,0,2,2,2,2,6,6,3,3,0,0,5,5,1,1,7,7,2,2,5,5,6,6,2,2,1,1,5,5,3,3,4,4,1,1,7,7,7,7,3,3,7,7,2,2,0,0,6,6,5,5,2,2,5,5,2,2,1,1,0,0,5,5,0,0,5,5,0,0,2,2,4,4,6,6,5,5,3,3,6,6,1,1,7,7,1,1,3,3,1,1,4,4,7,7,7,7,0,0,5,5,1,1,0,0,7,7,3,3,0,0,4,4,4,4,7,7,0,0,7,7,0,0,0,0,6,6,3,3,1,1,6,6,0,0,5,5,2,2,4,4,3,3,0,0,6,6,4,4,3,3,0,0,5,5,0,0,0,0,4,4,7,7,2,2,3,3,6,6,2,2,7,7,2,2,4,4,2,2,3,3,3,3,6,6,3,3,6,6,4,4,1,1,6,6,5,5,0,0,5,5,1,1,4,4,0,0,3,3,2,2,1,1,4,4,7,7,2,2,3,3,1,1,0,0,6,6,0,0,1,1,7,7,0,0,1,1,6,6,2,2,4,4,4,4,1,1,7,7,0,0,2,2,1,1,0,0,5,5,3,3,4,4,3,3,3,3,0,0,3,3,0,0,4,4,7,7,0,0,7,7,2,2,2,2,4,4,5,5,4,4,5,5,3,3,0,0,3,3,4,4,2,2,3,3,2,2,5,5,5,5,1,1,5,5,2,2,4,4,3,3,2,2,4,4,7,7,7,7,2,2,3,3,2,2,0,0,2,2,1,1,6,6,0,0,4,4,5,5,0,0,4,4,3,3,2,2,1,1,6,6,4,4,6,6,2,2,0,0,5,5,1,1,2,2,3,3,2,2,0,0,2,2,6,6,5,5,3,3,2,2,1,1,0,0,0,0,7,7,6,6,6,6,3,3,5,5,3,3,1,1,6,6,7,7,3,3,2,2,2,2,6,6,3,3,4,4,5,5,4,4,5,5,0,0,3,3,0,0,5,5,6,6,6,6,7,7,7,7,3,3,3,3,7,7,4,4,3,3,1,1,3,3,6,6,4,4,0,0,7,7,6,6,3,3,6,6,6,6,0,0,5,5,2,2,7,7,5,5,6,6,0,0,2,2,0,0,0,0,6,6,0,0,1,1,3,3,1,1,3,3,4,4,6,6,6,6,7,7,3,3,3,3,6,6,0,0,3,3,6,6,0,0,4,4,4,4,4,4,2,2,2,2,2,2,2,2,1,1,5,5,1,1,2,2,3,3,3,3,1,1,2,2,7,7,2,2,1,1,0,0,3,3,3,3,4,4,2,2,5,5,6,6,1,1,0,0,4,4,1,1,3,3,1,1,1,1,0,0,4,4,5,5,5,5,2,2,1,1,5,5,1,1,4,4,6,6,1,1,0,0,4,4,5,5,5,5,2,2,1,1,2,2,1,1,1,1,1,1,3,3,6,6,4,4,2,2,0,0,4,4,5,5,2,2,5,5,4,4,7,7,4,4,2,2,1,1,3,3,0,0,2,2,1,1,2,2,2,2,2,2,7,7,4,4,0,0,5,5,5,5,2,2,4,4,0,0,2,2,1,1,1,1,5,5,3,3,6,6,6,6,2,2,2,2,1,1,5,5,3,3,1,1,3,3,7,7,5,5,2,2,3,3,5,5,3,3,5,5,6,6,2,2,4,4,2,2,0,0,3,3,1,1,7,7,3,3,2,2,6,6,2,2,7,7,7,7,2,2,4,4,5,5,0,0,0,0,1,1,3,3,6,6,1,1,2,2,6,6,5,5,5,5,7,7,1,1,7,7,0,0,2,2,7,7,3,3,6,6,7,7,7,7,7,7,1,1,0,0,2,2,4,4,2,2,4,4,4,4,1,1,6,6,3,3,6,6,7,7,1,1,7,7,0,0,6,6,2,2,7,7,6,6,3,3,0,0,5,5,4,4,4,4,7,7,1,1,7,7,1,1,3,3,2,2,6,6,7,7,5,5,1,1,3,3,2,2,6,6,1,1,5,5,4,4,2,2,0,0,7,7,4,4,5,5,2,2,7,7,1,1,6,6,5,5,4,4,2,2,2,2,2,2,5,5,3,3,4,4,5,5,1,1,0,0,4,4,4,4,0,0,6,6,7,7,1,1,3,3,7,7,2,2,7,7,0,0,5,5,3,3,0,0,5,5,5,5,0,0,0,0,5,5,4,4,6,6,3,3,5,5,5,5,5,5,7,7,4,4,4,4,7,7,2,2,1,1,0,0,0,0,4,4,2,2,2,2,5,5,1,1,6,6,1,1,1,1,1,1,7,7,4,4,6,6,4,4,3,3,1,1,3,3,0,0,1,1,0,0,1,1,5,5,6,6,1,1,1,1,4,4,4,4,3,3,5,5,7,7,3,3,7,7,1,1,2,2,4,4,0,0,3,3,4,4,6,6,2,2,6,6,2,2,0,0,2,2,1,1,3,3,5,5,3,3,1,1,1,1,2,2,0,0,1,1,3,3,0,0,4,4,2,2,0,0,7,7,7,7,6,6,7,7,5,5,6,6,7,7,3,3,4,4,5,5,5,5,0,0,0,0,3,3,3,3,1,1,3,3,6,6,5,5,2,2,0,0,0,0,3,3,7,7,0,0,2,2,4,4,4,4,2,2,5,5,2,2,0,0,0,0,0,0,5,5,2,2,6,6,3,3,6,6,2,2,0,0,0,0,5,5,1,1,1,1,4,4,4,4,2,2,1,1,4,4,4,4,1,1,7,7,5,5,7,7,7,7,1,1,7,7,3,3,7,7,1,1,3,3,3,3,1,1,5,5,1,1,2,2,2,2,1,1,6,6,0,0,2,2,7,7,6,6,5,5,5,5,2,2,2,2,3,3,4,4,4,4,7,7,7,7,2,2,6,6,6,6,4,4,1,1,0,0,4,4,3,3,1,1,0,0,0,0,4,4,2,2,3,3,3,3,0,0,7,7,4,4,5,5,5,5,5,5,1,1,3,3,6,6,3,3,3,3,2,2,6,6,5,5,1,1,7,7,2,2,4,4,1,1,3,3,2,2,1,1,4,4,5,5,1,1,0,0,7,7,7,7,7,7,5,5,6,6,6,6,1,1,3,3,7,7,0,0,7,7,4,4,5,5,7,7,4,4,3,3,6,6,2,2,2,2,5,5,5,5,6,6,4,4,3,3,1,1,4,4,0,0,5,5,2,2,0,0,5,5,0,0,5,5,3,3,6,6,0,0,7,7,3,3,6,6,4,4,5,5,7,7,2,2,0,0,5,5,4,4,3,3,0,0,3,3,0,0,3,3,7,7,5,5,3,3,1,1,5,5,3,3,4,4,5,5,5,5,3,3,0,0,1,1,6,6,0,0,4,4,1,1,5,5,4,4,4,4,7,7,3,3,2,2,0,0,2,2,7,7,0,0,4,4,6,6,6,6,6,6,4,4,7,7,2,2,5,5,1,1,7,7,7,7,1,1,4,4,3,3,4,4,5,5,7,7,0,0,5,5,5,5,0,0,7,7,3,3,1,1,4,4,6,6,0,0,1,1,5,5,7,7,3,3,4,4,3,3,1,1,0,0,2,2,3,3,5,5,3,3,3,3,1,1,5,5,4,4,5,5,5,5,1,1,2,2,2,2,5,5,6,6,4,4,1,1,6,6,5,5,6,6,3,3,7,7,2,2,0,0,7,7,5,5,0,0,3,3,5,5,0,0,4,4,7,7,5,5,2,2,1,1,4,4,3,3,0,0,4,4,1,1,3,3,2,2,3,3,1,1,0,0,3,3,7,7,0,0,6,6,1,1,3,3,0,0,4,4,2,2,3,3,4,4,0,0,6,6,7,7,0,0,3,3,2,2,7,7,1,1,4,4,3,3,4,4,1,1,3,3,3,3,1,1,0,0,7,7,0,0,7,7,5,5,0,0,7,7,0,0,7,7,5,5,6,6,1,1,7,7,1,1,4,4,4,4,4,4,1,1,0,0,4,4,6,6,3,3,5,5,4,4,4,4,7,7,0,0,5,5,0,0,5,5,2,2,0,0,4,4,6,6,3,3,3,3,2,2,0,0,2,2,7,7,6,6,3,3,0,0,0,0,7,7,3,3,1,1,1,1,1,1,4,4,7,7,6,6,4,4,7,7,1,1,0,0,0,0,1,1,2,2,7,7,3,3,1,1,2,2,3,3,5,5,7,7,3,3,5,5,6,6,7,7,1,1,3,3,6,6,1,1,4,4,0,0,1,1,7,7,3,3,1,1,0,0,2,2,2,2,6,6,2,2,6,6,2,2,6,6,2,2,4,4,6,6,4,4,3,3,0,0,6,6,0,0,4,4,4,4,6,6,6,6,6,6,5,5,2,2,6,6,4,4,6,6,4,4,0,0,1,1,5,5,0,0,1,1,3,3,2,2,0,0,7,7,4,4,6,6,3,3,3,3,1,1,2,2,3,3,3,3,6,6,1,1,1,1,1,1,5,5,5,5,6,6,1,1,1,1,7,7,4,4,4,4,7,7,5,5,5,5,3,3,4,4,0,0,0,0,4,4,4,4,3,3,2,2,0,0,3,3,0,0,0,0,0,0,1,1,7,7,3,3,6,6,0,0,1,1,3,3,3,3,0,0,5,5,2,2,3,3,6,6,7,7,3,3,1,1,7,7,5,5,7,7,5,5,1,1,4,4,4,4,1,1,4,4,3,3,1,1,5,5,6,6,3,3,6,6,6,6,3,3,5,5,0,0,3,3,2,2,6,6,0,0,5,5,3,3,5,5,3,3,2,2,1,1,4,4,6,6,3,3,3,3,3,3,3,3,4,4,4,4,4,4,5,5,1,1,1,1,7,7,1,1,6,6,5,5,4,4,2,2,5,5,6,6,7,7,3,3,1,1,0,0,4,4,4,4,0,0,6,6,5,5,4,4,0,0,4,4,5,5,0,0,6,6,0,0,0,0,4,4,3,3,3,3,2,2,5,5,7,7,2,2,1,1,7,7,2,2,4,4,1,1,5,5,6,6,4,4,2,2,6,6,3,3,3,3,4,4,3,3,1,1,1,1,5,5,0,0,0,0,5,5,7,7,7,7,7,7,5,5,4,4,1,1,7,7,4,4,5,5,6,6,3,3,4,4,2,2,4,4,3,3,0,0,7,7,4,4,2,2,0,0,4,4,1,1,1,1,3,3,2,2,5,5,7,7,4,4,0,0,2,2,2,2,7,7,5,5,6,6,3,3,7,7,6,6,3,3,0,0,3,3,2,2,0,0,5,5,2,2,7,7,5,5,4,4,3,3,6,6,7,7,1,1,1,1,1,1,3,3,6,6,0,0,5,5,2,2,3,3,5,5,3,3,3,3,2,2,5,5,4,4,1,1,3,3,3,3,5,5,0,0,6,6,5,5,2,2,3,3,1,1,7,7,1,1,1,1,5,5,2,2,7,7,5,5,0,0,2,2,3,3,0,0,0,0,6,6,2,2,6,6,0,0,7,7,4,4,4,4,0,0,6,6,6,6,2,2,7,7,7,7,6,6,6,6,2,2,5,5,0,0,4,4,6,6,1,1,1,1,4,4,5,5,4,4,4,4,3,3,6,6,5,5,5,5,6,6,4,4,2,2,6,6,7,7,3,3,2,2,2,2,1,1,1,1,0,0,7,7,1,1,5,5,0,0,2,2,0,0,4,4,3,3,4,4,2,2,1,1,7,7,0,0,7,7,4,4,5,5,2,2,3,3,5,5,5,5,0,0,5,5,4,4,4,4,0,0,1,1,4,4,1,1,6,6,6,6,6,6,1,1,0,0,6,6,5,5,4,4,0,0,3,3,6,6,0,0,5,5,6,6,0,0,1,1,0,0,7,7,0,0,2,2,4,4,2,2,3,3,0,0,3,3,2,2,7,7,0,0,7,7,5,5,4,4,3,3,3,3,6,6,0,0,2,2,7,7,7,7,6,6,0,0,6,6,6,6,5,5,2,2,4,4,5,5,2,2,6,6,5,5,4,4,6,6,0,0,4,4,6,6,0,0,0,0,0,0,2,2,5,5,0,0,4,4,1,1,7,7,7,7,7,7,5,5,0,0,3,3,5,5,2,2,1,1,6,6,0,0,3,3,2,2,5,5,6,6,2,2,1,1,5,5,2,2,3,3,3,3,7,7,2,2,6,6,6,6,3,3,0,0,6,6,5,5,2,2,3,3,1,1,1,1,1,1,6,6,4,4,0,0,1,1,7,7,2,2,0,0,7,7,1,1,3,3,1,1,5,5,6,6,1,1,0,0,1,1,7,7,2,2,3,3,2,2,4,4,3,3,4,4,1,1,0,0,1,1,1,1,3,3,0,0,7,7,0,0,3,3,2,2,0,0,0,0,7,7,5,5,1,1,5,5,5,5,1,1,2,2,6,6,2,2,0,0,2,2,2,2,7,7,6,6,6,6,4,4,0,0,1,1,4,4,3,3,0,0,1,1,3,3,1,1,2,2,2,2,0,0,4,4,3,3,0,0,5,5,2,2,5,5,1,1,5,5,5,5,5,5,6,6,4,4,3,3,3,3,4,4,5,5,7,7,5,5,5,5,0,0,3,3,0,0,4,4,7,7,2,2,5,5,5,5,5,5,0,0,4,4,2,2,3,3,3,3,0,0,6,6,6,6,3,3,1,1,1,1,6,6,7,7,7,7,1,1,0,0,2,2,2,2,6,6,5,5,4,4,6,6,4,4,0,0,5,5,4,4,7,7,2,2,0,0,0,0,7,7,3,3,3,3,4,4,6,6,4,4,1,1,2,2,5,5,0,0,2,2,6,6,1,1,2,2,7,7,0,0,6,6,0,0,4,4,6,6,5,5,5,5,1,1,5,5,5,5,5,5,5,5,5,5,5,5,6,6,1,1,1,1,1,1,5,5,4,4,2,2,6,6,0,0,0,0,4,4,0,0,1,1,1,1,3,3,5,5,6,6,1,1,1,1,6,6,4,4,7,7,6,6,2,2,6,6,4,4,2,2,1,1,5,5,5,5,7,7,5,5,7,7,3,3,5,5,4,4,7,7,0,0,5,5,0,0,3,3,2,2,1,1,5,5,5,5,4,4,0,0,6,6,7,7,4,4,2,2,4,4,1,1,1,1,1,1,3,3,2,2,2,2,1,1,6,6,3,3,6,6,3,3,1,1,6,6,0,0,5,5,7,7,7,7,1,1,7,7,0,0,4,4,0,0,3,3,1,1,4,4,5,5,4,4,0,0,3,3,5,5,4,4,4,4,4,4,4,4,6,6,3,3,0,0,2,2,3,3,7,7,0,0,0,0,0,0,7,7,5,5,0,0,2,2,4,4,3,3,0,0,4,4,6,6,7,7,3,3,4,4,2,2,6,6,5,5,2,2,3,3,2,2,3,3,0,0,0,0,0,0,4,4,4,4,7,7,1,1,1,1,3,3,1,1,7,7,5,5,4,4,1,1,1,1,2,2,0,0,4,4,1,1,0,0,5,5,6,6,7,7,1,1,1,1,3,3,2,2,3,3,0,0,3,3,6,6,2,2,7,7,6,6,0,0,6,6,6,6,1,1,0,0,4,4,1,1,0,0,7,7,4,4,5,5,5,5,1,1,2,2,2,2,6,6,4,4,0,0,6,6,7,7,4,4,5,5,1,1,5,5,2,2,1,1,0,0,2,2,4,4,7,7,5,5,3,3,5,5,2,2,2,2,6,6,0,0,3,3,6,6,5,5,0,0,4,4,0,0,0,0,0,0,6,6,2,2,1,1,1,1,3,3,5,5,2,2,2,2,6,6,5,5,1,1,2,2,5,5,5,5,2,2,4,4,2,2,5,5,6,6,3,3,7,7,6,6,7,7,3,3,5,5,4,4,3,3,2,2,5,5,6,6,6,6,1,1,1,1,4,4,5,5,0,0,3,3,4,4,6,6,4,4,7,7,7,7,6,6,1,1,5,5,1,1,2,2,2,2,5,5,4,4,5,5,1,1,0,0,2,2,6,6,2,2,3,3,7,7,6,6,0,0,7,7,1,1,5,5,7,7,6,6,0,0,4,4,0,0,1,1,5,5,0,0,2,2,6,6,7,7,6,6,5,5,6,6,7,7,6,6,0,0,0,0,2,2,5,5,6,6,1,1,6,6,7,7,2,2,4,4,2,2,1,1,2,2,2,2,5,5,4,4,0,0,2,2,4,4,2,2,5,5,4,4,5,5,4,4,4,4,1,1,4,4,2,2,7,7,5,5,1,1,6,6,3,3,3,3,1,1,1,1,1,1,0,0,3,3,7,7,4,4,0,0,1,1,1,1,3,3,3,3,0,0,0,0,1,1,0,0,1,1,4,4,0,0,5,5,7,7,1,1,3,3,6,6,6,6,2,2,3,3,5,5,1,1,1,1,2,2,6,6,7,7,6,6,4,4,5,5,5,5,4,4,5,5,0,0,7,7,1,1,4,4,4,4,1,1,1,1,7,7,4,4,5,5,6,6,0,0,5,5,2,2,1,1,2,2,6,6,0,0,5,5,1,1,3,3,7,7,1,1,2,2,3,3,4,4,7,7,0,0,2,2,1,1,4,4,2,2,1,1,1,1,2,2,0,0,3,3,5,5,2,2,7,7,2,2,4,4,1,1,1,1,7,7,7,7,6,6,3,3,3,3,7,7,0,0,4,4,0,0,6,6,7,7,5,5,4,4,5,5,3,3,5,5,4,4,0,0,0,0,3,3,4,4,3,3,1,1,7,7,3,3,3,3,6,6,2,2,2,2,6,6,2,2,7,7,6,6,3,3,0,0,2,2,4,4,3,3,7,7,7,7,0,0,6,6,2,2,4,4,5,5,3,3,5,5,6,6,7,7,4,4,0,0,0,0,2,2,3,3,6,6,1,1,2,2,4,4,3,3,3,3,2,2,1,1,7,7,0,0,4,4,5,5,3,3,1,1,6,6,0,0,3,3,5,5,2,2,4,4,1,1,4,4,4,4,0,0,2,2,6,6,3,3,1,1,5,5,7,7,2,2,7,7,1,1,4,4,4,4,5,5,1,1,3,3,3,3,0,0,2,2,4,4,2,2,7,7,1,1,2,2,4,4,0,0,0,0,1,1,4,4,1,1,5,5,5,5,1,1,0,0,1,1,1,1,4,4,2,2,3,3,6,6,3,3,5,5,1,1,4,4,0,0,1,1,1,1,2,2,0,0,1,1,2,2,7,7,2,2,6,6,2,2,3,3,2,2,3,3,5,5,5,5,6,6,4,4,0,0,5,5,2,2,0,0,3,3,7,7,0,0,7,7,7,7,5,5,5,5,1,1,4,4,1,1,4,4,1,1,0,0,1,1,4,4,3,3,0,0,2,2,3,3,6,6,0,0,1,1,4,4,1,1,0,0,0,0,3,3,4,4,6,6,3,3,5,5,6,6,3,3,2,2,7,7,6,6,0,0,2,2,5,5,2,2,3,3,0,0,3,3,3,3,1,1,2,2,7,7,6,6,0,0,5,5,5,5,4,4,7,7,2,2,7,7,5,5,7,7,7,7,1,1,1,1,7,7,2,2,0,0,3,3,5,5,0,0,6,6,2,2,1,1,3,3,6,6,7,7,3,3,2,2,2,2,7,7,7,7,6,6,1,1,1,1,2,2,4,4,2,2,3,3,1,1,5,5,2,2,7,7,6,6,6,6,3,3,2,2,0,0,5,5,0,0,6,6,5,5,7,7,0,0,3,3,0,0,4,4,0,0,0,0,5,5,3,3,0,0,5,5,0,0,7,7,1,1,0,0,3,3,1,1,6,6,1,1,1,1,2,2,0,0,4,4,4,4,2,2,2,2,6,6,6,6,0,0,7,7,0,0,0,0,7,7,5,5,7,7,4,4,1,1,4,4,4,4,5,5,2,2,2,2,4,4,7,7,4,4,2,2,4,4,4,4,0,0,6,6,4,4,0,0,4,4,4,4,6,6,4,4,2,2,6,6,4,4,2,2,1,1,7,7,0,0,0,0,6,6,7,7,1,1,5,5,5,5,5,5,3,3,0,0,1,1,5,5,3,3,1,1,5,5,4,4,0,0,3,3,3,3,5,5,0,0,3,3,0,0,4,4,7,7,7,7,0,0,5,5,7,7,2,2,7,7,2,2,6,6,3,3,2,2,2,2,3,3,6,6,4,4,5,5,3,3,2,2,1,1,6,6,6,6,4,4,0,0,7,7,0,0,0,0,7,7,5,5,6,6,3,3,4,4,2,2,5,5,4,4,6,6,2,2,4,4,4,4,7,7,5,5,2,2,3,3,5,5,6,6,5,5,7,7,0,0,4,4,4,4,4,4,4,4,2,2,5,5,3,3,3,3,0,0,7,7,5,5,3,3,7,7,7,7,0,0,2,2,5,5,2,2,0,0,6,6,0,0,2,2,6,6,2,2,0,0,0,0,4,4,6,6,3,3,4,4,4,4,4,4,4,4,1,1,4,4,2,2,4,4,4,4,1,1,1,1,2,2,1,1,4,4,2,2,7,7,4,4,7,7,2,2,6,6,7,7,1,1,4,4,5,5,3,3,1,1,6,6,5,5,4,4,7,7,1,1,3,3,0,0,7,7,2,2,5,5,1,1,2,2,0,0,4,4,7,7,2,2,5,5,5,5,7,7,4,4,7,7,1,1,0,0,3,3,1,1,1,1,3,3,5,5,3,3,0,0,4,4,3,3,2,2,2,2,3,3,7,7,2,2,6,6,0,0,1,1,5,5,0,0,3,3,6,6,0,0,5,5,7,7,2,2,3,3,3,3,7,7,5,5,2,2,3,3,7,7,6,6,0,0,0,0,3,3,4,4,2,2,5,5,3,3,5,5,4,4,0,0,4,4,7,7,6,6,1,1,5,5,4,4,6,6,5,5,4,4,3,3,4,4,1,1,5,5,3,3,1,1,4,4,7,7,5,5,3,3,2,2,1,1,2,2,3,3,7,7,2,2,4,4,5,5,7,7,4,4,3,3,1,1,0,0,5,5,7,7,2,2,6,6,3,3,1,1,5,5,0,0,0,0,6,6,6,6,2,2,5,5,0,0,3,3,1,1,7,7,3,3,1,1,2,2,4,4,7,7,0,0,7,7,0,0,1,1,2,2,7,7,2,2,6,6,7,7,2,2,0,0,6,6,2,2,5,5,3,3,6,6,6,6,1,1,6,6,7,7,2,2,4,4,0,0,4,4,1,1,7,7,5,5,3,3,2,2,2,2,1,1,4,4,3,3,1,1,3,3,5,5,6,6,4,4,4,4,0,0,0,0,3,3,2,2,5,5,5,5,1,1,4,4,0,0,0,0,2,2,7,7,2,2,0,0,1,1,0,0,4,4,1,1,2,2,7,7,3,3,1,1,5,5,5,5,7,7,3,3,3,3,6,6,5,5,7,7,2,2,3,3,0,0,1,1,4,4,5,5,2,2,1,1,0,0,5,5,3,3,2,2,1,1,4,4,0,0,0,0,2,2,5,5,1,1,5,5,6,6,0,0,1,1,7,7,2,2,6,6,4,4,3,3,2,2,0,0,1,1,7,7,3,3,1,1,7,7,5,5,0,0,1,1,6,6,1,1,5,5,3,3,4,4,1,1,0,0,5,5,2,2,7,7,4,4,1,1,4,4,7,7,3,3,1,1,5,5,1,1,0,0,1,1,4,4,6,6,5,5,2,2,2,2,5,5,7,7,4,4,5,5,2,2,4,4,6,6,1,1,3,3,7,7,1,1,4,4,6,6,4,4,2,2,6,6,2,2,4,4,3,3,4,4,3,3,3,3,6,6,3,3,3,3,0,0,0,0,4,4,2,2,2,2,2,2,4,4,2,2,2,2,6,6,0,0,0,0,4,4,1,1,6,6,2,2,0,0,2,2,5,5,4,4,6,6,4,4,7,7,2,2,2,2,3,3,5,5,1,1,3,3,0,0,0,0,3,3,0,0,2,2,5,5,2,2,6,6,7,7,5,5,6,6,0,0,7,7,4,4,0,0,4,4,2,2,2,2,2,2,7,7,6,6,4,4,5,5,4,4,7,7,5,5,1,1,0,0,1,1,2,2,5,5,4,4,0,0,7,7,4,4,4,4,4,4,0,0,2,2,7,7,6,6,2,2,5,5,6,6,3,3,0,0,4,4,7,7,0,0,6,6,6,6,2,2,1,1,1,1,0,0,3,3,4,4,3,3,6,6,0,0,4,4,6,6,2,2,4,4,6,6,3,3,1,1,6,6,2,2,0,0,1,1,6,6,6,6,2,2,6,6,1,1,7,7,7,7,6,6,2,2,1,1,2,2,1,1,0,0,5,5,1,1,3,3,5,5,6,6,5,5,1,1,2,2,7,7,7,7,4,4,5,5,5,5,6,6,6,6,7,7,6,6,4,4,4,4,4,4,0,0,7,7,1,1,3,3,5,5,4,4,5,5,2,2,1,1,6,6,0,0,7,7,5,5,1,1,3,3,0,0,5,5,3,3,5,5,2,2,3,3,7,7,4,4,0,0,4,4,6,6,5,5,1,1,5,5,2,2,4,4,2,2,6,6,6,6,0,0,1,1,7,7,4,4,6,6,0,0,0,0,2,2,3,3,5,5,0,0,0,0,5,5,2,2,2,2,6,6,7,7,4,4,3,3,4,4,6,6,1,1,5,5,4,4,4,4,6,6,2,2,2,2,1,1,6,6,2,2,0,0,3,3,0,0,1,1,6,6,3,3,6,6,0,0,5,5,7,7,5,5,2,2,0,0,4,4,0,0,2,2,3,3,0,0,3,3,5,5,7,7,4,4,3,3,0,0,2,2,6,6,3,3,6,6,6,6,7,7,2,2,2,2,7,7,0,0,1,1,3,3,4,4,1,1,5,5,0,0,3,3,3,3,1,1,3,3,6,6,4,4,1,1,1,1,4,4,2,2,4,4,3,3,6,6,0,0,1,1,1,1,1,1,2,2,1,1,6,6,2,2,1,1,6,6,7,7,5,5,7,7,7,7,7,7,5,5,2,2,3,3,2,2,2,2,5,5,4,4,1,1,2,2,6,6,0,0,3,3,4,4,6,6,6,6,5,5,3,3,1,1,6,6,0,0,0,0,1,1,2,2,0,0,1,1,4,4,6,6,3,3,6,6,1,1,1,1,3,3,4,4,6,6,2,2,0,0,1,1,1,1,0,0,7,7,4,4,6,6,4,4,2,2,6,6,2,2,4,4,6,6,1,1,5,5,0,0,6,6,5,5,2,2,3,3,2,2,3,3,0,0,2,2,0,0,6,6,3,3,2,2,2,2,0,0,2,2,5,5,5,5,3,3,1,1,0,0,1,1,0,0,6,6,4,4,4,4,5,5,0,0,6,6,1,1,7,7,7,7,1,1,3,3,4,4,0,0,1,1,7,7,3,3,2,2,1,1,7,7,4,4,4,4,2,2,2,2,4,4,3,3,0,0,4,4,5,5,7,7,2,2,6,6,3,3,4,4,0,0,2,2,7,7,2,2,3,3,3,3,5,5,4,4,5,5,7,7,2,2,5,5,1,1,4,4,7,7,0,0,4,4,2,2,3,3,5,5,3,3,1,1,6,6,2,2,3,3,3,3,3,3,1,1,7,7,0,0,7,7,6,6,6,6,4,4,6,6,2,2,7,7,6,6,0,0,5,5,2,2,6,6,5,5,0,0,0,0,4,4,6,6,3,3,3,3,2,2,3,3,7,7,4,4,2,2,5,5,2,2,3,3,5,5,0,0,3,3,1,1,4,4,0,0,2,2,1,1,0,0,6,6,1,1,0,0,6,6,4,4,4,4,0,0,1,1,2,2,7,7,4,4,7,7,2,2,4,4,1,1,6,6,1,1,0,0,6,6,0,0,0,0,6,6,5,5,6,6,0,0,7,7,6,6,2,2,3,3,6,6,2,2,3,3,1,1,4,4,0,0,3,3,7,7,1,1,6,6,3,3,4,4,3,3,6,6,2,2,3,3,7,7,0,0,6,6,1,1,5,5,4,4,0,0,1,1,4,4,6,6,7,7,2,2,3,3,6,6,0,0,7,7,7,7,0,0,4,4,4,4,3,3,0,0,0,0,2,2,0,0,0,0,2,2,0,0,5,5,5,5,1,1,5,5,2,2,4,4,7,7,1,1,3,3,7,7,0,0,6,6,4,4,1,1,0,0,3,3,0,0,0,0,1,1,7,7,0,0,7,7,0,0,0,0,6,6,2,2,4,4,3,3,0,0,0,0,5,5,1,1,2,2,0,0,7,7,7,7,7,7,1,1,0,0,7,7,0,0,5,5,3,3,4,4,3,3,3,3,5,5,2,2,0,0,4,4,4,4,6,6,2,2,7,7,0,0,2,2,5,5,1,1,6,6,4,4,2,2,3,3,2,2,2,2,0,0,7,7,6,6,1,1,7,7,2,2,0,0,6,6,5,5,1,1,5,5,3,3,5,5,3,3,3,3,4,4,7,7,6,6,4,4,2,2,0,0,1,1,0,0,4,4,2,2,0,0,3,3,7,7,3,3,6,6,3,3,4,4,1,1,5,5,1,1,5,5,3,3,1,1,2,2,5,5,4,4,6,6,4,4,0,0,2,2,6,6,2,2,4,4,4,4,4,4,3,3,4,4,6,6,0,0,1,1,1,1,1,1,7,7,1,1,4,4,4,4,4,4,4,4,5,5,1,1,3,3,3,3,0,0,7,7,6,6,7,7,0,0,7,7,7,7,5,5,3,3,1,1,3,3,7,7,6,6,5,5,1,1,5,5,4,4,6,6,1,1,2,2,5,5,0,0,3,3,5,5,1,1,7,7,3,3,4,4,4,4,6,6,7,7,6,6,0,0,3,3,7,7,3,3,0,0,1,1,6,6,4,4,4,4,3,3,1,1,1,1,6,6,7,7,4,4,5,5,2,2,4,4,6,6,2,2,1,1,5,5,2,2,0,0,7,7,1,1,5,5,3,3,0,0,1,1,2,2,3,3,2,2,7,7,1,1,2,2,2,2,5,5,2,2,2,2,0,0,7,7,3,3,3,3,6,6,1,1,2,2,3,3,5,5,3,3,4,4,7,7,5,5,4,4,2,2,4,4,5,5,1,1,0,0,0,0,1,1,0,0,4,4,1,1,1,1,7,7,4,4,7,7,3,3,0,0,5,5,0,0,1,1,5,5,0,0,3,3,1,1,1,1,2,2,2,2,2,2,0,0,0,0,2,2,6,6,5,5,3,3,5,5,6,6,0,0,5,5,6,6,0,0,1,1,6,6,2,2,7,7,2,2,4,4,1,1,1,1,6,6,2,2,3,3,3,3,5,5,2,2,5,5,2,2,3,3,4,4,6,6,4,4,0,0,7,7,5,5,1,1,3,3,0,0,1,1,3,3,7,7,0,0,0,0,1,1,7,7,6,6,2,2,5,5,0,0,2,2,6,6,1,1,1,1,2,2,1,1,2,2,7,7,1,1,4,4,3,3,0,0,3,3,4,4,4,4,3,3,1,1,4,4,6,6,7,7,2,2,4,4,7,7,3,3,2,2,6,6,4,4,4,4,5,5,5,5,4,4,7,7,5,5,5,5,1,1,1,1,7,7,5,5,7,7,4,4,5,5,1,1,3,3,4,4,6,6,1,1,1,1,7,7,1,1,3,3,3,3,5,5,2,2,0,0,7,7,5,5,3,3,3,3,3,3,5,5,0,0,2,2,3,3,3,3,4,4,5,5,6,6,2,2,1,1,4,4,2,2,6,6,0,0,2,2,6,6,2,2,3,3,6,6,4,4,7,7,0,0,5,5,5,5,5,5,7,7,0,0,4,4,5,5,2,2,6,6,1,1,7,7,5,5,1,1,2,2,2,2,0,0,1,1,0,0,0,0,2,2,1,1,6,6,5,5,2,2,0,0,2,2,0,0,1,1,1,1,0,0,4,4,7,7,6,6,2,2,0,0,4,4,5,5,2,2,7,7,3,3,1,1,0,0,4,4,2,2,0,0,6,6,1,1,0,0,6,6,1,1,0,0,4,4,6,6,6,6,0,0,0,0,3,3,7,7,6,6,6,6,0,0,0,0,0,0,4,4,1,1,0,0,5,5,3,3,5,5,0,0,1,1,2,2,3,3,1,1,4,4,0,0,3,3,1,1,1,1,6,6,5,5,4,4,2,2,4,4,7,7,6,6,5,5,3,3,6,6,5,5,4,4,1,1,4,4,5,5,3,3,7,7,4,4,2,2,0,0,7,7,2,2,4,4,6,6,6,6,4,4,7,7,3,3,0,0,0,0,6,6,1,1,7,7,3,3,1,1,0,0,7,7,2,2,2,2,2,2,3,3,2,2,4,4,7,7,3,3,2,2,5,5,5,5,6,6,0,0,7,7,0,0,0,0,0,0,0,0,0,0,2,2,0,0,5,5,5,5,4,4,6,6,2,2,0,0,5,5,4,4,0,0,1,1,0,0,1,1,7,7,5,5,5,5,3,3,6,6,6,6,4,4,5,5,3,3,2,2,5,5,6,6,6,6,7,7,3,3,2,2,6,6,3,3,0,0,7,7,4,4,2,2,0,0,4,4,6,6,5,5,2,2,1,1,5,5,5,5,4,4,7,7,5,5,4,4,6,6,2,2,0,0,6,6,7,7,1,1,5,5,4,4,7,7,2,2,7,7,6,6,3,3,5,5,1,1,0,0,2,2,2,2,3,3,7,7,6,6,6,6,2,2,6,6,1,1,7,7,6,6,4,4,1,1,4,4,0,0,7,7,6,6,2,2,7,7,4,4,4,4,7,7,3,3,1,1,3,3,0,0,5,5,1,1,4,4,5,5,6,6,6,6,4,4,7,7,5,5,2,2,7,7,3,3,5,5,3,3,1,1,7,7,4,4,1,1,7,7,0,0,6,6,6,6,7,7,2,2,4,4,7,7,0,0,6,6,0,0,3,3,5,5,1,1,3,3,2,2,4,4,1,1,1,1,1,1,3,3,4,4,2,2,7,7,6,6,1,1,1,1,1,1,6,6,2,2,3,3,5,5,4,4,6,6,0,0,2,2,1,1,4,4,2,2,0,0,3,3,1,1,4,4,6,6,4,4,6,6,3,3,0,0,2,2,7,7,0,0,2,2,0,0,1,1,0,0,4,4,1,1,0,0,2,2,2,2,1,1,2,2,0,0,1,1,3,3,6,6,7,7,6,6,0,0,2,2,6,6,0,0,6,6,1,1,2,2,7,7,4,4,2,2,6,6,5,5,1,1,5,5,5,5,0,0,2,2,4,4,4,4,6,6,1,1,0,0,2,2,4,4,3,3,2,2,2,2,4,4,5,5,6,6,5,5,2,2,4,4,6,6,2,2,5,5,7,7,0,0,2,2,6,6,3,3,1,1,4,4,4,4,0,0,2,2,4,4,6,6,5,5,0,0,6,6,6,6,3,3,7,7,7,7,4,4,5,5,0,0,3,3,5,5,5,5,4,4,0,0,0,0,6,6,3,3,2,2,1,1,5,5,0,0,7,7,4,4,6,6,1,1,6,6,5,5,6,6,0,0,4,4,0,0,6,6,5,5,4,4,2,2,0,0,5,5,1,1,6,6,0,0,3,3,5,5,5,5,1,1,6,6,1,1,7,7,0,0,5,5,2,2,3,3,6,6,5,5,2,2,2,2,7,7,5,5,0,0,2,2,0,0,1,1,4,4,6,6,0,0,3,3,7,7,1,1,1,1,4,4,3,3,0,0,1,1,0,0,5,5,5,5,3,3,1,1,0,0,4,4,7,7,1,1,2,2,5,5,3,3,2,2,3,3,1,1,1,1,2,2,4,4,2,2,2,2,3,3,6,6,0,0,5,5,2,2,6,6,2,2,0,0,1,1,6,6,1,1,0,0,6,6,4,4,4,4,2,2,2,2,0,0,0,0,5,5,2,2,5,5,1,1,6,6,7,7,1,1,5,5,2,2,6,6,6,6,4,4,0,0,4,4,5,5,7,7,7,7,3,3,6,6,7,7,2,2,2,2,5,5,5,5,3,3,0,0,0,0,7,7,1,1,1,1,1,1,3,3,7,7,7,7,0,0,7,7,3,3,4,4,3,3,1,1,3,3,4,4,3,3,6,6,2,2,2,2,0,0,2,2,4,4,3,3,1,1,4,4,7,7,2,2,4,4,0,0,4,4,2,2,4,4,1,1,2,2,3,3,3,3,3,3,0,0,1,1,1,1,2,2,2,2,7,7,5,5,6,6,4,4,0,0,7,7,6,6,3,3,7,7,4,4,6,6,6,6,5,5,1,1,4,4,2,2,0,0,7,7,4,4,1,1,6,6,0,0,5,5,1,1,2,2,7,7,2,2,4,4,0,0,0,0,6,6,3,3,3,3,2,2,1,1,0,0,2,2,4,4,0,0,6,6,5,5,2,2,5,5,2,2,1,1,1,1,4,4,5,5,7,7,0,0,5,5,0,0,2,2,2,2,6,6,4,4,4,4,2,2,5,5,7,7,7,7,5,5,4,4,7,7,5,5,1,1,7,7,5,5,4,4,0,0,0,0,4,4,3,3,6,6,1,1,1,1,1,1,3,3,5,5,1,1,1,1,2,2,7,7,5,5,6,6,7,7,3,3,3,3,2,2,1,1,3,3,5,5,3,3,7,7,2,2,2,2,4,4,4,4,4,4,1,1,7,7,2,2,5,5,4,4,7,7,3,3,3,3,7,7,4,4,7,7,1,1,6,6,3,3,6,6,7,7,4,4,7,7,6,6,4,4,7,7,7,7,1,1,6,6,4,4,2,2,0,0,7,7,7,7,2,2,7,7,2,2,6,6,3,3,2,2,6,6,6,6,6,6,2,2,4,4,0,0,0,0,3,3,5,5,5,5,5,5,6,6,3,3,2,2,7,7,5,5,1,1,4,4,1,1,3,3,7,7,2,2,5,5,5,5,6,6,2,2,1,1,5,5,5,5,2,2,2,2,4,4,3,3,7,7,6,6,5,5,0,0,1,1,5,5,3,3,2,2,4,4,2,2,1,1,2,2,0,0,6,6,4,4,6,6,0,0,3,3,2,2,0,0,1,1,6,6,6,6,5,5,7,7,6,6,3,3,3,3,0,0,1,1,0,0,1,1,3,3,3,3,3,3,6,6,7,7,5,5,2,2,3,3,2,2,4,4,2,2,4,4,3,3,6,6,3,3,5,5,6,6,2,2,0,0,2,2,5,5,3,3,1,1,7,7,6,6,5,5,4,4,2,2,3,3,3,3,3,3,3,3,0,0,2,2,1,1,6,6,4,4,0,0,5,5,3,3,0,0,0,0,4,4,4,4,3,3,6,6,6,6,0,0,6,6,7,7,0,0,1,1,1,1,6,6,7,7,2,2,4,4,3,3,2,2,1,1,6,6,5,5,7,7,3,3,7,7,3,3,7,7,0,0,3,3,3,3,6,6,7,7,2,2,5,5,0,0,1,1,1,1,5,5,2,2,3,3,0,0,6,6,6,6,0,0,3,3,6,6,3,3,4,4,0,0,4,4,4,4,7,7,4,4,6,6,4,4,4,4,3,3,2,2,6,6,1,1,0,0,0,0,1,1,0,0,5,5,4,4,0,0,4,4,2,2,4,4,0,0,1,1,6,6,5,5,0,0,6,6,1,1,1,1,3,3,7,7,3,3,6,6,3,3,7,7,5,5,4,4,7,7,6,6,3,3,7,7,7,7,0,0,5,5,7,7,6,6,6,6,6,6,4,4,7,7,1,1,6,6,2,2,1,1,5,5,5,5,7,7,4,4,5,5,6,6,0,0,0,0,7,7,0,0,3,3,7,7,6,6,4,4,0,0,3,3,3,3,3,3,2,2,0,0,0,0,1,1,6,6,0,0,6,6,2,2,0,0,7,7,5,5,4,4,2,2,3,3,6,6,0,0,0,0,2,2,0,0,4,4,5,5,3,3,1,1,1,1,4,4,5,5,1,1,4,4,4,4,7,7,2,2,4,4,0,0,2,2,7,7,6,6,3,3,3,3,4,4,3,3,4,4,5,5,2,2,7,7,5,5,6,6,1,1,1,1,5,5,7,7,7,7,5,5,2,2,2,2,0,0,1,1,3,3,0,0,5,5,6,6,5,5,5,5,7,7,2,2,2,2,7,7,1,1,5,5,1,1,5,5,4,4,2,2,6,6,4,4,6,6,3,3,3,3,2,2,5,5,0,0,4,4,1,1,6,6,5,5,1,1,4,4,5,5,7,7,1,1,0,0,2,2,2,2,2,2,1,1,0,0,0,0,5,5,4,4,4,4,5,5,0,0,2,2,6,6,0,0,2,2,3,3,6,6,3,3,3,3,7,7,0,0,6,6,4,4,1,1,5,5,4,4,6,6,1,1,1,1,5,5,1,1,1,1,1,1,4,4,6,6,7,7,5,5,5,5,3,3,6,6,2,2,0,0,3,3,3,3,0,0,3,3,4,4,4,4,1,1,3,3,3,3,4,4,6,6,1,1,7,7,7,7,3,3,1,1,6,6,2,2,4,4,0,0,1,1,7,7,3,3,1,1,0,0,2,2,4,4,3,3,1,1,7,7,0,0,6,6,7,7,1,1,5,5,4,4,0,0,4,4,1,1,3,3,4,4,1,1,3,3,3,3,5,5,7,7,1,1,0,0,5,5,4,4,4,4,2,2,4,4,3,3,4,4,5,5,6,6,3,3,1,1,2,2,0,0,7,7,4,4,1,1,2,2,1,1,1,1,1,1,2,2,2,2,0,0,6,6,5,5,0,0,3,3,4,4,5,5,6,6,2,2,7,7,7,7,0,0,0,0,0,0,6,6,3,3,4,4,7,7,2,2,3,3,0,0,3,3,0,0,5,5,6,6,1,1,7,7,1,1,0,0,6,6,1,1,5,5,0,0,0,0,6,6,5,5,4,4,1,1,7,7,1,1,6,6,5,5,0,0,7,7,0,0,7,7,0,0,2,2,1,1,6,6,4,4,4,4,4,4,1,1,2,2,2,2,5,5,6,6,2,2,2,2,5,5,5,5,4,4,5,5,4,4,2,2,7,7,2,2,5,5,0,0,0,0,0,0,0,0,4,4,3,3,6,6,4,4,6,6,4,4,0,0,0,0,1,1,2,2,0,0,3,3,5,5,2,2,2,2,4,4,4,4,0,0,4,4,0,0,2,2,5,5,1,1,0,0,0,0,0,0,4,4,5,5,2,2,1,1,6,6,1,1,1,1,2,2,0,0,0,0,3,3,6,6,5,5,3,3,3,3,2,2,4,4,3,3,0,0,6,6,0,0,4,4,4,4,2,2,2,2,2,2,2,2,4,4,4,4,1,1,4,4,7,7,6,6,2,2,3,3,4,4,3,3,0,0,6,6,0,0,5,5,6,6,1,1,0,0,7,7,6,6,2,2,0,0,6,6,4,4,4,4,7,7,1,1,0,0,0,0,2,2,4,4,5,5,7,7,0,0,3,3,2,2,2,2,1,1,2,2,6,6,1,1,3,3,6,6,1,1,2,2,5,5,3,3,2,2,3,3,7,7,1,1,1,1,1,1,3,3,4,4,1,1,7,7,5,5,6,6,1,1,5,5,5,5,5,5,1,1,2,2,4,4,3,3,5,5,3,3,7,7,5,5,3,3,4,4,1,1,6,6,7,7,4,4,5,5,4,4,6,6,4,4,6,6,7,7,1,1,7,7,0,0,6,6,7,7,0,0,0,0,0,0,0,0,0,0,6,6,2,2,5,5,1,1,7,7,6,6,1,1,3,3,6,6,4,4,4,4,0,0,2,2,5,5,2,2,1,1,2,2,0,0,5,5,0,0,1,1,0,0,1,1,1,1,0,0,5,5,3,3,1,1,3,3,7,7,6,6,6,6,4,4,0,0,2,2,0,0,6,6,2,2,1,1,3,3,4,4,3,3,6,6,4,4,2,2,5,5,7,7,6,6,7,7,2,2,4,4,6,6,5,5,6,6,5,5,3,3,6,6,1,1,7,7,5,5,0,0,1,1,0,0,3,3,6,6,7,7,5,5,2,2,5,5,3,3,1,1,1,1,4,4,1,1,5,5,1,1,0,0,5,5,2,2,4,4,2,2,5,5,4,4,6,6,5,5,1,1,3,3,2,2,4,4,3,3,6,6,6,6,0,0,2,2,0,0,0,0,1,1,3,3,2,2,3,3,6,6,6,6,6,6,5,5,7,7,4,4,0,0,0,0,6,6,0,0,4,4,5,5,5,5,4,4,7,7,6,6,5,5,1,1,4,4,2,2,0,0,1,1,3,3,5,5,7,7,7,7,5,5,6,6,5,5,0,0,5,5,1,1,5,5,2,2,1,1,3,3,6,6,5,5,6,6,5,5,4,4,7,7,2,2,6,6,2,2,4,4,1,1,3,3,6,6,7,7,4,4,3,3,1,1,7,7,0,0,5,5,2,2,0,0,0,0,0,0,5,5,5,5,1,1,3,3,0,0,2,2,0,0,7,7,0,0,1,1,3,3,2,2,4,4,5,5,3,3,0,0,6,6,0,0,4,4,0,0,3,3,5,5,1,1,2,2,4,4,4,4,1,1,7,7,2,2,2,2,5,5,2,2,7,7,5,5,3,3,5,5,2,2,4,4,3,3,4,4,3,3,0,0,2,2,4,4,5,5,4,4,4,4,0,0,4,4,0,0,6,6,1,1,6,6,2,2,1,1,5,5,5,5,5,5,7,7,7,7,4,4,4,4,5,5,0,0,3,3,0,0,4,4,0,0,6,6,4,4,3,3,0,0,6,6,4,4,0,0,4,4,0,0,5,5,0,0,2,2,6,6,3,3,3,3,2,2,4,4,3,3,5,5,6,6,4,4,4,4,0,0,4,4,6,6,5,5,6,6,2,2,2,2,1,1,5,5,4,4,4,4,1,1,0,0,7,7,0,0,3,3,1,1,1,1,7,7,3,3,0,0,6,6,6,6,4,4,0,0,4,4,5,5,6,6,0,0,7,7,0,0,5,5,2,2,1,1,0,0,2,2,4,4,3,3,1,1,7,7,2,2,7,7,7,7,3,3,5,5,1,1,7,7,2,2,2,2,2,2,7,7,5,5,5,5,2,2,0,0,6,6,4,4,3,3,1,1,2,2,3,3,6,6,2,2,2,2,3,3,6,6,0,0,2,2,1,1,3,3,4,4,0,0,3,3,3,3,5,5,2,2,2,2,2,2,1,1,2,2,5,5,7,7,2,2,2,2,3,3,5,5,4,4,1,1,4,4,6,6,6,6,2,2,2,2,0,0,0,0,3,3,2,2,0,0,3,3,4,4,7,7,3,3,1,1,6,6,0,0,4,4,5,5,0,0,0,0,6,6,4,4,2,2,7,7,1,1,5,5,3,3,5,5,4,4,2,2,6,6,3,3,4,4,3,3,3,3,0,0,6,6,5,5,3,3,4,4,6,6,2,2,3,3,1,1,0,0,1,1,1,1,0,0,5,5,7,7,4,4,7,7,2,2,4,4,1,1,6,6,1,1,1,1,3,3,0,0,3,3,1,1,4,4,0,0,7,7,5,5,4,4,7,7,5,5,4,4,4,4,4,4,5,5,4,4,3,3,6,6,7,7,3,3,2,2,4,4,6,6,4,4,6,6,7,7,5,5,1,1,3,3,3,3,3,3,1,1,1,1,0,0,2,2,5,5,6,6,4,4,1,1,5,5,5,5,1,1,7,7,5,5,4,4,7,7,4,4,1,1,6,6,6,6,2,2,0,0,0,0,1,1,4,4,3,3,5,5,7,7,6,6,2,2,2,2,6,6,1,1,5,5,1,1,1,1,1,1,1,1,5,5,6,6,2,2,7,7,1,1,0,0,3,3,3,3,7,7,2,2,4,4,5,5,2,2,5,5,2,2,3,3,3,3,3,3,6,6,6,6,1,1,0,0,3,3,0,0,2,2,7,7,3,3,0,0,2,2,7,7,4,4,2,2,4,4,2,2,5,5,0,0,3,3,7,7,7,7,3,3,5,5,0,0,2,2,2,2,0,0,4,4,0,0,4,4,6,6,1,1,4,4,5,5,4,4,3,3,1,1,6,6,2,2,6,6,2,2,0,0,4,4,1,1,1,1,4,4,0,0,0,0,6,6,4,4,1,1,7,7,2,2,4,4,4,4,1,1,3,3,7,7,1,1,2,2,2,2,2,2,2,2,2,2,3,3,0,0,1,1,6,6,4,4,0,0,1,1,0,0,5,5,4,4,0,0,5,5,2,2,5,5,2,2,4,4,2,2,3,3,4,4,4,4,6,6,4,4,7,7,0,0,7,7,3,3,4,4,2,2,4,4,0,0,1,1,4,4,6,6,3,3,6,6,2,2,2,2,6,6,5,5,1,1,0,0,7,7,6,6,6,6,1,1,3,3,7,7,3,3,7,7,2,2,4,4,7,7,2,2,2,2,0,0,1,1,3,3,0,0,0,0,4,4,7,7,1,1,1,1,1,1,3,3,2,2,7,7,7,7,3,3,5,5,1,1,2,2,6,6,7,7,3,3,6,6,3,3,1,1,6,6,4,4,6,6,0,0,3,3,4,4,3,3,4,4,7,7,0,0,1,1,7,7,4,4,3,3,3,3,0,0,0,0,5,5,3,3,6,6,7,7,2,2,1,1,5,5,0,0,0,0,1,1,3,3,3,3,4,4,7,7,1,1,3,3,5,5,7,7,4,4,4,4,0,0,7,7,0,0,1,1,0,0,2,2,4,4,0,0,5,5,7,7,3,3,7,7,1,1,0,0,5,5,7,7,7,7,4,4,2,2,4,4,1,1,4,4,5,5,6,6,1,1,0,0,2,2,4,4,3,3,5,5,3,3,3,3,0,0,0,0,1,1,7,7,5,5,3,3,4,4,1,1,7,7,4,4,5,5,5,5,0,0,5,5,4,4,2,2,6,6,5,5,4,4,1,1,4,4,0,0,5,5,5,5,6,6,4,4,4,4,6,6,4,4,2,2,7,7,3,3,1,1,5,5,0,0,7,7,6,6,1,1,2,2,4,4,0,0,0,0,3,3,3,3,3,3,5,5,3,3,3,3,2,2,0,0,6,6,0,0,6,6,1,1,4,4,0,0,4,4,7,7,0,0,4,4,2,2,2,2,5,5,6,6,1,1,0,0,3,3,0,0,4,4,6,6,3,3,3,3,4,4,6,6,3,3,0,0,5,5,1,1,3,3,2,2,0,0,6,6,5,5,5,5,5,5,0,0,6,6,0,0,2,2,1,1,5,5,3,3,5,5,7,7,2,2,6,6,5,5,4,4,5,5,6,6,7,7,4,4,0,0,3,3,2,2,1,1,7,7,4,4,2,2,0,0,7,7,6,6,4,4,1,1,4,4,0,0,4,4,5,5,0,0,7,7,7,7,5,5,2,2,4,4,1,1,2,2,0,0,5,5,6,6,6,6,1,1,6,6,5,5,5,5,0,0,2,2,5,5,7,7,4,4,7,7,3,3,6,6,7,7,4,4,0,0,4,4,6,6,1,1,2,2,3,3,2,2,2,2,6,6,6,6,5,5,0,0,3,3,6,6,2,2,2,2,5,5,7,7,3,3,5,5,6,6,2,2,4,4,0,0,6,6,0,0,0,0,0,0,3,3,5,5,3,3,1,1,7,7,2,2,5,5,6,6,1,1,3,3,6,6,2,2,2,2,2,2,4,4,5,5,6,6,3,3,6,6,6,6,6,6,5,5,5,5,7,7,1,1,4,4,5,5,4,4,5,5,0,0,5,5,0,0,2,2,2,2,5,5,4,4,0,0,5,5,0,0,2,2,6,6,7,7,0,0,5,5,7,7,4,4,5,5,6,6,1,1,5,5,2,2,0,0,0,0,2,2,1,1,7,7,5,5,5,5,3,3,2,2,3,3,6,6,4,4,0,0,5,5,7,7,2,2,3,3,0,0,2,2,5,5,3,3,6,6,6,6,1,1,6,6,3,3,7,7,3,3,5,5,7,7,4,4,3,3,0,0,1,1,3,3,2,2,5,5,1,1,4,4,3,3,6,6,0,0,2,2,6,6,7,7,5,5,0,0,7,7,0,0,0,0,6,6,6,6,7,7,0,0,0,0,0,0,0,0,5,5,4,4,6,6,4,4,1,1,3,3,6,6,1,1,3,3,7,7,1,1,4,4,4,4,1,1,7,7,5,5,7,7,4,4,2,2,0,0,6,6,5,5,6,6,7,7,5,5,4,4,5,5,7,7,7,7,0,0,5,5,2,2,5,5,5,5,0,0,3,3,6,6,6,6,3,3,2,2,0,0,6,6,1,1,7,7,7,7,6,6,6,6,5,5,4,4,5,5,1,1,6,6,2,2,4,4,0,0,2,2,4,4,6,6,4,4,5,5,6,6,5,5,5,5,1,1,0,0,0,0,4,4,5,5,7,7,1,1,4,4,0,0,1,1,2,2,7,7,7,7,4,4,3,3,1,1,7,7,5,5,4,4,7,7,4,4,2,2,2,2,1,1,4,4,5,5,4,4,6,6,5,5,2,2,7,7,1,1,3,3,0,0,7,7,2,2,1,1,1,1,2,2,5,5,3,3,2,2,2,2,0,0,6,6,6,6,3,3,2,2,0,0,3,3,0,0,1,1,2,2,0,0,2,2,5,5,3,3,6,6,1,1,1,1,4,4,4,4,3,3,1,1,2,2,2,2,5,5,5,5,7,7,3,3,7,7,0,0,0,0,0,0,5,5,5,5,2,2,7,7,6,6,4,4,0,0,5,5,3,3,7,7,4,4,3,3,4,4,6,6,1,1,3,3,5,5,4,4,1,1,5,5,6,6,0,0,6,6,6,6,4,4,7,7,2,2,4,4,6,6,7,7,6,6,2,2,0,0,6,6,4,4,3,3,4,4,4,4,0,0,2,2,1,1,0,0,0,0,1,1,2,2,6,6,2,2,0,0,4,4,4,4,0,0,0,0,0,0,4,4,1,1,1,1,2,2,7,7,2,2,4,4,1,1,0,0,5,5,0,0,1,1,3,3,3,3,2,2,2,2,4,4,6,6,4,4,5,5,3,3,3,3,2,2,1,1,0,0,2,2,4,4,1,1,2,2,7,7,4,4,6,6,0,0,2,2,4,4,7,7,1,1,3,3,3,3,3,3,3,3,7,7,5,5,3,3,7,7,1,1,4,4,0,0,4,4,0,0,0,0,2,2,0,0,2,2,3,3,4,4,2,2,1,1,7,7,2,2,5,5,7,7,7,7,7,7,4,4,5,5,5,5,6,6,2,2,7,7,1,1,0,0,1,1,0,0,2,2,4,4,6,6,3,3,2,2,0,0,3,3,6,6,6,6,2,2,7,7,0,0,2,2,6,6,2,2,2,2,6,6,4,4,6,6,5,5,1,1,4,4,3,3,7,7,5,5,0,0,5,5,2,2,1,1,7,7,4,4,7,7,6,6,4,4,1,1,3,3,2,2,0,0,0,0,7,7,2,2,0,0,6,6,6,6,4,4,1,1,1,1,3,3,4,4,1,1,0,0,6,6,6,6,4,4,4,4,5,5,3,3,4,4,4,4,0,0,5,5,5,5,3,3,4,4,6,6,4,4,4,4,5,5,6,6,7,7,6,6,7,7,4,4,3,3,4,4,1,1,7,7,4,4,6,6,6,6,6,6,1,1,7,7,3,3,3,3,1,1,0,0,2,2,2,2,0,0,2,2,0,0,6,6,4,4,1,1,7,7,7,7,6,6,3,3,6,6,1,1,0,0,3,3,6,6,1,1,3,3,5,5,2,2,2,2,0,0,0,0,2,2,0,0,1,1,2,2,1,1,2,2,2,2,4,4,2,2,0,0,6,6,2,2,6,6,3,3,5,5,2,2,5,5,7,7,0,0,4,4,0,0,2,2,2,2,4,4,3,3,4,4,4,4,7,7,4,4,0,0,7,7,3,3,2,2,4,4,3,3,0,0,0,0,0,0,4,4,5,5,7,7,1,1,1,1,7,7,5,5,5,5,6,6,2,2,5,5,5,5,6,6,6,6,4,4,1,1,2,2,2,2,6,6,0,0,2,2,7,7,6,6,1,1,3,3,3,3,4,4,6,6,6,6,1,1,4,4,4,4,1,1,6,6,1,1,5,5,3,3,2,2,1,1,6,6,6,6,1,1,2,2,0,0,2,2,4,4,3,3,3,3,6,6,1,1,4,4,3,3,3,3,3,3,0,0,6,6,5,5,4,4,4,4,2,2,6,6,4,4,1,1,4,4,2,2,5,5,3,3,2,2,6,6,0,0,2,2,2,2,7,7,0,0,4,4,3,3,4,4,3,3,1,1,2,2,5,5,3,3,6,6,0,0,1,1,7,7,1,1,2,2,1,1,6,6,4,4,7,7,6,6,0,0,5,5,5,5,1,1,4,4,0,0,6,6,3,3,0,0,4,4,1,1,6,6,7,7,4,4,2,2,4,4,7,7,2,2,3,3,0,0,2,2,6,6,6,6,2,2,7,7,7,7,1,1,4,4,0,0,3,3,4,4,4,4,1,1,7,7,3,3,0,0,5,5,7,7,6,6,1,1,0,0,4,4,5,5,2,2,7,7,6,6,1,1,0,0,1,1,7,7,5,5,4,4,7,7,6,6,1,1,7,7,1,1,0,0,2,2,1,1,2,2,3,3,0,0,5,5,1,1,7,7,3,3,3,3,6,6,4,4,4,4,1,1,2,2,2,2,4,4,2,2,4,4,6,6,0,0,5,5,3,3,2,2,0,0,0,0,6,6,4,4,4,4,0,0,1,1,2,2,6,6,1,1,7,7,3,3,5,5,2,2,6,6,1,1,5,5,2,2,4,4,0,0,0,0,0,0,5,5,4,4,5,5,4,4,6,6,2,2,2,2,1,1,3,3,3,3,6,6,0,0,2,2,3,3,6,6,6,6,5,5,7,7,5,5,3,3,3,3,2,2,1,1,2,2,1,1,0,0,6,6,7,7,1,1,3,3,4,4,0,0,7,7,0,0,0,0,0,0,2,2,0,0,2,2,1,1,6,6,5,5,0,0,1,1,5,5,2,2,7,7,1,1,5,5,4,4,2,2,2,2,4,4,7,7,0,0,2,2,4,4,2,2,7,7,4,4,2,2,5,5,3,3,5,5,1,1,0,0,4,4,3,3,7,7,1,1,5,5,6,6,0,0,7,7,1,1,3,3,3,3,3,3,0,0,0,0,6,6,0,0,4,4,7,7,1,1,0,0,1,1,2,2,2,2,4,4,6,6,2,2,0,0,3,3,5,5,1,1,1,1,5,5,7,7,2,2,1,1,6,6,5,5,0,0,6,6,2,2,1,1,6,6,4,4,5,5,1,1,6,6,6,6,4,4,1,1,6,6,6,6,6,6,4,4,6,6,5,5,6,6,3,3,0,0,0,0,0,0,0,0,2,2,5,5,5,5,4,4,3,3,6,6,4,4,5,5,1,1,4,4,3,3,6,6,3,3,5,5,2,2,3,3,3,3,1,1,4,4,7,7,5,5,2,2,0,0,4,4,3,3,1,1,3,3,1,1,6,6,4,4,1,1,3,3,0,0,6,6,5,5,5,5,5,5,2,2,2,2,6,6,5,5,7,7,7,7,0,0,4,4,1,1,0,0,3,3,1,1,3,3,3,3,3,3,5,5,1,1,2,2,4,4,7,7,3,3,5,5,4,4,0,0,6,6,5,5,6,6,6,6,6,6,3,3,1,1,5,5,5,5,2,2,4,4,3,3,1,1,1,1,7,7,4,4,4,4,2,2,0,0,3,3,2,2,0,0,7,7,6,6,6,6,7,7,7,7,4,4,2,2,6,6,2,2,7,7,1,1,7,7,7,7,0,0,4,4,5,5,5,5,1,1,7,7,2,2,6,6,4,4,5,5,2,2,2,2,1,1,6,6,5,5,4,4,6,6,0,0,5,5,4,4,3,3,4,4,4,4,5,5,0,0,1,1,0,0,0,0,2,2,4,4,2,2,3,3,4,4,4,4,2,2,3,3,4,4,3,3,2,2,1,1,5,5,1,1,2,2,1,1,1,1,4,4,0,0,4,4,2,2,2,2,3,3,4,4,6,6,3,3,3,3,2,2,7,7,7,7,1,1,0,0,2,2,5,5,4,4,4,4,3,3,0,0,4,4,7,7,0,0,3,3,5,5,1,1,2,2,3,3,1,1,4,4,3,3,5,5,7,7,4,4,7,7,6,6,7,7,2,2,6,6,4,4,2,2,5,5,2,2,7,7,0,0,0,0,3,3,3,3,7,7,2,2,1,1,6,6,7,7,7,7,4,4,7,7,2,2,4,4,4,4,7,7,7,7,0,0,3,3,1,1,1,1,2,2,4,4,5,5,1,1,5,5,4,4,5,5,3,3,4,4,5,5,0,0,3,3,4,4,3,3,6,6,0,0,4,4,2,2,1,1,6,6,0,0,1,1,5,5,4,4,7,7,6,6,3,3,2,2,0,0,4,4,2,2,6,6,1,1,1,1,3,3,0,0,4,4,1,1,7,7,6,6,2,2,2,2,0,0,5,5,1,1,5,5,2,2,6,6,3,3,7,7,4,4,1,1,3,3,6,6,3,3,4,4,6,6,4,4,5,5,2,2,1,1,4,4,4,4,5,5,7,7,5,5,6,6,4,4,4,4,0,0,7,7,4,4,5,5,1,1,7,7,1,1,0,0,4,4,6,6,4,4,5,5,1,1,7,7,0,0,2,2,1,1,7,7,1,1,2,2,2,2,3,3,0,0,0,0,7,7,2,2,7,7,6,6,3,3,1,1,0,0,3,3,0,0,2,2,3,3,3,3,4,4,4,4,5,5,1,1,5,5,3,3,0,0,6,6,1,1,1,1,7,7,3,3,3,3,4,4,6,6,3,3,6,6,1,1,2,2,3,3,2,2,6,6,6,6,4,4,4,4,6,6,2,2,4,4,1,1,6,6,0,0,5,5,4,4,6,6,7,7,2,2,1,1,3,3,3,3,7,7,3,3,1,1,0,0,6,6,0,0,2,2,5,5,6,6,3,3,6,6,4,4,0,0,3,3,7,7,4,4,0,0,2,2,3,3,7,7,4,4,1,1,4,4,6,6,7,7,5,5,2,2,3,3,4,4,4,4,0,0,2,2,5,5,4,4,7,7,2,2,6,6,7,7,0,0,6,6,4,4,2,2,2,2,6,6,6,6,4,4,2,2,4,4,7,7,5,5,7,7,0,0,7,7,6,6,0,0,2,2,4,4,7,7,6,6,4,4,6,6,3,3,7,7,0,0,2,2,5,5,2,2,3,3,1,1,1,1,4,4,2,2,3,3,3,3,3,3,0,0,6,6,1,1,3,3,5,5,6,6,6,6,1,1,5,5,0,0,0,0,1,1,0,0,1,1,1,1,3,3,0,0,5,5,1,1,1,1,3,3,3,3,3,3,5,5,2,2,0,0,6,6,4,4,3,3,3,3,5,5,4,4,7,7,1,1,5,5,0,0,2,2,3,3,0,0,6,6,7,7,2,2,4,4,6,6,5,5,6,6,5,5,3,3,4,4,6,6,2,2,4,4,3,3,7,7,2,2,3,3,4,4,2,2,4,4,2,2,3,3,1,1,5,5,1,1,3,3,4,4,5,5,1,1,5,5,6,6,7,7,2,2,6,6,6,6,5,5,0,0,6,6,2,2,2,2,6,6,7,7,6,6,0,0,0,0,3,3,2,2,4,4,3,3,2,2,6,6,5,5,6,6,5,5,1,1,6,6,7,7,1,1,6,6,5,5,5,5,1,1,2,2,2,2,5,5,7,7,0,0,5,5,4,4,2,2,5,5,2,2,6,6,0,0,0,0,3,3,5,5,2,2,4,4,0,0,3,3,6,6,3,3,1,1,5,5,1,1,4,4,2,2,1,1,4,4,6,6,6,6,1,1,2,2,4,4,2,2,0,0,2,2,0,0,5,5,6,6,1,1,0,0,0,0,4,4,6,6,7,7,7,7,6,6,5,5,3,3,4,4,0,0,2,2,1,1,4,4,4,4,4,4,6,6,4,4,5,5,4,4,2,2,6,6,6,6,1,1,5,5,6,6,4,4,1,1,7,7,4,4,2,2,6,6,6,6,7,7,4,4,4,4,1,1,5,5,6,6,6,6,2,2,1,1,4,4,5,5,1,1,0,0,2,2,2,2,1,1,7,7,3,3,0,0,1,1,2,2,1,1,6,6,1,1,4,4,6,6,2,2,7,7,0,0,7,7,4,4,5,5,3,3,2,2,6,6,1,1,2,2,5,5,6,6,1,1,2,2,7,7,5,5,0,0,3,3,5,5,3,3,6,6,2,2,4,4,1,1,1,1,6,6,7,7,0,0,4,4,4,4,1,1,5,5,4,4,0,0,4,4,0,0,5,5,6,6,0,0,1,1,5,5,2,2,0,0,0,0,6,6,1,1,2,2,2,2,0,0,2,2,0,0,2,2,0,0,2,2,5,5,4,4,7,7,6,6,7,7,1,1,1,1,4,4,2,2,4,4,7,7,1,1,0,0,7,7,4,4,4,4,7,7,0,0,3,3,4,4,7,7,1,1,6,6,4,4,0,0,3,3,4,4,2,2,2,2,7,7,3,3,1,1,3,3,2,2,1,1,4,4,5,5,3,3,2,2,6,6,0,0,3,3,1,1,4,4,5,5,5,5,4,4,7,7,7,7,0,0,0,0,1,1,5,5,7,7,7,7,2,2,5,5,2,2,4,4,1,1,4,4,0,0,0,0,5,5,0,0,2,2,0,0,3,3,3,3,6,6,2,2,7,7,1,1,1,1,1,1,1,1,3,3,4,4,1,1,0,0,5,5,0,0,7,7,0,0,2,2,4,4,0,0,3,3,1,1,1,1,4,4,6,6,2,2,5,5,3,3,2,2,1,1,6,6,1,1,6,6,7,7,5,5,4,4,1,1,2,2,0,0,1,1,1,1,2,2,7,7,0,0,5,5,6,6,5,5,4,4,5,5,4,4,1,1,7,7,1,1,3,3,6,6,0,0,2,2,4,4,7,7,1,1,0,0,3,3,4,4,0,0,2,2,2,2,4,4,1,1,6,6,2,2,6,6,7,7,3,3,6,6,2,2,5,5,3,3,4,4,0,0,0,0,0,0,6,6,3,3,0,0,4,4,0,0,1,1,3,3,6,6,1,1,5,5,1,1,2,2,2,2,5,5,7,7,0,0,7,7,2,2,7,7,2,2,6,6,5,5,1,1,1,1,3,3,5,5,3,3,4,4,4,4,6,6,0,0,6,6,6,6,2,2,3,3,2,2,7,7,1,1,3,3,0,0,0,0,0,0,1,1,1,1,3,3,4,4,0,0,6,6,6,6,5,5,2,2,0,0,4,4,2,2,0,0,5,5,6,6,0,0,4,4,5,5,6,6,5,5,7,7,0,0,7,7,4,4,1,1,6,6,4,4,1,1,2,2,1,1,3,3,2,2,1,1,1,1,1,1,5,5,2,2,1,1,5,5,1,1,3,3,4,4,2,2,0,0,0,0,3,3,7,7,1,1,4,4,4,4,3,3,2,2,2,2,5,5,4,4,6,6,1,1,0,0,5,5,5,5,7,7,1,1,2,2,6,6,3,3,0,0,5,5,6,6,2,2,5,5,2,2,3,3,6,6,7,7,4,4,6,6,3,3,6,6,4,4,7,7,6,6,6,6,5,5,2,2,5,5,5,5,2,2,3,3,7,7,4,4,7,7,2,2,5,5,5,5,4,4,2,2,5,5,0,0,3,3,5,5,1,1,7,7,0,0,1,1,0,0,6,6,5,5,7,7,0,0,7,7,3,3,4,4,2,2,3,3,7,7,7,7,1,1,5,5,0,0,3,3,2,2,0,0,3,3,5,5,4,4,3,3,3,3,0,0,6,6,2,2,2,2,3,3,2,2,4,4,1,1,0,0,5,5,1,1,0,0,1,1,0,0,4,4,7,7,6,6,1,1,4,4,7,7,6,6,3,3,7,7,4,4,0,0,6,6,0,0,7,7,1,1,3,3,2,2,6,6,0,0,2,2,3,3,2,2,1,1,1,1,2,2,2,2,2,2,0,0,1,1,7,7,6,6,3,3,5,5,7,7,5,5,0,0,0,0,0,0,4,4,4,4,6,6,6,6,5,5,6,6,2,2,2,2,4,4,0,0,4,4,1,1,2,2,3,3,3,3,5,5,2,2,5,5,5,5,4,4,2,2,3,3,5,5,0,0,5,5,2,2,0,0,7,7,2,2,4,4,5,5,0,0,7,7,5,5,4,4,5,5,2,2,2,2,0,0,3,3,1,1,4,4,1,1,0,0,7,7,3,3,7,7,2,2,1,1,3,3,1,1,2,2,4,4,2,2,6,6,3,3,0,0,2,2,7,7,4,4,6,6,4,4,5,5,0,0,4,4,7,7,1,1,6,6,7,7,1,1,5,5,2,2,0,0,7,7,0,0,1,1,1,1,1,1,5,5,0,0,3,3,0,0,1,1,1,1,2,2,4,4,0,0,5,5,4,4,7,7,3,3,5,5,6,6,3,3,3,3,6,6,2,2,2,2,1,1,1,1,6,6,2,2,3,3,7,7,7,7,1,1,3,3,6,6,6,6,1,1,7,7,4,4,5,5,7,7,1,1,1,1,7,7,7,7,2,2,1,1,6,6,4,4,0,0,0,0,1,1,3,3,4,4,3,3,6,6,5,5,3,3,3,3,2,2,6,6,6,6,2,2,2,2,0,0,2,2,1,1,2,2,6,6,3,3,5,5,1,1,3,3,6,6,3,3,2,2,3,3,4,4,7,7,4,4,5,5,6,6,1,1,3,3,7,7,2,2,7,7,5,5,0,0,5,5,3,3,1,1,2,2,3,3,6,6,3,3,7,7,3,3,7,7,0,0,4,4,1,1,3,3,2,2,7,7,5,5,6,6,6,6,6,6,4,4,5,5,3,3,4,4,0,0,1,1,3,3,5,5,6,6,7,7,3,3,4,4,7,7,0,0,2,2,2,2,7,7,2,2,7,7,7,7,6,6,7,7,4,4,0,0,4,4,4,4,5,5,3,3,0,0,2,2,6,6,3,3,3,3,7,7,1,1,4,4,3,3,1,1,4,4,5,5,7,7,1,1,3,3,4,4,4,4,6,6,5,5,3,3,1,1,6,6,7,7,7,7,3,3,1,1,7,7,6,6,0,0,5,5,1,1,0,0,7,7,5,5,4,4,7,7,4,4,0,0,7,7,5,5,1,1,3,3,4,4,1,1,7,7,4,4,6,6,5,5,7,7,6,6,1,1,0,0,2,2,7,7,1,1,6,6,2,2,0,0,3,3,4,4,1,1,0,0,5,5,5,5,3,3,4,4,5,5,7,7,3,3,1,1,4,4,4,4,2,2,1,1,7,7,0,0,7,7,0,0,1,1,6,6,4,4,7,7,2,2,2,2,6,6,0,0,3,3,7,7,1,1,4,4,6,6,3,3,2,2,4,4,1,1,5,5,1,1,0,0,7,7,4,4,2,2,4,4,3,3,6,6,7,7,7,7,1,1,6,6,4,4,0,0,0,0,2,2,6,6,4,4,2,2,3,3,5,5,7,7,6,6,0,0,4,4,2,2,0,0,0,0,3,3,3,3,5,5,7,7,5,5,6,6,2,2,4,4,6,6,3,3,4,4,7,7,0,0,7,7,0,0,7,7,1,1,3,3,6,6,3,3,5,5,6,6,4,4,0,0,0,0,4,4,4,4,3,3,1,1,0,0,5,5,1,1,2,2,0,0,0,0,6,6,1,1,3,3,7,7,6,6,5,5,6,6,7,7,1,1,0,0,0,0,1,1,4,4,1,1,7,7,1,1,3,3,0,0,5,5,1,1,7,7,7,7,3,3,1,1,0,0,4,4,0,0,0,0,3,3,4,4,4,4,1,1,0,0,4,4,5,5,7,7,3,3,4,4,6,6,7,7,3,3,5,5,5,5,6,6,6,6,1,1,0,0,7,7,5,5,0,0,2,2,4,4,6,6,2,2,6,6,5,5,6,6,1,1,6,6,4,4,2,2,2,2,2,2,1,1,7,7,4,4,7,7,2,2,2,2,6,6,0,0,5,5,3,3,4,4,7,7,6,6,1,1,6,6,2,2,5,5,0,0,6,6,0,0,4,4,5,5,5,5,3,3,5,5,3,3,5,5,2,2,5,5,2,2,3,3,2,2,2,2,2,2,4,4,1,1,7,7,7,7,0,0,0,0,7,7,2,2,5,5,4,4,4,4,2,2,1,1,3,3,3,3,1,1,3,3,7,7,6,6,5,5,4,4,6,6,3,3,6,6,3,3,2,2,1,1,4,4,5,5,1,1,6,6,4,4,0,0,2,2,2,2,6,6,0,0,3,3,5,5,4,4,3,3,6,6,5,5,6,6,6,6,6,6,4,4,5,5,3,3,2,2,3,3,0,0,6,6,2,2,3,3,7,7,5,5,6,6,7,7,2,2,4,4,0,0,5,5,2,2,0,0,1,1,1,1,4,4,0,0,6,6,1,1,2,2,6,6,4,4,4,4,4,4,7,7,5,5,5,5,3,3,1,1,0,0,3,3,4,4,4,4,2,2,6,6,0,0,3,3,1,1,7,7,6,6,5,5,6,6,4,4,2,2,5,5,2,2,2,2,4,4,5,5,1,1,2,2,7,7,1,1,1,1,6,6,0,0,5,5,7,7,5,5,3,3,7,7,0,0,1,1,1,1,2,2,7,7,0,0,4,4,4,4,0,0,6,6,6,6,7,7,7,7,4,4,6,6,6,6,4,4,7,7,6,6,2,2,0,0,2,2,6,6,1,1,7,7,0,0,4,4,0,0,0,0,6,6,4,4,3,3,3,3,6,6,7,7,4,4,5,5,3,3,7,7,1,1,4,4,0,0,3,3,3,3,3,3,7,7,0,0,4,4,5,5,5,5,7,7,6,6,3,3,5,5,6,6,1,1,2,2,0,0,2,2,6,6,3,3,4,4,6,6,5,5,5,5,0,0,4,4,6,6,7,7,0,0,6,6,4,4,1,1,3,3,1,1,5,5,3,3,7,7,2,2,0,0,7,7,1,1,5,5,5,5,0,0,2,2,6,6,2,2,3,3,4,4,6,6,4,4,5,5,3,3,3,3,5,5,3,3,2,2,1,1,2,2,6,6,0,0,7,7,7,7,3,3,0,0,4,4,6,6,6,6,7,7,5,5,0,0,4,4,2,2,5,5,2,2,3,3,0,0,4,4,5,5,3,3,6,6,0,0,6,6,3,3,2,2,3,3,0,0,0,0,0,0,0,0,2,2,2,2,1,1,2,2,3,3,0,0,4,4,1,1,0,0,0,0,4,4,3,3,4,4,7,7,1,1,5,5,7,7,1,1,2,2,1,1,5,5,3,3,5,5,5,5,1,1,1,1,7,7,6,6,4,4,7,7,5,5,6,6,1,1,4,4,1,1,0,0,5,5,7,7,7,7,6,6,1,1,5,5,7,7,5,5,2,2,4,4,5,5,1,1,7,7,2,2,5,5,2,2,4,4,5,5,1,1,4,4,2,2,4,4,4,4,0,0,3,3,1,1,0,0,5,5,2,2,7,7,3,3,1,1,3,3,1,1,2,2,2,2,5,5,2,2,2,2,0,0,7,7,7,7,5,5,2,2,5,5,2,2,2,2,4,4,3,3,2,2,3,3,5,5,4,4,6,6,3,3,0,0,3,3,2,2,5,5,0,0,4,4,0,0,4,4,6,6,5,5,7,7,0,0,2,2,0,0,0,0,1,1,0,0,2,2,3,3,6,6,0,0,0,0,5,5,3,3,5,5,5,5,2,2,2,2,0,0,0,0,1,1,2,2,5,5,5,5,4,4,1,1,0,0,1,1,4,4,6,6,7,7,6,6,6,6,3,3,2,2,3,3,4,4,6,6,4,4,2,2,5,5,2,2,7,7,0,0,4,4,4,4,4,4,3,3,3,3,5,5,2,2,5,5,7,7,2,2,1,1,1,1,3,3,5,5,0,0,1,1,7,7,7,7,7,7,6,6,3,3,6,6,7,7,7,7,0,0,5,5,2,2,6,6,1,1,6,6,7,7,5,5,1,1,6,6,7,7,1,1,4,4,1,1,6,6,5,5,5,5,5,5,0,0,1,1,2,2,0,0,4,4,7,7,7,7,1,1,6,6,1,1,1,1,3,3,2,2,0,0,2,2,4,4,3,3,5,5,3,3,7,7,4,4,6,6,0,0,3,3,6,6,1,1,0,0,0,0,4,4,7,7,4,4,2,2,7,7,0,0,0,0,7,7,1,1,6,6,0,0,6,6,4,4,6,6,3,3,4,4,6,6,0,0,1,1,6,6,2,2,5,5,2,2,7,7,7,7,6,6,1,1,1,1,2,2,3,3,5,5,3,3,4,4,1,1,4,4,2,2,6,6,2,2,5,5,4,4,5,5,7,7,0,0,4,4,3,3,6,6,6,6,6,6,4,4,6,6,5,5,4,4,4,4,0,0,7,7,0,0,6,6,2,2,3,3,2,2,4,4,1,1,6,6,0,0,5,5,1,1,6,6,0,0,3,3,2,2,7,7,5,5,2,2,4,4,5,5,2,2,6,6,2,2,0,0,4,4,0,0,3,3,3,3,3,3,4,4,0,0,3,3,0,0,5,5,6,6,1,1,5,5,1,1,7,7,6,6,6,6,1,1,2,2,2,2,7,7,0,0,1,1,6,6,4,4,4,4,1,1,1,1,1,1,6,6,5,5,3,3,0,0,4,4,1,1,2,2,1,1,2,2,5,5,1,1,1,1,6,6,7,7,5,5,4,4,2,2,4,4,6,6,0,0,3,3,2,2,4,4,6,6,2,2,6,6,0,0,1,1,0,0,7,7,0,0,1,1,6,6,6,6,4,4,3,3,1,1,4,4,0,0,5,5,5,5,4,4,6,6,6,6,3,3,1,1,4,4,5,5,1,1,5,5,7,7,0,0,1,1,0,0,1,1,6,6,4,4,1,1,3,3,3,3,5,5,0,0,0,0,3,3,7,7,7,7,0,0,4,4,4,4,2,2,1,1,5,5,2,2,2,2,3,3,7,7,3,3,1,1,4,4,5,5,0,0,5,5,1,1,2,2,2,2,0,0,5,5,4,4,6,6,5,5,7,7,6,6,0,0,2,2,3,3,4,4,7,7,2,2,4,4,6,6,3,3,0,0,1,1,3,3,6,6,7,7,3,3,2,2,4,4,4,4,0,0,7,7,7,7,4,4,3,3,0,0,6,6,5,5,1,1,4,4,2,2,2,2,5,5,4,4,0,0,0,0,4,4,6,6,3,3,5,5,3,3,2,2,4,4,5,5,2,2,6,6,3,3,3,3,2,2,3,3,2,2,6,6,1,1,7,7,3,3,7,7,1,1,2,2,3,3,5,5,0,0,3,3,2,2,2,2,2,2,1,1,2,2,4,4,0,0,6,6,6,6,3,3,6,6,2,2,2,2,4,4,6,6,0,0,7,7,6,6,3,3,7,7,6,6,3,3,6,6,4,4,5,5,1,1,1,1,4,4,7,7,5,5,0,0,2,2,5,5,6,6,1,1,6,6,3,3,4,4,2,2,1,1,2,2,6,6,1,1,2,2,1,1,3,3,5,5,5,5,3,3,3,3,5,5,5,5,5,5,2,2,0,0,5,5,7,7,3,3,5,5,5,5,0,0,5,5,0,0,2,2,5,5,2,2,7,7,2,2,4,4,0,0,5,5,5,5,6,6,2,2,4,4,6,6,1,1,5,5,2,2,0,0,4,4,6,6,0,0,7,7,4,4,4,4,3,3,6,6,3,3,3,3,2,2,7,7,6,6,0,0,0,0,2,2,3,3,1,1,4,4,1,1,6,6,2,2,6,6,5,5,7,7,2,2,6,6,5,5,2,2,5,5,1,1,4,4,6,6,2,2,2,2,4,4,3,3,5,5,5,5,2,2,6,6,7,7,6,6,7,7,6,6,2,2,1,1,5,5,2,2,1,1,7,7,3,3,4,4,1,1,1,1,7,7,2,2,7,7,3,3,6,6,3,3,1,1,3,3,5,5,5,5,5,5,7,7,7,7,6,6,1,1,0,0,5,5,4,4,2,2,2,2,4,4,4,4,4,4,5,5,0,0,7,7,2,2,2,2,1,1,4,4,5,5,0,0,0,0,6,6,4,4,7,7,2,2,1,1,2,2,4,4,2,2,0,0,2,2,2,2,0,0,0,0,0,0,7,7,3,3,3,3,6,6,4,4,2,2,6,6,5,5,3,3,7,7,6,6,6,6,3,3,6,6,0,0,1,1,2,2,0,0,6,6,7,7,2,2,5,5,2,2,5,5,1,1,4,4,3,3,0,0,3,3,7,7,1,1,6,6,7,7,7,7,3,3,2,2,4,4,7,7,6,6,4,4,2,2,1,1,3,3,0,0,6,6,2,2,6,6,4,4,2,2,3,3,4,4,4,4,1,1,1,1,6,6,0,0,6,6,6,6,7,7,1,1,4,4,4,4,0,0,0,0,5,5,1,1,5,5,7,7,4,4,4,4,5,5,0,0,5,5,7,7,2,2,5,5,7,7,0,0,2,2,6,6,6,6,3,3,0,0,6,6,7,7,3,3,3,3,2,2,5,5,6,6,1,1,4,4,3,3,4,4,1,1,0,0,3,3,5,5,0,0,5,5,0,0,2,2,2,2,5,5,1,1,6,6,6,6,2,2,2,2,6,6,4,4,2,2,6,6,2,2,2,2,3,3,7,7,1,1,7,7,5,5,6,6,4,4,6,6,0,0,7,7,5,5,3,3,1,1,0,0,3,3,2,2,2,2,2,2,2,2,3,3,5,5,7,7,4,4,3,3,1,1,4,4,3,3,1,1,3,3,3,3,1,1,2,2,2,2,6,6,4,4,4,4,4,4,0,0,1,1,7,7,1,1,3,3,1,1,0,0,4,4,7,7,0,0,4,4,0,0,6,6,4,4,4,4,6,6,4,4,5,5,7,7,4,4,4,4,0,0,7,7,2,2,4,4,4,4,1,1,3,3,2,2,4,4,1,1,2,2,4,4,6,6,4,4,0,0,7,7,5,5,1,1,4,4,4,4,7,7,2,2,0,0,5,5,7,7,7,7,5,5,0,0,7,7,0,0,5,5,0,0,5,5,1,1,3,3,3,3,3,3,0,0,2,2,5,5,1,1,2,2,7,7,6,6,3,3,1,1,5,5,7,7,4,4,7,7,2,2,6,6,7,7,1,1,3,3,1,1,1,1,7,7,0,0,1,1,1,1,2,2,4,4,7,7,5,5,1,1,7,7,2,2,4,4,4,4,1,1,5,5,7,7,5,5,0,0,0,0,5,5,3,3,7,7,1,1,5,5,4,4,7,7,4,4,4,4,5,5,4,4,3,3,0,0,1,1,6,6,6,6,7,7,6,6,7,7,3,3,7,7,2,2,2,2,0,0,1,1,1,1,7,7,5,5,7,7,1,1,2,2,2,2,2,2,0,0,0,0,5,5,1,1,2,2,4,4,0,0,7,7,4,4,2,2,7,7,0,0,7,7,7,7,4,4,6,6,4,4,3,3,6,6,2,2,5,5,2,2,3,3,7,7,0,0,0,0,3,3,7,7,6,6,0,0,1,1,2,2,0,0,3,3,2,2,0,0,5,5,5,5,4,4,3,3,6,6,4,4,2,2,1,1,2,2,0,0,3,3,5,5,6,6,3,3,1,1,5,5,2,2,1,1,5,5,5,5,4,4,0,0,4,4,0,0,0,0,6,6,0,0,5,5,0,0,5,5,3,3,1,1,0,0,6,6,1,1,0,0,7,7,6,6,2,2,4,4,1,1,2,2,3,3,5,5,3,3,3,3,7,7,2,2,7,7,4,4,2,2,5,5,1,1,6,6,3,3,0,0,3,3,4,4,2,2,7,7,3,3,4,4,1,1,1,1,1,1,3,3,2,2,2,2,4,4,5,5,0,0,5,5,6,6,3,3,3,3,2,2,5,5,2,2,2,2,1,1,5,5,7,7,0,0,4,4,2,2,1,1,0,0,2,2,4,4,3,3,6,6,1,1,0,0,5,5,3,3,0,0,0,0,1,1,2,2,7,7,5,5,6,6,6,6,6,6,2,2,1,1,4,4,2,2,4,4,0,0,5,5,0,0,0,0,3,3,2,2,2,2,6,6,7,7,6,6,7,7,0,0,7,7,3,3,7,7,4,4,7,7,1,1,3,3,5,5,1,1,6,6,5,5,3,3,2,2,1,1,4,4,3,3,7,7,1,1,7,7,7,7,1,1,7,7,5,5,3,3,0,0,2,2,0,0,6,6,5,5,3,3,4,4,6,6,4,4,5,5,6,6,5,5,5,5,4,4,1,1,2,2,3,3,4,4,3,3,1,1,7,7,7,7,4,4,6,6,3,3,7,7,2,2,0,0,4,4,6,6,5,5,3,3,0,0,7,7,0,0,1,1,0,0,0,0,5,5,5,5,6,6,5,5,3,3,3,3,2,2,5,5,6,6,7,7,1,1,2,2,4,4,2,2,7,7,7,7,1,1,7,7,1,1,0,0,1,1,5,5,2,2,3,3,0,0,4,4,2,2,2,2,4,4,3,3,3,3,6,6,4,4,3,3,2,2,5,5,4,4,2,2,3,3,5,5,2,2,7,7,6,6,2,2,4,4,7,7,0,0,7,7,4,4,6,6,7,7,7,7,3,3,6,6,2,2,4,4,4,4,6,6,3,3,2,2,1,1,7,7,7,7,0,0,5,5,1,1,6,6,4,4,5,5,5,5,5,5,4,4,6,6,7,7,7,7,1,1,1,1,7,7,0,0,5,5,0,0,1,1,6,6,0,0,5,5,1,1,7,7,0,0,6,6,2,2,5,5,0,0,3,3,4,4,0,0,7,7,6,6,3,3,1,1,6,6,0,0,2,2,0,0,4,4,2,2,6,6,0,0,0,0,7,7,7,7,7,7,0,0,1,1,7,7,7,7,0,0,2,2,2,2,3,3,4,4,0,0,6,6,6,6,4,4,4,4,6,6,7,7,4,4,7,7,2,2,0,0,1,1,4,4,3,3,5,5,0,0,7,7,0,0,3,3,1,1,4,4,2,2,2,2,4,4,6,6,1,1,7,7,1,1,4,4,0,0,0,0,0,0,4,4,2,2,4,4,4,4,0,0,6,6,1,1,6,6,3,3,4,4,5,5,2,2,4,4,1,1,6,6,5,5,1,1,7,7,6,6,5,5,1,1,3,3,3,3,6,6,3,3,6,6,1,1,3,3,6,6,7,7,7,7,0,0,2,2,0,0,2,2,4,4,7,7,2,2,2,2,0,0,2,2,7,7,2,2,2,2,3,3,7,7,1,1,3,3,3,3,4,4,0,0,0,0,7,7,2,2,2,2,0,0,5,5,5,5,6,6,1,1,2,2,7,7,1,1,4,4,3,3,6,6,6,6,1,1,7,7,5,5,0,0,0,0,6,6,7,7,2,2,2,2,0,0,5,5,2,2,5,5,4,4,1,1,0,0,3,3,0,0,3,3,0,0,2,2,1,1,1,1,4,4,3,3,2,2,6,6,3,3,5,5,3,3,2,2,6,6,2,2,1,1,6,6,4,4,6,6,7,7,4,4,7,7,3,3,0,0,6,6,7,7,0,0,4,4,2,2,4,4,7,7,1,1,0,0,1,1,4,4,5,5,2,2,6,6,4,4,4,4,7,7,7,7,2,2,2,2,2,2,2,2,3,3,1,1,6,6,5,5,7,7,7,7,0,0,7,7,1,1,3,3,6,6,3,3,5,5,5,5,0,0,0,0,3,3,0,0,1,1,7,7,6,6,0,0,3,3,2,2,0,0,2,2,5,5,3,3,0,0,0,0,1,1,6,6,1,1,4,4,6,6,2,2,4,4,3,3,4,4,6,6,2,2,1,1,7,7,5,5,6,6,3,3,7,7,0,0,3,3,4,4,4,4,3,3,0,0,2,2,5,5,7,7,3,3,6,6,7,7,0,0,2,2,0,0,6,6,3,3,4,4,4,4,2,2,1,1,5,5,0,0,6,6,3,3,1,1,3,3,4,4,5,5,2,2,1,1,0,0,6,6,0,0,1,1,4,4,3,3,3,3,0,0,3,3,7,7,7,7,7,7,0,0,6,6,4,4,4,4,6,6,5,5,5,5,3,3,3,3,2,2,2,2,7,7,2,2,4,4,5,5,0,0,5,5,3,3,7,7,5,5,3,3,1,1,6,6,7,7,1,1,6,6,6,6,1,1,6,6,3,3,7,7,1,1,3,3,6,6,6,6,2,2,6,6,1,1,4,4,4,4,6,6,6,6,0,0,5,5,4,4,0,0,4,4,4,4,3,3,3,3,0,0,5,5,5,5,2,2,4,4,7,7,3,3,2,2,5,5,6,6,7,7,0,0,4,4,7,7,5,5,2,2,5,5,3,3,3,3,3,3,1,1,7,7,3,3,7,7,1,1,7,7,7,7,3,3,3,3,5,5,0,0,4,4,0,0,2,2,4,4,4,4,3,3,5,5,5,5,2,2,6,6,6,6,1,1,2,2,2,2,3,3,2,2,0,0,6,6,2,2,1,1,5,5,6,6,0,0,5,5,3,3,0,0,7,7,7,7,7,7,7,7,4,4,1,1,0,0,5,5,4,4,2,2,6,6,3,3,1,1,4,4,1,1,1,1,2,2,3,3,6,6,7,7,6,6,2,2,6,6,6,6,6,6,3,3,0,0,4,4,1,1,5,5,3,3,1,1,0,0,6,6,5,5,2,2,5,5,5,5,2,2,4,4,7,7,2,2,4,4,6,6,0,0,5,5,6,6,5,5,2,2,0,0,4,4,4,4,3,3,1,1,4,4,5,5,6,6,1,1,0,0,0,0,2,2,1,1,4,4,4,4,7,7,6,6,6,6,6,6,5,5,3,3,0,0,2,2,1,1,0,0,7,7,7,7,3,3,4,4,5,5,4,4,4,4,2,2,4,4,7,7,0,0,7,7,2,2,2,2,0,0,1,1,2,2,0,0,3,3,0,0,2,2,3,3,3,3,5,5,3,3,5,5,6,6,3,3,2,2,3,3,0,0,4,4,7,7,4,4,0,0,3,3,7,7,2,2,0,0,5,5,5,5,3,3,3,3,6,6,3,3,3,3,5,5,6,6,3,3,7,7,7,7,6,6,5,5,1,1,4,4,4,4,7,7,6,6,1,1,2,2,2,2,0,0,7,7,2,2,5,5,4,4,6,6,3,3,3,3,0,0,0,0,2,2,0,0,4,4,7,7,0,0,7,7,2,2,4,4,0,0,1,1,0,0,0,0,4,4,3,3,4,4,1,1,5,5,6,6,7,7,6,6,3,3,3,3,7,7,1,1,0,0,0,0,3,3,3,3,0,0,1,1,1,1,4,4,3,3,6,6,2,2,0,0,2,2,2,2,3,3,0,0,6,6,6,6,5,5,4,4,3,3,3,3,0,0,7,7,7,7,6,6,2,2,4,4,2,2,5,5,1,1,2,2,0,0,0,0,7,7,7,7,4,4,3,3,7,7,4,4,2,2,0,0,1,1,4,4,3,3,7,7,0,0,7,7,6,6,6,6,0,0,5,5,6,6,0,0,2,2,5,5,3,3,2,2,5,5,1,1,5,5,1,1,3,3,0,0,0,0,2,2,1,1,7,7,5,5,5,5,7,7,5,5,0,0,6,6,7,7,4,4,5,5,4,4,2,2,0,0,6,6,0,0,4,4,0,0,1,1,6,6,6,6,3,3,0,0,6,6,6,6,4,4,2,2,4,4,3,3,2,2,0,0,4,4,6,6,4,4,0,0,2,2,2,2,6,6,0,0,3,3,6,6,5,5,1,1,0,0,0,0,1,1,7,7,7,7,2,2,4,4,1,1,3,3,1,1,3,3,6,6,3,3,5,5,0,0,0,0,1,1,0,0,5,5,2,2,5,5,0,0,5,5,0,0,0,0,6,6,1,1,2,2,3,3,1,1,1,1,5,5,5,5,4,4,5,5,3,3,2,2,5,5,1,1,5,5,0,0,7,7,5,5,4,4,3,3,2,2,0,0,1,1,2,2,7,7,3,3,2,2,0,0,0,0,2,2,7,7,3,3,5,5,4,4,5,5,0,0,7,7,7,7,0,0,3,3,1,1,6,6,5,5,1,1,3,3,6,6,2,2,0,0,1,1,5,5,4,4,0,0,1,1,5,5,1,1,6,6,4,4,5,5,7,7,5,5,2,2,0,0,3,3,6,6,4,4,1,1,5,5,7,7,4,4,3,3,0,0,3,3,2,2,0,0,2,2,7,7,6,6,4,4,3,3,4,4,5,5,2,2,3,3,7,7,1,1,7,7,2,2,1,1,6,6,1,1,0,0,0,0,5,5,3,3,0,0,3,3,3,3,7,7,4,4,4,4,7,7,1,1,5,5,2,2,7,7,1,1,4,4,0,0,3,3,7,7,2,2,4,4,5,5,5,5,3,3,0,0,4,4,7,7,0,0,3,3,3,3,3,3,1,1,4,4,7,7,3,3,7,7,2,2,0,0,0,0,1,1,7,7,4,4,7,7,3,3,5,5,1,1,7,7,6,6,0,0,7,7,6,6,3,3,4,4,4,4,3,3,0,0,0,0,0,0,6,6,0,0,5,5,5,5,7,7,5,5,5,5,1,1,4,4,0,0,0,0,4,4,0,0,5,5,3,3,0,0,7,7,7,7,5,5,2,2,7,7,4,4,4,4,6,6,3,3,2,2,0,0,6,6,0,0,2,2,4,4,0,0,2,2,5,5,1,1,1,1,0,0,0,0,5,5,5,5,6,6,0,0,2,2,2,2,5,5,4,4,6,6,0,0,0,0,4,4,2,2,1,1,4,4,1,1,1,1,2,2,1,1,1,1,6,6,4,4,2,2,6,6,2,2,0,0,3,3,2,2,7,7,3,3,6,6,4,4,1,1,7,7,4,4,2,2,4,4,3,3,4,4,7,7,1,1,6,6,1,1,4,4,1,1,0,0,0,0,3,3,1,1,0,0,1,1,4,4,3,3,3,3,0,0,2,2,0,0,3,3,4,4,2,2,6,6,4,4,4,4,6,6,0,0,2,2,6,6,4,4,0,0,3,3,5,5,0,0,6,6,7,7,2,2,2,2,5,5,7,7,4,4,7,7,1,1,7,7,0,0,6,6,3,3,4,4,6,6,0,0,3,3,0,0,0,0,4,4,5,5,4,4,4,4,1,1,7,7,4,4,5,5,3,3,7,7,5,5,6,6,4,4,2,2,2,2,6,6,5,5,2,2,0,0,2,2,5,5,1,1,6,6,6,6,1,1,2,2,6,6,1,1,5,5,1,1,3,3,1,1,7,7,3,3,6,6,0,0,5,5,4,4,1,1,0,0,0,0,1,1,6,6,6,6,0,0,1,1,3,3,4,4,4,4,3,3,6,6,5,5,4,4,1,1,4,4,4,4,5,5,4,4,5,5,6,6,7,7,7,7,6,6,6,6,6,6,7,7,4,4,0,0,1,1,1,1,4,4,3,3,4,4,3,3,6,6,4,4,6,6,0,0,5,5,1,1,4,4,5,5,3,3,3,3,6,6,6,6,0,0,0,0,3,3,0,0,4,4,2,2,0,0,4,4,2,2,0,0,0,0,7,7,1,1,3,3,3,3,1,1,3,3,3,3,3,3,2,2,6,6,7,7,4,4,4,4,0,0,4,4,5,5,2,2,7,7,2,2,4,4,7,7,3,3,5,5,0,0,4,4,3,3,7,7,4,4,0,0,1,1,0,0,1,1,5,5,6,6,2,2,5,5,5,5,7,7,3,3,7,7,5,5,1,1,1,1,0,0,2,2,0,0,7,7,6,6,1,1,4,4,4,4,3,3,2,2,4,4,5,5,7,7,3,3,3,3,1,1,0,0,1,1,1,1,4,4,6,6,3,3,4,4,7,7,1,1,1,1,0,0,0,0,2,2,4,4,5,5,1,1,1,1,4,4,0,0,6,6,1,1,2,2,1,1,2,2,2,2,6,6,0,0,1,1,5,5,7,7,1,1,3,3,4,4,2,2,2,2,6,6,2,2,3,3,7,7,3,3,3,3,3,3,4,4,0,0,7,7,0,0,5,5,5,5,0,0,2,2,4,4,1,1,3,3,3,3,6,6,2,2,0,0,2,2,2,2,3,3,0,0,6,6,5,5,0,0,1,1,0,0,6,6,3,3,4,4,2,2,0,0,6,6,0,0,1,1,7,7,1,1,2,2,2,2,6,6,5,5,7,7,5,5,3,3,6,6,0,0,3,3,5,5,7,7,6,6,3,3,5,5,6,6,3,3,1,1,1,1,7,7,4,4,0,0,6,6,0,0,7,7,7,7,5,5,0,0,1,1,7,7,4,4,1,1,3,3,4,4,0,0,5,5,1,1,0,0,3,3,5,5,7,7,0,0,4,4,3,3,1,1,4,4,3,3,5,5,4,4,4,4,0,0,1,1,3,3,1,1,7,7,5,5,4,4,6,6,2,2,0,0,0,0,1,1,5,5,0,0,0,0,2,2,1,1,3,3,7,7,1,1,3,3,1,1,0,0,6,6,0,0,2,2,4,4,2,2,7,7,5,5,7,7,6,6,1,1,2,2,3,3,5,5,2,2,7,7,4,4,4,4,6,6,3,3,5,5,1,1,5,5,7,7,4,4,3,3,5,5,5,5,0,0,4,4,6,6,2,2,0,0,0,0,7,7,0,0,5,5,6,6,5,5,5,5,4,4,4,4,5,5,3,3,6,6,7,7,7,7,4,4,2,2,5,5,2,2,5,5,2,2,4,4,1,1,0,0,0,0,7,7,6,6,4,4,1,1,4,4,0,0,3,3,1,1,5,5,1,1,6,6,4,4,1,1,6,6,5,5,2,2,4,4,7,7,5,5,6,6,0,0,4,4,5,5,4,4,3,3,2,2,7,7,2,2,0,0,3,3,5,5,7,7,2,2,5,5,2,2,0,0,1,1,5,5,2,2,6,6,3,3,5,5,2,2,0,0,3,3,4,4,0,0,1,1,2,2,7,7,5,5,1,1,2,2,7,7,1,1,1,1,3,3,1,1,3,3,1,1,0,0,0,0,1,1,6,6,2,2,2,2,5,5,3,3,3,3,4,4,7,7,3,3,7,7,3,3,1,1,3,3,5,5,5,5,3,3,0,0,5,5,2,2,7,7,5,5,6,6,0,0,6,6,4,4,3,3,2,2,6,6,0,0,4,4,1,1,2,2,6,6,7,7,1,1,0,0,6,6,0,0,3,3,5,5,4,4,5,5,2,2,0,0,6,6,4,4,7,7,1,1,1,1,0,0,4,4,4,4,0,0,2,2,6,6,0,0,4,4,5,5,5,5,5,5,6,6,2,2,7,7,2,2,3,3,1,1,2,2,2,2,0,0,0,0,6,6,2,2,4,4,3,3,1,1,0,0,1,1,3,3,4,4,7,7,2,2,2,2,4,4,0,0,0,0,3,3,2,2,0,0,6,6,2,2,4,4,4,4,5,5,2,2,2,2,2,2,4,4,0,0,0,0,7,7,0,0,2,2,6,6,5,5,4,4,0,0,3,3,7,7,3,3,0,0,2,2,1,1,6,6,1,1,1,1,1,1,4,4,5,5,2,2,5,5,2,2,7,7,7,7,0,0,1,1,0,0,4,4,7,7,3,3,2,2,0,0,0,0,2,2,0,0,1,1,7,7,6,6,4,4,0,0,0,0,6,6,7,7,7,7,6,6,2,2,7,7,2,2,1,1,6,6,0,0,7,7,3,3,3,3,3,3,6,6,2,2,3,3,2,2,0,0,5,5,2,2,3,3,5,5,4,4,4,4,4,4,7,7,0,0,2,2,2,2,2,2,6,6,7,7,4,4,0,0,0,0,5,5,3,3,1,1,4,4,2,2,0,0,5,5,6,6,0,0,5,5,2,2,2,2,2,2,4,4,2,2,3,3,7,7,7,7,1,1,2,2,7,7,7,7,4,4,1,1,1,1,4,4,4,4,0,0,5,5,0,0,2,2,0,0,0,0,0,0,1,1,3,3,2,2,4,4,6,6,2,2,5,5,7,7,7,7,3,3,2,2,6,6,3,3,6,6,7,7,5,5,4,4,6,6,0,0,6,6,2,2,7,7,3,3,1,1,2,2,0,0,5,5,7,7,2,2,0,0,4,4,3,3,0,0,2,2,7,7,7,7,5,5,2,2,2,2,6,6,5,5,6,6,4,4,5,5,7,7,7,7,6,6,6,6,1,1,0,0,2,2,2,2,2,2,0,0,6,6,2,2,0,0,6,6,3,3,6,6,5,5,4,4,0,0,0,0,6,6,2,2,7,7,7,7,1,1,0,0,7,7,2,2,4,4,1,1,1,1,0,0,5,5,7,7,4,4,2,2,4,4,0,0,5,5,7,7,0,0,5,5,5,5,3,3,0,0,5,5,4,4,2,2,0,0,5,5,3,3,6,6,4,4,2,2,0,0,1,1,4,4,2,2,3,3,5,5,0,0,1,1,0,0,0,0,6,6,1,1,0,0,2,2,7,7,3,3,2,2,0,0,4,4,0,0,6,6,3,3,2,2,7,7,7,7,4,4,2,2,4,4,0,0,2,2,4,4,4,4,2,2,4,4,1,1,6,6,4,4,6,6,6,6,2,2,1,1,5,5,3,3,2,2,7,7,6,6,2,2,0,0,7,7,5,5,5,5,7,7,4,4,3,3,6,6,2,2,1,1,1,1,2,2,6,6,3,3,0,0,3,3,3,3,3,3,4,4,3,3,7,7,5,5,3,3,7,7,0,0,5,5,0,0,6,6,7,7,0,0,7,7,4,4,6,6,6,6,0,0,3,3,3,3,3,3,5,5,6,6,5,5,7,7,3,3,4,4,3,3,7,7,4,4,4,4,3,3,5,5,1,1,0,0,3,3,5,5,2,2,7,7,3,3,3,3,3,3,6,6,2,2,3,3,1,1,2,2,2,2,1,1,1,1,0,0,5,5,5,5,1,1,0,0,2,2,7,7,1,1,0,0,1,1,2,2,1,1,7,7,5,5,5,5,4,4,2,2,6,6,7,7,4,4,7,7,4,4,2,2,3,3,2,2,4,4,6,6,1,1,1,1,6,6,1,1,2,2,2,2,2,2,3,3,5,5,2,2,0,0,6,6,5,5,0,0,6,6,4,4,2,2,1,1,7,7,0,0,0,0,1,1,2,2,3,3,7,7,0,0,6,6,6,6,2,2,2,2,6,6,0,0,4,4,7,7,4,4,6,6,4,4,1,1,0,0,3,3,3,3,3,3,0,0,2,2,6,6,6,6,3,3,5,5,4,4,5,5,3,3,6,6,1,1,4,4,2,2,2,2,7,7,0,0,7,7,6,6,3,3,3,3,7,7,5,5,3,3,2,2,7,7,1,1,2,2,1,1,5,5,5,5,0,0,3,3,5,5,2,2,2,2,3,3,5,5,6,6,7,7,1,1,4,4,3,3,3,3,4,4,1,1,2,2,3,3,6,6,5,5,3,3,1,1,5,5,2,2,2,2,4,4,1,1,5,5,2,2,1,1,4,4,7,7,0,0,4,4,1,1,2,2,1,1,6,6,6,6,0,0,6,6,2,2,0,0,4,4,6,6,5,5,7,7,0,0,5,5,7,7,2,2,1,1,4,4,6,6,7,7,2,2,4,4,0,0,3,3,2,2,0,0,5,5,5,5,6,6,5,5,3,3,2,2,7,7,1,1,1,1,1,1,7,7,1,1,1,1,0,0,6,6,3,3,6,6,6,6,5,5,7,7,2,2,4,4,1,1,2,2,2,2,2,2,2,2,3,3,5,5,0,0,6,6,3,3,0,0,1,1,5,5,0,0,5,5,1,1,2,2,0,0,3,3,2,2,3,3,1,1,1,1,1,1,0,0,6,6,7,7,4,4,2,2,0,0,7,7,2,2,7,7,4,4,3,3,0,0,2,2,7,7,2,2,3,3,2,2,2,2,5,5,1,1,4,4,6,6,7,7,4,4,5,5,4,4,6,6,6,6,0,0,6,6,5,5,3,3,6,6,4,4,1,1,4,4,4,4,5,5,6,6,1,1,1,1,2,2,1,1,0,0,6,6,7,7,1,1,2,2,0,0,3,3,2,2,6,6,6,6,0,0,7,7,5,5,2,2,5,5,1,1,0,0,6,6,6,6,3,3,4,4,0,0,0,0,0,0,4,4,0,0,2,2,1,1,2,2,2,2,1,1,5,5,6,6,0,0,0,0,3,3,4,4,3,3,3,3,2,2,4,4,6,6,6,6,1,1,1,1,0,0,2,2,6,6,3,3,4,4,2,2,5,5,0,0,3,3,0,0,3,3,3,3,3,3,7,7,2,2,1,1,0,0,6,6,1,1,5,5,0,0,2,2,0,0,3,3,3,3,2,2,4,4,1,1,5,5,4,4,2,2,3,3,1,1,5,5,5,5,3,3,4,4,7,7,3,3,0,0,7,7,2,2,1,1,4,4,7,7,3,3,1,1,6,6,2,2,5,5,0,0,5,5,1,1,1,1,3,3,7,7,6,6,5,5,2,2,3,3,0,0,4,4,6,6,7,7,6,6,2,2,3,3,1,1,1,1,7,7,4,4,1,1,6,6,3,3,1,1,6,6,2,2,5,5,2,2,6,6,2,2,2,2,1,1,4,4,3,3,7,7,3,3,5,5,4,4,6,6,6,6,1,1,6,6,7,7,3,3,4,4,6,6,5,5,6,6,4,4,4,4,0,0,5,5,3,3,4,4,4,4,2,2,4,4,1,1,7,7,2,2,2,2,1,1,2,2,3,3,7,7,2,2,4,4,1,1,6,6,2,2,5,5,5,5,5,5,3,3,7,7,7,7,0,0,5,5,4,4,7,7,3,3,6,6,7,7,1,1,6,6,4,4,1,1,0,0,3,3,2,2,6,6,6,6,6,6,2,2,3,3,3,3,2,2,0,0,6,6,2,2,6,6,1,1,2,2,6,6,1,1,4,4,3,3,5,5,3,3,6,6,0,0,2,2,3,3,5,5,1,1,4,4,6,6,3,3,2,2,5,5,4,4,4,4,3,3,0,0,3,3,1,1,1,1,0,0,0,0,5,5,0,0,6,6,4,4,4,4,4,4,5,5,0,0,6,6,4,4,6,6,3,3,5,5,7,7,0,0,6,6,1,1,1,1,0,0,5,5,0,0,4,4,3,3,6,6,3,3,3,3,1,1,1,1,4,4,5,5,0,0,5,5,1,1,7,7,4,4,2,2,7,7,4,4,6,6,2,2,7,7,3,3,3,3,1,1,4,4,7,7,0,0,1,1,1,1,1,1,4,4,2,2,6,6,1,1,3,3,4,4,3,3,1,1,1,1,3,3,4,4,0,0,2,2,4,4,7,7,7,7,4,4,2,2,6,6,5,5,0,0,4,4,7,7,0,0,7,7,5,5,7,7,0,0,0,0,2,2,6,6,6,6,0,0,7,7,4,4,2,2,0,0,5,5,2,2,7,7,3,3,2,2,5,5,3,3,2,2,2,2,7,7,6,6,4,4,7,7,0,0,2,2,0,0,0,0,4,4,4,4,4,4,1,1,2,2,1,1,3,3,5,5,5,5,2,2,5,5,0,0,0,0,5,5,0,0,0,0,2,2,3,3,4,4,0,0,5,5,7,7,3,3,6,6,3,3,6,6,6,6,0,0,1,1,2,2,4,4,2,2,5,5,3,3,3,3,2,2,6,6,4,4,2,2,7,7,5,5,3,3,6,6,7,7,7,7,7,7,0,0,3,3,6,6,4,4,3,3,0,0,3,3,1,1,1,1,0,0,6,6,3,3,0,0,2,2,7,7,5,5,5,5,5,5,6,6,6,6,4,4,7,7,1,1,1,1,4,4,3,3,3,3,0,0,6,6,3,3,7,7,0,0,4,4,1,1,7,7,7,7,7,7,7,7,5,5,2,2,2,2,0,0,4,4,7,7,6,6,0,0,0,0,4,4,1,1,4,4,4,4,4,4,1,1,7,7,1,1,5,5,0,0,6,6,4,4,4,4,2,2,3,3,5,5,1,1,4,4,6,6,2,2,7,7,1,1,0,0,1,1,5,5,6,6,0,0,5,5,6,6,7,7,5,5,2,2,0,0,5,5,4,4,3,3,0,0,0,0,3,3,4,4,4,4,0,0,3,3,5,5,5,5,3,3,2,2,4,4,3,3,3,3,6,6,2,2,0,0,0,0,1,1,1,1,6,6,1,1,6,6,5,5,1,1,6,6,6,6,1,1,0,0,4,4,3,3,1,1,2,2,4,4,0,0,0,0,0,0,0,0,2,2,4,4,4,4,6,6,1,1,4,4,2,2,4,4,3,3,2,2,0,0,0,0,1,1,1,1,1,1,6,6,0,0,7,7,0,0,2,2,4,4,5,5,5,5,6,6,4,4,4,4,0,0,0,0,0,0,2,2,1,1,0,0,0,0,1,1,3,3,2,2,6,6,5,5,7,7,7,7,0,0,6,6,7,7,3,3,0,0,2,2,1,1,7,7,5,5,6,6,7,7,4,4,4,4,1,1,2,2,2,2,1,1,3,3,2,2,2,2,3,3,3,3,4,4,6,6,4,4,7,7,6,6,4,4,3,3,2,2,4,4,1,1,5,5,5,5,2,2,7,7,7,7,0,0,2,2,3,3,0,0,4,4,7,7,1,1,0,0,7,7,2,2,5,5,5,5,3,3,2,2,5,5,4,4,6,6,2,2,0,0,5,5,2,2,1,1,7,7,3,3,7,7,1,1,4,4,1,1,1,1,6,6,5,5,2,2,4,4,1,1,5,5,6,6,2,2,4,4,3,3,2,2,1,1,2,2,4,4,1,1,3,3,1,1,4,4,0,0,6,6,6,6,7,7,3,3,6,6,0,0,7,7,2,2,2,2,7,7,2,2,5,5,6,6,4,4,5,5,1,1,5,5,2,2,4,4,6,6,5,5,2,2,2,2,1,1,0,0,1,1,5,5,6,6,4,4,1,1,1,1,0,0,5,5,4,4,0,0,1,1,5,5,5,5,2,2,5,5,6,6,0,0,7,7,3,3,4,4,7,7,6,6,6,6,0,0,3,3,5,5,6,6,3,3,2,2,5,5,1,1,1,1,6,6,5,5,1,1,3,3,3,3,3,3,1,1,1,1,5,5,2,2,0,0,2,2,5,5,7,7,3,3,3,3,2,2,7,7,3,3,3,3,1,1,5,5,6,6,3,3,3,3,1,1,3,3,4,4,6,6,2,2,5,5,1,1,3,3,6,6,0,0,2,2,2,2,2,2,2,2,7,7,4,4,5,5,7,7,4,4,4,4,1,1,2,2,1,1,0,0,6,6,7,7,1,1,4,4,2,2,3,3,0,0,2,2,0,0,4,4,2,2,5,5,2,2,3,3,3,3,2,2,5,5,4,4,5,5,0,0,0,0,0,0,7,7,3,3,7,7,1,1,1,1,2,2,2,2,0,0,2,2,6,6,5,5,0,0,2,2,1,1,3,3,1,1,6,6,7,7,7,7,3,3,5,5,2,2,4,4,1,1,7,7,5,5,5,5,4,4,5,5,5,5,3,3,4,4,0,0,2,2,5,5,6,6,3,3,7,7,0,0,7,7,4,4,2,2,4,4,7,7,0,0,7,7,3,3,0,0,3,3,2,2,6,6,7,7,3,3,7,7,6,6,7,7,5,5,0,0,2,2,1,1,1,1,3,3,0,0,4,4,6,6,5,5,0,0,3,3,6,6,5,5,6,6,2,2,6,6,0,0,3,3,0,0,6,6,1,1,6,6,2,2,4,4,3,3,3,3,3,3,5,5,0,0,1,1,7,7,7,7,6,6,2,2,5,5,6,6,4,4,1,1,0,0,4,4,6,6,4,4,7,7,1,1,1,1,7,7,4,4,5,5,7,7,0,0,2,2,4,4,1,1,6,6,7,7,2,2,0,0,3,3,3,3,1,1,6,6,7,7,1,1,2,2,2,2,7,7,2,2,0,0,6,6,1,1,3,3,3,3,5,5,3,3,6,6,5,5,1,1,2,2,3,3,4,4,6,6,5,5,7,7,1,1,1,1,7,7,4,4,2,2,3,3,0,0,1,1,0,0,1,1,1,1,3,3,5,5,5,5,0,0,3,3,3,3,1,1,5,5,1,1,3,3,7,7,4,4,5,5,5,5,0,0,5,5,0,0,2,2,5,5,3,3,4,4,2,2,6,6,7,7,1,1,3,3,1,1,0,0,1,1,3,3,2,2,3,3,0,0,4,4,1,1,3,3,0,0,5,5,2,2,2,2,0,0,3,3,4,4,7,7,7,7,1,1,7,7,2,2,3,3,7,7,5,5,3,3,4,4,1,1,7,7,5,5,6,6,2,2,3,3,6,6,4,4,0,0,7,7,3,3,1,1,6,6,7,7,2,2,7,7,2,2,0,0,3,3,5,5,5,5,1,1,2,2,2,2,1,1,3,3,2,2,2,2,0,0,5,5,1,1,0,0,0,0,3,3,2,2,3,3,5,5,3,3,2,2,6,6,7,7,6,6,3,3,3,3,5,5,5,5,7,7,6,6,7,7,3,3,2,2,3,3,3,3,7,7,3,3,7,7,3,3,6,6,4,4,7,7,5,5,5,5,4,4,3,3,1,1,0,0,7,7,5,5,1,1,7,7,2,2,7,7,5,5,2,2,5,5,0,0,0,0,5,5,2,2,5,5,6,6,6,6,7,7,1,1,6,6,5,5,5,5,0,0,3,3,1,1,6,6,2,2,1,1,4,4,6,6,0,0,0,0,5,5,7,7,6,6,4,4,3,3,5,5,1,1,3,3,3,3,5,5,6,6,4,4,2,2,3,3,4,4,7,7,1,1,7,7,2,2,6,6,5,5,6,6,2,2,1,1,1,1,6,6,2,2,6,6,5,5,2,2,5,5,0,0,1,1,3,3,5,5,6,6,2,2,2,2,4,4,4,4,0,0,4,4,6,6,5,5,6,6,0,0,0,0,1,1,0,0,0,0,7,7,5,5,4,4,3,3,1,1,6,6,7,7,0,0,7,7,3,3,3,3,1,1,4,4,7,7,5,5,1,1,7,7,1,1,2,2,2,2,1,1,3,3,3,3,0,0,5,5,0,0,4,4,5,5,6,6,7,7,6,6,1,1,0,0,0,0,3,3,6,6,0,0,1,1,0,0,4,4,3,3,6,6,3,3,7,7,7,7,4,4,6,6,6,6,7,7,2,2,3,3,5,5,2,2,1,1,7,7,0,0,3,3,3,3,6,6,1,1,3,3,2,2,5,5,2,2,7,7,2,2,1,1,6,6,1,1,2,2,6,6,3,3,2,2,4,4,3,3,3,3,2,2,4,4,5,5,2,2,1,1,6,6,4,4,0,0,0,0,6,6,1,1,2,2,3,3,1,1,3,3,5,5,4,4,7,7,7,7,0,0,7,7,0,0,5,5,3,3,4,4,2,2,1,1,1,1,3,3,7,7,4,4,4,4,6,6,3,3,1,1,2,2,5,5,6,6,1,1,6,6,7,7,6,6,4,4,7,7,5,5,0,0,3,3,6,6,1,1,5,5,5,5,2,2,5,5,3,3,0,0,3,3,2,2,4,4,6,6,0,0,0,0,1,1,6,6,0,0,0,0,6,6,4,4,5,5,6,6,1,1,5,5,0,0,5,5,7,7,4,4,2,2,1,1,6,6,7,7,5,5,6,6,4,4,1,1,2,2,5,5,1,1,5,5,5,5,5,5,6,6,6,6,5,5,0,0,7,7,2,2,5,5,1,1,0,0,0,0,2,2,2,2,6,6,7,7,3,3,2,2,4,4,4,4,3,3,7,7,7,7,3,3,0,0,6,6,3,3,6,6,4,4,4,4,2,2,0,0,4,4,1,1,4,4,5,5,4,4,0,0,2,2,2,2,7,7,1,1,4,4,2,2,1,1,3,3,0,0,2,2,1,1,6,6,5,5,3,3,7,7,6,6,6,6,6,6,3,3,5,5,1,1,3,3,1,1,6,6,1,1,7,7,5,5,1,1,2,2,0,0,7,7,6,6,0,0,2,2,2,2,0,0,1,1,2,2,3,3,1,1,7,7,6,6,2,2,2,2,3,3,1,1,6,6,0,0,6,6,2,2,3,3,4,4,0,0,0,0,1,1,2,2,7,7,6,6,5,5,7,7,3,3,0,0,6,6,5,5,1,1,4,4,4,4,3,3,7,7,5,5,2,2,4,4,6,6,1,1,1,1,6,6,0,0,4,4,3,3,5,5,2,2,2,2,5,5,2,2,1,1,7,7,2,2,1,1,1,1,6,6,2,2,2,2,3,3,0,0,3,3,5,5,2,2,3,3,6,6,1,1,4,4,5,5,5,5,6,6,7,7,0,0,1,1,2,2,1,1,1,1,0,0,2,2,5,5,7,7,6,6,4,4,6,6,1,1,5,5,6,6,7,7,7,7,4,4,5,5,5,5,2,2,6,6,1,1,1,1,1,1,7,7,5,5,5,5,7,7,4,4,3,3,0,0,3,3,2,2,1,1,6,6,0,0,6,6,4,4,6,6,0,0,0,0,0,0,5,5,1,1,7,7,5,5,0,0,1,1,1,1,1,1,4,4,6,6,1,1,4,4,0,0,2,2,3,3,6,6,0,0,3,3,1,1,5,5,4,4,1,1,5,5,6,6,1,1,1,1,2,2,7,7,0,0,3,3,3,3,0,0,6,6,0,0,4,4,3,3,0,0,4,4,3,3,6,6,7,7,2,2,4,4,0,0,4,4,6,6,0,0,1,1,0,0,3,3,5,5,1,1,5,5,6,6,0,0,3,3,4,4,6,6,2,2,7,7,4,4,3,3,1,1,7,7,7,7,4,4,1,1,1,1,0,0,3,3,7,7,4,4,4,4,0,0,7,7,7,7,1,1,3,3,5,5,3,3,5,5,1,1,0,0,2,2,5,5,0,0,2,2,5,5,0,0,3,3,1,1,2,2,7,7,3,3,7,7,4,4,3,3,0,0,4,4,4,4,7,7,4,4,2,2,4,4,1,1,1,1,3,3,2,2,1,1,3,3,4,4,3,3,6,6,4,4,2,2,0,0,0,0,7,7,4,4,3,3,6,6,2,2,3,3,0,0,1,1,2,2,6,6,1,1,4,4,0,0,7,7,0,0,0,0,4,4,2,2,2,2,5,5,5,5,0,0,7,7,0,0,5,5,5,5,4,4,5,5,0,0,5,5,3,3,0,0,3,3,2,2,0,0,6,6,7,7,4,4,6,6,4,4,6,6,7,7,3,3,0,0,5,5,5,5,6,6,4,4,3,3,7,7,0,0,2,2,0,0,6,6,1,1,0,0,0,0,2,2,5,5,6,6,1,1,6,6,1,1,7,7,5,5,5,5,2,2,7,7,5,5,3,3,3,3,0,0,0,0,4,4,2,2,5,5,1,1,3,3,7,7,2,2,1,1,5,5,3,3,5,5,1,1,7,7,0,0,5,5,5,5,6,6,7,7,2,2,2,2,0,0,3,3,2,2,5,5,6,6,2,2,0,0,5,5,2,2,1,1,4,4,2,2,6,6,1,1,6,6,0,0,7,7,0,0,0,0,5,5,3,3,5,5,0,0,3,3,6,6,5,5,5,5,5,5,3,3,5,5,7,7,0,0,6,6,1,1,4,4,3,3,6,6,0,0,7,7,1,1,1,1,6,6,0,0,5,5,1,1,3,3,2,2,4,4,5,5,0,0,2,2,1,1,0,0,7,7,2,2,2,2,6,6,2,2,3,3,0,0,1,1,1,1,5,5,4,4,1,1,0,0,5,5,7,7,1,1,1,1,4,4,1,1,7,7,5,5,4,4,1,1,0,0,6,6,0,0,2,2,6,6,4,4,0,0,7,7,5,5,0,0,6,6,0,0,4,4,4,4,4,4,1,1,5,5,2,2,1,1,0,0,1,1,0,0,6,6,7,7,1,1,5,5,1,1,4,4,3,3,4,4,2,2,7,7,6,6,2,2,2,2,2,2,0,0,4,4,6,6,7,7,3,3,7,7,6,6,4,4,0,0,0,0,1,1,3,3,5,5,1,1,1,1,6,6,0,0,7,7,6,6,7,7,7,7,1,1,6,6,6,6,4,4,2,2,7,7,4,4,4,4,0,0,2,2,0,0,0,0,1,1,3,3,7,7,6,6,0,0,7,7,1,1,4,4,6,6,5,5,1,1,0,0,0,0,3,3,5,5,3,3,3,3,1,1,4,4,4,4,7,7,6,6,3,3,1,1,5,5,1,1,4,4,4,4,6,6,5,5,6,6,5,5,5,5,4,4,1,1,5,5,1,1,6,6,6,6,4,4,1,1,0,0,4,4,3,3,4,4,4,4,6,6,5,5,6,6,0,0,0,0,0,0,2,2,7,7,6,6,3,3,4,4,2,2,4,4,7,7,0,0,4,4,2,2,1,1,6,6,7,7,7,7,5,5,2,2,6,6,3,3,4,4,1,1,7,7,4,4,0,0,0,0,6,6,1,1,1,1,5,5,2,2,2,2,7,7,4,4,4,4,3,3,3,3,0,0,6,6,1,1,0,0,7,7,6,6,4,4,7,7,5,5,1,1,1,1,0,0,6,6,1,1,6,6,2,2,3,3,1,1,7,7,4,4,7,7,0,0,2,2,6,6,0,0,1,1,3,3,7,7,6,6,2,2,7,7,7,7,7,7,6,6,4,4,5,5,0,0,2,2,0,0,2,2,7,7,1,1,5,5,2,2,7,7,2,2,7,7,7,7,0,0,0,0,6,6,4,4,5,5,4,4,2,2,0,0,0,0,2,2,7,7,3,3,3,3,4,4,7,7,1,1,3,3,3,3,2,2,0,0,3,3,1,1,2,2,3,3,5,5,2,2,0,0,2,2,6,6,0,0,0,0,2,2,4,4,3,3,7,7,1,1,2,2,0,0,7,7,5,5,3,3,0,0,3,3,1,1,7,7,6,6,4,4,7,7,2,2,1,1,2,2,7,7,1,1,7,7,2,2,7,7,5,5,6,6,6,6,7,7,0,0,6,6,6,6,1,1,0,0,4,4,5,5,4,4,6,6,1,1,6,6,0,0,0,0,4,4,3,3,2,2,2,2,6,6,2,2,0,0,5,5,4,4,7,7,4,4,5,5,3,3,1,1,4,4,4,4,6,6,1,1,4,4,5,5,2,2,7,7,3,3,6,6,1,1,4,4,2,2,7,7,3,3,5,5,1,1,3,3,0,0,4,4,6,6,7,7,3,3,5,5,5,5,5,5,3,3,0,0,0,0,1,1,2,2,6,6,1,1,4,4,3,3,6,6,7,7,6,6,1,1,5,5,6,6,7,7,2,2,6,6,2,2,1,1,0,0,3,3,4,4,0,0,7,7,6,6,1,1,5,5,4,4,0,0,7,7,6,6,0,0,5,5,1,1,5,5,3,3,7,7,4,4,0,0,6,6,2,2,0,0,1,1,0,0,7,7,0,0,7,7,6,6,1,1,3,3,5,5,1,1,4,4,4,4,0,0,7,7,7,7,6,6,0,0,7,7,0,0,6,6,1,1,2,2,5,5,5,5,1,1,5,5,6,6,6,6,4,4,3,3,4,4,0,0,4,4,6,6,0,0,7,7,6,6,5,5,1,1,0,0,3,3,0,0,6,6,5,5,2,2,3,3,5,5,5,5,5,5,3,3,2,2,5,5,4,4,2,2,0,0,1,1,3,3,1,1,2,2,3,3,4,4,2,2,3,3,0,0,4,4,0,0,1,1,1,1,2,2,7,7,3,3,6,6,6,6,4,4,3,3,7,7,1,1,6,6,1,1,0,0,2,2,6,6,0,0,1,1,4,4,0,0,1,1,6,6,3,3,7,7,4,4,5,5,4,4,0,0,0,0,0,0,1,1,0,0,0,0,7,7,6,6,6,6,4,4,3,3,3,3,1,1,5,5,1,1,7,7,7,7,2,2,7,7,1,1,7,7,2,2,2,2,3,3,6,6,5,5,2,2,3,3,2,2,4,4,6,6,1,1,1,1,4,4,6,6,3,3,2,2,2,2,3,3,6,6,4,4,7,7,7,7,0,0,0,0,5,5,6,6,1,1,2,2,0,0,0,0,2,2,2,2,2,2,7,7,7,7,5,5,0,0,0,0,5,5,2,2,5,5,0,0,4,4,7,7,0,0,0,0,4,4,0,0,7,7,0,0,1,1,2,2,4,4,6,6,0,0,7,7,6,6,0,0,6,6,3,3,4,4,3,3,7,7,1,1,3,3,6,6,7,7,1,1,1,1,1,1,3,3,4,4,5,5,5,5,5,5,1,1,0,0,1,1,3,3,7,7,6,6,6,6,5,5,1,1,3,3,0,0,2,2,5,5,3,3,0,0,2,2,1,1,5,5,7,7,7,7,1,1,2,2,7,7,0,0,2,2,5,5,3,3,2,2,1,1,7,7,5,5,6,6,2,2,6,6,3,3,0,0,7,7,4,4,6,6,3,3,6,6,7,7,7,7,1,1,1,1,7,7,4,4,2,2,5,5,3,3,4,4,5,5,3,3,4,4,7,7,2,2,4,4,7,7,0,0,1,1,1,1,4,4,6,6,3,3,3,3,4,4,4,4,5,5,0,0,2,2,7,7,7,7,7,7,4,4,6,6,0,0,0,0,0,0,5,5,5,5,5,5,2,2,4,4,7,7,1,1,5,5,2,2,6,6,1,1,1,1,4,4,6,6,7,7,2,2,4,4,7,7,1,1,0,0,1,1,2,2,2,2,5,5,6,6,4,4,7,7,4,4,0,0,7,7,7,7,0,0,1,1,7,7,4,4,6,6,2,2,5,5,3,3,6,6,2,2,4,4,5,5,7,7,7,7,4,4,5,5,4,4,2,2,5,5,3,3,5,5,4,4,4,4,4,4,2,2,7,7,7,7,4,4,5,5,1,1,5,5,6,6,7,7,3,3,3,3,4,4,2,2,2,2,7,7,3,3,4,4,4,4,1,1,2,2,2,2,5,5,0,0,6,6,5,5,7,7,5,5,3,3,5,5,3,3,5,5,6,6,0,0,1,1,0,0,0,0,3,3,4,4,5,5,7,7,6,6,0,0,3,3,3,3,3,3,3,3,0,0,1,1,7,7,2,2,1,1,6,6,2,2,1,1,3,3,7,7,3,3,2,2,2,2,5,5,0,0,6,6,2,2,4,4,6,6,4,4,4,4,5,5,6,6,4,4,2,2,1,1,2,2,6,6,1,1,2,2,7,7,4,4,1,1,0,0,1,1,7,7,6,6,0,0,4,4,5,5,2,2,1,1,0,0,4,4,3,3,0,0,5,5,1,1,5,5,3,3,2,2,0,0,4,4,7,7,5,5,3,3,2,2,4,4,0,0,1,1,4,4,1,1,7,7,5,5,1,1,0,0,1,1,0,0,4,4,2,2,7,7,3,3,5,5,0,0,5,5,5,5,7,7,6,6,4,4,0,0,0,0,6,6,1,1,5,5,1,1,1,1,3,3,3,3,3,3,3,3,0,0,2,2,5,5,0,0,2,2,6,6,4,4,0,0,2,2,0,0,6,6,4,4,3,3,0,0,4,4,6,6,4,4,0,0,3,3,5,5,7,7,2,2,3,3,4,4,4,4,1,1,1,1,0,0,2,2,7,7,6,6,5,5,0,0,7,7,3,3,4,4,1,1,2,2,1,1,0,0,5,5,0,0,1,1,2,2,0,0,4,4,0,0,4,4,6,6,4,4,6,6,3,3,6,6,3,3,3,3,6,6,3,3,6,6,7,7,0,0,5,5,1,1,0,0,6,6,1,1,0,0,7,7,2,2,1,1,1,1,0,0,0,0,1,1,7,7,2,2,2,2,5,5,5,5,1,1,0,0,2,2,5,5,0,0,1,1,4,4,3,3,1,1,4,4,2,2,4,4,7,7,4,4,0,0,4,4,2,2,2,2,4,4,3,3,7,7,4,4,5,5,1,1,5,5,1,1,1,1,5,5,6,6,6,6,2,2,5,5,0,0,2,2,1,1,2,2,5,5,0,0,2,2,1,1,4,4,1,1,2,2,6,6,4,4,5,5,0,0,0,0,0,0,3,3,1,1,4,4,6,6,4,4,3,3,4,4,1,1,2,2,5,5,3,3,0,0,3,3,4,4,7,7,7,7,3,3,0,0,5,5,1,1,6,6,4,4,3,3,2,2,2,2,2,2,0,0,1,1,5,5,2,2,4,4,6,6,2,2,0,0,3,3,0,0,3,3,1,1,1,1,3,3,0,0,2,2,6,6,3,3,3,3,2,2,3,3,0,0,4,4,6,6,2,2,3,3,4,4,7,7,6,6,7,7,7,7,4,4,0,0,0,0,6,6,5,5,0,0,1,1,5,5,2,2,0,0,3,3,7,7,6,6,1,1,1,1,6,6,7,7,4,4,6,6,0,0,3,3,7,7,7,7,5,5,0,0,0,0,2,2,3,3,4,4,0,0,2,2,2,2,3,3,0,0,6,6,1,1,6,6,4,4,0,0,3,3,6,6,4,4,7,7,5,5,4,4,7,7,4,4,3,3,7,7,2,2,1,1,7,7,7,7,6,6,1,1,0,0,4,4,3,3,7,7,6,6,1,1,7,7,1,1,7,7,5,5,4,4,0,0,4,4,4,4,6,6,2,2,4,4,4,4,3,3,4,4,1,1,2,2,0,0,6,6,3,3,4,4,4,4,6,6,4,4,7,7,5,5,1,1,0,0,3,3,3,3,7,7,3,3,5,5,4,4,5,5,7,7,3,3,5,5,1,1,1,1,4,4,3,3,5,5,1,1,3,3,4,4,6,6,0,0,5,5,4,4,2,2,1,1,0,0,5,5,1,1,1,1,5,5,4,4,1,1,1,1,0,0,0,0,6,6,5,5,4,4,3,3,6,6,7,7,2,2,3,3,4,4,2,2,4,4,7,7,7,7,1,1,0,0,5,5,7,7,5,5,6,6,3,3,7,7,7,7,2,2,1,1,0,0,7,7,5,5,7,7,4,4,0,0,6,6,7,7,6,6,0,0,1,1,0,0,1,1,4,4,7,7,1,1,7,7,0,0,7,7,6,6,5,5,3,3,0,0,3,3,6,6,7,7,3,3,0,0,4,4,2,2,4,4,7,7,4,4,2,2,0,0,2,2,4,4,0,0,7,7,5,5,1,1,0,0,6,6,4,4,0,0,2,2,1,1,6,6,0,0,7,7,3,3,6,6,6,6,6,6,2,2,0,0,2,2,6,6,2,2,4,4,4,4,4,4,4,4,4,4,7,7,2,2,7,7,3,3,3,3,5,5,1,1,0,0,6,6,3,3,2,2,2,2,2,2,4,4,5,5,3,3,6,6,3,3,0,0,1,1,2,2,2,2,0,0,0,0,3,3,1,1,5,5,6,6,4,4,4,4,3,3,1,1,0,0,0,0,3,3,0,0,2,2,3,3,2,2,7,7,4,4,6,6,6,6,1,1,0,0,7,7,2,2,4,4,5,5,0,0,0,0,7,7,3,3,4,4,1,1,6,6,5,5,2,2,4,4,3,3,5,5,2,2,5,5,1,1,1,1,7,7,0,0,6,6,0,0,6,6,6,6,3,3,5,5,5,5,3,3,7,7,7,7,3,3,3,3,2,2,2,2,1,1,1,1,3,3,6,6,6,6,4,4,1,1,6,6,4,4,4,4,1,1,0,0,1,1,6,6,0,0,3,3,7,7,6,6,0,0,0,0,7,7,3,3,2,2,1,1,6,6,2,2,3,3,0,0,4,4,1,1,4,4,5,5,6,6,4,4,1,1,4,4,1,1,3,3,0,0,2,2,2,2,4,4,5,5,1,1,1,1,7,7,4,4,6,6,1,1,3,3,6,6,6,6,5,5,1,1,7,7,3,3,6,6,6,6,6,6,4,4,3,3,3,3,7,7,3,3,3,3,2,2,0,0,3,3,1,1,4,4,5,5,7,7,2,2,2,2,5,5,0,0,6,6,7,7,1,1,6,6,4,4,4,4,6,6,3,3,0,0,5,5,0,0,4,4,4,4,5,5,2,2,2,2,4,4,5,5,2,2,3,3,5,5,3,3,5,5,0,0,1,1,4,4,6,6,4,4,0,0,4,4,3,3,5,5,7,7,5,5,2,2,2,2,2,2,1,1,0,0,2,2,2,2,1,1,4,4,6,6,3,3,1,1,1,1,3,3,3,3,7,7,0,0,2,2,7,7,2,2,3,3,4,4,3,3,1,1,7,7,2,2,1,1,5,5,0,0,1,1,0,0,2,2,1,1,0,0,6,6,7,7,3,3,6,6,2,2,7,7,7,7,2,2,5,5,2,2,1,1,2,2,2,2,1,1,4,4,0,0,3,3,7,7,3,3,1,1,7,7,4,4,0,0,2,2,2,2,3,3,1,1,6,6,5,5,5,5,6,6,4,4,0,0,0,0,1,1,3,3,5,5,5,5,4,4,0,0,3,3,0,0,6,6,6,6,4,4,3,3,2,2,4,4,6,6,1,1,6,6,5,5,5,5,6,6,2,2,5,5,7,7,6,6,1,1,0,0,6,6,0,0,2,2,1,1,3,3,3,3,1,1,4,4,5,5,0,0,7,7,0,0,4,4,7,7,6,6,6,6,1,1,0,0,1,1,1,1,2,2,1,1,0,0,1,1,5,5,7,7,0,0,3,3,7,7,3,3,0,0,3,3,6,6,7,7,1,1,6,6,3,3,1,1,5,5,5,5,7,7,4,4,5,5,0,0,6,6,3,3,0,0,0,0,3,3,5,5,0,0,1,1,1,1,2,2,4,4,7,7,2,2,1,1,2,2,1,1,6,6,4,4,1,1,2,2,4,4,2,2,0,0,2,2,5,5,2,2,4,4,1,1,2,2,2,2,6,6,1,1,7,7,7,7,1,1,5,5,4,4,6,6,2,2,3,3,4,4,2,2,0,0,0,0,3,3,2,2,4,4,5,5,0,0,2,2,4,4,3,3,4,4,5,5,1,1,6,6,0,0,4,4,6,6,5,5,4,4,6,6,7,7,5,5,2,2,1,1,2,2,1,1,5,5,4,4,7,7,0,0,4,4,2,2,2,2,0,0,3,3,7,7,7,7,7,7,4,4,0,0,2,2,0,0,7,7,7,7,3,3,3,3,5,5,6,6,1,1,2,2,2,2,6,6,4,4,7,7,2,2,0,0,4,4,1,1,3,3,7,7,6,6,5,5,4,4,0,0,2,2,4,4,6,6,0,0,5,5,0,0,4,4,0,0,0,0,7,7,6,6,1,1,1,1,0,0,6,6,0,0,3,3,4,4,0,0,3,3,4,4,6,6,5,5,4,4,2,2,6,6,4,4,5,5,6,6,6,6,0,0,0,0,4,4,2,2,6,6,3,3,2,2,3,3,4,4,5,5,0,0,2,2,0,0,0,0,5,5,2,2,2,2,5,5,0,0,1,1,0,0,2,2,0,0,5,5,5,5,7,7,2,2,0,0,4,4,7,7,0,0,3,3,5,5,3,3,6,6,0,0,4,4,7,7,6,6,3,3,2,2,4,4,4,4,2,2,2,2,5,5,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,0,3,3,4,4,7,7,0,0,0,0,0,0,4,4,7,7,7,7,6,6,1,1,1,1,7,7,0,0,4,4,2,2,4,4,1,1,3,3,6,6,7,7,3,3,7,7,0,0,3,3,0,0,6,6,2,2,1,1,5,5,6,6,4,4,2,2,5,5,1,1,0,0,3,3,2,2,5,5,6,6,4,4,3,3,3,3,3,3,1,1,0,0,5,5,6,6,2,2,4,4,6,6,4,4,4,4,1,1,2,2,0,0,2,2,0,0,5,5,0,0,7,7,6,6,0,0,1,1,4,4,7,7,6,6,5,5,4,4,0,0,5,5,6,6,2,2,1,1,1,1,2,2,0,0,0,0,5,5,0,0,3,3,5,5,6,6,6,6,6,6,4,4,6,6,7,7,3,3,5,5,3,3,7,7,6,6,1,1,1,1,7,7,5,5,7,7,6,6,0,0,2,2,1,1,0,0,5,5,5,5,6,6,6,6,1,1,1,1,7,7,4,4,3,3,3,3,6,6,2,2,5,5,7,7,3,3,3,3,5,5,0,0,7,7,3,3,3,3,0,0,3,3,3,3,4,4,0,0,6,6,4,4,7,7,5,5,5,5,6,6,5,5,5,5,2,2,2,2,5,5,1,1,6,6,4,4,7,7,4,4,7,7,3,3,6,6,0,0,2,2,3,3,3,3,6,6,1,1,0,0,3,3,6,6,3,3,3,3,2,2,0,0,7,7,1,1,6,6,5,5,3,3,3,3,3,3,4,4,6,6,3,3,2,2,3,3,2,2,7,7,3,3,5,5,4,4,1,1,5,5,5,5,1,1,6,6,3,3,7,7,5,5,1,1,6,6,7,7,2,2,0,0,0,0,0,0,4,4,1,1,5,5,2,2,7,7,3,3,7,7,5,5,0,0,2,2,0,0,2,2,0,0,5,5,4,4,0,0,6,6,7,7,3,3,5,5,3,3,1,1,4,4,5,5,7,7,3,3,0,0,7,7,5,5,7,7,1,1,0,0,4,4,3,3,1,1,4,4,2,2,0,0,7,7,4,4,2,2,7,7,5,5,2,2,0,0,1,1,0,0,1,1,4,4,7,7,3,3,4,4,2,2,5,5,6,6,2,2,6,6,2,2,0,0,2,2,2,2,4,4,6,6,2,2,4,4,3,3,1,1,1,1,1,1,4,4,2,2,5,5,5,5,4,4,1,1,5,5,5,5,2,2,5,5,2,2,3,3,0,0,0,0,5,5,5,5,2,2,5,5,6,6,4,4,1,1,4,4,6,6,1,1,0,0,0,0,6,6,4,4,6,6,2,2,7,7,0,0,2,2,1,1,0,0,0,0,5,5,3,3,6,6,0,0,3,3,2,2,2,2,3,3,5,5,4,4,7,7,0,0,1,1,6,6,1,1,4,4,3,3,1,1,0,0,1,1,4,4,0,0,2,2,5,5,6,6,7,7,0,0,4,4,3,3,4,4,0,0,0,0,3,3,4,4,3,3,3,3,2,2,4,4,7,7,0,0,4,4,1,1,7,7,3,3,5,5,6,6,1,1,1,1,0,0,7,7,3,3,0,0,2,2,2,2,6,6,1,1,5,5,4,4,0,0,6,6,5,5,2,2,4,4,4,4,4,4,0,0,6,6,7,7,4,4,5,5,6,6,1,1,2,2,2,2,4,4,4,4,2,2,2,2,7,7,2,2,1,1,6,6,6,6,5,5,4,4,5,5,3,3,3,3,1,1,2,2,0,0,2,2,2,2,2,2,1,1,1,1,5,5,4,4,6,6,4,4,1,1,5,5,4,4,7,7,1,1,6,6,5,5,6,6,2,2,1,1,1,1,0,0,5,5,1,1,6,6,5,5,3,3,3,3,5,5,5,5,7,7,1,1,6,6,6,6,5,5,4,4,5,5,0,0,5,5,3,3,7,7,4,4,6,6,6,6,4,4,0,0,2,2,6,6,4,4,4,4,2,2,7,7,3,3,5,5,3,3,6,6,0,0,0,0,3,3,0,0,0,0,0,0,3,3,3,3,1,1,4,4,4,4,3,3,1,1,6,6,5,5,2,2,1,1,3,3,7,7,7,7,6,6,6,6,3,3,2,2,6,6,4,4,1,1,3,3,5,5,4,4,7,7,5,5,3,3,2,2,6,6,1,1,5,5,6,6,1,1,5,5,2,2,0,0,7,7,5,5,6,6,4,4,0,0,6,6,6,6,2,2,5,5,6,6,0,0,2,2,3,3,0,0,7,7,3,3,3,3,1,1,6,6,0,0,7,7,4,4,5,5,3,3,0,0,0,0,1,1,2,2,2,2,6,6,2,2,1,1,2,2,7,7,3,3,2,2,5,5,0,0,4,4,1,1,4,4,4,4,2,2,7,7,1,1,0,0,0,0,4,4,6,6,3,3,3,3,5,5,7,7,0,0,1,1,6,6,0,0,2,2,0,0,1,1,1,1,4,4,0,0,0,0,5,5,6,6,5,5,5,5,4,4,4,4,5,5,1,1,0,0,5,5,3,3,6,6,3,3,0,0,6,6,1,1,7,7,6,6,3,3,5,5,3,3,0,0,2,2,7,7,2,2,7,7,1,1,2,2,3,3,7,7,2,2,5,5,1,1,7,7,0,0,5,5,1,1,1,1,7,7,1,1,4,4,5,5,1,1,4,4,2,2,0,0,2,2,5,5,7,7,6,6,7,7,0,0,5,5,2,2,0,0,7,7,1,1,6,6,6,6,4,4,1,1,1,1,2,2,5,5,0,0,2,2,0,0,5,5,0,0,7,7,0,0,2,2,3,3,2,2,3,3,0,0,4,4,6,6,3,3,5,5,2,2,2,2,3,3,3,3,4,4,0,0,1,1,7,7,4,4,6,6,7,7,3,3,7,7,3,3,3,3,4,4,5,5,6,6,5,5,4,4,3,3,6,6,6,6,5,5,4,4,4,4,4,4,3,3,3,3,0,0,3,3,6,6,1,1,2,2,7,7,7,7,6,6,4,4,6,6,3,3,0,0,1,1,4,4,1,1,3,3,2,2,2,2,5,5,1,1,1,1,7,7,5,5,1,1,0,0,4,4,2,2,7,7,1,1,3,3,0,0,6,6,7,7,7,7,5,5,7,7,4,4,2,2,7,7,7,7,6,6,1,1,5,5,3,3,6,6,1,1,7,7,3,3,7,7,3,3,1,1,0,0,5,5,0,0,5,5,6,6,3,3,2,2,6,6,5,5,4,4,4,4,3,3,6,6,0,0,7,7,6,6,2,2,2,2,0,0,5,5,4,4,3,3,4,4,3,3,2,2,6,6,4,4,7,7,1,1,2,2,3,3,6,6,6,6,5,5,2,2,1,1,3,3,5,5,2,2,7,7,7,7,0,0,1,1,2,2,6,6,3,3,3,3,1,1,0,0,1,1,3,3,4,4,1,1,6,6,7,7,1,1,3,3,7,7,0,0,4,4,4,4,6,6,4,4,4,4,6,6,2,2,1,1,7,7,6,6,0,0,4,4,5,5,1,1,2,2,7,7,7,7,6,6,3,3,6,6,7,7,3,3,1,1,2,2,1,1,5,5,4,4,0,0,1,1,1,1,1,1,3,3,4,4,1,1,0,0,2,2,5,5,1,1,5,5,3,3,1,1,7,7,1,1,1,1,7,7,4,4,6,6,2,2,5,5,0,0,4,4,7,7,0,0,1,1,6,6,1,1,5,5,2,2,2,2,7,7,1,1,2,2,0,0,3,3,4,4,2,2,6,6,7,7,3,3,5,5,3,3,0,0,6,6,5,5,3,3,0,0,2,2,5,5,1,1,6,6,5,5,6,6,4,4,2,2,1,1,7,7,0,0,5,5,0,0,1,1,2,2,1,1,0,0,7,7,7,7,4,4,0,0,1,1,4,4,2,2,0,0,2,2,4,4,5,5,6,6,6,6,7,7,7,7,4,4,7,7,3,3,0,0,0,0,5,5,3,3,2,2,0,0,6,6,2,2,6,6,7,7,7,7,7,7,4,4,3,3,0,0,2,2,0,0,0,0,5,5,6,6,4,4,0,0,4,4,1,1,0,0,4,4,5,5,4,4,3,3,3,3,4,4,0,0,5,5,6,6,0,0,3,3,0,0,6,6,6,6,6,6,2,2,0,0,0,0,3,3,5,5,7,7,4,4,5,5,1,1,3,3,5,5,6,6,6,6,6,6,7,7,3,3,0,0,0,0,2,2,7,7,0,0,0,0,0,0,0,0,4,4,7,7,5,5,1,1,2,2,5,5,4,4,2,2,0,0,7,7,4,4,4,4,3,3,2,2,7,7,0,0,3,3,1,1,4,4,3,3,6,6,1,1,5,5,0,0,3,3,1,1,1,1,7,7,3,3,1,1,4,4,4,4,4,4,2,2,5,5,6,6,6,6,7,7,0,0,2,2,3,3,2,2,5,5,0,0,2,2,1,1,7,7,0,0,6,6,2,2,7,7,5,5,0,0,4,4,5,5,7,7,5,5,1,1,0,0,4,4,0,0,5,5,6,6,4,4,2,2,0,0,4,4,3,3,6,6,6,6,7,7,7,7,5,5,4,4,3,3,4,4,7,7,1,1,4,4,1,1,3,3,0,0,1,1,5,5,3,3,2,2,0,0,6,6,1,1,2,2,1,1,6,6,7,7,6,6,1,1,7,7,0,0,3,3,6,6,5,5,2,2,6,6,3,3,0,0,4,4,1,1,3,3,3,3,6,6,2,2,3,3,0,0,3,3,5,5,1,1,5,5,0,0,0,0,7,7,1,1,3,3,1,1,1,1,0,0,2,2,1,1,7,7,0,0,3,3,4,4,7,7,1,1,4,4,1,1,5,5,3,3,5,5,1,1,0,0,7,7,6,6,7,7,3,3,1,1,3,3,1,1,5,5,6,6,7,7,1,1,6,6,5,5,0,0,3,3,0,0,2,2,5,5,3,3,2,2,6,6,4,4,6,6,6,6,5,5,4,4,6,6,2,2,3,3,5,5,4,4,2,2,1,1,6,6,2,2,4,4,2,2,6,6,2,2,7,7,6,6,7,7,1,1,5,5,0,0,0,0,6,6,5,5,6,6,5,5,6,6,5,5,4,4,2,2,2,2,6,6,6,6,0,0,5,5,7,7,1,1,0,0,7,7,6,6,2,2,1,1,7,7,3,3,6,6,6,6,2,2,5,5,4,4,6,6,2,2,2,2,0,0,6,6,2,2,6,6,7,7,7,7,5,5,5,5,5,5,6,6,6,6,4,4,7,7,2,2,5,5,3,3,0,0,0,0,0,0,2,2,2,2,1,1,4,4,3,3,4,4,6,6,3,3,6,6,3,3,5,5,5,5,5,5,5,5,1,1,3,3,1,1,7,7,4,4,3,3,3,3,5,5,3,3,7,7,4,4,1,1,7,7,6,6,4,4,4,4,7,7,7,7,4,4,4,4,6,6,4,4,3,3,6,6,6,6,0,0,2,2,0,0,0,0,1,1,1,1,5,5,6,6,0,0,7,7,7,7,4,4,3,3,1,1,1,1,7,7,1,1,7,7,7,7,6,6,4,4,1,1,1,1,3,3,4,4,0,0,1,1,5,5,4,4,2,2,6,6,1,1,6,6,0,0,4,4,1,1,4,4,5,5,0,0,3,3,2,2,7,7,6,6,5,5,6,6,4,4,4,4,3,3,5,5,1,1,2,2,1,1,0,0,3,3,7,7,0,0,1,1,6,6,6,6,3,3,5,5,3,3,0,0,1,1,0,0,1,1,0,0,6,6,5,5,0,0,6,6,2,2,6,6,1,1,7,7,2,2,4,4,0,0,7,7,1,1,6,6,6,6,4,4,3,3,7,7,0,0,5,5,3,3,1,1,3,3,2,2,7,7,0,0,2,2,4,4,6,6,3,3,4,4,1,1,1,1,1,1,3,3,2,2,0,0,3,3,5,5,5,5,2,2,6,6,1,1,4,4,7,7,6,6,1,1,5,5,5,5,6,6,4,4,3,3,0,0,4,4,5,5,7,7,0,0,7,7,7,7,0,0,0,0,1,1,6,6,3,3,4,4,6,6,7,7,6,6,4,4,6,6,4,4,4,4,3,3,1,1,0,0,5,5,5,5,2,2,0,0,0,0,1,1,4,4,3,3,7,7,7,7,5,5,1,1,2,2,7,7,5,5,1,1,4,4,5,5,0,0,1,1,0,0,6,6,7,7,1,1,1,1,1,1,0,0,7,7,7,7,6,6,1,1,2,2,0,0,5,5,4,4,6,6,5,5,0,0,5,5,7,7,0,0,6,6,4,4,7,7,4,4,2,2,5,5,4,4,0,0,0,0,4,4,6,6,2,2,2,2,7,7,6,6,5,5,3,3,7,7,6,6,7,7,7,7,4,4,1,1,7,7,5,5,0,0,5,5,7,7,6,6,5,5,4,4,6,6,6,6,7,7,6,6,6,6,0,0,4,4,2,2,7,7,2,2,6,6,2,2,6,6,6,6,3,3,2,2,3,3,2,2,3,3,7,7,4,4,0,0,3,3,3,3,1,1,0,0,1,1,3,3,4,4,2,2,0,0,1,1,3,3,6,6,7,7,3,3,4,4,4,4,1,1,0,0,0,0,7,7,5,5,1,1,0,0,2,2,3,3,6,6,6,6,1,1,2,2,2,2,2,2,1,1,4,4,4,4,0,0,2,2,1,1,0,0,1,1,0,0,7,7,6,6,5,5,2,2,2,2,7,7,6,6,3,3,7,7,4,4,4,4,4,4,6,6,6,6,3,3,4,4,4,4,4,4,1,1,2,2,5,5,1,1,1,1,3,3,3,3,2,2,1,1,1,1,1,1,5,5,5,5,3,3,0,0,4,4,0,0,0,0,0,0,0,0,5,5,3,3,5,5,4,4,7,7,6,6,3,3,4,4,7,7,0,0,5,5,0,0,4,4,5,5,5,5,4,4,4,4,5,5,4,4,6,6,5,5,0,0,7,7,2,2,1,1,0,0,3,3,2,2,4,4,1,1,1,1,6,6,7,7,0,0,7,7,6,6,7,7,5,5,2,2,5,5,0,0,4,4,7,7,4,4,4,4,2,2,0,0,2,2,6,6,5,5,2,2,0,0,2,2,4,4,7,7,1,1,7,7,7,7,7,7,1,1,0,0,6,6,5,5,7,7,2,2,7,7,0,0,4,4,1,1,1,1,2,2,6,6,7,7,0,0,5,5,6,6,6,6,1,1,6,6,6,6,1,1,6,6,7,7,4,4,6,6,4,4,3,3,6,6,6,6,5,5,5,5,1,1,4,4,6,6,0,0,3,3,2,2,0,0,1,1,0,0,5,5,1,1,1,1,6,6,2,2,1,1,4,4,5,5,2,2,6,6,7,7,1,1,4,4,6,6,2,2,7,7,2,2,6,6,6,6,2,2,5,5,2,2,0,0,3,3,2,2,0,0,1,1,2,2,3,3,5,5,5,5,1,1,1,1,0,0,5,5,5,5,1,1,2,2,0,0,5,5,4,4,5,5,3,3,5,5,0,0,6,6,0,0,3,3,2,2,0,0,6,6,0,0,6,6,5,5,2,2,7,7,4,4,6,6,3,3,4,4,2,2,1,1,7,7,5,5,5,5,5,5,7,7,7,7,5,5,5,5,0,0,4,4,7,7,7,7,0,0,0,0,7,7,6,6,7,7,4,4,0,0,6,6,7,7,0,0,1,1,5,5,4,4,0,0,6,6,0,0,1,1,1,1,6,6,2,2,0,0,6,6,0,0,3,3,6,6,1,1,6,6,2,2,0,0,1,1,4,4,6,6,3,3,2,2,0,0,1,1,6,6,5,5,3,3,5,5,1,1,2,2,5,5,1,1,4,4,5,5,2,2,1,1,0,0,0,0,7,7,6,6,0,0,0,0,0,0,4,4,3,3,7,7,1,1,3,3,4,4,5,5,0,0,4,4,6,6,3,3,7,7,7,7,2,2,4,4,6,6,2,2,5,5,2,2,0,0,5,5,2,2,5,5,0,0,6,6,4,4,2,2,4,4,4,4,4,4,7,7,0,0,1,1,4,4,2,2,6,6,4,4,2,2,5,5,1,1,4,4,6,6,2,2,2,2,0,0,2,2,5,5,5,5,2,2,6,6,0,0,2,2,6,6,0,0,1,1,3,3,6,6,0,0,1,1,0,0,0,0,0,0,3,3,5,5,7,7,7,7,2,2,7,7,3,3,5,5,3,3,3,3,7,7,0,0,4,4,0,0,4,4,6,6,4,4,2,2,0,0,4,4,3,3,4,4,3,3,0,0,1,1,4,4,6,6,6,6,7,7,2,2,3,3,3,3,5,5,2,2,5,5,7,7,0,0,0,0,1,1,6,6,6,6,0,0,2,2,6,6,2,2,4,4,0,0,6,6,0,0,6,6,6,6,6,6,3,3,5,5,0,0,6,6,6,6,7,7,4,4,7,7,0,0,1,1,6,6,5,5,2,2,6,6,2,2,5,5,7,7,3,3,4,4,7,7,1,1,7,7,3,3,1,1,7,7,4,4,5,5,1,1,1,1,3,3,0,0,1,1,6,6,4,4,7,7,1,1,1,1,3,3,4,4,0,0,0,0,7,7,2,2,3,3,5,5,5,5,7,7,1,1,4,4,1,1,7,7,2,2,4,4,3,3,5,5,2,2,7,7,1,1,6,6,6,6,1,1,5,5,4,4,2,2,7,7,2,2,6,6,2,2,3,3,1,1,0,0,6,6,0,0,6,6,3,3,1,1,5,5,4,4,3,3,6,6,4,4,5,5,3,3,0,0,5,5,0,0,0,0,7,7,6,6,0,0,1,1,2,2,2,2,3,3,0,0,2,2,1,1,1,1,1,1,6,6,1,1,4,4,4,4,6,6,6,6,1,1,2,2,6,6,6,6,2,2,0,0,6,6,5,5,4,4,4,4,1,1,7,7,6,6,7,7,7,7,3,3,5,5,5,5,1,1,4,4,3,3,0,0,5,5,5,5,6,6,1,1,6,6,4,4,0,0,5,5,4,4,3,3,5,5,1,1,1,1,2,2,1,1,5,5,1,1,2,2,7,7,6,6,0,0,1,1,7,7,6,6,5,5,2,2,2,2,1,1,4,4,5,5,0,0,6,6,0,0,1,1,6,6,5,5,3,3,3,3,4,4,7,7,1,1,0,0,5,5,2,2,0,0,6,6,5,5,3,3,3,3,0,0,1,1,3,3,5,5,4,4,1,1,5,5,3,3,6,6,6,6,3,3,3,3,1,1,5,5,6,6,2,2,6,6,1,1,2,2,5,5,0,0,0,0,0,0,2,2,2,2,5,5,7,7,4,4,4,4,1,1,3,3,0,0,2,2,5,5,0,0,2,2,6,6,2,2,7,7,6,6,7,7,5,5,1,1,3,3,5,5,3,3,1,1,0,0,0,0,3,3,4,4,7,7,5,5,1,1,2,2,7,7,4,4,4,4,3,3,7,7,6,6,1,1,6,6,1,1,4,4,2,2,6,6,7,7,4,4,2,2,3,3,3,3,4,4,0,0,0,0,0,0,7,7,7,7,5,5,3,3,0,0,1,1,1,1,5,5,4,4,3,3,3,3,1,1,7,7,2,2,2,2,0,0,3,3,4,4,0,0,1,1,2,2,2,2,4,4,1,1,0,0,0,0,5,5,4,4,4,4,4,4,2,2,0,0,0,0,6,6,5,5,1,1,3,3,5,5,2,2,4,4,6,6,3,3,7,7,4,4,2,2,4,4,7,7,0,0,0,0,6,6,6,6,7,7,3,3,2,2,4,4,3,3,2,2,1,1,1,1,5,5,2,2,6,6,2,2,7,7,4,4,2,2,7,7,6,6,2,2,0,0,7,7,6,6,0,0,4,4,7,7,1,1,7,7,7,7,1,1,4,4,7,7,3,3,3,3,2,2,6,6,4,4,4,4,4,4,5,5,1,1,4,4,7,7,2,2,2,2,0,0,2,2,6,6,7,7,0,0,1,1,3,3,3,3,0,0,2,2,2,2,3,3,6,6,7,7,3,3,4,4,3,3,2,2,2,2,7,7,3,3,5,5,5,5,3,3,5,5,0,0,7,7,6,6,6,6,7,7,2,2,1,1,1,1,3,3,6,6,2,2,3,3,5,5,6,6,5,5,3,3,7,7,6,6,1,1,5,5,2,2,5,5,6,6,0,0,3,3,1,1,1,1,0,0,5,5,3,3,4,4,7,7,0,0,4,4,4,4,6,6,2,2,2,2,5,5,7,7,1,1,1,1,0,0,4,4,1,1,6,6,1,1,5,5,1,1,2,2,7,7,1,1,5,5,1,1,7,7,6,6,7,7,1,1,5,5,2,2,2,2,7,7,2,2,0,0,5,5,2,2,0,0,2,2,3,3,4,4,5,5,3,3,5,5,6,6,7,7,7,7,0,0,2,2,4,4,4,4,1,1,0,0,3,3,6,6,5,5,7,7,3,3,0,0,2,2,4,4,0,0,2,2,2,2,6,6,7,7,5,5,5,5,7,7,7,7,4,4,4,4,6,6,2,2,7,7,7,7,1,1,1,1,0,0,4,4,5,5,1,1,1,1,7,7,1,1,0,0,3,3,5,5,5,5,7,7,2,2,2,2,6,6,4,4,7,7,7,7,2,2,2,2,5,5,2,2,1,1,6,6,2,2,5,5,6,6,6,6,0,0,6,6,5,5,2,2,3,3,7,7,5,5,5,5,4,4,2,2,7,7,5,5,1,1,1,1,6,6,5,5,3,3,7,7,6,6,1,1,3,3,1,1,0,0,4,4,2,2,1,1,6,6,5,5,4,4,7,7,3,3,0,0,2,2,4,4,3,3,0,0,3,3,4,4,2,2,7,7,6,6,3,3,2,2,6,6,3,3,7,7,2,2,0,0,2,2,7,7,7,7,5,5,7,7,3,3,5,5,2,2,3,3,7,7,6,6,2,2,5,5,3,3,7,7,0,0,7,7,6,6,5,5,6,6,5,5,0,0,6,6,3,3,5,5,6,6,0,0,4,4,4,4,0,0,5,5,2,2,7,7,3,3,1,1,7,7,0,0,4,4,2,2,0,0,2,2,2,2,6,6,5,5,5,5,6,6,3,3,4,4,1,1,4,4,0,0,0,0,5,5,6,6,3,3,3,3,1,1,4,4,2,2,7,7,7,7,5,5,6,6,6,6,5,5,0,0,4,4,7,7,2,2,0,0,7,7,6,6,5,5,1,1,2,2,4,4,6,6,1,1,1,1,1,1,3,3,3,3,1,1,7,7,0,0,4,4,6,6,3,3,0,0,1,1,2,2,4,4,4,4,5,5,1,1,1,1,4,4,6,6,6,6,0,0,7,7,2,2,7,7,6,6,3,3,7,7,5,5,7,7,4,4,1,1,3,3,3,3,3,3,4,4,0,0,5,5,3,3,5,5,0,0,1,1,1,1,0,0,3,3,7,7,2,2,4,4,3,3,0,0,3,3,3,3,5,5,0,0,4,4,3,3,5,5,7,7,7,7,6,6,7,7,2,2,5,5,3,3,6,6,6,6,3,3,4,4,4,4,6,6,2,2,2,2,7,7,4,4,6,6,3,3,5,5,3,3,5,5,4,4,7,7,1,1,6,6,5,5,7,7,0,0,1,1,6,6,1,1,7,7,0,0,2,2,7,7,2,2,0,0,1,1,0,0,2,2,5,5,4,4,6,6,4,4,4,4,2,2,5,5,1,1,5,5,7,7,6,6,4,4,6,6,0,0,7,7,2,2,5,5,5,5,3,3,5,5,1,1,5,5,7,7,4,4,3,3,1,1,2,2,5,5,4,4,3,3,3,3,7,7,3,3,7,7,4,4,7,7,0,0,4,4,6,6,0,0,0,0,1,1,0,0,7,7,0,0,0,0,5,5,1,1,3,3,0,0,7,7,6,6,0,0,5,5,0,0,7,7,5,5,0,0,3,3,1,1,7,7,1,1,6,6,4,4,6,6,6,6,1,1,6,6,4,4,2,2,0,0,5,5,2,2,7,7,3,3,4,4,5,5,1,1,7,7,1,1,6,6,5,5,5,5,3,3,1,1,0,0,6,6,6,6,3,3,6,6,1,1,1,1,6,6,6,6,2,2,7,7,1,1,4,4,5,5,3,3,4,4,2,2,3,3,7,7,4,4,5,5,5,5,2,2,0,0,1,1,7,7,4,4,2,2,2,2,5,5,2,2,3,3,1,1,4,4,2,2,3,3,2,2,5,5,1,1,5,5,3,3,3,3,3,3,2,2,3,3,7,7,3,3,0,0,7,7,4,4,1,1,4,4,1,1,0,0,4,4,2,2,5,5,1,1,4,4,5,5,1,1,3,3,5,5,4,4,6,6,2,2,7,7,5,5,1,1,7,7,5,5,4,4,7,7,6,6,7,7,6,6,7,7,5,5,6,6,7,7,0,0,0,0,5,5,2,2,6,6,7,7,4,4,1,1,7,7,3,3,6,6,1,1,6,6,4,4,4,4,4,4,6,6,2,2,4,4,4,4,0,0,4,4,0,0,4,4,0,0,0,0,3,3,1,1,2,2,3,3,4,4,4,4,2,2,5,5,7,7,3,3,3,3,0,0,4,4,2,2,0,0,6,6,2,2,4,4,6,6,1,1,7,7,4,4,1,1,0,0,0,0,1,1,5,5,0,0,2,2,1,1,6,6,5,5,6,6,6,6,4,4,1,1,7,7,3,3,1,1,3,3,4,4,5,5,7,7,1,1,7,7,5,5,3,3,2,2,4,4,1,1,3,3,5,5,5,5,0,0,1,1,1,1,0,0,4,4,0,0,2,2,4,4,7,7,4,4,4,4,0,0,3,3,0,0,1,1,7,7,2,2,6,6,7,7,5,5,6,6,1,1,6,6,4,4,3,3,5,5,3,3,0,0,0,0,4,4,1,1,1,1,1,1,6,6,0,0,3,3,0,0,0,0,4,4,1,1,6,6,1,1,7,7,0,0,0,0,3,3,1,1,5,5,1,1,4,4,4,4,7,7,5,5,4,4,6,6,3,3,7,7,4,4,7,7,6,6,2,2,6,6,0,0,3,3,4,4,6,6,2,2,4,4,0,0,5,5,1,1,0,0,7,7,6,6,4,4,5,5,6,6,6,6,2,2,2,2,2,2,7,7,1,1,2,2,0,0,2,2,5,5,1,1,0,0,7,7,6,6,4,4,6,6,3,3,1,1,6,6,0,0,1,1,7,7,1,1,2,2,0,0,5,5,6,6,5,5,3,3,7,7,3,3,2,2,4,4,7,7,0,0,0,0,0,0,7,7,6,6,2,2,3,3,2,2,4,4,2,2,3,3,1,1,3,3,0,0,7,7,4,4,5,5,0,0,2,2,1,1,4,4,0,0,2,2,3,3,2,2,1,1,5,5,1,1,6,6,6,6,7,7,1,1,0,0,5,5,3,3,4,4,2,2,0,0,0,0,2,2,3,3,4,4,6,6,4,4,2,2,3,3,6,6,1,1,3,3,0,0,4,4,3,3,6,6,0,0,1,1,3,3,4,4,7,7,3,3,6,6,1,1,5,5,4,4,7,7,5,5,6,6,6,6,3,3,3,3,6,6,2,2,1,1,1,1,7,7,2,2,2,2,1,1,1,1,6,6,6,6,4,4,5,5,6,6,2,2,2,2,7,7,3,3,7,7,2,2,1,1,4,4,6,6,6,6,5,5,4,4,6,6,3,3,4,4,6,6,0,0,0,0,4,4,1,1,2,2,2,2,1,1,3,3,1,1,2,2,5,5,7,7,7,7,2,2,2,2,0,0,4,4,1,1,6,6,5,5,6,6,3,3,1,1,4,4,4,4,6,6,1,1,7,7,1,1,5,5,6,6,6,6,4,4,3,3,1,1,6,6,5,5,1,1,1,1,4,4,2,2,0,0,7,7,7,7,6,6,5,5,5,5,1,1,3,3,4,4,6,6,4,4,1,1,1,1,5,5,3,3,5,5,0,0,6,6,0,0,2,2,6,6,7,7,5,5,2,2,5,5,3,3,5,5,7,7,0,0,5,5,4,4,3,3,7,7,1,1,5,5,1,1,5,5,4,4,5,5,0,0,1,1,7,7,1,1,2,2,0,0,7,7,7,7,1,1,6,6,6,6,7,7,2,2,2,2,4,4,3,3,4,4,1,1,4,4,2,2,0,0,2,2,3,3,1,1,0,0,7,7,6,6,7,7,5,5,3,3,1,1,1,1,6,6,6,6,4,4,7,7,2,2,0,0,6,6,4,4,4,4,3,3,7,7,6,6,4,4,2,2,2,2,7,7,6,6,2,2,3,3,2,2,3,3,4,4,4,4,4,4,3,3,3,3,5,5,0,0,4,4,5,5,4,4,2,2,1,1,6,6,0,0,2,2,5,5,2,2,0,0,3,3,3,3,6,6,0,0,5,5,6,6,0,0,5,5,3,3,5,5,1,1,6,6,7,7,0,0,7,7,1,1,4,4,1,1,1,1,1,1,6,6,3,3,1,1,4,4,1,1,5,5,3,3,4,4,6,6,4,4,1,1,4,4,7,7,5,5,4,4,6,6,2,2,0,0,3,3,3,3,3,3,0,0,0,0,5,5,7,7,4,4,3,3,1,1,7,7,1,1,6,6,1,1,5,5,1,1,3,3,5,5,1,1,1,1,2,2,0,0,0,0,2,2,6,6,4,4,2,2,6,6,7,7,2,2,2,2,2,2,1,1,2,2,5,5,5,5,0,0,7,7,5,5,0,0,7,7,0,0,3,3,3,3,2,2,7,7,1,1,5,5,2,2,0,0,5,5,1,1,1,1,7,7,3,3,1,1,0,0,5,5,7,7,5,5,5,5,2,2,5,5,7,7,6,6,3,3,7,7,7,7,5,5,6,6,3,3,3,3,1,1,2,2,1,1,6,6,2,2,1,1,3,3,1,1,4,4,2,2,7,7,4,4,7,7,3,3,5,5,7,7,1,1,3,3,3,3,7,7,4,4,5,5,7,7,0,0,4,4,4,4,5,5,6,6,3,3,0,0,2,2,1,1,3,3,3,3,0,0,5,5,2,2,4,4,4,4,4,4,1,1,5,5,1,1,1,1,1,1,4,4,7,7,5,5,1,1,1,1,5,5,6,6,3,3,3,3,2,2,0,0,0,0,4,4,0,0,4,4,2,2,5,5,7,7,4,4,6,6,5,5,7,7,3,3,3,3,1,1,2,2,4,4,4,4,3,3,4,4,2,2,0,0,1,1,1,1,1,1,0,0,4,4,2,2,6,6,2,2,0,0,2,2,0,0,2,2,4,4,1,1,3,3,5,5,2,2,5,5,0,0,0,0,4,4,6,6,3,3,2,2,5,5,0,0,7,7,2,2,6,6,0,0,0,0,5,5,0,0,1,1,4,4,6,6,7,7,1,1,4,4,0,0,4,4,3,3,3,3,5,5,0,0,3,3,0,0,7,7,0,0,3,3,2,2,0,0,4,4,4,4,0,0,3,3,0,0,3,3,0,0,0,0,3,3,2,2,6,6,4,4,0,0,5,5,7,7,3,3,3,3,3,3,6,6,0,0,6,6,2,2,7,7,4,4,0,0,2,2,2,2,2,2,0,0,7,7,6,6,7,7,7,7,7,7,7,7,5,5,6,6,7,7,5,5,4,4,3,3,2,2,0,0,2,2,4,4,5,5,1,1,4,4,4,4,1,1,1,1,5,5,4,4,6,6,5,5,6,6,5,5,1,1,6,6,5,5,3,3,2,2,7,7,6,6,0,0,3,3,0,0,6,6,3,3,6,6,2,2,7,7,2,2,0,0,4,4,7,7,6,6,7,7,6,6,6,6,4,4,4,4,2,2,1,1,4,4,0,0,7,7,7,7,2,2,2,2,3,3,0,0,2,2,4,4,5,5,0,0,4,4,1,1,1,1,4,4,3,3,3,3,6,6,0,0,7,7,2,2,6,6,4,4,5,5,4,4,5,5,2,2,2,2,2,2,4,4,6,6,6,6,3,3,1,1,1,1,0,0,5,5,0,0,4,4,4,4,0,0,1,1,7,7,4,4,7,7,2,2,5,5,7,7,4,4,4,4,7,7,2,2,5,5,0,0,2,2,4,4,4,4,3,3,2,2,0,0,3,3,7,7,2,2,1,1,2,2,3,3,1,1,2,2,1,1,2,2,4,4,7,7,3,3,4,4,3,3,7,7,1,1,4,4,3,3,4,4,4,4,6,6,2,2,2,2,5,5,7,7,3,3,5,5,7,7,1,1,2,2,2,2,4,4,6,6,0,0,6,6,1,1,5,5,2,2,7,7,1,1,4,4,0,0,2,2,3,3,3,3,4,4,0,0,4,4,7,7,5,5,2,2,7,7,6,6,3,3,7,7,0,0,7,7,3,3,4,4,1,1,6,6,0,0,7,7,2,2,5,5,3,3,0,0,3,3,4,4,0,0,2,2,7,7,1,1,1,1,7,7,0,0,6,6,2,2,1,1,6,6,4,4,2,2,2,2,4,4,2,2,6,6,3,3,5,5,5,5,2,2,5,5,6,6,4,4,6,6,2,2,0,0,7,7,6,6,5,5,1,1,0,0,6,6,7,7,0,0,6,6,3,3,3,3,2,2,4,4,7,7,7,7,0,0,6,6,1,1,3,3,4,4,6,6,1,1,1,1,7,7,2,2,7,7,3,3,5,5,5,5,0,0,0,0,4,4,7,7,6,6,6,6,2,2,5,5,5,5,0,0,7,7,0,0,3,3,4,4,7,7,3,3,1,1,7,7,4,4,0,0,1,1,0,0,5,5,6,6,4,4,2,2,7,7,3,3,6,6,0,0,6,6,1,1,2,2,5,5,0,0,0,0,4,4,7,7,6,6,2,2,7,7,1,1,5,5,1,1,3,3,1,1,3,3,5,5,2,2,5,5,4,4,2,2,7,7,0,0,5,5,6,6,0,0,7,7,2,2,2,2,4,4,4,4,5,5,5,5,6,6,7,7,5,5,6,6,1,1,2,2,5,5,4,4,7,7,2,2,6,6,1,1,5,5,3,3,4,4,0,0,5,5,6,6,6,6,4,4,7,7,7,7,1,1,7,7,5,5,4,4,1,1,2,2,7,7,6,6,0,0,3,3,5,5,1,1,4,4,0,0,5,5,2,2,1,1,2,2,2,2,1,1,7,7,6,6,3,3,7,7,6,6,1,1,0,0,6,6,4,4,7,7,0,0,5,5,6,6,3,3,3,3,4,4,4,4,1,1,2,2,3,3,7,7,6,6,7,7,1,1,2,2,4,4,5,5,7,7,6,6,1,1,0,0,0,0,3,3,4,4,6,6,4,4,0,0,6,6,6,6,2,2,1,1,1,1,4,4,6,6,0,0,0,0,4,4,3,3,0,0,5,5,5,5,3,3,3,3,5,5,5,5,1,1,5,5,2,2,2,2,6,6,5,5,3,3,2,2,7,7,0,0,0,0,7,7,6,6,1,1,0,0,0,0,2,2,6,6,3,3,5,5,1,1,0,0,6,6,0,0,6,6,0,0,0,0,1,1,2,2,0,0,7,7,4,4,2,2,2,2,1,1,2,2,5,5,5,5,3,3,1,1,3,3,1,1,3,3,1,1,6,6,1,1,7,7,2,2,4,4,5,5,7,7,3,3,6,6,3,3,3,3,6,6,4,4,6,6,3,3,3,3,6,6,6,6,0,0,0,0,5,5,2,2,6,6,6,6,6,6,6,6,0,0,0,0,1,1,3,3,7,7,0,0,6,6,0,0,0,0,5,5,6,6,2,2,5,5,4,4,0,0,7,7,3,3,4,4,5,5,1,1,5,5,0,0,3,3,1,1,2,2,2,2,0,0,3,3,0,0,2,2,1,1,7,7,4,4,7,7,0,0,4,4,0,0,3,3,2,2,6,6,0,0,0,0,1,1,3,3,7,7,5,5,0,0,6,6,0,0,1,1,3,3,6,6,4,4,4,4,1,1,4,4,6,6,2,2,5,5,0,0,4,4,7,7,5,5,5,5,0,0,3,3,2,2,3,3,1,1,1,1,5,5,1,1,4,4,5,5,5,5,2,2,2,2,5,5,2,2,6,6,5,5,2,2,5,5,7,7,2,2,1,1,4,4,6,6,5,5,0,0,5,5,0,0,2,2,0,0,4,4,7,7,1,1,5,5,6,6,7,7,4,4,3,3,1,1,5,5,3,3,7,7,3,3,7,7,1,1,5,5,6,6,3,3,4,4,3,3,3,3,5,5,2,2,3,3,5,5,6,6,3,3,7,7,4,4,6,6,6,6,4,4,5,5,4,4,6,6,1,1,5,5,3,3,2,2,5,5,2,2,0,0,3,3,6,6,2,2,0,0,7,7,3,3,6,6,7,7,3,3,3,3,1,1,6,6,0,0,0,0,4,4,0,0,3,3,0,0,2,2,3,3,7,7,4,4,7,7,7,7,3,3,7,7,2,2,1,1,7,7,5,5,4,4,6,6,4,4,5,5,4,4,1,1,7,7,4,4,2,2,3,3,4,4,6,6,0,0,6,6,3,3,4,4,7,7,0,0,0,0,3,3,4,4,0,0,4,4,0,0,6,6,3,3,3,3,5,5,0,0,6,6,5,5,0,0,3,3,0,0,1,1,0,0,7,7,2,2,6,6,0,0,0,0,0,0,4,4,4,4,2,2,6,6,2,2,4,4,7,7,6,6,5,5,1,1,0,0,5,5,0,0,1,1,5,5,5,5,7,7,1,1,0,0,1,1,4,4,4,4,2,2,0,0,5,5,0,0,1,1,6,6,5,5,3,3,7,7,5,5,7,7,1,1,5,5,6,6,6,6,5,5,1,1,1,1,0,0,0,0,4,4,5,5,1,1,5,5,1,1,4,4,0,0,5,5,6,6,4,4,2,2,4,4,3,3,3,3,0,0,2,2,6,6,3,3,2,2,3,3,0,0,6,6,0,0,2,2,4,4,3,3,6,6,2,2,7,7,0,0,3,3,2,2,5,5,2,2,5,5,3,3,6,6,7,7,1,1,1,1,4,4,5,5,7,7,6,6,6,6,2,2,4,4,0,0,4,4,4,4,4,4,2,2,7,7,6,6,7,7,3,3,0,0,1,1,5,5,6,6,2,2,6,6,0,0,3,3,0,0,2,2,4,4,5,5,7,7,0,0,4,4,1,1,2,2,1,1,0,0,1,1,0,0,7,7,0,0,5,5,1,1,6,6,3,3,0,0,7,7,4,4,4,4,0,0,4,4,1,1,0,0,3,3,4,4,6,6,1,1,0,0,5,5,2,2,0,0,5,5,0,0,4,4,2,2,5,5,3,3,7,7,7,7,1,1,1,1,4,4,7,7,2,2,1,1,4,4,1,1,2,2,2,2,6,6,1,1,5,5,0,0,7,7,5,5,4,4,2,2,6,6,1,1,3,3,6,6,7,7,7,7,0,0,5,5,2,2,0,0,1,1,1,1,6,6,1,1,5,5,7,7,5,5,5,5,4,4,2,2,0,0,7,7,2,2,7,7,4,4,0,0,0,0,4,4,4,4,2,2,0,0,4,4,1,1,6,6,6,6,1,1,4,4,2,2,7,7,2,2,2,2,0,0,6,6,6,6,7,7,4,4,3,3,7,7,0,0,2,2,3,3,7,7,6,6,1,1,0,0,6,6,7,7,4,4,7,7,3,3,1,1,3,3,7,7,7,7,1,1,4,4,2,2,1,1,5,5,6,6,6,6,3,3,3,3,2,2,6,6,4,4,0,0,1,1,6,6,1,1,2,2,4,4,7,7,7,7,3,3,7,7,0,0,5,5,6,6,6,6,0,0,4,4,4,4,0,0,2,2,2,2,0,0,3,3,3,3,0,0,2,2,6,6,2,2,4,4,6,6,2,2,0,0,6,6,5,5,4,4,7,7,3,3,7,7,2,2,0,0,3,3,6,6,0,0,2,2,6,6,2,2,0,0,4,4,3,3,3,3,4,4,4,4,2,2,1,1,6,6,1,1,4,4,2,2,4,4,0,0,2,2,0,0,2,2,6,6,0,0,1,1,2,2,0,0,7,7,0,0,4,4,4,4,7,7,3,3,6,6,5,5,1,1,7,7,2,2,5,5,5,5,2,2,5,5,5,5,1,1,4,4,3,3,6,6,0,0,5,5,2,2,5,5,2,2,0,0,3,3,4,4,0,0,0,0,0,0,3,3,5,5,2,2,1,1,7,7,3,3,5,5,1,1,0,0,3,3,0,0,3,3,3,3,6,6,7,7,0,0,4,4,1,1,5,5,0,0,7,7,5,5,4,4,7,7,0,0,5,5,5,5,5,5,7,7,7,7,4,4,7,7,6,6,0,0,2,2,3,3,7,7,7,7,6,6,4,4,7,7,4,4,6,6,0,0,2,2,1,1,4,4,4,4,0,0,0,0,2,2,2,2,4,4,0,0,6,6,0,0,6,6,3,3,7,7,4,4,6,6,3,3,7,7,3,3,5,5,5,5,3,3,1,1,3,3,2,2,5,5,4,4,6,6,0,0,3,3,2,2,3,3,6,6,2,2,6,6,7,7,6,6,4,4,3,3,1,1,4,4,2,2,2,2,1,1,0,0,4,4,0,0,7,7,4,4,7,7,7,7,0,0,6,6,4,4,6,6,1,1,0,0,0,0,7,7,3,3,7,7,5,5,4,4,1,1,7,7,3,3,4,4,0,0,4,4,4,4,7,7,6,6,4,4,2,2,3,3,4,4,3,3,1,1,2,2,2,2,5,5,0,0,0,0,1,1,2,2,7,7,4,4,7,7,7,7,3,3,3,3,5,5,0,0,5,5,6,6,0,0,0,0,0,0,4,4,1,1,2,2,2,2,5,5,2,2,4,4,1,1,4,4,5,5,7,7,5,5,5,5,3,3,5,5,6,6,5,5,5,5,1,1,7,7,7,7,1,1,2,2,5,5,3,3,0,0,4,4,0,0,4,4,6,6,2,2,7,7,4,4,3,3,0,0,5,5,5,5,5,5,4,4,0,0,0,0,2,2,1,1,1,1,1,1,0,0,5,5,3,3,7,7,4,4,0,0,7,7,4,4,2,2,3,3,1,1,3,3,7,7,3,3,7,7,6,6,0,0,4,4,2,2,4,4,2,2,4,4,4,4,6,6,0,0,1,1,7,7,0,0,3,3,2,2,6,6,0,0,7,7,3,3,0,0,3,3,4,4,0,0,3,3,3,3,1,1,6,6,7,7,2,2,0,0,4,4,6,6,2,2,6,6,0,0,7,7,6,6,0,0,3,3,7,7,2,2,0,0,2,2,1,1,3,3,2,2,3,3,4,4,4,4,6,6,5,5,0,0,1,1,2,2,2,2,1,1,1,1,5,5,4,4,6,6,2,2,0,0,4,4,7,7,7,7,1,1,5,5,0,0,1,1,5,5,5,5,7,7,5,5,0,0,0,0,2,2,2,2,1,1,4,4,5,5,3,3,0,0,0,0,0,0,4,4,7,7,1,1,0,0,3,3,3,3,3,3,5,5,5,5,7,7,4,4,6,6,6,6,2,2,5,5,2,2,2,2,6,6,0,0,4,4,7,7,0,0,2,2,5,5,2,2,6,6,4,4,5,5,2,2,3,3,2,2,3,3,7,7,0,0,3,3,1,1,0,0,7,7,3,3,2,2,5,5,7,7,2,2,0,0,7,7,5,5,4,4,6,6,3,3,5,5,4,4,3,3,4,4,7,7,4,4,0,0,5,5,6,6,5,5,1,1,5,5,5,5,4,4,5,5,1,1,7,7,6,6,7,7,1,1,2,2,2,2,2,2,6,6,4,4,4,4,1,1,0,0,7,7,1,1,1,1,0,0,0,0,0,0,2,2,6,6,2,2,1,1,7,7,1,1,3,3,3,3,3,3,6,6,3,3,7,7,0,0,3,3,5,5,5,5,0,0,4,4,4,4,6,6,3,3,2,2,5,5,0,0,4,4,5,5,7,7,1,1,1,1,3,3,7,7,4,4,7,7,5,5,2,2,0,0,7,7,5,5,3,3,0,0,2,2,2,2,1,1,5,5,2,2,0,0,1,1,6,6,6,6,7,7,4,4,6,6,1,1,6,6,4,4,7,7,2,2,3,3,4,4,5,5,2,2,1,1,6,6,5,5,0,0,3,3,0,0,3,3,3,3,4,4,0,0,3,3,5,5,6,6,7,7,7,7,2,2,3,3,0,0,4,4,7,7,1,1,0,0,4,4,1,1,6,6,5,5,0,0,3,3,4,4,1,1,2,2,5,5,1,1,4,4,4,4,5,5,3,3,6,6,5,5,1,1,2,2,4,4,5,5,4,4,3,3,6,6,7,7,6,6,4,4,4,4,3,3,6,6,1,1,2,2,0,0,2,2,2,2,7,7,2,2,2,2,1,1,1,1,4,4,5,5,2,2,1,1,0,0,6,6,3,3,6,6,0,0,0,0,0,0,3,3,1,1,6,6,0,0,6,6,4,4,1,1,2,2,0,0,5,5,7,7,3,3,5,5,0,0,0,0,0,0,5,5,5,5,6,6,0,0,6,6,3,3,6,6,1,1,3,3,3,3,0,0,4,4,5,5,0,0,3,3,2,2,3,3,5,5,4,4,5,5,7,7,1,1,2,2,4,4,0,0,6,6,1,1,3,3,0,0,6,6,6,6,0,0,1,1,5,5,6,6,7,7,4,4,3,3,2,2,6,6,7,7,2,2,0,0,0,0,2,2,6,6,0,0,5,5,7,7,0,0,4,4,3,3,3,3,4,4,5,5,7,7,5,5,3,3,1,1,4,4,6,6,2,2,3,3,4,4,0,0,0,0,2,2,0,0,0,0,3,3,3,3,0,0,4,4,6,6,1,1,4,4,7,7,0,0,2,2,2,2,4,4,0,0,2,2,6,6,0,0,1,1,0,0,4,4,2,2,1,1,0,0,0,0,4,4,2,2,6,6,3,3,4,4,3,3,6,6,1,1,2,2,1,1,4,4,4,4,1,1,6,6,3,3,6,6,4,4,0,0,3,3,7,7,6,6,0,0,1,1,4,4,1,1,1,1,3,3,5,5,1,1,3,3,1,1,0,0,3,3,5,5,0,0,2,2,0,0,4,4,5,5,3,3,3,3,5,5,5,5,7,7,2,2,2,2,7,7,0,0,1,1,1,1,1,1,2,2,6,6,2,2,3,3,0,0,6,6,1,1,4,4,1,1,2,2,5,5,0,0,1,1,4,4,3,3,3,3,3,3,2,2,1,1,0,0,1,1,3,3,2,2,1,1,6,6,1,1,2,2,3,3,1,1,3,3,1,1,7,7,0,0,3,3,4,4,5,5,3,3,3,3,0,0,3,3,6,6,4,4,6,6,3,3,0,0,4,4,2,2,5,5,5,5,5,5,2,2,2,2,3,3,0,0,5,5,7,7,0,0,7,7,3,3,0,0,2,2,6,6,1,1,0,0,5,5,5,5,7,7,6,6,3,3,7,7,2,2,5,5,4,4,2,2,0,0,5,5,0,0,0,0,7,7,4,4,1,1,0,0,0,0,5,5,4,4,1,1,4,4,2,2,3,3,4,4,0,0,2,2,2,2,0,0,2,2,5,5,1,1,2,2,7,7,2,2,4,4,2,2,2,2,1,1,0,0,5,5,0,0,6,6,3,3,2,2,4,4,4,4,0,0,6,6,2,2,2,2,0,0,1,1,4,4,1,1,4,4,3,3,5,5,1,1,3,3,0,0,3,3,2,2,1,1,5,5,3,3,3,3,6,6,0,0,6,6,2,2,4,4,7,7,2,2,3,3,5,5,1,1,2,2,3,3,5,5,3,3,5,5,5,5,6,6,2,2,6,6,3,3,4,4,4,4,6,6,7,7,7,7,0,0,3,3,7,7,2,2,1,1,2,2,4,4,6,6,2,2,1,1,7,7,4,4,6,6,3,3,1,1,0,0,7,7,7,7,5,5,0,0,0,0,1,1,2,2,5,5,1,1,6,6,0,0,0,0,6,6,0,0,1,1,4,4,1,1,2,2,4,4,3,3,6,6,3,3,1,1,6,6,6,6,3,3,2,2,6,6,7,7,1,1,4,4,1,1,6,6,7,7,1,1,0,0,3,3,4,4,0,0,6,6,3,3,1,1,3,3,2,2,3,3,0,0,4,4,0,0,4,4,3,3,6,6,5,5,1,1,6,6,1,1,2,2,6,6,1,1,3,3,2,2,3,3,5,5,5,5,6,6,3,3,2,2,7,7,6,6,5,5,0,0,6,6,7,7,2,2,2,2,5,5,5,5,0,0,2,2,5,5,4,4,3,3,2,2,4,4,4,4,6,6,2,2,0,0,4,4,7,7,6,6,5,5,5,5,5,5,1,1,0,0,5,5,4,4,5,5,4,4,6,6,6,6,3,3,2,2,6,6,5,5,1,1,7,7,5,5,7,7,6,6,5,5,4,4,0,0,2,2,2,2,4,4,3,3,5,5,5,5,1,1,6,6,7,7,1,1,5,5,3,3,5,5,2,2,0,0,2,2,1,1,0,0,7,7,4,4,2,2,3,3,0,0,4,4,6,6,4,4,3,3,3,3,2,2,6,6,2,2,2,2,0,0,2,2,3,3,6,6,1,1,3,3,7,7,2,2,5,5,6,6,3,3,7,7,0,0,2,2,1,1,5,5,1,1,6,6,7,7,4,4,3,3,0,0,3,3,7,7,5,5,6,6,7,7,3,3,3,3,0,0,1,1,5,5,0,0,5,5,2,2,4,4,5,5,4,4,2,2,0,0,2,2,7,7,7,7,0,0,6,6,5,5,7,7,6,6,6,6,2,2,5,5,7,7,4,4,7,7,4,4,3,3,1,1,0,0,7,7,0,0,3,3,3,3,4,4,2,2,5,5,0,0,6,6,1,1,6,6,4,4,5,5,1,1,1,1,6,6,0,0,0,0,3,3,0,0,5,5,5,5,3,3,3,3,1,1,4,4,1,1,0,0,3,3,0,0,4,4,1,1,3,3,4,4,0,0,4,4,6,6,7,7,1,1,3,3,2,2,5,5,4,4,4,4,5,5,3,3,4,4,4,4,3,3,4,4,7,7,0,0,5,5,0,0,4,4,6,6,0,0,1,1,3,3,3,3,6,6,2,2,0,0,6,6,5,5,1,1,6,6,3,3,4,4,2,2,0,0,1,1,3,3,5,5,1,1,6,6,0,0,7,7,5,5,0,0,5,5,1,1,4,4,0,0,2,2,4,4,1,1,7,7,3,3,0,0,0,0,2,2,0,0,3,3,4,4,5,5,7,7,3,3,4,4,3,3,6,6,4,4,4,4,1,1,5,5,1,1,4,4,4,4,5,5,2,2,0,0,3,3,1,1,7,7,1,1,0,0,4,4,2,2,5,5,5,5,5,5,3,3,1,1,0,0,4,4,2,2,0,0,6,6,1,1,3,3,0,0,7,7,3,3,0,0,0,0,1,1,3,3,5,5,0,0,6,6,3,3,6,6,4,4,4,4,6,6,2,2,5,5,3,3,1,1,5,5,0,0,6,6,1,1,0,0,5,5,3,3,2,2,3,3,6,6,5,5,4,4,7,7,4,4,4,4,5,5,2,2,3,3,3,3,2,2,5,5,0,0,2,2,3,3,2,2,4,4,1,1,5,5,4,4,3,3,2,2,3,3,3,3,2,2,3,3,0,0,6,6,5,5,0,0,2,2,7,7,0,0,4,4,4,4,2,2,4,4,3,3,7,7,2,2,7,7,2,2,1,1,1,1,0,0,3,3,1,1,7,7,6,6,3,3,4,4,2,2,6,6,1,1,1,1,5,5,3,3,4,4,7,7,0,0,5,5,1,1,5,5,4,4,3,3,7,7,6,6,6,6,1,1,6,6,4,4,4,4,4,4,3,3,6,6,3,3,1,1,3,3,2,2,7,7,5,5,7,7,2,2,0,0,1,1,0,0,1,1,4,4,6,6,3,3,4,4,1,1,4,4,5,5,2,2,7,7,2,2,2,2,7,7,7,7,0,0,5,5,1,1,6,6,6,6,3,3,5,5,1,1,7,7,0,0,4,4,1,1,6,6,5,5,4,4,1,1,3,3,2,2,5,5,6,6,5,5,0,0,4,4,0,0,0,0,2,2,1,1,7,7,4,4,3,3,0,0,5,5,1,1,3,3,2,2,6,6,6,6,4,4,5,5,4,4,0,0,3,3,4,4,5,5,6,6,4,4,1,1,4,4,7,7,7,7,3,3,1,1,7,7,1,1,7,7,7,7,5,5,5,5,2,2,5,5,6,6,3,3,0,0,3,3,1,1,3,3,6,6,0,0,0,0,0,0,3,3,2,2,1,1,3,3,7,7,0,0,7,7,1,1,2,2,0,0,6,6,6,6,0,0,5,5,5,5,2,2,6,6,6,6,0,0,0,0,3,3,2,2,7,7,4,4,4,4,7,7,6,6,6,6,6,6,2,2,6,6,1,1,6,6,0,0,2,2,7,7,5,5,7,7,5,5,4,4,0,0,1,1,1,1,0,0,3,3,6,6,7,7,6,6,0,0,2,2,4,4,3,3,7,7,7,7,0,0,2,2,1,1,6,6,3,3,1,1,6,6,2,2,2,2,0,0,7,7,4,4,7,7,2,2,4,4,1,1,4,4,6,6,3,3,4,4,1,1,0,0,0,0,1,1,5,5,6,6,0,0,7,7,0,0,3,3,0,0,7,7,4,4,1,1,4,4,2,2,4,4,7,7,5,5,7,7,0,0,5,5,0,0,1,1,3,3,0,0,3,3,3,3,2,2,4,4,2,2,0,0,0,0,0,0,0,0,4,4,3,3,3,3,3,3,1,1,1,1,7,7,0,0,5,5,1,1,7,7,4,4,1,1,2,2,2,2,6,6,1,1,6,6,6,6,3,3,7,7,3,3,5,5,4,4,0,0,6,6,1,1,7,7,5,5,7,7,3,3,7,7,0,0,3,3,5,5,2,2,1,1,7,7,6,6,5,5,0,0,5,5,3,3,6,6,0,0,1,1,3,3,5,5,2,2,0,0,6,6,4,4,7,7,0,0,4,4,3,3,2,2,6,6,2,2,4,4,7,7,5,5,3,3,1,1,2,2,5,5,7,7,2,2,4,4,5,5,7,7,6,6,2,2,3,3,7,7,1,1,6,6,1,1,0,0,2,2,4,4,2,2,5,5,1,1,2,2,7,7,2,2,6,6,2,2,5,5,3,3,5,5,4,4,0,0,0,0,7,7,5,5,3,3,2,2,0,0,0,0,5,5,0,0,4,4,6,6,4,4,5,5,6,6,1,1,4,4,3,3,6,6,6,6,3,3,5,5,4,4,7,7,3,3,2,2,5,5,4,4,4,4,2,2,6,6,2,2,4,4,3,3,0,0,7,7,2,2,5,5,5,5,6,6,5,5,6,6,6,6,6,6,1,1,1,1,2,2,2,2,0,0,2,2,2,2,4,4,4,4,6,6,3,3,2,2,5,5,5,5,0,0,1,1,0,0,6,6,2,2,1,1,3,3,4,4,4,4,1,1,6,6,5,5,5,5,7,7,7,7,5,5,6,6,7,7,3,3,6,6,5,5,0,0,5,5,3,3,5,5,1,1,3,3,7,7,3,3,1,1,4,4,7,7,7,7,3,3,0,0,6,6,2,2,3,3,2,2,7,7,1,1,3,3,2,2,3,3,7,7,2,2,2,2,0,0,2,2,1,1,4,4,6,6,2,2,7,7,7,7,3,3,2,2,7,7,6,6,3,3,2,2,7,7,0,0,2,2,0,0,0,0,7,7,6,6,4,4,1,1,4,4,2,2,0,0,5,5,0,0,2,2,1,1,1,1,2,2,1,1,7,7,1,1,7,7,1,1,0,0,3,3,1,1,0,0,7,7,7,7,4,4,3,3,0,0,5,5,4,4,6,6,2,2,7,7,2,2,0,0,0,0,2,2,7,7,6,6,0,0,5,5,2,2,7,7,4,4,7,7,2,2,7,7,3,3,2,2,3,3,4,4,6,6,3,3,7,7,3,3,7,7,0,0,7,7,5,5,1,1,0,0,5,5,4,4,3,3,5,5,2,2,0,0,3,3,0,0,2,2,2,2,0,0,6,6,3,3,7,7,6,6,5,5,5,5,6,6,3,3,2,2,2,2,6,6,2,2,1,1,1,1,4,4,1,1,2,2,3,3,5,5,5,5,6,6,3,3,2,2,1,1,0,0,4,4,2,2,2,2,6,6,4,4,2,2,6,6,5,5,1,1,6,6,1,1,1,1,1,1,3,3,0,0,6,6,6,6,4,4,7,7,7,7,4,4,1,1,2,2,1,1,1,1,4,4,5,5,6,6,7,7,4,4,1,1,0,0,6,6,4,4,2,2,5,5,4,4,4,4,6,6,4,4,6,6,2,2,1,1,4,4,6,6,1,1,1,1,2,2,5,5,6,6,4,4,1,1,7,7,1,1,0,0,7,7,3,3,4,4,0,0,2,2,1,1,3,3,7,7,4,4,5,5,5,5,2,2,2,2,6,6,6,6,3,3,2,2,0,0,2,2,3,3,7,7,4,4,1,1,1,1,6,6,7,7,5,5,1,1,6,6,3,3,0,0,6,6,4,4,3,3,0,0,0,0,0,0,1,1,3,3,1,1,5,5,2,2,2,2,5,5,1,1,2,2,0,0,5,5,1,1,6,6,1,1,4,4,7,7,7,7,1,1,0,0,3,3,4,4,0,0,6,6,1,1,7,7,6,6,5,5,7,7,5,5,7,7,1,1,3,3,6,6,1,1,5,5,2,2,0,0,1,1,3,3,2,2,4,4,1,1,1,1,7,7,5,5,2,2,5,5,5,5,0,0,1,1,3,3,0,0,4,4,2,2,1,1,5,5,6,6,1,1,2,2,3,3,0,0,5,5,3,3,2,2,4,4,6,6,4,4,6,6,6,6,7,7,1,1,0,0,3,3,1,1,5,5,0,0,5,5,7,7,1,1,6,6,5,5,4,4,0,0,2,2,5,5,6,6,7,7,6,6,3,3,7,7,2,2,4,4,7,7,7,7,0,0,5,5,1,1,4,4,6,6,1,1,5,5,3,3,2,2,2,2,7,7,3,3,6,6,1,1,4,4,4,4,5,5,7,7,1,1,4,4,7,7,4,4,1,1,5,5,3,3,2,2,6,6,2,2,2,2,6,6,7,7,3,3,6,6,4,4,2,2,4,4,6,6,1,1,4,4,1,1,3,3,6,6,7,7,6,6,4,4,2,2,3,3,6,6,1,1,0,0,0,0,0,0,7,7,0,0,4,4,0,0,5,5,0,0,3,3,5,5,2,2,2,2,5,5,0,0,5,5,5,5,7,7,0,0,5,5,0,0,6,6,7,7,3,3,7,7,7,7,3,3,1,1,4,4,0,0,1,1,2,2,0,0,0,0,2,2,2,2,4,4,7,7,3,3,2,2,2,2,2,2,3,3,4,4,6,6,3,3,0,0,0,0,3,3,6,6,0,0,7,7,2,2,7,7,4,4,3,3,0,0,5,5,0,0,6,6,4,4,2,2,7,7,6,6,7,7,1,1,5,5,0,0,6,6,6,6,2,2,4,4,6,6,4,4,4,4,4,4,2,2,3,3,7,7,0,0,1,1,2,2,2,2,1,1,5,5,3,3,6,6,0,0,1,1,5,5,0,0,0,0,2,2,1,1,6,6,2,2,0,0,2,2,0,0,7,7,1,1,0,0,6,6,7,7,1,1,5,5,3,3,6,6,3,3,0,0,4,4,6,6,0,0,0,0,0,0,7,7,1,1,2,2,2,2,3,3,4,4,4,4,1,1,5,5,3,3,4,4,0,0,2,2,3,3,5,5,2,2,0,0,2,2,6,6,6,6,3,3,7,7,5,5,2,2,2,2,1,1,3,3,0,0,7,7,1,1,0,0,4,4,2,2,5,5,3,3,1,1,5,5,6,6,0,0,7,7,0,0,7,7,4,4,4,4,0,0,3,3,0,0,2,2,2,2,5,5,1,1,2,2,1,1,0,0,5,5,4,4,3,3,2,2,3,3,5,5,7,7,1,1,6,6,4,4,6,6,4,4,5,5,4,4,2,2,2,2,5,5,1,1,0,0,0,0,3,3,6,6,4,4,2,2,5,5,3,3,4,4,1,1,3,3,2,2,7,7,6,6,2,2,2,2,3,3,2,2,6,6,7,7,7,7,2,2,1,1,4,4,2,2,1,1,4,4,4,4,7,7,3,3,7,7,5,5,4,4,4,4,7,7,0,0,6,6,7,7,2,2,7,7,1,1,7,7,5,5,3,3,0,0,4,4,1,1,1,1,5,5,0,0,0,0,2,2,5,5,3,3,7,7,6,6,4,4,4,4,6,6,2,2,3,3,1,1,3,3,6,6,7,7,3,3,0,0,1,1,7,7,1,1,3,3,4,4,6,6,0,0,5,5,6,6,4,4,7,7,3,3,7,7,6,6,2,2,2,2,4,4,4,4,6,6,7,7,4,4,0,0,3,3,5,5,5,5,2,2,2,2,4,4,0,0,5,5,7,7,1,1,2,2,3,3,0,0,4,4,1,1,7,7,4,4,5,5,7,7,3,3,4,4,4,4,0,0,0,0,4,4,1,1,4,4,3,3,0,0,1,1,4,4,4,4,5,5,5,5,4,4,3,3,3,3,5,5,4,4,7,7,5,5,5,5,0,0,0,0,5,5,1,1,7,7,0,0,3,3,3,3,1,1,7,7,1,1,4,4,2,2,2,2,7,7,4,4,2,2,3,3,7,7,2,2,7,7,2,2,1,1,3,3,2,2,0,0,5,5,1,1,2,2,5,5,5,5,5,5,0,0,2,2,2,2,6,6,0,0,0,0,7,7,0,0,1,1,6,6,1,1,6,6,2,2,0,0,0,0,6,6,4,4,6,6,1,1,1,1,1,1,5,5,5,5,4,4,7,7,6,6,1,1,4,4,7,7,7,7,7,7,3,3,4,4,7,7,1,1,0,0,3,3,2,2,7,7,6,6,4,4,0,0,0,0,6,6,0,0,4,4,0,0,5,5,4,4,3,3,6,6,3,3,5,5,1,1,2,2,5,5,4,4,2,2,5,5,0,0,0,0,0,0,1,1,2,2,7,7,1,1,5,5,1,1,5,5,5,5,0,0,3,3,1,1,0,0,5,5,7,7,5,5,0,0,0,0,2,2,2,2,5,5,1,1,3,3,0,0,4,4,3,3,2,2,7,7,5,5,2,2,7,7,4,4,7,7,0,0,4,4,7,7,1,1,6,6,1,1,3,3,7,7,7,7,5,5,0,0,7,7,1,1,1,1,5,5,7,7,5,5,2,2,4,4,6,6,3,3,2,2,1,1,3,3,1,1,7,7,7,7,1,1,2,2,6,6,1,1,2,2,3,3,4,4,0,0,2,2,5,5,4,4,5,5,3,3,0,0,2,2,6,6,5,5,3,3,5,5,3,3,3,3,1,1,2,2,1,1,4,4,6,6,2,2,7,7,3,3,0,0,0,0,6,6,0,0,4,4,2,2,0,0,2,2,4,4,1,1,1,1,2,2,2,2,6,6,1,1,1,1,5,5,1,1,4,4,7,7,3,3,0,0,5,5,4,4,7,7,7,7,5,5,1,1,7,7,2,2,7,7,1,1,0,0,6,6,0,0,5,5,2,2,5,5,3,3,0,0,2,2,2,2,2,2,5,5,5,5,1,1,1,1,1,1,5,5,7,7,7,7,6,6,1,1,2,2,7,7,0,0,4,4,2,2,0,0,7,7,3,3,5,5,7,7,0,0,2,2,0,0,2,2,4,4,7,7,6,6,1,1,7,7,3,3,2,2,7,7,7,7,6,6,2,2,7,7,0,0,3,3,1,1,0,0,4,4,0,0,6,6,1,1,2,2,1,1,2,2,0,0,0,0,1,1,1,1,4,4,2,2,3,3,5,5,4,4,6,6,1,1,0,0,3,3,3,3,4,4,6,6,0,0,2,2,5,5,5,5,3,3,6,6,4,4,6,6,2,2,5,5,1,1,2,2,5,5,2,2,5,5,2,2,7,7,0,0,5,5,7,7,1,1,5,5,6,6,1,1,5,5,0,0,5,5,1,1,5,5,7,7,3,3,6,6,2,2,0,0,0,0,0,0,6,6,4,4,5,5,4,4,2,2,2,2,3,3,1,1,2,2,6,6,5,5,7,7,1,1,6,6,7,7,0,0,5,5,2,2,0,0,1,1,6,6,2,2,0,0,0,0,4,4,5,5,6,6,1,1,4,4,5,5,3,3,4,4,6,6,6,6,0,0,7,7,0,0,7,7,5,5,7,7,0,0,1,1,0,0,1,1,5,5,3,3,3,3,7,7,0,0,4,4,1,1,2,2,5,5,3,3,4,4,1,1,3,3,1,1,4,4,4,4,1,1,0,0,0,0,0,0,2,2,2,2,3,3,5,5,6,6,3,3,5,5,7,7,2,2,7,7,1,1,1,1,3,3,3,3,5,5,6,6,7,7,1,1,1,1,7,7,0,0,0,0,2,2,4,4,3,3,1,1,0,0,2,2,4,4,2,2,5,5,3,3,2,2,7,7,6,6,1,1,4,4,1,1,3,3,1,1,1,1,7,7,0,0,5,5,3,3,0,0,1,1,1,1,0,0,4,4,7,7,2,2,1,1,3,3,7,7,0,0,1,1,1,1,3,3,4,4,6,6,0,0,4,4,1,1,3,3,0,0,0,0,7,7,6,6,7,7,3,3,0,0,7,7,7,7,1,1,1,1,3,3,6,6,7,7,3,3,1,1,7,7,5,5,1,1,2,2,1,1,3,3,5,5,4,4,6,6,5,5,3,3,5,5,3,3,6,6,7,7,3,3,2,2,0,0,3,3,2,2,4,4,3,3,5,5,4,4,0,0,3,3,3,3,2,2,6,6,2,2,6,6,0,0,4,4,5,5,0,0,2,2,3,3,6,6,3,3,1,1,4,4,4,4,5,5,6,6,1,1,2,2,5,5,6,6,3,3,0,0,6,6,5,5,0,0,0,0,5,5,4,4,6,6,7,7,4,4,3,3,1,1,3,3,0,0,5,5,4,4,0,0,2,2,5,5,6,6,0,0,6,6,1,1,1,1,0,0,5,5,2,2,1,1,3,3,4,4,4,4,5,5,5,5,3,3,0,0,1,1,3,3,1,1,0,0,7,7,5,5,4,4,4,4,2,2,6,6,3,3,5,5,4,4,5,5,6,6,1,1,0,0,5,5,2,2,2,2,5,5,6,6,2,2,1,1,4,4,4,4,2,2,0,0,5,5,7,7,4,4,6,6,2,2,4,4,1,1,5,5,2,2,5,5,0,0,0,0,3,3,7,7,6,6,5,5,2,2,5,5,1,1,3,3,6,6,7,7,6,6,1,1,0,0,0,0,5,5,5,5,4,4,0,0,7,7,6,6,1,1,1,1,3,3,4,4,4,4,2,2,0,0,5,5,0,0,2,2,1,1,5,5,0,0,0,0,3,3,2,2,4,4,7,7,1,1,0,0,1,1,4,4,1,1,1,1,7,7,1,1,1,1,1,1,7,7,2,2,3,3,4,4,7,7,0,0,3,3,0,0,3,3,6,6,6,6,2,2,7,7,5,5,6,6,0,0,4,4,4,4,3,3,6,6,5,5,4,4,3,3,4,4,3,3,4,4,2,2,2,2,6,6,4,4,0,0,0,0,7,7,7,7,5,5,3,3,0,0,4,4,5,5,5,5,1,1,4,4,0,0,6,6,0,0,4,4,0,0,7,7,2,2,2,2,1,1,3,3,5,5,6,6,0,0,5,5,3,3,6,6,3,3,5,5,6,6,0,0,2,2,5,5,0,0,0,0,4,4,0,0,3,3,6,6,7,7,3,3,7,7,1,1,3,3,0,0,2,2,5,5,3,3,6,6,0,0,6,6,6,6,6,6,6,6,6,6,4,4,4,4,1,1,1,1,2,2,1,1,2,2,6,6,1,1,1,1,6,6,6,6,4,4,3,3,4,4,2,2,6,6,2,2,3,3,3,3,6,6,3,3,3,3,7,7,0,0,3,3,4,4,4,4,2,2,5,5,6,6,1,1,5,5,1,1,0,0,0,0,0,0,4,4,1,1,1,1,0,0,7,7,1,1,0,0,7,7,7,7,4,4,7,7,6,6,0,0,7,7,7,7,2,2,2,2,3,3,5,5,1,1,0,0,0,0,4,4,0,0,4,4,4,4,6,6,0,0,1,1,0,0,3,3,2,2,5,5,5,5,7,7,1,1,4,4,0,0,4,4,7,7,6,6,2,2,6,6,5,5,6,6,2,2,0,0,6,6,5,5,7,7,4,4,1,1,6,6,7,7,7,7,3,3,1,1,3,3,5,5,6,6,6,6,0,0,4,4,5,5,5,5,0,0,2,2,7,7,3,3,2,2,7,7,2,2,2,2,1,1,6,6,4,4,4,4,3,3,7,7,7,7,7,7,5,5,0,0,2,2,0,0,3,3,6,6,5,5,3,3,6,6,0,0,7,7,3,3,4,4,4,4,7,7,5,5,2,2,4,4,6,6,0,0,7,7,6,6,2,2,6,6,6,6,7,7,4,4,1,1,2,2,2,2,5,5,6,6,3,3,1,1,2,2,1,1,3,3,0,0,1,1,7,7,2,2,4,4,7,7,6,6,7,7,5,5,6,6,4,4,5,5,1,1,6,6,3,3,2,2,4,4,0,0,4,4,1,1,1,1,0,0,7,7,2,2,7,7,2,2,7,7,0,0,1,1,0,0,7,7,5,5,4,4,0,0,4,4,3,3,4,4,3,3,7,7,1,1,0,0,3,3,3,3,3,3,2,2,7,7,2,2,2,2,4,4,2,2,6,6,6,6,3,3,6,6,3,3,2,2,6,6,0,0,4,4,1,1,0,0,2,2,7,7,2,2,2,2,3,3,6,6,6,6,2,2,7,7,2,2,5,5,6,6,4,4,3,3,5,5,4,4,3,3,5,5,4,4,0,0,2,2,2,2,4,4,0,0,3,3,7,7,1,1,5,5,2,2,5,5,0,0,6,6,4,4,4,4,0,0,1,1,5,5,7,7,2,2,2,2,6,6,7,7,3,3,2,2,1,1,5,5,1,1,4,4,2,2,4,4,7,7,0,0,5,5,7,7,4,4,6,6,7,7,2,2,1,1,0,0,3,3,5,5,6,6,4,4,1,1,3,3,0,0,3,3,5,5,4,4,1,1,7,7,0,0,2,2,7,7,0,0,3,3,3,3,1,1,2,2,6,6,7,7,2,2,0,0,0,0,0,0,1,1,3,3,6,6,5,5,1,1,2,2,3,3,3,3,2,2,0,0,0,0,2,2,6,6,3,3,1,1,6,6,0,0,7,7,7,7,6,6,2,2,2,2,4,4,6,6,0,0,3,3,1,1,7,7,5,5,2,2,4,4,1,1,2,2,3,3,3,3,5,5,2,2,5,5,7,7,7,7,5,5,6,6,1,1,0,0,0,0,3,3,2,2,4,4,5,5,5,5,2,2,2,2,1,1,7,7,2,2,2,2,5,5,4,4,6,6,3,3,2,2,1,1,4,4,5,5,3,3,2,2,3,3,3,3,2,2,3,3,7,7,3,3,6,6,1,1,4,4,3,3,7,7,1,1,0,0,6,6,3,3,5,5,7,7,6,6,0,0,0,0,2,2,7,7,2,2,7,7,6,6,2,2,2,2,6,6,1,1,7,7,3,3,7,7,3,3,2,2,4,4,0,0,5,5,3,3,5,5,5,5,1,1,0,0,7,7,0,0,6,6,0,0,6,6,5,5,5,5,2,2,2,2,1,1,7,7,5,5,5,5,3,3,5,5,3,3,7,7,5,5,1,1,7,7,0,0,0,0,6,6,4,4,3,3,5,5,5,5,2,2,4,4,7,7,6,6,2,2,6,6,1,1,3,3,2,2,7,7,0,0,4,4,4,4,1,1,1,1,7,7,1,1,7,7,6,6,2,2,1,1,5,5,0,0,2,2,6,6,3,3,6,6,7,7,7,7,1,1,3,3,4,4,0,0,3,3,0,0,4,4,6,6,5,5,4,4,4,4,3,3,4,4,1,1,7,7,0,0,6,6,4,4,3,3,4,4,0,0,6,6,4,4,5,5,1,1,1,1,6,6,3,3,2,2,0,0,7,7,2,2,0,0,4,4,4,4,6,6,5,5,0,0,7,7,7,7,0,0,3,3,5,5,2,2,0,0,7,7,5,5,6,6,7,7,4,4,0,0,6,6,2,2,7,7,1,1,2,2,0,0,5,5,3,3,3,3,0,0,7,7,2,2,4,4,5,5,7,7,2,2,1,1,2,2,1,1,3,3,5,5,3,3,4,4,6,6,1,1,6,6,1,1,0,0,7,7,2,2,4,4,6,6,5,5,2,2,6,6,3,3,3,3,6,6,2,2,4,4,7,7,4,4,2,2,0,0,7,7,3,3,1,1,6,6,4,4,5,5,0,0,4,4,2,2,3,3,5,5,3,3,6,6,2,2,1,1,2,2,0,0,0,0,6,6,3,3,0,0,6,6,5,5,0,0,1,1,7,7,0,0,7,7,3,3,2,2,3,3,3,3,7,7,5,5,2,2,0,0,3,3,4,4,6,6,4,4,2,2,1,1,1,1,5,5,7,7,3,3,7,7,0,0,1,1,2,2,7,7,1,1,1,1,2,2,5,5,3,3,5,5,6,6,4,4,0,0,7,7,0,0,6,6,3,3,7,7,6,6,6,6,7,7,3,3,2,2,0,0,0,0,0,0,4,4,3,3,7,7,1,1,5,5,5,5,3,3,5,5,1,1,0,0,2,2,2,2,6,6,0,0,7,7,4,4,1,1,3,3,5,5,4,4,3,3,3,3,5,5,4,4,5,5,3,3,7,7,5,5,2,2,6,6,0,0,5,5,2,2,2,2,5,5,1,1,3,3,6,6,5,5,4,4,7,7,0,0,0,0,1,1,4,4,0,0,5,5,6,6,7,7,4,4,4,4,3,3,7,7,2,2,0,0,6,6,7,7,6,6,7,7,1,1,1,1,1,1,1,1,0,0,0,0,2,2,3,3,1,1,0,0,4,4,4,4,6,6,5,5,3,3,6,6,4,4,1,1,6,6,2,2,2,2,1,1,4,4,2,2,5,5,7,7,1,1,0,0,5,5,1,1,2,2,4,4,4,4,1,1,2,2,4,4,4,4,3,3,0,0,3,3,5,5,0,0,4,4,3,3,7,7,6,6,3,3,1,1,2,2,3,3,4,4,2,2,4,4,6,6,5,5,7,7,1,1,1,1,0,0,0,0,3,3,7,7,3,3,5,5,1,1,3,3,1,1,2,2,7,7,4,4,3,3,3,3,7,7,5,5,6,6,3,3,6,6,6,6,2,2,2,2,2,2,4,4,0,0,3,3,5,5,7,7,6,6,5,5,6,6,6,6,5,5,7,7,1,1,6,6,3,3,4,4,1,1,5,5,3,3,2,2,1,1,6,6,3,3,1,1,6,6,4,4,4,4,7,7,3,3,7,7,7,7,5,5,4,4,5,5,6,6,5,5,2,2,4,4,3,3,6,6,6,6,1,1,2,2,0,0,3,3,0,0,0,0,5,5,4,4,4,4,2,2,7,7,7,7,0,0,4,4,2,2,5,5,6,6,1,1,0,0,6,6,0,0,2,2,5,5,2,2,3,3,2,2,1,1,6,6,5,5,2,2,3,3,2,2,6,6,5,5,6,6,4,4,5,5,0,0,6,6,4,4,2,2,5,5,3,3,4,4,5,5,3,3,6,6,6,6,5,5,1,1,3,3,3,3,4,4,5,5,6,6,2,2,5,5,6,6,4,4,4,4,6,6,0,0,0,0,4,4,2,2,6,6,6,6,7,7,4,4,6,6,3,3,6,6,1,1,5,5,5,5,0,0,5,5,3,3,3,3,6,6,4,4,7,7,7,7,4,4,2,2,1,1,4,4,5,5,6,6,0,0,4,4,5,5,2,2,2,2,3,3,3,3,1,1,1,1,5,5,2,2,7,7,3,3,2,2,4,4,2,2,1,1,5,5,7,7,2,2,1,1,7,7,6,6,4,4,1,1,3,3,4,4,3,3,7,7,7,7,5,5,1,1,5,5,4,4,7,7,0,0,2,2,1,1,6,6,6,6,5,5,5,5,4,4,7,7,4,4,6,6,4,4,6,6,1,1,5,5,5,5,2,2,2,2,4,4,0,0,0,0,4,4,5,5,7,7,0,0,0,0,7,7,4,4,5,5,2,2,3,3,7,7,6,6,6,6,7,7,2,2,0,0,5,5,0,0,7,7,7,7,3,3,0,0,2,2,7,7,3,3,7,7,0,0,0,0,7,7,1,1,1,1,2,2,6,6,2,2,2,2,3,3,1,1,6,6,1,1,2,2,2,2,7,7,3,3,2,2,1,1,7,7,6,6,7,7,2,2,6,6,4,4,4,4,2,2,7,7,0,0,1,1,5,5,0,0,6,6,3,3,0,0,4,4,7,7,6,6,1,1,1,1,6,6,6,6,3,3,6,6,3,3,2,2,4,4,4,4,4,4,7,7,7,7,2,2,1,1,0,0,2,2,0,0,5,5,1,1,0,0,6,6,4,4,6,6,6,6,7,7,3,3,7,7,2,2,4,4,7,7,2,2,1,1,3,3,3,3,5,5,2,2,7,7,7,7,7,7,6,6,3,3,1,1,0,0,0,0,4,4,3,3,3,3,2,2,3,3,4,4,3,3,3,3,4,4,6,6,0,0,5,5,4,4,5,5,1,1,4,4,6,6,0,0,0,0,6,6,2,2,4,4,0,0,0,0,0,0,2,2,2,2,6,6,3,3,5,5,4,4,5,5,4,4,0,0,3,3,2,2,5,5,0,0,2,2,4,4,5,5,3,3,6,6,6,6,1,1,4,4,3,3,1,1,4,4,1,1,5,5,6,6,1,1,0,0,0,0,4,4,5,5,5,5,1,1,4,4,6,6,2,2,5,5,7,7,3,3,6,6,2,2,7,7,0,0,0,0,6,6,3,3,4,4,7,7,4,4,7,7,6,6,7,7,2,2,2,2,3,3,4,4,6,6,0,0,0,0,4,4,0,0,6,6,1,1,0,0,0,0,7,7,0,0,2,2,0,0,1,1,0,0,2,2,7,7,6,6,3,3,5,5,7,7,1,1,4,4,4,4,6,6,3,3,5,5,5,5,1,1,4,4,3,3,3,3,5,5,6,6,7,7,5,5,1,1,7,7,5,5,1,1,7,7,6,6,7,7,2,2,5,5,7,7,0,0,1,1,5,5,3,3,0,0,1,1,4,4,5,5,4,4,3,3,3,3,5,5,6,6,7,7,1,1,6,6,1,1,1,1,1,1,5,5,0,0,7,7,1,1,0,0,6,6,3,3,1,1,1,1,6,6,4,4,1,1,2,2,5,5,5,5,3,3,6,6,5,5,2,2,2,2,4,4,0,0,7,7,4,4,4,4,1,1,4,4,3,3,1,1,3,3,4,4,7,7,2,2,6,6,6,6,7,7,6,6,4,4,1,1,0,0,4,4,7,7,0,0,7,7,6,6,0,0,3,3,4,4,6,6,3,3,4,4,6,6,5,5,5,5,7,7,4,4,1,1,3,3,5,5,3,3,7,7,1,1,0,0,1,1,0,0,2,2,3,3,3,3,6,6,0,0,3,3,5,5,1,1,0,0,3,3,3,3,2,2,2,2,1,1,1,1,7,7,4,4,2,2,5,5,1,1,7,7,7,7,6,6,4,4,7,7,1,1,2,2,5,5,1,1,4,4,2,2,4,4,2,2,6,6,1,1,5,5,0,0,1,1,6,6,1,1,7,7,5,5,2,2,0,0,7,7,1,1,4,4,1,1,4,4,4,4,1,1,6,6,3,3,5,5,5,5,5,5,5,5,7,7,4,4,7,7,2,2,6,6,2,2,2,2,0,0,6,6,1,1,3,3,0,0,2,2,1,1,2,2,2,2,0,0,1,1,0,0,1,1,3,3,6,6,3,3,6,6,3,3,5,5,4,4,6,6,1,1,3,3,3,3,0,0,6,6,3,3,4,4,0,0,4,4,6,6,4,4,1,1,3,3,5,5,3,3,4,4,6,6,4,4,2,2,5,5,6,6,0,0,6,6,1,1,3,3,6,6,1,1,7,7,1,1,6,6,6,6,1,1,6,6,4,4,0,0,0,0,1,1,4,4,6,6,3,3,4,4,2,2,5,5,2,2,0,0,5,5,2,2,3,3,0,0,4,4,7,7,1,1,5,5,4,4,1,1,2,2,0,0,0,0,5,5,1,1,6,6,1,1,7,7,4,4,0,0,2,2,0,0,0,0,4,4,5,5,1,1,1,1,4,4,0,0,6,6,2,2,5,5,3,3,4,4,0,0,5,5,5,5,4,4,2,2,5,5,2,2,7,7,4,4,0,0,0,0,1,1,1,1,2,2,4,4,7,7,7,7,2,2,7,7,0,0,0,0,2,2,3,3,5,5,1,1,5,5,7,7,4,4,3,3,1,1,1,1,4,4,6,6,0,0,3,3,0,0,5,5,0,0,4,4,0,0,0,0,0,0,5,5,1,1,2,2,5,5,7,7,6,6,6,6,7,7,7,7,2,2,5,5,1,1,0,0,0,0,0,0,3,3,7,7,0,0,3,3,3,3,1,1,2,2,0,0,2,2,6,6,6,6,4,4,3,3,1,1,4,4,6,6,5,5,3,3,1,1,4,4,0,0,5,5,0,0,0,0,0,0,7,7,0,0,0,0,6,6,5,5,2,2,2,2,4,4,1,1,7,7,3,3,4,4,5,5,3,3,6,6,4,4,7,7,2,2,5,5,2,2,4,4,1,1,1,1,2,2,3,3,4,4,2,2,6,6,2,2,3,3,1,1,4,4,7,7,7,7,4,4,2,2,3,3,1,1,0,0,7,7,0,0,6,6,2,2,1,1,5,5,4,4,5,5,3,3,0,0,6,6,5,5,6,6,7,7,0,0,5,5,2,2,3,3,1,1,3,3,6,6,0,0,5,5,1,1,3,3,6,6,4,4,4,4,2,2,4,4,5,5,7,7,0,0,2,2,0,0,4,4,3,3,5,5,2,2,3,3,6,6,2,2,0,0,6,6,3,3,5,5,5,5,7,7,6,6,6,6,3,3,2,2,7,7,3,3,7,7,1,1,3,3,2,2,4,4,1,1,6,6,4,4,2,2,0,0,6,6,3,3,6,6,7,7,6,6,5,5,1,1,0,0,3,3,3,3,6,6,5,5,3,3,7,7,1,1,5,5,7,7,2,2,4,4,3,3,3,3,4,4,5,5,5,5,2,2,2,2,2,2,4,4,4,4,2,2,6,6,5,5,1,1,3,3,4,4,1,1,4,4,2,2,6,6,7,7,0,0,3,3,1,1,1,1,0,0,5,5,3,3,6,6,1,1,2,2,2,2,7,7,1,1,2,2,4,4,7,7,6,6,6,6,6,6,3,3,3,3,2,2,1,1,3,3,7,7,1,1,2,2,1,1,0,0,1,1,3,3,0,0,6,6,3,3,5,5,2,2,0,0,2,2,7,7,4,4,0,0,0,0,1,1,0,0,6,6,3,3,6,6,0,0,3,3,1,1,2,2,1,1,0,0,2,2,5,5,4,4,1,1,2,2,0,0,3,3,0,0,6,6,6,6,2,2,6,6,1,1,4,4,3,3,2,2,6,6,1,1,0,0,3,3,4,4,5,5,3,3,1,1,1,1,7,7,6,6,6,6,4,4,7,7,2,2,6,6,7,7,0,0,5,5,2,2,1,1,5,5,6,6,5,5,0,0,5,5,3,3,7,7,3,3,0,0,0,0,5,5,5,5,3,3,3,3,5,5,6,6,1,1,0,0,3,3,6,6,6,6,0,0,2,2,2,2,2,2,1,1,7,7,3,3,5,5,5,5,7,7,3,3,5,5,4,4,7,7,4,4,0,0,0,0,1,1,7,7,2,2,7,7,4,4,6,6,2,2,4,4,3,3,2,2,5,5,1,1,4,4,0,0,3,3,7,7,4,4,2,2,1,1,4,4,5,5,0,0,6,6,3,3,2,2,6,6,2,2,2,2,6,6,4,4,5,5,3,3,3,3,0,0,2,2,0,0,4,4,6,6,1,1,0,0,5,5,2,2,3,3,0,0,0,0,2,2,0,0,0,0,7,7,4,4,2,2,6,6,1,1,4,4,1,1,4,4,1,1,6,6,1,1,0,0,7,7,1,1,4,4,3,3,4,4,6,6,4,4,2,2,5,5,5,5,2,2,6,6,4,4,3,3,1,1,1,1,6,6,2,2,0,0,5,5,4,4,3,3,6,6,1,1,1,1,4,4,5,5,6,6,0,0,4,4,0,0,6,6,0,0,0,0,4,4,4,4,5,5,5,5,4,4,5,5,5,5,6,6,1,1,4,4,5,5,6,6,3,3,2,2,4,4,2,2,1,1,3,3,3,3,2,2,3,3,4,4,7,7,6,6,7,7,4,4,6,6,6,6,1,1,1,1,2,2,4,4,2,2,3,3,2,2,0,0,7,7,0,0,5,5,4,4,4,4,0,0,6,6,0,0,7,7,0,0,7,7,6,6,3,3,5,5,0,0,3,3,1,1,1,1,3,3,1,1,4,4,6,6,4,4,3,3,2,2,4,4,1,1,1,1,1,1,6,6,2,2,0,0,1,1,4,4,7,7,3,3,6,6,4,4,2,2,2,2,2,2,6,6,4,4,2,2,4,4,3,3,4,4,1,1,6,6,6,6,1,1,3,3,4,4,2,2,0,0,2,2,1,1,6,6,2,2,6,6,2,2,4,4,2,2,1,1,6,6,4,4,0,0,3,3,1,1,1,1,0,0,6,6,7,7,1,1,4,4,4,4,5,5,1,1,3,3,6,6,3,3,1,1,1,1,2,2,2,2,0,0,0,0,6,6,7,7,0,0,5,5,2,2,1,1,7,7,4,4,2,2,2,2,0,0,2,2,6,6,0,0,6,6,7,7,5,5,3,3,6,6,7,7,2,2,4,4,3,3,7,7,6,6,6,6,1,1,4,4,2,2,6,6,6,6,7,7,3,3,2,2,2,2,4,4,4,4,5,5,1,1,5,5,6,6,2,2,5,5,7,7,2,2,3,3,6,6,7,7,6,6,2,2,7,7,3,3,6,6,0,0,5,5,4,4,3,3,3,3,4,4,0,0,2,2,3,3,6,6,0,0,1,1,7,7,0,0,0,0,7,7,7,7,2,2,6,6,7,7,2,2,1,1,7,7,0,0,2,2,4,4,4,4,1,1,6,6,3,3,0,0,3,3,6,6,7,7,3,3,0,0,6,6,4,4,6,6,1,1,0,0,4,4,0,0,7,7,5,5,5,5,0,0,2,2,1,1,1,1,0,0,0,0,4,4,0,0,7,7,7,7,6,6,6,6,7,7,1,1,2,2,2,2,6,6,4,4,3,3,3,3,4,4,1,1,0,0,1,1,7,7,5,5,2,2,5,5,6,6,1,1,3,3,6,6,0,0,4,4,0,0,5,5,3,3,4,4,2,2,7,7,7,7,7,7,4,4,5,5,4,4,4,4,7,7,3,3,1,1,4,4,7,7,1,1,2,2,3,3,4,4,5,5,2,2,3,3,1,1,3,3,7,7,4,4,4,4,0,0,2,2,2,2,7,7,4,4,0,0,7,7,1,1,1,1,2,2,6,6,5,5,4,4,6,6,7,7,0,0,3,3,6,6,0,0,6,6,5,5,2,2,6,6,7,7,3,3,3,3,4,4,1,1,0,0,3,3,0,0,7,7,3,3,6,6,1,1,7,7,7,7,5,5,5,5,6,6,2,2,5,5,1,1,5,5,2,2,2,2,2,2,7,7,2,2,5,5,6,6,7,7,0,0,0,0,5,5,7,7,6,6,7,7,0,0,3,3,2,2,2,2,3,3,1,1,2,2,1,1,6,6,0,0,7,7,6,6,0,0,4,4,5,5,0,0,6,6,7,7,6,6,0,0,2,2,4,4,0,0,7,7,4,4,2,2,4,4,2,2,4,4,1,1,7,7,4,4,6,6,5,5,3,3,4,4,1,1,3,3,6,6,4,4,5,5,5,5,0,0,3,3,3,3,7,7,5,5,3,3,3,3,1,1,0,0,2,2,2,2,2,2,7,7,0,0,3,3,5,5,4,4,3,3,6,6,1,1,4,4,2,2,5,5,2,2,7,7,3,3,6,6,5,5,7,7,7,7,0,0,5,5,7,7,5,5,1,1,5,5,1,1,5,5,3,3,0,0,5,5,6,6,6,6,5,5,2,2,3,3,2,2,2,2,0,0,6,6,2,2,4,4,0,0,5,5,7,7,2,2,0,0,3,3,2,2,4,4,4,4,2,2,1,1,6,6,1,1,6,6,6,6,0,0,4,4,3,3,7,7,7,7,1,1,0,0,3,3,7,7,5,5,0,0,0,0,1,1,6,6,0,0,1,1,2,2,6,6,1,1,3,3,4,4,5,5,5,5,1,1,1,1,4,4,2,2,3,3,3,3,3,3,0,0,1,1,4,4,0,0,6,6,3,3,7,7,6,6,2,2,7,7,0,0,5,5,6,6,2,2,2,2,4,4,1,1,3,3,7,7,6,6,3,3,3,3,0,0,3,3,1,1,5,5,3,3,2,2,1,1,4,4,1,1,5,5,0,0,1,1,1,1,0,0,5,5,3,3,3,3,7,7,4,4,3,3,7,7,1,1,5,5,0,0,6,6,1,1,1,1,7,7,2,2,3,3,6,6,2,2,1,1,0,0,6,6,5,5,5,5,5,5,4,4,0,0,5,5,4,4,6,6,1,1,6,6,0,0,0,0,5,5,7,7,5,5,7,7,6,6,2,2,4,4,5,5,1,1,4,4,3,3,5,5,0,0,7,7,5,5,1,1,0,0,0,0,3,3,7,7,2,2,0,0,2,2,0,0,6,6,5,5,5,5,2,2,0,0,2,2,1,1,4,4,2,2,0,0,1,1,7,7,5,5,4,4,1,1,2,2,3,3,6,6,2,2,1,1,5,5,4,4,3,3,3,3,7,7,2,2,7,7,5,5,7,7,0,0,7,7,4,4,7,7,6,6,4,4,2,2,1,1,4,4,1,1,2,2,1,1,0,0,0,0,7,7,6,6,4,4,7,7,3,3,5,5,2,2,4,4,6,6,2,2,6,6,4,4,4,4,0,0,2,2,4,4,3,3,4,4,2,2,4,4,0,0,2,2,6,6,3,3,7,7,7,7,6,6,4,4,5,5,0,0,0,0,4,4,0,0,5,5,6,6,1,1,4,4,3,3,4,4,7,7,2,2,2,2,7,7,0,0,4,4,3,3,4,4,7,7,6,6,1,1,6,6,2,2,3,3,3,3,5,5,6,6,4,4,2,2,2,2,4,4,7,7,1,1,0,0,3,3,6,6,3,3,5,5,6,6,6,6,0,0,0,0,0,0,0,0,6,6,6,6,5,5,6,6,0,0,6,6,0,0,3,3,1,1,5,5,6,6,4,4,1,1,7,7,0,0,7,7,1,1,2,2,6,6,6,6,3,3,0,0,7,7,0,0,6,6,3,3,4,4,5,5,5,5,6,6,7,7,2,2,7,7,7,7,1,1,0,0,2,2,5,5,2,2,4,4,0,0,3,3,6,6,4,4,6,6,5,5,0,0,2,2,2,2,7,7,1,1,7,7,3,3,1,1,1,1,0,0,0,0,7,7,1,1,0,0,6,6,4,4,1,1,0,0,7,7,4,4,0,0,0,0,3,3,1,1,5,5,0,0,1,1,2,2,2,2,2,2,3,3,6,6,2,2,0,0,4,4,7,7,2,2,4,4,2,2,1,1,5,5,2,2,0,0,0,0,1,1,3,3,1,1,5,5,4,4,3,3,7,7,3,3,1,1,3,3,6,6,0,0,6,6,0,0,6,6,3,3,6,6,7,7,2,2,3,3,0,0,2,2,3,3,1,1,1,1,2,2,7,7,3,3,2,2,0,0,6,6,2,2,5,5,4,4,5,5,6,6,7,7,2,2,6,6,4,4,1,1,1,1,1,1,6,6,0,0,5,5,7,7,4,4,4,4,2,2,1,1,2,2,2,2,5,5,2,2,1,1,5,5,6,6,5,5,0,0,5,5,1,1,6,6,0,0,7,7,7,7,7,7,0,0,6,6,2,2,1,1,4,4,7,7,7,7,2,2,2,2,6,6,7,7,7,7,1,1,4,4,3,3,2,2,1,1,2,2,0,0,4,4,7,7,1,1,3,3,2,2,6,6,5,5,0,0,2,2,7,7,7,7,6,6,2,2,7,7,4,4,0,0,6,6,5,5,3,3,1,1,2,2,6,6,0,0,1,1,1,1,6,6,3,3,1,1,1,1,3,3,7,7,0,0,1,1,4,4,7,7,4,4,1,1,2,2,0,0,4,4,5,5,4,4,2,2,3,3,7,7,5,5,0,0,0,0,6,6,5,5,5,5,4,4,6,6,1,1,3,3,2,2,3,3,6,6,3,3,7,7,4,4,1,1,6,6,3,3,2,2,7,7,5,5,1,1,1,1,7,7,4,4,5,5,1,1,5,5,6,6,7,7,4,4,1,1,1,1,4,4,0,0,1,1,6,6,7,7,6,6,5,5,6,6,1,1,4,4,0,0,4,4,2,2,3,3,4,4,1,1,3,3,5,5,5,5,6,6,6,6,0,0,2,2,1,1,6,6,5,5,3,3,5,5,1,1,0,0,4,4,1,1,1,1,2,2,6,6,2,2,0,0,6,6,0,0,7,7,6,6,5,5,7,7,3,3,4,4,0,0,0,0,2,2,2,2,6,6,0,0,0,0,0,0,2,2,1,1,5,5,4,4,3,3,3,3,0,0,2,2,2,2,4,4,4,4,2,2,4,4,4,4,7,7,1,1,1,1,2,2,3,3,0,0,5,5,4,4,0,0,5,5,0,0,2,2,1,1,0,0,1,1,5,5,5,5,2,2,3,3,6,6,6,6,4,4,0,0,2,2,0,0,2,2,2,2,7,7,0,0,2,2,6,6,1,1,1,1,7,7,1,1,1,1,4,4,0,0,4,4,3,3,1,1,3,3,1,1,4,4,2,2,2,2,5,5,5,5,0,0,0,0,5,5,4,4,6,6,4,4,3,3,4,4,6,6,0,0,1,1,3,3,6,6,4,4,1,1,1,1,1,1,2,2,4,4,7,7,1,1,3,3,0,0,4,4,5,5,5,5,2,2,3,3,6,6,2,2,3,3,2,2,2,2,5,5,1,1,7,7,0,0,2,2,7,7,4,4,5,5,7,7,3,3,6,6,1,1,3,3,1,1,4,4,3,3,3,3,4,4,4,4,4,4,4,4,0,0,4,4,1,1,4,4,2,2,1,1,1,1,0,0,0,0,6,6,1,1,3,3,7,7,2,2,4,4,1,1,2,2,6,6,2,2,2,2,2,2,3,3,2,2,7,7,1,1,5,5,1,1,2,2,0,0,6,6,1,1,3,3,4,4,3,3,1,1,4,4,1,1,2,2,5,5,1,1,3,3,0,0,3,3,4,4,5,5,3,3,2,2,7,7,6,6,7,7,4,4,7,7,1,1,0,0,5,5,2,2,3,3,1,1,4,4,4,4,2,2,2,2,0,0,5,5,0,0,7,7,0,0,7,7,6,6,6,6,3,3,1,1,5,5,6,6,5,5,3,3,0,0,1,1,3,3,2,2,2,2,7,7,0,0,5,5,5,5,1,1,4,4,1,1,7,7,7,7,7,7,5,5,1,1,5,5,4,4,1,1,0,0,3,3,3,3,2,2,2,2,2,2,3,3,2,2,3,3,1,1,5,5,2,2,1,1,3,3,6,6,1,1,1,1,4,4,3,3,3,3,4,4,5,5,7,7,6,6,7,7,4,4,4,4,6,6,3,3,6,6,0,0,6,6,1,1,2,2,2,2,2,2,5,5,0,0,7,7,0,0,4,4,0,0,3,3,0,0,1,1,7,7,6,6,5,5,7,7,4,4,3,3,6,6,5,5,0,0,0,0,0,0,0,0,3,3,4,4,4,4,5,5,4,4,1,1,4,4,1,1,0,0,7,7,3,3,6,6,3,3,1,1,4,4,0,0,1,1,0,0,2,2,5,5,5,5,2,2,4,4,7,7,3,3,1,1,4,4,6,6,1,1,6,6,5,5,0,0,2,2,4,4,2,2,0,0,5,5,4,4,3,3,2,2,2,2,2,2,0,0,1,1,7,7,2,2,7,7,0,0,4,4,5,5,4,4,0,0,3,3,4,4,1,1,5,5,2,2,2,2,7,7,6,6,0,0,3,3,7,7,4,4,3,3,5,5,1,1,5,5,2,2,2,2,6,6,4,4,0,0,0,0,3,3,0,0,4,4,4,4,3,3,2,2,5,5,7,7,4,4,4,4,6,6,5,5,6,6,1,1,0,0,4,4,4,4,4,4,5,5,6,6,2,2,0,0,7,7,6,6,5,5,2,2,5,5,5,5,3,3,1,1,7,7,0,0,1,1,4,4,7,7,0,0,3,3,4,4,6,6,2,2,4,4,1,1,5,5,5,5,0,0,3,3,5,5,0,0,1,1,3,3,3,3,5,5,5,5,7,7,3,3,6,6,6,6,5,5,5,5,4,4,3,3,5,5,2,2,6,6,7,7,2,2,3,3,0,0,6,6,7,7,2,2,6,6,3,3,2,2,4,4,4,4,5,5,7,7,4,4,0,0,2,2,6,6,6,6,1,1,1,1,0,0,2,2,7,7,1,1,7,7,1,1,2,2,7,7,0,0,4,4,6,6,0,0,5,5,7,7,5,5,2,2,5,5,0,0,0,0,4,4,4,4,2,2,4,4,7,7,1,1,0,0,0,0,6,6,2,2,5,5,7,7,5,5,1,1,3,3,5,5,5,5,5,5,1,1,1,1,2,2,3,3,2,2,6,6,7,7,6,6,1,1,6,6,5,5,2,2,3,3,4,4,6,6,6,6,7,7,7,7,0,0,0,0,5,5,7,7,7,7,0,0,1,1,6,6,2,2,7,7,4,4,7,7,6,6,6,6,2,2,2,2,3,3,1,1,2,2,0,0,6,6,7,7,4,4,5,5,1,1,2,2,2,2,5,5,1,1,3,3,4,4,1,1,5,5,6,6,4,4,6,6,7,7,0,0,0,0,0,0,4,4,6,6,0,0,4,4,2,2,3,3,2,2,2,2,4,4,4,4,5,5,2,2,6,6,4,4,2,2,7,7,0,0,1,1,0,0,6,6,0,0,0,0,4,4,6,6,4,4,6,6,6,6,1,1,0,0,4,4,1,1,3,3,6,6,6,6,2,2,0,0,5,5,1,1,6,6,2,2,0,0,6,6,7,7,1,1,6,6,0,0,2,2,0,0,2,2,7,7,1,1,0,0,3,3,7,7,5,5,1,1,3,3,0,0,7,7,1,1,7,7,1,1,5,5,0,0,1,1,3,3,0,0,7,7,6,6,3,3,7,7,0,0,6,6,4,4,1,1,6,6,2,2,5,5,5,5,2,2,0,0,6,6,3,3,2,2,2,2,6,6,5,5,1,1,6,6,5,5,2,2,0,0,6,6,0,0,7,7,5,5,0,0,0,0,2,2,1,1,7,7,6,6,4,4,0,0,6,6,4,4,1,1,5,5,1,1,5,5,6,6,3,3,0,0,0,0,4,4,4,4,2,2,0,0,3,3,7,7,6,6,1,1,0,0,3,3,6,6,6,6,3,3,4,4,0,0,6,6,5,5,5,5,6,6,2,2,7,7,7,7,6,6,3,3,2,2,2,2,1,1,6,6,0,0,2,2,3,3,6,6,2,2,6,6,3,3,0,0,0,0,4,4,0,0,0,0,5,5,1,1,4,4,1,1,5,5,5,5,6,6,5,5,7,7,1,1,3,3,2,2,5,5,7,7,2,2,0,0,7,7,7,7,7,7,5,5,0,0,0,0,0,0,3,3,5,5,5,5,5,5,1,1,4,4,1,1,7,7,4,4,0,0,3,3,7,7,0,0,5,5,6,6,7,7,5,5,1,1,3,3,3,3,1,1,6,6,7,7,1,1,4,4,3,3,3,3,2,2,4,4,5,5,1,1,5,5,0,0,6,6,3,3,2,2,0,0,4,4,0,0,6,6,4,4,1,1,5,5,0,0,0,0,7,7,0,0,5,5,3,3,6,6,2,2,1,1,6,6,1,1,6,6,7,7,3,3,2,2,1,1,7,7,0,0,5,5,2,2,1,1,3,3,5,5,4,4,4,4,3,3,3,3,0,0,6,6,2,2,1,1,1,1,1,1,2,2,6,6,1,1,4,4,6,6,5,5,1,1,2,2,7,7,1,1,3,3,7,7,2,2,2,2,7,7,4,4,2,2,7,7,1,1,5,5,3,3,0,0,5,5,5,5,0,0,0,0,7,7,5,5,0,0,3,3,7,7,4,4,1,1,6,6,2,2,3,3,6,6,1,1,2,2,7,7,0,0,4,4,1,1,1,1,3,3,2,2,3,3,2,2,7,7,3,3,1,1,7,7,6,6,1,1,7,7,6,6,2,2,4,4,0,0,6,6,1,1,3,3,2,2,3,3,2,2,3,3,0,0,3,3,6,6,2,2,7,7,0,0,7,7,5,5,7,7,3,3,0,0,5,5,4,4,4,4,5,5,4,4,1,1,6,6,5,5,3,3,1,1,4,4,1,1,2,2,5,5,4,4,2,2,5,5,1,1,1,1,7,7,6,6,5,5,0,0,7,7,3,3,2,2,3,3,3,3,3,3,2,2,1,1,1,1,6,6,2,2,3,3,3,3,6,6,6,6,6,6,3,3,0,0,0,0,1,1,6,6,0,0,4,4,0,0,6,6,7,7,0,0,3,3,1,1,0,0,3,3,1,1,2,2,4,4,2,2,3,3,7,7,5,5,0,0,1,1,0,0,1,1,5,5,0,0,0,0,4,4,2,2,5,5,4,4,5,5,2,2,3,3,0,0,7,7,5,5,1,1,6,6,0,0,1,1,0,0,2,2,6,6,1,1,0,0,4,4,2,2,5,5,5,5,1,1,1,1,0,0,7,7,7,7,4,4,3,3,7,7,3,3,4,4,7,7,7,7,4,4,5,5,6,6,3,3,6,6,1,1,0,0,6,6,1,1,7,7,0,0,5,5,6,6,4,4,6,6,7,7,1,1,5,5,2,2,0,0,0,0,4,4,5,5,7,7,4,4,5,5,0,0,2,2,7,7,4,4,4,4,0,0,4,4,4,4,6,6,4,4,5,5,0,0,7,7,0,0,1,1,6,6,1,1,4,4,0,0,4,4,0,0,5,5,4,4,6,6,2,2,4,4,0,0,0,0,4,4,1,1,3,3,1,1,0,0,1,1,1,1,5,5,4,4,6,6,1,1,7,7,0,0,3,3,1,1,6,6,6,6,3,3,5,5,7,7,5,5,0,0,5,5,6,6,0,0,6,6,3,3,3,3,4,4,0,0,0,0,2,2,7,7,5,5,7,7,4,4,2,2,4,4,3,3,7,7,6,6,7,7,1,1,4,4,7,7,5,5,1,1,6,6,2,2,7,7,5,5,6,6,7,7,5,5,2,2,0,0,7,7,2,2,2,2,5,5,3,3,1,1,0,0,2,2,4,4,6,6,2,2,1,1,7,7,0,0,6,6,5,5,4,4,1,1,5,5,1,1,1,1,1,1,0,0,3,3,2,2,6,6,2,2,1,1,4,4,7,7,2,2,4,4,6,6,1,1,1,1,5,5,3,3,7,7,0,0,4,4,4,4,5,5,0,0,0,0,6,6,5,5,7,7,0,0,5,5,3,3,7,7,7,7,1,1,5,5,6,6,1,1,1,1,4,4,2,2,3,3,4,4,1,1,6,6,1,1,3,3,2,2,4,4,0,0,7,7,5,5,4,4,0,0,2,2,0,0,3,3,6,6,7,7,2,2,0,0,4,4,4,4,4,4,0,0,0,0,1,1,2,2,6,6,2,2,7,7,6,6,2,2,4,4,3,3,7,7,5,5,4,4,1,1,2,2,6,6,2,2,0,0,6,6,0,0,0,0,6,6,6,6,4,4,0,0,1,1,1,1,6,6,5,5,5,5,7,7,6,6,6,6,5,5,2,2,3,3,0,0,3,3,6,6,2,2,2,2,1,1,3,3,0,0,4,4,5,5,2,2,5,5,6,6,4,4,5,5,2,2,2,2,7,7,4,4,5,5,0,0,1,1,2,2,1,1,6,6,4,4,1,1,5,5,2,2,7,7,3,3,0,0,7,7,6,6,5,5,0,0,6,6,0,0,6,6,2,2,4,4,4,4,6,6,7,7,0,0,1,1,0,0,4,4,7,7,5,5,0,0,6,6,0,0,6,6,2,2,2,2,0,0,2,2,0,0,1,1,2,2,5,5,3,3,0,0,5,5,2,2,2,2,1,1,5,5,5,5,2,2,1,1,5,5,5,5,2,2,6,6,3,3,2,2,2,2,1,1,2,2,6,6,2,2,4,4,1,1,3,3,7,7,4,4,3,3,6,6,2,2,7,7,0,0,3,3,4,4,2,2,4,4,4,4,2,2,5,5,1,1,5,5,7,7,1,1,3,3,0,0,2,2,0,0,6,6,5,5,6,6,7,7,0,0,4,4,0,0,3,3,0,0,4,4,5,5,4,4,1,1,1,1,5,5,6,6,4,4,0,0,4,4,5,5,3,3,0,0,2,2,3,3,6,6,6,6,0,0,7,7,5,5,6,6,2,2,1,1,5,5,6,6,6,6,3,3,5,5,6,6,7,7,5,5,0,0,0,0,6,6,5,5,1,1,3,3,0,0,0,0,1,1,2,2,5,5,6,6,5,5,0,0,0,0,7,7,7,7,7,7,7,7,0,0,7,7,3,3,7,7,1,1,0,0,6,6,2,2,1,1,3,3,6,6,0,0,0,0,3,3,4,4,5,5,3,3,6,6,1,1,3,3,1,1,6,6,7,7,7,7,5,5,6,6,4,4,2,2,2,2,1,1,7,7,4,4,7,7,5,5,1,1,0,0,5,5,5,5,2,2,1,1,7,7,3,3,6,6,6,6,3,3,6,6,3,3,4,4,5,5,3,3,2,2,5,5,7,7,2,2,4,4,2,2,6,6,0,0,0,0,6,6,1,1,5,5,4,4,4,4,2,2,4,4,0,0,6,6,1,1,2,2,5,5,4,4,5,5,0,0,7,7,0,0,6,6,2,2,6,6,4,4,7,7,0,0,7,7,7,7,4,4,0,0,0,0,4,4,3,3,1,1,1,1,6,6,1,1,5,5,1,1,1,1,3,3,7,7,6,6,4,4,1,1,3,3,0,0,1,1,6,6,1,1,5,5,1,1,0,0,1,1,5,5,1,1,4,4,7,7,0,0,0,0,1,1,3,3,0,0,6,6,6,6,3,3,0,0,7,7,7,7,7,7,3,3,1,1,2,2,5,5,5,5,6,6,7,7,7,7,2,2,0,0,0,0,1,1,0,0,0,0,5,5,4,4,7,7,4,4,0,0,0,0,1,1,4,4,0,0,1,1,4,4,0,0,3,3,4,4,0,0,4,4,5,5,0,0,3,3,4,4,0,0,3,3,0,0,0,0,6,6,1,1,1,1,1,1,4,4,0,0,5,5,4,4,7,7,2,2,0,0,3,3,0,0,4,4,6,6,4,4,2,2,4,4,1,1,4,4,1,1,2,2,6,6,1,1,3,3,2,2,3,3,2,2,5,5,7,7,0,0,0,0,3,3,5,5,4,4,3,3,4,4,5,5,6,6,2,2,7,7,3,3,0,0,4,4,6,6,2,2,4,4,0,0,0,0,4,4,1,1,6,6,2,2,1,1,2,2,4,4,7,7,2,2,5,5,6,6,0,0,0,0,2,2,6,6,3,3,0,0,7,7,6,6,5,5,4,4,6,6,0,0,5,5,0,0,2,2,2,2,0,0,6,6,4,4,4,4,7,7,3,3,5,5,4,4,2,2,5,5,6,6,4,4,4,4,6,6,4,4,2,2,4,4,5,5,0,0,6,6,3,3,6,6,6,6,4,4,3,3,4,4,3,3,3,3,0,0,5,5,7,7,7,7,6,6,6,6,7,7,4,4,6,6,7,7,2,2,6,6,7,7,2,2,4,4,7,7,5,5,3,3,1,1,0,0,2,2,4,4,4,4,3,3,3,3,3,3,4,4,6,6,4,4,2,2,2,2,0,0,5,5,4,4,7,7,7,7,3,3,7,7,0,0,3,3,7,7,1,1,1,1,2,2,0,0,0,0,4,4,6,6,0,0,6,6,5,5,5,5,6,6,2,2,3,3,2,2,5,5,3,3,5,5,5,5,1,1,1,1,2,2,7,7,0,0,4,4,6,6,6,6,7,7,2,2,3,3,0,0,5,5,0,0,7,7,2,2,2,2,3,3,2,2,5,5,0,0,0,0,1,1,3,3,3,3,7,7,6,6,5,5,1,1,3,3,0,0,1,1,6,6,5,5,2,2,3,3,4,4,3,3,2,2,4,4,3,3,4,4,0,0,5,5,1,1,0,0,3,3,4,4,1,1,5,5,1,1,7,7,5,5,7,7,5,5,3,3,5,5,2,2,6,6,0,0,2,2,6,6,2,2,2,2,4,4,1,1,0,0,6,6,6,6,1,1,2,2,4,4,6,6,1,1,2,2,0,0,7,7,2,2,7,7,2,2,1,1,0,0,0,0,4,4,0,0,2,2,1,1,4,4,1,1,4,4,5,5,0,0,3,3,4,4,0,0,3,3,3,3,7,7,2,2,0,0,3,3,1,1,7,7,5,5,3,3,0,0,5,5,5,5,5,5,6,6,6,6,5,5,3,3,7,7,1,1,0,0,6,6,3,3,6,6,6,6,6,6,5,5,0,0,4,4,5,5,5,5,6,6,1,1,4,4,2,2,5,5,1,1,6,6,1,1,7,7,0,0,1,1,3,3,5,5,2,2,1,1,0,0,1,1,3,3,0,0,4,4,4,4,5,5,0,0,3,3,3,3,5,5,2,2,2,2,0,0,1,1,5,5,5,5,3,3,5,5,7,7,0,0,1,1,2,2,3,3,4,4,3,3,5,5,2,2,7,7,7,7,4,4,1,1,7,7,4,4,7,7,1,1,2,2,5,5,7,7,1,1,4,4,6,6,3,3,3,3,2,2,5,5,5,5,1,1,5,5,5,5,1,1,1,1,1,1,2,2,6,6,0,0,0,0,1,1,4,4,5,5,6,6,2,2,0,0,6,6,4,4,1,1,6,6,6,6,0,0,2,2,7,7,5,5,5,5,6,6,4,4,7,7,6,6,6,6,0,0,6,6,6,6,4,4,3,3,4,4,2,2,3,3,4,4,5,5,6,6,6,6,2,2,0,0,6,6,2,2,3,3,3,3,5,5,3,3,5,5,7,7,6,6,6,6,2,2,3,3,3,3,6,6,2,2,0,0,3,3,0,0,0,0,4,4,1,1,5,5,0,0,5,5,2,2,5,5,4,4,5,5,4,4,2,2,5,5,1,1,5,5,5,5,2,2,5,5,1,1,2,2,2,2,6,6,5,5,4,4,4,4,5,5,1,1,5,5,6,6,0,0,1,1,3,3,2,2,6,6,7,7,6,6,0,0,4,4,2,2,4,4,7,7,7,7,5,5,6,6,7,7,6,6,1,1,0,0,5,5,4,4,6,6,0,0,5,5,4,4,0,0,5,5,3,3,0,0,6,6,4,4,7,7,0,0,6,6,6,6,6,6,4,4,2,2,4,4,5,5,7,7,1,1,2,2,2,2,4,4,1,1,2,2,1,1,5,5,5,5,6,6,2,2,6,6,3,3,2,2,2,2,2,2,7,7,3,3,4,4,4,4,2,2,3,3,4,4,2,2,0,0,4,4,2,2,0,0,4,4,6,6,1,1,7,7,3,3,6,6,4,4,3,3,6,6,5,5,0,0,7,7,0,0,0,0,7,7,3,3,2,2,7,7,0,0,7,7,7,7,7,7,2,2,0,0,0,0,7,7,5,5,3,3,2,2,4,4,6,6,7,7,5,5,4,4,6,6,4,4,5,5,1,1,3,3,0,0,6,6,1,1,7,7,7,7,5,5,4,4,2,2,7,7,5,5,3,3,7,7,2,2,0,0,0,0,4,4,3,3,1,1,1,1,0,0,1,1,1,1,2,2,3,3,3,3,0,0,0,0,0,0,2,2,0,0,1,1,0,0,7,7,1,1,3,3,1,1,1,1,3,3,6,6,2,2,4,4,4,4,2,2,3,3,4,4,1,1,0,0,0,0,5,5,7,7,0,0,6,6,4,4,0,0,7,7,7,7,2,2,0,0,7,7,3,3,4,4,1,1,6,6,4,4,0,0,0,0,7,7,2,2,1,1,3,3,7,7,6,6,4,4,2,2,7,7,1,1,5,5,2,2,4,4,6,6,5,5,7,7,3,3,0,0,1,1,2,2,1,1,1,1,0,0,1,1,5,5,4,4,3,3,2,2,7,7,7,7,5,5,4,4,4,4,5,5,0,0,4,4,5,5,7,7,7,7,3,3,7,7,7,7,3,3,2,2,2,2,4,4,4,4,3,3,1,1,1,1,7,7,7,7,2,2,4,4,3,3,1,1,4,4,6,6,2,2,1,1,1,1,6,6,6,6,0,0,4,4,7,7,4,4,0,0,4,4,0,0,4,4,4,4,4,4,2,2,0,0,7,7,0,0,5,5,5,5,0,0,3,3,0,0,7,7,2,2,2,2,7,7,0,0,5,5,0,0,7,7,1,1,2,2,1,1,1,1,2,2,6,6,2,2,0,0,4,4,0,0,1,1,7,7,6,6,7,7,4,4,2,2,2,2,2,2,1,1,1,1,7,7,0,0,2,2,6,6,6,6,5,5,2,2,7,7,3,3,3,3,0,0,2,2,7,7,3,3,2,2,6,6,4,4,1,1,0,0,3,3,7,7,6,6,1,1,1,1,5,5,6,6,6,6,3,3,1,1,4,4,4,4,1,1,3,3,2,2,1,1,3,3,3,3,6,6,6,6,5,5,2,2,2,2,2,2,3,3,6,6,3,3,1,1,5,5,6,6,4,4,2,2,4,4,7,7,6,6,3,3,2,2,4,4,4,4,5,5,3,3,2,2,2,2,0,0,0,0,2,2,4,4,4,4,3,3,1,1,1,1,2,2,2,2,0,0,3,3,3,3,4,4,7,7,2,2,4,4,7,7,0,0,2,2,5,5,4,4,2,2,1,1,6,6,3,3,3,3,7,7,4,4,1,1,3,3,5,5,0,0,7,7,2,2,2,2,5,5,0,0,0,0,2,2,0,0,1,1,7,7,5,5,0,0,0,0,0,0,0,0,0,0,3,3,5,5,4,4,0,0,5,5,6,6,1,1,1,1,4,4,2,2,5,5,4,4,7,7,6,6,7,7,0,0,0,0,5,5,4,4,7,7,2,2,0,0,2,2,7,7,2,2,7,7,0,0,3,3,2,2,7,7,3,3,7,7,5,5,6,6,2,2,6,6,2,2,4,4,3,3,2,2,6,6,1,1,4,4,6,6,0,0,1,1,1,1,2,2,4,4,3,3,4,4,7,7,0,0,6,6,5,5,5,5,2,2,1,1,5,5,1,1,4,4,6,6,0,0,3,3,0,0,5,5,2,2,5,5,5,5,2,2,2,2,7,7,0,0,0,0,1,1,0,0,5,5,0,0,3,3,2,2,4,4,2,2,1,1,3,3,0,0,6,6,2,2,6,6,2,2,3,3,6,6,7,7,2,2,4,4,7,7,5,5,7,7,4,4,4,4,5,5,6,6,3,3,3,3,4,4,0,0,6,6,2,2,6,6,0,0,5,5,0,0,0,0,5,5,6,6,3,3,4,4,2,2,1,1,3,3,3,3,7,7,3,3,5,5,2,2,2,2,5,5,0,0,3,3,0,0,4,4,0,0,3,3,4,4,4,4,1,1,5,5,1,1,5,5,5,5,2,2,0,0,6,6,4,4,1,1,6,6,0,0,2,2,3,3,3,3,2,2,6,6,0,0,0,0,2,2,3,3,5,5,0,0,3,3,1,1,0,0,0,0,7,7,2,2,7,7,7,7,4,4,2,2,3,3,1,1,7,7,6,6,5,5,6,6,6,6,7,7,6,6,1,1,4,4,0,0,7,7,4,4,6,6,2,2,6,6,1,1,2,2,0,0,6,6,0,0,1,1,3,3,3,3,5,5,7,7,0,0,2,2,6,6,1,1,6,6,5,5,7,7,4,4,7,7,2,2,1,1,4,4,1,1,3,3,0,0,2,2,0,0,5,5,3,3,2,2,4,4,5,5,3,3,5,5,7,7,7,7,6,6,7,7,4,4,4,4,6,6,2,2,4,4,0,0,4,4,4,4,2,2,2,2,4,4,6,6,3,3,1,1,4,4,5,5,6,6,1,1,4,4,6,6,0,0,2,2,6,6,2,2,0,0,6,6,1,1,2,2,6,6,5,5,6,6,1,1,1,1,6,6,4,4,3,3,5,5,4,4,7,7,6,6,6,6,4,4,1,1,6,6,3,3,0,0,6,6,1,1,6,6,2,2,4,4,7,7,4,4,6,6,0,0,2,2,4,4,3,3,6,6,4,4,2,2,0,0,1,1,0,0,3,3,6,6,2,2,3,3,2,2,5,5,5,5,2,2,3,3,5,5,3,3,4,4,0,0,5,5,1,1,7,7,4,4,6,6,5,5,2,2,2,2,1,1,4,4,7,7,4,4,5,5,0,0,6,6,4,4,5,5,7,7,2,2,1,1,7,7,0,0,3,3,4,4,7,7,3,3,4,4,4,4,0,0,6,6,5,5,4,4,0,0,6,6,1,1,0,0,0,0,1,1,6,6,2,2,6,6,4,4,4,4,5,5,0,0,1,1,0,0,6,6,3,3,4,4,4,4,5,5,5,5,1,1,5,5,5,5,2,2,0,0,2,2,1,1,7,7,2,2,2,2,1,1,3,3,2,2,7,7,4,4,7,7,6,6,2,2,3,3,7,7,0,0,2,2,3,3,1,1,5,5,0,0,6,6,4,4,7,7,3,3,2,2,7,7,2,2,3,3,4,4,6,6,5,5,2,2,6,6,3,3,5,5,4,4,5,5,2,2,1,1,2,2,0,0,5,5,4,4,5,5,5,5,3,3,2,2,4,4,7,7,4,4,4,4,3,3,1,1,4,4,2,2,7,7,0,0,2,2,7,7,4,4,6,6,0,0,1,1,4,4,4,4,3,3,0,0,0,0,5,5,4,4,3,3,1,1,3,3,3,3,5,5,6,6,7,7,7,7,2,2,1,1,1,1,0,0,7,7,5,5,3,3,0,0,0,0,5,5,6,6,4,4,0,0,6,6,2,2,6,6,2,2,4,4,4,4,3,3,5,5,3,3,6,6,7,7,4,4,3,3,6,6,7,7,3,3,0,0,5,5,2,2,7,7,4,4,6,6,7,7,0,0,2,2,1,1,6,6,1,1,3,3,4,4,0,0,2,2,6,6,2,2,3,3,2,2,5,5,6,6,5,5,2,2,3,3,2,2,0,0,4,4,6,6,5,5,4,4,6,6,5,5,4,4,7,7,6,6,6,6,5,5,6,6,2,2,4,4,6,6,1,1,6,6,5,5,1,1,0,0,0,0,3,3,4,4,2,2,2,2,6,6,7,7,6,6,0,0,2,2,5,5,6,6,7,7,1,1,5,5,6,6,7,7,1,1,4,4,4,4,0,0,7,7,3,3,0,0,3,3,6,6,5,5,6,6,6,6,4,4,2,2,1,1,0,0,6,6,5,5,4,4,6,6,1,1,7,7,5,5,2,2,4,4,1,1,1,1,0,0,3,3,7,7,1,1,1,1,5,5,4,4,3,3,0,0,3,3,0,0,6,6,0,0,2,2,2,2,0,0,6,6,6,6,5,5,1,1,1,1,0,0,3,3,1,1,6,6,6,6,3,3,0,0,1,1,4,4,2,2,2,2,2,2,1,1,2,2,7,7,2,2,1,1,3,3,3,3,0,0,4,4,6,6,0,0,0,0,6,6,1,1,0,0,0,0,7,7,5,5,3,3,3,3,6,6,4,4,0,0,5,5,4,4,4,4,5,5,0,0,6,6,3,3,7,7,7,7,7,7,5,5,6,6,0,0,4,4,0,0,4,4,0,0,5,5,1,1,4,4,1,1,7,7,3,3,0,0,1,1,4,4,7,7,2,2,7,7,4,4,1,1,0,0,2,2,7,7,5,5,1,1,0,0,3,3,7,7,6,6,1,1,0,0,2,2,1,1,5,5,7,7,0,0,2,2,7,7,1,1,3,3,7,7,4,4,2,2,0,0,5,5,7,7,3,3,4,4,4,4,1,1,7,7,0,0,2,2,2,2,4,4,1,1,1,1,0,0,2,2,5,5,4,4,5,5,7,7,4,4,3,3,7,7,1,1,5,5,2,2,4,4,1,1,4,4,6,6,0,0,2,2,1,1,7,7,3,3,1,1,0,0,7,7,7,7,0,0,1,1,6,6,3,3,2,2,2,2,5,5,1,1,0,0,5,5,7,7,1,1,0,0,4,4,3,3,4,4,6,6,4,4,1,1,7,7,3,3,2,2,6,6,0,0,6,6,4,4,0,0,6,6,0,0,1,1,2,2,5,5,4,4,4,4,4,4,1,1,5,5,2,2,7,7,5,5,4,4,5,5,4,4,5,5,6,6,4,4,5,5,1,1,0,0,7,7,5,5,2,2,4,4,6,6,4,4,2,2,4,4,2,2,7,7,4,4,6,6,7,7,7,7,4,4,7,7,5,5,0,0,4,4,4,4,6,6,6,6,2,2,6,6,1,1,1,1,5,5,7,7,2,2,4,4,0,0,4,4,4,4,6,6,4,4,3,3,1,1,0,0,5,5,4,4,7,7,4,4,0,0,3,3,7,7,1,1,2,2,0,0,4,4,3,3,1,1,1,1,5,5,2,2,5,5,5,5,4,4,4,4,4,4,6,6,3,3,4,4,6,6,0,0,1,1,1,1,5,5,3,3,7,7,1,1,2,2,7,7,3,3,7,7,5,5,6,6,5,5,0,0,2,2,2,2,2,2,4,4,2,2,7,7,4,4,0,0,0,0,1,1,6,6,4,4,6,6,6,6,0,0,0,0,7,7,3,3,5,5,2,2,3,3,7,7,6,6,5,5,1,1,0,0,7,7,0,0,6,6,3,3,0,0,7,7,4,4,0,0,0,0,4,4,4,4,5,5,0,0,4,4,2,2,3,3,4,4,1,1,6,6,6,6,3,3,3,3,1,1,2,2,7,7,7,7,3,3,2,2,4,4,2,2,1,1,4,4,7,7,5,5,1,1,6,6,2,2,2,2,2,2,0,0,0,0,6,6,2,2,5,5,2,2,2,2,3,3,6,6,7,7,5,5,3,3,7,7,5,5,6,6,3,3,3,3,3,3,5,5,5,5,3,3,4,4,5,5,6,6,6,6,5,5,4,4,4,4,1,1,6,6,4,4,2,2,4,4,1,1,7,7,7,7,6,6,4,4,7,7,4,4,1,1,5,5,2,2,4,4,6,6,4,4,5,5,3,3,3,3,4,4,5,5,7,7,2,2,7,7,6,6,4,4,1,1,1,1,6,6,4,4,3,3,3,3,0,0,3,3,6,6,7,7,6,6,3,3,1,1,3,3,4,4,0,0,1,1,6,6,5,5,5,5,6,6,2,2,0,0,4,4,5,5,7,7,1,1,6,6,6,6,7,7,5,5,1,1,1,1,5,5,0,0,2,2,0,0,0,0,4,4,5,5,0,0,3,3,2,2,5,5,0,0,4,4,5,5,0,0,3,3,6,6,4,4,6,6,0,0,4,4,5,5,7,7,1,1,0,0,0,0,4,4,5,5,1,1,5,5,7,7,0,0,0,0,7,7,5,5,4,4,7,7,5,5,7,7,5,5,7,7,1,1,0,0,3,3,3,3,5,5,5,5,1,1,4,4,7,7,7,7,1,1,7,7,6,6,5,5,0,0,6,6,3,3,0,0,6,6,6,6,0,0,0,0,2,2,0,0,5,5,0,0,0,0,5,5,6,6,5,5,5,5,5,5,3,3,3,3,3,3,1,1,5,5,0,0,1,1,5,5,0,0,4,4,5,5,0,0,4,4,4,4,0,0,3,3,4,4,6,6,5,5,0,0,1,1,1,1,3,3,1,1,1,1,7,7,1,1,4,4,2,2,0,0,6,6,1,1,0,0,1,1,1,1,3,3,2,2,5,5,0,0,2,2,4,4,3,3,4,4,6,6,7,7,0,0,3,3,7,7,1,1,0,0,4,4,6,6,0,0,2,2,3,3,0,0,0,0,4,4,1,1,4,4,6,6,4,4,5,5,0,0,4,4,7,7,6,6,1,1,6,6,0,0,4,4,0,0,0,0,5,5,1,1,7,7,7,7,6,6,1,1,2,2,2,2,4,4,2,2,0,0,3,3,2,2,1,1,5,5,6,6,1,1,0,0,2,2,5,5,0,0,3,3,2,2,3,3,4,4,4,4,0,0,3,3,0,0,5,5,1,1,3,3,7,7,5,5,4,4,1,1,7,7,3,3,5,5,1,1,6,6,4,4,6,6,1,1,6,6,2,2,6,6,1,1,3,3,5,5,6,6,6,6,2,2,5,5,2,2,5,5,3,3,0,0,3,3,1,1,5,5,4,4,7,7,7,7,3,3,4,4,0,0,5,5,1,1,0,0,3,3,3,3,5,5,5,5,1,1,3,3,6,6,1,1,1,1,4,4,7,7,1,1,0,0,3,3,2,2,5,5,3,3,1,1,2,2,7,7,0,0,5,5,6,6,1,1,4,4,2,2,4,4,2,2,2,2,0,0,3,3,2,2,6,6,7,7,6,6,4,4,4,4,0,0,2,2,1,1,6,6,0,0,5,5,1,1,6,6,7,7,1,1,5,5,6,6,3,3,4,4,1,1,6,6,4,4,3,3,2,2,1,1,5,5,1,1,0,0,0,0,3,3,3,3,2,2,2,2,1,1,7,7,3,3,1,1,6,6,3,3,0,0,2,2,0,0,7,7,3,3,6,6,5,5,4,4,5,5,2,2,5,5,2,2,0,0,5,5,5,5,5,5,0,0,7,7,6,6,0,0,3,3,5,5,7,7,0,0,5,5,7,7,0,0,7,7,3,3,2,2,1,1,1,1,4,4,5,5,5,5,5,5,0,0,4,4,0,0,4,4};

float samplerBlueNoiseErrorDistribution_128x128_OptimizedFor_2d2d2d2d_8spp(int pixel_i, int pixel_j, int sampleIndex, int sampleDimension)
{
	// wrap arguments
	pixel_i = pixel_i & 127;
	pixel_j = pixel_j & 127;
	sampleIndex = sampleIndex & 255;
	sampleDimension = sampleDimension & 255;

	// xor index based on optimized ranking
	int rankedSampleIndex = sampleIndex ^ rankingTile[sampleDimension + (pixel_i + pixel_j*128)*8];

	// fetch value in sequence
	int value = sobol_256spp_256d[sampleDimension + rankedSampleIndex*256];

	// If the dimension is optimized, xor sequence value based on optimized scrambling
	value = value ^ scramblingTile[(sampleDimension%8) + (pixel_i + pixel_j*128)*8];

	// convert to float and return
	float v = (0.5f+value)/256.0f;
	return v;
}
