// This file is part of the FidelityFX SDK.
//
// Copyright (C) 2024 Advanced Micro Devices, Inc.
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files(the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and /or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions :
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#ifndef FFX_CLASSIFIER_RESOURCES_H
#define FFX_CLASSIFIER_RESOURCES_H

#if defined(FFX_CPU) || defined(FFX_GPU)
#define FFX_CLASSIFIER_RESOURCE_IDENTIFIER_NULL                      0
#define FFX_CLASSIFIER_RESOURCE_IDENTIFIER_INPUT_DEPTH               1
#define FFX_CLASSIFIER_RESOURCE_IDENTIFIER_INPUT_NORMAL              2
#define FFX_CLASSIFIER_RESOURCE_IDENTIFIER_WORK_QUEUE                3
#define FFX_CLASSIFIER_RESOURCE_IDENTIFIER_OUTPUT_WORK_QUEUE_COUNTER 4
#define FFX_CLASSIFIER_RESOURCE_IDENTIFIER_OUTPUT_RAY_HIT            5
#define FFX_CLASSIFIER_RESOURCE_IDENTIFIER_INPUT_SHADOW_MAPS         7
#define FFX_CLASSIFIER_RESOURCE_IDENTIFIER_INPUT_MOTION_VECTORS      8
#define FFX_CLASSIFIER_RESOURCE_IDENTIFIER_INPUT_SPECULAR_ROUGHNESS  9
#define FFX_CLASSIFIER_RESOURCE_IDENTIFIER_INPUT_ENVIRONMENT_MAP     10
#define FFX_CLASSIFIER_RESOURCE_IDENTIFIER_VARIANCE_HISTORY          11
#define FFX_CLASSIFIER_RESOURCE_IDENTIFIER_HIT_COUNTER_HISTORY       12
#define FFX_CLASSIFIER_RESOURCE_IDENTIFIER_HIT_COUNTER               13
#define FFX_CLASSIFIER_RESOURCE_IDENTIFIER_RAY_LIST                  14
#define FFX_CLASSIFIER_RESOURCE_IDENTIFIER_HW_RAY_LIST               15
#define FFX_CLASSIFIER_RESOURCE_IDENTIFIER_EXTRACTED_ROUGHNESS       16
#define FFX_CLASSIFIER_RESOURCE_IDENTIFIER_RAY_COUNTER               17
#define FFX_CLASSIFIER_RESOURCE_IDENTIFIER_DENOISER_TILE_LIST        18
#define FFX_CLASSIFIER_RESOURCE_IDENTIFIER_DEBUG_IMAGE               19
#define FFX_CLASSIFIER_RESOURCE_IDENTIFIER_RADIANCE                  20

#define FFX_CLASSIFIER_RESOURCE_IDENTIFIER_COUNT                     25 // 21 + FFX_CLASSIFIER_MAX_SHADOW_MAP_TEXTURES_COUNT
#if defined(FFX_CLASSIFIER_MAX_SHADOW_MAP_TEXTURES_COUNT)
static_assert(FFX_CLASSIFIER_MAX_SHADOW_MAP_TEXTURES_COUNT == 4,
              "This count represents 21 + FFX_CLASSIFIER_MAX_SHADOW_MAP_TEXTURES_COUNT. This assert monitors if MAX_SHADOW_MAP_TEXTURES_COUNT has changed");
#endif // #if defined(FFX_CLASSIFIER_MAX_SHADOW_MAP_TEXTURES_COUNT)

#define FFX_CLASSIFIER_CONSTANTBUFFER_IDENTIFIER_CLASSIFIER  0
#define FFX_CLASSIFIER_CONSTANTBUFFER_IDENTIFIER_REFLECTION  1

#endif // #if defined(FFX_CPU) || defined(FFX_GPU)

#endif //!defined( FFX_CLASSIFIER_RESOURCES_H )
